<?php
/**
 * Campaigns API Endpoint
 * Handles email campaign operations
 */

require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/functions.php';

header('Content-Type: text/html; charset=utf-8');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = $_POST['name'] ?? '';
    $subject = $_POST['subject'] ?? '';
    $recipients = $_POST['recipients'] ?? '';
    $content = $_POST['content'] ?? '';

    // Validate
    if (empty($name) || empty($subject) || empty($recipients) || empty($content)) {
        header('HX-Trigger: ' . json_encode([
            'showMessage' => [
                'message' => 'Please fill in all required fields.',
                'status' => 'danger'
            ]
        ]));
        exit;
    }

    // In production, save campaign to database
    sleep(1);

    header('HX-Trigger: ' . json_encode([
        'showMessage' => [
            'message' => 'Campaign "' . e($name) . '" created successfully!',
            'status' => 'success'
        ]
    ]));

    // Return updated campaign list or redirect
    header('HX-Redirect: ' . BASE_URL . '/mailing.php');
}
