<?php
/**
 * Maintenance API Endpoint
 * Handles system maintenance operations
 */

require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/functions.php';

header('Content-Type: text/html; charset=utf-8');

$action = $_GET['action'] ?? '';

switch ($action) {
    case 'backup':
        // Simulate backup operation
        sleep(2);

        header('HX-Trigger: ' . json_encode([
            'showMessage' => [
                'message' => 'Database backup completed successfully!',
                'status' => 'success'
            ]
        ]));
        break;

    case 'cache':
        // Simulate cache clearing
        sleep(1);

        header('HX-Trigger: ' . json_encode([
            'showMessage' => [
                'message' => 'System cache cleared successfully!',
                'status' => 'success'
            ]
        ]));
        break;

    case 'report':
        // Generate system report
        $report_date = date('Y-m-d_H-i-s');

        echo '<div class="uk-alert uk-alert-success uk-margin-small-top">
                <span uk-icon="icon: check"></span>
                Report generated: <a href="#" class="uk-link">system_report_' . $report_date . '.pdf</a>
              </div>';

        header('HX-Trigger: ' . json_encode([
            'showMessage' => [
                'message' => 'System report generated successfully!',
                'status' => 'success'
            ]
        ]));
        break;

    default:
        http_response_code(400);
        echo '<div class="uk-alert uk-alert-danger">Invalid action</div>';
}
