<?php
/**
 * Settings API Endpoint
 * Handles system and email configuration updates
 */

require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/functions.php';

header('Content-Type: text/html; charset=utf-8');

$type = $_GET['type'] ?? 'system';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Simulate saving settings
    sleep(1); // Simulate processing time

    $success = true; // In production, validate and save

    if ($success) {
        header('HX-Trigger: ' . json_encode([
            'showMessage' => [
                'message' => ucfirst($type) . ' settings saved successfully!',
                'status' => 'success'
            ]
        ]));

        echo '<div class="uk-alert uk-alert-success uk-margin-small" _="on load wait 3s then remove me">
                <span uk-icon="icon: check"></span> Settings saved successfully!
              </div>';
    } else {
        header('HX-Trigger: ' . json_encode([
            'showMessage' => [
                'message' => 'Failed to save settings. Please try again.',
                'status' => 'danger'
            ]
        ]));

        echo '<div class="uk-alert uk-alert-danger uk-margin-small">
                <span uk-icon="icon: warning"></span> Error saving settings.
              </div>';
    }
}
