<?php
/**
 * Admin Dashboard - Applications Page
 */

require_once __DIR__ . '/includes/bootstrap.php';

$page_title = 'Admin Dashboard';
$page_description = 'Manage users, monitor system performance, and generate reports.';
$active_tab = 'applications';

ob_start();

// Mock application stats
$app_stats = [
    ['icon' => 'file-text', 'value' => '1,234', 'label' => 'Active Applications', 'color' => 'primary'],
    ['icon' => 'check', 'value' => '892', 'label' => 'Accepted', 'color' => 'success'],
    ['icon' => 'clock', 'value' => '456', 'label' => 'Under Review', 'color' => 'warning'],
    ['icon' => 'warning', 'value' => '67', 'label' => 'Needs Attention', 'color' => 'danger']
];

// Status distribution
$status_distribution = [
    ['label' => 'Submitted', 'value' => 245, 'percentage' => 35, 'color' => 'primary', 'suffix' => 'applications'],
    ['label' => 'Under Review', 'value' => 189, 'percentage' => 27, 'color' => 'warning', 'suffix' => 'applications'],
    ['label' => 'Interview Scheduled', 'value' => 134, 'percentage' => 19, 'color' => 'cyan', 'suffix' => 'applications'],
    ['label' => 'Accepted', 'value' => 98, 'percentage' => 14, 'color' => 'success', 'suffix' => 'applications'],
    ['label' => 'Rejected', 'value' => 34, 'percentage' => 5, 'color' => 'danger', 'suffix' => 'applications']
];

// Recent applications
$recent_applications = [
    ['student' => 'John Doe', 'university' => 'Stanford University', 'program' => 'Computer Science (MS)', 'submitted' => '2024-01-30', 'status' => 'under_review'],
    ['student' => 'Sarah Chen', 'university' => 'MIT', 'program' => 'Engineering (MS)', 'submitted' => '2024-01-29', 'status' => 'interview_scheduled'],
    ['student' => 'Michael Rodriguez', 'university' => 'Harvard University', 'program' => 'Business Administration (MBA)', 'submitted' => '2024-01-28', 'status' => 'accepted'],
    ['student' => 'Emma Wilson', 'university' => 'University of Cambridge', 'program' => 'Economics (PhD)', 'submitted' => '2024-01-27', 'status' => 'submitted']
];
?>

<!-- Page Header with Actions -->
<div class="uk-flex uk-flex-between uk-flex-middle uk-margin-bottom">
    <h3 class="uk-margin-remove">Application Management</h3>
    <div>
        <button class="uk-button uk-button-default uk-button-small uk-margin-small-right">
            <span uk-icon="icon: download; ratio: 0.8"></span> Export Data
        </button>
        <button class="uk-button uk-button-default uk-button-small">
            <span uk-icon="icon: settings; ratio: 0.8"></span> Advanced Filters
        </button>
    </div>
</div>

<!-- Stats -->
<?php render_stat_cards($app_stats); ?>

<!-- Status Distribution -->
<div class="uk-card uk-card-default uk-card-body uk-margin-bottom">
    <h4 class="uk-card-title">Application Status Distribution</h4>
    <?php foreach ($status_distribution as $item): ?>
        <?php render_progress_bar($item); ?>
    <?php endforeach; ?>
</div>

<!-- Recent Applications -->
<div class="uk-card uk-card-default uk-card-body">
    <h4 class="uk-card-title">Recent Applications</h4>
    <?php foreach ($recent_applications as $app): ?>
        <div class="uk-card uk-card-default uk-card-body uk-card-small uk-margin-small-bottom">
            <div class="uk-flex uk-flex-between uk-flex-middle">
                <div>
                    <div class="uk-text-bold"><?= e($app['student']) ?></div>
                    <div class="uk-text-muted uk-text-small">
                        <?= e($app['university']) ?> - <?= e($app['program']) ?>
                    </div>
                    <div class="uk-text-meta uk-text-small">Submitted: <?= e($app['submitted']) ?></div>
                </div>
                <?= get_status_badge($app['status']) ?>
            </div>
        </div>
    <?php endforeach; ?>
</div>

<?php
$content = ob_get_clean();
include __DIR__ . '/includes/layout.php';
?>
