<?php
/**
 * Activity Feed Component
 * Display recent activities with icons and timestamps
 *
 * Usage:
 * render_activity_feed([
 *     [
 *         'icon' => 'user',
 *         'title' => 'New student registered',
 *         'user' => 'John Doe',
 *         'time' => '2 minutes ago'
 *     ]
 * ]);
 */

function render_activity_item($activity) {
    $icon = $activity['icon'] ?? 'info';
    $title = $activity['title'] ?? '';
    $user = $activity['user'] ?? '';
    $time = $activity['time'] ?? '';
    $color = $activity['color'] ?? 'muted';
    ?>
    <div class="uk-flex uk-margin-small-bottom">
        <div class="uk-border-circle uk-flex uk-flex-center uk-flex-middle uk-margin-right"
             style="width: 36px; height: 36px; min-width: 36px; <?= get_stat_icon_style($color) ?>">
            <span uk-icon="icon: <?= $icon ?>; ratio: 0.8"></span>
        </div>
        <div>
            <div class="uk-text-bold uk-text-small"><?= e($title) ?></div>
            <div class="uk-text-muted uk-text-small">
                <?php if ($user): ?>by <?= e($user) ?> &middot; <?php endif; ?>
                <?= e($time) ?>
            </div>
        </div>
    </div>
    <?php
}

function render_activity_feed($activities, $title = 'Recent Activities') {
    ?>
    <div class="uk-card uk-card-default uk-card-body">
        <h4 class="uk-card-title"><?= e($title) ?></h4>
        <?php foreach ($activities as $activity): ?>
            <?php render_activity_item($activity); ?>
        <?php endforeach; ?>
    </div>
    <?php
}
