<?php
/**
 * Header Component
 * Main navigation header with modern design and mobile support
 */
?>
<style>
.modern-navbar {
    background: white;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    position: sticky;
    top: 0;
    z-index: 980;
}

.navbar-content {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 12px 20px;
    max-width: 1600px;
    margin: 0 auto;
}

.navbar-logo {
    display: flex;
    align-items: center;
    gap: 12px;
    text-decoration: none;
    color: #1a1a1a;
}

.logo-circle {
    width: 36px;
    height: 36px;
    border-radius: 50%;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 14px;
    font-weight: 600;
}

.logo-text {
    font-size: 18px;
    font-weight: 700;
}

.navbar-center {
    flex: 1;
    display: flex;
    justify-content: center;
}

.navbar-nav {
    display: flex;
    list-style: none;
    margin: 0;
    padding: 0;
    gap: 8px;
}

.nav-item {
    position: relative;
}

.nav-link {
    display: flex;
    align-items: center;
    gap: 8px;
    padding: 8px 16px;
    border-radius: 8px;
    text-decoration: none;
    color: #64748b;
    font-size: 14px;
    font-weight: 500;
    transition: all 0.2s ease;
}

.nav-link:hover {
    background: #f1f5f9;
    color: #667eea;
}

.nav-link.active {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
}

.navbar-right {
    display: flex;
    align-items: center;
    gap: 12px;
}

.nav-icon-btn {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: all 0.2s ease;
    color: #64748b;
    position: relative;
}

.nav-icon-btn:hover {
    background: #f1f5f9;
    color: #667eea;
}

.notification-badge {
    position: absolute;
    top: 6px;
    right: 6px;
    width: 18px;
    height: 18px;
    border-radius: 50%;
    background: #f0506e;
    color: white;
    font-size: 10px;
    font-weight: 600;
    display: flex;
    align-items: center;
    justify-content: center;
}

.profile-avatar {
    width: 36px;
    height: 36px;
    border-radius: 50%;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 600;
    font-size: 14px;
}

/* Bottom Mobile Navigation */
.mobile-bottom-nav {
    display: none;
    position: fixed;
    bottom: 0;
    left: 0;
    right: 0;
    background: white;
    box-shadow: 0 -2px 12px rgba(0, 0, 0, 0.1);
    z-index: 1000;
    padding: 8px 0 calc(8px + env(safe-area-inset-bottom));
}

.mobile-nav-items {
    display: flex;
    justify-content: space-around;
    align-items: center;
    max-width: 100%;
    margin: 0 auto;
    padding: 0;
    list-style: none;
}

.mobile-nav-item {
    flex: 1;
    display: flex;
    justify-content: center;
}

.mobile-nav-link {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 4px;
    padding: 8px 12px;
    text-decoration: none;
    color: #64748b;
    font-size: 11px;
    font-weight: 500;
    transition: all 0.2s ease;
    border-radius: 8px;
    min-width: 60px;
}

.mobile-nav-link:hover {
    background: #f1f5f9;
    color: #667eea;
}

.mobile-nav-link.active {
    color: #667eea;
}

.mobile-nav-icon {
    font-size: 20px;
    transition: all 0.2s ease;
}

.mobile-nav-link.active .mobile-nav-icon {
    color: #667eea;
    transform: scale(1.1);
}

.mobile-nav-label {
    font-size: 10px;
    white-space: nowrap;
}

@media (max-width: 959px) {
    .navbar-center {
        display: none;
    }

    .mobile-bottom-nav {
        display: block;
    }

    /* Add padding to body to prevent content from being hidden behind bottom nav */
    body {
        padding-bottom: 70px;
    }
}

@media (max-width: 640px) {
    .logo-text {
        display: none;
    }

    .mobile-nav-label {
        display: none;
    }
}
</style>

<header class="modern-navbar">
    <div class="navbar-content">
        <!-- Logo -->
        <a href="<?= BASE_URL ?>" class="navbar-logo">
            <div class="logo-circle">AP</div>
            <span class="logo-text"><?= APP_NAME ?></span>
        </a>

        <!-- Center Navigation (Desktop) -->
        <div class="navbar-center uk-visible@m">
            <ul class="navbar-nav">
                <?php foreach ($GLOBALS['admin_nav'] as $key => $item): ?>
                <li class="nav-item">
                    <a href="<?= BASE_URL ?>/<?= $key === 'overview' ? 'index' : $key ?>.php"
                       class="nav-link <?= ($active_tab ?? 'overview') === $key ? 'active' : '' ?>"
                       hx-get="<?= BASE_URL ?>/pages/<?= $key ?>.php"
                       hx-target="#main-content"
                       hx-swap="innerHTML"
                       hx-push-url="<?= BASE_URL ?>/<?= $key === 'overview' ? 'index' : $key ?>.php">
                        <i class="fa-slab fa-solid fa-<?= $item['icon'] ?> fa-sm"></i>
                        <span class="uk-visible@l"><?= e($item['label']) ?></span>
                    </a>
                </li>
                <?php endforeach; ?>
            </ul>
        </div>

        <!-- Right Side Icons -->
        <div class="navbar-right">
            <!-- Notifications -->
            <div class="nav-icon-btn uk-visible@m">
                <i class="fa-slab fa-solid fa-bell"></i>
                <span class="notification-badge">3</span>
                <div uk-dropdown="mode: click; pos: bottom-right">
                    <div style="width: 320px; padding: 16px;">
                        <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 16px;">
                            <span style="font-weight: 600; color: #1a1a1a;">Notifications</span>
                            <a href="#" style="font-size: 12px; color: #667eea;">Mark all read</a>
                        </div>
                        <div style="display: flex; flex-direction: column; gap: 12px;">
                            <div style="padding: 12px; background: #f8fafc; border-radius: 8px;">
                                <div style="font-weight: 600; font-size: 13px; color: #1a1a1a;">New application submitted</div>
                                <div style="font-size: 12px; color: #64748b; margin-top: 4px;">John Doe - Stanford University</div>
                                <div style="font-size: 11px; color: #94a3b8; margin-top: 4px;">2 minutes ago</div>
                            </div>
                            <div style="padding: 12px; background: #f8fafc; border-radius: 8px;">
                                <div style="font-weight: 600; font-size: 13px; color: #1a1a1a;">Payment received</div>
                                <div style="font-size: 12px; color: #64748b; margin-top: 4px;">$5,000 from Sarah Chen</div>
                                <div style="font-size: 11px; color: #94a3b8; margin-top: 4px;">1 hour ago</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Settings -->
            <div class="nav-icon-btn uk-visible@m">
                <i class="fa-slab fa-solid fa-cog"></i>
                <div uk-dropdown="mode: click; pos: bottom-right">
                    <ul class="uk-nav uk-dropdown-nav" style="min-width: 200px;">
                        <li class="uk-nav-header">Settings</li>
                        <li><a href="#"><i class="fa-slab fa-solid fa-cog fa-fw"></i> General</a></li>
                        <li><a href="#"><i class="fa-slab fa-solid fa-lock fa-fw"></i> Security</a></li>
                        <li><a href="#"><i class="fa-slab fa-solid fa-bell fa-fw"></i> Notifications</a></li>
                        <li class="uk-nav-divider"></li>
                        <li><a href="#"><i class="fa-slab fa-solid fa-question-circle fa-fw"></i> Help & Support</a></li>
                        <li class="uk-nav-divider"></li>
                        <li><a href="#" onclick="toggleDarkMode(); return false;"><i class="fa-slab fa-solid fa-moon fa-fw"></i> <span id="theme-toggle-text">Dark Mode</span></a></li>
                    </ul>
                </div>
            </div>

            <!-- Profile -->
            <div class="nav-icon-btn">
                <div class="profile-avatar"><?= $GLOBALS['current_user']['initials'] ?></div>
                <div uk-dropdown="mode: click; pos: bottom-right">
                    <div style="padding: 16px; border-bottom: 1px solid #e2e8f0;">
                        <div style="font-weight: 600; color: #1a1a1a;"><?= e($GLOBALS['current_user']['name']) ?></div>
                        <div style="font-size: 12px; color: #64748b; margin-top: 4px;"><?= $GLOBALS['role_names'][$GLOBALS['current_user']['role']] ?></div>
                    </div>
                    <ul class="uk-nav uk-dropdown-nav" style="min-width: 200px;">
                        <li class="uk-nav-header">Account</li>
                        <li><a href="<?= BASE_URL ?>/profile.php"><i class="fa-slab fa-solid fa-user fa-fw"></i> My Profile</a></li>
                        <li><a href="#"><i class="fa-slab fa-solid fa-image fa-fw"></i> Change Avatar</a></li>
                        <li><a href="#"><i class="fa-slab fa-solid fa-lock fa-fw"></i> Change Password</a></li>
                        <li class="uk-nav-divider"></li>
                        <li><a href="#"><i class="fa-slab fa-solid fa-history fa-fw"></i> Activity Log</a></li>
                        <li><a href="#"><i class="fa-slab fa-solid fa-laptop fa-fw"></i> Active Sessions</a></li>
                        <li class="uk-nav-divider"></li>
                        <li><a href="/auth/login.php" style="color: #f0506e;"><i class="fa-slab fa-solid fa-sign-out-alt fa-fw"></i> Sign Out</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</header>

<!-- Bottom Mobile Navigation -->
<nav class="mobile-bottom-nav uk-hidden@m">
    <ul class="mobile-nav-items">
        <?php foreach ($GLOBALS['admin_nav'] as $key => $item): ?>
        <li class="mobile-nav-item">
            <a href="<?= BASE_URL ?>/<?= $key === 'overview' ? 'index' : $key ?>.php"
               class="mobile-nav-link <?= ($active_tab ?? 'overview') === $key ? 'active' : '' ?>"
               hx-get="<?= BASE_URL ?>/pages/<?= $key ?>.php"
               hx-target="#main-content"
               hx-swap="innerHTML"
               hx-push-url="<?= BASE_URL ?>/<?= $key === 'overview' ? 'index' : $key ?>.php">
                <i class="fa-slab fa-solid fa-<?= $item['icon'] ?> mobile-nav-icon"></i>
                <span class="mobile-nav-label"><?= e($item['label']) ?></span>
            </a>
        </li>
        <?php endforeach; ?>
    </ul>
</nav>

<script>
// Update active state on HTMX navigation
document.body.addEventListener('htmx:afterSwap', function(event) {
    if (event.detail.target.id === 'main-content') {
        // Remove active class from all nav links
        document.querySelectorAll('.nav-link, .mobile-nav-link').forEach(function(link) {
            link.classList.remove('active');
        });

        // Add active class to the clicked link
        if (event.detail.requestConfig && event.detail.requestConfig.elt) {
            event.detail.requestConfig.elt.classList.add('active');
        }
    }
});
</script>
