<?php
/**
 * Progress Bar Component
 * Display labeled progress bars
 *
 * Usage:
 * render_progress_bar([
 *     'label' => 'United States',
 *     'value' => 456,
 *     'max' => 1000,
 *     'percentage' => 35.2,
 *     'suffix' => 'applications',
 *     'color' => 'primary'
 * ]);
 */

function render_progress_bar($config) {
    $label = $config['label'] ?? '';
    $value = $config['value'] ?? 0;
    $max = $config['max'] ?? 100;
    $percentage = $config['percentage'] ?? ($max > 0 ? ($value / $max) * 100 : 0);
    $suffix = $config['suffix'] ?? '';
    $color = $config['color'] ?? 'primary';

    $bar_width = min(100, $percentage);
    ?>
    <div class="uk-margin-small-bottom">
        <div class="uk-flex uk-flex-between uk-margin-small-bottom">
            <span class="uk-text-bold"><?= e($label) ?></span>
            <span class="uk-text-muted">
                <?= number_format($value) ?> <?= e($suffix) ?>
                <?php if ($percentage): ?>
                    (<?= number_format($percentage, 1) ?>%)
                <?php endif; ?>
            </span>
        </div>
        <progress class="uk-progress uk-progress-<?= $color ?>" value="<?= $bar_width ?>" max="100"></progress>
    </div>
    <?php
}

/**
 * Render multiple progress bars
 */
function render_progress_list($items, $title = null) {
    ?>
    <div class="uk-card uk-card-default uk-card-body">
        <?php if ($title): ?>
            <h4 class="uk-card-title"><?= e($title) ?></h4>
        <?php endif; ?>
        <?php foreach ($items as $item): ?>
            <?php render_progress_bar($item); ?>
        <?php endforeach; ?>
    </div>
    <?php
}
