<?php
/**
 * Stat Card Component
 * Display statistics with icon, value, label, and optional trend
 *
 * Usage:
 * render_stat_card([
 *     'icon' => 'users',
 *     'value' => '2,847',
 *     'label' => 'Total Users',
 *     'trend' => 12,
 *     'color' => 'primary'
 * ]);
 */

function render_stat_card($config) {
    $icon = $config['icon'] ?? 'star';
    $value = $config['value'] ?? '0';
    $label = $config['label'] ?? 'Label';
    $trend = $config['trend'] ?? null;
    $color = $config['color'] ?? 'primary';
    $suffix = $config['suffix'] ?? 'from last month';

    $icon_style = get_stat_icon_style($color);
    ?>
    <div class="uk-card uk-card-default uk-card-body uk-card-small">
        <div class="uk-flex uk-flex-middle">
            <div class="uk-border-rounded uk-flex uk-flex-center uk-flex-middle uk-margin-right"
                 style="width: 48px; height: 48px; <?= $icon_style ?>">
                <span uk-icon="icon: <?= $icon ?>; ratio: 1.2"></span>
            </div>
            <div>
                <div class="uk-text-large uk-text-bold"><?= e($value) ?></div>
                <div class="uk-text-muted uk-text-small"><?= e($label) ?></div>
                <?php if ($trend !== null): ?>
                    <div class="uk-text-small"><?= get_trend_indicator($trend, $suffix) ?></div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <?php
}

/**
 * Render a grid of stat cards
 */
function render_stat_cards($cards, $columns = 4) {
    $grid_class = "uk-child-width-1-{$columns}@m uk-child-width-1-2@s";
    ?>
    <div class="<?= $grid_class ?> uk-grid-small uk-margin-bottom" uk-grid>
        <?php foreach ($cards as $card): ?>
            <div><?php render_stat_card($card); ?></div>
        <?php endforeach; ?>
    </div>
    <?php
}
