<?php
/**
 * Tabs Component
 * Navigation tabs for dashboard sections
 *
 * @param string $active Current active tab
 */

$active = $active ?? 'overview';
?>

<ul class="uk-tab uk-margin-medium-bottom" uk-tab>
    <?php foreach ($GLOBALS['admin_nav'] as $key => $item): ?>
        <li class="<?= $active === $key ? 'uk-active' : '' ?>">
            <a href="<?= BASE_URL ?>/<?= $key === 'overview' ? 'index' : $key ?>.php"
               hx-get="<?= BASE_URL ?>/pages/<?= $key ?>.php"
               hx-target="#main-content"
               hx-swap="innerHTML"
               hx-push-url="<?= BASE_URL ?>/<?= $key === 'overview' ? 'index' : $key ?>.php">
                <?= e($item['label']) ?>
            </a>
        </li>
    <?php endforeach; ?>
</ul>
