<?php
/**
 * User List Item Component
 * Display user info in a list format
 *
 * Usage:
 * render_user_list_item([
 *     'id' => 1,
 *     'name' => 'John Doe',
 *     'email' => 'john@example.com',
 *     'role' => 'student',
 *     'status' => 'active',
 *     'joined' => '2024-01-15',
 *     'last_active' => '2024-01-30',
 *     'meta' => ['Applications' => 3, 'Spent' => '$45,000']
 * ]);
 */

function render_user_list_item($user) {
    $id = $user['id'] ?? 0;
    $name = $user['name'] ?? 'Unknown';
    $email = $user['email'] ?? '';
    $role = $user['role'] ?? 'student';
    $status = $user['status'] ?? 'active';
    $joined = $user['joined'] ?? '';
    $last_active = $user['last_active'] ?? '';
    $meta = $user['meta'] ?? [];

    $status_class = $status === 'active' ? 'uk-label-success' : 'uk-label-danger';
    ?>
    <div class="uk-card uk-card-default uk-card-body uk-card-small uk-margin-small-bottom"
         id="user-<?= $id ?>">
        <div class="uk-flex uk-flex-middle uk-flex-between">
            <div class="uk-flex uk-flex-middle">
                <?= get_avatar($name, 48) ?>
                <div class="uk-margin-left">
                    <div class="uk-flex uk-flex-middle uk-flex-wrap">
                        <span class="uk-text-bold uk-margin-small-right"><?= e($name) ?></span>
                        <?= get_role_badge($role) ?>
                        <span class="uk-label <?= $status_class ?> uk-margin-small-left"><?= e($status) ?></span>
                    </div>
                    <div class="uk-text-muted uk-text-small"><?= e($email) ?></div>
                    <div class="uk-text-meta uk-text-small uk-margin-small-top">
                        <?php if ($joined): ?>
                            Joined: <?= e($joined) ?>
                        <?php endif; ?>
                        <?php if ($last_active): ?>
                            <span class="uk-margin-small-left">Last active: <?= e($last_active) ?></span>
                        <?php endif; ?>
                        <?php foreach ($meta as $key => $value): ?>
                            <span class="uk-margin-small-left"><?= e($key) ?>: <?= e($value) ?></span>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
            <div>
                <a href="#" uk-icon="icon: more-vertical"></a>
                <div uk-dropdown="mode: click; pos: bottom-right">
                    <ul class="uk-nav uk-dropdown-nav">
                        <li class="uk-nav-header">Actions</li>
                        <li><a href="<?= BASE_URL ?>/pages/user-detail.php?id=<?= $id ?>"
                               hx-get="<?= BASE_URL ?>/pages/user-detail.php?id=<?= $id ?>"
                               hx-target="#main-content"
                               hx-swap="innerHTML"><span uk-icon="icon: eye; ratio: 0.8" class="uk-margin-small-right"></span> View Profile</a></li>
                        <li><a href="#"
                               hx-get="<?= BASE_URL ?>/api/users.php?action=edit&id=<?= $id ?>"
                               hx-target="#modal-container"
                               hx-swap="innerHTML"><span uk-icon="icon: pencil; ratio: 0.8" class="uk-margin-small-right"></span> Edit User</a></li>
                        <li><a href="#"><span uk-icon="icon: mail; ratio: 0.8" class="uk-margin-small-right"></span> Send Email</a></li>
                        <li><a href="#"><span uk-icon="icon: unlock; ratio: 0.8" class="uk-margin-small-right"></span> Reset Password</a></li>
                        <li class="uk-nav-divider"></li>
                        <li><a href="#"><span uk-icon="icon: ban; ratio: 0.8" class="uk-margin-small-right"></span> <?= $status === 'active' ? 'Disable' : 'Enable' ?> User</a></li>
                        <li><a href="#" class="uk-text-danger"
                               hx-delete="<?= BASE_URL ?>/api/users.php?id=<?= $id ?>"
                               hx-confirm="Are you sure you want to delete this user?"
                               hx-target="#user-<?= $id ?>"
                               hx-swap="outerHTML"><span uk-icon="icon: trash; ratio: 0.8" class="uk-margin-small-right"></span> Delete User</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <?php
}
