<?php
/**
 * Bootstrap file - loads all dependencies
 * Include this at the top of every page
 */

require_once __DIR__ . '/config.php';
require_once __DIR__ . '/functions.php';

// Load only function-defining components (not template components)
// Template components (header, page-header, tabs) are included directly in layout.php
$function_components = [
    'stat-card.php',
    'user-list-item.php',
    'progress-bar.php',
    'activity-feed.php',
    'modal.php'
];

foreach ($function_components as $component) {
    $path = __DIR__ . '/../components/' . $component;
    if (file_exists($path)) {
        require_once $path;
    }
}
