<?php
/**
 * AdoxEdu Admin Portal Configuration
 * Core configuration settings for the admin dashboard
 */

// Application Settings
define('APP_NAME', 'Admin Portal');
define('APP_VERSION', '1.0.0');
define('BASE_URL', '.'); // Relative URLs

// User Roles
define('ROLE_SUPER_ADMIN', 'super_admin');
define('ROLE_ADMIN', 'admin');
define('ROLE_SENIOR_COUNSELOR', 'senior_counselor');
define('ROLE_COUNSELOR', 'counselor');
define('ROLE_STUDENT', 'student');

// Role Display Names
$GLOBALS['role_names'] = [
    ROLE_SUPER_ADMIN => 'Super Admin',
    ROLE_ADMIN => 'Admin',
    ROLE_SENIOR_COUNSELOR => 'Senior Counselor',
    ROLE_COUNSELOR => 'Counselor',
    ROLE_STUDENT => 'Student'
];

// Role Permissions
$GLOBALS['role_permissions'] = [
    ROLE_SUPER_ADMIN => ['all_system_access', 'user_management', 'system_settings', 'financial_reports'],
    ROLE_ADMIN => ['user_management', 'application_oversight', 'payment_management', 'reports'],
    ROLE_SENIOR_COUNSELOR => ['student_management', 'application_review', 'document_verification'],
    ROLE_COUNSELOR => ['assigned_students', 'application_guidance', 'document_review']
];

// Navigation Items
$GLOBALS['admin_nav'] = [
    'overview' => ['label' => 'Overview', 'icon' => 'home'],
    'users' => ['label' => 'Users', 'icon' => 'users'],
    'applications' => ['label' => 'Applications', 'icon' => 'file-alt'],
    'payments' => ['label' => 'Payments', 'icon' => 'credit-card'],
    'reports' => ['label' => 'Reports', 'icon' => 'chart-bar'],
    'mailing' => ['label' => 'Mailing', 'icon' => 'envelope'],
    'settings' => ['label' => 'Settings', 'icon' => 'cog']
];

// Application Statuses
$GLOBALS['application_statuses'] = [
    'submitted' => ['label' => 'Submitted', 'color' => 'secondary'],
    'under_review' => ['label' => 'Under Review', 'color' => 'warning'],
    'interview_scheduled' => ['label' => 'Interview Scheduled', 'color' => 'primary'],
    'accepted' => ['label' => 'Accepted', 'color' => 'success'],
    'rejected' => ['label' => 'Rejected', 'color' => 'danger']
];

// Payment Statuses
$GLOBALS['payment_statuses'] = [
    'completed' => ['label' => 'Completed', 'color' => 'success'],
    'pending' => ['label' => 'Pending', 'color' => 'warning'],
    'failed' => ['label' => 'Failed', 'color' => 'danger']
];

// Mock current user (would come from session in production)
$GLOBALS['current_user'] = [
    'id' => 1,
    'name' => 'Michael Chen',
    'email' => 'michael.chen@globaledpathways.com',
    'role' => ROLE_SUPER_ADMIN,
    'avatar' => null,
    'initials' => 'MC'
];
