<?php
/**
 * Main Layout Template
 * Wraps all admin pages with common structure
 * Note: bootstrap.php should be included before this file
 */

// Ensure dependencies are loaded
if (!defined('APP_NAME')) {
    require_once __DIR__ . '/bootstrap.php';
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= e($page_title ?? 'Admin Dashboard') ?> - <?= APP_NAME ?></title>

    <!-- UIKit CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/uikit@3.18.0/dist/css/uikit.min.css">

    <!-- Custom Styles -->
    <link rel="stylesheet" href="/assets/css/main.css">

    <!-- Chart & Map Libraries -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/jsvectormap@1.5.3/dist/css/jsvectormap.min.css">
</head>
<body>
    <!-- Skip Link for Accessibility -->
    <a href="#main-content" class="skip-link">Skip to main content</a>

    <!-- Page Loading Indicator -->
    <div id="page-loader" class="page-loading" style="display: none;"></div>

    <!-- Toast Container -->
    <div id="toast-container" class="toast-container" aria-live="polite"></div>

    <?php include __DIR__ . '/../components/header.php'; ?>

    <div class="uk-container uk-container-large uk-margin-medium-top uk-margin-large-bottom">
        <?php
        $title = $page_title ?? 'Admin Dashboard';
        $description = $page_description ?? 'Manage users, monitor system performance, and generate reports.';
        include __DIR__ . '/../components/page-header.php';
        ?>

        <?php
        $active = $active_tab ?? 'overview';
        include __DIR__ . '/../components/tabs.php';
        ?>

        <!-- Main Content Area -->
        <div id="main-content">
            <?php if (isset($content)): ?>
                <?= $content ?>
            <?php endif; ?>
        </div>
    </div>

    <!-- Modal Container for dynamic modals -->
    <div id="modal-container"></div>

    <!-- UIKit JS -->
    <script src="https://cdn.jsdelivr.net/npm/uikit@3.18.0/dist/js/uikit.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/uikit@3.18.0/dist/js/uikit-icons.min.js"></script>

    <!-- htmx -->
    <script src="https://unpkg.com/htmx.org@1.9.10"></script>

    <!-- hyperscript -->
    <script src="https://unpkg.com/hyperscript.org@0.9.12"></script>

    <!-- Chart & Map Libraries -->
    <script src="https://cdn.jsdelivr.net/npm/apexcharts@3.45.0/dist/apexcharts.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/echarts@5.4.3/dist/echarts.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/jsvectormap@1.5.3/dist/js/jsvectormap.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/jsvectormap@1.5.3/dist/maps/world.js"></script>

    <!-- Back to Top Button -->
    <button class="back-to-top" id="back-to-top" aria-label="Back to top" onclick="window.scrollTo({top: 0, behavior: 'smooth'})">
        <span uk-icon="icon: chevron-up"></span>
    </button>

    <!-- Custom Scripts -->
    <script>
        // Configure htmx
        document.body.addEventListener('htmx:configRequest', function(evt) {
            evt.detail.headers['X-Requested-With'] = 'XMLHttpRequest';
        });

        // Show notifications
        document.body.addEventListener('htmx:afterRequest', function(evt) {
            if (evt.detail.xhr.getResponseHeader('HX-Trigger')) {
                const trigger = JSON.parse(evt.detail.xhr.getResponseHeader('HX-Trigger'));
                if (trigger.showMessage) {
                    UIkit.notification({
                        message: trigger.showMessage.message,
                        status: trigger.showMessage.status || 'primary',
                        pos: 'top-right',
                        timeout: 3000
                    });
                }
            }
        });

        // Toast Notification System
        function showToast(message, type = 'info', duration = 4000) {
            const container = document.getElementById('toast-container');
            const toast = document.createElement('div');
            toast.className = `toast ${type}`;
            toast.innerHTML = `<span>${message}</span>`;
            container.appendChild(toast);
            setTimeout(() => {
                toast.classList.add('hiding');
                setTimeout(() => toast.remove(), 300);
            }, duration);
        }

        // Dark Mode Toggle
        function toggleDarkMode() {
            const html = document.documentElement;
            const isDark = html.getAttribute('data-theme') === 'dark';
            html.setAttribute('data-theme', isDark ? 'light' : 'dark');
            localStorage.setItem('theme', isDark ? 'light' : 'dark');
            const toggleText = document.getElementById('theme-toggle-text');
            if (toggleText) toggleText.textContent = isDark ? 'Dark Mode' : 'Light Mode';
        }

        // Theme Skin Switcher (for testing - no persistence)
        function switchThemeSkin(skinName) {
            const html = document.documentElement;
            if (skinName) {
                html.setAttribute('data-skin', skinName);
            } else {
                html.removeAttribute('data-skin');
            }
            // Update checkmarks
            const defaultCheck = document.getElementById('skin-default-check');
            const oceanicCheck = document.getElementById('skin-oceanic-check');
            const amethystCheck = document.getElementById('skin-amethyst-check');
            const violetCheck = document.getElementById('skin-violet-check');
            const matrixCheck = document.getElementById('skin-matrix-check');
            const noirCheck = document.getElementById('skin-noir-check');
            if (defaultCheck) defaultCheck.style.visibility = skinName === '' ? 'visible' : 'hidden';
            if (oceanicCheck) oceanicCheck.style.visibility = skinName === 'oceanic' ? 'visible' : 'hidden';
            if (amethystCheck) amethystCheck.style.visibility = skinName === 'amethyst' ? 'visible' : 'hidden';
            if (violetCheck) violetCheck.style.visibility = skinName === 'violet' ? 'visible' : 'hidden';
            if (matrixCheck) matrixCheck.style.visibility = skinName === 'matrix' ? 'visible' : 'hidden';
            if (noirCheck) noirCheck.style.visibility = skinName === 'noir' ? 'visible' : 'hidden';
        }

        // Initialize theme from localStorage
        (function() {
            const savedTheme = localStorage.getItem('theme') || 'light';
            document.documentElement.setAttribute('data-theme', savedTheme);
            const toggleText = document.getElementById('theme-toggle-text');
            if (toggleText) toggleText.textContent = savedTheme === 'dark' ? 'Light Mode' : 'Dark Mode';
        })();

        // Back to Top Button
        window.addEventListener('scroll', function() {
            const btn = document.getElementById('back-to-top');
            if (window.scrollY > 300) btn.classList.add('visible');
            else btn.classList.remove('visible');
        });

        // HTMX Loading Indicator
        document.body.addEventListener('htmx:beforeRequest', function() {
            document.getElementById('page-loader').style.display = 'block';
        });
        document.body.addEventListener('htmx:afterRequest', function() {
            document.getElementById('page-loader').style.display = 'none';
        });

        // Keyboard Shortcuts
        document.addEventListener('keydown', function(e) {
            if ((e.metaKey || e.ctrlKey) && e.key === 'k') {
                e.preventDefault();
                const searchInput = document.querySelector('input[type="search"], input[placeholder*="Search"]');
                if (searchInput) searchInput.focus();
            }
            if (e.key === 'Escape') {
                const modal = document.querySelector('.uk-modal.uk-open');
                if (modal) UIkit.modal(modal).hide();
            }
            if (e.key === '?' && !e.target.matches('input, textarea, select')) {
                showToast('Shortcuts: Ctrl+K = Search, Esc = Close modal', 'info', 5000);
            }
        });

        // Autosave for textareas
        document.querySelectorAll('textarea[data-autosave]').forEach(textarea => {
            const key = 'autosave_' + (textarea.id || textarea.name);
            const saved = localStorage.getItem(key);
            if (saved) textarea.value = saved;
            textarea.addEventListener('input', () => {
                localStorage.setItem(key, textarea.value);
            });
        });

        // Form submission feedback
        document.querySelectorAll('form').forEach(form => {
            form.addEventListener('submit', function() {
                const btn = form.querySelector('button[type="submit"]');
                if (btn) {
                    btn.disabled = true;
                    btn.innerHTML = '<span uk-spinner="ratio: 0.5"></span> Processing...';
                }
            });
        });

        // Add ARIA labels to icon-only buttons
        document.querySelectorAll('a[uk-icon], button[uk-icon]').forEach(el => {
            if (!el.getAttribute('aria-label') && !el.textContent.trim()) {
                const icon = el.getAttribute('uk-icon');
                if (icon) {
                    const match = icon.match(/icon:\s*([^;]+)/);
                    if (match) el.setAttribute('aria-label', match[1].trim());
                }
            }
        });
    </script>
</body>
</html>
