<?php
/**
 * Admin Dashboard - Overview Page
 */

// Load dependencies first
require_once __DIR__ . '/includes/bootstrap.php';

$page_title = 'Admin Dashboard';
$page_description = 'Manage users, monitor system performance, and generate reports.';
$active_tab = 'overview';

// Start output buffering for content
ob_start();

// Mock data for overview stats
$overview_stats = [
    [
        'icon' => 'users',
        'value' => '2,847',
        'label' => 'Total Users',
        'trend' => 12,
        'color' => 'primary'
    ],
    [
        'icon' => 'file-text',
        'value' => '1,234',
        'label' => 'Active Applications',
        'trend' => 8,
        'color' => 'success'
    ],
    [
        'icon' => 'credit-card',
        'value' => '$235K',
        'label' => 'Monthly Revenue',
        'trend' => 15,
        'color' => 'warning'
    ],
    [
        'icon' => 'bolt',
        'value' => '68.5%',
        'label' => 'Conversion Rate',
        'trend' => -2,
        'color' => 'purple'
    ]
];

// Recent activities
$recent_activities = [
    [
        'icon' => 'user',
        'title' => 'New student registered',
        'user' => 'John Doe',
        'time' => '2 minutes ago',
        'color' => 'primary'
    ],
    [
        'icon' => 'credit-card',
        'title' => 'Payment of $25,000 received',
        'user' => 'Sarah Chen',
        'time' => '15 minutes ago',
        'color' => 'success'
    ],
    [
        'icon' => 'file-text',
        'title' => 'Application submitted to Stanford',
        'user' => 'Michael Rodriguez',
        'time' => '1 hour ago',
        'color' => 'warning'
    ],
    [
        'icon' => 'users',
        'title' => 'Assigned to counselor Sarah Johnson',
        'user' => 'Emma Wilson',
        'time' => '2 hours ago',
        'color' => 'cyan'
    ]
];

// Top destinations
$top_destinations = [
    ['label' => 'United States', 'value' => 456, 'percentage' => 35.2, 'suffix' => 'applications'],
    ['label' => 'United Kingdom', 'value' => 289, 'percentage' => 22.3, 'suffix' => 'applications'],
    ['label' => 'Canada', 'value' => 234, 'percentage' => 18.1, 'suffix' => 'applications'],
    ['label' => 'Australia', 'value' => 178, 'percentage' => 13.7, 'suffix' => 'applications'],
    ['label' => 'Germany', 'value' => 98, 'percentage' => 7.6, 'suffix' => 'applications'],
    ['label' => 'Netherlands', 'value' => 40, 'percentage' => 3.1, 'suffix' => 'applications']
];

// Render stats
render_stat_cards($overview_stats);
?>

<div class="uk-grid-small uk-margin-top" uk-grid>
    <!-- Recent Activities -->
    <div class="uk-width-1-2@m">
        <?php render_activity_feed($recent_activities, 'Recent Activities'); ?>
    </div>

    <!-- Top Study Destinations -->
    <div class="uk-width-1-2@m">
        <?php render_progress_list($top_destinations, 'Top Study Destinations'); ?>
    </div>
</div>

<?php
$content = ob_get_clean();
include __DIR__ . '/includes/layout.php';
?>
