<?php
/**
 * Admin Dashboard - Mailing System Page
 */

require_once __DIR__ . '/includes/bootstrap.php';

$page_title = 'Admin Dashboard';
$page_description = 'Manage users, monitor system performance, and generate reports.';
$active_tab = 'mailing';

ob_start();

// Mailing stats
$mailing_stats = [
    ['icon' => 'mail', 'value' => '4,567', 'label' => 'Emails Sent This Month', 'color' => 'primary'],
    ['icon' => 'check', 'value' => '78.5%', 'label' => 'Average Open Rate', 'color' => 'success'],
    ['icon' => 'link', 'value' => '23.4%', 'label' => 'Average Click Rate', 'color' => 'warning'],
    ['icon' => 'users', 'value' => '2,456', 'label' => 'Total Recipients', 'color' => 'purple']
];

// Recent campaigns
$campaigns = [
    ['name' => 'January Newsletter', 'recipients' => 2456, 'sent' => '2024-01-15', 'open_rate' => '74.2%', 'status' => 'sent'],
    ['name' => 'Application Deadline Reminder', 'recipients' => 1234, 'sent' => '2024-01-20', 'open_rate' => '80%', 'status' => 'sent'],
    ['name' => 'Interview Preparation Workshop', 'recipients' => 567, 'sent' => '2024-02-05', 'open_rate' => null, 'status' => 'scheduled']
];
?>

<!-- Page Header with Actions -->
<div class="uk-flex uk-flex-between uk-flex-middle uk-margin-bottom">
    <h3 class="uk-margin-remove">Mailing System</h3>
    <button class="uk-button uk-button-primary uk-button-small">
        <span uk-icon="icon: mail; ratio: 0.8"></span> Open Mailing System
    </button>
</div>

<!-- Stats -->
<?php render_stat_cards($mailing_stats); ?>

<!-- Recent Campaigns -->
<div class="uk-card uk-card-default uk-card-body uk-margin-top">
    <h4 class="uk-card-title">Recent Email Campaigns</h4>

    <?php foreach ($campaigns as $campaign): ?>
        <div class="uk-card uk-card-default uk-card-body uk-card-small uk-margin-small-bottom">
            <div class="uk-flex uk-flex-between uk-flex-middle">
                <div>
                    <div class="uk-text-bold"><?= e($campaign['name']) ?></div>
                    <div class="uk-text-muted uk-text-small">
                        <?= number_format($campaign['recipients']) ?> recipients &middot;
                        <?= $campaign['status'] === 'scheduled' ? 'Scheduled for' : 'Sent' ?> <?= e($campaign['sent']) ?>
                    </div>
                </div>
                <div class="uk-text-right uk-flex uk-flex-middle">
                    <?php if ($campaign['open_rate']): ?>
                        <div class="uk-margin-right">
                            <div class="uk-text-bold"><?= e($campaign['open_rate']) ?></div>
                            <div class="uk-text-meta uk-text-small">Open Rate</div>
                        </div>
                    <?php endif; ?>
                    <span class="uk-label <?= $campaign['status'] === 'sent' ? 'uk-label-success' : 'uk-label-warning' ?>">
                        <?= e($campaign['status']) ?>
                    </span>
                </div>
            </div>
        </div>
    <?php endforeach; ?>

    <div class="uk-margin-top">
        <button class="uk-button uk-button-primary uk-margin-small-right"
                uk-toggle="target: #create-campaign-modal">
            <span uk-icon="icon: plus; ratio: 0.8"></span> Create Campaign
        </button>
        <button class="uk-button uk-button-default">View All Campaigns</button>
    </div>
</div>

<!-- Create Campaign Modal -->
<?php
render_form_modal('create-campaign-modal', 'Create Email Campaign', [
    ['name' => 'name', 'label' => 'Campaign Name', 'type' => 'text', 'placeholder' => 'February Newsletter', 'required' => true],
    ['name' => 'subject', 'label' => 'Email Subject', 'type' => 'text', 'placeholder' => 'Your monthly update', 'required' => true],
    ['name' => 'recipients', 'label' => 'Recipients', 'type' => 'select', 'placeholder' => 'Select recipients', 'required' => true, 'options' => [
        'all' => 'All Users',
        'students' => 'Students Only',
        'counselors' => 'Counselors Only',
        'active' => 'Active Applications'
    ]],
    ['name' => 'content', 'label' => 'Email Content', 'type' => 'textarea', 'placeholder' => 'Write your email content...', 'rows' => 5, 'required' => true]
], BASE_URL . '/api/campaigns.php');
?>

<?php
$content = ob_get_clean();
include __DIR__ . '/includes/layout.php';
?>
