<?php
require_once __DIR__ . '/../includes/bootstrap.php';

$activities = [
    ['action' => 'Logged in', 'device' => 'Chrome on MacBook Pro', 'ip' => '192.168.1.100', 'location' => 'New York, USA', 'time' => '2024-01-30 09:45:00'],
    ['action' => 'Updated user permissions', 'device' => 'Chrome on MacBook Pro', 'ip' => '192.168.1.100', 'location' => 'New York, USA', 'time' => '2024-01-30 10:15:00'],
    ['action' => 'Exported reports', 'device' => 'Chrome on MacBook Pro', 'ip' => '192.168.1.100', 'location' => 'New York, USA', 'time' => '2024-01-30 11:30:00'],
    ['action' => 'Modified system settings', 'device' => 'Chrome on MacBook Pro', 'ip' => '192.168.1.100', 'location' => 'New York, USA', 'time' => '2024-01-29 14:20:00'],
    ['action' => 'Created new user', 'device' => 'Safari on iPhone', 'ip' => '192.168.1.101', 'location' => 'New York, USA', 'time' => '2024-01-29 16:45:00'],
    ['action' => 'Logged in', 'device' => 'Safari on iPhone', 'ip' => '192.168.1.101', 'location' => 'New York, USA', 'time' => '2024-01-29 16:40:00'],
    ['action' => 'Changed password', 'device' => 'Chrome on MacBook Pro', 'ip' => '192.168.1.100', 'location' => 'New York, USA', 'time' => '2024-01-28 09:00:00'],
    ['action' => 'Logged in', 'device' => 'Chrome on MacBook Pro', 'ip' => '192.168.1.100', 'location' => 'New York, USA', 'time' => '2024-01-28 08:55:00'],
];
?>

<div class="uk-flex uk-flex-between uk-flex-middle uk-margin-bottom">
    <h3 class="uk-margin-remove">Activity Log</h3>
    <div>
        <select class="uk-select uk-form-small uk-margin-small-right" style="width: 150px;">
            <option>All Activities</option>
            <option>Logins</option>
            <option>Settings Changes</option>
            <option>User Management</option>
        </select>
        <button class="uk-button uk-button-default uk-button-small">
            <span uk-icon="icon: download; ratio: 0.8"></span> Export
        </button>
    </div>
</div>

<div class="uk-card uk-card-default uk-card-body">
    <table class="uk-table uk-table-divider uk-table-hover">
        <thead>
            <tr>
                <th>Action</th>
                <th>Device</th>
                <th>IP Address</th>
                <th>Location</th>
                <th>Time</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($activities as $activity): ?>
            <tr>
                <td class="uk-text-bold"><?= e($activity['action']) ?></td>
                <td class="uk-text-small"><?= e($activity['device']) ?></td>
                <td><code><?= e($activity['ip']) ?></code></td>
                <td class="uk-text-small"><?= e($activity['location']) ?></td>
                <td class="uk-text-small uk-text-muted"><?= e($activity['time']) ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

    <div class="uk-text-center uk-margin-top">
        <button class="uk-button uk-button-default">Load More</button>
    </div>
</div>
