<?php
require_once __DIR__ . '/../includes/bootstrap.php';

$app_id = $_GET['id'] ?? 'APP-001';

$application = [
    'id' => $app_id,
    'student' => ['name' => 'John Doe', 'email' => 'john.doe@email.com', 'phone' => '+1 (555) 123-4567', 'initials' => 'JD'],
    'university' => 'Stanford University',
    'program' => 'Computer Science (MS)',
    'deadline' => '2024-02-15',
    'submitted' => '2024-01-30',
    'status' => 'under_review',
    'counselor' => 'Sarah Johnson',
    'progress' => 65
];

$app_stats = [
    ['icon' => 'fa-percent', 'value' => '65%', 'label' => 'Progress', 'color' => '#667eea', 'color_dark' => '#5568d3'],
    ['icon' => 'fa-file-alt', 'value' => '3/4', 'label' => 'Documents', 'color' => '#32d296', 'color_dark' => '#28b67f'],
    ['icon' => 'fa-calendar-check', 'value' => '16', 'label' => 'Days Left', 'color' => '#faa05a', 'color_dark' => '#f48939'],
    ['icon' => 'fa-comments', 'value' => '2', 'label' => 'Notes', 'color' => '#8b5cf6', 'color_dark' => '#7c3aed']
];

$documents = [
    ['name' => 'Transcript', 'status' => 'verified', 'uploaded' => '2024-01-25', 'icon' => 'fa-file-alt'],
    ['name' => 'Statement of Purpose', 'status' => 'verified', 'uploaded' => '2024-01-26', 'icon' => 'fa-file-text'],
    ['name' => 'Letter of Recommendation', 'status' => 'pending', 'uploaded' => '2024-01-28', 'icon' => 'fa-file-signature'],
    ['name' => 'English Proficiency Test', 'status' => 'missing', 'uploaded' => '-', 'icon' => 'fa-language']
];

$timeline = [
    ['date' => '2024-01-30', 'event' => 'Application submitted to Stanford', 'user' => 'John Doe', 'icon' => 'fa-paper-plane'],
    ['date' => '2024-01-30', 'event' => 'Assigned to Sarah Johnson', 'user' => 'System', 'icon' => 'fa-user-check'],
    ['date' => '2024-01-28', 'event' => 'Documents uploaded successfully', 'user' => 'John Doe', 'icon' => 'fa-cloud-upload-alt'],
    ['date' => '2024-01-25', 'event' => 'Application created', 'user' => 'John Doe', 'icon' => 'fa-plus-circle']
];

$notes = [
    ['text' => 'Strong candidate - research background aligns well with program requirements. GPA 3.9, solid recommendation letters.', 'author' => 'Sarah Johnson', 'date' => 'Jan 30', 'time' => '2:45 PM'],
    ['text' => 'Needs English proficiency scores before deadline. Reminded student via email.', 'author' => 'Sarah Johnson', 'date' => 'Jan 28', 'time' => '10:30 AM']
];

$status_colors = ['submitted' => 'secondary', 'under_review' => 'warning', 'interview_scheduled' => 'primary', 'accepted' => 'success', 'rejected' => 'danger'];
$doc_status_colors = ['verified' => 'success', 'pending' => 'warning', 'missing' => 'danger'];
?>

<style>
.back-link {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    color: #64748b;
    text-decoration: none;
    font-size: 14px;
    font-weight: 500;
    margin-bottom: 24px;
    transition: all 0.2s ease;
}

.back-link:hover {
    color: #667eea;
    text-decoration: none;
}

.app-header-card {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border-radius: 12px;
    padding: 32px;
    color: white;
    margin-bottom: 24px;
    box-shadow: 0 4px 16px rgba(102, 126, 234, 0.2);
}

.app-title {
    font-size: 28px;
    font-weight: 700;
    margin: 0;
    color: white;
}

.app-subtitle {
    font-size: 16px;
    color: rgba(255, 255, 255, 0.9);
    margin-top: 4px;
}

.app-id {
    font-size: 13px;
    color: rgba(255, 255, 255, 0.8);
    margin-top: 8px;
}

.status-badge-large {
    padding: 8px 16px;
    border-radius: 8px;
    font-size: 13px;
    font-weight: 600;
    text-transform: uppercase;
    background: rgba(255, 255, 255, 0.2);
    color: white;
}

.modern-btn {
    padding: 10px 20px;
    border-radius: 8px;
    font-size: 14px;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.2s ease;
    display: inline-flex;
    align-items: center;
    gap: 8px;
    border: none;
}

.modern-btn-white {
    background: white;
    color: #667eea;
}

.modern-btn-white:hover {
    transform: translateY(-1px);
    box-shadow: 0 4px 12px rgba(255, 255, 255, 0.3);
}

.app-stat-card {
    border-radius: 12px;
    padding: 20px;
    background: white;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    transition: all 0.3s ease;
}

.app-stat-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 16px rgba(0, 0, 0, 0.12);
}

.stat-icon-small {
    width: 40px;
    height: 40px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 18px;
    margin-bottom: 12px;
}

.stat-value-small {
    font-size: 24px;
    font-weight: 700;
    color: #1a1a1a;
    margin-bottom: 4px;
}

.stat-label-small {
    font-size: 13px;
    color: #64748b;
    font-weight: 500;
}

.modern-card {
    background: white;
    border-radius: 12px;
    padding: 24px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    margin-bottom: 20px;
}

.card-title {
    font-size: 18px;
    font-weight: 600;
    color: #1a1a1a;
    margin-bottom: 20px;
    display: flex;
    align-items: center;
    gap: 8px;
}

.student-info-card {
    display: flex;
    align-items: center;
    gap: 16px;
    padding: 20px;
    background: #f8fafc;
    border-radius: 12px;
    border: 1px solid #e2e8f0;
}

.student-avatar {
    width: 64px;
    height: 64px;
    border-radius: 50%;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 24px;
    font-weight: 600;
    color: white;
    flex-shrink: 0;
}

.doc-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 16px;
    border-radius: 8px;
    background: #f8fafc;
    margin-bottom: 12px;
    border: 1px solid #e2e8f0;
    transition: all 0.2s ease;
}

.doc-item:hover {
    border-color: #667eea;
    background: white;
    box-shadow: 0 2px 8px rgba(102, 126, 234, 0.1);
}

.doc-icon {
    width: 40px;
    height: 40px;
    border-radius: 10px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 18px;
    flex-shrink: 0;
}

.status-badge {
    padding: 6px 12px;
    border-radius: 6px;
    font-size: 11px;
    font-weight: 600;
    text-transform: uppercase;
}

.status-success {
    background: #d1fae5;
    color: #065f46;
}

.status-warning {
    background: #fef3c7;
    color: #92400e;
}

.status-danger {
    background: #fee2e2;
    color: #991b1b;
}

.timeline-item {
    display: flex;
    gap: 16px;
    padding: 16px;
    border-radius: 8px;
    background: #f8fafc;
    margin-bottom: 12px;
    position: relative;
}

.timeline-icon {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 16px;
    flex-shrink: 0;
}

.note-item {
    padding: 16px;
    background: #f8fafc;
    border-radius: 8px;
    border-left: 4px solid #667eea;
    margin-bottom: 12px;
}

.info-list dt {
    font-size: 13px;
    color: #64748b;
    font-weight: 500;
    margin-bottom: 4px;
}

.info-list dd {
    font-size: 15px;
    color: #1a1a1a;
    font-weight: 500;
    margin-bottom: 16px;
}

.progress-bar {
    width: 100%;
    height: 8px;
    background: #e2e8f0;
    border-radius: 4px;
    overflow: hidden;
}

.progress-fill {
    height: 100%;
    background: linear-gradient(90deg, #667eea 0%, #764ba2 100%);
    transition: width 0.3s ease;
}
</style>

<a href="<?= BASE_URL ?>/index.php"
   hx-get="<?= BASE_URL ?>/pages/applications.php"
   hx-target="#main-content"
   hx-swap="innerHTML"
   hx-push-url="<?= BASE_URL ?>/applications.php"
   class="back-link">
    <i class="fa-slab fa-solid fa-arrow-left"></i> Back to Applications
</a>

<!-- Application Header -->
<div class="app-header-card">
    <div class="uk-flex uk-flex-between uk-flex-middle">
        <div>
            <h2 class="app-title"><?= e($application['university']) ?></h2>
            <div class="app-subtitle"><?= e($application['program']) ?></div>
            <div class="app-id">
                <i class="fa-slab fa-solid fa-hashtag"></i><?= e($application['id']) ?>
            </div>
        </div>
        <div style="display: flex; align-items: center; gap: 12px;">
            <span class="status-badge-large">
                <?= str_replace('_', ' ', $application['status']) ?>
            </span>
            <div class="uk-inline">
                <button class="modern-btn modern-btn-white">
                    <i class="fa-slab fa-solid fa-ellipsis-v"></i> Actions
                </button>
                <div uk-dropdown="mode: click; pos: bottom-right">
                    <ul class="uk-nav uk-dropdown-nav">
                        <li class="uk-nav-header">Actions</li>
                        <li><a href="#" uk-toggle="target: #update-status-modal"><i class="fa-slab fa-solid fa-tag fa-fw"></i> Update Status</a></li>
                        <li><a href="#" uk-toggle="target: #assign-counselor-modal"><i class="fa-slab fa-solid fa-user fa-fw"></i> Reassign Counselor</a></li>
                        <li><a href="#" uk-toggle="target: #contact-student-modal"><i class="fa-slab fa-solid fa-envelope fa-fw"></i> Contact Student</a></li>
                        <li class="uk-nav-divider"></li>
                        <li><a href="#" uk-toggle="target: #export-pdf-modal"><i class="fa-slab fa-solid fa-download fa-fw"></i> Export PDF</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Stats Grid -->
<div class="uk-grid-small uk-child-width-1-2@s uk-child-width-1-4@l" uk-grid>
    <?php foreach ($app_stats as $stat): ?>
    <div>
        <div class="app-stat-card">
            <div class="stat-icon-small" style="background: linear-gradient(135deg, <?= $stat['color'] ?> 0%, <?= $stat['color_dark'] ?> 100%);">
                <i class="fa-slab fa-solid <?= $stat['icon'] ?>"></i>
            </div>
            <div class="stat-value-small"><?= e($stat['value']) ?></div>
            <div class="stat-label-small"><?= e($stat['label']) ?></div>
        </div>
    </div>
    <?php endforeach; ?>
</div>

<div class="uk-grid-small uk-margin-top" uk-grid>
    <!-- Left Column -->
    <div class="uk-width-2-3@l">
        <!-- Student Info -->
        <div class="modern-card">
            <h4 class="card-title">
                <i class="fa-slab fa-solid fa-user"></i> Student Information
            </h4>
            <div class="student-info-card">
                <div class="student-avatar"><?= $application['student']['initials'] ?></div>
                <div style="flex: 1;">
                    <div style="font-weight: 600; font-size: 18px; color: #1a1a1a; margin-bottom: 4px;">
                        <?= e($application['student']['name']) ?>
                    </div>
                    <div style="font-size: 14px; color: #64748b;">
                        <i class="fa-slab fa-solid fa-envelope fa-sm"></i> <?= e($application['student']['email']) ?>
                    </div>
                    <div style="font-size: 14px; color: #64748b; margin-top: 2px;">
                        <i class="fa-slab fa-solid fa-phone fa-sm"></i> <?= e($application['student']['phone']) ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Documents -->
        <div class="modern-card">
            <h4 class="card-title">
                <i class="fa-slab fa-solid fa-folder-open"></i> Required Documents
            </h4>
            <?php foreach ($documents as $doc): ?>
            <div class="doc-item">
                <div style="display: flex; align-items: center; gap: 16px; flex: 1;">
                    <div class="doc-icon">
                        <i class="fa-slab fa-solid <?= $doc['icon'] ?>"></i>
                    </div>
                    <div>
                        <div style="font-weight: 600; color: #1a1a1a; font-size: 15px; margin-bottom: 4px;">
                            <?= e($doc['name']) ?>
                        </div>
                        <div style="font-size: 12px; color: #64748b;">
                            <?= $doc['uploaded'] !== '-' ? 'Uploaded: ' . e($doc['uploaded']) : 'Not uploaded' ?>
                        </div>
                    </div>
                </div>
                <div style="display: flex; align-items: center; gap: 12px;">
                    <span class="status-badge status-<?= $doc_status_colors[$doc['status']] ?>">
                        <?= e($doc['status']) ?>
                    </span>
                    <?php if ($doc['status'] !== 'missing'): ?>
                    <button style="background: none; border: none; color: #667eea; cursor: pointer;">
                        <i class="fa-slab fa-solid fa-download"></i>
                    </button>
                    <?php else: ?>
                    <button style="background: none; border: none; color: #faa05a; cursor: pointer;">
                        <i class="fa-slab fa-solid fa-paper-plane"></i>
                    </button>
                    <?php endif; ?>
                </div>
            </div>
            <?php endforeach; ?>
        </div>

        <!-- Notes -->
        <div class="modern-card">
            <h4 class="card-title">
                <i class="fa-slab fa-solid fa-sticky-note"></i> Counselor Notes
            </h4>
            <?php foreach ($notes as $note): ?>
            <div class="note-item">
                <div style="font-size: 14px; color: #1a1a1a; margin-bottom: 8px;"><?= e($note['text']) ?></div>
                <div style="font-size: 12px; color: #64748b;">
                    <i class="fa-slab fa-solid fa-user fa-xs"></i> <?= e($note['author']) ?> &middot;
                    <i class="fa-slab fa-solid fa-calendar fa-xs"></i> <?= e($note['date']) ?> at <?= e($note['time']) ?>
                </div>
            </div>
            <?php endforeach; ?>
            <hr class="uk-margin">
            <form>
                <textarea class="uk-textarea" rows="3" placeholder="Add a new note..." style="border-radius: 8px;"></textarea>
                <button class="modern-btn uk-margin-small-top" type="button" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white;">
                    <i class="fa-slab fa-solid fa-plus"></i> Add Note
                </button>
            </form>
        </div>
    </div>

    <!-- Right Column -->
    <div class="uk-width-1-3@l">
        <!-- Application Details -->
        <div class="modern-card">
            <h4 class="card-title">
                <i class="fa-slab fa-solid fa-info-circle"></i> Application Details
            </h4>
            <dl class="info-list uk-description-list">
                <dt>Application Deadline</dt>
                <dd><i class="fa-slab fa-solid fa-calendar-times fa-sm"></i> <?= e($application['deadline']) ?></dd>
                <dt>Submitted Date</dt>
                <dd><i class="fa-slab fa-solid fa-calendar-check fa-sm"></i> <?= e($application['submitted']) ?></dd>
                <dt>Assigned Counselor</dt>
                <dd><i class="fa-slab fa-solid fa-user-tie fa-sm"></i> <?= e($application['counselor']) ?></dd>
                <dt>Overall Progress</dt>
                <dd>
                    <div class="progress-bar">
                        <div class="progress-fill" style="width: <?= $application['progress'] ?>%"></div>
                    </div>
                    <div style="font-size: 13px; color: #667eea; font-weight: 600; margin-top: 4px;">
                        <?= $application['progress'] ?>% Complete
                    </div>
                </dd>
            </dl>
        </div>

        <!-- Activity Timeline -->
        <div class="modern-card">
            <h4 class="card-title">
                <i class="fa-slab fa-solid fa-history"></i> Activity Timeline
            </h4>
            <?php foreach ($timeline as $event): ?>
            <div class="timeline-item">
                <div class="timeline-icon">
                    <i class="fa-slab fa-solid <?= $event['icon'] ?>"></i>
                </div>
                <div style="flex: 1;">
                    <div style="font-size: 14px; color: #1a1a1a; font-weight: 500; margin-bottom: 2px;">
                        <?= e($event['event']) ?>
                    </div>
                    <div style="font-size: 12px; color: #64748b;">
                        <?= e($event['user']) ?>
                    </div>
                    <div style="font-size: 11px; color: #94a3b8; margin-top: 2px;">
                        <?= e($event['date']) ?>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>

<!-- Update Status Modal -->
<div id="update-status-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Update Application Status</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">New Status *</label>
                    <select class="uk-select" required>
                        <option value="">Select status...</option>
                        <option>Submitted</option>
                        <option selected>Under Review</option>
                        <option>Interview Scheduled</option>
                        <option>Accepted</option>
                        <option>Rejected</option>
                        <option>Waitlisted</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Notes (Optional)</label>
                    <textarea class="uk-textarea" rows="3" placeholder="Reason for status change..."></textarea>
                </div>
                <div class="uk-margin">
                    <label><input class="uk-checkbox" type="checkbox" checked> Notify student of status change</label>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Update Status</button>
        </div>
    </div>
</div>

<!-- Assign Counselor Modal -->
<div id="assign-counselor-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Assign Counselor</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Current Counselor</label>
                    <div class="uk-text-bold"><?= e($application['counselor']) ?></div>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">New Counselor *</label>
                    <select class="uk-select" required>
                        <option value="">Select counselor...</option>
                        <option>Sarah Johnson</option>
                        <option>Michael Chen</option>
                        <option>Emily Rodriguez</option>
                        <option>David Kim</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Reason for Transfer</label>
                    <textarea class="uk-textarea" rows="2" placeholder="Optional..."></textarea>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Assign</button>
        </div>
    </div>
</div>

<!-- Contact Student Modal -->
<div id="contact-student-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Contact Student</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">To</label>
                    <div class="uk-text-bold"><?= e($application['student']['name']) ?> (<?= e($application['student']['email']) ?>)</div>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Subject *</label>
                    <input class="uk-input" type="text" placeholder="Message subject" required>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Message *</label>
                    <textarea class="uk-textarea" rows="5" placeholder="Your message..." required></textarea>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Send Message</button>
        </div>
    </div>
</div>

<!-- Export PDF Modal -->
<div id="export-pdf-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Export to PDF</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Include</label>
                    <div class="uk-margin-small">
                        <label><input class="uk-checkbox" type="checkbox" checked> Application Details</label>
                    </div>
                    <div class="uk-margin-small">
                        <label><input class="uk-checkbox" type="checkbox" checked> Student Information</label>
                    </div>
                    <div class="uk-margin-small">
                        <label><input class="uk-checkbox" type="checkbox" checked> Document List</label>
                    </div>
                    <div class="uk-margin-small">
                        <label><input class="uk-checkbox" type="checkbox" checked> Activity Timeline</label>
                    </div>
                    <div class="uk-margin-small">
                        <label><input class="uk-checkbox" type="checkbox"> Counselor Notes</label>
                    </div>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Export PDF</button>
        </div>
    </div>
</div>

<script>
// Re-initialize UIKit components after HTMX load
if (typeof UIkit !== 'undefined') {
    UIkit.update();
}
</script>
