<?php
/**
 * Applications Page Content (Partial)
 */

require_once __DIR__ . '/../includes/bootstrap.php';

$app_stats = [
    ['icon' => 'fa-file-text', 'value' => '1,234', 'label' => 'Active Applications', 'color' => '#667eea', 'color_dark' => '#5568d3'],
    ['icon' => 'fa-check-circle', 'value' => '892', 'label' => 'Accepted', 'color' => '#32d296', 'color_dark' => '#28b67f'],
    ['icon' => 'fa-clock', 'value' => '456', 'label' => 'Under Review', 'color' => '#faa05a', 'color_dark' => '#f48939'],
    ['icon' => 'fa-exclamation-triangle', 'value' => '67', 'label' => 'Needs Attention', 'color' => '#f0506e', 'color_dark' => '#e03e5c']
];

$status_distribution = [
    ['label' => 'Submitted', 'value' => 245, 'percentage' => 35, 'color' => '#94a3b8'],
    ['label' => 'Under Review', 'value' => 189, 'percentage' => 27, 'color' => '#faa05a'],
    ['label' => 'Interview Scheduled', 'value' => 134, 'percentage' => 19, 'color' => '#667eea'],
    ['label' => 'Accepted', 'value' => 98, 'percentage' => 14, 'color' => '#32d296'],
    ['label' => 'Rejected', 'value' => 34, 'percentage' => 5, 'color' => '#f0506e']
];

$recent_applications = [
    ['id' => 'APP-001', 'student' => 'John Doe', 'university' => 'Stanford University', 'program' => 'Computer Science (MS)', 'submitted' => '2024-01-30', 'status' => 'under_review'],
    ['id' => 'APP-002', 'student' => 'Sarah Chen', 'university' => 'MIT', 'program' => 'Engineering (MS)', 'submitted' => '2024-01-29', 'status' => 'interview_scheduled'],
    ['id' => 'APP-003', 'student' => 'Michael Rodriguez', 'university' => 'Harvard University', 'program' => 'Business Administration (MBA)', 'submitted' => '2024-01-28', 'status' => 'accepted'],
    ['id' => 'APP-004', 'student' => 'Emma Wilson', 'university' => 'University of Cambridge', 'program' => 'Economics (PhD)', 'submitted' => '2024-01-27', 'status' => 'submitted']
];

$status_config = [
    'submitted' => ['label' => 'Submitted', 'color' => '#94a3b8', 'icon' => 'fa-paper-plane'],
    'under_review' => ['label' => 'Under Review', 'color' => '#faa05a', 'icon' => 'fa-search'],
    'interview_scheduled' => ['label' => 'Interview Scheduled', 'color' => '#667eea', 'icon' => 'fa-calendar-check'],
    'accepted' => ['label' => 'Accepted', 'color' => '#32d296', 'icon' => 'fa-check-circle'],
    'rejected' => ['label' => 'Rejected', 'color' => '#f0506e', 'icon' => 'fa-times-circle']
];
?>

<style>
.stat-card {
    background: linear-gradient(135deg, var(--stat-color) 0%, var(--stat-color-dark) 100%);
    border-radius: 12px;
    padding: 24px;
    color: white;
    position: relative;
    overflow: hidden;
    transition: all 0.3s ease;
    box-shadow: 0 4px 16px rgba(0, 0, 0, 0.1);
}

.stat-card:hover {
    transform: translateY(-4px);
    box-shadow: 0 8px 24px rgba(0, 0, 0, 0.15);
}

.stat-card::before {
    content: '';
    position: absolute;
    top: -50%;
    right: -20%;
    width: 200px;
    height: 200px;
    border-radius: 50%;
    background: rgba(255, 255, 255, 0.1);
}

.stat-content {
    position: relative;
    z-index: 1;
}

.stat-icon {
    font-size: 32px;
    opacity: 0.9;
    margin-bottom: 12px;
}

.stat-value {
    font-size: 32px;
    font-weight: 700;
    margin-bottom: 4px;
}

.stat-label {
    font-size: 14px;
    opacity: 0.95;
}

.distribution-card {
    background: white;
    border-radius: 12px;
    padding: 24px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    margin-bottom: 20px;
}

.card-title {
    font-size: 18px;
    font-weight: 600;
    color: #1a1a1a;
    margin-bottom: 20px;
}

.distribution-item {
    padding: 12px 0;
    border-bottom: 1px solid #e2e8f0;
}

.distribution-item:last-child {
    border-bottom: none;
}

.distribution-label {
    font-size: 14px;
    font-weight: 600;
    color: #1a1a1a;
    margin-bottom: 8px;
    display: flex;
    justify-content: space-between;
}

.distribution-bar {
    height: 8px;
    background: #e2e8f0;
    border-radius: 4px;
    overflow: hidden;
    margin-bottom: 4px;
}

.distribution-fill {
    height: 100%;
    border-radius: 4px;
    transition: width 0.5s ease;
}

.distribution-meta {
    font-size: 12px;
    color: #64748b;
}

.applications-card {
    background: white;
    border-radius: 12px;
    padding: 24px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
}

.application-item {
    padding: 16px;
    border-radius: 8px;
    margin-bottom: 12px;
    transition: all 0.2s ease;
    background: #f8fafc;
    border-left: 4px solid transparent;
}

.application-item:hover {
    background: #f1f5f9;
    border-left-color: #667eea;
    transform: translateX(4px);
}

.application-item:last-child {
    margin-bottom: 0;
}

.application-id {
    font-size: 11px;
    font-weight: 600;
    color: #667eea;
    background: #f0f4ff;
    padding: 4px 8px;
    border-radius: 4px;
    display: inline-block;
    margin-bottom: 8px;
}

.application-student {
    font-size: 15px;
    font-weight: 600;
    color: #1a1a1a;
    margin-bottom: 4px;
}

.application-university {
    font-size: 13px;
    color: #64748b;
    margin-bottom: 2px;
}

.application-program {
    font-size: 12px;
    color: #94a3b8;
}

.application-meta {
    font-size: 12px;
    color: #94a3b8;
}

.status-badge {
    padding: 4px 12px;
    border-radius: 6px;
    font-size: 11px;
    font-weight: 600;
    color: white;
    display: inline-flex;
    align-items: center;
    gap: 4px;
}

.action-menu-btn {
    width: 32px;
    height: 32px;
    border-radius: 6px;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: all 0.2s ease;
    color: #64748b;
    background: white;
}

.action-menu-btn:hover {
    background: #667eea;
    color: white;
}

@media (max-width: 959px) {
    .stat-card {
        padding: 20px;
    }

    .stat-value {
        font-size: 28px;
    }

    .stat-icon {
        font-size: 28px;
    }

    .application-meta {
        display: none;
    }
}
</style>

<div class="uk-flex uk-flex-between uk-flex-middle uk-margin-bottom mobile-stack">
    <h3 class="uk-margin-remove mobile-mb">
        <i class="fa-slab fa-solid fa-file-text"></i> Application Management
    </h3>
    <div class="uk-flex" style="gap: 8px;">
        <button class="uk-button uk-button-default uk-button-small" uk-toggle="target: #export-data-modal">
            <i class="fa-slab fa-solid fa-download"></i> <span class="uk-visible@m">Export Data</span>
        </button>
        <button class="uk-button uk-button-default uk-button-small" uk-toggle="target: #advanced-filters-modal">
            <i class="fa-slab fa-solid fa-filter"></i> <span class="uk-visible@m">Advanced Filters</span>
        </button>
    </div>
</div>

<!-- Stats Cards -->
<div class="uk-grid-small uk-child-width-1-2@s uk-child-width-1-4@m uk-margin-bottom" uk-grid>
    <?php foreach ($app_stats as $stat): ?>
    <div>
        <div class="stat-card" style="--stat-color: <?= $stat['color'] ?>; --stat-color-dark: <?= $stat['color_dark'] ?>;">
            <div class="stat-content">
                <div class="stat-icon">
                    <i class="fa-slab fa-solid <?= $stat['icon'] ?>"></i>
                </div>
                <div class="stat-value"><?= e($stat['value']) ?></div>
                <div class="stat-label"><?= e($stat['label']) ?></div>
            </div>
        </div>
    </div>
    <?php endforeach; ?>
</div>

<!-- Status Distribution -->
<div class="distribution-card">
    <h4 class="card-title">
        <i class="fa-slab fa-solid fa-chart-pie"></i> Application Status Distribution
    </h4>
    <?php foreach ($status_distribution as $item): ?>
    <div class="distribution-item">
        <div class="distribution-label">
            <span><?= e($item['label']) ?></span>
            <span><?= $item['percentage'] ?>%</span>
        </div>
        <div class="distribution-bar">
            <div class="distribution-fill" style="width: <?= $item['percentage'] ?>%; background: <?= $item['color'] ?>;"></div>
        </div>
        <div class="distribution-meta">
            <?= number_format($item['value']) ?> applications
        </div>
    </div>
    <?php endforeach; ?>
</div>

<!-- Recent Applications -->
<div class="applications-card">
    <h4 class="card-title">
        <i class="fa-slab fa-solid fa-list"></i> Recent Applications
    </h4>
    <?php foreach ($recent_applications as $app):
        $status = $status_config[$app['status']];
    ?>
    <div class="application-item"
         style="cursor: pointer;"
         hx-get="<?= BASE_URL ?>/pages/application-detail.php?id=<?= $app['id'] ?>"
         hx-target="#main-content"
         hx-swap="innerHTML"
         hx-push-url="<?= BASE_URL ?>/application-detail.php?id=<?= $app['id'] ?>">
        <div class="uk-flex uk-flex-between uk-flex-middle" style="gap: 16px;">
            <!-- Info -->
            <div style="flex: 1; min-width: 0;">
                <div class="application-id"><?= e($app['id']) ?></div>
                <div class="application-student"><?= e($app['student']) ?></div>
                <div class="application-university">
                    <i class="fa-slab fa-solid fa-university fa-fw"></i> <?= e($app['university']) ?>
                </div>
                <div class="application-program">
                    <i class="fa-slab fa-solid fa-graduation-cap fa-fw"></i> <?= e($app['program']) ?>
                </div>
            </div>

            <!-- Meta (Desktop) -->
            <div class="application-meta uk-visible@m">
                <i class="fa-slab fa-solid fa-calendar fa-fw"></i> <?= date('M d, Y', strtotime($app['submitted'])) ?>
            </div>

            <!-- Status & Actions -->
            <div class="uk-flex uk-flex-middle" style="gap: 8px;">
                <span class="status-badge" style="background: <?= $status['color'] ?>;">
                    <i class="fa-slab fa-solid <?= $status['icon'] ?>"></i>
                    <span><?= $status['label'] ?></span>
                </span>
                <div class="action-menu-btn" uk-tooltip="Actions">
                    <i class="fa-slab fa-solid fa-ellipsis-v"></i>
                    <div uk-dropdown="mode: click; pos: bottom-right">
                        <ul class="uk-nav uk-dropdown-nav">
                            <li class="uk-nav-header">Actions</li>
                            <li><a href="#"><i class="fa-slab fa-solid fa-eye fa-fw"></i> View Details</a></li>
                            <li><a href="#" uk-toggle="target: #assign-counselor-modal"><i class="fa-slab fa-solid fa-user fa-fw"></i> Assign Counselor</a></li>
                            <li><a href="#" uk-toggle="target: #update-status-modal"><i class="fa-slab fa-solid fa-tag fa-fw"></i> Update Status</a></li>
                            <li><a href="#" uk-toggle="target: #contact-student-modal"><i class="fa-slab fa-solid fa-envelope fa-fw"></i> Contact Student</a></li>
                            <li><a href="#" uk-toggle="target: #add-note-modal"><i class="fa-slab fa-solid fa-comment fa-fw"></i> Add Note</a></li>
                            <li class="uk-nav-divider"></li>
                            <li><a href="#" uk-toggle="target: #export-pdf-modal"><i class="fa-slab fa-solid fa-download fa-fw"></i> Export PDF</a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endforeach; ?>
</div>

<!-- Export Data Modal -->
<div id="export-data-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title"><i class="fa-slab fa-solid fa-download"></i> Export Application Data</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Format</label>
                    <select class="uk-select">
                        <option>Excel</option>
                        <option>CSV</option>
                        <option>PDF</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Date Range</label>
                    <div class="uk-grid-small" uk-grid>
                        <div class="uk-width-1-2">
                            <input class="uk-input" type="date">
                        </div>
                        <div class="uk-width-1-2">
                            <input class="uk-input" type="date">
                        </div>
                    </div>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Include</label>
                    <div class="uk-margin-small">
                        <label><input class="uk-checkbox" type="checkbox" checked> Application Details</label>
                    </div>
                    <div class="uk-margin-small">
                        <label><input class="uk-checkbox" type="checkbox" checked> Student Information</label>
                    </div>
                    <div class="uk-margin-small">
                        <label><input class="uk-checkbox" type="checkbox"> Counselor Notes</label>
                    </div>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">
                <i class="fa-slab fa-solid fa-download"></i> Export
            </button>
        </div>
    </div>
</div>

<!-- Advanced Filters Modal -->
<div id="advanced-filters-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title"><i class="fa-slab fa-solid fa-filter"></i> Advanced Filters</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Status</label>
                    <select class="uk-select">
                        <option value="">All Statuses</option>
                        <option>Submitted</option>
                        <option>Under Review</option>
                        <option>Interview Scheduled</option>
                        <option>Accepted</option>
                        <option>Rejected</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">University</label>
                    <select class="uk-select">
                        <option value="">All Universities</option>
                        <option>Stanford University</option>
                        <option>MIT</option>
                        <option>Harvard University</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Counselor</label>
                    <select class="uk-select">
                        <option value="">All Counselors</option>
                        <option>Sarah Johnson</option>
                        <option>Michael Chen</option>
                        <option>Emily Rodriguez</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Submission Date</label>
                    <div class="uk-grid-small" uk-grid>
                        <div class="uk-width-1-2">
                            <input class="uk-input" type="date" placeholder="From">
                        </div>
                        <div class="uk-width-1-2">
                            <input class="uk-input" type="date" placeholder="To">
                        </div>
                    </div>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Clear</button>
            <button class="uk-button uk-button-primary" type="button">
                <i class="fa-slab fa-solid fa-check"></i> Apply Filters
            </button>
        </div>
    </div>
</div>

<!-- Export PDF Modal -->
<div id="export-pdf-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title"><i class="fa-slab fa-solid fa-file-pdf"></i> Export to PDF</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Include</label>
                    <div class="uk-margin-small">
                        <label><input class="uk-checkbox" type="checkbox" checked> Application Details</label>
                    </div>
                    <div class="uk-margin-small">
                        <label><input class="uk-checkbox" type="checkbox" checked> Student Information</label>
                    </div>
                    <div class="uk-margin-small">
                        <label><input class="uk-checkbox" type="checkbox" checked> Status History</label>
                    </div>
                    <div class="uk-margin-small">
                        <label><input class="uk-checkbox" type="checkbox"> Notes</label>
                    </div>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">
                <i class="fa-slab fa-solid fa-download"></i> Export PDF
            </button>
        </div>
    </div>
</div>

<!-- Update Status Modal -->
<div id="update-status-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title"><i class="fa-slab fa-solid fa-tag"></i> Update Application Status</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">New Status</label>
                    <select class="uk-select" required>
                        <option value="">Select status...</option>
                        <option>Submitted</option>
                        <option>Under Review</option>
                        <option>Interview Scheduled</option>
                        <option>Accepted</option>
                        <option>Rejected</option>
                        <option>Waitlisted</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Notes (Optional)</label>
                    <textarea class="uk-textarea" rows="3" placeholder="Reason for status change..."></textarea>
                </div>
                <div class="uk-margin">
                    <label><input class="uk-checkbox" type="checkbox" checked> Notify student of status change</label>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">
                <i class="fa-slab fa-solid fa-check"></i> Update Status
            </button>
        </div>
    </div>
</div>

<!-- Assign Counselor Modal -->
<div id="assign-counselor-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title"><i class="fa-slab fa-solid fa-user-plus"></i> Assign Counselor</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Counselor</label>
                    <select class="uk-select" required>
                        <option value="">Select counselor...</option>
                        <option>Sarah Johnson</option>
                        <option>Michael Chen</option>
                        <option>Emily Rodriguez</option>
                        <option>David Kim</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Notes (Optional)</label>
                    <textarea class="uk-textarea" rows="2" placeholder="Assignment notes..."></textarea>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">
                <i class="fa-slab fa-solid fa-check"></i> Assign
            </button>
        </div>
    </div>
</div>

<!-- Contact Student Modal -->
<div id="contact-student-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title"><i class="fa-slab fa-solid fa-envelope"></i> Contact Student</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Subject</label>
                    <input class="uk-input" type="text" placeholder="Message subject" required>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Message</label>
                    <textarea class="uk-textarea" rows="5" placeholder="Your message..." required></textarea>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">
                <i class="fa-slab fa-solid fa-paper-plane"></i> Send Message
            </button>
        </div>
    </div>
</div>

<!-- Add Note Modal -->
<div id="add-note-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title"><i class="fa-slab fa-solid fa-comment"></i> Add Note</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Note</label>
                    <textarea class="uk-textarea" rows="4" placeholder="Your note..." required></textarea>
                </div>
                <div class="uk-margin">
                    <label><input class="uk-checkbox" type="checkbox"> Pin this note</label>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">
                <i class="fa-slab fa-solid fa-check"></i> Add Note
            </button>
        </div>
    </div>
</div>
