<?php
require_once __DIR__ . '/../includes/bootstrap.php';

$counselor_id = $_GET['id'] ?? 1;

// Sample counselor data (would come from database in production)
$counselor = [
    'id' => $counselor_id,
    'name' => 'Sarah Johnson',
    'email' => 'sarah.johnson@globaledpathways.com',
    'role' => ROLE_COUNSELOR,
    'initials' => 'SJ',
    'phone' => '+1 (555) 987-6543',
    'joined' => '2023-06-01',
    'last_active' => '1 hour ago',
    'total_students' => 45,
    'active_students' => 38,
    'success_rate' => '94%',
    'avg_response' => '2.3 hrs',
    'satisfaction' => '4.8/5',
    'specialization' => 'Computer Science & Engineering',
    'languages' => ['English', 'Spanish', 'French'],
    'total_applications' => 142,
    'accepted_applications' => 134
];

$performance_stats = [
    ['icon' => 'fa-users', 'value' => '45', 'label' => 'Total Students', 'color' => '#667eea', 'color_dark' => '#5568d3'],
    ['icon' => 'fa-check-circle', 'value' => '94%', 'label' => 'Success Rate', 'color' => '#32d296', 'color_dark' => '#28b67f'],
    ['icon' => 'fa-clock', 'value' => '2.3 hrs', 'label' => 'Avg Response', 'color' => '#faa05a', 'color_dark' => '#f48939'],
    ['icon' => 'fa-star', 'value' => '4.8/5', 'label' => 'Satisfaction', 'color' => '#1e87f0', 'color_dark' => '#1b78d6']
];

$assigned_students = [
    ['id' => 1, 'name' => 'John Doe', 'email' => 'john.doe@email.com', 'initials' => 'JD', 'applications' => 3, 'status' => 'active', 'last_contact' => '2 days ago'],
    ['id' => 4, 'name' => 'Emma Wilson', 'email' => 'emma.wilson@email.com', 'initials' => 'EW', 'applications' => 2, 'status' => 'active', 'last_contact' => '1 week ago'],
    ['id' => 5, 'name' => 'David Kim', 'email' => 'david.kim@email.com', 'initials' => 'DK', 'applications' => 1, 'status' => 'pending', 'last_contact' => '3 days ago'],
    ['id' => 8, 'name' => 'Lisa Chen', 'email' => 'lisa.chen@email.com', 'initials' => 'LC', 'applications' => 4, 'status' => 'active', 'last_contact' => '1 day ago']
];

$recent_activity = [
    ['action' => 'Reviewed application for Stanford University', 'student' => 'John Doe', 'time' => '2 hours ago', 'icon' => 'fa-file-alt', 'type' => 'review'],
    ['action' => 'Sent feedback on Statement of Purpose', 'student' => 'Emma Wilson', 'time' => '5 hours ago', 'icon' => 'fa-comment', 'type' => 'feedback'],
    ['action' => 'Scheduled interview preparation session', 'student' => 'Lisa Chen', 'time' => '1 day ago', 'icon' => 'fa-calendar', 'type' => 'meeting'],
    ['action' => 'Approved document submission', 'student' => 'David Kim', 'time' => '2 days ago', 'icon' => 'fa-check-circle', 'type' => 'approval'],
    ['action' => 'Created application roadmap', 'student' => 'John Doe', 'time' => '3 days ago', 'icon' => 'fa-map', 'type' => 'planning']
];

$monthly_performance = [
    ['month' => 'Jul', 'students' => 32, 'applications' => 18, 'success' => 91],
    ['month' => 'Aug', 'students' => 35, 'applications' => 22, 'success' => 92],
    ['month' => 'Sep', 'students' => 38, 'applications' => 25, 'success' => 93],
    ['month' => 'Oct', 'students' => 40, 'applications' => 28, 'success' => 93],
    ['month' => 'Nov', 'students' => 42, 'applications' => 31, 'success' => 94],
    ['month' => 'Dec', 'students' => 45, 'applications' => 34, 'success' => 94]
];

$university_breakdown = [
    ['university' => 'Stanford University', 'applications' => 28, 'accepted' => 26, 'rate' => '93%'],
    ['university' => 'MIT', 'applications' => 24, 'accepted' => 23, 'rate' => '96%'],
    ['university' => 'Harvard University', 'applications' => 22, 'accepted' => 20, 'rate' => '91%'],
    ['university' => 'UC Berkeley', 'applications' => 20, 'accepted' => 19, 'rate' => '95%'],
    ['university' => 'Yale University', 'applications' => 18, 'accepted' => 16, 'rate' => '89%']
];

$status_colors = [
    'active' => 'success',
    'pending' => 'warning',
    'inactive' => 'secondary'
];
?>

<style>
.back-link {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    color: #64748b;
    text-decoration: none;
    font-size: 14px;
    font-weight: 500;
    margin-bottom: 24px;
    transition: all 0.2s ease;
}

.back-link:hover {
    color: #667eea;
    text-decoration: none;
}

.counselor-header-card {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border-radius: 12px;
    padding: 32px;
    color: white;
    margin-bottom: 24px;
    box-shadow: 0 4px 16px rgba(102, 126, 234, 0.2);
}

.counselor-avatar-large {
    width: 80px;
    height: 80px;
    border-radius: 50%;
    background: rgba(255, 255, 255, 0.2);
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 32px;
    font-weight: 600;
    color: white;
    border: 3px solid rgba(255, 255, 255, 0.3);
}

.counselor-name {
    font-size: 28px;
    font-weight: 700;
    margin: 0;
    color: white;
}

.counselor-email {
    font-size: 14px;
    color: rgba(255, 255, 255, 0.9);
    margin-top: 4px;
}

.counselor-badge {
    display: inline-block;
    padding: 6px 12px;
    border-radius: 6px;
    font-size: 12px;
    font-weight: 600;
    margin-right: 8px;
    margin-top: 12px;
    background: rgba(255, 255, 255, 0.2);
}

.modern-btn {
    padding: 10px 20px;
    border-radius: 8px;
    font-size: 14px;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.2s ease;
    display: inline-flex;
    align-items: center;
    gap: 8px;
    border: none;
}

.modern-btn-white {
    background: white;
    color: #667eea;
}

.modern-btn-white:hover {
    transform: translateY(-1px);
    box-shadow: 0 4px 12px rgba(255, 255, 255, 0.3);
}

.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 16px;
    margin-bottom: 24px;
}

.perf-stat-card {
    border-radius: 12px;
    padding: 20px;
    background: white;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    transition: all 0.3s ease;
}

.perf-stat-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 16px rgba(0, 0, 0, 0.12);
}

.stat-icon-small {
    width: 40px;
    height: 40px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 18px;
    margin-bottom: 12px;
}

.stat-value-small {
    font-size: 24px;
    font-weight: 700;
    color: #1a1a1a;
    margin-bottom: 4px;
}

.stat-label-small {
    font-size: 13px;
    color: #64748b;
    font-weight: 500;
}

.content-grid {
    display: grid;
    grid-template-columns: 1fr;
    gap: 20px;
    margin-top: 24px;
}

@media (min-width: 1200px) {
    .content-grid {
        grid-template-columns: 2fr 1fr;
    }
}

.modern-card {
    background: white;
    border-radius: 12px;
    padding: 24px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    margin-bottom: 20px;
}

.card-title {
    font-size: 18px;
    font-weight: 600;
    color: #1a1a1a;
    margin-bottom: 20px;
    display: flex;
    align-items: center;
    gap: 8px;
}

.student-item {
    padding: 16px;
    border-radius: 8px;
    background: #f8fafc;
    margin-bottom: 12px;
    transition: all 0.2s ease;
    border: 1px solid #e2e8f0;
    cursor: pointer;
}

.student-item:hover {
    border-color: #667eea;
    background: white;
    box-shadow: 0 2px 8px rgba(102, 126, 234, 0.1);
}

.student-item:last-child {
    margin-bottom: 0;
}

.student-avatar-small {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 600;
    font-size: 14px;
    flex-shrink: 0;
}

.activity-item {
    display: flex;
    gap: 16px;
    padding: 16px;
    border-radius: 8px;
    background: #f8fafc;
    margin-bottom: 12px;
    transition: all 0.2s ease;
}

.activity-item:hover {
    background: white;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
}

.activity-item:last-child {
    margin-bottom: 0;
}

.activity-icon {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 16px;
    flex-shrink: 0;
}

.university-item {
    padding: 16px;
    border-radius: 8px;
    background: #f8fafc;
    margin-bottom: 12px;
    border-left: 4px solid #e2e8f0;
}

.university-item:last-child {
    margin-bottom: 0;
}

.info-list {
    list-style: none;
    padding: 0;
    margin: 0;
}

.info-list dt {
    font-size: 13px;
    color: #64748b;
    font-weight: 500;
    margin-bottom: 4px;
}

.info-list dd {
    font-size: 15px;
    color: #1a1a1a;
    font-weight: 500;
    margin-bottom: 16px;
    margin-left: 0;
}

.info-list dd:last-child {
    margin-bottom: 0;
}

.status-badge {
    padding: 6px 12px;
    border-radius: 6px;
    font-size: 12px;
    font-weight: 600;
    text-transform: uppercase;
}

.status-success {
    background: #d1fae5;
    color: #065f46;
}

.status-warning {
    background: #fef3c7;
    color: #92400e;
}

.status-secondary {
    background: #e2e8f0;
    color: #475569;
}

.language-tag {
    display: inline-block;
    padding: 4px 10px;
    border-radius: 6px;
    background: #f0f4ff;
    color: #667eea;
    font-size: 12px;
    font-weight: 500;
    margin-right: 6px;
    margin-bottom: 6px;
}

.chart-container {
    margin-top: 20px;
    padding-top: 20px;
    border-top: 1px solid #e2e8f0;
}

@media (max-width: 959px) {
    .counselor-header-card {
        padding: 24px;
    }

    .counselor-name {
        font-size: 24px;
    }

    .modern-btn {
        font-size: 13px;
        padding: 8px 16px;
    }

    .stats-grid {
        grid-template-columns: repeat(2, 1fr);
    }
}

@media (max-width: 640px) {
    .counselor-header-card > div {
        flex-direction: column !important;
        align-items: flex-start !important;
    }

    .counselor-header-card > div > div:last-child {
        width: 100%;
        margin-top: 16px;
    }

    .modern-btn {
        width: 100%;
        justify-content: center;
    }
}
</style>

<a href="<?= BASE_URL ?>/index.php"
   hx-get="<?= BASE_URL ?>/pages/reports.php"
   hx-target="#main-content"
   hx-swap="innerHTML"
   hx-push-url="<?= BASE_URL ?>/reports.php"
   class="back-link">
    <i class="fa-slab fa-solid fa-arrow-left"></i> Back to Reports
</a>

<!-- Counselor Header -->
<div class="counselor-header-card">
    <div style="display: flex; justify-content: space-between; align-items: center;">
        <div style="display: flex; align-items: center; gap: 24px;">
            <div class="counselor-avatar-large"><?= $counselor['initials'] ?></div>
            <div>
                <h2 class="counselor-name"><?= e($counselor['name']) ?></h2>
                <div class="counselor-email"><?= e($counselor['email']) ?></div>
                <div>
                    <span class="counselor-badge">Role</span>
                    <span class="counselor-badge"><?= e($counselor['specialization']) ?></span>
                </div>
            </div>
        </div>
        <div style="display: flex; gap: 12px;">
            <button class="modern-btn modern-btn-white">
                <i class="fa-slab fa-solid fa-envelope"></i> Send Message
            </button>
            <button class="modern-btn modern-btn-white">
                <i class="fa-slab fa-solid fa-download"></i> Export Report
            </button>
        </div>
    </div>
</div>

<!-- Performance Stats Grid -->
<div class="stats-grid">
    <?php foreach ($performance_stats as $stat): ?>
    <div class="perf-stat-card">
        <div class="stat-icon-small" style="background: linear-gradient(135deg, <?= $stat['color'] ?> 0%, <?= $stat['color_dark'] ?> 100%);">
            <i class="fa-slab fa-solid <?= $stat['icon'] ?>"></i>
        </div>
        <div class="stat-value-small"><?= e($stat['value']) ?></div>
        <div class="stat-label-small"><?= e($stat['label']) ?></div>
    </div>
    <?php endforeach; ?>
</div>

<!-- Main Content Grid -->
<div class="content-grid">
    <!-- Left Column -->
    <div>
        <!-- Assigned Students -->
        <div class="modern-card">
            <h4 class="card-title">
                <i class="fa-slab fa-solid fa-users"></i> Assigned Students (<?= count($assigned_students) ?>)
            </h4>
            <?php foreach ($assigned_students as $student): ?>
            <div class="student-item"
                 hx-get="<?= BASE_URL ?>/pages/user-detail.php?id=<?= $student['id'] ?>"
                 hx-target="#main-content"
                 hx-swap="innerHTML"
                 hx-push-url="<?= BASE_URL ?>/user-detail.php?id=<?= $student['id'] ?>">
                <div style="display: flex; justify-content: space-between; align-items: center; gap: 12px;">
                    <div style="display: flex; align-items: center; gap: 12px; flex: 1;">
                        <div class="student-avatar-small"><?= $student['initials'] ?></div>
                        <div style="flex: 1; min-width: 0;">
                            <div style="font-weight: 600; color: #1a1a1a; font-size: 15px; margin-bottom: 2px;">
                                <?= e($student['name']) ?>
                            </div>
                            <div style="font-size: 12px; color: #64748b;">
                                <i class="fa-slab fa-solid fa-envelope fa-xs"></i> <?= e($student['email']) ?>
                            </div>
                        </div>
                    </div>
                    <div style="text-align: right;">
                        <div style="font-size: 14px; font-weight: 600; color: #667eea; margin-bottom: 4px;">
                            <?= $student['applications'] ?> <?= $student['applications'] === 1 ? 'app' : 'apps' ?>
                        </div>
                        <span class="status-badge status-<?= $status_colors[$student['status']] ?>">
                            <?= ucfirst($student['status']) ?>
                        </span>
                    </div>
                </div>
                <div style="margin-top: 8px; padding-top: 8px; border-top: 1px solid #e2e8f0; font-size: 12px; color: #94a3b8;">
                    <i class="fa-slab fa-solid fa-clock fa-xs"></i> Last contact: <?= e($student['last_contact']) ?>
                </div>
            </div>
            <?php endforeach; ?>
        </div>

        <!-- University Performance Breakdown -->
        <div class="modern-card">
            <h4 class="card-title">
                <i class="fa-slab fa-solid fa-university"></i> University Performance
            </h4>
            <?php foreach ($university_breakdown as $uni): ?>
            <div class="university-item">
                <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 8px;">
                    <div style="font-weight: 600; color: #1a1a1a; font-size: 15px;">
                        <?= e($uni['university']) ?>
                    </div>
                    <div style="font-weight: 700; color: #32d296; font-size: 16px;">
                        <?= e($uni['rate']) ?>
                    </div>
                </div>
                <div style="font-size: 13px; color: #64748b;">
                    <?= $uni['accepted'] ?> accepted out of <?= $uni['applications'] ?> applications
                </div>
                <div style="margin-top: 8px; height: 4px; background: #e2e8f0; border-radius: 2px; overflow: hidden;">
                    <div style="height: 100%; background: linear-gradient(90deg, #32d296 0%, #28b67f 100%); width: <?= intval($uni['accepted'] / $uni['applications'] * 100) ?>%;"></div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>

        <!-- Recent Activity -->
        <div class="modern-card">
            <h4 class="card-title">
                <i class="fa-slab fa-solid fa-history"></i> Recent Activity
            </h4>
            <?php foreach ($recent_activity as $item): ?>
            <div class="activity-item">
                <div class="activity-icon">
                    <i class="fa-slab fa-solid <?= $item['icon'] ?>"></i>
                </div>
                <div style="flex: 1;">
                    <div style="font-size: 14px; color: #1a1a1a; font-weight: 500;"><?= e($item['action']) ?></div>
                    <div style="font-size: 12px; color: #94a3b8; margin-top: 2px;">
                        <?= e($item['student']) ?> • <?= e($item['time']) ?>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>

        <!-- Performance Chart -->
        <div class="modern-card">
            <h4 class="card-title">
                <i class="fa-slab fa-solid fa-chart-line"></i> Performance Trend
            </h4>
            <div id="performance-chart" style="height: 300px;"></div>
        </div>
    </div>

    <!-- Right Column -->
    <div>
        <!-- Counselor Information -->
        <div class="modern-card">
            <h4 class="card-title">
                <i class="fa-slab fa-solid fa-info-circle"></i> Counselor Information
            </h4>
            <dl class="info-list">
                <dt>Phone Number</dt>
                <dd><i class="fa-slab fa-solid fa-phone fa-sm"></i> <?= e($counselor['phone']) ?></dd>

                <dt>Email Address</dt>
                <dd><i class="fa-slab fa-solid fa-envelope fa-sm"></i> <?= e($counselor['email']) ?></dd>

                <dt>Specialization</dt>
                <dd><i class="fa-slab fa-solid fa-graduation-cap fa-sm"></i> <?= e($counselor['specialization']) ?></dd>

                <dt>Languages</dt>
                <dd>
                    <?php foreach ($counselor['languages'] as $lang): ?>
                        <span class="language-tag"><?= e($lang) ?></span>
                    <?php endforeach; ?>
                </dd>

                <dt>Member Since</dt>
                <dd><i class="fa-slab fa-solid fa-calendar-plus fa-sm"></i> <?= date('M d, Y', strtotime($counselor['joined'])) ?></dd>

                <dt>Last Active</dt>
                <dd><i class="fa-slab fa-solid fa-clock fa-sm"></i> <?= e($counselor['last_active']) ?></dd>

                <dt>Counselor ID</dt>
                <dd><code style="background: #f8fafc; padding: 4px 8px; border-radius: 4px; font-size: 13px;">#<?= e($counselor['id']) ?></code></dd>
            </dl>
        </div>

        <!-- Key Metrics -->
        <div class="modern-card">
            <h4 class="card-title">
                <i class="fa-slab fa-solid fa-chart-bar"></i> Key Metrics
            </h4>
            <dl class="info-list">
                <dt>Total Students Managed</dt>
                <dd style="color: #667eea; font-size: 20px;"><?= $counselor['total_students'] ?></dd>

                <dt>Currently Active</dt>
                <dd style="color: #32d296; font-size: 20px;"><?= $counselor['active_students'] ?></dd>

                <dt>Total Applications Handled</dt>
                <dd><?= $counselor['total_applications'] ?> applications</dd>

                <dt>Applications Accepted</dt>
                <dd style="color: #32d296;"><?= $counselor['accepted_applications'] ?> (<?= round($counselor['accepted_applications'] / $counselor['total_applications'] * 100, 1) ?>%)</dd>

                <dt>Average Response Time</dt>
                <dd><?= e($counselor['avg_response']) ?></dd>

                <dt>Student Satisfaction</dt>
                <dd>
                    <span style="color: #faa05a; font-size: 18px;"><?= e($counselor['satisfaction']) ?></span>
                    <span style="color: #94a3b8; font-size: 12px;">⭐⭐⭐⭐⭐</span>
                </dd>
            </dl>
        </div>

        <!-- Actions -->
        <div class="modern-card">
            <h4 class="card-title">
                <i class="fa-slab fa-solid fa-cog"></i> Actions
            </h4>
            <div style="display: flex; flex-direction: column; gap: 8px;">
                <button class="uk-button uk-button-default uk-width-1-1" style="justify-content: flex-start;">
                    <i class="fa-slab fa-solid fa-envelope fa-fw"></i> Send Message
                </button>
                <button class="uk-button uk-button-default uk-width-1-1" style="justify-content: flex-start;">
                    <i class="fa-slab fa-solid fa-calendar fa-fw"></i> Schedule Meeting
                </button>
                <button class="uk-button uk-button-default uk-width-1-1" style="justify-content: flex-start;">
                    <i class="fa-slab fa-solid fa-users fa-fw"></i> View All Students
                </button>
                <button class="uk-button uk-button-default uk-width-1-1" style="justify-content: flex-start;">
                    <i class="fa-slab fa-solid fa-download fa-fw"></i> Export Full Report
                </button>
                <hr style="margin: 8px 0;">
                <button class="uk-button uk-button-default uk-width-1-1" style="justify-content: flex-start;">
                    <i class="fa-slab fa-solid fa-user-edit fa-fw"></i> Edit Profile
                </button>
            </div>
        </div>
    </div>
</div>

<!-- ApexCharts Script -->
<script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Performance Trend Chart
    var performanceOptions = {
        series: [{
            name: 'Students',
            data: <?= json_encode(array_column($monthly_performance, 'students')) ?>
        }, {
            name: 'Applications',
            data: <?= json_encode(array_column($monthly_performance, 'applications')) ?>
        }, {
            name: 'Success Rate',
            data: <?= json_encode(array_column($monthly_performance, 'success')) ?>
        }],
        chart: {
            height: 300,
            type: 'line',
            zoom: { enabled: false },
            toolbar: { show: false }
        },
        dataLabels: { enabled: false },
        stroke: {
            width: [3, 3, 3],
            curve: 'smooth'
        },
        colors: ['#667eea', '#32d296', '#faa05a'],
        xaxis: {
            categories: <?= json_encode(array_column($monthly_performance, 'month')) ?>
        },
        yaxis: [
            {
                title: { text: 'Students / Applications' },
                min: 0
            },
            {
                opposite: true,
                title: { text: 'Success Rate (%)' },
                min: 85,
                max: 100
            }
        ],
        legend: {
            position: 'top',
            horizontalAlign: 'left'
        }
    };

    var performanceChart = new ApexCharts(document.querySelector("#performance-chart"), performanceOptions);
    performanceChart.render();
});

// Re-initialize UIKit components after HTMX load
if (typeof UIkit !== 'undefined') {
    UIkit.update();
}
</script>
