<?php
require_once __DIR__ . '/../includes/bootstrap.php';
?>

<h3 class="uk-margin-bottom">Help & Support</h3>

<div class="uk-grid-small" uk-grid>
    <div class="uk-width-2-3@m">
        <div class="uk-card uk-card-default uk-card-body">
            <h4 class="uk-card-title">Frequently Asked Questions</h4>

            <ul uk-accordion>
                <li class="uk-open">
                    <a class="uk-accordion-title" href="#">How do I add a new user?</a>
                    <div class="uk-accordion-content">
                        <p>Navigate to the Users page and click the "Add User" button. Fill in the required information including name, email, and role, then click "Create User".</p>
                    </div>
                </li>
                <li>
                    <a class="uk-accordion-title" href="#">How do I export reports?</a>
                    <div class="uk-accordion-content">
                        <p>Go to the Reports page, select your desired filters and date range, then click the "Export" button. You can export in PDF, Excel, or CSV format.</p>
                    </div>
                </li>
                <li>
                    <a class="uk-accordion-title" href="#">How do I manage user permissions?</a>
                    <div class="uk-accordion-content">
                        <p>Click on a user in the Users list to view their details. In the user detail page, you can modify their role and specific permissions.</p>
                    </div>
                </li>
                <li>
                    <a class="uk-accordion-title" href="#">How do I send bulk emails?</a>
                    <div class="uk-accordion-content">
                        <p>Use the Mailing page to create email campaigns. You can select recipients by role, status, or create custom lists.</p>
                    </div>
                </li>
            </ul>
        </div>

        <div class="uk-card uk-card-default uk-card-body uk-margin-top">
            <h4 class="uk-card-title">Contact Support</h4>
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Subject</label>
                    <input class="uk-input" type="text" placeholder="Brief description of your issue">
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Category</label>
                    <select class="uk-select">
                        <option>Technical Issue</option>
                        <option>Billing Question</option>
                        <option>Feature Request</option>
                        <option>General Inquiry</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Priority</label>
                    <select class="uk-select">
                        <option>Low</option>
                        <option selected>Normal</option>
                        <option>High</option>
                        <option>Urgent</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Description</label>
                    <textarea class="uk-textarea" rows="5" placeholder="Please describe your issue in detail..."></textarea>
                </div>
                <button class="uk-button uk-button-primary">Submit Ticket</button>
            </form>
        </div>
    </div>

    <div class="uk-width-1-3@m">
        <div class="uk-card uk-card-default uk-card-body">
            <h5 class="uk-card-title">Quick Links</h5>
            <ul class="uk-list">
                <li><a href="#"><span uk-icon="icon: file-text; ratio: 0.8" class="uk-margin-small-right"></span> Documentation</a></li>
                <li><a href="#"><span uk-icon="icon: video-camera; ratio: 0.8" class="uk-margin-small-right"></span> Video Tutorials</a></li>
                <li><a href="#"><span uk-icon="icon: git-branch; ratio: 0.8" class="uk-margin-small-right"></span> Release Notes</a></li>
                <li><a href="#"><span uk-icon="icon: lifesaver; ratio: 0.8" class="uk-margin-small-right"></span> System Status</a></li>
            </ul>
        </div>

        <div class="uk-card uk-card-default uk-card-body uk-margin-top">
            <h5 class="uk-card-title">Contact Information</h5>
            <dl class="uk-description-list">
                <dt>Email</dt>
                <dd>support@globaledpathways.com</dd>
                <dt>Phone</dt>
                <dd>+1 (800) 123-4567</dd>
                <dt>Hours</dt>
                <dd>Mon-Fri 9AM-6PM ET</dd>
            </dl>
        </div>

        <div class="uk-card uk-card-default uk-card-body uk-margin-top">
            <h5 class="uk-card-title">Recent Tickets</h5>
            <div class="uk-text-small">
                <div class="uk-margin-small-bottom">
                    <div class="uk-text-bold">#1234 - Export issue</div>
                    <div class="uk-text-muted">Resolved - 2 days ago</div>
                </div>
                <div class="uk-margin-small-bottom">
                    <div class="uk-text-bold">#1198 - Login problems</div>
                    <div class="uk-text-muted">Resolved - 1 week ago</div>
                </div>
            </div>
        </div>
    </div>
</div>
