<?php
require_once __DIR__ . '/../includes/bootstrap.php';

$stats = [
    ['icon' => 'mail', 'value' => '4,567', 'label' => 'Sent This Month', 'color' => 'primary'],
    ['icon' => 'check', 'value' => '78.5%', 'label' => 'Open Rate', 'color' => 'success'],
    ['icon' => 'link', 'value' => '23.4%', 'label' => 'Click Rate', 'color' => 'warning'],
    ['icon' => 'users', 'value' => '2,456', 'label' => 'Subscribers', 'color' => 'secondary']
];

$templates = [
    ['id' => 1, 'name' => 'Welcome Email', 'category' => 'Onboarding', 'last_used' => '2024-01-28'],
    ['id' => 2, 'name' => 'Newsletter', 'category' => 'Marketing', 'last_used' => '2024-01-15'],
    ['id' => 3, 'name' => 'Payment Reminder', 'category' => 'Transactional', 'last_used' => '2024-01-30'],
    ['id' => 4, 'name' => 'Application Update', 'category' => 'Notification', 'last_used' => '2024-01-25']
];

$queued = [
    ['subject' => 'February Newsletter', 'recipients' => 2456, 'scheduled' => '2024-02-01 10:00', 'status' => 'scheduled'],
    ['subject' => 'Deadline Reminder', 'recipients' => 890, 'scheduled' => '2024-02-05 09:00', 'status' => 'scheduled']
];

$recent = [
    ['subject' => 'January Newsletter', 'recipients' => 2456, 'sent' => '2024-01-15', 'opens' => '74.2%', 'clicks' => '21.3%'],
    ['subject' => 'Application Tips', 'recipients' => 1234, 'sent' => '2024-01-20', 'opens' => '80.1%', 'clicks' => '28.5%'],
    ['subject' => 'Holiday Greetings', 'recipients' => 2456, 'sent' => '2023-12-22', 'opens' => '65.8%', 'clicks' => '12.4%']
];

$lists = [
    ['name' => 'All Users', 'count' => 2456, 'growth' => '+12'],
    ['name' => 'Students', 'count' => 2300, 'growth' => '+8'],
    ['name' => 'Counselors', 'count' => 34, 'growth' => '+2'],
    ['name' => 'Active Applications', 'count' => 890, 'growth' => '+45'],
    ['name' => 'Inactive Users', 'count' => 122, 'growth' => '-5']
];

render_stat_cards($stats, 4);
?>

<ul class="uk-subnav uk-subnav-pill uk-margin-top" uk-switcher="animation: uk-animation-fade">
    <li class="uk-active"><a href="#">Dashboard</a></li>
    <li><a href="#">Compose</a></li>
    <li><a href="#">Templates</a></li>
    <li><a href="#">Lists</a></li>
    <li><a href="#">Automations</a></li>
    <li><a href="#">Analytics</a></li>
</ul>

<ul class="uk-switcher uk-margin">
    <!-- Dashboard Tab -->
    <li>
        <div class="uk-grid-small" uk-grid>
            <div class="uk-width-2-3@m">
                <!-- Queued Emails -->
                <div class="uk-card uk-card-default uk-card-body uk-margin-bottom">
                    <h4 class="uk-card-title">Queued Emails</h4>
                    <?php if (empty($queued)): ?>
                        <p class="uk-text-muted">No emails in queue</p>
                    <?php else: ?>
                        <?php foreach ($queued as $email): ?>
                        <div class="uk-card uk-card-secondary uk-card-body uk-card-small uk-margin-small-bottom">
                            <div class="uk-flex uk-flex-between uk-flex-middle">
                                <div>
                                    <div class="uk-text-bold"><?= e($email['subject']) ?></div>
                                    <div class="uk-text-small"><?= number_format($email['recipients']) ?> recipients</div>
                                </div>
                                <div class="uk-text-right">
                                    <div class="uk-text-small"><?= e($email['scheduled']) ?></div>
                                    <span class="uk-label uk-label-warning"><?= e($email['status']) ?></span>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>

                <!-- Recent Campaigns -->
                <div class="uk-card uk-card-default uk-card-body">
                    <h4 class="uk-card-title">Recent Campaigns</h4>
                    <table class="uk-table uk-table-divider uk-table-small">
                        <thead>
                            <tr><th>Subject</th><th>Recipients</th><th>Sent</th><th>Opens</th><th>Clicks</th></tr>
                        </thead>
                        <tbody>
                            <?php foreach ($recent as $campaign): ?>
                            <tr>
                                <td class="uk-text-bold"><?= e($campaign['subject']) ?></td>
                                <td><?= number_format($campaign['recipients']) ?></td>
                                <td><?= e($campaign['sent']) ?></td>
                                <td class="uk-text-success"><?= e($campaign['opens']) ?></td>
                                <td class="uk-text-primary"><?= e($campaign['clicks']) ?></td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="uk-width-1-3@m">
                <!-- Quick Actions -->
                <div class="uk-card uk-card-default uk-card-body uk-margin-bottom">
                    <h4 class="uk-card-title">Quick Actions</h4>
                    <button class="uk-button uk-button-primary uk-width-1-1 uk-margin-small-bottom" uk-toggle="target: #new-campaign-modal">
                        <span uk-icon="icon: plus; ratio: 0.8"></span> New Campaign
                    </button>
                    <button class="uk-button uk-button-default uk-width-1-1 uk-margin-small-bottom" uk-toggle="target: #quick-send-modal">
                        <span uk-icon="icon: mail; ratio: 0.8"></span> Quick Send
                    </button>
                    <button class="uk-button uk-button-default uk-width-1-1" uk-toggle="target: #new-template-modal">
                        <span uk-icon="icon: file-text; ratio: 0.8"></span> New Template
                    </button>
                </div>

                <!-- Subscriber Lists -->
                <div class="uk-card uk-card-default uk-card-body">
                    <h4 class="uk-card-title">Subscriber Lists</h4>
                    <?php foreach ($lists as $list): ?>
                    <div class="uk-flex uk-flex-between uk-margin-small-bottom">
                        <span><?= e($list['name']) ?></span>
                        <span>
                            <?= number_format($list['count']) ?>
                            <span class="uk-text-small <?= strpos($list['growth'], '+') === 0 ? 'uk-text-success' : 'uk-text-danger' ?>">
                                <?= e($list['growth']) ?>
                            </span>
                        </span>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </li>

    <!-- Compose Tab -->
    <li>
        <div class="uk-card uk-card-default uk-card-body">
            <form class="uk-form-stacked">
                <div class="uk-grid-small" uk-grid>
                    <div class="uk-width-2-3@m">
                        <div class="uk-margin">
                            <label class="uk-form-label">To *</label>
                            <select class="uk-select" required>
                                <option value="">Select recipients...</option>
                                <option>All Users (2,456)</option>
                                <option>Students Only (2,300)</option>
                                <option>Counselors Only (34)</option>
                                <option>Active Applications (890)</option>
                                <option>Custom Segment...</option>
                            </select>
                        </div>
                        <div class="uk-margin">
                            <label class="uk-form-label">Subject *</label>
                            <input class="uk-input" type="text" placeholder="Email subject line" required>
                        </div>
                        <div class="uk-margin">
                            <label class="uk-form-label">Content *</label>
                            <div class="uk-button-group uk-margin-small-bottom">
                                <button type="button" class="uk-button uk-button-default uk-button-small" onclick="document.execCommand('bold')"><strong>B</strong></button>
                                <button type="button" class="uk-button uk-button-default uk-button-small" onclick="document.execCommand('italic')"><em>I</em></button>
                                <button type="button" class="uk-button uk-button-default uk-button-small" onclick="document.execCommand('underline')"><u>U</u></button>
                                <button type="button" class="uk-button uk-button-default uk-button-small" onclick="document.execCommand('insertUnorderedList')">List</button>
                                <button type="button" class="uk-button uk-button-default uk-button-small" onclick="document.execCommand('createLink', false, prompt('URL:'))">Link</button>
                                <button type="button" class="uk-button uk-button-default uk-button-small">Image</button>
                            </div>
                            <div contenteditable="true" class="uk-textarea" style="min-height: 300px;">
                                <p>Dear {{name}},</p>
                                <p>Your email content here...</p>
                            </div>
                        </div>
                    </div>
                    <div class="uk-width-1-3@m">
                        <div class="uk-margin">
                            <label class="uk-form-label">From Name</label>
                            <input class="uk-input" type="text" value="GlobalEd Pathways">
                        </div>
                        <div class="uk-margin">
                            <label class="uk-form-label">Reply-To</label>
                            <input class="uk-input" type="email" value="support@globaledpathways.com">
                        </div>
                        <div class="uk-margin">
                            <label class="uk-form-label">Schedule</label>
                            <select class="uk-select">
                                <option>Send Now</option>
                                <option>Schedule for Later</option>
                            </select>
                        </div>
                        <hr>
                        <h5>Personalization Tags</h5>
                        <div class="uk-text-small">
                            <code class="uk-display-block uk-margin-small-bottom">{{name}}</code>
                            <code class="uk-display-block uk-margin-small-bottom">{{email}}</code>
                            <code class="uk-display-block uk-margin-small-bottom">{{role}}</code>
                        </div>
                        <hr>
                        <div class="uk-margin">
                            <label><input class="uk-checkbox" type="checkbox" checked> Track opens</label>
                        </div>
                        <div class="uk-margin">
                            <label><input class="uk-checkbox" type="checkbox" checked> Track clicks</label>
                        </div>
                    </div>
                </div>
                <div class="uk-margin-top">
                    <button class="uk-button uk-button-primary" type="submit">Send Email</button>
                    <button class="uk-button uk-button-default" type="button">Save Draft</button>
                    <button class="uk-button uk-button-default" type="button">Preview</button>
                </div>
            </form>
        </div>
    </li>

    <!-- Templates Tab -->
    <li>
        <div class="uk-flex uk-flex-between uk-flex-middle uk-margin-bottom">
            <h4 class="uk-margin-remove">Email Templates</h4>
            <button class="uk-button uk-button-primary uk-button-small" uk-toggle="target: #new-template-modal">
                <span uk-icon="icon: plus; ratio: 0.8"></span> New Template
            </button>
        </div>
        <div class="uk-grid-small uk-child-width-1-4@m uk-child-width-1-2@s" uk-grid>
            <?php foreach ($templates as $tpl): ?>
            <div>
                <div class="uk-card uk-card-default uk-card-body uk-card-small">
                    <div class="uk-card-badge uk-label"><?= e($tpl['category']) ?></div>
                    <h5 class="uk-card-title uk-margin-remove-bottom"><?= e($tpl['name']) ?></h5>
                    <p class="uk-text-meta uk-margin-small-top">Last used: <?= e($tpl['last_used']) ?></p>
                    <div class="uk-margin-top uk-flex uk-flex-between uk-flex-middle">
                        <div>
                            <a href="#" class="uk-button uk-button-text uk-margin-small-right">Edit</a>
                            <a href="#" class="uk-button uk-button-text">Preview</a>
                        </div>
                        <a href="#" uk-icon="icon: more-vertical; ratio: 0.8"></a>
                        <div uk-dropdown="mode: click; pos: bottom-right">
                            <ul class="uk-nav uk-dropdown-nav">
                                <li class="uk-nav-header">Actions</li>
                                <li><a href="#" uk-toggle="target: #edit-template-modal"><span uk-icon="icon: pencil; ratio: 0.8" class="uk-margin-small-right"></span> Edit</a></li>
                                <li><a href="#" uk-toggle="target: #preview-template-modal"><span uk-icon="icon: eye; ratio: 0.8" class="uk-margin-small-right"></span> Preview</a></li>
                                <li><a href="#" uk-toggle="target: #use-template-modal"><span uk-icon="icon: mail; ratio: 0.8" class="uk-margin-small-right"></span> Use for Campaign</a></li>
                                <li><a href="#"><span uk-icon="icon: copy; ratio: 0.8" class="uk-margin-small-right"></span> Duplicate</a></li>
                                <li class="uk-nav-divider"></li>
                                <li><a href="#" class="uk-text-danger" uk-toggle="target: #delete-template-modal"><span uk-icon="icon: trash; ratio: 0.8" class="uk-margin-small-right"></span> Delete</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </li>

    <!-- Lists Tab -->
    <li>
        <div class="uk-flex uk-flex-between uk-flex-middle uk-margin-bottom">
            <h4 class="uk-margin-remove">Subscriber Lists</h4>
            <button class="uk-button uk-button-primary uk-button-small" uk-toggle="target: #create-list-modal">
                <span uk-icon="icon: plus; ratio: 0.8"></span> Create List
            </button>
        </div>
        <div class="uk-card uk-card-default uk-card-body">
            <table class="uk-table uk-table-divider uk-table-hover">
                <thead>
                    <tr><th>List Name</th><th>Subscribers</th><th>Growth</th><th>Created</th><th></th></tr>
                </thead>
                <tbody>
                    <?php foreach ($lists as $list): ?>
                    <tr>
                        <td class="uk-text-bold"><?= e($list['name']) ?></td>
                        <td><?= number_format($list['count']) ?></td>
                        <td class="<?= strpos($list['growth'], '+') === 0 ? 'uk-text-success' : 'uk-text-danger' ?>"><?= e($list['growth']) ?></td>
                        <td>2024-01-01</td>
                        <td>
                            <a href="#" uk-icon="icon: more-vertical; ratio: 0.8"></a>
                            <div uk-dropdown="mode: click; pos: bottom-right">
                                <ul class="uk-nav uk-dropdown-nav">
                                    <li class="uk-nav-header">Actions</li>
                                    <li><a href="#" uk-toggle="target: #view-subscribers-modal"><span uk-icon="icon: users; ratio: 0.8" class="uk-margin-small-right"></span> View Subscribers</a></li>
                                    <li><a href="#" uk-toggle="target: #edit-list-modal"><span uk-icon="icon: pencil; ratio: 0.8" class="uk-margin-small-right"></span> Edit List</a></li>
                                    <li><a href="#" uk-toggle="target: #add-subscribers-modal"><span uk-icon="icon: plus; ratio: 0.8" class="uk-margin-small-right"></span> Add Subscribers</a></li>
                                    <li><a href="#"><span uk-icon="icon: download; ratio: 0.8" class="uk-margin-small-right"></span> Export</a></li>
                                    <li><a href="#"><span uk-icon="icon: copy; ratio: 0.8" class="uk-margin-small-right"></span> Duplicate</a></li>
                                    <li class="uk-nav-divider"></li>
                                    <li><a href="#" class="uk-text-danger" uk-toggle="target: #delete-list-modal"><span uk-icon="icon: trash; ratio: 0.8" class="uk-margin-small-right"></span> Delete</a></li>
                                </ul>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </li>

    <!-- Automations Tab -->
    <li>
        <div class="uk-flex uk-flex-between uk-flex-middle uk-margin-bottom">
            <h4 class="uk-margin-remove">Email Automations</h4>
            <button class="uk-button uk-button-primary uk-button-small" uk-toggle="target: #new-automation-modal">
                <span uk-icon="icon: plus; ratio: 0.8"></span> New Automation
            </button>
        </div>
        <div class="uk-card uk-card-default uk-card-body">
            <div class="uk-card uk-card-secondary uk-card-body uk-card-small uk-margin-small-bottom">
                <div class="uk-flex uk-flex-between uk-flex-middle">
                    <div>
                        <div class="uk-text-bold">Welcome Series</div>
                        <div class="uk-text-small">Triggered: New user registration</div>
                    </div>
                    <div class="uk-flex uk-flex-middle">
                        <span class="uk-label uk-label-success">Active</span>
                        <span class="uk-margin-small-left uk-margin-small-right">3 emails</span>
                        <a href="#" uk-icon="icon: more-vertical; ratio: 0.8"></a>
                        <div uk-dropdown="mode: click; pos: bottom-right">
                            <ul class="uk-nav uk-dropdown-nav">
                                <li class="uk-nav-header">Actions</li>
                                <li><a href="#"><span uk-icon="icon: pencil; ratio: 0.8" class="uk-margin-small-right"></span> Edit</a></li>
                                <li><a href="#"><span uk-icon="icon: ban; ratio: 0.8" class="uk-margin-small-right"></span> Pause</a></li>
                                <li><a href="#"><span uk-icon="icon: chart; ratio: 0.8" class="uk-margin-small-right"></span> View Stats</a></li>
                                <li><a href="#"><span uk-icon="icon: copy; ratio: 0.8" class="uk-margin-small-right"></span> Duplicate</a></li>
                                <li class="uk-nav-divider"></li>
                                <li><a href="#" class="uk-text-danger"><span uk-icon="icon: trash; ratio: 0.8" class="uk-margin-small-right"></span> Delete</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            <div class="uk-card uk-card-secondary uk-card-body uk-card-small uk-margin-small-bottom">
                <div class="uk-flex uk-flex-between uk-flex-middle">
                    <div>
                        <div class="uk-text-bold">Payment Reminder</div>
                        <div class="uk-text-small">Triggered: 3 days before due date</div>
                    </div>
                    <div class="uk-flex uk-flex-middle">
                        <span class="uk-label uk-label-success">Active</span>
                        <span class="uk-margin-small-left uk-margin-small-right">1 email</span>
                        <a href="#" uk-icon="icon: more-vertical; ratio: 0.8"></a>
                        <div uk-dropdown="mode: click; pos: bottom-right">
                            <ul class="uk-nav uk-dropdown-nav">
                                <li class="uk-nav-header">Actions</li>
                                <li><a href="#"><span uk-icon="icon: pencil; ratio: 0.8" class="uk-margin-small-right"></span> Edit</a></li>
                                <li><a href="#"><span uk-icon="icon: ban; ratio: 0.8" class="uk-margin-small-right"></span> Pause</a></li>
                                <li><a href="#"><span uk-icon="icon: chart; ratio: 0.8" class="uk-margin-small-right"></span> View Stats</a></li>
                                <li><a href="#"><span uk-icon="icon: copy; ratio: 0.8" class="uk-margin-small-right"></span> Duplicate</a></li>
                                <li class="uk-nav-divider"></li>
                                <li><a href="#" class="uk-text-danger"><span uk-icon="icon: trash; ratio: 0.8" class="uk-margin-small-right"></span> Delete</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            <div class="uk-card uk-card-secondary uk-card-body uk-card-small">
                <div class="uk-flex uk-flex-between uk-flex-middle">
                    <div>
                        <div class="uk-text-bold">Application Status Update</div>
                        <div class="uk-text-small">Triggered: Status change</div>
                    </div>
                    <div class="uk-flex uk-flex-middle">
                        <span class="uk-label uk-label-warning">Paused</span>
                        <span class="uk-margin-small-left uk-margin-small-right">1 email</span>
                        <a href="#" uk-icon="icon: more-vertical; ratio: 0.8"></a>
                        <div uk-dropdown="mode: click; pos: bottom-right">
                            <ul class="uk-nav uk-dropdown-nav">
                                <li class="uk-nav-header">Actions</li>
                                <li><a href="#"><span uk-icon="icon: pencil; ratio: 0.8" class="uk-margin-small-right"></span> Edit</a></li>
                                <li><a href="#"><span uk-icon="icon: play; ratio: 0.8" class="uk-margin-small-right"></span> Resume</a></li>
                                <li><a href="#"><span uk-icon="icon: chart; ratio: 0.8" class="uk-margin-small-right"></span> View Stats</a></li>
                                <li><a href="#"><span uk-icon="icon: copy; ratio: 0.8" class="uk-margin-small-right"></span> Duplicate</a></li>
                                <li class="uk-nav-divider"></li>
                                <li><a href="#" class="uk-text-danger"><span uk-icon="icon: trash; ratio: 0.8" class="uk-margin-small-right"></span> Delete</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </li>

    <!-- Analytics Tab -->
    <li>
        <div class="uk-grid-small" uk-grid>
            <div class="uk-width-1-2@m">
                <div class="uk-card uk-card-default uk-card-body">
                    <h4 class="uk-card-title">Performance Overview</h4>
                    <div class="uk-margin">
                        <div class="uk-flex uk-flex-between uk-margin-small-bottom">
                            <span>Delivery Rate</span>
                            <span class="uk-text-bold">98.5%</span>
                        </div>
                        <progress class="uk-progress uk-progress-success" value="98.5" max="100"></progress>
                    </div>
                    <div class="uk-margin">
                        <div class="uk-flex uk-flex-between uk-margin-small-bottom">
                            <span>Open Rate</span>
                            <span class="uk-text-bold">78.5%</span>
                        </div>
                        <progress class="uk-progress uk-progress-primary" value="78.5" max="100"></progress>
                    </div>
                    <div class="uk-margin">
                        <div class="uk-flex uk-flex-between uk-margin-small-bottom">
                            <span>Click Rate</span>
                            <span class="uk-text-bold">23.4%</span>
                        </div>
                        <progress class="uk-progress uk-progress-warning" value="23.4" max="100"></progress>
                    </div>
                    <div class="uk-margin">
                        <div class="uk-flex uk-flex-between uk-margin-small-bottom">
                            <span>Unsubscribe Rate</span>
                            <span class="uk-text-bold">0.8%</span>
                        </div>
                        <progress class="uk-progress uk-progress-danger" value="0.8" max="100"></progress>
                    </div>
                </div>
            </div>
            <div class="uk-width-1-2@m">
                <div class="uk-card uk-card-default uk-card-body">
                    <h4 class="uk-card-title">Top Performing Emails</h4>
                    <ol class="uk-list">
                        <li><strong>Application Tips</strong> - 80.1% open rate</li>
                        <li><strong>Interview Prep Guide</strong> - 78.9% open rate</li>
                        <li><strong>Deadline Reminder</strong> - 76.2% open rate</li>
                        <li><strong>January Newsletter</strong> - 74.2% open rate</li>
                    </ol>
                </div>
            </div>
        </div>
    </li>
</ul>

<!-- New Campaign Modal -->
<div id="new-campaign-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">New Email Campaign</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Campaign Name *</label>
                    <input class="uk-input" type="text" placeholder="e.g., February Newsletter" required>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Recipients *</label>
                    <select class="uk-select" required>
                        <option value="">Select list...</option>
                        <option>All Users (2,456)</option>
                        <option>Students Only (2,300)</option>
                        <option>Counselors Only (34)</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Template</label>
                    <select class="uk-select">
                        <option value="">Start from scratch</option>
                        <option>Newsletter</option>
                        <option>Welcome Email</option>
                        <option>Payment Reminder</option>
                    </select>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Create Campaign</button>
        </div>
    </div>
</div>

<!-- Quick Send Modal -->
<div id="quick-send-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Quick Send</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">To *</label>
                    <input class="uk-input" type="email" placeholder="recipient@email.com" required>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Subject *</label>
                    <input class="uk-input" type="text" placeholder="Email subject" required>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Message *</label>
                    <textarea class="uk-textarea" rows="5" placeholder="Your message..." required></textarea>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Send</button>
        </div>
    </div>
</div>

<!-- New Template Modal -->
<div id="new-template-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">New Email Template</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Template Name *</label>
                    <input class="uk-input" type="text" placeholder="e.g., Welcome Email" required>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Category *</label>
                    <select class="uk-select" required>
                        <option value="">Select category...</option>
                        <option>Onboarding</option>
                        <option>Marketing</option>
                        <option>Transactional</option>
                        <option>Notification</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Subject Line *</label>
                    <input class="uk-input" type="text" placeholder="Email subject" required>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Create Template</button>
        </div>
    </div>
</div>

<!-- Edit Template Modal -->
<div id="edit-template-modal" uk-modal>
    <div class="uk-modal-dialog uk-width-xlarge">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Edit Template</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-grid-small" uk-grid>
                    <div class="uk-width-1-2">
                        <label class="uk-form-label">Template Name *</label>
                        <input class="uk-input" type="text" value="Welcome Email" required>
                    </div>
                    <div class="uk-width-1-2">
                        <label class="uk-form-label">Category</label>
                        <select class="uk-select">
                            <option selected>Onboarding</option>
                            <option>Marketing</option>
                            <option>Transactional</option>
                        </select>
                    </div>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Subject Line *</label>
                    <input class="uk-input" type="text" value="Welcome to GlobalEd Pathways!" required>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Content</label>
                    <textarea class="uk-textarea" rows="8" placeholder="Email content..."></textarea>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Save Changes</button>
        </div>
    </div>
</div>

<!-- Preview Template Modal -->
<div id="preview-template-modal" uk-modal="container: false">
    <div class="uk-modal-dialog uk-modal-body uk-width-xlarge">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <h2 class="uk-modal-title">Template Preview</h2>
        <div class="uk-card uk-card-secondary uk-card-body">
            <p class="uk-text-bold">Subject: Welcome to GlobalEd Pathways!</p>
            <hr>
            <p>Dear {{name}},</p>
            <p>Welcome to GlobalEd Pathways! We're excited to have you join our community of ambitious students pursuing their academic dreams abroad.</p>
            <p>Your dedicated counselor will be in touch shortly to begin your journey.</p>
        </div>
        <div class="uk-text-right uk-margin-top">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Close</button>
        </div>
    </div>
</div>

<!-- Use Template Modal -->
<div id="use-template-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Use Template for Campaign</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Campaign Name *</label>
                    <input class="uk-input" type="text" placeholder="Enter campaign name" required>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Recipients *</label>
                    <select class="uk-select" required>
                        <option value="">Select list...</option>
                        <option>All Users (2,456)</option>
                        <option>Students Only (2,300)</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Schedule</label>
                    <select class="uk-select">
                        <option>Send Now</option>
                        <option>Schedule for Later</option>
                    </select>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Create Campaign</button>
        </div>
    </div>
</div>

<!-- Delete Template Modal -->
<div id="delete-template-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Delete Template</h2>
        </div>
        <div class="uk-modal-body">
            <p>Are you sure you want to delete this template? This action cannot be undone.</p>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-danger" type="button">Delete</button>
        </div>
    </div>
</div>

<!-- Create List Modal -->
<div id="create-list-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Create Subscriber List</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">List Name *</label>
                    <input class="uk-input" type="text" placeholder="e.g., VIP Students" required>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Description</label>
                    <textarea class="uk-textarea" rows="2" placeholder="Brief description of this list..."></textarea>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Create List</button>
        </div>
    </div>
</div>

<!-- View Subscribers Modal -->
<div id="view-subscribers-modal" uk-modal="container: false">
    <div class="uk-modal-dialog uk-modal-body uk-width-xlarge">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <h2 class="uk-modal-title">Subscribers - All Users</h2>
        <div class="uk-margin">
            <input class="uk-input" type="search" placeholder="Search subscribers...">
        </div>
        <table class="uk-table uk-table-small uk-table-divider">
            <thead>
                <tr><th>Name</th><th>Email</th><th>Joined</th></tr>
            </thead>
            <tbody>
                <tr><td>John Doe</td><td>john@email.com</td><td>2024-01-15</td></tr>
                <tr><td>Sarah Chen</td><td>sarah@email.com</td><td>2024-01-18</td></tr>
                <tr><td>Michael Rodriguez</td><td>michael@email.com</td><td>2024-01-20</td></tr>
            </tbody>
        </table>
        <div class="uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Close</button>
        </div>
    </div>
</div>

<!-- Edit List Modal -->
<div id="edit-list-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Edit List</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">List Name *</label>
                    <input class="uk-input" type="text" value="All Users" required>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Description</label>
                    <textarea class="uk-textarea" rows="2" placeholder="Brief description..."></textarea>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Save Changes</button>
        </div>
    </div>
</div>

<!-- Add Subscribers Modal -->
<div id="add-subscribers-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Add Subscribers</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Add Method</label>
                    <div class="uk-margin-small">
                        <label><input class="uk-radio" type="radio" name="add-method" checked> Manual entry</label>
                    </div>
                    <div class="uk-margin-small">
                        <label><input class="uk-radio" type="radio" name="add-method"> Import CSV</label>
                    </div>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Email Addresses</label>
                    <textarea class="uk-textarea" rows="4" placeholder="Enter email addresses (one per line)..."></textarea>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Add Subscribers</button>
        </div>
    </div>
</div>

<!-- Delete List Modal -->
<div id="delete-list-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Delete List</h2>
        </div>
        <div class="uk-modal-body">
            <div class="uk-alert uk-alert-danger">
                <p>Are you sure you want to delete this list? All subscribers will be removed from this list.</p>
            </div>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-danger" type="button">Delete List</button>
        </div>
    </div>
</div>

<!-- New Automation Modal -->
<div id="new-automation-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">New Email Automation</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Automation Name *</label>
                    <input class="uk-input" type="text" placeholder="e.g., Welcome Series" required>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Trigger *</label>
                    <select class="uk-select" required>
                        <option value="">Select trigger...</option>
                        <option>New user registration</option>
                        <option>Application submitted</option>
                        <option>Payment received</option>
                        <option>Status change</option>
                        <option>Custom date</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Template</label>
                    <select class="uk-select">
                        <option value="">Select template...</option>
                        <option>Welcome Email</option>
                        <option>Payment Reminder</option>
                        <option>Application Update</option>
                    </select>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Create Automation</button>
        </div>
    </div>
</div>
