<?php
/**
 * Mailing Page Content (Partial)
 */

require_once __DIR__ . '/../includes/bootstrap.php';

$mailing_stats = [
    ['icon' => 'fa-envelope', 'value' => '4,567', 'label' => 'Emails Sent This Month', 'color' => '#667eea', 'color_dark' => '#5568d3', 'sparkline_data' => [2800, 3100, 3400, 3700, 3900, 4100, 4300, 4400, 4567]],
    ['icon' => 'fa-envelope-open', 'value' => '78.5%', 'label' => 'Average Open Rate', 'color' => '#32d296', 'color_dark' => '#28b67f', 'sparkline_data' => [72, 74, 75, 76, 77, 77.5, 78, 78.2, 78.5]],
    ['icon' => 'fa-mouse-pointer', 'value' => '23.4%', 'label' => 'Average Click Rate', 'color' => '#faa05a', 'color_dark' => '#f48939', 'sparkline_data' => [18, 19, 20, 21, 21.5, 22, 22.5, 23, 23.4]],
    ['icon' => 'fa-users', 'value' => '2,456', 'label' => 'Total Recipients', 'color' => '#8b5cf6', 'color_dark' => '#7c3aed', 'sparkline_data' => [2000, 2100, 2200, 2250, 2300, 2350, 2400, 2420, 2456]]
];

$campaigns = [
    ['name' => 'January Newsletter', 'recipients' => 2456, 'sent' => '2024-01-15', 'open_rate' => '74.2%', 'click_rate' => '21.3%', 'status' => 'sent'],
    ['name' => 'Application Deadline Reminder', 'recipients' => 1234, 'sent' => '2024-01-20', 'open_rate' => '80%', 'click_rate' => '28.5%', 'status' => 'sent'],
    ['name' => 'Interview Preparation Workshop', 'recipients' => 567, 'sent' => '2024-02-05', 'open_rate' => '85.3%', 'click_rate' => '32.1%', 'status' => 'sent'],
    ['name' => 'February Scholarship Update', 'recipients' => 890, 'sent' => '2024-02-15', 'open_rate' => null, 'click_rate' => null, 'status' => 'scheduled'],
    ['name' => 'New Program Announcement', 'recipients' => 1456, 'sent' => '2024-02-20', 'open_rate' => null, 'click_rate' => null, 'status' => 'draft']
];

$templates = [
    ['name' => 'Newsletter', 'description' => 'Monthly updates and news', 'icon' => 'fa-newspaper', 'color' => '#667eea'],
    ['name' => 'Announcement', 'description' => 'Important notifications', 'icon' => 'fa-bullhorn', 'color' => '#1e87f0'],
    ['name' => 'Reminder', 'description' => 'Deadline and task reminders', 'icon' => 'fa-bell', 'color' => '#faa05a'],
    ['name' => 'Welcome', 'description' => 'New user onboarding', 'icon' => 'fa-hands-helping', 'color' => '#32d296']
];

$engagement_data = [
    ['month' => 'Jan', 'sent' => 4200, 'opened' => 3300, 'clicked' => 980],
    ['month' => 'Feb', 'sent' => 4567, 'opened' => 3585, 'clicked' => 1068],
    ['month' => 'Mar', 'sent' => 5100, 'opened' => 4080, 'clicked' => 1224],
    ['month' => 'Apr', 'sent' => 4890, 'opened' => 3912, 'clicked' => 1173],
    ['month' => 'May', 'sent' => 5340, 'opened' => 4272, 'clicked' => 1282],
    ['month' => 'Jun', 'sent' => 5678, 'opened' => 4542, 'clicked' => 1363]
];
?>

<style>
.modern-stat-card {
    border-radius: 12px;
    padding: 24px;
    position: relative;
    overflow: hidden;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    transition: all 0.3s ease;
}

.modern-stat-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 16px rgba(0, 0, 0, 0.12);
}

.stat-card-bg {
    position: absolute;
    top: -30px;
    right: -30px;
    width: 120px;
    height: 120px;
    border-radius: 50%;
    opacity: 0.2;
}

.stat-icon {
    width: 48px;
    height: 48px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 20px;
    margin-bottom: 16px;
}

.stat-value {
    font-size: 32px;
    font-weight: 700;
    color: white;
    margin-bottom: 4px;
}

.stat-label {
    font-size: 14px;
    color: rgba(255, 255, 255, 0.9);
    font-weight: 500;
}

.stat-sparkline {
    margin: 12px -24px -24px -24px;
    height: 50px;
}

.campaign-card {
    background: white;
    border-radius: 12px;
    padding: 20px;
    margin-bottom: 12px;
    transition: all 0.2s ease;
    border: 1px solid #e2e8f0;
}

.campaign-card:hover {
    border-color: #667eea;
    box-shadow: 0 4px 12px rgba(102, 126, 234, 0.1);
    transform: translateY(-2px);
}

.template-card {
    background: white;
    border-radius: 12px;
    padding: 24px;
    text-align: center;
    border: 2px solid #e2e8f0;
    transition: all 0.2s ease;
    cursor: pointer;
    height: 100%;
}

.template-card:hover {
    border-color: #667eea;
    box-shadow: 0 4px 12px rgba(102, 126, 234, 0.1);
    transform: translateY(-2px);
}

.template-icon {
    width: 64px;
    height: 64px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 28px;
    margin: 0 auto 16px;
}

.template-name {
    font-weight: 600;
    font-size: 16px;
    color: #1a1a1a;
    margin-bottom: 8px;
}

.template-description {
    font-size: 13px;
    color: #64748b;
}

.modern-chart-card {
    background: white;
    border-radius: 12px;
    padding: 24px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
}

.chart-title {
    font-size: 18px;
    font-weight: 600;
    color: #1a1a1a;
    margin-bottom: 20px;
}

.page-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 24px;
}

.page-title {
    font-size: 24px;
    font-weight: 700;
    color: #1a1a1a;
    margin: 0;
}

.modern-btn {
    padding: 10px 20px;
    border-radius: 8px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    border: none;
    font-size: 14px;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.2s ease;
    display: inline-flex;
    align-items: center;
    gap: 8px;
}

.modern-btn:hover {
    transform: translateY(-1px);
    box-shadow: 0 4px 12px rgba(102, 126, 234, 0.3);
    color: white;
    text-decoration: none;
}

.modern-btn-secondary {
    background: white;
    color: #667eea;
    border: 1px solid #667eea;
}

.modern-btn-secondary:hover {
    background: #f8fafc;
    box-shadow: 0 2px 8px rgba(102, 126, 234, 0.2);
}

.status-badge {
    padding: 6px 12px;
    border-radius: 6px;
    font-size: 12px;
    font-weight: 600;
    text-transform: uppercase;
}

.status-sent {
    background: #d1fae5;
    color: #065f46;
}

.status-scheduled {
    background: #fef3c7;
    color: #92400e;
}

.status-draft {
    background: #e2e8f0;
    color: #475569;
}

.metric-badge {
    text-align: center;
    padding: 12px;
    border-radius: 8px;
    background: #f8fafc;
    min-width: 100px;
}

.metric-value {
    font-size: 18px;
    font-weight: 700;
    color: #1a1a1a;
    margin-bottom: 4px;
}

.metric-label {
    font-size: 12px;
    color: #64748b;
}

@media (max-width: 959px) {
    .page-header {
        flex-direction: column;
        align-items: stretch;
        gap: 12px;
    }
}
</style>

<div class="page-header">
    <h3 class="page-title">Mailing System</h3>
    <div style="display: flex; gap: 12px;">
        <button class="modern-btn" uk-toggle="target: #create-campaign-modal">
            <i class="fa-slab fa-solid fa-plus"></i> Create Campaign
        </button>
        <button class="modern-btn modern-btn-secondary" uk-toggle="target: #send-mail-modal">
            <i class="fa-slab fa-solid fa-paper-plane"></i> Send Mail
        </button>
    </div>
</div>

<!-- Stats Grid -->
<div class="uk-grid-small uk-child-width-1-2@s uk-child-width-1-4@m" uk-grid>
    <?php foreach ($mailing_stats as $index => $stat): ?>
    <div>
        <div class="modern-stat-card" style="background: linear-gradient(135deg, <?= $stat['color'] ?> 0%, <?= $stat['color_dark'] ?> 100%);">
            <div class="stat-card-bg" style="background: linear-gradient(135deg, <?= $stat['color'] ?> 0%, <?= $stat['color_dark'] ?> 100%);"></div>
            <div class="stat-icon" style="background: rgba(255, 255, 255, 0.2);">
                <i class="fa-slab fa-solid <?= $stat['icon'] ?>"></i>
            </div>
            <div class="stat-value"><?= e($stat['value']) ?></div>
            <div class="stat-label"><?= e($stat['label']) ?></div>
            <div class="stat-sparkline" id="sparkline-<?= $index ?>"></div>
        </div>
    </div>
    <?php endforeach; ?>
</div>

<!-- Email Templates -->
<div class="modern-chart-card uk-margin-top">
    <h4 class="chart-title"><i class="fa-slab fa-solid fa-palette"></i> Email Templates</h4>
    <div class="uk-grid-small uk-child-width-1-2@s uk-child-width-1-4@m" uk-grid>
        <?php foreach ($templates as $template): ?>
        <div>
            <div class="template-card" uk-toggle="target: #create-campaign-modal">
                <div class="template-icon" style="background: linear-gradient(135deg, <?= $template['color'] ?> 0%, <?= $template['color'] ?>dd 100%);">
                    <i class="fa-slab fa-solid <?= $template['icon'] ?>"></i>
                </div>
                <div class="template-name"><?= e($template['name']) ?></div>
                <div class="template-description"><?= e($template['description']) ?></div>
            </div>
        </div>
        <?php endforeach; ?>
    </div>
</div>

<!-- Charts Section -->
<div class="uk-grid-small uk-margin-top" uk-grid>
    <div class="uk-width-1-2@m">
        <div class="modern-chart-card">
            <h4 class="chart-title">Email Engagement Trends</h4>
            <div id="engagement-chart" style="height: 300px;"></div>
        </div>
    </div>
    <div class="uk-width-1-2@m">
        <div class="modern-chart-card">
            <h4 class="chart-title">Campaign Performance</h4>
            <div id="performance-chart" style="height: 300px;"></div>
        </div>
    </div>
</div>

<!-- Recent Campaigns -->
<div class="modern-chart-card uk-margin-top">
    <h4 class="chart-title"><i class="fa-slab fa-solid fa-paper-plane"></i> Recent Email Campaigns</h4>
    <?php foreach ($campaigns as $campaign): ?>
        <div class="campaign-card">
            <div class="uk-flex uk-flex-between uk-flex-middle">
                <div style="flex: 1;">
                    <div style="font-weight: 600; color: #1a1a1a; font-size: 16px; margin-bottom: 8px;">
                        <?= e($campaign['name']) ?>
                    </div>
                    <div style="font-size: 13px; color: #64748b;">
                        <i class="fa-slab fa-solid fa-users fa-sm"></i> <?= number_format($campaign['recipients']) ?> recipients &middot;
                        <i class="fa-slab fa-solid fa-calendar fa-sm"></i> <?= $campaign['status'] === 'scheduled' ? 'Scheduled for' : ($campaign['status'] === 'draft' ? 'Created' : 'Sent') ?> <?= e($campaign['sent']) ?>
                    </div>
                </div>
                <div style="display: flex; align-items: center; gap: 12px;">
                    <?php if ($campaign['open_rate']): ?>
                        <div class="metric-badge">
                            <div class="metric-value" style="color: #32d296;"><?= e($campaign['open_rate']) ?></div>
                            <div class="metric-label">Open Rate</div>
                        </div>
                        <div class="metric-badge">
                            <div class="metric-value" style="color: #667eea;"><?= e($campaign['click_rate']) ?></div>
                            <div class="metric-label">Click Rate</div>
                        </div>
                    <?php endif; ?>
                    <span class="status-badge status-<?= $campaign['status'] ?>">
                        <?= e($campaign['status']) ?>
                    </span>
                    <div class="uk-inline">
                        <button style="background: none; border: none; color: #64748b; cursor: pointer; padding: 8px;">
                            <i class="fa-slab fa-solid fa-ellipsis-v"></i>
                        </button>
                        <div uk-dropdown="mode: click; pos: bottom-right">
                            <ul class="uk-nav uk-dropdown-nav">
                                <li class="uk-nav-header">Actions</li>
                                <li><a href="#"><i class="fa-slab fa-solid fa-eye fa-fw"></i> View Details</a></li>
                                <li><a href="#"><i class="fa-slab fa-solid fa-chart-line fa-fw"></i> View Analytics</a></li>
                                <li><a href="#"><i class="fa-slab fa-solid fa-copy fa-fw"></i> Duplicate</a></li>
                                <?php if ($campaign['status'] !== 'sent'): ?>
                                <li><a href="#"><i class="fa-slab fa-solid fa-edit fa-fw"></i> Edit</a></li>
                                <?php endif; ?>
                                <li class="uk-nav-divider"></li>
                                <li><a href="#" class="uk-text-danger"><i class="fa-slab fa-solid fa-trash fa-fw"></i> Delete</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endforeach; ?>

    <div class="uk-margin-top">
        <button class="modern-btn modern-btn-secondary uk-width-1-1">
            <i class="fa-slab fa-solid fa-list"></i> View All Campaigns
        </button>
    </div>
</div>

<!-- Create Campaign Modal (Enhanced) -->
<div id="create-campaign-modal" class="uk-modal-full" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-full uk-close-large" type="button" uk-close></button>
        <div class="uk-grid-collapse uk-child-width-1-2@s uk-flex-middle" uk-grid>
            <div class="uk-padding-large">
                <h2>Create Email Campaign</h2>
                <form class="uk-form-stacked">
                    <div class="uk-margin">
                        <label class="uk-form-label">Campaign Name *</label>
                        <input class="uk-input" type="text" placeholder="February Newsletter" required>
                    </div>
                    <div class="uk-margin">
                        <label class="uk-form-label">Email Subject *</label>
                        <input class="uk-input" type="text" placeholder="Your monthly update from GlobalEd" required>
                    </div>
                    <div class="uk-grid-small" uk-grid>
                        <div class="uk-width-1-2">
                            <label class="uk-form-label">Recipients *</label>
                            <select class="uk-select" required>
                                <option value="">Select recipients</option>
                                <option>All Users (2,456)</option>
                                <option>Students Only (2,300)</option>
                                <option>Counselors Only (34)</option>
                                <option>Active Applications (890)</option>
                                <option>Custom Segment</option>
                            </select>
                        </div>
                        <div class="uk-width-1-2">
                            <label class="uk-form-label">Schedule</label>
                            <select class="uk-select">
                                <option>Send Immediately</option>
                                <option>Schedule for Later</option>
                            </select>
                        </div>
                    </div>
                    <div class="uk-margin">
                        <label class="uk-form-label">Template</label>
                        <select class="uk-select">
                            <option>Blank Template</option>
                            <option>Newsletter Template</option>
                            <option>Announcement Template</option>
                            <option>Reminder Template</option>
                        </select>
                    </div>
                    <div class="uk-margin">
                        <label class="uk-form-label">Email Content *</label>
                        <!-- Simple WYSIWYG Toolbar -->
                        <div class="uk-button-group uk-margin-small-bottom">
                            <button type="button" class="uk-button uk-button-default uk-button-small" onclick="document.execCommand('bold')"><strong>B</strong></button>
                            <button type="button" class="uk-button uk-button-default uk-button-small" onclick="document.execCommand('italic')"><em>I</em></button>
                            <button type="button" class="uk-button uk-button-default uk-button-small" onclick="document.execCommand('underline')"><u>U</u></button>
                            <button type="button" class="uk-button uk-button-default uk-button-small" onclick="document.execCommand('insertUnorderedList')">• List</button>
                            <button type="button" class="uk-button uk-button-default uk-button-small" onclick="document.execCommand('createLink', false, prompt('Enter URL:'))">Link</button>
                        </div>
                        <div contenteditable="true" class="uk-textarea" style="min-height: 200px; overflow-y: auto;">
                            <p>Dear {{name}},</p>
                            <p>We're excited to share the latest updates from GlobalEd Pathways...</p>
                        </div>
                    </div>
                    <div class="uk-margin">
                        <label><input class="uk-checkbox" type="checkbox" checked> Enable tracking (opens & clicks)</label>
                    </div>
                    <div class="uk-margin">
                        <button class="modern-btn uk-margin-small-right" type="submit">
                            <i class="fa-slab fa-solid fa-paper-plane"></i> Create Campaign
                        </button>
                        <button class="modern-btn modern-btn-secondary" type="button">
                            <i class="fa-slab fa-solid fa-eye"></i> Preview
                        </button>
                    </div>
                </form>
            </div>
            <div class="uk-background-muted uk-padding-large uk-visible@m" style="min-height: 100vh;">
                <h4>Campaign Tips</h4>
                <ul class="uk-list uk-list-bullet">
                    <li>Use personalization tags like {{name}} for better engagement</li>
                    <li>Keep subject lines under 50 characters</li>
                    <li>Best send times: Tue-Thu, 10am-2pm</li>
                    <li>Include a clear call-to-action</li>
                    <li>Test your emails before sending</li>
                </ul>
                <h4 class="uk-margin-top">Available Tags</h4>
                <ul class="uk-list uk-list-bullet">
                    <li><code>{{name}}</code> - Recipient's name</li>
                    <li><code>{{email}}</code> - Recipient's email</li>
                    <li><code>{{role}}</code> - User role</li>
                    <li><code>{{date}}</code> - Current date</li>
                    <li><code>{{student_id}}</code> - Student ID</li>
                </ul>
            </div>
        </div>
    </div>
</div>

<!-- Send Mail Modal -->
<div id="send-mail-modal" uk-modal>
    <div class="uk-modal-dialog uk-modal-body uk-width-xlarge">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <h2 class="uk-modal-title">Send Email</h2>
        <form class="uk-form-stacked">
            <div class="uk-margin">
                <label class="uk-form-label">To *</label>
                <input class="uk-input" type="email" placeholder="recipient@example.com" required>
            </div>
            <div class="uk-margin">
                <label class="uk-form-label">Subject *</label>
                <input class="uk-input" type="text" placeholder="Email subject" required>
            </div>
            <div class="uk-margin">
                <label class="uk-form-label">Message *</label>
                <!-- Simple WYSIWYG Toolbar -->
                <div class="uk-button-group uk-margin-small-bottom">
                    <button type="button" class="uk-button uk-button-default uk-button-small" onclick="document.execCommand('bold')"><strong>B</strong></button>
                    <button type="button" class="uk-button uk-button-default uk-button-small" onclick="document.execCommand('italic')"><em>I</em></button>
                    <button type="button" class="uk-button uk-button-default uk-button-small" onclick="document.execCommand('underline')"><u>U</u></button>
                    <button type="button" class="uk-button uk-button-default uk-button-small" onclick="document.execCommand('insertUnorderedList')">• List</button>
                </div>
                <div contenteditable="true" class="uk-textarea" style="min-height: 150px; overflow-y: auto;">
                    <p>Write your message here...</p>
                </div>
            </div>
            <div class="uk-margin">
                <div uk-form-custom>
                    <input type="file" multiple>
                    <button class="uk-button uk-button-default uk-button-small" type="button">
                        <i class="fa-slab fa-solid fa-paperclip"></i> Attach Files
                    </button>
                </div>
            </div>
        </form>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="modern-btn" type="button">
                <i class="fa-slab fa-solid fa-paper-plane"></i> Send Email
            </button>
        </div>
    </div>
</div>

<script>
(function() {
    // ApexCharts - Sparklines in stat cards
    <?php foreach ($mailing_stats as $index => $stat): ?>
    var sparkline<?= $index ?> = document.getElementById('sparkline-<?= $index ?>');
    if (sparkline<?= $index ?> && typeof ApexCharts !== 'undefined') {
        var sparkOptions<?= $index ?> = {
            series: [{
                data: <?= json_encode($stat['sparkline_data']) ?>
            }],
            chart: {
                type: 'area',
                height: 50,
                sparkline: {
                    enabled: true
                }
            },
            stroke: {
                curve: 'smooth',
                width: 2
            },
            fill: {
                opacity: 0.3,
                type: 'gradient',
                gradient: {
                    opacityFrom: 0.5,
                    opacityTo: 0.1
                }
            },
            colors: ['#ffffff'],
            tooltip: {
                enabled: true,
                theme: 'dark',
                x: {
                    show: false
                }
            }
        };
        new ApexCharts(sparkline<?= $index ?>, sparkOptions<?= $index ?>).render();
    }
    <?php endforeach; ?>

    // ApexCharts - Email Engagement Trends
    var engagementEl = document.getElementById('engagement-chart');
    if (engagementEl && typeof ApexCharts !== 'undefined') {
        var engagementOptions = {
            series: [{
                name: 'Sent',
                data: <?= json_encode(array_column($engagement_data, 'sent')) ?>
            }, {
                name: 'Opened',
                data: <?= json_encode(array_column($engagement_data, 'opened')) ?>
            }, {
                name: 'Clicked',
                data: <?= json_encode(array_column($engagement_data, 'clicked')) ?>
            }],
            chart: {
                type: 'line',
                height: 300,
                toolbar: { show: false }
            },
            colors: ['#667eea', '#32d296', '#faa05a'],
            stroke: {
                curve: 'smooth',
                width: 3
            },
            dataLabels: { enabled: false },
            xaxis: {
                categories: <?= json_encode(array_column($engagement_data, 'month')) ?>,
                labels: { style: { colors: '#64748b' } }
            },
            yaxis: { labels: { style: { colors: '#64748b' } } },
            legend: { position: 'top' },
            tooltip: { theme: 'dark' },
            grid: {
                borderColor: '#e2e8f0',
                strokeDashArray: 4
            }
        };
        new ApexCharts(engagementEl, engagementOptions).render();
    }

    // ECharts - Campaign Performance Funnel
    var performanceEl = document.getElementById('performance-chart');
    if (performanceEl && typeof echarts !== 'undefined') {
        var performanceChart = echarts.init(performanceEl);
        var performanceOption = {
            tooltip: {
                trigger: 'item',
                formatter: '{b}: {c} ({d}%)'
            },
            series: [{
                type: 'funnel',
                left: '10%',
                width: '80%',
                label: {
                    formatter: '{b}: {c}'
                },
                data: [
                    { value: 5678, name: 'Delivered', itemStyle: { color: '#667eea' } },
                    { value: 4542, name: 'Opened', itemStyle: { color: '#32d296' } },
                    { value: 1363, name: 'Clicked', itemStyle: { color: '#faa05a' } },
                    { value: 545, name: 'Converted', itemStyle: { color: '#1e87f0' } }
                ]
            }]
        };
        performanceChart.setOption(performanceOption);
        window.addEventListener('resize', function() { performanceChart.resize(); });
    }
})();
</script>
