<?php
require_once __DIR__ . '/../../includes/bootstrap.php';

$stats = [
    ['icon' => 'mail', 'value' => '15,234', 'label' => 'Emails Sent', 'color' => 'primary', 'trend' => 12],
    ['icon' => 'eye', 'value' => '68.5%', 'label' => 'Open Rate', 'color' => 'success', 'trend' => 3],
    ['icon' => 'link', 'value' => '24.3%', 'label' => 'Click Rate', 'color' => 'warning', 'trend' => -2],
    ['icon' => 'users', 'value' => '3,245', 'label' => 'Subscribers', 'color' => 'purple', 'trend' => 8],
];

$recent_campaigns = [
    ['name' => 'January Newsletter', 'sent' => '2024-01-28', 'recipients' => 2456, 'opens' => 1678, 'clicks' => 543],
    ['name' => 'Application Deadline Reminder', 'sent' => '2024-01-25', 'recipients' => 892, 'opens' => 756, 'clicks' => 312],
    ['name' => 'Welcome Email', 'sent' => '2024-01-24', 'recipients' => 45, 'opens' => 42, 'clicks' => 38],
    ['name' => 'Payment Reminder', 'sent' => '2024-01-20', 'recipients' => 156, 'opens' => 134, 'clicks' => 89],
];

render_stat_cards($stats, 4);
?>

<div class="uk-grid-small uk-margin-top" uk-grid>
    <div class="uk-width-2-3@m">
        <div class="uk-card uk-card-default uk-card-body">
            <h4 class="uk-card-title">Recent Campaigns Performance</h4>
            <table class="uk-table uk-table-divider uk-table-small">
                <thead>
                    <tr>
                        <th>Campaign</th>
                        <th>Sent</th>
                        <th>Recipients</th>
                        <th>Opens</th>
                        <th>Clicks</th>
                        <th>Rate</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($recent_campaigns as $campaign): ?>
                    <tr>
                        <td class="uk-text-bold uk-text-small"><?= e($campaign['name']) ?></td>
                        <td class="uk-text-small"><?= e($campaign['sent']) ?></td>
                        <td><?= number_format($campaign['recipients']) ?></td>
                        <td><?= number_format($campaign['opens']) ?></td>
                        <td><?= number_format($campaign['clicks']) ?></td>
                        <td class="uk-text-success"><?= round(($campaign['opens'] / $campaign['recipients']) * 100, 1) ?>%</td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
    <div class="uk-width-1-3@m">
        <div class="uk-card uk-card-default uk-card-body">
            <h4 class="uk-card-title">Top Performing</h4>
            <div class="uk-margin">
                <div class="uk-text-bold uk-text-small">Highest Open Rate</div>
                <div class="uk-text-muted uk-text-small">Welcome Email - 93.3%</div>
            </div>
            <div class="uk-margin">
                <div class="uk-text-bold uk-text-small">Highest Click Rate</div>
                <div class="uk-text-muted uk-text-small">Welcome Email - 84.4%</div>
            </div>
            <div class="uk-margin">
                <div class="uk-text-bold uk-text-small">Most Sent</div>
                <div class="uk-text-muted uk-text-small">January Newsletter - 2,456</div>
            </div>
        </div>

        <div class="uk-card uk-card-default uk-card-body uk-margin-top">
            <h4 class="uk-card-title">Subscriber Growth</h4>
            <div class="uk-text-large uk-text-bold uk-text-success">+8.3%</div>
            <div class="uk-text-muted uk-text-small">vs last month</div>
            <div class="uk-margin-top">
                <div class="uk-text-small">New: <span class="uk-text-success">+267</span></div>
                <div class="uk-text-small">Unsubscribed: <span class="uk-text-danger">-23</span></div>
            </div>
        </div>
    </div>
</div>
