<?php
require_once __DIR__ . '/../../includes/bootstrap.php';

$automations = [
    ['id' => 1, 'name' => 'Welcome Series', 'trigger' => 'User Registration', 'emails' => 3, 'status' => 'active', 'sent' => 1245],
    ['id' => 2, 'name' => 'Application Reminder', 'trigger' => 'Incomplete Application', 'emails' => 2, 'status' => 'active', 'sent' => 567],
    ['id' => 3, 'name' => 'Payment Due Reminder', 'trigger' => '7 Days Before Due', 'emails' => 1, 'status' => 'active', 'sent' => 892],
    ['id' => 4, 'name' => 'Re-engagement', 'trigger' => 'Inactive 30 Days', 'emails' => 3, 'status' => 'paused', 'sent' => 234],
    ['id' => 5, 'name' => 'Document Request Follow-up', 'trigger' => 'Missing Documents', 'emails' => 2, 'status' => 'active', 'sent' => 456],
];

$status_colors = ['active' => 'success', 'paused' => 'warning', 'draft' => 'secondary'];
?>

<div class="uk-flex uk-flex-between uk-flex-middle uk-margin-bottom">
    <h4 class="uk-margin-remove">Email Automations</h4>
    <button class="uk-button uk-button-primary uk-button-small" uk-toggle="target: #add-automation-modal">
        <span uk-icon="icon: plus; ratio: 0.8"></span> New Automation
    </button>
</div>

<div class="uk-card uk-card-default uk-card-body">
    <table class="uk-table uk-table-divider uk-table-hover">
        <thead>
            <tr>
                <th>Automation Name</th>
                <th>Trigger</th>
                <th>Emails</th>
                <th>Total Sent</th>
                <th>Status</th>
                <th></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($automations as $automation): ?>
            <tr>
                <td class="uk-text-bold"><?= e($automation['name']) ?></td>
                <td class="uk-text-small"><?= e($automation['trigger']) ?></td>
                <td><?= $automation['emails'] ?> email<?= $automation['emails'] > 1 ? 's' : '' ?></td>
                <td><?= number_format($automation['sent']) ?></td>
                <td><span class="uk-label uk-label-<?= $status_colors[$automation['status']] ?>"><?= e($automation['status']) ?></span></td>
                <td class="uk-text-right">
                    <a href="#" uk-icon="icon: play; ratio: 0.8" uk-tooltip="<?= $automation['status'] === 'active' ? 'Pause' : 'Activate' ?>"></a>
                    <a href="#" uk-icon="icon: pencil; ratio: 0.8" class="uk-margin-small-left" uk-tooltip="Edit"></a>
                    <a href="#" uk-icon="icon: chart; ratio: 0.8" class="uk-margin-small-left" uk-tooltip="Analytics"></a>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<!-- Add Automation Modal -->
<div id="add-automation-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Create New Automation</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Automation Name *</label>
                    <input class="uk-input" type="text" placeholder="e.g., Welcome Series" required>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Trigger Event *</label>
                    <select class="uk-select" required>
                        <option value="">Select trigger...</option>
                        <option>User Registration</option>
                        <option>Application Submitted</option>
                        <option>Payment Received</option>
                        <option>Document Uploaded</option>
                        <option>Inactive Period</option>
                        <option>Custom Date</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Description</label>
                    <textarea class="uk-textarea" rows="3" placeholder="Automation description..."></textarea>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Create Automation</button>
        </div>
    </div>
</div>
