<?php
require_once __DIR__ . '/../../includes/bootstrap.php';
?>

<div class="uk-card uk-card-default uk-card-body">
    <h4 class="uk-card-title">Compose New Email</h4>
    <form class="uk-form-stacked" hx-post="<?= BASE_URL ?>/api/mail.php" hx-target="#compose-result">
        <div class="uk-margin">
            <label class="uk-form-label">Recipients</label>
            <select class="uk-select" name="recipients" required>
                <option value="">Select recipient group...</option>
                <option value="all">All Users</option>
                <option value="students">All Students</option>
                <option value="counselors">All Counselors</option>
                <option value="active">Active Users (Last 30 days)</option>
                <option value="custom">Custom List</option>
            </select>
        </div>
        <div class="uk-margin">
            <label class="uk-form-label">Subject</label>
            <input class="uk-input" type="text" name="subject" placeholder="Email subject line" required>
        </div>
        <div class="uk-margin">
            <label class="uk-form-label">Template</label>
            <select class="uk-select" name="template">
                <option value="">No template (blank email)</option>
                <option value="welcome">Welcome Email</option>
                <option value="newsletter">Newsletter</option>
                <option value="notification">Notification</option>
                <option value="reminder">Reminder</option>
            </select>
        </div>
        <div class="uk-margin">
            <label class="uk-form-label">Message</label>
            <textarea class="uk-textarea" rows="10" name="message" placeholder="Write your email content here..." required></textarea>
        </div>
        <div class="uk-margin">
            <label><input class="uk-checkbox" type="checkbox" name="schedule"> Schedule for later</label>
        </div>
        <div id="compose-result"></div>
        <div class="uk-flex uk-flex-right">
            <button class="uk-button uk-button-default uk-margin-small-right" type="button">Preview</button>
            <button class="uk-button uk-button-primary" type="submit">Send Email</button>
        </div>
    </form>
</div>
