<?php
require_once __DIR__ . '/../../includes/bootstrap.php';

$lists = [
    ['id' => 1, 'name' => 'All Students', 'subscribers' => 2456, 'created' => '2023-01-01', 'type' => 'Dynamic'],
    ['id' => 2, 'name' => 'Active Users', 'subscribers' => 1890, 'created' => '2023-06-15', 'type' => 'Dynamic'],
    ['id' => 3, 'name' => 'Newsletter Subscribers', 'subscribers' => 3245, 'created' => '2023-03-20', 'type' => 'Static'],
    ['id' => 4, 'name' => 'Premium Clients', 'subscribers' => 156, 'created' => '2023-09-01', 'type' => 'Static'],
    ['id' => 5, 'name' => 'Fall 2024 Applicants', 'subscribers' => 892, 'created' => '2024-01-10', 'type' => 'Dynamic'],
];
?>

<div class="uk-flex uk-flex-between uk-flex-middle uk-margin-bottom">
    <h4 class="uk-margin-remove">Mailing Lists</h4>
    <button class="uk-button uk-button-primary uk-button-small" uk-toggle="target: #add-list-modal">
        <span uk-icon="icon: plus; ratio: 0.8"></span> New List
    </button>
</div>

<div class="uk-card uk-card-default uk-card-body">
    <table class="uk-table uk-table-divider uk-table-hover">
        <thead>
            <tr>
                <th>List Name</th>
                <th>Type</th>
                <th>Subscribers</th>
                <th>Created</th>
                <th></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($lists as $list): ?>
            <tr>
                <td class="uk-text-bold"><?= e($list['name']) ?></td>
                <td><span class="uk-label uk-label-<?= $list['type'] === 'Dynamic' ? 'primary' : 'secondary' ?>"><?= e($list['type']) ?></span></td>
                <td><?= number_format($list['subscribers']) ?></td>
                <td class="uk-text-small"><?= e($list['created']) ?></td>
                <td class="uk-text-right">
                    <a href="#" uk-icon="icon: users; ratio: 0.8" uk-tooltip="View Subscribers"></a>
                    <a href="#" uk-icon="icon: pencil; ratio: 0.8" class="uk-margin-small-left" uk-tooltip="Edit"></a>
                    <a href="#" uk-icon="icon: download; ratio: 0.8" class="uk-margin-small-left" uk-tooltip="Export"></a>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<!-- Add List Modal -->
<div id="add-list-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Create New List</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">List Name *</label>
                    <input class="uk-input" type="text" placeholder="e.g., Newsletter Subscribers" required>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">List Type *</label>
                    <select class="uk-select" required>
                        <option value="static">Static (Manual)</option>
                        <option value="dynamic">Dynamic (Auto-updated)</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Description</label>
                    <textarea class="uk-textarea" rows="3" placeholder="List description..."></textarea>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Create List</button>
        </div>
    </div>
</div>
