<?php
require_once __DIR__ . '/../../includes/bootstrap.php';

$templates = [
    ['id' => 1, 'name' => 'Welcome Email', 'category' => 'Onboarding', 'last_modified' => '2024-01-15', 'uses' => 245],
    ['id' => 2, 'name' => 'Newsletter Template', 'category' => 'Marketing', 'last_modified' => '2024-01-20', 'uses' => 89],
    ['id' => 3, 'name' => 'Payment Reminder', 'category' => 'Transactional', 'last_modified' => '2024-01-25', 'uses' => 156],
    ['id' => 4, 'name' => 'Application Update', 'category' => 'Notification', 'last_modified' => '2024-01-28', 'uses' => 432],
    ['id' => 5, 'name' => 'Document Request', 'category' => 'Transactional', 'last_modified' => '2024-01-30', 'uses' => 78],
];
?>

<div class="uk-flex uk-flex-between uk-flex-middle uk-margin-bottom">
    <h4 class="uk-margin-remove">Email Templates</h4>
    <button class="uk-button uk-button-primary uk-button-small" uk-toggle="target: #add-template-modal">
        <span uk-icon="icon: plus; ratio: 0.8"></span> New Template
    </button>
</div>

<div class="uk-card uk-card-default uk-card-body">
    <table class="uk-table uk-table-divider uk-table-hover">
        <thead>
            <tr>
                <th>Template Name</th>
                <th>Category</th>
                <th>Last Modified</th>
                <th>Uses</th>
                <th></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($templates as $template): ?>
            <tr>
                <td class="uk-text-bold"><?= e($template['name']) ?></td>
                <td><span class="uk-label uk-label-secondary"><?= e($template['category']) ?></span></td>
                <td class="uk-text-small"><?= e($template['last_modified']) ?></td>
                <td><?= number_format($template['uses']) ?></td>
                <td class="uk-text-right">
                    <a href="#" uk-icon="icon: pencil; ratio: 0.8" uk-tooltip="Edit"></a>
                    <a href="#" uk-icon="icon: eye; ratio: 0.8" class="uk-margin-small-left" uk-tooltip="Preview"></a>
                    <a href="#" uk-icon="icon: copy; ratio: 0.8" class="uk-margin-small-left" uk-tooltip="Duplicate"></a>
                    <a href="#" uk-icon="icon: trash; ratio: 0.8" class="uk-margin-small-left uk-text-danger" uk-tooltip="Delete"></a>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<!-- Add Template Modal -->
<div id="add-template-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Create New Template</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Template Name *</label>
                    <input class="uk-input" type="text" placeholder="e.g., Welcome Email" required>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Category *</label>
                    <select class="uk-select" required>
                        <option value="">Select category...</option>
                        <option>Onboarding</option>
                        <option>Marketing</option>
                        <option>Transactional</option>
                        <option>Notification</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Subject Line</label>
                    <input class="uk-input" type="text" placeholder="Email subject">
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Content</label>
                    <textarea class="uk-textarea" rows="8" placeholder="Template content..."></textarea>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Create Template</button>
        </div>
    </div>
</div>
