<?php
require_once __DIR__ . '/../includes/bootstrap.php';
?>

<h3 class="uk-margin-bottom">Notification Preferences</h3>

<div class="uk-card uk-card-default uk-card-body">
    <h4 class="uk-card-title">Email Notifications</h4>

    <div class="uk-margin">
        <div class="uk-flex uk-flex-between uk-flex-middle">
            <div>
                <div class="uk-text-bold">New Applications</div>
                <div class="uk-text-small uk-text-muted">Receive emails when new applications are submitted</div>
            </div>
            <label class="uk-switch">
                <input type="checkbox" checked>
                <span class="uk-switch-slider"></span>
            </label>
        </div>
    </div>

    <div class="uk-margin">
        <div class="uk-flex uk-flex-between uk-flex-middle">
            <div>
                <div class="uk-text-bold">Payment Received</div>
                <div class="uk-text-small uk-text-muted">Get notified when payments are processed</div>
            </div>
            <label class="uk-switch">
                <input type="checkbox" checked>
                <span class="uk-switch-slider"></span>
            </label>
        </div>
    </div>

    <div class="uk-margin">
        <div class="uk-flex uk-flex-between uk-flex-middle">
            <div>
                <div class="uk-text-bold">User Registration</div>
                <div class="uk-text-small uk-text-muted">Receive alerts when new users register</div>
            </div>
            <label class="uk-switch">
                <input type="checkbox">
                <span class="uk-switch-slider"></span>
            </label>
        </div>
    </div>

    <div class="uk-margin">
        <div class="uk-flex uk-flex-between uk-flex-middle">
            <div>
                <div class="uk-text-bold">Document Uploads</div>
                <div class="uk-text-small uk-text-muted">Get notified when documents are uploaded</div>
            </div>
            <label class="uk-switch">
                <input type="checkbox" checked>
                <span class="uk-switch-slider"></span>
            </label>
        </div>
    </div>
</div>

<div class="uk-card uk-card-default uk-card-body uk-margin-top">
    <h4 class="uk-card-title">Push Notifications</h4>

    <div class="uk-margin">
        <div class="uk-flex uk-flex-between uk-flex-middle">
            <div>
                <div class="uk-text-bold">Desktop Notifications</div>
                <div class="uk-text-small uk-text-muted">Show notifications on your desktop</div>
            </div>
            <label class="uk-switch">
                <input type="checkbox" checked>
                <span class="uk-switch-slider"></span>
            </label>
        </div>
    </div>

    <div class="uk-margin">
        <div class="uk-flex uk-flex-between uk-flex-middle">
            <div>
                <div class="uk-text-bold">Sound Alerts</div>
                <div class="uk-text-small uk-text-muted">Play sounds for important notifications</div>
            </div>
            <label class="uk-switch">
                <input type="checkbox">
                <span class="uk-switch-slider"></span>
            </label>
        </div>
    </div>
</div>

<div class="uk-card uk-card-default uk-card-body uk-margin-top">
    <h4 class="uk-card-title">Weekly Digest</h4>

    <div class="uk-margin">
        <div class="uk-flex uk-flex-between uk-flex-middle">
            <div>
                <div class="uk-text-bold">Weekly Summary Email</div>
                <div class="uk-text-small uk-text-muted">Receive a weekly summary of all activities</div>
            </div>
            <label class="uk-switch">
                <input type="checkbox" checked>
                <span class="uk-switch-slider"></span>
            </label>
        </div>
    </div>

    <div class="uk-margin">
        <label class="uk-form-label">Preferred Day</label>
        <select class="uk-select uk-form-width-medium">
            <option>Monday</option>
            <option>Tuesday</option>
            <option>Wednesday</option>
            <option>Thursday</option>
            <option selected>Friday</option>
            <option>Saturday</option>
            <option>Sunday</option>
        </select>
    </div>
</div>

<div class="uk-margin-top">
    <button class="uk-button uk-button-primary">Save Preferences</button>
    <button class="uk-button uk-button-default uk-margin-small-left">Reset to Defaults</button>
</div>

<style>
.uk-switch {
    position: relative;
    display: inline-block;
    width: 50px;
    height: 26px;
}
.uk-switch input {
    opacity: 0;
    width: 0;
    height: 0;
}
.uk-switch-slider {
    position: absolute;
    cursor: pointer;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-color: #ccc;
    transition: .4s;
    border-radius: 26px;
}
.uk-switch-slider:before {
    position: absolute;
    content: "";
    height: 20px;
    width: 20px;
    left: 3px;
    bottom: 3px;
    background-color: white;
    transition: .4s;
    border-radius: 50%;
}
input:checked + .uk-switch-slider {
    background-color: #1a1a1a;
}
input:checked + .uk-switch-slider:before {
    transform: translateX(24px);
}
</style>
