<?php
require_once __DIR__ . '/../includes/bootstrap.php';

$notifications = [
    ['id' => 1, 'type' => 'application', 'title' => 'New application submitted', 'message' => 'John Doe - Stanford University', 'time' => '2024-01-30 14:30:00', 'read' => false],
    ['id' => 2, 'type' => 'payment', 'title' => 'Payment received', 'message' => '$5,000 from Sarah Chen', 'time' => '2024-01-30 13:00:00', 'read' => false],
    ['id' => 3, 'type' => 'document', 'title' => 'Document uploaded', 'message' => 'Transcript - Emma Wilson', 'time' => '2024-01-30 11:00:00', 'read' => false],
    ['id' => 4, 'type' => 'user', 'title' => 'New user registered', 'message' => 'michael.chen@email.com', 'time' => '2024-01-30 09:30:00', 'read' => true],
    ['id' => 5, 'type' => 'system', 'title' => 'System backup completed', 'message' => 'All data backed up successfully', 'time' => '2024-01-30 02:00:00', 'read' => true],
    ['id' => 6, 'type' => 'application', 'title' => 'Application status updated', 'message' => 'Jane Doe - MIT - Accepted', 'time' => '2024-01-29 16:00:00', 'read' => true],
];

$type_icons = [
    'application' => 'file-text',
    'payment' => 'credit-card',
    'document' => 'folder',
    'user' => 'user',
    'system' => 'cog'
];
?>

<div class="uk-flex uk-flex-between uk-flex-middle uk-margin-bottom">
    <h3 class="uk-margin-remove">Notifications</h3>
    <div>
        <button class="uk-button uk-button-default uk-button-small uk-margin-small-right" uk-toggle="target: #mark-all-read-modal">Mark All Read</button>
        <select class="uk-select uk-form-small" style="width: 150px;">
            <option>All Notifications</option>
            <option>Unread Only</option>
            <option>Applications</option>
            <option>Payments</option>
            <option>System</option>
        </select>
    </div>
</div>

<div class="uk-card uk-card-default uk-card-body">
    <?php foreach ($notifications as $notification): ?>
    <div class="uk-flex uk-flex-between uk-flex-middle uk-padding-small uk-margin-small-bottom <?= $notification['read'] ? '' : 'uk-background-muted' ?>" style="border-radius: 8px;">
        <div class="uk-flex uk-flex-middle">
            <span uk-icon="icon: <?= $type_icons[$notification['type']] ?>" class="uk-margin-right"></span>
            <div>
                <div class="uk-text-bold uk-text-small">
                    <?= e($notification['title']) ?>
                    <?php if (!$notification['read']): ?>
                        <span class="uk-badge uk-margin-small-left">New</span>
                    <?php endif; ?>
                </div>
                <div class="uk-text-muted uk-text-small"><?= e($notification['message']) ?></div>
                <div class="uk-text-meta uk-text-small"><?= e($notification['time']) ?></div>
            </div>
        </div>
        <div>
            <a href="#" uk-icon="icon: more-vertical; ratio: 0.8"></a>
            <div uk-dropdown="mode: click; pos: bottom-right">
                <ul class="uk-nav uk-dropdown-nav">
                    <li class="uk-nav-header">Actions</li>
                    <?php if (!$notification['read']): ?>
                    <li><a href="#" uk-toggle="target: #mark-read-modal"><span uk-icon="icon: check; ratio: 0.8" class="uk-margin-small-right"></span> Mark as Read</a></li>
                    <?php else: ?>
                    <li><a href="#" uk-toggle="target: #mark-unread-modal"><span uk-icon="icon: close; ratio: 0.8" class="uk-margin-small-right"></span> Mark as Unread</a></li>
                    <?php endif; ?>
                    <li><a href="#" uk-toggle="target: #view-notification-modal"><span uk-icon="icon: eye; ratio: 0.8" class="uk-margin-small-right"></span> View Details</a></li>
                    <li><a href="#" uk-toggle="target: #mute-similar-modal"><span uk-icon="icon: bell-slash; ratio: 0.8" class="uk-margin-small-right"></span> Mute Similar</a></li>
                    <li class="uk-nav-divider"></li>
                    <li><a href="#" class="uk-text-danger" uk-toggle="target: #delete-notification-modal"><span uk-icon="icon: trash; ratio: 0.8" class="uk-margin-small-right"></span> Delete</a></li>
                </ul>
            </div>
        </div>
    </div>
    <?php endforeach; ?>

    <div class="uk-text-center uk-margin-top">
        <button class="uk-button uk-button-default">Load More</button>
    </div>
</div>

<!-- Mark All Read Modal -->
<div id="mark-all-read-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Mark All as Read</h2>
        </div>
        <div class="uk-modal-body">
            <p>Are you sure you want to mark all notifications as read?</p>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Mark All Read</button>
        </div>
    </div>
</div>

<!-- Mark Read Modal -->
<div id="mark-read-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Mark as Read</h2>
        </div>
        <div class="uk-modal-body">
            <p>Mark this notification as read?</p>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Mark Read</button>
        </div>
    </div>
</div>

<!-- Mark Unread Modal -->
<div id="mark-unread-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Mark as Unread</h2>
        </div>
        <div class="uk-modal-body">
            <p>Mark this notification as unread?</p>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Mark Unread</button>
        </div>
    </div>
</div>

<!-- View Notification Modal -->
<div id="view-notification-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Notification Details</h2>
        </div>
        <div class="uk-modal-body">
            <dl class="uk-description-list uk-description-list-divider">
                <dt>Title</dt>
                <dd>New application submitted</dd>
                <dt>Message</dt>
                <dd>John Doe - Stanford University</dd>
                <dt>Type</dt>
                <dd><span class="uk-label">Application</span></dd>
                <dt>Time</dt>
                <dd>January 30, 2024 at 2:30 PM</dd>
            </dl>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Close</button>
        </div>
    </div>
</div>

<!-- Mute Similar Modal -->
<div id="mute-similar-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Mute Similar Notifications</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Mute Duration</label>
                    <select class="uk-select">
                        <option>1 hour</option>
                        <option>8 hours</option>
                        <option>24 hours</option>
                        <option>1 week</option>
                        <option>Forever</option>
                    </select>
                </div>
                <p class="uk-text-muted uk-text-small">You will stop receiving notifications of this type for the selected duration.</p>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Mute</button>
        </div>
    </div>
</div>

<!-- Delete Notification Modal -->
<div id="delete-notification-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Delete Notification</h2>
        </div>
        <div class="uk-modal-body">
            <p>Are you sure you want to delete this notification?</p>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-danger" type="button">Delete</button>
        </div>
    </div>
</div>
