<?php
/**
 * Overview Page Content (Partial)
 * Returns only content for htmx loading
 */

require_once __DIR__ . '/../includes/bootstrap.php';

// Mock data for overview stats with sparkline data
$stats = [
    [
        'icon' => 'fa-users',
        'value' => '2,847',
        'label' => 'Total Users',
        'trend' => '+12% this month',
        'color' => '#667eea',
        'color_dark' => '#5568d3',
        'sparkline_data' => [1200, 1450, 1650, 1800, 2100, 2300, 2500, 2650, 2847]
    ],
    [
        'icon' => 'fa-file-text',
        'value' => '1,234',
        'label' => 'Active Applications',
        'trend' => '+8% this month',
        'color' => '#32d296',
        'color_dark' => '#28b67f',
        'sparkline_data' => [890, 920, 980, 1050, 1100, 1150, 1180, 1210, 1234]
    ],
    [
        'icon' => 'fa-credit-card',
        'value' => '$235K',
        'label' => 'Monthly Revenue',
        'trend' => '+15% this month',
        'color' => '#faa05a',
        'color_dark' => '#f48939',
        'sparkline_data' => [150, 165, 180, 185, 190, 200, 215, 225, 235]
    ],
    [
        'icon' => 'fa-chart-line',
        'value' => '68.5%',
        'label' => 'Conversion Rate',
        'trend' => 'Above average',
        'color' => '#1e87f0',
        'color_dark' => '#1b78d6',
        'sparkline_data' => [62, 63, 64, 65, 66, 67, 67.5, 68, 68.5]
    ]
];

$recent_activities = [
    ['icon' => 'fa-user', 'title' => 'New student registered', 'user' => 'John Doe', 'time' => '2 minutes ago', 'color' => '#667eea'],
    ['icon' => 'fa-credit-card', 'title' => 'Payment of $25,000 received', 'user' => 'Sarah Chen', 'time' => '15 minutes ago', 'color' => '#32d296'],
    ['icon' => 'fa-file-text', 'title' => 'Application submitted to Stanford', 'user' => 'Michael Rodriguez', 'time' => '1 hour ago', 'color' => '#faa05a'],
    ['icon' => 'fa-users', 'title' => 'Assigned to counselor Sarah Johnson', 'user' => 'Emma Wilson', 'time' => '2 hours ago', 'color' => '#1e87f0']
];

$top_destinations = [
    ['label' => 'United States', 'value' => 456, 'percentage' => 35.2],
    ['label' => 'United Kingdom', 'value' => 289, 'percentage' => 22.3],
    ['label' => 'Canada', 'value' => 234, 'percentage' => 18.1],
    ['label' => 'Australia', 'value' => 178, 'percentage' => 13.7],
    ['label' => 'Germany', 'value' => 98, 'percentage' => 7.6],
    ['label' => 'Netherlands', 'value' => 40, 'percentage' => 3.1]
];
?>

<style>
.stat-card {
    background: linear-gradient(135deg, var(--stat-color) 0%, var(--stat-color-dark) 100%);
    border-radius: 12px;
    padding: 24px;
    color: white;
    position: relative;
    overflow: hidden;
    transition: all 0.3s ease;
    box-shadow: 0 4px 16px rgba(0, 0, 0, 0.1);
}

.stat-card:hover {
    transform: translateY(-4px);
    box-shadow: 0 8px 24px rgba(0, 0, 0, 0.15);
}

.stat-card::before {
    content: '';
    position: absolute;
    top: -50%;
    right: -20%;
    width: 200px;
    height: 200px;
    border-radius: 50%;
    background: rgba(255, 255, 255, 0.1);
}

.stat-card::after {
    content: '';
    position: absolute;
    bottom: -30%;
    right: -10%;
    width: 150px;
    height: 150px;
    border-radius: 50%;
    background: rgba(255, 255, 255, 0.05);
}

.stat-content {
    position: relative;
    z-index: 1;
}

.stat-icon {
    font-size: 32px;
    opacity: 0.9;
    margin-bottom: 12px;
}

.stat-value {
    font-size: 32px;
    font-weight: 700;
    margin-bottom: 4px;
    line-height: 1.2;
}

.stat-label {
    font-size: 14px;
    opacity: 0.95;
    margin-bottom: 8px;
}

.stat-trend {
    font-size: 12px;
    opacity: 0.85;
    display: flex;
    align-items: center;
    gap: 4px;
}

.stat-sparkline {
    margin-top: 12px;
    height: 50px;
    position: relative;
    z-index: 2;
}

.activity-card {
    background: white;
    border-radius: 12px;
    padding: 24px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    margin-bottom: 20px;
}

.activity-item {
    padding: 16px;
    border-radius: 8px;
    margin-bottom: 12px;
    transition: all 0.2s ease;
    background: #f8fafc;
}

.activity-item:hover {
    background: #f1f5f9;
    transform: translateX(4px);
}

.activity-item:last-child {
    margin-bottom: 0;
}

.activity-icon {
    width: 40px;
    height: 40px;
    border-radius: 8px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    flex-shrink: 0;
}

.activity-title {
    font-size: 14px;
    font-weight: 600;
    color: #1a1a1a;
    margin-bottom: 4px;
}

.activity-user {
    font-size: 13px;
    color: #64748b;
}

.activity-time {
    font-size: 12px;
    color: #94a3b8;
}

.destinations-card {
    background: white;
    border-radius: 12px;
    padding: 24px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    margin-bottom: 20px;
}

.destination-item {
    padding: 12px 0;
    border-bottom: 1px solid #e2e8f0;
}

.destination-item:last-child {
    border-bottom: none;
}

.destination-label {
    font-size: 14px;
    font-weight: 600;
    color: #1a1a1a;
    margin-bottom: 8px;
}

.destination-bar {
    height: 8px;
    background: #e2e8f0;
    border-radius: 4px;
    overflow: hidden;
    margin-bottom: 4px;
}

.destination-fill {
    height: 100%;
    background: linear-gradient(90deg, #667eea 0%, #764ba2 100%);
    border-radius: 4px;
    transition: width 0.5s ease;
}

.destination-meta {
    font-size: 12px;
    color: #64748b;
    display: flex;
    justify-content: space-between;
}

.chart-card {
    background: white;
    border-radius: 12px;
    padding: 24px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    margin-bottom: 20px;
}

.card-title {
    font-size: 18px;
    font-weight: 600;
    color: #1a1a1a;
    margin-bottom: 20px;
}

@media (max-width: 959px) {
    .stat-card {
        padding: 20px;
    }

    .stat-value {
        font-size: 28px;
    }

    .stat-icon {
        font-size: 28px;
    }

    .stat-sparkline {
        height: 40px;
    }
}
</style>

<!-- Stats Cards with Sparklines -->
<div class="uk-grid-small uk-child-width-1-2@s uk-child-width-1-4@m" uk-grid>
    <?php foreach ($stats as $index => $stat): ?>
    <div>
        <div class="stat-card" style="--stat-color: <?= $stat['color'] ?>; --stat-color-dark: <?= $stat['color_dark'] ?>;">
            <div class="stat-content">
                <div class="stat-icon">
                    <i class="fa-slab fa-solid <?= $stat['icon'] ?>"></i>
                </div>
                <div class="stat-value"><?= e($stat['value']) ?></div>
                <div class="stat-label"><?= e($stat['label']) ?></div>
                <div class="stat-trend">
                    <i class="fa-slab fa-solid fa-arrow-up fa-xs"></i>
                    <span><?= e($stat['trend']) ?></span>
                </div>
                <div class="stat-sparkline" id="sparkline-<?= $index ?>"></div>
            </div>
        </div>
    </div>
    <?php endforeach; ?>
</div>

<!-- Applications Over Time & Revenue Chart -->
<div class="uk-grid-small uk-margin-top" uk-grid>
    <div class="uk-width-2-3@m">
        <div class="chart-card">
            <h4 class="card-title">
                <i class="fa-slab fa-solid fa-chart-area"></i> Applications Over Time
            </h4>
            <div id="applications-timeline-chart" style="height: 320px;"></div>
        </div>
    </div>
    <div class="uk-width-1-3@m">
        <div class="chart-card">
            <h4 class="card-title">
                <i class="fa-slab fa-solid fa-filter"></i> Application Funnel
            </h4>
            <div id="application-funnel-chart" style="height: 320px;"></div>
        </div>
    </div>
</div>

<!-- Revenue & Program Distribution -->
<div class="uk-grid-small" uk-grid>
    <div class="uk-width-1-2@m">
        <div class="chart-card">
            <h4 class="card-title">
                <i class="fa-slab fa-solid fa-chart-bar"></i> Monthly Revenue
            </h4>
            <div id="revenue-chart" style="height: 280px;"></div>
        </div>
    </div>
    <div class="uk-width-1-2@m">
        <div class="chart-card">
            <h4 class="card-title">
                <i class="fa-slab fa-solid fa-graduation-cap"></i> Program Distribution
            </h4>
            <div id="program-distribution-chart" style="height: 280px;"></div>
        </div>
    </div>
</div>

<!-- Recent Activities & Top Destinations -->
<div class="uk-grid-small" uk-grid>
    <div class="uk-width-1-2@m">
        <div class="activity-card">
            <h4 class="card-title">
                <i class="fa-slab fa-solid fa-bell"></i> Recent Activities
            </h4>
            <?php foreach ($recent_activities as $activity): ?>
            <div class="activity-item">
                <div class="uk-flex uk-flex-middle" style="gap: 16px;">
                    <div class="activity-icon" style="background: <?= $activity['color'] ?>;">
                        <i class="fa-slab fa-solid <?= $activity['icon'] ?>"></i>
                    </div>
                    <div style="flex: 1; min-width: 0;">
                        <div class="activity-title"><?= e($activity['title']) ?></div>
                        <div class="activity-user"><?= e($activity['user']) ?></div>
                    </div>
                    <div class="activity-time uk-visible@m">
                        <?= e($activity['time']) ?>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>

    <div class="uk-width-1-2@m">
        <div class="destinations-card">
            <h4 class="card-title">
                <i class="fa-slab fa-solid fa-globe"></i> Top Study Destinations
            </h4>
            <?php foreach ($top_destinations as $dest): ?>
            <div class="destination-item">
                <div class="destination-label"><?= e($dest['label']) ?></div>
                <div class="destination-bar">
                    <div class="destination-fill" style="width: <?= $dest['percentage'] ?>%;"></div>
                </div>
                <div class="destination-meta">
                    <span><?= number_format($dest['value']) ?> applications</span>
                    <span><?= $dest['percentage'] ?>%</span>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>

<!-- Application Distribution Map -->
<div class="chart-card uk-margin-top">
    <h4 class="card-title">
        <i class="fa-slab fa-solid fa-map"></i> Application Distribution by Country
    </h4>
    <div id="admin-world-map" style="height: 350px;"></div>
</div>

<script>
(function() {
    // ApexCharts - Sparklines in Stat Cards
    <?php foreach ($stats as $index => $stat): ?>
    var sparkline<?= $index ?> = document.getElementById('sparkline-<?= $index ?>');
    if (sparkline<?= $index ?> && typeof ApexCharts !== 'undefined') {
        var sparkOptions<?= $index ?> = {
            series: [{
                data: <?= json_encode($stat['sparkline_data']) ?>
            }],
            chart: {
                type: 'area',
                height: 50,
                sparkline: { enabled: true },
                animations: {
                    enabled: true,
                    easing: 'easeinout',
                    speed: 800
                }
            },
            stroke: {
                curve: 'smooth',
                width: 2
            },
            fill: {
                opacity: 0.3,
                type: 'gradient',
                gradient: {
                    shadeIntensity: 1,
                    opacityFrom: 0.5,
                    opacityTo: 0.1,
                    stops: [0, 90, 100]
                }
            },
            colors: ['#ffffff'],
            tooltip: {
                enabled: true,
                theme: 'dark',
                x: { show: false },
                y: {
                    title: {
                        formatter: function() { return ''; }
                    }
                }
            }
        };
        var chart<?= $index ?> = new ApexCharts(sparkline<?= $index ?>, sparkOptions<?= $index ?>);
        chart<?= $index ?>.render();
    }
    <?php endforeach; ?>

    // ECharts - Applications Over Time
    var applicationsTimelineEl = document.getElementById('applications-timeline-chart');
    if (applicationsTimelineEl && typeof echarts !== 'undefined') {
        var applicationsChart = echarts.init(applicationsTimelineEl);
        var applicationsOption = {
            tooltip: {
                trigger: 'axis',
                axisPointer: { type: 'cross' }
            },
            legend: {
                data: ['Applications', 'Accepted', 'Rejected'],
                bottom: 0,
                textStyle: { fontSize: 12 }
            },
            grid: {
                left: '3%',
                right: '4%',
                bottom: '15%',
                containLabel: true
            },
            xAxis: {
                type: 'category',
                boundaryGap: false,
                data: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec']
            },
            yAxis: {
                type: 'value'
            },
            series: [
                {
                    name: 'Applications',
                    type: 'line',
                    smooth: true,
                    areaStyle: {
                        color: new echarts.graphic.LinearGradient(0, 0, 0, 1, [
                            { offset: 0, color: 'rgba(102, 126, 234, 0.3)' },
                            { offset: 1, color: 'rgba(102, 126, 234, 0.05)' }
                        ])
                    },
                    data: [120, 132, 150, 168, 189, 210, 245, 280, 320, 345, 380, 420],
                    itemStyle: { color: '#667eea' },
                    lineStyle: { width: 3 }
                },
                {
                    name: 'Accepted',
                    type: 'line',
                    smooth: true,
                    areaStyle: {
                        color: new echarts.graphic.LinearGradient(0, 0, 0, 1, [
                            { offset: 0, color: 'rgba(50, 210, 150, 0.3)' },
                            { offset: 1, color: 'rgba(50, 210, 150, 0.05)' }
                        ])
                    },
                    data: [85, 92, 105, 118, 130, 145, 165, 185, 210, 225, 250, 275],
                    itemStyle: { color: '#32d296' },
                    lineStyle: { width: 3 }
                },
                {
                    name: 'Rejected',
                    type: 'line',
                    smooth: true,
                    data: [12, 15, 18, 20, 22, 25, 28, 32, 35, 38, 42, 45],
                    itemStyle: { color: '#f0506e' },
                    lineStyle: { width: 2, type: 'dashed' }
                }
            ]
        };
        applicationsChart.setOption(applicationsOption);
        window.addEventListener('resize', function() { applicationsChart.resize(); });
    }

    // ECharts - Application Funnel
    var funnelEl = document.getElementById('application-funnel-chart');
    if (funnelEl && typeof echarts !== 'undefined') {
        var funnelChart = echarts.init(funnelEl);
        var funnelOption = {
            tooltip: {
                trigger: 'item',
                formatter: '{b}: {c} ({d}%)'
            },
            series: [{
                type: 'funnel',
                left: '10%',
                width: '80%',
                label: {
                    fontSize: 12,
                    formatter: '{b}\n{c}'
                },
                labelLine: {
                    show: false
                },
                itemStyle: {
                    borderWidth: 0
                },
                emphasis: {
                    label: {
                        fontSize: 14,
                        fontWeight: 'bold'
                    }
                },
                data: [
                    { value: 1234, name: 'Inquiries', itemStyle: { color: '#667eea' } },
                    { value: 892, name: 'Applications', itemStyle: { color: '#32d296' } },
                    { value: 456, name: 'Under Review', itemStyle: { color: '#faa05a' } },
                    { value: 234, name: 'Interviews', itemStyle: { color: '#1e87f0' } },
                    { value: 134, name: 'Offers', itemStyle: { color: '#8b5cf6' } },
                    { value: 98, name: 'Enrolled', itemStyle: { color: '#ec4899' } }
                ]
            }]
        };
        funnelChart.setOption(funnelOption);
        window.addEventListener('resize', function() { funnelChart.resize(); });
    }

    // ECharts - Monthly Revenue
    var revenueEl = document.getElementById('revenue-chart');
    if (revenueEl && typeof echarts !== 'undefined') {
        var revenueChart = echarts.init(revenueEl);
        var revenueOption = {
            tooltip: {
                trigger: 'axis',
                axisPointer: { type: 'shadow' },
                formatter: function(params) {
                    return params[0].name + '<br/>' + params[0].marker + ' $' + params[0].value + 'K';
                }
            },
            grid: {
                left: '3%',
                right: '4%',
                bottom: '10%',
                containLabel: true
            },
            xAxis: {
                type: 'category',
                data: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
                axisLabel: { fontSize: 11 }
            },
            yAxis: {
                type: 'value',
                axisLabel: {
                    formatter: '${value}K',
                    fontSize: 11
                }
            },
            series: [{
                data: [150, 165, 180, 185, 190, 200, 215, 225, 235, 245, 260, 275],
                type: 'bar',
                barWidth: '60%',
                itemStyle: {
                    color: new echarts.graphic.LinearGradient(0, 0, 0, 1, [
                        { offset: 0, color: '#faa05a' },
                        { offset: 1, color: '#f48939' }
                    ]),
                    borderRadius: [6, 6, 0, 0]
                },
                emphasis: {
                    itemStyle: {
                        color: new echarts.graphic.LinearGradient(0, 0, 0, 1, [
                            { offset: 0, color: '#f48939' },
                            { offset: 1, color: '#e67828' }
                        ])
                    }
                }
            }]
        };
        revenueChart.setOption(revenueOption);
        window.addEventListener('resize', function() { revenueChart.resize(); });
    }

    // ECharts - Program Distribution
    var programEl = document.getElementById('program-distribution-chart');
    if (programEl && typeof echarts !== 'undefined') {
        var programChart = echarts.init(programEl);
        var programOption = {
            tooltip: {
                trigger: 'item',
                formatter: '{b}: {c} ({d}%)'
            },
            legend: {
                orient: 'vertical',
                right: 10,
                top: 'center',
                textStyle: { fontSize: 11 }
            },
            series: [{
                type: 'pie',
                radius: ['40%', '70%'],
                center: ['35%', '50%'],
                avoidLabelOverlap: false,
                itemStyle: {
                    borderRadius: 8,
                    borderColor: '#fff',
                    borderWidth: 2
                },
                label: {
                    show: false
                },
                emphasis: {
                    label: {
                        show: true,
                        fontSize: 14,
                        fontWeight: 'bold'
                    }
                },
                data: [
                    { value: 456, name: 'Masters', itemStyle: { color: '#667eea' } },
                    { value: 289, name: 'Bachelors', itemStyle: { color: '#32d296' } },
                    { value: 234, name: 'MBA', itemStyle: { color: '#faa05a' } },
                    { value: 178, name: 'PhD', itemStyle: { color: '#1e87f0' } },
                    { value: 77, name: 'Diploma', itemStyle: { color: '#8b5cf6' } }
                ]
            }]
        };
        programChart.setOption(programOption);
        window.addEventListener('resize', function() { programChart.resize(); });
    }

    // jsVectorMap - World Map
    var mapEl = document.getElementById('admin-world-map');
    if (mapEl && typeof jsVectorMap !== 'undefined') {
        new jsVectorMap({
            selector: '#admin-world-map',
            map: 'world',
            backgroundColor: 'transparent',
            regionStyle: {
                initial: { fill: '#e2e8f0', stroke: '#cbd5e1', strokeWidth: 0.5 },
                hover: { fillOpacity: 0.8 }
            },
            series: {
                regions: [{
                    values: { US: 456, GB: 289, CA: 234, AU: 178, DE: 98, NL: 40 },
                    scale: ['#ddd6fe', '#667eea'],
                    normalizeFunction: 'polynomial'
                }]
            },
            onRegionTooltipShow: function(event, tooltip, code) {
                var values = { US: 456, GB: 289, CA: 234, AU: 178, DE: 98, NL: 40 };
                if (values[code]) {
                    tooltip.text(tooltip.text() + '<br>Applications: ' + values[code]);
                }
            }
        });
    }
})();
</script>
