<?php
require_once __DIR__ . '/../includes/bootstrap.php';

$txn_id = $_GET['id'] ?? 'TXN-001';

// Sample transaction data (would come from database in production)
$transaction = [
    'id' => $txn_id,
    'user' => ['name' => 'John Doe', 'email' => 'john.doe@email.com', 'id' => 1, 'initials' => 'JD'],
    'amount' => '$25,000',
    'amount_raw' => 25000,
    'currency' => 'USD',
    'method' => 'Credit Card',
    'card_last4' => '4242',
    'card_brand' => 'Visa',
    'date' => '2024-01-30 14:32:15',
    'status' => 'completed',
    'description' => 'Tuition Payment - Spring 2024',
    'fee' => '$750',
    'net' => '$24,250',
    'application_id' => 'APP-001',
    'university' => 'Stanford University',
    'program' => 'Computer Science (MS)'
];

$txn_stats = [
    ['icon' => 'fa-dollar-sign', 'value' => '$25,000', 'label' => 'Total Amount', 'color' => '#32d296', 'color_dark' => '#28b67f'],
    ['icon' => 'fa-hand-holding-usd', 'value' => '$24,250', 'label' => 'Net Amount', 'color' => '#667eea', 'color_dark' => '#5568d3'],
    ['icon' => 'fa-percentage', 'value' => '$750', 'label' => 'Processing Fee', 'color' => '#faa05a', 'color_dark' => '#f48939'],
    ['icon' => 'fa-check-circle', 'value' => 'Completed', 'label' => 'Status', 'color' => '#1e87f0', 'color_dark' => '#1b78d6']
];

$timeline = [
    ['date' => '2024-01-30 14:32:15', 'event' => 'Payment completed successfully', 'user' => 'System', 'icon' => 'fa-check-circle', 'type' => 'success'],
    ['date' => '2024-01-30 14:32:10', 'event' => 'Payment processing initiated', 'user' => 'System', 'icon' => 'fa-spinner', 'type' => 'info'],
    ['date' => '2024-01-30 14:32:05', 'event' => 'Payment authorization received', 'user' => 'Payment Gateway', 'icon' => 'fa-shield-alt', 'type' => 'info'],
    ['date' => '2024-01-30 14:32:00', 'event' => 'Payment initiated by user', 'user' => 'John Doe', 'icon' => 'fa-play-circle', 'type' => 'info']
];

$related_transactions = [
    ['id' => 'TXN-045', 'type' => 'Application Fee', 'amount' => '$150', 'date' => '2024-01-15', 'status' => 'completed'],
    ['id' => 'TXN-023', 'type' => 'Document Processing', 'amount' => '$50', 'date' => '2024-01-10', 'status' => 'completed']
];

$status_colors = [
    'completed' => 'success',
    'pending' => 'warning',
    'failed' => 'danger',
    'refunded' => 'secondary'
];
?>

<style>
.back-link {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    color: #64748b;
    text-decoration: none;
    font-size: 14px;
    font-weight: 500;
    margin-bottom: 24px;
    transition: all 0.2s ease;
}

.back-link:hover {
    color: #667eea;
    text-decoration: none;
}

.payment-header-card {
    background: linear-gradient(135deg, #32d296 0%, #28b67f 100%);
    border-radius: 12px;
    padding: 32px;
    color: white;
    margin-bottom: 24px;
    box-shadow: 0 4px 16px rgba(50, 210, 150, 0.2);
}

.payment-icon-large {
    width: 80px;
    height: 80px;
    border-radius: 50%;
    background: rgba(255, 255, 255, 0.2);
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 36px;
    color: white;
    border: 3px solid rgba(255, 255, 255, 0.3);
}

.payment-id {
    font-size: 14px;
    color: rgba(255, 255, 255, 0.9);
    font-weight: 500;
    margin-bottom: 4px;
}

.payment-amount {
    font-size: 36px;
    font-weight: 700;
    margin: 0;
    color: white;
}

.payment-description {
    font-size: 15px;
    color: rgba(255, 255, 255, 0.9);
    margin-top: 8px;
}

.payment-badge {
    display: inline-block;
    padding: 6px 12px;
    border-radius: 6px;
    font-size: 12px;
    font-weight: 600;
    margin-right: 8px;
    margin-top: 12px;
    background: rgba(255, 255, 255, 0.2);
}

.modern-btn {
    padding: 10px 20px;
    border-radius: 8px;
    font-size: 14px;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.2s ease;
    display: inline-flex;
    align-items: center;
    gap: 8px;
    border: none;
}

.modern-btn-white {
    background: white;
    color: #32d296;
}

.modern-btn-white:hover {
    transform: translateY(-1px);
    box-shadow: 0 4px 12px rgba(255, 255, 255, 0.3);
}

.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 16px;
    margin-bottom: 24px;
}

.payment-stat-card {
    border-radius: 12px;
    padding: 20px;
    background: white;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    transition: all 0.3s ease;
}

.payment-stat-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 16px rgba(0, 0, 0, 0.12);
}

.stat-icon-small {
    width: 40px;
    height: 40px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 18px;
    margin-bottom: 12px;
}

.stat-value-small {
    font-size: 24px;
    font-weight: 700;
    color: #1a1a1a;
    margin-bottom: 4px;
}

.stat-label-small {
    font-size: 13px;
    color: #64748b;
    font-weight: 500;
}

.content-grid {
    display: grid;
    grid-template-columns: 1fr;
    gap: 20px;
    margin-top: 24px;
}

@media (min-width: 1200px) {
    .content-grid {
        grid-template-columns: 2fr 1fr;
    }
}

.modern-card {
    background: white;
    border-radius: 12px;
    padding: 24px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    margin-bottom: 20px;
}

.card-title {
    font-size: 18px;
    font-weight: 600;
    color: #1a1a1a;
    margin-bottom: 20px;
    display: flex;
    align-items: center;
    gap: 8px;
}

.info-list {
    list-style: none;
    padding: 0;
    margin: 0;
}

.info-list dt {
    font-size: 13px;
    color: #64748b;
    font-weight: 500;
    margin-bottom: 4px;
}

.info-list dd {
    font-size: 15px;
    color: #1a1a1a;
    font-weight: 500;
    margin-bottom: 16px;
    margin-left: 0;
}

.info-list dd:last-child {
    margin-bottom: 0;
}

.timeline-item {
    display: flex;
    gap: 16px;
    padding: 16px;
    border-radius: 8px;
    background: #f8fafc;
    margin-bottom: 12px;
    transition: all 0.2s ease;
    border-left: 3px solid #e2e8f0;
}

.timeline-item:hover {
    background: white;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
}

.timeline-item:last-child {
    margin-bottom: 0;
}

.timeline-icon {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background: linear-gradient(135deg, #32d296 0%, #28b67f 100%);
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 16px;
    flex-shrink: 0;
}

.related-txn-item {
    padding: 16px;
    border-radius: 8px;
    background: #f8fafc;
    margin-bottom: 12px;
    transition: all 0.2s ease;
    border: 1px solid #e2e8f0;
    cursor: pointer;
}

.related-txn-item:hover {
    border-color: #32d296;
    background: white;
    box-shadow: 0 2px 8px rgba(50, 210, 150, 0.1);
}

.related-txn-item:last-child {
    margin-bottom: 0;
}

.status-badge {
    padding: 6px 12px;
    border-radius: 6px;
    font-size: 12px;
    font-weight: 600;
    text-transform: uppercase;
}

.status-success {
    background: #d1fae5;
    color: #065f46;
}

.status-warning {
    background: #fef3c7;
    color: #92400e;
}

.status-danger {
    background: #fee2e2;
    color: #991b1b;
}

.status-secondary {
    background: #e2e8f0;
    color: #475569;
}

.user-chip {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    padding: 8px 12px;
    border-radius: 8px;
    background: #f0f4ff;
    cursor: pointer;
    transition: all 0.2s ease;
}

.user-chip:hover {
    background: #e0e7ff;
    transform: translateX(2px);
}

.user-avatar-small {
    width: 32px;
    height: 32px;
    border-radius: 50%;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 600;
    font-size: 12px;
}

@media (max-width: 959px) {
    .payment-header-card {
        padding: 24px;
    }

    .payment-amount {
        font-size: 28px;
    }

    .modern-btn {
        font-size: 13px;
        padding: 8px 16px;
    }

    .stats-grid {
        grid-template-columns: repeat(2, 1fr);
    }
}

@media (max-width: 640px) {
    .payment-header-card > div {
        flex-direction: column !important;
        align-items: flex-start !important;
    }

    .payment-header-card > div > div:last-child {
        width: 100%;
        margin-top: 16px;
    }

    .modern-btn {
        width: 100%;
        justify-content: center;
    }
}
</style>

<a href="<?= BASE_URL ?>/index.php"
   hx-get="<?= BASE_URL ?>/pages/payments.php"
   hx-target="#main-content"
   hx-swap="innerHTML"
   hx-push-url="<?= BASE_URL ?>/payments.php"
   class="back-link">
    <i class="fa-slab fa-solid fa-arrow-left"></i> Back to Payments
</a>

<!-- Payment Header -->
<div class="payment-header-card">
    <div style="display: flex; justify-content: space-between; align-items: center;">
        <div style="display: flex; align-items: center; gap: 24px;">
            <div class="payment-icon-large">
                <i class="fa-slab fa-solid fa-credit-card"></i>
            </div>
            <div>
                <div class="payment-id"><?= e($transaction['id']) ?></div>
                <h2 class="payment-amount"><?= e($transaction['amount']) ?></h2>
                <div class="payment-description"><?= e($transaction['description']) ?></div>
                <div>
                    <span class="payment-badge"><?= e($transaction['method']) ?></span>
                    <span class="payment-badge"><?= date('M d, Y', strtotime($transaction['date'])) ?></span>
                </div>
            </div>
        </div>
        <div style="display: flex; gap: 12px;">
            <button class="modern-btn modern-btn-white">
                <i class="fa-slab fa-solid fa-download"></i> Receipt
            </button>
            <button class="modern-btn modern-btn-white">
                <i class="fa-slab fa-solid fa-undo"></i> Refund
            </button>
        </div>
    </div>
</div>

<!-- Stats Grid -->
<div class="stats-grid">
    <?php foreach ($txn_stats as $stat): ?>
    <div class="payment-stat-card">
        <div class="stat-icon-small" style="background: linear-gradient(135deg, <?= $stat['color'] ?> 0%, <?= $stat['color_dark'] ?> 100%);">
            <i class="fa-slab fa-solid <?= $stat['icon'] ?>"></i>
        </div>
        <div class="stat-value-small"><?= e($stat['value']) ?></div>
        <div class="stat-label-small"><?= e($stat['label']) ?></div>
    </div>
    <?php endforeach; ?>
</div>

<!-- Main Content Grid -->
<div class="content-grid">
    <!-- Left Column -->
    <div>
        <!-- Payment Details -->
        <div class="modern-card">
            <h4 class="card-title">
                <i class="fa-slab fa-solid fa-info-circle"></i> Payment Details
            </h4>
            <dl class="info-list">
                <dt>Transaction ID</dt>
                <dd><code style="background: #f8fafc; padding: 4px 8px; border-radius: 4px; font-size: 14px;"><?= e($transaction['id']) ?></code></dd>

                <dt>Amount</dt>
                <dd><span style="font-size: 20px; color: #32d296;"><?= e($transaction['amount']) ?> <?= e($transaction['currency']) ?></span></dd>

                <dt>Processing Fee</dt>
                <dd><?= e($transaction['fee']) ?> (3%)</dd>

                <dt>Net Amount</dt>
                <dd><span style="font-weight: 700;"><?= e($transaction['net']) ?></span></dd>

                <dt>Payment Method</dt>
                <dd>
                    <i class="fa-slab fa-solid fa-credit-card"></i>
                    <?= e($transaction['card_brand']) ?> •••• <?= e($transaction['card_last4']) ?>
                </dd>

                <dt>Date & Time</dt>
                <dd>
                    <i class="fa-slab fa-solid fa-calendar"></i>
                    <?= date('F d, Y \a\t g:i A', strtotime($transaction['date'])) ?>
                </dd>

                <dt>Status</dt>
                <dd>
                    <span class="status-badge status-<?= $status_colors[$transaction['status']] ?>">
                        <i class="fa-slab fa-solid fa-check-circle"></i> <?= ucfirst($transaction['status']) ?>
                    </span>
                </dd>

                <dt>Description</dt>
                <dd><?= e($transaction['description']) ?></dd>
            </dl>
        </div>

        <!-- Related Application -->
        <div class="modern-card">
            <h4 class="card-title">
                <i class="fa-slab fa-solid fa-link"></i> Related Application
            </h4>
            <div style="padding: 16px; border-radius: 8px; background: #f8fafc; border: 1px solid #e2e8f0; cursor: pointer;"
                 hx-get="<?= BASE_URL ?>/pages/application-detail.php?id=<?= $transaction['application_id'] ?>"
                 hx-target="#main-content"
                 hx-swap="innerHTML"
                 hx-push-url="<?= BASE_URL ?>/application-detail.php?id=<?= $transaction['application_id'] ?>">
                <div style="display: flex; justify-content: space-between; align-items: center;">
                    <div>
                        <div style="font-size: 11px; font-weight: 600; color: #667eea; background: #f0f4ff; padding: 4px 8px; border-radius: 4px; display: inline-block; margin-bottom: 6px;">
                            <?= e($transaction['application_id']) ?>
                        </div>
                        <div style="font-weight: 600; color: #1a1a1a; font-size: 16px; margin-bottom: 4px;">
                            <?= e($transaction['university']) ?>
                        </div>
                        <div style="font-size: 13px; color: #64748b;">
                            <i class="fa-slab fa-solid fa-graduation-cap"></i> <?= e($transaction['program']) ?>
                        </div>
                    </div>
                    <div>
                        <i class="fa-slab fa-solid fa-arrow-right" style="color: #667eea;"></i>
                    </div>
                </div>
            </div>
        </div>

        <!-- Transaction Timeline -->
        <div class="modern-card">
            <h4 class="card-title">
                <i class="fa-slab fa-solid fa-history"></i> Transaction Timeline
            </h4>
            <?php foreach ($timeline as $item): ?>
            <div class="timeline-item">
                <div class="timeline-icon">
                    <i class="fa-slab fa-solid <?= $item['icon'] ?>"></i>
                </div>
                <div style="flex: 1;">
                    <div style="font-size: 14px; color: #1a1a1a; font-weight: 500;"><?= e($item['event']) ?></div>
                    <div style="font-size: 12px; color: #94a3b8; margin-top: 2px;">
                        <?= date('M d, Y \a\t g:i A', strtotime($item['date'])) ?> • <?= e($item['user']) ?>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>

    <!-- Right Column -->
    <div>
        <!-- Customer Information -->
        <div class="modern-card">
            <h4 class="card-title">
                <i class="fa-slab fa-solid fa-user"></i> Customer Information
            </h4>
            <div class="user-chip"
                 hx-get="<?= BASE_URL ?>/pages/user-detail.php?id=<?= $transaction['user']['id'] ?>"
                 hx-target="#main-content"
                 hx-swap="innerHTML"
                 hx-push-url="<?= BASE_URL ?>/user-detail.php?id=<?= $transaction['user']['id'] ?>">
                <div class="user-avatar-small"><?= $transaction['user']['initials'] ?></div>
                <div>
                    <div style="font-weight: 600; color: #1a1a1a; font-size: 14px;"><?= e($transaction['user']['name']) ?></div>
                    <div style="font-size: 12px; color: #64748b;"><?= e($transaction['user']['email']) ?></div>
                </div>
            </div>

            <dl class="info-list" style="margin-top: 20px;">
                <dt>Customer ID</dt>
                <dd><code style="background: #f8fafc; padding: 4px 8px; border-radius: 4px; font-size: 13px;">#<?= e($transaction['user']['id']) ?></code></dd>

                <dt>Email</dt>
                <dd><i class="fa-slab fa-solid fa-envelope fa-sm"></i> <?= e($transaction['user']['email']) ?></dd>

                <dt>View Profile</dt>
                <dd>
                    <a href="#"
                       hx-get="<?= BASE_URL ?>/pages/user-detail.php?id=<?= $transaction['user']['id'] ?>"
                       hx-target="#main-content"
                       hx-swap="innerHTML"
                       hx-push-url="<?= BASE_URL ?>/user-detail.php?id=<?= $transaction['user']['id'] ?>"
                       style="color: #667eea; text-decoration: none;">
                        <i class="fa-slab fa-solid fa-arrow-right"></i> View full profile
                    </a>
                </dd>
            </dl>
        </div>

        <!-- Related Transactions -->
        <div class="modern-card">
            <h4 class="card-title">
                <i class="fa-slab fa-solid fa-exchange-alt"></i> Related Transactions
            </h4>
            <?php if (!empty($related_transactions)): ?>
                <?php foreach ($related_transactions as $rtxn): ?>
                <div class="related-txn-item"
                     hx-get="<?= BASE_URL ?>/pages/payment-detail.php?id=<?= $rtxn['id'] ?>"
                     hx-target="#main-content"
                     hx-swap="innerHTML"
                     hx-push-url="<?= BASE_URL ?>/payment-detail.php?id=<?= $rtxn['id'] ?>">
                    <div style="display: flex; justify-content: space-between; align-items: center;">
                        <div>
                            <div style="font-size: 11px; font-weight: 600; color: #32d296; background: #d1fae5; padding: 4px 8px; border-radius: 4px; display: inline-block; margin-bottom: 4px;">
                                <?= e($rtxn['id']) ?>
                            </div>
                            <div style="font-weight: 600; color: #1a1a1a; font-size: 14px; margin-bottom: 2px;">
                                <?= e($rtxn['type']) ?>
                            </div>
                            <div style="font-size: 12px; color: #64748b;">
                                <i class="fa-slab fa-solid fa-calendar fa-xs"></i> <?= date('M d, Y', strtotime($rtxn['date'])) ?>
                            </div>
                        </div>
                        <div style="text-align: right;">
                            <div style="font-weight: 700; color: #32d296; font-size: 16px;"><?= e($rtxn['amount']) ?></div>
                            <span class="status-badge status-<?= $status_colors[$rtxn['status']] ?>" style="font-size: 10px;">
                                <?= ucfirst($rtxn['status']) ?>
                            </span>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            <?php else: ?>
                <p style="text-align: center; color: #94a3b8; padding: 20px;">No related transactions</p>
            <?php endif; ?>
        </div>

        <!-- Actions -->
        <div class="modern-card">
            <h4 class="card-title">
                <i class="fa-slab fa-solid fa-cog"></i> Actions
            </h4>
            <div style="display: flex; flex-direction: column; gap: 8px;">
                <button class="uk-button uk-button-default uk-width-1-1" style="justify-content: flex-start;">
                    <i class="fa-slab fa-solid fa-download fa-fw"></i> Download Receipt
                </button>
                <button class="uk-button uk-button-default uk-width-1-1" style="justify-content: flex-start;">
                    <i class="fa-slab fa-solid fa-envelope fa-fw"></i> Send Receipt via Email
                </button>
                <button class="uk-button uk-button-default uk-width-1-1" style="justify-content: flex-start;">
                    <i class="fa-slab fa-solid fa-print fa-fw"></i> Print Receipt
                </button>
                <?php if ($transaction['status'] === 'completed'): ?>
                <hr style="margin: 8px 0;">
                <button class="uk-button uk-button-danger uk-width-1-1" style="justify-content: flex-start;">
                    <i class="fa-slab fa-solid fa-undo fa-fw"></i> Process Refund
                </button>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<script>
// Re-initialize UIKit components after HTMX load
document.addEventListener('DOMContentLoaded', function() {
    if (typeof UIkit !== 'undefined') {
        UIkit.update();
    }
});

if (typeof UIkit !== 'undefined') {
    UIkit.update();
}
</script>
