<?php
/**
 * Payments Page Content (Partial)
 */

require_once __DIR__ . '/../includes/bootstrap.php';

$payment_stats = [
    ['icon' => 'fa-credit-card', 'value' => '$2.8M', 'label' => 'Total Revenue', 'trend' => '+15% this month', 'color' => '#32d296', 'color_dark' => '#28b67f'],
    ['icon' => 'fa-calendar', 'value' => '$235K', 'label' => 'This Month', 'trend' => '+8% this month', 'color' => '#667eea', 'color_dark' => '#5568d3'],
    ['icon' => 'fa-clock', 'value' => '$45K', 'label' => 'Pending Payments', 'trend' => '12 transactions', 'color' => '#faa05a', 'color_dark' => '#f48939'],
    ['icon' => 'fa-undo', 'value' => '$12K', 'label' => 'Refunds Processed', 'trend' => '8 this month', 'color' => '#f0506e', 'color_dark' => '#e03e5c']
];

$payment_methods = [
    ['label' => 'Credit/Debit Card', 'value' => 1234, 'amount' => '$1.2M', 'percentage' => 100, 'color' => '#667eea'],
    ['label' => 'Bank Transfer', 'value' => 456, 'amount' => '$890K', 'percentage' => 37, 'color' => '#32d296'],
    ['label' => 'Digital Wallet', 'value' => 234, 'amount' => '$340K', 'percentage' => 19, 'color' => '#faa05a'],
    ['label' => 'Cash', 'value' => 89, 'amount' => '$120K', 'percentage' => 7, 'color' => '#1e87f0']
];

$transactions = [
    ['id' => 'TXN-001', 'user' => 'John Doe', 'method' => 'Credit Card', 'date' => '2024-01-30 14:32', 'amount' => '$25,000', 'status' => 'completed'],
    ['id' => 'TXN-002', 'user' => 'Sarah Chen', 'method' => 'Bank Transfer', 'date' => '2024-01-30 13:15', 'amount' => '$15,000', 'status' => 'pending'],
    ['id' => 'TXN-003', 'user' => 'Michael Rodriguez', 'method' => 'Digital Wallet', 'date' => '2024-01-30 11:45', 'amount' => '$20,000', 'status' => 'completed'],
    ['id' => 'TXN-004', 'user' => 'Emma Wilson', 'method' => 'Bank Transfer', 'date' => '2024-01-30 10:23', 'amount' => '$30,000', 'status' => 'failed']
];

$status_config = [
    'completed' => ['label' => 'Completed', 'color' => '#32d296', 'icon' => 'fa-check-circle'],
    'pending' => ['label' => 'Pending', 'color' => '#faa05a', 'icon' => 'fa-clock'],
    'failed' => ['label' => 'Failed', 'color' => '#f0506e', 'icon' => 'fa-times-circle']
];
?>

<style>
.stat-card {
    background: linear-gradient(135deg, var(--stat-color) 0%, var(--stat-color-dark) 100%);
    border-radius: 12px;
    padding: 24px;
    color: white;
    position: relative;
    overflow: hidden;
    transition: all 0.3s ease;
    box-shadow: 0 4px 16px rgba(0, 0, 0, 0.1);
}

.stat-card:hover {
    transform: translateY(-4px);
    box-shadow: 0 8px 24px rgba(0, 0, 0, 0.15);
}

.stat-card::before {
    content: '';
    position: absolute;
    top: -50%;
    right: -20%;
    width: 200px;
    height: 200px;
    border-radius: 50%;
    background: rgba(255, 255, 255, 0.1);
}

.stat-content {
    position: relative;
    z-index: 1;
}

.stat-icon {
    font-size: 32px;
    opacity: 0.9;
    margin-bottom: 12px;
}

.stat-value {
    font-size: 32px;
    font-weight: 700;
    margin-bottom: 4px;
}

.stat-label {
    font-size: 14px;
    opacity: 0.95;
    margin-bottom: 8px;
}

.stat-trend {
    font-size: 12px;
    opacity: 0.85;
}

.payment-card {
    background: white;
    border-radius: 12px;
    padding: 24px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    margin-bottom: 20px;
}

.card-title {
    font-size: 18px;
    font-weight: 600;
    color: #1a1a1a;
    margin-bottom: 20px;
}

.method-item {
    padding: 16px 0;
    border-bottom: 1px solid #e2e8f0;
}

.method-item:last-child {
    border-bottom: none;
}

.method-label {
    font-size: 14px;
    font-weight: 600;
    color: #1a1a1a;
    margin-bottom: 8px;
    display: flex;
    justify-content: space-between;
}

.method-bar {
    height: 8px;
    background: #e2e8f0;
    border-radius: 4px;
    overflow: hidden;
    margin-bottom: 4px;
}

.method-fill {
    height: 100%;
    border-radius: 4px;
    transition: width 0.5s ease;
}

.method-meta {
    font-size: 12px;
    color: #64748b;
}

.analytics-item {
    padding: 12px 16px;
    border-radius: 8px;
    margin-bottom: 12px;
    background: #f8fafc;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.analytics-label {
    font-size: 13px;
    color: #64748b;
}

.analytics-value {
    font-size: 16px;
    font-weight: 600;
    color: #1a1a1a;
}

.transaction-item {
    padding: 16px;
    border-radius: 8px;
    margin-bottom: 12px;
    transition: all 0.2s ease;
    background: #f8fafc;
    border-left: 4px solid transparent;
}

.transaction-item:hover {
    background: #f1f5f9;
    border-left-color: #667eea;
    transform: translateX(4px);
}

.transaction-item:last-child {
    margin-bottom: 0;
}

.transaction-id {
    font-size: 11px;
    font-weight: 600;
    color: #667eea;
    background: #f0f4ff;
    padding: 4px 8px;
    border-radius: 4px;
    display: inline-block;
    margin-bottom: 4px;
}

.transaction-user {
    font-size: 15px;
    font-weight: 600;
    color: #1a1a1a;
    margin-bottom: 4px;
}

.transaction-method {
    font-size: 13px;
    color: #64748b;
}

.transaction-date {
    font-size: 12px;
    color: #94a3b8;
}

.transaction-amount {
    font-size: 18px;
    font-weight: 700;
    color: #32d296;
    margin-bottom: 4px;
}

.status-badge {
    padding: 4px 12px;
    border-radius: 6px;
    font-size: 11px;
    font-weight: 600;
    color: white;
    display: inline-flex;
    align-items: center;
    gap: 4px;
}

.action-menu-btn {
    width: 32px;
    height: 32px;
    border-radius: 6px;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: all 0.2s ease;
    color: #64748b;
    background: white;
}

.action-menu-btn:hover {
    background: #667eea;
    color: white;
}

@media (max-width: 959px) {
    .stat-card {
        padding: 20px;
    }

    .stat-value {
        font-size: 28px;
    }

    .stat-icon {
        font-size: 28px;
    }

    .transaction-date {
        display: none;
    }
}
</style>

<div class="uk-flex uk-flex-between uk-flex-middle uk-margin-bottom mobile-stack">
    <h3 class="uk-margin-remove mobile-mb">
        <i class="fa-slab fa-solid fa-credit-card"></i> Payment Management
    </h3>
    <div class="uk-flex" style="gap: 8px;">
        <button class="uk-button uk-button-default uk-button-small" uk-toggle="target: #export-transactions-modal">
            <i class="fa-slab fa-solid fa-download"></i> <span class="uk-visible@m">Export</span>
        </button>
        <button class="uk-button uk-button-primary uk-button-small" uk-toggle="target: #process-refund-modal">
            <i class="fa-slab fa-solid fa-undo"></i> <span class="uk-visible@m">Refund</span>
        </button>
    </div>
</div>

<!-- Stats Cards -->
<div class="uk-grid-small uk-child-width-1-2@s uk-child-width-1-4@m uk-margin-bottom" uk-grid>
    <?php foreach ($payment_stats as $stat): ?>
    <div>
        <div class="stat-card" style="--stat-color: <?= $stat['color'] ?>; --stat-color-dark: <?= $stat['color_dark'] ?>;">
            <div class="stat-content">
                <div class="stat-icon">
                    <i class="fa-slab fa-solid <?= $stat['icon'] ?>"></i>
                </div>
                <div class="stat-value"><?= e($stat['value']) ?></div>
                <div class="stat-label"><?= e($stat['label']) ?></div>
                <div class="stat-trend"><?= e($stat['trend']) ?></div>
            </div>
        </div>
    </div>
    <?php endforeach; ?>
</div>

<!-- Payment Methods & Analytics -->
<div class="uk-grid-small" uk-grid>
    <div class="uk-width-1-2@m">
        <div class="payment-card">
            <h4 class="card-title">
                <i class="fa-slab fa-solid fa-wallet"></i> Payment Methods Performance
            </h4>
            <?php foreach ($payment_methods as $method): ?>
            <div class="method-item">
                <div class="method-label">
                    <span><?= e($method['label']) ?></span>
                    <span><?= e($method['amount']) ?></span>
                </div>
                <div class="method-bar">
                    <div class="method-fill" style="width: <?= $method['percentage'] ?>%; background: <?= $method['color'] ?>;"></div>
                </div>
                <div class="method-meta">
                    <?= number_format($method['value']) ?> transactions
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>

    <div class="uk-width-1-2@m">
        <div class="payment-card">
            <h4 class="card-title">
                <i class="fa-slab fa-solid fa-chart-line"></i> Payment Analytics
            </h4>
            <div class="analytics-item">
                <span class="analytics-label">Average Transaction:</span>
                <span class="analytics-value">$2,340</span>
            </div>
            <div class="analytics-item">
                <span class="analytics-label">Success Rate:</span>
                <span class="analytics-value" style="color: #32d296;">98.5%</span>
            </div>
            <div class="analytics-item">
                <span class="analytics-label">Failed Transactions:</span>
                <span class="analytics-value">1.5%</span>
            </div>
            <div class="analytics-item">
                <span class="analytics-label">Processing Time:</span>
                <span class="analytics-value">2.3 min avg</span>
            </div>
        </div>
    </div>
</div>

<!-- Recent Transactions -->
<div class="payment-card">
    <h4 class="card-title">
        <i class="fa-slab fa-solid fa-list"></i> Recent Transactions
    </h4>
    <?php foreach ($transactions as $txn):
        $status = $status_config[$txn['status']];
    ?>
    <div class="transaction-item"
         style="cursor: pointer;"
         hx-get="<?= BASE_URL ?>/pages/payment-detail.php?id=<?= $txn['id'] ?>"
         hx-target="#main-content"
         hx-swap="innerHTML"
         hx-push-url="<?= BASE_URL ?>/payment-detail.php?id=<?= $txn['id'] ?>">
        <div class="uk-flex uk-flex-between uk-flex-middle" style="gap: 16px;">
            <!-- Info -->
            <div style="flex: 1; min-width: 0;">
                <div class="transaction-id"><?= e($txn['id']) ?></div>
                <div class="transaction-user"><?= e($txn['user']) ?></div>
                <div class="transaction-method">
                    <i class="fa-slab fa-solid fa-credit-card fa-fw"></i> <?= e($txn['method']) ?>
                </div>
            </div>

            <!-- Date (Desktop) -->
            <div class="transaction-date uk-visible@m">
                <i class="fa-slab fa-solid fa-calendar fa-fw"></i> <?= date('M d, Y', strtotime($txn['date'])) ?>
            </div>

            <!-- Amount & Status -->
            <div class="uk-text-right">
                <div class="transaction-amount"><?= e($txn['amount']) ?></div>
                <span class="status-badge" style="background: <?= $status['color'] ?>;">
                    <i class="fa-slab fa-solid <?= $status['icon'] ?>"></i>
                    <span><?= $status['label'] ?></span>
                </span>
            </div>

            <!-- Actions -->
            <div class="action-menu-btn uk-visible@m" uk-tooltip="Actions">
                <i class="fa-slab fa-solid fa-ellipsis-v"></i>
                <div uk-dropdown="mode: click; pos: bottom-right">
                    <ul class="uk-nav uk-dropdown-nav">
                        <li class="uk-nav-header">Actions</li>
                        <li><a href="#" uk-toggle="target: #view-txn-details-modal"><i class="fa-slab fa-solid fa-eye fa-fw"></i> View Details</a></li>
                        <li><a href="#" uk-toggle="target: #view-receipt-modal"><i class="fa-slab fa-solid fa-file-text fa-fw"></i> View Receipt</a></li>
                        <li><a href="#" uk-toggle="target: #export-receipt-modal"><i class="fa-slab fa-solid fa-download fa-fw"></i> Export Receipt</a></li>
                        <?php if ($txn['status'] === 'completed'): ?>
                        <li class="uk-nav-divider"></li>
                        <li><a href="#" uk-toggle="target: #process-refund-modal"><i class="fa-slab fa-solid fa-undo fa-fw"></i> Process Refund</a></li>
                        <?php endif; ?>
                        <?php if ($txn['status'] === 'pending'): ?>
                        <li class="uk-nav-divider"></li>
                        <li><a href="#" uk-toggle="target: #mark-completed-modal"><i class="fa-slab fa-solid fa-check fa-fw"></i> Mark Completed</a></li>
                        <li><a href="#" uk-toggle="target: #cancel-txn-modal"><i class="fa-slab fa-solid fa-times fa-fw"></i> Cancel</a></li>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <?php endforeach; ?>
</div>

<!-- Export Transactions Modal -->
<div id="export-transactions-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title"><i class="fa-slab fa-solid fa-download"></i> Export Transactions</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Format</label>
                    <select class="uk-select">
                        <option>Excel</option>
                        <option>CSV</option>
                        <option>PDF</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Date Range</label>
                    <div class="uk-grid-small" uk-grid>
                        <div class="uk-width-1-2">
                            <input class="uk-input" type="date">
                        </div>
                        <div class="uk-width-1-2">
                            <input class="uk-input" type="date">
                        </div>
                    </div>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Status</label>
                    <select class="uk-select">
                        <option value="">All Statuses</option>
                        <option>Completed</option>
                        <option>Pending</option>
                        <option>Failed</option>
                    </select>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">
                <i class="fa-slab fa-solid fa-download"></i> Export
            </button>
        </div>
    </div>
</div>

<!-- Export Receipt Modal -->
<div id="export-receipt-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title"><i class="fa-slab fa-solid fa-file-pdf"></i> Export Receipt</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Format</label>
                    <select class="uk-select">
                        <option>PDF</option>
                        <option>PNG</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label><input class="uk-checkbox" type="checkbox" checked> Include company letterhead</label>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">
                <i class="fa-slab fa-solid fa-download"></i> Export
            </button>
        </div>
    </div>
</div>

<!-- Process Refund Modal -->
<div id="process-refund-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title"><i class="fa-slab fa-solid fa-undo"></i> Process Refund</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Transaction ID</label>
                    <select class="uk-select" required>
                        <option value="">Select transaction...</option>
                        <option>TXN-001 - John Doe ($25,000)</option>
                        <option>TXN-003 - Michael Rodriguez ($20,000)</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Refund Amount</label>
                    <div class="uk-inline uk-width-1-1">
                        <span class="uk-form-icon">$</span>
                        <input class="uk-input" type="number" placeholder="0.00" required>
                    </div>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Reason</label>
                    <select class="uk-select" required>
                        <option value="">Select reason...</option>
                        <option>Overpayment</option>
                        <option>Service not rendered</option>
                        <option>Duplicate payment</option>
                        <option>Customer request</option>
                        <option>Other</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Notes</label>
                    <textarea class="uk-textarea" rows="2" placeholder="Additional notes..."></textarea>
                </div>
                <div class="uk-margin">
                    <label><input class="uk-checkbox" type="checkbox" checked> Notify customer</label>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button" style="background: #faa05a;">
                <i class="fa-slab fa-solid fa-check"></i> Process Refund
            </button>
        </div>
    </div>
</div>

<!-- View Transaction Details Modal -->
<div id="view-txn-details-modal" uk-modal>
    <div class="uk-modal-dialog uk-width-large">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title"><i class="fa-slab fa-solid fa-info-circle"></i> Transaction Details</h2>
        </div>
        <div class="uk-modal-body">
            <dl class="uk-description-list uk-description-list-divider">
                <dt>Transaction ID</dt>
                <dd><code>TXN-001</code></dd>
                <dt>User</dt>
                <dd>John Doe (john.doe@email.com)</dd>
                <dt>Amount</dt>
                <dd class="uk-text-bold">$25,000</dd>
                <dt>Payment Method</dt>
                <dd>Credit Card (•••• 4242)</dd>
                <dt>Date & Time</dt>
                <dd>January 30, 2024 at 2:32 PM</dd>
                <dt>Status</dt>
                <dd><span class="uk-label uk-label-success">Completed</span></dd>
                <dt>Description</dt>
                <dd>Tuition Payment - Spring 2024</dd>
            </dl>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Close</button>
            <button class="uk-button uk-button-primary" type="button">
                <i class="fa-slab fa-solid fa-download"></i> Download Receipt
            </button>
        </div>
    </div>
</div>

<!-- View Receipt Modal -->
<div id="view-receipt-modal" uk-modal="container: false">
    <div class="uk-modal-dialog uk-modal-body uk-width-large">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <h2 class="uk-modal-title"><i class="fa-slab fa-solid fa-file-text"></i> Payment Receipt</h2>
        <div class="uk-text-center uk-padding">
            <i class="fa-slab fa-solid fa-file-text" style="font-size: 64px; color: #94a3b8;"></i>
            <p class="uk-text-muted uk-margin-top">Receipt preview would appear here</p>
        </div>
        <div class="uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Close</button>
            <button class="uk-button uk-button-primary" type="button">
                <i class="fa-slab fa-solid fa-download"></i> Download PDF
            </button>
        </div>
    </div>
</div>

<!-- Mark Completed Modal -->
<div id="mark-completed-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title"><i class="fa-slab fa-solid fa-check-circle"></i> Mark as Completed</h2>
        </div>
        <div class="uk-modal-body">
            <p>Are you sure you want to mark this transaction as completed?</p>
            <div class="uk-margin">
                <label class="uk-form-label">Notes (Optional)</label>
                <textarea class="uk-textarea" rows="2" placeholder="Any notes about completion..."></textarea>
            </div>
            <div class="uk-margin">
                <label><input class="uk-checkbox" type="checkbox" checked> Notify customer</label>
            </div>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button" style="background: #32d296;">
                <i class="fa-slab fa-solid fa-check"></i> Mark Completed
            </button>
        </div>
    </div>
</div>

<!-- Cancel Transaction Modal -->
<div id="cancel-txn-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title"><i class="fa-slab fa-solid fa-times-circle"></i> Cancel Transaction</h2>
        </div>
        <div class="uk-modal-body">
            <div class="uk-alert uk-alert-danger">
                <p><i class="fa-slab fa-solid fa-exclamation-triangle"></i> Are you sure you want to cancel this transaction? This action cannot be undone.</p>
            </div>
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Cancellation Reason</label>
                    <select class="uk-select" required>
                        <option value="">Select reason...</option>
                        <option>Payment failed</option>
                        <option>Customer request</option>
                        <option>Duplicate transaction</option>
                        <option>Other</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label><input class="uk-checkbox" type="checkbox" checked> Notify customer</label>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Keep Transaction</button>
            <button class="uk-button uk-button-danger" type="button">
                <i class="fa-slab fa-solid fa-times"></i> Cancel Transaction
            </button>
        </div>
    </div>
</div>
