<?php
require_once __DIR__ . '/../includes/bootstrap.php';

$user = $GLOBALS['current_user'];
?>

<div class="uk-flex uk-flex-between uk-flex-middle uk-margin-bottom">
    <h3 class="uk-margin-remove">My Profile</h3>
    <button class="uk-button uk-button-primary uk-button-small" uk-toggle="target: #edit-profile-modal">
        <span uk-icon="icon: pencil; ratio: 0.8"></span> Edit Profile
    </button>
</div>

<div class="uk-grid-small" uk-grid>
    <div class="uk-width-1-3@m">
        <div class="uk-card uk-card-default uk-card-body uk-text-center">
            <?= get_avatar($user['name'], 120) ?>
            <h4 class="uk-margin-small-top uk-margin-remove-bottom"><?= e($user['name']) ?></h4>
            <p class="uk-text-muted uk-margin-remove"><?= e($GLOBALS['role_names'][$user['role']]) ?></p>
            <div class="uk-margin-top">
                <button class="uk-button uk-button-default uk-button-small" uk-toggle="target: #change-avatar-modal">
                    <span uk-icon="icon: image; ratio: 0.8"></span> Change Avatar
                </button>
            </div>
        </div>

        <div class="uk-card uk-card-default uk-card-body uk-margin-top">
            <h5 class="uk-card-title">Quick Stats</h5>
            <dl class="uk-description-list">
                <dt>Member Since</dt>
                <dd>January 15, 2023</dd>
                <dt>Last Login</dt>
                <dd>Today at 9:45 AM</dd>
                <dt>Total Logins</dt>
                <dd>234</dd>
            </dl>
        </div>
    </div>

    <div class="uk-width-2-3@m">
        <div class="uk-card uk-card-default uk-card-body">
            <h4 class="uk-card-title">Personal Information</h4>
            <dl class="uk-description-list uk-description-list-divider">
                <dt>Full Name</dt>
                <dd><?= e($user['name']) ?></dd>
                <dt>Email Address</dt>
                <dd><?= e($user['email']) ?></dd>
                <dt>Phone Number</dt>
                <dd>+1 (555) 123-4567</dd>
                <dt>Department</dt>
                <dd>Administration</dd>
                <dt>Location</dt>
                <dd>New York, USA</dd>
                <dt>Timezone</dt>
                <dd>Eastern Time (ET)</dd>
            </dl>
        </div>

        <div class="uk-card uk-card-default uk-card-body uk-margin-top">
            <h4 class="uk-card-title">Security Settings</h4>
            <div class="uk-margin">
                <div class="uk-flex uk-flex-between uk-flex-middle">
                    <div>
                        <div class="uk-text-bold">Two-Factor Authentication</div>
                        <div class="uk-text-small uk-text-muted">Add an extra layer of security to your account</div>
                    </div>
                    <span class="uk-label uk-label-danger">Disabled</span>
                </div>
            </div>
            <div class="uk-margin">
                <div class="uk-flex uk-flex-between uk-flex-middle">
                    <div>
                        <div class="uk-text-bold">Password</div>
                        <div class="uk-text-small uk-text-muted">Last changed 30 days ago</div>
                    </div>
                    <button class="uk-button uk-button-default uk-button-small" uk-toggle="target: #change-password-modal">Change</button>
                </div>
            </div>
            <div class="uk-margin">
                <div class="uk-flex uk-flex-between uk-flex-middle">
                    <div>
                        <div class="uk-text-bold">Active Sessions</div>
                        <div class="uk-text-small uk-text-muted">2 devices currently logged in</div>
                    </div>
                    <button class="uk-button uk-button-default uk-button-small" uk-toggle="target: #manage-sessions-modal">Manage</button>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Change Avatar Modal -->
<div id="change-avatar-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Change Avatar</h2>
        </div>
        <div class="uk-modal-body">
            <div class="uk-text-center uk-margin-bottom">
                <?= get_avatar($user['name'], 100) ?>
            </div>
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Upload New Avatar</label>
                    <div uk-form-custom="target: true">
                        <input type="file" accept="image/*">
                        <input class="uk-input uk-form-width-large" type="text" placeholder="Select image..." disabled>
                    </div>
                    <p class="uk-text-small uk-text-muted uk-margin-small-top">Max file size: 2MB. Supported: JPG, PNG, GIF</p>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Upload</button>
        </div>
    </div>
</div>

<!-- Change Password Modal -->
<div id="change-password-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Change Password</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Current Password *</label>
                    <input class="uk-input" type="password" placeholder="Enter current password" required>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">New Password *</label>
                    <input class="uk-input" type="password" placeholder="Enter new password" required>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Confirm New Password *</label>
                    <input class="uk-input" type="password" placeholder="Confirm new password" required>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Change Password</button>
        </div>
    </div>
</div>

<!-- Manage Sessions Modal -->
<div id="manage-sessions-modal" uk-modal>
    <div class="uk-modal-dialog uk-width-large">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Active Sessions</h2>
        </div>
        <div class="uk-modal-body">
            <div class="uk-card uk-card-secondary uk-card-body uk-card-small uk-margin-small-bottom">
                <div class="uk-flex uk-flex-between uk-flex-middle">
                    <div>
                        <div class="uk-text-bold">Chrome on Windows</div>
                        <div class="uk-text-small">New York, USA &middot; Current session</div>
                    </div>
                    <span class="uk-label uk-label-success">Active</span>
                </div>
            </div>
            <div class="uk-card uk-card-default uk-card-body uk-card-small uk-margin-small-bottom">
                <div class="uk-flex uk-flex-between uk-flex-middle">
                    <div>
                        <div class="uk-text-bold">Safari on iPhone</div>
                        <div class="uk-text-small">New York, USA &middot; Last active 2 hours ago</div>
                    </div>
                    <button class="uk-button uk-button-danger uk-button-small">Revoke</button>
                </div>
            </div>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Close</button>
            <button class="uk-button uk-button-danger" type="button">Revoke All Other Sessions</button>
        </div>
    </div>
</div>

<!-- Edit Profile Modal -->
<div id="edit-profile-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Edit Profile</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Full Name</label>
                    <input class="uk-input" type="text" value="<?= e($user['name']) ?>">
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Email Address</label>
                    <input class="uk-input" type="email" value="<?= e($user['email']) ?>">
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Phone Number</label>
                    <input class="uk-input" type="tel" value="+1 (555) 123-4567">
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Location</label>
                    <input class="uk-input" type="text" value="New York, USA">
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Timezone</label>
                    <select class="uk-select">
                        <option selected>Eastern Time (ET)</option>
                        <option>Central Time (CT)</option>
                        <option>Mountain Time (MT)</option>
                        <option>Pacific Time (PT)</option>
                    </select>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Save Changes</button>
        </div>
    </div>
</div>
