<?php
/**
 * Reports Page Content (Partial)
 */

require_once __DIR__ . '/../includes/bootstrap.php';

$report_stats = [
    ['icon' => 'fa-check-circle', 'value' => '89.5%', 'label' => 'Acceptance Rate', 'color' => '#32d296', 'color_dark' => '#28b67f', 'sparkline_data' => [82, 84, 86, 87, 88, 88.5, 89, 89.2, 89.5]],
    ['icon' => 'fa-users', 'value' => '234', 'label' => 'New Students', 'color' => '#667eea', 'color_dark' => '#5568d3', 'sparkline_data' => [150, 165, 180, 195, 210, 220, 228, 231, 234]],
    ['icon' => 'fa-globe', 'value' => '24', 'label' => 'Countries Served', 'color' => '#faa05a', 'color_dark' => '#f48939', 'sparkline_data' => [18, 19, 20, 21, 21, 22, 23, 23, 24]],
    ['icon' => 'fa-clock', 'value' => '18.5', 'label' => 'Avg Processing Days', 'color' => '#1e87f0', 'color_dark' => '#1b78d6', 'sparkline_data' => [24, 23, 22, 21, 20.5, 20, 19.5, 19, 18.5]]
];

$monthly_trends = [
    ['month' => 'Jan', 'students' => 234, 'revenue' => '$185K'],
    ['month' => 'Feb', 'students' => 267, 'revenue' => '$210K'],
    ['month' => 'Mar', 'students' => 298, 'revenue' => '$245K'],
    ['month' => 'Apr', 'students' => 345, 'revenue' => '$287K'],
    ['month' => 'May', 'students' => 389, 'revenue' => '$324K'],
    ['month' => 'Jun', 'students' => 423, 'revenue' => '$356K']
];

$program_rates = [
    ['label' => 'Computer Science', 'value' => 456, 'percentage' => 92, 'suffix' => 'applications'],
    ['label' => 'Engineering', 'value' => 342, 'percentage' => 88, 'suffix' => 'applications'],
    ['label' => 'Business Administration', 'value' => 298, 'percentage' => 85, 'suffix' => 'applications'],
    ['label' => 'Medicine', 'value' => 234, 'percentage' => 78, 'suffix' => 'applications'],
    ['label' => 'Liberal Arts', 'value' => 187, 'percentage' => 94, 'suffix' => 'applications']
];

$counselors = [
    ['id' => 1, 'name' => 'Sarah Johnson', 'initials' => 'SJ', 'students' => 45, 'success' => '94%', 'response' => '2.3 hrs', 'satisfaction' => '4.8/5'],
    ['id' => 2, 'name' => 'Michael Chen', 'initials' => 'MC', 'students' => 38, 'success' => '91%', 'response' => '1.8 hrs', 'satisfaction' => '4.9/5'],
    ['id' => 3, 'name' => 'Emily Rodriguez', 'initials' => 'ER', 'students' => 42, 'success' => '89%', 'response' => '3.1 hrs', 'satisfaction' => '4.7/5'],
    ['id' => 4, 'name' => 'David Kim', 'initials' => 'DK', 'students' => 35, 'success' => '87%', 'response' => '2.7 hrs', 'satisfaction' => '4.6/5']
];
?>

<style>
.modern-stat-card {
    border-radius: 12px;
    padding: 24px;
    position: relative;
    overflow: hidden;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    transition: all 0.3s ease;
}

.modern-stat-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 16px rgba(0, 0, 0, 0.12);
}

.stat-card-bg {
    position: absolute;
    top: -30px;
    right: -30px;
    width: 120px;
    height: 120px;
    border-radius: 50%;
    opacity: 0.2;
}

.stat-icon {
    width: 48px;
    height: 48px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 20px;
    margin-bottom: 16px;
}

.stat-value {
    font-size: 32px;
    font-weight: 700;
    color: #1a1a1a;
    margin-bottom: 4px;
}

.stat-label {
    font-size: 14px;
    color: #64748b;
    font-weight: 500;
}

.stat-sparkline {
    margin-top: 16px;
    height: 50px;
}

.counselor-card {
    background: white;
    border-radius: 12px;
    padding: 20px;
    margin-bottom: 12px;
    transition: all 0.2s ease;
    border: 1px solid #e2e8f0;
}

.counselor-card:hover {
    border-color: #667eea;
    box-shadow: 0 4px 12px rgba(102, 126, 234, 0.1);
    transform: translateY(-2px);
}

.counselor-avatar {
    width: 48px;
    height: 48px;
    border-radius: 50%;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 600;
    font-size: 16px;
}

.metric-badge {
    text-align: center;
    padding: 12px;
    border-radius: 8px;
    background: #f8fafc;
}

.metric-value {
    font-size: 18px;
    font-weight: 700;
    color: #1a1a1a;
    margin-bottom: 4px;
}

.metric-label {
    font-size: 12px;
    color: #64748b;
}

.modern-chart-card {
    background: white;
    border-radius: 12px;
    padding: 24px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
}

.chart-title {
    font-size: 18px;
    font-weight: 600;
    color: #1a1a1a;
    margin-bottom: 20px;
}

.page-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 24px;
}

.page-title {
    font-size: 24px;
    font-weight: 700;
    color: #1a1a1a;
    margin: 0;
}

.header-actions {
    display: flex;
    gap: 12px;
}

.modern-select {
    padding: 8px 12px;
    border-radius: 8px;
    border: 1px solid #e2e8f0;
    font-size: 14px;
    color: #1a1a1a;
}

.modern-btn {
    padding: 8px 16px;
    border-radius: 8px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    border: none;
    font-size: 14px;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.2s ease;
    display: inline-flex;
    align-items: center;
    gap: 8px;
}

.modern-btn:hover {
    transform: translateY(-1px);
    box-shadow: 0 4px 12px rgba(102, 126, 234, 0.3);
}

@media (max-width: 959px) {
    .page-header {
        flex-direction: column;
        align-items: stretch;
        gap: 12px;
    }

    .header-actions {
        flex-direction: column;
    }
}
</style>

<div class="page-header">
    <h3 class="page-title">Reports & Analytics</h3>
    <div class="header-actions">
        <select class="modern-select">
            <option>Monthly</option>
            <option>Quarterly</option>
            <option>Yearly</option>
        </select>
        <button class="modern-btn" uk-toggle="target: #generate-report-modal">
            <i class="fa-slab fa-solid fa-download fa-sm"></i> Generate Report
        </button>
    </div>
</div>

<!-- Stats Grid -->
<div class="uk-grid-small uk-child-width-1-2@s uk-child-width-1-4@m" uk-grid>
    <?php foreach ($report_stats as $index => $stat): ?>
    <div>
        <div class="modern-stat-card" style="background: linear-gradient(135deg, <?= $stat['color'] ?> 0%, <?= $stat['color_dark'] ?> 100%);">
            <div class="stat-card-bg" style="background: linear-gradient(135deg, <?= $stat['color'] ?> 0%, <?= $stat['color_dark'] ?> 100%);"></div>
            <div class="stat-icon" style="background: rgba(255, 255, 255, 0.2);">
                <i class="fa-slab fa-solid <?= $stat['icon'] ?>"></i>
            </div>
            <div class="stat-value" style="color: white;"><?= e($stat['value']) ?></div>
            <div class="stat-label" style="color: rgba(255, 255, 255, 0.9);"><?= e($stat['label']) ?></div>
            <div class="stat-sparkline" id="sparkline-<?= $index ?>"></div>
        </div>
    </div>
    <?php endforeach; ?>
</div>

<!-- Charts Section -->
<div class="uk-grid-small uk-margin-top" uk-grid>
    <div class="uk-width-1-2@m">
        <div class="modern-chart-card">
            <h4 class="chart-title">Monthly Growth Trends</h4>
            <div id="monthly-growth-chart" style="height: 300px;"></div>
        </div>
    </div>
    <div class="uk-width-1-2@m">
        <div class="modern-chart-card">
            <h4 class="chart-title">Success Rates by Program Type</h4>
            <div id="program-success-chart" style="height: 300px;"></div>
        </div>
    </div>
</div>

<!-- Counselor Performance Section -->
<div class="modern-chart-card uk-margin-top">
    <h4 class="chart-title">Counselor Performance Metrics</h4>
    <?php foreach ($counselors as $counselor): ?>
        <div class="counselor-card"
             style="cursor: pointer;"
             hx-get="<?= BASE_URL ?>/pages/counselor-detail.php?id=<?= $counselor['id'] ?>"
             hx-target="#main-content"
             hx-swap="innerHTML"
             hx-push-url="<?= BASE_URL ?>/counselor-detail.php?id=<?= $counselor['id'] ?>">
            <div class="uk-flex uk-flex-between uk-flex-middle">
                <div class="uk-flex uk-flex-middle" style="gap: 16px;">
                    <div class="counselor-avatar"><?= $counselor['initials'] ?></div>
                    <div>
                        <div style="font-weight: 600; color: #1a1a1a; font-size: 16px;"><?= e($counselor['name']) ?></div>
                        <div style="font-size: 13px; color: #64748b; margin-top: 2px;"><?= $counselor['students'] ?> students managed</div>
                    </div>
                </div>
                <div class="uk-flex uk-flex-middle" style="gap: 16px;">
                    <div class="uk-flex" style="gap: 12px;">
                        <div class="metric-badge">
                            <div class="metric-value" style="color: #32d296;"><?= e($counselor['success']) ?></div>
                            <div class="metric-label">Success Rate</div>
                        </div>
                        <div class="metric-badge">
                            <div class="metric-value" style="color: #667eea;"><?= e($counselor['response']) ?></div>
                            <div class="metric-label">Avg Response</div>
                        </div>
                        <div class="metric-badge">
                            <div class="metric-value" style="color: #faa05a;"><?= e($counselor['satisfaction']) ?></div>
                            <div class="metric-label">Satisfaction</div>
                        </div>
                    </div>
                    <div class="uk-inline">
                        <button style="background: none; border: none; color: #64748b; cursor: pointer; padding: 8px;">
                            <i class="fa-slab fa-solid fa-ellipsis-v"></i>
                        </button>
                        <div uk-dropdown="mode: click; pos: bottom-right">
                            <ul class="uk-nav uk-dropdown-nav">
                                <li class="uk-nav-header">Actions</li>
                                <li><a href="#" uk-toggle="target: #view-counselor-profile-modal"><i class="fa-slab fa-solid fa-user fa-fw"></i> View Profile</a></li>
                                <li><a href="#" uk-toggle="target: #detailed-stats-modal"><i class="fa-slab fa-solid fa-chart-bar fa-fw"></i> Detailed Stats</a></li>
                                <li><a href="#" uk-toggle="target: #view-students-modal"><i class="fa-slab fa-solid fa-users fa-fw"></i> View Students</a></li>
                                <li><a href="#" uk-toggle="target: #send-message-modal"><i class="fa-slab fa-solid fa-envelope fa-fw"></i> Send Message</a></li>
                                <li class="uk-nav-divider"></li>
                                <li><a href="#" uk-toggle="target: #export-counselor-report-modal"><i class="fa-slab fa-solid fa-download fa-fw"></i> Export Report</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endforeach; ?>
</div>

<!-- Generate Report Modal -->
<div id="generate-report-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Generate Report</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Report Type</label>
                    <select class="uk-select">
                        <option>Performance Summary</option>
                        <option>Application Statistics</option>
                        <option>Revenue Report</option>
                        <option>Counselor Metrics</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Date Range</label>
                    <div class="uk-grid-small" uk-grid>
                        <div class="uk-width-1-2">
                            <input class="uk-input" type="date">
                        </div>
                        <div class="uk-width-1-2">
                            <input class="uk-input" type="date">
                        </div>
                    </div>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Format</label>
                    <select class="uk-select">
                        <option>PDF</option>
                        <option>Excel</option>
                        <option>CSV</option>
                    </select>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Generate</button>
        </div>
    </div>
</div>

<!-- View Counselor Profile Modal -->
<div id="view-counselor-profile-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Counselor Profile</h2>
        </div>
        <div class="uk-modal-body">
            <div class="uk-flex uk-flex-middle uk-margin-bottom">
                <div class="counselor-avatar" style="width: 60px; height: 60px; font-size: 20px;">SJ</div>
                <div class="uk-margin-left">
                    <div class="uk-text-bold">Sarah Johnson</div>
                    <div class="uk-text-muted uk-text-small">Senior Counselor</div>
                </div>
            </div>
            <dl class="uk-description-list uk-description-list-divider">
                <dt>Students Managed</dt>
                <dd>45</dd>
                <dt>Success Rate</dt>
                <dd>94%</dd>
                <dt>Avg Response Time</dt>
                <dd>2.3 hours</dd>
            </dl>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Close</button>
        </div>
    </div>
</div>

<!-- Detailed Stats Modal -->
<div id="detailed-stats-modal" uk-modal>
    <div class="uk-modal-dialog uk-width-large">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Detailed Statistics</h2>
        </div>
        <div class="uk-modal-body">
            <dl class="uk-description-list uk-description-list-divider">
                <dt>Total Applications Processed</dt>
                <dd>156</dd>
                <dt>Successful Admissions</dt>
                <dd>147</dd>
                <dt>Average Processing Time</dt>
                <dd>12 days</dd>
                <dt>Client Satisfaction</dt>
                <dd>4.8/5</dd>
            </dl>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Close</button>
        </div>
    </div>
</div>

<!-- View Students Modal -->
<div id="view-students-modal" uk-modal>
    <div class="uk-modal-dialog uk-width-large">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Assigned Students</h2>
        </div>
        <div class="uk-modal-body">
            <table class="uk-table uk-table-small uk-table-divider">
                <thead>
                    <tr><th>Name</th><th>Applications</th><th>Status</th></tr>
                </thead>
                <tbody>
                    <tr><td>John Doe</td><td>3</td><td><span class="uk-label uk-label-success">Active</span></td></tr>
                    <tr><td>Emma Wilson</td><td>2</td><td><span class="uk-label uk-label-success">Active</span></td></tr>
                    <tr><td>David Kim</td><td>1</td><td><span class="uk-label uk-label-warning">Pending</span></td></tr>
                </tbody>
            </table>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Close</button>
        </div>
    </div>
</div>

<!-- Send Message Modal -->
<div id="send-message-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Send Message</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Subject *</label>
                    <input class="uk-input" type="text" required>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Message *</label>
                    <textarea class="uk-textarea" rows="4" required></textarea>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Send</button>
        </div>
    </div>
</div>

<!-- Export Counselor Report Modal -->
<div id="export-counselor-report-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Export Report</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Format</label>
                    <select class="uk-select">
                        <option>PDF</option>
                        <option>Excel</option>
                        <option>CSV</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Include</label>
                    <div class="uk-margin-small">
                        <label><input class="uk-checkbox" type="checkbox" checked> Performance Metrics</label>
                    </div>
                    <div class="uk-margin-small">
                        <label><input class="uk-checkbox" type="checkbox" checked> Student List</label>
                    </div>
                    <div class="uk-margin-small">
                        <label><input class="uk-checkbox" type="checkbox"> Application Details</label>
                    </div>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Export</button>
        </div>
    </div>
</div>

<script>
(function() {
    // ApexCharts - Sparklines in stat cards
    <?php foreach ($report_stats as $index => $stat): ?>
    var sparkline<?= $index ?> = document.getElementById('sparkline-<?= $index ?>');
    if (sparkline<?= $index ?> && typeof ApexCharts !== 'undefined') {
        var sparkOptions<?= $index ?> = {
            series: [{
                data: <?= json_encode($stat['sparkline_data']) ?>
            }],
            chart: {
                type: 'area',
                height: 50,
                sparkline: {
                    enabled: true
                }
            },
            stroke: {
                curve: 'smooth',
                width: 2
            },
            fill: {
                opacity: 0.3,
                type: 'gradient',
                gradient: {
                    opacityFrom: 0.5,
                    opacityTo: 0.1
                }
            },
            colors: ['#ffffff'],
            tooltip: {
                enabled: true,
                theme: 'dark',
                x: {
                    show: false
                }
            }
        };
        new ApexCharts(sparkline<?= $index ?>, sparkOptions<?= $index ?>).render();
    }
    <?php endforeach; ?>

    // ApexCharts - Monthly Growth Trends
    var growthEl = document.getElementById('monthly-growth-chart');
    if (growthEl && typeof ApexCharts !== 'undefined') {
        var growthOptions = {
            series: [{
                name: 'Students',
                data: [234, 267, 298, 345, 389, 423]
            }, {
                name: 'Revenue ($K)',
                data: [185, 210, 245, 287, 324, 356]
            }],
            chart: { type: 'bar', height: 300, toolbar: { show: false } },
            colors: ['#667eea', '#32d296'],
            plotOptions: {
                bar: {
                    borderRadius: 8,
                    columnWidth: '60%'
                }
            },
            dataLabels: { enabled: false },
            xaxis: {
                categories: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun'],
                labels: { style: { colors: '#64748b' } }
            },
            yaxis: { labels: { style: { colors: '#64748b' } } },
            legend: { position: 'top' },
            tooltip: { theme: 'dark' }
        };
        new ApexCharts(growthEl, growthOptions).render();
    }

    // ECharts - Program Success Rates Radar Chart
    var radarEl = document.getElementById('program-success-chart');
    if (radarEl && typeof echarts !== 'undefined') {
        var radarChart = echarts.init(radarEl);
        var radarOption = {
            tooltip: {},
            radar: {
                indicator: [
                    { name: 'Computer Science', max: 100 },
                    { name: 'Engineering', max: 100 },
                    { name: 'Business', max: 100 },
                    { name: 'Medicine', max: 100 },
                    { name: 'Liberal Arts', max: 100 }
                ]
            },
            series: [{
                type: 'radar',
                data: [{
                    value: [92, 88, 85, 78, 94],
                    name: 'Success Rate',
                    areaStyle: { color: 'rgba(102, 126, 234, 0.3)' },
                    lineStyle: { color: '#667eea' },
                    itemStyle: { color: '#667eea' }
                }]
            }]
        };
        radarChart.setOption(radarOption);
        window.addEventListener('resize', function() { radarChart.resize(); });
    }
})();
</script>
