<?php
require_once __DIR__ . '/../includes/bootstrap.php';
?>

<h3 class="uk-margin-bottom">Security Settings</h3>

<div class="uk-grid-small" uk-grid>
    <div class="uk-width-2-3@m">
        <div class="uk-card uk-card-default uk-card-body">
            <h4 class="uk-card-title">Password</h4>
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Current Password</label>
                    <input class="uk-input" type="password" placeholder="Enter current password">
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">New Password</label>
                    <input class="uk-input" type="password" placeholder="Enter new password">
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Confirm New Password</label>
                    <input class="uk-input" type="password" placeholder="Confirm new password">
                </div>
                <button class="uk-button uk-button-primary">Update Password</button>
            </form>
        </div>

        <div class="uk-card uk-card-default uk-card-body uk-margin-top">
            <h4 class="uk-card-title">Two-Factor Authentication</h4>
            <p class="uk-text-muted">Add an extra layer of security to your account by requiring a verification code in addition to your password.</p>
            <div class="uk-margin">
                <div class="uk-flex uk-flex-between uk-flex-middle">
                    <div>
                        <div class="uk-text-bold">Authenticator App</div>
                        <div class="uk-text-small uk-text-muted">Use an app like Google Authenticator or Authy</div>
                    </div>
                    <button class="uk-button uk-button-primary uk-button-small">Enable</button>
                </div>
            </div>
            <div class="uk-margin">
                <div class="uk-flex uk-flex-between uk-flex-middle">
                    <div>
                        <div class="uk-text-bold">SMS Authentication</div>
                        <div class="uk-text-small uk-text-muted">Receive codes via text message</div>
                    </div>
                    <button class="uk-button uk-button-default uk-button-small">Enable</button>
                </div>
            </div>
        </div>

        <div class="uk-card uk-card-default uk-card-body uk-margin-top">
            <h4 class="uk-card-title">Active Sessions</h4>
            <p class="uk-text-muted">These devices are currently logged into your account.</p>

            <div class="uk-margin">
                <div class="uk-flex uk-flex-between uk-flex-middle uk-padding-small uk-background-muted" style="border-radius: 8px;">
                    <div class="uk-flex uk-flex-middle">
                        <span uk-icon="icon: laptop" class="uk-margin-right"></span>
                        <div>
                            <div class="uk-text-bold">MacBook Pro - Chrome</div>
                            <div class="uk-text-small uk-text-muted">New York, USA • Current session</div>
                        </div>
                    </div>
                    <span class="uk-label uk-label-success">Active</span>
                </div>
            </div>
            <div class="uk-margin">
                <div class="uk-flex uk-flex-between uk-flex-middle uk-padding-small uk-background-muted" style="border-radius: 8px;">
                    <div class="uk-flex uk-flex-middle">
                        <span uk-icon="icon: phone" class="uk-margin-right"></span>
                        <div>
                            <div class="uk-text-bold">iPhone 14 - Safari</div>
                            <div class="uk-text-small uk-text-muted">New York, USA • Last active 2 hours ago</div>
                        </div>
                    </div>
                    <button class="uk-button uk-button-danger uk-button-small">Revoke</button>
                </div>
            </div>

            <button class="uk-button uk-button-danger uk-margin-top">Sign Out All Other Sessions</button>
        </div>
    </div>

    <div class="uk-width-1-3@m">
        <div class="uk-card uk-card-default uk-card-body">
            <h5 class="uk-card-title">Security Tips</h5>
            <ul class="uk-list uk-list-bullet">
                <li>Use a strong, unique password</li>
                <li>Enable two-factor authentication</li>
                <li>Review active sessions regularly</li>
                <li>Never share your credentials</li>
                <li>Log out from shared devices</li>
            </ul>
        </div>

        <div class="uk-card uk-card-default uk-card-body uk-margin-top">
            <h5 class="uk-card-title">Recent Activity</h5>
            <div class="uk-text-small">
                <div class="uk-margin-small-bottom">
                    <div class="uk-text-bold">Password changed</div>
                    <div class="uk-text-muted">30 days ago</div>
                </div>
                <div class="uk-margin-small-bottom">
                    <div class="uk-text-bold">New login from Chrome</div>
                    <div class="uk-text-muted">Today at 9:45 AM</div>
                </div>
                <div class="uk-margin-small-bottom">
                    <div class="uk-text-bold">2FA disabled</div>
                    <div class="uk-text-muted">45 days ago</div>
                </div>
            </div>
        </div>
    </div>
</div>
