<?php
/**
 * Settings Page Content (Partial)
 */

require_once __DIR__ . '/../includes/bootstrap.php';

$system_stats = [
    ['icon' => 'fa-database', 'value' => '2.4 GB', 'label' => 'Database Size', 'color' => '#667eea', 'color_dark' => '#5568d3'],
    ['icon' => 'fa-check-circle', 'value' => '99.9%', 'label' => 'System Uptime', 'color' => '#32d296', 'color_dark' => '#28b67f'],
    ['icon' => 'fa-users', 'value' => '2,847', 'label' => 'Active Users', 'color' => '#faa05a', 'color_dark' => '#f48939'],
    ['icon' => 'fa-upload', 'value' => '10 MB', 'label' => 'Max Upload Size', 'color' => '#1e87f0', 'color_dark' => '#1b78d6']
];
?>

<style>
.settings-stat-card {
    border-radius: 12px;
    padding: 24px;
    position: relative;
    overflow: hidden;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    transition: all 0.3s ease;
}

.settings-stat-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 16px rgba(0, 0, 0, 0.12);
}

.stat-card-bg {
    position: absolute;
    top: -30px;
    right: -30px;
    width: 120px;
    height: 120px;
    border-radius: 50%;
    opacity: 0.2;
}

.stat-icon {
    width: 48px;
    height: 48px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 20px;
    margin-bottom: 16px;
}

.stat-value {
    font-size: 28px;
    font-weight: 700;
    color: white;
    margin-bottom: 4px;
}

.stat-label {
    font-size: 14px;
    color: rgba(255, 255, 255, 0.9);
    font-weight: 500;
}

.modern-settings-card {
    background: white;
    border-radius: 12px;
    padding: 24px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
}

.card-title {
    font-size: 18px;
    font-weight: 600;
    color: #1a1a1a;
    margin-bottom: 20px;
}

.role-card {
    background: #f8fafc;
    border-radius: 12px;
    padding: 20px;
    margin-bottom: 12px;
    transition: all 0.2s ease;
    border: 1px solid #e2e8f0;
}

.role-card:hover {
    border-color: #667eea;
    box-shadow: 0 4px 12px rgba(102, 126, 234, 0.1);
    transform: translateY(-2px);
}

.role-name {
    font-weight: 600;
    color: #1a1a1a;
    font-size: 16px;
    margin-bottom: 12px;
}

.permission-badge {
    display: inline-block;
    padding: 6px 12px;
    border-radius: 6px;
    background: white;
    color: #64748b;
    font-size: 12px;
    font-weight: 500;
    margin-right: 8px;
    margin-bottom: 8px;
    border: 1px solid #e2e8f0;
}

.modern-btn {
    padding: 10px 20px;
    border-radius: 8px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    border: none;
    font-size: 14px;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.2s ease;
    display: inline-flex;
    align-items: center;
    gap: 8px;
    width: 100%;
    justify-content: center;
}

.modern-btn:hover {
    transform: translateY(-1px);
    box-shadow: 0 4px 12px rgba(102, 126, 234, 0.3);
}

.modern-btn-secondary {
    background: white;
    color: #667eea;
    border: 1px solid #667eea;
}

.modern-btn-secondary:hover {
    background: #f8fafc;
    box-shadow: 0 2px 8px rgba(102, 126, 234, 0.2);
}

.modern-btn-danger {
    background: linear-gradient(135deg, #f0506e 0%, #e03e5c 100%);
}

.modern-btn-danger:hover {
    box-shadow: 0 4px 12px rgba(240, 80, 110, 0.3);
}

.form-label {
    font-weight: 500;
    color: #1a1a1a;
    font-size: 14px;
    margin-bottom: 8px;
    display: block;
}

.notification-toggle {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 16px;
    background: #f8fafc;
    border-radius: 8px;
    margin-bottom: 12px;
    transition: all 0.2s ease;
}

.notification-toggle:hover {
    background: #f1f5f9;
}

.toggle-label {
    font-weight: 500;
    color: #1a1a1a;
    font-size: 14px;
}

.toggle-description {
    font-size: 12px;
    color: #64748b;
    margin-top: 4px;
}

.page-title {
    font-size: 24px;
    font-weight: 700;
    color: #1a1a1a;
    margin: 0 0 24px 0;
}

.alert-banner {
    background: linear-gradient(135deg, #faa05a 0%, #f48939 100%);
    color: white;
    padding: 16px 20px;
    border-radius: 12px;
    margin-top: 20px;
    font-size: 14px;
    box-shadow: 0 2px 8px rgba(250, 160, 90, 0.2);
}

.alert-banner strong {
    font-weight: 600;
}
</style>

<h3 class="page-title">System Settings</h3>

<!-- System Stats -->
<div class="uk-grid-small uk-child-width-1-2@s uk-child-width-1-4@m uk-margin-bottom" uk-grid>
    <?php foreach ($system_stats as $stat): ?>
    <div>
        <div class="settings-stat-card" style="background: linear-gradient(135deg, <?= $stat['color'] ?> 0%, <?= $stat['color_dark'] ?> 100%);">
            <div class="stat-card-bg" style="background: linear-gradient(135deg, <?= $stat['color'] ?> 0%, <?= $stat['color_dark'] ?> 100%);"></div>
            <div class="stat-icon" style="background: rgba(255, 255, 255, 0.2);">
                <i class="fa-slab fa-solid <?= $stat['icon'] ?>"></i>
            </div>
            <div class="stat-value"><?= e($stat['value']) ?></div>
            <div class="stat-label"><?= e($stat['label']) ?></div>
        </div>
    </div>
    <?php endforeach; ?>
</div>

<!-- Settings Forms -->
<div class="uk-grid-small" uk-grid>
    <div class="uk-width-1-2@m">
        <div class="modern-settings-card">
            <h4 class="card-title"><i class="fa-slab fa-solid fa-cog"></i> System Configuration</h4>
            <form hx-post="<?= BASE_URL ?>/api/settings.php" hx-target="#system-config-response" hx-swap="innerHTML">
                <div class="uk-margin">
                    <label class="form-label">Application Deadline Reminder</label>
                    <select class="uk-select" name="deadline_reminder">
                        <option value="7" selected>7 days before</option>
                        <option value="14">14 days before</option>
                        <option value="30">30 days before</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label class="form-label">Maximum File Upload Size</label>
                    <select class="uk-select" name="max_upload">
                        <option value="5">5 MB</option>
                        <option value="10" selected>10 MB</option>
                        <option value="25">25 MB</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label class="form-label">Default Application Status</label>
                    <select class="uk-select" name="default_status">
                        <option value="pending" selected>Pending Review</option>
                        <option value="submitted">Submitted</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label class="form-label">Payment Processing Fee</label>
                    <div class="uk-inline uk-width-1-1">
                        <input class="uk-input" type="number" name="processing_fee" value="2.9" step="0.1">
                        <span class="uk-form-icon uk-form-icon-flip">%</span>
                    </div>
                </div>
                <div id="system-config-response"></div>
                <button class="modern-btn" type="submit">
                    <i class="fa-slab fa-solid fa-save"></i> Save System Settings
                </button>
            </form>
        </div>
    </div>

    <div class="uk-width-1-2@m">
        <div class="modern-settings-card">
            <h4 class="card-title"><i class="fa-slab fa-solid fa-envelope"></i> Email & Notifications</h4>
            <form hx-post="<?= BASE_URL ?>/api/settings.php?type=email" hx-target="#email-config-response" hx-swap="innerHTML">
                <div class="notification-toggle">
                    <div>
                        <div class="toggle-label">Student Registration Notifications</div>
                        <div class="toggle-description">Notify admins when new students register</div>
                    </div>
                    <input class="uk-checkbox" type="checkbox" name="notify_registration" checked>
                </div>

                <div class="notification-toggle">
                    <div>
                        <div class="toggle-label">Application Status Updates</div>
                        <div class="toggle-description">Auto-email students on status changes</div>
                    </div>
                    <input class="uk-checkbox" type="checkbox" name="notify_status" checked>
                </div>

                <div class="notification-toggle">
                    <div>
                        <div class="toggle-label">Payment Confirmations</div>
                        <div class="toggle-description">Send receipt emails automatically</div>
                    </div>
                    <input class="uk-checkbox" type="checkbox" name="notify_payment" checked>
                </div>

                <div class="notification-toggle">
                    <div>
                        <div class="toggle-label">Deadline Reminders</div>
                        <div class="toggle-description">Remind students of upcoming deadlines</div>
                    </div>
                    <input class="uk-checkbox" type="checkbox" name="notify_deadline" checked>
                </div>

                <div class="uk-margin">
                    <label class="form-label">Email Template Language</label>
                    <select class="uk-select" name="email_language">
                        <option value="en" selected>English</option>
                        <option value="es">Spanish</option>
                        <option value="fr">French</option>
                        <option value="zh">Chinese</option>
                    </select>
                </div>
                <div id="email-config-response"></div>
                <button class="modern-btn" type="submit">
                    <i class="fa-slab fa-solid fa-paper-plane"></i> Update Email Settings
                </button>
            </form>
        </div>
    </div>
</div>

<!-- User Permissions & Roles -->
<div class="modern-settings-card uk-margin-top">
    <h4 class="card-title"><i class="fa-slab fa-solid fa-shield-alt"></i> User Permissions & Roles</h4>
    <?php
    $roles_config = [
        ['name' => 'Super Admin', 'permissions' => ['All system access', 'User management', 'System settings', 'Financial reports']],
        ['name' => 'Admin', 'permissions' => ['User management', 'Application oversight', 'Payment management', 'Reports']],
        ['name' => 'Senior Counselor', 'permissions' => ['Student management', 'Application review', 'Document verification']],
        ['name' => 'Counselor', 'permissions' => ['Assigned students', 'Application guidance', 'Document review']]
    ];
    foreach ($roles_config as $role): ?>
        <div class="role-card">
            <div class="uk-flex uk-flex-between uk-flex-middle">
                <div style="flex: 1;">
                    <div class="role-name"><?= e($role['name']) ?></div>
                    <div>
                        <?php foreach ($role['permissions'] as $perm): ?>
                            <span class="permission-badge"><?= e($perm) ?></span>
                        <?php endforeach; ?>
                    </div>
                </div>
                <button class="uk-button uk-button-default uk-button-small" style="border-radius: 8px;">
                    <i class="fa-slab fa-solid fa-pencil-alt fa-sm"></i> Edit
                </button>
            </div>
        </div>
    <?php endforeach; ?>
    <button class="modern-btn modern-btn-secondary uk-margin-top">
        <i class="fa-slab fa-solid fa-plus"></i> Create New Role
    </button>
</div>

<!-- System Maintenance -->
<div class="modern-settings-card uk-margin-top">
    <h4 class="card-title"><i class="fa-slab fa-solid fa-tools"></i> System Maintenance</h4>

    <div class="uk-grid-small uk-margin-bottom" uk-grid>
        <div class="uk-width-1-1">
            <button class="modern-btn modern-btn-secondary uk-margin-small-bottom" hx-post="<?= BASE_URL ?>/api/maintenance.php?action=backup" hx-confirm="Are you sure you want to backup the database?">
                <i class="fa-slab fa-solid fa-download"></i> Backup Database
            </button>
        </div>
        <div class="uk-width-1-1">
            <button class="modern-btn modern-btn-secondary uk-margin-small-bottom" hx-post="<?= BASE_URL ?>/api/maintenance.php?action=cache" hx-confirm="Clear system cache?">
                <i class="fa-slab fa-solid fa-sync-alt"></i> Clear System Cache
            </button>
        </div>
        <div class="uk-width-1-1">
            <button class="modern-btn modern-btn-secondary">
                <i class="fa-slab fa-solid fa-file-alt"></i> Generate System Report
            </button>
        </div>
    </div>

    <div class="alert-banner">
        <strong><i class="fa-slab fa-solid fa-exclamation-triangle"></i> Scheduled Maintenance:</strong> System will be offline for maintenance on Feb 15, 2024 from 2:00 AM - 4:00 AM EST.
    </div>
</div>

<!-- Security Settings -->
<div class="modern-settings-card uk-margin-top">
    <h4 class="card-title"><i class="fa-slab fa-solid fa-lock"></i> Security Settings</h4>

    <div class="notification-toggle">
        <div>
            <div class="toggle-label">Two-Factor Authentication</div>
            <div class="toggle-description">Require 2FA for all admin users</div>
        </div>
        <input class="uk-checkbox" type="checkbox" name="require_2fa">
    </div>

    <div class="notification-toggle">
        <div>
            <div class="toggle-label">Session Timeout</div>
            <div class="toggle-description">Auto-logout after 30 minutes of inactivity</div>
        </div>
        <input class="uk-checkbox" type="checkbox" name="session_timeout" checked>
    </div>

    <div class="notification-toggle">
        <div>
            <div class="toggle-label">IP Whitelist</div>
            <div class="toggle-description">Restrict admin access to specific IP addresses</div>
        </div>
        <input class="uk-checkbox" type="checkbox" name="ip_whitelist">
    </div>

    <div class="uk-margin-top">
        <label class="form-label">Password Requirements</label>
        <select class="uk-select">
            <option>Standard (8+ characters)</option>
            <option selected>Strong (12+ characters, mixed case, numbers, symbols)</option>
            <option>Very Strong (16+ characters, mixed case, numbers, symbols)</option>
        </select>
    </div>

    <button class="modern-btn uk-margin-top">
        <i class="fa-slab fa-solid fa-save"></i> Save Security Settings
    </button>
</div>
