<?php
require_once __DIR__ . '/../includes/bootstrap.php';

$user_id = $_GET['id'] ?? 1;

// Sample user data (would come from database in production)
$user = [
    'id' => $user_id,
    'name' => 'John Doe',
    'email' => 'john.doe@email.com',
    'role' => ROLE_STUDENT,
    'status' => 'active',
    'phone' => '+1 (555) 123-4567',
    'joined' => '2024-01-15',
    'last_active' => '2 hours ago',
    'applications' => 3,
    'total_spent' => '$45,000',
    'initials' => 'JD',
    'address' => '123 Main St, San Francisco, CA 94102',
    'gpa' => '3.85',
    'degree' => 'Bachelor of Science in Computer Science',
    'university' => 'University of California, Berkeley'
];

$user_stats = [
    ['icon' => 'fa-file-alt', 'value' => '3', 'label' => 'Applications', 'color' => '#667eea', 'color_dark' => '#5568d3'],
    ['icon' => 'fa-check-circle', 'value' => '1', 'label' => 'Accepted', 'color' => '#32d296', 'color_dark' => '#28b67f'],
    ['icon' => 'fa-dollar-sign', 'value' => '$45K', 'label' => 'Total Spent', 'color' => '#faa05a', 'color_dark' => '#f48939'],
    ['icon' => 'fa-clock', 'value' => '2h', 'label' => 'Last Active', 'color' => '#1e87f0', 'color_dark' => '#1b78d6']
];

$applications = [
    ['id' => 'APP-001', 'university' => 'Stanford University', 'program' => 'Computer Science (MS)', 'status' => 'under_review', 'date' => '2024-01-15', 'counselor' => 'Sarah Johnson'],
    ['id' => 'APP-002', 'university' => 'MIT', 'program' => 'AI Research (MS)', 'status' => 'submitted', 'date' => '2024-01-20', 'counselor' => 'Michael Chen'],
    ['id' => 'APP-003', 'university' => 'UC Berkeley', 'program' => 'Data Science (MS)', 'status' => 'accepted', 'date' => '2024-01-10', 'counselor' => 'Sarah Johnson']
];

$payments = [
    ['id' => 'PAY-001', 'description' => 'Application Fee - Stanford', 'amount' => '$150', 'date' => '2024-01-15', 'status' => 'completed', 'method' => 'Credit Card'],
    ['id' => 'PAY-002', 'description' => 'Tuition Deposit - UC Berkeley', 'amount' => '$5,000', 'date' => '2024-01-20', 'status' => 'completed', 'method' => 'Wire Transfer'],
    ['id' => 'PAY-003', 'description' => 'Application Fee - MIT', 'amount' => '$150', 'date' => '2024-01-22', 'status' => 'completed', 'method' => 'Credit Card']
];

$activity = [
    ['action' => 'Updated profile information', 'time' => '2 hours ago', 'icon' => 'fa-user-edit', 'type' => 'info'],
    ['action' => 'Submitted application to Stanford', 'time' => '3 days ago', 'icon' => 'fa-paper-plane', 'type' => 'success'],
    ['action' => 'Made payment of $150', 'time' => '5 days ago', 'icon' => 'fa-credit-card', 'type' => 'success'],
    ['action' => 'Uploaded transcript document', 'time' => '1 week ago', 'icon' => 'fa-upload', 'type' => 'info'],
    ['action' => 'Accepted offer from UC Berkeley', 'time' => '2 weeks ago', 'icon' => 'fa-check-circle', 'type' => 'success']
];

$documents = [
    ['name' => 'Transcript', 'type' => 'PDF', 'size' => '2.4 MB', 'uploaded' => '2024-01-10', 'status' => 'verified'],
    ['name' => 'Statement of Purpose', 'type' => 'PDF', 'size' => '1.2 MB', 'uploaded' => '2024-01-12', 'status' => 'verified'],
    ['name' => 'Resume', 'type' => 'PDF', 'size' => '856 KB', 'uploaded' => '2024-01-14', 'status' => 'pending']
];

$status_colors = [
    'completed' => 'success',
    'pending' => 'warning',
    'submitted' => 'secondary',
    'under_review' => 'warning',
    'accepted' => 'success',
    'verified' => 'success'
];
?>

<style>
.back-link {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    color: #64748b;
    text-decoration: none;
    font-size: 14px;
    font-weight: 500;
    margin-bottom: 24px;
    transition: all 0.2s ease;
}

.back-link:hover {
    color: #667eea;
    text-decoration: none;
}

.user-header-card {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border-radius: 12px;
    padding: 32px;
    color: white;
    margin-bottom: 24px;
    box-shadow: 0 4px 16px rgba(102, 126, 234, 0.2);
}

.user-avatar-large {
    width: 80px;
    height: 80px;
    border-radius: 50%;
    background: rgba(255, 255, 255, 0.2);
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 32px;
    font-weight: 600;
    color: white;
    border: 3px solid rgba(255, 255, 255, 0.3);
}

.user-name {
    font-size: 28px;
    font-weight: 700;
    margin: 0;
    color: white;
}

.user-email {
    font-size: 14px;
    color: rgba(255, 255, 255, 0.9);
    margin-top: 4px;
}

.user-badge {
    display: inline-block;
    padding: 6px 12px;
    border-radius: 6px;
    font-size: 12px;
    font-weight: 600;
    margin-right: 8px;
    margin-top: 12px;
    background: rgba(255, 255, 255, 0.2);
}

.modern-btn {
    padding: 10px 20px;
    border-radius: 8px;
    font-size: 14px;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.2s ease;
    display: inline-flex;
    align-items: center;
    gap: 8px;
    border: none;
}

.modern-btn-white {
    background: white;
    color: #667eea;
}

.modern-btn-white:hover {
    transform: translateY(-1px);
    box-shadow: 0 4px 12px rgba(255, 255, 255, 0.3);
}

.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 16px;
    margin-bottom: 24px;
}

.user-stat-card {
    border-radius: 12px;
    padding: 20px;
    background: white;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    transition: all 0.3s ease;
}

.user-stat-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 16px rgba(0, 0, 0, 0.12);
}

.stat-icon-small {
    width: 40px;
    height: 40px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 18px;
    margin-bottom: 12px;
}

.stat-value-small {
    font-size: 24px;
    font-weight: 700;
    color: #1a1a1a;
    margin-bottom: 4px;
}

.stat-label-small {
    font-size: 13px;
    color: #64748b;
    font-weight: 500;
}

.content-grid {
    display: grid;
    grid-template-columns: 1fr;
    gap: 20px;
    margin-top: 24px;
}

@media (min-width: 1200px) {
    .content-grid {
        grid-template-columns: 2fr 1fr;
    }
}

.modern-card {
    background: white;
    border-radius: 12px;
    padding: 24px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    margin-bottom: 20px;
}

.card-title {
    font-size: 18px;
    font-weight: 600;
    color: #1a1a1a;
    margin-bottom: 20px;
    display: flex;
    align-items: center;
    gap: 8px;
}

.app-item {
    padding: 16px;
    border-radius: 8px;
    background: #f8fafc;
    margin-bottom: 12px;
    transition: all 0.2s ease;
    border: 1px solid #e2e8f0;
    cursor: pointer;
}

.app-item:hover {
    border-color: #667eea;
    background: white;
    box-shadow: 0 2px 8px rgba(102, 126, 234, 0.1);
}

.app-item:last-child {
    margin-bottom: 0;
}

.payment-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 16px;
    border-radius: 8px;
    background: #f8fafc;
    margin-bottom: 12px;
    border: 1px solid #e2e8f0;
}

.payment-item:last-child {
    margin-bottom: 0;
}

.doc-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 16px;
    border-radius: 8px;
    background: #f8fafc;
    margin-bottom: 12px;
    border: 1px solid #e2e8f0;
    transition: all 0.2s ease;
}

.doc-item:hover {
    background: white;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
}

.doc-item:last-child {
    margin-bottom: 0;
}

.doc-icon {
    width: 40px;
    height: 40px;
    border-radius: 8px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 16px;
    flex-shrink: 0;
}

.activity-item {
    display: flex;
    gap: 16px;
    padding: 16px;
    border-radius: 8px;
    background: #f8fafc;
    margin-bottom: 12px;
    transition: all 0.2s ease;
}

.activity-item:hover {
    background: white;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
}

.activity-item:last-child {
    margin-bottom: 0;
}

.activity-icon {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 16px;
    flex-shrink: 0;
}

.status-badge {
    padding: 6px 12px;
    border-radius: 6px;
    font-size: 12px;
    font-weight: 600;
    text-transform: uppercase;
}

.status-success {
    background: #d1fae5;
    color: #065f46;
}

.status-warning {
    background: #fef3c7;
    color: #92400e;
}

.status-secondary {
    background: #e2e8f0;
    color: #475569;
}

.info-list {
    list-style: none;
    padding: 0;
    margin: 0;
}

.info-list dt {
    font-size: 13px;
    color: #64748b;
    font-weight: 500;
    margin-bottom: 4px;
}

.info-list dd {
    font-size: 15px;
    color: #1a1a1a;
    font-weight: 500;
    margin-bottom: 16px;
    margin-left: 0;
}

.info-list dd:last-child {
    margin-bottom: 0;
}

@media (max-width: 959px) {
    .user-header-card {
        padding: 24px;
    }

    .user-name {
        font-size: 24px;
    }

    .modern-btn {
        font-size: 13px;
        padding: 8px 16px;
    }

    .stats-grid {
        grid-template-columns: repeat(2, 1fr);
    }
}

@media (max-width: 640px) {
    .user-header-card .uk-flex {
        flex-direction: column !important;
        align-items: flex-start !important;
    }

    .user-header-card > div > div:last-child {
        width: 100%;
        margin-top: 16px;
    }

    .modern-btn {
        width: 100%;
        justify-content: center;
    }
}
</style>

<a href="<?= BASE_URL ?>/index.php"
   hx-get="<?= BASE_URL ?>/pages/users.php"
   hx-target="#main-content"
   hx-swap="innerHTML"
   hx-push-url="<?= BASE_URL ?>/users.php"
   class="back-link">
    <i class="fa-slab fa-solid fa-arrow-left"></i> Back to Users
</a>

<!-- User Header -->
<div class="user-header-card">
    <div class="uk-flex uk-flex-between uk-flex-middle">
        <div class="uk-flex uk-flex-middle" style="gap: 24px;">
            <div class="user-avatar-large"><?= $user['initials'] ?></div>
            <div>
                <h2 class="user-name"><?= e($user['name']) ?></h2>
                <div class="user-email"><?= e($user['email']) ?></div>
                <div>
					<span class="user-badge">Role</span>
					<span class="user-badge"><?= ucfirst(e($user['status'])) ?></span>
                </div>
            </div>
        </div>
        <div style="display: flex; gap: 12px;">
            <button class="modern-btn modern-btn-white">
                <i class="fa-slab fa-solid fa-envelope"></i> Send Email
            </button>
            <button class="modern-btn modern-btn-white">
                <i class="fa-slab fa-solid fa-user-edit"></i> Edit User
            </button>
        </div>
    </div>
</div>

<!-- Stats Grid -->
<div class="stats-grid">
    <?php foreach ($user_stats as $stat): ?>
    <div class="user-stat-card">
        <div class="stat-icon-small" style="background: linear-gradient(135deg, <?= $stat['color'] ?> 0%, <?= $stat['color_dark'] ?> 100%);">
            <i class="fa-slab fa-solid <?= $stat['icon'] ?>"></i>
        </div>
        <div class="stat-value-small"><?= e($stat['value']) ?></div>
        <div class="stat-label-small"><?= e($stat['label']) ?></div>
    </div>
    <?php endforeach; ?>
</div>

<!-- Main Content Grid -->
<div class="content-grid">
    <!-- Left Column -->
    <div>
        <!-- Applications -->
        <div class="modern-card">
            <h4 class="card-title">
                <i class="fa-slab fa-solid fa-file-alt"></i> Applications
            </h4>
            <?php foreach ($applications as $app): ?>
            <div class="app-item"
                 hx-get="<?= BASE_URL ?>/pages/application-detail.php?id=<?= $app['id'] ?>"
                 hx-target="#main-content"
                 hx-swap="innerHTML"
                 hx-push-url="<?= BASE_URL ?>/application-detail.php?id=<?= $app['id'] ?>">
                <div style="display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 12px;">
                    <div style="flex: 1; min-width: 200px;">
                        <div style="font-size: 11px; font-weight: 600; color: #667eea; background: #f0f4ff; padding: 4px 8px; border-radius: 4px; display: inline-block; margin-bottom: 6px;">
                            <?= e($app['id']) ?>
                        </div>
                        <div style="font-weight: 600; color: #1a1a1a; font-size: 16px; margin-bottom: 4px;">
                            <?= e($app['university']) ?>
                        </div>
                        <div style="font-size: 13px; color: #64748b; margin-bottom: 4px;">
                            <i class="fa-slab fa-solid fa-graduation-cap fa-fw"></i> <?= e($app['program']) ?>
                        </div>
                        <div style="font-size: 12px; color: #94a3b8;">
                            <i class="fa-slab fa-solid fa-user fa-fw"></i> Counselor: <?= e($app['counselor']) ?>
                        </div>
                    </div>
                    <div style="text-align: right;">
                        <span class="status-badge status-<?= $status_colors[$app['status']] ?>">
                            <?= str_replace('_', ' ', $app['status']) ?>
                        </span>
                        <div style="font-size: 12px; color: #94a3b8; margin-top: 6px;">
                            <i class="fa-slab fa-solid fa-calendar fa-sm"></i> <?= date('M d, Y', strtotime($app['date'])) ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>

        <!-- Recent Payments -->
        <div class="modern-card">
            <h4 class="card-title">
                <i class="fa-slab fa-solid fa-credit-card"></i> Payment History
            </h4>
            <?php foreach ($payments as $payment): ?>
            <div class="payment-item">
                <div>
                    <div style="font-weight: 600; color: #1a1a1a; font-size: 15px; margin-bottom: 4px;">
                        <?= e($payment['description']) ?>
                    </div>
                    <div style="font-size: 12px; color: #64748b; margin-bottom: 2px;">
                        <i class="fa-slab fa-solid fa-hashtag fa-xs"></i><?= e($payment['id']) ?> &middot;
                        <i class="fa-slab fa-solid fa-calendar fa-xs"></i> <?= date('M d, Y', strtotime($payment['date'])) ?>
                    </div>
                    <div style="font-size: 12px; color: #94a3b8;">
                        <i class="fa-slab fa-solid fa-money-check fa-xs"></i> <?= e($payment['method']) ?>
                    </div>
                </div>
                <div style="text-align: right;">
                    <div style="font-weight: 700; color: #32d296; font-size: 18px;"><?= e($payment['amount']) ?></div>
                    <span class="status-badge status-success" style="font-size: 10px;">Completed</span>
                </div>
            </div>
            <?php endforeach; ?>
        </div>

        <!-- Documents -->
        <div class="modern-card">
            <h4 class="card-title">
                <i class="fa-slab fa-solid fa-folder-open"></i> Documents
            </h4>
            <?php foreach ($documents as $doc): ?>
            <div class="doc-item">
                <div style="display: flex; align-items: center; gap: 12px; flex: 1;">
                    <div class="doc-icon">
                        <i class="fa-slab fa-solid fa-file-pdf"></i>
                    </div>
                    <div>
                        <div style="font-weight: 600; color: #1a1a1a; font-size: 14px; margin-bottom: 2px;">
                            <?= e($doc['name']) ?>
                        </div>
                        <div style="font-size: 12px; color: #64748b;">
                            <?= e($doc['type']) ?> &middot; <?= e($doc['size']) ?> &middot; Uploaded <?= date('M d, Y', strtotime($doc['uploaded'])) ?>
                        </div>
                    </div>
                </div>
                <span class="status-badge status-<?= $status_colors[$doc['status']] ?>">
                    <?= e($doc['status']) ?>
                </span>
            </div>
            <?php endforeach; ?>
        </div>
    </div>

    <!-- Right Column -->
    <div>
        <!-- User Info -->
        <div class="modern-card">
            <h4 class="card-title">
                <i class="fa-slab fa-solid fa-info-circle"></i> User Information
            </h4>
            <dl class="info-list">
                <dt>Phone Number</dt>
                <dd><i class="fa-slab fa-solid fa-phone fa-sm"></i> <?= e($user['phone']) ?></dd>

                <dt>Email Address</dt>
                <dd><i class="fa-slab fa-solid fa-envelope fa-sm"></i> <?= e($user['email']) ?></dd>

                <dt>Address</dt>
                <dd><i class="fa-slab fa-solid fa-map-marker-alt fa-sm"></i> <?= e($user['address']) ?></dd>

                <dt>Member Since</dt>
                <dd><i class="fa-slab fa-solid fa-calendar-plus fa-sm"></i> <?= date('M d, Y', strtotime($user['joined'])) ?></dd>

                <dt>Last Active</dt>
                <dd><i class="fa-slab fa-solid fa-clock fa-sm"></i> <?= e($user['last_active']) ?></dd>

                <dt>User ID</dt>
                <dd><i class="fa-slab fa-solid fa-hashtag fa-sm"></i><?= e($user['id']) ?></dd>
            </dl>
        </div>

        <!-- Academic Background -->
        <div class="modern-card">
            <h4 class="card-title">
                <i class="fa-slab fa-solid fa-graduation-cap"></i> Academic Background
            </h4>
            <dl class="info-list">
                <dt>Current Degree</dt>
                <dd><?= e($user['degree']) ?></dd>

                <dt>University</dt>
                <dd><?= e($user['university']) ?></dd>

                <dt>GPA</dt>
                <dd><?= e($user['gpa']) ?> / 4.0</dd>
            </dl>
        </div>

        <!-- Recent Activity -->
        <div class="modern-card">
            <h4 class="card-title">
                <i class="fa-slab fa-solid fa-history"></i> Recent Activity
            </h4>
            <?php foreach ($activity as $item): ?>
            <div class="activity-item">
                <div class="activity-icon">
                    <i class="fa-slab fa-solid <?= $item['icon'] ?>"></i>
                </div>
                <div style="flex: 1;">
                    <div style="font-size: 14px; color: #1a1a1a; font-weight: 500;"><?= e($item['action']) ?></div>
                    <div style="font-size: 12px; color: #94a3b8; margin-top: 2px;"><?= e($item['time']) ?></div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>

<script>
// Re-initialize UIKit components after HTMX load
document.addEventListener('DOMContentLoaded', function() {
    if (typeof UIkit !== 'undefined') {
        UIkit.update();
    }
});

// Also trigger on HTMX after swap
if (typeof UIkit !== 'undefined') {
    UIkit.update();
}
</script>
