<?php
/**
 * Users Page Content (Partial)
 */

require_once __DIR__ . '/../includes/bootstrap.php';

$user_stats = [
    ['icon' => 'fa-user', 'value' => '2,456', 'label' => 'Students', 'color' => '#667eea', 'color_dark' => '#5568d3'],
    ['icon' => 'fa-users', 'value' => '34', 'label' => 'Counselors', 'color' => '#faa05a', 'color_dark' => '#f48939'],
    ['icon' => 'fa-cog', 'value' => '12', 'label' => 'Administrators', 'color' => '#1e87f0', 'color_dark' => '#1b78d6']
];

$users = [
    ['id' => 1, 'name' => 'John Doe', 'email' => 'john.doe@email.com', 'role' => ROLE_STUDENT, 'status' => 'active', 'joined' => '2024-01-15', 'last_active' => '2024-01-30', 'meta' => ['Applications' => 3, 'Spent' => '$45,000']],
    ['id' => 2, 'name' => 'Sarah Johnson', 'email' => 'sarah.johnson@globaledpathways.com', 'role' => ROLE_COUNSELOR, 'status' => 'active', 'joined' => '2023-06-01', 'last_active' => '2024-01-30', 'meta' => ['Students' => 45]],
    ['id' => 3, 'name' => 'Michael Chen', 'email' => 'michael.chen@globaledpathways.com', 'role' => ROLE_ADMIN, 'status' => 'active', 'joined' => '2023-01-01', 'last_active' => '2024-01-30', 'meta' => []],
    ['id' => 4, 'name' => 'Emma Wilson', 'email' => 'emma.wilson@email.com', 'role' => ROLE_STUDENT, 'status' => 'active', 'joined' => '2024-01-10', 'last_active' => '2024-01-29', 'meta' => ['Applications' => 2, 'Spent' => '$32,000']],
    ['id' => 5, 'name' => 'David Kim', 'email' => 'david.kim@email.com', 'role' => ROLE_STUDENT, 'status' => 'pending', 'joined' => '2024-01-25', 'last_active' => '2024-01-28', 'meta' => ['Applications' => 1, 'Spent' => '$12,000']],
    ['id' => 6, 'name' => 'Lisa Park', 'email' => 'lisa.park@globaledpathways.com', 'role' => ROLE_COUNSELOR, 'status' => 'active', 'joined' => '2023-09-15', 'last_active' => '2024-01-30', 'meta' => ['Students' => 38]],
    ['id' => 7, 'name' => 'Robert Taylor', 'email' => 'robert.taylor@email.com', 'role' => ROLE_STUDENT, 'status' => 'inactive', 'joined' => '2023-08-01', 'last_active' => '2023-12-15', 'meta' => ['Applications' => 0, 'Spent' => '$0']],
    ['id' => 8, 'name' => 'Jennifer Adams', 'email' => 'jennifer.adams@globaledpathways.com', 'role' => ROLE_ADMIN, 'status' => 'active', 'joined' => '2023-04-01', 'last_active' => '2024-01-30', 'meta' => []]
];

$status_config = [
    'active' => ['label' => 'Active', 'color' => '#32d296'],
    'pending' => ['label' => 'Pending', 'color' => '#faa05a'],
    'inactive' => ['label' => 'Inactive', 'color' => '#94a3b8']
];
?>

<style>
.stat-card {
    background: linear-gradient(135deg, var(--stat-color) 0%, var(--stat-color-dark) 100%);
    border-radius: 12px;
    padding: 24px;
    color: white;
    position: relative;
    overflow: hidden;
    transition: all 0.3s ease;
    box-shadow: 0 4px 16px rgba(0, 0, 0, 0.1);
}

.stat-card:hover {
    transform: translateY(-4px);
    box-shadow: 0 8px 24px rgba(0, 0, 0, 0.15);
}

.stat-card::before {
    content: '';
    position: absolute;
    top: -50%;
    right: -20%;
    width: 200px;
    height: 200px;
    border-radius: 50%;
    background: rgba(255, 255, 255, 0.1);
}

.stat-content {
    position: relative;
    z-index: 1;
}

.stat-icon {
    font-size: 32px;
    opacity: 0.9;
    margin-bottom: 12px;
}

.stat-value {
    font-size: 32px;
    font-weight: 700;
    margin-bottom: 4px;
}

.stat-label {
    font-size: 14px;
    opacity: 0.95;
}

.filters-card {
    background: white;
    border-radius: 12px;
    padding: 20px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    margin-bottom: 20px;
}

.search-input {
    padding: 10px 16px 10px 40px;
    border: 2px solid #e2e8f0;
    border-radius: 8px;
    font-size: 14px;
    width: 100%;
    transition: all 0.2s ease;
}

.search-input:focus {
    outline: none;
    border-color: #667eea;
}

.search-icon {
    position: absolute;
    left: 12px;
    top: 50%;
    transform: translateY(-50%);
    color: #94a3b8;
}

.filter-select {
    padding: 10px 16px;
    border: 2px solid #e2e8f0;
    border-radius: 8px;
    font-size: 14px;
    width: 100%;
    transition: all 0.2s ease;
}

.filter-select:focus {
    outline: none;
    border-color: #667eea;
}

.users-card {
    background: white;
    border-radius: 12px;
    padding: 24px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
}

.card-title {
    font-size: 18px;
    font-weight: 600;
    color: #1a1a1a;
    margin-bottom: 20px;
}

.user-item {
    padding: 16px;
    border-radius: 8px;
    margin-bottom: 12px;
    transition: all 0.2s ease;
    background: #f8fafc;
    border-left: 4px solid transparent;
}

.user-item:hover {
    background: #f1f5f9;
    border-left-color: #667eea;
    transform: translateX(4px);
}

.user-item:last-child {
    margin-bottom: 0;
}

.user-avatar {
    width: 48px;
    height: 48px;
    border-radius: 50%;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 600;
    font-size: 16px;
    flex-shrink: 0;
}

.user-name {
    font-size: 15px;
    font-weight: 600;
    color: #1a1a1a;
    margin-bottom: 4px;
}

.user-email {
    font-size: 13px;
    color: #64748b;
}

.user-meta {
    font-size: 12px;
    color: #94a3b8;
}

.role-badge {
    padding: 4px 12px;
    border-radius: 6px;
    font-size: 11px;
    font-weight: 600;
    color: white;
}

.status-badge {
    padding: 4px 12px;
    border-radius: 6px;
    font-size: 11px;
    font-weight: 600;
    color: white;
}

.action-button {
    width: 32px;
    height: 32px;
    border-radius: 6px;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: all 0.2s ease;
    color: #64748b;
    background: white;
}

.action-button:hover {
    background: #667eea;
    color: white;
}

@media (max-width: 959px) {
    .stat-card {
        padding: 20px;
    }

    .stat-value {
        font-size: 28px;
    }

    .stat-icon {
        font-size: 28px;
    }

    .user-meta {
        display: none;
    }
}
</style>

<div class="uk-flex uk-flex-between uk-flex-middle uk-margin-bottom mobile-stack">
    <h3 class="uk-margin-remove mobile-mb">
        <i class="fa-slab fa-solid fa-users"></i> User Management
    </h3>
    <button class="uk-button uk-button-primary uk-button-small mobile-full" uk-toggle="target: #add-user-modal">
        <i class="fa-slab fa-solid fa-plus"></i> Add User
    </button>
</div>

<!-- Stats Cards -->
<div class="uk-grid-small uk-child-width-1-3@m uk-margin-bottom" uk-grid>
    <?php foreach ($user_stats as $stat): ?>
    <div>
        <div class="stat-card" style="--stat-color: <?= $stat['color'] ?>; --stat-color-dark: <?= $stat['color_dark'] ?>;">
            <div class="stat-content">
                <div class="stat-icon">
                    <i class="fa-slab fa-solid <?= $stat['icon'] ?>"></i>
                </div>
                <div class="stat-value"><?= e($stat['value']) ?></div>
                <div class="stat-label"><?= e($stat['label']) ?></div>
            </div>
        </div>
    </div>
    <?php endforeach; ?>
</div>

<!-- Filters -->
<div class="filters-card">
    <form class="uk-grid-small" uk-grid>
        <div class="uk-width-1-1 uk-width-expand@m">
            <div class="uk-inline uk-width-1-1">
                <i class="fa-slab fa-solid fa-search search-icon"></i>
                <input class="search-input" type="search" id="user-search" placeholder="Search users..."
                       _="on keyup call filterUsers()">
            </div>
        </div>
        <div class="uk-width-1-2 uk-width-auto@m">
            <select class="filter-select" id="role-filter"
                    _="on change call filterUsers()">
                <option value="">All Roles</option>
                <?php foreach ($GLOBALS['role_names'] as $value => $label): ?>
                    <option value="<?= $value ?>"><?= $label ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="uk-width-1-2 uk-width-auto@m">
            <select class="filter-select" id="status-filter"
                    _="on change call filterUsers()">
                <option value="">All Status</option>
                <option value="active">Active</option>
                <option value="pending">Pending</option>
                <option value="inactive">Inactive</option>
            </select>
        </div>
        <div class="uk-width-1-1 uk-width-auto@m">
            <button class="uk-button uk-button-default uk-width-1-1 uk-width-auto@m" type="button">
                <i class="fa-slab fa-solid fa-download"></i> Export
            </button>
        </div>
    </form>
</div>

<script>
function filterUsers() {
    var search = document.getElementById('user-search').value.toLowerCase();
    var role = document.getElementById('role-filter').value;
    var status = document.getElementById('status-filter').value;
    var items = document.querySelectorAll('#users-list .user-item');
    var count = 0;

    items.forEach(function(item) {
        var text = item.textContent.toLowerCase();
        var itemRole = item.dataset.role || '';
        var itemStatus = item.dataset.status || '';

        var matchSearch = !search || text.indexOf(search) >= 0;
        var matchRole = !role || itemRole === role;
        var matchStatus = !status || itemStatus === status;

        if (matchSearch && matchRole && matchStatus) {
            item.classList.remove('uk-hidden');
            count++;
        } else {
            item.classList.add('uk-hidden');
        }
    });

    document.getElementById('user-count').textContent = count;
}
</script>

<!-- Users List -->
<div class="users-card">
    <h4 class="card-title">
        <i class="fa-slab fa-solid fa-list"></i> Users (<span id="user-count"><?= count($users) ?></span>)
    </h4>
    <div id="users-list">
        <?php foreach ($users as $user):
            $initials = strtoupper(substr($user['name'], 0, 1) . (strpos($user['name'], ' ') !== false ? substr(strstr($user['name'], ' '), 1, 1) : ''));
            $status = $status_config[$user['status']];
        ?>
            <div class="user-item" data-role="<?= $user['role'] ?>" data-status="<?= $user['status'] ?>"
                 style="cursor: pointer;"
                 hx-get="<?= BASE_URL ?>/pages/user-detail.php?id=<?= $user['id'] ?>"
                 hx-target="#main-content"
                 hx-swap="innerHTML"
                 hx-push-url="<?= BASE_URL ?>/user-detail.php?id=<?= $user['id'] ?>">
                <div class="uk-flex uk-flex-between uk-flex-middle" style="gap: 16px;">
                    <!-- Avatar & Info -->
                    <div class="uk-flex uk-flex-middle" style="flex: 1; gap: 16px; min-width: 0;">
                        <div class="user-avatar"><?= $initials ?></div>
                        <div style="flex: 1; min-width: 0;">
                            <div class="user-name"><?= e($user['name']) ?></div>
                            <div class="user-email"><?= e($user['email']) ?></div>
                        </div>
                    </div>

                    <!-- Meta Info (Desktop) -->
                    <div class="uk-flex uk-flex-middle uk-visible@m" style="gap: 20px;">
                        <div class="user-meta">
                            <i class="fa-slab fa-solid fa-calendar fa-fw"></i> <?= date('M d, Y', strtotime($user['joined'])) ?>
                        </div>
                        <?php if (!empty($user['meta'])): ?>
                            <?php foreach ($user['meta'] as $key => $value): ?>
                                <div class="user-meta">
                                    <i class="fa-slab fa-solid fa-<?= $key === 'Students' ? 'users' : ($key === 'Applications' ? 'file' : 'dollar-sign') ?> fa-fw"></i>
                                    <?= e($value) ?> <?= e($key) ?>
                                </div>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>

                    <!-- Role & Status -->
                    <div class="uk-flex uk-flex-middle" style="gap: 8px;">
                        <span class="role-badge" style="background: <?= $user['role'] === ROLE_ADMIN ? '#1e87f0' : ($user['role'] === ROLE_COUNSELOR ? '#faa05a' : '#667eea') ?>;">
                            <?= $GLOBALS['role_names'][$user['role']] ?>
                        </span>
                        <span class="status-badge" style="background: <?= $status['color'] ?>;">
                            <?= $status['label'] ?>
                        </span>
                    </div>

                    <!-- Actions -->
                    <div class="uk-flex uk-flex-middle uk-visible@m" style="gap: 4px;">
                        <div class="action-button" uk-tooltip="Edit User">
                            <i class="fa-slab fa-solid fa-edit"></i>
                        </div>
                        <div class="action-button" uk-tooltip="Delete User">
                            <i class="fa-slab fa-solid fa-trash"></i>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
</div>

<!-- Add User Modal -->
<div id="add-user-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title"><i class="fa-slab fa-solid fa-user-plus"></i> Add New User</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">First Name</label>
                    <input class="uk-input" type="text" placeholder="John" required>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Last Name</label>
                    <input class="uk-input" type="text" placeholder="Doe" required>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Email</label>
                    <input class="uk-input" type="email" placeholder="john.doe@example.com" required>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Role</label>
                    <select class="uk-select" required>
                        <option value="">Select role</option>
                        <?php foreach ($GLOBALS['role_names'] as $value => $label): ?>
                            <option value="<?= $value ?>"><?= $label ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">
                <i class="fa-slab fa-solid fa-check"></i> Add User
            </button>
        </div>
    </div>
</div>
