<?php
/**
 * Admin Dashboard - Payments Page
 */

require_once __DIR__ . '/includes/bootstrap.php';

$page_title = 'Admin Dashboard';
$page_description = 'Manage users, monitor system performance, and generate reports.';
$active_tab = 'payments';

ob_start();

// Payment stats
$payment_stats = [
    ['icon' => 'credit-card', 'value' => '$2.8M', 'label' => 'Total Revenue', 'trend' => 15, 'color' => 'success'],
    ['icon' => 'calendar', 'value' => '$235K', 'label' => 'This Month', 'trend' => 8, 'color' => 'primary'],
    ['icon' => 'clock', 'value' => '$45K', 'label' => 'Pending Payments', 'color' => 'warning'],
    ['icon' => 'refresh', 'value' => '$12K', 'label' => 'Refunds Processed', 'color' => 'danger']
];

// Payment methods performance
$payment_methods = [
    ['label' => 'Credit/Debit Card', 'value' => 1234, 'amount' => '$1.2M', 'suffix' => 'transactions'],
    ['label' => 'Bank Transfer', 'value' => 456, 'amount' => '$890K', 'suffix' => 'transactions'],
    ['label' => 'Digital Wallet', 'value' => 234, 'amount' => '$340K', 'suffix' => 'transactions'],
    ['label' => 'Cash', 'value' => 89, 'amount' => '$120K', 'suffix' => 'transactions']
];

// Payment analytics
$analytics = [
    'Average Transaction' => '$2,340',
    'Success Rate' => '98.5%',
    'Failed Transactions' => '1.5%',
    'Processing Time' => '2.3 min avg'
];

// Recent transactions
$transactions = [
    ['id' => 'TXN-001', 'user' => 'John Doe', 'method' => 'Credit Card', 'date' => '2024-01-30 14:32', 'amount' => '$25,000', 'status' => 'completed'],
    ['id' => 'TXN-002', 'user' => 'Sarah Chen', 'method' => 'Bank Transfer', 'date' => '2024-01-30 13:15', 'amount' => '$15,000', 'status' => 'pending'],
    ['id' => 'TXN-003', 'user' => 'Michael Rodriguez', 'method' => 'Digital Wallet', 'date' => '2024-01-30 11:45', 'amount' => '$20,000', 'status' => 'completed'],
    ['id' => 'TXN-004', 'user' => 'Emma Wilson', 'method' => 'Bank Transfer', 'date' => '2024-01-30 10:23', 'amount' => '$30,000', 'status' => 'failed']
];
?>

<!-- Page Header with Actions -->
<div class="uk-flex uk-flex-between uk-flex-middle uk-margin-bottom">
    <h3 class="uk-margin-remove">Payment Management</h3>
    <div>
        <button class="uk-button uk-button-default uk-button-small uk-margin-small-right">
            <span uk-icon="icon: download; ratio: 0.8"></span> Export Transactions
        </button>
        <button class="uk-button uk-button-primary uk-button-small">
            <span uk-icon="icon: credit-card; ratio: 0.8"></span> Process Refund
        </button>
    </div>
</div>

<!-- Stats -->
<?php render_stat_cards($payment_stats); ?>

<div class="uk-grid-small uk-margin-top" uk-grid>
    <!-- Payment Methods -->
    <div class="uk-width-1-2@m">
        <div class="uk-card uk-card-default uk-card-body">
            <h4 class="uk-card-title">Payment Methods Performance</h4>
            <?php foreach ($payment_methods as $method): ?>
                <div class="uk-flex uk-flex-between uk-margin-small-bottom">
                    <span><?= e($method['label']) ?></span>
                    <div class="uk-text-right">
                        <div class="uk-text-bold"><?= e($method['amount']) ?></div>
                        <div class="uk-text-muted uk-text-small"><?= number_format($method['value']) ?> <?= e($method['suffix']) ?></div>
                    </div>
                </div>
                <progress class="uk-progress" value="<?= ($method['value'] / 1234) * 100 ?>" max="100"></progress>
            <?php endforeach; ?>
        </div>
    </div>

    <!-- Payment Analytics -->
    <div class="uk-width-1-2@m">
        <div class="uk-card uk-card-default uk-card-body">
            <h4 class="uk-card-title">Payment Analytics</h4>
            <dl class="uk-description-list">
                <?php foreach ($analytics as $key => $value): ?>
                    <div class="uk-flex uk-flex-between uk-margin-small-bottom">
                        <dt class="uk-text-muted"><?= e($key) ?>:</dt>
                        <dd class="uk-text-bold <?= strpos($value, '%') !== false && floatval($value) > 90 ? 'uk-text-success' : '' ?>">
                            <?= e($value) ?>
                        </dd>
                    </div>
                <?php endforeach; ?>
            </dl>
        </div>
    </div>
</div>

<!-- Recent Transactions -->
<div class="uk-card uk-card-default uk-card-body uk-margin-top">
    <h4 class="uk-card-title">Recent Transactions</h4>
    <?php foreach ($transactions as $txn): ?>
        <div class="uk-card uk-card-default uk-card-body uk-card-small uk-margin-small-bottom">
            <div class="uk-flex uk-flex-between uk-flex-middle">
                <div class="uk-flex uk-flex-middle">
                    <div class="uk-border-circle uk-flex uk-flex-center uk-flex-middle uk-margin-right"
                         style="width: 40px; height: 40px; <?= get_stat_icon_style('primary') ?>">
                        <span uk-icon="icon: credit-card; ratio: 0.8"></span>
                    </div>
                    <div>
                        <div class="uk-text-bold"><?= e($txn['id']) ?></div>
                        <div class="uk-text-muted uk-text-small">
                            <?= e($txn['user']) ?> &middot; <?= e($txn['method']) ?>
                        </div>
                        <div class="uk-text-meta uk-text-small"><?= e($txn['date']) ?></div>
                    </div>
                </div>
                <div class="uk-text-right">
                    <div class="uk-text-bold"><?= e($txn['amount']) ?></div>
                    <?= get_status_badge($txn['status'], 'payment') ?>
                </div>
            </div>
        </div>
    <?php endforeach; ?>
</div>

<?php
$content = ob_get_clean();
include __DIR__ . '/includes/layout.php';
?>
