<?php
/**
 * Admin Dashboard - Reports & Analytics Page
 */

require_once __DIR__ . '/includes/bootstrap.php';

$page_title = 'Admin Dashboard';
$page_description = 'Manage users, monitor system performance, and generate reports.';
$active_tab = 'reports';

ob_start();

// Report stats
$report_stats = [
    ['icon' => 'check', 'value' => '89.5%', 'label' => 'Acceptance Rate', 'trend' => 5, 'color' => 'success'],
    ['icon' => 'users', 'value' => '234', 'label' => 'New Students', 'trend' => 12, 'color' => 'primary'],
    ['icon' => 'world', 'value' => '24', 'label' => 'Countries Served', 'trend' => 2, 'suffix' => 'new this month', 'color' => 'warning'],
    ['icon' => 'clock', 'value' => '18.5', 'label' => 'Avg Processing Days', 'trend' => -2, 'suffix' => 'days improvement', 'color' => 'cyan']
];

// Monthly growth trends
$monthly_trends = [
    ['month' => 'Jan', 'students' => 234, 'revenue' => '$185K'],
    ['month' => 'Feb', 'students' => 267, 'revenue' => '$210K'],
    ['month' => 'Mar', 'students' => 298, 'revenue' => '$245K'],
    ['month' => 'Apr', 'students' => 345, 'revenue' => '$287K'],
    ['month' => 'May', 'students' => 389, 'revenue' => '$324K'],
    ['month' => 'Jun', 'students' => 423, 'revenue' => '$356K']
];

// Success rates by program
$program_rates = [
    ['label' => 'Computer Science', 'value' => 456, 'percentage' => 92, 'suffix' => 'applications'],
    ['label' => 'Engineering', 'value' => 342, 'percentage' => 88, 'suffix' => 'applications'],
    ['label' => 'Business Administration', 'value' => 298, 'percentage' => 85, 'suffix' => 'applications'],
    ['label' => 'Medicine', 'value' => 234, 'percentage' => 78, 'suffix' => 'applications'],
    ['label' => 'Liberal Arts', 'value' => 187, 'percentage' => 94, 'suffix' => 'applications']
];

// Counselor performance
$counselors = [
    ['name' => 'Sarah Johnson', 'students' => 45, 'success' => '94%', 'response' => '2.3 hrs', 'satisfaction' => '4.8/5'],
    ['name' => 'Michael Chen', 'students' => 38, 'success' => '91%', 'response' => '1.8 hrs', 'satisfaction' => '4.9/5'],
    ['name' => 'Emily Rodriguez', 'students' => 42, 'success' => '89%', 'response' => '3.1 hrs', 'satisfaction' => '4.7/5'],
    ['name' => 'David Kim', 'students' => 35, 'success' => '87%', 'response' => '2.7 hrs', 'satisfaction' => '4.6/5']
];
?>

<!-- Page Header with Actions -->
<div class="uk-flex uk-flex-between uk-flex-middle uk-margin-bottom">
    <h3 class="uk-margin-remove">Reports & Analytics</h3>
    <div>
        <select class="uk-select uk-form-small uk-margin-small-right" style="width: 120px;">
            <option>Monthly</option>
            <option>Quarterly</option>
            <option>Yearly</option>
        </select>
        <button class="uk-button uk-button-primary uk-button-small">
            <span uk-icon="icon: download; ratio: 0.8"></span> Generate Report
        </button>
    </div>
</div>

<!-- Stats -->
<?php render_stat_cards($report_stats); ?>

<div class="uk-grid-small uk-margin-top" uk-grid>
    <!-- Monthly Growth Trends -->
    <div class="uk-width-1-2@m">
        <div class="uk-card uk-card-default uk-card-body">
            <h4 class="uk-card-title">Monthly Growth Trends</h4>
            <?php foreach ($monthly_trends as $trend): ?>
                <div class="uk-margin-small-bottom">
                    <div class="uk-flex uk-flex-between uk-margin-small-bottom">
                        <span class="uk-text-bold"><?= e($trend['month']) ?></span>
                        <div class="uk-text-right">
                            <span class="uk-text-bold"><?= $trend['students'] ?> students</span>
                            <span class="uk-text-muted uk-margin-small-left"><?= e($trend['revenue']) ?> revenue</span>
                        </div>
                    </div>
                    <progress class="uk-progress" value="<?= ($trend['students'] / 500) * 100 ?>" max="100"></progress>
                </div>
            <?php endforeach; ?>
        </div>
    </div>

    <!-- Success Rates by Program -->
    <div class="uk-width-1-2@m">
        <div class="uk-card uk-card-default uk-card-body">
            <h4 class="uk-card-title">Success Rates by Program Type</h4>
            <?php foreach ($program_rates as $rate): ?>
                <div class="uk-margin-small-bottom">
                    <div class="uk-flex uk-flex-between uk-margin-small-bottom">
                        <span><?= e($rate['label']) ?></span>
                        <div class="uk-text-right">
                            <span class="uk-text-bold"><?= $rate['percentage'] ?>%</span>
                            <span class="uk-text-muted uk-text-small uk-margin-small-left"><?= number_format($rate['value']) ?> <?= e($rate['suffix']) ?></span>
                        </div>
                    </div>
                    <progress class="uk-progress" value="<?= $rate['percentage'] ?>" max="100"></progress>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>

<!-- Counselor Performance -->
<div class="uk-card uk-card-default uk-card-body uk-margin-top">
    <h4 class="uk-card-title">Counselor Performance Metrics</h4>
    <?php foreach ($counselors as $counselor): ?>
        <div class="uk-card uk-card-default uk-card-body uk-card-small uk-margin-small-bottom">
            <div class="uk-flex uk-flex-between uk-flex-middle">
                <div class="uk-flex uk-flex-middle">
                    <?= get_avatar($counselor['name'], 40) ?>
                    <div class="uk-margin-left">
                        <div class="uk-text-bold"><?= e($counselor['name']) ?></div>
                        <div class="uk-text-muted uk-text-small"><?= $counselor['students'] ?> students managed</div>
                    </div>
                </div>
                <div class="uk-flex uk-text-center">
                    <div class="uk-margin-right">
                        <div class="uk-text-bold uk-text-success"><?= e($counselor['success']) ?></div>
                        <div class="uk-text-meta uk-text-small">Success Rate</div>
                    </div>
                    <div class="uk-margin-right">
                        <div class="uk-text-bold uk-text-primary"><?= e($counselor['response']) ?></div>
                        <div class="uk-text-meta uk-text-small">Avg Response</div>
                    </div>
                    <div>
                        <div class="uk-text-bold uk-text-warning"><?= e($counselor['satisfaction']) ?></div>
                        <div class="uk-text-meta uk-text-small">Satisfaction</div>
                    </div>
                </div>
            </div>
        </div>
    <?php endforeach; ?>
</div>

<?php
$content = ob_get_clean();
include __DIR__ . '/includes/layout.php';
?>
