<?php
/**
 * Admin Dashboard - Settings Page
 */

require_once __DIR__ . '/includes/bootstrap.php';

$page_title = 'Admin Dashboard';
$page_description = 'Manage users, monitor system performance, and generate reports.';
$active_tab = 'settings';

ob_start();
?>

<div class="uk-grid-small" uk-grid>
    <!-- System Configuration -->
    <div class="uk-width-1-2@m">
        <div class="uk-card uk-card-default uk-card-body">
            <h4 class="uk-card-title">System Configuration</h4>

            <form hx-post="<?= BASE_URL ?>/api/settings.php"
                  hx-target="#system-config-response"
                  hx-swap="innerHTML">
                <div class="uk-margin">
                    <label class="uk-form-label">Application Deadline Reminder</label>
                    <select class="uk-select" name="deadline_reminder">
                        <option value="7" selected>7 days before</option>
                        <option value="14">14 days before</option>
                        <option value="30">30 days before</option>
                    </select>
                </div>

                <div class="uk-margin">
                    <label class="uk-form-label">Maximum File Upload Size</label>
                    <select class="uk-select" name="max_upload">
                        <option value="5">5 MB</option>
                        <option value="10" selected>10 MB</option>
                        <option value="25">25 MB</option>
                    </select>
                </div>

                <div class="uk-margin">
                    <label class="uk-form-label">Default Application Status</label>
                    <select class="uk-select" name="default_status">
                        <option value="pending" selected>Pending Review</option>
                        <option value="submitted">Submitted</option>
                    </select>
                </div>

                <div class="uk-margin">
                    <label class="uk-form-label">Payment Processing Fee</label>
                    <div class="uk-inline uk-width-1-1">
                        <input class="uk-input" type="number" name="processing_fee" value="2.9" step="0.1">
                        <span class="uk-form-icon uk-form-icon-flip">%</span>
                    </div>
                </div>

                <div id="system-config-response"></div>

                <button class="uk-button uk-button-primary uk-width-1-1" type="submit">
                    <span uk-icon="icon: cog; ratio: 0.8"></span> Save System Settings
                </button>
            </form>
        </div>
    </div>

    <!-- Email & Notifications -->
    <div class="uk-width-1-2@m">
        <div class="uk-card uk-card-default uk-card-body">
            <h4 class="uk-card-title">Email & Notifications</h4>

            <form hx-post="<?= BASE_URL ?>/api/settings.php?type=email"
                  hx-target="#email-config-response"
                  hx-swap="innerHTML">
                <div class="uk-margin">
                    <label class="uk-flex uk-flex-between">
                        <span>Student Registration Notifications</span>
                        <input class="uk-checkbox" type="checkbox" name="notify_registration" checked
                               _="on change toggle .uk-text-muted on next <small/>">
                    </label>
                    <small class="uk-text-muted">Notify admins when new students register</small>
                </div>

                <div class="uk-margin">
                    <label class="uk-flex uk-flex-between">
                        <span>Application Status Updates</span>
                        <input class="uk-checkbox" type="checkbox" name="notify_status" checked>
                    </label>
                    <small class="uk-text-muted">Auto-email students on status changes</small>
                </div>

                <div class="uk-margin">
                    <label class="uk-flex uk-flex-between">
                        <span>Payment Confirmations</span>
                        <input class="uk-checkbox" type="checkbox" name="notify_payment" checked>
                    </label>
                    <small class="uk-text-muted">Send receipt emails automatically</small>
                </div>

                <div class="uk-margin">
                    <label class="uk-flex uk-flex-between">
                        <span>Deadline Reminders</span>
                        <input class="uk-checkbox" type="checkbox" name="notify_deadline" checked>
                    </label>
                    <small class="uk-text-muted">Remind students of upcoming deadlines</small>
                </div>

                <div class="uk-margin">
                    <label class="uk-form-label">Email Template Language</label>
                    <select class="uk-select" name="email_language">
                        <option value="en" selected>English</option>
                        <option value="es">Spanish</option>
                        <option value="fr">French</option>
                        <option value="zh">Chinese</option>
                    </select>
                </div>

                <div id="email-config-response"></div>

                <button class="uk-button uk-button-primary uk-width-1-1" type="submit">
                    <span uk-icon="icon: mail; ratio: 0.8"></span> Update Email Settings
                </button>
            </form>
        </div>
    </div>
</div>

<!-- User Permissions & Roles -->
<div class="uk-card uk-card-default uk-card-body uk-margin-top">
    <h4 class="uk-card-title">User Permissions & Roles</h4>

    <?php
    $roles_config = [
        ['name' => 'Super Admin', 'permissions' => ['All system access', 'User management', 'System settings', 'Financial reports']],
        ['name' => 'Admin', 'permissions' => ['User management', 'Application oversight', 'Payment management', 'Reports']],
        ['name' => 'Senior Counselor', 'permissions' => ['Student management', 'Application review', 'Document verification']],
        ['name' => 'Counselor', 'permissions' => ['Assigned students', 'Application guidance', 'Document review']]
    ];
    ?>

    <?php foreach ($roles_config as $role): ?>
        <div class="uk-card uk-card-default uk-card-body uk-card-small uk-margin-small-bottom">
            <div class="uk-flex uk-flex-between uk-flex-middle">
                <div>
                    <div class="uk-text-bold"><?= e($role['name']) ?></div>
                    <div class="uk-margin-small-top">
                        <?php foreach ($role['permissions'] as $perm): ?>
                            <span class="uk-label uk-label-secondary uk-margin-small-right uk-margin-small-bottom"><?= e($perm) ?></span>
                        <?php endforeach; ?>
                    </div>
                </div>
                <a href="#" class="uk-button uk-button-default uk-button-small">
                    <span uk-icon="icon: pencil; ratio: 0.8"></span> Edit
                </a>
            </div>
        </div>
    <?php endforeach; ?>

    <button class="uk-button uk-button-default uk-margin-top uk-width-1-1">
        <span uk-icon="icon: plus; ratio: 0.8"></span> Create New Role
    </button>
</div>

<!-- System Maintenance -->
<div class="uk-card uk-card-default uk-card-body uk-margin-top">
    <h4 class="uk-card-title">System Maintenance</h4>

    <div class="uk-grid-small" uk-grid>
        <div class="uk-width-1-2@s">
            <div class="uk-card uk-card-default uk-card-body uk-card-small">
                <div class="uk-text-primary uk-text-small">Database Size</div>
                <div class="uk-text-large uk-text-bold uk-text-success">2.4 GB</div>
                <div class="uk-text-success uk-text-small">12% increase this month</div>
            </div>
        </div>
        <div class="uk-width-1-2@s">
            <div class="uk-card uk-card-default uk-card-body uk-card-small">
                <div class="uk-text-primary uk-text-small">System Uptime</div>
                <div class="uk-text-large uk-text-bold uk-text-success">99.9%</div>
                <div class="uk-text-success uk-text-small">Last 30 days</div>
            </div>
        </div>
    </div>

    <div class="uk-margin-top">
        <button class="uk-button uk-button-default uk-width-1-1 uk-margin-small-bottom"
                hx-post="<?= BASE_URL ?>/api/maintenance.php?action=backup"
                hx-confirm="Are you sure you want to backup the database?"
                hx-indicator="#backup-indicator">
            <span uk-icon="icon: download; ratio: 0.8"></span> Backup Database
            <span id="backup-indicator" class="htmx-indicator" uk-spinner="ratio: 0.5"></span>
        </button>

        <button class="uk-button uk-button-default uk-width-1-1 uk-margin-small-bottom"
                hx-post="<?= BASE_URL ?>/api/maintenance.php?action=cache"
                hx-confirm="Clear system cache?">
            <span uk-icon="icon: refresh; ratio: 0.8"></span> Clear System Cache
        </button>

        <button class="uk-button uk-button-default uk-width-1-1"
                hx-get="<?= BASE_URL ?>/api/maintenance.php?action=report"
                hx-target="#report-download">
            <span uk-icon="icon: file-text; ratio: 0.8"></span> Generate System Report
        </button>
        <div id="report-download"></div>
    </div>

    <div class="uk-alert uk-alert-warning uk-margin-top">
        <p><strong>Scheduled Maintenance:</strong> System will be offline for maintenance on Feb 15, 2024 from 2:00 AM - 4:00 AM EST.</p>
    </div>
</div>

<?php
$content = ob_get_clean();
include __DIR__ . '/includes/layout.php';
?>
