<?php
/**
 * Admin Dashboard - Users Page
 */

require_once __DIR__ . '/includes/bootstrap.php';

$page_title = 'Admin Dashboard';
$page_description = 'Manage users, monitor system performance, and generate reports.';
$active_tab = 'users';

ob_start();

// Mock user stats
$user_stats = [
    ['icon' => 'user', 'value' => '2456', 'label' => 'Students', 'color' => 'primary'],
    ['icon' => 'users', 'value' => '34', 'label' => 'Counselors', 'color' => 'warning'],
    ['icon' => 'cog', 'value' => '12', 'label' => 'Administrators', 'color' => 'purple']
];

// Mock users data
$users = [
    [
        'id' => 1,
        'name' => 'John Doe',
        'email' => 'john.doe@email.com',
        'role' => ROLE_STUDENT,
        'status' => 'active',
        'joined' => '2024-01-15',
        'last_active' => '2024-01-30',
        'meta' => ['Applications' => 3, 'Spent' => '$45,000']
    ],
    [
        'id' => 2,
        'name' => 'Sarah Johnson',
        'email' => 'sarah.johnson@globaledpathways.com',
        'role' => ROLE_COUNSELOR,
        'status' => 'active',
        'joined' => '2023-06-01',
        'last_active' => '2024-01-30',
        'meta' => ['Students' => 45]
    ],
    [
        'id' => 3,
        'name' => 'Michael Chen',
        'email' => 'michael.chen@globaledpathways.com',
        'role' => ROLE_ADMIN,
        'status' => 'active',
        'joined' => '2023-01-01',
        'last_active' => '2024-01-30',
        'meta' => []
    ]
];
?>

<!-- Page Header with Actions -->
<div class="uk-flex uk-flex-between uk-flex-middle uk-margin-bottom">
    <h3 class="uk-margin-remove">User Management</h3>
    <button class="uk-button uk-button-primary uk-button-small"
            uk-toggle="target: #add-user-modal">
        <span uk-icon="icon: plus; ratio: 0.8"></span> Add User
    </button>
</div>

<!-- User Stats -->
<div class="uk-child-width-1-3@m uk-grid-small uk-margin-bottom" uk-grid>
    <?php foreach ($user_stats as $stat): ?>
        <div><?php render_stat_card($stat); ?></div>
    <?php endforeach; ?>
</div>

<!-- Search and Filters -->
<div class="uk-card uk-card-default uk-card-body uk-card-small uk-margin-bottom">
    <form class="uk-flex uk-flex-middle uk-flex-wrap"
          hx-get="<?= BASE_URL ?>/api/users.php"
          hx-target="#users-list"
          hx-trigger="submit, change from:select">
        <div class="uk-flex-1 uk-margin-small-right">
            <div class="uk-inline uk-width-1-1">
                <span class="uk-form-icon" uk-icon="icon: search"></span>
                <input class="uk-input" type="search" name="search" placeholder="Search users..."
                       hx-get="<?= BASE_URL ?>/api/users.php"
                       hx-target="#users-list"
                       hx-trigger="keyup changed delay:300ms">
            </div>
        </div>
        <div class="uk-margin-small-right">
            <select class="uk-select" name="role">
                <option value="">All Roles</option>
                <?php foreach ($GLOBALS['role_names'] as $value => $label): ?>
                    <option value="<?= $value ?>"><?= $label ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <button class="uk-button uk-button-default" type="button">
            <span uk-icon="icon: download"></span> Export
        </button>
    </form>
</div>

<!-- Users List -->
<div class="uk-card uk-card-default uk-card-body">
    <h4 class="uk-card-title">Users (<?= count($users) ?>)</h4>
    <div id="users-list">
        <?php foreach ($users as $user): ?>
            <?php render_user_list_item($user); ?>
        <?php endforeach; ?>
    </div>
</div>

<!-- Add User Modal -->
<?php
render_form_modal('add-user-modal', 'Add New User', [
    ['name' => 'first_name', 'label' => 'First Name', 'type' => 'text', 'placeholder' => 'John', 'required' => true],
    ['name' => 'last_name', 'label' => 'Last Name', 'type' => 'text', 'placeholder' => 'Doe', 'required' => true],
    ['name' => 'email', 'label' => 'Email', 'type' => 'email', 'placeholder' => 'john.doe@example.com', 'required' => true],
    ['name' => 'role', 'label' => 'Role', 'type' => 'select', 'placeholder' => 'Select role', 'required' => true, 'options' => $GLOBALS['role_names']]
], BASE_URL . '/api/users.php');
?>

<?php
$content = ob_get_clean();
include __DIR__ . '/includes/layout.php';
?>
