/*!
 * Font Awesome Pro 7.1.0 by @fontawesome - https://fontawesome.com
 * License - https://fontawesome.com/license (Commercial License)
 * Copyright 2025 Fonticons, Inc.
 */
(function () {
  'use strict';

  var _WINDOW = {};
  var _DOCUMENT = {};
  try {
    if (typeof window !== 'undefined') _WINDOW = window;
    if (typeof document !== 'undefined') _DOCUMENT = document;
  } catch (e) {} // eslint-disable-line no-empty

  var _ref = _WINDOW.navigator || {},
    _ref$userAgent = _ref.userAgent,
    userAgent = _ref$userAgent === void 0 ? '' : _ref$userAgent;
  var WINDOW = _WINDOW;
  var DOCUMENT = _DOCUMENT;
  var IS_BROWSER = !!WINDOW.document;
  var IS_DOM = !!DOCUMENT.documentElement && !!DOCUMENT.head && typeof DOCUMENT.addEventListener === 'function' && typeof DOCUMENT.createElement === 'function';
  var IS_IE = ~userAgent.indexOf('MSIE') || ~userAgent.indexOf('Trident/');

  function _arrayLikeToArray(r, a) {
    (null == a || a > r.length) && (a = r.length);
    for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e];
    return n;
  }
  function _arrayWithoutHoles(r) {
    if (Array.isArray(r)) return _arrayLikeToArray(r);
  }
  function _defineProperty(e, r, t) {
    return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, {
      value: t,
      enumerable: !0,
      configurable: !0,
      writable: !0
    }) : e[r] = t, e;
  }
  function _iterableToArray(r) {
    if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r);
  }
  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }
  function ownKeys(e, r) {
    var t = Object.keys(e);
    if (Object.getOwnPropertySymbols) {
      var o = Object.getOwnPropertySymbols(e);
      r && (o = o.filter(function (r) {
        return Object.getOwnPropertyDescriptor(e, r).enumerable;
      })), t.push.apply(t, o);
    }
    return t;
  }
  function _objectSpread2(e) {
    for (var r = 1; r < arguments.length; r++) {
      var t = null != arguments[r] ? arguments[r] : {};
      r % 2 ? ownKeys(Object(t), !0).forEach(function (r) {
        _defineProperty(e, r, t[r]);
      }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) {
        Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r));
      });
    }
    return e;
  }
  function _toConsumableArray(r) {
    return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread();
  }
  function _toPrimitive(t, r) {
    if ("object" != typeof t || !t) return t;
    var e = t[Symbol.toPrimitive];
    if (void 0 !== e) {
      var i = e.call(t, r || "default");
      if ("object" != typeof i) return i;
      throw new TypeError("@@toPrimitive must return a primitive value.");
    }
    return ("string" === r ? String : Number)(t);
  }
  function _toPropertyKey(t) {
    var i = _toPrimitive(t, "string");
    return "symbol" == typeof i ? i : i + "";
  }
  function _unsupportedIterableToArray(r, a) {
    if (r) {
      if ("string" == typeof r) return _arrayLikeToArray(r, a);
      var t = {}.toString.call(r).slice(8, -1);
      return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0;
    }
  }

  var _dt;
  var q = {
      classic: {
        fa: "solid",
        fas: "solid",
        "fa-solid": "solid",
        far: "regular",
        "fa-regular": "regular",
        fal: "light",
        "fa-light": "light",
        fat: "thin",
        "fa-thin": "thin",
        fab: "brands",
        "fa-brands": "brands"
      },
      duotone: {
        fa: "solid",
        fad: "solid",
        "fa-solid": "solid",
        "fa-duotone": "solid",
        fadr: "regular",
        "fa-regular": "regular",
        fadl: "light",
        "fa-light": "light",
        fadt: "thin",
        "fa-thin": "thin"
      },
      sharp: {
        fa: "solid",
        fass: "solid",
        "fa-solid": "solid",
        fasr: "regular",
        "fa-regular": "regular",
        fasl: "light",
        "fa-light": "light",
        fast: "thin",
        "fa-thin": "thin"
      },
      "sharp-duotone": {
        fa: "solid",
        fasds: "solid",
        "fa-solid": "solid",
        fasdr: "regular",
        "fa-regular": "regular",
        fasdl: "light",
        "fa-light": "light",
        fasdt: "thin",
        "fa-thin": "thin"
      },
      slab: {
        "fa-regular": "regular",
        faslr: "regular"
      },
      "slab-press": {
        "fa-regular": "regular",
        faslpr: "regular"
      },
      thumbprint: {
        "fa-light": "light",
        fatl: "light"
      },
      whiteboard: {
        "fa-semibold": "semibold",
        fawsb: "semibold"
      },
      notdog: {
        "fa-solid": "solid",
        fans: "solid"
      },
      "notdog-duo": {
        "fa-solid": "solid",
        fands: "solid"
      },
      etch: {
        "fa-solid": "solid",
        faes: "solid"
      },
      jelly: {
        "fa-regular": "regular",
        fajr: "regular"
      },
      "jelly-fill": {
        "fa-regular": "regular",
        fajfr: "regular"
      },
      "jelly-duo": {
        "fa-regular": "regular",
        fajdr: "regular"
      },
      chisel: {
        "fa-regular": "regular",
        facr: "regular"
      },
      utility: {
        "fa-semibold": "semibold",
        fausb: "semibold"
      },
      "utility-duo": {
        "fa-semibold": "semibold",
        faudsb: "semibold"
      },
      "utility-fill": {
        "fa-semibold": "semibold",
        faufsb: "semibold"
      }
    };
  var i = "classic",
    t = "duotone",
    d = "sharp",
    l = "sharp-duotone",
    f = "chisel",
    n = "etch",
    h = "jelly",
    o = "jelly-duo",
    u = "jelly-fill",
    g = "notdog",
    s = "notdog-duo",
    y = "slab",
    m = "slab-press",
    e = "thumbprint",
    p = "utility",
    a = "utility-duo",
    w = "utility-fill",
    x = "whiteboard",
    b = "Classic",
    c = "Duotone",
    I = "Sharp",
    F = "Sharp Duotone",
    v = "Chisel",
    S = "Etch",
    A = "Jelly",
    P = "Jelly Duo",
    j = "Jelly Fill",
    B = "Notdog",
    N = "Notdog Duo",
    k = "Slab",
    D = "Slab Press",
    T = "Thumbprint",
    C = "Utility",
    W = "Utility Duo",
    K = "Utility Fill",
    R = "Whiteboard",
    dt = (_dt = {}, _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_dt, i, b), t, c), d, I), l, F), f, v), n, S), h, A), o, P), u, j), g, B), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_dt, s, N), y, k), m, D), e, T), p, C), a, W), w, K), x, R));
  var gt = {
      classic: {
        900: "fas",
        400: "far",
        normal: "far",
        300: "fal",
        100: "fat"
      },
      duotone: {
        900: "fad",
        400: "fadr",
        300: "fadl",
        100: "fadt"
      },
      sharp: {
        900: "fass",
        400: "fasr",
        300: "fasl",
        100: "fast"
      },
      "sharp-duotone": {
        900: "fasds",
        400: "fasdr",
        300: "fasdl",
        100: "fasdt"
      },
      slab: {
        400: "faslr"
      },
      "slab-press": {
        400: "faslpr"
      },
      whiteboard: {
        600: "fawsb"
      },
      thumbprint: {
        300: "fatl"
      },
      notdog: {
        900: "fans"
      },
      "notdog-duo": {
        900: "fands"
      },
      etch: {
        900: "faes"
      },
      chisel: {
        400: "facr"
      },
      jelly: {
        400: "fajr"
      },
      "jelly-fill": {
        400: "fajfr"
      },
      "jelly-duo": {
        400: "fajdr"
      },
      utility: {
        600: "fausb"
      },
      "utility-duo": {
        600: "faudsb"
      },
      "utility-fill": {
        600: "faufsb"
      }
    };
  var _t = {
      chisel: {
        regular: "facr"
      },
      classic: {
        brands: "fab",
        light: "fal",
        regular: "far",
        solid: "fas",
        thin: "fat"
      },
      duotone: {
        light: "fadl",
        regular: "fadr",
        solid: "fad",
        thin: "fadt"
      },
      etch: {
        solid: "faes"
      },
      jelly: {
        regular: "fajr"
      },
      "jelly-duo": {
        regular: "fajdr"
      },
      "jelly-fill": {
        regular: "fajfr"
      },
      notdog: {
        solid: "fans"
      },
      "notdog-duo": {
        solid: "fands"
      },
      sharp: {
        light: "fasl",
        regular: "fasr",
        solid: "fass",
        thin: "fast"
      },
      "sharp-duotone": {
        light: "fasdl",
        regular: "fasdr",
        solid: "fasds",
        thin: "fasdt"
      },
      slab: {
        regular: "faslr"
      },
      "slab-press": {
        regular: "faslpr"
      },
      thumbprint: {
        light: "fatl"
      },
      utility: {
        semibold: "fausb"
      },
      "utility-duo": {
        semibold: "faudsb"
      },
      "utility-fill": {
        semibold: "faufsb"
      },
      whiteboard: {
        semibold: "fawsb"
      }
    };
  var qt = {
      kit: {
        fak: "kit",
        "fa-kit": "kit"
      },
      "kit-duotone": {
        fakd: "kit-duotone",
        "fa-kit-duotone": "kit-duotone"
      }
    },
    Ht = ["kit"];
  var L = "kit",
    r = "kit-duotone",
    U = "Kit",
    J = "Kit Duotone",
    $t = _defineProperty(_defineProperty({}, L, U), r, J);
  var ol = {
    kit: {
      "fa-kit": "fak"
    },
    "kit-duotone": {
      "fa-kit-duotone": "fakd"
    }
  };
  var fl = {
      kit: {
        fak: "fa-kit"
      },
      "kit-duotone": {
        fakd: "fa-kit-duotone"
      }
    };
  var ul = {
      kit: {
        kit: "fak"
      },
      "kit-duotone": {
        "kit-duotone": "fakd"
      }
    };

  var _ml;
  var l$1 = {
      GROUP: "duotone-group",
      SWAP_OPACITY: "swap-opacity",
      PRIMARY: "primary",
      SECONDARY: "secondary"
    };
  var n$1 = "classic",
    o$1 = "duotone",
    u$1 = "sharp",
    s$1 = "sharp-duotone",
    h$1 = "chisel",
    g$1 = "etch",
    y$1 = "jelly",
    e$1 = "jelly-duo",
    m$1 = "jelly-fill",
    p$1 = "notdog",
    a$1 = "notdog-duo",
    w$1 = "slab",
    b$1 = "slab-press",
    r$1 = "thumbprint",
    c$1 = "utility",
    i$1 = "utility-duo",
    x$1 = "utility-fill",
    I$1 = "whiteboard",
    F$1 = "Classic",
    v$1 = "Duotone",
    S$1 = "Sharp",
    A$1 = "Sharp Duotone",
    P$1 = "Chisel",
    j$1 = "Etch",
    B$1 = "Jelly",
    N$1 = "Jelly Duo",
    k$1 = "Jelly Fill",
    D$1 = "Notdog",
    C$1 = "Notdog Duo",
    T$1 = "Slab",
    L$1 = "Slab Press",
    W$1 = "Thumbprint",
    R$1 = "Utility",
    K$1 = "Utility Duo",
    U$1 = "Utility Fill",
    J$1 = "Whiteboard",
    ml$1 = (_ml = {}, _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_ml, n$1, F$1), o$1, v$1), u$1, S$1), s$1, A$1), h$1, P$1), g$1, j$1), y$1, B$1), e$1, N$1), m$1, k$1), p$1, D$1), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_ml, a$1, C$1), w$1, T$1), b$1, L$1), r$1, W$1), c$1, R$1), i$1, K$1), x$1, U$1), I$1, J$1));
  var E$1 = "kit",
    d$1 = "kit-duotone",
    _$1 = "Kit",
    M$1 = "Kit Duotone",
    rt$1 = _defineProperty(_defineProperty({}, E$1, _$1), d$1, M$1);
  var $t$1 = {
      classic: {
        "fa-brands": "fab",
        "fa-duotone": "fad",
        "fa-light": "fal",
        "fa-regular": "far",
        "fa-solid": "fas",
        "fa-thin": "fat"
      },
      duotone: {
        "fa-regular": "fadr",
        "fa-light": "fadl",
        "fa-thin": "fadt"
      },
      sharp: {
        "fa-solid": "fass",
        "fa-regular": "fasr",
        "fa-light": "fasl",
        "fa-thin": "fast"
      },
      "sharp-duotone": {
        "fa-solid": "fasds",
        "fa-regular": "fasdr",
        "fa-light": "fasdl",
        "fa-thin": "fasdt"
      },
      slab: {
        "fa-regular": "faslr"
      },
      "slab-press": {
        "fa-regular": "faslpr"
      },
      whiteboard: {
        "fa-semibold": "fawsb"
      },
      thumbprint: {
        "fa-light": "fatl"
      },
      notdog: {
        "fa-solid": "fans"
      },
      "notdog-duo": {
        "fa-solid": "fands"
      },
      etch: {
        "fa-solid": "faes"
      },
      jelly: {
        "fa-regular": "fajr"
      },
      "jelly-fill": {
        "fa-regular": "fajfr"
      },
      "jelly-duo": {
        "fa-regular": "fajdr"
      },
      chisel: {
        "fa-regular": "facr"
      },
      utility: {
        "fa-semibold": "fausb"
      },
      "utility-duo": {
        "fa-semibold": "faudsb"
      },
      "utility-fill": {
        "fa-semibold": "faufsb"
      }
    },
    z = {
      classic: ["fas", "far", "fal", "fat", "fad"],
      duotone: ["fadr", "fadl", "fadt"],
      sharp: ["fass", "fasr", "fasl", "fast"],
      "sharp-duotone": ["fasds", "fasdr", "fasdl", "fasdt"],
      slab: ["faslr"],
      "slab-press": ["faslpr"],
      whiteboard: ["fawsb"],
      thumbprint: ["fatl"],
      notdog: ["fans"],
      "notdog-duo": ["fands"],
      etch: ["faes"],
      jelly: ["fajr"],
      "jelly-fill": ["fajfr"],
      "jelly-duo": ["fajdr"],
      chisel: ["facr"],
      utility: ["fausb"],
      "utility-duo": ["faudsb"],
      "utility-fill": ["faufsb"]
    },
    Ht$1 = {
      classic: {
        fab: "fa-brands",
        fad: "fa-duotone",
        fal: "fa-light",
        far: "fa-regular",
        fas: "fa-solid",
        fat: "fa-thin"
      },
      duotone: {
        fadr: "fa-regular",
        fadl: "fa-light",
        fadt: "fa-thin"
      },
      sharp: {
        fass: "fa-solid",
        fasr: "fa-regular",
        fasl: "fa-light",
        fast: "fa-thin"
      },
      "sharp-duotone": {
        fasds: "fa-solid",
        fasdr: "fa-regular",
        fasdl: "fa-light",
        fasdt: "fa-thin"
      },
      slab: {
        faslr: "fa-regular"
      },
      "slab-press": {
        faslpr: "fa-regular"
      },
      whiteboard: {
        fawsb: "fa-semibold"
      },
      thumbprint: {
        fatl: "fa-light"
      },
      notdog: {
        fans: "fa-solid"
      },
      "notdog-duo": {
        fands: "fa-solid"
      },
      etch: {
        faes: "fa-solid"
      },
      jelly: {
        fajr: "fa-regular"
      },
      "jelly-fill": {
        fajfr: "fa-regular"
      },
      "jelly-duo": {
        fajdr: "fa-regular"
      },
      chisel: {
        facr: "fa-regular"
      },
      utility: {
        fausb: "fa-semibold"
      },
      "utility-duo": {
        faudsb: "fa-semibold"
      },
      "utility-fill": {
        faufsb: "fa-semibold"
      }
    },
    G$1 = ["solid", "regular", "light", "thin", "duotone", "brands", "semibold"],
    O$1 = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
    V$1 = O$1.concat([11, 12, 13, 14, 15, 16, 17, 18, 19, 20]),
    $$1 = ["aw", "fw", "pull-left", "pull-right"],
    to = [].concat(_toConsumableArray(Object.keys(z)), G$1, $$1, ["2xs", "xs", "sm", "lg", "xl", "2xl", "beat", "border", "fade", "beat-fade", "bounce", "flip-both", "flip-horizontal", "flip-vertical", "flip", "inverse", "layers", "layers-bottom-left", "layers-bottom-right", "layers-counter", "layers-text", "layers-top-left", "layers-top-right", "li", "pull-end", "pull-start", "pulse", "rotate-180", "rotate-270", "rotate-90", "rotate-by", "shake", "spin-pulse", "spin-reverse", "spin", "stack-1x", "stack-2x", "stack", "ul", "width-auto", "width-fixed", l$1.GROUP, l$1.SWAP_OPACITY, l$1.PRIMARY, l$1.SECONDARY]).concat(O$1.map(function (t) {
      return "".concat(t, "x");
    })).concat(V$1.map(function (t) {
      return "w-".concat(t);
    }));

  var NAMESPACE_IDENTIFIER = '___FONT_AWESOME___';
  var PRODUCTION = function () {
    try {
      return "production" === 'production';
    } catch (e$$1) {
      return false;
    }
  }();
  function familyProxy(obj) {
    // Defaults to the classic family if family is not available
    return new Proxy(obj, {
      get: function get(target, prop) {
        return prop in target ? target[prop] : target[i];
      }
    });
  }
  var _PREFIX_TO_STYLE = _objectSpread2({}, q);

  // We changed FACSSClassesToStyleId in the icons repo to be canonical and as such, "classic" family does not have any
  // duotone styles.  But we do still need duotone in _PREFIX_TO_STYLE below, so we are manually adding
  // {'fa-duotone': 'duotone'}
  _PREFIX_TO_STYLE[i] = _objectSpread2(_objectSpread2(_objectSpread2(_objectSpread2({}, {
    'fa-duotone': 'duotone'
  }), q[i]), qt['kit']), qt['kit-duotone']);
  var PREFIX_TO_STYLE = familyProxy(_PREFIX_TO_STYLE);
  var _STYLE_TO_PREFIX = _objectSpread2({}, _t);

  // We changed FAStyleIdToShortPrefixId in the icons repo to be canonical and as such, "classic" family does not have any
  // duotone styles.  But we do still need duotone in _STYLE_TO_PREFIX below, so we are manually adding {duotone: 'fad'}
  _STYLE_TO_PREFIX[i] = _objectSpread2(_objectSpread2(_objectSpread2(_objectSpread2({}, {
    duotone: 'fad'
  }), _STYLE_TO_PREFIX[i]), ul['kit']), ul['kit-duotone']);
  var STYLE_TO_PREFIX = familyProxy(_STYLE_TO_PREFIX);
  var _PREFIX_TO_LONG_STYLE = _objectSpread2({}, Ht$1);
  _PREFIX_TO_LONG_STYLE[i] = _objectSpread2(_objectSpread2({}, _PREFIX_TO_LONG_STYLE[i]), fl['kit']);
  var PREFIX_TO_LONG_STYLE = familyProxy(_PREFIX_TO_LONG_STYLE);
  var _LONG_STYLE_TO_PREFIX = _objectSpread2({}, $t$1);
  _LONG_STYLE_TO_PREFIX[i] = _objectSpread2(_objectSpread2({}, _LONG_STYLE_TO_PREFIX[i]), ol['kit']);
  var LONG_STYLE_TO_PREFIX = familyProxy(_LONG_STYLE_TO_PREFIX);
  var _FONT_WEIGHT_TO_PREFIX = _objectSpread2({}, gt);
  var FONT_WEIGHT_TO_PREFIX = familyProxy(_FONT_WEIGHT_TO_PREFIX);
  var RESERVED_CLASSES = [].concat(_toConsumableArray(Ht), _toConsumableArray(to));

  function bunker(fn) {
    try {
      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }
      fn.apply(void 0, args);
    } catch (e) {
      if (!PRODUCTION) {
        throw e;
      }
    }
  }

  var w$2 = WINDOW || {};
  if (!w$2[NAMESPACE_IDENTIFIER]) w$2[NAMESPACE_IDENTIFIER] = {};
  if (!w$2[NAMESPACE_IDENTIFIER].styles) w$2[NAMESPACE_IDENTIFIER].styles = {};
  if (!w$2[NAMESPACE_IDENTIFIER].hooks) w$2[NAMESPACE_IDENTIFIER].hooks = {};
  if (!w$2[NAMESPACE_IDENTIFIER].shims) w$2[NAMESPACE_IDENTIFIER].shims = [];
  var namespace = w$2[NAMESPACE_IDENTIFIER];

  function normalizeIcons(icons) {
    return Object.keys(icons).reduce(function (acc, iconName) {
      var icon = icons[iconName];
      var expanded = !!icon.icon;
      if (expanded) {
        acc[icon.iconName] = icon.icon;
      } else {
        acc[iconName] = icon;
      }
      return acc;
    }, {});
  }
  function defineIcons(prefix, icons) {
    var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    var _params$skipHooks = params.skipHooks,
      skipHooks = _params$skipHooks === void 0 ? false : _params$skipHooks;
    var normalized = normalizeIcons(icons);
    if (typeof namespace.hooks.addPack === 'function' && !skipHooks) {
      namespace.hooks.addPack(prefix, normalizeIcons(icons));
    } else {
      namespace.styles[prefix] = _objectSpread2(_objectSpread2({}, namespace.styles[prefix] || {}), normalized);
    }

    /**
     * Font Awesome 4 used the prefix of `fa` for all icons. With the introduction
     * of new styles we needed to differentiate between them. Prefix `fa` is now an alias
     * for `fas` so we'll ease the upgrade process for our users by automatically defining
     * this as well.
     */
    if (prefix === 'fas') {
      defineIcons('fa', icons);
    }
  }

  var icons = {
    "0": [320, 512, [], "30", ["", "M0 192C0 103.6 71.6 32 160 32s160 71.6 160 160l0 128c0 88.4-71.6 160-160 160S0 408.4 0 320L0 192zM160 64C89.3 64 32 121.3 32 192l0 128c0 70.7 57.3 128 128 128s128-57.3 128-128l0-128c0-70.7-57.3-128-128-128z"]],
    "1": [256, 512, [], "31", ["", "M16 32C7.2 32 0 39.2 0 48S7.2 64 16 64l96 0 0 384-96 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l224 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-96 0 0-400c0-8.8-7.2-16-16-16L16 32z"]],
    "2": [384, 512, [], "32", ["", "M48 48c0-8.8 7.2-16 16-16l197.9 0c54.2 0 98.1 43.9 98.1 98.1 0 39.1-23.2 74.5-59.1 90L131.5 293.3C90.5 311 64 351.4 64 396.1l0 51.9 272 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L48 480c-8.8 0-16-7.2-16-16l0-67.9c0-57.4 34.1-109.4 86.8-132.2l169.3-73.2c24.2-10.5 39.8-34.3 39.8-60.6 0-36.5-29.6-66.1-66.1-66.1L64 64c-8.8 0-16-7.2-16-16z"]],
    "3": [320, 512, [], "33", ["", "M64 272c-8.8 0-16-7.2-16-16s7.2-16 16-16l136 0c48.6 0 88-39.4 88-88s-39.4-88-88-88L16 64C7.2 64 0 56.8 0 48S7.2 32 16 32l184 0c66.3 0 120 53.7 120 120 0 44.5-24.2 83.3-60.1 104 35.9 20.7 60.1 59.5 60.1 104 0 66.3-53.7 120-120 120L16 480c-8.8 0-16-7.2-16-16s7.2-16 16-16l184 0c48.6 0 88-39.4 88-88s-39.4-88-88-88L64 272z"]],
    "4": [384, 512, [], "34", ["", "M32 48c0-8.8-7.2-16-16-16S0 39.2 0 48L0 288c0 35.3 28.7 64 64 64l224 0 0 112c0 8.8 7.2 16 16 16s16-7.2 16-16l0-112 48 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-48 0 0-272c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 272-224 0c-17.7 0-32-14.3-32-32L32 48z"]],
    "5": [320, 512, [], "35", ["", "M0 48c0-8.8 7.2-16 16-16l256 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-240 0 0 160 160 0c70.7 0 128 57.3 128 128S262.7 480 192 480L16 480c-8.8 0-16-7.2-16-16s7.2-16 16-16l176 0c53 0 96-43 96-96s-43-96-96-96L16 256c-8.8 0-16-7.2-16-16L0 48z"]],
    "6": [384, 512, [], "36", ["", "M272 32c8.8 0 16 7.2 16 16s-7.2 16-16 16L152 64C94.6 64 48 110.6 48 168l0 88.4C72.9 226.8 110.3 208 152 208l64 0c75.1 0 136 60.9 136 136S291.1 480 216 480l-64 0c-75.1 0-136-60.9-136-136 0-2 0-4 .1-6-.1-.7-.1-1.3-.1-2l0-168C16 92.9 76.9 32 152 32l120 0zM48 344c0 57.4 46.6 104 104 104l64 0c57.4 0 104-46.6 104-104S273.4 240 216 240l-64 0C94.6 240 48 286.6 48 344z"]],
    "7": [320, 512, [], "37", ["", "M0 48c0-8.8 7.2-16 16-16l288 0c5.8 0 11.1 3.1 14 8.2s2.7 11.3-.3 16.2l-256 416c-4.6 7.5-14.5 9.9-22 5.2s-9.9-14.5-5.2-22L275.4 64 16 64C7.2 64 0 56.8 0 48z"]],
    "8": [320, 512, [], "38", ["", "M304 152c0-66.3-53.7-120-120-120l-48 0C69.7 32 16 85.7 16 152 16 193.4 36.9 229.9 68.8 251.4 28.1 270.6 0 312 0 360 0 426.3 53.7 480 120 480l80 0c66.3 0 120-53.7 120-120 0-48-28.1-89.4-68.8-108.6 31.9-21.6 52.8-58.1 52.8-99.4zM184.1 272l15.9 0c48.6 0 88 39.4 88 88s-39.4 88-88 88l-80 0c-48.6 0-88-39.4-88-88s39.4-88 88-88l64.1 0zm0-32l-48.1 0c-48.6 0-87.9-39.4-87.9-88 0-48.6 39.4-88 88-88l48 0c48.6 0 88 39.4 88 88 0 48.6-39.4 88-87.9 88z"]],
    "9": [384, 512, [], "39", ["", "M208 320c45.2 0 85.6-20.9 112-53.5l0 77.5c0 57.4-46.6 104-104 104L96 448c-8.8 0-16 7.2-16 16s7.2 16 16 16l120 0c75.1 0 136-60.9 136-136l0-168.1C352 96.4 287.5 32 208 32l-48 0C80.5 32 16 96.5 16 176S80.5 320 160 320l48 0zM320 176c0 61.9-50.1 112-112 112l-48 0C98.1 288 48 237.9 48 176S98.1 64 160 64l48 0c61.9 0 112 50.1 112 112z"]],
    "chess-pawn-piece": [320, 512, ["chess-pawn-alt"], "f444", ["M48 476.5c0 2 1.6 3.5 3.5 3.5l216.9 0c1.5 0 2.7-.9 3.3-2.2l.3-1.4c0-.8-.3-1.6-.8-2.2-15.5-19.4-31.1-38.8-46.6-58.2l-129.2 0-46.6 58.3c-.5 .6-.8 1.4-.8 2.2zM96 128a64 64 0 1 0 128 0 64 64 0 1 0 -128 0zm16.1 256l95.8 0-13.3-160-69.1 0-13.3 160z", "M160 32c53 0 96 43 96 96 0 24.6-9.4 47-24.6 64l.6 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-5.3 0 13.3 160 56.2 70.3c5 6.3 7.8 14.1 7.8 22.2 0 19.6-15.9 35.5-35.5 35.5L51.5 512c-19.6 0-35.5-15.9-35.5-35.5 0-8.1 2.7-15.9 7.8-22.2L80 384 93.3 224 88 224c-8.8 0-16-7.2-16-16s7.2-16 16-16l.6 0c-15.2-17-24.6-39.4-24.6-64 0-53 43-96 96-96zM95.4 416l-46.6 58.3 0 0c-.5 .6-.8 1.4-.8 2.2 0 2 1.6 3.5 3.5 3.5l216.9 0c1.5 0 2.7-.9 3.3-2.2l.3-1.4c0-.8-.3-1.6-.8-2.2l0 0-46.6-58.3-129.2 0zm16.7-32l95.8 0-13.3-160-69.1 0-13.3 160zM160 64a64 64 0 1 0 0 128 64 64 0 1 0 0-128z"]],
    "dollar-sign": [320, 512, [128178, 61781, "dollar", "usd"], "24", ["", "M144 16c0-8.8 7.2-16 16-16s16 7.2 16 16l0 48 80 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L113.9 96C77.5 96 48 125.5 48 161.9 48 194.4 71.6 222 103.7 227l113.8 17.8c49.8 7.8 86.4 50.6 86.4 101 0 56.5-45.8 102.2-102.2 102.2l-25.8 0 0 48c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-48-96 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l153.8 0c38.8 0 70.2-31.4 70.2-70.2 0-34.6-25.2-64-59.4-69.4L98.8 258.6C51.1 251.2 16 210.1 16 161.9 16 107.8 59.8 64 113.9 64l30.1 0 0-48z"]],
    "layer-plus": [512, 512, ["layer-group-plus"], "f5ff", ["M43.1 224l202.9 93.8c6.4 3 13.7 3 20.1 0L468.9 224 266.1 130.2c-6.4-3-13.8-3-20.1 0L43.1 224zm0 160l202.9 93.8c6.4 3 13.7 3 20.1 0L468.9 384 391.2 348c-30.5 14.1-61 28.2-91.6 42.3-27.7 12.8-59.6 12.8-87.3 0-30.5-14.1-61-28.2-91.6-42.3L43.1 384z", "M448-16l0 48 48 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-48 0 0 48c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-48-48 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l48 0 0-48c0-8.8 7.2-16 16-16s16 7.2 16 16zM245.9 130.2L43.1 224 245.9 317.7c6.4 3 13.7 3 20.1 0L468.9 224 266.1 130.2c-6.4-3-13.8-3-20.1 0zm-13.4-29c14.9-6.9 32.1-6.9 47 0l218.6 101c8.5 3.9 13.9 12.4 13.9 21.8s-5.4 17.9-13.9 21.8l-218.6 101c-14.9 6.9-32.1 6.9-47 0L13.9 245.8C5.4 241.8 0 233.3 0 224s5.4-17.9 13.9-21.8l218.6-101zM13.9 362.2l68.7-31.8 38.1 17.6-77.7 35.9 202.9 93.8c6.4 3 13.7 3 20.1 0l202.9-93.8-77.7-35.9 38.1-17.6 68.7 31.8c8.5 3.9 13.9 12.4 13.9 21.8s-5.4 17.9-13.9 21.8l-218.6 101c-14.9 6.9-32.1 6.9-47 0L13.9 405.8C5.4 401.8 0 393.3 0 384s5.4-17.9 13.9-21.8z"]],
    "grid-4": [448, 512, [], "e198", ["M24 56l32 0 0 32-32 0 0-32zm0 122.7l32 0 0 32-32 0 0-32zm0 122.7l32 0 0 32-32 0 0-32zM24 424l32 0 0 32-32 0 0-32zM146.7 56l32 0 0 32-32 0 0-32zm0 122.7l32 0 0 32-32 0 0-32zm0 122.7l32 0 0 32-32 0 0-32zm0 122.7l32 0 0 32-32 0 0-32zM269.3 56l32 0 0 32-32 0 0-32zm0 122.7l32 0 0 32-32 0 0-32zm0 122.7l32 0 0 32-32 0 0-32zm0 122.7l32 0 0 32-32 0 0-32zM392 56l32 0 0 32-32 0 0-32zm0 122.7l32 0 0 32-32 0 0-32zm0 122.7l32 0 0 32-32 0 0-32zM392 424l32 0 0 32-32 0 0-32z", "M24 56l32 0 0 32-32 0 0-32zM16 32C7.2 32 0 39.2 0 48L0 96c0 8.8 7.2 16 16 16l48 0c8.8 0 16-7.2 16-16l0-48c0-8.8-7.2-16-16-16L16 32zm8 146.7l32 0 0 32-32 0 0-32zm-8-24c-8.8 0-16 7.2-16 16l0 48c0 8.8 7.2 16 16 16l48 0c8.8 0 16-7.2 16-16l0-48c0-8.8-7.2-16-16-16l-48 0zm8 146.7l32 0 0 32-32 0 0-32zm-8-24c-8.8 0-16 7.2-16 16l0 48c0 8.8 7.2 16 16 16l48 0c8.8 0 16-7.2 16-16l0-48c0-8.8-7.2-16-16-16l-48 0zM24 456l0-32 32 0 0 32-32 0zM0 416l0 48c0 8.8 7.2 16 16 16l48 0c8.8 0 16-7.2 16-16l0-48c0-8.8-7.2-16-16-16l-48 0c-8.8 0-16 7.2-16 16zm146.7 40l0-32 32 0 0 32-32 0zm-24-40l0 48c0 8.8 7.2 16 16 16l48 0c8.8 0 16-7.2 16-16l0-48c0-8.8-7.2-16-16-16l-48 0c-8.8 0-16 7.2-16 16zm146.7 8l32 0 0 32-32 0 0-32zm-8-24c-8.8 0-16 7.2-16 16l0 48c0 8.8 7.2 16 16 16l48 0c8.8 0 16-7.2 16-16l0-48c0-8.8-7.2-16-16-16l-48 0zM392 456l0-32 32 0 0 32-32 0zm-24-40l0 48c0 8.8 7.2 16 16 16l48 0c8.8 0 16-7.2 16-16l0-48c0-8.8-7.2-16-16-16l-48 0c-8.8 0-16 7.2-16 16zM146.7 333.3l0-32 32 0 0 32-32 0zm-24-40l0 48c0 8.8 7.2 16 16 16l48 0c8.8 0 16-7.2 16-16l0-48c0-8.8-7.2-16-16-16l-48 0c-8.8 0-16 7.2-16 16zm146.7 8l32 0 0 32-32 0 0-32zm-8-24c-8.8 0-16 7.2-16 16l0 48c0 8.8 7.2 16 16 16l48 0c8.8 0 16-7.2 16-16l0-48c0-8.8-7.2-16-16-16l-48 0zm130.7 56l0-32 32 0 0 32-32 0zm-24-40l0 48c0 8.8 7.2 16 16 16l48 0c8.8 0 16-7.2 16-16l0-48c0-8.8-7.2-16-16-16l-48 0c-8.8 0-16 7.2-16 16zM146.7 210.7l0-32 32 0 0 32-32 0zm-24-40l0 48c0 8.8 7.2 16 16 16l48 0c8.8 0 16-7.2 16-16l0-48c0-8.8-7.2-16-16-16l-48 0c-8.8 0-16 7.2-16 16zm146.7 8l32 0 0 32-32 0 0-32zm-8-24c-8.8 0-16 7.2-16 16l0 48c0 8.8 7.2 16 16 16l48 0c8.8 0 16-7.2 16-16l0-48c0-8.8-7.2-16-16-16l-48 0zm130.7 56l0-32 32 0 0 32-32 0zm-24-40l0 48c0 8.8 7.2 16 16 16l48 0c8.8 0 16-7.2 16-16l0-48c0-8.8-7.2-16-16-16l-48 0c-8.8 0-16 7.2-16 16zM146.7 88l0-32 32 0 0 32-32 0zm-24-40l0 48c0 8.8 7.2 16 16 16l48 0c8.8 0 16-7.2 16-16l0-48c0-8.8-7.2-16-16-16l-48 0c-8.8 0-16 7.2-16 16zm146.7 8l32 0 0 32-32 0 0-32zm-8-24c-8.8 0-16 7.2-16 16l0 48c0 8.8 7.2 16 16 16l48 0c8.8 0 16-7.2 16-16l0-48c0-8.8-7.2-16-16-16l-48 0zM392 88l0-32 32 0 0 32-32 0zM368 48l0 48c0 8.8 7.2 16 16 16l48 0c8.8 0 16-7.2 16-16l0-48c0-8.8-7.2-16-16-16l-48 0c-8.8 0-16 7.2-16 16z"]],
    "dog": [576, 512, [128021], "f6d3", ["M96 192l0 272c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-112c0-5.4 2.7-10.5 7.3-13.4s10.3-3.4 15.2-1.2l20 8.9c29 12.9 62 12.9 91 0l20-8.9 1.9-.7c4.5-1.4 9.4-.7 13.3 1.9 4.5 3 7.3 8 7.3 13.4l0 112c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-235.2-86-36.8-218 0zm234.7-27.7l77.2 33.1 8.8-26.5 1-2.3c2.7-5.2 8.2-8.6 14.2-8.6l48 0c35.3 0 64-28.7 64-64l0-32-48 0c-4.2 0-8.3-1.7-11.3-4.7L471.4 46.1c-9-9-21.2-14.1-33.9-14.1l-79.2 0-27.6 132.3zM452 80a20 20 0 1 1 -40 0 20 20 0 1 1 40 0z", "M355.3-31.7C362.8-30.1 368-23.4 368-16l-.3 3.2-2.7 12.7 72.5 0c21.2 0 41.6 8.4 56.6 23.4l8.6 8.6 49.4 0c13.3 0 24 10.7 24 24l0 40c0 53-43 96-96 96l-36.5 0-11.5 34.6 0 237.4c0 26.5-21.5 48-48 48l-32 0c-26.5 0-48-21.5-48-48l0-87.5c-35.8 15.1-76.2 15.1-112 0l0 87.5c0 26.5-21.5 48-48 48l-32 0c-26.5 0-48-21.5-48-48l0-273.6C27.5 183 0 150.7 0 112 0 103.2 7.2 96 16 96s16 7.2 16 16c0 24.8 18.9 45.3 43.1 47.8l4.9 .2 219 0 37.3-179.2 1-3.1c2.9-6.8 10.4-10.9 17.9-9.3zM96 464c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-112c0-5.4 2.7-10.5 7.3-13.4s10.3-3.4 15.2-1.2l20 8.9c29 12.9 62 12.9 91 0l20-8.9 1.9-.7c4.5-1.4 9.4-.7 13.3 1.9 4.5 3 7.3 8 7.3 13.4l0 112c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-235.2-86-36.8-218 0 0 272zM330.7 164.3l77.2 33.1 8.8-26.5 1-2.3c2.7-5.2 8.2-8.6 14.2-8.6l48 0c35.3 0 64-28.7 64-64l0-32-48 0c-4.2 0-8.3-1.7-11.3-4.7L471.4 46.1c-9-9-21.2-14.1-33.9-14.1l-79.2 0-27.6 132.3zM432 100a20 20 0 1 1 0-40 20 20 0 1 1 0 40z"]],
    "truck-moving": [640, 512, [], "f4df", ["M32 96l0 260.1c15.2-12.6 34.7-20.1 56-20.1 29.8 0 56.1 14.8 72 37.4 15.9-22.6 42.2-37.4 72-37.4 45.9 0 83.6 35.1 87.6 80l112.7 0c1.4-15.8 7-30.3 15.6-42.6L448 96c0-17.6-14.3-31.9-31.9-32-117.5 0-234.8 0-352.1 0-17.7 0-32 14.3-32 32zM480 288l0 57.6c12-6.1 25.6-9.6 40-9.6 39.9 0 73.5 26.5 84.4 62.8 2.3-4.4 3.6-9.5 3.6-14.8l0-96-128 0z", "M64 64l352 0c17.7 0 32 14.3 32 32l0 277.4c-8.6 12.3-14.2 26.8-15.6 42.6l-112.7 0c-4-44.9-41.7-80-87.6-80-29.8 0-56.1 14.8-72 37.4-15.9-22.6-42.2-37.4-72-37.4-21.3 0-40.8 7.5-56 20.1L32 96c0-17.7 14.3-32 32-32zM0 384l0 40c0 48.6 39.4 88 88 88 29.8 0 56.1-14.8 72-37.4 15.9 22.6 42.2 37.4 72 37.4 40.3 0 74.2-27.1 84.7-64l118.6 0c10.4 36.9 44.4 64 84.7 64 43 0 78.9-30.9 86.5-71.7 20-10.8 33.5-32 33.5-56.3l0-156.1c0-17-6.7-33.3-18.7-45.3l-35.9-35.9c-12-12-28.3-18.7-45.3-18.7l-60.1 0 0-32c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 384zM480 160l60.1 0c8.5 0 16.6 3.4 22.6 9.4l35.9 35.9c6 6 9.4 14.1 9.4 22.6l0 28.1-128 0 0-96zM608 288l0 96c0 5.4-1.3 10.4-3.6 14.8-10.8-36.3-44.5-62.8-84.4-62.8-14.4 0-28 3.5-40 9.6l0-57.6 128 0zM88 368a56 56 0 1 1 0 112 56 56 0 1 1 0-112zm376 56a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zM232 368a56 56 0 1 1 0 112 56 56 0 1 1 0-112z"]],
    "rotate": [512, 512, [128260, "sync-alt"], "f2f1", ["M32 368L32 468.7 132.8 368 32 368zM379.4 144l100.8 0 0-100.7-100.8 100.7z", "M480.2 43.3l-100.8 100.7 100.8 0 0-100.7zm32 108.7c0 13.3-10.7 24-24 24l-128.1 0c-9.7 0-18.5-5.8-22.2-14.8s-1.7-19.3 5.2-26.2l53.5-53.5c-88-71-217.2-65.7-298.9 16.1-39.9 39.9-61.6 91.2-65.1 143.5-.6 8.8-8.2 15.5-17 14.9S.1 247.8 .7 238.9c4-59.7 28.8-118.3 74.4-164 94.3-94.3 243.7-99.6 344.3-16.2L471.2 7c6.9-6.9 17.2-8.9 26.2-5.2S512.2 14.3 512.2 24l0 128zM479.6 270.9c.6-8.8 8.2-15.5 17-14.9s15.5 8.2 14.9 17c-4 59.7-28.8 118.3-74.4 164-94.3 94.3-243.7 99.6-344.3 16.2L41 505c-6.9 6.9-17.2 8.9-26.2 5.2S0 497.7 0 488L0 360c0-13.3 10.7-24 24-24l128.1 0c9.7 0 18.5 5.8 22.2 14.8s1.7 19.3-5.2 26.2l-53.5 53.5c88 71 217.2 65.7 298.9-16.1 39.9-39.9 61.6-91.2 65.1-143.4zM32 368L32 468.7 132.8 368 32 368z"]],
    "arrow-u-turn-up-left": [512, 512, [], "e7ed", ["", "M0 128c0-4.2 1.7-8.3 4.7-11.3l128-128c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6L54.6 112 328 112c101.6 0 184 82.4 184 184S429.6 480 328 480l-248 0-3.2-.3c-7.3-1.5-12.8-8-12.8-15.7s5.5-14.2 12.8-15.7l3.2-.3 248 0c83.9 0 152-68.1 152-152S412 144 328 144l-273.4 0 100.7 100.7 2.1 2.5c4.1 6.2 3.4 14.7-2.1 20.1s-13.9 6.2-20.1 2.1l-2.5-2.1-128-128c-3-3-4.7-7.1-4.7-11.3z"]],
    "keyboard-brightness": [640, 512, [], "e1c0", ["", "M115.3 172.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l88 88c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-88-88zM304 224c0 8.8 7.2 16 16 16s16-7.2 16-16l0-128c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 128zm132.7 36.7c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l88-88c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-88 88zM0 400c0 8.8 7.2 16 16 16l96 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-96 0c-8.8 0-16 7.2-16 16zm208-16c-8.8 0-16 7.2-16 16s7.2 16 16 16l224 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-224 0zm320 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l96 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-96 0z"]],
    "tent-double-peak": [576, 512, [], "e627", ["M32 189.7l0 34.3 512 0 0-34.3c0-5.6-3.3-12.3-10.7-16.9-32-19.7-74.2-52.2-108.7-101.1-26.8 30-74.2 70.8-136.7 70.8S178.1 101.8 151.3 71.7c-34.4 48.9-76.7 81.4-108.7 101.1-7.3 4.5-10.7 11.2-10.7 16.9zM32 256l0 192c0 17.7 14.3 32 32 32l192 0 0-224-224 0zm267.4 0l126 224 86.6 0c17.7 0 32-14.3 32-32l0-192-244.6 0z", "M442.2 40.4c-6.8-10.8-23.6-11.6-31.6-1.6-22.6 28.4-66.3 71.8-122.6 71.8S188 67.2 165.4 38.7c-7.9-10-24.8-9.1-31.6 1.6-32.5 51.6-75.6 85.3-107.9 105.2-15.5 9.5-25.9 25.9-25.9 44.1L0 448c0 35.3 28.7 64 64 64l448 0c35.3 0 64-28.7 64-64l0-258.3c0-18.2-10.4-34.6-25.9-44.1-32.3-19.9-75.4-53.6-107.9-105.2zm91.2 132.5c7.3 4.5 10.7 11.2 10.7 16.9l0 34.3-512 0 0-34.3c0-5.6 3.3-12.3 10.7-16.9 32-19.7 74.2-52.2 108.7-101.1 26.8 30 74.2 70.8 136.7 70.8s109.9-40.8 136.7-70.8c34.4 48.9 76.7 81.4 108.7 101.1zM544 256l0 192c0 17.7-14.3 32-32 32l-86.6 0-126-224 244.6 0zm-288 0l0 224-192 0c-17.7 0-32-14.3-32-32l0-192 224 0zm32 224L288 301.1 388.6 480 288 480z"]],
    "square-minus": [448, 512, [61767, "minus-square"], "f146", ["M32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64C46.3 64 32 78.3 32 96zm80 160c0-8.8 7.2-16 16-16l192 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-192 0c-8.8 0-16-7.2-16-16z", "M64 64C46.3 64 32 78.3 32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM128 240l192 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-192 0c-8.8 0-16-7.2-16-16s7.2-16 16-16z"]],
    "water-arrow-up": [512, 512, ["water-rise"], "f775", ["M0 357.9c0 1 .1 2 .3 2.9 1.6 8.7 9.9 14.5 18.6 12.9 24.9-4.5 48-17.5 68-31.8 26-18.6 61.1-18.6 87.1 0 25.6 18.3 52.9 34.1 82 34.1s56.4-15.8 82-34.1c26-18.6 61.1-18.6 87.1 0 20 14.3 43.1 27.3 68 31.8 8.7 1.6 17-4.2 18.6-12.9 .1-.8 .2-1.6 .3-2.4l0 127.1c-.2-7.4-5.6-13.9-13.1-15.3-18.1-3.3-36.7-13.2-55.1-26.4-37.1-26.5-87.1-26.5-124.3 0-25.3 18.1-45.3 28.1-63.5 28.1s-38.1-10.1-63.5-28.1c-37.1-26.5-87.1-26.5-124.3 0-18.5 13.2-37 23.1-55.1 26.4-8 1.4-13.5 8.6-13.1 15.7 0-42.7 0-85.3 0-128.1zm68.3-42c37.1-26.5 87.1-26.5 124.3 0l1 .7c-38.1-27.2-88.1-27.2-125.2-.7zM174 469.9c25.6 18.3 52.9 34.1 82 34.1-28.8 0-55.7-15.4-81.1-33.4-.3-.2-.6-.5-1-.7zm145.5-154c37.1-26.5 87.1-26.5 124.3 0l.8 .6c-37.9-27.1-88-27.1-125.1-.6zm105.7 154c20 14.3 43.1 27.3 68 31.8-24.6-4.5-47.4-17.2-67.2-31.2-.3-.2-.6-.4-.9-.6z", "M272 224c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-169.4-52.7 52.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l80-80c6.2-6.2 16.4-6.2 22.6 0l80 80c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L272 54.6 272 224zM425.1 341.9c-26-18.6-61.1-18.6-87.1 0-25.6 18.3-52.9 34.1-82 34.1s-56.4-15.8-82-34.1c-26-18.6-61.1-18.6-87.1 0-20 14.3-43.1 27.3-68 31.8-8.7 1.6-17-4.2-18.6-12.9s4.2-17 12.9-18.6c18.1-3.3 36.7-13.2 55.1-26.4 37.1-26.5 87.1-26.5 124.3 0 25.3 18.1 45.3 28.1 63.5 28.1s38.1-10.1 63.5-28.1c37.1-26.5 87.1-26.5 124.3 0 18.5 13.2 37 23.1 55.1 26.4 8.7 1.6 14.5 9.9 12.9 18.6s-9.9 14.5-18.6 12.9c-24.9-4.5-48-17.5-68-31.8zm0 128c-26-18.6-61.1-18.6-87.1 0-25.6 18.3-52.9 34.1-82 34.1s-56.4-15.8-82-34.1c-26-18.6-61.1-18.6-87.1 0-20 14.3-43.1 27.3-68 31.8-8.7 1.6-17-4.2-18.6-12.9s4.2-17 12.9-18.6c18.1-3.3 36.7-13.2 55.1-26.4 37.1-26.5 87.1-26.5 124.3 0 25.3 18.1 45.3 28.1 63.5 28.1s38.1-10.1 63.5-28.1c37.1-26.5 87.1-26.5 124.3 0 18.5 13.2 37 23.1 55.1 26.4 8.7 1.6 14.5 9.9 12.9 18.6s-9.9 14.5-18.6 12.9c-24.9-4.5-48-17.5-68-31.8z"]],
    "xmark-to-slot": [576, 512, ["times-to-slot", "vote-nay"], "f771", ["M128 96l0 224c0 17.7 14.3 32 32 32l256 0c17.7 0 32-14.3 32-32l0-224c0-17.7-14.3-32-32-32L160 64c-17.7 0-32 14.3-32 32zm83.2 121.6c-5.3-7.1-3.9-17.1 3.2-22.4s17.1-3.9 22.4 3.2l34 45.3 67.6-108.2c4.7-7.5 14.6-9.8 22-5.1s9.8 14.6 5.1 22l-80 128c-2.8 4.5-7.6 7.3-12.9 7.5s-10.3-2.2-13.5-6.4l-48-64z", "M416 64c17.7 0 32 14.3 32 32l0 224c0 17.7-14.3 32-32 32l-256 0c-17.7 0-32-14.3-32-32l0-224c0-17.7 14.3-32 32-32l256 0zM160 32c-35.3 0-64 28.7-64 64l0 224c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-224c0-35.3-28.7-64-64-64L160 32zM16 288c-8.8 0-16 7.2-16 16L0 416c0 35.3 28.7 64 64 64l448 0c35.3 0 64-28.7 64-64l0-112c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 112c0 17.7-14.3 32-32 32L64 448c-17.7 0-32-14.3-32-32l0-112c0-8.8-7.2-16-16-16zM365.6 152.5c4.7-7.5 2.4-17.4-5.1-22s-17.4-2.4-22 5.1l-67.6 108.2-34-45.3c-5.3-7.1-15.3-8.5-22.4-3.2s-8.5 15.3-3.2 22.4l48 64c3.2 4.2 8.2 6.6 13.5 6.4s10.1-3 12.9-7.5l80-128z"]],
    "sensor-cloud": [576, 512, ["sensor-smoke"], "e02c", ["M96 96c0-17.7 14.3-32 32-32l320 0c17.7 0 32 14.3 32 32l0 162.4c-7.8-1.6-15.8-2.4-24-2.4-10.6 0-20.9 1.4-30.8 4-21.4-12.7-46.5-20-73.2-20-73.9 0-134.7 55.6-143 127.2-18.9 21.9-30.9 49.9-32.7 80.8L128 448c-17.7 0-32-14.3-32-32L96 96zm64 48l0 96c0 8.8 7.2 16 16 16s16-7.2 16-16l0-96c0-8.8-7.2-16-16-16s-16 7.2-16 16zm64 0l0 96c0 8.8 7.2 16 16 16s16-7.2 16-16l0-96c0-8.8-7.2-16-16-16s-16 7.2-16 16z", "M128 64l320 0c17.7 0 32 14.3 32 32l0 162.4c11.3 2.3 22.1 6.2 32 11.4L512 96c0-35.3-28.7-64-64-64L128 32C92.7 32 64 60.7 64 96l0 320c0 35.3 28.7 64 64 64l50.1 0c-1.4-7.8-2.1-15.8-2.1-24 0-2.7 .1-5.4 .2-8L128 448c-17.7 0-32-14.3-32-32L96 96c0-17.7 14.3-32 32-32zm64 80c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 96c0 8.8 7.2 16 16 16s16-7.2 16-16l0-96zm64 0c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 96c0 8.8 7.2 16 16 16s16-7.2 16-16l0-96zm32.7 249.3c-5.5-37.7 25-73.3 63.3-73.3 19.1 0 36.2 8.4 48 21.7 5.3 6 14.3 7.2 21 2.6 7.7-5.2 17-8.3 27-8.3 27.2 0 49.6 23.9 47.9 51.1-.4 7.1 3.9 13.7 10.7 16.1 21.8 7.7 37.4 28.5 37.4 52.9 0 30.9-25.1 56-56 56l-176 0c-30.9 0-56-25.1-56-56 0-19.7 10.1-37 25.5-47 5.2-3.4 8-9.5 7.1-15.7zM352 288c-54.6 0-98 47-95.9 100-19.6 16.1-32.1 40.6-32.1 68 0 48.6 39.4 88 88 88l176 0c48.6 0 88-39.4 88-88 0-34.3-19.7-64-48.3-78.5-3.5-40.4-37.9-73.5-79.7-73.5-11.9 0-23.2 2.6-33.3 7.3-16.8-14.5-38.7-23.3-62.7-23.3z"]],
    "lychee": [512, 512, [], "e824", ["M32.7 280.8c2 5.7 4.2 11.2 6.7 16.7 4.5 10.2 3.9 19.4 2.5 26-2.3 8.3-5.8 16.2-8.9 24.3 5.5 6.6 12 12.2 17.1 19.2 3.7 5.7 5.5 11.6 6.3 16.3 1.1 8.4 .9 16.7 1.2 25.1 10.5 4.9 21.2 8.3 29.6 16.7 8.5 8.4 11.8 19.1 16.8 29.6 8.4 .3 16.8 .1 25.1 1.2 4.8 .8 10.6 2.6 16.3 6.3 6.9 5.1 12.6 11.5 19.2 17.1 8.1-3.1 15.9-6.6 24.3-8.9 6.5-1.4 15.8-2 26 2.5 5.5 2.4 11.1 4.6 16.7 6.7 7.2-5.5 14.2-11.2 22.2-15.7 4.4-2.2 10.3-4.3 17.3-4.7 6.6 0 13.1 1.2 19.6 2.3 2.8 .5 5.6 1 8.4 1.4 4.9-5.5 9.7-11.1 14.9-16.4 5-4.8 15.1-12.3 29.5-12.3l18.7-.5c3-5.2 6.4-11.9 11.3-18.8 6.9-8.7 15-15.6 26.2-17.9 5.9-1.4 11.9-2.7 17.8-4.3 1.6-5.5 3.3-12.7 6.3-20.6 2.3-6.2 7.8-17.1 20.2-23.6 5.1-2.8 10.2-5.6 15.2-8.7-.3-8.8-1-17.4-.4-26.1 .8-6.7 3.3-15.5 10.5-23.3 3.4-3.9 11.9-9.8 12-9.8-3.2-7-6.2-14.1-9.7-21-2.6-6.1-6.1-17.7-1.8-30.9 2.5-7.9 3.6-10.1 3.6-13-.3-4.4-1-7.9-3.7-11.4-7.6-8.6-20.6-13.5-30.8-18.6-24.4-12.1-48.6-24.1-69.1-42.8-18.7-20.4-30.6-44.4-42.7-68.8-2.4-4.8-4.8-9.7-7.3-14.5-3.1-5.9-6.3-12-11.3-16.4-3.5-2.6-7.1-3.4-11.4-3.7-2.9 0-5.1 1.1-13 3.6-13.2 4.3-24.8 .8-30.9-1.8-4.6-2.3-9.2-4.4-13.9-6.5-2.4-1.1-4.8-2.1-7.1-3.2-.1 .2-5.9 8.6-9.8 12-7.8 7.1-16.7 9.6-23.3 10.5-8.7 .6-17.4-.1-26.1-.4-3.1 5-5.9 10.1-8.7 15.2-6.5 12.4-17.3 17.9-23.6 20.3-7.8 3-15.1 4.7-20.6 6.3-1.5 5.6-2.9 11.3-4.2 16.9-2.6 11.3-9.1 19.9-18.1 27-6.9 4.8-13.6 8.2-18.8 11.2L78.1 169c0 14.4-7.5 24.5-12.3 29.5-5.3 5.2-10.9 10-16.4 14.9 .4 2.8 .9 5.6 1.3 8.3 1.1 6.5 2.3 13 2.3 19.6-.3 7-2.5 12.9-4.7 17.3-4.5 7.9-10.2 14.9-15.7 22.2zm103.8 76l8-40c1.1-5.5 5-10 10.3-11.9l2.3-.7 40-8 3.2-.3c7.4 0 14.1 5.3 15.6 12.9s-2.6 15-9.4 17.9l-3.1 .9-29.5 5.9-5.9 29.5-.9 3.1c-2.9 6.8-10.3 10.9-17.9 9.4s-12.8-8.2-12.9-15.6l.3-3.2zm32-160l8-40c1.1-5.5 5-10 10.3-11.9l2.3-.7 40-8 3.2-.3c7.4 0 14.1 5.3 15.6 12.9s-2.6 15-9.4 17.9l-3.1 .9-29.5 5.9-5.9 29.5-.9 3.1c-2.9 6.8-10.3 10.9-17.9 9.4-7.6-1.5-12.8-8.2-12.9-15.6l.3-3.2zm128 128l8-40c1.1-5.5 5-10 10.2-11.9l2.3-.7 40-8 3.2-.3c7.4 0 14.1 5.3 15.6 12.9 1.5 7.6-2.6 15-9.4 17.9l-3.1 .9-29.5 5.9-5.9 29.5-.9 3.1c-2.9 6.8-10.3 10.9-17.9 9.4s-12.8-8.2-12.9-15.6l.3-3.2z", "M234.1-.9c8.6 1.2 16.5 5.1 24.3 9 2.4 1.2 4.9 2.4 7.3 3.6 2.6 1.1 5.6 1.6 8.3 .7 7.4-2.4 15-4.8 22.8-5.2 12.2 0 21.7 3.4 29.4 9.1 7.9 6.4 14 14.3 19 23.1 3.8 7.2 7.4 14.6 11 22 1.8 3.8 3.7 7.6 5.6 11.3l29.8-17.8 .6-.3 .6-.3c21-10.2 43-5.5 56.8 8.4s18.7 35.8 8.4 56.8l-.3 .6-.4 .6-17.9 29.7c3.8 1.9 7.6 3.8 11.4 5.7 7.4 3.6 14.8 7.2 21.9 11 8.9 5.1 16.7 11.1 23.1 19 5.7 7.7 9.1 17.1 9.1 29.4-.3 7.9-2.8 15.4-5.2 22.8-.9 2.7-.4 5.7 .7 8.3 1.1 2.4 2.3 4.8 3.5 7.2 3.9 7.8 7.9 15.7 9 24.3 1.9 13.9-4.6 22.4-15.5 29.7-4.5 3-7.6 5.9-7.6 11.7 0 7.6 2.9 14.3 1 23.1-2.1 9.7-5 16.8-12.1 22.2-4.5 3.6-9.9 6.4-15.2 9.1-4.5 2.3-8.5 4.1-10.3 9.2-2.7 7.2-3.9 14.8-6.6 22-2.6 7.6-8.3 12.9-15.3 16.2-8.2 3.3-16.9 4.9-25.5 6.8-2.1 .4-3.8 1.6-5.2 3.2-5.1 6.4-9.3 14.1-12.9 21.3-4.9 7.7-12.9 11.7-21.6 12.7-7.6 .9-15.4 .7-23.1 .7-2.8 0-5.4 1.5-7.5 3.4-5.5 5.2-10.1 11.4-15.2 17-6.2 6.6-14.7 9-23.4 8.4-8.2-.5-16.3-2.7-24.3-3.8-2.2 0-4.7 1-6.7 2.2-5.2 3.2-11.5 9-18 13.7-6.5 4.6-14.2 5.7-21.7 4.3-8.1-1.9-15.9-5.3-23.5-8.7-3.2-1.4-6.1-1.7-9.5-.5-6.6 2.5-13.9 6.3-21.5 8.5-8.6 2.8-19.1 .8-26.1-5.1-2.2-1.8-4.4-4.2-6.7-6.6-4.3-4.6-8.8-9.5-14-11.1-4.8-.9-9.7-.9-14.6-.8-4.1 0-8.1 0-12.2-.5-9.2-.8-16.7-6.3-21.5-14-4.9-7.9-6-17.8-12.8-24.6s-16.7-7.8-24.6-12.8c-7.6-4.8-13.1-12.3-14-21.5-1.1-8.9 .3-18-1.3-26.8-2.6-7.9-12.6-14.3-17.7-20.7-5.9-6.9-7.9-17.5-5.1-26.1 2.2-7.6 6-14.9 8.5-21.5 1.2-3.4 .9-6.3-.5-9.5-3.4-7.6-6.8-15.4-8.7-23.5-1.4-7.5-.2-15.2 4.3-21.7 4.7-6.6 10.4-12.8 13.7-18 1.3-2 2.3-4.4 2.2-6.7-1.1-8.1-3.3-16.2-3.8-24.3-.5-8.7 1.9-17.1 8.4-23.4 5.6-5.1 11.7-9.7 17-15.2 2-2.1 3.4-4.6 3.4-7.5 0-7.7-.2-15.4 .7-23.1 1.1-8.6 5.1-16.7 12.7-21.6 7.3-3.6 15-7.9 21.3-12.9 2.6-2.4 3.3-5.9 4.1-9.3 1.6-7.3 3.2-14.6 6-21.5 3.2-7 8.6-12.6 16.2-15.2 7.2-2.6 14.8-3.9 22-6.6 2.7-1 5.2-2.6 6.5-5.1 .9-1.7 1.8-3.5 2.7-5.2 2.7-5.3 5.5-10.6 9.1-15.2 5.4-7.1 12.6-10 22.2-12.1 5.6-1.2 10.3-.5 14.9 .2 2.7 .4 5.4 .8 8.2 .8 5.8 0 8.7-3.1 11.7-7.6 7.3-10.8 15.8-17.4 29.7-15.5zm-2.2 32.2c-.1 .2-5.9 8.6-9.8 12-7.8 7.1-16.7 9.6-23.3 10.5-8.7 .6-17.4-.1-26.1-.4-3.1 5-5.9 10.1-8.7 15.2-6.5 12.4-17.3 17.9-23.6 20.3-7.8 3-15.1 4.7-20.6 6.3-1.5 5.6-2.9 11.3-4.2 16.9-2.6 11.3-9.1 19.9-18.1 27-6.9 4.8-13.6 8.2-18.8 11.2L78.1 169c0 14.4-7.5 24.5-12.3 29.5-5.3 5.2-10.9 10-16.4 14.9 .4 2.8 .9 5.6 1.3 8.3 1.1 6.5 2.3 13 2.3 19.6-.3 7-2.5 12.9-4.7 17.3-4.5 7.9-10.2 14.9-15.7 22.2 2 5.7 4.2 11.2 6.7 16.7 4.5 10.2 3.9 19.4 2.5 26-2.3 8.3-5.8 16.2-8.9 24.3 5.5 6.6 12 12.2 17.1 19.2 3.7 5.7 5.5 11.6 6.3 16.3 1.1 8.4 .9 16.7 1.2 25.1 10.5 4.9 21.2 8.3 29.6 16.7 8.5 8.4 11.8 19.1 16.8 29.6 8.4 .3 16.8 .1 25.1 1.2 4.8 .8 10.6 2.6 16.3 6.3 6.9 5.1 12.6 11.5 19.2 17.1 8.1-3.1 15.9-6.6 24.3-8.9 6.5-1.4 15.8-2 26 2.5 5.5 2.4 11.1 4.6 16.7 6.7 7.2-5.5 14.2-11.2 22.2-15.7 4.4-2.2 10.3-4.3 17.3-4.7 6.6 0 13.1 1.2 19.6 2.3 2.8 .5 5.6 1 8.4 1.4 4.9-5.5 9.7-11.1 14.9-16.4 5-4.8 15.1-12.3 29.5-12.3l18.7-.5c3-5.2 6.4-11.9 11.3-18.8 6.9-8.7 15-15.6 26.2-17.9 5.9-1.4 11.9-2.7 17.8-4.3 1.6-5.5 3.3-12.7 6.3-20.6 2.3-6.2 7.8-17.1 20.2-23.6 5.1-2.8 10.2-5.6 15.2-8.7-.3-8.8-1-17.4-.4-26.1 .8-6.7 3.3-15.5 10.5-23.3 3.4-3.9 11.9-9.8 12-9.8-3.2-7-6.2-14.1-9.7-21-2.6-6.1-6.1-17.7-1.8-30.9 2.5-7.9 3.6-10.1 3.6-13-.3-4.4-1-7.9-3.7-11.4-7.6-8.6-20.6-13.5-30.8-18.6-24.4-12.1-48.6-24.1-69.1-42.8-18.7-20.4-30.6-44.4-42.7-68.8-2.4-4.8-4.8-9.7-7.3-14.5-3.1-5.9-6.3-12-11.3-16.4-3.5-2.6-7.1-3.4-11.4-3.7-2.9 0-5.1 1.1-13 3.6-13.2 4.3-24.8 .8-30.9-1.8-4.6-2.3-9.2-4.4-13.9-6.5-2.4-1.1-4.8-2.1-7.1-3.2zM200.3 296c7.4 0 14.1 5.3 15.6 12.9s-2.6 15-9.4 17.9l-3.1 .9-29.5 5.9-5.9 29.5-.9 3.1c-2.9 6.8-10.3 10.9-17.9 9.4s-12.8-8.2-12.9-15.6l.3-3.2 8-40c1.1-5.5 5-10 10.3-11.9l2.3-.7 40-8 3.2-.3zm160-32c7.4 0 14.1 5.3 15.6 12.9 1.5 7.6-2.6 15-9.4 17.9l-3.1 .9-29.5 5.9-5.9 29.5-.9 3.1c-2.9 6.8-10.3 10.9-17.9 9.4s-12.8-8.2-12.9-15.6l.3-3.2 8-40c1.1-5.5 5-10 10.2-11.9l2.3-.7 40-8 3.2-.3zm-128-128c7.4 0 14.1 5.3 15.6 12.9s-2.6 15-9.4 17.9l-3.1 .9-29.5 5.9-5.9 29.5-.9 3.1c-2.9 6.8-10.3 10.9-17.9 9.4-7.6-1.5-12.8-8.2-12.9-15.6l.3-3.2 8-40c1.1-5.5 5-10 10.3-11.9l2.3-.7 40-8 3.2-.3zM427 85.3c-4.2-4.2-11.3-6.5-19.9-2.5l-29.8 17.9c4.4 6.8 9.3 13.3 14.9 19.3 6 5.6 12.5 10.5 19.3 14.9l17.9-29.8c4-8.6 1.8-15.7-2.4-19.8z"]],
    "align-justify": [448, 512, [], "f039", ["", "M16 48C7.2 48 0 55.2 0 64S7.2 80 16 80l416 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L16 48zM0 192c0 8.8 7.2 16 16 16l416 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L16 176c-8.8 0-16 7.2-16 16zM16 304c-8.8 0-16 7.2-16 16s7.2 16 16 16l416 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L16 304zm0 128c-8.8 0-16 7.2-16 16s7.2 16 16 16l416 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L16 432z"]],
    "sunglasses": [576, 512, [128374], "f892", ["M64.1 439.5c9.4 5.4 20.3 8.5 31.9 8.5l64 0c35.3 0 64-28.7 64-64l0-75.3-159.9 130.8zm320 0c9.4 5.4 20.3 8.5 31.9 8.5l64 0c35.3 0 64-28.7 64-64l0-75.3-159.9 130.8z", "M128.3 64C106.8 64 88 78.2 82.1 98.8L37.2 256 224 256c17.7 0 32 14.3 32 32l64 0c0-17.7 14.3-32 32-32l186.8 0-44.9-157.2C488 78.2 469.2 64 447.7 64L416 64c-8.8 0-16-7.2-16-16s7.2-16 16-16l31.7 0c35.7 0 67.1 23.7 76.9 58l48.3 169c2 7.1 3.1 14.5 3.1 22l0 103c0 53-43 96-96 96l-64 0c-53 0-96-43-96-96l0-64-64 0 0 64c0 53-43 96-96 96l-64 0c-53 0-96-43-96-96L0 281c0-7.4 1-14.8 3.1-22L51.4 90c9.8-34.3 41.2-58 76.9-58L160 32c8.8 0 16 7.2 16 16s-7.2 16-16 16l-31.7 0zM518.7 288l-166.7 0 0 96c0 12.1 3.3 23.3 9.1 33L518.7 288zM544 308.7L384.1 439.5c9.4 5.4 20.3 8.5 31.9 8.5l64 0c35.3 0 64-28.7 64-64l0-75.3zM32 288l0 96c0 12.1 3.3 23.3 9.1 33L198.7 288 32 288zM96 448l64 0c35.3 0 64-28.7 64-64l0-75.3-159.9 130.8c9.4 5.4 20.3 8.5 31.9 8.5z"]],
    "cloud-check": [576, 512, [], "e35c", ["M32 336c0 61.9 50.1 112 112 112l304 0c53 0 96-43 96-96 0-41.8-26.8-77.5-64.2-90.6-4.3-1.5-7.8-4.8-9.5-9.1s-1.5-9 .5-13.1c5.9-11.8 9.2-25.1 9.2-39.2 0-48.6-39.4-88-88-88-13.6 0-26.5 3.1-37.9 8.5-7.2 3.5-15.9 1-20.3-5.7-20-30.6-54.5-50.8-93.8-50.8-61.9 0-112 50.1-112 112 0 10.6 1.5 20.8 4.2 30.6 1.2 4.2 .6 8.8-1.7 12.6s-6 6.4-10.3 7.4C69.8 237.4 32 282.3 32 336zm164.5-24.4c-6.1-6.4-6-16.5 .4-22.6s16.5-5.9 22.6 .4l41.2 42.6 94.4-129.8c5.2-7.1 15.2-8.7 22.3-3.5s8.7 15.2 3.5 22.3L275.3 366.2c-2.8 3.8-7.1 6.2-11.8 6.5s-9.3-1.4-12.6-4.8l-54.4-56.3z", "M240 32c45.7 0 86.4 21.4 112.7 54.6 12.3-4.3 25.6-6.6 39.3-6.6 66.3 0 120 53.7 120 120 0 13.2-2.2 25.9-6.2 37.8 41.6 21.1 70.2 64.2 70.2 114.2 0 70.7-57.3 128-128 128l-304 0c-79.5 0-144-64.5-144-144 0-63.5 41-117.2 98-136.4-1.3-7.7-2-15.5-2-23.6 0-79.5 64.5-144 144-144zm0 32c-61.9 0-112 50.1-112 112 0 10.6 1.5 20.8 4.2 30.6 1.2 4.2 .6 8.8-1.7 12.6s-6 6.4-10.3 7.4C69.8 237.4 32 282.3 32 336 32 397.9 82.1 448 144 448l304 0c53 0 96-43 96-96 0-41.8-26.8-77.5-64.2-90.6-4.3-1.5-7.8-4.8-9.5-9.1s-1.5-9 .5-13.1c5.9-11.8 9.2-25.1 9.2-39.2 0-48.6-39.4-88-88-88-13.6 0-26.5 3.1-37.9 8.5-7.2 3.5-15.9 1-20.3-5.7-20-30.6-54.5-50.8-93.8-50.8zM355.1 202.2c5.2-7.1 15.2-8.7 22.3-3.5s8.7 15.2 3.5 22.3L275.3 366.2c-2.8 3.8-7.1 6.2-11.8 6.5s-9.3-1.4-12.6-4.8l-54.4-56.3c-6.1-6.4-6-16.5 .4-22.6s16.5-5.9 22.6 .4l41.2 42.6 94.4-129.8z"]],
    "message-minus": [512, 512, ["comment-alt-minus"], "f4a7", ["M32 128l0 224c0 35.3 28.7 64 64 64l40 0c13.3 0 24 10.7 24 24l0 68 112-84c6.9-5.2 15.3-8 24-8l120 0c35.3 0 64-28.7 64-64l0-224c0-35.3-28.7-64-64-64L96 64c-35.3 0-64 28.7-64 64zM160 240c0-8.8 7.2-16 16-16l160 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-160 0c-8.8 0-16-7.2-16-16z", "M179.2 533.6l0 0 112-84c1.4-1 3.1-1.6 4.8-1.6l120 0c53 0 96-43 96-96l0-224c0-53-43-96-96-96L96 32C43 32 0 75 0 128L0 352c0 53 43 96 96 96l32 0 0 68c0 15.5 12.5 28 28 28 6.1 0 12-2 16.8-5.6l6.4-4.8zM160 448l0-8c0-13.3-10.7-24-24-24l-40 0c-35.3 0-64-28.7-64-64l0-224c0-35.3 28.7-64 64-64l320 0c35.3 0 64 28.7 64 64l0 224c0 35.3-28.7 64-64 64l-120 0c-8.7 0-17.1 2.8-24 8l-112 84 0-60zm16-224c-8.8 0-16 7.2-16 16s7.2 16 16 16l160 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-160 0z"]],
    "face-clouds": [640, 512, [], "e47d", ["M96 256c0-16.5 1.8-32.5 5.2-48l121 0c-3.8 4.2-6.1 9.9-6.1 16 0 13.3 10.7 24 24 24s24-10.7 24-24c0-8.3-4.2-15.6-10.6-19.9 47.6-12.9 82.6-56.4 82.6-108.1 0-23.8-7.4-45.8-20-64 1.3 0 2.7 0 4 0 123.7 0 224 100.3 224 224 0 .8 0 1.5 0 2.4-7.8-1.6-15.8-2.4-24-2.4-10.6 0-20.9 1.4-30.8 4-20.9-12.4-45.3-19.7-71.4-20 3.8-4.2 6.1-9.9 6.1-16 0-13.3-10.7-24-24-24s-24 10.7-24 24c0 7.9 3.8 14.8 9.6 19.2-59.6 12.8-105.5 62.5-112.6 124-20.5 23.8-33 54.8-33 88.8 0 3.2 .1 6.3 .3 9.4-84.4-32.1-144.3-113.8-144.3-209.4z", "M144 0c23.4 0 43.2 15.4 49.7 36.7 2.1 6.7 8.3 11.3 15.3 11.3l7 0c22.1 0 40 17.9 40 40s-17.9 40-40 40L72 128c-22.1 0-40-17.9-40-40S49.9 48 72 48l7 0C86 48 92.2 43.4 94.3 36.7 100.8 15.4 120.6 0 144 0zM68 16.1C30.1 18.2 0 49.6 0 88 0 127.8 32.2 160 72 160l144 0c39.8 0 72-32.2 72-72 0-38.4-30.1-69.8-68-71.9-13.5-28.4-42.4-48.1-76-48.1S81.5-12.3 68 16.1zM64 256c0 116.3 77.6 214.6 183.9 245.7-4.1-11.5-6.7-23.6-7.5-36.3-84.4-32.1-144.3-113.8-144.3-209.4 0-16.5 1.8-32.5 5.2-48L80 208c-3.8 0-7.7-.2-11.4-.6-3 15.7-4.6 32-4.6 48.6zM320 32c123.7 0 224 100.3 224 224 0 .8 0 1.6 0 2.4 11.2 2.3 21.8 6.1 31.7 11.3 .2-4.5 .4-9.1 .4-13.7 0-141.4-114.6-256-256-256-11.7 0-23.3 .8-34.6 2.3 12 7.9 22.4 18 30.5 29.7 1.3 0 2.7 0 4 0zM264 224a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm160 0a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM352.7 393.3c-5.5-37.7 25-73.3 63.3-73.3 19.1 0 36.2 8.4 48 21.7 5.3 6 14.3 7.2 21 2.6 7.7-5.2 17-8.3 27-8.3 27.2 0 49.6 23.9 47.9 51.1-.4 7.1 3.9 13.7 10.7 16.1 21.8 7.7 37.4 28.5 37.4 52.9 0 30.9-25.1 56-56 56l-176 0c-30.9 0-56-25.1-56-56 0-19.7 10.1-37 25.5-47 5.2-3.4 8-9.5 7.1-15.7zM416 288c-54.6 0-98 47-95.9 100-19.6 16.1-32.1 40.6-32.1 68 0 48.6 39.4 88 88 88l176 0c48.6 0 88-39.4 88-88 0-34.3-19.7-64-48.3-78.5-3.5-40.4-37.9-73.5-79.7-73.5-11.9 0-23.2 2.6-33.3 7.3-16.8-14.5-38.7-23.3-62.7-23.3z"]],
    "left-long-to-line": [640, 512, [], "e41e", ["M160 256l128-128 0 80c0 8.8 7.2 16 16 16l288 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-288 0c-8.8 0-16 7.2-16 16l0 80-128-128z", "M0 112c0-8.8 7.2-16 16-16s16 7.2 16 16l0 288c0 8.8-7.2 16-16 16S0 408.8 0 400L0 112zM137.4 278.6c-12.5-12.5-12.5-32.8 0-45.3l128-128c9.2-9.2 22.9-11.9 34.9-6.9S320 115.1 320 128l0 64 272 0c26.5 0 48 21.5 48 48l0 32c0 26.5-21.5 48-48 48l-272 0 0 64c0 12.9-7.8 24.6-19.8 29.6s-25.7 2.2-34.9-6.9l-128-128zM160 256l128 128 0-80c0-8.8 7.2-16 16-16l288 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-288 0c-8.8 0-16-7.2-16-16l0-80-128 128z"]],
    "plane-landing-gear": [640, 512, [], "e7bc", ["M51.2 224l19 104.6c4.1 22.8 24 39.4 47.2 39.4l10.6 0c138.6 .2 277.1 .4 415.7 .6 17.9 0 32.3-14.4 32.3-32.3 0-17.8-14.5-32.3-32.3-32.3L416 304c-4.5 0-8.8-1.9-11.8-5.2l-171.2-186.8-50.8 0 57 170.9c1.6 4.9 .8 10.2-2.2 14.4s-7.8 6.6-13 6.6l-96 0c-5.2 0-10.1-2.5-13.1-6.8L63.7 224 51.2 224z", "M576 336.3c0-17.8-14.5-32.3-32.3-32.3L416 304c-4.5 0-8.8-1.9-11.8-5.2l-171.2-186.8-50.8 0 57 170.9c1.6 4.9 .8 10.2-2.2 14.4s-7.8 6.6-13 6.6l-96 0c-5.2 0-10.1-2.5-13.1-6.8l-51.2-73.2-12.5 0 19 104.6c4.1 22.8 24 39.4 47.2 39.4l10.6 0 415.6 .6c17.9 0 32.3-14.4 32.3-32.3zM543.7 272c35.5 0 64.3 28.8 64.3 64.3 0 35.5-28.8 64.4-64.4 64.3l-415.6-.6-10.6 0c-38.7 0-71.8-27.7-78.7-65.7L16.3 210.9c-.8-4.7 .4-9.5 3.5-13.1S27.3 192 32 192l40 0c5.2 0 10.1 2.5 13.1 6.8l51.2 73.2 65.5 0-57-170.9c-1.6-4.9-.8-10.2 2.2-14.4s7.8-6.6 13-6.6l80 0c4.5 0 8.8 1.9 11.8 5.2L423 272 543.7 272zM233.3 480a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM384 456a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]],
    "calendar-check": [448, 512, [], "f274", ["M32 128l0 288c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-288c0-17.7-14.3-32-32-32L64 96c-17.7 0-32 14.3-32 32zm84.7 164.7c6.2-6.2 16.4-6.2 22.6 0l50.7 50.7 117-160.8c5.2-7.1 15.2-8.7 22.3-3.5s8.7 15.2 3.5 22.3l-128 176c-2.8 3.8-7 6.2-11.7 6.5s-9.3-1.3-12.6-4.6l-64-64c-6.2-6.2-6.2-16.4 0-22.6z", "M336 0c8.8 0 16 7.2 16 16l0 48 32 0c35.3 0 64 28.7 64 64l0 288-.3 6.5c-3.1 30.1-27 54.1-57.1 57.1l-6.5 .3-320 0-6.5-.3c-30.1-3.1-54.1-27-57.1-57.1L0 416 0 128C0 92.7 28.7 64 64 64l32 0 0-48c0-8.8 7.2-16 16-16s16 7.2 16 16l0 48 192 0 0-48c0-8.8 7.2-16 16-16zM64 96c-17.7 0-32 14.3-32 32l0 288c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-288c0-17.7-14.3-32-32-32L64 96zm243.1 86.6c5.2-7.1 15.2-8.7 22.3-3.5s8.7 15.2 3.5 22.3l-128 176c-2.8 3.8-7 6.2-11.7 6.5s-9.3-1.3-12.6-4.6l-64-64c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l50.7 50.7 117-160.8z"]],
    "square-ring": [448, 512, [], "e44f", ["M32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64C46.3 64 32 78.3 32 96zM352 256a128 128 0 1 1 -256 0 128 128 0 1 1 256 0z", "M64 64C46.3 64 32 78.3 32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM320 256a96 96 0 1 0 -192 0 96 96 0 1 0 192 0zM96 256a128 128 0 1 1 256 0 128 128 0 1 1 -256 0z"]],
    "face-kiss": [512, 512, [128535, "kiss"], "f596", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm168-48a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm40 72c0-8.8 7.2-16 16-16l16 0c26.5 0 48 21.5 48 48 0 12.3-4.6 23.5-12.2 32 7.6 8.5 12.2 19.7 12.2 32 0 26.5-21.5 48-48 48l-16 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0c-8.8 0-16-7.2-16-16zm120-72a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M480 256a224 224 0 1 0 -448 0 224 224 0 1 0 448 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm240 24c0-8.8 7.2-16 16-16l16 0c26.5 0 48 21.5 48 48 0 12.3-4.6 23.5-12.2 32 7.6 8.5 12.2 19.7 12.2 32 0 26.5-21.5 48-48 48l-16 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0c-8.8 0-16-7.2-16-16zm-88-72a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm184-24a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]],
    "circle-video": [512, 512, ["video-circle"], "e12b", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm96-56c0-22.1 17.9-40 40-40l112 0c22.1 0 40 17.9 40 40l0 6.1 56.8-28.4c5-2.5 10.9-2.2 15.6 .7s7.6 8.1 7.6 13.6l0 128c0 5.5-2.9 10.7-7.6 13.6s-10.6 3.2-15.6 .7l-56.8-28.4 0 6.1c0 22.1-17.9 40-40 40l-112 0c-22.1 0-40-17.9-40-40l0-112z", "M256 32a224 224 0 1 1 0 448 224 224 0 1 1 0-448zm0 480a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm24-320c4.4 0 8 3.6 8 8l0 112c0 4.4-3.6 8-8 8l-112 0c-4.4 0-8-3.6-8-8l0-112c0-4.4 3.6-8 8-8l112 0zm40 14.1l0-6.1c0-22.1-17.9-40-40-40l-112 0c-22.1 0-40 17.9-40 40l0 112c0 22.1 17.9 40 40 40l112 0c22.1 0 40-17.9 40-40l0-6.1 56.8 28.4c5 2.5 10.9 2.2 15.6-.7s7.6-8.1 7.6-13.6l0-128c0-5.5-2.9-10.7-7.6-13.6s-10.6-3.2-15.6-.7L320 206.1zm0 35.8l48-24 0 76.2-48-24 0-28.2z"]],
    "cart-shopping-fast": [640, 512, [], "e0dc", ["M177 64l34.9 192 318.8 0c18.9 0 35.2-13.2 39.1-31.6L602.1 73.7c1.1-5-2.7-9.7-7.8-9.7L177 64zm75 396a20 20 0 1 0 40 0 20 20 0 1 0 -40 0zm224 0a20 20 0 1 0 40 0 20 20 0 1 0 -40 0z", "M64 16C64 7.2 71.2 0 80 0l45.3 0c20.6 0 38.6 13.1 45.3 32l423.8 0c25.5 0 44.4 23.5 39.1 48.4L601.1 231.1C594 264.3 564.7 288 530.7 288l-313 0 5.7 31.2c3.5 19 20 32.8 39.4 32.8L528 352c8.8 0 16 7.2 16 16s-7.2 16-16 16l-265.3 0c-34.8 0-64.6-24.9-70.8-59.1L141 45.1c-1.4-7.6-8-13.1-15.7-13.1L80 32c-8.8 0-16-7.2-16-16zM211.9 256l318.8 0c18.9 0 35.2-13.2 39.1-31.6L602.1 73.7c1.1-5-2.7-9.7-7.8-9.7L177 64 211.9 256zM272 480a20 20 0 1 0 0-40 20 20 0 1 0 0 40zm0-72a52 52 0 1 1 0 104 52 52 0 1 1 0-104zm244 52a20 20 0 1 0 -40 0 20 20 0 1 0 40 0zm-72 0a52 52 0 1 1 104 0 52 52 0 1 1 -104 0zM16 96l64 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-64 0c-8.8 0-16-7.2-16-16S7.2 96 16 96zm0 96l80 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-80 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zm0 96l96 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16s7.2-16 16-16z"]],
    "desktop-arrow-down": [512, 512, [], "e155", ["M32 96c0-17.7 14.3-32 32-32l128 0 0-32 48 0 0 153.4-52.7-52.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l80 80c6.2 6.2 16.4 6.2 22.6 0l80-80c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-52.7 52.7 0-153.4 48 0 0 32 128 0c17.7 0 32 14.3 32 32l0 192-448 0 0-192zM202.9 480l10.7-64 84.9 0 10.7 64-106.2 0z", "M272 16l0 169.4 52.7-52.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6l-80 80c-6.2 6.2-16.4 6.2-22.6 0l-80-80c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0L240 185.4 240 16c0-8.8 7.2-16 16-16s16 7.2 16 16zM64 32l128 0 0 32-128 0C46.3 64 32 78.3 32 96l0 192 448 0 0-192c0-17.7-14.3-32-32-32l-128 0 0-32 128 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64l-117.1 0 10.7 64 58.4 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-288 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l58.4 0 10.7-64-117.1 0c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32zM480 352l0-32-448 0 0 32c0 17.7 14.3 32 32 32l384 0c17.7 0 32-14.3 32-32zM202.9 480l106.2 0-10.7-64-84.9 0-10.7 64z"]],
    "banjo": [512, 512, [129685], "f8a3", ["M56 320a136 136 0 1 0 272 0 136 136 0 1 0 -272 0zm68.7-3.3c6.2-6.2 16.4-6.2 22.6 0l48 48c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-48-48c-6.2-6.2-6.2-16.4 0-22.6zM397.1 114.9l42.9-9.5 39-39c.6-.6 1-1.5 1-2.3s-.3-1.7-1-2.3L450.3 33c-.6-.6-1.5-1-2.3-1s-1.7 .3-2.3 1l-39 39-9.5 42.9z", "M445.7 33c.6-.6 1.5-1 2.3-1s1.7 .3 2.3 1L479 61.7c.6 .6 1 1.5 1 2.3s-.3 1.7-1 2.3l-39 39-42.9 9.5 9.5-42.9 39-39zM376.4 60.5l-15 67.5-62.4 62.4c-25.2-20.8-56.6-34.4-90.9-37.7l0-8.8c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 8.8c-34.4 3.2-65.8 16.9-90.9 37.7l-6.2-6.2c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l6.2 6.2C41.6 238.2 28 269.6 24.8 304L16 304c-8.8 0-16 7.2-16 16s7.2 16 16 16l8.8 0c3.2 34.4 16.9 65.8 37.7 90.9l-6.2 6.2c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l6.2-6.2c25.2 20.8 56.6 34.4 90.9 37.7l0 8.8c0 8.8 7.2 16 16 16s16-7.2 16-16l0-8.8c34.4-3.2 65.8-16.9 90.9-37.7l6.2 6.2c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-6.2-6.2c20.8-25.2 34.4-56.6 37.7-90.9l8.8 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-8.8 0c-3.2-34.4-16.9-65.8-37.7-90.9l62.4-62.4 67.5-15c3-.7 5.7-2.2 7.8-4.3L501.7 89c6.6-6.6 10.3-15.6 10.3-25s-3.7-18.3-10.3-25L473 10.3C466.3 3.7 457.4 0 448 0s-18.3 3.7-25 10.3L380.7 52.7c-2.2 2.2-3.6 4.9-4.3 7.8zM192 184a136 136 0 1 1 0 272 136 136 0 1 1 0-272zM124.7 316.7c-6.2 6.2-6.2 16.4 0 22.6l48 48c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-48-48c-6.2-6.2-16.4-6.2-22.6 0z"]],
    "cloud-hail-mixed": [512, 512, [], "f73a", ["M32 224c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64s-28.7-64-64-64c-5.9 0-11.6 .8-16.9 2.3-5.9 1.6-12.1-.3-16.2-4.8s-5.2-11-2.9-16.6c2.6-6.4 4-13.5 4-20.9 0-30.9-25.1-56-56-56-19.9 0-37.4 10.4-47.4 26.1-3.3 5.2-9.3 8.1-15.5 7.3s-11.3-5-13.2-10.8c-10.6-31.8-40.6-54.7-75.9-54.7-44.2 0-80 35.8-80 80 0 9.6 1.7 18.7 4.7 27.2 1.7 4.6 1.1 9.6-1.4 13.8s-6.8 6.9-11.6 7.5C56.3 164.6 32 191.5 32 224z", "M96 112c0-44.2 35.8-80 80-80 35.3 0 65.3 22.9 75.9 54.7 2 5.9 7.1 10.1 13.2 10.8s12.2-2.1 15.5-7.3c9.9-15.7 27.5-26.1 47.4-26.1 30.9 0 56 25.1 56 56 0 7.4-1.4 14.4-4 20.9-2.3 5.6-1.1 12.1 2.9 16.6s10.3 6.4 16.2 4.8c5.4-1.5 11.1-2.3 16.9-2.3 35.3 0 64 28.7 64 64s-28.7 64-64 64L96 288c-35.3 0-64-28.7-64-64 0-32.5 24.3-59.4 55.7-63.5 4.8-.6 9.1-3.4 11.6-7.5s3-9.2 1.4-13.8C97.7 130.7 96 121.6 96 112zM176 0c-61.9 0-112 50.1-112 112 0 7.1 .7 14.1 1.9 20.8-38.3 12.6-65.9 48.7-65.9 91.2 0 53 43 96 96 96l320 0c53 0 96-43 96-96s-43-96-96-96l-.4 0c.2-2.6 .4-5.3 .4-8 0-48.6-39.4-88-88-88-21.7 0-41.5 7.9-56.9 20.9-19.8-31.7-55-52.9-95.1-52.9zM97.9 389.1c2.8-8.4-1.7-17.4-10.1-20.2s-17.4 1.7-20.2 10.1L54.2 418.8c-2.8 8.4 1.7 17.4 10.1 20.2s17.4-1.7 20.2-10.1l13.3-39.9zm120 0c2.8-8.4-1.7-17.4-10.1-20.2s-17.4 1.7-20.2 10.1l-37.3 112c-2.8 8.4 1.7 17.4 10.1 20.2s17.4-1.7 20.2-10.1l37.3-112zm112 0c2.8-8.4-1.7-17.4-10.1-20.2s-17.4 1.7-20.2 10.1l-13.3 39.9c-2.8 8.4 1.7 17.4 10.1 20.2s17.4-1.7 20.2-10.1l13.3-39.9zm120 0c2.8-8.4-1.7-17.4-10.1-20.2s-17.4 1.7-20.2 10.1l-37.3 112c-2.8 8.4 1.7 17.4 10.1 20.2s17.4-1.7 20.2-10.1l37.3-112zM72 488a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm208 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]],
    "square-half-stroke": [448, 512, [], "e793", ["M32 96l0 320c0 17.7 14.3 32 32 32l144 0 0-384-144 0C46.3 64 32 78.3 32 96z", "M240 64l0 384 144 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L240 64zm-32 0L64 64C46.3 64 32 78.3 32 96l0 320c0 17.7 14.3 32 32 32l144 0 0-384zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96z"]],
    "kitchen-set": [576, 512, [], "e51a", ["M32 144a112 112 0 1 0 224 0 112 112 0 1 0 -224 0zm192 0a80 80 0 1 1 -160 0 80 80 0 1 1 160 0zM64 352l0 64 64 0 0-64-64 0zM96 144a48 48 0 1 0 96 0 48 48 0 1 0 -96 0zM320 352l0 112c0 8.8 7.2 16 16 16l128 0c8.8 0 16-7.2 16-16l0-112-160 0zm64-208c0 8.8 7.2 16 16 16l96 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-96 0c-8.8 0-16 7.2-16 16z", "M144 256a112 112 0 1 0 0-224 112 112 0 1 0 0 224zm143.1-96c-8 72-69 128-143.1 128-79.5 0-144-64.5-144-144S64.5 0 144 0c74.1 0 135.2 56 143.1 128l67.6 0c6.6-18.6 24.4-32 45.3-32l96 0c26.5 0 48 21.5 48 48s-21.5 48-48 48l-96 0c-20.9 0-38.7-13.4-45.3-32l-67.6 0zM272 320l48 0 0-32c0-17.7 14.3-32 32-32l96 0c17.7 0 32 14.3 32 32l0 32 48 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0 0 112c0 26.5-21.5 48-48 48l-128 0c-26.5 0-48-21.5-48-48l0-112-16 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zm80 0l96 0 0-32-96 0 0 32zm-32 32l0 112c0 8.8 7.2 16 16 16l128 0c8.8 0 16-7.2 16-16l0-112-160 0zM496 128l-96 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l96 0c8.8 0 16-7.2 16-16s-7.2-16-16-16zM192 144a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM64 144a80 80 0 1 1 160 0 80 80 0 1 1 -160 0zM0 496c0-8.8 7.2-16 16-16l192 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L16 512c-8.8 0-16-7.2-16-16zM160 352l0 32 16 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0zm0-32l16 0c26.5 0 48 21.5 48 48s-21.5 48-48 48l-16 0c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-80c0-8.8 7.2-16 16-16l112 0zm-32 64l0-32-64 0 0 64 64 0 0-32z"]],
    "dna": [384, 512, [129516], "f471", ["M38.4 64c6.5 23.4 17.6 44.5 32.2 64l242.9 0c14.6-19.5 25.7-40.6 32.2-64L38.4 64zm0 384l307.3 0c-6.5-23.5-17.6-44.5-32.2-64.1-.5 0-.9 .1-1.4 .1L72 384c-.5 0-.9 0-1.4-.1-14.6 19.5-25.8 40.6-32.2 64.1zM98.5 160c26.6 26.7 59.1 51.1 93.5 76.2 34.4-25.1 66.9-49.5 93.5-76.2l-187 0zm0 192l187 0c-26.6-26.7-59.1-51.1-93.5-76.2-34.4 25.1-66.9 49.5-93.5 76.2z", "M368 0c8.8 0 16 7.2 16 16 0 113.2-83.6 180.5-164.8 240 81.2 59.5 164.8 126.8 164.8 240 0 8.8-7.2 16-16 16s-16-7.2-16-16c0-5.5-.2-10.8-.7-16L32.7 480c-.4 5.2-.7 10.5-.7 16 0 8.8-7.2 16-16 16S0 504.8 0 496C0 382.8 83.6 315.5 164.8 256 83.6 196.5 0 129.2 0 16 0 7.2 7.2 0 16 0S32 7.2 32 16c0 5.5 .2 10.8 .7 16l318.7 0c.4-5.2 .7-10.5 .7-16 0-8.8 7.2-16 16-16zM38.4 64c6.5 23.4 17.6 44.5 32.2 64l242.9 0c14.6-19.5 25.7-40.6 32.2-64L38.4 64zm60.1 96c26.6 26.7 59.1 51.1 93.5 76.2 34.4-25.1 66.9-49.5 93.5-76.2l-187 0zM192 275.8c-34.4 25.1-66.9 49.5-93.5 76.2l187 0c-26.6-26.7-59.1-51.1-93.5-76.2zM313.4 383.9c-.5 0-.9 .1-1.4 .1L72 384c-.5 0-.9 0-1.4-.1-14.6 19.5-25.8 40.6-32.2 64.1l307.3 0c-6.5-23.5-17.6-44.5-32.2-64.1z"]],
    "circle-bangladeshi-taka": [512, 512, [], "e701", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zM144.2 141.4c1.5-8.7 9.7-14.6 18.4-13.2l17.4 2.9c25.3 4.2 43.9 26.2 43.9 51.9l0 25 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0 0 91.4c0 11.4 9.2 20.6 20.6 20.6l16 0c41.7 0 75.4-33.8 75.4-75.4l0-16c0-11.4-9.2-20.6-20.6-20.6l-3.4 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l3.4 0c29 0 52.6 23.5 52.6 52.6l0 16C368 335.9 319.9 384 260.6 384l-16 0c-29 0-52.6-23.5-52.6-52.6l0-91.4-29.7 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l29.7 0 0-25c0-10.1-7.3-18.6-17.2-20.3l-17.4-2.9c-8.7-1.5-14.6-9.7-13.2-18.4z", "M256 32a224 224 0 1 1 0 448 224 224 0 1 1 0-448zm0 480a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM144.2 141.4c-1.5 8.7 4.4 17 13.2 18.4l17.4 2.9c9.9 1.7 17.2 10.2 17.2 20.3l0 25-29.7 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l29.7 0 0 91.4c0 29 23.5 52.6 52.6 52.6l16 0C319.9 384 368 335.9 368 276.6l0-16c0-29-23.5-52.6-52.6-52.6l-3.4 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l3.4 0c11.4 0 20.6 9.2 20.6 20.6l0 16c0 41.7-33.8 75.4-75.4 75.4l-16 0c-11.4 0-20.6-9.2-20.6-20.6l0-91.4 16 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0 0-25c0-25.7-18.6-47.6-43.9-51.9l-17.4-2.9c-8.7-1.5-17 4.4-18.4 13.2z"]],
    "box-circle-check": [576, 512, [], "e0c4", ["M64 160l384 0 0 48.7c-5.3-.4-10.6-.7-16-.7-106 0-192 86-192 192 0 16.6 2.1 32.7 6 48L96 448c-17.7 0-32-14.3-32-32l0-256zm7.3-32l47.6-66.6c6-8.4 15.7-13.4 26-13.4l95.1 0 0 80-168.7 0zM272 48l95.1 0c10.3 0 20 5 26 13.4l47.6 66.6-168.7 0 0-80z", "M448 160l0 48.7c11 .9 21.6 2.7 32 5.4l0-65.5c0-13.3-4.2-26.3-11.9-37.2L419.1 42.8C407.1 26 387.7 16 367.1 16L144.9 16c-20.7 0-40.1 10-52.1 26.8L43.9 111.3C36.2 122.2 32 135.2 32 148.5L32 416c0 35.3 28.7 64 64 64l161.4 0c-4.7-10.2-8.5-20.9-11.4-32L96 448c-17.7 0-32-14.3-32-32l0-256 384 0zM71.3 128l47.6-66.6c6-8.4 15.7-13.4 26-13.4l95.1 0 0 80-168.7 0zM272 128l0-80 95.1 0c10.3 0 20 5 26 13.4L440.7 128 272 128zM432 288a112 112 0 1 1 0 224 112 112 0 1 1 0-224zm0 256a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm57.4-204.9c-7.1-5.2-17.2-3.6-22.4 3.5l-53 72.9-26.8-26.8c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l40 40c3.3 3.3 7.9 5 12.6 4.6s8.9-2.8 11.7-6.5l64-88c5.2-7.1 3.6-17.2-3.5-22.4z"]],
    "trillium": [512, 512, [], "e588", ["M50.8 368.7c15.8 4.7 43.4 11.8 73.4 14.2 31.3 2.4 62.9-.4 86.5-14.1l5-3.2c11.4-7.7 20.2-18 26.1-29.5l1.2-1.9c3-4.2 7.8-6.8 13.1-6.8 6 0 11.5 3.4 14.2 8.7 6.8 13.2 17.3 24.7 31.1 32.7l4.5 2.4c23 11.5 52.6 13.9 82 11.7 30-2.3 57.6-9.4 73.4-14.2-3.8-16-11.5-43.5-24.4-70.6-12.7-26.6-29.6-51-51.1-65.2l-4.4-2.7c-12.6-7.2-26.2-10.7-39.7-10.8-5.5 0-10.7-2.9-13.6-7.7s-3.1-10.6-.6-15.6c5.5-10.9 8.7-23.2 8.7-36.2l-.2-5.1c-1.5-25.7-14.2-52.5-30.9-76.8-17-24.8-37-45.2-48.9-56.5-12 11.3-31.9 31.7-48.9 56.5-17.8 25.9-31.1 54.7-31.1 81.9 0 13.1 3.1 25.4 8.7 36.2 2.5 5 2.3 10.9-.6 15.6s-8.1 7.6-13.7 7.6c-11.8 0-23.8 2.7-35.1 8.2l-4.8 2.6c-23.6 13.6-41.9 39.5-55.4 67.9-13 27.2-20.7 54.6-24.5 70.6zM312.2 240a56 56 0 1 1 -112 0 56 56 0 1 1 112 0z", "M237.6-4.7c11-8.5 26.1-8.4 37.1 0L277-2.8 288.1 8c12.6 12.7 28.8 30.8 43.4 51.9 6.1 8.9 12 18.6 17.2 28.8 14.2-1.2 28.4-1 41.7 0 25.6 2 49.4 7.1 66.7 11.6l15 4.2c15.4 4.7 24.5 20.3 20.8 36.1l-3.8 15.1c-4.7 17.2-12.2 40.3-23.3 63.5-5.1 10.8-11.3 21.8-18.4 32.4 7.1 10.7 13.2 21.8 18.4 32.6 14.8 30.9 23.1 61.7 27.1 78.6l.6 2.9c1.8 13.7-5.8 26.8-18.6 32.1l-2.8 1c-16.6 5-47.5 13.1-81.6 15.8-13.4 1-27.6 1.2-41.9-.1-5.3 10.3-11.1 20-17.3 28.9-19.4 28.2-41.8 50.9-54.5 62.8l-2.3 1.9c-11 8.5-26.1 8.4-37.1 0l-2.3-1.9-11.2-10.8c-12.6-12.7-28.8-30.8-43.4-51.9-6.1-8.9-12-18.7-17.2-28.9-14.2 1.2-28.4 1.1-41.7 0-25.6-2-49.4-7.1-66.7-11.6l-15-4.2c-15.5-4.7-24.5-20.3-20.8-36.1l3.8-15.1c4.7-17.2 12.2-40.3 23.3-63.5 5.2-10.8 11.3-22 18.4-32.6-7.1-10.6-13.3-21.6-18.4-32.4-14.8-30.9-23.1-61.7-27.1-78.6l-.6-2.9c-1.8-13.7 5.8-26.8 18.6-32.1l2.8-1c16.6-5 47.5-13.1 81.6-15.8 13.3-1 27.5-1.2 41.8 0 5.3-10.3 11.2-20 17.3-28.9 19.4-28.2 41.8-50.9 54.5-62.8l2.3-1.9zM256.1 372c-6.4 7.5-13.8 14.4-22.3 20.2l-7 4.4c-9.5 5.5-19.6 9.5-30.1 12.4 3.2 5.6 6.7 11.2 10.4 16.6 17 24.8 37 45.2 48.9 56.5 12-11.3 31.9-31.7 48.9-56.5 3.7-5.4 7.2-11 10.4-16.6-8.2-2.3-16.2-5.3-23.9-9.2l-6.1-3.3c-11.4-6.6-21.3-15-29.4-24.5zm.1-350.4c-12 11.3-31.9 31.7-48.9 56.5-17.8 25.9-31.1 54.7-31.1 81.9 0 13.1 3.1 25.4 8.7 36.2 2.5 5 2.3 10.9-.6 15.6s-8.1 7.6-13.7 7.6c-11.8 0-23.8 2.7-35.1 8.2l-4.8 2.6c-23.6 13.6-41.9 39.5-55.4 67.9-13 27.2-20.7 54.6-24.5 70.6 15.8 4.7 43.4 11.8 73.4 14.2 31.3 2.4 62.9-.4 86.5-14.1l5-3.2c11.4-7.7 20.2-18 26.1-29.5l1.2-1.9c3-4.2 7.8-6.8 13.1-6.8 6 0 11.5 3.4 14.2 8.7 6.8 13.2 17.3 24.7 31.1 32.7l4.5 2.4c23 11.5 52.6 13.9 82 11.7 30-2.3 57.6-9.4 73.4-14.2-3.8-16-11.5-43.5-24.4-70.6-12.7-26.6-29.6-51-51.1-65.2l-4.4-2.7c-12.6-7.2-26.2-10.7-39.7-10.8-5.5 0-10.7-2.9-13.6-7.7s-3.1-10.6-.6-15.6c5.5-10.9 8.7-23.2 8.7-36.2l-.2-5.1c-1.5-25.7-14.2-52.5-30.9-76.8-17-24.8-37-45.2-48.9-56.5zm0 274.4a56 56 0 1 1 0-112 56 56 0 1 1 0 112zm0-80a24 24 0 1 0 0 48 24 24 0 1 0 0-48zM150.5 120.2c-8.6-.3-17.5-.1-26.2 .6-30 2.3-57.6 9.4-73.4 14.2 3.8 16 11.5 43.5 24.4 70.6 3.2 6.8 6.8 13.4 10.6 19.7 8.5-8.8 18.1-16.6 28.8-22.7l6.7-3.6c8.7-4.3 17.7-7.3 26.8-9.2-2.6-9.5-4.1-19.5-4.1-29.8 0-13.6 2.3-27 6.3-39.8zm211.3 0c4 12.9 6.4 26.3 6.4 39.8l-.2 6.8c-.5 7.9-1.8 15.6-3.9 23 11.4 2.4 22.7 6.6 33.3 12.7l5.9 3.6c8.4 5.5 15.9 12 22.9 19.2 3.8-6.4 7.4-13 10.7-19.8 13-27.1 20.7-54.6 24.5-70.6-15.8-4.7-43.4-11.8-73.4-14.2-8.8-.7-17.5-.9-26.2-.6z"]],
    "delete-right": [640, 512, [], "e154", ["M96 128c0-17.7 14.3-32 32-32l306.7 0c8.5 0 16.6 3.4 22.6 9.4L608 256 457.4 406.6c-6 6-14.1 9.4-22.6 9.4L128 416c-17.7 0-32-14.3-32-32l0-256zm124.7 60.7c-6.2 6.2-6.2 16.4 0 22.6l44.7 44.7-44.7 44.7c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l44.7-44.7 44.7 44.7c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-44.7-44.7 44.7-44.7c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-44.7 44.7-44.7-44.7c-6.2-6.2-16.4-6.2-22.6 0z", "M96 128c0-17.7 14.3-32 32-32l306.7 0c8.5 0 16.6 3.4 22.6 9.4L608 256 457.4 406.6c-6 6-14.1 9.4-22.6 9.4L128 416c-17.7 0-32-14.3-32-32l0-256zm32-64c-35.3 0-64 28.7-64 64l0 256c0 35.3 28.7 64 64 64l306.7 0c17 0 33.3-6.7 45.3-18.7L630.6 278.6c6-6 9.4-14.1 9.4-22.6s-3.4-16.6-9.4-22.6L480 82.7C468 70.7 451.7 64 434.7 64L128 64zm92.7 124.7c-6.2 6.2-6.2 16.4 0 22.6l44.7 44.7-44.7 44.7c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l44.7-44.7 44.7 44.7c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-44.7-44.7 44.7-44.7c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-44.7 44.7-44.7-44.7c-6.2-6.2-16.4-6.2-22.6 0z"]],
    "circle-colon": [512, 512, [], "e6fc", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm97.3 0c0-65.4 49-119.3 112.2-127l7.3-22c2.8-8.4 11.9-12.9 20.2-10.1s12.9 11.9 10.1 20.2l-4.1 12.2c9.7 1.4 19 3.8 27.9 7.2l9.8-29.5c2.8-8.4 11.9-12.9 20.2-10.1s12.9 11.9 10.1 20.2l-11.6 34.7c4.8 3.4 9.3 7.1 13.5 11.1 6.4 6.1 6.7 16.2 .6 22.6s-16.2 6.7-22.6 .7c-.8-.7-1.5-1.4-2.3-2.1L265 351.7c22.5-1.8 42.7-11.3 58.2-25.9 6.4-6.1 16.6-5.8 22.6 .7s5.8 16.6-.6 22.6c-22.9 21.6-53.8 34.9-87.9 34.9-1 0-2 0-3 0l-7 21.1c-2.8 8.4-11.9 12.9-20.2 10.1s-12.9-11.9-10.1-20.2l5.3-15.8c-9.4-2.7-18.3-6.4-26.6-11l-12.3 36.9c-2.8 8.4-11.9 12.9-20.2 10.1s-12.9-11.9-10.1-20.2l15.6-46.8c-24.1-23.3-39.2-56-39.2-92.2zm32 0c0 21.4 7 41.2 18.8 57.1L229.8 164c-39.6 11.8-68.6 48.5-68.6 92zm44.6 81.1c8.1 5.1 16.9 9.1 26.4 11.6l60.6-181.9c-8.8-3.5-18.2-5.8-28.1-6.5L205.8 337.1z", "M256 32a224 224 0 1 1 0 448 224 224 0 1 1 0-448zm0 480a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm23.2-394.9c2.8-8.4-1.7-17.4-10.1-20.2s-17.4 1.7-20.2 10.1l-7.3 22c-63.3 7.8-112.2 61.7-112.2 127 0 36.2 15 68.9 39.2 92.2l-15.6 46.8c-2.8 8.4 1.7 17.4 10.1 20.2s17.4-1.7 20.2-10.1l12.3-36.9c8.3 4.6 17.3 8.3 26.6 11l-5.3 15.8c-2.8 8.4 1.7 17.4 10.1 20.2s17.4-1.7 20.2-10.1l7-21.1c1 0 2 0 3 0 34 0 64.9-13.3 87.9-34.9 6.4-6.1 6.7-16.2 .6-22.6s-16.2-6.7-22.6-.7c-15.5 14.6-35.7 24.1-58.2 25.9l55.9-167.6c.8 .7 1.5 1.4 2.3 2.1 6.4 6.1 16.6 5.8 22.6-.7s5.8-16.6-.6-22.6c-4.2-4-8.8-7.7-13.5-11.1l11.6-34.7c2.8-8.4-1.7-17.4-10.1-20.2s-17.4 1.7-20.2 10.1L303 136.4c-8.9-3.4-18.2-5.8-27.9-7.2l4.1-12.2zm13.7 49.8L232.2 348.7c-9.5-2.5-18.3-6.5-26.4-11.6l58.9-176.8c9.9 .8 19.3 3 28.1 6.5zM229.8 164L180.1 313.1c-11.8-16-18.8-35.7-18.8-57.1 0-43.5 28.9-80.2 68.6-92z"]],
    "child-reaching": [320, 512, [], "e59d", ["M112 201.1c15.3 4.5 31.4 6.9 47.9 6.9 16.5 0 32.7-2.4 48.1-7l0 151-96 0 0-150.9zM192 64a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M192 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM96 64A64 64 0 1 1 224 64 64 64 0 1 1 96 64zM80 188c-27.8-14.9-51.4-37.4-67.5-65.8L2.1 103.9c-4.4-7.7-1.7-17.5 6-21.8s17.5-1.7 21.8 6l10.4 18.3c24.4 43 70.1 69.6 119.5 69.6 48.9 0 94.1-26 118.7-68.2l11.6-19.9c4.5-7.6 14.2-10.2 21.9-5.8s10.2 14.2 5.8 21.9l-11.6 19.9c-16 27.5-39.1 49.4-66.2 63.9L240 496c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-112-96 0 0 112c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-308zm32 13.1l0 150.9 96 0 0-151c-15.4 4.6-31.6 7-48.1 7-16.4 0-32.5-2.4-47.9-6.9z"]],
    "face-confounded": [512, 512, [], "e36c", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm81.7 104.8c4-7.9 13.6-11.1 21.5-7.2l23.7 11.8 40.3-26.8c5.4-3.6 12.4-3.6 17.8 0l39.1 26.1 39.1-26.1c5.4-3.6 12.4-3.6 17.7 0l40.3 26.8 23.7-11.8c7.9-4 17.5-.7 21.5 7.2s.7 17.5-7.2 21.5l-32 16c-5.1 2.6-11.3 2.2-16-1l-39.1-26.1-39.1 26.1c-5.4 3.6-12.4 3.6-17.7 0l-39.1-26.1-39.1 26.1c-4.8 3.2-10.9 3.6-16 1l-32-16c-7.9-4-11.1-13.6-7.2-21.5zm7.6-168c4-7.9 13.6-11.1 21.5-7.2l80 40c5.4 2.7 8.8 8.3 8.8 14.3s-3.4 11.6-8.8 14.3l-80 40c-7.9 4-17.5 .7-21.5-7.2s-.7-17.5 7.2-21.5l51.4-25.7-51.4-25.7c-7.9-4-11.1-13.6-7.2-21.5zM280.4 240c0-6.1 3.4-11.6 8.8-14.3l80-40c7.9-4 17.5-.7 21.5 7.2s.7 17.5-7.2 21.5l-51.4 25.7 51.4 25.7c7.9 4 11.1 13.6 7.2 21.5s-13.6 11.1-21.5 7.2l-80-40c-5.4-2.7-8.8-8.3-8.8-14.3z", "M480 256a224 224 0 1 0 -448 0 224 224 0 1 0 448 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm216.9 82.7l39.1 26.1 39.1-26.1c5.4-3.6 12.4-3.6 17.7 0l40.3 26.8 23.7-11.8c7.9-4 17.5-.7 21.5 7.2s.7 17.5-7.2 21.5l-32 16c-5.1 2.6-11.3 2.2-16-1l-39.1-26.1-39.1 26.1c-5.4 3.6-12.4 3.6-17.7 0l-39.1-26.1-39.1 26.1c-4.8 3.2-10.9 3.6-16 1l-32-16c-7.9-4-11.1-13.6-7.2-21.5s13.6-11.1 21.5-7.2l23.7 11.8 40.3-26.8c5.4-3.6 12.4-3.6 17.8 0zM121.3 192.8c4-7.9 13.6-11.1 21.5-7.2l80 40c5.4 2.7 8.8 8.3 8.8 14.3s-3.4 11.6-8.8 14.3l-80 40c-7.9 4-17.5 .7-21.5-7.2s-.7-17.5 7.2-21.5l51.4-25.7-51.4-25.7c-7.9-4-11.1-13.6-7.2-21.5zm262.2 21.5l-51.4 25.7 51.4 25.7c7.9 4 11.1 13.6 7.2 21.5s-13.6 11.1-21.5 7.2l-80-40c-5.4-2.7-8.8-8.3-8.8-14.3s3.4-11.6 8.8-14.3l80-40c7.9-4 17.5-.7 21.5 7.2s.7 17.5-7.2 21.5z"]],
    "sidebar": [512, 512, [], "e24e", ["M256 96l192 0c17.7 0 32 14.3 32 32l0 256c0 17.7-14.3 32-32 32l-192 0 0-320z", "M224 96l0 320-160 0c-17.7 0-32-14.3-32-32l0-256c0-17.7 14.3-32 32-32l160 0zm16-32L64 64C28.7 64 0 92.7 0 128L0 384c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L240 64zm16 32l192 0c17.7 0 32 14.3 32 32l0 256c0 17.7-14.3 32-32 32l-192 0 0-320zM80 160c0 8.8 7.2 16 16 16l64 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-64 0c-8.8 0-16 7.2-16 16zm0 64c0 8.8 7.2 16 16 16l64 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-64 0c-8.8 0-16 7.2-16 16zm0 64c0 8.8 7.2 16 16 16l64 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-64 0c-8.8 0-16 7.2-16 16z"]],
    "paste": [512, 512, ["file-clipboard"], "f0ea", ["M256 224l0 224c0 17.7 14.3 32 32 32l160 0c17.7 0 32-14.3 32-32l0-168.6c0-8.7-3.6-17-9.8-23.1l-57.7-55.4c-6-5.7-13.9-8.9-22.2-8.9L288 192c-17.7 0-32 14.3-32 32z", "M64 32l224 0c17.7 0 32 14.3 32 32l0 48 32 0 0-48c0-35.3-28.7-64-64-64L64 0C28.7 0 0 28.7 0 64L0 384c0 35.3 28.7 64 64 64l112 0 0-32-112 0c-17.7 0-32-14.3-32-32L32 64c0-17.7 14.3-32 32-32zm32 96l128 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L96 96c-8.8 0-16 7.2-16 16s7.2 16 16 16zM448 480l-160 0c-17.7 0-32-14.3-32-32l0-224c0-17.7 14.3-32 32-32l102.3 0c8.3 0 16.2 3.2 22.2 8.9l57.7 55.4c6.3 6 9.8 14.4 9.8 23.1L480 448c0 17.7-14.3 32-32 32zM224 224l0 224c0 35.3 28.7 64 64 64l160 0c35.3 0 64-28.7 64-64l0-168.6c0-17.4-7.1-34.1-19.7-46.2l-57.8-55.4c-11.9-11.4-27.8-17.8-44.3-17.8L288 160c-35.3 0-64 28.7-64 64z"]],
    "inhaler": [640, 512, [], "f5f9", ["M256 272l0 160c0 8.8 7.2 16 16 16l188.3 0c14.1 0 26.6-9.3 30.7-22.8l49.5-165.1-126.1-112.1-31.2 96.9C381.1 251.5 375 256 368 256l-96 0c-8.8 0-16 7.2-16 16z", "M415.4 40.2C423.3 15.8 449 1.9 473.7 8.6L588.5 39.9c26 7.1 41.1 34.3 33.3 60.1L521.6 434.4c-8.1 27.1-33 45.6-61.3 45.6L272 480c-26.5 0-48-21.5-48-48l0-160c0-26.5 21.5-48 48-48l84.3 0 59.1-183.8zm49.9-.7c-8.3-2.3-16.8 2.4-19.4 10.5l-20.8 64.6 1.5 1.4 124 110.2 40.6-135.4c2.6-8.6-2.4-17.7-11.1-20L465.3 39.5zm75.2 220.6L414.4 148 383.2 244.9C381.1 251.5 375 256 368 256l-96 0c-8.8 0-16 7.2-16 16l0 160c0 8.8 7.2 16 16 16l188.3 0c14.1 0 26.6-9.3 30.7-22.8l49.5-165.1zM32 328a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM56 448a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm72-168a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM56 256a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm72 120a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]],
    "meteor": [512, 512, [9732], "f753", ["M32 309.8c0 93.6 75.9 170.2 169.3 170.2 54.4 0 105.4-26.1 137.2-70.2l134.2-185.8-50.6 0c-5.4 0-10.4-2.7-13.4-7.3s-3.4-10.2-1.2-15.2L479.7 37.4c.2-.5 .3-1 .3-1.5 0-2.1-1.7-3.8-3.8-3.8-.5 0-1.1 .1-1.5 .3L310.4 104.6c-4.9 2.2-10.7 1.7-15.2-1.2s-7.3-8-7.3-13.4L288 32 100.3 172.8C57.3 205 32 256 32 309.8zM328 312a128 128 0 1 1 -256 0 128 128 0 1 1 256 0z", "M320 32c0-26.4-30.1-41.4-51.2-25.6L81.1 147.2C30 185.5 0 246.1 0 309.8 0 420.9 90 512 201.3 512 265.9 512 326.6 481 364.4 428.6L498.6 242.7c15.3-21.2 .2-50.7-25.9-50.7L446.6 192 509 50.3c2-4.5 3-9.5 3-14.4 0-19.8-16-35.8-35.8-35.8-5 0-9.9 1-14.4 3L320 65.4 320 32zm154.6 .3c.5-.2 1-.3 1.5-.3 2.1 0 3.8 1.7 3.8 3.8 0 .5-.1 1.1-.3 1.5L407.4 201.6c-2.2 4.9-1.7 10.7 1.2 15.2s8 7.3 13.4 7.3l50.6 0-134.2 185.8C306.7 453.9 255.6 480 201.3 480 107.9 480 32 403.4 32 309.8 32 256 57.3 205 100.3 172.8L288 32 288 89.9c0 5.4 2.7 10.4 7.3 13.4s10.2 3.4 15.2 1.2L474.6 32.3zM296 312a96 96 0 1 1 -192 0 96 96 0 1 1 192 0zM200 184a128 128 0 1 0 0 256 128 128 0 1 0 0-256zM184 304a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm56 48a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"]],
    "honey-pot": [448, 512, [127855], "e418", ["M32 224l384 0c0-53-43-96-96-96l-96 0 0-32 144 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-176 0 0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80-80 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l48 0 0 32c-53 0-96 43-96 96zM60.7 352c23.4 47.9 55.2 78.1 72.7 92.3 2.5 2 6.7 3.7 12.9 3.7l155.3 0c6.3 0 10.5-1.7 12.9-3.7 17.5-14.1 49.4-44.4 72.7-92.3L60.7 352z", "M128 64l32 0 0 80c0 8.8 7.2 16 16 16s16-7.2 16-16l0-80 176 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-144 0 0 32 96 0c53 0 96 43 96 96L32 224c0-53 43-96 96-96l0-32-48 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l48 0zM447.8 237.2c.2-4.3 .2-8.7 .2-13.2 0-42.9-21.1-80.8-53.4-104 12.9-8.6 21.4-23.3 21.4-40 0-26.5-21.5-48-48-48L80 32c-26.5 0-48 21.5-48 48 0 16.7 8.5 31.4 21.4 40-32.3 23.2-53.4 61.2-53.4 104 0 4.5 .1 8.9 .2 13.2-.2 .9-.2 1.8-.2 2.8 0 1.5 .2 2.9 .6 4.3 7.2 126.3 80.7 199 112.7 224.9 9.3 7.5 21.1 10.9 33.1 10.9l155.3 0c12 0 23.7-3.3 33.1-10.9 32-25.9 105.5-98.6 112.7-224.9 .4-1.4 .6-2.8 .6-4.3 0-1-.1-1.9-.2-2.8zM414.4 256c-2.4 23.5-7.3 44.9-13.9 64-.2 0-.3 0-.5 0L48 320c-.2 0-.3 0-.5 0-6.5-19.2-11.5-40.5-13.9-64l380.8 0zm-27.1 96c-23.4 47.9-55.2 78.1-72.7 92.3-2.5 2-6.7 3.7-12.9 3.7l-155.3 0c-6.3 0-10.5-1.7-12.9-3.7-17.5-14.1-49.4-44.4-72.7-92.3l326.6 0z"]],
    "laptop-slash": [640, 512, [], "e1c7", ["M150.5 64l256 256 137.5 0 0-224c0-17.7-14.3-32-32-32L150.5 64zm336 336l48 48 18.4 0c28 0 51.2-20.9 54.7-48l-121 0z", "M59.3-27.2c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l544 544c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-37.7-37.7c42.1-6.2 74.4-42.4 74.4-86.2 0-13.7-11.1-24.9-24.9-24.9l-160.6 0-304-304 361.5 0c17.7 0 32 14.3 32 32l0 224 32 0 0-224c0-35.3-28.7-64-64-64L128 32c-3 0-6 .2-8.9 .6L59.3-27.2zM486.5 400l121 0c-3.5 27.1-26.6 48-54.7 48l-18.4 0-48-48zM64 96l0 224 32 0 0-197.5-31.8-31.8c-.1 1.7-.2 3.5-.2 5.3zM24.9 368C11.1 368 0 379.1 0 392.9 0 441 39 480 87.1 480l366.4 0-32-32-334.4 0c-28 0-51.2-20.9-54.7-48l341 0-32-32-316.6 0z"]],
    "gears": [576, 512, ["cogs"], "f085", ["M33.3 148.8l6.6 24.6c1 3.6 4.3 6.1 8.1 5.9L79.1 178c5-.2 9.9 1.9 13.1 5.8 3.6 4.4 7.7 8.5 12.2 12.2 3.9 3.2 6 8 5.8 13.1l-1.3 31.2c-.2 3.7 2.3 7.1 5.9 8.1l24.6 6.6c3.6 1 7.4-.7 9.2-4L163 223.2c2.3-4.5 6.6-7.6 11.6-8.4 5.7-.9 11.3-2.4 16.6-4.5 4.7-1.8 10-1.2 14.2 1.5l26.3 16.8c3.2 2 7.3 1.6 10-1.1l18-18c2.7-2.7 3.1-6.8 1.1-10l-16.8-26.3c-2.7-4.2-3.2-9.5-1.5-14.2 1-2.7 1.9-5.4 2.6-8.2s1.4-5.6 1.8-8.4c.8-5 3.9-9.2 8.4-11.6l27.7-14.4c3.3-1.7 5-5.5 4-9.2l-6.6-24.6c-1-3.6-4.3-6.1-8.1-5.9L241.3 78c-5 .2-9.9-1.9-13.1-5.8-3.6-4.4-7.7-8.5-12.2-12.2-3.9-3.2-6-8-5.8-13.1l1.3-31.2c.2-3.7-2.3-7.1-5.9-8.1L181 1.1c-3.6-1-7.4 .7-9.2 4L157.4 32.8c-2.3 4.5-6.6 7.6-11.6 8.4-5.7 .9-11.3 2.4-16.6 4.5-4.7 1.8-10 1.2-14.2-1.5L88.7 27.4c-3.2-2-7.3-1.6-10 1.1l-18 18c-2.7 2.7-3.1 6.8-1.1 10L76.4 82.8c2.7 4.2 3.2 9.5 1.5 14.2-1 2.7-1.9 5.4-2.6 8.2s-1.4 5.6-1.8 8.4c-.8 5-3.9 9.2-8.4 11.6L37.3 139.7c-3.3 1.7-5 5.5-4 9.2zm181-6.3a56 56 0 1 1 -108.2-29 56 56 0 1 1 108.2 29zm75 220.7c-1 3.6 .7 7.4 4 9.2L321 386.8c4.5 2.3 7.6 6.6 8.4 11.6 .5 2.8 1.1 5.6 1.8 8.4s1.6 5.6 2.6 8.2c1.8 4.7 1.2 10-1.5 14.2l-16.8 26.3c-2 3.2-1.6 7.3 1.1 10l18 18c2.7 2.7 6.8 3.1 10 1.1L371 467.9c4.2-2.7 9.5-3.2 14.2-1.5 5.4 2 10.9 3.5 16.6 4.5 5 .8 9.2 3.9 11.6 8.4l14.4 27.7c1.7 3.3 5.5 5 9.2 4l24.6-6.6c3.6-1 6.1-4.3 5.9-8.1l-1.3-31.2c-.2-5 1.9-9.9 5.8-13 4.5-3.7 8.5-7.8 12.2-12.2 3.2-3.9 8-6.1 13.1-5.8l31.2 1.3c3.7 .2 7.1-2.3 8.1-5.9l6.6-24.6c1-3.6-.7-7.4-4-9.2l-27.7-14.4c-4.5-2.3-7.6-6.6-8.4-11.6-.5-2.8-1.1-5.6-1.8-8.4s-1.6-5.6-2.6-8.2c-1.8-4.7-1.2-10 1.5-14.2l16.8-26.3c2-3.2 1.6-7.3-1.1-10l-18-18c-2.7-2.7-6.8-3.1-10-1.1l-26.3 16.8c-4.2 2.7-9.5 3.3-14.2 1.5-5.4-2-10.9-3.5-16.6-4.5-5-.8-9.2-3.9-11.6-8.4l-14.4-27.7c-1.7-3.3-5.5-5-9.2-4l-24.6 6.6c-3.6 1-6.1 4.3-5.9 8.1l1.3 31.2c.2 5-1.9 9.9-5.8 13.1-4.5 3.7-8.5 7.8-12.2 12.2-3.2 3.9-8 6.1-13.1 5.8l-31.2-1.3c-3.7-.2-7.1 2.3-8.1 5.9l-6.6 24.6zm181 6.3a56 56 0 1 1 -108.2 29 56 56 0 1 1 108.2-29z", "M181 1.1c-3.6-1-7.4 .7-9.2 4L157.4 32.8c-2.3 4.5-6.6 7.6-11.6 8.4-5.7 .9-11.3 2.4-16.6 4.5-4.7 1.8-10 1.2-14.2-1.5L88.7 27.4c-3.2-2-7.3-1.6-10 1.1l-18 18c-2.7 2.7-3.1 6.8-1.1 10L76.4 82.8c2.7 4.2 3.2 9.5 1.5 14.2-1 2.7-1.9 5.4-2.6 8.2s-1.4 5.6-1.8 8.4c-.8 5-3.9 9.2-8.4 11.6L37.3 139.7c-3.3 1.7-5 5.5-4 9.2l6.6 24.6c1 3.6 4.3 6.1 8.1 5.9L79.1 178c5-.2 9.9 1.9 13.1 5.8 3.6 4.4 7.7 8.5 12.2 12.2 3.9 3.2 6 8 5.8 13.1l-1.3 31.2c-.2 3.7 2.3 7.1 5.9 8.1l24.6 6.6c3.6 1 7.4-.7 9.2-4L163 223.2c2.3-4.5 6.6-7.6 11.6-8.4 5.7-.9 11.3-2.4 16.6-4.5 4.7-1.8 10-1.2 14.2 1.5l26.3 16.8c3.2 2 7.3 1.6 10-1.1l18-18c2.7-2.7 3.1-6.8 1.1-10l-16.8-26.3c-2.7-4.2-3.2-9.5-1.5-14.2 1-2.7 1.9-5.4 2.6-8.2s1.4-5.6 1.8-8.4c.8-5 3.9-9.2 8.4-11.6l27.7-14.4c3.3-1.7 5-5.5 4-9.2l-6.6-24.6c-1-3.6-4.3-6.1-8.1-5.9L241.3 78c-5 .2-9.9-1.9-13.1-5.8-3.6-4.4-7.7-8.5-12.2-12.2-3.9-3.2-6-8-5.8-13.1l1.3-31.2c.2-3.7-2.3-7.1-5.9-8.1L181 1.1zM143.5-9.7c8.7-16.6 27.7-25 45.8-20.1l24.6 6.6c18.1 4.9 30.4 21.6 29.6 40.4l-1 23.5c1.7 1.6 3.4 3.3 5 5l23.6-1c18.7-.8 35.5 11.5 40.4 29.6l6.6 24.6c4.9 18.1-3.5 37.2-20.1 45.8L277 155.6c-.5 2.3-1.2 4.6-1.8 6.8l12.7 19.9c10.1 15.8 7.8 36.5-5.5 49.8l-18 18c-13.3 13.3-33.9 15.5-49.8 5.5L194.7 243c-2.3 .7-4.5 1.3-6.9 1.8l-10.9 20.9c-8.7 16.6-27.7 25-45.8 20.2l-24.6-6.6c-18.1-4.9-30.4-21.6-29.6-40.4l1-23.5c-1.7-1.6-3.4-3.3-5-5l-23.6 1c-18.7 .8-35.5-11.5-40.4-29.6L2.4 157.1c-4.9-18.1 3.5-37.2 20.1-45.8l20.9-10.9c.5-2.3 1.2-4.6 1.8-6.8L32.6 73.6c-10.1-15.8-7.8-36.5 5.5-49.8l18-18C69.3-7.4 90-9.7 105.9 .4L125.7 13c2.3-.7 4.5-1.3 6.9-1.8L143.5-9.7zm2.2 191.8a56 56 0 1 1 29-108.2 56 56 0 1 1 -29 108.2zm37.7-47.9a24 24 0 1 0 -46.4-12.4 24 24 0 1 0 46.4 12.4zM370.8 263.7c-3.6 1-6.1 4.3-5.9 8.1l1.3 31.2c.2 5-1.9 9.9-5.8 13.1-4.5 3.7-8.5 7.8-12.2 12.2-3.2 3.9-8 6.1-13.1 5.8l-31.2-1.3c-3.7-.2-7.1 2.3-8.1 5.9l-6.6 24.6c-1 3.6 .7 7.4 4 9.2L321 386.8c4.5 2.3 7.6 6.6 8.4 11.6 .5 2.8 1.1 5.6 1.8 8.4s1.6 5.6 2.6 8.2c1.8 4.7 1.2 10-1.5 14.2l-16.8 26.3c-2 3.2-1.6 7.3 1.1 10l18 18c2.7 2.7 6.8 3.1 10 1.1L371 467.9c4.2-2.7 9.5-3.2 14.2-1.5 5.4 2 10.9 3.5 16.6 4.5 5 .8 9.2 3.9 11.6 8.4l14.4 27.7c1.7 3.3 5.5 5 9.2 4l24.6-6.6c3.6-1 6.1-4.3 5.9-8.1l-1.3-31.2c-.2-5 1.9-9.9 5.8-13 4.5-3.7 8.5-7.8 12.2-12.2 3.2-3.9 8-6.1 13.1-5.8l31.2 1.3c3.7 .2 7.1-2.3 8.1-5.9l6.6-24.6c1-3.6-.7-7.4-4-9.2l-27.7-14.4c-4.5-2.3-7.6-6.6-8.4-11.6-.5-2.8-1.1-5.6-1.8-8.4s-1.6-5.6-2.6-8.2c-1.8-4.7-1.2-10 1.5-14.2l16.8-26.3c2-3.2 1.6-7.3-1.1-10l-18-18c-2.7-2.7-6.8-3.1-10-1.1l-26.3 16.8c-4.2 2.7-9.5 3.3-14.2 1.5-5.4-2-10.9-3.5-16.6-4.5-5-.8-9.2-3.9-11.6-8.4l-14.4-27.7c-1.7-3.3-5.5-5-9.2-4l-24.6 6.6zm-37.9 9.5c-.8-18.7 11.5-35.5 29.6-40.4l24.6-6.6c18.1-4.9 37.2 3.5 45.8 20.1l10.9 20.9c2.3 .5 4.6 1.2 6.9 1.8l19.9-12.7c15.8-10.1 36.5-7.8 49.8 5.5l18 18c13.3 13.3 15.5 33.9 5.5 49.8l-12.7 19.9c.7 2.2 1.3 4.5 1.8 6.8l20.9 10.9c16.6 8.7 25 27.7 20.2 45.8l-6.6 24.6c-4.9 18.1-21.6 30.4-40.4 29.6l-23.6-1c-1.6 1.7-3.3 3.4-5 5l1 23.5c.8 18.7-11.5 35.5-29.6 40.4l-24.6 6.6c-18.1 4.9-37.2-3.5-45.8-20.2l-10.9-20.9c-2.3-.5-4.6-1.2-6.9-1.8l-19.9 12.7c-15.8 10.1-36.5 7.8-49.8-5.5l-18-18c-13.3-13.3-15.5-33.9-5.5-49.8l12.7-19.9c-.7-2.2-1.3-4.5-1.8-6.8l-20.9-10.9c-16.6-8.7-25-27.7-20.1-45.8l6.6-24.6c4.9-18.1 21.6-30.4 40.4-29.6l23.6 1c1.6-1.7 3.3-3.4 5-5l-1-23.5zm97.8 165a56 56 0 1 1 -29-108.2 56 56 0 1 1 29 108.2zm8.7-60.3a24 24 0 1 0 -46.4 12.4 24 24 0 1 0 46.4-12.4z"]],
    "wave-sine": [576, 512, [8767], "f899", ["", "M38.9 139.8c18.3-45.8 62.6-75.8 111.9-75.8 50.7 0 96 31.7 113.3 79.3l78 214.4c12.7 35 46 58.3 83.2 58.3 36.2 0 68.8-22 82.2-55.7l37.7-94.3c3.3-8.2 12.6-12.2 20.8-8.9s12.2 12.6 8.9 20.8l-37.7 94.3c-18.3 45.8-62.6 75.8-111.9 75.8-50.7 0-96-31.7-113.3-79.3L234 154.3c-12.7-35-46-58.3-83.2-58.3-36.2 0-68.8 22-82.2 55.7L30.9 245.9c-3.3 8.2-12.6 12.2-20.8 8.9s-12.2-12.6-8.9-20.8l37.7-94.3z"]],
    "arrow-turn-left-up": [384, 512, [], "e634", ["", "M368 480c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0c-53 0-96-43-96-96L176 54.6 59.3 171.3c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l144-144c3-3 7.1-4.7 11.3-4.7s8.3 1.7 11.3 4.7l144 144c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L208 54.6 208 416c0 35.3 28.7 64 64 64l96 0z"]],
    "garage": [576, 512, [], "e009", ["M24 509.9c4.8-2.8 8-7.9 8-13.9l0-304 512 0 0 304c0 5.9 3.2 11.1 8 13.9l0 2.1-88 0c8.8 0 16-7.2 16-16l0-208c0-17.7-14.3-32-32-32l-320 0c-17.7 0-32 14.3-32 32l0 208c0 8.8 7.2 16 16 16l-88 0 0-2.1zm8-354.1c0-13.2 8.1-25 20.4-29.8L282.2 36.6c3.7-1.5 7.9-1.5 11.6 0L523.6 126c12.3 4.8 20.4 16.6 20.4 29.8l0 4.2c-170.7 0-341.4 0-512 0l0-4.2z", "M544 192l-512 0 0 304c0 8.8-7.2 16-16 16S0 504.8 0 496L0 155.8c0-26.4 16.2-50.1 40.8-59.6L270.6 6.8c11.2-4.4 23.6-4.4 34.8 0L535.2 96.1c24.6 9.6 40.8 33.3 40.8 59.6L576 496c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-304zm0-32l0-4.2c0-13.2-8.1-25-20.4-29.8L293.8 36.6c-3.7-1.5-7.9-1.5-11.6 0L52.4 126C40.1 130.7 32 142.6 32 155.8l0 4.2 512 0zM128 256l320 0c17.7 0 32 14.3 32 32l0 208c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-112-320 0 0 112c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-208c0-17.7 14.3-32 32-32zm320 96l0-64-320 0 0 64 320 0zM224 448l128 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-128 0c-8.8 0-16-7.2-16-16s7.2-16 16-16z"]],
    "flatbread-stuffed": [512, 512, [129369], "e40c", ["M121.9 435.4L435.5 121.8c28 37.4 44.6 83.8 44.6 134.2 0 123.7-100.3 224-224 224-50.4 0-96.8-16.6-134.2-44.6zM144.1 248c0-39.8 32.2-72 72-72 14.8 0 28.6 4.5 40 12.1-33.3 33.3-66.6 66.6-99.9 99.9-7.7-11.4-12.1-25.2-12.1-40zm80 160a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm80-16a24 24 0 1 0 48 0 24 24 0 1 0 -48 0z", "M32.4 226.8L65 280c6.7 11 9.9 23.8 9 36.7l-3.9 57.4-25.6 25.6c-4.8-5.8-7.3-13.3-6.8-21.2l4.4-64c.4-6.2-1.1-12.5-4.3-17.8L4.4 242.3c-7.1-11.6-5.5-26.7 3.9-36.6l44.1-46.4c4.3-4.5 7.1-10.3 8-16.5l9.3-63.5c2-13.6 12.8-24.1 26.3-25.6l63.2-7.1c6.2-.7 12-3.3 16.6-7.5L223.2-3.8c10.1-9.2 25.1-10.2 36.4-2.7l52.7 35.5c5.1 3.5 11.2 5.2 17.4 5l63.5-2.2c5.5-.2 10.8 1.2 15.3 3.7l-28.8 28.8-49 1.7c-12.9 .4-25.7-3.2-36.4-10.4l-51.1-34.4-46.1 41.6c-9.6 8.6-21.6 14.1-34.5 15.5l-61.6 6.9-9 62.1c-1.9 12.7-7.6 24.6-16.5 33.9L32.4 226.8zm89.5 208.6c37.4 28 83.8 44.6 134.2 44.6 123.7 0 224-100.3 224-224 0-50.4-16.6-96.8-44.6-134.2L121.9 435.4zM414.5 97.6c12.5-12.5 32.9-12.6 43.8 1.3 33.7 43.4 53.8 97.9 53.8 157 0 141.4-114.6 256-256 256-59.2 0-113.7-20.1-157-53.8-13.9-10.9-13.8-31.3-1.3-43.8L414.5 97.6zM248.1 384a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm56 8a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM279 165.2l-22.9 22.9c-11.4-7.7-25.2-12.1-40-12.1-39.8 0-72 32.2-72 72 0 14.8 4.5 28.6 12.1 40l-22.9 22.9c-13.3-17.5-21.2-39.3-21.2-62.9 0-57.4 46.6-104 104-104 23.6 0 45.5 7.9 62.9 21.2z"]],
    "u-turn-down-left": [512, 512, [], "e7ef", ["M32.2 384c.1 .2 .3 .5 .6 .8L144 496 144 432c0-8.8 7.2-16 16-16l144 0c97.2 0 176-78.8 176-176S401.2 64 304 64l-208 0 0 64 208 0c61.8 0 112 50.2 112 112S365.8 352 304 352l-144 0c-8.8 0-16-7.2-16-16l0-64-111.2 111.2c-.3 .3-.4 .6-.6 .8z", "M0 384c0 9.7 4.4 16.7 8.3 21.5l1 1.1 112 112c20.1 20.1 54.6 5.5 54.6-22.6l0-48 128 0c114.9 0 208-93.1 208-208S418.9 32 304 32l-208 0-3.3 .2C76.6 33.8 64 47.4 64 64l0 64 .2 3.3C65.8 147.4 79.4 160 96 160l208 0c44.2 0 80 35.8 80 80s-35.8 80-80 80l-128 0 0-48c0-28.1-34.5-42.7-54.6-22.6l-112 112-1 1.1C4.4 367.3 0 374.3 0 384l0 0zm32.8-.8L144 272 144 336c0 8.8 7.2 16 16 16l144 0c61.8 0 112-50.1 112-112S365.8 128 304 128l-208 0 0-64 208 0c97.2 0 176 78.8 176 176S401.2 416 304 416l-144 0c-8.8 0-16 7.2-16 16l0 64-111.2-111.2c-.3-.3-.4-.6-.6-.8 .1-.2 .3-.5 .6-.8z"]],
    "face-shaking-horizontal": [640, 512, [], "e79d", ["M64 256c0-123.7 100.3-224 224-224 82.9 0 155.3 45 194 112l36.2 0c7.4 15.2 13.4 31.3 17.7 48L464 192c-8.8 0-16 7.2-16 16s7.2 16 16 16l78 0c1.3 10.5 2 21.2 2 32s-.7 21.5-2 32l-78 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l71.9 0c-4.3 16.7-10.3 32.8-17.7 48L482 368c-38.7 67-111.1 112-194 112-123.7 0-224-100.3-224-224zm48-40c0 8.8 7.2 16 16 16s16-7.2 16-16c0-13.3 10.7-24 24-24l16 0c13.3 0 24 10.7 24 24 0 8.8 7.2 16 16 16s16-7.2 16-16c0-30.9-25.1-56-56-56l-16 0c-30.9 0-56 25.1-56 56zm22.3 127.9c29.3 34.3 73 56.1 121.7 56.1s92.4-21.8 121.7-56.1c5.7-6.7 5-16.8-1.8-22.6s-16.8-5-22.6 1.8C329.8 350.6 295 368 256 368s-73.8-17.4-97.3-44.9c-5.7-6.7-15.8-7.5-22.6-1.8s-7.5 15.8-1.8 22.6zM272 216c0 8.8 7.2 16 16 16s16-7.2 16-16c0-13.3 10.7-24 24-24l16 0c13.3 0 24 10.7 24 24 0 8.8 7.2 16 16 16s16-7.2 16-16c0-30.9-25.1-56-56-56l-16 0c-30.9 0-56 25.1-56 56z", "M288 480c82.9 0 155.3-45 194-112l36.2 0c-41.5 85.3-129 144-230.3 144-141.4 0-256-114.6-256-256S146.6 0 288 0C389.2 0 476.7 58.7 518.3 144L482 144C443.3 77 370.9 32 288 32 164.3 32 64 132.3 64 256S164.3 480 288 480zM158.7 323.1C182.2 350.6 217 368 256 368s73.8-17.4 97.3-44.9c5.7-6.7 15.8-7.5 22.6-1.8s7.5 15.8 1.8 22.6C348.4 378.2 304.7 400 256 400s-92.4-21.8-121.7-56.1c-5.7-6.7-5-16.8 1.8-22.6s16.8-5 22.6 1.8zM168 192c-13.3 0-24 10.7-24 24 0 8.8-7.2 16-16 16s-16-7.2-16-16c0-30.9 25.1-56 56-56l16 0c30.9 0 56 25.1 56 56 0 8.8-7.2 16-16 16s-16-7.2-16-16c0-13.3-10.7-24-24-24l-16 0zm136 24c0 8.8-7.2 16-16 16s-16-7.2-16-16c0-30.9 25.1-56 56-56l16 0c30.9 0 56 25.1 56 56 0 8.8-7.2 16-16 16s-16-7.2-16-16c0-13.3-10.7-24-24-24l-16 0c-13.3 0-24 10.7-24 24zM544 80c0-8.8 7.2-16 16-16 44.2 0 80 35.8 80 80s-35.8 80-80 80l-96 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l96 0c26.5 0 48-21.5 48-48s-21.5-48-48-48c-8.8 0-16-7.2-16-16zm16 208c18.8 0 35.1-10.8 42.9-26.5 13.8-6 26.3-14.3 37-24.5 0 1 .1 2 .1 3 0 44.2-35.8 80-80 80l-96 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l96 0z"]],
    "eyes": [576, 512, [], "e367", ["M32 288a48 48 0 1 0 96 0 48 48 0 1 0 -96 0zm272 0a48 48 0 1 0 96 0 48 48 0 1 0 -96 0z", "M272 256c0 56.3-15.5 105.9-39 140.4-23.6 34.7-52.8 51.6-81 51.6s-57.4-16.8-81-51.6c-6.7-9.9-12.8-21-18-33.1 8.4 3 17.5 4.7 27 4.7 44.2 0 80-35.8 80-80s-35.8-80-80-80c-17.2 0-33.1 5.4-46.1 14.6 4.8-42.4 18.4-79.5 37.1-107.1 23.6-34.7 52.8-51.6 81-51.6s57.4 16.8 81 51.6c23.5 34.6 39 84.1 39 140.4zm16-100.1C263.1 82.4 211.5 32 152 32 68.1 32 0 132.3 0 256S68.1 480 152 480c59.5 0 111.1-50.4 136-123.9 24.9 73.4 76.5 123.9 136 123.9 83.9 0 152-100.3 152-224S507.9 32 424 32c-59.5 0-111.1 50.4-136 123.9zm55 240.6c-6.7-9.9-12.8-21-18-33.1 8.4 3 17.5 4.7 27 4.7 44.2 0 80-35.8 80-80s-35.8-80-80-80c-17.2 0-33.1 5.4-46.1 14.6 4.8-42.4 18.4-79.5 37.1-107.1 23.6-34.7 52.8-51.6 81-51.6s57.4 16.8 81 51.6c23.5 34.6 39 84.1 39 140.4s-15.5 105.9-39 140.4c-23.6 34.7-52.8 51.6-81 51.6s-57.4-16.8-81-51.6zM32 288a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm320-48a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"]],
    "dash": [512, 512, ["minus-large"], "e404", ["", "M0 256c0-8.8 7.2-16 16-16l480 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L16 272c-8.8 0-16-7.2-16-16z"]],
    "photo-film-music": [640, 512, [], "e228", ["M224 64l0 224c0 17.7 14.3 32 32 32l112 0 0-32.2-72 0c-14.5 0-27.9-7.8-34.9-20.5s-6.7-28.2 .9-40.5l39.4-63.9c7-11.4 19.2-18.5 32.6-19s26 5.7 33.9 16.5l4.7 6.5 42.6-61.7c7.4-10.7 19.4-17.1 32.4-17.3s25.2 5.9 32.8 16.3L544 191.3c10.7-2.2 21.3-4.4 32-6.7L576 64c0-17.7-14.3-32-32-32L256 32c-17.7 0-32 14.3-32 32zm88 32a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M544 32L256 32c-17.7 0-32 14.3-32 32l0 224c0 17.7 14.3 32 32 32l112 0 0 32-112 0c-35.3 0-64-28.7-64-64l0-224c0-35.3 28.7-64 64-64L544 0c35.3 0 64 28.7 64 64l0 114-32 6.7 0-120.6c0-17.7-14.3-32-32-32zM224 448l56.4 0c-4.3 9.8-7.1 20.5-8 32L64 480c-35.3 0-64-28.7-64-64L0 192c0-35.3 28.7-64 64-64l80 0 0 32-16 0 0 288 96 0zM544 191.3l-34.4 7.2-55.1-75.2c-1.5-2.1-4-3.3-6.6-3.3s-5 1.3-6.5 3.5L386 203.7c-3 4.3-7.8 6.9-13 6.9s-10.1-2.4-13.1-6.6l-18-24.8c-1.6-2.2-4.1-3.4-6.8-3.3s-5.1 1.5-6.5 3.8l-39.4 63.9c-1.5 2.5-1.6 5.6-.2 8.1s4.1 4.1 7 4.1l76.7 0c-3.1 7.5-4.7 15.7-4.7 24.2l0 7.8-72 0c-14.5 0-27.9-7.8-34.9-20.5s-6.7-28.2 .9-40.5l39.4-63.9c7-11.4 19.2-18.5 32.6-19s26 5.7 33.9 16.5l4.7 6.5 42.6-61.7c7.4-10.7 19.4-17.1 32.4-17.3s25.2 5.9 32.8 16.3L544 191.3zM264 96a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM96 240l0-80-32 0c-17.7 0-32 14.3-32 32l0 48 64 0zm0 128l-64 0 0 48c0 17.7 14.3 32 32 32l32 0 0-80zm0-96l-64 0 0 64 64 0 0-64zm544-32.1l0 216.1c0 30.7-28.4 56-64 56s-64-25.3-64-56 28.4-56 64-56c11.7 0 22.6 2.7 32 7.5l0-67.9-160 33.3 0 115.1c0 30.7-28.4 56-64 56s-64-25.3-64-56 28.4-56 64-56c11.7 0 22.6 2.7 32 7.5l0-159.6c0-7.6 5.3-14.1 12.7-15.7l192-40c4.7-1 9.6 .2 13.4 3.2s5.9 7.6 5.9 12.4zm-32 67l0-47.3-160 33.3 0 47.3 160-33.3zM352 487.9c0 9.6 10.4 24 32 24s32-14.4 32-24-10.4-24-32-24-32 14.4-32 24zm224-56c-21.6 0-32 14.4-32 24s10.4 24 32 24 32-14.4 32-24-10.4-24-32-24z"]],
    "location-arrow-slash": [576, 512, [], "e77a", ["M218.9 164.4L480 64 379.6 325.1 218.9 164.4z", "M27.3-27.2c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l544 544c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-167-167 105.5-274.3c4.5-11.8 1.7-25.2-7.2-34.1s-22.3-11.8-34.1-7.2L194.2 139.6 27.3-27.2zM218.9 164.4L480 64 379.6 325.1 218.9 164.4zM52.5 194.1C39.9 199 31.7 211.2 32 224.7s9.1 25.4 21.9 29.6l176.8 58.9 58.9 176.8c4.3 12.8 16.1 21.6 29.6 21.9s25.7-7.9 30.6-20.5l23.1-60-24.8-24.8-28.2 73.3-50.7-152.2-53-53-152.2-50.7 73.3-28.2-24.8-24.8-60 23.1z"]],
    "circle-m": [512, 512, [], "e115", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm128-80c0-7 4.5-13.1 11.1-15.2s13.9 .3 17.9 5.9l67 93.8 67-93.8c4-5.7 11.3-8.1 17.9-5.9S352 169 352 176l0 160c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-110.1-51 71.4c-3 4.2-7.9 6.7-13 6.7s-10-2.5-13-6.7l-51-71.4 0 110.1c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-160z", "M256 32a224 224 0 1 1 0 448 224 224 0 1 1 0-448zm0 480a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM189 166.7c-4-5.7-11.3-8.1-17.9-5.9S160 169 160 176l0 160c0 8.8 7.2 16 16 16s16-7.2 16-16l0-110.1 51 71.4c3 4.2 7.9 6.7 13 6.7s10-2.5 13-6.7l51-71.4 0 110.1c0 8.8 7.2 16 16 16s16-7.2 16-16l0-160c0-7-4.5-13.1-11.1-15.2S327 161 323 166.7l-67 93.8-67-93.8z"]],
    "arrow-up-to-dotted-line": [384, 512, [], "e0a1", ["", "M48 24A24 24 0 1 1 0 24 24 24 0 1 1 48 24zM180.7 132.7c6.2-6.2 16.4-6.2 22.6 0l144 144c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L208 182.6 208 496c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-313.4-116.7 116.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l144-144zM136 48a24 24 0 1 1 0-48 24 24 0 1 1 0 48zM272 24a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm88 24a24 24 0 1 1 0-48 24 24 0 1 1 0 48z"]],
    "file-circle-plus": [576, 512, [58606], "e494", ["M64 64c0-17.7 14.3-32 32-32l128 0 0 96c0 35.3 28.7 64 64 64l96 0 0 22c-82.8 21.3-144 96.5-144 186 0 28.6 6.2 55.6 17.4 80L96 480c-17.7 0-32-14.3-32-32L64 64z", "M224 32L96 32C78.3 32 64 46.3 64 64l0 384c0 17.7 14.3 32 32 32l161.4 0c5.2 11.3 11.4 22 18.6 32L96 512c-35.3 0-64-28.7-64-64L32 64C32 28.7 60.7 0 96 0L229.5 0c17 0 33.3 6.7 45.3 18.7L397.3 141.3c12 12 18.7 28.3 18.7 45.3l0 22.1c-11 .9-21.6 2.7-32 5.4l0-22-96 0c-35.3 0-64-28.7-64-64l0-96zM370.7 160L256 45.3 256 128c0 17.7 14.3 32 32 32l82.7 0zM544 400a112 112 0 1 0 -224 0 112 112 0 1 0 224 0zm-256 0a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm160-64l0 48 48 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-48 0 0 48c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-48-48 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l48 0 0-48c0-8.8 7.2-16 16-16s16 7.2 16 16z"]],
    "mustache": [640, 512, [], "e5bc", ["M32 190.7L32 204c0 90.6 73.4 164 164 164 35.5 0 70-11.5 98.4-32.8l16-12c5.7-4.3 13.5-4.3 19.2 0l16 12c28.4 21.3 62.9 32.8 98.4 32.8 90.6 0 164-73.4 164-164l0-13.3c-45.7 24.4-103.1 16.8-140.9-21-16.4-16.4-38.8-25.7-62-25.7l-3.3 0c-18.9 0-37.3 5.6-53 16.1l-19.9 13.3c-5.4 3.6-12.4 3.6-17.8 0l-19.9-13.3c-15.7-10.5-34.1-16.1-53-16.1l-3.3 0c-23.3 0-45.6 9.2-62 25.7-37.8 37.8-95.3 45.4-140.9 21z", "M235 112c-31.7 0-62.2 12.6-84.6 35.1-31.6 31.6-81.9 34.4-116.8 6.5l-7.5-6c-5.1-4.1-12-4.5-17.5-1.6-1.4 .7-2.7 1.7-3.8 2.8-2.9 2.9-4.7 6.9-4.7 11.3l0 44c0 108.2 87.8 196 196 196 42.4 0 83.7-13.8 117.6-39.2l6.4-4.8 6.4 4.8c33.9 25.4 75.2 39.2 117.6 39.2 108.2 0 196-87.8 196-196l0-44c0-4.4-1.8-8.4-4.6-11.3-1.1-1.2-2.4-2.1-3.8-2.8-5.5-2.9-12.4-2.5-17.5 1.6l-7.5 6c-34.9 27.9-85.2 25.1-116.8-6.5-22.4-22.4-52.9-35.1-84.6-35.1l-3.3 0c-25.2 0-49.8 7.5-70.8 21.4l-11 7.3-11-7.3c-21-14-45.6-21.4-70.8-21.4l-3.3 0zm373 78.7l0 13.3c0 90.6-73.4 164-164 164-35.5 0-70-11.5-98.4-32.8l-16-12c-5.7-4.3-13.5-4.3-19.2 0l-16 12C266 356.5 231.5 368 196 368 105.4 368 32 294.6 32 204l0-13.3c45.7 24.4 103.1 16.8 140.9-21 16.4-16.4 38.8-25.7 62-25.7l3.3 0c18.9 0 37.3 5.6 53 16.1l19.9 13.3c5.4 3.6 12.4 3.6 17.8 0l19.9-13.3c15.7-10.5 34.1-16.1 53-16.1l3.3 0c23.3 0 45.6 9.2 62 25.7 37.8 37.8 95.3 45.4 140.9 21z"]],
    "window-frame": [448, 512, [129695], "e04f", ["M64 64l0 176 144 0 0-208-112 0C78.3 32 64 46.3 64 64zm0 208l0 208 144 0 0-208-144 0zM240 32l0 208 144 0 0-176c0-17.7-14.3-32-32-32L240 32zm0 240l0 208 144 0 0-208-144 0z", "M352 0c35.3 0 64 28.7 64 64l0 416 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L16 512c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0 0-416C32 28.7 60.7 0 96 0L352 0zM64 240l144 0 0-208-112 0C78.3 32 64 46.3 64 64l0 176zm0 32l0 208 144 0 0-208-144 0zm176 0l0 208 144 0 0-208-144 0zm144-32l0-176c0-17.7-14.3-32-32-32l-112 0 0 208 144 0z"]],
    "house-night": [640, 512, [], "e010", ["M32 80c0 44.2 35.8 80 80 80 12 0 23.3-2.6 33.5-7.3-38.4-15.3-65.5-52.8-65.5-96.7 0-19.9 5.6-38.5 15.3-54.2-36.1 7.7-63.3 39.8-63.3 78.2zM208 264.5L208 480c0 17.7 14.3 32 32 32l256 0c17.7 0 32-14.3 32-32l0-215.5-160-154.3-160 154.3zM304 312c0-22.1 17.9-40 40-40l48 0c22.1 0 40 17.9 40 40l0 48c0 22.1-17.9 40-40 40l-48 0c-22.1 0-40-17.9-40-40l0-48z", "M272-48c-8.8 0-16 7.2-16 16l0 32-32 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l32 0 0 32c0 8.8 7.2 16 16 16s16-7.2 16-16l0-32 32 0c8.8 0 16-7.2 16-16S328.8 0 320 0l-32 0 0-32c0-8.8-7.2-16-16-16zM127-31c-4.9-.7-9.9-1-15-1-61.9 0-112 50.1-112 112S50.1 192 112 192c30.6 0 58.4-12.3 78.6-32.2 .7-.6 1.3-1.3 1.9-2 6-6.2 10.8-12.6 14.8-19 3.9-6.2-3.2-13.3-10.4-12-2.4 .4-4.9 .8-7.5 .9-3.4 .3-7.5 .3-11.9-.1-.4 0-.8-.1-1.2-.1-36.1-3.8-64.3-34.4-64.3-71.6 0-20.8 8.8-39.5 22.9-52.7 .3-.3 .6-.5 .9-.8 2.9-2.7 6.1-5.1 9.4-7.2 2.1-1.4 4.3-2.6 6.6-3.7 6.6-3.3 8-13.2 1.1-15.9-7-2.7-14.7-5-23.2-6.3-.9-.1-1.8-.3-2.7-.4zM80 56c0 43.9 27.1 81.4 65.5 96.7-10.2 4.7-21.6 7.3-33.5 7.3-44.2 0-80-35.8-80-80 0-38.4 27.1-70.5 63.3-78.2-9.7 15.8-15.3 34.4-15.3 54.2zM379.1 76.5c-6.2-6-16-6-22.2 0l-224 216c-6.4 6.1-6.5 16.3-.4 22.6s16.3 6.5 22.6 .4L176 295.4 176 480c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-184.6 20.9 20.2c6.4 6.1 16.5 5.9 22.6-.4s5.9-16.5-.4-22.6l-224-216zM528 264.5L528 480c0 17.7-14.3 32-32 32l-256 0c-17.7 0-32-14.3-32-32l0-215.5 160-154.3 160 154.3zM304 312l0 48c0 22.1 17.9 40 40 40l48 0c22.1 0 40-17.9 40-40l0-48c0-22.1-17.9-40-40-40l-48 0c-22.1 0-40 17.9-40 40zm40-8l48 0c4.4 0 8 3.6 8 8l0 48c0 4.4-3.6 8-8 8l-48 0c-4.4 0-8-3.6-8-8l0-48c0-4.4 3.6-8 8-8zM560 16c-8.8 0-16 7.2-16 16l0 32-32 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l32 0 0 32c0 8.8 7.2 16 16 16s16-7.2 16-16l0-32 32 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-32 0 0-32c0-8.8-7.2-16-16-16z"]],
    "reel": [448, 512, [], "e238", ["M64 96l0 64c0 8.8 7.2 16 16 16l288 0c8.8 0 16-7.2 16-16l0-64-32 0 0-64-256 0 0 64-32 0zm0 64l0 96c0-8.8 7.2-16 16-16l304 0 0-80c0-8.8-7.2-16-16-16L80 144c-8.8 0-16 7.2-16 16zm0 96l0 96c0 8.8 7.2 16 16 16l288 0c8.8 0 16-7.2 16-16l0-80-304 0c-8.8 0-16-7.2-16-16zm0 96l0 64 32 0 0 64 256 0 0-64 32 0 0-64c0-8.8-7.2-16-16-16L80 336c-8.8 0-16 7.2-16 16z", "M32 16C32 7.2 39.2 0 48 0L400 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0 0 64-32 0 0-64-256 0 0 64-32 0 0-64-16 0c-8.8 0-16-7.2-16-16zm0 480c0-8.8 7.2-16 16-16l16 0 0-64 32 0 0 64 256 0 0-64 32 0 0 64 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L48 512c-8.8 0-16-7.2-16-16zM80 144l288 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L80 176c-8.8 0-16-7.2-16-16s7.2-16 16-16zm0 96l352 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L80 272c-8.8 0-16-7.2-16-16s7.2-16 16-16zM64 352c0-8.8 7.2-16 16-16l288 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L80 368c-8.8 0-16-7.2-16-16z"]],
    "icicles": [512, 512, [], "f7ad", ["M32 36.6c0 .5 .1 1 .2 1.5l71.8 215.3 32.8-98.5c2.3-6.9 8.9-11.4 16.2-10.9s13.3 5.7 14.7 12.8L200 318.4 232.3 156.9c1.5-7.3 7.7-12.6 15.1-12.9s14 4.6 16 11.7l23.8 85.6 33.3-133.2c1.8-7.3 8.5-12.3 16-12.1s13.9 5.7 15.2 13L408.2 410.4 479.9 39c.1-.4 .1-.7 .1-1.1 0-3.3-2.6-5.9-5.9-5.9L36.6 32c-2.6 0-4.6 2.1-4.6 4.6z", "M0 36.6C0 16.4 16.4 0 36.6 0L474.1 0c20.9 0 37.9 17 37.9 37.9 0 2.4-.2 4.8-.7 7.2L423.7 499c-1.5 7.5-8.1 13-15.8 13s-14.3-5.5-15.7-13.1l-58.5-312-30.2 121c-1.8 7-8.1 12-15.3 12.1s-13.7-4.7-15.6-11.7l-22-79.4-34.8 174.2c-1.5 7.5-8.1 12.9-15.7 12.9s-14.2-5.4-15.7-12.9l-36.2-180.9-28.9 86.8C117 315.6 110.9 320 104 320s-13-4.4-15.2-10.9L1.9 48.2C.6 44.5 0 40.6 0 36.6zM36.6 32c-2.6 0-4.6 2.1-4.6 4.6 0 .5 .1 1 .2 1.5l71.8 215.3 32.8-98.5c2.3-6.9 8.9-11.4 16.2-10.9s13.3 5.7 14.7 12.8L200 318.4 232.3 156.9c1.5-7.3 7.7-12.6 15.1-12.9s14 4.6 16 11.7l23.8 85.6 33.3-133.2c1.8-7.3 8.5-12.3 16-12.1s13.9 5.7 15.2 13L408.2 410.4 479.9 39c.1-.4 .1-.7 .1-1.1 0-3.3-2.6-5.9-5.9-5.9L36.6 32z"]],
    "binary-slash": [576, 512, [], "e33e", ["", "M27.3-27.2c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l544 544c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L480 425.5 480 352c0-35.3-28.7-64-64-64l-64 0c-3 0-6 .2-8.9 .6l-78.9-78.9C278.8 198 288 180.1 288 160l0-96c0-35.3-28.7-64-64-64L160 0c-28.5 0-52.7 18.7-61 44.5L27.3-27.2zM128 73.5l0-9.5c0-17.7 14.3-32 32-32l64 0c17.7 0 32 14.3 32 32l0 96c0 11.3-5.8 21.2-14.6 26.9L128 73.5zM374.5 320l41.5 0c17.7 0 32 14.3 32 32l0 41.5-73.5-73.5zm-86.3 26.7c-.1 1.7-.2 3.5-.2 5.3l0 96c0 35.3 28.7 64 64 64l64 0c10.9 0 21.1-2.7 30-7.5l-24.9-24.9c-1.7 .3-3.4 .4-5.1 .4l-64 0c-17.7 0-32-14.3-32-32l0-69.5-31.8-31.8zM409.8 3.4c-3.9-3-8.9-4.1-13.7-2.9l-64 16c-8.6 2.1-13.8 10.8-11.6 19.4s10.8 13.8 19.4 11.6l44.1-11 0 155.5-48 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l128 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-48 0 0-176c0-4.9-2.3-9.6-6.2-12.6zm-224 288c-3.9-3-8.9-4.1-13.7-2.9l-64 16c-8.6 2.1-13.8 10.8-11.6 19.4s10.8 13.8 19.4 11.6l44.1-11 0 155.5-48 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l128 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-48 0 0-176c0-4.9-2.3-9.6-6.2-12.6z"]],
    "square-sliders-vertical": [448, 512, ["sliders-v-square"], "f3f2", ["M32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64C46.3 64 32 78.3 32 96zM88 208c0-8.8 7.2-16 16-16l24 0 0-48c0-8.8 7.2-16 16-16s16 7.2 16 16l0 48 24 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-24 0 0 144c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-144-24 0c-8.8 0-16-7.2-16-16zm160 96c0-8.8 7.2-16 16-16l24 0 0-144c0-8.8 7.2-16 16-16s16 7.2 16 16l0 144 24 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-24 0 0 48c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-48-24 0c-8.8 0-16-7.2-16-16z", "M384 64c17.7 0 32 14.3 32 32l0 320c0 17.7-14.3 32-32 32L64 448c-17.7 0-32-14.3-32-32L32 96c0-17.7 14.3-32 32-32l320 0zM64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm80 96c-8.8 0-16 7.2-16 16l0 48-24 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l24 0 0 144c0 8.8 7.2 16 16 16s16-7.2 16-16l0-144 24 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-24 0 0-48c0-8.8-7.2-16-16-16zm160 0c-8.8 0-16 7.2-16 16l0 144-24 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l24 0 0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48 24 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-24 0 0-144c0-8.8-7.2-16-16-16z"]],
    "arrow-trend-up": [576, 512, [], "e098", ["M0 400c0 4.1 1.6 8.2 4.7 11.3 6.2 6.2 16.4 6.2 22.6 0L192 246.6 308.7 363.3c6.2 6.2 16.4 6.2 22.6 0L544 150.6 544 288c0 8.8 7.2 16 16 16s16-7.2 16-16l0 160c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64l0-48z", "M368 112c0-8.8 7.2-16 16-16l176 0c8.8 0 16 7.2 16 16l0 176c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-137.4-212.7 212.7c-6.2 6.2-16.4 6.2-22.6 0L192 246.6 27.3 411.3c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l176-176c6.2-6.2 16.4-6.2 22.6 0L320 329.4 521.4 128 384 128c-8.8 0-16-7.2-16-16z"]],
    "timeline-arrow": [576, 512, [], "e29d", ["M48 96a48 48 0 1 0 96 0 48 48 0 1 0 -96 0zM176 416a48 48 0 1 0 96 0 48 48 0 1 0 -96 0zM304 96a48 48 0 1 0 96 0 48 48 0 1 0 -96 0z", "M144 96a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zm32 0c0 38.7-27.5 71-64 78.4l0 81.6 224 0 0-81.6c-36.5-7.4-64-39.7-64-78.4 0-44.2 35.8-80 80-80s80 35.8 80 80c0 38.7-27.5 71-64 78.4l0 81.6 153.4 0-44.7-44.7c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l72 72c6.2 6.2 6.2 16.4 0 22.6l-72 72c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l44.7-44.7-281.4 0 0 49.6c36.5 7.4 64 39.7 64 78.4 0 44.2-35.8 80-80 80s-80-35.8-80-80c0-38.7 27.5-71 64-78.4l0-49.6-192 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l64 0 0-81.6C43.5 167 16 134.7 16 96 16 51.8 51.8 16 96 16s80 35.8 80 80zm176 48a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM272 416a48 48 0 1 0 -96 0 48 48 0 1 0 96 0z"]],
    "fort": [576, 512, [], "e486", ["M32 128l0 80c0 8.8 7.2 16 16 16l160 0c8.8 0 16-7.2 16-16l0-80-192 0zM64 256l0 192c0 17.7 14.3 32 32 32l112 0 0-64c0-44.2 35.8-80 80-80s80 35.8 80 80l0 64 112 0c17.7 0 32-14.3 32-32l0-192-144 0c-26.5 0-48-21.5-48-48l0-16-64 0 0 16c0 26.5-21.5 48-48 48L64 256zM352 128l0 80c0 8.8 7.2 16 16 16l160 0c8.8 0 16-7.2 16-16l0-80-192 0z", "M16 32c8.8 0 16 7.2 16 16l0 48 80 0 0-48c0-8.8 7.2-16 16-16s16 7.2 16 16l0 48 80 0 0-48c0-8.8 7.2-16 16-16s16 7.2 16 16l0 112 64 0 0-112c0-8.8 7.2-16 16-16s16 7.2 16 16l0 48 80 0 0-48c0-8.8 7.2-16 16-16s16 7.2 16 16l0 48 80 0 0-48c0-8.8 7.2-16 16-16s16 7.2 16 16l0 160c0 20.9-13.4 38.7-32 45.3L544 448c0 35.3-28.7 64-64 64L96 512c-35.3 0-64-28.7-64-64l0-194.7C13.4 246.7 0 228.9 0 208L0 48c0-8.8 7.2-16 16-16zM240 480l96 0 0-64c0-26.5-21.5-48-48-48s-48 21.5-48 48l0 64zm128 0l112 0c17.7 0 32-14.3 32-32l0-192-144 0c-26.5 0-48-21.5-48-48l0-16-64 0 0 16c0 26.5-21.5 48-48 48l-144 0 0 192c0 17.7 14.3 32 32 32l112 0 0-64c0-44.2 35.8-80 80-80s80 35.8 80 80l0 64zM544 128l-192 0 0 80c0 8.8 7.2 16 16 16l160 0c8.8 0 16-7.2 16-16l0-80zM32 208c0 8.8 7.2 16 16 16l160 0c8.8 0 16-7.2 16-16l0-80-192 0 0 80z"]],
    "circle-v": [512, 512, [], "e12a", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm129.7-72.8c-4-7.9-.7-17.5 7.2-21.5s17.5-.7 21.5 7.2L256 300.2 321.7 168.8c4-7.9 13.6-11.1 21.5-7.2s11.1 13.6 7.2 21.5l-80 160c-2.7 5.4-8.2 8.8-14.3 8.8s-11.6-3.4-14.3-8.8l-80-160z", "M256 32a224 224 0 1 1 0 448 224 224 0 1 1 0-448zm0 480a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM190.3 168.8c-4-7.9-13.6-11.1-21.5-7.2s-11.1 13.6-7.2 21.5l80 160c2.7 5.4 8.3 8.8 14.3 8.8s11.6-3.4 14.3-8.8l80-160c4-7.9 .7-17.5-7.2-21.5s-17.5-.7-21.5 7.2L256 300.2 190.3 168.8z"]],
    "hexagon-nodes-bolt": [576, 512, [], "e69a", ["M35.2 148a24 24 0 1 0 41.6 24A24 24 0 1 0 35.2 148zm0 216a24 24 0 1 0 41.6-24A24 24 0 1 0 35.2 364zM200 56a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm0 200a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm0 200a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zM371.2 172a24 24 0 1 0 41.6-24 24 24 0 1 0 -41.6 24z", "M200 56a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm40 53.7c23.1-6.9 40-28.3 40-53.7c0-30.9-25.1-56-56-56s-56 25.1-56 56c0 25.4 16.9 46.8 40 53.7l0 92.6c-8.6 2.6-16.3 7.1-22.7 13.2l-74.8-42.7c5.5-23.4-4.7-48.6-26.5-61.2C57.2 96 23 105.2 7.5 132S1.2 193 28 208.5c3.9 2.2 7.9 4 12 5.2l0 84.6c-4.1 1.2-8.1 2.9-12 5.2C1.2 319-8 353.2 7.5 380S57.2 416 84 400.5c21.9-12.6 32-37.8 26.5-61.3l46.3-26.4c-6.9-8.1-12.3-17.5-15.9-27.8L94.7 311.5c-6.5-6.2-14.3-10.6-22.7-13.1l0-84.7c8.4-2.5 16.2-6.9 22.7-13.1l74.8 42.7c-1 4.1-1.5 8.4-1.5 12.7c0 25.4 16.9 46.8 40 53.7l0 92.6c-23.1 6.9-40 28.3-40 53.7c0 30.9 25.1 56 56 56c30.7 0 55.6-24.7 56-55.2c-7.5-12.9-13.5-26.8-17.6-41.5c-6.3-5.9-13.9-10.4-22.4-12.9l0-92.6c8.6-2.6 16.3-7.1 22.7-13.2l6.8 3.9c4.1-9.9 9.2-19.4 15-28.3l-5.9-3.3c1-4.1 1.5-8.4 1.5-12.7c0-25.4-16.9-46.8-40-53.7l0-92.6zM440.5 132C425 105.2 390.8 96 364 111.5c-21.9 12.6-32 37.8-26.6 61.2l-46.3 26.4c6.9 8.1 12.3 17.5 15.9 27.8l46.2-26.4c2.5 2.3 5.1 4.4 7.9 6.3c21.7-9.5 45.6-14.8 70.8-14.8c2 0 4 0 5.9 .1c12.1-17.3 13.8-40.6 2.6-60.1zM380 139.2a24 24 0 1 1 24 41.6 24 24 0 1 1 -24-41.6zM35.2 148a24 24 0 1 1 41.6 24A24 24 0 1 1 35.2 148zM200 456a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM76.8 340A24 24 0 1 1 35.2 364a24 24 0 1 1 41.6-24zM224 232a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm96 136a112 112 0 1 1 224 0 112 112 0 1 1 -224 0zm256 0a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-96.1-81c-4.3-3.7-10.6-4-15.1-.6l-96 72c-4.1 3.1-5.8 8.5-4.2 13.4s6.2 8.2 11.4 8.2l35.6 0-30.1 54.2c-2.8 5-1.7 11.1 2.6 14.9s10.6 4 15.1 .6l96-72c4.1-3.1 5.8-8.5 4.2-13.4s-6.2-8.2-11.4-8.2l-35.6 0 30.1-54.2c2.8-5 1.7-11.1-2.6-14.9z"]],
    "light-emergency-on": [640, 512, [], "e420", ["M128 368l0 64c0 8.8 7.2 16 16 16l352 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16l-352 0c-8.8 0-16 7.2-16 16zm64-176l0 128 256 0 0-128c0-70.7-57.3-128-128-128S192 121.3 192 192zm32 0c0-53 43-96 96-96 8.8 0 16 7.2 16 16s-7.2 16-16 16c-35.3 0-64 28.7-64 64 0 8.8-7.2 16-16 16s-16-7.2-16-16z", "M55.2 33.7l64 32c7.9 4 11.1 13.6 7.2 21.5s-13.6 11.1-21.5 7.2l-64-32c-7.9-4-11.1-13.6-7.2-21.5s13.6-11.1 21.5-7.2zm544 28.6l-64 32c-7.9 4-17.5 .7-21.5-7.2s-.7-17.5 7.2-21.5l64-32c7.9-4 17.5-.7 21.5 7.2s.7 17.5-7.2 21.5zM16 192l64 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-64 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zm544 0l64 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-64 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zM480 320l16 0c26.5 0 48 21.5 48 48l0 64c0 26.5-21.5 48-48 48l-352 0c-26.5 0-48-21.5-48-48l0-64c0-26.5 21.5-48 48-48l16 0 0-128c0-88.4 71.6-160 160-160s160 71.6 160 160l0 128zm-32 0l0-128c0-70.7-57.3-128-128-128S192 121.3 192 192l0 128 256 0zM128 368l0 64c0 8.8 7.2 16 16 16l352 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16l-352 0c-8.8 0-16 7.2-16 16zM320 128c-35.3 0-64 28.7-64 64 0 8.8-7.2 16-16 16s-16-7.2-16-16c0-53 43-96 96-96 8.8 0 16 7.2 16 16s-7.2 16-16 16z"]],
    "question": [320, 512, [10067, 10068, 61736], "3f", ["", "M32 160C32 89.3 89.3 32 160 32S288 89.3 288 160c0 53.5-32.8 99.3-79.5 118.5-31.1 12.8-64.5 41-64.5 81.5l0 24c0 8.8 7.2 16 16 16s16-7.2 16-16l0-24c0-21.3 18.5-41.2 44.7-51.9 58.2-23.9 99.3-81.2 99.3-148.1 0-88.4-71.6-160-160-160S0 71.6 0 160c0 8.8 7.2 16 16 16s16-7.2 16-16zM160 512c13.3 0 24-10.7 24-24s-10.7-24-24-24-24 10.7-24 24 10.7 24 24 24z"]],
    "square-lira": [448, 512, [], "e6e7", ["M32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64C46.3 64 32 78.3 32 96zm81.8 279.4c-2.8-5.3-2.3-11.7 1.1-16.6l30.8-44c2.4-3.4 4.5-7.1 6.2-10.9l-7.8 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l13.5 0c-.5-6.5-1.9-13-4.3-19.2l-1.9-4.8-7.3 0c-8.8 0-16-7.2-16-16 0-8.1 6.1-14.8 13.9-15.9-4.8-45.5 30.8-88.1 79.6-88.1l1.3 0c25.5 0 49.9 10.1 67.9 28.1l8.6 8.6c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-8.6-8.6c-12-12-28.3-18.7-45.3-18.7l-1.3 0c-30.4 0-52.3 27.5-47.4 56l97.8 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-86.7 0c2.4 7.9 3.8 15.9 4.2 24l82.5 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-86.2 0c-3 10.3-7.6 20.2-13.9 29.2L158.7 352 304 352c8.8 0 16 7.2 16 16s-7.2 16-16 16l-176 0c-6 0-11.4-3.3-14.2-8.6z", "M64 64C46.3 64 32 78.3 32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM151.3 248l-7.3 0c-8.8 0-16-7.2-16-16 0-8.1 6.1-14.8 13.9-15.9-4.8-45.5 30.8-88.1 79.6-88.1l1.3 0c25.5 0 49.9 10.1 67.9 28.1l8.6 8.6c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-8.6-8.6c-12-12-28.3-18.7-45.3-18.7l-1.3 0c-30.4 0-52.3 27.5-47.4 56l97.8 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-86.7 0c2.4 7.9 3.8 15.9 4.2 24l82.5 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-86.2 0c-3 10.3-7.6 20.2-13.9 29.2L158.7 352 304 352c8.8 0 16 7.2 16 16s-7.2 16-16 16l-176 0c-6 0-11.4-3.3-14.2-8.6s-2.3-11.7 1.1-16.6l30.8-44c2.4-3.4 4.5-7.1 6.2-10.9l-7.8 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l13.5 0c-.5-6.5-1.9-13-4.3-19.2l-1.9-4.8z"]],
    "square-dashed-circle-plus": [576, 512, [], "e5c2", ["", "M120 32l8 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-8 0c-30.9 0-56 25.1-56 56l0 8c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-8c0-48.6 39.4-88 88-88zM48 192c8.8 0 16 7.2 16 16l0 96c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-96c0-8.8 7.2-16 16-16zM64 384l0 8c0 30.9 25.1 56 56 56l126 0c2.9 11.1 6.7 21.8 11.4 32L120 480c-48.6 0-88-39.4-88-88l0-8c0-8.8 7.2-16 16-16s16 7.2 16 16zM480 120l0 94c-10.4-2.7-21-4.5-32-5.4l0-88.7c0-30.9-25.1-56-56-56l-8 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l8 0c48.6 0 88 39.4 88 88zM320 48c0 8.8-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l96 0c8.8 0 16 7.2 16 16zM544 400a112 112 0 1 0 -224 0 112 112 0 1 0 224 0zm-256 0a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm160-64l0 48 48 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-48 0 0 48c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-48-48 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l48 0 0-48c0-8.8 7.2-16 16-16s16 7.2 16 16z"]],
    "chair-office": [448, 512, [], "f6c1", ["M64 304l0 48c0 8.8 7.2 16 16 16l288 0c8.8 0 16-7.2 16-16l0-48c0-8.8-7.2-16-16-16L80 288c-8.8 0-16 7.2-16 16zM128 64l0 192 192 0 0-192c0-17.7-14.3-32-32-32L160 32c-17.7 0-32 14.3-32 32z", "M160 32c-17.7 0-32 14.3-32 32l0 192 192 0 0-192c0-17.7-14.3-32-32-32L160 32zM352 64l0 192 16 0c26.5 0 48 21.5 48 48l0 48c0 26.5-21.5 48-48 48l-128 0 0 80 64 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-160 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l64 0 0-80-128 0c-26.5 0-48-21.5-48-48l0-48c0-26.5 21.5-48 48-48l16 0 0-192c0-35.3 28.7-64 64-64L288 0c35.3 0 64 28.7 64 64zM224 368l144 0c8.8 0 16-7.2 16-16l0-48c0-8.8-7.2-16-16-16L80 288c-8.8 0-16 7.2-16 16l0 48c0 8.8 7.2 16 16 16l144 0zM48 144l0 64c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-64c0-8.8 7.2-16 16-16s16 7.2 16 16zm384 0l0 64c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-64c0-8.8 7.2-16 16-16s16 7.2 16 16z"]],
    "user-magnifying-glass": [576, 512, [], "e5c5", ["M16 512c8.8 0 16-7.2 16-16l0-16c0-79.5 64.5-144 144-144l64.2 0c-.1 2.7-.2 5.4-.2 8.1 0 90.9 72.2 164.9 162.3 167.9L16 512zM320 128a96 96 0 1 1 -192 0 96 96 0 1 1 192 0z", "M224 32a96 96 0 1 1 0 192 96 96 0 1 1 0-192zM334.2 193.1C345.5 174 352 151.8 352 128 352 57.3 294.7 0 224 0S96 57.3 96 128 153.3 256 224 256c16.5 0 32.3-3.1 46.7-8.8 16.2-22.9 38-41.6 63.5-54.1zM244.8 304L176 304C78.8 304 0 382.8 0 480l0 16c0 8.8 7.2 16 16 16s16-7.2 16-16l0-16c0-79.5 64.5-144 144-144l64.2 0c.5-11 2.1-21.7 4.6-32zM408 256.1a88 88 0 1 1 0 176 88 88 0 1 1 0-176zm0 208c27.4 0 52.6-9.2 72.8-24.6l67.8 67.9c6.2 6.3 16.4 6.3 22.6 0s6.3-16.4 0-22.6l-67.9-68c15.4-20.2 24.6-45.4 24.6-72.7 0-66.3-53.7-120-120-120s-120 53.7-120 120 53.7 120 120 120z"]],
    "container-storage": [576, 512, [], "f4b7", ["M64 64l448 0 0 384-448 0 0-384zm64 80l0 224c0 8.8 7.2 16 16 16s16-7.2 16-16l0-224c0-8.8-7.2-16-16-16s-16 7.2-16 16zm96 0l0 224c0 8.8 7.2 16 16 16s16-7.2 16-16l0-224c0-8.8-7.2-16-16-16s-16 7.2-16 16zm96 0l0 224c0 8.8 7.2 16 16 16s16-7.2 16-16l0-224c0-8.8-7.2-16-16-16s-16 7.2-16 16zm96 0l0 224c0 8.8 7.2 16 16 16s16-7.2 16-16l0-224c0-8.8-7.2-16-16-16s-16 7.2-16 16z", "M0 48c0-8.8 7.2-16 16-16l544 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0 0 384 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L16 480c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0 0-384-16 0C7.2 64 0 56.8 0 48zM64 64l0 384 448 0 0-384-448 0zm64 80c0-8.8 7.2-16 16-16s16 7.2 16 16l0 224c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-224zm208-16c8.8 0 16 7.2 16 16l0 224c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-224c0-8.8 7.2-16 16-16zm80 16c0-8.8 7.2-16 16-16s16 7.2 16 16l0 224c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-224zM240 128c8.8 0 16 7.2 16 16l0 224c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-224c0-8.8 7.2-16 16-16z"]],
    "arrow-left-to-bracket": [512, 512, [], "e669", ["", "M164.7 267.3c-3-3-4.7-7.1-4.7-11.3s1.7-8.3 4.7-11.3l144-144c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6L214.6 240 496 240c8.8 0 16 7.2 16 16s-7.2 16-16 16l-281.4 0 116.7 116.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-144-144zM176 448c8.8 0 16 7.2 16 16s-7.2 16-16 16l-80 0c-53 0-96-43-96-96L0 128C0 75 43 32 96 32l80 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L96 64c-35.3 0-64 28.7-64 64l0 256c0 35.3 28.7 64 64 64l80 0z"]],
    "sparkle": [512, 512, [], "e5d6", ["M46.8 256l138.6 51.9c8.7 3.2 15.5 10.1 18.8 18.8L256 465.2 307.9 326.6c3.2-8.7 10.1-15.5 18.8-18.8L465.2 256 326.6 204.1c-8.7-3.2-15.5-10.1-18.8-18.8L256 46.8 204.1 185.4c-3.2 8.7-10.1 15.5-18.8 18.8L46.8 256z", "M326.6 204.1L465.2 256 326.6 307.9c-8.7 3.2-15.5 10.1-18.8 18.8L256 465.2 204.1 326.6c-3.2-8.7-10.1-15.5-18.8-18.8L46.8 256 185.4 204.1c8.7-3.2 15.5-10.1 18.8-18.8L256 46.8 307.9 185.4c3.2 8.7 10.1 15.5 18.8 18.8zm11.2-30L278.5 15.6C275 6.2 266 0 256 0s-19 6.2-22.5 15.6L174.2 174.2 15.6 233.5C6.2 237 0 246 0 256s6.2 19 15.6 22.5l158.6 59.4 59.4 158.6C237 505.8 246 512 256 512s19-6.2 22.5-15.6l59.4-158.6 158.6-59.4C505.8 275 512 266 512 256s-6.2-19-15.6-22.5L337.8 174.2z"]],
    "campfire": [512, 512, [], "f6ba", ["M140.9 174.7c0 31 11.7 58.9 30.8 79.6-1.1-5.1-1.6-10.3-1.6-15.6 0-52.2 58-100.4 79.4-116.5 4.7-3.5 11-3.5 15.7 0 21.5 16.1 79.4 64.4 79.4 116.5 0 3.9-.3 7.7-.9 11.5 17-20.2 27.2-46.5 27.2-75.5 0-44.2-30.3-91.2-61.8-121.2-5.5 5.3-13.7 14.1-18.2 18.9-7.5 8.1-20.4 7.7-27.4-.9-12.5-15.3-23.9-28.8-37.3-41.3-19.5 17.9-40.8 41-57.3 66.2-17.1 26.2-28.2 53.3-28.2 78.3z", "M226.4 30.1c13.4 12.5 24.8 26.1 37.3 41.3 7 8.5 19.9 8.9 27.4 .9 4.5-4.8 12.7-13.6 18.2-18.9 31.5 30 61.8 77 61.8 121.2 0 28.9-10.2 55.2-27.2 75.5 .6-3.7 .9-7.6 .9-11.5 0-52.2-58-100.4-79.4-116.5-4.7-3.5-11-3.5-15.7 0-21.5 16.1-79.4 64.4-79.4 116.5 0 5.3 .6 10.6 1.6 15.6-19.2-20.7-30.8-48.7-30.8-79.6 0-25.1 11.1-52.1 28.2-78.3 16.5-25.2 37.8-48.4 57.3-66.2zm89.3 208.5c0 25.8-22 50.1-53.6 52.2-1.7 .1-3.4 .1-5.2 .2-33.7-.3-57.6-25.5-57.6-52.4 0-15.8 9.2-34.3 24.9-53.2 11-13.2 23.5-24.5 33.3-32.6 9.8 8 22.2 19.3 33.3 32.6 15.7 18.9 24.9 37.4 24.9 53.2zM208.6 7c-21.2 19.2-45.1 44.8-63.8 73.4-18.6 28.4-32.9 61.1-32.9 94.2 0 80.6 64 145.5 144.1 145.5s144.1-64.8 144.1-145.5c0-56.8-38.1-111.9-72.8-144.2-10.1-9.4-25.9-9.5-36.1-.1-3.6 3.3-8.5 8.4-13 13.1-10.5-12.6-21.3-24.8-34-36.4-4.2-3.9-9.7-6.9-17-6.9-5.5 0-13.1 1.7-18.7 6.9zM21.9 289.1c-8.2-3.3-17.5 .7-20.8 8.9s.7 17.5 8.9 20.8L212.9 400 10.1 481.1c-8.2 3.3-12.2 12.6-8.9 20.8s12.6 12.2 20.8 8.9L256 417.2 490.1 510.9c8.2 3.3 17.5-.7 20.8-8.9s-.7-17.5-8.9-20.8L299.1 400 501.9 318.9c8.2-3.3 12.2-12.6 8.9-20.8s-12.6-12.2-20.8-8.9L256 382.8 21.9 289.1z"]],
    "hands-bound": [640, 512, [], "e4f9", ["M48 186.2c0 3.6 1.2 7.2 3.5 10L158.3 329.9c5 6.2 9 13.9 11.9 22.1l101.7 0-.1-96.1c0-20.6-6.7-41.1-19.5-58L210 139.6c-5.4-7.4-15.4-8.7-22.3-3.5-7.9 5.6-8.4 15.7-3.5 22.2l30.5 42.2c.2 .2 .5 .5 .5 .8 26.1 39.7-33.8 86.7-70.7 42.4L87.4 175.2c-4.8-5.8-7.5-13.1-7.4-20.7l.6-105.9c0-22.4-32-21.7-32-.7L48 186.2zM160 512l128 0c-8.8 0-16-7.2-16-16l0-48-96 0 0 48c0 8.8-7.2 16-16 16zm192 0l128 0c-8.8 0-16-7.2-16-16l0-48-96 0 0 48c0 8.8-7.2 16-16 16zm16-256.1l-.1 96.1 101.7 0c2.9-8.2 6.9-15.9 11.9-22.1L588.3 196.2c2.2-2.7 3.5-6.4 3.5-10l-.7-138.3c0-21-32-21.6-32 .7l.6 105.9c0 7.5-2.6 14.9-7.4 20.7l-57.1 68.5c-36.8 44.4-96.8-2.6-70.7-42.4 0-.2 .2-.5 .5-.8l30.5-42.2c4.9-6.5 4.4-16.6-3.5-22.2-7-5.2-17-3.9-22.3 3.5l-42.3 58.4c-12.7 16.9-19.5 37.4-19.5 58z", "M16.8 48c0-26.7 21.8-48.4 48.7-48 26 .4 47.2 23.7 47.2 49.7L112 154.7 173.9 228c7.1 8.4 20.1-1.8 13.6-10.7l-28.6-39.2c-13.4-18.5-13.1-44.6 2.5-61.4 25.5-27.4 60.5-15.2 74.4 4l42.3 58.4c16.6 22.1 25.6 49.1 25.6 76.9l0 96.1 32.2 0 0-96.1c0-27.7 9-54.7 25.6-76.9l42.3-58.4c13.9-19.2 48.9-31.4 74.4-4 15.6 16.7 15.9 42.9 2.5 61.4l-28.6 39.2c-6.5 9 6.5 19.1 13.6 10.7l61.9-73.4-.7-104.9c0-26 21.2-49.4 47.2-49.7 26.8-.4 48.7 21.2 48.7 48l.8 138.2c0 11-3.7 21.5-10.5 30L506.4 349.9c-.5 .7-1.1 1.4-1.6 2.1l23.2 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-416 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l22.9 0c-.5-.7-1-1.4-1.6-2.1L26.5 216.2c-6.7-8.5-10.5-19-10.5-30L16.8 48zM170.2 352l101.7 0-.1-96.1c0-20.6-6.7-41.1-19.5-58L210 139.6c-5.4-7.4-15.4-8.7-22.3-3.5-7.9 5.6-8.4 15.7-3.5 22.2l30.5 42.2c.2 .2 .5 .5 .5 .8 26.1 39.7-33.8 86.7-70.7 42.4L87.4 175.2c-4.8-5.8-7.5-13.1-7.4-20.7l.6-105.9c0-22.4-32-21.7-32-.7L48 186.2c0 3.6 1.2 7.2 3.5 10L158.3 329.9c5 6.2 9 13.9 11.9 22.1zm311.2-22.1L588.3 196.2c2.2-2.7 3.5-6.4 3.5-10l-.7-138.3c0-21-32-21.6-32 .7l.6 105.9c0 7.5-2.6 14.9-7.4 20.7l-57.1 68.5c-36.8 44.4-96.8-2.6-70.7-42.4 0-.2 .2-.5 .5-.8l30.5-42.2c4.9-6.5 4.4-16.6-3.5-22.2-7-5.2-17-3.9-22.3 3.5l-42.3 58.4c-12.7 16.9-19.5 37.4-19.5 58l-.1 96.1 101.7 0c2.9-8.2 6.9-15.9 11.9-22.1zM112 416l416 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-32 0 0 48c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-48-96 0 0 48c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-48-32 0 0 48c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-48-96 0 0 48c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-48-32 0c-8.8 0-16-7.2-16-16s7.2-16 16-16z"]],
    "panel-fire": [576, 512, [], "e42f", ["M64 96c0-17.7 14.3-32 32-32l320 0c17.7 0 32 14.3 32 32l0 85.8c-.7 .4-1.4 .9-2.1 1.4-7.9-7.9-15.9-15.6-24.2-23.1-7-6.3-15-10.7-23.5-13.3-5.7-20.1-24.2-34.8-46.2-34.8l-192 0c-26.5 0-48 21.5-48 48l0 64c0 26.5 21.5 48 48 48l84.1 0c-19.9 33.5-36.1 72.6-36.1 110.1 0 22.9 3.7 45.1 10.6 65.9L96 448c-17.7 0-32-14.3-32-32L64 96zm56 240a24 24 0 1 0 48 0 24 24 0 1 0 -48 0z", "M416 64L96 64C78.3 64 64 78.3 64 96l0 320c0 17.7 14.3 32 32 32l122.6 0c3.7 11.1 8.2 21.8 13.6 32L96 480c-35.3 0-64-28.7-64-64L32 96c0-35.3 28.7-64 64-64l320 0c35.3 0 64 28.7 64 64l0 76.2c-11.1 .3-22.2 3.5-32 9.6L448 96c0-17.7-14.3-32-32-32zm-64 48c21.9 0 40.4 14.7 46.2 34.8-12.1-3.7-25-3.7-37.1 0-2.6-1.8-5.7-2.8-9-2.8l-192 0c-8.8 0-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16l105.2 0c-6.4 8.8-12.3 17.6-17.7 26.3-1.2 1.9-2.3 3.8-3.4 5.7L160 272c-26.5 0-48-21.5-48-48l0-64c0-26.5 21.5-48 48-48l192 0zM120 336a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM363.5 199.5c6.3-5.6 14.5-7.5 20.6-7.5 8 .1 14 3.3 18.7 7.6 14.2 12.8 26.3 26.4 38 40.3 5-5.2 10.6-10.9 14.6-14.5 11.2-10.3 28.6-10.2 39.7 .1 38.5 35.5 80.9 96.1 80.9 158.6 0 88.8-71.2 160-160 160S256 472.8 256 384c0-36.5 16-72.5 36.6-103.7 20.8-31.5 47.3-59.6 70.9-80.8zm19.6 25.4c-21.7 19.7-45.4 45.2-63.8 73-19 28.8-31.3 58.6-31.3 86.1 0 33.6 12.7 64.1 33.6 86.8-1.1-5.3-1.6-10.8-1.6-16.4 0-57.4 63.8-110.5 87.4-128.2 5.2-3.9 12.1-3.9 17.3 0 23.6 17.7 87.4 70.8 87.4 128.2 0 5.6-.6 11.1-1.6 16.4 20.9-22.7 33.6-53.2 33.6-86.8 0-48.7-33.7-100.4-68.8-133.5-6.1 5.8-15.4 15.6-20.5 21-8.3 8.8-22.3 8.3-30-.9-14-16.9-26.7-31.8-41.7-45.7zM480 454.4c0-17.4-10.1-37.7-27.4-58.5-12.1-14.5-25.8-27-36.6-35.8-10.7 8.8-24.5 21.3-36.6 35.8-17.3 20.7-27.4 41.1-27.4 58.5 0 29.8 26.5 57.6 64 57.6l.1 0c37.4-.1 63.9-27.9 63.9-57.6z"]],
    "clock-seven-thirty": [512, 512, [], "e351", ["M480 256a224 224 0 1 1 -448 0 224 224 0 1 1 448 0zM178.7 343.1c-4.9 7.4-2.9 17.3 4.4 22.2s17.3 2.9 22.2-4.4l34.7-52 0 91.2c0 8.8 7.2 16 16 16s16-7.2 16-16l0-144c0-7.1-4.6-13.3-11.4-15.3s-14 .6-17.9 6.4l-64 96z", "M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm480 0a256 256 0 1 1 -512 0 256 256 0 1 1 512 0zM240 400l0-91.2-34.7 52c-4.9 7.4-14.8 9.3-22.2 4.4s-9.3-14.8-4.4-22.2l64-96c3.9-5.9 11.2-8.5 17.9-6.4S272 248.9 272 256l0 144c0 8.8-7.2 16-16 16s-16-7.2-16-16z"]],
    "tugrik-sign": [384, 512, [], "e2ba", ["", "M16 32C7.2 32 0 39.2 0 48S7.2 64 16 64l160 0 0 147.5-115.9 29c-8.6 2.1-13.8 10.8-11.6 19.4s10.8 13.8 19.4 11.6l108.1-27 0 63-115.9 29c-8.6 2.1-13.8 10.8-11.6 19.4s10.8 13.8 19.4 11.6l108.1-27 0 115.5c0 8.8 7.2 16 16 16s16-7.2 16-16l0-123.5 115.9-29c8.6-2.1 13.8-10.8 11.6-19.4s-10.8-13.8-19.4-11.6l-108.1 27 0-63 115.9-29c8.6-2.1 13.8-10.8 11.6-19.4s-10.8-13.8-19.4-11.6L208 203.5 208 64 368 64c8.8 0 16-7.2 16-16s-7.2-16-16-16L16 32z"]],
    "audio-description-slash": [576, 512, [], "e0a8", ["M150.5 96L480 96c17.7 0 32 14.3 32 32l0 256c0 17.7-14.3 32-32 32l-9.5 0-68.8-68.8c27-10.4 46.2-36.6 46.2-67.2l0-48c0-39.8-32.2-72-72-72l-56 0c-8.8 0-16 7.2-16 16L304 249.5 150.5 96zM336 192l40 0c22.1 0 40 17.9 40 40l0 48c0 22.1-17.9 40-40 40l-1.5 0-38.5-38.5 0-89.5z", "M27.3-27.2c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l544 544c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L499.5 445c25.8-8.2 44.5-32.4 44.5-61l0-256c0-35.3-28.7-64-64-64L118.5 64 27.3-27.2zM150.5 96L480 96c17.7 0 32 14.3 32 32l0 256c0 17.7-14.3 32-32 32l-9.5 0-68.8-68.8c27-10.4 46.2-36.6 46.2-67.2l0-48c0-39.8-32.2-72-72-72l-56 0c-8.8 0-16 7.2-16 16L304 249.5 150.5 96zm224 224l-38.5-38.5 0-89.5 40 0c22.1 0 40 17.9 40 40l0 48c0 22.1-17.9 40-40 40l-1.5 0zM39.5 98c-4.8 9-7.5 19.2-7.5 30l0 256c0 35.3 28.7 64 64 64l293.5 0-32-32-261.5 0c-17.7 0-32-14.3-32-32l0-256c0-1.7 .1-3.4 .4-5.1L39.5 98zm96 96c-4.8 9-7.5 19.2-7.5 30l0 112c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48 69.5 0-32-32-37.5 0 0-32c0-1.7 .1-3.4 .4-5.1L135.5 194zM240 298.5l0 37.5c0 8.8 7.2 16 16 16s16-7.2 16-16l0-5.5-32-32z"]],
    "face-thermometer": [640, 512, [], "e39a", ["M96.3 256c0 123.7 100.3 224 224 224 121.5 0 220.3-96.7 223.9-217.3L443.9 363c3.4 6.5 2.1 14.7-3.7 19.7-6.7 5.7-16.8 5-22.6-1.8-23.5-27.5-58.4-44.9-97.3-44.9s-73.8 17.4-97.3 44.9c-5.7 6.7-15.8 7.5-22.6 1.8s-7.5-15.8-1.8-22.6c29.3-34.3 73-56.1 121.7-56.1 3.1 0 6.1 .1 9.1 .3L401.7 232c-.5 0-.9 0-1.4 0-13.3 0-24-10.7-24-24s10.7-24 24-24 24 10.7 24 24c0 .5 0 .9 0 1.4l80.5-80.5c-40.4-58.5-108-96.9-184.5-96.9-123.7 0-224 100.3-224 224zm168-48a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zM367.7 311.2c.3 .1 .5 .2 .8 .3l28.8-29.8-29.6 29.6z", "M544.2 262.7L443.9 363c3.4 6.5 2.1 14.7-3.7 19.7-6.7 5.7-16.8 5-22.6-1.8-23.5-27.5-58.4-44.9-97.3-44.9s-73.8 17.4-97.3 44.9c-5.7 6.7-15.8 7.5-22.6 1.8s-7.5-15.8-1.8-22.6c29.3-34.3 73-56.1 121.7-56.1 3.1 0 6.1 .1 9.1 .3L401.7 232c-.5 0-.9 0-1.4 0-13.3 0-24-10.7-24-24s10.7-24 24-24 24 10.7 24 24c0 .5 0 .9 0 1.4l80.5-80.5c-40.4-58.5-108-96.9-184.5-96.9-123.7 0-224 100.3-224 224s100.3 224 224 224c121.5 0 220.3-96.7 223.9-217.3zm31-31c.7 8 1.1 16.1 1.1 24.2 0 141.4-114.6 256-256 256S64.3 397.4 64.3 256 178.9 0 320.3 0c86 0 162.1 42.4 208.5 107.4 23.5-14.1 54.5-11 74.8 9.2 23.9 23.9 23.9 62.7 0 86.6l-28.4 28.4zM421.5 340.1l36.1-36.1-12.7-12.7c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l12.7 12.7 25.4-25.4-12.7-12.7c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l12.7 12.7 25.4-25.4-12.7-12.7c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l12.7 12.7 4.7-4.7c11.4-11.4 11.4-29.9 0-41.4s-29.9-11.4-41.4 0L367.7 311.2c19.9 6.2 38.1 16.1 53.8 29zM240.3 184a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]],
    "lightbulb-cfl-on": [640, 512, [], "e5a7", ["M192 74.3c0 14.8 13.9 25.7 28.3 22.1 22.2-5.5 44.3-11.1 66.5-16.6 10.1-2.6 17.2-11.7 17.2-22.1 0-14.8-13.9-25.7-28.3-22.1L209.3 52.2C199.1 54.7 192 63.8 192 74.3zm0 80c0 14.8 13.8 25.6 28.2 22.2l191.7-47.9 18.8-4.7c10.2-2.5 17.3-11.7 17.3-22.1 0-14.8-13.9-25.7-28.3-22.1-215.2 53.8-197.3 49.3-210.4 52.6-10.2 2.5-17.3 11.7-17.3 22.1zm0 80c0 14.8 13.9 25.7 28.3 22.1 28.7-7.2 98.8-24.7 210.4-52.6 10.2-2.5 17.3-11.7 17.3-22.1 0-14.8-13.8-25.6-28.2-22.2L228.1 207.5c-6.4 1.6-12.6 3.2-18.8 4.7-10.2 2.5-17.3 11.7-17.3 22.1zM256 416l0 16c0 26.5 21.5 48 48 48l32 0c26.5 0 48-21.5 48-48l0-16-128 0zm16-139.5l0 41 32-8 0 74.5 32 0 0-64c0-7.3 5-13.7 12.1-15.5l82.6-20.6c10.2-2.5 17.3-11.7 17.3-22.1 0-14.8-13.9-25.7-28.3-22.1-42.5 10.6-85 21.2-127.9 32L272 276.5z", "M336 57.7C336 22 302.5-4.1 267.9 4.5L201.5 21.1c-24.4 6.1-41.5 28-41.5 53.2 0 16 6.8 30.1 17.3 40-10.8 10.1-17.3 24.4-17.3 40 0 16 6.8 30.1 17.3 40-10.8 10.1-17.3 24.4-17.3 40 0 35.7 33.5 61.8 68.1 53.2l63.7-15.9 .1 0c42.7-10.7 85.3-21.3 127.8-31.9 14.4-3.6 28.3 7.3 28.3 22.1 0 10.5-7.1 19.6-17.3 22.1l-82.6 20.6C341 306.3 336 312.7 336 320l0 64-32 0 0-74.5-32 8 0 66.5-16 0c-17.7 0-32 14.3-32 32l0 16c0 44.2 35.8 80 80 80l32 0c44.2 0 80-35.8 80-80l0-16c0-17.7-14.3-32-32-32l-16 0 0-51.5 70.5-17.6c24.4-6.1 41.5-28 41.5-53.2 0-16-6.8-30.1-17.3-40 10.8-10.1 17.3-24.4 17.3-40 0-16-6.8-30.1-17.3-40 10.8-10.1 17.3-24.4 17.3-40 0-35.7-33.5-61.8-68.1-53.2L335.1 67.7c.6-3.3 .9-6.6 .9-10zm94.7 146.1c-111.6 27.9-181.7 45.4-210.4 52.6-14.4 3.6-28.3-7.3-28.3-22.1 0-10.5 7.1-19.6 17.3-22.1l18.6-4.6 .2-.1 191.7-47.9c14.3-3.5 28.2 7.4 28.2 22.2 0 10.5-7.1 19.6-17.3 22.1zm-136.2-93L419.7 79.6c14.4-3.6 28.3 7.3 28.3 22.1 0 10.5-7.1 19.6-17.3 22.1l-18.6 4.6-.2 .1-191.7 47.9c-14.3 3.5-28.2-7.4-28.2-22.2 0-10.5 7.1-19.6 17.3-22.1l18.8-4.7 .1 0 66.4-16.6 .1 0zm-7.8-31l0 0-66.4 16.6 0 0c-14.4 3.6-28.3-7.3-28.3-22.1 0-10.5 7.1-19.6 17.3-22.1l66.4-16.6c14.4-3.6 28.3 7.3 28.3 22.1 0 10.4-7.1 19.6-17.2 22.1zM384 416l0 16c0 26.5-21.5 48-48 48l-32 0c-26.5 0-48-21.5-48-48l0-16 128 0zM40.9 18.7c-7.4-4.9-17.3-2.9-22.2 4.4s-2.9 17.3 4.4 22.2l48 32c7.4 4.9 17.3 2.9 22.2-4.4s2.9-17.3-4.4-22.2l-48-32zm576 26.6c7.4-4.9 9.3-14.8 4.4-22.2s-14.8-9.3-22.2-4.4l-48 32c-7.4 4.9-9.3 14.8-4.4 22.2s14.8 9.3 22.2 4.4l48-32zM16 176c-8.8 0-16 7.2-16 16s7.2 16 16 16l48 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-48 0zm560 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l48 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-48 0zM88.9 333.3c7.4-4.9 9.3-14.8 4.4-22.2s-14.8-9.3-22.2-4.4l-48 32c-7.4 4.9-9.3 14.8-4.4 22.2s14.8 9.3 22.2 4.4l48-32zm480-26.6c-7.4-4.9-17.3-2.9-22.2 4.4s-2.9 17.3 4.4 22.2l48 32c7.4 4.9 17.3 2.9 22.2-4.4s2.9-17.3-4.4-22.2l-48-32z"]],
    "clock-three": [512, 512, [], "e356", ["M480 256a224 224 0 1 1 -448 0 224 224 0 1 1 448 0zM240 112l0 144c0 8.8 7.2 16 16 16l112 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-96 0 0-128c0-8.8-7.2-16-16-16s-16 7.2-16 16z", "M480 256a224 224 0 1 1 -448 0 224 224 0 1 1 448 0zM0 256a256 256 0 1 0 512 0 256 256 0 1 0 -512 0zM240 112l0 144c0 8.8 7.2 16 16 16l112 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-96 0 0-128c0-8.8-7.2-16-16-16s-16 7.2-16 16z"]],
    "person-walking-luggage": [576, 512, [], "e554", ["M53.5 488.8l51.4 25.7 57.7-115.4-51.4-25.7-57.7 115.4zM304 149.9l0 114.6c0 18.2 10.3 34.8 26.5 42.9l37.5 18.7 0-176.8c-9.9-3.5-20.4-5.3-31.2-5.3-11.3 0-22.4 2-32.8 5.9zM328 24a24 24 0 1 0 48 0 24 24 0 1 0 -48 0z", "M352 0a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm0 80a56 56 0 1 0 0-112 56 56 0 1 0 0 112zm-80 89.8l0 94.7c0 30.3 17.1 58 44.2 71.6l93.5 46.7c14.6 7.3 24.4 21.4 26.2 37.6l12.2 109.4c1 8.8 8.9 15.1 17.7 14.1s15.1-8.9 14.1-17.7L467.8 416.8c-3-27-19.5-50.6-43.7-62.7l-24-12 0-173.8c4.5 4 8.6 8.5 12.3 13.5L432 208c15.1 20.1 38.8 32 64 32l32 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-32 0c-15.1 0-29.3-7.1-38.4-19.2l-19.7-26.3c-23.9-31.8-61.3-50.5-101.1-50.5-35.6 0-69.6 15-93.5 41.4l-30.5 33.6c-13.4 14.7-20.8 33.9-20.8 53.8l0 99.5-15.2 30.3-51.4-25.7c-15.8-7.9-35-1.5-42.9 14.3L24.9 474.5c-7.9 15.8-1.5 35 14.3 42.9l51.4 25.7c15.8 7.9 35 1.5 42.9-14.3l88.8-177.7c1.1-2.2 1.7-4.7 1.7-7.2l0-103.3c0-11.9 4.5-23.5 12.5-32.3L267 174.9c1.6-1.8 3.3-3.5 5-5.1zm32-19.9c10.4-3.9 21.5-5.9 32.8-5.9 10.8 0 21.3 1.8 31.2 5.3l0 176.8-37.5-18.7c-16.3-8.1-26.5-24.8-26.5-42.9l0-114.6zM292.8 399c-2 5.9-5 11.3-9.1 16.1L195.9 517.6c-5.8 6.7-5 16.8 1.7 22.6s16.8 5 22.6-1.7L308 435.9c6.7-7.9 11.9-16.9 15.2-26.8l4.6-13.8-28.9-14.5-6 18.1zM111.2 373.5l51.4 25.7-57.7 115.4-51.4-25.7 57.7-115.4z"]],
    "file-arrow-down": [384, 512, ["file-download"], "f56d", ["M32 64l0 384c0 17.7 14.3 32 32 32l256 0c17.7 0 32-14.3 32-32l0-256-96 0c-35.3 0-64-28.7-64-64l0-96-128 0C46.3 32 32 46.3 32 64zm76.7 268.7c6.2-6.2 16.4-6.2 22.6 0L176 377.4 176 256c0-8.8 7.2-16 16-16s16 7.2 16 16l0 121.4 44.7-44.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6l-72 72c-6.2 6.2-16.4 6.2-22.6 0l-72-72c-6.2-6.2-6.2-16.4 0-22.6z", "M64 32l128 0 0 96c0 35.3 28.7 64 64 64l96 0 0 256c0 17.7-14.3 32-32 32L64 480c-17.7 0-32-14.3-32-32L32 64c0-17.7 14.3-32 32-32zM224 45.3L338.7 160 256 160c-17.7 0-32-14.3-32-32l0-82.7zM64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-261.5c0-17-6.7-33.3-18.7-45.3L242.7 18.7C230.7 6.7 214.5 0 197.5 0L64 0zm44.7 355.3l72 72c6.2 6.2 16.4 6.2 22.6 0l72-72c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0L208 377.4 208 256c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 121.4-44.7-44.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6z"]],
    "person-booth": [576, 512, [], "f756", ["M64 176l0 96c0 15.1 7.1 29.3 19.2 38.4L128 344 128 176c0-17.7-14.3-32-32-32s-32 14.3-32 32zM72 24a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm233.9 8L406.3 232.8c1.6 3.2 2.1 6.9 1.4 10.4l-36 172.7 172.3 0 0-368c0-8.8-7.2-16-16-16L305.9 32z", "M96 48a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm0-80A56 56 0 1 1 96 80 56 56 0 1 1 96-32zm.5 144c25.5 0 48.6 15 58.9 38.3l34.3 77.2c7.7 17.3 24.9 28.5 43.9 28.5l38.4 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-38.4 0c-31.6 0-60.3-18.6-73.1-47.5l-.5-1.1 0 128.6c20.1 15.1 32 38.8 32 64l0 96c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-96c0-15.1-7.1-29.3-19.2-38.4L64 336c-20.1-15.1-32-38.8-32-64l0-95.5C32 140.9 60.9 112 96.5 112zM32 528l0-156.1c1.1 .8 2.1 1.7 3.2 2.5L64 396 64 528c0 8.8-7.2 16-16 16s-16-7.2-16-16zm96-352c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 96c0 15.1 7.1 29.3 19.2 38.4L128 344 128 176zm278.3 56.8c1.6 3.2 2.1 6.9 1.4 10.4l-36 172.7 172.3 0 0-368c0-8.8-7.2-16-16-16L305.9 32 406.3 232.8zM544 528l0-80-192 0c-4.8 0-9.4-2.2-12.4-5.9s-4.2-8.6-3.3-13.4l38.9-186.6-87.2-174.4 0 136.2-32 0 0-156c0-26.5 21.5-48 48-48L528 0c26.5 0 48 21.5 48 48l0 480c0 8.8-7.2 16-16 16s-16-7.2-16-16zm-256 0c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-188 32 0 0 188z"]],
    "locust": [576, 512, [], "e520", ["M64 294.2c0-21.1 17.1-38.2 38.2-38.2l49.8 0-57.5 76.6-8.2-3.8C72.7 322.6 64 309.1 64 294.2zm60.3 52.1L192 256 480 256c35.3 0 64 28.7 64 64s-28.7 64-64 64l-231.2 0c-27.5 0-54.8-5.9-79.8-17.4l-44.6-20.4zM448 320a24 24 0 1 0 48 0 24 24 0 1 0 -48 0z", "M336 32c132.5 0 240 107.5 240 240l0 48-.1 4.9c-2.4 47.5-39.4 85.9-86.2 90.6l20.7 41.3c4 7.9 .7 17.5-7.2 21.5s-17.5 .7-21.5-7.2l-27.6-55.2-136.3 0-32 55.9c-4.4 7.7-14.2 10.3-21.8 6s-10.3-14.2-6-21.8l22.9-40.1-32.2 0-12-.3c-11.4-.6-22.8-2.2-34-4.5l-45.9 62.3c-5.2 7.1-15.3 8.6-22.4 3.4s-8.6-15.3-3.4-22.4l38.9-52.9c-4.9-1.8-9.7-3.7-14.4-5.9l0 0-51-23.3-75.8 101.2c-5.3 7.1-15.3 8.5-22.4 3.2s-8.5-15.3-3.2-22.4l71.7-95.6-1.9-.8-4.6-2.3C47.6 344.2 33.9 323 32.2 299.3l-.2-5.1c0-36.3 27.6-66.2 63-69.8l7.2-.4 73.8 0 67.2-89.6 2.7-2.8c2.9-2.4 6.7-3.7 10.6-3.6 5.2 .1 10 2.8 12.9 7.1l40.5 60.8 45.3-61.4 1.3-1.6c3.3-3.4 7.9-5.2 12.7-4.9 5.5 .4 10.3 3.5 12.9 8.3l47.8 87.7 50.2 0c23.9 0 45.7 8.8 62.5 23.2-12.3-103.2-100-183.2-206.5-183.2l-32 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l32 0zM124.3 346.2l44.6 20.4C194 378.1 221.2 384 248.8 384L480 384c35.3 0 64-28.7 64-64s-28.7-64-64-64l-288 0-67.7 90.2zM472 344a24 24 0 1 1 0-48 24 24 0 1 1 0 48zM102.2 256c-21.1 0-38.2 17.1-38.2 38.2 0 14.9 8.7 28.5 22.3 34.7l8.2 3.8 57.5-76.6-49.8 0zM216 224l73.2 0 .5-.7-34.4-51.6-39.2 52.3zm112.9 0l64.6 0-27.5-50.3-37.1 50.3z"]],
    "window": [512, 512, [], "f40e", ["M32 128l0 96 448 0 0-96c0-17.7-14.3-32-32-32L64 96c-17.7 0-32 14.3-32 32zm88 32a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm96 0a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm96 0a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M448 96c17.7 0 32 14.3 32 32l0 96-448 0 0-96c0-17.7 14.3-32 32-32l384 0zm32 160l0 128c0 17.7-14.3 32-32 32L64 416c-17.7 0-32-14.3-32-32l0-128 448 0zM64 64C28.7 64 0 92.7 0 128L0 384c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L64 64zm56 96a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm72 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm120-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"]],
    "right-long": [576, 512, ["long-arrow-alt-right"], "f30b", ["M32 240l0 32c0 8.8 7.2 16 16 16l352 0c8.8 0 16 7.2 16 16l0 80 128-128-128-128 0 80c0 8.8-7.2 16-16 16L48 224c-8.8 0-16 7.2-16 16z", "M566.6 233.4c12.5 12.5 12.5 32.8 0 45.3l-128 128c-9.2 9.2-22.9 11.9-34.9 6.9S384 396.9 384 384l0-64-336 0c-26.5 0-48-21.5-48-48l0-32c0-26.5 21.5-48 48-48l336 0 0-64c0-12.9 7.8-24.6 19.8-29.6s25.7-2.2 34.9 6.9l128 128zM416 384l128-128-128-128 0 80c0 8.8-7.2 16-16 16L48 224c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l352 0c8.8 0 16 7.2 16 16l0 80z"]],
    "truck-droplet": [576, 512, [], "e58c", ["M32 96l0 288c0 17.7 14.3 32 32 32l.4 0c4-44.9 41.7-80 87.6-80s83.6 35.1 87.6 80l96.7 0c2.8-30.8 21.4-57 47.6-70.4L384 96c0-17.7-14.3-32-32-32L64 64C46.3 64 32 78.3 32 96zM136 232c0-33.2 34.5-78 55.8-102.4 8.7-10 23.8-10 32.5 0 21.2 24.4 55.8 69.1 55.8 102.4 0 48-32.2 72-72 72s-72-32.2-72-72zm280 56l0 48.4c2.6-.2 5.3-.4 8-.4 45.9 0 83.6 35.1 87.6 80l.4 0c17.7 0 32-14.3 32-32l0-96-128 0z", "M352 64c17.7 0 32 14.3 32 32l0 249.6c-26.2 13.4-44.9 39.6-47.6 70.4l-96.7 0c-4-44.9-41.7-80-87.6-80s-83.6 35.1-87.6 80l-.4 0c-17.7 0-32-14.3-32-32L32 96c0-17.7 14.3-32 32-32l288 0zm64 272.4l0-48.4 128 0 0 96c0 17.7-14.3 32-32 32l-.4 0c-4-44.9-41.7-80-87.6-80-2.7 0-5.4 .1-8 .4zM544 227.9l0 28.1-128 0 0-96 60.1 0c8.5 0 16.6 3.4 22.6 9.4l35.9 35.9c6 6 9.4 14.1 9.4 22.6zM64 448l3.3 0c10.4 36.9 44.4 64 84.7 64s74.2-27.1 84.7-64l102.6 0c10.4 36.9 44.4 64 84.7 64s74.2-27.1 84.7-64l3.3 0c35.3 0 64-28.7 64-64l0-156.1c0-17-6.7-33.3-18.7-45.3l-35.9-35.9c-12-12-28.3-18.7-45.3-18.7l-60.1 0 0-32c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 384c0 35.3 28.7 64 64 64zm32-24a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm272 0a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zM248 232c0 16.4-5.3 25.4-10.8 30.5-5.9 5.5-15.6 9.5-29.2 9.5-22.1 0-40-17.9-40-40 0-7.3 4.5-20.3 15.2-37.8 7.5-12.2 16.5-24.2 24.8-34.3 8.3 10.1 17.3 22 24.8 34.3 10.7 17.4 15.2 30.5 15.2 37.8zm32 0c0-33.2-34.5-78-55.8-102.4-8.7-10-23.8-10-32.5 0-21.2 24.4-55.8 69.1-55.8 102.4 0 39.8 32.2 72 72 72s72-24 72-72z"]],
    "hand-holding-medical": [576, 512, [], "e05c", ["M0 384c0 8.8 7.2 16 16 16l64 0c3.2 0 6.2-.9 8.9-2.7l79.9-53.3c7.9-5.3 17.1-8.1 26.6-8.1L344 336c13.3 0 24 10.7 24 24s-10.7 24-24 24l-88 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l148.6 0c2.9 0 5.7-.8 8.2-2.3L511.3 355c3.4-2 7.2-3 11.1-3l1.3 0c11.2 0 20.3 9.1 20.3 20.3 0 6.9-3.5 13.3-9.2 17L415.1 467.1c-13 8.4-28.1 12.9-43.6 12.9L16 480c-8.8 0-16 7.2-16 16L0 384z", "M256 40l0 40c0 8.8-7.2 16-16 16l-40 0c-4.4 0-8 3.6-8 8l0 48c0 4.4 3.6 8 8 8l40 0c8.8 0 16 7.2 16 16l0 40c0 4.4 3.6 8 8 8l48 0c4.4 0 8-3.6 8-8l0-40c0-8.8 7.2-16 16-16l40 0c4.4 0 8-3.6 8-8l0-48c0-4.4-3.6-8-8-8l-40 0c-8.8 0-16-7.2-16-16l0-40c0-4.4-3.6-8-8-8l-48 0c-4.4 0-8 3.6-8 8zm8-40l48 0c22.1 0 40 17.9 40 40l0 24 24 0c22.1 0 40 17.9 40 40l0 48c0 22.1-17.9 40-40 40l-24 0 0 24c0 22.1-17.9 40-40 40l-48 0c-22.1 0-40-17.9-40-40l0-24-24 0c-22.1 0-40-17.9-40-40l0-48c0-22.1 17.9-40 40-40l24 0 0-24c0-22.1 17.9-40 40-40zM151 317.4c13.1-8.8 28.6-13.4 44.4-13.4L344 304c30.9 0 56 25.1 56 56 0 8.6-1.9 16.7-5.4 24l5.6 0 94.7-56.4c8.3-4.9 17.8-7.6 27.5-7.6l1.3 0c28.9 0 52.3 23.4 52.3 52.3 0 17.7-9 34.2-23.8 43.8L432.6 493.9c-18.2 11.8-39.4 18.1-61 18.1L16 512c-8.8 0-16-7.2-16-16s7.2-16 16-16l355.5 0c15.5 0 30.6-4.5 43.6-12.9l119.6-77.8c5.8-3.7 9.2-10.2 9.2-17 0-11.2-9.1-20.3-20.3-20.3l-1.3 0c-3.9 0-7.7 1.1-11.1 3l-98.5 58.7c-2.5 1.5-5.3 2.3-8.2 2.3L256 416c-8.8 0-16-7.2-16-16s7.2-16 16-16l88 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-148.6 0c-9.5 0-18.7 2.8-26.6 8.1L88.9 397.3c-2.6 1.8-5.7 2.7-8.9 2.7l-64 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l59.2 0 75.8-50.6z"]],
    "hand-point-left": [512, 512, [], "f0a5", ["M32 152c0 13.3 10.7 24 24 24l184 0 0-32c0-5.5 .6-10.8 1.6-16L56 128c-13.3 0-24 10.7-24 24zm144 80c0 13.3 10.7 24 24 24l45.4 0c-3.5-7.3-5.4-15.4-5.4-24l0-24-40 0c-13.3 0-24 10.7-24 24zm32 80c0 13.3 10.7 24 24 24l64 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-64 0c-13.2 0-24 10.8-24 24zm16 80c0 13.3 10.7 24 24 24l56 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-56 0c-13.3 0-24 10.7-24 24zm48-248l0 88c0 13.2 10.7 24 24 24 13.3 0 24-10.7 24-24l0-56c0-8.8 7.2-16 16-16s16 7.2 16 16l0 56c0 15.7-6.4 29.8-16.8 40 10.4 10.2 16.8 24.3 16.8 40 0 13.8-5 26.4-13.2 36.1 12.9 10.3 21.2 26.1 21.2 43.9 0 8.6-1.9 16.7-5.4 24 69.5-1.4 125.4-58.2 125.4-128l0-64c0-70.7-57.3-128-128-128l-32 0c-26.5 0-48 21.5-48 48z", "M56 128c-13.3 0-24 10.7-24 24s10.7 24 24 24l184 0 0-32c0-5.5 .6-10.8 1.6-16L56 128zm216 48l0 56c0 13.2 10.7 24 24 24l0 0c13.3 0 24-10.7 24-24l0-56c0-8.8 7.2-16 16-16s16 7.2 16 16l0 56c0 15.7-6.4 29.8-16.8 40 10.4 10.2 16.8 24.3 16.8 40 0 13.8-5 26.4-13.2 36.1 12.9 10.3 21.2 26.1 21.2 43.9 0 8.6-1.9 16.7-5.4 24 69.5-1.4 125.4-58.2 125.4-128l0-64c0-70.7-57.3-128-128-128l-32 0c-26.5 0-48 21.5-48 48l0 32zm-32 32l-40 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l45.4 0c-3.5-7.3-5.4-15.4-5.4-24l0-24zm-90.6 0L56 208c-30.9 0-56-25.1-56-56S25.1 96 56 96l200 0c14.6-19.4 37.8-32 64-32l32 0c88.4 0 160 71.6 160 160l0 64c0 88.4-71.6 160-160 160l-104 0c-30.9 0-56-25.1-56-56 0-12.1 3.8-23.3 10.4-32.5-15.8-9.9-26.4-27.5-26.4-47.5 0-9.7 2.5-18.8 6.8-26.7-22.5-7.3-38.8-28.4-38.8-53.3 0-8.6 1.9-16.7 5.4-24zM272 288l-40 0c-13.2 0-24 10.8-24 24 0 13.3 10.7 24 24 24l64 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-24 0zm0 128l32 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-56 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l24 0z"]],
    "calculator": [384, 512, [128425], "f1ec", ["M32 160l0 288c0 17.7 14.3 32 32 32l256 0c17.7 0 32-14.3 32-32l0-288-320 0zM64 416c0-8.8 7.2-16 16-16l128 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L80 432c-8.8 0-16-7.2-16-16zm56-192a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm0 96a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm96-96a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm0 96a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm96-96a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm0 96a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm-48 96c0-13.3 10.7-24 24-24s24 10.7 24 24-10.7 24-24 24-24-10.7-24-24z", "M352 160l0 288c0 17.7-14.3 32-32 32L64 480c-17.7 0-32-14.3-32-32l0-288 320 0zm0-32l-320 0 0-64c0-17.7 14.3-32 32-32l256 0c17.7 0 32 14.3 32 32l0 64zm32 0l0-64c0-35.3-28.7-64-64-64L64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-320zM72 224a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm24 72a24 24 0 1 0 0 48 24 24 0 1 0 0-48zm72-72a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm24 72a24 24 0 1 0 0 48 24 24 0 1 0 0-48zm72-72a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm24 72a24 24 0 1 0 0 48 24 24 0 1 0 0-48zM264 416c0 13.3 10.7 24 24 24s24-10.7 24-24-10.7-24-24-24-24 10.7-24 24zM80 400c-8.8 0-16 7.2-16 16s7.2 16 16 16l128 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L80 400z"]],
    "oil-temperature": [640, 512, ["oil-temp"], "f614", ["M272 304a48 48 0 1 0 96 0 48 48 0 1 0 -96 0z", "M592 372c10.1 0 14.2 8.2 18.6 15.5 12.9 21 29.4 46.9 29.4 72.5 0 28-18.8 52-48 52-28.2 0-48-25.1-48-52 0-25.7 16.5-51.6 29.4-72.5 4.5-7.3 8.6-15.5 18.6-15.5zm22.4-151.2c18.1-4 30.8 17.5 18.6 31.4L451.1 458.3c-12.1 13.8-29.6 21.7-48 21.7l-259.1 0-4.9-.2C114.9 477.3 96 456.8 96 432l0-28-64.8-24.3c-17.6-6.6-29.6-22.7-31-41.2L0 334.7 0 272c0-26.5 21.5-48 48-48l172.1 0c-7.7 9.6-14.1 20.4-18.8 32l-73.3 0 0 176c0 8.8 7.2 16 16 16l259.1 0c9.2 0 17.9-3.9 24-10.8l155.8-176.6-135.6 30.1c-1.1-10.8-3.6-21.3-7.3-31.2l174.4-38.7zM592 419c-6.5 11.7-16 27-16 41 0 12.9 8.9 20 16 20 11.6 0 16-9.5 16-20 0-13.9-9.5-29.2-16-41zM400 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-64 0 0 64 64 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-64 0 0 97.6c36.5 7.4 64 39.7 64 78.4 0 44.2-35.8 80-80 80s-80-35.8-80-80c0-38.7 27.5-71 64-78.4L304 16c0-8.8 7.2-16 16-16l80 0zM48 256c-8.8 0-16 7.2-16 16l0 62.7c0 6.7 4.1 12.6 10.4 15L96 369.8 96 256 48 256zm272 0a48 48 0 1 0 0 96 48 48 0 1 0 0-96z"]],
    "minus": [448, 512, [8211, 8722, 10134, "subtract"], "f068", ["", "M0 256c0-8.8 7.2-16 16-16l416 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L16 272c-8.8 0-16-7.2-16-16z"]],
    "message-arrow-down": [512, 512, ["comment-alt-arrow-down"], "e1db", ["M32 128l0 224c0 35.3 28.7 64 64 64l40 0c13.3 0 24 10.7 24 24l0 68 112-84c6.9-5.2 15.3-8 24-8l120 0c35.3 0 64-28.7 64-64l0-224c0-35.3-28.7-64-64-64L96 64c-35.3 0-64 28.7-64 64zM172.7 236.7c6.2-6.2 16.4-6.2 22.6 0L240 281.4 240 160c0-8.8 7.2-16 16-16s16 7.2 16 16l0 121.4 44.7-44.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6l-72 72c-6.2 6.2-16.4 6.2-22.6 0l-72-72c-6.2-6.2-6.2-16.4 0-22.6z", "M179.2 533.6l0 0 112-84c1.4-1 3.1-1.6 4.8-1.6l120 0c53 0 96-43 96-96l0-224c0-53-43-96-96-96L96 32C43 32 0 75 0 128L0 352c0 53 43 96 96 96l32 0 0 68c0 15.5 12.5 28 28 28 6.1 0 12-2 16.8-5.6l6.4-4.8zM160 448l0-8c0-13.3-10.7-24-24-24l-40 0c-35.3 0-64-28.7-64-64l0-224c0-35.3 28.7-64 64-64l320 0c35.3 0 64 28.7 64 64l0 224c0 35.3-28.7 64-64 64l-120 0c-8.7 0-17.1 2.8-24 8l-112 84 0-60zm84.7-116.7c6.2 6.2 16.4 6.2 22.6 0l72-72c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0L272 281.4 272 160c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 121.4-44.7-44.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l72 72z"]],
    "shoe": [640, 512, [], "e6d8", ["M32 224l0 128 573 0c-7.6-29.6-29.1-54.4-58.5-65.7l-92.8-35.7c-9.8-3.8-19.3-8.2-28.4-13.3l-38 38c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l33.3-33.2c-4.7-3.6-9.3-7.4-13.7-11.4l-30.3-27.3-38.6 38.6c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l37.4-37.4-67.4-60.7c-1.9-1.7-4.3-2.6-6.8-2.6-4.5 0-8.5 3-9.8 7.4l-1.9 6.7C227.5 168.1 174.6 208 114.3 208L48 208c-8.8 0-16 7.2-16 16z", "M160 384l0 16c0 8.8-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16l0-16 128 0zM32 352l0-128c0-8.8 7.2-16 16-16l66.3 0c60.3 0 113.2-39.9 129.8-97.9l1.9-6.7c1.2-4.4 5.2-7.4 9.8-7.4 2.5 0 4.9 .9 6.8 2.6l67.4 60.7-37.4 37.4c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l38.6-38.6 30.3 27.3c4.4 4 9 7.8 13.7 11.4l-33.3 33.2c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l38-38c9.1 5.1 18.6 9.5 28.4 13.3l92.8 35.7c29.4 11.3 50.9 36.1 58.5 65.7L32 352zm576 32l0 16c0 8.8-7.2 16-16 16l-273.8 0c-14.9 0-29.6-3.5-42.9-10.1L231.6 384 608 384zM222.5 415.3L261 434.5c17.8 8.9 37.4 13.5 57.2 13.5L592 448c26.5 0 48-21.5 48-48l0-24.1c0-53-32.6-100.5-82.1-119.5l-92.8-35.7c-21.9-8.4-42.1-20.8-59.5-36.5L284 74.8c-7.7-7-17.8-10.8-28.2-10.8-18.8 0-35.4 12.5-40.6 30.6l-1.9 6.7c-12.6 44.2-53 74.7-99 74.7L48 176c-26.5 0-48 21.5-48 48L0 400c0 26.5 21.5 48 48 48l96 0c15 0 28.4-6.9 37.2-17.6 6.8-8.3 10.8-18.8 10.8-30.4l30.5 15.3z"]],
    "game-board-simple": [448, 512, ["game-board-alt"], "f868", ["M96 128l0 112 112 0 0-112-112 0zM240 272l0 112 112 0 0-112-112 0z", "M390.5 32.3C422.8 35.6 448 62.9 448 96l0 320-.3 6.5c-3.1 30.1-27 54.1-57.1 57.1l-6.5 .3-320 0-6.5-.3c-30.1-3.1-54.1-27-57.1-57.1L0 416 0 96C0 62.9 25.2 35.6 57.5 32.3l6.5-.3 320 0 6.5 .3zM64 64C46.3 64 32 78.3 32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64zM355.3 96.2C371.4 97.8 384 111.4 384 128l0 256-.2 3.3c-1.5 15.1-13.5 27-28.6 28.6l-3.3 .2-256 0-3.3-.2c-15.1-1.5-27-13.5-28.6-28.6L64 384 64 128c0-16.6 12.6-30.2 28.7-31.8l3.3-.2 256 0 3.3 .2zM240 384l112 0 0-112-112 0 0 112zM96 384l112 0 0-112-112 0 0 112zM240 240l112 0 0-112-112 0 0 112zM96 240l112 0 0-112-112 0 0 112z"]],
    "arrow-turn-left": [512, 512, [], "e632", ["", "M480 432c0 8.8 7.2 16 16 16s16-7.2 16-16l0-96c0-53-43-96-96-96L54.6 240 171.3 123.3c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-144 144c-3 3-4.7 7.1-4.7 11.3s1.7 8.3 4.7 11.3l144 144c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L54.6 272 416 272c35.3 0 64 28.7 64 64l0 96z"]],
    "circle-4": [512, 512, [], "e0f1", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm144-80c0-8.8 7.2-16 16-16s16 7.2 16 16l0 72c0 4.4 3.6 8 8 8l72 0 0-80c0-8.8 7.2-16 16-16s16 7.2 16 16l0 80c8.8 0 16 7.2 16 16s-7.2 16-16 16l0 48c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-48-72 0c-22.1 0-40-17.9-40-40l0-72z", "M256 32a224 224 0 1 1 0 448 224 224 0 1 1 0-448zm0 480a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM192 160c-8.8 0-16 7.2-16 16l0 72c0 22.1 17.9 40 40 40l72 0 0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48c8.8 0 16-7.2 16-16s-7.2-16-16-16l0-80c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 80-72 0c-4.4 0-8-3.6-8-8l0-72c0-8.8-7.2-16-16-16z"]],
    "hammer-war": [448, 512, [], "f6e4", ["M32 68.9l0 198.2 187.5-26.8c3-.4 6-.4 9.1 0L416 267.1 416 68.9 228.5 95.7c-3 .4-6 .4-9.1 0L32 68.9z", "M224 0c8.8 0 16 7.2 16 16l0 45.7 171.5-24.5C430.8 34.5 448 49.4 448 68.9l0 198.2c0 19.5-17.2 34.4-36.5 31.7L240 274.3 240 528c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-253.7-171.5 24.5C17.2 301.5 0 286.6 0 267.1L0 68.9C0 49.4 17.2 34.5 36.5 37.2L208 61.7 208 16c0-8.8 7.2-16 16-16zM416 267.1l0-198.2-187.5 26.8c-3 .4-6 .4-9.1 0L32 68.9 32 267.1 219.5 240.3c3-.4 6-.4 9.1 0L416 267.1z"]],
    "light-emergency": [448, 512, [], "e41f", ["M32 368l0 64c0 8.8 7.2 16 16 16l352 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16L48 352c-8.8 0-16 7.2-16 16zM96 192l0 128 256 0 0-128c0-70.7-57.3-128-128-128S96 121.3 96 192zm32 0c0-53 43-96 96-96 8.8 0 16 7.2 16 16s-7.2 16-16 16c-35.3 0-64 28.7-64 64 0 8.8-7.2 16-16 16s-16-7.2-16-16z", "M400 320l-16 0 0-128c0-88.4-71.6-160-160-160S64 103.6 64 192l0 128-16 0c-26.5 0-48 21.5-48 48l0 64c0 26.5 21.5 48 48 48l352 0c26.5 0 48-21.5 48-48l0-64c0-26.5-21.5-48-48-48zM352 192l0 128-256 0 0-128c0-70.7 57.3-128 128-128s128 57.3 128 128zM48 352l352 0c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16L48 448c-8.8 0-16-7.2-16-16l0-64c0-8.8 7.2-16 16-16zM160 192c0-35.3 28.7-64 64-64 8.8 0 16-7.2 16-16s-7.2-16-16-16c-53 0-96 43-96 96 0 8.8 7.2 16 16 16s16-7.2 16-16z"]],
    "arrow-up-z-a": [512, 512, ["sort-alpha-up-alt"], "f882", ["", "M139.3 36.7c-6.2-6.2-16.4-6.2-22.6 0l-96 96c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0L112 86.6 112 464c0 8.8 7.2 16 16 16s16-7.2 16-16l0-377.4 68.7 68.7c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-96-96zM312 32c-8.8 0-16 7.2-16 16s7.2 16 16 16l108.1 0-120 133.3c-4.2 4.7-5.3 11.4-2.7 17.2s8.3 9.5 14.6 9.5l144 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-108.1 0 120-133.3c4.2-4.7 5.3-11.4 2.7-17.2S462.3 32 456 32L312 32zm86.3 264.8c-2.7-5.4-8.2-8.8-14.3-8.8s-11.6 3.4-14.3 8.8L305.8 424.6c-.1 .2-.2 .4-.3 .6l-15.8 31.7c-4 7.9-.7 17.5 7.2 21.5s17.5 .7 21.5-7.2l11.6-23.2 108.2 0 11.6 23.2c4 7.9 13.6 11.1 21.5 7.2s11.1-13.6 7.2-21.5l-15.8-31.7c-.1-.2-.2-.4-.3-.6L398.3 296.8zM422.1 416l-76.2 0 38.1-76.2 38.1 76.2z"]],
    "microphone-slash": [576, 512, [], "f131", ["M224 96l0 73.5 104.3 104.3C342.7 262 352 244.1 352 224l0-128c0-35.3-28.7-64-64-64s-64 28.7-64 64z", "M27.3-27.2c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l544 544c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L419 364.4c37.6-35 61-85 61-140.4l0-48c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 48c0 46.6-19.9 88.5-51.7 117.8L351 296.5c20.2-17.6 33-43.5 33-72.5l0-128c0-53-43-96-96-96s-96 43-96 96l0 41.5-164.7-164.7zM224 169.5L224 96c0-35.3 28.7-64 64-64s64 28.7 64 64l0 128c0 20.1-9.3 38-23.7 49.7L224 169.5zm-120.2-7.2c-4.7 2.8-7.8 7.9-7.8 13.7l0 48c0 100.6 77.4 183.2 176 191.3l0 64.7-64 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l160 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-64 0 0-64.7c15.2-1.3 29.9-4.3 43.9-8.9l-26.1-26.1c-10.9 2.4-22.3 3.6-33.9 3.6-88.4 0-160-71.6-160-160l0-37.5-24.2-24.2z"]],
    "square-pen": [448, 512, ["pen-square", "pencil-square"], "f14b", ["M32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64C46.3 64 32 78.3 32 96zM96.5 364.3l18.7-74.9c2.1-8.4 6.5-16.2 12.6-22.3L254.2 140.7c18.7-18.7 49.1-18.7 67.9 0l17.4 17.4c18.7 18.7 18.7 49.1 0 67.9L213.1 352.3c-6.2 6.2-13.9 10.5-22.3 12.6l-74.9 18.7c-5.5 1.4-11.2-.2-15.2-4.2s-5.6-9.7-4.2-15.2z", "M64 64C46.3 64 32 78.3 32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm299.5 67.3c-6.2-6.2-16.4-6.2-22.6 0l-21.4 21.4 40 40 21.4-21.4c6.2-6.2 6.2-16.4 0-22.6l-17.4-17.4zm-149 126.4c-2.1 2.1-3.5 4.6-4.2 7.4l-12.3 49 49-12.3c2.8-.7 5.4-2.2 7.4-4.2l82.3-82.3-40-40-82.3 82.3zm103.8-149c18.7-18.7 49.1-18.7 67.9 0l17.4 17.4c18.7 18.7 18.7 49.1 0 67.9L213.1 352.3c-6.2 6.2-13.9 10.5-22.3 12.6l-74.9 18.7c-5.5 1.4-11.2-.2-15.2-4.2s-5.6-9.7-4.2-15.2l18.7-74.9c2.1-8.4 6.5-16.2 12.6-22.3L254.2 140.7z"]],
    "bell-plus": [448, 512, [], "f849", ["M32 368.6c0 8.5 6.9 15.4 15.4 15.4l353.2 0c8.5 0 15.4-6.9 15.4-15.4 0-3.5-1.2-6.9-3.4-9.6l-10.1-12.6C369.8 305.5 352 254.7 352 202.3l0-10.3c0-70.7-57.3-128-128-128S96 121.3 96 192l0 10.3c0 52.4-17.8 103.2-50.6 144.1L35.4 359c-2.2 2.7-3.4 6.1-3.4 9.6zM136 224c0-8.8 7.2-16 16-16l56 0 0-56c0-8.8 7.2-16 16-16s16 7.2 16 16l0 56 56 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-56 0 0 56c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-56-56 0c-8.8 0-16-7.2-16-16z", "M208 16c0-8.8 7.2-16 16-16s16 7.2 16 16l0 16.8c80.9 8 144 76.2 144 159.2l0 10.3c0 45.1 15.4 88.9 43.5 124.1L437.6 339c6.7 8.4 10.4 18.8 10.4 29.6 0 26.2-21.2 47.4-47.4 47.4L47.4 416C21.2 416 0 394.8 0 368.6 0 357.9 3.7 347.4 10.4 339l10.1-12.6C48.6 291.2 64 247.4 64 202.3L64 192c0-83 63.1-151.2 144-159.2L208 16zM96 192l0 10.3c0 52.4-17.8 103.2-50.6 144.1L35.4 359c-2.2 2.7-3.4 6.1-3.4 9.6 0 8.5 6.9 15.4 15.4 15.4l353.2 0c8.5 0 15.4-6.9 15.4-15.4 0-3.5-1.2-6.9-3.4-9.6l-10.1-12.6C369.8 305.5 352 254.7 352 202.3l0-10.3c0-70.7-57.3-128-128-128S96 121.3 96 192zM224 512c-31.3 0-58-20-67.9-48l35.9 0c7.3 9.7 18.9 16 32 16s24.7-6.3 32-16l35.9 0c-9.9 28-36.6 48-67.9 48zM208 296l0-56-56 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l56 0 0-56c0-8.8 7.2-16 16-16s16 7.2 16 16l0 56 56 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-56 0 0 56c0 8.8-7.2 16-16 16s-16-7.2-16-16z"]],
    "hand-fist": [384, 512, [9994, "fist-raised"], "f6de", ["M128 56c0-22.1 17.9-40 40-40s40 17.9 40 40l0 32c0-22.1 17.9-40 40-40s40 17.9 40 40l0 64c0-22.1 17.9-40 40-40s40 17.9 40 40l0 104c0 44.1-22.3 82.9-56.2 106-4.7 3.2-7.8 8.4-7.8 14.1l0 135.9-192 0 0-115.3c0-8-5.9-14.6-13.6-16.7-47.5-13-82.4-56.4-82.4-108.1 0-13.9 7.3-42.4 34.5-58-1.6-4.4-2.5-9.1-2.5-14L48 88c0-22.1 17.9-40 40-40s40 17.9 40 40l0-32z", "M222.2 233.7c7.7 4 16.5 6.3 25.8 6.3 12.1 0 23.3-3.8 32.5-10.4 9.9 15.8 27.5 26.4 47.5 26.4 8.6 0 16.7-1.9 24-5.4l0 5.4c0 38.6-19.5 72.6-49.2 92.7-8.6 5.8-14.8 15.7-14.8 27.4L288 496c0 8.8 7.2 16 16 16s16-7.2 16-16l0-119.9 0-.1 .1-.1c.1-.2 .3-.5 .7-.7 38.1-25.9 63.2-69.6 63.2-119.2l0-104c0-30.9-25.1-56-56-56-8.6 0-16.7 1.9-24 5.4L304 88c0-30.9-25.1-56-56-56-9.7 0-18.8 2.5-26.7 6.8-7.3-22.5-28.4-38.8-53.3-38.8s-46 16.3-53.3 38.8c-7.9-4.3-17-6.8-26.7-6.8-30.9 0-56 25.1-56 56l0 112c0 2.6 .2 5.1 .5 7.6-19.7 14.6-32.5 38-32.5 64.4 0 59 39.9 108.7 94.2 123.5 .8 .2 1.3 .6 1.6 1 .1 .2 .2 .3 .2 .3l0 0 0 99.3c0 8.8 7.2 16 16 16s16-7.2 16-16l0-99.3c0-16.3-11.9-28.4-25.4-32.1-40.7-11.1-70.6-48.4-70.6-92.6 0-26.5 21.5-48 48-48l88 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-56 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l56 0c30.9 0 56-25.1 56-56 0-4.9-.6-9.7-1.8-14.3zM192 197.4c-7.3-3.5-15.4-5.4-24-5.4l-24 0 0-136c0-13.3 10.7-24 24-24s24 10.7 24 24l0 141.4zM112 192l-32 0c-5.5 0-10.8 .6-16 1.6L64 88c0-13.3 10.7-24 24-24s24 10.7 24 24l0 104zm240 0l0 8c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-48c0-13.3 10.7-24 24-24s24 10.7 24 24l0 40zM224 88c0-13.3 10.7-24 24-24s24 10.7 24 24l0 96c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-96z"]],
    "pants": [512, 512, [], "e6d5", ["M40.9 460.6c-2.5 13 6 25.6 19 28.1l80 15.4c12.7 2.4 25-5.6 27.9-18.1l72.7-313.6c1.7-7.3 8.1-12.4 15.6-12.4s13.9 5.1 15.6 12.4L344.6 486c2.9 12.6 15.2 20.6 27.9 18.1l80-15.4c13-2.5 21.5-15.1 19-28.1l-64-332.6-55.3 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l49.2 0-8.6-44.5C390.7 40.2 380.8 32 369.3 32L143.2 32c-11.5 0-21.4 8.2-23.6 19.5l-8.6 44.5 49.2 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-55.3 0-64 332.6z", "M88.2 45.4C93.3 19.1 116.3 0 143.2 0L369.3 0c26.9 0 49.9 19.1 55 45.4L503 454.6c5.8 30.4-14 59.7-44.4 65.6l-80 15.4c-29.6 5.7-58.3-13-65.1-42.3l-57.2-246.4-57.2 246.4c-6.8 29.3-35.6 48-65.1 42.3l-80-15.4C23.6 514.3 3.7 485 9.5 454.6L88.2 45.4zm55-13.4c-11.5 0-21.4 8.2-23.6 19.5l-8.6 44.5 49.2 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-55.3 0-64 332.6c-2.5 13 6 25.6 19 28.1l80 15.4c12.7 2.4 25-5.6 27.9-18.1l72.7-313.6c1.7-7.3 8.1-12.4 15.6-12.4s13.9 5.1 15.6 12.4L344.6 486c2.9 12.6 15.2 20.6 27.9 18.1l80-15.4c13-2.5 21.5-15.1 19-28.1l-64-332.6-55.3 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l49.2 0-8.6-44.5C390.7 40.2 380.8 32 369.3 32L143.2 32z"]],
    "comment-sms": [512, 512, ["sms"], "f7cd", ["M32 240c0 46.7 16.5 89.8 44.8 124.8 8.1 10.1 9.4 24.1 3.2 35.4l-40.2 73.6 101-43.3c7.9-3.4 16.8-3.5 24.8-.2 27.6 11.3 58.2 17.6 90.4 17.6 125.7 0 224-95 224-208S381.7 32 256 32 32 127 32 240zm67.2-27.5c0-21.9 17.8-39.7 39.7-39.7l21.1 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-21.1 0c-4.3 0-7.7 3.5-7.7 7.7 0 2.9 1.7 5.6 4.3 6.9l25 12.5c13.5 6.7 22 20.5 22 35.5 0 21.9-17.8 39.7-39.7 39.7l-27.5 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l27.5 0c4.3 0 7.7-3.5 7.7-7.7 0-2.9-1.7-5.6-4.3-6.9l-25-12.5c-13.5-6.7-22-20.5-22-35.5zm102.4-23.7c0-7.2 4.8-13.5 11.7-15.4s14.3 1 18 7.2l24.7 41.1 24.7-41.1c3.7-6.2 11.1-9.1 18-7.2s11.7 8.2 11.7 15.4l0 102.4c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-44.6-8.7 14.5c-2.9 4.8-8.1 7.8-13.7 7.8s-10.8-3-13.7-7.8l-8.7-14.5 0 44.6c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-102.4zm128 23.7c0-21.9 17.8-39.7 39.7-39.7l21.1 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-21.1 0c-4.3 0-7.7 3.5-7.7 7.7 0 2.9 1.7 5.6 4.3 6.9l25 12.5c13.5 6.7 22 20.5 22 35.5 0 21.9-17.8 39.7-39.7 39.7l-27.5 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l27.5 0c4.3 0 7.7-3.5 7.7-7.7 0-2.9-1.7-5.6-4.3-6.9l-25-12.5c-13.5-6.7-22-20.5-22-35.5z", "M80 400.2c6.2-11.4 4.9-25.4-3.2-35.4-28.2-34.9-44.8-78.1-44.8-124.8 0-113 98.3-208 224-208s224 95 224 208-98.3 208-224 208c-32.3 0-62.8-6.3-90.4-17.6-7.9-3.3-16.9-3.2-24.8 .2L39.8 473.8 80 400.2zM0 240c0 54.4 19.3 104.6 51.9 144.9L3.1 474.3c-2 3.7-3.1 7.9-3.1 12.2 0 14.1 11.4 25.5 25.5 25.5 4 0 7.8-.6 11.5-2.1L153.4 460c31.4 12.9 66.1 20 102.6 20 141.4 0 256-107.5 256-240S397.4 0 256 0 0 107.5 0 240zm138.9-67.2c-21.9 0-39.7 17.8-39.7 39.7 0 15 8.5 28.8 22 35.5l25 12.5c2.6 1.3 4.3 4 4.3 6.9 0 4.3-3.5 7.7-7.7 7.7l-27.5 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l27.5 0c21.9 0 39.7-17.8 39.7-39.7 0-15.1-8.5-28.8-22-35.5l-25-12.5c-2.6-1.3-4.3-4-4.3-6.9 0-4.3 3.5-7.7 7.7-7.7l21.1 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-21.1 0zm190.7 39.7c0 15 8.5 28.8 22 35.5l25 12.5c2.6 1.3 4.3 4 4.3 6.9 0 4.3-3.5 7.7-7.7 7.7l-27.5 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l27.5 0c21.9 0 39.7-17.8 39.7-39.7 0-15.1-8.5-28.8-22-35.5l-25-12.5c-2.6-1.3-4.3-4-4.3-6.9 0-4.3 3.5-7.7 7.7-7.7l21.1 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-21.1 0c-21.9 0-39.7 17.8-39.7 39.7zm-98.3-32c-3.7-6.2-11.1-9.1-18-7.2s-11.7 8.2-11.7 15.4l0 102.4c0 8.8 7.2 16 16 16s16-7.2 16-16l0-44.6 8.7 14.5c2.9 4.8 8.1 7.8 13.7 7.8s10.8-3 13.7-7.8l8.7-14.5 0 44.6c0 8.8 7.2 16 16 16s16-7.2 16-16l0-102.4c0-7.2-4.8-13.5-11.7-15.4s-14.3 1-18 7.2l-24.7 41.1-24.7-41.1z"]],
    "head-side-gear": [512, 512, [], "e611", ["M32 216c0 53.3 22.6 101.3 58.9 134.9 3.3 3 5.1 7.3 5.1 11.7L96 496c0 5.9-3.2 11.1-8 13.9l0 2.1 216 0c-8.8 0-16-7.2-16-16l0-64c0-8.8 7.2-16 16-16l48 0c26.5 0 48-21.5 48-48l0-48c0-8.8 7.2-16 16-16l18.7 0c16.2 0 29.3-13.1 29.3-29.3 0-7.8-3.1-15.2-8.6-20.7l-52.4-52.4c-2.5-2.5-4.1-5.8-4.6-9.3-11.6-90.5-88.9-160.4-182.5-160.4-101.6 0-184 82.4-184 184zm73.2-58.1l16-27.7c8.8-15.3 28.4-20.5 43.7-11.7l.6 .3c.9 .5 3.3 1 6.5-.8 3.3-1.9 4.1-4.3 4.1-5.3l0-.7c0-17.7 14.3-32 32-32l32 0c17.7 0 32 14.3 32 32l0 .7c0 1 .8 3.4 4.1 5.3 3.2 1.8 5.5 1.4 6.5 .8l.6-.3c15.3-8.8 34.9-3.6 43.7 11.7l16 27.7c8.8 15.3 3.6 34.9-11.7 43.7l-.6 .3c-.9 .5-2.6 2.4-2.6 6.1s1.6 5.6 2.5 6.1l.6 .3c15.3 8.8 20.6 28.4 11.7 43.7l-16 27.7c-5.8 10-16.1 15.7-26.9 16-.5 0-1 0-1.6 0-5.2-.1-10.5-1.5-15.3-4.3l-.6-.3c-.4-.2-1-.4-1.9-.5-.3 0-.5 0-.8 0-1.1 .1-2.4 .5-3.8 1.3-3.3 1.9-4.1 4.3-4.1 5.3l0 .7c0 17.3-13.7 31.4-30.9 32-.4 0-.7 0-1.1 0l-32 0c-.4 0-.8 0-1.2 0-17.1-.6-30.8-14.7-30.8-32l0-.7c0-1-.8-3.4-4.1-5.3-1.5-.9-2.8-1.2-3.9-1.3-.2 0-.5 0-.7 0-.9 0-1.5 .3-1.9 .5l-.6 .3c-4.8 2.8-10.1 4.2-15.3 4.3-.5 0-1 0-1.6 0-10.8-.3-21.1-6-26.9-16l-16-27.7c-8.8-15.3-3.6-34.9 11.7-43.7l.6-.3c.9-.5 2.6-2.4 2.6-6.1s-1.6-5.6-2.6-6.1l-.6-.3c-15.3-8.8-20.5-28.4-11.7-43.7z", "M32 216c0-101.6 82.4-184 184-184 93.6 0 170.9 69.9 182.5 160.4 .5 3.5 2.1 6.8 4.6 9.3l52.4 52.4c5.5 5.5 8.6 12.9 8.6 20.7 0 16.2-13.1 29.3-29.3 29.3L416 304c-8.8 0-16 7.2-16 16l0 48c0 26.5-21.5 48-48 48l-48 0c-8.8 0-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48 32 0c44.2 0 80-35.8 80-80l0-32 2.7 0c33.8 0 61.3-27.4 61.3-61.3 0-16.2-6.5-31.8-17.9-43.3l-48.6-48.6C413.5 79.3 324 0 216 0 96.7 0 0 96.7 0 216 0 276 24.5 330.3 64 369.5L64 496c0 8.8 7.2 16 16 16s16-7.2 16-16l0-133.4c0-4.5-1.9-8.7-5.1-11.7-36.2-33.6-58.9-81.6-58.9-134.9zM176 112l0 .7c0 1-.8 3.4-4.1 5.3-3.2 1.8-5.5 1.4-6.5 .8l-.6-.3c-15.3-8.8-34.9-3.6-43.7 11.7l-16 27.7c-8.8 15.3-3.6 34.9 11.7 43.7l.6 .3c.9 .5 2.6 2.4 2.6 6.1s-1.6 5.6-2.6 6.1l-.6 .3c-15.3 8.8-20.5 28.4-11.7 43.7l16 27.7c8.8 15.3 28.4 20.6 43.7 11.7l.6-.3c.9-.5 3.3-1 6.5 .8 3.3 1.9 4.1 4.3 4.1 5.3l0 .7c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-.7c0-1 .8-3.4 4.1-5.3 3.2-1.8 5.5-1.4 6.5-.8l.6 .3c15.3 8.8 34.9 3.6 43.7-11.7l16-27.7c8.8-15.3 3.6-34.9-11.7-43.7l-.6-.3c-.9-.5-2.5-2.4-2.5-6.1s1.6-5.6 2.6-6.1l.6-.3c15.3-8.8 20.6-28.4 11.7-43.7l-16-27.7c-8.8-15.3-28.4-20.5-43.7-11.7l-.6 .3c-.9 .5-3.3 1-6.5-.8-3.3-1.9-4.1-4.3-4.1-5.3l0-.7c0-17.7-14.3-32-32-32l-32 0c-17.7 0-32 14.3-32 32zm64 0l0 .7c0 15.1 9.4 26.8 20 33 10.7 6.2 25.5 8.3 38.5 .8l.6-.3 16 27.7-.6 .3c-13 7.5-18.6 21.4-18.6 33.8s5.5 26.3 18.6 33.8l.6 .3-16 27.7-.6-.3c-13-7.5-27.8-5.4-38.5 .8-10.6 6.2-20 17.9-20 33l0 .7-32 0 0-.7c0-15.1-9.4-26.8-20-33-10.7-6.2-25.5-8.3-38.5-.8l-.6 .3-16-27.7 .6-.3c13-7.5 18.6-21.4 18.6-33.8s-5.5-26.3-18.6-33.8l-.6-.3 16-27.7 .6 .3c13 7.5 27.8 5.4 38.5-.8 10.6-6.2 20-17.9 20-33l0-.7 32 0zm8 96a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"]],
    "transporter-1": [576, 512, [], "e043", ["M240 156.7c14.4-8.2 30.9-12.7 48-12.7s33.6 4.5 48 12.7l0 163.3-96 0 0-163.3zM312 24a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M288 48a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm0-80a56 56 0 1 1 0 112 56 56 0 1 1 0-112zM208 186.1c-1.1 1.6-2.2 3.3-3.2 5L141.7 296.2c-4.5 7.6-14.4 10-22 5.5s-10-14.4-5.5-21.9l63.1-105.1C200.7 135.8 242.7 112 288 112s87.3 23.8 110.6 62.6l63.1 105.1c4.5 7.6 2.1 17.4-5.5 21.9s-17.4 2.1-22-5.5L371.2 191.1c-1-1.7-2.1-3.4-3.2-5l0 133.9-32 0 0-163.3c-14.4-8.2-30.9-12.7-48-12.7s-33.6 4.5-48 12.7l0 163.3-32 0 0-133.9zM144 544c-8.8 0-16-7.2-16-16s7.2-16 16-16l288 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-288 0zM536.7 134.6l7.3 25.4 25.4 7.3c3.9 1.1 6.6 4.7 6.6 8.7s-2.7 7.6-6.6 8.7l-25.4 7.3-7.3 25.4c-1.1 3.9-4.7 6.6-8.7 6.6s-7.6-2.7-8.7-6.6l-7.3-25.4-25.4-7.3c-3.9-1.1-6.6-4.7-6.6-8.7s2.7-7.6 6.6-8.7l25.4-7.3 7.3-25.4c1.1-3.9 4.7-6.6 8.7-6.6s7.6 2.7 8.7 6.6zm-480 192L64 352 89.4 359.3c3.9 1.1 6.6 4.7 6.6 8.7s-2.7 7.6-6.6 8.7L64 384 56.7 409.4c-1.1 3.9-4.7 6.6-8.7 6.6s-7.6-2.7-8.7-6.6L32 384 6.6 376.7C2.7 375.6 0 372.1 0 368s2.7-7.6 6.6-8.7L32 352 39.3 326.6c1.1-3.9 4.7-6.6 8.7-6.6s7.6 2.7 8.7 6.6zM192 384c0-8.8 7.2-16 16-16l160 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-160 0c-8.8 0-16-7.2-16-16zm0 64c0-8.8 7.2-16 16-16l160 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-160 0c-8.8 0-16-7.2-16-16z"]],
    "scanner-touchscreen": [512, 512, [], "f48a", ["M32 160l0 288c0 17.7 14.3 32 32 32l192 0c17.7 0 32-14.3 32-32l0-288c0-17.7-14.3-32-32-32L64 128c-17.7 0-32 14.3-32 32zm32 24c0-13.3 10.7-24 24-24l144 0c13.3 0 24 10.7 24 24l0 240c0 13.3-10.7 24-24 24L88 448c-13.3 0-24-10.7-24-24l0-240zm32 8l0 224 128 0 0-224-128 0z", "M128-32c-8.8 0-16 7.2-16 16l0 64 32 0 0-64c0-8.8-7.2-16-16-16zM352-16c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 84.1c12.9 9 23.8 20.7 32 34.2L352-16zm-64 0c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 64c11.1 0 21.9 1.6 32 4.6L288-16zm-64 0c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 64 32 0 0-64zM496-32c-8.8 0-16 7.2-16 16l0 288c0 8.8 7.2 16 16 16s16-7.2 16-16l0-288c0-8.8-7.2-16-16-16zm-80 0c-8.8 0-16 7.2-16 16l0 288c0 8.8 7.2 16 16 16s16-7.2 16-16l0-288c0-8.8-7.2-16-16-16zM256 128c17.7 0 32 14.3 32 32l0 288c0 17.7-14.3 32-32 32L64 480c-17.7 0-32-14.3-32-32l0-288c0-17.7 14.3-32 32-32l192 0zM64 96C28.7 96 0 124.7 0 160L0 448c0 35.3 28.7 64 64 64l192 0c35.3 0 64-28.7 64-64l0-288c0-35.3-28.7-64-64-64L64 96zm32 96l128 0 0 224-128 0 0-224zm-8-32c-13.3 0-24 10.7-24 24l0 240c0 13.3 10.7 24 24 24l144 0c13.3 0 24-10.7 24-24l0-240c0-13.3-10.7-24-24-24L88 160z"]],
    "flask-round-potion": [384, 512, ["flask-potion"], "f6e1", ["M32.9 337.4l6.2-3.1 31.1-15.5c19.4-9.7 40.9-14.8 62.6-14.8 25.4 0 50.2 6.9 72 19.9l5 3c27.4 16.4 58.7 25.1 90.6 25.1l48.5 0C334 425 269.4 480 192 480 109.5 480 41.6 417.6 32.9 337.4z", "M80 32l16 0 0 121.7C38.6 186.9 0 248.9 0 320 0 426 86 512 192 512s192-86 192-192c0-71.1-38.6-133.1-96-166.3l0-121.7 16 0c8.8 0 16-7.2 16-16S312.8 0 304 0L80 0C71.2 0 64 7.2 64 16s7.2 16 16 16zm48 131.2l0-131.2 128 0 0 131.2c0 6 3.4 11.5 8.7 14.2 51.8 26.5 87.3 80.4 87.3 142.6l-51.7 0c-26.1 0-51.7-7.1-74.1-20.5l-5-3c-26.7-16-57.3-24.5-88.5-24.5-26.7 0-53 6.2-76.9 18.2L33 301.6c6.2-54.3 39.6-100.3 86.2-124.2 5.4-2.7 8.7-8.2 8.7-14.2zM32.9 337.4l6.2-3.1 31.1-15.5c19.4-9.7 40.9-14.8 62.6-14.8 25.4 0 50.2 6.9 72 19.9l5 3c27.4 16.4 58.7 25.1 90.6 25.1l48.5 0C334 425 269.4 480 192 480 109.5 480 41.6 417.6 32.9 337.4z"]],
    "car-bolt": [512, 512, [], "e341", ["M32 256l0 128 448 0 0-128c0-17.7-14.3-32-32-32l-64 0c0-8.2-1.6-16.6-4.9-24.5-1.1-2.6-2.3-5.1-3.7-7.5l-128.8 0-16 16 89.4 0c6.5 0 12.3 3.9 14.8 9.9s1.1 12.9-3.5 17.4l-96 96c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l68.7-68.7-89.4 0c-6.5 0-12.3-3.9-14.8-9.9s-1.1-12.9 3.5-17.4l20.7-20.7-64.8 0c-5.6 9.8-8.6 20.8-8.6 32l-64 0c-17.7 0-32 14.3-32 32zm96 48a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm304 0a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M108.9 107.8l-28.1 84.2 55.7 0c-5.6 9.8-8.6 20.8-8.6 32l-64 0c-17.7 0-32 14.3-32 32l0 128 448 0 0-128c0-17.7-14.3-32-32-32l-64 0c0-8.2-1.6-16.6-4.9-24.5-1.1-2.6-2.3-5.1-3.7-7.5l55.7 0-28.1-84.2C394.3 81.6 369.9 64 342.3 64L169.7 64c-27.5 0-52 17.6-60.7 43.8zM46.3 194.5L78.6 97.6C91.7 58.4 128.3 32 169.7 32l172.7 0c41.3 0 78 26.4 91.1 65.6l32.3 96.8c26.7 7.7 46.3 32.3 46.3 61.5l0 208c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-48-448 0 0 48c0 8.8-7.2 16-16 16S0 472.8 0 464L0 256c0-29.2 19.6-53.8 46.3-61.5zM104 280a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm280 24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM299.3 139.3L230.6 208 320 208c6.5 0 12.3 3.9 14.8 9.9s1.1 12.9-3.5 17.4l-96 96c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l68.7-68.7-89.4 0c-6.5 0-12.3-3.9-14.8-9.9s-1.1-12.9 3.5-17.4l96-96c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6z"]],
    "table-rows": [448, 512, ["rows"], "e292", ["M160 64l0 176 256 0 0-144c0-17.7-14.3-32-32-32L160 64zm0 208l0 176 224 0c17.7 0 32-14.3 32-32l0-144-256 0z", "M384 64c17.7 0 32 14.3 32 32l0 144-256 0 0-176 224 0zm32 208l0 144c0 17.7-14.3 32-32 32l-224 0 0-176 256 0zM160 32L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L160 32zM64 448c-17.7 0-32-14.3-32-32L32 96c0-17.7 14.3-32 32-32l64 0 0 384-64 0z"]],
    "cloud-slash": [576, 512, [], "e137", ["M156.3 101.6c20.5-23.1 50.4-37.6 83.7-37.6 39.3 0 73.8 20.2 93.8 50.8 4.4 6.7 13.1 9.1 20.3 5.7 11.4-5.5 24.3-8.5 37.9-8.5 48.6 0 88 39.4 88 88 0 14.1-3.3 27.4-9.2 39.2-2 4.1-2.2 8.9-.5 13.1s5.2 7.6 9.5 9.1c37.4 13.1 64.2 48.8 64.2 90.6 0 37.2-21.1 69.4-52 85.4L156.3 101.6z", "M27.3-27.3c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l544 544c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-55.9-55.9c36.4-22.6 60.6-62.9 60.6-108.8 0-49.9-28.5-93-70.1-114.2 3.9-11.9 6.1-24.6 6.1-37.8 0-66.3-53.7-120-120-120-13.7 0-26.9 2.3-39.2 6.5-26.4-33.2-67.1-54.5-112.8-54.5-42.1 0-80.1 18.1-106.4 47L27.3-27.3zM156.3 101.6c20.5-23.1 50.4-37.6 83.7-37.6 39.3 0 73.8 20.2 93.8 50.8 4.4 6.7 13.1 9.1 20.3 5.7 11.4-5.5 24.3-8.5 37.9-8.5 48.6 0 88 39.4 88 88 0 14.1-3.3 27.4-9.2 39.2-2 4.1-2.2 8.9-.5 13.1s5.2 7.6 9.5 9.1c37.4 13.1 64.2 48.8 64.2 90.6 0 37.2-21.1 69.4-52 85.4L156.3 101.6zM96 176c0 8 .7 15.9 1.9 23.5-56.9 19.2-97.9 73-97.9 136.5 0 79.5 64.5 144 144 144l277.5 0-32-32-245.5 0c-61.9 0-112-50.1-112-112 0-53.7 37.8-98.6 88.2-109.5 4.3-.9 8.1-3.6 10.3-7.4s2.9-8.3 1.7-12.6c-1.8-6.3-3-12.8-3.7-19.5L97.4 155.9c-.9 6.6-1.4 13.3-1.4 20.1z"]],
    "face-hand-yawn": [512, 512, [], "e379", ["M32 256C32 132.3 132.3 32 256 32S480 132.3 480 256c0 63.3-26.2 120.4-68.4 161.1-2.9-2.7-5.9-5-9.1-7.1 10.5-23.5 6.1-52-13.2-71.3-6.4-6.4-13.9-11.2-21.8-14.3-5.8-56.4-53.5-100.4-111.4-100.4-50.8 0-93.7 33.8-107.4 80.2-1.5-.1-3-.2-4.6-.2-35.3 0-64 28.7-64 64l0 26.6C49.9 356.5 32 308.3 32 256zm83.2-54.4c5.3 7.1 15.3 8.5 22.4 3.2l64-48c7.1-5.3 8.5-15.3 3.2-22.4s-15.3-8.5-22.4-3.2l-64 48c-7.1 5.3-8.5 15.3-3.2 22.4zm192-67.2c-5.3 7.1-3.9 17.1 3.2 22.4l64 48c7.1 5.3 17.1 3.9 22.4-3.2s3.9-17.1-3.2-22.4l-64-48c-7.1-5.3-17.1-3.9-22.4 3.2z", "M480 256c0 63.3-26.2 120.4-68.4 161.1 .6 .5 1.1 1.1 1.7 1.6 7.5 7.5 12.8 16.4 15.8 25.9 51-46.8 83-114 83-188.7 0-141.4-114.6-256-256-256S0 114.6 0 256c0 73.2 30.7 139.2 80 185.9l0-47.3C49.9 356.5 32 308.3 32 256 32 132.3 132.3 32 256 32S480 132.3 480 256zM339.4 320.2c9.5-.7 19 .7 28 4.3-5.8-56.4-53.5-100.4-111.4-100.4-50.8 0-93.7 33.8-107.4 80.2 11.2 .8 21.5 4.4 30.4 10.2 9.4-33.7 40.4-58.4 77-58.4 32.2 0 59.9 19 72.6 46.4 4.7 5.4 8.3 11.5 10.8 17.8zM204.8 134.4c-5.3-7.1-15.3-8.5-22.4-3.2l-64 48c-7.1 5.3-8.5 15.3-3.2 22.4s15.3 8.5 22.4 3.2l64-48c7.1-5.3 8.5-15.3 3.2-22.4zm105.6 22.4l64 48c7.1 5.3 17.1 3.9 22.4-3.2s3.9-17.1-3.2-22.4l-64-48c-7.1-5.3-17.1-3.9-22.4 3.2s-3.9 17.1 3.2 22.4zM291.3 355.3c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-72 72c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l72-72zM160 368c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 104c0 57.4 46.6 104 104 104l3.5 0c27.6 0 54-11 73.5-30.5l70.2-70.2c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-70.2 70.2C273 536.4 254.6 544 235.5 544l-3.5 0c-39.8 0-72-32.2-72-72l0-104zm195.3 27.3c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-80 80c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l80-80z"]],
    "tickets": [640, 512, [], "e658", ["M128 96l0 38.7c28.2 12.3 48 40.5 48 73.3s-19.8 61-48 73.3l0 38.7c0 17.7 14.3 32 32 32l384 0c17.7 0 32-14.3 32-32l0-38.7c-28.2-12.3-48-40.5-48-73.3s19.8-61 48-73.3L576 96c0-17.7-14.3-32-32-32L160 64c-17.7 0-32 14.3-32 32zm96 72c0-22.1 17.9-40 40-40l176 0c22.1 0 40 17.9 40 40l0 80c0 22.1-17.9 40-40 40l-176 0c-22.1 0-40-17.9-40-40l0-80zm32 0l0 80c0 4.4 3.6 8 8 8l176 0c4.4 0 8-3.6 8-8l0-80c0-4.4-3.6-8-8-8l-176 0c-4.4 0-8 3.6-8 8z", "M160 64l384 0c17.7 0 32 14.3 32 32l0 38.7c-28.2 12.3-48 40.5-48 73.3s19.8 61 48 73.3l0 38.7c0 17.7-14.3 32-32 32l-384 0c-17.7 0-32-14.3-32-32l0-38.7c28.2-12.3 48-40.5 48-73.3s-19.8-61-48-73.3L128 96c0-17.7 14.3-32 32-32zm0-32c-35.3 0-64 28.7-64 64l0 48c0 8.8 7.4 15.7 15.7 18.6 18.8 6.5 32.3 24.4 32.3 45.4s-13.5 38.9-32.3 45.4C103.4 256.3 96 263.2 96 272l0 48c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-48c0-8.8-7.4-15.7-15.7-18.6-18.8-6.5-32.3-24.4-32.3-45.4s13.5-38.9 32.3-45.4c8.3-2.9 15.7-9.8 15.7-18.6l0-48c0-35.3-28.7-64-64-64L160 32zM16 128c-8.8 0-16 7.2-16 16L0 424c0 30.9 25.1 56 56 56l440 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L56 448c-13.3 0-24-10.7-24-24l0-280c0-8.8-7.2-16-16-16zm248 32l176 0c4.4 0 8 3.6 8 8l0 80c0 4.4-3.6 8-8 8l-176 0c-4.4 0-8-3.6-8-8l0-80c0-4.4 3.6-8 8-8zm-40 8l0 80c0 22.1 17.9 40 40 40l176 0c22.1 0 40-17.9 40-40l0-80c0-22.1-17.9-40-40-40l-176 0c-22.1 0-40 17.9-40 40z"]],
    "sim-card": [384, 512, [], "f7c4", ["M32 64l0 384c0 17.7 14.3 32 32 32l256 0c17.7 0 32-14.3 32-32l0-322.7c0-8.5-3.4-16.6-9.4-22.6L281.4 41.4c-6-6-14.1-9.4-22.6-9.4L64 32C46.3 32 32 46.3 32 64zM64 256c0-17.7 14.3-32 32-32l192 0c17.7 0 32 14.3 32 32l0 160c0 17.7-14.3 32-32 32L96 448c-17.7 0-32-14.3-32-32l0-160z", "M64 32C46.3 32 32 46.3 32 64l0 384c0 17.7 14.3 32 32 32l256 0c17.7 0 32-14.3 32-32l0-322.7c0-8.5-3.4-16.6-9.4-22.6L281.4 41.4c-6-6-14.1-9.4-22.6-9.4L64 32zM304 18.7L365.3 80c12 12 18.7 28.3 18.7 45.3L384 448c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64C0 28.7 28.7 0 64 0L258.7 0c17 0 33.3 6.7 45.3 18.7zM288 416l0-64-112 0 0 64 112 0zm-144 0l0-64-48 0 0 64 48 0zM96 256l0 64 112 0 0-64-112 0zm192 64l0-64-48 0 0 64 48 0zm32-64l0 160c0 17.7-14.3 32-32 32L96 448c-17.7 0-32-14.3-32-32l0-160c0-17.7 14.3-32 32-32l192 0c17.7 0 32 14.3 32 32z"]],
    "shield-quartered": [512, 512, [], "e575", ["M61.1 240l178.9 0 0 232.6C133.3 420.1 82.4 324.6 61.1 240zM272 38.8l173.2 73.5c11.3 4.8 18.9 15.5 18.8 27.6-.1 20-1.9 43.2-6.3 68.2L272 208 272 38.8z", "M66.8 112.3c-11.3 4.8-18.9 15.5-18.8 27.6 .1 20 1.9 43.2 6.3 68.2l185.7 0 0-169.2-173.2 73.5zM61.1 240C82.4 324.6 133.3 420.1 240 472.6l0-232.6-178.9 0zM272 240l0 232.6c106.7-52.5 157.7-148 179-232.6l-179 0zm185.8-32c4.3-24.9 6.2-48.2 6.3-68.2 .1-12.1-7.5-22.8-18.8-27.6L272 38.8 272 208 457.8 208zM231.1 7.8c16-6.8 34-6.8 50 0l176.7 75c22 9.3 38.4 31 38.3 57.2-.5 99.2-41.3 280.7-213.6 363.2-16.7 8-36.1 8-52.8 0-172.4-82.5-213.1-264-213.6-363.2-.1-26.2 16.3-47.9 38.3-57.2l176.7-75z"]],
    "square-ellipsis-vertical": [448, 512, [], "e26f", ["M32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64C46.3 64 32 78.3 32 96zm216 64a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm0 96a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm0 96a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M64 64C46.3 64 32 78.3 32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM224 232a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm-24-72a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm24 168a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]],
    "oven": [448, 512, [], "e01d", ["M32 96l0 96 384 0 0-96c0-35.3-28.7-64-64-64L96 32C60.7 32 32 60.7 32 96zm0 128l0 224c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-224-384 0zm96-112a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zM96 304c0-8.8 7.2-16 16-16l224 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-224 0c-8.8 0-16-7.2-16-16zM208 112a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm80 0a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm80 0a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M352 32c35.3 0 64 28.7 64 64l0 96-384 0 0-96c0-35.3 28.7-64 64-64l256 0zm64 192l0 224c0 17.7-14.3 32-32 32L64 480c-17.7 0-32-14.3-32-32l0-224 384 0zM96 0C43 0 0 43 0 96L0 448c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-352c0-53-43-96-96-96L96 0zm32 112a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm56 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm104-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm56 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM96 304c0 8.8 7.2 16 16 16l224 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-224 0c-8.8 0-16 7.2-16 16z"]],
    "scale-balanced": [640, 512, [9878, "balance-scale"], "f24e", ["M32 320l192 0c0 14.2-7.6 29.5-24.7 42.3-17.1 12.8-42.2 21.7-71.3 21.7s-54.2-8.9-71.3-21.7C39.6 349.5 32 334.2 32 320zm384 0l192 0c0 14.2-7.6 29.5-24.7 42.3-17.1 12.8-42.2 21.7-71.3 21.7s-54.2-8.9-71.3-21.7C423.6 349.5 416 334.2 416 320z", "M384 64c0 29.8-20.4 54.9-48 62l0 354 192 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-416 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l192 0 0-354c-27.6-7.1-48-32.2-48-62L112 64c-8.8 0-16-7.2-16-16s7.2-16 16-16l152.6 0C275.6 12.9 296.3 0 320 0s44.4 12.9 55.4 32L512 32c8.8 0 16 7.2 16 16s-7.2 16-16 16L384 64zm56.7 298.3C457.8 375.1 482.9 384 512 384s54.2-8.9 71.3-21.7C600.4 349.5 608 334.2 608 320l-192 0c0 14.2 7.6 29.5 24.7 42.3zm71.3-215L426.3 288 597.7 288 512 147.3zM384 320l0-1.6c0-14.7 4-29.1 11.7-41.6l92-151.2c5.2-8.5 14.4-13.7 24.3-13.7s19.2 5.2 24.3 13.7l92 151.2c7.6 12.5 11.7 26.9 11.7 41.6l0 1.6c0 53-57.3 96-128 96s-128-43-128-96zM32 320c0 14.2 7.6 29.5 24.7 42.3 17.1 12.8 42.2 21.7 71.3 21.7s54.2-8.9 71.3-21.7C216.4 349.5 224 334.2 224 320L32 320zm10.3-32L213.7 288 128 147.3 42.3 288zM128 416C57.3 416 0 373 0 320l0-1.6c0-14.7 4-29.1 11.7-41.6l92-151.2c5.2-8.5 14.4-13.7 24.3-13.7s19.2 5.2 24.3 13.7l92 151.2c7.6 12.5 11.7 26.9 11.7 41.6l0 1.6c0 53-57.3 96-128 96zM320 96a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]],
    "car": [512, 512, [128664, "automobile"], "f1b9", ["M32 256c0-6.1 1.7-11.8 4.7-16.7 3.2-3.8 6.8-7.4 10.6-10.6 4.9-3 10.6-4.7 16.7-4.7l384 0c6.1 0 11.8 1.7 16.7 4.7 3.8 3.2 7.4 6.8 10.6 10.6 3 4.9 4.7 10.6 4.7 16.7l0 128-448 0 0-128zm48 48a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm304 0a24 24 0 1 0 48 0 24 24 0 1 0 -48 0z", "M108.9 107.8l-28.1 84.2 350.3 0-28.1-84.2C394.3 81.6 369.9 64 342.3 64L169.7 64c-27.5 0-52 17.6-60.7 43.8zM46.3 194.5L78.6 97.6C91.7 58.4 128.3 32 169.7 32l172.7 0c41.3 0 78 26.4 91.1 65.6l32.3 96.8c26.7 7.7 46.3 32.3 46.3 61.5l0 208c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-48-448 0 0 48c0 8.8-7.2 16-16 16S0 472.8 0 464L0 256c0-29.2 19.6-53.8 46.3-61.5zM64 224c-17.7 0-32 14.3-32 32l0 128 448 0 0-128c0-17.7-14.3-32-32-32L64 224zm40 56a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm280 24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"]],
    "circle-baht": [512, 512, [], "e72d", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zM161.8 155.9c0-15.4 12.5-27.9 27.9-27.9l50.3 0 0-16c0-8.8 7.2-16 16-16s16 7.2 16 16l0 16 13.3 0c39.8 0 72 32.2 72 72 0 19.1-7.4 36.4-19.5 49.3 21.8 12.4 36.5 35.8 36.5 62.7 0 39.8-32.2 72-72 72l-30.2 0 0 16c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-16-47.9 0c-16.8 0-30.4-13.6-30.4-30.4l0-197.7zm32 4.1l0 80 46.2 0 0-80-46.2 0zm0 112l0 80 46.2 0 0-80-46.2 0zM272 160l0 80 13.3 0c22.1 0 40-17.9 40-40s-17.9-40-40-40L272 160zm0 112l0 80 30.2 0c22.1 0 40-17.9 40-40s-17.9-40-40-40L272 272z", "M256 32a224 224 0 1 1 0 448 224 224 0 1 1 0-448zm0 480a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM240 112l0 16-50.3 0c-15.4 0-27.9 12.5-27.9 27.9l0 197.7c0 16.8 13.6 30.4 30.4 30.4l47.9 0 0 16c0 8.8 7.2 16 16 16s16-7.2 16-16l0-16 30.2 0c39.8 0 72-32.2 72-72 0-26.9-14.7-50.3-36.5-62.7 12.1-12.9 19.5-30.2 19.5-49.3 0-39.8-32.2-72-72-72l-13.3 0 0-16c0-8.8-7.2-16-16-16s-16 7.2-16 16zm-46.2 48l46.2 0 0 80-46.2 0 0-80zm78.2 0l13.3 0c22.1 0 40 17.9 40 40s-17.9 40-40 40l-13.3 0 0-80zM193.8 272l46.2 0 0 80-46.2 0 0-80zm78.2 0l30.2 0c22.1 0 40 17.9 40 40s-17.9 40-40 40l-30.2 0 0-80z"]],
    "badger-honey": [640, 512, [129441], "f6b4", ["M32 224c0-36.1 20-67.6 49.5-84 9.7 65.6 66.2 116 134.5 116l2 0c22.3 0 44.3-5.4 64-15.8l85.6-44.8c32.4-17 68.2-26.3 104.8-27.3-.2 1.3-.4 2.6-.4 3.9 0 11 9 20 20 20s20-9 20-20c0-1.4-.1-2.7-.4-4l95.8 0c.4 2.3 .6 4.8 .6 7.2l0 2.2c0 10.2-4.1 20.1-11.3 27.3-7.1 7.1-17.3 11.4-28.7 12.4-75.6 7-145.3 45-187.8 78.4-4.6 3.6-6.8 9.4-5.9 15.2L394 429.4c1.6 9.8-5.9 18.6-15.8 18.6l-23.1 0c-7.8 0-14.5-5.7-15.8-13.4L322.4 333.4c-1.3-7.7-8-13.4-15.8-13.4l-118.1 0c-6.4 0-12.2 3.8-14.7 9.7l-16 37.3c-4.4 10.3-5.1 21.9-1.9 32.7l8.3 27.7c3.1 10.3-4.6 20.6-15.3 20.6l-21.2 0c-7.1 0-13.3-4.6-15.3-11.4L99.4 392.9c-1.8-5.9-1.8-12.1-.1-18l11.3-39.4c2.4-8.4-2.4-17.1-10.7-19.7-39.3-12-67.8-48.6-67.8-91.8z", "M459.8 96c-21 0-41.8 4.9-60.6 14.3-23.3 11.6-48.9 17.7-74.9 17.7L128 128c-5.3 0-10.5 .4-15.6 1.3 4.7 53.1 49.3 94.7 103.6 94.7l2 0c17.1 0 34-4.2 49.2-12.1l85.6-44.8C391.7 146.7 435 136 479 136l104.9 0c-.7-.4-1.5-.7-2.2-1l-61.1-26.7C502.2 100.2 482.3 96 462.2 96l-2.4 0zM32 224c0 43.2 28.5 79.8 67.8 91.8 8.3 2.6 13.1 11.3 10.7 19.7L99.2 374.9c-1.7 5.9-1.6 12.1 .1 18l13.1 43.7c2 6.8 8.3 11.4 15.3 11.4l21.2 0c10.7 0 18.4-10.3 15.3-20.6L156 399.7c-3.2-10.8-2.6-22.4 1.9-32.7l16-37.3c2.5-5.9 8.3-9.7 14.7-9.7l118.1 0c7.8 0 14.5 5.7 15.8 13.4l16.9 101.3c1.3 7.7 8 13.4 15.8 13.4l23.1 0c9.9 0 17.4-8.9 15.8-18.6L374.2 310.7c-1-5.8 1.3-11.6 5.9-15.2 42.5-33.4 112.3-71.5 187.8-78.4 11.5-1.1 21.7-5.3 28.7-12.4 7.2-7.2 11.3-17.1 11.3-27.3l0-2.2c0-2.4-.2-4.8-.6-7.2l-95.8 0c.3 1.3 .4 2.6 .4 4 0 11-9 20-20 20s-20-9-20-20c0-1.3 .1-2.6 .4-3.9-36.5 1-72.3 10.3-104.8 27.3L282 240.2c-19.8 10.3-41.7 15.8-64 15.8l-2 0C147.7 256 91.1 205.6 81.5 140 52 156.4 32 187.9 32 224zM75.7 340.9C58.9 333.3 44 322.3 32 308.7L32 320c0 8.8-7.2 16-16 16S0 328.8 0 320l0-96C0 153.3 57.3 96 128 96l196.2 0c21 0 41.8-4.9 60.6-14.3 23.3-11.6 48.9-17.7 74.9-17.7l2.4 0c24.5 0 48.8 5.1 71.2 14.9l61.1 26.7C622.1 117.7 640 145 640 175.2l0 2.2c0 18.7-7.4 36.7-20.7 49.9-12.1 12.1-27.6 18.7-43.3 21.1l0 23.6c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-19.1c-53.3 10.6-102.6 36.9-136.6 62.1l18.2 109.1c4.9 29.3-17.7 55.9-47.3 55.9l-23.1 0c-23.5 0-43.5-17-47.3-40.1l-14.6-87.9-94 0-11.8 27.6c-1.5 3.4-1.7 7.3-.6 10.9l8.3 27.7c9.2 30.8-13.8 61.8-46 61.8l-21.2 0c-21.2 0-39.9-13.9-46-34.2L68.7 402.1c-3.5-11.7-3.6-24.2-.2-36l7.2-25.2z"]],
    "crop-simple": [512, 512, ["crop-alt"], "f565", ["M128 128l240 0c.4 0 .7 0 1.1 0 8.3 .6 14.9 7.5 14.9 16l0 240-240 0c-.4 0-.7 0-1.1 0-8.3-.6-14.9-7.5-14.9-16l0-240z", "M128 16c0-8.8-7.2-16-16-16S96 7.2 96 16l0 80-80 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l80 0 0 240c0 26.5 21.5 48 48 48l192 0 0-32-192 0c-8.8 0-16-7.2-16-16l0-352zM384 496c0 8.8 7.2 16 16 16s16-7.2 16-16l0-80 80 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-80 0 0-240c0-26.5-21.5-48-48-48l-192 0 0 32 192 0c8.8 0 16 7.2 16 16l0 352z"]],
    "timer": [512, 512, [], "e29e", ["M32 256c0-61.9 25.1-117.8 65.6-158.4l51.1 51.1c-6.2 6.2-6.2 16.4 0 22.6l96 96c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L256 233.4 256 128c8.8 0 16-7.2 16-16l0-79.4c116.2 8.2 208 105.1 208 223.4 0 123.7-100.3 224-224 224S32 379.7 32 256z", "M256 0c-8.8 0-16 7.2-16 16l0 96c0 8.8 7.2 16 16 16s16-7.2 16-16l0-79.4c116.2 8.2 208 105.1 208 223.4 0 123.7-100.3 224-224 224S32 379.7 32 256c0-61.9 25.1-117.8 65.6-158.4 6.2-6.2 6.2-16.4 0-22.6S81.2 68.7 75 75C28.7 121.3 0 185.3 0 256 0 397.4 114.6 512 256 512S512 397.4 512 256 397.4 0 256 0zM171.3 148.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l96 96c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-96-96z"]],
    "square-dollar": [448, 512, ["dollar-square", "usd-square"], "f2e9", ["M32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64C46.3 64 32 78.3 32 96zM152 214.6c0-30.1 24.4-54.6 54.6-54.6l1.4 0 0-16c0-8.8 7.2-16 16-16s16 7.2 16 16l0 16 24 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-57.4 0c-12.5 0-22.6 10.1-22.6 22.6 0 11.2 8.3 20.7 19.4 22.3l45.8 6.5c26.9 3.8 46.8 26.9 46.8 54 0 30.1-24.4 54.6-54.6 54.6l-1.4 0 0 16c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-16-32 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l65.4 0c12.5 0 22.6-10.1 22.6-22.6 0-11.2-8.3-20.7-19.4-22.3l-45.8-6.5c-26.9-3.8-46.8-26.9-46.8-54z", "M64 64C46.3 64 32 78.3 32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm224 32c8.8 0 16 7.2 16 16l0 16 24 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-57.4 0c-12.5 0-22.6 10.1-22.6 22.6 0 11.2 8.3 20.7 19.4 22.3l45.8 6.5c26.9 3.8 46.8 26.9 46.8 54 0 30.1-24.4 54.6-54.6 54.6l-1.4 0 0 16c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-16-32 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l65.4 0c12.5 0 22.6-10.1 22.6-22.6 0-11.2-8.3-20.7-19.4-22.3l-45.8-6.5c-26.9-3.8-46.8-26.9-46.8-54 0-30.1 24.4-54.6 54.6-54.6l1.4 0 0-16c0-8.8 7.2-16 16-16z"]],
    "medal": [448, 512, [127941], "f5a2", ["M64 320a160 160 0 1 0 320 0 160 160 0 1 0 -320 0zm47.4-23.8c-6.7-6.5-3-17.9 6.3-19.3l60.6-8.8c3.7-.5 6.9-2.8 8.5-6.2L213.9 207c4.1-8.4 16.1-8.4 20.3 0l27.1 54.9c1.6 3.3 4.8 5.6 8.5 6.2l60.6 8.8c9.3 1.3 13 12.7 6.3 19.3l-43.8 42.7c-2.7 2.6-3.9 6.3-3.3 10l10.3 60.3c1.6 9.2-8.1 16.3-16.4 11.9l-54.2-28.5c-3.3-1.7-7.2-1.7-10.5 0l-54.2 28.5c-8.3 4.4-18-2.7-16.4-11.9l10.3-60.3c.6-3.7-.6-7.4-3.2-10l-43.8-42.7z", "M198 129.7L125.1-4c-2.1-3.8-6.7-5.3-10.6-3.3l-85 42.5c-4.1 2-5.6 7-3.4 11l70.9 130c27.7-24.5 62.6-41.2 101.2-46.4zM153.2-19.3L224 110.6 294.9-19.3c10.3-18.9 33.7-26.3 53-16.6l85 42.5c20.3 10.1 28.1 35 17.2 54.9l-75.8 139c26.1 32.8 41.7 74.3 41.7 119.5 0 106-86 192-192 192S32 426 32 320c0-45.2 15.6-86.7 41.7-119.5L-2.1 61.5C-13 41.6-5.1 16.7 15.1 6.6l85-42.5c19.3-9.6 42.7-2.3 53 16.6zM422.1 46.2c2.2-4 .6-9-3.4-11l-85-42.5c-3.9-1.9-8.5-.5-10.6 3.3L250 129.7c38.5 5.2 73.4 21.9 101.2 46.4l70.9-130zM384 320a160 160 0 1 0 -320 0 160 160 0 1 0 320 0zM178.3 268.1c3.7-.5 6.9-2.8 8.5-6.2L213.9 207c4.1-8.4 16.1-8.4 20.3 0l27.1 54.9c1.6 3.3 4.8 5.6 8.5 6.2l60.6 8.8c9.3 1.3 13 12.7 6.3 19.3l-43.8 42.7c-2.7 2.6-3.9 6.3-3.3 10l10.3 60.3c1.6 9.2-8.1 16.3-16.4 11.9l-54.2-28.5c-3.3-1.7-7.2-1.7-10.5 0l-54.2 28.5c-8.3 4.4-18-2.7-16.4-11.9l10.3-60.3c.6-3.7-.6-7.4-3.2-10l-43.8-42.7c-6.7-6.5-3-17.9 6.3-19.3l60.6-8.8zm-14.5 34.4a63.3 63.3 0 1 0 120.4 39.1 63.3 63.3 0 1 0 -120.4-39.1z"]],
    "scroll": [576, 512, [128220], "f70e", ["M112 408c0 38.4 30.1 69.8 67.9 71.9-1.3 .1-2.6 .1-3.9 .1-35.3 0-64-28.7-64-64l0-8zM131.9 64L360 64c30.9 0 56 25.1 56 56l0 200-144 0c-26.5 0-48 21.5-48 48l0 40c0 22.1-17.9 40-40 40s-40-17.9-40-40l0-304c0-14.8-4.5-28.6-12.1-40z", "M32 104c0-22.1 17.9-40 40-40s40 17.9 40 40l0 56-72 0c-4.4 0-8-3.6-8-8l0-48zm99.9-40L360 64c30.9 0 56 25.1 56 56l0 200-144 0c-26.5 0-48 21.5-48 48l0 40c0 22.1-17.9 40-40 40s-40-17.9-40-40l0-304c0-14.8-4.5-28.6-12.1-40zM448 320l0-200c0-48.6-39.4-88-88-88L72 32C32.2 32 0 64.2 0 104l0 48c0 22.1 17.9 40 40 40l72 0 0 216c0 39.8 32.2 72 72 72l272 0c48.6 0 88-39.4 88-88l0-24c0-26.5-21.5-48-48-48l-48 0zm8 128l-212.1 0c7.7-11.4 12.1-25.2 12.1-40l0-40c0-8.8 7.2-16 16-16l224 0c8.8 0 16 7.2 16 16l0 24c0 30.9-25.1 56-56 56z"]],
    "calendars": [512, 512, [], "e0d7", ["M128 192l352 0 0 160c0 17.7-14.3 32-32 32l-288 0c-17.7 0-32-14.3-32-32l0-160z", "M192 16c0-8.8 7.2-16 16-16s16 7.2 16 16l0 48 160 0 0-48c0-8.8 7.2-16 16-16s16 7.2 16 16l0 48 32 0c35.3 0 64 28.7 64 64l0 224c0 35.3-28.7 64-64 64l-288 0c-35.3 0-64-28.7-64-64l0-224c0-35.3 28.7-64 64-64l32 0 0-48zM400 96L160 96c-17.7 0-32 14.3-32 32l0 32 352 0 0-32c0-17.7-14.3-32-32-32l-48 0zM128 352c0 17.7 14.3 32 32 32l288 0c17.7 0 32-14.3 32-32l0-160-352 0 0 160zM32 176l0 272c0 17.7 14.3 32 32 32l336 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L64 512c-35.3 0-64-28.7-64-64L0 176c0-8.8 7.2-16 16-16s16 7.2 16 16z"]],
    "apple-core": [384, 512, [], "e08f", ["M65.6 452.7c20.8 18.5 42.9 27.3 62.6 27.3 13.2 0 32-2.7 45.3-5 12.3-2.2 25-2.2 37.3 0 13.3 2.3 32.1 5 45.3 5 19.7 0 41.8-8.8 62.6-27.3-38.6-37.7-62.6-90.4-62.6-148.7 0-55.6 21.8-106.1 57.3-143.4-3-.4-6.1-.6-9.3-.6-21 0-48.7 8.4-71.1 17.1-26.2 10.2-55.6 10.2-81.9 0-22.4-8.7-50.1-17.1-71.1-17.1-3.2 0-6.3 .2-9.3 .6 35.5 37.3 57.3 87.8 57.3 143.4 0 58.3-24 111-62.6 148.7zM192.1 91.4l0 4.6 4.6 0c32.8 0 59.4-26.6 59.4-59.4l0-4.6-4.6 0c-32.8 0-59.4 26.6-59.4 59.4z", "M196.7 96c32.8 0 59.4-26.6 59.4-59.4l0-4.6-4.6 0c-32.8 0-59.4 26.6-59.4 59.4l0 4.6 4.6 0zm-18.3 32c-10.1 0-18.3-8.2-18.3-18.3l0-18.3C160.1 40.9 201.1 0 251.6 0l18.3 0c10.1 0 18.3 8.2 18.3 18.3l0 18.3c0 50.5-40.9 91.4-91.4 91.4l-18.3 0zM128.1 480c13.2 0 32-2.7 45.3-5 12.3-2.2 25-2.2 37.3 0 13.3 2.3 32.1 5 45.3 5 19.7 0 41.8-8.8 62.6-27.3-38.6-37.7-62.6-90.4-62.6-148.7 0-55.6 21.8-106.1 57.3-143.4-3-.4-6.1-.6-9.3-.6-21 0-48.7 8.4-71.1 17.1-26.2 10.2-55.6 10.2-81.9 0-22.4-8.7-50.1-17.1-71.1-17.1-3.2 0-6.3 .2-9.3 .6 35.5 37.3 57.3 87.8 57.3 143.4 0 58.3-24 111-62.6 148.7 20.8 18.5 42.9 27.3 62.6 27.3zM30 462.4c-6.2-6.8-4.4-17.3 2.7-23.1 38.8-32.3 63.4-80.9 63.4-135.3 0-55.4-25.6-104.7-65.5-137-8-6.5-9.3-18.7-.7-24.3 14.2-9.3 30.9-14.7 50.3-14.7 27.3 0 59.7 10.3 82.7 19.3 18.8 7.3 39.9 7.3 58.7 0 22.9-8.9 55.4-19.3 82.7-19.3 19.3 0 36.1 5.4 50.3 14.7 8.6 5.6 7.3 17.9-.7 24.3-40 32.3-65.5 81.7-65.5 137 0 54.4 24.7 103 63.4 135.3 7 5.9 8.8 16.3 2.7 23.1-28.3 31.3-63.2 49.6-98.1 49.6-16.2 0-37.4-3.2-50.9-5.5-8.7-1.5-17.6-1.5-26.3 0-13.5 2.4-34.6 5.5-50.8 5.5-34.9 0-69.8-18.3-98.1-49.6z"]],
    "file-excel": [384, 512, [], "f1c3", ["M32 64l0 384c0 17.7 14.3 32 32 32l256 0c17.7 0 32-14.3 32-32l0-256-96 0c-35.3 0-64-28.7-64-64l0-96-128 0C46.3 32 32 46.3 32 64zm91.4 217.8c-5.4-7-4.2-17 2.8-22.5s17-4.2 22.5 2.8l43.4 55.8 43.4-55.8c5.4-7 15.5-8.2 22.5-2.8s8.2 15.5 2.8 22.5l-48.4 62.2 48.4 62.2c5.4 7 4.2 17-2.8 22.5s-17 4.2-22.5-2.8l-43.4-55.8-43.4 55.8c-5.4 7-15.5 8.2-22.5 2.8s-8.2-15.5-2.8-22.5l48.4-62.2-48.4-62.2z", "M64 32l128 0 0 96c0 35.3 28.7 64 64 64l96 0 0 256c0 17.7-14.3 32-32 32L64 480c-17.7 0-32-14.3-32-32L32 64c0-17.7 14.3-32 32-32zM224 45.3L338.7 160 256 160c-17.7 0-32-14.3-32-32l0-82.7zM64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-261.5c0-17-6.7-33.3-18.7-45.3L242.7 18.7C230.7 6.7 214.5 0 197.5 0L64 0zm84.6 262.2c-5.4-7-15.5-8.2-22.5-2.8s-8.2 15.5-2.8 22.5l48.4 62.2-48.4 62.2c-5.4 7-4.2 17 2.8 22.5s17 4.2 22.5-2.8l43.4-55.8 43.4 55.8c5.4 7 15.5 8.2 22.5 2.8s8.2-15.5 2.8-22.5l-48.4-62.2 48.4-62.2c5.4-7 4.2-17-2.8-22.5s-17-4.2-22.5 2.8l-43.4 55.8-43.4-55.8z"]],
    "diamond-half": [512, 512, [], "e5b7", ["M32 256c0 6.9 2.7 13.5 7.6 18.3L224 458.7 224 53.3 39.6 237.7C34.7 242.5 32 249.1 32 256z", "M248.9 5.9c4.4 3 7.1 8 7.1 13.3l0 473.7c0 5.3-2.7 10.3-7.1 13.3s-10.1 3.5-15 1.5c-7-2.9-13.4-7.1-18.9-12.6L17 297C6.1 286.1 0 271.4 0 256s6.1-30.1 17-41L215 17c5.5-5.5 11.9-9.7 18.9-12.6 4.9-2 10.6-1.5 15 1.5zM224 53.3L39.6 237.7C34.7 242.5 32 249.1 32 256s2.7 13.5 7.6 18.3l0 0 184.4 184.4 0-405.5z"]],
    "baguette": [640, 512, [129366], "e3d8", ["M48.1 437.3c29.4 44.1 89 56 133.1 26.6l384-256c44.1-29.4 56-89 26.6-133.1s-89-56-133.1-26.6l-79.2 52.8 47.8 47.8c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-52.3-52.3-88 58.7 51 51c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-55.5-55.5-88 58.7 54.2 54.2c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L122 272.6 74.7 304.1c-44.1 29.4-56 89-26.6 133.1z", "M591.9 74.8c-29.4-44.1-89-56-133.1-26.6l-79.2 52.8 47.8 47.8c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-52.3-52.3-88 58.7 51 51c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-55.5-55.5-88 58.7 54.2 54.2c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L122 272.6 74.7 304.1c-44.1 29.4-56 89-26.6 133.1s89 56 133.1 26.6l384-256c44.1-29.4 56-89 26.6-133.1zM618.5 57c39.2 58.8 23.3 138.3-35.5 177.5l-384 256C140.2 529.7 60.7 513.8 21.5 455S-1.8 316.7 57 277.5l384-256C499.8-17.7 579.3-1.8 618.5 57z"]],
    "ear-triangle-exclamation": [576, 512, [], "e75c", ["M96 192c0-88.4 71.6-160 160-160s160 71.6 160 160l0 1.4c-5.2-.9-10.6-1.4-16-1.4-11.1 0-21.9 2-32 5.9l0-5.9c0-61.9-50.1-112-112-112S144 130.1 144 192l0 32c0 8.8 7.2 16 16 16l16 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-16 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l16 0c35.3 0 64-28.7 64-64s-28.7-64-64-64l0-16c0-44.2 35.8-80 80-80s80 35.8 80 80l0 8c0 5.2 2.5 9.9 6.4 12.8-7.8 6.5-14.6 14.3-19.9 23.3L188 462.7c-3.1 5.3-5.7 10.9-7.6 16.6-47.5-5.7-84.4-46.2-84.4-95.3l0-192z", "M416 192l0 1.4c11.3 2 21.9 6.2 31.5 12.1 .3-4.5 .5-9 .5-13.5 0-106-86-192-192-192S64 86 64 192l0 192c0 65.3 48.9 119.2 112.1 127-.1-1.6-.1-3.2-.1-4.7 0-9.2 1.5-18.3 4.4-27-47.5-5.7-84.4-46.2-84.4-95.3l0-192c0-88.4 71.6-160 160-160s160 71.6 160 160zm-80 8c0 5.2 2.5 9.9 6.4 12.8 7.7-6.4 16.3-11.4 25.6-14.9l0-5.9c0-61.9-50.1-112-112-112S144 130.1 144 192l0 32c0 8.8 7.2 16 16 16l16 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-16 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l16 0c35.3 0 64-28.7 64-64s-28.7-64-64-64l0-16c0-44.2 35.8-80 80-80s80 35.8 80 80l0 8zM224 493.9c0 27.6 22.3 49.9 49.9 49.9l252.2 0c27.6 0 49.9-22.3 49.9-49.9 0-9-2.5-17.9-7.1-25.7L448.5 267.5c-10.2-17-28.6-27.4-48.5-27.4s-38.2 10.4-48.5 27.4L231.1 468.2c-4.7 7.8-7.1 16.6-7.1 25.7zm34.6-9.2L379 284c4.4-7.4 12.4-11.9 21-11.9s16.6 4.5 21 11.9L541.4 484.7c1.7 2.8 2.6 6 2.6 9.2 0 9.9-8 17.9-17.9 17.9l-252.2 0c-9.9 0-17.9-8-17.9-17.9 0-3.2 .9-6.4 2.6-9.2zM400 488.1a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm0-176.9c-8.8 0-16 7.2-16 16l0 72.9c0 8.8 7.2 16 16 16s16-7.2 16-16l0-72.9c0-8.8-7.2-16-16-16z"]],
    "h5": [576, 512, [], "e412", ["", "M64 80c0-8.8-7.2-16-16-16S32 71.2 32 80l0 352c0 8.8 7.2 16 16 16s16-7.2 16-16l0-160 160 0 0 160c0 8.8 7.2 16 16 16s16-7.2 16-16l0-352c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 160-160 0 0-160zM336 64c-8.8 0-16 7.2-16 16l0 160c0 8.8 7.2 16 16 16l104 0c44.2 0 80 35.8 80 80s-35.8 80-80 80l-104 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l104 0c61.9 0 112-50.1 112-112S501.9 224 440 224l-88 0 0-128 168 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L336 64z"]],
    "person-ski-lift": [512, 512, ["ski-lift"], "f7c8", ["M80 88a24 24 0 1 0 48 0 24 24 0 1 0 -48 0z", "M256 0c8.8 0 16 7.2 16 16l0 194.8c-1.9 .3-3.7 .6-5.6 1.1L240 218.5 240 16c0-8.8 7.2-16 16-16zM104.8 177.7c7.9-4 17.5-.7 21.5 7.2l42.3 84.5 105.6-26.4c15.1-3.8 29.8 7.7 29.8 23.3l0 136.5 150.7-59.7c15.3-6 25.3-20.8 25.3-37.2l0-1.9c0-8.8 7.2-16 16-16s16 7.2 16 16l0 1.9c0 29.5-18 56.1-45.5 66.9l-348.6 138c-8.2 3.3-17.5-.8-20.8-9s.8-17.5 9-20.8l165.9-65.7 0-139-95.7 23.9c-14.6 3.6-29.7-3.3-36.4-16.7L97.7 199.2c-4-7.9-.7-17.5 7.2-21.5zM9.1 161.6c8-3.8 17.5-.5 21.3 7.5L103.3 321c10 20.9 33.5 31.6 55.9 25.5l36.5-10c8.5-2.3 17.3 2.7 19.6 11.2s-2.7 17.3-11.2 19.6l-36.5 10c-37.3 10.2-76.5-7.7-93.2-42.6L1.6 182.9c-3.8-8-.5-17.5 7.5-21.3zM128 88a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM48 88A56 56 0 1 1 160 88 56 56 0 1 1 48 88z"]],
    "square-cedi": [448, 512, [], "e729", ["M32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64C46.3 64 32 78.3 32 96zM97.3 256c0-64.8 48.2-118.4 110.7-126.8l0-17.2c0-8.8 7.2-16 16-16s16 7.2 16 16l0 16.8c28.2 3.2 53.6 15.6 73.1 34.1 6.4 6.1 6.7 16.2 .6 22.6s-16.2 6.7-22.6 .7c-13.8-13.1-31.5-22-51.1-25.1l0 189.8c19.6-3 37.3-12 51.1-25.1 6.4-6.1 16.6-5.8 22.6 .6s5.8 16.6-.6 22.6c-19.6 18.5-45 30.8-73.1 34.1l0 16.8c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-17.2c-62.5-8.4-110.7-62-110.7-126.8zm32 0c0 47.1 34 86.3 78.7 94.5l0-188.9c-44.8 8.1-78.7 47.3-78.7 94.5z", "M64 64C46.3 64 32 78.3 32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm240 16l0 16.8c28.2 3.2 53.6 15.6 73.1 34.1 6.4 6.1 6.7 16.2 .6 22.6s-16.2 6.7-22.6 .7c-13.8-13.1-31.5-22-51.1-25.1l0 189.8c19.6-3 37.3-12 51.1-25.1 6.4-6.1 16.6-5.8 22.6 .6s5.8 16.6-.6 22.6c-19.6 18.5-45 30.8-73.1 34.1l0 16.8c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-17.2c-62.5-8.4-110.7-62-110.7-126.8S145.5 137.6 208 129.2l0-17.2c0-8.8 7.2-16 16-16s16 7.2 16 16zM129.3 256c0 47.1 34 86.3 78.7 94.5l0-188.9c-44.8 8.1-78.7 47.3-78.7 94.5z"]],
    "filter": [512, 512, [], "f0b0", ["M32 96L219.3 283.3c3 3 4.7 7.1 4.7 11.3l0 121.4 64 64 0-185.4c0-4.2 1.7-8.3 4.7-11.3L480 96 32 96z", "M2.4 83.8C7.4 71.8 19.1 64 32 64l448 0c12.9 0 24.6 7.8 29.6 19.8s2.2 25.7-6.9 34.9L320 301.3 320 480c0 12.9-7.8 24.6-19.8 29.6s-25.7 2.2-34.9-6.9l-64-64c-6-6-9.4-14.1-9.4-22.6L192 301.3 9.4 118.6C.2 109.5-2.5 95.7 2.4 83.8zM480 96L32 96 219.3 283.3c3 3 4.7 7.1 4.7 11.3l0 121.4 64 64 0-185.4c0-4.2 1.7-8.3 4.7-11.3L480 96z"]],
    "calculator-simple": [512, 512, ["calculator-alt"], "f64c", ["", "M256 0c8.8 0 16 7.2 16 16l0 224 224 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-224 0 0 224c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-224-224 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l224 0 0-224c0-8.8 7.2-16 16-16zm88 96l40 0 0-48c0-8.8 7.2-16 16-16s16 7.2 16 16l0 48 48 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-48 0 0 48c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-48-48 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l8 0zM53.1 341.1c6.2-6.2 16.4-6.2 22.6 0l36.3 36.3 36.3-36.3c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6l-36.3 36.3 36.3 36.3c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L112 422.6 75.7 458.9c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6L89.4 400 53.1 363.7c-6.2-6.2-6.2-16.4 0-22.6zM48 96l128 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L48 128c-8.8 0-16-7.2-16-16s7.2-16 16-16zM336 352l128 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-128 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zm0 64l128 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-128 0c-8.8 0-16-7.2-16-16s7.2-16 16-16z"]],
    "coin-blank": [512, 512, [], "e3fb", ["M32 208C32 146.1 132.3 96 256 96S480 146.1 480 208 379.7 320 256 320 32 269.9 32 208zm0 69.8c16.2 16.5 38.1 30.9 64 42.6l0 64.7c-2.3-1.1-4.5-2.1-6.7-3.2-42.9-21.5-57.3-45.2-57.3-61.9l0-42.2zm96 55c33.3 10.8 71.4 17.6 112 19l0 64c-41.7-1.4-79.9-8.1-112-18.3l0-64.7zm144 19c40.6-1.4 78.7-8.2 112-19l0 64.7c-32.1 10.3-70.3 16.9-112 18.3l0-64zm144-31.3c25.9-11.7 47.8-26.2 64-42.6l0 42.2c0 16.7-14.4 40.4-57.3 61.9-2.2 1.1-4.4 2.2-6.7 3.2l0-64.7z", "M128 332.7c33.3 10.8 71.4 17.6 112 19l0 64c-41.7-1.4-79.9-8.1-112-18.3l0-64.7zm-96-55c16.2 16.5 38.1 30.9 64 42.6l0 64.7c-2.3-1.1-4.5-2.1-6.7-3.2-42.9-21.5-57.3-45.2-57.3-61.9l0-42.2zM256 64C114.6 64 0 128.5 0 208L0 320c0 70.7 114.6 128 256 128s256-57.3 256-128l0-112c0-79.5-114.6-144-256-144zM416 320.4c25.9-11.7 47.8-26.2 64-42.6l0 42.2c0 16.7-14.4 40.4-57.3 61.9-2.2 1.1-4.4 2.2-6.7 3.2l0-64.7zM272 351.7c40.6-1.4 78.7-8.2 112-19l0 64.7c-32.1 10.3-70.3 16.9-112 18.3l0-64zM32 208C32 146.1 132.3 96 256 96S480 146.1 480 208 379.7 320 256 320 32 269.9 32 208z"]],
    "intersection": [384, 512, [8898], "f668", ["", "M16 480c8.8 0 16-7.2 16-16l0-240c0-88.4 71.6-160 160-160s160 71.6 160 160l0 240c0 8.8 7.2 16 16 16s16-7.2 16-16l0-240c0-106-86-192-192-192S0 118 0 224L0 464c0 8.8 7.2 16 16 16z"]],
    "drum": [512, 512, [129345], "f569", ["M32 263.2L32 368c0 8.8 5.3 19.5 20 31 10.8 8.5 25.6 16.5 44 23.5l0-126.4c-25.9-8.9-47.8-20.1-64-32.9zm96 42.3l0 127.2c32.3 8.5 70.5 14 112 15.1l0-128c-40.6-1.1-78.7-6.1-112-14.3zm144 14.3l0 128c41.5-1.1 79.7-6.6 112-15.1l0-127.2c-33.3 8.2-71.4 13.3-112 14.3zm144-23.7l0 126.4c18.3-7 33.2-15 44-23.5 14.8-11.6 20-22.2 20-31l0-104.8c-16.2 12.8-38.1 24-64 32.9z", "M509.6 39.5c4.7 7.5 2.4 17.4-5.1 22l-86.3 53.9C475.5 133 512 162.8 512 208l0 160c0 22.6-13.6 41.6-32.3 56.2-18.8 14.7-44.9 26.8-75.1 35.9-41.8 12.6-93.3 19.9-148.6 19.9s-106.8-7.3-148.6-19.9C77.1 451 51.1 438.9 32.3 424.2 13.6 409.6 0 390.6 0 368L0 208c0-80 114.6-112 256-112 42.7 0 82.9 2.9 118.3 9.2L487.5 34.4c7.5-4.7 17.4-2.4 22 5.1zM332 131.6c-23.5-2.4-49-3.6-76-3.6-69 0-128.5 7.9-169.4 23.8-41.3 16-54.6 35.8-54.6 56.2 0 11.2 11.3 31.5 55.7 50.6 41.3 17.8 100.8 29.4 168.3 29.4s127-11.5 168.3-29.4c44.3-19.1 55.7-39.4 55.7-50.6 0-20.4-13.3-40.1-54.6-56.2-13.1-5.1-28.2-9.4-44.8-12.8L248.5 221.6c-7.5 4.7-17.4 2.4-22-5.1s-2.4-17.4 5.1-22L332 131.6zM480 263.2c-16.2 12.8-38.1 24-64 32.9l0 126.4c18.3-7 33.2-15 44-23.5 14.8-11.6 20-22.2 20-31l0-104.8zm-96 42.3c-33.3 8.2-71.4 13.3-112 14.3l0 128c41.5-1.1 79.7-6.6 112-15.1l0-127.2zM240 319.8c-40.6-1.1-78.7-6.1-112-14.3l0 127.2c32.3 8.5 70.5 14 112 15.1l0-128zM96 296.1c-25.9-8.9-47.8-20.1-64-32.9L32 368c0 8.8 5.3 19.5 20 31 10.8 8.5 25.6 16.5 44 23.5l0-126.4z"]],
    "map-pin": [320, 512, [128205], "f276", ["M48 144a112 112 0 1 0 224 0 112 112 0 1 0 -224 0zm32 0c0-44.2 35.8-80 80-80 8.8 0 16 7.2 16 16s-7.2 16-16 16c-26.5 0-48 21.5-48 48 0 8.8-7.2 16-16 16s-16-7.2-16-16z", "M160 256a112 112 0 1 0 0-224 112 112 0 1 0 0 224zM304 144c0 74.1-56 135.2-128 143.1L176 496c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-208.9C72 279.2 16 218.1 16 144 16 64.5 80.5 0 160 0S304 64.5 304 144zm-192 0c0 8.8-7.2 16-16 16s-16-7.2-16-16c0-44.2 35.8-80 80-80 8.8 0 16 7.2 16 16s-7.2 16-16 16c-26.5 0-48 21.5-48 48z"]],
    "circle-house": [512, 512, [], "e6c8", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm67.4-22.2c-5.4-7-4.2-17 2.8-22.5l144-112c5.8-4.5 13.9-4.5 19.6 0l144 112c7 5.4 8.2 15.5 2.8 22.5s-15.5 8.2-22.5 2.8l-6.2-4.8 0 96.2c0 30.9-25.1 56-56 56l-144 0c-30.9 0-56-25.1-56-56l0-96.2-6.2 4.8c-7 5.4-17 4.2-22.5-2.8zM240 292.3l0 59.7 32 0 0-59.7c-4.7-2.7-10.2-4.3-16-4.3s-11.3 1.6-16 4.3z", "M256 32a224 224 0 1 1 0 448 224 224 0 1 1 0-448zm0 480a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM240 352l0-64 32 0 0 64-32 0zm-32 0l-24 0c-13.3 0-24-10.7-24-24l0-121.1 96-74.7 96 74.7 0 121.1c0 13.3-10.7 24-24 24l-24 0 0-64c0-17.7-14.3-32-32-32l-32 0c-17.7 0-32 14.3-32 32l0 64zM128 231.8l0 96.2c0 30.9 25.1 56 56 56l144 0c30.9 0 56-25.1 56-56l0-96.2 6.2 4.8c7 5.4 17 4.2 22.5-2.8s4.2-17-2.8-22.5l-144-112c-5.8-4.5-13.9-4.5-19.6 0l-144 112c-7 5.4-8.2 15.5-2.8 22.5s15.5 8.2 22.5 2.8l6.2-4.8z"]],
    "table-pivot": [576, 512, [], "e291", ["M96 96c0-17.7 14.3-32 32-32l64 0 0 96-96 0 0-64zm0 96l96 0 0 256-64 0c-17.7 0-32-14.3-32-32l0-224zM224 64l224 0c17.7 0 32 14.3 32 32l0 64-256 0 0-96z", "M224 64l0 96 256 0 0-64c0-17.7-14.3-32-32-32L224 64zM208 32l240 0c35.3 0 64 28.7 64 64l0 114c-10.5-2.7-21.5-2.7-32 0l0-18-256 0 0 256 18 0c-2.7 10.5-2.7 21.5 0 32l-114 0c-35.3 0-64-28.7-64-64L64 96c0-35.3 28.7-64 64-64l80 0zM96 160l96 0 0-96-64 0c-17.7 0-32 14.3-32 32l0 64zm0 32l0 224c0 17.7 14.3 32 32 32l64 0 0-256-96 0zM436.7 308.7l48-48c6.2-6.2 16.4-6.2 22.6 0l48 48c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L512 310.6 512 416c0 35.3-28.7 64-64 64l-105.4 0 20.7 20.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-48-48c-6.2-6.2-6.2-16.4 0-22.6l48-48c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6L342.6 448 448 448c17.7 0 32-14.3 32-32l0-105.4-20.7 20.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6z"]],
    "bridge-suspension": [512, 512, [], "e4cd", ["M32 288l448 0 0 51.9c-38 13.4-64 49.5-64 90.5l0 49.5-64 0 0-32c0-53-43-96-96-96s-96 43-96 96l0 32-64 0 0-49.5c0-41-26-77.1-64-90.5L32 288z", "M80 256l0-155.7c-14.8 20.8-33.9 38.5-55.5 52.1-7.5 4.7-17.4 2.5-22.1-5s-2.5-17.4 5-22.1c39.5-24.9 67.7-65.2 72.6-110.8 .1-1.4 .4-2.7 .9-4 .8-2.3 2.1-4.3 3.8-5.9s3.7-3 5.9-3.8C92.3 .3 94.1 0 96 0s3.7 .3 5.4 .9c2.3 .8 4.3 2.1 5.9 3.8s3 3.7 3.8 5.9c.5 1.3 .7 2.6 .9 4 7.3 67.4 68.3 121.4 144.1 121.4S392.8 82 400.1 14.6c.1-1.4 .4-2.7 .9-4 .8-2.3 2.1-4.3 3.8-5.9s3.7-3 5.9-3.8c1.7-.6 3.5-.9 5.4-.9s3.7 .3 5.4 .9c2.3 .8 4.3 2.1 5.9 3.8 1.6 1.6 2.9 3.7 3.8 5.9 .5 1.3 .8 2.6 .9 4 4.9 45.5 33.1 85.8 72.6 110.8 7.5 4.7 9.7 14.6 5 22.1s-14.6 9.7-22.1 5c-21.6-13.6-40.6-31.3-55.5-52.1l0 155.7 64 0c8.8 0 16 7.2 16 16l0 80c0 7.3-5 13.7-12.1 15.5l-3.4 .9C468 375.5 448 401.1 448 430.5l0 49.5c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-32c0-35.3-28.7-64-64-64s-64 28.7-64 64l0 32c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-49.5c0-29.4-20-55-48.5-62.1l-3.4-.9C5 365.7 0 359.3 0 352l0-80c0-8.8 7.2-16 16-16l64 0zM400 97.9c-16.5 21.9-38.5 39.8-64 52l0 106.1 64 0 0-158.1zm-96 63.8c-15.3 4.1-31.4 6.2-48 6.2s-32.7-2.2-48-6.2l0 94.2 96 0 0-94.2zM176 149.9c-25.5-12.2-47.4-30.1-64-52l0 158.1 64 0 0-106.1zM32 288l0 51.9c38 13.4 64 49.5 64 90.5l0 49.5 64 0 0-32c0-53 43-96 96-96s96 43 96 96l0 32 64 0 0-49.5c0-41 26-77.1 64-90.5l0-51.9-448 0z"]],
    "scale-unbalanced-flip": [640, 512, ["balance-scale-right"], "f516", ["M32 288c0 14.2 7.6 29.5 24.7 42.3 17.1 12.8 42.2 21.7 71.3 21.7s54.2-8.9 71.3-21.7C216.4 317.5 224 302.2 224 288L32 288zM416 416c0 14.2 7.6 29.5 24.7 42.3 17.1 12.8 42.2 21.7 71.3 21.7s54.2-8.9 71.3-21.7C600.4 445.5 608 430.2 608 416l-192 0z", "M112.2 10.9c-2.8 8.4 1.7 17.4 10.1 20.2L256.5 75.9c4.6 24.4 23.1 43.9 46.9 50.1l0 354-192 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l208 0c8.8 0 16-7.2 16-16l0-370c10.3-2.6 19.6-7.8 27.2-14.7l143.8 47.9c8.4 2.8 17.4-1.7 20.2-10.1s-1.7-17.4-10.1-20.2L380.3 83.5c2-6.1 3-12.7 3-19.5 0-35.3-28.7-64-64-64-28 0-51.8 18-60.5 43L132.4 .8C124-2 115 2.6 112.2 10.9zm87.1 319.3C182.2 343.1 157.1 352 128 352s-54.2-8.9-71.3-21.7C39.6 317.5 32 302.2 32 288l192 0c0 14.2-7.6 29.5-24.7 42.3zM128 115.3L213.7 256 42.3 256 128 115.3zM256 288l0-1.6c0-14.7-4-29.1-11.7-41.6l-92-151.2C147.2 85.2 137.9 80 128 80s-19.2 5.2-24.3 13.7l-92 151.2C4 257.4 0 271.8 0 286.4L0 288c0 53 57.3 96 128 96s128-43 128-96zM608 416c0 14.2-7.6 29.5-24.7 42.3-17.1 12.8-42.2 21.7-71.3 21.7s-54.2-8.9-71.3-21.7C423.6 445.5 416 430.2 416 416l192 0zm-10.3-32L426.3 384 512 243.3 597.7 384zM512 512c70.7 0 128-43 128-96l0-1.6c0-14.7-4-29.1-11.7-41.6l-92-151.2c-5.2-8.5-14.4-13.7-24.3-13.7s-19.2 5.2-24.3 13.7l-92 151.2C388 385.4 384 399.8 384 414.4l0 1.6c0 53 57.3 96 128 96zM319.3 32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]],
    "light-switch": [384, 512, [], "e017", ["M32 64l0 384c0 17.7 14.3 32 32 32l256 0c17.7 0 32-14.3 32-32l0-384c0-17.7-14.3-32-32-32L64 32C46.3 32 32 46.3 32 64zm64 80c0-26.5 21.5-48 48-48l96 0c26.5 0 48 21.5 48 48l0 224c0 26.5-21.5 48-48 48l-96 0c-26.5 0-48-21.5-48-48l0-224z", "M64 32l256 0c17.7 0 32 14.3 32 32l0 384c0 17.7-14.3 32-32 32L64 480c-17.7 0-32-14.3-32-32L32 64c0-17.7 14.3-32 32-32zM320 0L64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-384c0-35.3-28.7-64-64-64zM128 368l0-96 128 0 0 96c0 8.8-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16zm0-128l0-96c0-8.8 7.2-16 16-16l96 0c8.8 0 16 7.2 16 16l0 96-128 0zM96 144l0 224c0 26.5 21.5 48 48 48l96 0c26.5 0 48-21.5 48-48l0-224c0-26.5-21.5-48-48-48l-96 0c-26.5 0-48 21.5-48 48z"]],
    "arrows-to-circle": [512, 512, [], "e4bd", ["M232 256a24 24 0 1 0 48 0 24 24 0 1 0 -48 0z", "M484.7 507.3c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L374.6 352 432 352c8.8 0 16-7.2 16-16s-7.2-16-16-16l-96 0c-8.8 0-16 7.2-16 16l0 96c0 8.8 7.2 16 16 16s16-7.2 16-16l0-57.4 132.7 132.7zM176 64c-8.8 0-16 7.2-16 16L160 137.4 27.3 4.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6L137.4 160 80 160c-8.8 0-16 7.2-16 16s7.2 16 16 16l96 0c8.8 0 16-7.2 16-16l0-96c0-8.8-7.2-16-16-16zM507.3 4.7c-6.2-6.2-16.4-6.2-22.6 0L352 137.4 352 80c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 96c0 8.8 7.2 16 16 16l96 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-57.4 0 132.7-132.7c6.2-6.2 6.2-16.4 0-22.6zM80 352l57.4 0-132.7 132.7c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0L160 374.6 160 432c0 8.8 7.2 16 16 16s16-7.2 16-16l0-96c0-8.8-7.2-16-16-16l-96 0c-8.8 0-16 7.2-16 16s7.2 16 16 16zM256 232a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm0 80a56 56 0 1 0 0-112 56 56 0 1 0 0 112z"]],
    "ampersand": [384, 512, [], "26", ["", "M80 112.5c0 21.1 8.2 41.5 22.9 56.5l38.3 39.3 50.3-21.8c29.4-12.8 48.5-42 48.5-74.2 0-44.3-35.9-80.4-80-80.4-44.1 0-80 36.2-80 80.5zM204.2 215.9l-39.1 16.9 121.4 124.6 54.8-49.3c6.6-5.9 16.7-5.4 22.6 1.2s5.4 16.7-1.2 22.6l-53.9 48.5 70.6 72.5c6.2 6.3 6 16.5-.3 22.6s-16.5 6-22.6-.3l-71.5-73.4-34.8 31.3C216.7 463.3 173.2 480 128 480 58 480 0 423.3 0 352.9 0 302.3 30.1 256.5 76.5 236.3l33.2-14.4-29.8-30.6C59.4 170.3 48 141.8 48 112.5 48 50.7 98 0 160 0 221.9 0 272 50.6 272 112.4 272 157.2 245.4 198 204.2 215.9zM128 448c37.2 0 73.2-13.8 100.9-38.7l33.8-30.4-129-132.4-44.4 19.2C54.5 280.8 32 315 32 352.9 32 405.3 75.3 448 128 448z"]],
    "chess-clock": [576, 512, [], "f43d", ["M32 160l0 224c0 17.7 14.3 32 32 32l448 0c16.1 0 29.4-11.8 31.7-27.3l0-233.4C541.4 139.8 528.1 128 512 128L64 128c-17.7 0-32 14.3-32 32zM243.9 339.9A96 96 0 1 1 108.1 204.1 96 96 0 1 1 243.9 339.9zM496 272a96 96 0 1 1 -192 0 96 96 0 1 1 192 0z", "M208 16c8.8 0 16 7.2 16 16s-7.2 16-16 16l-48 0 0 48 352 0 6.5 .3C550.8 99.6 576 126.9 576 160l0 224-.3 6.5c-3.1 30.1-27 54.1-57.1 57.1l-6.5 .3-448 0-6.5-.3c-30.1-3.1-54.1-27-57.1-57.1L0 384 0 160c0-33.1 25.2-60.4 57.5-63.7l6.5-.3 64 0 0-48-48 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l128 0zM64 128c-17.7 0-32 14.3-32 32l0 224c0 17.7 14.3 32 32 32l448 0c17.7 0 32-14.3 32-32l0-224c0-17.7-14.3-32-32-32L64 128zM243.9 339.9A96 96 0 1 1 108.1 204.1 96 96 0 1 1 243.9 339.9zM400 368a96 96 0 1 1 0-192 96 96 0 1 1 0 192zM192 272c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-61.9c-10.7 2.8-20.9 8.3-29.2 16.7-25 25-25 65.5 0 90.5s65.5 25 90.5 0 25-65.5 0-90.5c-8.4-8.4-18.5-13.9-29.2-16.7l0 61.9zm208-64c-35.3 0-64 28.7-64 64s28.7 64 64 64 64-28.7 64-64c0-11.9-3.3-22.9-8.9-32.5l-43.8 43.8c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l43.8-43.8c-9.5-5.6-20.6-8.9-32.4-8.9zM480 32c8.8 0 16 7.2 16 16s-7.2 16-16 16L352 64c-8.8 0-16-7.2-16-16s7.2-16 16-16l128 0z"]],
    "envelope": [512, 512, [128386, 9993, 61443], "f0e0", ["M32 122.5c0 8.4 4 16.4 10.8 21.4L227.6 279.3c16.9 12.4 39.9 12.4 56.8 0L469.2 143.8c6.8-5 10.8-12.9 10.8-21.4 0-14.6-11.9-26.5-26.5-26.5l-395 0C43.9 96 32 107.9 32 122.5zm0 53.1L32 384c0 17.7 14.3 32 32 32l384 0c17.7 0 32-14.3 32-32l0-208.4-176.7 129.6c-28.2 20.6-66.5 20.6-94.6 0L32 175.6z", "M0 122.5l0-2.5 .1 0C1.3 88.9 27 64 58.5 64l395 0c31.5 0 57.1 24.9 58.4 56l.1 0 0 264c0 35.3-28.7 64-64 64L64 448c-35.3 0-64-28.7-64-64L0 122.5zm480 53.1L303.3 305.1c-28.2 20.6-66.5 20.6-94.6 0L32 175.6 32 384c0 17.7 14.3 32 32 32l384 0c17.7 0 32-14.3 32-32l0-208.4zm0-53.1c0-14.6-11.9-26.5-26.5-26.5l-395 0c-14.6 0-26.5 11.9-26.5 26.5 0 8.4 4 16.4 10.8 21.4L227.6 279.3c16.9 12.4 39.9 12.4 56.8 0L469.2 143.8c6.8-5 10.8-12.9 10.8-21.4z"]],
    "baby": [384, 512, [], "f77c", ["M38.1 168.1c-8.8 9.9-7.9 25.1 2 33.9l24.2 21.5c16.1 14.3 34.4 25.7 53.9 33.8 6 2.5 9.8 8.3 9.9 14.7l128 0c0-6.5 3.9-12.3 9.9-14.7 19.6-8.1 37.8-19.5 53.9-33.8l24.2-21.5c9.9-8.8 10.8-24 2-33.9s-24-10.8-33.9-2l-24.2 21.5C261.5 211 227.4 224 192 224s-69.5-13-95.9-36.5L71.9 166.1c-9.9-8.8-25.1-7.9-33.9 2zM68 421.3l32 48c7.4 11 22.3 14 33.3 6.7s14-22.3 6.7-33.3l-14.9-22.3c-4-6.1-3.5-14.1 1.4-19.5l16.8-19-34-34-39.2 44.1c-7.3 8.2-8.1 20.2-2 29.3zM144 80a48 48 0 1 0 96 0 48 48 0 1 0 -96 0zm96.7 301.9l16.8 19c4.8 5.4 5.4 13.4 1.4 19.5L244 442.7c-7.4 11-4.4 25.9 6.7 33.3s25.9 4.4 33.3-6.7l32-48c6.1-9.1 5.2-21.1-2-29.3l-39.2-44.1-34 34z", "M192 128a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM192 0a80 80 0 1 1 0 160 80 80 0 1 1 0-160zM14.1 146.8c20.5-23.1 55.9-25.2 79.1-4.7l24.2 21.5C137.9 181.9 164.5 192 192 192s54.1-10.1 74.6-28.4l24.2-21.5c23.1-20.5 58.5-18.5 79.1 4.7s18.5 58.5-4.6 79.1L341 247.3c-16.1 14.3-33.9 26-53 35.1l0 32.3 49.9 56.1c16.9 19 18.9 47.1 4.7 68.3l-32 48c-17.2 25.7-51.9 32.7-77.7 15.5s-32.7-51.9-15.5-77.7l8-12-18.6-20.9-29.7 0-18.6 20.9 8 12c17.2 25.7 10.2 60.5-15.5 77.7s-60.5 10.2-77.7-15.5l-32-48c-14.1-21.2-12.2-49.2 4.7-68.3l49.9-56.1 0-32.3c-19.1-9-37-20.8-53-35.1L18.8 225.9c-23.1-20.5-25.2-55.9-4.7-79.1zm57.8 19.3c-9.9-8.8-25.1-7.9-33.9 2s-7.9 25.1 2 33.9l24.2 21.5c16.1 14.3 34.4 25.7 53.9 33.8 6 2.5 9.8 8.3 9.9 14.7l128 0c0-6.5 3.9-12.3 9.9-14.7 19.6-8.1 37.8-19.5 53.9-33.8l24.2-21.5c9.9-8.8 10.8-24 2-33.9s-24-10.8-33.9-2l-24.2 21.5C261.5 211 227.4 224 192 224s-69.5-13-95.9-36.5L71.9 166.1zM256 304l-128 0 0 16.8c0 .2 0 .4 0 .6l38.9 38.9c1-.2 2-.3 3-.3l44.1 0c1 0 2 .1 3 .3L256 321.4c0-.2 0-.4 0-.6l0-16.8zm18.7 43.9l-34 34 16.8 19c4.8 5.4 5.4 13.4 1.4 19.5L244 442.7c-7.4 11-4.4 25.9 6.7 33.3s25.9 4.4 33.3-6.7l32-48c6.1-9.1 5.2-21.1-2-29.3l-39.2-44.1zm-131.4 34l-34-34-39.2 44.1c-7.3 8.2-8.1 20.2-2 29.3l32 48c7.4 11 22.3 14 33.3 6.7s14-22.3 6.7-33.3l-14.9-22.3c-4-6.1-3.5-14.1 1.4-19.5l16.8-19z"]],
    "nfc-lock": [576, 512, [], "e1f8", ["M64 96c0-17.7 14.3-32 32-32l320 0c17.7 0 32 14.3 32 32l0 81c-24 3-46 12.7-64 27.1l0-44.1c0-17.7-14.3-32-32-32l-80 0c-17.7 0-32 14.3-32 32l0 50.7c-18.6 6.6-32 24.4-32 45.3 0 26.5 21.5 48 48 48s48-21.5 48-48c0-20.9-13.4-38.7-32-45.3l0-50.7 80 0 0 82c-10.2 18.4-16 39.5-16 62l0 24.4c-7.6 6.8-14.1 14.8-19.2 23.6l-156.8 0 0-192 16 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0c-17.7 0-32 14.3-32 32l0 192c0 17.7 14.3 32 32 32l145.3 0c-.9 5.2-1.3 10.5-1.3 15.9l0 48.1-208 0c-17.7 0-32-14.3-32-32L64 96z", "M416 64L96 64C78.3 64 64 78.3 64 96l0 320c0 17.7 14.3 32 32 32l208 0 0 32-208 0c-35.3 0-64-28.7-64-64L32 96c0-35.3 28.7-64 64-64l320 0c35.3 0 64 28.7 64 64l0 81c-5.2-.7-10.6-1-16-1s-10.8 .3-16 1l0-81c0-17.7-14.3-32-32-32zm-32 96l0 44.1c-13 10.4-23.9 23.3-32 37.9l0-82-80 0 0 50.7c18.6 6.6 32 24.4 32 45.3 0 26.5-21.5 48-48 48s-48-21.5-48-48c0-20.9 13.4-38.7 32-45.3l0-50.7c0-17.7 14.3-32 32-32l80 0c17.7 0 32 14.3 32 32zM305.3 384L160 384c-17.7 0-32-14.3-32-32l0-192c0-17.7 14.3-32 32-32l16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0 0 192 156.8 0c-5.6 9.7-9.6 20.5-11.5 32zM256 240a16 16 0 1 0 0 32 16 16 0 1 0 0-32zM384 352.1l0-48c0-44.2 35.8-80 80-80s80 35.8 80 80l0 50.6c18.6 6.6 32 24.4 32 45.3l0 96c0 26.5-21.5 48-48 48l-128 0c-26.5 0-48-21.5-48-48l0-96c0-20.9 13.4-38.7 32-45.3l0-2.6zm0 47.9l0 96c0 8.8 7.2 16 16 16l128 0c8.8 0 16-7.2 16-16l0-96c0-8.2-6.2-15-14.3-15.9l-131.5 0c-8 .9-14.3 7.7-14.3 15.9zm128-95.9c0-26.5-21.5-48-48-48s-48 21.5-48 48l0 47.9 96 0 0-47.9z"]],
    "square-caret-down": [448, 512, ["caret-square-down"], "f150", ["M32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64C46.3 64 32 78.3 32 96zM96 219.5c0-15.2 12.3-27.5 27.5-27.5l201 0c15.2 0 27.5 12.3 27.5 27.5 0 6.9-2.6 13.6-7.3 18.7L249.2 341c-6.5 7-15.6 11-25.2 11s-18.7-4-25.2-11L103.3 238.2c-4.7-5.1-7.3-11.8-7.3-18.7z", "M64 448c-17.7 0-32-14.3-32-32L32 96c0-17.7 14.3-32 32-32l320 0c17.7 0 32 14.3 32 32l0 320c0 17.7-14.3 32-32 32L64 448zM0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416zm224-64c9.6 0 18.7-4 25.2-11l95.5-102.8c4.7-5.1 7.3-11.8 7.3-18.7 0-15.2-12.3-27.5-27.5-27.5l-201 0c-15.2 0-27.5 12.3-27.5 27.5 0 6.9 2.6 13.6 7.3 18.7L198.8 341c6.5 7 15.6 11 25.2 11zm-1.7-32.7l-88.4-95.3 180.3 0-88.4 95.3c-.4 .5-1.1 .7-1.7 .7s-1.3-.3-1.7-.7z"]],
    "hyphen": [320, 512, [], "2d", ["", "M0 256c0-8.8 7.2-16 16-16l288 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L16 272c-8.8 0-16-7.2-16-16z"]],
    "plane-prop": [576, 512, [], "e22b", ["M32 256c0 6.1 4.4 11.4 10.4 12.4l95.8 16.9c10.1 1.8 20.3 2.7 30.6 2.7L512 288c17.7 0 32-14.3 32-32s-14.3-32-32-32l-343.2 0c-10.3 0-20.5 .9-30.6 2.7L42.5 243.6c-6 1.1-10.4 6.3-10.4 12.4zm39.6-50.1l46.7-8.2-16.8-37.7-17.4 0-12.5 45.9zm0 100.1l12.5 45.9 17.4 0 16.8-37.7-46.7-8.2zM241.7 192l68.6 0-20.4-160-27.8 0-20.4 160zm0 128l20.4 160 27.8 0 20.4-160-68.6 0z", "M248 0c-8.1 0-14.9 6-15.9 14l-6.4 50-33.7 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l29.7 0-12.2 96-40.6 0c-5.9 0-11.8 .3-17.6 .7l-24.6-55.2c-2.6-5.8-8.3-9.5-14.6-9.5l-40 0c-7.2 0-13.5 4.8-15.4 11.8L36.8 212.1C15.6 215.9 0 234.4 0 256s15.5 40.1 36.8 43.9l19.7 72.3c1.9 7 8.2 11.8 15.4 11.8l40 0c6.3 0 12.1-3.7 14.6-9.5l24.6-55.2c5.9 .5 11.8 .7 17.6 .7l40.6 0 12.2 96-29.7 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l33.7 0 6.4 50c1 8 7.8 14 15.9 14l56 0c8.1 0 14.9-6 15.9-14l6.4-50 41.7 0 0 32c0 8.8 7.2 16 16 16s16-7.2 16-16l0-32c8.8 0 16-7.2 16-16s-7.2-16-16-16l0-32c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 32-37.7 0 12.2-96 169.4 0c35.3 0 64-28.7 64-64s-28.7-64-64-64l-169.4 0-12.2-96 37.7 0 0 32c0 8.8 7.2 16 16 16s16-7.2 16-16l0-32c8.8 0 16-7.2 16-16s-7.2-16-16-16l0-32c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 32-41.7 0-6.4-50c-1-8-7.8-14-15.9-14L248 0zM118.4 314.3l-16.8 37.7-17.4 0-12.5-45.9 46.7 8.2zM101.6 160l16.8 37.7-46.7 8.2 12.5-45.9 17.4 0zm208.7 32l-68.6 0 20.4-160 27.8 0 20.4 160zm0 128l-20.4 160-27.8 0-20.4-160 68.6 0zM512 224c17.7 0 32 14.3 32 32s-14.3 32-32 32l-343.2 0c-10.3 0-20.5-.9-30.6-2.7L42.5 268.4c-6-1.1-10.4-6.3-10.4-12.4s4.4-11.4 10.4-12.4l95.8-16.9c10.1-1.8 20.3-2.7 30.6-2.7L512 224z"]],
    "tent": [512, 512, [], "e57d", ["M35.5 448l204.7 0 0-368.5-166.9 106.7c-8.3 5.3-13.7 14.1-14.6 23.8L35.5 448zM272.2 80.7l0 154.6 136.7 212.7 68 0-23.2-237.8c-1-9.8-6.4-18.6-14.7-23.9L272.2 80.7z", "M58.8 210.1l-23.3 237.9 204.7 0 0-368.5-166.9 106.7c-8.3 5.3-13.7 14.1-14.6 23.8zM272.2 80.7l0 154.6 136.7 212.7 68 0-23.2-237.8c-1-9.8-6.4-18.6-14.7-23.9L272.2 80.7zm0 213.7l0 153.5 98.7 0-98.7-153.5zM3.7 444.9L26.9 206.9c1.9-19.5 12.7-37.1 29.2-47.7L229.3 48.5c15.7-10 35.8-10.1 51.5-.1L456.1 159.3c16.7 10.6 27.5 28.2 29.5 47.8l23.2 237.8c1.8 18.8-12.9 35.1-31.8 35.1L35.5 480c-18.9 0-33.7-16.3-31.8-35.1z"]],
    "chimney": [448, 512, [], "f78b", ["M32 64l384 0 0 64-384 0 0-64zM48 480c8.8 0 16-7.2 16-16l0-48 96 0 0 48c0 8.8 7.2 16 16 16L48 480zM64 160l96 0 0 96-96 0 0-96zm0 128l192 0 0 96-192 0 0-96zM176 480c8.8 0 16-7.2 16-16l0-48 192 0 0 48c0 8.8 7.2 16 16 16l-224 0zm16-320l192 0 0 96-192 0 0-96zm96 128l96 0 0 96-96 0 0-96z", "M32 64l384 0 0 64-384 0 0-64zm0 96l0 304c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48 96 0 0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48 192 0 0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-304c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32L32 32C14.3 32 0 46.3 0 64l0 64c0 17.7 14.3 32 32 32zm352 0l0 96-192 0 0-96 192 0zm-224 0l0 96-96 0 0-96 96 0zm16 224l-112 0 0-96 192 0 0 96-80 0zm112 0l0-96 96 0 0 96-96 0z"]],
    "a": [384, 512, [97], "41", ["", "M206.7 41.8c-2.5-5.9-8.3-9.8-14.7-9.8s-12.2 3.8-14.7 9.8l-176 416c-3.4 8.1 .4 17.5 8.5 21s17.5-.4 21-8.5l36.5-86.2 249.6 0 36.5 86.2c3.4 8.1 12.8 11.9 21 8.5s11.9-12.8 8.5-21l-176-416zM303.2 352L80.8 352 192 89.1 303.2 352z"]],
    "circle-small": [320, 512, [], "e122", ["M32 256a128 128 0 1 0 256 0 128 128 0 1 0 -256 0z", "M288 256a128 128 0 1 0 -256 0 128 128 0 1 0 256 0zM0 256a160 160 0 1 1 320 0 160 160 0 1 1 -320 0z"]],
    "parachute-box": [512, 512, [], "f4cd", ["M32.6 192l96.9 0c4.7-76.1 26.2-141.8 56.7-182-83.1 25.5-146.6 95.1-153.6 182zm128.9 0l189.9 0C347.9 138.5 335.5 91.6 318.4 57.3 296.9 14.4 273.2 0 256.5 0s-40.4 14.4-61.9 57.3c-17.2 34.3-29.5 81.2-33.1 134.7zm30.9 192l0 64c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-64 0c-17.7 0-32 14.3-32 32zM326.8 10c30.6 40.2 52 105.9 56.7 182l96.9 0c-7-86.9-70.5-156.5-153.6-182z", "M383.5 192c-4.7-76.1-26.2-141.8-56.7-182 83.1 25.5 146.6 95.1 153.6 182l-96.9 0zm-32.1 0l-189.9 0C165.1 138.5 177.4 91.6 194.6 57.3 216.1 14.4 239.8 0 256.5 0s40.4 14.4 61.9 57.3c17.2 34.3 29.5 81.2 33.1 134.7zm-222 0l-96.9 0c7-86.9 70.5-156.5 153.6-182-30.6 40.2-52 105.9-56.7 182zm-69 32l180 0 0 96-16 0c-12.7 0-24.5 3.7-34.4 10L60.5 224zm212 0l180 0-129.6 106c-9.9-6.3-21.7-10-34.4-10l-16 0 0-96zM6.7 220l162 132.6c-5.2 9.3-8.2 20-8.2 31.4l0 64c0 35.3 28.7 64 64 64l64 0c35.3 0 64-28.7 64-64l0-64c0-11.4-3-22.2-8.2-31.4L506.3 220c3.6-2.9 5.7-7.3 5.7-12 0-134.7-114.8-234.7-246.1-239.3-3.1-.5-6.2-.7-9.4-.7s-6.3 .2-9.4 .7C115.8-26.7 1 73.3 1 208 1 212.6 3.1 217 6.7 220zM224.5 352l64 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32z"]],
    "cart-flatbed-boxes": [576, 512, ["dolly-flatbed-alt"], "f475", ["M160 448a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm32-336l0 160c0 8.8 7.2 16 16 16l96 0c8.8 0 16-7.2 16-16l0-160c0-8.8-7.2-16-16-16l-96 0c-8.8 0-16 7.2-16 16zm160 64l0 96c0 8.8 7.2 16 16 16l96 0c8.8 0 16-7.2 16-16l0-96c0-8.8-7.2-16-16-16l-96 0c-8.8 0-16 7.2-16 16zm64 272a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M0 16C0 7.2 7.2 0 16 0L48 0C74.5 0 96 21.5 96 48l0 304c0 17.7 14.3 32 32 32l432 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-56.6 0c5.4 9.4 8.6 20.3 8.6 32 0 35.3-28.7 64-64 64s-64-28.7-64-64c0-11.7 3.1-22.6 8.6-32l-145.1 0c5.4 9.4 8.6 20.3 8.6 32 0 35.3-28.7 64-64 64s-64-28.7-64-64c0-11.7 3.1-22.6 8.6-32l-8.6 0c-35.3 0-64-28.7-64-64L64 48c0-8.8-7.2-16-16-16L16 32C7.2 32 0 24.8 0 16zM448 416a32 32 0 1 0 0 64 32 32 0 1 0 0-64zM160 448a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zM304 96l-96 0c-8.8 0-16 7.2-16 16l0 160c0 8.8 7.2 16 16 16l96 0c8.8 0 16-7.2 16-16l0-160c0-8.8-7.2-16-16-16zm48 34.7c5-1.8 10.4-2.7 16-2.7l96 0c26.5 0 48 21.5 48 48l0 96c0 26.5-21.5 48-48 48l-96 0c-12.3 0-23.5-4.6-32-12.2-8.5 7.6-19.7 12.2-32 12.2l-96 0c-26.5 0-48-21.5-48-48l0-160c0-26.5 21.5-48 48-48l96 0c26.5 0 48 21.5 48 48l0 18.7zm0 45.3l0 96c0 8.8 7.2 16 16 16l96 0c8.8 0 16-7.2 16-16l0-96c0-8.8-7.2-16-16-16l-96 0c-8.8 0-16 7.2-16 16z"]],
    "cart-arrow-down": [640, 512, [], "f218", ["M106.3 31.3l213.7 0 0 106.1-44.7-44.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l72 72c6.2 6.2 16.4 6.2 22.6 0l72-72c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-44.7 44.7 0-106.1 216.2 0-.5 2.7c-1.3-.7-2.8-1.3-4.3-1.6-8.6-1.9-17.1 3.7-19 12.3L505.8 224.4c-4 18.4-20.2 31.6-39.1 31.6l-318.8 0-39.4-216.6c-.5-2.8-1.3-5.5-2.2-8.1zM228 460a20 20 0 1 1 -40 0 20 20 0 1 1 40 0zm224 0a20 20 0 1 1 -40 0 20 20 0 1 1 40 0z", "M0 16C0 7.2 7.2 0 16 0L61.3 0c23.2 0 43.1 16.6 47.2 39.4l39.4 216.6 318.8 0c18.9 0 35.2-13.2 39.1-31.6L544.4 44.6c1.9-8.6 10.4-14.1 19-12.3s14.1 10.4 12.3 19L537.1 231.1C530 264.3 500.7 288 466.7 288l-313 0 5.7 31.2c3.5 19 20 32.8 39.4 32.8L464 352c8.8 0 16 7.2 16 16s-7.2 16-16 16l-265.3 0c-34.8 0-64.6-24.9-70.8-59.1L77 45.1C75.7 37.5 69 32 61.3 32L16 32C7.2 32 0 24.8 0 16zM208 480a20 20 0 1 0 0-40 20 20 0 1 0 0 40zm0-72a52 52 0 1 1 0 104 52 52 0 1 1 0-104zm244 52a20 20 0 1 0 -40 0 20 20 0 1 0 40 0zm-72 0a52 52 0 1 1 104 0 52 52 0 1 1 -104 0zM324.7 187.3l-72-72c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0L320 137.4 320 16c0-8.8 7.2-16 16-16s16 7.2 16 16l0 121.4 44.7-44.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6l-72 72c-6.2 6.2-16.4 6.2-22.6 0z"]],
    "circle-7": [512, 512, [], "e0f4", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm160-80c0-8.8 7.2-16 16-16l112 0c5.9 0 11.3 3.2 14.1 8.4s2.5 11.4-.6 16.4l-104 160c-4.8 7.4-14.7 9.5-22.1 4.7s-9.5-14.7-4.7-22.1L290.5 192 208 192c-8.8 0-16-7.2-16-16z", "M256 32a224 224 0 1 1 0 448 224 224 0 1 1 0-448zm0 480a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM208 160c-8.8 0-16 7.2-16 16s7.2 16 16 16l82.5 0-87.9 135.3c-4.8 7.4-2.7 17.3 4.7 22.1s17.3 2.7 22.1-4.7l104-160c3.2-4.9 3.4-11.2 .6-16.4S325.9 160 320 160l-112 0z"]],
    "lock-hashtag": [384, 512, [], "e423", ["M32 224l0 224c0 17.7 14.3 32 32 32l256 0c17.7 0 32-14.3 32-32l0-224c0-17.7-14.3-32-32-32L64 192c-17.7 0-32 14.3-32 32zm64 64c0-8.8 7.2-16 16-16l16 0 0-16c0-8.8 7.2-16 16-16s16 7.2 16 16l0 16 64 0 0-16c0-8.8 7.2-16 16-16s16 7.2 16 16l0 16 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0 0 64 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0 0 16c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-16-64 0 0 16c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-16-16 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0 0-64-16 0c-8.8 0-16-7.2-16-16zm64 16l0 64 64 0 0-64-64 0z", "M192 0c53 0 96 43 96 96l0 64-192 0 0-64c0-53 43-96 96-96zM64 96l0 64c-35.3 0-64 28.7-64 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-224c0-35.3-28.7-64-64-64l0-64c0-70.7-57.3-128-128-128S64 25.3 64 96zm0 96l256 0c17.7 0 32 14.3 32 32l0 224c0 17.7-14.3 32-32 32L64 480c-17.7 0-32-14.3-32-32l0-224c0-17.7 14.3-32 32-32zm80 48c-8.8 0-16 7.2-16 16l0 16-16 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l16 0 0 64-16 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l16 0 0 16c0 8.8 7.2 16 16 16s16-7.2 16-16l0-16 64 0 0 16c0 8.8 7.2 16 16 16s16-7.2 16-16l0-16 16 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0 0-64 16 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0 0-16c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 16-64 0 0-16c0-8.8-7.2-16-16-16zm16 128l0-64 64 0 0 64-64 0z"]],
    "circle-sterling": [512, 512, [], "e5cf", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zM145.8 359.4c-2.8-5.3-2.3-11.7 1.1-16.6l30.8-44c5.7-8.1 9.4-17.3 11-26.9L176 272c-8.8 0-16-7.2-16-16s7.2-16 16-16l10.3 0c-.4-1.1-.7-2.1-1.1-3.2L179 221c-20.4-52.4 18.3-109 74.6-109l1.3 0c25.5 0 49.9 10.1 67.9 28.1l8.6 8.6c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-8.6-8.6c-12-12-28.3-18.7-45.3-18.7l-1.3 0c-33.8 0-57 33.9-44.7 65.4l6.2 15.8c1.9 4.8 3.4 9.8 4.4 14.8l84.6 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-83 0c-1.8 16-7.6 31.6-17.1 45.2L190.7 336 336 336c8.8 0 16 7.2 16 16s-7.2 16-16 16l-176 0c-6 0-11.4-3.3-14.2-8.6z", "M256 32a224 224 0 1 1 0 448 224 224 0 1 1 0-448zm0 480a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM179 221l6.2 15.8c.4 1.1 .8 2.1 1.1 3.2L176 240c-8.8 0-16 7.2-16 16s7.2 16 16 16l12.7 0c-1.6 9.5-5.3 18.7-11 26.9l-30.8 44c-3.4 4.9-3.8 11.3-1.1 16.6S154 368 160 368l176 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-145.3 0 13.2-18.8c9.5-13.6 15.3-29.2 17.1-45.2l83 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-84.6 0c-1.1-5-2.6-9.9-4.4-14.8l-6.2-15.8c-12.2-31.5 11-65.4 44.7-65.4l1.3 0c17 0 33.3 6.7 45.3 18.7l8.6 8.6c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-8.6-8.6c-18-18-42.4-28.1-67.9-28.1l-1.3 0c-56.3 0-95 56.6-74.6 109z"]],
    "bridge-circle-exclamation": [576, 512, [], "e4ca", ["M32 160l448 0 0 54c-15.3-3.9-31.4-6-48-6-53.2 0-101.4 21.7-136.2 56.6-12.1-5.5-25.6-8.6-39.8-8.6-53 0-96 43-96 96l0 96-64 0 0-113.5c0-41-26-77.1-64-90.5L32 160z", "M16 32C7.2 32 0 39.2 0 48S7.2 64 16 64l32 0 0 64-32 0c-8.8 0-16 7.2-16 16L0 256c0 7.3 5 13.7 12.1 15.5l3.4 .9C44 279.5 64 305.1 64 334.5L64 448c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-96c0-35.3 28.7-64 64-64 6.3 0 12.4 .9 18.2 2.6 6.5-9.3 13.7-18 21.7-26-12.1-5.5-25.6-8.6-39.8-8.6-53 0-96 43-96 96l0 96-64 0 0-113.5c0-41-26-77.1-64-90.5l0-83.9 448 0 0 54c11.1 2.9 21.8 6.7 32 11.4l0-81.4c0-8.8-7.2-16-16-16l-32 0 0-64 32 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L16 32zM432 64l0 64-96 0 0-64 96 0zM304 64l0 64-96 0 0-64 96 0zM176 64l0 64-96 0 0-64 96 0zM320 400a112 112 0 1 1 224 0 112 112 0 1 1 -224 0zm256 0a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zM432 484a20 20 0 1 0 0-40 20 20 0 1 0 0 40zm0-164c-8.8 0-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16s16-7.2 16-16l0-64c0-8.8-7.2-16-16-16z"]],
    "cloud-arrow-up": [576, 512, [62338, "cloud-upload", "cloud-upload-alt"], "f0ee", ["M32 336c0 61.9 50.1 112 112 112l304 0c53 0 96-43 96-96 0-41.8-26.8-77.5-64.2-90.6-4.3-1.5-7.8-4.8-9.5-9.1s-1.5-9 .5-13.1c5.9-11.8 9.2-25.1 9.2-39.2 0-48.6-39.4-88-88-88-13.6 0-26.4 3.1-37.9 8.5-7.2 3.5-15.9 1-20.3-5.7-20-30.6-54.6-50.8-93.8-50.8-61.9 0-112 50.1-112 112 0 10.6 1.5 20.9 4.2 30.5 1.2 4.3 .6 8.8-1.7 12.6s-6 6.5-10.3 7.4C69.8 237.4 32 282.3 32 336zm172.7-67.3l72-72c6.2-6.2 16.4-6.2 22.6 0l72 72c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L304 246.6 304 368c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-121.4-44.7 44.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6z", "M128 176c0-61.9 50.1-112 112-112 39.3 0 73.8 20.2 93.8 50.8 4.4 6.7 13.1 9.1 20.3 5.7 11.4-5.5 24.3-8.5 37.9-8.5 48.6 0 88 39.4 88 88 0 14.1-3.3 27.4-9.2 39.2-2 4.1-2.2 8.9-.5 13.1s5.2 7.6 9.5 9.1c37.4 13.1 64.2 48.8 64.2 90.6 0 53-43 96-96 96l-304 0c-61.9 0-112-50.1-112-112 0-53.7 37.8-98.6 88.2-109.5 4.3-.9 8.1-3.6 10.3-7.4s2.9-8.3 1.7-12.6c-2.7-9.7-4.2-19.9-4.2-30.5zM240 32c-79.5 0-144 64.5-144 144 0 8 .7 15.9 1.9 23.5-56.9 19.2-97.9 73-97.9 136.5 0 79.5 64.5 144 144 144l304 0c70.7 0 128-57.3 128-128 0-49.9-28.5-93-70.1-114.2 3.9-11.9 6.1-24.6 6.1-37.8 0-66.3-53.7-120-120-120-13.7 0-26.9 2.3-39.2 6.5-26.4-33.2-67.1-54.5-112.8-54.5zm59.3 164.7c-6.2-6.2-16.4-6.2-22.6 0l-72 72c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0L272 246.6 272 368c0 8.8 7.2 16 16 16s16-7.2 16-16l0-121.4 44.7 44.7c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-72-72z"]],
    "at": [512, 512, [61946], "40", ["", "M256 32C132.3 32 32 132.3 32 256S132.3 480 256 480c8.8 0 16 7.2 16 16s-7.2 16-16 16C114.6 512 0 397.4 0 256S114.6 0 256 0 512 114.6 512 256l0 24c0 48.6-39.4 88-88 88-33.4 0-62.5-18.7-77.4-46.1-20.4 28-53.4 46.1-90.6 46.1-61.9 0-112-50.1-112-112s50.1-112 112-112c31.3 0 59.7 12.9 80 33.6l0-1.6c0-8.8 7.2-16 16-16s16 7.2 16 16l0 104c0 30.9 25.1 56 56 56s56-25.1 56-56l0-24C480 132.3 379.7 32 256 32zm80 224a80 80 0 1 0 -160 0 80 80 0 1 0 160 0z"]],
    "indian-rupee-sign": [320, 512, ["indian-rupee", "inr"], "e1bc", ["", "M0 48c0-8.8 7.2-16 16-16l288 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L202.5 64c28.7 23.2 48.3 57.3 52.6 96l48.9 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-48.9 0c-8 72-69 128-143.1 128l-46.1 0 183.4 131c7.2 5.1 8.9 15.1 3.7 22.3s-15.1 8.9-22.3 3.7L6.7 317C1 313-1.4 305.7 .8 299.1S9 288 16 288l96 0c56.4 0 103.1-41.7 110.9-96L16 192c-8.8 0-16-7.2-16-16s7.2-16 16-16l206.9 0c-7.8-54.3-54.4-96-110.9-96L16 64C7.2 64 0 56.8 0 48z"]],
    "truck": [576, 512, [128666, 9951], "f0d1", ["M32 96l0 288c0 17.7 14.3 32 32 32l.4 0c4-44.9 41.7-80 87.6-80s83.6 35.1 87.6 80l96.7 0c2.8-30.8 21.4-57 47.6-70.4L384 96c0-17.7-14.3-32-32-32L64 64C46.3 64 32 78.3 32 96zM416 288l0 48.4c2.6-.2 5.3-.4 8-.4 45.9 0 83.6 35.1 87.6 80l.4 0c17.7 0 32-14.3 32-32l0-96-128 0z", "M64 64C46.3 64 32 78.3 32 96l0 288c0 17.7 14.3 32 32 32l.4 0c4-44.9 41.7-80 87.6-80s83.6 35.1 87.6 80l96.7 0c2.8-30.8 21.4-57 47.6-70.4L384 96c0-17.7-14.3-32-32-32L64 64zM416 288l0 48.4c2.6-.2 5.3-.4 8-.4 45.9 0 83.6 35.1 87.6 80l.4 0c17.7 0 32-14.3 32-32l0-96-128 0zm128-32l0-28.1c0-8.5-3.4-16.6-9.4-22.6l-35.9-35.9c-6-6-14.1-9.4-22.6-9.4l-60.1 0 0 96 128 0zM67.3 448L64 448c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l288 0c35.3 0 64 28.7 64 64l0 32 60.1 0c17 0 33.3 6.7 45.3 18.7l35.9 35.9c12 12 18.7 28.3 18.7 45.3L576 384c0 35.3-28.7 64-64 64l-3.3 0c-10.4 36.9-44.4 64-84.7 64s-74.2-27.1-84.7-64l-102.6 0c-10.4 36.9-44.4 64-84.7 64s-74.2-27.1-84.7-64zM152 480a56 56 0 1 0 0-112 56 56 0 1 0 0 112zm272 0a56 56 0 1 0 0-112 56 56 0 1 0 0 112z"]],
    "game-console-handheld-crank": [576, 512, [], "e5b9", ["M32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64C46.3 64 32 78.3 32 96zm32 32c0-17.7 14.3-32 32-32l256 0c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32L96 288c-17.7 0-32-14.3-32-32l0-128zm0 240c0-8.8 7.2-16 16-16l16 0 0-16c0-8.8 7.2-16 16-16s16 7.2 16 16l0 16 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0 0 16c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-16-16 0c-8.8 0-16-7.2-16-16zm208-8a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm80 0a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zM512 160l0 32 32 0 0-32-32 0z", "M64 64C46.3 64 32 78.3 32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64zM448 96l0 160 32 0 0-96c0-17.7 14.3-32 32-32l32 0c17.7 0 32 14.3 32 32l0 32c0 17.7-14.3 32-32 32l-32 0 0 48c0 8.8-7.2 16-16 16l-48 0 0 128c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64zM96 128l0 128 256 0 0-128-256 0zm-32 0c0-17.7 14.3-32 32-32l256 0c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32L96 288c-17.7 0-32-14.3-32-32l0-128zm448 64l32 0 0-32-32 0 0 32zM128 336l0 16 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0 0 16c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-16-16 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0 0-16c0-8.8 7.2-16 16-16s16 7.2 16 16zm96 24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm104-24a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]],
    "chalkboard-user": [640, 512, ["chalkboard-teacher"], "f51c", ["M160 96c0-17.7 14.3-32 32-32l352 0c17.7 0 32 14.3 32 32l0 288c0 17.7-14.3 32-32 32l-32 0 0-64c0-17.7-14.3-32-32-32l-96 0c-17.7 0-32 14.3-32 32l0 64-29.9 0c-15.1-31.4-41.5-56.4-74-69.6 15-21 23.8-46.7 23.8-74.4 0-65.3-48.9-119.1-112-127l0-49z", "M192 64l352 0c17.7 0 32 14.3 32 32l0 288c0 17.7-14.3 32-32 32l-32 0 0-64c0-17.7-14.3-32-32-32l-96 0c-17.7 0-32 14.3-32 32l0 64-29.9 0c4.8 10.1 8.5 20.8 10.9 32l211 0c35.3 0 64-28.7 64-64l0-288c0-35.3-28.7-64-64-64L192 32c-35.3 0-64 28.7-64 64l0 49c5.2-.7 10.6-1 16-1s10.8 .3 16 1l0-49c0-17.7 14.3-32 32-32zM384 416l0-64 96 0 0 64-96 0zM96 272a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm128 0a80 80 0 1 0 -160 0 80 80 0 1 0 160 0zM96 384c-53 0-96 43-96 96l0 16c0 8.8 7.2 16 16 16s16-7.2 16-16l0-16c0-35.3 28.7-64 64-64l96 0c35.3 0 64 28.7 64 64l0 16c0 8.8 7.2 16 16 16s16-7.2 16-16l0-16c0-53-43-96-96-96l-96 0z"]],
    "user-check": [640, 512, [], "f4fc", ["M48.5 512c8.8 0 16-7.2 16-16l0-16c0-79.5 64.5-144 144-144l96 0c79.5 0 144 64.5 144 144l0 16c0 8.8 7.2 16 16 16l-416 0zm304-384a96 96 0 1 1 -192 0 96 96 0 1 1 192 0z", "M304.5 304c97.2 0 176 78.8 176 176l0 16c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-16c0-79.5-64.5-144-144-144l-96 0c-79.5 0-144 64.5-144 144l0 16c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-16c0-97.2 78.8-176 176-176l96 0zM595.6 106.2c5.2-7.1 15.2-8.7 22.3-3.5s8.7 15.2 3.5 22.3L515.8 270.2c-2.8 3.8-7.1 6.2-11.8 6.5s-9.3-1.4-12.6-4.8L437 215.6c-6.1-6.4-6-16.5 .4-22.6s16.5-5.9 22.6 .4l41.2 42.6 94.4-129.8zM256.5 256a128 128 0 1 1 0-256 128 128 0 1 1 0 256zm0-224a96 96 0 1 0 0 192 96 96 0 1 0 0-192z"]],
    "chart-pie-simple-circle-currency": [640, 512, [], "e604", ["M64 272c0-98.3 68.3-180.8 160-202.4L224 272c0 26.5 21.5 48 48 48l47.2 0c2.4-5.3 5.1-10.5 7.9-15.6l2.3 0c-16.2 28.1-25.4 60.8-25.4 95.6 0 32.3 8 62.7 22 89.4-.7 .2-1.3 .3-2 .5-2.5-4.8-4.8-9.7-7-14.8-14.5 3.2-29.6 4.9-45.1 4.9-114.9 0-208-93.1-208-208z", "M336 34.4l0 173.6 132 0c-30 4.3-57.8 15.6-81.8 32L336 240c-17.7 0-32-14.3-32-32l0-176c0-17.7 14.4-32.2 31.9-29.9 107 14.2 191.8 99 206 206 .2 1.2 .2 2.3 .2 3.4-10.6-2.6-21.6-4.3-32.8-5.1-14.3-88.5-84.6-158.3-173.3-172zM272 288l65.6 0c-7.1 10-13.3 20.7-18.4 32L272 320c-26.5 0-48-21.5-48-48l0-202.4c-91.7 21.7-160 104.1-160 202.4 0 114.9 93.1 208 208 208 15.5 0 30.6-1.7 45.1-4.9 4.3 10.2 9.4 20 15.3 29.2-19.3 5-39.5 7.7-60.4 7.7-132.5 0-240-107.5-240-240 0-114.1 79.6-209.6 186.3-234 20.4-4.7 37.7 11.6 37.7 30.7L256 272c0 8.8 7.2 16 16 16zM496 512a112 112 0 1 0 0-224 112 112 0 1 0 0 224zm0-256a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm0 176a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm55.1 .5l12.2 12.2c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-12.2-12.2c-9.5 5.6-20.6 8.9-32.5 8.9s-23-3.2-32.5-8.9l-12.2 12.2c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l12.2-12.2c-5.6-9.5-8.9-20.6-8.9-32.5s3.2-23 8.9-32.5l-12.2-12.2c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l12.2 12.2c9.5-5.6 20.6-8.9 32.5-8.9s23 3.2 32.5 8.9l12.2-12.2c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6l-12.2 12.2c5.6 9.5 8.9 20.6 8.9 32.5s-3.2 23-8.9 32.5z"]],
    "face-fearful": [512, 512, [], "e375", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm208-32a80 80 0 1 1 -160 0 80 80 0 1 1 160 0zM84.3 138.9c-6-6.5-5.7-16.6 .8-22.6 20.1-18.7 45.5-31.5 73.7-35.2 5.6-.7 11.4-1.1 17.2-1.1 8.8 0 16 7.2 16 16s-7.2 16-16 16c-4.4 0-8.8 .3-13 .9-21.2 2.8-40.6 12.4-56.1 26.8-6.5 6-16.6 5.7-22.6-.8zM160 395.8c0-50.7 41.1-91.8 91.8-91.8l8.4 0c50.7 0 91.8 41.1 91.8 91.8 0 11.2-9 20.2-20.2 20.2l-151.6 0c-11.2 0-20.2-9-20.2-20.2zM432 224a80 80 0 1 1 -160 0 80 80 0 1 1 160 0zM320 96c0-8.8 7.2-16 16-16 5.8 0 11.6 .4 17.2 1.1 28.2 3.7 53.7 16.4 73.7 35.2 6.5 6 6.8 16.2 .8 22.6s-16.2 6.8-22.6 .8c-15.5-14.5-34.8-24-56.1-26.8-4.3-.6-8.6-.9-13-.9-8.8 0-16-7.2-16-16z", "M480 256a224 224 0 1 0 -448 0 224 224 0 1 0 448 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm251.8 48l8.4 0c50.7 0 91.8 41.1 91.8 91.8 0 11.2-9 20.2-20.2 20.2l-151.6 0c-11.2 0-20.2-9-20.2-20.2 0-50.7 41.1-91.8 91.8-91.8zm8.4 32l-8.4 0c-29 0-53.2 20.6-58.6 48l125.7 0c-5.5-27.4-29.6-48-58.6-48zM136 224a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm216-24a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM176 112c-4.4 0-8.8 .3-13 .9-21.2 2.8-40.6 12.4-56.1 26.8-6.5 6-16.6 5.7-22.6-.8s-5.7-16.6 .8-22.6c20.1-18.7 45.5-31.5 73.7-35.2 5.6-.7 11.4-1.1 17.2-1.1 8.8 0 16 7.2 16 16s-7.2 16-16 16zm173 .9c-4.3-.6-8.6-.9-13-.9-8.8 0-16-7.2-16-16s7.2-16 16-16c5.8 0 11.6 .4 17.2 1.1 28.2 3.7 53.7 16.4 73.7 35.2 6.5 6 6.8 16.2 .8 22.6s-16.2 6.8-22.6 .8c-15.5-14.5-34.8-24-56.1-26.8zM160 176a48 48 0 1 0 0 96 48 48 0 1 0 0-96zm80 48a80 80 0 1 1 -160 0 80 80 0 1 1 160 0zm64 0a48 48 0 1 0 96 0 48 48 0 1 0 -96 0zm48 80a80 80 0 1 1 0-160 80 80 0 1 1 0 160z"]],
    "user-ninja": [448, 512, [129399], "f504", ["M16 512c8.8 0 16-7.2 16-16l0-16c0-66.4 45-122.4 106.2-139 50.7 58.8 96.6 112.1 137.7 159.7 5.8 6.7 15.9 7.4 22.6 1.7s7.4-15.9 1.7-22.6l-55-63.8 64.7-75C371 357.6 416 413.6 416 480l0 16c0 8.8 7.2 16 16 16L16 512zM133.5 160l181.1 0c-13.2 37.3-48.7 64-90.5 64s-77.4-26.7-90.5-64zm19-96C170 44.4 195.6 32 224 32s54 12.4 71.6 32L152.4 64z", "M224 224c41.8 0 77.4-26.7 90.5-64l-181.1 0c13.2 37.3 48.7 64 90.5 64zM314.5 96L136 96c-.8 0-1.7-.1-2.5-.2-3.6 10.1-5.5 20.9-5.5 32.2l192 0c0-11.2-1.9-22-5.5-32zm-19-32C278 44.4 252.4 32 224 32s-54 12.4-71.6 32l143.1 0zM224 256c-63.6 0-116.3-46.3-126.3-107.1L75.3 171.3c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6L89.4 112 52.7 75.3c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l29.2 29.2C123 34 169.6 0 224 0 294.7 0 352 57.3 352 128S294.7 256 224 256zm-83.5 51.6c1.1-.2 2.2-.4 3.3-.4 .9 0 1.7 0 2.6 .2 3.7 .5 7.2 2.4 9.8 5.4l67.9 78.7 67.9-78.7c3.8-4.4 9.6-6.4 15.3-5.2 80.3 16.3 140.8 87.3 140.8 172.5l0 16c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-16c0-66.4-45-122.4-106.2-139l-64.7 75 55 63.8c5.8 6.7 5 16.8-1.7 22.6s-16.8 5-22.6-1.7C234.8 453.1 188.9 399.8 138.2 341 77 357.6 32 413.6 32 480l0 16c0 8.8-7.2 16-16 16S0 504.8 0 496l0-16c0-85 60.3-156 140.5-172.4z"]],
    "frame": [512, 512, [], "e495", ["M96 96l0 320 320 0 0-320-320 0z", "M512 80c0-8.8-7.2-16-16-16l-48 0 0-48c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 48-320 0 0-48C96 7.2 88.8 0 80 0S64 7.2 64 16l0 48-48 0C7.2 64 0 71.2 0 80S7.2 96 16 96l48 0 0 320-48 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l48 0 0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48 320 0 0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48 48 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-48 0 0-320 48 0c8.8 0 16-7.2 16-16zM416 96l0 320-320 0 0-320 320 0z"]],
    "plant-wilt": [512, 512, [], "e5aa", ["M32 331.1c0 5.8 3.3 18.8 13.5 36.5 8.3 14.5 20.1 30 34.5 44.3 14.4-14.3 26.2-29.9 34.5-44.3 10.2-17.7 13.5-30.7 13.5-36.5 0-31.2-20.1-51.1-48-51.1s-48 19.9-48 51.1zm352-160c0 5.8 3.3 18.8 13.5 36.5 8.3 14.5 20.1 30 34.5 44.3 14.4-14.3 26.2-29.9 34.5-44.3 10.2-17.7 13.5-30.7 13.5-36.5 0-31.2-20.1-51.1-48-51.1s-48 19.9-48 51.1z", "M344-32c57.4 0 104 46.6 104 104l0 17.4c35.7 6.6 60.3 35.4 63.6 72.9l.4 8.7c0 27.9-25.3 74.8-66 111.7-3.8 3.5-8.8 5.3-14 5.3s-10.2-1.8-14-5.3c-40.7-36.8-66-83.7-66-111.7l.4-8.7c3.3-37.5 28-66.3 63.6-72.9L416 72c0-39.8-32.2-72-72-72s-72 32.2-72 72l0 456c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-328c0-39.8-32.2-72-72-72s-72 32.2-72 72l0 48.2c0 .4-.1 .8-.1 1.2 35.7 6.6 60.4 35.4 63.8 72.9l.4 8.7c0 27.9-25.3 74.8-66 111.7-3.8 3.5-8.8 5.3-14 5.3s-10.2-1.8-14-5.3C25.3 405.9 0 359 0 331.1l.4-8.7c3.3-37.5 28-66.3 63.7-72.9 0-.4-.1-.8-.1-1.2L64 200c0-57.4 46.6-104 104-104 28 0 53.3 11.1 72 29.1L240 72c0-57.4 46.6-104 104-104zM80 280c-27.9 0-48 19.9-48 51.1 0 5.8 3.3 18.8 13.5 36.5 8.3 14.5 20.1 30 34.5 44.3 14.4-14.3 26.2-29.9 34.5-44.3 10.2-17.7 13.5-30.7 13.5-36.5 0-31.2-20.1-51.1-48-51.1zM432 120c-27.9 0-48 19.9-48 51.1 0 5.8 3.3 18.8 13.5 36.5 8.3 14.5 20.1 30 34.5 44.3 14.4-14.3 26.2-29.9 34.5-44.3 10.2-17.7 13.5-30.7 13.5-36.5 0-31.2-20.1-51.1-48-51.1z"]],
    "weight-scale": [448, 512, ["weight"], "f496", ["M32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32l-40.2 0c15.3 22.9 24.2 50.4 24.2 80 0 22-4.9 42.8-13.7 61.4-5.7 12.1-18.5 18.6-31.9 18.6l-196.8 0c-13.3 0-26.2-6.5-31.9-18.6-8.8-18.6-13.7-39.5-13.7-61.4 0-29.6 8.9-57.1 24.2-80L64 64C46.3 64 32 78.3 32 96z", "M325.5 191.3c-.5 .3-1.6 .7-3.1 .7l-75.5 0 24.2-66.5c3-8.3-1.3-17.5-9.6-20.5s-17.5 1.3-20.5 9.6l-28.2 77.5-87.2 0c-1.6 0-2.7-.4-3.2-.7-6.7-14.3-10.5-30.4-10.5-47.3 0-31.3 12.9-59.7 33.6-80 2.3-2.2 4.7-4.4 7.1-6.4 19.4-16 44.2-25.6 71.2-25.6 30.5 0 58.2 12.2 78.4 32 20.7 20.3 33.6 48.7 33.6 80 0 17-3.8 33-10.5 47.3zM368 144c0-29.6-8.9-57.1-24.2-80L384 64c17.7 0 32 14.3 32 32l0 320c0 17.7-14.3 32-32 32L64 448c-17.7 0-32-14.3-32-32L32 96c0-17.7 14.3-32 32-32l40.2 0c-15.3 22.9-24.2 50.4-24.2 80 0 22 4.9 42.8 13.7 61.4 5.7 12.1 18.5 18.6 31.9 18.6l196.8 0c13.3 0 26.2-6.5 31.9-18.6 8.8-18.6 13.7-39.5 13.7-61.4zM384 32l-69.5 0C289.8 12 258.3 0 224 0s-65.8 12-90.5 32L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64z"]],
    "farm": [576, 512, ["barn-silo"], "f864", ["M32 80l0 26.2 102 0c11.9-20.1 30.2-36 52.3-44.8l3.2-1.3C180.6 25.5 149.3 0 112 0 67.8 0 32 35.8 32 80zm0 58.2L32 448c0 17.7 14.3 32 32 32l50.8 0c-1.8-7.7-2.8-15.7-2.8-24l0-122.3c-19.5-15.5-32-39.4-32-66.2 0-9.6 1.6-19.1 4.8-28.1 11.9-33.7 23.8-67.5 35.7-101.2l-88.5 0zM160.3 266c-.2 .5-.3 1-.3 1.5 0 2.5 2 4.5 4.5 4.5l11.5 0c8.8 0 16 7.2 16 16l0 168c0 13.3 10.7 24 24 24l56 0 0-88c0-30.9 25.1-56 56-56l48 0c30.9 0 56 25.1 56 56l0 88 56 0c13.3 0 24-10.7 24-24l0-168c0-8.8 7.2-16 16-16l11.5 0c2.5 0 4.5-2 4.5-4.5 0-.5-.1-1-.3-1.5L503.4 151.6c-2.6-7.3-8.2-13.1-15.4-16L362 85.2c-6.4-2.6-13.5-2.6-19.9 0L216 135.6c-7.2 2.9-12.8 8.7-15.4 16L160.3 266zM288 192c0-17.7 14.3-32 32-32l64 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-64z", "M114.8 480c2.7 11.5 7.4 22.3 13.6 32L64 512c-35.3 0-64-28.7-64-64L0 80C0 18.1 50.1-32 112-32 162.8-32 205.7 1.8 219.4 48.1l-29.9 12C180.6 25.5 149.3 0 112 0 67.8 0 32 35.8 32 80l0 26.2 102 0c-3.5 5.9-6.5 12.2-8.8 18.8l-4.6 13.2-88.5 0 0 309.8c0 17.7 14.3 32 32 32l50.8 0zM342 85.2L216 135.6c-7.2 2.9-12.8 8.7-15.4 16L160.3 266c-.2 .5-.3 1-.3 1.5 0 2.5 2 4.5 4.5 4.5l11.5 0c8.8 0 16 7.2 16 16l0 168c0 13.3 10.7 24 24 24l56 0 0-88c0-30.9 25.1-56 56-56l48 0c30.9 0 56 25.1 56 56l0 88 56 0c13.3 0 24-10.7 24-24l0-168c0-8.8 7.2-16 16-16l11.5 0c2.5 0 4.5-2 4.5-4.5 0-.5-.1-1-.3-1.5L503.4 151.6c-2.6-7.3-8.2-13.1-15.4-16L362 85.2c-6.4-2.6-13.5-2.6-19.9 0zM488 512l-272 0c-30.9 0-56-25.1-56-56l0-152.3c-18-2.2-32-17.6-32-36.2 0-4.1 .7-8.2 2.1-12.1L170.4 141c5.6-16 17.9-28.8 33.6-35.1l126-50.4c14-5.6 29.7-5.6 43.7 0l126.1 50.4c15.7 6.3 28 19.1 33.6 35.1l40.4 114.4c1.4 3.9 2.1 8 2.1 12.1 0 18.6-14 34-32 36.2L544 456c0 30.9-25.1 56-56 56zM400 392c0-13.3-10.7-24-24-24l-48 0c-13.3 0-24 10.7-24 24l0 88 96 0 0-88zM320 192l0 64 64 0 0-64-64 0zm-32 0c0-17.7 14.3-32 32-32l64 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-64z"]],
    "caret-right": [256, 512, [], "f0da", ["M80.3 128l0 256 16 16 144-144-144-144-16 16zm16 0L223.2 254.9c.3 .4 .6 .8 .7 1.1-42.5 42.8-85 85.4-127.6 128l0-256z", "M246.9 233.4c11.6 12.9 12.8 32.4 0 45.2l-128 128c-9.1 9.2-22.9 11.9-34.9 6.9l-4.3-2.2c-9.5-5.7-15.5-16.1-15.5-27.4l0-256 .3-4.8c1.4-9.4 7-17.7 15.1-22.6l4.3-2.2c10.5-4.3 22.3-2.8 31.2 3.8l3.7 3.1 128 128zm-23 22.7c-.1-.3-.3-.7-.7-1.1L96.3 128 96.3 384 224 256.3c0-.1-.1-.2-.1-.2z"]],
    "hexagon-divide": [576, 512, [], "e1ad", ["M61.3 236.2c-7 12.3-7 27.4 0 39.7L157.5 444c7.1 12.4 20.4 20.1 34.7 20.1l191.6 0c4.8 0 9.5-.9 13.9-2.5 7.7-3.3 14.4-8.6 19.5-15.5 .5-.7 .9-1.4 1.4-2.2l96.2-168.1c7-12.3 7-27.4 0-39.7L418.5 68.1C411.4 55.7 398.2 48 383.8 48L192.2 48c-3.7 0-7.3 .5-10.8 1.5-3.5 1.1-6.8 2.5-9.9 4.3-5.7 3.4-10.6 8.3-14 14.3L61.3 236.2zM176 256c0-8.8 7.2-16 16-16l192 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-192 0c-8.8 0-16-7.2-16-16zm136-96a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm0 192a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M61.3 275.9L157.5 444c7.1 12.4 20.4 20.1 34.7 20.1l191.6 0c14.3 0 27.6-7.7 34.7-20.1l96.2-168.1c7-12.3 7-27.4 0-39.7L418.5 68.1C411.4 55.7 398.2 48 383.8 48L192.2 48c-14.3 0-27.6 7.7-34.7 20.1L61.3 236.2c-7 12.3-7 27.4 0 39.7zM33.5 291.8c-12.7-22.2-12.7-49.4 0-71.5L129.7 52.2C142.5 29.8 166.4 16 192.2 16l191.6 0c25.8 0 49.7 13.8 62.5 36.2l96.2 168.1c12.7 22.2 12.7 49.4 0 71.5L446.3 459.9c-12.8 22.4-36.7 36.2-62.5 36.2l-191.6 0c-25.8 0-49.7-13.8-62.5-36.2L33.5 291.8zM288 136a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM192 240l192 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-192 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zm72 112a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"]],
    "florin-sign": [384, 512, [], "e184", ["", "M322.4 32c-32.1 0-61.2 19.2-73.7 48.8L188.2 224 48 224c-8.8 0-16 7.2-16 16s7.2 16 16 16l126.6 0-68.8 162.7C98.3 436.5 80.9 448 61.6 448L16 448c-8.8 0-16 7.2-16 16s7.2 16 16 16l45.6 0c32.1 0 61.2-19.2 73.7-48.8L209.4 256 336 256c8.8 0 16-7.2 16-16s-7.2-16-16-16l-113.1 0 55.3-130.7C285.7 75.5 303.1 64 322.4 64L368 64c8.8 0 16-7.2 16-16s-7.2-16-16-16l-45.6 0z"]],
    "lightbulb-exclamation-on": [640, 512, [], "e1ca", ["M160 192c0 42.7 16.7 81.4 43.9 110.1 19.9 20.9 40.4 48.7 48.5 81.9l135.3 0c8.1-33.2 28.6-61 48.5-81.9 27.2-28.7 43.9-67.4 43.9-110.1 0-88.4-71.6-160-160-160S160 103.6 160 192zm96 224l0 16c0 26.5 21.5 48 48 48l32 0c26.5 0 48-21.5 48-48l0-16-128 0zm88-120a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zM296.6 121.1c-1-13.6 9.8-25.1 23.4-25.1s24.3 11.6 23.4 25.1l-7.4 104c-.6 8.4-7.6 14.9-16 14.9s-15.4-6.5-16-14.9l-7.4-104z", "M320 0c106 0 192 86 192 192 0 51.2-20 97.7-52.7 132.1-23.6 24.9-43.3 55.3-43.3 89.6l0 18.3c0 44.2-35.8 80-80 80l-32 0c-44.2 0-80-35.8-80-80l0-18.3C224 379.4 204.3 349 180.7 324.1 148 289.7 128 243.2 128 192 128 86 214 0 320 0zM256 432c0 26.5 21.5 48 48 48l32 0c26.5 0 48-21.5 48-48l0-16-128 0 0 16zM320 32c-88.4 0-160 71.6-160 160 0 42.7 16.7 81.4 43.9 110.1 19.9 20.9 40.4 48.7 48.5 81.9l135.3 0c8.1-33.2 28.6-61 48.5-81.9 27.2-28.7 43.9-67.4 43.9-110.1 0-88.4-71.6-160-160-160zM71.1 306.7c7.4-4.9 17.3-2.9 22.2 4.4s2.9 17.3-4.4 22.2l-48 32c-7.4 4.9-17.3 2.9-22.2-4.4s-2.9-17.3 4.4-22.2l48-32zm475.6 4.4c4.9-7.4 14.8-9.3 22.2-4.4l48 32c7.4 4.9 9.3 14.8 4.4 22.2s-14.8 9.3-22.2 4.4l-48-32c-7.4-4.9-9.3-14.8-4.4-22.2zM320 320a24 24 0 1 1 0-48 24 24 0 1 1 0 48zm0-224c13.6 0 24.3 11.6 23.4 25.1l-7.4 104c-.6 8.4-7.6 14.9-16 14.9s-15.4-6.5-16-14.9l-7.4-104c-1-13.6 9.8-25.1 23.4-25.1zM64 176c8.8 0 16 7.2 16 16s-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l48 0zm560 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l48 0zM18.7 23.1c4.9-7.4 14.8-9.3 22.2-4.4l48 32c7.4 4.9 9.3 14.8 4.4 22.2s-14.8 9.3-22.2 4.4l-48-32c-7.4-4.9-9.3-14.8-4.4-22.2zm580.4-4.4c7.4-4.9 17.3-2.9 22.2 4.4s2.9 17.3-4.4 22.2l-48 32c-7.4 4.9-17.3 2.9-22.2-4.4s-2.9-17.3 4.4-22.2l48-32z"]],
    "bell": [448, 512, [128276, 61602], "f0f3", ["M32 368.6c0 8.5 6.9 15.4 15.4 15.4l353.2 0c8.5 0 15.4-6.9 15.4-15.4 0-3.5-1.2-6.9-3.4-9.6l-10.1-12.6C369.8 305.5 352 254.7 352 202.3l0-10.3c0-70.7-57.3-128-128-128S96 121.3 96 192l0 10.3c0 52.4-17.8 103.2-50.6 144.1L35.4 359c-2.2 2.7-3.4 6.1-3.4 9.6z", "M224 0c-8.8 0-16 7.2-16 16l0 16.8C127.1 40.8 64 109 64 192l0 10.3c0 45.1-15.4 88.9-43.5 124.1L10.4 339C3.7 347.4 0 357.9 0 368.6 0 394.8 21.2 416 47.4 416l353.2 0c26.2 0 47.4-21.2 47.4-47.4 0-10.8-3.7-21.2-10.4-29.6l-10.1-12.6c-28.2-35.2-43.5-79-43.5-124.1l0-10.3c0-83-63.1-151.2-144-159.2L240 16c0-8.8-7.2-16-16-16zm0 64c70.7 0 128 57.3 128 128l0 10.3c0 52.4 17.8 103.2 50.6 144.1L412.6 359c2.2 2.7 3.4 6.1 3.4 9.6 0 8.5-6.9 15.4-15.4 15.4L47.4 384c-8.5 0-15.4-6.9-15.4-15.4 0-3.5 1.2-6.9 3.4-9.6l10.1-12.6C78.2 305.5 96 254.7 96 202.3L96 192c0-70.7 57.3-128 128-128zM156.1 464c9.9 28 36.6 48 67.9 48s58-20 67.9-48L256 464c-7.3 9.7-18.9 16-32 16s-24.7-6.3-32-16l-35.9 0z"]],
    "hand-back-point-left": [512, 512, [], "e19f", ["M32 168c0 13.3 10.7 24 24 24l157.5 0c7.1 0 13.3 4.6 15.3 11.4s-.6 14-6.5 18c-8.7 5.8-14.3 15.6-14.3 26.7 0 15.6 11.2 28.6 25.9 31.4 5.1 1 9.5 4.4 11.6 9.2s1.8 10.3-.9 14.8c-2.9 4.8-4.6 10.5-4.6 16.6 0 14.7 10 27.2 23.6 30.9 4.4 1.2 8.1 4.2 10.1 8.3s2.2 8.8 .6 13.1c-1.4 3.6-2.2 7.6-2.2 11.8 0 17.7 14.3 32 32 32l96 0c44.2 0 80-35.8 80-80l0-135.7c0-18.5-4.6-36.8-13.4-53.1l-4.5-8.3C442.6 102.6 404.7 80 363.5 80L344 80c-15.1 0-29.3 7.1-38.4 19.2l-9.6 12.8 48 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L56 144c-13.3 0-24 10.7-24 24z", "M0 168c0-30.9 25.1-56 56-56l200.6 0c2-3.2 4.2-6.4 6.5-9.5L280 80c15.1-20.1 38.8-32 64-32l19.5 0c53 0 101.7 29.1 126.8 75.7l4.5 8.3c11.3 21 17.2 44.4 17.2 68.3L512 336c0 61.9-50.1 112-112 112l-96 0c-35.3 0-64-28.7-64-64 0-2.8 .2-5.6 .5-8.3-19.4-11-32.5-31.8-32.5-55.7 0-5.3 .7-10.5 1.9-15.5-20.2-10.8-33.9-32-33.9-56.5 0-8.5 1.7-16.6 4.7-24L56 224c-30.9 0-56-25.1-56-56zm56-24c-13.3 0-24 10.7-24 24s10.7 24 24 24l157.5 0c7.1 0 13.3 4.6 15.3 11.4s-.6 14-6.5 18c-8.7 5.8-14.3 15.6-14.3 26.7 0 15.6 11.2 28.6 25.9 31.4 5.1 1 9.5 4.4 11.6 9.2s1.8 10.3-.9 14.8c-2.9 4.8-4.6 10.5-4.6 16.6 0 14.7 10 27.2 23.6 30.9 4.4 1.2 8.1 4.2 10.1 8.3s2.2 8.8 .6 13.1c-1.4 3.6-2.2 7.6-2.2 11.8 0 17.7 14.3 32 32 32l96 0c44.2 0 80-35.8 80-80l0-135.7c0-18.5-4.6-36.8-13.4-53.1l0 0-4.5-8.3C442.6 102.6 404.7 80 363.5 80L344 80c-15.1 0-29.3 7.1-38.4 19.2l-9.6 12.8 48 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L56 144z"]],
    "lari-sign": [384, 512, [], "e1c8", ["", "M144 0c8.8 0 16 7.2 16 16l0 50.7c10.4-1.7 21.1-2.7 32-2.7s21.6 .9 32 2.7L224 16c0-8.8 7.2-16 16-16s16 7.2 16 16l0 58.9c62.8 22.2 110.7 76.2 124.2 142.7 1.8 8.7-3.8 17.1-12.5 18.9s-17.1-3.8-18.9-12.5c-10.5-51.6-45.7-94.1-92.8-114.7L256 240c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-140.8c-10.3-2.1-21-3.2-32-3.2s-21.7 1.1-32 3.2L160 240c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-130.7C71.5 134 32 190.4 32 256 32 344.4 103.6 416 192 416l176 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L16 448c-8.8 0-16-7.2-16-16s7.2-16 16-16l69.8 0C34.1 381.6 0 322.8 0 256 0 172.4 53.4 101.3 128 74.9L128 16c0-8.8 7.2-16 16-16z"]],
    "rectangle-plus": [512, 512, [], "e6b5", ["M32 128l0 256c0 17.7 14.3 32 32 32l384 0c17.7 0 32-14.3 32-32l0-256c0-17.7-14.3-32-32-32L64 96c-17.7 0-32 14.3-32 32zM144 256c0-8.8 7.2-16 16-16l80 0 0-80c0-8.8 7.2-16 16-16s16 7.2 16 16l0 80 80 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-80 0 0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80-80 0c-8.8 0-16-7.2-16-16z", "M64 96c-17.7 0-32 14.3-32 32l0 256c0 17.7 14.3 32 32 32l384 0c17.7 0 32-14.3 32-32l0-256c0-17.7-14.3-32-32-32L64 96zM0 128C0 92.7 28.7 64 64 64l384 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64L64 448c-35.3 0-64-28.7-64-64L0 128zM240 352l0-80-80 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l80 0 0-80c0-8.8 7.2-16 16-16s16 7.2 16 16l0 80 80 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-80 0 0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16z"]],
    "cucumber": [512, 512, [129362], "e401", ["M60.6 316.1c-37.5 37.5-37.5 98.3 0 135.8s98.3 37.5 135.8 0l256-256c37.5-37.5 37.5-98.3 0-135.8s-98.3-37.5-135.8 0l-256 256zM168.5 308a20 20 0 1 1 -40 0 20 20 0 1 1 40 0zm184-64a20 20 0 1 1 -40 0 20 20 0 1 1 40 0zm32-128a20 20 0 1 1 -40 0 20 20 0 1 1 40 0z", "M196.4 451.9l256-256c37.5-37.5 37.5-98.3 0-135.8s-98.3-37.5-135.8 0l-256 256c-37.5 37.5-37.5 98.3 0 135.8s98.3 37.5 135.8 0zm21.8 23.4c-50 49.2-130.5 48.9-180.2-.8-50-50-50-131 0-181l95.2-95.2c-7-9.4-6.2-22.7 2.3-31.2s21.9-9.3 31.2-2.3L294 37.5c50-50 131-50 181 0 49.7 49.7 50 130.2 .8 180.2 7 9.4 6.2 22.7-2.3 31.3s-21.8 9.3-31.2 2.3L251.8 441.7c7 9.4 6.2 22.7-2.3 31.2s-21.9 9.3-31.3 2.3zM128.5 308a20 20 0 1 1 40 0 20 20 0 1 1 -40 0zm204-84a20 20 0 1 1 0 40 20 20 0 1 1 0-40zm12-108a20 20 0 1 1 40 0 20 20 0 1 1 -40 0z"]],
    "seal": [512, 512, [], "e241", ["", "M32.2 336.5c-3.4 8.2 .5 17.5 8.7 20.9l56 23.2c15.7 6.5 28.1 19 34.6 34.6l23.2 56c3.4 8.2 12.7 12 20.9 8.7l56-23.2c15.7-6.5 33.3-6.5 49 0l56 23.2c8.2 3.4 17.5-.5 20.9-8.7l23.2-56c6.5-15.7 19-28.1 34.6-34.6l56-23.2c8.2-3.4 12-12.7 8.7-20.9l-23.2-56c-6.5-15.7-6.5-33.3 0-49l23.2-56c3.4-8.2-.5-17.5-8.7-20.9l-56-23.2c-15.7-6.5-28.1-19-34.6-34.6l-23.2-56c-3.4-8.2-12.7-12-20.9-8.7l-56 23.2c-15.7 6.5-33.3 6.5-49 0l-56-23.2c-8.2-3.4-17.5 .5-20.9 8.7l-23.2 56c-6.5 15.7-19 28.1-34.6 34.6l-56 23.2c-8.2 3.4-12 12.7-8.7 20.9l23.2 56c6.5 15.7 6.5 33.3 0 49l-23.2 56zm-3.6 50.5c-24.5-10.1-36.1-38.2-26-62.7l23.2-56c3.2-7.8 3.2-16.6 0-24.5l-23.2-56c-10.1-24.5 1.5-52.6 26-62.7l56-23.2c7.8-3.2 14.1-9.5 17.3-17.3l23.2-56c10.1-24.5 38.2-36.1 62.7-26l56 23.2c7.8 3.2 16.7 3.2 24.5 0l56-23.2c24.5-10.1 52.6 1.5 62.7 26l23.2 56c3.2 7.8 9.5 14.1 17.3 17.3l56 23.2c24.5 10.1 36.1 38.2 26 62.7l-23.2 56c-3.2 7.8-3.2 16.7 0 24.5l23.2 56c10.1 24.5-1.5 52.6-26 62.7l-56 23.2c-7.8 3.2-14.1 9.5-17.3 17.3l-23.2 56c-10.1 24.5-38.2 36.1-62.7 26l-56-23.2c-7.8-3.2-16.7-3.2-24.5 0l-56 23.2c-24.5 10.1-52.6-1.5-62.7-26l-23.2-56c-3.2-7.8-9.5-14.1-17.3-17.3l-56-23.2z"]],
    "circle-caret-down": [512, 512, ["caret-circle-down"], "f32d", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm96-36.5c0-15.2 12.3-27.5 27.5-27.5l201 0c15.2 0 27.5 12.3 27.5 27.5 0 6.9-2.6 13.6-7.3 18.7L281.2 341c-6.5 7-15.6 11-25.2 11s-18.7-4-25.2-11L135.3 238.2c-4.7-5.1-7.3-11.8-7.3-18.7z", "M256 480a224 224 0 1 1 0-448 224 224 0 1 1 0 448zM256 0a256 256 0 1 0 0 512 256 256 0 1 0 0-512zm0 352c9.6 0 18.7-4 25.2-11l95.5-102.8c4.7-5.1 7.3-11.8 7.3-18.7 0-15.2-12.3-27.5-27.5-27.5l-201 0c-15.2 0-27.5 12.3-27.5 27.5 0 6.9 2.6 13.6 7.3 18.7L230.8 341c6.5 7 15.6 11 25.2 11zm1.7-32.7c-.4 .5-1.1 .7-1.7 .7s-1.3-.3-1.7-.7l-88.4-95.3 180.3 0-88.4 95.3z"]],
    "mill-sign": [384, 512, [], "e1ed", ["", "M302.8 6c3.3-8.2-.6-17.5-8.8-20.8s-17.5 .6-20.8 8.8L233.9 90.8c-17.2 8.5-31.7 21.7-41.9 37.8-18.4-29.2-50.9-48.5-88-48.5-27.9 0-53.3 11-72 29l0-13c0-8.8-7.2-16-16-16S0 87.2 0 96l0 80 .3 0c-.2 2.6-.3 5.3-.3 8L0 416c0 8.8 7.2 16 16 16s16-7.2 16-16l0-232c0-39.8 32.2-72 72-72s72 32.2 72 72L176 233.2 65.2 506c-3.3 8.2 .6 17.5 8.8 20.8s17.5-.6 20.8-8.8L176 318.2 176 416c0 8.8 7.2 16 16 16s16-7.2 16-16l0-176.6 50.4-124.2c6.8-2.1 14.1-3.3 21.6-3.3 39.8 0 72 32.2 72 72l0 232c0 8.8 7.2 16 16 16s16-7.2 16-16l0-232c0-57.4-46.6-104-104-104-2.5 0-4.9 .1-7.3 .3L302.8 6z"]],
    "mug-tea-saucer": [576, 512, [], "e1f5", ["M96 64l0 240c0 34.2 26.8 62.1 60.6 63.9 1.1 0 2.3 .1 3.4 .1l192 0c1.2 0 2.3 0 3.4-.1 33.7-1.8 60.6-29.7 60.6-63.9l0-240-192 0 0 40.5 36.5 30.4C267.8 141 272 150 272 159.5l0 64.5c0 17.7-14.3 32-32 32l-64 0c-17.3 0-31.4-13.7-32-30.8 0-.4 0-.8 0-1.2l0-64.5c0-.4 0-.8 0-1.2 .3-9 4.5-17.5 11.5-23.4l36.5-30.4 0-40.5-96 0z", "M224 64l0 40.5 36.5 30.4C267.8 141 272 150 272 159.5l0 64.5c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-64.5c0-9.5 4.2-18.5 11.5-24.6l36.5-30.4 0-40.5-96 0 0 240c0 35.3 28.7 64 64 64l192 0c35.3 0 64-28.7 64-64l0-240-192 0zm224 0l0 160 16 0c44.2 0 80-35.8 80-80s-35.8-80-80-80l-16 0zm0 192l0 48c0 53-43 96-96 96l-192 0c-53 0-96-43-96-96L64 64c0-17.7 14.3-32 32-32l368 0c61.9 0 112 50.1 112 112S525.9 256 464 256l-16 0zM32 496c0-8.8 7.2-16 16-16l416 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L48 512c-8.8 0-16-7.2-16-16zM176 159.5l0 64.5 64 0 0-64.5-32-26.7-32 26.7z"]],
    "cart-circle-check": [640, 512, [], "e3f1", ["M113 64l417.3 0c5.1 0 8.9 4.7 7.8 9.7L509.3 208.5c-4.4-.3-8.8-.5-13.3-.5-48.7 0-93.2 18.1-127 48L147.9 256 113 64zM228 460a20 20 0 1 1 -40 0 20 20 0 1 1 40 0z", "M16 0C7.2 0 0 7.2 0 16S7.2 32 16 32l45.3 0C69 32 75.7 37.5 77 45.1l50.9 279.7c6.2 34.2 36 59.1 70.8 59.1l105.9 0c.9-11 2.7-21.6 5.4-32l-111.3 0c-19.3 0-35.9-13.8-39.4-32.8L153.7 288 340 288c8.4-11.7 18.2-22.5 29-32L147.9 256 113 64 530.3 64c5.1 0 8.9 4.7 7.8 9.7L509.3 208.5c10.8 .7 21.4 2.4 31.7 4.8L569.4 80.4C574.8 55.5 555.8 32 530.3 32L106.6 32C99.9 13.1 81.9 0 61.3 0L16 0zM188 460a20 20 0 1 1 40 0 20 20 0 1 1 -40 0zm72 0a52 52 0 1 0 -104 0 52 52 0 1 0 104 0zM496 288a112 112 0 1 1 0 224 112 112 0 1 1 0-224zm0 256a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm57.4-204.9c-7.1-5.2-17.2-3.6-22.4 3.5l-53 72.9-26.8-26.8c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l40 40c3.3 3.3 7.9 5 12.6 4.6s8.9-2.8 11.7-6.5l64-88c5.2-7.1 3.6-17.2-3.5-22.4z"]],
    "album": [448, 512, [128189], "f89f", ["M32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64C46.3 64 32 78.3 32 96zM384 256a160 160 0 1 1 -320 0 160 160 0 1 1 320 0z", "M384 64c17.7 0 32 14.3 32 32l0 320c0 17.7-14.3 32-32 32L64 448c-17.7 0-32-14.3-32-32L32 96c0-17.7 14.3-32 32-32l320 0zM64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm160 96a128 128 0 1 1 0 256 128 128 0 1 1 0-256zm0 288a160 160 0 1 0 0-320 160 160 0 1 0 0 320zm0-136a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]],
    "left-to-line": [512, 512, ["arrow-alt-to-left"], "f34b", ["M163.3 256L288 380.7 288 304c0-8.8 7.2-16 16-16l160 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16-53.3 0-106.7 0-160 0-8.8 0-16-7.2-16-16l0-76.7-124.7 124.7z", "M16 448c8.8 0 16-7.2 16-16L32 80c0-8.8-7.2-16-16-16S0 71.2 0 80L0 432c0 8.8 7.2 16 16 16zM135 239c-9.4 9.4-9.4 24.6 0 33.9L279 417c6.9 6.9 17.2 8.9 26.2 5.2S320 409.7 320 400l0-80 144 0c26.5 0 48-21.5 48-48l0-32c0-26.5-21.5-48-48-48l-80 0 0 0-64 0 0-80c0-9.7-5.8-18.5-14.8-22.2S285.9 88.2 279 95L135 239zm249-15l0 0 80 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-160 0c-8.8 0-16 7.2-16 16L288 380.7 163.3 256 288 131.3 288 208c0 8.8 7.2 16 16 16l80 0z"]],
    "person-snowboarding": [576, 512, [127938, "snowboarding"], "f7ce", ["M232.1 242.2c.7 .4 1.5 .9 2.2 1.5l32.9 27.4 86-73.8-38.7-27.3-82.4 72.1zM400 72a24 24 0 1 0 48 0 24 24 0 1 0 -48 0z", "M448 72a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm-80 0a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zM178.9 54.8c5.1-7.2 15.1-8.9 22.3-3.8l272 192c7.2 5.1 8.9 15.1 3.8 22.3s-15.1 8.9-22.3 3.8l-74.6-52.7-88.1 75.5 20.9 17.4c14.6 12.2 23 30.2 23 49.2l0 92.9 92 18c7.4 1.5 15.1 1.1 22.4-1l41.2-11.8c8.5-2.4 17.4 2.5 19.8 11s-2.5 17.4-11 19.8l-41.2 11.8c-12.1 3.5-24.9 4-37.3 1.6L88.1 435.4c-15.6-3.1-30-10.7-41.2-21.9L20.7 387.3c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l26.2 26.2c6.7 6.7 15.4 11.3 24.7 13.2l81.8 16 0-135c0-23.1 10-45 27.3-60.2l84.3-73.8-104.8-74c-7.2-5.1-8.9-15.1-3.8-22.3zM208 426.3l96 18.8 0-86.6c0-9.5-4.2-18.5-11.5-24.6l-78.7-65.6c-.7-.6-1.4-1.3-2-1.9-2.5 5.8-3.8 12.2-3.8 18.7l0 141.3zm145.2-229l-38.7-27.3-82.4 72.1c.7 .4 1.5 .9 2.2 1.5l32.9 27.4 86-73.8z"]],
    "tty": [512, 512, ["teletype"], "f1e4", ["M48.1 241.6c2.4 4.2 7.6 6 12.1 4.1l79-32.5c4-1.6 6.4-5.7 5.9-9.9l-3.8-37.9c-1.5-15.1 7.8-29.2 22.3-33.7 60.6-18.9 126-17.7 186 3.3 13.9 4.9 22.7 18.7 21.2 33.4l-3.5 34.9c-.4 4.3 2 8.3 5.9 9.9l79 32.5c4.5 1.9 9.7 .1 12.1-4.1 25.6-44.9 18.5-96.6-19.4-121.4-114.3-74.9-263.2-74.9-377.5 0-37.9 24.8-45 76.6-19.4 121.4z", "M151.3 242.8l-79 32.5c-19.4 8-41.7 .3-52.1-17.9-31.2-54.6-26.7-127.2 29.6-164.1 124.9-81.9 287.6-81.9 412.5 0 56.3 36.9 60.9 109.4 29.6 164.1-10.4 18.2-32.7 25.8-52.1 17.9l-79-32.5c-17-7-27.4-24.4-25.6-42.7l3.5-34.9c-53.5-18.8-111.9-19.8-165.9-3l3.8 37.9c1.8 18.3-8.6 35.7-25.6 42.7zm-10-77.4c-1.5-15.1 7.8-29.2 22.3-33.7 60.6-18.9 126-17.7 186 3.3 13.9 4.9 22.7 18.7 21.2 33.4l-3.5 34.9c-.4 4.3 2 8.3 5.9 9.9l79 32.5c4.5 1.9 9.7 .1 12.1-4.1 25.6-44.9 18.5-96.6-19.4-121.4-114.3-74.9-263.2-74.9-377.5 0-37.9 24.8-45 76.6-19.4 121.4 2.4 4.2 7.6 6 12.1 4.1l79-32.5c4-1.6 6.4-5.7 5.9-9.9l-3.8-37.9zM88.2 352a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm96 0a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zM64.2 472a24 24 0 1 1 0-48 24 24 0 1 1 0 48zm408-24a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm-216-72a24 24 0 1 1 0-48 24 24 0 1 1 0 48zm120-24a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm72 24a24 24 0 1 1 0-48 24 24 0 1 1 0 48zm-320 72c0-8.8 7.2-16 16-16l224 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-224 0c-8.8 0-16-7.2-16-16z"]],
    "slider-circle": [576, 512, [], "e750", ["M256 256a96 96 0 1 0 192 0 96 96 0 1 0 -192 0z", "M448 256a96 96 0 1 0 -192 0 96 96 0 1 0 192 0zm31 16c-7.9 63.1-61.7 112-127 112-70.7 0-128-57.3-128-128s57.3-128 128-128c65.3 0 119.1 48.9 127 112l81 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-81 0zM176.7 240c-.5 5.3-.7 10.6-.7 16s.2 10.7 .7 16L16 272c-8.8 0-16-7.2-16-16s7.2-16 16-16l160.7 0z"]],
    "users-rectangle": [576, 512, [], "e594", ["M176 416c8.8 0 16-7.2 16-16l0-8c0-39.8 32.2-72 72-72l48 0c39.8 0 72 32.2 72 72l0 8c0 8.8 7.2 16 16 16l-224 0zM336 160a48 48 0 1 1 -96 0 48 48 0 1 1 96 0z", "M64 32C46.3 32 32 46.3 32 64l0 384c0 17.7 14.3 32 32 32l448 0c17.7 0 32-14.3 32-32l0-384c0-17.7-14.3-32-32-32L64 32zM0 64C0 28.7 28.7 0 64 0L512 0c35.3 0 64 28.7 64 64l0 384c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zM288 208a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm0-128a80 80 0 1 1 0 160 80 80 0 1 1 0-160zM144 184c0 19.6 14.1 35.9 32.7 39.3 6.5 11.4 14.7 21.7 24.3 30.6-5.5 1.3-11.2 2-17.1 2-39.8 0-72-32.2-72-72 0-34.5 24.3-63.3 56.7-70.4-4.6 12-7.6 24.8-8.4 38.2-9.9 7.3-16.3 19-16.3 32.2zm248 72c-5.9 0-11.6-.7-17.1-2 9.6-8.9 17.8-19.2 24.3-30.6 18.6-3.4 32.7-19.7 32.7-39.3 0-13.2-6.4-24.9-16.3-32.2-.8-13.4-3.7-26.2-8.4-38.2 32.4 7 56.7 35.9 56.7 70.4 0 39.8-32.2 72-72 72zM149.3 293.9c-21.6 25.1-35.2 57.2-37.1 92.4-.1 1.9-.2 3.8-.2 5.7l0 8c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-8c0-45.3 28.9-83.8 69.3-98.1zm314.5 92.4c-1.9-35.2-15.5-67.3-37.1-92.4 40.4 14.3 69.3 52.8 69.3 98.1l0 8c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-8c0-1.9-.1-3.8-.2-5.7zM264 288l48 0c57.4 0 104 46.6 104 104l0 8c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-8c0-39.8-32.2-72-72-72l-48 0c-39.8 0-72 32.2-72 72l0 8c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-8c0-57.4 46.6-104 104-104z"]],
    "mobile": [384, 512, [128241, "mobile-android", "mobile-phone"], "f3ce", ["M48 64c0-17.7 14.3-32 32-32l224 0c17.7 0 32 14.3 32 32l0 384c0 17.7-14.3 32-32 32L80 480c-17.7 0-32-14.3-32-32L48 64zm96 352c0 8.8 7.2 16 16 16l64 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-64 0c-8.8 0-16 7.2-16 16z", "M80 32C62.3 32 48 46.3 48 64l0 384c0 17.7 14.3 32 32 32l224 0c17.7 0 32-14.3 32-32l0-384c0-17.7-14.3-32-32-32L80 32zM16 64C16 28.7 44.7 0 80 0L304 0c35.3 0 64 28.7 64 64l0 384c0 35.3-28.7 64-64 64L80 512c-35.3 0-64-28.7-64-64L16 64zM160 400l64 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-64 0c-8.8 0-16-7.2-16-16s7.2-16 16-16z"]],
    "arrows-turn-to-dots": [448, 512, [], "e4c1", ["M96 96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM416 368a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M260.7 4.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6L230.6 80 352 80c53 0 96 43 96 96l0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-32c0-35.3-28.7-64-64-64l-121.4 0 52.7 52.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-80-80c-6.2-6.2-6.2-16.4 0-22.6l80-80zm-73.4 272l80 80c6.2 6.2 6.2 16.4 0 22.6l-80 80c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6L217.4 384 96 384c-35.3 0-64 28.7-64 64l0 32c0 8.8-7.2 16-16 16S0 488.8 0 480l0-32c0-53 43-96 96-96l121.4 0-52.7-52.7c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0zM384 400a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm0-96a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM32 96a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm96 0A64 64 0 1 1 0 96 64 64 0 1 1 128 96z"]],
    "exclamation": [64, 512, [10069, 10071, 61738], "21", ["", "M32 464c13.3 0 24 10.7 24 24s-10.7 24-24 24-24-10.7-24-24 10.7-24 24-24zM32 0C45.4 0 56.1 11 55.8 24.4L48 368.4c-.2 8.7-7.3 15.6-16 15.6s-15.8-6.9-16-15.6L8.2 24.4C7.9 11 18.6 0 32 0z"]],
    "location-xmark": [384, 512, ["map-marker-times", "map-marker-xmark"], "f60e", ["M32 188.6C32 102.6 103.1 32 192 32s160 70.6 160 156.6c0 50.3-25.9 109.4-61.4 165.6-34 53.8-74 100.5-98.6 127.4-24.6-26.9-64.6-73.7-98.6-127.4-35.5-56.2-61.4-115.3-61.4-165.6zm92.7-63.9c-6.2 6.2-6.2 16.4 0 22.6l44.7 44.7-44.7 44.7c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l44.7-44.7 44.7 44.7c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-44.7-44.7 44.7-44.7c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-44.7 44.7-44.7-44.7c-6.2-6.2-16.4-6.2-22.6 0z", "M32 188.6C32 102.6 103.1 32 192 32s160 70.6 160 156.6c0 50.3-25.9 109.4-61.4 165.6-34 53.8-74 100.5-98.6 127.4-24.6-26.9-64.6-73.7-98.6-127.4-35.5-56.2-61.4-115.3-61.4-165.6zM192 0C86 0 0 84.4 0 188.6 0 307.9 120.2 450.9 170.4 505.4 182.2 518.2 201.8 518.2 213.6 505.4 263.8 450.9 384 307.9 384 188.6 384 84.4 298 0 192 0zM124.7 124.7c-6.2 6.2-6.2 16.4 0 22.6l44.7 44.7-44.7 44.7c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l44.7-44.7 44.7 44.7c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-44.7-44.7 44.7-44.7c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-44.7 44.7-44.7-44.7c-6.2-6.2-16.4-6.2-22.6 0z"]],
    "church": [512, 512, [9962], "f51d", ["M32 328.7L32 456c0 13.3 10.7 24 24 24l40 0 0-198.1-50.7 25.4C37.1 311.3 32 319.6 32 328.7zm96-110.8l0 262.1 64 0 0-96c0-35.3 28.7-64 64-64s64 28.7 64 64l0 96 64 0 0-262.1c0-5.6-2.9-10.7-7.7-13.7L256 130.8 135.7 204.3c-4.8 2.9-7.7 8.1-7.7 13.7zm288 63.9l0 198.1 40 0c13.3 0 24-10.7 24-24l0-127.3c0-9.1-5.1-17.4-13.3-21.5L416 281.9z", "M256-32c8.8 0 16 7.2 16 16l0 32 40 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-40 0 0 55 121 74c14.3 8.7 23 24.2 23 41l0 28.2 65 32.5c19 9.5 31 28.9 31 50.1L512 456c0 30.9-25.1 56-56 56L56 512c-30.9 0-56-25.1-56-56L0 328.7c0-21.2 12-40.6 31-50.1l65-32.5 0-28.2c0-16.7 8.7-32.2 23-41l121-74 0-55-40 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l40 0 0-32c0-8.8 7.2-16 16-16zM416 480l40 0c13.3 0 24-10.7 24-24l0-127.3c0-9.1-5.1-17.4-13.3-21.5L416 281.9 416 480zm-32 0l0-262.1c0-5.6-2.9-10.7-7.7-13.7L256 130.8 135.7 204.3c-4.8 2.9-7.7 8.1-7.7 13.7l0 262.1 64 0 0-96c0-35.3 28.7-64 64-64s64 28.7 64 64l0 96 64 0zM45.3 307.3C37.1 311.3 32 319.6 32 328.7L32 456c0 13.3 10.7 24 24 24l40 0 0-198.1-50.7 25.4zM288 480l0-96c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 96 64 0z"]],
    "toggle-off": [576, 512, [], "f204", ["M224 256a64 64 0 1 1 -128 0 64 64 0 1 1 128 0z", "M416 128c70.7 0 128 57.3 128 128S486.7 384 416 384l-256 0C89.3 384 32 326.7 32 256S89.3 128 160 128l256 0zM576 256c0-88.4-71.6-160-160-160L160 96C71.6 96 0 167.6 0 256S71.6 416 160 416l256 0c88.4 0 160-71.6 160-160zm-352 0a64 64 0 1 1 -128 0 64 64 0 1 1 128 0zM64 256a96 96 0 1 0 192 0 96 96 0 1 0 -192 0z"]],
    "face-nauseated": [512, 512, [], "e381", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm65.7-88.8c-4-7.9-.7-17.5 7.2-21.5l64-32c7.9-4 17.5-.7 21.5 7.2s.7 17.5-7.2 21.5l-64 32c-7.9 4-17.5 .7-21.5-7.2zm48.5 105.4c4.4-7.6 14.2-10.3 21.9-5.8 19.5 11.3 33.8 30.5 38.4 53.3l99.2 0c4.6-22.8 18.9-42 38.4-53.3 7.7-4.4 17.4-1.8 21.9 5.8s1.8 17.4-5.8 21.9c-14.4 8.3-24 23.8-24 41.6s9.6 33.3 24 41.6c7.6 4.4 10.3 14.2 5.8 21.9s-14.2 10.3-21.9 5.8c-19.5-11.3-33.8-30.5-38.4-53.3l-99.2 0c-4.6 22.8-18.9 42-38.4 53.3-7.6 4.4-17.4 1.8-21.9-5.8s-1.8-17.4 5.8-21.9c14.4-8.3 24-23.8 24-41.6s-9.6-33.3-24-41.6c-7.6-4.4-10.3-14.2-5.8-21.9zM200 208a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm160 0a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm-38.3-87.2c4-7.9 13.6-11.1 21.5-7.2l64 32c7.9 4 11.1 13.6 7.2 21.5s-13.6 11.1-21.5 7.2l-64-32c-7.9-4-11.1-13.6-7.2-21.5z", "M480 256a224 224 0 1 0 -448 0 224 224 0 1 0 448 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm168 10.7c19.5 11.3 33.8 30.5 38.4 53.3l99.2 0c4.6-22.8 18.9-42 38.4-53.3 7.7-4.4 17.4-1.8 21.9 5.8s1.8 17.4-5.8 21.9c-14.4 8.3-24 23.8-24 41.6s9.6 33.3 24 41.6c7.6 4.4 10.3 14.2 5.8 21.9s-14.2 10.3-21.9 5.8c-19.5-11.3-33.8-30.5-38.4-53.3l-99.2 0c-4.6 22.8-18.9 42-38.4 53.3-7.6 4.4-17.4 1.8-21.9-5.8s-1.8-17.4 5.8-21.9c14.4-8.3 24-23.8 24-41.6s-9.6-33.3-24-41.6c-7.6-4.4-10.3-14.2-5.8-21.9s14.2-10.3 21.9-5.8zM336 184a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM200 208a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm-16.8-65.7l-64 32c-7.9 4-17.5 .7-21.5-7.2s-.7-17.5 7.2-21.5l64-32c7.9-4 17.5-.7 21.5 7.2s.7 17.5-7.2 21.5zm138.5-21.5c4-7.9 13.6-11.1 21.5-7.2l64 32c7.9 4 11.1 13.6 7.2 21.5s-13.6 11.1-21.5 7.2l-64-32c-7.9-4-11.1-13.6-7.2-21.5z"]],
    "deer": [512, 512, [129420], "f78e", ["M48 264l0 4.1c0 8.5 3.4 16.6 9.4 22.6l3.9 3.9c12 12 18.7 28.3 18.7 45.3l0 4.3c0 6.9-1.1 13.7-3.3 20.2l-8.5 25.4c-2.2 6.6-2.2 13.7 0 20.2l21.5 64.4c1.1 3.3 4.1 5.5 7.6 5.5l29.4 0c5.5 0 9.3-5.4 7.6-10.5l-11.6-34.8c-8.1-24.3 1.1-51.1 22.4-65.3 8.2-5.4 12.4-15.1 10.8-24.8l-3.7-21.9c-1-6.3 1.7-12.6 7.1-16.1s12.3-3.4 17.6 .1l13.7 9.2C210.3 329 233.5 336 257.2 336l30.8 0c8.8 0 16 7.2 16 16l0 120c0 4.4 3.6 8 8 8l32 0c4.4 0 8-3.6 8-8l0-161c0-6.2 .9-12.4 2.7-18.4l22-73.3c2-6.8 8.3-11.4 15.3-11.4l64.4 0c13 0 23.6-10.6 23.6-23.6 0-6.3-2.5-12.3-6.9-16.7l-60.4-60.4c-7.2-7.2-17-11.3-27.2-11.3-17.3 0-32.5 11.5-37.1 28.2l-20 72.1c-1.9 6.9-8.2 11.7-15.4 11.7L104 208c-30.9 0-56 25.1-56 56zM416 144a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M256 16c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 24c0 30.9 25.1 56 56 56l39.2 0-40 26.7c-7.4 4.9-9.3 14.8-4.4 22.2s14.8 9.3 22.2 4.4l13.8-9.2-10 35.9-201.6 0c-50.7 0-92.7 39.4-95.8 90L0 319c-.6 8.8 6.2 16.4 15 17s16.4-6.2 17-15l.6-9.9c.7 .8 1.4 1.5 2.2 2.3l3.9 3.9c6 6 9.4 14.1 9.4 22.6l0 4.3c0 3.4-.6 6.9-1.6 10.1l-8.5 25.4c-4.4 13.1-4.4 27.3 0 40.5l21.5 64.4C64.8 501 80.1 512 97.3 512l29.4 0c27.3 0 46.6-26.7 37.9-52.6l-11.6-34.8c-3.6-10.7 .5-22.4 9.8-28.6 15.2-10.1 24.4-26.8 25.3-44.6 21.3 10.9 45 16.6 69 16.6l14.8 0 0 104c0 22.1 17.9 40 40 40l32 0c22.1 0 40-17.9 40-40l0-161c0-3.1 .5-6.2 1.4-9.2l18.6-61.8 52.5 0c30.7 0 55.6-24.9 55.6-55.6 0-14.7-5.9-28.9-16.3-39.3L440.8 90.2C459.3 81.1 472 62 472 40l0-24c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 24c0 13.3-10.7 24-24 24l-69.4 0c3.5-7.3 5.4-15.4 5.4-24l0-24c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 24c0 13.3-10.7 24-24 24l-16 0c-13.3 0-24-10.7-24-24l0-24zM385.4 96c10.2 0 20 4.1 27.2 11.3l60.4 60.4c4.4 4.4 6.9 10.4 6.9 16.7 0 13-10.6 23.6-23.6 23.6L392 208c-7.1 0-13.3 4.6-15.3 11.4l-22 73.3c-1.8 6-2.7 12.2-2.7 18.4l0 161c0 4.4-3.6 8-8 8l-32 0c-4.4 0-8-3.6-8-8l0-120c0-8.8-7.2-16-16-16l-30.8 0c-23.7 0-46.9-7-66.6-20.2l-13.7-9.2c-5.3-3.5-12.2-3.6-17.6-.1s-8.1 9.8-7.1 16.1l3.7 21.9c1.6 9.7-2.6 19.4-10.8 24.8-21.4 14.2-30.5 41-22.4 65.3l11.6 34.8c1.7 5.2-2.1 10.5-7.6 10.5l-29.4 0c-3.4 0-6.5-2.2-7.6-5.5L68.2 410.1c-2.2-6.6-2.2-13.7 0-20.2l8.5-25.4c2.2-6.5 3.3-13.4 3.3-20.2l0-4.3c0-17-6.7-33.3-18.7-45.3l-3.9-3.9c-6-6-9.4-14.1-9.4-22.6l0-4.1c0-30.9 25.1-56 56-56l208.9 0c7.2 0 13.5-4.8 15.4-11.7l20-72.1C353 107.5 368.1 96 385.4 96zM416 144a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"]],
    "box-open-full": [576, 512, ["box-full"], "f49c", ["M80 295l0 51.9c0 17.2 9.2 33.1 24.2 41.7l160 91.4c2.5 1.4 5.2 2.6 7.8 3.6l0-149.6-10.2 23.9c-7.5 17.6-28.7 24.7-45.3 15.2L80 295zm224-29.7l0 218.3c2.7-1 5.3-2.1 7.8-3.6l160-91.4c15-8.5 24.2-24.5 24.2-41.7L496 155.6 304 265.3z", "M320 128c0-53-43-96-96-96-41.2 0-76.3 25.9-89.9 62.3L106 78.3C125.4 32.3 170.9 0 224 0 262.9 0 297.7 17.3 321.2 44.7 326.4 19.2 349 0 376 0l48 0c30.9 0 56 25.1 56 56l0 16.6-32 18.3 0-34.9c0-13.3-10.7-24-24-24l-48 0c-13.3 0-24 10.7-24 24l0 72c0 6.3-.5 12.4-1.3 18.5l-40 22.9c6-12.5 9.3-26.5 9.3-41.3zM216.5 373L80 295 80 346.9c0 17.2 9.2 33.1 24.2 41.7l160 91.4c2.5 1.4 5.2 2.6 7.8 3.6l0-149.6-10.2 23.9c-7.5 17.6-28.7 24.7-45.3 15.2zM304 483.6c2.7-1 5.3-2.1 7.8-3.6l160-91.4c15-8.5 24.2-24.5 24.2-41.7l0-191.3-192.1 109.7 0 218.3zM546.3 216.2l-18.3-30.5 0 161.1c0 28.7-15.4 55.2-40.3 69.4l-160 91.4c-24.6 14-54.8 14-79.4 0l-160-91.4C63.4 402.1 48 375.6 48 346.9l0-70.1-27.6-15.8C6.3 252.9 .5 235.5 6.9 220.6l42.4-98.9c1.8-4.2 5.3-7.4 9.6-8.9s9.1-1 13 1.3L288 237.6 504.1 114.1c7.6-4.3 17.2-1.8 21.7 5.7l48 80c4.5 7.6 2.1 17.4-5.5 22s-17.4 2.1-21.9-5.5zM267.7 262.8l-196-112-35.3 82.4 196 112 35.3-82.4z"]],
    "cherries": [576, 512, [], "e0ec", ["M32 304c0 77 69 144 160 144s160-67 160-144c0-44.2-35.8-80-80-80-22.4 0-42.6 9.2-57.1 24-6 6.1-14.3 9.6-22.9 9.6s-16.8-3.5-22.9-9.6c-14.6-14.9-34.8-24-57.1-24-44.2 0-80 35.8-80 80zM376.1 447.8c2.6 .1 5.2 .2 7.9 .2 91 0 160-67 160-144 0-44.2-35.8-80-80-80-17.1 0-33 5.4-46 14.5 9 20 14 42.2 14 65.5 0 55.7-21.2 105.4-55.9 143.8z", "M301.6-8.4c-1.7-2.7-4.2-5-7.3-6.3-8.1-3.5-17.5 .3-21 8.4L178.8 214.1C160.2 200.2 137 192 112 192 50.1 192 0 242.1 0 304 0 401.2 86 480 192 480s192-78.8 192-176c0-61.9-50.1-112-112-112-20 0-38.8 5.3-55.1 14.5L290.7 34.3 400.3 208.4c7 9.3 12.9 19.4 17.7 30.1 13-9.2 28.9-14.5 46-14.5 44.2 0 80 35.8 80 80 0 77-69 144-160 144-2.6 0-5.3-.1-7.9-.2-9.4 10.4-19.7 20-30.9 28.6 12.5 2.4 25.5 3.6 38.8 3.6 106 0 192-78.8 192-176 0-61.9-50.1-112-112-112-11.5 0-22.6 1.7-33.1 5L301.6-8.4zM192 257.6c8.6 0 16.8-3.5 22.9-9.6 14.6-14.9 34.8-24 57.1-24 44.2 0 80 35.8 80 80 0 77-69 144-160 144S32 381 32 304c0-44.2 35.8-80 80-80 22.4 0 42.6 9.2 57.1 24 6 6.1 14.3 9.6 22.9 9.6z"]],
    "vacuum-robot": [512, 512, [], "e04e", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm84.7 20.7c6.2-6.2 16.4-6.2 22.6 0l96 96c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-96-96c-6.2-6.2-6.2-16.4 0-22.6zm16-144c68.1-68.1 178.5-68.1 246.6 0s68.1 178.5 0 246.6c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6c55.6-55.6 55.6-145.8 0-201.4s-145.8-55.6-201.4 0c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6zm48 80c6.2-6.2 16.4-6.2 22.6 0l96 96c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-96-96c-6.2-6.2-6.2-16.4 0-22.6z", "M256 32a224 224 0 1 1 0 448 224 224 0 1 1 0-448zm0 480a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM356.7 155.3c55.6 55.6 55.6 145.8 0 201.4-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0c68.1-68.1 68.1-178.5 0-246.6s-178.5-68.1-246.6 0c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0c55.6-55.6 145.8-55.6 201.4 0zM203.3 212.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l96 96c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-96-96zm32 160l-96-96c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l96 96c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6z"]],
    "circle-eurozone": [512, 512, [], "e745", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm96-80c0-8.8 7.2-16 16-16l72 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-56 0 0 51.2 48 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-48 0 0 44.8 57.6 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L144 352c-8.8 0-16-7.2-16-16l0-160zm136 0c0-8.8 7.2-16 16-16l88 0c5.7 0 10.9 3 13.8 7.9s3 10.9 .2 15.9l-75 136.3 60.9 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-88 0c-5.7 0-10.9-3-13.8-7.9s-3-10.9-.2-15.9l75-136.3-60.9 0c-8.8 0-16-7.2-16-16z", "M256 32a224 224 0 1 1 0 448 224 224 0 1 1 0-448zm0 480a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM144 160c-8.8 0-16 7.2-16 16l0 160c0 8.8 7.2 16 16 16l73.6 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-57.6 0 0-44.8 48 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-48 0 0-51.2 56 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-72 0zm136 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l60.9 0-75 136.3c-2.7 5-2.6 11 .2 15.9s8.1 7.9 13.8 7.9l88 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-60.9 0 75-136.3c2.7-5 2.6-11-.2-15.9S373.7 160 368 160l-88 0z"]],
    "shoe-prints": [576, 512, [], "f54b", ["M32 400c0-26.5 21.5-48 48-48l32 0 0 96-32 0c-26.5 0-48-21.5-48-48zM96 112c0-26.5 21.5-48 48-48l32 0 0 96-32 0c-26.5 0-48-21.5-48-48zm48 239.6c45.6-2.4 78-14.7 105.9-25.9l3-1.2c29.1-11.6 51.2-20.5 83.1-20.5 36.5 0 75 7.4 103 22.3 27.4 14.5 41 33.4 41 57.7 0 21.1-17.4 44.9-58.3 65.4-39.2 19.6-90.2 30.6-133.7 30.6-27.7 0-64.5-7.2-96.1-15-15.4-3.9-29-7.7-38.6-10.6-3.7-1.1-6.8-2.1-9.2-2.8l0-99.9zM208 60.5c2.4-.8 5.5-1.7 9.2-2.8 9.7-2.9 23.2-6.8 38.6-10.6 31.6-7.9 68.4-15 96.1-15 43.5 0 94.5 11 133.7 30.6 41 20.5 58.3 44.3 58.3 65.4 0 24.4-13.6 43.2-41 57.7-28.1 14.9-66.5 22.3-103 22.3-31.9 0-54-8.9-83.1-20.5l-3-1.2C286 175.1 253.6 162.8 208 160.4l0-99.9z", "M208 60.5l0 99.9c45.6 2.4 78 14.7 105.9 25.9l3 1.2c29.1 11.7 51.2 20.5 83.1 20.5 36.5 0 75-7.4 103-22.3 27.4-14.5 41-33.4 41-57.7 0-21.1-17.4-44.9-58.3-65.4-39.2-19.6-90.2-30.6-133.7-30.6-27.7 0-64.5 7.2-96.1 15-15.4 3.9-29 7.7-38.6 10.6-3.7 1.1-6.8 2.1-9.2 2.8zM176 160l0-96-32 0c-26.5 0-48 21.5-48 48s21.5 48 48 48l32 0zM192 32S288.3 0 352 0c96 0 224 48 224 128S480 240 400 240c-38.2 0-65.4-10.9-93.9-22.4-31.2-12.5-63.9-25.6-114.1-25.6l-48 0c-44.2 0-80-35.8-80-80s35.8-80 80-80l48 0zM112 448l0-96-32 0c-26.5 0-48 21.5-48 48s21.5 48 48 48l32 0zm41.2 6.3c9.7 2.9 23.2 6.8 38.6 10.6 31.6 7.9 68.4 15 96.1 15 43.5 0 94.5-11 133.7-30.6 41-20.5 58.3-44.3 58.3-65.4 0-24.4-13.6-43.2-41-57.7-28.1-14.9-66.5-22.3-103-22.3-31.9 0-54 8.9-83.1 20.5l-3 1.2C222 336.9 189.6 349.2 144 351.6l0 99.9c2.4 .8 5.5 1.7 9.2 2.8zM128 480l-48 0c-44.2 0-80-35.8-80-80s35.8-80 80-80l48 0c50.2 0 82.9-13.1 114.1-25.6 28.5-11.4 55.7-22.4 93.9-22.4 80 0 176 32 176 112S384 512 288 512c-63.7 0-160-32-160-32z"]],
    "squirrel": [512, 512, [], "f71a", ["M416.1 238.5l18.8 0c32.9 0 59.6-26.7 59.6-59.6 0-36.6-29.6-66.2-66.2-66.2l-12.2 0 0 15.3-83 0 0 62.8c0 12.1-3.4 23.9-9.8 34.1l-35.2 55.9 0-120.8-18.2-54.8c-17.4-52.3-66.3-87.6-121.5-87.6l-3.9 0C73.7 17.6 16.5 74.9 16.5 145.5l0 5c0 67.9 55 122.9 122.9 122.9 25.6 0 40 29.4 24.3 49.6l-6.8 8.7c-8.7 11.2-13.5 25.1-13.5 39.3l0 12.5c0 61.9 50.1 112 112 112l117.3 0c39.8 0 72-32.2 72-72l0-21.1c0-21.3-10.6-41.1-28.2-53l-.4-.3 0-110.6z", "M144 32C82.1 32 32 82.1 32 144S82.1 256 144 256c15.7 0 30.2 8.5 37.7 22.3 9.6 17.3 5.2 37-4.3 50.5-11 15.6-17.4 34.6-17.4 55.2 0 53 43 96 96 96l112 0c35.3 0 64-28.7 64-64s-28.7-64-64-64c-6.7 0-13.2 1-19.2 2.9-8.4 2.6-17.4-2-20.1-10.5s2-17.4 10.5-20.1c9.1-2.9 18.8-4.4 28.8-4.4 11.2 0 22 1.9 32 5.5l0-85.5c0-8.8 7.2-16 16-16l11.5 0c21.2 0 40.6-12 50.1-31l2-4.1-.3-3.4C476 152.9 448.5 128 415.6 128L400 128c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16s16 7.2 16 16l0 16c49.1 .2 90.2 37.5 95.1 86.4l.8 8c.3 3-.3 6-1.6 8.7l-4.1 8.2c-14.2 28.5-42.7 46.9-74.2 48.5l0 88.6c19.6 17.6 32 43.1 32 71.6 0 24.6-9.2 47-24.4 64l40.4 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-224 0c-70.7 0-128-57.3-128-128 0-27.4 8.6-52.8 23.2-73.6 4.5-6.3 4.6-12.8 2.4-16.7-1.9-3.5-5.7-5.7-9.7-5.7-79.5 0-144-64.5-144-144S64.5 0 144 0 288 64.5 288 144l0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-32c0-61.9-50.1-112-112-112zM352 80l0 76.2c0 39-7.1 66.6-21.2 91.9-11.9 21.2-28.6 40.5-48.2 63l0 0 0 0c-2.8 3.2-5.7 6.5-8.6 9.9l-11.2 13c-14.2 16.5-22.8 42.7-22.8 66.1 0 8.8-7.2 16-16 16s-16-7.2-16-16c0-29.6 10.4-63.7 30.6-87l11.2-13c3-3.5 5.9-6.8 8.7-10 19.9-22.9 34.3-39.4 44.4-57.5 11-19.7 17.1-41.6 17.1-76.2L320 80c0-8.8 7.2-16 16-16s16 7.2 16 16zm64 64a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"]],
    "circle-cedi": [512, 512, [], "e742", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm97.3 0c0-64.8 48.2-118.4 110.7-126.8l0-17.2c0-8.8 7.2-16 16-16s16 7.2 16 16l0 16.8c28.2 3.2 53.6 15.6 73.1 34.1 6.4 6.1 6.7 16.2 .6 22.6s-16.2 6.7-22.6 .7c-13.8-13.1-31.5-22-51.1-25.1l0 189.8c19.6-3 37.3-12 51.1-25.1 6.4-6.1 16.6-5.8 22.6 .6s5.8 16.6-.6 22.6c-19.6 18.5-45 30.8-73.1 34.1l0 16.8c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-17.2c-62.5-8.4-110.7-62-110.7-126.8zm32 0c0 47.1 34 86.3 78.7 94.5l0-188.9c-44.8 8.1-78.7 47.3-78.7 94.5z", "M256 32a224 224 0 1 1 0 448 224 224 0 1 1 0-448zm0 480a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm16-400c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 17.2c-62.5 8.4-110.7 62-110.7 126.8S177.5 374.4 240 382.8l0 17.2c0 8.8 7.2 16 16 16s16-7.2 16-16l0-16.8c28.2-3.2 53.6-15.6 73.1-34.1 6.4-6.1 6.7-16.2 .6-22.6s-16.2-6.7-22.6-.6c-13.8 13.1-31.5 22-51.1 25.1l0-189.8c19.6 3 37.3 12 51.1 25.1 6.4 6.1 16.6 5.8 22.6-.7s5.8-16.6-.6-22.6c-19.6-18.5-45-30.8-73.1-34.1l0-16.8zM161.3 256c0-47.1 34-86.3 78.7-94.5l0 188.9c-44.8-8.1-78.7-47.3-78.7-94.5z"]],
    "file-circle-exclamation": [576, 512, [], "e4eb", ["M64 64c0-17.7 14.3-32 32-32l128 0 0 96c0 35.3 28.7 64 64 64l96 0 0 22c-82.8 21.3-144 96.5-144 186 0 28.6 6.2 55.6 17.4 80L96 480c-17.7 0-32-14.3-32-32L64 64z", "M224 32L96 32C78.3 32 64 46.3 64 64l0 384c0 17.7 14.3 32 32 32l161.4 0c5.2 11.3 11.4 22 18.6 32L96 512c-35.3 0-64-28.7-64-64L32 64C32 28.7 60.7 0 96 0L229.5 0c17 0 33.3 6.7 45.3 18.7L397.3 141.3c12 12 18.7 28.3 18.7 45.3l0 22.1c-11 .9-21.6 2.7-32 5.4l0-22-96 0c-35.3 0-64-28.7-64-64l0-96zM370.7 160L256 45.3 256 128c0 17.7 14.3 32 32 32l82.7 0zM544 400a112 112 0 1 0 -224 0 112 112 0 1 0 224 0zm-256 0a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm144 44a20 20 0 1 1 0 40 20 20 0 1 1 0-40zm0-124c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-64c0-8.8 7.2-16 16-16z"]],
    "wallet": [512, 512, [], "f555", ["M32 112c0-26.5 21.5-48 48-48l384 0c8.8 0 16-7.2 16-16l0 64c-13.4-10.1-30-16-48-16L112 96c-8.8 0-16 7.2-16 16s7.2 16 16 16l320 0c26.5 0 48 21.5 48 48l0 192c0 26.5-21.5 48-48 48L80 416c-26.5 0-48-21.5-48-48l0-256zM360 272a24 24 0 1 0 48 0 24 24 0 1 0 -48 0z", "M80 32C35.8 32 0 67.8 0 112L0 368c0 44.2 35.8 80 80 80l352 0c44.2 0 80-35.8 80-80l0-192c0-44.2-35.8-80-80-80L112 96c-8.8 0-16 7.2-16 16s7.2 16 16 16l320 0c26.5 0 48 21.5 48 48l0 192c0 26.5-21.5 48-48 48L80 416c-26.5 0-48-21.5-48-48l0-256c0-26.5 21.5-48 48-48l384 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L80 32zM384 296a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]],
    "square-tugrik": [448, 512, [], "e728", ["M32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64C46.3 64 32 78.3 32 96zm80 48c0-8.8 7.2-16 16-16l192 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-80 0 0 57.8 50.9-17c8.4-2.8 17.4 1.7 20.2 10.1s-1.7 17.4-10.1 20.2l-61.1 20.4 0 30.3 50.9-17c8.4-2.8 17.4 1.7 20.2 10.1s-1.7 17.4-10.1 20.2L240 315.5 240 368c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-41.8-50.9 17c-8.4 2.8-17.4-1.7-20.2-10.1s1.7-17.4 10.1-20.2l61.1-20.4 0-30.3-50.9 17c-8.4 2.8-17.4-1.7-20.2-10.1s1.7-17.4 10.1-20.2l61.1-20.4 0-68.5-80 0c-8.8 0-16-7.2-16-16z", "M64 64C46.3 64 32 78.3 32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm112 48c0-8.8 7.2-16 16-16l192 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-80 0 0 57.8 50.9-17c8.4-2.8 17.4 1.7 20.2 10.1s-1.7 17.4-10.1 20.2l-61.1 20.4 0 30.3 50.9-17c8.4-2.8 17.4 1.7 20.2 10.1s-1.7 17.4-10.1 20.2L240 315.5 240 368c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-41.8-50.9 17c-8.4 2.8-17.4-1.7-20.2-10.1s1.7-17.4 10.1-20.2l61.1-20.4 0-30.3-50.9 17c-8.4 2.8-17.4-1.7-20.2-10.1s1.7-17.4 10.1-20.2l61.1-20.4 0-68.5-80 0c-8.8 0-16-7.2-16-16z"]],
    "message": [512, 512, ["comment-alt"], "f27a", ["M32 128l0 224c0 35.3 28.7 64 64 64l40 0c13.3 0 24 10.7 24 24l0 68 112-84c6.9-5.2 15.3-8 24-8l120 0c35.3 0 64-28.7 64-64l0-224c0-35.3-28.7-64-64-64L96 64c-35.3 0-64 28.7-64 64z", "M179.2 533.6s0 0 0 0l-6.4 4.8c-4.8 3.6-10.7 5.6-16.8 5.6-15.5 0-28-12.5-28-28l0-68-32 0c-53 0-96-43-96-96L0 128C0 75 43 32 96 32l320 0c53 0 96 43 96 96l0 224c0 53-43 96-96 96l-120 0c-1.7 0-3.4 .6-4.8 1.6l-112 84zM160 468l0 40 112-84c6.9-5.2 15.3-8 24-8l120 0c35.3 0 64-28.7 64-64l0-224c0-35.3-28.7-64-64-64L96 64c-35.3 0-64 28.7-64 64l0 224c0 35.3 28.7 64 64 64l40 0c13.3 0 24 10.7 24 24l0 28z"]],
    "trophy": [512, 512, [127942], "f091", ["M129.1 47c6.2 163.9 44.9 239.2 76.1 273.5 15.5 17.1 29.9 24.8 39.3 28.3 4.8 1.8 8.5 2.6 10.6 3 .5 .1 .9 .1 1.2 .2 .3 0 .7-.1 1.2-.2 2.1-.3 5.8-1.1 10.6-3 9.4-3.5 23.8-11.3 39.3-28.3 31.2-34.2 69.8-109.6 76.1-273.5 .3-7.8-6.2-15-15.1-15l-224 0c-9 0-15.4 7.3-15.1 15z", "M144.2 32l224 0c9 0 15.4 7.3 15.1 15-6.2 163.9-44.9 239.2-76.1 273.5-15.5 17.1-29.9 24.8-39.3 28.3-4.8 1.8-8.5 2.6-10.6 3-.5 .1-.9 .1-1.2 .2-.3 0-.7-.1-1.2-.2-2.1-.3-5.8-1.1-10.6-3-9.4-3.5-23.8-11.3-39.3-28.3-31.2-34.2-69.8-109.6-76.1-273.5-.3-7.8 6.2-15 15.1-15zm224-32l-224 0c-26.5 0-48.1 21.8-47.1 48.2 .2 5.3 .4 10.6 .7 15.8L48.2 64c-26.1 0-49.1 21.5-46.5 49.5 6.1 65.8 30.3 111.5 62.1 142.9 28.9 28.6 63.3 44.3 93.6 53 29.9 49.4 63.5 66.1 82.9 71.8l0 98.9-96 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l224 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-96 0 0-98.9c19.8-5.8 54.5-23.1 85-75.3 31-9.8 64.7-26.4 92.9-54.7 31-31.1 54.4-75.4 60.6-137.6 2.8-28.1-20.3-49.6-46.4-49.6l-49.6 0c.3-5.2 .5-10.4 .7-15.8 1-26.5-20.6-48.2-47.1-48.2zm44.2 96l51.8 0c9.3 0 15.3 7.3 14.5 14.4-5.5 55.2-25.8 92.5-51.4 118.1-15.1 15.1-32.3 26.5-49.9 35 16-40.6 28.9-94.9 35-167.5zM136.7 267.8c-17.6-8-35-19-50.5-34.2-26-25.6-47.2-64.2-52.7-123.1-.7-7.2 5.4-14.5 14.6-14.5L100 96c6.3 75.2 20 130.8 36.7 171.8z"]],
    "face-dizzy": [512, 512, ["dizzy"], "f567", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm68.7-107.3c6.2-6.2 16.4-6.2 22.6 0l36.7 36.7 36.7-36.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6l-36.7 36.7 36.7 36.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-36.7-36.7-36.7 36.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l36.7-36.7-36.7-36.7c-6.2-6.2-6.2-16.4 0-22.6zM176 368c0-34.1 21.4-63.2 51.4-74.7 8.6-4.1 18.2-6.4 28.3-6.4 9 0 17.6 1.8 25.4 5.1 31.9 10.6 54.9 40.6 54.9 76 0 44.2-35.8 80-80 80s-80-35.8-80-80zM292.7 148.7c6.2-6.2 16.4-6.2 22.6 0l36.7 36.7 36.7-36.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6l-36.7 36.7 36.7 36.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-36.7-36.7-36.7 36.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l36.7-36.7-36.7-36.7c-6.2-6.2-6.2-16.4 0-22.6z", "M480 256a224 224 0 1 0 -448 0 224 224 0 1 0 448 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zM208 368a48 48 0 1 0 96 0 48 48 0 1 0 -96 0zm48 80a80 80 0 1 1 0-160 80 80 0 1 1 0 160zM100.7 148.7c6.2-6.2 16.4-6.2 22.6 0l36.7 36.7 36.7-36.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6l-36.7 36.7 36.7 36.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-36.7-36.7-36.7 36.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l36.7-36.7-36.7-36.7c-6.2-6.2-6.2-16.4 0-22.6zm192 0c6.2-6.2 16.4-6.2 22.6 0l36.7 36.7 36.7-36.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6l-36.7 36.7 36.7 36.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-36.7-36.7-36.7 36.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l36.7-36.7-36.7-36.7c-6.2-6.2-6.2-16.4 0-22.6z"]],
    "bacteria": [640, 512, [], "e059", ["M82.7 178.7c-25 25-25 65.5 0 90.5 24.8 24.8 65 25 90 .5 .2-.2 .4-.4 .5-.5l128-128c.2-.2 .3-.3 .5-.5 24.5-25 24.4-65.2-.5-90-25-25-65.5-25-90.5 0-42.7 42.7-85.3 85.3-128 128zM152 224a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm64-64a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zM338.7 370.7c-25 25-25 65.5 0 90.5 24.9 24.9 65.1 25 90.1 .4 .1-.1 .3-.3 .4-.4 42.7-42.7 85.3-85.3 128-128 .1-.1 .3-.3 .4-.4 24.6-25 24.5-65.3-.4-90.1-25-25-65.4-25-90.4-.1L338.7 370.7zM408 416a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M272-8c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 9.3c-14 2.4-27.6 7.8-39.6 16.4l-5.1-5.1c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l4.1 4.1-41.4 41.4-4.1-4.1c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l4.1 4.1-41.4 41.4-4.1-4.1c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l5.1 5.1c-8.6 12-14.1 25.6-16.4 39.6L24 208c-8.8 0-16 7.2-16 16s7.2 16 16 16l9.3 0c2.4 14 7.8 27.6 16.4 39.6l-5.1 5.1c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l5.1-5.1c12 8.6 25.6 14.1 39.6 16.4l0 9.3c0 8.8 7.2 16 16 16s16-7.2 16-16l0-9.3c14-2.4 27.6-7.8 39.6-16.4l5.1 5.1c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-4.1-4.1 41.4-41.4 4.1 4.1c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-4.1-4.1 41.4-41.4 4.1 4.1c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-5.1-5.1c8.6-12 14.1-25.6 16.4-39.6l9.3 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-9.3 0c-2.4-14-7.8-27.6-16.4-39.6l5.1-5.1c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-5.1 5.1C299.6 9.2 286 3.7 272 1.3L272-8zm29.3 58.7c25 25 25 65.5 0 90.5l-128 128c-25 25-65.5 25-90.5 0s-25-65.5 0-90.5l128-128c25-25 65.5-25 90.5 0zM152 224a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm40-40a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm336 0c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 9.3c-14 2.4-27.6 7.8-39.6 16.4l-5.1-5.1c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l4.1 4.1-41.4 41.4-4.1-4.1c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l4.1 4.1-41.4 41.4-4.1-4.1c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l5.1 5.1c-8.6 12-14.1 25.6-16.4 39.6l-9.3 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l9.3 0c2.4 14 7.8 27.6 16.4 39.6l-5.1 5.1c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l5.1-5.1c12 8.6 25.6 14.1 39.6 16.4l0 9.3c0 8.8 7.2 16 16 16s16-7.2 16-16l0-9.3c14-2.4 27.6-7.8 39.6-16.4l5.1 5.1c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-4.1-4.1 41.4-41.4 4.1 4.1c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-4.1-4.1 41.4-41.4 4.1 4.1c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-5.1-5.1c8.6-12 14.1-25.6 16.4-39.6l9.3 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-9.3 0c-2.4-14-7.8-27.6-16.4-39.6l5.1-5.1c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-5.1 5.1c-12-8.6-25.6-14.1-39.6-16.4l0-9.3zm29.3 58.7c25 25 25 65.5 0 90.5l-128 128c-25 25-65.5 25-90.5 0s-25-65.5 0-90.5l128-128c25-25 65.5-25 90.5 0zM384 440a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]],
    "toggle-large-on": [576, 512, [], "e5b1", ["M32 256c0 70.7 57.3 128 128 128l160 0c-38.9-29.2-64-75.7-64-128s25.1-98.8 64-128l-160 0C89.3 128 32 185.3 32 256z", "M416 128a128 128 0 1 0 0 256 128 128 0 1 0 0-256zm0 288l-256 0C71.6 416 0 344.4 0 256S71.6 96 160 96l256 0c88.4 0 160 71.6 160 160S504.4 416 416 416zm-96-32c-38.9-29.2-64-75.7-64-128s25.1-98.8 64-128l-160 0C89.3 128 32 185.3 32 256S89.3 384 160 384l160 0z"]],
    "ear-deaf": [512, 512, ["deaf", "deafness", "hard-of-hearing"], "f2a4", ["M87.2 254.3c5.2-2.6 8.8-8.1 8.8-14.3 0-79.5 64.5-144 144-144s144 64.5 144 144c0 41.9-17.9 79.7-46.5 106-10.1 9.2-17.5 22.6-17.5 38 0 53-43 96-96 96l-16 0c-2.6 0-5 .6-7.2 1.7l-49.3-98.6 35.8-35.8c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-28.2 28.2-49.3-98.6zM128 240c0 8.8 7.2 16 16 16s16-7.2 16-16c0-44.2 35.8-80 80-80s80 35.8 80 80c0 8.8 7.2 16 16 16s16-7.2 16-16c0-61.9-50.1-112-112-112S128 178.1 128 240z", "M507.3 27.3l-64 64c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l64-64c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6zm-320 320l-160 160c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l160-160c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6zM240 96c-79.5 0-144 64.5-144 144 0 8.8-7.2 16-16 16s-16-7.2-16-16c0-97.2 78.8-176 176-176s176 78.8 176 176c0 51.3-21.9 97.4-56.9 129.6-4.8 4.4-7.1 9.7-7.1 14.4 0 70.7-57.3 128-128 128l-16 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0c53 0 96-43 96-96 0-15.4 7.4-28.7 17.5-38 28.6-26.3 46.5-64.1 46.5-106 0-79.5-64.5-144-144-144zm0 64c-44.2 0-80 35.8-80 80 0 8.8-7.2 16-16 16s-16-7.2-16-16c0-61.9 50.1-112 112-112s112 50.1 112 112c0 8.8-7.2 16-16 16s-16-7.2-16-16c0-44.2-35.8-80-80-80z"]],
    "people-arrows": [512, 512, ["people-arrows-left-right"], "e068", ["M32 224c0-17.7 14.3-32 32-32l64 0c.3 0 .5 0 .8 0-8.1 8.1-16.3 16.3-24.4 24.4-21.9 21.9-21.9 57.3 0 79.2 8.1 8.1 16.3 16.3 24.4 24.4-.3 0-.5 0-.8 0l-64 0c-17.7 0-32-14.3-32-32l0-64zM128 64a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM383.2 192c.3 0 .5 0 .8 0l64 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-64 0c-.3 0-.5 0-.8 0 8.1-8.1 16.3-16.3 24.4-24.4 21.9-21.9 21.9-57.3 0-79.2-8.1-8.1-16.3-16.3-24.4-24.4zM448 64a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M96 96a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM96 0A64 64 0 1 1 96 128 64 64 0 1 1 96 0zm32 192l-64 0c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32l64 0c.3 0 .5 0 .8 0L160 351.2 160 496c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-144-64 0 0 144c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-152.6C12.9 332.4 0 311.7 0 288l0-64c0-35.3 28.7-64 64-64l64 0c9.6 0 18.7 2.1 26.9 5.9L128.8 192c-.3 0-.5 0-.8 0zM352 496l0-144.8 31.2-31.2c.3 0 .5 0 .8 0l64 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-64 0c-.3 0-.5 0-.8 0l-26.1-26.1c8.2-3.8 17.3-5.9 26.9-5.9l64 0c35.3 0 64 28.7 64 64l0 64c0 23.7-12.9 44.4-32 55.4L480 496c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-144-64 0 0 144c0 8.8-7.2 16-16 16s-16-7.2-16-16zM416 96a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm0-96a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM182.6 240l146.7 0-36.7-36.7c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l64 64c6.2 6.2 6.2 16.4 0 22.6l-64 64c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l36.7-36.7-146.7 0 36.7 36.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-64-64c-6.2-6.2-6.2-16.4 0-22.6l64-64c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6L182.6 240z"]],
    "treasure-chest": [512, 512, [], "f723", ["M32 160l0 96 64 0 0-186.5C58.7 82.6 32 118.2 32 160zm0 128l0 128c0 17.7 14.3 32 32 32l32 0 0-160-64 0zM128 64l0 192 80 0 0-32c0-26.5 21.5-48 48-48s48 21.5 48 48l0 32 80 0 0-192-256 0zm0 224l0 160 256 0 0-160-80 0 0 32c0 26.5-21.5 48-48 48s-48-21.5-48-48l0-32-80 0zM416 69.5l0 186.5 64 0 0-96c0-41.8-26.7-77.4-64-90.5zM416 288l0 160 32 0c17.7 0 32-14.3 32-32l0-128-64 0z", "M384 64l0 192-80 0 0-32c0-26.5-21.5-48-48-48s-48 21.5-48 48l0 32-80 0 0-192 256 0zm32 5.5c37.3 13.2 64 48.7 64 90.5l0 96-64 0 0-186.5zM480 288l0 128c0 17.7-14.3 32-32 32l-32 0 0-160 64 0zM384 448l-256 0 0-160 80 0 0 32c0 26.5 21.5 48 48 48s48-21.5 48-48l0-32 80 0 0 160zM96 448l-32 0c-17.7 0-32-14.3-32-32l0-128 64 0 0 160zM32 256l0-96c0-41.8 26.7-77.4 64-90.5l0 186.5-64 0zM128 32C57.3 32 0 89.3 0 160L0 416c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-256c0-70.7-57.3-128-128-128L128 32zM272 320c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-96c0-8.8 7.2-16 16-16s16 7.2 16 16l0 96z"]],
    "caret-large-right": [256, 512, [], "e82e", ["M64.5 96l160 160-160 160 0-320z", "M247.1 233.4c12.5 12.5 12.5 32.8 0 45.2l-160 160c-9.2 9.2-22.9 11.9-34.9 6.9S32.5 428.9 32.5 416l0-320c0-12.9 7.8-24.6 19.8-29.6 10.5-4.3 22.3-2.8 31.2 3.8l3.6 3.1 160 160zM64.5 96l0 320 160-160-160-160z"]],
    "hands-clapping": [512, 512, [], "e1a8", ["M32 257.9c0 4.8 1.9 9.3 5.3 12.7 33.6 33.6 62.3 62.3 86.1 86.1 6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L62.6 341.3c-3.4-3.4-7.9-5.3-12.7-5.3-9.9 0-17.9 8-17.9 17.9 0 4.8 1.9 9.3 5.3 12.7 32.2 32.2 47 47 71.7 71.7 26.7 26.7 62.9 41.7 100.7 41.7 78.6 0 142.4-63.8 142.4-142.4L352 208c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 64c0 8.8-7.2 16-16 16-4.4 0-8.4-1.8-11.3-4.7L166.6 157.3c-3.4-3.4-7.9-5.3-12.7-5.3-9.9 0-17.9 8-17.9 17.9 0 4.8 1.9 9.3 5.2 12.7 26 26 52 52 78.1 78.1 6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0c-59.7-59.7-96.4-96.4-110.1-110.1-3.4-3.4-7.9-5.3-12.7-5.3-9.9 0-17.9 8-17.9 17.9 0 4.8 1.9 9.3 5.3 12.7 5.6 5.6 42.4 42.4 110.1 110.1 6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L62.6 245.3c-3.4-3.4-7.9-5.3-12.7-5.3-9.9 0-17.9 8-17.9 17.9zM360.8 478.1C428.4 467.1 480 408.4 480 337.6L480 208c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 64c0 8.8-7.2 16-16 16-4.4 0-8.4-1.8-11.3-4.7l-4.7-4.7 0 59c0 54.3-21 103.7-55.2 140.5z", "M336 16c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16s16-7.2 16-16l0-64zM215.1 18.7c-7.4 4.9-9.3 14.8-4.4 22.2l32 48c4.9 7.4 14.8 9.3 22.2 4.4s9.3-14.8 4.4-22.2l-32-48c-4.9-7.4-14.8-9.3-22.2-4.4zm209.8 0c-7.4-4.9-17.3-2.9-22.2 4.4l-32 48c-4.9 7.4-2.9 17.3 4.4 22.2s17.3 2.9 22.2-4.4l32-48c4.9-7.4 2.9-17.3-4.4-22.2zM153.9 152c4.8 0 9.3 1.9 12.7 5.3L292.7 283.3c2.9 2.9 6.9 4.7 11.3 4.7 8.8 0 16-7.2 16-16l0-64c0-8.8 7.2-16 16-16s16 7.2 16 16l0 129.6c0 78.6-63.8 142.4-142.4 142.4-37.8 0-74-15-100.7-41.7-25.3-25.3-41.9-41.9-49.6-49.6l0 0-22-22c-3.4-3.4-5.3-7.9-5.3-12.7 0-9.9 8-17.9 17.9-17.9 4.8 0 9.3 1.9 12.7 5.2l0 0 38.1 38.1c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-38.1-38.1 0 0-48-48c-3.4-3.4-5.3-7.9-5.3-12.7 0-9.9 8-17.9 17.9-17.9 4.8 0 9.3 1.9 12.7 5.3l86.1 86.1c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-86.1-86.1 0 0-24-24c-3.4-3.4-5.3-7.9-5.3-12.7 0-9.9 8-17.9 17.9-17.9 4.8 0 9.3 1.9 12.7 5.3l32 32 0 0 78.1 78.1c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-78.1-78.1 0 0c-3.4-3.4-5.2-7.9-5.2-12.7 0-9.9 8-17.9 17.9-17.9zM31.1 211.7C12.9 219.1 0 237 0 257.9 0 271.2 5.3 283.9 14.6 293.3l15 15C12.2 316.1 0 333.6 0 353.9 0 367.2 5.3 379.9 14.6 389.3l22 22 0 0 16 16 0 0 33.6 33.6C119 493.6 163.4 512 209.6 512 305.9 512 384 433.9 384 337.6L384 208c0-26.5-21.5-48-48-48s-48 21.5-48 48l0 25.4-98.7-98.7c-9.4-9.4-22.1-14.6-35.3-14.6-20.4 0-37.9 12.2-45.7 29.7-9.3-8.8-21.5-13.7-34.3-13.7-27.6 0-49.9 22.4-49.9 49.9 0 9.1 2.5 18 7.1 25.7zM360.8 478.1c-11.7 12.6-25 23.7-39.5 33.1 5.4 .5 10.9 .8 16.4 .8 96.3 0 174.4-78.1 174.4-174.4L512 208c0-26.5-21.5-48-48-48s-48 21.5-48 48l0 70.6 4.7 4.7c2.9 2.9 6.9 4.7 11.3 4.7 8.8 0 16-7.2 16-16l0-64c0-8.8 7.2-16 16-16s16 7.2 16 16l0 129.6c0 70.7-51.6 129.4-119.2 140.5z"]],
    "circle-ampersand": [512, 512, [], "e0f8", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm112 64.8c0-20.8 10.2-40.3 27.4-52.1l38.7-26.6-18.6-19.5c-9.9-10.4-15.4-24.2-15.4-38.6 0-30.9 25.1-56 56-56l16.8 0c30.5 0 55.2 24.7 55.2 55.2 0 20.8-10.2 40.2-27.3 52l-17.5 12.1 45.4 47.7 34.5-48.2c5.1-7.2 15.1-8.9 22.3-3.7s8.9 15.1 3.7 22.3l-38 53.2 36.6 38.4c6.1 6.4 5.8 16.5-.6 22.6s-16.5 5.8-22.6-.6l-32.4-34-6.3 8.8c-13.5 18.9-35.3 30.2-58.6 30.2l-36 0c-34.9 0-63.2-28.3-63.2-63.2zm32 0c0 17.2 14 31.2 31.2 31.2l36 0c12.9 0 25-6.2 32.5-16.8l9.8-13.8-53.2-55.8-42.9 29.5c-8.5 5.8-13.5 15.4-13.5 25.7zM208 184c0 6.2 2.4 12.1 6.6 16.6l22.1 23.3 21.8-15c8.4-5.8 13.5-15.4 13.5-25.6 0-12.8-10.4-23.2-23.2-23.2L232 160c-13.3 0-24 10.7-24 24z", "M256 32a224 224 0 1 1 0 448 224 224 0 1 1 0-448zm0 480a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM208 184c0-13.3 10.7-24 24-24l16.8 0c12.8 0 23.2 10.4 23.2 23.2 0 10.2-5 19.8-13.5 25.6l-21.8 15-22.1-23.3c-4.3-4.5-6.6-10.4-6.6-16.6zm68.7 51.2c17.1-11.8 27.3-31.2 27.3-52 0-30.5-24.7-55.2-55.2-55.2L232 128c-30.9 0-56 25.1-56 56 0 14.4 5.5 28.2 15.4 38.6l18.6 19.5-38.7 26.6c-17.1 11.8-27.4 31.3-27.4 52.1 0 34.9 28.3 63.2 63.2 63.2l36 0c23.3 0 45.1-11.2 58.6-30.2l6.3-8.8 32.4 34c6.1 6.4 16.2 6.6 22.6 .6s6.6-16.2 .6-22.6l-36.6-38.4 38-53.2c5.1-7.2 3.5-17.2-3.7-22.3s-17.2-3.5-22.3 3.7l-34.5 48.2-45.4-47.7 17.5-12.1zm-87.1 59.9l42.9-29.5 53.2 55.8-9.8 13.8c-7.5 10.5-19.6 16.8-32.5 16.8l-36 0c-17.2 0-31.2-14-31.2-31.2 0-10.3 5.1-19.9 13.5-25.7z"]],
    "virus-covid-slash": [576, 512, [], "e4a9", ["M186.7 132.2c27.6-22.6 62.9-36.2 101.3-36.2 88.4 0 160 71.6 160 160 0 38.4-13.6 73.7-36.2 101.3L186.7 132.2z", "M27.3-27.2c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l544 544c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-91-91 17-17c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-17 17-23.1-23.1c25.1-29.6 41.4-67 44.7-108l32.7 0 0 24c0 8.8 7.2 16 16 16s16-7.2 16-16l0-80c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 24-32.7 0c-3.4-41-19.6-78.3-44.7-108l23.1-23.1 0 0 17 17c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L440.7 46.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l17 17 0 0-23.1 23.1C382.3 84.3 345 68 304 64.7l0-32.7 24 0c8.8 0 16-7.2 16-16S336.8 0 328 0L248 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l24 0 0 32.7c-41 3.4-78.3 19.6-108 44.7l-23.1-23.1 0 0 17-17c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-17 17-90.9-90.9zM186.7 132.2c27.6-22.6 62.9-36.2 101.3-36.2 88.4 0 160 71.6 160 160 0 38.4-13.6 73.7-36.2 101.3L186.7 132.2zM96.7 240l-32.7 0 0-24c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 80c0 8.8 7.2 16 16 16s16-7.2 16-16l0-24 32.7 0c3.4 41 19.6 78.3 44.7 108l-23.1 23.1 0 0-17-17c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l56.6 56.6c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-17-17 0 0 23.1-23.1c29.6 25.1 67 41.4 108 44.7l0 32.7-24 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l80 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-24 0 0-32.7c23.7-2 46.3-8.2 66.8-18.1L346.5 405c-18.1 7.1-37.8 11-58.5 11-88.4 0-160-71.6-160-160 0-20.6 3.9-40.4 11-58.5l-24.3-24.3c-9.8 20.5-16.1 43-18.1 66.8z"]],
    "chart-simple-horizontal": [448, 512, [], "e474", ["M32 48l0 32c0 8.8 7.2 16 16 16l288 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16L48 32c-8.8 0-16 7.2-16 16zm0 384l0 32c0 8.8 7.2 16 16 16l160 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16L48 416c-8.8 0-16 7.2-16 16z", "M352 48l0 32c0 8.8-7.2 16-16 16L48 96c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l288 0c8.8 0 16 7.2 16 16zM336 0L48 0C21.5 0 0 21.5 0 48L0 80c0 26.5 21.5 48 48 48l288 0c26.5 0 48-21.5 48-48l0-32c0-26.5-21.5-48-48-48zm80 272c0 8.8-7.2 16-16 16L48 288c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l352 0c8.8 0 16 7.2 16 16l0 32zm32-32c0-26.5-21.5-48-48-48L48 192c-26.5 0-48 21.5-48 48l0 32c0 26.5 21.5 48 48 48l352 0c26.5 0 48-21.5 48-48l0-32zM224 464c0 8.8-7.2 16-16 16L48 480c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l160 0c8.8 0 16 7.2 16 16l0 32zm32-32c0-26.5-21.5-48-48-48L48 384c-26.5 0-48 21.5-48 48l0 32c0 26.5 21.5 48 48 48l160 0c26.5 0 48-21.5 48-48l0-32z"]],
    "down-from-dotted-line": [384, 512, [], "e407", ["M67.3 352L192 476.7 316.7 352 240 352c-8.8 0-16-7.2-16-16l0-160c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16 0 53.3 0 106.7 0 160 0 8.8-7.2 16-16 16l-76.7 0z", "M209 505l0 0c-9.4 9.4-24.6 9.4-33.9 0l0 0-144-144c-6.9-6.9-8.9-17.2-5.2-26.2S38.3 320 48 320l80 0 0-64 0 0 0-80c0-26.5 21.5-48 48-48l32 0c26.5 0 48 21.5 48 48l0 144 80 0c9.7 0 18.5 5.8 22.2 14.8s1.7 19.3-5.2 26.2L209 505zm15-249l0-80c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16l0 80 0 0 0 80c0 8.8-7.2 16-16 16L67.3 352 192 476.7 316.7 352 240 352c-8.8 0-16-7.2-16-16l0-80zM24 0a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM136 0a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM272 24a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zM360 0a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]],
    "calendar-days": [448, 512, ["calendar-alt"], "f073", ["M32 192l0 64 96 0 0-64-96 0zm0 96l0 64 96 0 0-64-96 0zm0 96l0 32c0 17.7 14.3 32 32 32l64 0 0-64-96 0zM160 192l0 64 128 0 0-64-128 0zm0 96l0 64 128 0 0-64-128 0zm0 96l0 64 128 0 0-64-128 0zM320 192l0 64 96 0 0-64-96 0zm0 96l0 64 96 0 0-64-96 0zm0 96l0 64 64 0c17.7 0 32-14.3 32-32l0-32-96 0z", "M112 0c8.8 0 16 7.2 16 16l0 48 192 0 0-48c0-8.8 7.2-16 16-16s16 7.2 16 16l0 48 32 0c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 128C0 92.7 28.7 64 64 64l32 0 0-48c0-8.8 7.2-16 16-16zM384 96L64 96c-17.7 0-32 14.3-32 32l0 32 384 0 0-32c0-17.7-14.3-32-32-32zm32 96l-96 0 0 64 96 0 0-64zm0 96l-96 0 0 64 96 0 0-64zm0 96l-96 0 0 64 64 0c17.7 0 32-14.3 32-32l0-32zM288 352l0-64-128 0 0 64 128 0zM160 384l0 64 128 0 0-64-128 0zm-32-32l0-64-96 0 0 64 96 0zM32 384l0 32c0 17.7 14.3 32 32 32l64 0 0-64-96 0zm0-128l96 0 0-64-96 0 0 64zm128 0l128 0 0-64-128 0 0 64z"]],
    "lighthouse": [576, 512, [], "e612", ["M160.6 480l79.4 0 0-64c0-26.5 21.5-48 48-48s48 21.5 48 48l0 64 79.4 0-57.6-288-139.5 0-57.6 288zM224 76.2l0 83.8 128 0 0-83.8-64-41.1-64 41.1z", "M279.4 2.5c5.3-3.4 12-3.4 17.3 0l112 72c7.4 4.8 9.6 14.7 4.8 22.1s-14.7 9.6-22.1 4.8l-7.4-4.7 0 63.3 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-9.6 0 57.6 288 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-352 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0 57.6-288-9.6 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0 0-63.3-7.3 4.7c-7.4 4.8-17.3 2.6-22.1-4.8s-2.6-17.3 4.8-22.1l112-72zM272 480l32 0 0-64c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 64zm64 0l79.4 0-57.6-288-139.5 0-57.6 288 79.4 0 0-64c0-26.5 21.5-48 48-48s48 21.5 48 48l0 64zM352 76.2l-64-41.1-64 41.1 0 83.8 128 0 0-83.8zM39.2 17.7l64 32c7.9 4 11.1 13.6 7.2 21.5S96.8 82.3 88.8 78.3l-64-32c-7.9-4-11.1-13.6-7.2-21.5s13.6-11.1 21.5-7.2zm64 188.6l-64 32c-7.9 4-17.5 .7-21.5-7.2s-.7-17.5 7.2-21.5l64-32c7.9-4 17.5-.7 21.5 7.2s.7 17.5-7.2 21.5zM558.3 24.8c4 7.9 .7 17.5-7.2 21.5l-64 32c-7.9 4-17.5 .7-21.5-7.2s-.7-17.5 7.2-21.5l64-32c7.9-4 17.5-.7 21.5 7.2zm-92.6 160c4-7.9 13.6-11.1 21.5-7.2l64 32c7.9 4 11.1 13.6 7.2 21.5s-13.6 11.1-21.5 7.2l-64-32c-7.9-4-11.1-13.6-7.2-21.5z"]],
    "diamond-turn-right": [512, 512, ["directions"], "f5eb", ["M32 256c0 6.9 2.7 13.5 7.6 18.3L237.7 472.4c4.9 4.9 11.5 7.6 18.3 7.6s13.5-2.7 18.3-7.6L472.4 274.3c4.9-4.9 7.6-11.5 7.6-18.3s-2.7-13.5-7.6-18.3L274.3 39.6C269.5 34.7 262.9 32 256 32s-13.5 2.7-18.3 7.6L39.6 237.7C34.7 242.5 32 249.1 32 256zm144 16c0-35.3 28.7-64 64-64l89.4 0-44.7-44.7c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l72 72c6.2 6.2 6.2 16.4 0 22.6l-72 72c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l44.7-44.7-89.4 0c-17.7 0-32 14.3-32 32l0 48c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-48z", "M17 297C6.1 286.1 0 271.4 0 256s6.1-30.1 17-41L215 17C225.9 6.1 240.6 0 256 0s30.1 6.1 41 17L495 215c10.9 10.9 17 25.6 17 41s-6.1 30.1-17 41L297 495c-10.9 10.9-25.6 17-41 17s-30.1-6.1-41-17L17 297zM274.3 39.6C269.5 34.7 262.9 32 256 32s-13.5 2.7-18.3 7.6L39.6 237.7C34.7 242.5 32 249.1 32 256s2.7 13.5 7.6 18.3L237.7 472.4c4.9 4.9 11.5 7.6 18.3 7.6s13.5-2.7 18.3-7.6L472.4 274.3c4.9-4.9 7.6-11.5 7.6-18.3s-2.7-13.5-7.6-18.3L274.3 39.6zm105 195.7l-72 72c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l44.7-44.7-89.4 0c-17.7 0-32 14.3-32 32l0 48c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-48c0-35.3 28.7-64 64-64l89.4 0-44.7-44.7c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l72 72c6.2 6.2 6.2 16.4 0 22.6z"]],
    "drone": [512, 512, [], "f85f", ["M192 224l0 64c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-64 0c-17.7 0-32 14.3-32 32z", "M400 320c-1.6 0-3.1 0-4.7 .1 3-10.2 4.7-21 4.7-32.1 61.9 0 112 50.1 112 112s-50.1 112-112 112-112-50.1-112-112c11.2 0 22-1.6 32.1-4.7-.1 1.5-.1 3.1-.1 4.7 0 44.2 35.8 80 80 80s80-35.8 80-80-35.8-80-80-80zm-79.5 23.1c-6.4 3.8-13.6 6.5-21.3 7.9-3.7 .6-7.4 1-11.3 1l-64 0c-3.8 0-7.6-.3-11.3-1-7.6-1.4-14.8-4.1-21.3-7.9l-68.2 68.2c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l68.2-68.2c-3.8-6.4-6.5-13.6-7.9-21.3-.6-3.7-1-7.4-1-11.3l0-64c0-3.8 .3-7.6 1-11.3 1.4-7.6 4.1-14.8 7.9-21.3l-68.2-68.2c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l68.2 68.2c6.4-3.8 13.6-6.5 21.3-7.9 3.7-.6 7.4-1 11.3-1l64 0c3.8 0 7.6 .3 11.3 1 7.6 1.4 14.8 4.1 21.3 7.9l68.2-68.2c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6l-68.2 68.2c3.8 6.4 6.5 13.6 7.9 21.3 .6 3.7 1 7.4 1 11.3l0 64c0 3.8-.3 7.6-1 11.3-1.4 7.6-4.1 14.8-7.9 21.3l68.2 68.2c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-68.2-68.2zM112 0c61.9 0 112 50.1 112 112-11.2 0-22 1.6-32.1 4.7 .1-1.5 .1-3.1 .1-4.7 0-44.2-35.8-80-80-80s-80 35.8-80 80 35.8 80 80 80c1.6 0 3.1 0 4.7-.1-3 10.2-4.7 21-4.7 32.1-61.9 0-112-50.1-112-112S50.1 0 112 0zM0 400c0-61.9 50.1-112 112-112 0 11.2 1.6 22 4.7 32.1-1.5-.1-3.1-.1-4.7-.1-44.2 0-80 35.8-80 80s35.8 80 80 80 80-35.8 80-80c0-1.6 0-3.1-.1-4.7 10.2 3 21 4.7 32.1 4.7 0 61.9-50.1 112-112 112S0 461.9 0 400zM320.1 116.7c-10.2-3-21-4.7-32.1-4.7 0-61.9 50.1-112 112-112s112 50.1 112 112-50.1 112-112 112c0-11.2-1.6-22-4.7-32.1 1.5 .1 3.1 .1 4.7 .1 44.2 0 80-35.8 80-80s-35.8-80-80-80-80 35.8-80 80c0 1.6 0 3.1 .1 4.7zM224 192c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-64 0z"]],
    "text": [384, 512, [], "f893", ["", "M32 72c0-4.4 3.6-8 8-8l136 0 0 384-80 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l192 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-80 0 0-384 136 0c4.4 0 8 3.6 8 8l0 72c0 8.8 7.2 16 16 16s16-7.2 16-16l0-72c0-22.1-17.9-40-40-40L40 32C17.9 32 0 49.9 0 72l0 72c0 8.8 7.2 16 16 16s16-7.2 16-16l0-72z"]],
    "square-guarani": [448, 512, [], "e70e", ["M32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64C46.3 64 32 78.3 32 96zm72 160c0-60.8 45.3-111.1 104-118.9l0-17.1c0-8.8 7.2-16 16-16s16 7.2 16 16l0 17.1c26.3 3.5 50 15.6 68 33.2 6.3 6.2 6.4 16.3 .2 22.6s-16.3 6.4-22.6 .2c-12.3-12-28-20.5-45.6-23.7l0 70.6 88 0c8.8 0 16 7.2 16 16 0 60.8-45.3 111.1-104 118.9l0 17.1c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-17.1c-58.7-7.8-104-58.1-104-118.9zm32 0c0 43.1 31 79 72 86.6l0-173.1c-41 7.5-72 43.4-72 86.5zm104 16l0 70.6c35.8-6.6 64-34.8 70.6-70.6L240 272z", "M64 64C46.3 64 32 78.3 32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm208 24c0-8.8 7.2-16 16-16s16 7.2 16 16l0 17.1c26.3 3.5 50 15.6 68 33.2 6.3 6.2 6.4 16.3 .2 22.6s-16.3 6.4-22.6 .2c-12.3-12-28-20.5-45.6-23.7l0 70.6 88 0c8.8 0 16 7.2 16 16 0 60.8-45.3 111.1-104 118.9l0 17.1c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-17.1c-58.7-7.8-104-58.1-104-118.9s45.3-111.1 104-118.9l0-17.1zM136 256c0 43.1 31 79 72 86.6l0-173.1c-41 7.5-72 43.4-72 86.5zm174.5 16l-70.6 0 0 70.6c35.8-6.6 64-34.8 70.6-70.6z"]],
    "toilet-paper-under-slash": [576, 512, ["toilet-paper-reverse-slash"], "e2a1", ["M124 69.5L322.9 268.4c-1.9-14.3-2.9-29.2-2.9-44.4 0-50.8 11.2-97.5 30.1-132.1 5.6-10.2 12-19.6 19.2-27.9L144 64c-6.5 0-13.3 1.8-20 5.5zM352 224c0 32.2 4.9 61.8 13.2 86.7L438 383.5c16.2-2.7 33.4-16.3 47.8-42.7 15.9-29.1 26.2-70.3 26.2-116.8s-10.3-87.7-26.2-116.8C469.6 77.5 449.9 64 432 64s-37.6 13.5-53.8 43.2C362.3 136.3 352 177.5 352 224zm56 0c0-26.5 10.7-48 24-48s24 21.5 24 48-10.7 48-24 48-24-21.5-24-48zm55.3 184.7l48.7 48.7 0-97.9c-12.5 21.7-29 39.7-48.7 49.2z", "M27.3-27.2c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l544 544c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-27.9-27.9c.4-2.9 .6-5.9 .6-8.9l0-256c0-50.8-11.2-97.5-30.1-132.1-18.6-34-46.8-59.9-81.9-59.9L144 32c-15.9 0-30.4 5.3-43.2 14.3L27.3-27.2zM124 69.5c6.7-3.7 13.5-5.5 20-5.5l225.3 0c-7.2 8.2-13.6 17.7-19.2 27.9-18.9 34.6-30.1 81.4-30.1 132.1 0 15.2 1 30.1 2.9 44.4L124 69.5zM365.2 310.7c-8.3-24.9-13.2-54.5-13.2-86.7 0-46.5 10.3-87.7 26.2-116.8 16.2-29.7 35.9-43.2 53.8-43.2s37.6 13.5 53.8 43.2C501.7 136.3 512 177.5 512 224s-10.3 87.7-26.2 116.8c-14.4 26.4-31.6 40-47.8 42.7l-72.8-72.8zm98 98c19.8-9.5 36.3-27.5 48.7-49.2l0 97.9-48.7-48.7zM32 224c0 50.8 11.2 97.5 30.1 132.1 18.6 34 46.8 59.9 81.9 59.9l16 0 0 64c0 35.3 28.7 64 64 64l256 0c1.8 0 3.5-.1 5.3-.2L453.5 512 224 512c-17.7 0-32-14.3-32-32l0-64 165.5 0-32-32-181.5 0c-17.9 0-37.6-13.5-53.8-43.2-15.9-29.1-26.2-70.3-26.2-116.8 0-32.7 5.1-62.8 13.6-87.9L52.8 111.3C39.6 143.1 32 182.2 32 224zm400 48c13.3 0 24-21.5 24-48s-10.7-48-24-48-24 21.5-24 48 10.7 48 24 48z"]],
    "hand-point-up": [384, 512, [9757], "f0a6", ["M32 320l0 32c0 70.7 57.3 128 128 128l64 0c69.8 0 126.6-55.9 128-125.4-7.3 3.4-15.4 5.4-24 5.4-17.8 0-33.6-8.3-43.9-21.2-9.8 8.2-22.4 13.2-36.1 13.2-15.7 0-29.8-6.4-40-16.8-10.2 10.4-24.3 16.8-40 16.8l-56 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l56 0c13.3 0 24-10.7 24-24 0-13.3-10.8-24-24-24l-88 0c-26.5 0-48 21.5-48 48zM64 56l0 185.6c5.2-1 10.5-1.6 16-1.6l32 0 0-184c0-13.3-10.7-24-24-24S64 42.7 64 56zm80 144l0 40 24 0c8.6 0 16.7 1.9 24 5.4l0-45.4c0-13.3-10.7-24-24-24s-24 10.7-24 24zm80 32l0 64c0 13.3 10.7 24 24 24s24-10.7 24-24l0-64c0-13.3-10.7-24-24-24-13.2 0-24 10.7-24 24zm80 16l0 56c0 13.3 10.7 24 24 24s24-10.7 24-24l0-56c0-13.3-10.7-24-24-24s-24 10.7-24 24z", "M64 56c0-13.3 10.7-24 24-24s24 10.7 24 24l0 184-32 0c-5.5 0-10.8 .6-16 1.6L64 56zm48 216l56 0c13.2 0 24 10.7 24 24l0 0c0 13.3-10.7 24-24 24l-56 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l56 0c15.7 0 29.8-6.4 40-16.8 10.2 10.4 24.3 16.8 40 16.8 13.8 0 26.4-5 36.1-13.2 10.3 12.9 26.1 21.2 43.9 21.2 8.6 0 16.7-1.9 24-5.4-1.4 69.5-58.2 125.4-128 125.4l-64 0C89.3 480 32 422.7 32 352l0-32c0-26.5 21.5-48 48-48l32 0zm32-32l0-40c0-13.3 10.7-24 24-24s24 10.7 24 24l0 45.4c-7.3-3.5-15.4-5.4-24-5.4l-24 0zm0-90.6L144 56c0-30.9-25.1-56-56-56S32 25.1 32 56l0 200C12.6 270.6 0 293.8 0 320l0 32c0 88.4 71.6 160 160 160l64 0c88.4 0 160-71.6 160-160l0-104c0-30.9-25.1-56-56-56-12.1 0-23.3 3.8-32.5 10.4-9.9-15.8-27.5-26.4-47.5-26.4-9.7 0-18.8 2.5-26.7 6.8-7.3-22.5-28.4-38.8-53.3-38.8-8.6 0-16.7 1.9-24 5.4zM224 272l0-40c0-13.2 10.8-24 24-24 13.3 0 24 10.7 24 24l0 64c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-24zm128 0l0 32c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-56c0-13.3 10.7-24 24-24s24 10.7 24 24l0 24z"]],
    "pen-slash": [576, 512, [], "e213", ["M252.9 198.4c24.5-24.5 48.9-48.9 73.4-73.4 30.9 30.9 61.8 61.8 92.7 92.7l-73.4 73.4c-30.9-30.9-61.8-61.8-92.7-92.7z", "M27.3-27.2c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l544 544c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L368.2 313.7 522.8 159.1C536.4 145.6 544 127.2 544 108s-7.6-37.6-21.2-51.1L487.1 21.2C473.6 7.6 455.2 0 436 0s-37.6 7.6-51.1 21.2l-154.6 154.6-203-203zM252.9 198.4l73.4-73.4 92.7 92.7-73.4 73.4-92.7-92.7zM90.9 315.1c-10.7 10.7-18.5 24.1-22.6 38.7L32.9 481.6c-2.3 8.3 0 17.3 6.2 23.4s15.1 8.5 23.4 6.2l127.8-35.5c14.6-4.1 27.9-11.8 38.7-22.6l82.8-82.8-22.6-22.6-82.8 82.8c-6.8 6.8-15.3 11.8-24.6 14.4L67.5 476.5 99.2 362.4c2.6-9.3 7.5-17.8 14.4-24.6l82.8-82.8-22.6-22.6-82.8 82.8zM407.5 43.8C415.1 36.2 425.3 32 436 32s20.9 4.2 28.5 11.8l35.7 35.7C507.8 87.1 512 97.3 512 108s-4.2 20.9-11.8 28.5L441.7 195 349 102.3 407.5 43.8z"]],
    "comment-plus": [512, 512, [], "f4b2", ["M32 240c0 46.7 16.5 89.8 44.8 124.8 8.1 10.1 9.4 24.1 3.2 35.4l-40.2 73.6 101-43.3c7.9-3.4 16.8-3.5 24.8-.2 27.6 11.3 58.2 17.6 90.4 17.6 125.7 0 224-95 224-208S381.7 32 256 32 32 127 32 240zm136 0c0-8.8 7.2-16 16-16l56 0 0-56c0-8.8 7.2-16 16-16s16 7.2 16 16l0 56 56 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-56 0 0 56c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-56-56 0c-8.8 0-16-7.2-16-16z", "M80 400.2c6.2-11.4 4.9-25.4-3.2-35.4-28.2-34.9-44.8-78.1-44.8-124.8 0-113 98.3-208 224-208s224 95 224 208-98.3 208-224 208c-32.3 0-62.8-6.3-90.4-17.6-7.9-3.3-16.9-3.2-24.8 .2L39.8 473.8 80 400.2zM0 240c0 54.4 19.3 104.6 51.9 144.9L3.1 474.3c-2 3.7-3.1 7.9-3.1 12.2 0 14.1 11.4 25.5 25.5 25.5 4 0 7.8-.6 11.5-2.1L153.4 460c31.4 12.9 66.1 20 102.6 20 141.4 0 256-107.5 256-240S397.4 0 256 0 0 107.5 0 240zm240 72c0 8.8 7.2 16 16 16s16-7.2 16-16l0-56 56 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-56 0 0-56c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 56-56 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l56 0 0 56z"]],
    "bezier-curve": [640, 512, [], "f55b", ["M32 112a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zM64 368l0 64c0 8.8 7.2 16 16 16l64 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16l-64 0c-8.8 0-16 7.2-16 16zM272 80l0 64c0 8.8 7.2 16 16 16l64 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16l-64 0c-8.8 0-16 7.2-16 16zM480 368l0 64c0 8.8 7.2 16 16 16l64 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16l-64 0c-8.8 0-16 7.2-16 16zm64-256a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M352 64c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16l-64 0c-8.8 0-16-7.2-16-16l0-64c0-8.8 7.2-16 16-16l64 0zm83.4 64l78.6 0c7.1 27.6 32.2 48 62 48 35.3 0 64-28.7 64-64s-28.7-64-64-64c-29.8 0-54.9 20.4-62 48l-114 0 0-16c0-26.5-21.5-48-48-48l-64 0c-26.5 0-48 21.5-48 48l0 16-114 0c-7.1-27.6-32.2-48-62-48-35.3 0-64 28.7-64 64s28.7 64 64 64c29.8 0 54.9-20.4 62-48l78.6 0C139.5 167.2 96 238.5 96 320l-16 0c-26.5 0-48 21.5-48 48l0 64c0 26.5 21.5 48 48 48l64 0c26.5 0 48-21.5 48-48l0-64c0-26.5-21.5-48-48-48l-16 0c0-77.5 45.9-144.3 112-174.6 .7 25.9 21.9 46.6 48 46.6l64 0c26 0 47.2-20.7 48-46.6 66.1 30.3 112 97.1 112 174.6l-16 0c-26.5 0-48 21.5-48 48l0 64c0 26.5 21.5 48 48 48l64 0c26.5 0 48-21.5 48-48l0-64c0-26.5-21.5-48-48-48l-16 0c0-81.5-43.5-152.8-108.6-192zM544 352l16 0c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16l-64 0c-8.8 0-16-7.2-16-16l0-64c0-8.8 7.2-16 16-16l48 0zm-416 0l16 0c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16l-64 0c-8.8 0-16-7.2-16-16l0-64c0-8.8 7.2-16 16-16l48 0zM32 112a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm512 0a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"]],
    "clipboard-list-check": [384, 512, [], "f737", ["M32 96l0 352c0 17.7 14.3 32 32 32l256 0c17.7 0 32-14.3 32-32l0-352c0-17.7-14.3-32-32-32l-16.6 0c-3.9 27.1-27.2 48-55.4 48l-112 0c-28.2 0-51.6-20.9-55.4-48L64 64C46.3 64 32 78.3 32 96zM76.4 306.9c-5.5-6.9-4.4-17 2.5-22.5s17-4.4 22.5 2.5l12.5 15.6 32.8-40.5c5.6-6.9 15.6-7.9 22.5-2.4s7.9 15.6 2.4 22.5l-45.3 56c-3 3.8-7.6 5.9-12.5 5.9s-9.4-2.2-12.4-6L76.4 306.9zM136 208a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zM88 400c0-13.3 10.7-24 24-24s24 10.7 24 24-10.7 24-24 24-24-10.7-24-24zm88-192c0-8.8 7.2-16 16-16l96 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16zm0 192c0-8.8 7.2-16 16-16l96 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16zm32-96c0-8.8 7.2-16 16-16l64 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-64 0c-8.8 0-16-7.2-16-16z", "M136 80l112 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L136 32c-13.3 0-24 10.7-24 24s10.7 24 24 24zm0 32c-28.2 0-51.6-20.9-55.4-48L64 64C46.3 64 32 78.3 32 96l0 352c0 17.7 14.3 32 32 32l256 0c17.7 0 32-14.3 32-32l0-352c0-17.7-14.3-32-32-32l-16.6 0c-3.9 27.1-27.2 48-55.4 48l-112 0zM248 0c22.3 0 41.6 13.1 50.6 32L320 32c35.3 0 64 28.7 64 64l0 352c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l21.4 0c9-18.9 28.3-32 50.6-32L248 0zM192 224c-8.8 0-16-7.2-16-16s7.2-16 16-16l96 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0zm0 160l96 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zm-56 16c0 13.3-10.7 24-24 24s-24-10.7-24-24 10.7-24 24-24 24 10.7 24 24zM112 184a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm96 120c0-8.8 7.2-16 16-16l64 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-64 0c-8.8 0-16-7.2-16-16zm-36.5-21.9l-45.3 56c-3 3.8-7.6 5.9-12.5 5.9s-9.4-2.2-12.4-6L76.4 306.9c-5.5-6.9-4.4-17 2.5-22.5s17-4.4 22.5 2.5l12.5 15.6 32.8-40.5c5.6-6.9 15.6-7.9 22.5-2.4s7.9 15.6 2.4 22.5z"]],
    "lamp-desk": [512, 512, [], "e014", ["M211.3 51.3c20.3-20.3 53.1-20.3 73.4 0l40 40c3 3 7.1 4.7 11.3 4.7L473.4 96 256 313.4 256 176c0-4.2-1.7-8.3-4.7-11.3l-40-40c-20.3-20.3-20.3-53.1 0-73.4z", "M307.3 28.7c-32.8-32.8-85.9-32.8-118.6 0s-32.8 85.9 0 118.6l12.7 12.7-84.7 84.7c-4 4-5.6 9.9-4.1 15.4L171.2 480 16 480c-8.8 0-16 7.2-16 16s7.2 16 16 16l352 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-163.7 0-58.5-219.2 78.2-78.2 0 142.1c0 15.1 12.2 27.3 27.3 27.3 7.2 0 14.2-2.9 19.3-8L504 110.6c5.1-5.1 8-12.1 8-19.3 0-15.1-12.2-27.3-27.3-27.3l-142.1 0-35.3-35.3zm-96 22.6c20.3-20.3 53.1-20.3 73.4 0l40 40c3 3 7.1 4.7 11.3 4.7L473.4 96 256 313.4 256 176c0-4.2-1.7-8.3-4.7-11.3l-40-40c-20.3-20.3-20.3-53.1 0-73.4z"]],
    "person-half-dress": [384, 512, [], "e548", ["M108.1 352l62-190.5c1.2-3.7 3.3-6.9 5.9-9.5l0 199.9-67.9 0zM168 24c0-13.3 10.7-24 24-24 0 16 0 32 0 48-13.3 0-24-10.7-24-24z", "M216 24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm-80 0a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zM124.6 197.9L44.5 298c-5.5 6.9-15.6 8-22.5 2.5s-8-15.6-2.5-22.5L128.3 142c12.1-15.1 29-25.1 47.7-28.6l0 38.7c-2.7 2.6-4.7 5.8-5.9 9.5l-62 190.5 67.9 0 0 32-16 0 0 144c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-144-42 0c-10.9 0-18.6-10.6-15.2-21l53.7-165.1zM240 368l-32 0 0-32 32 0 0-179.3c-9.8-5.6-20.7-9.5-32-11.4l0-32.3c39 4.9 74.1 27.4 94.7 61.7l63.1 105.1c4.5 7.6 2.1 17.4-5.5 21.9s-17.4 2.1-22-5.5L275.2 191.1c-1-1.7-2.1-3.4-3.2-5L272 528c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-160z"]],
    "peanut": [512, 512, [], "e430", ["M32 362.9c0-38 16.9-74 46.1-98.3l5.1-4.2c17.5-14.6 38.5-24.2 60.9-27.9l19.4-3.2c33.7-5.6 60.1-32 65.8-65.8l1.1-6.5c4.9-29.6 19-56.9 40.2-78.2l4.6-4.6c27-27 63.6-42.2 101.8-42.2L432 32c26.5 0 48 21.5 48 48l0 55.1c0 38.2-15.2 74.8-42.2 101.8l-4.6 4.6c-21.2 21.2-48.5 35.3-78.2 40.2l-6.5 1.1c-33.7 5.6-60.1 32-65.8 65.8l-1.9 11.6c-4.4 26.3-16.9 50.6-35.7 69.5l-12.9 12.9c-24 24-56.6 37.5-90.5 37.5L80 480c-26.5 0-48-21.5-48-48l0-69.1zM108.8 416a19.2 19.2 0 1 0 38.4 0 19.2 19.2 0 1 0 -38.4 0zm64-64a19.2 19.2 0 1 0 38.4 0 19.2 19.2 0 1 0 -38.4 0zm0 64a19.2 19.2 0 1 0 38.4 0 19.2 19.2 0 1 0 -38.4 0zm160-224a19.2 19.2 0 1 0 38.4 0 19.2 19.2 0 1 0 -38.4 0zm64-64a19.2 19.2 0 1 0 38.4 0 19.2 19.2 0 1 0 -38.4 0zm0 64a19.2 19.2 0 1 0 38.4 0 19.2 19.2 0 1 0 -38.4 0z", "M32 362.9L32 432c0 26.5 21.5 48 48 48l61.7 0c33.9 0 66.5-13.5 90.5-37.5l12.9-12.9c18.9-18.9 31.4-43.2 35.7-69.5l1.9-11.6c5.6-33.7 32-60.1 65.8-65.8l6.5-1.1c29.6-4.9 56.9-19 78.2-40.2l4.6-4.6c27-27 42.2-63.6 42.2-101.8L480 80c0-26.5-21.5-48-48-48l-55.1 0c-38.2 0-74.8 15.2-101.8 42.2l-4.6 4.6c-21.2 21.2-35.3 48.5-40.2 78.2l-1.1 6.5c-5.6 33.7-32 60.1-65.8 65.8l-19.4 3.2c-22.4 3.7-43.4 13.4-60.9 27.9l-5.1 4.2C48.9 288.9 32 325 32 362.9zM0 432l0-69.1C0 315.5 21.1 270.4 57.6 240l5.1-4.2c21.8-18.2 48.1-30.2 76.1-34.9l19.4-3.2c20.2-3.4 36.1-19.2 39.5-39.5l1.1-6.5c6-36.2 23.2-69.6 49.2-95.5l4.6-4.6C285.5 18.5 330.2 0 376.9 0L432 0c44.2 0 80 35.8 80 80l0 55.1c0 46.7-18.5 91.4-51.5 124.5l-4.6 4.6c-25.9 25.9-59.3 43.1-95.5 49.2l-6.5 1.1c-20.2 3.4-36.1 19.2-39.5 39.5l-1.9 11.6c-5.5 32.9-21.1 63.3-44.7 86.8l-12.9 12.9c-30 30-70.7 46.9-113.1 46.9L80 512c-44.2 0-80-35.8-80-80zm108.8-16a19.2 19.2 0 1 1 38.4 0 19.2 19.2 0 1 1 -38.4 0zM352 172.8a19.2 19.2 0 1 1 0 38.4 19.2 19.2 0 1 1 0-38.4zM172.8 416a19.2 19.2 0 1 1 38.4 0 19.2 19.2 0 1 1 -38.4 0zM416 172.8a19.2 19.2 0 1 1 0 38.4 19.2 19.2 0 1 1 0-38.4zM172.8 352a19.2 19.2 0 1 1 38.4 0 19.2 19.2 0 1 1 -38.4 0zM416 108.8a19.2 19.2 0 1 1 0 38.4 19.2 19.2 0 1 1 0-38.4z"]],
    "message-plus": [512, 512, ["comment-alt-plus"], "f4a8", ["M32 128l0 224c0 35.3 28.7 64 64 64l40 0c13.3 0 24 10.7 24 24l0 68 112-84c6.9-5.2 15.3-8 24-8l120 0c35.3 0 64-28.7 64-64l0-224c0-35.3-28.7-64-64-64L96 64c-35.3 0-64 28.7-64 64zM168 240c0-8.8 7.2-16 16-16l56 0 0-56c0-8.8 7.2-16 16-16s16 7.2 16 16l0 56 56 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-56 0 0 56c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-56-56 0c-8.8 0-16-7.2-16-16z", "M179.2 533.6l0 0 112-84c1.4-1 3.1-1.6 4.8-1.6l120 0c53 0 96-43 96-96l0-224c0-53-43-96-96-96L96 32C43 32 0 75 0 128L0 352c0 53 43 96 96 96l32 0 0 68c0 15.5 12.5 28 28 28 6.1 0 12-2 16.8-5.6l6.4-4.8zM160 448l0-8c0-13.3-10.7-24-24-24l-40 0c-35.3 0-64-28.7-64-64l0-224c0-35.3 28.7-64 64-64l320 0c35.3 0 64 28.7 64 64l0 224c0 35.3-28.7 64-64 64l-120 0c-8.7 0-17.1 2.8-24 8l-112 84 0-60zm80-136c0 8.8 7.2 16 16 16s16-7.2 16-16l0-56 56 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-56 0 0-56c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 56-56 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l56 0 0 56z"]],
    "bracket-curly": [256, 512, ["bracket-curly-left"], "7b", ["", "M64 112c0-44.2 35.8-80 80-80l64 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-64 0c-26.5 0-48 21.5-48 48l0 53.5c0 21.2-8.4 41.6-23.4 56.6L38.6 256 72.6 289.9c15 15 23.4 35.4 23.4 56.6L96 400c0 26.5 21.5 48 48 48l64 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-64 0c-44.2 0-80-35.8-80-80l0-53.5c0-12.7-5.1-24.9-14.1-33.9L4.7 267.3c-3-3-4.7-7.1-4.7-11.3s1.7-8.3 4.7-11.3l45.3-45.3c9-9 14.1-21.2 14.1-33.9L64 112z"]],
    "square-poll-horizontal": [448, 512, ["poll-h"], "f682", ["M32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64C46.3 64 32 78.3 32 96zm64 64c0-8.8 7.2-16 16-16l128 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-128 0c-8.8 0-16-7.2-16-16zm0 96c0-8.8 7.2-16 16-16l224 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-224 0c-8.8 0-16-7.2-16-16zm0 96c0-8.8 7.2-16 16-16l64 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-64 0c-8.8 0-16-7.2-16-16z", "M64 64C46.3 64 32 78.3 32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm256 64c0 8.8-7.2 16-16 16l-128 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l128 0c8.8 0 16 7.2 16 16zm80 80c8.8 0 16 7.2 16 16s-7.2 16-16 16l-224 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l224 0zM192 352c0 8.8-7.2 16-16 16l-64 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l64 0c8.8 0 16 7.2 16 16z"]],
    "nfc-signal": [576, 512, [], "e1fb", ["M64 96c0-17.7 14.3-32 32-32l320 0c17.7 0 32 14.3 32 32l0 163.5c-23 9.1-44.5 21.2-64 35.8L384 160c0-17.7-14.3-32-32-32l-80 0c-17.7 0-32 14.3-32 32l0 50.7c-18.6 6.6-32 24.4-32 45.3 0 26.5 21.5 48 48 48s48-21.5 48-48c0-20.9-13.4-38.7-32-45.3l0-50.7 80 0 0 163.3c-8.9 9-17.1 18.6-24.7 28.7l-167.3 0 0-192 16 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0c-17.7 0-32 14.3-32 32l0 192c0 17.7 14.3 32 32 32l146.6 0c-11 20-19.7 41.4-25.6 64L96 448c-17.7 0-32-14.3-32-32L64 96z", "M416 64L96 64C78.3 64 64 78.3 64 96l0 320c0 17.7 14.3 32 32 32l185 0c-2.7 10.4-4.9 21.1-6.4 32L96 480c-35.3 0-64-28.7-64-64L32 96c0-35.3 28.7-64 64-64l320 0c35.3 0 64 28.7 64 64l0 153c-10.9 2.9-21.6 6.4-32 10.5L448 96c0-17.7-14.3-32-32-32zm-32 96l0 135.3c-11.4 8.5-22.1 17.8-32 27.9l0-163.3-80 0 0 50.7c18.6 6.6 32 24.4 32 45.3 0 26.5-21.5 48-48 48s-48-21.5-48-48c0-20.9 13.4-38.7 32-45.3l0-50.7c0-17.7 14.3-32 32-32l80 0c17.7 0 32 14.3 32 32zM306.6 384L160 384c-17.7 0-32-14.3-32-32l0-192c0-17.7 14.3-32 32-32l16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0 0 192 167.3 0c-7.6 10.2-14.5 20.8-20.7 32zM256 240a16 16 0 1 0 0 32 16 16 0 1 0 0-32zm304 48c8.8 0 16 7.2 16 16s-7.2 16-16 16c-114.9 0-208 93.1-208 208 0 8.8-7.2 16-16 16s-16-7.2-16-16c0-132.5 107.5-240 240-240zM544 480a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm32-80c0 8.8-7.2 16-16 16-61.9 0-112 50.1-112 112 0 8.8-7.2 16-16 16s-16-7.2-16-16c0-79.5 64.5-144 144-144 8.8 0 16 7.2 16 16z"]],
    "box-isometric": [512, 512, [], "e797", ["M48.5 165.1l0 181.7c0 17.2 9.2 33.1 24.2 41.7l160 91.4c2.5 1.4 5.2 2.6 7.8 3.6l0-218.3-191.2-109.2c-.6 3-.9 6-.9 9.1zm17-36.7l191 109.1 79.8-45.6-191.8-109.6-71.8 41c-2.6 1.5-5 3.1-7.2 5zM176.7 64l191.8 109.6 79-45.1c-2.2-1.9-4.6-3.5-7.2-5L280.3 32c-14.8-8.4-32.9-8.4-47.7 0l-56 32zm95.8 201.3l0 218.3c2.7-.9 5.3-2.1 7.8-3.6l160-91.4c15-8.6 24.2-24.5 24.2-41.7l0-181.7c0-3.1-.3-6.1-.9-9.1L272.4 265.3z", "M232.6 480c2.5 1.4 5.2 2.6 7.8 3.6l0-218.3-191.2-109.2c-.6 3-.9 6-.9 9.1l0 181.7c0 17.2 9.2 33.1 24.2 41.7l160 91.4zm47.7 0l160-91.4c15-8.6 24.2-24.5 24.2-41.7l0-181.7c0-3.1-.3-6.1-.9-9.1l-191.2 109.2 0 218.3c2.7-.9 5.3-2.1 7.8-3.6zm88.2-306.4l79-45.1c-2.2-1.9-4.6-3.5-7.2-5L280.3 32c-14.8-8.4-32.9-8.4-47.7 0l-56 32 191.8 109.6zM336.3 192l-191.8-109.6-71.8 41c-2.6 1.5-5 3.1-7.2 5l191 109.1 79.8-45.6zM296.1 507.7c-24.6 14.1-54.8 14.1-79.4 0l-160-91.4c-24.9-14.2-40.3-40.7-40.3-69.4l0-181.7c0-28.7 15.4-55.2 40.3-69.4l160-91.4c24.6-14.1 54.8-14.1 79.4 0l160 91.4c24.9 14.2 40.3 40.7 40.3 69.4l0 181.7c0 28.7-15.4 55.2-40.3 69.4l-160 91.4z"]],
    "school-circle-xmark": [640, 512, [], "e56d", ["M32 192c0-17.7 14.3-32 32-32l72 0c3.6 0 7.1-1.2 9.9-3.4L288 44.4 430.1 156.6c2.8 2.2 6.3 3.4 9.9 3.4l72 0c17.7 0 32 14.3 32 32l0 22c-15.3-3.9-31.4-6-48-6-84 0-155.5 54-181.5 129.2-3.4-.8-6.9-1.2-10.5-1.2l-32 0c-26.5 0-48 21.5-48 48l0 96-160 0c-17.7 0-32-14.3-32-32l0-256zm64 64l0 16c0 8.8 7.2 16 16 16l16 0c8.8 0 16-7.2 16-16l0-16c0-8.8-7.2-16-16-16l-16 0c-8.8 0-16 7.2-16 16zm0 112l0 16c0 8.8 7.2 16 16 16l16 0c8.8 0 16-7.2 16-16l0-16c0-8.8-7.2-16-16-16l-16 0c-8.8 0-16 7.2-16 16zM224 192a64 64 0 1 0 128 0 64 64 0 1 0 -128 0z", "M268.2 19.3c11.6-9.2 28-9.2 39.7 0L445.6 128 512 128c35.3 0 64 28.7 64 64l0 33.4c-10.2-4.7-20.9-8.5-32-11.4l0-22c0-17.7-14.3-32-32-32l-72 0c-3.6 0-7.1-1.2-9.9-3.4L288 44.4 145.9 156.6c-2.8 2.2-6.3 3.4-9.9 3.4l-72 0c-17.7 0-32 14.3-32 32l0 256c0 17.7 14.3 32 32 32l160 0 0-96c0-26.5 21.5-48 48-48l32 0c3.6 0 7.1 .4 10.5 1.2-3.5 10-6.1 20.4-7.9 31.1-.9-.1-1.7-.2-2.6-.2l-32 0c-8.8 0-16 7.2-16 16l0 96 64 0 0 0 1.4 0c5.2 11.3 11.4 22 18.6 32L64 512c-35.3 0-64-28.7-64-64L0 192c0-35.3 28.7-64 64-64l66.4 0 137.7-108.7zM144 384c0 8.8-7.2 16-16 16l-16 0c-8.8 0-16-7.2-16-16l0-16c0-8.8 7.2-16 16-16l16 0c8.8 0 16 7.2 16 16l0 16zm-16-96l-16 0c-8.8 0-16-7.2-16-16l0-16c0-8.8 7.2-16 16-16l16 0c8.8 0 16 7.2 16 16l0 16c0 8.8-7.2 16-16 16zm160-64a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm0-96a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM608 400a112 112 0 1 0 -224 0 112 112 0 1 0 224 0zm-256 0a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm203.3-36.7l-36.7 36.7 36.7 36.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-36.7-36.7-36.7 36.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l36.7-36.7-36.7-36.7c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l36.7 36.7 36.7-36.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6z"]],
    "person-seat-window": [448, 512, [], "e788", ["M128 224l0 80c0 26.5 21.5 48 48 48l16 0 0-128c0-17.7-14.3-32-32-32s-32 14.3-32 32zm8-152a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zM320 96l0 96c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-96c0-17.7-14.3-32-32-32l-32 0c-17.7 0-32 14.3-32 32z", "M184 72a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm-80 0a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm24 152l0 80c0 26.5 21.5 48 48 48l16 0 0-128c0-17.7-14.3-32-32-32s-32 14.3-32 32zm96 0l0 128 16 0c35.3 0 64 28.7 64 64l0 64 32 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16l0-80c0-17.7-14.3-32-32-32l-64 0c-44.2 0-80-35.8-80-80l0-80c0-35.3 28.7-64 64-64s64 28.7 64 64zM32 160c8.8 0 16 7.2 16 16l0 176c0 44.2 35.8 80 80 80l80 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-80 0C66.1 464 16 413.9 16 352l0-176c0-8.8 7.2-16 16-16zM352 64c-17.7 0-32 14.3-32 32l0 96c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-96c0-17.7-14.3-32-32-32l-32 0zM288 96c0-35.3 28.7-64 64-64l32 0c35.3 0 64 28.7 64 64l0 96c0 35.3-28.7 64-64 64l-32 0c-35.3 0-64-28.7-64-64l0-96z"]],
    "grapes": [576, 512, [], "e306", ["M79.4 420.9a44.1 44.1 0 1 0 88.1 0 44.1 44.1 0 1 0 -88.1 0zm30-120.1a44.1 44.1 0 1 0 88.1 0 44.1 44.1 0 1 0 -88.1 0zm30-120.1a44.1 44.1 0 1 0 88.1 0 44.1 44.1 0 1 0 -88.1 0zm60.1 210.2a44.1 44.1 0 1 0 88.1 0 44.1 44.1 0 1 0 -88.1 0zm30-120.1a44.1 44.1 0 1 0 88.1 0 44.1 44.1 0 1 0 -88.1 0zm30-120.1a44.1 44.1 0 1 0 88.1 0 44.1 44.1 0 1 0 -88.1 0zm60.1 210.2a44.1 44.1 0 1 0 88.1 0 44.1 44.1 0 1 0 -88.1 0zm30-120.1a44.1 44.1 0 1 0 88.1 0 44.1 44.1 0 1 0 -88.1 0zM383 33.8C360 56.8 360 94.2 383 117.3l10.7 10.7 10.7-10.7c23.1-23.1 23.1-60.5 0-83.5L393.7 23.1 383 33.8zm33.3 116.8L427 161.3c23.1 23.1 60.5 23.1 83.5 0l10.7-10.7-10.7-10.7c-23.1-23.1-60.5-23.1-83.5 0l-10.7 10.7z", "M415.6-.2c-12.1-12.1-31.7-12.1-43.9 0L360.4 11.1c-19.1 19.1-28 44.6-26.5 69.7-9.3-4-19.5-6.3-30.3-6.3-32.2 0-59.7 20-70.8 48.2-13.3-11.3-30.5-18.2-49.3-18.2-42 0-76.1 34.1-76.1 76.1 0 18.8 6.8 36 18.2 49.3-28.2 11.1-48.2 38.6-48.2 70.8 0 18.8 6.8 36 18.2 49.3-28.2 11.1-48.2 38.6-48.2 70.8 0 42 34.1 76.1 76.1 76.1 32.2 0 59.7-20 70.8-48.2 13.3 11.3 30.5 18.2 49.3 18.2 32.2 0 59.7-20 70.8-48.2 13.3 11.3 30.5 18.2 49.3 18.2 42 0 76.1-34.1 76.1-76.1 0-18.8-6.8-36-18.2-49.3 28.2-11.1 48.2-38.6 48.2-70.8 0-10.8-2.2-21-6.3-30.3 25 1.4 50.5-7.4 69.7-26.5l11.4-11.4c12.1-12.1 12.1-31.7 0-43.9l-11.4-11.4c-22-22-52.5-30.4-81-25.2 5.3-28.5-3.1-59-25.2-81L415.6-.2zM404.4 117.3L393.7 128 383 117.3C360 94.2 360 56.8 383 33.8l10.7-10.7 10.7 10.7c23.1 23.1 23.1 60.5 0 83.5zm12 33.3L427 139.9c23.1-23.1 60.5-23.1 83.5 0l10.7 10.7-10.7 10.7c-23.1 23.1-60.5 23.1-83.5 0l-10.7-10.7zM303.6 194.7a44.1 44.1 0 1 1 0-88.1 44.1 44.1 0 1 1 0 88.1zm-120.1 30a44.1 44.1 0 1 1 0-88.1 44.1 44.1 0 1 1 0 88.1zm210.2 60.1a44.1 44.1 0 1 1 0-88.1 44.1 44.1 0 1 1 0 88.1zm-120.1 30a44.1 44.1 0 1 1 0-88.1 44.1 44.1 0 1 1 0 88.1zm-120.1 30a44.1 44.1 0 1 1 0-88.1 44.1 44.1 0 1 1 0 88.1zm210.2 60.1a44.1 44.1 0 1 1 0-88.1 44.1 44.1 0 1 1 0 88.1zm-120.1 30a44.1 44.1 0 1 1 0-88.1 44.1 44.1 0 1 1 0 88.1zm-120.1 30a44.1 44.1 0 1 1 0-88.1 44.1 44.1 0 1 1 0 88.1z"]],
    "hand-lizard": [512, 512, [], "f258", ["M32 120c0-13.3 10.7-24 24-24l230.6 0c25.8 0 50.1 12.5 65.1 33.5L465.1 288.3c9.7 13.6 14.9 29.8 14.9 46.5l0 97.2c0 8.8 7.2 16 16 16l-128 0c8.8 0 16-7.2 16-16l0-32c0-5.4-2.7-10.3-7.1-13.3l-96-64c-2.6-1.8-5.7-2.7-8.9-2.7l-152 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l136 0c35.3 0 64-28.7 64-64s-28.7-64-64-64L56 144c-13.3 0-24-10.7-24-24z", "M0 120C0 89.1 25.1 64 56 64l230.6 0c36.2 0 70.1 17.5 91.1 46.9L491.1 269.7c13.6 19 20.9 41.8 20.9 65.1l0 97.2c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-97.2c0-16.7-5.2-32.9-14.9-46.5L351.7 129.5c-15-21-39.3-33.5-65.1-33.5L56 96c-13.3 0-24 10.7-24 24s10.7 24 24 24l200 0c35.3 0 64 28.7 64 64s-28.7 64-64 64l-136 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l152 0c3.2 0 6.2 .9 8.9 2.7l96 64c4.4 3 7.1 8 7.1 13.3l0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-23.4-84.8-56.6-147.2 0c-30.9 0-56-25.1-56-56s25.1-56 56-56l136 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L56 176c-30.9 0-56-25.1-56-56z"]],
    "camera-slash": [576, 512, [], "e0d9", ["M175.7 121.2c.3-.4 .5-.8 .7-1.2l28.1-48.1c2.9-4.9 8.1-7.9 13.8-7.9l139.2 0c5.7 0 11 3 13.8 7.9l28.1 48.1c2.9 4.9 8.1 7.9 13.8 7.9l66.7 0c17.7 0 32 14.3 32 32l0 256c0 11.3-5.8 21.2-14.6 26.9L389.6 335.1c6.6-14.3 10.4-30.3 10.4-47.1 0-61.9-50.1-112-112-112-16.8 0-32.8 3.7-47.1 10.4l-65.1-65.1z", "M27.3-27.2c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l544 544c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-51-51C534.7 454 544 436.1 544 416l0-256c0-35.3-28.7-64-64-64l-57.5 0-23.4-40.2C390.5 41.1 374.7 32 357.6 32L218.4 32c-17.1 0-32.9 9.1-41.5 23.8L153.5 96 150.5 96 27.3-27.2zM175.7 121.2c.3-.4 .5-.8 .7-1.2l28.1-48.1c2.9-4.9 8.1-7.9 13.8-7.9l139.2 0c5.7 0 11 3 13.8 7.9l28.1 48.1c2.9 4.9 8.1 7.9 13.8 7.9l66.7 0c17.7 0 32 14.3 32 32l0 256c0 11.3-5.8 21.2-14.6 26.9L389.6 335.1c6.6-14.3 10.4-30.3 10.4-47.1 0-61.9-50.1-112-112-112-16.8 0-32.8 3.7-47.1 10.4l-65.1-65.1zM364.8 310.3l-99.2-99.2c7.1-2.1 14.6-3.2 22.3-3.2 44.2 0 80 35.8 80 80 0 7.7-1.1 15.2-3.2 22.3zM32 160l0 256c0 35.3 28.7 64 64 64l325.5 0-32-32-293.5 0c-17.7 0-32-14.3-32-32l0-256c0-10.2 4.8-19.3 12.3-25.2L53.6 112.1C40.3 123.8 32 140.9 32 160zM176 288c0 61.9 50.1 112 112 112 15.8 0 30.8-3.3 44.4-9.1l-25.2-25.2c-6.1 1.5-12.6 2.3-19.2 2.3-44.2 0-80-35.8-80-80 0-6.6 .8-13 2.3-19.2l-25.2-25.2c-5.9 13.6-9.1 28.6-9.1 44.4z"]],
    "chalkboard": [576, 512, ["blackboard"], "f51b", ["M64 120c0-13.3 10.7-24 24-24l400 0c13.3 0 24 10.7 24 24l0 296-64 0 0-48c0-26.5-21.5-48-48-48l-96 0c-26.5 0-48 21.5-48 48l0 48-192 0 0-296z", "M64 120l0 296 192 0 0-48c0-26.5 21.5-48 48-48l96 0c26.5 0 48 21.5 48 48l0 48 64 0 0-296c0-13.3-10.7-24-24-24L88 96c-13.3 0-24 10.7-24 24zM32 416l0-296c0-30.9 25.1-56 56-56l400 0c30.9 0 56 25.1 56 56l0 296 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L16 448c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0zm384-48c0-8.8-7.2-16-16-16l-96 0c-8.8 0-16 7.2-16 16l0 48 128 0 0-48z"]],
    "memo-pad": [384, 512, [], "e1da", ["M32 128l0 320c0 17.7 14.3 32 32 32l256 0c17.7 0 32-14.3 32-32l0-320-320 0zm64 80c0-8.8 7.2-16 16-16l160 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-160 0c-8.8 0-16-7.2-16-16zm0 96c0-8.8 7.2-16 16-16l160 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-160 0c-8.8 0-16-7.2-16-16zm0 96c0-8.8 7.2-16 16-16l96 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16z", "M320 32c17.7 0 32 14.3 32 32l0 32-320 0 0-32c0-17.7 14.3-32 32-32l256 0zm32 96l0 320c0 17.7-14.3 32-32 32L64 480c-17.7 0-32-14.3-32-32l0-320 320 0zM64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-384c0-35.3-28.7-64-64-64L64 0zM96 208c0 8.8 7.2 16 16 16l160 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-160 0c-8.8 0-16 7.2-16 16zm0 96c0 8.8 7.2 16 16 16l160 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-160 0c-8.8 0-16 7.2-16 16zm0 96c0 8.8 7.2 16 16 16l96 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-96 0c-8.8 0-16 7.2-16 16z"]],
    "bluetooth": [320, 512, [], "f293", ["M176 51.6l103 91.6-103 80.1 0-171.7zm0 237.1l103 80.1-103 91.6 0-171.7z", "M153.4 1.4c5.7-2.6 12.5-1.5 17.2 2.6l144 128c3.6 3.2 5.5 7.7 5.4 12.5s-2.4 9.2-6.2 12.1L186.1 256 313.8 355.4c3.8 2.9 6 7.4 6.2 12.1s-1.8 9.3-5.4 12.5l-144 128c-4.7 4.2-11.4 5.2-17.2 2.6S144 502.3 144 496l0-207.3-118.2 91.9c-7 5.4-17 4.2-22.5-2.8s-4.2-17 2.8-22.5L133.9 256 6.2 156.6c-7-5.4-8.2-15.5-2.8-22.5s15.5-8.2 22.5-2.8L144 223.3 144 16c0-6.3 3.7-12 9.4-14.6zM176 288.7l0 171.7 103-91.6-103-80.1zm0-65.4l103-80.1-103-91.6 0 171.7z"]],
    "objects-align-center-horizontal": [448, 512, [], "e3bc", ["M32 112l0 64c0 8.8 7.2 16 16 16l352 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16L48 96c-8.8 0-16 7.2-16 16zM96 336l0 64c0 8.8 7.2 16 16 16l224 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16l-224 0c-8.8 0-16 7.2-16 16z", "M240-16c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 80-160 0C21.5 64 0 85.5 0 112l0 64c0 26.5 21.5 48 48 48l160 0 0 64-96 0c-26.5 0-48 21.5-48 48l0 64c0 26.5 21.5 48 48 48l96 0 0 80c0 8.8 7.2 16 16 16s16-7.2 16-16l0-80 96 0c26.5 0 48-21.5 48-48l0-64c0-26.5-21.5-48-48-48l-96 0 0-64 160 0c26.5 0 48-21.5 48-48l0-64c0-26.5-21.5-48-48-48l-160 0 0-80zM416 176c0 8.8-7.2 16-16 16L48 192c-8.8 0-16-7.2-16-16l0-64c0-8.8 7.2-16 16-16l352 0c8.8 0 16 7.2 16 16l0 64zM352 400c0 8.8-7.2 16-16 16l-224 0c-8.8 0-16-7.2-16-16l0-64c0-8.8 7.2-16 16-16l224 0c8.8 0 16 7.2 16 16l0 64z"]],
    "distribute-spacing-vertical": [512, 512, [], "e366", ["M128 208l0 96c0 8.8 7.2 16 16 16l224 0c8.8 0 16-7.2 16-16l0-96c0-8.8-7.2-16-16-16l-224 0c-8.8 0-16 7.2-16 16z", "M512 464c0-8.8-7.2-16-16-16L16 448c-8.8 0-16 7.2-16 16s7.2 16 16 16l480 0c8.8 0 16-7.2 16-16zM144 320c-8.8 0-16-7.2-16-16l0-96c0-8.8 7.2-16 16-16l224 0c8.8 0 16 7.2 16 16l0 96c0 8.8-7.2 16-16 16l-224 0zm224 32c26.5 0 48-21.5 48-48l0-96c0-26.5-21.5-48-48-48l-224 0c-26.5 0-48 21.5-48 48l0 96c0 26.5 21.5 48 48 48l224 0zM496 64c8.8 0 16-7.2 16-16s-7.2-16-16-16L16 32C7.2 32 0 39.2 0 48S7.2 64 16 64l480 0z"]],
    "up-right-from-square": [512, 512, ["external-link-alt"], "f35d", ["M331.4 32l148.8 148.7 0-148.7-148.8 0z", "M480.2 32l-148.8 0 148.8 148.7 0-148.7zm8-32c13.3 0 24 10.7 24 24l0 176c0 9.7-5.8 18.5-14.8 22.2s-19.3 1.7-26.2-5.2l-76.8-76.7-175.1 175.1c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l175.1-175-76.7-76.7c-6.9-6.9-8.9-17.2-5.2-26.2S302.4 0 312.1 0L488.2 0zM.1 176c0-44.2 35.8-80 80-80l96 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0c-26.5 0-48 21.5-48 48l0 256c0 26.5 21.5 48 48 48l256 0c26.5 0 48-21.5 48-48l0-96c0-8.8 7.2-16 16-16s16 7.2 16 16l0 96c0 44.2-35.8 80-80 80l-256 0c-44.2 0-80-35.8-80-80l0-256z"]],
    "square-turkish-lira": [448, 512, [], "e71f", ["M32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64C46.3 64 32 78.3 32 96zm80.8 149.1c-2.8-8.4 1.7-17.4 10.1-20.2l37.1-12.4 0-68.5c0-8.8 7.2-16 16-16s16 7.2 16 16l0 57.8 74.9-25c8.4-2.8 17.4 1.7 20.2 10.1s-1.7 17.4-10.1 20.2l-85.1 28.4 0 30.3 74.9-25c8.4-2.8 17.4 1.7 20.2 10.1s-1.7 17.4-10.1 20.2l-85.1 28.4 0 52.5 48 0c35.3 0 64-28.7 64-64 0-8.8 7.2-16 16-16s16 7.2 16 16c0 53-43 96-96 96l-64 0c-8.8 0-16-7.2-16-16l0-57.8-26.9 9c-8.4 2.8-17.4-1.7-20.2-10.1s1.7-17.4 10.1-20.2l37.1-12.4 0-30.3-26.9 9c-8.4 2.8-17.4-1.7-20.2-10.1z", "M64 64C46.3 64 32 78.3 32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm176 32c8.8 0 16 7.2 16 16l0 57.8 74.9-25c8.4-2.8 17.4 1.7 20.2 10.1s-1.7 17.4-10.1 20.2l-85.1 28.4 0 30.3 74.9-25c8.4-2.8 17.4 1.7 20.2 10.1s-1.7 17.4-10.1 20.2l-85.1 28.4 0 52.5 48 0c35.3 0 64-28.7 64-64 0-8.8 7.2-16 16-16s16 7.2 16 16c0 53-43 96-96 96l-64 0c-8.8 0-16-7.2-16-16l0-57.8-26.9 9c-8.4 2.8-17.4-1.7-20.2-10.1s1.7-17.4 10.1-20.2l37.1-12.4 0-30.3-26.9 9c-8.4 2.8-17.4-1.7-20.2-10.1s1.7-17.4 10.1-20.2l37.1-12.4 0-68.5c0-8.8 7.2-16 16-16z"]],
    "rotate-exclamation": [512, 512, [], "e23c", ["", "M496.5 256c8.8 .6 15.5 8.2 14.9 17-4 59.7-28.8 118.3-74.4 164-50 50-115.5 75-181 75-70.8 0-138.4-29.2-187-80.6L32 392.2 32 496c0 8.8-7.2 16-16 16S0 504.8 0 496L0 352c0-8.8 7.2-16 16-16l128 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-90.9 0 39.1 41.4c42.6 45.1 101.8 70.6 163.8 70.6 57.4 0 114.7-21.9 158.4-65.6 39.9-39.9 61.6-91.2 65.1-143.5 .6-8.8 8.2-15.5 17-14.9zM256 384a24 24 0 1 1 0-48 24 24 0 1 1 0 48zm0-256c13.5 0 24.3 11.4 23.5 24.9l-7.6 136c-.5 8.5-7.5 15.1-16 15.1s-15.5-6.6-16-15.1l-7.6-136c-.8-13.5 10-24.9 23.5-24.9zM496 0c8.8 0 16 7.2 16 16l0 144c0 8.8-7.2 16-16 16l-128 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l90.9 0-39.1-41.4C377.2 57.5 318 32 256 32 198.6 32 141.3 53.9 97.6 97.6 57.6 137.5 36 188.8 32.5 241.1 31.9 249.9 24.3 256.6 15.5 256S0 247.8 .6 238.9C4.5 179.2 29.3 120.6 75 75 125 25 190.5 0 256 0 326.8 0 394.4 29.2 443 80.6l37 39.1 0-103.8c0-8.8 7.2-16 16-16z"]],
    "right-from-line": [512, 512, ["arrow-alt-from-left"], "f347", ["M160 240l0 32c0 8.8 7.2 16 16 16l160 0c8.8 0 16 7.2 16 16L352 380.7 476.7 256 352 131.3 352 208c0 8.8-7.2 16-16 16l-160 0c-8.8 0-16 7.2-16 16z", "M505 273l0 0c9.4-9.4 9.4-24.6 0-33.9l0 0-144-144c-6.9-6.9-17.2-8.9-26.2-5.2S320 102.3 320 112l0 80-144 0c-26.5 0-48 21.5-48 48l0 32c0 26.5 21.5 48 48 48l144 0 0 80c0 9.7 5.8 18.5 14.8 22.2s19.3 1.7 26.2-5.2L505 273zM256 224l80 0c8.8 0 16-7.2 16-16L352 131.3 476.7 256 352 380.7 352 304c0-8.8-7.2-16-16-16l-160 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l80 0zM16 64C7.2 64 0 71.2 0 80L0 432c0 8.8 7.2 16 16 16s16-7.2 16-16L32 80c0-8.8-7.2-16-16-16z"]],
    "circle-q": [512, 512, [], "e11e", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm121.3 0c0-56.7 46-102.7 102.7-102.7s102.7 46 102.7 102.7c0 23.1-7.6 44.3-20.4 61.5l16.1 16.1c5.7 5.7 5.7 15 0 20.7s-15 5.7-20.7 0l-16.1-16.1c-17.1 12.8-38.4 20.4-61.5 20.4-56.7 0-102.7-46-102.7-102.7zm29.3 0c0 40.5 32.8 73.3 73.3 73.3 14.9 0 28.8-4.5 40.4-12.2l-34.8-34.8c-5.7-5.7-5.7-15 0-20.7s15-5.7 20.7 0l34.8 34.8c7.7-11.6 12.2-25.5 12.2-40.4 0-40.5-32.8-73.3-73.3-73.3s-73.3 32.8-73.3 73.3z", "M256 32a224 224 0 1 1 0 448 224 224 0 1 1 0-448zm0 480a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM182.7 256c0-40.5 32.8-73.3 73.3-73.3s73.3 32.8 73.3 73.3c0 14.9-4.5 28.8-12.2 40.4l-34.8-34.8c-5.7-5.7-15-5.7-20.7 0s-5.7 15 0 20.7l34.8 34.8c-11.6 7.7-25.5 12.2-40.4 12.2-40.5 0-73.3-32.8-73.3-73.3zm176 0c0-56.7-46-102.7-102.7-102.7s-102.7 46-102.7 102.7 46 102.7 102.7 102.7c23.1 0 44.3-7.6 61.5-20.4l16.1 16.1c5.7 5.7 15 5.7 20.7 0s5.7-15 0-20.7l-16.1-16.1c12.8-17.1 20.4-38.4 20.4-61.5z"]],
    "moon-over-sun": [576, 512, ["eclipse-alt"], "f74a", ["M57.6 160.5l51.7 77.9c7.1 10.7 7.1 24.7 0 35.4l-51.7 77.9 91.6 18.5c12.6 2.6 22.5 12.4 25 25l18.5 91.6 77.9-51.7c10.7-7.1 24.7-7.1 35.4 0l77.9 51.7 18.5-91.6c2.6-12.6 12.4-22.5 25-25l91.6-18.5-51.7-77.9c-7.1-10.7-7.1-24.7 0-35.4l51.7-77.9-91.6-18.5c-12.6-2.6-22.5-12.4-25-25L383.8 25.3 306 77c-10.7 7.1-24.7 7.1-35.4 0l-77.9-51.7-18.5 91.6c-2.6 12.6-12.4 22.5-25 25L57.6 160.5zM399.7 256a111.7 111.7 0 1 1 -223.5 0 111.7 111.7 0 1 1 223.5 0zM296.3 232c0 34.5 27.2 62.5 61.3 63.9 6.8-11.8 10.7-25.4 10.7-40 0-33-20-61.3-48.5-73.6-14.4 11.8-23.5 29.6-23.5 49.6z", "M383.8 25.3L306 77c-10.7 7.1-24.7 7.1-35.4 0l-77.9-51.7-18.5 91.6c-2.6 12.6-12.4 22.5-25 25l-91.6 18.5 51.7 77.9c7.1 10.7 7.1 24.7 0 35.4l-51.7 77.9 91.6 18.5c12.6 2.6 22.5 12.4 25 25l18.5 91.6 77.9-51.7c10.7-7.1 24.7-7.1 35.4 0l77.9 51.7 18.5-91.6c2.6-12.6 12.4-22.5 25-25l91.6-18.5-51.7-77.9c-7.1-10.7-7.1-24.7 0-35.4l51.7-77.9-91.6-18.5c-12.6-2.6-22.5-12.4-25-25L383.8 25.3zM398.4-9.9c6.3 2.6 12.6 8.4 14.4 17.2l20.9 103.2 103.2 20.9c8.8 1.8 14.6 8.1 17.2 14.4s3 14.9-2 22.4l-58.2 87.8 58.2 87.8c5 7.5 4.6 16 2 22.4s-8.4 12.6-17.2 14.4l-103.2 20.9-20.9 103.2c-1.8 8.8-8.1 14.6-14.4 17.2s-14.9 3-22.4-2l-87.8-58.2-87.8 58.2c-7.5 5-16 4.6-22.4 2s-12.6-8.4-14.4-17.2L142.8 401.4 39.6 380.5c-8.8-1.8-14.6-8.1-17.2-14.4s-3-14.9 2-22.4L82.6 256 24.4 168.2c-5-7.5-4.6-16-2-22.4s8.4-12.6 17.2-14.4L142.8 110.6 163.7 7.3c1.8-8.8 8.1-14.6 14.4-17.2s14.9-3 22.4 2L288.3 50.3 376-7.9c7.5-5 16-4.6 22.4-2zM357.6 295.9c6.8-11.8 10.7-25.4 10.7-40 0-33-20-61.3-48.5-73.6-14.4 11.8-23.5 29.6-23.5 49.6 0 34.5 27.2 62.5 61.3 63.9zm-26.4 27.6c-38.8-12.3-66.9-48.6-66.9-91.5 0-20.8 6.6-40.1 17.9-55.8-41.3 3.1-73.9 37.7-73.9 79.8 0 44.2 35.8 80 80 80 15.8 0 30.5-4.6 42.9-12.5zM287.7 144a112 112 0 1 1 .5 224 112 112 0 1 1 -.5-224z"]],
    "360-degrees": [640, 512, [], "e2dc", ["", "M608 64a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM16 64C7.2 64 0 71.2 0 80S7.2 96 16 96l111.3 0-91.9 118.2c-3.8 4.8-4.4 11.4-1.7 16.9s8.3 9 14.4 9l32 0c44.2 0 80 35.8 80 80l0 16c0 44.2-35.8 80-80 80l-5.5 0c-12.7 0-24.9-5.1-33.9-14.1L27.3 388.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l13.3 13.3c15 15 35.4 23.4 56.6 23.4l5.5 0c61.9 0 112-50.1 112-112l0-16c0-61.6-49.8-111.6-111.3-112L172.6 89.8c3.8-4.8 4.4-11.4 1.7-16.9s-8.3-9-14.4-9L16 64zm432 80c0-26.5 21.5-48 48-48s48 21.5 48 48l0 224c0 26.5-21.5 48-48 48s-48-21.5-48-48l0-224zM576 368l0-224c0-44.2-35.8-80-80-80s-80 35.8-80 80l0 224c0 44.2 35.8 80 80 80s80-35.8 80-80zM256 176c0-44.2 35.8-80 80-80 8.8 0 16-7.2 16-16s-7.2-16-16-16c-61.9 0-112 50.1-112 112l0 112 0 .2 0 79.8c0 44.2 35.8 80 80 80s80-35.8 80-80l0-96c0-44.2-35.8-80-80-80-18 0-34.6 6-48 16l0-32zm48 48c26.5 0 48 21.5 48 48l0 96c0 26.5-21.5 48-48 48s-48-21.5-48-48l0-96c0-26.5 21.5-48 48-48z"]],
    "bracket-round-right": [192, 512, [], "29", ["", "M33.9 40.4C29.7 48.2 32.6 57.9 40.4 62.1 80.5 83.8 160 153.4 160 256S80.5 428.2 40.4 449.9c-7.8 4.2-10.7 13.9-6.4 21.7s13.9 10.7 21.7 6.4C100.8 453.6 192 375.3 192 256S100.8 58.4 55.6 33.9c-7.8-4.2-17.5-1.3-21.7 6.4z"]],
    "square-full": [512, 512, [128997, 128998, 128999, 129000, 129001, 129002, 129003, 11035, 11036], "f45c", ["M32 64l0 384c0 17.7 14.3 32 32 32l384 0c17.7 0 32-14.3 32-32l0-384c0-17.7-14.3-32-32-32L64 32C46.3 32 32 46.3 32 64z", "M448 32c17.7 0 32 14.3 32 32l0 384c0 17.7-14.3 32-32 32L64 480c-17.7 0-32-14.3-32-32L32 64c0-17.7 14.3-32 32-32l384 0zM64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-384c0-35.3-28.7-64-64-64L64 0z"]],
    "star-sharp": [512, 512, [], "e28b", ["M43.3 208l126 91c5.5 4 7.9 11.1 5.9 17.6l-43.8 143.9 114.7-89.2c5.8-4.5 13.9-4.5 19.6 0l114.7 89.2-43.8-143.9c-2-6.5 .4-13.6 5.9-17.6l126-91-148.7 0c-7 0-13.1-4.5-15.2-11.1L256 43.6 207.2 196.9C205.1 203.5 199 208 192 208L43.3 208z", "M256 43.6L207.2 196.9C205.1 203.5 199 208 192 208l-148.7 0 126 91c5.5 4 7.9 11.1 5.9 17.6l-43.8 143.9 114.7-89.2c5.8-4.5 13.9-4.5 19.6 0l114.7 89.2-43.8-143.9c-2-6.5 .4-13.6 5.9-17.6l126-91-148.7 0c-7 0-13.1-4.5-15.2-11.1L256 43.6zM230.3 18.8C233.9 7.6 244.3 0 256 0s22.1 7.6 25.7 18.8l50 157.2 153.7 0c14.7 0 26.6 11.9 26.6 26.6 0 8.5-4.1 16.6-11 21.6l-130.3 94.1 50.8 167c4.1 13.3-5.9 26.8-19.8 26.8-4.6 0-9.1-1.5-12.7-4.4L256 404.3 123.1 507.6c-3.6 2.8-8.1 4.4-12.7 4.4-13.9 0-23.9-13.4-19.8-26.8l50.8-167-130.3-94.1c-6.9-5-11-13-11-21.6 0-14.7 11.9-26.6 26.6-26.6l153.7 0 50-157.2z"]],
    "list-radio": [512, 512, [], "e1d0", ["M32 96c0 4.4 .9 8.7 2.5 12.5l42-42C72.7 64.9 68.4 64 64 64 46.3 64 32 78.3 32 96zm0 160a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm0 160a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zM51.5 125.5c3.8 1.6 8.1 2.5 12.5 2.5 17.7 0 32-14.3 32-32 0-4.4-.9-8.7-2.5-12.5l-42 42z", "M76.5 66.5l-42 42c-1.6-3.8-2.5-8.1-2.5-12.5 0-17.7 14.3-32 32-32 4.4 0 8.7 .9 12.5 2.5zm17 17c1.6 3.8 2.5 8.1 2.5 12.5 0 17.7-14.3 32-32 32-4.4 0-8.7-.9-12.5-2.5l42-42zM128 96A64 64 0 1 0 0 96 64 64 0 1 0 128 96zm64 0c0 8.8 7.2 16 16 16l288 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L208 80c-8.8 0-16 7.2-16 16zm0 160c0 8.8 7.2 16 16 16l288 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-288 0c-8.8 0-16 7.2-16 16zm0 160c0 8.8 7.2 16 16 16l288 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-288 0c-8.8 0-16 7.2-16 16zM64 288a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm0-96a64 64 0 1 0 0 128 64 64 0 1 0 0-128zm0 256a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm0-96a64 64 0 1 0 0 128 64 64 0 1 0 0-128z"]],
    "head-side-medical": [512, 512, [], "f809", ["M32 216c0 53.3 22.6 101.3 58.9 134.9 3.3 3 5.1 7.3 5.1 11.7L96 496c0 5.9-3.2 11.1-8 13.9l0 2.1 216 0c-8.8 0-16-7.2-16-16l0-64c0-8.8 7.2-16 16-16l48 0c26.5 0 48-21.5 48-48l0-48c0-8.8 7.2-16 16-16l18.7 0c16.2 0 29.3-13.1 29.3-29.3 0-7.8-3.1-15.2-8.6-20.7l-52.4-52.4c-2.5-2.5-4.1-5.8-4.6-9.3-11.6-90.5-88.9-160.4-182.5-160.4-101.6 0-184 82.4-184 184zm96-8c0-17.7 14.3-32 32-32l16 0 0-16c0-17.7 14.3-32 32-32l32 0c17.7 0 32 14.3 32 32l0 16 16 0c17.7 0 32 14.3 32 32l0 32c0 17.7-14.3 32-32 32l-16 0 0 16c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-16-16 0c-17.7 0-32-14.3-32-32l0-32z", "M32 216c0-101.6 82.4-184 184-184 93.6 0 170.9 69.9 182.5 160.4 .5 3.5 2.1 6.8 4.6 9.3l52.4 52.4c5.5 5.5 8.6 12.9 8.6 20.7 0 16.2-13.1 29.3-29.3 29.3L416 304c-8.8 0-16 7.2-16 16l0 48c0 26.5-21.5 48-48 48l-48 0c-8.8 0-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48 32 0c44.2 0 80-35.8 80-80l0-32 2.7 0c33.8 0 61.3-27.4 61.3-61.3 0-16.2-6.5-31.8-17.9-43.3l-48.6-48.6C413.5 79.3 324 0 216 0 96.7 0 0 96.7 0 216 0 276 24.5 330.3 64 369.5L64 496c0 8.8 7.2 16 16 16s16-7.2 16-16l0-133.4c0-4.5-1.9-8.7-5.1-11.7-36.2-33.6-58.9-81.6-58.9-134.9zm176-88c-17.7 0-32 14.3-32 32l0 16-16 0c-17.7 0-32 14.3-32 32l0 32c0 17.7 14.3 32 32 32l16 0 0 16c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-16 16 0c17.7 0 32-14.3 32-32l0-32c0-17.7-14.3-32-32-32l-16 0 0-16c0-17.7-14.3-32-32-32l-32 0zm32 136l0 24-32 0 0-40c0-4.4-3.6-8-8-8l-40 0 0-32 40 0c4.4 0 8-3.6 8-8l0-40 32 0 0 40c0 4.4 3.6 8 8 8l40 0 0 32-40 0c-4.4 0-8 3.6-8 8l0 16z"]],
    "tombstone": [448, 512, [], "f720", ["M64 192l0 288 320 0 0-288c0-88.4-71.6-160-160-160S64 103.6 64 192zm64 32c0-8.8 7.2-16 16-16l64 0 0-64c0-8.8 7.2-16 16-16s16 7.2 16 16l0 64 64 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-64 0 0 128c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-128-64 0c-8.8 0-16-7.2-16-16z", "M384 480l-320 0 0-288c0-88.4 71.6-160 160-160s160 71.6 160 160l0 288zM32 192l0 288-16 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l416 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0 0-288C416 86 330 0 224 0S32 86 32 192zm208-48c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 64-64 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l64 0 0 128c0 8.8 7.2 16 16 16s16-7.2 16-16l0-128 64 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-64 0 0-64z"]],
    "square-a-lock": [576, 512, [], "e44d", ["M64 96c0-17.7 14.3-32 32-32l320 0c17.7 0 32 14.3 32 32l0 49c-63.1 7.9-112 61.7-112 127l0 24.4c-.4 .4-.9 .8-1.3 1.2L270.3 168.8c-2.7-5.4-8.3-8.8-14.3-8.8s-11.6 3.4-14.3 8.8l-80 160c-4 7.9-.7 17.5 7.2 21.5s17.5 .7 21.5-7.2l11.6-23.2 108.2 0 3.3 6.5c-6 12.5-9.4 26.6-9.4 41.4l0 80.1-208 0c-17.7 0-32-14.3-32-32L64 96zM217.9 288l38.1-76.2 38.1 76.2-76.2 0z", "M96 64l320 0c17.7 0 32 14.3 32 32l0 49c5.2-.7 10.6-1 16-1s10.8 .3 16 1l0-49c0-35.3-28.7-64-64-64L96 32C60.7 32 32 60.7 32 96l0 320c0 35.3 28.7 64 64 64l209.3 0c-.9-5.2-1.3-10.6-1.3-16.1l0-15.9-208 0c-17.7 0-32-14.3-32-32L64 96c0-17.7 14.3-32 32-32zM270.3 168.8c-2.7-5.4-8.3-8.8-14.3-8.8s-11.6 3.4-14.3 8.8l-80 160c-4 7.9-.7 17.5 7.2 21.5s17.5 .7 21.5-7.2l11.6-23.2 108.2 0 3.3 6.5c5.2-11 12.5-20.8 21.3-28.9L270.3 168.8zM256 211.8l38.1 76.2-76.2 0 38.1-76.2zM384 320.1l0 2.6c-18.6 6.6-32 24.4-32 45.3l0 96c0 26.5 21.5 48 48 48l128 0c26.5 0 48-21.5 48-48l0-96c0-20.9-13.4-38.7-32-45.3l0-50.6c0-44.2-35.8-80-80-80s-80 35.8-80 80l0 48zm0 47.9c0-8.2 6.2-15 14.3-15.9l131.5 0c8 .9 14.3 7.7 14.3 15.9l0 96c0 8.8-7.2 16-16 16l-128 0c-8.8 0-16-7.2-16-16l0-96zm128-95.9l0 47.9-96 0 0-47.9c0-26.5 21.5-48 48-48s48 21.5 48 48z"]],
    "clover": [512, 512, [], "e139", ["M49.5 199.6c0 9.1 3.6 17.8 10.1 24.3l20.8 20.8c3 3 4.7 7.1 4.7 11.3s-1.7 8.3-4.7 11.3L59.6 288.2c-6.4 6.4-10.1 15.2-10.1 24.3 0 19 15.4 34.3 34.3 34.3l3.5 0c8.7 0 17.2-2.2 24.8-6.4l85-47c6.2-3.4 14-2.4 19.1 2.7 5 5 6.1 12.8 2.7 19.1l-47 85c-4.2 7.6-6.4 16.1-6.4 24.8l0 3.5c0 19 15.4 34.3 34.4 34.3 9.1 0 17.8-3.6 24.3-10.1l20.8-20.9 2.4-2c2.6-1.7 5.7-2.7 8.9-2.7 4.2 0 8.3 1.7 11.3 4.7l20.9 20.9c6.4 6.4 15.2 10.1 24.3 10.1 19 0 34.3-15.4 34.3-34.3l0-3.5c0-6.5-1.2-13-3.6-19l-2.7-5.8-47-85c-3.4-6.2-2.4-14 2.7-19.1s12.8-6.1 19.1-2.7l85 47 5.8 2.7c6 2.4 12.5 3.6 19 3.6l3.5 0c19 0 34.3-15.4 34.3-34.3 0-9.1-3.6-17.8-10.1-24.3l-20.9-20.9c-3-3-4.7-7.1-4.7-11.3s1.7-8.3 4.7-11.3l20.9-20.8 2.3-2.5c5-6.1 7.8-13.8 7.8-21.8 0-19-15.4-34.4-34.3-34.4l-3.3 0c-8.7 0-17.4 2.3-25 6.5L317 218.5c-6.2 3.5-14 2.4-19.1-2.5-5.1-5-6.2-12.7-2.8-19l45.9-85.2 2.7-5.8c2.3-5.9 3.5-12.3 3.5-18.7l0-3.8c0-19-15.4-34.3-34.3-34.3-9.1 0-17.8 3.6-24.3 10.1L267.7 80.1c-3 3-7.1 4.7-11.3 4.7s-8.3-1.7-11.3-4.7L224.2 59.2c-6.4-6.4-15.2-10.1-24.3-10.1-19 0-34.4 15.4-34.4 34.3l0 3.5c0 8.7 2.2 17.2 6.4 24.8l47 85c3.4 6.2 2.4 14-2.7 19.1s-12.8 6.1-19.1 2.7l-85-47c-7.6-4.2-16.1-6.4-24.8-6.4l-3.5 0c-19 0-34.3 15.4-34.3 34.4z", "M312.8 17.2c36.6 0 66.3 29.7 66.3 66.3l0 3.8c0 12.1-2.6 24.1-7.7 35.1l-2.3 4.7-19.8 36.7 35.6-19.9 4.7-2.5c11.2-5.4 23.5-8.2 35.9-8.2l3.3 0c36.6 0 66.3 29.7 66.3 66.4 0 15.4-5.4 30.2-15 42l-4.4 4.9-9.6 9.5 9.6 9.6c12.4 12.4 19.4 29.3 19.4 46.9 0 36.6-29.7 66.3-66.3 66.3l-3.5 0c-12.3 0-24.5-2.7-35.6-8l-4.7-2.4-36.4-20.1 20.1 36.4 2.4 4.7c5.2 11.1 8 23.3 8 35.6l0 3.5c0 36.6-29.7 66.3-66.3 66.3-17.6 0-34.5-7-46.9-19.4l-9.6-9.6-9.5 9.6c-12.4 12.4-29.3 19.4-46.9 19.4-36.6 0-66.4-29.7-66.4-66.3l0-3.5c0-14.1 3.6-28 10.4-40.3l20.1-36.4-36.4 20.2c-12.3 6.8-26.2 10.4-40.3 10.4l-3.5 0c-36.6 0-66.3-29.7-66.3-66.3 0-17.6 7-34.5 19.4-46.9l9.5-9.6-9.5-9.5c-12.4-12.4-19.4-29.3-19.4-46.9 0-36.6 29.7-66.4 66.3-66.4l3.5 0c14.1 0 28 3.6 40.3 10.4l36.4 20.1-20.1-36.4c-6.8-12.3-10.4-26.2-10.4-40.3l0-3.5c0-36.6 29.7-66.3 66.4-66.3 17.6 0 34.5 7 46.9 19.4l9.5 9.5 9.6-9.5 4.9-4.4c11.8-9.7 26.6-15 42-15zm0 32c-9.1 0-17.8 3.6-24.3 10.1L267.7 80.1c-3 3-7.1 4.7-11.3 4.7s-8.3-1.7-11.3-4.7L224.2 59.2c-6.4-6.4-15.2-10.1-24.3-10.1-19 0-34.4 15.4-34.4 34.3l0 3.5c0 8.7 2.2 17.2 6.4 24.8l47 85c3.4 6.2 2.4 14-2.7 19.1s-12.8 6.1-19.1 2.7l-85-47c-7.6-4.2-16.1-6.4-24.8-6.4l-3.5 0c-19 0-34.3 15.4-34.3 34.4 0 9.1 3.6 17.8 10.1 24.3l20.8 20.8c3 3 4.7 7.1 4.7 11.3s-1.7 8.3-4.7 11.3L59.6 288.2c-6.4 6.4-10.1 15.2-10.1 24.3 0 19 15.4 34.3 34.3 34.3l3.5 0c8.7 0 17.2-2.2 24.8-6.4l85-47c6.2-3.4 14-2.4 19.1 2.7 5 5 6.1 12.8 2.7 19.1l-47 85c-4.2 7.6-6.4 16.1-6.4 24.8l0 3.5c0 19 15.4 34.3 34.4 34.3 9.1 0 17.8-3.6 24.3-10.1l20.8-20.9 2.4-2c2.6-1.7 5.7-2.7 8.9-2.7 4.2 0 8.3 1.7 11.3 4.7l20.9 20.9c6.4 6.4 15.2 10.1 24.3 10.1 19 0 34.3-15.4 34.3-34.3l0-3.5c0-6.5-1.2-13-3.6-19l-2.7-5.8-47-85c-3.4-6.2-2.4-14 2.7-19.1s12.8-6.1 19.1-2.7l85 47 5.8 2.7c6 2.4 12.5 3.6 19 3.6l3.5 0c19 0 34.3-15.4 34.3-34.3 0-9.1-3.6-17.8-10.1-24.3l-20.9-20.9c-3-3-4.7-7.1-4.7-11.3s1.7-8.3 4.7-11.3l20.9-20.8 2.3-2.5c5-6.1 7.8-13.8 7.8-21.8 0-19-15.4-34.4-34.3-34.4l-3.3 0c-8.7 0-17.4 2.3-25 6.5L317 218.5c-6.2 3.5-14 2.4-19.1-2.5-5.1-5-6.2-12.7-2.8-19l45.9-85.2 2.7-5.8c2.3-5.9 3.5-12.3 3.5-18.7l0-3.8c0-19-15.4-34.3-34.3-34.3z"]],
    "signal-bars-fair": [448, 512, ["signal-alt-2"], "f692", ["", "M170.7 272c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 192c0 8.8 7.2 16 16 16s16-7.2 16-16l0-192zM32 400c0-8.8-7.2-16-16-16S0 391.2 0 400l0 64c0 8.8 7.2 16 16 16s16-7.2 16-16l0-64z"]],
    "folder-heart": [512, 512, [], "e189", ["M32 96l0 288c0 17.7 14.3 32 32 32l384 0c17.7 0 32-14.3 32-32l0-240c0-17.7-14.3-32-32-32l-149.3 0c-13.8 0-27.3-4.5-38.4-12.8L221.9 70.4c-5.5-4.2-12.3-6.4-19.2-6.4L64 64C46.3 64 32 78.3 32 96zM144 240c0-35.3 28.7-64 64-64l2.9 0c16.7 0 32.8 6.3 45.1 17.5 12.3-11.2 28.4-17.5 45.1-17.5l2.9 0c35.3 0 64 28.7 64 64 0 35.3-23.1 64.5-45 84.6-22.4 20.6-46.8 34.7-55.9 39.6-7 3.8-15.3 3.8-22.2 0-9.1-4.9-33.5-19-55.9-39.6-21.8-20.1-45-49.3-45-84.6z", "M448 416L64 416c-17.7 0-32-14.3-32-32L32 96c0-17.7 14.3-32 32-32l138.7 0c6.9 0 13.7 2.2 19.2 6.4l38.4 28.8c11.1 8.3 24.6 12.8 38.4 12.8L448 112c17.7 0 32 14.3 32 32l0 240c0 17.7-14.3 32-32 32zM64 448l384 0c35.3 0 64-28.7 64-64l0-240c0-35.3-28.7-64-64-64L298.7 80c-6.9 0-13.7-2.2-19.2-6.4L241.1 44.8C230 36.5 216.5 32 202.7 32L64 32C28.7 32 0 60.7 0 96L0 384c0 35.3 28.7 64 64 64zM276.4 218.2c6.5-6.5 15.4-10.2 24.7-10.2l2.9 0c17.7 0 32 14.3 32 32 0 21.4-14.5 42.5-34.6 61-16.9 15.5-35.4 27-45.4 32.7-10-5.7-28.5-17.2-45.4-32.7-20.1-18.5-34.6-39.7-34.6-61 0-17.7 14.3-32 32-32l2.9 0c9.3 0 18.1 3.7 24.7 10.2l9.1 9.1c3 3 7.1 4.7 11.3 4.7s8.3-1.7 11.3-4.7l9.1-9.1zM301.1 176c-16.7 0-32.8 6.3-45.1 17.5-12.3-11.2-28.4-17.5-45.1-17.5l-2.9 0c-35.3 0-64 28.7-64 64 0 35.3 23.1 64.5 45 84.6 22.4 20.6 46.8 34.7 55.9 39.6 7 3.8 15.3 3.8 22.2 0 9.1-4.9 33.5-19 55.9-39.6 21.8-20.1 45-49.3 45-84.6 0-35.3-28.7-64-64-64l-2.9 0z"]],
    "cloud-word": [576, 512, [], "e138", ["M32 336c0 61.9 50.1 112 112 112l304 0c53 0 96-43 96-96 0-41.8-26.8-77.5-64.2-90.6-4.3-1.5-7.8-4.8-9.5-9.1s-1.5-9 .5-13.1c5.9-11.8 9.2-25.1 9.2-39.2 0-48.6-39.4-88-88-88-13.6 0-26.4 3.1-37.9 8.5-7.2 3.5-15.9 1-20.3-5.7-20-30.6-54.6-50.8-93.8-50.8-61.9 0-112 50.1-112 112 0 10.6 1.5 20.9 4.2 30.5 1.2 4.3 .6 8.8-1.7 12.6s-6 6.5-10.3 7.4C69.8 237.4 32 282.3 32 336zm128-64c0-8.8 7.2-16 16-16l96 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16zm0 96c0-8.8 7.2-16 16-16l48 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16zm128 0c0-8.8 7.2-16 16-16l96 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16zm48-96c0-8.8 7.2-16 16-16l48 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16z", "M240 64c-61.9 0-112 50.1-112 112 0 10.6 1.5 20.9 4.2 30.5 1.2 4.3 .6 8.8-1.7 12.6s-6 6.5-10.3 7.4C69.8 237.4 32 282.3 32 336 32 397.9 82.1 448 144 448l304 0c53 0 96-43 96-96 0-41.8-26.8-77.5-64.2-90.6-4.3-1.5-7.8-4.8-9.5-9.1s-1.5-9 .5-13.1c5.9-11.8 9.2-25.1 9.2-39.2 0-48.6-39.4-88-88-88-13.6 0-26.4 3.1-37.9 8.5-7.2 3.5-15.9 1-20.3-5.7-20-30.6-54.6-50.8-93.8-50.8zM96 176c0-79.5 64.5-144 144-144 45.7 0 86.5 21.3 112.8 54.5 12.3-4.2 25.5-6.5 39.2-6.5 66.3 0 120 53.7 120 120 0 13.2-2.1 25.9-6.1 37.8 41.6 21.1 70.1 64.3 70.1 114.2 0 70.7-57.3 128-128 128l-304 0C64.5 480 0 415.5 0 336 0 272.6 41 218.8 97.9 199.5 96.7 191.9 96 184 96 176zm64 96c0-8.8 7.2-16 16-16l96 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16zm176 0c0-8.8 7.2-16 16-16l48 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16zm64 80c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l96 0zm-176 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l48 0z"]],
    "screen-users": [640, 512, ["users-class"], "f63d", ["M96 64c0-17.7 14.3-32 32-32l384 0c17.7 0 32 14.3 32 32l0 144c-61.9 0-112 50.1-112 112 0-61.9-50.1-112-112-112S208 258.1 208 320c0-61.9-50.1-112-112-112L96 64z", "M512 32L128 32c-17.7 0-32 14.3-32 32l0 144c-11.1 0-21.9 1.6-32 4.6L64 64C64 28.7 92.7 0 128 0L512 0c35.3 0 64 28.7 64 64l0 148.6c-10.1-3-20.9-4.6-32-4.6l0-144c0-17.7-14.3-32-32-32zM96 352a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm0-96a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm224 96a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm0-96a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm256 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm-96 0a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zM32 480l0 16c0 8.8-7.2 16-16 16S0 504.8 0 496l0-16c0-35.3 28.7-64 64-64l64 0c35.3 0 64 28.7 64 64l0 16c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-16c0-17.7-14.3-32-32-32l-64 0c-17.7 0-32 14.3-32 32zm256-32c-17.7 0-32 14.3-32 32l0 16c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-16c0-35.3 28.7-64 64-64l64 0c35.3 0 64 28.7 64 64l0 16c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-16c0-17.7-14.3-32-32-32l-64 0zm192 32l0 16c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-16c0-35.3 28.7-64 64-64l64 0c35.3 0 64 28.7 64 64l0 16c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-16c0-17.7-14.3-32-32-32l-64 0c-17.7 0-32 14.3-32 32z"]],
    "teeth-open": [512, 512, [], "f62f", ["M32 96l0 36.1c11.4-7.7 25.2-12.1 40-12.1 18.9 0 36.1 7.3 48.9 19.2 13.3-25.7 40.1-43.2 71.1-43.2 26.2 0 49.4 12.6 64 32 14.6-19.4 37.8-32 64-32 30.9 0 57.7 17.5 71 43.2 12.8-11.9 30-19.2 49-19.2 14.8 0 28.6 4.5 40 12.1L480 96c0-17.7-14.3-32-32-32L64 64C46.3 64 32 78.3 32 96zm0 309.7L32 416c0 17.7 14.3 32 32 32l384 0c17.7 0 32-14.3 32-32l0-10.3c-10.4 6.5-22.8 10.3-36 10.3l-8 0c-19.1 0-36.4-7.9-48.8-20.6-14.2 22-39 36.6-67.2 36.6-26.2 0-49.4-12.6-64-32-14.6 19.4-37.8 32-64 32-28.2 0-53-14.6-67.2-36.6-12.4 12.7-29.6 20.6-48.8 20.6l-8 0c-13.2 0-25.6-3.8-36-10.3z", "M424 224l32 0c13.3 0 24-10.7 24-24l0-8c0-22.1-17.9-40-40-40s-40 17.9-40 40l0 8c0 13.3 10.7 24 24 24zm56-91.9L480 96c0-17.7-14.3-32-32-32L64 64C46.3 64 32 78.3 32 96l0 36.1c11.4-7.7 25.2-12.1 40-12.1 18.9 0 36.1 7.3 48.9 19.2 13.3-25.7 40.1-43.2 71.1-43.2 26.2 0 49.4 12.6 64 32 14.6-19.4 37.8-32 64-32 30.9 0 57.7 17.5 71 43.2 12.8-11.9 30-19.2 49-19.2 14.8 0 28.6 4.5 40 12.1zM512 192l0 8c0 30.9-25.1 56-56 56L56 256c-30.9 0-56-25.1-56-56L0 96C0 60.7 28.7 32 64 32l384 0c35.3 0 64 28.7 64 64l0 96zM32 192l0 8c0 13.3 10.7 24 24 24l32 0c13.3 0 24-10.7 24-24l0-8c0-22.1-17.9-40-40-40s-40 17.9-40 40zm136 32l48 0c13.3 0 24-10.7 24-24l0-24c0-26.5-21.5-48-48-48s-48 21.5-48 48l0 24c0 13.3 10.7 24 24 24zm128 0l48 0c13.3 0 24-10.7 24-24l0-24c0-26.5-21.5-48-48-48s-48 21.5-48 48l0 24c0 13.3 10.7 24 24 24zM124.8 395.4C112.4 408.1 95.1 416 76 416l-8 0c-13.2 0-25.6-3.8-36-10.3L32 416c0 17.7 14.3 32 32 32l384 0c17.7 0 32-14.3 32-32l0-10.3c-10.4 6.5-22.8 10.3-36 10.3l-8 0c-19.1 0-36.4-7.9-48.8-20.6-14.2 22-39 36.6-67.2 36.6-26.2 0-49.4-12.6-64-32-14.6 19.4-37.8 32-64 32-28.2 0-53-14.6-67.2-36.6zM100 304l368 0c24.3 0 44 19.7 44 44 0 .7 0 1.5 0 2.2 0 .6 0 1.2 0 1.8l0 64c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64l0-64c0-.6 0-1.2 0-1.8 0-.7 0-1.4 0-2.2 0-24.3 19.7-44 44-44l56 0zM68 384l8 0c19.9 0 36-16.1 36-36 0-6.6-5.4-12-12-12l-52 0c-8.3 0-15.1 6.3-15.9 14.4 1.2 18.8 16.8 33.6 35.9 33.6zm344-48c-6.6 0-12 5.4-12 12 0 19.9 16.1 36 36 36l8 0c19.1 0 34.7-14.8 35.9-33.6-.8-8.1-7.6-14.4-15.9-14.4l-52 0zM272 352c0 26.5 21.5 48 48 48s48-21.5 48-48c0-8.8-7.2-16-16-16l-64 0c-8.8 0-16 7.2-16 16zm-128 0c0 26.5 21.5 48 48 48s48-21.5 48-48c0-8.8-7.2-16-16-16l-64 0c-8.8 0-16 7.2-16 16z"]],
    "circle-u": [512, 512, [], "e127", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm144-80c0-8.8 7.2-16 16-16s16 7.2 16 16l0 96c0 26.5 21.5 48 48 48s48-21.5 48-48l0-96c0-8.8 7.2-16 16-16s16 7.2 16 16l0 96c0 44.2-35.8 80-80 80s-80-35.8-80-80l0-96z", "M256 32a224 224 0 1 1 0 448 224 224 0 1 1 0-448zm0 480a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM208 176c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 96c0 44.2 35.8 80 80 80s80-35.8 80-80l0-96c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 96c0 26.5-21.5 48-48 48s-48-21.5-48-48l0-96z"]],
    "calendar-heart": [448, 512, [], "e0d3", ["M32 128l0 288c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-288c0-17.7-14.3-32-32-32L64 96c-17.7 0-32 14.3-32 32zm80 128c0-35.3 28.7-64 64-64l2.9 0c16.7 0 32.8 6.3 45.1 17.5 12.3-11.2 28.4-17.5 45.1-17.5l2.9 0c35.3 0 64 28.7 64 64 0 35.3-23.1 64.5-45 84.6-22.4 20.6-46.8 34.7-55.9 39.6-7 3.8-15.3 3.8-22.2 0-9.1-4.9-33.5-19-55.9-39.6-21.8-20.1-45-49.3-45-84.6z", "M112 0c8.8 0 16 7.2 16 16l0 48 192 0 0-48c0-8.8 7.2-16 16-16s16 7.2 16 16l0 48 32 0c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 128C0 92.7 28.7 64 64 64l32 0 0-48c0-8.8 7.2-16 16-16zM384 96L64 96c-17.7 0-32 14.3-32 32l0 288c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-288c0-17.7-14.3-32-32-32zM244.4 234.2l-9.1 9.1c-3 3-7.1 4.7-11.3 4.7s-8.3-1.7-11.3-4.7l-9.1-9.1c-6.5-6.5-15.4-10.2-24.7-10.2l-2.9 0c-17.7 0-32 14.3-32 32 0 21.4 14.5 42.5 34.6 61 16.8 15.5 35.4 27 45.4 32.7 10-5.7 28.5-17.2 45.4-32.7 20.1-18.5 34.6-39.7 34.6-61 0-17.7-14.3-32-32-32l-2.9 0c-9.3 0-18.1 3.7-24.7 10.2zM269.1 192l2.9 0c35.3 0 64 28.7 64 64 0 35.3-23.1 64.5-45 84.6-22.4 20.6-46.8 34.7-55.9 39.6-7 3.8-15.3 3.8-22.2 0-9.1-4.9-33.5-19-55.9-39.6-21.8-20.1-45-49.3-45-84.6 0-35.3 28.7-64 64-64l2.9 0c16.7 0 32.8 6.3 45.1 17.5 12.3-11.2 28.4-17.5 45.1-17.5z"]],
    "narwhal": [640, 512, [], "f6fe", ["M32 142.7l0 23.9c0 15.7 7.6 30.3 20.5 39.3L96 236.5 139.5 206c12.8-9 20.5-23.7 20.5-39.3l0-23.9-54.8 38.4c-5.5 3.9-12.8 3.9-18.4 0L32 142.7zm83.1 237.3C127.9 437.3 178.9 480 240 480l224 0c79.5 0 144-64.5 144-144 0-79.2-65.5-144-145.4-144-43.3 0-85.9 14.8-119.6 41.7L170.5 371.8c-9.9 7.9-22.1 12.2-34.8 12.2-7.3 0-14.2-1.4-20.6-3.9zM528 296a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M630.6 1.4c8 3.7 11.6 13.1 7.9 21.2L562.2 190.6c46.8 31.7 77.8 85 77.8 145.4 0 97.2-78.8 176-176 176l-224 0c-88.4 0-160-71.6-160-160l0-87.7-45.9-32.1C12.7 217.3 0 192.8 0 166.7L0 112c0-6 3.3-11.4 8.6-14.2s11.7-2.3 16.6 1.1L96 148.5 166.8 98.9c4.9-3.4 11.3-3.8 16.6-1.1S192 106 192 112l0 54.7c0 26.1-12.7 50.6-34.1 65.5l-45.9 32.1 0 64c0 13.1 10.6 23.7 23.7 23.7 5.4 0 10.6-1.8 14.8-5.2L323.1 208.8c39.4-31.6 89.1-48.7 139.6-48.7 25.4 0 49.6 5.4 71.5 15L609.4 9.4c3.7-8 13.1-11.6 21.2-7.9zM464 480c79.5 0 144-64.5 144-144 0-79.2-65.5-144-145.4-144-43.3 0-85.9 14.8-119.6 41.7L170.5 371.8c-9.9 7.9-22.1 12.2-34.8 12.2-7.3 0-14.2-1.4-20.6-3.9 12.8 57.2 63.9 99.9 124.9 99.9l224 0zm40-208a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM32 166.7c0 15.7 7.6 30.3 20.5 39.3L96 236.5 139.5 206c12.8-9 20.5-23.7 20.5-39.3l0-23.9-54.8 38.4c-5.5 3.9-12.8 3.9-18.4 0L32 142.7 32 166.7z"]],
    "bars-staggered": [512, 512, ["reorder", "stream"], "f550", ["", "M0 80c0-8.8 7.2-16 16-16l416 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L16 96C7.2 96 0 88.8 0 80zM64 256c0-8.8 7.2-16 16-16l416 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L80 272c-8.8 0-16-7.2-16-16zM448 432c0 8.8-7.2 16-16 16L16 448c-8.8 0-16-7.2-16-16s7.2-16 16-16l416 0c8.8 0 16 7.2 16 16z"]],
    "warehouse": [576, 512, [], "f494", ["M32 155.8l0 4.2 512 0 0-4.2c0-13.2-8.1-25-20.4-29.8L293.8 36.6c-3.7-1.5-7.9-1.5-11.6 0L52.4 126C40.1 130.7 32 142.6 32 155.8z", "M544 192l-512 0 0 304c0 8.8-7.2 16-16 16S0 504.8 0 496L0 155.8c0-26.4 16.2-50.1 40.8-59.6L270.6 6.8c11.2-4.4 23.6-4.4 34.8 0L535.2 96.1c24.6 9.6 40.8 33.3 40.8 59.6L576 496c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-304zm0-32l0-4.2c0-13.2-8.1-25-20.4-29.8L293.8 36.6c-3.7-1.5-7.9-1.5-11.6 0L52.4 126C40.1 130.7 32 142.6 32 155.8l0 4.2 512 0zM112 256l352 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-352 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zM96 368c0-8.8 7.2-16 16-16l352 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-352 0c-8.8 0-16-7.2-16-16zm16 80l352 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-352 0c-8.8 0-16-7.2-16-16s7.2-16 16-16z"]],
    "swatchbook": [512, 512, [], "f5c3", ["M32 288l128 0 0 128c0 35.3-28.7 64-64 64s-64-28.7-64-64l0-128zM72 416a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm99.7 64c42.7-42.7 85.3-85.3 128-128L448 352c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-276.3 0zM192 233.5c30-30 66-66 108.2-108.2 12.5-12.5 32.8-12.5 45.3 0 15.1 15.1 30.2 30.2 45.3 45.3 12.5 12.5 12.5 32.8 0 45.3-66.3 66.3-132.5 132.5-198.7 198.7 0-60.4 0-120.7 0-181z", "M0 416c0 53 43 96 96 96l352 0c35.3 0 64-28.7 64-64l0-64c0-35.3-28.7-64-64-64l-48.4 0-32 32 80.4 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-276.3 0 241.6-241.6c25-25 25-65.5 0-90.5l-45.3-45.3c-25-25-65.5-25-90.5 0l-37.6 37.6 0 45.3 60.2-60.2c12.5-12.5 32.8-12.5 45.3 0l45.3 45.3c12.5 12.5 12.5 32.8 0 45.3L192 414.5 192 64c0-35.3-28.7-64-64-64L64 0C28.7 0 0 28.7 0 64L0 416zm96 64c-35.3 0-64-28.7-64-64l0-128 128 0 0 128c0 35.3-28.7 64-64 64zM32 256l0-96 128 0 0 96-128 0zm0-128l0-64c0-17.7 14.3-32 32-32l64 0c17.7 0 32 14.3 32 32l0 64-128 0zM96 440a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]],
    "circle-three-quarters": [512, 512, [], "e125", ["M32 256c0 123.7 100.3 224 224 224 112.8 0 206.2-83.5 221.7-192L272 288c-26.5 0-48-21.5-48-48l0-205.7C115.5 49.8 32 143.2 32 256z", "M224 34.3C115.5 49.8 32 143.2 32 256 32 379.7 132.3 480 256 480 368.8 480 462.2 396.5 477.7 288L272 288c-26.5 0-48-21.5-48-48l0-205.7zM224.1 2C241.6-.2 256 14.3 256 32l0 208c0 8.8 7.2 16 16 16l208 0C497.7 256 512.2 270.4 510 287.9 494.3 414.2 386.6 512 256 512 114.6 512 0 397.4 0 256 0 125.4 97.8 17.7 224.1 2z"]],
    "circle-chf": [512, 512, [], "e72c", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm64-68c0-24.3 19.7-44 44-44s44 19.7 44 44l0 4c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-4c0-6.6-5.4-12-12-12s-12 5.4-12 12l0 136c0 6.6 5.4 12 12 12s12-5.4 12-12l0-4c0-8.8 7.2-16 16-16s16 7.2 16 16l0 4c0 24.3-19.7 44-44 44s-44-19.7-44-44l0-136zm112-28c0-8.8 7.2-16 16-16s16 7.2 16 16l0 80 32 0 0-80c0-8.8 7.2-16 16-16s16 7.2 16 16l0 192c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80-32 0 0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-192zm128 0c0-8.8 7.2-16 16-16l48 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-32 0 0 64 24 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-24 0 0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-192z", "M256 32a224 224 0 1 1 0 448 224 224 0 1 1 0-448zm0 480a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM140 144c-24.3 0-44 19.7-44 44l0 136c0 24.3 19.7 44 44 44s44-19.7 44-44l0-4c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 4c0 6.6-5.4 12-12 12s-12-5.4-12-12l0-136c0-6.6 5.4-12 12-12s12 5.4 12 12l0 4c0 8.8 7.2 16 16 16s16-7.2 16-16l0-4c0-24.3-19.7-44-44-44zm100 16c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 192c0 8.8 7.2 16 16 16s16-7.2 16-16l0-80 32 0 0 80c0 8.8 7.2 16 16 16s16-7.2 16-16l0-192c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 80-32 0 0-80zm112-16c-8.8 0-16 7.2-16 16l0 192c0 8.8 7.2 16 16 16s16-7.2 16-16l0-80 24 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-24 0 0-64 32 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-48 0z"]],
    "campground": [512, 512, [9978], "f6bb", ["M32 400.8l0 47.2 74.6 0 9.5-10.6 128-144c3-3.4 7.4-5.4 12-5.4s8.9 2 12 5.4l128 144 9.4 10.6 74.6 0 0-47.2c0-1.9-.7-3.7-1.9-5.2L256 132.6 33.9 395.6c-1.2 1.4-1.9 3.3-1.9 5.2z", "M330.3 19.8c6.8 5.7 7.6 15.8 1.9 22.5L276.9 107.8 502.6 375c6.1 7.2 9.4 16.4 9.4 25.8l0 47.2c0 17.7-14.3 32-32 32L32 480c-17.7 0-32-14.3-32-32l0-47.2c0-9.4 3.3-18.6 9.4-25.8l225.6-267.2-55.3-65.5c-5.7-6.8-4.8-16.8 1.9-22.5s16.8-4.8 22.5 1.9L256 83 307.8 21.7c5.7-6.8 15.8-7.6 22.5-1.9zM33.9 395.6c-1.2 1.4-1.9 3.3-1.9 5.2l0 47.2 74.6 0 9.5-10.6 128-144c3-3.4 7.4-5.4 12-5.4s8.9 2 12 5.4l128 144 9.4 10.6 74.6 0 0-47.2c0-1.9-.7-3.7-1.9-5.2L256 132.6 33.9 395.6zM149.4 448L362.6 448 256 328.1 149.4 448z"]],
    "person-walking-arrow-right": [576, 512, [], "e552", ["M112 149.9c10.4-3.9 21.5-5.9 32.8-5.9 10.8 0 21.3 1.8 31.2 5.3l0 176.8-37.5-18.7c-16.3-8.1-26.5-24.8-26.5-42.9l0-114.6zM184 24a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M160 48a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm0-80a56 56 0 1 1 0 112 56 56 0 1 1 0-112zM112 149.9l0 114.6c0 18.2 10.3 34.8 26.5 42.9l37.5 18.7 0-176.8c-9.9-3.5-20.4-5.3-31.2-5.3-11.3 0-22.4 2-32.8 5.9zM80 169.8c-1.7 1.6-3.4 3.3-5 5.1L44.5 208.5c-8 8.8-12.5 20.3-12.5 32.3L32 304c0 8.8-7.2 16-16 16S0 312.8 0 304l0-63.3c0-19.9 7.4-39.1 20.8-53.8l30.5-33.6c23.9-26.3 57.9-41.4 93.5-41.4 39.8 0 77.2 18.7 101.1 50.5l19.7 26.3c9.1 12.1 23.3 19.2 38.4 19.2l32 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-32 0c-25.2 0-48.9-11.9-64-32l-19.7-26.3c-3.7-4.9-7.8-9.4-12.3-13.5l0 173.8 24 12c24.3 12.1 40.7 35.7 43.7 62.7l12.2 109.4c1 8.8-5.4 16.7-14.1 17.7s-16.7-5.4-17.7-14.1L243.9 420.4c-1.8-16.2-11.7-30.3-26.2-37.6L124.2 336C97.1 322.4 80 294.7 80 264.4l0-94.7zM106.8 381l28.9 14.5-4.6 13.8c-3.3 9.8-8.4 18.9-15.2 26.8L28.1 538.4c-5.8 6.7-15.9 7.5-22.6 1.7s-7.5-15.9-1.7-22.6L91.7 415.1c4-4.7 7.1-10.2 9.1-16.1l6-18.1zm392.5-41.6c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6L521.4 272 400 272c-8.8 0-16-7.2-16-16s7.2-16 16-16l121.4 0-44.7-44.7c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l72 72c6.2 6.2 6.2 16.4 0 22.6l-72 72z"]],
    "spider-black-widow": [512, 512, [], "f718", ["M176.5 320l0 16c0 44.2 35.8 80 80 80l8.2-.4c40.3-4.1 71.8-38.2 71.8-79.6l0-16c0-27.2-13.6-51.2-34.5-65.7-6.9-4.8-8.9-14.2-4.6-21.5 4.5-7.3 7.1-15.8 7.1-24.8l0-32-.3-4.9c-2.3-22.6-20.3-40.5-42.8-42.8l-4.9-.2c-26.5 0-48 21.5-48 48l0 32c0 9.1 2.6 17.5 7 24.8 4.4 7.2 2.4 16.6-4.6 21.5-20.8 14.5-34.4 38.5-34.4 65.7zm40-26c0-3.3 2.7-6 6-6l68 0c3.3 0 6 2.7 6 6 0 1.3-.4 2.6-1.2 3.6l-22.8 30.4 22.8 30.4c.8 1 1.2 2.3 1.2 3.6 0 3.3-2.7 6-6 6l-68 0c-3.3 0-6-2.7-6-6 0-1.3 .4-2.6 1.2-3.6l22.8-30.4-22.8-30.4c-.8-1-1.2-2.3-1.2-3.6z", "M362.7-30.9c7.2-2.8 15.2 0 19.3 6.2l1.5 2.9 56 144c2.2 5.7 1 12.2-3.2 16.7l-86.2 92.8 110-28.9 21.3-63.8 1.3-3c3.7-6.4 11.6-9.6 18.9-7.2 7.3 2.5 11.7 9.7 10.8 17.1l-.7 3.2-24 72c-1.7 5.1-5.9 9-11.1 10.4l-93.2 24.5 93.2 24.5c5.2 1.4 9.4 5.3 11.1 10.4l24 72 .7 3.2c.9 7.4-3.5 14.6-10.8 17.1-7.3 2.4-15.2-.7-18.9-7.2l-1.3-3-21.3-63.8-92.3-24.3 69.8 97.7c2.8 4 3.7 9.1 2.3 13.8l-40 136-1.2 3c-3.5 6.5-11.2 10-18.6 7.8-8.5-2.5-13.3-11.4-10.8-19.8L407 395 368.4 341c-2.6 57.6-48.6 103.9-106.1 106.8l-5.7 .2c-60.2 0-109.3-47.5-111.9-107L106 395 143.8 523.5c2.5 8.5-2.4 17.4-10.8 19.8-7.4 2.2-15.1-1.3-18.6-7.8l-1.2-3-40-136c-1.4-4.7-.5-9.8 2.3-13.8l69.8-97.7-92.3 24.3-21.2 63.8-1.3 3c-3.7 6.4-11.6 9.6-18.9 7.2-7.3-2.4-11.7-9.7-10.8-17.1l.7-3.2 24-72c1.7-5.1 5.9-9 11.1-10.4l93.2-24.5-93.2-24.5c-5.2-1.4-9.4-5.3-11.1-10.4l-24-72-.7-3.2c-.9-7.4 3.5-14.6 10.8-17.1 7.3-2.4 15.2 .7 18.9 7.2l1.3 3 21.2 63.8 110 28.9-86.2-92.8c-4.2-4.5-5.4-11-3.2-16.7l56-144 1.5-2.9c4-6.3 12-9 19.2-6.2 7.2 2.8 11.2 10.3 10 17.6l-.9 3.1-52.4 134.7 69.5 74.8 0-23.3c0-44.2 35.8-80 80-80l8.2 .4c40.3 4.1 71.8 38.2 71.8 79.6l0 23.3 69.5-74.8-52.4-134.7-.9-3.1c-1.3-7.3 2.8-14.8 10-17.6zM256.5 128c-26.5 0-48 21.5-48 48l0 32c0 9.1 2.6 17.5 7 24.8 4.4 7.2 2.4 16.6-4.6 21.5-20.8 14.5-34.4 38.5-34.4 65.7l0 16c0 44.2 35.8 80 80 80l8.2-.4c40.3-4.1 71.8-38.2 71.8-79.6l0-16c0-27.2-13.6-51.2-34.5-65.7-6.9-4.8-8.9-14.2-4.6-21.5 4.5-7.3 7.1-15.8 7.1-24.8l0-32-.3-4.9c-2.3-22.6-20.3-40.5-42.8-42.8l-4.9-.2zm34 160c3.3 0 6 2.7 6 6 0 1.3-.4 2.6-1.2 3.6l-22.8 30.4 22.8 30.4c.8 1 1.2 2.3 1.2 3.6 0 3.3-2.7 6-6 6l-68 0c-3.3 0-6-2.7-6-6 0-1.3 .4-2.6 1.2-3.6l22.8-30.4-22.8-30.4c-.8-1-1.2-2.3-1.2-3.6 0-3.3 2.7-6 6-6l68 0z"]],
    "glasses": [576, 512, [], "f530", ["M32 288l192 0 0 96c0 35.3-28.7 64-64 64l-64 0c-35.3 0-64-28.7-64-64l0-96zm320 0l192 0 0 96c0 35.3-28.7 64-64 64l-64 0c-35.3 0-64-28.7-64-64l0-96z", "M128.3 64C106.8 64 88 78.2 82.1 98.8L37.2 256 224 256c17.7 0 32 14.3 32 32l64 0c0-17.7 14.3-32 32-32l186.8 0-44.9-157.2C488 78.2 469.2 64 447.7 64L416 64c-8.8 0-16-7.2-16-16s7.2-16 16-16l31.7 0c35.7 0 67.1 23.7 76.9 58l48.3 169c2 7.1 3.1 14.5 3.1 22l0 103c0 53-43 96-96 96l-64 0c-53 0-96-43-96-96l0-64-64 0 0 64c0 53-43 96-96 96l-64 0c-53 0-96-43-96-96L0 281c0-7.4 1-14.8 3.1-22L51.4 90c9.8-34.3 41.2-58 76.9-58L160 32c8.8 0 16 7.2 16 16s-7.2 16-16 16l-31.7 0zM544 288l-192 0 0 96c0 35.3 28.7 64 64 64l64 0c35.3 0 64-28.7 64-64l0-96zM32 288l0 96c0 35.3 28.7 64 64 64l64 0c35.3 0 64-28.7 64-64l0-96-192 0z"]],
    "circle-pause": [512, 512, [62092, "pause-circle"], "f28b", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm160-80c0-8.8 7.2-16 16-16s16 7.2 16 16l0 160c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-160zm96 0c0-8.8 7.2-16 16-16s16 7.2 16 16l0 160c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-160z", "M256 32a224 224 0 1 1 0 448 224 224 0 1 1 0-448zm0 480a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM224 176c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 160c0 8.8 7.2 16 16 16s16-7.2 16-16l0-160zm96 0c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 160c0 8.8 7.2 16 16 16s16-7.2 16-16l0-160z"]],
    "memory": [512, 512, [], "f538", ["M32 120l0 8c19.4 14.6 32 37.8 32 64s-12.6 49.4-32 64l0 32 448 0 0-32c-19.4-14.6-32-37.8-32-64s12.6-49.4 32-64l0-8c0-13.3-10.7-24-24-24L56 96c-13.3 0-24 10.7-24 24zm0 200l0 96 64 0 0-32c0-8.8 7.2-16 16-16s16 7.2 16 16l0 32 64 0 0-32c0-8.8 7.2-16 16-16s16 7.2 16 16l0 32 64 0 0-32c0-8.8 7.2-16 16-16s16 7.2 16 16l0 32 64 0 0-32c0-8.8 7.2-16 16-16s16 7.2 16 16l0 32 64 0 0-96-448 0zm96-176c0-8.8 7.2-16 16-16s16 7.2 16 16l0 96c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-96zm112 0c0-8.8 7.2-16 16-16s16 7.2 16 16l0 96c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-96zm112 0c0-8.8 7.2-16 16-16s16 7.2 16 16l0 96c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-96z", "M0 120C0 89.1 25.1 64 56 64l400 0c30.9 0 56 25.1 56 56l0 16.6c0 5.7-3 11-8 13.8-14.4 8.3-24 23.8-24 41.6s9.6 33.3 24 41.6c4.9 2.9 8 8.1 8 13.8L512 416c0 17.7-14.3 32-32 32L32 448c-17.7 0-32-14.3-32-32L0 247.4c0-5.7 3-11 8-13.8 14.4-8.3 24-23.8 24-41.6s-9.6-33.3-24-41.6c-4.9-2.9-8-8.1-8-13.8L0 120zM32 320l0 96 64 0 0-32c0-8.8 7.2-16 16-16s16 7.2 16 16l0 32 64 0 0-32c0-8.8 7.2-16 16-16s16 7.2 16 16l0 32 64 0 0-32c0-8.8 7.2-16 16-16s16 7.2 16 16l0 32 64 0 0-32c0-8.8 7.2-16 16-16s16 7.2 16 16l0 32 64 0 0-96-448 0zm448-32l0-32c-19.4-14.6-32-37.8-32-64s12.6-49.4 32-64l0-8c0-13.3-10.7-24-24-24L56 96c-13.3 0-24 10.7-24 24l0 8c19.4 14.6 32 37.8 32 64s-12.6 49.4-32 64l0 32 448 0zM144 128c8.8 0 16 7.2 16 16l0 96c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-96c0-8.8 7.2-16 16-16zm112 0c8.8 0 16 7.2 16 16l0 96c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-96c0-8.8 7.2-16 16-16zm112 0c8.8 0 16 7.2 16 16l0 96c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-96c0-8.8 7.2-16 16-16z"]],
    "gift": [512, 512, [127873], "f06b", ["M32 176l0 32c0 8.8 7.2 16 16 16l416 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16L48 160c-8.8 0-16 7.2-16 16zm32 80l0 160c0 17.7 14.3 32 32 32l144 0 0-192-176 0zm208 0l0 192 144 0c17.7 0 32-14.3 32-32l0-160-176 0z", "M308.5 58.7L273.9 128 352 128c26.5 0 48-21.5 48-48 0-26.5-21.6-48-48.2-48-18.3 0-35.1 10.4-43.3 26.7zM160 160L48 160c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l416 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-304 0zM48 128l48 0c-10-13.4-16-30-16-48 0-44.2 36-80 80.2-80 30.4 0 58.3 17.2 71.9 44.4L256 92.2 279.9 44.4c13.6-27.2 41.5-44.4 71.9-44.4 44.1 0 80.2 35.8 80.2 80 0 18-6 34.6-16 48l48 0c26.5 0 48 21.5 48 48l0 32c0 20.9-13.4 38.7-32 45.3L480 416c0 35.3-28.7 64-64 64L96 480c-35.3 0-64-28.7-64-64l0-162.7C13.4 246.7 0 228.9 0 208l0-32c0-26.5 21.5-48 48-48zm190.1 0L203.5 58.7c-8.2-16.3-25-26.7-43.3-26.7-26.6 0-48.2 21.5-48.2 48 0 26.5 21.5 48 48 48l78.1 0zM64 416c0 17.7 14.3 32 32 32l144 0 0-192-176 0 0 160zm208 32l144 0c17.7 0 32-14.3 32-32l0-160-176 0 0 192z"]],
    "sprinkler-ceiling": [384, 512, [], "e44c", ["", "M0 0l32 0 0 83.8 96 26.2 0 33.2-116.2-31.7C4.8 109.5 0 103.2 0 96L0 0zM256 110l96-26.2 0-83.8 32 0 0 96c0 7.2-4.8 13.5-11.8 15.4L256 143.1 256 110zM192 32c8.8 0 16 7.2 16 16l0 176 96 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L80 256c-8.8 0-16-7.2-16-16s7.2-16 16-16l96 0 0-176c0-8.8 7.2-16 16-16zM144 320a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM80 416c-8.8 0-16-7.2-16-16s7.2-16 16-16 16 7.2 16 16-7.2 16-16 16zm144-80a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm-32 80c-8.8 0-16-7.2-16-16s7.2-16 16-16 16 7.2 16 16-7.2 16-16 16zm-32 48c0 8.8-7.2 16-16 16s-16-7.2-16-16 7.2-16 16-16 16 7.2 16 16zm80 16c-8.8 0-16-7.2-16-16s7.2-16 16-16 16 7.2 16 16-7.2 16-16 16zm144-16c0 8.8-7.2 16-16 16s-16-7.2-16-16 7.2-16 16-16 16 7.2 16 16zm-80-48c-8.8 0-16-7.2-16-16s7.2-16 16-16 16 7.2 16 16-7.2 16-16 16zM32 464c0 8.8-7.2 16-16 16s-16-7.2-16-16 7.2-16 16-16 16 7.2 16 16z"]],
    "square-phone-hangup": [448, 512, ["phone-square-down"], "e27a", ["M32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64C46.3 64 32 78.3 32 96zM69.3 307.9c-13.6-30.7-9.4-73 24.5-96.3 78.2-53.7 182.1-53.7 260.3 0 33.9 23.2 38.1 65.5 24.5 96.3l-.9 2c-10.5 23.8-38.1 34.9-62.2 25L294.1 326c-19.3-8-31.3-27.5-29.6-48.4l.3-3.1c-26.5-8.2-55-8.7-81.7-1.5l.4 4.6c1.7 20.8-10.2 40.4-29.6 48.4l-21.5 8.8c-24.1 9.9-51.7-1.2-62.2-25l-.9-2z", "M64 64C46.3 64 32 78.3 32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM348.5 297l.9-2c9-20.3 4.8-44.5-13.3-56.9-67.3-46.2-156.8-46.2-224.1 0-18.1 12.5-22.3 36.6-13.3 56.9l.9 2c3.5 7.9 12.7 11.6 20.7 8.3l21.5-8.8c6.4-2.7 10.4-9.2 9.9-16.1L150.1 263c-.6-7.2 3.7-13.9 10.6-16.4 41.1-14.7 86.4-13.9 127 2.2 6.5 2.6 10.6 9.2 10 16.2l-1.3 15.4c-.6 6.9 3.4 13.5 9.9 16.1l21.5 8.8c8 3.3 17.2-.4 20.7-8.3zm-32.9 37.9L294.1 326c-19.3-8-31.3-27.5-29.6-48.4l.3-3.1c-26.5-8.2-55-8.7-81.7-1.5l.4 4.6c1.7 20.8-10.2 40.4-29.6 48.4l-21.5 8.8c-24.1 9.9-51.7-1.2-62.2-25l-.9-2c-13.6-30.7-9.4-73 24.5-96.3 78.2-53.7 182.1-53.7 260.3 0 33.9 23.2 38.1 65.5 24.5 96.3l-.9 2c-10.5 23.8-38.1 34.9-62.2 25z"]],
    "money-bill-wheat": [512, 512, [], "e52a", ["M32 304c0-8.8 7.2-16 16-16l32 0c0 26.5-21.5 48-48 48l0-32zm0 64c44.2 0 80-35.8 80-80l288 0c0 44.2 35.8 80 80 80l0 32c-44.2 0-80 35.8-80 80l-288 0c0-44.2-35.8-80-80-80l0-32zm0 64c26.5 0 48 21.5 48 48l-32 0c-8.8 0-16-7.2-16-16l0-32zm160-48a64 64 0 1 0 128 0 64 64 0 1 0 -128 0zm240-96l32 0c8.8 0 16 7.2 16 16l0 32c-26.5 0-48-21.5-48-48zm0 192c0-26.5 21.5-48 48-48l0 32c0 8.8-7.2 16-16 16l-32 0z", "M224 64l0 5.3c-18.6-6.6-32-24.4-32-45.3l0-5.3c18.6 6.6 32 24.4 32 45.3zM160 0l0 24c0 31.7 18.4 59 45.1 72-26.7 13-45.1 40.3-45.1 72l0 24c0 8.8 7.2 16 16 16 44.2 0 80-35.8 80-80l0-64c0-44.2-35.8-80-80-80-8.8 0-16 7.2-16 16zM48 0C39.2 0 32 7.2 32 16s7.2 16 16 16l64 0c8.8 0 16-7.2 16-16S120.8 0 112 0L48 0zM16 80C7.2 80 0 87.2 0 96s7.2 16 16 16l128 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L16 80zm16 96c0 8.8 7.2 16 16 16l64 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-64 0c-8.8 0-16 7.2-16 16zM336 69.3c-18.6-6.6-32-24.4-32-45.3l0-5.3c18.6 6.6 32 24.4 32 45.3l0 5.3zM288-16c-8.8 0-16 7.2-16 16l0 24c0 31.7 18.4 59 45.1 72-26.7 13-45.1 40.3-45.1 72l0 24c0 8.8 7.2 16 16 16 44.2 0 80-35.8 80-80l0-64c0-44.2-35.8-80-80-80zM448 64l0 5.3c-18.6-6.6-32-24.4-32-45.3l0-5.3c18.6 6.6 32 24.4 32 45.3zM384 0l0 24c0 31.7 18.4 59 45.1 72-26.7 13-45.1 40.3-45.1 72l0 24c0 8.8 7.2 16 16 16 44.2 0 80-35.8 80-80l0-64c0-44.2-35.8-80-80-80-8.8 0-16 7.2-16 16zM304 173.3l0-5.3c0-20.9 13.4-38.7 32-45.3l0 5.3c0 20.9-13.4 38.7-32 45.3zM192 168c0-20.9 13.4-38.7 32-45.3l0 5.3c0 20.9-13.4 38.7-32 45.3l0-5.3zm224 5.3l0-5.3c0-20.9 13.4-38.7 32-45.3l0 5.3c0 20.9-13.4 38.7-32 45.3zM480 304l0 32c-26.5 0-48-21.5-48-48l32 0c8.8 0 16 7.2 16 16zM32 368c44.2 0 80-35.8 80-80l288 0c0 44.2 35.8 80 80 80l0 32c-44.2 0-80 35.8-80 80l-288 0c0-44.2-35.8-80-80-80l0-32zM432 480c0-26.5 21.5-48 48-48l0 32c0 8.8-7.2 16-16 16l-32 0zM32 432c26.5 0 48 21.5 48 48l-32 0c-8.8 0-16-7.2-16-16l0-32zM80 288c0 26.5-21.5 48-48 48l0-32c0-8.8 7.2-16 16-16l32 0zM48 256c-26.5 0-48 21.5-48 48L0 464c0 26.5 21.5 48 48 48l416 0c26.5 0 48-21.5 48-48l0-160c0-26.5-21.5-48-48-48L48 256zM224 384a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm96 0a64 64 0 1 0 -128 0 64 64 0 1 0 128 0z"]],
    "circle-florin": [512, 512, [], "e6e4", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zM144 368c0-8.8 7.2-16 16-16l23.9 0c8.2 0 15.7-4.9 18.9-12.5l35.8-83.5-62.6 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l76.3 0 27.5-64.1c8.3-19.3 27.3-31.9 48.3-31.9l23.9 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-23.9 0c-8.2 0-15.7 4.9-18.9 12.5L287.1 224 336 224c8.8 0 16 7.2 16 16s-7.2 16-16 16l-62.6 0-41.2 96.1c-8.3 19.3-27.3 31.9-48.3 31.9L160 384c-8.8 0-16-7.2-16-16z", "M256 32a224 224 0 1 1 0 448 224 224 0 1 1 0-448zm0 480a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm23.8-352.1L252.3 224 176 224c-8.8 0-16 7.2-16 16s7.2 16 16 16l62.6 0-35.8 83.5c-3.2 7.6-10.7 12.5-18.9 12.5L160 352c-8.8 0-16 7.2-16 16s7.2 16 16 16l23.9 0c21 0 40-12.5 48.3-31.9l41.2-96.1 62.6 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-48.9 0 22.1-51.5c3.2-7.6 10.7-12.5 18.9-12.5l23.9 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-23.9 0c-21 0-40 12.5-48.3 31.9z"]],
    "dungeon": [512, 512, [], "f6d9", ["M32 256l64 0c0-20 3.7-39.2 10.4-56.9L49 170.4C38 196.7 32 225.7 32 256zm0 32l0 80 64 0 0-80-64 0zm0 112l0 64c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-64-64 0zM63.3 141.8l57.5 28.7c16.2-25.5 39.3-46.1 66.8-59.1l-39-52c-35.3 19.3-64.8 47.8-85.3 82.3zM178.4 45.8l40.8 54.4C231 97.5 243.3 96 256 96s25 1.5 36.8 4.3l40.8-54.4C309.4 36.9 283.3 32 256 32s-53.4 4.9-77.6 13.8zm146.1 65.5c27.1 12.8 50 33.1 66.1 58l54.9-32.9c-20.3-32.1-48.6-58.7-82-77.1l-39 52zM405.2 198c7 18 10.8 37.6 10.8 58l64 0c0-32.5-6.9-63.4-19.4-91.3L405.2 198zM416 288l0 80 64 0 0-80-64 0zm0 112l0 64c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-64-64 0z", "M219.2 100.3L178.4 45.8C202.6 36.9 228.7 32 256 32s53.4 4.9 77.6 13.8l-40.8 54.4C281 97.5 268.7 96 256 96s-25 1.5-36.8 4.3zm-31.7 11.1c-27.5 13-50.6 33.6-66.8 59.1L63.3 141.8c20.5-34.5 50-63 85.3-82.3l39 52zm-81.1 87.7C99.7 216.8 96 236 96 256l-64 0c0-30.3 6-59.3 17-85.6l57.5 28.7zM96 288l0 80-64 0 0-80 64 0zm0 112l0 64c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-64 64 0zM363.4 59.4c33.4 18.3 61.7 44.9 82 77.1l-54.9 32.9c-16.1-25-39-45.2-66.1-58l39-52zm97.2 105.3C473.1 192.6 480 223.5 480 256l-64 0c0-20.5-3.8-40-10.8-58l55.5-33.3zM480 288l0 80-64 0 0-80 64 0zm0 112l0 64c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-64 64 0zM128 256c0-70.7 57.3-128 128-128s128 57.3 128 128l0 208c0 26.5 21.5 48 48 48l32 0c26.5 0 48-21.5 48-48l0-208C512 114.6 397.4 0 256 0S0 114.6 0 256L0 464c0 26.5 21.5 48 48 48l32 0c26.5 0 48-21.5 48-48l0-208zm128-80c-8.8 0-16 7.2-16 16l0 304c0 8.8 7.2 16 16 16s16-7.2 16-16l0-304c0-8.8-7.2-16-16-16zm-64 32c-8.8 0-16 7.2-16 16l0 272c0 8.8 7.2 16 16 16s16-7.2 16-16l0-272c0-8.8-7.2-16-16-16zm128 0c-8.8 0-16 7.2-16 16l0 272c0 8.8 7.2 16 16 16s16-7.2 16-16l0-272c0-8.8-7.2-16-16-16z"]],
    "comet": [512, 512, [], "e003", ["M32 309.8c0 93.6 75.9 170.2 169.3 170.2 54.4 0 105.4-26.1 137.2-70.2l134.2-185.8-50.6 0c-5.4 0-10.4-2.7-13.4-7.3s-3.4-10.2-1.2-15.2L479.7 37.4c.2-.5 .3-1 .3-1.5 0-2.1-1.7-3.8-3.8-3.8-.5 0-1.1 .1-1.5 .3L310.4 104.6c-4.9 2.2-10.7 1.7-15.2-1.2s-7.3-8-7.3-13.4L288 32 100.3 172.8C57.3 205 32 256 32 309.8zm54.3-37.4c1.9-5.8 6.9-10 12.9-10.9l65.3-9.5 29.2-59.2c2.7-5.5 8.3-8.9 14.3-8.9s11.7 3.5 14.3 8.9l29.2 59.2 65.3 9.5c6 .9 11 5.1 12.9 10.9s.3 12.2-4 16.4l-47.2 46 11.2 65c1 6-1.4 12.1-6.4 15.7s-11.5 4.1-16.8 1.2l-58.4-30.7-58.4 30.7c-5.4 2.8-11.9 2.4-16.8-1.2s-7.4-9.6-6.4-15.7l11.2-65-47.2-46c-4.4-4.3-5.9-10.6-4-16.4z", "M320 32c0-26.4-30.1-41.4-51.2-25.6L81.1 147.2C30 185.5 0 246.1 0 309.8 0 420.9 90 512 201.3 512 265.9 512 326.6 481 364.4 428.6L498.6 242.7c15.3-21.2 .2-50.7-25.9-50.7L446.6 192 509 50.3c2-4.5 3-9.5 3-14.4 0-19.8-16-35.8-35.8-35.8-5 0-9.9 1-14.4 3L320 65.4 320 32zm154.6 .3c.5-.2 1-.3 1.5-.3 2.1 0 3.8 1.7 3.8 3.8 0 .5-.1 1.1-.3 1.5L407.4 201.6c-2.2 4.9-1.7 10.7 1.2 15.2s8 7.3 13.4 7.3l50.6 0-134.2 185.8C306.7 453.9 255.6 480 201.3 480 107.9 480 32 403.4 32 309.8 32 256 57.3 205 100.3 172.8L288 32 288 89.9c0 5.4 2.7 10.4 7.3 13.4s10.2 3.4 15.2 1.2L474.6 32.3zM169.1 283.7c10.4-1.5 19.4-8.1 24.1-17.5l14.8-30.1 14.8 30.1c4.7 9.4 13.7 16 24.1 17.5l33.2 4.8-24 23.4c-7.5 7.4-11 17.9-9.2 28.3l5.7 33.1-29.7-15.6c-9.3-4.9-20.5-4.9-29.8 0l-29.7 15.6 5.7-33.1c1.8-10.4-1.7-21-9.2-28.3l-24-23.4 33.2-4.8zm53.3-90.8c-2.7-5.5-8.3-8.9-14.3-8.9s-11.7 3.5-14.3 8.9l-29.2 59.2-65.3 9.5c-6 .9-11 5.1-12.9 10.9s-.3 12.2 4 16.4l47.2 46-11.2 65c-1 6 1.4 12.1 6.4 15.7s11.5 4.1 16.8 1.2l58.4-30.7 58.4 30.7c5.4 2.8 11.9 2.4 16.8-1.2s7.4-9.6 6.4-15.7l-11.2-65 47.2-46c4.4-4.3 5.9-10.6 4-16.4s-6.9-10-12.9-10.9l-65.3-9.5-29.2-59.2z"]],
    "face-holding-back-tears": [512, 512, [129401], "e482", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm48.1-78c-1.1-8.8 5.1-16.8 13.9-17.9l11.5-1.4c25.5-3.2 46.6-21.3 53.6-45.9l1.5-5.2c2.4-8.5 11.3-13.4 19.8-11s13.4 11.3 11 19.8l-1.5 5.2c-4.2 14.8-11.8 28-21.9 38.8 40.4 4 72 38.1 72 79.6l0 64c0 8.8-7.2 16-16 16s-16-7.2-16-16c-13.4 10-30 16-48 16-11.4 0-22.2-2.4-32-6.7l0 6.7c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-32c-10-13.4-16-30-16-48s6-34.6 16-48c-8 0-14.9-5.9-15.9-14zm81.6 210.5c-5.7-6.7-5-16.8 1.8-22.6s16.8-5 22.6 1.8c16.9 19.8 42 32.3 70 32.3s53.1-12.5 70-32.3c5.7-6.7 15.8-7.5 22.6-1.8s7.5 15.8 1.8 22.6C327.6 415.1 293.8 432 256 432s-71.6-16.9-94.3-43.5zM272 240c0-41.5 31.5-75.6 72-79.6-10-10.8-17.6-24.1-21.9-38.8l-1.5-5.2c-2.4-8.5 2.5-17.4 11-19.8s17.4 2.5 19.8 11l1.5 5.2c7 24.7 28.1 42.7 53.6 45.9l11.5 1.4c8.8 1.1 15 9.1 13.9 17.9-1 8.1-7.9 14-15.9 14 10 13.4 16 30 16 48s-6 34.6-16 48l0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-6.7c-9.8 4.3-20.6 6.7-32 6.7-44.2 0-80-35.8-80-80z", "M480 256a224 224 0 1 0 -448 0 224 224 0 1 0 448 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zM320.6 116.4c-2.4-8.5 2.5-17.4 11-19.8s17.4 2.5 19.8 11l1.5 5.2c7 24.7 28.1 42.7 53.6 45.9l11.5 1.4c8.8 1.1 15 9.1 13.9 17.9-1 8.1-7.9 14-15.9 14 10 13.4 16 30 16 48s-6 34.6-16 48l0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-6.7c-9.8 4.3-20.6 6.7-32 6.7-44.2 0-80-35.8-80-80 0-41.5 31.5-75.6 72-79.6-10-10.8-17.6-24.1-21.9-38.8l-1.5-5.2zM180.4 96.6c8.5 2.4 13.4 11.3 11 19.8l-1.5 5.2c-4.2 14.8-11.8 28-21.9 38.8 40.4 4 72 38.1 72 79.6l0 64c0 8.8-7.2 16-16 16s-16-7.2-16-16c-13.4 10-30 16-48 16-11.4 0-22.2-2.4-32-6.7l0 6.7c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-32c-10-13.4-16-30-16-48s6-34.6 16-48c-8 0-14.9-5.9-15.9-14-1.1-8.8 5.1-16.8 13.9-17.9l11.5-1.4c25.5-3.2 46.6-21.3 53.6-45.9l1.5-5.2c2.4-8.5 11.3-13.4 19.8-11zM208 240a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zm144 48a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM160 208c17.7 0 32 14.3 32 32s-14.3 32-32 32-32-14.3-32-32c17.7 0 32-14.3 32-32zm160 32c17.7 0 32-14.3 32-32 17.7 0 32 14.3 32 32s-14.3 32-32 32-32-14.3-32-32zm6 127.7c5.7-6.7 15.8-7.5 22.6-1.8s7.5 15.8 1.8 22.6C327.6 415.1 293.8 432 256 432s-71.6-16.9-94.3-43.5c-5.7-6.7-5-16.8 1.8-22.6s16.8-5 22.6 1.8c16.9 19.8 42 32.3 70 32.3s53.1-12.5 70-32.3z"]],
    "card-heart": [384, 512, [], "e3eb", ["M32 64l0 384c0 17.7 14.3 32 32 32l256 0c17.7 0 32-14.3 32-32l0-384c0-17.7-14.3-32-32-32L64 32C46.3 32 32 46.3 32 64zM80 224c0-35.3 28.7-64 64-64l2.9 0c16.7 0 32.8 6.3 45.1 17.5 12.3-11.2 28.4-17.5 45.1-17.5l2.9 0c35.3 0 64 28.7 64 64 0 35.3-23.1 64.5-45 84.6-22.4 20.6-46.8 34.7-55.9 39.6-7 3.8-15.3 3.8-22.2 0-9.1-4.9-33.5-19-55.9-39.6-21.8-20.1-45-49.3-45-84.6z", "M64 32C46.3 32 32 46.3 32 64l0 384c0 17.7 14.3 32 32 32l256 0c17.7 0 32-14.3 32-32l0-384c0-17.7-14.3-32-32-32L64 32zM0 64C0 28.7 28.7 0 64 0L320 0c35.3 0 64 28.7 64 64l0 384c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zM212.4 202.2l-9.1 9.1c-3 3-7.1 4.7-11.3 4.7s-8.3-1.7-11.3-4.7l-9.1-9.1c-6.5-6.5-15.4-10.2-24.7-10.2l-2.9 0c-17.7 0-32 14.3-32 32 0 21.4 14.5 42.5 34.6 61 16.8 15.5 35.4 27 45.4 32.7 10-5.7 28.5-17.2 45.4-32.7 20.1-18.5 34.6-39.7 34.6-61 0-17.7-14.3-32-32-32l-2.9 0c-9.3 0-18.1 3.7-24.7 10.2zM237.1 160l2.9 0c35.3 0 64 28.7 64 64 0 35.3-23.1 64.5-45 84.6-22.4 20.6-46.8 34.7-55.9 39.6-7 3.8-15.3 3.8-22.2 0-9.1-4.9-33.5-19-55.9-39.6-21.8-20.1-45-49.3-45-84.6 0-35.3 28.7-64 64-64l2.9 0c16.7 0 32.8 6.3 45.1 17.5 12.3-11.2 28.4-17.5 45.1-17.5z"]],
    "car-mirrors": [576, 512, [], "e343", ["M64 256c0-6.1 1.7-11.8 4.7-16.7 3.2-3.8 6.8-7.4 10.6-10.6 4.9-3 10.6-4.7 16.7-4.7l384 0c6.1 0 11.8 1.7 16.7 4.7 3.8 3.2 7.4 6.8 10.6 10.6 3 4.9 4.7 10.6 4.7 16.7l0 128-448 0 0-128zm48 48a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm304 0a24 24 0 1 0 48 0 24 24 0 1 0 -48 0z", "M201.7 64c-27.5 0-52 17.6-60.7 43.8l-28.1 84.2 350.3 0-28.1-84.2C426.3 81.6 401.9 64 374.3 64L201.7 64zM40.6 224L16 224c-8.8 0-16-7.2-16-16s7.2-16 16-16l63.1 0 31.5-94.4C123.7 58.4 160.3 32 201.7 32l172.7 0c41.3 0 78 26.4 91.1 65.6l31.4 94.4 63.1 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-24.6 0c5.4 9.4 8.6 20.3 8.6 32l0 208c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-48-448 0 0 48c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-208c0-11.7 3.1-22.6 8.6-32zM96 224c-17.7 0-32 14.3-32 32l0 128 448 0 0-128c0-17.7-14.3-32-32-32L96 224zm16 80a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm328-24a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]],
    "suitcase-medical": [512, 512, ["medkit"], "f0fa", ["M32 160l0 256c0 17.7 14.3 32 32 32l32 0 0-320-32 0c-17.7 0-32 14.3-32 32zm96-32l0 320 256 0 0-320-256 0zm32 144c0-17.7 14.3-32 32-32l16 0 0-16c0-17.7 14.3-32 32-32l32 0c17.7 0 32 14.3 32 32l0 16 16 0c17.7 0 32 14.3 32 32l0 32c0 17.7-14.3 32-32 32l-16 0 0 16c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-16-16 0c-17.7 0-32-14.3-32-32l0-32zM416 128l0 320 32 0c17.7 0 32-14.3 32-32l0-256c0-17.7-14.3-32-32-32l-32 0z", "M192 48l0 48 128 0 0-48c0-8.8-7.2-16-16-16l-96 0c-8.8 0-16 7.2-16 16zM160 96l0-48c0-26.5 21.5-48 48-48l96 0c26.5 0 48 21.5 48 48l0 48 96 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 160c0-35.3 28.7-64 64-64l96 0zm176 32l-208 0 0 320 256 0 0-320-48 0zm80 0l0 320 32 0c17.7 0 32-14.3 32-32l0-256c0-17.7-14.3-32-32-32l-32 0zM96 448l0-320-32 0c-17.7 0-32 14.3-32 32l0 256c0 17.7 14.3 32 32 32l32 0zM208 224c0-17.7 14.3-32 32-32l32 0c17.7 0 32 14.3 32 32l0 16 16 0c17.7 0 32 14.3 32 32l0 32c0 17.7-14.3 32-32 32l-16 0 0 16c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-16-16 0c-17.7 0-32-14.3-32-32l0-32c0-17.7 14.3-32 32-32l16 0 0-16zm64 112l0-24c0-4.4 3.6-8 8-8l40 0 0-32-40 0c-4.4 0-8-3.6-8-8l0-40-32 0 0 40c0 4.4-3.6 8-8 8l-40 0 0 32 40 0c4.4 0 8 3.6 8 8l0 40 32 0 0-16z"]],
    "block-quote": [448, 512, [], "e0b5", ["", "M16 64C7.2 64 0 71.2 0 80S7.2 96 16 96l416 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L16 64zM144 240c-8.8 0-16 7.2-16 16s7.2 16 16 16l288 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-288 0zM128 432c0 8.8 7.2 16 16 16l288 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-288 0c-8.8 0-16 7.2-16 16zM0 432c0 8.8 7.2 16 16 16s16-7.2 16-16l0-192c0-8.8-7.2-16-16-16S0 231.2 0 240L0 432z"]],
    "hands-holding-heart": [640, 512, ["hands-heart"], "f4c3", ["M32 128c0-17.7 14.3-32 32-32s32 14.3 32 32l0 124.3c0 27.1 10.8 53.1 29.9 72.2 1.6 1.6 19.9 19.9 54.8 54.8 5.3 5.3 10.7 10.7 16 16 6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-60-60c-9.2-9.2-9.2-24.2 0-33.4s24.2-9.2 33.4 0L284 370.6c12.8 12.8 20 30.2 20 48.3l0 77.1c0 8.8 7.2 16 16 16l-192 0c4.1 0 8.2-1.6 11.3-4.7 6.2-6.2 6.2-16.4 0-22.6L55.4 400.8c-15-15-23.4-35.4-23.4-56.6L32 128zM320 512c8.8 0 16-7.2 16-16l0-77.1c0-18.1 7.2-35.5 20-48.3l91.3-91.3c9.2-9.2 24.2-9.2 33.4 0s9.2 24.2 0 33.4l-60 60c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l60-60 10.8-10.8c19.2-19.2 29.9-45.1 29.9-72.2L544 128c0-17.7 14.3-32 32-32s32 14.3 32 32l0 216.2c0 21.2-8.4 41.6-23.4 56.6l-83.9 83.9c-6.2 6.2-6.2 16.4 0 22.6 3.1 3.1 7.2 4.7 11.3 4.7l-192 0z", "M354.4 49.8L333 79.3c-3 4.2-7.8 6.6-13 6.6s-10-2.5-13-6.6L285.6 49.8c-8.1-11.2-21-17.8-34.7-17.8-23.7 0-42.9 19.2-42.9 42.9 0 26.7 17.1 52.1 38.1 75.9 23.4 26.6 52 49.8 71.3 64.2 1.7 1.2 3.6 1.2 5.3 0 19.3-14.4 47.9-37.6 71.3-64.2 20.9-23.8 38.1-49.2 38.1-75.9 0-23.7-19.2-42.9-42.9-42.9-13.8 0-26.7 6.6-34.7 17.8zM389.1 0c41.4 0 74.9 33.5 74.9 74.9 0 39.6-24.9 73-46 97-25.5 29-56.1 53.8-76.2 68.7-13 9.7-30.5 9.7-43.5 0-20.1-15-50.7-39.7-76.2-68.7-21.2-24.1-46-57.4-46-97 0-41.4 33.5-74.9 74.9-74.9 24 0 46.6 11.5 60.7 31L320 42.7 328.4 31c14.1-19.5 36.7-31 60.7-31zM64 64c35.3 0 64 28.7 64 64l0 124.3c0 4.6 .4 9.1 1.3 13.5 2.1-3.2 4.6-6.3 7.4-9.1 21.7-21.7 56.9-21.7 78.6 0L306.6 348c5.1 5.1 9.6 10.6 13.4 16.6 3.8-5.9 8.3-11.5 13.4-16.6l91.3-91.3c21.7-21.7 56.9-21.7 78.6 0 2.8 2.8 5.3 5.9 7.4 9.1 .9-4.4 1.3-8.9 1.3-13.5L512 128c0-35.3 28.7-64 64-64s64 28.7 64 64l0 216.2c0 29.7-11.8 58.2-32.8 79.2l-83.9 83.9c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l83.9-83.9c15-15 23.4-35.4 23.4-56.6L608 128c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 124.3c0 27.1-10.8 53.1-29.9 72.2-1.6 1.6-19.9 19.9-54.8 54.8l-16 16c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l60-60c9.2-9.2 9.2-24.2 0-33.4s-24.2-9.2-33.4 0L356 370.6c-12.8 12.8-20 30.2-20 48.3l0 77.1c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-77.1c0-18.1-7.2-35.5-20-48.3l-91.3-91.3c-9.2-9.2-24.2-9.2-33.4 0s-9.2 24.2 0 33.4l60 60c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-16-16 0 0-44-44 0 0-10.7-10.8C106.8 305.4 96 279.4 96 252.3L96 128c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 216.2c0 21.2 8.4 41.6 23.4 56.6l83.9 83.9c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L32.8 423.4C11.8 402.4 0 373.9 0 344.2L0 128C0 92.7 28.7 64 64 64z"]],
    "arrow-up-small-big": [512, 512, ["sort-size-up-alt"], "f88f", ["M320 80c0-8.8 7.2-16 16-16l64 0c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16l-64 0c-8.8 0-16-7.2-16-16l0-64zm0 224c0-8.8 7.2-16 16-16l128 0c8.8 0 16 7.2 16 16l0 128c0 8.8-7.2 16-16 16l-128 0c-8.8 0-16-7.2-16-16l0-128z", "M139.3 36.7c-6.2-6.2-16.4-6.2-22.6 0l-96 96c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0L112 86.6 112 464c0 8.8 7.2 16 16 16s16-7.2 16-16l0-377.4 68.7 68.7c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-96-96zM320 80c0-8.8 7.2-16 16-16l64 0c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16l-64 0c-8.8 0-16-7.2-16-16l0-64zm-32 0l0 64c0 26.5 21.5 48 48 48l64 0c26.5 0 48-21.5 48-48l0-64c0-26.5-21.5-48-48-48l-64 0c-26.5 0-48 21.5-48 48zm32 224c0-8.8 7.2-16 16-16l128 0c8.8 0 16 7.2 16 16l0 128c0 8.8-7.2 16-16 16l-128 0c-8.8 0-16-7.2-16-16l0-128zm-32 0l0 128c0 26.5 21.5 48 48 48l128 0c26.5 0 48-21.5 48-48l0-128c0-26.5-21.5-48-48-48l-128 0c-26.5 0-48 21.5-48 48z"]],
    "sliders-simple": [512, 512, [], "e253", ["M32 368a48 48 0 1 0 96 0 48 48 0 1 0 -96 0zM384 144a48 48 0 1 0 96 0 48 48 0 1 0 -96 0z", "M80 416a48 48 0 1 1 0-96 48 48 0 1 1 0 96zm78.4-64c-7.4-36.5-39.7-64-78.4-64-44.2 0-80 35.8-80 80s35.8 80 80 80c38.7 0 71-27.5 78.4-64L496 384c8.8 0 16-7.2 16-16s-7.2-16-16-16l-337.6 0zM480 144a48 48 0 1 1 -96 0 48 48 0 1 1 96 0zM353.6 128L16 128c-8.8 0-16 7.2-16 16s7.2 16 16 16l337.6 0c7.4 36.5 39.7 64 78.4 64 44.2 0 80-35.8 80-80s-35.8-80-80-80c-38.7 0-71 27.5-78.4 64z"]],
    "person-cane": [448, 512, [], "e53c", ["M176 156.7l0 179.3 96 0 0-179.3c-14.4-8.2-30.9-12.7-48-12.7s-33.6 4.5-48 12.7zM208 24a24 24 0 1 0 48 0 24 24 0 1 0 -48 0z", "M208 24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm80 0a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zM224 144c17.1 0 33.6 4.5 48 12.7l0 179.3-96 0 0-179.3c14.4-8.2 30.9-12.7 48-12.7zm48 224l0 160c0 8.8 7.2 16 16 16s16-7.2 16-16l0-341.9c1.1 1.6 2.2 3.3 3.2 5l63.1 105.1c4.5 7.6 14.4 10 22 5.5s10-14.4 5.5-21.9L334.6 174.6C311.3 135.8 269.3 112 224 112s-87.3 23.8-110.6 62.6L50.3 279.8c-4.5 7.6-2.1 17.4 5.5 21.9s17.4 2.1 22-5.5l63.1-105.1c1-1.7 2.1-3.4 3.2-5L144 528c0 8.8 7.2 16 16 16s16-7.2 16-16l0-160 96 0zm128 0c8.8 0 16 7.2 16 16l0 144c0 8.8 7.2 16 16 16s16-7.2 16-16l0-144c0-26.5-21.5-48-48-48s-48 21.5-48 48c0 8.8 7.2 16 16 16s16-7.2 16-16 7.2-16 16-16z"]],
    "message-music": [512, 512, ["comment-alt-music"], "f8af", ["M32 128l0 224c0 35.3 28.7 64 64 64l40 0c13.3 0 24 10.7 24 24l0 68 112-84c6.9-5.2 15.3-8 24-8l120 0c35.3 0 64-28.7 64-64l0-224c0-35.3-28.7-64-64-64L96 64c-35.3 0-64 28.7-64 64z", "M179.2 533.6s0 0 0 0l-6.4 4.8c-4.8 3.6-10.7 5.6-16.8 5.6-15.5 0-28-12.5-28-28l0-68-32 0c-53 0-96-43-96-96L0 128C0 75 43 32 96 32l320 0c53 0 96 43 96 96l0 224c0 53-43 96-96 96l-120 0c-1.7 0-3.4 .6-4.8 1.6l-112 84zM160 468l0 40 112-84c6.9-5.2 15.3-8 24-8l120 0c35.3 0 64-28.7 64-64l0-224c0-35.3-28.7-64-64-64L96 64c-35.3 0-64 28.7-64 64l0 224c0 35.3 28.7 64 64 64l40 0c13.3 0 24 10.7 24 24l0 28zM296 128l24 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0 0 112-.1-.1c.1 1.3 .1 2.7 .1 4.1 0 33.1-28.7 60-64 60s-64-26.9-64-60 28.7-60 64-60c11.7 0 22.6 2.9 32 8l0-72c0-13.3 10.7-24 24-24zM272 276c0-13.5-12.3-28-32-28s-32 14.5-32 28 12.4 28 32 28 32-14.5 32-28z"]],
    "gauge-low": [512, 512, ["tachometer-alt-slow"], "f627", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm88 0a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm9.9-104.4c-4.2-7.8-1.3-17.5 6.5-21.7s17.5-1.3 21.7 6.5l82.6 153.4c4.9-1.2 10-1.8 15.3-1.8 35.3 0 64 28.7 64 64s-28.7 64-64 64-64-28.7-64-64c0-18.6 7.9-35.3 20.5-47L129.9 151.6zM280 96a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm112 48a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm48 112a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M256 480a224 224 0 1 0 0-448 224 224 0 1 0 0 448zM256 0a256 256 0 1 1 0 512 256 256 0 1 1 0-512zm24 96a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zM224 352a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm-32 0c0-18.6 7.9-35.3 20.5-47L129.9 151.6c-4.2-7.8-1.3-17.5 6.5-21.7s17.5-1.3 21.7 6.5l82.6 153.4c4.9-1.2 10-1.8 15.3-1.8 35.3 0 64 28.7 64 64s-28.7 64-64 64-64-28.7-64-64zM392 144a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm24 88a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM120 256a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z"]],
    "hexagon-equals": [576, 512, [], "e6b2", ["M61.3 236.2c-7 12.3-7 27.4 0 39.7L157.5 444c7.1 12.4 20.4 20.1 34.7 20.1l191.6 0c14.3 0 27.6-7.7 34.7-20.1l96.2-168.1c7-12.3 7-27.4 0-39.7L418.5 68.1C411.4 55.7 398.2 48 383.8 48L192.2 48c-14.3 0-27.6 7.7-34.7 20.1L61.3 236.2zM192 208c0-8.8 7.2-16 16-16l160 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-160 0c-8.8 0-16-7.2-16-16zm0 96c0-8.8 7.2-16 16-16l160 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-160 0c-8.8 0-16-7.2-16-16z", "M61.3 275.9L157.5 444c7.1 12.4 20.4 20.1 34.7 20.1l191.6 0c14.3 0 27.6-7.7 34.7-20.1l96.2-168.1c7-12.3 7-27.4 0-39.7L418.5 68.1C411.4 55.7 398.2 48 383.8 48L192.2 48c-14.3 0-27.6 7.7-34.7 20.1L61.3 236.2c-7 12.3-7 27.4 0 39.7zM33.5 291.8c-12.7-22.2-12.7-49.4 0-71.5L129.7 52.2C142.5 29.8 166.4 16 192.2 16l191.6 0c25.8 0 49.7 13.8 62.5 36.2l96.2 168.1c12.7 22.2 12.7 49.4 0 71.5L446.3 459.9c-12.8 22.4-36.7 36.2-62.5 36.2l-191.6 0c-25.8 0-49.7-13.8-62.5-36.2L33.5 291.8zM192 208c0-8.8 7.2-16 16-16l160 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-160 0c-8.8 0-16-7.2-16-16zm0 96c0-8.8 7.2-16 16-16l160 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-160 0c-8.8 0-16-7.2-16-16z"]],
    "capsule": [448, 512, [], "e75a", ["M32 344.2c0 57.3 46.5 103.8 103.8 103.8 27.5 0 53.9-10.9 73.4-30.4l76.9-76.9-146.7-146.7-76.9 76.9C42.9 290.3 32 316.7 32 344.2z", "M286.1 340.7L139.3 193.9 62.4 270.9c-19.5 19.5-30.4 45.9-30.4 73.4 0 57.3 46.5 103.8 103.8 103.8 27.5 0 53.9-10.9 73.4-30.4l76.9-76.9zm22.6-22.6l76.9-76.9c19.5-19.5 30.4-45.9 30.4-73.4 0-57.3-46.5-103.8-103.8-103.8-27.5 0-53.9 10.9-73.4 30.4l-76.9 76.9 146.7 146.7zm99.5-54.3L231.8 440.2c-25.5 25.5-60 39.8-96 39.8-75 0-135.8-60.8-135.8-135.8 0-36 14.3-70.5 39.8-96L216.2 71.8c25.5-25.5 60-39.8 96-39.8 75 0 135.8 60.8 135.8 135.8 0 36-14.3 70.5-39.8 96z"]],
    "user-sith": [448, 512, [], "e7b8", ["M16 512c8.8 0 16-7.2 16-16 0-61.9 50.1-112 112-112l160 0c61.9 0 112 50.1 112 112 0 8.8 7.2 16 16 16L16 512zM81.9 256l44.4-88.8c1.1-2.2 1.7-4.7 1.7-7.2l0-8c0-22.1 17.9-40 40-40l40 0 0 8c0 8.8 7.2 16 16 16s16-7.2 16-16l0-8 40 0c22.1 0 40 17.9 40 40l0 8c0 2.5 .6 4.9 1.7 7.2l44.4 88.8-68 0-58.2-69.8 0-10.2c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 10.2-58.2 69.8-68 0zM96 464l0 32c0 8.8 7.2 16 16 16s16-7.2 16-16l0-32c0-8.8-7.2-16-16-16s-16 7.2-16 16zM128.1 92c2-33.5 29.9-60 63.9-60l64 0c34 0 61.8 26.5 63.9 60-11.4-7.6-25.1-12-39.9-12L168 80c-14.7 0-28.5 4.4-39.9 12zM208 464l0 32c0 8.8 7.2 16 16 16s16-7.2 16-16l0-32c0-8.8-7.2-16-16-16s-16 7.2-16 16zm112 0l0 32c0 8.8 7.2 16 16 16s16-7.2 16-16l0-32c0-8.8-7.2-16-16-16s-16 7.2-16 16z", "M208 0c0-8.8 7.2-16 16-16s16 7.2 16 16l16 0c53 0 96 43 96 96l0 60.2 54.3 108.6c2.5 5 2.2 10.9-.7 15.6S397.5 288 392 288l-72 0c0 2.3-.5 4.6-1.5 6.8-2.6 5.6-8.3 9.2-14.5 9.2l-160 0c-6.2 0-11.9-3.6-14.5-9.2-1-2.2-1.5-4.5-1.5-6.8l-72 0c-5.5 0-10.7-2.9-13.6-7.6s-3.2-10.6-.7-15.6L96 156.2 96 96c0-53 43-96 96-96l16 0zM128 160c0 2.5-.6 4.9-1.7 7.2l-44.4 88.8 68 0 58.2-69.8 0-10.2c0-8.8 7.2-16 16-16s16 7.2 16 16l0 10.2 58.2 69.8 68 0-44.4-88.8c-1.1-2.2-1.7-4.7-1.7-7.2l0-8c0-22.1-17.9-40-40-40l-40 0 0 8c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-8-40 0c-22.1 0-40 17.9-40 40l0 8zM280 80c14.7 0 28.5 4.4 39.9 12-2-33.5-29.9-60-63.9-60l-64 0c-34 0-61.8 26.5-63.9 60 11.4-7.6 25.1-12 39.9-12l112 0zM144 384c-61.9 0-112 50.1-112 112 0 8.8-7.2 16-16 16S0 504.8 0 496c0-79.5 64.5-144 144-144l160 0c79.5 0 144 64.5 144 144 0 8.8-7.2 16-16 16s-16-7.2-16-16c0-61.9-50.1-112-112-112l-160 0zm-32 64c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zm112 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zm112 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM178.2 272l91.7 0-45.8-55-45.8 55z"]],
    "gauge": [512, 512, ["dashboard", "gauge-med", "tachometer-alt-average"], "f624", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm88 0a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm48-112a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm24 208c0-29.8 20.4-54.9 48-62l0-194c0-8.8 7.2-16 16-16s16 7.2 16 16l0 194c27.6 7.1 48 32.2 48 62 0 35.3-28.7 64-64 64s-64-28.7-64-64zM392 144a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm48 112a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M256 32a224 224 0 1 1 0 448 224 224 0 1 1 0-448zm0 480a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm0-192a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm0 96c35.3 0 64-28.7 64-64 0-29.8-20.4-54.9-48-62l0-194c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 194c-27.6 7.1-48 32.2-48 62 0 35.3 28.7 64 64 64zM144 168a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm-24 88a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm296 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM392 144a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"]],
    "envelope-open-text": [576, 512, [], "f658", ["M64 200.4L239.3 334.8c8.4 6.4 17.7 11 27.5 13.7l1 .8c1.4 1.1 2.8 2.1 4.2 2.9l0 95.3-189.1 0C72.1 445.2 64 435.6 64 424l0-223.6z", "M543.2 144c-2.3-12.4-9.5-23.4-20.2-30.5L332.4-13.6c-26.9-17.9-61.9-17.9-88.8 0L53 113.5c-12.9 8.6-20.8 23-21 38.5l0 272c0 30.9 24.9 56 55.9 56l184.1 0 0-32-184.1 0C74.7 448 64 437.3 64 424l0-223.6 175.3 134.4c9.9 7.6 21.1 12.5 32.7 14.9l0-33.1c-4.7-1.6-9.1-4-13.2-7.2L69.9 164.6c-3.7-2.9-5.9-7.3-5.9-12 0-5.1 2.5-9.8 6.7-12.6L261.4 13c16.1-10.7 37.1-10.7 53.3 0L505.3 140.1c1.6 1.1 2.9 2.4 4 3.9l33.9 0zM528 224c8.8 0 16 7.2 16 16l0 224c0 8.8-7.2 16-16 16l-160 0c-8.8 0-16-7.2-16-16l0-224c0-8.8 7.2-16 16-16l160 0zM368 192c-26.5 0-48 21.5-48 48l0 224c0 26.5 21.5 48 48 48l160 0c26.5 0 48-21.5 48-48l0-224c0-26.5-21.5-48-48-48l-160 0zm32 96c-8.8 0-16 7.2-16 16s7.2 16 16 16l96 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-96 0zm0 64c-8.8 0-16 7.2-16 16s7.2 16 16 16l80 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-80 0z"]],
    "toolbox": [512, 512, [129520], "f552", ["", "M176 32l160 0c8.8 0 16 7.2 16 16l0 48-192 0 0-48c0-8.8 7.2-16 16-16zM128 48l0 48-28.1 0c-12.7 0-24.9 5.1-33.9 14.1L14.1 161.9c-9 9-14.1 21.2-14.1 33.9L0 416c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-220.1c0-12.7-5.1-24.9-14.1-33.9l-51.9-51.9c-9-9-21.2-14.1-33.9-14.1l-28.1 0 0-48c0-26.5-21.5-48-48-48L176 0c-26.5 0-48 21.5-48 48zm16 80l268.1 0c4.2 0 8.3 1.7 11.3 4.7l51.9 51.9c3 3 4.7 7.1 4.7 11.3l0 92.1-112 0 0-32c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 32-160 0 0-32c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 32-112 0 0-92.1c0-4.2 1.7-8.3 4.7-11.3l51.9-51.9c3-3 7.1-4.7 11.3-4.7l44.1 0zM32 320l112 0 0 32c0 8.8 7.2 16 16 16s16-7.2 16-16l0-32 160 0 0 32c0 8.8 7.2 16 16 16s16-7.2 16-16l0-32 112 0 0 96c0 17.7-14.3 32-32 32L64 448c-17.7 0-32-14.3-32-32l0-96z"]],
    "wheat-slash": [576, 512, [], "e339", ["M296.2 62.8c-21.2 25.1-20 62.8 3.7 86.4l34.6 34.6 1.5-1.9 3.5-4.9c16-25.1 12.7-58.3-8.7-79.7L296.2 62.8zm63.9 146.7l34.6 34.6c23.7 23.7 61.3 24.9 86.4 3.7l-34.5-34.5c-22.8-22.8-59.1-25-84.6-5.2l-1.9 1.5zM448 77l0 19 19 0 6.2-.3c28.7-2.9 51.5-25.8 54.4-54.4l.3-6.2 0-19-19 0c-33.7 0-61 27.3-61 61z", "M4.7-27.2c5.5-5.5 13.9-6.2 20.1-2.1l2.5 2.1 544 544 2.1 2.5c4.1 6.2 3.4 14.7-2.1 20.1s-13.9 6.2-20.1 2.1l-2.5-2.1-544-544-2.1-2.5C-1.5-13.3-.8-21.8 4.7-27.2zM43.3 523.3c-6.2 6.2-16.3 6.2-22.6 0-6.2-6.2-6.2-16.4 0-22.6l22.6 22.6zM88 232c4.2 0 8.3 1.7 11.3 4.7l46.1 46.1c24.3 24.3 33 58.9 25.3 90.5 31.7-7.7 66.2 1 90.6 25.3l46.1 46.1c3 3 4.7 7.1 4.7 11.3s-1.7 8.3-4.7 11.3l-7.4 7.4c-37.5 37.5-98.3 37.5-135.7 0L128 438.6 43.3 523.3c-7.5-7.5-15-15.1-22.6-22.6l84.7-84.7-36.1-36.1c-37.5-37.5-37.5-98.3 0-135.7l7.4-7.4 2.4-2c2.6-1.7 5.7-2.7 8.9-2.7zM238.7 421.3c-22.8-22.8-59.1-25-84.6-5.3l-1.9 1.5 34.6 34.6c23.7 23.7 61.3 24.9 86.4 3.7l-34.5-34.5zm101.5-22.6c-25.9 1.1-52.2-8.1-72-27.9l-94.9-94.9c-19.8-19.8-29.1-46.1-27.9-72L340.1 398.6zM88.2 270.8c-21.2 25.1-20 62.8 3.7 86.4l34.6 34.6 1.5-1.9 3.5-4.9c16-25 12.7-58.3-8.7-79.7L88.2 270.8zM296 24c4.2 0 8.3 1.7 11.3 4.7l46.1 46.1c24.3 24.3 33 58.9 25.3 90.5 31.7-7.7 66.2 1 90.6 25.3l46.1 46.1c3 3 4.7 7.1 4.7 11.3s-1.7 8.3-4.7 11.3l-7.4 7.4c-37.5 37.5-98.3 37.5-135.8 0l-94.9-94.9c-37.5-37.5-37.5-98.3 0-135.7l7.4-7.4 2.4-2c2.6-1.7 5.7-2.7 8.9-2.7zM446.7 213.3c-22.8-22.8-59.1-25-84.6-5.2l-1.9 1.5 34.6 34.6c23.7 23.7 61.3 24.9 86.4 3.7l-34.5-34.5zM296.2 62.8c-21.2 25.1-20 62.8 3.7 86.4l34.6 34.6 1.5-1.9 3.5-4.9c16-25.1 12.7-58.3-8.7-79.7L296.2 62.8zM547.2-15.7c3.1 .6 5.9 2.1 8.2 4.4 3 3 4.7 7.1 4.7 11.3l0 35-.1 4.8c-2.4 47.5-40.6 85.7-88.1 88.1l-4.8 .1-35 0c-4.2 0-8.3-1.7-11.3-4.7S416 116.2 416 112l0-35c0-51.4 41.6-93 93-93l35 0 3.1 .3zM509 16c-33.7 0-61 27.3-61 61l0 19 19 0 6.2-.3c28.7-2.9 51.5-25.8 54.4-54.4l.3-6.2 0-19-19 0z"]],
    "power-off": [512, 512, [9211], "f011", ["M32 256c0 123.7 100.3 224 224 224S480 379.7 480 256c0-85.9-48.4-160.6-119.5-198.2-26.8-14.1-56.7-23-88.5-25.3L272 256c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-223.4C208.2 34.8 178.2 43.7 151.5 57.8 80.4 95.4 32 170.1 32 256z", "M272-16c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 272c0 8.8 7.2 16 16 16s16-7.2 16-16l0-272zM151.5 57.8c7.8-4.1 10.8-13.8 6.7-21.6s-13.8-10.8-21.6-6.7C55.4 72.4 0 157.7 0 256 0 397.4 114.6 512 256 512S512 397.4 512 256c0-98.3-55.4-183.6-136.5-226.5-7.8-4.1-17.5-1.1-21.6 6.7s-1.1 17.5 6.7 21.6C431.6 95.4 480 170.1 480 256 480 379.7 379.7 480 256 480S32 379.7 32 256C32 170.1 80.4 95.4 151.5 57.8z"]],
    "signal": [448, 512, [128246, "signal-5", "signal-perfect"], "f012", ["", "M448 48c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 416c0 8.8 7.2 16 16 16s16-7.2 16-16l0-416zM328 128c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16s16-7.2 16-16l0-320c0-8.8-7.2-16-16-16zM240 240c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 224c0 8.8 7.2 16 16 16s16-7.2 16-16l0-224zM120 320c-8.8 0-16 7.2-16 16l0 128c0 8.8 7.2 16 16 16s16-7.2 16-16l0-128c0-8.8-7.2-16-16-16zM16 384c-8.8 0-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16s16-7.2 16-16l0-64c0-8.8-7.2-16-16-16z"]],
    "arrows-spin": [512, 512, [], "e4bb", ["M32.1 368l0 84.7 84.8-84.7-84.8 0zM59.5 32l84.7 84.8 0-84.8-84.7 0zM368.1 395.3l0 84.8 84.7 0-84.7-84.8zM395.4 144l84.8 0 0-84.7-84.8 84.7z", "M66.4 84.1L23.2 40.9c-6.9-6.9-8.9-17.2-5.2-26.2S30.4 0 40.1 0l112 0c13.3 0 24 10.7 24 24l0 112.1c0 9.7-5.8 18.5-14.8 22.2s-19.3 1.7-26.2-5.2L89 106.8c-35.4 39.6-56.9 91.9-56.9 149.2 0 5 .2 10 .5 15 .6 8.8-6.1 16.4-14.9 17S1.2 281.9 .7 273c-.4-5.6-.6-11.3-.6-17 0-66.1 25.1-126.4 66.3-171.9zM59.5 32l84.7 84.8 0-84.8-84.7 0zm196.6 0c-5 0-10 .2-14.9 .5-8.8 .6-16.4-6.1-17-14.9S230.2 1.1 239 .6c5.6-.4 11.3-.6 17.1-.6 66.1 0 126.4 25.1 171.9 66.3L471.2 23c6.9-6.9 17.2-8.9 26.2-5.2S512.2 30.3 512.2 40l0 112c0 13.3-10.7 24-24 24l-112.1 0c-9.7 0-18.5-5.8-22.2-14.8s-1.7-19.3 5.2-26.2l46.2-46.1C365.7 53.5 313.4 32 256.1 32zM494.5 224c8.8-.6 16.4 6.1 17 14.9 .4 5.6 .6 11.3 .6 17.1 0 66.1-25.1 126.4-66.2 171.8l43.2 43.3c6.9 6.9 8.9 17.2 5.2 26.2S481.9 512 472.1 512l-112 0c-13.3 0-24-10.7-24-24l0-112.1c0-9.7 5.8-18.5 14.8-22.2s19.3-1.7 26.2 5.2l46.1 46.2c35.4-39.6 56.9-91.9 56.9-149.1 0-5-.2-10-.5-14.9-.6-8.8 6.1-16.4 14.9-17zM107 423.1c39.6 35.4 91.9 56.9 149.1 56.9 5 0 10-.2 15-.5 8.8-.6 16.4 6.1 17 14.9s-6.1 16.4-14.9 17c-5.6 .4-11.3 .6-17 .6-66.1 0-126.4-25.1-171.8-66.2L41.1 489c-6.9 6.9-17.2 8.9-26.2 5.2S.1 481.7 .1 472l0-112c0-13.3 10.7-24 24-24l112.1 0c9.7 0 18.5 5.8 22.2 14.8s1.7 19.3-5.2 26.2L107 423.1zM480.2 144l0-84.7-84.8 84.7 84.8 0zM32.1 452.7l84.8-84.7-84.8 0 0 84.7zm336 27.4l84.7 0-84.7-84.8 0 84.8z"]],
    "joint": [576, 512, [], "f595", ["M32 400c0 3.9 2.7 7.2 6.2 8l155.7 35.9c11.8 2.7 23.9 4.1 36 4.1l8 0-55-89.4-144.6 33.4c-3.5 .8-6.2 4.1-6.2 8zm184.7-47.5l58.7 95.5 77.9 0c8.1 0 16.3-.6 24.3-1.9l2.8-.4-57.7-93.7-92.9 0c-4.4 0-8.8 .2-13.2 .5zm143.8-.4l54.3 88.3 108.9-16.8c11.7-1.8 20.3-11.8 20.3-23.7s-8.6-21.9-20.3-23.7l-146-22.5c-5.7-.9-11.5-1.4-17.2-1.7z", "M384 0c-8.8 0-16 7.2-16 16l0 27c0 48.8 19.4 95.6 53.9 130.1l21 21C456.4 207.6 464 225.9 464 245l0 27c0 8.8 7.2 16 16 16s16-7.2 16-16l0-27c0-27.6-11-54-30.5-73.5l-21-21C416 122 400 83.3 400 43l0-27c0-8.8-7.2-16-16-16zM560 288c8.8 0 16-7.2 16-16l0-27c0-48.8-19.4-95.6-53.9-130.1l-21-21C487.6 80.4 480 62.1 480 43l0-27c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 27c0 27.6 11 54 30.5 73.5l21 21C528 166 544 204.7 544 245l0 27c0 8.8 7.2 16 16 16zM38.2 392l144.6-33.4 55 89.4-8 0c-12.1 0-24.2-1.4-36-4.1L38.2 408c-3.5-.8-6.2-4.1-6.2-8s2.7-7.2 6.2-8zm237.2 56l-58.7-95.5c4.4-.4 8.8-.5 13.2-.5l92.9 0 57.7 93.7-2.8 .4c-8 1.2-16.2 1.9-24.3 1.9l-77.9 0zm139.3-7.6l-54.3-88.3c5.8 .3 11.5 .8 17.2 1.7l146 22.5c11.7 1.8 20.3 11.8 20.3 23.7s-8.6 21.9-20.3 23.7L414.7 440.4zM186.7 324.9L31 360.8C12.9 365 0 381.4 0 400s12.9 35 31 39.2l155.7 35.9c14.2 3.3 28.6 4.9 43.2 4.9l123.5 0c9.8 0 19.5-.7 29.2-2.2l146-22.5c27.3-4.2 47.4-27.7 47.4-55.3s-20.1-51.1-47.4-55.3l-146-22.5c-9.7-1.5-19.4-2.2-29.2-2.2l-123.5 0c-14.5 0-29 1.6-43.2 4.9z"]],
    "down-from-line": [384, 512, ["arrow-alt-from-top"], "f349", ["M67.3 352L192 476.7 316.7 352 240 352c-8.8 0-16-7.2-16-16l0-160c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16l0 160c0 8.8-7.2 16-16 16l-76.7 0z", "M175 505l0 0c9.4 9.4 24.6 9.4 33.9 0l0 0 144-144c6.9-6.9 8.9-17.2 5.2-26.2S345.7 320 336 320l-80 0 0-144c0-26.5-21.5-48-48-48l-32 0c-26.5 0-48 21.5-48 48l0 144-80 0c-9.7 0-18.5 5.8-22.2 14.8S24.2 354.1 31 361L175 505zm49-249l0 80c0 8.8 7.2 16 16 16L316.7 352 192 476.7 67.3 352 144 352c8.8 0 16-7.2 16-16l0-160c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 80zM384 16c0-8.8-7.2-16-16-16L16 0C7.2 0 0 7.2 0 16S7.2 32 16 32l352 0c8.8 0 16-7.2 16-16z"]],
    "tablet-rugged": [448, 512, [], "f48f", ["M128 96l192 0 0 320-192 0 0-320z", "M64 176l0 16c0 12.1-6.8 23.2-17.7 28.6l-14.3 7.2 0 56.4 14.3 7.2C57.2 296.8 64 307.9 64 320l0 16c0 12.1-6.8 23.2-17.7 28.6l-14.3 7.2 0 56.4 16.6 8.3c8.1 4.1 14.1 11.3 16.5 20.1 3.8 13.5 16.2 23.4 30.8 23.4l256 0c14.7 0 27.1-9.9 30.8-23.4 2.4-8.7 8.4-16 16.5-20.1l16.6-8.3 0-56.4-14.3-7.2C390.8 359.2 384 348.1 384 336l0-16c0-12.1 6.8-23.2 17.7-28.6l14.3-7.2 0-56.4-14.3-7.2C390.8 215.2 384 204.1 384 192l0-16c0-12.1 6.8-23.2 17.7-28.6l14.3-7.2 0-56.4-16.6-8.3c-8.1-4-14.1-11.3-16.5-20.1-3.8-13.5-16.2-23.4-30.8-23.4L96 32c-14.7 0-27.1 9.9-30.8 23.4-2.4 8.7-8.4 16-16.5 20.1l-16.6 8.3 0 56.4 14.3 7.2C57.2 152.8 64 163.9 64 176zM21.3 314.7c-7-3.5-11.2-5.6-12.5-6.2-5.4-2.7-8.8-8.2-8.8-14.3l0-76.2c0-6.1 3.4-11.6 8.8-14.3 2.9-1.4 19.2-9.6 23.2-11.6l0-16c-17.5-8.7-22.9-11.4-23.2-11.6-5.4-2.7-8.8-8.3-8.8-14.3L0 73.9c0-6.1 3.4-11.6 8.8-14.3L34.3 46.8C41.8 19.8 66.6 0 96 0L352 0c29.4 0 54.2 19.8 61.7 46.8l25.5 12.7c5.4 2.7 8.8 8.3 8.8 14.3l0 76.2c0 6.1-3.4 11.6-8.8 14.3-2.9 1.4-19.2 9.6-23.2 11.6l0 16c17.5 8.7 22.9 11.4 23.2 11.6 5.4 2.7 8.8 8.3 8.8 14.3l0 76.2c0 6.1-3.4 11.6-8.8 14.3-2.9 1.4-19.2 9.6-23.2 11.6l0 16c7.4 3.7 14 7 19.8 9.9l3.4 1.7c5.4 2.7 8.8 8.2 8.8 14.3l0 76.2c0 6.1-3.4 11.6-8.8 14.3l-25.5 12.7c-7.5 27-32.3 46.8-61.7 46.8L96 512c-29.4 0-54.2-19.8-61.7-46.8L8.8 452.4C3.4 449.7 0 444.2 0 438.1l0-76.2c0-6.1 3.4-11.6 8.8-14.3 2.9-1.4 19.2-9.6 23.2-11.6l0-16-10.7-5.3zM128 96l0 320 192 0 0-320-192 0zM96 96c0-17.7 14.3-32 32-32l192 0c17.7 0 32 14.3 32 32l0 320c0 17.7-14.3 32-32 32l-192 0c-17.7 0-32-14.3-32-32L96 96z"]],
    "braille": [384, 512, [], "f2a1", ["M32 64a48 48 0 1 0 96 0 48 48 0 1 0 -96 0zm0 192a48 48 0 1 0 96 0 48 48 0 1 0 -96 0zM96 64a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm0 192a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zM256 64a48 48 0 1 0 96 0 48 48 0 1 0 -96 0zm64 0a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M80 16a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm0 128a80 80 0 1 0 0-160 80 80 0 1 0 0 160zm0 64a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm0 128a80 80 0 1 0 0-160 80 80 0 1 0 0 160zm48 112c0 26.5-21.5 48-48 48s-48-21.5-48-48 21.5-48 48-48 48 21.5 48 48zm32 0c0-44.2-35.8-80-80-80s-80 35.8-80 80 35.8 80 80 80 80-35.8 80-80zm144 48c-26.5 0-48-21.5-48-48s21.5-48 48-48 48 21.5 48 48-21.5 48-48 48zm0 32c44.2 0 80-35.8 80-80s-35.8-80-80-80-80 35.8-80 80 35.8 80 80 80zM256 256a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm128 0a80 80 0 1 0 -160 0 80 80 0 1 0 160 0zM304 16a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm0 128a80 80 0 1 0 0-160 80 80 0 1 0 0 160zM80 80a16 16 0 1 0 0-32 16 16 0 1 0 0 32zM96 256a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM304 80a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"]],
    "basket-shopping": [576, 512, ["shopping-basket"], "f291", ["M71 192l433.9 0-46.1 230.3c-3 15-16.1 25.7-31.4 25.7l-279.1 0c-15.3 0-28.4-10.8-31.4-25.7L71 192zm89 80l0 96c0 8.8 7.2 16 16 16s16-7.2 16-16l0-96c0-8.8-7.2-16-16-16s-16 7.2-16 16zm112 0l0 96c0 8.8 7.2 16 16 16s16-7.2 16-16l0-96c0-8.8-7.2-16-16-16s-16 7.2-16 16zm112 0l0 96c0 8.8 7.2 16 16 16s16-7.2 16-16l0-96c0-8.8-7.2-16-16-16s-16 7.2-16 16z", "M288 0c4.6 0 8.9 1.9 11.9 5.3L438.3 160 544 160c8.8 0 16 7.2 16 16s-7.2 16-16 16l-6.4 0-47.3 236.6c-6 29.9-32.2 51.4-62.8 51.4l-279.1 0c-30.5 0-56.8-21.5-62.8-51.4L38.4 192 32 192c-8.8 0-16-7.2-16-16s7.2-16 16-16l0 0 105.7 0 138.4-154.7c3-3.4 7.4-5.3 11.9-5.3zm0 40L180.6 160 395.4 160 288 40zM71 192l46.1 230.3c3 15 16.1 25.7 31.4 25.7l279.1 0c15.3 0 28.4-10.8 31.4-25.7L505 192 71 192zm121 80l0 96c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-96c0-8.8 7.2-16 16-16s16 7.2 16 16zm96-16c8.8 0 16 7.2 16 16l0 96c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-96c0-8.8 7.2-16 16-16zm128 16l0 96c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-96c0-8.8 7.2-16 16-16s16 7.2 16 16z"]],
    "party-bell": [512, 512, [], "e31a", ["M32 224c0-106 86-192 192-192 30.3 0 59 7 84.5 19.6 7.1 3.5 11.5 11 11.5 19.1 0 6-2.4 11.7-6.6 15.9L86.6 313.4c-4.2 4.2-9.9 6.6-15.9 6.6-8.1 0-15.6-4.3-19.1-11.5-12.5-25.5-19.6-54.2-19.6-84.5z", "M32 224c0-106 86-192 192-192 30.3 0 59 7 84.5 19.6 7.1 3.5 11.5 11 11.5 19.1 0 6-2.4 11.7-6.6 15.9L86.6 313.4c-4.2 4.2-9.9 6.6-15.9 6.6-8.1 0-15.6-4.3-19.1-11.5-12.5-25.5-19.6-54.2-19.6-84.5zM224 0c-123.7 0-224 100.3-224 224 0 35.3 8.2 68.9 22.8 98.7 9.5 19.3 28.8 29.3 47.8 29.3 14.5 0 28.3-5.7 38.5-16L336 109.2c10.2-10.2 16-24.1 16-38.5 0-19-10.1-38.4-29.3-47.8-29.8-14.6-63.3-22.8-98.7-22.8zM480 88a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM352 504a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM40 480a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zM364.7 172.7c-6.2 6.2-6.2 16.4 0 22.6l8.3 8.3c23.1 23.1 53.4 37.7 85.9 41.3l27.4 3c8.8 1 16.7-5.4 17.7-14.1s-5.4-16.7-14.1-17.7l-27.4-3c-25.3-2.8-48.8-14.1-66.8-32.1l-8.2-8.3c-6.2-6.2-16.4-6.2-22.6 0zm-169.4 192c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l8.3 8.2c18 18 29.3 41.6 32.1 66.8l3 27.4c1 8.8 8.9 15.1 17.7 14.1s15.1-8.9 14.1-17.7l-3-27.4c-3.6-32.5-18.2-62.8-41.3-85.9l-8.3-8.3zm303 135.5c6.7-5.7 7.6-15.8 1.9-22.6l-8.5-10c-6.2-7.3-9.4-16.6-9.2-26.1 1-38.2-28.5-70.4-66.6-72.6l-30-1.8c-20.9-1.2-37.1-18.8-36.5-39.8 .5-17.4-5.5-34.4-16.7-47.7l-8.5-10c-5.7-6.7-15.8-7.6-22.6-1.9s-7.6 15.8-1.9 22.6l8.5 10c6.2 7.3 9.4 16.6 9.2 26.1-1 38.2 28.5 70.4 66.6 72.6l30 1.8c20.9 1.2 37.1 18.8 36.5 39.8-.5 17.4 5.5 34.4 16.7 47.7l8.5 10c5.7 6.7 15.8 7.6 22.6 1.9z"]],
    "bra": [576, 512, [], "e6cf", ["M48 336c0 61.9 50.1 112 112 112 37 0 69.9-18 90.3-45.7l-13.8-19.4c-32-44.8-76.2-79.5-127.4-100L71.2 267.7C56.6 286.7 48 310.3 48 336zm277.7 66.3c20.4 27.8 53.3 45.7 90.3 45.7 61.9 0 112-50.1 112-112 0-25.7-8.6-49.4-23.2-68.3l-37.9 15.1c-51.2 20.5-95.4 55.2-127.4 100l-13.8 19.4z", "M127.6 51.6c2-8.6-3.4-17.2-12-19.2s-17.2 3.4-19.2 12L50.8 242.2c-21.7 25.2-34.8 58-34.8 93.8 0 79.5 64.5 144 144 144 49.9 0 93.9-25.4 119.8-64l16.5 0c25.8 38.6 69.8 64 119.8 64 79.5 0 144-64.5 144-144 0-35.8-13.1-68.6-34.8-93.8L479.6 44.4c-2-8.6-10.6-14-19.2-12s-14 10.6-12 19.2l43.1 187-36.5 14.6c-56.8 22.7-106 61.3-141.6 111.1l-14.1 19.7-22.9 0-14.1-19.7c-35.6-49.8-84.7-88.4-141.6-111.1l-36.5-14.6 43.1-187zM236.5 382.9l13.8 19.4c-20.4 27.8-53.3 45.7-90.3 45.7-61.9 0-112-50.1-112-112 0-25.7 8.6-49.3 23.2-68.3l37.9 15.1c51.2 20.5 95.4 55.2 127.4 100zm103.1 0c32-44.8 76.2-79.5 127.4-100l37.9-15.1c14.6 18.9 23.2 42.6 23.2 68.3 0 61.9-50.1 112-112 112-37 0-69.9-18-90.3-45.7l13.8-19.4z"]],
    "car-wash": [448, 512, [], "f5e6", ["M32 336l0 96 384 0 0-96c0-17.7-14.3-32-32-32L64 304c-17.7 0-32 14.3-32 32zm88 32a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm256 0a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M240 48c0 8.4-2.6 11.4-3.7 12.5-1.6 1.5-5.3 3.5-12.3 3.5-8.8 0-16-7.2-16-16 0-1.7 1.6-8.3 8.6-19.6 2.3-3.7 4.8-7.5 7.4-11 2.6 3.6 5.2 7.3 7.4 11 6.9 11.3 8.6 17.9 8.6 19.6zm32 0c0-22.2-23-52-37.2-68.2-5.8-6.7-15.9-6.7-21.7 0-14.2 16.3-37.2 46.1-37.2 68.2 0 26.5 21.5 48 48 48s48-16 48-48zM131.9 176l184.2 0c14.2 0 26.7 9.4 30.7 23l21.5 73-288.5 0 21.5-73c4-13.6 16.5-23 30.7-23zM70.5 189.9L45.6 274.7C19.2 282.6 0 307.1 0 336L0 496c0 8.8 7.2 16 16 16s16-7.2 16-16l0-32 384 0 0 32c0 8.8 7.2 16 16 16s16-7.2 16-16l0-160c0-28.9-19.2-53.4-45.6-61.3l-24.9-84.7c-8-27.2-33-45.9-61.4-45.9l-184.2 0c-28.4 0-53.4 18.7-61.4 45.9zM416 384l0 48-384 0 0-96c0-17.7 14.3-32 32-32l320 0c17.7 0 32 14.3 32 32l0 48zM96 392a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm280-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM76.3 60.5c-1.6 1.5-5.3 3.5-12.3 3.5-8.8 0-16-7.2-16-16 0-1.7 1.6-8.3 8.6-19.6 2.3-3.7 4.8-7.5 7.4-11 2.6 3.6 5.2 7.3 7.4 11 6.9 11.3 8.6 17.9 8.6 19.6 0 8.4-2.6 11.4-3.7 12.5zM64 96C90.5 96 112 80 112 48 112 25.8 89-4 74.8-20.2 69-26.9 59-26.9 53.2-20.2 39-4 16 25.8 16 48 16 74.5 37.5 96 64 96zM400 48c0 8.4-2.6 11.4-3.7 12.5-1.6 1.5-5.3 3.5-12.3 3.5-8.8 0-16-7.2-16-16 0-1.7 1.6-8.3 8.6-19.6 2.3-3.7 4.8-7.5 7.4-11 2.6 3.6 5.2 7.3 7.4 11 6.9 11.3 8.6 17.9 8.6 19.6zm32 0c0-22.2-23-52-37.2-68.2-5.8-6.7-15.9-6.7-21.7 0-14.2 16.3-37.2 46.1-37.2 68.2 0 26.5 21.5 48 48 48s48-16 48-48z"]],
    "face-sunglasses": [512, 512, [], "e398", ["M0 256c0-71.9 29.7-136.9 77.4-183.4 3.7-.4 7.5-.6 11.3-.6l39.6 0C164.5 46.8 208.5 32 256 32s91.5 14.8 127.8 40l39.6 0c3.8 0 7.6 .2 11.3 .6 47.7 46.5 77.4 111.5 77.4 183.4 0 2.2 0 4.4-.1 6.6-7.9 19.7-21.4 36.2-38.5 47.7-24.3 97.5-112.4 169.7-217.4 169.7S62.9 407.8 38.6 310.3c-17.1-11.5-30.7-28-38.5-47.7-.1-2.2-.1-4.4-.1-6.6zm25.5-69.5l8 48C38.7 265.4 65.4 288 96.7 288l78.7 0c31.3 0 58-22.6 63.1-53.5l8-48c.6-3.5 .9-7.1 .9-10.5l17.3 0c0 3.5 .3 7 .9 10.5l8 48c5.1 30.9 31.8 53.5 63.1 53.5l78.7 0c31.3 0 58-22.6 63.1-53.5l8-48c6.5-39-23.6-74.5-63.1-74.5l-94.7 0c-24 0-44.5 13-55.4 32l-34.5 0c-11-19-31.5-32-55.4-32l-94.7 0c-39.5 0-69.6 35.5-63.1 74.5zM134.3 359.9c29.3 34.3 73 56.1 121.7 56.1s92.4-21.8 121.7-56.1c5.7-6.7 5-16.8-1.8-22.6s-16.8-5-22.6 1.8C329.8 366.6 295 384 256 384s-73.8-17.4-97.3-44.9c-5.7-6.7-15.8-7.5-22.6-1.8s-7.5 15.8-1.8 22.6z", "M256 480c105 0 193.1-72.2 217.4-169.7 17.1-11.5 30.7-28 38.5-47.7-3.5 138.3-116.7 249.4-255.9 249.4S3.6 400.9 .1 262.6C7.9 282.3 21.5 298.8 38.6 310.3 62.9 407.8 151 480 256 480zM128.2 72L88.7 72C84.8 72 81.1 72.2 77.4 72.6 123.5 27.7 186.5 0 256 0S388.5 27.7 434.6 72.6c-3.7-.4-7.5-.6-11.3-.6l-39.6 0C347.5 46.8 303.5 32 256 32S164.5 46.8 128.2 72zm7.9 265.3c6.7-5.7 16.8-5 22.6 1.8 23.5 27.5 58.4 44.9 97.3 44.9s73.8-17.4 97.3-44.9c5.7-6.7 15.8-7.5 22.6-1.8s7.5 15.8 1.8 22.6C348.4 394.2 304.7 416 256 416s-92.4-21.8-121.7-56.1c-5.7-6.7-5-16.8 1.8-22.6zM264.6 176l-17.3 0c0 3.5-.3 7-.9 10.5l-8 48c-5.1 30.9-31.8 53.5-63.1 53.5l-78.7 0c-31.3 0-58-22.6-63.1-53.5l-8-48C19 147.5 49.1 112 88.7 112l94.7 0c24 0 44.5 13 55.4 32l34.5 0c11-19 31.5-32 55.4-32l94.7 0c39.5 0 69.6 35.5 63.1 74.5l-8 48c-5.1 30.9-31.8 53.5-63.1 53.5l-78.7 0c-31.3 0-58-22.6-63.1-53.5l-8-48c-.6-3.5-.9-7.1-.9-10.5zm32.5 5.3l8 48c1 5.9 3.5 11.1 7.1 15.4l33.6-100.7-17.1 0c-19.8 0-34.8 17.8-31.6 37.3zM409.8 144l-30.3 0-37.3 112 30.3 0 37.3-112zm31.8 5.7l-35.4 106.3 9.1 0c15.6 0 29-11.3 31.6-26.7l8-48c2.1-12.7-3.6-24.7-13.3-31.5zM88.7 144c-19.8 0-34.8 17.8-31.6 37.3l8 48c1 5.9 3.5 11.1 7.1 15.4l33.6-100.7-17.1 0zm43.8 112l37.3-112-30.3 0-37.3 112 30.3 0zm69.2-106.3l-35.4 106.3 9.1 0c15.6 0 29-11.3 31.6-26.7l8-48c2.1-12.7-3.6-24.7-13.3-31.5z"]],
    "bridge": [512, 512, [], "e4c8", ["M32 160l0 83.9c38 13.4 64 49.5 64 90.5l0 113.5 64 0 0-96c0-53 43-96 96-96s96 43 96 96l0 96 64 0 0-113.5c0-41 26-77.1 64-90.5l0-83.9-448 0z", "M16 32C7.2 32 0 39.2 0 48S7.2 64 16 64l32 0 0 64-32 0c-8.8 0-16 7.2-16 16L0 256c0 7.3 5 13.7 12.1 15.5l3.4 .9C44 279.5 64 305.1 64 334.5L64 448c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-96c0-35.3 28.7-64 64-64s64 28.7 64 64l0 96c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-113.5c0-29.4 20-55 48.5-62.1l3.4-.9c7.1-1.8 12.1-8.2 12.1-15.5l0-112c0-8.8-7.2-16-16-16l-32 0 0-64 32 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L16 32zM432 64l0 64-96 0 0-64 96 0zM304 64l0 64-96 0 0-64 96 0zM176 64l0 64-96 0 0-64 96 0zM32 243.9l0-83.9 448 0 0 83.9c-38 13.4-64 49.5-64 90.5l0 113.5-64 0 0-96c0-53-43-96-96-96s-96 43-96 96l0 96-64 0 0-113.5c0-41-26-77.1-64-90.5z"]],
    "arrows-from-line": [384, 512, [], "e0a4", ["", "M180.7-27.3c6.2-6.2 16.4-6.2 22.6 0l80 80c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L208 22.6 208 176c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-153.4-52.7 52.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l80-80zM0 256c0-8.8 7.2-16 16-16l352 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L16 272c-8.8 0-16-7.2-16-16zM283.3 459.3l-80 80c-6.2 6.2-16.4 6.2-22.6 0l-80-80c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0L176 489.4 176 336c0-8.8 7.2-16 16-16s16 7.2 16 16l0 153.4 52.7-52.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6z"]],
    "up-long-to-line": [320, 512, [], "e6c6", ["M32 224l80 0c8.8 0 16 7.2 16 16l0 288c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-288c0-8.8 7.2-16 16-16l80 0-128-128-128 128z", "M304-64c8.8 0 16 7.2 16 16s-7.2 16-16 16L16-32C7.2-32 0-39.2 0-48S7.2-64 16-64l288 0zM137.4 73.4c12.5-12.5 32.8-12.5 45.3 0l128 128c9.2 9.2 11.9 22.9 6.9 34.9S300.9 256 288 256l-64 0 0 272c0 26.5-21.5 48-48 48l-32 0c-26.5 0-48-21.5-48-48l0-272-64 0c-12.9 0-24.6-7.8-29.6-19.8S.2 210.5 9.4 201.4l128-128zM160 96l-128 128 80 0c8.8 0 16 7.2 16 16l0 288c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-288c0-8.8 7.2-16 16-16l80 0-128-128z"]],
    "up-to-line": [384, 512, ["arrow-alt-to-top"], "f34d", ["M67.3 288l76.7 0c8.8 0 16 7.2 16 16 0 53.3 0 106.7 0 160 0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-160c0-8.8 7.2-16 16-16L316.7 288 192 163.3 67.3 288z", "M0 16c0 8.8 7.2 16 16 16l352 0c8.8 0 16-7.2 16-16S376.8 0 368 0L16 0C7.2 0 0 7.2 0 16zM209 135c-9.4-9.4-24.6-9.4-33.9 0L31 279c-6.9 6.9-8.9 17.2-5.2 26.2S38.3 320 48 320l80 0 0 64 0 0 0 80c0 26.5 21.5 48 48 48l32 0c26.5 0 48-21.5 48-48l0-144 80 0c9.7 0 18.5-5.8 22.2-14.8s1.7-19.3-5.2-26.2L209 135zm15 249l0 80c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-80 0 0 0-80c0-8.8-7.2-16-16-16L67.3 288 192 163.3 316.7 288 240 288c-8.8 0-16 7.2-16 16l0 80z"]],
    "plane-arrival": [576, 512, [128748], "f5af", ["M49.5 116.3l.6 106.3c.1 23.2 16.8 43 39.7 47 13.9 2.5 22.7 4 26.2 4.6l386 68.1c17.4 3.1 34-8.6 37.1-26s-8.6-34-26-37.1L402.8 259.8c-4.4-.8-8.3-3.4-10.7-7.2l-136.2-213.7-50-8.8 26.4 178.2c.8 5.1-1 10.2-4.7 13.8s-8.9 5.2-13.9 4.3L127 211.2c-4.8-.8-8.9-3.8-11.3-8.1L70.3 120 49.5 116.3z", "M513.1 279.3c17.4 3.1 29 19.7 26 37.1s-19.7 29-37.1 26l-386-68.1c-3.5-.6-12.2-2.2-26.2-4.6-22.8-4-39.5-23.8-39.7-47l-.6-106.3 20.8 3.7 45.4 83.2c2.3 4.3 6.5 7.2 11.3 8.1l86.7 15.3c5.1 .9 10.3-.7 13.9-4.3s5.4-8.7 4.7-13.8L205.9 30.2 255.8 39 392 252.7c2.4 3.8 6.3 6.4 10.7 7.2l110.3 19.4zm57.5 42.6c6.1-34.8-17.1-68-51.9-74.1L415.3 229.5 279 15.8c-2.4-3.8-6.3-6.4-10.7-7.2L189.6-5.2c-5.1-.9-10.3 .7-13.9 4.3s-5.4 8.7-4.7 13.8l26.4 178.2-57.2-10.1-45.4-83.2c-2.3-4.3-6.5-7.2-11.3-8.1L36.2 81.5c-4.7-.8-9.5 .5-13.1 3.5s-5.7 7.6-5.7 12.3l.7 125.5c.2 38.7 28 71.6 66.1 78.4 13.9 2.5 22.7 4 26.2 4.6l386 68.1c34.8 6.1 68-17.1 74.1-51.9zM225.3 423a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm118.5-7.3a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM16 480c-8.8 0-16 7.2-16 16s7.2 16 16 16l544 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L16 480z"]],
    "pot-food": [640, 512, [127858], "e43f", ["M98.9 272.9l.6 10.3c4.2 72.1 47.8 133 109.3 162.2 7.7 3.7 13.7 10.3 16.5 18.4 3.3 9.4 12.2 16.1 22.7 16.1l144 0c10.4 0 19.4-6.7 22.7-16.1 2.8-8.1 8.7-14.7 16.5-18.4 61.4-29.2 105-90.1 109.3-162.2l.6-10.3c.5-9.2-6.8-16.9-16-16.9l-410.2 0c-9.2 0-16.5 7.8-16 16.9zM358.7 192l146.7 0c-12.3-28.3-40.5-48-73.3-48s-61 19.7-73.3 48z", "M128 16c0-8.8-7.2-16-16-16S96 7.2 96 16c0 27.6 4.2 46.8 11.8 61.5 7.4 14.5 17.4 23.2 25.3 30.1l.5 .4c8 7 13.8 12.3 18.3 21 4.5 8.8 8.2 22.5 8.2 47 0 8.8 7.2 16 16 16s16-7.2 16-16c0-27.6-4.2-46.8-11.8-61.5-7.4-14.5-17.4-23.2-25.3-30.1l-.5-.4c-8-7-13.8-12.3-18.3-21-4.5-8.8-8.2-22.5-8.2-47zm96 0c0-8.8-7.2-16-16-16s-16 7.2-16 16c0 27.6 4.2 46.8 11.8 61.5 7.4 14.5 17.4 23.2 25.3 30.1l.5 .4c8 7 13.8 12.3 18.3 21 4.5 8.8 8.2 22.5 8.2 47 0 8.8 7.2 16 16 16s16-7.2 16-16c0-27.6-4.2-46.8-11.8-61.5-7.4-14.5-17.4-23.2-25.3-30.1l-.5-.4c-8-7-13.8-12.3-18.3-21-4.5-8.8-8.2-22.5-8.2-47zM32 256c-8.8 0-16 7.2-16 16s7.2 16 16 16l35.8 0c5.9 82.9 56.5 152.7 127.3 186.4 7.6 21.9 28.4 37.6 52.9 37.6l144 0c24.5 0 45.3-15.7 52.9-37.6 70.8-33.7 121.4-103.5 127.3-186.4l35.8 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-37.6 0c-6.6-18.6-24.3-32-45.3-32l-410.2 0c-21 0-38.7 13.4-45.3 32L32 256zm507.4-64c-13.8-46.3-56.6-80-107.4-80s-93.6 33.7-107.4 80l34 0c12.3-28.3 40.5-48 73.3-48s61 19.7 73.3 48l34 0zM225.3 463.9c-2.8-8.1-8.7-14.7-16.5-18.4-61.4-29.2-105-90.1-109.3-162.2l-.6-10.3c-.5-9.2 6.8-16.9 16-16.9l410.2 0c9.2 0 16.5 7.8 16 16.9l-.6 10.3c-4.2 72.1-47.8 133-109.3 162.2-7.7 3.7-13.7 10.3-16.5 18.4-3.3 9.4-12.2 16.1-22.7 16.1l-144 0c-10.4 0-19.4-6.7-22.7-16.1z"]],
    "cash-register": [512, 512, [], "f788", ["M32 416l0 32c0 17.7 14.3 32 32 32l384 0c17.7 0 32-14.3 32-32l0-32-448 0zm.3-32l447.3 0-23.5-164.5c-2.3-15.8-15.8-27.5-31.7-27.5l-337 0c-15.9 0-29.4 11.7-31.7 27.5L32.3 384zM136 256a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm48 80a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm48-80a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm48 80a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm48-80a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm48 80a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm48-80a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M256 32c17.7 0 32 14.3 32 32s-14.3 32-32 32L96 96C78.3 96 64 81.7 64 64S78.3 32 96 32l160 0zM96 0C60.7 0 32 28.7 32 64s28.7 64 64 64l64 0 0 32-72.5 0c-31.8 0-58.9 23.4-63.4 54.9L.6 379.5c-.4 3-.6 6-.6 9L0 448c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-59.5c0-3-.2-6.1-.6-9L487.8 214.9c-4.5-31.5-31.5-54.9-63.4-54.9l-232.5 0 0-32 64 0c35.3 0 64-28.7 64-64S291.3 0 256 0L96 0zM32 448l0-32 448 0 0 32c0 17.7-14.3 32-32 32L64 480c-17.7 0-32-14.3-32-32zM456.2 219.5L479.7 384 32.3 384 55.8 219.5C58.1 203.7 71.6 192 87.5 192l337 0c15.9 0 29.4 11.7 31.7 27.5zM112 232a24 24 0 1 0 0 48 24 24 0 1 0 0-48zm72 24a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm-24 56a24 24 0 1 0 0 48 24 24 0 1 0 0-48zm120-56a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm-24 56a24 24 0 1 0 0 48 24 24 0 1 0 0-48zm120-56a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm-24 56a24 24 0 1 0 0 48 24 24 0 1 0 0-48z"]],
    "ring": [512, 512, [], "f70b", ["M32 192c0 14.3 8.7 30 27.6 44.8 6.3-3.7 13-7.2 19.9-10.4 46-21.5 108.4-34.3 176.5-34.3s130.5 12.8 176.5 34.3c6.9 3.2 13.6 6.7 19.9 10.4 18.9-14.8 27.6-30.4 27.6-44.8 0-21-18.9-45-61.1-64.7-40.9-19.1-98.5-31.3-162.9-31.3S133.9 108.2 93.1 127.3C50.9 147 32 171 32 192zm0 63.3L32 320c0 21 18.9 45 61.1 64.7 40.9 19.1 98.5 31.3 162.9 31.3s122.1-12.2 162.9-31.3C461.1 365 480 341 480 320l0-64.7c-13.2 11.8-29.5 22-47.5 30.4-46 21.5-108.4 34.3-176.5 34.3S125.5 307.2 79.5 285.7c-18-8.4-34.4-18.6-47.5-30.4z", "M93.1 127.3C133.9 108.2 191.5 96 256 96s122.1 12.2 162.9 31.3c42.2 19.7 61.1 43.7 61.1 64.7 0 14.3-8.7 30-27.6 44.8-6.3-3.7-13-7.2-19.9-10.4-46-21.5-108.4-34.3-176.5-34.3S125.5 204.8 79.5 226.3C72.6 229.5 66 233 59.6 236.8 40.7 222 32 206.3 32 192 32 171 50.9 147 93.1 127.3zM480 255.3l0 64.7c0 21-18.9 45-61.1 64.7-40.9 19.1-98.5 31.3-162.9 31.3S133.9 403.8 93.1 384.7C50.9 365 32 341 32 320l0-64.7c13.2 11.8 29.5 22 47.5 30.4 46 21.5 108.4 34.3 176.5 34.3s130.5-12.8 176.5-34.3c18-8.4 34.4-18.6 47.5-30.4zM0 192L0 320c0 40.8 34.8 72.8 79.5 93.7 46 21.5 108.4 34.3 176.5 34.3s130.5-12.8 176.5-34.3C477.2 392.8 512 360.8 512 320l0-128c0-40.8-34.8-72.8-79.5-93.7-46-21.5-108.4-34.3-176.5-34.3S125.5 76.8 79.5 98.3C34.8 119.2 0 151.2 0 192zm93.1 64.7l-1.5-.7 1.5-.7C133.9 236.2 191.5 224 256 224s122.1 12.2 162.9 31.3l1.5 .7-1.5 .7C378.1 275.8 320.5 288 256 288S133.9 275.8 93.1 256.7z"]],
    "message-xmark": [512, 512, ["comment-alt-times", "message-times"], "f4ab", ["M32 128l0 224c0 35.3 28.7 64 64 64l40 0c13.3 0 24 10.7 24 24l0 68 112-84c6.9-5.2 15.3-8 24-8l120 0c35.3 0 64-28.7 64-64l0-224c0-35.3-28.7-64-64-64L96 64c-35.3 0-64 28.7-64 64zm156.7 44.7c6.2-6.2 16.4-6.2 22.6 0l44.7 44.7 44.7-44.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6l-44.7 44.7 44.7 44.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-44.7-44.7-44.7 44.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l44.7-44.7-44.7-44.7c-6.2-6.2-6.2-16.4 0-22.6z", "M179.2 533.6l0 0 112-84c1.4-1 3.1-1.6 4.8-1.6l120 0c53 0 96-43 96-96l0-224c0-53-43-96-96-96L96 32C43 32 0 75 0 128L0 352c0 53 43 96 96 96l32 0 0 68c0 15.5 12.5 28 28 28 6.1 0 12-2 16.8-5.6l6.4-4.8zM160 448l0-8c0-13.3-10.7-24-24-24l-40 0c-35.3 0-64-28.7-64-64l0-224c0-35.3 28.7-64 64-64l320 0c35.3 0 64 28.7 64 64l0 224c0 35.3-28.7 64-64 64l-120 0c-8.7 0-17.1 2.8-24 8l-112 84 0-60zm28.7-275.3c-6.2 6.2-6.2 16.4 0 22.6l44.7 44.7-44.7 44.7c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l44.7-44.7 44.7 44.7c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-44.7-44.7 44.7-44.7c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-44.7 44.7-44.7-44.7c-6.2-6.2-16.4-6.2-22.6 0z"]],
    "share-nodes": [512, 512, ["share-alt"], "f1e0", ["M32 256c0 35.3 28.7 64 64 64 18.3 0 34.7-7.7 46.4-19.9 6.7-7 11.8-15.6 14.7-25 .3-1 .6-1.9 .8-2.9 1.3-5.1 2-10.6 2-16.1s-.7-11-2-16.1c-2.6-10.2-7.7-19.4-14.6-26.9-.3-.4-.6-.7-1-1-11.7-12.3-28.1-19.9-46.4-19.9-35.3 0-64 28.7-64 64zM320 96c0 5.6 .7 11 2 16.1 2.6 10.2 7.7 19.4 14.6 26.9 .3 .4 .6 .7 1 1 11.7 12.3 28.1 19.9 46.4 19.9 35.3 0 64-28.7 64-64s-28.7-64-64-64-64 28.7-64 64zm0 320c0 35.3 28.7 64 64 64s64-28.7 64-64-28.7-64-64-64c-18.3 0-34.7 7.6-46.4 19.9-.3 .3-.7 .7-1 1-6.9 7.5-11.9 16.7-14.6 26.9-1.3 5.1-2 10.5-2 16.1z", "M448 96c0-35.3-28.7-64-64-64s-64 28.7-64 64c0 5.6 .7 11 2 16.1 2.6 10.2 7.7 19.4 14.6 26.9 .3 .4 .6 .7 1 1 11.7 12.3 28.1 19.9 46.4 19.9 35.3 0 64-28.7 64-64zM293.5 128c-3.5-10-5.5-20.8-5.5-32 0-53 43-96 96-96s96 43 96 96-43 96-96 96c-30.3 0-57.4-14.1-75-36L186.5 224c3.5 10 5.5 20.8 5.5 32s-1.9 22-5.5 32L309 356c17.6-22 44.6-36 75-36 53 0 96 43 96 96s-43 96-96 96-96-43-96-96c0-11.2 1.9-22 5.5-32L171 316c-17.6 22-44.6 36-75 36-53 0-96-43-96-96s43-96 96-96c30.3 0 57.4 14.1 75 36l122.5-68zM142.4 211.9c-11.7-12.3-28.1-19.9-46.4-19.9-35.3 0-64 28.7-64 64s28.7 64 64 64c18.3 0 34.7-7.7 46.4-19.9 6.7-7 11.8-15.6 14.7-25 .3-1 .6-1.9 .8-2.9 1.3-5.1 2-10.6 2-16.1s-.7-11-2-16.1c-2.6-10.2-7.7-19.4-14.6-26.9-.3-.4-.6-.7-1-1zM384 480c35.3 0 64-28.7 64-64s-28.7-64-64-64c-18.3 0-34.7 7.6-46.4 19.9-.3 .3-.7 .7-1 1-6.9 7.5-11.9 16.7-14.6 26.9-1.3 5.1-2 10.5-2 16.1 0 35.3 28.7 64 64 64z"]],
    "octagon-divide": [512, 512, [], "e203", ["M32.5 181.6l0 148.8c0 4.2 1.7 8.3 4.7 11.3L170.7 475.2c3 3 7.1 4.7 11.3 4.7l148.8 0c4.2 0 8.3-1.7 11.3-4.7L475.7 341.7c3-3 4.7-7.1 4.7-11.3l0-148.8c0-4.2-1.7-8.3-4.7-11.3L342.2 36.8c-3-3-7.1-4.7-11.3-4.7L182 32.1c-4.2 0-8.3 1.7-11.3 4.7L37.2 170.3c-3 3-4.7 7.1-4.7 11.3zM144.4 256c0-8.8 7.2-16 16-16l192 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-192 0c-8.8 0-16-7.2-16-16zm136-96a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm0 192a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M.5 330.4c0 12.7 5.1 24.9 14.1 33.9L148.1 497.9c9 9 21.2 14.1 33.9 14.1l148.8 0c12.7 0 24.9-5.1 33.9-14.1L498.3 364.4c9-9 14.1-21.2 14.1-33.9l0-148.8c0-12.7-5.1-24.9-14.1-33.9L364.8 14.1c-9-9-21.2-14.1-33.9-14.1L182 .1c-12.7 0-24.9 5.1-33.9 14.1L14.6 147.6c-9 9-14.1 21.2-14.1 33.9l0 148.8zM182 32.1l148.8 0c4.2 0 8.3 1.7 11.3 4.7L475.7 170.3c3 3 4.7 7.1 4.7 11.3l0 148.8c0 4.2-1.7 8.3-4.7 11.3L342.2 475.2c-3 3-7.1 4.7-11.3 4.7l-148.8 0c-4.2 0-8.3-1.7-11.3-4.7L37.2 341.7c-3-3-4.7-7.1-4.7-11.3l0-148.8c0-4.2 1.7-8.3 4.7-11.3L170.7 36.8c3-3 7.1-4.7 11.3-4.7zM256.4 184a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm-96 56c-8.8 0-16 7.2-16 16s7.2 16 16 16l192 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-192 0zm120 112a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"]],
    "folder-arrow-up": [512, 512, ["folder-upload"], "e054", ["M32 96l0 288c0 17.7 14.3 32 32 32l384 0c17.7 0 32-14.3 32-32l0-240c0-17.7-14.3-32-32-32l-149.3 0c-13.8 0-27.3-4.5-38.4-12.8L221.9 70.4c-5.5-4.2-12.3-6.4-19.2-6.4L64 64C46.3 64 32 78.3 32 96zM172.7 244.7l72-72c6.2-6.2 16.4-6.2 22.6 0l72 72c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L272 222.6 272 344c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-121.4-44.7 44.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6z", "M480 384c0 17.7-14.3 32-32 32L64 416c-17.7 0-32-14.3-32-32L32 96c0-17.7 14.3-32 32-32l138.7 0c6.9 0 13.7 2.2 19.2 6.4l38.4 28.8c11.1 8.3 24.6 12.8 38.4 12.8L448 112c17.7 0 32 14.3 32 32l0 240zM64 448l384 0c35.3 0 64-28.7 64-64l0-240c0-35.3-28.7-64-64-64L298.7 80c-6.9 0-13.7-2.2-19.2-6.4L241.1 44.8C230 36.5 216.5 32 202.7 32L64 32C28.7 32 0 60.7 0 96L0 384c0 35.3 28.7 64 64 64zM267.3 172.7c-6.2-6.2-16.4-6.2-22.6 0l-72 72c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0L240 222.6 240 344c0 8.8 7.2 16 16 16s16-7.2 16-16l0-121.4 44.7 44.7c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-72-72z"]],
    "arrows-minimize": [448, 512, ["compress-arrows"], "e0a5", ["", "M4.7 36.7c6.2-6.2 16.4-6.2 22.6 0L160 169.4 160 80c0-8.8 7.2-16 16-16s16 7.2 16 16l0 128c0 8.8-7.2 16-16 16L48 224c-8.8 0-16-7.2-16-16s7.2-16 16-16L137.4 192 4.7 59.3c-6.2-6.2-6.2-16.4 0-22.6zm438.6 0c6.2 6.2 6.2 16.4 0 22.6L310.6 192 400 192c8.8 0 16 7.2 16 16s-7.2 16-16 16l-128 0c-8.8 0-16-7.2-16-16l0-128c0-8.8 7.2-16 16-16s16 7.2 16 16l0 89.4 132.7-132.7c6.2-6.2 16.4-6.2 22.6 0zM32 304c0-8.8 7.2-16 16-16l128 0c8.8 0 16 7.2 16 16l0 128c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-89.4-132.7 132.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6L137.4 320 48 320c-8.8 0-16-7.2-16-16zm224 0c0-8.8 7.2-16 16-16l128 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-89.4 0 132.7 132.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L288 342.6 288 432c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-128z"]],
    "person-circle-exclamation": [640, 512, [], "e53f", ["M176 156.7l0 179.3 96 0 0-179.3c-14.4-8.2-30.9-12.7-48-12.7s-33.6 4.5-48 12.7zm5.8-133.1a42.1 42.1 0 1 0 84.2 0 42.1 42.1 0 1 0 -84.2 0zM248 24a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M200 24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm80 0a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zM140.8 191.1c1-1.7 2.1-3.4 3.2-5L144 528c0 8.8 7.2 16 16 16s16-7.2 16-16l0-160 96 0 0 160c0 8.8 7.2 16 16 16s16-7.2 16-16l0-341.9c1.1 1.6 2.2 3.3 3.2 5l47.4 79c7.4-8 15.4-15.4 24.1-22.1l-44-73.4C311.3 135.8 269.3 112 224 112s-87.3 23.8-110.6 62.6L50.3 279.8c-4.5 7.6-2.1 17.4 5.5 21.9s17.4 2.1 22-5.5l63.1-105.1zM272 336l-96 0 0-179.3c14.4-8.2 30.9-12.7 48-12.7s33.6 4.5 48 12.7L272 336zm112 64a112 112 0 1 1 224 0 112 112 0 1 1 -224 0zm256 0a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zM496 484a20 20 0 1 0 0-40 20 20 0 1 0 0 40zm0-164c-8.8 0-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16s16-7.2 16-16l0-64c0-8.8-7.2-16-16-16z"]],
    "binoculars": [512, 512, [], "f1e5", ["M32 356.9L32 432c0 8.8 7.2 16 16 16l128 0c8.8 0 16-7.2 16-16l0-304-85.6 0c-8.1 0-14.9 6-15.9 14l-5.7 45.9c-3.9 30.8-14.1 60.5-30.1 87.1-14.8 24.7-22.7 53-22.7 81.9zM224 160l0 96 64 0 0-96-64 0zm96-32l0 304c0 8.8 7.2 16 16 16l128 0c8.8 0 16-7.2 16-16l0-75.1c0-28.8-7.8-57.1-22.7-81.9-16-26.6-26.2-56.3-30.1-87.1L421.5 142c-1-8-7.8-14-15.9-14L320 128z", "M112 32c-8.8 0-16 7.2-16 16s7.2 16 16 16l64 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-64 0zm224 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l64 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-64 0zM192 432c0 8.8-7.2 16-16 16L48 448c-8.8 0-16-7.2-16-16l0-75.1c0-28.8 7.8-57.1 22.7-81.9 16-26.6 26.2-56.3 30.1-87.1L90.5 142c1-8 7.8-14 15.9-14l85.6 0 0 304zm32 0l0-144 64 0 0 144c0 26.5 21.5 48 48 48l128 0c26.5 0 48-21.5 48-48l0-75.1c0-34.6-9.4-68.6-27.2-98.3-13.7-22.8-22.5-48.2-25.8-74.6L453.3 138c-3-24-23.4-42-47.6-42L312 96c-13.3 0-24 10.7-24 24l0 8-64 0 0-8c0-13.3-10.7-24-24-24l-93.6 0c-24.2 0-44.6 18-47.6 42L53 184C49.7 210.4 40.9 235.8 27.2 258.6 9.4 288.3 0 322.3 0 356.9L0 432c0 26.5 21.5 48 48 48l128 0c26.5 0 48-21.5 48-48zm0-176l0-96 64 0 0 96-64 0zm96 16l0-144 85.6 0c8.1 0 14.9 6 15.9 14l5.7 45.9c3.9 30.8 14.1 60.5 30.1 87.1 14.8 24.7 22.7 53 22.7 81.9l0 75.1c0 8.8-7.2 16-16 16l-128 0c-8.8 0-16-7.2-16-16l0-160z"]],
    "grid-round-5": [448, 512, [], "e5de", ["", "M28 32a28 28 0 1 0 0 56 28 28 0 1 0 0-56zM0 158a28 28 0 1 0 56 0 28 28 0 1 0 -56 0zm28 70a28 28 0 1 0 0 56 28 28 0 1 0 0-56zM0 354a28 28 0 1 0 56 0 28 28 0 1 0 -56 0zm0 98c0 15.5 12.5 28 28 28s28-12.5 28-28-12.5-28-28-28-28 12.5-28 28zm98 0c0 15.5 12.5 28 28 28s28-12.5 28-28-12.5-28-28-28-28 12.5-28 28zm126-28c-15.5 0-28 12.5-28 28s12.5 28 28 28 28-12.5 28-28-12.5-28-28-28zm70 28c0 15.5 12.5 28 28 28s28-12.5 28-28-12.5-28-28-28-28 12.5-28 28zm126-28c-15.5 0-28 12.5-28 28s12.5 28 28 28 28-12.5 28-28-12.5-28-28-28zM126 326a28 28 0 1 0 0 56 28 28 0 1 0 0-56zm70 28a28 28 0 1 0 56 0 28 28 0 1 0 -56 0zm126-28a28 28 0 1 0 0 56 28 28 0 1 0 0-56zm70 28a28 28 0 1 0 56 0 28 28 0 1 0 -56 0zM98 256a28 28 0 1 0 56 0 28 28 0 1 0 -56 0zm126-28a28 28 0 1 0 0 56 28 28 0 1 0 0-56zm70 28a28 28 0 1 0 56 0 28 28 0 1 0 -56 0zm126-28a28 28 0 1 0 0 56 28 28 0 1 0 0-56zM126 130a28 28 0 1 0 0 56 28 28 0 1 0 0-56zm70 28a28 28 0 1 0 56 0 28 28 0 1 0 -56 0zm126-28a28 28 0 1 0 0 56 28 28 0 1 0 0-56zm70 28a28 28 0 1 0 56 0 28 28 0 1 0 -56 0zM98 60a28 28 0 1 0 56 0 28 28 0 1 0 -56 0zM224 32a28 28 0 1 0 0 56 28 28 0 1 0 0-56zm70 28a28 28 0 1 0 56 0 28 28 0 1 0 -56 0zM420 32a28 28 0 1 0 0 56 28 28 0 1 0 0-56z"]],
    "kip-sign": [384, 512, [], "e1c4", ["", "M80 32c8.8 0 16 7.2 16 16L96 222.4 325.9 35.6c6.9-5.6 16.9-4.5 22.5 2.3s4.5 16.9-2.3 22.5L125.1 240 368 240c8.8 0 16 7.2 16 16s-7.2 16-16 16l-242.9 0 221 179.6c6.9 5.6 7.9 15.6 2.3 22.5s-15.7 7.9-22.5 2.3L96 289.6 96 465c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-193-48 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l48 0 0-192c0-8.8 7.2-16 16-16z"]],
    "hard-drive": [448, 512, [128436, "hdd"], "f0a0", ["M32 96l0 168.6c9.4-5.4 20.3-8.6 32-8.6l320 0c11.7 0 22.6 3.1 32 8.6L416 96c0-17.7-14.3-32-32-32L64 64C46.3 64 32 78.3 32 96zm0 224l0 96c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-96c0-17.7-14.3-32-32-32L64 288c-17.7 0-32 14.3-32 32zm248 48a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm96 0a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M64 64C46.3 64 32 78.3 32 96l0 168.6c9.4-5.4 20.3-8.6 32-8.6l320 0c11.7 0 22.6 3.1 32 8.6L416 96c0-17.7-14.3-32-32-32L64 64zM32 320l0 96c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-96c0-17.7-14.3-32-32-32L64 288c-17.7 0-32 14.3-32 32zM0 320L0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64l0-96zm256 24a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm96 0a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]],
    "ranking-star": [512, 512, [], "e561", ["M32 368l0 96c0 8.8 7.2 16 16 16l112 0 0-128-112 0c-8.8 0-16 7.2-16 16zm160-64l0 176 128 0 0-176c0-8.8-7.2-16-16-16l-96 0c-8.8 0-16 7.2-16 16zm13.3-193.6l19.1 19.1c3.6 3.6 5.3 8.7 4.5 13.8l-4.2 26.6 24-12.2 3.5-1.3c3.7-.9 7.5-.5 11 1.3l24 12.2-4.2-26.6c-.8-5 .9-10.2 4.5-13.8l19-19.1-26.6-4.2c-3.8-.6-7.2-2.5-9.7-5.4l-2.1-3.2-12.2-24-12.2 24c-2.3 4.6-6.7 7.7-11.8 8.5l-26.6 4.2zM352 384l0 96 112 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16l-112 0z", "M304 256c26.5 0 48 21.5 48 48l0 48 112 0c26.5 0 48 21.5 48 48l0 64-.2 4.9C509.3 493.1 488.9 512 464 512L48 512c-26.5 0-48-21.5-48-48l0-96c0-26.5 21.5-48 48-48l112 0 0-16c0-26.5 21.5-48 48-48l96 0zM48 352c-8.8 0-16 7.2-16 16l0 96c0 8.8 7.2 16 16 16l112 0 0-128-112 0zm160-64c-8.8 0-16 7.2-16 16l0 176 128 0 0-176c0-8.8-7.2-16-16-16l-96 0zM352 480l112 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16l-112 0 0 96zM255.8 22.4c6 0 11.5 3.4 14.2 8.8l22.8 44.7 49.5 7.9 2.2 .5c4.9 1.5 8.9 5.3 10.5 10.3 1.9 5.7 .4 12-3.9 16.2l-35.4 35.5 7.8 49.6c.9 5.9-1.5 11.9-6.4 15.4s-11.3 4-16.7 1.3l-44.7-22.8-44.7 22.8c-5.4 2.7-11.8 2.2-16.7-1.3s-7.3-9.5-6.4-15.4l7.8-49.6-35.4-35.5c-4.2-4.3-5.7-10.5-3.9-16.2s6.8-9.9 12.7-10.8l49.5-7.9 22.8-44.7 1.2-1.9c3-4.2 7.8-6.8 13.1-6.8zM243.6 97.6c-2.3 4.6-6.7 7.7-11.8 8.5l-26.6 4.2 19.1 19.1c3.6 3.6 5.3 8.7 4.5 13.8l-4.2 26.6 24-12.2 3.5-1.3c3.7-.9 7.5-.5 11 1.3l24 12.2-4.2-26.6c-.8-5 .9-10.2 4.5-13.8l19-19.1-26.6-4.2c-3.8-.6-7.2-2.5-9.7-5.4l-2.1-3.2-12.2-24-12.2 24z"]],
    "user-tie": [448, 512, [], "f508", ["M16.5 512c58.5 0 117 0 175.5 0l32 0c-5.3 0-10.2-2.6-13.2-6.9L106.7 353.8C62.1 378.3 32 425.6 32 480l0 16c0 8.7-6.9 15.7-15.5 16zM128 128a96 96 0 1 0 192 0 96 96 0 1 0 -192 0zm63.6 292.7l32.4 47.1 32.4-47.1-32.4-64.9-32.4 64.9zM224 512l208 0c-8.8 0-16-7.2-16-16l0-16c0-54.4-30.1-101.7-74.7-126.2L237.2 505.1c-3 4.3-7.9 6.9-13.2 6.9z", "M224 224a96 96 0 1 0 0-192 96 96 0 1 0 0 192zm128-96a128 128 0 1 1 -256 0 128 128 0 1 1 256 0zM176 320c0-8.8 7.2-16 16-16l64 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-6.1 0 27.3 54.6 45.7-66.3c4.3-6.3 12.6-8.7 19.6-5.6 62.1 27.1 105.6 89.2 105.6 161.4l0 16c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-16c0-54.4-30.1-101.7-74.7-126.2L237.2 505.1c-3 4.3-7.9 6.9-13.2 6.9s-10.2-2.6-13.2-6.9L106.7 353.8C62.1 378.3 32 425.6 32 480l0 16c0 8.8-7.2 16-16 16S0 504.8 0 496l0-16c0-72.2 43.5-134.2 105.6-161.3 7-3.1 15.2-.7 19.6 5.6l45.7 66.3 27.3-54.6-6.1 0c-8.8 0-16-7.2-16-16zm48 147.8l32.4-47.1-32.4-64.9-32.4 64.9 32.4 47.1z"]],
    "square-bitcoin": [448, 512, [], "e6f2", ["M32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64C46.3 64 32 78.3 32 96zm97.8 59.9c0-15.4 12.5-27.9 27.9-27.9l18.3 0 0-16c0-8.8 7.2-16 16-16s16 7.2 16 16l0 16 16 0 0-16c0-8.8 7.2-16 16-16s16 7.2 16 16l0 16.1c38.5 1.4 69.3 33.1 69.3 71.9 0 19.1-7.4 36.4-19.5 49.3 21.8 12.4 36.5 35.8 36.5 62.7 0 39.8-32.2 72-72 72l-14.2 0 0 16c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-16-16 0 0 16c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-16-15.9 0c-16.8 0-30.4-13.6-30.4-30.4l0-197.7zm32 4.1l0 80 91.5 0c22.1 0 40-17.9 40-40s-17.9-40-40-40l-91.5 0zm0 112l0 80 108.5 0c22.1 0 40-17.9 40-40s-17.9-40-40-40l-108.5 0z", "M64 64C46.3 64 32 78.3 32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm192 0c8.8 0 16 7.2 16 16l0 16 16 0 0-16c0-8.8 7.2-16 16-16s16 7.2 16 16l0 16.1c38.5 1.4 69.3 33.1 69.3 71.9 0 19.1-7.4 36.4-19.5 49.3 21.8 12.4 36.5 35.8 36.5 62.7 0 39.8-32.2 72-72 72l-14.2 0 0 16c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-16-16 0 0 16c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-16-15.9 0c-16.8 0-30.4-13.6-30.4-30.4l0-197.7c0-15.4 12.5-27.9 27.9-27.9l18.3 0 0-16c0-8.8 7.2-16 16-16zm78.2 256c22.1 0 40-17.9 40-40s-17.9-40-40-40l-108.5 0 0 80 108.5 0zM240 160l-78.2 0 0 80 91.5 0c22.1 0 40-17.9 40-40s-17.9-40-40-40L240 160z"]],
    "ellipsis": [448, 512, ["ellipsis-h"], "f141", ["", "M448 256a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm-192 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM32 288a32 32 0 1 1 0-64 32 32 0 1 1 0 64z"]],
    "arrow-turn-down-left": [512, 512, [], "e2e1", ["", "M480 80c0-8.8 7.2-16 16-16s16 7.2 16 16l0 96c0 53-43 96-96 96L54.6 272 171.3 388.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-144-144c-3-3-4.7-7.1-4.7-11.3s1.7-8.3 4.7-11.3l144-144c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6L54.6 240 416 240c35.3 0 64-28.7 64-64l0-96z"]],
    "octagon-check": [512, 512, [], "e426", ["M32.5 181.6l0 148.8c0 4.2 1.7 8.3 4.7 11.3L170.7 475.3c3 3 7.1 4.7 11.3 4.7l148.8 0c4.2 0 8.3-1.7 11.3-4.7L475.7 341.7c3-3 4.7-7.1 4.7-11.3l0-148.8c0-4.2-1.7-8.3-4.7-11.3L342.2 36.8c-3-3-7.1-4.7-11.3-4.7L182 32.1c-4.2 0-8.3 1.7-11.3 4.7L37.2 170.3c-3 3-4.7 7.1-4.7 11.3zm116.6 95.1c6.2-6.2 16.4-6.2 22.6 0l50.8 50.7 117-160.8c5.2-7.1 15.2-8.7 22.3-3.5s8.7 15.2 3.5 22.3l-128 176c-2.8 3.8-7 6.2-11.7 6.5s-9.3-1.3-12.6-4.6l-64-64c-6.2-6.2-6.2-16.4 0-22.6z", "M330.9 .1c12.7 0 25 5.1 34 14.1L498.3 147.6c9 9 14.1 21.2 14.1 33.9l0 148.8c0 12.7-5.1 25-14.1 34L364.8 497.9c-9 9-21.2 14.1-34 14.1l-148.8 0c-12.7 0-24.9-5.1-33.9-14.1L14.6 364.4c-9-9-14.1-21.2-14.1-34l0-148.8c0-12.7 5.1-24.9 14.1-33.9L148.1 14.1c9-9 21.2-14.1 33.9-14.1l148.8 0zM182 32.1c-4.2 0-8.3 1.7-11.3 4.7L37.2 170.3c-3 3-4.7 7.1-4.7 11.3l0 148.8c0 4.2 1.7 8.3 4.7 11.3L170.7 475.3c3 3 7.1 4.7 11.3 4.7l148.8 0c4.2 0 8.3-1.7 11.3-4.7L475.7 341.7c3-3 4.7-7.1 4.7-11.3l0-148.8c0-4.2-1.7-8.3-4.7-11.3L342.2 36.8c-3-3-7.1-4.7-11.3-4.7L182 32.1zM339.5 166.6c5.2-7.1 15.2-8.7 22.3-3.5s8.7 15.2 3.5 22.3l-128 176c-2.8 3.8-7 6.2-11.7 6.5s-9.3-1.3-12.6-4.6l-64-64c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l50.8 50.7 117-160.8z"]],
    "store-24": [576, 512, [], "e79b", ["", "M97.1 32C65.7 32 38 52.3 28.5 82.2L9.6 141.4c-9.7 30.4 .8 61.2 22.5 80.1l0 186.5c0 39.8 32.2 72 72 72l168 0 0-32-168 0c-22.1 0-40-17.9-40-40l0-56 210 0c3.2-12.6 10.2-23.7 19.7-32l-229.7 0 0-82c5.6 1.3 11.5 2 17.5 2 23.8 0 45.2-11.1 59.2-28.5 13.3 17.3 34.3 28.5 58 28.5 23.2 0 43.9-10.8 57.3-27.6 13.4 16.8 34.1 27.6 57.3 27.6 23.7 0 44.7-11.2 58-28.5 13.9 17.4 35.3 28.5 59.2 28.5 6.1 0 11.9-.7 17.5-2l0 66 32 0 0-82.5c21.7-18.9 32.2-49.7 22.5-80.1L483.8 82.2C474.3 52.3 446.5 32 415.2 32l-318 0zM386.4 160.1l-8.7-96.1 37.5 0c17.4 0 32.9 11.3 38.2 27.9l18.9 59.2c9 28.1-12 56.9-41.6 56.9-22.6 0-41.4-17.2-43.4-39.7l-.7-8.1 0-.1zM354.5 163l0 .1c2.1 24.1-16.9 44.9-41.1 44.9-22.8 0-41.3-18.5-41.3-41.3l0-102.7 73.4 0 9 99zM166.7 64l73.4 0 0 102.7c0 22.8-18.5 41.3-41.3 41.3-24.3 0-43.3-20.8-41.1-45l9-99zm-32.1 0l-8.7 96.1 0 0-.7 8.2c-2 22.5-20.9 39.7-43.4 39.7-29.5 0-50.5-28.7-41.6-56.9L59 91.9C64.2 75.3 79.7 64 97.1 64l37.5 0zM320.1 400c0 8.8 7.2 16 16 16s16-7.2 16-16 7.2-16 16-16 16 7.2 16 16l0 1c0 5.8-2.1 11.3-5.9 15.6l-52.5 59.1c-3.5 4-5.5 9.1-5.5 14.5 0 12 9.8 21.8 21.8 21.8l58.2 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-35.5 0 37.4-42.1c9-10.2 14-23.3 14-36.9l0-1c0-26.5-21.5-48-48-48s-48 21.5-48 48zm128 32c0 4.2 1.7 8.3 4.7 11.3s7.1 4.7 11.3 4.7l48 0 0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-128c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 48-32 0 0-48c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 64z"]],
    "store-slash": [576, 512, [], "e071", ["M119.6 65.1c3-.7 6.1-1.1 9.3-1.1l37.5 0-4 44-42.8-42.8zm72.3 72.3l6.7-73.4 73.4 0 0 102.7c0 13.8-6.8 26-17.2 33.5l-62.9-62.9zM304 64l73.4 0c3 33 6 66 9 99.1 2.1 24.1-16.9 44.9-41.1 44.9-22.8 0-41.3-18.5-41.3-41.3L304 64zM406.5 352l73.5 0 0 56c0 5.2-1 10.1-2.8 14.7L406.5 352zm3-288L447 64c17.4 0 32.9 11.3 38.2 27.9L504 151.1c9 28.1-12 56.9-41.6 56.9-22.6 0-41.4-17.2-43.4-39.7-.2-2.7-.5-5.4-.7-8.2L409.5 64z", "M27.3-27.2c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l544 544c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-70.4-70.4c7-11.1 11.1-24.3 11.1-38.4l0-186.5c21.7-18.9 32.2-49.7 22.5-80.1L515.7 82.2C506.2 52.3 478.4 32 447 32L129 32c-12.1 0-23.7 3-33.9 8.5L27.3-27.2zm92.3 92.3c3-.7 6.1-1.1 9.3-1.1l37.5 0-4 44-42.8-42.8zm72.3 72.3l6.7-73.4 73.4 0 0 102.7c0 13.8-6.8 26-17.2 33.5l-62.9-62.9zm85.7 85.7c3.8-3.2 7.3-6.7 10.4-10.6 13.4 16.8 34.1 27.6 57.3 27.6 23.7 0 44.7-11.2 58-28.5 13.9 17.4 35.3 28.5 59.2 28.5 6.1 0 11.9-.7 17.5-2l0 82-105.5 0-96.9-96.9zM406.5 352l73.5 0 0 56c0 5.2-1 10.1-2.8 14.7L406.5 352zM41.5 141.4c-9.7 30.4 .8 61.2 22.5 80.1L64 408c0 39.8 32.2 72 72 72l285.5 0-32-32-253.5 0c-22.1 0-40-17.9-40-40l0-56 197.5 0-32-32-165.5 0 0-82c5.6 1.3 11.5 2 17.5 2 18.8 0 36.2-6.9 49.5-18.4l-22.7-22.7c-7.4 5.8-16.7 9.2-26.8 9.2-29.5 0-50.5-28.7-41.6-56.9l5-15.7-25.5-25.5-10 31.4zM409.5 64L447 64c17.4 0 32.9 11.3 38.2 27.9L504 151.1c9 28.1-12 56.9-41.6 56.9-22.6 0-41.4-17.2-43.4-39.7l-.7-8.1 0-.1-8.7-96.1zm-23.1 99.1c2.1 24.1-16.9 44.9-41.1 44.9-22.8 0-41.3-18.5-41.3-41.3l0-102.7 73.4 0 9 99 0 .1z"]],
    "percent": [448, 512, [62101, 62785, "percentage"], "25", ["M32 128a64 64 0 1 0 128 0 64 64 0 1 0 -128 0zM288 384a64 64 0 1 0 128 0 64 64 0 1 0 -128 0z", "M443.3 36.7c6.2 6.2 6.2 16.4 0 22.6l-416 416c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l416-416c6.2-6.2 16.4-6.2 22.6 0zM96 192a64 64 0 1 0 0-128 64 64 0 1 0 0 128zM96 32a96 96 0 1 1 0 192 96 96 0 1 1 0-192zM416 384a64 64 0 1 0 -128 0 64 64 0 1 0 128 0zm-160 0a96 96 0 1 1 192 0 96 96 0 1 1 -192 0z"]],
    "circle-n": [512, 512, [], "e118", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm144-80c0-6.8 4.3-12.8 10.7-15.1s13.5-.2 17.8 5.1L304 290.4 304 176c0-8.8 7.2-16 16-16s16 7.2 16 16l0 160c0 6.8-4.3 12.8-10.7 15.1s-13.5 .2-17.8-5.1L208 221.6 208 336c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-160z", "M256 32a224 224 0 1 1 0 448 224 224 0 1 1 0-448zm0 480a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM204.5 166c-4.2-5.3-11.4-7.4-17.8-5.1S176 169.2 176 176l0 160c0 8.8 7.2 16 16 16s16-7.2 16-16l0-114.4 99.5 124.4c4.2 5.3 11.4 7.4 17.8 5.1S336 342.8 336 336l0-160c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 114.4-99.5-124.4z"]],
    "file-zipper": [384, 512, ["file-archive"], "f1c6", ["M32 64l0 384c0 17.7 14.3 32 32 32l256 0c17.7 0 32-14.3 32-32l0-256-96 0c-35.3 0-64-28.7-64-64l0-96-128 0C46.3 32 32 46.3 32 64zM64 80c0-8.8 7.2-16 16-16l64 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L80 96c-8.8 0-16-7.2-16-16zm0 64c0-8.8 7.2-16 16-16l64 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-64 0c-8.8 0-16-7.2-16-16zm0 80c0-17.7 14.3-32 32-32l32 0c17.7 0 32 14.3 32 32l0 48c0 26.5-21.5 48-48 48s-48-21.5-48-48l0-48z", "M192 32L64 32C46.3 32 32 46.3 32 64l0 384c0 17.7 14.3 32 32 32l256 0c17.7 0 32-14.3 32-32l0-256-96 0c-35.3 0-64-28.7-64-64l0-96zM338.7 160L224 45.3 224 128c0 17.7 14.3 32 32 32l82.7 0zM0 64C0 28.7 28.7 0 64 0L197.5 0c17 0 33.3 6.7 45.3 18.7L365.3 141.3c12 12 18.7 28.3 18.7 45.3L384 448c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zM64 80c0-8.8 7.2-16 16-16l64 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L80 96c-8.8 0-16-7.2-16-16zm0 64c0-8.8 7.2-16 16-16l64 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-64 0c-8.8 0-16-7.2-16-16zm32 80l0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48-32 0zm0-32l32 0c17.7 0 32 14.3 32 32l0 48c0 26.5-21.5 48-48 48s-48-21.5-48-48l0-48c0-17.7 14.3-32 32-32z"]],
    "trash-can-xmark": [448, 512, [], "e2ae", ["M64 144l0 304c0 17.7 14.3 32 32 32l256 0c17.7 0 32-14.3 32-32l0-304-320 0zm85.5-80l149 0-11-36.6c-2-6.8-8.3-11.4-15.3-11.4l-96.4 0c-7.1 0-13.3 4.6-15.3 11.4L149.5 64zm7.2 156.7c6.2-6.2 16.4-6.2 22.6 0l44.7 44.7 44.7-44.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6l-44.7 44.7 44.7 44.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-44.7-44.7-44.7 44.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l44.7-44.7-44.7-44.7c-6.2-6.2-6.2-16.4 0-22.6z", "M160.5 27.4c2-6.8 8.3-11.4 15.3-11.4l96.4 0c7.1 0 13.3 4.6 15.3 11.4l11 36.6-149 0 11-36.6zM116.1 64L16 64C7.2 64 0 71.2 0 80S7.2 96 16 96l416 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-100.1 0-13.7-45.8C312.1-2.1 293.4-16 272.2-16l-96.4 0c-21.2 0-39.9 13.9-46 34.2L116.1 64zM32 144l0 304c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-304-32 0 0 304c0 17.7-14.3 32-32 32L96 480c-17.7 0-32-14.3-32-32l0-304-32 0zm124.7 76.7c-6.2 6.2-6.2 16.4 0 22.6l44.7 44.7-44.7 44.7c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l44.7-44.7 44.7 44.7c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-44.7-44.7 44.7-44.7c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-44.7 44.7-44.7-44.7c-6.2-6.2-16.4-6.2-22.6 0z"]],
    "display": [512, 512, [], "e163", ["M32 96l0 256c0 17.7 14.3 32 32 32l384 0c17.7 0 32-14.3 32-32l0-256c0-17.7-14.3-32-32-32L64 64C46.3 64 32 78.3 32 96zM202.9 480l106.2 0-10.7-64-84.9 0-10.7 64z", "M64 64l384 0c17.7 0 32 14.3 32 32l0 256c0 17.7-14.3 32-32 32L64 384c-17.7 0-32-14.3-32-32L32 96c0-17.7 14.3-32 32-32zM448 32L64 32C28.7 32 0 60.7 0 96L0 352c0 35.3 28.7 64 64 64l117.1 0-10.7 64-58.4 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l288 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-58.4 0-10.7-64 117.1 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64zM298.4 416l10.7 64-106.2 0 10.7-64 84.9 0z"]],
    "ellipsis-stroke": [512, 512, ["ellipsis-h-alt"], "f39b", ["M112 256a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm176 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm176 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M48 256a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm96 0a64 64 0 1 1 -128 0 64 64 0 1 1 128 0zm112-32a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm0 96a64 64 0 1 1 0-128 64 64 0 1 1 0 128zm176-96a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm0 96a64 64 0 1 1 0-128 64 64 0 1 1 0 128z"]],
    "air-conditioner": [576, 512, [], "f8f4", ["M32 128l0 128c0 17.7 14.3 32 32 32l448 0c17.7 0 32-14.3 32-32l0-128c0-17.7-14.3-32-32-32L64 96c-17.7 0-32 14.3-32 32zm64 80c0-8.8 7.2-16 16-16l352 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-352 0c-8.8 0-16-7.2-16-16z", "M64 96c-17.7 0-32 14.3-32 32l0 128c0 17.7 14.3 32 32 32l448 0c17.7 0 32-14.3 32-32l0-128c0-17.7-14.3-32-32-32L64 96zM0 128C0 92.7 28.7 64 64 64l448 0c35.3 0 64 28.7 64 64l0 128c0 35.3-28.7 64-64 64L64 320c-35.3 0-64-28.7-64-64L0 128zm112 64l352 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-352 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zM224 480l0-112 32 0 0 112c0 35.3-28.7 64-64 64s-64-28.7-64-64c0-8.8 7.2-16 16-16s16 7.2 16 16c0 17.7 14.3 32 32 32s32-14.3 32-32zM352 368l0 112c0 17.7 14.3 32 32 32s32-14.3 32-32l0-8c0-8.8 7.2-16 16-16s16 7.2 16 16l0 8c0 35.3-28.7 64-64 64s-64-28.7-64-64l0-112 32 0z"]],
    "file-xls": [576, 512, [], "e64d", ["M64 64c0-17.7 14.3-32 32-32l128 0 0 96c0 35.3 28.7 64 64 64l96 0 0 144-120 0c-30.9 0-56 25.1-56 56l0 88-112 0c-17.7 0-32-14.3-32-32L64 64z", "M224 32L96 32C78.3 32 64 46.3 64 64l0 384c0 17.7 14.3 32 32 32l112 0 0 32-112 0c-35.3 0-64-28.7-64-64L32 64C32 28.7 60.7 0 96 0L229.5 0c17 0 33.3 6.7 45.3 18.7L397.3 141.3c12 12 18.7 28.3 18.7 45.3l0 149.5-32 0 0-144-96 0c-35.3 0-64-28.7-64-64l0-96zM370.7 160L256 45.3 256 128c0 17.7 14.3 32 32 32l82.7 0zM288 400c0 7.3 2.2 14.4 6.2 20.4l9.8 14.7 9.8-14.7c4-6.1 6.2-13.2 6.2-20.4 0-8.8 7.2-16 16-16s16 7.2 16 16c0 13.6-4 26.9-11.6 38.2l-17.2 25.8 17.2 25.8c7.5 11.3 11.6 24.6 11.6 38.2 0 8.8-7.2 16-16 16s-16-7.2-16-16c0-7.3-2.2-14.4-6.2-20.4l-9.8-14.7-9.8 14.7c-4 6.1-6.2 13.2-6.2 20.4 0 8.8-7.2 16-16 16s-16-7.2-16-16c0-13.6 4-26.9 11.6-38.2l17.2-25.8-17.2-25.8c-7.5-11.3-11.6-24.6-11.6-38.2 0-8.8 7.2-16 16-16s16 7.2 16 16zM400 544c-8.8 0-16-7.2-16-16l0-128c0-8.8 7.2-16 16-16s16 7.2 16 16l0 112 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-32 0zm80-114.3c0-25.2 20.4-45.7 45.7-45.7l26.3 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-26.3 0c-7.5 0-13.7 6.1-13.7 13.7 0 5.2 2.9 9.9 7.6 12.2l31.2 15.6c15.5 7.7 25.2 23.5 25.2 40.8 0 25.2-20.4 45.7-45.7 45.7L496 544c-8.8 0-16-7.2-16-16s7.2-16 16-16l34.3 0c7.5 0 13.7-6.1 13.7-13.7 0-5.2-2.9-9.9-7.6-12.2l-31.2-15.6C489.8 462.8 480 447 480 429.7z"]],
    "pinata": [512, 512, [], "e3c3", ["M32 107.3c0 16.4 9.3 31.4 23.9 38.8l63.2 31.6c5.4 2.7 8.8 8.3 8.8 14.3l0 48.1 25.1-15.7 4.4-2.3c10.6-4.5 23-3 32.3 4.2l23.2 18.2 32.1-20.1 4.4-2.3c10.6-4.5 23-3 32.3 4.2l23.2 18.2 32.1-20.1 4.4-2.3c10.6-4.5 23-3 32.3 4.2l23.2 18.2 32.1-20.1 4.4-2.3c10.6-4.5 23-3 32.3 4.2l14 11C478.4 203.2 450.4 176 416 176l-144 0c-8.8 0-16-7.2-16-16l0-136c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 24c0 8.8-7.2 16-16 16L75.3 64C51.4 64 32 83.4 32 107.3zm96 170.4l0 42.3 25.1-15.7 4.4-2.3c10.6-4.5 23-3 32.3 4.2l23.2 18.2 32.1-20.1 4.4-2.3c10.6-4.5 23-3 32.3 4.2l23.2 18.2 32.1-20.1c11.4-7.1 26.1-6.4 36.7 1.9l23.2 18.2 32.1-20.1 4.4-2.3c10.6-4.5 23-3 32.3 4.2l14.2 11.1 0-39.6-1.9-1.2-32-25.1-32.1 20.1c-10 6.3-22.5 6.5-32.5 .8l-4.2-2.8-23.2-18.2-32.1 20.1c-11.4 7.1-26.1 6.4-36.7-1.9l-23.2-18.2-32.1 20.1c-11.4 7.1-26.1 6.4-36.7-1.9l-23.2-18.2-41.6 26c-.2 .1-.3 .1-.5 .2zm0 80l0 98.2c0 13.3 10.7 24 24 24l32 0c13.3 0 24-10.7 24-24l0-56c0-8.8 7.2-16 16-16l160 0c8.8 0 16 7.2 16 16l0 56c0 13.3 10.7 24 24 24l32 0c13.3 0 24-10.7 24-24l0-98.2-1.9-1.2-32-25.1-32.1 20.1c-11.4 7.1-26.1 6.4-36.7-1.9l-23.2-18.2-32.1 20.1c-10 6.3-22.5 6.5-32.5 .8l-4.2-2.8-23.2-18.2-32.1 20.1c-10 6.3-22.5 6.5-32.5 .8l-4.2-2.8-23.2-18.2-41.6 26c-.2 .1-.3 .1-.5 .2zM192 120a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M232-32c30.9 0 56 25.1 56 56l0 120 128 0c53 0 96 43 96 96l0 216c0 30.9-25.1 56-56 56l-32 0c-30.9 0-56-25.1-56-56l0-40-128 0 0 40c0 30.9-25.1 56-56 56l-32 0c-30.9 0-56-25.1-56-56l0-254.1-54.3-27.2C16.1 162 0 135.9 0 107.3 0 65.7 33.7 32 75.3 32l100.7 0 0-8c0-30.9 25.1-56 56-56zM414 351.6c-11.4 7.1-26.1 6.4-36.7-1.9l-23.2-18.2-32.1 20.1c-10 6.3-22.5 6.5-32.5 .8l-4.2-2.8-23.2-18.2-32.1 20.1c-10 6.3-22.5 6.5-32.5 .8l-4.2-2.8-23.2-18.2-41.6 26c-.2 .1-.3 .1-.5 .2l0 98.2c0 13.3 10.7 24 24 24l32 0c13.3 0 24-10.7 24-24l0-56c0-8.8 7.2-16 16-16l160 0c8.8 0 16 7.2 16 16l0 56c0 13.3 10.7 24 24 24l32 0c13.3 0 24-10.7 24-24l0-98.2-1.9-1.2-32-25.1-32.1 20.1zm0-80c-10 6.3-22.5 6.5-32.5 .8l-4.2-2.8-23.2-18.2-32.1 20.1c-11.4 7.1-26.1 6.4-36.7-1.9l-23.2-18.2-32.1 20.1c-11.4 7.1-26.1 6.4-36.7-1.9l-23.2-18.2-41.6 26c-.2 .1-.3 .1-.5 .2l0 42.3 25.1-15.7 4.4-2.3c10.6-4.5 23-3 32.3 4.2l23.2 18.2 32.1-20.1 4.4-2.3c10.6-4.5 23-3 32.3 4.2l23.2 18.2 32.1-20.1c11.4-7.1 26.1-6.4 36.7 1.9l23.2 18.2 32.1-20.1 4.4-2.3c10.6-4.5 23-3 32.3 4.2l14.2 11.1 0-39.6-1.9-1.2-32-25.1-32.1 20.1zM232 0c-13.3 0-24 10.7-24 24l0 24c0 8.8-7.2 16-16 16L75.3 64c-23.9 0-43.3 19.4-43.3 43.3 0 16.4 9.3 31.4 23.9 38.8l63.2 31.6c5.4 2.7 8.8 8.3 8.8 14.3l0 48.1 25.1-15.7 4.4-2.3c10.6-4.5 23-3 32.3 4.2l23.2 18.2 32.1-20.1 4.4-2.3c10.6-4.5 23-3 32.3 4.2l23.2 18.2 32.1-20.1 4.4-2.3c10.6-4.5 23-3 32.3 4.2l23.2 18.2 32.1-20.1 4.4-2.3c10.6-4.5 23-3 32.3 4.2l14 11C478.4 203.2 450.4 176 416 176l-144 0c-8.8 0-16-7.2-16-16l0-136c0-13.3-10.7-24-24-24zM168 144a24 24 0 1 1 0-48 24 24 0 1 1 0 48z"]],
    "chart-fft": [512, 512, [], "e69e", ["M32 320l80 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l64 0c6.9 0 13-4.4 15.2-10.9l67-200.9 47.2 106.3c2.6 5.8 8.3 9.5 14.6 9.5l71.4 0 59.3 88.9c4.9 7.4 14.8 9.3 22.2 4.4 4.6-3 7.1-8 7.1-13.1l0 111.8-400 0c-26.5 0-48-21.5-48-48l0-80z", "M32 48c0-8.8-7.2-16-16-16S0 39.2 0 48L0 400c0 44.2 35.8 80 80 80l416 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L80 448c-26.5 0-48-21.5-48-48L32 48zM270.6 89.5c-2.7-6-8.8-9.8-15.4-9.5s-12.3 4.7-14.4 10.9L164.5 320 112 320c-8.8 0-16 7.2-16 16s7.2 16 16 16l64 0c6.9 0 13-4.4 15.2-10.9l67-200.9 47.2 106.3c2.6 5.8 8.3 9.5 14.6 9.5l71.4 0 59.3 88.9c4.9 7.4 14.8 9.3 22.2 4.4s9.3-14.8 4.4-22.2l-64-96c-3-4.5-8-7.1-13.3-7.1l-69.6 0-59.8-134.5z"]],
    "circle-user-circle-exclamation": [640, 512, [], "e7a0", ["M64 256c0-123.7 100.3-224 224-224 107.3 0 197.1 75.5 218.9 176.3-3.6-.2-7.2-.3-10.9-.3-77.5 0-144.3 45.9-174.6 112l-1.4 0-64 0C196.1 320 145.9 361.1 131.9 416.6 90 375.9 64 319 64 256zm144-64a80 80 0 1 0 160 0 80 80 0 1 0 -160 0z", "M310 352c2.9-11.1 6.7-21.8 11.4-32l-1.4 0-64 0C196.1 320 145.9 361.1 131.9 416.6 90 375.9 64 319 64 256 64 132.3 164.3 32 288 32 395.3 32 485.1 107.5 506.9 208.3 518.4 208.9 529.6 210.6 540.4 213.2 520.1 92.2 414.8 0 288 0 146.6 0 32 114.6 32 256S146.6 512 288 512c16.7 0 33-1.6 48.8-4.6-6.3-9.3-11.8-19.3-16.4-29.7-10.6 1.5-21.4 2.3-32.4 2.3-47.5 0-91.5-14.8-127.7-39.9 4-49.3 45.3-88.1 95.7-88.1l54 0zM288 240a48 48 0 1 1 0-96 48 48 0 1 1 0 96zm-80-48a80 80 0 1 0 160 0 80 80 0 1 0 -160 0zM384 400a112 112 0 1 1 224 0 112 112 0 1 1 -224 0zm256 0a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zM496 484a20 20 0 1 0 0-40 20 20 0 1 0 0 40zm0-164c-8.8 0-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16s16-7.2 16-16l0-64c0-8.8-7.2-16-16-16z"]],
    "phone-intercom": [512, 512, [], "e434", ["M32 80l0 352c0 8.8 7.2 16 16 16l64 0c8.8 0 16-7.2 16-16l0-352c0-8.8-7.2-16-16-16L48 64c-8.8 0-16 7.2-16 16zm128.7 9.6c-.2 1.7-.3 3.4-.3 5.1l0 321.9c0 2.4 .2 4.7 .5 7 3.4 14 16 24.4 31.1 24.4l256 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L192 64c-15.5 0-28.3 11-31.3 25.6zM208 144c0-17.7 14.3-32 32-32l160 0c17.7 0 32 14.3 32 32l0 80c0 17.7-14.3 32-32 32l-160 0c-17.7 0-32-14.3-32-32l0-80zm56 192a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm80 0a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm80 0a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M48 64c-8.8 0-16 7.2-16 16l0 352c0 8.8 7.2 16 16 16l64 0c8.8 0 16-7.2 16-16l0-352c0-8.8-7.2-16-16-16L48 64zM148.6 463c-8.8 10.4-21.9 17-36.6 17l-64 0c-26.5 0-48-21.5-48-48L0 80C0 53.5 21.5 32 48 32l64 0c14.7 0 27.8 6.6 36.6 17 11.4-10.5 26.6-17 43.4-17l256 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64l-256 0c-16.7 0-32-6.4-43.4-17zM160 416c0 17.7 14.3 32 32 32l256 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L192 64c-17.7 0-32 14.3-32 32l0 320zM400 144l-160 0 0 80 160 0 0-80zM240 112l160 0c17.7 0 32 14.3 32 32l0 80c0 17.7-14.3 32-32 32l-160 0c-17.7 0-32-14.3-32-32l0-80c0-17.7 14.3-32 32-32zm0 200a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm56 24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm104-24a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]],
    "turn-left-up": [384, 512, [], "e638", ["M64 160l80 0c8.8 0 16 7.2 16 16l0 176c0 70.7 57.3 128 128 128l64 0 0-64-64 0c-35.3 0-64-28.7-64-64l0-176c0-8.8 7.2-16 16-16l80 0-128-128-128 128z", "M214.6 9.4c-12.5-12.5-32.8-12.5-45.3 0l-128 128c-9.2 9.2-11.9 22.9-6.9 34.9S51.1 192 64 192l64 0 0 160c0 88.4 71.6 160 160 160l64 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-64 0c-17.7 0-32-14.3-32-32l0-160 64 0c12.9 0 24.6-7.8 29.6-19.8s2.2-25.7-6.9-34.9l-128-128zM192 32l128 128-80 0c-8.8 0-16 7.2-16 16l0 176c0 35.3 28.7 64 64 64l64 0 0 64-64 0c-70.7 0-128-57.3-128-128l0-176c0-8.8-7.2-16-16-16L64 160 192 32z"]],
    "scarf": [512, 512, [129507], "f7c1", ["M128 112c0-44.2 35.8-80 80-80l96 0c44.2 0 80 35.8 80 80l0 56.2c0 21.2-8.4 41.6-23.4 56.6l-8.6 8.6-75.7-75.7c-5-5-1.5-13.7 5.7-13.7l6.1 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-6.1 0c-35.6 0-53.5 43.1-28.3 68.3l75.7 75.7-68.7 68.7-4.7 4.7-104.6-104.6c-15-15-23.4-35.4-23.4-56.6l0-56.2z", "M128 112l0 56.2c0 21.2 8.4 41.6 23.4 56.6l104.6 104.6 4.7-4.7 68.7-68.7-75.7-75.7c-25.2-25.2-7.4-68.3 28.3-68.3l6.1 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-6.1 0c-7.1 0-10.7 8.6-5.7 13.7l75.7 75.7 8.6-8.6c15-15 23.4-35.4 23.4-56.6l0-56.2c0-44.2-35.8-80-80-80l-96 0c-44.2 0-80 35.8-80 80zM352 278.6L326.6 304 451.3 428.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L304 326.6 278.6 352 403.3 476.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L256 374.6c-1.4-1.4-43.8-43.8-127.2-127.2-21-21-32.8-49.5-32.8-79.2L96 112C96 50.1 146.1 0 208 0l96 0c61.9 0 112 50.1 112 112l0 56.2c0 29.7-11.8 58.2-32.8 79.2l-8.6 8.6 124.7 124.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L352 278.6zM103.4 289.9l22.6 22.6-90.7 90.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l90.7-90.7zm48 48l22.6 22.6-90.7 90.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l90.7-90.7zm48 48l22.6 22.6-90.7 90.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l90.7-90.7z"]],
    "message-pen": [512, 512, ["comment-alt-edit", "message-edit"], "f4a4", ["M32 128c0-35.3 28.7-64 64-64l320 0c35.3 0 64 28.7 64 64l0 224c0 35.3-28.7 64-64 64l-120 0c-8.7 0-17.1 2.8-24 8l-112 84 0-68c0-13.3-10.7-24-24-24l-40 0c-35.3 0-64-28.7-64-64l0-224zm96 209.8c0 16.7 13.5 30.2 30.2 30.2 2.5 0 4.9-.3 7.3-.9L215 354.7c11.3-2.8 21.5-8.6 29.7-16.8L366.1 216.6c11.5-11.5 17.9-27.1 17.9-43.3 0-33.8-27.4-61.3-61.3-61.3-16.2 0-31.8 6.5-43.3 17.9L158.1 251.3c-8.2 8.2-14 18.5-16.8 29.7l-12.4 49.4c-.6 2.4-.9 4.9-.9 7.3z", "M32 128c0-35.3 28.7-64 64-64l320 0c35.3 0 64 28.7 64 64l0 224c0 35.3-28.7 64-64 64l-120 0c-8.7 0-17.1 2.8-24 8l-112 84 0-68c0-13.3-10.7-24-24-24l-40 0c-35.3 0-64-28.7-64-64l0-224zM96 32C43 32 0 75 0 128L0 352c0 53 43 96 96 96l32 0 0 68c0 15.5 12.5 28 28 28 6.1 0 12-2 16.8-5.6l118.4-88.8c1.4-1 3.1-1.6 4.8-1.6l120 0c53 0 96-43 96-96l0-224c0-53-43-96-96-96L96 32zM302.1 152.6c5.5-5.5 12.9-8.6 20.7-8.6 16.2 0 29.3 13.1 29.3 29.3 0 7.8-3.1 15.2-8.6 20.7L222.1 315.3c-4.1 4.1-9.2 7-14.9 8.4l-46.6 11.6 11.6-46.6c1.4-5.6 4.3-10.8 8.4-14.9L302.1 152.6zM322.7 112c-16.2 0-31.8 6.5-43.3 17.9L158.1 251.3c-8.2 8.2-14 18.5-16.8 29.7l-12.4 49.4c-.6 2.4-.9 4.9-.9 7.3 0 16.7 13.5 30.2 30.2 30.2 2.5 0 4.9-.3 7.3-.9L215 354.7c11.3-2.8 21.5-8.6 29.7-16.8L366.1 216.6c11.5-11.5 17.9-27.1 17.9-43.3 0-33.8-27.4-61.3-61.3-61.3z"]],
    "icons": [512, 512, ["heart-music-camera-bolt"], "f86d", ["M32 67c0 25.6 15.7 46 33 63.8 20.9 21.5 46.2 39.8 63 50.8 16.7-11 42.3-29.3 63.1-50.8 17.3-17.8 33-38.2 33-63.8 0-19.4-15.7-35-35-35-9.8 0-17.3 3.9-24.7 11.1-6.7 6.5-12.3 14.2-18.6 23.3-4.4 6.3-9 12.9-17.6 12.9s-13.2-6.6-17.6-12.9C104 57.3 98.4 49.6 91.7 43.1 84.3 35.9 76.9 32 67 32 47.7 32 32 47.7 32 67zm0 285l0 112c0 8.8 7.2 16 16 16l192 0c8.8 0 16-7.2 16-16l0-112c0-8.8-7.2-16-16-16l-35.2 0c-5.3 0-10.3-2.7-13.3-7.1l-16.6-24.9-61.7 0-16.6 24.9c-3 4.5-8 7.1-13.3 7.1L48 336c-8.8 0-16 7.2-16 16zm160 48a48 48 0 1 1 -96 0 48 48 0 1 1 96 0zm64-180c0 5.5 8.2 20 32 20s32-14.5 32-20-8.2-20-32-20-32 14.5-32 20zm160-40c0 5.5 8.2 20 32 20s32-14.5 32-20-8.2-20-32-20-32 14.5-32 20z", "M142 20.1c11.5-11.1 26.5-20.1 46.9-20.1 37 0 67 30 67 67 0 34.3-18.7 62.1-42 86.1-23.2 23.9-50.8 43.7-68.3 55.3-10.8 7.1-24.5 7.1-35.3 0-17.6-11.6-45.1-31.4-68.3-55.3-23.3-24-42-51.8-42-86.1 0-37 30-67 67-67 20.5 0 35.5 9 46.9 20.1 5 4.9 9.7 10.5 14 16.1 4.3-5.6 9-11.3 14-16.1zM67 32c-19.4 0-35 15.7-35 35 0 25.6 15.7 46 33 63.8 20.9 21.5 46.2 39.8 63 50.8 16.7-11 42.3-29.3 63.1-50.8 17.3-17.8 33-38.2 33-63.8 0-19.4-15.7-35-35-35-9.8 0-17.3 3.9-24.7 11.1-6.7 6.5-12.3 14.2-18.6 23.3-4.4 6.3-9 12.9-17.6 12.9s-13.2-6.6-17.6-12.9C104 57.3 98.4 49.6 91.7 43.1 84.3 35.9 76.9 32 67 32zM473.7 .6C493.5-3.3 512 11.8 512 32l0 148c0 28.4-28.3 52-64 52s-64-23.6-64-52 28.3-52 64-52c11.7 0 22.6 2.5 32 6.9L480 32 352 57.6 352 220c0 28.4-28.3 52-64 52s-64-23.6-64-52 28.3-52 64-52c11.7 0 22.6 2.5 32 6.9l0-117.3c0-15.3 10.8-28.4 25.7-31.4L473.7 .6zM320 220c0-5.5-8.2-20-32-20s-32 14.5-32 20 8.2 20 32 20 32-14.5 32-20zm160-40c0-5.5-8.2-20-32-20s-32 14.5-32 20 8.2 20 32 20 32-14.5 32-20zM86.5 286.2c5.9-8.9 15.9-14.2 26.6-14.2l61.7 0c10.7 0 20.7 5.3 26.6 14.2l11.8 17.8 26.7 0c26.5 0 48 21.5 48 48l0 112c0 26.5-21.5 48-48 48L48 512c-26.5 0-48-21.5-48-48L0 352c0-26.5 21.5-48 48-48l26.7 0 11.8-17.8zM174.9 304l-61.7 0-16.6 24.9c-3 4.5-8 7.1-13.3 7.1L48 336c-8.8 0-16 7.2-16 16l0 112c0 8.8 7.2 16 16 16l192 0c8.8 0 16-7.2 16-16l0-112c0-8.8-7.2-16-16-16l-35.2 0c-5.3 0-10.3-2.7-13.3-7.1L174.9 304zM128 400a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm16 48a48 48 0 1 1 0-96 48 48 0 1 1 0 96zM475.7 277.1c6 6.5 5.6 16.6-.8 22.6L392.7 376 480 376c6.6 0 12.5 4 14.9 10.2s.8 13.1-4 17.6l-112 104c-6.5 6-16.6 5.6-22.6-.8s-5.6-16.6 .8-22.6l82.1-76.3-87.3 0c-6.6 0-12.5-4-14.9-10.2s-.8-13.1 4-17.6l112-104c6.5-6 16.6-5.6 22.6 .8z"]],
    "file-xml": [576, 512, [], "e654", ["M64 64c0-17.7 14.3-32 32-32l128 0 0 96c0 35.3 28.7 64 64 64l96 0 0 144-152 0c-30.9 0-56 25.1-56 56l0 88-80 0c-17.7 0-32-14.3-32-32L64 64z", "M224 32L96 32C78.3 32 64 46.3 64 64l0 384c0 17.7 14.3 32 32 32l80 0 0 32-80 0c-35.3 0-64-28.7-64-64L32 64C32 28.7 60.7 0 96 0L229.5 0c17 0 33.3 6.7 45.3 18.7L397.3 141.3c12 12 18.7 28.3 18.7 45.3l0 149.5-32 0 0-144-96 0c-35.3 0-64-28.7-64-64l0-96zM370.7 160L256 45.3 256 128c0 17.7 14.3 32 32 32l82.7 0zM512 528l0-128c0-8.8 7.2-16 16-16s16 7.2 16 16l0 112 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16zM381.7 391.8l34.3 57.1 34.3-57.1c3.7-6.2 11.1-9.1 18-7.2S480 392.8 480 400l0 128c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-70.2-18.3 30.5c-2.9 4.8-8.1 7.8-13.7 7.8s-10.8-3-13.7-7.8L384 457.8 384 528c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-128c0-7.2 4.8-13.5 11.7-15.4s14.3 1 18 7.2zM256 400c0 7.3 2.2 14.4 6.2 20.4l9.8 14.7 9.8-14.7c4-6.1 6.2-13.2 6.2-20.4 0-8.8 7.2-16 16-16s16 7.2 16 16c0 13.6-4 26.9-11.6 38.2l-17.2 25.8 17.2 25.8c7.5 11.3 11.6 24.6 11.6 38.2 0 8.8-7.2 16-16 16s-16-7.2-16-16c0-7.3-2.2-14.4-6.2-20.4l-9.8-14.7-9.8 14.7c-4 6.1-6.2 13.2-6.2 20.4 0 8.8-7.2 16-16 16s-16-7.2-16-16c0-13.6 4-26.9 11.6-38.2l17.2-25.8-17.2-25.8c-7.5-11.3-11.6-24.6-11.6-38.2 0-8.8 7.2-16 16-16s16 7.2 16 16z"]],
    "ruler-vertical": [256, 512, [], "f548", ["M32 16l0 480c0 8.8 7.2 16 16 16l160 0c8.8 0 16-7.2 16-16l0-48-80 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l80 0 0-56-48 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l48 0 0-56-80 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l80 0 0-56-48 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l48 0 0-56-80 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l80 0 0-48c0-8.8-7.2-16-16-16L48 0C39.2 0 32 7.2 32 16z", "M32 496L32 16C32 7.2 39.2 0 48 0L208 0c8.8 0 16 7.2 16 16l0 48-80 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l80 0 0 56-48 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l48 0 0 56-80 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l80 0 0 56-48 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l48 0 0 56-80 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l80 0 0 48c0 8.8-7.2 16-16 16L48 512c-8.8 0-16-7.2-16-16zM256 80l0-64c0-26.5-21.5-48-48-48L48-32C21.5-32 0-10.5 0 16L0 496c0 26.5 21.5 48 48 48l160 0c26.5 0 48-21.5 48-48l0-416z"]],
    "map-location-dot": [640, 512, ["map-marked-alt"], "f5a0", ["M96 110.2l112-50.8 0 343.6-112 56.4 0-349.2zM240 55.5l160 53.3 0 109.4c-34.3 30.2-56 74.2-56 123.6 0 33.2 10.4 65.4 23.2 93.1 2 4.3 4 8.5 6.2 12.7L240 403.2 240 55.5zM432 109L544 52.6 544 179c-10.4-2-21.1-3-32-3-28.9 0-56.1 7.2-80 20l0-87z", "M576 26.7c0-5.6-2.9-10.7-7.6-13.6s-10.6-3.2-15.6-.7L416.9 80.7 242.6 22.6c-11.5-3.8-24-3.2-35 1.8L73.4 85.3C67.7 87.9 64 93.6 64 99.9l0 385.4c0 5.6 2.9 10.7 7.6 13.6s10.6 3.2 15.6 .7l135.9-68.4 174.3 58.1 .6 .2c-3.7-5.6-7.3-11.3-10.8-17.1-4.7-7.8-9.4-16.1-13.8-24.8l-133.4-44.5 0-347.7 160 53.3 0 109.4c9.7-8.6 20.5-16.1 32-22.2l0-87 112-56.4 0 126.4c11.1 2.1 21.8 5.3 32 9.5l0-161.8zM208 403L96 459.4 96 110.2 208 59.4 208 403zM512 256c49.1 0 88 39 88 85.9 0 25.6-12.4 57.1-31.8 89.4-18 29.9-39.9 57.1-56.2 75.8-16.4-18.7-38.2-45.8-56.2-75.8-19.4-32.3-31.8-63.8-31.8-89.4 0-46.9 38.9-85.9 88-85.9zM392 341.9c0 68.9 64.1 150.4 98.6 189.3 11.6 13 31.3 13 42.9 0 34.5-38.9 98.6-120.4 98.6-189.3 0-65.1-53.7-117.9-120-117.9S392 276.8 392 341.9zM512 368a24 24 0 1 1 0-48 24 24 0 1 1 0 48zm-56-24a56 56 0 1 0 112 0 56 56 0 1 0 -112 0z"]],
    "watermelon-slice": [512, 512, [], "e337", ["M86.3 368.3L368.3 86.3c29.8 34.9 47.7 80.2 47.7 129.7 0 110.5-89.5 200-200 200-49.5 0-94.7-18-129.7-47.7zm78.3-43.6c-6.2 6.2-6.2 16.4 0 22.6l16 16c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-16-16c-6.2-6.2-16.4-6.2-22.6 0zm80-80c-6.2 6.2-6.2 16.4 0 22.6l16 16c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-16-16c-6.2-6.2-16.4-6.2-22.6 0zm8 88c-6.2 6.2-6.2 16.4 0 22.6l16 16c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-16-16c-6.2-6.2-16.4-6.2-22.6 0zm72-168c-6.2 6.2-6.2 16.4 0 22.6l16 16c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-16-16c-6.2-6.2-16.4-6.2-22.6 0zm8 88c-6.2 6.2-6.2 16.4 0 22.6l16 16c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-16-16c-6.2-6.2-16.4-6.2-22.6 0z", "M404.7 4.7c6.2-6.2 16.4-6.2 22.6 0 54.2 54.2 84.7 127.8 84.7 204.5l0 4C512 378.2 378.2 512 213.2 512l-4 0c-76.7 0-150.2-30.5-204.5-84.7-6.2-6.2-6.2-16.4 0-22.6l400-400zm11 34.3L391 63.7c35.5 40.8 57 94 57 152.3 0 128.1-103.9 232-232 232-58.3 0-111.6-21.5-152.3-57L39 415.6C85.8 457 146.3 480 209.1 480l4 0C360.5 480 480 360.5 480 213.2l0-4c0-62.8-23-123.3-64.4-170.2zM86.3 368.3c34.9 29.8 80.2 47.7 129.7 47.7 110.5 0 200-89.5 200-200 0-49.5-18-94.7-47.7-129.7L86.3 368.3zm261-203.6l16 16c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-16-16c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0zm-80 80l16 16c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-16-16c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0zm88 8l16 16c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-16-16c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0zm-168 72l16 16c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-16-16c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0zm88 8l16 16c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-16-16c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0z"]],
    "jack-o-lantern": [512, 512, [127875], "f30e", ["M32 304c0 47.6 12.9 89.2 32.1 118 19.3 29 42.6 42 63.9 42 10.3 0 20.7-2.9 30.8-9 20.4-12.1 46-12.1 66.4 0 10.2 6 20.5 9 30.8 9s20.7-2.9 30.8-9c20.3-12.1 46-12.1 66.4 0 10.2 6 20.5 9 30.8 9 21.3 0 44.5-13 63.9-42 19.2-28.8 32.1-70.4 32.1-118s-12.9-89.2-32.1-118c-19.4-29-42.6-42-63.9-42-10.3 0-20.7 2.9-30.8 9-20.3 12.1-46 12.1-66.4 0-10.2-6-20.5-9-30.8-9s-20.7 2.9-30.8 9c-20.4 12.1-46 12.1-66.4 0-10.2-6-20.5-9-30.8-9-21.3 0-44.5 13-63.9 42-19.2 28.8-32.1 70.4-32.1 118zm70.5 13.3c-3.4-11.7 8.4-21 20-17.3 2.3 .7 4.7 1.5 7 2.2 2.1 .6 4.1 1.2 6.2 1.8 36.6 10.3 77.3 16 120.2 16s83.6-5.7 120.2-16c2.1-.6 4.2-1.2 6.2-1.8 2.4-.7 4.7-1.4 7-2.2 11.6-3.7 23.4 5.6 20 17.3-19.5 66.3-80.9 114.7-153.5 114.7S122 383.6 102.5 317.3zm29-79.2l32-40c3-3.8 7.6-6 12.5-6s9.5 2.2 12.5 6l32 40c5.5 6.9 4.4 17-2.5 22.5s-17 4.4-22.5-2.5L176 233.6 156.5 258c-5.5 6.9-15.6 8-22.5 2.5s-8-15.6-2.5-22.5zm160 0l32-40c3-3.8 7.6-6 12.5-6s9.5 2.2 12.5 6l32 40c5.5 6.9 4.4 17-2.5 22.5s-17 4.4-22.5-2.5L336 233.6 316.5 258c-5.5 6.9-15.6 8-22.5 2.5s-8-15.6-2.5-22.5z", "M227.3 48l57.4 0 29.1 81.5c-3.7-.7-7.3-2-10.6-4-14.6-8.7-30.5-13.5-47.2-13.5s-32.6 4.8-47.2 13.5c-3.3 2-6.9 3.3-10.6 4L227.3 48zM199 31.9l-31.9 89.2c-12.3-5.9-25.5-9.2-39.2-9.2-70.7 0-128 86-128 192S57.3 496 128 496c16.7 0 32.6-4.8 47.2-13.5 10.3-6.1 23.4-6.1 33.7 0 14.6 8.7 30.5 13.5 47.2 13.5s32.6-4.8 47.2-13.5c10.3-6.1 23.4-6.1 33.7 0 14.6 8.7 30.5 13.5 47.2 13.5 70.7 0 128-86 128-192S454.7 112 384 112c-13.7 0-26.8 3.2-39.2 9.2L313 31.9C309.6 22.4 300.5 16 290.4 16l-68.7 0c-10.1 0-19.2 6.4-22.6 15.9zM128 464c-21.3 0-44.5-13-63.9-42-19.2-28.8-32.1-70.4-32.1-118s12.9-89.2 32.1-118c19.3-29 42.6-42 63.9-42 10.3 0 20.7 2.9 30.8 9 20.4 12.1 46 12.1 66.4 0 10.2-6 20.5-9 30.8-9s20.7 2.9 30.8 9c20.3 12.1 46 12.1 66.4 0 10.2-6 20.5-9 30.8-9 21.3 0 44.5 13 63.9 42 19.2 28.8 32.1 70.4 32.1 118s-12.9 89.2-32.1 118c-19.4 29-42.6 42-63.9 42-10.3 0-20.7-2.9-30.8-9-20.3-12.1-46-12.1-66.4 0-10.2 6-20.5 9-30.8 9s-20.7-2.9-30.8-9c-20.4-12.1-46-12.1-66.4 0-10.2 6-20.5 9-30.8 9zm60.5-266c-3-3.8-7.6-6-12.5-6s-9.5 2.2-12.5 6l-32 40c-5.5 6.9-4.4 17 2.5 22.5s17 4.4 22.5-2.5L176 233.6 195.5 258c5.5 6.9 15.6 8 22.5 2.5s8-15.6 2.5-22.5l-32-40zm160 0c-3-3.8-7.6-6-12.5-6s-9.5 2.2-12.5 6l-32 40c-5.5 6.9-4.4 17 2.5 22.5s17 4.4 22.5-2.5L336 233.6 355.5 258c5.5 6.9 15.6 8 22.5 2.5s8-15.6 2.5-22.5l-32-40zM147.6 340.1c30.2 7 61.2 11.1 92.4 12.1l0 7.8c0 8.8 7.2 16 16 16s16-7.2 16-16l0-7.8c31.2-1 62.3-5.1 92.4-12.1-7.7 12.3-17.5 23.2-28.9 32.2-1.7-7-8-12.3-15.6-12.3-8.8 0-16 7.2-16 16l0 14.7c-14.8 6-31 9.3-48 9.3s-33.2-3.3-48-9.3l0-14.7c0-8.8-7.2-16-16-16-7.6 0-13.9 5.2-15.6 12.3-11.3-9-21.1-19.9-28.9-32.2zM389.5 300c-85.2 27.3-181.8 27.3-267 0-11.6-3.7-23.4 5.6-20 17.3 19.5 66.3 80.9 114.7 153.5 114.7s134-48.4 153.5-114.7c3.4-11.7-8.4-21-20-17.3z"]],
    "candy": [576, 512, [127852], "e3e7", ["M112 256c0 97.2 78.8 176 176 176 38.4 0 73.9-12.3 102.9-33.2L112.4 243.5c-.3 4.1-.4 8.3-.4 12.5zm71-141.3L462.9 275.7c.7-6.5 1.1-13 1.1-19.7 0-97.2-78.8-176-176-176-39.3 0-75.7 12.9-105 34.7z", "M575.9 94.7c.6 6.8-3.3 13.3-9.6 16l-97.8 41.9c17.5 30.5 27.5 65.8 27.5 103.4 0 114.9-93.1 208-208 208-37.6 0-72.9-10-103.4-27.5l-41.9 97.7c-2.7 6.3-9.1 10.2-16 9.6s-12.6-5.4-14.2-12.1l-11.8-47.2-31.6 10.5c-5.7 1.9-12.1 .4-16.4-3.9s-5.8-10.6-3.9-16.4l10.5-31.6-47.2-11.8C5.5 429.9 .6 424.1 .1 417.3s3.3-13.3 9.6-16l97.7-41.9C90 329 80 293.7 80 256 80 141.1 173.1 48 288 48 325.6 48 360.9 58 391.4 75.5l41.9-97.8c2.7-6.3 9.1-10.2 16-9.6s12.6 5.4 14.2 12.1l11.8 47.2 31.6-10.5c5.8-1.9 12.1-.4 16.4 3.9s5.8 10.6 3.9 16.4l-10.5 31.6 47.2 11.8c6.7 1.7 11.5 7.4 12.1 14.2zm-157.6-.8c11.7 9.4 22.4 20.1 31.8 31.8l60-25.7-17.9-4.5c-4.3-1.1-8-3.9-10.1-7.8s-2.6-8.5-1.2-12.8l5.9-17.6-17.6 5.9c-4.2 1.4-8.9 1-12.8-1.2s-6.7-5.8-7.8-10.1L444 34 418.3 93.9zM390.8 398.8L112.4 243.5c-.3 4.1-.4 8.3-.4 12.5 0 97.2 78.8 176 176 176 38.4 0 73.9-12.3 102.9-33.2zm25.5-22.4c17.9-19.1 31.6-42.2 39.6-67.8L158 137.3c-18.6 20.4-32.5 45.2-40 72.7L416.3 376.4zm46.5-100.7c.7-6.5 1.1-13 1.1-19.7 0-97.2-78.8-176-176-176-39.3 0-75.7 12.9-105 34.7L462.9 275.7zm-337 110.6L66 412 83.9 416.5c4.3 1.1 8 3.9 10.1 7.8s2.6 8.5 1.2 12.8l-5.9 17.6 17.6-5.9c4.2-1.4 8.9-1 12.8 1.2s6.7 5.8 7.8 10.1l4.5 17.9 25.7-59.9c-11.7-9.4-22.4-20.1-31.8-31.8z"]],
    "heart-crack": [512, 512, [128148, "heart-broken"], "f7a9", ["M32 165.1c0 55 34.4 107.1 71.8 152.5 42.1 51.2 93.4 96 128.5 122.9 6.2 4.8 14.4 7.5 23.7 7.5s17.4-2.7 23.7-7.5c35.1-26.8 86.4-71.7 128.5-122.9 37.3-45.4 71.8-97.5 71.8-152.5 0-55.9-45.3-101.1-101.1-101.1-32.4 0-62.9 15.6-81.9 41.9l-20.9 28.9 40.1 46.8c3 3.5 4.3 8.1 3.7 12.6s-3.2 8.6-7 11.1l-81.5 54.3 53.1 66.4c5.5 6.9 4.4 17-2.5 22.5s-17 4.4-22.5-2.5l-64-80c-2.8-3.5-4-8-3.3-12.4s3.2-8.4 6.9-10.9l81-54-36.3-42.3c-1.2-1.4-2.1-2.9-2.7-4.5l-26-36C196.1 79.6 165.6 64 133.1 64 77.3 64 32 109.3 32 165.1z", "M296.9 105.9c19-26.3 49.5-41.9 81.9-41.9 55.9 0 101.1 45.3 101.1 101.1 0 55-34.5 107.1-71.8 152.5-42.1 51.2-93.4 96-128.5 122.9-6.2 4.8-14.4 7.5-23.7 7.5s-17.4-2.7-23.7-7.5c-35.1-26.8-86.4-71.7-128.5-122.9-37.3-45.4-71.8-97.5-71.8-152.5 0-55.9 45.3-101.1 101.1-101.1 32.4 0 62.9 15.6 81.9 41.9l26 36c.6 1.6 1.6 3.2 2.7 4.5l36.3 42.3-81 54c-3.7 2.5-6.2 6.4-6.9 10.9s.5 8.9 3.3 12.4l64 80c5.5 6.9 15.6 8 22.5 2.5s8-15.6 2.5-22.5l-53.1-66.4 81.5-54.3c3.8-2.5 6.3-6.6 7-11.1s-.7-9.1-3.7-12.6l-40.1-46.8 20.9-28.9zM378.9 32C336.2 32 296 52.5 271 87.1l-15 20.7-15-20.7C216 52.5 175.8 32 133.1 32 59.6 32 0 91.6 0 165.1 0 232.5 41.6 292.4 79.1 338 123.2 391.5 176.4 438 212.9 465.9 225.2 475.4 240.4 480 256 480s30.8-4.6 43.1-14.1C335.6 438 388.8 391.5 432.9 338 470.4 292.4 512 232.5 512 165.1 512 91.6 452.4 32 378.9 32z"]],
    "cow": [640, 512, [128004], "f6c8", ["M128 144c0-15 6.8-28.3 17.6-37.1 3.8 22.8 14.7 44 31.2 60.5l3.1 3.1c24 24 56.6 37.5 90.5 37.5l3.2 0c33.9 0 66.5-13.5 90.5-37.5l3.1-3.1c19.2-19.2 30.7-44.6 32.5-71.4l30 0c26.3 0 50.8 12.9 65.8 34.5l51.7 74.7c3.7 5.4 10.3 7.9 16.7 6.5s11.2-6.6 12.3-13c.6-3.8 3.9-6.7 7.9-6.7 4.4 0 8 3.6 8 8l0 64.9c0 3.3 1 6.4 2.8 9.1l10.3 14.9c1.9 2.7 2.8 5.9 2.8 9.1l0 87.5c0 16.8-13.6 30.5-30.5 30.5-10.4 0-20.1-5.3-25.7-14.1l-37.3-58.6c-1.6-2.6-2.5-5.5-2.5-8.6l0-62.7c0-6.1-3.4-11.6-8.8-14.3l-64-32c-5-2.5-10.9-2.2-15.6 .7S416 234.5 416 240l0 168c0 4.4-3.6 8-8 8l-32 0c-4.4 0-8-3.6-8-8l0-72c0-53-43-96-96-96s-96 43-96 96l0 72c0 4.4-3.6 8-8 8l-32 0c-4.4 0-8-3.6-8-8l0-264zM552 320a16 16 0 1 0 32 0 16 16 0 1 0 -32 0z", "M128 144l0 264c0 4.4 3.6 8 8 8l32 0c4.4 0 8-3.6 8-8l0-72c0-53 43-96 96-96s96 43 96 96l0 72c0 4.4 3.6 8 8 8l32 0c4.4 0 8-3.6 8-8l0-168c0-5.5 2.9-10.7 7.6-13.6s10.6-3.2 15.6-.7l64 32c5.4 2.7 8.8 8.2 8.8 14.3l0 62.7c0 3 .9 6 2.5 8.6l37.3 58.6c5.6 8.8 15.3 14.1 25.7 14.1 16.8 0 30.5-13.6 30.5-30.5l0-87.5c0-3.3-1-6.4-2.8-9.1L594.8 274c-1.9-2.7-2.8-5.9-2.8-9.1l0-64.9c0-4.4-3.6-8-8-8-4 0-7.3 2.9-7.9 6.7-1.1 6.4-5.9 11.6-12.3 13s-12.9-1.1-16.7-6.5l-51.7-74.7C480.5 108.9 456 96 429.7 96l-30 0c-1.9 26.9-13.4 52.3-32.5 71.4l-3.1 3.1c-24 24-56.6 37.5-90.5 37.5l-3.2 0c-33.9 0-66.5-13.5-90.5-37.5l-3.1-3.1c-16.6-16.6-27.4-37.8-31.2-60.5-10.7 8.8-17.6 22.2-17.6 37.1zm71.4 .8l3.1 3.1c18 18 42.4 28.1 67.9 28.1l3.2 0c25.5 0 49.9-10.1 67.9-28.1l3.1-3.1c13.2-13.2 21.3-30.4 23.1-48.8L176.4 96c1.8 18.4 9.9 35.6 23.1 48.8zm8.6 231l0 32.2c0 22.1-17.9 40-40 40l-32 0c-22.1 0-40-17.9-40-40l0-264c0-18 6-34.6 16-48-26.5 0-48 21.5-48 48l0 124.8C64 297.1 41.1 320 12.8 320 5.7 320 0 314.3 0 307.2L0 288c0-23.7 12.9-44.4 32-55.4L32 144c0-44.2 35.8-80 80-80l317.7 0c36.8 0 71.2 18 92.1 48.2l38.5 55.6c6.6-4.9 14.9-7.8 23.7-7.8 22.1 0 40 17.9 40 40l0 59.9 7.5 10.8c5.6 8 8.5 17.6 8.5 27.3l0 87.5c0 34.5-28 62.5-62.5 62.5-21.4 0-41.2-10.9-52.7-28.9l-37.3-58.6c-4.9-7.7-7.5-16.6-7.5-25.8l0-52.8-32-16 0 142.1c0 22.1-17.9 40-40 40l-32 0c-22.1 0-40-17.9-40-40l0-32.2c-6.6 2-14.6 3.8-24 5.3l0 10.9c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-8.1c-5.1 .1-10.9 .1-16 0l0 8.1c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-10.9c-9.4-1.5-17.4-3.3-24-5.3zm0-33.8c2.1 .8 4.7 1.8 7.7 2.7 11.4 3.5 29.8 7.3 56.3 7.3s44.9-3.8 56.3-7.3c3-.9 5.6-1.9 7.7-2.7l0-6c0-35.3-28.7-64-64-64s-64 28.7-64 64l0 6zm344-22a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"]],
    "rss": [448, 512, ["feed"], "f09e", ["M32 416a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M0 48c0-8.8 7.2-16 16-16 238.6 0 432 193.4 432 432 0 8.8-7.2 16-16 16s-16-7.2-16-16C416 243.1 236.9 64 16 64 7.2 64 0 56.8 0 48zM64 448a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm0-96a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM16 160c167.9 0 304 136.1 304 304 0 8.8-7.2 16-16 16s-16-7.2-16-16c0-150.2-121.8-272-272-272-8.8 0-16-7.2-16-16s7.2-16 16-16z"]],
    "magnifying-glass": [512, 512, [128269, "search"], "f002", ["M32 208a176 176 0 1 0 352 0 176 176 0 1 0 -352 0z", "M384 208a176 176 0 1 0 -352 0 176 176 0 1 0 352 0zM343.3 366C307 397.2 259.7 416 208 416 93.1 416 0 322.9 0 208S93.1 0 208 0 416 93.1 416 208c0 51.7-18.8 99-50 135.3L507.3 484.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L343.3 366z"]],
    "objects-align-left": [512, 512, [], "e3be", ["M160 112l0 64c0 8.8 7.2 16 16 16l288 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16L176 96c-8.8 0-16 7.2-16 16zm0 224l0 64c0 8.8 7.2 16 16 16l160 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16l-160 0c-8.8 0-16 7.2-16 16z", "M0 16C0 7.2 7.2 0 16 0S32 7.2 32 16l0 480c0 8.8-7.2 16-16 16S0 504.8 0 496L0 16zM160 176c0 8.8 7.2 16 16 16l288 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16L176 96c-8.8 0-16 7.2-16 16l0 64zm-32-64c0-26.5 21.5-48 48-48l288 0c26.5 0 48 21.5 48 48l0 64c0 26.5-21.5 48-48 48l-288 0c-26.5 0-48-21.5-48-48l0-64zm32 288c0 8.8 7.2 16 16 16l160 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16l-160 0c-8.8 0-16 7.2-16 16l0 64zm-32-64c0-26.5 21.5-48 48-48l160 0c26.5 0 48 21.5 48 48l0 64c0 26.5-21.5 48-48 48l-160 0c-26.5 0-48-21.5-48-48l0-64z"]],
    "cloud-moon": [640, 512, [], "f6c3", ["M64 416c0 35.3 28.7 64 64 64l272 0c26.5 0 47.9-21.5 47.9-48 0-28.8-26.4-51.5-54.7-47.5-6.1 .8-12.1-1.9-15.5-7s-3.6-11.7-.4-17c4.2-7.1 6.7-15.5 6.7-24.4 0-26.5-21.5-48-48-48-15.7 0-29.6 7.5-38.4 19.2-3.6 4.8-9.7 7.2-15.7 6.1s-10.8-5.4-12.5-11.3c-7.8-26.6-32.4-46-61.4-46-35.3 0-64 28.7-64 64 0 4.4 .4 8.7 1.3 12.8 1 4.8-.3 9.7-3.4 13.4s-7.7 5.8-12.6 5.8C93.9 351.3 64 380.6 64 416zM320 192c0 5.7 .3 11.3 .9 16.9 4.9-.6 10-.9 15-.9 65.5 0 119.5 49.2 127.1 112.6 13.8 7.8 26 18.1 36 30.3 22.5-2.7 43.6-10 62.2-21-81.2-12.9-143.2-83.1-143.2-167.9 0-52.2 23.5-98.8 60.4-130-87.7 .8-158.4 72.1-158.4 160z", "M478.5 32c-37 31.2-60.4 77.8-60.4 130 0 84.8 62 155 143.2 167.9-18.7 11-39.7 18.3-62.2 21 7.3 8.9 13.4 18.8 18.1 29.5 36.8-7.2 69.9-24.9 95.9-49.9 5.5-5.3 7.1-13.4 3.9-20.4s-10.3-11.2-17.8-10.6c-3.7 .3-7.4 .4-11.1 .4-76.2 0-138-61.8-138-138 0-54.1 31.1-101 76.6-123.6 6.8-3.4 10.8-10.7 9.8-18.3S529.9 6.4 522.5 4.7c-13.7-3.1-27.9-4.7-42.5-4.7-106 0-192 86-192 192 0 2.8 .1 5.6 .2 8.4 5.3 3.6 10.4 7.5 15.2 11.8 5.7-1.5 11.5-2.6 17.5-3.3-.6-5.5-.9-11.2-.9-16.9 0-87.8 70.8-159.2 158.4-160zM144 320c0-35.3 28.7-64 64-64 29.1 0 53.7 19.4 61.4 46 1.7 5.8 6.5 10.2 12.5 11.3s12-1.3 15.7-6.1c8.8-11.7 22.7-19.2 38.4-19.2 26.5 0 48 21.5 48 48 0 9-2.4 17.3-6.7 24.4-3.1 5.3-3 11.9 .4 17s9.4 7.8 15.5 7c28.3-3.9 54.7 18.7 54.7 47.5 0 26.5-21.5 48-47.9 48l-272 0c-35.3 0-64-28.7-64-64 0-35.4 29.9-64.7 65.3-64 4.9 .1 9.5-2 12.6-5.8s4.4-8.7 3.4-13.4c-.8-4.1-1.3-8.4-1.3-12.8zm146.2-49.6c-16.8-27.8-47.3-46.4-82.2-46.4-53.5 0-96.7 44-96 97.3-45.4 7.6-80 47.1-80 94.7 0 53 43 96 96 96l272 0c44.1-.1 79.9-35.8 79.9-80 0-39.4-28.4-72.1-65.8-78.7 1.2-5.6 1.9-11.3 1.9-17.2 0-44.2-35.8-80-80-80-17 0-32.8 5.3-45.8 14.4z"]],
    "abacus": [576, 512, [129518], "f640", ["M32 96l0 96 96 0 0-32-16 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0 0-64-64 0C46.3 64 32 78.3 32 96zm0 128l0 192c0 17.7 14.3 32 32 32l64 0 0-64-16 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0 0-32-16 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0 0-64-96 0zM160 64l0 64 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0 0 32 96 0 0-32-16 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0 0-64-96 0zm0 160l0 64 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0 0 32 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0 0 64 96 0 0-64-16 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0 0-32-16 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0 0-64-96 0zM288 64l0 64 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0 0 32 128 0 0-32-16 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0 0-64-128 0zm0 160l0 64 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0 0 32 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0 0 64 128 0 0-64-16 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0 0-128-128 0zM448 64l0 64 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0 0 32 96 0 0-96c0-17.7-14.3-32-32-32l-64 0zm0 160l0 128 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0 0 64 64 0c17.7 0 32-14.3 32-32l0-192-96 0z", "M512 64c17.7 0 32 14.3 32 32l0 96-96 0 0-32 16 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0 0-64 64 0zm-96 64l-16 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l16 0 0 32-128 0 0-32 16 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0 0-64 128 0 0 64zm-160 0l-16 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l16 0 0 32-96 0 0-32 16 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0 0-64 96 0 0 64zm-128 0l-16 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l16 0 0 32-96 0 0-96c0-17.7 14.3-32 32-32l64 0 0 64zM32 416l0-192 96 0 0 64-16 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l16 0 0 32-16 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l16 0 0 64-64 0c-17.7 0-32-14.3-32-32zm128-32l16 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0 0-32 16 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0 0-64 96 0 0 64-16 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l16 0 0 32-16 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l16 0 0 64-96 0 0-64zm128-64l16 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0 0-64 128 0 0 128-16 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l16 0 0 64-128 0 0-64 16 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0 0-32zm160 64l16 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0 0-128 96 0 0 192c0 17.7-14.3 32-32 32l-64 0 0-64zM64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l448 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32z"]],
    "boxes-stacked": [512, 512, [62625, "boxes", "boxes-alt"], "f468", ["M32 288l0 160c0 17.7 14.3 32 32 32l160 0c17.7 0 32-14.3 32-32l0-160c0-17.7-14.3-32-32-32l-16 0 0 56c0 22.1-17.9 40-40 40l-48 0c-22.1 0-40-17.9-40-40l0-56-16 0c-17.7 0-32 14.3-32 32zM144 64l0 112 224 0 0-112c0-17.7-14.3-32-32-32l-16 0 0 56c0 22.1-17.9 40-40 40l-48 0c-22.1 0-40-17.9-40-40l0-56-16 0c-17.7 0-32 14.3-32 32zM331.4 480L448 480c17.7 0 32-14.3 32-32l0-160c0-17.7-14.3-32-32-32l-16 0 0 56c0 22.1-17.9 40-40 40l-56 0 0 96c0 11.1-1.6 21.9-4.6 32z", "M336 32c17.7 0 32 14.3 32 32l0 112 32 0 0-112c0-35.3-28.7-64-64-64L176 0c-35.3 0-64 28.7-64 64l0 112 32 0 0-112c0-17.7 14.3-32 32-32l16 0 0 56c0 22.1 17.9 40 40 40l48 0c22.1 0 40-17.9 40-40l0-56 16 0zM224 32l64 0 0 56c0 4.4-3.6 8-8 8l-48 0c-4.4 0-8-3.6-8-8l0-56zm91.9 480L448 512c35.3 0 64-28.7 64-64l0-160c0-35.3-28.7-64-64-64l-132.1 0c6.7 9.7 12 20.4 15.4 32l68.6 0 0 56c0 4.4-3.6 8-8 8l-56 0 0 32 56 0c22.1 0 40-17.9 40-40l0-56 16 0c17.7 0 32 14.3 32 32l0 160c0 17.7-14.3 32-32 32l-116.6 0c-3.4 11.6-8.7 22.3-15.4 32zM240 448.1l0-.1 0-160 0 0 0 160 0 .1zM224 256c17.7 0 32 14.3 32 32l0 160c0 17.7-14.3 32-32 32L64 480c-17.7 0-32-14.3-32-32l0-160c0-17.7 14.3-32 32-32l16 0 0 56c0 22.1 17.9 40 40 40l48 0c22.1 0 40-17.9 40-40l0-56 16 0zM112 312l0-56 64 0 0 56c0 4.4-3.6 8-8 8l-48 0c-4.4 0-8-3.6-8-8zm112-88L64 224c-35.3 0-64 28.7-64 64L0 448c0 35.3 28.7 64 64 64l160 0c35.3 0 64-28.7 64-64l0-160c0-35.3-28.7-64-64-64z"]],
    "code-branch": [448, 512, [], "f126", ["M32 80a48 48 0 1 0 96 0 48 48 0 1 0 -96 0zm0 352a48 48 0 1 0 96 0 48 48 0 1 0 -96 0zM320 80a48 48 0 1 0 96 0 48 48 0 1 0 -96 0z", "M80 128a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm80-48c0 38.7-27.5 71-64 78.4l0 81.6 192 0c35.3 0 64-28.7 64-64l0-17.6c-36.5-7.4-64-39.7-64-78.4 0-44.2 35.8-80 80-80s80 35.8 80 80c0 38.7-27.5 71-64 78.4l0 17.6c0 53-43 96-96 96l-192 0 0 81.6c36.5 7.4 64 39.7 64 78.4 0 44.2-35.8 80-80 80S0 476.2 0 432c0-38.7 27.5-71 64-78.4l0-195.2C27.5 151 0 118.7 0 80 0 35.8 35.8 0 80 0s80 35.8 80 80zm208 48a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM80 480a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"]],
    "ban": [512, 512, [128683, "cancel"], "f05e", ["M32 256c0 123.7 100.3 224 224 224 56.1 0 107.4-20.6 146.7-54.7l-316-316C52.6 148.6 32 199.9 32 256zM109.3 86.7l316 316c34.1-39.3 54.7-90.6 54.7-146.7 0-123.7-100.3-224-224-224-56.1 0-107.4 20.6-146.7 54.7z", "M402.7 425.3l-316-316c-34.1 39.3-54.7 90.6-54.7 146.7 0 123.7 100.3 224 224 224 56.1 0 107.4-20.6 146.7-54.7zm22.6-22.6c34.1-39.3 54.7-90.6 54.7-146.7 0-123.7-100.3-224-224-224-56.1 0-107.4 20.6-146.7 54.7l316 316zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0z"]],
    "person-carry-box": [384, 512, ["person-carry"], "f4cf", ["M32 176l0 96c0 15.1 7.1 29.3 19.2 38.4L96 344 96 176c0-17.7-14.3-32-32-32s-32 14.3-32 32zM40 24a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zM224 144l0 96c0 8.8 7.2 16 16 16l96 0c8.8 0 16-7.2 16-16l0-96c0-8.8-7.2-16-16-16l-96 0c-8.8 0-16 7.2-16 16z", "M64 0a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm0 80A56 56 0 1 0 64-32 56 56 0 1 0 64 80zm.5 32C28.9 112 0 140.9 0 176.5L0 272c0 25.2 11.9 48.9 32 64l76.8 57.6c12.1 9.1 19.2 23.3 19.2 38.4l0 96c0 8.8 7.2 16 16 16s16-7.2 16-16l0-96c0-25.2-11.9-48.9-32-64l0-128.6 .5 1.1C141.3 269.4 170 288 201.6 288L336 288c26.5 0 48-21.5 48-48l0-96c0-26.5-21.5-48-48-48l-96 0c-26.5 0-48 21.5-48 48l0 96c0 5.4 .9 10.6 2.6 15.5-16.1-2.4-30.1-12.8-36.8-28l-34.3-77.2C113.1 127 90 112 64.5 112zM240 256c-8.8 0-16-7.2-16-16l0-96c0-8.8 7.2-16 16-16l96 0c8.8 0 16 7.2 16 16l0 96c0 8.8-7.2 16-16 16l-96 0zM0 528c0 8.8 7.2 16 16 16s16-7.2 16-16l0-132-28.8-21.6c-1.1-.8-2.1-1.6-3.2-2.5L0 528zM96 176l0 168-44.8-33.6C39.1 301.3 32 287.1 32 272l0-96c0-17.7 14.3-32 32-32s32 14.3 32 32z"]],
    "circle-litecoin": [512, 512, [], "e6f4", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm112.8 5.1c-2.8-8.4 1.7-17.4 10.1-20.2l37.1-12.4 0-84.5c0-8.8 7.2-16 16-16s16 7.2 16 16l0 73.8 74.9-25c8.4-2.8 17.4 1.7 20.2 10.1s-1.7 17.4-10.1 20.2l-85.1 28.4 0 100.5 112 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-128 0c-8.8 0-16-7.2-16-16l0-105.8-26.9 9c-8.4 2.8-17.4-1.7-20.2-10.1z", "M256 32a224 224 0 1 1 0 448 224 224 0 1 1 0-448zm0 480a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM208 128c-8.8 0-16 7.2-16 16l0 84.5-37.1 12.4c-8.4 2.8-12.9 11.9-10.1 20.2s11.9 12.9 20.2 10.1l26.9-9 0 105.8c0 8.8 7.2 16 16 16l128 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-112 0 0-100.5 85.1-28.4c8.4-2.8 12.9-11.9 10.1-20.2s-11.9-12.9-20.2-10.1l-74.9 25 0-73.8c0-8.8-7.2-16-16-16z"]],
    "jug-detergent": [384, 512, [], "e519", ["M32 256l0 192c0 17.7 14.3 32 32 32l256 0c17.7 0 32-14.3 32-32l0-192c0-53-43-96-96-96l-128 0c-53 0-96 43-96 96zM128 32l0 32 64 0 0-32-64 0zm80 224c0-26.5 21.5-48 48-48s48 21.5 48 48l0 96c0 26.5-21.5 48-48 48s-48-21.5-48-48l0-96z", "M128 64l0-32 64 0 0 32-64 0zM96 64L80 64c-8.8 0-16 7.2-16 16s7.2 16 16 16l160 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0 0-40c0-13.3-10.7-24-24-24L120 0C106.7 0 96 10.7 96 24l0 40zm32 96l128 0c53 0 96 43 96 96l0 192c0 17.7-14.3 32-32 32L64 480c-17.7 0-32-14.3-32-32l0-192c0-53 43-96 96-96zm0-32C57.3 128 0 185.3 0 256L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-192c0-70.7-57.3-128-128-128l-128 0zm128 80c-26.5 0-48 21.5-48 48l0 96c0 26.5 21.5 48 48 48s48-21.5 48-48l0-96c0-26.5-21.5-48-48-48zm-16 48c0-8.8 7.2-16 16-16s16 7.2 16 16l0 96c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-96z"]],
    "floppy-disk-pen": [576, 512, [], "e182", ["M64.4 96c0-17.7 14.3-32 32-32l32 0 0 112c0 17.7 14.3 32 32 32l160 0c17.7 0 32-14.3 32-32l0-109.1c3.5 1.6 6.6 3.8 9.4 6.5L439 150.6c6 6 9.4 14.1 9.4 22.6l0 50c-6.4 4.2-12.5 9.2-18.1 14.8L284.8 383.6c-16.5 16.5-27.4 37.8-31.3 60.8-.2 1.2-.4 2.4-.6 3.7L96.4 448c-17.7 0-32-14.3-32-32l0-320zm128 224a64 64 0 1 0 128 0 64 64 0 1 0 -128 0z", "M96.4 64c-17.7 0-32 14.3-32 32l0 320c0 17.7 14.3 32 32 32l156.5 0-5.3 32-151.2 0c-35.3 0-64-28.7-64-64l0-320c0-35.3 28.7-64 64-64l242.7 0c17 0 33.3 6.7 45.3 18.7L461.6 128c12 12 18.7 28.3 18.7 45.3l0 35.3c-11.2 3.2-22 8.1-32 14.7l0-50c0-8.5-3.4-16.6-9.4-22.6L361.8 73.4c-2.7-2.7-5.9-4.9-9.4-6.5l0 109.1c0 17.7-14.3 32-32 32l-160 0c-17.7 0-32-14.3-32-32l0-112-32 0zm64 0l0 112 160 0 0-112-160 0zm128 256a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm-96 0a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zM341.5 440.3c-4.7 4.7-7.8 10.8-8.9 17.4l-8.5 50.8 50.8-8.5c6.6-1.1 12.6-4.2 17.4-8.9l102.2-102.2-50.7-50.7-102.2 102.2zM466.3 315.4l50.7 50.7 20.7-20.7c14-14 14-36.7 0-50.7s-36.7-14-50.7 0l-20.7 20.7zM301 452.4c2.2-13.2 8.4-25.3 17.9-34.7L464.4 272.1c26.5-26.5 69.5-26.5 96 0s26.5 69.5 0 96L414.9 513.6c-9.4 9.4-21.6 15.7-34.7 17.9l-74.6 12.4c-9.8 1.6-18.6-7.2-17-17L301 452.4z"]],
    "lips": [576, 512, [128068, 128482], "f600", ["M36.5 256.2l68.8 88c39.4 50.4 99.8 79.8 163.8 79.8l37.7 0c64 0 124.4-29.4 163.8-79.8l68.8-88-106.4-130.1c-15.6-19.1-39-30.1-63.6-30.1-13.5 0-26.8 3.3-38.7 9.7l-35.2 18.8c-4.7 2.5-10.4 2.5-15.1 0l-35.2-18.8c-11.9-6.4-25.2-9.7-38.7-9.7-24.6 0-48 11.1-63.6 30.1L36.5 256.2zm75.6 1.4c-.5-4.8 1.2-9.5 4.6-12.9l64-64c4.3-4.3 10.6-5.8 16.4-3.9l90.9 30.3 90.9-30.3c5.8-1.9 12.1-.4 16.4 3.9l64 64c3.4 3.4 5.1 8.1 4.6 12.9s-3.1 9.1-7 11.7l-47.6 31.8C375.1 323.8 334.9 336 293.9 336l-11.7 0c-41.1 0-81.2-12.2-115.4-34.9l-47.6-31.8c-4-2.7-6.6-7-7-11.7z", "M206.5 64c-34.2 0-66.7 15.4-88.4 41.9L3.6 245.9c-4.7 5.8-4.8 14.1-.2 20l76.7 98.1C125.6 422 195.3 456 269.1 456l37.7 0c73.8 0 143.5-34 189-92.1l76.7-98.1c4.6-5.9 4.5-14.2-.2-20l-114.5-140c-21.7-26.5-54.1-41.9-88.4-41.9-18.8 0-37.3 4.6-53.8 13.5L288 92.3 260.3 77.5c-16.6-8.8-35-13.5-53.8-13.5zm-63.6 62.1c15.6-19.1 39-30.1 63.6-30.1 13.5 0 26.8 3.3 38.7 9.7l35.2 18.8c4.7 2.5 10.4 2.5 15.1 0l35.2-18.8c11.9-6.4 25.2-9.7 38.7-9.7 24.6 0 48 11.1 63.6 30.1l106.4 130.1-68.8 88C431.2 394.6 370.8 424 306.9 424l-37.7 0c-64 0-124.4-29.4-163.8-79.8l-68.8-88 106.4-130.1zm54.1 50.7c-5.7-1.9-12.1-.4-16.4 3.9l-64 64c-3.4 3.4-5.1 8.1-4.6 12.9s3.1 9.1 7 11.7l47.6 31.8c34.2 22.8 74.3 34.9 115.4 34.9l11.7 0c41.1 0 81.2-12.2 115.4-34.9l47.6-31.8c4-2.7 6.6-7 7-11.7s-1.2-9.5-4.6-12.9l-64-64c-4.3-4.3-10.6-5.8-16.4-3.9l-90.9 30.3-90.9-30.3zm-43.9 76.7l43.2-43.2 86.6 28.9c3.3 1.1 6.8 1.1 10.1 0l86.6-28.9 43.2 43.2-31.4 20.9c-28.9 19.3-62.9 29.6-97.6 29.6l-11.7 0c-34.7 0-68.7-10.3-97.6-29.6l-31.4-20.9z"]],
    "outlet": [448, 512, [], "e01c", ["M32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64C46.3 64 32 78.3 32 96zM80 256c0-61.1 30.8-99.1 49.7-116.6 8.8-8.2 20.7-11.4 32.6-11.4l123.3 0c12 0 23.9 3.3 32.6 11.4 18.9 17.5 49.7 55.5 49.7 116.6s-30.8 99-49.7 116.6c-8.8 8.2-20.7 11.4-32.6 11.4l-123.3 0c-12 0-23.9-3.3-32.6-11.4-18.9-17.5-49.7-55.5-49.7-116.6z", "M64 64C46.3 64 32 78.3 32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM112 256c0 49.2 24.6 79.3 39.5 93.1 1.2 1.1 4.3 2.9 10.9 2.9l123.3 0c6.6 0 9.7-1.8 10.9-2.9 14.9-13.8 39.5-43.9 39.5-93.1s-24.6-79.3-39.5-93.1c-1.2-1.1-4.3-2.9-10.9-2.9l-123.3 0c-6.6 0-9.7 1.8-10.9 2.9-14.9 13.8-39.5 43.9-39.5 93.1zm-32 0c0-61.1 30.8-99.1 49.7-116.6 8.8-8.2 20.7-11.4 32.6-11.4l123.3 0c12 0 23.9 3.3 32.6 11.4 18.9 17.5 49.7 55.5 49.7 116.6s-30.8 99-49.7 116.6c-8.8 8.2-20.7 11.4-32.6 11.4l-123.3 0c-12 0-23.9-3.3-32.6-11.4-18.9-17.5-49.7-55.5-49.7-116.6zm96-64c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zm96 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zm-48 80c13.3 0 24 10.7 24 24l0 24-48 0 0-24c0-13.3 10.7-24 24-24z"]],
    "reply": [512, 512, [61714, "mail-reply"], "f3e5", ["M32 208l160 160 0-88c0-13.3 10.7-24 24-24l104 0c70.7 0 128 57.3 128 128 0 8.3-.7 16.1-2 23.2 18.2-23.4 34-57.1 34-103.2 0-79.5-64.5-144-144-144l-120 0c-13.3 0-24-10.7-24-24l0-88-160 160z", "M216 160c-13.3 0-24-10.7-24-24l0-88-160 160 160 160 0-88c0-13.3 10.7-24 24-24l104 0c70.7 0 128 57.3 128 128 0 8.3-.7 16.1-2 23.2 18.2-23.4 34-57.1 34-103.2 0-79.5-64.5-144-144-144l-120 0zm8 144l0 64c0 12.9-7.8 24.6-19.8 29.6s-25.7 2.2-34.9-6.9l-160-160c-12.5-12.5-12.5-32.8 0-45.3l160-160c9.2-9.2 22.9-11.9 34.9-6.9S224 35.1 224 48l0 80 112 0c97.2 0 176 78.8 176 176 0 113.3-81.5 163.9-100.2 174.1-2.5 1.4-5.3 1.9-8.1 1.9-10.9 0-19.7-8.9-19.7-19.7 0-7.5 4.3-14.4 9.8-19.5 9.4-8.8 22.2-26.4 22.2-56.7 0-53-43-96-96-96l-96 0 0 16z"]],
    "sun-plant-wilt": [640, 512, [], "e57a", ["M127.1 78.1l-66.2-17.4 19.2 67.7-62.4 31.2 62.4 35.6-19.2 60.4 66.2-13.6 32.5 58.5 33.1-58.5 65.2 17.5-14.5-64.2 56-35.6-56-31.2 14.5-67.7-65.2 17.4-33.1-57.6-32.5 57.6zm245.1 212l-7.1 0c-24.4 0-44.2 19.8-44.2 44.2 0 12.4 3.9 24.4 11.1 34.4l35.6 49.4 36.8-49.3c7.5-10.1 11.6-22.3 11.6-34.9 0-24.2-19.6-43.8-43.8-43.8zm207.7-64l-7.1 0c-24.4 0-44.2 19.8-44.2 44.2 0 12.4 3.9 24.4 11.1 34.4l35.6 49.4 36.8-49.3c7.5-10.1 11.6-22.3 11.6-34.9 0-24.2-19.6-43.8-43.8-43.8z", "M528.8 97c35.3 0 63.9 28.7 63.9 64l0 49.7c11.1 2.6 21.2 7.8 29.2 16 11.9 12.1 18 28.9 18 48 0 14.3-7.5 30.8-16.5 45.2-9.4 15.1-22.3 30.8-36.5 44.2l-11-11.6 0 0 11 11.6c-6.2 5.8-15.8 5.8-22 0-14.2-13.4-27.1-29-36.5-44.1-9-14.4-16.5-30.9-16.5-45.3 0-19.1 6.1-35.9 18-48 8.4-8.5 18.9-13.8 30.6-16.3l0-49.4c0-17.6-14.3-32-31.9-32-17.6 0-32 14.3-32 31.9l0 319.2 127.2 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-142.9 0c-.1 0-.2 0-.3 0s-.2 0-.3 0L16 512.1c-8.8 0-16-7.2-16-16s7.2-16 16-16l448.8 0 0-215.4c0-22.1-17.9-39.9-39.9-39.9-22.1 0-40 17.9-40 39.9l0 9.7c11.4 2.5 21.7 7.8 29.9 16.1 11.9 12.1 18 28.9 18 48 0 14.3-7.5 30.8-16.5 45.2-9.4 15.1-22.3 30.8-36.5 44.2l-11-11.6 0 0 11 11.6c-6.2 5.8-15.8 5.8-22 0-14.2-13.4-27-29-36.5-44.1-9-14.4-16.5-30.9-16.5-45.3 0-19.1 6.1-35.9 18-48 8.2-8.3 18.5-13.6 29.9-16.1l0-9.7c0-39.7 32.2-71.9 72-71.9 14.8 0 28.5 4.5 39.9 12.1l0-43.9c0-35.3 28.7-63.9 64-63.9zM368.9 304.6c-10.5 0-18.2 3.4-23.2 8.4s-8.8 13.2-8.8 25.5c0 5 3.3 15 11.6 28.3 5.5 8.7 12.5 17.8 20.3 26.5 7.8-8.7 14.9-17.8 20.3-26.6 8.3-13.4 11.6-23.4 11.6-28.3 0-12.3-3.8-20.5-8.8-25.5s-12.6-8.4-23.2-8.4zM576 240.7c-10.6 0-18.2 3.4-23.2 8.4-5 5-8.8 13.2-8.8 25.5 0 5 3.3 15 11.6 28.3 5.5 8.7 12.5 17.8 20.3 26.5 7.8-8.7 14.9-17.8 20.3-26.6 8.3-13.4 11.6-23.4 11.6-28.3 0-12.3-3.8-20.5-8.8-25.5-5-5-12.6-8.4-23.2-8.4zM160.5 0c5.9 0 11.3 3.2 14.1 8.4l27.5 50.9 55.6-16.6c5.6-1.7 11.8-.1 15.9 4s5.7 10.3 4 15.9l-16.7 55.4 51.1 27.5c5.2 2.8 8.4 8.2 8.4 14.1s-3.2 11.3-8.4 14.1l-51.1 27.4 16.7 55.5c1.7 5.6 .2 11.7-4 15.9s-10.3 5.7-15.9 4l-55.6-16.7-27.5 51c-2.8 5.2-8.2 8.4-14.1 8.4-5.9 0-11.3-3.2-14.1-8.4l-27.5-51-55.5 16.7c-5.6 1.7-11.7 .1-15.9-4s-5.7-10.3-4-15.9l16.6-55.5-51-27.4C3.9 171 .7 165.5 .7 159.7s3.2-11.3 8.4-14.1l51-27.5-16.6-55.4c-1.7-5.6-.2-11.7 4-15.9s10.3-5.7 15.9-4l55.6 16.6 27.5-50.9 1.2-1.8c3-4.1 7.8-6.6 12.9-6.6zM140.9 86c-3.6 6.7-11.4 9.9-18.7 7.7L82.6 81.9 94.5 121.4c2.2 7.3-1.1 15.1-7.7 18.7l-36.3 19.6 36.3 19.6c6.7 3.6 9.9 11.4 7.7 18.7l-11.9 39.5 39.6-11.8 2.7-.6c6.4-.7 12.8 2.4 15.9 8.3l19.6 36.3 19.6-36.3 1.5-2.3c4-5.1 10.8-7.3 17.1-5.4l39.6 11.8-11.8-39.5c-2.2-7.3 1.1-15.1 7.8-18.7l36.3-19.6-36.3-19.6c-6.7-3.6-9.9-11.4-7.8-18.7l11.8-39.5-39.6 11.8c-7.3 2.2-15.1-1-18.7-7.7L160.5 49.7 140.9 86zm20.2 106.8a31.9 31.9 0 1 1 0-63.9 31.9 31.9 0 1 1 0 63.9z"]],
    "face-mask": [512, 512, [], "e37f", ["M32.1 250.8c0 1.7-.1 3.4-.1 5.2 0 61 24.4 116.4 64 156.8L96 320c0-11.1 2.8-21.5 7.8-30.6L32.1 250.8zm3.4-34.5l91.1 49.1c9.7-6 21.2-9.4 33.4-9.4l192 0c12.2 0 23.7 3.4 33.4 9.4l91.1-49.1C457.8 111.5 366.2 32 256 32S54.2 111.5 35.5 216.3zm79.7-6.7c-5.3-7.1-3.9-17.1 3.2-22.4l6.4-4.8c19.4-14.5 43-22.4 67.2-22.4l16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0c-17.3 0-34.2 5.6-48 16l-6.4 4.8c-7.1 5.3-17.1 3.9-22.4-3.2zM288 176c0-8.8 7.2-16 16-16l16 0c24.2 0 47.8 7.9 67.2 22.4l6.4 4.8c7.1 5.3 8.5 15.3 3.2 22.4s-15.3 8.5-22.4 3.2L368 208c-13.8-10.4-30.7-16-48-16l-16 0c-8.8 0-16-7.2-16-16zM408.2 289.4c4.9 9.1 7.8 19.5 7.8 30.6l0 92.8c39.6-40.4 64-95.7 64-156.8 0-1.7 0-3.5-.1-5.2l-71.7 38.6z", "M401.6 466.6C468.3 420.4 512 343.3 512 256 512 114.6 397.4 0 256 0S0 114.6 0 256c0 87.3 43.7 164.4 110.4 210.6 16.9 27.3 47.2 45.4 81.6 45.4l128 0c34.5 0 64.7-18.2 81.6-45.4zM416 412.8l0-92.8c0-11.1-2.8-21.5-7.8-30.6l71.7-38.6c0 1.7 .1 3.4 .1 5.2 0 61-24.4 116.4-64 156.8zM256 32c110.2 0 201.8 79.5 220.5 184.3l-91.1 49.1c-9.7-6-21.2-9.4-33.4-9.4l-192 0c-12.2 0-23.7 3.4-33.4 9.4L35.5 216.3C54.2 111.5 145.8 32 256 32zM96 320l0 92.8c-39.6-40.4-64-95.7-64-156.8 0-1.7 0-3.5 .1-5.2l71.7 38.6C98.8 298.5 96 308.9 96 320zm32 0c0-17.7 14.3-32 32-32l192 0c17.7 0 32 14.3 32 32l0 96c0 35.3-28.7 64-64 64l-128 0c-35.3 0-64-28.7-64-64l0-96zM288 176c0 8.8 7.2 16 16 16l16 0c17.3 0 34.2 5.6 48 16l6.4 4.8c7.1 5.3 17.1 3.9 22.4-3.2s3.9-17.1-3.2-22.4l-6.4-4.8c-19.4-14.5-43-22.4-67.2-22.4l-16 0c-8.8 0-16 7.2-16 16zm-80-16l-16 0c-24.2 0-47.8 7.9-67.2 22.4l-6.4 4.8c-7.1 5.3-8.5 15.3-3.2 22.4s15.3 8.5 22.4 3.2L144 208c13.8-10.4 30.7-16 48-16l16 0c8.8 0 16-7.2 16-16s-7.2-16-16-16zM184 336c-8.8 0-16 7.2-16 16s7.2 16 16 16l144 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-144 0zm0 64c-8.8 0-16 7.2-16 16s7.2 16 16 16l144 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-144 0z"]],
    "falafel": [576, 512, [129478], "e40a", ["M34.6 352.9c9-10.7 12.3-25 8.8-38.6-1.3-5.2 1.3-10.6 6.2-12.9 12.8-5.7 22-17.2 24.7-30.9 1.1-5.3 5.8-9.1 11.3-8.9 14 .4 27.3-6 35.7-17.1 3.3-4.3 9.2-5.7 14.1-3.2 12.4 6.4 27.2 6.4 39.6 0 4.9-2.5 10.8-1.1 14.1 3.2 8.4 11.2 21.7 17.5 35.7 17.1 5.5-.2 10.2 3.7 11.3 8.9 2.7 13.7 12 25.2 24.7 30.9 3.6 1.6 6 5 6.5 8.8-1.1 6.4-1.3 13.1-.6 19.7-14.1 23.4-14.1 52.9 0 76.3-.2 2.4-.4 4.8-.4 7.1-1.1 2.3-3 4.2-5.5 5.3-12.8 5.7-22 17.2-24.7 30.9-1.1 5.3-5.8 9.1-11.3 8.9-14-.4-27.3 6-35.7 17.1-3.3 4.3-9.2 5.7-14.1 3.2-12.4-6.4-27.2-6.4-39.6 0-4.9 2.5-10.8 1.1-14.1-3.2-8.4-11.1-21.7-17.5-35.7-17.1-5.5 .2-10.2-3.7-11.3-8.9-2.7-13.7-12-25.2-24.7-30.9-5-2.2-7.6-7.7-6.2-12.9 3.5-13.5 .2-27.9-8.8-38.6-3.5-4.1-3.5-10.1 0-14.3zM80 352a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm32 64a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm74.6-271.3c8.8-10.7 12-25 8.6-38.4-1.4-5.5 1.4-10.9 6-13 12.6-5.8 21.6-17.4 24.2-30.9 1.1-5.5 5.7-9 10.6-8.9 13.9 .4 27-6.1 35.3-17.3 3.1-4.3 8.6-5.4 13-3.1 12.3 6.5 27 6.5 39.3 0 4.4-2.3 9.9-1.2 13 3.1 8.2 11.2 21.4 17.7 35.3 17.3 4.9-.1 9.5 3.4 10.6 8.9 2.6 13.6 11.6 25.2 24.2 30.9 4.6 2.1 7.4 7.5 6 13-3.4 13.4-.2 27.7 8.6 38.4 3.5 4.2 3.5 10.4 0 14.5-7.6 9.2-11 21.1-9.6 32.8-19.8-.7-39.3 6.7-53.7 20.9-25.6 3.4-47 20.2-57.1 43.2-3.1-2.9-6.6-5.6-10.3-7.9-9.2-26.8-32.9-46.7-61.6-50.1-9.4-9.5-21-16.1-33.5-19.5-1.4-7-4.5-13.7-9.1-19.3-3.5-4.2-3.5-10.4 0-14.5zm135.6 217c8.5-10.3 11.5-24 8.3-36.9-1.2-4.7 1.2-9.4 5.1-11.2 12.2-5.6 20.8-16.7 23.3-29.8 .9-4.7 4.9-7.7 9-7.6 13.4 .4 26.1-5.9 34-16.6 2.7-3.6 7.4-4.6 11.1-2.7 11.9 6.3 26 6.3 37.8 0 3.7-2 8.4-1 11.1 2.7 7.9 10.8 20.6 17 34 16.6 4.1-.1 8.1 2.8 9 7.6 2.5 13.1 11.2 24.2 23.3 29.8 3.9 1.8 6.3 6.4 5.1 11.2-3.3 12.9-.2 26.7 8.3 36.9 3 3.6 3 8.9 0 12.5-8.5 10.3-11.5 24-8.3 36.9 1.2 4.7-1.2 9.4-5.1 11.2-12.2 5.6-20.8 16.7-23.3 29.8-.9 4.7-4.9 7.7-9 7.6-13.4-.4-26.1 5.9-34 16.6-2.7 3.6-7.4 4.6-11.1 2.7-11.9-6.3-26-6.3-37.8 0-3.7 2-8.4 1-11.1-2.7-7.9-10.8-20.6-17-34-16.6-4.1 .1-8.1-2.8-9-7.6-2.5-13.1-11.2-24.2-23.3-29.8-3.9-1.8-6.3-6.4-5.1-11.2 3.3-12.9 .2-26.7-8.3-36.9-3-3.6-3-8.9 0-12.5zM384 400a16 16 0 1 0 32 0 16 16 0 1 0 -32 0z", "M195.7 178.6c-11.4-3.1-23.5-3.5-35.3-.9-11.7-15.9-11.2-38 1.5-53.4 2.3-2.7 3.1-6.5 2.2-10.1-5.1-20.1 4.7-41.3 23.7-50 3.1-1.4 5.4-4.3 6.1-7.9 4-20.4 21.9-35.3 42.9-34.7 3.3 .1 6.5-1.4 8.6-4.3 12.4-16.8 35.1-22.2 53.7-12.4 3 1.6 6.5 1.6 9.4 0 18.6-9.8 41.3-4.4 53.7 12.4 2.1 2.9 5.3 4.4 8.6 4.3 21-.6 39 14.3 42.9 34.7 .7 3.6 3.1 6.5 6.1 7.9 19 8.7 28.8 29.9 23.7 50-.9 3.6 0 7.4 2.2 10.1 13.2 16 13.2 39.3 0 55.3-2.3 2.7-3.1 6.5-2.2 10.1 .2 1 .5 2 .6 3-4.2 .6-8.4 1.6-12.5 3-6.6-2.2-13.4-3.4-20.2-3.7-1.4-11.7 2-23.6 9.6-32.8 3.5-4.2 3.5-10.4 0-14.5-8.8-10.7-12-25-8.6-38.4 1.4-5.5-1.4-10.9-6-13-12.6-5.8-21.6-17.4-24.2-30.9-1.1-5.5-5.7-9-10.6-8.9-13.9 .4-27-6.1-35.3-17.3-3.1-4.3-8.6-5.4-13-3.1-12.3 6.5-27 6.5-39.3 0-4.4-2.3-9.9-1.2-13 3.1-8.2 11.2-21.4 17.7-35.3 17.3-4.9-.1-9.5 3.4-10.6 8.9-2.6 13.6-11.6 25.2-24.2 30.9-4.6 2.1-7.4 7.5-6 13 3.4 13.4 .2 27.7-8.6 38.4-3.5 4.2-3.5 10.4 0 14.5 4.7 5.6 7.8 12.3 9.1 19.3zm71.5 131.6c-.5-3.7-2.8-7.1-6.5-8.8-12.8-5.7-22-17.2-24.7-30.9-1.1-5.3-5.8-9.1-11.3-8.9-14 .4-27.3-6-35.7-17.1-3.3-4.3-9.2-5.7-14.1-3.2-12.4 6.4-27.2 6.4-39.6 0-4.9-2.5-10.8-1.1-14.1 3.2-8.4 11.2-21.7 17.5-35.7 17.1-5.5-.2-10.2 3.7-11.3 8.9-2.7 13.7-12 25.2-24.7 30.9-5 2.2-7.6 7.7-6.2 12.9 3.5 13.5 .2 27.9-8.8 38.6-3.5 4.1-3.5 10.1 0 14.3 9 10.7 12.3 25 8.8 38.6-1.3 5.2 1.3 10.6 6.2 12.9 12.8 5.7 22 17.2 24.7 30.9 1.1 5.3 5.8 9.1 11.3 8.9 14-.4 27.3 6 35.7 17.1 3.3 4.3 9.2 5.7 14.1 3.2 12.4-6.4 27.2-6.4 39.6 0 4.9 2.5 10.8 1.1 14.1-3.2 8.4-11.1 21.7-17.5 35.7-17.1 5.5 .2 10.2-3.7 11.3-8.9 2.7-13.7 12-25.2 24.7-30.9 2.5-1.1 4.4-3 5.5-5.3-.1 12 2.8 23.7 8.2 34.2l-.7 .3c-3.3 1.5-5.7 4.4-6.4 8-4.1 20.6-22.5 35.2-43.5 34.6-3.6-.1-7.1 1.6-9.2 4.4-12.7 16.8-35.6 22-54.3 12.4-3.2-1.7-7.1-1.7-10.3 0-18.7 9.6-41.6 4.4-54.3-12.4-2.2-2.9-5.6-4.5-9.2-4.4-21 .6-39.4-14-43.5-34.6-.7-3.5-3.1-6.5-6.4-8-19.2-8.6-29.4-29.7-24.2-50.1 .9-3.5 .1-7.1-2.3-9.9-13.6-16.1-13.6-39.6 0-55.6 2.3-2.7 3.2-6.4 2.3-9.9-5.3-20.4 5-41.5 24.2-50.1 3.3-1.5 5.7-4.5 6.4-8 4.1-20.6 22.5-35.2 43.5-34.6 3.6 .1 7.1-1.6 9.2-4.4 12.7-16.8 35.6-22 54.3-12.4 3.2 1.7 7.1 1.7 10.3 0 18.7-9.6 41.6-4.4 54.3 12.4 2.2 2.9 5.6 4.5 9.2 4.4 21-.6 39.4 14 43.5 34.6 .7 3.5 3.1 6.5 6.4 8 2.9 1.3 5.6 2.9 8.1 4.7-7.6 9.7-12.6 21.2-14.6 33.3zM402 259.7c-7.9 10.8-20.6 17-34 16.6-4.1-.1-8.1 2.8-9 7.6-2.5 13.1-11.2 24.2-23.3 29.8-3.9 1.8-6.3 6.4-5.1 11.2 3.3 12.9 .2 26.7-8.3 36.9-3 3.6-3 8.9 0 12.5 8.5 10.3 11.5 24 8.3 36.9-1.2 4.7 1.2 9.4 5.1 11.2 12.2 5.6 20.8 16.7 23.3 29.8 .9 4.7 4.9 7.7 9 7.6 13.4-.4 26.1 5.9 34 16.6 2.7 3.6 7.4 4.6 11.1 2.7 11.9-6.3 26-6.3 37.8 0 3.7 2 8.4 1 11.1-2.7 7.9-10.8 20.6-17 34-16.6 4.1 .1 8.1-2.8 9-7.6 2.5-13.1 11.2-24.2 23.3-29.8 3.9-1.8 6.3-6.4 5.1-11.2-3.3-12.9-.2-26.7 8.3-36.9 3-3.6 3-8.9 0-12.5-8.5-10.3-11.5-24-8.3-36.9 1.2-4.7-1.2-9.4-5.1-11.2-12.2-5.6-20.8-16.7-23.3-29.8-.9-4.7-4.9-7.7-9-7.6-13.4 .4-26.1-5.9-34-16.6-2.7-3.6-7.4-4.6-11.1-2.7-11.9 6.3-26 6.3-37.8 0-3.7-2-8.4-1-11.1 2.7zm26-31c2.5 1.3 5.5 1.3 8 0 17.9-9.4 39.8-4.2 51.8 12 1.8 2.4 4.6 3.7 7.3 3.7 20.2-.6 37.5 13.8 41.4 33.4 .6 3.1 2.6 5.6 5.2 6.8 18.3 8.4 27.7 28.8 22.8 48.1-.8 3.1 0 6.3 1.9 8.7 12.8 15.4 12.8 37.9 0 53.3-1.9 2.3-2.7 5.6-1.9 8.7 4.9 19.4-4.5 39.7-22.8 48.1-2.6 1.2-4.6 3.7-5.2 6.8-3.8 19.6-21.1 34-41.4 33.4-2.8-.1-5.5 1.2-7.3 3.7-12 16.2-33.8 21.4-51.8 12-2.5-1.3-5.5-1.3-8 0-17.9 9.4-39.8 4.2-51.8-12-1.8-2.4-4.6-3.7-7.3-3.7-20.2 .6-37.5-13.8-41.4-33.4-.6-3.1-2.6-5.6-5.2-6.8-18.3-8.4-27.7-28.8-22.8-48.1 .8-3.1 0-6.3-1.9-8.7-12.8-15.4-12.8-37.9 0-53.3 1.9-2.3 2.7-5.6 1.9-8.7-4.9-19.4 4.5-39.7 22.8-48.1 2.6-1.2 4.6-3.7 5.2-6.8 3.8-19.6 21.1-34 41.4-33.4 2.8 .1 5.5-1.2 7.3-3.7 12-16.2 33.8-21.4 51.8-12zM400 384a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM80 352a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm48 48a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"]],
    "tombstone-blank": [448, 512, [129702, "tombstone-alt"], "f721", ["M64 192l0 288 320 0 0-288c0-88.4-71.6-160-160-160S64 103.6 64 192z", "M384 192c0-88.4-71.6-160-160-160S64 103.6 64 192l0 288 320 0 0-288zM32 480l0-288C32 86 118 0 224 0S416 86 416 192l0 288 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L16 512c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0z"]],
    "circle-caret-up": [512, 512, ["caret-circle-up"], "f331", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm96 36.5c0-6.9 2.6-13.6 7.3-18.7L230.8 171c6.5-7 15.6-11 25.2-11s18.7 4 25.2 11l95.5 102.8c4.7 5.1 7.3 11.8 7.3 18.7 0 15.2-12.3 27.5-27.5 27.5l-201 0c-15.2 0-27.5-12.3-27.5-27.5z", "M256 32a224 224 0 1 1 0 448 224 224 0 1 1 0-448zm0 480a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm0-352c-9.6 0-18.7 4-25.2 11L135.3 273.8c-4.7 5.1-7.3 11.8-7.3 18.7 0 15.2 12.3 27.5 27.5 27.5l201 0c15.2 0 27.5-12.3 27.5-27.5 0-6.9-2.6-13.6-7.3-18.7L281.2 171c-6.5-7-15.6-11-25.2-11zm-1.7 32.7c.4-.5 1.1-.7 1.7-.7s1.3 .3 1.7 .7l88.4 95.3-180.3 0 88.4-95.3z"]],
    "lamp-street": [512, 512, [], "e1c5", ["M164.6 313.9c-.3 1.4 0 2.6 1 3.8 1.1 1.3 3 2.3 5.5 2.3l298 0c2.4 0 4.4-1 5.5-2.3 1-1.1 1.3-2.4 1-3.8-17.1-70-80.2-121.9-155.4-121.9S181.6 243.9 164.6 313.9z", "M32 168c0-75.1 60.9-136 136-136 72.7 0 132 57 135.8 128.7-83.1 6.9-151.1 66.7-170.3 145.6-6.2 25.5 14.8 45.7 37.5 45.7l70.6 0c7.4 36.5 39.7 64 78.4 64s71-27.5 78.4-64l70.6 0C491.7 352 512.7 331.8 506.5 306.3 487.2 227.3 419.1 167.4 335.8 160.6 332 71.3 258.3 0 168 0 75.2 0 0 75.2 0 168L0 496c0 8.8 7.2 16 16 16s16-7.2 16-16l0-328zm288 24c75.2 0 138.4 51.9 155.4 121.9 .3 1.4 0 2.6-1 3.8-1.1 1.3-3 2.3-5.5 2.3l-298 0c-2.4 0-4.4-1-5.5-2.3-1-1.1-1.3-2.4-1-3.8 17.1-70 80.2-121.9 155.4-121.9zm0 192c-20.9 0-38.7-13.4-45.3-32l90.5 0c-6.6 18.6-24.4 32-45.3 32z"]],
    "circle-b": [512, 512, [], "e0fd", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm160-80c0-8.8 7.2-16 16-16l56 0c30.9 0 56 25.1 56 56 0 12.1-3.8 23.3-10.4 32.5 15.8 9.9 26.4 27.5 26.4 47.5 0 30.9-25.1 56-56 56l-72 0c-8.8 0-16-7.2-16-16l0-160zm32 16l0 48 40 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-40 0zm0 80l0 48 56 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-56 0z", "M256 32a224 224 0 1 1 0 448 224 224 0 1 1 0-448zm0 480a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM192 176l0 160c0 8.8 7.2 16 16 16l72 0c30.9 0 56-25.1 56-56 0-20-10.5-37.6-26.4-47.5 6.5-9.2 10.4-20.4 10.4-32.5 0-30.9-25.1-56-56-56l-56 0c-8.8 0-16 7.2-16 16zm96 40c0 13.3-10.7 24-24 24l-40 0 0-48 40 0c13.3 0 24 10.7 24 24zM224 320l0-48 56 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-56 0z"]],
    "butterfly": [512, 512, [], "e811", ["M32 74.7l0 89c0 69.5 49.3 127.5 114.8 141 5.8 1.2 10.4 5.4 12.1 11.1s.2 11.7-4 15.9l-29.4 29.5c-8.6 8.6-13.5 20.3-13.5 32.5l.5 6.4c2.1 14.8 11.3 27.9 25 34.7l15.6 7.8 5.4 2.3c5.5 2 11.4 3 17.3 3 21.9 0 41.4-14 48.3-34.8l4.2-12.7 2.8-8.8c5.9-20.6 9-41.9 9-63.4l0-70.8c0-.4-.1-.8-.2-1.2-2.6-106.7-89.9-192.4-197.2-192.4-5.9 0-10.7 4.8-10.7 10.7zM272 261.3l0 67c0 24.5 4 48.9 11.7 72.2l4.2 12.7 1.4 3.8c7.9 18.7 26.3 31 46.8 31l5.9-.3c5.8-.7 11.5-2.4 16.8-5l15.6-7.8 5.6-3.3c10.6-7.3 17.6-18.7 19.4-31.4l.5-6.4c0-10.7-3.7-21-10.4-29.2l-3.1-3.4-29.5-29.5c-4.2-4.2-5.7-10.3-4-15.9s6.3-9.9 12.1-11.1c65.6-13.5 114.8-71.5 114.8-141l0-89-.2-2.2c-.9-4.2-4.1-7.4-8.3-8.3l-2.2-.2C360.4 64 272 152.4 272 261.3z", "M473.7 32.2C495.2 34.4 512 52.6 512 74.7l0 89c0 75.1-47.1 139.1-113.3 164.4l10.4 10.4 5.2 5.7c11.4 13.9 17.7 31.3 17.7 49.4l-.2 5.5c-1.8 25.5-16.1 48.6-38.1 61.6l-4.8 2.6-15.6 7.8c-10.1 5-21 8-32.2 8.6l-4.8 .1c-33.4 0-63.4-20.1-76.3-50.5l-2.3-6.2-1.6-4.7-1.6 4.7c-11.3 33.8-43 56.7-78.7 56.7-11.3 0-22.4-2.3-32.7-6.7l-4.4-2-15.6-7.8c-24.8-12.4-41-36.9-42.9-64.2l-.2-5.5c0-20.7 8.2-40.5 22.8-55.2l10.4-10.4C47 302.8 0 238.8 0 163.7l0-89 .2-4.4C2.4 48.8 20.6 32 42.7 32 139.6 32 222.5 92.2 256 177.2 289.5 92.2 372.4 32 469.3 32l4.4 .2zM42.7 64C36.8 64 32 68.8 32 74.7l0 89c0 69.5 49.3 127.5 114.8 141 5.8 1.2 10.4 5.4 12.1 11.1s.2 11.7-4 15.9l-29.4 29.5c-8.6 8.6-13.5 20.3-13.5 32.5l.5 6.4c2.1 14.8 11.3 27.9 25 34.7l15.6 7.8 5.4 2.3c5.5 2 11.4 3 17.3 3 21.9 0 41.4-14 48.3-34.8l4.2-12.7 2.8-8.8c5.9-20.6 9-41.9 9-63.4l0-70.8c0-.4-.1-.8-.2-1.2-2.6-106.7-89.9-192.4-197.2-192.4zm426.7 0C360.4 64 272 152.4 272 261.3l0 67c0 24.5 4 48.9 11.7 72.2l4.2 12.7 1.4 3.8c7.9 18.7 26.3 31 46.8 31l5.9-.3c5.8-.7 11.5-2.4 16.8-5l15.6-7.8 5.6-3.3c10.6-7.3 17.6-18.7 19.4-31.4l.5-6.4c0-10.7-3.7-21-10.4-29.2l-3.1-3.4-29.5-29.5c-4.2-4.2-5.7-10.3-4-15.9s6.3-9.9 12.1-11.1c65.6-13.5 114.8-71.5 114.8-141l0-89-.2-2.2c-.9-4.2-4.1-7.4-8.3-8.3l-2.2-.2z"]],
    "bacterium": [512, 512, [], "e05a", ["M87.4 311.4c-31.2 31.2-31.2 81.9 0 113.1s81.9 31.2 113.1 0c74.7-74.7 149.3-149.3 224-224 31.2-31.2 31.2-81.9 0-113.1s-81.9-31.2-113.1 0c-74.7 74.7-149.3 149.3-224 224zM184 352a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm80-80a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M368 16c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 20.6c-17.3 5.1-33.6 14.5-47.2 28.2l-4.7 4.7-16.8-16.8c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l16.8 16.8-41.4 41.4-16.8-16.8c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l16.8 16.8c-13.8 13.8-27.6 27.6-41.4 41.4l-16.8-16.8c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l16.8 16.8-41.4 41.4-16.8-16.8c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l16.8 16.8-4.7 4.7c-13.6 13.6-23 29.9-28.2 47.2L16 336c-8.8 0-16 7.2-16 16s7.2 16 16 16l16 0c0 23.6 7.4 47.3 22.3 67.1l-9.6 9.6c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l9.6-9.6c19.4 14.6 42.5 22 65.7 22.3l0 13.3c0 8.8 7.2 16 16 16s16-7.2 16-16l0-17.5c17.8-5 34.6-14.6 48.6-28.6l4.7-4.7 16.8 16.8c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-16.8-16.8 41.4-41.4 16.8 16.8c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-16.8-16.8c13.8-13.8 27.6-27.6 41.4-41.4l16.8 16.8c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-16.8-16.8 41.4-41.4 16.8 16.8c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-16.8-16.8 4.7-4.7c13.6-13.6 23-29.9 28.2-47.2l20.6 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0c0-23.6-7.4-47.3-22.3-67.1l9.6-9.6c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-9.6 9.6C415.3 39.4 391.6 32 368 32l0-16zm56.6 184.6c-74.7 74.7-149.3 149.3-224 224-31.2 31.2-81.9 31.2-113.1 0s-31.2-81.9 0-113.1c74.7-74.7 149.3-149.3 224-224 31.2-31.2 81.9-31.2 113.1 0s31.2 81.9 0 113.1zM184 352a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm56-56a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]],
    "square-7": [448, 512, [], "e25c", ["M32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64C46.3 64 32 78.3 32 96zm128 80c0-8.8 7.2-16 16-16l112 0c5.9 0 11.3 3.2 14.1 8.4s2.5 11.4-.6 16.4l-104 160c-4.8 7.4-14.7 9.5-22.1 4.7s-9.5-14.7-4.7-22.1L258.5 192 176 192c-8.8 0-16-7.2-16-16z", "M64 64C46.3 64 32 78.3 32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm176 64l112 0c5.9 0 11.3 3.2 14.1 8.4s2.5 11.4-.6 16.4l-104 160c-4.8 7.4-14.7 9.5-22.1 4.7s-9.5-14.7-4.7-22.1L258.5 192 176 192c-8.8 0-16-7.2-16-16s7.2-16 16-16z"]],
    "magnifying-glass-arrows-rotate": [512, 512, [], "e65e", ["M16 208l.8 0c8.2-.1 15.1-6.4 15.8-14.7 7.5-90.3 83.1-161.3 175.4-161.3 39.9 0 76.8 13.3 106.3 35.7L279 103c-6.9 6.9-8.9 17.2-5.2 26.2S286.3 144 296 144l93.1 0c7.1 20 10.9 41.6 10.9 64-.7 0-.8 0-.8 0-8.2 .1-15.1 6.4-15.8 14.7-7.4 90.3-83.1 161.3-175.4 161.3-39.9 0-76.8-13.3-106.3-35.7-17.3 17.3-5.5 5.5 35.3-35.3 6.9-6.9 8.9-17.2 5.2-26.2S129.7 272 120 272l-93.1 0C19.8 252 16 230.4 16 208z", "M384 43.3l0 68.7-68.7 0 68.7-68.7zM392 144c13.3 0 24-10.7 24-24l0-96c0-9.7-5.8-18.5-14.8-22.2S381.9 .2 375 7L337.1 44.9C301.7 16.8 256.8 0 208 0 99 0 9.5 83.9 .7 190.7 0 199.5 6.5 207.2 15.3 207.9 15.7 208 16.1 208 16.5 208l.3 0c8.2-.1 15.1-6.4 15.8-14.7 7.5-90.3 83.1-161.3 175.4-161.3 39.9 0 76.8 13.3 106.3 35.7L279 103c-6.9 6.9-8.9 17.2-5.2 26.2S286.3 144 296 144l96 0zM32 372.7l0-68.7 68.7 0-68.7 68.7zM24 272c-13.3 0-24 10.7-24 24l0 96c0 9.7 5.8 18.5 14.8 22.2S34.1 415.8 41 409l96-96c6.9-6.9 8.9-17.2 5.2-26.2S129.7 272 120 272l-96 0zm342 71.3c27.7-32.3 45.6-73.1 49.3-118 .7-8.8-5.8-16.5-14.6-17.3-.4 0-.8 0-1.2-.1l-.3 0c-8.2 .1-15.1 6.4-15.8 14.7-7.4 90.3-83.1 161.3-175.4 161.3-39.9 0-76.8-13.3-106.3-35.7L78.9 371.1c35.5 28.1 80.3 44.9 129.1 44.9 51.7 0 99-18.8 135.3-50L484.7 507.3c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L366 343.3z"]],
    "square-i": [448, 512, [], "e272", ["M32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64C46.3 64 32 78.3 32 96zm112 80c0-8.8 7.2-16 16-16l128 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-48 0 0 128 48 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-128 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l48 0 0-128-48 0c-8.8 0-16-7.2-16-16z", "M64 64C46.3 64 32 78.3 32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm160 64l128 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-48 0 0 128 48 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-128 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l48 0 0-128-48 0c-8.8 0-16-7.2-16-16s7.2-16 16-16z"]],
    "standard-definition": [512, 512, ["rectangle-sd"], "e28a", ["M32 128l0 256c0 17.7 14.3 32 32 32l384 0c17.7 0 32-14.3 32-32l0-256c0-17.7-14.3-32-32-32L64 96c-17.7 0-32 14.3-32 32zm64 83.8c0-28.6 23.2-51.8 51.8-51.8l68.2 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-68.2 0c-11 0-19.8 8.9-19.8 19.8l0 8.3c0 11 8.9 19.8 19.8 19.8l40.3 0c28.6 0 51.8 23.2 51.8 51.8l0 8.3c0 28.6-23.2 51.8-51.8 51.8L120 352c-8.8 0-16-7.2-16-16s7.2-16 16-16l68.2 0c11 0 19.8-8.9 19.8-19.8l0-8.3c0-11-8.9-19.8-19.8-19.8l-40.3 0C119.2 272 96 248.8 96 220.2l0-8.3zM272 176c0-8.8 7.2-16 16-16l56 0c39.8 0 72 32.2 72 72l0 48c0 39.8-32.2 72-72 72l-56 0c-8.8 0-16-7.2-16-16l0-160zm32 16l0 128 40 0c22.1 0 40-17.9 40-40l0-48c0-22.1-17.9-40-40-40l-40 0z", "M448 96c17.7 0 32 14.3 32 32l0 256c0 17.7-14.3 32-32 32L64 416c-17.7 0-32-14.3-32-32l0-256c0-17.7 14.3-32 32-32l384 0zM64 64C28.7 64 0 92.7 0 128L0 384c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L64 64zM96 211.8l0 8.3c0 28.6 23.2 51.8 51.8 51.8l40.3 0c11 0 19.8 8.9 19.8 19.8l0 8.3c0 11-8.9 19.8-19.8 19.8L120 320c-8.8 0-16 7.2-16 16s7.2 16 16 16l68.2 0c28.6 0 51.8-23.2 51.8-51.8l0-8.3c0-28.6-23.2-51.8-51.8-51.8l-40.3 0c-11 0-19.8-8.9-19.8-19.8l0-8.3c0-11 8.9-19.8 19.8-19.8l68.2 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-68.2 0C119.2 160 96 183.2 96 211.8zM288 160c-8.8 0-16 7.2-16 16l0 160c0 8.8 7.2 16 16 16l56 0c39.8 0 72-32.2 72-72l0-48c0-39.8-32.2-72-72-72l-56 0zm16 160l0-128 40 0c22.1 0 40 17.9 40 40l0 48c0 22.1-17.9 40-40 40l-40 0z"]],
    "alien-8bit": [576, 512, [128126, "alien-monster"], "f8f6", ["M32 144l0 144 48 0c8.8 0 16 7.2 16 16l0 48 384 0 0-48c0-8.8 7.2-16 16-16l48 0 0-144-32 0 0 96c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-48-80 0c-8.8 0-16-7.2-16-16l0-80-32 0 0 48c0 8.8-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16l0-48-32 0 0 80c0 8.8-7.2 16-16 16l-80 0 0 48c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-96-32 0zm96-80l0 32 32 0 0-32-32 0zm32 320l0 64 80 0 0-32-32 0c-8.8 0-16-7.2-16-16l0-16-32 0zm32-144c0-8.8 7.2-16 16-16s16 7.2 16 16l0 64c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-64zM336 416l0 32 80 0 0-64-32 0 0 16c0 8.8-7.2 16-16 16l-32 0zm16-176c0-8.8 7.2-16 16-16s16 7.2 16 16l0 64c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-64zM416 64l0 32 32 0 0-32-32 0z", "M128 32c-17.7 0-32 14.3-32 32l0 32c0 17.7 14.3 32 32 32l32 0 0 32-64 0 0-16c0-17.7-14.3-32-32-32l-32 0c-17.7 0-32 14.3-32 32L0 288c0 17.7 14.3 32 32 32l32 0 0 32c0 17.7 14.3 32 32 32l32 0 0 64c0 17.7 14.3 32 32 32l80 0c17.7 0 32-14.3 32-32l0-32c0-17.7-14.3-32-32-32l96 0c-17.7 0-32 14.3-32 32l0 32c0 17.7 14.3 32 32 32l80 0c17.7 0 32-14.3 32-32l0-64 32 0c17.7 0 32-14.3 32-32l0-32 32 0c17.7 0 32-14.3 32-32l0-144c0-17.7-14.3-32-32-32l-32 0c-17.7 0-32 14.3-32 32l0 16-64 0 0-32 32 0c17.7 0 32-14.3 32-32l0-32c0-17.7-14.3-32-32-32l-32 0c-17.7 0-32 14.3-32 32l-32 0c-17.7 0-32 14.3-32 32l0 32-64 0 0-32c0-17.7-14.3-32-32-32l-32 0c0-17.7-14.3-32-32-32l-32 0zM480 192l0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-96 32 0 0 144-48 0c-8.8 0-16 7.2-16 16l0 48-384 0 0-48c0-8.8-7.2-16-16-16l-48 0 0-144 32 0 0 96c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48 80 0c8.8 0 16-7.2 16-16l0-80 32 0 0 48c0 8.8 7.2 16 16 16l96 0c8.8 0 16-7.2 16-16l0-48 32 0 0 80c0 8.8 7.2 16 16 16l80 0zM128 96l0-32 32 0 0 32-32 0zm320 0l-32 0 0-32 32 0 0 32zM160 448l0-64 32 0 0 16c0 8.8 7.2 16 16 16l32 0 0 32-80 0zm224-48l0-16 32 0 0 64-80 0 0-32 32 0c8.8 0 16-7.2 16-16zM224 240c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16s16-7.2 16-16l0-64zm160 0c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16s16-7.2 16-16l0-64z"]],
    "vacuum": [640, 512, [], "e04d", ["M33.7 480l6.7-20.2c8.7-26.1 33.2-43.8 60.7-43.8l42.5 0c.2 0 .4 0 .6 0l15.7 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L33.7 480zM448 416a64 64 0 1 1 -128 0 64 64 0 1 1 128 0zm-88 0a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm24-224c0-17.7 14.3-32 32-32 88.4 0 160 71.6 160 160l0 128c0 17.7-14.3 32-32 32l-49.1 0c10.9-18.8 17.1-40.7 17.1-64 0-70.7-57.3-128-128-128l0-96z", "M302.1 0C249 0 203.2 37.2 192.4 89.2L131 384 101.2 384c-41.3 0-78 26.4-91.1 65.6L2.5 472.6C.8 477.5 0 482.6 0 487.8 0 501.2 10.8 512 24.2 512L160 512c35.3 0 64-28.7 64-64 0-34.1-26.7-62-60.3-63.9L223.7 95.7C231.5 58.6 264.2 32 302.1 32L528 32c44.2 0 80 35.8 80 80 0 34.8-22.2 64.4-53.2 75.4-35-36.6-84.2-59.4-138.8-59.4-35.3 0-64 28.7-64 64l0 100c10.2-2.6 21-4 32-4l0-96c0-17.7 14.3-32 32-32 88.4 0 160 71.6 160 160l0 128c0 17.7-14.3 32-32 32l-49.1 0c-7 12-15.8 22.8-26.2 32l75.3 0c35.3 0 64-28.7 64-64l0-128c0-39.5-11.9-76.1-32.3-106.6 38-17.9 64.3-56.6 64.3-101.4 0-61.9-50.1-112-112-112L302.1 0zM143.7 416c.2 0 .4 0 .6 0l15.7 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-126.3 0 6.7-20.2c8.7-26.1 33.2-43.8 60.7-43.8l42.5 0zM384 352a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm0 160a96 96 0 1 0 0-192 96 96 0 1 0 0 192zm24-96a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"]],
    "bowl-chopsticks-noodles": [512, 512, [], "e2ea", ["M34.9 272.9l.6 10.3c4.2 72.1 47.8 133 109.3 162.2 7.7 3.7 13.7 10.3 16.5 18.4 3.3 9.4 12.2 16.1 22.7 16.1l144 0c10.4 0 19.4-6.7 22.7-16.1 2.8-8.1 8.7-14.7 16.5-18.4 61.4-29.2 105-90.1 109.3-162.2l.6-10.3c.5-9.2-6.8-16.9-16-16.9L50.9 256c-9.2 0-16.5 7.8-16 16.9z", "M96 79.7L12.9 96.3C4.2 98-1.4 106.5 .3 115.1s10.2 14.3 18.8 12.6l76.9-15.4 0 42.3-81.1 5.4c-8.8 .6-15.5 8.2-14.9 17s8.2 15.5 17 14.9l78.9-5.3 0 37.3-45.1 0C23.3 224 1.4 247.2 3 274.8l.6 10.3c4.9 84.1 55.9 155.1 127.5 189.2 7.6 21.9 28.4 37.6 52.9 37.6l144 0c24.5 0 45.3-15.7 52.9-37.6 71.6-34.1 122.5-105.1 127.5-189.2l.6-10.3c1.6-27.6-20.3-50.8-47.9-50.8L208 224 208 32c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 192-48 0 0-176c0-8.8-7.2-16-16-16S96 39.2 96 48l0 31.7zM256 144L256 176 497.1 160c8.8-.6 15.5-8.2 14.9-17s-8.2-15.5-17-14.9L256 144zm0-96.3l0 32.6 243.1-48.6c8.7-1.7 14.3-10.2 12.6-18.8S501.5-1.4 492.9 .3L256 47.7zM144.8 445.5c-61.4-29.2-105-90.1-109.3-162.2l-.6-10.3c-.5-9.2 6.8-16.9 16-16.9l410.2 0c9.2 0 16.5 7.8 16 16.9l-.6 10.3c-4.2 72.1-47.8 133-109.3 162.2-7.7 3.7-13.7 10.3-16.5 18.4-3.3 9.4-12.2 16.1-22.7 16.1l-144 0c-10.4 0-19.4-6.7-22.7-16.1-2.8-8.1-8.7-14.7-16.5-18.4z"]],
    "record-vinyl": [512, 512, [], "f8d9", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm352 0a128 128 0 1 1 -256 0 128 128 0 1 1 256 0z", "M256 32a224 224 0 1 1 0 448 224 224 0 1 1 0-448zm0 480a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM384 256a128 128 0 1 0 -256 0 128 128 0 1 0 256 0zM256 160a96 96 0 1 1 0 192 96 96 0 1 1 0-192zm0 120a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]],
    "floppy-disk": [448, 512, [128190, 128426, "save"], "f0c7", ["M32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-242.7c0-8.5-3.4-16.6-9.4-22.6L329.4 73.4c-2.7-2.7-5.9-4.9-9.4-6.5L320 176c0 17.7-14.3 32-32 32l-160 0c-17.7 0-32-14.3-32-32l0-112-32 0C46.3 64 32 78.3 32 96zM288 320a64 64 0 1 1 -128 0 64 64 0 1 1 128 0z", "M64 64C46.3 64 32 78.3 32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-242.7c0-8.5-3.4-16.6-9.4-22.6L329.4 73.4c-2.7-2.7-5.9-4.9-9.4-6.5L320 176c0 17.7-14.3 32-32 32l-160 0c-17.7 0-32-14.3-32-32l0-112-32 0zm64 0l0 112 160 0 0-112-160 0zM0 96C0 60.7 28.7 32 64 32l242.7 0c17 0 33.3 6.7 45.3 18.7L429.3 128c12 12 18.7 28.3 18.7 45.3L448 416c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM256 320a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm-96 0a64 64 0 1 1 128 0 64 64 0 1 1 -128 0z"]],
    "down-left": [448, 512, [], "e16a", ["M64.2 150.6l0 265.4 265.4 0-84.7-84.7c-6.2-6.2-6.2-16.4 0-22.6L398.3 155.3c6.2-6.2 6.2-16.4 0-22.6L347.6 81.9c-6.2-6.2-16.4-6.2-22.6 0L171.6 235.3c-6.2 6.2-16.4 6.2-22.6 0L64.2 150.6z", "M64.2 416l0-265.4 84.7 84.7c6.2 6.2 16.4 6.2 22.6 0L324.9 81.9c6.2-6.2 16.4-6.2 22.6 0l50.7 50.7c6.2 6.2 6.2 16.4 0 22.6L244.9 308.7c-6.2 6.2-6.2 16.4 0 22.6l84.7 84.7-265.4 0zm-32 8c0 13.3 10.7 24 24 24l273.4 0c28.5 0 42.8-34.5 22.6-54.6L278.9 320 420.9 177.9c18.7-18.7 18.7-49.1 0-67.9L370.2 59.3c-18.7-18.7-49.1-18.7-67.9 0L160.2 201.4 86.9 128c-20.2-20.2-54.6-5.9-54.6 22.6l0 273.4z"]],
    "toilets-portable": [576, 512, [], "e584", ["M64 64l0 32 160 0 0-32c0-17.7-14.3-32-32-32L96 32C78.3 32 64 46.3 64 64zm0 64l0 320 160 0 0-112-24 0c-22.1 0-40-17.9-40-40l0-48c0-22.1 17.9-40 40-40l24 0 0-80-160 0zM352 64l0 32 168 0 0-32c0-17.7-14.3-32-32-32L384 32c-17.7 0-32 14.3-32 32zm0 64l0 320 168 0 0-112-24 0c-22.1 0-40-17.9-40-40l0-48c0-22.1 17.9-40 40-40l24 0 0-80-168 0z", "M96 32l96 0c17.7 0 32 14.3 32 32l0 32-160 0 0-32c0-17.7 14.3-32 32-32zM32 96l0 400c0 8.8 7.2 16 16 16s16-7.2 16-16l0-16 160 0 0 16c0 8.8 7.2 16 16 16s16-7.2 16-16l0-432c0-35.3-28.7-64-64-64L96 0C60.7 0 32 28.7 32 64l0 32zm192 32l0 80-24 0c-22.1 0-40 17.9-40 40l0 48c0 22.1 17.9 40 40 40l24 0 0 112-160 0 0-320 160 0zm0 112l0 64-24 0c-4.4 0-8-3.6-8-8l0-48c0-4.4 3.6-8 8-8l24 0zM384 32l104 0c17.7 0 32 14.3 32 32l0 32-168 0 0-32c0-17.7 14.3-32 32-32zM352 448l0-320 168 0 0 80-24 0c-22.1 0-40 17.9-40 40l0 48c0 22.1 17.9 40 40 40l24 0 0 112-168 0zM552 208l0-144c0-35.3-28.7-64-64-64L384 0c-35.3 0-64 28.7-64 64l0 432c0 8.8 7.2 16 16 16s16-7.2 16-16l0-16 168 0 0 16c0 8.8 7.2 16 16 16s16-7.2 16-16l0-288zm-32 32l0 64-24 0c-4.4 0-8-3.6-8-8l0-48c0-4.4 3.6-8 8-8l24 0z"]],
    "o": [448, 512, [111], "4f", ["", "M224 64a192 192 0 1 0 0 384 192 192 0 1 0 0-384zM448 256a224 224 0 1 1 -448 0 224 224 0 1 1 448 0z"]],
    "palette": [512, 512, [127912], "f53f", ["M32 256c0 123.7 100.3 224 224 224 3.1 0 6.2-.1 9.3-.2 10.4-.4 22.7-10.7 22.7-30 0-5.3-1.9-11.8-6.9-23.5-.6-1.5-1.3-3.1-2.1-4.8-4.3-9.7-10.3-23.2-13.2-37-1.1-5.4-1.7-10.9-1.7-16.6 0-44.2 35.8-80 80-80l97.9 0c24.3 0 37.9-15.6 38.1-29.7 0-.8 0-1.6 0-2.3 0-123.7-100.3-224-224-224S32 132.3 32 256zm120 0a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm32-96a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm96-32a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm96 32a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M480 258.3c-.1 14.1-13.8 29.7-38.1 29.7L344 288c-44.2 0-80 35.8-80 80 0 5.6 .6 11.2 1.7 16.6 2.9 13.8 8.9 27.3 13.2 37 .8 1.7 1.5 3.3 2.1 4.8 5 11.6 6.9 18.2 6.9 23.5 0 19.2-12.3 29.6-22.7 30-3.1 .1-6.2 .2-9.3 .2-123.7 0-224-100.3-224-224S132.3 32 256 32 480 132.3 480 256c0 .8 0 1.6 0 2.3zm32 .3c0-.9 0-1.8 0-2.7 0-141.4-114.6-256-256-256S0 114.6 0 256 114.6 512 256 512c3.5 0 7.1-.1 10.6-.2 31.8-1.3 53.4-30.1 53.4-62 0-14.5-6.1-28.3-12.1-42-4.3-9.8-8.7-19.7-10.8-29.9-.7-3.2-1-6.5-1-9.9 0-26.5 21.5-48 48-48l97.9 0c36.5 0 69.7-24.8 70.1-61.3zM152 256a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm8-72a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm120-56a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm72 56a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]],
    "paintbrush-fine-slash": [576, 512, [], "e74d", ["M290.6 236L484.4 42.2c6.5-6.5 15.4-10.2 24.7-10.2 19.3 0 34.9 15.6 34.9 34.9 0 9.3-3.7 18.1-10.2 24.7L340 285.4 290.6 236z", "M27.3-27.2c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l544 544c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L362.6 308 556.4 114.2C569 101.7 576 84.7 576 66.9 576 30 546 0 509.1 0 491.3 0 474.3 7 461.8 19.6L268 213.4 27.3-27.2zM290.6 236L484.4 42.2c6.5-6.5 15.4-10.2 24.7-10.2 19.3 0 34.9 15.6 34.9 34.9 0 9.3-3.7 18.1-10.2 24.7L340 285.4 290.6 236zM64 384c0 15.5 2.8 30.4 7.8 44.2 7.6 20.8-5.8 51.8-28 51.8L16 480c-8.8 0-16 7.2-16 16s7.2 16 16 16l176 0c67.3 0 122.4-51.9 127.6-117.9l-34.8-34.8c2.1 7.9 3.2 16.2 3.2 24.7 0 53-43 96-96 96l-96.4 0c.7-1.3 1.4-2.6 2.1-3.8 8.3-16.7 11.7-38.9 4.2-59-3.8-10.3-5.9-21.4-5.9-33.1 0-53 43-96 96-96 8.5 0 16.8 1.1 24.7 3.2l-34.8-34.8C115.9 261.6 64 316.7 64 384z"]],
    "blueberries": [512, 512, [], "e2e8", ["M32 336a144 144 0 1 0 288 0 144 144 0 1 0 -288 0zm64-48c0-8.8 7.2-16 16-16l32 0 0-32c0-8.8 7.2-16 16-16s16 7.2 16 16l0 32 32 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-32 0 0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-32-32 0c-8.8 0-16-7.2-16-16zM199.7 129.3c95.9 10.9 172 87 182.9 182.9 56.6-19.4 97.3-73.1 97.3-136.3 0-79.5-64.5-144-144-144-63.2 0-116.9 40.7-136.3 97.3zM288 128c0-8.8 7.2-16 16-16l32 0 0-32c0-8.8 7.2-16 16-16s16 7.2 16 16l0 32 32 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-32 0 0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-32-32 0c-8.8 0-16-7.2-16-16z", "M382.7 312.3c56.6-19.4 97.3-73.1 97.3-136.3 0-79.5-64.5-144-144-144-63.2 0-116.9 40.7-136.3 97.3-7.8-.9-15.7-1.3-23.7-1.3-3.2 0-6.3 .1-9.4 .2 20.8-74 88.8-128.2 169.4-128.2 97.2 0 176 78.8 176 176 0 80.6-54.2 148.6-128.2 169.4 .1-3.1 .2-6.3 .2-9.4 0-8-.5-15.9-1.3-23.7zM320 336a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zM0 336a176 176 0 1 1 352 0 176 176 0 1 1 -352 0zm176-96l0 32 32 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-32 0 0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-32-32 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l32 0 0-32c0-8.8 7.2-16 16-16s16 7.2 16 16zM368 80l0 32 32 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-32 0 0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-32-32 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l32 0 0-32c0-8.8 7.2-16 16-16s16 7.2 16 16z"]],
    "fish-bones": [576, 512, [], "e304", ["M560.2 256.5C532 183 457.8 136.1 431.6 122.7l0 269.9c26.6-13.8 107.7-72.2 128.6-136.1zM96 359.6l0-207.9-64.2-38.2c-6.3-3.8-14 2.3-11.7 9.3L62.3 254.3 18.8 391c-2.3 7.1 5.5 13.1 11.8 9.2L96 359.6z", "M42.4 141.5l27.3 22.8c6.8 5.7 16.9 4.7 22.5-2s4.7-16.9-2-22.5L44.8 101.8c-4.5-3.8-10.2-5.8-16.1-5.8-17.1 0-29.3 16.7-24 33L46 256 4.7 383c-5.3 16.3 6.8 33 24 33 5.9 0 11.6-2.1 16.1-5.8l0 0 45.4-37.9c6.8-5.7 7.7-15.7 2-22.5s-15.7-7.7-22.5-2l-27.3 22.8 32-98.5 69.5 0 0 80c0 8.8 7.2 16 16 16s16-7.2 16-16l0-80 64 0 0 80c0 8.8 7.2 16 16 16s16-7.2 16-16l0-80 64 0 0 80c0 8.8 7.2 16 16 16s16-7.2 16-16l0-80 48 0 0 120.9c0 11.3 11.4 19 21.4 13.8 20.1-10.3 38.2-22.9 54-36.3 39.1-33 66.9-72.4 81-99.8 4.7-9.2 4.7-20.1 0-29.3-14.1-27.4-41.9-66.8-81-99.8-15.8-13.4-33.9-26-54-36.3-10.1-5.1-21.4 2.5-21.4 13.8l0 120.9-48 0 0-80c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 80-64 0 0-80c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 80-64 0 0-80c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 80-69.5 0-32-98.5zM447.7 259.2c.2-1 .3-2.1 .3-3.2s-.1-2.2-.3-3.2l0-104.7c8.2 5.6 16 11.5 23.4 17.7 35.6 30 60.9 66.1 73.2 90.1 0 .1 0 .2 0 .3-12.4 24-37.7 60.1-73.2 90.1-7.3 6.2-15.1 12.1-23.4 17.7l0-104.7z"]],
    "unlock": [384, 512, [128275], "f09c", ["M32 224c0-17.7 14.3-32 32-32l256 0c17.7 0 32 14.3 32 32l0 224c0 17.7-14.3 32-32 32L64 480c-17.7 0-32-14.3-32-32l0-224z", "M96 96c0-53 43-96 96-96s96 43 96 96c0 8.8 7.2 16 16 16s16-7.2 16-16c0-70.7-57.3-128-128-128S64 25.3 64 96l0 64c-35.3 0-64 28.7-64 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-224c0-35.3-28.7-64-64-64l-224 0 0-64zM32 224c0-17.7 14.3-32 32-32l256 0c17.7 0 32 14.3 32 32l0 224c0 17.7-14.3 32-32 32L64 480c-17.7 0-32-14.3-32-32l0-224z"]],
    "fan-table": [448, 512, [], "e004", ["M32 224a192 192 0 1 0 384 0 192 192 0 1 0 -384 0zm71.6-20.4c-19.9-49.2 3.9-105.1 53-125 20.5-8.3 43.8 1.6 52.1 22.1L228.6 150c19.9-15.9 46-23.9 73.3-20 52.5 7.4 89.1 55.9 81.7 108.4-3.1 21.9-23.3 37.1-45.2 34L285.8 265c3.8 25.2-2.3 51.8-19.3 73.5-32.6 41.8-93 49.2-134.8 16.5-17.4-13.6-20.5-38.7-6.9-56.1L157.6 257c-23.7-9.3-43.7-27.9-54-53.4z", "M416 224a192 192 0 1 0 -384 0 192 192 0 1 0 384 0zm32 0c0 118.3-91.8 215.2-208 223.4l0 32.6 128 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L80 512c-8.8 0-16-7.2-16-16s7.2-16 16-16l128 0 0-32.6C91.8 439.2 0 342.3 0 224 0 100.3 100.3 0 224 0S448 100.3 448 224zM224 208a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm-55.4-99.7c-32.8 13.2-48.6 50.5-35.4 83.3 9.3 23 30.4 37.7 53.6 39.8 5.8 .5 10.9 4.2 13.2 9.6s1.5 11.6-2.1 16.2l-47.9 61.4c-2.7 3.5-2.1 8.5 1.4 11.2 27.9 21.8 68.1 16.8 89.8-11 15.3-19.5 17.4-45.2 7.6-66.3-2.5-5.3-1.8-11.6 1.7-16.3s9.3-7.1 15.1-6.3l77.1 10.8c4.4 .6 8.4-2.4 9-6.8 4.9-35-19.5-67.4-54.5-72.3-24.6-3.5-47.9 7.5-61.3 26.5-3.4 4.8-9.1 7.3-14.9 6.7s-10.8-4.5-13-9.9L179 112.7c-1.7-4.1-6.3-6.1-10.4-4.4zm60 41.6c19.9-15.9 46-23.9 73.3-20 52.5 7.4 89.1 55.9 81.7 108.4-3.1 21.9-23.3 37.1-45.2 34L285.8 265c3.8 25.2-2.3 51.8-19.3 73.5-32.6 41.8-93 49.2-134.8 16.5-17.4-13.6-20.5-38.7-6.9-56.1L157.6 257c-23.7-9.3-43.7-27.9-54-53.4-19.9-49.2 3.9-105.1 53-125 20.5-8.3 43.8 1.6 52.1 22.1L228.6 150z"]],
    "ear-listen": [512, 512, ["assistive-listening-systems"], "f2a2", ["M87.2 254.3c5.2-2.6 8.8-8 8.8-14.3 0-79.5 64.5-144 144-144s144 64.5 144 144c0 41.9-17.9 79.7-46.5 106-10.1 9.2-17.5 22.6-17.5 38 0 53-43 96-96 96l-16 0c-2.6 0-5 .6-7.2 1.7l-36.9-73.8c29.1-2 52.1-26.3 52.1-55.9 0-30.9-25.1-56-56-56-16.9 0-32.1 7.5-42.3 19.3l-30.5-61zM128 240c0 8.8 7.2 16 16 16s16-7.2 16-16c0-44.2 35.8-80 80-80s80 35.8 80 80c0 8.8 7.2 16 16 16s16-7.2 16-16c0-61.9-50.1-112-112-112S128 178.1 128 240z", "M350 8.2c-4.3 7.7-1.5 17.5 6.2 21.8 73.8 41 123.7 119.7 123.7 210 0 8.8 7.2 16 16 16s16-7.2 16-16c0-102.4-56.6-191.6-140.2-238-7.7-4.3-17.5-1.5-21.8 6.2zM96 240c0-79.5 64.5-144 144-144s144 64.5 144 144c0 41.9-17.9 79.7-46.5 106-10.1 9.2-17.5 22.6-17.5 38 0 53-43 96-96 96l-16 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l16 0c70.7 0 128-57.3 128-128 0-4.8 2.4-10.1 7.1-14.4 34.9-32.1 56.9-78.3 56.9-129.6 0-97.2-78.8-176-176-176S64 142.8 64 240c0 8.8 7.2 16 16 16s16-7.2 16-16zm64 136a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM32 504a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM52.7 372.7c-6.2 6.2-6.2 16.4 0 22.6l64 64c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-64-64c-6.2-6.2-16.4-6.2-22.6 0zM160 240c0-44.2 35.8-80 80-80s80 35.8 80 80c0 8.8 7.2 16 16 16s16-7.2 16-16c0-61.9-50.1-112-112-112S128 178.1 128 240c0 8.8 7.2 16 16 16s16-7.2 16-16z"]],
    "code-pull-request": [512, 512, [], "e13c", ["M48 80a48 48 0 1 0 96 0 48 48 0 1 0 -96 0zm0 352a48 48 0 1 0 96 0 48 48 0 1 0 -96 0zm320 0a48 48 0 1 0 96 0 48 48 0 1 0 -96 0z", "M315.3 27.3c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-64 64c-6.2 6.2-6.2 16.4 0 22.6l64 64c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L278.6 96 352 96c26.5 0 48 21.5 48 48l0 209.6c-36.5 7.4-64 39.7-64 78.4 0 44.2 35.8 80 80 80s80-35.8 80-80c0-38.7-27.5-71-64-78.4L432 144c0-44.2-35.8-80-80-80l-73.4 0 36.7-36.7zM48 80a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm64 78.4c36.5-7.4 64-39.7 64-78.4 0-44.2-35.8-80-80-80S16 35.8 16 80c0 38.7 27.5 71 64 78.4l0 195.2c-36.5 7.4-64 39.7-64 78.4 0 44.2 35.8 80 80 80s80-35.8 80-80c0-38.7-27.5-71-64-78.4l0-195.2zM48 432a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm368-48a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"]],
    "thumbtack-angle": [512, 512, [], "e751", ["M73.9 228.4L283.6 438.1c3.6 3.6 9.6 3 12.4-1.3l3.2-4.9c20.8-31.9 28.3-69.2 23.1-104.9l-1-7.2c-.7-4.6 .7-9.2 3.7-12.7L433.7 180.9 331.1 78.3 204.9 187.1c-3.5 3-8.2 4.4-12.7 3.7l-7.2-1c-35.6-5.2-72.9 2.3-104.9 23.1L75.2 216c-4.3 2.8-4.9 8.8-1.3 12.4z", "M484.7 231.4l-28.1-28.1-102.7 119.2c6.2 43.1-2.8 88.3-28 126.9l-3.2 4.9c-13.9 21.3-43.8 24.4-61.8 6.4L51.3 251c-18-18-14.8-47.9 6.4-61.8l4.8-3.2c38.6-25.2 83.8-34.2 126.9-28L308.6 55.4 280.6 27.3c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0L507.3 208.8c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0zM331.1 78.3L204.9 187.1c-3.5 3-8.2 4.4-12.7 3.7l-7.2-1c-35.6-5.2-72.9 2.3-104.9 23.1L75.2 216c-4.3 2.8-4.9 8.8-1.3 12.4L283.6 438.1c3.6 3.6 9.6 3 12.4-1.3l3.2-4.9c20.8-31.9 28.3-69.2 23.1-104.9l-1-7.2c-.7-4.6 .7-9.2 3.7-12.7L433.7 180.9 331.1 78.3zM110.9 378.5l22.6 22.6-106.2 106.2c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6L110.9 378.5z"]],
    "key": [512, 512, [128273], "f084", ["M32 398.6l0 81.4 96 0 0-48c0-8.8 7.2-16 16-16l48 0 0-48c0-8.8 7.2-16 16-16l49.4 0 31.4-31.4c3.9-3.9 9.5-5.5 14.9-4.3 10.4 2.4 21.2 3.6 32.4 3.6 79.5 0 144-64.5 144-144S415.5 32 336 32 192 96.5 192 176c0 15.2 2.4 29.9 6.7 43.7 1.8 5.7 .3 11.9-3.9 16.2L32 398.6zM392 144a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M192 176c0-79.5 64.5-144 144-144s144 64.5 144 144-64.5 144-144 144c-11.1 0-22-1.3-32.4-3.6-5.4-1.2-11 .4-14.9 4.3L257.4 352 208 352c-8.8 0-16 7.2-16 16l0 48-48 0c-8.8 0-16 7.2-16 16l0 48-96 0 0-81.4 162.8-162.8c4.2-4.2 5.7-10.5 3.9-16.2-4.4-13.8-6.7-28.4-6.7-43.7zM336 0c-97.2 0-176 78.8-176 176 0 15.1 1.9 29.8 5.5 43.9L4.7 380.7c-3 3-4.7 7.1-4.7 11.3L0 496c0 8.8 7.2 16 16 16l128 0c8.8 0 16-7.2 16-16l0-48 48 0c8.8 0 16-7.2 16-16l0-48 40 0c4.2 0 8.3-1.7 11.3-4.7l30-30c10 1.8 20.2 2.7 30.7 2.7 97.2 0 176-78.8 176-176S433.2 0 336 0zm32 168a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]],
    "snake": [512, 512, [128013], "f716", ["M96.4 415.8L21.4 448.5c-6.4 2.8-6.4 11.9 0 14.7l74.9 32.2 247.3 0c66.3 0 120.1-53.8 120.1-120.1S410 255.2 343.7 255.2l-167.4 0c-26.5 0-48-21.5-48-48l0-7.3c0-26.5 21.5-48 48-48l106.5 0 2.1 3.7c25.2 43.8 80.1 60.5 125.5 38.3l50.3-24.7c21.5-10.5 35.1-32.4 35.1-56.3 0-24.8-14.7-47.3-37.4-57.4L405 31.9c-43.3-19.1-94.1-3.8-119.6 36l-2.6 4-105.8 0C106.3 72 49 129.3 49 200l0 7.5c0 70.7 57.3 128 128 128l167.7 0c22.2 0 40.1 18 40.1 40.1s-18 40.1-40.1 40.1l-248.4 0z", "M293.9 88L180 88C115.9 88 64 139.9 64 204s51.9 116 116 116l164 0c30.9 0 56 25.1 56 56s-25.1 56-56 56l-228.8 0c-8.4 0-16.8 1.7-24.6 4.9L44.8 456 90.6 475.1c7.8 3.3 16.2 4.9 24.6 4.9L344 480c57.4 0 104-46.6 104-104S401.4 272 344 272l-164 0c-37.6 0-68-30.4-68-68s30.4-68 68-68l109.1 0 9.5 14.2c14.1 21.1 37.7 33.8 63.1 33.8l4.5 0c12.3 0 24.5-2.7 35.6-7.9L455 151.3c15.3-7.1 25-22.5 25-39.3s-9.8-32.2-25-39.3L400.5 47.3c-10.3-4.8-21.5-7.3-32.9-7.3-25.8 0-49.9 12.8-64.2 34l-9.5 14zM176 512l-60.8 0c-12.7 0-25.2-2.5-36.9-7.4L14.8 478.2C5.8 474.4 0 465.7 0 456s5.8-18.4 14.8-22.2l63.5-26.5c11.7-4.9 24.2-7.4 36.9-7.4L344 400c13.3 0 24-10.7 24-24s-10.7-24-24-24l-164 0C98.3 352 32 285.7 32 204S98.3 56 180 56l97 0c20.3-29.9 54.2-48 90.7-48 16 0 31.9 3.5 46.4 10.3l54.4 25.4C495 56.1 512 82.7 512 112s-17 55.9-43.5 68.3l-53.1 24.8c-8.7 4-17.8 7-27.1 8.8-7.2 1.4-14.6 2.1-22 2.1l-4.5 0c-6 0-11.9-.5-17.7-1.5-8-1.3-15.7-3.5-23.1-6.5-19.7-8-36.8-21.8-48.9-40l-92 0c-19.9 0-36 16.1-36 36s16.1 36 36 36l164 0c6 0 11.9 .4 17.7 1.1 1.5 .2 3 .4 4.5 .7 6.8 1.1 13.5 2.8 19.9 4.8 54.5 17.7 93.9 68.9 93.9 129.3 0 75.1-60.9 136-136 136l-168 0zM352 80a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm16 48a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"]],
    "circle-waveform-lines": [512, 512, ["waveform-circle"], "e12d", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm96-40c0-8.8 7.2-16 16-16s16 7.2 16 16l0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80zm80-72c0-8.8 7.2-16 16-16s16 7.2 16 16l0 224c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-224zm80 56c0-8.8 7.2-16 16-16s16 7.2 16 16l0 112c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-112zm80 40c0-8.8 7.2-16 16-16s16 7.2 16 16l0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-32z", "M256 32a224 224 0 1 1 0 448 224 224 0 1 1 0-448zm0 480a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM240 144c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 224c0 8.8 7.2 16 16 16s16-7.2 16-16l0-224zm80 56c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 112c0 8.8 7.2 16 16 16s16-7.2 16-16l0-112zM160 216c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 80c0 8.8 7.2 16 16 16s16-7.2 16-16l0-80zm240 24c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16s16-7.2 16-16l0-32z"]],
    "empty-set": [512, 512, [8709, 216], "f656", ["", "M507.3 27.3c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0L425.4 64C380.2 24.2 320.9 0 256 0 114.6 0 0 114.6 0 256 0 320.9 24.2 380.2 64 425.4L4.7 484.7c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0L86.6 448c45.1 39.8 104.4 64 169.4 64 141.4 0 256-114.6 256-256 0-64.9-24.2-124.2-64-169.4l59.3-59.3zM402.7 86.7l-316 316C52.6 363.4 32 312.1 32 256 32 132.3 132.3 32 256 32 312.1 32 363.4 52.6 402.7 86.7zM109.3 425.3l316-316c34.1 39.3 54.7 90.6 54.7 146.7 0 123.7-100.3 224-224 224-56.1 0-107.4-20.6-146.7-54.7z"]],
    "circle-won": [512, 512, [], "e6ec", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm80 16c0-8.8 7.2-16 16-16l9.4 0-24.7-83.4c-2.5-8.5 2.3-17.4 10.8-19.9s17.4 2.3 19.9 10.8l27.4 92.5 41.2 0 28.7-100.4c2-6.9 8.2-11.6 15.4-11.6s13.4 4.7 15.4 11.6l28.7 100.4 41.2 0 27.4-92.5c2.5-8.5 11.4-13.3 19.9-10.8s13.3 11.4 10.8 19.9l-24.7 83.4 9.4 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-18.9 0-29.8 100.5c-2 6.8-8.3 11.5-15.4 11.5s-13.4-4.8-15.3-11.6l-28.7-100.4-39.9 0-28.7 100.4c-2 6.8-8.2 11.6-15.3 11.6s-13.4-4.6-15.4-11.5L146.9 288 128 288c-8.8 0-16-7.2-16-16zm68.2 16l11.5 38.7 11.1-38.7-22.5 0zm65-32l21.6 0-10.8-37.8-10.8 37.8zm64 32l11.1 38.7 11.5-38.7-22.5 0z", "M256 32a224 224 0 1 1 0 448 224 224 0 1 1 0-448zm0 480a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm0-368c-7.1 0-13.4 4.7-15.4 11.6l-28.7 100.4-41.2 0-27.4-92.5c-2.5-8.5-11.4-13.3-19.9-10.8s-13.3 11.4-10.8 19.9l24.7 83.4-9.4 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l18.9 0 29.8 100.5c2 6.8 8.3 11.5 15.4 11.5s13.4-4.8 15.3-11.6l28.7-100.4 39.9 0 28.7 100.4c2 6.8 8.2 11.6 15.3 11.6s13.4-4.6 15.4-11.5L365.1 288 384 288c8.8 0 16-7.2 16-16s-7.2-16-16-16l-9.4 0 24.7-83.4c2.5-8.5-2.3-17.4-10.8-19.9s-17.4 2.3-19.9 10.8l-27.4 92.5-41.2 0-28.7-100.4c-2-6.9-8.2-11.6-15.4-11.6zm64.3 182.7l-11.1-38.7 22.5 0-11.5 38.7zM256 218.2l10.8 37.8-21.6 0 10.8-37.8zM180.2 288l22.5 0-11.1 38.7-11.5-38.7z"]],
    "hockey-stick": [512, 512, [], "e7e6", ["M64.5 368l0 96c0 8.8 7.2 16 16 16l48 0 0-128-48 0c-8.8 0-16 7.2-16 16zm96-16l0 128 63.4 0c32.5 0 61.9-19.7 74.1-49.9l31.8-78.1-169.3 0z", "M481.7-22c3.3-8.2 12.7-12.1 20.8-8.8s12.1 12.7 8.8 20.8L327.6 442.2C310.5 484.4 269.4 512 223.9 512L80.5 512c-26.5 0-48-21.5-48-48l0-96c0-26.5 21.5-48 48-48l262.2 0 138.9-342zM160.5 480l63.4 0c32.5 0 61.9-19.7 74.1-49.9l31.8-78.1-169.3 0 0 128zm-80-128c-8.8 0-16 7.2-16 16l0 96c0 8.8 7.2 16 16 16l48 0 0-128-48 0z"]],
    "monkey": [576, 512, [128018], "f6fb", ["M192 416c0-70.9 38.4-132.8 95.5-166 26.4 32.9 67 54 112.5 54 5.4 0 10.7-.3 16-.9l0 50.5c-20.3-20.7-48.7-33.6-80-33.6l-32 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l32 0c44.2 0 80 35.8 80 80l0 48-224 0 0-64zm64-304c0-17.7 14.3-32 32-32l4.6 0c-3 10.1-4.6 20.9-4.6 32l0 32c-17.7 0-32-14.3-32-32zm64 0c0 20.8 13.2 38.4 31.6 45.1 4.7 1.7 8.4 5.9 8.4 10.9 0 22.1 17.9 40 40 40s40-17.9 40-40c0-5 3.7-9.2 8.4-10.9 18.5-6.7 31.6-24.4 31.6-45.1l0 48c0 44.2-35.8 80-80 80s-80-35.8-80-80l0-48zm16-48c14.6-19.4 37.8-32 64-32s49.4 12.6 64 32L336 64zM507.4 80l4.6 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l0-32c0-11.1-1.6-21.9-4.6-32z", "M160 416c0-82.3 44.3-154.2 110.4-193.1 4.7 9.7 10.5 18.7 17.1 27.1-57.1 33.3-95.5 95.2-95.5 166l0 64 224 0 0-48c0-44.2-35.8-80-80-80l-32 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l32 0c31.3 0 59.7 12.9 80 33.6l0-50.5c14.7-1.6 28.7-5.5 41.7-11.1l79.2 84.1c25.1 26.7 39.1 62 39.1 98.7l0 21.2c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-21.2c0-28.5-10.9-56-30.4-76.8l-65.6-69.7 0 151.7 32 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-336 0C64.5 512 0 447.5 0 368L0 103.3C0 46.2 46.2 0 103.3 0 152.3 0 192 39.7 192 88.7l0 7.3c0 53-43 96-96 96l-16 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0c35.3 0 64-28.7 64-64l0-7.3C160 57.4 134.6 32 103.3 32 63.9 32 32 63.9 32 103.3L32 368c0 61.9 50.1 112 112 112l16 0 0-64zM480 160l0-48c0 20.8-13.2 38.4-31.6 45.1-4.7 1.7-8.4 5.9-8.4 10.9 0 22.1-17.9 40-40 40s-40-17.9-40-40c0-5-3.7-9.2-8.4-10.9-18.5-6.7-31.6-24.4-31.6-45.1l0 48c0 44.2 35.8 80 80 80s80-35.8 80-80zM336 64l128 0c-14.6-19.4-37.8-32-64-32s-49.4 12.6-64 32zm64 208c-56.4 0-103.1-41.7-110.9-96l-1.1 0c-35.3 0-64-28.7-64-64s28.7-64 64-64l20.1 0C328.3 19 361.9 0 400 0s71.7 19 91.9 48L512 48c35.3 0 64 28.7 64 64s-28.7 64-64 64l-1.1 0c-7.8 54.3-54.4 96-110.9 96zM544 112c0-17.7-14.3-32-32-32l-4.6 0c3 10.1 4.6 20.9 4.6 32l0 32c17.7 0 32-14.3 32-32zM288 144l0-32c0-11.1 1.6-21.9 4.6-32L288 80c-17.7 0-32 14.3-32 32s14.3 32 32 32zm80-16a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm80-16a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"]],
    "forklift": [576, 512, [], "f47a", ["M32 216l0 140.1c15.2-12.6 34.7-20.1 56-20.1 45.9 0 83.6 35.1 87.6 80l64.7 0c4-44.9 41.7-80 87.6-80 8.3 0 16.4 1.2 24 3.3l0-51.3-144 0c-4.2 0-8.3-1.7-11.3-4.7L105.4 192 56 192c-13.3 0-24 10.7-24 24z", "M480 16c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 448c0 8.8 7.2 16 16 16l96 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-80 0 0-432zM32 424a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zM0 216L0 424c0 48.6 39.4 88 88 88 40.3 0 74.2-27.1 84.7-64l70.6 0c10.4 36.9 44.4 64 84.7 64 48.6 0 88-39.4 88-88 0-27.3-12.5-51.7-32-67.9l0-89.6c0-9.3-2-18.4-5.9-26.8l-83-179.8c-7.8-17-24.9-27.9-43.6-27.9L144 32c-26.5 0-48 21.5-48 48l0 80-40 0c-30.9 0-56 25.1-56 56zM352 339.3c-7.6-2.2-15.7-3.3-24-3.3-45.9 0-83.6 35.1-87.6 80l-64.7 0c-4-44.9-41.7-80-87.6-80-21.3 0-40.8 7.5-56 20.1L32 216c0-13.3 10.7-24 24-24l49.4 0 91.3 91.3c3 3 7.1 4.7 11.3 4.7l144 0 0 51.3zM350.2 256l-135.6 0-86.6-86.6 0-89.4c0-8.8 7.2-16 16-16l107.5 0c6.2 0 11.9 3.6 14.5 9.3l83 179.8c.4 .9 .8 1.9 1.2 2.9zM272 424a56 56 0 1 1 112 0 56 56 0 1 1 -112 0z"]],
    "skull": [512, 512, [128128], "f54c", ["M32 240c0 64.8 32 123.3 83.2 161.8 8 6 12.8 15.5 12.8 25.6l0 36.6c0 8.8 7.2 16 16 16l48 0 0-48c0-8.8 7.2-16 16-16s16 7.2 16 16l0 48 64 0 0-48c0-8.8 7.2-16 16-16s16 7.2 16 16l0 48 48 0c8.8 0 16-7.2 16-16l0-36.6c0-10.1 4.7-19.5 12.8-25.6 51.2-38.5 83.2-96.9 83.2-161.8 0-113-98.3-208-224-208S32 127 32 240zm192 16a64 64 0 1 1 -128 0 64 64 0 1 1 128 0zm192 0a64 64 0 1 1 -128 0 64 64 0 1 1 128 0z", "M384 427.4c0-10.1 4.7-19.5 12.8-25.6 51.2-38.5 83.2-96.9 83.2-161.8 0-113-98.3-208-224-208S32 127 32 240c0 64.8 32 123.3 83.2 161.8 8 6 12.8 15.5 12.8 25.6l0 36.6c0 8.8 7.2 16 16 16l48 0 0-48c0-8.8 7.2-16 16-16s16 7.2 16 16l0 48 64 0 0-48c0-8.8 7.2-16 16-16s16 7.2 16 16l0 48 48 0c8.8 0 16-7.2 16-16l0-36.6zm32 0l0 36.6c0 26.5-21.5 48-48 48l-224 0c-26.5 0-48-21.5-48-48l0-36.6C37.5 383.4 0 315.8 0 240 0 107.5 114.6 0 256 0S512 107.5 512 240c0 75.8-37.5 143.4-96 187.4zM160 288a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm0-96a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm224 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm-96 0a64 64 0 1 1 128 0 64 64 0 1 1 -128 0z"]],
    "sneaker": [640, 512, [], "e6da", ["M32 163.5l0 156.5 573 0c-10.2-43-45.3-77-90.5-84.5l-71.7-11.9-3.2-.5-28.3 28.3c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l22-22-51.2-31.5-44.2 44.2c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l38.8-38.8-99.2-61.1c-.9-.5-1.8-.8-2.8-.8-3 0-5.4 2.4-5.4 5.4l0 45.3c0 51.5-41.8 93.3-93.3 93.3-32.8 0-63.1-17.2-80-45.3L32 163.5z", "M411.3 251.3c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l22-22-51.2-31.5-44.2 44.2c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l38.8-38.8-99.2-61.1c-.9-.5-1.8-.8-2.8-.8-3 0-5.4 2.4-5.4 5.4l0 45.3c0 51.5-41.8 93.3-93.3 93.3-32.8 0-63.1-17.2-80-45.3L32 163.5 32 320 605 320c-10.2-43-45.3-77-90.5-84.5l-71.7-11.9-3.2-.5-28.3 28.3zM32 352l0 32c0 17.7 14.3 32 32 32l512 0c17.7 0 32-14.3 32-32l0-32-576 0zM0 384L0 158.6c0-16.9 13.7-30.6 30.6-30.6 10.8 0 20.7 5.6 26.3 14.9l21.2 35.4c11.1 18.5 31 29.8 52.6 29.8 33.9 0 61.3-27.4 61.3-61.3l0-45.3c0-20.7 16.7-37.4 37.4-37.4 6.9 0 13.7 1.9 19.6 5.5L448 192 519.7 203.9C589.1 215.5 640 275.6 640 346l0 38c0 35.3-28.7 64-64 64L64 448c-35.3 0-64-28.7-64-64z"]],
    "gamepad-modern": [576, 512, [127918, 63676, "gamepad-alt"], "e5a2", ["M32 240l0 140.3c0 37.4 30.3 67.7 67.7 67.7 29.1 0 55-18.6 64.2-46.3l12.9-38.8 1-2.3c2.7-5.2 8.2-8.6 14.2-8.6l192 0c6.9 0 13 4.4 15.2 10.9l12.9 38.8c9.2 27.6 35.1 46.3 64.2 46.3 37.4 0 67.7-30.3 67.7-67.7L544 240c0-94.2-73.9-171.1-166.9-175.8L368 64 208 64C110.8 64 32 142.8 32 240zm64-16c0-8.8 7.2-16 16-16l32 0 0-32c0-8.8 7.2-16 16-16s16 7.2 16 16l0 32 32 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-32 0 0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-32-32 0c-8.8 0-16-7.2-16-16zm312 32a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm48-80a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M378.7 32.3C488.6 37.9 576 128.7 576 240l0 140.3c0 55.1-44.6 99.7-99.7 99.7-42.9 0-81-27.5-94.6-68.2l-9.3-27.8-168.9 0-9.3 27.8C180.7 452.5 142.6 480 99.7 480 44.6 480 0 435.4 0 380.3L0 240C0 125.1 93.1 32 208 32l160 0 10.7 .3zM208 64C110.8 64 32 142.8 32 240l0 140.3c0 37.4 30.3 67.7 67.7 67.7 29.1 0 55-18.6 64.2-46.3l12.9-38.8 1-2.3c2.7-5.2 8.2-8.6 14.2-8.6l192 0c6.9 0 13 4.4 15.2 10.9l12.9 38.8c9.2 27.6 35.1 46.3 64.2 46.3 37.4 0 67.7-30.3 67.7-67.7L544 240c0-94.2-73.9-171.1-166.9-175.8L368 64 208 64zm-48 96c8.8 0 16 7.2 16 16l0 32 32 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-32 0 0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-32-32 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l32 0 0-32c0-8.8 7.2-16 16-16zM384 280a24 24 0 1 1 0-48 24 24 0 1 1 0 48zm48-80a24 24 0 1 1 0-48 24 24 0 1 1 0 48z"]],
    "square-k": [448, 512, [], "e274", ["M32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64C46.3 64 32 78.3 32 96zm112 80c0-8.8 7.2-16 16-16s16 7.2 16 16l0 76.7 101.5-88.8c6.7-5.8 16.8-5.1 22.6 1.5s5.1 16.8-1.5 22.6l-68.3 59.8 69.7 77.4c5.9 6.6 5.4 16.7-1.2 22.6s-16.7 5.4-22.6-1.2l-70-77.8-30.1 26.3 0 40.7c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-160z", "M64 64C46.3 64 32 78.3 32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm298.5 92l-68.3 59.8 69.7 77.4c5.9 6.6 5.4 16.7-1.2 22.6s-16.7 5.4-22.6-1.2l-70-77.8-30.1 26.3 0 40.7c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-160c0-8.8 7.2-16 16-16s16 7.2 16 16l0 76.7 101.5-88.8c6.7-5.8 16.8-5.1 22.6 1.5s5.1 16.8-1.5 22.6z"]],
    "comment-text": [512, 512, [], "e14d", ["M32 240c0 46.7 16.5 89.8 44.8 124.8 8.1 10.1 9.4 24.1 3.2 35.4l-40.2 73.6 101-43.3c7.9-3.4 16.8-3.5 24.8-.2 27.6 11.3 58.2 17.6 90.4 17.6 125.7 0 224-95 224-208S381.7 32 256 32 32 127 32 240zm136-64c0-8.8 7.2-16 16-16l144 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-56 0 0 128c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-128-56 0c-8.8 0-16-7.2-16-16z", "M80 400.2c6.2-11.4 4.9-25.4-3.2-35.4-28.2-34.9-44.8-78.1-44.8-124.8 0-113 98.3-208 224-208s224 95 224 208-98.3 208-224 208c-32.3 0-62.8-6.3-90.4-17.6-7.9-3.3-16.9-3.2-24.8 .2L39.8 473.8 80 400.2zM0 240c0 54.4 19.3 104.6 51.9 144.9L3.1 474.3c-2 3.7-3.1 7.9-3.1 12.2 0 14.1 11.4 25.5 25.5 25.5 4 0 7.8-.6 11.5-2.1L153.4 460c31.4 12.9 66.1 20 102.6 20 141.4 0 256-107.5 256-240S397.4 0 256 0 0 107.5 0 240zm184-80c-8.8 0-16 7.2-16 16s7.2 16 16 16l56 0 0 128c0 8.8 7.2 16 16 16s16-7.2 16-16l0-128 56 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-144 0z"]],
    "mars-stroke-up": [384, 512, [9896, "mars-stroke-v"], "f22a", ["M48 336a144 144 0 1 0 288 0 144 144 0 1 0 -288 0z", "M192 192l0 0c-79.5 0-144 64.5-144 144s64.5 144 144 144 144-64.5 144-144-64.5-144-144-144zM16 336c0-91.8 70.3-167.2 160-175.3l0-48.7-48 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l48 0 0-68.7-37.5 32.8c-6.7 5.8-16.8 5.1-22.6-1.5s-5.1-16.8 1.5-22.6l64-56c6-5.3 15-5.3 21.1 0l64 56c6.6 5.8 7.3 15.9 1.5 22.6s-15.9 7.3-22.6 1.5L208 11.3 208 80 256 80c8.8 0 16 7.2 16 16s-7.2 16-16 16l-48 0 0 48.7c89.7 8.1 160 83.5 160 175.3 0 97.2-78.8 176-176 176S16 433.2 16 336z"]],
    "cowbell": [448, 512, [], "f8b3", ["M32 373.5c0 5.8 4.7 10.5 10.5 10.5l363 0c5.8 0 10.5-4.7 10.5-10.5 0-.9-.1-1.8-.3-2.7l-66-251C345.9 105.8 333.2 96 318.7 96L129.3 96c-14.5 0-27.2 9.8-30.9 23.9l-66 251c-.2 .9-.3 1.8-.3 2.7z", "M184 16l80 0c13.3 0 24 10.7 24 24l0 24-128 0 0-24c0-13.3 10.7-24 24-24zM128 40l0 24c-28.5 .6-53.3 20-60.6 47.7l-66 251C.5 366.2 0 369.8 0 373.5 0 397 19 416 42.5 416l363 0c23.5 0 42.5-19 42.5-42.5 0-3.6-.5-7.3-1.4-10.8l-66-251C373.3 84 348.5 64.6 320 64l0-24c0-30.9-25.1-56-56-56l-80 0c-30.9 0-56 25.1-56 56zm16 56l174.7 0c14.5 0 27.2 9.8 30.9 23.9l66 251c.2 .9 .3 1.8 .3 2.7 0 5.8-4.7 10.5-10.5 10.5l-363 0c-5.8 0-10.5-4.7-10.5-10.5 0-.9 .1-1.8 .3-2.7l66-251c3.7-14.1 16.4-23.9 30.9-23.9L144 96zm80 416c32.8 0 61-19.7 73.3-48l-37.6 0c-8.8 9.8-21.6 16-35.8 16s-27-6.2-35.8-16l-37.6 0c12.3 28.3 40.5 48 73.3 48z"]],
    "fire-flame-simple": [384, 512, ["burn"], "f46a", ["M32 321.6C32 408.7 104.2 480 192 480s160-71.3 160-158.4c0-18.5-3.2-36.8-9.5-54.1l-.7-1.9C310.2 178.6 258.9 100.2 192 36.4 125.1 100.2 73.8 178.6 42.2 265.5l-.7 1.9c-6.3 17.4-9.5 35.7-9.5 54.1zm48-2.1c0-12.4 2.6-24.7 7.6-36l1.9-4.3c16.5-37.2 39.8-71.1 68.6-99.9l8.9-8.9c6.6-6.6 15.6-10.3 24.9-10.3s18.3 3.7 24.9 10.3l8.9 8.9c28.8 28.8 52.1 62.7 68.6 99.9l1.9 4.3c5 11.3 7.6 23.7 7.6 36 0 61.7-50 112.5-112 112.5S80 381.2 80 319.5z", "M341.8 265.5C310.2 178.6 258.9 100.2 192 36.4 125.1 100.2 73.8 178.6 42.2 265.5l-.7 1.9C35.2 284.8 32 303.1 32 321.6 32 408.7 104.2 480 192 480s160-71.3 160-158.4c0-18.5-3.2-36.8-9.5-54.1l0 0-.7-1.9zm30.1-10.9l.7 1.9c7.6 20.9 11.5 42.9 11.5 65.1 0 105.2-86.8 190.4-192 190.4S0 426.7 0 321.6c0-22.2 3.9-44.2 11.5-65.1l.7-1.9C46.2 160.8 102 76.5 174.9 8.5l3.3-3C181.9 2 186.9 0 192 0s10.1 2 13.8 5.5l3.3 3c72.9 68 128.7 152.4 162.7 246.1zM192 160c9.3 0 18.3 3.7 24.9 10.3l8.9 8.9c28.8 28.8 52.1 62.7 68.6 99.9l1.9 4.3c5 11.3 7.6 23.7 7.6 36 0 61.7-50 112.5-112 112.5S80 381.2 80 319.5c0-12.4 2.6-24.7 7.6-36l1.9-4.3c16.5-37.2 39.8-71.1 68.6-99.9l8.9-8.9c6.6-6.6 15.6-10.3 24.9-10.3zm-2.3 32.9l-8.9 8.9c-26 26-47.1 56.6-62 90.3l-1.9 4.3c-3.2 7.2-4.9 15.1-4.9 23 0 44.3 35.9 80.5 80 80.5s80-36.2 80-80.5c0-7.9-1.7-15.8-4.9-23l-1.9-4.3c-15-33.6-36-64.3-62-90.3l-8.9-8.9c-.6-.6-1.4-.9-2.3-.9s-1.7 .4-2.3 .9z"]],
    "tree": [448, 512, [127794], "f1bb", ["M58.6 416l330.8 0-100-117.6c-4-4.7-5-11.4-2.3-17.1s8.3-9.3 14.5-9.3l55.8 0-100-117.6c-4-4.8-5-11.4-2.3-17.1s8.3-9.3 14.5-9.3L325.4 128 224 8.7 122.6 128 178.4 128c6.2 0 11.9 3.6 14.5 9.3s1.7 12.3-2.3 17.1l-100 117.6 55.8 0c6.2 0 11.9 3.6 14.5 9.3s1.7 12.3-2.3 17.1L58.6 416z", "M224-32c4.7 0 9.1 2.1 12.2 5.6l136 160c4 4.8 5 11.4 2.3 17.1S366.2 160 360 160l-55.8 0 100 117.6c4 4.8 5 11.4 2.3 17.1S398.2 304 392 304l-55.8 0 100 117.6c4 4.8 5 11.4 2.3 17.1S430.2 448 424 448l-184 0 0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80-184 0c-6.2 0-11.9-3.6-14.5-9.3s-1.7-12.3 2.3-17.1L111.8 304 56 304c-6.2 0-11.9-3.6-14.5-9.3s-1.7-12.3 2.3-17.1L143.8 160 88 160c-6.2 0-11.9-3.6-14.5-9.3s-1.7-12.3 2.3-17.1l136-160 2.5-2.4c2.8-2.1 6.1-3.2 9.7-3.2zM122.6 128l55.8 0c6.2 0 11.9 3.6 14.5 9.3s1.7 12.3-2.3 17.1l-100 117.6 55.8 0c6.2 0 11.9 3.6 14.5 9.3s1.7 12.3-2.3 17.1l-100 117.6 330.8 0-100-117.6c-4-4.7-5-11.4-2.3-17.1s8.3-9.3 14.5-9.3l55.8 0-100-117.6c-4-4.8-5-11.4-2.3-17.1s8.3-9.3 14.5-9.3L325.4 128 224 8.7 122.6 128z"]],
    "gauge-simple-min": [512, 512, ["tachometer-slowest"], "f62d", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm50.3-8.2c4.5-7.6 14.4-10 22-5.5l106.9 64.1c11.6-11.4 27.4-18.4 44.9-18.4 35.3 0 64 28.7 64 64s-28.7 64-64 64-64-28.7-64-64c0-6.3 .9-12.4 2.6-18.2L87.8 269.7c-7.6-4.5-10-14.4-5.5-22z", "M256 32a224 224 0 1 1 0 448 224 224 0 1 1 0-448zm0 480a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm0-192a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm0 96c35.3 0 64-28.7 64-64s-28.7-64-64-64c-17.5 0-33.4 7-44.9 18.4L104.2 242.3c-7.6-4.5-17.4-2.1-22 5.5s-2.1 17.4 5.5 22l106.8 64.1c-1.7 5.8-2.6 11.9-2.6 18.2 0 35.3 28.7 64 64 64z"]],
    "comments-question-check": [576, 512, [], "e14f", ["M32 144c0 29.1 9.6 56.4 26.5 79.3 6.4 8.8 8 20.2 4.1 30.3l-22 57.8 79.5-30.3c6.6-2.5 13.9-2.8 20.7-.7 16 4.9 33.2 7.5 51.2 7.5 91 0 160-67 160-144S283 0 192 0 32 67 32 144zm90.8-42.8C122.8 63 153.8 32 192 32s69.2 31 69.2 69.2c0 35.8-24.3 53.7-42.1 61.7-7.8 3.5-11.1 9.2-11.1 13.1 0 8.8-7.2 16-16 16s-16-7.2-16-16c0-20.8 15.3-35.7 30.1-42.3 12.2-5.4 23.2-14.7 23.2-32.5 0-20.6-16.7-37.2-37.2-37.2s-37.2 16.7-37.2 37.2c0 8.8-7.2 16-16 16s-16-7.2-16-16zM212 240a20 20 0 1 1 -40 0 20 20 0 1 1 40 0zm15.4 125.5c15 63.8 77.4 114.5 156.6 114.5 18 0 35.2-2.7 51.2-7.5 6.8-2.1 14.1-1.8 20.7 .7l79.5 30.3-22-57.8c-3.9-10.2-2.3-21.6 4.1-30.3 16.8-22.9 26.5-50.1 26.5-79.3 0-64.8-48.9-122.5-118.6-139.2-13.7 53.4-47.7 98.5-93.1 128.9 .2 .2 .4 .4 .5 .7l34 45.3 67.6-108.2c4.7-7.5 14.6-9.8 22-5.1s9.8 14.6 5.1 22l-80 128c-2.8 4.5-7.6 7.3-12.9 7.5s-10.3-2.2-13.5-6.4l-48-64c-1-1.3-1.7-2.6-2.2-4-23.9 11.9-50.1 20.1-77.6 24z", "M62.6 253.6C66.4 243.5 64.9 232 58.5 223.3 41.6 200.4 32 173.1 32 144 32 67 101 0 192 0s160 67 160 144-69 144-160 144c-18 0-35.2-2.7-51.2-7.5-6.8-2.1-14.1-1.8-20.7 .7l-79.5 30.3 22-57.8zM0 144c0 36.4 12 70.2 32.7 98.2L1.3 324.5c-.9 2.3-1.3 4.7-1.3 7.2 0 11.2 9.1 20.3 20.3 20.3 2.5 0 4.9-.5 7.2-1.3l104-39.6c19 5.8 39.4 8.9 60.6 8.9 106 0 192-78.8 192-176S298-32 192-32 0 46.8 0 144zM384 512c21.2 0 41.5-3.1 60.6-8.9l104 39.6c2.3 .9 4.8 1.3 7.2 1.3 11.2 0 20.3-9.1 20.3-20.3 0-2.5-.5-4.9-1.3-7.2l-31.3-82.3c20.6-28.1 32.7-61.9 32.7-98.2 0-82.4-61.7-151.5-145-170.7-1.1 10.8-2.9 21.3-5.6 31.5 69.8 16.7 118.6 74.4 118.6 139.2 0 29.1-9.6 56.4-26.5 79.3-6.4 8.8-8 20.2-4.1 30.3l22 57.8-79.5-30.3c-6.6-2.5-13.9-2.8-20.7-.7-16 4.9-33.2 7.5-51.2 7.5-79.1 0-141.6-50.7-156.6-114.5-10.6 1.5-21.4 2.3-32.3 2.4 16.4 81.9 94.7 144 188.8 144zM154.8 101.2C154.8 80.7 171.4 64 192 64s37.2 16.7 37.2 37.2c0 17.8-11 27-23.2 32.5-14.7 6.6-30.1 21.5-30.1 42.3 0 8.8 7.2 16 16 16s16-7.2 16-16c0-3.8 3.4-9.6 11.1-13.1 17.8-8 42.1-25.9 42.1-61.7 0-38.2-31-69.2-69.2-69.2s-69.2 31-69.2 69.2c0 8.8 7.2 16 16 16s16-7.2 16-16zM192 260a20 20 0 1 0 0-40 20 20 0 1 0 0 40zm269.6 20.5c4.7-7.5 2.4-17.4-5.1-22s-17.4-2.4-22 5.1l-67.6 108.2-34-45.3c-5.3-7.1-15.3-8.5-22.4-3.2s-8.5 15.3-3.2 22.4l48 64c3.2 4.2 8.2 6.6 13.5 6.4s10.1-3 12.9-7.5l80-128z"]],
    "smog": [576, 512, [], "f75f", ["M64 144c0 61.9 50.1 112 112 112l97.6 0c4.2 0 8.2 1.6 11.2 4.6 17.3 17 41 27.4 67.2 27.4s49.9-10.4 67.2-27.4c3-2.9 7-4.6 11.2-4.6l1.6 0c44.2 0 80-35.8 80-80s-35.8-80-80-80c-3 0-5.9 .2-8.8 .5-6.8 .7-13.3-2.9-16.2-9.1-15.3-32.7-48.5-55.4-87-55.4-22.5 0-43.1 7.7-59.4 20.6-5.6 4.4-13.5 4.6-19.3 .4-18.4-13.2-40.9-21-65.3-21-61.9 0-112 50.1-112 112z", "M32 144C32 64.5 96.5 0 176 0 203.2 0 228.6 7.5 250.3 20.6 270.4 7.6 294.3 0 320 0 367.4 0 408.8 25.8 430.9 64l1.1 0c61.9 0 112 50.1 112 112 0 60.3-47.6 109.4-107.2 111.9-22.6 20-52.3 32.1-84.8 32.1-32.5 0-62.1-12.1-84.7-32L176 288C96.5 288 32 223.5 32 144zM176 32C114.1 32 64 82.1 64 144s50.1 112 112 112l97.6 0c4.2 0 8.2 1.6 11.2 4.6 17.3 17 41 27.4 67.2 27.4s49.9-10.4 67.2-27.4c3-2.9 7-4.6 11.2-4.6l1.6 0c44.2 0 80-35.8 80-80s-35.8-80-80-80c-3 0-5.9 .2-8.8 .5-6.8 .7-13.3-2.9-16.2-9.1-15.3-32.7-48.5-55.4-87-55.4-22.5 0-43.1 7.7-59.4 20.6-5.6 4.4-13.5 4.6-19.3 .4-18.4-13.2-40.9-21-65.3-21zM512 400c0 8.8-7.2 16-16 16L16 416c-8.8 0-16-7.2-16-16s7.2-16 16-16l480 0c8.8 0 16 7.2 16 16zM80 480l96 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zm176 0l304 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-304 0c-8.8 0-16-7.2-16-16s7.2-16 16-16z"]],
    "s": [320, 512, [115], "53", ["", "M0 147.6C0 83.8 51.8 32 115.6 32L288 32c8.8 0 16 7.2 16 16s-7.2 16-16 16L115.6 64c-46.2 0-83.6 37.4-83.6 83.6 0 40.9 29.6 75.8 69.9 82.5l121.5 20.3c55.7 9.3 96.6 57.5 96.6 114 0 63.8-51.8 115.6-115.6 115.6L32 480c-8.8 0-16-7.2-16-16s7.2-16 16-16l172.4 0c46.2 0 83.6-37.4 83.6-83.6 0-40.9-29.5-75.8-69.9-82.5L96.6 261.7C40.9 252.4 0 204.1 0 147.6z"]],
    "phone-arrow-up-right": [512, 512, ["phone-arrow-up", "phone-outgoing"], "e224", ["M34.2 157.4C67.6 318 194.1 444.4 354.7 477.9 412.9 490 463.1 448.2 477.6 394.9l1.8-6.7c2.3-8.4-2-17.2-10.1-20.6l-93.3-38.9c-7.1-2.9-15.2-.9-20.1 5l-36.6 44.7c-4.7 5.7-12.6 7.5-19.2 4.3-75-35.6-135-97.6-168.1-174-2.8-6.6-1-14.2 4.6-18.7l41.6-34.1c5.9-4.8 8-13 5-20.1L144.4 42.7c-3.4-8-12.2-12.3-20.6-10.1l-6.7 1.8C63.9 49 22.1 99.1 34.2 157.4z", "M324.7 164.7c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0L480 54.6 480 144c0 8.8 7.2 16 16 16s16-7.2 16-16l0-128c0-8.8-7.2-16-16-16L368 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l89.4 0-132.7 132.7zM123.8 32.6c8.4-2.3 17.2 2 20.6 10.1L183.3 136c2.9 7.1 .9 15.2-5 20.1l-41.6 34.1c-5.5 4.5-7.4 12.2-4.6 18.7 33.1 76.4 93.1 138.4 168.1 174 6.6 3.2 14.6 1.4 19.2-4.3L356 333.8c4.8-5.9 13-8 20.1-5l93.3 38.9c8 3.4 12.3 12.2 10.1 20.6l-1.8 6.7C463.1 448.2 412.9 490 354.7 477.9 194.1 444.4 67.6 318 34.2 157.4 22.1 99.1 63.9 49 117.1 34.4l6.7-1.8zm50.1-2.3C164.4 7.5 139.3-4.8 115.4 1.7l-6.7 1.8c-65 17.7-122.3 81.2-105.9 160.3 36 173.1 172.2 309.3 345.3 345.3 79.1 16.5 142.6-40.9 160.3-105.9l1.8-6.7c6.5-23.9-5.7-49-28.6-58.5l-93.3-38.9c-20.1-8.4-43.4-2.6-57.2 14.3l-28.5 34.9c-59.3-31.1-107.3-80.8-136.3-141.3l32.1-26.3c16.9-13.8 22.7-37 14.3-57.2L173.9 30.4z"]],
    "teddy-bear": [512, 512, [], "e3cf", ["M46.3 242.3c23.1 33.1 53.8 60.5 89.6 79.6 5.2 2.8 8.5 8.2 8.5 14.1l0 64c-.8 8.6-6.6 16-16 16-9.4 0-15.1-7.4-16-16 0-17.7-14.3-32-32-32-17.4 .8-32 13.9-32 32l0 32c1.4 27 21 46.6 48 48l320 0c27-1.4 46.6-21 48-48l0-32c0-18.1-14.6-31.2-32-32-17.7 0-32 14.3-32 32-.9 8.6-6.6 16-16 16-9.4 0-15.2-7.4-16-16l0-64c0-5.9 3.3-11.3 8.5-14.1 35.8-19.1 66.6-46.5 89.6-79.6 8.5-13.7 7.4-31.6-5.3-42.6-15.2-11.7-35.3-9.3-47.1 5.9-35.6 51.1-93.6 82.3-157.6 82.3s-122-31.2-157.6-82.3c-11.8-15.3-31.9-17.7-47.1-5.9-12.8 11-13.8 28.8-5.3 42.6zM112.3 72c0 16.4 9.9 30.6 24.2 36.7 6.8 3 10.7 10.3 9.4 17.6-1 5.4-1.6 11.3-1.6 17.7 0 61.9 50.1 112 112 112s112-50.1 112-112c0-6.4-.6-12.3-1.6-17.7-1.4-7.3 2.5-14.7 9.4-17.6 14.3-6.2 24.2-20.3 24.2-36.7 0-22.1-17.9-40-40-40-17.4 0-32.2 11.1-37.7 26.7-2.7 7.7-10.8 12.1-18.8 10.2-15.7-3.7-31.5-4.6-47.5-5-16 .4-31.9 1.3-47.5 5-8 1.9-16.1-2.5-18.8-10.2-5.5-15.6-20.3-26.7-37.7-26.7-22.1 0-40 17.9-40 40zm64 328c0-44.2 35.8-80 80-80s80 35.8 80 80l0 16c0 8.8-7.2 16-16 16s-16-7.2-16-16l-96 0c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-16zm52-256a20 20 0 1 1 -40 0 20 20 0 1 1 40 0zm-4 56c0-13.3 14.3-24 32-24s32 10.7 32 24-14.3 24-32 24-32-10.7-32-24zm100-56a20 20 0 1 1 -40 0 20 20 0 1 1 40 0z", "M360.3 0c39.8 0 72 32.2 72 72 0 25.2-13 47.2-32.5 60.1 .3 3.9 .5 7.8 .5 11.9 0 11.5-1.4 22.6-3.9 33.3 24.4-23 60.1-21.6 85.6-1.8 25.5 21.9 27.8 57.7 10.7 85.1-22.4 32.1-51.3 59.5-84.7 80.2 7.5-3.1 15.8-4.8 24.4-4.8 32 0 64 27.8 64 64l0 32c-2.2 44.9-35.1 77.8-80 80l-320 0c-44.9-2.2-77.8-35.1-80-80l0-32c0-36.2 32-64 64-64 8.6 0 16.9 1.7 24.4 4.8-33.4-20.7-62.3-48.1-84.8-80.2-17.1-27.4-14.8-63.2 10.7-85.1 25.5-19.8 61.2-21.2 85.6 1.8-2.5-10.7-3.9-21.8-3.9-33.3 0-4.1 .2-8 .5-11.9-19.5-12.8-32.5-34.9-32.5-60.1 0-39.8 32.2-72 72-72 26.4 0 49.3 14.2 61.8 35.3 14-2.3 28-3 42.2-3.3 14.1 .2 28.2 .9 42.2 3.3 12.5-21.1 35.5-35.3 61.8-35.3zM461.1 199.8c-15.2-11.7-35.3-9.3-47.1 5.9-35.6 51.1-93.6 82.3-157.6 82.3s-122-31.2-157.6-82.3c-11.8-15.3-31.9-17.7-47.1-5.9-12.8 11-13.8 28.8-5.3 42.6 23.1 33.1 53.8 60.5 89.6 79.6 5.2 2.8 8.5 8.2 8.5 14.1l0 64c-.8 8.6-6.6 16-16 16-9.4 0-15.1-7.4-16-16 0-17.7-14.3-32-32-32-17.4 .8-32 13.9-32 32l0 32c1.4 27 21 46.6 48 48l320 0c27-1.4 46.6-21 48-48l0-32c0-18.1-14.6-31.2-32-32-17.7 0-32 14.3-32 32-.9 8.6-6.6 16-16 16-9.4 0-15.2-7.4-16-16l0-64c0-5.9 3.3-11.3 8.5-14.1 35.8-19.1 66.6-46.5 89.6-79.6 8.5-13.7 7.4-31.6-5.3-42.6zM256.3 320c44.2 0 80 35.8 80 80l0 16c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-16c0-26.5-21.5-48-48-48s-48 21.5-48 48l0 16c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-16c0-44.2 35.8-80 80-80zm104-288c-17.4 0-32.2 11.1-37.7 26.7-2.7 7.7-10.8 12.1-18.8 10.2-15.7-3.7-31.5-4.6-47.5-5-16 .4-31.9 1.3-47.5 5-8 1.9-16.1-2.5-18.8-10.2-5.5-15.6-20.3-26.7-37.7-26.7-22.1 0-40 17.9-40 40 0 16.4 9.9 30.6 24.2 36.7 6.8 3 10.7 10.3 9.4 17.6-1 5.4-1.6 11.3-1.6 17.7 0 61.9 50.1 112 112 112s112-50.1 112-112c0-6.4-.6-12.3-1.6-17.7-1.4-7.3 2.5-14.7 9.4-17.6 14.3-6.2 24.2-20.3 24.2-36.7 0-22.1-17.9-40-40-40zm-104 144c17.7 0 32 10.7 32 24s-14.3 24-32 24-32-10.7-32-24 14.3-24 32-24zm-48-12a20 20 0 1 1 0-40 20 20 0 1 1 0 40zm96 0a20 20 0 1 1 0-40 20 20 0 1 1 0 40z"]],
    "slot-machine": [640, 512, [], "e3ce", ["M64.2 92.7L64 96 64 416c0 17.7 14.3 32 32 32l352 0c17.7 0 32-14.3 32-32l0-320c0-16.6-12.6-30.2-28.7-31.8L448 64 96 64C79.4 64 65.8 76.6 64.2 92.7zM128 176c0-8.8 7.2-16 16-16l48 0 3.7 .4c3.6 .9 6.9 3 9.1 6s3.3 6.8 3.1 10.5l-.7 3.7-48 160c-2.5 8.5-11.4 13.3-19.9 10.7s-13.3-11.4-10.7-19.9L170.5 192 144 192c-8.8 0-16-7.2-16-16zm112 0c0-8.8 7.2-16 16-16l48 0 3.7 .4c3.6 .9 6.9 3 9.1 6s3.3 6.8 3.1 10.5l-.7 3.7-48 160c-2.5 8.5-11.4 13.3-19.9 10.7s-13.3-11.4-10.7-19.9L282.5 192 256 192c-8.8 0-16-7.2-16-16zm112 0c0-8.8 7.2-16 16-16l48 0 3.7 .4c3.6 .9 6.9 3 9.1 6s3.3 6.8 3.1 10.5l-.7 3.7-48 160c-2.5 8.5-11.4 13.3-19.9 10.7s-13.3-11.4-10.7-19.9L394.5 192 368 192c-8.8 0-16-7.2-16-16zm224-32a16 16 0 1 0 32 0 16 16 0 1 0 -32 0z", "M454.5 32.3C486.8 35.6 512 62.9 512 96l0 320-.3 6.5c-.9 9.2-3.8 17.8-8.3 25.5l24.6 0c26.5 0 48-21.5 48-48l0-210.8c-18.6-6.6-32-24.3-32-45.2 0-26.5 21.5-48 48-48s48 21.5 48 48c0 20.9-13.4 38.6-32 45.2L608 400c0 44.2-35.8 80-80 80l-432 0-6.5-.3c-30.1-3.1-54.1-27-57.1-57.1L32 416 32 96c0-33.1 25.2-60.4 57.5-63.7l6.5-.3 352 0 6.5 .3zM96 64C79.4 64 65.8 76.6 64.2 92.7L64 96 64 416c0 17.7 14.3 32 32 32l352 0c17.7 0 32-14.3 32-32l0-320c0-16.6-12.6-30.2-28.7-31.8L448 64 96 64zm99.7 96.4c3.6 .9 6.9 3 9.1 6s3.3 6.8 3.1 10.5l-.7 3.7-48 160c-2.5 8.5-11.4 13.3-19.9 10.7s-13.3-11.4-10.7-19.9L170.5 192 144 192c-8.8 0-16-7.2-16-16s7.2-16 16-16l48 0 3.7 .4zm112 0c3.6 .9 6.9 3 9.1 6s3.3 6.8 3.1 10.5l-.7 3.7-48 160c-2.5 8.5-11.4 13.3-19.9 10.7s-13.3-11.4-10.7-19.9L282.5 192 256 192c-8.8 0-16-7.2-16-16s7.2-16 16-16l48 0 3.7 .4zm112 0c3.6 .9 6.9 3 9.1 6s3.3 6.8 3.1 10.5l-.7 3.7-48 160c-2.5 8.5-11.4 13.3-19.9 10.7s-13.3-11.4-10.7-19.9L394.5 192 368 192c-8.8 0-16-7.2-16-16s7.2-16 16-16l48 0 3.7 .4zM592 128a16 16 0 1 0 0 32 16 16 0 1 0 0-32z"]],
    "face-sleeping": [640, 512, [], "e38d", ["M96 256C96 132.3 196.3 32 320 32l0-32c45 0 87.3 11.6 124 32l-60 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l45.8 0-58.1 69.8c-4 4.8-4.8 11.4-2.2 17s8.3 9.2 14.5 9.2l80 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-45.8 0 58.1-69.8c.9-1 1.6-2.2 2.1-3.3 47.5 37.5 81.4 91.3 93.1 153.1l-32.7 0c3.4 15.5 5.2 31.5 5.2 48 0 123.7-100.3 224-224 224S96 379.7 96 256zm64-8c0 30.9 25.1 56 56 56l16 0c30.9 0 56-25.1 56-56 0-8.8-7.2-16-16-16s-16 7.2-16 16c0 13.3-10.7 24-24 24l-16 0c-13.3 0-24-10.7-24-24 0-8.8-7.2-16-16-16s-16 7.2-16 16zM264 384a56 56 0 1 0 112 0 56 56 0 1 0 -112 0zm88-136c0 30.9 25.1 56 56 56l16 0c30.9 0 56-25.1 56-56 0-8.8-7.2-16-16-16s-16 7.2-16 16c0 13.3-10.7 24-24 24l-16 0c-13.3 0-24-10.7-24-24 0-8.8-7.2-16-16-16s-16 7.2-16 16z", "M528-48c0 8.8 7.2 16 16 16l45.8 0-58.1 69.8c-4 4.8-4.8 11.4-2.2 17S537.8 64 544 64l80 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-45.8 0 58.1-69.8c4-4.8 4.8-11.4 2.2-17S630.2-64 624-64l-80 0c-8.8 0-16 7.2-16 16zM368 48c0 8.8 7.2 16 16 16l45.8 0-58.1 69.8c-4 4.8-4.8 11.4-2.2 17s8.3 9.2 14.5 9.2l80 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-45.8 0 58.1-69.8c4-4.8 4.8-11.4 2.2-17S470.2 32 464 32l-80 0c-8.8 0-16 7.2-16 16zM320 0C178.6 0 64 114.6 64 256S178.6 512 320 512 576 397.4 576 256c0-16.4-1.5-32.5-4.5-48l-32.7 0c3.4 15.5 5.2 31.5 5.2 48 0 123.7-100.3 224-224 224S96 379.7 96 256 196.3 32 320 32l0-32zm0 408a24 24 0 1 1 0-48 24 24 0 1 1 0 48zm-56-24a56 56 0 1 0 112 0 56 56 0 1 0 -112 0zM408 272c-13.3 0-24-10.7-24-24 0-8.8-7.2-16-16-16s-16 7.2-16 16c0 30.9 25.1 56 56 56l16 0c30.9 0 56-25.1 56-56 0-8.8-7.2-16-16-16s-16 7.2-16 16c0 13.3-10.7 24-24 24l-16 0zM192 248c0-8.8-7.2-16-16-16s-16 7.2-16 16c0 30.9 25.1 56 56 56l16 0c30.9 0 56-25.1 56-56 0-8.8-7.2-16-16-16s-16 7.2-16 16c0 13.3-10.7 24-24 24l-16 0c-13.3 0-24-10.7-24-24z"]],
    "jedi": [576, 512, [], "f669", ["M48.9 218.7c.8 .6 1.6 1.2 2.4 2l56 56c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L49.2 263.8C61.1 385.2 163.5 480 288 480s226.9-94.8 238.8-216.2l-35.5 35.5c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l56-56c.7-.7 1.5-1.4 2.4-2-.9-10.4-2.5-20.5-4.7-30.5l-31.1 31.1c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l43.2-43.2c-12.7-32.8-32.3-62.1-57.2-86.1 .8 6.8 1.3 13.6 1.3 20.6 0 53.6-25.1 101.4-64.2 132.1 24.9 25.9 40.2 61.1 40.2 99.9 0 79.5-64.5 144-144 144S144 399.5 144 320c0-38.8 15.3-74 40.2-99.9-39.1-30.7-64.2-78.5-64.2-132.1 0-7 .4-13.9 1.3-20.6-24.8 24-44.5 53.3-57.2 86.1l43.2 43.2c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L53.6 188.2c-2.2 9.9-3.8 20.1-4.7 30.5z", "M288 0c8.8 0 16 7.2 16 16l0 264.9 36.1-24.1c3.2-2.1 7.4-1.7 10.1 1s3.1 6.9 1 10.1l-23.9 35.8 42.2 8.4c3.7 .7 6.4 4 6.4 7.8s-2.7 7.1-6.4 7.8l-42.2 8.4 23.9 35.8c2.1 3.2 1.7 7.4-1 10.1s-6.9 3.1-10.1 1l-36.1-24.1 0 71.7c54.3-7.8 96-54.4 96-110.9 0-36.2-17.1-68.3-43.8-88.8-4.2-3.2-6.5-8.3-6.2-13.6s3.2-10.1 7.8-12.8c39.7-23.8 66.2-67.2 66.2-116.8 0-20.3-4.5-39.6-12.4-56.9-3-6.5-1.3-14.1 4-18.8s13.2-5.2 19.1-1.4C510 59.3 560 143.8 560 240 560 390.2 438.2 512 288 512S16 390.2 16 240c0-96.2 50-180.7 125.3-229.1 6-3.8 13.8-3.3 19.1 1.4s7 12.3 4 18.8c-8 17.3-12.4 36.5-12.4 56.9 0 49.6 26.5 93 66.2 116.8 4.5 2.7 7.4 7.5 7.8 12.8s-2 10.4-6.2 13.6c-26.6 20.5-43.8 52.7-43.8 88.8 0 56.4 41.7 103.1 96 110.9l0-71.7-36.1 24.1c-3.2 2.1-7.4 1.7-10.1-1s-3.1-6.9-1-10.1l23.9-35.8-42.2-8.4c-3.7-.7-6.4-4-6.4-7.8s2.7-7.1 6.4-7.8l42.2-8.4-23.9-35.8c-2.1-3.2-1.7-7.4 1-10.1s6.9-3.1 10.1-1L272 280.9 272 16c0-8.8 7.2-16 16-16zM64.1 153.5l43.2 43.2c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L53.6 188.2c-2.2 9.9-3.8 20.1-4.7 30.5 .8 .6 1.6 1.2 2.4 2l56 56c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L49.2 263.8C61.1 385.2 163.5 480 288 480s226.9-94.8 238.8-216.2l-35.5 35.5c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l56-56c.7-.7 1.5-1.4 2.4-2-.9-10.4-2.5-20.5-4.7-30.5l-31.1 31.1c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l43.2-43.2c-12.7-32.8-32.3-62.1-57.2-86.1 .8 6.8 1.3 13.6 1.3 20.6 0 53.6-25.1 101.4-64.2 132.1 24.9 25.9 40.2 61.1 40.2 99.9 0 79.5-64.5 144-144 144S144 399.5 144 320c0-38.8 15.3-74 40.2-99.9-39.1-30.7-64.2-78.5-64.2-132.1 0-7 .4-13.9 1.3-20.6-24.8 24-44.5 53.3-57.2 86.1z"]],
    "police-box": [384, 512, [], "e021", ["M64 96l0 384 256 0 0-384c-17.7 0-32-14.3-32-32L96 64c0 17.7-14.3 32-32 32zm32 72c0-22.1 17.9-40 40-40l112 0c22.1 0 40 17.9 40 40l0 32c0 22.1-17.9 40-40 40l-40 0 0 40c0 22.1-17.9 40-40 40l-32 0c-22.1 0-40-17.9-40-40l0-112z", "M208 16c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 16-80 0c-17.7 0-32 14.3-32 32-17.7 0-32 14.3-32 32l0 384-16 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l352 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0 0-384c0-17.7-14.3-32-32-32 0-17.7-14.3-32-32-32l-80 0 0-16zm80 48c0 17.7 14.3 32 32 32l0 384-256 0 0-384c17.7 0 32-14.3 32-32l192 0zM136 128c-22.1 0-40 17.9-40 40l0 112c0 22.1 17.9 40 40 40l32 0c22.1 0 40-17.9 40-40l0-40 40 0c22.1 0 40-17.9 40-40l0-32c0-22.1-17.9-40-40-40l-112 0zm40 32l0 48-48 0 0-40c0-4.4 3.6-8 8-8l40 0zm0 80l0 40c0 4.4-3.6 8-8 8l-32 0c-4.4 0-8-3.6-8-8l0-40 48 0zm32-80l40 0c4.4 0 8 3.6 8 8l0 32c0 4.4-3.6 8-8 8l-40 0 0-48z"]],
    "dog-leashed": [576, 512, [129454], "f6d4", ["M96 192l0 272c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-112c0-5.4 2.7-10.5 7.3-13.4s10.3-3.4 15.2-1.2l20 8.9c17 7.5 35.4 10.6 53.5 9.3l0-163.6-160 0zm192 0l0 156.5c1.8-.7 3.7-1.4 5.5-2.2l20-8.9 1.9-.7c4.5-1.4 9.4-.7 13.3 1.9 4.5 3 7.3 8 7.3 13.4l0 112c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-235.2-86-36.8-26 0zm42.7-27.7l77.2 33.1 8.8-26.5 1-2.3c2.7-5.2 8.2-8.6 14.2-8.6l10.9 0 .1-.3 43.6 0C518.8 156.4 544 129.1 544 96l0-32-48 0c-4.2 0-8.3-1.7-11.3-4.7L471.4 46.1c-9-9-21.2-14.1-33.9-14.1l-79.2 0-27.6 132.3zM452 80a20 20 0 1 1 -40 0 20 20 0 1 1 40 0z", "M355.3-31.7C362.8-30.1 368-23.4 368-16l-.3 3.2-2.7 12.7 72.5 0c21.2 0 41.6 8.4 56.6 23.4l8.6 8.6 49.4 0c13.3 0 24 10.7 24 24l0 40c0 53-43 96-96 96l-36.5 0-11.5 34.6 0 237.4c0 26.5-21.5 48-48 48l-32 0c-26.5 0-48-21.5-48-48l0-87.5c-35.8 15.1-76.2 15.1-112 0l0 87.5c0 26.5-21.5 48-48 48l-32 0c-26.5 0-48-21.5-48-48l0-273.6C27.5 183 0 150.7 0 112 0 103.2 7.2 96 16 96s16 7.2 16 16c0 24.8 18.9 45.3 43.1 47.8l4.9 .2 161.7 0-140.6-132.3-2.1-2.4C94.6 19.1 95 10.7 100.3 5s13.7-6.6 20.1-2.7l2.6 2 160 150.6 5.4 5.1 10.7 0 37.3-179.2 1-3.1c2.9-6.8 10.4-10.9 17.9-9.3zM96 464c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-112c0-5.4 2.7-10.5 7.3-13.4s10.3-3.4 15.2-1.2l20 8.9c17 7.5 35.4 10.6 53.5 9.3l0-163.6-160 0 0 272zM288 348.5c1.8-.7 3.7-1.4 5.5-2.2l20-8.9 1.9-.7c4.5-1.4 9.4-.7 13.3 1.9 4.5 3 7.3 8 7.3 13.4l0 112c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-235.2-86-36.8-26 0 0 156.5zm42.7-184.2l77.2 33.1 8.8-26.5 1-2.3c2.7-5.2 8.2-8.6 14.2-8.6l48 0c35.3 0 64-28.7 64-64l0-32-48 0c-4.2 0-8.3-1.7-11.3-4.7L471.4 46.1c-9-9-21.2-14.1-33.9-14.1l-79.2 0-27.6 132.3zM432 100a20 20 0 1 1 0-40 20 20 0 1 1 0 40z"]],
    "person-hiking": [448, 512, ["hiking"], "f6ec", ["M32 160l0 96 32 0 0-128c-17.7 0-32 14.3-32 32zM168 24a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm0 144l0 104.4c0 15 7 29 18.8 38.1L216 332.8 216 168c0-13.3-10.7-24-24-24s-24 10.7-24 24z", "M192 48a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm0-80a56 56 0 1 1 0 112 56 56 0 1 1 0-112zm0 176c-13.3 0-24 10.7-24 24l0 104.4c0 15 7 29 18.8 38.1L216 332.8 216 168c0-13.3-10.7-24-24-24zm56 213.3l28.7 21.9c16.9 12.9 27.9 31.9 30.7 53l12.5 93.7c1.2 8.8-5 16.8-13.7 18s-16.8-5-18-13.7l-12.5-93.7c-1.7-12.6-8.3-24.1-18.4-31.8l-89.8-68.7c-19.8-15.1-31.4-38.6-31.4-63.5L136 168c0-30.9 25.1-56 56-56 25.5 0 49.1 13.7 61.8 35.8l29.7 52c8.5 15 24.5 24.2 41.7 24.2l58.9 0 0-112c0-8.8 7.2-16 16-16s16 7.2 16 16l0 416c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-272-58.9 0c-28.7 0-55.2-15.4-69.5-40.3l-7.7-13.4 0 155zM133.2 411.7l10.6-37.2 26.7 22.9-6.6 23.1c-3.7 13.1-10.7 25-20.4 34.6L59.3 539.3c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6L121 432.4c5.8-5.8 10-12.9 12.2-20.8zM64 128c-17.7 0-32 14.3-32 32l0 96 32 0 0-128zM0 160c0-35.3 28.7-64 64-64 17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-96z"]],
    "arrows-up-to-line": [448, 512, [], "e4c2", ["", "M16 0C7.2 0 0 7.2 0 16S7.2 32 16 32l416 0c8.8 0 16-7.2 16-16S440.8 0 432 0L16 0zm91.3 100.7c-6.2-6.2-16.4-6.2-22.6 0l-80 80c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0L80 150.6 80 496c0 8.8 7.2 16 16 16s16-7.2 16-16l0-345.4 52.7 52.7c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-80-80zm256 0c-6.2-6.2-16.4-6.2-22.6 0l-80 80c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0L336 150.6 336 496c0 8.8 7.2 16 16 16s16-7.2 16-16l0-345.4 52.7 52.7c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-80-80z"]],
    "pen-line": [576, 512, [], "e212", ["M35.5 476.5l114.1-31.7c9.3-2.6 17.8-7.5 24.6-14.4L387 217.7 294.3 125 81.6 337.8c-6.8 6.8-11.8 15.3-14.4 24.6L35.5 476.5z", "M404 32c-10.7 0-20.9 4.2-28.5 11.8l-58.5 58.5 92.7 92.7 58.5-58.5c7.6-7.6 11.8-17.8 11.8-28.5s-4.2-20.9-11.8-28.5L432.5 43.8C424.9 36.2 414.7 32 404 32zM81.6 337.8c-6.8 6.8-11.8 15.3-14.4 24.6L35.5 476.5 149.6 444.8c9.3-2.6 17.8-7.5 24.6-14.4L387 217.7 294.3 125 81.6 337.8zM352.9 21.2C366.4 7.6 384.8 0 404 0s37.6 7.6 51.1 21.2l35.7 35.7C504.4 70.4 512 88.8 512 108s-7.6 37.6-21.2 51.1l-294 294c-10.7 10.7-24.1 18.5-38.7 22.6L30.4 511.1c-8.3 2.3-17.3 0-23.4-6.2s-8.5-15.1-6.2-23.4L36.4 353.8c4.1-14.6 11.8-27.9 22.6-38.7l294-294zM272 480l288 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-288 0c-8.8 0-16-7.2-16-16s7.2-16 16-16z"]],
    "badge-percent": [512, 512, [], "f646", ["M32 256c0 28.3 15.9 53 39.4 65.4 6.8 3.6 10.1 11.5 7.8 18.8-7.8 25.4-1.6 54.1 18.4 74.1s48.7 26.2 74.1 18.4c7.3-2.3 15.2 1 18.8 7.8 12.4 23.5 37.1 39.4 65.4 39.4s53-15.9 65.4-39.4c3.6-6.8 11.5-10.1 18.8-7.8 25.4 7.8 54.1 1.6 74.1-18.4s26.2-48.7 18.4-74.1c-2.3-7.3 1-15.2 7.8-18.8 23.5-12.4 39.4-37.1 39.4-65.4s-15.9-53-39.4-65.4c-6.8-3.6-10.1-11.5-7.8-18.8 7.8-25.4 1.6-54.1-18.4-74.1s-48.7-26.2-74.1-18.4c-7.3 2.3-15.2-1-18.8-7.8-12.4-23.5-37.1-39.4-65.4-39.4s-53 15.9-65.4 39.4c-3.6 6.8-11.5 10.1-18.8 7.8-25.4-7.8-54.1-1.6-74.1 18.4s-26.2 48.7-18.4 74.1c2.3 7.3-1 15.2-7.8 18.8-23.5 12.4-39.4 37.1-39.4 65.4zm132.7 68.7l160-160c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6l-160 160c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6zM216 192a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zM344 320a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M190.6 71.4C203 47.9 227.7 32 256 32s53 15.9 65.4 39.4c3.6 6.8 11.5 10.1 18.8 7.8 25.4-7.8 54.1-1.6 74.1 18.4s26.2 48.7 18.4 74.1c-2.3 7.3 1 15.2 7.8 18.8 23.5 12.4 39.4 37.1 39.4 65.4s-15.9 53-39.4 65.4c-6.8 3.6-10.1 11.5-7.8 18.8 7.8 25.4 1.6 54.1-18.4 74.1s-48.7 26.2-74.1 18.4c-7.3-2.3-15.2 1-18.8 7.8-12.4 23.5-37.1 39.4-65.4 39.4s-53-15.9-65.4-39.4c-3.6-6.8-11.5-10.1-18.8-7.8-25.4 7.8-54.1 1.6-74.1-18.4s-26.2-48.7-18.4-74.1c2.3-7.3-1-15.2-7.8-18.8-23.5-12.4-39.4-37.1-39.4-65.4s15.9-53 39.4-65.4c6.8-3.6 10.1-11.5 7.8-18.8-7.8-25.4-1.6-54.1 18.4-74.1s48.7-26.2 74.1-18.4c7.3 2.3 15.2-1 18.8-7.8zM256 0c-36.1 0-68 18.1-87.1 45.6-33-6-68.3 3.8-93.9 29.4s-35.3 60.9-29.4 93.9C18.1 188 0 219.9 0 256s18.1 68 45.6 87.1c-6 33 3.8 68.3 29.4 93.9s60.9 35.3 93.9 29.4C188 493.9 219.9 512 256 512s68-18.1 87.1-45.6c33 6 68.3-3.8 93.9-29.4s35.3-60.9 29.4-93.9C493.9 324 512 292.1 512 256s-18.1-68-45.6-87.1c6-33-3.8-68.3-29.4-93.9s-60.9-35.3-93.9-29.4C324 18.1 292.1 0 256 0zm91.3 164.7c-6.2-6.2-16.4-6.2-22.6 0l-160 160c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l160-160c6.2-6.2 6.2-16.4 0-22.6zM192 216a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM320 344a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]],
    "mars-double": [640, 512, [9891], "f227", ["M32 304a144 144 0 1 0 288 0 144 144 0 1 0 -288 0zM348.7 446.7c6.3 .8 12.8 1.3 19.3 1.3 79.5 0 144-64.5 144-144 0-33.1-11.2-63.7-30-88-11.7 14.6-29.8 24-50 24-20.2 0-38.2-9.4-49.9-24 11.5 27 17.9 56.7 17.9 88 0 54.2-19.3 104-51.3 142.7z", "M288 48c0-8.8 7.2-16 16-16l128 0c8.8 0 16 7.2 16 16l0 128c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-89.4-104.7 104.7c25.4 30.5 40.7 69.8 40.7 112.6 0 97.2-78.8 176-176 176S0 401.2 0 304 78.8 128 176 128c42.8 0 82.1 15.3 112.6 40.7L393.4 64 304 64c-8.8 0-16-7.2-16-16zM176 448a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm146 25.9c9.6-8.3 18.6-17.4 26.7-27.2 6.3 .8 12.8 1.3 19.3 1.3 79.5 0 144-64.5 144-144 0-33.1-11.2-63.7-30-88 8.8-11 14-24.9 14-40l0-22.6 89.4-89.4-89.4 0 0-16c0-5.5-.7-10.8-2-15.9 .6-.1 1.3-.1 2-.1l128 0c8.8 0 16 7.2 16 16l0 128c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-89.4-104.7 104.7c25.4 30.5 40.7 69.8 40.7 112.6 0 97.2-78.8 176-176 176-15.9 0-31.4-2.1-46-6.1z"]],
    "thermometer": [512, 512, [], "f491", ["M128 285.3l0 98.7 98.7 0c4.2 0 8.3-1.7 11.3-4.7L458.2 159.2c14-14 21.8-32.9 21.8-52.7 0-41.2-33.4-74.5-74.5-74.5-19.8 0-38.7 7.9-52.7 21.8L342.6 64 379.3 100.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L320 86.6 262.6 144 299.3 180.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-36.7-36.7-57.4 57.4 36.7 36.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-36.7-36.7-27.3 27.3c-3 3-4.7 7.1-4.7 11.3z", "M352.8 53.8c14-14 32.9-21.8 52.7-21.8 41.1 0 74.5 33.4 74.5 74.5 0 19.8-7.8 38.7-21.8 52.7L238.1 379.3c-3 3-7.1 4.7-11.3 4.7l-98.7 0 0-98.7c0-4.2 1.7-8.3 4.7-11.3l27.3-27.3 36.7 36.7c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-36.7-36.7 57.4-57.4 36.7 36.7c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L262.6 144 320 86.6 356.7 123.3c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L342.6 64 352.8 53.8zM96 285.3l0 108.1-91.3 91.3c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l91.3-91.3 108.1 0c12.7 0 24.9-5.1 33.9-14.1L480.8 181.8c20-20 31.2-47.1 31.2-75.3 0-58.8-47.7-106.5-106.5-106.5-28.2 0-55.3 11.2-75.3 31.2L110.1 251.3c-9 9-14.1 21.2-14.1 33.9z"]],
    "paintbrush": [576, 512, [128396, "paint-brush"], "f1fc", ["M240 256.9l0 8.4c32.1 13 57.7 38.6 70.7 70.7l8.4 0c25.6 0 49.6-12.2 64.7-32.9L536.7 92.9c4.8-6.6 7.3-14.4 7.3-22.5 0-21.2-17.2-38.3-38.3-38.3-8.1 0-16 2.6-22.5 7.3L272.9 192.2c-20.7 15.1-32.9 39.1-32.9 64.7z", "M505.7 0c-14.9 0-29.3 4.7-41.4 13.5L254.1 166.3c-29 21.1-46.1 54.7-46.1 90.6l0 .1c-5.2-.7-10.6-1-16-1-70.7 0-128 57.3-128 128 0 15.5 2.8 30.4 7.8 44.2 7.6 20.8-5.8 51.8-28 51.8L16 480c-8.8 0-16 7.2-16 16s7.2 16 16 16l176 0c70.7 0 128-57.3 128-128 0-5.4-.3-10.8-1-16l.1 0c35.8 0 69.5-17.1 90.6-46.1L562.5 111.7C571.3 99.7 576 85.2 576 70.3 576 31.5 544.5 0 505.7 0zm-195 336c-13-32.1-38.6-57.7-70.7-70.7l0-8.4c0-25.6 12.2-49.6 32.9-64.7L483.1 39.3c6.6-4.8 14.4-7.3 22.5-7.3 21.2 0 38.3 17.2 38.3 38.3 0 8.1-2.6 16-7.3 22.5L383.8 303.1c-15.1 20.7-39.1 32.9-64.7 32.9l-8.4 0zM288 384c0 53-43 96-96 96l-96.4 0c.7-1.3 1.4-2.6 2.1-3.8 8.3-16.7 11.7-38.9 4.2-59-3.8-10.3-5.9-21.4-5.9-33.1 0-53 43-96 96-96s96 43 96 96z"]],
    "signal-stream": [576, 512, [], "f8dd", ["M256 256a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M98.5 60.3c6.5 6 6.9 16.1 1 22.6-41.9 45.6-67.4 106.4-67.4 173.1S57.5 383.5 99.4 429.1c6 6.5 5.5 16.6-1 22.6s-16.6 5.5-22.6-1C28.8 399.5 0 331.1 0 256S28.8 112.5 75.9 61.2c6-6.5 16.1-6.9 22.6-1zm379.1 0c6.5-6 16.6-5.5 22.6 1 47.1 51.3 75.9 119.7 75.9 194.8s-28.8 143.5-75.9 194.8c-6 6.5-16.1 6.9-22.6 1s-6.9-16.1-1-22.6C518.5 383.5 544 322.8 544 256S518.5 128.5 476.6 82.9c-6-6.5-5.5-16.6 1-22.6zM224 256a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zm64 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM185.2 155.2C159.7 181.2 144 216.7 144 256s15.7 74.8 41.2 100.8c6.2 6.3 6.1 16.4-.2 22.6s-16.4 6.1-22.6-.2C131.2 347.5 112 304 112 256s19.2-91.5 50.3-123.2c6.2-6.3 16.3-6.4 22.6-.2s6.4 16.3 .2 22.6zm228.5-22.4C444.8 164.5 464 208 464 256s-19.2 91.5-50.3 123.2c-6.2 6.3-16.3 6.4-22.6 .2s-6.4-16.3-.2-22.6c25.5-26 41.2-61.5 41.2-100.8s-15.7-74.8-41.2-100.8c-6.2-6.3-6.1-16.4 .2-22.6s16.4-6.1 22.6 .2z"]],
    "square-p": [448, 512, [], "e279", ["M32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64C46.3 64 32 78.3 32 96zm128 80c0-8.8 7.2-16 16-16l56 0c39.8 0 72 32.2 72 72s-32.2 72-72 72l-40 0 0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-160zm32 16l0 80 40 0c22.1 0 40-17.9 40-40s-17.9-40-40-40l-40 0z", "M64 64C46.3 64 32 78.3 32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm176 64l56 0c39.8 0 72 32.2 72 72s-32.2 72-72 72l-40 0 0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-160c0-8.8 7.2-16 16-16zm56 112c22.1 0 40-17.9 40-40s-17.9-40-40-40l-40 0 0 80 40 0z"]],
    "bee": [512, 512, [], "e0b2", ["M256 496l-80-80 160 0-80 80zm0-464c35.3 0 64 28.7 64 64l0 32c0 .9-.1 1.8-.2 2.7 90.9 15.2 160.2 94.2 160.2 189.3l0 48-32 0c-27.3 0-53.2-5.7-76.7-16l-230.5 0c-23.5 10.3-49.5 16-76.8 16l-32 0 0-48c0-95.2 69.3-174.2 160.1-189.3 0-.9-.1-1.8-.1-2.7l0-32c0-35.3 28.7-64 64-64zm0 160c-.2 0-.5-.1-.7-.1l0 .1 1.4 0 0-.1c-.2 0-.5 .1-.7 .1z", "M327.2 2.6c6.2-4.1 14.7-3.4 20.1 2.1s6.2 13.9 2.1 20.1l-2.1 2.5-24.6 24.6C331.1 64.5 336 79.7 336 96l0 21.6C427.7 139.3 496 221.7 496 320l0 48-.3 3.2c-1.5 7.3-8 12.8-15.7 12.8l-32 0c-21.4 0-42.1-3.3-61.6-9.3-28.8 59.8-95.4 115.9-116.2 132.4l-3.2 2.1c-3.4 1.8-7.2 2.8-11.1 2.8s-7.7-.9-11.1-2.8l-3.2-2.1c-20.7-16.5-87.4-72.6-116.2-132.4-19.4 6-40.1 9.3-61.5 9.3l-32 0c-7.7 0-14.2-5.5-15.7-12.8l-.3-3.2 0-48c0-98.4 68.3-180.7 160-202.4L176 96c0-16.3 4.9-31.5 13.2-44.1l-24.6-24.6-2.1-2.5c-4.1-6.2-3.4-14.7 2.1-20.1s13.9-6.2 20.1-2.1l2.5 2.1 24.6 24.6c12.6-8.4 27.8-13.2 44.1-13.2 16.3 0 31.4 4.9 44.1 13.2l24.6-24.6 2.5-2.1zM206.9 432c18.9 19.8 37.5 35.9 49.1 45.4 11.5-9.5 30.1-25.6 49.1-45.4l-98.1 0zm-48.8-64c5.6 10.3 12.8 21.1 21.2 32l153.5 0c8.4-10.9 15.5-21.7 21.2-32l-195.8 0zM224 144c-97.2 0-176 78.8-176 176l0 32 16 0c97.2 0 176-78.8 176-176l0-32-16 0zm48 32c0 97.2 78.8 176 176 176l16 0 0-32c0-97.2-78.8-176-176-176l-16 0 0 32zm-16 80.1c-13 31.2-33.5 58.6-59.1 79.9l118.3 0c-25.7-21.3-46.1-48.7-59.1-79.9zM256 48c-26.5 0-48 21.5-48 48l0 16.7c5.3-.4 10.6-.7 16-.7l64 0c5.4 0 10.7 .3 16 .7L304 96c0-26.5-21.5-48-48-48z"]],
    "music-slash": [576, 512, [], "f8d1", ["M224 105.7l0 63.8 8.7 8.7 247.3-55 0-67.3c0-10.2-9.5-17.8-19.5-15.6L236.5 90c-7.3 1.6-12.5 8.1-12.5 15.6zM363.3 308.8l72.8 72.8c25.5-6.3 43.9-24.3 43.9-45.6 0-26.5-28.7-48-64-48-21.9 0-41.2 8.2-52.7 20.8z", "M27.3-27.2c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l544 544c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L461.1 406.6c30.3-13.5 50.9-40 50.9-70.6l0-280.1C512 25.2 483.6 2.4 453.6 9l-224 49.8c-22 4.9-37.6 24.4-37.6 46.9l0 31.8-164.7-164.7zM232.7 178.1l-8.7-8.7 0-63.8c0-7.5 5.2-14 12.5-15.6l224-49.8c10-2.2 19.5 5.4 19.5 15.6l0 67.3-247.3 55zm26.8 26.8l220.5-49 0 120.4c-17-12.7-39.4-20.4-64-20.4-30.5 0-57.6 11.8-75.2 30.3l-81.3-81.3zM363.3 308.8c11.5-12.5 30.8-20.8 52.7-20.8 35.3 0 64 21.5 64 48 0 21.2-18.4 39.3-43.9 45.6l-72.8-72.8zM192 340.4c-17-12.7-39.4-20.4-64-20.4-53 0-96 35.8-96 80s43 80 96 80 96-35.8 96-80l0-117.5-32-32 0 89.9zm0 59.6c0 26.5-28.7 48-64 48s-64-21.5-64-48 28.7-48 64-48 64 21.5 64 48z"]],
    "person-simple": [192, 512, [], "e220", ["M32 224l0 64c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-64 0c-17.7 0-32 14.3-32 32zM64 64a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M128 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM32 64A64 64 0 1 1 160 64 64 64 0 1 1 32 64zM64 192c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-64 0zM0 224c0-35.3 28.7-64 64-64l64 0c35.3 0 64 28.7 64 64l0 64c0 23.7-12.9 44.4-32 55.4L160 496c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-144-64 0 0 144c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-152.6C12.9 332.4 0 311.7 0 288l0-64z"]],
    "album-collection-circle-user": [576, 512, [], "e48f", ["M48.6 210c-.6-4.6 .8-9.1 3.9-12.6s7.4-5.4 12-5.4l384 0c4.6 0 9 2 12 5.4s4.5 8 3.9 12.6l-.1 .6c-10.3-1.7-21-2.6-31.8-2.6-39.1 0-75.5 11.7-105.8 31.8-20.5-10-44.5-15.8-70.2-15.8-75.7 0-137.1 50.1-137.1 112 0 59.1 56.1 107.5 127.1 111.7 2.9 11.2 6.7 22 11.4 32.3L96.5 480c-8.1 0-14.9-6-15.9-14l-32-256z", "M128.5 16c0 8.8 7.2 16 16 16l224 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-224 0c-8.8 0-16 7.2-16 16zm-48 80c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-320 0c-8.8 0-16 7.2-16 16zm-28 101.4c3-3.4 7.4-5.4 12-5.4l384 0c4.6 0 9 2 12 5.4l0 0c3 3.4 4.5 8 3.9 12.6l-.1 .6c10.7 1.8 21.2 4.5 31.3 8l.6-4.6c1.7-13.7-2.5-27.4-11.6-37.7s-22.2-16.2-36-16.2l-384 0c-13.8 0-26.9 5.9-36 16.2S15.2 200.3 16.9 214l32 256c3 24 23.4 42 47.6 42l180 0c-7.2-10-13.4-20.7-18.6-32L96.5 480c-8.1 0-14.9-6-15.9-14l-32-256c-.6-4.6 .8-9.1 3.9-12.6zm204 26.6c-75.7 0-137.1 50.1-137.1 112 0 59.1 56.1 107.5 127.1 111.7-2.7-10.5-4.5-21.4-5.4-32.5-55.4-6-89.7-43.9-89.7-79.2 0-38.4 40.7-80 105.1-80 15.4 0 29.5 2.4 42 6.5 8.7-8.4 18.1-16.1 28.2-22.8-20.5-10-44.5-15.8-70.2-15.8zm0 88c-16.2 0-29.4 10.7-29.4 24 0 9.9 7.4 18.5 18 22.1 3.6-16.1 9.2-31.5 16.5-45.8-1.7-.2-3.4-.4-5.1-.4zm116 182.6c7.8-9.1 19.4-14.6 31.8-14.6l56.4 0c12.4 0 23.9 5.5 31.8 14.6-17.3 11-37.9 17.4-60 17.4s-42.7-6.4-60-17.4zm144.3-20.8c-13.8-16.1-34.2-25.8-56.1-25.8l-56.4 0c-21.8 0-42.2 9.6-56.1 25.8-17.3-19.7-27.7-45.5-27.7-73.8 0-61.9 50.1-112 112-112s112 50.1 112 112c0 28.2-10.5 54.1-27.7 73.8zM576.5 400a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-144-48a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm0 80a56 56 0 1 0 0-112 56 56 0 1 0 0 112z"]],
    "whale": [640, 512, [128011], "f72c", ["M32 317.6C32 389.6 90.4 448 162.4 448L544 448c35.3 0 64-28.7 64-64l0-108.3c0-63.9-51.8-115.7-115.7-115.7-73.2 0-144.2 24.9-201.4 70.7L161.6 334.1c-14.5 11.6-32.4 17.9-50.9 17.9l-3.2 0c-28.9 0-55.4-16.4-68.4-42.2-2.2-4.3-3.9-8.8-5.2-13.3-1.3 6.9-1.9 14-1.9 21.2zm85.2-207.8l8.7 52.2 52.2 8.7c15.3 2.5 30.9-2.4 41.8-13.4l18.7-18.7-65.3-10.9c-6.7-1.1-12-6.4-13.2-13.2L149.3 49.3 130.6 68c-11 11-16 26.5-13.4 41.8zM416 296a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M164.9 .8c5.7 1.8 9.9 6.7 10.9 12.6l14.1 84.7 84.7 14.1c5.9 1 10.8 5.2 12.6 10.9s.3 12-3.9 16.2L242.6 180c-18.3 18.3-44.2 26.6-69.7 22.3L111 192 70.8 250.4c-9.2 13.3-10.4 30.6-3.1 45 7.5 15 22.9 24.6 39.7 24.6l3.2 0c11.3 0 22.2-3.8 31-10.9L270.9 205.7C333.8 155.4 411.8 128 492.3 128 573.9 128 640 194.1 640 275.7L640 384c0 53-43 96-96 96l-381.6 0C72.7 480 0 407.3 0 317.6 0 278.2 15.7 240.3 43.6 212.4l46.5-46.5 3.4-3.4-7.9-47.4C81.4 89.6 89.7 63.7 108 45.4L148.7 4.7c4.2-4.2 10.5-5.8 16.2-3.9zM149.3 49.3L130.6 68c-11 11-16 26.5-13.4 41.8l8.7 52.2 52.2 8.7c15.3 2.5 30.9-2.4 41.8-13.4l18.7-18.7-65.3-10.9c-6.7-1.1-12-6.4-13.2-13.2L149.3 49.3zM368 296a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm-334.1 .5c-1.3 6.9-1.9 14-1.9 21.2 0 72 58.4 130.4 130.4 130.4L544 448c35.3 0 64-28.7 64-64l0-108.3c0-63.9-51.8-115.7-115.7-115.7-73.2 0-144.2 24.9-201.4 70.7L161.6 334.1c-14.5 11.6-32.4 17.9-50.9 17.9l-3.2 0c-28.9 0-55.4-16.4-68.4-42.2-2.2-4.3-3.9-8.8-5.2-13.3z"]],
    "arrow-up-triangle-square": [512, 512, ["sort-shapes-up"], "f88a", ["M309.3 192L458.7 192 384 67.5 309.3 192zM320 336l0 96c0 8.8 7.2 16 16 16l96 0c8.8 0 16-7.2 16-16l0-96c0-8.8-7.2-16-16-16l-96 0c-8.8 0-16 7.2-16 16z", "M139.3 36.7c-6.2-6.2-16.4-6.2-22.6 0l-96 96c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0L112 86.6 112 464c0 8.8 7.2 16 16 16s16-7.2 16-16l0-377.4 68.7 68.7c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-96-96zM320 432l0-96c0-8.8 7.2-16 16-16l96 0c8.8 0 16 7.2 16 16l0 96c0 8.8-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16zM384 67.5L458.7 192 309.3 192 384 67.5zM275.6 186c-2.3 3.9-3.6 8.4-3.6 12.9 0 13.8 11.2 25.1 25.1 25.1l173.9 0c13.8 0 25.1-11.2 25.1-25.1 0-4.5-1.2-9-3.6-12.9L408.2 45.7C403.1 37.2 393.9 32 384 32s-19.1 5.2-24.2 13.7L275.6 186zM288 432c0 26.5 21.5 48 48 48l96 0c26.5 0 48-21.5 48-48l0-96c0-26.5-21.5-48-48-48l-96 0c-26.5 0-48 21.5-48 48l0 96z"]],
    "neuter": [384, 512, [9906], "f22c", ["M48 176a144 144 0 1 0 288 0 144 144 0 1 0 -288 0z", "M48 176a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zM208 351.3c89.7-8.1 160-83.5 160-175.3 0-97.2-78.8-176-176-176S16 78.8 16 176c0 91.8 70.3 167.2 160 175.3L176 496c0 8.8 7.2 16 16 16s16-7.2 16-16l0-144.7z"]],
    "square-phone-flip": [448, 512, ["phone-square-alt"], "f87b", ["M32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64C46.3 64 32 78.3 32 96zM88.5 337.9c-9.4-24.3 2.3-51.6 26.3-61.6l21.4-8.9c19.3-8 41.6-2.7 55.1 13.3l3 3.5c24-13.9 43.7-34.3 56.7-58.9l-2.3-2c-16-13.5-21.3-35.8-13.3-55.1l8.9-21.4c10-24 37.4-35.7 61.6-26.3l2 .8c31.3 12.1 58.2 45 50.7 85.4-17.3 93.3-90.8 166.7-184.1 184.1-40.4 7.5-73.3-19.4-85.4-50.7l-.8-2z", "M64 64C46.3 64 32 78.3 32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm294.4 54.3c-8.1-3.1-17.2 .8-20.5 8.8l-8.9 21.4c-2.7 6.4-.9 13.9 4.4 18.4l11.8 10c5.4 4.6 7.1 12.1 4.4 18.5-17.3 40.1-48.8 72.7-88.2 91.4-6.6 3.1-14.4 1.4-19.1-4.1l-11.3-13.3c-4.5-5.3-11.9-7.1-18.4-4.4l-21.4 8.9c-8 3.3-11.9 12.5-8.8 20.5l.8 2c8 20.7 28.1 34.9 49.7 30.8 80.3-14.9 143.5-78.2 158.5-158.5 4-21.6-10.1-41.7-30.8-49.7l-2-.8zm-50.1-3.5c10-24 37.4-35.7 61.6-26.3l2 .8c31.3 12.1 58.2 45 50.7 85.4-17.3 93.3-90.8 166.7-184.1 184.1-40.4 7.5-73.3-19.4-85.4-50.7l-.8-2c-9.4-24.3 2.3-51.6 26.3-61.6l21.4-8.9c19.3-8 41.6-2.7 55.1 13.3l3 3.5c24-13.9 43.7-34.3 56.7-58.9l-2.3-2c-16-13.5-21.3-35.8-13.3-55.1l8.9-21.4z"]],
    "circle-g": [512, 512, [], "e10f", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm120 0c0-57.4 46.6-104 104-104 26.6 0 50.9 10 69.3 26.5 6.6 5.9 7.1 16 1.3 22.6s-16 7.1-22.6 1.3c-12.7-11.4-29.5-18.3-48-18.3-39.8 0-72 32.2-72 72s32.2 72 72 72c34.3 0 63-23.9 70.2-56L272 272c-8.8 0-16-7.2-16-16s7.2-16 16-16l72 0c8.8 0 16 7.2 16 16 0 57.4-46.6 104-104 104S152 313.4 152 256z", "M256 32a224 224 0 1 1 0 448 224 224 0 1 1 0-448zm0 480a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM184 256c0-39.8 32.2-72 72-72 18.5 0 35.2 6.9 48 18.3 6.6 5.9 16.7 5.3 22.6-1.3s5.3-16.7-1.3-22.6c-18.4-16.5-42.7-26.5-69.3-26.5-57.4 0-104 46.6-104 104s46.6 104 104 104 104-46.6 104-104c0-8.8-7.2-16-16-16l-72 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l54.2 0c-7.3 32.1-36 56-70.2 56-39.8 0-72-32.2-72-72z"]],
    "circle-down-right": [512, 512, [], "e108", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm119-65l40-40c9.4-9.4 24.6-9.4 33.9 0l59 59 27-27c15-15 41-4.3 41 17l0 128c0 13.3-10.7 24-24 24l-128 0c-21.2 0-32-26-17-41l27-27-59-59c-9.4-9.4-9.4-24.6 0-33.9z", "M256 480a224 224 0 1 1 0-448 224 224 0 1 1 0 448zM256 0a256 256 0 1 0 0 512 256 256 0 1 0 0-512zm64 219.3l0 100.7-100.7 0 24.7-24.7c6.2-6.2 6.2-16.4 0-22.6L179.3 208 208 179.3 272.7 244c3 3 7.1 4.7 11.3 4.7s8.3-1.7 11.3-4.7L320 219.3zM328 352c13.3 0 24-10.7 24-24l0-128c0-21.2-26-32-41-17l-27 27-59-59c-9.4-9.4-24.6-9.4-33.9 0l-40 40c-9.4 9.4-9.4 24.6 0 33.9l59 59-27 27c-15 15-4.3 41 17 41l128 0z"]],
    "people-dress": [576, 512, [], "e217", ["M76.1 352l167.9 0-62-190.5c-3.1-9.5-12-15.9-21.9-15.9s-18.9 6.4-21.9 15.9L76.1 352zM136 24a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zM332.1 352l167.9 0-62-190.5c-3.1-9.5-12-15.9-21.9-15.9s-18.9 6.4-21.9 15.9L332.1 352zM392 24a24 24 0 1 0 48 0 24 24 0 1 0 -48 0z", "M160 0a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm0 80a56 56 0 1 0 0-112 56 56 0 1 0 0 112zM96 384l0 144c0 8.8 7.2 16 16 16s16-7.2 16-16l0-144 64 0 0 144c0 8.8 7.2 16 16 16s16-7.2 16-16l0-144 42 0c10.9 0 18.6-10.6 15.2-21L239.6 235.2 274.3 293c2.9 4.8 8.1 7.8 13.7 7.8s10.8-3 13.7-7.8l34.7-57.9-41.6 127.9c-3.4 10.3 4.3 21 15.2 21l42 0 0 144c0 8.8 7.2 16 16 16s16-7.2 16-16l0-144 64 0 0 144c0 8.8 7.2 16 16 16s16-7.2 16-16l0-144 42 0c10.9 0 18.6-10.6 15.2-21L486.7 208 546.9 294c5.1 7.2 15 9 22.3 3.9s9-15 3.9-22.3L478.7 140.7c-14-20-36.9-31.9-61.4-31.9-26.3 0-50.7 13.8-64.2 36.4L288 253.7 222.9 145.2c-13.5-22.6-37.9-36.4-64.2-36.4-24.4 0-47.3 11.9-61.3 31.9L2.9 275.6c-5.1 7.2-3.3 17.2 3.9 22.3S24 301.2 29.1 294L89.3 208 38.8 363c-3.4 10.3 4.3 21 15.2 21l42 0zm147.9-32l-167.9 0 62-190.5c3.1-9.5 12-15.9 21.9-15.9s18.9 6.4 21.9 15.9l62 190.5zM416 0a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm0 80a56 56 0 1 0 0-112 56 56 0 1 0 0 112zm83.9 272l-167.9 0 62-190.5c3.1-9.5 12-15.9 21.9-15.9s18.9 6.4 21.9 15.9l62 190.5z"]],
    "circle-half": [512, 512, [], "e110", ["M32 256c0 112.8 83.5 206.2 192 221.7l0-443.5C115.5 49.8 32 143.2 32 256z", "M224 34.3C115.5 49.8 32 143.2 32 256s83.5 206.2 192 221.7l0-443.5zM224.1 2C241.6-.2 256 14.3 256 32l0 448C256 497.7 241.6 512.2 224.1 510 97.8 494.3 0 386.6 0 256S97.8 17.7 224.1 2z"]],
    "face-grin-tongue-squint": [512, 512, [128541, "grin-tongue-squint"], "f58a", ["M32 256C32 132.3 132.3 32 256 32S480 132.3 480 256c0 69.1-31.3 130.9-80.5 172-1.4 17-5.8 33.2-12.6 48-37.8 22.5-81.9 35.6-129 36 52.1-1 94.1-43.6 94.1-96l0-63.3c15-5.2 28.7-11.7 40.6-19.2 7.5-4.7 9.7-14.6 4.9-22.1s-14.6-9.7-22.1-4.9c-10 6.3-21.9 11.9-35.3 16.5l-36.3 9.1c-9.5 1.6-19.5 2.8-29.7 3.4-15.2 .5-29.6 .2-42.8-.5-7.9-.7-15.6-1.6-23-2.9L171.9 323c-13.4-4.6-25.3-10.2-35.3-16.5-7.5-4.7-17.3-2.5-22.1 4.9s-2.5 17.4 4.9 22.1c11.8 7.5 25.5 14 40.6 19.2l0 63.3c0 52.4 41.9 95 94.1 96-47.1-.3-91.2-13.4-129-36-6.8-14.8-11.2-31-12.6-48-49.2-41.1-80.5-102.9-80.5-172zm89.3-95.2c-4 7.9-.7 17.5 7.2 21.5l51.4 25.7-51.4 25.7c-7.9 4-11.1 13.6-7.2 21.5s13.6 11.1 21.5 7.2l80-40c5.4-2.7 8.8-8.3 8.8-14.3s-3.4-11.6-8.8-14.3l-80-40c-7.9-4-17.5-.7-21.5 7.2zM280.4 208c0 6.1 3.4 11.6 8.8 14.3l80 40c7.9 4 17.5 .7 21.5-7.2s.7-17.5-7.2-21.5l-51.4-25.7 51.4-25.7c7.9-4 11.1-13.6 7.2-21.5s-13.6-11.1-21.5-7.2l-80 40c-5.4 2.7-8.8 8.3-8.8 14.3z", "M480 256c0 69.1-31.3 130.9-80.5 172-1.4 17-5.8 33.2-12.6 48 74.9-44.7 125.1-126.5 125.1-220 0-141.4-114.6-256-256-256S0 114.6 0 256c0 93.5 50.2 175.4 125.1 220-6.8-14.8-11.2-31-12.6-48-49.2-41.1-80.5-102.9-80.5-172 0-123.7 100.3-224 224-224S480 132.3 480 256zM256 336c-16.8 0-32.8-1.4-47.8-3.9L171.9 323c-13.4-4.6-25.3-10.2-35.3-16.5-7.5-4.7-17.3-2.5-22.1 4.9s-2.5 17.4 4.9 22.1c11.8 7.5 25.5 14 40.6 19.2l0 63.3c0 53 43 96 96 96s96-43 96-96l0-63.3c15-5.2 28.7-11.7 40.6-19.2 7.5-4.7 9.7-14.6 4.9-22.1s-14.6-9.7-22.1-4.9c-10 6.3-21.9 11.9-35.3 16.5l-36.3 9.1c-15 2.5-31 3.9-47.8 3.9zM128.5 182.3l51.4 25.7-51.4 25.7c-7.9 4-11.1 13.6-7.2 21.5s13.6 11.1 21.5 7.2l80-40c5.4-2.7 8.8-8.3 8.8-14.3s-3.4-11.6-8.8-14.3l-80-40c-7.9-4-17.5-.7-21.5 7.2s-.7 17.5 7.2 21.5zm262.2-21.5c-4-7.9-13.6-11.1-21.5-7.2l-80 40c-5.4 2.7-8.8 8.3-8.8 14.3s3.4 11.6 8.8 14.3l80 40c7.9 4 17.5 .7 21.5-7.2s.7-17.5-7.2-21.5l-51.4-25.7 51.4-25.7c7.9-4 11.1-13.6 7.2-21.5zM320 416c0 35.3-28.7 64-64 64s-64-28.7-64-64l0-21.4c0-14.7 11.9-26.6 26.6-26.6l2 0c11.3 0 21.1 7.9 23.6 18.9 2.8 12.6 20.8 12.6 23.6 0 2.5-11.1 12.3-18.9 23.6-18.9l2 0c14.7 0 26.6 11.9 26.6 26.6l0 21.4z"]],
    "pickaxe": [576, 512, [], "e5bf", ["M219.9 23.5C356.4 78.7 465.3 187.6 520.5 324.1 535.5 294 544 260 544 224 544 100.3 443.7 0 320 0 284 0 250 8.5 219.9 23.5z", "M544 224C544 260 535.5 294 520.5 324.1 465.3 187.6 356.4 78.7 219.9 23.5 250 8.5 284 0 320 0 443.7 0 544 100.3 544 224zM502.1 366.7c4 12.1 19.5 15.6 26.9 5.2 29.6-41.8 47-92.8 47-147.9 0-64.9-24.2-124.2-64-169.4l27.3-27.3c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0L489.4 32c-45.1-39.8-104.4-64-169.4-64-55.1 0-106.2 17.4-147.9 47-10.4 7.3-6.8 22.9 5.2 26.9 71.3 23.7 135.7 62.6 189.2 112.9L36.7 484.7c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0L389.2 177.4c50.3 53.5 89.2 117.9 112.9 189.2z"]],
    "comment-dollar": [512, 512, [], "f651", ["M32 240c0 46.7 16.5 89.8 44.8 124.8 8.1 10.1 9.4 24.1 3.2 35.4l-40.2 73.6 101-43.3c7.9-3.4 16.8-3.5 24.8-.2 27.6 11.3 58.2 17.6 90.4 17.6 125.7 0 224-95 224-208S381.7 32 256 32 32 127 32 240zm160-33.7c0-25.6 20.7-46.3 46.3-46.3l1.7 0 0-8c0-8.8 7.2-16 16-16s16 7.2 16 16l0 8 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-49.7 0c-7.9 0-14.3 6.4-14.3 14.3 0 7 5.1 13 12 14.1l45.3 7.6c22.3 3.7 38.7 23 38.7 45.7 0 25.6-20.7 46.3-46.3 46.3l-1.7 0 0 8c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-8-24 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l57.7 0c7.9 0 14.3-6.4 14.3-14.3 0-7-5.1-13-12-14.1L230.7 252c-22.3-3.7-38.7-23-38.7-45.7z", "M80 400.2c6.2-11.4 4.9-25.4-3.2-35.4-28.2-34.9-44.8-78.1-44.8-124.8 0-113 98.3-208 224-208s224 95 224 208-98.3 208-224 208c-32.3 0-62.8-6.3-90.4-17.6-7.9-3.3-16.9-3.2-24.8 .2L39.8 473.8 80 400.2zM0 240c0 54.4 19.3 104.6 51.9 144.9L3.1 474.3c-2 3.7-3.1 7.9-3.1 12.2 0 14.1 11.4 25.5 25.5 25.5 4 0 7.8-.6 11.5-2.1L153.4 460c31.4 12.9 66.1 20 102.6 20 141.4 0 256-107.5 256-240S397.4 0 256 0 0 107.5 0 240zM256 136c-8.8 0-16 7.2-16 16l0 8-1.7 0c-25.6 0-46.3 20.7-46.3 46.3 0 22.6 16.4 42 38.7 45.7l45.3 7.6c6.9 1.1 12 7.1 12 14.1 0 7.9-6.4 14.3-14.3 14.3L216 288c-8.8 0-16 7.2-16 16s7.2 16 16 16l24 0 0 8c0 8.8 7.2 16 16 16s16-7.2 16-16l0-8 1.7 0c25.6 0 46.3-20.7 46.3-46.3 0-22.6-16.4-42-38.7-45.7L236 220.4c-6.9-1.2-12-7.1-12-14.1 0-7.9 6.4-14.3 14.3-14.3l49.7 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0 0-8c0-8.8-7.2-16-16-16z"]],
    "list-timeline": [512, 512, [], "e1d1", ["M182.6 80l32 32 201.4 0 0-64-201.4 0-32 32zm0 176l32 32 265.4 0 0-64-265.4 0-32 32zm0 176l32 32 201.4 0 0-64-201.4 0-32 32z", "M214.6 16L416 16c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-201.4 0c-8.5 0-16.6-3.4-22.6-9.4L148.7 91.3c-6.2-6.2-6.2-16.4 0-22.6L192 25.4c6-6 14.1-9.4 22.6-9.4zm0 32l-32 32 32 32 201.4 0 0-64-201.4 0zM56 104a24 24 0 1 1 0-48 24 24 0 1 1 0 48zm0 176a24 24 0 1 1 0-48 24 24 0 1 1 0 48zM32 432a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm182.6-64L416 368c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-201.4 0c-8.5 0-16.6-3.4-22.6-9.4l-43.3-43.3c-6.2-6.2-6.2-16.4 0-22.6L192 377.4c6-6 14.1-9.4 22.6-9.4zm0 32l-32 32 32 32 201.4 0 0-64-201.4 0zM192 201.4c6-6 14.1-9.4 22.6-9.4L480 192c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-265.4 0c-8.5 0-16.6-3.4-22.6-9.4l-43.3-43.3c-6.2-6.2-6.2-16.4 0-22.6L192 201.4zM480 224l-265.4 0-32 32 32 32 265.4 0 0-64z"]],
    "swords-laser": [640, 512, [], "e03d", ["M51.3-12.6c3-3 7.7-3.1 10.8-.3L374.7 272 295.2 272 51-1.9c-2.8-3.1-2.6-7.8 .3-10.7zM361.4 157.1L376 170.3 578.1-12.9c3.1-2.8 7.8-2.7 10.7 .3s3 7.6 .3 10.7l-182 200.6 13.5 12.3-.3 .3-59.1-54 .3-.2z", "M35.4 454.1L202.6 286.8c-.5 15.1 4.9 30.8 17.7 43.6l56 56-154.3 154.3c-18.7 18.7-49.1 18.7-67.9 0L35.4 521.9c-18.7-18.7-18.7-49.1 0-67.9zM612.7 19.5L430.7 220.2 407.1 198.6 589-2c2.8-3.1 2.7-7.8-.3-10.7s-7.6-3-10.7-.3L376 170.3 352.2 148.7 556.6-36.7c15.7-14.2 39.8-13.7 54.8 1.3S627 3.8 612.7 19.5zM192.1 342.6l-25.4 25.4 41.4 41.4 25.4-25.4-41.4-41.4zM185.4 432L144.1 390.6 58 476.7c-6.2 6.2-6.2 16.4 0 22.6l18.7 18.7c6.2 6.2 16.4 6.2 22.6 0L185.4 432zM51.3-12.6C48.4-9.7 48.2-5 51-1.9L295.2 272 374.7 272 62.1-12.9c-3.1-2.8-7.9-2.7-10.8 .3zM83.7-36.5l338.6 308.5 12.6 0c8.5 0 16.6 3.4 22.6 9.4L606.1 430.1c18.7 18.7 18.7 49.1 0 67.9L562 542.1c-18.7 18.7-49.1 18.7-67.9 0L251.4 299.3c-7.8-7.8-5.3-20 3-25L27.1 19.4c-14.1-15.8-13.4-39.7 1.6-54.7 15-15 39.3-15.6 55-1.3zM583.5 475.3c6.2-6.2 6.2-16.4 0-22.6l-74.7-74.7-22.1 22.1 86.1 86.1 10.7-10.7zm-44.1 44.1l10.7-10.7-86.1-86.1-22.1 22.1 74.7 74.7c6.2 6.2 16.4 6.2 22.6 0zm-120-97.4l66.7-66.7-51.3-51.3-133.5 0 118.1 118.1z"]],
    "phone-waveform": [640, 512, [], "e6e2", ["M98.2 157.4C131.6 318 258 444.4 418.7 477.9 476.9 490 527.1 448.2 541.6 394.9l1.8-6.7c2.3-8.4-2-17.2-10.1-20.6l-93.3-38.9c-7.1-2.9-15.2-.9-20.1 5l-36.6 44.7c-4.7 5.7-12.6 7.5-19.2 4.3-75-35.6-135-97.6-168.1-174-2.8-6.6-1-14.2 4.6-18.7l41.6-34.1c5.9-4.8 8-13 5-20.1L208.3 42.7c-3.4-8-12.2-12.3-20.6-10.1l-6.7 1.8C127.9 49 86.1 99.1 98.2 157.4z", "M464-16c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 224c0 8.8 7.2 16 16 16s16-7.2 16-16l0-224zm80 32c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 160c0 8.8 7.2 16 16 16s16-7.2 16-16l0-160zM384 32c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 128c0 8.8 7.2 16 16 16s16-7.2 16-16l0-128zM624 64c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16s16-7.2 16-16l0-64zM187.8 32.6c8.4-2.3 17.2 2 20.6 10.1L247.2 136c2.9 7.1 .9 15.2-5 20.1l-41.6 34.1c-5.5 4.5-7.4 12.2-4.6 18.7 33.1 76.4 93.1 138.4 168.1 174 6.6 3.2 14.6 1.4 19.2-4.3L420 333.8c4.8-5.9 13-8 20.1-5l93.3 38.9c8 3.4 12.3 12.2 10.1 20.6l-1.8 6.7C527.1 448.2 476.9 490 418.7 477.9 258 444.4 131.6 318 98.2 157.4 86.1 99.1 127.9 49 181.1 34.4l6.7-1.8zm50.1-2.3C228.3 7.5 203.3-4.8 179.4 1.7l-6.7 1.8c-65 17.7-122.3 81.2-105.9 160.3 36 173.1 172.2 309.3 345.3 345.3 79.1 16.5 142.6-40.9 160.3-105.9l1.8-6.7c6.5-23.9-5.7-49-28.6-58.5l-93.3-38.9c-20.1-8.4-43.4-2.6-57.2 14.3l-28.5 34.9c-59.3-31.1-107.3-80.8-136.3-141.3l32.1-26.3c16.9-13.8 22.7-37 14.3-57.2L237.9 30.4z"]],
    "hippo": [640, 512, [129435], "f6ed", ["M64 256c0-88.4 71.6-160 160-160l68.9 0c26.5 0 52.7 5 77.2 14.9l18.2 7.3c-2.8 8.1-4.3 16.8-4.3 25.9l0 5c0 9.5-4.5 18.4-10.8 25.6-13.2 15.4-21.2 35.4-21.2 57.3 0 45.9 35.1 83.6 80 87.6l0 16.4c0 8.8 7.2 16 16 16l0 32c-12.3 0-23.5-4.6-32-12.2l0 52.2c0 13.3-10.7 24-24 24l-32 0c-13.3 0-24-10.7-24-24l0-60.1c0-5.1-2.4-9.9-6.5-12.9s-9.4-3.9-14.3-2.4l-11.3 3.6c-31.2 9.8-64.6 9.8-95.8 0l-11.3-3.6c-4.9-1.5-10.2-.6-14.3 2.4s-6.5 7.8-6.5 12.9l0 60.1c0 13.3-10.7 24-24 24l-32 0c-13.3 0-24-10.7-24-24l0-72c0-8.8-7.2-16-16-16s-16 7.2-16 16c0-25.6 0-51.1 0-76.7 0-8.1 0-14.5 0-19.3zm320-24c0-14 5.1-26.7 13.5-36.5 9.2-10.7 18.5-26.7 18.5-46.5l0-5c0-26.5 21.5-48 48-48l48 0c26.5 0 48 21.5 48 48 0 13.4 5.5 24.7 13.2 33-25.7 5.1-45.2 27.7-45.2 55 0 8.8 7.2 16 16 16s16-7.2 16-16c0-13.3 10.7-24 24-24s24 10.7 24 24c0 30.9-25.1 56-56 56l-112 0c-30.9 0-56-25.1-56-56zm40-40c0 8.8 7.2 16 16 16 13.3 0 24 10.7 24 24 0 8.8 7.2 16 16 16s16-7.2 16-16c0-30.9-25.1-56-56-56-8.8 0-16 7.2-16 16zm24-48a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm64 0a16 16 0 1 0 32 0 16 16 0 1 0 -32 0z", "M427.3 44.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l12.1 12.1c-4.4 3.2-8.4 6.8-12 10.8L382 81.2C353.6 69.8 323.4 64 292.9 64L224 64c-106 0-192 86-192 192 0 11.5 0 8.5 0 27.1 0 25.4-8.7 50.1-24.5 70L3.5 358C-2 364.9-.9 375 6 380.5s17 4.4 22.5-2.5l3.9-4.9c20.4-25.5 31.6-57.3 31.6-90 0-33.7 0-14.1 0-27.1 0-88.4 71.6-160 160-160l68.9 0c26.5 0 52.7 5 77.2 14.9l18.2 7.3c-2.8 8.1-4.3 16.8-4.3 25.9l0 5c0 9.5-4.5 18.4-10.8 25.6-13.2 15.4-21.2 35.4-21.2 57.3 0 45.9 35.1 83.6 80 87.6l0 16.4c0 8.8 7.2 16 16 16s16-7.2 16-16l0-16 88 0c2.7 0 5.4-.1 8-.4l0 16.4c0 8.8 7.2 16 16 16s16-7.2 16-16l0-25.6c28.5-14.6 48-44.2 48-78.4 0-30.8-15.8-57.8-39.7-73.6-4.9-3.2-8.3-8.5-8.3-14.4 0-22.4-9.2-42.7-24.1-57.3l11.4-11.4c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0L540.2 69.1C531.5 65.8 521.9 64 512 64l-48 0c-5.4 0-10.7 .5-15.8 1.6L427.3 44.7zM448 288l-8 0c-30.9 0-56-25.1-56-56 0-14 5.1-26.7 13.5-36.5 9.2-10.7 18.5-26.7 18.5-46.5l0-5c0-26.5 21.5-48 48-48l48 0c26.5 0 48 21.5 48 48 0 13.4 5.5 24.7 13.2 33-25.7 5.1-45.2 27.7-45.2 55 0 8.8 7.2 16 16 16s16-7.2 16-16c0-13.3 10.7-24 24-24s24 10.7 24 24c0 30.9-25.1 56-56 56l-104 0zm-32 83.8l0 52.2c0 13.3-10.7 24-24 24l-32 0c-13.3 0-24-10.7-24-24l0-60.1c0-5.1-2.4-9.9-6.5-12.9s-9.4-3.9-14.3-2.4l-11.3 3.6c-31.2 9.8-64.6 9.8-95.8 0l-11.3-3.6c-4.9-1.5-10.2-.6-14.3 2.4s-6.5 7.8-6.5 12.9l0 60.1c0 13.3-10.7 24-24 24l-32 0c-13.3 0-24-10.7-24-24l0-72c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 72c0 30.9 25.1 56 56 56l32 0c30.9 0 56-25.1 56-56l0-38.6c31.5 8.1 64.5 8.1 96 0l0 38.6c0 30.9 25.1 56 56 56l32 0c30.9 0 56-25.1 56-56l0-40c-12.3 0-23.5-4.6-32-12.2zM480 144a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm-40 32c-8.8 0-16 7.2-16 16s7.2 16 16 16c13.3 0 24 10.7 24 24 0 8.8 7.2 16 16 16s16-7.2 16-16c0-30.9-25.1-56-56-56zm88-16a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"]],
    "sword-laser-alt": [640, 512, [], "e03c", ["M265.4 272l79.5 0 244.2-273.9c2.8-3.1 2.6-7.8-.3-10.7-3-3-7.7-3.1-10.8-.3L265.4 272z", "M578-12.9L265.4 272 344.9 272 589.1-1.9c2.8-3.1 2.6-7.8-.3-10.7-3-3-7.7-3.1-10.8-.3zM217.9 272L556.5-36.5c15.7-14.3 39.9-13.8 55 1.3 14.9 14.9 15.6 38.9 1.6 54.7L385.8 274.3c8.3 5 10.8 17.2 3 25L146 542.1c-18.7 18.7-49.1 18.7-67.9 0L34 497.9c-18.7-18.7-18.7-49.1 0-67.9L182.7 281.4c6-6 14.1-9.4 22.6-9.4l12.6 0zM67.4 486.1l86.1-86.1-22.1-22.1-74.7 74.7c-6.2 6.2-6.2 16.4 0 22.6l10.7 10.7zM90 508.7l10.7 10.7c6.2 6.2 16.4 6.2 22.6 0l74.7-74.7-22.1-22.1-86.1 86.1zM338.8 304l-133.5 0-51.3 51.3 66.7 66.7 118.1-118.1z"]],
    "flower": [448, 512, [127804, 10047], "f7ff", ["M32 168c0 25.7 9.3 49.1 24.7 67.3 10.1 11.9 10.1 29.5 0 41.4-15.4 18.2-24.7 41.6-24.7 67.3 0 57.4 46.6 104 104 104 25.7 0 49.1-9.3 67.3-24.7 11.9-10.1 29.5-10.1 41.4 0 18.2 15.4 41.6 24.7 67.3 24.7 57.4 0 104-46.6 104-104 0-25.7-9.3-49.1-24.7-67.3-10.1-11.9-10.1-29.5 0-41.4 15.4-18.2 24.7-41.6 24.7-67.3 0-57.4-46.6-104-104-104-25.7 0-49.1 9.3-67.3 24.7-11.9 10.1-29.5 10.1-41.4 0-18.2-15.4-41.6-24.7-67.3-24.7-57.4 0-104 46.6-104 104zm272 88a80 80 0 1 1 -160 0 80 80 0 1 1 160 0z", "M448 168c0 33.6-12.2 64.3-32.3 88 20.1 23.7 32.3 54.4 32.3 88 0 75.1-60.9 136-136 136-33.6 0-64.3-12.2-88-32.3-23.7 20.1-54.4 32.3-88 32.3-75.1 0-136-60.9-136-136 0-33.6 12.2-64.3 32.3-88-20.1-23.7-32.3-54.4-32.3-88 0-75.1 60.9-136 136-136 33.6 0 64.3 12.2 88 32.3 23.7-20.1 54.4-32.3 88-32.3 75.1 0 136 60.9 136 136zM203.3 88.7c-18.2-15.4-41.6-24.7-67.3-24.7-57.4 0-104 46.6-104 104 0 25.7 9.3 49.1 24.7 67.3 10.1 11.9 10.1 29.5 0 41.4-15.4 18.2-24.7 41.6-24.7 67.3 0 57.4 46.6 104 104 104 25.7 0 49.1-9.3 67.3-24.7 11.9-10.1 29.5-10.1 41.4 0 18.2 15.4 41.6 24.7 67.3 24.7 57.4 0 104-46.6 104-104 0-25.7-9.3-49.1-24.7-67.3-10.1-11.9-10.1-29.5 0-41.4 15.4-18.2 24.7-41.6 24.7-67.3 0-57.4-46.6-104-104-104-25.7 0-49.1 9.3-67.3 24.7-11.9 10.1-29.5 10.1-41.4 0zM272 256a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zm-128 0a80 80 0 1 1 160 0 80 80 0 1 1 -160 0z"]],
    "bowl-food": [512, 512, [], "e4c6", ["M32.1 288l209.6 0-115.8 129.4c-3.4-5.5-8.4-9.8-14.4-12.5-45.5-19.9-77.6-64.6-79.4-116.9z", "M203.8 82.2C213.9 61.5 233.8 48 256 48s42.2 13.5 52.2 34.2c2 4.1 5.6 7.2 10 8.4s9.1 .6 12.9-1.9c8.8-5.6 18.9-8.7 29.8-8.7 27.8 0 52.1 21.2 57.8 51 1.5 7.7 8.3 13.2 16.1 13 .4 0 .7 0 1.1 0 23.3 0 44 20.5 44 48 0 8.8 7.2 16 16 16s16-7.2 16-16c0-39.4-27.5-73.5-64.9-79.2-12.1-37.2-45.6-64.8-86.1-64.8-11.4 0-22.3 2.2-32.3 6.2-16.4-23-42.7-38.2-72.7-38.2s-56.2 15.2-72.7 38.2c-10-4-20.9-6.2-32.3-6.2-40.5 0-74 27.6-86.1 64.8-37.4 5.7-64.9 39.8-64.9 79.2 0 8.8 7.2 16 16 16s16-7.2 16-16c0-27.5 20.7-48 44-48 .4 0 .7 0 1.1 0 7.8 .2 14.7-5.3 16.1-13 5.7-29.8 30-51 57.8-51 10.8 0 21 3.2 29.8 8.7 3.8 2.4 8.6 3.1 12.9 1.9s8-4.3 10-8.4zM129.3 425.1c-2.7-9-9.2-16.4-17.8-20.2-45.5-19.9-77.6-64.6-79.4-116.9l447.8 0c-1.8 52.3-33.9 97-79.4 116.9-8.6 3.8-15.2 11.2-17.8 20.2-3.9 13.2-16.2 22.9-30.7 22.9l-192 0c-14.5 0-26.7-9.6-30.7-22.9zM27.4 256C12.3 256 0 268.3 0 283.4 0 350.9 40.6 408.8 98.6 434.3 106.5 460.7 131 480 160 480l192 0c29 0 53.5-19.3 61.4-45.7 58.1-25.4 98.6-83.4 98.6-150.8 0-15.1-12.3-27.4-27.4-27.4L27.4 256z"]],
    "globe-pointer": [576, 512, [], "e60e", ["M96.6 240l95.7 0c2.7-79.3 25.5-152.9 58.5-197.1-85 27.6-147.7 104.6-154.2 197.1zm127.9-4.1l5.9-1.7c48.6-14.3 93.8 30.9 79.5 79.5-12.7 43.2-25.4 86.4-38.1 129.6 17.9 26.9 35.7 36.7 48.3 36.7 15.7-.1 39.5-15.2 61.5-59.9 19-38.6 32.1-91.3 34.2-148.1l-95.7 0 0-32 95.7 0c-2.1-56.8-15.2-109.5-34.2-148.1-22-44.7-45.9-59.8-61.5-59.9-15.7 .1-39.5 15.2-61.5 59.9-18.6 37.7-31.5 88.8-34 144zM389.2 42.9c33 44.2 55.8 117.8 58.5 197.1l95.7 0c-6.5-92.5-69.2-169.5-154.2-197.1zm0 426.2c85-27.6 147.7-104.6 154.2-197.1l-95.7 0c-2.7 79.3-25.5 152.9-58.5 197.1z", "M320 480c15.5 0 39.4-15 61.5-59.9 19-38.6 32.1-91.3 34.2-148.1l-95.7 0 0-32 95.7 0C413.6 183.2 400.5 130.5 381.5 91.9 359.4 47 335.5 32 320 32s-39.4 15-61.5 59.9c-18.6 37.7-31.5 88.8-34 144l-122.6 36.1-5.3 0 .1 1.5-31.3 9.2C64.5 273.9 64 265 64 256 64 114.6 178.6 0 320 0S576 114.6 576 256 461.4 512 320 512c-22.8 0-45-3-66-8.6l17.7-60.2c18 27.1 35.9 36.7 48.3 36.7zM200.6 344.8l-.3-1.6 .9-.3-.6 1.9zM389.2 469.1c85-27.6 147.7-104.6 154.2-197.1l-95.7 0c-2.7 79.3-25.5 152.9-58.5 197.1zM447.7 240l95.7 0c-6.5-92.5-69.2-169.5-154.2-197.1 33 44.2 55.8 117.8 58.5 197.1zM250.8 42.9C165.8 70.5 103.1 147.5 96.6 240l95.7 0c2.7-79.3 25.5-152.9 58.5-197.1zM87.1 359.8L137.5 385c9.3 4.6 16.8 12.2 21.5 21.5l25.2 50.5 40.5-137.7-137.7 40.5zm156.8-79.5c12.1-3.6 23.4 7.7 19.9 19.9L203.5 505c-4.1 13.9-23.2 15.6-29.7 2.6l-38.3-76.5-92.2 92.2c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l92.2-92.2-76.5-38.3c-13-6.5-11.3-25.6 2.6-29.7l204.8-60.2z"]],
    "eggplant": [512, 512, [], "e16c", ["M32 335.5c-.6-39.7 11.2-67 29.4-88.5 19.2-22.6 46.8-40.5 80.9-58.3 11.9-6.2 25.5-12.8 39.5-19.7l3.1-1.5c29.3-14.2 58.7-28.6 86.3-46.4 9.1 7.9 19.7 14 31.5 18.2 4.2 12.3 10.6 24.8 20.5 36.5 13.7 16.1 30.9 26.9 50 33.2 7.2 20.9 21.8 39 40.3 50.6-16.1 36.7-36.3 73.8-60.4 107-49.6 68.5-110.2 113.6-176.8 113.6-78.4-.1-143.2-66.1-144.4-144.5zM320 48l96 0c26.5 0 48 21.5 48 48l0 96-4 0c-6.6 0-12-5.4-12-12l0-10c0-18.8-15.2-34-34-34-21 0-38-17-38-38 0-18.8-15.2-34-34-34l-10 0c-6.6 0-12-5.4-12-12l0-4z", "M482.7 51.9C491.1 64.5 496 79.7 496 96l0 96c0 17.7-14.3 32-32 32l-4 0c-24.3 0-44-19.7-44-44l0-10c0-1.1-.9-2-2-2-38.7 0-70-31.3-70-70 0-1.1-.9-2-2-2l-10 0c-24.3 0-44-19.7-44-44l0-4c0-17.7 14.3-32 32-32l96 0c16.3 0 31.5 4.9 44.1 13.3L484.7 4.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6L482.7 51.9zM416 48l-96 0 0 4c0 6.6 5.4 12 12 12l10 0c18.8 0 34 15.2 34 34 0 21 17 38 38 38 18.8 0 34 15.2 34 34l0 10c0 6.6 5.4 12 12 12l4 0 0-96c0-26.5-21.5-48-48-48zM169.9 139.3c27.9-13.5 55.9-27.1 81.3-43.3 5.2 9.5 12 18 20.1 25.1-27.4 17.8-56.9 32.1-86.3 46.4l-3.1 1.5c-14.1 6.8-27.6 13.4-39.5 19.7-34 17.8-61.7 35.7-80.9 58.3-18.2 21.5-30 48.8-29.4 88.5 1.1 78.4 66 144.4 144.4 144.5 66.7 .1 127.2-45.1 176.8-113.6 24.1-33.3 44.4-70.5 60.4-107 9.1 5.3 19.3 9.2 30.1 11.1-51 117.4-144.5 241.6-267.3 241.5-96.5-.1-175-80.8-176.4-176-1.7-113.5 83.3-154.7 169.9-196.7z"]],
    "folder-arrow-right": [512, 512, [], "e7d3", ["M32 96l0 288c0 17.7 14.3 32 32 32l384 0c17.7 0 32-14.3 32-32l0-240c0-17.7-14.3-32-32-32l-149.3 0c-12.1 0-23.9-3.4-34.1-9.9l-4.2-2.9-38.4-28.8c-5.5-4.2-12.3-6.4-19.2-6.4L64 64C46.3 64 32 78.3 32 96zM160 264c0-8.8 7.2-16 16-16l121.4 0-44.7-44.7c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l72 72 2.1 2.5c4.1 6.2 3.4 14.7-2.1 20.1l-72 72-2.5 2.1c-6.2 4.1-14.7 3.4-20.1-2.1s-6.2-13.9-2.1-20.1l2.1-2.5 44.7-44.7-121.4 0c-8.8 0-16-7.2-16-16z", "M202.7 32c13.8 0 27.3 4.5 38.4 12.8l38.4 28.8c4.2 3.1 9 5.2 14.1 6l5.1 .4 149.3 0c35.3 0 64 28.7 64 64l0 240c0 35.3-28.7 64-64 64L64 448c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l138.7 0zM64 64C46.3 64 32 78.3 32 96l0 288c0 17.7 14.3 32 32 32l384 0c17.7 0 32-14.3 32-32l0-240c0-17.7-14.3-32-32-32l-149.3 0c-12.1 0-23.9-3.4-34.1-9.9l-4.2-2.9-38.4-28.8c-5.5-4.2-12.3-6.4-19.2-6.4L64 64zM252.7 180.7c6.3-6.2 16.4-6.2 22.6 0l72 72 2.1 2.5c4.1 6.2 3.4 14.7-2.1 20.1l-72 72-2.5 2.1c-6.2 4.1-14.7 3.4-20.1-2.1s-6.2-13.9-2.1-20.1l2.1-2.5 44.7-44.7-121.4 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l121.4 0-44.7-44.7c-6.2-6.2-6.2-16.4 0-22.6z"]],
    "battery-slash": [640, 512, [], "f377", ["M182.5 96L496 96c26.5 0 48 21.5 48 48l0 224c0 24.4-18.2 44.6-41.9 47.6L182.5 96z", "M59.3-27.2c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l544 544c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-75.4-75.4C556.2 429.1 576 400.8 576 368l0-32 32 0c17.7 0 32-14.3 32-32l0-96c0-17.7-14.3-32-32-32l-32 0 0-32c0-44.2-35.8-80-80-80L150.5 64 59.3-27.2zM182.5 96L496 96c26.5 0 48 21.5 48 48l0 224c0 24.4-18.2 44.6-41.9 47.6L182.5 96zM32 144l0 224c0 44.2 35.8 80 80 80l309.5 0-32-32-277.5 0c-26.5 0-48-21.5-48-48l0-224c0-14.7 6.6-27.8 16.9-36.6L58.2 84.8C42.1 99.4 32 120.5 32 144zm544 64l32 0 0 96-32 0 0-96z"]],
    "film-slash": [576, 512, [], "e179", ["M192 64l0 73.5 192 192 0-265.5-192 0z", "M27.3-27.2c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l544 544c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-68.2-68.2c5.7-9.5 8.9-20.7 8.9-32.6l0-320c0-35.3-28.7-64-64-64L128 32c-11.9 0-23 3.2-32.6 8.9L27.3-27.2zm92.3 92.3c2.7-.7 5.5-1.1 8.4-1.1l32 0 0 41.5-40.4-40.4zM192 137.5l0-73.5 192 0 0 265.5-192-192zM438.5 384l41.5 0 0 32c0 2.9-.4 5.7-1.1 8.4L438.5 384zM64 122.5L64 416c0 35.3 28.7 64 64 64l293.5 0-32-32-197.5 0 0-197.5-10.5-10.5-85.5 0 0-85.5-32-32zM128 448c-17.7 0-32-14.3-32-32l0-32 64 0 0 64-32 0zM96 352l0-80 64 0 0 80-64 0zm384-80l0 80-64 0 0-80 64 0zm0-112l0 80-64 0 0-80 64 0zm0-64l0 32-64 0 0-64 32 0c17.7 0 32 14.3 32 32z"]],
    "square-virus": [448, 512, [], "e578", ["M32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64C46.3 64 32 78.3 32 96zM80 256c0-13.3 10.7-24 24-24 22.9 0 34.4-27.7 18.2-43.9-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0c16.2 16.2 43.9 4.7 43.9-18.2 0-13.3 10.7-24 24-24s24 10.7 24 24c0 22.9 27.7 34.4 43.9 18.2 9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9c-16.2 16.2-4.7 43.9 18.2 43.9 13.3 0 24 10.7 24 24s-10.7 24-24 24c-22.9 0-34.4 27.7-18.2 43.9 9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0c-16.2-16.2-43.9-4.7-43.9 18.2 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-22.9-27.7-34.4-43.9-18.2-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9c16.2-16.2 4.7-43.9-18.2-43.9-13.3 0-24-10.7-24-24z", "M64 64C46.3 64 32 78.3 32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm160.1 96.1A90.3 90.3 0 1 0 287.9 319.9 90.3 90.3 0 1 0 160.1 192.1zm131.8-37.9c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9c-16.2 16.2-4.7 43.9 18.2 43.9 13.3 0 24 10.7 24 24s-10.7 24-24 24c-22.9 0-34.4 27.7-18.2 43.9 9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0c-16.2-16.2-43.9-4.7-43.9 18.2 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-22.9-27.7-34.4-43.9-18.2-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9c16.2-16.2 4.7-43.9-18.2-43.9-13.3 0-24-10.7-24-24s10.7-24 24-24c22.9 0 34.4-27.7 18.2-43.9-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0c16.2 16.2 43.9 4.7 43.9-18.2 0-13.3 10.7-24 24-24s24 10.7 24 24c0 22.9 27.7 34.4 43.9 18.2zM200 212a20 20 0 1 1 0 40 20 20 0 1 1 0-40zm28 68a20 20 0 1 1 40 0 20 20 0 1 1 -40 0z"]],
    "tricycle-adult": [640, 512, [], "e5c4", ["M32 336a80 80 0 1 0 160 0 80 80 0 1 0 -160 0zm448 16a64 64 0 1 0 128 0 64 64 0 1 0 -128 0z", "M288 80c0-8.8 7.2-16 16-16l48 0c5.2 0 10.1 2.5 13.1 6.8L502.2 265.6c12.6-6.1 26.8-9.6 41.8-9.6 53 0 96 43 96 96s-43 96-96 96-96-43-96-96c0-26.5 10.7-50.5 28.1-67.9l-20.5-29.1-73.5 73.5c-15 15-35.4 23.4-56.6 23.4l-102.6 0c-7.8 54.3-54.4 96-110.9 96-61.9 0-112-50.1-112-112 0-50.2 33-92.6 78.4-106.9-3.6-5.1-6.5-10.7-8.6-16.9L48.8 149.1c-2.8-8.4 1.7-17.4 10.1-20.2s17.4 1.7 20.2 10.1l21.1 63.2c4.4 13.1 16.6 21.9 30.4 21.9l77.4 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-17.6 0c17.1 16.8 28.9 39.1 32.5 64l102.6 0c12.7 0 24.9-5.1 33.9-14.1l77.3-77.3 1.3 1.3-94.3-134-39.7 0c-8.8 0-16-7.2-16-16zM192 336a80 80 0 1 0 -160 0 80 80 0 1 0 160 0zm352 80a64 64 0 1 0 0-128 64 64 0 1 0 0 128z"]],
    "circle-phone-flip": [512, 512, ["phone-circle-alt"], "e11c", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm88.5 81.9c-9.4-24.3 2.3-51.6 26.3-61.6l21.4-8.9c19.3-8 41.6-2.7 55.1 13.3l3 3.5c24-13.9 43.7-34.3 56.7-58.9l-2.3-2c-16-13.5-21.3-35.8-13.3-55.1l8.9-21.4c10-24 37.4-35.7 61.6-26.3l2 .8c31.3 12.1 58.2 45 50.7 85.4-17.3 93.3-90.8 166.7-184.1 184.1-40.4 7.5-73.3-19.4-85.4-50.7l-.8-2z", "M256 32a224 224 0 1 1 0 448 224 224 0 1 1 0-448zm0 480a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm70.4-361.7l2 .8c20.7 8 34.9 28.1 30.8 49.7-14.9 80.3-78.2 143.5-158.5 158.5-21.6 4-41.7-10.1-49.7-30.8l-.8-2c-3.1-8.1 .8-17.2 8.8-20.5l21.4-8.9c6.4-2.7 13.9-.9 18.4 4.4l11.3 13.3c4.7 5.5 12.5 7.2 19.1 4.1 39.4-18.7 70.9-51.2 88.2-91.4 2.8-6.5 1-14-4.4-18.5l-11.8-10c-5.3-4.5-7.1-11.9-4.4-18.4l8.9-21.4c3.3-8 12.5-11.9 20.5-8.8zm-50.1-3.5l-8.9 21.4c-8 19.3-2.7 41.6 13.3 55.1l2.3 2c-13 24.5-32.7 45-56.7 58.9l-3-3.5c-13.5-16-35.8-21.3-55.1-13.3l-21.4 8.9c-24 10-35.7 37.4-26.3 61.6l.8 2c12.1 31.3 45 58.2 85.4 50.7 93.3-17.3 166.7-90.8 184.1-184.1 7.5-40.4-19.4-73.3-50.7-85.4l-2-.8c-24.3-9.4-51.6 2.3-61.6 26.3z"]],
    "cloud-sun-rain": [576, 512, [127782], "f743", ["M42.4 123.4l70.3-14.2c6.3-1.3 11.2-6.2 12.5-12.5L139.4 26.4 199.2 66c5.3 3.5 12.3 3.5 17.6 0l59.8-39.6 10.5 51.9c-18.2 9.8-33.5 24.1-44.5 41.5-10.5-5-22.2-7.8-34.6-7.8-44.2 0-80 35.8-80 80 0 32.8 19.7 61 48 73.3 .2 21.2 5.2 41 13.9 58.7l-50.5 33.5-14.2-70.3c-1.3-6.3-6.2-11.2-12.5-12.5l-70.3-14.2 39.6-59.8c3.5-5.3 3.5-12.3 0-17.6L42.4 123.4zM256 264c0-24.4 15.6-45.2 37.4-52.9 6.8-2.4 11.1-8.9 10.7-16.1-1.7-27.1 20.7-51.1 47.9-51.1 10 0 19.3 3.1 27 8.3 6.7 4.5 15.7 3.4 21-2.6 11.8-13.3 28.9-21.7 48-21.7 38.3 0 68.8 35.5 63.3 73.3-.9 6.2 1.9 12.3 7.1 15.7 15.4 10 25.5 27.3 25.5 47 0 30.9-25.1 56-56 56l-176 0c-30.9 0-56-25.1-56-56z", "M303.2-3.2c-1.1-5.2-4.6-9.5-9.5-11.6s-10.5-1.5-14.9 1.4L208 33.6 137.3-13.3c-4.4-2.9-10-3.5-14.9-1.4s-8.5 6.4-9.5 11.6L96 80 12.8 96.8c-5.2 1.1-9.5 4.6-11.6 9.5s-1.5 10.5 1.4 14.9L49.6 192 2.7 262.7c-2.9 4.4-3.5 10-1.4 14.9s6.4 8.5 11.6 9.5L96 304 112.8 387.2c1.1 5.2 4.6 9.5 9.5 11.6s10.5 1.5 14.9-1.4l70.1-46.5c-6.8-8.2-12.6-17.1-17.4-26.8l-50.5 33.5-14.2-70.3c-1.3-6.3-6.2-11.2-12.5-12.5l-70.3-14.2 39.6-59.8c3.5-5.3 3.5-12.3 0-17.6l-39.6-59.8 70.3-14.2c6.3-1.3 11.2-6.2 12.5-12.5L139.4 26.4 199.2 66c5.3 3.5 12.3 3.5 17.6 0l59.8-39.6 10.5 51.9c9.4-5.1 19.6-8.9 30.3-11.4L303.2-3.2zM208 112c-44.2 0-80 35.8-80 80 0 32.8 19.7 61 48 73.3l0-1.3c0-11.4 1.4-22.4 4-33-12.1-8.7-20-22.9-20-39 0-26.5 21.5-48 48-48 7.6 0 14.8 1.8 21.2 4.9 3.2-10.4 7.7-20.1 13.4-29.1-10.5-5-22.2-7.8-34.6-7.8zm77.1 288.8c-8.4-2.8-17.4 1.7-20.2 10.1l-26.7 80c-2.8 8.4 1.7 17.4 10.1 20.2s17.4-1.7 20.2-10.1l26.7-80c2.8-8.4-1.7-17.4-10.1-20.2zm120 0c-8.4-2.8-17.4 1.7-20.2 10.1l-26.7 80c-2.8 8.4 1.7 17.4 10.1 20.2s17.4-1.7 20.2-10.1l26.7-80c2.8-8.4-1.7-17.4-10.1-20.2zm120 0c-8.4-2.8-17.4 1.7-20.2 10.1l-26.7 80c-2.8 8.4 1.7 17.4 10.1 20.2s17.4-1.7 20.2-10.1l26.7-80c2.8-8.4-1.7-17.4-10.1-20.2zM511.3 201.3c-.9 6.2 1.9 12.3 7.1 15.7 15.4 10 25.5 27.3 25.5 47 0 30.9-25.1 56-56 56l-176 0c-30.9 0-56-25.1-56-56 0-24.4 15.6-45.2 37.4-52.9 6.8-2.4 11.1-8.9 10.7-16.1-1.7-27.1 20.7-51.1 47.9-51.1 10 0 19.3 3.1 27 8.3 6.7 4.5 15.7 3.4 21-2.6 11.8-13.3 28.9-21.7 48-21.7 38.3 0 68.8 35.5 63.3 73.3zM448 96c-23.9 0-45.8 8.8-62.7 23.3-10.2-4.7-21.5-7.3-33.3-7.3-41.8 0-76.3 33-79.7 73.5-28.6 14.5-48.3 44.2-48.3 78.5 0 48.6 39.4 88 88 88l176 0c48.6 0 88-39.4 88-88 0-27.4-12.5-51.8-32.1-68 2.1-53-41.3-100-95.9-100z"]],
    "h4": [512, 512, [], "f86a", ["", "M32 80c0-8.8-7.2-16-16-16S0 71.2 0 80L0 432c0 8.8 7.2 16 16 16s16-7.2 16-16l0-160 160 0 0 160c0 8.8 7.2 16 16 16s16-7.2 16-16l0-352c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 160-160 0 0-160zm288 0c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 128c0 44.2 35.8 80 80 80l112 0 0 144c0 8.8 7.2 16 16 16s16-7.2 16-16l0-352c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 176-112 0c-26.5 0-48-21.5-48-48l0-128z"]],
    "circle-caret-right": [512, 512, ["caret-circle-right"], "f330", ["M480 256a224 224 0 1 1 -448 0 224 224 0 1 1 448 0zM192 155.5l0 201c0 15.2 12.3 27.5 27.5 27.5 6.9 0 13.6-2.6 18.7-7.3L341 281.2c7-6.5 11-15.6 11-25.2s-4-18.7-11-25.2L238.2 135.3c-5.1-4.7-11.8-7.3-18.7-7.3-15.2 0-27.5 12.3-27.5 27.5z", "M480 256a224 224 0 1 1 -448 0 224 224 0 1 1 448 0zM0 256a256 256 0 1 0 512 0 256 256 0 1 0 -512 0zm352 0c0-9.6-4-18.7-11-25.2L238.2 135.3c-5.1-4.7-11.8-7.3-18.7-7.3-15.2 0-27.5 12.3-27.5 27.5l0 201c0 15.2 12.3 27.5 27.5 27.5 6.9 0 13.6-2.6 18.7-7.3L341 281.2c7-6.5 11-15.6 11-25.2zm-32.7-1.7c.5 .4 .7 1.1 .7 1.7s-.3 1.3-.7 1.7l-95.3 88.4 0-180.3 95.3 88.4z"]],
    "keyboard-brightness-low": [512, 512, [], "e1c1", ["", "M256 184a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM144 384c-8.8 0-16 7.2-16 16s7.2 16 16 16l224 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-224 0zM120 224a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm296 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm88 136a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM32 408a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]],
    "arrow-right-long": [576, 512, ["long-arrow-right"], "f178", ["", "M571.3 267.3c6.2-6.2 6.2-16.4 0-22.6l-144-144c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6L521.4 240 16 240c-8.8 0-16 7.2-16 16s7.2 16 16 16l505.4 0-116.7 116.7c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l144-144z"]],
    "font-case": [576, 512, [], "f866", ["", "M64 168l0 88 160 0 0-88c0-39.8-32.2-72-72-72l-16 0c-39.8 0-72 32.2-72 72zM32 272l0-104C32 110.6 78.6 64 136 64l16 0c57.4 0 104 46.6 104 104l0 264c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-144-160 0 0 144c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-160zm392-48c-39.8 0-72 32.2-72 72l0 48c0 39.8 32.2 72 72 72l16 0c39.8 0 72-32.2 72-72l0-48c0-39.8-32.2-72-72-72l-16 0zm88-3l0-13c0-8.8 7.2-16 16-16s16 7.2 16 16l0 134.5c0 25.8 4.2 51.4 12.3 75.9l2.9 8.6c2.8 8.4-1.7 17.4-10.1 20.2s-17.4-1.7-20.2-10.1l-2.9-8.6c-2-6.1-3.9-12.3-5.5-18.6-19.1 23.3-48 38.1-80.5 38.1l-16 0c-57.4 0-104-46.6-104-104l0-48c0-57.4 46.6-104 104-104l16 0c27.9 0 53.3 11 72 29z"]],
    "building-un": [512, 512, [], "e4d9", ["M64 64c0-17.7 14.3-32 32-32l256 0c17.7 0 32 14.3 32 32l0 272-80 0c-18.1 0-34.4 7.5-46 19.5-5.6-2.3-11.6-3.5-18-3.5l-32 0c-26.5 0-48 21.5-48 48l0 80-64 0c-17.7 0-32-14.3-32-32L64 64zm80 64l0 16c0 8.8 7.2 16 16 16l16 0c8.8 0 16-7.2 16-16l0-16c0-8.8-7.2-16-16-16l-16 0c-8.8 0-16 7.2-16 16zm0 112l0 16c0 8.8 7.2 16 16 16l16 0c8.8 0 16-7.2 16-16l0-16c0-8.8-7.2-16-16-16l-16 0c-8.8 0-16 7.2-16 16zM256 128l0 16c0 8.8 7.2 16 16 16l16 0c8.8 0 16-7.2 16-16l0-16c0-8.8-7.2-16-16-16l-16 0c-8.8 0-16 7.2-16 16zm0 112l0 16c0 8.8 7.2 16 16 16l16 0c8.8 0 16-7.2 16-16l0-16c0-8.8-7.2-16-16-16l-16 0c-8.8 0-16 7.2-16 16z", "M352 32L96 32C78.3 32 64 46.3 64 64l0 384c0 17.7 14.3 32 32 32l64 0 0-80c0-26.5 21.5-48 48-48l32 0c6.4 0 12.4 1.2 18 3.5-7.6 7.9-13.2 17.7-16 28.6-.7-.1-1.3-.1-2-.1l-32 0c-8.8 0-16 7.2-16 16l0 80 48 0 0 32-144 0c-35.3 0-64-28.7-64-64L32 64C32 28.7 60.7 0 96 0L352 0c35.3 0 64 28.7 64 64l0 272-32 0 0-272c0-17.7-14.3-32-32-32zm-80 80l16 0c8.8 0 16 7.2 16 16l0 16c0 8.8-7.2 16-16 16l-16 0c-8.8 0-16-7.2-16-16l0-16c0-8.8 7.2-16 16-16zM256 240c0-8.8 7.2-16 16-16l16 0c8.8 0 16 7.2 16 16l0 16c0 8.8-7.2 16-16 16l-16 0c-8.8 0-16-7.2-16-16l0-16zM160 112l16 0c8.8 0 16 7.2 16 16l0 16c0 8.8-7.2 16-16 16l-16 0c-8.8 0-16-7.2-16-16l0-16c0-8.8 7.2-16 16-16zM144 240c0-8.8 7.2-16 16-16l16 0c8.8 0 16 7.2 16 16l0 16c0 8.8-7.2 16-16 16l-16 0c-8.8 0-16-7.2-16-16l0-16zM428.3 384.4c7.2-1.7 14.7 1.8 18 8.4l33.7 67.4 0-60.2c0-8.8 7.2-16 16-16s16 7.2 16 16l0 128c0 7.4-5.1 13.9-12.3 15.6s-14.7-1.8-18-8.4L448 467.8 448 528c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-128c0-7.4 5.1-13.9 12.3-15.6zM320 400l0 96c0 8.8 7.2 16 16 16s16-7.2 16-16l0-96c0-8.8 7.2-16 16-16s16 7.2 16 16l0 96c0 26.5-21.5 48-48 48s-48-21.5-48-48l0-96c0-8.8 7.2-16 16-16s16 7.2 16 16z"]],
    "toilet-paper-xmark": [512, 512, [], "e5b3", ["M32 224C32 177.5 42.3 136.3 58.2 107.2 74.4 77.5 94.1 64 112 64l225.3 0c-7.2 8.2-13.6 17.7-19.2 27.9-18.9 34.6-30.1 81.4-30.1 132.1s11.2 97.5 30.1 132.1c5.6 10.2 12 19.6 19.2 27.9L112 384C94.1 384 74.4 370.5 58.2 340.8 42.3 311.7 32 270.5 32 224zm68.7-67.3c-6.2 6.2-6.2 16.4 0 22.6l44.7 44.7-44.7 44.7c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l44.7-44.7 44.7 44.7c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-44.7-44.7 44.7-44.7c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-44.7 44.7-44.7-44.7c-6.2-6.2-16.4-6.2-22.6 0zM160 416l240 0c33.9 0 61.4-24.1 80-56.4L480 480c0 17.7-14.3 32-32 32l-256 0c-17.7 0-32-14.3-32-32l0-64zM320 224c0-46.5 10.3-87.7 26.2-116.8 16.2-29.7 35.9-43.2 53.8-43.2s37.6 13.5 53.8 43.2C469.7 136.3 480 177.5 480 224s-10.3 87.7-26.2 116.8C437.6 370.5 417.9 384 400 384s-37.6-13.5-53.8-43.2C330.3 311.7 320 270.5 320 224zm56 0c0 26.5 10.7 48 24 48s24-21.5 24-48-10.7-48-24-48-24 21.5-24 48z", "M32 224C32 177.5 42.3 136.3 58.2 107.2 74.4 77.5 94.1 64 112 64l225.3 0c-7.2 8.2-13.6 17.7-19.2 27.9-18.9 34.6-30.1 81.4-30.1 132.1s11.2 97.5 30.1 132.1c5.6 10.2 12 19.6 19.2 27.9L112 384C94.1 384 74.4 370.5 58.2 340.8 42.3 311.7 32 270.5 32 224zM346.2 107.2C362.4 77.5 382.1 64 400 64s37.6 13.5 53.8 43.2C469.7 136.3 480 177.5 480 224s-10.3 87.7-26.2 116.8C437.6 370.5 417.9 384 400 384s-37.6-13.5-53.8-43.2C330.3 311.7 320 270.5 320 224s10.3-87.7 26.2-116.8zM480 359.6L480 480c0 17.7-14.3 32-32 32l-256 0c-17.7 0-32-14.3-32-32l0-64 240 0c33.9 0 61.4-24.1 80-56.4zM128 416l0 64c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-256c0-50.8-11.2-97.5-30.1-132.1-18.6-34-46.8-59.9-81.9-59.9L112 32C76.9 32 48.6 57.9 30.1 91.9 11.2 126.5 0 173.2 0 224s11.2 97.5 30.1 132.1C48.6 390.1 76.9 416 112 416l16 0zM424 224c0-26.5-10.7-48-24-48s-24 21.5-24 48 10.7 48 24 48 24-21.5 24-48zM100.7 156.7c-6.2 6.2-6.2 16.4 0 22.6l44.7 44.7-44.7 44.7c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l44.7-44.7 44.7 44.7c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-44.7-44.7 44.7-44.7c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-44.7 44.7-44.7-44.7c-6.2-6.2-16.4-6.2-22.6 0z"]],
    "temperature-low": [448, 512, [], "f76b", ["M48 368c0 61.9 50.1 112 112 112s112-50.1 112-112c0-28.4-10.6-54.3-28-74.1-2.6-2.9-4-6.7-4-10.6L240 112c0-44.2-35.8-80-80-80S80 67.8 80 112l0 171.3c0 3.9-1.4 7.7-4 10.6-17.4 19.8-28 45.7-28 74.1zm48 0c0-29.8 20.4-54.9 48-62l0-18c0-8.8 7.2-16 16-16s16 7.2 16 16l0 18c27.6 7.1 48 32.2 48 62 0 35.3-28.7 64-64 64s-64-28.7-64-64z", "M80 112c0-44.2 35.8-80 80-80s80 35.8 80 80l0 171.3c0 3.9 1.4 7.7 4 10.6 17.4 19.8 28 45.7 28 74.1 0 61.9-50.1 112-112 112S48 429.9 48 368c0-28.4 10.6-54.3 28-74.1 2.6-2.9 4-6.7 4-10.6L80 112zM160 0C98.1 0 48 50.1 48 112l0 165.5c-20 24.7-32 56.2-32 90.5 0 79.5 64.5 144 144 144s144-64.5 144-144c0-34.3-12-65.8-32-90.5L272 112C272 50.1 221.9 0 160 0zM128 368a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm96 0c0-29.8-20.4-54.9-48-62l0-18c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 18c-27.6 7.1-48 32.2-48 62 0 35.3 28.7 64 64 64s64-28.7 64-64zM352 64a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm96 0a64 64 0 1 0 -128 0 64 64 0 1 0 128 0z"]],
    "h2": [576, 512, [], "f314", ["", "M64 80c0-8.8-7.2-16-16-16S32 71.2 32 80l0 352c0 8.8 7.2 16 16 16s16-7.2 16-16l0-160 160 0 0 160c0 8.8 7.2 16 16 16s16-7.2 16-16l0-352c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 160-160 0 0-160zM352 64c-8.8 0-16 7.2-16 16s7.2 16 16 16l108.3 0c32.9 0 59.7 26.7 59.7 59.7 0 21.6-11.7 41.5-30.5 52.1l-95.8 53.7C348.2 286.9 320 334.9 320 387l0 45c0 8.8 7.2 16 16 16l192 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-176 0 0-29c0-40.5 21.9-77.9 57.3-97.7l95.8-53.7c28.9-16.2 46.9-46.8 46.9-80 0-50.6-41-91.7-91.7-91.7L352 64z"]],
    "face-smile-halo": [512, 512, [], "e38f", ["M48 272c0-37 9.7-71.7 26.6-101.8 50 14 113.8 21.8 181.4 21.8s131.4-7.8 181.4-21.8C454.3 200.3 464 235 464 272 464 386.9 370.9 480 256 480S48 386.9 48 272zm64-8c0 8.8 7.2 16 16 16s16-7.2 16-16c0-17.7 14.3-32 32-32s32 14.3 32 32c0 8.8 7.2 16 16 16s16-7.2 16-16c0-35.3-28.7-64-64-64s-64 28.7-64 64zm22.3 95.9c29.3 34.3 73 56.1 121.7 56.1s92.4-21.8 121.7-56.1c5.7-6.7 5-16.8-1.8-22.6s-16.8-5-22.6 1.8C329.8 366.6 295 384 256 384s-73.8-17.4-97.3-44.9c-5.7-6.7-15.8-7.5-22.6-1.8s-7.5 15.8-1.8 22.6zM272 264c0 8.8 7.2 16 16 16s16-7.2 16-16c0-17.7 14.3-32 32-32s32 14.3 32 32c0 8.8 7.2 16 16 16s16-7.2 16-16c0-35.3-28.7-64-64-64s-64 28.7-64 64z", "M32 56c0 2.2 1.5 7.5 12.1 15 10.2 7.2 25.9 14.3 46.8 20.6 41.6 12.5 99.9 20.4 165.1 20.4s123.5-7.9 165.1-20.4C442 85.3 457.7 78.2 467.9 71 478.5 63.5 480 58.2 480 56s-1.5-7.5-12.1-15C457.7 33.8 442 26.7 421.1 20.4 379.5 7.9 321.2 0 256 0S132.5 7.9 90.9 20.4C70 26.7 54.3 33.8 44.1 41 33.5 48.5 32 53.8 32 56zM256-32c67.4 0 129 8.2 174.3 21.8 22.5 6.8 42 15.1 56.1 25.2 13.7 9.7 25.6 23.4 25.6 41.1s-11.9 31.3-25.6 41.1c-14.1 10-33.5 18.4-56.1 25.2-45.3 13.6-106.9 21.8-174.3 21.8s-129-8.2-174.3-21.8C59.1 115.5 39.7 107.1 25.6 97.1 11.9 87.3 0 73.7 0 56S11.9 24.7 25.6 14.9C39.7 4.9 59.1-3.5 81.7-10.2 127-23.8 188.6-32 256-32zM67.9 168.2c2.2 .7 4.4 1.3 6.7 1.9-16.9 30.1-26.6 64.8-26.6 101.8 0 114.9 93.1 208 208 208s208-93.1 208-208c0-37-9.7-71.7-26.6-101.8 2.3-.6 4.5-1.3 6.7-1.9 8.1-2.4 16.3-5.2 24.2-8.2 17.7 33.4 27.7 71.6 27.7 112 0 132.5-107.5 240-240 240S16 404.5 16 272c0-40.5 10-78.6 27.7-112 8 3.1 16.1 5.8 24.2 8.2zm68.2 169.1c6.7-5.7 16.8-5 22.6 1.8 23.5 27.5 58.4 44.9 97.3 44.9s73.8-17.4 97.3-44.9c5.7-6.7 15.8-7.5 22.6-1.8s7.5 15.8 1.8 22.6C348.4 394.2 304.7 416 256 416s-92.4-21.8-121.7-56.1c-5.7-6.7-5-16.8 1.8-22.6zM144 264c0 8.8-7.2 16-16 16s-16-7.2-16-16c0-35.3 28.7-64 64-64s64 28.7 64 64c0 8.8-7.2 16-16 16s-16-7.2-16-16c0-17.7-14.3-32-32-32s-32 14.3-32 32zm192-32c-17.7 0-32 14.3-32 32 0 8.8-7.2 16-16 16s-16-7.2-16-16c0-35.3 28.7-64 64-64s64 28.7 64 64c0 8.8-7.2 16-16 16s-16-7.2-16-16c0-17.7-14.3-32-32-32z"]],
    "rocket-vertical": [448, 512, [], "e7bd", ["M54.6 370.5l26.2 95.9c26.2-26.2 51.5-53.7 78.8-78.7-18.6-32.9-32.2-63.5-41.7-91.9L58.7 354.9c-4.1 4.1-5.6 10-4.1 15.5zm82.7-224c-12.6 52.1-6.5 124.5 49.1 223.8 24.1-10.4 51.7-10.4 75.8 0 55.6-99.3 61.7-171.8 49.1-223.8-13.7-56.7-51-96.1-87.1-123.3-36.1 27.2-73.4 66.6-87.1 123.3zM280.4 160a56 56 0 1 1 -112 0 56 56 0 1 1 112 0zm8.8 227.7c27.3 25 52.6 52.5 78.8 78.7l26.2-95.9c1.5-5.5-.1-11.5-4.1-15.5l-59.1-59.1c-9.5 28.4-23.2 59-41.7 91.9z", "M280.4 160a56 56 0 1 1 -112 0 56 56 0 1 1 112 0zm-56-24a24 24 0 1 0 0 48 24 24 0 1 0 0-48zM107.8 260.6L36.1 332.3c-12.2 12.2-16.9 30-12.4 46.6l26.2 95.9c6.5 23.7 36.1 31.6 53.5 14.2l75.8-75.8c25-25 65.5-25 90.5 0L345.4 489c17.4 17.4 47 9.5 53.5-14.2L425 378.9c4.5-16.6-.2-34.4-12.4-46.6L341 260.6c32.2-139.1-39.5-219.9-99.2-264.3-10.4-7.7-24.5-7.7-34.8 0-59.7 44.4-131.4 125.2-99.2 264.3zm51.8 127.1c-27.3 25-52.6 52.5-78.8 78.7L54.6 370.5c-1.5-5.5 .1-11.5 4.1-15.5l59.1-59.1c9.5 28.4 23.2 59 41.7 91.9zm171.4-91.9L390 354.9c4.1 4.1 5.6 10 4.1 15.5L368 466.4c-26.2-26.2-51.5-53.7-78.8-78.7 18.6-32.9 32.2-63.5 41.7-91.9zm-68.7 74.5c-24.1-10.4-51.7-10.4-75.8 0-55.6-99.3-61.7-171.8-49.1-223.8 13.7-56.7 51-96.1 87.1-123.3 36.1 27.2 73.4 66.6 87.1 123.3 12.6 52.1 6.5 124.5-49.1 223.8z"]],
    "door-open": [448, 512, [], "f52b", ["M64 64l0 416 224 0 0-416c0-17.7-14.3-32-32-32L96 32C78.3 32 64 46.3 64 64zM248 248a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M96 32C78.3 32 64 46.3 64 64l0 416 224 0 0-416c0-17.7-14.3-32-32-32L96 32zm215.4 0c5.4 9.4 8.6 20.3 8.6 32l0 448-304 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0 0-416C32 28.7 60.7 0 96 0L352 0c35.3 0 64 28.7 64 64l0 416 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-432c0-17.7-14.3-32-32-32l-40.6 0zM248 248a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z"]],
    "align-left": [448, 512, [], "f036", ["", "M16 48C7.2 48 0 55.2 0 64S7.2 80 16 80l256 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L16 48zm0 128c-8.8 0-16 7.2-16 16s7.2 16 16 16l416 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L16 176zM0 320c0 8.8 7.2 16 16 16l256 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L16 304c-8.8 0-16 7.2-16 16zM16 432c-8.8 0-16 7.2-16 16s7.2 16 16 16l416 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L16 432z"]],
    "pencil-slash": [576, 512, [], "e215", ["M252.9 198.4l73.4-73.4 92.7 92.7-73.4 73.4-92.7-92.7z", "M27.3-27.2c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l544 544c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L368.2 313.7 522.8 159.1C536.4 145.6 544 127.2 544 108s-7.6-37.6-21.2-51.1L487.1 21.2C473.6 7.6 455.2 0 436 0s-37.6 7.6-51.1 21.2l-154.6 154.6-203-203zM252.9 198.4l73.4-73.4 92.7 92.7-73.4 73.4-92.7-92.7zM90.9 315.1c-10.7 10.7-18.5 24.1-22.6 38.7L32.9 481.6c-2.3 8.3 0 17.3 6.2 23.4s15.1 8.5 23.4 6.2l127.8-35.5c14.6-4.1 27.9-11.8 38.7-22.6l82.8-82.8-22.6-22.6-71.4 71.4-92.7-92.7 71.4-71.4-22.6-22.6-82.8 82.8zM436 32c10.7 0 20.9 4.2 28.5 11.8l35.7 35.7C507.8 87.1 512 97.3 512 108s-4.2 20.9-11.8 28.5L441.7 195 349 102.3 407.5 43.8C415.1 36.2 425.3 32 436 32zM104 350.6L193.4 440c-3.7 2-7.7 3.6-11.8 4.8L67.5 476.5 99.2 362.4c1.1-4.1 2.7-8.1 4.8-11.8z"]],
    "camera": [512, 512, [62258, "camera-alt"], "f030", ["M32 160l0 256c0 17.7 14.3 32 32 32l384 0c17.7 0 32-14.3 32-32l0-256c0-17.7-14.3-32-32-32l-66.7 0c-5.7 0-11-3-13.8-7.9L339.4 71.9c-2.9-4.9-8.1-7.9-13.8-7.9L186.4 64c-5.7 0-11 3-13.8 7.9l-28.1 48.1c-2.9 4.9-8.1 7.9-13.8 7.9L64 128c-17.7 0-32 14.3-32 32zM368 288a112 112 0 1 1 -224 0 112 112 0 1 1 224 0z", "M186.4 32c-17.1 0-32.9 9.1-41.5 23.8L121.5 96 64 96C28.7 96 0 124.7 0 160L0 416c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64l-57.5 0-23.4-40.2C358.5 41.1 342.7 32 325.6 32L186.4 32zM172.6 71.9c2.9-4.9 8.1-7.9 13.8-7.9l139.2 0c5.7 0 11 3 13.8 7.9l28.1 48.1c2.9 4.9 8.1 7.9 13.8 7.9l66.7 0c17.7 0 32 14.3 32 32l0 256c0 17.7-14.3 32-32 32L64 448c-17.7 0-32-14.3-32-32l0-256c0-17.7 14.3-32 32-32l66.7 0c5.7 0 11-3 13.8-7.9l28.1-48.1zM256 400a112 112 0 1 0 0-224 112 112 0 1 0 0 224zM176 288a80 80 0 1 1 160 0 80 80 0 1 1 -160 0z"]],
    "hat-winter": [512, 512, [], "f7a8", ["M72.3 384c4.3-25.1 10.4-50.4 18.6-74.4l32 12.8c24.5 9.8 52.2 6.9 74.1-7.7L229.4 293c16.1-10.7 37.1-10.7 53.3 0l32.5 21.7c21.9 14.6 49.6 17.5 74.1 7.7l32-12.8c8.1 24.1 14.2 49.3 18.5 74.4L72.3 384zM90.9 231.3c25.7-44.2 61.1-79.2 108.3-95-51.7 16.2-85.8 53.9-108.3 95zm11.4 48.4c2-4.6 4.1-9.1 6.2-13.5 31.5-64.3 78.5-106.2 147.4-106.2s116 41.8 147.4 106.2c2.2 4.4 4.2 8.9 6.2 13.5l-32.4 12.9c-14.7 5.9-31.3 4.1-44.5-4.6l-32.5-21.7c-26.9-17.9-61.9-17.9-88.8 0L179.1 288c-13.2 8.8-29.8 10.5-44.5 4.6l-32.4-12.9zm210-143.1c.1-.1 .2-.3 .4-.4 52.4 16.3 86.7 54.8 109.2 96.5-25.8-44.9-61.5-80.5-109.6-96.2z", "M247.6 36.5c1.8-2.7 4.9-4.5 8.3-4.5s6.5 1.7 8.3 4.5c3.6 5.4 10.1 8.1 16.5 6.8 3.2-.6 6.6 .3 9.1 2.7s3.4 5.9 2.7 9.1c-1.3 6.4 1.4 12.9 6.8 16.5 2.7 1.8 4.5 4.9 4.5 8.3s-1.8 6.5-4.5 8.3c-5.4 3.6-8.1 10.1-6.8 16.5 .6 3.2-.3 6.6-2.7 9.1s-5.9 3.4-9.1 2.7c-6.4-1.3-12.9 1.4-16.5 6.8-1.8 2.7-4.9 4.5-8.3 4.5s-6.5-1.7-8.3-4.5c-3.6-5.4-10.1-8.1-16.5-6.8-3.2 .6-6.6-.3-9.1-2.7s-3.4-5.9-2.7-9.1c1.3-6.4-1.4-12.9-6.8-16.5-2.7-1.8-4.5-4.9-4.5-8.3s1.7-6.5 4.5-8.3c5.4-3.6 8.1-10.1 6.8-16.5-.6-3.2 .3-6.6 2.7-9.1s5.9-3.4 9.1-2.7c6.4 1.3 12.9-1.4 16.5-6.8zM256 0c-11 0-21 4.2-28.5 11.2-10.2 .4-20.3 4.5-28 12.3s-11.9 17.9-12.3 28C180.2 58.9 176 68.9 176 80s4.2 21 11.2 28.5c.4 10.2 4.5 20.3 12.3 28l.2 .2C103.4 168 56.7 279.5 39.7 384.7 17.2 388.6 0 408.3 0 432l0 32c0 26.5 21.5 48 48 48l416 0c26.5 0 48-21.5 48-48l0-32c0-23.7-17.2-43.4-39.7-47.3-16.9-105.2-63.7-216.7-159.9-248.1 .1 0 .1-.1 .1-.1 7.8-7.8 11.9-17.9 12.3-28 6.9-7.5 11.1-17.5 11.1-28.5s-4.2-21-11.1-28.5c-.4-10.2-4.5-20.3-12.3-28s-17.9-11.9-28-12.3C277 4.2 267 0 256 0zM90.8 309.6l32 12.8c24.5 9.8 52.2 6.9 74.1-7.7L229.4 293c16.1-10.7 37.1-10.7 53.3 0l32.5 21.7c21.9 14.6 49.6 17.5 74.1 7.7l32-12.8c8.1 24.1 14.2 49.3 18.5 74.4L72.3 384c4.3-25.1 10.4-50.4 18.6-74.4zm11.5-29.9c2-4.6 4.1-9.1 6.2-13.5 31.5-64.3 78.5-106.2 147.4-106.2s116 41.8 147.4 106.2c2.2 4.4 4.2 8.9 6.2 13.5l-32.4 12.9c-14.7 5.9-31.3 4.1-44.5-4.6l-32.5-21.7c-26.9-17.9-61.9-17.9-88.8 0L179.1 288c-13.2 8.8-29.8 10.5-44.5 4.6l-32.4-12.9zM48 480c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l416 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16L48 480z"]],
    "house-person-return": [640, 512, ["house-person-arrive", "house-return"], "e011", ["M80 148.2l111.8-95 96.2 85.5c-5.3 7.1-10.6 14.2-16 21.3l-32 0c-35.3 0-64 28.7-64 64s28.7 64 64 64l32 0 0 16c0 8.8-7.2 16-16 16L96 320c-8.8 0-16-7.2-16-16l0-155.8z", "M416 0a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm0 80a56 56 0 1 0 0-112 56 56 0 1 0 0 112zm48 69.9l0 114.6c0 18.2-10.3 34.8-26.5 42.9l-37.5 18.7 0-176.8c9.9-3.5 20.4-5.3 31.2-5.3 11.3 0 22.4 2 32.8 5.9zm32 19.9c1.7 1.6 3.4 3.3 5 5.1l30.5 33.6c8 8.8 12.5 20.3 12.5 32.3l0 63.3c0 8.8 7.2 16 16 16s16-7.2 16-16l0-63.3c0-19.9-7.4-39.1-20.8-53.8l-30.5-33.6c-23.9-26.3-57.9-41.4-93.5-41.4-39.8 0-77.2 18.7-101.1 50.5l-19.7 26.3C301.3 200.9 287.1 208 272 208l-32 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l32 0c25.2 0 48.9-11.9 64-32l19.7-26.3c3.7-4.9 7.8-9.4 12.3-13.5l0 173.8-24 12c-24.3 12.1-40.7 35.7-43.7 62.7L288.1 526.2c-1 8.8 5.4 16.7 14.1 17.7s16.7-5.4 17.7-14.1l12.2-109.4c1.8-16.2 11.7-30.3 26.2-37.6L451.8 336c27.1-13.6 44.2-41.3 44.2-71.6l0-94.7zM469.2 381l-28.9 14.5 4.6 13.8c3.3 9.8 8.4 18.9 15.2 26.8l87.8 102.5c5.8 6.7 15.9 7.5 22.6 1.7s7.5-15.9 1.7-22.6L484.3 415.1c-4-4.7-7.1-10.2-9.1-16.1l-6-18.1zM202.6 20c-6-5.3-14.9-5.4-21-.2l-160 136c-6.7 5.7-7.6 15.8-1.8 22.6s15.8 7.6 22.6 1.8L48 175.4 48 304c0 26.5 21.5 48 48 48l160 0c26.5 0 48-21.5 48-48l0-20.1c-10.3 2.7-21.1 4.1-32 4.1l0 16c0 8.8-7.2 16-16 16L96 320c-8.8 0-16-7.2-16-16l0-155.8 111.8-95 96.2 85.5 3.7-5c5.2-6.9 10.9-13.4 17-19.4L202.6 20z"]],
    "knife": [512, 512, ["utensil-knife"], "f2e4", ["M246.7 288L463.3 71.4c27.4 37.6 24.2 90.5-9.7 124.4L315.4 334.1c-6.2 6.2-16.4 6.2-22.6 0L246.7 288z", "M452.8 36.7c6.2-6.2 16.4-6.2 22.6 0l.8 .8c50 50 50 131 0 181L338.1 356.7c-18.7 18.7-49.1 18.7-67.9 0L224.1 310.6 27.4 507.3c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l448-448zM246.7 288l46.1 46.1c6.2 6.2 16.4 6.2 22.6 0L453.6 195.9c33.9-33.9 37.1-86.9 9.7-124.4L246.7 288z"]],
    "message-exclamation": [512, 512, ["comment-alt-exclamation"], "f4a5", ["M32 128l0 224c0 35.3 28.7 64 64 64l40 0c13.3 0 24 10.7 24 24l0 68 112-84c6.9-5.2 15.3-8 24-8l120 0c35.3 0 64-28.7 64-64l0-224c0-35.3-28.7-64-64-64L96 64c-35.3 0-64 28.7-64 64zM280 344a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zM232.5 136.9c-.8-13.5 10-24.9 23.5-24.9s24.3 11.4 23.5 24.9l-7.6 136c-.5 8.5-7.5 15.1-16 15.1s-15.5-6.6-16-15.1l-7.6-136z", "M416 32c53 0 96 43 96 96l0 224c0 53-43 96-96 96l-120 0c-1.7 0-3.4 .6-4.8 1.6L172.8 538.4c-4.8 3.6-10.8 5.6-16.8 5.6-15.5 0-28-12.5-28-28l0-68-32 0c-53 0-96-43-96-96L0 128C0 75 43 32 96 32l320 0zM96 64c-35.3 0-64 28.7-64 64l0 224c0 35.3 28.7 64 64 64l40 0c13.3 0 24 10.7 24 24l0 68 112-84c6.9-5.2 15.3-8 24-8l120 0c35.3 0 64-28.7 64-64l0-224c0-35.3-28.7-64-64-64L96 64zM256 368a24 24 0 1 1 0-48 24 24 0 1 1 0 48zm0-256c13.5 0 24.3 11.4 23.5 24.9l-7.6 136c-.5 8.5-7.5 15.1-16 15.1s-15.5-6.6-16-15.1l-7.6-136c-.8-13.5 10-24.9 23.5-24.9z"]],
    "right-to-line": [512, 512, ["arrow-alt-to-right"], "f34c", ["M32 240l0 32c0 8.8 7.2 16 16 16l160 0c8.8 0 16 7.2 16 16L224 380.7 348.7 256 224 131.3 224 208c0 8.8-7.2 16-16 16-53.3 0-106.7 0-160 0-8.8 0-16 7.2-16 16z", "M496 64c-8.8 0-16 7.2-16 16l0 352c0 8.8 7.2 16 16 16s16-7.2 16-16l0-352c0-8.8-7.2-16-16-16zM377 273c9.4-9.4 9.4-24.6 0-33.9L233 95c-6.9-6.9-17.2-8.9-26.2-5.2S192 102.3 192 112l0 80-64 0 0 0-80 0c-26.5 0-48 21.5-48 48l0 32c0 26.5 21.5 48 48 48l144 0 0 80c0 9.7 5.8 18.5 14.8 22.2s19.3 1.7 26.2-5.2L377 273zM128 288l-80 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l80 0 0 0 80 0c8.8 0 16-7.2 16-16L224 131.3 348.7 256 224 380.7 224 304c0-8.8-7.2-16-16-16l-80 0z"]],
    "mailbox": [576, 512, [128234], "f813", ["M234.5 96L416 96c70.7 0 128 57.3 128 128l0 192c0 17.7-14.3 32-32 32l-232.6 0c5.4-9.4 8.6-20.3 8.6-32l0-208c0-45.2-20.9-85.6-53.5-112zM320 240c0 8.8 7.2 16 16 16l48 0 0 64c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-144 0c-8.8 0-16 7.2-16 16z", "M234.5 96c32.6 26.4 53.5 66.8 53.5 112l0 208c0 11.7-3.1 22.6-8.6 32L512 448c17.7 0 32-14.3 32-32l0-192c0-70.7-57.3-128-128-128L234.5 96zM144 96C82.1 96 32 146.1 32 208l0 208c0 17.7 14.3 32 32 32l160 0c17.7 0 32-14.3 32-32l0-208c0-61.9-50.1-112-112-112zm0-32l272 0c88.4 0 160 71.6 160 160l0 192c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 208C0 128.5 64.5 64 144 64zM96 224l96 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zm224 16c0-8.8 7.2-16 16-16l144 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-64-48 0c-8.8 0-16-7.2-16-16zm96 16l0 64 64 0 0-64-64 0z"]],
    "message-heart": [512, 512, [], "e5c9", ["M32 128l0 224c0 35.3 28.7 64 64 64l40 0c13.3 0 24 10.7 24 24l0 68 112-84c6.9-5.2 15.3-8 24-8l120 0c35.3 0 64-28.7 64-64l0-224c0-35.3-28.7-64-64-64L96 64c-35.3 0-64 28.7-64 64zm112 96c0-35.3 28.7-64 64-64l2.9 0c16.7 0 32.8 6.3 45.1 17.5 12.3-11.2 28.4-17.5 45.1-17.5l2.9 0c35.3 0 64 28.7 64 64 0 35.3-23.1 64.5-45 84.6-22.4 20.6-46.8 34.7-55.9 39.6-7 3.8-15.3 3.8-22.2 0-9.1-4.9-33.5-19-55.9-39.6-21.8-20.1-45-49.3-45-84.6z", "M179.2 533.6l0 0 112-84c1.4-1 3.1-1.6 4.8-1.6l120 0c53 0 96-43 96-96l0-224c0-53-43-96-96-96L96 32C43 32 0 75 0 128L0 352c0 53 43 96 96 96l32 0 0 68c0 15.5 12.5 28 28 28 6.1 0 12-2 16.8-5.6l6.4-4.8zM160 448l0-8c0-13.3-10.7-24-24-24l-40 0c-35.3 0-64-28.7-64-64l0-224c0-35.3 28.7-64 64-64l320 0c35.3 0 64 28.7 64 64l0 224c0 35.3-28.7 64-64 64l-120 0c-8.7 0-17.1 2.8-24 8l-112 84 0-60zM276.4 202.2c6.5-6.5 15.4-10.2 24.7-10.2l2.9 0c17.7 0 32 14.3 32 32 0 21.4-14.5 42.5-34.6 61-16.9 15.5-35.4 27-45.4 32.7-10-5.7-28.5-17.2-45.4-32.7-20.1-18.5-34.6-39.7-34.6-61 0-17.7 14.3-32 32-32l2.9 0c9.3 0 18.1 3.7 24.7 10.2l9.1 9.1c3 3 7.1 4.7 11.3 4.7s8.3-1.7 11.3-4.7l9.1-9.1zM301.1 160c-16.7 0-32.8 6.3-45.1 17.5-12.3-11.2-28.4-17.5-45.1-17.5l-2.9 0c-35.3 0-64 28.7-64 64 0 35.3 23.1 64.5 45 84.6 22.4 20.6 46.8 34.7 55.9 39.6 7 3.8 15.3 3.8 22.2 0 9.1-4.9 33.5-19 55.9-39.6 21.8-20.1 45-49.3 45-84.6 0-35.3-28.7-64-64-64l-2.9 0z"]],
    "message-middle-top": [512, 512, ["comment-middle-top-alt"], "e1e2", ["M32 160l0 224c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-224c0-35.3-28.7-64-64-64l-76 0c-7.6 0-14.7-3.6-19.2-9.6L256 0 196 80c-7.6 10.1-19.4 16-32 16L96 96c-35.3 0-64 28.7-64 64z", "M512 384c0 53-43 96-96 96L96 480c-53 0-96-43-96-96L0 160c0-53 43-96 96-96l68 0c2.5 0 4.9-1.2 6.4-3.2l60-80c6-8.1 15.5-12.8 25.6-12.8s19.6 4.7 25.6 12.8L344 64 416 64c53 0 96 43 96 96l0 224zm-96 64c35.3 0 64-28.7 64-64l0-224c0-35.3-28.7-64-64-64l-76 0c-7.6 0-14.7-3.6-19.2-9.6L256 0 196 80c-7.6 10.1-19.4 16-32 16L96 96c-35.3 0-64 28.7-64 64l0 224c0 35.3 28.7 64 64 64l320 0z"]],
    "users-rays": [576, 512, [], "e593", ["M176 400c8.8 0 16-7.2 16-16l0-8c0-39.8 32.2-72 72-72l48 0c39.8 0 72 32.2 72 72l0 8c0 8.8 7.2 16 16 16l-224 0zM336 144a48 48 0 1 1 -96 0 48 48 0 1 1 96 0z", "M4.7-27.3c-6.2 6.2-6.2 16.4 0 22.6l56 56c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-56-56c-6.2-6.2-16.4-6.2-22.6 0zm566.6 0c-6.2-6.2-16.4-6.2-22.6 0l-56 56c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l56-56c6.2-6.2 6.2-16.4 0-22.6zM27.3 539.3l56-56c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-56 56c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0zm544 0c6.2-6.2 6.2-16.4 0-22.6l-56-56c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l56 56c6.2 6.2 16.4 6.2 22.6 0zM288 96a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm0 128a80 80 0 1 0 0-160 80 80 0 1 0 0 160zM144 168c0-13.2 6.4-24.9 16.3-32.2 .8-13.4 3.7-26.2 8.4-38.2-32.4 7-56.7 35.9-56.7 70.4 0 39.8 32.2 72 72 72 5.9 0 11.6-.7 17.1-2-9.6-8.9-17.8-19.2-24.3-30.6-18.6-3.4-32.7-19.7-32.7-39.3zm248 72c39.8 0 72-32.2 72-72 0-34.5-24.3-63.3-56.7-70.4 4.6 12 7.5 24.8 8.4 38.2 9.9 7.3 16.3 19 16.3 32.2 0 19.6-14.1 35.9-32.7 39.3-6.5 11.4-14.7 21.7-24.3 30.6 5.5 1.3 11.2 2 17.1 2zM149.3 277.9C108.9 292.2 80 330.7 80 376l0 8c0 8.8 7.2 16 16 16s16-7.2 16-16l0-8c0-1.9 .1-3.8 .2-5.7 1.9-35.2 15.5-67.3 37.1-92.4zm314.5 92.4c.2 1.9 .2 3.8 .2 5.7l0 8c0 8.8 7.2 16 16 16s16-7.2 16-16l0-8c0-45.3-28.9-83.8-69.3-98.1 21.6 25.1 35.2 57.2 37.1 92.4zM264 272c-57.4 0-104 46.6-104 104l0 8c0 8.8 7.2 16 16 16s16-7.2 16-16l0-8c0-39.8 32.2-72 72-72l48 0c39.8 0 72 32.2 72 72l0 8c0 8.8 7.2 16 16 16s16-7.2 16-16l0-8c0-57.4-46.6-104-104-104l-48 0z"]],
    "circles-overlap": [576, 512, [], "e600", ["M192 304c0 28.8 6.9 56 19.2 80 95.7-1.7 172.8-79.8 172.8-176 0-28.8-6.9-56-19.2-80-95.7 1.7-172.8 79.8-172.8 176z", "M174.7 380.8c-9.5-23.8-14.7-49.7-14.7-76.8 0-107 80.9-195.2 184.8-206.7-32.3-39.8-81.6-65.3-136.8-65.3-97.2 0-176 78.8-176 176 0 85.8 61.4 157.3 142.7 172.8zm17.7 34.6C84.8 407.4 0 317.6 0 208 0 93.1 93.1 0 208 0 281.9 0 346.8 38.5 383.7 96.6 491.2 104.6 576 194.4 576 304 576 418.9 482.9 512 368 512 294.1 512 229.2 473.5 192.3 415.4zm38.9-.7c32.3 39.8 81.6 65.3 136.8 65.3 97.2 0 176-78.8 176-176 0-85.8-61.4-157.3-142.7-172.8 9.5 23.8 14.7 49.7 14.7 76.8 0 107-80.9 195.2-184.8 206.7zM364.8 128c-95.7 1.7-172.8 79.8-172.8 176 0 28.8 6.9 56 19.2 80 95.7-1.7 172.8-79.8 172.8-176 0-28.8-6.9-56-19.2-80z"]],
    "rainbow": [640, 512, [127752], "f75b", ["M16 448c8.8 0 16-7.2 16-16l0-80C32 192.9 160.9 64 320 64S608 192.9 608 352l0 80c0 8.8 7.2 16 16 16l-120 0c8.8 0 16-7.2 16-16l0-84c0-112.7-91.3-204-204-204S112 235.3 112 348l0 84c0 8.8 7.2 16 16 16L16 448zm112 0c8.8 0 16-7.2 16-16l0-84c0-95 77-172 172-172s172 77 172 172l0 84c0 8.8 7.2 16 16 16l-104 0c8.8 0 16-7.2 16-16l0-80c0-53-43-96-96-96s-96 43-96 96l0 80c0 8.8 7.2 16 16 16l-112 0z", "M320 64C160.9 64 32 192.9 32 352l0 80c0 8.8-7.2 16-16 16S0 440.8 0 432l0-80C0 175.3 143.3 32 320 32S640 175.3 640 352l0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80C608 192.9 479.1 64 320 64zm-4 112c-95 0-172 77-172 172l0 84c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-84c0-112.7 91.3-204 204-204s204 91.3 204 204l0 84c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-84c0-95-77-172-172-172zM256 352l0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80c0-53 43-96 96-96s96 43 96 96l0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80c0-35.3-28.7-64-64-64s-64 28.7-64 64z"]],
    "box-arrow-down-arrow-up": [448, 512, [], "e795", ["M32 160l0 256c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-256-384 0zm7.3-32l168.7 0 0-80-95.1 0c-10.3 0-20 5-26 13.4L39.3 128zM84.7 324.7c6.2-6.2 16.4-6.2 22.6 0L128 345.4 128 224c0-8.8 7.2-16 16-16s16 7.2 16 16l0 121.4 20.7-20.7 2.5-2.1c6.2-4.1 14.7-3.4 20.1 2.1s6.2 13.9 2.1 20.1l-2.1 2.5-48 48c-5.5 5.5-13.9 6.2-20.1 2.1l-2.5-2.1-48-48c-6.2-6.2-6.2-16.4 0-22.6zM240 48l0 80 168.7 0-47.6-66.6c-5.3-7.4-13.3-12.1-22.2-13.2l-3.8-.2-95.1 0zm4.7 212.7l48-48 2.5-2.1c6.2-4.1 14.7-3.4 20.1 2.1l48 48 2.1 2.5c4.1 6.2 3.4 14.7-2.1 20.1s-13.9 6.2-20.1 2.1l-2.5-2.1-20.7-20.7 0 121.4c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-121.4-20.7 20.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6z", "M335.1 16c20.7 0 40.1 10 52.1 26.8l48.9 68.5c7.7 10.8 11.9 23.9 11.9 37.2l0 267.5-.3 6.5c-3.1 30.1-27 54.1-57.1 57.1l-6.5 .3-320 0-6.5-.3c-30.1-3.1-54.1-27-57.1-57.1L0 416 0 148.5c0-11.7 3.2-23.1 9.2-33l2.7-4.2 48.9-68.5c10.5-14.7 26.7-24.2 44.4-26.3l7.7-.5 222.1 0zM32 416c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-256-384 0 0 256zM295.2 210.6c6.2-4.1 14.7-3.4 20.1 2.1l48 48 2.1 2.5c4.1 6.2 3.4 14.7-2.1 20.1s-13.9 6.2-20.1 2.1l-2.5-2.1-20.7-20.7 0 121.4c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-121.4-20.7 20.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l48-48 2.5-2.1zM144 208c8.8 0 16 7.2 16 16l0 121.4 20.7-20.7 2.5-2.1c6.2-4.1 14.7-3.4 20.1 2.1s6.2 13.9 2.1 20.1l-2.1 2.5-48 48c-5.5 5.5-13.9 6.2-20.1 2.1l-2.5-2.1-48-48c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0L128 345.4 128 224c0-8.8 7.2-16 16-16zM112.9 48c-10.3 0-20 5-26 13.4l-47.6 66.6 168.7 0 0-80-95.1 0zM240 128l168.7 0-47.6-66.6c-5.3-7.4-13.3-12.1-22.2-13.2l-3.8-.2-95.1 0 0 80z"]],
    "left-from-dotted-line": [512, 512, [], "e6c2", ["M35.3 256L160 380.7 160 304c0-8.8 7.2-16 16-16l160 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16-53.3 0-106.7 0-160 0-8.8 0-16-7.2-16-16L160 131.3 35.3 256z", "M7 239l0 0c-9.4 9.4-9.4 24.6 0 33.9l0 0 144 144c6.9 6.9 17.2 8.9 26.2 5.2S192 409.7 192 400l0-80 144 0c26.5 0 48-21.5 48-48l0-32c0-26.5-21.5-48-48-48l-80 0 0 0-64 0 0-80c0-9.7-5.8-18.5-14.8-22.2S157.9 88.2 151 95L7 239zm249-15l0 0 80 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-160 0c-8.8 0-16 7.2-16 16L160 380.7 35.3 256 160 131.3 160 208c0 8.8 7.2 16 16 16l80 0zM464 424a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm0-112a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm24-88a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM464 88a24 24 0 1 0 48 0 24 24 0 1 0 -48 0z"]],
    "sitemap": [512, 512, [], "f0e8", ["M32 384l64 0 0 64-64 0 0-64zM224 64l64 0 0 64-64 0 0-64zm0 320l64 0 0 64-64 0 0-64zm192 0l64 0 0 64-64 0 0-64z", "M288 64l0 64-64 0 0-64 64 0zm-64 96l16 0 0 64-128 0c-35.3 0-64 28.7-64 64l0 64-16 0c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-16 0 0-64c0-17.7 14.3-32 32-32l128 0 0 96-16 0c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-16 0 0-96 128 0c17.7 0 32 14.3 32 32l0 64-16 0c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-16 0 0-64c0-35.3-28.7-64-64-64l-128 0 0-64 16 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-64 0c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32zM32 384l64 0 0 64-64 0 0-64zm192 0l64 0 0 64-64 0 0-64zm192 0l64 0 0 64-64 0 0-64z"]],
    "caravan-simple": [640, 512, ["caravan-alt"], "e000", ["M64 96l0 256c0 17.7 14.3 32 32 32l49.6 0c14.6-28.5 44.2-48 78.4-48s63.8 19.5 78.4 48l209.6 0 0-224c0-53-43-96-96-96L96 64C78.3 64 64 78.3 64 96zm64 72c0-22.1 17.9-40 40-40l48 0c22.1 0 40 17.9 40 40l0 48c0 22.1-17.9 40-40 40l-48 0c-22.1 0-40-17.9-40-40l0-48zm192 0c0-22.1 17.9-40 40-40l48 0c22.1 0 40 17.9 40 40l0 48c0 22.1-17.9 40-40 40l-48 0c-22.1 0-40-17.9-40-40l0-48z", "M416 64c53 0 96 43 96 96l0 224-209.6 0c-14.6-28.5-44.2-48-78.4-48s-63.8 19.5-78.4 48L96 384c-17.7 0-32-14.3-32-32L64 96c0-17.7 14.3-32 32-32l320 0zM96 416l40.4 0c-.2 2.6-.4 5.3-.4 8 0 48.6 39.4 88 88 88s88-39.4 88-88c0-2.7-.1-5.4-.4-8L624 416c8.8 0 16-7.2 16-16s-7.2-16-16-16l-80 0 0-224c0-70.7-57.3-128-128-128L96 32C60.7 32 32 60.7 32 96l0 256c0 35.3 28.7 64 64 64zm72-256l48 0c4.4 0 8 3.6 8 8l0 48c0 4.4-3.6 8-8 8l-48 0c-4.4 0-8-3.6-8-8l0-48c0-4.4 3.6-8 8-8zm-40 8l0 48c0 22.1 17.9 40 40 40l48 0c22.1 0 40-17.9 40-40l0-48c0-22.1-17.9-40-40-40l-48 0c-22.1 0-40 17.9-40 40zm280-8c4.4 0 8 3.6 8 8l0 48c0 4.4-3.6 8-8 8l-48 0c-4.4 0-8-3.6-8-8l0-48c0-4.4 3.6-8 8-8l48 0zm-48-32c-22.1 0-40 17.9-40 40l0 48c0 22.1 17.9 40 40 40l48 0c22.1 0 40-17.9 40-40l0-48c0-22.1-17.9-40-40-40l-48 0zM224 368a56 56 0 1 1 0 112 56 56 0 1 1 0-112z"]],
    "face-grin-stars": [512, 512, [129321, "grin-stars"], "f587", ["M0 256c0-37.5 8.1-73.2 22.6-105.3l27.4 26.7-7.5 43.5C38 247 65.4 267 88.9 254.6l39.1-20.6 39.1 20.6c23.5 12.3 50.9-7.6 46.4-33.7l-7.5-43.5 31.6-30.8c19-18.5 8.5-50.8-17.7-54.6L176.2 85.6 156.7 46c-4.3-8.8-11.7-14.3-19.9-16.6 16.5-8.7 34.2-15.7 52.6-20.6 3.9 4.8 7.4 10.1 10.3 16l6.3 12.8C222.1 33.9 238.8 32 256 32s33.9 1.9 49.9 5.6l6.3-12.8c2.9-5.9 6.4-11.3 10.3-16 18.4 5 36 11.9 52.6 20.6-8.2 2.3-15.5 7.8-19.9 16.6L335.8 85.6 292 92c-26.2 3.8-36.7 36.1-17.7 54.6l31.6 30.8-7.5 43.5c-4.5 26.1 23 46.1 46.4 33.7l39.1-20.6 39.1 20.6c23.5 12.3 50.9-7.6 46.4-33.7l-7.5-43.5 27.3-26.7c14.5 32.1 22.6 67.8 22.6 105.3 0 2.6 0 5.2-.1 7.8 .1-2.2 .1-4.4 .1-6.7-7.1 16.9-19.9 30.7-35.7 39.4-19.1 104.4-110.5 183.5-220.3 183.5S54.7 400.9 35.7 296.5c-15.7-8.7-28.6-22.5-35.7-39.4 0-.4 0-.7 0-1.1zm102.5 77.3C122 399.6 183.4 448 256 448s134-48.4 153.5-114.7c3.4-11.7-8.4-21-20-17.3-39.9 12.8-85.3 20-133.5 20s-93.6-7.2-133.5-20c-11.6-3.7-23.4 5.6-20 17.3z", "M256 512C115 512 .6 398 0 257.1 7.1 274.1 19.9 287.9 35.7 296.5 54.7 400.9 146.1 480 256 480s201.3-79.1 220.3-183.5c15.7-8.7 28.6-22.5 35.7-39.4-.6 140.9-115 254.9-256 254.9zm0-480c-17.2 0-33.9 1.9-49.9 5.6l-6.3-12.8C196.8 18.8 193.3 13.5 189.4 8.7 210.7 3 233 0 256 0s45.3 3 66.6 8.7c-3.9 4.7-7.4 10.1-10.3 16l-6.3 12.8C289.9 33.9 273.2 32 256 32zm0 336c-38 0-74.5-4.2-108.5-12 22.7 36.1 62.8 60 108.5 60s85.8-23.9 108.5-60c-34 7.8-70.5 12-108.5 12zm153.5-34.7C390 399.6 328.6 448 256 448S122 399.6 102.5 333.3c-3.4-11.7 8.4-21 20-17.3 39.9 12.8 85.3 20 133.5 20s93.6-7.2 133.5-20c11.6-3.7 23.4 5.6 20 17.3zM355.3 46C367 22.2 401 22.2 412.7 46L432.2 85.6 476 92c26.2 3.8 36.7 36.1 17.7 54.6l-31.6 30.8 7.5 43.5c4.5 26.1-23 46.1-46.4 33.7l-39.1-20.6-39.1 20.6C321.4 267 294 247 298.5 220.9l7.5-43.5-31.6-30.8C255.3 128 265.8 95.8 292 92l43.7-6.4 19.5-39.6zM384 60.2l-23.3 47.2c-2.3 4.7-6.8 8-12 8.8l-52 7.6 37.7 36.7c3.8 3.7 5.5 9 4.6 14.2l-8.9 51.8 46.5-24.5c4.7-2.5 10.2-2.5 14.9 0l46.5 24.5-8.9-51.8c-.9-5.2 .8-10.5 4.6-14.2l37.7-36.7-52-7.6c-5.2-.8-9.7-4-12-8.8L384 60.2zM156.7 46L176.2 85.6 220 92c26.2 3.8 36.7 36.1 17.7 54.6l-31.6 30.8 7.5 43.5c4.5 26.1-23 46.1-46.4 33.7L128 234.1 88.9 254.6C65.4 267 38 247 42.5 220.9l7.5-43.5-31.6-30.8C-.7 128 9.8 95.8 36 92L79.8 85.6 99.3 46C111 22.2 145 22.2 156.7 46zm-52 61.3c-2.3 4.7-6.8 8-12 8.8l-52 7.6 37.7 36.7c3.8 3.7 5.5 9 4.6 14.2l-8.9 51.8 46.5-24.5c4.7-2.5 10.2-2.5 14.9 0l46.5 24.5-8.9-51.8c-.9-5.2 .8-10.5 4.6-14.2l37.7-36.7-52-7.6c-5.2-.8-9.7-4-12-8.8L128 60.2 104.7 107.3z"]],
    "message-sms": [512, 512, [], "e1e5", ["M32 128l0 224c0 35.3 28.7 64 64 64l40 0c13.3 0 24 10.7 24 24l0 68 112-84c6.9-5.2 15.3-8 24-8l120 0c35.3 0 64-28.7 64-64l0-224c0-35.3-28.7-64-64-64L96 64c-35.3 0-64 28.7-64 64zm67.2 84.5c0-21.9 17.8-39.7 39.7-39.7l21.1 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-21.1 0c-4.3 0-7.7 3.5-7.7 7.7 0 2.9 1.7 5.6 4.3 6.9l25 12.5c13.5 6.7 22 20.5 22 35.5 0 21.9-17.8 39.7-39.7 39.7l-27.5 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l27.5 0c4.3 0 7.7-3.5 7.7-7.7 0-2.9-1.7-5.6-4.3-6.9l-25-12.5c-13.5-6.7-22-20.5-22-35.5zm102.4-23.7c0-7.2 4.8-13.5 11.7-15.4s14.3 1 18 7.2l24.7 41.1 24.7-41.1c3.7-6.2 11.1-9.1 18-7.2s11.7 8.2 11.7 15.4l0 102.4c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-44.6-8.7 14.5c-2.9 4.8-8.1 7.8-13.7 7.8s-10.8-3-13.7-7.8l-8.7-14.5 0 44.6c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-102.4zm128 23.7c0-21.9 17.8-39.7 39.7-39.7l21.1 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-21.1 0c-4.3 0-7.7 3.5-7.7 7.7 0 2.9 1.7 5.6 4.3 6.9l25 12.5c13.5 6.7 22 20.5 22 35.5 0 21.9-17.8 39.7-39.7 39.7l-27.5 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l27.5 0c4.3 0 7.7-3.5 7.7-7.7 0-2.9-1.7-5.6-4.3-6.9l-25-12.5c-13.5-6.7-22-20.5-22-35.5z", "M179.2 533.6l0 0 112-84c1.4-1 3.1-1.6 4.8-1.6l120 0c53 0 96-43 96-96l0-224c0-53-43-96-96-96L96 32C43 32 0 75 0 128L0 352c0 53 43 96 96 96l32 0 0 68c0 15.5 12.5 28 28 28 6.1 0 12-2 16.8-5.6l6.4-4.8zM160 448l0-8c0-13.3-10.7-24-24-24l-40 0c-35.3 0-64-28.7-64-64l0-224c0-35.3 28.7-64 64-64l320 0c35.3 0 64 28.7 64 64l0 224c0 35.3-28.7 64-64 64l-120 0c-8.7 0-17.1 2.8-24 8l-112 84 0-60zM138.9 172.8c-21.9 0-39.7 17.8-39.7 39.7 0 15 8.5 28.8 22 35.5l25 12.5c2.6 1.3 4.3 4 4.3 6.9 0 4.3-3.5 7.7-7.7 7.7l-27.5 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l27.5 0c21.9 0 39.7-17.8 39.7-39.7 0-15.1-8.5-28.8-22-35.5l-25-12.5c-2.6-1.3-4.3-4-4.3-6.9 0-4.3 3.5-7.7 7.7-7.7l21.1 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-21.1 0zm190.7 39.7c0 15 8.5 28.8 22 35.5l25 12.5c2.6 1.3 4.3 4 4.3 6.9 0 4.3-3.5 7.7-7.7 7.7l-27.5 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l27.5 0c21.9 0 39.7-17.8 39.7-39.7 0-15.1-8.5-28.8-22-35.5l-25-12.5c-2.6-1.3-4.3-4-4.3-6.9 0-4.3 3.5-7.7 7.7-7.7l21.1 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-21.1 0c-21.9 0-39.7 17.8-39.7 39.7zm-98.3-32c-3.7-6.2-11.1-9.1-18-7.2s-11.7 8.2-11.7 15.4l0 102.4c0 8.8 7.2 16 16 16s16-7.2 16-16l0-44.6 8.7 14.5c2.9 4.8 8.1 7.8 13.7 7.8s10.8-3 13.7-7.8l8.7-14.5 0 44.6c0 8.8 7.2 16 16 16s16-7.2 16-16l0-102.4c0-7.2-4.8-13.5-11.7-15.4s-14.3 1-18 7.2l-24.7 41.1-24.7-41.1z"]],
    "comments-question": [576, 512, [], "e14e", ["M32 144c0 29.1 9.6 56.4 26.5 79.3 6.4 8.8 8 20.2 4.1 30.3l-22 57.8 79.5-30.3c6.6-2.5 13.9-2.8 20.7-.7 16 4.9 33.2 7.5 51.2 7.5 91 0 160-67 160-144S283 0 192 0 32 67 32 144zm90.8-42.8C122.8 63 153.8 32 192 32s69.2 31 69.2 69.2c0 35.8-24.3 53.7-42.1 61.7-7.8 3.5-11.1 9.2-11.1 13.1 0 8.8-7.2 16-16 16s-16-7.2-16-16c0-20.8 15.3-35.7 30.1-42.3 12.2-5.4 23.2-14.7 23.2-32.5 0-20.6-16.7-37.2-37.2-37.2s-37.2 16.7-37.2 37.2c0 8.8-7.2 16-16 16s-16-7.2-16-16zM212 240a20 20 0 1 1 -40 0 20 20 0 1 1 40 0zm15.4 125.5c15 63.8 77.4 114.5 156.6 114.5 18 0 35.2-2.7 51.2-7.5 6.8-2.1 14.1-1.8 20.7 .7l79.5 30.3-22-57.8c-3.9-10.2-2.3-21.6 4.1-30.3 16.8-22.9 26.5-50.1 26.5-79.3 0-64.8-48.9-122.5-118.6-139.2-22.9 89.5-102.9 155.4-198 168.7z", "M58.5 223.3c6.4 8.8 8 20.2 4.1 30.3l-22 57.8 79.5-30.3c6.6-2.5 13.9-2.8 20.7-.7 16 4.9 33.2 7.5 51.2 7.5 91 0 160-67 160-144S283 0 192 0 32 67 32 144c0 29.1 9.6 56.4 26.5 79.3zm-25.8 19C12 214.2 0 180.4 0 144 0 46.8 86-32 192-32s192 78.8 192 176-86 176-192 176c-21.2 0-41.5-3.1-60.6-8.9l-104 39.6c-2.3 .9-4.7 1.3-7.2 1.3-11.2 0-20.3-9.1-20.3-20.3 0-2.5 .4-4.9 1.3-7.2l31.3-82.3zM195.2 368c10.9-.1 21.7-1 32.3-2.4 15 63.8 77.4 114.5 156.6 114.5 18 0 35.2-2.7 51.2-7.5 6.8-2.1 14.1-1.8 20.7 .7l79.5 30.3-22-57.8c-3.9-10.2-2.3-21.6 4.1-30.3 16.8-22.9 26.5-50.1 26.5-79.3 0-64.8-48.9-122.5-118.6-139.2 2.6-10.2 4.5-20.7 5.6-31.5 83.3 19.2 145 88.3 145 170.7 0 36.4-12 70.2-32.7 98.2l31.3 82.3c.9 2.3 1.3 4.7 1.3 7.2 0 11.2-9.1 20.3-20.3 20.3-2.5 0-4.9-.5-7.2-1.3l-104-39.6c-19 5.8-39.4 8.9-60.6 8.9-94.1 0-172.4-62.1-188.8-144zM192 64c-20.6 0-37.2 16.7-37.2 37.2 0 8.8-7.2 16-16 16s-16-7.2-16-16C122.8 63 153.8 32 192 32s69.2 31 69.2 69.2c0 35.8-24.3 53.7-42.1 61.7-7.8 3.5-11.1 9.2-11.1 13.1 0 8.8-7.2 16-16 16s-16-7.2-16-16c0-20.8 15.3-35.7 30.1-42.3 12.2-5.4 23.2-14.7 23.2-32.5 0-20.6-16.7-37.2-37.2-37.2zM172 240a20 20 0 1 1 40 0 20 20 0 1 1 -40 0z"]],
    "sort-up": [384, 512, ["sort-asc"], "f0de", ["M32 192L352 192 192 32 32 192z", "M192 32L352 192 32 192 192 32zM2.4 204.3c5 12 16.6 19.8 29.6 19.8l320 0c12.9 0 24.6-7.8 29.6-19.8s2.2-25.7-6.9-34.9l-160-160c-12.5-12.5-32.8-12.5-45.3 0l-160 160c-9.2 9.2-11.9 22.9-6.9 34.9z"]],
    "billboard": [576, 512, [], "e5cd", ["M64 128l0 256 448 0 0-256c0-17.7-14.3-32-32-32l-80 0 0 48 32 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l32 0 0-48-160 0 0 48 32 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l32 0 0-48-80 0c-17.7 0-32 14.3-32 32z", "M384 32c8.8 0 16 7.2 16 16l0 16 80 0c35.3 0 64 28.7 64 64l0 256 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-256 0 0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80-256 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0 0-256c0-35.3 28.7-64 64-64l80 0 0-16c0-8.8 7.2-16 16-16s16 7.2 16 16l0 16 160 0 0-16c0-8.8 7.2-16 16-16zM288 384l224 0 0-256c0-17.7-14.3-32-32-32l-80 0 0 48 32 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l32 0 0-48-160 0 0 48 32 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l32 0 0-48-80 0c-17.7 0-32 14.3-32 32l0 256 224 0z"]],
    "eye": [576, 512, [128065], "f06e", ["M196.1 283.9c11.9 39.4 48.6 68.1 91.9 68.1 53 0 96-43 96-96 0-43.3-28.7-79.9-68.1-91.9 2.7 8.8 4.1 18.2 4.1 27.9 0 53-43 96-96 96-9.7 0-19.1-1.4-27.9-4.1z", "M288 64c-140.8 0-229.3 128-256 192 26.7 64 115.2 192 256 192 140.8 0 229.3-128 256-192-26.7-64-115.2-192-256-192zM95.4 112.6C142.5 68.8 207.2 32 288 32s145.5 36.8 192.6 80.6c46.8 43.5 78.1 95.4 93 131.1 3.3 7.9 3.3 16.7 0 24.6-14.9 35.7-46.2 87.7-93 131.1-47.1 43.7-111.8 80.6-192.6 80.6S142.5 443.2 95.4 399.4c-46.8-43.5-78.1-95.4-93-131.1-3.3-7.9-3.3-16.7 0-24.6 14.9-35.7 46.2-87.7 93-131.1zM288 352c53 0 96-43 96-96 0-43.3-28.7-79.9-68.1-91.9 2.7 8.8 4.1 18.2 4.1 27.9 0 53-43 96-96 96-9.7 0-19.1-1.4-27.9-4.1 11.9 39.4 48.6 68.1 91.9 68.1zM160.2 263.8c-.2-2.6-.2-5.2-.2-7.8 0-12.2 1.7-23.9 4.9-35 .3-.9 .5-1.8 .8-2.7 12.4-40.4 44.3-72.2 84.7-84.7 11.9-3.7 24.6-5.6 37.7-5.6 2.5 0 5 .1 7.4 .2l.4 0c67.1 4 120.2 59.7 120.2 127.8 0 70.7-57.3 128-128 128-68.1 0-123.8-53.2-127.8-120.2zm32.1-16.1c9.3 5.3 20.1 8.4 31.6 8.4 35.3 0 64-28.7 64-64 0-11.5-3-22.3-8.4-31.6-46.4 4-83.3 40.9-87.3 87.3z"]],
    "arrow-down-small-big": [512, 512, ["sort-size-down-alt"], "f88d", ["M320 80c0-8.8 7.2-16 16-16l64 0c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16l-64 0c-8.8 0-16-7.2-16-16l0-64zm0 224c0-8.8 7.2-16 16-16l128 0c8.8 0 16 7.2 16 16l0 128c0 8.8-7.2 16-16 16l-128 0c-8.8 0-16-7.2-16-16l0-128z", "M235.3 379.3l-96 96c-6.2 6.2-16.4 6.2-22.6 0l-96-96c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0L112 425.4 112 48c0-8.8 7.2-16 16-16s16 7.2 16 16l0 377.4 68.7-68.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6zM320 80l0 64c0 8.8 7.2 16 16 16l64 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16l-64 0c-8.8 0-16 7.2-16 16zm-32 0c0-26.5 21.5-48 48-48l64 0c26.5 0 48 21.5 48 48l0 64c0 26.5-21.5 48-48 48l-64 0c-26.5 0-48-21.5-48-48l0-64zm32 224l0 128c0 8.8 7.2 16 16 16l128 0c8.8 0 16-7.2 16-16l0-128c0-8.8-7.2-16-16-16l-128 0c-8.8 0-16 7.2-16 16zm-32 0c0-26.5 21.5-48 48-48l128 0c26.5 0 48 21.5 48 48l0 128c0 26.5-21.5 48-48 48l-128 0c-26.5 0-48-21.5-48-48l0-128z"]],
    "axe": [640, 512, [129683], "f6b2", ["M67.3 451.3c-7 7-7 18.4 0 25.4s18.4 7 25.4 0l232-232-25.4-25.4-232 232zM264.6 116.7c-6.2 6.2-6.2 16.4 0 22.6L404.3 279c7.5 7.5 11.7 17.7 11.7 28.3l0 76.7c106 0 192-86 192-192l-76.7 0c-10.6 0-20.8-4.2-28.3-11.7L363.3 40.6c-6.2-6.2-16.4-6.2-22.6 0l-76.1 76.1z", "M503 180.3L363.3 40.6c-6.2-6.2-16.4-6.2-22.6 0l-76.1 76.1c-6.2 6.2-6.2 16.4 0 22.6L404.3 279c7.5 7.5 11.7 17.7 11.7 28.3l0 76.7c106 0 192-86 192-192l-76.7 0c-10.6 0-20.8-4.2-28.3-11.7zM385.9 17.9L525.7 157.7c1.5 1.5 3.5 2.3 5.7 2.3l84.7 0c13.3 0 24 10.7 24 24l0 8c0 123.7-100.3 224-224 224l-8 0c-13.3 0-24-10.7-24-24l0-84.7c0-2.1-.8-4.2-2.3-5.7l-34.3-34.3-232 232c-19.5 19.5-51.1 19.5-70.6 0s-19.5-51.1 0-70.6l232-232-34.7-34.7c-18.7-18.7-18.7-49.1 0-67.9l76.1-76.1c18.7-18.7 49.1-18.7 67.9 0zM299.3 219.3l-232 232c-7 7-7 18.4 0 25.4s18.4 7 25.4 0l232-232-25.4-25.4zm184-206.6l48 48c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-48-48c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0z"]],
    "caret-left": [256, 512, [], "f0d9", ["M32.7 256c.1-.3 .3-.7 .7-1.1l126.9-126.9 0 256c-42.6-42.6-85.1-85.1-127.6-128z", "M9.7 233.4c-11.6 12.9-12.8 32.4 0 45.2l128 128c9.1 9.2 22.9 11.9 34.9 6.9l4.3-2.2c9.5-5.7 15.5-16.1 15.5-27.4l0-256-.3-4.8c-1.4-9.4-7-17.7-15.1-22.6l-4.3-2.2c-10.5-4.3-22.3-2.8-31.2 3.8l-3.7 3.1-128 128zm23 22.7c.1-.3 .3-.7 .7-1.1l126.9-126.9 0 256-127.7-127.7c0-.1 .1-.2 .1-.2z"]],
    "apple-whole": [448, 512, [127822, 127823, "apple-alt"], "f5d1", ["M32 288c0-33.8 8-67.7 22.8-92 14.2-23.5 33-36 57.2-36 21 0 48.7 8.4 71.1 17.1 26.2 10.2 55.6 10.2 81.9 0 22.4-8.7 50.1-17.1 71.1-17.1 24.3 0 43 12.5 57.2 36 14.7 24.3 22.8 58.2 22.8 92 0 57.5-18 106.6-43.6 140.8-26 34.7-57.4 51.2-84.4 51.2-13.2 0-32-2.7-45.3-5-12.3-2.2-25-2.2-37.3 0-13.3 2.3-32.1 5-45.3 5-27 0-58.4-16.5-84.4-51.2-25.6-34.2-43.6-83.3-43.6-140.8zM224 91.4C224 58.6 250.6 32 283.4 32l4.6 0 0 4.6C288 69.4 261.4 96 228.6 96l-4.6 0 0-4.6z", "M228.6 96l-4.6 0 0-4.6C224 58.6 250.6 32 283.4 32l4.6 0 0 4.6C288 69.4 261.4 96 228.6 96zm-18.3 32l18.3 0c50.5 0 91.4-40.9 91.4-91.4l0-18.3C320 8.2 311.8 0 301.7 0L283.4 0C232.9 0 192 40.9 192 91.4l0 18.3c0 10.1 8.2 18.3 18.3 18.3zM32 288c0-33.8 8-67.7 22.8-92 14.2-23.5 33-36 57.2-36 21 0 48.7 8.4 71.1 17.1 26.2 10.2 55.6 10.2 81.9 0 22.4-8.7 50.1-17.1 71.1-17.1 24.3 0 43 12.5 57.2 36 14.7 24.3 22.8 58.2 22.8 92 0 57.5-18 106.6-43.6 140.8-26 34.7-57.4 51.2-84.4 51.2-13.2 0-32-2.7-45.3-5-12.3-2.2-25-2.2-37.3 0-13.3 2.3-32.1 5-45.3 5-27 0-58.4-16.5-84.4-51.2-25.6-34.2-43.6-83.3-43.6-140.8zM160 512c16.2 0 37.4-3.2 50.8-5.5 8.7-1.5 17.6-1.5 26.3 0 13.5 2.4 34.6 5.5 50.8 5.5 80 0 160-96 160-224 0-76.3-35.7-160-112-160-27.3 0-59.7 10.3-82.7 19.3-18.8 7.3-39.9 7.3-58.7 0-22.9-8.9-55.4-19.3-82.7-19.3-76.3 0-112 83.7-112 160 0 128 80 224 160 224z"]],
    "scroll-torah": [576, 512, ["torah"], "f6a0", ["M32 80l0 352c0 17.7 14.3 32 32 32s32-14.3 32-32L96 80c0-17.7-14.3-32-32-32S32 62.3 32 80zm96 0l0 352 320 0 0-352-320 0zm50 120.3c2.8-5.1 8.2-8.3 14-8.3l51.8 0 30.7-48.5c2.9-4.6 8-7.5 13.5-7.5s10.6 2.8 13.5 7.5l30.7 48.5 51.8 0c5.8 0 11.2 3.2 14 8.3s2.6 11.3-.5 16.3l-24.9 39.5 24.9 39.5c3.1 4.9 3.3 11.2 .5 16.3s-8.2 8.3-14 8.3l-51.8 0-30.7 48.5c-2.9 4.6-8 7.5-13.5 7.5s-10.6-2.8-13.5-7.5L243.8 320 192 320c-5.8 0-11.2-3.2-14-8.3s-2.6-11.3 .5-16.3l24.9-39.5-24.9-39.5c-3.1-4.9-3.3-11.2-.5-16.3zM480 80l0 352c0 17.7 14.3 32 32 32s32-14.3 32-32l0-352c0-17.7-14.3-32-32-32s-32 14.3-32 32z", "M96 80l0 352c0 17.7-14.3 32-32 32s-32-14.3-32-32L32 80c0-17.7 14.3-32 32-32S96 62.3 96 80zM64 496c23.7 0 44.4-12.9 55.4-32l337.1 0c11.1 19.1 31.7 32 55.4 32 35.3 0 64-28.7 64-64l0-352c0-35.3-28.7-64-64-64-23.7 0-44.4 12.9-55.4 32L119.4 48C108.4 28.9 87.7 16 64 16 28.7 16 0 44.7 0 80L0 432c0 35.3 28.7 64 64 64zM448 80l0 352-320 0 0-352 320 0zm32 352l0-352c0-17.7 14.3-32 32-32s32 14.3 32 32l0 352c0 17.7-14.3 32-32 32s-32-14.3-32-32zM301.5 143.5c-2.9-4.6-8-7.5-13.5-7.5s-10.6 2.8-13.5 7.5L243.8 192 192 192c-5.8 0-11.2 3.2-14 8.3s-2.6 11.3 .5 16.3l24.9 39.5-24.9 39.5c-3.1 4.9-3.3 11.2-.5 16.3s8.2 8.3 14 8.3l51.8 0 30.7 48.5c2.9 4.6 8 7.5 13.5 7.5s10.6-2.8 13.5-7.5l30.7-48.5 51.8 0c5.8 0 11.2-3.2 14-8.3s2.6-11.3-.5-16.3l-24.9-39.5 24.9-39.5c3.1-4.9 3.3-11.2 .5-16.3s-8.2-8.3-14-8.3l-51.8 0-30.7-48.5zm-35.4 73.1L288 182 309.8 216.5c2.9 4.6 8 7.5 13.5 7.5l31.6 0-14.8 23.5c-3.3 5.2-3.3 11.9 0 17.1l14.8 23.5-31.6 0c-5.5 0-10.6 2.8-13.5 7.5L288 330 266.2 295.5c-2.9-4.6-8-7.5-13.5-7.5l-31.6 0 14.8-23.5c3.3-5.2 3.3-11.9 0-17.1L221 224 252.6 224c5.5 0 10.6-2.8 13.5-7.5z"]],
    "house-lock": [640, 512, [], "e510", ["M112 202.2L288 37.9 458.2 196.7C423.1 219.5 400 259.1 400 304l0 24.4c-19.6 17.6-32 43.1-32 71.5l0-31.9c0-35.3-28.7-64-64-64l-32 0c-35.3 0-64 28.7-64 64l0 112-64 0c-17.7 0-32-14.3-32-32l0-245.8z", "M277.1 4.3c6.1-5.7 15.7-5.7 21.8 0L489.3 182c-11.1 3.5-21.5 8.5-31.1 14.7L288 37.9 112 202.2 112 448c0 17.7 14.3 32 32 32l64 0 0-112c0-35.3 28.7-64 64-64l32 0c35.3 0 64 28.7 64 64l0 127.9c0 5.5 .5 10.9 1.3 16.1L144 512c-35.3 0-64-28.7-64-64l0-216-21.1 19.7c-6.5 6-16.6 5.7-22.6-.8s-5.7-16.6 .8-22.6l240-224zM240 480l96 0 0-112c0-17.7-14.3-32-32-32l-32 0c-17.7 0-32 14.3-32 32l0 112zM448 352.1l0-48c0-44.2 35.8-80 80-80s80 35.8 80 80l0 50.6c18.6 6.6 32 24.4 32 45.3l0 96c0 26.5-21.5 48-48 48l-128 0c-26.5 0-48-21.5-48-48l0-96c0-20.9 13.4-38.7 32-45.3l0-2.6zm0 47.9l0 96c0 8.8 7.2 16 16 16l128 0c8.8 0 16-7.2 16-16l0-96c0-8.2-6.2-15-14.3-15.9l-131.5 0c-8 .9-14.3 7.7-14.3 15.9zm128-95.9c0-26.5-21.5-48-48-48s-48 21.5-48 48l0 47.9 96 0 0-47.9z"]],
    "square-litecoin": [448, 512, [], "e6f7", ["M32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64C46.3 64 32 78.3 32 96zm80.8 165.1c-2.8-8.4 1.7-17.4 10.1-20.2l37.1-12.4 0-84.5c0-8.8 7.2-16 16-16s16 7.2 16 16l0 73.8 74.9-25c8.4-2.8 17.4 1.7 20.2 10.1s-1.7 17.4-10.1 20.2l-85.1 28.4 0 100.5 112 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-128 0c-8.8 0-16-7.2-16-16l0-105.8-26.9 9c-8.4 2.8-17.4-1.7-20.2-10.1z", "M64 64C46.3 64 32 78.3 32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm176 32c8.8 0 16 7.2 16 16l0 73.8 74.9-25c8.4-2.8 17.4 1.7 20.2 10.1s-1.7 17.4-10.1 20.2l-85.1 28.4 0 100.5 112 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-128 0c-8.8 0-16-7.2-16-16l0-105.8-26.9 9c-8.4 2.8-17.4-1.7-20.2-10.1s1.7-17.4 10.1-20.2l37.1-12.4 0-84.5c0-8.8 7.2-16 16-16z"]],
    "arrows-left-right-to-line": [576, 512, [], "e4ba", ["", "M32 112l0 288c0 8.8-7.2 16-16 16S0 408.8 0 400L0 112c0-8.8 7.2-16 16-16s16 7.2 16 16zm544 0l0 288c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-288c0-8.8 7.2-16 16-16s16 7.2 16 16zM475.3 267.3l-80 80c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l52.7-52.7-274.7 0 52.7 52.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-80-80c-3-3-4.7-7.1-4.7-11.3s1.7-8.3 4.7-11.3l80-80c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6l-52.7 52.7 274.7 0-52.7-52.7c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l80 80c6.2 6.2 6.2 16.4 0 22.6z"]],
    "trash": [448, 512, [], "f1f8", ["M60.8 144L83.5 450.4c1.2 16.7 15.2 29.6 31.9 29.6l217.1 0c16.8 0 30.7-12.9 31.9-29.6L387.2 144 60.8 144zm88.7-80l149 0-11-36.6c-1.6-5.2-5.6-9.1-10.5-10.7-1.6-.3-3.2-.6-4.8-.7l-94.5 0c-.6 0-1.3 0-1.9 0-1.6 .2-3.2 .4-4.8 .7-5 1.6-9 5.5-10.5 10.7L149.5 64z", "M160.5 27.4c2-6.8 8.3-11.4 15.3-11.4l96.4 0c7.1 0 13.3 4.6 15.3 11.4l11 36.6-149 0 11-36.6zM116.1 64L16 64C7.2 64 0 71.2 0 80S7.2 96 16 96l416 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-100.1 0-13.7-45.8C312.1-2.1 293.4-16 272.2-16l-96.4 0c-21.2 0-39.9 13.9-46 34.2L116.1 64zM28.7 144L51.6 452.7c2.5 33.4 30.3 59.3 63.8 59.3l217.1 0c33.5 0 61.3-25.9 63.8-59.3l22.9-308.7-32.1 0-22.7 306.4c-1.2 16.7-15.2 29.6-31.9 29.6l-217.1 0c-16.8 0-30.7-12.9-31.9-29.6L60.8 144 28.7 144z"]],
    "face-sad-tear": [512, 512, [128546, "sad-tear"], "f5b4", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm88 102.4c0-19.4 13.1-38.3 23.6-53.4 6.7-9.6 13.8-18.8 21.4-27.6 2.8-3.3 6.6-5.4 11-5.4s8.1 2.1 11 5.4c7.6 8.8 14.7 18.1 21.4 27.6 10.5 15.1 23.6 34 23.6 53.4 0 31.8-25.1 57.6-56 57.6s-56-25.8-56-57.6zM200 208a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm72.4 113c5.1-.6 10.3-1 15.6-1 34.5 0 65.6 14.1 88.1 36.7 6.2 6.3 6.2 16.4-.1 22.6s-16.4 6.2-22.6-.1c-16.7-16.9-39.8-27.3-65.4-27.3-2.8 0-5.5 .1-8.3 .4-.8-11-3.3-21.6-7.3-31.4zM360 208a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M256 32a224 224 0 1 1 0 448 224 224 0 1 1 0-448zm0 480a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM200 208a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm136 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM208.4 305c-6.7-9.6-13.8-18.8-21.4-27.6-2.8-3.3-6.6-5.4-11-5.4s-8.1 2.1-11 5.4c-7.6 8.8-14.7 18.1-21.4 27.6-10.5 15.1-23.6 34-23.6 53.4 0 31.8 25.1 57.6 56 57.6s56-25.8 56-57.6c0-19.4-13.1-38.3-23.6-53.4zM176 314.9c2.1 2.8 4.1 5.6 6.1 8.5 5.4 7.8 10 14.5 13.5 21.2 3.4 6.7 4.4 11.1 4.4 13.8 0 15-11.6 25.6-24 25.6s-24-10.6-24-25.6c0-2.7 1-7 4.4-13.8 3.4-6.7 8-13.5 13.5-21.2 2-2.9 4.1-5.7 6.1-8.5zM288 352c25.6 0 48.7 10.4 65.4 27.3 6.2 6.3 16.3 6.3 22.6 .1s6.3-16.3 .1-22.6c-22.5-22.7-53.6-36.7-88.1-36.7-5.3 0-10.5 .3-15.6 1 4 9.8 6.5 20.4 7.3 31.4 2.7-.2 5.5-.4 8.3-.4z"]],
    "tire-flat": [512, 512, [], "f632", ["M32 288c0 33.4 7.3 65 20.3 93.3 5 10.8 5 23.6-.6 34.7L34.1 451.4c-1.4 2.7-2.1 5.8-2.1 8.8 0 10.9 8.9 19.8 19.8 19.8l408.4 0c10.9 0 19.8-8.9 19.8-19.8 0-3.1-.7-6.1-2.1-8.8L460.2 416c-5.6-11.1-5.5-23.9-.6-34.7 13-28.4 20.3-60 20.3-93.3 0-123.7-100.3-224-224-224S32 164.3 32 288zm384 0a160 160 0 1 1 -320 0 160 160 0 1 1 320 0z", "M32 460.2c0 10.9 8.9 19.8 19.8 19.8l408.4 0c10.9 0 19.8-8.9 19.8-19.8 0-3.1-.7-6.1-2.1-8.8L460.2 416c-5.6-11.1-5.5-23.9-.6-34.7 13-28.4 20.3-60 20.3-93.3 0-123.7-100.3-224-224-224S32 164.3 32 288c0 33.4 7.3 65 20.3 93.3 5 10.8 5 23.6-.6 34.7l-17.7 35.3 0 0c-1.4 2.7-2.1 5.8-2.1 8.8zM512 288c0 38.1-8.3 74.2-23.2 106.7-1 2.2-1 4.8 .1 7l17.7 35.3c3.6 7.2 5.5 15.1 5.5 23.2 0 28.6-23.2 51.8-51.8 51.8L51.8 512c-28.6 0-51.8-23.2-51.8-51.8 0-8 1.9-16 5.5-23.2l17.7-35.3c1.1-2.2 1.1-4.8 .1-7-14.9-32.5-23.2-68.6-23.2-106.7 0-141.4 114.6-256 256-256S512 146.6 512 288zm-128 0c0-36.8-15.5-69.9-40.3-93.3l-38.2 52.6c9.1 11 14.5 25.2 14.5 40.6 0 1.4 0 2.7-.1 4l61.8 20.1c1.5-7.8 2.3-15.9 2.3-24.2zm-74.1 34.4c-8.6 13.5-22.1 23.5-38 27.6l0 65c44.3-5.5 81.5-33.6 99.8-72.4l-61.9-20.1zm-70 27.5c-15.8-4.1-29.3-14.1-37.9-27.5l-61.9 20.1c18.3 38.8 55.5 66.9 99.8 72.4l0-65zM128 288c0 8.3 .8 16.3 2.3 24.2L192.1 292c-.1-1.3-.1-2.7-.1-4 0-15.4 5.5-29.6 14.5-40.6-3.7-5.2-16.5-22.7-38.2-52.6-24.8 23.3-40.3 56.5-40.3 93.3zm128-64c8.3 0 16.3 1.6 23.6 4.5l38.2-52.6C299.5 165.8 278.4 160 256 160s-43.5 5.8-61.8 15.9c21.8 30 34.5 47.5 38.2 52.6 7.3-2.9 15.3-4.5 23.6-4.5zM96 288a160 160 0 1 1 320 0 160 160 0 1 1 -320 0zm192 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"]],
    "melon": [512, 512, [], "e310", ["M32 256c0 35.8 8.4 69.7 23.4 99.7 8.4-56.6 47.7-127.6 110.2-190.1S299.1 63.8 355.7 55.4C325.7 40.4 291.8 32 256 32 132.3 32 32 132.3 32 256zm62.5 74.2c-15.2 45.5-8.6 72.4 3.2 84.2s38.7 18.4 84.2 3.2c43.5-14.5 94.7-46.5 142-93.8s79.3-98.5 93.8-142c15.2-45.5 8.6-72.4-3.2-84.2s-38.7-18.4-84.2-3.2c-43.5 14.5-94.7 46.5-142 93.8s-79.3 98.5-93.8 142zm61.9 126.5c30 14.9 63.9 23.4 99.7 23.4 123.7 0 224-100.3 224-224 0-35.8-8.4-69.7-23.4-99.7-8.4 56.6-47.7 127.6-110.2 190.1S212.9 448.2 156.3 456.6z", "M480 256c0-35.8-8.4-69.7-23.4-99.7-8.4 56.6-47.7 127.6-110.2 190.1S212.9 448.2 156.3 456.6c30 14.9 63.9 23.4 99.7 23.4 123.7 0 224-100.3 224-224zM55.4 355.7c8.4-56.6 47.7-127.6 110.2-190.1S299.1 63.8 355.7 55.4c-30-14.9-63.9-23.4-99.7-23.4-123.7 0-224 100.3-224 224 0 35.8 8.4 69.7 23.4 99.7zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zM414.3 97.7c-11.8-11.8-38.7-18.4-84.2-3.2-43.5 14.5-94.7 46.5-142 93.8s-79.3 98.5-93.8 142c-15.2 45.5-8.6 72.4 3.2 84.2s38.7 18.4 84.2 3.2c43.5-14.5 94.7-46.5 142-93.8s79.3-98.5 93.8-142c15.2-45.5 8.6-72.4-3.2-84.2z"]],
    "fax": [512, 512, [128224, 128439], "f1ac", ["M32 176l0 256c0 8.8 7.2 16 16 16l64 0c8.8 0 16-7.2 16-16l0-256c0-8.8-7.2-16-16-16l-64 0c-8.8 0-16 7.2-16 16zm128 48l0 208c0 8.8 7.2 16 16 16l288 0c8.8 0 16-7.2 16-16l0-192c0-8.8-7.2-16-16-16l-304 0zm96 64a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm0 96a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm88-96a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm0 96a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm88-96a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm0 96a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M160 56c0-13.3 10.7-24 24-24l159.4 0c6.4 0 12.5 2.5 17 7L409 87.6c4.5 4.5 7 10.6 7 17l0 31.4 32 0 0-31.4c0-14.9-5.9-29.1-16.4-39.6L383 16.4C372.5 5.9 358.3 0 343.4 0L184 0c-30.9 0-56 25.1-56 56l0 74.7c-5-1.8-10.4-2.7-16-2.7l-64 0c-26.5 0-48 21.5-48 48L0 432c0 26.5 21.5 48 48 48l64 0c12.3 0 23.5-4.6 32-12.2 8.5 7.6 19.7 12.2 32 12.2l288 0c26.5 0 48-21.5 48-48l0-192c0-26.5-21.5-48-48-48l-304 0 0-136zM128 176l0 256c0 8.8-7.2 16-16 16l-64 0c-8.8 0-16-7.2-16-16l0-256c0-8.8 7.2-16 16-16l64 0c8.8 0 16 7.2 16 16zm48 272c-8.8 0-16-7.2-16-16l0-208 304 0c8.8 0 16 7.2 16 16l0 192c0 8.8-7.2 16-16 16l-288 0zm80-160a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM232 408a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM344 288a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM320 408a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM432 288a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM408 408a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]],
    "arrow-left-long-to-line": [640, 512, [], "e3d4", ["", "M0 112L0 400c0 8.8 7.2 16 16 16s16-7.2 16-16l0-288c0-8.8-7.2-16-16-16S0 103.2 0 112zM132.7 244.7c-6.2 6.2-6.2 16.4 0 22.6l144 144c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L182.6 272 624 272c8.8 0 16-7.2 16-16s-7.2-16-16-16l-441.4 0 116.7-116.7c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-144 144z"]],
    "user-music": [640, 512, [], "f8eb", ["M48 512c8.8 0 16-7.2 16-16l0-16c0-79.5 64.5-144 144-144l96 0c23 0 44.7 5.4 64 15l0 34.2c-49.9 6.9-96 45.7-96 102.9 0 8.4 1 16.4 2.8 23.9L48 512zM352 128a96 96 0 1 1 -192 0 96 96 0 1 1 192 0z", "M160 128a96 96 0 1 1 192 0 96 96 0 1 1 -192 0zm224 0a128 128 0 1 0 -256 0 128 128 0 1 0 256 0zM64 480c0-79.5 64.5-144 144-144l96 0c23 0 44.7 5.4 64 15l0-35c-19.8-7.7-41.4-12-64-12l-96 0c-97.2 0-176 78.8-176 176l0 16c0 8.8 7.2 16 16 16s16-7.2 16-16l0-16zM640 240c0-4.8-2.2-9.4-5.9-12.4s-8.6-4.2-13.4-3.2l-192 40c-7.4 1.5-12.7 8.1-12.7 15.7l0 159.6c-9.4-4.8-20.3-7.5-32-7.5-35.6 0-64 25.3-64 56s28.4 56 64 56 64-25.3 64-56l0-115.1 160-33.3 0 67.9c-9.4-4.8-20.3-7.5-32-7.5-35.6 0-64 25.3-64 56s28.4 56 64 56 64-25.3 64-56L640 240zm-32 67l-160 33.3 0-47.3 160-33.3 0 47.3zM352 488.1c0-9.6 10.4-24 32-24s32 14.4 32 24-10.4 24-32 24-32-14.4-32-24zm224-56c21.6 0 32 14.4 32 24s-10.4 24-32 24-32-14.4-32-24 10.4-24 32-24z"]],
    "person-circle-plus": [640, 512, [], "e541", ["M176 156.7l0 179.3 96 0 0-179.3c-14.4-8.2-30.9-12.7-48-12.7s-33.6 4.5-48 12.7zM200 24a24 24 0 1 0 48 0 24 24 0 1 0 -48 0z", "M200 24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm80 0a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zM140.8 191.1c1-1.7 2.1-3.4 3.2-5L144 528c0 8.8 7.2 16 16 16s16-7.2 16-16l0-160 96 0 0 160c0 8.8 7.2 16 16 16s16-7.2 16-16l0-341.9c1.1 1.6 2.2 3.3 3.2 5l47.4 79c7.4-8 15.4-15.4 24.1-22.1l-44-73.4C311.3 135.8 269.3 112 224 112s-87.3 23.8-110.6 62.6L50.3 279.8c-4.5 7.6-2.1 17.4 5.5 21.9s17.4 2.1 22-5.5l63.1-105.1zM272 336l-96 0 0-179.3c14.4-8.2 30.9-12.7 48-12.7s33.6 4.5 48 12.7L272 336zm112 64a112 112 0 1 1 224 0 112 112 0 1 1 -224 0zm256 0a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zM512 336c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 48-48 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l48 0 0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48 48 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-48 0 0-48z"]],
    "hamsa": [512, 512, [], "f665", ["M32 317.3c0 7.8 3.1 15.2 8.6 20.7l90.2 90.2C164 461.3 209 480 256 480s92-18.7 125.3-51.9l90.2-90.2c5.5-5.5 8.6-12.9 8.6-20.7 0-16.2-13.1-29.3-29.3-29.3L400 288c-8.8 0-16-7.2-16-16l0-176c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 112c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-144c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 144c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-112c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 176c0 8.8-7.2 16-16 16l-50.7 0C45.1 288 32 301.1 32 317.3zM144 352c0-8.9 3.2-18 9.9-25 7.3-7.6 21.3-21 38.7-32.7 17.1-11.4 39.5-22.4 63.4-22.4s46.2 11 63.4 22.4c17.4 11.6 31.4 25.1 38.7 32.7 6.7 7 9.9 16.1 9.9 25s-3.2 18-9.9 25c-7.3 7.6-21.3 21-38.7 32.7-17.1 11.4-39.5 22.4-63.4 22.4s-46.2-11-63.4-22.4c-17.4-11.6-31.4-25.1-38.7-32.7-6.7-7-9.9-16.1-9.9-25z", "M256 32c17.7 0 32 14.3 32 32l0 144c0 8.8 7.2 16 16 16s16-7.2 16-16l0-112c0-17.7 14.3-32 32-32s32 14.3 32 32l0 176c0 8.8 7.2 16 16 16l50.7 0c16.2 0 29.3 13.1 29.3 29.3 0 7.8-3.1 15.2-8.6 20.7l-90.2 90.2C348 461.3 303 480 256 480s-92-18.7-125.3-51.9L40.6 337.9C35.1 332.5 32 325 32 317.3 32 301.1 45.1 288 61.3 288l50.7 0c8.8 0 16-7.2 16-16l0-176c0-17.7 14.3-32 32-32s32 14.3 32 32l0 112c0 8.8 7.2 16 16 16s16-7.2 16-16l0-144c0-17.7 14.3-32 32-32zm0-32C228.1 0 204.3 17.9 195.6 42.8 185.4 36 173.2 32 160 32 124.7 32 96 60.7 96 96l0 160-34.7 0C27.4 256 0 283.4 0 317.3 0 333.5 6.5 349.1 17.9 360.6l90.2 90.2C147.3 490 200.5 512 256 512s108.7-22 147.9-61.3l90.2-90.2c11.5-11.5 17.9-27.1 17.9-43.3 0-33.8-27.4-61.3-61.3-61.3l-34.7 0 0-160c0-35.3-28.7-64-64-64-13.2 0-25.4 4-35.6 10.8-8.7-24.9-32.5-42.8-60.4-42.8zM176.9 349.3c6.5-6.7 18.7-18.4 33.5-28.2 15.1-10.1 31.1-17 45.6-17s30.5 6.9 45.6 17c14.8 9.9 27 21.5 33.5 28.2 .4 .5 .9 1.3 .9 2.7s-.5 2.3-.9 2.7c-6.5 6.7-18.7 18.4-33.5 28.2-15.1 10.1-31.1 17-45.6 17s-30.5-6.9-45.6-17c-14.8-9.9-27-21.5-33.5-28.2-.4-.5-.9-1.3-.9-2.7s.5-2.3 .9-2.7zM256 272c-23.8 0-46.2 11-63.4 22.4-17.4 11.6-31.4 25.1-38.7 32.7-6.7 7-9.9 16.1-9.9 25s3.2 18 9.9 25c7.3 7.6 21.3 21 38.7 32.7 17.1 11.4 39.5 22.4 63.4 22.4s46.2-11 63.4-22.4c17.4-11.6 31.4-25.1 38.7-32.7 6.7-7 9.9-16.1 9.9-25s-3.2-18-9.9-25c-7.3-7.6-21.3-21-38.7-32.7-17.1-11.4-39.5-22.4-63.4-22.4zm0 104a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]],
    "house-building": [640, 512, [], "e1b1", ["M64 259.3L64 448c0 17.7 14.3 32 32 32l224 0c17.7 0 32-14.3 32-32l0-188.7-144-126-144 126zM152 296c0-17.7 14.3-32 32-32l48 0c17.7 0 32 14.3 32 32l0 48c0 17.7-14.3 32-32 32l-48 0c-17.7 0-32-14.3-32-32l0-48z", "M576 32L352 32c-17.7 0-32 14.3-32 32l0 61-32-28 0-33c0-35.3 28.7-64 64-64L576 0c35.3 0 64 28.7 64 64l0 384c0 35.3-28.7 64-64 64l-164.1 0c6.7-9.7 12-20.4 15.4-32L576 480c17.7 0 32-14.3 32-32l0-384c0-17.7-14.3-32-32-32zm-88 88c0-8.8 7.2-16 16-16l16 0c8.8 0 16 7.2 16 16l0 16c0 8.8-7.2 16-16 16l-16 0c-8.8 0-16-7.2-16-16l0-16zm16 80l16 0c8.8 0 16 7.2 16 16l0 16c0 8.8-7.2 16-16 16l-16 0c-8.8 0-16-7.2-16-16l0-16c0-8.8 7.2-16 16-16zM488 312c0-8.8 7.2-16 16-16l16 0c8.8 0 16 7.2 16 16l0 16c0 8.8-7.2 16-16 16l-16 0c-8.8 0-16-7.2-16-16l0-16zM408 104l16 0c8.8 0 16 7.2 16 16l0 16c0 8.8-7.2 16-16 16l-16 0c-8.8 0-16-7.2-16-16l0-16c0-8.8 7.2-16 16-16zm-189.5-4l192 168c6.6 5.8 7.3 15.9 1.5 22.6s-15.9 7.3-22.6 1.5l-5.5-4.8 0 160.7c0 35.3-28.7 64-64 64L96 512c-35.3 0-64-28.7-64-64l0-160.7-5.5 4.8c-6.7 5.8-16.8 5.1-22.6-1.5S-1.2 273.8 5.5 268l192-168c6-5.3 15-5.3 21.1 0zM352 259.3l-144-126-144 126 0 188.7c0 17.7 14.3 32 32 32l224 0c17.7 0 32-14.3 32-32l0-188.7zM152 296c0-17.7 14.3-32 32-32l48 0c17.7 0 32 14.3 32 32l0 48c0 17.7-14.3 32-32 32l-48 0c-17.7 0-32-14.3-32-32l0-48zm32 0l0 48 48 0 0-48-48 0z"]],
    "person-circle-question": [640, 512, [], "e542", ["M176 156.7l0 179.3 96 0 0-179.3c-14.4-8.2-30.9-12.7-48-12.7s-33.6 4.5-48 12.7zM200 24a24 24 0 1 0 48 0 24 24 0 1 0 -48 0z", "M200 24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm80 0a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zM140.8 191.1c1-1.7 2.1-3.4 3.2-5L144 528c0 8.8 7.2 16 16 16s16-7.2 16-16l0-160 96 0 0 160c0 8.8 7.2 16 16 16s16-7.2 16-16l0-341.9c1.1 1.6 2.2 3.3 3.2 5l47.4 79c7.4-8 15.4-15.4 24.1-22.1l-44-73.4C311.3 135.8 269.3 112 224 112s-87.3 23.8-110.6 62.6L50.3 279.8c-4.5 7.6-2.1 17.4 5.5 21.9s17.4 2.1 22-5.5l63.1-105.1zM272 336l-96 0 0-179.3c14.4-8.2 30.9-12.7 48-12.7s33.6 4.5 48 12.7L272 336zm112 64a112 112 0 1 1 224 0 112 112 0 1 1 -224 0zm256 0a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zM496 484a20 20 0 1 0 0-40 20 20 0 1 0 0 40zm0-140c13.3 0 24 10.7 24 24 0 7.2-4.2 13.7-10.8 16.6l-12.4 5.5c-10.2 4.5-16.8 14.7-16.8 25.9 0 8.8 7.2 16 16 16 8 0 14.6-5.9 15.8-13.5l10.4-4.6c18.1-8.1 29.8-26 29.8-45.9 0-30.9-25.1-56-56-56-27.1 0-49.7 19.2-54.9 44.8-1.8 8.7 3.8 17.1 12.5 18.9s17.1-3.8 18.9-12.5c2.2-11 11.9-19.2 23.5-19.2z"]],
    "crate-empty": [512, 512, [], "e151", ["M32 280l0 72 448 0 0-72c0-13.3-10.7-24-24-24L56 256c-13.3 0-24 10.7-24 24zm0 104l0 72c0 13.3 10.7 24 24 24l400 0c13.3 0 24-10.7 24-24l0-72-448 0zm64-80a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm0 128a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zM448 304a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm0 128a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M480 384l0 72c0 13.3-10.7 24-24 24L56 480c-13.3 0-24-10.7-24-24l0-72 448 0zm0-32l-448 0 0-72c0-13.3 10.7-24 24-24l400 0c13.3 0 24 10.7 24 24l0 72zm32 0l0-72c0-30.9-25.1-56-56-56L56 224c-30.9 0-56 25.1-56 56L0 456c0 30.9 25.1 56 56 56l400 0c30.9 0 56-25.1 56-56l0-104zM96 304a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm336 16a16 16 0 1 0 0-32 16 16 0 1 0 0 32zM96 432a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm336 16a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"]],
    "sun-haze": [576, 512, [], "f765", ["M57.3 160.5l91.6-18.5c12.6-2.6 22.5-12.4 25-25L192.5 25.3 270.3 77c10.7 7.1 24.7 7.1 35.4 0l77.9-51.7 18.5 91.6c2.6 12.6 12.4 22.5 25 25l91.6 18.5-51.7 77.9c-7.1 10.7-7.1 24.7 0 35.4l30.7 46.3-117.8 0c12.7-18.1 20.1-40.2 20.1-64 0-61.9-50.1-112-112-112S176 194.1 176 256c0 23.8 7.4 45.9 20.1 64L78.3 320 109 273.7c7.1-10.7 7.1-24.7 0-35.4L57.3 160.5z", "M402.1 116.9L383.5 25.3 305.7 77c-10.7 7.1-24.7 7.1-35.4 0l-77.9-51.7-18.5 91.6c-2.6 12.6-12.4 22.5-25 25L57.3 160.5 109 238.3c7.1 10.7 7.1 24.7 0 35.4l-30.7 46.3-38.4 0 42.5-64-58.2-87.8c-5-7.5-4.6-16-2-22.4s8.4-12.6 17.2-14.4L142.6 110.6 163.4 7.3c1.8-8.8 8.1-14.6 14.4-17.2s14.9-3 22.4 2L288 50.3 375.8-7.9c7.5-5 16-4.6 22.4-2s12.6 8.4 14.4 17.2l20.9 103.2 103.2 20.9c8.8 1.8 14.6 8.1 17.2 14.4s3 14.9-2 22.4l-58.2 87.8 42.5 64-38.4 0-30.7-46.3c-7.1-10.7-7.1-24.7 0-35.4l51.7-77.9-91.6-18.5c-12.6-2.6-22.5-12.4-25-25zM400 256c0 23.8-7.4 45.9-20.1 64L336 320c19.4-14.6 32-37.8 32-64 0-44.2-35.8-80-80-80s-80 35.8-80 80c0 26.2 12.6 49.4 32 64l-43.9 0c-12.7-18.1-20.1-40.2-20.1-64 0-61.9 50.1-112 112-112s112 50.1 112 112zM512 400c0 8.8-7.2 16-16 16L16 416c-8.8 0-16-7.2-16-16s7.2-16 16-16l480 0c8.8 0 16 7.2 16 16zM64 496c0-8.8 7.2-16 16-16l96 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16zm176 0c0-8.8 7.2-16 16-16l304 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-304 0c-8.8 0-16-7.2-16-16z"]],
    "circle-3": [512, 512, [], "e0f0", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm152-80c0-8.8 7.2-16 16-16l72 0c30.9 0 56 25.1 56 56 0 15.7-6.4 29.8-16.8 40 10.4 10.2 16.8 24.3 16.8 40 0 30.9-25.1 56-56 56l-72 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l72 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-56 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l56 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-72 0c-8.8 0-16-7.2-16-16z", "M256 32a224 224 0 1 1 0 448 224 224 0 1 1 0-448zm0 480a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm16-272l-56 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l56 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-72 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l72 0c30.9 0 56-25.1 56-56 0-15.7-6.4-29.8-16.8-40 10.4-10.2 16.8-24.3 16.8-40 0-30.9-25.1-56-56-56l-72 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l72 0c13.3 0 24 10.7 24 24s-10.7 24-24 24z"]],
    "clipboard-check": [384, 512, [], "f46c", ["M32 96l0 352c0 17.7 14.3 32 32 32l256 0c17.7 0 32-14.3 32-32l0-352c0-17.7-14.3-32-32-32l-16.6 0c-3.9 27.1-27.2 48-55.4 48l-112 0c-28.2 0-51.6-20.9-55.4-48L64 64C46.3 64 32 78.3 32 96zm68.5 231.6c-6.1-6.4-6-16.5 .4-22.6s16.5-5.9 22.6 .4l41.2 42.6 94.4-129.8c5.2-7.1 15.2-8.7 22.3-3.5s8.7 15.2 3.5 22.3L179.3 382.2c-2.8 3.8-7.1 6.2-11.8 6.5s-9.3-1.4-12.6-4.8l-54.4-56.3z", "M248 0c22.3 0 41.6 13.1 50.6 32L320 32c35.3 0 64 28.7 64 64l0 352c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l21.4 0c9-18.9 28.3-32 50.6-32L248 0zM64 64C46.3 64 32 78.3 32 96l0 352c0 17.7 14.3 32 32 32l256 0c17.7 0 32-14.3 32-32l0-352c0-17.7-14.3-32-32-32l-16.6 0c-3.9 27.1-27.2 48-55.4 48l-112 0c-28.2 0-51.6-20.9-55.4-48L64 64zM259.1 218.2c5.2-7.1 15.2-8.7 22.3-3.5s8.7 15.2 3.5 22.3L179.3 382.2c-2.8 3.8-7.1 6.2-11.8 6.5s-9.3-1.4-12.6-4.8l-54.4-56.3c-6.1-6.4-6-16.5 .4-22.6s16.5-5.9 22.6 .4l41.2 42.6 94.4-129.8zM136 32c-13.3 0-24 10.7-24 24s10.7 24 24 24l112 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L136 32z"]],
    "share-from-square": [576, 512, [61509, "share-square"], "f14d", ["M192 240c0 35.3 14.9 60.8 32.8 79.3-.6-4.6-.8-9.2-.8-13.9 0-62.7 50.8-113.5 113.5-113.5l62.5 0c8.8 0 16 7.2 16 16L416 281.4 537.4 160 416 38.6 416 112c0 8.8-7.2 16-16 16l-96 0c-61.9 0-112 50.1-112 112z", "M416 112L416 38.6 537.4 160 416 281.4 416 208c0-8.8-7.2-16-16-16l-62.5 0c-62.7 0-113.5 50.8-113.5 113.5 0 4.6 .3 9.3 .8 13.9-17.9-18.5-32.8-44.1-32.8-79.3 0-61.9 50.1-112 112-112l96 0c8.8 0 16-7.2 16-16zM411.3 0C396.2 0 384 12.2 384 27.3l0 68.7-80 0c-79.5 0-144 64.5-144 144 0 93.4 82.8 134.8 100.6 142.6 .9 .4 1.9 .7 2.8 .9l.1 0c7.2 1.7 14.6-1.9 17.9-8.5s1.6-14.7-4.1-19.4c-14.7-12.2-21.4-30-21.4-50.2 0-45 36.5-81.5 81.5-81.5l46.5 0 0 68.7c0 15.1 12.2 27.3 27.3 27.3 7.2 0 14.2-2.9 19.3-8L571.3 171.3c6.2-6.2 6.2-16.4 0-22.6L430.6 8c-5.1-5.1-12.1-8-19.3-8zM112 96c-44.2 0-80 35.8-80 80l0 256c0 44.2 35.8 80 80 80l256 0c44.2 0 80-35.8 80-80l0-32c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 32c0 26.5-21.5 48-48 48l-256 0c-26.5 0-48-21.5-48-48l0-256c0-26.5 21.5-48 48-48l32 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-32 0z"]],
    "fork-knife": [512, 512, ["utensils-alt"], "f2e6", ["M48.9 71.4L179.3 201.9c2 10.5 5.2 20.8 9.5 30.9-15.6 15.6-31.1 31.1-46.7 46.7L58.6 195.9C24.7 162 21.5 109 48.9 71.4zM256.1 172c0-23.1 12-45.3 31.1-59.3L401.6 28.9c7-5.1 8.6-14.9 3.7-22l41.1 41.2c-3.5 .4-6.9 1.9-9.6 4.6l-112 112c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l112-112c2.7-2.7 4.2-6 4.6-9.5l40.5 40.6c-7-4.3-16.3-2.6-21.3 4.2L399.4 224.9c-14 19.1-36.1 31.1-59.3 31.1-18.8 0-36.8-7.5-50.1-20.8l-13.1-13.1c-13.3-13.3-20.8-31.3-20.8-50.1z", "M405 6.5c5.2 7.1 3.7 17.1-3.4 22.4L287.3 112.7c-19.1 14-31.1 36.1-31.1 59.3 0 18.8 7.5 36.8 20.8 50.1L290 235.2c13.3 13.3 31.3 20.8 50.1 20.8 23.1 0 45.3-12 59.3-31.1l83.8-114.3c5.2-7.1 15.2-8.7 22.4-3.4s8.7 15.2 3.4 22.4L425.2 243.8c-19.5 26.6-50.9 44.2-85.1 44.2-25 0-49.1-9.1-67.8-25.5L27.4 507.3c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6L249.6 239.8c-16.4-18.7-25.5-42.8-25.5-67.8 0-34.2 17.6-65.6 44.2-85.1L382.6 3.1c7.1-5.2 17.1-3.7 22.4 3.4zm54.4 46.1c6.2 6.2 6.2 16.4 0 22.6l-112 112c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l112-112c6.2-6.2 16.4-6.2 22.6 0zM177.8 155c-1.9 15.5-1.4 31.3 1.6 46.8L48.9 71.4C21.5 109 24.7 162 58.6 195.9l83.6 83.5-22.6 22.6-83.5-83.6c-50-50-50-131 0-181l.8-.8c6.2-6.2 16.4-6.2 22.6 0L177.8 155zm307 352.3l-169.4-169.4-1.5-4.5c14.3 2.4 28.9 2.7 43.2 .9L507.4 484.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0z"]],
    "receipt": [384, 512, [129534], "f543", ["M32 43.6l0 424.9 32.1-18.3c4.9-2.8 11-2.8 15.9 0l48.6 27.8 56.3-28.2c4.5-2.3 9.8-2.3 14.3 0l56.3 28.2 48.6-27.8c4.9-2.8 11-2.8 15.9 0l32.1 18.3 0-424.9-32.1 18.3c-4.9 2.8-11 2.8-15.9 0l-48.6-27.8-56.3 28.2c-4.5 2.3-9.8 2.3-14.3 0L128.5 34.1 79.9 61.9c-4.9 2.8-11 2.8-15.9 0L32 43.6zM80 160c0-8.8 7.2-16 16-16l192 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L96 176c-8.8 0-16-7.2-16-16zm0 96c0-8.8 7.2-16 16-16l192 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L96 272c-8.8 0-16-7.2-16-16zm0 96c0-8.8 7.2-16 16-16l192 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L96 368c-8.8 0-16-7.2-16-16z", "M135.2 1.7c-4.8-2.4-10.4-2.2-15.1 .4L72 29.6 23.9 2.1C19-.7 12.9-.7 8 2.2S0 10.3 0 16L0 496c0 5.7 3 11 8 13.8s11 2.9 16 .1l48.1-27.5 48.1 27.5c4.6 2.7 10.3 2.8 15.1 .4l56.8-28.4 56.8 28.4c4.8 2.4 10.4 2.2 15.1-.4l48.1-27.5 48.1 27.5c5 2.8 11 2.8 16-.1s8-8.1 8-13.8l0-480c0-5.7-3-11-8-13.8s-11-2.9-16-.1L312 29.6 263.9 2.1c-4.6-2.7-10.3-2.8-15.1-.4L192 30.1 135.2 1.7zM79.9 61.9l48.6-27.8 56.3 28.2c4.5 2.3 9.8 2.3 14.3 0l56.3-28.2 48.6 27.8c4.9 2.8 11 2.8 15.9 0l32.1-18.3 0 424.9-32.1-18.3c-4.9-2.8-11-2.8-15.9 0l-48.6 27.8-56.3-28.2c-4.5-2.3-9.8-2.3-14.3 0l-56.3 28.2-48.6-27.8c-4.9-2.8-11-2.8-15.9 0L32 468.4 32 43.6 64.1 61.9c4.9 2.8 11 2.8 15.9 0zM96 144c-8.8 0-16 7.2-16 16s7.2 16 16 16l192 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L96 144zM80 352c0 8.8 7.2 16 16 16l192 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L96 336c-8.8 0-16 7.2-16 16zM96 240c-8.8 0-16 7.2-16 16s7.2 16 16 16l192 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L96 240z"]],
    "equals": [448, 512, [62764], "3d", ["", "M16 128c-8.8 0-16 7.2-16 16s7.2 16 16 16l416 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L16 128zm0 224c-8.8 0-16 7.2-16 16s7.2 16 16 16l416 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L16 352z"]],
    "diagram-lean-canvas": [576, 512, [], "e156", ["M32 96c0-17.7 14.3-32 32-32l64 0 0 224-96 0 0-192zm0 224l240 0 0 128-208 0c-17.7 0-32-14.3-32-32l0-96zM160 64l64 0 0 104-64 0 0-104zm0 136l64 0 0 88-64 0 0-88zM256 64l64 0 0 224-64 0 0-224zm48 256l240 0 0 96c0 17.7-14.3 32-32 32l-208 0 0-128zM352 64l64 0 0 104-64 0 0-104zm0 136l64 0 0 88-64 0 0-88zM448 64l64 0c17.7 0 32 14.3 32 32l0 192-96 0 0-224z", "M448 64l0 224 96 0 0-192c0-17.7-14.3-32-32-32l-64 0zm-32 0l-64 0 0 104 64 0 0-104zm-96 0l-64 0 0 224 64 0 0-224zm-96 0l-64 0 0 104 64 0 0-104zm-96 0L64 64C46.3 64 32 78.3 32 96l0 192 96 0 0-224zM32 320l0 96c0 17.7 14.3 32 32 32l208 0 0-128-240 0zM304 448l208 0c17.7 0 32-14.3 32-32l0-96-240 0 0 128zM0 96C0 60.7 28.7 32 64 32l448 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM224 288l0-88-64 0 0 88 64 0zm192-88l-64 0 0 88 64 0 0-88z"]],
    "box-arrow-up": [448, 512, [], "e827", ["M32 160l0 256c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-256-384 0zm7.3-32l168.7 0 0-80-95.1 0c-10.3 0-20 5-26 13.4L39.3 128zM140.7 284.7l72-72 2.5-2.1c6.2-4.1 14.7-3.4 20.1 2.1l72 72 2.1 2.5c4.1 6.2 3.4 14.7-2.1 20.1s-13.9 6.2-20.1 2.1l-2.5-2.1-44.7-44.7 0 121.4c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-121.4-44.7 44.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6zM240 48l0 80 168.7 0-47.6-66.6c-5.3-7.4-13.3-12.1-22.2-13.2l-3.8-.2-95.1 0z", "M335.1 16c20.7 0 40.1 10 52.1 26.8l48.9 68.5c7.7 10.8 11.9 23.9 11.9 37.2l0 267.5-.3 6.5c-3.1 30.1-27 54.1-57.1 57.1l-6.5 .3-320 0-6.5-.3c-30.1-3.1-54.1-27-57.1-57.1L0 416 0 148.5c0-11.7 3.2-23.1 9.2-33l2.7-4.2 48.9-68.5c10.5-14.7 26.7-24.2 44.4-26.3l7.7-.5 222.1 0zM32 416c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-256-384 0 0 256zM215.2 210.6c6.2-4.1 14.7-3.4 20.1 2.1l72 72 2.1 2.5c4.1 6.2 3.4 14.7-2.1 20.1s-13.9 6.2-20.1 2.1l-2.5-2.1-44.7-44.7 0 121.4c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-121.4-44.7 44.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l72-72 2.5-2.1zM112.9 48c-10.3 0-20 5-26 13.4l-47.6 66.6 168.7 0 0-80-95.1 0zM240 128l168.7 0-47.6-66.6c-5.3-7.4-13.3-12.1-22.2-13.2l-3.8-.2-95.1 0 0 80z"]],
    "chevron-up": [448, 512, [], "f077", ["", "M212.7 100.7c6.2-6.2 16.4-6.2 22.6 0l208 208c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L224 134.6 27.3 331.3c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l208-208z"]],
    "virus-slash": [576, 512, [], "e075", ["M149.2 94.6c2.8 .8 5.5 2.3 7.7 4.6l1.5 1.5c41.9 42 113.7 12.4 113.7-47l0-5.7c0-8.8 7.2-16 16-16s16 7.2 16 16l0 4.8c0 59.7 72.2 89.5 114.3 47.3l2.2-2.2c6.6-6.6 17.2-6.7 23.9-.4 7 6.6 7.2 17.6 .5 24.5l-2.8 2.8c-41.9 43-11.4 115.2 48.7 115.2l5.1 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-5.8 0c-59.4 0-89.1 71.8-47.1 113.7l1.6 1.6c2.1 2.1 3.6 4.6 4.4 7.3l-300-300z", "M27.3-27.2c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l544 544c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-94.6-94.6c9.3-18.7 6.1-42-9.4-57.5l-1.6-1.6c-21.8-21.8-6.4-59.1 24.5-59.1l5.8 0c26.5 0 48-21.5 48-48s-21.5-48-48-48l-5.1 0c-31.7 0-47.9-38.2-25.7-60.9l2.8-2.8c19.2-19.7 18.5-51.2-1.5-70.1-19.4-18.3-49.8-17.8-68.6 1.1l-2.2 2.2c-22 22.1-59.7 6.5-59.7-24.7l0-4.8c0-26.5-21.5-48-48-48s-48 21.5-48 48l0 5.7c0 30.8-37.3 46.2-59 24.4l-1.5-1.5c-15.6-15.7-39-18.8-57.8-9.4L27.3-27.2zM149.2 94.6c2.8 .8 5.5 2.3 7.7 4.6l1.5 1.5c41.9 42 113.7 12.4 113.7-47l0-5.7c0-8.8 7.2-16 16-16s16 7.2 16 16l0 4.8c0 59.7 72.2 89.5 114.3 47.3l2.2-2.2c6.6-6.6 17.2-6.7 23.9-.4 7 6.6 7.2 17.6 .5 24.5l-2.8 2.8c-41.9 43-11.4 115.2 48.7 115.2l5.1 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-5.8 0c-59.4 0-89.1 71.8-47.1 113.7l1.6 1.6c2.1 2.1 3.6 4.6 4.4 7.3l-300-300zM85.7 208L80 208c-26.5 0-48 21.5-48 48s21.5 48 48 48l5.8 0c30.9 0 46.3 37.3 24.5 59.1l-1.6 1.6c-19.5 19.5-19.5 51.1 0 70.6s51.1 19.5 70.6 0l1.6-1.6c21.8-21.8 59.1-6.4 59.1 24.5l0 5.8c0 26.5 21.5 48 48 48s48-21.5 48-48l0-5.8c0-18.7 13.8-31.8 29.4-34.3l-25.1-25.1c-20.8 10.6-36.4 31.8-36.4 59.4l0 5.8c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-5.8c0-59.4-71.8-89.1-113.7-47.1l-1.6 1.6c-7 7-18.4 7-25.4 0s-7-18.4 0-25.4l1.6-1.6c42-42 12.2-113.7-47.1-113.7L80 272c-8.8 0-16-7.2-16-16s7.2-16 16-16l5.7 0c27.6 0 48.9-15.5 59.4-36.4L120 178.5c-2.5 15.7-15.5 29.5-34.3 29.5z"]],
    "globe-stand": [448, 512, [], "f5f6", ["M80 192a128 128 0 1 0 256 0 128 128 0 1 0 -256 0z", "M28.7 348.7c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l10-10C99 394.1 145.1 412.1 192 415.4l0 64.6-112 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l256 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-112 0 0-64.6c51.9-3.7 102.7-25.4 142.4-65 83.7-83.7 87.3-217.1 10.9-305.1l10-10c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0L343.8 33.6c-6.2 6.2-6.2 16.4 0 22.6 75 75 75 196.5 0 271.5s-196.5 75-271.5 0c-6.2-6.2-16.4-6.2-22.6 0L28.7 348.7zM80 192a128 128 0 1 1 256 0 128 128 0 1 1 -256 0zm288 0a160 160 0 1 0 -320 0 160 160 0 1 0 320 0z"]],
    "ring-diamond": [384, 512, [], "e5ab", ["M122.8 71.4l39.3 59c9.7-1.5 19.7-2.3 29.9-2.3s20.2 .8 29.9 2.3l39.3-59-22.5-39.4-93.4 0-22.5 39.4z", "M136 0c-5.7 0-11 3.1-13.9 8.1l-32 56c-3 5.3-2.8 11.8 .6 16.8l38.4 57.7C54 164.6 0 236 0 320 0 426 86 512 192 512s192-86 192-192c0-84-54-155.4-129.1-181.5l38.4-57.7c3.4-5 3.6-11.6 .6-16.8l-32-56C259 3.1 253.7 0 248 0L136 0zm85.9 130.3c-9.7-1.5-19.7-2.3-29.9-2.3s-20.2 .8-29.9 2.3l-39.3-59 22.5-39.4 93.4 0 22.5 39.4-39.3 59zM32 320a160 160 0 1 1 320 0 160 160 0 1 1 -320 0z"]],
    "phone-rotary": [512, 512, [9742], "f8d3", ["M64 373.8c0-7.9 2.3-15.6 6.7-22.2l96.9-145.4c5.9-8.9 15.9-14.2 26.6-14.2l123.5 0c10.7 0 20.7 5.3 26.6 14.2l96.9 145.4c4.4 6.6 6.7 14.3 6.7 22.2l0 42.2c0 17.7-14.3 32-32 32L96 448c-17.7 0-32-14.3-32-32l0-42.2zM176 320a80 80 0 1 0 160 0 80 80 0 1 0 -160 0z", "M0 147.9L0 176c0 26.5 21.5 48 48 48l11.6 0 21.3-32-33 0c-8.8 0-16-7.2-16-16l0-28.1c0-4.5 1.7-6.9 2.9-7.9 29.7-23.8 108-76 221.1-76s191.3 52.2 221.1 76c1.2 1 2.9 3.4 2.9 7.9l0 28.1c0 8.8-7.2 16-16 16l-33 0 21.3 32 11.6 0c26.5 0 48-21.5 48-48l0-28.1c0-12.7-5-24.9-15-32.9-32.8-26.2-118-83-241-83S47.7 88.8 15 115C5 123 0 135.2 0 147.9zM64 373.8c0-7.9 2.3-15.6 6.7-22.2l96.9-145.4c5.9-8.9 15.9-14.2 26.6-14.2l123.5 0c10.7 0 20.7 5.3 26.6 14.2l96.9 145.4c4.4 6.6 6.7 14.3 6.7 22.2l0 42.2c0 17.7-14.3 32-32 32L96 448c-17.7 0-32-14.3-32-32l0-42.2zm-32 0L32 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-42.2c0-14.2-4.2-28.1-12.1-39.9L371 188.5c-11.5-17.2-30.5-27.7-51-28.5l0-32c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 32-64 0 0-32c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 32c-20.5 .7-39.5 11.3-51 28.5L44.1 333.9C36.2 345.7 32 359.6 32 373.8zM256 272a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm0 128a80 80 0 1 0 0-160 80 80 0 1 0 0 160z"]],
    "slash": [576, 512, [], "f715", ["", "M4.7-27.3c6.2-6.2 16.4-6.2 22.6 0l544 544c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L4.7-4.7c-6.2-6.2-6.2-16.4 0-22.6z"]],
    "arrow-down-to-dotted-line": [384, 512, [], "e095", ["", "M0 488c0 13.3 10.7 24 24 24s24-10.7 24-24-10.7-24-24-24-24 10.7-24 24zM180.7 379.3c6.2 6.2 16.4 6.2 22.6 0l144-144c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0L208 329.4 208 16c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 313.4-116.7-116.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l144 144zM136 512c13.3 0 24-10.7 24-24s-10.7-24-24-24-24 10.7-24 24 10.7 24 24 24zm88-24c0 13.3 10.7 24 24 24s24-10.7 24-24-10.7-24-24-24-24 10.7-24 24zm136 24c13.3 0 24-10.7 24-24s-10.7-24-24-24-24 10.7-24 24 10.7 24 24 24z"]],
    "saxophone-fire": [640, 512, ["sax-hot"], "f8db", ["M32 153.7c0 7.7 .9 15.1 2.5 22.3l25.2 0c15.4-31.7 47.2-58 61.3-68.5 4.1-3.1 9.7-3.1 13.8 0 14.1 10.5 46 36.8 61.3 68.5l25.2 0c1.7-7.1 2.6-14.6 2.6-22.3 0-16.6-6.3-35.9-16.9-55-8.9-16-20.2-30.7-31.6-42.4-.9 1-1.9 2.2-3 3.5-5.9 6.7-14.4 10.6-23.4 10.8s-17.6-3.4-23.7-9.9l-15.2-15.9-8.5-9.5C85.8 50.1 69.2 68.2 56.1 87.9 41.2 110.2 32 132.8 32 153.7zm0 188.2l0 7.6c0 72.1 58.5 130.6 130.6 130.6 39.2 0 76.2-17.6 101-47.9L498 145.6c9.1-11.1 22.8-17.6 37.2-17.6l66.2 0-17.9-17.9c-9-9-21.2-14.1-33.9-14.1l-27.6 0c-12.5 0-24.5 4.9-33.4 13.5L243.4 347.3c-8.3 8-19.4 12.5-31 12.5-24.6 0-44.5-19.9-44.5-44.5l0-2.5c0-8.8 2.5-17.4 7.1-24.9l20-32-149.8 0-11.1 61.2c-1.5 8.2-2.2 16.4-2.2 24.7zM144 328a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M149.1 70.6c9-.2 17.4-4.1 23.4-10.8 1.1-1.2 2.1-2.5 3-3.5 11.3 11.7 22.7 26.4 31.6 42.4 10.6 19.1 16.9 38.4 16.9 55 0 7.7-.9 15.1-2.6 22.3l32.7 0c1.3-7.2 1.9-14.7 1.9-22.3 0-24-8.8-48.7-20.9-70.5-12.2-21.9-28.2-41.9-44-56.5-4.5-4.2-10.2-6.2-15.9-6.2-3.8 0-7.1 .9-10.1 2.5-5.4 2.8-9.6 7.7-13.7 12.5-.9 1.1-1.8 2.1-2.7 3.1L133.4 22.7c-1.6-1.7-3.2-3.5-4.8-5.3-.7-.7-1.3-1.5-2-2.2-6.6-7.5-14-14.8-24.2-15.1-5.8-.1-11.7 1.9-16.3 6-18.7 16.9-40 39.1-56.7 64.1-16.6 24.9-29.4 53.7-29.4 83.6 0 7.6 .6 15 1.9 22.3l32.6 0c-1.7-7.1-2.5-14.6-2.5-22.3 0-20.9 9.2-43.5 24.1-65.8 13.1-19.6 29.8-37.8 45.6-52.7l8.5 9.5 15.2 15.9c6.2 6.5 14.8 10.1 23.7 9.9zM196.2 176c-15.4-31.7-47.2-58-61.3-68.5-4.1-3.1-9.7-3.1-13.8 0-14.1 10.5-46 36.8-61.3 68.5L97 176c2-2.8 4.2-5.7 6.7-8.6 7.9-9.5 16.8-17.9 24.4-24.4 7.6 6.5 16.4 14.9 24.4 24.4 2.4 2.9 4.7 5.8 6.7 8.6l37.2 0zM521.9 64c-20.8 0-40.8 8.1-55.7 22.6L221.1 324.3c-2.3 2.3-5.4 3.5-8.7 3.5-6.9 0-12.5-5.6-12.5-12.5l0-2.5c0-2.8 .8-5.6 2.3-7.9l30.6-49 7.1 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L16 224c-8.8 0-16 7.2-16 16 0 7.8 5.5 14.2 12.9 15.7L2.7 311.5C.9 321.5 0 331.7 0 341.9l0 7.6c0 89.8 72.8 162.6 162.6 162.6 48.8 0 94.9-21.9 125.8-59.6L522.8 165.9c3-3.7 7.6-5.9 12.4-5.9l77.5 0c15.1 0 27.3-12.2 27.3-27.3 0-7.2-2.9-14.2-8-19.3L606.1 87.4c-15-15-35.4-23.4-56.6-23.4l-27.6 0zM45.4 256l149.8 0-20 32c-4.7 7.5-7.1 16.1-7.1 24.9l0 2.5c0 24.6 19.9 44.5 44.5 44.5 11.6 0 22.7-4.5 31-12.5L488.5 109.5c9-8.7 20.9-13.5 33.4-13.5l27.6 0c12.7 0 24.9 5.1 33.9 14.1l17.9 17.9-66.2 0c-14.4 0-28 6.5-37.2 17.6L263.6 432.1C238.8 462.4 201.7 480 162.6 480 90.5 480 32 421.5 32 349.4l0-7.6c0-8.3 .7-16.6 2.2-24.7L45.4 256zM144 328a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"]],
    "window-frame-open": [448, 512, [], "e050", ["M64 64l0 192 144 0 0-224-112 0C78.3 32 64 46.3 64 64zM240 32l0 224 144 0 0-192c0-17.7-14.3-32-32-32L240 32z", "M240 32l112 0c17.7 0 32 14.3 32 32l0 192-144 0 0-224zM416 288l0-224c0-35.3-28.7-64-64-64L96 0C60.7 0 32 28.7 32 64l0 224 384 0zM208 256L64 256 64 64c0-17.7 14.3-32 32-32l112 0 0 224zM16 480c-8.8 0-16 7.2-16 16s7.2 16 16 16l416 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0 0-144-32 0 0 144-320 0 0-144-32 0 0 144-16 0z"]],
    "circle-d": [512, 512, [], "e104", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm144-80c0-8.8 7.2-16 16-16l64 0c53 0 96 43 96 96s-43 96-96 96l-64 0c-8.8 0-16-7.2-16-16l0-160zm32 16l0 128 48 0c35.3 0 64-28.7 64-64s-28.7-64-64-64l-48 0z", "M256 32a224 224 0 1 1 0 448 224 224 0 1 1 0-448zm0 480a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM192 160c-8.8 0-16 7.2-16 16l0 160c0 8.8 7.2 16 16 16l64 0c53 0 96-43 96-96s-43-96-96-96l-64 0zm64 160l-48 0 0-128 48 0c35.3 0 64 28.7 64 64s-28.7 64-64 64z"]],
    "expand": [448, 512, [], "f065", ["M0 176L0 336c0-8.8 7.2-16 16-16s16 7.2 16 16l0 112 112 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l160 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l112 0 0-112c0-8.8 7.2-16 16-16s16 7.2 16 16l0-160c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-112-112 0c-8.8 0-16-7.2-16-16s7.2-16 16-16L144 32c8.8 0 16 7.2 16 16s-7.2 16-16 16L32 64 32 176c0 8.8-7.2 16-16 16S0 184.8 0 176z", "M144 32c8.8 0 16 7.2 16 16s-7.2 16-16 16L32 64 32 176c0 8.8-7.2 16-16 16S0 184.8 0 176L0 48c0-8.8 7.2-16 16-16l128 0zM0 336c0-8.8 7.2-16 16-16s16 7.2 16 16l0 112 112 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L16 480c-8.8 0-16-7.2-16-16L0 336zM432 32c8.8 0 16 7.2 16 16l0 128c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-112-112 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l128 0zM416 336c0-8.8 7.2-16 16-16s16 7.2 16 16l0 128c0 8.8-7.2 16-16 16l-128 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l112 0 0-112z"]],
    "scooter": [512, 512, [], "e7c3", ["M32 400a48 48 0 1 0 96 0 48 48 0 1 0 -96 0zm352 0a48 48 0 1 0 96 0 48 48 0 1 0 -96 0z", "M256 48c0-8.8 7.2-16 16-16l80 0c7.4 0 13.9 5.1 15.6 12.3l64 272 .9 3.7c44 .2 79.6 36 79.6 80 0 44.2-35.8 80-80 80-38.7 0-71-27.5-78.4-64l-195.2 0c-7.4 36.5-39.7 64-78.4 64-44.2 0-80-35.8-80-80s35.8-80 80-80c38.7 0 71 27.5 78.4 64l195.2 0c5.3-26.2 23.4-47.7 47.4-57.8l-.6-2.6-61.1-259.7-67.3 0c-8.8 0-16-7.2-16-16zM128 400a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zm256 0a48 48 0 1 0 96 0 48 48 0 1 0 -96 0z"]],
    "file-mp4": [576, 512, [], "e649", ["M64 64c0-17.7 14.3-32 32-32l128 0 0 96c0 35.3 28.7 64 64 64l96 0 0 144-184 0c-30.9 0-56 25.1-56 56l0 88-48 0c-17.7 0-32-14.3-32-32L64 64z", "M224 32L96 32C78.3 32 64 46.3 64 64l0 384c0 17.7 14.3 32 32 32l48 0 0 32-48 0c-35.3 0-64-28.7-64-64L32 64C32 28.7 60.7 0 96 0L229.5 0c17 0 33.3 6.7 45.3 18.7L397.3 141.3c12 12 18.7 28.3 18.7 45.3l0 149.5-32 0 0-144-96 0c-35.3 0-64-28.7-64-64l0-96zM370.7 160L256 45.3 256 128c0 17.7 14.3 32 32 32l82.7 0zM368 384l32 0c30.9 0 56 25.1 56 56s-25.1 56-56 56l-16 0 0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-128c0-8.8 7.2-16 16-16zm32 80c13.3 0 24-10.7 24-24s-10.7-24-24-24l-16 0 0 48 16 0zM221.7 391.8l34.3 57.1 34.3-57.1c3.7-6.2 11.1-9.1 18-7.2S320 392.8 320 400l0 128c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-70.2-18.3 30.5c-2.9 4.8-8.1 7.8-13.7 7.8s-10.8-3-13.7-7.8L224 457.8 224 528c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-128c0-7.2 4.8-13.5 11.7-15.4s14.3 1 18 7.2zm263 83.5c-3-3-4.7-7.1-4.7-11.3l0-64c0-8.8 7.2-16 16-16s16 7.2 16 16l0 48 32 0 0-48c0-8.8 7.2-16 16-16s16 7.2 16 16l0 128c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-48-48 0c-4.2 0-8.3-1.7-11.3-4.7z"]],
    "note-sticky": [448, 512, [62026, "sticky-note"], "f249", ["M32 96l0 320c0 17.7 14.3 32 32 32l192 0 0-96c0-35.3 28.7-64 64-64l96 0 0-192c0-17.7-14.3-32-32-32L64 64C46.3 64 32 78.3 32 96z", "M256 448L64 448c-17.7 0-32-14.3-32-32L32 96c0-17.7 14.3-32 32-32l320 0c17.7 0 32 14.3 32 32l0 192-96 0c-35.3 0-64 28.7-64 64l0 96zM402.7 320L288 434.7 288 352c0-17.7 14.3-32 32-32l82.7 0zM0 416c0 35.3 28.7 64 64 64l197.5 0c17 0 33.3-6.7 45.3-18.7L429.3 338.7c12-12 18.7-28.3 18.7-45.3L448 96c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416z"]],
    "dolphin": [512, 512, [], "e168", ["M32 237.8c0 10 8.1 18.2 18.2 18.2l166.2 0c4.2 0 8.2 1.6 11.2 4.6l73.8 72.3c2.1 2 4.8 3.1 7.7 3.1 6.1 0 11-4.9 11-11l0-51.4c0-4.8 2.2-9.4 5.9-12.4s8.6-4.2 13.3-3.3c43.8 8.9 76.8 47.6 76.8 94.1 0 20.4-6.3 39.3-17.2 54.8 47.6-19 81.2-65.6 81.2-119.9 0-61.6-21.9-118.1-58.3-162.2-4.3-5.2-4.9-12.5-1.5-18.3 11-18.8 24-42.5 31.2-61.1 2.1-5.4 3.4-9.7 4.2-13-32 2-72.8 14.5-105.2 26.6-4.1 1.5-8.7 1.3-12.7-.7-34-16.8-72.2-26.2-112.7-26.2L176 32c-61.9 0-112 50.1-112 112 0 15.5 3.1 30.1 8.8 43.5 3.1 7.4 .3 16-6.7 20L41 222.1c-5.6 3.3-9 9.2-9 15.7zM176 152a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm27.6 235.3l18.8 37.5c2.3 4.5 2.3 9.8 0 14.3l-18.8 37.5c20.9-6.2 38.6-20.8 48.7-40.9l1.9-3.8-1.9-3.8c-10-20.1-27.8-34.7-48.7-40.9z", "M176 32l49.1 0c40.5 0 78.7 9.4 112.7 26.2 4 2 8.5 2.2 12.7 .7 32.4-12.1 73.2-24.6 105.2-26.6-.8 3.3-2.2 7.6-4.2 13-7.2 18.6-20.2 42.3-31.2 61.1-3.4 5.8-2.8 13.1 1.5 18.3 36.4 44.1 58.3 100.6 58.3 162.2 0 54.4-33.6 100.9-81.2 119.9 10.8-15.5 17.2-34.4 17.2-54.8 0-46.5-33-85.2-76.8-94.1-4.7-1-9.6 .3-13.3 3.3s-5.9 7.6-5.9 12.4l0 51.4c0 6.1-4.9 11-11 11-2.9 0-5.6-1.1-7.7-3.1l-73.8-72.3c-3-2.9-7-4.6-11.2-4.6L50.2 256c-10 0-18.2-8.1-18.2-18.2 0-6.5 3.4-12.4 9-15.7l25.1-14.6c6.9-4.1 9.8-12.6 6.7-20-5.6-13.4-8.8-28-8.8-43.5 0-61.9 50.1-112 112-112zm280.6-6.3s0 0 0 .1c0-.1 0-.1 0-.1zM320 416l-38.1 0-1-2.1C261.9 376 223.1 352 180.7 352l-4.7 0c-5.5 0-10.7 2.9-13.6 7.6s-3.2 10.6-.7 15.6l28.4 56.8-28.4 56.8c-2.5 5-2.2 10.9 .7 15.6s8.1 7.6 13.6 7.6l4.7 0c42.4 0 81.2-24 100.2-61.9l1-2.1 69 0c89 0 161.1-72.1 161.1-161.1 0-65.3-21.8-125.6-58.6-173.8 10-17.5 21-38.4 27.9-56.2 3.9-10.2 7.4-21.4 7.3-30.9 0-4.8-1-11.5-5.6-17.3-5.1-6.4-12.4-8.7-19-8.7-37 0-83.5 13.9-118.3 26.5-36.7-17-77.6-26.5-120.6-26.5L176 0c-79.5 0-144 64.5-144 144 0 14.8 2.2 29.1 6.4 42.6l-13.5 7.9C9.5 203.5 0 220 0 237.8 0 265.5 22.5 288 50.2 288l159.6 0 69.1 67.7c8 7.9 18.8 12.3 30.1 12.3 23.7 0 43-19.2 43-43l0-28.5c19.1 11.1 32 31.8 32 55.4 0 35.3-28.7 64-64 64zM203.6 387.3c20.9 6.2 38.6 20.8 48.7 40.9l1.9 3.8-1.9 3.8c-10 20.1-27.8 34.7-48.7 40.9l18.8-37.5c2.3-4.5 2.3-9.8 0-14.3l-18.8-37.5zM152 176a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]],
    "border-bottom": [448, 512, [], "f84d", ["M32 88l0 80c13.3 0 24 10.7 24 24s-10.7 24-24 24l0 80c13.3 0 24 10.7 24 24s-10.7 24-24 24l0 104 384 0 0-104c-13.3 0-24-10.7-24-24s10.7-24 24-24l0-80c-13.3 0-24-10.7-24-24s10.7-24 24-24l0-80c-13.3 0-24-10.7-24-24l-80 0c0 13.3-10.7 24-24 24s-24-10.7-24-24l-80 0c0 13.3-10.7 24-24 24s-24-10.7-24-24L56 64c0 13.3-10.7 24-24 24z", "M448 464c0 8.8-7.2 16-16 16L16 480c-8.8 0-16-7.2-16-16s7.2-16 16-16l416 0c8.8 0 16 7.2 16 16zM392 320a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM56 320a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zM392 192a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM56 192a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zM392 64a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM56 64A24 24 0 1 1 8 64 24 24 0 1 1 56 64zm208 0a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm-80 0a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z"]],
    "user-message": [576, 512, [], "e7b1", ["M17.4 511.9c8.2-.7 14.6-7.6 14.6-15.9l0-16c0-79.5 64.5-144 144-144l96 0c79.5 0 144 64.5 144 144l0 16c0 8.2 6.1 14.9 14 16-137.6 0-275.1 0-412.6-.1zM128 128c0-53 43-96 96-96 6.9 0 13.6 .7 20 2.1-2.6 9.5-4 19.5-4 29.9l0 96c0 21.4 6 41.4 16.4 58.4-10.1 3.6-21 5.6-32.4 5.6-53 0-96-43-96-96z", "M256.4 218.4c5.9 9.6 13.2 18.3 21.6 25.7-16.4 7.6-34.7 11.9-54 11.9-70.7 0-128-57.3-128-128S153.3 0 224 0c11.5 0 22.6 1.5 33.2 4.3-5.7 9.1-10.2 19.1-13.2 29.7-6.5-1.4-13.2-2.1-20-2.1-53 0-96 43-96 96s43 96 96 96c11.4 0 22.3-2 32.4-5.6zM176 336C96.5 336 32 400.5 32 480l0 16c0 8.8-7.2 16-16 16S0 504.8 0 496l0-16c0-97.2 78.8-176 176-176l96 0c97.2 0 176 78.8 176 176l0 16c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-16c0-79.5-64.5-144-144-144l-96 0zM320 64l0 96c0 17.7 14.3 32 32 32l16 0c8.8 0 16 7.2 16 16l0 41.4 52.7-52.7c3-3 7.1-4.7 11.3-4.7l64 0c17.7 0 32-14.3 32-32l0-96c0-17.7-14.3-32-32-32L352 32c-17.7 0-32 14.3-32 32zM352 0L512 0c35.3 0 64 28.7 64 64l0 96c0 35.3-28.7 64-64 64l-57.4 0-48 48c-20.2 20.2-54.6 5.9-54.6-22.6l0-25.4c-35.3 0-64-28.7-64-64l0-96c0-35.3 28.7-64 64-64z"]],
    "signal-weak": [448, 512, ["signal-1"], "f68c", ["", "M16 384c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16S0 472.8 0 464l0-64c0-8.8 7.2-16 16-16z"]],
    "table-columns": [448, 512, ["columns"], "f0db", ["M32 192l0 224c0 17.7 14.3 32 32 32l144 0 0-256-176 0zm208 0l0 256 144 0c17.7 0 32-14.3 32-32l0-224-176 0z", "M384 64c17.7 0 32 14.3 32 32l0 64-384 0 0-64c0-17.7 14.3-32 32-32l320 0zM0 160L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96l0 64zM416 416c0 17.7-14.3 32-32 32l-144 0 0-256 176 0 0 224zM208 448L64 448c-17.7 0-32-14.3-32-32l0-224 176 0 0 256z"]],
    "person-shelter": [512, 512, [], "e54f", ["M232 268.2l0 99.8 48 0 0-99.8c-7.6-2.8-15.7-4.2-24-4.2s-16.4 1.5-24 4.2zM240 168a16 16 0 1 0 32 0 16 16 0 1 0 -32 0z", "M264.2 2.3c-5.1-3-11.4-3-16.5 0l-240 144C2.9 149.2 0 154.4 0 160L0 496c0 8.8 7.2 16 16 16s16-7.2 16-16L32 169.1 256 34.7 480 169.1 480 496c0 8.8 7.2 16 16 16s16-7.2 16-16l0-336c0-5.6-2.9-10.8-7.8-13.7l-240-144zM240 168a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm64 0a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM200 292.1L200 496c0 8.8 7.2 16 16 16s16-7.2 16-16l0-96 48 0 0 96c0 8.8 7.2 16 16 16s16-7.2 16-16l0-203.9c1.2 1.7 2.4 3.4 3.5 5.2l38.8 63.1c4.6 7.5 14.5 9.9 22 5.2s9.9-14.5 5.2-22l-38.8-63.1C324.2 250.4 291.4 232 256 232s-68.2 18.4-86.8 48.5l-38.8 63.1c-4.6 7.5-2.3 17.4 5.2 22s17.4 2.3 22-5.2l38.8-63.1c1.1-1.8 2.3-3.5 3.5-5.2zM232 368l0-99.8c7.6-2.8 15.7-4.2 24-4.2s16.4 1.5 24 4.2l0 99.8-48 0z"]],
    "camera-security": [448, 512, ["camera-home"], "f8fe", ["M32 64l0 288c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-288c0-17.7-14.3-32-32-32L64 32C46.3 32 32 46.3 32 64zM336 208a112 112 0 1 1 -224 0 112 112 0 1 1 224 0z", "M64 32C46.3 32 32 46.3 32 64l0 288c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-288c0-17.7-14.3-32-32-32L64 32zM0 64C0 28.7 28.7 0 64 0L384 0c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64l-144 0 0 64 80 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-192 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l80 0 0-64-144 0c-35.3 0-64-28.7-64-64L0 64zM304 208a80 80 0 1 0 -160 0 80 80 0 1 0 160 0zm-192 0a112 112 0 1 1 224 0 112 112 0 1 1 -224 0z"]],
    "circle-notch": [512, 512, [], "f1ce", ["", "M223.7 17.6C225.4 26.3 219.8 34.7 211.2 36.5 108.9 57.2 32 147.6 32 256 32 379.7 132.3 480 256 480S480 379.7 480 256c0-108.4-76.9-198.8-179.2-219.5-8.7-1.8-14.3-10.2-12.5-18.9S298.5 3.4 307.2 5.1C424 28.8 512 132.1 512 256 512 397.4 397.4 512 256 512S0 397.4 0 256C0 132.1 88 28.8 204.8 5.1 213.5 3.4 221.9 9 223.7 17.6z"]],
    "water": [512, 512, [], "f773", ["M0 134.3c0 .8 .1 1.7 .3 2.5 1.6 8.7 9.9 14.5 18.6 12.9 24.9-4.5 48-17.5 68-31.8 26-18.6 61.1-18.6 87.1 0 25.6 18.3 52.9 34.1 82 34.1s56.4-15.8 82-34.1c26-18.6 61.1-18.6 87.1 0 20 14.3 43.1 27.3 68 31.8 8.7 1.6 17-4.2 18.6-12.9 .2-.9 .2-1.7 .3-2.6l0 143.4c-.1-7.5-5.5-14-13.1-15.4-18.1-3.3-36.7-13.2-55.1-26.4-37.1-26.5-87.1-26.5-124.3 0-25.3 18.1-45.3 28.1-63.5 28.1s-38.1-10.1-63.5-28.1c-37.1-26.5-87.1-26.5-124.3 0-18.5 13.2-37 23.1-55.1 26.4-7.6 1.4-13 7.9-13.1 15.4L0 134.3zm0 144c0 .8 .1 1.7 .3 2.5 1.6 8.7 9.9 14.5 18.6 12.9 24.9-4.5 48-17.5 68-31.8 26-18.6 61.1-18.6 87.1 0 25.6 18.3 52.9 34.1 82 34.1s56.4-15.8 82-34.1c26-18.6 61.1-18.6 87.1 0 20 14.3 43.1 27.3 68 31.8 8.7 1.6 17-4.2 18.6-12.9 .2-.9 .2-1.7 .3-2.6 0 47.9 0 95.8 0 143.8-.1-7.9-5.5-14.5-13.1-15.8-18.1-3.3-36.7-13.2-55.1-26.4-37.1-26.5-87.1-26.5-124.3 0-25.3 18.1-45.3 28.1-63.5 28.1s-38.1-10.1-63.5-28.1c-37.1-26.5-87.1-26.5-124.3 0-18.5 13.2-37 23.1-55.1 26.4-7.6 1.4-13 7.9-13.1 15.4L0 278.3z", "M425.1 117.9c20 14.3 43.1 27.3 68 31.8 8.7 1.6 17-4.2 18.6-12.9s-4.2-17-12.9-18.6c-18.1-3.3-36.7-13.2-55.1-26.4-37.1-26.5-87.1-26.5-124.3 0-25.3 18.1-45.3 28.1-63.5 28.1s-38.1-10.1-63.5-28.1c-37.1-26.5-87.1-26.5-124.3 0-18.5 13.2-37 23.1-55.1 26.4-8.7 1.6-14.5 9.9-12.9 18.6s9.9 14.5 18.6 12.9c24.9-4.5 48-17.5 68-31.8-9.2-12.8-9.2-12.8 0 0 26-18.6 61.1-18.6 87.1 0 25.6 18.3 52.9 34.1 82 34.1s56.4-15.8 82-34.1c26-18.6 61.1-18.6 87.1 0zm0 144c20 14.3 43.1 27.3 68 31.8 8.7 1.6 17-4.2 18.6-12.9s-4.2-17-12.9-18.6c-18.1-3.3-36.7-13.2-55.1-26.4-37.1-26.5-87.1-26.5-124.3 0-25.3 18.1-45.3 28.1-63.5 28.1s-38.1-10.1-63.5-28.1c-37.1-26.5-87.1-26.5-124.3 0-18.5 13.2-37 23.1-55.1 26.4-8.7 1.6-14.5 9.9-12.9 18.6s9.9 14.5 18.6 12.9c24.9-4.5 48-17.5 68-31.8 26-18.6 61.1-18.6 87.1 0 25.6 18.3 52.9 34.1 82 34.1s56.4-15.8 82-34.1c26-18.6 61.1-18.6 87.1 0zM338 405.9c26-18.6 61.1-18.6 87.1 0 20 14.3 43.1 27.3 68 31.8 8.7 1.6 17-4.2 18.6-12.9s-4.2-17-12.9-18.6c-18.1-3.3-36.7-13.2-55.1-26.4-37.1-26.5-87.1-26.5-124.3 0-25.3 18.1-45.3 28.1-63.5 28.1s-38.1-10.1-63.5-28.1c-37.1-26.5-87.1-26.5-124.3 0-18.5 13.2-37 23.1-55.1 26.4-8.7 1.6-14.5 9.9-12.9 18.6s9.9 14.5 18.6 12.9c24.9-4.5 48-17.5 68-31.8 26-18.6 61.1-18.6 87.1 0 25.6 18.3 52.9 34.1 82 34.1s56.4-15.8 82-34.1z"]],
    "delete-left": [640, 512, [9003, "backspace"], "f55a", ["M32 256L182.6 406.6c6 6 14.1 9.4 22.6 9.4L512 416c17.7 0 32-14.3 32-32l0-256c0-17.7-14.3-32-32-32L205.3 96c-8.5 0-16.6 3.4-22.6 9.4L32 256zm252.7-67.3c6.2-6.2 16.4-6.2 22.6 0l44.7 44.7 44.7-44.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6l-44.7 44.7 44.7 44.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-44.7-44.7-44.7 44.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l44.7-44.7-44.7-44.7c-6.2-6.2-6.2-16.4 0-22.6z", "M544 128c0-17.7-14.3-32-32-32L205.3 96c-8.5 0-16.6 3.4-22.6 9.4L32 256 182.6 406.6c6 6 14.1 9.4 22.6 9.4L512 416c17.7 0 32-14.3 32-32l0-256zM512 64c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64l-306.7 0c-17 0-33.3-6.7-45.3-18.7L9.4 278.6c-6-6-9.4-14.1-9.4-22.6s3.4-16.6 9.4-22.6L160 82.7c12-12 28.3-18.7 45.3-18.7L512 64zM419.3 188.7c6.2 6.2 6.2 16.4 0 22.6l-44.7 44.7 44.7 44.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-44.7-44.7-44.7 44.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l44.7-44.7-44.7-44.7c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l44.7 44.7 44.7-44.7c6.2-6.2 16.4-6.2 22.6 0z"]],
    "circle-rupee": [512, 512, [], "e714", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm96-96c0-8.8 7.2-16 16-16l56 0c39.8 0 72 32.2 72 72 0 29.4-17.6 54.7-42.8 65.8l25.7 64.2c3.3 8.2-.7 17.5-8.9 20.8s-17.5-.7-20.8-8.9l-28-69.9-37.2 0 0 64c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-192zm32 16l0 80 40 0c22.1 0 40-17.9 40-40s-17.9-40-40-40l-40 0zm128 67.2c0-28.3 22.9-51.2 51.2-51.2l36.8 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-36.8 0c-10.6 0-19.2 8.6-19.2 19.2 0 9.1 6.4 17 15.4 18.8l23.5 4.7c23.9 4.8 41.1 25.8 41.1 50.2 0 28.3-22.9 51.2-51.2 51.2L312 368c-8.8 0-16-7.2-16-16s7.2-16 16-16l36.8 0c10.6 0 19.2-8.6 19.2-19.2 0-9.1-6.4-17-15.4-18.8l-23.5-4.7c-23.9-4.8-41.1-25.8-41.1-50.2z", "M256 32a224 224 0 1 1 0 448 224 224 0 1 1 0-448zm0 480a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM144 144c-8.8 0-16 7.2-16 16l0 192c0 8.8 7.2 16 16 16s16-7.2 16-16l0-64 37.2 0 28 69.9c3.3 8.2 12.6 12.2 20.8 8.9s12.2-12.6 8.9-20.8l-25.7-64.2c25.2-11.2 42.8-36.5 42.8-65.8 0-39.8-32.2-72-72-72l-56 0zm56 112l-40 0 0-80 40 0c22.1 0 40 17.9 40 40s-17.9 40-40 40zm88-12.8c0 24.4 17.2 45.4 41.1 50.2l23.5 4.7c9 1.8 15.4 9.7 15.4 18.8 0 10.6-8.6 19.2-19.2 19.2L312 336c-8.8 0-16 7.2-16 16s7.2 16 16 16l36.8 0c28.3 0 51.2-22.9 51.2-51.2 0-24.4-17.2-45.4-41.1-50.2L335.4 262c-9-1.8-15.4-9.7-15.4-18.8 0-10.6 8.6-19.2 19.2-19.2l36.8 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-36.8 0c-28.3 0-51.2 22.9-51.2 51.2z"]],
    "arrow-down-to-square": [448, 512, [], "e096", ["M32 160l0 288c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-288c0-17.7-14.3-32-32-32l-144 0 0 169.4 52.7-52.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6l-80 80c-6.2 6.2-16.4 6.2-22.6 0l-80-80c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l52.7 52.7 0-169.4-144 0c-17.7 0-32 14.3-32 32z", "M240-16c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 313.4-52.7-52.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l80 80c6.2 6.2 16.4 6.2 22.6 0l80-80c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0L240 297.4 240-16zM32 160c0-17.7 14.3-32 32-32l48 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L64 96C28.7 96 0 124.7 0 160L0 448c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-288c0-35.3-28.7-64-64-64l-48 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l48 0c17.7 0 32 14.3 32 32l0 288c0 17.7-14.3 32-32 32L64 480c-17.7 0-32-14.3-32-32l0-288z"]],
    "square-b": [448, 512, [], "e264", ["M32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64C46.3 64 32 78.3 32 96zm128 80c0-8.8 7.2-16 16-16l56 0c30.9 0 56 25.1 56 56 0 12.1-3.8 23.3-10.4 32.5 15.8 9.9 26.4 27.5 26.4 47.5 0 30.9-25.1 56-56 56l-72 0c-8.8 0-16-7.2-16-16l0-160zm32 16l0 48 40 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-40 0zm0 80l0 48 56 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-56 0z", "M64 64C46.3 64 32 78.3 32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm160 80c0-8.8 7.2-16 16-16l56 0c30.9 0 56 25.1 56 56 0 12.1-3.8 23.3-10.4 32.5 15.8 9.9 26.4 27.5 26.4 47.5 0 30.9-25.1 56-56 56l-72 0c-8.8 0-16-7.2-16-16l0-160zm96 40c0-13.3-10.7-24-24-24l-40 0 0 48 40 0c13.3 0 24-10.7 24-24zM192 320l56 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-56 0 0 48z"]],
    "broom-ball": [576, 512, ["quidditch", "quidditch-broom-ball"], "f458", ["M45.3 480l149.2 0 5.8-.2c26.9-1.3 52.5-11.9 72.4-30l4.2-4c24.3-24.3 36.6-58 33.7-92.1l-.8-6.8-3.6-24.8-52.5-52.5-24.8-3.5c-36.3-5.2-72.9 7-98.8 32.9l-10.5 10.5c-11.6 11.6-19.3 26.5-22.2 42.5 12.4 .5 23.4 8.1 28.2 19.7 5 12 2.2 25.7-6.9 34.9L45.3 480zM274.6 242.6l58.7 58.7 43.5-7.2-94.9-94.9-7.3 43.5zM448 464a48 48 0 1 0 96 0 48 48 0 1 0 -96 0z", "M496 544a80 80 0 1 1 0-160 80 80 0 1 1 0 160zm0-128a48 48 0 1 0 0 96 48 48 0 1 0 0-96zM551.2 2.6c6.2-4.1 14.7-3.4 20.1 2.1s6.2 13.9 2.1 20.1l-2.1 2.5-208 208 45.3 45.2c4.8 4.8 7.4 11.2 7.4 17.9l-.4 4.6c-1.9 10.4-10.1 18.7-20.8 20.5l-54.7 9.1 1.4 9.9c6.6 46.3-9 92.9-42 126l-5.3 5.1c-27.2 24.7-62.8 38.4-99.7 38.4l-171.8 0-4.6-.5c-8.8-1.8-15.8-8.8-17.6-17.6L0 489.3c0-4.5 1.4-8.8 3.8-12.5l2.8-3.4 89.4-89.4-14.7 0c-8.4 0-15.4-6-17-13.8l-.3-3.5c0-28 10.4-55 29.1-75.7l3.9-4 10.5-10.5c31-31 73.9-46.6 117.3-43l8.7 1 9.8 1.4 9.1-54.7c2-12.2 12.6-21.2 25-21.2 6.7 0 13.2 2.7 17.9 7.4l45.3 45.2 208-208 2.5-2.1zM229 266.2c-36.3-5.2-72.9 7-98.8 32.9l-10.5 10.5c-11.6 11.6-19.3 26.5-22.2 42.5 12.4 .5 23.4 8.1 28.2 19.7 5 12 2.2 25.7-6.9 34.9l-73.4 73.4 149.2 0 5.8-.2c26.9-1.3 52.5-11.9 72.4-30l4.2-4c24.3-24.3 36.6-58 33.7-92.1l-.8-6.8-3.6-24.8-52.5-52.5-24.8-3.5zm45.7-23.6l58.7 58.7 43.5-7.2-94.9-94.9-7.3 43.5z"]],
    "h6": [512, 512, [], "e413", ["", "M16 64c8.8 0 16 7.2 16 16l0 160 160 0 0-160c0-8.8 7.2-16 16-16s16 7.2 16 16l0 352c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-160-160 0 0 160c0 8.8-7.2 16-16 16S0 440.8 0 432L0 80c0-8.8 7.2-16 16-16zM384 96c-35.3 0-64 28.7-64 64l0 72.4c17-15.2 39.4-24.4 64-24.4l32 0c53 0 96 43 96 96l0 48c0 53-43 96-96 96l-32 0c-53 0-96-43-96-96l0-192c0-53 43-96 96-96l80 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-80 0zM320 304l0 48c0 35.3 28.7 64 64 64l32 0c35.3 0 64-28.7 64-64l0-48c0-35.3-28.7-64-64-64l-32 0c-35.3 0-64 28.7-64 64z"]],
    "j": [320, 512, [106], "4a", ["", "M304 32c8.8 0 16 7.2 16 16l0 272c0 88.4-71.6 160-160 160S0 408.4 0 320l0-48c0-8.8 7.2-16 16-16s16 7.2 16 16l0 48c0 70.7 57.3 128 128 128s128-57.3 128-128l0-272c0-8.8 7.2-16 16-16z"]],
    "shuttle-space": [576, 512, ["space-shuttle"], "f197", ["M32 80l0 48 64 0 0-64-48 0c-8.8 0-16 7.2-16 16zm0 80l0 80 112 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-112 0 0 80 80 0c15.3 0 28.9-7.1 37.7-18.3 5.8-7.3 15.2-13.7 27-13.7L400 320c54.9 0 104.4-22.9 139.5-64-35.1-41.1-84.6-64-139.5-64l-223.3 0c-11.8 0-21.2-6.4-27-13.7-8.8-11.2-22.4-18.3-37.7-18.3l-80 0zm0 224l0 48c0 8.8 7.2 16 16 16l48 0 0-64-64 0zM128 66.4l0 63.2c18.9 3.8 35.3 14.3 46.8 28.9 .6 .7 1.2 1.2 1.6 1.4 .2 .1 .3 .1 .3 .1l134.4 0-114.4-68.6c-21.2-12.7-44.5-21.2-68.7-25zm0 316l0 63.2c24.2-3.8 47.6-12.3 68.7-25l114.4-68.6-134.4 0c0 0-.2 0-.3 .1-.4 .2-1 .7-1.6 1.4-11.5 14.5-27.9 25-46.8 28.9zM416 240c0-8.8 7.2-16 16-16s16 7.2 16 16l0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-32z", "M213.2 448.1L373.3 352 400 352c64.7 0 123.5-27.4 164.8-76.3 9.6-11.4 9.6-28 0-39.4-41.3-48.9-100.1-76.3-164.8-76.3l-26.7 0-160.1-96.1C178.4 43 138.6 32 98 32L48 32C21.5 32 0 53.5 0 80L0 432c0 26.5 21.5 48 48 48l50 0c40.6 0 80.4-11 115.2-31.9zM32 240l0-80 80 0c15.3 0 28.9 7.1 37.7 18.3 5.8 7.3 15.2 13.7 27 13.7L400 192c54.9 0 104.4 22.9 139.5 64-35.1 41.1-84.6 64-139.5 64l-223.3 0c-11.8 0-21.2 6.4-27 13.7-8.8 11.2-22.4 18.3-37.7 18.3l-80 0 0-80 112 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L32 240zM174.8 353.5c.6-.7 1.2-1.2 1.6-1.4 .2-.1 .3-.1 .3-.1l134.4 0-114.4 68.6c-21.2 12.7-44.5 21.2-68.7 25l0-63.2c18.9-3.8 35.3-14.3 46.8-28.9zM32 384l64 0 0 64-48 0c-8.8 0-16-7.2-16-16l0-48zM174.8 158.5c-11.5-14.5-27.9-25-46.8-28.9l0-63.2c24.2 3.8 47.6 12.3 68.7 25l114.4 68.6-134.4 0c0 0-.2 0-.3-.1-.4-.2-1-.7-1.6-1.4zM96 128l-64 0 0-48c0-8.8 7.2-16 16-16l48 0 0 64zm336 96c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16s16-7.2 16-16l0-32c0-8.8-7.2-16-16-16z"]],
    "yin-yang": [512, 512, [9775], "f6ad", ["M32 256c0 81.5 43.5 152.9 108.6 192-13.1-20.9-20.6-45.6-20.6-72 0-75.1 60.9-136 136-136 57.4 0 104-46.6 104-104S313.4 32 256 32C132.3 32 32 132.3 32 256zM280 136a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M480 256c0 123.7-100.3 224-224 224-57.4 0-104-46.6-104-104s46.6-104 104-104c75.1 0 136-60.9 136-136 0-26.5-7.6-51.2-20.6-72 65.1 39.2 108.6 110.5 108.6 192zM256 32c57.4 0 104 46.6 104 104S313.4 240 256 240c-75.1 0-136 60.9-136 136 0 26.5 7.6 51.2 20.6 72-65.1-39.2-108.6-110.5-108.6-192 0-123.7 100.3-224 224-224zm0 480a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm24-136a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM256 160a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]],
    "signal-good": [448, 512, ["signal-3"], "f68e", ["", "M240 240c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 224c0 8.8 7.2 16 16 16s16-7.2 16-16l0-224zM120 320c-8.8 0-16 7.2-16 16l0 128c0 8.8 7.2 16 16 16s16-7.2 16-16l0-128c0-8.8-7.2-16-16-16zM16 384c-8.8 0-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16s16-7.2 16-16l0-64c0-8.8-7.2-16-16-16z"]],
    "image-stack": [512, 512, [], "e771", ["M32 224l0 192c0 17.7 14.3 32 32 32l384 0c17.7 0 32-14.3 32-32l0-192c0-17.7-14.3-32-32-32L64 192c-17.7 0-32 14.3-32 32zm88 32a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm23.2 137.4c-6.7-13.8-4.9-30.2 4.6-42.2l44.3-56c7.1-8.9 17.6-14.4 29-15.1s22.5 3.5 30.6 11.6l.3 .3 32.7-39.6c7.6-9.2 18.9-14.5 30.9-14.5s23.3 5.3 30.9 14.5l81 98.2c9.9 11.9 11.9 28.5 5.3 42.5S412.1 416 396.6 416l-217.4 0c-15.3 0-29.3-8.8-36-22.6z", "M112-32l288 0c8.8 0 16 7.2 16 16S408.8 0 400 0L112 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zM64 64l384 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L64 96c-8.8 0-16-7.2-16-16s7.2-16 16-16zm0 128c-17.7 0-32 14.3-32 32l0 192c0 17.7 14.3 32 32 32l384 0c17.7 0 32-14.3 32-32l0-192c0-17.7-14.3-32-32-32L64 192zM0 224c0-35.3 28.7-64 64-64l384 0c35.3 0 64 28.7 64 64l0 192c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 224zm96 8a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm219.6 37.8c-2.4 0-4.6 1.1-6.2 2.9l-43.9 53.2c-2.9 3.5-7.1 5.6-11.6 5.8s-8.9-1.5-12.1-4.6l-12.8-12.7c-1.6-1.6-3.8-2.5-6.1-2.3s-4.4 1.2-5.8 3l-44.3 56c-1.9 2.4-2.3 5.7-.9 8.5s4.1 4.5 7.2 4.5l217.4 0c3.1 0 5.9-1.8 7.2-4.6s.9-6.1-1.1-8.5l-81-98.2c-1.5-1.8-3.8-2.9-6.2-2.9zm-30.9-17.5c7.6-9.2 18.9-14.5 30.9-14.5s23.3 5.3 30.9 14.5l81 98.2c9.9 11.9 11.9 28.5 5.3 42.5S412.1 416 396.6 416l-217.4 0c-15.3 0-29.3-8.8-36-22.6s-4.9-30.2 4.6-42.2l44.3-56c7.1-8.9 17.6-14.4 29-15.1s22.5 3.5 30.6 11.6l.3 .3 32.7-39.6z"]],
    "stop": [448, 512, [9209], "f04d", ["M32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64C46.3 64 32 78.3 32 96z", "M384 64c17.7 0 32 14.3 32 32l0 320c0 17.7-14.3 32-32 32L64 448c-17.7 0-32-14.3-32-32L32 96c0-17.7 14.3-32 32-32l320 0zM64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32z"]],
    "trowel": [576, 512, [], "e589", ["M73.3 470.7L151 237.6 306.4 393 73.3 470.7zM385.6 106.2L481 10.8c14.4-14.4 37.8-14.4 52.2 0s14.4 37.8 0 52.2l-95.4 95.4c-2.1 2.1-5.5 2.1-7.5 0l-44.7-44.7c-2.1-2.1-2.1-5.5 0-7.5z", "M555.8-11.8c26.9 26.9 26.9 70.5 0 97.5l-95.4 95.4c-14.6 14.6-38.2 14.6-52.8 0l-11-11-134 134 84.7 84.7c3.9 3.9 5.5 9.6 4.3 15s-5.3 9.7-10.5 11.5l-288 96c-5.7 1.9-12.1 .4-16.4-3.9s-5.8-10.6-3.9-16.4l96-288c1.8-5.3 6.1-9.2 11.5-10.5s11.1 .3 15 4.3l84.7 84.7 134-134-11-11c-14.6-14.6-14.6-38.2 0-52.8l95.4-95.4c26.9-26.9 70.5-26.9 97.5 0zM385.6 106.2c-2.1 2.1-2.1 5.5 0 7.5l44.7 44.7c2.1 2.1 5.5 2.1 7.5 0L533.2 63c14.4-14.4 14.4-37.8 0-52.2s-37.8-14.4-52.2 0l-95.4 95.4zM73.3 470.7L306.4 393 151 237.6 73.3 470.7z"]],
    "circle-2": [512, 512, [], "e0ef", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm160-78.7c0-8.8 7.2-16 16-16l57.8 0c29.9 0 54.2 24.3 54.2 54.2 0 21.2-12.3 40.4-31.6 49.2L252 281.4c-15.5 7.1-26 21.8-27.7 38.6l79.7 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16l0-10.9c0-31.3 18.2-59.7 46.7-72.7l36.4-16.7c7.9-3.6 12.9-11.5 12.9-20.2 0-12.2-9.9-22.2-22.2-22.2l-57.8 0c-8.8 0-16-7.2-16-16z", "M256 32a224 224 0 1 1 0 448 224 224 0 1 1 0-448zm0 480a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM208 161.3c-8.8 0-16 7.2-16 16s7.2 16 16 16l57.8 0c12.2 0 22.2 9.9 22.2 22.2 0 8.7-5.1 16.5-12.9 20.2l-36.4 16.7c-28.4 13-46.7 41.4-46.7 72.7l0 10.9c0 8.8 7.2 16 16 16l96 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-79.7 0c1.8-16.7 12.2-31.5 27.7-38.6l36.4-16.7c19.3-8.8 31.6-28.1 31.6-49.2 0-29.9-24.3-54.2-54.2-54.2l-57.8 0z"]],
    "drumstick": [512, 512, [127831], "f6d6", ["M192 176l0 96c0 26.5 21.5 48 48 48l96 0c79.5 0 144-64.5 144-144S415.5 32 336 32 192 96.5 192 176z", "M192 272l0-96c0-79.5 64.5-144 144-144s144 64.5 144 144-64.5 144-144 144l-96 0c-26.5 0-48-21.5-48-48zm-32-96l0 96c0 3 .2 6 .5 8.9l-41 41c-12.7-11.1-29.3-17.9-47.5-17.9-39.8 0-72 32.2-72 72 0 37.2 28.2 67.8 64.4 71.6 3.8 36.2 34.4 64.4 71.6 64.4 39.8 0 72-32.2 72-72 0-18.2-6.8-34.8-17.9-47.5l41-41c2.9 .3 5.9 .5 8.9 .5l96 0c97.2 0 176-78.8 176-176S433.2 0 336 0 160 78.8 160 176zm12.2 138.4c6.4 10.3 15.1 18.9 25.4 25.4L162.4 375c-11.2 11.2-7.8 27.6 1.1 36 7.7 7.3 12.5 17.6 12.5 29.1 0 22.1-17.9 40-40 40s-40-17.9-40-40c0-13.1-10.9-24-24-24-22.1 0-40-17.9-40-40s17.9-40 40-40c11.5 0 21.8 4.8 29.1 12.5 8.4 8.9 24.8 12.3 36 1.1l35.1-35.1z"]],
    "square-x": [448, 512, [], "e286", ["M32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64C46.3 64 32 78.3 32 96zm115.5 90c-5.5-6.9-4.4-17 2.5-22.5s17-4.4 22.5 2.5L224 230.4 275.5 166c5.5-6.9 15.6-8 22.5-2.5s8 15.6 2.5 22.5l-56 70 56 70c5.5 6.9 4.4 17-2.5 22.5s-17 4.4-22.5-2.5L224 281.6 172.5 346c-5.5 6.9-15.6 8-22.5 2.5s-8-15.6-2.5-22.5l56-70-56-70z", "M64 64C46.3 64 32 78.3 32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm172.5 70L224 230.4 275.5 166c5.5-6.9 15.6-8 22.5-2.5s8 15.6 2.5 22.5l-56 70 56 70c5.5 6.9 4.4 17-2.5 22.5s-17 4.4-22.5-2.5L224 281.6 172.5 346c-5.5 6.9-15.6 8-22.5 2.5s-8-15.6-2.5-22.5l56-70-56-70c-5.5-6.9-4.4-17 2.5-22.5s17-4.4 22.5 2.5z"]],
    "peapod": [512, 512, [], "e31c", ["M32 416l0 48c0 8.8 7.2 16 16 16l48 0c212.1 0 384-171.9 384-384l0-48c0-8.8-7.2-16-16-16l-48 0C203.9 32 32 203.9 32 416zm176-48a64 64 0 1 1 -128 0 64 64 0 1 1 128 0zM320 256a64 64 0 1 1 -128 0 64 64 0 1 1 128 0zM432 144a64 64 0 1 1 -128 0 64 64 0 1 1 128 0z", "M416 32C203.9 32 32 203.9 32 416l0 48c0 8.8 7.2 16 16 16l48 0c212.1 0 384-171.9 384-384l0-48c0-8.8-7.2-16-16-16l-48 0zm0-32l48 0c26.5 0 48 21.5 48 48l0 48c0 229.8-186.2 416-416 416l-48 0c-26.5 0-48-21.5-48-48l0-48C0 186.2 186.2 0 416 0zM368 112a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm64 32a64 64 0 1 1 -128 0 64 64 0 1 1 128 0zM224 256a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm32 64a64 64 0 1 1 0-128 64 64 0 1 1 0 128zM112 368a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm32 64a64 64 0 1 1 0-128 64 64 0 1 1 0 128z"]],
    "message-text": [512, 512, ["comment-alt-text"], "e1e6", ["M32 128l0 224c0 35.3 28.7 64 64 64l40 0c13.3 0 24 10.7 24 24l0 68 112-84c6.9-5.2 15.3-8 24-8l120 0c35.3 0 64-28.7 64-64l0-224c0-35.3-28.7-64-64-64L96 64c-35.3 0-64 28.7-64 64zm136 48c0-8.8 7.2-16 16-16l144 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-56 0 0 128c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-128-56 0c-8.8 0-16-7.2-16-16z", "M179.2 533.6l0 0 112-84c1.4-1 3.1-1.6 4.8-1.6l120 0c53 0 96-43 96-96l0-224c0-53-43-96-96-96L96 32C43 32 0 75 0 128L0 352c0 53 43 96 96 96l32 0 0 68c0 15.5 12.5 28 28 28 6.1 0 12-2 16.8-5.6l6.4-4.8zM160 448l0-8c0-13.3-10.7-24-24-24l-40 0c-35.3 0-64-28.7-64-64l0-224c0-35.3 28.7-64 64-64l320 0c35.3 0 64 28.7 64 64l0 224c0 35.3-28.7 64-64 64l-120 0c-8.7 0-17.1 2.8-24 8l-112 84 0-60zm24-288c-8.8 0-16 7.2-16 16s7.2 16 16 16l56 0 0 128c0 8.8 7.2 16 16 16s16-7.2 16-16l0-128 56 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-144 0z"]],
    "hand-back-fist": [384, 512, ["hand-rock"], "f255", ["M32 197.5c0-16.7 10.3-31.6 26-37.5 3.9-1.5 7.8-2.9 11.7-4.4 3.7-1.4 6.6-4 8.4-7.3 1.3-2.3 2-4.9 2-7.7L80 64c0-17.7 14.3-32 32-32 9.6 0 18.1 4.2 24 10.8 3 3.4 7.4 5.4 12 5.4s9-2 12-5.4c5.9-6.7 14.4-10.8 24-10.8 13.7 0 25.4 8.6 30 20.8 1.9 5.2 6.4 9 11.8 10.1s11-.7 14.8-4.7c5.9-6.3 14.1-10.1 23.4-10.1 14.2 0 26.3 9.2 30.4 22.1 2.5 7.8 10.6 12.4 18.6 10.7 2.2-.5 4.5-.7 6.9-.7 17.7 0 32 14.3 32 32l0 89c0 17.4-4.7 34.5-13.7 49.4L286.9 336 122 336c-.7-.7-1.4-1.3-2.2-1.8L49.1 284.6C38.4 277.1 32 264.9 32 251.8l0-54.3zM64 416l256 0 0 64-256 0 0-64z", "M64 384c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32l256 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32L64 384zm260.3-48l41.5-69.2C377.7 246.9 384 224.2 384 201l0-89c0-35.3-28.7-64-64-64l-.6 0c-11.1-19.1-31.7-32-55.4-32-11 0-21.3 2.8-30.3 7.6-11.7-14.4-29.6-23.6-49.7-23.6-13.3 0-25.7 4.1-36 11.1-10.3-7-22.7-11.1-36-11.1-35.3 0-64 28.7-64 64l0 65.6-1.3 .5C18.6 140.7 0 167.5 0 197.5l0 54.3c0 23.5 11.5 45.5 30.7 59l36 25.2 55.4 0c-.7-.7-1.4-1.3-2.2-1.8L49.1 284.6C38.4 277.1 32 264.9 32 251.8l0-54.3c0-16.7 10.3-31.6 26-37.5-5.6-15-5.6-15 0 0l11.7-4.4c3.7-1.4 6.6-4 8.4-7.3 1.3-2.3 2-4.9 2-7.7L80 64c0-17.7 14.3-32 32-32 9.6 0 18.1 4.2 24 10.8 3 3.4 7.4 5.4 12 5.4s9-2 12-5.4c5.9-6.7 14.4-10.8 24-10.8 13.7 0 25.4 8.6 30 20.8 1.9 5.2 6.4 9 11.8 10.1s11-.7 14.8-4.7c5.9-6.3 14.1-10.1 23.4-10.1 14.2 0 26.3 9.2 30.4 22.1 2.5 7.8 10.6 12.4 18.6 10.7 2.2-.5 4.5-.7 6.9-.7 17.7 0 32 14.3 32 32l0 89c0 17.4-4.7 34.5-13.7 49.4l-51.4 85.6 37.3 0zM64 416l256 0 0 64-256 0 0-64z"]],
    "snowman-head": [448, 512, ["frosty-head"], "f79b", ["M96 64c0-17.7 14.3-32 32-32l192 0c17.7 0 32 14.3 32 32l0 96-256 0 0-96zM208 368c0-8.8 7.2-16 16-16s16 7.2 16 16l0 1c0 2.4-.5 4.7-1.5 6.9l-14.5 32.7-14.5-32.7c-1-2.2-1.5-4.5-1.5-6.9l0-1z", "M128 32l192 0c17.7 0 32 14.3 32 32l0 96 32 0 0-96c0-35.3-28.7-64-64-64L128 0C92.7 0 64 28.7 64 64l0 96 32 0 0-96c0-17.7 14.3-32 32-32zM352 224l.7 0c29.3 31.4 47.3 73.6 47.3 120 0 52-22.5 98.8-58.5 131-3 2.7-8.3 5-15.8 5l-203.5 0c-7.5 0-12.7-2.2-15.8-5-35.9-32.3-58.5-79-58.5-131 0-46.4 17.9-88.6 47.3-120L352 224zM16 192c-8.8 0-16 7.2-16 16s7.2 16 16 16l38.1 0c-24 33.9-38.1 75.3-38.1 120 0 61.5 26.7 116.8 69.1 154.8 10.1 9.1 23.6 13.2 37.1 13.2l203.5 0c13.6 0 27-4.1 37.1-13.2 42.4-38.1 69.1-93.3 69.1-154.8 0-44.7-14.1-86.1-38.1-120l38.1 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L16 192zM144 328a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm184-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM224 320c-26.5 0-48 21.5-48 48l0 1c0 6.9 1.4 13.6 4.2 19.9l29.2 65.6c2.6 5.8 8.3 9.5 14.6 9.5s12.1-3.7 14.6-9.5l29.2-65.6c2.8-6.3 4.2-13 4.2-19.9l0-1c0-26.5-21.5-48-48-48zm-16 48c0-8.8 7.2-16 16-16s16 7.2 16 16l0 1c0 2.4-.5 4.7-1.5 6.9l-14.5 32.7-14.5-32.7c-1-2.2-1.5-4.5-1.5-6.9l0-1z"]],
    "blanket": [448, 512, [], "f498", ["M32 128c0-35.3 28.7-64 64-64l256 0c35.3 0 64 28.7 64 64l0 165.4c-7.3-3.5-15.4-5.4-24-5.4L96 288c-24.6 0-47 9.2-64 24.4L32 128z", "M32 128l0 184.4C49 297.2 71.4 288 96 288l296 0c8.6 0 16.7 1.9 24 5.4L416 128c0-35.3-28.7-64-64-64L96 64c-35.3 0-64 28.7-64 64zM0 384L0 128C0 75 43 32 96 32l256 0c53 0 96 43 96 96l0 216c0 30.9-25.1 56-56 56L96 400c-8.8 0-16-7.2-16-16s7.2-16 16-16l296 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L96 320c-35.3 0-64 28.7-64 64s28.7 64 64 64l336 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L96 480c-53 0-96-43-96-96z"]],
    "comment-xmark": [512, 512, ["comment-times"], "f4b5", ["M32 240c0 46.7 16.5 89.8 44.8 124.8 8.1 10.1 9.4 24.1 3.2 35.4l-40.2 73.6 101-43.3c7.9-3.4 16.8-3.5 24.8-.2 27.6 11.3 58.2 17.6 90.4 17.6 125.7 0 224-95 224-208S381.7 32 256 32 32 127 32 240zm156.7-67.3c6.2-6.2 16.4-6.2 22.6 0l44.7 44.7 44.7-44.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6l-44.7 44.7 44.7 44.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-44.7-44.7-44.7 44.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l44.7-44.7-44.7-44.7c-6.2-6.2-6.2-16.4 0-22.6z", "M80 400.2c6.2-11.4 4.9-25.4-3.2-35.4-28.2-34.9-44.8-78.1-44.8-124.8 0-113 98.3-208 224-208s224 95 224 208-98.3 208-224 208c-32.3 0-62.8-6.3-90.4-17.6-7.9-3.3-16.9-3.2-24.8 .2L39.8 473.8 80 400.2zM0 240c0 54.4 19.3 104.6 51.9 144.9L3.1 474.3c-2 3.7-3.1 7.9-3.1 12.2 0 14.1 11.4 25.5 25.5 25.5 4 0 7.8-.6 11.5-2.1L153.4 460c31.4 12.9 66.1 20 102.6 20 141.4 0 256-107.5 256-240S397.4 0 256 0 0 107.5 0 240zm188.7-67.3c-6.2 6.2-6.2 16.4 0 22.6l44.7 44.7-44.7 44.7c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l44.7-44.7 44.7 44.7c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-44.7-44.7 44.7-44.7c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-44.7 44.7-44.7-44.7c-6.2-6.2-16.4-6.2-22.6 0z"]],
    "person-dolly-empty": [512, 512, [], "f4d1", ["M32 176l0 96c0 15.1 7.1 29.3 19.2 38.4L96 344 96 176c0-17.7-14.3-32-32-32s-32 14.3-32 32zM40 24a24 24 0 1 0 48 0 24 24 0 1 0 -48 0z", "M88 24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM8 24A56 56 0 1 1 120 24 56 56 0 1 1 8 24zM0 176.5c0-35.6 28.9-64.5 64.5-64.5 25.5 0 48.6 15 58.9 38.3l34.3 77.2c7.7 17.3 24.9 28.5 43.9 28.5l54.4 0 0-80c0-8.8 7.2-16 16-16s16 7.2 16 16l0 274.7c13.6 4.8 24.4 15.6 29.3 29.3L496 480c8.8 0 16 7.2 16 16s-7.2 16-16 16l-178.7 0c-6.6 18.6-24.4 32-45.3 32-26.5 0-48-21.5-48-48 0-20.9 13.4-38.7 32-45.3l0-162.7-54.4 0c-31.6 0-60.3-18.6-73.1-47.5l-.5-1.1 0 128.6c20.1 15.1 32 38.8 32 64l0 96c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-96c0-15.1-7.1-29.3-19.2-38.4L32 336C11.9 320.9 0 297.2 0 272l0-95.5zM0 371.9c1.1 .8 2.1 1.7 3.2 2.5L32 396 32 528c0 8.8-7.2 16-16 16S0 536.8 0 528L0 371.9zM64 144c-17.7 0-32 14.3-32 32l0 96c0 15.1 7.1 29.3 19.2 38.4L96 344 96 176c0-17.7-14.3-32-32-32zM272 512a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"]],
    "signal-slash": [576, 512, [], "f695", ["", "M27.3-27.2c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l544 544c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L512 457.5 512 48c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 377.5-72-72 0-209.5c0-8.8-7.2-16-16-16s-16 7.2-16 16L376 321.5 27.3-27.2zM272 464c0 8.8 7.2 16 16 16s16-7.2 16-16l0-101.5-32-32 0 133.5zM184 320c-8.8 0-16 7.2-16 16l0 128c0 8.8 7.2 16 16 16s16-7.2 16-16l0-128c0-8.8-7.2-16-16-16zM80 384c-8.8 0-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16s16-7.2 16-16l0-64c0-8.8-7.2-16-16-16z"]],
    "hexagon-plus": [576, 512, ["plus-hexagon"], "f300", ["M61.3 236.2c-7 12.3-7 27.4 0 39.7L157.5 444c7.1 12.4 20.4 20.1 34.7 20.1l191.6 0c4.8 0 9.5-.9 13.9-2.5 7.7-3.3 14.4-8.6 19.5-15.5 .5-.7 .9-1.4 1.4-2.2l96.2-168.1c7-12.3 7-27.4 0-39.7L418.5 68.1C411.4 55.7 398.2 48 383.8 48L192.2 48c-3.7 0-7.3 .5-10.8 1.5-3.5 1.1-6.8 2.5-9.9 4.3-5.7 3.4-10.6 8.3-14 14.3L61.3 236.2zM176 256c0-8.8 7.2-16 16-16l80 0 0-80c0-8.8 7.2-16 16-16s16 7.2 16 16l0 80 80 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-80 0 0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80-80 0c-8.8 0-16-7.2-16-16z", "M61.3 275.9L157.5 444c7.1 12.4 20.4 20.1 34.7 20.1l191.6 0c14.3 0 27.6-7.7 34.7-20.1l96.2-168.1c7-12.3 7-27.4 0-39.7L418.5 68.1C411.4 55.7 398.2 48 383.8 48L192.2 48c-14.3 0-27.6 7.7-34.7 20.1L61.3 236.2c-7 12.3-7 27.4 0 39.7zM33.5 291.8c-12.7-22.2-12.7-49.4 0-71.5L129.7 52.2C142.5 29.8 166.4 16 192.2 16l191.6 0c25.8 0 49.7 13.8 62.5 36.2l96.2 168.1c12.7 22.2 12.7 49.4 0 71.5L446.3 459.9c-12.8 22.4-36.7 36.2-62.5 36.2l-191.6 0c-25.8 0-49.7-13.8-62.5-36.2L33.5 291.8zM272 352l0-80-80 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l80 0 0-80c0-8.8 7.2-16 16-16s16 7.2 16 16l0 80 80 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-80 0 0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16z"]],
    "temperature-high": [448, 512, [], "f769", ["M48 368c0 61.9 50.1 112 112 112s112-50.1 112-112c0-28.4-10.6-54.3-28-74.1-2.6-2.9-4-6.7-4-10.6L240 112c0-44.2-35.8-80-80-80S80 67.8 80 112l0 171.3c0 3.9-1.4 7.7-4 10.6-17.4 19.8-28 45.7-28 74.1zm48 0c0-29.8 20.4-54.9 48-62l0-194c0-8.8 7.2-16 16-16s16 7.2 16 16l0 194c27.6 7.1 48 32.2 48 62 0 35.3-28.7 64-64 64s-64-28.7-64-64z", "M80 112c0-44.2 35.8-80 80-80s80 35.8 80 80l0 171.3c0 3.9 1.4 7.7 4 10.6 17.4 19.8 28 45.7 28 74.1 0 61.9-50.1 112-112 112S48 429.9 48 368c0-28.4 10.6-54.3 28-74.1 2.6-2.9 4-6.7 4-10.6L80 112zM160 0C98.1 0 48 50.1 48 112l0 165.5c-20 24.7-32 56.2-32 90.5 0 79.5 64.5 144 144 144s144-64.5 144-144c0-34.3-12-65.8-32-90.5L272 112C272 50.1 221.9 0 160 0zM128 368a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm96 0c0-29.8-20.4-54.9-48-62l0-194c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 194c-27.6 7.1-48 32.2-48 62 0 35.3 28.7 64 64 64s64-28.7 64-64zM352 64a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm96 0a64 64 0 1 0 -128 0 64 64 0 1 0 128 0z"]],
    "greater-than": [512, 512, [62769], "3e", ["", "M33.5 41.3c-3.7 8-.2 17.5 7.8 21.2L458 256 41.3 449.5c-8 3.7-11.5 13.2-7.8 21.3s13.2 11.5 21.2 7.8l448-208c5.6-2.6 9.3-8.3 9.3-14.5s-3.6-11.9-9.3-14.5l-448-208c-8-3.7-17.5-.2-21.2 7.8z"]],
    "toothbrush": [576, 512, [129701], "f635", ["M32 160c0 17.7 14.3 32 32 32l288 0c35.3 0 64-28.7 64-64 0-18.6-7.7-32.3-20.5-42.7-9.9-8.1-23.1-14.2-37.9-17.8-1.8 10.3-5.3 21.5-11.9 31.6-12.6 19.1-32.9 28.9-57.7 28.9L64 128c-17.7 0-32 14.3-32 32z", "M64 192c-17.7 0-32-14.3-32-32s14.3-32 32-32l224 0c24.8 0 45.1-9.9 57.7-28.9 6.6-10.1 10.1-21.2 11.9-31.6 14.8 3.6 27.9 9.7 37.9 17.8 12.8 10.4 20.5 24.1 20.5 42.7 0 35.3-28.7 64-64 64L64 192zM0 160c0 35.3 28.7 64 64 64l288 0c53 0 96-43 96-96 0-58.5-51.6-89.9-104-95.2-8.8-.9-15.8 6.4-16.4 15.2-1.5 25.3-8.4 48-39.6 48L64 96C28.7 96 0 124.7 0 160zM64 272c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 176-16 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l544 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-176 0 0-176c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 176-32 0 0-176c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 176-32 0 0-176c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 176-32 0 0-176c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 176-32 0 0-176c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 176-32 0 0-176z"]],
    "flute": [576, 512, [], "f8b9", ["M52.7 428.7c-6.2 6.2-6.2 16.4 0 22.6l40 40c6.2 6.2 16.4 6.2 22.6 0L220 386.6 157.4 324 52.7 428.7zM144 416a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm36-114.6L242.6 364 523.3 83.3c6.2-6.2 6.2-16.4 0-22.6l-40-40c-6.2-6.2-16.4-6.2-22.6 0L180 301.4zM312 248a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm64-64a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm64-64a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M460.7 20.7L180 301.4 242.6 364 523.3 83.3c6.2-6.2 6.2-16.4 0-22.6l-40-40c-6.2-6.2-16.4-6.2-22.6 0zM157.4 324L52.7 428.7c-6.2 6.2-6.2 16.4 0 22.6l40 40c6.2 6.2 16.4 6.2 22.6 0L220 386.6 157.4 324zM438.1-1.9c18.7-18.7 49.1-18.7 67.9 0l40 40c18.7 18.7 18.7 49.1 0 67.9l-408 408c-18.7 18.7-49.1 18.7-67.9 0l-40-40c-18.7-18.7-18.7-49.1 0-67.9l408-408zM280 248a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM128 400a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM344 184a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm80-80a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"]],
    "lobster": [512, 512, [129438], "e421", ["M32 80l0 48c0 17.7 14.3 32 32 32s32-14.3 32-32l0-48c0-8.8 7.2-16 16-16l-25.3 0-7 35.1c-1.7 8.7-10.2 14.3-18.8 12.6S46.6 101.5 48.3 92.9L59.6 36.6C43.3 44.2 32 60.8 32 80zM188.3 480l135.4 0c-3.8-6.5-9.8-11.6-17-14.2-15-5.4-23.6-20.8-20.7-36.1-10 1.2-20.7 2.2-30.1 2.2s-20.1-1-30.1-2.2c2.9 15.2-5.7 30.7-20.7 36.1-7.2 2.6-13.2 7.6-17 14.2zM208 200l0 99.6c1 .2 2.1 .4 3.3 .6 9.9 1.8 24.9 3.7 44.7 3.7s34.9-1.9 44.7-3.7c1.2-.2 2.2-.4 3.3-.6l0-99.6c0-12.1-6.5-26.2-19.3-40.9-9-10.4-19.7-19.2-28.7-25.7-9.1 6.4-19.7 15.3-28.7 25.7-12.8 14.7-19.3 28.7-19.3 40.9zm0 132.2l0 15.4c1 .2 2.1 .4 3.3 .6 9.9 1.8 24.9 3.7 44.7 3.7s34.9-1.9 44.7-3.7c1.2-.2 2.2-.4 3.3-.6l0-15.4c-11.6 2-27.7 3.8-48 3.8s-36.4-1.8-48-3.8zm.7 48.1l5.5 15.5c12.9 2.1 29.3 4.2 41.8 4.2s28.9-2.1 41.8-4.2l5.5-15.5C291.8 382.3 276 384 256 384s-35.8-1.7-47.3-3.7zM400 64c8.8 0 16 7.2 16 16l0 48c0 17.7 14.3 32 32 32s32-14.3 32-32l0-48c0-19.2-11.3-35.8-27.6-43.4l11.3 56.3c1.7 8.7-3.9 17.1-12.6 18.8s-17.1-3.9-18.8-12.6l-7-35.1-25.3 0z", "M32 80c0-19.2 11.3-35.8 27.6-43.4L48.3 92.9c-1.7 8.7 3.9 17.1 12.6 18.8S78 107.8 79.7 99.1l16-80c.9-4.7-.3-9.6-3.3-13.3S84.8 0 80 0C35.8 0 0 35.8 0 80l0 48c0 35.3 28.7 64 64 64 6.2 0 12.2-.9 17.9-2.5l26.9 20.1c19.4 14.5 43 22.4 67.2 22.4l0 24-32.9 0c-7.5 0-14.8-1.7-21.5-5.1L87.2 233.7c-7.9-4-17.5-.7-21.5 7.2s-.7 17.5 7.2 21.5l34.5 17.2c11.1 5.6 23.4 8.4 35.8 8.4l32.9 0 0 16-53.6 0c-5.2 0-10.3-.8-15.2-2.5L69.1 288.8c-8.4-2.8-17.4 1.7-20.2 10.1s1.7 17.4 10.1 20.2l38.1 12.7c8.2 2.7 16.7 4.1 25.3 4.1l53.6 0 0 16-.9 0c-12.4 0-24.7 2.9-35.8 8.4l-18.5 9.2c-7.9 4-11.1 13.6-7.2 21.5s13.6 11.1 21.5 7.2l18.5-9.2c6.7-3.3 14-5.1 21.5-5.1l.9 0 18.5 51.7c-24.8 8.8-42.5 32.5-42.5 60.3 0 8.8 7.2 16 16 16l176 0c8.8 0 16-7.2 16-16 0-27.8-17.7-51.4-42.5-60.3l18.5-51.7 .9 0c7.4 0 14.8 1.7 21.5 5.1l18.5 9.2c7.9 4 17.5 .7 21.5-7.2s.7-17.5-7.2-21.5l-18.5-9.2c-11.1-5.6-23.4-8.4-35.8-8.4l-.9 0 0-16 53.6 0c8.6 0 17.1-1.4 25.3-4.1l38.1-12.7c8.4-2.8 12.9-11.9 10.1-20.2s-11.9-12.9-20.2-10.1l-38.1 12.7c-4.9 1.6-10 2.5-15.2 2.5l-53.6 0 0-16 32.9 0c12.4 0 24.7-2.9 35.8-8.4l34.5-17.2c7.9-4 11.1-13.6 7.2-21.5s-13.6-11.1-21.5-7.2l-34.5 17.2c-6.7 3.3-14 5.1-21.5 5.1l-32.9 0 0-24c24.2 0 47.8-7.9 67.2-22.4l26.9-20.1c5.7 1.7 11.7 2.5 17.9 2.5 35.3 0 64-28.7 64-64l0-48c0-44.2-35.8-80-80-80-4.8 0-9.3 2.1-12.4 5.9s-4.3 8.6-3.3 13.3l16 80c1.7 8.7 10.2 14.3 18.8 12.6s14.3-10.2 12.6-18.8L452.4 36.6C468.7 44.2 480 60.8 480 80l0 48c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-48c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 48c0 16.7 6.4 31.9 16.9 43.3L384 184c-13.8 10.4-30.7 16-48 16 0-25.6-14.7-48.9-32-67.2l0-52.1c0-15.6 11.3-29 26.7-31.6l7.9-1.3c8.7-1.5 14.6-9.7 13.2-18.4s-9.7-14.6-18.4-13.2l-7.9 1.3C294.6 22.7 272 49.4 272 80.7l0 25c-3.2-2.2-6.3-4.1-9-5.8-4.3-2.6-9.7-2.6-14 0-2.8 1.6-5.8 3.6-9 5.8l0-25c0-31.3-22.6-58-53.5-63.1l-7.9-1.3c-8.7-1.5-17 4.4-18.4 13.2s4.4 17 13.2 18.4l7.9 1.3C196.7 51.7 208 65 208 80.7l0 52.1c-17.3 18.3-32 41.6-32 67.2-17.3 0-34.2-5.6-48-16l-16.9-12.7C121.6 159.9 128 144.7 128 128l0-48c0-8.8-7.2-16-16-16S96 71.2 96 80l0 48c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-48zM304 200l0 99.6c-1 .2-2.1 .4-3.3 .6-9.9 1.8-24.9 3.7-44.7 3.7s-34.9-1.9-44.7-3.7c-1.2-.2-2.2-.4-3.3-.6l0-99.6c0-12.1 6.5-26.2 19.3-40.9 9-10.4 19.7-19.2 28.7-25.7 9.1 6.4 19.7 15.3 28.7 25.7 12.8 14.7 19.3 28.7 19.3 40.9l0 0zM208 332.2c11.6 2 27.7 3.8 48 3.8s36.4-1.8 48-3.8l0 15.4c-1 .2-2.1 .4-3.3 .6-9.9 1.8-24.9 3.7-44.7 3.7s-34.9-1.9-44.7-3.7c-1.2-.2-2.2-.4-3.3-.6l0-15.4zM256 384c20 0 35.8-1.7 47.3-3.7l-5.5 15.5c-12.9 2.1-29.3 4.2-41.8 4.2s-28.9-2.1-41.8-4.2l-5.5-15.5c11.5 1.9 27.4 3.7 47.3 3.7zm-30.1 45.8c10 1.2 20.7 2.2 30.1 2.2s20.1-1 30.1-2.2c-2.9 15.2 5.6 30.7 20.7 36.1 7.2 2.6 13.2 7.6 17 14.2l-135.4 0c3.8-6.5 9.7-11.6 17-14.2 15-5.4 23.6-20.8 20.7-36.1z"]],
    "calendar-circle-exclamation": [576, 512, [], "e46e", ["M64 192l416 0 0 22c-15.3-3.9-31.4-6-48-6-106 0-192 86-192 192 0 16.6 2.1 32.7 6 48L96 448c-17.7 0-32-14.3-32-32l0-224z", "M160 16c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 48-32 0c-35.3 0-64 28.7-64 64l0 288c0 35.3 28.7 64 64 64l161.4 0c-4.7-10.2-8.5-20.9-11.4-32L96 448c-17.7 0-32-14.3-32-32l0-224 416 0 0-64c0-35.3-28.7-64-64-64l-32 0 0-48c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 48-192 0 0-48zM96 96l320 0c17.7 0 32 14.3 32 32l0 32-384 0 0-32c0-17.7 14.3-32 32-32zM320 400a112 112 0 1 1 224 0 112 112 0 1 1 -224 0zm256 0a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zM432 484a20 20 0 1 0 0-40 20 20 0 1 0 0 40zm0-164c-8.8 0-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16s16-7.2 16-16l0-64c0-8.8-7.2-16-16-16z"]],
    "mobile-rotate": [576, 512, [], "e813", ["M73.9 169.4c-12.5 12.5-12.5 32.8 0 45.2l255.3 255.3 3.6 3.3c12.5 9.9 30.8 9 42.4-2.5l128-128 2.1-2.3c9.6-11.6 9.7-28.4 .5-40.1l-3.3-3.6-255.2-255.3c-11.6-11.6-30.1-12.4-42.6-2.4l-3.1 2.8-127.6 127.6zM357.2 372.7l48-48 2.5-2.1c6.2-4.1 14.7-3.4 20.1 2.1s6.2 13.9 2.1 20.1l-2.1 2.5-48 48c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6z", "M53.2 340.7c5.5-5.5 13.9-6.2 20.1-2.1l2.5 2.1 48 48 2.1 2.5c4.1 6.2 3.4 14.7-2.1 20.1s-13.9 6.2-20.1 2.1l-2.5-2.1-20.7-20.7 0 25.4c0 44.2 35.8 80 80 80 22.6 0 42.9-9.4 57.5-24.5l22.7 22.7c-20.3 20.9-48.7 33.8-80.2 33.8-61.9 0-112-50.1-112-112l0-25.4-20.7 20.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l48-48zM184.1 14.3c25.1-20.5 62.2-19 85.7 4.4l256 256 4.4 4.8c20.5 25.1 19 62.2-4.4 85.7l-128 128-4.6 4.1c-21.9 18.1-53 19.4-76.2 3.9l-4.8-3.6-4.8-4.4-256-256c-23.4-23.4-24.9-60.5-4.4-85.7l4.4-4.8 128-128 4.8-4.4zm63 27c-11.6-11.6-30.1-12.4-42.6-2.4l-3.1 2.8-127.6 127.6c-12.5 12.5-12.5 32.8 0 45.2l255.3 255.3 3.6 3.3c12.5 9.9 30.8 9 42.4-2.5l128-128 2.1-2.3c9.6-11.6 9.7-28.4 .5-40.1l-3.3-3.6-255.2-255.3zM407.7 322.6c6.2-4.1 14.7-3.4 20.1 2.1s6.2 13.9 2.1 20.1l-2.1 2.5-48 48c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l48-48 2.5-2.1zM416.5-16c61.9 0 112 50.1 112 112l0 25.4 20.7-20.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6l-48 48c-5.5 5.5-13.9 6.2-20.1 2.1l-2.5-2.1-48-48-2.1-2.5c-4.1-6.2-3.4-14.7 2.1-20.1s13.9-6.2 20.1-2.1l2.5 2.1 20.7 20.7 0-25.4c0-44.2-35.8-80-80-80-22.6 0-42.9 9.4-57.5 24.5L336.3 17.8C356.7-3 385.1-16 416.5-16z"]],
    "crutch": [512, 512, [], "f7f7", ["", "M300.7 12.7c6.2-6.2 16.4-6.2 22.6 0l176 176c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L456 190.6 286.1 360.6c-15 15-35.4 23.4-56.6 23.4l-59 0c-12.7 0-24.9 5.1-33.9 14.1-59.1 59.1-95.5 95.5-109.3 109.3-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l32-32 0 0 77.3-77.3c9-9 14.1-21.2 14.1-33.9l0-59c0-21.2 8.4-41.6 23.4-56.6L321.4 56 300.7 35.3c-6.2-6.2-6.2-16.4 0-22.6zM344 78.6L238.6 184 328 273.4 433.4 168 344 78.6zm-128 128l-41.9 41.9c-9 9-14.1 21.2-14.1 33.9l0 59c0 3.8-.3 7.6-.8 11.3 3.7-.5 7.5-.8 11.3-.8l59 0c12.7 0 24.9-5.1 33.9-14.1L305.4 296 216 206.6z"]],
    "command": [512, 512, [], "e142", ["", "M96 192l64 0 0 128-64 0c-53 0-96 43-96 96s43 96 96 96 96-43 96-96l0-64 128 0 0 64c0 53 43 96 96 96s96-43 96-96-43-96-96-96l-64 0 0-128 64 0c53 0 96-43 96-96s-43-96-96-96-96 43-96 96l0 64-128 0 0-64c0-53-43-96-96-96S0 43 0 96 43 192 96 192zM256 320l-64 0 0-128 128 0 0 128-64 0zM96 160c-35.3 0-64-28.7-64-64s28.7-64 64-64 64 28.7 64 64l0 64-64 0zm64 256c0 35.3-28.7 64-64 64s-64-28.7-64-64 28.7-64 64-64l64 0 0 64zM352 160l0-64c0-35.3 28.7-64 64-64s64 28.7 64 64-28.7 64-64 64l-64 0zm64 192c35.3 0 64 28.7 64 64s-28.7 64-64 64-64-28.7-64-64l0-64 64 0z"]],
    "tv-retro": [512, 512, [128250], "f401", ["M32 160l0 256c0 17.7 14.3 32 32 32l384 0c17.7 0 32-14.3 32-32l0-256c0-17.7-14.3-32-32-32L64 128c-17.7 0-32 14.3-32 32zm32 48c0-26.5 21.5-48 48-48l192 0c26.5 0 48 21.5 48 48l0 160c0 26.5-21.5 48-48 48l-192 0c-26.5 0-48-21.5-48-48l0-160zm376 24a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm0 80a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M171.3 4.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6L217.4 96 64 96C28.7 96 0 124.7 0 160L0 416c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64l-153.4 0 68.7-68.7c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0L256 89.4 171.3 4.7zM480 160l0 256c0 17.7-14.3 32-32 32L64 448c-17.7 0-32-14.3-32-32l0-256c0-17.7 14.3-32 32-32l384 0c17.7 0 32 14.3 32 32zm-40 72a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM416 336a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM304 192c8.8 0 16 7.2 16 16l0 160c0 8.8-7.2 16-16 16l-192 0c-8.8 0-16-7.2-16-16l0-160c0-8.8 7.2-16 16-16l192 0zM112 160c-26.5 0-48 21.5-48 48l0 160c0 26.5 21.5 48 48 48l192 0c26.5 0 48-21.5 48-48l0-160c0-26.5-21.5-48-48-48l-192 0z"]],
    "paw-claws": [512, 512, [], "f702", ["M32.2 216.5l-.2 3 .3 4.7c.7 4.8 2.5 10.1 5.7 15.3l2 3c4.8 6.8 11 11.5 16.9 13.9 6.8 2.8 12.2 2.2 15.8 .3 3.4-1.9 6.3-5.8 7.1-12.2 .8-6.5-.7-15-5.8-23.4s-12.1-14.1-18.9-16.9c-5.1-2.1-9.4-2.3-12.8-1.4l-3 1.2c-3.4 1.9-6.5 5.9-7.2 12.6zM96 431.7l0 4.4c0 6.6 5.3 11.9 11.9 11.9 10.1 0 20.1-1.5 29.7-4.5l80.2-25.1 9.4-2.6c22.1-5.1 45.2-4.2 67 2.6l80.2 25.1 7.3 2c7.4 1.7 14.9 2.6 22.4 2.6 6.6 0 11.9-5.3 11.9-11.9l0-4.4c0-5.4-.6-10.4-1.8-14.9l-1.4-4.4C364.2 281.4 281.7 256 256 256 231.1 256 152.8 279.9 103.8 400.3l-4.6 12C97.1 418 96 424.5 96 431.7zm48-322.1l.2 4.8c.4 4.8 1.4 9.9 3.1 15l1.8 4.7c4.5 10.8 11.4 19.1 18.7 24.1 8.4 5.8 16.4 6.9 22.7 4.8 6.3-2.1 11.9-7.6 15.1-17.1 3.2-9.5 3.5-22.1-.9-35.3-4.4-13.1-12.1-23.1-20.5-28.9-7.3-5.1-14.4-6.6-20.2-5.5l-2.4 .6c-7.9 2.6-15.4 11.5-17.2 26l-.4 6.6zm162.4 28.3c3.2 9.5 8.9 15 15.1 17.1 6.3 2.1 14.3 1 22.7-4.8s16.1-15.8 20.5-28.9c4.4-13.1 4.1-25.7 .9-35.3-3.2-9.5-8.9-15-15.1-17.1-6.3-2.1-14.3-1-22.7 4.8s-16.1 15.8-20.5 28.9c-4.4 13.1-4.1 25.7-.9 35.3zM432.2 244.5c.8 6.4 3.7 10.3 7.1 12.2 3.6 2 9 2.5 15.8-.3 6.8-2.8 13.8-8.5 18.9-16.9 5.1-8.4 6.6-16.9 5.8-23.4-.8-6.4-3.7-10.3-7.1-12.2-3.6-2-9-2.5-15.8 .2-6.8 2.8-13.8 8.5-18.9 16.9s-6.6 16.9-5.8 23.4z", "M256 224c41.3 0 134.4 35.9 186.8 177.2 3.6 9.7 5.2 20.1 5.2 30.5l0 4.4-.2 4.5c-2.3 22.1-21 39.4-43.7 39.4l-10-.4c-6.6-.5-13.2-1.5-19.7-3l-9.6-2.6-80.2-25.1c-18.6-5.8-38.6-5.8-57.2 0l-80.2 25.1-9.6 2.6c-9.7 2.2-19.7 3.4-29.7 3.4l-4.5-.2c-20.7-2.1-37.1-18.5-39.2-39.2l-.2-4.5 0-4.4c0-7.8 .9-15.6 2.9-23.1l2.3-7.4C121.6 259.9 214.7 224 256 224zm0 32c-24.9 0-103.2 23.9-152.2 144.3l-4.6 12C97.1 418 96 424.5 96 431.7l0 4.4c0 6.6 5.3 11.9 11.9 11.9 10.1 0 20.1-1.5 29.7-4.5l80.2-25.1 9.4-2.6c22.1-5.1 45.2-4.2 67 2.6l80.2 25.1 7.3 2c7.4 1.7 14.9 2.6 22.4 2.6 6.6 0 11.9-5.3 11.9-11.9l0-4.4c0-5.4-.6-10.4-1.8-14.9l-1.4-4.4C364.2 281.4 281.7 256 256 256zM16 128c8.8 0 16 7.2 16 16l0 28.5c11.8-3.7 24.3-2.4 35.2 2.1 13.5 5.5 25.8 16.1 34.2 30s12 29.5 10.2 43.9c-1.8 14.5-9.3 28.4-23.4 36.2-13.9 7.7-29.8 6.9-43.3 1.3-11.8-4.8-22.7-13.5-30.8-24.9L10.6 256C4.5 245.9 .9 234.9 .2 224.2L0 219.5 0 144c0-8.8 7.2-16 16-16zm480 0c8.8 0 16 7.2 16 16l0 72c0 .3-.1 .6-.1 .9 .6 13-3.1 26.8-10.5 39.2-8.4 13.9-20.6 24.4-34.2 30-13.5 5.5-29.4 6.3-43.3-1.3-14.1-7.8-21.6-21.7-23.4-36.2-1.8-14.4 1.8-30 10.2-43.9s20.6-24.4 34.2-30c11-4.5 23.4-5.8 35.2-2.1l0-28.5c0-8.8 7.2-16 16-16zM42.3 202.8l-3 1.2c-3.4 1.9-6.5 5.9-7.2 12.6l-.2 3 .3 4.7c.7 4.8 2.5 10.1 5.7 15.3l2 3c4.8 6.8 11 11.5 16.9 13.9 6.8 2.8 12.2 2.2 15.8 .3 3.4-1.9 6.3-5.8 7.1-12.2 .8-6.5-.7-15-5.8-23.4s-12.1-14.1-18.9-16.9c-5.1-2.1-9.4-2.3-12.8-1.4zm430.3 1.2c-3.6-2-9-2.5-15.8 .2-6.8 2.8-13.8 8.5-18.9 16.9s-6.6 16.9-5.8 23.4c.8 6.4 3.7 10.3 7.1 12.2 3.6 2 9 2.5 15.8-.3 6.8-2.8 13.8-8.5 18.9-16.9 5.1-8.4 6.6-16.9 5.8-23.4-.8-6.4-3.7-10.3-7.1-12.2zM128 0c8.8 0 16 7.2 16 16l0 33.8c2.4-1.2 4.9-2.3 7.6-3.2l6.8-1.7c15.7-2.9 31.3 1.8 44.1 10.7 14.5 10.1 26.3 26 32.7 45.1s6.5 38.8 .9 55.6c-5.6 16.8-17.6 31.4-35.5 37.3-17.9 5.9-36.3 1.1-50.8-8.9-12.7-8.8-23.3-22.1-30-38.1l-2.6-7c-2.5-7.5-4-15.1-4.6-22.5l-.3-7.4 0-93.6c0-8.8 7.2-16 16-16zM384-8c8.8 0 16 7.2 16 16l0 93.6c0 .1 0 .2 0 .3 0 9.7-1.6 19.7-4.9 29.6-6.4 19.1-18.1 35-32.7 45.1s-32.9 14.8-50.8 8.9c-18-5.9-29.9-20.5-35.5-37.3-5.6-16.7-5.5-36.5 .9-55.6s18.1-35 32.7-45.1 32.9-14.8 50.8-8.9c2.7 .9 5.2 2 7.6 3.2L368 8c0-8.8 7.2-16 16-16zM184.2 81.8c-7.3-5.1-14.4-6.6-20.2-5.5l-2.4 .6c-7.9 2.6-15.4 11.5-17.2 26l-.4 6.6 .2 4.8c.4 4.8 1.4 9.9 3.1 15l1.8 4.7c4.5 10.8 11.4 19.1 18.7 24.1 8.4 5.8 16.4 6.9 22.7 4.8 6.3-2.1 11.9-7.6 15.1-17.1 3.2-9.5 3.5-22.1-.9-35.3-4.4-13.1-12.1-23.1-20.5-28.9zM350.5 69c-6.3-2.1-14.3-1-22.7 4.8s-16.1 15.8-20.5 28.9c-4.4 13.1-4.1 25.7-.9 35.3 3.2 9.5 8.9 15 15.1 17.1 6.3 2.1 14.3 1 22.7-4.8s16.1-15.8 20.5-28.9c4.4-13.1 4.1-25.7 .9-35.3-3.2-9.5-8.9-15-15.1-17.1z"]],
    "septagon": [576, 512, ["heptagon"], "e820", ["M42.3 291.4c-2.2 9.5 .1 19.5 6.2 27.1l119.3 149.6 2.4 2.7c6 5.9 14.1 9.3 22.6 9.3l191.3 0c9.7 0 19-4.4 25-12l118.7-148.9 2.8-4c3.6-6 5.2-12.9 4.5-19.8l-.8-4.8-42.4-185.7c-1.9-8.1-6.8-15.2-13.8-19.7L474 82.8 302.4 .1c-7.5-3.6-16.1-4.1-24-1.5L273.8 .4 102.2 83.1c-7.5 3.6-13.2 9.9-16.1 17.6l-1.5 5.2-42.3 185.5z", "M267.4-31.5c15.9-5.5 33.5-4.6 48.8 2.8l172.4 83 6.3 3.5c14.2 9 24.5 23.3 28.3 39.9l42.6 186.5 1.2 7.2c1.6 14.3-1.7 28.8-9.4 41.1l-4.2 5.9-119.3 149.6-4.8 5.4c-10.2 10.2-23.6 16.6-38 18.3l-7.3 .4-191.3 0-7.2-.4c-14.3-1.6-27.7-8.1-38-18.3L142.8 488 23.5 338.4c-12.1-15.2-16.7-35.2-12.3-54.2l42.6-186.5 2-7c4.9-13.9 14.4-25.7 27-33.4l5.6-3 172.4-83 6.7-2.8zm35 31.6c-7.5-3.6-16.1-4.1-24-1.5L273.8 .4 102.2 83.1c-7.5 3.6-13.2 9.9-16.1 17.6l-1.5 5.2-42.3 185.5c-2.2 9.5 .1 19.5 6.2 27.1l119.3 149.6 2.4 2.7c6 5.9 14.1 9.3 22.6 9.3l191.3 0c9.7 0 19-4.4 25-12l118.7-148.9 2.8-4c3.6-6 5.2-12.9 4.5-19.8l-.8-4.8-42.4-185.7c-1.9-8.1-6.8-15.2-13.8-19.7L474 82.8 302.4 .1z"]],
    "face-smile-upside-down": [512, 512, [], "e395", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm102.3-87.9c29.3-34.3 73-56.1 121.7-56.1s92.4 21.8 121.7 56.1c5.7 6.7 5 16.8-1.8 22.6s-16.8 5-22.6-1.8C329.8 161.4 295 144 256 144s-73.8 17.4-97.3 44.9c-5.7 6.7-15.8 7.5-22.6 1.8s-7.5-15.8-1.8-22.6zM200 304a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm160 0a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M32 256a224 224 0 1 1 448 0 224 224 0 1 1 -448 0zm480 0a256 256 0 1 0 -512 0 256 256 0 1 0 512 0zM158.7 188.9C182.2 161.4 217 144 256 144s73.8 17.4 97.3 44.9c5.7 6.7 15.8 7.5 22.6 1.8s7.5-15.8 1.8-22.6C348.4 133.8 304.7 112 256 112s-92.4 21.8-121.7 56.1c-5.7 6.7-5 16.8 1.8 22.6s16.8 5 22.6-1.8zM200 304a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm136-24a24 24 0 1 0 0 48 24 24 0 1 0 0-48z"]],
    "glass-empty": [384, 512, [], "e191", ["", "M40.5 32c-4.7 0-8.4 4-8 8.7l34.6 410C68.5 467.3 82.3 480 99 480l186.8 0c16.6 0 30.5-12.7 31.9-29.3l34.6-410c.4-4.7-3.3-8.7-8-8.7L40.5 32zM.6 43.4C-1.3 20 17.1 0 40.5 0L344.2 0c23.4 0 41.8 20 39.9 43.4l-34.6 410C346.7 486.5 319 512 285.8 512L99 512c-33.3 0-61-25.5-63.8-58.6L.6 43.4z"]],
    "ear": [384, 512, [128066], "f5f0", ["M32 192l0 192c0 53 43 96 96 96l9.3 0c39.3 0 74.6-23.9 89.1-60.3l20.1-50.2c8.4-21 23.6-36.5 38.8-47.5 40.4-29.1 66.7-76.5 66.7-130 0-88.4-71.6-160-160-160S32 103.6 32 192zm48 0c0-61.9 50.1-112 112-112s112 50.1 112 112l0 8c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-8c0-44.2-35.8-80-80-80s-80 35.8-80 80l0 16c35.3 0 64 28.7 64 64s-28.7 64-64 64l-16 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-16 0c-8.8 0-16-7.2-16-16l0-32z", "M352 192c0 53.5-26.2 100.9-66.7 130-15.2 11-30.4 26.5-38.8 47.5l-20.1 50.2c-14.6 36.4-49.9 60.3-89.1 60.3l-9.3 0c-53 0-96-43-96-96l0-192c0-88.4 71.6-160 160-160s160 71.6 160 160zM276.3 381.4c5.5-13.7 15.8-24.8 27.8-33.4 48.4-34.9 80-91.7 80-156 0-106-86-192-192-192S0 86 0 192L0 384c0 70.7 57.3 128 128 128l9.3 0c52.3 0 99.4-31.9 118.8-80.5l20.1-50.2zM112 192c0-44.2 35.8-80 80-80s80 35.8 80 80l0 8c0 8.8 7.2 16 16 16s16-7.2 16-16l0-8c0-61.9-50.1-112-112-112S80 130.1 80 192l0 32c0 8.8 7.2 16 16 16l16 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-16 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l16 0c35.3 0 64-28.7 64-64s-28.7-64-64-64l0-16z"]],
    "street-view": [512, 512, [], "f21d", ["M192 224c0 18.7 0 37.3 0 56 14.4 2.1 25.6 13.8 27.2 28.3l8.9 84.5c.4 4.1 3.9 7.2 8 7.2l40 0c4.1 0 7.5-3.1 8-7.2l8.9-84.5c1.5-14.5 12.7-26.2 27.2-28.3 0-18.7 0-37.3 0-56 0-17.7-14.3-32-32-32l-64 0c-17.7 0-32 14.3-32 32zM224 64a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M256 32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm0 96a64 64 0 1 0 0-128 64 64 0 1 0 0 128zM192 280l0 0 0-56c0-17.7 14.3-32 32-32l64 0c17.7 0 32 14.3 32 32l0 56 0 0c-14.4 2.1-25.6 13.8-27.2 28.3l-8.9 84.5c-.4 4.1-3.9 7.2-8 7.2l-40 0c-4.1 0-7.5-3.1-8-7.2l-8.9-84.5c-1.5-14.5-12.7-26.2-27.2-28.3zm-32-56l0 56c0 16.1 11.9 29.4 27.3 31.7l8.9 84.5c2.1 20.4 19.3 35.8 39.8 35.8l40 0c20.5 0 37.6-15.5 39.8-35.8l8.9-84.5c15.5-2.3 27.3-15.6 27.3-31.7l0-56c0-35.3-28.7-64-64-64l-64 0c-35.3 0-64 28.7-64 64zM32 426.2c0-1.1 .4-3.3 3.6-6.9 3.3-3.7 8.9-8 17.3-12.5 16.8-8.9 42-17 73.6-23.1l-6.1-31.4c-33.2 6.4-61.8 15.3-82.6 26.2-10.4 5.5-19.5 11.9-26.2 19.4-6.8 7.6-11.8 17.2-11.8 28.3 0 17.6 12.2 31 25.8 40.3 14.1 9.7 33.5 17.8 56 24.4 45.3 13.2 106.8 21.1 174.2 21.1s128.9-7.9 174.2-21.1c22.5-6.6 41.9-14.7 56-24.4 13.6-9.4 25.8-22.7 25.8-40.3 0-11.1-4.9-20.6-11.8-28.3-6.7-7.5-15.9-13.9-26.2-19.4-20.8-11-49.4-19.8-82.6-26.2l-6.1 31.4c31.6 6.1 56.8 14.2 73.6 23.1 8.4 4.5 14 8.7 17.3 12.5 3.2 3.6 3.6 5.9 3.6 6.9 0 1.6-1.3 6.6-11.9 14-10.2 7-25.9 13.9-46.8 20-41.6 12.1-100 19.8-165.2 19.8s-123.6-7.7-165.2-19.8c-20.9-6.1-36.7-13-46.8-20-10.7-7.3-11.9-12.3-11.9-14z"]],
    "briefs": [512, 512, [], "e6d0", ["M32 112l0 32 448 0 0-32c0-8.8-7.2-16-16-16L48 96c-8.8 0-16 7.2-16 16zm0 64l0 64c0 7.3 7.2 19.1 24.7 24.5 24.5 7.6 46.8 19.8 66 35.8l2.1-2.7C147.6 267.1 160 230.1 160 192l0-16-128 0zM145.7 323c16.9 19.7 29.9 42.8 37.7 68.3 5.4 17.6 17.2 24.7 24.5 24.7l96 0c7.3 0 19.1-7.2 24.5-24.7 7.9-25.4 20.8-48.6 37.7-68.3l-4.7-6.2C334.6 280.8 320 237 320 192l0-16-128 0 0 16c0 45-14.6 88.8-41.6 124.8l-4.7 6.2zM352 176l0 16c0 38.1 12.4 75.1 35.2 105.6l2.1 2.7c19.2-16 41.5-28.3 66-35.8 17.6-5.4 24.7-17.2 24.7-24.5l0-64-128 0z", "M48 96c-8.8 0-16 7.2-16 16l0 32 448 0 0-32c0-8.8-7.2-16-16-16L48 96zm272 80l-128 0 0 16c0 45-14.6 88.8-41.6 124.8l-4.7 6.2c16.9 19.7 29.9 42.8 37.7 68.3 5.4 17.6 17.2 24.7 24.5 24.7l96 0c7.3 0 19.1-7.2 24.5-24.7 7.9-25.4 20.8-48.6 37.7-68.3l-4.7-6.2C334.6 280.8 320 237 320 192l0-16zm69.3 124.3c19.2-16 41.5-28.3 66-35.8 17.6-5.4 24.7-17.2 24.7-24.5l0-64-128 0 0 16c0 38.1 12.4 75.1 35.2 105.6l2.1 2.7zM32 176l0 64c0 7.3 7.2 19.1 24.7 24.5 24.5 7.6 46.8 19.8 66 35.8l2.1-2.7C147.6 267.1 160 230.1 160 192l0-16-128 0zM0 112C0 85.5 21.5 64 48 64l416 0c26.5 0 48 21.5 48 48l0 128c0 26.5-22 47.3-47.3 55.1-50.3 15.6-90 55.3-105.6 105.6-7.8 25.3-28.6 47.3-55.1 47.3l-96 0c-26.5 0-47.3-22-55.1-47.3-15.6-50.3-55.3-90-105.6-105.6-25.3-7.8-47.3-28.6-47.3-55.1L0 112z"]],
    "speakers": [448, 512, [], "f8e0", ["M128 32l0 352c0 17.7 14.3 32 32 32l224 0c17.7 0 32-14.3 32-32l0-352c0-17.7-14.3-32-32-32L160 0c-17.7 0-32 14.3-32 32zM368 272a96 96 0 1 1 -192 0 96 96 0 1 1 192 0zM296 80a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M160 0c-17.7 0-32 14.3-32 32l0 352c0 17.7 14.3 32 32 32l224 0c17.7 0 32-14.3 32-32l0-352c0-17.7-14.3-32-32-32L160 0zM96 32c0-35.3 28.7-64 64-64l224 0c35.3 0 64 28.7 64 64l0 352c0 35.3-28.7 64-64 64l-224 0c-35.3 0-64-28.7-64-64L96 32zM336 272a64 64 0 1 0 -128 0 64 64 0 1 0 128 0zm-160 0a96 96 0 1 1 192 0 96 96 0 1 1 -192 0zM248 80a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM32 80l0 400c0 17.7 14.3 32 32 32l272 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L64 544c-35.3 0-64-28.7-64-64L0 80c0-8.8 7.2-16 16-16s16 7.2 16 16z"]],
    "wave-square": [512, 512, [], "f83e", ["", "M128 96l0 168c0 13.3-10.7 24-24 24l-88 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l80 0 0-168c0-13.3 10.7-24 24-24l128 0c13.3 0 24 10.7 24 24l0 328 112 0 0-168c0-13.3 10.7-24 24-24l88 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-80 0 0 168c0 13.3-10.7 24-24 24l-128 0c-13.3 0-24-10.7-24-24l0-328-112 0z"]],
    "angle-left": [256, 512, [8249], "f104", ["", "M20.7 267.3c-6.2-6.2-6.2-16.4 0-22.6l160-160c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6L54.6 256 203.3 404.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-160-160z"]],
    "turtle": [576, 512, [128034], "f726", ["M32 336c0 8.8 7.2 16 16 16l48 0 0 80c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-80 96 0 0 80c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-80 35.7 0c48.2 0 91-30.8 106.3-76.6l2.8-8.5c2.2-6.5 8.3-10.9 15.2-10.9l32 0c17.7 0 32-14.3 32-32l0-12.6c0-37.2-30.2-67.4-67.4-67.4-24.6 0-44.6 20-44.6 44.6l0 59.4c0 39.8-32.2 72-72 72L48 320c-8.8 0-16 7.2-16 16zm16-80l303.8 0c-8.7-.1-15.8-7.2-15.8-16l0-40c0-75.1-60.9-136-136-136S64 124.9 64 200l0 40c0 8.8-7.2 16-16 16zm448-48a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M200 64C124.9 64 64 124.9 64 200l0 40c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-40c0-92.8 75.2-168 168-168s168 75.2 168 168l0 40c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-40c0-75.1-60.9-136-136-136zM400 188.6c0-42.3 34.3-76.6 76.6-76.6 54.9 0 99.4 44.5 99.4 99.4l0 12.6c0 35.3-28.7 64-64 64l-20.5 0c-20.3 57.4-74.7 96-135.8 96l-3.7 0 0 48c0 26.5-21.5 48-48 48l-32 0c-26.5 0-48-21.5-48-48l0-48-32 0 0 48c0 26.5-21.5 48-48 48l-32 0c-26.5 0-48-21.5-48-48l0-48-16 0c-26.5 0-48-21.5-48-48s21.5-48 48-48l312 0c22.1 0 40-17.9 40-40l0-59.4zM256 416l0 16c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-80 35.7 0c48.2 0 91-30.8 106.3-76.6l2.8-8.5c2.2-6.5 8.3-10.9 15.2-10.9l32 0c17.7 0 32-14.3 32-32l0-12.6c0-37.2-30.2-67.4-67.4-67.4-24.6 0-44.6 20-44.6 44.6l0 59.4c0 39.8-32.2 72-72 72L48 320c-8.8 0-16 7.2-16 16s7.2 16 16 16l48 0 0 80c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-80 96 0 0 64zM480 192a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"]],
    "arrow-right-to-line": [512, 512, [8677, "arrow-to-right"], "f340", ["", "M512 80c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 352c0 8.8 7.2 16 16 16s16-7.2 16-16l0-352zM379.3 267.3c6.2-6.2 6.2-16.4 0-22.6l-144-144c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6L329.4 240 16 240c-8.8 0-16 7.2-16 16s7.2 16 16 16l313.4 0-116.7 116.7c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l144-144z"]],
    "pants-straight": [448, 512, [], "e6d6", ["M1.6 51l26 416c1.6 25.3 22.6 45 47.9 45-24.4-1.1-44.3-20.4-45.8-45L3.7 51C2 24.1 22.8 1.2 49.5 0 21.8 0-.1 23.4 1.6 51zm34-2l2.9 47 57.9 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-55.9 0 21.1 337c.5 8.4 7.5 15 16 15l130.9 0 0-296c0-8.8 7.2-16 16-16s16 7.2 16 16l0 296 130.9 0c8.4 0 15.4-6.6 16-15l21.1-337-55.9 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l57.9 0 2.9-47c.6-9.2-6.7-17-16-17L51.6 32c-9.2 0-16.5 7.8-16 17z", "M51.6 32c-9.2 0-16.5 7.8-16 17l2.9 47 57.9 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-55.9 0 21.1 337c.5 8.4 7.5 15 16 15l130.9 0 0-296c0-8.8 7.2-16 16-16s16 7.2 16 16l0 296 130.9 0c8.4 0 15.4-6.6 16-15l21.1-337-55.9 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l57.9 0 2.9-47c.6-9.2-6.7-17-16-17L51.6 32zM224.5 512L77.6 512c-25.3 0-46.3-19.7-47.9-45L3.7 51C1.9 23.4 23.9 0 51.6 0L397.4 0c27.7 0 49.6 23.4 47.9 51l-26 416c-1.6 25.3-22.6 45-47.9 45l-146.9 0z"]],
    "screwdriver": [576, 512, [129691], "f54a", ["M56.7 404.7c-6.2 6.2-6.2 16.4 0 22.6l60.1 60.1c6.2 6.2 16.4 6.2 22.6 0L265.5 361.4c22.9-22.9 22.9-59.9 0-82.7s-59.9-22.8-82.7 0L56.7 404.7zM384.1 97.1l0 62.9 62.9 0 71.9-107.9-26.9-26.9-107.9 71.9z", "M550.8 38.7c5.4 5.4 6.2 13.8 2 20.2L473.6 177.8c-5.9 8.9-15.9 14.2-26.6 14.2l-72.2 0-76.3 76.3c24.6 35.3 21.2 84.2-10.3 115.7L162.1 510.1c-18.7 18.7-49.1 18.7-67.9 0L34.1 449.9c-18.7-18.7-18.7-49.1 0-67.9L160.1 256c31.5-31.5 80.4-34.9 115.7-10.3l76.3-76.3 0-72.2c0-10.7 5.3-20.7 14.2-26.6L485.2-8.7c6.3-4.2 14.8-3.4 20.2 2l45.4 45.4zM384.1 160l62.9 0 71.9-107.9-26.9-26.9-107.9 71.9 0 62.9zM56.7 427.3l60.1 60.1c6.2 6.2 16.4 6.2 22.6 0L265.5 361.4c22.9-22.9 22.9-59.9 0-82.7s-59.9-22.8-82.7 0L56.7 404.7c-6.2 6.2-6.2 16.4 0 22.6z"]],
    "traffic-light-stop": [320, 512, [], "f63a", ["M32 32l0 352c0 70.7 57.3 128 128 128s128-57.3 128-128l0-352c0-17.7-14.3-32-32-32L64 0C46.3 0 32 14.3 32 32zm184 80a56 56 0 1 1 -112 0 56 56 0 1 1 112 0zm0 144a56 56 0 1 1 -112 0 56 56 0 1 1 112 0zM104 400c0-30.9 25.1-56 56-56s56 25.1 56 56-25.1 56-56 56-56-25.1-56-56z", "M64 0C46.3 0 32 14.3 32 32l0 352c0 70.7 57.3 128 128 128s128-57.3 128-128l0-352c0-17.7-14.3-32-32-32L64 0zM0 32C0-3.3 28.7-32 64-32l192 0c35.3 0 64 28.7 64 64l0 352c0 88.4-71.6 160-160 160S0 472.4 0 384L0 32zM136 400c0 13.3 10.7 24 24 24s24-10.7 24-24-10.7-24-24-24-24 10.7-24 24zm-32 0c0-30.9 25.1-56 56-56s56 25.1 56 56-25.1 56-56 56-56-25.1-56-56zm56-168a24 24 0 1 0 0 48 24 24 0 1 0 0-48zm0 80a56 56 0 1 1 0-112 56 56 0 1 1 0 112zm0-144a56 56 0 1 1 0-112 56 56 0 1 1 0 112z"]],
    "square-euro": [448, 512, [], "e732", ["M32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64C46.3 64 32 78.3 32 96zm72 128c0-8.8 7.2-16 16-16l24.7 0c19.2-46.9 65.4-80 119.2-80l33 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-33 0c-35.7 0-66.8 19.3-83.6 48l59.7 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-71.4 0c-1 5.4-1.4 11-1.4 16.8 0 5.2 .4 10.3 1.2 15.2l71.7 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-60.6 0c16.6 29.5 48.2 49.5 84.5 49.5l33 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-33 0c-54.4 0-101-33.8-119.8-81.5L120 304c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0c-.6-5-.9-10.1-.9-15.2 0-5.7 .4-11.3 1.1-16.8L120 240c-8.8 0-16-7.2-16-16z", "M64 64C46.3 64 32 78.3 32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm263.9 32l33 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-33 0c-35.7 0-66.8 19.3-83.6 48l59.7 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-71.4 0c-1 5.4-1.4 11-1.4 16.8 0 5.2 .4 10.3 1.2 15.2l71.7 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-60.6 0c16.6 29.5 48.2 49.5 84.5 49.5l33 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-33 0c-54.4 0-101-33.8-119.8-81.5L120 304c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0c-.6-5-.9-10.1-.9-15.2 0-5.7 .4-11.3 1.1-16.8L120 240c-8.8 0-16-7.2-16-16s7.2-16 16-16l24.7 0c19.2-46.9 65.4-80 119.2-80z"]],
    "tractor": [576, 512, [128668], "f722", ["M33 336l7 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-7 0c2.9 23.4 12.1 44.8 25.9 62.5l5-5c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6l-5 5c17.7 13.8 39.1 23 62.5 25.9l0-7c0-8.8 7.2-16 16-16s16 7.2 16 16l0 7c23.4-2.9 44.8-12.1 62.5-25.9l-5-5c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l5 5c13.8-17.7 23-39.1 25.9-62.5l-7 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l7 0c-2.9-23.4-12.1-44.8-25.9-62.5l-5 5c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l5-5c-17.7-13.8-39.1-23-62.5-25.9l0 7c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-7c-23.4 2.9-44.8 12.1-62.5 25.9l5 5c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-5-5C45.1 291.2 35.9 312.6 33 336zm199 16a72 72 0 1 1 -144 0 72 72 0 1 1 144 0zm24-128c38.9 29.2 64 75.7 64 128l109.4 0c14.3-10.1 31.8-16 50.6-16 2.4 0 4.9 .1 7.3 .3l51-42.5c3.6-3 5.8-7.5 5.8-12.3l0-41.5c0-8.8-7.2-16-16-16l-272 0zM424 424a56 56 0 1 0 112 0 56 56 0 1 0 -112 0z", "M128 64l107.8 0c11.2 0 21.7 5.9 27.4 15.5L330.7 192 128 192 128 64zM96 192l0 13.3C39.5 230 0 286.4 0 352 0 440.4 71.6 512 160 512 237.4 512 302 457 316.8 384l84.8 0c-6.1 12-9.6 25.6-9.6 40 0 48.6 39.4 88 88 88s88-39.4 88-88c0-32.7-17.8-61.2-44.3-76.4l35-29.2c10.9-9.1 17.3-22.6 17.3-36.9l0-41.5c0-26.5-21.5-48-48-48l-48 0 0-80c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 80-80 0-77.4-128.9C279.1 43.8 258.2 32 235.8 32L128 32c-17.7 0-32 14.3-32 32l0 128zM487.3 336.3c-2.4-.2-4.8-.3-7.3-.3-18.8 0-36.3 5.9-50.6 16L320 352c0-52.3-25.1-98.8-64-128l272 0c8.8 0 16 7.2 16 16l0 41.5c0 4.7-2.1 9.3-5.8 12.3l-51 42.5zM144 472l0 7c-23.4-2.9-44.8-12.1-62.5-25.9l5-5c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-5 5C45.1 412.8 35.9 391.4 33 368l7 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-7 0c2.9-23.4 12.1-44.8 25.9-62.5l5 5c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-5-5c17.7-13.8 39.1-23 62.5-25.9l0 7c0 8.8 7.2 16 16 16s16-7.2 16-16l0-7c23.4 2.9 44.8 12.1 62.5 25.9l-5 5c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l5-5c13.8 17.7 23 39.1 25.9 62.5l-7 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l7 0c-2.9 23.4-12.1 44.8-25.9 62.5l-5-5c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l5 5c-17.7 13.8-39.1 23-62.5 25.9l0-7c0-8.8-7.2-16-16-16s-16 7.2-16 16zm16-48a72 72 0 1 0 0-144 72 72 0 1 0 0 144zm-40-72a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zm304 72a56 56 0 1 1 112 0 56 56 0 1 1 -112 0z"]],
    "bridge-circle-xmark": [576, 512, [], "e4cb", ["M32 160l448 0 0 54c-15.3-3.9-31.4-6-48-6-53.2 0-101.4 21.7-136.2 56.6-12.1-5.5-25.6-8.6-39.8-8.6-53 0-96 43-96 96l0 96-64 0 0-113.5c0-41-26-77.1-64-90.5L32 160z", "M16 32C7.2 32 0 39.2 0 48S7.2 64 16 64l32 0 0 64-32 0c-8.8 0-16 7.2-16 16L0 256c0 7.3 5 13.7 12.1 15.5l3.4 .9C44 279.5 64 305.1 64 334.5L64 448c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-96c0-35.3 28.7-64 64-64 6.3 0 12.4 .9 18.2 2.6 6.5-9.3 13.7-18 21.7-26-12.1-5.5-25.6-8.6-39.8-8.6-53 0-96 43-96 96l0 96-64 0 0-113.5c0-41-26-77.1-64-90.5l0-83.9 448 0 0 54c11.1 2.9 21.8 6.7 32 11.4l0-81.4c0-8.8-7.2-16-16-16l-32 0 0-64 32 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L16 32zM432 64l0 64-96 0 0-64 96 0zM304 64l0 64-96 0 0-64 96 0zM176 64l0 64-96 0 0-64 96 0zM320 400a112 112 0 1 1 224 0 112 112 0 1 1 -224 0zm256 0a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-121.4 0l36.7-36.7c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-36.7 36.7-36.7-36.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l36.7 36.7-36.7 36.7c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l36.7-36.7 36.7 36.7c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L454.6 400z"]],
    "vials": [512, 512, [], "f493", ["M64 224l0 192c0 35.3 28.7 64 64 64s64-28.7 64-64l0-192-128 0zm256 0l0 192c0 35.3 28.7 64 64 64s64-28.7 64-64l0-192-128 0z", "M16 0C7.2 0 0 7.2 0 16S7.2 32 16 32l16 0 0 384c0 53 43 96 96 96s96-43 96-96l0-384 64 0 0 384c0 53 43 96 96 96s96-43 96-96l0-384 16 0c8.8 0 16-7.2 16-16S504.8 0 496 0L16 0zM192 32l0 160-128 0 0-160 128 0zM64 416l0-192 128 0 0 192c0 35.3-28.7 64-64 64s-64-28.7-64-64zM448 32l0 160-128 0 0-160 128 0zM320 416l0-192 128 0 0 192c0 35.3-28.7 64-64 64s-64-28.7-64-64z"]],
    "starfighter-twin-ion-engine-advanced": [576, 512, ["starfighter-alt-advanced"], "e28e", ["M32 236.8l0 38.3 101.5 22.6c-3.6-13.3-5.5-27.3-5.5-41.7s1.9-28.4 5.5-41.7L32 236.8zM160 256a128 128 0 1 0 256 0 128 128 0 1 0 -256 0zm208 0a80 80 0 1 1 -160 0 80 80 0 1 1 160 0zm74.5-41.7c3.6 13.3 5.5 27.3 5.5 41.7s-1.9 28.4-5.5 41.7l101.5-22.6 0-38.3-101.5-22.6z", "M124.8 25.6c5.3-7.1 3.9-17.1-3.2-22.4S104.5-.7 99.2 6.4L9.6 125.9C3.4 134.2 0 144.3 0 154.7L0 357.3c0 10.4 3.4 20.5 9.6 28.8L99.2 505.6c5.3 7.1 15.3 8.5 22.4 3.2s8.5-15.3 3.2-22.4L35.2 366.9c-2.1-2.8-3.2-6.1-3.2-9.6l0-49.4 116.1 25.8C175.5 382.8 227.9 416 288 416s112.5-33.2 139.9-82.2l116.1-25.8 0 41.9c0 3.3-1 6.5-2.9 9.2L450.9 486.8c-5.1 7.2-3.4 17.2 3.8 22.3s17.2 3.4 22.3-3.8l90.1-127.7c5.7-8.1 8.8-17.8 8.8-27.7l0-202.6c0-10.9-3.7-21.5-10.5-30L476.5 6C471-.9 460.9-2 454 3.5s-8 15.6-2.5 22.5l89 111.2c2.3 2.8 3.5 6.4 3.5 10l0 56.8-116.1-25.8C400.5 129.2 348.1 96 288 96s-112.5 33.2-139.9 82.2L32 204.1 32 154.7c0-3.5 1.1-6.8 3.2-9.6L124.8 25.6zM442.5 214.3l101.5 22.6 0 38.3-101.5 22.6c3.6-13.3 5.5-27.3 5.5-41.7s-1.9-28.4-5.5-41.7zm-309 83.4L32 275.2 32 236.8 133.5 214.3c-3.6 13.3-5.5 27.3-5.5 41.7s1.9 28.4 5.5 41.7zM288 128a128 128 0 1 1 0 256 128 128 0 1 1 0-256zm48 128a48 48 0 1 1 -96 0 48 48 0 1 1 96 0zm-48-80a80 80 0 1 0 0 160 80 80 0 1 0 0-160z"]],
    "stethoscope": [512, 512, [129658], "f0f1", ["M416 192a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M0 48C0 21.5 21.5 0 48 0l56 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L48 32c-8.8 0-16 7.2-16 16l0 128c0 70.7 57.3 128 128 128s128-57.3 128-128l0-128c0-8.8-7.2-16-16-16l-56 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l56 0c26.5 0 48 21.5 48 48l0 128c0 83-63.1 151.2-144 159.2l0 48.8c0 70.7 57.3 128 128 128s128-57.3 128-128l0-130c-27.6-7.1-48-32.2-48-62 0-35.3 28.7-64 64-64s64 28.7 64 64c0 29.8-20.4 54.9-48 62l0 130c0 88.4-71.6 160-160 160S144 472.4 144 384l0-48.8C63.1 327.2 0 259 0 176L0 48zM448 224a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]],
    "podcast": [448, 512, [], "f2ce", ["M189.4 349.5c0 14.4 3 39.3 7.3 65.7 4.2 25.3 9.1 49.4 12.7 63 1 .4 2.5 .8 4.9 1.2 2.7 .4 5.9 .6 9.7 .6s7-.2 9.7-.6c2.3-.4 3.9-.8 4.9-1.2 3.6-13.7 8.6-37.9 12.8-63.1 4.3-26.4 7.3-51.2 7.3-65.6 0-4.3-.9-5.8-1.1-6.1-.2-.3-.7-1.2-2.8-2.3-5.2-2.9-15.3-5.1-30.7-5.1s-25.5 2.2-30.7 5.1c-2.1 1.1-2.6 2-2.8 2.3-.2 .3-1.1 1.8-1.1 6.1zM208 224a16 16 0 1 0 32 0 16 16 0 1 0 -32 0z", "M416 224c0 64.8-32.1 122.1-81.3 156.9-1.2 13-3 27.1-5.1 40.7 70.5-37.7 118.5-112.1 118.5-197.6 0-123.7-100.3-224-224-224S0 100.3 0 224c0 85.5 48 159.9 118.4 197.6-2.1-13.6-3.9-27.7-5.1-40.7-49.2-34.8-81.3-92.1-81.3-156.9 0-106 86-192 192-192s192 86 192 192zm-96 0c0 22.5-7.7 43.1-20.7 59.5 8.4 5.8 16.2 13.3 22.6 22.9 18.8-22.3 30.1-51 30.1-82.4 0-70.7-57.3-128-128-128S96 153.3 96 224c0 31.4 11.3 60.2 30.1 82.4 6.3-9.6 14.2-17.2 22.6-22.9-12.9-16.4-20.7-37-20.7-59.5 0-53 43-96 96-96s96 43 96 96zm-96-16a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm0 64a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM209.5 478.2c-3.6-13.6-8.6-37.7-12.7-63-4.3-26.4-7.3-51.3-7.3-65.7 0-4.3 .9-5.8 1.1-6.1 .2-.3 .7-1.2 2.8-2.3 5.2-2.9 15.3-5.1 30.7-5.1s25.5 2.2 30.7 5.1c2.1 1.1 2.6 2 2.8 2.3 .2 .3 1.1 1.8 1.1 6.1 0 14.3-3 39.2-7.3 65.6-4.1 25.2-9.1 49.4-12.8 63.1-1 .4-2.5 .8-4.9 1.2-2.7 .4-5.9 .6-9.7 .6s-7-.2-9.7-.6c-2.3-.4-3.9-.8-4.9-1.2zm-30.6 9.5c5.3 19.8 25.5 24.3 45.1 24.3s39.8-4.6 45.1-24.3c8.1-29.9 21.5-103.9 21.5-138.2 0-36.5-32.4-45.5-66.6-45.5s-66.6 9-66.6 45.5c0 34.4 13.4 108.5 21.5 138.2z"]],
    "arrow-up-right-dots": [512, 512, [], "e4b7", ["", "M80 32c-8.8 0-16 7.2-16 16s7.2 16 16 16L169.4 64 4.7 228.7c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0L192 86.6 192 176c0 8.8 7.2 16 16 16s16-7.2 16-16l0-128c0-8.8-7.2-16-16-16L80 32zM456 70.1a14.1 14.1 0 1 1 -28.2 0 14.1 14.1 0 1 1 28.2 0zM441.9 32a38.1 38.1 0 1 0 0 76.2 38.1 38.1 0 1 0 0-76.2zM331.8 194.2a14.1 14.1 0 1 1 -28.2 0 14.1 14.1 0 1 1 28.2 0zm-14.1-38.1a38.1 38.1 0 1 0 0 76.2 38.1 38.1 0 1 0 0-76.2zm124.2 24a14.1 14.1 0 1 1 0 28.2 14.1 14.1 0 1 1 0-28.2zm-38.1 14.1a38.1 38.1 0 1 0 76.2 0 38.1 38.1 0 1 0 -76.2 0zM208.3 317.8a14.1 14.1 0 1 1 -28.2 0 14.1 14.1 0 1 1 28.2 0zm-14.1-38.1a38.1 38.1 0 1 0 0 76.2 38.1 38.1 0 1 0 0-76.2zm123.5 24a14.1 14.1 0 1 1 0 28.2 14.1 14.1 0 1 1 0-28.2zm-38.1 14.1a38.1 38.1 0 1 0 76.2 0 38.1 38.1 0 1 0 -76.2 0zm176.3 0a14.1 14.1 0 1 1 -28.2 0 14.1 14.1 0 1 1 28.2 0zm-14.1-38.1a38.1 38.1 0 1 0 0 76.2 38.1 38.1 0 1 0 0-76.2zM70.1 427.8a14.1 14.1 0 1 1 0 28.2 14.1 14.1 0 1 1 0-28.2zM32 441.9a38.1 38.1 0 1 0 76.2 0 38.1 38.1 0 1 0 -76.2 0zm176.3 0a14.1 14.1 0 1 1 -28.2 0 14.1 14.1 0 1 1 28.2 0zm-14.1-38.1a38.1 38.1 0 1 0 0 76.2 38.1 38.1 0 1 0 0-76.2zm123.5 24a14.1 14.1 0 1 1 0 28.2 14.1 14.1 0 1 1 0-28.2zm-38.1 14.1a38.1 38.1 0 1 0 76.2 0 38.1 38.1 0 1 0 -76.2 0zm176.3 0a14.1 14.1 0 1 1 -28.2 0 14.1 14.1 0 1 1 28.2 0zm-14.1-38.1a38.1 38.1 0 1 0 0 76.2 38.1 38.1 0 1 0 0-76.2z"]],
    "chess-queen": [512, 512, [9819], "f445", ["M49 171.8l104.6 196.2 204.8 0 104.6-196.2-14.2 4.7c-30.6 10.2-64.2 1-85.2-22.9l-4-5-10.7-14.3-25.6 19.2c-19.4 14.5-43 22.4-67.2 22.4-21.2 0-41.9-6-59.7-17.2l-7.4-5.2-25.6-19.2-10.7 14.3c-20.7 27.5-56.6 38.8-89.3 27.9L49 171.8zm47 306c0 1.2 1 2.1 2.1 2.1l315.7 0c1.2 0 2.1-1 2.1-2.1 0-.4-.1-.9-.4-1.2l-55.7-76.7-207.7 0-55.8 76.7c-.3 .4-.4 .8-.4 1.2zM232 40a24 24 0 1 0 48 0 24 24 0 1 0 -48 0z", "M354.3 96.2c4.2 .6 8 2.9 10.6 6.3l20.3 27.1 2.4 3c12.7 14.3 32.7 19.9 51.1 13.8l52.2-17.4c6.2-2.1 13.1-.1 17.3 4.9s5 12.1 1.9 17.8l-123.3 231.2 54.7 75.1c4.2 5.8 6.5 12.9 6.5 20.1 0 18.8-15.3 34.1-34.1 34.1L98.1 512c-18.8 0-34.1-15.3-34.1-34.1 0-7.2 2.3-14.2 6.5-20.1L125.2 382.7 1.9 151.5c-3.1-5.8-2.3-12.8 1.9-17.8s11.1-6.9 17.3-4.9l52.2 17.4 3.7 1.1c18.6 4.6 38.3-2.3 49.9-17.8l20.3-27.1 2.2-2.4c5.6-4.9 14-5.4 20.2-.8l38.4 28.8 5.3 3.7c12.7 8 27.5 12.3 42.7 12.3 17.3 0 34.2-5.6 48-16l38.4-28.8 2.7-1.6c2.8-1.4 6-1.9 9.2-1.4zM152.2 400L96.4 476.7c-.3 .4-.4 .8-.4 1.2 0 1.2 1 2.1 2.1 2.1l315.7 0c1.2 0 2.1-1 2.1-2.1 0-.4-.1-.9-.4-1.2l-55.7-76.7-207.7 0zm171-246.4c-19.4 14.5-43 22.4-67.2 22.4-21.2 0-41.9-6-59.7-17.2l-7.4-5.2-25.6-19.2-10.7 14.3c-20.7 27.5-56.6 38.8-89.3 27.9L49 171.8 153.6 368 358.4 368 463 171.8 448.8 176.6c-30.6 10.2-64.2 1-85.2-22.9l-4-5-10.7-14.3-25.6 19.2zM256 96a56 56 0 1 1 0-112 56 56 0 1 1 0 112zm0-80a24 24 0 1 0 0 48 24 24 0 1 0 0-48z"]],
    "anchor-circle-exclamation": [640, 512, [], "e4ab", ["M240 80a48 48 0 1 0 96 0 48 48 0 1 0 -96 0z", "M288 32a48 48 0 1 0 0 96 48 48 0 1 0 0-96zM208 80c0-44.2 35.8-80 80-80s80 35.8 80 80c0 38.7-27.5 71-64 78.4l0 304.8c4.5-.4 8.9-1.1 13.2-1.9 3.5 10.4 7.9 20.5 13.1 30-13.6 3.1-27.7 4.7-42.3 4.7-106 0-192-86-192-192l0-28.7-37.5 32.8c-6.7 5.8-16.8 5.1-22.6-1.5s-5.1-16.8 1.5-22.6l64-56c6-5.3 15-5.3 21.1 0l64 56c6.7 5.8 7.3 15.9 1.5 22.6s-15.9 7.3-22.6 1.5L128 275.3 128 304c0 83 63.1 151.2 144 159.2l0-304.8c-36.5-7.4-64-39.7-64-78.4zM608 400a112 112 0 1 0 -224 0 112 112 0 1 0 224 0zm-256 0a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm144 44a20 20 0 1 1 0 40 20 20 0 1 1 0-40zm0-124c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-64c0-8.8 7.2-16 16-16z"]],
    "ellipsis-vertical": [64, 512, ["ellipsis-v"], "f142", ["", "M32 416c17.7 0 32 14.3 32 32s-14.3 32-32 32-32-14.3-32-32 14.3-32 32-32zm0-192c17.7 0 32 14.3 32 32s-14.3 32-32 32-32-14.3-32-32 14.3-32 32-32zM0 64A32 32 0 1 1 64 64 32 32 0 1 1 0 64z"]],
    "acorn": [448, 512, [], "f6ae", ["M32 160l0 31.8 32.2 0c109.8 .2 219.6 .2 329.4 .2 7.5-.2 14.9-.2 22.4 0l0-32c0-35.3-28.7-64-64-64L96 96c-35.3 0-64 28.7-64 64zm48 64l.3 13.8C83.8 308.7 114.9 404.7 224 446 340.4 402 368 295.6 368 224L80 224z", "M244.7 4.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6l-3.9 3.9c-9.2 9.2-16 20.5-19.8 32.8l108.3 0 4.9 .1C407.7 66.7 448 108.6 448 160l0 32-.2 3.3c-1.5 15.1-13.5 27-28.6 28.6l-3.3 .2-16 0-.4 15.2c-3.8 78.1-38.6 189.9-165.5 237.3l-5 1.4c-3.4 .6-6.9 .6-10.3 0l-5-1.4C87 429.1 52.2 317.3 48.4 239.2l-.4-15.2-16 0-3.3-.2c-15.1-1.5-27-13.5-28.6-28.6L0 192 0 160c0-51.4 40.3-93.3 91.1-95.9L96 64 210.6 64c4.5-20.8 14.9-40.1 30.2-55.4l3.9-3.9zM80.3 237.8C83.8 308.7 114.9 404.7 224 446 340.4 402 368 295.6 368 224l-288 0 .3 13.8zM96 96c-35.3 0-64 28.7-64 64l0 32 384 0 0-32c0-35.3-28.7-64-64-64L96 96z"]],
    "ban-parking": [512, 512, ["parking-circle-slash"], "f616", ["M32 256c0 123.7 100.3 224 224 224 56.1 0 107.4-20.6 146.7-54.7L297 319.6c-3 .3-5.9 .4-9 .4l-80 0 0 48c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-169.4-89.3-89.3C52.6 148.6 32 199.9 32 256zM109.3 86.7l66.7 66.7 0-1.4c0-13.3 10.7-24 24-24l88 0c53 0 96 43 96 96 0 37.2-21.1 69.4-52 85.4l93.3 93.3c34.1-39.3 54.7-90.6 54.7-146.7 0-123.7-100.3-224-224-224-56.1 0-107.4 20.6-146.7 54.7zM208 160l0 25.4 99.6 99.6c25.8-8.3 44.4-32.4 44.4-61 0-35.3-28.7-64-64-64l-80 0zm0 70.6l0 57.4 57.4 0-57.4-57.4z", "M425.3 402.7L332 309.4c30.9-16 52-48.2 52-85.4 0-53-43-96-96-96l-88 0c-13.3 0-24 10.7-24 24l0 1.4-66.7-66.7c39.3-34.1 90.6-54.7 146.7-54.7 123.7 0 224 100.3 224 224 0 56.1-20.6 107.4-54.7 146.7zm-22.6 22.6C363.4 459.4 312.1 480 256 480 132.3 480 32 379.7 32 256 32 199.9 52.6 148.6 86.7 109.3L176 198.6 176 368c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48 80 0c3 0 6-.1 9-.4L402.7 425.3zM307.6 285l-99.6-99.6 0-25.4 80 0c35.3 0 64 28.7 64 64 0 28.5-18.7 52.7-44.4 61zM208 230.6l57.4 57.4-57.4 0 0-57.4zM256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512z"]],
    "square-dong": [448, 512, [], "e70f", ["M32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64C46.3 64 32 78.3 32 96zm80 304c0-8.8 7.2-16 16-16l192 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-192 0c-8.8 0-16-7.2-16-16zm16-128c0-44.2 35.8-80 80-80 18 0 34.6 6 48 16l0-48-48 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l48 0 0-16c0-8.8 7.2-16 16-16s16 7.2 16 16l0 16 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0 0 176c0 8.8-7.2 16-16 16s-16-7.2-16-16c-13.4 10-30 16-48 16-44.2 0-80-35.8-80-80zm32 0a48 48 0 1 0 96 0 48 48 0 1 0 -96 0z", "M64 64C46.3 64 32 78.3 32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm256 16c0-8.8 7.2-16 16-16s16 7.2 16 16l0 16 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0 0 176c0 8.8-7.2 16-16 16s-16-7.2-16-16c-13.4 10-30 16-48 16-44.2 0-80-35.8-80-80s35.8-80 80-80c18 0 34.6 6 48 16l0-48-48 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l48 0 0-16zM208 224a48 48 0 1 0 0 96 48 48 0 1 0 0-96zM112 400c0-8.8 7.2-16 16-16l192 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-192 0c-8.8 0-16-7.2-16-16z"]],
    "list-dropdown": [448, 512, [], "e1cf", ["M32 192l384 0 0 224c0 17.7-14.3 32-32 32L64 448c-17.7 0-32-14.3-32-32l0-224zm64 80c0 8.8 7.2 16 16 16l224 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-224 0c-8.8 0-16 7.2-16 16zm0 96c0 8.8 7.2 16 16 16l224 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-224 0c-8.8 0-16 7.2-16 16z", "M64 64l320 0c17.7 0 32 14.3 32 32l0 64-384 0 0-64c0-17.7 14.3-32 32-32zM32 192l384 0 0 224c0 17.7-14.3 32-32 32L64 448c-17.7 0-32-14.3-32-32l0-224zM0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zM112 256c-8.8 0-16 7.2-16 16s7.2 16 16 16l224 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-224 0zm0 96c-8.8 0-16 7.2-16 16s7.2 16 16 16l224 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-224 0zM312 92c-4.9 0-9.2 2.9-11.1 7.4s-.8 9.6 2.6 13.1l24 24c4.7 4.7 12.3 4.7 17 0l24-24c3.4-3.4 4.5-8.6 2.6-13.1S364.9 92 360 92l-48 0z"]],
    "camera-circle-ellipsis": [640, 512, [], "e766", ["M96 160c0-17.7 14.3-32 32-32l66.7 0c5.7 0 11-3 13.8-7.9l28.1-48.1c2.9-4.9 8.1-7.9 13.8-7.9l139.2 0c5.7 0 11 3 13.8 7.9l28.1 48.1c2.9 4.9 8.1 7.9 13.8 7.9l66.7 0c17.7 0 32 14.3 32 32l0 54c-15.3-3.9-31.4-6-48-6-29.5 0-57.4 6.6-82.4 18.5-20-30.4-54.5-50.5-93.6-50.5-61.9 0-112 50.1-112 112 0 56.4 41.7 103.1 96 110.9 0 .4 0 .8 0 1.1 0 16.6 2.1 32.7 6 48l-182 0c-17.7 0-32-14.3-32-32l0-256z", "M250.4 32c-17.1 0-32.9 9.1-41.5 23.8L185.5 96 128 96c-35.3 0-64 28.7-64 64l0 256c0 35.3 28.7 64 64 64l193.4 0c-4.7-10.2-8.5-20.9-11.4-32l-182 0c-17.7 0-32-14.3-32-32l0-256c0-17.7 14.3-32 32-32l66.7 0c5.7 0 11-3 13.8-7.9l28.1-48.1c2.9-4.9 8.1-7.9 13.8-7.9l139.2 0c5.7 0 11 3 13.8 7.9l28.1 48.1c2.9 4.9 8.1 7.9 13.8 7.9l66.7 0c17.7 0 32 14.3 32 32l0 54c11.1 2.9 21.8 6.7 32 11.4l0-65.4c0-35.3-28.7-64-64-64l-57.5 0-23.4-40.2C422.5 41.1 406.7 32 389.6 32L250.4 32zM320 176c-61.9 0-112 50.1-112 112 0 56.4 41.7 103.1 96 110.9 .1-10.9 1-21.6 2.8-31.9-37.9-6.3-66.8-39.2-66.8-78.9 0-44.2 35.8-80 80-80 27.4 0 51.5 13.7 65.9 34.7 8.7-6.1 18-11.5 27.7-16.2-20-30.4-54.5-50.5-93.6-50.5zM496 512a112 112 0 1 1 0-224 112 112 0 1 1 0 224zm0-256a144 144 0 1 0 0 288 144 144 0 1 0 0-288zm20 144a20 20 0 1 0 -40 0 20 20 0 1 0 40 0zm44 20a20 20 0 1 0 0-40 20 20 0 1 0 0 40zM452 400a20 20 0 1 0 -40 0 20 20 0 1 0 40 0z"]],
    "family-dress": [512, 512, [], "e301", ["M42.5 352L77.3 230.3c6.5-22.7 27.2-38.3 50.8-38.3 8.9 0 17.5 2.2 25 6.3 2.2 15.9 8 30.7 16.5 43.4-25.5 23.4-41.5 57-41.5 94.3 0 5.3 0 10.7 0 16l-85.6 0zM160.1 64a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm48 272c0-26.5 21.5-48 48-48s48 21.5 48 48l0 32c0 8.8-7.2 16-16 16l-64 0c-8.8 0-16-7.2-16-16l0-32zm72-152a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm62.5 57.7c8.5-12.8 14.3-27.5 16.5-43.4 7.5-4 16-6.3 25-6.3 23.6 0 44.3 15.6 50.8 38.3l34.8 121.7-85.6 0 0-16c0-37.3-16-70.9-41.5-94.3zM416.1 64a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M128.1 32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm0 96a64 64 0 1 0 0-128 64 64 0 1 0 0 128zm0 224l-85.6 0 34.8-121.7c6.5-22.7 27.2-38.3 50.8-38.3 8.9 0 17.5 2.2 25 6.3-.6-4.7-1-9.4-1-14.3 0-6.8 .7-13.5 1.9-20-8.2-2.6-16.9-4-25.9-4-37.9 0-71.2 25.1-81.6 61.5L11.8 343.2C5.9 363.7 21.3 384 42.5 384l21.6 0 0 112c0 8.8 7.2 16 16 16s16-7.2 16-16l0-112 33.3 0c-.9-5.2-1.3-10.5-1.3-16l0-16zm254.7 32l33.3 0 0 112c0 8.8 7.2 16 16 16s16-7.2 16-16l0-112 21.6 0c21.3 0 36.6-20.3 30.8-40.8L465.7 221.5c-10.4-36.4-43.7-61.5-81.6-61.5-9 0-17.7 1.4-25.9 4 1.3 6.5 1.9 13.1 1.9 20 0 4.8-.3 9.6-1 14.3 7.5-4 16-6.3 25-6.3 23.6 0 44.3 15.6 50.8 38.3l34.8 121.7-85.6 0 0 16c0 5.5-.5 10.8-1.3 16zm1.3-352a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm0 96a64 64 0 1 0 0-128 64 64 0 1 0 0 128zm-128 32a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm0 80a56 56 0 1 0 0-112 56 56 0 1 0 0 112zm0 48c26.5 0 48 21.5 48 48l0 32c0 8.8-7.2 16-16 16l-64 0c-8.8 0-16-7.2-16-16l0-32c0-26.5 21.5-48 48-48zm-48 125.3l0 82.7c0 8.8 7.2 16 16 16s16-7.2 16-16l0-80 32 0 0 80c0 8.8 7.2 16 16 16s16-7.2 16-16l0-82.7c18.6-6.6 32-24.4 32-45.3l0-32c0-44.2-35.8-80-80-80s-80 35.8-80 80l0 32c0 20.9 13.4 38.7 32 45.3z"]],
    "podium": [448, 512, [], "f680", ["M84.3 192l22.5 258.8c1.4 16.5 15.3 29.2 31.9 29.2l170.6 0c16.6 0 30.4-12.7 31.9-29.2L363.7 192 84.3 192zM208 48c0 8.8 7.2 16 16 16l64 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-64 0c-8.8 0-16 7.2-16 16z", "M224 32c-8.8 0-16 7.2-16 16s7.2 16 16 16l64 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-64 0zm-45.3 0C185.3 13.4 203.1 0 224 0l64 0c26.5 0 48 21.5 48 48s-21.5 48-48 48l-64 0c-20.9 0-38.7-13.4-45.3-32L176 64c-26.5 0-48 21.5-48 48l0 48 280 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-12.2 0-22.7 261.5c-2.9 33.1-30.6 58.5-63.8 58.5l-170.6 0c-33.2 0-60.9-25.4-63.8-58.5L52.2 192 40 192c-8.8 0-16-7.2-16-16s7.2-16 16-16l56 0 0-48c0-44.2 35.8-80 80-80l2.7 0zM341.2 450.8l22.5-258.8-279.4 0 22.5 258.8c1.4 16.5 15.3 29.2 31.9 29.2l170.6 0c16.6 0 30.4-12.7 31.9-29.2z"]],
    "robot-astromech": [512, 512, [], "e2d2", ["M144 144c0-61.9 50.1-112 112-112S368 82.1 368 144l0 16-224 0 0-16zm48-48a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm96 16a16 16 0 1 0 32 0 16 16 0 1 0 -32 0z", "M256 0C176.5 0 112 64.5 112 144l0 16-16 0c-35.3 0-64 28.7-64 64l0 196.2-29.6 59.3C.8 482.6 0 486 0 489.5 0 501.9 10.1 512 22.5 512L128 512c8.8 0 16-7.2 16-16l0-89.4 36.7 36.7c3 3 7.1 4.7 11.3 4.7l128 0c4.2 0 8.3-1.7 11.3-4.7l36.7-36.7 0 89.4c0 8.8 7.2 16 16 16l105.5 0c12.4 0 22.5-10.1 22.5-22.5 0-3.5-.8-6.9-2.4-10L480 420.2 480 224c0-35.3-28.7-64-64-64l-16 0 0-16C400 64.5 335.5 0 256 0zM400 192l16 0c17.7 0 32 14.3 32 32l0 200c0 2.5 .6 4.9 1.7 7.2l24.4 48.8-74.1 0 0-288zm-32 0l0 169.4-54.6 54.6-114.7 0-54.6-54.6 0-169.4 224 0zm-256 0l0 288-74.1 0 24.4-48.8c1.1-2.2 1.7-4.7 1.7-7.2l0-200c0-17.7 14.3-32 32-32l16 0zm32-48c0-61.9 50.1-112 112-112S368 82.1 368 144l0 16-224 0 0-16zm80-16a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm80 0a16 16 0 1 0 0-32 16 16 0 1 0 0 32zM192 240c0 8.8 7.2 16 16 16l96 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-96 0c-8.8 0-16 7.2-16 16zm0 64c0 8.8 7.2 16 16 16l96 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-96 0c-8.8 0-16 7.2-16 16z"]],
    "heart-circle-exclamation": [576, 512, [], "e4fe", ["M32 165.1c0-55.9 45.3-101.1 101.1-101.1 32.4 0 62.9 15.6 81.9 41.9l28 38.7c3 4.2 7.8 6.6 13 6.6s10-2.5 13-6.6l28-38.7c19-26.3 49.5-41.9 81.9-41.9 55.9 0 101.1 45.3 101.1 101.1 0 16-2.9 31.7-7.9 47.1-12.9-2.7-26.3-4.2-40.1-4.2-106 0-192 86-192 192 0 16.1 2 31.8 5.7 46.8-5.1-1.2-9.6-3.4-13.4-6.3-35.1-26.8-86.4-71.7-128.5-122.9-37.3-45.4-71.8-97.5-71.8-152.5z", "M378.9 64c-32.4 0-62.9 15.6-81.9 41.9l-28 38.7c-3 4.2-7.8 6.6-13 6.6s-10-2.5-13-6.6l-28-38.7c-19-26.3-49.5-41.9-81.9-41.9-55.9 0-101.1 45.3-101.1 101.1 0 55 34.4 107.1 71.8 152.5 42.1 51.2 93.4 96 128.5 122.9 3.8 2.9 8.4 5.1 13.4 6.3 2.9 11.5 6.8 22.6 11.7 33.2-.5 0-.9 0-1.4 0-15.6 0-30.8-4.6-43.1-14.1-36.5-27.9-89.7-74.4-133.8-127.9-37.5-45.5-79.1-105.5-79.1-172.8 0-73.5 59.6-133.1 133.1-133.1 42.7 0 82.8 20.5 107.9 55.1l15 20.7 15-20.7c25-34.6 65.2-55.1 107.9-55.1 73.5 0 133.1 59.6 133.1 133.1 0 19.4-3.5 38.3-9.3 56.3-9.8-3.9-20.1-7-30.6-9.2 5-15.4 7.9-31.1 7.9-47.1 0-55.9-45.3-101.1-101.1-101.1zM544 400a112 112 0 1 0 -224 0 112 112 0 1 0 224 0zm-256 0a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm144 44a20 20 0 1 1 0 40 20 20 0 1 1 0-40zm0-124c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-64c0-8.8 7.2-16 16-16z"]],
    "building-circle-exclamation": [576, 512, [], "e4d3", ["M64 64c0-17.7 14.3-32 32-32l256 0c17.7 0 32 14.3 32 32l0 150c-30.2 7.8-57.5 22.7-80 42.9 0-.4 0-.7 0-.9l0-16c0-8.8-7.2-16-16-16l-16 0c-8.8 0-16 7.2-16 16l0 16c0 8.8 7.2 16 16 16l16 0c.2 0 .5 0 .9 0-20.2 22.6-35.2 50.1-43 80.4-2-.2-4-.4-6-.4l-32 0c-26.5 0-48 21.5-48 48l0 80-64 0c-17.7 0-32-14.3-32-32L64 64zm80 64l0 16c0 8.8 7.2 16 16 16l16 0c8.8 0 16-7.2 16-16l0-16c0-8.8-7.2-16-16-16l-16 0c-8.8 0-16 7.2-16 16zm0 112l0 16c0 8.8 7.2 16 16 16l16 0c8.8 0 16-7.2 16-16l0-16c0-8.8-7.2-16-16-16l-16 0c-8.8 0-16 7.2-16 16zM256 128l0 16c0 8.8 7.2 16 16 16l16 0c8.8 0 16-7.2 16-16l0-16c0-8.8-7.2-16-16-16l-16 0c-8.8 0-16 7.2-16 16z", "M352 32L96 32C78.3 32 64 46.3 64 64l0 384c0 17.7 14.3 32 32 32l64 0 0-80c0-26.5 21.5-48 48-48l32 0c2 0 4 .1 6 .4-2.6 10.2-4.4 20.8-5.3 31.6-.2 0-.4 0-.7 0l-32 0c-8.8 0-16 7.2-16 16l0 80 65.4 0c5.2 11.3 11.4 22 18.6 32L96 512c-35.3 0-64-28.7-64-64L32 64C32 28.7 60.7 0 96 0L352 0c35.3 0 64 28.7 64 64l0 144.7c-11 .9-21.6 2.7-32 5.4l0-150c0-17.7-14.3-32-32-32zM304 256.9c-5.3 4.7-10.3 9.8-15.1 15.1-.3 0-.6 0-.9 0l-16 0c-8.8 0-16-7.2-16-16l0-16c0-8.8 7.2-16 16-16l16 0c8.8 0 16 7.2 16 16l0 16c0 .3 0 .6 0 .9zM272 112l16 0c8.8 0 16 7.2 16 16l0 16c0 8.8-7.2 16-16 16l-16 0c-8.8 0-16-7.2-16-16l0-16c0-8.8 7.2-16 16-16zm-112 0l16 0c8.8 0 16 7.2 16 16l0 16c0 8.8-7.2 16-16 16l-16 0c-8.8 0-16-7.2-16-16l0-16c0-8.8 7.2-16 16-16zM144 240c0-8.8 7.2-16 16-16l16 0c8.8 0 16 7.2 16 16l0 16c0 8.8-7.2 16-16 16l-16 0c-8.8 0-16-7.2-16-16l0-16zM544 400a112 112 0 1 0 -224 0 112 112 0 1 0 224 0zm-256 0a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm144 44a20 20 0 1 1 0 40 20 20 0 1 1 0-40zm0-124c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-64c0-8.8 7.2-16 16-16z"]],
    "person-arrow-up-from-line": [576, 512, [], "e539", ["M144 156.7l0 179.3 96 0 0-179.3c-14.4-8.2-30.9-12.7-48-12.7s-33.6 4.5-48 12.7zM168 24a24 24 0 1 0 48 0 24 24 0 1 0 -48 0z", "M192 48a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm0-80a56 56 0 1 1 0 112 56 56 0 1 1 0-112zM112 186.1c-1.1 1.6-2.2 3.3-3.2 5L45.7 296.2c-4.5 7.6-14.4 10-22 5.5s-10-14.4-5.5-21.9L81.4 174.6C104.7 135.8 146.7 112 192 112s87.3 23.8 110.6 62.6l63.1 105.1c4.5 7.6 2.1 17.4-5.5 21.9s-17.4 2.1-22-5.5L275.2 191.1c-1-1.7-2.1-3.4-3.2-5l0 325.9 288 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L16 544c-8.8 0-16-7.2-16-16s7.2-16 16-16l96 0 0-325.9zM144 512l96 0 0-144-96 0 0 144zm96-355.3c-14.4-8.2-30.9-12.7-48-12.7s-33.6 4.5-48 12.7l0 179.3 96 0 0-179.3zM555.3 75.3c-6.2 6.2-16.4 6.2-22.6 0L480 22.6 480 192c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-169.4-52.7 52.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l80-80c6.2-6.2 16.4-6.2 22.6 0l80 80c6.2 6.2 6.2 16.4 0 22.6z"]],
    "circle-arrow-down-left": [512, 512, [], "e0f9", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm128-48c0-8.8 7.2-16 16-16s16 7.2 16 16l0 89.4 132.7-132.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6L214.6 320 304 320c8.8 0 16 7.2 16 16s-7.2 16-16 16l-128 0c-8.8 0-16-7.2-16-16l0-128z", "M256 32a224 224 0 1 0 0 448 224 224 0 1 0 0-448zm0 480a256 256 0 1 1 0-512 256 256 0 1 1 0 512zM192 208l0 89.4 132.7-132.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6L214.6 320 304 320c8.8 0 16 7.2 16 16s-7.2 16-16 16l-128 0c-8.8 0-16-7.2-16-16l0-128c0-8.8 7.2-16 16-16s16 7.2 16 16z"]],
    "not-equal": [448, 512, [], "f53e", ["", "M381.2 57.1c5-7.3 3.2-17.2-4-22.3s-17.2-3.2-22.3 4L293.2 128 16 128c-8.8 0-16 7.2-16 16s7.2 16 16 16l255 0-132.9 192-122.1 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l99.9 0-49.1 70.9c-5 7.3-3.2 17.2 4 22.3s17.2 3.2 22.3-4L154.8 384 432 384c8.8 0 16-7.2 16-16s-7.2-16-16-16l-255 0 132.9-192 122.1 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-99.9 0 49.1-70.9z"]],
    "binary-circle-check": [576, 512, [], "e33c", ["", "M384 16c0-4.9-2.3-9.6-6.2-12.6S368.9-.7 364.1 .5l-64 16c-8.6 2.1-13.8 10.8-11.6 19.4s10.8 13.8 19.4 11.6l44.1-11 0 155.5-48 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l51.1 0c23.5-10.3 49.5-16 76.9-16 5.4 0 10.7 .2 16 .7 0-.2 0-.4 0-.7 0-8.8-7.2-16-16-16l-48 0 0-176zM160 304c0-4.9-2.3-9.6-6.2-12.6s-8.9-4.1-13.7-2.9l-64 16c-8.6 2.1-13.8 10.8-11.6 19.4s10.8 13.8 19.4 11.6l44.1-11 0 155.5-48 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l128 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-48 0 0-176zM64 64l0 96c0 35.3 28.7 64 64 64l64 0c35.3 0 64-28.7 64-64l0-96c0-35.3-28.7-64-64-64L128 0C92.7 0 64 28.7 64 64zm64-32l64 0c17.7 0 32 14.3 32 32l0 96c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-96c0-17.7 14.3-32 32-32zM432 288a112 112 0 1 1 0 224 112 112 0 1 1 0-224zm0 256a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm57.4-204.9c-7.1-5.2-17.2-3.6-22.4 3.5l-53 72.9-26.8-26.8c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l40 40c3.3 3.3 7.9 5 12.6 4.6s8.9-2.8 11.7-6.5l64-88c5.2-7.1 3.6-17.2-3.5-22.4z"]],
    "train-tram": [384, 512, [128650], "e5b4", ["M64 288l0 64c0 35.3 28.7 64 64 64l128 0c35.3 0 64-28.7 64-64l0-64-256 0zm88 64a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm128 0a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M0 0C0-8.8 7.2-16 16-16l352 0c8.8 0 16 7.2 16 16l0 48c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-32-144 0 0 80 48 0c53 0 96 43 96 96l0 160c0 33.5-17.1 62.9-43.1 80.1l71.4 85.6c5.7 6.8 4.7 16.9-2 22.5s-16.9 4.7-22.5-2l-77.4-92.9c-7.2 1.7-14.6 2.6-22.3 2.6l-128 0c-7.7 0-15.2-.9-22.3-2.6L28.3 538.2c-5.7 6.8-15.7 7.7-22.5 2s-7.7-15.7-2-22.5l71.4-85.6C49.1 414.9 32 385.5 32 352l0-160c0-53 43-96 96-96l48 0 0-80-144 0 0 32c0 8.8-7.2 16-16 16S0 56.8 0 48L0 0zM256 128l-128 0c-35.3 0-64 28.7-64 64l0 64 256 0 0-64c0-35.3-28.7-64-64-64zm64 160l-256 0 0 64c0 35.3 28.7 64 64 64l128 0c35.3 0 64-28.7 64-64l0-64zM104 352a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm152-24a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]],
    "plane-departure": [640, 512, [128747], "f5b0", ["M53 249.5l53.6 91.8c11.7 20 36.1 28.8 57.9 20.9 13.3-4.8 21.6-7.9 25-9.1L557.8 219c16.6-6 25.2-24.4 19.1-41s-24.4-25.2-41-19.1L430.7 197.1c-4.2 1.5-8.9 1.2-12.9-.8l-224.8-117-47.7 17.4 112 141.1c3.2 4 4.3 9.3 2.9 14.3s-5.1 8.9-9.9 10.7l-82.7 30.1c-4.6 1.7-9.6 1.2-13.8-1.4L72.9 242.2 53 249.5z", "M535.9 158.8c16.6-6 35 2.5 41 19.1s-2.5 35-19.1 41L189.5 353c-3.4 1.2-11.7 4.3-25 9.1-21.8 7.9-46.2-.9-57.9-20.9l-53.6-91.8 19.9-7.2 80.9 49.3c4.2 2.5 9.2 3 13.8 1.4l82.7-30.1c4.8-1.8 8.5-5.7 9.9-10.7s.3-10.3-2.9-14.3l-112-141.1 47.7-17.4 224.8 117c4 2.1 8.6 2.4 12.9 .8l105.2-38.3zM607 167c-12.1-33.2-48.8-50.3-82-38.3l-98.6 35.9-224.8-117c-4-2.1-8.6-2.4-12.9-.8L113.5 74.2c-4.8 1.8-8.5 5.7-9.9 10.7s-.3 10.3 2.9 14.3l112 141.1-54.6 19.9-80.9-49.3c-4.2-2.5-9.2-3-13.8-1.4L24 226c-4.5 1.6-8 5.1-9.6 9.6s-1.2 9.4 1.2 13.5L79 357.4c19.5 33.4 60.1 48 96.4 34.8 13.3-4.8 21.6-7.9 25-9.1L568.8 249c33.2-12.1 50.3-48.8 38.2-82zM48.2 480c-8.8 0-16 7.2-16 16s7.2 16 16 16l544 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-544 0z"]],
    "microphone-stand": [512, 512, [127908], "f8cb", ["M60.8 379.4c-11.5 12.6-11.1 32.1 1 44.2l26.6 26.7c12.1 12.1 31.6 12.6 44.2 1l178.6-163.1-87.4-87.4-163 178.6zM244 166.1l.1 11.4 .8-.8 90.5 90.5-.8 .8 11.4 .1c20.7 .2 41.4-7.6 57.2-23.4l11.4-11.4-135.8-135.8-11.4 11.4c-15.8 15.8-23.6 36.5-23.4 57.2zm57.5-91.3L437.2 210.6c37.4-37.5 37.3-98.2-.1-135.6S339 37.5 301.5 74.8z", "M223.8 200.9l87.4 87.4-178.6 163.1c-12.6 11.5-32.1 11.1-44.2-1L61.8 423.6c-12.1-12.1-12.5-31.6-1-44.2l163-178.6zM334.6 268l.8-.8-90.5-90.5-.8 .8-.1-11.4c-.2-20.7 7.6-41.4 23.4-57.2l11.4-11.4 135.8 135.8-11.4 11.4c-15.8 15.8-36.5 23.6-57.2 23.4l-11.4-.1zM437.1 75c37.4 37.4 37.5 98.1 .1 135.6L301.5 74.8C339 37.5 399.7 37.5 437.1 75zm22.6-22.6c-50-50-131-50-181 0L244.8 86.3c-22.1 22.1-33 51.1-32.8 80.1L37.2 357.8c-23.1 25.2-22.2 64.2 2 88.4l26.6 26.7c24.2 24.2 63.2 25.2 88.5 2.1l85.9-78.4 0 131.5c0 8.8 7.2 16 16 16s16-7.2 16-16l0-160.7 73.6-67.2c29 .2 58-10.7 80.1-32.8l33.9-33.9c50-50 50-131 0-181z"]],
    "shop-24": [640, 512, [], "e79a", ["M48 204.2c0 10.9 8.9 19.8 19.8 19.8l440.4 0c10.9 0 19.8-8.9 19.8-19.8 0-3.1-.7-6.1-2.1-8.8L469.1 81.7C463.6 70.8 452.6 64 440.4 64L135.6 64c-12.1 0-23.2 6.8-28.6 17.7L50.1 195.4c-1.4 2.7-2.1 5.8-2.1 8.8zM96 384l0 48c0 8.8 7.2 16 16 16l192 0 0-64-208 0z", "M50.1 195.4c-1.4 2.7-2.1 5.8-2.1 8.8 0 10.9 8.9 19.8 19.8 19.8l440.4 0c10.9 0 19.8-8.9 19.8-19.8 0-3.1-.7-6.1-2.1-8.8L469.1 81.7C463.6 70.8 452.6 64 440.4 64L135.6 64c-12.1 0-23.2 6.8-28.6 17.7L50.1 195.4zM64 255.9c-26.8-1.9-48-24.3-48-51.6 0-8 1.9-16 5.5-23.2L78.3 67.4C89.2 45.7 111.3 32 135.6 32l304.9 0c24.2 0 46.4 13.7 57.2 35.4l56.8 113.7c3.6 7.2 5.5 15.1 5.5 23.2 0 27.3-21.2 49.7-48 51.6l0 48.1-32 0 0-48-128 0 0 50c-12.6 3.2-23.7 10.2-32 19.7l0-69.7-224 0 0 96 210 0c-1.3 5.1-2 10.5-2 16l0 16-208 0 0 48c0 8.8 7.2 16 16 16l192 0 0 32-192 0c-26.5 0-48-21.5-48-48l0-176.1zM352 400c0-26.5 21.5-48 48-48s48 21.5 48 48l0 1c0 13.6-5 26.7-14 36.9L396.5 480 432 480c8.8 0 16 7.2 16 16s-7.2 16-16 16l-58.2 0c-12 0-21.8-9.8-21.8-21.8 0-5.3 2-10.5 5.5-14.5l52.5-59.1c3.8-4.3 5.9-9.9 5.9-15.6l0-1c0-8.8-7.2-16-16-16s-16 7.2-16 16-7.2 16-16 16-16-7.2-16-16zm128 32l0-64c0-8.8 7.2-16 16-16s16 7.2 16 16l0 48 32 0 0-48c0-8.8 7.2-16 16-16s16 7.2 16 16l0 128c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-48-48 0c-4.2 0-8.3-1.7-11.3-4.7S480 436.2 480 432z"]],
    "brightness": [512, 512, [], "e0c9", ["M192 256a64 64 0 1 0 128 0 64 64 0 1 0 -128 0z", "M240 104c0 8.8 7.2 16 16 16s16-7.2 16-16l0-88c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 88zm16 88a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm0 160a96 96 0 1 0 0-192 96 96 0 1 0 0 192zm0 160c8.8 0 16-7.2 16-16l0-80c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 80c0 8.8 7.2 16 16 16zM0 256c0 8.8 7.2 16 16 16l80 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-80 0c-8.8 0-16 7.2-16 16zm408-16c-8.8 0-16 7.2-16 16s7.2 16 16 16l88 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-88 0zM75 437c6.2 6.2 16.4 6.2 22.6 0l56.6-56.6c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0L75 414.4c-6.2 6.2-6.2 16.4 0 22.6zM352.2 137.2c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0L437 97.6c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-62.2 62.2zM75 75c-6.2 6.2-6.2 16.4 0 22.6l56.6 56.6c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L97.6 75c-6.2-6.2-16.4-6.2-22.6 0zM374.8 352.2c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6L414.4 437c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-62.2-62.2z"]],
    "right-to-bracket": [512, 512, ["sign-in-alt"], "f2f6", ["M32 240l0 32c0 8.8 7.2 16 16 16l128 0c8.8 0 16 7.2 16 16L192 380.7 316.7 256 192 131.3 192 208c0 8.8-7.2 16-16 16L48 224c-8.8 0-16 7.2-16 16z", "M201 95L345 239c9.4 9.4 9.4 24.6 0 33.9L201 417c-6.9 6.9-17.2 8.9-26.2 5.2S160 409.7 160 400l0-80-112 0c-26.5 0-48-21.5-48-48l0-32c0-26.5 21.5-48 48-48l112 0 0-80c0-9.7 5.8-18.5 14.8-22.2S194.1 88.2 201 95zm-9 285.7L316.7 256 192 131.3 192 208c0 8.8-7.2 16-16 16L48 224c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l128 0c8.8 0 16 7.2 16 16l0 76.7zM336 448l80 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64l-80 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l80 0c53 0 96 43 96 96l0 256c0 53-43 96-96 96l-80 0c-8.8 0-16-7.2-16-16s7.2-16 16-16z"]],
    "sd-card": [384, 512, [], "f7c2", ["M32 122.5L32 448c0 17.7 14.3 32 32 32l256 0c17.7 0 32-14.3 32-32l0-384c0-17.7-14.3-32-32-32L122.5 32c-8.5 0-16.6 3.4-22.6 9.4L41.4 99.9c-6 6-9.4 14.1-9.4 22.6zM112 96c0-8.8 7.2-16 16-16s16 7.2 16 16l0 64c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-64zm80 0c0-8.8 7.2-16 16-16s16 7.2 16 16l0 64c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-64zm80 0c0-8.8 7.2-16 16-16s16 7.2 16 16l0 64c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-64z", "M41.4 99.9c-6 6-9.4 14.1-9.4 22.6L32 448c0 17.7 14.3 32 32 32l256 0c17.7 0 32-14.3 32-32l0-384c0-17.7-14.3-32-32-32L122.5 32c-8.5 0-16.6 3.4-22.6 9.4L41.4 99.9zM18.7 77.3L77.3 18.7C89.3 6.7 105.5 0 122.5 0L320 0c35.3 0 64 28.7 64 64l0 384c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 122.5c0-17 6.7-33.3 18.7-45.3zM144 96l0 64c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-64c0-8.8 7.2-16 16-16s16 7.2 16 16zm80 0l0 64c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-64c0-8.8 7.2-16 16-16s16 7.2 16 16zm80 0l0 64c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-64c0-8.8 7.2-16 16-16s16 7.2 16 16z"]],
    "dot": [128, 512, [], "e7d1", ["M32 256c0 17.7 14.3 32 32 32s32-14.3 32-32-14.3-32-32-32-32 14.3-32 32z", "M64 192c35.3 0 64 28.7 64 64s-28.7 64-64 64-64-28.7-64-64 28.7-64 64-64zm0 32c-17.7 0-32 14.3-32 32s14.3 32 32 32 32-14.3 32-32-14.3-32-32-32z"]],
    "house-circle-exclamation": [640, 512, [], "e50a", ["M112 202.2L288 37.9 471.9 209.5c-62.6 7.8-115.7 45.8-144.6 98.9-7.2-2.8-15-4.4-23.2-4.4l-32 0c-35.3 0-64 28.7-64 64l0 112-64 0c-17.7 0-32-14.3-32-32l0-245.8z", "M277.1 4.3c6.1-5.7 15.7-5.7 21.8 0l219.7 205c-7.4-.9-14.9-1.3-22.6-1.3-8.2 0-16.2 .5-24.1 1.5L288 37.9 112 202.2 112 448c0 17.7 14.3 32 32 32l64 0 0-112c0-35.3 28.7-64 64-64l32 0c8.2 0 16 1.5 23.2 4.4-5.1 9.3-9.4 19.2-12.9 29.4-3.2-1.1-6.7-1.7-10.3-1.7l-32 0c-17.7 0-32 14.3-32 32l0 112 81.4 0c5.2 11.3 11.4 22 18.6 32l-196 0c-35.3 0-64-28.7-64-64l0-216-21.1 19.7c-6.5 6-16.6 5.7-22.6-.8s-5.7-16.6 .8-22.6l240-224zM608 400a112 112 0 1 0 -224 0 112 112 0 1 0 224 0zm-256 0a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm144 44a20 20 0 1 1 0 40 20 20 0 1 1 0-40zm0-124c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-64c0-8.8 7.2-16 16-16z"]],
    "shekel-sign": [384, 512, [8362, "ils", "shekel", "sheqel", "sheqel-sign"], "f20b", ["", "M48 32C21.5 32 0 53.5 0 80L0 464c0 8.8 7.2 16 16 16s16-7.2 16-16L32 80c0-8.8 7.2-16 16-16l112 0c44.2 0 80 35.8 80 80l0 192c0 8.8 7.2 16 16 16s16-7.2 16-16l0-192c0-61.9-50.1-112-112-112L48 32zM272 480c61.9 0 112-50.1 112-112l0-320c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 320c0 44.2-35.8 80-80 80l-112 0c-8.8 0-16-7.2-16-16l0-256c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 256c0 26.5 21.5 48 48 48l112 0z"]],
    "square-u": [448, 512, [], "e281", ["M32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64C46.3 64 32 78.3 32 96zm112 80c0-8.8 7.2-16 16-16s16 7.2 16 16l0 96c0 26.5 21.5 48 48 48s48-21.5 48-48l0-96c0-8.8 7.2-16 16-16s16 7.2 16 16l0 96c0 44.2-35.8 80-80 80s-80-35.8-80-80l0-96z", "M64 64C46.3 64 32 78.3 32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm176 80l0 96c0 26.5 21.5 48 48 48s48-21.5 48-48l0-96c0-8.8 7.2-16 16-16s16 7.2 16 16l0 96c0 44.2-35.8 80-80 80s-80-35.8-80-80l0-96c0-8.8 7.2-16 16-16s16 7.2 16 16z"]],
    "truck-container-empty": [640, 512, [], "e2b5", ["M480 288l0 51.3c7.6-2.2 15.7-3.3 24-3.3 44.6 0 81.4 33.2 87.2 76.2 10-5.4 16.8-16 16.8-28.2l0-96-128 0z", "M464 128c-8.8 0-16 7.2-16 16l0 212.1c-17.6 14.5-29.5 35.8-31.6 59.9l-96.7 0c-4-44.9-41.7-80-87.6-80-29.8 0-56.1 14.8-72 37.4-15.9-22.6-42.2-37.4-72-37.4-48.6 0-88 39.4-88 88s39.4 88 88 88c29.8 0 56.1-14.8 72-37.4 15.9 22.6 42.2 37.4 72 37.4 40.3 0 74.2-27.1 84.7-64l102.6 0c10.4 36.9 44.4 64 84.7 64 40.8 0 75.1-27.7 85.1-65.3 29.1-6 50.9-31.8 50.9-62.7l0-156.1c0-17-6.7-33.3-18.7-45.3l-35.9-35.9c-12-12-28.3-18.7-45.3-18.7L464 128zm40 240a56 56 0 1 1 0 112 56 56 0 1 1 0-112zm87.2 44.2c-5.8-43-42.6-76.2-87.2-76.2-8.3 0-16.4 1.2-24 3.3l0-51.3 128 0 0 96c0 12.2-6.8 22.7-16.8 28.2zM480 256l0-96 60.1 0c8.5 0 16.6 3.4 22.6 9.4l35.9 35.9c6 6 9.4 14.1 9.4 22.6l0 28.1-128 0zM32 424a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm256 0a56 56 0 1 1 -112 0 56 56 0 1 1 112 0z"]],
    "user-pilot-tie": [448, 512, [], "e2c1", ["M16 512c8.8 0 16-7.2 16-16l0-16c0-54.4 30.1-101.7 74.7-126.2L210.8 505.1c3 4.3 7.9 6.9 13.2 6.9L16 512zM80 43.6c0-1.8 1.2-3.5 3-3.9L224 1.2 365 39.6c1.8 .5 3 2.1 3 3.9 0 1.4-.8 2.8-2 3.5l-14.5 8.7C341.9 61.5 336 72 336 83.2l0 7.3C312 99.3 269.5 112 224 112S136 99.3 112 90.5l0-7.3c0-11.2-5.9-21.7-15.5-27.4L82 47.1c-1.2-.7-2-2.1-2-3.5zm81.7-2.7c-4 7.9-.7 17.5 7.2 21.5l48 24c4.5 2.3 9.8 2.3 14.3 0l48-24c7.9-4 11.1-13.6 7.2-21.5s-13.6-11.1-21.5-7.2L224 54.1 183.2 33.7c-7.9-4-17.5-.7-21.5 7.2zm29.9 379.8l32.4-64.9 32.4 64.9-32.4 47.1-32.4-47.1zM224 512c5.3 0 10.2-2.6 13.2-6.9L341.3 353.8C385.9 378.3 416 425.6 416 480l0 16c0 8.8 7.2 16 16 16l-208 0zm80-48c0 8.8 7.2 16 16 16l48 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-48 0c-8.8 0-16 7.2-16 16z", "M336 83.2l0 7.3C312 99.3 269.5 112 224 112S136 99.3 112 90.5l0-7.3c0-11.2-5.9-21.7-15.5-27.4L82 47.1c-1.2-.7-2-2.1-2-3.5 0-1.8 1.2-3.5 3-3.9L224 1.2 365 39.6c1.8 .5 3 2.1 3 3.9 0 1.4-.8 2.8-2 3.5l-14.5 8.7C341.9 61.5 336 72 336 83.2zm32 0l14.5-8.7C393.3 68 400 56.2 400 43.6 400 27.3 389.1 13 373.4 8.7l-141-38.5c-5.5-1.5-11.3-1.5-16.8 0L74.6 8.7C58.9 13 48 27.3 48 43.6 48 56.2 54.7 68 65.5 74.5l14.5 8.7 0 8.6c0 11.4 6 21.8 16 26.7L96 144c0 70.7 57.3 128 128 128s128-57.3 128-128l0-25.5c10-5 16-15.4 16-26.7l0-8.6zM128 144l0-14.6c25.9 7.5 59.9 14.6 96 14.6s70.1-7.1 96-14.6l0 14.6c0 53-43 96-96 96s-96-43-96-96zm48 176c0 8.8 7.2 16 16 16l6.1 0-27.3 54.6-45.7-66.3c-4.3-6.3-12.6-8.7-19.6-5.6-62.1 27.1-105.6 89.2-105.6 161.4l0 16c0 8.8 7.2 16 16 16s16-7.2 16-16l0-16c0-54.4 30.1-101.7 74.7-126.2L210.8 505.1c3 4.3 7.9 6.9 13.2 6.9s10.2-2.6 13.2-6.9L341.3 353.8C385.9 378.3 416 425.6 416 480l0 16c0 8.8 7.2 16 16 16s16-7.2 16-16l0-16c0-72.2-43.5-134.2-105.6-161.4-7-3.1-15.2-.7-19.6 5.6l-45.7 66.3-27.3-54.6 6.1 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-64 0c-8.8 0-16 7.2-16 16zm48 147.8l-32.4-47.1 32.4-64.9 32.4 64.9-32.4 47.1zm80-3.8c0 8.8 7.2 16 16 16l48 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-48 0c-8.8 0-16 7.2-16 16zM183.2 33.7c-7.9-4-17.5-.7-21.5 7.2s-.7 17.5 7.2 21.5l48 24c4.5 2.3 9.8 2.3 14.3 0l48-24c7.9-4 11.1-13.6 7.2-21.5s-13.6-11.1-21.5-7.2L224 54.1 183.2 33.7z"]],
    "radio": [512, 512, [128251], "f8d7", ["M32 162.3L32 416c0 17.7 14.3 32 32 32l384 0c17.7 0 32-14.3 32-32l0-256c0-17.7-14.3-32-32-32L64 128c-10.9 0-20.6 5.5-26.3 13.8-3.6 6.1-5.7 13.1-5.7 20.5zM80 240c0-8.8 7.2-16 16-16l96 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16zm0 96c0-8.8 7.2-16 16-16l96 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16zm368-48a96 96 0 1 1 -192 0 96 96 0 1 1 192 0z", "M500.4-.6c8.5-2.4 13.4-11.3 11-19.8s-11.3-13.4-19.8-11L52.4 93.1C34.6 98.1 20 109.5 10.8 124.4 4 134.6 0 146.8 0 160L0 416c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L159.4 96 500.4-.6zM32 272l0-109.7c0-7.4 2-14.5 5.7-20.5 5.8-8.3 15.4-13.8 26.3-13.8l384 0c17.7 0 32 14.3 32 32l0 256c0 17.7-14.3 32-32 32L64 448c-17.7 0-32-14.3-32-32l0-144zm384 16a64 64 0 1 1 -128 0 64 64 0 1 1 128 0zm-64-96a96 96 0 1 0 0 192 96 96 0 1 0 0-192zM96 224c-8.8 0-16 7.2-16 16s7.2 16 16 16l96 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-96 0zm0 96c-8.8 0-16 7.2-16 16s7.2 16 16 16l96 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-96 0z"]],
    "hand-dots": [512, 512, ["allergies"], "f461", ["M39 279c-9.4 9.4-9.4 24.6 0 33.9L142.8 416.7c40.5 40.5 95.4 63.3 152.7 63.3l8.5 0c79.5 0 144-64.5 144-144l0-184c0-13.3-10.7-24-24-24-13.2 0-24 10.7-24 23.9l0 88.1c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-152c0-13.3-10.7-24-24-24-13.2 0-24 10.7-24 23.9L320 240c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-184c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 184c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-151.9C208 74.7 197.3 64 184 64s-24 10.7-24 24l0 239.4c0 6.5-3.9 12.3-9.9 14.8s-12.9 1.1-17.4-3.5L73 279c-9.4-9.4-24.6-9.4-33.9 0zm209 73a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm64 64a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm16-112a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm64 64a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M264 0c-24.9 0-46 16.3-53.3 38.8-7.9-4.3-17-6.8-26.7-6.8-30.9 0-56 25.1-56 56l0 200.8-32.4-32.4c-21.9-21.9-57.3-21.9-79.2 0s-21.9 57.3 0 79.2L120.2 439.4C166.7 485.9 229.8 512 295.5 512l8.5 0c97.2 0 176-78.8 176-176l0-184c0-30.9-25.1-56-56-56-8.6 0-16.7 1.9-24 5.4L400 88c0-30.9-25.1-56-56-56-9.7 0-18.8 2.5-26.7 6.8-7.3-22.5-28.4-38.8-53.3-38.8zM184 64c13.3 0 24 10.7 24 24l0 152c0 8.8 7.2 16 16 16s16-7.2 16-16l0-184c0-13.3 10.7-24 24-24s24 10.7 24 24l0 184c0 8.8 7.2 16 16 16s16-7.2 16-16l0-152.1c0-13.2 10.8-23.9 24-23.9 13.3 0 24 10.7 24 24l0 152c0 8.8 7.2 16 16 16s16-7.2 16-16l0-88.1c0-13.2 10.8-23.9 24-23.9 13.3 0 24 10.7 24 24l0 184c0 79.5-64.5 144-144 144l-8.5 0c-57.3 0-112.2-22.8-152.7-63.3L39 313c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l59.7 59.7c4.6 4.6 11.5 5.9 17.4 3.5s9.9-8.3 9.9-14.8L160 88c0-13.3 10.7-24 24-24zm64 288a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm56-24a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm88 40a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM288 440a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]],
    "pencil-line": [576, 512, [], "e74f", ["M93 326.3L185.7 419 387 217.7 294.3 125 93 326.3z", "M375.5 43.8C383.1 36.2 393.3 32 404 32s20.9 4.2 28.5 11.8l35.7 35.7C475.8 87.1 480 97.3 480 108s-4.2 20.9-11.8 28.5L409.7 195 317 102.3 375.5 43.8zM294.3 125L387 217.7 185.7 419 93 326.3 294.3 125zM67.2 362.4c1.1-4.1 2.7-8.1 4.8-11.8L161.4 440c-3.7 2-7.7 3.6-11.8 4.8L35.5 476.5 67.2 362.4zM404 0c-19.2 0-37.6 7.6-51.1 21.2l-294 294c-10.7 10.7-18.5 24.1-22.6 38.7L.9 481.6c-2.3 8.3 0 17.3 6.2 23.4s15.1 8.5 23.4 6.2l127.8-35.5c14.6-4.1 27.9-11.8 38.7-22.6l294-294C504.4 145.6 512 127.2 512 108s-7.6-37.6-21.2-51.1L455.1 21.2C441.6 7.6 423.2 0 404 0zM272 480c-8.8 0-16 7.2-16 16s7.2 16 16 16l288 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-288 0z"]],
    "hand-shaka": [576, 512, [], "e831", ["M57.9 84L76 141.2c2.7 8.5 4.1 17.5 4.1 26.5l0 119C80 393.4 166.6 480 273.4 480l9.6-.2c47.8-2.4 93.1-22.4 127.1-56.4L519.5 314c5.5-5.5 8.6-13 8.6-20.7 0-15.1-11.5-27.5-26.2-29.1l-3-.2c-7.8 0-15.2 3.1-20.7 8.6-69.4 69.3-111.2 111.1-125.5 125.5-11.5 11.5-27.1 17.9-43.3 17.9-30.4 0-55.6-22.2-60.4-51.3-6.3 2.1-12.9 3.3-19.6 3.3-33.8 0-61.2-27.4-61.3-61.3 0-6.7 1.2-13.4 3.3-19.6-29.1-4.8-51.3-29.9-51.3-60.4 0-16.2 6.5-31.8 17.9-43.3l22-22c-.6-15-3.1-30-7.7-44.3L134.2 59.9C127.5 38.9 105 27.2 84 33.8 62.9 40.5 51.2 63 57.9 84zM152 226.7c0 16.1 13.1 29.2 29.3 29.2 7.8 0 15.2-3.1 20.7-8.6l37.5-37.5c5.5-5.5 8.6-12.9 8.6-20.7 0-16.1-13.1-29.3-29.2-29.3-7.8 0-15.2 3.1-20.7 8.6L160.6 206c-5.5 5.5-8.6 12.9-8.6 20.7zm48 80c0 16.1 13.1 29.2 29.3 29.3 7.8 0 15.2-3.1 20.7-8.6l53.5-53.5c5.5-5.5 8.6-12.9 8.6-20.7 0-16.1-13.1-29.3-29.3-29.3-7.8 0-15.2 3.1-20.7 8.6L208.6 286c-5.5 5.5-8.6 12.9-8.6 20.7zm80 48c0 16.1 13.1 29.2 29.3 29.3 7.8 0 15.2-3.1 20.7-8.6l37.5-37.5c5.5-5.5 8.6-12.9 8.6-20.7 0-16.1-13.1-29.2-29.3-29.2-7.8 0-15.2 3.1-20.7 8.6L288.6 334c-5.5 5.5-8.6 12.9-8.6 20.7z", "M74.4 3.3c37.9-11.9 78.4 9.1 90.3 47l18.1 57.2c2.9 9.2 5.1 18.5 6.6 28 8.9-4.9 19-7.5 29.4-7.5 33.8 0 61.2 27.4 61.2 61.3 0 1-.1 1.9-.2 2.9 1 0 1.9-.1 2.9-.1 33.8 0 61.2 27.4 61.3 61.3 0 1-.1 1.9-.2 2.9 1 0 1.9-.1 2.9-.1 27.8 0 51.2 18.5 58.7 43.9l50-49.9c11.5-11.5 27.1-17.9 43.3-17.9 33.8 0 61.2 27.4 61.3 61.2 0 16.2-6.4 31.8-17.9 43.3L432.7 446c-39.6 39.6-92.5 62.9-148.1 65.7l-11.2 .3C148.9 512 48 411.1 48 286.7l0-119c0-5.7-.9-11.4-2.6-16.8L27.4 93.7c-12-37.9 9.1-78.4 47-90.3zm59.8 56.6C127.5 38.9 105 27.2 84 33.8 62.9 40.5 51.2 63 57.9 84L76 141.2c2.7 8.5 4.1 17.5 4.1 26.5l0 119C80 393.4 166.6 480 273.4 480l9.6-.2c47.8-2.4 93.1-22.4 127.1-56.4L519.5 314c5.5-5.5 8.6-13 8.6-20.7 0-15.1-11.5-27.5-26.2-29.1l-3-.2c-7.8 0-15.2 3.1-20.7 8.6-69.4 69.3-111.2 111.1-125.5 125.5-11.5 11.5-27.1 17.9-43.3 17.9-30.4 0-55.6-22.2-60.4-51.3-6.3 2.1-12.9 3.3-19.6 3.3-33.8 0-61.2-27.4-61.3-61.3 0-6.7 1.2-13.4 3.3-19.6-29.1-4.8-51.3-29.9-51.3-60.4 0-16.2 6.5-31.8 17.9-43.3l22-22c-.6-15-3.1-30-7.7-44.3L134.2 59.9zM346.8 288c-7.8 0-15.2 3.1-20.7 8.6L288.6 334c-5.5 5.5-8.6 12.9-8.6 20.7 0 16.1 13.1 29.2 29.3 29.3 7.8 0 15.2-3.1 20.7-8.6l37.5-37.5c5.5-5.5 8.6-12.9 8.6-20.7 0-16.1-13.1-29.2-29.3-29.2zm-64-64c-7.8 0-15.2 3.1-20.7 8.6L208.6 286c-5.5 5.5-8.6 12.9-8.6 20.7 0 16.1 13.1 29.2 29.3 29.3 7.8 0 15.2-3.1 20.7-8.6l53.5-53.5c5.5-5.5 8.6-12.9 8.6-20.7 0-16.1-13.1-29.3-29.3-29.3zm-64-64c-7.8 0-15.2 3.1-20.7 8.6L160.6 206c-5.5 5.5-8.6 12.9-8.6 20.7 0 16.1 13.1 29.2 29.3 29.2 7.8 0 15.2-3.1 20.7-8.6l37.5-37.5c5.5-5.5 8.6-12.9 8.6-20.7 0-16.1-13.1-29.3-29.2-29.3z"]],
    "flask-gear": [576, 512, [], "e5f1", ["M32 458.1c0-3.8 1-7.6 2.9-10.9l54.4-95.2 128.8 0c2.8 11.6 8.4 22.5 16.6 31.5-20.2 22.3-24.8 55.8-9.4 83.4l7.3 13.1-178.6 0C41.8 480 32 470.2 32 458.1z", "M112 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l16 0 0 187.8-61.8 108.1c-.1 .2-.2 .3-.3 .5L7.1 431.3C2.4 439.5 0 448.7 0 458.1 0 487.9 24.1 512 53.9 512l196.7 0c-1-1.5-2-3.1-2.9-4.7L232.6 480 53.9 480c-12.1 0-21.9-9.8-21.9-21.9 0-3.8 1-7.6 2.9-10.9l54.4-95.2 128.8 0c-2.5-10.4-2.7-21.3-.4-32l-110.2 0 50.3-88.1c1.4-2.4 2.1-5.2 2.1-7.9l0-192 128 0 0 184 32 0 0-184 16 0c8.8 0 16-7.2 16-16S344.8 0 336 0L112 0zM392.2 255.6l48 0 0 10.6c0 16.6 9.3 30.4 21.9 37.7 12.7 7.4 29.4 8.5 43.7 .2l9.2-5.3 24 41.6-9.3 5.4C515.4 354 508 369 508 383.6s7.4 29.6 21.7 37.8l9.3 5.4-24 41.6-9.2-5.3c-14.3-8.3-31-7.2-43.7 .2-12.6 7.3-21.9 21.1-21.9 37.7l0 10.6-48 0 0-10.4c0-16.7-9.4-30.6-22.1-37.9-12.7-7.3-29.4-8.5-43.8-.2l-9 5.2-24-41.6 8.9-5.1c14.4-8.3 21.8-23.4 21.8-38.1s-7.4-29.8-21.8-38.1l-8.9-5.1 24-41.6 9 5.2c14.4 8.3 31.1 7.2 43.8-.2 12.7-7.3 22.1-21.2 22.1-37.9l0-10.4zm-8-32c-13.3 0-24 10.7-24 24l0 18.4c0 4.2-2.4 8-6.1 10.2s-8.2 2.3-11.8 .2l-15.9-9.2c-11.5-6.6-26.2-2.7-32.8 8.8l-32 55.4c-6.6 11.5-2.7 26.2 8.8 32.8l15.8 9.1c3.7 2.1 5.8 6.1 5.8 10.4s-2.1 8.2-5.8 10.4l-15.8 9.1c-11.5 6.6-15.4 21.3-8.8 32.8l32 55.4c6.6 11.5 21.3 15.4 32.8 8.8l15.9-9.2c3.7-2.1 8.2-2 11.8 .2s6.1 5.9 6.1 10.2l0 18.4c0 13.3 10.7 24 24 24l64 0c13.3 0 24-10.7 24-24l0-18.6c0-4.2 2.4-7.9 6-10 3.6-2.1 8.1-2.3 11.7-.2l16.1 9.3c11.5 6.6 26.2 2.7 32.8-8.8l32-55.4c6.6-11.5 2.7-26.2-8.8-32.8l-16.3-9.4c-3.6-2.1-5.7-6-5.7-10.1s2.1-8 5.7-10.1l16.3-9.4c11.5-6.6 15.4-21.3 8.8-32.8l-32-55.4c-6.6-11.5-21.3-15.4-32.8-8.8l-16.1 9.3c-3.6 2.1-8.1 1.9-11.7-.2-3.6-2.1-6-5.9-6-10l0-18.6c0-13.3-10.7-24-24-24l-64 0zM472 383.8a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zm-56-24a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]],
    "book-skull": [448, 512, ["book-dead"], "f6b7", ["M32 64l0 328.6c9.4-5.4 20.3-8.6 32-8.6l336 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 32C46.3 32 32 46.3 32 64zm89.4 185.4c3.7-8 13.1-11.6 21.2-7.9l81.4 37 81.4-37c8-3.7 17.5-.1 21.2 7.9s.1 17.5-7.9 21.2l-56 25.4 56 25.4c8 3.7 11.6 13.1 7.9 21.2s-13.1 11.6-21.2 7.9l-81.4-37-81.4 37c-8 3.7-17.5 .1-21.2-7.9s-.1-17.5 7.9-21.2l56-25.4-56-25.4c-8-3.7-11.6-13.1-7.9-21.2zM128 144c0-47.3 46.5-80 96-80 48.6 0 94.2 31.4 95.9 77.3 .1 1.8 .1 3.6 0 5.4-1.1 27.3-18.2 49.9-41.5 63.2-4.2 12.8-16.2 22-30.4 22l-48 0c-14.2 0-26.2-9.2-30.4-22-24.1-13.8-41.6-37.4-41.6-66z", "M0 64C0 28.7 28.7 0 64 0L400 0c26.5 0 48 21.5 48 48l0 320c0 20.9-13.4 38.7-32 45.3l0 66.7 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L64 512c-35.3 0-64-28.7-64-64l0 0 0-384zM64 416c-17.7 0-32 14.3-32 32s14.3 32 32 32l320 0 0-64-320 0zM32 392.6c9.4-5.4 20.3-8.6 32-8.6l336 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 32C46.3 32 32 46.3 32 64l0 328.6zM224 96c-38.9 0-64 24.6-64 48 0 15.9 10.9 31.7 30.7 40.9 5.7 2.6 9.3 8.3 9.3 14.5l0 .6 48 0 0-.6c0-6.2 3.6-11.9 9.3-14.5 19.9-9.2 30.7-25.1 30.7-40.9 0-23.4-25.1-48-64-48zm-96 48c0-47.3 46.5-80 96-80s96 32.7 96 80c0 28.6-17.5 52.2-41.6 66-4.2 12.8-16.2 22-30.4 22l-48 0c-14.2 0-26.2-9.2-30.4-22-24.1-13.8-41.6-37.4-41.6-66zm48 0a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm80-16a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm70.6 121.4c3.7 8 .1 17.5-7.9 21.2l-56 25.4 56 25.4c8 3.7 11.6 13.1 7.9 21.2s-13.1 11.6-21.2 7.9l-81.4-37-81.4 37c-8 3.7-17.5 .1-21.2-7.9s-.1-17.5 7.9-21.2l56-25.4-56-25.4c-8-3.7-11.6-13.1-7.9-21.2s13.1-11.6 21.2-7.9l81.4 37 81.4-37c8-3.7 17.5-.1 21.2 7.9z"]],
    "unlock-keyhole": [384, 512, ["unlock-alt"], "f13e", ["M32 224l0 224c0 17.7 14.3 32 32 32l256 0c17.7 0 32-14.3 32-32l0-224c0-17.7-14.3-32-32-32L64 192c-17.7 0-32 14.3-32 32zm96 112c0-8.8 7.2-16 16-16l96 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16z", "M192 0C139 0 96 43 96 96l0 64 224 0c35.3 0 64 28.7 64 64l0 224c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 224c0-35.3 28.7-64 64-64l0-64C64 25.3 121.3-32 192-32S320 25.3 320 96c0 8.8-7.2 16-16 16s-16-7.2-16-16c0-53-43-96-96-96zM64 192c-17.7 0-32 14.3-32 32l0 224c0 17.7 14.3 32 32 32l256 0c17.7 0 32-14.3 32-32l0-224c0-17.7-14.3-32-32-32L64 192zM240 352l-96 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l96 0c8.8 0 16 7.2 16 16s-7.2 16-16 16z"]],
    "truck-ramp": [576, 512, [], "f4e0", ["M352 96c0-17.7 14.3-32 32-32l192 0 0 334.6-3.7 0c-10.9-36.3-44.5-62.7-84.3-62.7-34.2 0-63.8 19.5-78.4 48l-57.6 0 0-288z", "M320 96c0-35.3 28.7-64 64-64l192 0 0 32-192 0c-17.7 0-32 14.3-32 32l0 288 57.6 0c14.6-28.5 44.2-48 78.4-48 48.6 0 88 39.4 88 88s-39.4 88-88 88-88-39.4-88-88c0-2.7 .1-5.4 .4-8l-62 0-317.8 95.3c-8.5 2.5-17.4-2.3-19.9-10.7s2.3-17.4 10.7-19.9L320 388.1 320 96zM488 480a56 56 0 1 0 0-112 56 56 0 1 0 0 112z"]],
    "envelope-dot": [576, 512, ["envelope-badge"], "e16f", ["M64 122.5C64 107.9 75.9 96 90.5 96L369 96c5.3 41.8 30.5 77.2 65.9 96.5L316.4 279.3c-16.9 12.4-39.9 12.4-56.8 0L74.8 143.8C68 138.8 64 130.9 64 122.5zm0 53.1L240.7 305.1c28.2 20.6 66.5 20.6 94.6 0l135.8-99.6c8.1 1.6 16.4 2.4 24.9 2.4 5.4 0 10.8-.3 16-1l0 177c0 17.7-14.3 32-32 32L96 416c-17.7 0-32-14.3-32-32l0-208.4z", "M448 80a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm128 0a80 80 0 1 0 -160 0 80 80 0 1 0 160 0zM544 384l0-185.3c-10.1 4.1-20.8 6.9-32 8.3l0 177c0 17.7-14.3 32-32 32L96 416c-17.7 0-32-14.3-32-32l0-208.4 176.7 129.6c28.2 20.6 66.5 20.6 94.6 0l135.8-99.6c-12.9-2.5-25.1-7-36.2-13.1L316.4 279.3c-16.9 12.4-39.9 12.4-56.8 0L74.8 143.8C68 138.8 64 130.9 64 122.5 64 107.9 75.9 96 90.5 96L369 96c-.7-5.2-1-10.6-1-16s.3-10.8 1-16L90.5 64C59 64 33.3 88.9 32.1 120l-.1 0 0 264c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64z"]],
    "house-heart": [512, 512, ["home-heart"], "f4c9", ["M80.5 202.2l0 245.8c0 17.7 14.3 32 32 32l288 0c17.7 0 32-14.3 32-32l0-245.8-176-164.3-176 164.3zm64 85.8c0-35.3 28.7-64 64-64l2.9 0c16.7 0 32.8 6.3 45.1 17.5 12.3-11.2 28.4-17.5 45.1-17.5l2.9 0c35.3 0 64 28.7 64 64 0 35.3-23.1 64.5-45 84.6-22.4 20.6-46.8 34.7-55.9 39.6-7 3.8-15.3 3.8-22.2 0-9.1-4.9-33.5-19-55.9-39.6-21.8-20.1-45-49.3-45-84.6z", "M245.6 4.3c6.1-5.7 15.7-5.7 21.8 0l240 224c6.5 6 6.8 16.2 .8 22.6s-16.2 6.8-22.6 .8l-21.1-19.7 0 216c0 35.3-28.7 64-64 64l-288 0c-35.3 0-64-28.7-64-64l0-216-21.1 19.7c-6.5 6-16.6 5.7-22.6-.8s-5.7-16.6 .8-22.6l240-224zm10.9 33.6l-176 164.3 0 245.8c0 17.7 14.3 32 32 32l288 0c17.7 0 32-14.3 32-32l0-245.8-176-164.3zm20.4 228.3l-9.1 9.1c-3 3-7.1 4.7-11.3 4.7s-8.3-1.7-11.3-4.7l-9.1-9.1c-6.5-6.5-15.4-10.2-24.7-10.2l-2.9 0c-17.7 0-32 14.3-32 32 0 21.4 14.5 42.5 34.6 61 16.8 15.5 35.4 27 45.4 32.7 10-5.7 28.5-17.2 45.4-32.7 20.1-18.5 34.6-39.7 34.6-61 0-17.7-14.3-32-32-32l-2.9 0c-9.3 0-18.1 3.7-24.7 10.2zM301.6 224l2.9 0c35.3 0 64 28.7 64 64 0 35.3-23.1 64.5-45 84.6-22.4 20.6-46.8 34.7-55.9 39.6-7 3.8-15.3 3.8-22.2 0-9.1-4.9-33.5-19-55.9-39.6-21.8-20.1-45-49.3-45-84.6 0-35.3 28.7-64 64-64l2.9 0c16.7 0 32.8 6.3 45.1 17.5 12.3-11.2 28.4-17.5 45.1-17.5z"]],
    "file-arrow-up": [384, 512, ["file-upload"], "f574", ["M32 64l0 384c0 17.7 14.3 32 32 32l256 0c17.7 0 32-14.3 32-32l0-256-96 0c-35.3 0-64-28.7-64-64l0-96-128 0C46.3 32 32 46.3 32 64zm76.7 252.7l72-72c6.2-6.2 16.4-6.2 22.6 0l72 72c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L208 294.6 208 416c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-121.4-44.7 44.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6z", "M64 32l128 0 0 96c0 35.3 28.7 64 64 64l96 0 0 256c0 17.7-14.3 32-32 32L64 480c-17.7 0-32-14.3-32-32L32 64c0-17.7 14.3-32 32-32zM224 45.3L338.7 160 256 160c-17.7 0-32-14.3-32-32l0-82.7zM64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-261.5c0-17-6.7-33.3-18.7-45.3L242.7 18.7C230.7 6.7 214.5 0 197.5 0L64 0zM275.3 316.7l-72-72c-6.2-6.2-16.4-6.2-22.6 0l-72 72c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0L176 294.6 176 416c0 8.8 7.2 16 16 16s16-7.2 16-16l0-121.4 44.7 44.7c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6z"]],
    "game-console-handheld": [384, 512, [], "f8bb", ["M32 64l0 352c0 35.3 28.7 64 64 64l192 0c35.3 0 64-28.7 64-64l0-352c0-17.7-14.3-32-32-32L64 32C46.3 32 32 46.3 32 64zM64 80c0-8.8 7.2-16 16-16l224 0c8.8 0 16 7.2 16 16l0 144c0 17.7-14.3 32-32 32L96 256c-17.7 0-32-14.3-32-32L64 80zm0 256c0-8.8 7.2-16 16-16l16 0 0-16c0-8.8 7.2-16 16-16s16 7.2 16 16l0 16 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0 0 16c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-16-16 0c-8.8 0-16-7.2-16-16zm192 24a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm64-48a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M64 32C46.3 32 32 46.3 32 64l0 352c0 35.3 28.7 64 64 64l192 0c35.3 0 64-28.7 64-64l0-352c0-17.7-14.3-32-32-32L64 32zM0 64C0 28.7 28.7 0 64 0L320 0c35.3 0 64 28.7 64 64l0 352c0 53-43 96-96 96L96 512c-53 0-96-43-96-96L0 64zM96 224l192 0 0-128-192 0 0 128zM64 80c0-8.8 7.2-16 16-16l224 0c8.8 0 16 7.2 16 16l0 144c0 17.7-14.3 32-32 32L96 256c-17.7 0-32-14.3-32-32L64 80zM208 360a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm88-72a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM96 304c0-8.8 7.2-16 16-16s16 7.2 16 16l0 16 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0 0 16c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-16-16 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0 0-16z"]],
    "face-grin-tears": [640, 512, [128514, "grin-tears"], "f588", ["M64.1 248c.5-16.8 2.7-33.3 6.3-49.2l31.2-3.9c1-.1 1.9-.2 2.9-.3 26.7-93.9 113.1-162.6 215.5-162.6s188.8 68.8 215.5 162.6c1 .1 1.9 .2 2.9 .3l31.2 3.9c3.6 15.9 5.8 32.3 6.3 49.2l-43.5-5.4c-10.4-1.3-19.2 7.5-17.9 17.9l6.9 55.5c2.5 20.1 14.9 36.8 31.9 45.5-6.6 14.7-14.6 28.6-23.8 41.7-9.4-5.1-18-11.6-25.7-19.1-40.5 58-107.7 96-183.8 96s-143.4-38-183.8-96c-7.6 7.6-16.2 14-25.7 19.1-9.2-13.1-17.2-27-23.8-41.7 8.5-4.4 15.8-10.7 21.4-18.5 2.8-3.9 5.1-8.1 6.9-12.7 .9-2.3 1.6-4.6 2.3-7s1.1-4.8 1.4-7.4c2.3-18.5 4.6-37 6.9-55.5 1.3-10.4-7.5-19.2-17.9-17.9L64.1 248zm102.4 69.3C186 383.6 247.4 432 320 432s134-48.4 153.5-114.7c3.4-11.7-8.4-21-20-17.3-39.9 12.8-85.3 20-133.5 20s-93.6-7.2-133.5-20c-11.6-3.7-23.4 5.6-20 17.3zM176 218c0 8.8 7.2 16 16 16s16-7.2 16-16c0-17.7 14.3-32 32-32s32 14.3 32 32c0 8.8 7.2 16 16 16s16-7.2 16-16c0-35.3-28.7-64-64-64s-64 28.7-64 64zm160 0c0 8.8 7.2 16 16 16s16-7.2 16-16c0-17.7 14.3-32 32-32s32 14.3 32 32c0 8.8 7.2 16 16 16s16-7.2 16-16c0-35.3-28.7-64-64-64s-64 28.7-64 64z", "M503.8 384l.1 0c7.5 7.6 16.1 14.1 25.5 19.1-46.3 65.8-122.9 108.9-209.5 108.9S156.8 469 110.5 403.1c9.4-5.1 18-11.6 25.5-19.1l.1 0c40.5 58 107.7 96 183.8 96s143.4-38 183.8-96zm31.6-189.4C508.8 100.8 422.4 32 320 32S131.2 100.8 104.5 194.6c-1 .1-1.9 .2-2.9 .3l-31.2 3.9C96.4 85 198.3 0 320 0S543.6 85 569.6 198.8l-31.2-3.9c-1-.1-1.9-.2-2.9-.3zM428.5 340c-34 7.8-70.5 12-108.5 12s-74.5-4.2-108.5-12c22.7 36.1 62.8 60 108.5 60s85.8-23.9 108.5-60zm25-40c11.6-3.7 23.4 5.6 20 17.3-19.5 66.3-80.9 114.7-153.5 114.7S186 383.6 166.5 317.3c-3.4-11.7 8.4-21 20-17.3 39.9 12.8 85.3 20 133.5 20s93.6-7.2 133.5-20zM208 218c0 8.8-7.2 16-16 16s-16-7.2-16-16c0-35.3 28.7-64 64-64s64 28.7 64 64c0 8.8-7.2 16-16 16s-16-7.2-16-16c0-17.7-14.3-32-32-32s-32 14.3-32 32zm192-32c-17.7 0-32 14.3-32 32 0 8.8-7.2 16-16 16s-16-7.2-16-16c0-35.3 28.7-64 64-64s64 28.7 64 64c0 8.8-7.2 16-16 16s-16-7.2-16-16c0-17.7-14.3-32-32-32zM32 308.5c0 15.2 12.3 27.5 27.5 27.5 13.9 0 25.6-10.3 27.3-24.1l4.4-35.1-35.1 4.4C42.3 283 32 294.6 32 308.5zm551.9-27.3l-35.1-4.4 4.4 35.1c1.7 13.8 13.4 24.1 27.3 24.1 15.2 0 27.5-12.3 27.5-27.5 0-13.9-10.3-25.6-24.1-27.3zM52.1 249.5l55.5-6.9c10.4-1.3 19.2 7.5 17.9 17.9l-6.9 55.5c-3.7 29.8-29 52.1-59 52.1-32.9 0-59.5-26.6-59.5-59.5 0-30 22.3-55.3 52.1-59zm535.8 0c29.8 3.7 52.1 29 52.1 59 0 32.9-26.6 59.5-59.5 59.5-30 0-55.3-22.3-59-52.1l-6.9-55.5c-1.3-10.4 7.5-19.2 17.9-17.9l55.5 6.9z"]],
    "pen-to-square": [512, 512, ["edit"], "f044", ["M165.3 346.7L231 331.5c5.8-1.3 11.2-4.3 15.4-8.6l171-171-57.4-57.4-171 170.9c-4.2 4.2-7.2 9.6-8.6 15.4l-15.1 65.6z", "M454.6 45.3l12.1 12.1c12.5 12.5 12.5 32.8 0 45.3L440 129.4 382.6 72 409.4 45.3c12.5-12.5 32.8-12.5 45.3 0zM189 265.6l171-170.9 57.4 57.4-171 171c-4.2 4.2-9.6 7.2-15.4 8.6l-65.6 15.1 15.1-65.6c1.3-5.8 4.3-11.2 8.6-15.4zM386.7 22.6L166.4 243c-8.5 8.5-14.4 19.2-17.1 30.9l-20.9 90.6c-1.2 5.4 .4 11 4.3 14.9s9.5 5.5 14.9 4.3l90.6-20.9c11.7-2.7 22.4-8.6 30.9-17.1L489.4 125.3c25-25 25-65.5 0-90.5L477.3 22.6c-25-25-65.5-25-90.5 0zM80 64C35.8 64 0 99.8 0 144L0 432c0 44.2 35.8 80 80 80l288 0c44.2 0 80-35.8 80-80l0-128c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 128c0 26.5-21.5 48-48 48L80 480c-26.5 0-48-21.5-48-48l0-288c0-26.5 21.5-48 48-48l128 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L80 64z"]],
    "earth-europe": [512, 512, ["globe-europe"], "f7a2", ["M176 370.3l0 3.2c0 12.7 5.1 24.9 14.1 33.9l16 16c5.5 5.5 12.9 8.6 20.7 8.6 28.6 0 52.6 19.5 59.3 46 63.6-8.5 118.7-43.7 153.8-94l-1.2 0c-18.7 0-36.7-7.4-49.9-20.7l-4-4c-4.7-4.7-11-7.3-17.5-7.3-13.6 0-26.7-4.9-37-13.7l-26.6-22.8c-8.7-7.5-19.8-11.6-31.2-11.6l-20.9 0c-9.5 0-18.7 2.8-26.6 8.1l-27.4 18.3C184 339.2 176 354.2 176 370.3zm32-158.5l0 1.6c0 5.9 4.8 10.7 10.7 10.7 3.4 0 6.5-1.6 8.5-4.3l10.7-14.3c6.3-8.4 16.3-13.4 26.8-13.4 8.9 0 17.4 3.5 23.7 9.8l2.8 2.8c2.6 2.6 6.8 2.6 9.4 0l32.1-32.1c13-13 35.2-3.8 35.2 14.6l0 9.4c0 6.3 5.1 11.4 11.4 11.4l3.7 0c23.4 0 36.5 27.1 21.8 45.4-3.7 4.6-3 11.4 1.5 15.2l15.9 13.2c4.8 4 10.8 6.2 17.1 6.2l38.3 0c1.5-10.5 2.3-21.1 2.3-32 0-114.2-85.5-208.5-195.9-222.3l-4.5 17.8c15-3.8 31.1 2.1 40 15.3 12.6 18.7 5.9 44.2-14.2 54.3l-59.2 29.6c-3.8 1.9-6.2 5.8-6.2 10.1 0 8.8-3.5 17.3-9.7 23.5L211.6 203c-2.3 2.3-3.6 5.4-3.6 8.7z", "M477.7 288l-38.3 0c-6.2 0-12.3-2.2-17.1-6.2l-15.9-13.2c-4.6-3.8-5.2-10.5-1.5-15.2 14.6-18.3 1.6-45.4-21.8-45.4l-3.7 0c-6.3 0-11.4-5.1-11.4-11.4l0-9.4c0-18.4-22.2-27.6-35.2-14.6l-32.1 32.1c-2.6 2.6-6.8 2.6-9.4 0l-2.8-2.8c-6.3-6.3-14.8-9.8-23.7-9.8-10.5 0-20.5 5-26.8 13.4l-10.7 14.3c-2 2.7-5.2 4.3-8.5 4.3-5.9 0-10.7-4.8-10.7-10.7l0-1.6c0-3.3 1.3-6.4 3.6-8.7l18.7-18.7c6.2-6.2 9.7-14.7 9.7-23.5 0-4.3 2.4-8.2 6.2-10.1l59.2-29.6c20.2-10.1 26.9-35.6 14.2-54.3-8.9-13.2-25.1-19.1-40-15.3l4.5-17.8c110.5 13.8 195.9 108.1 195.9 222.3 0 10.9-.8 21.5-2.3 32zm-7 32c-3.3 11-7.4 21.7-12.3 32l-19.8 0c-10.2 0-20.1-4.1-27.3-11.3l-4-4c-10.7-10.7-25.1-16.6-40.2-16.6-5.9 0-11.7-2.1-16.1-6l-26.6-22.8c-14.5-12.4-33-19.3-52.1-19.3l-20.9 0c-15.8 0-31.2 4.7-44.4 13.4l-27.4 18.2c-22.3 14.8-35.6 39.8-35.6 66.6l0 3.2c0 21.2 8.4 41.6 23.4 56.6l16 16c11.5 11.5 27.1 17.9 43.3 17.9 11.4 0 21.2 6.5 26.1 16-122.2-1.7-220.8-101.3-220.8-224 0-122.2 97.9-221.6 219.5-224l-6.9 27.6c-4.9 19.7 15.4 36.2 33.7 27.3l8.1-3.9c2.4-1.2 5.3-.4 6.8 1.8 1.8 2.7 .8 6.3-2 7.8l-59.2 29.6c-14.7 7.3-23.9 22.3-23.9 38.7 0 .3-.1 .6-.4 .9L189 180.4c-8.3 8.3-13 19.6-13 31.3l0 1.6c0 23.6 19.1 42.7 42.7 42.7 13.4 0 26.1-6.3 34.1-17.1l10.7-14.3c.3-.4 .7-.6 1.2-.6 .4 0 .8 .2 1.1 .4l2.8 2.8c15.1 15.1 39.6 15.1 54.7 0l15.4-15.4c5.8 15.3 20 26.5 36.9 28-9.5 17.6-5.6 40 10.3 53.3l15.9 13.2c10.5 8.8 23.8 13.6 37.5 13.6l31.3 0zm-30.9 64c-35.1 50.3-90.2 85.5-153.8 94-6.8-26.4-30.8-46-59.3-46-7.8 0-15.2-3.1-20.7-8.6l-16-16c-9-9-14.1-21.2-14.1-33.9l0-3.2c0-16.1 8-31 21.4-39.9l27.4-18.3c7.9-5.3 17.1-8.1 26.6-8.1l20.9 0c11.5 0 22.5 4.1 31.2 11.6l26.6 22.8c10.3 8.8 23.4 13.7 37 13.7 6.6 0 12.9 2.6 17.5 7.3l4 4c13.2 13.2 31.2 20.7 49.9 20.7l1.2 0zM256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM187.3 100.7c-6.2-6.2-16.4-6.2-22.6 0l-32 32c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l32-32c6.2-6.2 6.2-16.4 0-22.6z"]],
    "table-picnic": [512, 512, [], "e32d", ["M150.4 224l211.3 0-52.4-128-106.5 0-52.4 128z", "M62.8 438.1c-3.3 8.2-12.7 12.1-20.9 8.8s-12.1-12.7-8.8-20.9l49.9-121.9 34.6 0-54.8 134.1zm416-12.1c3.3 8.2-.6 17.5-8.7 20.9s-17.5-.6-20.9-8.8l-54.8-134.1 34.6 0 49.9 121.9zM432 64c8.8 0 16 7.2 16 16s-7.2 16-16 16l-88.2 0 52.3 128 99.8 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L16 256c-8.8 0-16-7.2-16-16s7.2-16 16-16l99.8 0 52.3-128-88.2 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l352 0zM202.8 96l-52.4 128 211.3 0-52.4-128-106.5 0z"]],
    "face-grin-beam-sweat": [512, 512, [128517, "grin-beam-sweat"], "f583", ["M32 256c0-123.7 100.3-224 224-224 32.1 0 62.7 6.8 90.3 18.9-5.5 12.4-10.3 27.7-10.3 45.1 0 22.3 6.5 43.1 17.7 60.5-5.6-1.6-11.6-2.5-17.7-2.5-35.3 0-64 28.7-64 64 0 8.8 7.2 16 16 16s16-7.2 16-16c0-17.7 14.3-32 32-32s32 14.3 32 32c0 8.8 7.2 16 16 16s16-7.2 16-16c0-8.1-1.5-15.8-4.2-22.9 15.6 8.2 33.4 12.9 52.2 12.9 9 0 17.8-1.1 26.2-3.1 3.8 16.5 5.8 33.5 5.8 51.1 0 123.7-100.3 224-224 224S32 379.7 32 256zm70.5 61.3C122 383.6 183.4 432 256 432s134-48.4 153.5-114.7c3.4-11.7-8.4-21-20-17.3-39.9 12.8-85.3 20-133.5 20s-93.6-7.2-133.5-20c-11.6-3.7-23.4 5.6-20 17.3zM112 218c0 8.8 7.2 16 16 16s16-7.2 16-16c0-17.7 14.3-32 32-32s32 14.3 32 32c0 8.8 7.2 16 16 16s16-7.2 16-16c0-35.3-28.7-64-64-64s-64 28.7-64 64z", "M362.1 22.9C329.8 8.2 293.8 0 256 0 114.6 0 0 114.6 0 256S114.6 512 256 512 512 397.4 512 256c0-21.8-2.7-42.9-7.8-63.1-9.2 5.4-19.3 9.5-30 12 3.8 16.4 5.8 33.5 5.8 51.1 0 123.7-100.3 224-224 224S32 379.7 32 256 132.3 32 256 32c32.1 0 62.7 6.8 90.3 18.9 1.4-3.1 2.8-5.9 4.2-8.6 3.6-7 7.7-13.5 11.6-19.4zm2.4 317c-22.7 36.1-62.8 60-108.5 60s-85.8-23.9-108.5-60c34 7.8 70.5 12 108.5 12s74.5-4.2 108.5-12zm25-40c-39.9 12.8-85.3 20-133.5 20s-93.6-7.2-133.5-20c-11.6-3.7-23.4 5.6-20 17.3 19.5 66.3 80.9 114.7 153.5 114.7s134-48.4 153.5-114.7c3.4-11.7-8.4-21-20-17.3zM144 218c0-17.7 14.3-32 32-32s32 14.3 32 32c0 8.8 7.2 16 16 16s16-7.2 16-16c0-35.3-28.7-64-64-64s-64 28.7-64 64c0 8.8 7.2 16 16 16s16-7.2 16-16zm192-32c17.7 0 32 14.3 32 32 0 8.8 7.2 16 16 16s16-7.2 16-16c0-35.3-28.7-64-64-64s-64 28.7-64 64c0 8.8 7.2 16 16 16s16-7.2 16-16c0-17.7 14.3-32 32-32zM448 40.9c3.8 4.7 7.5 9.6 11 14.5 6.2 8.6 11.6 16.3 15.6 24 4 7.7 5.3 13.1 5.3 16.6 0 17.7-14.3 32-32 32s-32-14.3-32-32c0-3.5 1.3-8.9 5.3-16.6 4-7.7 9.5-15.4 15.6-24 3.6-4.9 7.2-9.8 11-14.5zM448 0c-5 0-9.3 2.4-12.5 6-8.7 9.8-16.8 20.1-24.5 30.7-12 16.7-27 37.7-27 59.3 0 35.3 28.7 64 64 64s64-28.7 64-64c0-21.5-15-42.5-27-59.3-7.6-10.6-15.8-20.9-24.5-30.7-3.2-3.6-7.6-6-12.5-6z"]],
    "circle-half-stroke": [512, 512, [9680, "adjust"], "f042", ["M32 256c0 118.3 91.8 215.2 208 223.4l0-446.9C123.8 40.8 32 137.7 32 256z", "M272 479.4l0-446.9C388.2 40.8 480 137.7 480 256S388.2 471.2 272 479.4zm-32 0C123.8 471.2 32 374.3 32 256S123.8 40.8 240 32.6l0 446.9zM256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512z"]],
    "ruler-triangle": [512, 512, [128208], "f61c", ["M64 32l0 416 416 0-68.7-68.7-16 16c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l16-16-41.4-41.4-16 16c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l16-16-41.4-41.4-16 16c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l16-16-41.4-41.4-16 16c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l16-16-41.4-41.4-16 16c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l16-16-68.7-68.7zm64 201.1c0-6.5 3.9-12.3 9.9-14.8s12.9-1.1 17.4 3.5L290.2 356.7c4.6 4.6 5.9 11.5 3.5 17.4s-8.3 9.9-14.8 9.9L144 384c-8.8 0-16-7.2-16-16l0-134.9z", "M480 448l-416 0 0-416 68.7 68.7-16 16c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l16-16 41.4 41.4-16 16c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l16-16 41.4 41.4-16 16c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l16-16 41.4 41.4-16 16c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l16-16 41.4 41.4-16 16c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l16-16 68.7 68.7zM86.6 9.4C77.5 .2 63.7-2.5 51.8 2.4S32 19.1 32 32l0 416c0 17.7 14.3 32 32 32l416 0c12.9 0 24.6-7.8 29.6-19.8s2.2-25.7-6.9-34.9L86.6 9.4zm68.7 212.5c-4.6-4.6-11.5-5.9-17.4-3.5s-9.9 8.3-9.9 14.8L128 368c0 8.8 7.2 16 16 16l134.9 0c6.5 0 12.3-3.9 14.8-9.9s1.1-12.9-3.5-17.4L155.3 221.8zM160 352l0-80.2 80.2 80.2-80.2 0z"]],
    "octagon-plus": [512, 512, ["plus-octagon"], "f301", ["M32.5 181.6l0 148.8c0 4.2 1.7 8.3 4.7 11.3L170.7 475.2c3 3 7.1 4.7 11.3 4.7l148.8 0c4.2 0 8.3-1.7 11.3-4.7L475.7 341.7c3-3 4.7-7.1 4.7-11.3l0-148.8c0-4.2-1.7-8.3-4.7-11.3L342.2 36.8c-3-3-7.1-4.7-11.3-4.7L182 32.1c-4.2 0-8.3 1.7-11.3 4.7L37.2 170.3c-3 3-4.7 7.1-4.7 11.3zM144.4 256c0-8.8 7.2-16 16-16l80 0 0-80c0-8.8 7.2-16 16-16s16 7.2 16 16l0 80 80 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-80 0 0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80-80 0c-8.8 0-16-7.2-16-16z", "M.5 330.4c0 12.7 5.1 24.9 14.1 33.9L148.1 497.9c9 9 21.2 14.1 33.9 14.1l148.8 0c12.7 0 24.9-5.1 33.9-14.1L498.3 364.4c9-9 14.1-21.2 14.1-33.9l0-148.8c0-12.7-5.1-24.9-14.1-33.9L364.8 14.1c-9-9-21.2-14.1-33.9-14.1L182 .1c-12.7 0-24.9 5.1-33.9 14.1L14.6 147.6c-9 9-14.1 21.2-14.1 33.9l0 148.8zM182 32.1l148.8 0c4.2 0 8.3 1.7 11.3 4.7L475.7 170.3c3 3 4.7 7.1 4.7 11.3l0 148.8c0 4.2-1.7 8.3-4.7 11.3L342.2 475.2c-3 3-7.1 4.7-11.3 4.7l-148.8 0c-4.2 0-8.3-1.7-11.3-4.7L37.2 341.7c-3-3-4.7-7.1-4.7-11.3l0-148.8c0-4.2 1.7-8.3 4.7-11.3L170.7 36.8c3-3 7.1-4.7 11.3-4.7zM240.4 352c0 8.8 7.2 16 16 16s16-7.2 16-16l0-80 80 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-80 0 0-80c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 80-80 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l80 0 0 80z"]],
    "user-cowboy": [448, 512, [], "f8ea", ["M16 512l416 0c-8.8 0-16-7.2-16-16 0-79.5-64.5-144-144-144l-96 0c-79.5 0-144 64.5-144 144 0 8.8-7.2 16-16 16zM120.8 96.2c27.5 9.4 61.6 15.8 103.2 15.8 36.1 0 66.5-4.8 91.9-12.2-3.3-18.3-8.2-38.4-14.8-56.1-5.4-14.2-11.5-25.8-18.1-33.5-6.5-7.7-12.2-10.1-17-10.1-4.7 0-10.2 2-17.7 6.1-6.1 3.4-14.8 7-24.3 7l0-6.2c-5.9 0-12-2.7-17.2-6.1-7.5-4.8-15.9-8.9-24.8-8.9-31.3 0-50.7 53.3-61.2 104.2z", "M232.9-21.9c8.3-4.6 19.8-10.1 33.1-10.1 17.6 0 31.3 9.6 41.4 21.4 10 11.7 17.7 27.2 23.7 43 6.8 18.1 11.9 38 15.4 56.4 41.6-18.3 64.2-42.9 71.5-56.4 4.2-7.8 14-10.6 21.7-6.4s10.6 14 6.4 21.7c-11.7 21.5-42.2 52.4-94 73.4l0 22.9c0 70.7-57.3 128-128 128S96 214.7 96 144l0-22.9C44.1 100.1 13.7 69.1 2 47.7-2.3 39.9 .6 30.2 8.3 26s17.5-1.4 21.7 6.4c12.7 23.3 70.8 79.7 194 79.7 36.1 0 66.5-4.8 91.9-12.2-3.3-18.3-8.2-38.4-14.8-56.1-5.4-14.2-11.5-25.8-18.1-33.5-6.5-7.7-12.2-10.1-17-10.1-4.7 0-10.2 2-17.7 6.1-6.1 3.4-14.8 7-24.3 7l0-32c1.8 0 4.9-.8 8.9-3zM320 131.8c-27.4 7.5-59.3 12.2-96 12.2s-68.6-4.7-96-12.2l0 12.2c0 53 43 96 96 96s96-43 96-96l0-12.2zM32 496c0 8.8-7.2 16-16 16S0 504.8 0 496c0-97.2 78.8-176 176-176l96 0c97.2 0 176 78.8 176 176 0 8.8-7.2 16-16 16s-16-7.2-16-16c0-79.5-64.5-144-144-144l-96 0C96.5 352 32 416.5 32 496z"]],
    "bookmark-plus": [384, 512, [], "e755", ["M32 64c0-17.7 14.3-32 32-32l256 0c17.7 0 32 14.3 32 32l0 412-147.8-87.3c-3.1-1.9-6.6-2.9-10.1-3.2l-2.1-1.4-2.1 1.4c-3.5 .3-7 1.4-10.1 3.2L32 476 32 64zm72 144c0 8.8 7.2 16 16 16l56 0 0 56c0 8.8 7.2 16 16 16s16-7.2 16-16l0-56 56 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-56 0 0-56c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 56-56 0c-8.8 0-16 7.2-16 16z", "M64 0C28.7 0 0 28.7 0 64L0 490c0 18.6 20.2 30.1 36.2 20.7L192 418.6 347.8 510.6c16 9.5 36.2-2.1 36.2-20.7l0-426c0-35.3-28.7-64-64-64L64 0zM32 64c0-17.7 14.3-32 32-32l256 0c17.7 0 32 14.3 32 32l0 412-147.8-87.3c-7.5-4.5-16.9-4.5-24.4 0L32 476 32 64zM176 280c0 8.8 7.2 16 16 16s16-7.2 16-16l0-56 56 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-56 0 0-56c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 56-56 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l56 0 0 56z"]],
    "person-military-to-person": [512, 512, [], "e54c", ["M64 256.5c0-8.2 3.1-15.6 8.1-21.3l88.7 53.1-96.8 0 0-31.8zM88 44.9l88-11.7 0 13.7-88 0 0-1.9zm8 51.8c21.3 0 42.7 0 64 0 0 17.6-14.3 31.9-32 31.9S96 114.2 96 96.6zm20.5 127.8l43.5 0c17.7 0 32 14.3 32 32l0 13.2-75.5-45.2zm203.5 32c0-17.7 14.3-32 32-32l64 0c17.7 0 32 14.3 32 32l0 31.8-128 0 0-31.8zM416 96.6a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M176 33.1l0 13.7-88 0 0-1.9 88-11.7zM180.8 .2L76.8 14.1C64.9 15.6 56 25.8 56 37.9l0 16.9c0 13.3 10.7 24 24 24l104 0c13.3 0 24-10.7 24-24L208 24C208 9.5 195.2-1.7 180.8 .2zM352 96.6a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm96 0a64 64 0 1 0 -128 0 64 64 0 1 0 128 0zM320 256.5c0-17.7 14.3-32 32-32l64 0c17.7 0 32 14.3 32 32l0 31.8-128 0 0-31.8zm-32 0l0 31.8c0 17.7 14.3 32 32 32l128 0c17.7 0 32-14.3 32-32l0-31.8c0-35.3-28.7-64-64-64l-64 0c-35.3 0-64 28.7-64 64zm-171.5-32l43.5 0c17.7 0 32 14.3 32 32l0 13.2-75.5-45.2zm44.2 63.8l-96.8 0 0-31.8c0-8.2 3.1-15.6 8.1-21.3l88.7 53.1zM96 192.5c-35.3 0-64 28.7-64 64l0 31.8c0 17.7 14.3 32 32 32l128 0c17.7 0 32-14.3 32-32l0-31.8c0-35.3-28.7-64-64-64l-64 0zM64 96.6c0 35.3 28.7 63.9 64 63.9s64-28.6 64-63.9l-32 0c0 17.6-14.3 31.9-32 31.9S96 114.2 96 96.6l-32 0zm82.6 259.6c-6.6-5.9-16.7-5.3-22.6 1.3s-5.3 16.7 1.3 22.6l40.5 35.9-149.9 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l149.9 0-40.5 35.9c-6.6 5.9-7.2 16-1.3 22.6s16 7.2 22.6 1.3l72-63.9c3.4-3 5.4-7.4 5.4-12s-2-8.9-5.4-12l-72-63.9zm218.8 0l-72 63.9c-3.4 3-5.4 7.4-5.4 12s2 8.9 5.4 12l72 63.9c6.6 5.9 16.7 5.3 22.6-1.3s5.3-16.7-1.3-22.6l-40.5-35.9 149.9 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-149.9 0 40.5-35.9c6.6-5.9 7.2-16 1.3-22.6s-16-7.2-22.6-1.3z"]],
    "image-music": [640, 512, [], "e770", ["M96 96c0-17.7 14.3-32 32-32l320 0c17.7 0 32 14.3 32 32l0 108.6-61.1 12.7c-16.3 3.4-30 12.8-39.1 25.5l-26.3-40.6c-7.4-11.4-20-18.3-33.6-18.3s-26.2 6.9-33.6 18.3l-32.9 50.8c-7.5-8.3-18.2-13.1-29.6-13.1-13.1 0-25.3 6.4-32.8 17.1l-56 80c-8.6 12.2-9.6 28.2-2.7 41.4S153.1 400 168 400l156.7 0c-19.2 11-35.2 27.4-44.3 48L128 448c-17.7 0-32-14.3-32-32L96 96zm48 64a48 48 0 1 0 96 0 48 48 0 1 0 -96 0z", "M448 64L128 64c-17.7 0-32 14.3-32 32l0 320c0 17.7 14.3 32 32 32l152.4 0c-4.3 9.8-7.1 20.5-8 32L128 480c-35.3 0-64-28.7-64-64L64 96c0-35.3 28.7-64 64-64l320 0c35.3 0 64 28.7 64 64l0 102-32 6.7 0-108.6c0-17.7-14.3-32-32-32zM353.6 202.3l26.3 40.6C372.4 253.4 368 266.3 368 280l0 3.5-41.3-63.8c-1.5-2.3-4-3.7-6.7-3.7s-5.2 1.4-6.7 3.7l-45.6 70.4c-2.9 4.5-7.8 7.2-13.1 7.3s-10.3-2.5-13.4-6.8l-10.6-15.2c-1.5-2.1-3.9-3.4-6.6-3.4s-5.1 1.3-6.6 3.4l-56 80c-1.7 2.4-1.9 5.6-.5 8.3S165 368 168 368l200 0 0 17.2c-15.2 2.1-30 7.2-43.3 14.8L168 400c-14.9 0-28.6-8.3-35.5-21.5s-5.8-29.2 2.7-41.4l56-80c7.5-10.7 19.7-17.1 32.8-17.1 11.3 0 22 4.8 29.6 13.1l32.9-50.8c7.4-11.4 20-18.3 33.6-18.3s26.2 6.9 33.6 18.3zM192 144a16 16 0 1 0 0 32 16 16 0 1 0 0-32zm48 16a48 48 0 1 1 -96 0 48 48 0 1 1 96 0zm400 79.9l0 216.1c0 30.7-28.4 56-64 56s-64-25.3-64-56 28.4-56 64-56c11.7 0 22.6 2.7 32 7.5l0-67.9-160 33.3 0 115.1c0 30.7-28.4 56-64 56s-64-25.3-64-56 28.4-56 64-56c11.7 0 22.6 2.7 32 7.5l0-159.6c0-7.6 5.3-14.1 12.7-15.7l192-40c4.7-1 9.6 .2 13.4 3.2s5.9 7.6 5.9 12.4zm-32 67l0-47.3-160 33.3 0 47.3 160-33.3zM352 487.9c0 9.6 10.4 24 32 24s32-14.4 32-24-10.4-24-32-24-32 14.4-32 24zm224-56c-21.6 0-32 14.4-32 24s10.4 24 32 24 32-14.4 32-24-10.4-24-32-24z"]],
    "person-pinball": [512, 512, [], "e21d", ["M88 24a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zM192 285.1l288-57.6 0 124.5-288 0 0-66.9zM384 0l96 0 0 181.9-92-103.4c-2.6-2.9-4-6.7-4-10.6L384 0z", "M499.2-31.7c7.3 1.5 12.8 8 12.8 15.7l0 544c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-144-288 0 0 144c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-251.2-82.5-123.7c-3.8-5.7-10.2-9.1-17.1-9.1-11.3 0-20.5 9.2-20.5 20.5l0 115.5c0 11.6 4.2 22.9 11.9 31.6l24.3 27.8 4.5 5.7c9.9 13.6 15.3 30.1 15.3 47L96 528c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-135.9c0-10.2-3.2-20.1-9.2-28.2l-2.7-3.4-24.3-27.8C15 318 8 299.3 8 279.9L8 164.5c0-29 23.5-52.5 52.5-52.5 17.5 0 34 8.8 43.7 23.4l79.2 118.8 270.1-54-89.3-100.5C356.3 90.9 352 79.6 352 67.8l0-83.8 .3-3.2c1.5-7.3 8-12.8 15.7-12.8l128 0 3.2 .3zM192 285.1l0 66.9 288 0 0-124.5-288 57.6zM384 67.8c0 3.9 1.4 7.7 4 10.6l92 103.4 0-181.9-96 0 0 67.8zM64 80A56 56 0 1 1 64-32 56 56 0 1 1 64 80zM64 0a24 24 0 1 0 0 48 24 24 0 1 0 0-48z"]],
    "mouse-field": [512, 512, [], "e5a8", ["M444.4 126.1c12.1-11.9 19.5-28.4 19.5-46.6 0-36.1-29.3-65.3-65.3-65.3-17.9 0-34.2 7.2-46 18.9-13.5-10.5-30.5-16.8-49-16.8l-5.2 0c-41.2 0-74.7 33.4-74.7 74.7 0 28.6 13.7 55.5 36.8 72.4l18.5 13.5-13.7 0c-83.9 0-152 68.1-152 152l0 15.5c0 30.9 25.1 56 56 56l186.7 0c16.3 0 29.5-13.2 29.5-29.5 0-12.4-7.8-23.5-19.4-27.7l-28-10.2 29.1-77.1 91.9 0c21 0 38-17 38-38 0-39.2-21.2-73.4-52.7-91.9z", "M379.4 36.6c6.2-3 13.2-4.6 20.6-4.6 26.5 0 48 21.5 48 48 0 9.6-2.8 18.6-7.7 26.1-12.5-5.5-26-8.9-40.3-9.8l0-.3c0-22.4-7.7-43-20.6-59.4zm88.2 86.2c7.8-12.4 12.4-27.1 12.4-42.8 0-44.2-35.8-80-80-80-16.9 0-32.7 5.3-45.6 14.3-14.6-9-31.9-14.3-50.4-14.3-53.1 0-96 43.4-96 96.3 0 25.7 10.2 49.8 27.5 67.5-79.7 16.8-139.5 87.5-139.5 172.2 0 18 6 34.6 16 48l-48 0c-35.3 0-64 28.7-64 64s28.7 64 64 64l400 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L64 480c-17.7 0-32-14.3-32-32s14.3-32 32-32l292.1 0c24.2 0 43.9-19.7 43.9-43.9 0-18.9-12.1-35.7-30-41.6l-12.8-4.3 21.7-54.2 85.2 0c26.5 0 48-21.5 48-48l0-8c0-37.6-17.3-71.2-44.4-93.2zM176 384c-26.5 0-48-21.5-48-48 0-79.5 64.5-144 144-144l16 0c7.7 0 14.4-5.5 15.7-13.1s-2.9-15.1-10.1-17.8l-12.1-4.5c-24.9-9.3-41.5-33.4-41.5-60.2 0-35.4 28.7-64.3 64-64.3 35.3 0 64 28.7 64 64l0 16c0 8.8 7.2 16 16 16l8 0c48.6 0 88 39.4 88 88l0 8c0 8.8-7.2 16-16 16l-96 0c-6.5 0-12.4 4-14.9 10.1l-26.4 66-33.7-11.2c-8.4-2.8-17.4 1.7-20.2 10.1s1.7 17.4 10.1 20.2l76.9 25.6c4.9 1.6 8.1 6.2 8.1 11.3 0 6.6-5.3 11.9-11.9 11.9L176 384zM336 80c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 16-16 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32zm96 108a20 20 0 1 0 -40 0 20 20 0 1 0 40 0z"]],
    "table-cells-column-lock": [640, 512, [], "e678", ["M96 192l96 0 0 256-64 0c-17.7 0-32-14.3-32-32l0-224zm128 0l128 0 0 128 28.8 0c-8.1 14.1-12.8 30.4-12.8 47.9l0 80.1-144 0 0-256zm160 0l44.1 0c-17.6 21.9-28.1 49.7-28.1 80l0 24.4c-6.1 5.4-11.5 11.6-16 18.5L384 192z", "M448 64L128 64c-17.7 0-32 14.3-32 32l0 64 370 0c-14.6 8.1-27.5 19-37.9 32l-44.1 0 0 122.8c-1.1 1.7-2.2 3.4-3.2 5.2l-28.8 0 0-128-128 0 0 256 144 0 0 15.9c0 5.5 .5 10.9 1.3 16.1L128 480c-35.3 0-64-28.7-64-64L64 96c0-35.3 28.7-64 64-64l320 0c35.3 0 64 28.7 64 64l0 49c-11.2 1.4-21.9 4.2-32 8.3L480 96c0-17.7-14.3-32-32-32zM192 192l-96 0 0 224c0 17.7 14.3 32 32 32l64 0 0-256zM448 320.1l0-48c0-44.2 35.8-80 80-80s80 35.8 80 80l0 50.6c18.6 6.6 32 24.4 32 45.3l0 96c0 26.5-21.5 48-48 48l-128 0c-26.5 0-48-21.5-48-48l0-96c0-20.9 13.4-38.7 32-45.3l0-2.6zm0 47.9l0 96c0 8.8 7.2 16 16 16l128 0c8.8 0 16-7.2 16-16l0-96c0-8.2-6.2-15-14.3-15.9l-131.5 0c-8 .9-14.3 7.7-14.3 15.9zm128-95.9c0-26.5-21.5-48-48-48s-48 21.5-48 48l0 47.9 96 0 0-47.9z"]],
    "truck-field-un": [640, 512, [], "e58e", ["M64 96l0 240c0 6.8 4.2 12.6 10.2 14.9 14.8-27.9 44.1-46.9 77.8-46.9 34.2 0 63.8 19.5 78.4 48l153.6 0 0-256c0-17.7-14.3-32-32-32L96 64C78.3 64 64 78.3 64 96zm48 48c0-8.8 7.2-16 16-16s16 7.2 16 16l0 64c0 8.8 7.2 16 16 16s16-7.2 16-16l0-64c0-8.8 7.2-16 16-16s16 7.2 16 16l0 64c0 26.5-21.5 48-48 48s-48-21.5-48-48l0-64zm128 0c0-7.1 4.6-13.3 11.4-15.3s14 .6 17.9 6.4l34.7 52 0-43.2c0-8.8 7.2-16 16-16s16 7.2 16 16l0 96c0 7.1-4.6 13.3-11.4 15.3s-14-.6-17.9-6.4l-34.7-52 0 43.2c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-96zm176 96l0 84.1c15.2-12.6 34.7-20.1 56-20.1 34.2 0 63.8 19.5 78.4 48l9.6 0c8.8 0 16-7.2 16-16l0-80c0-8.8-7.2-16-16-16l-144 0z", "M96 64C78.3 64 64 78.3 64 96l0 240c0 6.8 4.2 12.6 10.2 14.9 14.8-27.9 44.1-46.9 77.8-46.9 34.2 0 63.8 19.5 78.4 48l153.6 0 0-256c0-17.7-14.3-32-32-32L96 64zM0 160c0-17.7 14.3-32 32-32l0-32c0-35.3 28.7-64 64-64l256 0c35.3 0 64 28.7 64 64l24.6 0c25.4 0 48.4 15.1 58.6 38.3l32.2 73.7 28.5 0c26.5 0 48 21.5 48 48l0 80c0 26.5-21.5 48-48 48l-.4 0c.2 2.6 .4 5.3 .4 8 0 48.6-39.4 88-88 88s-88-39.4-88-88c0-2.7 .1-5.4 .4-8l-144.7 0c.2 2.6 .4 5.3 .4 8 0 48.6-39.4 88-88 88s-88-39.4-88-88c0-3.6 .2-7.1 .6-10.5-19-6.4-32.6-24.4-32.6-45.5l0-48c-17.7 0-32-14.3-32-32l0-96zM416 324.1c15.2-12.6 34.7-20.1 56-20.1 34.2 0 63.8 19.5 78.4 48l9.6 0c8.8 0 16-7.2 16-16l0-80c0-8.8-7.2-16-16-16l-144 0 0 84.1zM416 208l80.5 0-26.6-60.8c-5.1-11.6-16.6-19.2-29.3-19.2l-24.6 0 0 80zM152 448a56 56 0 1 0 0-112 56 56 0 1 0 0 112zm376-56a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zM269.3 135.1l34.7 52 0-43.2c0-8.8 7.2-16 16-16s16 7.2 16 16l0 96c0 7.1-4.6 13.3-11.4 15.3s-14-.6-17.9-6.4l-34.7-52 0 43.2c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-96c0-7.1 4.6-13.3 11.4-15.3s14 .6 17.9 6.4zM144 144l0 64c0 8.8 7.2 16 16 16s16-7.2 16-16l0-64c0-8.8 7.2-16 16-16s16 7.2 16 16l0 64c0 26.5-21.5 48-48 48s-48-21.5-48-48l0-64c0-8.8 7.2-16 16-16s16 7.2 16 16z"]],
    "clock": [512, 512, [128339, "clock-four"], "f017", ["M480 256a224 224 0 1 1 -448 0 224 224 0 1 1 448 0zM240 112l0 144c0 5.4 2.7 10.3 7.1 13.3l96 64c7.4 4.9 17.3 2.9 22.2-4.4s2.9-17.3-4.4-22.2L272 247.4 272 112c0-8.8-7.2-16-16-16s-16 7.2-16 16z", "M480 256a224 224 0 1 1 -448 0 224 224 0 1 1 448 0zM0 256a256 256 0 1 0 512 0 256 256 0 1 0 -512 0zM240 112l0 144c0 5.4 2.7 10.3 7.1 13.3l96 64c7.4 4.9 17.3 2.9 22.2-4.4s2.9-17.3-4.4-22.2L272 247.4 272 112c0-8.8-7.2-16-16-16s-16 7.2-16 16z"]],
    "layer-minus": [512, 512, ["layer-group-minus"], "f5fe", ["M43.1 224l202.9 93.8c6.4 3 13.7 3 20.1 0L468.9 224 266.1 130.2c-6.4-3-13.8-3-20.1 0L43.1 224zm0 160l202.9 93.8c6.4 3 13.7 3 20.1 0L468.9 384 391.2 348c-30.5 14.1-61 28.2-91.6 42.3-27.7 12.8-59.6 12.8-87.3 0-30.5-14.1-61-28.2-91.6-42.3L43.1 384z", "M368 32c-8.8 0-16 7.2-16 16s7.2 16 16 16l128 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L368 32zM266.1 130.2L468.9 224 266.1 317.7c-6.4 3-13.8 3-20.1 0L43.1 224 245.9 130.2c6.4-3 13.7-3 20.1 0zm13.4-29c-14.9-6.9-32.1-6.9-47 0L13.9 202.2C5.4 206.1 0 214.6 0 224s5.4 17.9 13.9 21.8l218.6 101c14.9 6.9 32.1 6.9 47 0l218.6-101c8.5-3.9 13.9-12.4 13.9-21.8s-5.4-17.9-13.9-21.8l-218.6-101zM82.7 330.4L13.9 362.2C5.4 366.1 0 374.6 0 384s5.4 17.9 13.9 21.8l218.6 101c14.9 6.9 32.1 6.9 47 0l218.6-101c8.5-3.9 13.9-12.4 13.9-21.8s-5.4-17.9-13.9-21.8l-68.7-31.8-38.1 17.6 77.7 35.9-202.9 93.8c-6.4 3-13.8 3-20.1 0L43.1 384 120.8 348 82.7 330.4z"]],
    "circle-euro": [512, 512, [], "e5ce", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm88-32c0-8.8 7.2-16 16-16l24.7 0c19.2-46.9 65.4-80 119.2-80l33 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-33 0c-35.7 0-66.8 19.3-83.6 48l59.7 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-71.4 0c-1 5.4-1.4 11-1.4 16.8 0 5.2 .4 10.3 1.2 15.2l71.7 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-60.6 0c16.6 29.5 48.2 49.5 84.5 49.5l33 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-33 0c-54.4 0-101-33.8-119.8-81.5L136 304c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0c-.6-5-.9-10.1-.9-15.2 0-5.7 .4-11.3 1.1-16.8L136 240c-8.8 0-16-7.2-16-16z", "M480 256a224 224 0 1 0 -448 0 224 224 0 1 0 448 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zM279.9 128l33 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-33 0c-35.7 0-66.8 19.3-83.6 48l59.7 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-71.4 0c-1 5.4-1.4 11-1.4 16.8 0 5.2 .4 10.3 1.2 15.2l71.7 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-60.6 0c16.6 29.5 48.2 49.5 84.5 49.5l33 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-33 0c-54.4 0-101-33.8-119.8-81.5L136 304c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0c-.6-5-.9-10.1-.9-15.2 0-5.7 .4-11.3 1.1-16.8L136 240c-8.8 0-16-7.2-16-16s7.2-16 16-16l24.7 0c19.2-46.9 65.4-80 119.2-80z"]],
    "book": [448, 512, [128212], "f02d", ["M32 64l0 328.6c9.4-5.4 20.3-8.6 32-8.6l336 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 32C46.3 32 32 46.3 32 64zm96 80c0-8.8 7.2-16 16-16l192 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-192 0c-8.8 0-16-7.2-16-16zm0 96c0-8.8 7.2-16 16-16l192 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-192 0c-8.8 0-16-7.2-16-16z", "M0 64C0 28.7 28.7 0 64 0L400 0c26.5 0 48 21.5 48 48l0 320c0 20.9-13.4 38.7-32 45.3l0 66.7 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L64 512c-35.3 0-64-28.7-64-64l0 0 0-384zM64 416c-17.7 0-32 14.3-32 32s14.3 32 32 32l320 0 0-64-320 0zM32 392.6c9.4-5.4 20.3-8.6 32-8.6l336 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 32C46.3 32 32 46.3 32 64l0 328.6zM144 128l192 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-192 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zm0 96l192 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-192 0c-8.8 0-16-7.2-16-16s7.2-16 16-16z"]],
    "face-laugh-wink": [512, 512, ["laugh-wink"], "f59c", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm69.6 58c-3.7-13.7 7.5-26 21.7-26l265.4 0c14.2 0 25.4 12.3 21.7 26-18.5 68-80.6 118-154.4 118S120 382 101.6 314zM200 192a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm72 8c0-30.9 25.1-56 56-56l16 0c30.9 0 56 25.1 56 56 0 8.8-7.2 16-16 16s-16-7.2-16-16c0-13.3-10.7-24-24-24l-16 0c-13.3 0-24 10.7-24 24 0 8.8-7.2 16-16 16s-16-7.2-16-16z", "M480 256a224 224 0 1 0 -448 0 224 224 0 1 0 448 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zM256 400c53.7 0 99.7-33.1 118.7-80l-237.4 0c19 46.9 65 80 118.7 80zM123.3 288l265.4 0c14.2 0 25.4 12.3 21.7 26-18.5 68-80.6 118-154.4 118S120 382 101.6 314c-3.7-13.7 7.5-26 21.7-26zM152 192a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm152 8c0 8.8-7.2 16-16 16s-16-7.2-16-16c0-30.9 25.1-56 56-56l16 0c30.9 0 56 25.1 56 56 0 8.8-7.2 16-16 16s-16-7.2-16-16c0-13.3-10.7-24-24-24l-16 0c-13.3 0-24 10.7-24 24z"]],
    "transducer": [384, 512, [], "e826", ["M32 432l0 64c0 8.8 7.2 16 16 16l48 0 0-96-48 0c-8.8 0-16 7.2-16 16zM96 112l0 272 192 0 0-272c0-8.8-7.2-16-16-16L112 96c-8.8 0-16 7.2-16 16zm32 304l0 96 128 0 0-96-128 0zm160 0l0 96 48 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16l-48 0z", "M240-32c8.8 0 16 7.2 16 16l0 80 16 0c26.5 0 48 21.5 48 48l0 272 16 0c26.5 0 48 21.5 48 48l0 64-.2 4.9C381.3 525.1 360.9 544 336 544L48 544C23.1 544 2.7 525.1 .2 500.9L0 496 0 432c0-26.5 21.5-48 48-48l16 0 0-272c0-26.5 21.5-48 48-48l16 0 0-80c0-8.8 7.2-16 16-16s16 7.2 16 16l0 80 64 0 0-80c0-8.8 7.2-16 16-16zM48 416c-8.8 0-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16l48 0 0-96-48 0zm80 96l128 0 0-96-128 0 0 96zm160 0l48 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16l-48 0 0 96zM112 96c-8.8 0-16 7.2-16 16l0 272 192 0 0-272c0-8.8-7.2-16-16-16L112 96z"]],
    "user-doctor-hair-long": [448, 512, [], "e459", ["M17.4 511.9c42.2 .1 84.4 .1 126.6 .1-30.9 0-56-25.1-56-56 0-25.4 16.9-46.8 40-53.7l0-42.1c-55.9 19.8-96 73.1-96 135.8 0 8.4-6.4 15.3-14.6 15.9zM84 240l55.3 0c-12.1-10.6-22.1-23.5-29.5-38-4 7.7-8.6 15-13.9 22L84 240zm36 216c0 13.3 10.7 24 24 24s24-10.7 24-24-10.7-24-24-24-24 10.7-24 24zM133.5 96l57.6 0c17.8 0 35.1-5.9 49.1-16.9l38.6-30C263.2 38.3 244.4 32 224 32 182.2 32 146.6 58.7 133.5 96zM144 512l286 0c-7.9-1.1-14-7.8-14-16 0-62.7-40.1-116-96-135.8l0 41.8c27.6 7.1 48 32.2 48 62l0 24c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-24c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 24c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-24c0-29.8 20.4-54.9 48-62l0-49.1c-5.3-.6-10.6-.9-16-.9l-96 0c-5.4 0-10.7 .3-16 .9l0 49.4c23.1 6.9 40 28.3 40 53.7 0 30.9-25.1 56-56 56zM308.7 240l55.3 0-12-16c-5.2-7-9.9-14.3-13.9-22-7.4 14.5-17.4 27.4-29.5 38z", "M320 128c0-21-6.7-40.4-18.2-56.2l-42 32.7C240.2 119.7 216 128 191.1 128l-63.1 0 0 16c0 53 43 96 96 96s96-43 96-96l0-16zM191.1 96c17.8 0 35.1-5.9 49.1-16.9l38.6-30C263.2 38.3 244.4 32 224 32 182.2 32 146.6 58.7 133.5 96l57.6 0zM338.1 202c-7.4 14.5-17.4 27.4-29.5 38l55.3 0-12-16c-5.2-7-9.9-14.3-13.9-22zM224 272L76 272c-15.5 0-28-12.5-28-28 0-6.1 2-12 5.6-16.8l16.8-22.4C87 182.6 96 155.7 96 128 96 57.3 153.3 0 224 0S352 57.3 352 128c0 27.7 9 54.6 25.6 76.8l16.8 22.4c3.6 4.8 5.6 10.7 5.6 16.8 0 15.5-12.5 28-28 28l-148 0zm-84.7-32c-12.1-10.6-22.1-23.5-29.5-38-4 7.7-8.6 15-13.9 22l-12 16 55.3 0zM32 496c0 8.8-7.2 16-16 16S0 504.8 0 496c0-97.2 78.8-176 176-176l96 0c97.2 0 176 78.8 176 176 0 8.8-7.2 16-16 16s-16-7.2-16-16c0-62.7-40.1-116-96-135.8l0 41.8c27.6 7.1 48 32.2 48 62l0 24c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-24c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 24c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-24c0-29.8 20.4-54.9 48-62l0-49.1c-5.3-.6-10.6-.9-16-.9l-96 0c-5.4 0-10.7 .3-16 .9l0 49.4c23.1 6.9 40 28.3 40 53.7 0 30.9-25.1 56-56 56s-56-25.1-56-56c0-25.4 16.9-46.8 40-53.7l0-42.1C72.1 380 32 433.3 32 496zm136-40c0-13.3-10.7-24-24-24s-24 10.7-24 24 10.7 24 24 24 24-10.7 24-24z"]],
    "cloud-meatball": [512, 512, [], "f73b", ["M32 224c0-32.5 24.3-59.4 55.7-63.5 4.8-.6 9.1-3.4 11.6-7.5s3-9.2 1.4-13.8c-3.1-8.5-4.7-17.6-4.7-27.2 0-44.2 35.8-80 80-80 35.3 0 65.3 22.9 75.9 54.7 2 5.9 7.1 10.1 13.2 10.8s12.2-2.1 15.5-7.3c9.9-15.7 27.5-26.1 47.4-26.1 30.9 0 56 25.1 56 56 0 7.4-1.4 14.4-4 20.9-2.3 5.6-1.1 12.1 2.9 16.6s10.3 6.4 16.2 4.8c5.4-1.5 11.1-2.3 16.9-2.3 35.3 0 64 28.7 64 64s-28.7 64-64 64l-45.7 0c-.1-.1-.3-.3-.4-.4l-1.4-1.4c-15-15-35.3-22.9-56.1-22.2-14.2-15.1-34.2-23.9-55.4-23.9l-2 0c-21.1 0-41.1 8.8-55.4 23.9-20.8-.6-41.1 7.3-56.1 22.2l-1.4 1.4c-.1 .1-.3 .3-.4 .4L96 288c-35.3 0-64-28.7-64-64z", "M96 112c0-44.2 35.8-80 80-80 35.3 0 65.3 22.9 75.9 54.7 2 5.9 7.1 10.1 13.2 10.8s12.2-2.1 15.5-7.3c9.9-15.7 27.5-26.1 47.4-26.1 30.9 0 56 25.1 56 56 0 7.4-1.4 14.4-4 20.9-2.3 5.6-1.1 12.1 2.9 16.6s10.3 6.4 16.2 4.8c5.4-1.5 11.1-2.3 16.9-2.3 35.3 0 64 28.7 64 64s-28.7 64-64 64l-45.7 0c8.9 9.1 15.3 20.1 18.8 32l26.9 0c53 0 96-43 96-96s-43-96-96-96l-.4 0c.2-2.6 .4-5.3 .4-8 0-48.6-39.4-88-88-88-21.7 0-41.5 7.9-56.9 20.9-19.8-31.7-55-52.9-95.1-52.9-61.9 0-112 50.1-112 112 0 7.1 .7 14.1 1.9 20.8-38.3 12.6-65.9 48.7-65.9 91.2 0 53 43 96 96 96l26.9 0c3.5-11.9 9.8-22.9 18.8-32L96 288c-35.3 0-64-28.7-64-64 0-32.5 24.3-59.4 55.7-63.5 4.8-.6 9.1-3.4 11.6-7.5s3-9.2 1.4-13.8C97.7 130.7 96 121.6 96 112zM32 400a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm64 0a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zm352 0a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm64 0a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM311.5 455.5A78.5 78.5 0 1 1 200.5 344.5 78.5 78.5 0 1 1 311.5 455.5zM280.3 300.5c-6-9-15.9-12.6-24.3-12.6s-18.3 3.5-24.3 12.6c-6.3 9.5-17.7 14.2-28.8 11.9-10.6-2.1-20.1 2.4-26.1 8.3s-10.4 15.4-8.3 26.1c2.2 11.1-2.5 22.5-11.9 28.8-9 6-12.6 15.9-12.6 24.3s3.5 18.3 12.6 24.3c9.5 6.3 14.2 17.7 11.9 28.8-2.1 10.6 2.4 20.1 8.3 26.1s15.5 10.4 26.1 8.3c11.1-2.2 22.5 2.5 28.8 11.9 6 9 15.9 12.6 24.3 12.6s18.3-3.5 24.3-12.6c6.3-9.5 17.7-14.2 28.8-11.9 10.6 2.1 20.1-2.4 26.1-8.3s10.4-15.5 8.3-26.1c-2.2-11.1 2.5-22.5 11.9-28.8 9-6 12.6-15.9 12.6-24.3s-3.5-18.3-12.6-24.3c-9.5-6.3-14.2-17.7-11.9-28.8 2.1-10.6-2.4-20.1-8.3-26.1s-15.5-10.4-26.1-8.3c-11.1 2.2-22.5-2.5-28.8-11.9z"]],
    "cloud-xmark": [576, 512, [], "e35f", ["M32 336c0 61.9 50.1 112 112 112l304 0c53 0 96-43 96-96 0-41.8-26.8-77.5-64.2-90.6-4.3-1.5-7.8-4.8-9.5-9.1s-1.5-9 .5-13.1c5.9-11.8 9.2-25.1 9.2-39.2 0-48.6-39.4-88-88-88-13.6 0-26.4 3.1-37.9 8.5-7.2 3.5-15.9 1-20.3-5.7-20-30.6-54.6-50.8-93.8-50.8-61.9 0-112 50.1-112 112 0 10.6 1.5 20.9 4.2 30.5 1.2 4.3 .6 8.8-1.7 12.6s-6 6.5-10.3 7.4C69.8 237.4 32 282.3 32 336zM220.7 220.7c6.2-6.2 16.4-6.2 22.6 0l44.7 44.7 44.7-44.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6l-44.7 44.7 44.7 44.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-44.7-44.7-44.7 44.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l44.7-44.7-44.7-44.7c-6.2-6.2-6.2-16.4 0-22.6z", "M128 176c0-61.9 50.1-112 112-112 39.3 0 73.8 20.2 93.8 50.8 4.4 6.7 13.1 9.1 20.3 5.7 11.4-5.5 24.3-8.5 37.9-8.5 48.6 0 88 39.4 88 88 0 14.1-3.3 27.4-9.2 39.2-2 4.1-2.2 8.9-.5 13.1s5.2 7.6 9.5 9.1c37.4 13.1 64.2 48.8 64.2 90.6 0 53-43 96-96 96l-304 0c-61.9 0-112-50.1-112-112 0-53.7 37.8-98.6 88.2-109.5 4.3-.9 8.1-3.6 10.3-7.4s2.9-8.3 1.7-12.6c-2.7-9.7-4.2-19.9-4.2-30.5zM240 32c-79.5 0-144 64.5-144 144 0 8 .7 15.9 1.9 23.5-56.9 19.2-97.9 73-97.9 136.5 0 79.5 64.5 144 144 144l304 0c70.7 0 128-57.3 128-128 0-49.9-28.5-93-70.1-114.2 3.9-11.9 6.1-24.6 6.1-37.8 0-66.3-53.7-120-120-120-13.7 0-26.9 2.3-39.2 6.5-26.4-33.2-67.1-54.5-112.8-54.5zM220.7 220.7c-6.2 6.2-6.2 16.4 0 22.6l44.7 44.7-44.7 44.7c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l44.7-44.7 44.7 44.7c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-44.7-44.7 44.7-44.7c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-44.7 44.7-44.7-44.7c-6.2-6.2-16.4-6.2-22.6 0z"]],
    "chart-area": [512, 512, ["area-chart"], "f1fe", ["M128 254l0 98 320 0 0-132.7-56-56-40.6 40.6c-6.2 6.2-14.6 9.6-23.3 9.4s-17-3.9-22.9-10.4L240 131.8 128 254z", "M32 48c0-8.8-7.2-16-16-16S0 39.2 0 48L0 400c0 44.2 35.8 80 80 80l416 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L80 448c-26.5 0-48-21.5-48-48L32 48zM305.2 202.9c5.9 6.4 14.2 10.2 22.9 10.4s17.2-3.2 23.3-9.4l40.6-40.6 56 56 0 132.7-320 0 0-98 112-122.2 65.2 71.1zm23.6-21.6c-9.8-10.7-33.5-36.5-71.1-77.5-4.5-5-11-7.8-17.7-7.8s-13.1 2.8-17.7 7.8l-120 130.9c-4.1 4.4-6.3 10.2-6.3 16.2L96 360c0 13.3 10.7 24 24 24l336 0c13.3 0 24-10.7 24-24l0-144c0-6.4-2.5-12.5-7-17l-64-64c-9.4-9.4-24.6-9.4-33.9 0-15.9 15.9-31.3 31.3-46.3 46.3z"]],
    "utility-pole-double": [512, 512, [], "e2c4", ["", "M272 16c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 80-128 0 0-48c0-8.8-7.2-16-16-16S80 39.2 80 48l0 48-15.7 0c-.2 0-.3 0-.5 0L32 96 32 48c0-8.8-7.2-16-16-16S0 39.2 0 48l0 64c0 8.8 7.2 16 16 16l43.4 0 180.6 112.9 0 47.1-128 0 0-48c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 48-15.7 0c-.2 0-.4 0-.5 0l-31.8 0 0-48c0-8.8-7.2-16-16-16S0 231.2 0 240l0 64c0 8.8 7.2 16 16 16l43.4 0 180.6 112.9 0 63.1c0 8.8 7.2 16 16 16s16-7.2 16-16l0-63.1 180.6-112.9 43.4 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 48-31.8 0c-.2 0-.3 0-.5 0l-15.7 0 0-48c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 48-128 0 0-47.1 180.6-112.9 43.4 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 48-31.8 0c-.2 0-.3 0-.5 0l-15.7 0 0-48c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 48-128 0 0-80zM392.2 128l-120.2 75.1 0-75.1 120.2 0zM240 203.1l-120.2-75.1 120.2 0 0 75.1zM392.2 320l-120.2 75.1 0-75.1 120.2 0zM240 395.1l-120.2-75.1 120.2 0 0 75.1z"]],
    "rupiah-sign": [512, 512, [], "e23d", ["", "M0 48c0-8.8 7.2-16 16-16l96 0c79.5 0 144 64.5 144 144 0 60.9-37.9 113-91.3 134.1l42.7 149.5c2.4 8.5-2.5 17.4-11 19.8s-17.4-2.5-19.8-11l-42.9-150c-7.1 1.1-14.4 1.6-21.8 1.6l-80 0 0 144c0 8.8-7.2 16-16 16S0 472.8 0 464L0 48zM32 288l80 0c61.9 0 112-50.1 112-112S173.9 64 112 64l-80 0 0 224zm288-16l0 144 80 0c44.2 0 80-35.8 80-80s-35.8-80-80-80l-64 0c-8.8 0-16 7.2-16 16zm16-48l64 0c61.9 0 112 50.1 112 112S461.9 448 400 448l-80 0 0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-256c0-26.5 21.5-48 48-48z"]],
    "diagram-nested": [448, 512, [], "e157", ["M32 80l0 96c0 8.8 7.2 16 16 16l96 0c8.8 0 16-7.2 16-16l0-96c0-8.8-7.2-16-16-16L48 64c-8.8 0-16 7.2-16 16zM288 336l0 96c0 8.8 7.2 16 16 16l96 0c8.8 0 16-7.2 16-16l0-96c0-8.8-7.2-16-16-16l-96 0c-8.8 0-16 7.2-16 16z", "M144 64c8.8 0 16 7.2 16 16l0 96c0 8.8-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16l0-96c0-8.8 7.2-16 16-16l96 0zM112 224l32 0c26.5 0 48-21.5 48-48l0-96c0-26.5-21.5-48-48-48L48 32C21.5 32 0 53.5 0 80l0 96c0 26.5 21.5 48 48 48l32 0 0 96c0 44.2 35.8 80 80 80l96 0 0 32c0 26.5 21.5 48 48 48l96 0c26.5 0 48-21.5 48-48l0-96c0-26.5-21.5-48-48-48l-96 0c-26.5 0-48 21.5-48 48l0 32-96 0c-26.5 0-48-21.5-48-48l0-96zM288 368l0-32c0-8.8 7.2-16 16-16l96 0c8.8 0 16 7.2 16 16l0 96c0 8.8-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16l0-64z"]],
    "square-quarters": [448, 512, [], "e44e", ["M32 96l0 320c0 2.9 .4 5.6 1.1 8.3L201.4 256 33.1 87.7C32.4 90.4 32 93.1 32 96zM246.6 256L414.9 424.3c.7-2.6 1.1-5.4 1.1-8.3l0-320c0-2.9-.4-5.6-1.1-8.3L246.6 256z", "M55.7 65.1L224 233.4 392.3 65.1c-2.6-.7-5.4-1.1-8.3-1.1L64 64c-2.9 0-5.6 .4-8.3 1.1zM33.1 87.7C32.4 90.4 32 93.1 32 96l0 320c0 2.9 .4 5.6 1.1 8.3L201.4 256 33.1 87.7zM55.7 446.9c2.6 .7 5.4 1.1 8.3 1.1l320 0c2.9 0 5.6-.4 8.3-1.1L224 278.6 55.7 446.9zm359.2-22.6c.7-2.6 1.1-5.4 1.1-8.3l0-320c0-2.9-.4-5.6-1.1-8.3L246.6 256 414.9 424.3zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96z"]],
    "print-slash": [576, 512, [], "f686", ["M278.5 224L480 224c17.7 0 32 14.3 32 32l0 128-73.5 0-160-160zM448 272a16 16 0 1 0 32 0 16 16 0 1 0 -32 0z", "M27.3-27.2c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l544 544c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L470.5 416 512 416c17.7 0 32-14.3 32-32l0-128c0-35.3-28.7-64-64-64l-233.5 0-86.5-86.5 0-41.5c0-17.7 14.3-32 32-32l149.5 0c8.5 0 16.6 3.4 22.6 9.4l42.5 42.5c6 6 9.4 14.1 9.4 22.6l0 37.5 32 0 0-37.5c0-17-6.7-33.3-18.7-45.3L386.7 18.7C374.7 6.7 358.5 0 341.5 0L192 0c-35.3 0-64 28.7-64 64l0 9.5-100.7-100.7zM278.5 224L480 224c17.7 0 32 14.3 32 32l0 128-73.5 0-160-160zM96 192c-35.3 0-64 28.7-64 64l0 128c0 17.7 14.3 32 32 32l64 0 0 64c0 17.7 14.3 32 32 32l256 0c10.2 0 19.4-4.8 25.2-12.3l-19.7-19.7-261.5 0 0-128 133.5 0-32-32-101.5 0c-17.7 0-32 14.3-32 32l0 32-64 0 0-128c0-17.7 14.3-32 32-32l69.5 0-32-32-37.5 0zm384 80a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"]],
    "shield-keyhole": [512, 512, [], "e248", ["M48 139.8c.5 94 39.3 259.8 195.4 334.5 7.9 3.8 17.2 3.8 25.1 0 156.1-74.7 195-240.4 195.5-334.5 .1-12.1-7.5-22.8-18.8-27.6l-176.7-75c-8-3.4-17-3.4-25 0l-176.7 75C55.5 117 48 127.7 48 139.8zM200 208c0-30.9 25.1-56 56-56s56 25.1 56 56c0 25.4-16.9 46.8-40 53.7l0 74.3c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-74.3c-23.1-6.9-40-28.3-40-53.7z", "M243.6 37.3c8-3.4 17-3.4 25 0l176.7 75c11.3 4.8 18.9 15.5 18.8 27.6-.5 94-39.4 259.8-195.5 334.5-7.9 3.8-17.2 3.8-25.1 0-156.1-74.7-195-240.4-195.4-334.5-.1-12.1 7.5-22.8 18.8-27.6l176.7-75zM281.1 7.8c-16-6.8-34-6.8-50 0L54.3 82.8c-22 9.3-38.4 31-38.3 57.2 .5 99.2 41.3 280.7 213.6 363.2 16.7 8 36.1 8 52.8 0 172.4-82.5 213.2-264 213.6-363.2 .1-26.2-16.3-47.9-38.3-57.2L281.1 7.8zM256 184a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm56 24c0-30.9-25.1-56-56-56s-56 25.1-56 56c0 25.4 16.9 46.8 40 53.7l0 74.3c0 8.8 7.2 16 16 16s16-7.2 16-16l0-74.3c23.1-6.9 40-28.3 40-53.7z"]],
    "square-left": [448, 512, [11013, "arrow-alt-square-left"], "f351", ["M32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64C46.3 64 32 78.3 32 96zM95 239L199 135c6.9-6.9 17.2-8.9 26.2-5.2S240 142.3 240 152l0 40 72 0c22.1 0 40 17.9 40 40l0 48c0 22.1-17.9 40-40 40l-72 0 0 40c0 9.7-5.8 18.5-14.8 22.2s-19.3 1.7-26.2-5.2L95 273c-9.4-9.4-9.4-24.6 0-33.9z", "M32 416c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64C46.3 64 32 78.3 32 96l0 320zm32 64c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480zM208 340.7l0-36.7c0-8.8 7.2-16 16-16l88 0c4.4 0 8-3.6 8-8l0-48c0-4.4-3.6-8-8-8l-88 0c-8.8 0-16-7.2-16-16l0-36.7-84.7 84.7 84.7 84.7zM199 135c6.9-6.9 17.2-8.9 26.2-5.2S240 142.3 240 152l0 40 72 0c22.1 0 40 17.9 40 40l0 48c0 22.1-17.9 40-40 40l-72 0 0 40c0 9.7-5.8 18.5-14.8 22.2s-19.3 1.7-26.2-5.2L95 273c-9.4-9.4-9.4-24.6 0-33.9L199 135z"]],
    "text-width": [448, 512, [], "f035", ["", "M40 0C17.9 0 0 17.9 0 40l0 72c0 8.8 7.2 16 16 16s16-7.2 16-16l0-72c0-4.4 3.6-8 8-8l168 0 0 224-64 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l160 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-64 0 0-224 168 0c4.4 0 8 3.6 8 8l0 72c0 8.8 7.2 16 16 16s16-7.2 16-16l0-72c0-22.1-17.9-40-40-40L40 0zm67.3 379.3c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-80 80c-6.2 6.2-6.2 16.4 0 22.6l80 80c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-52.7-52.7 338.7 0-52.7 52.7c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l80-80c6.2-6.2 6.2-16.4 0-22.6l-80-80c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l52.7 52.7-338.7 0 52.7-52.7z"]],
    "circle-currency": [512, 512, [], "e6ee", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zM148.7 148.7c6.2-6.2 16.4-6.2 22.6 0l29.1 29.1C216.1 166.6 235.3 160 256 160s39.9 6.6 55.6 17.7l29.1-29.1c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6l-29.1 29.1C345.4 216.1 352 235.3 352 256s-6.6 39.9-17.7 55.6l29.1 29.1c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-29.1-29.1C295.9 345.4 276.7 352 256 352s-39.9-6.6-55.6-17.7l-29.1 29.1c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l29.1-29.1C166.6 295.9 160 276.7 160 256s6.6-39.9 17.7-55.6l-29.1-29.1c-6.2-6.2-6.2-16.4 0-22.6zM192 256a64 64 0 1 0 128 0 64 64 0 1 0 -128 0z", "M256 32a224 224 0 1 1 0 448 224 224 0 1 1 0-448zm0 480a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM148.7 148.7c-6.2 6.2-6.2 16.4 0 22.6l29.1 29.1C166.6 216.1 160 235.3 160 256s6.6 39.9 17.7 55.6l-29.1 29.1c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l29.1-29.1C216.1 345.4 235.3 352 256 352s39.9-6.6 55.6-17.7l29.1 29.1c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-29.1-29.1C345.4 295.9 352 276.7 352 256s-6.6-39.9-17.7-55.6l29.1-29.1c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-29.1 29.1C295.9 166.6 276.7 160 256 160s-39.9 6.6-55.6 17.7l-29.1-29.1c-6.2-6.2-16.4-6.2-22.6 0zM256 192a64 64 0 1 1 0 128 64 64 0 1 1 0-128z"]],
    "signature-lock": [576, 512, [], "e3ca", ["M384 368c0-8.2 6.2-15 14.3-15.9l131.5 0c8 .9 14.3 7.7 14.3 15.9l0 96c0 8.8-7.2 16-16 16l-128 0c-8.8 0-16-7.2-16-16l0-96z", "M160 64c-35.3 0-64 28.7-64 64l0 48c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-48c0-53 43-96 96-96s96 43 96 96l0 3.4c0 21-1.4 42-4.3 62.8l111.7-33.5c6.1-1.8 12.7 .1 16.8 5 1.7 2 2.8 4.3 3.3 6.7-29 23.5-47.6 59.4-47.6 99.6l0 24.4c-7.6 6.8-14.1 14.8-19.2 23.6L304 320c-5.5 0-10.7-2.9-13.6-7.6s-3.2-10.6-.7-15.6l47.4-94.9-91.7 27.5c-1.8 8.5-3.9 16.9-6.2 25.2L232 280.4c-11.4 41-27.7 80.5-48.5 117.5l-27.1 48.1C144.6 467 122.5 480 98.5 480 61.8 480 32 450.2 32 413.5l0-93.9c0-35.3 23.2-66.5 57-76.6l128.7-38.6c4.2-24.1 6.3-48.5 6.3-73l0-3.4c0-35.3-28.7-64-64-64zM304 416l-75.6 0c5.8-10.5 11.2-21.2 16.3-32l59.3 0 0 32zM210 240.1L98.2 273.6c-20.3 6.1-34.2 24.8-34.2 46l0 93.9c0 19 15.4 34.5 34.5 34.5 12.5 0 23.9-6.7 30.1-17.6l27.1-48.1c19.6-34.8 34.9-71.9 45.6-110.4l7.2-25.7c.6-2 1.1-4 1.6-6zm174 80l0-48c0-44.2 35.8-80 80-80s80 35.8 80 80l0 50.6c18.6 6.6 32 24.4 32 45.3l0 96c0 26.5-21.5 48-48 48l-128 0c-26.5 0-48-21.5-48-48l0-96c0-20.9 13.4-38.7 32-45.3l0-2.6zm0 47.9l0 96c0 8.8 7.2 16 16 16l128 0c8.8 0 16-7.2 16-16l0-96c0-8.2-6.2-15-14.3-15.9l-131.5 0c-8 .9-14.3 7.7-14.3 15.9zm128-95.9c0-26.5-21.5-48-48-48s-48 21.5-48 48l0 47.9 96 0 0-47.9z"]],
    "satellite": [512, 512, [128752], "f7bf", ["M38.9 257.6c21.9-11.3 46.7-17.6 73.1-17.6 88.4 0 160 71.6 160 160 0 26.4-6.4 51.2-17.6 73.1L38.9 257.6zm162.9-27.4L381.1 50.9c2.3 .2 4.7 .6 6.9 1.1l72.8 72.8c.4 1.8 .8 3.5 1 5.3L281.8 310.2c-18-34-46-62-80-80z", "M216 35.3l67.7 67.7-84.7 84.7-67.7-67.7 84.7-84.7zm90.3 45.1L233 7c-9.4-9.4-24.6-9.4-33.9 0l-96 96c-9.4 9.4-9.4 24.6 0 33.9l73.4 73.4-6.5 6.5c-18.3-5.8-37.7-8.9-57.9-8.9-40.6 0-78.3 12.6-109.4 34.2-7.7 5.4-8.2 16.3-1.5 23l111.6 111.6-60 60c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l60-60 111.6 111.6c6.6 6.6 17.6 6.2 23-1.5 21.5-31 34.2-68.7 34.2-109.4 0-20.2-3.1-39.6-8.9-57.9l6.5-6.5 73.4 73.4c9.4 9.4 24.6 9.4 33.9 0l96-96c9.4-9.4 9.4-24.6 0-33.9l-73.4-73.4 55-55c12.5-12.5 12.5-32.8 0-45.3l-80-80c-12.5-12.5-32.8-12.5-45.3 0l-55 55zM409 228.3L476.7 296 392 380.7 324.3 313 409 228.3zM384 48l80 80-182.2 182.2c-18-34-46-62-80-80L384 48zM272 400c0 26.4-6.4 51.2-17.6 73.1L38.9 257.6c21.9-11.3 46.7-17.6 73.1-17.6 88.4 0 160 71.6 160 160z"]],
    "ball-pile": [640, 512, [], "f77e", ["M56 432a56 56 0 1 0 112 0 56 56 0 1 0 -112 0zM160 256a56 56 0 1 0 112 0 56 56 0 1 0 -112 0zM264 80a56 56 0 1 0 112 0 56 56 0 1 0 -112 0zm0 352a56 56 0 1 0 112 0 56 56 0 1 0 -112 0zM368 256a56 56 0 1 0 112 0 56 56 0 1 0 -112 0zM472 432a56 56 0 1 0 112 0 56 56 0 1 0 -112 0z", "M112 520a88 88 0 1 1 0-176 88 88 0 1 1 0 176zm208 0a88 88 0 1 1 0-176 88 88 0 1 1 0 176zm208 0a88 88 0 1 1 0-176 88 88 0 1 1 0 176zm0-144a56 56 0 1 0 0 112 56 56 0 1 0 0-112zm-416 0a56 56 0 1 0 0 112 56 56 0 1 0 0-112zm208 0a56 56 0 1 0 0 112 56 56 0 1 0 0-112zM216 344a88 88 0 1 1 0-176 88 88 0 1 1 0 176zm208 0a88 88 0 1 1 0-176 88 88 0 1 1 0 176zM216 200a56 56 0 1 0 0 112 56 56 0 1 0 0-112zm208 0a56 56 0 1 0 0 112 56 56 0 1 0 0-112zM320 168a88 88 0 1 1 0-176 88 88 0 1 1 0 176zm0-144a56 56 0 1 0 0 112 56 56 0 1 0 0-112z"]],
    "seats": [512, 512, [], "e765", ["M32 304c0-8.8 7.2-16 16-16l416 0c8.8 0 16 7.2 16 16l0 48c0 8.8-7.2 16-16 16L48 368c-8.8 0-16-7.2-16-16l0-48zM64 64c0-10.5 5-19.8 12.8-25.6 6-3.3 12.8-5.5 19.9-6.4L208 32c17.7 0 32 14.3 32 32l0 192-176 0 0-192zm208 0c0-17.7 14.3-32 32-32l111.4 0c7 .9 13.6 3 19.6 6.2 7.9 5.8 13 15.2 13 25.8l0 192-176 0 0-192z", "M96 32C78.3 32 64 46.3 64 64l0 192 176 0 0-192c0-17.7-14.3-32-32-32L96 32zM448 256l0-192c0-17.7-14.3-32-32-32L304 32c-17.7 0-32 14.3-32 32l0 192 176 0zm32 0l0 2.7c18.6 6.6 32 24.4 32 45.3l0 48c0 20.9-13.4 38.7-32 45.3l0 98.7c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-96-176 0 0 96c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-96-176 0 0 96c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-98.7C13.4 390.7 0 372.9 0 352l0-48c0-20.9 13.4-38.7 32-45.3L32 64C32 28.7 60.7 0 96 0L208 0C227.1 0 244.3 8.4 256 21.7 267.7 8.4 284.9 0 304 0L416 0c35.3 0 64 28.7 64 64l0 192zM48 368l416 0c8.8 0 16-7.2 16-16l0-48c0-8.8-7.2-16-16-16L48 288c-8.8 0-16 7.2-16 16l0 48c0 8.8 7.2 16 16 16z"]],
    "file-eps": [576, 512, [], "e644", ["M64 64c0-17.7 14.3-32 32-32l128 0 0 96c0 35.3 28.7 64 64 64l96 0 0 144-152 0c-30.9 0-56 25.1-56 56l0 88-80 0c-17.7 0-32-14.3-32-32L64 64z", "M224 32L96 32C78.3 32 64 46.3 64 64l0 384c0 17.7 14.3 32 32 32l80 0 0 32-80 0c-35.3 0-64-28.7-64-64L32 64C32 28.7 60.7 0 96 0L229.5 0c17 0 33.3 6.7 45.3 18.7L397.3 141.3c12 12 18.7 28.3 18.7 45.3l0 149.5-32 0 0-144-96 0c-35.3 0-64-28.7-64-64l0-96zM370.7 160L256 45.3 256 128c0 17.7 14.3 32 32 32l82.7 0zM240 384l64 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-48 0 0 32 32 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-32 0 0 32 48 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-64 0c-8.8 0-16-7.2-16-16l0-128c0-8.8 7.2-16 16-16zm128 0l32 0c30.9 0 56 25.1 56 56s-25.1 56-56 56l-16 0 0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-128c0-8.8 7.2-16 16-16zm32 80c13.3 0 24-10.7 24-24s-10.7-24-24-24l-16 0 0 48 16 0zm80-34.3c0-25.2 20.4-45.7 45.7-45.7l26.3 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-26.3 0c-7.5 0-13.7 6.1-13.7 13.7 0 5.2 2.9 9.9 7.6 12.2l31.2 15.6c15.5 7.7 25.2 23.5 25.2 40.8 0 25.2-20.4 45.7-45.7 45.7L496 544c-8.8 0-16-7.2-16-16s7.2-16 16-16l34.3 0c7.5 0 13.7-6.1 13.7-13.7 0-5.2-2.9-9.9-7.6-12.2l-31.2-15.6C489.8 462.8 480 447 480 429.7z"]],
    "magnifying-glass-minus": [512, 512, ["search-minus"], "f010", ["M32 208a176 176 0 1 0 352 0 176 176 0 1 0 -352 0zm80 0c0-8.8 7.2-16 16-16l160 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-160 0c-8.8 0-16-7.2-16-16z", "M208 32a176 176 0 1 1 0 352 176 176 0 1 1 0-352zm0 384c51.7 0 99-18.8 135.3-50L484.7 507.3c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L366 343.3C397.2 307 416 259.7 416 208 416 93.1 322.9 0 208 0S0 93.1 0 208 93.1 416 208 416zM128 192c-8.8 0-16 7.2-16 16s7.2 16 16 16l160 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-160 0z"]],
    "vent-damper": [640, 512, [], "e465", ["M32 192l0 128 32 0 0-128-32 0zm64-64l0 256c0 17.7 14.3 32 32 32l384 0c17.7 0 32-14.3 32-32l0-256c0-17.7-14.3-32-32-32L128 96c-17.7 0-32 14.3-32 32zm64 48c0-8.8 7.2-16 16-16l288 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-288 0c-8.8 0-16-7.2-16-16zm0 80c0-8.8 7.2-16 16-16l288 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-288 0c-8.8 0-16-7.2-16-16zm0 80c0-8.8 7.2-16 16-16l288 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-288 0c-8.8 0-16-7.2-16-16zM576 192l0 128 32 0 0-128-32 0z", "M512 96c17.7 0 32 14.3 32 32l0 256c0 17.7-14.3 32-32 32l-384 0c-17.7 0-32-14.3-32-32l0-256c0-17.7 14.3-32 32-32l384 0zM64 128l0 32-32 0c-17.7 0-32 14.3-32 32L0 320c0 17.7 14.3 32 32 32l32 0 0 32c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-32 32 0c17.7 0 32-14.3 32-32l0-128c0-17.7-14.3-32-32-32l-32 0 0-32c0-35.3-28.7-64-64-64L128 64c-35.3 0-64 28.7-64 64zm0 64l0 128-32 0 0-128 32 0zM608 320l-32 0 0-128 32 0 0 128zM176 160c-8.8 0-16 7.2-16 16s7.2 16 16 16l288 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-288 0zm0 80c-8.8 0-16 7.2-16 16s7.2 16 16 16l288 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-288 0zm0 80c-8.8 0-16 7.2-16 16s7.2 16 16 16l288 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-288 0z"]],
    "people-group": [512, 512, [], "e533", ["M176 288l0 16c0 23.7 10.3 45 26.7 59.6 3.4 3 5.3 7.4 5.3 11.9l0 80.4c0 13.3 10.7 24 24 24l48 0c13.3 0 24-10.7 24-24l0-80.4c0-4.6 1.9-8.9 5.3-11.9 16.4-14.7 26.7-35.9 26.7-59.6l0-16c0-44.2-35.8-80-80-80s-80 35.8-80 80zM224 64a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M288 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm-96 0a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zM96 112a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm0-80a56 56 0 1 1 0 112 56 56 0 1 1 0-112zm320 80a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm0-80a56 56 0 1 1 0 112 56 56 0 1 1 0-112zM127.2 193c-7.1 9.6-13.1 20-17.9 31-42.9 1.4-77.3 36.7-77.3 80 0 23.7 10.3 45 26.7 59.6 3.4 3 5.3 7.4 5.3 11.9L64 464c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-81.6c-19.8-20.2-32-47.9-32-78.4 0-61.9 50.1-112 112-112 5.2 0 10.2 .3 15.2 1zm275.5 31c-4.8-11-10.9-21.4-17.9-31 5-.7 10.1-1 15.2-1 61.9 0 112 50.1 112 112 0 30.5-12.2 58.2-32 78.4l0 81.6c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-88.4c0-4.6 1.9-8.9 5.3-11.9 16.4-14.7 26.7-35.9 26.7-59.6 0-43.3-34.4-78.5-77.3-80zM256 208c-44.2 0-80 35.8-80 80l0 16c0 23.7 10.3 45 26.7 59.6 3.4 3 5.3 7.4 5.3 11.9l0 80.4c0 13.3 10.7 24 24 24l48 0c13.3 0 24-10.7 24-24l0-80.4c0-4.6 1.9-8.9 5.3-11.9 16.4-14.7 26.7-35.9 26.7-59.6l0-16c0-44.2-35.8-80-80-80zM144 288c0-61.9 50.1-112 112-112s112 50.1 112 112l0 16c0 30.5-12.2 58.2-32 78.4l0 73.6c0 30.9-25.1 56-56 56l-48 0c-30.9 0-56-25.1-56-56l0-73.6c-19.8-20.2-32-47.9-32-78.4l0-16z"]],
    "square-quote": [448, 512, [], "e329", ["M32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64C46.3 64 32 78.3 32 96zM96 200c0-22.1 17.9-40 40-40l32 0c22.1 0 40 17.9 40 40l0 86.4c0 31.8-23.4 58.9-54.9 63.4l-14.8 2.1c-8.7 1.3-16.9-4.8-18.1-13.6s4.8-16.9 13.6-18.1l14.8-2.1c15.8-2.2 27.5-15.8 27.5-31.7l0-15.2c-2.6 .5-5.3 .8-8 .8l-32 0c-22.1 0-40-17.9-40-40l0-32zm32 0l0 32c0 4.4 3.6 8 8 8l32 0c4.4 0 8-3.6 8-8l0-32c0-4.4-3.6-8-8-8l-32 0c-4.4 0-8 3.6-8 8zm112 0c0-22.1 17.9-40 40-40l32 0c22.1 0 40 17.9 40 40l0 86.4c0 31.8-23.4 58.9-55 63.4l-14.8 2.1c-8.7 1.3-16.9-4.8-18.1-13.6s4.8-16.9 13.6-18.1l14.8-2.1c15.8-2.2 27.5-15.8 27.5-31.7l0-15.2c-2.6 .5-5.3 .8-8 .8l-32 0c-22.1 0-40-17.9-40-40l0-32zm32 0l0 32c0 4.4 3.6 8 8 8l32 0c4.4 0 8-3.6 8-8l0-32c0-4.4-3.6-8-8-8l-32 0c-4.4 0-8 3.6-8 8z", "M384 64c17.7 0 32 14.3 32 32l0 320c0 17.7-14.3 32-32 32L64 448c-17.7 0-32-14.3-32-32L32 96c0-17.7 14.3-32 32-32l320 0zM64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM208 286.4l0-86.4c0-22.1-17.9-40-40-40l-32 0c-22.1 0-40 17.9-40 40l0 32c0 22.1 17.9 40 40 40l32 0c2.7 0 5.4-.3 8-.8l0 15.2c0 15.9-11.7 29.4-27.5 31.7l-14.8 2.1c-8.7 1.2-14.8 9.4-13.6 18.1s9.4 14.8 18.1 13.6l14.8-2.1c31.5-4.5 54.9-31.5 54.9-63.4zM176 232c0 4.4-3.6 8-8 8l-32 0c-4.4 0-8-3.6-8-8l0-32c0-4.4 3.6-8 8-8l32 0c4.4 0 8 3.6 8 8l0 32zm176 0l0-32c0-22.1-17.9-40-40-40l-32 0c-22.1 0-40 17.9-40 40l0 32c0 22.1 17.9 40 40 40l32 0c2.7 0 5.4-.3 8-.8l0 15.2c0 15.9-11.7 29.4-27.5 31.7l-14.8 2.1c-8.7 1.2-14.8 9.4-13.6 18.1s9.4 14.8 18.1 13.6l14.8-2.1c31.5-4.5 55-31.5 55-63.4l0-54.4zm-32-16l0 16c0 4.4-3.6 8-8 8l-32 0c-4.4 0-8-3.6-8-8l0-32c0-4.4 3.6-8 8-8l32 0c4.4 0 8 3.6 8 8l0 16z"]],
    "square-binary": [448, 512, [], "e69b", ["M32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64C46.3 64 32 78.3 32 96zm80 56c0-22.1 17.9-40 40-40l32 0c22.1 0 40 17.9 40 40l0 48c0 22.1-17.9 40-40 40l-32 0c-22.1 0-40-17.9-40-40l0-48zm8 144c0-8.8 7.2-16 16-16l24 0c8.8 0 16 7.2 16 16l0 96c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80-8 0c-8.8 0-16-7.2-16-16zm24-144l0 48c0 4.4 3.6 8 8 8l32 0c4.4 0 8-3.6 8-8l0-48c0-4.4-3.6-8-8-8l-32 0c-4.4 0-8 3.6-8 8zm80 168c0-22.1 17.9-40 40-40l32 0c22.1 0 40 17.9 40 40l0 48c0 22.1-17.9 40-40 40l-32 0c-22.1 0-40-17.9-40-40l0-48zm32 0l0 48c0 4.4 3.6 8 8 8l32 0c4.4 0 8-3.6 8-8l0-48c0-4.4-3.6-8-8-8l-32 0c-4.4 0-8 3.6-8 8zm8-192c0-8.8 7.2-16 16-16l24 0c8.8 0 16 7.2 16 16l0 96c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80-8 0c-8.8 0-16-7.2-16-16z", "M384 64c17.7 0 32 14.3 32 32l0 320c0 17.7-14.3 32-32 32L64 448c-17.7 0-32-14.3-32-32L32 96c0-17.7 14.3-32 32-32l320 0zM64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm48 120l0 48c0 22.1 17.9 40 40 40l32 0c22.1 0 40-17.9 40-40l0-48c0-22.1-17.9-40-40-40l-32 0c-22.1 0-40 17.9-40 40zm40-8l32 0c4.4 0 8 3.6 8 8l0 48c0 4.4-3.6 8-8 8l-32 0c-4.4 0-8-3.6-8-8l0-48c0-4.4 3.6-8 8-8zM264 280c-22.1 0-40 17.9-40 40l0 48c0 22.1 17.9 40 40 40l32 0c22.1 0 40-17.9 40-40l0-48c0-22.1-17.9-40-40-40l-32 0zm-8 40c0-4.4 3.6-8 8-8l32 0c4.4 0 8 3.6 8 8l0 48c0 4.4-3.6 8-8 8l-32 0c-4.4 0-8-3.6-8-8l0-48zM120 296c0 8.8 7.2 16 16 16l8 0 0 80c0 8.8 7.2 16 16 16s16-7.2 16-16l0-96c0-8.8-7.2-16-16-16l-24 0c-8.8 0-16 7.2-16 16zM280 112c-8.8 0-16 7.2-16 16s7.2 16 16 16l8 0 0 80c0 8.8 7.2 16 16 16s16-7.2 16-16l0-96c0-8.8-7.2-16-16-16l-24 0z"]],
    "masks-theater": [640, 512, [127917, "theater-masks"], "f630", ["M256.2 125.7l0 171.8c0 74 46.3 140.1 115.9 165.4L399.8 473c10.6 3.9 22.2 3.9 32.8 0l27.7-10.1c69.6-25.3 115.9-91.4 115.9-165.4l0-171.8c0-3.8-1.2-6.2-2.4-7.5-19.6-20-71.1-54.2-157.6-54.2s-138 34.2-157.6 54.2c-1.2 1.3-2.4 3.7-2.4 7.5zm34.4 187.1c-2.2-11.3 3.9-20.8 12.2-25 7.9-4 18-3.5 25.9 2.6 24.2 18.6 54.5 29.6 87.5 29.6s63.2-11 87.5-29.6c7.9-6.1 18-6.5 25.9-2.6 8.3 4.2 14.5 13.6 12.2 25-11.6 58.8-63.4 103.2-125.6 103.2s-114-44.4-125.6-103.2zm5.6-95.2c8.6-19.7 28.3-33.6 51.3-33.6s42.7 13.8 51.3 33.6c3.5 8.1-.2 17.5-8.3 21.1s-17.5-.2-21.1-8.3c-3.7-8.5-12.2-14.4-22-14.4s-18.3 5.9-22 14.4c-3.5 8.1-13 11.8-21.1 8.3s-11.8-13-8.3-21.1zm137.3 0c8.6-19.7 28.3-33.6 51.3-33.6s42.7 13.8 51.3 33.6c3.5 8.1-.2 17.5-8.3 21.1s-17.5-.2-21.1-8.3c-3.7-8.5-12.2-14.4-22-14.4s-18.3 5.9-22 14.4c-3.5 8.1-13 11.8-21.1 8.3s-11.8-13-8.3-21.1z", "M176.2 157.7l0 36.7c-5.4-5.6-13.3-8.5-21.5-7.1-9.7 1.7-17 9-19.2 18-2.1 8.6-10.7 13.9-19.3 11.8s-13.9-10.7-11.8-19.3c5.1-20.9 22.1-38 44.7-42 9.4-1.7 18.6-.9 27.1 1.9zm0 103.2l0 38.5c0 2.6 0 5.2 .1 7.7-4.8 7.5-8.3 15.7-10.5 24.4l12.1-2.1c1.3 10.7 3.2 21.2 5.7 31.5l-14.7 2.6c-18.3 3.2-39.8-11.2-35.4-34.3 5.3-27.3 20.6-51.7 42.6-68.3zM215.7 436c8.4 13.2 17.9 25.7 28.6 37.2-2.3-.2-4.6-.5-6.9-.9l-29.1-5.1C122.2 452 54.8 384.6 39.6 298.5L9.7 129.3c-1.7-9.9-.6-21.5 6.2-31.4 20.6-30.1 72.8-77.7 166.6-94.2 44.4-7.8 82.5-5.9 113.4 .5-20.9 7.6-39 16.7-54.4 26.4-16.3-.1-34.1 1.2-53.4 4.6-85.2 15-130 57.7-145.8 80.8-1 1.5-1.7 4-1.1 7.8L71.1 292.9C83.9 365.8 141 422.9 213.9 435.7l1.8 .3zm20-340.2C261.3 69.8 321 32 416.2 32S571.2 69.8 596.7 95.8c8.5 8.6 11.5 19.8 11.5 29.9l0 171.8c0 87.5-54.7 165.6-136.9 195.5l-27.7 10.1c-17.7 6.4-37 6.4-54.7 0L361.1 493c-82.2-29.9-136.9-108-136.9-195.5l0-171.8c0-10 3.1-21.3 11.5-29.9zM416.2 64c-86.5 0-138 34.2-157.6 54.2-1.2 1.3-2.4 3.7-2.4 7.5l0 171.8c0 74 46.3 140.1 115.9 165.4L399.8 473c10.6 3.9 22.2 3.9 32.8 0l27.7-10.1c69.6-25.3 115.9-91.4 115.9-165.4l0-171.8c0-3.8-1.2-6.2-2.4-7.5-19.6-20-71.1-54.2-157.6-54.2zm0 320c38.3 0 71.3-22.4 86.8-54.8-25.6 14.5-55.2 22.8-86.8 22.8s-61.2-8.3-86.8-22.8c15.4 32.4 48.5 54.8 86.8 54.8zm-87.5-93.6C353 309 383.3 320 416.2 320s63.2-11 87.5-29.6c7.9-6.1 18-6.5 25.9-2.6 8.3 4.2 14.5 13.6 12.2 25-11.6 58.8-63.4 103.2-125.6 103.2s-114-44.4-125.6-103.2c-2.2-11.3 3.9-20.8 12.2-25 7.9-4 18-3.5 25.9 2.6zM347.5 216c-9.8 0-18.3 5.9-22 14.4-3.5 8.1-13 11.8-21.1 8.3s-11.8-13-8.3-21.1c8.6-19.7 28.3-33.6 51.3-33.6s42.7 13.8 51.3 33.6c3.5 8.1-.2 17.5-8.3 21.1s-17.5-.2-21.1-8.3c-3.7-8.5-12.2-14.4-22-14.4zm115.3 14.4c-3.5 8.1-13 11.8-21.1 8.3s-11.8-13-8.3-21.1c8.6-19.7 28.3-33.6 51.3-33.6s42.7 13.8 51.3 33.6c3.5 8.1-.2 17.5-8.3 21.1s-17.5-.2-21.1-8.3c-3.7-8.5-12.2-14.4-22-14.4s-18.3 5.9-22 14.4z"]],
    "house-turret": [576, 512, [], "e1b4", ["M64 259.3L64 448c0 17.7 14.3 32 32 32l224 0c17.7 0 32-14.3 32-32l0-188.7-144-126-144 126zM152 296c0-17.7 14.3-32 32-32l48 0c17.7 0 32 14.3 32 32l0 48c0 17.7-14.3 32-32 32l-48 0c-17.7 0-32-14.3-32-32l0-48z", "M304 32l48 0 0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48 64 0 0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48 48 0c8.8 0 16 7.2 16 16l0 400c0 17.7-14.3 32-32 32l-84.6 0c-3.4 11.6-8.7 22.3-15.4 32L512 512c35.3 0 64-28.7 64-64l0-400c0-26.5-21.5-48-48-48L304 0c-26.5 0-48 21.5-48 48l0 21 32 28 0-49c0-8.8 7.2-16 16-16zm-85.5 68c-6-5.3-15-5.3-21.1 0L5.5 268c-6.7 5.8-7.3 15.9-1.5 22.6s15.9 7.3 22.6 1.5L32 287.3 32 448c0 35.3 28.7 64 64 64l224 0c35.3 0 64-28.7 64-64l0-160.7 5.5 4.8c6.6 5.8 16.8 5.1 22.6-1.5s5.1-16.8-1.5-22.6l-192-168zM352 259.3L352 448c0 17.7-14.3 32-32 32L96 480c-17.7 0-32-14.3-32-32l0-188.7 144-126 144 126zM152 296l0 48c0 17.7 14.3 32 32 32l48 0c17.7 0 32-14.3 32-32l0-48c0-17.7-14.3-32-32-32l-48 0c-17.7 0-32 14.3-32 32zm32 0l48 0 0 48-48 0 0-48z"]],
    "cart-plus": [640, 512, [], "f217", ["M106.3 31.3l197.7 0 0 48.7-56 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l56 0 0 56c0 8.8 7.2 16 16 16s16-7.2 16-16l0-56 56 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-56 0 0-48.7 232.2 0-.5 2.7c-1.3-.7-2.8-1.3-4.3-1.6-8.6-1.9-17.1 3.7-19 12.3L505.8 224.4c-4 18.4-20.2 31.6-39.1 31.6l-318.8 0-39.4-216.6c-.5-2.8-1.3-5.5-2.2-8.1zM228 460a20 20 0 1 1 -40 0 20 20 0 1 1 40 0zm224 0a20 20 0 1 1 -40 0 20 20 0 1 1 40 0z", "M0 16C0 7.2 7.2 0 16 0L61.3 0c23.2 0 43.1 16.6 47.2 39.4l39.4 216.6 318.8 0c18.9 0 35.2-13.2 39.1-31.6L544.4 44.6c1.9-8.6 10.4-14.1 19-12.3s14.1 10.4 12.3 19L537.1 231.1C530 264.3 500.7 288 466.7 288l-313 0 5.7 31.2c3.5 19 20 32.8 39.4 32.8L464 352c8.8 0 16 7.2 16 16s-7.2 16-16 16l-265.3 0c-34.8 0-64.6-24.9-70.8-59.1L77 45.1C75.7 37.5 69 32 61.3 32L16 32C7.2 32 0 24.8 0 16zM208 480a20 20 0 1 0 0-40 20 20 0 1 0 0 40zm0-72a52 52 0 1 1 0 104 52 52 0 1 1 0-104zm244 52a20 20 0 1 0 -40 0 20 20 0 1 0 40 0zm-72 0a52 52 0 1 1 104 0 52 52 0 1 1 -104 0zM304 168l0-56-56 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l56 0 0-56c0-8.8 7.2-16 16-16s16 7.2 16 16l0 56 56 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-56 0 0 56c0 8.8-7.2 16-16 16s-16-7.2-16-16z"]],
    "hands-asl-interpreting": [640, 512, ["american-sign-language-interpreting", "asl-interpreting", "hands-american-sign-language-interpreting"], "f2a3", ["M32 256c0 53 43 96 96 96l80 0c29.6 0 55.5-16.1 69.3-40 4.4-7.6 1.8-17.4-5.8-21.9-2.5-1.4-5.1-2.1-7.7-2.2-.4 0-.5 0-.6 0-5.5 .1-10.7 3-13.6 8-8.3 14.4-23.9 24-41.6 24-26.5 0-48-21.5-48-48s21.5-48 48-48c17.7 0 33.3 9.6 41.6 24 2.9 5 8.1 7.9 13.6 8 .4 0 .5 0 .6 0 2.6 0 5.2-.7 7.7-2.2 7.6-4.4 10.3-14.2 5.8-21.9-8.6-14.9-22-26.8-38-33.7-6.3-2.7-10.2-9.1-9.7-16s5.4-12.6 12.1-14.3l66.3-16.6c8.6-2.1 13.8-10.8 11.6-19.4s-10.8-13.8-19.4-11.6l-89.8 22.4c-7.3 1.8-14.9-1.7-18.3-8.5s-1.4-15 4.5-19.6l69.3-54.2c7-5.4 8.2-15.5 2.7-22.5s-15.5-8.2-22.5-2.7l-93.6 73.3c-5.7 4.5-13.8 4.5-19.6 .1s-7.9-12.2-5.1-18.9l14.9-35.8c3.4-8.2-.5-17.5-8.6-20.9s-17.5 .5-20.9 8.6L39.4 219.1C34.5 230.8 32 243.3 32 256zM320.5 379.9c2.1 8.6 10.8 13.8 19.4 11.6l89.8-22.4c7.3-1.8 14.9 1.7 18.3 8.5s1.4 15-4.5 19.6l-69.3 54.2c-7 5.4-8.2 15.5-2.7 22.5s15.5 8.2 22.5 2.7l93.6-73.3c5.7-4.5 13.8-4.5 19.6-.1s7.9 12.2 5.1 18.9l-14.9 35.8c-3.4 8.2 .5 17.5 8.6 20.9s17.5-.5 20.9-8.6l73.8-177.2c4.9-11.7 7.4-24.2 7.4-36.9 0-53-43-96-96-96l-80 0c-29.6 0-55.5 16.1-69.3 40-4.4 7.6-1.8 17.4 5.8 21.9 2.5 1.4 5.1 2.1 7.7 2.2 .4 0 .5 0 .6 0 5.5-.1 10.7-3 13.6-8 8.3-14.4 23.9-24 41.6-24 26.5 0 48 21.5 48 48s-21.5 48-48 48c-17.7 0-33.3-9.6-41.6-24-2.9-5-8.1-7.9-13.6-8-.4 0-.5 0-.6 0-2.6 0-5.2 .7-7.7 2.2-7.6 4.4-10.3 14.2-5.8 21.9 8.6 14.9 22 26.8 38 33.7 6.3 2.7 10.2 9.1 9.7 16s-5.4 12.6-12.1 14.3l-66.3 16.6c-8.6 2.1-13.8 10.8-11.6 19.4z", "M146.5 3.7C122-6.5 93.9 5.1 83.7 29.5L9.8 206.8C3.3 222.4 0 239.1 0 256 0 326.7 57.3 384 128 384l80 0c41.5 0 77.7-22.6 97-56 10.7-18.4 7.7-41-5.8-56 13.5-15 16.4-37.6 5.8-56-5.5-9.5-12.4-18.2-20.4-25.6l31-7.8c25.7-6.4 41.4-32.5 34.9-58.2S318.1 83 292.4 89.4l-16.8 4.2 10-7.8c20.9-16.3 24.6-46.5 8.2-67.4l0 0c-16.3-20.9-46.5-24.6-67.4-8.2L176 49.7c.7-19.4-10.5-38.1-29.5-46zM263.8 256l-.3 0-.3 0c-5.5-.1-10.7-3-13.6-8-8.3-14.4-23.9-24-41.6-24-26.5 0-48 21.5-48 48s21.5 48 48 48c17.7 0 33.3-9.6 41.6-24 2.9-5 8.1-7.9 13.6-8l.3 0 .3 0c2.6 0 5.2 .7 7.7 2.2 7.6 4.4 10.3 14.2 5.8 21.9-13.8 23.9-39.7 40-69.3 40l-80 0c-53 0-96-43-96-96 0-12.7 2.5-25.2 7.4-36.9L113.2 41.8c3.4-8.2 12.8-12 20.9-8.6s12 12.8 8.6 20.9L127.9 89.9c-2.8 6.7-.7 14.5 5.1 18.9s13.8 4.4 19.6-.1l93.6-73.3c7-5.4 17-4.2 22.5 2.7s4.2 17-2.7 22.5l-69.3 54.2c-5.9 4.7-7.8 12.8-4.5 19.6s10.9 10.3 18.3 8.5l89.8-22.4c8.6-2.1 17.3 3.1 19.4 11.6s-3.1 17.3-11.6 19.4l-66.3 16.6c-6.7 1.7-11.5 7.4-12.1 14.3s3.4 13.3 9.7 16c16 6.8 29.4 18.7 38 33.7 4.4 7.6 1.8 17.4-5.8 21.9-2.5 1.4-5.1 2.1-7.7 2.2zm-41.9 8c1.7 2.9 3.6 5.6 5.8 8-2.1 2.4-4.1 5.1-5.8 8-2.8 4.9-8 8-13.9 8-8.8 0-16-7.2-16-16s7.2-16 16-16c5.9 0 11.1 3.2 13.9 8zM493.5 508.3c24.5 10.2 52.6-1.4 62.8-25.8l73.8-177.2c6.5-15.6 9.8-32.3 9.8-49.2 0-70.7-57.3-128-128-128l-80 0c-41.5 0-77.7 22.6-97 56-10.7 18.4-7.7 41 5.8 56-13.5 15-16.4 37.6-5.8 56 5.5 9.5 12.4 18.2 20.4 25.6l-31 7.8c-25.7 6.4-41.4 32.5-34.9 58.2s32.5 41.4 58.2 34.9l16.8-4.2-10 7.8c-20.9 16.3-24.6 46.5-8.2 67.4s46.5 24.6 67.4 8.2L464 462.3c-.7 19.4 10.6 38.1 29.5 46zM376.2 256l.3 0 .3 0c5.5 .1 10.7 3 13.6 8 8.3 14.4 23.9 24 41.6 24 26.5 0 48-21.5 48-48s-21.5-48-48-48c-17.7 0-33.3 9.6-41.6 24-2.9 5-8.1 7.9-13.6 8l-.3 0-.3 0c-2.6 0-5.2-.7-7.7-2.2-7.6-4.4-10.3-14.2-5.8-21.9 13.8-23.9 39.7-40 69.3-40l80 0c53 0 96 43 96 96 0 12.7-2.5 25.2-7.4 36.9L526.8 470.1c-3.4 8.2-12.8 12-20.9 8.6s-12-12.8-8.6-20.9l14.9-35.8c2.8-6.7 .7-14.5-5.1-18.9s-13.8-4.4-19.6 .1l-93.6 73.3c-7 5.4-17 4.2-22.5-2.7s-4.2-17 2.7-22.5l69.3-54.2c5.9-4.7 7.8-12.8 4.5-19.6s-10.9-10.3-18.3-8.5l-89.8 22.4c-8.6 2.1-17.3-3.1-19.4-11.6s3.1-17.3 11.6-19.4l66.3-16.6c6.7-1.7 11.5-7.4 12.1-14.3s-3.4-13.3-9.7-16c-16-6.8-29.4-18.7-38-33.7-4.4-7.7-1.8-17.4 5.8-21.9 2.5-1.4 5.1-2.1 7.7-2.2zm41.9-8c-1.7-2.9-3.6-5.6-5.8-8 2.1-2.4 4.1-5.1 5.8-8 2.8-4.9 8-8 13.9-8 8.8 0 16 7.2 16 16s-7.2 16-16 16c-5.9 0-11.1-3.2-13.9-8z"]],
    "face-anxious-sweat": [640, 512, [], "e36a", ["M96.1 250.1c1.5 1 3 2.2 4.4 3.4l.3 .3c14.4 12.5 32.3 29.7 46.8 50.2 14.3 20.1 28.4 47.7 28.4 80.1 0 13.4-2.2 26.2-6.4 38 39.9 36.1 92.6 58 150.4 58 123.7 0 224-100.3 224-224S443.7 32 320 32C198.3 32 99.2 129.1 96.1 250.1zm48.1-39.5c-1.5-8.7 4.4-17 13.2-18.4l2.5-.4c26.3-4.4 50.6-16.9 69.5-35.7l7.4-7.4c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6l-7.4 7.4c-23.6 23.6-53.9 39.2-86.8 44.7l-2.5 .4c-8.7 1.5-17-4.4-18.4-13.2zM264 272a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zM224 395.8c0-50.7 41.1-91.8 91.8-91.8l8.4 0c50.7 0 91.8 41.1 91.8 91.8 0 11.2-9 20.2-20.2 20.2l-151.6 0c-11.2 0-20.2-9-20.2-20.2zM424 272a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zM380.7 148.7c6.2-6.2 16.4-6.2 22.6 0l7.4 7.4c18.9 18.9 43.1 31.4 69.5 35.7l2.5 .4c8.7 1.5 14.6 9.7 13.2 18.4s-9.7 14.6-18.4 13.2l-2.5-.4c-32.9-5.5-63.3-21.1-86.8-44.7l-7.4-7.4c-6.2-6.2-6.2-16.4 0-22.6z", "M544 256c0 123.7-100.3 224-224 224-57.9 0-110.6-21.9-150.4-58-3.7 10.6-8.9 20.3-15.3 29.1 44.7 38 102.5 60.8 165.7 60.8 141.4 0 256-114.6 256-256S461.4 0 320 0c-136 0-247.2 106.1-255.5 240 11 .1 22.1 3.4 31.6 10.1 3.1-121 102.2-218.1 223.9-218.1 123.7 0 224 100.3 224 224zM315.8 304c-50.7 0-91.8 41.1-91.8 91.8 0 11.2 9 20.2 20.2 20.2l151.6 0c11.2 0 20.2-9 20.2-20.2 0-50.7-41.1-91.8-91.8-91.8l-8.4 0zm8.4 32c29 0 53.2 20.6 58.6 48l-125.7 0c5.5-27.4 29.6-48 58.6-48l8.4 0zM376 272a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zM240 296a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm19.3-147.3c-6.2-6.2-16.4-6.2-22.6 0l-7.4 7.4c-18.9 18.9-43.2 31.4-69.5 35.7l-2.5 .4c-8.7 1.5-14.6 9.7-13.2 18.4s9.7 14.6 18.4 13.2l2.5-.4c32.9-5.5 63.3-21.1 86.8-44.7l7.4-7.4c6.2-6.2 6.2-16.4 0-22.6zm121.4 22.6l7.4 7.4c23.6 23.6 53.9 39.2 86.8 44.7l2.5 .4c8.7 1.5 17-4.4 18.4-13.2s-4.4-17-13.2-18.4l-2.5-.4c-26.3-4.4-50.6-16.9-69.5-35.7l-7.4-7.4c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6zM64 328.9c3.8 4.7 7.5 9.6 11 14.5 6.2 8.6 11.6 16.3 15.6 24 4 7.7 5.3 13.1 5.3 16.6 0 17.7-14.3 32-32 32s-32-14.3-32-32c0-3.5 1.3-8.9 5.3-16.6 4-7.7 9.5-15.4 15.6-24 3.6-4.9 7.2-9.8 11-14.5zM64 288c-5 0-9.3 2.4-12.5 6-8.7 9.8-16.8 20.1-24.5 30.7-12 16.7-27 37.7-27 59.3 0 35.3 28.7 64 64 64s64-28.7 64-64c0-21.5-15-42.5-27-59.3-7.6-10.6-15.8-20.9-24.5-30.7-3.2-3.6-7.6-6-12.5-6z"]],
    "message-smile": [512, 512, ["comment-alt-smile"], "f4aa", ["M32 128l0 224c0 35.3 28.7 64 64 64l40 0c13.3 0 24 10.7 24 24l0 68 112-84c6.9-5.2 15.3-8 24-8l120 0c35.3 0 64-28.7 64-64l0-224c0-35.3-28.7-64-64-64L96 64c-35.3 0-64 28.7-64 64zM154.6 306.7c-5.9-6.6-5.3-16.7 1.3-22.6s16.7-5.3 22.6 1.3C197.5 306.6 225.2 320 256 320s58.5-13.4 77.5-34.7c5.9-6.6 16-7.1 22.6-1.3s7.1 16 1.3 22.6C332.5 334.5 296.3 352 256 352s-76.5-17.5-101.4-45.3zM216 192a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm128 0a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M179.2 533.6l0 0 112-84c1.4-1 3.1-1.6 4.8-1.6l120 0c53 0 96-43 96-96l0-224c0-53-43-96-96-96L96 32C43 32 0 75 0 128L0 352c0 53 43 96 96 96l32 0 0 68c0 15.5 12.5 28 28 28 6.1 0 12-2 16.8-5.6l6.4-4.8zM160 448l0-8c0-13.3-10.7-24-24-24l-40 0c-35.3 0-64-28.7-64-64l0-224c0-35.3 28.7-64 64-64l320 0c35.3 0 64 28.7 64 64l0 224c0 35.3-28.7 64-64 64l-120 0c-8.7 0-17.1 2.8-24 8l-112 84 0-60zm32-232a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm128 0a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM155.9 284.1c-6.6 5.9-7.1 16-1.3 22.6 24.9 27.8 61.1 45.3 101.4 45.3s76.5-17.5 101.4-45.3c5.9-6.6 5.3-16.7-1.3-22.6s-16.7-5.3-22.6 1.3C314.5 306.6 286.8 320 256 320s-58.5-13.4-77.5-34.7c-5.9-6.6-16-7.1-22.6-1.3z"]],
    "location-exclamation": [384, 512, ["map-marker-exclamation"], "f608", ["M32 188.6c0 50.3 25.9 109.4 61.4 165.6 34 53.8 73.9 100.4 98.6 127.4 24.6-26.9 64.6-73.6 98.6-127.4 35.5-56.2 61.4-115.3 61.4-165.6 0-85.9-71.1-156.6-160-156.6S32 102.6 32 188.6zM216 328a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zM168.5 120.9c-.8-13.5 10-24.9 23.5-24.9s24.3 11.4 23.5 24.9l-7.6 136c-.5 8.5-7.5 15.1-16 15.1s-15.5-6.6-16-15.1l-7.6-136z", "M192 0c106 0 192 84.4 192 188.6 0 119.3-120.2 262.3-170.4 316.8l0 0c-11.8 12.8-31.4 12.8-43.3 0l0 0C120.1 450.8 0 307.9 0 188.6 0 84.4 86 0 192 0zm0 32c-88.9 0-160 70.6-160 156.6 0 50.3 25.9 109.4 61.4 165.6 34 53.8 73.9 100.4 98.6 127.4 24.6-26.9 64.6-73.6 98.6-127.4 35.5-56.2 61.4-115.3 61.4-165.6 0-85.9-71.1-156.6-160-156.6zm0 320a24 24 0 1 1 0-48 24 24 0 1 1 0 48zm0-256c13.5 0 24.3 11.4 23.5 24.9l-7.6 136c-.5 8.5-7.5 15.1-16 15.1s-15.5-6.6-16-15.1l-7.6-136c-.8-13.5 10-24.9 23.5-24.9z"]],
    "square-naira": [448, 512, [], "e708", ["M32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64C46.3 64 32 78.3 32 96zM96 272c0-8.8 7.2-16 16-16l16 0 0-112c0-7 4.5-13.1 11.1-15.2s13.9 .3 17.9 5.9l86.6 121.3 44.3 0 0-112c0-8.8 7.2-16 16-16s16 7.2 16 16l0 112 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0 0 80c0 7-4.5 13.1-11.1 15.2S295 383 291 377.3l-63.8-89.3-67.2 0 0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80-16 0c-8.8 0-16-7.2-16-16zm64-78.1l0 62.1 44.3 0-44.3-62.1z", "M64 64C46.3 64 32 78.3 32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm139.1 32.8c6.6-2.1 13.9 .3 17.9 5.9l86.6 121.3 44.3 0 0-112c0-8.8 7.2-16 16-16s16 7.2 16 16l0 112 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0 0 80c0 7-4.5 13.1-11.1 15.2S295 383 291 377.3l-63.8-89.3-67.2 0 0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80-16 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0 0-112c0-7 4.5-13.1 11.1-15.2zM288 318.1l0-30.1-21.5 0 21.5 30.1zM160 193.9l0 62.1 44.3 0-44.3-62.1z"]],
    "table-cells-row-unlock": [640, 512, [], "e691", ["M96 192l96 0 0 256-64 0c-17.7 0-32-14.3-32-32l0-224zm128 0l128 0 0 128 28.8 0c-8.1 14.1-12.8 30.4-12.8 47.9l0 80.1-144 0 0-256zm160 0l44.1 0c-17.6 21.9-28.1 49.7-28.1 80l0 24.4c-6.1 5.4-11.5 11.6-16 18.5L384 192z", "M448 64L128 64c-17.7 0-32 14.3-32 32l0 64 370 0c-14.6 8.1-27.5 19-37.9 32l-44.1 0 0 122.8c-1.1 1.7-2.2 3.4-3.2 5.2l-28.8 0 0-128-128 0 0 256 144 0 0 15.9c0 5.5 .5 10.9 1.3 16.1L128 480c-35.3 0-64-28.7-64-64L64 96c0-35.3 28.7-64 64-64l320 0c35.3 0 64 28.7 64 64l0 49c-11.2 1.4-21.9 4.2-32 8.3L480 96c0-17.7-14.3-32-32-32zM192 192l-96 0 0 224c0 17.7 14.3 32 32 32l64 0 0-256zm384 80c-.1-26.5-21.5-47.9-48-47.9-26.5 0-48 21.5-48 48l0 47.9 112 0c26.5 0 48 21.5 48 48l0 96c0 26.5-21.5 48-48 48l-128 0c-26.5 0-48-21.5-48-48l0-96c0-20.9 13.4-38.7 32-45.3l0-50.6c0-44.2 35.8-80 80-80 44.2 0 79.9 35.8 80 79.9l-32 0zm-96 80.1l-17.7 0c-8 .9-14.3 7.7-14.3 15.9l0 96c0 8.8 7.2 16 16 16l128 0c8.8 0 16-7.2 16-16l0-96c0-8.8-7.2-16-16-16l-48 0 0 .1-64 0z"]],
    "diamonds-4": [512, 512, [], "e68b", ["M32 256c0 6.9 2.7 13.5 7.6 18.3l48.1 48.1c6.2 6.2 16.4 6.2 22.6 0l55.1-55.1c6.2-6.2 6.2-16.4 0-22.6l-55.1-55.1c-6.2-6.2-16.4-6.2-22.6 0L39.6 237.7C34.7 242.5 32 249.1 32 256zM189.5 87.7c-6.2 6.2-6.2 16.4 0 22.6l55.1 55.1c6.2 6.2 16.4 6.2 22.6 0l55.1-55.1c6.2-6.2 6.2-16.4 0-22.6L274.3 39.6C269.5 34.7 262.9 32 256 32s-13.5 2.7-18.3 7.6L189.5 87.7zm0 313.9c-6.2 6.2-6.2 16.4 0 22.6l48.1 48.1c4.9 4.9 11.5 7.6 18.3 7.6s13.5-2.7 18.3-7.6l48.1-48.1c6.2-6.2 6.2-16.4 0-22.6l-55.1-55.1c-6.2-6.2-16.4-6.2-22.6 0l-55.1 55.1zm157-157c-6.2 6.2-6.2 16.4 0 22.6l55.1 55.1c6.2 6.2 16.4 6.2 22.6 0l48.1-48.1c4.9-4.9 7.6-11.5 7.6-18.3s-2.7-13.5-7.6-18.3l-48.1-48.1c-6.2-6.2-16.4-6.2-22.6 0l-55.1 55.1z", "M17 215l48.1-48.1c18.7-18.7 49.1-18.7 67.9 0l55.1 55.1c18.7 18.7 18.7 49.1 0 67.9L133 345.1c-18.7 18.7-49.1 18.7-67.9 0L17 297C6.1 286.1 0 271.4 0 256s6.1-30.1 17-41zm22.6 59.3l48.1 48.1c6.2 6.2 16.4 6.2 22.6 0l55.1-55.1c6.2-6.2 6.2-16.4 0-22.6l-55.1-55.1c-6.2-6.2-16.4-6.2-22.6 0L39.6 237.7C34.7 242.5 32 249.1 32 256s2.7 13.5 7.6 18.3zM166.9 379c-18.7 18.7-18.7 49.1 0 67.9L215 495c10.9 10.9 25.6 17 41 17s30.1-6.1 41-17l48.1-48.1c18.7-18.7 18.7-49.1 0-67.9l-55.1-55.1c-18.7-18.7-49.1-18.7-67.9 0L166.9 379zm77.8-32.5c6.2-6.2 16.4-6.2 22.6 0l55.1 55.1c6.2 6.2 6.2 16.4 0 22.6l-48.1 48.1c-4.9 4.9-11.5 7.6-18.3 7.6s-13.5-2.7-18.3-7.6l-48.1-48.1c-6.2-6.2-6.2-16.4 0-22.6l55.1-55.1zM379 166.9c18.7-18.7 49.1-18.7 67.9 0L495 215c10.9 10.9 17 25.6 17 41s-6.1 30.1-17 41l-48.1 48.1c-18.7 18.7-49.1 18.7-67.9 0l-55.1-55.1c-18.7-18.7-18.7-49.1 0-67.9L379 166.9zm22.6 22.6l-55.1 55.1c-6.2 6.2-6.2 16.4 0 22.6l55.1 55.1c6.2 6.2 16.4 6.2 22.6 0l48.1-48.1c4.9-4.9 7.6-11.5 7.6-18.3s-2.7-13.5-7.6-18.3l-48.1-48.1c-6.2-6.2-16.4-6.2-22.6 0zM345.1 65.1L297 17C286.1 6.1 271.4 0 256 0s-30.1 6.1-41 17L166.9 65.1c-18.7 18.7-18.7 49.1 0 67.9l55.1 55.1c18.7 18.7 49.1 18.7 67.9 0L345.1 133c18.7-18.7 18.7-49.1 0-67.9zM189.5 110.3c-6.2-6.2-6.2-16.4 0-22.6l48.1-48.1c4.9-4.9 11.5-7.6 18.3-7.6s13.5 2.7 18.3 7.6l48.1 48.1c6.2 6.2 6.2 16.4 0 22.6l-55.1 55.1c-6.2 6.2-16.4 6.2-22.6 0l-55.1-55.1z"]],
    "rocket": [512, 512, [], "f135", ["M24.5 288L128 288c1.1 0 2.3 0 3.4 .1 9.2-36.8 20.5-68.6 33.3-96.1l-73.5 0c-5.6 0-10.8 2.9-13.7 7.8L24.5 288zm138.2 6.5c25.1 9.7 45 29.7 54.8 54.8 121.4-30.6 179.7-83.2 206.8-135.6 26-50.4 24.7-103.6 18-143.9-40.3-6.8-93.5-8-143.9 18-52.4 27.1-105 85.4-135.6 206.8zM224 380.6c0 1.1 .1 2.2 .1 3.4l0 103.5 88.2-52.9c4.8-2.9 7.8-8.1 7.8-13.7l0-73.5c-27.4 12.9-59.3 24.1-96.1 33.3zM392 176a56 56 0 1 1 -112 0 56 56 0 1 1 112 0z", "M459.2 40.3c6.3 1.3 11.3 6.2 12.6 12.6 8.9 44.3 14.2 111.2-19 175.5-19.3 37.4-51.1 72.8-100.7 102.1l0 90.4c0 16.9-8.8 32.5-23.3 41.2l-88.2 52.9c-21.3 12.8-48.5-2.6-48.5-27.4L192 384c0-35.3-28.7-64-64-64L24.5 320c-24.9 0-40.2-27.1-27.4-48.5L50 183.3C58.7 168.8 74.3 160 91.2 160l90.4 0c29.3-49.6 64.7-81.4 102.1-100.7 64.3-33.2 131.2-27.8 175.5-19zM224 380.6c0 1.1 .1 2.2 .1 3.4l0 103.5 88.2-52.9c4.8-2.9 7.8-8.1 7.8-13.7l0-73.5c-27.4 12.9-59.3 24.1-96.1 33.3zm200.4-167c26-50.4 24.7-103.6 18-143.9-40.3-6.8-93.5-8-143.9 18-52.4 27.1-105 85.4-135.6 206.8 25.1 9.7 45 29.7 54.8 54.8 121.4-30.6 179.7-83.2 206.8-135.6zM164.7 192l-73.5 0c-5.6 0-10.8 2.9-13.7 7.8L24.5 288 128 288c1.1 0 2.3 0 3.4 .1 9.2-36.8 20.5-68.6 33.3-96.1zM312 176a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm24 56a56 56 0 1 1 0-112 56 56 0 1 1 0 112z"]],
    "file-circle-info": [576, 512, [58604], "e493", ["M64 64c0-17.7 14.3-32 32-32l128 0 0 96c0 35.3 28.7 64 64 64l96 0 0 22c-82.8 21.3-144 96.5-144 186 0 28.6 6.2 55.6 17.4 80L96 480c-17.7 0-32-14.3-32-32L64 64z", "M224 32L96 32C78.3 32 64 46.3 64 64l0 384c0 17.7 14.3 32 32 32l161.4 0c5.2 11.3 11.4 22 18.6 32L96 512c-35.3 0-64-28.7-64-64L32 64C32 28.7 60.7 0 96 0L229.5 0c17 0 33.3 6.7 45.3 18.7L397.3 141.3c12 12 18.7 28.3 18.7 45.3l0 22.1c-11 .9-21.6 2.7-32 5.4l0-22-96 0c-35.3 0-64-28.7-64-64l0-96zM370.7 160L256 45.3 256 128c0 17.7 14.3 32 32 32l82.7 0zM544 400a112 112 0 1 0 -224 0 112 112 0 1 0 224 0zm-256 0a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm144-44a20 20 0 1 1 0-40 20 20 0 1 1 0 40zM400 464c0-8.8 7.2-16 16-16l0-32c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0c8.8 0 16 7.2 16 16l0 48 0 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16z"]],
    "cloud-fog": [576, 512, [127787, "fog"], "f74e", ["M64 224c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64s-28.7-64-64-64c-5.9 0-11.6 .8-16.9 2.3-5.9 1.6-12.1-.3-16.2-4.8s-5.2-11-2.9-16.6c2.6-6.4 4-13.5 4-20.9 0-30.9-25.1-56-56-56-19.9 0-37.4 10.4-47.4 26.1-3.3 5.2-9.3 8.1-15.5 7.3s-11.3-5-13.2-10.8c-10.6-31.8-40.6-54.7-75.9-54.7-44.2 0-80 35.8-80 80 0 9.6 1.7 18.7 4.7 27.2 1.7 4.6 1.1 9.6-1.4 13.8s-6.8 6.9-11.6 7.5C88.3 164.6 64 191.5 64 224z", "M208 32c-44.2 0-80 35.8-80 80 0 9.6 1.7 18.7 4.7 27.2 1.7 4.6 1.1 9.6-1.4 13.8s-6.8 6.9-11.6 7.5c-31.4 4-55.7 30.9-55.7 63.5 0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64s-28.7-64-64-64c-5.9 0-11.6 .8-16.9 2.3-5.9 1.6-12.1-.3-16.2-4.8s-5.2-11-2.9-16.6c2.6-6.4 4-13.5 4-20.9 0-30.9-25.1-56-56-56-19.9 0-37.4 10.4-47.4 26.1-3.3 5.2-9.3 8.1-15.5 7.3s-11.3-5-13.2-10.8C273.3 54.9 243.3 32 208 32zM96 112c0-61.9 50.1-112 112-112 40.2 0 75.4 21.1 95.1 52.9 15.3-13 35.2-20.9 56.9-20.9 48.6 0 88 39.4 88 88 0 2.7-.1 5.4-.4 8l.4 0c53 0 96 43 96 96s-43 96-96 96l-320 0c-53 0-96-43-96-96 0-42.5 27.6-78.6 65.9-91.2-1.3-6.7-1.9-13.7-1.9-20.8zM512 400c0 8.8-7.2 16-16 16L16 416c-8.8 0-16-7.2-16-16s7.2-16 16-16l480 0c8.8 0 16 7.2 16 16zM80 480l96 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zm176 0l304 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-304 0c-8.8 0-16-7.2-16-16s7.2-16 16-16z"]],
    "option": [640, 512, [], "e318", ["", "M178 107.7c-6.1-7.4-15.2-11.7-24.8-11.7L16 96C7.2 96 0 88.8 0 80S7.2 64 16 64l137.3 0c19.2 0 37.4 8.6 49.5 23.5L462 404.3c6.1 7.4 15.2 11.7 24.8 11.7L624 416c8.8 0 16 7.2 16 16s-7.2 16-16 16l-137.3 0c-19.2 0-37.4-8.6-49.5-23.5L178 107.7zM624 64c8.8 0 16 7.2 16 16s-7.2 16-16 16L432 96c-8.8 0-16-7.2-16-16s7.2-16 16-16l192 0z"]],
    "utility-pole": [512, 512, [], "e2c3", ["", "M272 16c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 80-128 0 0-48c0-8.8-7.2-16-16-16S80 39.2 80 48l0 48-15.8 0-.3 0-31.9 0 0-48c0-8.8-7.2-16-16-16S0 39.2 0 48l0 64c0 8.8 7.2 16 16 16L58.4 128 240 271.7 240 496c0 8.8 7.2 16 16 16s16-7.2 16-16l0-224.3 181.6-143.7 42.4 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 48-31.9 0-.3 0-15.8 0 0-48c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 48-128 0 0-80zM402 128l-130 102.9 0-102.9 130 0zM240 230.9l-130-102.9 130 0 0 102.9z"]],
    "shrimp": [512, 512, [129424], "e448", ["M96.9 160c8 72 69 128 143.1 128l80 0 0-128-223.1 0zM224 208a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm54.6 240l57.4 0 0-43.1-46.4-9.9 9.7 9.7c6.2 6.2 6.2 16.4 0 22.6L278.6 448zM352 160.9l0 127.1 4 0c12 0 23.3 3.5 32.7 9.7l78.8-52.5C447 199.6 403.6 166.6 352 160.9zm16 246.4l0 37.2c33-7.5 61.7-26.3 81.7-52.1l-39.8-15.9c-8.1 16.1-23.5 27.8-41.9 30.8zm42-85.4c3.3 6.9 5.4 14.4 5.9 22.4l50.8 20.3c8.6-18.4 13.3-39 13.3-60.6 0-9.3-.9-18.3-2.5-27.1l-67.4 45z", "M0 96C0 60.7 28.7 32 64 32l368 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L64 64C46.3 64 32 78.3 32 96s14.3 32 32 32l272 0c97.2 0 176 78.8 176 176S433.2 480 336 480l-96 0c-8.8 0-16-7.2-16-16 0-4.4 1.8-8.4 4.7-11.3l36.7-36.7-36.7-36.7c-5-5-6.1-12.7-2.7-19s10.5-9.5 17.4-8L348.9 375c3.2 .7 6.4 1 9.7 1 14 0 25.4-11.4 25.4-25.4l0-2.6c0-15.5-12.5-28-28-28l-116 0c-91.8 0-167.2-70.3-175.3-160l-.7 0C28.7 160 0 131.3 0 96zM336 448l0-43.1-46.4-9.9 9.7 9.7c6.2 6.2 6.2 16.4 0 22.6L278.6 448 336 448zm32-3.6c33-7.5 61.7-26.3 81.7-52.1l-39.8-15.9c-8.1 16.1-23.5 27.8-41.9 30.8l0 37.2zm98.7-79.8c8.6-18.4 13.3-39 13.3-60.6 0-9.3-.9-18.3-2.5-27.1l-67.4 45c3.3 6.9 5.4 14.4 5.9 22.4l50.8 20.3zm.8-119.5C447 199.6 403.6 166.6 352 160.9l0 127.1 4 0c12 0 23.3 3.5 32.7 9.7l78.8-52.5zM320 160L96.9 160c8 72 69 128 143.1 128l80 0 0-128zM208 192a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"]],
    "alien": [448, 512, [128125], "f8f5", ["M32 224c0 56.2 31.2 110.7 72.2 157.4 40.4 46.1 86.7 80.4 108.6 95.4 2.8 1.9 6.6 3.2 11.2 3.2s8.4-1.3 11.2-3.2c21.9-15 68.1-49.3 108.6-95.4 41-46.7 72.2-101.3 72.2-157.4 0-106-86-192-192-192S32 118 32 224zm32 0c0-8.8 7.2-16 16-16l32 0c53 0 96 43 96 96 0 8.8-7.2 16-16 16l-32 0c-53 0-96-43-96-96zm176 80c0-53 43-96 96-96l32 0c8.8 0 16 7.2 16 16 0 53-43 96-96 96l-32 0c-8.8 0-16-7.2-16-16z", "M224 32c-106 0-192 86-192 192 0 56.2 31.2 110.7 72.2 157.4 40.4 46.1 86.7 80.4 108.6 95.4 2.8 1.9 6.6 3.2 11.2 3.2s8.4-1.3 11.2-3.2c21.9-15 68.1-49.3 108.6-95.4 41-46.7 72.2-101.3 72.2-157.4 0-106-86-192-192-192zM0 224C0 100.3 100.3 0 224 0S448 100.3 448 224c0 135.3-148.8 247.7-194.7 279.2-8.6 5.9-18.9 8.8-29.3 8.8s-20.7-2.9-29.3-8.8C148.8 471.7 0 359.3 0 224zm350 16l-14 0c-29.8 0-54.9 20.4-62 48l14 0c29.8 0 54.9-20.4 62-48zm-14-32l32 0c8.8 0 16 7.2 16 16 0 53-43 96-96 96l-32 0c-8.8 0-16-7.2-16-16 0-53 43-96 96-96zM112 240l-14 0c7.1 27.6 32.2 48 62 48l14 0c-7.1-27.6-32.2-48-62-48zm96 64c0 8.8-7.2 16-16 16l-32 0c-53 0-96-43-96-96 0-8.8 7.2-16 16-16l32 0c53 0 96 43 96 96z"]],
    "skeleton": [512, 512, [], "f620", ["M112 512c8.8 0 16-7.2 16-16 0-26.5 21.5-48 48-48l160 0c26.5 0 48 21.5 48 48 0 8.8 7.2 16 16 16l-288 0z", "M256 0c8.8 0 16 7.2 16 16l0 80 152 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-152 0 0 64 216 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-216 0 0 64 120 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-120 0 0 96 64 0c44.2 0 80 35.8 80 80 0 8.8-7.2 16-16 16s-16-7.2-16-16c0-26.5-21.5-48-48-48l-160 0c-26.5 0-48 21.5-48 48 0 8.8-7.2 16-16 16s-16-7.2-16-16c0-44.2 35.8-80 80-80l64 0 0-96-120 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l120 0 0-64-216 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l216 0 0-64-152 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l152 0 0-80c0-8.8 7.2-16 16-16z"]],
    "tire-pressure-warning": [512, 512, [], "f633", ["M42 280.6c-.6-47.4 17.8-89.7 35.8-120.5 .2-.3 .3-.6 .5-.9l5-9.9C102.2 111.4 112 69.8 112 27.6L112 16c0-8.8-7.2-16-16-16L416 0c-8.8 0-16 7.2-16 16l0 11.6c0 42.2 9.8 83.9 28.7 121.6l5 9.9c.2 .3 .3 .6 .5 .9 18 30.9 36.4 73.1 35.8 120.5-.6 45.5-18.7 97.9-76.2 151.4l-275.6 0C60.8 378.5 42.6 326.1 42 280.6zm194 40.7a20 20 0 1 0 40 0 20 20 0 1 0 -40 0zM240 128l0 128c0 8.8 7.2 16 16 16s16-7.2 16-16l0-128c0-8.8-7.2-16-16-16s-16 7.2-16 16z", "M416 0c-8.8 0-16 7.2-16 16l0 11.6c0 42.2 9.8 83.9 28.7 121.6l5 9.9c.2 .3 .3 .6 .5 .9 18 30.9 36.4 73.1 35.8 120.5-.6 45.5-18.7 97.9-76.2 151.4l-275.6 0c-57.5-53.5-75.6-105.9-76.2-151.4-.6-47.4 17.8-89.7 35.8-120.5 .2-.3 .3-.6 .5-.9l5-9.9C102.2 111.4 112 69.8 112 27.6L112 16c0-8.8-7.2-16-16-16S80 7.2 80 16l0 11.6c0 37.3-8.7 74-25.3 107.3l-4.7 9.5c-19.3 33.1-40.6 81.1-39.9 136.6 .7 55 23.1 115.3 86 174.1 0 .3 0 .6 0 .9l0 40c0 8.8 7.2 16 16 16s16-7.2 16-16l0-32 64 0 0 32c0 8.8 7.2 16 16 16s16-7.2 16-16l0-32 64 0 0 32c0 8.8 7.2 16 16 16s16-7.2 16-16l0-32 64 0 0 32c0 8.8 7.2 16 16 16s16-7.2 16-16l0-40c0-.3 0-.6 0-.9 62.9-58.8 85.3-119.1 86-174.1 .7-55.5-20.7-103.5-39.9-136.6l-4.7-9.5C440.7 101.6 432 64.8 432 27.6L432 16c0-8.8-7.2-16-16-16zM256 112c-8.8 0-16 7.2-16 16l0 128c0 8.8 7.2 16 16 16s16-7.2 16-16l0-128c0-8.8-7.2-16-16-16zm20 209.3a20 20 0 1 0 -40 0 20 20 0 1 0 40 0z"]],
    "nose": [448, 512, [], "e5bd", ["M32 400c0-44.2 35.8-80 80-80l16 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0c-17.2 0-33.5 3.9-48 10.8L64 16 160 16c0 3.4 1.1 6.9 3.4 9.8L395.4 323.2c13.3 17.1 20.6 38.1 20.6 59.7 0 53.6-43.5 97.1-97.1 97.1l-78.8 0c-.1-2.7-.1-5.3-.1-8 0-39.8-32.2-72-72-72s-72 32.2-72 72l0 6.4C59.5 471 32 438.7 32 400z", "M166.2 3.4c7-5.4 17-4.2 22.5 2.8L420.7 303.5c17.7 22.7 27.3 50.6 27.3 79.4 0 71.3-57.8 129.1-129.1 129.1L112 512C50.1 512 0 461.9 0 400S50.1 288 112 288l16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0c-44.2 0-80 35.8-80 80 0 38.7 27.5 71 64 78.4l0-6.4c0-39.8 32.2-72 72-72s72 32.2 72 72l0 8 78.9 0c53.6 0 97.1-43.5 97.1-97.1 0-21.6-7.2-42.7-20.6-59.7L163.4 25.8c-5.4-7-4.2-17 2.8-22.5zM208 480l0-8c0-22.1-17.9-40-40-40s-40 17.9-40 40l0 8 80 0z"]],
    "sign-posts-wrench": [640, 512, [], "e626", ["M64 128c0-17.7 14.3-32 32-32l384 0c17.7 0 32 14.3 32 32l0 48c-97.2 0-176 78.8-176 176 0 22.6 4.3 44.2 12 64L96 416c-17.7 0-32-14.3-32-32l0-256z", "M96 32l0 32c-35.3 0-64 28.7-64 64l0 256c0 35.3 28.7 64 64 64l0 0 0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48 236.5 0c-6.5-10-12.1-20.7-16.5-32L96 416c-17.7 0-32-14.3-32-32l0-256c0-17.7 14.3-32 32-32l384 0c17.7 0 32 14.3 32 32l0 48c10.9 0 21.6 1 32 2.9l0-50.9c0-35.3-28.7-64-64-64l0-32c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 32-320 0 0-32c0-8.8-7.2-16-16-16S96 23.2 96 32zM480 250.8c0-5.5-2.8-10.6-7.5-13.5s-10.5-3.3-15.4-.9c-43.2 20.5-73.1 64.6-73.1 115.7 0 47.4 25.8 88.8 64 110.9l0 65.1c0 8.8 7.2 16 16 16s16-7.2 16-16l0-74.8c0-6.2-3.6-11.8-9.1-14.5-32.5-15.4-54.9-48.5-54.9-86.8 0-28.4 12.3-54 32-71.6l0 39.6c0 35.3 28.7 64 64 64s64-28.7 64-64l0-39.6c19.7 17.6 32 43.1 32 71.6 0 38.3-22.4 71.3-54.9 86.8-5.6 2.6-9.1 8.3-9.1 14.5l0 74.8c0 8.8 7.2 16 16 16s16-7.2 16-16l0-65.1c38.2-22.1 64-63.5 64-110.9 0-51.1-29.9-95.1-73.1-115.7-5-2.4-10.8-2-15.4 .9s-7.5 8-7.5 13.5l0 69.2c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-69.2z"]],
    "tenge-sign": [384, 512, [8376, "tenge"], "f7d7", ["", "M0 48c0-8.8 7.2-16 16-16l352 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L16 64C7.2 64 0 56.8 0 48zM0 176c0-8.8 7.2-16 16-16l352 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-160 0 0 272c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-272-160 0c-8.8 0-16-7.2-16-16z"]],
    "face-scream": [576, 512, [], "e38b", ["M64 256C64 132.3 164.3 32 288 32S512 132.3 512 256c0 17-1.9 33.5-5.5 49.4-40.6 6.8-73.8 38.1-82.1 79.6-3.8 18.9-7.6 37.9-11.4 56.9-35.7 24.1-78.8 38.1-125.1 38.1s-89.4-14.1-125.1-38.1c-3.8-18.9-7.6-37.9-11.4-56.9-8.3-41.5-41.4-72.8-82.1-79.6-3.6-15.9-5.5-32.4-5.5-49.4zm48.4-10.4c1.9 20.9 11.8 40.6 31.2 51.2 19.2 10.5 41.5 8.7 61 .1 19.5-8.6 37.7-24.6 50.5-45.6 12.8-21 18.5-44.1 16.6-64.9-1.9-20.9-11.8-40.6-31.2-51.2-19.2-10.5-41.5-8.7-61-.1-19.5 8.6-37.7 24.6-50.5 45.6-12.8 21-18.5 44.1-16.6 64.9zM224 368l0 16c0 35.3 28.7 64 64 64s64-28.7 64-64l0-16c0-35.3-28.7-64-64-64s-64 28.7-64 64zm80.4-181.6c-1.9 20.8 3.8 43.9 16.6 64.9 12.8 21 30.9 37 50.5 45.6 19.4 8.6 41.8 10.4 61-.1 19.4-10.6 29.3-30.3 31.2-51.2 1.9-20.8-3.8-43.9-16.6-64.9-12.8-21-30.9-37-50.5-45.6-19.4-8.6-41.8-10.4-61 .1-19.4 10.6-29.3 30.3-31.2 51.2z", "M512 256c0 17-1.9 33.5-5.5 49.4 5.4-.9 11-1.4 16.7-1.4 5.4 0 10.8 .4 16 1.3 3.1-15.9 4.7-32.4 4.7-49.3 0-141.4-114.6-256-256-256S32 114.6 32 256c0 16.9 1.6 33.3 4.7 49.3 5.2-.8 10.6-1.3 16-1.3 5.7 0 11.3 .5 16.7 1.4-3.6-15.9-5.5-32.4-5.5-49.4 0-123.7 100.3-224 224-224S512 132.3 512 256zM288 480c-46.3 0-89.4-14.1-125.1-38.1l8.4 42.1C206.3 501.9 246 512 288 512s81.7-10.1 116.7-28.1l8.4-42.1C377.4 465.9 334.3 480 288 480zM73.1 400.7L95.4 512 128 512 104.5 394.4C99.5 369.8 77.9 352 52.8 352 23.6 352 0 375.6 0 404.8l0 107.2 32 0 0-107.2c0-11.5 9.3-20.8 20.8-20.8 9.9 0 18.4 7 20.3 16.7zM480.6 512l22.3-111.3c1.9-9.7 10.5-16.7 20.4-16.7 11.5 0 20.8 9.3 20.8 20.8l0 107.2 32 0 0-107.2c0-29.1-23.6-52.8-52.8-52.8-25.1 0-46.8 17.8-51.7 42.4L448 512 480.6 512zM156.3 197.4c9.7-15.9 23-27.2 36.1-33 13.2-5.8 24.6-5.5 32.7-1.1 7.9 4.3 13.5 13 14.7 26 1.2 13.1-2.4 29.4-12.1 45.3-9.7 15.9-23 27.2-36.1 33-13.2 5.8-24.6 5.5-32.7 1.1-7.9-4.3-13.5-13-14.7-26-1.2-13.1 2.4-29.4 12.1-45.3zm84.1-62.1c-19.2-10.5-41.5-8.7-61-.1-19.5 8.6-37.7 24.6-50.5 45.6-12.8 21-18.5 44.1-16.6 64.9 1.9 20.9 11.8 40.6 31.2 51.2 19.2 10.5 41.5 8.7 61 .1 19.5-8.6 37.7-24.6 50.5-45.6 12.8-21 18.5-44.1 16.6-64.9-1.9-20.9-11.8-40.6-31.2-51.2zm143.3 29.2c13.1 5.8 26.4 17.1 36.1 33 9.7 15.9 13.3 32.2 12.1 45.3-1.2 13-6.9 21.7-14.7 26-8.1 4.4-19.5 4.7-32.7-1.1-13.1-5.8-26.4-17.1-36.1-33-9.7-15.9-13.3-32.2-12.1-45.3 1.2-13 6.9-21.7 14.7-26 8.1-4.4 19.5-4.7 32.7 1.1zm12.9-29.3c-19.4-8.6-41.8-10.4-61 .1-19.4 10.6-29.3 30.3-31.2 51.2-1.9 20.8 3.8 43.9 16.6 64.9 12.8 21 30.9 37 50.5 45.6 19.4 8.6 41.8 10.4 61-.1 19.4-10.6 29.3-30.3 31.2-51.2 1.9-20.8-3.8-43.9-16.6-64.9-12.8-21-30.9-37-50.5-45.6zM320 368l0 16c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-16c0-17.7 14.3-32 32-32s32 14.3 32 32zm-96 0l0 16c0 35.3 28.7 64 64 64s64-28.7 64-64l0-16c0-35.3-28.7-64-64-64s-64 28.7-64 64z"]],
    "house-chimney-medical": [512, 512, ["clinic-medical"], "f7f2", ["M80.5 202.2l0 245.8c0 17.7 14.3 32 32 32l288 0c17.7 0 32-14.3 32-32l0-245.8-176-164.3-176 164.3zm80 69.8c0-17.7 14.3-32 32-32l16 0 0-16c0-17.7 14.3-32 32-32l32 0c17.7 0 32 14.3 32 32l0 16 16 0c17.7 0 32 14.3 32 32l0 32c0 17.7-14.3 32-32 32l-16 0 0 16c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-16-16 0c-17.7 0-32-14.3-32-32l0-32zm224-200l0 41.6 48 44.8 0-86.4c0-4.4-3.6-8-8-8l-32 0c-4.4 0-8 3.6-8 8z", "M267.4 4.3c-6.1-5.7-15.7-5.7-21.8 0l-240 224c-6.5 6-6.8 16.2-.8 22.6s16.2 6.8 22.6 .8l21.1-19.7 0 216c0 35.3 28.7 64 64 64l288 0c35.3 0 64-28.7 64-64l0-216 21.1 19.7c6.5 6 16.6 5.7 22.6-.8s5.7-16.6-.8-22.6l-42.9-40.1 0-116.2c0-22.1-17.9-40-40-40l-32 0c-22.1 0-40 17.9-40 40l0 11.7-85.1-79.4zM432.5 72l0 86.4-48-44.8 0-41.6c0-4.4 3.6-8 8-8l32 0c4.4 0 8 3.6 8 8zm0 130.2l0 245.8c0 17.7-14.3 32-32 32l-288 0c-17.7 0-32-14.3-32-32l0-245.8 176-164.3 176 164.3zM240.5 192c-17.7 0-32 14.3-32 32l0 16-16 0c-17.7 0-32 14.3-32 32l0 32c0 17.7 14.3 32 32 32l16 0 0 16c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-16 16 0c17.7 0 32-14.3 32-32l0-32c0-17.7-14.3-32-32-32l-16 0 0-16c0-17.7-14.3-32-32-32l-32 0zm32 136l0 24-32 0 0-40c0-4.4-3.6-8-8-8l-40 0 0-32 40 0c4.4 0 8-3.6 8-8l0-40 32 0 0 40c0 4.4 3.6 8 8 8l40 0 0 32-40 0c-4.4 0-8 3.6-8 8l0 16z"]],
    "square-arrow-left": [448, 512, ["arrow-square-left"], "f33a", ["M32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64C46.3 64 32 78.3 32 96zM132.7 244.7l72-72c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6L182.6 240 304 240c8.8 0 16 7.2 16 16s-7.2 16-16 16l-121.4 0 44.7 44.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-72-72c-6.2-6.2-6.2-16.4 0-22.6z", "M64 64C46.3 64 32 78.3 32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM132.7 244.7l72-72c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6L182.6 240 304 240c8.8 0 16 7.2 16 16s-7.2 16-16 16l-121.4 0 44.7 44.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-72-72c-6.2-6.2-6.2-16.4 0-22.6z"]],
    "circle-location-arrow": [512, 512, ["location-circle"], "f602", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm71.5 7.2c-2.4-11.4 3.7-23.1 14.5-27.7L338.5 141c9.5-3.9 20.2-1.9 27.3 5.3 7.2 7.1 9.2 17.8 5.2 27.2L276.5 394c-3.9 9.1-12.9 15-22.8 15-1.6 0-3.3-.1-4.9-.5-11.5-2.4-19.8-12.6-19.8-24.3l0-101.2-101.3 0c-11.7 0-21.9-8.3-24.2-19.8z", "M480 256a224 224 0 1 0 -448 0 224 224 0 1 0 448 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm127.7 27c-11.7 0-21.9-8.3-24.2-19.8-2.4-11.4 3.7-23.1 14.5-27.7L338.5 141c9.5-3.9 20.2-1.9 27.3 5.3 7.2 7.1 9.2 17.8 5.2 27.2L276.5 394c-3.9 9.1-12.9 15-22.8 15-1.6 0-3.3-.1-4.9-.5-11.5-2.4-19.8-12.6-19.8-24.3l0-101.2-101.3 0zm35.3-32l65.9 0c17.7 0 32 14.3 32 32l0 66 73.5-171.4-171.4 73.4z"]],
    "users-slash": [640, 512, [], "e073", ["M160 480c8.8 0 16-7.2 16-16l0-24c0-65.4 52.4-118.6 117.5-120l160 160-293.5 0zm80-352c0-44.2 35.8-80 80-80s80 35.8 80 80-35.8 80-80 80c-11.5 0-22.4-2.4-32.2-6.8l-41-41c-4.3-9.9-6.8-20.8-6.8-32.2z", "M59.3-27.2c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l544 544c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-277-277c58.9-3.3 105.6-52.1 105.6-111.8 0-61.9-50.1-112-112-112-59.7 0-108.5 46.7-111.8 105.6L59.3-27.2zM287.8 201.2l-41-41c-4.3-9.9-6.8-20.8-6.8-32.2 0-44.2 35.8-80 80-80s80 35.8 80 80-35.8 80-80 80c-11.5 0-22.4-2.4-32.2-6.8zM80.2 106.7c-10.2 15.3-16.2 33.6-16.2 53.3 0 53 43 96 96 96 19.7 0 38.1-6 53.3-16.2L190 216.5c-9 4.8-19.2 7.5-30 7.5-35.3 0-64-28.7-64-64 0-10.9 2.7-21.1 7.5-30L80.2 106.7zM264.7 291.2C195.8 305.6 144 366.8 144 440l0 24c0 8.8 7.2 16 16 16s16-7.2 16-16l0-24c0-65.4 52.4-118.7 117.5-120l-28.8-28.8zM510.8 337c1.7 .2 3.4 .5 5.1 .8 47.6 8.6 84.7 47.1 91.1 95.4L639.9 466c.1-.7 .1-1.3 .1-2l0-16c0-79.5-64.5-144-144-144l-18.2 0 33 33zM452.4 217.8c-6.1 9.1-13.2 17.4-21 25 14.2 8.4 30.9 13.2 48.6 13.2 53 0 96-43 96-96s-43-96-96-96c-4.4 0-8.7 .3-12.9 .9 4.3 9.9 7.6 20.4 9.8 31.2 1.1-.1 2.1-.1 3.2-.1 35.3 0 64 28.7 64 64s-28.7 64-64 64c-9.9 0-19.2-2.2-27.6-6.2zM149.4 304l-5.4 0C64.5 304 0 368.5 0 448l0 16c0 8.8 7.2 16 16 16s16-7.2 16-16l0-16c0-55.1 39.7-100.8 92.1-110.2 7.2-12.1 15.7-23.5 25.3-33.8z"]],
    "traffic-cone": [512, 512, [], "f636", ["M64 480l384 0-53.3-128-277.3 0-53.3 128zm66.7-160l250.7 0-40-96-170.7 0-40 96zM184 192l144 0-64.6-155.1c-1.2-3-4.2-4.9-7.4-4.9s-6.1 1.9-7.4 4.9L184 192z", "M256 32c3.2 0 6.1 1.9 7.4 4.9L328 192 184 192 248.6 36.9c1.2-3 4.2-4.9 7.4-4.9zm85.3 192l40 96-250.7 0 40-96 170.7 0zm53.3 128l53.3 128-384 0 53.3-128 277.3 0zM219.1 24.6L29.3 480 16 480c-8.8 0-16 7.2-16 16s7.2 16 16 16l480 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-13.3 0-189.7-455.4C286.7 9.7 272.1 0 256 0s-30.7 9.7-36.9 24.6z"]],
    "star-sharp-half-stroke": [512, 512, ["star-sharp-half-alt"], "e28d", ["M43.3 208l126 91c5.5 4 7.9 11.1 5.9 17.6l-43.8 143.9 108.5-84.4 0-282.3-32.8 102.9C205.1 203.5 199 208 192 208L43.3 208z", "M240 93.9l0 282.3-108.5 84.4 43.8-143.9c2-6.5-.4-13.6-5.9-17.6l-126-91 148.7 0c7 0 13.1-4.5 15.2-11.1L240 93.9zm32 282.3l0-282.3 32.8 102.9c2.1 6.6 8.3 11.1 15.2 11.1l148.7 0-126 91c-5.5 4-7.9 11.1-5.9 17.6L380.5 460.6 272 376.2zM256 0c-11.7 0-22.1 7.6-25.7 18.8l-50 157.2-153.7 0c-14.7 0-26.6 11.9-26.6 26.6 0 8.5 4.1 16.6 11 21.6l130.3 94.1-50.8 167c-4.1 13.3 5.9 26.8 19.8 26.8 4.6 0 9.1-1.5 12.7-4.4L256 404.3 388.9 507.6c3.6 2.8 8.1 4.4 12.7 4.4 13.9 0 23.9-13.4 19.8-26.8l-50.8-167 130.3-94.1c6.9-5 11-13 11-21.6 0-14.7-11.9-26.6-26.6-26.6l-153.7 0-50-157.2C278.1 7.6 267.7 0 256 0z"]],
    "h1": [512, 512, [], "f313", ["", "M32 80c0-8.8-7.2-16-16-16S0 71.2 0 80L0 432c0 8.8 7.2 16 16 16s16-7.2 16-16l0-160 192 0 0 160c0 8.8 7.2 16 16 16s16-7.2 16-16l0-352c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 160-192 0 0-160zm400 0c0-5.5-2.9-10.7-7.6-13.6s-10.6-3.2-15.6-.7l-80 40c-7.9 4-11.1 13.6-7.2 21.5s13.6 11.1 21.5 7.2l56.8-28.4 0 310.1-64 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l160 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-64 0 0-336z"]],
    "tamale": [320, 512, [129748], "e451", ["M35.7 39.2c-.5-3.8 0-6.8 .8-8.6 .7-1.6 1.4-2.4 2.3-2.9 19.6-11.3 58.8-27.7 121.6-27.7S262.2 16.4 281.9 27.7c.8 .5 1.6 1.2 2.3 2.9 .8 1.9 1.3 4.8 .8 8.6l-22.5 168.8-48 0 17.8-142c1.1-8.8-5.1-16.8-13.9-17.9S201.5 53.2 200.4 62l-18.2 146-35.8 0-18.2-146c-1.1-8.8-9.1-15-17.9-13.9S95.3 57.2 96.4 66l17.8 142-56 0-22.5-168.8zm0 433.6L58.2 304 83.1 304c-8 22.5 1.9 48 23.8 58.9-3.5 27.7-6.9 55.4-10.4 83.1-1.1 8.8 5.1 16.8 13.9 17.9s16.8-5.1 17.9-13.9l10.4-83.1c8-1.8 15.5-5.5 21.7-11.1 8.3 7.4 18.9 11.7 29.9 12.2l10.3 82c1.1 8.8 9.1 15 17.9 13.9s15-9.1 13.9-17.9l-11-87.7c16.6-12.5 23.4-34.5 16.3-54.3l24.9 0 22.5 168.8c.5 3.8 0 6.8-.8 8.6-.7 1.6-1.4 2.4-2.3 2.9-19.6 11.3-58.8 27.7-121.6 27.7S58.4 495.6 38.8 484.3c-.8-.5-1.6-1.2-2.3-2.9-.8-1.9-1.3-4.8-.8-8.6z", "M38.8 27.7C58.4 16.4 97.6 0 160.3 0S262.2 16.4 281.9 27.7c.8 .5 1.6 1.2 2.3 2.9 .8 1.9 1.3 4.8 .8 8.6l-22.5 168.8 32.3 0 21.9-164.6C319 26.1 313 8.7 297.8 0 273.6-14 229-32 160.3-32S47-14 22.8 0C7.7 8.7 1.7 26.1 4 43.4L25.9 208 58.2 208 35.7 39.2c-.5-3.8 0-6.8 .8-8.6 .7-1.6 1.4-2.4 2.3-2.9zM58.2 304L25.9 304 4 468.6c-2.3 17.3 3.7 34.7 18.8 43.4 24.2 14 68.9 32 137.5 32s113.3-18 137.5-32c15.1-8.7 21.1-26.1 18.8-43.4l-21.9-164.6-32.3 0 22.5 168.8c.5 3.8 0 6.8-.8 8.6-.7 1.6-1.4 2.4-2.3 2.9-19.6 11.3-58.8 27.7-121.6 27.7S58.4 495.6 38.8 484.3c-.8-.5-1.6-1.2-2.3-2.9-.8-1.9-1.3-4.8-.8-8.6L58.2 304zm156.2-96L232.2 66c1.1-8.8-5.1-16.8-13.9-17.9S201.5 53.2 200.4 62l-18.2 146 32.2 0zm17.8 238l-11-87.7c-2.3 1.7-4.8 3.3-7.4 4.6-7.6 3.8-15.7 5.4-23.6 5l10.3 82c1.1 8.8 9.1 15 17.9 13.9s15-9.1 13.9-17.9zM106.9 362.9l0 0-10.4 83.1c-1.1 8.8 5.1 16.8 13.9 17.9s16.8-5.1 17.9-13.9l10.4-83.1c-10.3 2.3-21.5 1.1-31.7-4zM146.4 208L128.2 62c-1.1-8.8-9.1-15-17.9-13.9S95.3 57.2 96.4 66l17.8 142 32.2 0zM16.3 256c0 8.8 7.2 16 16 16l102.1 0-20.4 40.8c-4 7.9-.7 17.5 7.2 21.5s17.5 .7 21.5-7.2l17.7-35.4 17.7 35.4c4 7.9 13.6 11.1 21.5 7.2s11.1-13.6 7.2-21.5l-20.4-40.8 102.1 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-256 0c-8.8 0-16 7.2-16 16z"]],
    "route-highway": [448, 512, [], "f61a", ["M32 338.5c0 31.2 18.2 59.6 46.5 72.7L224 478.4 369.5 411.2c28.4-13.1 46.5-41.5 46.5-72.7 0-10.2-1.9-20.3-5.7-29.8l-11.4-28.5C389 255.7 384 229.5 384 203l0-11-320 0 0 11c0 26.5-5 52.7-14.9 77.2L37.7 308.8c-3.8 9.5-5.7 19.6-5.7 29.8z", "M232.2 2.3c-5.1-3-11.4-3-16.5 0L194.6 15c-31.9 19.2-71.5 20.7-104.8 4-17.7-8.9-39.2-3.8-51.1 12.1L14.5 63.3c-10.7 14.2-11.9 33.5-3 49 13.5 23.6 20.5 50.2 20.5 77.4L32 203c0 22.4-4.3 44.6-12.6 65.4L8 296.9c-5.3 13.2-8 27.4-8 41.6 0 43.7 25.4 83.5 65.1 101.8l152.2 70.2c4.3 2 9.2 2 13.4 0l152.2-70.2c39.7-18.3 65.1-58.1 65.1-101.8 0-14.3-2.7-28.4-8-41.6l-11.4-28.5c-8.3-20.8-12.6-43-12.6-65.4l0-13.4c0-27.1 7.1-53.8 20.6-77.4 8.8-15.5 7.6-34.7-3-49L409.3 31.1c-11.9-15.8-33.4-20.9-51.1-12.1-33.3 16.7-72.8 15.1-104.8-4L232.2 2.3zm178 306.5c3.8 9.5 5.7 19.6 5.7 29.8 0 31.2-18.2 59.6-46.5 72.7L224 478.4 78.5 411.2c-28.4-13.1-46.5-41.5-46.5-72.7 0-10.2 1.9-20.3 5.7-29.8l11.4-28.5C59 255.7 64 229.5 64 203l0-11 320 0 0 11c0 26.5 5 52.7 14.9 77.2l11.4 28.5zM386.4 160L61.6 160c-3.6-22.3-11.1-43.8-22.4-63.6-2.5-4.4-2.2-9.8 .9-13.9L64.3 50.3c2.6-3.5 7.3-4.6 11.2-2.6 43.1 21.6 94.2 19.6 135.5-5.2l13-7.8 13 7.8c41.3 24.8 92.4 26.8 135.5 5.2 3.9-1.9 8.6-.8 11.2 2.6l24.2 32.3c3 4 3.4 9.5 .9 13.9-11.3 19.7-18.8 41.3-22.4 63.6z"]],
    "paper-plane": [576, 512, [61913], "f1d8", ["M48.3 184.5c0 1.2 .7 2.2 1.8 2.6L252.4 269.4 501.5 20.2 50.2 181.8c-1.1 .4-1.9 1.5-1.9 2.7zM275 292l82.2 202.2c.4 1.1 1.5 1.8 2.6 1.8 1.2 0 2.3-.8 2.7-1.9L524.1 42.8 275 292z", "M275 292L524.1 42.8 362.5 494.1c-.4 1.1-1.5 1.9-2.7 1.9-1.2 0-2.2-.7-2.6-1.8L275 292zM501.5 20.2L252.4 269.4 50.1 187.2c-1.1-.4-1.8-1.5-1.8-2.6 0-1.2 .8-2.3 1.9-2.7L501.5 20.2zM38.1 216.8l205.8 83.6 83.6 205.8c5.3 13.1 18.1 21.7 32.3 21.7 14.7 0 27.8-9.2 32.8-23.1L570.6 8c3.5-9.8 1-20.6-6.3-28s-18.2-9.8-28-6.3L39.4 151.7c-13.9 5-23.1 18.1-23.1 32.8 0 14.2 8.6 27 21.7 32.3z"]],
    "object-intersect": [512, 512, [], "e49d", ["M192 224l0 96 96 0c17.7 0 32-14.3 32-32l0-96-96 0c-17.7 0-32 14.3-32 32z", "M64 32C46.3 32 32 46.3 32 64l0 16-32 0 0-16C0 28.7 28.7 0 64 0l16 0 0 32-16 0zm160 0l-96 0 0-32 96 0 0 32zM32 128l0 96-32 0 0-96 32 0zM0 288l0-16 32 0 0 16c0 17.7 14.3 32 32 32l48 0 0 32-48 0c-35.3 0-64-28.7-64-64zm160-32l0-32c0-35.3 28.7-64 64-64l128 0 0 128c0 35.3-28.7 64-64 64l-128 0 0-96zm320 32l32 0 0 96-32 0 0-96zm32-48l-32 0 0-16c0-17.7-14.3-32-32-32l-48 0 0-32 48 0c35.3 0 64 28.7 64 64l0 16zm0 192l0 16c0 35.3-28.7 64-64 64l-16 0 0-32 16 0c17.7 0 32-14.3 32-32l0-16 32 0zM384 512l-96 0 0-32 96 0 0 32zM160 400l32 0 0 48c0 17.7 14.3 32 32 32l16 0 0 32-16 0c-35.3 0-64-28.7-64-64l0-48zM352 112l-32 0 0-48c0-17.7-14.3-32-32-32l-16 0 0-32 16 0c35.3 0 64 28.7 64 64l0 48zm-32 80l-96 0c-17.7 0-32 14.3-32 32l0 96 96 0c17.7 0 32-14.3 32-32l0-96z"]],
    "book-atlas": [448, 512, ["atlas"], "f558", ["M32 64l0 328.6c9.4-5.4 20.3-8.6 32-8.6l336 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 32C46.3 32 32 46.3 32 64zM352 208a128 128 0 1 1 -256 0 128 128 0 1 1 256 0z", "M0 64C0 28.7 28.7 0 64 0L400 0c26.5 0 48 21.5 48 48l0 320c0 20.9-13.4 38.7-32 45.3l0 66.7 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L64 512c-35.3 0-64-28.7-64-64l0 0 0-384zM64 416c-17.7 0-32 14.3-32 32s14.3 32 32 32l320 0 0-64-320 0zM32 392.6c9.4-5.4 20.3-8.6 32-8.6l336 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 32C46.3 32 32 46.3 32 64l0 328.6zM318.7 224L279 224c-1.8 28.6-8.3 54-17.7 72.5 29.8-12.6 51.9-39.7 57.4-72.5zm-189.3 0c5.5 32.8 27.6 59.9 57.4 72.5-9.5-18.5-15.9-43.9-17.7-72.5l-39.7 0zm84.5 55c4.5 9.7 8.2 13.8 10.2 15.5 2-1.7 5.7-5.8 10.2-15.5 6.2-13.4 11.1-32.5 12.7-55l-45.8 0c1.6 22.5 6.5 41.6 12.7 55zm-12.7-87l45.8 0c-1.6-22.5-6.5-41.6-12.7-55-4.5-9.6-8.2-13.8-10.2-15.5-2 1.7-5.7 5.8-10.2 15.5-6.2 13.4-11.1 32.5-12.7 55zm117.6 0c-5.5-32.8-27.6-59.9-57.4-72.5 9.5 18.5 15.9 43.9 17.7 72.5l39.7 0zM169 192c1.8-28.6 8.3-54 17.7-72.5-29.8 12.6-51.9 39.7-57.4 72.5l39.7 0zM96 208a128 128 0 1 1 256 0 128 128 0 1 1 -256 0z"]],
    "table": [448, 512, [], "f0ce", ["M32 192l0 112 176 0 0-112-176 0zm0 144l0 80c0 17.7 14.3 32 32 32l144 0 0-112-176 0zM240 192l0 112 176 0 0-112-176 0zm0 144l0 112 144 0c17.7 0 32-14.3 32-32l0-80-176 0z", "M64 64C46.3 64 32 78.3 32 96l0 64 384 0 0-64c0-17.7-14.3-32-32-32L64 64zM0 192L0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 192zm416 0l-176 0 0 112 176 0 0-112zm-208 0l-176 0 0 112 176 0 0-112zm0 144l-176 0 0 80c0 17.7 14.3 32 32 32l144 0 0-112zm32 112l144 0c17.7 0 32-14.3 32-32l0-80-176 0 0 112z"]],
    "circle-sort": [512, 512, ["sort-circle"], "e030", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm121.8-46.8c-3.7-9-1.7-19.3 5.2-26.2l80-80c9.4-9.4 24.6-9.4 33.9 0l80 80c6.9 6.9 8.9 17.2 5.2 26.2S345.7 224 336 224l-160 0c-9.7 0-18.5-5.8-22.2-14.8zm0 93.6c3.7-9 12.5-14.8 22.2-14.8l160 0c9.7 0 18.5 5.8 22.2 14.8s1.7 19.3-5.2 26.2l-80 80c-9.4 9.4-24.6 9.4-33.9 0l-80-80c-6.9-6.9-8.9-17.2-5.2-26.2z", "M480 256a224 224 0 1 0 -448 0 224 224 0 1 0 448 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zM256 131.3l-60.7 60.7 121.4 0-60.7-60.7zM239 103c9.4-9.4 24.6-9.4 33.9 0l80 80c6.9 6.9 8.9 17.2 5.2 26.2S345.7 224 336 224l-160 0c-9.7 0-18.5-5.8-22.2-14.8s-1.7-19.3 5.2-26.2l80-80zM195.3 320l60.7 60.7 60.7-60.7-121.4 0zM273 409c-9.4 9.4-24.6 9.4-33.9 0l-80-80c-6.9-6.9-8.9-17.2-5.2-26.2S166.3 288 176 288l160 0c9.7 0 18.5 5.8 22.2 14.8s1.7 19.3-5.2 26.2l-80 80z"]],
    "heart": [512, 512, [128153, 128154, 128155, 128156, 128420, 129293, 129294, 129505, 9829, 10084, 61578], "f004", ["M32 165.1c0 55 34.4 107.1 71.8 152.5 42.1 51.2 93.4 96 128.5 122.9 6.2 4.8 14.4 7.5 23.7 7.5s17.4-2.7 23.7-7.5c35.1-26.8 86.4-71.7 128.5-122.9 37.3-45.4 71.8-97.5 71.8-152.5 0-55.9-45.3-101.1-101.1-101.1-32.4 0-62.9 15.6-81.9 41.9l-28 38.7c-3 4.2-7.8 6.6-13 6.6s-10-2.5-13-6.6l-28-38.7C196.1 79.6 165.6 64 133.1 64 77.3 64 32 109.3 32 165.1z", "M378.9 64c-32.4 0-62.9 15.6-81.9 41.9l-28 38.7c-3 4.2-7.8 6.6-13 6.6s-10-2.5-13-6.6l-28-38.7 0 0c-19-26.3-49.5-41.9-81.9-41.9-55.9 0-101.1 45.3-101.1 101.1 0 55 34.4 107.1 71.8 152.5 42.1 51.2 93.4 96 128.5 122.9 6.2 4.8 14.4 7.5 23.7 7.5s17.4-2.7 23.7-7.5c35.1-26.8 86.4-71.7 128.5-122.9 37.3-45.4 71.8-97.5 71.8-152.5 0-55.9-45.3-101.1-101.1-101.1zM271 87.1c25-34.6 65.2-55.1 107.9-55.1 73.5 0 133.1 59.6 133.1 133.1 0 67.4-41.6 127.3-79.1 172.8-44.1 53.6-97.3 100.1-133.8 127.9-12.4 9.4-27.6 14.1-43.1 14.1s-30.8-4.6-43.1-14.1C176.4 438 123.2 391.5 79.1 338 41.6 292.4 0 232.5 0 165.1 0 91.6 59.6 32 133.1 32 175.8 32 216 52.5 241 87.1l15 20.7 15-20.7z"]],
    "scythe": [576, 512, [], "f710", ["M43.9 192l458.6 0 37.3-160-228 0C203.7 32 103.7 89.4 49.2 182.8L43.9 192z", "M49.2 182.8l-5.4 9.2 458.6 0 37.3-160-228 0C203.7 32 103.7 89.4 49.2 182.8zM480.1 288l14.9-64-479 0c-5.7 0-11-3.1-13.9-8s-2.8-11.1 .1-16l19.4-33.2C81.8 63.5 192.3 0 311.8 0L560 0c4.9 0 9.5 2.2 12.5 6.1s4.2 8.8 3 13.6l-112 480c-2 8.6-10.6 14-19.2 11.9s-14-10.6-11.9-19.2L472.6 320 336 320c-8.8 0-16-7.2-16-16s7.2-16 16-16l144.1 0z"]],
    "circle-chevron-up": [512, 512, ["chevron-circle-up"], "f139", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm100.7 20.7l112-112c6.2-6.2 16.4-6.2 22.6 0l112 112c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L256 198.6 155.3 299.3c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6z", "M256 32a224 224 0 1 1 0 448 224 224 0 1 1 0-448zm0 480a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM379.3 276.7l-112-112c-6.2-6.2-16.4-6.2-22.6 0l-112 112c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0L256 198.6 356.7 299.3c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6z"]],
    "apostrophe": [192, 512, [], "27", ["M32 96l0 64c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32L64 64C46.3 64 32 78.3 32 96z", "M78.7 320.1c-8.8 .7-15.3 8.5-14.6 17.3s8.5 15.3 17.3 14.6l8-.7c58-4.8 102.7-53.4 102.7-111.6L192 96c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96l0 64c0 35.3 28.7 64 64 64l64 0c11.7 0 22.6-3.1 32-8.6l0 24.2c0 41.6-31.9 76.3-73.4 79.7l-8 .7zM160 160c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32l64 0c17.7 0 32 14.3 32 32l0 64z"]],
    "battery-half": [640, 512, ["battery-3"], "f242", ["M160 192l0 128 128 0 0-128-128 0z", "M496 96c26.5 0 48 21.5 48 48l0 224c0 26.5-21.5 48-48 48l-384 0c-26.5 0-48-21.5-48-48l0-224c0-26.5 21.5-48 48-48l384 0zm80 272l0-32 32 0c17.7 0 32-14.3 32-32l0-96c0-17.7-14.3-32-32-32l-32 0 0-32c0-44.2-35.8-80-80-80L112 64c-44.2 0-80 35.8-80 80l0 224c0 44.2 35.8 80 80 80l384 0c44.2 0 80-35.8 80-80zm0-64l0-96 32 0 0 96-32 0zM160 320l0-128 128 0 0 128-128 0zM128 184l0 144c0 13.3 10.7 24 24 24l144 0c13.3 0 24-10.7 24-24l0-144c0-13.3-10.7-24-24-24l-144 0c-13.3 0-24 10.7-24 24z"]],
    "font-awesome": [512, 512, [62501, 62694, "font-awesome-flag", "font-awesome-logo-full"], "f2b4", ["M64 128l0 288 397 0-58.2-131c-3.7-8.3-3.7-17.7 0-26L461 128 64 128z", "M64 32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm55.4 64c5.4-9.4 8.6-20.3 8.6-32 0-35.3-28.7-64-64-64S0 28.7 0 64c0 23.7 12.9 44.4 32 55.4l0 392.6 32 0 0-64 405.6 0c14.6 0 26.4-11.8 26.4-26.4 0-3.7-.8-7.3-2.3-10.7L432 272 493.7 133.1c1.5-3.4 2.3-7 2.3-10.7 0-14.6-11.8-26.4-26.4-26.4L119.4 96zM461 416l-397 0 0-288 397 0-58.2 131c-3.7 8.3-3.7 17.7 0 26L461 416z"]],
    "handcuffs": [576, 512, [], "e4f8", ["M32 320a160 160 0 1 0 320 0 160 160 0 1 0 -320 0zm288 0a128 128 0 1 1 -256 0 128 128 0 1 1 256 0zM128 112l0 26.9c20-7.1 41.6-10.9 64-10.9s44 3.8 64 10.9l0-26.9-128 0zm208 0l0 16c2 1.5 4 3.1 6 4.6 13.5-3 27.6-4.6 42-4.6 16.6 0 32.7 2.1 48 6l0-22-96 0zm35.3 48.5c8.9 10 16.9 20.7 24 32 65.4 5.8 116.6 60.6 116.6 127.5S460.7 441.7 395.4 447.5c-7.1 11.3-15.2 22-24 32 4.2 .3 8.4 .5 12.7 .5 88.4 0 160-71.6 160-160S472.4 160 384 160c-4.3 0-8.5 .2-12.7 .5z", "M312-32c0-13.3-10.7-24-24-24s-24 10.7-24 24 10.7 24 24 24 24-10.7 24-24zM192 56a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM128 80c-17.7 0-32 14.3-32 32l0 41.7C38.6 186.9 0 248.9 0 320 0 426 86 512 192 512s192-86 192-192c0-71.1-38.6-133.1-96-166.3l0-41.7c0-17.7-14.3-32-32-32L128 80zm128 58.9c-20-7.1-41.6-10.9-64-10.9s-44 3.8-64 10.9l0-26.9 128 0 0 26.9zM192 160a160 160 0 1 1 0 320 160 160 0 1 1 0-320zM320 320a128 128 0 1 0 -256 0 128 128 0 1 0 256 0zM192 224a96 96 0 1 1 0 192 96 96 0 1 1 0-192zM329.3 80c4.3 9.8 6.7 20.6 6.7 32l96 0 0 22c-15.3-3.9-31.4-6-48-6-14.4 0-28.5 1.6-42 4.6 10.6 8.5 20.4 17.8 29.4 27.9 4.2-.3 8.4-.5 12.7-.5 88.4 0 160 71.6 160 160S472.4 480 384 480c-4.3 0-8.5-.2-12.7-.5-9 10.1-18.8 19.4-29.4 27.9 13.5 3 27.6 4.6 42 4.6 106 0 192-86 192-192 0-77.5-45.9-144.3-112-174.6l0-33.4c0-17.7-14.3-32-32-32L329.3 80zm84.7 148.8C452.4 241.4 480 277.5 480 320s-27.6 78.6-65.9 91.2c-5.2 12.7-11.5 24.8-18.7 36.3 65.4-5.8 116.6-60.6 116.6-127.5S460.7 198.3 395.4 192.5c7.2 11.5 13.5 23.6 18.7 36.3zM384 56a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]],
    "square-bangladeshi-taka": [448, 512, [], "e744", ["M32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64C46.3 64 32 78.3 32 96zm80.2 45.4c1.5-8.7 9.7-14.6 18.4-13.2l17.4 2.9c25.3 4.2 43.9 26.2 43.9 51.9l0 25 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0 0 91.4c0 11.4 9.2 20.6 20.6 20.6l11.4 0c44.2 0 80-35.8 80-80l0-11.4c0-11.4-9.2-20.6-20.6-20.6l-3.4 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l3.4 0c29 0 52.6 23.5 52.6 52.6l0 11.4c0 61.9-50.1 112-112 112l-11.4 0c-29 0-52.6-23.5-52.6-52.6l0-91.4-29.7 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l29.7 0 0-25c0-10.1-7.3-18.6-17.2-20.3l-17.4-2.9c-8.7-1.5-14.6-9.7-13.2-18.4z", "M64 64C46.3 64 32 78.3 32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm112.2 45.4c1.5-8.7 9.7-14.6 18.4-13.2l17.4 2.9c25.3 4.2 43.9 26.2 43.9 51.9l0 25 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0 0 91.4c0 11.4 9.2 20.6 20.6 20.6l11.4 0c44.2 0 80-35.8 80-80l0-11.4c0-11.4-9.2-20.6-20.6-20.6l-3.4 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l3.4 0c29 0 52.6 23.5 52.6 52.6l0 11.4c0 61.9-50.1 112-112 112l-11.4 0c-29 0-52.6-23.5-52.6-52.6l0-91.4-29.7 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l29.7 0 0-25c0-10.1-7.3-18.6-17.2-20.3l-17.4-2.9c-8.7-1.5-14.6-9.7-13.2-18.4z"]],
    "hat-cowboy-side": [640, 512, [], "f8c1", ["M32 366.5L32 380c0 19.9 16.1 36 36 36L475.2 416 255 269.2C226.4 250.2 192.8 240 158.5 240 88.6 240 32 296.6 32 366.5zM185.3 209.8c18.2 2.4 35.9 7.2 52.8 14.2l219.8 0-27.7-124.7c-4.6-20.6-22.9-35.3-44-35.3l-1 0c-6.4 0-12.6 1.5-18.3 4.3-29.5 14.8-64.3 14.8-93.8 0-5.7-2.8-11.9-4.3-18.3-4.3l-1 0c-21.1 0-39.4 14.7-44 35.3L185.3 209.8zm309.4 32.1L533.3 416 572 416c19.9 0 36-16.1 36-36l0-4c0-67.4-49-123.3-113.4-134.1z", "M253.8 64c-21.1 0-39.4 14.7-44 35.3L185.3 209.8c18.2 2.4 35.9 7.2 52.8 14.2l219.8 0-27.7-124.7c-4.6-20.6-22.9-35.3-44-35.3l-1 0c-6.4 0-12.6 1.5-18.3 4.3-29.5 14.8-64.3 14.8-93.8 0-5.7-2.8-11.9-4.3-18.3-4.3l-1 0zM152.9 208.1L178.6 92.3C186.4 57.1 217.7 32 253.8 32l1 0c11.3 0 22.5 2.6 32.6 7.7 20.5 10.3 44.7 10.3 65.2 0 10.1-5.1 21.3-7.7 32.6-7.7l1 0c36.1 0 67.4 25.1 75.2 60.3l25.9 116.3C572.9 216.4 640 288.4 640 376l0 4c0 37.6-30.4 68-68 68L68 448c-37.6 0-68-30.4-68-68l0-13.5c0-85.6 67.9-155.4 152.9-158.4zm341.8 33.8L533.3 416 572 416c19.9 0 36-16.1 36-36l0-4c0-67.4-49-123.3-113.4-134.1zm.3 148.9L465 256 292.8 256 494.9 390.7zM158.5 240C88.6 240 32 296.6 32 366.5L32 380c0 19.9 16.1 36 36 36L475.2 416 255 269.2c-28.6-19.1-62.2-29.2-96.5-29.2z"]],
    "sausage": [512, 512, [], "f820", ["M96 416c0 35.3 28.7 64 64 64 176.7 0 320-143.3 320-320 0-35.3-28.7-64-64-64s-64 28.7-64 64c0 106-86 192-192 192-35.3 0-64 28.7-64 64zm64-16c0-8.8 7.2-16 16-16 114.9 0 208-93.1 208-208 0-8.8 7.2-16 16-16s16 7.2 16 16c0 132.5-107.5 240-240 240-8.8 0-16-7.2-16-16z", "M400 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l64 0c8.8 0 16-7.2 16-16S472.8 0 464 0L400 0zM32 400c0-8.8-7.2-16-16-16S0 391.2 0 400l0 64c0 8.8 7.2 16 16 16s16-7.2 16-16l0-64zM480 160c0 176.7-143.3 320-320 320-35.3 0-64-28.7-64-64s28.7-64 64-64c106 0 192-86 192-192 0-35.3 28.7-64 64-64s64 28.7 64 64zm32 0c0-53-43-96-96-96s-96 43-96 96c0 88.4-71.6 160-160 160-53 0-96 43-96 96s43 96 96 96c194.4 0 352-157.6 352-352zm-112 0c-8.8 0-16 7.2-16 16 0 114.9-93.1 208-208 208-8.8 0-16 7.2-16 16s7.2 16 16 16c132.5 0 240-107.5 240-240 0-8.8-7.2-16-16-16z"]],
    "chevrons-down": [448, 512, ["chevron-double-down"], "f322", ["", "M4.7 75.3l208 208c6.2 6.2 16.4 6.2 22.6 0l208-208c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0L224 249.4 27.3 52.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6zm0 192l208 208c6.2 6.2 16.4 6.2 22.6 0l208-208c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0L224 441.4 27.3 244.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6z"]],
    "industry": [512, 512, [], "f275", ["M32 80l0 336c0 17.7 14.3 32 32 32l384 0c17.7 0 32-14.3 32-32l0-257.1c0-6.5-7.4-10.3-12.7-6.5l-138 99.3c-4.9 3.5-11.3 4-16.6 1.3s-8.7-8.2-8.7-14.2l0-81.9c0-6.4-7.1-10.2-12.4-6.7L152.9 242.6c-4.9 3.3-11.2 3.6-16.4 .8s-8.5-8.2-8.5-14.1L128 80c0-8.8-7.2-16-16-16L48 64c-8.8 0-16 7.2-16 16z", "M48 64c-8.8 0-16 7.2-16 16l0 336c0 17.7 14.3 32 32 32l384 0c17.7 0 32-14.3 32-32l0-257.1c0-6.5-7.4-10.3-12.7-6.5l-138 99.3c-4.9 3.5-11.3 4-16.6 1.3s-8.7-8.2-8.7-14.2l0-81.9c0-6.4-7.1-10.2-12.4-6.7L152.9 242.6c-4.9 3.3-11.2 3.6-16.4 .8s-8.5-8.2-8.5-14.1L128 80c0-8.8-7.2-16-16-16L48 64zM0 80C0 53.5 21.5 32 48 32l64 0c26.5 0 48 21.5 48 48l0 119.4 113.8-75.9c26.6-17.7 62.2 1.3 62.2 33.3l0 50.6 112.6-81.1c26.5-19.1 63.4-.1 63.4 32.5L512 416c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 80z"]],
    "people-dress-simple": [512, 512, [], "e218", ["M42.5 352l171.2 0-34.8-121.7c-6.5-22.7-27.2-38.3-50.8-38.3s-44.3 15.6-50.8 38.3L42.5 352zM96.1 64a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zM298.5 352l171.2 0-34.8-121.7c-6.5-22.7-27.2-38.3-50.8-38.3s-44.3 15.6-50.8 38.3L298.5 352zM352.1 64a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M128.1 32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm0 96a64 64 0 1 0 0-128 64 64 0 1 0 0 128zm85.6 224L42.5 352 77.3 230.3c6.5-22.7 27.2-38.3 50.8-38.3s44.3 15.6 50.8 38.3L213.7 352zM128.1 160c-37.9 0-71.2 25.1-81.6 61.5L11.8 343.2C5.9 363.7 21.3 384 42.5 384l21.6 0 0 112c0 8.8 7.2 16 16 16s16-7.2 16-16l0-112 64 0 0 112c0 8.8 7.2 16 16 16s16-7.2 16-16l0-112 21.6 0c21.3 0 36.6-20.3 30.8-40.8L209.7 221.5C199.3 185.1 166 160 128.1 160zm256-128a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm0 96a64 64 0 1 0 0-128 64 64 0 1 0 0 128zm85.6 224l-171.2 0 34.8-121.7c6.5-22.7 27.2-38.3 50.8-38.3s44.3 15.6 50.8 38.3L469.7 352zM384.1 160c-37.9 0-71.2 25.1-81.6 61.5L267.8 343.2c-5.8 20.4 9.5 40.8 30.8 40.8l21.6 0 0 112c0 8.8 7.2 16 16 16s16-7.2 16-16l0-112 64 0 0 112c0 8.8 7.2 16 16 16s16-7.2 16-16l0-112 21.6 0c21.3 0 36.6-20.3 30.8-40.8L465.7 221.5C455.3 185.1 422 160 384.1 160z"]],
    "lines-leaning": [384, 512, [], "e51e", ["", "M190.9 53.7c3.2-8.2-.9-17.5-9.2-20.7s-17.5 .9-20.7 9.2l-160 416c-3.2 8.2 .9 17.5 9.2 20.7s17.5-.9 20.7-9.2l160-416zm84.7-21.3c-8.6-2-17.2 3.4-19.2 12l-96 416c-2 8.6 3.4 17.2 12 19.2s17.2-3.4 19.2-12l96-416c2-8.6-3.4-17.2-12-19.2zM368 32c-8.8 0-16 7.2-16 16l0 416c0 8.8 7.2 16 16 16s16-7.2 16-16l0-416c0-8.8-7.2-16-16-16z"]],
    "passport": [384, 512, [], "f5ab", ["M32 64l0 384c0 17.7 14.3 32 32 32l256 0c17.7 0 32-14.3 32-32l0-384c0-17.7-14.3-32-32-32L64 32C46.3 32 32 46.3 32 64zM64 208c0-67.1 51.7-122.2 117.4-127.5 3.5-.3 7-.5 10.6-.5s7.1 .1 10.6 .5c65.7 5.4 117.4 60.4 117.4 127.5 0 70.7-57.3 128-128 128S64 278.7 64 208zM96 400c0-8.8 7.2-16 16-16l160 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-160 0c-8.8 0-16-7.2-16-16z", "M320 32c17.7 0 32 14.3 32 32l0 384c0 17.7-14.3 32-32 32L64 480c-17.7 0-32-14.3-32-32L32 64c0-17.7 14.3-32 32-32l256 0zM64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-384c0-35.3-28.7-64-64-64L64 0zM229.3 296.5c9.5-18.5 15.9-43.9 17.7-72.5l39.7 0c-5.5 32.8-27.6 59.9-57.4 72.5zm-74.5 0C125 283.9 102.8 256.8 97.3 224l39.7 0c1.8 28.6 8.3 54 17.7 72.5zM169.1 224l45.8 0c-1.6 22.5-6.5 41.6-12.7 55-4.5 9.7-8.2 13.8-10.2 15.5-2-1.7-5.7-5.8-10.2-15.5-6.2-13.4-11.1-32.5-12.7-55zm0-32c1.6-22.5 6.5-41.6 12.7-55 4.5-9.6 8.2-13.8 10.2-15.5 2 1.7 5.7 5.8 10.2 15.5 6.2 13.4 11.1 32.5 12.7 55l-45.8 0zm77.9 0c-1.8-28.6-8.3-54-17.7-72.5 29.8 12.6 51.9 39.7 57.4 72.5L247 192zm-92.2-72.5C145.3 138 138.8 163.4 137 192l-39.7 0c5.5-32.8 27.6-59.9 57.4-72.5zM192 336a128 128 0 1 0 0-256 128 128 0 1 0 0 256zm-80 48c-8.8 0-16 7.2-16 16s7.2 16 16 16l160 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-160 0z"]],
    "infinity": [640, 512, [8734, 9854], "f534", ["", "M0 233.5C0 157.5 61.5 96 137.5 96 176.7 96 214.1 112.8 240.2 142.1l79.8 89.8 79.8-89.8C425.9 112.8 463.3 96 502.5 96 578.5 96 640 157.5 640 233.5l0 45.1c0 75.9-61.5 137.5-137.5 137.5-39.3 0-76.7-16.8-102.7-46.1l-79.8-89.8-79.8 89.8C214.1 399.2 176.7 416 137.5 416 61.5 416 0 354.5 0 278.5l0-45.1zM298.6 256l-82.3-92.6C196.3 140.9 167.6 128 137.5 128 79.2 128 32 175.2 32 233.5l0 45.1c0 58.2 47.2 105.5 105.5 105.5 30.1 0 58.8-12.9 78.8-35.4L298.6 256zm42.8 0l82.3 92.6c20 22.5 48.7 35.4 78.8 35.4 58.2 0 105.5-47.2 105.5-105.5l0-45.1c0-58.2-47.2-105.5-105.5-105.5-30.1 0-58.8 12.9-78.8 35.4L341.4 256z"]],
    "hand-heart": [640, 512, [], "f4bc", ["M103.5 279l1.8-1.7c9.4-7.7 23.3-7.1 32.1 1.7l59.7 59.7c4.6 4.6 11.5 5.9 17.4 3.5s9.9-8.3 9.9-14.8l0-239.4c0-13.3 10.7-24 24-24 12.4 0 22.6 9.4 23.9 21.5l.1 2.5 0 152c0 8.8 7.2 16 16 16s16-7.2 16-16l0-184c0-13.3 10.7-24 24-24 13.2 0 24 10.7 24 24l0 184c0 8.8 7.2 16 16 16s16-7.2 16-16l0-152 .1-2.5C385.9 73.4 396.1 64 408.5 64l2.4 .1C423 65.4 432.5 75.6 432.5 88l0 152c0 8.8 7.2 16 16 16s16-7.2 16-16l0-88c0-13.3 10.7-24 24-24l2.4 .1c12.1 1.2 21.6 11.4 21.6 23.9l0 109.8c-11.4 3.6-22.2 8.8-32 15.5-20.1-13.7-44.1-21.3-69.1-21.3-67.9 0-122.9 55-122.9 122.9l0 2.5c0 34.4 14.2 65.5 30.3 90.1 1.1 1.7 2.3 3.5 3.5 5.2-39.8-7.1-77-25.1-107.2-52.5l-7.8-7.4-103.8-103.8c-9.4-9.4-9.4-24.6 0-33.9z", "M549.6 304c41.4 0 74.9 33.5 74.9 74.9 0 39.6-24.9 73-46 97-25.5 29-56.1 53.8-76.2 68.7-13 9.7-30.5 9.7-43.5 0-20.1-15-50.7-39.7-76.2-68.7-21.2-24.1-46-57.4-46-97 0-41.4 33.5-74.9 74.9-74.9 24 0 46.6 11.5 60.7 31l8.4 11.7 8.4-11.7c14.1-19.5 36.7-31 60.7-31zm0 32c-13.8 0-26.7 6.6-34.7 17.8l-21.4 29.6c-3 4.2-7.8 6.6-13 6.6s-10-2.5-13-6.6l-21.4-29.6c-8.1-11.1-21-17.8-34.7-17.8-23.7 0-42.9 19.2-42.9 42.9 0 26.7 17.1 52.1 38.1 75.9 23.4 26.6 52 49.8 71.3 64.2 1.7 1.2 3.6 1.2 5.3 0 19.3-14.4 47.9-37.6 71.3-64.2 20.9-23.8 38.1-49.2 38.1-75.9 0-23.7-19.2-42.9-42.9-42.9zM328.5 0c24.9 0 46 16.3 53.2 38.8 7.9-4.3 17.1-6.8 26.8-6.8l5.7 .3C442.4 35.2 464.5 59 464.5 88l0 13.4c7.3-3.5 15.4-5.4 24-5.4l5.7 .3c28.2 2.9 50.3 26.7 50.3 55.7l0 104.2c-11 .5-21.7 2.3-32 5.6l0-109.8c0-12.4-9.5-22.6-21.6-23.9l-2.4-.1c-13.3 0-24 10.7-24 24l0 88c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-152c0-12.4-9.5-22.6-21.6-23.9l-2.4-.1c-12.4 0-22.6 9.4-23.9 21.5l-.1 2.5 0 152c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-184c0-13.3-10.8-24-24-24-13.3 0-24 10.7-24 24l0 184c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-152-.1-2.5c-1.2-12.1-11.5-21.5-23.9-21.5-13.3 0-24 10.7-24 24l0 239.4c0 6.5-3.9 12.3-9.9 14.8s-12.9 1.1-17.4-3.5L137.5 279c-8.8-8.8-22.7-9.3-32.1-1.7l-1.8 1.7c-9.4 9.4-9.4 24.6 0 33.9l103.8 103.8 7.8 7.4c30.2 27.4 67.4 45.4 107.2 52.5 7.8 11.4 16.2 21.8 24.2 31 1.2 1.4 2.5 2.8 3.8 4.2-58.1-2.3-113.6-24.9-156.7-63.9l-8.9-8.5-103.8-103.8c-21.9-21.9-21.9-57.3 0-79.2l4.2-3.8c22-17.9 54.4-16.7 74.9 3.8l32.4 32.4 0-200.8c0-30.9 25.1-56 56-56 9.7 0 18.8 2.4 26.7 6.8 7.3-22.5 28.4-38.8 53.3-38.8z"]],
    "clone": [512, 512, [], "f24d", ["M192 64l0 224c0 17.7 14.3 32 32 32l224 0c17.7 0 32-14.3 32-32l0-224c0-17.7-14.3-32-32-32L224 32c-17.7 0-32 14.3-32 32z", "M288 480L64 480c-17.7 0-32-14.3-32-32l0-224c0-17.7 14.3-32 32-32l48 0 0-32-48 0c-35.3 0-64 28.7-64 64L0 448c0 35.3 28.7 64 64 64l224 0c35.3 0 64-28.7 64-64l0-48-32 0 0 48c0 17.7-14.3 32-32 32zM224 320c-17.7 0-32-14.3-32-32l0-224c0-17.7 14.3-32 32-32l224 0c17.7 0 32 14.3 32 32l0 224c0 17.7-14.3 32-32 32l-224 0zm-64-32c0 35.3 28.7 64 64 64l224 0c35.3 0 64-28.7 64-64l0-224c0-35.3-28.7-64-64-64L224 0c-35.3 0-64 28.7-64 64l0 224z"]],
    "forward": [576, 512, [9193], "f04e", ["M96 72l0 368c0 3.2 1.9 6.1 4.9 7.4s6.4 .6 8.7-1.6l192-184c1.6-1.5 2.5-3.6 2.5-5.8s-.9-4.3-2.5-5.8l-192-184c-2.3-2.2-5.7-2.8-8.7-1.6S96 68.8 96 72zm240 0l0 368c0 3.2 1.9 6.1 4.9 7.4s6.4 .6 8.7-1.6l192-184c1.6-1.5 2.5-3.6 2.5-5.8s-.9-4.3-2.5-5.8l-192-184c-2.3-2.2-5.7-2.8-8.7-1.6S336 68.8 336 72z", "M109.5 66.2c-2.3-2.2-5.7-2.8-8.7-1.6S96 68.8 96 72l0 368c0 3.2 1.9 6.1 4.9 7.4s6.4 .6 8.7-1.6l192-184c1.6-1.5 2.5-3.6 2.5-5.8s-.9-4.3-2.5-5.8l-192-184zM304 303.7L131.7 468.9c-11.6 11.1-28.6 14.2-43.4 7.9S64 456 64 440L64 72c0-16 9.6-30.5 24.3-36.8s31.8-3.2 43.4 7.9L304 208.3 304 72c0-16 9.6-30.5 24.3-36.8s31.8-3.2 43.4 7.9l192 184c7.9 7.5 12.3 18 12.3 28.9s-4.5 21.3-12.3 28.9l-192 184c-11.6 11.1-28.6 14.2-43.4 7.9S304 456 304 440l0-136.3zM340.9 64.6c-2.9 1.3-4.9 4.2-4.9 7.4l0 368c0 3.2 1.9 6.1 4.9 7.4s6.4 .6 8.7-1.6l192-184c1.6-1.5 2.5-3.6 2.5-5.8s-.9-4.3-2.5-5.8l-192-184c-2.3-2.2-5.7-2.8-8.7-1.6z"]],
    "square-r": [448, 512, [], "e27c", ["M8 104C8 68.7 36.7 40 72 40l304 0c35.3 0 64 28.7 64 64l0 304c0 35.3-28.7 64-64 64L72 472c-35.3 0-64-28.7-64-64L8 104zm24-8l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64C46.3 64 32 78.3 32 96zm128 80c0-8.8 7.2-16 16-16l64 0c35.3 0 64 28.7 64 64 0 25.5-15 47.6-36.6 57.9l33.4 44.5c5.3 7.1 3.9 17.1-3.2 22.4s-17.1 3.9-22.4-3.2l-43.2-57.6-40 0 0 48c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-160zm32 16l0 64 48 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-48 0z", "M64 64C46.3 64 32 78.3 32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm176 64l64 0c35.3 0 64 28.7 64 64 0 25.5-15 47.6-36.6 57.9l33.4 44.5c5.3 7.1 3.9 17.1-3.2 22.4s-17.1 3.9-22.4-3.2l-43.2-57.6-40 0 0 48c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-160c0-8.8 7.2-16 16-16zm64 96c17.7 0 32-14.3 32-32s-14.3-32-32-32l-48 0 0 64 48 0z"]],
    "period": [128, 512, [], "2e", ["M32 416c0 17.7 14.3 32 32 32s32-14.3 32-32-14.3-32-32-32-32 14.3-32 32z", "M64 448c-17.7 0-32-14.3-32-32s14.3-32 32-32 32 14.3 32 32-14.3 32-32 32zm0 32c35.3 0 64-28.7 64-64s-28.7-64-64-64-64 28.7-64 64 28.7 64 64 64z"]],
    "m": [448, 512, [109], "4d", ["", "M11.3 32.7c6.7-2.1 14 .5 17.9 6.3L224 323.7 418.8 39c4-5.8 11.2-8.3 17.9-6.3S448 41 448 48l0 416c0 8.8-7.2 16-16 16s-16-7.2-16-16L416 99.7 237.2 361c-3 4.4-7.9 7-13.2 7s-10.2-2.6-13.2-7L32 99.7 32 464c0 8.8-7.2 16-16 16S0 472.8 0 464L0 48c0-7 4.6-13.2 11.3-15.3z"]],
    "money-check-pen": [576, 512, ["money-check-edit"], "f872", ["", "M448.4 96l-384 0c-17.7 0-32 14.3-32 32l0 256c0 17.7 14.3 32 32 32l197.8 0c-4.1 9-7.1 18.5-8.7 28.3l-.6 3.7-188.5 0c-35.3 0-64-28.7-64-64l0-256c0-35.3 28.7-64 64-64l384 0c35.3 0 64 28.7 64 64l0 76.1c-10.8 0-21.6 1.5-32 4.4l0-80.6c0-17.7-14.3-32-32-32zM96.4 304c0-8.8 7.2-16 16-16l160 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-160 0c-8.8 0-16-7.2-16-16zm16-112l288 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-288 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zM341.5 440.1c-4.7 4.7-7.8 10.8-8.9 17.4l-8.5 50.8 50.8-8.5c6.6-1.1 12.6-4.2 17.4-8.9l102.2-102.2-50.7-50.7-102.2 102.2zM466.3 315.3l50.7 50.7 20.7-20.7c14-14 14-36.7 0-50.7s-36.7-14-50.7 0l-20.7 20.7zM301 452.2c2.2-13.2 8.4-25.3 17.9-34.7L464.4 272c26.5-26.5 69.5-26.5 96 0s26.5 69.5 0 96L414.9 513.5c-9.4 9.4-21.6 15.7-34.7 17.9l-74.6 12.4c-.8 .1-1.6 .2-2.4 .2-8.2 0-14.8-6.6-14.8-14.8 0-.8 .1-1.6 .2-2.4L301 452.2z"]],
    "road-spikes": [640, 512, [], "e568", ["M96 169.7l0 150.3 100.2 0C182.1 298.8 148.7 248.7 96 169.7zm128 0l0 150.3 100.2 0c-14.1-21.2-47.5-71.3-100.2-150.3zm128 0l0 150.3 100.2 0c-14.1-21.2-47.5-71.3-100.2-150.3zm128 0L480 320 580.2 320 480 169.7z", "M93.3 108c50.2 75.4 83.1 124.7 98.7 148l0-139.2c0-15.8 20.5-22 29.3-8.9 50.2 75.4 83.1 124.7 98.7 148l0-139.2c0-15.8 20.5-22 29.3-8.9 50.2 75.4 83.1 124.7 98.7 148l0-139.2c0-15.8 20.5-22 29.3-8.9L606.8 302.2c14.2 21.3-1.1 49.8-26.6 49.8L64 352 64 116.8c0-15.8 20.5-22 29.3-8.9zM512 320l68.2 0-100.2-150.3 0 150.3 32 0zm-90.6-46.2l-69.4-104.1 0 150.3 100.2 0-30.8-46.2zm-128 0l-69.4-104.1 0 150.3 100.2 0-30.8-46.2zm-128 0L96 169.7 96 320 196.2 320 165.4 273.8zM16 416l608 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L16 448c-8.8 0-16-7.2-16-16s7.2-16 16-16z"]],
    "fish-cooked": [576, 512, [], "f7fe", ["M37.6 135.2L62.1 245.6c1.5 6.9 1.5 14 0 20.8l-24.5 110.4 84.9-58.4c6.6-4.5 15.5-3.5 20.9 2.4 21.4 23.6 49.6 47.6 80.7 65.6 31.2 18.1 64.3 29.6 95.9 29.6 51.6 0 108.2-26.5 152.4-61.5 22-17.4 40.2-36.4 52.9-54.3 13-18.4 18.7-33.7 18.7-44.2s-5.7-25.8-18.7-44.2c-12.6-17.9-30.9-36.9-52.9-54.3-44.3-35.1-100.9-61.5-152.4-61.5-31.6 0-64.7 11.5-95.9 29.6-31.1 18-59.3 42-80.7 65.6-5.4 5.9-14.3 7-20.9 2.4L37.6 135.2zm191.1 77.5l64-64c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6l-64 64c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6zm16 112l160-160c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6l-160 160c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6zm112 16l64-64c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6l-64 64c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6z", "M143.4 191.2c21.4-23.6 49.6-47.6 80.7-65.6 31.2-18.1 64.3-29.6 95.9-29.6 51.6 0 108.2 26.5 152.4 61.5 22 17.4 40.2 36.4 52.9 54.3 13 18.4 18.7 33.7 18.7 44.2s-5.7 25.8-18.7 44.2c-12.6 17.9-30.9 36.9-52.9 54.3-44.3 35.1-100.9 61.5-152.4 61.5-31.6 0-64.7-11.5-95.9-29.6-31.1-18-59.3-42-80.7-65.6-5.4-5.9-14.3-7-20.9-2.4L37.6 376.8 62.1 266.4c1.5-6.9 1.5-14 0-20.8l-24.5-110.4 84.9 58.4c6.6 4.5 15.5 3.5 20.9-2.4zM320 64c-39.1 0-77.8 14.1-111.9 33.9-29.8 17.2-56.8 39.3-78.7 61.6L43.7 100.6C39.3 97.6 34.1 96 28.8 96 12 96-.5 111.6 3.2 128L30.8 252.5c.5 2.3 .5 4.7 0 6.9L3.2 384c-3.6 16.4 8.8 32 25.6 32 5.3 0 10.5-1.6 14.9-4.6-9.1-13.2-9.1-13.2 0 0l85.6-58.9c21.9 22.4 49 44.4 78.7 61.6 34.2 19.8 72.9 33.9 111.9 33.9 61.4 0 124.8-30.9 172.3-68.5 23.9-18.9 44.4-40.1 59.2-60.9 14.4-20.4 24.5-42.4 24.5-62.6s-10.2-42.2-24.5-62.6c-14.7-20.8-35.2-42-59.2-60.9-47.5-37.6-110.9-68.5-172.3-68.5zm-4.7 107.3c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-64 64c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l64-64zm112 16c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-160 160c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l160-160zm16 112c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-64 64c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l64-64z"]],
    "person-seat-reclined": [512, 512, [], "e21f", ["M168 72a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm28.8 153.2l22.6 90.5C224.7 337 243.9 352 266 352l17.5 0-34.9-139.8c-3-11.9-13.6-20.2-25.9-20.2-17.4 0-30.1 16.3-25.9 33.2z", "M192 48a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm0 80a56 56 0 1 0 0-112 56 56 0 1 0 0 112zm30.7 64c12.2 0 22.9 8.3 25.9 20.2L283.5 352 266 352c-22 0-41.2-15-46.6-36.4l-22.6-90.5c-4.2-16.8 8.5-33.2 25.9-33.2zm93.8 160L279.6 204.5c-6.5-26.1-30-44.5-56.9-44.5-38.2 0-66.2 35.9-56.9 72.9l22.6 90.5C197.3 359 229.3 384 266 384l37.7 0 .4 0 .3 0 50 0c12.1 0 23.2 6.8 28.6 17.7l50.7 101.5c3.6 7.1 11.8 10.5 19.4 8l48-16c8.4-2.8 12.9-11.9 10.1-20.2s-11.9-12.9-20.2-10.1l-34.8 11.6-44.5-89.1c-10.8-21.7-33-35.4-57.2-35.4l-37.8 0zM95.6 172.3c-2-8.6-10.6-13.9-19.2-11.9s-13.9 10.6-11.9 19.2l46.6 198c11.9 50.6 57 86.3 109 86.3l84 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-84 0c-37.1 0-69.4-25.5-77.9-61.7l-46.6-198z"]],
    "mountain": [512, 512, [127956], "f6fc", ["M33 436.2l104.9-194.2 57.6 72 2.6 2.6c2.9 2.3 6.4 3.5 10.2 3.4 4.9-.1 9.6-2.4 12.6-6.4l43.2-57.6 117.8 0 97.3 180.2c1.3 2.5 1.2 5.5-.2 7.9-1.4 2.4-4.1 3.9-6.9 3.9L40 448c-2.1 0-4.1-.8-5.6-2.3l-1.3-1.6c-1.4-2.4-1.5-5.4-.2-7.9z", "M256 0c14.7 0 28.2 8.1 35.2 21l216 400c6.7 12.4 6.4 27.4-.8 39.5l-3 4.3c-6.4 8.2-15.8 13.5-26.2 14.8l-5.2 .3-432 0-5.2-.3c-10.3-1.4-19.7-6.7-26.2-14.8l-3-4.3c-6.3-10.6-7.4-23.4-3-34.7l2.2-4.8 216-400 2.9-4.6C231.2 6.2 243.2 0 256 0zM33 436.2c-1.3 2.5-1.3 5.5 .2 7.9l1.3 1.6c1.5 1.4 3.5 2.3 5.6 2.3l432 0c2.8 0 5.4-1.5 6.9-3.9 1.4-2.4 1.5-5.4 .2-7.9L381.8 256 264 256 220.8 313.6c-3 4-7.6 6.3-12.6 6.4-3.7 .1-7.3-1.2-10.2-3.4L195.5 314 137.9 242 33 436.2zM256 32c-2.4 0-4.6 1.1-6.1 2.9l-1.3 2.1-94.2 174.3 2.1 2.6 51.1 63.8 35.6-47.4 2.6-2.7c2.8-2.4 6.4-3.7 10.2-3.7l108.5 0-101.4-187.8c-1.4-2.6-4.1-4.2-7.1-4.2z"]],
    "circle-w": [512, 512, [], "e12c", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm112.5-76.1c-2.1-8.6 3.1-17.3 11.6-19.4s17.3 3.1 19.4 11.6l27 108.1 38.3-109.5c2.2-6.4 8.3-10.7 15.1-10.7s12.9 4.3 15.1 10.7l38.3 109.5 27-108.1c2.1-8.6 10.8-13.8 19.4-11.6s13.8 10.8 11.6 19.4l-40 160c-1.7 6.9-7.7 11.8-14.8 12.1s-13.5-4-15.8-10.7L256 224.4 215.1 341.3c-2.3 6.7-8.8 11-15.8 10.7s-13.1-5.2-14.8-12.1l-40-160z", "M256 32a224 224 0 1 1 0 448 224 224 0 1 1 0-448zm0 480a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM175.5 172.1c-2.1-8.6-10.8-13.8-19.4-11.6s-13.8 10.8-11.6 19.4l40 160c1.7 6.9 7.7 11.8 14.8 12.1s13.5-4 15.8-10.7L256 224.4 296.9 341.3c2.3 6.7 8.8 11 15.8 10.7s13.1-5.2 14.8-12.1l40-160c2.1-8.6-3.1-17.3-11.6-19.4s-17.3 3.1-19.4 11.6l-27 108.1-38.3-109.5c-2.2-6.4-8.3-10.7-15.1-10.7s-12.9 4.3-15.1 10.7l-38.3 109.5-27-108.1z"]],
    "chess": [512, 512, [], "f439", ["M64 466.7c0 7.3 5.9 13.2 13.2 13.3l229.5 0c6.4 0 11.7-4.6 13-10.6l.3-2.7c0-2.6-.8-5.2-2.2-7.3l-1.7-2-50.7-50.8-6.7-6.6-133.4 0-6.7 6.6-50.8 50.8c-2.5 2.5-3.9 5.9-3.9 9.4zM99.8 128l40 80 104.4 0 40-80-184.4 0zm30 240l124.5 0-12.8-128-98.9 0-12.8 128z", "M192-32c8.8 0 16 7.2 16 16l0 32 32 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-32 0 0 48 86.1 0c14.3 0 25.9 11.6 25.9 25.9 0 4-.9 8-2.7 11.6L280 208c8.8 0 16 7.2 16 16s-7.2 16-16 16l-6.4 0 14.4 144 50.7 50.7c8.5 8.5 13.3 20 13.3 32 0 25-20.3 45.2-45.3 45.3L77.2 512c-25 0-45.2-20.3-45.2-45.3 0-12 4.8-23.5 13.2-32L96 384 110.4 240 104 240c-8.8 0-16-7.2-16-16s7.2-16 16-16L66.7 133.5c-1.8-3.6-2.7-7.6-2.7-11.6 0-14.3 11.6-25.9 25.9-25.9l86.1 0 0-48-32 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l32 0 0-32c0-8.8 7.2-16 16-16zM472 160c22.1 0 40 17.9 40 40l0 64c0 7.6-2.1 15-6.2 21.3l-1.8 2.7-40 53.3 0 45.3 38.8 51.8 2.1 3.1c4.6 7.3 7.1 15.8 7.1 24.5 0 25.4-20.6 46-46 46l-77.8 0c5.4-9.7 9.1-20.5 10.8-32l67 0c7.7 0 14-6.3 14-14 0-2.3-.5-4.5-1.6-6.5l-1.2-1.9-42-56c-.4-.5-.7-1.1-1-1.6l-62.3 0-32-32 92.1 0 0-32c0-3.5 1.1-6.8 3.2-9.6l43.2-57.6 1.2-2.3c.3-.8 .4-1.7 .4-2.5l0-64c0-4.4-3.6-8-8-8l-36 0 0 32c0 11-9 20-20 20s-20-9-20-20l0-32-54.3 0 16-32 114.3 0zM118.6 406.6L67.9 457.4c-2.5 2.5-3.9 5.9-3.9 9.4 0 7.3 5.9 13.2 13.2 13.3l229.5 0c6.4 0 11.7-4.6 13-10.6l.3-2.7c0-2.6-.8-5.2-2.2-7.3l-1.7-2-50.7-50.8-6.7-6.6-133.4 0-6.7 6.6zM129.8 368l124.5 0-12.8-128-98.9 0-12.8 128zm10-160l104.4 0 40-80-184.4 0 40 80z"]],
    "temperature-three-quarters": [320, 512, ["temperature-3", "thermometer-3", "thermometer-three-quarters"], "f2c8", ["M48 368c0 61.9 50.1 112 112 112s112-50.1 112-112c0-28.4-10.6-54.3-28-74.1-2.6-2.9-4-6.7-4-10.6L240 112c0-44.2-35.8-80-80-80S80 67.8 80 112l0 171.3c0 3.9-1.4 7.7-4 10.6-17.4 19.8-28 45.7-28 74.1zm48 0c0-29.8 20.4-54.9 48-62l0-130c0-8.8 7.2-16 16-16s16 7.2 16 16l0 130c27.6 7.1 48 32.2 48 62 0 35.3-28.7 64-64 64s-64-28.7-64-64z", "M160 32c-44.2 0-80 35.8-80 80l0 171.3c0 3.9-1.4 7.7-4 10.6-17.4 19.8-28 45.7-28 74.1 0 61.9 50.1 112 112 112s112-50.1 112-112c0-28.4-10.6-54.3-28-74.1-2.6-2.9-4-6.7-4-10.6L240 112c0-44.2-35.8-80-80-80zM48 112C48 50.1 98.1 0 160 0S272 50.1 272 112l0 165.5c20 24.7 32 56.2 32 90.5 0 79.5-64.5 144-144 144S16 447.5 16 368c0-34.3 12-65.8 32-90.5L48 112zM160 400c17.7 0 32-14.3 32-32s-14.3-32-32-32-32 14.3-32 32 14.3 32 32 32zm0 32c-35.3 0-64-28.7-64-64 0-29.8 20.4-54.9 48-62l0-130c0-8.8 7.2-16 16-16s16 7.2 16 16l0 130c27.6 7.1 48 32.2 48 62 0 35.3-28.7 64-64 64z"]],
    "b": [320, 512, [98], "42", ["", "M16 32C7.2 32 0 39.2 0 48L0 464c0 8.8 7.2 16 16 16l176 0c70.7 0 128-57.3 128-128 0-52.8-32-98.2-77.7-117.7 27.7-20.4 45.7-53.2 45.7-90.3 0-61.9-50.1-112-112-112L16 32zM192 256c53 0 96 43 96 96s-43 96-96 96l-160 0 0-192 160 0zm-16-32l-144 0 0-160 144 0c44.2 0 80 35.8 80 80s-35.8 80-80 80z"]],
    "shield-virus": [512, 512, [], "e06c", ["M48 139.8c.5 94 39.3 259.8 195.4 334.5 7.9 3.8 17.2 3.8 25.1 0 156.1-74.7 195-240.4 195.5-334.5 .1-12.1-7.5-22.8-18.8-27.6l-176.7-75c-8-3.4-17-3.4-25 0l-176.7 75C55.5 117 48 127.7 48 139.8zM112 240c0-13.3 10.7-24 24-24 22.9 0 34.4-27.7 18.2-43.9-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0c16.2 16.2 43.9 4.7 43.9-18.2 0-13.3 10.7-24 24-24s24 10.7 24 24c0 22.9 27.7 34.4 43.9 18.2 9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9c-16.2 16.2-4.7 43.9 18.2 43.9 13.3 0 24 10.7 24 24s-10.7 24-24 24c-22.9 0-34.4 27.7-18.2 43.9 9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0c-16.2-16.2-43.9-4.7-43.9 18.2 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-22.9-27.7-34.4-43.9-18.2-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9c16.2-16.2 4.7-43.9-18.2-43.9-13.3 0-24-10.7-24-24z", "M243.6 37.3c8-3.4 17-3.4 25 0l176.7 75c11.3 4.8 18.9 15.5 18.8 27.6-.5 94-39.4 259.8-195.5 334.5-7.9 3.8-17.2 3.8-25.1 0-156.1-74.7-195-240.4-195.4-334.5-.1-12.1 7.5-22.8 18.8-27.6l176.7-75zM281.1 7.8c-16-6.8-34-6.8-50 0L54.3 82.8c-22 9.3-38.4 31-38.3 57.2 .5 99.2 41.3 280.7 213.6 363.2 16.7 8 36.1 8 52.8 0 172.4-82.5 213.2-264 213.6-363.2 .1-26.2-16.3-47.9-38.3-57.2L281.1 7.8zm38.9 296A90.3 90.3 0 1 1 192.2 176.1 90.3 90.3 0 1 1 319.9 303.9zm4-165.7c-16.2 16.2-43.9 4.7-43.9-18.2 0-13.3-10.7-24-24-24s-24 10.7-24 24c0 22.9-27.7 34.4-43.9 18.2-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9c16.2 16.2 4.7 43.9-18.2 43.9-13.3 0-24 10.7-24 24s10.7 24 24 24c22.9 0 34.4 27.7 18.2 43.9-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0c16.2-16.2 43.9-4.7 43.9 18.2 0 13.3 10.7 24 24 24s24-10.7 24-24c0-22.9 27.7-34.4 43.9-18.2 9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9c-16.2-16.2-4.7-43.9 18.2-43.9 13.3 0 24-10.7 24-24s-10.7-24-24-24c-22.9 0-34.4-27.7-18.2-43.9 9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0zM232 236a20 20 0 1 0 0-40 20 20 0 1 0 0 40zm68 28a20 20 0 1 0 -40 0 20 20 0 1 0 40 0z"]],
    "triangle": [512, 512, [9650], "f2ec", ["M33.5 436.2c-1.3 2.5-1.3 5.5 .2 7.9l1.3 1.6c1.5 1.4 3.5 2.3 5.6 2.3l432 0c2.8 0 5.4-1.5 6.8-3.9l.8-1.9c.4-1.3 .4-2.7 .1-4l-.7-1.9-216-400c-1.1-2-2.8-3.4-4.9-3.9l-2.1-.3c-2.4 0-4.7 1.1-6.2 2.9L249 37.1 33.5 436.2z", "M261.9 .4c12.5 1.7 23.6 9.3 29.8 20.6l216 400c6.7 12.4 6.4 27.4-.8 39.5l-3 4.3c-6.4 8.2-15.8 13.5-26.2 14.8l-5.2 .3-432 0-5.2-.3C25 478.3 15.6 473 9.1 464.8l-3-4.3c-6.3-10.6-7.4-23.4-3-34.7l2.2-4.8 216-400 2.9-4.6C231.7 6.2 243.6 0 256.5 0l5.4 .4zM256.5 32c-2.4 0-4.7 1.1-6.2 2.9L249 37.1 33.5 436.2c-1.3 2.5-1.3 5.5 .2 7.9l1.3 1.6c1.5 1.4 3.5 2.3 5.6 2.3l432 0c2.8 0 5.4-1.5 6.8-3.9l.8-1.9c.4-1.3 .4-2.7 .1-4l-.7-1.9-216-400c-1.1-2-2.8-3.4-4.9-3.9l-2.1-.3z"]],
    "litecoin-sign": [384, 512, [], "e1d3", ["", "M96 48c0-8.8-7.2-16-16-16S64 39.2 64 48l0 179.5-51.9 13C3.6 242.6-1.7 251.3 .5 259.9s10.8 13.8 19.4 11.6L64 260.5 64 440c0 22.1 17.9 40 40 40l264 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-264 0c-4.4 0-8-3.6-8-8l0-187.5 179.9-45c8.6-2.1 13.8-10.8 11.6-19.4s-10.8-13.8-19.4-11.6L96 219.5 96 48z"]],
    "dice-d6": [512, 512, [], "f6d1", ["M48.4 165.1l0 181.8c0 17.2 9.3 33.1 24.2 41.7l160 91.4c2.5 1.4 5.2 2.5 7.8 3.5l0-218.2-191.1-109.2c-.6 3-.9 6-.9 9.1zm17.1-36.6L256.5 237.6 447.4 128.5c-2.2-1.9-4.5-3.6-7.1-5L280.3 32c-14.8-8.4-32.9-8.4-47.7 0l-160 91.4c-2.6 1.5-4.9 3.2-7.1 5.1zM272.4 265.3l0 218.2c2.7-.9 5.3-2 7.8-3.5l160-91.4c11.9-6.8 20.3-18.4 23.1-31.5 0-67 0-133.9 .1-201L272.4 265.3z", "M216.8 4.3c24.6-14 54.8-14 79.3 0l160 91.4c23.4 13.3 38.3 37.5 40.1 64.1l.2 5.4 0 181.7c0 28.7-15.4 55.2-40.3 69.5l-160 91.4c-24.6 14-54.8 14-79.3 0l-160-91.4c-24.9-14.2-40.3-40.7-40.3-69.4l0-181.8c0-28.7 15.4-55.2 40.3-69.4l160-91.4zM49.4 156.1c-.6 3-.9 6-.9 9.1l0 181.8c0 17.2 9.3 33.1 24.2 41.7l160 91.4c2.5 1.4 5.2 2.5 7.8 3.5l0-218.2-191.1-109.2zM272.4 265.3l0 218.2c2.7-.9 5.3-2 7.8-3.5l160-91.4c15-8.5 24.2-24.5 24.2-41.7l0-181.7-.4-6.4c-.1-.9-.4-1.8-.5-2.7L272.4 265.3zM280.3 32c-14.8-8.4-32.9-8.4-47.7 0l-160 91.4c-2.6 1.5-4.9 3.2-7.1 5.1L256.5 237.6 447.4 128.5c-2.2-1.9-4.5-3.6-7.1-5L280.3 32z"]],
    "grip-lines-vertical": [192, 512, [], "f7a5", ["", "M16 32C7.2 32 0 39.2 0 48L0 464c0 8.8 7.2 16 16 16s16-7.2 16-16L32 48c0-8.8-7.2-16-16-16zm160 0c-8.8 0-16 7.2-16 16l0 416c0 8.8 7.2 16 16 16s16-7.2 16-16l0-416c0-8.8-7.2-16-16-16z"]],
    "toggle-large-off": [576, 512, [], "e5b0", ["M32 256a128 128 0 1 0 256 0 128 128 0 1 0 -256 0z", "M160 384a128 128 0 1 1 0-256 128 128 0 1 1 0 256zm0 32l256 0c88.4 0 160-71.6 160-160S504.4 96 416 96L160 96C71.6 96 0 167.6 0 256S71.6 416 160 416zm96-32c38.9-29.2 64-75.7 64-128s-25.1-98.8-64-128l160 0c70.7 0 128 57.3 128 128S486.7 384 416 384l-160 0z"]],
    "golf-ball-tee": [384, 512, ["golf-ball"], "f450", ["M32 192c0-88.4 71.6-160 160-160s160 71.6 160 160c0 43.6-17.5 83.1-45.8 112l-113.1 0c26-.6 46.9-21.9 46.9-48 0-8.8-7.2-16-16-16-7.7 0-14.2 5.5-15.7 12.8l-.6 6.4c-1.3 6.3-6.2 11.2-12.5 12.5l-6.4 .6c-7.3 1.5-12.8 8-12.8 15.7 0 8.6 6.8 15.6 15.4 16-37.9 0-75.7 0-113.6 0-28.3-28.9-45.8-68.4-45.8-112zm128 16c0 8.8 7.2 16 16 16 26.5 0 48-21.5 48-48 0-8.8-7.2-16-16-16-7.7 0-14.2 5.5-15.7 12.8l-.6 6.4c-1.3 6.3-6.2 11.2-12.5 12.5l-6.4 .6c-7.3 1.5-12.8 8-12.8 15.7zm80 16c0 8.8 7.2 16 16 16 26.5 0 48-21.5 48-48 0-8.8-7.2-16-16-16-7.7 0-14.2 5.5-15.7 12.8l-.6 6.4c-1.3 6.3-6.2 11.2-12.5 12.5l-6.4 .6c-7.3 1.5-12.8 8-12.8 15.7z", "M304 352c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0 0 112c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-112-96 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l224 0zM192 0c106 0 192 86 192 192 0 41.8-13.4 80.5-36.1 112l-41.7 0c28.3-28.9 45.8-68.4 45.8-112 0-88.4-71.6-160-160-160S32 103.6 32 192c0 43.6 17.5 83.1 45.8 112l-41.7 0C13.4 272.5 0 233.8 0 192 0 86 86 0 192 0zm32 240c8.8 0 16 7.2 16 16 0 26.5-21.5 48-48 48-8.8 0-16-7.2-16-16 0-7.7 5.5-14.2 12.8-15.7l6.4-.6c6.3-1.3 11.2-6.2 12.5-12.5l.6-6.4c1.5-7.3 8-12.8 15.7-12.8zm64-64c8.8 0 16 7.2 16 16 0 26.5-21.5 48-48 48-8.8 0-16-7.2-16-16 0-7.7 5.5-14.2 12.8-15.7l6.4-.6c6.3-1.3 11.2-6.2 12.5-12.5l.6-6.4c1.5-7.3 8-12.8 15.7-12.8zm-80-16c8.8 0 16 7.2 16 16 0 26.5-21.5 48-48 48-8.8 0-16-7.2-16-16 0-7.7 5.5-14.2 12.8-15.7l6.4-.6c6.3-1.3 11.2-6.2 12.5-12.5l.6-6.4c1.5-7.3 8-12.8 15.7-12.8z"]],
    "hexagon": [576, 512, [11043], "f312", ["M61.3 236.2L157.5 68.1C164.6 55.7 177.8 48 192.2 48l191.6 0c14.3 0 27.6 7.7 34.7 20.1l96.2 168.1c7 12.3 7 27.4 0 39.7L418.5 444c-7.1 12.4-20.4 20.1-34.7 20.1l-191.6 0c-14.3 0-27.6-7.7-34.7-20.1L61.3 275.9c-7-12.3-7-27.4 0-39.7z", "M61.3 236.2L157.5 68.1C164.6 55.7 177.8 48 192.2 48l191.6 0c14.3 0 27.6 7.7 34.7 20.1l96.2 168.1c7 12.3 7 27.4 0 39.7L418.5 444c-7.1 12.4-20.4 20.1-34.7 20.1l-191.6 0c-14.3 0-27.6-7.7-34.7-20.1L61.3 275.9c-7-12.3-7-27.4 0-39.7zM33.5 220.3c-12.7 22.2-12.7 49.4 0 71.5l96.2 168.1c12.8 22.4 36.7 36.2 62.5 36.2l191.6 0c25.8 0 49.7-13.8 62.5-36.2l96.2-168.1c12.7-22.2 12.7-49.4 0-71.5L446.3 52.2C433.5 29.8 409.6 16 383.8 16L192.2 16c-25.8 0-49.7 13.8-62.5 36.2L33.5 220.3z"]],
    "kite": [640, 512, [129665], "f6f4", ["M32 247.6l48 19.2 0 10.3-48 19.2 0-48.8zm80 19.2l48-19.2 0 48.8-48-19.2 0-10.3zm159.7 46.8L313.6 56.3 421.4 164 271.7 313.7zM466.6 164L576 54.6 576 273.4 466.6 164z", "M564.9 .2C589.1 2.7 608 23.1 608 48l0 228.8c0 23.5-17.1 43.6-40.3 47.4L255.6 374.9 136.3 494.3c-6.2 6.2-14.6 9.7-23.3 9.7-18.2 0-33-14.8-33-33l0-159.4-58.1 23.3c-4.9 2-10.5 1.4-14.9-1.6S0 325.3 0 320l0-96c0-5.3 2.6-10.3 7-13.2s10-3.6 14.9-1.6L80 232.4 80 192c0-17.7-14.3-32-32-32l-32 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l32 0c35.3 0 64 28.7 64 64l0 40.4 58.1-23.2 1.9-.6c4.4-1.2 9.2-.4 13 2.2 4.4 3 7 7.9 7 13.2l0 96c0 5.3-2.6 10.3-7 13.3s-10 3.6-14.9 1.6L112 311.6 112 471c0 .5 .4 1 1 1 .3 0 .5-.1 .7-.3L233 352.3 283.8 40.3C287.6 17.1 307.7 0 331.2 0L560 0 564.9 .2zM294.4 336.2L551.7 294.3 444 186.6 294.4 336.2zm-22.7-22.5L421.4 164 313.6 56.3 271.7 313.7zM32 296.4l48-19.2 0-10.3-48-19.2 0 48.8zm80-29.6l0 10.3 48 19.2 0-48.8-48 19.2zM466.6 164L576 273.4 576 54.6 466.6 164zM444 141.4L553.4 32 334.6 32 444 141.4z"]],
    "share-all": [576, 512, [], "f367", ["M32 304c0 43.8 15.5 76.7 33.7 100.1-1.1-6.3-1.7-13-1.7-20.1 0-70.7 57.3-128 128-128l48 0c8.8 0 16 7.2 16 16l0 97.3c186.7-188.4 186.7-134.1 0-322.6l0 97.3c0 8.8-7.2 16-16 16l-64 0C96.5 160 32 224.5 32 304z", "M416 208c-5.3-5.3-122.6-123.6-160-161.3l0 97.3c0 8.8-7.2 16-16 16l-64 0c-79.5 0-144 64.5-144 144 0 43.8 15.5 76.7 33.7 100.1-1.1-6.3-1.7-13-1.7-20.1 0-70.7 57.3-128 128-128l48 0c8.8 0 16 7.2 16 16l0 97.3c37.4-37.7 154.7-156 160-161.3zM251.3 8c7.1 0 14 2.7 19.3 8 23.1 23.3 162.3 163.7 168 169.4 12.5 12.5 12.5 32.8 0 45.3-5.7 5.7-145 146.1-168 169.4-5.3 5.3-12.2 8-19.3 8-15.1 0-27.3-12.2-27.3-27.3l0-92.7-32 0c-53 0-96 43-96 96 0 27.4 11.2 44.1 26.2 66.5l3.1 4.6c4 6 3.5 14-1.3 19.5s-12.7 7-19.2 3.7C87.2 469.5 0 417.5 0 304 0 206.8 78.8 128 176 128l48 0 0-92.7C224 20.2 236.2 8 251.3 8zM372.7 36.7c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0L566.6 185.4c12.5 12.5 12.5 32.8 0 45.3L395.3 401.9c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6L544 208 372.7 36.7z"]],
    "chemex": [384, 512, [], "e830", ["M65.5 160l26 35.8c2.8 3.8 4.9 8 6.4 12.2l66.4 0c5.5-9.6 15.8-16 27.7-16s22.2 6.4 27.7 16l66.4 0c1.5-4.3 3.6-8.4 6.4-12.2l26-35.8-253 0zm-.1 128l253.1 0-26.1-35.8c-2.8-3.8-4.9-7.9-6.4-12.2l-66.4 0c-5.5 9.6-15.8 16-27.7 16s-22.2-6.4-27.7-16l-66.4 0c-1.5 4.3-3.6 8.4-6.4 12.2L65.4 288z", "M351.5 .2c18.3 1.8 32.5 17.3 32.5 36 0 7.7-2.4 15.1-6.9 21.3l-51.3 70.5 24.1 0 2.2 .2c5.1 .7 9.6 3.9 12 8.6 2.7 5.4 2.2 11.8-1.3 16.7L323.2 208 336 208c8.8 0 16 7.2 16 16s-7.2 16-16 16l-12.8 0 39.7 54.6c3.5 4.9 4 11.3 1.3 16.7S356 320 350 320l-24.2 0 15.3 21.1c27.8 38.3 46.8 86.1 29.3 130l-2.7 6.4c-.9 2.1-1.9 4.2-2.9 6.3l-1.8 3.4c-9.7 16.3-28.5 24.7-47.8 24.7l-246.3 0-7.7-.4c-16.5-1.9-31.7-10.2-40.1-24.3l-1.8-3.4c-1-2.1-2-4.2-2.9-6.3l-2.7-6.4c-16.4-41.2-.8-85.8 24.1-122.8l5.1-7.3 15.3-21.1-24.2 0c-6 0-11.5-3.4-14.3-8.7s-2.2-11.8 1.3-16.7L60.8 240 48 240c-8.8 0-16-7.2-16-16s7.2-16 16-16l12.8 0-39.7-54.6c-3.5-4.9-4-11.3-1.3-16.7s8.2-8.8 14.2-8.8l24.1 0-51.2-70.5C2.4 51.3 0 43.9 0 36.2 0 16.2 16.2 0 36.2 0l311.6 0 3.7 .2zM68.7 359.9c-25.9 35.6-36.7 71.1-25.4 99.3 1.4 3.6 3 7.2 4.7 10.6 2.4 4.8 9.2 10.1 20.8 10.1l246.3 0c11.6 0 18.5-5.3 20.8-10.1 1.7-3.5 3.3-7 4.7-10.6 11.3-28.2 .5-63.8-25.4-99.3l-29-39.9-188.5 0-29 39.9zM97.9 240c-1.5 4.3-3.6 8.4-6.4 12.2l-26.1 35.8 253.1 0-26.1-35.8c-2.8-3.8-4.9-7.9-6.4-12.2l-66.4 0c-5.5 9.6-15.8 16-27.7 16s-22.2-6.4-27.7-16l-66.4 0zm-6.4-44.2c2.8 3.8 4.9 8 6.4 12.2l66.4 0c5.5-9.6 15.8-16 27.7-16s22.2 6.4 27.7 16l66.4 0c1.5-4.3 3.6-8.4 6.4-12.2l26-35.8-253 0 26 35.8zM36.2 32c-2.3 0-4.2 1.9-4.2 4.2 0 .9 .3 1.8 .8 2.5l64.9 89.3 188.5 0 64.9-89.3c.5-.7 .8-1.6 .8-2.5 0-2.3-1.9-4.2-4.2-4.2L36.2 32z"]],
    "folder-open": [576, 512, [128194, 128449, 61717], "f07c", ["M82.3 395.2C79 405.5 86.7 416 97.5 416L477 416c7 0 13.2-4.5 15.3-11.2l50-160c3.2-10.3-4.5-20.8-15.3-20.8l-379.4 0c-7 0-13.2 4.5-15.3 11.2l-50 160z", "M97.5 416c-10.8 0-18.5-10.5-15.3-20.8l50-160c2.1-6.7 8.3-11.2 15.3-11.2L527 224c10.8 0 18.5 10.5 15.3 20.8l-50 160C490.1 411.5 484 416 477 416L97.5 416zm126.7 32L477 448c21 0 39.6-13.6 45.8-33.7l50-160c9.7-30.9-13.4-62.3-45.8-62.3l-379.4 0c-21 0-39.6 13.6-45.8 33.7L64.2 345.6 64.2 96c0-17.7 14.3-32 32-32l138.7 0c6.9 0 13.7 2.2 19.2 6.4l38.4 28.8c11.1 8.3 24.6 12.8 38.4 12.8l117.3 0c17.7 0 32 14.3 32 32l32 0c0-35.3-28.7-64-64-64L330.9 80c-6.9 0-13.7-2.2-19.2-6.4L273.3 44.8C262.2 36.5 248.8 32 234.9 32L96.2 32c-35.3 0-64 28.7-64 64l0 288c0 35.3 28.7 64 64 64l128 0z"]],
    "tick": [192, 512, [], "e32f", ["M56 104c0-22.1 17.9-40 40-40s40 17.9 40 40l0 6.8c0 3.6-.4 7.3-1.3 10.8L104.3 249.5c-.9 3.8-4.3 6.5-8.3 6.5s-7.4-2.7-8.3-6.5L57.3 121.6c-.8-3.5-1.3-7.2-1.3-10.8l0-6.8z", "M56.6 256.9C60.9 275.1 77.2 288 96 288s35.1-12.9 39.4-31.1L165.9 129c1.4-6 2.1-12.1 2.1-18.2l0-6.8c0-39.8-32.2-72-72-72S24 64.2 24 104l0 6.8c0 6.1 .7 12.3 2.1 18.2L56.6 256.9zM56 104c0-22.1 17.9-40 40-40s40 17.9 40 40l0 6.8c0 3.6-.4 7.3-1.3 10.8L104.3 249.5c-.9 3.8-4.3 6.5-8.3 6.5s-7.4-2.7-8.3-6.5L57.3 121.6c-.8-3.5-1.3-7.2-1.3-10.8l0-6.8z"]],
    "face-drooling": [512, 512, [], "e372", ["M32 256C32 132.3 132.3 32 256 32S480 132.3 480 256c0 61-24.4 116.4-64 156.8l0 43.1c-14.8 11.8-30.8 22-48 30.4l0-132c3.4-3.3 6.6-6.8 9.7-10.4 5.7-6.7 5-16.8-1.8-22.6s-16.8-5-22.6 1.8C329.8 350.6 295 368 256 368s-73.8-17.4-97.3-44.9c-5.7-6.7-15.8-7.5-22.6-1.8s-7.5 15.8-1.8 22.6c29.3 34.3 73 56.1 121.7 56.1l0 64c0 8.8 7.2 16 16 16s16-7.2 16-16l0-67.2c17.2-3.5 33.3-9.7 48-18.2L336 496c0 1.1 .1 2.2 .3 3.1-55.8 18.4-103.9 13-128.3 8.4l0-32.7C107.4 452.9 32 363.2 32 256zm80-32c0 8.8 7.2 16 16 16s16-7.2 16-16c0-26.5 21.5-48 48-48 8.8 0 16-7.2 16-16s-7.2-16-16-16c-44.2 0-80 35.8-80 80zm192-64c0 8.8 7.2 16 16 16 26.5 0 48 21.5 48 48 0 8.8 7.2 16 16 16s16-7.2 16-16c0-44.2-35.8-80-80-80-8.8 0-16 7.2-16 16z", "M480 256c0 61-24.4 116.4-64 156.8l0 43.1c58.5-46.9 96-119 96-199.9 0-141.4-114.6-256-256-256S0 114.6 0 256C0 381 89.6 485 208 507.5l0-32.7C107.4 452.9 32 363.2 32 256 32 132.3 132.3 32 256 32S480 132.3 480 256zM353.3 323.1C329.8 350.6 295 368 256 368s-73.8-17.4-97.3-44.9c-5.7-6.7-15.8-7.5-22.6-1.8s-7.5 15.8-1.8 22.6c29.3 34.3 73 56.1 121.7 56.1l0 64c0 8.8 7.2 16 16 16s16-7.2 16-16l0-67.2c17.2-3.5 33.3-9.7 48-18.2L336 496c0 8.8 7.2 16 16 16s16-7.2 16-16l0-141.7c3.4-3.3 6.6-6.8 9.7-10.4 5.7-6.7 5-16.8-1.8-22.6s-16.8-5-22.6 1.8zM112 224c0 8.8 7.2 16 16 16s16-7.2 16-16c0-26.5 21.5-48 48-48 8.8 0 16-7.2 16-16s-7.2-16-16-16c-44.2 0-80 35.8-80 80zm208-80c-8.8 0-16 7.2-16 16s7.2 16 16 16c26.5 0 48 21.5 48 48 0 8.8 7.2 16 16 16s16-7.2 16-16c0-44.2-35.8-80-80-80z"]],
    "bullseye-arrow": [576, 512, [127919], "f648", ["", "M452.3 24.9l-42 42 6.3 37.8 48.3-48.3-12.6-31.5zm19.4 140.4l-60.4-10.1-112.1 112.1c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l112.1-112.1-10.1-60.4c-1.7-10.2 1.6-20.6 8.9-27.9l59.2-59.2C455-23 468.8-20.1 473-9.5L496 48 553.5 71c10.7 4.3 13.5 18 5.4 26.2l-59.2 59.2c-7.3 7.3-17.7 10.6-27.9 8.9zm15.8-86.2l-48.3 48.3 37.8 6.3 42-42-31.5-12.6zM288 0c23.3 0 45.8 3.1 67.2 8.9l-1.5 1.5c-7.7 7.7-13.7 16.9-17.7 26.7-15.5-3.4-31.5-5.2-48-5.2-123.7 0-224 100.3-224 224S164.3 480 288 480 512 379.7 512 256c0-16.5-1.8-32.6-5.2-48 9.9-4 19-9.9 26.7-17.7l1.5-1.5c5.8 21.4 8.9 43.9 8.9 67.2 0 141.4-114.6 256-256 256S32 397.4 32 256 146.6 0 288 0zm0 96c16.4 0 32.3 2.5 47.2 7.1l2.2 13.1-16.2 16.2c-10.6-2.8-21.7-4.3-33.2-4.3-70.7 0-128 57.3-128 128s57.3 128 128 128 128-57.3 128-128c0-11.5-1.5-22.6-4.3-33.2l16.2-16.2 13.1 2.2c4.6 14.9 7.1 30.8 7.1 47.2 0 88.4-71.6 160-160 160S128 344.4 128 256 199.7 96 288 96z"]],
    "kaaba": [512, 512, [128331], "f66b", ["M32 132.1l0 53.8 218.3 82.8c3.7 1.4 7.7 1.4 11.3 0l218.3-82.8 0-53.8-207 78.5c-11 4.2-23.1 4.2-34 0L32 132.1zm0 88l0 53.8 96 36.4 0 34.2-96-36.4 0 74.6c0 6.7 4.1 12.6 10.4 15l208 78c3.6 1.4 7.6 1.4 11.2 0l208-78c6.2-2.3 10.4-8.3 10.4-15l0-74.6-96 36.4 0-34.2 96-36.4 0-53.8-207 78.5c-11 4.2-23.1 4.2-34 0L32 220.1zM176 328.5l74.3 28.2c3.7 1.4 7.7 1.4 11.3 0l74.3-28.2 0 34.2-63 23.9c-11 4.2-23.1 4.2-34 0l-63-23.9 0-34.2z", "M32 132.1l0 53.8 218.3 82.8c3.7 1.4 7.7 1.4 11.3 0l218.3-82.8 0-53.8-207 78.5c-11 4.2-23.1 4.2-34 0L32 132.1zm421.1-24L261.6 36.3c-3.6-1.4-7.6-1.4-11.2 0L58.9 108.1 250.3 180.7c3.7 1.4 7.7 1.4 11.3 0l191.5-72.6zm26.9 112L273 298.7c-11 4.2-23.1 4.2-34 0l-207-78.5 0 53.8 96 36.4 0 34.2-96-36.4 0 74.6c0 6.7 4.1 12.6 10.4 15l208 78c3.6 1.4 7.6 1.4 11.2 0l208-78c6.2-2.3 10.4-8.3 10.4-15l0-74.6-96 36.4 0-34.2 96-36.4 0-53.8zM0 382.7L0 129.3c0-20 12.4-37.9 31.1-44.9l208-78c10.9-4.1 22.8-4.1 33.7 0l208 78c18.7 7 31.1 24.9 31.1 44.9l0 253.5c0 20-12.4 37.9-31.1 44.9l-208 78c-10.9 4.1-22.8 4.1-33.7 0l-208-78C12.4 420.7 0 402.7 0 382.7zm176-20l0-34.2 74.3 28.2c3.7 1.4 7.7 1.4 11.3 0l74.3-28.2 0 34.2-63 23.9c-11 4.2-23.1 4.2-34 0l-63-23.9z"]],
    "hand-back-point-right": [512, 512, [], "e1a1", ["M32 200.3L32 336c0 44.2 35.8 80 80 80l96 0c17.7 0 32-14.3 32-32 0-4.2-.8-8.2-2.2-11.8-1.7-4.2-1.5-9 .6-13.1s5.7-7.1 10.1-8.3c13.6-3.7 23.6-16.1 23.6-30.9 0-6.1-1.7-11.7-4.6-16.6-2.7-4.5-3.1-10-.9-14.8s6.5-8.2 11.6-9.2c14.8-2.8 25.9-15.8 25.9-31.4 0-11.1-5.7-20.9-14.3-26.7-5.9-3.9-8.5-11.2-6.5-18s8.3-11.4 15.3-11.4L456 192c13.3 0 24-10.7 24-24s-10.7-24-24-24l-288 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l48 0-9.6-12.8C197.3 87.1 183.1 80 168 80l-19.5 0c-41.2 0-79.1 22.6-98.6 58.9l-4.5 8.3C36.6 163.5 32 181.7 32 200.3z", "M512 168c0-30.9-25.1-56-56-56l-200.6 0c-2-3.2-4.2-6.4-6.5-9.5L232 80c-15.1-20.1-38.8-32-64-32l-19.5 0c-53 0-101.7 29.1-126.8 75.7L17.2 132C5.9 153 0 176.4 0 200.3L0 336c0 61.9 50.1 112 112 112l96 0c35.3 0 64-28.7 64-64 0-2.8-.2-5.6-.5-8.3 19.4-11 32.5-31.8 32.5-55.7 0-5.3-.7-10.5-1.9-15.5 20.2-10.8 33.9-32 33.9-56.5 0-8.5-1.7-16.6-4.7-24L456 224c30.9 0 56-25.1 56-56zm-56-24c13.3 0 24 10.7 24 24s-10.7 24-24 24l-157.5 0c-7.1 0-13.3 4.6-15.3 11.4s.6 14 6.5 18c8.7 5.8 14.3 15.6 14.3 26.7 0 15.6-11.2 28.6-25.9 31.4-5.1 1-9.5 4.4-11.6 9.2s-1.8 10.3 .9 14.8c2.9 4.8 4.6 10.5 4.6 16.6 0 14.7-10 27.2-23.6 30.9-4.4 1.2-8.1 4.2-10.1 8.3s-2.2 8.8-.6 13.1c1.4 3.6 2.2 7.6 2.2 11.8 0 17.7-14.3 32-32 32l-96 0c-44.2 0-80-35.8-80-80l0-135.7c0-18.5 4.6-36.8 13.4-53.1l0 0 4.5-8.3C69.4 102.6 107.3 80 148.5 80L168 80c15.1 0 29.3 7.1 38.4 19.2l9.6 12.8-48 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l288 0z"]],
    "starfighter-twin-ion-engine": [512, 512, ["starfighter-alt"], "e038", ["M32 236.9l0 38.1 67.5 14.5c-2.3-10.8-3.5-22-3.5-33.5s1.2-22.7 3.5-33.5L32 236.9zM128 256a128 128 0 1 0 256 0 128 128 0 1 0 -256 0zm208 0a80 80 0 1 1 -160 0 80 80 0 1 1 160 0zm76.5-33.5c2.3 10.8 3.5 22 3.5 33.5s-1.2 22.7-3.5 33.5l67.5-14.5 0-38.1-67.5-14.5z", "M32 48c0-8.8-7.2-16-16-16S0 39.2 0 48L0 464c0 8.8 7.2 16 16 16s16-7.2 16-16l0-156.2 79.5 17C137.3 378.7 192.3 416 256 416s118.7-37.3 144.5-91.2l79.5-17 0 156.2c0 8.8 7.2 16 16 16s16-7.2 16-16l0-416c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 156.2-79.5-17C374.7 133.3 319.7 96 256 96s-118.7 37.3-144.5 91.2L32 204.2 32 48zM412.5 222.5l67.5 14.5 0 38.1-67.5 14.5c2.3-10.8 3.5-22 3.5-33.5s-1.2-22.7-3.5-33.5zm-313 67.1l-67.5-14.5 0-38.1 67.5-14.5c-2.3 10.8-3.5 22-3.5 33.5s1.2 22.7 3.5 33.5zM256 128a128 128 0 1 1 0 256 128 128 0 1 1 0-256zm48 128a48 48 0 1 1 -96 0 48 48 0 1 1 96 0zm-48-80a80 80 0 1 0 0 160 80 80 0 1 0 0-160z"]],
    "hand-holding": [576, 512, [], "f4bd", ["M0 384c0 8.8 7.2 16 16 16l64 0c3.2 0 6.2-.9 8.9-2.7l79.9-53.3c7.9-5.3 17.1-8.1 26.6-8.1L344 336c13.3 0 24 10.7 24 24s-10.7 24-24 24l-88 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l148.6 0c2.9 0 5.7-.8 8.2-2.3L511.3 355c3.4-2 7.2-3 11.1-3l1.3 0c11.2 0 20.3 9.1 20.3 20.3 0 6.9-3.5 13.3-9.2 17L415.1 467.1c-13 8.4-28.1 12.9-43.6 12.9L16 480c-8.8 0-16 7.2-16 16L0 384z", "M195.4 304c-15.8 0-31.2 4.7-44.4 13.4L75.2 368 16 368c-8.8 0-16 7.2-16 16s7.2 16 16 16l64 0c3.2 0 6.2-.9 8.9-2.7l79.9-53.3c7.9-5.3 17.1-8.1 26.6-8.1L344 336c13.3 0 24 10.7 24 24s-10.7 24-24 24l-88 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l148.6 0c2.9 0 5.7-.8 8.2-2.3L511.3 355c3.4-2 7.2-3 11.1-3l1.3 0c11.2 0 20.3 9.1 20.3 20.3 0 6.9-3.5 13.3-9.2 17L415.1 467.1c-13 8.4-28.1 12.9-43.6 12.9L16 480c-8.8 0-16 7.2-16 16s7.2 16 16 16l355.5 0c21.7 0 42.9-6.3 61-18.1l119.6-77.8c14.8-9.6 23.8-26.1 23.8-43.8 0-28.9-23.4-52.3-52.3-52.3l-1.3 0c-9.7 0-19.1 2.6-27.5 7.6l-94.7 56.4-5.6 0c3.5-7.3 5.4-15.4 5.4-24 0-30.9-25.1-56-56-56l-148.6 0z"]],
    "badge-sheriff": [512, 512, [], "f8a2", ["M84.6 167.7l33.3 53.2c13.4 21.5 13.4 48.8 0 70.3L84.6 344.3c2 2.3 3.9 4.9 5.5 7.7 1.7 3 3.1 6 4.1 9.1l65 0c23.9 0 46 12.9 57.8 33.8l30.3 53.9c2.9-.6 6-.9 9.1-.9s6.1 .3 9.1 .9l30.3-53.9c11.7-20.9 33.8-33.8 57.8-33.8l65 0c1-3.1 2.4-6.2 4.1-9.1 1.6-2.8 3.4-5.3 5.5-7.7l-33.3-53.2c-13.4-21.5-13.4-48.8 0-70.3l33.3-53.2c-2-2.3-3.9-4.9-5.5-7.7-1.7-3-3.1-6-4.1-9.1l-65 0c-23.9 0-46-12.9-57.8-33.8L265.4 63.1c-2.9 .6-6 .9-9.1 .9s-6.1-.3-9.1-.9l-30.3 53.9c-11.7 20.9-33.8 33.8-57.8 33.8l-65 0c-1 3.1-2.4 6.2-4.1 9.1-1.6 2.8-3.4 5.3-5.5 7.7zm108.1 81.7c.2-2.1 .5-4.2 1-6.3 .9-4.2 2.1-8.2 3.7-12 3.2-7.6 7.9-14.5 13.7-20.3 11.6-11.6 27.6-18.7 45.3-18.7 35.3 0 64 28.7 64 64s-28.7 64-64 64c-17.7 0-33.7-7.2-45.3-18.7-5.8-5.8-10.5-12.7-13.7-20.3-1.6-3.8-2.9-7.8-3.7-12-.4-2.1-.8-4.3-1-6.5-.1-1.1-.2-2.1-.2-3.2 0-1.1-.1-2.1-.1-3.4 0-2.4 .1-4.4 .3-6.5z", "M256.4 32a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm0 32c-3.1 0-6.1-.3-9.1-.9l-30.3 53.9c-11.7 20.9-33.8 33.8-57.8 33.8l-65 0c-1 3.1-2.4 6.2-4.1 9.1-1.6 2.8-3.4 5.3-5.5 7.7l33.3 53.2c13.4 21.5 13.4 48.8 0 70.3L84.6 344.3c2 2.3 3.9 4.9 5.5 7.7 1.7 3 3.1 6 4.1 9.1l65 0c23.9 0 46 12.9 57.8 33.8l30.3 53.9c2.9-.6 6-.9 9.1-.9s6.1 .3 9.1 .9l30.3-53.9c11.7-20.9 33.8-33.8 57.8-33.8l65 0c1-3.1 2.4-6.2 4.1-9.1 1.6-2.8 3.4-5.3 5.5-7.7l-33.3-53.2c-13.4-21.5-13.4-48.8 0-70.3l33.3-53.2c-2-2.3-3.9-4.9-5.5-7.7-1.7-3-3.1-6-4.1-9.1l-65 0c-23.9 0-46-12.9-57.8-33.8L265.4 63.1c-2.9 .6-6 .9-9.1 .9zm-163 54.9l65.8 0c12.4 0 23.8-6.7 29.9-17.5l30.6-54.4c-7.1-8.4-11.3-19.2-11.3-30.9 0-26.5 21.5-48 48-48s48 21.5 48 48c0 11.8-4.3 22.6-11.3 30.9l30.6 54.4c6.1 10.8 17.5 17.5 29.9 17.5l65.8 0c3.8-9.9 10.9-18.7 20.8-24.4 23-13.3 52.3-5.4 65.6 17.6s5.4 52.3-17.6 65.6c-10.1 5.8-21.5 7.6-32.1 5.7L422 237.8c-7 11.1-7 25.2 0 36.3l34.1 54.5c10.7-1.8 22-.1 32.1 5.7 23 13.3 30.8 42.6 17.6 65.6s-42.6 30.8-65.6 17.6c-9.9-5.7-17-14.5-20.8-24.4l-65.8 0c-12.4 0-23.8 6.7-29.9 17.5l-30.6 54.4c7.1 8.4 11.3 19.2 11.3 30.9 0 26.5-21.5 48-48 48s-48-21.5-48-48c0-11.8 4.3-22.6 11.3-30.9L189 410.6c-6.1-10.8-17.5-17.5-29.9-17.5l-65.8 0c-3.8 9.9-10.9 18.7-20.8 24.4-23 13.3-52.3 5.4-65.6-17.6s-5.4-52.3 17.6-65.6c10.1-5.8 21.5-7.6 32.1-5.7l34.1-54.5c6.9-11.1 6.9-25.2 0-36.3L56.6 183.3c-10.7 1.8-22 .1-32.1-5.7-23-13.3-30.8-42.6-17.6-65.6S49.6 81.2 72.5 94.4c9.9 5.7 17 14.5 20.8 24.4zM288.4 256a32.4 32.4 0 1 0 -64.7 0 32.4 32.4 0 1 0 64.7 0zm-96.7 0a64.4 64.4 0 1 1 128.7 0 64.4 64.4 0 1 1 -128.7 0zM472.2 149.9a16 16 0 1 0 -16-27.7 16 16 0 1 0 16 27.7zM450.4 368a16 16 0 1 0 27.7 16 16 16 0 1 0 -27.7-16zm-178 128a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM34.7 384a16 16 0 1 0 27.7-16 16 16 0 1 0 -27.7 16zm5.9-234.1a16 16 0 1 0 16-27.7 16 16 0 1 0 -16 27.7z"]],
    "rainbow-half": [512, 512, [], "e7ca", ["M16 480c8.8 0 16-7.2 16-16 0-238.6 193.4-432 432-432 8.8 0 16-7.2 16-16l0 144c0-8.8-7.2-16-16-16-176.7 0-320 143.3-320 320 0 8.8 7.2 16 16 16L16 480zm144 0c8.8 0 16-7.2 16-16 0-159.1 128.9-288 288-288 8.8 0 16-7.2 16-16l0 144c0-8.8-7.2-16-16-16-97.2 0-176 78.8-176 176 0 8.8 7.2 16 16 16l-144 0z", "M464 32c-238.6 0-432 193.4-432 432 0 8.8-7.2 16-16 16S0 472.8 0 464C0 207.7 207.7 0 464 0 472.8 0 480 7.2 480 16s-7.2 16-16 16zm0 144c-159.1 0-288 128.9-288 288 0 8.8-7.2 16-16 16s-16-7.2-16-16c0-176.7 143.3-320 320-320 8.8 0 16 7.2 16 16s-7.2 16-16 16zM320 464c0 8.8-7.2 16-16 16s-16-7.2-16-16c0-97.2 78.8-176 176-176 8.8 0 16 7.2 16 16s-7.2 16-16 16c-79.5 0-144 64.5-144 144z"]],
    "comment-lines": [512, 512, [], "f4b0", ["M32 240c0 46.7 16.5 89.8 44.8 124.8 8.1 10.1 9.4 24.1 3.2 35.4l-40.2 73.6 101-43.3c7.9-3.4 16.8-3.5 24.8-.2 27.6 11.3 58.2 17.6 90.4 17.6 125.7 0 224-95 224-208S381.7 32 256 32 32 127 32 240zm96-32c0-8.8 7.2-16 16-16l224 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-224 0c-8.8 0-16-7.2-16-16zm0 96c0-8.8 7.2-16 16-16l128 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-128 0c-8.8 0-16-7.2-16-16z", "M80 400.2c6.2-11.4 4.9-25.4-3.2-35.4-28.2-34.9-44.8-78.1-44.8-124.8 0-113 98.3-208 224-208s224 95 224 208-98.3 208-224 208c-32.3 0-62.8-6.3-90.4-17.6-7.9-3.3-16.9-3.2-24.8 .2L39.8 473.8 80 400.2zM0 240c0 54.4 19.3 104.6 51.9 144.9L3.1 474.3c-2 3.7-3.1 7.9-3.1 12.2 0 14.1 11.4 25.5 25.5 25.5 4 0 7.8-.6 11.5-2.1L153.4 460c31.4 12.9 66.1 20 102.6 20 141.4 0 256-107.5 256-240S397.4 0 256 0 0 107.5 0 240zm144-48c-8.8 0-16 7.2-16 16s7.2 16 16 16l224 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-224 0zm0 96c-8.8 0-16 7.2-16 16s7.2 16 16 16l128 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-128 0z"]],
    "single-quote-right": [192, 512, [], "e81c", ["M32 160l0 64c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-64 0c-17.7 0-32 14.3-32 32z", "M48 416c-8.8 0-16-7.2-16-16s7.2-16 16-16l32 0c44.2 0 80-35.8 80-80l0-24.6c-7.6 4.4-16.3 7.3-25.5 8.3l-6.5 .3-64 0-6.5-.3C25.2 284.4 0 257.1 0 224l0-64 .3-6.5c3.1-30.1 27-54.1 57.1-57.1l6.5-.3 64 0 6.5 .3c30.1 3.1 54.1 27 57.1 57.1l.3 6.5 0 144c0 61.9-50.1 112-112 112l-32 0zm80-160c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-64 0c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32l64 0z"]],
    "bottle-droplet": [320, 512, [], "e4c4", ["M32 288l0 160c0 35.3 28.7 64 64 64l128 0c35.3 0 64-28.7 64-64l0-160c0-50.2-28.9-93.7-71.1-114.7-5.4-2.7-8.9-8.3-8.9-14.3l0-159-96 0 0 159c0 6.1-3.4 11.6-8.9 14.3-42.2 21-71.1 64.5-71.1 114.7zm48 70.2c0-38.8 43.7-91.9 66.5-117 7.3-8.1 19.7-8.1 27 0 22.8 25.1 66.5 78.2 66.5 117 0 52.5-35.8 78.7-80 78.7s-80-35.3-80-78.7z", "M64-16C64-7.2 71.2 0 80 0l0 149.4C32.2 177.1 0 228.8 0 288L0 448c0 53 43 96 96 96l128 0c53 0 96-43 96-96l0-160c0-59.2-32.2-110.9-80-138.6L240 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L80-32c-8.8 0-16 7.2-16 16zM112 0l96 0 0 159c0 6.1 3.4 11.6 8.9 14.3 42.2 21 71.1 64.5 71.1 114.7l0 160c0 35.3-28.7 64-64 64L96 512c-35.3 0-64-28.7-64-64l0-160c0-50.2 28.9-93.7 71.1-114.7 5.4-2.7 8.9-8.3 8.9-14.3L112 0zm96 358.2c0 18.5-6 29.1-12.9 35.4-7.4 6.7-19.1 11.4-35.1 11.4-27 0-48-21.4-48-46.7 0-9.5 6.2-25.7 19.5-46.2 8.9-13.7 19.3-26.9 28.5-37.7 9.2 10.8 19.6 23.9 28.5 37.7 13.3 20.6 19.5 36.8 19.5 46.2zm32 0c0-38.8-43.7-91.9-66.5-117-7.3-8.1-19.7-8.1-27 0-22.8 25.1-66.5 78.2-66.5 117 0 43.5 35.8 78.7 80 78.7s80-26.2 80-78.7z"]],
    "face-explode": [512, 512, ["exploding-head"], "e2fe", ["M32.1 263.1L43.8 267c13.1 4.4 27.3 4.4 40.5 0L160 241.7 235.8 267c13.1 4.4 27.3 4.4 40.5 0L352 241.7 427.8 267c13.1 4.4 27.3 4.4 40.5 0l11.6-3.9C476.1 383.5 377.3 480 256 480S35.9 383.5 32.1 263.1zM152 336a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm40 80l0 16c0 8.8 7.2 16 16 16l96 0c8.8 0 16-7.2 16-16l0-16c0-35.3-28.7-64-64-64s-64 28.7-64 64zm120-80a24 24 0 1 0 48 0 24 24 0 1 0 -48 0z", "M208-32c14.3 0 27.2 6.3 36 16.3 3 3.4 7.4 5.4 12 5.4s9-2 12-5.4c8.8-10 21.7-16.3 36-16.3 22.3 0 41.2 15.3 46.5 36 1.8 7.1 8.2 12 15.5 12l10 0c22.1 0 40 17.9 40 40s-17.9 40-40 40l-24 0c-35.3 0-64 28.7-64 64l0 20 32-10.7 0-9.4c0-17.7 14.3-32 32-32l24 0c39.8 0 72-32.2 72-72 0-39.3-31.5-71.3-70.7-72-12.3-28.3-40.5-48-73.3-48-18 0-34.6 6-48 16-13.4-10-30-16-48-16-32.8 0-61 19.8-73.3 48-39.1 .7-70.7 32.7-70.7 72 0 39.8 32.2 72 72 72l24 0c17.7 0 32 14.3 32 32l0 9.4 32 10.7 0-20c0-35.3-28.7-64-64-64l-24 0c-22.1 0-40-17.9-40-40s17.9-40 40-40l10 0c7.3 0 13.7-4.9 15.5-12 5.3-20.7 24.1-36 46.5-36zM33.5 229.8L2.6 219.5c-1.5 10.8-2.4 21.7-2.6 32.9 0 1.2 0 2.4 0 3.6 0 141.4 114.6 256 256 256S512 397.4 512 256c0-1.2 0-2.4 0-3.6-.2-11.1-1-22.1-2.6-32.9-22.4 7.5-39.5 13.2-51.3 17.1-6.6 2.2-13.7 2.2-20.2 0l-75.8-25.3c-6.6-2.2-13.7-2.2-20.2 0l-75.8 25.3c-6.6 2.2-13.7 2.2-20.2 0l-75.8-25.3c-6.6-2.2-13.7-2.2-20.2 0L74.1 236.6c-6.6 2.2-13.7 2.2-20.2 0l-20.4-6.8zm-1.4 33.3L43.8 267c13.1 4.4 27.3 4.4 40.5 0L160 241.7 235.8 267c13.1 4.4 27.3 4.4 40.5 0L352 241.7 427.8 267c13.1 4.4 27.3 4.4 40.5 0l11.6-3.9C476.1 383.5 377.3 480 256 480S35.9 383.5 32.1 263.1zM200 336a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm136 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM192 416l0 16c0 8.8 7.2 16 16 16l96 0c8.8 0 16-7.2 16-16l0-16c0-35.3-28.7-64-64-64s-64 28.7-64 64zm64-32c17.7 0 32 14.3 32 32l-64 0c0-17.7 14.3-32 32-32z"]],
    "window-minimize": [512, 512, [128469], "f2d1", ["", "M0 432c0-8.8 7.2-16 16-16l480 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L16 448c-8.8 0-16-7.2-16-16z"]],
    "stadium": [576, 512, [], "e6cc", ["M32 216c0 8.3 4.3 18 16.1 28.6 10.4 9.4 25.7 18.6 45.4 26.8 16.8-13.3 41.5-23.6 69.4-30.9 11.3-3 23.5-5.5 36.3-7.6L137.2 146c-12.9 3.4-24.8 7.2-35.8 11.4-23.5 9-41.5 19.3-53.3 30S32 207.7 32 216zm0 56.9L32 408c0 8.3 4.3 18 16.1 28.6s29.7 21 53.3 30c29.1 11.1 65.6 19.8 106.6 24.7l0-43.3c0-44.2 35.8-80 80-80s80 35.8 80 80l0 43.3c41-5 77.5-13.6 106.6-24.7 23.5-9 41.5-19.3 53.3-30S544 416.3 544 408l0-135.1c-15.2 12.3-35.1 22.8-58 31.6-51.5 19.7-121.5 31.5-198 31.5S141.4 324.2 90 304.5c-22.9-8.7-42.8-19.3-58-31.6zm100.9 11.9C176 296.8 229.6 304 288 304s112-7.2 155.1-19.1c-10.2-4.8-23-9.4-38.2-13.4-32.2-8.4-72.7-13.5-117-13.5s-84.8 5.1-117 13.5c-15.2 4-27.9 8.6-38.2 13.4zm38.2-146.5l64.3 90c16.9-1.5 34.5-2.4 52.7-2.4s35.8 .8 52.7 2.4l64.3-90c-35-6.6-74.7-10.3-116.9-10.3s-81.9 3.8-116.9 10.3zm205.7 94.5c12.8 2.1 25 4.7 36.3 7.6 28 7.3 52.7 17.6 69.4 30.9 19.7-8.2 35-17.4 45.4-26.8 11.8-10.7 16.1-20.3 16.1-28.6s-4.3-18-16.1-28.6-29.7-21-53.3-30c-10.9-4.2-22.9-8-35.8-11.4l-62.1 86.9z", "M263.6-45.6c4.7-2.9 10.6-3.2 15.6-.7l96 48C380.6 4.4 384 9.9 384 16s-3.4 11.6-8.8 14.3L288 73.9 288 96c59.1 0 114.2 7 160 19.3L448 0c0-5.5 2.9-10.7 7.6-13.6s10.6-3.2 15.6-.7l96 48c5.4 2.7 8.8 8.3 8.8 14.3s-3.4 11.6-8.8 14.3l-87.2 43.6 0 19.4c2 .7 4.1 1.5 6 2.2 25.7 9.8 47.6 21.9 63.3 36.1S576 195.5 576 216l0 192c0 20.5-10.9 38.1-26.6 52.4s-37.6 26.3-63.3 36.1C434.6 516.2 364.6 528 288 528S141.4 516.2 90 496.5c-25.7-9.8-47.6-21.9-63.3-36.1S0 428.5 0 408L0 216c0-20.5 10.9-38.1 26.6-52.4 10.1-9.1 22.8-17.4 37.4-24.8L64 0c0-5.5 2.9-10.7 7.6-13.6s10.6-3.2 15.6-.7l96 48c5.4 2.7 8.8 8.3 8.8 14.3s-3.4 11.6-8.8 14.3L96 105.9 96 125.3c43.4-15.6 98.9-25.9 160-28.6L256-32c0-5.5 2.9-10.7 7.6-13.6zM480 70.1L524.2 48 480 25.9 480 70.1zm-192-32L332.2 16 288-6.1 288 38.1zM96 57.4L96 70.1 140.2 48 96 25.9 96 57.4zm308.9 81c-35-6.6-74.7-10.3-116.9-10.3s-81.9 3.8-116.9 10.3l64.3 90c16.9-1.5 34.5-2.4 52.7-2.4s35.8 .8 52.7 2.4l64.3-90zm33.9 7.6l-62.1 86.9c12.8 2.1 25 4.7 36.3 7.6 28 7.3 52.7 17.6 69.4 30.9 19.7-8.2 35-17.4 45.4-26.8 11.8-10.7 16.1-20.3 16.1-28.6s-4.3-18-16.1-28.6-29.7-21-53.3-30c-10.9-4.2-22.9-8-35.8-11.4zM101.4 157.4c-23.5 9-41.5 19.3-53.3 30S32 207.7 32 216l0 0c0 8.3 4.3 18 16.1 28.6 10.4 9.4 25.7 18.6 45.4 26.8 16.8-13.3 41.5-23.6 69.4-30.9 11.3-3 23.5-5.5 36.3-7.6L137.2 146c-12.9 3.4-24.8 7.2-35.8 11.4zM486 304.5C434.6 324.2 364.6 336 288 336S141.4 324.2 90 304.5c-22.9-8.7-42.8-19.3-58-31.6L32 408c0 8.3 4.3 18 16.1 28.6s29.7 21 53.3 30c29.1 11.1 65.6 19.8 106.6 24.7l0-43.3c0-44.2 35.8-80 80-80s80 35.8 80 80l0 43.3c41-5 77.5-13.6 106.6-24.7 23.5-9 41.5-19.3 53.3-30S544 416.3 544 408l0-135.1c-15.2 12.3-35.1 22.8-58 31.6zM240 494.3c15.5 1.1 31.6 1.7 48 1.7s32.5-.6 48-1.7l0-46.3c0-26.5-21.5-48-48-48s-48 21.5-48 48l0 46.3zM288 304c58.4 0 112-7.2 155.1-19.1-10.2-4.8-23-9.4-38.2-13.4-32.2-8.4-72.7-13.5-117-13.5s-84.8 5.1-117 13.5c-15.2 4-27.9 8.6-38.2 13.4 43.1 11.9 96.7 19.1 155.1 19.1z"]],
    "megaphone": [512, 512, [128227], "f675", ["M32 224.2l0 63.5 448 126 0-315.5-448 126z", "M496 32c-8.8 0-16 7.2-16 16l0 17-448 126 0-15c0-8.8-7.2-16-16-16S0 167.2 0 176L0 336c0 8.8 7.2 16 16 16s16-7.2 16-16l0-15 102.3 28.8c-4.1 10.6-6.3 22.2-6.3 34.2 0 53 43 96 96 96 47 0 86.2-33.8 94.4-78.5L480 447 480 464c0 8.8 7.2 16 16 16s16-7.2 16-16l0-416c0-8.8-7.2-16-16-16zM480 413.8l-448-126 0-63.5 448-126 0 315.5zM287.4 392.8c-4.3 31.2-31 55.2-63.4 55.2-35.3 0-64-28.7-64-64 0-9.1 1.9-17.7 5.3-25.5l122.1 34.3z"]],
    "burger-glass": [576, 512, [], "e0ce", ["M76.9 192L98.7 450.7c1.4 16.6 15.3 29.3 31.9 29.3l77.4 0 0-141.5c0-16.5 2.3-38.2 14.3-59.1 15-26.1 46.3-65.5 102.5-87.4L76.9 192z", "M64.1 40.7L74.2 160 373.7 160 383.8 40.7c.4-4.7-3.3-8.7-8-8.7L72.1 32c-4.7 0-8.4 4-8 8.7zM76.9 192L98.7 450.7c1.4 16.6 15.3 29.3 31.9 29.3l77.8 0c-.3 2.2-.4 4.4-.4 6.7 0 8.7 1.1 17.2 3.1 25.3l-80.5 0c-33.3 0-61-25.5-63.8-58.6L32.2 43.4C30.3 20 48.7 0 72.1 0L375.8 0c23.4 0 41.8 20 39.9 43.4L404.5 176c-30.9 1.2-57.3 7.2-79.7 16L76.9 192zM288 338.8l0 29.3-32 0 0-29.3c0-6.3 .5-12.6 1.8-18.7 1.2-5.8 3.2-11.3 6.2-16.5 61.3-106.9 242.8-107 304.1 0 3 5.2 4.9 10.7 6.1 16.5 1.3 6.1 1.8 12.4 1.8 18.7l0 29.3-32 0 0-29.3c0-9.5-1.5-15.4-3.7-19.3-23.6-41.1-72-64.1-124.3-64.1s-100.7 23-124.3 64.1c-2.2 3.8-3.7 9.8-3.7 19.3zM544 486.5l0-22.4 32 0 0 22.4c0 9.2-2.2 17.9-6 25.6-9.4 18.7-28.7 31.5-51.1 31.5l-205.7 0c-22.3 0-41.7-12.8-51.1-31.5-3.9-7.7-6-16.4-6-25.6l0-22.4 32 0 0 22.4c0 13.9 11.3 25.1 25.1 25.1l205.7 0c13.9 0 25.1-11.3 25.1-25.1zM272 400l288 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-288 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zM400 288a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm-48 16a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm112 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"]],
    "pen-paintbrush": [576, 512, ["pencil-paintbrush"], "f618", ["M67.5 476.5l114.1-31.7c9.3-2.6 17.8-7.5 24.6-14.4L419 217.7 326.3 125 113.6 337.8c-6.8 6.8-11.8 15.3-14.4 24.6L67.5 476.5z", "M436 32c-10.7 0-20.9 4.2-28.5 11.8l-58.5 58.5 92.7 92.7 58.5-58.5c7.6-7.6 11.8-17.8 11.8-28.5s-4.2-20.9-11.8-28.5L464.5 43.8C456.9 36.2 446.7 32 436 32zM113.6 337.8c-6.8 6.8-11.8 15.3-14.4 24.6L67.5 476.5 181.6 444.8c9.3-2.6 17.8-7.5 24.6-14.4L419 217.7 326.3 125 113.6 337.8zM384.9 21.2C398.4 7.6 416.8 0 436 0s37.6 7.6 51.1 21.2l35.7 35.7C536.4 70.4 544 88.8 544 108s-7.6 37.6-21.2 51.1l-294 294c-10.7 10.7-24.1 18.5-38.7 22.6L62.4 511.1c-8.3 2.3-17.3 0-23.4-6.2s-8.5-15.1-6.2-23.4L68.4 353.8c4.1-14.6 11.8-27.9 22.6-38.7l294-294zM121.8 216.4L19.6 114.2C7 101.7 0 84.7 0 66.9 0 30 30 0 66.9 0 84.7 0 101.7 7 114.2 19.6L216.4 121.8 193.8 144.4 91.6 42.2C85.1 35.7 76.2 32 66.9 32 47.6 32 32 47.6 32 66.9 32 76.2 35.7 85.1 42.2 91.6l102.2 102.2-22.6 22.6zM284.9 465l22.8-22.8c17.5 23 45.2 37.8 76.4 37.8l96.4 0c-.7-1.3-1.4-2.6-2.1-3.8-8.3-16.7-11.7-38.9-4.2-59 3.8-10.3 5.9-21.4 5.9-33.1 0-31.1-14.8-58.8-37.8-76.4L465 284.9c28.7 23.5 47 59.2 47 99.1 0 15.5-2.8 30.4-7.8 44.2-7.6 20.8 5.8 51.8 28 51.8l27.9 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-176 0c-40 0-75.7-18.3-99.1-47z"]],
    "lightbulb-slash": [576, 512, [], "f673", ["M156 101.5c28.8-42 77.2-69.5 132-69.5 88.4 0 160 71.6 160 160 0 42.7-16.7 81.4-43.9 110.1-7.3 7.7-14.7 16.4-21.6 25.9L211 156.5c8.2-25.8 32.4-44.5 61-44.5 8.8 0 16-7.2 16-16s-7.2-16-16-16c-37.2 0-69.4 21.2-85.4 52.1L156 101.5z", "M27.3-27.2c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l544 544c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L405.5 351c6.4-9.5 13.9-18.5 21.8-26.8 32.7-34.4 52.7-80.9 52.7-132.1 0-106-86-192-192-192-63.6 0-120 30.9-154.9 78.6L27.3-27.2zM156 101.5c28.8-42 77.2-69.5 132-69.5 88.4 0 160 71.6 160 160 0 42.7-16.7 81.4-43.9 110.1-7.3 7.7-14.7 16.4-21.6 25.9L211 156.5c8.2-25.8 32.4-44.5 61-44.5 8.8 0 16-7.2 16-16s-7.2-16-16-16c-37.2 0-69.4 21.2-85.4 52.1L156 101.5zM96 192c0 51.2 20 97.7 52.7 132.1 23.6 24.9 43.3 55.3 43.3 89.6l0 18.3c0 44.2 35.8 80 80 80l32 0c40.8 0 74.5-30.6 79.4-70.1l-57.9-57.9-105.1 0c-8.1-33.3-28.6-61-48.5-81.9-27.2-28.7-43.9-67.4-43.9-110.1 0-1.8 0-3.6 .1-5.4l-29-29c-2 11.2-3.1 22.7-3.1 34.4zM224 432l0-16 128 0 0 16c0 26.5-21.5 48-48 48l-32 0c-26.5 0-48-21.5-48-48z"]],
    "circle-australian-dollar": [512, 512, [], "e730", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm80.7 83.3l51-164.3c2.8-8.9 11-15 20.3-15s17.6 6.1 20.3 15l51 164.3c2.6 8.4-2.1 17.4-10.5 20s-17.4-2.1-20-10.5l-8.9-28.7-63.6 0-8.9 28.7c-2.6 8.4-11.6 13.2-20 10.5s-13.2-11.6-10.5-20zM162.1 288l43.8 0-21.9-70.5-21.9 70.5zM264 215c0-28 20.9-51.1 48-54.5l0-16.4c0-8.8 7.2-16 16-16s16 7.2 16 16l0 16 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-41 0c-12.7 0-23 10.3-23 23 0 11.2 8.1 20.8 19.2 22.7l30.9 5.1c26.5 4.4 45.9 27.4 45.9 54.2 0 28-20.9 51.1-48 54.5l0 16.4c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-16-24 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l49 0c12.7 0 23-10.3 23-23 0-11.2-8.1-20.8-19.2-22.7l-30.9-5.1C283.4 264.8 264 241.9 264 215z", "M256 32a224 224 0 1 1 0 448 224 224 0 1 1 0-448zm0 480a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm72-384c-8.8 0-16 7.2-16 16l0 16.4c-27.1 3.4-48 26.5-48 54.5 0 26.9 19.4 49.8 45.9 54.2l30.9 5.1c11.1 1.8 19.2 11.4 19.2 22.7 0 12.7-10.3 23-23 23l-49 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l24 0 0 16c0 8.8 7.2 16 16 16s16-7.2 16-16l0-16.4c27.1-3.4 48-26.5 48-54.5 0-26.9-19.4-49.8-45.9-54.2l-30.9-5.1c-11.1-1.8-19.2-11.4-19.2-22.7 0-12.7 10.3-23 23-23l41 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0 0-16c0-8.8-7.2-16-16-16zM224.7 348.7c2.6 8.4 11.6 13.2 20 10.5s13.2-11.6 10.5-20L204.3 175c-2.8-8.9-11-15-20.3-15s-17.6 6.1-20.3 15l-51 164.3c-2.6 8.4 2.1 17.4 10.5 20s17.4-2.1 20-10.5l8.9-28.7 63.6 0 8.9 28.7zM184 217.5l21.9 70.5-43.8 0 21.9-70.5z"]],
    "shuttle-space-vertical": [448, 512, [], "e7bf", ["M32 448l0 48c0 8.8 7.2 16 16 16l48 0 0-64-64 0zm2.4-32l63.2 0c3.8-18.9 14.3-35.3 28.9-46.8 .7-.6 1.2-1.2 1.4-1.5 .1-.2 .1-.3 .1-.3l0-134.4-68.6 114.4c-12.7 21.2-21.2 44.5-25 68.7zM128 432l0 80 80 0 0-112c0-8.8 7.2-16 16-16s16 7.2 16 16l0 112 80 0 0-80c0-15.3-7.1-28.9-18.3-37.7-7.3-5.8-13.7-15.2-13.7-27L288 144c0-54.9-22.9-104.4-64-139.5-41.1 35.1-64 84.6-64 139.5l0 223.3c0 11.8-6.4 21.2-13.7 27-11.2 8.8-18.3 22.4-18.3 37.7zm64-320c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16zM320 232.9l0 134.4c0 0 0 .2 .1 .3 .2 .4 .7 1 1.4 1.5 14.5 11.5 25 27.9 28.9 46.8l63.2 0c-3.8-24.2-12.3-47.6-25-68.7L320 232.9zM352 448l0 64 48 0c8.8 0 16-7.2 16-16l0-48-64 0z", "M416.1 330.8L320 170.7 320 144c0-64.7-27.4-123.5-76.3-164.8-11.4-9.6-28-9.6-39.4 0-48.9 41.3-76.3 100.1-76.3 164.8l0 26.7-96.1 160.1C11 365.6 0 405.4 0 446l0 50c0 26.5 21.5 48 48 48l352 0c26.5 0 48-21.5 48-48l0-50c0-40.6-11-80.4-31.9-115.2zM208 512l-80 0 0-80c0-15.3 7.1-28.9 18.3-37.7 7.3-5.8 13.7-15.2 13.7-27L160 144c0-54.9 22.9-104.4 64-139.5 41.1 35.1 64 84.6 64 139.5l0 223.3c0 11.8 6.4 21.2 13.7 27 11.2 8.8 18.3 22.4 18.3 37.7l0 80-80 0 0-112c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 112zM321.5 369.2c-.7-.6-1.2-1.2-1.4-1.5-.1-.2-.1-.3-.1-.3l0-134.4 68.6 114.4c12.7 21.2 21.2 44.5 25 68.7l-63.2 0c-3.8-18.9-14.3-35.3-28.9-46.8zM352 512l0-64 64 0 0 48c0 8.8-7.2 16-16 16l-48 0zM126.5 369.2c-14.5 11.5-25 27.9-28.9 46.8l-63.2 0c3.8-24.2 12.3-47.6 25-68.7l68.6-114.4 0 134.4c0 0 0 .2-.1 .3-.2 .4-.7 1-1.4 1.5zM96 448l0 64-48 0c-8.8 0-16-7.2-16-16l0-48 64 0zm96-336c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16z"]],
    "person-to-door": [576, 512, [58704], "e433", ["M163 278.4l40.9-134.4 12.6 0c18.1 0 34.7 10.2 42.9 26.4l-48.9 147.5-31.6-9.6c-12.7-3.9-19.8-17.3-16-29.9zM280 24a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zM416.2 45.7C417.3 37.9 424 32 432 32l96 0c8.8 0 16 7.2 16 16l0 416c0 8.8-7.2 16-16 16l-96 0c-7.9 0-14.5-5.8-15.8-13.2 0-.5 0-1.1 0-1.7 0-54.4 0-108.8-.1-163.2 27.6-7.2 47.9-32.2 47.9-62s-20.3-54.8-47.9-62c.1-43.9 .1-87.8 .1-131.7 0-.2 0-.4 0-.6z", "M256 0a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm0 80a56 56 0 1 0 0-112 56 56 0 1 0 0 112zM100.3 158.5c3.8-8.8 12.5-14.5 22.1-14.5l48 0-38.1 125.1c-9 29.6 7.7 60.9 37.3 69.9L298 378 241.4 505.5c-3.6 8.1 0 17.5 8.1 21.1s17.5 0 21.1-8.1L327.3 391c7.8-17.6-1.5-38-19.9-43.6l-66.2-20.2 38.5-116.3 9.2 18.5c8.1 16.3 24.8 26.5 42.9 26.5l68.2 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-68.2 0c-6.1 0-11.6-3.4-14.3-8.8L288 156.2c-13.6-27.1-41.3-44.2-71.6-44.2l-94.1 0c-22.4 0-42.6 13.4-51.5 33.9L33.3 233.7c-3.5 8.1 .3 17.5 8.4 21s17.5-.3 21-8.4l37.6-87.8zM163 278.4l40.9-134.4 12.6 0c18.1 0 34.7 10.2 42.9 26.4l-48.9 147.5-31.6-9.6c-12.7-3.9-19.8-17.3-16-29.9zM110.3 395.7c-2.6 7.4-7 14-12.8 19.3L5.2 499.3c-6.5 6-7 16.1-1 22.6s16.1 7 22.6 1l92.3-84.4c9.6-8.8 16.9-19.8 21.3-32.1l8.5-23.8c-10.4-4-19.9-9.5-28.2-16.1l-10.4 29.2zM384 48l0 128 16 0c5.5 0 10.9 .7 16 2l0-130c0-8.8 7.2-16 16-16l96 0c8.8 0 16 7.2 16 16l0 416c0 8.8-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16l0-162c-5.1 1.3-10.5 2-16 2l-16 0 0 160c0 26.5 21.5 48 48 48l96 0c26.5 0 48-21.5 48-48l0-416c0-26.5-21.5-48-48-48L432 0c-26.5 0-48 21.5-48 48z"]],
    "face-viewfinder": [512, 512, [], "e2ff", ["M128 256a128 128 0 1 0 256 0 128 128 0 1 0 -256 0zm104-32a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm-45.3 80c-4.4-7.7-1.8-17.4 5.8-21.9s17.4-1.8 21.9 5.8c8.3 14.4 23.8 24 41.6 24s33.3-9.6 41.6-24c4.4-7.6 14.2-10.3 21.9-5.8s10.3 14.2 5.8 21.9c-13.8 23.9-39.7 40-69.3 40s-55.5-16.1-69.3-40zM328 224a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M64 0C28.7 0 0 28.7 0 64l0 80c0 8.8 7.2 16 16 16s16-7.2 16-16l0-80c0-17.7 14.3-32 32-32l80 0c8.8 0 16-7.2 16-16S152.8 0 144 0L64 0zM448 0L368 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l80 0c17.7 0 32 14.3 32 32l0 80c0 8.8 7.2 16 16 16s16-7.2 16-16l0-80c0-35.3-28.7-64-64-64zM0 448c0 35.3 28.7 64 64 64l80 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-80 0c-17.7 0-32-14.3-32-32l0-80c0-8.8-7.2-16-16-16S0 359.2 0 368l0 80zm448 64c35.3 0 64-28.7 64-64l0-80c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 80c0 17.7-14.3 32-32 32l-80 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l80 0zM232 224a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm72 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM256 128a128 128 0 1 1 0 256 128 128 0 1 1 0-256zm0 288a160 160 0 1 0 0-320 160 160 0 1 0 0 320zM214.4 288c-4.4-7.6-14.2-10.3-21.9-5.8s-10.3 14.2-5.8 21.9c13.8 23.9 39.7 40 69.3 40s55.5-16.1 69.3-40c4.4-7.7 1.8-17.4-5.8-21.9s-17.4-1.8-21.9 5.8c-8.3 14.4-23.8 24-41.6 24s-33.3-9.6-41.6-24z"]],
    "rectangle-video-on-demand": [576, 512, [], "e774", ["M32 128l0 256c0 17.7 14.3 32 32 32l448 0c17.7 0 32-14.3 32-32l0-256c0-17.7-14.3-32-32-32L64 96c-17.7 0-32 14.3-32 32zm32 48c0-8.8 7.2-16 16-16s16 7.2 16 16l0 68.9c0 23.3 9.3 45.7 25.8 62.2l6.2 6.2 6.2-6.2c16.5-16.5 25.8-38.9 25.8-62.2l0-68.9c0-8.8 7.2-16 16-16s16 7.2 16 16l0 68.9c0 31.8-12.6 62.3-35.1 84.9l-17.5 17.5c-6.2 6.2-16.4 6.2-22.6 0L99.1 329.8C76.6 307.3 64 276.7 64 244.9L64 176zm160 40c0-30.9 25.1-56 56-56l16 0c30.9 0 56 25.1 56 56l0 80c0 30.9-25.1 56-56 56l-16 0c-30.9 0-56-25.1-56-56l0-80zm32 0l0 80c0 13.3 10.7 24 24 24l16 0c13.3 0 24-10.7 24-24l0-80c0-13.3-10.7-24-24-24l-16 0c-13.3 0-24 10.7-24 24zm128-40c0-8.8 7.2-16 16-16l48 0c35.3 0 64 28.7 64 64l0 64c0 35.3-28.7 64-64 64l-48 0c-8.8 0-16-7.2-16-16l0-160zm32 16l0 128 32 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-32 0z", "M64 96c-17.7 0-32 14.3-32 32l0 256c0 17.7 14.3 32 32 32l448 0c17.7 0 32-14.3 32-32l0-256c0-17.7-14.3-32-32-32L64 96zM0 128C0 92.7 28.7 64 64 64l448 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64L64 448c-35.3 0-64-28.7-64-64L0 128zm96 48l0 68.9c0 23.3 9.3 45.7 25.8 62.2l6.2 6.2 6.2-6.2c16.5-16.5 25.8-38.9 25.8-62.2l0-68.9c0-8.8 7.2-16 16-16s16 7.2 16 16l0 68.9c0 31.8-12.6 62.3-35.1 84.9l-17.5 17.5c-6.2 6.2-16.4 6.2-22.6 0L99.1 329.8C76.6 307.3 64 276.7 64 244.9L64 176c0-8.8 7.2-16 16-16s16 7.2 16 16zm184 16c-13.3 0-24 10.7-24 24l0 80c0 13.3 10.7 24 24 24l16 0c13.3 0 24-10.7 24-24l0-80c0-13.3-10.7-24-24-24l-16 0zm-56 24c0-30.9 25.1-56 56-56l16 0c30.9 0 56 25.1 56 56l0 80c0 30.9-25.1 56-56 56l-16 0c-30.9 0-56-25.1-56-56l0-80zm176-56l48 0c35.3 0 64 28.7 64 64l0 64c0 35.3-28.7 64-64 64l-48 0c-8.8 0-16-7.2-16-16l0-160c0-8.8 7.2-16 16-16zm16 160l32 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-32 0 0 128z"]],
    "tennis-ball": [512, 512, [127934], "f45e", ["M32 255.4l0 .6c0 123.7 100.3 224 224 224l.6 0c-4.5-58.4 15.6-118.4 60.3-163.1S421.6 252.1 480 256.6l0-.6C480 132.3 379.7 32 256 32l-.6 0c4.5 58.4-15.6 118.4-60.3 163.1S90.4 259.9 32 255.4zm2.3-31.9c49.5 3.8 100.3-13.2 138.1-51s54.8-88.6 51-138.1C125.8 48.6 48.6 125.8 34.3 223.5zM288.5 477.7c97.7-14.2 174.9-91.4 189.1-189.1-49.5-3.8-100.3 13.2-138.1 51s-54.8 88.6-51 138.1z", "M256.6 480c-4.5-58.4 15.6-118.4 60.3-163.1S421.6 252.1 480 256.6l0-.6C480 132.3 379.7 32 256 32l-.6 0c4.5 58.4-15.6 118.4-60.3 163.1S90.4 259.9 32 255.4l0 .6c0 123.7 100.3 224 224 224l.6 0zm31.9-2.3c97.7-14.2 174.9-91.4 189.1-189.1-49.5-3.8-100.3 13.2-138.1 51s-54.8 88.6-51 138.1zM223.5 34.3c-97.7 14.2-174.9 91.5-189.1 189.1 49.5 3.8 100.3-13.2 138.1-51s54.8-88.6 51-138.1zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0z"]],
    "chevron-right": [320, 512, [9002], "f054", ["", "M315.3 244.7c6.2 6.2 6.2 16.4 0 22.6l-208 208c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6L281.4 256 84.7 59.3c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l208 208z"]],
    "egg": [384, 512, [129370], "f7fb", ["M32 288c0 91.7 74.8 176 160 176s160-84.3 160-176c0-50.8-14.7-113.1-43.5-161.7-28.7-48.4-67.9-78.3-116.5-78.3S104.2 77.9 75.5 126.3C46.7 174.9 32 237.2 32 288zm48 0c0-28.3 5.7-61.9 16.9-93.5 11.2-31.5 28.4-62.4 52.3-84.2 6.5-6 16.7-5.5 22.6 1s5.5 16.6-1 22.6c-18.8 17.1-33.6 42.7-43.7 71.2-10.1 28.4-15.1 58.3-15.1 82.8 0 8.8-7.2 16-16 16s-16-7.2-16-16z", "M192 464C106.8 464 32 379.7 32 288 32 237.2 46.7 174.9 75.5 126.3 104.2 77.9 143.4 48 192 48s87.8 29.9 116.5 78.3c28.8 48.6 43.5 110.8 43.5 161.7 0 91.7-74.8 176-160 176zM0 288C0 394 86 496 192 496S384 394 384 288c0-112-64-272-192-272S0 176 0 288zM170.8 134c6.5-6 7-16.1 1-22.6s-16.1-7-22.6-1c-23.9 21.8-41.1 52.7-52.3 84.2-11.2 31.6-16.9 65.1-16.9 93.5 0 8.8 7.2 16 16 16s16-7.2 16-16c0-24.5 5-54.4 15.1-82.8 10.1-28.5 25-54.1 43.7-71.2z"]],
    "conveyor-belt-arm": [640, 512, [], "e5f8", ["M32 416c0 35.3 28.7 64 64 64l448 0c35.3 0 64-28.7 64-64s-28.7-64-64-64L96 352c-35.3 0-64 28.7-64 64zm120 0a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm192 0a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm192 0a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M112 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l96 0 0 112c0 4.2 1.7 8.3 4.7 11.3s7.1 4.7 11.3 4.7l240 0 0 32c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48c0-4.2-1.7-8.3-4.7-11.3S484.2 128 480 128l-240 0 0-96 96 0c8.8 0 16-7.2 16-16S344.8 0 336 0L112 0zM448 288l64 0 0 32-64 0 0-32zm-32-8l0 40-32 0 0-40c0-13.3-10.7-24-24-24l-80 0c-13.3 0-24 10.7-24 24l0 40-32 0 0-40c0-13.3-10.7-24-24-24l-80 0c-13.3 0-24 10.7-24 24l0 40c-53 0-96 43-96 96s43 96 96 96l448 0c53 0 96-43 96-96s-43-96-96-96l0-40c0-13.3-10.7-24-24-24l-80 0c-13.3 0-24 10.7-24 24zM120 352l424 0c35.3 0 64 28.7 64 64s-28.7 64-64 64L96 480c-35.3 0-64-28.7-64-64s28.7-64 64-64l24 0zm72-64l0 32-64 0 0-32 64 0zm96 32l0-32 64 0 0 32-64 0zM128 440a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm216-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm168 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]],
    "landmark-dome": [512, 512, ["landmark-alt"], "f752", ["M96 224c0-88.4 71.6-160 160-160s160 71.6 160 160L96 224zm0 32l80 0 0 144-80 0 0-144zm112 0l96 0 0 144-96 0 0-144zm128 0l80 0 0 144-80 0 0-144z", "M256 0c8.8 0 16 7.2 16 16l0 16.7c98.6 8.1 176 90.7 176 191.3l16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0 0 144 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L48 432c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0 0-144-16 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0C64 123.3 141.4 40.8 240 32.7L240 16c0-8.8 7.2-16 16-16zM96 224l320 0c0-88.4-71.6-160-160-160S96 135.6 96 224zm0 32l0 144 80 0 0-144-80 0zm112 0l0 144 96 0 0-144-96 0zm128 0l0 144 80 0 0-144-80 0zM0 496c0-8.8 7.2-16 16-16l480 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L16 512c-8.8 0-16-7.2-16-16z"]],
    "grate": [448, 512, [], "e193", ["M32 96l0 144 64 0 0-176-32 0C46.3 64 32 78.3 32 96zm0 176l0 144c0 17.7 14.3 32 32 32l32 0 0-176-64 0zM128 64l0 176 80 0 0-176-80 0zm0 208l0 176 80 0 0-176-80 0zM240 64l0 176 80 0 0-176-80 0zm0 208l0 176 80 0 0-176-80 0zM352 64l0 176 64 0 0-144c0-17.7-14.3-32-32-32l-32 0zm0 208l0 176 32 0c17.7 0 32-14.3 32-32l0-144-64 0z", "M112 32l272 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l48 0zM32 272l0 144c0 17.7 14.3 32 32 32l32 0 0-176-64 0zm96 176l80 0 0-176-80 0 0 176zm112 0l80 0 0-176-80 0 0 176zm112 0l32 0c17.7 0 32-14.3 32-32l0-144-64 0 0 176zm64-208l0-144c0-17.7-14.3-32-32-32l-32 0 0 176 64 0zM320 64l-80 0 0 176 80 0 0-176zM208 64l-80 0 0 176 80 0 0-176zM96 64L64 64C46.3 64 32 78.3 32 96l0 144 64 0 0-176z"]],
    "worm": [512, 512, [], "e599", ["M32 312l0 144c0 13.3 10.7 24 24 24s24-10.7 24-24l0-144c0-39.8 32.2-72 72-72 44.2 0 80 35.8 80 80l0 36c0 68.5 55.5 124 124 124s124-55.5 124-124l0-266.4C480 57.8 454.2 32 422.4 32l-40.1 0c-34.4 0-62.3 27.9-62.3 62.3 0 31 22.8 57.2 53.4 61.6 21.3 3 40.8 5.8 58.6 8.4L432 356c0 42-34 76-76 76s-76-34-76-76l0-36c0-70.7-57.3-128-128-128-66.3 0-120 53.7-120 120zM432 88a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M432 192l0-27.8c-17.7-2.5-37.2-5.3-58.6-8.4-30.7-4.4-53.4-30.6-53.4-61.6 0-34.4 27.9-62.3 62.3-62.3l40.1 0C454.2 32 480 57.8 480 89.6L480 356c0 68.5-55.5 124-124 124S232 424.5 232 356l0-36c0-44.2-35.8-80-80-80-39.8 0-72 32.2-72 72l0 144c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-144c0-66.3 53.7-120 120-120 70.7 0 128 57.3 128 128l0 36c0 42 34 76 76 76s76-34 76-76l0-164zM382.3 0c-52.1 0-94.3 42.2-94.3 94.3 0 46.9 34.5 86.7 80.9 93.3l31.1 4.4 0 164c0 24.3-19.7 44-44 44s-44-19.7-44-44l0-36c0-88.4-71.6-160-160-160-83.9 0-152 68.1-152 152L0 456c0 30.9 25.1 56 56 56s56-25.1 56-56l0-144c0-22.1 17.9-40 40-40 26.5 0 48 21.5 48 48l0 36c0 86.2 69.8 156 156 156s156-69.8 156-156l0-266.4C512 40.1 471.9 0 422.4 0L382.3 0zM408 112a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]],
    "sack": [512, 512, [], "f81c", ["M48 416.8c0 34.9 28.3 63.2 63.2 63.2l289.6 0c34.9 0 63.2-28.3 63.2-63.2 0-110.6-69-177.9-155-256.8l-106 0C117 239 48 306.3 48 416.8zM160 37.9c0 1 .3 2 .8 2.9l49.8 87.1 90.9 0 49.8-87.1c.5-.9 .8-1.9 .8-2.9 0-3.3-2.7-5.9-5.9-5.9L165.9 32c-3.3 0-5.9 2.7-5.9 5.9z", "M332.5 138.1L379 56.7c3.3-5.7 5-12.2 5-18.8 0-20.9-17-37.9-37.9-37.9L165.9 0c-20.9 0-37.9 17-37.9 37.9 0 6.6 1.7 13.1 5 18.8l46.5 81.4C95.3 215.4 16 291.6 16 416.8 16 469.4 58.6 512 111.2 512l289.6 0c52.6 0 95.2-42.6 95.2-95.2 0-125.2-79.3-201.4-163.5-278.7zM309 160c86 79 155 146.3 155 256.8 0 34.9-28.3 63.2-63.2 63.2l-289.6 0C76.3 480 48 451.7 48 416.8 48 306.3 117 239 203 160l106 0zm-7.6-32l-90.9 0-49.8-87.1c-.5-.9-.8-1.9-.8-2.9 0-3.3 2.7-5.9 5.9-5.9l180.1 0c3.3 0 5.9 2.7 5.9 5.9 0 1-.3 2-.8 2.9L301.4 128z"]],
    "user-injured": [448, 512, [], "f728", ["M128 128l192 0c0 53-43 96-96 96s-96-43-96-96zm19.6 226.8c9.2-1.8 18.7-2.8 28.4-2.8l96 0c79.5 0 144 64.5 144 144 0 8.8 7.2 16 16 16l-176 0c35.3 0 64-28.7 64-64s-28.7-64-64-64l-93 0-15.5-29.2zM180 416l76 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-42.1 0-33.9-64z", "M224 224c53 0 96-43 96-96l-192 0c0 53 43 96 96 96zm0-192c-41.8 0-77.4 26.7-90.5 64l65.5 0 37.9-63.2c-4.2-.6-8.5-.8-12.8-.8zm44.2 10.8L236.3 96 314.5 96c-8.2-23.1-24.9-42.1-46.3-53.2zM352 128a128 128 0 1 1 -256 0 128 128 0 1 1 256 0zM32.9 480l144.8 0-61-115.2C71.4 385.3 38.6 428.6 32.9 480zM16 512c-8.8 0-16-7.2-16-16 0-97.2 78.8-176 176-176l96 0c97.2 0 176 78.8 176 176 0 8.8-7.2 16-16 16s-16-7.2-16-16c0-79.5-64.5-144-144-144l-96 0c-9.7 0-19.2 1-28.4 2.8l15.5 29.2 93 0c35.3 0 64 28.7 64 64s-28.7 64-64 64L16 512zm164-96l33.9 64 42.1 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-76 0z"]],
    "midi": [512, 512, [], "e806", ["M32 256c0 123.7 100.3 224 224 224S480 379.7 480 256c0-89.3-52.3-166.4-128-202.4l0 58.4-.2 4.9c-2.3 22.6-20.3 40.6-42.8 42.8l-4.9 .3-96 0c-24.9 0-45.3-18.9-47.8-43.1l-.2-4.9 0-58.4C84.3 89.6 32 166.7 32 256zm96 0a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm37.5 124.4a24 24 0 1 1 -33.9-33.9 24 24 0 1 1 33.9 33.9zM280 408a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm100.4-27.6a24 24 0 1 1 -33.9-33.9 24 24 0 1 1 33.9 33.9zM432 256a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M320 52.3c0-20.1 19.3-36.5 39.6-30.2l4.1 1.6 8.1 3.9C455 69.9 512 156.3 512 256 512 397.4 397.4 512 256 512S0 397.4 0 256C0 153.1 60.8 64.4 148.3 23.7l4.1-1.6c20.3-6.3 39.6 10 39.6 30.2l0 59.7 .3 3.2c1.5 7.3 8 12.8 15.7 12.8l96 0 3.2-.3c7.3-1.5 12.8-7.9 12.8-15.7l0-59.7zM352 112l-.2 4.9c-2.3 22.6-20.3 40.6-42.8 42.8l-4.9 .3-96 0c-24.9 0-45.3-18.9-47.8-43.1l-.2-4.9 0-58.4C84.3 89.6 32 166.7 32 256 32 379.7 132.3 480 256 480S480 379.7 480 256c0-89.3-52.3-166.4-128-202.4l0 58.4zM256 432a24 24 0 1 1 0-48 24 24 0 1 1 0 48zm-90.5-51.6a24 24 0 1 1 -33.9-33.9 24 24 0 1 1 33.9 33.9zm214.9 0a24 24 0 1 1 -33.9-33.9 24 24 0 1 1 33.9 33.9zM104 280a24 24 0 1 1 0-48 24 24 0 1 1 0 48zm304 0a24 24 0 1 1 0-48 24 24 0 1 1 0 48z"]],
    "moon-star": [512, 512, [], "e7c9", ["M32 256c0-123.7 100.3-224 224-224 9.5 0 18.9 .6 28 1.7-60.1 38.3-100 105.6-100 182.3 0 117.2 96.4 212.8 210.7 215.9-38.2 30.1-86.3 48.1-138.7 48.1-123.7 0-224-100.3-224-224z", "M32 256c0 123.7 100.3 224 224 224 52.4 0 100.6-18 138.7-48.1-114.3-3.2-210.7-98.7-210.7-215.9 0-76.6 39.9-143.9 100-182.3-9.2-1.1-18.5-1.7-28-1.7-123.7 0-224 100.3-224 224zM0 256c0-141.4 114.6-256 256-256 19.4 0 38.4 2.2 56.7 6.3 9.9 2.2 17.3 10.5 18.5 20.5s-4 19.8-13.1 24.4c-60.6 30.2-102.1 92.7-102.1 164.8 0 106.1 93.4 191.8 198.8 183.4 10.1-.8 19.6 4.8 23.8 14.1s2 20.1-5.3 27.1C387.3 484.8 324.8 512 256 512 114.6 512 0 397.4 0 256zM416 128l0 64 64 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-64 0 0 64c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-64-64 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l64 0 0-64c0-8.8 7.2-16 16-16s16 7.2 16 16z"]],
    "strikethrough": [512, 512, [], "f0cc", ["", "M96 147.6C96 83.8 147.8 32 211.6 32L384 32c8.8 0 16 7.2 16 16s-7.2 16-16 16L211.6 64c-46.2 0-83.6 37.4-83.6 83.6 0 40.9 29.6 75.8 69.9 82.5l121.5 20.3c7.4 1.2 14.5 3.1 21.3 5.7L496 256c8.8 0 16 7.2 16 16s-7.2 16-16 16L16 288c-8.8 0-16-7.2-16-16s7.2-16 16-16l155.3 0C126.8 239.5 96 196.7 96 147.6zM379 336l33.4 0c2.3 9.1 3.5 18.6 3.5 28.4 0 63.8-51.8 115.6-115.6 115.6L128 480c-8.8 0-16-7.2-16-16s7.2-16 16-16l172.4 0c46.2 0 83.6-37.4 83.6-83.6 0-9.9-1.7-19.5-5-28.4z"]],
    "calendar-circle-minus": [576, 512, [], "e46f", ["M64 192l416 0 0 22c-15.3-3.9-31.4-6-48-6-106 0-192 86-192 192 0 16.6 2.1 32.7 6 48L96 448c-17.7 0-32-14.3-32-32l0-224z", "M160 16c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 48-32 0c-35.3 0-64 28.7-64 64l0 288c0 35.3 28.7 64 64 64l161.4 0c-4.7-10.2-8.5-20.9-11.4-32L96 448c-17.7 0-32-14.3-32-32l0-224 416 0 0-64c0-35.3-28.7-64-64-64l-32 0 0-48c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 48-192 0 0-48zM96 96l320 0c17.7 0 32 14.3 32 32l0 32-384 0 0-32c0-17.7 14.3-32 32-32zM432 288a112 112 0 1 1 0 224 112 112 0 1 1 0-224zm0 256a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm80-144c0-8.8-7.2-16-16-16l-128 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l128 0c8.8 0 16-7.2 16-16z"]],
    "blog": [512, 512, [], "f781", ["", "M224 16c0-8.8 7.2-16 16-16 150.2 0 272 121.8 272 272 0 8.8-7.2 16-16 16s-16-7.2-16-16c0-132.5-107.5-240-240-240-8.8 0-16-7.2-16-16zM48 96c8.8 0 16 7.2 16 16l0 256c0 61.9 50.1 112 112 112s112-50.1 112-112-50.1-112-112-112l-32 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l32 0c79.5 0 144 64.5 144 144S255.5 512 176 512 32 447.5 32 368l0-256c0-8.8 7.2-16 16-16zm192 0c97.2 0 176 78.8 176 176 0 8.8-7.2 16-16 16s-16-7.2-16-16c0-79.5-64.5-144-144-144-8.8 0-16-7.2-16-16s7.2-16 16-16z"]],
    "stopwatch-20": [448, 512, [], "e06f", ["M48 288a176 176 0 1 0 352 0 176 176 0 1 0 -352 0zm64-48c0-26.5 21.5-48 48-48s48 21.5 48 48l0 3.8c0 10.9-3 21.6-8.8 30.9L151.7 352 192 352c8.8 0 16 7.2 16 16s-7.2 16-16 16l-57.8 0c-12.3 0-22.2-10-22.2-22.2 0-4.1 1.1-8.2 3.3-11.7L172 258c2.6-4.3 4-9.2 4-14.1l0-3.8c0-8.8-7.2-16-16-16s-16 7.2-16 16-7.2 16-16 16-16-7.2-16-16zm128 0c0-26.5 21.5-48 48-48s48 21.5 48 48l0 96c0 26.5-21.5 48-48 48s-48-21.5-48-48l0-96zm32 0l0 96c0 8.8 7.2 16 16 16s16-7.2 16-16l0-96c0-8.8-7.2-16-16-16s-16 7.2-16 16z", "M160 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l48 0 0 48c0 .2 0 .4 0 .6-107.4 8.2-192 97.9-192 207.4 0 114.9 93.1 208 208 208s208-93.1 208-208c0-43.5-13.3-83.8-36.2-117.2l31.5-31.5c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-29 29c-34.5-36.8-82.3-61-135.7-65.1 0-.2 0-.4 0-.6l0-48 48 0c8.8 0 16-7.2 16-16S296.8 0 288 0L160 0zm64 464a176 176 0 1 1 0-352 176 176 0 1 1 0 352zM112 240c0 8.8 7.2 16 16 16s16-7.2 16-16 7.2-16 16-16 16 7.2 16 16l0 3.8c0 5-1.4 9.9-4 14.1l-56.7 92.1c-2.2 3.5-3.3 7.5-3.3 11.7 0 12.3 10 22.2 22.2 22.2l57.8 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-40.3 0 47.5-77.3c5.7-9.3 8.8-20 8.8-30.9l0-3.8c0-26.5-21.5-48-48-48s-48 21.5-48 48zm176-48c-26.5 0-48 21.5-48 48l0 96c0 26.5 21.5 48 48 48s48-21.5 48-48l0-96c0-26.5-21.5-48-48-48zm-16 48c0-8.8 7.2-16 16-16s16 7.2 16 16l0 96c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-96z"]],
    "square-florin": [448, 512, [], "e717", ["M32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64C46.3 64 32 78.3 32 96zm80 272c0-8.8 7.2-16 16-16l23.9 0c8.2 0 15.7-4.9 18.9-12.5l35.8-83.5-62.6 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l76.3 0 27.5-64.1c8.3-19.3 27.3-31.9 48.3-31.9l23.9 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-23.9 0c-8.2 0-15.7 4.9-18.9 12.5L255.1 224 304 224c8.8 0 16 7.2 16 16s-7.2 16-16 16l-62.6 0-41.2 96.1c-8.3 19.3-27.3 31.9-48.3 31.9L128 384c-8.8 0-16-7.2-16-16z", "M64 64C46.3 64 32 78.3 32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm247.8 63.9c8.3-19.3 27.3-31.9 48.3-31.9l23.9 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-23.9 0c-8.2 0-15.7 4.9-18.9 12.5L255.1 224 304 224c8.8 0 16 7.2 16 16s-7.2 16-16 16l-62.6 0-41.2 96.1c-8.3 19.3-27.3 31.9-48.3 31.9L128 384c-8.8 0-16-7.2-16-16s7.2-16 16-16l23.9 0c8.2 0 15.7-4.9 18.9-12.5l35.8-83.5-62.6 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l76.3 0 27.5-64.1z"]],
    "binary": [384, 512, [], "e33b", ["", "M320 16c0-4.9-2.3-9.6-6.2-12.6S304.9-.7 300.1 .5l-64 16c-8.6 2.1-13.8 10.8-11.6 19.4s10.8 13.8 19.4 11.6l44.1-11 0 155.5-48 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l128 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-48 0 0-176zM96 304c0-4.9-2.3-9.6-6.2-12.6s-8.9-4.1-13.7-2.9l-64 16C3.6 306.6-1.7 315.3 .5 323.9s10.8 13.8 19.4 11.6l44.1-11 0 155.5-48 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l128 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-48 0 0-176zM0 64l0 96c0 35.3 28.7 64 64 64l64 0c35.3 0 64-28.7 64-64l0-96c0-35.3-28.7-64-64-64L64 0C28.7 0 0 28.7 0 64zM64 32l64 0c17.7 0 32 14.3 32 32l0 96c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-96c0-17.7 14.3-32 32-32zM256 288c-35.3 0-64 28.7-64 64l0 96c0 35.3 28.7 64 64 64l64 0c35.3 0 64-28.7 64-64l0-96c0-35.3-28.7-64-64-64l-64 0zm-32 64c0-17.7 14.3-32 32-32l64 0c17.7 0 32 14.3 32 32l0 96c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-96z"]],
    "shield-check": [512, 512, [], "f2f7", ["M48 139.8c.5 94 39.3 259.8 195.4 334.5 7.9 3.8 17.2 3.8 25.1 0 156.1-74.7 195-240.4 195.5-334.5 .1-12.1-7.5-22.8-18.8-27.6l-176.7-75c-8-3.4-17-3.4-25 0l-176.8 75C55.5 117 48 127.7 48 139.8zM164.5 279.6c-6.1-6.4-6-16.5 .4-22.6s16.5-5.9 22.6 .4l41.2 42.6 94.4-129.8c5.2-7.1 15.2-8.7 22.3-3.5s8.7 15.2 3.5 22.3L243.4 334.2c-2.8 3.8-7.1 6.2-11.8 6.5s-9.3-1.4-12.6-4.8l-54.4-56.3z", "M231.1 7.8c16-6.8 34-6.8 50 0L457.8 82.8c22 9.3 38.4 31 38.3 57.2-.5 99.2-41.3 280.7-213.7 363.2-16.7 8-36.1 8-52.7 0-172.4-82.5-213.1-264-213.6-363.2-.1-26.2 16.3-47.9 38.3-57.2L231.1 7.8zm37.5 29.4c-8-3.4-17-3.4-25 0l-176.8 75c-11.3 4.8-18.8 15.5-18.8 27.6 .5 94 39.3 259.8 195.4 334.5 7.9 3.8 17.2 3.8 25.1 0 156.1-74.7 195-240.4 195.5-334.5 .1-12.1-7.5-22.8-18.8-27.6l-176.7-75zm54.5 132.9c5.2-7.1 15.2-8.7 22.3-3.5s8.7 15.2 3.5 22.3L243.4 334.2c-2.8 3.8-7.1 6.2-11.8 6.5s-9.3-1.4-12.6-4.8l-54.4-56.3c-6.1-6.4-6-16.5 .4-22.6s16.5-5.9 22.6 .4l41.2 42.6 94.4-129.8z"]],
    "square-cruzeiro": [448, 512, [], "e6ed", ["M32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64C46.3 64 32 78.3 32 96zM88.5 256c0-75.1 60.9-136 136-136 36.1 0 69 14.1 93.3 37.1 6.4 6.1 6.7 16.2 .6 22.6s-16.2 6.7-22.6 .7c-18.6-17.6-43.7-28.4-71.4-28.4-57.4 0-104 46.6-104 104 0 51.8 37.9 94.8 87.5 102.7L208 248c0-8.8 7.2-16 16-16s16 7.2 16 16l0 4.1c11.4-7.7 25.2-12.1 40-12.1 8.8 0 16 7.2 16 16s-7.2 16-16 16c-22.1 0-40 17.9-40 40l0 46.9c21.5-3.2 40.8-13 55.8-27.2 6.4-6.1 16.6-5.8 22.6 .6s5.8 16.6-.6 22.6c-24.3 23-57.2 37.1-93.3 37.1-75.1 0-136-60.9-136-136z", "M64 64C46.3 64 32 78.3 32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM120.5 256c0 51.8 37.9 94.8 87.5 102.7L208 248c0-8.8 7.2-16 16-16s16 7.2 16 16l0 4.1c11.4-7.7 25.2-12.1 40-12.1 8.8 0 16 7.2 16 16s-7.2 16-16 16c-22.1 0-40 17.9-40 40l0 46.9c21.5-3.2 40.8-13 55.8-27.2 6.4-6.1 16.6-5.8 22.6 .6s5.8 16.6-.6 22.6c-24.3 23-57.2 37.1-93.3 37.1-75.1 0-136-60.9-136-136s60.9-136 136-136c36.1 0 69 14.1 93.3 37.1 6.4 6.1 6.7 16.2 .6 22.6s-16.2 6.7-22.6 .7c-18.6-17.6-43.7-28.4-71.4-28.4-57.4 0-104 46.6-104 104z"]],
    "truck-pickup": [640, 512, [128763], "f63c", ["M64 240l0 112 9.6 0c14.6-28.5 44.2-48 78.4-48s63.8 19.5 78.4 48l179.2 0c14.6-28.5 44.2-48 78.4-48s63.8 19.5 78.4 48l9.6 0 0-112c0-8.8-7.2-16-16-16L80 224c-8.8 0-16 7.2-16 16z", "M256 64l0 128 202.7 0-67.5-112.5C385.4 69.9 375 64 363.8 64L256 64zM224 192l0-128c0-17.7 14.3-32 32-32l107.8 0c22.5 0 43.3 11.8 54.9 31.1L496 192 560 192c26.5 0 48 21.5 48 48l0 112 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-48.4 0c.2 2.6 .4 5.3 .4 8 0 48.6-39.4 88-88 88s-88-39.4-88-88c0-2.7 .1-5.4 .4-8l-160.7 0c.2 2.6 .4 5.3 .4 8 0 48.6-39.4 88-88 88s-88-39.4-88-88c0-2.7 .1-5.4 .4-8L16 384c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0 0-112c0-26.5 21.5-48 48-48l144 0zm0 32L80 224c-8.8 0-16 7.2-16 16l0 112 9.6 0c14.6-28.5 44.2-48 78.4-48s63.8 19.5 78.4 48l179.2 0c14.6-28.5 44.2-48 78.4-48s63.8 19.5 78.4 48l9.6 0 0-112c0-8.8-7.2-16-16-16l-336 0zM208 392a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zm280 56a56 56 0 1 0 0-112 56 56 0 1 0 0 112z"]],
    "seedling": [512, 512, [127793, "sprout"], "f4d8", ["M32 96l32 0c106 0 192 86 192 192l-32 0C118 288 32 202 32 96zM288 224c0-106 86-192 192-192l0 16c0 106-86 192-192 192l0-16z", "M496 0l3.2 .3C506.5 1.8 512 8.3 512 16l0 32-.3 11.5c-5.8 114.5-97.7 206.4-212.2 212.2l-11.5 .3 0 224c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-176-32 0-11.5-.3C94.1 313.7 0 215.8 0 96L0 80c0-7.7 5.5-14.2 12.8-15.7l3.2-.3 48 0 11.5 .3c79.7 4 148.4 49.8 184.8 115.8 19.7-99.1 104.7-174.6 208.2-179.8L480 0 496 0zM32 96c0 106 86 192 192 192l32 0C256 182 170 96 64 96L32 96zM480 32c-106 0-192 86-192 192l0 16c106 0 192-86 192-192l0-16z"]],
    "circle-divide": [512, 512, [], "e106", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm112 0c0-8.8 7.2-16 16-16l192 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-192 0c-8.8 0-16-7.2-16-16zm136-96a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm0 192a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M256 32a224 224 0 1 1 0 448 224 224 0 1 1 0-448zm0 480a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm0-328a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm-96 56c-8.8 0-16 7.2-16 16s7.2 16 16 16l192 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-192 0zM280 352a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"]],
    "circle-kip": [512, 512, [], "e6fd", ["M32 256a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm112.2 .2c0-8.8 7.2-16 16-16l31.8 0 0-96.2c0-8.8 7.2-16 16-16s16 7.2 16 16l0 72.5 101.8-84.8c6.8-5.7 16.9-4.7 22.5 2.1s4.7 16.9-2.1 22.5l-100.8 83.9 90.3 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-90.2 0 100.6 83.5c6.8 5.6 7.7 15.7 2.1 22.5s-15.7 7.7-22.5 2.1L224 295.9 224 368c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-95.8-31.8 0c-8.8 0-16-7.2-16-16z", "M256 32a224 224 0 1 1 0 448 224 224 0 1 1 0-448zm0 480a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm92.3-378.2c-5.7-6.8-15.7-7.7-22.5-2.1L224 216.5 224 144c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 96.2-31.8 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l31.8 0 0 95.8c0 8.8 7.2 16 16 16s16-7.2 16-16l0-72.1 101.8 84.4c6.8 5.6 16.9 4.7 22.5-2.1s4.7-16.9-2.1-22.5l-100.6-83.5 90.2 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-90.3 0 100.8-83.9c6.8-5.7 7.7-15.7 2.1-22.5z"]],
    "transgender": [576, 512, [9895, "transgender-alt"], "f225", ["M160 240c0 68.3 53.5 124.1 120.9 127.8 2.4 .1 4.8 .2 7.1 .2s4.8-.1 7.1-.2c67.4-3.7 120.9-59.5 120.9-127.8 0-70.7-57.3-128-128-128S160 169.3 160 240z", "M160 0c0 8.8-7.2 16-16 16L70.6 16 128 73.4 148.7 52.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6L150.6 96 178.2 123.6C206.9 96.6 245.5 80 288 80s81.1 16.6 109.8 43.6L505.4 16 432 16c-8.8 0-16-7.2-16-16s7.2-16 16-16l112 0c8.8 0 16 7.2 16 16l0 112c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-73.4-109.2 109.2c18.4 26.1 29.2 57.9 29.2 92.2 0 83-63.1 151.2-144 159.2l0 48.8 48 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-48 0 0 48c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-48-48 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l48 0 0-48.8c-80.9-8-144-76.2-144-159.2 0-34.3 10.8-66.1 29.2-92.2l-29.2-29.2-20.7 20.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6L105.4 96 48 38.6 48 112c0 8.8-7.2 16-16 16s-16-7.2-16-16L16 0c0-8.8 7.2-16 16-16l112 0c8.8 0 16 7.2 16 16zM288 368a128 128 0 1 0 0-256 128 128 0 1 0 0 256z"]],
    "arrow-down-to-bracket": [448, 512, [], "e094", ["", "M379.3 203.3l-144 144c-6.2 6.2-16.4 6.2-22.6 0l-144-144c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0L208 297.4 208 16c0-8.8 7.2-16 16-16s16 7.2 16 16l0 281.4 116.7-116.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6zM32 336l0 80c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-80c0-8.8 7.2-16 16-16s16 7.2 16 16l0 80c0 53-43 96-96 96L96 512c-53 0-96-43-96-96l0-80c0-8.8 7.2-16 16-16s16 7.2 16 16z"]],
    "unicorn": [640, 512, [129412], "f727", ["M96 210.7c0 6.7 1.3 13.3 3.9 19.5l33.4 80.1c1.8 4.3 2.7 8.9 2.7 13.5 0 4.8-1 9.5-2.8 13.9l-8.1 19c-9.3 21.7-10.9 46-4.6 68.8l13.5 48.6c1 3.5 4.1 5.9 7.7 5.9l33.2 0c5.3 0 9.1-5 7.7-10.1l-15.9-57.2c-3.4-12.3-2.5-25.3 2.5-37l8.1-19c4.4-10.4 6.7-21.5 6.7-32.8 0-4.6-.4-9.2-1.1-13.7-.9-5.3 .9-10.6 4.8-14.3s9.3-5.2 14.5-4L318.4 318c1.4 .3 2.8 .6 4.3 .8 7.7 1.3 13.3 8 13.3 15.8L336 472c0 4.4 3.6 8 8 8l32 0c4.4 0 8-3.6 8-8l0-160.4c0-4.6 1.9-8.9 5.3-11.9 16.3-14.5 26.7-35.6 26.7-59.6 0-2.3-.1-4.5-.3-6.7-.1-1.5 0-3.1 .3-4.5l0-52.8c0-8.8 7.2-16 16-16l32 0c5.4 0 10.3 2.7 13.3 7.1l6.4 9.6c9.4 14.2 28.5 18.3 42.9 9.2 10.1-6.3 15.8-17.8 14.7-29.7l-7.7-80.8c-2.3-24.6-23-43.4-47.8-43.4L448 32c-61.9 0-112 50.1-112 112 0 8.8-7.2 16-16 16l-173.3 0c-28 0-50.7 22.7-50.7 50.7zM496 96a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M448 32l37.8 0c24.7 0 45.4 18.8 47.8 43.4l7.7 80.8c1.1 11.9-4.5 23.4-14.7 29.7-14.4 9-33.4 4.9-42.9-9.2l-6.4-9.6c-3-4.5-8-7.1-13.3-7.1l-32 0c-8.8 0-16 7.2-16 16l0 52.8c-.3 1.5-.4 3-.3 4.5 .2 2.2 .3 4.4 .3 6.7 0 24-10.4 45.1-26.7 59.6-3.4 3-5.3 7.4-5.3 11.9L384 472c0 4.4-3.6 8-8 8l-32 0c-4.4 0-8-3.6-8-8l0-137.3c0-7.8-5.6-14.5-13.3-15.8-1.4-.2-2.8-.5-4.3-.8L202.2 291.9c-5.2-1.2-10.6 .3-14.5 4s-5.7 9-4.8 14.3c.8 4.5 1.1 9.1 1.1 13.7 0 11.3-2.3 22.4-6.7 32.8l-8.1 19c-5 11.7-5.9 24.8-2.5 37l15.9 57.2c1.4 5.1-2.4 10.1-7.7 10.1l-33.2 0c-3.6 0-6.7-2.4-7.7-5.9l-13.5-48.6c-6.3-22.8-4.7-47.1 4.6-68.8l8.1-19c1.9-4.4 2.8-9.1 2.8-13.9 0-4.6-.9-9.3-2.7-13.5L99.9 230.2c-2.6-6.2-3.9-12.8-3.9-19.5 0-28 22.7-50.7 50.7-50.7L320 160c8.8 0 16-7.2 16-16 0-61.9 50.1-112 112-112zM564.2 64c-2.5-12.2-7.7-23.4-15-32.9 6.3-2.1 10.8-8.1 10.8-15.1 0-8.8-7.2-16-16-16L448 0C373.9 0 312.8 56 304.9 128l-158.2 0C113.2 128 84.4 147.9 71.4 176.5 31.3 180.8 0 214.7 0 256l0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48c0-20.9 13.4-38.7 32-45.3 0 10.9 2.2 21.7 6.4 31.7l33.4 80.1c.2 .4 .2 .8 .2 1.2 0 .4-.1 .9-.3 1.3l-8.1 19c-12.2 28.4-14.3 60.2-6 90l13.5 48.6c4.8 17.3 20.6 29.3 38.5 29.3l33.2 0c26.5 0 45.6-25.2 38.5-50.7l-15.9-57.2c-1.5-5.3-1.1-10.9 1.1-15.9l8.1-19c5.6-13.1 8.8-27.2 9.2-41.4L304 347.6 304 472c0 22.1 17.9 40 40 40l32 0c22.1 0 40-17.9 40-40l0-153.6c19.6-20 32-47.5 32-78.4 0-1.9-.1-3.9-.1-5.8 .1-.7 .1-1.4 .1-2.2l0-40 7.4 0 1.7 2.5c19 28.6 57.4 36.8 86.5 18.6 20.4-12.7 31.8-35.9 29.6-59.9l-4.7-49.4 65.2-21.7c3.8-1.3 6.4-4.8 6.4-8.8 0-5.1-4.2-9.3-9.3-9.3l-66.5 0zM480 112a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"]],
    "left-from-bracket": [512, 512, [], "e66c", ["M35.3 256L160 380.7 160 304c0-8.8 7.2-16 16-16l128 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-128 0c-8.8 0-16-7.2-16-16L160 131.3 35.3 256z", "M7 239l0 0c-9.4 9.4-9.4 24.6 0 33.9l0 0 144 144c6.9 6.9 17.2 8.9 26.2 5.2S192 409.7 192 400l0-80 112 0c26.5 0 48-21.5 48-48l0-32c0-26.5-21.5-48-48-48l-112 0 0-80c0-9.7-5.8-18.5-14.8-22.2S157.9 88.2 151 95L7 239zM160 380.7L35.3 256 160 131.3 160 208c0 8.8 7.2 16 16 16l128 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-128 0c-8.8 0-16 7.2-16 16l0 76.7zM336 448c-8.8 0-16 7.2-16 16s7.2 16 16 16l80 0c53 0 96-43 96-96l0-256c0-53-43-96-96-96l-80 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l80 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64l-80 0z"]],
    "ramp-loading": [384, 512, [], "f4d4", ["M51.8 480l280.4 0-64-128-152.4 0-64 128z", "M0 64C0 28.7 28.7 0 64 0L320 0c35.3 0 64 28.7 64 64l0 340.7-32-64 0-276.7c0-17.7-14.3-32-32-32L64 32C46.3 32 32 46.3 32 64L32 340.7 0 404.7 0 64zM372.4 488.8c5.3 10.6-2.4 23.2-14.3 23.2L25.9 512c-11.9 0-19.6-12.5-14.3-23.2 7.8-15.6 33-66 75.6-151.2 5.4-10.8 16.5-17.7 28.6-17.7l152.4 0c12.1 0 23.2 6.8 28.6 17.7 42.6 85.1 67.8 135.5 75.6 151.2zM332.2 480l-64-128-152.4 0-64 128 280.4 0z"]],
    "hand-holding-box": [576, 512, [], "f47b", ["M0 384c0 8.8 7.2 16 16 16l64 0c3.2 0 6.2-.9 8.9-2.7l79.9-53.3c7.9-5.3 17.1-8.1 26.6-8.1L344 336c13.3 0 24 10.7 24 24s-10.7 24-24 24l-88 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l148.6 0c2.9 0 5.7-.8 8.2-2.3L511.3 355c3.4-2 7.2-3 11.1-3l1.3 0c11.2 0 20.3 9.1 20.3 20.3 0 6.9-3.5 13.3-9.2 17L415.1 467.1c-13 8.4-28.1 12.9-43.6 12.9L16 480c-8.8 0-16 7.2-16 16L0 384z", "M208 32l0 96c0 5.5 2.9 10.7 7.6 13.6s10.6 3.2 15.6 .7l56.8-28.4 56.8 28.4c5 2.5 10.9 2.2 15.6-.7s7.6-8.1 7.6-13.6l0-96 32 0c8.8 0 16 7.2 16 16l0 160c0 8.8-7.2 16-16 16l-224 0c-8.8 0-16-7.2-16-16l0-160c0-8.8 7.2-16 16-16l32 0zM224 0L176 0c-26.5 0-48 21.5-48 48l0 160c0 26.5 21.5 48 48 48l224 0c26.5 0 48-21.5 48-48l0-160c0-26.5-21.5-48-48-48L224 0zm16 32l96 0 0 70.1-40.8-20.4c-4.5-2.3-9.8-2.3-14.3 0L240 102.1 240 32zM195.4 304c-15.8 0-31.2 4.7-44.4 13.4L75.2 368 16 368c-8.8 0-16 7.2-16 16s7.2 16 16 16l64 0c3.2 0 6.2-.9 8.9-2.7l79.9-53.3c7.9-5.3 17.1-8.1 26.6-8.1L344 336c13.3 0 24 10.7 24 24s-10.7 24-24 24l-88 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l148.6 0c2.9 0 5.7-.8 8.2-2.3L511.3 355c3.4-2 7.2-3 11.1-3l1.3 0c11.2 0 20.3 9.1 20.3 20.3 0 6.9-3.5 13.3-9.2 17L415.1 467.1c-13 8.4-28.1 12.9-43.6 12.9L16 480c-8.8 0-16 7.2-16 16s7.2 16 16 16l355.5 0c21.7 0 42.9-6.3 61-18.1l119.6-77.8c14.8-9.6 23.8-26.1 23.8-43.8 0-28.9-23.4-52.3-52.3-52.3l-1.3 0c-9.7 0-19.1 2.6-27.5 7.6l-94.7 56.4-5.6 0c3.5-7.3 5.4-15.4 5.4-24 0-30.9-25.1-56-56-56l-148.6 0z"]],
    "star-half": [576, 512, [61731], "f089", ["M53.7 179.9L157.1 283.3c7.2 7.2 10.6 17.5 9 27.6l-22.8 144.4 128.8-65.5 0-348.9-50.5 98.9c-4.6 9.1-13.4 15.5-23.5 17.1l-144.4 23z", "M266.7-18.9c4.1-8 12.4-13.1 21.4-13.1 8.8 0 16 7.2 16 16l0 415.6c0 6-3.4 11.5-8.7 14.3L143.8 491c-8 4.1-17.7 3.3-25-2l0 0c-7.3-5.3-11-14.2-9.6-23.2L134.4 305.9 20 191.4c-6.4-6.4-8.6-15.8-5.8-24.4s10.1-14.9 19.1-16.3l159.9-25.4 73.6-144.2zM272.1 41l-50.5 98.9c-4.6 9.1-13.4 15.5-23.5 17.1l-144.4 23 103.3 103.5c7.2 7.2 10.6 17.5 9 27.6l-22.8 144.4 128.8-65.5 0-348.9zM295.2-4.4l0 0 0 0s0 0 0 0zM29.4 172l0 0z"]],
    "arrow-down-to-line": [384, 512, ["arrow-to-bottom"], "f33d", ["", "M368 512c8.8 0 16-7.2 16-16s-7.2-16-16-16L16 480c-8.8 0-16 7.2-16 16s7.2 16 16 16l352 0zM180.7 379.3c6.2 6.2 16.4 6.2 22.6 0l144-144c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0L208 329.4 208 16c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 313.4-116.7-116.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l144 144z"]],
    "photo-film": [640, 512, ["photo-video"], "f87c", ["M224 64l0 224c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-224c0-17.7-14.3-32-32-32L256 32c-17.7 0-32 14.3-32 32zm37.1 203.3c-7.1-12.7-6.7-28.2 .9-40.5l39.4-63.9c7-11.4 19.2-18.5 32.6-19s26 5.7 33.9 16.5l4.7 6.5 42.6-61.7c7.4-10.7 19.4-17.1 32.4-17.3s25.2 5.9 32.8 16.3l87.8 119.8c8.9 12.2 10.2 28.3 3.4 41.7s-20.6 21.9-35.7 21.9l-239.8 0c-14.5 0-27.9-7.8-3