/*!
 * Font Awesome Pro 7.1.0 by @fontawesome - https://fontawesome.com
 * License - https://fontawesome.com/license (Commercial License)
 * Copyright 2025 Fonticons, Inc.
 */
(function () {
  'use strict';

  var _WINDOW = {};
  var _DOCUMENT = {};
  try {
    if (typeof window !== 'undefined') _WINDOW = window;
    if (typeof document !== 'undefined') _DOCUMENT = document;
  } catch (e) {} // eslint-disable-line no-empty

  var _ref = _WINDOW.navigator || {},
    _ref$userAgent = _ref.userAgent,
    userAgent = _ref$userAgent === void 0 ? '' : _ref$userAgent;
  var WINDOW = _WINDOW;
  var DOCUMENT = _DOCUMENT;
  var IS_BROWSER = !!WINDOW.document;
  var IS_DOM = !!DOCUMENT.documentElement && !!DOCUMENT.head && typeof DOCUMENT.addEventListener === 'function' && typeof DOCUMENT.createElement === 'function';
  var IS_IE = ~userAgent.indexOf('MSIE') || ~userAgent.indexOf('Trident/');

  function _arrayLikeToArray(r, a) {
    (null == a || a > r.length) && (a = r.length);
    for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e];
    return n;
  }
  function _arrayWithoutHoles(r) {
    if (Array.isArray(r)) return _arrayLikeToArray(r);
  }
  function _defineProperty(e, r, t) {
    return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, {
      value: t,
      enumerable: !0,
      configurable: !0,
      writable: !0
    }) : e[r] = t, e;
  }
  function _iterableToArray(r) {
    if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r);
  }
  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }
  function ownKeys(e, r) {
    var t = Object.keys(e);
    if (Object.getOwnPropertySymbols) {
      var o = Object.getOwnPropertySymbols(e);
      r && (o = o.filter(function (r) {
        return Object.getOwnPropertyDescriptor(e, r).enumerable;
      })), t.push.apply(t, o);
    }
    return t;
  }
  function _objectSpread2(e) {
    for (var r = 1; r < arguments.length; r++) {
      var t = null != arguments[r] ? arguments[r] : {};
      r % 2 ? ownKeys(Object(t), !0).forEach(function (r) {
        _defineProperty(e, r, t[r]);
      }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) {
        Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r));
      });
    }
    return e;
  }
  function _toConsumableArray(r) {
    return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread();
  }
  function _toPrimitive(t, r) {
    if ("object" != typeof t || !t) return t;
    var e = t[Symbol.toPrimitive];
    if (void 0 !== e) {
      var i = e.call(t, r || "default");
      if ("object" != typeof i) return i;
      throw new TypeError("@@toPrimitive must return a primitive value.");
    }
    return ("string" === r ? String : Number)(t);
  }
  function _toPropertyKey(t) {
    var i = _toPrimitive(t, "string");
    return "symbol" == typeof i ? i : i + "";
  }
  function _unsupportedIterableToArray(r, a) {
    if (r) {
      if ("string" == typeof r) return _arrayLikeToArray(r, a);
      var t = {}.toString.call(r).slice(8, -1);
      return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0;
    }
  }

  var _dt;
  var q = {
      classic: {
        fa: "solid",
        fas: "solid",
        "fa-solid": "solid",
        far: "regular",
        "fa-regular": "regular",
        fal: "light",
        "fa-light": "light",
        fat: "thin",
        "fa-thin": "thin",
        fab: "brands",
        "fa-brands": "brands"
      },
      duotone: {
        fa: "solid",
        fad: "solid",
        "fa-solid": "solid",
        "fa-duotone": "solid",
        fadr: "regular",
        "fa-regular": "regular",
        fadl: "light",
        "fa-light": "light",
        fadt: "thin",
        "fa-thin": "thin"
      },
      sharp: {
        fa: "solid",
        fass: "solid",
        "fa-solid": "solid",
        fasr: "regular",
        "fa-regular": "regular",
        fasl: "light",
        "fa-light": "light",
        fast: "thin",
        "fa-thin": "thin"
      },
      "sharp-duotone": {
        fa: "solid",
        fasds: "solid",
        "fa-solid": "solid",
        fasdr: "regular",
        "fa-regular": "regular",
        fasdl: "light",
        "fa-light": "light",
        fasdt: "thin",
        "fa-thin": "thin"
      },
      slab: {
        "fa-regular": "regular",
        faslr: "regular"
      },
      "slab-press": {
        "fa-regular": "regular",
        faslpr: "regular"
      },
      thumbprint: {
        "fa-light": "light",
        fatl: "light"
      },
      whiteboard: {
        "fa-semibold": "semibold",
        fawsb: "semibold"
      },
      notdog: {
        "fa-solid": "solid",
        fans: "solid"
      },
      "notdog-duo": {
        "fa-solid": "solid",
        fands: "solid"
      },
      etch: {
        "fa-solid": "solid",
        faes: "solid"
      },
      jelly: {
        "fa-regular": "regular",
        fajr: "regular"
      },
      "jelly-fill": {
        "fa-regular": "regular",
        fajfr: "regular"
      },
      "jelly-duo": {
        "fa-regular": "regular",
        fajdr: "regular"
      },
      chisel: {
        "fa-regular": "regular",
        facr: "regular"
      },
      utility: {
        "fa-semibold": "semibold",
        fausb: "semibold"
      },
      "utility-duo": {
        "fa-semibold": "semibold",
        faudsb: "semibold"
      },
      "utility-fill": {
        "fa-semibold": "semibold",
        faufsb: "semibold"
      }
    };
  var i = "classic",
    t = "duotone",
    d = "sharp",
    l = "sharp-duotone",
    f = "chisel",
    n = "etch",
    h = "jelly",
    o = "jelly-duo",
    u = "jelly-fill",
    g = "notdog",
    s = "notdog-duo",
    y = "slab",
    m = "slab-press",
    e = "thumbprint",
    p = "utility",
    a = "utility-duo",
    w = "utility-fill",
    x = "whiteboard",
    b = "Classic",
    c = "Duotone",
    I = "Sharp",
    F = "Sharp Duotone",
    v = "Chisel",
    S = "Etch",
    A = "Jelly",
    P = "Jelly Duo",
    j = "Jelly Fill",
    B = "Notdog",
    N = "Notdog Duo",
    k = "Slab",
    D = "Slab Press",
    T = "Thumbprint",
    C = "Utility",
    W = "Utility Duo",
    K = "Utility Fill",
    R = "Whiteboard",
    dt = (_dt = {}, _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_dt, i, b), t, c), d, I), l, F), f, v), n, S), h, A), o, P), u, j), g, B), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_dt, s, N), y, k), m, D), e, T), p, C), a, W), w, K), x, R));
  var gt = {
      classic: {
        900: "fas",
        400: "far",
        normal: "far",
        300: "fal",
        100: "fat"
      },
      duotone: {
        900: "fad",
        400: "fadr",
        300: "fadl",
        100: "fadt"
      },
      sharp: {
        900: "fass",
        400: "fasr",
        300: "fasl",
        100: "fast"
      },
      "sharp-duotone": {
        900: "fasds",
        400: "fasdr",
        300: "fasdl",
        100: "fasdt"
      },
      slab: {
        400: "faslr"
      },
      "slab-press": {
        400: "faslpr"
      },
      whiteboard: {
        600: "fawsb"
      },
      thumbprint: {
        300: "fatl"
      },
      notdog: {
        900: "fans"
      },
      "notdog-duo": {
        900: "fands"
      },
      etch: {
        900: "faes"
      },
      chisel: {
        400: "facr"
      },
      jelly: {
        400: "fajr"
      },
      "jelly-fill": {
        400: "fajfr"
      },
      "jelly-duo": {
        400: "fajdr"
      },
      utility: {
        600: "fausb"
      },
      "utility-duo": {
        600: "faudsb"
      },
      "utility-fill": {
        600: "faufsb"
      }
    };
  var _t = {
      chisel: {
        regular: "facr"
      },
      classic: {
        brands: "fab",
        light: "fal",
        regular: "far",
        solid: "fas",
        thin: "fat"
      },
      duotone: {
        light: "fadl",
        regular: "fadr",
        solid: "fad",
        thin: "fadt"
      },
      etch: {
        solid: "faes"
      },
      jelly: {
        regular: "fajr"
      },
      "jelly-duo": {
        regular: "fajdr"
      },
      "jelly-fill": {
        regular: "fajfr"
      },
      notdog: {
        solid: "fans"
      },
      "notdog-duo": {
        solid: "fands"
      },
      sharp: {
        light: "fasl",
        regular: "fasr",
        solid: "fass",
        thin: "fast"
      },
      "sharp-duotone": {
        light: "fasdl",
        regular: "fasdr",
        solid: "fasds",
        thin: "fasdt"
      },
      slab: {
        regular: "faslr"
      },
      "slab-press": {
        regular: "faslpr"
      },
      thumbprint: {
        light: "fatl"
      },
      utility: {
        semibold: "fausb"
      },
      "utility-duo": {
        semibold: "faudsb"
      },
      "utility-fill": {
        semibold: "faufsb"
      },
      whiteboard: {
        semibold: "fawsb"
      }
    };
  var qt = {
      kit: {
        fak: "kit",
        "fa-kit": "kit"
      },
      "kit-duotone": {
        fakd: "kit-duotone",
        "fa-kit-duotone": "kit-duotone"
      }
    },
    Ht = ["kit"];
  var L = "kit",
    r = "kit-duotone",
    U = "Kit",
    J = "Kit Duotone",
    $t = _defineProperty(_defineProperty({}, L, U), r, J);
  var ol = {
    kit: {
      "fa-kit": "fak"
    },
    "kit-duotone": {
      "fa-kit-duotone": "fakd"
    }
  };
  var fl = {
      kit: {
        fak: "fa-kit"
      },
      "kit-duotone": {
        fakd: "fa-kit-duotone"
      }
    };
  var ul = {
      kit: {
        kit: "fak"
      },
      "kit-duotone": {
        "kit-duotone": "fakd"
      }
    };

  var _ml;
  var l$1 = {
      GROUP: "duotone-group",
      SWAP_OPACITY: "swap-opacity",
      PRIMARY: "primary",
      SECONDARY: "secondary"
    };
  var n$1 = "classic",
    o$1 = "duotone",
    u$1 = "sharp",
    s$1 = "sharp-duotone",
    h$1 = "chisel",
    g$1 = "etch",
    y$1 = "jelly",
    e$1 = "jelly-duo",
    m$1 = "jelly-fill",
    p$1 = "notdog",
    a$1 = "notdog-duo",
    w$1 = "slab",
    b$1 = "slab-press",
    r$1 = "thumbprint",
    c$1 = "utility",
    i$1 = "utility-duo",
    x$1 = "utility-fill",
    I$1 = "whiteboard",
    F$1 = "Classic",
    v$1 = "Duotone",
    S$1 = "Sharp",
    A$1 = "Sharp Duotone",
    P$1 = "Chisel",
    j$1 = "Etch",
    B$1 = "Jelly",
    N$1 = "Jelly Duo",
    k$1 = "Jelly Fill",
    D$1 = "Notdog",
    C$1 = "Notdog Duo",
    T$1 = "Slab",
    L$1 = "Slab Press",
    W$1 = "Thumbprint",
    R$1 = "Utility",
    K$1 = "Utility Duo",
    U$1 = "Utility Fill",
    J$1 = "Whiteboard",
    ml$1 = (_ml = {}, _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_ml, n$1, F$1), o$1, v$1), u$1, S$1), s$1, A$1), h$1, P$1), g$1, j$1), y$1, B$1), e$1, N$1), m$1, k$1), p$1, D$1), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_ml, a$1, C$1), w$1, T$1), b$1, L$1), r$1, W$1), c$1, R$1), i$1, K$1), x$1, U$1), I$1, J$1));
  var E$1 = "kit",
    d$1 = "kit-duotone",
    _$1 = "Kit",
    M$1 = "Kit Duotone",
    rt$1 = _defineProperty(_defineProperty({}, E$1, _$1), d$1, M$1);
  var $t$1 = {
      classic: {
        "fa-brands": "fab",
        "fa-duotone": "fad",
        "fa-light": "fal",
        "fa-regular": "far",
        "fa-solid": "fas",
        "fa-thin": "fat"
      },
      duotone: {
        "fa-regular": "fadr",
        "fa-light": "fadl",
        "fa-thin": "fadt"
      },
      sharp: {
        "fa-solid": "fass",
        "fa-regular": "fasr",
        "fa-light": "fasl",
        "fa-thin": "fast"
      },
      "sharp-duotone": {
        "fa-solid": "fasds",
        "fa-regular": "fasdr",
        "fa-light": "fasdl",
        "fa-thin": "fasdt"
      },
      slab: {
        "fa-regular": "faslr"
      },
      "slab-press": {
        "fa-regular": "faslpr"
      },
      whiteboard: {
        "fa-semibold": "fawsb"
      },
      thumbprint: {
        "fa-light": "fatl"
      },
      notdog: {
        "fa-solid": "fans"
      },
      "notdog-duo": {
        "fa-solid": "fands"
      },
      etch: {
        "fa-solid": "faes"
      },
      jelly: {
        "fa-regular": "fajr"
      },
      "jelly-fill": {
        "fa-regular": "fajfr"
      },
      "jelly-duo": {
        "fa-regular": "fajdr"
      },
      chisel: {
        "fa-regular": "facr"
      },
      utility: {
        "fa-semibold": "fausb"
      },
      "utility-duo": {
        "fa-semibold": "faudsb"
      },
      "utility-fill": {
        "fa-semibold": "faufsb"
      }
    },
    z = {
      classic: ["fas", "far", "fal", "fat", "fad"],
      duotone: ["fadr", "fadl", "fadt"],
      sharp: ["fass", "fasr", "fasl", "fast"],
      "sharp-duotone": ["fasds", "fasdr", "fasdl", "fasdt"],
      slab: ["faslr"],
      "slab-press": ["faslpr"],
      whiteboard: ["fawsb"],
      thumbprint: ["fatl"],
      notdog: ["fans"],
      "notdog-duo": ["fands"],
      etch: ["faes"],
      jelly: ["fajr"],
      "jelly-fill": ["fajfr"],
      "jelly-duo": ["fajdr"],
      chisel: ["facr"],
      utility: ["fausb"],
      "utility-duo": ["faudsb"],
      "utility-fill": ["faufsb"]
    },
    Ht$1 = {
      classic: {
        fab: "fa-brands",
        fad: "fa-duotone",
        fal: "fa-light",
        far: "fa-regular",
        fas: "fa-solid",
        fat: "fa-thin"
      },
      duotone: {
        fadr: "fa-regular",
        fadl: "fa-light",
        fadt: "fa-thin"
      },
      sharp: {
        fass: "fa-solid",
        fasr: "fa-regular",
        fasl: "fa-light",
        fast: "fa-thin"
      },
      "sharp-duotone": {
        fasds: "fa-solid",
        fasdr: "fa-regular",
        fasdl: "fa-light",
        fasdt: "fa-thin"
      },
      slab: {
        faslr: "fa-regular"
      },
      "slab-press": {
        faslpr: "fa-regular"
      },
      whiteboard: {
        fawsb: "fa-semibold"
      },
      thumbprint: {
        fatl: "fa-light"
      },
      notdog: {
        fans: "fa-solid"
      },
      "notdog-duo": {
        fands: "fa-solid"
      },
      etch: {
        faes: "fa-solid"
      },
      jelly: {
        fajr: "fa-regular"
      },
      "jelly-fill": {
        fajfr: "fa-regular"
      },
      "jelly-duo": {
        fajdr: "fa-regular"
      },
      chisel: {
        facr: "fa-regular"
      },
      utility: {
        fausb: "fa-semibold"
      },
      "utility-duo": {
        faudsb: "fa-semibold"
      },
      "utility-fill": {
        faufsb: "fa-semibold"
      }
    },
    G$1 = ["solid", "regular", "light", "thin", "duotone", "brands", "semibold"],
    O$1 = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
    V$1 = O$1.concat([11, 12, 13, 14, 15, 16, 17, 18, 19, 20]),
    $$1 = ["aw", "fw", "pull-left", "pull-right"],
    to = [].concat(_toConsumableArray(Object.keys(z)), G$1, $$1, ["2xs", "xs", "sm", "lg", "xl", "2xl", "beat", "border", "fade", "beat-fade", "bounce", "flip-both", "flip-horizontal", "flip-vertical", "flip", "inverse", "layers", "layers-bottom-left", "layers-bottom-right", "layers-counter", "layers-text", "layers-top-left", "layers-top-right", "li", "pull-end", "pull-start", "pulse", "rotate-180", "rotate-270", "rotate-90", "rotate-by", "shake", "spin-pulse", "spin-reverse", "spin", "stack-1x", "stack-2x", "stack", "ul", "width-auto", "width-fixed", l$1.GROUP, l$1.SWAP_OPACITY, l$1.PRIMARY, l$1.SECONDARY]).concat(O$1.map(function (t) {
      return "".concat(t, "x");
    })).concat(V$1.map(function (t) {
      return "w-".concat(t);
    }));

  var NAMESPACE_IDENTIFIER = '___FONT_AWESOME___';
  var PRODUCTION = function () {
    try {
      return "production" === 'production';
    } catch (e$$1) {
      return false;
    }
  }();
  function familyProxy(obj) {
    // Defaults to the classic family if family is not available
    return new Proxy(obj, {
      get: function get(target, prop) {
        return prop in target ? target[prop] : target[i];
      }
    });
  }
  var _PREFIX_TO_STYLE = _objectSpread2({}, q);

  // We changed FACSSClassesToStyleId in the icons repo to be canonical and as such, "classic" family does not have any
  // duotone styles.  But we do still need duotone in _PREFIX_TO_STYLE below, so we are manually adding
  // {'fa-duotone': 'duotone'}
  _PREFIX_TO_STYLE[i] = _objectSpread2(_objectSpread2(_objectSpread2(_objectSpread2({}, {
    'fa-duotone': 'duotone'
  }), q[i]), qt['kit']), qt['kit-duotone']);
  var PREFIX_TO_STYLE = familyProxy(_PREFIX_TO_STYLE);
  var _STYLE_TO_PREFIX = _objectSpread2({}, _t);

  // We changed FAStyleIdToShortPrefixId in the icons repo to be canonical and as such, "classic" family does not have any
  // duotone styles.  But we do still need duotone in _STYLE_TO_PREFIX below, so we are manually adding {duotone: 'fad'}
  _STYLE_TO_PREFIX[i] = _objectSpread2(_objectSpread2(_objectSpread2(_objectSpread2({}, {
    duotone: 'fad'
  }), _STYLE_TO_PREFIX[i]), ul['kit']), ul['kit-duotone']);
  var STYLE_TO_PREFIX = familyProxy(_STYLE_TO_PREFIX);
  var _PREFIX_TO_LONG_STYLE = _objectSpread2({}, Ht$1);
  _PREFIX_TO_LONG_STYLE[i] = _objectSpread2(_objectSpread2({}, _PREFIX_TO_LONG_STYLE[i]), fl['kit']);
  var PREFIX_TO_LONG_STYLE = familyProxy(_PREFIX_TO_LONG_STYLE);
  var _LONG_STYLE_TO_PREFIX = _objectSpread2({}, $t$1);
  _LONG_STYLE_TO_PREFIX[i] = _objectSpread2(_objectSpread2({}, _LONG_STYLE_TO_PREFIX[i]), ol['kit']);
  var LONG_STYLE_TO_PREFIX = familyProxy(_LONG_STYLE_TO_PREFIX);
  var _FONT_WEIGHT_TO_PREFIX = _objectSpread2({}, gt);
  var FONT_WEIGHT_TO_PREFIX = familyProxy(_FONT_WEIGHT_TO_PREFIX);
  var RESERVED_CLASSES = [].concat(_toConsumableArray(Ht), _toConsumableArray(to));

  function bunker(fn) {
    try {
      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }
      fn.apply(void 0, args);
    } catch (e) {
      if (!PRODUCTION) {
        throw e;
      }
    }
  }

  var w$2 = WINDOW || {};
  if (!w$2[NAMESPACE_IDENTIFIER]) w$2[NAMESPACE_IDENTIFIER] = {};
  if (!w$2[NAMESPACE_IDENTIFIER].styles) w$2[NAMESPACE_IDENTIFIER].styles = {};
  if (!w$2[NAMESPACE_IDENTIFIER].hooks) w$2[NAMESPACE_IDENTIFIER].hooks = {};
  if (!w$2[NAMESPACE_IDENTIFIER].shims) w$2[NAMESPACE_IDENTIFIER].shims = [];
  var namespace = w$2[NAMESPACE_IDENTIFIER];

  function normalizeIcons(icons) {
    return Object.keys(icons).reduce(function (acc, iconName) {
      var icon = icons[iconName];
      var expanded = !!icon.icon;
      if (expanded) {
        acc[icon.iconName] = icon.icon;
      } else {
        acc[iconName] = icon;
      }
      return acc;
    }, {});
  }
  function defineIcons(prefix, icons) {
    var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    var _params$skipHooks = params.skipHooks,
      skipHooks = _params$skipHooks === void 0 ? false : _params$skipHooks;
    var normalized = normalizeIcons(icons);
    if (typeof namespace.hooks.addPack === 'function' && !skipHooks) {
      namespace.hooks.addPack(prefix, normalizeIcons(icons));
    } else {
      namespace.styles[prefix] = _objectSpread2(_objectSpread2({}, namespace.styles[prefix] || {}), normalized);
    }

    /**
     * Font Awesome 4 used the prefix of `fa` for all icons. With the introduction
     * of new styles we needed to differentiate between them. Prefix `fa` is now an alias
     * for `fas` so we'll ease the upgrade process for our users by automatically defining
     * this as well.
     */
    if (prefix === 'fas') {
      defineIcons('fa', icons);
    }
  }

  var icons = {
    "0": [320, 512, [], "30", ["", "M0 192C0 103.6 71.6 32 160 32s160 71.6 160 160l0 128c0 88.4-71.6 160-160 160S0 408.4 0 320L0 192zM160 80C98.1 80 48 130.1 48 192l0 128c0 61.9 50.1 112 112 112s112-50.1 112-112l0-128c0-61.9-50.1-112-112-112z"]],
    "1": [256, 512, [], "31", ["", "M24 32C10.7 32 0 42.7 0 56S10.7 80 24 80l80 0 0 352-80 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l208 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0 0-376c0-13.3-10.7-24-24-24L24 32z"]],
    "2": [384, 512, [], "32", ["", "M48 64c0-13.3 10.7-24 24-24l186.9 0c55.9 0 101.1 45.3 101.1 101.1 0 40.5-24.1 77-61.3 93L143 300.8c-38.2 16.4-63 54-63 95.6l0 35.6 248 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L56 480c-13.3 0-24-10.7-24-24l0-59.6c0-60.8 36.2-115.8 92.1-139.7L279.8 190c19.5-8.4 32.2-27.6 32.2-48.8 0-29.3-23.8-53.1-53.1-53.1L72 88C58.7 88 48 77.3 48 64z"]],
    "3": [320, 512, [], "33", ["", "M72 280c-13.3 0-24-10.7-24-24s10.7-24 24-24l124 0c42 0 76-34 76-76s-34-76-76-76L24 80C10.7 80 0 69.3 0 56S10.7 32 24 32l172 0c68.5 0 124 55.5 124 124 0 41-19.9 77.4-50.7 100 30.7 22.6 50.7 59 50.7 100 0 68.5-55.5 124-124 124L24 480c-13.3 0-24-10.7-24-24s10.7-24 24-24l172 0c42 0 76-34 76-76s-34-76-76-76L72 280z"]],
    "4": [384, 512, [], "34", ["", "M320 56c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 248-208 0c-8.8 0-16-7.2-16-16L48 56c0-13.3-10.7-24-24-24S0 42.7 0 56L0 288c0 35.3 28.7 64 64 64l208 0 0 104c0 13.3 10.7 24 24 24s24-10.7 24-24l0-104 40 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-40 0 0-248z"]],
    "5": [320, 512, [], "35", ["", "M0 56C0 42.7 10.7 32 24 32l240 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-216 0 0 128 136 0c75.1 0 136 60.9 136 136S259.1 480 184 480L24 480c-13.3 0-24-10.7-24-24s10.7-24 24-24l160 0c48.6 0 88-39.4 88-88s-39.4-88-88-88L24 256c-13.3 0-24-10.7-24-24L0 56z"]],
    "6": [384, 512, [], "36", ["", "M264 32c13.3 0 24 10.7 24 24s-10.7 24-24 24L160 80c-53 0-96 43-96 96l0 64.3c23.7-20.1 54.4-32.3 88-32.3l64 0c75.1 0 136 60.9 136 136S291.1 480 216 480l-64 0c-75.1 0-136-60.9-136-136 0-1.9 0-3.8 .1-5.6-.1-.8-.1-1.6-.1-2.4l0-160C16 96.5 80.5 32 160 32l104 0zM64 344c0 48.6 39.4 88 88 88l64 0c48.6 0 88-39.4 88-88s-39.4-88-88-88l-64 0c-48.6 0-88 39.4-88 88z"]],
    "7": [320, 512, [], "37", ["", "M0 56C0 42.7 10.7 32 24 32l272 0c8.6 0 16.6 4.7 20.9 12.2s4.1 16.8-.3 24.2l-240 400c-6.8 11.4-21.6 15-32.9 8.2S28.6 455 35.4 443.7L253.6 80 24 80C10.7 80 0 69.3 0 56z"]],
    "8": [320, 512, [], "38", ["", "M304 156c0-68.5-55.5-124-124-124l-40 0C71.5 32 16 87.5 16 156 16 193.7 32.8 227.4 59.3 250.2 23.7 272 0 311.2 0 356 0 424.5 55.5 480 124 480l72 0c68.5 0 124-55.5 124-124 0-44.8-23.7-84-59.3-105.8 26.5-22.7 43.3-56.5 43.3-94.2zM180.1 280l15.9 0c42 0 76 34 76 76s-34 76-76 76l-72 0c-42 0-76-34-76-76s34-76 76-76l56.1 0zm0-48L140 232c-42 0-76-34-76-76 0-42 34-76 76-76l40 0c42 0 76 34 76 76 0 42-34 76-76 76z"]],
    "9": [384, 512, [], "39", ["", "M208 320c36.9 0 70.5-13.9 96-36.7l0 52.7c0 53-43 96-96 96l-104 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l104 0c79.5 0 144-64.5 144-144l0-160.1C352 96.4 287.5 32 208 32l-48 0C80.5 32 16 96.5 16 176S80.5 320 160 320l48 0zm96-144c0 53-43 96-96 96l-48 0c-53 0-96-43-96-96s43-96 96-96l48 0c53 0 96 43 96 96z"]],
    "chess-pawn-piece": [320, 512, ["chess-pawn-alt"], "f444", ["M77.4 464l165.1 0-38.4-48-88.3 0-38.4 48zM104 136a56 56 0 1 0 112 0 56 56 0 1 0 -112 0zm25.7 232l60.6 0-11.8-128-36.9 0-11.8 128z", "M160 32c57.4 0 104 46.6 104 104 0 22.3-7.1 42.9-19 59.8 6.6 4.3 11 11.7 11 20.2 0 13.3-10.7 24-24 24l-5.3 0 13.3 144 56.2 70.3c5 6.3 7.8 14.1 7.8 22.2 0 19.6-15.9 35.5-35.5 35.5L51.5 512c-19.6 0-35.5-15.9-35.5-35.5 0-8.1 2.7-15.9 7.8-22.2L80 384 93.3 240 88 240c-13.3 0-24-10.7-24-24 0-8.5 4.4-15.9 11-20.2-11.9-16.9-19-37.6-19-59.8 0-57.4 46.6-104 104-104zM115.8 416l-38.4 48 165.1 0-38.4-48-88.3 0zm13.8-48l60.6 0-11.8-128-36.9 0-11.8 128zM160 80a56 56 0 1 0 0 112 56 56 0 1 0 0-112z"]],
    "dollar-sign": [320, 512, [128178, 61781, "dollar", "usd"], "24", ["", "M136 24c0-13.3 10.7-24 24-24s24 10.7 24 24l0 40 64 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-130 0c-29.8 0-54 24.2-54 54 0 26.4 19.1 48.9 45.1 53.2l106.1 17.7c51.3 8.5 88.8 52.9 88.8 104.8 0 58.7-47.6 106.3-106.3 106.3l-13.7 0 0 40c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-40-80 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l141.7 0c32.2 0 58.3-26.1 58.3-58.3 0-28.5-20.6-52.8-48.7-57.5L101.2 266.5C52 258.3 16 215.8 16 166 16 109.6 61.6 64 118 64l18 0 0-40z"]],
    "layer-plus": [512, 512, ["layer-group-plus"], "f5ff", ["M81.2 224l171.4 79.2c2.1 1 4.6 1 6.7 0L430.8 224 259.4 144.7c-2.1-1-4.6-1-6.7 0L81.2 224zm0 160l171.4 79.2c2.1 1 4.6 1 6.7 0l171.4-79.2-58.7-27.1c-24.2 11.2-48.3 22.3-72.5 33.5-27.7 12.8-59.6 12.8-87.3 0-24.2-11.2-48.3-22.3-72.5-33.5L81.2 384z", "M432-32c13.3 0 24 10.7 24 24l0 32 32 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-32 0 0 32c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-32-32 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l32 0 0-32c0-13.3 10.7-24 24-24zM252.6 144.7L81.2 224 252.6 303.2c2.1 1 4.6 1 6.7 0L430.8 224 259.4 144.7c-2.1-1-4.6-1-6.7 0zm-20.1-43.6c14.9-6.9 32.1-6.9 47 0l218.6 101c8.5 3.9 13.9 12.4 13.9 21.8s-5.4 17.9-13.9 21.8l-218.6 101c-14.9 6.9-32.1 6.9-47 0L13.9 245.8C5.4 241.8 0 233.3 0 224s5.4-17.9 13.9-21.8l218.6-101zM13.9 362.2l68.7-31.8 57.2 26.4-58.7 27.1 171.4 79.2c2.1 1 4.6 1 6.7 0l171.4-79.2-58.7-27.1 57.2-26.4 68.7 31.8c8.5 3.9 13.9 12.4 13.9 21.8s-5.4 17.9-13.9 21.8l-218.6 101c-14.9 6.9-32.1 6.9-47 0L13.9 405.8C5.4 401.8 0 393.3 0 384s5.4-17.9 13.9-21.8z"]],
    "grid-4": [448, 512, [], "e198", ["", "M0 48c0-8.8 7.2-16 16-16l48 0c8.8 0 16 7.2 16 16l0 48c0 8.8-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16L0 48zM0 170.7c0-8.8 7.2-16 16-16l48 0c8.8 0 16 7.2 16 16l0 48c0 8.8-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16l0-48zM0 293.3c0-8.8 7.2-16 16-16l48 0c8.8 0 16 7.2 16 16l0 48c0 8.8-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16l0-48zM16 400l48 0c8.8 0 16 7.2 16 16l0 48c0 8.8-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16l0-48c0-8.8 7.2-16 16-16zm122.7 0l48 0c8.8 0 16 7.2 16 16l0 48c0 8.8-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16l0-48c0-8.8 7.2-16 16-16zm106.7 16c0-8.8 7.2-16 16-16l48 0c8.8 0 16 7.2 16 16l0 48c0 8.8-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16l0-48zM384 400l48 0c8.8 0 16 7.2 16 16l0 48c0 8.8-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16l0-48c0-8.8 7.2-16 16-16zM138.7 277.3l48 0c8.8 0 16 7.2 16 16l0 48c0 8.8-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16l0-48c0-8.8 7.2-16 16-16zm106.7 16c0-8.8 7.2-16 16-16l48 0c8.8 0 16 7.2 16 16l0 48c0 8.8-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16l0-48zm138.7-16l48 0c8.8 0 16 7.2 16 16l0 48c0 8.8-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16l0-48c0-8.8 7.2-16 16-16zM138.7 154.7l48 0c8.8 0 16 7.2 16 16l0 48c0 8.8-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16l0-48c0-8.8 7.2-16 16-16zm106.7 16c0-8.8 7.2-16 16-16l48 0c8.8 0 16 7.2 16 16l0 48c0 8.8-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16l0-48zm138.7-16l48 0c8.8 0 16 7.2 16 16l0 48c0 8.8-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16l0-48c0-8.8 7.2-16 16-16zM138.7 32l48 0c8.8 0 16 7.2 16 16l0 48c0 8.8-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16l0-48c0-8.8 7.2-16 16-16zM245.3 48c0-8.8 7.2-16 16-16l48 0c8.8 0 16 7.2 16 16l0 48c0 8.8-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16l0-48zM384 32l48 0c8.8 0 16 7.2 16 16l0 48c0 8.8-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16l0-48c0-8.8 7.2-16 16-16z"]],
    "dog": [576, 512, [128021], "f6d3", ["M112 208l0 248c0 4.4 3.6 8 8 8l32 0c4.4 0 8-3.6 8-8l0-104c0-8.1 4.1-15.7 10.9-20.1s15.4-5.1 22.8-1.8l20 8.9 5.1 2.1c25.6 9.8 54.2 9.1 79.4-2.1l20-8.9c7.4-3.3 16-2.6 22.8 1.8S352 343.9 352 352l0 104c0 4.4 3.6 8 8 8l32 0c4.4 0 8-3.6 8-8l0-218.5-68.9-29.5-219.1 0zm229.5-47.8l65.2 27.9 1.8-8.9 1.2-4C413.2 166.2 422 160 432 160l40 0c30.9 0 56-25.1 56-56l0-24-40 0c-6.4 0-12.5-2.5-17-7L457.8 59.7C450.3 52.2 440.1 48 429.5 48l-64.7 0-23.4 112.2zM452 88a20 20 0 1 1 -40 0 20 20 0 1 1 40 0z", "M328.5-12.9c2.7-13 15.4-21.3 28.4-18.6s21.3 15.4 18.6 28.4l-.7 3.1 54.7 0 8.7 .4c20.1 2 39.1 10.9 53.5 25.3l6.2 6.2 54.1 0 2.5 .1C566.6 33.4 576 43.6 576 56l0 48c0 57.4-46.6 104-104 104l-20.3 0-3.7 18.4 0 229.6c0 30.9-25.1 56-56 56l-32 0c-30.9 0-56-25.1-56-56l0-67.9c-31.2 10.4-64.8 10.4-96 0l0 67.9c0 30.9-25.1 56-56 56l-32 0c-30.9 0-56-25.1-56-56l0-251.4C27.1 194.1 0 160.3 0 120 0 106.7 10.7 96 24 96s24 10.7 24 24c0 22.1 17.9 40 40 40l204.5 0 36-172.9zM112 456c0 4.4 3.6 8 8 8l32 0c4.4 0 8-3.6 8-8l0-104c0-8.1 4.1-15.7 10.9-20.1s15.4-5.1 22.8-1.8l20 8.9 5.1 2.1c25.6 9.8 54.2 9.1 79.4-2.1l20-8.9c7.4-3.3 16-2.6 22.8 1.8S352 343.9 352 352l0 104c0 4.4 3.6 8 8 8l32 0c4.4 0 8-3.6 8-8l0-218.5-68.9-29.5-219.1 0 0 248zM341.5 160.2l65.2 27.9 1.8-8.9 1.2-4C413.2 166.2 422 160 432 160l40 0c30.9 0 56-25.1 56-56l0-24-40 0c-6.4 0-12.5-2.5-17-7L457.8 59.7C450.3 52.2 440.1 48 429.5 48l-64.7 0-23.4 112.2zM432 108a20 20 0 1 1 0-40 20 20 0 1 1 0 40z"]],
    "truck-moving": [640, 512, [], "f4df", ["M48 96l0 249.6c12-6.1 25.6-9.6 40-9.6 25.2 0 48 10.6 64 27.6 16-17 38.8-27.6 64-27.6 40.3 0 74.2 27.1 84.7 64l131.3 0 0-304c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16zM480 304l0 41.6c12-6.1 25.6-9.6 40-9.6 29.8 0 56.1 14.8 72 37.4l0-69.4-112 0z", "M64 80c-8.8 0-16 7.2-16 16l0 249.6c12-6.1 25.6-9.6 40-9.6 25.2 0 48 10.6 64 27.6 16-17 38.8-27.6 64-27.6 40.3 0 74.2 27.1 84.7 64l131.3 0 0-304c0-8.8-7.2-16-16-16L64 80zM480 345.6c12-6.1 25.6-9.6 40-9.6 29.8 0 56.1 14.8 72 37.4l0-69.4-112 0 0 41.6zM640 384c0 24.3-13.5 45.4-33.5 56.3-7.6 40.8-43.5 71.7-86.5 71.7-40.3 0-74.2-27.1-84.7-64l-134.6 0c-10.4 36.9-44.4 64-84.7 64-25.2 0-48-10.6-64-27.6-16 17-38.8 27.6-64 27.6-48.6 0-88-39.4-88-88L0 96C0 60.7 28.7 32 64 32l352 0c35.3 0 64 28.7 64 64l0 32 55.4 0c17 0 33.3 6.7 45.3 18.7l40.6 40.6c12 12 18.7 28.3 18.7 45.3L640 384zM592 256l0-23.4c0-4.2-1.7-8.3-4.7-11.3l-40.6-40.6c-3-3-7.1-4.7-11.3-4.7l-55.4 0 0 80 112 0zM88 464a40 40 0 1 0 0-80 40 40 0 1 0 0 80zm472-40a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zM216 464a40 40 0 1 0 0-80 40 40 0 1 0 0 80z"]],
    "rotate": [512, 512, [128260, "sync-alt"], "f2f1", ["M48 376l0 54.1 54.1-54.1-54.1 0zM410.1 136l54.1 0 0-54.1c-18.1 18-36.1 36.1-54.1 54.1z", "M512.2 24c0-9.7-5.8-18.5-14.8-22.2S478.1 .2 471.2 7L419.4 58.8C318.8-24.7 169.3-19.3 75.1 75 31.9 118.2 7.3 173.1 1.5 229.5 .1 242.7 9.7 254.5 22.9 255.9s25-8.2 26.3-21.4c4.7-45.9 24.7-90.4 59.8-125.5 75.5-75.5 194.6-80.8 276.2-16L335.1 143c-6.9 6.9-8.9 17.2-5.2 26.2S342.4 184 352.1 184l136.1 0c13.3 0 24-10.7 24-24l0-136zm-75.1 85l27.1-27.1 0 54.1-54.1 0 27-27zm73.6 173.6c1.4-13.2-8.2-25-21.4-26.3s-25 8.2-26.3 21.4c-4.7 45.8-24.7 90.4-59.8 125.5-75.5 75.5-194.6 80.8-276.2 16L177.1 369c6.9-6.9 8.9-17.2 5.2-26.2S169.8 328 160.1 328L24 328c-13.3 0-24 10.7-24 24L0 488c0 9.7 5.8 18.5 14.8 22.2S34.1 511.8 41 505l51.8-51.8c100.6 83.5 250.1 78.1 344.3-16.2 43.2-43.2 67.8-98.1 73.6-154.5zM48 430.1l0-54.1 54.1 0-54.1 54.1z"]],
    "arrow-u-turn-up-left": [512, 512, [], "e7ed", ["", "M7.1 145c-9.4-9.4-9.4-24.6 0-33.9L127.1-9c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9L82 104 324 104c103.8 0 188 84.2 188 188S427.8 480 324 480l-236 0-2.5-.1C73.5 478.6 64 468.4 64 456s9.4-22.6 21.5-23.9l2.5-.1 236 0c77.3 0 140-62.7 140-140S401.3 152 324 152l-242.1 0 79 79 1.7 1.8c7.7 9.4 7.1 23.3-1.7 32.1s-22.7 9.3-32.1 1.7l-1.8-1.7-120-120z"]],
    "keyboard-brightness": [640, 512, [], "e1c0", ["", "M129 167c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l80 80c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-80-80zm167 33c0 13.3 10.7 24 24 24s24-10.7 24-24l0-112c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 112zm135 47c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l80-80c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-80 80zM0 392c0 13.3 10.7 24 24 24l80 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0c-13.3 0-24 10.7-24 24zm216-24c-13.3 0-24 10.7-24 24s10.7 24 24 24l208 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-208 0zm320 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l80 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0z"]],
    "tent-double-peak": [576, 512, [], "e627", ["M48.3 189.1c-.2 .3-.3 .6-.3 .6l0 34.3 480 0 0-34.3c0-.1-.1-.3-.3-.6-.4-.7-1.3-1.7-2.7-2.6-29.8-18.3-68.2-47.4-101.8-89.9-29.6 29.2-75.9 62.1-135.2 62.1S182.5 125.7 152.8 96.5c-33.6 42.6-72 71.6-101.8 89.9-1.4 .9-2.3 1.9-2.8 2.6zM48 272l0 176c0 8.8 7.2 16 16 16l192 0 0-192-208 0zm256 0L407.4 464 512 464c8.8 0 16-7.2 16-16l0-176-224 0z", "M442.2 40.4c-6.8-10.8-23.6-11.6-31.6-1.6-22.6 28.4-66.3 71.8-122.6 71.8S188 67.2 165.4 38.7c-7.9-10-24.8-9.1-31.6 1.6-32.5 51.6-75.6 85.3-107.9 105.2-15.5 9.5-25.9 25.9-25.9 44.1L0 448c0 35.3 28.7 64 64 64l448 0c35.3 0 64-28.7 64-64l0-258.3c0-18.2-10.4-34.6-25.9-44.1-32.3-19.9-75.4-53.6-107.9-105.2zM525 186.4c1.4 .9 2.3 1.9 2.7 2.6 .2 .3 .3 .6 .3 .6l0 34.3-480 0 0-34.3c0-.1 .1-.3 .3-.6 .4-.7 1.3-1.7 2.8-2.6 29.8-18.3 68.2-47.4 101.8-89.9 29.6 29.2 75.9 62.1 135.2 62.1s105.5-32.9 135.2-62.1c33.6 42.6 72 71.6 101.8 89.9zM48 272l208 0 0 192-192 0c-8.8 0-16-7.2-16-16l0-176zm256 0l224 0 0 176c0 8.8-7.2 16-16 16L407.4 464 304 272z"]],
    "square-minus": [448, 512, [61767, "minus-square"], "f146", ["M48 96l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16zm64 160c0-13.3 10.7-24 24-24l176 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-176 0c-13.3 0-24-10.7-24-24z", "M64 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM136 232l176 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-176 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"]],
    "water-arrow-up": [512, 512, ["water-rise"], "f775", ["M0 358.7c0 1.1 .1 2.2 .2 3.2 1.8 13.1 13.8 22.4 27 20.6 28.2-3.8 53.6-18.9 74.2-34.5 21.3-16.1 49.9-16.1 71.2 0 24.2 18.3 52.3 35.9 83.4 35.9s59.1-17.7 83.4-35.9c21.3-16.1 49.9-16.1 71.2 0 20.7 15.6 46 30.7 74.2 34.5 13.1 1.8 25.2-7.5 27-20.6 .1-.9 .2-1.8 .2-2.7l0 127c-.2-11.6-8.9-21.7-20.8-23.3-15.9-2.1-33.2-11.3-51.7-25.2-38.4-29-90.5-29-129 0-24 18.1-40.7 26.3-54.5 26.3s-30.5-8.2-54.5-26.3c-38.4-29-90.5-29-129 0-18.5 13.9-35.8 23.1-51.7 25.2-12.3 1.6-21.2 12.4-20.8 23.8 0-42.7 0-85.3 0-128.1zM172.7 476.1c24.2 18.3 52.3 35.9 83.4 35.9-30.6 0-58.3-17.2-82.3-35.2-.3-.3-.7-.5-1-.8zm237.9 0c20.7 15.6 46 30.7 74.2 34.5-27.8-3.7-52.8-18.4-73.3-33.8-.3-.2-.6-.5-.9-.7z", "M280 216c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-134.1-47 47c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9L239 7c9.4-9.4 24.6-9.4 33.9 0l88 88c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-47-47 0 134.1zM410.6 348.1c-21.3-16.1-49.9-16.1-71.2 0-24.2 18.3-52.3 35.9-83.4 35.9s-59.1-17.7-83.4-35.9c-21.3-16.1-49.9-16.1-71.2 0-20.7 15.6-46 30.7-74.2 34.5-13.1 1.8-25.2-7.5-27-20.6s7.5-25.2 20.6-27c15.9-2.1 33.2-11.3 51.7-25.2 38.4-29 90.5-29 129 0 24 18.1 40.7 26.3 54.5 26.3s30.5-8.2 54.5-26.3c38.4-29 90.5-29 129 0 18.5 13.9 35.8 23.1 51.7 25.2 13.1 1.8 22.4 13.8 20.6 27s-13.8 22.4-27 20.6c-28.2-3.8-53.6-18.9-74.2-34.5zm0 128c-21.3-16.1-49.9-16.1-71.2 0-24.2 18.3-52.3 35.9-83.4 35.9s-59.1-17.7-83.4-35.9c-21.3-16.1-49.9-16.1-71.2 0-20.7 15.6-46 30.7-74.2 34.5-13.1 1.8-25.2-7.5-27-20.6s7.5-25.2 20.6-27c15.9-2.1 33.2-11.3 51.7-25.2 38.4-29 90.5-29 129 0 24 18.1 40.7 26.3 54.5 26.3s30.5-8.2 54.5-26.3c38.4-29 90.5-29 129 0 18.5 13.9 35.8 23.1 51.7 25.2 13.1 1.8 22.4 13.8 20.6 27s-13.8 22.4-27 20.6c-28.2-3.8-53.6-18.9-74.2-34.5z"]],
    "xmark-to-slot": [576, 512, ["times-to-slot", "vote-nay"], "f771", ["M144 96l0 224c0 8.8 7.2 16 16 16l256 0c8.8 0 16-7.2 16-16l0-224c0-8.8-7.2-16-16-16L160 80c-8.8 0-16 7.2-16 16zm76.1 44.1c9.4-9.4 24.6-9.4 33.9 0l33.9 33.9 33.9-33.9c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-33.9 33.9 33.9 33.9c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-33.9-33.9-33.9 33.9c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l33.9-33.9-33.9-33.9c-9.4-9.4-9.4-24.6 0-33.9z", "M416 80c8.8 0 16 7.2 16 16l0 224c0 8.8-7.2 16-16 16l-256 0c-8.8 0-16-7.2-16-16l0-224c0-8.8 7.2-16 16-16l256 0zM160 32c-35.3 0-64 28.7-64 64l0 224c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-224c0-35.3-28.7-64-64-64L160 32zM24 288c-13.3 0-24 10.7-24 24L0 416c0 35.3 28.7 64 64 64l448 0c35.3 0 64-28.7 64-64l0-104c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 104c0 8.8-7.2 16-16 16L64 432c-8.8 0-16-7.2-16-16l0-104c0-13.3-10.7-24-24-24zM355.9 140.1c-9.4-9.4-24.6-9.4-33.9 0l-33.9 33.9-33.9-33.9c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l33.9 33.9-33.9 33.9c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l33.9-33.9 33.9 33.9c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-33.9-33.9 33.9-33.9c9.4-9.4 9.4-24.6 0-33.9z"]],
    "sensor-cloud": [576, 512, ["sensor-smoke"], "e02c", ["M112 96c0-8.8 7.2-16 16-16l320 0c8.8 0 16 7.2 16 16l0 176.3c-2.6-.2-5.3-.3-8-.3-6 0-11.9 .5-17.7 1.5-22.7-20.8-53-33.5-86.3-33.5-69.4 0-125.8 55.2-127.9 124-21.3 17-37 40.7-44 68l-52 0c-8.8 0-16-7.2-16-16l0-320zm48 56l0 80c0 13.3 10.7 24 24 24s24-10.7 24-24l0-80c0-13.3-10.7-24-24-24s-24 10.7-24 24zm96 0l0 80c0 13.3 10.7 24 24 24s24-10.7 24-24l0-80c0-13.3-10.7-24-24-24s-24 10.7-24 24z", "M128 80l320 0c8.8 0 16 7.2 16 16l0 176.3c17.6 1.3 33.9 7 48 16L512 96c0-35.3-28.7-64-64-64L128 32C92.7 32 64 60.7 64 96l0 320c0 35.3 28.7 64 64 64l49 0c-.7-5.2-1-10.6-1-16 0-11.1 1.4-21.8 4-32l-52 0c-8.8 0-16-7.2-16-16l0-320c0-8.8 7.2-16 16-16zm80 72c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 80c0 13.3 10.7 24 24 24s24-10.7 24-24l0-80zm96 0c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 80c0 13.3 10.7 24 24 24s24-10.7 24-24l0-80zM576 464c0-39-27.9-71.5-64.8-78.6 .5-3.1 .8-6.2 .8-9.4 0-30.9-25.1-56-56-56-12.4 0-23.9 4-33.1 10.8-13.4-25.5-40.1-42.8-70.9-42.8-44.2 0-80 35.8-80 80 0 7.4 1 14.6 2.9 21.5-29.8 11.6-50.9 40.6-50.9 74.5 0 44.2 35.8 80 80 80l192 0c44.2 0 80-35.8 80-80z"]],
    "lychee": [512, 512, [], "e824", ["M50.3 283.4l3.5 7.8c5.9 13.4 6.3 28.6 1.8 42.2-1.5 3.7-3 7.3-4.7 10.9 10.9 11.4 19.4 23.3 21.4 39.5 .5 4.8 .7 9.6 .6 14.4 6.3 2.5 17 7.4 25.3 15.7S111.5 432.7 114 439c4.8-.1 9.6 .1 14.4 .6 16.2 2.1 28 10.6 39.5 21.4 3.6-1.6 7.2-3.2 10.9-4.7 13.5-4.6 28.8-4.1 42.2 1.8l7.8 3.5c.4-.3 .9-.7 1.4-1.1 9.7-7.5 27.7-21.3 52.9-16.6 5.1 .9 7.4 1.5 9.4 .8 1.9-.6 3.4-2.5 6.6-6.2 10.9-13.2 27.8-20.6 44.1-20.6l9.7-.3c1-1.6 2.4-3.9 4.4-7.7 8-14.7 22.6-25.4 38.7-28.8l8.8-2.2c1.3-4.4 2.5-8.9 3.8-13.3 6.2-17 19.2-26.8 34.2-35.4-1.3-19.2 5.4-32.6 13-48 1.4-2.9 2.9-5.8 4.3-8.8-6.9-15.9-11.6-31-6.5-48.4 1-3.8 2.1-7.6 2.7-11.4-7.1-6.2-16.8-9.8-25.1-14-25.9-12.9-51.7-25.7-73.1-45.8-20.2-21.4-33-47.2-45.9-73.2-1.9-3.8-3.8-7.6-5.7-11.4-4.1-8.1-6.8-11.9-8.2-13.6-3.9 .5-7.7 1.7-11.4 2.7-17.4 5.1-32.5 .5-48.4-6.5-3.1 1.5-6 2.9-8.8 4.3-15.4 7.7-28.8 14.3-48 13-8.6 15-18.4 28-35.4 34.2-4.4 1.4-8.9 2.5-13.3 3.8l-2.2 8.8c-3.4 16.1-14.1 30.7-28.8 38.7-3.7 2-6.1 3.4-7.7 4.4l-.3 9.7c0 16.3-7.4 33.2-20.6 44.1-3.8 3.2-5.6 4.6-6.2 6.5-.7 2-.1 4.3 .8 9.4 5 26.4-10.5 44.9-17.6 54.3zm77.9 74.3l.4-2.4 8-40c1.9-9.5 9.3-16.9 18.8-18.8l40-8 2.4-.4c12.1-1.2 23.4 7 25.8 19.2 2.4 12.2-4.8 24.1-16.4 27.7l-2.4 .6-24.3 4.8-4.9 24.3-.6 2.4c-3.6 11.6-15.5 18.9-27.7 16.4-12.2-2.4-20.4-13.7-19.2-25.8zm32-160l.4-2.4 8-40c1.9-9.5 9.3-16.9 18.8-18.8l40-8 2.4-.4c12.1-1.2 23.4 7 25.8 19.2 2.4 12.2-4.8 24.1-16.4 27.7l-2.4 .6-24.3 4.8-4.9 24.3-.6 2.4c-3.6 11.6-15.5 18.9-27.7 16.4-12.2-2.4-20.4-13.7-19.2-25.8zm128 128l.4-2.4 8-40c1.9-9.5 9.3-16.9 18.8-18.8l40-8 2.4-.4c12.1-1.2 23.4 7 25.8 19.2 2.4 12.2-4.8 24.1-16.4 27.7l-2.4 .6-24.3 4.8-4.9 24.3-.6 2.4c-3.6 11.6-15.5 18.9-27.7 16.4s-20.4-13.7-19.2-25.8z", "M232 4.3c11.9-1.6 22.9 1.9 33.3 7.3 2.3 1.3 5.7 1.6 8.2 .8 7.2-2.5 15-4.2 22.6-4.7 12.5-.8 23.4 3.5 33 11.1 14.6 12.8 22.3 33.1 30.7 50.1 3.1 6.3 6.2 12.2 9.3 17.9l30.5-18.3c12.6-7.5 28.7-5.6 39.1 4.8s12.4 26.5 4.8 39.1L425.1 143c8.9 4.9 18.1 9.3 27.2 13.6 14.7 6.9 30.3 14.3 40.9 26.3 7.6 9.6 11.9 20.5 11.1 33-.5 7.5-2.2 15.4-4.7 22.6-.8 2.5-.5 5.9 .8 8.2 5.4 10.4 8.9 21.5 7.3 33.3-1.5 10.7-6.6 18.9-9.9 23.8-7.5 11.2-8.3 11.9-7.9 16 .6 5.4 1.1 11.1 .8 16.3-.3 5.7-1.4 12.5-5.4 19.2-3.8 6.5-9.1 10.7-13.3 13.5-4.4 2.9-9 5.6-13.8 7.9-2.4 1.2-4.5 3.9-5.1 6.4-1.3 5.4-2.8 11.1-4.7 16-2.1 5.3-5.3 11.1-10.8 16.2-5.4 4.9-11.5 7.4-16.3 9-3.5 1.1-7.1 2-10.7 2.8-4.2 1-9.1 1.7-11.3 5.9-2.7 4.9-5.5 10-8.4 14.2-3.2 4.5-7.5 9.4-13.9 13.1-6.3 3.6-12.7 4.8-17.8 5.3-5.3 .5-10.7 .6-16.1 .6-2.7 0-5.9 1.6-7.3 3.2-6.9 9.2-16.6 17.5-27.5 21.3-11.2 3.9-22.8 2.6-34.2 .7-1.6-.3-2.8-.2-4.8 .7-3 1.4-6 3.7-12.1 8.3-7.5 5.5-18.2 12.2-32.1 10.4-5.6-.7-10.4-2.6-13.6-4l-10.1-4.6c-2.6-1.1-6.1-.9-9.1 .5-4.4 2.1-9.1 4.3-13.5 5.8-5 1.7-12 3.4-20 1.8-7.9-1.5-13.8-5.5-17.7-8.7-4.3-3.4-8.3-7.4-12.1-11.3-1.5-1.5-3.4-2.4-5.5-2.9-3.5-.5-7.1-.4-10.7-.4-4.2 0-8.4 0-12.6-.8-6-1.1-12.3-3.7-18-8.8-5.2-4.7-8.5-10.5-11-15.8-1.9-4.7-3-9.4-7.3-13.6-4.3-4.3-9-5.3-13.7-7.3-5.4-2.4-11.1-5.8-15.8-11-5.2-5.7-7.7-12-8.8-18-.8-4.2-.8-8.4-.8-12.6 0-5.2 .9-12.2-3.3-16.2-3.9-3.9-7.8-7.9-11.2-12.1-3.2-3.9-7.2-9.8-8.7-17.7-1.5-8.1 .1-15.1 1.8-20 1.6-4.6 4-9.7 6.2-14.3 1.2-2.7 1.1-6 .1-8.3L5.3 300.5c-1.4-3.1-3.3-7.9-4-13.6-1.8-13.9 4.9-24.6 10.4-32.1 4.6-6.1 6.9-9.2 8.3-12.1 .9-2 1-3.1 .7-4.7-1.9-11.4-3.2-23 .7-34.2 3.8-10.9 12.1-20.6 21.3-27.5 1.7-1.4 3.2-4.5 3.2-7.3 0-5.3 0-10.7 .6-16.1 .5-5.2 1.7-11.5 5.3-17.8 3.6-6.4 8.6-10.7 13.1-13.9 4.2-3 9.3-5.8 14.2-8.4 2.2-1.2 4.2-4 4.8-6.6 1.3-5.2 2.3-10.4 3.9-15.4 1.6-4.9 4.1-10.9 9-16.3 5-5.6 10.9-8.7 16.2-10.8 4.9-1.9 10.6-3.4 16-4.8 2.5-.6 5.2-2.8 6.4-5.1 2.4-4.7 5-9.4 7.9-13.7 2.8-4.2 7-9.4 13.5-13.3 6.7-4 13.5-5.1 19.2-5.4 5.2-.2 10.9 .3 16.3 .8 3.7 .3 4.6-.3 12.8-5.8 8.3-5.6 16.8-10.6 26.9-12zm-2.4 52c-15.4 7.7-28.8 14.3-48 13-8.6 15-18.4 28-35.4 34.2-4.4 1.4-8.9 2.5-13.3 3.8l-2.2 8.8c-3.4 16.1-14.1 30.7-28.8 38.7-3.7 2-6.1 3.4-7.7 4.4l-.3 9.7c0 16.3-7.4 33.2-20.6 44.1-3.8 3.2-5.6 4.6-6.2 6.5-.7 2-.1 4.3 .8 9.4 5 26.4-10.5 44.9-17.6 54.3l3.5 7.8c5.9 13.4 6.3 28.6 1.8 42.2-1.5 3.7-3 7.3-4.7 10.9 10.9 11.4 19.4 23.3 21.4 39.5 .5 4.8 .7 9.6 .6 14.4 6.3 2.5 17 7.4 25.3 15.7S111.5 432.7 114 439c4.8-.1 9.6 .1 14.4 .6 16.2 2.1 28 10.6 39.5 21.4 3.6-1.6 7.2-3.2 10.9-4.7 13.5-4.6 28.8-4.1 42.2 1.8l7.8 3.5c.4-.3 .9-.7 1.4-1.1 9.7-7.5 27.7-21.3 52.9-16.6 5.1 .9 7.4 1.5 9.4 .8 1.9-.6 3.4-2.5 6.6-6.2 10.9-13.2 27.8-20.6 44.1-20.6l9.7-.3c1-1.6 2.4-3.9 4.4-7.7 8-14.7 22.6-25.4 38.7-28.8l8.8-2.2c1.3-4.4 2.5-8.9 3.8-13.3 6.2-17 19.2-26.8 34.2-35.4-1.3-19.2 5.4-32.6 13-48 1.4-2.9 2.9-5.8 4.3-8.8-6.9-15.9-11.6-31-6.5-48.4 1-3.8 2.1-7.6 2.7-11.4-7.1-6.2-16.8-9.8-25.1-14-25.9-12.9-51.7-25.7-73.1-45.8-20.2-21.4-33-47.2-45.9-73.2-1.9-3.8-3.8-7.6-5.7-11.4-4.1-8.1-6.8-11.9-8.2-13.6-3.9 .5-7.7 1.7-11.4 2.7-17.4 5.1-32.5 .5-48.4-6.5-3.1 1.5-6 2.9-8.8 4.3zM197.8 288.1c12.1-1.2 23.4 7 25.8 19.2 2.4 12.2-4.8 24.1-16.4 27.7l-2.4 .6-24.3 4.8-4.9 24.3-.6 2.4c-3.6 11.6-15.5 18.9-27.7 16.4-12.2-2.4-20.4-13.7-19.2-25.8l.4-2.4 8-40c1.9-9.5 9.3-16.9 18.8-18.8l40-8 2.4-.4zm160-32c12.1-1.2 23.4 7 25.8 19.2 2.4 12.2-4.8 24.1-16.4 27.7l-2.4 .6-24.3 4.8-4.9 24.3-.6 2.4c-3.6 11.6-15.5 18.9-27.7 16.4s-20.4-13.7-19.2-25.8l.4-2.4 8-40c1.9-9.5 9.3-16.9 18.8-18.8l40-8 2.4-.4zm-128-128c12.1-1.2 23.4 7 25.8 19.2 2.4 12.2-4.8 24.1-16.4 27.7l-2.4 .6-24.3 4.8-4.9 24.3-.6 2.4c-3.6 11.6-15.5 18.9-27.7 16.4-12.2-2.4-20.4-13.7-19.2-25.8l.4-2.4 8-40c1.9-9.5 9.3-16.9 18.8-18.8l40-8 2.4-.4z"]],
    "align-justify": [448, 512, [], "f039", ["", "M24 40C10.7 40 0 50.7 0 64S10.7 88 24 88l400 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L24 40zm0 128c-13.3 0-24 10.7-24 24s10.7 24 24 24l400 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L24 168zM0 320c0 13.3 10.7 24 24 24l400 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L24 296c-13.3 0-24 10.7-24 24zM24 424c-13.3 0-24 10.7-24 24s10.7 24 24 24l400 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L24 424z"]],
    "sunglasses": [576, 512, [128374], "f892", ["M86.9 431.1c2.9 .6 6 .9 9.1 .9l64 0c26.5 0 48-21.5 48-48l0-51.9-121.1 99zm320 0c2.9 .6 6 .9 9.1 .9l64 0c26.5 0 48-21.5 48-48l0-51.9-121.1 99z", "M135.8 80c-17.7 0-33.3 11.7-38.4 28.6L53.8 256 224 256c17.7 0 32 14.3 32 32l64 0c0-17.7 14.3-32 32-32l170.2 0-43.7-147.4c-5-17-20.6-28.6-38.4-28.6L408 80c-13.3 0-24-10.7-24-24s10.7-24 24-24l32.2 0c39 0 73.3 25.6 84.4 63l47.8 161.3c2.4 8.1 3.6 16.5 3.6 25L576 384c0 53-43 96-96 96l-64 0c-53 0-96-43-96-96l0-48-64 0 0 48c0 53-43 96-96 96l-64 0c-53 0-96-43-96-96L0 281.3c0-8.5 1.2-16.9 3.6-25L51.4 95c11.1-37.4 45.4-63 84.4-63L168 32c13.3 0 24 10.7 24 24s-10.7 24-24 24l-32.2 0zM486.5 304l-118.5 0 0 80c0 5.2 .8 10.3 2.4 15l116.1-95zM528 332.1l-121.1 99c2.9 .6 6 .9 9.1 .9l64 0c26.5 0 48-21.5 48-48l0-51.9zM48 304l0 80c0 5.2 .8 10.3 2.4 15L166.5 304 48 304zM96 432l64 0c26.5 0 48-21.5 48-48l0-51.9-121.1 99c2.9 .6 6 .9 9.1 .9z"]],
    "cloud-check": [576, 512, [], "e35c", ["M48 336c0 53 43 96 96 96l304 0c44.2 0 80-35.8 80-80 0-37.5-25.8-69-60.6-77.7-7.5-1.9-13.6-7.2-16.5-14.3s-2.1-15.3 2-21.8c7-11.2 11.2-24.2 11.2-38.2 0-39.8-32.2-72-72-72-11 0-21.4 2.5-30.8 7-10.5 5-23.1 1.7-29.9-7.8-20.3-28.6-53.7-47.2-91.3-47.2-61.9 0-112 50.1-112 112 0 8.4 1 16.6 2.7 24.5 2.7 12.1-4.3 24.3-16.1 28.1-38.7 12.4-66.6 48.7-66.6 91.4zm150.8-10.5c-9.2-9.5-9-24.7 .6-33.9s24.7-8.9 33.9 .6l26.5 27.4 85.6-117.7c7.8-10.7 22.8-13.1 33.5-5.3s13.1 22.8 5.3 33.5L281.8 370.9c-4.2 5.7-10.7 9.4-17.8 9.8s-14-2.2-18.9-7.3l-46.4-48z", "M240 32c47.1 0 89.4 20.4 118.7 52.8 10.6-3.1 21.8-4.8 33.3-4.8 66.3 0 120 53.7 120 120 0 13.3-2.3 26-6.2 37.8 41.7 21.1 70.2 64.2 70.2 114.2 0 70.7-57.3 128-128 128l-304 0c-79.5 0-144-64.5-144-144 0-56.8 32.9-105.9 80.7-129.3-.4-4.8-.7-9.7-.7-14.7 0-88.4 71.6-160 160-160zm0 48c-61.9 0-112 50.1-112 112 0 8.4 1 16.6 2.7 24.5 2.7 12.1-4.3 24.3-16.1 28.1-38.7 12.4-66.6 48.7-66.6 91.4 0 53 43 96 96 96l304 0c44.2 0 80-35.8 80-80 0-37.5-25.8-69-60.6-77.7-7.5-1.9-13.6-7.2-16.5-14.3s-2.1-15.3 2-21.8c7-11.2 11.2-24.2 11.2-38.2 0-39.8-32.2-72-72-72-11 0-21.4 2.5-30.8 7-10.5 5-23.1 1.7-29.9-7.8-20.3-28.6-53.7-47.2-91.3-47.2zM345.4 201.9c7.8-10.7 22.8-13.1 33.5-5.3s13.1 22.8 5.3 33.5L281.8 370.9c-4.2 5.7-10.7 9.4-17.8 9.8s-14-2.2-18.9-7.3l-46.4-48c-9.2-9.5-9-24.7 .6-33.9s24.7-8.9 33.9 .6l26.5 27.4 85.6-117.7z"]],
    "message-minus": [512, 512, ["comment-alt-minus"], "f4a7", ["M48 128l0 224c0 26.5 21.5 48 48 48l56 0c10.4 0 19.3 6.6 22.6 15.9 .9 2.5 1.4 5.2 1.4 8.1l0 49.7c32.7-23.1 63.3-44.7 91.9-64.9 8.1-5.7 17.8-8.8 27.7-8.8L416 400c26.5 0 48-21.5 48-48l0-224c0-26.5-21.5-48-48-48L96 80c-26.5 0-48 21.5-48 48zM160 240c0-13.3 10.7-24 24-24l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24z", "M203.7 512.9l0 0 91.9-64.9 120.4 0c53 0 96-43 96-96l0-224c0-53-43-96-96-96L96 32C43 32 0 75 0 128L0 352c0 53 43 96 96 96l32 0 0 72c0 9 5 17.2 13 21.3s17.6 3.5 24.9-1.7l37.8-26.7zM295.6 400c-9.9 0-19.6 3.1-27.7 8.8-28.6 20.2-59.3 41.8-91.9 64.9l0-49.7c0-2.8-.5-5.6-1.4-8.1-3.3-9.3-12.2-15.9-22.6-15.9l-56 0c-26.5 0-48-21.5-48-48l0-224c0-26.5 21.5-48 48-48l320 0c26.5 0 48 21.5 48 48l0 224c0 26.5-21.5 48-48 48l-120.4 0zM184 216c-13.3 0-24 10.7-24 24s10.7 24 24 24l144 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-144 0z"]],
    "face-clouds": [640, 512, [], "e47d", ["M112 256c0-16.5 1.9-32.6 5.6-48l94.7 0c-2.7 4.7-4.3 10.2-4.3 16 0 17.7 14.3 32 32 32s32-14.3 32-32c0-8.1-3-15.4-7.9-21 41.7-13.5 71.9-52.7 71.9-99 0-20.6-6-39.8-16.3-56l.3 0c114.9 0 208 93.1 208 208 0 5.5-.2 10.9-.6 16.3-2.4-.2-4.9-.3-7.4-.3-6 0-11.9 .5-17.7 1.5-20.1-18.4-46.1-30.5-74.9-33 2.9-4.8 4.6-10.5 4.6-16.5 0-17.7-14.3-32-32-32s-32 14.3-32 32c0 8.6 3.4 16.4 8.9 22.1-50.3 16.2-87.1 62.6-88.8 117.9-25.5 20.4-43 50.3-47.1 84.4-75.7-31.1-128.9-105.6-128.9-192.4z", "M222.4 32l1.6 0c35.3 0 64 28.7 64 64s-28.7 64-64 64L64 160C28.7 160 0 131.3 0 96S28.7 32 64 32l1.6 0C73-4.5 105.3-32 144-32s71 27.5 78.4 64zM64 256c0-16.4 1.5-32.5 4.5-48.1 1.2 0 2.3 .1 3.5 .1l45.6 0c-3.6 15.4-5.6 31.5-5.6 48 0 86.9 53.3 161.3 128.9 192.4-.6 5.1-.9 10.3-.9 15.6 0 12.9 1.9 25.3 5.4 37-105-31.9-181.4-129.5-181.4-245zM320 48l-.3 0c-12.5-19.5-31.3-34.6-53.6-42.3 17.4-3.7 35.5-5.7 54-5.7 141.4 0 256 114.6 256 256 0 10.6-.6 21-1.9 31.2-13.8-8.4-29.7-13.7-46.7-14.9 .4-5.4 .6-10.8 .6-16.3 0-114.9-93.1-208-208-208zM208 224a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm160 0a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM640 464c0 44.2-35.8 80-80 80l-192 0c-44.2 0-80-35.8-80-80 0-33.9 21.1-62.9 50.9-74.5-1.9-6.8-2.9-14-2.9-21.5 0-44.2 35.8-80 80-80 30.8 0 57.5 17.4 70.9 42.8 9.3-6.8 20.7-10.8 33.1-10.8 30.9 0 56 25.1 56 56 0 3.2-.3 6.4-.8 9.4 36.9 7.1 64.8 39.6 64.8 78.6z"]],
    "left-long-to-line": [640, 512, [], "e41e", ["M182.6 256l89.4 89.4 0-33.4c0-13.3 10.7-24 24-24l296 0 0-64-296 0c-13.3 0-24-10.7-24-24l0-33.4-89.4 89.4z", "M0 120c0-13.3 10.7-24 24-24s24 10.7 24 24l0 272c0 13.3-10.7 24-24 24S0 405.3 0 392L0 120zm272 46.6L182.6 256 272 345.4 272 312c0-13.3 10.7-24 24-24l296 0 0-64-296 0c-13.3 0-24-10.7-24-24l0-33.4zm-134.6 112c-12.5-12.5-12.5-32.8 0-45.3l128-128c9.2-9.2 22.9-11.9 34.9-6.9l0 0c12 5 19.8 16.6 19.8 29.6l0 48 272 0c26.5 0 48 21.5 48 48l0 64c0 26.5-21.5 48-48 48l-272 0 0 48c0 12.9-7.8 24.6-19.8 29.6l0 0c-12 5-25.7 2.2-34.9-6.9l-128-128z"]],
    "plane-landing-gear": [576, 512, [], "e7bc", ["M52.8 208l17.3 95.2c3.5 19 20 32.8 39.4 32.8L496 336c17.7 0 32-14.3 32-32s-14.3-32-32-32l-103.7 0c-6.6 0-12.8-2.7-17.3-7.4l-161.3-168.6-28 0 50.1 144.1c2.6 7.3 1.4 15.5-3.1 21.8S221 272 213.2 272l-86.7 0c-6.5 0-12.7-2.6-17.2-7.2l-55.5-56.8-1.1 0z", "M528 304c0-17.7-14.3-32-32-32l-103.7 0c-6.6 0-12.8-2.7-17.3-7.4l-161.3-168.6-28 0 50.1 144.1c2.6 7.3 1.4 15.5-3.1 21.8S221 272 213.2 272l-86.7 0c-6.5 0-12.7-2.6-17.2-7.2l-55.5-56.8-1.1 0 17.3 95.2c3.5 19 20 32.8 39.4 32.8L496 336c17.7 0 32-14.3 32-32zm-32-80c44.2 0 80 35.8 80 80s-35.8 80-80 80l-386.6 0c-42.5 0-79-30.4-86.6-72.3L.4 188.3c-1.3-7 .6-14.2 5.2-19.7S16.9 160 24 160l40 0c6.5 0 12.7 2.6 17.2 7.2l55.5 56.8 42.8 0-50.1-144.1c-2.6-7.3-1.4-15.5 3.1-21.8S144.2 48 152 48l72 0c6.6 0 12.8 2.7 17.3 7.4L402.6 224 496 224zM192 448a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm192-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]],
    "calendar-check": [448, 512, [], "f274", ["M48 128l0 288c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-288c0-8.8-7.2-16-16-16L64 112c-8.8 0-16 7.2-16 16zm71.1 159.1c9.4-9.4 24.6-9.4 33.9 0l36 36 105.6-145.2c7.8-10.7 22.8-13.1 33.5-5.3 10.7 7.8 13.1 22.8 5.3 33.5L211.4 374.1c-4.1 5.7-10.5 9.3-17.5 9.8-7 .5-13.9-2-18.8-6.9l-55.9-55.9c-9.4-9.4-9.4-24.6 0-33.9z", "M328 0c13.3 0 24 10.7 24 24l0 40 32 0c35.3 0 64 28.7 64 64l0 288c0 33.1-25.2 60.4-57.5 63.7l-6.5 .3-320 0-6.5-.3c-30.1-3.1-54.1-27-57.1-57.1L0 416 0 128C0 92.7 28.7 64 64 64l32 0 0-40c0-13.3 10.7-24 24-24s24 10.7 24 24l0 40 160 0 0-40c0-13.3 10.7-24 24-24zM64 112c-8.8 0-16 7.2-16 16l0 288c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-288c0-8.8-7.2-16-16-16L64 112zm230.7 65.9c7.8-10.7 22.8-13.1 33.5-5.3 10.7 7.8 13.1 22.8 5.3 33.5L211.4 374.1c-4.1 5.7-10.5 9.3-17.5 9.8-7 .5-13.9-2-18.8-6.9l-55.9-55.9c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l36 36 105.6-145.2z"]],
    "square-ring": [448, 512, [], "e44f", ["M48 96l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16zM352 256a128 128 0 1 1 -256 0 128 128 0 1 1 256 0z", "M64 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM304 256a80 80 0 1 0 -160 0 80 80 0 1 0 160 0zM96 256a128 128 0 1 1 256 0 128 128 0 1 1 -256 0z"]],
    "face-kiss": [512, 512, [128535, "kiss"], "f596", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm160-48a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm16 64c0-8.8 7.2-16 16-16l32 0c26.5 0 48 21.5 48 48 0 12.3-4.6 23.5-12.2 32 7.6 8.5 12.2 19.7 12.2 32 0 26.5-21.5 48-48 48l-32 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0c-8.8 0-16-7.2-16-16zm144-64a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M464 256a208 208 0 1 0 -416 0 208 208 0 1 0 416 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm240 0l32 0c26.5 0 48 21.5 48 48 0 12.3-4.6 23.5-12.2 32 7.6 8.5 12.2 19.7 12.2 32 0 26.5-21.5 48-48 48l-32 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zm-96-48a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm192-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]],
    "circle-video": [512, 512, ["video-circle"], "e12b", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm80-64c0-17.7 14.3-32 32-32l128 0c17.7 0 32 14.3 32 32l0 38.4 61-36.6c1.9-1.2 4.2-1.8 6.4-1.8 6.9 0 12.5 5.6 12.5 12.5l0 102.9c0 6.9-5.6 12.5-12.5 12.5-2.3 0-4.5-.6-6.4-1.8l-61-36.6 0 38.4c0 17.7-14.3 32-32 32l-128 0c-17.7 0-32-14.3-32-32l0-128z", "M464 256a208 208 0 1 0 -416 0 208 208 0 1 0 416 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm128-64c0-17.7 14.3-32 32-32l128 0c17.7 0 32 14.3 32 32l0 38.4 61-36.6c1.9-1.2 4.2-1.8 6.4-1.8 6.9 0 12.5 5.6 12.5 12.5l0 102.9c0 6.9-5.6 12.5-12.5 12.5-2.3 0-4.5-.6-6.4-1.8l-61-36.6 0 38.4c0 17.7-14.3 32-32 32l-128 0c-17.7 0-32-14.3-32-32l0-128z"]],
    "cart-shopping-fast": [640, 512, [], "e0dc", ["M197.5 80l29.1 160 288.6 0c19.2 0 35.7-13.6 39.3-32.4L578.9 80 197.5 80z", "M88-16C74.7-16 64-5.3 64 8S74.7 32 88 32l45.3 0c3.9 0 7.2 2.8 7.9 6.6l52.1 286.3c6.2 34.2 36 59.1 70.8 59.1L520 384c13.3 0 24-10.7 24-24s-10.7-24-24-24l-255.9 0c-11.6 0-21.5-8.3-23.6-19.7l-5.1-28.3 279.8 0c42.2 0 78.4-29.9 86.4-71.4L627.9 79.6C632.7 54.9 613.8 32 588.6 32l-399.9 0-.4-2c-4.8-26.6-28-46-55.1-46L88-16zM515.1 240l-288.6 0-29.1-160 381.5 0-24.5 127.6c-3.6 18.8-20.1 32.4-39.3 32.4zM320 464a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zm224 0a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM24 96C10.7 96 0 106.7 0 120s10.7 24 24 24l64 0c13.3 0 24-10.7 24-24S101.3 96 88 96L24 96zm0 96c-13.3 0-24 10.7-24 24s10.7 24 24 24l80 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0zm0 96c-13.3 0-24 10.7-24 24s10.7 24 24 24l96 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-96 0z"]],
    "desktop-arrow-down": [512, 512, [], "e155", ["M48 96c0-8.8 7.2-16 16-16l112 0 0-48 56 0 0 110.1-15-15c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l56 56c9.4 9.4 24.6 9.4 33.9 0l56-56c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-15 15 0-110.1 56 0 0 48 112 0c8.8 0 16 7.2 16 16l0 176-416 0 0-176zM220.3 464l8-48 55.3 0 8 48-71.3 0z", "M280 24l0 118.1 15-15c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-56 56c-9.4 9.4-24.6 9.4-33.9 0l-56-56c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l15 15 0-118.1c0-13.3 10.7-24 24-24s24 10.7 24 24zM64 32l112 0 0 48-112 0c-8.8 0-16 7.2-16 16l0 176 416 0 0-176c0-8.8-7.2-16-16-16l-112 0 0-48 112 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64l-115.7 0 8 48 51.7 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-272 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l51.7 0 8-48-115.7 0c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32zM464 352l0-32-416 0 0 32c0 8.8 7.2 16 16 16l384 0c8.8 0 16-7.2 16-16zM220.3 464l71.3 0-8-48-55.3 0-8 48z"]],
    "banjo": [512, 512, [129685], "f8a3", ["M64 320a128 128 0 1 0 256 0 128 128 0 1 0 -256 0zm55-9c9.4-9.4 24.6-9.4 33.9 0l48 48c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-48-48c-9.4-9.4-9.4-24.6 0-33.9z", "M465 7c-9.4-9.4-24.6-9.4-33.9 0L383 55c-2.4 2.4-4.3 5.3-5.5 8.5l-22.2 59.1-62.7 62.7c-22-16.5-48.1-27.7-76.6-31.7 0-13.7-9.6-25.7-24-25.7s-24 12-24 25.7c-28.5 4.1-54.6 15.3-76.6 31.7-9.7-9.7-25-11.4-35.2-1.2s-8.5 25.5 1.2 35.2C41 241.4 29.8 267.5 25.7 296 12 296 0 305.6 0 320s12 24 25.7 24c4.1 28.5 15.3 54.6 31.7 76.6-9.7 9.7-11.4 25-1.2 35.2s25.5 8.5 35.2-1.2c22 16.5 48.2 27.7 76.6 31.7 0 13.7 9.6 25.7 24 25.7s24-12 24-25.7c28.5-4.1 54.6-15.3 76.6-31.7 9.7 9.7 25 11.4 35.2 1.2s8.5-25.5-1.2-35.2c16.5-22 27.7-48.2 31.7-76.6 13.7 0 25.7-9.6 25.7-24s-12-24-25.7-24c-4.1-28.5-15.3-54.6-31.7-76.6l62.7-62.7 59.1-22.2c3.2-1.2 6.1-3.1 8.5-5.5l48-48c9.4-9.4 9.4-24.6 0-33.9L465 7zM119 311c-9.4 9.4-9.4 24.6 0 33.9l48 48c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-48-48c-9.4-9.4-24.6-9.4-33.9 0zm73-119a128 128 0 1 1 0 256 128 128 0 1 1 0-256z"]],
    "cloud-hail-mixed": [512, 512, [], "f73a", ["M48 216c0 30.9 25.1 56 56 56l304 0c30.9 0 56-25.1 56-56s-25.1-56-56-56c-13.3 0-24-10.7-24-24 0-30.9-25.1-56-56-56-15.6 0-29.6 6.3-39.8 16.6-5.5 5.6-13.4 8.1-21.2 6.8s-14.3-6.4-17.6-13.6c-11.4-24.7-36.4-41.8-65.4-41.8-39.8 0-72 32.2-72 72 0 4.5 .4 8.8 1.2 13 2.4 13-6.3 25.5-19.3 27.9-26.1 4.8-45.9 27.6-45.9 55.1z", "M112 120c0-39.8 32.2-72 72-72 28.9 0 53.9 17.1 65.4 41.8 3.3 7.1 9.9 12.2 17.6 13.6s15.7-1.2 21.2-6.8c10.2-10.3 24.2-16.6 39.8-16.6 30.9 0 56 25.1 56 56 0 13.3 10.7 24 24 24 30.9 0 56 25.1 56 56s-25.1 56-56 56l-304 0c-30.9 0-56-25.1-56-56 0-27.4 19.8-50.3 45.9-55.1 13-2.4 21.7-14.9 19.3-27.9-.8-4.2-1.2-8.5-1.2-13zM184 0C117.7 0 64 53.7 64 120 26.4 135.7 0 172.7 0 216 0 273.4 46.6 320 104 320l304 0c57.4 0 104-46.6 104-104 0-50-35.3-91.7-82.3-101.7-10-47-51.7-82.3-101.7-82.3-18.3 0-35.4 4.7-50.3 13-22-27.4-55.7-45-93.7-45zM102.8 399.6c4.2-12.6-2.6-26.2-15.2-30.4s-26.2 2.6-30.4 15.2l-8 24C45 421 51.8 434.6 64.4 438.8s26.2-2.6 30.4-15.2l8-24zm120 0c4.2-12.6-2.6-26.2-15.2-30.4s-26.2 2.6-30.4 15.2l-32 96c-4.2 12.6 2.6 26.2 15.2 30.4s26.2-2.6 30.4-15.2l32-96zm112 0c4.2-12.6-2.6-26.2-15.2-30.4s-26.2 2.6-30.4 15.2l-8 24c-4.2 12.6 2.6 26.2 15.2 30.4s26.2-2.6 30.4-15.2l8-24zm120 0c4.2-12.6-2.6-26.2-15.2-30.4s-26.2 2.6-30.4 15.2l-32 96c-4.2 12.6 2.6 26.2 15.2 30.4s26.2-2.6 30.4-15.2l32-96zM72 488a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm208 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]],
    "square-half-stroke": [448, 512, [], "e793", ["M48 96l0 320c0 8.8 7.2 16 16 16l136 0 0-352-136 0c-8.8 0-16 7.2-16 16z", "M248 80l0 352 136 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L248 80zm-48 0L64 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l136 0 0-352zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96z"]],
    "kitchen-set": [576, 512, [], "e51a", ["M48 144a96 96 0 1 0 192 0 96 96 0 1 0 -192 0zm160 0a64 64 0 1 1 -128 0 64 64 0 1 1 128 0zM336 320l0 144 128 0 0-144-128 0zm64-192l0 32 96 0 0-32-96 0z", "M240 144a96 96 0 1 0 -192 0 96 96 0 1 0 192 0zm46 24c-11.4 68.1-70.7 120-142 120-79.5 0-144-64.5-144-144S64.5 0 144 0c71.4 0 130.6 51.9 142 120l66.7 0c3.8-22.7 23.6-40 47.3-40l96 0c26.5 0 48 21.5 48 48l0 32c0 26.5-21.5 48-48 48l-96 0c-23.8 0-43.5-17.3-47.3-40L286 168zM80 144a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zM376 264c0-13.3 10.7-24 24-24s24 10.7 24 24l0 8 96 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-8 0 0 144c0 26.5-21.5 48-48 48l-128 0c-26.5 0-48-21.5-48-48l0-144-8 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l96 0 0-8zm-40 56l0 144 128 0 0-144-128 0zM32 336c0-8.8 7.2-16 16-16l128 0c26.5 0 48 21.5 48 48s-21.5 48-48 48l-16 0c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-80zm128 48l16 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0 0 32zM0 488c0-13.3 10.7-24 24-24l176 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 512c-13.3 0-24-10.7-24-24zM400 128l0 32 96 0 0-32-96 0z"]],
    "dna": [384, 512, [129516], "f471", ["M59.7 80c7 16.4 17 32.3 29.4 48l205.8 0c12.4-15.7 22.4-31.6 29.4-48L59.7 80zm0 352l264.5 0c-7-16.4-17-32.3-29.4-48L89.1 384c-12.4 15.7-22.4 31.6-29.4 48zm74.8-256c17.8 16.4 37.2 32.6 57.5 49.1 20.3-16.5 39.7-32.7 57.5-49.1l-115 0zm0 160l115 0c-17.8-16.4-37.2-32.6-57.5-49.1-20.3 16.5-39.7 32.7-57.5 49.1z", "M360 0c13.3 0 24 10.7 24 24 0 55.6-24.5 101.9-58.1 141.9-27.2 32.4-61.5 62-95.8 90.1 34.3 28.1 68.6 57.7 95.8 90.1 33.6 40 58.1 86.3 58.1 141.9 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-2.7-.1-5.4-.2-8L48.2 480c-.2 2.6-.2 5.3-.2 8 0 13.3-10.7 24-24 24S0 501.3 0 488c0-55.6 24.5-101.9 58.1-141.9 27.2-32.4 61.5-62 95.8-90.1-34.3-28.1-68.6-57.7-95.8-90.1-33.6-40-58.1-86.3-58.1-141.9 0-13.3 10.7-24 24-24S48 10.7 48 24c0 2.7 .1 5.4 .2 8l287.5 0c.2-2.6 .2-5.3 .2-8 0-13.3 10.7-24 24-24zM324.3 80L59.7 80c7 16.4 17 32.3 29.4 48l205.8 0c12.4-15.7 22.4-31.6 29.4-48zm-74.8 96l-115 0c17.8 16.4 37.2 32.6 57.5 49.1 20.3-16.5 39.7-32.7 57.5-49.1zM59.7 432l264.5 0c-7-16.4-17-32.3-29.4-48L89.1 384c-12.4 15.7-22.4 31.6-29.4 48zm74.8-96l115 0c-17.8-16.4-37.2-32.6-57.5-49.1-20.3 16.5-39.7 32.7-57.5 49.1z"]],
    "circle-bangladeshi-taka": [512, 512, [], "e701", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm88.5-108.7c2.6-13 15.2-21.4 28.2-18.8l10.6 2.1c28.3 5.7 48.7 30.5 48.7 59.4l0 18 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0 0 83.4c0 6.9 5.6 12.6 12.6 12.6l24 0c37.2 0 67.4-30.2 67.4-67.4l0-16c0-6.9-5.6-12.6-12.6-12.6l-3.4 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l3.4 0c33.5 0 60.6 27.1 60.6 60.6l0 16C376 332.3 324.3 384 260.6 384l-24 0c-33.5 0-60.6-27.1-60.6-60.6l0-83.4-13.7 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l13.7 0 0-18c0-6-4.2-11.2-10.1-12.3l-10.6-2.1c-13-2.6-21.4-15.2-18.8-28.2z", "M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM136.5 147.3c-2.6 13 5.8 25.6 18.8 28.2l10.6 2.1c5.9 1.2 10.1 6.3 10.1 12.3l0 18-13.7 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l13.7 0 0 83.4c0 33.5 27.1 60.6 60.6 60.6l24 0C324.3 384 376 332.3 376 268.6l0-16c0-33.5-27.1-60.6-60.6-60.6l-3.4 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l3.4 0c6.9 0 12.6 5.6 12.6 12.6l0 16c0 37.2-30.2 67.4-67.4 67.4l-24 0c-6.9 0-12.6-5.6-12.6-12.6l0-83.4 16 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0 0-18c0-28.9-20.4-53.7-48.7-59.4l-10.6-2.1c-13-2.6-25.6 5.8-28.2 18.8z"]],
    "box-circle-check": [576, 512, [], "e0c4", ["M80 176l352 0 0 32c-106 0-192 86-192 192 0 10.9 .9 21.6 2.7 32L96 432c-8.8 0-16-7.2-16-16l0-240zm11-48l40.9-57.3c3-4.2 7.9-6.7 13-6.7l87.1 0 0 64-141 0zM280 64l87.1 0c5.2 0 10 2.5 13 6.7l40.9 57.3-141 0 0-64z", "M432 176l-352 0 0 240c0 8.8 7.2 16 16 16l146.7 0c2.8 16.8 7.8 32.9 14.8 48L96 480c-35.3 0-64-28.7-64-64l0-267.5c0-13.3 4.2-26.3 11.9-37.2L92.9 42.8C104.9 26 124.3 16 144.9 16l222.1 0c20.7 0 40.1 10 52.1 26.8l48.9 68.5c7.8 10.9 11.9 23.9 11.9 37.2l0 65.5c-15.3-3.9-31.4-6-48-6l0-32zm-11-48L380.1 70.7c-3-4.2-7.9-6.7-13-6.7l-87.1 0 0 64 141 0zm-189 0l0-64-87.1 0c-5.2 0-10 2.5-13 6.7L91 128 232 128zm56 272a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm201.4-60.9c-7.1-5.2-17.2-3.6-22.4 3.5l-53 72.9-26.8-26.8c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l40 40c3.3 3.3 7.9 5 12.6 4.6s8.9-2.8 11.7-6.5l64-88c5.2-7.1 3.6-17.2-3.5-22.3z"]],
    "trillium": [512, 512, [], "e588", ["M60.5 363.2c15.9 4.4 39.3 9.8 64.3 11.8 30.7 2.4 60.3-.6 81.9-13l4.5-2.8c10.2-7 18.2-16.1 23.5-26.5l1.7-2.8c4.5-6.3 11.8-10.2 19.6-10.2 9 0 17.2 5 21.3 13 6.1 11.9 15.5 22.2 28 29.4l4.1 2.2c21.1 10.6 49 13.1 77.8 10.8 25-2 48.4-7.4 64.3-11.8-4.2-16-11.2-38.9-22-61.6-12.4-26.1-28.5-48.9-48.2-61.9l-4-2.5c-11.3-6.5-23.6-9.6-35.7-9.7-8.3 0-16.1-4.4-20.4-11.5s-4.7-16-.9-23.4c5-9.8 7.8-20.8 7.8-32.6l-.1-4.7c-1.4-23.6-13.2-48.9-29.5-72.7-14.2-20.7-30.6-38.3-42.3-49.9-11.8 11.6-28.1 29.2-42.3 49.9-17.4 25.4-29.7 52.5-29.7 77.4 0 11.8 2.8 22.9 7.8 32.6 3.8 7.4 3.4 16.3-.9 23.4s-12.1 11.5-20.4 11.5c-10.6 0-21.4 2.4-31.6 7.4l-4.3 2.3c-21.5 12.4-38.9 36.6-52.2 64.4-10.8 22.7-17.8 45.6-22 61.6zM296.2 240a40 40 0 1 1 -80 0 40 40 0 1 1 80 0z", "M232.8-11.1c13.8-10.7 33-10.7 46.8 0l2.9 2.4 11.4 11.1c12.8 13 29.4 31.4 44.3 53 5.3 7.7 10.5 16.1 15.3 25 13-.8 25.7-.5 37.6 .4 26.2 2 50.4 7.2 68.1 11.8L474.4 97c19.5 5.9 30.9 25.7 26.3 45.5l-3.9 15.4c-4.8 17.6-12.5 41.1-23.8 64.8-4.6 9.5-9.9 19.4-16.1 29 6.1 9.7 11.5 19.5 16.1 29.1 15.1 31.6 23.7 63 27.7 80.2l.7 3.7c2.3 17.3-7.3 33.9-23.4 40.6l-3.6 1.3c-16.9 5.1-48.4 13.4-83.3 16.1-12 .9-24.8 1.2-37.9 .4-4.8 8.9-10 17.3-15.3 25.1-19.8 28.9-42.7 52-55.6 64.1l-2.9 2.4c-13.8 10.7-33 10.6-46.8 0l-2.9-2.4-11.4-11.1c-12.8-12.9-29.4-31.4-44.3-53-5.3-7.8-10.5-16.2-15.3-25.1-13 .8-25.7 .6-37.6-.3-26.2-2-50.4-7.2-68.1-11.8l-15.3-4.3c-19.5-5.9-30.9-25.7-26.3-45.5l3.9-15.4c4.8-17.6 12.5-41.1 23.8-64.8 4.6-9.5 9.9-19.4 16.1-29.1-6.2-9.6-11.5-19.5-16.1-29-15.1-31.6-23.7-63-27.7-80.2l-.7-3.7C8.5 121.6 18.1 105 34.3 98.3L37.8 97c16.9-5.1 48.4-13.4 83.3-16.1 12-.9 24.8-1.2 37.8-.4 4.8-8.9 10.1-17.3 15.4-25.1 19.8-28.9 42.7-52 55.6-64.1l2.9-2.4zm23.3 394.9c-5.4 5.4-11.3 10.5-17.8 14.9l-7.5 4.7c-7.1 4.1-14.5 7.3-22.1 10 1.6 2.5 3.3 5.1 5 7.6 14.2 20.7 30.6 38.3 42.3 49.9 11.8-11.6 28.1-29.2 42.3-49.9 1.7-2.5 3.4-5.1 5-7.6-5.2-1.9-10.4-4-15.4-6.5l-6.5-3.5c-9.5-5.5-18-12.2-25.4-19.7zm.1-351.1c-11.8 11.6-28.1 29.2-42.3 49.9-17.4 25.4-29.7 52.5-29.7 77.4 0 11.8 2.8 22.9 7.8 32.6 3.8 7.4 3.4 16.3-.9 23.4s-12.1 11.5-20.4 11.5c-10.6 0-21.4 2.4-31.6 7.4l-4.3 2.3c-21.5 12.4-38.9 36.6-52.2 64.4-10.8 22.7-17.8 45.6-22 61.6 15.9 4.4 39.3 9.8 64.3 11.8 30.7 2.4 60.3-.6 81.9-13l4.5-2.8c10.2-7 18.2-16.1 23.5-26.5l1.7-2.8c4.5-6.3 11.8-10.2 19.6-10.2 9 0 17.2 5 21.3 13 6.1 11.9 15.5 22.2 28 29.4l4.1 2.2c21.1 10.6 49 13.1 77.8 10.8 25-2 48.4-7.4 64.3-11.8-4.2-16-11.2-38.9-22-61.6-12.4-26.1-28.5-48.9-48.2-61.9l-4-2.5c-11.3-6.5-23.6-9.6-35.7-9.7-8.3 0-16.1-4.4-20.4-11.5s-4.7-16-.9-23.4c5-9.8 7.8-20.8 7.8-32.6l-.1-4.7c-1.4-23.6-13.2-48.9-29.5-72.7-14.2-20.7-30.6-38.3-42.3-49.9zm0 247.3a40 40 0 1 1 0-80 40 40 0 1 1 0 80zm116-151.9c2.5 10.4 4 21 4 31.9l-.2 7.3c-.3 5.7-1.1 11.2-2.2 16.7 9.5 2.7 18.8 6.5 27.7 11.7l6.2 3.8c5.9 3.9 11.5 8.3 16.7 13 1.8-3.4 3.6-6.8 5.3-10.3 10.8-22.6 17.8-45.6 22-61.6-15.9-4.4-39.3-9.8-64.3-11.8-5.1-.4-10.1-.6-15.1-.7zm-232.1 0c-5 .1-10.1 .3-15.2 .7-25 2-48.4 7.4-64.3 11.8 4.2 16 11.2 38.9 22 61.6 1.7 3.5 3.4 6.9 5.2 10.3 7-6.3 14.7-12 23-16.8l7.2-3.8c6.7-3.3 13.7-5.9 20.7-7.9-1.6-7.7-2.4-15.7-2.4-23.9 0-10.9 1.4-21.5 3.9-31.9z"]],
    "delete-right": [640, 512, [], "e154", ["M112 128c0-8.8 7.2-16 16-16l306.7 0c4.2 0 8.3 1.7 11.3 4.7L585.4 256 446.1 395.3c-3 3-7.1 4.7-11.3 4.7L128 400c-8.8 0-16-7.2-16-16l0-256zm108.1 60.1c-9.4 9.4-9.4 24.6 0 33.9l33.9 33.9-33.9 33.9c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l33.9-33.9 33.9 33.9c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-33.9-33.9 33.9-33.9c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-33.9 33.9-33.9-33.9c-9.4-9.4-24.6-9.4-33.9 0z", "M434.7 64c17 0 33.3 6.7 45.3 18.7L630.6 233.4c6 6 9.4 14.1 9.4 22.6s-3.4 16.6-9.4 22.6L480 429.3c-12 12-28.3 18.7-45.3 18.7L128 448c-35.3 0-64-28.7-64-64l0-256c0-35.3 28.7-64 64-64l306.7 0zM112 128l0 256c0 8.8 7.2 16 16 16l306.7 0c4.2 0 8.3-1.7 11.3-4.7L585.4 256 446.1 116.7c-3-3-7.1-4.7-11.3-4.7L128 112c-8.8 0-16 7.2-16 16zm243.9 60.1c9.4 9.4 9.4 24.6 0 33.9l-33.9 33.9 33.9 33.9c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-33.9-33.9-33.9 33.9c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l33.9-33.9-33.9-33.9c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l33.9 33.9 33.9-33.9c9.4-9.4 24.6-9.4 33.9 0z"]],
    "circle-colon": [512, 512, [], "e6fc", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm80 0c0-65.8 49.7-120 113.5-127.2l7.3-21.9c2.8-8.4 11.9-12.9 20.2-10.1s12.9 11.9 10.1 20.2l-4.1 12.4c9.7 1.4 19 4 27.8 7.4l10-29.9c2.8-8.4 11.9-12.9 20.2-10.1s12.9 11.9 10.1 20.2l-11.8 35.5c4.4 3.2 8.6 6.7 12.5 10.4 9.6 9.1 10.1 24.3 1 33.9-7.8 8.3-20.2 9.8-29.6 4.2L270.6 334.7c15.4-2.8 29.3-10.1 40.3-20.5 9.6-9.1 24.8-8.7 33.9 1s8.7 24.8-1 33.9c-22.9 21.6-53.9 34.9-87.9 34.9-.6 0-1.2 0-1.8 0l-7 21.1c-2.8 8.4-11.9 12.9-20.2 10.1s-12.9-11.9-10.1-20.2l5.2-15.5c-9.4-2.6-18.3-6.2-26.7-10.7l-12.1 36.3c-2.8 8.4-11.9 12.9-20.2 10.1s-12.9-11.9-10.1-20.2l15.3-45.9C143.4 325.7 128 292.7 128 256zm48 0c0 14.2 3.7 27.5 10.1 39l37.4-112.1c-28 12.5-47.5 40.5-47.5 73.1zM210.9 322c7.9 5.4 16.8 9.4 26.4 11.7l50.4-151.3c-8.7-3.7-18.2-6-28.1-6.4L210.9 322z", "M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm23.2-394.9c2.8-8.4-1.7-17.4-10.1-20.2s-17.4 1.7-20.2 10.1l-7.3 21.9c-63.9 7.2-113.5 61.4-113.5 127.2 0 36.7 15.4 69.7 40.1 93.1l-15.3 45.9c-2.8 8.4 1.7 17.4 10.1 20.2s17.4-1.7 20.2-10.1l12.1-36.3c8.4 4.5 17.3 8.1 26.7 10.7l-5.2 15.5c-2.8 8.4 1.7 17.4 10.1 20.2s17.4-1.7 20.2-10.1l7-21.1c.6 0 1.2 0 1.8 0 34 0 65-13.3 87.9-34.9 9.6-9.1 10.1-24.3 1-33.9s-24.3-10.1-33.9-1c-11 10.4-24.8 17.6-40.3 20.5L315.2 201c9.4 5.6 21.8 4.1 29.6-4.2 9.1-9.6 8.7-24.8-1-33.9-3.9-3.7-8.1-7.2-12.5-10.4l11.8-35.5c2.8-8.4-1.7-17.4-10.1-20.2s-17.4 1.7-20.2 10.1l-10 29.9c-8.8-3.5-18.1-6-27.8-7.4l4.1-12.4zm8.5 65.4L237.2 333.8c-9.6-2.3-18.5-6.3-26.4-11.7l48.7-146c10 .4 19.4 2.7 28.1 6.4zm-64.1 .4L186.1 295c-6.5-11.5-10.1-24.8-10.1-39 0-32.6 19.5-60.7 47.5-73.1z"]],
    "child-reaching": [320, 512, [], "e59d", ["M128 220.9l0 115.1 64 0 0-115.2c-10.5 2.1-21.3 3.2-32.2 3.2-10.8 0-21.4-1.1-31.8-3.1zM136 72a24 24 0 1 0 48 0 24 24 0 1 0 -48 0z", "M160 48a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm0 96a72 72 0 1 0 0-144 72 72 0 1 0 0 144zm-.2 32c-41.6 0-80-22.4-100.6-58.5L44.9 92.2c-6.5-11.5-21.2-15.6-32.7-9s-15.6 21.2-9 32.7l14.4 25.3c15 26.5 36.8 47.7 62.5 62.1L80 488c0 13.3 10.7 24 24 24s24-10.7 24-24l0-104 64 0 0 104c0 13.3 10.7 24 24 24s24-10.7 24-24l0-285c25-14 46.2-34.6 61.1-60.2l15.6-26.7c6.7-11.4 2.8-26.1-8.6-32.8s-26.1-2.8-32.8 8.6l-15.6 26.7C239 154.2 200.9 176 159.8 176zM192 336l-64 0 0-115.1c10.4 2.1 21 3.1 31.8 3.1 10.9 0 21.7-1.1 32.2-3.2L192 336z"]],
    "face-confounded": [512, 512, [], "e36c", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm74.6-64.8c4.5-6.8 13.3-9.2 20.6-5.5l79.6 40c5.4 2.7 8.8 8.2 8.8 14.3s-3.4 11.6-8.8 14.3l-79.6 40c-7.3 3.6-16.1 1.3-20.6-5.5s-3.1-15.9 3.1-21.1L159 240 125.8 212.3c-6.2-5.2-7.6-14.3-3.1-21.1zM125 361.7c3.5-10.5 14.8-16.1 25.3-12.6l14.7 4.9 39.9-26.6c7.2-4.8 16.8-4.4 23.6 1l27.5 22 27.5-22c6.8-5.4 16.3-5.9 23.6-1l39.9 26.6 14.7-4.9c10.5-3.5 21.8 2.2 25.3 12.6s-2.2 21.8-12.6 25.3l-24 8c-5.9 2-12.3 1.1-17.4-2.3l-35.8-23.9-28.6 22.9c-7.3 5.8-17.7 5.8-25 0l-28.6-22.9-35.8 23.9c-5.1 3.4-11.6 4.3-17.4 2.3l-24-8c-10.5-3.5-16.1-14.8-12.6-25.3zM280.4 240c0-6 3.4-11.6 8.8-14.3l79.6-40c7.3-3.6 16.1-1.3 20.6 5.5s3.1 15.9-3.1 21.1L353 240 386.2 267.7c6.2 5.2 7.6 14.3 3.1 21.1s-13.3 9.2-20.6 5.5l-79.6-40c-5.4-2.7-8.8-8.2-8.8-14.3z", "M464 256a208 208 0 1 0 -416 0 208 208 0 1 0 416 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm228.5 72.4l27.5 22 27.5-22c6.8-5.4 16.3-5.9 23.6-1l39.9 26.6 14.7-4.9c10.5-3.5 21.8 2.2 25.3 12.6s-2.2 21.8-12.6 25.3l-24 8c-5.9 2-12.3 1.1-17.4-2.3l-35.8-23.9-28.6 22.9c-7.3 5.8-17.7 5.8-25 0l-28.6-22.9-35.8 23.9c-5.1 3.4-11.6 4.3-17.4 2.3l-24-8c-10.5-3.5-16.1-14.8-12.6-25.3s14.8-16.1 25.3-12.6l14.7 4.9 39.9-26.6c7.2-4.8 16.8-4.4 23.6 1zM122.6 191.2c4.5-6.8 13.3-9.2 20.6-5.5l79.6 40c5.4 2.7 8.8 8.2 8.8 14.3s-3.4 11.6-8.8 14.3l-79.6 40c-7.3 3.6-16.1 1.3-20.6-5.5s-3.1-15.9 3.1-21.1L159 240 125.8 212.3c-6.2-5.2-7.6-14.3-3.1-21.1zm263.6 21.1L353 240 386.2 267.7c6.2 5.2 7.6 14.3 3.1 21.1s-13.3 9.2-20.6 5.5l-79.6-40c-5.4-2.7-8.8-8.2-8.8-14.3s3.4-11.6 8.8-14.3l79.6-40c7.3-3.6 16.1-1.3 20.6 5.5s3.1 15.9-3.1 21.1z"]],
    "sidebar": [512, 512, [], "e24e", ["M224 112l0 288 224 0c8.8 0 16-7.2 16-16l0-256c0-8.8-7.2-16-16-16l-224 0z", "M0 128C0 92.7 28.7 64 64 64l384 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64L64 448c-35.3 0-64-28.7-64-64L0 128zM176 240c0-13.3-10.7-24-24-24l-80 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l80 0c13.3 0 24-10.7 24-24zm0 88c0-13.3-10.7-24-24-24l-80 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l80 0c13.3 0 24-10.7 24-24zm48 72l224 0c8.8 0 16-7.2 16-16l0-256c0-8.8-7.2-16-16-16l-224 0 0 288zM176 152c0-13.3-10.7-24-24-24l-80 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l80 0c13.3 0 24-10.7 24-24z"]],
    "paste": [512, 512, ["file-clipboard"], "f0ea", ["M272 224l0 224c0 8.8 7.2 16 16 16l160 0c8.8 0 16-7.2 16-16l0-165.5c0-4.2-1.7-8.3-4.7-11.3l-58.5-58.5c-3-3-7.1-4.7-11.3-4.7L288 208c-8.8 0-16 7.2-16 16z", "M64 48l224 0c8.8 0 16 7.2 16 16l0 48 48 0 0-48c0-35.3-28.7-64-64-64L64 0C28.7 0 0 28.7 0 64L0 384c0 35.3 28.7 64 64 64l112 0 0-48-112 0c-8.8 0-16-7.2-16-16L48 64c0-8.8 7.2-16 16-16zm176 72c0-13.3-10.7-24-24-24L104 96c-13.3 0-24 10.7-24 24s10.7 24 24 24l105.6 0c8.8-8.6 19-15.8 30.2-21.1 .1-.9 .2-1.9 .2-2.9zM448 464l-160 0c-8.8 0-16-7.2-16-16l0-224c0-8.8 7.2-16 16-16l101.5 0c4.2 0 8.3 1.7 11.3 4.7l58.5 58.5c3 3 4.7 7.1 4.7 11.3L464 448c0 8.8-7.2 16-16 16zM224 224l0 224c0 35.3 28.7 64 64 64l160 0c35.3 0 64-28.7 64-64l0-165.5c0-17-6.7-33.3-18.7-45.3l-58.5-58.5c-12-12-28.3-18.7-45.3-18.7L288 160c-35.3 0-64 28.7-64 64z"]],
    "inhaler": [640, 512, [], "f5f9", ["M272 288l0 128c0 8.8 7.2 16 16 16l178 0c7.1 0 13.4-4.7 15.4-11.5l48.5-166.3-103.4-91.9-27.4 92.5C396 265 386.6 272 376 272l-88 0c-8.8 0-16 7.2-16 16z", "M406.2 61.5c9.7-32.6 43.1-52 76.2-44.1l90.2 21.5c35.6 8.5 56.9 45 46.6 80.2L527.4 433.9c-8 27.3-33 46.1-61.4 46.1l-178 0c-35.3 0-64-28.7-64-64l0-128c0-35.3 28.7-64 64-64l70.1 0 48.1-162.5zm65.1 2.6c-8.3-2-16.6 2.9-19 11l-10.8 36.3 103.2 91.8 28.5-97.6c2.6-8.8-2.8-17.9-11.7-20L471.3 64.1zm58.6 190.1L426.4 162.3 399 254.8C396 265 386.6 272 376 272l-88 0c-8.8 0-16 7.2-16 16l0 128c0 8.8 7.2 16 16 16l178 0c7.1 0 13.4-4.7 15.4-11.5l48.5-166.3zM32 320a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM64 448a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm64-176a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM64 256a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm64 112a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]],
    "meteor": [512, 512, [9732], "f753", ["M48 307.5c0 86.1 69.8 156.5 155.6 156.5 50.2 0 97.4-24.3 126.6-65.2l116.4-163-33.5 2.6c-8.4 .6-16.5-3.2-21.4-10.1s-5.8-15.8-2.4-23.5l64.5-146.6-147 64.7c-7.7 3.4-16.6 2.5-23.5-2.4s-10.7-13-10.1-21.4l3-40.6-164.8 122.4C71.6 210.6 48 257.8 48 307.5zM312 312a112 112 0 1 1 -224 0 112 112 0 1 1 224 0z", "M474.8 0c-5.2 0-10.3 1.1-15 3.2L324 62.9 325.4 44.7c2.5-34.2-36.2-55.5-63.7-35.1L82.7 142.5C30.6 181.2 0 242.7 0 307.5 0 419.8 91 512 203.6 512 269.3 512 331 480.2 369.2 426.7L495.6 249.8c19.7-27.6-1.8-65.7-35.6-63.1l-10.7 .8 59.5-135.3c2.1-4.7 3.2-9.8 3.2-15 0-20.6-16.7-37.2-37.2-37.2zm-168 122.9l147-64.7-64.5 146.6c-3.4 7.7-2.5 16.7 2.4 23.5s13 10.7 21.4 10.1l33.5-2.6-116.4 163C301 439.7 253.8 464 203.6 464 117.8 464 48 393.6 48 307.5 48 257.8 71.6 210.6 111.4 181l164.8-122.4-3 40.6c-.6 8.4 3.2 16.5 10.1 21.4s15.8 5.8 23.5 2.4zM200 424a112 112 0 1 0 0-224 112 112 0 1 0 0 224zM176 264a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm24 96a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"]],
    "honey-pot": [448, 512, [127855], "e418", ["M48 224c0-56.5 32.6-105.5 80-129l0 41c0 13.3 10.7 24 24 24s24-10.7 24-24l0-55.1c5.3-.6 10.6-.9 16-.9l64 0c79.5 0 144 64.5 144 144L48 224zM78.6 352l290.7 0c-21.5 40.9-49 67-64.6 79.6-.4 .1-1.4 .4-3.1 .4l-155.3 0c-1.6 0-2.6-.2-3.2-.4-15.5-12.6-43.1-38.7-64.6-79.6z", "M78.6 352c21.5 40.9 49 67 64.6 79.6l.1 0c.4 .1 1.4 .4 3.1 .4l155.3 0c1.6 0 2.6-.2 3.1-.4l.1 0c15.5-12.6 43.1-38.7 64.6-79.6L78.6 352zM48 224l352 0c0-79.5-64.5-144-144-144l-64 0c-5.4 0-10.7 .3-16 .9l0 55.1c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-41c-47.4 23.6-80 72.5-80 129zM56 32l336 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-9 0c39.9 35.2 65 86.7 65 144 0 138.8-79.6 217.9-113.3 245.1-9.3 7.5-21.1 10.9-33.1 10.9l-155.3 0C134.4 480 122.6 476.7 113.3 469.1 79.6 441.9 0 362.8 0 224 0 166.7 25.1 115.2 65 80l-9 0C42.7 80 32 69.3 32 56S42.7 32 56 32z"]],
    "laptop-slash": [640, 512, [], "e1c7", ["M177.8 80l224 224 126.2 0 0-208c0-8.8-7.2-16-16-16L177.8 80zm320 320l32 32 7.8 0c22.1 0 41.1-13.1 49.6-32l-89.3 0z", "M73-24.9c-9.4-9.4-24.6-9.4-33.9 0S29.7-.3 39 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-29-29c39.7-14.1 68.1-52 68.1-96.5 0-14.1-11.5-25.6-25.6-25.6l-164.6 0-272-272 334.2 0c8.8 0 16 7.2 16 16l0 208 48 0 0-208c0-35.3-28.7-64-64-64L129.8 32 73-24.9zM497.8 400l89.3 0c-8.5 18.9-27.5 32-49.6 32l-7.8 0-32-32zM394.2 432l-291.8 0c-22.1 0-41.1-13.1-49.6-32l309.4 0-48-48-288.6 0C11.5 352 0 363.5 0 377.6 0 434.2 45.8 480 102.4 480l339.8 0-48-48zM112 149.8l-48-48 0 202.2 48 0 0-154.2z"]],
    "gears": [640, 512, ["cogs"], "f085", ["M65.5 149l6.5 24.2 29.8-1.6c8-.4 15.6 3.1 20.5 9.5 4.9 6.4 10.6 12.2 17.1 17.1 6.4 4.8 9.9 12.5 9.5 20.4l-1.6 29.7 24.2 6.5 13.5-26.6c3.6-7.1 10.5-12 18.4-13 8.1-1 15.9-3.1 23.3-6.3 7.4-3.1 15.8-2.4 22.5 2l25 16.3 17.7-17.7-16.3-25c-4.4-6.7-5.1-15.1-2-22.4 1.5-3.7 2.9-7.5 3.9-11.5s1.8-8 2.3-11.9c1-7.9 5.9-14.8 13-18.4l26.6-13.5-6.5-24.2-29.8 1.6c-8 .4-15.6-3.1-20.5-9.5-4.9-6.4-10.6-12.2-17.1-17.1-6.4-4.8-9.9-12.5-9.5-20.4l1.6-29.7-24.2-6.5-13.5 26.6c-3.6 7.1-10.5 12-18.4 13-8.1 1-15.9 3.1-23.3 6.3-7.4 3.1-15.8 2.4-22.5-2l-25-16.3-17.7 17.7 16.3 25c4.4 6.7 5.1 15.1 2 22.4-1.5 3.7-2.9 7.5-3.9 11.5s-1.8 8-2.3 11.9c-1 7.9-5.9 14.8-13 18.4L65.5 149zm157.8-12.7a32 32 0 1 1 -61.8-16.6 32 32 0 1 1 61.8 16.6zM321.5 363l26.6 13.5c7.1 3.6 12 10.5 13 18.4 .5 4 1.3 7.9 2.3 11.9s2.4 7.8 3.9 11.5c3.1 7.3 2.3 15.7-2 22.4l-16.3 25 17.7 17.7 25-16.3c6.7-4.4 15.1-5.1 22.5-2 7.4 3.1 15.3 5.3 23.3 6.3 7.9 1 14.8 5.8 18.4 13l13.5 26.6 24.2-6.5-1.6-29.7c-.4-8 3.1-15.6 9.5-20.4 6.5-4.9 12.2-10.7 17.1-17.1 4.8-6.4 12.5-9.9 20.5-9.5l29.8 1.6 6.5-24.2-26.6-13.5c-7.1-3.6-12-10.5-13-18.4-.5-4-1.3-7.9-2.3-11.9s-2.4-7.8-3.9-11.5c-3.1-7.3-2.3-15.7 2-22.4l16.3-25-17.7-17.7-25 16.3c-6.7 4.4-15.1 5.1-22.5 2-7.4-3.1-15.3-5.3-23.3-6.3-7.9-1-14.8-5.8-18.4-13l-13.5-26.6-24.2 6.5 1.6 29.7c.4 8-3.1 15.6-9.5 20.4-6.5 4.9-12.2 10.7-17.1 17.1-4.8 6.4-12.5 9.9-20.5 9.5l-29.8-1.6-6.5 24.2zm157.8 12.7a32 32 0 1 1 -61.8 16.6 32 32 0 1 1 61.8-16.6z", "M170.6-20.6c10.3-20.2 33.3-30.5 55.2-24.7L250-38.8c21.9 5.9 36.7 26.3 35.5 49l-1 17.8c2.7 2.5 5.3 5.1 7.8 7.8l17.8-1c22.7-1.2 43.1 13.6 49 35.5l6.5 24.2c5.9 21.9-4.4 45-24.7 55.2l-15.9 8.1c-.8 3.6-1.8 7.2-2.9 10.7l9.7 14.9c12.4 19 9.8 44.1-6.3 60.2L308 261.3c-16.1 16.1-41.1 18.7-60.2 6.3l-14.9-9.7c-3.5 1.1-7.1 2.1-10.7 2.9l-8.1 15.9c-10.3 20.2-33.3 30.5-55.2 24.7l-24.2-6.5c-21.9-5.9-36.7-26.3-35.5-49l1-17.8c-2.7-2.5-5.3-5.1-7.8-7.8l-17.8 1c-22.7 1.2-43.1-13.6-49-35.5l-6.5-24.2c-5.9-21.9 4.4-45 24.7-55.2l0 0 15.9-8.1c.8-3.6 1.8-7.2 2.9-10.7L52.8 72.6c-12.4-19-9.8-44.1 6.3-60.2l0 0 17.7-17.7C92.8-21.4 117.9-24 137-11.6l14.9 9.7c3.5-1.1 7.1-2.1 10.7-2.9l8.1-15.9zm67 28.2l-24.2-6.5-13.5 26.6c-3.6 7.1-10.5 12-18.4 13-8.1 1-15.9 3.1-23.3 6.3-7.4 3.1-15.8 2.4-22.5-2l-25-16.3-17.7 17.7 16.3 25c4.4 6.7 5.1 15.1 2 22.4-1.5 3.7-2.9 7.5-3.9 11.5s-1.8 8-2.3 11.9c-1 7.9-5.9 14.8-13 18.4l-26.6 13.5 6.5 24.2 29.8-1.6c8-.4 15.6 3.1 20.5 9.5 4.9 6.4 10.6 12.2 17.1 17.1 6.4 4.8 9.9 12.5 9.5 20.4l-1.6 29.7 24.2 6.5 13.5-26.6c3.6-7.1 10.5-12 18.4-13 8.1-1 15.9-3.1 23.3-6.3 7.4-3.1 15.8-2.4 22.5 2l25 16.3 17.7-17.7-16.3-25c-4.4-6.7-5.1-15.1-2-22.4 1.5-3.7 2.9-7.5 3.9-11.5s1.8-8 2.3-11.9c1-7.9 5.9-14.8 13-18.4l26.6-13.5-6.5-24.2-29.8 1.6c-8 .4-15.6-3.1-20.5-9.5-4.9-6.4-10.6-12.2-17.1-17.1-6.4-4.8-9.9-12.5-9.5-20.4l1.6-29.7zM161.5 119.7a32 32 0 1 1 61.8 16.6 32 32 0 1 1 -61.8-16.6zM355.2 266.2c-1.2-22.7 13.6-43.1 35.5-49l24.2-6.5c21.9-5.9 45 4.4 55.2 24.7l8.1 15.9c3.6 .8 7.2 1.8 10.7 2.9l14.9-9.7c19-12.4 44.1-9.8 60.2 6.3l17.7 17.7c16.1 16.1 18.7 41.2 6.3 60.2l-9.7 14.9c1.1 3.5 2.1 7.1 2.9 10.7l15.9 8.1c20.2 10.3 30.5 33.3 24.7 55.2l-6.5 24.2c-5.9 21.9-26.3 36.7-49 35.5l-17.8-1c-2.5 2.7-5.1 5.3-7.8 7.8l1 17.8c1.2 22.7-13.6 43.1-35.5 49l-24.2 6.5c-21.9 5.9-45-4.4-55.2-24.7l-8.1-15.9c-3.6-.8-7.2-1.8-10.7-2.9L393 523.6c-19 12.4-44.1 9.8-60.2-6.3l-17.7-17.7c-16.1-16.1-18.7-41.1-6.3-60.2l9.7-14.9c-1.1-3.5-2.1-7.1-2.9-10.7l-15.9-8.1c-20.2-10.3-30.5-33.3-24.7-55.2l6.5-24.2c5.9-21.9 26.3-36.7 49-35.5l17.8 1c2.5-2.7 5.1-5.3 7.8-7.8l-1-17.8zm72.1-9.1l-24.2 6.5 1.6 29.7c.4 8-3.1 15.6-9.5 20.4-6.5 4.9-12.2 10.7-17.1 17.1-4.8 6.4-12.5 9.9-20.5 9.5l-29.8-1.6-6.5 24.2 26.6 13.5c7.1 3.6 12 10.5 13 18.4 .5 4 1.3 7.9 2.3 11.9s2.4 7.8 3.9 11.5c3.1 7.3 2.3 15.7-2 22.4l-16.3 25 17.7 17.7 25-16.3c6.7-4.4 15.1-5.1 22.5-2 7.4 3.1 15.3 5.3 23.3 6.3 7.9 1 14.8 5.8 18.4 13l13.5 26.6 24.2-6.5-1.6-29.7c-.4-8 3.1-15.6 9.5-20.4 6.5-4.9 12.2-10.7 17.1-17.1 4.8-6.4 12.5-9.9 20.5-9.5l29.8 1.6 6.5-24.2-26.6-13.5c-7.1-3.6-12-10.5-13-18.4-.5-4-1.3-7.9-2.3-11.9s-2.4-7.8-3.9-11.5c-3.1-7.3-2.3-15.7 2-22.4l16.3-25-17.7-17.7-25 16.3c-6.7 4.4-15.1 5.1-22.5 2-7.4-3.1-15.3-5.3-23.3-6.3-7.9-1-14.8-5.8-18.4-13l-13.5-26.6zm-9.9 135.2a32 32 0 1 1 61.8-16.6 32 32 0 1 1 -61.8 16.6z"]],
    "wave-sine": [576, 512, [8767], "f899", ["", "M146.5 112c-34.5 0-65.2 21.7-76.7 54.3L46.6 232C42.2 244.5 28.5 251 16 246.6S-3 228.5 1.4 216l23.2-65.7c18.3-51.7 67.1-86.3 122-86.3 51.7 0 98.5 30.8 118.9 78.4l89.3 208.3c12.8 29.9 42.2 49.3 74.8 49.3 34.5 0 65.2-21.8 76.7-54.3L529.4 280c4.4-12.5 18.1-19.1 30.6-14.6s19.1 18.1 14.6 30.6l-23.2 65.7c-18.2 51.7-67.1 86.3-122 86.3-51.7 0-98.5-30.8-118.9-78.4L221.3 161.3c-12.8-29.9-42.2-49.3-74.8-49.3z"]],
    "arrow-turn-left-up": [384, 512, [], "e634", ["", "M360 464c13.3 0 24 10.7 24 24s-10.7 24-24 24l-96 0c-53 0-96-43-96-96l0-334.1-95 95c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9L175 7c4.5-4.5 10.6-7 17-7s12.5 2.5 17 7L345 143c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-95-95 0 334.1c0 26.5 21.5 48 48 48l96 0z"]],
    "garage": [576, 512, [], "e009", ["M24 512c13.3 0 24-10.7 24-24l0-296 480 0 0 296c0 13.3 10.7 24 24 24-32 0-64 0-96 0 13.3 0 24-10.7 24-24l0-208c0-22.1-17.9-40-40-40l-304 0c-22.1 0-40 17.9-40 40l0 208c0 13.3 10.7 24 24 24-32 0-64 0-96 0zM53.2 144c1.4-1.3 3.1-2.4 5-3.1L288 51.5 517.8 140.9c1.9 .7 3.6 1.8 5 3.1L53.2 144z", "M574.9 144c-4-21.5-18.8-39.8-39.7-47.9L305.4 6.8c-11.2-4.4-23.6-4.4-34.8 0L40.8 96.1C19.9 104.2 5.1 122.5 1.1 144 .4 147.8 0 151.8 0 155.8L0 488c0 13.3 10.7 24 24 24s24-10.7 24-24l0-296 480 0 0 296c0 13.3 10.7 24 24 24s24-10.7 24-24l0-332.2c0-4-.4-7.9-1.1-11.8zM53.2 144c1.4-1.3 3.1-2.4 5-3.1L288 51.5 517.8 140.9c1.9 .7 3.6 1.8 5 3.1L53.2 144zM144 488l0-88 288 0 0 88c0 13.3 10.7 24 24 24s24-10.7 24-24l0-208c0-22.1-17.9-40-40-40l-304 0c-22.1 0-40 17.9-40 40l0 208c0 13.3 10.7 24 24 24s24-10.7 24-24zM432 288l0 64-288 0 0-64 288 0zM224 448c-13.3 0-24 10.7-24 24s10.7 24 24 24l128 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-128 0z"]],
    "flatbread-stuffed": [512, 512, [129369], "e40c", ["M146.9 433.1c31.7 19.6 69.1 30.9 109.2 30.9 114.9 0 208-93.1 208-208 0-40.1-11.3-77.5-30.9-109.2L146.9 433.1zM272.1 408a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm80-16a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M393.2 31.9l-63.5 2.2c-6.2 .2-12.3-1.5-17.4-5L259.6-6.4c-11.3-7.6-26.2-6.5-36.4 2.7L175.7 39.1c-4.6 4.2-10.4 6.8-16.6 7.5L95.9 53.7C82.4 55.2 71.6 65.8 69.7 79.3l-9.3 63.5c-.9 6.2-3.7 12-8 16.5L8.3 205.7c-9.4 9.9-11 25-3.9 36.6l33.3 54.4c3.3 5.3 4.8 11.5 4.3 17.8l-4.4 64c-.5 7.9 2 15.4 6.8 21.2l84.2-84.2c-10.5-14.5-16.6-32.3-16.6-51.5 0-48.6 39.4-88 88-88 19.2 0 37 6.2 51.5 16.6l157-157c-4.6-2.6-9.8-3.9-15.3-3.7zM256.1 464c-40.1 0-77.5-11.3-109.2-30.9L433.2 146.8c19.6 31.7 30.9 69.1 30.9 109.2 0 114.9-93.1 208-208 208zM458.3 99C447.4 85 427 85.1 414.5 97.6L97.7 414.4c-12.5 12.5-12.6 32.9 1.3 43.8 43.4 33.7 97.9 53.8 157 53.8 141.4 0 256-114.6 256-256 0-59.2-20.1-113.7-53.8-157zM272.1 408a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm56 8a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]],
    "u-turn-down-left": [512, 512, [], "e7ef", ["M55.1 384l73.4 73.4 0-17.4c0-13.3 10.8-24 24-24l144 0 8.7-.2c88.8-4.5 159.3-77.9 159.3-167.8S393.9 84.7 305.1 80.2l-8.7-.2-184 0 0 64 184 0 5.3 .1c55 2.8 98.7 48.2 98.7 103.9s-43.7 101.1-98.7 103.9l-5.3 .1-144 0c-13.2 0-24-10.7-24-24l0-17.4-73.4 73.4z", "M7.2 364.3c-10.3 12.8-7.2 28-1.1 37.7l3 4 1 1 111.7 111.7 0 0 3.9 3.3c20.3 14.8 50.7 .6 50.7-26l0-32 120 0 11.1-.3C421.7 457.9 512.5 363.6 512.5 248S421.7 38.1 307.6 32.3l-11.1-.3-200 0c-17.7 0-32 14.3-32 32l0 96c0 17.7 14.3 32 32 32l200 0 5.7 .3c28.2 2.9 50.3 26.7 50.3 55.7s-22 52.9-50.3 55.7l-5.7 .3-120 0 0-32c0-24.4-26.2-39.2-47-28.3l-3 1.9-1.9 1.4-2.7 2.3-112 112-2.6 2.9zm121.2-53.7l0 17.4c0 13.3 10.8 24 24 24l144 0 5.3-.1c55-2.8 98.7-48.2 98.7-103.9s-43.7-101.1-98.7-103.9l-5.3-.1-184 0 0-64 184 0 8.7 .2c88.8 4.5 159.3 77.9 159.3 167.8S393.9 411.3 305.1 415.8l-8.7 .2-144 0c-13.2 0-24 10.7-24 24l0 17.4-73.4-73.4 73.4-73.4z"]],
    "face-shaking-horizontal": [640, 512, [], "e79d", ["M80 256c0-114.9 93.1-208 208-208 73.6 0 138.3 38.3 175.3 96l55 0c7.4 15.2 13.4 31.3 17.7 48L472 192c-13.3 0-24 10.7-24 24s10.7 24 24 24l71.5 0c.3 5.3 .5 10.6 .5 16 0 10.8-.7 21.5-2 32l-70 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l59.3 0c-5.5 16.8-12.8 32.9-21.5 48L452 384c-38.1 48.7-97.4 80-164 80-114.9 0-208-93.1-208-208zm28-40c0 11 9 20 20 20s20-9 20-20 9-20 20-20l16 0c11 0 20 9 20 20s9 20 20 20 20-9 20-20c0-33.1-26.9-60-60-60l-16 0c-33.1 0-60 26.9-60 60zm34.7 136.6c22.1 23 60 47.4 113.3 47.4s91.2-24.4 113.3-47.4c9.2-9.6 8.9-24.8-.7-33.9s-24.8-8.9-33.9 .7C319.7 335 293.6 352 256 352s-63.7-17-78.7-32.6c-9.2-9.6-24.4-9.9-33.9-.7s-9.9 24.4-.7 33.9zM268 216c0 11 9 20 20 20s20-9 20-20 9-20 20-20l16 0c11 0 20 9 20 20s9 20 20 20 20-9 20-20c0-33.1-26.9-60-60-60l-16 0c-33.1 0-60 26.9-60 60z", "M288 464c66.6 0 125.9-31.3 164-80l57.8 0c-44.3 76.5-127 128-221.8 128-141.4 0-256-114.6-256-256S146.6 0 288 0C389.2 0 476.7 58.7 518.3 144l-55 0C426.3 86.3 361.6 48 288 48 173.1 48 80 141.1 80 256s93.1 208 208 208zM177.3 319.4C192.3 335 218.4 352 256 352s63.7-17 78.7-32.6c9.2-9.6 24.4-9.9 33.9-.7s9.9 24.4 .7 33.9c-22.1 23-60 47.4-113.3 47.4s-91.2-24.4-113.3-47.4c-9.2-9.6-8.9-24.8 .7-33.9s24.8-8.9 33.9 .7zM168 196c-11 0-20 9-20 20s-9 20-20 20-20-9-20-20c0-33.1 26.9-60 60-60l16 0c33.1 0 60 26.9 60 60 0 11-9 20-20 20s-20-9-20-20-9-20-20-20l-16 0zm140 20c0 11-9 20-20 20s-20-9-20-20c0-33.1 26.9-60 60-60l16 0c33.1 0 60 26.9 60 60 0 11-9 20-20 20s-20-9-20-20-9-20-20-20l-16 0c-11 0-20 9-20 20zM528 88c0-13.3 10.7-24 24-24 48.6 0 88 39.4 88 88s-39.4 88-88 88l-80 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l80 0c22.1 0 40-17.9 40-40s-17.9-40-40-40c-13.3 0-24-10.7-24-24zM448 312c0-13.3 10.7-24 24-24l80 0c33.4 0 64-12 87.6-32-4 44.9-41.7 80-87.6 80l-80 0c-13.3 0-24-10.7-24-24z"]],
    "eyes": [576, 512, [], "e367", ["M56 288a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm256 0a32 32 0 1 0 64.1 0 32 32 0 1 0 -64.1 0z", "M226.9 387c22-31.5 37.1-77.7 37.1-131s-15.1-99.4-37.1-131C204.8 93.3 179 80 156 80s-48.8 13.3-70.9 45c-16.4 23.6-29 55.3-34.3 92.1 11.1-5.9 23.8-9.2 37.2-9.2 44.2 0 80 35.8 80 80s-35.8 80-80 80c-5.2 0-10.2-.5-15.1-1.4 3.7 7.3 7.8 14.1 12.2 20.4 22.1 31.7 47.9 45 70.9 45s48.8-13.3 70.9-45zM156 32C211.6 32 260.4 73.7 288 136.6 315.6 73.7 364.4 32 420 32 506.2 32 576 132.3 576 256S506.2 480 420 480C364.4 480 315.6 438.3 288 375.4 260.4 438.3 211.6 480 156 480 69.8 480 0 379.7 0 256S69.8 32 156 32zM528 256c0-53.3-15.1-99.4-37.1-131-22.1-31.7-47.9-45-70.9-45s-48.8 13.3-70.9 45c-15.8 22.8-28.1 53.1-33.7 88.2 8.9-3.4 18.6-5.3 28.7-5.3 44.2 0 80 35.8 80 80s-35.8 80-80 80c-2.2 0-4.3-.1-6.5-.3 3.6 6.9 7.5 13.3 11.6 19.2 22.1 31.7 47.9 45 70.9 45s48.8-13.3 70.9-45c22-31.5 37.1-77.7 37.1-131zM313 279.9a32 32 0 1 0 62 16.2 32 32 0 1 0 -62-16.2zM88 320a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]],
    "dash": [512, 512, ["minus-large"], "e404", ["", "M0 256c0-13.3 10.7-24 24-24l464 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 280c-13.3 0-24-10.7-24-24z"]],
    "photo-film-music": [640, 512, [], "e228", ["M240 64c0-8.8 7.2-16 16-16l288 0c8.8 0 16 7.2 16 16l0 125.9c-9.6 1.7-19.1 3.5-28.7 5.2l-54.9-87.9C472 100.3 464.3 96 456 96s-16 4.3-20.4 11.3l-47.5 76.1-17.2-22.1c-4.5-5.8-11.5-9.3-18.9-9.3s-14.4 3.4-18.9 9.3l-56 72c-5.6 7.2-6.6 17-2.6 25.3S286.8 272 296 272l57.8 0c-1.2 5.1-1.8 10.4-1.8 15.8l0 16.2-96 0c-8.8 0-16-7.2-16-16l0-224zm32 48a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M256 48l288 0c8.8 0 16 7.2 16 16l0 125.9 27.1-4.9c7.1-1.3 14.1-1.5 20.9-.6L608 64c0-35.3-28.7-64-64-64L256 0c-35.3 0-64 28.7-64 64l0 224c0 35.3 28.7 64 64 64l96 0 0-48-96 0c-8.8 0-16-7.2-16-16l0-224c0-8.8 7.2-16 16-16zm97.8 224c6.2-27.7 28.5-49.7 57.4-55l120.2-21.8-54.9-87.9C472 100.3 464.3 96 456 96s-16 4.3-20.4 11.3l-47.5 76.1-17.2-22.1c-4.5-5.8-11.5-9.3-18.9-9.3s-14.4 3.4-18.9 9.3l-56 72c-5.6 7.2-6.6 17-2.6 25.3S286.8 272 296 272l57.8 0zM273.5 480c3.7-19.4 13.9-35.7 26.5-48l-156 0 0-304-80 0c-35.3 0-64 28.7-64 64L0 416c0 35.3 28.7 64 64 64l209.5 0zM304 144a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM96 232l-48 0 0-40c0-8.8 7.2-16 16-16l32 0 0 56zm0 144l0 56-32 0c-8.8 0-16-7.2-16-16l0-40 48 0zm0-48l-48 0 0-48 48 0 0 48zm528-72.1c0-7.1-3.2-13.9-8.6-18.4s-12.7-6.5-19.7-5.2l-176 32c-11.4 2.1-19.7 12-19.7 23.6l0 161.6c-5.9-1.1-11.4-1.6-16-1.6-9.5 0-22.9 2.1-34.9 7.5-11.1 5-29.1 17.2-29.1 40.5s18 35.4 29.1 40.5c11.9 5.4 25.4 7.5 34.9 7.5s22.9-2.1 34.9-7.5c11.1-5 29.1-17.2 29.1-40.5l0-139.9 128-23.3 0 84.9c-5.9-1.1-11.4-1.6-16-1.6-9.5 0-22.9 2.1-34.9 7.5-11.1 5-29.1 17.2-29.1 40.5s18 35.4 29.1 40.5c11.9 5.4 25.4 7.5 34.9 7.5s22.9-2.1 34.9-7.5c11.1-5 29.1-17.2 29.1-40.5l0-208z"]],
    "location-arrow-slash": [576, 512, [], "e77a", ["M239.5 173.6l212.7-81.8-81.8 212.7-130.9-130.9z", "M41-24.9c-9.4-9.4-24.6-9.4-33.9 0S-2.3-.3 7 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9L407.5 341.7 509.9 75.5c4.5-11.8 1.7-25.2-7.2-34.1s-22.3-11.8-34.1-7.2L202.4 136.5 41-24.9zM239.5 173.6l212.7-81.8-81.8 212.7-130.9-130.9zm93.2 228.8l-11.6 30.1-20.9-62.6-126.2-126.2-62.6-20.9 30.1-11.6-37.1-37.1-51.9 19.9C39.9 199 31.7 211.2 32 224.7s9.1 25.4 21.9 29.6l176.8 58.9 58.9 176.8c4.3 12.8 16.1 21.6 29.6 21.9s25.7-7.9 30.6-20.5l19.9-51.9-37.1-37.1z"]],
    "circle-m": [512, 512, [], "e115", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm96-88c0-10.4 6.7-19.6 16.5-22.8s20.7 .2 26.8 8.6l68.6 93.6 68.6-93.6c6.1-8.4 17-11.8 26.8-8.6S368 157.6 368 168l0 176c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-102.7-44.6 60.9c-4.5 6.2-11.7 9.8-19.4 9.8s-14.8-3.6-19.4-9.8L192 241.3 192 344c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-176z", "M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM187.4 153.8c-6.1-8.4-17-11.8-26.8-8.6S144 157.6 144 168l0 176c0 13.3 10.7 24 24 24s24-10.7 24-24l0-102.7 44.6 60.9c4.5 6.2 11.7 9.8 19.4 9.8s14.8-3.6 19.4-9.8L320 241.3 320 344c0 13.3 10.7 24 24 24s24-10.7 24-24l0-176c0-10.4-6.7-19.6-16.5-22.8s-20.7 .2-26.8 8.6l-68.6 93.6-68.6-93.6z"]],
    "arrow-up-to-dotted-line": [384, 512, [], "e0a1", ["", "M64 32A32 32 0 1 1 0 32 32 32 0 1 1 64 32zM175 135c9.4-9.4 24.6-9.4 33.9 0L345 271c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-95-95 0 278.1c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-278.1-95 95c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9L175 135zM138.7 64a32 32 0 1 1 0-64 32 32 0 1 1 0 64zM277.3 32a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM352 64a32 32 0 1 1 0-64 32 32 0 1 1 0 64z"]],
    "file-circle-plus": [576, 512, [58606], "e494", ["M80 64c0-8.8 7.2-16 16-16l112 0 0 88c0 39.8 32.2 72 72 72l128 0 0 1.5c-94.7 11.8-168 92.6-168 190.5 0 22.4 3.8 44 10.9 64L96 464c-8.8 0-16-7.2-16-16L80 64z", "M208 48L96 48c-8.8 0-16 7.2-16 16l0 384c0 8.8 7.2 16 16 16l154.9 0c6.1 17.3 14.6 33.4 25.1 48L96 512c-35.3 0-64-28.7-64-64L32 64C32 28.7 60.7 0 96 0L229.5 0c17 0 33.3 6.7 45.3 18.7L397.3 141.3c12 12 18.7 28.3 18.7 45.3l0 21.5-136 0c-39.8 0-72-32.2-72-72l0-88zM348.1 160L256 67.9 256 136c0 13.3 10.7 24 24 24l68.1 0zM432 256a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm16 80c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 48-48 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l48 0 0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48 48 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-48 0 0-48z"]],
    "mustache": [640, 512, [], "e5bc", ["M48.2 210.7c4.5 78.8 69.8 141.3 149.8 141.3 32.5 0 64-10.5 90-30l17.6-13.2c8.5-6.4 20.3-6.4 28.8 0L352 322c26 19.5 57.5 30 90 30 79.9 0 145.3-62.5 149.8-141.3-44.3 16.7-96 7-131.4-28.4-14.3-14.3-33.6-22.3-53.8-22.3l-1.2 0c-18.5 0-36.4 6.5-50.6 18.3l-19.3 16.1c-8.9 7.4-21.8 7.4-30.7 0l-19.3-16.1c-14.2-11.8-32.1-18.3-50.6-18.3l-1.2 0c-20.2 0-39.5 8-53.8 22.3-35.4 35.4-87.1 45.1-131.4 28.4z", "M233.4 112c-32.9 0-64.4 13.1-87.7 36.3-28.5 28.5-74.2 29.8-104.3 3.1l-1.5-1.3c-2.7-2.4-5.8-4.1-9-5-2.8-.8-5.4-1.1-7.4-1-3.6 .1-7 .9-10.1 2.4-2.2 1-4.2 2.4-6 4.2-4.6 4.4-7.5 10.6-7.5 17.4l0 34c0 109.4 88.6 198 198 198 42.8 0 84.5-13.9 118.8-39.6l3.2-2.4 3.2 2.4c34.3 25.7 76 39.6 118.8 39.6 109.4 0 198-88.6 198-198l0-34c0-6.9-2.9-13.1-7.5-17.4-4.2-4-9.8-6.5-16.1-6.6-.4 0-.9 0-1.3 0-2.4 .1-4.8 .5-7.1 1.3-2.9 1-5.6 2.6-8 4.7l-1.5 1.3c-30.1 26.7-75.8 25.4-104.3-3.1-23.3-23.3-54.8-36.3-87.7-36.3l-1.2 0c-29.7 0-58.5 10.4-81.3 29.5l-4 3.3-4-3.3c-22.8-19-51.6-29.5-81.3-29.5l-1.2 0zm358.3 98.7c-4.5 78.8-69.8 141.3-149.8 141.3-32.5 0-64-10.5-90-30l-17.6-13.2c-8.5-6.4-20.3-6.4-28.8 0L288 322c-26 19.5-57.5 30-90 30-79.9 0-145.3-62.5-149.8-141.3 44.3 16.7 96 7 131.4-28.4 14.3-14.3 33.6-22.3 53.8-22.3l1.2 0c18.5 0 36.4 6.5 50.6 18.3l19.3 16.1c8.9 7.4 21.8 7.4 30.7 0l19.3-16.1c14.2-11.8 32.1-18.3 50.6-18.3l1.2 0c20.2 0 39.5 8 53.8 22.3 35.4 35.4 87.1 45.1 131.4 28.4z"]],
    "window-frame": [448, 512, [129695], "e04f", ["M80 64l0 168 120 0 0-184-104 0c-8.8 0-16 7.2-16 16zm0 216l0 184 120 0 0-184-120 0zM248 48l0 184 120 0 0-168c0-8.8-7.2-16-16-16L248 48zm0 232l0 184 120 0 0-184-120 0z", "M416 64l0 400 8 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 512c-13.3 0-24-10.7-24-24s10.7-24 24-24l8 0 0-400C32 28.7 60.7 0 96 0L352 0c35.3 0 64 28.7 64 64zM80 232l120 0 0-184-104 0c-8.8 0-16 7.2-16 16l0 168zm120 48l-120 0 0 184 120 0 0-184zm48 0l0 184 120 0 0-184-120 0zm0-48l120 0 0-168c0-8.8-7.2-16-16-16l-104 0 0 184z"]],
    "house-night": [640, 512, [], "e010", ["M224 276l0 204c0 8.8 7.2 16 16 16l256 0c8.8 0 16-7.2 16-16L512 276 368 137.3 224 276zm96 36c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-48z", "M125.2-15.9c6.2-4.4 5.4-14.8-2.2-15.6-3.6-.4-7.3-.5-11-.5-61.9 0-112 50.1-112 112S50.1 192 112 192c32.1 0 61.1-13.5 81.5-35.2 5.2-5.6-1-14-8.6-13.2-2.9 .3-5.9 .4-9 .4-48.6 0-88-39.4-88-88 0-29.7 14.7-55.9 37.2-71.9zM384.6 86.7c-9.3-8.9-24-8.9-33.3 0l-216 208c-9.5 9.2-9.8 24.4-.6 33.9s24.4 9.8 33.9 .6l7.4-7.1 0 157.8c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-157.8 7.4 7.1c9.5 9.2 24.7 8.9 33.9-.6s8.9-24.7-.6-33.9l-216-208zM512 276l0 204c0 8.8-7.2 16-16 16l-256 0c-8.8 0-16-7.2-16-16L224 276 368 137.3 512 276zM320 312l0 48c0 13.3 10.7 24 24 24l48 0c13.3 0 24-10.7 24-24l0-48c0-13.3-10.7-24-24-24l-48 0c-13.3 0-24 10.7-24 24zM520 72L487.4 85c-4.5 1.8-7.4 6.1-7.4 11s2.9 9.2 7.4 11l32.6 13 13 32.6c1.8 4.5 6.1 7.4 11 7.4s9.2-2.9 11-7.4l13-32.6 32.6-13c4.5-1.8 7.4-6.1 7.4-11s-2.9-9.2-7.4-11L568 72 555 39.4c-1.8-4.5-6.1-7.4-11-7.4s-9.2 2.9-11 7.4L520 72zM245-24.6L232 8 199.4 21c-4.5 1.8-7.4 6.1-7.4 11s2.9 9.2 7.4 11L232 56 245 88.6c1.8 4.5 6.1 7.4 11 7.4s9.2-2.9 11-7.4L280 56 312.6 43c4.5-1.8 7.4-6.1 7.4-11s-2.9-9.2-7.4-11L280 8 267-24.6c-1.8-4.5-6.1-7.4-11-7.4s-9.2 2.9-11 7.4z"]],
    "reel": [448, 512, [], "e238", ["M64 96l0 64c0 13.3 10.7 24 24 24l272 0c13.3 0 24-10.7 24-24l0-64-48 0 0-48-224 0 0 48-48 0zm0 64l0 96c0-13.3 10.7-24 24-24l296 0 0-72c0-13.3-10.7-24-24-24L88 136c-13.3 0-24 10.7-24 24zm0 96l0 96c0 13.3 10.7 24 24 24l272 0c13.3 0 24-10.7 24-24l0-72-296 0c-13.3 0-24-10.7-24-24zm0 96l0 64 48 0 0 48 224 0 0-48 48 0 0-64c0-13.3-10.7-24-24-24L88 328c-13.3 0-24 10.7-24 24z", "M32 24C32 10.7 42.7 0 56 0L392 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-8 0 0 48-48 0 0-48-224 0 0 48-48 0 0-48-8 0C42.7 48 32 37.3 32 24zm0 464c0-13.3 10.7-24 24-24l8 0 0-48 48 0 0 48 224 0 0-48 48 0 0 48 8 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L56 512c-13.3 0-24-10.7-24-24zM88 136l272 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L88 184c-13.3 0-24-10.7-24-24s10.7-24 24-24zm0 96l336 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L88 280c-13.3 0-24-10.7-24-24s10.7-24 24-24zM64 352c0-13.3 10.7-24 24-24l272 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L88 376c-13.3 0-24-10.7-24-24z"]],
    "icicles": [512, 512, [], "f7ad", ["M54.3 48l406.2 0-48 348.2-53-241.4c-2.4-10.7-11.7-18.5-22.6-18.8s-20.8 6.7-23.9 17.2l-26.9 91.6-23.6-61.4c-3.8-9.8-13.5-16-24-15.3s-19.3 8.2-21.7 18.4L192 290 167.3 186.4c-2.4-10.2-11.3-17.7-21.7-18.4s-20.2 5.5-24 15.3L99.6 240.6 54.3 48z", "M5.2 9.1C9.7 3.4 16.7 0 24 0L488 0c6.9 0 13.5 3 18.1 8.2s6.6 12.2 5.7 19L448.9 483c-2.3 16.6-16.5 29-33.2 29-15.8 0-29.4-11-32.8-26.4l-50.3-229.1-11.2 38.2c-4.4 15-18.1 25.2-33.7 25.2-14.5 0-27.6-9-32.8-22.5l-9.4-24.6-20.2 84.9C221.5 373.1 207.8 384 192 384s-29.5-10.9-33.2-26.2l-20.2-84.9-9.5 24.8c-5.2 13.4-18.1 22.3-32.5 22.3-16.2 0-30.2-11.1-33.9-26.8L.6 29.5C-1 22.4 .6 14.8 5.2 9.1zM54.3 48l45.3 192.6 22-57.2c3.8-9.8 13.5-16 24-15.3s19.3 8.2 21.7 18.4L192 290 216.7 186.4c2.4-10.2 11.3-17.7 21.7-18.4s20.2 5.5 24 15.3L286 244.8 313 153.2c3.1-10.5 12.9-17.6 23.9-17.2s20.3 8.1 22.6 18.8l53 241.4 48-348.2-406.2 0z"]],
    "binary-slash": [576, 512, [], "e33e", ["", "M7-24.9c9.4-9.4 24.6-9.4 33.9 0l61.3 61.3C112.6 14.9 134.5 0 160 0l64 0c35.3 0 64 28.7 64 64l0 96c0 17.2-6.8 32.8-17.8 44.3l83.7 83.7 62.2 0c35.3 0 64 28.7 64 64l0 62.2 89 89c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0L7 9.1C-2.3-.3-2.3-15.5 7-24.9zM236.2 170.4c2.4-2.8 3.8-6.4 3.8-10.4l0-96c0-8.8-7.2-16-16-16l-64 0c-8.8 0-16 7.2-16 16l0 14.2 92.2 92.2zM394.2 464l44 44c-6.9 2.6-14.4 4-22.2 4l-64 0c-35.3 0-64-28.7-64-64l0-90.2 48 48 0 42.2c0 8.8 7.2 16 16 16l42.2 0zM424 24l0 152 32 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-112 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l32 0 0-118.7-16.4 5.5C347 67 333.4 60.2 329.2 47.6s2.6-26.2 15.2-30.4l48-16C399.7-1.2 407.8 0 414 4.5S424 16.3 424 24zM200 312l0 152 32 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-112 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l32 0 0-118.7-16.4 5.5c-12.6 4.2-26.2-2.6-30.4-15.2s2.6-26.2 15.2-30.4l48-16c7.3-2.4 15.4-1.2 21.6 3.3s10 11.8 10 19.5z"]],
    "square-sliders-vertical": [448, 512, ["sliders-v-square"], "f3f2", ["M48 96l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16zM80 216c0-13.3 10.7-24 24-24l16 0 0-40c0-13.3 10.7-24 24-24s24 10.7 24 24l0 40 16 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-16 0 0 120c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-120-16 0c-13.3 0-24-10.7-24-24zm160 80c0-13.3 10.7-24 24-24l16 0 0-120c0-13.3 10.7-24 24-24s24 10.7 24 24l0 120 16 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-16 0 0 40c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-40-16 0c-13.3 0-24-10.7-24-24z", "M384 80c8.8 0 16 7.2 16 16l0 320c0 8.8-7.2 16-16 16L64 432c-8.8 0-16-7.2-16-16L48 96c0-8.8 7.2-16 16-16l320 0zM64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm80 96c-13.3 0-24 10.7-24 24l0 40-16 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l16 0 0 120c0 13.3 10.7 24 24 24s24-10.7 24-24l0-120 16 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-16 0 0-40c0-13.3-10.7-24-24-24zm184 24c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 120-16 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l16 0 0 40c0 13.3 10.7 24 24 24s24-10.7 24-24l0-40 16 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-16 0 0-120z"]],
    "arrow-trend-up": [576, 512, [], "e098", ["M0 392c0 6.1 2.3 12.3 7 17 9.4 9.4 24.6 9.4 33.9 0l151-151 111 111c9.4 9.4 24.6 9.4 33.9 0l191-191 0 118.1c0 13.3 10.7 24 24 24s24-10.7 24-24l0 152c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64l0-56z", "M352 120c0-13.3 10.7-24 24-24l176 0c13.3 0 24 10.7 24 24l0 176c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-118.1-191 191c-9.4 9.4-24.6 9.4-33.9 0L192 257.9 41 409c-9.4 9.4-24.6 9.4-33.9 0S-2.3 384.4 7 375L175 207c9.4-9.4 24.6-9.4 33.9 0L320 318.1 494.1 144 376 144c-13.3 0-24-10.7-24-24z"]],
    "timeline-arrow": [576, 512, [], "e29d", ["M64 96a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zM192 416a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zM320 96a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M128 96a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm48 0c0 35.8-23.5 66.1-56 76.3l0 59.7 208 0 0-59.7c-32.5-10.2-56-40.5-56-76.3 0-44.2 35.8-80 80-80s80 35.8 80 80c0 35.8-23.5 66.1-56 76.3l0 59.7 118.1 0-23-23c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l64 64c9.4 9.4 9.4 24.6 0 33.9l-64 64c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l23-23-246.1 0 0 59.7c32.5 10.2 56 40.5 56 76.3 0 44.2-35.8 80-80 80s-80-35.8-80-80c0-35.8 23.5-66.1 56-76.3l0-59.7-176 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l48 0 0-59.7C39.5 162.1 16 131.8 16 96 16 51.8 51.8 16 96 16s80 35.8 80 80zm16 320a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zM352 128a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]],
    "fort": [576, 512, [], "e486", ["M48 144l0 64 160 0 0-64-160 0zM80 256l0 192c0 8.8 7.2 16 16 16l128 0 0-80c0-35.3 28.7-64 64-64s64 28.7 64 64l0 80 128 0c8.8 0 16-7.2 16-16l0-192-128 0c-26.5 0-48-21.5-48-48l-64 0c0 26.5-21.5 48-48 48L80 256zM368 144l0 64 160 0 0-64-160 0z", "M24 32c13.3 0 24 10.7 24 24l0 40 56 0 0-40c0-13.3 10.7-24 24-24s24 10.7 24 24l0 40 56 0 0-40c0-13.3 10.7-24 24-24s24 10.7 24 24l0 104 64 0 0-104c0-13.3 10.7-24 24-24s24 10.7 24 24l0 40 56 0 0-40c0-13.3 10.7-24 24-24s24 10.7 24 24l0 40 56 0 0-40c0-13.3 10.7-24 24-24s24 10.7 24 24l0 152c0 20.9-13.4 38.7-32 45.3L544 448c0 35.3-28.7 64-64 64L96 512c-35.3 0-64-28.7-64-64l0-194.7C13.4 246.7 0 228.9 0 208L0 56C0 42.7 10.7 32 24 32zM208 256l-128 0 0 192c0 8.8 7.2 16 16 16l128 0 0-80c0-35.3 28.7-64 64-64s64 28.7 64 64l0 80 128 0c8.8 0 16-7.2 16-16l0-192-128 0c-26.5 0-48-21.5-48-48l-64 0c0 26.5-21.5 48-48 48zm0-112l-160 0 0 64 160 0 0-64zm160 64l160 0 0-64-160 0 0 64z"]],
    "circle-v": [512, 512, [], "e12a", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm98.5-77.3c-5.9-11.9-1.1-26.3 10.7-32.2s26.3-1.1 32.2 10.7L256 290.3 322.5 157.3c5.9-11.9 20.3-16.7 32.2-10.7s16.7 20.3 10.7 32.2l-88 176c-4.1 8.1-12.4 13.3-21.5 13.3s-17.4-5.1-21.5-13.3l-88-176z", "M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM189.5 157.3c-5.9-11.9-20.3-16.7-32.2-10.7s-16.7 20.3-10.7 32.2l88 176c4.1 8.1 12.4 13.3 21.5 13.3s17.4-5.1 21.5-13.3l88-176c5.9-11.9 1.1-26.3-10.7-32.2s-26.3-1.1-32.2 10.7L256 290.3 189.5 157.3z"]],
    "hexagon-nodes-bolt": [576, 512, [], "e69a", ["M84.8 172A24 24 0 1 1 43.2 148a24 24 0 1 1 41.6 24zm0 168A24 24 0 1 1 43.2 364a24 24 0 1 1 41.6-24zM248 64a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm0 192a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm0 192a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zM404.8 148a24 24 0 1 1 -41.6 24 24 24 0 1 1 41.6-24z", "M224 88a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm64-24c0 26.9-16.5 49.9-40 59.3l0 73.3c23.5 9.5 40 32.5 40 59.3c0 3.4-.3 6.7-.8 10l1 .6c-9.2 13-16.7 27.4-22.1 42.7l-3.5-2.1c-4.4 3.3-9.3 6.1-14.5 8.2l0 73.3c3.4 1.4 6.7 3.1 9.9 5c3.8 26.3 13.5 50.8 27.7 72C277.9 492.4 253.2 512 224 512c-35.3 0-64-28.7-64-64c0-26.9 16.5-49.9 40-59.3l0-73.3c-23.5-9.5-40-32.5-40-59.3c0-3.4 .3-6.7 .8-10l-58.2-34.9c-4.5 3.4-9.4 6.1-14.6 8.2l0 73.3c5.1 2.1 10 4.8 14.5 8.2l29.4-17.6c4.7 15.8 13.3 29.9 24.7 41.1L127.2 342c4 25.4-7.6 51.8-31.2 65.4C65.4 425.1 26.3 414.6 8.6 384S1.4 314.3 32 296.6c2.6-1.5 5.3-2.8 8-3.9l0-73.3c-2.7-1.1-5.4-2.4-8-3.9C1.4 197.8-9.1 158.6 8.6 128S65.4 86.9 96 104.6c23.6 13.6 35.2 40 31.2 65.4l58.2 34.9c4.4-3.3 9.3-6.1 14.5-8.2l0-73.3c-23.5-9.5-40-32.5-40-59.3c0-35.3 28.7-64 64-64s64 28.7 64 64zM432 192c-30.3 0-58.8 7.7-83.7 21.1c-1-.6-1.9-1.3-2.8-2l-29.4 17.6c-4.7-15.8-13.3-29.9-24.7-41.1l29.4-17.6c-4-25.4 7.7-51.7 31.2-65.4c30.6-17.7 69.8-7.2 87.4 23.4c11.9 20.6 11 45-.1 64.1c-2.4-.1-4.9-.2-7.4-.2zM224 280a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm172-99.2a24 24 0 1 0 -24-41.6 24 24 0 1 0 24 41.6zM84.8 172A24 24 0 1 0 43.2 148a24 24 0 1 0 41.6 24zM248 448a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM43.2 364a24 24 0 1 0 41.6-24A24 24 0 1 0 43.2 364zM432 224a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm47.9 63c-4.3-3.7-10.6-4-15.1-.6l-96 72c-4.1 3.1-5.8 8.5-4.2 13.4s6.2 8.2 11.4 8.2l35.6 0-30.1 54.2c-2.8 5-1.7 11.1 2.6 14.9s10.6 4 15.1 .6l96-72c4.1-3.1 5.8-8.5 4.2-13.4s-6.2-8.2-11.4-8.2l-35.6 0 30.1-54.2c2.8-5 1.7-11.1-2.6-14.9z"]],
    "light-emergency-on": [640, 512, [], "e420", ["M144 368l0 64 352 0 0-64-352 0zm48-160l0 112 256 0 0-112c0-70.7-57.3-128-128-128S192 137.3 192 208zm32-8c0-48.6 39.4-88 88-88 13.3 0 24 10.7 24 24s-10.7 24-24 24c-22.1 0-40 17.9-40 40 0 13.3-10.7 24-24 24s-24-10.7-24-24z", "M69.3 36l48 32c11 7.4 14 22.3 6.7 33.3s-22.3 14-33.3 6.7l-48-32c-11-7.4-14-22.3-6.7-33.3s22.3-14 33.3-6.7zM597.3 76l-48 32c-11 7.4-25.9 4.4-33.3-6.7s-4.4-25.9 6.7-33.3l48-32c11-7.4 25.9-4.4 33.3 6.7s4.4 25.9-6.7 33.3zM24 192l48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zm544 0l48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zM496 320c26.5 0 48 21.5 48 48l0 64c0 26.5-21.5 48-48 48l-352 0c-26.5 0-48-21.5-48-48l0-64c0-26.5 21.5-48 48-48l0-112c0-97.2 78.8-176 176-176s176 78.8 176 176l0 112zm-48 0l0-112c0-70.7-57.3-128-128-128S192 137.3 192 208l0 112 256 0zM144 432l352 0 0-64-352 0 0 64zM312 160c-22.1 0-40 17.9-40 40 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-48.6 39.4-88 88-88 13.3 0 24 10.7 24 24s-10.7 24-24 24z"]],
    "question": [320, 512, [10067, 10068, 61736], "3f", ["", "M48 160C48 98.1 98.1 48 160 48S272 98.1 272 160c0 48.2-30.5 89.4-73.3 105.1-29.4 10.8-62.7 37.9-62.7 78.9l0 16c0 13.3 10.7 24 24 24s24-10.7 24-24l0-16c0-12.1 11-26.3 31.3-33.8 61.1-22.5 104.7-81.2 104.7-150.2 0-88.4-71.6-160-160-160S0 71.6 0 160l0 8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-8zM160 512c17.7 0 32-14.3 32-32s-14.3-32-32-32-32 14.3-32 32 14.3 32 32 32z"]],
    "square-lira": [448, 512, [], "e6e7", ["M48 96l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16zm66.4 274.5c-4-8.2-3-18 2.6-25.3L143.7 311c1.7-2.2 3.3-4.6 4.7-7l-4.4 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l11.9 0c-.4-6.4-1.8-12.9-4.3-19l-1.4-3.5c-.2-.5-.4-1-.6-1.5l-5.6 0c-8.8 0-16-7.2-16-16 0-8.7 6.9-15.7 15.5-16 0-46.5 37.5-88 88.1-88l2.2 0c19.7 0 38.8 6.4 54.5 18.2l14.2 10.6c10.6 8 12.8 23 4.8 33.6s-23 12.8-33.6 4.8l-14.2-10.6C252 179 243 176 233.7 176l-2.2 0c-23 0-40.1 18.9-40 40l80.5 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-71.5 0c2.1 7.9 3.2 16 3.5 24l68 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-72 0c-3.2 11.3-8.3 22.1-15.1 32L296 336c13.3 0 24 10.7 24 24s-10.7 24-24 24l-160 0c-9.2 0-17.5-5.2-21.6-13.5z", "M64 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM150.2 249.5c-.2-.5-.4-1-.6-1.5l-5.6 0c-8.8 0-16-7.2-16-16 0-8.7 6.9-15.7 15.5-16 0-46.5 37.5-88 88.1-88l2.2 0c19.7 0 38.8 6.4 54.5 18.2l14.2 10.6c10.6 8 12.8 23 4.8 33.6s-23 12.8-33.6 4.8l-14.2-10.6C252 179 243 176 233.7 176l-2.2 0c-23 0-40.1 18.9-40 40l80.5 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-71.5 0c2.1 7.9 3.2 16 3.5 24l68 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-72 0c-3.2 11.3-8.3 22.1-15.1 32L296 336c13.3 0 24 10.7 24 24s-10.7 24-24 24l-160 0c-9.2 0-17.5-5.2-21.6-13.5s-3-18 2.6-25.3L143.7 311c1.7-2.2 3.3-4.6 4.7-7l-4.4 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l11.9 0c-.4-6.4-1.8-12.9-4.3-19l-1.4-3.5z"]],
    "square-dashed-circle-plus": [576, 512, [], "e5c2", ["", "M144 56c0 13.3-10.7 24-24 24-22.1 0-40 17.9-40 40 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-48.6 39.4-88 88-88 13.3 0 24 10.7 24 24zM32 216c0-13.3 10.7-24 24-24s24 10.7 24 24l0 80c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-80zM56 368c13.3 0 24 10.7 24 24 0 22.1 17.9 40 40 40l122.7 0c2.8 16.8 7.8 32.9 14.8 48L120 480c-48.6 0-88-39.4-88-88 0-13.3 10.7-24 24-24zM480 214c-15.3-3.9-31.4-6-48-6l0-88c0-22.1-17.9-40-40-40-13.3 0-24-10.7-24-24s10.7-24 24-24c48.6 0 88 39.4 88 88l0 94zM296 80l-80 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l80 0c13.3 0 24 10.7 24 24s-10.7 24-24 24zm-8 320a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm144-80c-8.8 0-16 7.2-16 16l0 48-48 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l48 0 0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48 48 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-48 0 0-48c0-8.8-7.2-16-16-16z"]],
    "chair-office": [448, 512, [], "f6c1", ["M80 304l0 48 288 0 0-48-288 0zM144 64l0 192 160 0 0-192c0-8.8-7.2-16-16-16L160 48c-8.8 0-16 7.2-16 16z", "M160 48c-8.8 0-16 7.2-16 16l0 192 160 0 0-192c0-8.8-7.2-16-16-16L160 48zM352 64l0 192 16 0c26.5 0 48 21.5 48 48l0 48c0 26.5-21.5 48-48 48l-120 0 0 64 48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l48 0 0-64-120 0c-26.5 0-48-21.5-48-48l0-48c0-26.5 21.5-48 48-48l16 0 0-192c0-35.3 28.7-64 64-64L288 0c35.3 0 64 28.7 64 64zM224 352l144 0 0-48-288 0 0 48 144 0zM48 152l0 48c0 13.3-10.7 24-24 24S0 213.3 0 200l0-48c0-13.3 10.7-24 24-24s24 10.7 24 24zm400 0l0 48c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-48c0-13.3 10.7-24 24-24s24 10.7 24 24z"]],
    "user-magnifying-glass": [640, 512, [], "e5c5", ["M56.5 512c13.3 0 24-10.7 24-24l0-8c0-70.7 57.3-128 128-128l80.2 0c-.1 2.7-.2 5.3-.2 8 0 67.2 39.4 125.1 96.4 152L56.5 512zm280-384a80 80 0 1 1 -160 0 80 80 0 1 1 160 0z", "M176.5 128a80 80 0 1 1 160 0 80 80 0 1 1 -160 0zm208 0a128 128 0 1 0 -256 0 128 128 0 1 0 256 0zM80.5 480c0-70.7 57.3-128 128-128l80.2 0c.8-16.8 4-32.9 9.4-48l-89.6 0c-97.2 0-176 78.8-176 176l0 8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-8zm376-192a72 72 0 1 1 0 144 72 72 0 1 1 0-144zm0 192c24.4 0 47.1-7.3 66.1-19.8l60.9 60.9c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-60.9-60.9c12.6-19 19.9-41.8 19.9-66.3 0-66.3-53.7-120-120-120s-120 53.7-120 120 53.7 120 120 120z"]],
    "container-storage": [576, 512, [], "f4b7", ["M80 80l416 0 0 352-416 0 0-352zm40 72l0 208c0 13.3 10.7 24 24 24s24-10.7 24-24l0-208c0-13.3-10.7-24-24-24s-24 10.7-24 24zm96 0l0 208c0 13.3 10.7 24 24 24s24-10.7 24-24l0-208c0-13.3-10.7-24-24-24s-24 10.7-24 24zm96 0l0 208c0 13.3 10.7 24 24 24s24-10.7 24-24l0-208c0-13.3-10.7-24-24-24s-24 10.7-24 24zm96 0l0 208c0 13.3 10.7 24 24 24s24-10.7 24-24l0-208c0-13.3-10.7-24-24-24s-24 10.7-24 24z", "M0 56C0 42.7 10.7 32 24 32l528 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-8 0 0 352 8 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 480c-13.3 0-24-10.7-24-24s10.7-24 24-24l8 0 0-352-8 0C10.7 80 0 69.3 0 56zM80 80l0 352 416 0 0-352-416 0zm40 72c0-13.3 10.7-24 24-24s24 10.7 24 24l0 208c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-208zm216-24c13.3 0 24 10.7 24 24l0 208c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-208c0-13.3 10.7-24 24-24zm72 24c0-13.3 10.7-24 24-24s24 10.7 24 24l0 208c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-208zM240 128c13.3 0 24 10.7 24 24l0 208c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-208c0-13.3 10.7-24 24-24z"]],
    "arrow-left-to-bracket": [512, 512, [], "e669", ["", "M303 409L167 273c-9.4-9.4-9.4-24.6 0-33.9L303 103c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-95 95 246.1 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-246.1 0 95 95c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0zM168 80L96 80c-26.5 0-48 21.5-48 48l0 256c0 26.5 21.5 48 48 48l72 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-72 0c-53 0-96-43-96-96L0 128C0 75 43 32 96 32l72 0c13.3 0 24 10.7 24 24s-10.7 24-24 24z"]],
    "sparkle": [512, 512, [], "e5d6", ["M92.5 256l108.8 40.7c6.5 2.4 11.6 7.6 14.1 14.1L256 419.5 296.7 310.8c2.4-6.5 7.6-11.6 14.1-14.1L419.5 256 310.8 215.3c-6.5-2.4-11.6-7.6-14.1-14.1L256 92.5 215.3 201.2c-2.4 6.5-7.6 11.6-14.1 14.1L92.5 256z", "M256 0c10 0 19 6.2 22.5 15.6l59.4 158.6 158.6 59.4C505.8 237 512 246 512 256s-6.2 19-15.6 22.5l-158.6 59.4-59.4 158.6C275 505.8 266 512 256 512s-19-6.2-22.5-15.6L174.2 337.8 15.6 278.5C6.2 275 0 266 0 256s6.2-19 15.6-22.5l158.6-59.4 59.4-158.6C237 6.2 246 0 256 0zm0 92.5L215.3 201.2c-2.4 6.5-7.6 11.6-14.1 14.1L92.5 256 201.2 296.7c6.5 2.4 11.6 7.6 14.1 14.1L256 419.5 296.7 310.8c2.4-6.5 7.6-11.6 14.1-14.1L419.5 256 310.8 215.3c-6.5-2.4-11.6-7.6-14.1-14.1L256 92.5z"]],
    "campfire": [512, 512, [], "f6ba", ["M199.3 218.3c0 32.1 26 58.2 58.2 58.2s58.2-26 58.2-58.2c0-33.2-33.7-66.4-49.8-80.4-4.9-4.2-11.9-4.2-16.8 0-16.1 14-49.8 47.2-49.8 80.4z", "M279.2 43.9s-22.1-26.7-35-37C239.2 2.9 233.8 .2 227.2 0s-13.1 2.1-18.3 6.8c-21.1 19.2-45 44.4-63.8 72.9-18.7 28.3-33.1 61-33.1 95 0 80.5 63.4 145.3 144 145.3 79.8 0 144-64.7 144-145.3 0-27.3-9.9-55.4-23.6-80.1-13.7-24.9-31.8-47.6-49.5-64.2-5-4.7-11.5-7.1-17.9-7.1-6.8 0-14 2.5-18.8 8.1l-11 12.5zm36.5 174.4c0 32.1-26 58.2-58.2 58.2s-58.2-26-58.2-58.2c0-33.2 33.7-66.4 49.8-80.4 4.9-4.2 11.9-4.2 16.8 0 16.1 14 49.8 47.2 49.8 80.4zM32.5 289.6c-12.4-4.7-26.3 1.5-31 13.9s1.5 26.2 13.9 31L188.3 400 15.5 465.6c-12.4 4.7-18.6 18.6-13.9 31s18.6 18.6 31 13.9L256 425.7 479.5 510.4c12.4 4.7 26.2-1.5 31-13.9s-1.5-26.2-13.9-31L323.7 400 496.5 334.4c12.4-4.7 18.6-18.6 13.9-31s-18.6-18.6-31-13.9L256 374.3 32.5 289.6z"]],
    "hands-bound": [640, 512, [], "e4f9", ["M162.1 186.7L136 168 136 64c-2.7-24-17.6-48-48-48S37.3 40 40 64l0 168 120 152 319.8 0 120-152 0-168c2.7-24-17.6-48-48-48s-45.3 24-48 48l0 104-26.1 18.7c-1-8.6-5-17.8-13.9-26.7-25.6-25.6-53.3-10.7-64 0L319.9 247.9 240 160c-10.7-10.7-38.4-25.6-64 0-8.9 8.9-12.9 18-13.9 26.7zM152 512l336 0 0-64-336 0 0 64z", "M16 72l0 134.6c0 22.2 7.4 43.7 21.1 61.2l69.2 88.6c-6.2 4.3-10.2 11.5-10.2 19.7 0 13.3 10.7 24 24 24l400 0c13.3 0 24-10.7 24-24 0-8.1-4-15.3-10.2-19.7l69.2-88.6c13.7-17.5 21.1-39 21.1-61.2L624 72c0-39.8-32.2-72-72-72s-72 32.2-72 72l0 66.3c-.5-.5-1-.9-1.6-1.4-29.8-25.2-74.3-22-100.2 7.2l-46.7 52.5c-4.2 4.7-8 9.7-11.5 14.8-3.5-5.2-7.3-10.1-11.5-14.8l-46.7-52.5c-25.9-29.2-70.4-32.4-100.2-7.2-.5 .5-1.1 .9-1.6 1.4L160 72c0-39.8-32.2-72-72-72S16 32.2 16 72zM163.8 352L74.9 238.2C67.8 229.2 64 218 64 206.6L64 72c0-13.3 10.7-24 24-24s24 10.7 24 24l0 107.4 71.5 95.3c.1 .2 .3 .4 .4 .6 7.5 9.4 20.9 11.6 31 5 11.4-7.4 14.1-22.9 6-33.7-.1-.2-.3-.4-.4-.6L189.3 207c-2.7-3.3-4.3-7.2-5-11.2-1.3-8.1 1.6-16.6 8.2-22.2 9.9-8.4 24.8-7.3 33.4 2.4l46.7 52.5c15.1 16.9 23.4 38.8 23.4 61.5l0 61.9-132.2 0zM344 352l0-61.9c0-22.7 8.3-44.6 23.4-61.5l46.7-52.5c8.6-9.7 23.5-10.8 33.4-2.4 6.7 5.6 9.5 14.1 8.2 22.2-.6 4-2.3 7.8-5 11.2l-31.3 39.1c-.2 .2-.3 .4-.4 .6-8.1 10.8-5.4 26.3 6 33.7 10.1 6.6 23.5 4.3 31-5 .2-.2 .3-.4 .4-.6L528 179.4 528 72c0-13.3 10.7-24 24-24s24 10.7 24 24l0 134.6c0 11.5-3.8 22.6-10.9 31.7L476.2 352 344 352zM120 424c-13.3 0-24 10.7-24 24s10.7 24 24 24l8 0 0 16c0 13.3 10.7 24 24 24s24-10.7 24-24l0-16 120 0 0 16c0 13.3 10.7 24 24 24s24-10.7 24-24l0-16 120 0 0 16c0 13.3 10.7 24 24 24s24-10.7 24-24l0-16 8 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-400 0z"]],
    "panel-fire": [576, 512, [], "e42f", ["M80 96c0-8.8 7.2-16 16-16l320 0c8.8 0 16 7.2 16 16l0 73.6c-3.4-3.2-6.8-6.4-10.3-9.5-11.9-10.7-26.9-16.1-42-16.1-5.5-9.6-15.9-16-27.7-16l-192 0c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32l94.1 0c-2.3 3.4-4.5 6.9-6.6 10.3-21.4 34.7-39.5 76.1-39.5 115.8 0 17.1 2.1 33.8 6 49.9L96 432c-8.8 0-16-7.2-16-16L80 96zm56 224a24 24 0 1 0 48 0 24 24 0 1 0 -48 0z", "M416 80L96 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l118 0c4.1 16.8 10.2 32.9 18.1 48L96 480c-35.3 0-64-28.7-64-64L32 96c0-35.3 28.7-64 64-64l320 0c35.3 0 64 28.7 64 64l0 76.2c-12 .3-23.8 3.9-34.1 11-4.6-4.6-9.2-9.1-13.9-13.5L432 96c0-8.8-7.2-16-16-16zm-78.2 79.9c-33 29.5-61.8 62.9-83.7 96.1L160 256c-17.7 0-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32l192 0c11.8 0 22.2 6.4 27.7 16-15 0-30 5.3-41.9 15.9zM160 296a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm281.7-55.9L454 226.3c5.4-6.1 13.3-8.8 20.9-8.9 7.2 0 14.3 2.6 19.9 7.8 19.7 18.3 39.8 43.2 55 70.6 15.1 27.2 26.2 58.1 26.2 88.1 0 88.7-71.3 159.8-160 159.8-89.6 0-160-71.3-160-159.8 0-37.3 16-73.4 36.8-104.5 20.9-31.3 47.5-59 70.9-80.2 5.7-5.2 13.1-7.7 20.3-7.5s13.4 3.2 18.8 7.5c14.4 11.4 38.9 40.7 38.9 40.7zM480 432c0-36.5-37-73-54.8-88.4-5.4-4.7-13.1-4.7-18.5 0-17.7 15.4-54.8 51.9-54.8 88.4 0 35.3 28.7 64 64 64s64-28.7 64-64z"]],
    "clock-seven-thirty": [512, 512, [], "e351", ["M464 256a208 208 0 1 1 -416 0 208 208 0 1 1 416 0zM172 338.7c-7.4 11-4.4 25.9 6.7 33.3s25.9 4.4 33.3-6.7l20-30 0 56.7c0 13.3 10.7 24 24 24s24-10.7 24-24l0-136c0-10.6-6.9-19.9-17-23s-21.1 .9-26.9 9.7l-64 96z", "M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm464 0a256 256 0 1 1 -512 0 256 256 0 1 1 512 0zM232 392l0-56.7-20 30c-7.4 11-22.3 14-33.3 6.7s-14-22.3-6.7-33.3l64-96c5.9-8.8 16.8-12.7 26.9-9.7s17 12.4 17 23l0 136c0 13.3-10.7 24-24 24s-24-10.7-24-24z"]],
    "tugrik-sign": [384, 512, [], "e2ba", ["", "M24 32C10.7 32 0 42.7 0 56S10.7 80 24 80l144 0 0 125.3-109.8 27.5c-12.9 3.2-20.7 16.2-17.5 29.1S57 282.5 69.8 279.3l98.2-24.5 0 46.5-109.8 27.5c-12.9 3.2-20.7 16.2-17.5 29.1S57 378.5 69.8 375.3L168 350.7 168 456c0 13.3 10.7 24 24 24s24-10.7 24-24l0-117.3 109.8-27.5c12.9-3.2 20.7-16.2 17.5-29.1s-16.2-20.7-29.1-17.5l-98.2 24.5 0-46.5 109.8-27.5c12.9-3.2 20.7-16.2 17.5-29.1s-16.2-20.7-29.1-17.5L216 193.3 216 80 360 80c13.3 0 24-10.7 24-24s-10.7-24-24-24L24 32z"]],
    "audio-description-slash": [576, 512, [], "e0a8", ["M177.8 112L480 112c8.8 0 16 7.2 16 16l0 256c0 8.8-7.2 16-16 16l-14.2 0-56.3-56.3C432.4 331.6 448 307.6 448 280l0-48c0-39.8-32.2-72-72-72l-48 0c-13.3 0-24 10.7-24 24l0 54.2-126.2-126.2zM352 208l24 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24l-6.2 0-17.8-17.8 0-78.2z", "M41-24.9c-9.4-9.4-24.6-9.4-33.9 0S-2.3-.3 7 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-61.4-61.4C529.1 431.4 544 409.5 544 384l0-256c0-35.3-28.7-64-64-64L129.8 64 41-24.9zM177.8 112L480 112c8.8 0 16 7.2 16 16l0 256c0 8.8-7.2 16-16 16l-14.2 0-56.3-56.3C432.4 331.6 448 307.6 448 280l0-48c0-39.8-32.2-72-72-72l-48 0c-13.3 0-24 10.7-24 24l0 54.2-126.2-126.2zm192 192l-17.8-17.8 0-78.2 24 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24l-6.2 0zM132 201.8c-2.6 6.9-4 14.4-4 22.2l0 104c0 13.3 10.7 24 24 24s24-10.7 24-24l0-24 48 0 0 24c0 13.3 10.7 24 24 24 9.2 0 17.3-5.2 21.3-12.9L132 201.8zm-52-52l-44-44c-2.6 6.9-4 14.4-4 22.2l0 256c0 35.3 28.7 64 64 64l282.2 0-48-48-234.2 0c-8.8 0-16-7.2-16-16l0-234.2z"]],
    "face-thermometer": [576, 512, [], "e39a", ["M80.2 256c0-114.9 93.1-208 208-208 73.4 0 137.9 38 174.9 95.4l14.2-13.8c7.1-6.9 15.1-12.2 23.7-16 7.5 11.1 14.1 22.9 19.8 35.2-2.8 1-5.6 2.3-8.2 3.8-1.3 .8-2.6 1.7-3.8 2.6s-2.4 2-3.6 3.1L344.5 314c-16.3-6.1-35.1-10-56.3-10-53.3 0-91.2 24.4-113.3 47.4-9.2 9.6-8.9 24.8 .7 33.9s24.8 8.9 33.9-.7c15-15.7 41.1-32.6 78.7-32.6s63.7 17 78.7 32.6c9.2 9.6 24.4 9.9 33.9 .7 5.1-4.9 7.6-11.5 7.4-18.1 163.4-156.1 108-103.2 135.4-129.3 .4 6 .6 12 .6 18.1 0 13.7-1.1 27.1-3.1 40.2l-83.5 80.5c-37.7 52.8-99.5 87.3-169.4 87.3-114.9 0-208-93.1-208-208zm96-48a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm160 0a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M288.2 48c-114.9 0-208 93.1-208 208s93.1 208 208 208c69.9 0 131.7-34.4 169.4-87.3l83.5-80.5C521.8 418.5 415.9 512 288.2 512 146.9 512 32.2 397.4 32.2 256S146.9 0 288.2 0c88.7 0 166.8 45.1 212.8 113.6-8.5 3.8-16.6 9.1-23.7 16l-14.2 13.8C426.1 86 361.6 48 288.2 48zM400.9 385.3c-9.6 9.2-24.8 8.9-33.9-.7-15-15.7-41.1-32.6-78.7-32.6s-63.7 17-78.7 32.6c-9.2 9.6-24.4 9.9-33.9 .7s-9.9-24.4-.7-33.9c22.1-23 60-47.4 113.3-47.4 21.2 0 40 3.9 56.3 10L505.2 158.3c16.5-16 42.7-15.7 58.9 .5 16.7 16.7 16.4 43.8-.7 60.1l-13.2 12.6-26.8-26.8c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l26.3 26.3-26 24.8-25.7-25.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l25.2 25.2-26 24.8-24.6-24.6c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l24.1 24.1-20.8 19.8c.2 6.6-2.3 13.2-7.4 18.1zM208.2 176a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm128 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"]],
    "lightbulb-cfl-on": [640, 512, [], "e5a7", ["M192 80c1.9 0 3.9-.2 5.8-.7l122.2-30.5 0 46.5-128 32 0-47.3zm0 96c1.9 0 3.9-.2 5.8-.7L448 112.7 448 160c-1.9 0-3.9 .2-5.8 .7L192 223.3 192 176zm80 76.7l176-44 0 47.3c-2.1 0-4.2 .3-6.3 .9l-88 24C343.2 283.7 336 293.2 336 304l0 80-32 0 0-89.8-32 8 0-49.5z", "M325.8 47.3c12.9-3.2 20.7-16.2 17.5-29.1S327-2.5 314.2 .7l-128 32c-12.9 3.2-20.7 16.2-17.5 29.1S185 82.5 197.8 79.3l128-32zM471.3 82.2c-3.2-12.9-16.2-20.7-29.1-17.5l-256 64c-12.9 3.2-20.7 16.2-17.5 29.1s16.2 20.7 29.1 17.5l256-64c12.9-3.2 20.7-16.2 17.5-29.1zm0 96c-3.2-12.9-16.2-20.7-29.1-17.5l-256 64c-12.9 3.2-20.7 16.2-17.5 29.1s16.2 20.7 29.1 17.5l256-64c12.9-3.2 20.7-16.2 17.5-29.1zM256 306.2l0 77.8-8 0c-13.3 0-24 10.7-24 24l0 24c0 44.2 35.8 80 80 80l32 0c44.2 0 80-35.8 80-80l0-24c0-13.3-10.7-24-24-24l-8 0 0-61.7 70.3-19.2c12.8-3.5 20.3-16.7 16.8-29.5s-16.7-20.3-29.5-16.8l-88 24C343.2 283.7 336 293.2 336 304l0 80-32 0 0-89.8-48 12zM58.7 26.5c-11.9-5.9-26.3-1.1-32.2 10.7S25.4 63.5 37.3 69.5l32 16c11.9 5.9 26.3 1.1 32.2-10.7s1.1-26.3-10.7-32.2l-32-16zm544 42.9c11.9-5.9 16.7-20.3 10.7-32.2s-20.3-16.7-32.2-10.7l-32 16c-11.9 5.9-16.7 20.3-10.7 32.2s20.3 16.7 32.2 10.7l32-16zM24 168c-13.3 0-24 10.7-24 24s10.7 24 24 24l32 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-32 0zm560 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l32 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-32 0zM90.7 341.5c11.9-5.9 16.7-20.3 10.7-32.2s-20.3-16.7-32.2-10.7l-32 16c-11.9 5.9-16.7 20.3-10.7 32.2s20.3 16.7 32.2 10.7l32-16zm480-42.9c-11.9-5.9-26.3-1.1-32.2 10.7s-1.1 26.3 10.7 32.2l32 16c11.9 5.9 26.3 1.1 32.2-10.7s1.1-26.3-10.7-32.2l-32-16z"]],
    "clock-three": [512, 512, [], "e356", ["M464 256a208 208 0 1 1 -416 0 208 208 0 1 1 416 0zM232 120l0 136c0 13.3 10.7 24 24 24l104 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0 0-112c0-13.3-10.7-24-24-24s-24 10.7-24 24z", "M464 256a208 208 0 1 1 -416 0 208 208 0 1 1 416 0zM0 256a256 256 0 1 0 512 0 256 256 0 1 0 -512 0zM232 120l0 136c0 13.3 10.7 24 24 24l104 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0 0-112c0-13.3-10.7-24-24-24s-24 10.7-24 24z"]],
    "person-walking-luggage": [512, 512, [], "e554", ["M288.3 162.2c6-1.4 12.2-2.2 18.4-2.2 7.4 0 14.6 1 21.6 3l0 154.8-22.2-14.8c-11.1-7.4-17.8-19.9-17.8-33.3l0-107.6z", "M264.3 24a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm24 138.2l0 107.6c0 13.4 6.7 25.9 17.8 33.3l22.2 14.8 0-154.8c-7-2-14.2-3-21.6-3-6.3 0-12.4 .7-18.4 2.2zm-48 31.7L220 214.2c-7.5 7.5-11.7 17.7-11.7 28.3l0 45.1c0 .1 0 .3 0 .4l0 17.4c0 8.1-1.9 16-5.5 23.3l-69 138.1-.8-.4-27.7 55.3c-9.9 19.8-33.9 27.8-53.7 17.9L14.6 521c-19.8-9.9-27.8-33.9-17.9-53.7L47.3 366.3c9.9-19.8 33.9-27.8 53.7-17.9l30.7 15.3 28.3-56.6c.3-.6 .4-1.2 .4-1.8l0-9c0-.1 0-.3 0-.4l0-53.5c0-23.3 9.3-45.7 25.8-62.2L217.4 149c23.7-23.7 55.8-37 89.4-37 35.8 0 70 15.2 93.9 41.8l22.4 24.9c7.6 8.4 18.4 13.2 29.7 13.2l35.5 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-35.5 0c-24.9 0-48.7-10.6-65.4-29.1l-11.1-12.3 0 151.3 21.2 14.1c21.1 14 35.1 36.5 38.4 61.6l12.2 91.3c1.8 13.1-7.5 25.2-20.6 27s-25.2-7.5-27-20.6l-12.2-91.3c-1.5-11.4-7.9-21.6-17.5-28L279.5 343c-24.5-16.3-39.2-43.8-39.2-73.2l0-75.8zM260 387.7l41.9 28-2 7c-4.1 14.4-11.8 27.5-22.4 38L201.3 537c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l76.3-76.3c4.8-4.8 8.3-10.8 10.2-17.3l6.2-21.8z"]],
    "file-arrow-down": [384, 512, ["file-download"], "f56d", ["M48 64l0 384c0 8.8 7.2 16 16 16l256 0c8.8 0 16-7.2 16-16l0-240-88 0c-39.8 0-72-32.2-72-72l0-88-112 0c-8.8 0-16 7.2-16 16zm63 263c9.4-9.4 24.6-9.4 33.9 0l23 23 0-86.1c0-13.3 10.7-24 24-24s24 10.7 24 24l0 86.1 23-23c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-64 64c-9.4 9.4-24.6 9.4-33.9 0l-64-64c-9.4-9.4-9.4-24.6 0-33.9z", "M64 48l112 0 0 88c0 39.8 32.2 72 72 72l88 0 0 240c0 8.8-7.2 16-16 16L64 464c-8.8 0-16-7.2-16-16L48 64c0-8.8 7.2-16 16-16zM224 67.9l92.1 92.1-68.1 0c-13.3 0-24-10.7-24-24l0-68.1zM64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-261.5c0-17-6.7-33.3-18.7-45.3L242.7 18.7C230.7 6.7 214.5 0 197.5 0L64 0zM175 425c9.4 9.4 24.6 9.4 33.9 0l64-64c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-23 23 0-86.1c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 86.1-23-23c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l64 64z"]],
    "person-booth": [576, 512, [], "f756", ["M80 176l0 95.4c0 10.6 4.2 20.8 11.7 28.3L112 320 112 176c0-8.8-7.2-16-16-16s-16 7.2-16 16zM330.4 48l83.4 182c2 4.4 2.7 9.3 1.8 14.1L388.5 400 528 400 528 56c0-4.4-3.6-8-8-8L330.4 48z", "M40 24A56 56 0 1 1 152 24 56 56 0 1 1 40 24zm56.4 88c23.3 0 44.7 12.5 56.1 32.8l42.1 74.8c7.1 12.6 20.4 20.4 34.9 20.4l34.6 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-34.6 0c-27.4 0-52.9-12.7-69.4-33.9l0 97.9 12.8 9.6C195 378.2 208 404.3 208 432l0 88c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-88c0-12.6-5.9-24.4-16-32L67.2 342.4C45 325.8 32 299.7 32 272l0-95.6C32 140.8 60.8 112 96.4 112zM32 520l0-150.4c3.5 3.5 7.2 6.8 11 9.9L80 409 80 520c0 13.3-10.7 24-24 24s-24-10.7-24-24zm80-344c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 95.4c0 10.6 4.2 20.8 11.7 28.3L112 320 112 176zm301.8 54c2 4.4 2.7 9.3 1.8 14.1L388.5 400 528 400 528 56c0-4.4-3.6-8-8-8l-189.6 0 83.4 182zM528 520l0-72-168 0c-7.1 0-13.8-3.1-18.4-8.6s-6.5-12.6-5.3-19.6l30.7-176.7-63.1-137.6 0 88.2c-5.1-1.2-10.5-1.8-16-1.8l-32 0 0-136c0-30.9 25.1-56 56-56L520 0c30.9 0 56 25.1 56 56l0 464c0 13.3-10.7 24-24 24s-24-10.7-24-24zM304 334.2L304 520c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-184 32 0c5.5 0 10.9-.6 16-1.8z"]],
    "locust": [576, 512, [], "e520", ["M80 294.2c0-12.2 9.9-22.2 22.2-22.2l36.5 0-36.7 46.4-9.1-4.1C85.1 310.7 80 302.8 80 294.2zM146.9 339l52.9-67 280.2 0c26.5 0 48 21.5 48 48s-21.5 48-48 48l-238.2 0c-20.7 0-41.1-4.4-59.9-13l-35-16zM448 320a24 24 0 1 0 48 0 24 24 0 1 0 -48 0z", "M328 32c137 0 248 111 248 248l0 40-.1 4.9c-2.3 45.9-36.9 83.3-81.6 90l15.2 30.3c5.9 11.9 1.1 26.3-10.8 32.2s-26.3 1.1-32.2-10.7l-25.4-50.7-110.7 0-29.7 51.9c-6.6 11.5-21.2 15.5-32.7 8.9s-15.5-21.2-8.9-32.8l16.1-28.1-33.4 0-10.3-.3c-8.6-.5-17.2-1.6-25.7-3.2l-42.5 57.7c-7.9 10.7-22.9 12.9-33.6 5.1s-12.9-22.9-5.1-33.6l33.2-45-41.5-19-73.5 93.1c-8.2 10.4-23.3 12.2-33.7 4s-12.2-23.3-4-33.7l66.3-84c-22.5-11-37.4-33.1-39.2-57.9l-.2-5.1c0-36.3 27.6-66.2 63-69.8l7.2-.4 74.4 0 68.6-86.9 1.9-2.2c4.8-4.7 11.3-7.3 18.1-6.9 7.8 .4 14.9 4.5 19 11.1l29.4 46.2 35.1-47.6 1.9-2.3c4.9-5.1 11.8-7.9 19-7.4 8.2 .6 15.5 5.2 19.4 12.4l45.5 83.5 45.4 0c15.3 0 29.8 3.7 42.6 10.1-20.8-88.3-100-154.1-194.6-154.1l-24 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l24 0zM146.9 339l35 16c18.8 8.6 39.2 13 59.9 13L480 368c26.5 0 48-21.5 48-48s-21.5-48-48-48l-280.2 0-52.9 67zM472 344a24 24 0 1 1 0-48 24 24 0 1 1 0 48zM102.2 272c-12.2 0-22.2 9.9-22.2 22.2 0 8.7 5.1 16.5 12.9 20.1l9.1 4.1 36.7-46.4-36.5 0zm135.5-48l43.7 0-19.5-30.6-24.2 30.6zm107.1 0l35.2 0-15-27.4-20.2 27.4z"]],
    "window": [512, 512, [], "f40e", ["M48 256l0 128c0 8.8 7.2 16 16 16l384 0c8.8 0 16-7.2 16-16l0-128-416 0z", "M48 384l0-128 416 0 0 128c0 8.8-7.2 16-16 16L64 400c-8.8 0-16-7.2-16-16zM64 64C28.7 64 0 92.7 0 128L0 384c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L64 64zm32 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm64 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm128-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]],
    "right-long": [576, 512, ["long-arrow-alt-right"], "f30b", ["M48 224l0 64 360 0c13.3 0 24 10.7 24 24l0 33.4 89.4-89.4-89.4-89.4 0 33.4c0 13.3-10.7 24-24 24L48 224z", "M521.4 256L432 166.6 432 200c0 13.3-10.7 24-24 24l-360 0 0 64 360 0c13.3 0 24 10.7 24 24l0 33.4 89.4-89.4zm45.3-22.6c12.5 12.5 12.5 32.8 0 45.3l-128 128c-9.2 9.2-22.9 11.9-34.9 6.9l0 0c-12-5-19.8-16.6-19.8-29.6l0-48-336 0c-26.5 0-48-21.5-48-48l0-64c0-26.5 21.5-48 48-48l336 0 0-48c0-12.9 7.8-24.6 19.8-29.6l0 0c12-5 25.7-2.2 34.9 6.9l128 128 0 0z"]],
    "truck-droplet": [576, 512, [], "e58c", ["M48 96l0 288c0 8.8 7.2 16 16 16l3.3 0c10.4-36.9 44.4-64 84.7-64s74.2 27.1 84.7 64l102.6 0c4.9-17.4 15.1-32.7 28.7-43.9L368 96c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16zm88 136c0-33.2 34.5-78 55.8-102.4 8.7-10 23.8-10 32.5 0 21.2 24.4 55.8 69.1 55.8 102.4 0 48-32.2 72-72 72s-72-32.2-72-72zm280 72l0 32.4c2.6-.2 5.3-.4 8-.4 40.3 0 74.2 27.1 84.7 64l3.3 0c8.8 0 16-7.2 16-16l0-80-112 0z", "M352 80c8.8 0 16 7.2 16 16l0 260.1c-13.6 11.2-23.8 26.5-28.7 43.9l-102.6 0c-10.4-36.9-44.4-64-84.7-64s-74.2 27.1-84.7 64L64 400c-8.8 0-16-7.2-16-16L48 96c0-8.8 7.2-16 16-16l288 0zM64 448l3.3 0c10.4 36.9 44.4 64 84.7 64s74.2-27.1 84.7-64l102.6 0c10.4 36.9 44.4 64 84.7 64s74.2-27.1 84.7-64l3.3 0c35.3 0 64-28.7 64-64l0-151.4c0-17-6.7-33.3-18.7-45.3l-40.6-40.6c-12-12-28.3-18.7-45.3-18.7l-55.4 0 0-32c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 384c0 35.3 28.7 64 64 64zM416 176l55.4 0c4.2 0 8.3 1.7 11.3 4.7l40.6 40.6c3 3 4.7 7.1 4.7 11.3l0 23.4-112 0 0-80zm0 160.4l0-32.4 112 0 0 80c0 8.8-7.2 16-16 16l-3.3 0c-10.4-36.9-44.4-64-84.7-64-2.7 0-5.4 .1-8 .4zM112 424a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zm272 0a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zM208 304c39.8 0 72-24 72-72 0-33.2-34.5-78-55.8-102.4-8.7-10-23.8-10-32.5 0-21.2 24.4-55.8 69.1-55.8 102.4 0 39.8 32.2 72 72 72z"]],
    "hand-holding-medical": [576, 512, [], "e05c", ["M0 376c0 13.3 10.7 24 24 24l48 0c4.7 0 9.4-1.4 13.3-4l79.9-53.3c6.6-4.4 14.3-6.7 22.2-6.7L320 336c8.8 0 16 7.2 16 16s-7.2 16-16 16l-64 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l144 0c4.8 0 9.6-1.5 13.6-4.2l76-52.1c10.7-7.3 25.4-4.1 32 7 6.1 10.2 3.2 23.5-6.6 30.2l-80.1 54.6c-12 8.2-26.1 12.5-40.6 12.5L24 464c-13.3 0-24 10.7-24 24L0 376z", "M240 24l0 56-56 0c-13.3 0-24 10.7-24 24l0 48c0 13.3 10.7 24 24 24l56 0 0 56c0 13.3 10.7 24 24 24l48 0c13.3 0 24-10.7 24-24l0-56 56 0c13.3 0 24-10.7 24-24l0-48c0-13.3-10.7-24-24-24l-56 0 0-56c0-13.3-10.7-24-24-24L264 0c-13.3 0-24 10.7-24 24zM165.2 342.7c6.6-4.4 14.3-6.7 22.2-6.7L320 336c8.8 0 16 7.2 16 16s-7.2 16-16 16l-64 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l144 0c4.8 0 9.6-1.5 13.6-4.2l76-52.1c10.7-7.3 25.4-4.1 32 7 6.1 10.2 3.2 23.5-6.6 30.2l-80.1 54.6c-12 8.2-26.1 12.5-40.6 12.5L24 464c-13.3 0-24 10.7-24 24s10.7 24 24 24l370.4 0c24.1 0 47.7-7.3 67.6-20.9l80.1-54.6c30.9-21 40-62.5 20.7-94.5-20.9-34.8-66.8-44.8-100.3-21.9L392.6 368 382 368c1.3-5.1 2-10.5 2-16 0-35.3-28.7-64-64-64l-132.6 0c-17.4 0-34.4 5.1-48.8 14.8L64.7 352 24 352c-13.3 0-24 10.7-24 24s10.7 24 24 24l48 0c4.7 0 9.4-1.4 13.3-4l79.9-53.3z"]],
    "hand-point-left": [512, 512, [], "f0a5", ["M48 144c0-8.8 7.2-16 16-16l177.6 0c-1 5.2-1.6 10.5-1.6 16l0 16-176 0c-8.8 0-16-7.2-16-16zm144 80c0-8.8 7.2-16 16-16l32 0 0 16c0 5.5 .7 10.9 2 16l-34 0c-8.8 0-16-7.2-16-16zm32 80c0-8.8 7.2-16 16-16l64 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-64 0c-8.8 0-16-7.2-16-16zm16 80c0-8.8 7.2-16 16-16l64 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-64 0c-8.8 0-16-7.2-16-16zm48-240c0-17.7 14.3-32 32-32l24 0c66.3 0 120 53.7 120 120l0 48c0 52.5-33.7 97.1-80.7 113.4 .5-3.1 .7-6.2 .7-9.4 0-20-9.2-37.9-23.6-49.7 4.9-9 7.6-19.4 7.6-30.3 0-15.1-5.3-29-14-40 8.8-11 14-24.9 14-40l0-40c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 40c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80z", "M64 128l177.6 0c-1 5.2-1.6 10.5-1.6 16l0 16-176 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zm224 16c0-17.7 14.3-32 32-32l24 0c66.3 0 120 53.7 120 120l0 48c0 52.5-33.7 97.1-80.7 113.4 .5-3.1 .7-6.2 .7-9.4 0-20-9.2-37.9-23.6-49.7 4.9-9 7.6-19.4 7.6-30.3 0-15.1-5.3-29-14-40 8.8-11 14-24.9 14-40l0-40c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 40c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80zm32-80l0 0c-18 0-34.6 6-48 16L64 80C28.7 80 0 108.7 0 144s28.7 64 64 64l82 0c-1.3 5.1-2 10.5-2 16 0 25.3 14.7 47.2 36 57.6-2.6 7-4 14.5-4 22.4 0 20 9.2 37.9 23.6 49.7-4.9 9-7.6 19.4-7.6 30.3 0 35.3 28.7 64 64 64l88 0c92.8 0 168-75.2 168-168l0-48c0-92.8-75.2-168-168-168l-24 0zM256 400c-8.8 0-16-7.2-16-16s7.2-16 16-16l64 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-64 0zM240 224c0 5.5 .7 10.9 2 16l-34 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l32 0 0 16zm24 64l40 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-64 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l24 0z"]],
    "calculator": [384, 512, [128425], "f1ec", ["M48 176l0 272c0 8.8 7.2 16 16 16l256 0c8.8 0 16-7.2 16-16l0-272-288 0zm80 56a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm0 88a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zM80 408c0-13.3 10.7-24 24-24l88 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-88 0c-13.3 0-24-10.7-24-24zM216 232a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm0 88a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm88-88a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm0 88a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm-48 88c0-13.3 10.7-24 24-24s24 10.7 24 24-10.7 24-24 24-24-10.7-24-24z", "M336 176l0 272c0 8.8-7.2 16-16 16L64 464c-8.8 0-16-7.2-16-16l0-272 288 0zm0-48l-288 0 0-64c0-8.8 7.2-16 16-16l256 0c8.8 0 16 7.2 16 16l0 64zm48 0l0-64c0-35.3-28.7-64-64-64L64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-320zM80 232a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm24 64a24 24 0 1 0 0 48 24 24 0 1 0 0-48zM80 408c0 13.3 10.7 24 24 24l88 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-88 0c-13.3 0-24 10.7-24 24zM192 208a24 24 0 1 0 0 48 24 24 0 1 0 0-48zM168 320a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zM280 208a24 24 0 1 0 0 48 24 24 0 1 0 0-48zM256 320a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm24 64c-13.3 0-24 10.7-24 24s10.7 24 24 24 24-10.7 24-24-10.7-24-24-24z"]],
    "oil-temperature": [640, 512, ["oil-temp"], "f614", ["M288 288a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M578.9 375.2c5.8-10.6 20.5-10.6 26.3 0 14.2 26.2 34.9 67.8 34.9 88.8 0 32-21.5 48-48 48s-48-21.5-48-48c0-21 20.7-62.6 34.9-88.8zm36.2-155c18.1-3.9 30.7 17.6 18.4 31.5L451.1 458.3c-12.1 13.8-29.6 21.7-48 21.7l-259.1 0-4.9-.2C114.9 477.3 96 456.8 96 432l0-21.3-67.5-30C12.3 373.4 1.4 357.9 .1 340.3L0 336.8 0 272c0-26.5 21.5-48 48-48l161.2 0c-8.9 15.3-14.7 32.7-16.5 51.2l-45.4 0 0 153.6 255.9 0c3.7 0 7.2-1.6 9.6-4.3l118.1-133.9-72.1 15.5c-4 .9-8.1 1.2-12.2 1.1 .9-6.2 1.4-12.6 1.4-19.1 0-11.9-1.7-23.4-4.7-34.4l4.7 2.4 167-35.8zM392 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0 0 48 48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0 0 67.7c32.5 10.2 56 40.5 56 76.3 0 44.2-35.8 80-80 80s-80-35.8-80-80c0-35.8 23.5-66.2 56-76.3L296 24c0-13.3 10.7-24 24-24l72 0zM48 336.8l48 21.3 0-86.1-48 0 0 64.8zM320 256a32 32 0 1 0 0 64 32 32 0 1 0 0-64z"]],
    "minus": [448, 512, [8211, 8722, 10134, "subtract"], "f068", ["", "M0 256c0-13.3 10.7-24 24-24l400 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 280c-13.3 0-24-10.7-24-24z"]],
    "message-arrow-down": [512, 512, ["comment-alt-arrow-down"], "e1db", ["M48 128l0 224c0 26.5 21.5 48 48 48l56 0c10.4 0 19.3 6.6 22.6 15.9 .9 2.5 1.4 5.2 1.4 8.1l0 49.7c32.7-23.1 63.3-44.7 91.9-64.9 8.1-5.7 17.8-8.8 27.7-8.8L416 400c26.5 0 48-21.5 48-48l0-224c0-26.5-21.5-48-48-48L96 80c-26.5 0-48 21.5-48 48zM167 231c9.4-9.4 24.6-9.4 33.9 0l31 31 0-102.1c0-13.3 10.7-24 24-24s24 10.7 24 24l0 102.1 31-31c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-72 72c-9.4 9.4-24.6 9.4-33.9 0l-72-72c-9.4-9.4-9.4-24.6 0-33.9z", "M203.7 512.9l0 0 91.9-64.9 120.4 0c53 0 96-43 96-96l0-224c0-53-43-96-96-96L96 32C43 32 0 75 0 128L0 352c0 53 43 96 96 96l32 0 0 72c0 9 5 17.2 13 21.3s17.6 3.5 24.9-1.7l37.8-26.7zM295.6 400c-9.9 0-19.6 3.1-27.7 8.8-28.6 20.2-59.3 41.8-91.9 64.9l0-49.7c0-2.8-.5-5.6-1.4-8.1-3.3-9.3-12.2-15.9-22.6-15.9l-56 0c-26.5 0-48-21.5-48-48l0-224c0-26.5 21.5-48 48-48l320 0c26.5 0 48 21.5 48 48l0 224c0 26.5-21.5 48-48 48l-120.4 0zM239 337c9.4 9.4 24.6 9.4 33.9 0l72-72c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-31 31 0-102.1c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 102.1-31-31c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l72 72z"]],
    "shoe": [640, 512, [], "e6d8", ["M48 224l0 96 521.2 0c-7.9-8.1-17.5-14.5-28.5-18.8l-92.8-35.7c-9.3-3.6-18.3-7.7-27.1-12.4L393 281c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l21.2-21.2c-2.3-1.9-4.5-3.9-6.8-5.9l-25-22.5-27.5 27.5c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l25.8-25.8-53.9-48.5C239.6 180.3 181 224 114.3 224L48 224z", "M144 368l-96 0 0 32 96 0 0-32zM48 320l521.2 0c-7.9-8.1-17.5-14.5-28.5-18.8l-92.8-35.7c-9.3-3.6-18.3-7.7-27.1-12.4L393 281c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l21.2-21.2c-2.3-1.9-4.5-3.9-6.8-5.9l-25-22.5-27.5 27.5c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l25.8-25.8-53.9-48.5C239.6 180.3 181 224 114.3 224l-66.3 0 0 96zm543.6 48l-356.3 0 47.1 23.6c11.1 5.6 23.4 8.4 35.8 8.4l273.8 0 0-24.1c0-2.7-.1-5.3-.4-7.9zM255.8 64c10.4 0 20.5 3.9 28.2 10.8L405.6 184.3c17.4 15.7 37.6 28.1 59.5 36.5l92.8 35.7c49.4 19 82.1 66.5 82.1 119.5l0 24.1c0 26.5-21.5 48-48 48l-273.8 0c-19.9 0-39.5-4.6-57.2-13.5-12.2-6.1-35.2-17.6-69-34.5 0 15.7-7.5 29.6-19.2 38.4-8 6-18 9.6-28.8 9.6l-96 0c-26.5 0-48-21.5-48-48L0 224c0-26.5 21.5-48 48-48l66.3 0c46 0 86.4-30.5 99-74.7l1.9-6.7C220.4 76.5 237 64 255.8 64z"]],
    "game-board-simple": [448, 512, ["game-board-alt"], "f868", ["M48 256l0 160c0 8.8 7.2 16 16 16l160 0 0-176-176 0zM224 80l0 176 176 0 0-160c0-8.8-7.2-16-16-16L224 80z", "M224 432L64 432c-8.8 0-16-7.2-16-16l0-160 176 0 0 176zM400 256l-176 0 0-176 160 0c8.8 0 16 7.2 16 16l0 160zM64 480l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416c0 33.1 25.2 60.4 57.5 63.7L64 480z"]],
    "arrow-turn-left": [512, 512, [], "e632", ["", "M464 424c0 13.3 10.7 24 24 24s24-10.7 24-24l0-96c0-53-43-96-96-96l-334.1 0 95-95c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0L7 239c-4.5 4.5-7 10.6-7 17s2.5 12.5 7 17L143 409c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-95-95 334.1 0c26.5 0 48 21.5 48 48l0 96z"]],
    "circle-4": [512, 512, [], "e0f1", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm128-88c0-13.3 10.7-24 24-24s24 10.7 24 24l0 88 48 0 0-88c0-13.3 10.7-24 24-24s24 10.7 24 24l0 88 8 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-8 0 0 40c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-40-56 0c-22.1 0-40-17.9-40-40l0-96z", "M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM200 144c-13.3 0-24 10.7-24 24l0 96c0 22.1 17.9 40 40 40l56 0 0 40c0 13.3 10.7 24 24 24s24-10.7 24-24l0-40 8 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-8 0 0-88c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 88-48 0 0-88c0-13.3-10.7-24-24-24z"]],
    "hammer-war": [448, 512, [], "f6e4", ["M48 87.3l0 161.3 169.2-24.2c4.5-.6 9.1-.6 13.6 0l169.2 24.2 0-161.3-169.2 24.2c-4.5 .6-9.1 .6-13.6 0L48 87.3z", "M224 0c13.3 0 24 10.7 24 24l0 36.6 163.5-23.4C430.8 34.5 448 49.4 448 68.9l0 198.2c0 19.5-17.2 34.4-36.5 31.7L248 275.4 248 520c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-244.6-163.5 23.4C17.2 301.5 0 286.6 0 267.1L0 68.9C0 49.4 17.2 34.5 36.5 37.2L200 60.6 200 24c0-13.3 10.7-24 24-24zM400 248.7l0-161.3-169.2 24.2c-4.5 .6-9.1 .6-13.6 0L48 87.3 48 248.7 217.2 224.5c4.5-.6 9.1-.6 13.6 0L400 248.7z"]],
    "light-emergency": [448, 512, [], "e41f", ["M48 368l0 64 352 0 0-64-352 0zM96 208l0 112 256 0 0-112c0-70.7-57.3-128-128-128S96 137.3 96 208zm32-8c0-48.6 39.4-88 88-88 13.3 0 24 10.7 24 24s-10.7 24-24 24c-22.1 0-40 17.9-40 40 0 13.3-10.7 24-24 24s-24-10.7-24-24z", "M448 368c0-26.5-21.5-48-48-48l0-112c0-97.2-78.8-176-176-176S48 110.8 48 208l0 112c-26.5 0-48 21.5-48 48l0 64c0 26.5 21.5 48 48 48l352 0c26.5 0 48-21.5 48-48l0-64zM352 208l0 112-256 0 0-112c0-70.7 57.3-128 128-128s128 57.3 128 128zM48 368l352 0 0 64-352 0 0-64zM176 200c0-22.1 17.9-40 40-40 13.3 0 24-10.7 24-24s-10.7-24-24-24c-48.6 0-88 39.4-88 88 0 13.3 10.7 24 24 24s24-10.7 24-24z"]],
    "arrow-up-z-a": [512, 512, ["sort-alpha-up-alt"], "f882", ["", "M288.5 56c0 13.3 10.7 24 24 24l86.1 0-103 103c-6.9 6.9-8.9 17.2-5.2 26.2S302.8 224 312.5 224l144 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-86.1 0 103-103c6.9-6.9 8.9-17.2 5.2-26.2S466.2 32 456.5 32l-144 0c-13.3 0-24 10.7-24 24zM406 285.3c-4.1-8.1-12.4-13.3-21.5-13.3s-17.4 5.1-21.5 13.3l-80 160c-5.9 11.9-1.1 26.3 10.7 32.2s26.3 1.1 32.2-10.7l13.4-26.7 85.2 0c1.7 0 3.3-.2 4.9-.5L443 466.7c5.9 11.9 20.3 16.7 32.2 10.7s16.7-20.3 10.7-32.2l-80-160zm-21.5 64.4l21.2 42.3-42.3 0 21.2-42.3zM145.5 39c-9.4-9.4-24.6-9.4-33.9 0l-88 88c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l47-47 0 342.1c0 13.3 10.7 24 24 24s24-10.7 24-24l0-342.1 47 47c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-88-88z"]],
    "microphone-slash": [576, 512, [], "f131", ["M240 96l0 78.2 94.4 94.4c1.1-4 1.6-8.2 1.6-12.5l0-160c0-26.5-21.5-48-48-48s-48 21.5-48 48z", "M41-24.9c-9.4-9.4-24.6-9.4-33.9 0S-2.3-.3 7 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9L428.2 362.4C450.7 332.8 464 296 464 256l0-40c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 40c0 26.7-8.2 51.5-22.2 72l-23.2-23.2c8.5-14.3 13.3-31 13.3-48.8l0-160c0-53-43-96-96-96s-96 43-96 96l0 30.2-151-151zm199 199L240 96c0-26.5 21.5-48 48-48s48 21.5 48 48l0 160c0 4.3-.6 8.5-1.6 12.5L240 174.2zM350.7 420.5l-38.7-38.7c-7.8 1.5-15.8 2.2-23.9 2.2-70.7 0-128-57.3-128-128l0-26.2-35.1-35.1c-7.7 4-12.9 12-12.9 21.3l0 40c0 89.1 66.2 162.7 152 174.4l0 33.6-48 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l144 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0 0-33.6c13.4-1.8 26.4-5.2 38.7-9.9z"]],
    "square-pen": [448, 512, ["pen-square", "pencil-square"], "f14b", ["M48 96l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16zM96.5 364l15-60.1c1.4-5.6 4.3-10.8 8.4-14.9l91.5-91.6 71 71-91.6 91.5c-4.1 4.1-9.2 7-14.9 8.4l-60.1 15c-5.5 1.4-11.2-.2-15.2-4.2s-5.6-9.7-4.2-15.2zM245.4 163.5l23.8-23.8c15.6-15.6 40.9-15.6 56.6 0l14.4 14.4c15.6 15.6 15.6 40.9 0 56.6l-23.8 23.8-71-71z", "M64 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm325.8 43.7l14.4 14.4c15.6 15.6 15.6 40.9 0 56.6l-23.8 23.8-71-71 23.8-23.8c15.6-15.6 40.9-15.6 56.6 0zM119.9 289l91.5-91.6 71 71-91.6 91.5c-4.1 4.1-9.2 7-14.9 8.4l-60.1 15c-5.5 1.4-11.2-.2-15.2-4.2s-5.6-9.7-4.2-15.2l15-60.1c1.4-5.6 4.3-10.8 8.4-14.9z"]],
    "bell-plus": [448, 512, [], "f849", ["M55.6 368l336.9 0-12.9-22.1C356.3 306 344 260.6 344 214.5l0-14.5c0-66.3-53.7-120-120-120S104 133.7 104 200l0 14.5c0 46.2-12.3 91.5-35.5 131.4L55.6 368zM136 224c0-13.3 10.7-24 24-24l40 0 0-40c0-13.3 10.7-24 24-24s24 10.7 24 24l0 40 40 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-40 0 0 40c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-40-40 0c-13.3 0-24-10.7-24-24z", "M224 0c-13.3 0-24 10.7-24 24l0 9.7C118.6 45.3 56 115.4 56 200l0 14.5c0 37.7-10 74.7-29 107.3L5.1 359.2C1.8 365 0 371.5 0 378.2 0 399.1 16.9 416 37.8 416l372.4 0c20.9 0 37.8-16.9 37.8-37.8 0-6.7-1.8-13.3-5.1-19L421 321.7c-19-32.6-29-69.6-29-107.3l0-14.5c0-84.6-62.6-154.7-144-166.3l0-9.7c0-13.3-10.7-24-24-24zM392.4 368l-336.9 0 12.9-22.1C91.7 306 104 260.6 104 214.5l0-14.5c0-66.3 53.7-120 120-120s120 53.7 120 120l0 14.5c0 46.2 12.3 91.5 35.5 131.4L392.4 368zM156.1 464c9.9 28 36.6 48 67.9 48s58-20 67.9-48l-135.8 0zM136 224c0 13.3 10.7 24 24 24l40 0 0 40c0 13.3 10.7 24 24 24s24-10.7 24-24l0-40 40 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-40 0 0-40c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 40-40 0c-13.3 0-24 10.7-24 24z"]],
    "hand-fist": [384, 512, [9994, "fist-raised"], "f6de", ["M48 256c0-17.7 14.3-32 32-32l80 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-40 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l40 0c35.3 0 64-28.7 64-64 0-.7 0-1.4 0-2 5.1 1.3 10.5 2 16 2 7.9 0 15.4-1.4 22.4-4 10.4 21.3 32.3 36 57.6 36 5.2 0 10.2-.6 15-1.8-4.4 32.4-23.8 60.1-51.1 75.9-7.4 4.3-12 12.2-12 20.8L272 488c0 13.3 10.7 24 24 24l-176 0c13.3 0 24-10.7 24-24l0-108c0-11-7.4-20.5-18-23.2-44.9-11.5-78-52.3-78-100.7zM64 96c0-8.8 7.2-16 16-16s16 7.2 16 16l0 80-16 0c-5.5 0-10.8 .6-16 1.6L64 96zm80-32c0-8.8 7.2-16 16-16s16 7.2 16 16l0 114c-5.1-1.3-10.5-2-16-2l-16 0 0-112zm80 32c0-8.8 7.2-16 16-16s16 7.2 16 16l0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80zm80 64c0-8.8 7.2-16 16-16s16 7.2 16 16l0 48c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-48z", "M80 80c8.8 0 16 7.2 16 16l0 80-16 0c-5.5 0-10.8 .6-16 1.6L64 96c0-8.8 7.2-16 16-16zm0 144l80 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-40 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l40 0c35.3 0 64-28.7 64-64 0-.7 0-1.4 0-2 5.1 1.3 10.5 2 16 2 7.9 0 15.4-1.4 22.4-4 10.4 21.3 32.3 36 57.6 36 5.2 0 10.2-.6 15-1.8-4.4 32.4-23.8 60.1-51.1 75.9-7.4 4.3-12 12.2-12 20.8L272 488c0 13.3 10.7 24 24 24s24-10.7 24-24l0-108.1c38.7-27.5 64-72.8 64-123.9l0-96c0-35.3-28.7-64-64-64-5.5 0-10.9 .7-16 2l0-2c0-35.3-28.7-64-64-64-7.9 0-15.4 1.4-22.4 4-10.4-21.3-32.3-36-57.6-36s-47.2 14.7-57.6 36c-7-2.6-14.5-4-22.4-4-35.3 0-64 28.7-64 64l0 104c0 2.3 .3 4.6 1 6.7-10.6 13.6-17 30.7-17 49.3 0 64.2 39.8 119 96 141.3L96 488c0 13.3 10.7 24 24 24s24-10.7 24-24l0-108c0-11-7.4-20.5-18-23.2-44.9-11.5-78-52.3-78-100.7 0-17.7 14.3-32 32-32zm256-32l0 16c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-48c0-8.8 7.2-16 16-16s16 7.2 16 16l0 32zM144 176l0-112c0-8.8 7.2-16 16-16s16 7.2 16 16l0 114c-5.1-1.3-10.5-2-16-2l-16 0zm80 0l0-80c0-8.8 7.2-16 16-16s16 7.2 16 16l0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16z"]],
    "pants": [512, 512, [], "e6d5", ["M41.3 444.6c-1.7 8.7 4 17.2 12.7 18.8l95.2 18.3c8.5 1.6 16.7-3.8 18.6-12.2l65.1-290.8c2.5-11 12.2-18.8 23.4-18.8s21 7.8 23.4 18.8l65.1 290.8c1.9 8.4 10.1 13.8 18.6 12.2l95.2-18.3c8.7-1.7 14.4-10.1 12.7-18.8l-62.9-316.6-48.1 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l38.5 0-7-35.1c-1.5-7.5-8.1-12.9-15.7-12.9L136.5 32c-7.6 0-14.2 5.4-15.7 12.9l-7 35.1 38.5 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48.1 0-62.9 316.6z", "M73.7 35.5C79.7 5.6 106-16 136.5-16l239.7 0C406.7-16 433 5.6 439 35.5l79.5 399.7c6.9 34.8-15.8 68.6-50.7 75.3l-95.2 18.3c-34 6.5-67-15.1-74.5-48.9L256.3 293.8 214.7 480c-7.6 33.8-40.6 55.4-74.5 48.9L44.9 510.6C10.1 503.8-12.7 470-5.8 435.2L73.7 35.5zM136.5 32c-7.6 0-14.2 5.4-15.7 12.9l-7 35.1 38.5 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48.1 0-62.9 316.6c-1.7 8.7 4 17.2 12.7 18.8l95.2 18.3c8.5 1.6 16.7-3.8 18.6-12.2l65.1-290.8c2.5-11 12.2-18.8 23.4-18.8s21 7.8 23.4 18.8l65.1 290.8c1.9 8.4 10.1 13.8 18.6 12.2l95.2-18.3c8.7-1.7 14.4-10.1 12.7-18.8l-62.9-316.6-48.1 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l38.5 0-7-35.1c-1.5-7.5-8.1-12.9-15.7-12.9L136.5 32z"]],
    "comment-sms": [512, 512, ["sms"], "f7cd", ["M48 240c0 42.8 15.1 82.4 41.2 114.7 12.2 15.1 14.1 36.1 4.8 53.2l-18 33.1 58.5-25.1c11.8-5.1 25.2-5.2 37.1-.3 25.7 10.5 54.2 16.4 84.3 16.4 117.8 0 208-88.8 208-192S373.8 48 256 48 48 136.8 48 240zm51.2-25.6c0-23 18.6-41.6 41.6-41.6l19.2 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-19.2 0c-5.3 0-9.6 4.3-9.6 9.6s4.3 9.6 9.6 9.6c23 0 41.6 18.6 41.6 41.6s-18.6 41.6-41.6 41.6l-25.6 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l25.6 0c5.3 0 9.6-4.3 9.6-9.6s-4.3-9.6-9.6-9.6c-23 0-41.6-18.6-41.6-41.6zm102.4-25.6c0-7.2 4.8-13.5 11.7-15.4s14.3 1 18 7.2l24.7 41.1 24.7-41.1c3.7-6.2 11.1-9.1 18-7.2s11.7 8.2 11.7 15.4l0 102.4c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-44.6-8.7 14.5c-2.9 4.8-8.1 7.8-13.7 7.8s-10.8-3-13.7-7.8l-8.7-14.5 0 44.6c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-102.4zm128 25.6c0-23 18.6-41.6 41.6-41.6l19.2 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-19.2 0c-5.3 0-9.6 4.3-9.6 9.6s4.3 9.6 9.6 9.6c23 0 41.6 18.6 41.6 41.6s-18.6 41.6-41.6 41.6l-25.6 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l25.6 0c5.3 0 9.6-4.3 9.6-9.6s-4.3-9.6-9.6-9.6c-23 0-41.6-18.6-41.6-41.6z", "M0 240c0 54.4 19.3 104.6 51.9 144.9L3.1 474.3c-2 3.7-3.1 7.9-3.1 12.2 0 14.1 11.4 25.5 25.5 25.5 4 0 7.8-.6 11.5-2.1L153.4 460c31.4 12.9 66.1 20 102.6 20 141.4 0 256-107.5 256-240S397.4 0 256 0 0 107.5 0 240zM94 407.9c9.3-17.1 7.4-38.1-4.8-53.2-26.1-32.2-41.2-71.9-41.2-114.7 0-103.2 90.2-192 208-192s208 88.8 208 192-90.2 192-208 192c-30.2 0-58.7-5.9-84.3-16.4-11.9-4.9-25.3-4.8-37.1 .3L76 440.9 94 407.9zm46.8-235.1c-23 0-41.6 18.6-41.6 41.6S117.8 256 140.8 256c5.3 0 9.6 4.3 9.6 9.6s-4.3 9.6-9.6 9.6l-25.6 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l25.6 0c23 0 41.6-18.6 41.6-41.6S163.8 224 140.8 224c-5.3 0-9.6-4.3-9.6-9.6s4.3-9.6 9.6-9.6l19.2 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-19.2 0zm188.8 41.6c0 23 18.6 41.6 41.6 41.6 5.3 0 9.6 4.3 9.6 9.6s-4.3 9.6-9.6 9.6l-25.6 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l25.6 0c23 0 41.6-18.6 41.6-41.6S394.2 224 371.2 224c-5.3 0-9.6-4.3-9.6-9.6s4.3-9.6 9.6-9.6l19.2 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-19.2 0c-23 0-41.6 18.6-41.6 41.6zm-98.3-33.8c-3.7-6.2-11.1-9.1-18-7.2s-11.7 8.2-11.7 15.4l0 102.4c0 8.8 7.2 16 16 16s16-7.2 16-16l0-44.6 8.7 14.5c2.9 4.8 8.1 7.8 13.7 7.8s10.8-3 13.7-7.8l8.7-14.5 0 44.6c0 8.8 7.2 16 16 16s16-7.2 16-16l0-102.4c0-7.2-4.8-13.5-11.7-15.4s-14.3 1-18 7.2l-24.7 41.1-24.7-41.1z"]],
    "head-side-gear": [512, 512, [], "e611", ["M48 224c0-97.2 78.8-176 176-176 86.6 0 158.7 62.6 173.3 145.1 .9 4.8 3.2 9.3 6.7 12.8l52.2 52.2c5 5 7.9 11.9 7.9 19 0 14.9-12 26.9-26.9 26.9L424 304c-13.3 0-24 10.7-24 24l0 48c0 22.1-17.9 40-40 40l-48 0c-13.3 0-24 10.7-24 24l0 48c0 13.3 10.7 24 24 24-187.9 0-262.5 0-224 0 13.3 0 24-10.7 24-24l0-99.9c0-18.1-7.8-34.2-18.5-46-28.3-31.2-45.5-72.6-45.5-118.1zm56.5-46c-2.6 6.8 .5 14.3 6.8 18l2.9 1.7c9.2 5.3 13.7 15.8 13.7 26.4s-4.5 21.1-13.7 26.4l-3 1.7c-6.3 3.6-9.5 11.1-6.8 17.9 2.1 5.5 4.6 10.7 7.4 15.8l2.4 4.1c3.1 5.1 6.4 9.9 10.1 14.5 4.6 5.7 12.7 6.7 19 3l2.9-1.7c9.2-5.3 20.4-4 29.6 1.3S192 321.6 192 332.2l0 3.4c0 7.3 4.9 13.8 12.1 14.9 6.5 1 13.1 1.5 19.9 1.5s13.4-.5 19.9-1.5c7.2-1.1 12.1-7.6 12.1-14.9l0-3.4c0-10.6 6.9-19.8 16.1-25.1s20.4-6.6 29.6-1.3l2.9 1.7c6.3 3.6 14.4 2.6 19-3 3.7-4.6 7.1-9.4 10.1-14.5l2.4-4.2c2.8-5.1 5.3-10.3 7.4-15.8 2.6-6.8-.5-14.3-6.8-17.9l-3-1.7c-9.2-5.3-13.7-15.8-13.7-26.4s4.5-21.1 13.7-26.4l3-1.7c6.3-3.6 9.5-11.1 6.8-18-2.1-5.5-4.6-10.8-7.4-15.9l-2.3-4c-3.1-5.1-6.5-9.9-10.2-14.5-4.6-5.7-12.7-6.7-19-3l-2.9 1.7c-9.2 5.3-20.4 4-29.6-1.3S256 126.4 256 115.8l0-3.4c0-7.3-4.9-13.8-12.1-14.9-6.5-1-13.1-1.5-19.9-1.5s-13.4 .5-19.9 1.5c-7.2 1.1-12.1 7.6-12.1 14.9l0 3.4c0 10.6-6.9 19.8-16.1 25.1s-20.4 6.6-29.6 1.3l-2.9-1.7c-6.3-3.6-14.4-2.6-19 3-3.7 4.6-7.1 9.5-10.2 14.6l-2.3 3.9c-2.8 5.1-5.3 10.4-7.4 15.9zM264 224a40 40 0 1 1 -80 0 40 40 0 1 1 80 0z", "M224 0C100.3 0 0 100.3 0 224 0 281.8 22 334.6 58 374.3 62.2 379 64 384 64 388.1L64 488c0 13.3 10.7 24 24 24s24-10.7 24-24l0-99.9c0-18.1-7.8-34.2-18.5-46-28.3-31.2-45.5-72.6-45.5-118.1 0-97.2 78.8-176 176-176 86.6 0 158.7 62.6 173.3 145.1 .9 4.8 3.2 9.3 6.7 12.8l52.2 52.2c5 5 7.9 11.9 7.9 19 0 14.9-12 26.9-26.9 26.9L424 304c-13.3 0-24 10.7-24 24l0 48c0 22.1-17.9 40-40 40l-48 0c-13.3 0-24 10.7-24 24l0 48c0 13.3 10.7 24 24 24s24-10.7 24-24l0-24 24 0c48.6 0 88-39.4 88-88l0-24.8c36.2-5.3 64-36.5 64-74.1 0-19.9-7.9-38.9-21.9-53l-47-47C421.5 75.9 331.7 0 224 0zM336.6 195.9c6.3-3.6 9.5-11.1 6.8-18-2.1-5.5-4.6-10.8-7.4-15.9l-2.3-4c-3.1-5.1-6.5-9.9-10.2-14.5-4.6-5.7-12.7-6.7-19-3l-2.9 1.7c-9.2 5.3-20.4 4-29.6-1.3S256 126.4 256 115.8l0-3.4c0-7.3-4.9-13.8-12.1-14.9-6.5-1-13.1-1.5-19.9-1.5s-13.4 .5-19.9 1.5c-7.2 1.1-12.1 7.6-12.1 14.9l0 3.4c0 10.6-6.9 19.8-16.1 25.1s-20.4 6.6-29.6 1.3l-2.9-1.7c-6.3-3.6-14.4-2.6-19 3-3.7 4.6-7.1 9.5-10.2 14.6l-2.3 3.9c-2.8 5.1-5.3 10.4-7.4 15.9-2.6 6.8 .5 14.3 6.8 18l2.9 1.7c9.2 5.3 13.7 15.8 13.7 26.4s-4.5 21.1-13.7 26.4l-3 1.7c-6.3 3.6-9.5 11.1-6.8 17.9 2.1 5.5 4.6 10.7 7.4 15.8l2.4 4.1c3.1 5.1 6.4 9.9 10.1 14.5 4.6 5.7 12.7 6.7 19 3l2.9-1.7c9.2-5.3 20.4-4 29.6 1.3S192 321.6 192 332.2l0 3.4c0 7.3 4.9 13.8 12.1 14.9 6.5 1 13.1 1.5 19.9 1.5s13.4-.5 19.9-1.5c7.2-1.1 12.1-7.6 12.1-14.9l0-3.4c0-10.6 6.9-19.8 16.1-25.1s20.4-6.6 29.6-1.3l2.9 1.7c6.3 3.6 14.4 2.6 19-3 3.7-4.6 7.1-9.4 10.1-14.5l2.4-4.2c2.8-5.1 5.3-10.3 7.4-15.8 2.6-6.8-.5-14.3-6.8-17.9l-3-1.7c-9.2-5.3-13.7-15.8-13.7-26.4s4.5-21.1 13.7-26.4l3-1.7zM184 224a40 40 0 1 1 80 0 40 40 0 1 1 -80 0z"]],
    "transporter-1": [576, 512, [], "e043", ["M256 167.1c9.9-4.6 20.8-7.1 32-7.1s22.1 2.5 32 7.1l0 136.9-64 0c0-45.6 0-91.3 0-136.9z", "M344 24a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zM320 304l48 0 0-86.4 60.5 84.4c7.7 10.8 22.7 13.2 33.5 5.5s13.3-22.7 5.5-33.5L388.3 163.5C365.1 131.2 327.8 112 288 112s-77.2 19.2-100.3 51.5L108.5 274c-7.7 10.8-5.2 25.8 5.5 33.5s25.8 5.2 33.5-5.5l60.5-84.4 0 86.4 48 0 0-136.9c9.9-4.6 20.8-7.1 32-7.1s22.1 2.5 32 7.1L320 304zm48 192l-216 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l272 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-56 0zM536.7 134.6c-1.1-3.9-4.7-6.6-8.7-6.6s-7.6 2.7-8.7 6.6l-7.3 25.4-25.4 7.3c-3.9 1.1-6.6 4.7-6.6 8.7s2.7 7.6 6.6 8.7l25.4 7.3 7.3 25.4c1.1 3.9 4.7 6.6 8.7 6.6s7.6-2.7 8.7-6.6l7.3-25.4 25.4-7.3c3.9-1.1 6.6-4.7 6.6-8.7s-2.7-7.6-6.6-8.7l-25.4-7.3-7.3-25.4zm-480 192c-1.1-3.9-4.7-6.6-8.7-6.6s-7.6 2.7-8.7 6.6L32 352 6.6 359.3C2.7 360.4 0 363.9 0 368s2.7 7.6 6.6 8.7L32 384 39.3 409.4c1.1 3.9 4.7 6.6 8.7 6.6s7.6-2.7 8.7-6.6L64 384 89.4 376.7c3.9-1.1 6.6-4.7 6.6-8.7s-2.7-7.6-6.6-8.7L64 352 56.7 326.6zM192 368c0 8.8 7.2 16 16 16l160 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-160 0c-8.8 0-16 7.2-16 16zm0 64c0 8.8 7.2 16 16 16l160 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-160 0c-8.8 0-16 7.2-16 16z"]],
    "scanner-touchscreen": [512, 512, [], "f48a", ["M48 160l0 288c0 8.8 7.2 16 16 16l192 0c8.8 0 16-7.2 16-16l0-288c0-8.8-7.2-16-16-16L64 144c-8.8 0-16 7.2-16 16zm32 40c0-13.3 10.7-24 24-24l112 0c13.3 0 24 10.7 24 24l0 208c0 13.3-10.7 24-24 24l-112 0c-13.3 0-24-10.7-24-24l0-208zm48 24l0 160 64 0 0-160-64 0z", "M120-32C106.7-32 96-21.3 96-8l0 56 48 0 0-56c0-13.3-10.7-24-24-24zM392 288c13.3 0 24-10.7 24-24L416-8c0-13.3-10.7-24-24-24S368-21.3 368-8l0 272c0 13.3 10.7 24 24 24zM320-16c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 68.6c11.6 3.4 22.3 8.7 32 15.4L320-16zM256 0c0-17.7-14.3-32-32-32S192-17.7 192 0l0 48 64 0 0-48zM448 0l0 256c0 17.7 14.3 32 32 32s32-14.3 32-32L512 0c0-17.7-14.3-32-32-32S448-17.7 448 0zM256 144c8.8 0 16 7.2 16 16l0 288c0 8.8-7.2 16-16 16L64 464c-8.8 0-16-7.2-16-16l0-288c0-8.8 7.2-16 16-16l192 0zM64 96C28.7 96 0 124.7 0 160L0 448c0 35.3 28.7 64 64 64l192 0c35.3 0 64-28.7 64-64l0-288c0-35.3-28.7-64-64-64L64 96zm64 128l64 0 0 160-64 0 0-160zm-24-48c-13.3 0-24 10.7-24 24l0 208c0 13.3 10.7 24 24 24l112 0c13.3 0 24-10.7 24-24l0-208c0-13.3-10.7-24-24-24l-112 0z"]],
    "flask-round-potion": [384, 512, ["flask-potion"], "f6e1", ["M50.3 345.7l23.5-11.8c18.3-9.2 38.5-13.9 59-13.9 23.9 0 47.4 6.5 67.9 18.8l5 3C234.2 358.9 267 368 300.3 368l27.5 0c-19.8 55.9-73.1 96-135.8 96-70.8 0-129.6-51-141.7-118.3z", "M88 48l8 0 0 105.7C38.6 186.9 0 248.9 0 320 0 426 86 512 192 512s192-86 192-192c0-71.1-38.6-133.1-96-166.3l0-105.7 8 0c13.3 0 24-10.7 24-24S309.3 0 296 0L88 0C74.7 0 64 10.7 64 24S74.7 48 88 48zm56 120.2l0-120.2 96 0 0 120.2c0 9.3 5.3 17.7 13.7 21.7 48.7 23.1 82.3 72.7 82.3 130.2l-35.7 0c-24.6 0-48.8-6.7-70-19.4l-5-3c-28-16.8-60-25.6-92.6-25.6-27.9 0-55.5 6.5-80.5 19l-1.6 .8c9-45.1 39-82.7 79.5-101.9 8.4-4 13.7-12.4 13.7-21.7zM50.3 345.7l23.5-11.8c18.3-9.2 38.5-13.9 59-13.9 23.9 0 47.4 6.5 67.9 18.8l5 3C234.2 358.9 267 368 300.3 368l27.5 0c-19.8 55.9-73.1 96-135.8 96-70.8 0-129.6-51-141.7-118.3z"]],
    "car-bolt": [512, 512, [], "e341", ["M48 256l0 112 416 0 0-112c0-8.8-7.2-16-16-16l-58.1 0c1.3-5.2 2.1-10.6 2.1-16.1 0-11.6-3.1-22.5-8.5-31.9l-96.5 0-5 16 45.5 0c9.1 0 16.5 7.4 16.5 16.5 0 4.8-2.1 9.3-5.7 12.5L227.9 332.6c-2.5 2.2-5.7 3.4-9.1 3.4-9.3 0-16-9.1-13.2-18l24.4-78-45.5 0c-9.1 0-16.5-7.4-16.5-16.5 0-4.8 2.1-9.3 5.7-12.5l22-19.1-67.1 0c-5.6 9.6-8.6 20.7-8.6 32.1 0 5.5 .7 10.8 2 15.9l-58 0c-8.8 0-16 7.2-16 16zm96 48a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm288 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M118.4 112.8L92 192 128.6 192c-5.6 9.6-8.6 20.7-8.6 32.1 0 5.5 .7 10.8 2 15.9l-58 0c-8.8 0-16 7.2-16 16l0 112 416 0 0-112c0-8.8-7.2-16-16-16l-58.1 0c1.3-5.2 2.1-10.6 2.1-16.1 0-11.6-3.1-22.5-8.5-31.9l36.6 0-26.4-79.2C387.1 93.2 368.8 80 348.1 80L163.9 80c-20.7 0-39 13.2-45.5 32.8zM39.8 196.7l33-99.1C85.9 58.4 122.6 32 163.9 32l184.2 0c41.3 0 78 26.4 91.1 65.6l33 99.1c23.3 9.5 39.8 32.5 39.8 59.3l0 200c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-40-416 0 0 40c0 13.3-10.7 24-24 24S0 469.3 0 456L0 256c0-26.8 16.4-49.7 39.8-59.3zM112 272a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm256 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM184.5 240c-9.1 0-16.5-7.4-16.5-16.5 0-4.8 2.1-9.3 5.7-12.5l110.4-95.7c2.5-2.2 5.7-3.4 9.1-3.4 9.3 0 16 9.1 13.2 18l-24.4 78 45.5 0c9.1 0 16.5 7.4 16.5 16.5 0 4.8-2.1 9.3-5.7 12.5L227.9 332.6c-2.5 2.2-5.7 3.4-9.1 3.4-9.3 0-16-9.1-13.2-18l24.4-78-45.5 0z"]],
    "table-rows": [448, 512, ["rows"], "e292", ["M128 80l0 152 272 0 0-136c0-8.8-7.2-16-16-16L128 80zm0 200l0 152 256 0c8.8 0 16-7.2 16-16l0-136-272 0z", "M384 432l-256 0 0-152 272 0 0 136c0 8.8-7.2 16-16 16zm16-200l-272 0 0-152 256 0c8.8 0 16 7.2 16 16l0 136zM0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416z"]],
    "cloud-slash": [576, 512, [], "e137", ["M170.3 104.3c19.1-15.2 43.4-24.3 69.7-24.3 37.7 0 71 18.6 91.3 47.1 6.7 9.5 19.3 12.8 29.8 7.8 9.3-4.4 19.7-6.9 30.8-6.9 39.8 0 72 32.2 72 72 0 14.1-4 27.2-11 38.3-4.1 6.5-4.8 14.6-2 21.7s9 12.5 16.5 14.3c34.8 8.7 60.5 40.2 60.5 77.6 0 29.8-16.3 55.8-40.5 69.6L170.3 104.3z", "M41-25C31.6-34.3 16.4-34.3 7-25S-2.3-.4 7 9L535 537c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-46.7-46.7c32.5-23.2 53.8-61.3 53.8-104.3 0-49.9-28.5-93-70.1-114.2 4-11.9 6.1-24.6 6.1-37.8 0-66.3-53.7-120-120-120-11.5 0-22.7 1.6-33.3 4.7-29.3-32.3-71.6-52.7-118.7-52.7-39.6 0-75.9 14.4-103.8 38.2L41-25zM170.3 104.3c19.1-15.2 43.4-24.3 69.7-24.3 37.7 0 71 18.6 91.3 47.1 6.7 9.5 19.3 12.8 29.8 7.8 9.3-4.4 19.7-6.9 30.8-6.9 39.8 0 72 32.2 72 72 0 14.1-4 27.2-11 38.3-4.1 6.5-4.8 14.6-2 21.7s9 12.5 16.5 14.3c34.8 8.7 60.5 40.2 60.5 77.6 0 29.8-16.3 55.8-40.5 69.6L170.3 104.3zM362.2 432L144 432c-53 0-96-43-96-96 0-42.7 27.9-79 66.6-91.4 11.8-3.8 18.8-16 16.1-28.1-1.3-6-2.2-12.2-2.5-18.5L84.5 154.3c-2.9 12.1-4.5 24.7-4.5 37.7 0 4.9 .2 9.8 .7 14.6-47.8 23.4-80.7 72.5-80.7 129.4 0 79.5 64.5 144 144 144l266.2 0-48-48z"]],
    "face-hand-yawn": [512, 512, [], "e379", ["M48 256c0 41.1 11.9 79.4 32.5 111.7 4.1-35.8 34.6-63.7 71.5-63.7 3.1 0 6.2 .2 9.2 .6 7.4-45.7 47-80.6 94.8-80.6 48.2 0 88 35.5 94.9 81.7 15.7 1.5 31 8.3 43 20.3 18.1 18.1 24.3 43.7 18.6 66.9 32-36.6 51.4-84.5 51.4-136.9 0-114.9-93.1-208-208-208S48 141.1 48 256zm60.8-49.6c-8-10.6-5.8-25.6 4.8-33.6l64-48c10.6-8 25.6-5.8 33.6 4.8s5.8 25.6-4.8 33.6l-64 48c-10.6 8-25.6 5.8-33.6-4.8zm192-76.8c8-10.6 23-12.8 33.6-4.8l64 48c10.6 8 12.8 23 4.8 33.6s-23 12.8-33.6 4.8l-64-48c-10.6-8-12.8-23-4.8-33.6z", "M48 256C48 141.1 141.1 48 256 48s208 93.1 208 208c0 52.4-19.4 100.3-51.4 136.9-1 4-2.3 8-4 11.8 .5 .4 .9 .9 1.4 1.4 10.8 10.8 17.3 24.1 19.7 38.1 50.6-46.8 82.4-113.7 82.4-188.1 0-141.4-114.6-256-256-256S0 114.6 0 256c0 73.2 30.7 139.2 80 185.9L80 376c0-2.8 .2-5.6 .5-8.3-20.6-32.3-32.5-70.6-32.5-111.7zm208-32c-47.8 0-87.4 34.9-94.8 80.6 15.2 2 29 8.7 39.7 18.6l29.1-29.1c27.6-27.6 72.3-27.6 99.9 0 3.6 3.6 6.7 7.4 9.3 11.5 3.9-.3 7.8-.2 11.7 .2-6.9-46.2-46.8-81.7-94.9-81.7zm-44.8-94.4c-8-10.6-23-12.8-33.6-4.8l-64 48c-10.6 8-12.8 23-4.8 33.6s23 12.8 33.6 4.8l64-48c10.6-8 12.8-23 4.8-33.6zm94.4 33.6l64 48c10.6 8 25.6 5.8 33.6-4.8s5.8-25.6-4.8-33.6l-64-48c-10.6-8-25.6-5.8-33.6 4.8s-5.8 25.6 4.8 33.6zM128 376l0 98.2c0 56.2 45.6 101.8 101.8 101.8 27 0 52.9-10.7 72-29.8L376 472c8.8-8.8 8.8-23.2 0-32s-23.2-8.8-32 0l-32 32c-4.4 4.4-11.6 4.4-16 0s-4.4-11.6 0-16l64-64c8.8-8.8 8.8-23.2 0-32s-23.2-8.8-32 0l-64 64c-4.4 4.4-11.6 4.4-16 0s-4.4-11.6 0-16l48-48c8.8-8.8 8.8-23.2 0-32s-23.2-8.8-32 0l-81.2 81.2c-2.5 2.5-6.8 .7-6.8-2.8l0-30.3c0-13.3-10.7-24-24-24s-24 10.7-24 24z"]],
    "tickets": [640, 512, [], "e658", ["M144 96l0 28.9c28.7 16.6 48 47.6 48 83.1s-19.3 66.6-48 83.1l0 28.9c0 8.8 7.2 16 16 16l384 0c8.8 0 16-7.2 16-16l0-28.9c-28.7-16.6-48-47.6-48-83.1s19.3-66.6 48-83.1L560 96c0-8.8-7.2-16-16-16L160 80c-8.8 0-16 7.2-16 16zm96 72c0-22.1 17.9-40 40-40l144 0c22.1 0 40 17.9 40 40l0 80c0 22.1-17.9 40-40 40l-144 0c-22.1 0-40-17.9-40-40l0-80zm48 8l0 64 128 0 0-64-128 0z", "M160 80l384 0c8.8 0 16 7.2 16 16l0 28.9c-28.7 16.6-48 47.6-48 83.1s19.3 66.6 48 83.1l0 28.9c0 8.8-7.2 16-16 16l-384 0c-8.8 0-16-7.2-16-16l0-28.9c28.7-16.6 48-47.6 48-83.1s-19.3-66.6-48-83.1L144 96c0-8.8 7.2-16 16-16zm0-48c-35.3 0-64 28.7-64 64l0 48c0 8.8 7.4 15.7 15.7 18.6 18.8 6.5 32.3 24.4 32.3 45.4s-13.5 38.9-32.3 45.4C103.4 256.3 96 263.2 96 272l0 48c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-48c0-8.8-7.4-15.7-15.7-18.6-18.8-6.5-32.3-24.4-32.3-45.4s13.5-38.9 32.3-45.4c8.3-2.9 15.7-9.8 15.7-18.6l0-48c0-35.3-28.7-64-64-64L160 32zM24 128c-13.3 0-24 10.7-24 24L0 408c0 39.8 32.2 72 72 72l416 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L72 432c-13.3 0-24-10.7-24-24l0-256c0-13.3-10.7-24-24-24zM416 240l-128 0 0-64 128 0 0 64zM240 168l0 80c0 22.1 17.9 40 40 40l144 0c22.1 0 40-17.9 40-40l0-80c0-22.1-17.9-40-40-40l-144 0c-22.1 0-40 17.9-40 40z"]],
    "sim-card": [384, 512, [], "f7c4", ["M48 64l0 384c0 8.8 7.2 16 16 16l256 0c8.8 0 16-7.2 16-16l0-322.7c0-4.2-1.7-8.3-4.7-11.3L270.1 52.7c-3-3-7.1-4.7-11.3-4.7L64 48c-8.8 0-16 7.2-16 16zM96 272c0-17.7 14.3-32 32-32l56 0 0 72-88 0 0-40zm0 88l56 0 0 56-24 0c-17.7 0-32-14.3-32-32l0-24zm104 0l88 0 0 24c0 17.7-14.3 32-32 32l-56 0 0-56zm32-120l24 0c17.7 0 32 14.3 32 32l0 40-56 0 0-72z", "M336 125.3L336 448c0 8.8-7.2 16-16 16L64 464c-8.8 0-16-7.2-16-16L48 64c0-8.8 7.2-16 16-16l194.7 0c4.2 0 8.3 1.7 11.3 4.7l61.3 61.3c3 3 4.7 7.1 4.7 11.3zM64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-322.7c0-17-6.7-33.3-18.7-45.3L304 18.7C292 6.7 275.7 0 258.7 0L64 0zm64 240c-17.7 0-32 14.3-32 32l0 40 88 0 0-72-56 0zM96 384c0 17.7 14.3 32 32 32l24 0 0-56-56 0 0 24zm160 32c17.7 0 32-14.3 32-32l0-24-88 0 0 56 56 0zM232 312l56 0 0-40c0-17.7-14.3-32-32-32l-24 0 0 72z"]],
    "shield-quartered": [512, 512, [], "e575", ["M79.8 248l152.3 0 0 202.3C145.6 401.7 100.7 321.9 79.8 248zM280 59.6L439 127c5.9 2.5 9.1 7.8 9 12.8-.1 17.9-1.6 38.4-5.1 60.3L280 200 280 59.6z", "M73.1 127c-5.9 2.5-9.1 7.8-9 12.8 .1 17.9 1.6 38.4 5.1 60.3l162.9 0 0-140.4-159 67.4zm6.7 121c20.9 73.9 65.9 153.7 152.3 202.3l0-202.3-152.3 0zM280 248l0 202.4C366.5 401.8 411.4 322 432.3 248L280 248zm162.9-48c3.5-21.9 5-42.3 5.1-60.3 0-5-3.1-10.2-9-12.8l-159-67.4 0 140.4 162.9 0zM269.4 2.9L457.8 82.8c22 9.3 38.4 31 38.3 57.2-.5 99.2-41.3 280.7-213.6 363.2-16.7 8-36.1 8-52.8 0-172.4-82.5-213.2-264-213.6-363.2-.1-26.2 16.3-47.9 38.3-57.2L242.7 2.9C246.9 1 251.4 0 256 0s9.2 1 13.4 2.9z"]],
    "square-ellipsis-vertical": [448, 512, [], "e26f", ["M48 96l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16zm208 64a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm0 96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm0 96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M64 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM224 224a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm-32-64a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm32 160a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]],
    "oven": [448, 512, [], "e01d", ["M48 96l0 80 352 0 0-80c0-26.5-21.5-48-48-48L96 48C69.5 48 48 69.5 48 96zm0 128l0 224c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-224-352 0zm80-112a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zM96 296c0-13.3 10.7-24 24-24l208 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-208 0c-13.3 0-24-10.7-24-24zM208 112a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm80 0a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm80 0a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M352 48c26.5 0 48 21.5 48 48l0 80-352 0 0-80c0-26.5 21.5-48 48-48l256 0zm48 176l0 224c0 8.8-7.2 16-16 16L64 464c-8.8 0-16-7.2-16-16l0-224 352 0zM96 0C43 0 0 43 0 96L0 448c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-352c0-53-43-96-96-96L96 0zm32 112a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm56 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm104-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm56 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM96 296c0 13.3 10.7 24 24 24l208 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-208 0c-13.3 0-24 10.7-24 24z"]],
    "scale-balanced": [640, 512, [9878, "balance-scale"], "f24e", ["", "M520 48L393.3 48C381 19.7 352.8 0 320 0s-61 19.7-73.3 48L120 48c-13.3 0-24 10.7-24 24s10.7 24 24 24l121.6 0c5.8 28.6 26.9 51.7 54.4 60.3l0 307.7-176 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l400 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-176 0 0-307.7c27.5-8.6 48.6-31.7 54.4-60.3L520 96c13.3 0 24-10.7 24-24s-10.7-24-24-24zm-8 147.8L584.4 320 439.6 320 512 195.8zM386 337.1C396.8 382 449.1 416 512 416s115.2-34 126-78.9c2.6-11-1-22.3-6.7-32.1L536.1 141.8c-5-8.6-14.2-13.8-24.1-13.8s-19.1 5.3-24.1 13.8L392.7 305.1c-5.7 9.8-9.3 21.1-6.7 32.1zM54.4 320l72.4-124.2 72.4 124.2-144.9 0zm72.4 96c62.9 0 115.2-34 126-78.9 2.6-11-1-22.3-6.7-32.1L150.9 141.8c-5-8.6-14.2-13.8-24.1-13.8s-19.1 5.3-24.1 13.8L7.6 305.1C1.9 314.8-1.8 326.1 .9 337.1 11.7 382 64 416 126.8 416zM320 48a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]],
    "car": [512, 512, [128664, "automobile"], "f1b9", ["M48 256l0 112 416 0 0-112c0-8.8-7.2-16-16-16L64 240c-8.8 0-16 7.2-16 16zm96 48a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm288 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M118.4 112.8L92 192 420 192 393.6 112.8C387.1 93.2 368.8 80 348.1 80L163.9 80c-20.7 0-39 13.2-45.5 32.8zM39.8 196.7l33-99.1C85.9 58.4 122.6 32 163.9 32l184.2 0c41.3 0 78 26.4 91.1 65.6l33 99.1c23.3 9.5 39.8 32.5 39.8 59.3l0 200c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-40-416 0 0 40c0 13.3-10.7 24-24 24S0 469.3 0 456L0 256c0-26.8 16.4-49.7 39.8-59.3zM64 240c-8.8 0-16 7.2-16 16l0 112 416 0 0-112c0-8.8-7.2-16-16-16L64 240zm48 32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm256 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"]],
    "circle-baht": [512, 512, [], "e72d", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zM168 154.3c0-14.5 11.8-26.3 26.3-26.3l45.7 0 0-16c0-8.8 7.2-16 16-16s16 7.2 16 16l0 16 4 0c42 0 76 34 76 76 0 16.2-5.1 31.3-13.8 43.7 18.1 13.9 29.8 35.8 29.8 60.3 0 42-34 76-76 76l-20 0 0 16c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-16-43.4 0c-15.8 0-28.6-12.8-28.6-28.6l0-201.1zM216 176l0 56 24 0 0-56-24 0zm0 104l0 56 24 0 0-56-24 0zm56-104l0 56 4 0c15.5 0 28-12.5 28-28s-12.5-28-28-28l-4 0zm0 104l0 56 20 0c15.5 0 28-12.5 28-28s-12.5-28-28-28l-20 0z", "M464 256a208 208 0 1 0 -416 0 208 208 0 1 0 416 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zM256 96c-8.8 0-16 7.2-16 16l0 16-45.7 0c-14.5 0-26.3 11.8-26.3 26.3l0 201.1c0 15.8 12.8 28.6 28.6 28.6l43.4 0 0 16c0 8.8 7.2 16 16 16s16-7.2 16-16l0-16 20 0c42 0 76-34 76-76 0-24.6-11.7-46.4-29.8-60.3 8.7-12.4 13.8-27.4 13.8-43.7 0-42-34-76-76-76l-4 0 0-16c0-8.8-7.2-16-16-16zm-16 80l0 56-24 0 0-56 24 0zm32 56l0-56 4 0c15.5 0 28 12.5 28 28s-12.5 28-28 28l-4 0zm-32 48l0 56-24 0 0-56 24 0zm32 56l0-56 20 0c15.5 0 28 12.5 28 28s-12.5 28-28 28l-20 0z"]],
    "badger-honey": [640, 512, [129441], "f6b4", ["M48 224c0 37.4 25.7 68.9 60.4 77.6 6.3 1.6 11.7 5.7 14.9 11.3s4.1 12.3 2.3 18.6l-10.7 37.6c-1.3 4.4-1.2 9.1 .1 13.5l13.1 43.7c1 3.4 4.1 5.7 7.7 5.7l29.2 0c5.4 0 9.2-5.2 7.7-10.3L164.3 394c-3.8-12.6-3-26.1 2.2-38.2l16-37.3c3.8-8.8 12.5-14.5 22.1-14.5l110.1 0c11.7 0 21.7 8.5 23.7 20.1l16.9 101.3c.6 3.9 4 6.7 7.9 6.7l31.1 0c4.9 0 8.7-4.4 7.9-9.3l-21.3-128c0-.2-.1-.4-.1-.6-2.3-9.4 1.3-19.2 9.1-25 41.3-30.4 101.5-61.6 169.4-67.9 10.1-.9 18.4-4.6 23.9-10.1l2.6-2.6c3.4-3.4 5.5-7.7 6.1-12.4l-80.2 0c-1.9 9.1-9.9 16-19.6 16-9.5 0-17.5-6.7-19.5-15.6-38.5 2.3-75.9 13.9-109.1 33.8L294 251.9C272 265 246.9 272 221.3 272 152.6 272 95.4 223 82.7 158.1 61.7 172.5 48 196.7 48 224z", "M465 112c16.9 0 33.6 3.7 49 10.9l45.3 21.1-72.3 0c-49.3 0-97.7 13.4-139.9 38.8l-69.4 41.7c-17 10.2-36.4 15.6-56.2 15.6-55.4 0-101.1-41.2-108.3-94.6 4.9-.9 9.9-1.4 15-1.4l204.2 0c27.3 0 54.1-6.3 78.5-18.5l2.5-1.2c16.1-8 33.8-12.2 51.8-12.2zm126.8 64c-.6 4.7-2.8 9-6.1 12.4l-2.6 2.6 0 0c-5.5 5.5-13.8 9.2-23.9 10.1-67.9 6.4-128.1 37.5-169.4 67.9-7.8 5.7-11.4 15.6-9.1 25 0 .2 .1 .4 .1 .6l21.3 128c.8 4.9-2.9 9.3-7.9 9.3l-31.1 0c-3.9 0-7.2-2.8-7.9-6.7L338.3 324.1c-1.9-11.6-11.9-20.1-23.7-20.1l-110.1 0c-9.6 0-18.3 5.7-22.1 14.5l-16 37.3c-5.2 12.1-5.9 25.6-2.2 38.2l8.3 27.7c1.5 5.1-2.3 10.3-7.7 10.3l-29.2 0c-3.5 0-6.6-2.3-7.7-5.7L115 382.6c-1.3-4.4-1.3-9.1-.1-13.5l10.7-37.6c1.8-6.2 1-13-2.3-18.6s-8.6-9.7-14.9-11.3c-34.7-8.7-60.4-40.2-60.4-77.6 0-27.3 13.7-51.5 34.7-65.9 12.8 64.9 70 113.9 138.6 113.9 25.6 0 50.7-7 72.7-20.1l69.4-41.7c33.2-19.9 70.6-31.5 109.1-33.8 2 8.9 10 15.6 19.5 15.6 9.7 0 17.7-6.9 19.6-16l80.2 0zM48 323.9c7.8 6.2 16.3 11.6 25.4 15.9l-4.6 16.1c-3.8 13.2-3.7 27.3 .3 40.5l13.1 43.7c7.1 23.7 28.9 39.9 53.6 39.9l29.2 0c37.5 0 64.4-36.2 53.6-72.1l-8.3-27.7c-.5-1.8-.4-3.7 .3-5.4l9.8-22.8 73.9 0 13.5 81.2c4.5 27 27.9 46.8 55.2 46.8l31.1 0c34.6 0 60.9-31.1 55.2-65.2L430.2 299.3c28.6-19.1 64.3-36.8 103.4-45.6l19.6 31.4c3.1 5 10.4 5 13.6 0l27.8-44.5c8.1-3.8 15.7-9 22.4-15.7l2.6-2.6c13.1-13.1 20.4-30.8 20.4-49.3 0-27.1-15.7-51.7-40.2-63.1L534.2 79.4c-21.7-10.1-45.3-15.4-69.3-15.4-25.4 0-50.5 5.9-73.2 17.3l-2.5 1.2C371.6 91.4 352 96 332.2 96L128 96C57.3 96 0 153.3 0 224L0 328c0 13.3 10.7 24 24 24s24-10.7 24-24l0-4.1z"]],
    "crop-simple": [512, 512, ["crop-alt"], "f565", ["M128 128l248 0c4.6 .1 8 3.7 8 8l0 248-248 0c-4.6-.1-8-3.7-8-8l0-248z", "M128 24c0-13.3-10.7-24-24-24S80 10.7 80 24l0 56-56 0C10.7 80 0 90.7 0 104s10.7 24 24 24l56 0 0 248c0 30.9 25.1 56 56 56l200 0 0-48-200 0c-4.4 0-8-3.6-8-8l0-352zM384 488c0 13.3 10.7 24 24 24s24-10.7 24-24l0-56 56 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-56 0 0-248c0-30.9-25.1-56-56-56l-200 0 0 48 200 0c4.4 0 8 3.6 8 8l0 352z"]],
    "timer": [512, 512, [], "e29e", ["M48.2 247.9c1.5-40.2 14.5-77.5 35.7-108.7 7.5-11 15.8-21.1 25.1-30.3L159 159c-9.4 9.4-9.4 24.6 0 33.9l80 80c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-17-17 0-94.1c13.3 0 24-10.7 24-24l0-54.6c103.6 11.9 184 99.9 184 206.6 0 114.9-93.1 208-208 208S48 370.9 48 256c0-2.7 .1-5.4 .2-8.1z", "M232 24c0-13.3 10.7-24 24-24 141.4 0 256 114.6 256 256S397.4 512 256 512 0 397.4 0 256c0-37.9 8.2-73.8 23-106.1 6-13.2 13.1-25.8 21.2-37.6l.1-.2c9.1-13.3 19.3-25.7 30.7-37.1 9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9c-9.2 9.2-17.6 19.3-25 30.1l-.1 .2c-21.2 31.2-34.2 68.5-35.7 108.7-.1 2.7-.2 5.4-.2 8.1 0 114.9 93.1 208 208 208s208-93.1 208-208c0-106.8-80.4-194.7-184-206.6l0 54.6c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-80zM159 159c9.4-9.4 24.6-9.4 33.9 0l80 80c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-80-80c-9.4-9.4-9.4-24.6 0-33.9z"]],
    "square-dollar": [448, 512, ["dollar-square", "usd-square"], "f2e9", ["M48 96l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16zm96 118.6c0-32.3 24.5-58.9 56-62.2l0-8.3c0-13.3 10.7-24 24-24s24 10.7 24 24l0 8 16 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-57.4 0c-8 0-14.6 6.5-14.6 14.6 0 7.2 5.3 13.4 12.5 14.4l45.8 6.5c30.8 4.4 53.7 30.8 53.7 61.9 0 32.3-24.5 58.9-56 62.2l0 8.3c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-8-24 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l65.4 0c8 0 14.6-6.5 14.6-14.6 0-7.2-5.3-13.4-12.5-14.4l-45.8-6.5c-30.8-4.4-53.7-30.8-53.7-61.9z", "M64 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm248 48l0 8 16 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-57.4 0c-8 0-14.6 6.5-14.6 14.6 0 7.2 5.3 13.4 12.5 14.4l45.8 6.5c30.8 4.4 53.7 30.8 53.7 61.9 0 32.3-24.5 58.9-56 62.2l0 8.3c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-8-24 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l65.4 0c8 0 14.6-6.5 14.6-14.6 0-7.2-5.3-13.4-12.5-14.4l-45.8-6.5c-30.8-4.4-53.7-30.8-53.7-61.9 0-32.3 24.5-58.9 56-62.2l0-8.3c0-13.3 10.7-24 24-24s24 10.7 24 24z"]],
    "medal": [512, 512, [127941], "f5a2", ["M112.3 320a144 144 0 1 0 288 0 144 144 0 1 0 -288 0zm50.8-21.2c-5.6-5.4-2.5-14.8 5.2-16l50.1-7.3c3-.4 5.7-2.4 7-5.1l22.4-45.4c3.4-7 13.3-7 16.8 0l22.4 45.4c1.4 2.8 4 4.7 7 5.1l50.1 7.3c7.7 1.1 10.7 10.5 5.2 16l-36.3 35.4c-2.2 2.1-3.2 5.2-2.7 8.3l8.6 49.9c1.3 7.6-6.7 13.5-13.6 9.9l-44.8-23.6c-2.7-1.4-6-1.4-8.7 0l-44.8 23.6c-6.9 3.6-14.9-2.2-13.6-9.9l8.6-49.9c.5-3-.5-6.1-2.7-8.3l-36.3-35.4z", "M21.6 64.2L96.4 213.8c-20.2 30.4-32 67-32 106.2 0 106 86 192 192 192s192-86 192-192c0-39.3-11.8-75.8-32-106.2L491 64.2c11.9-23.7 2.2-52.5-21.5-64.4L383.8-43.1c-23.1-11.6-51.2-2.7-63.6 19.9l-63.8 117-63.8-117C180.1-45.8 152-54.7 128.9-43.1L43-.2C19.3 11.7 9.7 40.5 21.6 64.2zm269.1 66.9L362.3-.2 448.1 42.7 382 174.9c-25.5-22.1-56.8-37.6-91.3-43.8zm-68.8 0c-34.5 6.2-65.9 21.7-91.3 43.8L64.5 42.7 150.3-.2 221.9 131.1zM112.3 320a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm174.8-49.5l-22.4-45.4c-3.4-7-13.3-7-16.8 0l-22.4 45.4c-1.4 2.8-4 4.7-7 5.1l-50.1 7.3c-7.7 1.1-10.7 10.5-5.2 16l36.3 35.4c2.2 2.1 3.2 5.2 2.7 8.3l-8.6 49.9c-1.3 7.6 6.7 13.5 13.6 9.9L252 378.7c2.7-1.4 6-1.4 8.7 0l44.8 23.6c6.9 3.6 14.9-2.2 13.6-9.9l-8.6-49.9c-.5-3 .5-6.1 2.7-8.3l36.3-35.4c5.5-5.4 2.5-14.8-5.2-16l-50.1-7.3c-3-.4-5.7-2.4-7-5.1z"]],
    "scroll": [576, 512, [128220], "f70e", ["M112 400c0 41.4 31.4 75.4 71.6 79.5-2.5 .3-5.1 .5-7.6 .5-35.3 0-64-28.7-64-64l0-16zM153.3 80L360 80c22.1 0 40 17.9 40 40l0 184-120 0c-30.9 0-56 25.1-56 56l0 40c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-288c0-11.4-2.4-22.2-6.7-32z", "M48 112c0-17.7 14.3-32 32-32s32 14.3 32 32l0 48-64 0 0-48zM153.3 80L360 80c22.1 0 40 17.9 40 40l0 184-120 0c-30.9 0-56 25.1-56 56l0 40c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-288c0-11.4-2.4-22.2-6.7-32zM448 304l0-184c0-48.6-39.4-88-88-88L80 32C35.8 32 0 67.8 0 112l0 48c0 26.5 21.5 48 48 48l64 0 0 192c0 44.2 35.8 80 80 80l264 0c48.6 0 88-39.4 88-88l0-32c0-30.9-25.1-56-56-56l-40 0zm8 128l-190.7 0c4.3-9.8 6.7-20.6 6.7-32l0-40c0-4.4 3.6-8 8-8l208 0c4.4 0 8 3.6 8 8l0 32c0 22.1-17.9 40-40 40z"]],
    "calendars": [512, 512, [], "e0d7", ["M144 224l0 128c0 8.8 7.2 16 16 16l288 0c8.8 0 16-7.2 16-16l0-128-320 0z", "M192 24c0-13.3 10.7-24 24-24s24 10.7 24 24l0 40 128 0 0-40c0-13.3 10.7-24 24-24s24 10.7 24 24l0 40 32 0c35.3 0 64 28.7 64 64l0 224c0 35.3-28.7 64-64 64l-288 0c-35.3 0-64-28.7-64-64l0-224c0-35.3 28.7-64 64-64l32 0 0-40zm256 88l-288 0c-8.8 0-16 7.2-16 16l0 48 320 0 0-48c0-8.8-7.2-16-16-16zM144 352c0 8.8 7.2 16 16 16l288 0c8.8 0 16-7.2 16-16l0-128-320 0 0 128zM48 184l0 264c0 8.8 7.2 16 16 16l328 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L64 512c-35.3 0-64-28.7-64-64L0 184c0-13.3 10.7-24 24-24s24 10.7 24 24z"]],
    "apple-core": [384, 512, [], "e08f", ["M89.2 450.9c13.9 9.2 27.4 13.1 38.9 13.1 4.6 0 13.6-1.7 24.9-5.1 25.4-7.6 52.7-7.6 78.1 0 11.3 3.4 20.3 5.1 24.9 5.1 11.4 0 24.9-4 38.9-13.1-34.1-39.3-54.9-90.7-54.9-146.9 0-46 13.9-88.8 37.7-124.4-12.7 3-26.4 7.5-39 12.4-30 11.7-63.5 11.7-93.5 0-12.6-4.9-26.2-9.4-39-12.4 23.8 35.6 37.7 78.4 37.7 124.4 0 56.2-20.7 107.6-54.9 146.9z", "M192 112c-8.8 0-16-7.2-16-16l0-16c0-44.2 35.8-80 80-80l16 0c8.8 0 16 7.2 16 16l0 16c0 44.2-35.8 80-80 80l-16 0zM128 464c4.6 0 13.6-1.7 24.9-5.1 25.4-7.6 52.7-7.6 78.1 0 11.3 3.4 20.3 5.1 24.9 5.1 11.4 0 24.9-4 38.9-13.1-34.1-39.3-54.9-90.7-54.9-146.9 0-46 13.9-88.8 37.7-124.4-12.7 3-26.4 7.5-39 12.4-30 11.7-63.5 11.7-93.5 0-12.6-4.9-26.2-9.4-39-12.4 23.8 35.6 37.7 78.4 37.7 124.4 0 56.2-20.7 107.6-54.9 146.9 13.9 9.2 27.4 13.1 38.9 13.1zM304 128c6.7 0 13 .6 19.1 1.9 .7 .1 1.4 .3 2.1 .4 13.4 3 25.9 9.1 37.2 18.3 4 3.2 3.3 9.3-.9 12.3-44.5 31.9-73.5 84.1-73.5 143.1 0 57.4 27.5 108.4 70 140.5 3.7 2.8 4.5 8 1.6 11.5-29.2 35.1-66.4 55.9-103.6 55.9-11.9 0-26.5-3.4-38.8-7.1-16.4-4.9-34.1-4.9-50.5 0-12.2 3.7-26.8 7.1-38.8 7.1-37.2 0-74.5-20.8-103.6-55.9-2.9-3.5-2.1-8.8 1.6-11.5 42.5-32.1 70-83.1 70-140.5 0-59-29-111.2-73.5-143.1-4.2-3-4.8-9.1-.9-12.3 11.3-9.2 23.8-15.3 37.2-18.3 .7-.2 1.4-.3 2.1-.4 6.1-1.2 12.4-1.9 19.1-1.9 27.3 0 59.7 10.3 82.7 19.3 18.8 7.3 39.9 7.3 58.7 0 22.9-8.9 55.4-19.3 82.7-19.3z"]],
    "file-excel": [384, 512, [], "f1c3", ["M48 64l0 384c0 8.8 7.2 16 16 16l256 0c8.8 0 16-7.2 16-16l0-240-88 0c-39.8 0-72-32.2-72-72l0-88-112 0c-8.8 0-16 7.2-16 16zm76.8 230.4c-8-10.6-5.8-25.6 4.8-33.6s25.6-5.8 33.6 4.8L192 304 220.8 265.6c8-10.6 23-12.8 33.6-4.8s12.8 23 4.8 33.6L222 344 259.2 393.6c8 10.6 5.8 25.6-4.8 33.6s-25.6 5.8-33.6-4.8L192 384 163.2 422.4c-8 10.6-23 12.8-33.6 4.8s-12.8-23-4.8-33.6L162 344 124.8 294.4z", "M64 48l112 0 0 88c0 39.8 32.2 72 72 72l88 0 0 240c0 8.8-7.2 16-16 16L64 464c-8.8 0-16-7.2-16-16L48 64c0-8.8 7.2-16 16-16zM224 67.9l92.1 92.1-68.1 0c-13.3 0-24-10.7-24-24l0-68.1zM64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-261.5c0-17-6.7-33.3-18.7-45.3L242.7 18.7C230.7 6.7 214.5 0 197.5 0L64 0zm99.2 265.6c-8-10.6-23-12.8-33.6-4.8s-12.8 23-4.8 33.6L162 344 124.8 393.6c-8 10.6-5.8 25.6 4.8 33.6s25.6 5.8 33.6-4.8L192 384 220.8 422.4c8 10.6 23 12.8 33.6 4.8s12.8-23 4.8-33.6L222 344 259.2 294.4c8-10.6 5.8-25.6-4.8-33.6s-25.6-5.8-33.6 4.8L192 304 163.2 265.6z"]],
    "diamond-half": [512, 512, [], "e5b7", ["M48 256c0 2.6 1 5.2 2.9 7L208 420.1 208 91.9 50.9 249c-1.9 1.9-2.9 4.4-2.9 7z", "M241.2 11.8c9 3.7 14.8 12.5 14.8 22.2l0 444.1c0 9.7-5.8 18.5-14.8 22.2s-19.3 1.7-26.2-5.2L17 297C6.1 286.1 0 271.4 0 256s6.1-30.1 17-41L215 17c6.9-6.9 17.2-8.9 26.2-5.2zM208 91.9L50.9 249c-1.9 1.9-2.9 4.4-2.9 7s1 5.2 2.9 7L208 420.1 208 91.9z"]],
    "baguette": [640, 512, [129366], "e3d8", ["M61.4 428.4c24.5 36.8 74.2 46.7 110.9 22.2l384-256c36.8-24.5 46.7-74.2 22.2-110.9S504.4 36.9 467.6 61.4L397.9 107.9 433 143c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-41.9-41.9-74.5 49.6 38.3 38.3c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-45.1-45.1-74.5 49.6 41.5 41.5c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-48.3-48.3-43.1 28.7c-36.8 24.5-46.7 74.2-22.2 110.9z", "M578.6 83.6c-24.5-36.8-74.2-46.7-110.9-22.2L397.9 107.9 433 143c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-41.9-41.9-74.5 49.6 38.3 38.3c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-45.1-45.1-74.5 49.6 41.5 41.5c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-48.3-48.3-43.1 28.7c-36.8 24.5-46.7 74.2-22.2 110.9s74.2 46.7 110.9 22.2l384-256c36.8-24.5 46.7-74.2 22.2-110.9zM618.5 57c39.2 58.8 23.3 138.3-35.5 177.5l-384 256C140.2 529.7 60.7 513.8 21.5 455S-1.8 316.7 57 277.5l384-256C499.8-17.7 579.3-1.8 618.5 57z"]],
    "ear-triangle-exclamation": [576, 512, [], "e75c", ["M112 192c0-79.5 64.5-144 144-144s144 64.5 144 144c-11.1 0-21.9 2-32 5.9l0-5.9c0-61.9-50.1-112-112-112S144 130.1 144 192l0 40c0 13.3 10.7 24 24 24l16 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-16 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l16 0c39.8 0 72-32.2 72-72 0-37.1-28-67.6-64-71.6l0-16.4c0-35.3 28.7-64 64-64s64 28.7 64 64l0 8c0 9.4 5.4 17.6 13.3 21.5-4.1 4.5-7.7 9.3-10.8 14.6L188 462.7c-.2 .4-.5 .8-.7 1.2-42-2.4-75.3-37.3-75.3-79.9l0-192z", "M256 48c79.5 0 144 64.5 144 144 17.1 0 33.5 4.8 47.5 13.5 .3-4.5 .5-9 .5-13.5 0-106-86-192-192-192S64 86 64 192l0 192c0 65.3 48.9 119.2 112.1 127-.1-1.6-.1-3.2-.1-4.7 0-14.9 3.9-29.5 11.3-42.4-42-2.4-75.3-37.3-75.3-79.9l0-192c0-79.5 64.5-144 144-144zM368 192c0-61.9-50.1-112-112-112S144 130.1 144 192l0 40c0 13.3 10.7 24 24 24l16 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-16 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l16 0c39.8 0 72-32.2 72-72 0-37.1-28-67.6-64-71.6l0-16.4c0-35.3 28.7-64 64-64s64 28.7 64 64l0 8c0 9.4 5.4 17.6 13.3 21.5 9.6-10.5 21.5-18.6 34.7-23.6l0-5.9zM229.2 487.3c-3.4 5.8-5.2 12.4-5.2 19.1 0 20.7 16.8 37.4 37.4 37.4l277.1 0c20.7 0 37.4-16.8 37.4-37.4 0-6.7-1.8-13.3-5.2-19.1L436.3 260.7c-7.6-12.8-21.4-20.6-36.3-20.6s-28.7 7.8-36.3 20.6L229.2 487.3zM416 327.2l0 80.9c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80.9c0-8.8 7.2-16 16-16s16 7.2 16 16zM400 456.1a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]],
    "h5": [576, 512, [], "e412", ["", "M80 88c0-13.3-10.7-24-24-24S32 74.7 32 88l0 336c0 13.3 10.7 24 24 24s24-10.7 24-24l0-144 128 0 0 144c0 13.3 10.7 24 24 24s24-10.7 24-24l0-336c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 144-128 0 0-144zM344 64c-13.3 0-24 10.7-24 24l0 160c0 13.3 10.7 24 24 24l96 0c35.3 0 64 28.7 64 64s-28.7 64-64 64l-96 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l96 0c61.9 0 112-50.1 112-112S501.9 224 440 224l-72 0 0-112 144 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L344 64z"]],
    "person-ski-lift": [512, 512, ["ski-lift"], "f7c8", ["", "M240 0c8.8 0 16 7.2 16 16l0 191.9-32 7.5 0-199.4c0-8.8 7.2-16 16-16zM112 32a48 48 0 1 1 0 96 48 48 0 1 1 0-96zM13.7 178.3c12-5.7 26.3-.7 32 11.3l65 135.8c8.3 17.4 28 26.4 46.6 21.3l36.5-9.9c12.8-3.5 26 4.1 29.5 16.8s-4.1 26-16.8 29.5l-36.5 9.9c-41 11.2-84.2-8.6-102.5-46.9L2.4 210.4c-5.7-12-.7-26.3 11.3-32zM488 288c13.3 0 24 10.7 24 24l0 1c0 33.5-20.9 63.4-52.3 75L128.3 510.5c-12.4 4.6-26.2-1.8-30.8-14.2s1.8-26.2 14.2-30.8l160.3-59.2 0-119.9-94.2 22.2c-18 4.2-36.6-4.5-44.9-21L90.3 202.3c-11.5-23.1 5.2-50.3 31.1-50.3 13.2 0 25.2 7.4 31.1 19.2l42 84 86.2-20.3c20.1-4.7 39.3 10.5 39.3 31.2l0 122.4 123.1-45.5c12.6-4.6 20.9-16.6 20.9-30l0-1c0-13.3 10.7-24 24-24z"]],
    "square-cedi": [448, 512, [], "e729", ["M48 96l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16zm54.7 160c0-58.5 41.9-107.2 97.3-117.8l0-2.2c0-13.3 10.7-24 24-24s24 10.7 24 24l0 2.7c21.8 4.7 41.5 15.3 57.1 30.1 9.6 9.1 10.1 24.3 1 33.9s-24.3 10.1-33.9 1c-6.9-6.5-15.1-11.7-24.2-15.1l0 134.9c9.1-3.4 17.2-8.6 24.2-15.1 9.6-9.1 24.8-8.7 33.9 1s8.7 24.8-1 33.9c-15.6 14.8-35.3 25.4-57.1 30.1l0 2.7c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-2.2c-55.4-10.6-97.3-59.4-97.3-117.8zm48 0c0 31.8 20.6 58.8 49.3 68.3l0-136.7c-28.6 9.5-49.3 36.5-49.3 68.3z", "M384 80c8.8 0 16 7.2 16 16l0 320c0 8.8-7.2 16-16 16L64 432c-8.8 0-16-7.2-16-16L48 96c0-8.8 7.2-16 16-16l320 0zM64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM248 136c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 2.2c-55.4 10.6-97.3 59.3-97.3 117.8S144.6 363.2 200 373.8l0 2.2c0 13.3 10.7 24 24 24s24-10.7 24-24l0-2.7c21.8-4.7 41.5-15.3 57.1-30.1 9.6-9.1 10.1-24.3 1-33.9s-24.3-10.1-33.9-1c-6.9 6.5-15.1 11.7-24.2 15.1l0-134.9c9.1 3.4 17.2 8.6 24.2 15.1 9.6 9.1 24.8 8.7 33.9-1s8.7-24.8-1-33.9c-15.6-14.8-35.3-25.4-57.1-30.1l0-2.7zm-48 51.7l0 136.7c-28.6-9.5-49.3-36.5-49.3-68.3s20.6-58.8 49.3-68.3z"]],
    "filter": [512, 512, [], "f0b0", ["M73.9 112l364.1 0-143 143c-4.5 4.5-7 10.6-7 17l0 166.1-64-64 0-102.1c0-6.4-2.5-12.5-7-17L73.9 112z", "M0 93.7C0 77.3 13.3 64 29.7 64l452.7 0c16.4 0 29.7 13.3 29.7 29.7 0 7.9-3.1 15.4-8.7 21L336 281.9 336 482.3c0 16.4-13.3 29.7-29.7 29.7-7.9 0-15.4-3.1-21-8.7L183 401c-4.5-4.5-7-10.6-7-17L176 281.9 8.7 114.6C3.1 109.1 0 101.5 0 93.7zM73.9 112L217 255c4.5 4.5 7 10.6 7 17l0 102.1 64 64 0-166.1c0-6.4 2.5-12.5 7-17l143-143-364.1 0z"]],
    "calculator-simple": [512, 512, ["calculator-alt"], "f64c", ["", "M256 0c13.3 0 24 10.7 24 24l0 208 208 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-208 0 0 208c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-208-208 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l208 0 0-208c0-13.3 10.7-24 24-24zM400 32c13.3 0 24 10.7 24 24l0 32 32 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-32 0 0 32c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-32-32 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l32 0 0-32c0-13.3 10.7-24 24-24zM55.4 343.4c9.4-9.4 24.6-9.4 33.9 0l22.6 22.6 22.6-22.6c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-22.6 22.6 22.6 22.6c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0L112 433.9 89.4 456.6c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9L78.1 400 55.4 377.4c-9.4-9.4-9.4-24.6 0-33.9zM64 88l96 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-96 0c-13.3 0-24-10.7-24-24S50.7 88 64 88zM352 336l96 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-96 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zm0 80l96 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-96 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"]],
    "coin-blank": [512, 512, [], "e3fb", ["M48 292c15.6 12.2 34.5 23 56 31.9l0 47.3c-2.6-1.2-5.1-2.4-7.6-3.6-41.2-20.6-48.4-40.2-48.4-47.6l0-28zm16-84c0-53 86-96 192-96s192 43 192 96-86 96-192 96-192-43-192-96zm88 131.6c24.8 6.2 51.8 10.3 80 11.8l0 48c-29.1-1.5-56.1-5.6-80-11.7l0-48zm128 11.8c25.2-1.3 49.4-4.7 72-9.8l0 48.1c-21.9 5-46.1 8.5-72 9.8l0-48zm120-24.3c24.8-9.5 46.5-21.4 64-35.1l0 28c0 7.4-7.2 27-48.4 47.6-4.9 2.4-10.1 4.8-15.6 7l0-47.5z", "M152 339.6c24.8 6.2 51.8 10.3 80 11.8l0 48c-29.1-1.5-56.1-5.6-80-11.7l0-48zM48 292c15.6 12.2 34.5 23 56 31.9l0 47.3c-2.6-1.2-5.1-2.4-7.6-3.6-41.2-20.6-48.4-40.2-48.4-47.6l0-28zM256 64C114.6 64 0 128.5 0 208L0 320c0 70.7 114.6 128 256 128s256-57.3 256-128l0-112c0-79.5-114.6-144-256-144zM400 327.1c24.8-9.5 46.5-21.4 64-35.1l0 28c0 7.4-7.2 27-48.4 47.6-4.9 2.4-10.1 4.8-15.6 7l0-47.5zM280 351.4c25.2-1.3 49.4-4.7 72-9.8l0 48.1c-21.9 5-46.1 8.5-72 9.8l0-48zM64 208c0-53 86-96 192-96s192 43 192 96-86 96-192 96-192-43-192-96z"]],
    "intersection": [384, 512, [8898], "f668", ["", "M24 480c13.3 0 24-10.7 24-24l0-232c0-79.5 64.5-144 144-144s144 64.5 144 144l0 232c0 13.3 10.7 24 24 24s24-10.7 24-24l0-232c0-106-86-192-192-192S0 118 0 224L0 456c0 13.3 10.7 24 24 24z"]],
    "drum": [512, 512, [129345], "f569", ["M48 274.2c11.6 7 25 13.4 40 19l0 110.1c-10.4-4.7-18.9-9.6-25.5-14.6-12.2-9.4-14.5-16.6-14.5-20.7l0-93.8zm88 33.1c29.1 6.6 61.6 10.8 96 12.2l0 112c-35.5-1.4-68.1-5.8-96-12.5l0-111.7zm144 12.2c34.4-1.3 66.9-5.6 96-12.2l0 111.7c-27.9 6.7-60.5 11.1-96 12.5l0-112zm144-26.3c15-5.6 28.4-12 40-19l0 93.8c0 4.1-2.3 11.2-14.5 20.7-6.5 5-15 10-25.5 14.6l0-110.1z", "M501.2 76.1c11.1-7.3 14.2-22.1 6.9-33.2s-22.1-14.2-33.2-6.9L370.2 104.5C335.8 98.7 297 96 256 96 114.6 96 0 128 0 208L0 368c0 24.9 14.9 44.5 33.2 58.7 18.5 14.3 43.6 25.5 72 33.9 42.2 12.4 94.6 19.5 150.8 19.5s108.6-7 150.8-19.5c28.4-8.4 53.5-19.6 72-33.9 18.4-14.1 33.2-33.8 33.2-58.7l0-160c0-41.1-30.2-69.5-78.8-87.4l67.9-44.5zM307.4 145.6l-64.6 42.3c-11.1 7.3-14.2 22.1-6.9 33.2s22.1 14.2 33.2 6.9l111.1-72.8c14.7 3.2 27.9 7 39.4 11.5 38.8 15.1 44.4 30.6 44.4 41.3 0 .8-2.7 17.2-46 35.9-38.9 16.8-96 28.1-162 28.1S132.9 260.7 94 243.9c-43.3-18.7-46-35.1-46-35.9 0-10.6 5.6-26.2 44.4-41.3 38.3-14.9 95.4-22.7 163.6-22.7 18 0 35.1 .5 51.4 1.6zM424 293.2c15-5.6 28.4-12 40-19l0 93.8c0 4.1-2.3 11.2-14.5 20.7-6.5 5-15 10-25.5 14.6l0-110.1zM280 319.5c34.4-1.3 66.9-5.6 96-12.2l0 111.7c-27.9 6.7-60.5 11.1-96 12.5l0-112zM136 307.4c29.1 6.6 61.6 10.8 96 12.2l0 112c-35.5-1.4-68.1-5.8-96-12.5l0-111.7zM48 274.2c11.6 7 25 13.4 40 19l0 110.1c-10.4-4.7-18.9-9.6-25.5-14.6-12.2-9.4-14.5-16.6-14.5-20.7l0-93.8z"]],
    "map-pin": [320, 512, [128205], "f276", ["M64 144a96 96 0 1 0 192 0 96 96 0 1 0 -192 0z", "M64 144a96 96 0 1 1 192 0 96 96 0 1 1 -192 0zM184 286c68.1-11.4 120-70.7 120-142 0-79.5-64.5-144-144-144S16 64.5 16 144c0 71.4 51.9 130.6 120 142l0 202c0 13.3 10.7 24 24 24s24-10.7 24-24l0-202z"]],
    "circle-house": [512, 512, [], "e6c8", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm64-22.3c0-6.2 2.5-12 7-16.3L242.2 101.5C245.9 98 250.9 96 256 96s10.1 2 13.8 5.5L393 217.4c4.5 4.2 7 10.1 7 16.3 0 12.3-10 22.3-22.3 22.3l-9.7 0 0 85.5c0 23.5-19 42.5-42.5 42.5l-139 0C163 384 144 365 144 341.5l0-85.5-9.7 0C122 256 112 246 112 233.7z", "M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM368 256l9.7 0c12.3 0 22.3-10 22.3-22.3 0-6.2-2.5-12-7-16.3L269.8 101.5C266.1 98 261.1 96 256 96s-10.1 2-13.8 5.5L119 217.4c-4.5 4.2-7 10.1-7 16.3 0 12.3 10 22.3 22.3 22.3l9.7 0 0 85.5c0 23.5 19 42.5 42.5 42.5l139 0c23.5 0 42.5-19 42.5-42.5l0-85.5zM224 288c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 48-64 0 0-48z"]],
    "table-pivot": [576, 512, [], "e291", ["M112.5 96c0-8.8 7.2-16 16-16l64 0 0 80-80 0 0-64zm0 112l80 0 0 152c0 13.3 10.7 24 24 24 2.8 0 5.5-.5 8-1.4l0 40.3c-1.5 2.9-2.8 6-3.9 9l-92.1 0c-8.8 0-16-7.2-16-16l0-208zm128-128l208 0c8.8 0 16 7.2 16 16l0 92.1c-3.1 1.1-6.1 2.4-9 3.9l-40.3 0c.9-2.5 1.4-5.2 1.4-8 0-13.3-10.7-24-24-24l-152 0 0-80z", "M448.5 80l-208 0 0 80 152 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-152 0 0 152c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-152-80 0 0 208c0 8.8 7.2 16 16 16l92.1 0c-5.5 15.5-5.5 32.5 0 48l-92.1 0c-35.3 0-64-28.7-64-64l0-320c0-35.3 28.7-64 64-64l320 0c35.3 0 64 28.7 64 64l0 92.1c-15.5-5.5-32.5-5.5-48 0l0-92.1c0-8.8-7.2-16-16-16zm-336 80l80 0 0-80-64 0c-8.8 0-16 7.2-16 16l0 64zm407 161l-7-7 0 102.1c0 35.3-28.7 64-64 64l-102.1 0 7 7c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-48-48c-9.4-9.4-9.4-24.6 0-33.9l48-48c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-7 7 102.1 0c8.8 0 16-7.2 16-16l0-102.1-7 7c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l48-48c9.4-9.4 24.6-9.4 33.9 0l48 48c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0z"]],
    "bridge-suspension": [512, 512, [], "e4cd", ["M48 288l0 49.8c29.7 19 48 51.9 48 87.6l0 38.6 48 0c0-61.9 50.1-112 112-112s112 50.1 112 112l48 0 0-38.6c0-35.7 18.3-68.7 48-87.6l0-49.8-416 0z", "M73.4 15.9c-.7 1.9-1.1 3.9-1.3 6-4.1 37.6-27.5 71.3-60.9 92.4-11.2 7.1-14.6 21.9-7.5 33.1s21.9 14.6 33.1 7.5c12.8-8.1 24.6-17.7 35.2-28.6l0 113.7-48 0c-13.3 0-24 10.7-24 24l0 88c0 9.1 5.1 17.4 13.3 21.5l3.8 1.9c19 9.5 31 28.9 31 50.1L48 472c0 22.1 17.9 40 40 40l64 0c22.1 0 40-17.9 40-40l0-8c0-35.3 28.7-64 64-64s64 28.7 64 64l0 8c0 22.1 17.9 40 40 40l64 0c22.1 0 40-17.9 40-40l0-46.6c0-21.2 12-40.6 31-50.1l3.8-1.9c8.1-4.1 13.3-12.4 13.3-21.5l0-88c0-13.3-10.7-24-24-24l-48 0 0-112.3c10.5 10.8 22.4 20.4 35.4 28.4 11.3 6.9 26.1 3.4 33-7.9s3.4-26.1-7.9-33c-33.7-20.7-56.5-54.7-60.7-93.2-.2-2.1-.6-4.1-1.3-6.1-2.4-6.7-7.8-12.1-14.6-14.5-2.4-.9-5.1-1.3-7.8-1.3-2.9 0-5.7 .5-8.3 1.4-6.6 2.4-12 7.7-14.4 14.5-.7 1.9-1.1 3.9-1.3 5.9-6.9 62.9-64.1 114.1-136.1 114.1S126.8 84.8 119.9 21.9c-.2-2.1-.6-4-1.3-5.9-1.2-3.5-3.2-6.5-5.8-9-2.4-2.4-5.4-4.3-8.7-5.5-2.6-.9-5.4-1.5-8.3-1.4-2.7 0-5.3 .5-7.8 1.3-3.5 1.2-6.6 3.2-9.2 5.8-2.4 2.4-4.3 5.4-5.5 8.8zM336 166.8c21.2-9.6 40.2-23 56-39.3l0 112.5-56 0 0-73.2zM256 184c10.9 0 21.6-.9 32-2.6l0 58.6-64 0 0-58.6c10.4 1.7 21.1 2.6 32 2.6zM120 127.5c15.8 16.3 34.8 29.6 56 39.3l0 73.2-56 0 0-112.5zM48 337.8l0-49.8 416 0 0 49.8c-29.7 19-48 51.9-48 87.6l0 38.6-48 0c0-61.9-50.1-112-112-112S144 402.1 144 464l-48 0 0-38.6c0-35.7-18.3-68.7-48-87.6z"]],
    "scale-unbalanced-flip": [640, 512, ["balance-scale-right"], "f516", ["", "M97.5 16.7c-4 12.6 2.9 26.1 15.5 30.2L240.7 87.7c3.1 32.4 25.5 59.2 55.6 68.6l0 307.7-176 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l200 0c13.3 0 24-10.7 24-24l0-331.7c14.2-4.5 26.8-12.8 36.4-23.8L513 174.9c12.6 4 26.1-2.9 30.2-15.5s-2.9-26.1-15.5-30.2L399.9 88.3c.3-2.7 .4-5.5 .4-8.3 0-44.2-35.8-80-80-80-29.8 0-55.8 16.3-69.6 40.5L127.7 1.1c-12.6-4-26.1 2.9-30.2 15.5zm30.9 147.1l72.4 124.2-144.9 0 72.4-124.2zm126 141.3c2.6-11-1-22.3-6.7-32.1L152.4 109.8c-5-8.6-14.2-13.8-24.1-13.8s-19.1 5.3-24.1 13.8L9.1 273.1c-5.7 9.8-9.3 21.1-6.7 32.1 10.8 44.8 63.1 78.9 126 78.9s115.2-34 126-78.9zM583.6 416l-144.9 0 72.4-124.2 72.4 124.2zm-72.4 96c62.9 0 115.2-34 126-78.9 2.6-11-1-22.3-6.7-32.1L535.3 237.8c-5-8.6-14.2-13.8-24.1-13.8s-19.1 5.3-24.1 13.8L391.9 401.1c-5.7 9.8-9.3 21.1-6.7 32.1 10.8 44.8 63.1 78.9 126 78.9zM320.3 48a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]],
    "light-switch": [384, 512, [], "e017", ["M48 64l0 384c0 8.8 7.2 16 16 16l256 0c8.8 0 16-7.2 16-16l0-384c0-8.8-7.2-16-16-16L64 48c-8.8 0-16 7.2-16 16zm48 80c0-26.5 21.5-48 48-48l96 0c26.5 0 48 21.5 48 48l0 224c0 26.5-21.5 48-48 48l-96 0c-26.5 0-48-21.5-48-48l0-224z", "M64 48c-8.8 0-16 7.2-16 16l0 384c0 8.8 7.2 16 16 16l256 0c8.8 0 16-7.2 16-16l0-384c0-8.8-7.2-16-16-16L64 48zM0 64C0 28.7 28.7 0 64 0L320 0c35.3 0 64 28.7 64 64l0 384c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zM144 368l96 0 0-88-96 0 0 88zm0-136l96 0 0-88-96 0 0 88zM96 144c0-26.5 21.5-48 48-48l96 0c26.5 0 48 21.5 48 48l0 224c0 26.5-21.5 48-48 48l-96 0c-26.5 0-48-21.5-48-48l0-224z"]],
    "arrows-to-circle": [512, 512, [], "e4bd", ["", "M7.5 7c9.4-9.4 24.6-9.4 33.9 0l103 103 0-38.1c0-13.3 10.7-24 24-24s24 10.7 24 24l0 96c0 13.3-10.7 24-24 24l-96 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l38.1 0-103-103C-1.8 31.6-1.8 16.4 7.5 7zm192 249a56.5 56.5 0 1 1 113 0 56.5 56.5 0 1 1 -113 0zm306-215l-103 103 38.1 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-96 0c-13.3 0-24-10.7-24-24l0-96c0-13.3 10.7-24 24-24s24 10.7 24 24l0 38.1 103-103c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9zm0 464c-9.4 9.4-24.6 9.4-33.9 0l-103-103 0 38.1c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-96c0-13.3 10.7-24 24-24l96 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-38.1 0 103 103c9.4 9.4 9.4 24.6 0 33.9zM7.5 471l103-103-38.1 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l96 0c13.3 0 24 10.7 24 24l0 96c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-38.1-103 103c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9z"]],
    "ampersand": [384, 512, [], "26", ["", "M96 110.3c0 15.7 5.9 30.7 16.5 42.2l34.6 37.5 45.6-26.1c19.3-11 31.3-31.6 31.3-53.9 0-34.3-27.8-62.1-62.1-62.1l-3.7 0C123.9 48 96 75.9 96 110.3zm120.5 95.3l-36 20.6 104.5 113.2 58.8-53.2c9.8-8.9 25-8.1 33.9 1.7s8.1 25-1.7 33.9l-58.5 52.9 60 65c9 9.7 8.4 24.9-1.4 33.9s-24.9 8.4-33.9-1.4l-60.3-65.4-26.5 23.9C220.6 462.5 175.1 480 128 480 57.3 480 0 422.7 0 352l0-2.3c0-46.8 25.1-89.9 65.7-113.1l38.7-22.1-27.1-29.4C58.4 164.7 48 138 48 110.3 48 49.4 97.4 0 158.3 0l3.7 0c60.8 0 110.1 49.3 110.1 110.1 0 39.5-21.2 76-55.5 95.6zM128 432c35.2 0 69.2-13.1 95.4-36.7l26.1-23.6-111.7-121-48.3 27.6C63.8 292.9 48 320.2 48 349.7l0 2.3c0 44.2 35.8 80 80 80z"]],
    "chess-clock": [576, 512, [], "f43d", ["M48 160l0 224c0 8.8 7.2 16 16 16l448 0c8.8 0 16-7.2 16-16l0-224c0-8.8-7.2-16-16-16L64 144c-8.8 0-16 7.2-16 16zM272 272a96 96 0 1 1 -192 0 96 96 0 1 1 192 0zm224 0a96 96 0 1 1 -192 0 96 96 0 1 1 192 0z", "M200 16c13.3 0 24 10.7 24 24s-10.7 24-24 24l-32 0 0 32 344 0 6.5 .3C550.8 99.6 576 126.9 576 160l0 224-.3 6.5c-3.1 30.1-27 54.1-57.1 57.1l-6.5 .3-448 0-6.5-.3c-30.1-3.1-54.1-27-57.1-57.1L0 384 0 160c0-33.1 25.2-60.4 57.5-63.7l6.5-.3 56 0 0-32-32 0C74.7 64 64 53.3 64 40S74.7 16 88 16l112 0zM64 144c-8.8 0-16 7.2-16 16l0 224c0 8.8 7.2 16 16 16l448 0c8.8 0 16-7.2 16-16l0-224c0-8.8-7.2-16-16-16L64 144zM176 368a96 96 0 1 1 0-192 96 96 0 1 1 0 192zm224 0a96 96 0 1 1 0-192 96 96 0 1 1 0 192zM176 224a48 48 0 1 0 0 96 48 48 0 1 0 0-96zm224 0a48 48 0 1 0 0 96 48 48 0 1 0 0-96zM472 32c13.3 0 24 10.7 24 24s-10.7 24-24 24L360 80c-13.3 0-24-10.7-24-24s10.7-24 24-24l112 0z"]],
    "envelope": [512, 512, [128386, 9993, 61443], "f0e0", ["M48 125.4c0 4.2 2 8.2 5.3 10.7L231.8 271.5c14.3 10.8 34.1 10.8 48.4 0L458.7 136.1c3.3-2.5 5.3-6.5 5.3-10.7 0-7.4-6-13.4-13.4-13.4L61.4 112C54 112 48 118 48 125.4zm0 66.9L48 384c0 8.8 7.2 16 16 16l384 0c8.8 0 16-7.2 16-16l0-191.7-154.8 117.4c-31.4 23.9-74.9 23.9-106.4 0L48 192.3z", "M61.4 64C27.5 64 0 91.5 0 125.4 0 126.3 0 127.1 .1 128L0 128 0 384c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-256-.1 0c0-.9 .1-1.7 .1-2.6 0-33.9-27.5-61.4-61.4-61.4L61.4 64zM464 192.3L464 384c0 8.8-7.2 16-16 16L64 400c-8.8 0-16-7.2-16-16l0-191.7 154.8 117.4c31.4 23.9 74.9 23.9 106.4 0L464 192.3zM48 125.4C48 118 54 112 61.4 112l389.2 0c7.4 0 13.4 6 13.4 13.4 0 4.2-2 8.2-5.3 10.7L280.2 271.5c-14.3 10.8-34.1 10.8-48.4 0L53.3 136.1c-3.3-2.5-5.3-6.5-5.3-10.7z"]],
    "baby": [384, 512, [], "f77c", ["M52.7 180.7c-6.2 6.2-6.2 16.4 0 22.6l18.7 18.7c12.8 12.8 27.5 23.4 43.4 31.5 8.1 4.1 13.1 12.4 13.1 21.4l0 13 128 0 0-13c0-9 5.1-17.3 13.1-21.4 15.9-8.1 30.6-18.6 43.4-31.5l18.7-18.7c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-18.7 18.7c-26 26-61.2 40.6-97.9 40.6s-72-14.6-97.9-40.6L75.3 180.7c-6.2-6.2-16.4-6.2-22.6 0zM67.4 398.2c-4.5 5.8-4.5 14 .1 19.8l32 40c5.5 6.9 15.6 8 22.5 2.5s8-15.6 2.5-22.5l-12.3-15.4c-6.9-8.7-7-21-.2-29.7l23.6-30.3-24.1-21.1-44.1 56.7zM160 80a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm88.4 282.6L272 392.9c6.8 8.8 6.7 21.1-.2 29.7L259.5 438c-5.5 6.9-4.4 17 2.5 22.5s17 4.4 22.5-2.5l32-40c4.6-5.8 4.7-14 .1-19.8l-44.1-56.7-24.1 21.1z", "M192 112a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM192 0a80 80 0 1 1 0 160 80 80 0 1 1 0-160zM75.3 180.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l18.7 18.7c12.8 12.8 27.5 23.4 43.4 31.5 8.1 4.1 13.1 12.4 13.1 21.4l0 13 128 0 0-13c0-9 5.1-17.3 13.1-21.4 15.9-8.1 30.6-18.6 43.4-31.5l18.7-18.7c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-18.7 18.7c-26 26-61.2 40.6-97.9 40.6s-72-14.6-97.9-40.6L75.3 180.7zM272.6 341.5l-24.1 21.1 23.6 30.3c6.8 8.8 6.7 21.1-.2 29.7L259.5 438c-5.5 6.9-4.4 17 2.5 22.5s17 4.4 22.5-2.5l32-40c4.6-5.8 4.7-14 .1-19.8l-44.1-56.7zm-137 21.1l-24.1-21.1-44.1 56.7c-4.5 5.8-4.5 14 .1 19.8l32 40c5.5 6.9 15.6 8 22.5 2.5s8-15.6 2.5-22.5l-12.3-15.4c-6.9-8.7-7-21-.2-29.7l23.6-30.3zM18.7 146.7c25-25 65.5-25 90.5 0L128 165.5c17 17 40 26.5 64 26.5s47-9.5 64-26.5l18.7-18.7c25-25 65.5-25 90.5 0s25 65.5 0 90.5L346.5 256c-12.9 12.9-27.2 23.9-42.5 33.1l0 14.6 50.5 65c18.2 23.4 18 56.2-.5 79.3l-32 40c-22.1 27.6-62.4 32.1-90 10s-32.1-62.4-10-90l.5-.6-5.8-7.4-49.4 0-5.8 7.4 .5 .6c22.1 27.6 17.6 67.9-10 90s-67.9 17.6-90-10L30 448c-18.5-23.1-18.7-55.9-.5-79.3l50.5-65 0-14.6c-15.4-9.2-29.7-20.3-42.5-33.1L18.7 237.3c-25-25-25-65.5 0-90.5z"]],
    "nfc-lock": [576, 512, [], "e1f8", ["M80 96c0-8.8 7.2-16 16-16l320 0c8.8 0 16 7.2 16 16l0 84c-17.8 4.6-34.1 12.9-48 24l0-36.1c0-22.1-17.9-40-40-40l-72 0c-22.1 0-40 17.9-40 40l0 56c-9.7 7.3-16 18.9-16 32 0 22.1 17.9 40 40 40s40-17.9 40-40c0-13.1-6.3-24.7-16-32l0-48 56 0 0 152.4c-2.7 2.4-5.2 5-7.6 7.6l-152.4 0 0-160 8 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-16 0c-22.1 0-40 17.9-40 40l0 176c0 22.1 17.9 40 40 40l137.3 0c-.9 5.2-1.3 10.5-1.3 15.9l0 32.1-208 0c-8.8 0-16-7.2-16-16L80 96z", "M416 80L96 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l208 0 0 48-208 0c-35.3 0-64-28.7-64-64L32 96c0-35.3 28.7-64 64-64l320 0c35.3 0 64 28.7 64 64l0 81c-5.2-.7-10.6-1-16-1-11 0-21.8 1.4-32 4l0-84c0-8.8-7.2-16-16-16zm-32 88l0 36.1c-29.3 23.5-48 59.5-48 99.9l0-128-56 0 0 48c9.7 7.3 16 18.9 16 32 0 22.1-17.9 40-40 40s-40-17.9-40-40c0-13.1 6.3-24.7 16-32l0-56c0-22.1 17.9-40 40-40l72 0c22.1 0 40 17.9 40 40zM176 336l152.4 0c-11.8 13.2-20 29.7-23.1 48L168 384c-22.1 0-40-17.9-40-40l0-176c0-22.1 17.9-40 40-40l16 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-8 0 0 160zm320-31.9c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 47.9 64 0 0-47.9zM352 400c0-20.9 13.4-38.7 32-45.3l0-50.6c0-44.2 35.8-80 80-80s80 35.8 80 80l0 50.6c18.6 6.6 32 24.4 32 45.3l0 96c0 26.5-21.5 48-48 48l-128 0c-26.5 0-48-21.5-48-48l0-96z"]],
    "square-caret-down": [448, 512, ["caret-square-down"], "f150", ["M48 96l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16zM98 206.4c3.8-8.7 12.5-14.4 22-14.4l208 0c9.5 0 18.2 5.7 22 14.4s2.1 18.9-4.4 25.9l-104 112c-4.5 4.9-10.9 7.7-17.6 7.7s-13-2.8-17.6-7.7l-104-112c-6.5-7-8.2-17.2-4.4-25.9z", "M384 432c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l320 0zm64-16c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320zM224 352c-6.7 0-13-2.8-17.6-7.7l-104-112c-6.5-7-8.2-17.2-4.4-25.9S110.5 192 120 192l208 0c9.5 0 18.2 5.7 22 14.4s2.1 18.9-4.4 25.9l-104 112c-4.5 4.9-10.9 7.7-17.6 7.7z"]],
    "hyphen": [320, 512, [], "2d", ["", "M0 256c0-13.3 10.7-24 24-24l272 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 280c-13.3 0-24-10.7-24-24z"]],
    "plane-prop": [576, 512, [], "e22b", ["M48 256c0 6.9 4.9 12.7 11.7 13.9l87.9 15.5c9.6 1.7 19.4 2.6 29.2 2.6L496 288c17.7 0 32-14.3 32-32s-14.3-32-32-32l-319.2 0c-9.8 0-19.6 .9-29.2 2.6L59.7 242.1C53 243.3 48 249.1 48 256zm202.8-80l50.2 0-18.1-136-14 0-18.1 136zm0 160l18.1 136 14 0 18.1-136-50.2 0z", "M576 256c0-44.2-35.8-80-80-80l-146.5 0-9.6-72 28.1 0 0 24c0 8.8 7.2 16 16 16s16-7.2 16-16l0-25.4c9.3-3.3 16-12.2 16-22.6s-6.7-19.3-16-22.6L400 32c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 24-34.5 0-5.8-43.2C326.2 .9 316-8 304-8L248-8c-12 0-22.2 8.9-23.8 20.8L218.5 56 200 56c-13.3 0-24 10.7-24 24s10.7 24 24 24l12.1 0-9.6 72-25.6 0c-6.8 0-13.6 .3-20.3 1l-22.5-50.7c-3.9-8.7-12.4-14.3-21.9-14.3l-40 0c-10.8 0-20.3 7.2-23.2 17.7l-20.2 74C11.3 214.8 0 234.3 0 256s11.2 41.2 28.6 52.3l20.2 74C51.7 392.8 61.2 400 72 400l40 0c9.5 0 18.1-5.6 21.9-14.3L156.5 335c6.8 .6 13.6 1 20.3 1l25.6 0 9.6 72-12.1 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l18.5 0 5.8 43.2c.2 1.5 .5 2.9 1 4.3 3.2 9.7 12.3 16.5 22.8 16.5l56 0c12 0 22.2-8.9 23.8-20.8l5.8-43.2 34.5 0 0 24c0 8.8 7.2 16 16 16s16-7.2 16-16l0-25.4c9.3-3.3 16-12.2 16-22.6s-6.7-19.3-16-22.6l0-25.4c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 24-28.1 0 9.6-72 146.5 0c44.2 0 80-35.8 80-80zM107.5 327.1l-11.1 24.9-6.1 0-8-29.3 25.1 4.4zM96.4 160l11.1 24.9-25.1 4.4 8-29.3 6.1 0zM301.1 336l-18.1 136-14 0-18.1-136 50.2 0zM250.9 176l18.1-136 14 0 18.1 136-50.2 0zM192 224l304 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-319.2 0c-9.8 0-19.6-.9-29.2-2.6L59.7 269.9C53 268.7 48 262.9 48 256s4.9-12.7 11.7-13.9l87.9-15.5c9.6-1.7 19.4-2.6 29.2-2.6l15.2 0z"]],
    "tent": [512, 512, [], "e57d", ["M53.1 432l179.1 0 0-328.4-150.2 96.1c-4.1 2.6-6.8 7-7.3 11.9L53.1 432zM280.2 104.7l0 151.3 95.3 176 83.7 0-21.5-220.2c-.5-4.9-3.2-9.3-7.4-12L280.2 104.7z", "M232.2 432l0-328.4-150.2 96.1c-4.1 2.6-6.8 7-7.3 11.9L53.1 432 232.2 432zm48-176l95.3 176 83.7 0-21.5-220.2c-.5-4.9-3.2-9.3-7.4-12l-150.2-95.1 0 151.3zM3.7 444.9L26.9 206.9c1.9-19.5 12.7-37.1 29.2-47.7L229.3 48.5c15.7-10 35.8-10.1 51.5-.1L456.1 159.3c16.7 10.6 27.5 28.2 29.5 47.8l23.2 237.8c1.8 18.8-12.9 35.1-31.8 35.1L35.5 480c-18.9 0-33.7-16.3-31.8-35.1z"]],
    "chimney": [448, 512, [], "f78b", ["M48 80l0 96 352 0 0-96-352 0zm8 408l208 0c-13.3 0-24-10.7-24-24l0-80-160 0 0 80c0 13.3-10.7 24-24 24zM80 224l0 112 80 0 0-112-80 0zm128 0l0 112 160 0 0-112-160 0zm56 264l128 0c-13.3 0-24-10.7-24-24l0-80-80 0 0 80c0 13.3-10.7 24-24 24z", "M48 176l352 0 0-96-352 0 0 96zM0 64C0 46.3 14.3 32 32 32l384 0c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32l0 240c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-80-80 0 0 80c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-80-160 0 0 80c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-240c-17.7 0-32-14.3-32-32L0 64zM80 224l0 112 80 0 0-112-80 0zm128 0l0 112 160 0 0-112-160 0z"]],
    "a": [384, 512, [97], "41", ["", "M214.1 46.7C210.4 37.8 201.7 32 192 32s-18.4 5.8-22.1 14.7l-168 400c-5.1 12.2 .6 26.3 12.8 31.4s26.3-.6 31.4-12.8l34.1-81.3 223.5 0 34.1 81.3c5.1 12.2 19.2 18 31.4 12.8s18-19.2 12.8-31.4l-168-400zM283.6 336l-183.1 0 91.6-218 91.6 218z"]],
    "circle-small": [320, 512, [], "e122", ["M48 256a112 112 0 1 0 224 0 112 112 0 1 0 -224 0z", "M272 256a112 112 0 1 0 -224 0 112 112 0 1 0 224 0zM0 256a160 160 0 1 1 320 0 160 160 0 1 1 -320 0z"]],
    "parachute-box": [512, 512, [], "f4cd", ["M50.5 176l79.7 0c5.4-57.4 20.5-108.1 41.7-145-64 24.4-110.3 76.9-121.4 145zm127.9 0l155 0C328.8 131.5 317.8 93 303.6 64.4 283 23.2 263.4 16 256 16s-27 7.2-47.6 48.4c-14.3 28.5-25.2 67-29.9 111.6zM208 384l0 64c0 8.8 7.2 16 16 16l64 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16l-64 0c-8.8 0-16 7.2-16 16zM340.1 31c21.2 36.9 36.2 87.6 41.7 145l79.7 0C450.4 107.9 404.1 55.4 340.1 31z", "M79.5 224l152.5 0 0 96-8 0c-9.3 0-18.1 2-26 5.5L79.5 224zM280 224L432.5 224 314 325.5c-7.9-3.5-16.8-5.5-26-5.5l-8 0 0-96zM8.4 226.2L164.6 360.1c-3 7.4-4.6 15.4-4.6 23.9l0 64c0 35.3 28.7 64 64 64l64 0c35.3 0 64-28.7 64-64l0-64c0-8.4-1.6-16.5-4.6-23.9L503.6 226.2c5.3-4.6 8.4-11.2 8.4-18.2 0-143.5-117.1-240-256-240S0 64.5 0 208c0 7 3.1 13.7 8.4 18.2zM50.5 176c11.1-68.1 57.3-120.6 121.4-145-21.2 36.9-36.2 87.6-41.7 145l-79.7 0zm331.2 0c-5.4-57.4-20.5-108.1-41.7-145 64 24.4 110.3 76.9 121.4 145l-79.7 0zM208.4 64.4C229 23.2 248.6 16 256 16s27 7.2 47.6 48.4c14.3 28.5 25.2 67 29.9 111.6l-155 0c4.7-44.5 15.7-83 29.9-111.6zM224 368l64 0c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16l-64 0c-8.8 0-16-7.2-16-16l0-64c0-8.8 7.2-16 16-16z"]],
    "cart-flatbed-boxes": [576, 512, ["dolly-flatbed-alt"], "f475", ["M208 128l0 160c0 8.8 7.2 16 16 16l64 0c8.8 0 16-7.2 16-16l0-160c0-8.8-7.2-16-16-16l-64 0c-8.8 0-16 7.2-16 16zm144 80l0 80c0 8.8 7.2 16 16 16l80 0c8.8 0 16-7.2 16-16l0-80c0-8.8-7.2-16-16-16l-80 0c-8.8 0-16 7.2-16 16z", "M0 24C0 10.7 10.7 0 24 0L56 0c30.9 0 56 25.1 56 56l0 320c0 13.3 10.7 24 24 24l416 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-42.7 0c1.8 5 2.7 10.4 2.7 16 0 26.5-21.5 48-48 48s-48-21.5-48-48c0-5.6 1-11 2.7-16l-197.5 0c1.8 5 2.7 10.4 2.7 16 0 26.5-21.5 48-48 48s-48-21.5-48-48c0-5.7 1-11.1 2.8-16.2-37.3-2.7-66.8-33.8-66.8-71.8L64 56c0-4.4-3.6-8-8-8L24 48C10.7 48 0 37.3 0 24zm288 88l-64 0c-8.8 0-16 7.2-16 16l0 160c0 8.8 7.2 16 16 16l64 0c8.8 0 16-7.2 16-16l0-160c0-8.8-7.2-16-16-16zm64 34c5.1-1.3 10.5-2 16-2l80 0c35.3 0 64 28.7 64 64l0 80c0 35.3-28.7 64-64 64l-80 0c-15.1 0-29-5.3-40-14-11 8.8-24.9 14-40 14l-64 0c-35.3 0-64-28.7-64-64l0-160c0-35.3 28.7-64 64-64l64 0c35.3 0 64 28.7 64 64l0 18zm0 62l0 80c0 8.8 7.2 16 16 16l80 0c8.8 0 16-7.2 16-16l0-80c0-8.8-7.2-16-16-16l-80 0c-8.8 0-16 7.2-16 16z"]],
    "cart-arrow-down": [640, 512, [], "f218", ["M124.6 31.3l187.4 0 0 86.8-31-31c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l72 72c9.4 9.4 24.6 9.4 33.9 0l72-72c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-31 31 0-86.8 208.2 0-1.1 6c-3-2.4-6.5-4.1-10.5-4.9-13-2.5-25.6 6-28.1 19L495.9 220.5c-2.2 11.3-12.1 19.5-23.6 19.5l-309.8 0-38-208.7z", "M0 8C0-5.3 10.7-16 24-16l45.3 0c27.1 0 50.3 19.4 55.1 46l38.2 210 309.8 0c11.5 0 21.4-8.2 23.6-19.5L528.4 51.5c2.5-13 15.1-21.5 28.1-19s21.5 15.1 19 28.1L543.1 229.6c-6.5 33.9-36.2 58.4-70.7 58.4l-301 0 5.1 28.3c2.1 11.4 12 19.7 23.6 19.7L456 336c13.3 0 24 10.7 24 24s-10.7 24-24 24l-255.9 0c-34.8 0-64.6-24.9-70.8-59.1L77.2 38.6c-.7-3.8-4-6.6-7.9-6.6L24 32C10.7 32 0 21.3 0 8zM160 464a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm224 0a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM319 193l-72-72c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l31 31 0-102.1c0-13.3 10.7-24 24-24s24 10.7 24 24l0 102.1 31-31c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-72 72c-9.4 9.4-24.6 9.4-33.9 0z"]],
    "circle-7": [512, 512, [], "e0f4", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm128-88c0-13.3 10.7-24 24-24l112 0c8.3 0 16 4.3 20.4 11.4s4.8 15.9 1 23.4l-88 176c-5.9 11.9-20.3 16.7-32.2 10.7s-16.7-20.3-10.7-32.2L273.2 192 200 192c-13.3 0-24-10.7-24-24z", "M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM200 144c-13.3 0-24 10.7-24 24s10.7 24 24 24l73.2 0-70.6 141.3c-5.9 11.9-1.1 26.3 10.7 32.2s26.3 1.1 32.2-10.7l88-176c3.7-7.4 3.3-16.3-1-23.4S320.3 144 312 144l-112 0z"]],
    "lock-hashtag": [384, 512, [], "e423", ["M48 224l0 224c0 8.8 7.2 16 16 16l256 0c8.8 0 16-7.2 16-16l0-224c0-8.8-7.2-16-16-16-16 0-32 0-48 0-125.3 0-194.7 0-208 0-8.8 0-16 7.1-16 16zm44 72c0-11 9-20 20-20l20 0 0-20c0-11 9-20 20-20s20 9 20 20l0 20 40 0 0-20c0-11 9-20 20-20s20 9 20 20l0 20 20 0c11 0 20 9 20 20s-9 20-20 20l-20 0 0 40 20 0c11 0 20 9 20 20s-9 20-20 20l-20 0 0 20c0 11-9 20-20 20s-20-9-20-20l0-20-40 0 0 20c0 11-9 20-20 20s-20-9-20-20l0-20-20 0c-11 0-20-9-20-20s9-20 20-20l20 0 0-40-20 0c-11 0-20-9-20-20zm80 20l0 40 40 0 0-40-40 0z", "M112 96l0 64 160 0 0-64c0-44.2-35.8-80-80-80s-80 35.8-80 80zM64 160l0-64C64 25.3 121.3-32 192-32S320 25.3 320 96l0 64c35.3 0 64 28.7 64 64l0 224c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 224c0-35.3 28.7-64 64-64zm208 48l-160 0 0 0-48 0 0 0c-8.8 0-16 7.2-16 16l0 224c0 8.8 7.2 16 16 16l256 0c8.8 0 16-7.2 16-16l0-224c0-8.8-7.2-16-16-16l0 0-48 0 0 0zM152 236c11 0 20 9 20 20l0 20 40 0 0-20c0-11 9-20 20-20s20 9 20 20l0 20 20 0c11 0 20 9 20 20s-9 20-20 20l-20 0 0 40 20 0c11 0 20 9 20 20s-9 20-20 20l-20 0 0 20c0 11-9 20-20 20s-20-9-20-20l0-20-40 0 0 20c0 11-9 20-20 20s-20-9-20-20l0-20-20 0c-11 0-20-9-20-20s9-20 20-20l20 0 0-40-20 0c-11 0-20-9-20-20s9-20 20-20l20 0 0-20c0-11 9-20 20-20zm20 80l0 40 40 0 0-40-40 0z"]],
    "circle-sterling": [512, 512, [], "e5cf", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm98.7 115.1c-4.1-7.9-3.5-17.5 1.6-24.8l30.2-43.1c8.1-11.5 11.6-25.5 10.3-39.1L176 264c-8.8 0-16-7.2-16-16s7.2-16 16-16l2.9 0c-15.8-55.2 25.5-112 84.7-112l2.2 0c19.7 0 38.8 6.4 54.5 18.2l14.2 10.6c10.6 8 12.8 23 4.8 33.6s-23 12.8-33.6 4.8l-14.2-10.6C284 171 275 168 265.7 168l-2.2 0c-28.5 0-47.8 28.9-37 55.2l2.5 6c.4 .9 .7 1.8 1.1 2.8l73.9 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-67.1 0c1.3 23.4-5.2 46.9-19.1 66.6l-3.7 5.4 113.9 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-160 0c-8.9 0-17.2-5-21.3-12.9z", "M464 256a208 208 0 1 0 -416 0 208 208 0 1 0 416 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm176 8c-8.8 0-16-7.2-16-16s7.2-16 16-16l2.9 0c-15.8-55.2 25.5-112 84.7-112l2.2 0c19.7 0 38.8 6.4 54.5 18.2l14.2 10.6c10.6 8 12.8 23 4.8 33.6s-23 12.8-33.6 4.8l-14.2-10.6C284 171 275 168 265.7 168l-2.2 0c-28.5 0-47.8 28.9-37 55.2l2.5 6c.4 .9 .7 1.8 1.1 2.8l73.9 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-67.1 0c1.3 23.4-5.2 46.9-19.1 66.6l-3.7 5.4 113.9 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-160 0c-8.9 0-17.2-5-21.3-12.9s-3.5-17.5 1.6-24.8l30.2-43.1c8.1-11.5 11.6-25.5 10.3-39.1L176 264z"]],
    "bridge-circle-exclamation": [576, 512, [], "e4ca", ["M48 192l416 0 0 18.7c-10.4-1.7-21.1-2.7-32-2.7-52.7 0-100.5 21.3-135.2 55.7-12.6-5-26.4-7.7-40.8-7.7-61.9 0-112 50.1-112 112l0 64-48 0 0-102.6c0-35.7-18.3-68.7-48-87.6L48 192z", "M24 32C10.7 32 0 42.7 0 56S10.7 80 24 80l16 0 0 64-16 0c-13.3 0-24 10.7-24 24l0 88c0 9.1 5.1 17.4 13.3 21.5l3.8 1.9c19 9.5 31 28.9 31 50.1L48 440c0 22.1 17.9 40 40 40l64 0c22.1 0 40-17.9 40-40l0-72c0-35.3 28.7-64 64-64 3.2 0 6.3 .2 9.3 .7 8.6-15.1 19.3-28.9 31.5-41-12.6-5-26.4-7.7-40.8-7.7-61.9 0-112 50.1-112 112l0 64-48 0 0-102.6c0-35.7-18.3-68.7-48-87.6l0-49.8 416 0 0 18.7c16.8 2.8 32.9 7.8 48 14.8l0-57.4c0-13.3-10.7-24-24-24l-16 0 0-64 16 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L24 32zM424 80l0 64-80 0 0-64 80 0zM296 80l0 64-80 0 0-64 80 0zM168 80l0 64-80 0 0-64 80 0zM432 544a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm0-100a20 20 0 1 1 0 40 20 20 0 1 1 0-40zm0-140c8.8 0 16 7.2 16 16l0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80c0-8.8 7.2-16 16-16z"]],
    "cloud-arrow-up": [576, 512, [62338, "cloud-upload", "cloud-upload-alt"], "f0ee", ["M48 336c0 53 43 96 96 96l304 0c44.2 0 80-35.8 80-80 0-37.4-25.7-68.9-60.5-77.6-7.5-1.9-13.6-7.2-16.5-14.3s-2.1-15.2 2-21.7c7-11.1 11-24.2 11-38.3 0-39.8-32.2-72-72-72-11.1 0-21.5 2.5-30.8 6.9-10.5 5-23.1 1.7-29.8-7.8-20.3-28.6-53.7-47.1-91.3-47.1-61.9 0-112 50.1-112 112 0 8.4 .9 16.6 2.7 24.5 2.7 12.1-4.3 24.3-16.1 28.1-38.7 12.4-66.6 48.7-66.6 91.4zm159-73l64-64c9.4-9.4 24.6-9.4 33.9 0l64 64c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-23-23 0 86.1c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-86.1-23 23c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9z", "M240 32c-88.4 0-160 71.6-160 160 0 4.9 .2 9.8 .7 14.6-47.8 23.4-80.7 72.5-80.7 129.4 0 79.5 64.5 144 144 144l304 0c70.7 0 128-57.3 128-128 0-49.9-28.5-93-70.1-114.2 4-11.9 6.1-24.6 6.1-37.8 0-66.3-53.7-120-120-120-11.5 0-22.7 1.6-33.3 4.7-29.3-32.3-71.6-52.7-118.7-52.7zM128 192c0-61.9 50.1-112 112-112 37.7 0 71 18.6 91.3 47.1 6.7 9.5 19.3 12.8 29.8 7.8 9.3-4.4 19.7-6.9 30.8-6.9 39.8 0 72 32.2 72 72 0 14.1-4 27.2-11 38.3-4.1 6.5-4.8 14.6-2 21.7s9 12.5 16.5 14.3c34.8 8.7 60.5 40.2 60.5 77.6 0 44.2-35.8 80-80 80l-304 0c-53 0-96-43-96-96 0-42.7 27.9-79 66.6-91.4 11.8-3.8 18.8-16 16.1-28.1-1.8-7.9-2.7-16.1-2.7-24.5zm177 7c-9.4-9.4-24.6-9.4-33.9 0l-64 64c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l23-23 0 86.1c0 13.3 10.7 24 24 24s24-10.7 24-24l0-86.1 23 23c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-64-64z"]],
    "at": [512, 512, [61946], "40", ["", "M256 48C141.1 48 48 141.1 48 256s93.1 208 208 208c13.3 0 24 10.7 24 24s-10.7 24-24 24C114.6 512 0 397.4 0 256S114.6 0 256 0 512 114.6 512 256l0 28c0 50.8-41.2 92-92 92-31.1 0-58.7-15.5-75.3-39.2-21.9 24.1-53.6 39.2-88.7 39.2-66.3 0-120-53.7-120-120s53.7-120 120-120c28.8 0 55.2 10.1 75.8 27 4.3-6.6 11.7-11 20.2-11 13.3 0 24 10.7 24 24l0 108c0 24.3 19.7 44 44 44s44-19.7 44-44l0-28c0-114.9-93.1-208-208-208zm72 208a72 72 0 1 0 -144 0 72 72 0 1 0 144 0z"]],
    "indian-rupee-sign": [320, 512, ["indian-rupee", "inr"], "e1bc", ["", "M0 56C0 42.7 10.8 32 24 32l272 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-84.7 0c17.7 19.8 30.1 44.6 34.7 72l50 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-50 0c-11.4 68.1-70.7 120-142 120L98.9 320 262 436.5c10.8 7.7 13.3 22.7 5.6 33.5s-22.7 13.3-33.5 5.6l-224-160C1.6 309.5-2 298.6 1.1 288.7S13.6 272 24 272l80 0c44.7 0 82.3-30.6 93-72L24 200c-13.3 0-24-10.7-24-24s10.7-24 24-24l173 0c-10.7-41.4-48.2-72-93-72L24 80C10.8 80 0 69.3 0 56z"]],
    "truck": [576, 512, [128666, 9951], "f0d1", ["M48 96l0 288c0 8.8 7.2 16 16 16l3.3 0c10.4-36.9 44.4-64 84.7-64s74.2 27.1 84.7 64l102.6 0c4.9-17.4 15.1-32.7 28.7-43.9L368 96c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16zM416 304l0 32.4c2.6-.2 5.3-.4 8-.4 40.3 0 74.2 27.1 84.7 64l3.3 0c8.8 0 16-7.2 16-16l0-80-112 0z", "M64 80c-8.8 0-16 7.2-16 16l0 288c0 8.8 7.2 16 16 16l3.3 0c10.4-36.9 44.4-64 84.7-64s74.2 27.1 84.7 64l102.6 0c4.9-17.4 15.1-32.7 28.7-43.9L368 96c0-8.8-7.2-16-16-16L64 80zm3.3 368L64 448c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l288 0c35.3 0 64 28.7 64 64l0 32 55.4 0c17 0 33.3 6.7 45.3 18.7l40.6 40.6c12 12 18.7 28.3 18.7 45.3L576 384c0 35.3-28.7 64-64 64l-3.3 0c-10.4 36.9-44.4 64-84.7 64s-74.2-27.1-84.7-64l-102.6 0c-10.4 36.9-44.4 64-84.7 64s-74.2-27.1-84.7-64zM416 256l112 0 0-23.4c0-4.2-1.7-8.3-4.7-11.3l-40.6-40.6c-3-3-7.1-4.7-11.3-4.7l-55.4 0 0 80zm0 48l0 32.4c2.6-.2 5.3-.4 8-.4 40.3 0 74.2 27.1 84.7 64l3.3 0c8.8 0 16-7.2 16-16l0-80-112 0zM152 464a40 40 0 1 0 0-80 40 40 0 1 0 0 80zm272 0a40 40 0 1 0 0-80 40 40 0 1 0 0 80z"]],
    "game-console-handheld-crank": [576, 512, [], "e5b9", ["M48 96l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16zm48 64c0-17.7 14.3-32 32-32l192 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-192 0c-17.7 0-32-14.3-32-32l0-64zm0 176c0-8.8 7.2-16 16-16l16 0 0-16c0-8.8 7.2-16 16-16s16 7.2 16 16l0 16 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0 0 16c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-16-16 0c-8.8 0-16-7.2-16-16zm192-8a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm64 0a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M64 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 176 32 0 0-104c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24l0 32c0 13.3-10.7 24-24 24l-24 0 0 72c0 13.3-10.7 24-24 24l-56 0 0 96c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm128 32l192 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-192 0c-17.7 0-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32zm16 160c8.8 0 16 7.2 16 16l0 16 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0 0 16c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-16-16 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0 0-16c0-8.8 7.2-16 16-16zm120 16a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm40 24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"]],
    "chalkboard-user": [640, 512, ["chalkboard-teacher"], "f51c", ["M176 96c0-8.8 7.2-16 16-16l352 0c8.8 0 16 7.2 16 16l0 288c0 8.8-7.2 16-16 16l-32 0 0-16c0-17.7-14.3-32-32-32l-96 0c-17.7 0-32 14.3-32 32l0 16-38.9 0c-15.6-23.9-38.2-42.7-64.9-53.6 15-21 23.8-46.7 23.8-74.4 0-59.6-40.8-109.8-96-124l0-52z", "M192 80l352 0c8.8 0 16 7.2 16 16l0 288c0 8.8-7.2 16-16 16l-32 0 0-16c0-17.7-14.3-32-32-32l-96 0c-17.7 0-32 14.3-32 32l0 16-38.9 0c9.4 14.4 16.3 30.6 19.9 48l211 0c35.3 0 64-28.7 64-64l0-288c0-35.3-28.7-64-64-64L192 32c-35.3 0-64 28.7-64 64l0 49c5.2-.7 10.6-1 16-1 11 0 21.8 1.4 32 4l0-52c0-8.8 7.2-16 16-16zM144 352a80 80 0 1 0 0-160 80 80 0 1 0 0 160zM96 384c-53 0-96 43-96 96 0 17.7 14.3 32 32 32l224 0c17.7 0 32-14.3 32-32 0-53-43-96-96-96l-96 0z"]],
    "user-check": [640, 512, [], "f4fc", ["M56.3 512c13.3 0 24-10.7 24-24l0-8c0-70.7 57.3-128 128-128l96 0c70.7 0 128 57.3 128 128l0 8c0 13.3 10.7 24 24 24l-400 0zm280-384a80 80 0 1 1 -160 0 80 80 0 1 1 160 0z", "M304.3 304c97.2 0 176 78.8 176 176l0 8c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-8c0-70.7-57.3-128-128-128l-96 0c-70.7 0-128 57.3-128 128l0 8c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-8c0-97.2 78.8-176 176-176l96 0zM585.7 105.9c7.8-10.7 22.8-13.1 33.5-5.3s13.1 22.8 5.3 33.5L522.1 274.9c-4.2 5.7-10.7 9.3-17.7 9.8s-14-2.2-18.9-7.3l-46.4-48c-9.2-9.5-9-24.7 .6-33.9 9.5-9.2 24.7-8.9 33.9 .6l26.5 27.4 85.6-117.7zM256.3 256a128 128 0 1 1 0-256 128 128 0 1 1 0 256zm0-208a80 80 0 1 0 0 160 80 80 0 1 0 0-160z"]],
    "chart-pie-simple-circle-currency": [640, 512, [], "e604", ["M80 272c0-83.6 53.4-154.7 128-181.1L208 296c0 22.1 17.9 40 40 40l66.9 0c-7.1 20-10.9 41.6-10.9 64 0 20.8 3.3 40.8 9.4 59.5-13.3 2.9-27.2 4.5-41.4 4.5-106 0-192-86-192-192z", "M352 192l138 0C472.6 124.6 419.4 71.4 352 54l0 138zm144 16c-39.3 0-75.8 11.8-106.2 32L336 240c-17.7 0-32-14.3-32-32l0-176c0-17.7 14.4-32.2 31.9-29.9 107 14.2 191.8 99 206 206 .2 1.9 .3 3.7 .2 5.5-14.8-3.6-30.2-5.6-46.1-5.6zM256 288l84 0c-10.5 14.6-19 30.7-25.1 48L248 336c-22.1 0-40-17.9-40-40l0-205.1c-74.6 26.4-128 97.5-128 181.1 0 106 86 192 192 192 14.2 0 28.1-1.5 41.4-4.5 5.1 15.8 12.2 30.6 21 44.3-19.9 5.4-40.8 8.2-62.4 8.2-132.5 0-240-107.4-240-240 0-110 73.9-202.6 174.7-231 26.5-7.5 49.3 13.7 49.3 38l0 209zm96 112a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm219.3-52.7c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-20.2 20.2c-9.5-5.6-20.6-8.9-32.5-8.9s-23 3.2-32.5 8.9l-20.2-20.2c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l20.2 20.2c-5.6 9.5-8.9 20.6-8.9 32.5s3.2 23 8.9 32.5l-20.2 20.2c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l20.2-20.2c9.5 5.6 20.6 8.9 32.5 8.9s23-3.2 32.5-8.9l20.2 20.2c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-20.2-20.2c5.6-9.5 8.9-20.6 8.9-32.5s-3.2-23-8.9-32.5l20.2-20.2zM496 368a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]],
    "face-fearful": [512, 512, [], "e375", ["M48 256c0 114.9 93.1 208 208 208s208-93.1 208-208c0-42-12.5-81.1-33.9-113.8-7.6 7.6-19.9 7.8-27.8 .4-14.9-13.9-33.5-23.1-53.8-25.8-4.1-.5-8.3-.8-12.5-.8-11 0-20-9-20-20s9-20 20-20c6 0 11.9 .4 17.7 1.2 4.1 .5 8.1 1.3 12.1 2.2-31.9-19.9-69.5-31.3-109.8-31.3S178.1 59.5 146.2 79.3c4-.9 8-1.6 12.1-2.2 5.8-.8 11.7-1.2 17.7-1.2 11 0 20 9 20 20s-9 20-20 20c-4.2 0-8.4 .3-12.5 .8-20.3 2.7-38.9 11.9-53.8 25.8-7.9 7.4-20.2 7.1-27.8-.4-21.4 32.7-33.9 71.8-33.9 113.8zm192-32a80 80 0 1 1 -160 0 80 80 0 1 1 160 0zM176 400c0-44.2 35.8-80 80-80s80 35.8 80 80c0 8.8-7.2 16-16 16l-128 0c-8.8 0-16-7.2-16-16zM432 224a80 80 0 1 1 -160 0 80 80 0 1 1 160 0z", "M464 256c0-42-12.5-81.1-33.9-113.8-7.6 7.6-19.9 7.8-27.8 .4-14.9-13.9-33.5-23.1-53.8-25.8-4.1-.5-8.3-.8-12.5-.8-11 0-20-9-20-20s9-20 20-20c6 0 11.9 .4 17.7 1.2 4.1 .5 8.1 1.3 12.1 2.2-31.9-19.9-69.5-31.3-109.8-31.3S178.1 59.5 146.2 79.3c4-.9 8-1.6 12.1-2.2 5.8-.8 11.7-1.2 17.7-1.2 11 0 20 9 20 20s-9 20-20 20c-4.2 0-8.4 .3-12.5 .8-20.3 2.7-38.9 11.9-53.8 25.8-7.9 7.4-20.2 7.1-27.8-.4-21.4 32.7-33.9 71.8-33.9 113.8 0 114.9 93.1 208 208 208s208-93.1 208-208zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm256 64c44.2 0 80 35.8 80 80 0 8.8-7.2 16-16 16l-128 0c-8.8 0-16-7.2-16-16 0-44.2 35.8-80 80-80zM136 224a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm216-24a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM160 176a48 48 0 1 0 0 96 48 48 0 1 0 0-96zm80 48a80 80 0 1 1 -160 0 80 80 0 1 1 160 0zm64 0a48 48 0 1 0 96 0 48 48 0 1 0 -96 0zm48 80a80 80 0 1 1 0-160 80 80 0 1 1 0 160z"]],
    "user-ninja": [448, 512, [129399], "f504", ["M24.5 512c13-.3 23.5-10.9 23.5-24l0-8c0-56.8 37.1-105.1 88.4-121.8 49.1 52 91.2 96.5 126.2 133.5 9.1 9.6 24.3 10.1 33.9 1s10.1-24.3 1-33.9L257 416 311.6 358.2C362.9 374.9 400 423.2 400 480l0 8c0 13.1 10.5 23.7 23.5 24-133 0-266 0-399 0z", "M352 128c0-70.7-57.3-128-128-128-49.6 0-92.6 28.2-113.8 69.4-3-5.8-6.8-11.3-11.7-16.1-15.8-15.8-38.8-20.7-53.6-22.1-8.1-.8-14.6 5.7-13.8 13.8 1.4 14.7 6.3 37.8 22.1 53.6 5.8 5.8 12.6 10.1 19.6 13.4-7 3.2-13.8 7.6-19.6 13.4-15.8 15.8-20.7 38.8-22.1 53.6-.8 8.1 5.7 14.6 13.8 13.8 14.7-1.4 37.8-6.3 53.6-22.1 1.2-1.2 2.4-2.5 3.5-3.8 16.4 51.8 64.8 89.3 122 89.3 70.7 0 128-57.3 128-128zM144 112c0-8.8 7.2-16 16-16l128 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-128 0c-8.8 0-16-7.2-16-16zm-1.2 195.4c-1.4 .1-2.9 .3-4.3 .6-79.2 17.2-138.5 87.6-138.5 172l0 8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-8c0-56.8 37.1-105.1 88.4-121.8l70.2 74.2 0 0 56 59.2c9.1 9.6 24.3 10.1 33.9 1s10.1-24.3 1-33.9L257 416 311.6 358.2C362.9 374.9 400 423.2 400 480l0 8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-8c0-84.5-59.6-155.1-139-172.1-8.2-1.8-16.7 .9-22.5 7l-62.6 66.2-62.6-66.2c-4.1-4.4-9.5-6.9-15.1-7.4-1.2-.1-2.3-.1-3.5-.1z"]],
    "frame": [512, 512, [], "e495", ["M112 112l0 288 288 0 0-288-288 0z", "M512 88c0-13.3-10.7-24-24-24l-40 0 0-40c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 40-288 0 0-40c0-13.3-10.7-24-24-24S64 10.7 64 24l0 40-40 0C10.7 64 0 74.7 0 88s10.7 24 24 24l40 0 0 288-40 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l40 0 0 40c0 13.3 10.7 24 24 24s24-10.7 24-24l0-40 288 0 0 40c0 13.3 10.7 24 24 24s24-10.7 24-24l0-40 40 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-40 0 0-288 40 0c13.3 0 24-10.7 24-24zM112 400l0-288 288 0 0 288-288 0z"]],
    "plant-wilt": [512, 512, [], "e5aa", ["M48 331.1s0 .7 .3 2.3c.3 1.6 .8 3.7 1.7 6.4 1.8 5.4 4.9 12.2 9.3 19.8 5.4 9.3 12.3 19.2 20.7 28.8 8.3-9.7 15.3-19.6 20.7-28.8 4.4-7.7 7.4-14.4 9.3-19.8 .9-2.7 1.4-4.8 1.7-6.4 .3-1.5 .3-2.3 .3-2.3 0-23.1-13.7-35.1-32-35.1s-32 11.9-32 35.1zm352-160s0 .7 .3 2.3c.3 1.6 .8 3.7 1.8 6.4 1.8 5.4 4.9 12.2 9.3 19.8 5.4 9.3 12.3 19.2 20.7 28.8 8.3-9.7 15.3-19.6 20.7-28.8 4.4-7.7 7.4-14.4 9.3-19.8 .9-2.7 1.4-4.8 1.8-6.4 .3-1.5 .3-2.3 .3-2.3 0-23.1-13.7-35.1-32-35.1s-32 11.9-32 35.1z", "M344-32c61.9 0 112 50.1 112 112l0 11.4c31.3 9.2 52.6 36.3 55.6 71l.4 8.7c0 27.9-25.3 74.8-66 111.7-3.8 3.5-8.8 5.3-14 5.3s-10.2-1.8-14-5.3c-40.7-36.8-66-83.7-66-111.7l.4-8.7c3.1-34.6 24.3-61.8 55.6-71L408 80c0-35.3-28.7-64-64-64s-64 28.7-64 64l0 440c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-312c0-35.3-28.7-64-64-64s-64 28.7-64 64l0 40.2c0 1-.1 2-.2 3 31.4 9.1 52.8 36.3 55.8 71.1l.4 8.7c0 27.9-25.3 74.8-66 111.7-3.8 3.5-8.8 5.3-14 5.3s-10.2-1.8-14-5.3C25.3 405.9 0 359 0 331.1l.4-8.7c3.1-34.7 24.4-61.9 55.8-71-.1-1-.2-2-.2-3.1L56 208c0-61.9 50.1-112 112-112 23.8 0 45.9 7.4 64 20.1L232 80c0-61.9 50.1-112 112-112zM80 296c-18.3 0-32 11.9-32 35.1 0 0 0 .7 .3 2.3 .3 1.6 .8 3.7 1.7 6.4 1.8 5.4 4.9 12.2 9.3 19.8 5.4 9.3 12.3 19.2 20.7 28.8 8.3-9.7 15.3-19.6 20.7-28.8 4.4-7.7 7.4-14.4 9.3-19.8 .9-2.7 1.4-4.8 1.7-6.4 .3-1.5 .3-2.3 .3-2.3 0-23.1-13.7-35.1-32-35.1zM432 136c-18.3 0-32 11.9-32 35.1 0 0 0 .7 .3 2.3 .3 1.6 .8 3.7 1.8 6.4 1.8 5.4 4.9 12.2 9.3 19.8 5.4 9.3 12.3 19.2 20.7 28.8 8.3-9.7 15.3-19.6 20.7-28.8 4.4-7.7 7.4-14.4 9.3-19.8 .9-2.7 1.4-4.8 1.8-6.4 .3-1.5 .3-2.3 .3-2.3 0-23.1-13.7-35.1-32-35.1z"]],
    "weight-scale": [448, 512, ["weight"], "f496", ["M48 96l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16l-31 0c9.6 19.3 15 41 15 64 0 22-4.9 42.8-13.7 61.4-5.7 12.1-18.5 18.6-31.9 18.6l-196.8 0c-13.3 0-26.2-6.5-31.9-18.6-8.8-18.6-13.7-39.5-13.7-61.4 0-23 5.4-44.7 15-64L64 80c-8.8 0-16 7.2-16 16z", "M314.6 176c3.5-10 5.4-20.7 5.4-32 0-53-43-96-96-96s-96 43-96 96c0 11.3 1.9 22 5.4 32l71.4 0 29.2-65.7c5.4-12.1 19.6-17.6 31.7-12.2s17.6 19.6 12.2 31.7l-20.6 46.3 57.2 0zm39.7 29.4c-5.7 12.1-18.5 18.6-31.9 18.6l-196.8 0c-13.3 0-26.2-6.5-31.9-18.6-8.8-18.6-13.7-39.5-13.7-61.4 0-23 5.4-44.7 15-64L64 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16l-31 0c9.6 19.3 15 41 15 64 0 22-4.9 42.8-13.7 61.4zM64 32l69.5 0C158.2 12 189.7 0 224 0s65.8 12 90.5 32L384 32c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32z"]],
    "farm": [576, 512, ["barn-silo"], "f864", ["M48 80l0 18.2 89.4 0c9.8-13.2 22.4-24.2 37-32.2-6.4-28.6-31.9-50-62.5-50-35.3 0-64 28.7-64 64zm0 66.2L48 448c0 8.8 7.2 16 16 16l49.1 0c-.7-5.2-1.1-10.6-1.1-16l0-110.6c-19.6-17-32-42.1-32-70 0-10 1.6-19.9 4.8-29.3l30.6-91.9-67.4 0zM177.3 264l6.7 0c13.3 0 24 10.7 24 24l0 160c0 8.8 7.2 16 16 16l48 0 0-72c0-30.9 25.1-56 56-56l48 0c30.9 0 56 25.1 56 56l0 72 48 0c8.8 0 16-7.2 16-16l0-160c0-13.3 10.7-24 24-24l6.7 0-34.4-103.3c-1.7-5-5.3-9-10.1-11.2L359.8 93.9c-5-2.3-10.6-2.3-15.6 0L221.8 149.5c-4.8 2.2-8.4 6.2-10.1 11.2L177.3 264zM304 200c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-48z", "M64 464l49.1 0c2.5 17.7 9.2 34 18.9 48L64 512c-35.3 0-64-28.7-64-64L0 80C0 18.1 50.1-32 112-32 161.8-32 204.1 .5 218.6 45.5L182.1 62.1c-2.6 1.2-5.1 2.5-7.6 3.8-6.4-28.6-31.9-50-62.5-50-35.3 0-64 28.7-64 64l0 18.2 89.4 0c-7.2 9.7-12.9 20.5-16.8 32.2l-5.3 15.8-67.4 0 0 301.8c0 8.8 7.2 16 16 16zM344.2 93.9L221.8 149.5c-4.8 2.2-8.4 6.2-10.1 11.2L177.3 264 184 264c13.3 0 24 10.7 24 24l0 160c0 8.8 7.2 16 16 16l48 0 0-72c0-30.9 25.1-56 56-56l48 0c30.9 0 56 25.1 56 56l0 72 48 0c8.8 0 16-7.2 16-16l0-160c0-13.3 10.7-24 24-24l6.7 0-34.4-103.3c-1.7-5-5.3-9-10.1-11.2L359.8 93.9c-5-2.3-10.6-2.3-15.6 0zM480 512l-256 0c-35.3 0-64-28.7-64-64l0-137.8c-18.5-5.5-32-22.6-32-42.8 0-4.8 .8-9.6 2.3-14.1l35.9-107.7c5.9-17.6 18.8-32 35.8-39.7L324.3 50.2c17.6-8 37.8-8 55.3 0l122.4 55.6c16.9 7.7 29.9 22.1 35.8 39.7l35.9 107.7c1.5 4.6 2.3 9.3 2.3 14.1 0 20.3-13.5 37.4-32 42.8L544 448c0 35.3-28.7 64-64 64zM384 392c0-4.4-3.6-8-8-8l-48 0c-4.4 0-8 3.6-8 8l0 72 64 0 0-72zM328 176l48 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-48c0-13.3 10.7-24 24-24z"]],
    "caret-right": [256, 512, [], "f0da", ["M112.3 166.6l89.4 89.4-89.4 89.4 0-178.8z", "M246.9 233.4c11.6 12.9 12.8 32.4 0 45.2l-128 128c-9.1 9.2-22.9 11.9-34.9 6.9l-4.3-2.2c-9.5-5.7-15.5-16.1-15.5-27.4l0-256 .3-4.8c1.4-9.4 7-17.7 15.1-22.6l4.3-2.2c12-4.9 25.7-2.2 34.9 6.9l128 128zM112.3 166.6l0 178.8 89.4-89.4-89.4-89.4z"]],
    "hexagon-divide": [576, 512, [], "e1ad", ["M75.2 244.1c-4.2 7.4-4.2 16.5 0 23.8L171.4 436c4.3 7.5 12.2 12.1 20.8 12.1l191.6 0c8.6 0 16.6-4.6 20.8-12.1L500.8 268c4.2-7.4 4.2-16.5 0-23.8L404.7 76.1C400.4 68.6 392.4 64 383.8 64L192.2 64c-8.6 0-16.6 4.6-20.8 12.1L75.2 244.1zM176 256c0-13.3 10.7-24 24-24l176 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-176 0c-13.3 0-24-10.7-24-24zm144-96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm0 192a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M33.5 220.3c-12.7 22.2-12.7 49.4 0 71.5l96.2 168.1c12.8 22.4 36.7 36.2 62.5 36.2l191.6 0c25.8 0 49.7-13.8 62.5-36.2l96.2-168.1c12.7-22.2 12.7-49.4 0-71.5L446.3 52.2C433.5 29.8 409.6 16 383.8 16L192.2 16c-25.8 0-49.7 13.8-62.5 36.2L33.5 220.3zM75.2 268c-4.2-7.4-4.2-16.5 0-23.8L171.4 76.1c4.3-7.5 12.2-12.1 20.8-12.1l191.6 0c8.6 0 16.6 4.6 20.8 12.1l96.2 168.1c4.2 7.4 4.2 16.5 0 23.8L404.7 436c-4.3 7.5-12.2 12.1-20.8 12.1l-191.6 0c-8.6 0-16.6-4.6-20.8-12.1L75.2 268zM288 192a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm-88 40c-13.3 0-24 10.7-24 24s10.7 24 24 24l176 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-176 0zM320 352a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"]],
    "florin-sign": [384, 512, [], "e184", ["", "M315.3 32c-36 0-68.3 21.9-81.7 55.3L179 224 56 224c-13.3 0-24 10.7-24 24s10.7 24 24 24l103.8 0-53.9 134.9C99.7 422 85 432 68.7 432L24 432c-13.3 0-24 10.7-24 24s10.7 24 24 24l44.7 0c36 0 68.3-21.9 81.7-55.3L211.4 272 328 272c13.3 0 24-10.7 24-24s-10.7-24-24-24l-97.4 0 47.5-118.9C284.3 90 299 80 315.3 80L360 80c13.3 0 24-10.7 24-24s-10.7-24-24-24l-44.7 0z"]],
    "lightbulb-exclamation-on": [640, 512, [], "e1ca", ["M176 192c0 38.4 15 73.2 39.5 99 21.3 22.5 44.9 54 53.3 93l102.4 0c8.4-39 32-70.5 53.3-93 24.5-25.8 39.5-60.6 39.5-99 0-79.5-64.5-144-144-144S176 112.5 176 192zm176 88a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM289 138.6c-2-18.5 12.4-34.6 31-34.6s33 16.1 31 34.6l-7.1 64.1C342.5 214.8 332.2 224 320 224s-22.5-9.2-23.8-21.3L289 138.6z", "M320 0c106 0 192 86 192 192 0 51.2-20 97.7-52.7 132.1l-8.6 9.6c-19.6 22.9-34.7 50-34.7 80l0 18.4c0 44.2-35.8 80-80 80l-32 0c-44.2 0-80-35.8-80-80l0-18.4c0-34.3-19.7-64.7-43.3-89.6-32.6-34.4-52.7-80.9-52.7-132.1 0-106 86-192 192-192zm0 48c-79.5 0-144 64.5-144 144 0 38.4 15 73.2 39.5 99 21.3 22.5 44.9 54 53.3 93l102.4 0c8.4-39 32-70.5 53.3-93 24.5-25.8 39.5-60.6 39.5-99 0-79.5-64.5-144-144-144zM69.3 298.5c11.9-5.9 26.3-1.1 32.2 10.7s1.1 26.3-10.8 32.2l-32 16c-11.9 5.9-26.3 1.1-32.2-10.7s-1.1-26.3 10.8-32.2l32-16zm469.2 10.7c5.9-11.8 20.3-16.7 32.2-10.7l32 16c11.8 5.9 16.7 20.3 10.7 32.2-5.9 11.8-20.3 16.7-32.2 10.7l-32-16c-11.8-5.9-16.7-20.3-10.7-32.2zM320 312a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm0-208c18.6 0 33 16.1 31 34.6l-7.1 64.1C342.5 214.8 332.2 224 320 224s-22.5-9.2-23.8-21.3L289 138.6c-2-18.5 12.4-34.6 31-34.6zM56 168c13.3 0 24 10.7 24 24s-10.7 24-24 24l-32 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l32 0zm560 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-32 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l32 0zM26.5 37.3c5.9-11.9 20.3-16.7 32.2-10.8l32 16c11.9 5.9 16.7 20.3 10.8 32.2S81.1 91.4 69.3 85.5l-32-16C25.4 63.5 20.6 49.1 26.5 37.3zM581.3 26.5c11.9-5.9 26.3-1.1 32.2 10.8s1.1 26.3-10.7 32.2l-32 16c-11.9 5.9-26.3 1.1-32.2-10.8s-1.1-26.3 10.7-32.2l32-16z"]],
    "bell": [448, 512, [128276, 61602], "f0f3", ["M55.6 368l336.9 0-12.9-22.1C356.3 306 344 260.6 344 214.5l0-14.5c0-66.3-53.7-120-120-120S104 133.7 104 200l0 14.5c0 46.2-12.3 91.5-35.5 131.4L55.6 368z", "M224 0c-13.3 0-24 10.7-24 24l0 9.7C118.6 45.3 56 115.4 56 200l0 14.5c0 37.7-10 74.7-29 107.3L5.1 359.2C1.8 365 0 371.5 0 378.2 0 399.1 16.9 416 37.8 416l372.4 0c20.9 0 37.8-16.9 37.8-37.8 0-6.7-1.8-13.3-5.1-19L421 321.7c-19-32.6-29-69.6-29-107.3l0-14.5c0-84.6-62.6-154.7-144-166.3l0-9.7c0-13.3-10.7-24-24-24zM392.4 368l-336.9 0 12.9-22.1C91.7 306 104 260.6 104 214.5l0-14.5c0-66.3 53.7-120 120-120s120 53.7 120 120l0 14.5c0 46.2 12.3 91.5 35.5 131.4L392.4 368zM156.1 464c9.9 28 36.6 48 67.9 48s58-20 67.9-48l-135.8 0z"]],
    "hand-back-point-left": [512, 512, [], "e19f", ["M48 176c0 8.8 7.2 16 16 16l136 0c10.3 0 19.5 6.6 22.8 16.4s-.1 20.6-8.3 26.8c-3.9 3-6.4 7.6-6.4 12.8 0 8.8 7.2 16 16 16l8 0c10.3 0 19.5 6.6 22.8 16.4s-.1 20.6-8.3 26.8c-3.9 3-6.4 7.6-6.4 12.8 0 8.8 7.2 16 16 16 9.1 0 17.4 5.1 21.5 13.3s3.2 17.9-2.3 25.1c-2 2.7-3.2 6-3.2 9.6 0 8.8 7.2 16 16 16l104 0c39.8 0 72-32.2 72-72l0-125.4c0-18.4-4.9-36.5-14.2-52.4l-1.5-2.6c-18.6-32-52.8-51.6-89.8-51.6l-10.2 0c-11.3 0-22 4.8-29.6 13.1L301.5 128 344 128c8.8 0 16 7.2 16 16s-7.2 16-16 16L64 160c-8.8 0-16 7.2-16 16z", "M0 176c0-35.3 28.7-64 64-64l188.8 0c3.6-5.2 7.6-10.2 11.9-14.9l18.4-20.3C299.9 58.5 323.5 48 348.3 48l10.2 0c54.1 0 104.1 28.7 131.3 75.4l1.5 2.6c13.6 23.2 20.7 49.7 20.7 76.6L512 328c0 66.3-53.7 120-120 120l-104 0c-35.3 0-64-28.7-64-64 0-2.8 .2-5.6 .5-8.3-19.4-11-32.5-31.8-32.5-55.7 0-5.3 .7-10.5 1.9-15.5-20.2-10.8-33.9-32-33.9-56.5 0-2.7 .2-5.4 .5-8L64 240c-35.3 0-64-28.7-64-64zm64-16c-8.8 0-16 7.2-16 16s7.2 16 16 16l136 0c10.3 0 19.5 6.6 22.8 16.4s-.1 20.6-8.3 26.8c-3.9 3-6.4 7.6-6.4 12.8 0 8.8 7.2 16 16 16l8 0c10.3 0 19.5 6.6 22.8 16.4s-.1 20.6-8.3 26.8c-3.9 3-6.4 7.6-6.4 12.8 0 8.8 7.2 16 16 16 9.1 0 17.4 5.1 21.5 13.3s3.2 17.9-2.3 25.1c-2 2.7-3.2 6-3.2 9.6 0 8.8 7.2 16 16 16l104 0c39.8 0 72-32.2 72-72l0-125.4c0-18.4-4.9-36.5-14.2-52.4l0 0-1.5-2.6c-18.6-32-52.8-51.6-89.8-51.6l-10.2 0c-11.3 0-22 4.8-29.6 13.1L301.5 128 344 128c8.8 0 16 7.2 16 16s-7.2 16-16 16L64 160z"]],
    "lari-sign": [384, 512, [], "e1c8", ["", "M144 0c13.3 0 24 10.7 24 24l0 41.5c7.9-1 15.9-1.5 24-1.5s16.1 .5 24 1.5L216 24c0-13.3 10.7-24 24-24s24 10.7 24 24l0 54c58.9 23.8 103.2 76 116.2 139.7 2.6 13-5.8 25.7-18.7 28.3s-25.7-5.8-28.3-18.7c-8.3-41-34-75.6-69.1-95.9L264 232c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-118c-7.8-1.3-15.8-2-24-2s-16.2 .7-24 2l0 118c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-100.7c-43 24.9-72 71.4-72 124.7 0 79.5 64.5 144 144 144l168 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 448c-13.3 0-24-10.7-24-24s10.7-24 24-24l41 0C25.1 364.8 0 313.3 0 256 0 175.4 49.6 106.4 120 78l0-54c0-13.3 10.7-24 24-24z"]],
    "rectangle-plus": [512, 512, [], "e6b5", ["M48 128l0 256c0 8.8 7.2 16 16 16l384 0c8.8 0 16-7.2 16-16l0-256c0-8.8-7.2-16-16-16L64 112c-8.8 0-16 7.2-16 16zM160 256c0-13.3 10.7-24 24-24l48 0 0-48c0-13.3 10.7-24 24-24s24 10.7 24 24l0 48 48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0 0 48c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-48-48 0c-13.3 0-24-10.7-24-24z", "M64 112c-8.8 0-16 7.2-16 16l0 256c0 8.8 7.2 16 16 16l384 0c8.8 0 16-7.2 16-16l0-256c0-8.8-7.2-16-16-16L64 112zM0 128C0 92.7 28.7 64 64 64l384 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64L64 448c-35.3 0-64-28.7-64-64L0 128zm256 32c13.3 0 24 10.7 24 24l0 48 48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0 0 48c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-48-48 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l48 0 0-48c0-13.3 10.7-24 24-24z"]],
    "cucumber": [512, 512, [129362], "e401", ["M71.4 327.4c-31.2 31.2-31.2 81.9 0 113.1s81.9 31.2 113.1 0l159-159c-4.7-4.4-7.6-10.6-7.6-17.5 0-13.3 10.7-24 24-24 6.9 0 13.1 2.9 17.5 7.6l63-63c31.2-31.2 31.2-81.9 0-113.1s-81.9-31.2-113.1 0l-256 256zM184 320a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zM376 128a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M71.4 440.6c-31.2-31.2-31.2-81.9 0-113.1l256-256c31.2-31.2 81.9-31.2 113.1 0s31.2 81.9 0 113.1l-63 63c-4.4-4.7-10.6-7.6-17.5-7.6-13.3 0-24 10.7-24 24 0 6.9 2.9 13.1 7.6 17.5l-159 159c-31.2 31.2-81.9 31.2-113.1 0zM37.5 474.5c47.8 47.8 124 49.9 174.3 6.3 12.6 10.3 31.1 9.6 42.9-2.2 11.6-11.6 12.4-30 2.4-42.6L436 257c12.6 10.1 31 9.3 42.6-2.4 11.7-11.7 12.5-30.3 2.2-42.9 43.6-50.3 41.5-126.5-6.3-174.3-50-50-131-50-181 0L172 159c-12.6-10.1-31-9.3-42.6 2.4s-12.4 30-2.4 42.6L37.5 293.5c-50 50-50 131 0 181zM352 152a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM184 320a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"]],
    "seal": [512, 512, [], "e241", ["", "M125.1 28.6l-23.2 56c-3.2 7.8-9.5 14.1-17.3 17.3l-56 23.2c-24.5 10.1-36.1 38.2-26 62.7l23.2 56c3.2 7.8 3.2 16.7 0 24.5l-23.2 56c-10.1 24.5 1.5 52.6 26 62.7l56 23.2c7.8 3.2 14.1 9.5 17.3 17.3l23.2 56c10.1 24.5 38.2 36.1 62.7 26l56-23.2c7.8-3.2 16.7-3.2 24.5 0l56 23.2c24.5 10.1 52.6-1.5 62.7-26l23.2-56c3.2-7.8 9.5-14.1 17.3-17.3l56-23.2c24.5-10.1 36.1-38.2 26-62.7l-23.2-56c-3.2-7.8-3.2-16.6 0-24.5l23.2-56c10.1-24.5-1.5-52.6-26-62.7l-56-23.2c-7.8-3.2-14.1-9.5-17.3-17.3L387 28.6c-10.1-24.5-38.2-36.1-62.7-26l-56 23.2c-7.8 3.2-16.7 3.2-24.5 0l-56-23.2c-24.5-10.1-52.6 1.5-62.7 26zM47 342.6l23.2-56c8.1-19.6 8.1-41.6 0-61.2l-23.2-56 56-23.2c19.6-8.1 35.2-23.7 43.3-43.3l23.2-56 56 23.2c19.6 8.1 41.6 8.1 61.2 0l56-23.2 23.2 56c8.1 19.6 23.7 35.2 43.3 43.3l56 23.2-23.2 56c-8.1 19.6-8.1 41.6 0 61.2l23.2 56-56 23.2c-19.6 8.1-35.2 23.7-43.3 43.3l-23.2 56-56-23.2c-19.6-8.1-41.6-8.1-61.2 0l-56 23.2-23.2-56c-8.1-19.6-23.7-35.2-43.3-43.3L47 342.6z"]],
    "circle-caret-down": [512, 512, ["caret-circle-down"], "f32d", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm82-49.6c3.8-8.7 12.5-14.4 22-14.4l208 0c9.5 0 18.2 5.7 22 14.4s2.1 18.9-4.4 25.9l-104 112c-4.5 4.9-10.9 7.7-17.6 7.7s-13-2.8-17.6-7.7l-104-112c-6.5-7-8.2-17.2-4.4-25.9z", "M256 464a208 208 0 1 1 0-416 208 208 0 1 1 0 416zM256 0a256 256 0 1 0 0 512 256 256 0 1 0 0-512zm0 352c6.7 0 13-2.8 17.6-7.7l104-112c6.5-7 8.2-17.2 4.4-25.9S369.5 192 360 192l-208 0c-9.5 0-18.2 5.7-22 14.4s-2.1 18.9 4.4 25.9l104 112c4.5 4.9 10.9 7.7 17.6 7.7z"]],
    "mill-sign": [384, 512, [], "e1ed", ["", "M310.2 9c5-12.3-.9-26.3-13.2-31.3S270.8-21.3 265.8-9L224.2 93.2C211.8 100 200.9 109.2 192 120.1 172.2 95.7 141.9 80 108 80 85.5 80 64.7 86.9 47.4 98.6 44.9 88 35.4 80 24 80 10.7 80 0 90.8 0 104l0 80 .1 0c0 1.3-.1 2.7-.1 4L0 408c0 13.3 10.7 24 24 24s24-10.7 24-24l0-220c0-33.1 26.9-60 60-60s60 26.9 60 60L168 231.6 57.8 503c-5 12.3 .9 26.3 13.2 31.3s26.3-.9 31.3-13.2L168 359.2 168 408c0 13.3 10.7 24 24 24s24-10.7 24-24l0-167 45.2-111.1c4.7-1.2 9.7-1.9 14.8-1.9 33.1 0 60 26.9 60 60l0 220c0 13.3 10.7 24 24 24s24-10.7 24-24l0-220c0-57.9-45.5-105.1-102.6-107.9L310.2 9z"]],
    "mug-tea-saucer": [576, 512, [], "e1f5", ["M112 80l0 208c0 26.5 21.5 48 48 48l192 0c26.5 0 48-21.5 48-48l0-208-152 0 0 20.4c0 7.5 2.6 14.7 7.4 20.5l25.2 30.2c4.8 5.8 7.4 13 7.4 20.5l0 52.4c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-52.4c0-7.5 2.6-14.7 7.4-20.5l25.2-30.2c4.8-5.8 7.4-13 7.4-20.5l0-20.4-88 0z", "M112 288c0 26.5 21.5 48 48 48l192 0c26.5 0 48-21.5 48-48l0-208-152 0 0 20.4c0 7.5 2.6 14.7 7.4 20.5l25.2 30.2c4.8 5.8 7.4 13 7.4 20.5l0 52.4c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-52.4c0-7.5 2.6-14.7 7.4-20.5l25.2-30.2c4.8-5.8 7.4-13 7.4-20.5l0-20.4-88 0 0 208zM448 80l0 144 8 0c39.8 0 72-32.2 72-72s-32.2-72-72-72l-8 0zm0 192l0 16c0 53-43 96-96 96l-192 0c-53 0-96-43-96-96L64 64c0-17.7 14.3-32 32-32l360 0c66.3 0 120 53.7 120 120S522.3 272 456 272l-8 0zM32 488c0-13.3 10.7-24 24-24l400 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L56 512c-13.3 0-24-10.7-24-24z"]],
    "cart-circle-check": [640, 512, [], "e3f1", ["M133.5 80l381.5 0-24.5 127.6-.1 .5c-37.1 1.1-71.5 12.7-100.5 31.9l-227.3 0-29.1-160z", "M0 8C0-5.3 10.7-16 24-16l45.3 0c27.1 0 50.3 19.4 55.1 46l.4 2 399.9 0c25.1 0 44 22.9 39.3 47.6L538.3 212.7c-13.6-3.1-27.8-4.7-42.3-4.7-1.9 0-3.8 0-5.7 .1l.1-.5 24.5-127.6-381.5 0 29.1 160 227.3 0c-19.4 12.9-36.2 29.2-49.8 48l-168.7 0 5.1 28.3c2.1 11.4 12 19.7 23.6 19.7l114.9 0c-5.4 15.2-8.9 31.3-10.3 48l-104.6 0c-34.8 0-64.6-24.9-70.8-59.1L77.2 38.6c-.7-3.8-4-6.6-7.9-6.6L24 32C10.7 32 0 21.3 0 8zM208 416a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm144-16a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm201.4-60.9c-7.1-5.2-17.2-3.6-22.4 3.5l-53 72.9-26.8-26.8c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l40 40c3.3 3.3 7.9 5 12.6 4.6s8.9-2.8 11.7-6.5l64-88c5.2-7.1 3.6-17.2-3.5-22.3z"]],
    "album": [448, 512, [128189], "f89f", ["M48 96l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16zM368 256a144 144 0 1 1 -288 0 144 144 0 1 1 288 0z", "M384 80c8.8 0 16 7.2 16 16l0 320c0 8.8-7.2 16-16 16L64 432c-8.8 0-16-7.2-16-16L48 96c0-8.8 7.2-16 16-16l320 0zM64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM256 256a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm-128 0a96 96 0 1 1 192 0 96 96 0 1 1 -192 0zm240 0a144 144 0 1 0 -288 0 144 144 0 1 0 288 0z"]],
    "left-to-line": [512, 512, ["arrow-alt-to-left"], "f34b", ["M185.9 256l86.1 86.1 0-30.1c0-13.3 10.7-24 24-24l168 0 0-64c-52 0-108 0-168 0-13.3 0-24-10.7-24-24l0-30.1-86.1 86.1z", "M24 64c13.3 0 24 10.7 24 24l0 336c0 13.3-10.7 24-24 24S0 437.3 0 424L0 88C0 74.7 10.7 64 24 64zM135 273c-4.5-4.5-7-10.6-7-17s2.5-12.5 7-17L279 95c6.9-6.9 17.2-8.9 26.2-5.2S320 102.3 320 112l0 64 64 0 0 0 80 0c26.5 0 48 21.5 48 48l0 64c0 26.5-21.5 48-48 48l-144 0 0 64c0 9.7-5.8 18.5-14.8 22.2s-19.3 1.7-26.2-5.2L135 273zm249 15l80 0 0-64-80 0 0 0-88 0c-13.3 0-24-10.7-24-24l0-30.1-86.1 86.1 86.1 86.1 0-30.1c0-13.3 10.7-24 24-24l88 0z"]],
    "person-snowboarding": [576, 512, [127938, "snowboarding"], "f7ce", ["M245.1 241.9l22.5 18.7 73.1-62.7-25.1-17.7-70.5 61.7z", "M424.5 16a56 56 0 1 1 0 112 56 56 0 1 1 0-112zM172.9 50.2c7.6-10.8 22.6-13.4 33.4-5.8l272 192c10.8 7.6 13.4 22.6 5.8 33.4s-22.6 13.4-33.4 5.8l-69.5-49.1-76.2 65.3 13.6 11.4c16.4 13.7 25.9 33.9 25.9 55.3l0 86.3 85.5 16.7c6.2 1.2 12.6 .9 18.7-.8l41.2-11.8c12.7-3.6 26 3.7 29.7 16.5s-3.7 26-16.5 29.7l-41.2 11.8c-13.4 3.8-27.4 4.4-41.1 1.8L87.1 443.3c-17.2-3.4-33-11.8-45.3-24.1L15.5 393c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l26.2 26.2c5.6 5.6 12.8 9.4 20.6 11l72.2 14.1 0-125.3c0-25.4 11-49.5 30.1-66.2l76.6-67.1-96.5-68.1C167.8 76 165.2 61 172.9 50.2zm43.6 369.6l80 15.7 0-76.9c0-7.1-3.2-13.9-8.6-18.4l-71.1-59.3c-.2 1.4-.2 2.8-.2 4.3l0 134.7zM340.7 198l-25.1-17.7-70.5 61.7 22.5 18.7 73.1-62.7z"]],
    "tty": [512, 512, ["teletype"], "f1e4", ["M57.7 240.8c-18-36-11.3-80.4 20.8-102.9 110.4-77.3 244.7-77.3 355.1 0 32.1 22.5 38.8 66.8 20.8 102.9-.3 .6-1 .9-1.6 .6l-78.9-29.6c-.6-.2-.9-.8-.8-1.4l3-27c2.5-22.6-11.2-43.9-32.9-51-56-18.1-116.2-19.2-172.7-3.2-22.6 6.4-37.2 28.2-34.6 51.5l3.3 29.7c.1 .6-.3 1.2-.8 1.4L59.3 241.5c-.6 .2-1.3 0-1.6-.6z", "M50.9 98.6c-56.4 39.5-61.9 112.1-36.2 163.7 11.3 22.6 37.8 33 61.4 24.1L155 256.9c21.1-7.9 34.2-29.2 31.7-51.6l-3.3-29.7c47.3-13.4 97.9-12.5 144.8 2.7l-3 27c-2.5 22.4 10.6 43.7 31.7 51.6l78.9 29.6c23.6 8.9 50.1-1.5 61.4-24.1 25.8-51.6 20.2-124.1-36.2-163.6-126.9-88.9-283.3-88.9-410.1 0zm6.8 142.2c-18-36-11.3-80.4 20.8-102.9 110.4-77.3 244.7-77.3 355.1 0 32.1 22.5 38.8 66.8 20.8 102.9-.3 .6-1 .9-1.6 .6l-78.9-29.6c-.6-.2-.9-.8-.8-1.4l3-27c2.5-22.6-11.2-43.9-32.9-51-56-18.1-116.2-19.2-172.7-3.2-22.6 6.4-37.2 28.2-34.6 51.5l3.3 29.7c.1 .6-.3 1.2-.8 1.4L59.3 241.5c-.6 .2-1.3 0-1.6-.6zM32 352a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm96 0a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zM64 416a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm352 32a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zM256 320a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm64 32a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm128-32a32 32 0 1 0 0 64 32 32 0 1 0 0-64zM128 448c0 13.3 10.7 24 24 24l208 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-208 0c-13.3 0-24 10.7-24 24z"]],
    "slider-circle": [576, 512, [], "e750", ["M272 256a80 80 0 1 0 160 0 80 80 0 1 0 -160 0z", "M432 256a80 80 0 1 0 -160 0 80 80 0 1 0 160 0zm45.8 24c-11.2 59.2-63.3 104-125.8 104-70.7 0-128-57.3-128-128s57.3-128 128-128c62.5 0 114.5 44.8 125.8 104l74.2 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-74.2 0zM177.6 232c-1.1 7.8-1.6 15.9-1.6 24s.6 16.2 1.6 24L24 280c-13.3 0-24-10.7-24-24s10.7-24 24-24l153.6 0z"]],
    "users-rectangle": [576, 512, [], "e594", ["M200 416c13.3 0 24-10.7 24-24l0-8c0-26.5 21.5-48 48-48l32 0c26.5 0 48 21.5 48 48l0 8c0 13.3 10.7 24 24 24l-176 0zM320 160a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M64 48c-8.8 0-16 7.2-16 16l0 384c0 8.8 7.2 16 16 16l448 0c8.8 0 16-7.2 16-16l0-384c0-8.8-7.2-16-16-16L64 48zM0 64C0 28.7 28.7 0 64 0L512 0c35.3 0 64 28.7 64 64l0 384c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zM288 192a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm0-112a80 80 0 1 1 0 160 80 80 0 1 1 0-160zM160 160c0 37.1 15.8 70.6 41.1 94-5.5 1.3-11.2 2-17.1 2-39.8 0-72-32.2-72-72 0-34.5 24.3-63.3 56.7-70.4-5.6 14.4-8.7 30-8.7 46.4zm232 96c-5.9 0-11.6-.7-17.1-2 25.3-23.4 41.1-56.8 41.1-94 0-16.4-3.1-32-8.7-46.4 32.4 7 56.7 35.9 56.7 70.4 0 39.8-32.2 72-72 72zM170.5 288.2c-21.2 22.3-35.8 50.9-40.7 82.7-1.2 4.2-1.8 8.6-1.8 13.1l0 8c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-8c0-51.2 40.1-93 90.5-95.8zm275.7 82.7c-4.9-31.8-19.5-60.4-40.7-82.7 50.5 2.8 90.5 44.7 90.5 95.8l0 8c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-8c0-4.6-.6-9-1.8-13.1zM272 288l32 0c53 0 96 43 96 96l0 8c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-8c0-26.5-21.5-48-48-48l-32 0c-26.5 0-48 21.5-48 48l0 8c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-8c0-53 43-96 96-96z"]],
    "mobile": [384, 512, [128241, "mobile-android", "mobile-phone"], "f3ce", ["M64 64l0 384c0 8.8 7.2 16 16 16l224 0c8.8 0 16-7.2 16-16l0-384c0-8.8-7.2-16-16-16L80 48c-8.8 0-16 7.2-16 16zm64 328c0-13.3 10.7-24 24-24l80 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24z", "M80 48c-8.8 0-16 7.2-16 16l0 384c0 8.8 7.2 16 16 16l224 0c8.8 0 16-7.2 16-16l0-384c0-8.8-7.2-16-16-16L80 48zM16 64C16 28.7 44.7 0 80 0L304 0c35.3 0 64 28.7 64 64l0 384c0 35.3-28.7 64-64 64L80 512c-35.3 0-64-28.7-64-64L16 64zM152 368l80 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"]],
    "arrows-turn-to-dots": [448, 512, [], "e4c1", ["", "M271-9c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-47 47 94.1 0c53 0 96 43 96 96l0 32c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-32c0-26.5-21.5-48-48-48l-94.1 0 47 47c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-88-88c-9.4-9.4-9.4-24.6 0-33.9L271-9zM177 263l88 88c9.4 9.4 9.4 24.6 0 33.9l-88 88c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l47-47-94.1 0c-26.5 0-48 21.5-48 48l0 32c0 13.3-10.7 24-24 24S0 485.3 0 472l0-32c0-53 43-96 96-96l94.1 0-47-47c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0zM320 368a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zM64 160a64 64 0 1 1 0-128 64 64 0 1 1 0 128z"]],
    "exclamation": [64, 512, [10069, 10071, 61738], "21", ["", "M32.3 448c17.7 0 32 14.3 32 32s-14.3 32-32 32c-17.7 0-32-14.3-32-32s14.3-32 32-32zM36.2 .2c18.8 2 33.2 18.2 32.5 37.5L56.3 360.9c-.5 12.9-11.1 23.1-24 23.1s-23.5-10.2-24-23.1L-4 37.7C-4.8 17.1 11.7 0 32.3 0l3.8 .2z"]],
    "location-xmark": [384, 512, ["map-marker-times", "map-marker-xmark"], "f60e", ["M48 188.6C48 111.7 111.7 48 192 48s144 63.7 144 140.6c0 45.6-23.8 101.5-58.9 157.1-28.3 44.8-61 84.8-85.1 112.1-24.1-27.3-56.7-67.2-85.1-112.1-35.1-55.5-58.9-111.5-58.9-157.1zm76.1-64.5c-9.4 9.4-9.4 24.6 0 33.9l33.9 33.9-33.9 33.9c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l33.9-33.9 33.9 33.9c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-33.9-33.9 33.9-33.9c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-33.9 33.9-33.9-33.9c-9.4-9.4-24.6-9.4-33.9 0z", "M48 188.6C48 111.7 111.7 48 192 48s144 63.7 144 140.6c0 45.6-23.8 101.5-58.9 157.1-28.3 44.8-61 84.8-85.1 112.1-24.1-27.3-56.7-67.2-85.1-112.1-35.1-55.5-58.9-111.5-58.9-157.1zM192 0C86 0 0 84.4 0 188.6 0 307.9 120.2 450.9 170.4 505.4 182.2 518.2 201.8 518.2 213.6 505.4 263.8 450.9 384 307.9 384 188.6 384 84.4 298 0 192 0zm67.9 124.1c-9.4-9.4-24.6-9.4-33.9 0l-33.9 33.9-33.9-33.9c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l33.9 33.9-33.9 33.9c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l33.9-33.9 33.9 33.9c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-33.9-33.9 33.9-33.9c9.4-9.4 9.4-24.6 0-33.9z"]],
    "church": [512, 512, [9962], "f51d", ["M48 335l0 113c0 8.8 7.2 16 16 16l32 0 0-166.2-40.1 23.4C51 324 48 329.3 48 335zm96-109.6l0 238.6 48 0 0-80c0-35.3 28.7-64 64-64s64 28.7 64 64l0 80 48 0 0-238.6c0-2.7-1.4-5.2-3.7-6.7L256 148.6 147.7 218.7c-2.3 1.5-3.7 4-3.7 6.7zm272 72.4l0 166.2 32 0c8.8 0 16-7.2 16-16l0-113c0-5.7-3-11-7.9-13.8L416 297.8z", "M256-32c13.3 0 24 10.7 24 24l0 24 32 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-32 0 0 42.9 110.4 71.4c15.9 10.3 25.6 28 25.6 47l0 16.8 64.2 37.5C499.9 291.2 512 312.2 512 335l0 113c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 335c0-22.8 12.1-43.8 31.8-55.3l64.2-37.5 0-16.8c0-19 9.6-36.7 25.6-47l110.4-71.4 0-42.9-32 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l32 0 0-24c0-13.3 10.7-24 24-24zM147.7 218.7c-2.3 1.5-3.7 4-3.7 6.7l0 238.6 48 0 0-80c0-35.3 28.7-64 64-64s64 28.7 64 64l0 80 48 0 0-238.6c0-2.7-1.4-5.2-3.7-6.7L256 148.6 147.7 218.7zM416 464l32 0c8.8 0 16-7.2 16-16l0-113c0-5.7-3-11-7.9-13.8L416 297.8 416 464zM96 297.8L55.9 321.2C51 324 48 329.3 48 335l0 113c0 8.8 7.2 16 16 16l32 0 0-166.2z"]],
    "toggle-off": [576, 512, [], "f204", ["M240 256a48 48 0 1 1 -96 0 48 48 0 1 1 96 0z", "M384 112c79.5 0 144 64.5 144 144S463.5 400 384 400l-192 0c-79.5 0-144-64.5-144-144s64.5-144 144-144l192 0zM576 256c0-106-86-192-192-192L192 64C86 64 0 150 0 256S86 448 192 448l192 0c106 0 192-86 192-192zm-336 0a48 48 0 1 1 -96 0 48 48 0 1 1 96 0zM96 256a96 96 0 1 0 192 0 96 96 0 1 0 -192 0z"]],
    "face-nauseated": [512, 512, [], "e381", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm46.1-87.1c-4.9-9.9-.9-21.9 8.9-26.8l64-32c9.9-4.9 21.9-.9 26.8 8.9s.9 21.9-8.9 26.8l-64 32c-9.9 4.9-21.9 .9-26.8-8.9zM208 224a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm-62 65.5c4.5-1 9.2-1.5 14-1.5 26.9 0 49.9 16.5 59.3 40l73.3 0c9.5-23.5 32.5-40 59.3-40 4.8 0 9.5 .5 14 1.5-18.3 14.7-30 37.2-30 62.5s11.7 47.8 30 62.5c-4.5 1-9.2 1.5-14 1.5-26.9 0-49.9-16.5-59.3-40l-73.3 0c-9.5 23.5-32.5 40-59.3 40-4.8 0-9.5-.5-14-1.5 18.3-14.7 30-37.2 30-62.5s-11.7-47.8-30-62.5zM368 224a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM318.1 119.1c4.9-9.9 17-13.9 26.8-8.9l64 32c9.9 4.9 13.9 17 8.9 26.8s-17 13.9-26.8 8.9l-64-32c-9.9-4.9-13.9-17-8.9-26.8z", "M464 256a208 208 0 1 0 -416 0 208 208 0 1 0 416 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm336-64a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM208 224a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm-23.1-78.1l-64 32c-9.9 4.9-21.9 .9-26.8-8.9s-.9-21.9 8.9-26.8l64-32c9.9-4.9 21.9-.9 26.8 8.9s.9 21.9-8.9 26.8zm133.2-26.8c4.9-9.9 17-13.9 26.8-8.9l64 32c9.9 4.9 13.9 17 8.9 26.8s-17 13.9-26.8 8.9l-64-32c-9.9-4.9-13.9-17-8.9-26.8zM160 288c26.9 0 49.9 16.5 59.3 40l73.3 0c9.5-23.5 32.5-40 59.3-40 4.8 0 9.5 .5 14 1.5-18.3 14.7-30 37.2-30 62.5s11.7 47.8 30 62.5c-4.5 1-9.2 1.5-14 1.5-26.9 0-49.9-16.5-59.3-40l-73.3 0c-9.5 23.5-32.5 40-59.3 40-4.8 0-9.5-.5-14-1.5 18.3-14.7 30-37.2 30-62.5s-11.7-47.8-30-62.5c4.5-1 9.2-1.5 14-1.5z"]],
    "deer": [576, 512, [129420], "f78e", ["M88 264l0 4.1c0 6.4 2.5 12.5 7 17l3.9 3.9c13.5 13.5 21.1 31.8 21.1 50.9l0 4.3c0 7.7-1.2 15.4-3.7 22.8l-8.2 24.7c-1.7 5.1-1.6 10.7 .2 15.8l20.5 56.5 28.9 0-20.3-55.8c-3.8-10.4 0-22 9.2-28.2l22.2-14.8c7.9-5.2 11.9-14.6 10.4-23.9l-2.9-17.4c-1.6-9.4 2.6-18.9 10.6-24.1s18.4-5.1 26.3 .2l13.7 9.2c18.4 12.3 40 18.8 62.1 18.8l30.8 0c13.3 0 24 10.7 24 24l0 112 32 0 0-152.2c0-7.7 1.2-15.4 3.7-22.8l21.5-64.6c3.3-9.8 12.4-16.4 22.8-16.4l59.6 0c11.3 0 20.4-9.1 20.4-20.4 0-5.7-2.4-11.2-6.7-15.1L440 120.5c-6-5.5-13.8-8.5-21.9-8.5-14.4 0-27.1 9.4-31.2 23.2l-19 63.6c-3 10.2-12.4 17.1-23 17.1L136 216c-26.5 0-48 21.5-48 48zM448 160a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M288 16c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 24c0 30.9 25.1 56 56 56l40 0-50.4 12.6c-8 2-13.6 9.2-13.6 17.4 0 9.9 8 18 18 18l28.2 0-7.2 24-191 0c-36.5 0-68.3 20.4-84.5 50.4-9.2 13.7-15.1 30-16.2 47.6L32 319c-.6 8.8 6.2 16.4 15 17 8.5 .5 15.9-5.7 16.9-14.1l1.1 1.1c4.5 4.5 7 10.6 7 17l0 4.3c0 2.6-.4 5.1-1.2 7.6l-8.2 24.7c-5.1 15.4-4.9 32.1 .6 47.4l22.5 61.8c5.7 15.8 20.8 26.3 37.6 26.3l46 0c27.8 0 47.1-27.6 37.6-53.7l-17.8-48.8 6.5-4.3c15.2-10.1 25.6-25.4 29.9-42.4 20 8.7 41.7 13.3 63.8 13.3l6.8 0 0 96c0 22.1 17.9 40 40 40l48 0c22.1 0 40-17.9 40-40l0-160.2c0-2.6 .4-5.1 1.2-7.6l16.1-48.2 42.3 0c37.8 0 68.4-30.6 68.4-68.4 0-19.3-8.1-37.6-22.4-50.6L476.2 88.4C492.8 78.7 504 60.7 504 40l0-24c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 24c0 13.3-10.7 24-24 24l-69.4 0c3.5-7.3 5.4-15.4 5.4-24l0-24c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 24c0 13.3-10.7 24-24 24l-16 0c-13.3 0-24-10.7-24-24l0-24zm130.1 96c8.1 0 15.9 3 21.9 8.5l57.3 52.1c4.2 3.9 6.7 9.3 6.7 15.1 0 11.3-9.1 20.4-20.4 20.4L424 208c-10.3 0-19.5 6.6-22.8 16.4L379.7 289c-2.4 7.3-3.7 15-3.7 22.8l0 152.2-32 0 0-112c0-13.3-10.7-24-24-24l-30.8 0c-22.1 0-43.7-6.5-62.1-18.8L213.3 300c-8-5.3-18.3-5.4-26.3-.2s-12.2 14.7-10.6 24.1l2.9 17.4c1.6 9.3-2.5 18.7-10.4 23.9L146.7 380c-9.2 6.1-13 17.8-9.2 28.2l20.3 55.8-28.9 0-20.5-56.5c-1.9-5.1-1.9-10.7-.2-15.8l8.2-24.7c2.4-7.3 3.7-15 3.7-22.8l0-4.3c0-19.1-7.6-37.4-21.1-50.9L95 285.1c-4.5-4.5-7-10.6-7-17l0-4.1c0-26.5 21.5-48 48-48l208.9 0c10.6 0 20-7 23-17.1l19-63.6c4.1-13.8 16.8-23.2 31.2-23.2zM448 160a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"]],
    "box-open-full": [576, 512, ["box-full"], "f49c", ["M96 305.4l0 41c0 14.5 7.9 27.9 20.6 35l147.4 81.9 0-100.7c-12 15-33.6 19.7-51 9.7L96 305.4zm216-35.2l0 193.1 147.4-81.9c12.7-7.1 20.6-20.4 20.6-35l0-169.6-168 93.3z", "M304 128c0-44.2-35.8-80-80-80-32.4 0-60.2 19.2-72.8 46.9L109.4 71C130.4 28.9 173.8 0 224 0 256.7 0 286.6 12.3 309.2 32.5 318.1 13.3 337.5 0 360 0l64 0c30.9 0 56 25.1 56 56l0 7.4-3.7 2.1-44.3 25.3 0-34.8c0-4.4-3.6-8-8-8l-64 0c-4.4 0-8 3.6-8 8l0 80.5-60.6 34.6c8-12.4 12.6-27.3 12.6-43.1zM213 372.2l-116.9-66.8 0 41c0 14.5 7.9 27.9 20.6 35l147.4 81.9 0-100.7c-12 15-33.6 19.7-51 9.7zm16.2-46l27.7-60-178.6-99.2-30.1 55.8 181 103.4zM531.4 220.3l-3.4-5.7 0 131.7c0 32-17.3 61.4-45.3 76.9l-152 84.4c-26.6 14.8-58.9 14.8-85.5 0l-152-84.4C65.4 407.8 48 378.3 48 346.3l0-68.4-30.4-17.4C-1.2 249.8-8 226 2.3 206.9l48.6-90.3c3.1-5.8 8.4-10 14.7-11.7s13-.9 18.7 2.5L288 228.1 491.8 107.3c11.4-6.7 26-3 32.8 8.3l48 80c6.8 11.4 3.1 26.1-8.2 32.9s-26.1 3.1-32.9-8.2zM480 176.8l-168 93.3 0 193.1 147.4-81.9c12.7-7.1 20.6-20.4 20.6-35l0-169.6z"]],
    "cherries": [576, 512, [], "e0ec", ["M48 304c0 66.8 60.5 128 144 128s144-61.2 144-128c0-35.3-28.7-64-64-64-17.9 0-34 7.3-45.7 19.2-9 9.2-21.4 14.4-34.3 14.4s-25.3-5.2-34.3-14.4c-11.7-11.9-27.8-19.2-45.7-19.2-35.3 0-64 28.7-64 64zM389.2 431.9c80.8-2.5 138.8-62.5 138.8-127.9 0-35.3-28.7-64-64-64-15.1 0-28.9 5.2-40 14 5.2 15.7 8 32.5 8 50 0 48.3-16 92.1-42.8 127.9z", "M285.7-23.9c8.7-.8 17.2 3.2 22.2 10.4L448.1 193.1c5.2-.7 10.5-1.1 15.9-1.1 61.9 0 112 50.1 112 112 0 97.2-86 176-192 176-13.3 0-26.3-1.2-38.8-3.6 16.7-12.9 31.5-27.8 44-44.5 80.8-2.5 138.8-62.5 138.8-127.9 0-35.3-28.7-64-64-64-15.1 0-29 5.2-40 14-4.1-12.6-9.8-24.5-16.8-35.5L292.8 49.8 228 201c13.5-5.8 28.4-9 44-9 61.9 0 112 50.1 112 112 0 97.2-86 176-192 176S0 401.2 0 304c0-61.9 50.1-112 112-112 22.1 0 42.7 6.4 60.1 17.5L265.9-9.5c3.5-8.1 11-13.6 19.8-14.4zM192 273.6c-12.9 0-25.3-5.2-34.3-14.4-11.7-11.9-27.8-19.2-45.7-19.2-35.3 0-64 28.7-64 64 0 66.8 60.5 128 144 128s144-61.2 144-128c0-35.3-28.7-64-64-64-17.9 0-34 7.3-45.7 19.2-9 9.2-21.4 14.4-34.3 14.4z"]],
    "vacuum-robot": [512, 512, [], "e04e", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm79 31c9.4-9.4 24.6-9.4 33.9 0l64 64c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-64-64c-9.4-9.4-9.4-24.6 0-33.9zm16-144c62.4-62.4 163.5-62.4 225.9 0s62.4 163.5 0 225.9c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9c43.6-43.6 43.6-114.4 0-158.1S220.6 133.3 177 177c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9zm48 80c9.4-9.4 24.6-9.4 33.9 0l64 64c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-64-64c-9.4-9.4-9.4-24.6 0-33.9z", "M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm79-335c43.6 43.6 43.6 114.4 0 158.1-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0c62.4-62.4 62.4-163.6 0-225.9S205.4 80.6 143 143c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0c43.6-43.6 114.4-43.6 158.1 0zM225 223c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l64 64c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-64-64zm-64 64c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l64 64c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-64-64z"]],
    "circle-eurozone": [512, 512, [], "e745", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm64-88c0-13.3 10.7-24 24-24l72 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0 0 43.2 40 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-40 0 0 36.8 49.6 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L136 368c-13.3 0-24-10.7-24-24l0-176zm152 0c0-13.3 10.7-24 24-24l88 0c8.3 0 16 4.3 20.4 11.4s4.8 15.9 1 23.4L326.8 320 376 320c13.3 0 24 10.7 24 24s-10.7 24-24 24l-88 0c-8.3 0-16-4.3-20.4-11.4s-4.8-15.9-1-23.4L337.2 192 288 192c-13.3 0-24-10.7-24-24z", "M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM136 144c-13.3 0-24 10.7-24 24l0 176c0 13.3 10.7 24 24 24l73.6 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-49.6 0 0-36.8 40 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-40 0 0-43.2 48 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-72 0zm152 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l49.2 0-70.6 141.3c-3.7 7.4-3.3 16.3 1 23.4S279.7 368 288 368l88 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-49.2 0 70.6-141.3c3.7-7.4 3.3-16.3-1-23.4S384.3 144 376 144l-88 0z"]],
    "shoe-prints": [576, 512, [], "f54b", ["M48 400c0-17.7 14.3-32 32-32l16 0 0 64-16 0c-17.7 0-32-14.3-32-32zm64-288c0-17.7 14.3-32 32-32l16 0 0 64-16 0c-17.7 0-32-14.3-32-32zm32 255.6c48.7-2.4 83.2-15.6 111.8-27l2.1-.9c29.7-11.9 49.2-19.7 78-19.7 34.8 0 70.4 7.1 95.5 20.4 24 12.7 32.5 27 32.5 43.6 0 11.7-10 31.3-49.5 51.1-36.8 18.4-85.3 28.9-126.5 28.9-25.7 0-60.9-6.7-92.3-14.6-15.1-3.8-28.4-7.6-37.9-10.4-4.7-1.4-8.5-2.6-11-3.4-1.2-.4-2.2-.7-2.8-.9l0-67.1zM208 77.3c.6-.2 1.6-.5 2.8-.9 2.5-.8 6.3-2 11-3.4 9.5-2.8 22.8-6.6 37.9-10.4 31.4-7.8 66.6-14.6 92.3-14.6 41.2 0 89.8 10.6 126.5 28.9 39.4 19.7 49.5 39.4 49.5 51.1 0 16.5-8.4 30.9-32.5 43.6-25.1 13.3-60.8 20.4-95.5 20.4-28.8 0-48.4-7.8-78-19.7l-2.1-.9c-28.6-11.4-63.1-24.6-111.8-27l0-67.1z", "M208 77.3l0 67.1c48.7 2.4 83.2 15.6 111.8 27l2.1 .9c29.7 11.9 49.2 19.7 78 19.7 34.8 0 70.4-7.1 95.5-20.4 24-12.7 32.5-27 32.5-43.6 0-11.7-10-31.3-49.5-51.1-36.8-18.4-85.3-28.9-126.5-28.9-25.7 0-60.9 6.7-92.3 14.6-15.1 3.8-28.4 7.6-37.9 10.4-4.7 1.4-8.5 2.6-11 3.4-1.2 .4-2.2 .7-2.8 .9zM160 144l0-64-16 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l16 0zM192 32S288.3 0 352 0c96 0 224 48 224 128S480 240 400 240c-38.2 0-65.4-10.9-93.9-22.4-31.2-12.5-63.9-25.6-114.1-25.6l-48 0c-44.2 0-80-35.8-80-80s35.8-80 80-80l48 0zM96 432l0-64-16 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l16 0zm50.8 3.6c2.5 .8 6.3 2 11 3.4 9.5 2.8 22.8 6.6 37.9 10.4 31.4 7.8 66.6 14.6 92.3 14.6 41.2 0 89.8-10.6 126.5-28.9 39.4-19.7 49.5-39.4 49.5-51.1 0-16.5-8.4-30.9-32.5-43.6-25.1-13.3-60.8-20.4-95.5-20.4-28.8 0-48.4 7.8-78 19.7l-2.1 .9c-28.6 11.4-63.1 24.6-111.8 27l0 67.1c.6 .2 1.6 .5 2.8 .9zM128 480l-48 0c-44.2 0-80-35.8-80-80s35.8-80 80-80l48 0c50.2 0 82.9-13.1 114.1-25.6 28.5-11.4 55.7-22.4 93.9-22.4 80 0 176 32 176 112S384 512 288 512c-63.7 0-160-32-160-32z"]],
    "squirrel": [512, 512, [], "f71a", ["M48.1 147.7c0-55.1 44.7-99.7 99.7-99.7 40.2 0 74.8 23.7 90.6 58 5.5 12 19.8 17.3 31.8 11.8S287.6 98 282 86c8.7 18.8 13.5 39.7 13.5 61.8l0 17.5 .8-1.2c-8.7 38.1-24.7 74.3-47.4 106.7l-35 49.9c-14.3 20.4-22 44.8-22 69.8 0 26.4 8.4 50.9 22.8 70.9-36.1-9.5-62.8-42.4-62.8-81.5 0-21.4 7.9-40.9 21.1-55.8 6.1-6.9 11-16.3 12-27.3l.7-7.7c2-22.3-15.6-41.5-38-41.5-55.1 0-99.7-44.7-99.7-99.7zm192 242.6c0-15.1 4.6-29.9 13.3-42.2l35-49.9c32.2-46 52.9-98.9 60.4-154.2l58.9 0c28.8 0 52.9 21.8 55.7 50.4l.1 1.1-1 2c-8.1 16.3-24.8 26.5-42.9 26.5l-11.5 0c-13.3 0-24 10.7-24 24l0 57.2c-5.2-.8-10.6-1.2-16-1.2-10.8 0-21.3 1.7-31.2 4.8-12.6 4-19.7 17.4-15.7 30.1s17.4 19.7 30.1 15.7c5.3-1.7 10.9-2.6 16.8-2.6 30.9 0 56 25.1 56 56s-25.1 56-56 56l-54.3 0c-40.7 0-73.7-33-73.7-73.7zM384.1 176a16 16 0 1 0 32 0 16 16 0 1 0 -32 0z", "M147.8 48c-55.1 0-99.7 44.7-99.7 99.7s44.7 99.7 99.7 99.7c22.4 0 40 19.2 38 41.5l-.7 7.7c-1 11-5.9 20.4-12 27.3-13.1 14.9-21.1 34.4-21.1 55.8 0 39.1 26.6 72 62.8 81.5-14.3-20-22.8-44.4-22.8-70.9 0-25 7.7-49.3 22-69.8l35-49.9c35.8-51.2 55.1-112.2 55.1-174.6l0-20.8c0-6.2 5-11.2 11.2-11.2 15.2 0 28.7 7.6 36.8 19.2 8.1-11.6 21.6-19.2 36.8-19.2 6.2 0 11.2 5 11.2 11.2l0 20.8 7.6 0c53.4 0 98.2 40.5 103.5 93.7l.8 8c.5 4.5-.4 9.1-2.4 13.1l-4.1 8.2c-14.4 28.8-42 48.1-73.4 52.3l0 54.8c24.3 19 40 48.7 40 82 0 20.6-6 39.8-16.3 56l33.4 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-252.8 0c-73 0-132.3-59.2-132.3-132.3 0-32.3 11.6-61.9 30.8-84.8-75.5-6.6-134.8-69.9-134.8-147.2 0-81.6 66.1-147.7 147.7-147.7 59.6 0 110.9 35.3 134.2 86 5.5 12 .3 26.3-11.8 31.8s-26.3 .3-31.8-11.8C222.6 71.7 188 48 147.8 48zM352.1 464l16 0c30.9 0 56-25.1 56-56s-25.1-56-56-56c-5.9 0-11.5 .9-16.8 2.6-12.6 4-26.1-3.1-30.1-15.7s3.1-26.1 15.7-30.1c9.9-3.1 20.4-4.8 31.2-4.8 5.4 0 10.8 .4 16 1.2l0-57.2c0-13.3 10.7-24 24-24l11.5 0c18.2 0 34.8-10.3 42.9-26.5l1-2-.1-1.1c-2.9-28.6-27-50.4-55.7-50.4l-58.9 0c-7.6 55.2-28.2 108.1-60.4 154.2l-35 49.9c-8.7 12.4-13.3 27.1-13.3 42.2 0 40.7 33 73.7 73.7 73.7l38.3 0zm32-288a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"]],
    "circle-cedi": [512, 512, [], "e742", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm80 0c0-62.5 44.8-114.5 104-125.8l0-10.2c0-13.3 10.7-24 24-24s24 10.7 24 24l0 10.2c24.5 4.6 46.5 16.3 63.9 32.7 9.6 9.1 10.1 24.3 1 33.9s-24.3 10.1-33.9 1c-8.7-8.2-19.2-14.5-30.9-18.2l0 152.7c11.7-3.7 22.2-9.9 30.9-18.2 9.6-9.1 24.8-8.7 33.9 1s8.7 24.8-1 33.9c-17.4 16.4-39.4 28-63.9 32.7l0 10.2c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-10.2C172.8 370.5 128 318.5 128 256zm48 0c0 35.8 23.5 66.1 56 76.3l0-152.7c-32.5 10.2-56 40.5-56 76.3z", "M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm24-392c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 10.2C172.8 141.5 128 193.5 128 256s44.8 114.5 104 125.8l0 10.2c0 13.3 10.7 24 24 24s24-10.7 24-24l0-10.2c24.5-4.6 46.5-16.3 63.9-32.7 9.6-9.1 10.1-24.3 1-33.9s-24.3-10.1-33.9-1c-8.7 8.2-19.2 14.5-30.9 18.2l0-152.7c11.7 3.7 22.2 9.9 30.9 18.2 9.6 9.1 24.8 8.7 33.9-1s8.7-24.8-1-33.9c-17.4-16.4-39.4-28-63.9-32.7l0-10.2zM176 256c0-35.8 23.5-66.1 56-76.3l0 152.7c-32.5-10.2-56-40.5-56-76.3z"]],
    "file-circle-exclamation": [576, 512, [], "e4eb", ["M80 64c0-8.8 7.2-16 16-16l112 0 0 88c0 39.8 32.2 72 72 72l88 0 0 10.9c-74.6 26.4-128 97.5-128 181.1 0 22.4 3.8 44 10.9 64L96 464c-8.8 0-16-7.2-16-16L80 64z", "M208 48L96 48c-8.8 0-16 7.2-16 16l0 384c0 8.8 7.2 16 16 16l154.9 0c6.1 17.3 14.6 33.4 25.1 48L96 512c-35.3 0-64-28.7-64-64L32 64C32 28.7 60.7 0 96 0L229.5 0c17 0 33.3 6.7 45.3 18.7L397.3 141.3c12 12 18.7 28.3 18.7 45.3l0 22.1c-16.7 1.4-32.8 4.9-48 10.3l0-10.9-88 0c-39.8 0-72-32.2-72-72l0-88zM348.1 160L256 67.9 256 136c0 13.3 10.7 24 24 24l68.1 0zM432 256a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm0 228a20 20 0 1 0 0-40 20 20 0 1 0 0 40zm0-180c-8.8 0-16 7.2-16 16l0 80c0 8.8 7.2 16 16 16s16-7.2 16-16l0-80c0-8.8-7.2-16-16-16z"]],
    "wallet": [512, 512, [], "f555", ["M48 120c0-22.1 17.9-40 40-40l368 0c13.3 0 24-10.7 24-24l0 92.1c-15.2-12.6-34.7-20.1-56-20.1l-304 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l304 0c22.1 0 40 17.9 40 40l0 144c0 22.1-17.9 40-40 40L88 400c-22.1 0-40-17.9-40-40l0-240zM352 288a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M88 32C39.4 32 0 71.4 0 120L0 360c0 48.6 39.4 88 88 88l336 0c48.6 0 88-39.4 88-88l0-144c0-48.6-39.4-88-88-88l-304 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l304 0c22.1 0 40 17.9 40 40l0 144c0 22.1-17.9 40-40 40L88 400c-22.1 0-40-17.9-40-40l0-240c0-22.1 17.9-40 40-40l368 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L88 32zM384 320a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]],
    "square-tugrik": [448, 512, [], "e728", ["M48 96l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16zm64 56c0-13.3 10.7-24 24-24l176 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-64 0 0 39.1 42.9-14.3c8.4-2.8 17.4 1.7 20.2 10.1s-1.7 17.4-10.1 20.2l-53.1 17.7 0 30.3 42.9-14.3c8.4-2.8 17.4 1.7 20.2 10.1s-1.7 17.4-10.1 20.2L248 312.9 248 360c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-31.1-42.9 14.3c-8.4 2.8-17.4-1.7-20.2-10.1s1.7-17.4 10.1-20.2l53.1-17.7 0-30.3-42.9 14.3c-8.4 2.8-17.4-1.7-20.2-10.1s1.7-17.4 10.1-20.2l53.1-17.7 0-55.1-64 0c-13.3 0-24-10.7-24-24z", "M64 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm112 56c0-13.3 10.7-24 24-24l176 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-64 0 0 39.1 42.9-14.3c8.4-2.8 17.4 1.7 20.2 10.1s-1.7 17.4-10.1 20.2l-53.1 17.7 0 30.3 42.9-14.3c8.4-2.8 17.4 1.7 20.2 10.1s-1.7 17.4-10.1 20.2L248 312.9 248 360c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-31.1-42.9 14.3c-8.4 2.8-17.4-1.7-20.2-10.1s1.7-17.4 10.1-20.2l53.1-17.7 0-30.3-42.9 14.3c-8.4 2.8-17.4-1.7-20.2-10.1s1.7-17.4 10.1-20.2l53.1-17.7 0-55.1-64 0c-13.3 0-24-10.7-24-24z"]],
    "message": [512, 512, ["comment-alt"], "f27a", ["M48 128l0 224c0 26.5 21.5 48 48 48l56 0c10.4 0 19.3 6.6 22.6 15.9 .9 2.5 1.4 5.2 1.4 8.1l0 49.7c32.7-23.1 63.3-44.7 91.9-64.9 8.1-5.7 17.8-8.8 27.7-8.8L416 400c26.5 0 48-21.5 48-48l0-224c0-26.5-21.5-48-48-48L96 80c-26.5 0-48 21.5-48 48z", "M203.7 512.9s0 0 0 0l-37.8 26.7c-7.3 5.2-16.9 5.8-24.9 1.7S128 529 128 520l0-72-32 0c-53 0-96-43-96-96L0 128C0 75 43 32 96 32l320 0c53 0 96 43 96 96l0 224c0 53-43 96-96 96l-120.4 0-91.9 64.9zm64.3-104.1c8.1-5.7 17.8-8.8 27.7-8.8L416 400c26.5 0 48-21.5 48-48l0-224c0-26.5-21.5-48-48-48L96 80c-26.5 0-48 21.5-48 48l0 224c0 26.5 21.5 48 48 48l56 0c10.4 0 19.3 6.6 22.6 15.9 .9 2.5 1.4 5.2 1.4 8.1l0 49.7c32.7-23.1 63.3-44.7 91.9-64.9z"]],
    "trophy": [512, 512, [127942], "f091", ["M145.2 48c6.4 160.7 44.3 231.4 71.8 261.7 13.7 15.1 25.9 21.4 33.1 24.1 2.6 1 4.7 1.5 6.1 1.9 1.4-.3 3.5-.9 6.1-1.9 7.2-2.7 19.4-9 33.1-24.1 27.5-30.3 65.5-101 71.8-261.7L145.2 48z", "M217 309.7c-27.6-30.3-65.5-101-71.8-261.7l222.2 0c-6.4 160.7-44.3 231.4-71.8 261.7-13.7 15.1-25.9 21.4-33.1 24.1-2.6 1-4.7 1.5-6.1 1.9-1.4-.3-3.5-.9-6.1-1.9-7.2-2.7-19.4-9-33.1-24.1zM368.3 0l-224 0c-26.5 0-48.1 21.8-47.1 48.2 .2 5.3 .4 10.6 .7 15.8L48.3 64c-26.1 0-49.1 21.5-47.2 49.7 4.8 70.5 29.4 120.2 63 154.4 32.4 32.9 71.5 49.9 104.8 58.6 22.8 31 46.4 45.2 63.3 51.8l0 85.6-80 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l208 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0 0-85.6c17.5-6.8 42.3-21.9 65.9-55.3 34-10 72.4-28.1 103.8-60.5 32.8-33.9 56.6-82 61.5-148.9 2-28.3-21.1-49.7-47.1-49.7l-49.6 0c.3-5.2 .5-10.4 .7-15.8 1-26.5-20.6-48.2-47.1-48.2zM411 112l52.3 0c-4.4 55.5-23.8 92.3-47.9 117.2-10.8 11.1-22.8 20.2-35.4 27.6 13.6-36.7 24.8-83.9 31-144.8zM134.3 261.6c-12.6-7.1-24.9-16-35.9-27.2-24.6-25-44.9-63-49.2-122.4l52.4 0c6.5 63.6 18.3 112.3 32.8 149.6z"]],
    "face-dizzy": [512, 512, ["dizzy"], "f567", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm57.9-102.1c7.8-7.8 20.5-7.8 28.3 0l25.9 25.9 25.9-25.9c7.8-7.8 20.5-7.8 28.3 0s7.8 20.5 0 28.3l-25.9 25.9 25.9 25.9c7.8 7.8 7.8 20.5 0 28.3s-20.5 7.8-28.3 0l-25.9-25.9-25.9 25.9c-7.8 7.8-20.5 7.8-28.3 0s-7.8-20.5 0-28.3l25.9-25.9-25.9-25.9c-7.8-7.8-7.8-20.5 0-28.3zM320 352a64 64 0 1 1 -128 0 64 64 0 1 1 128 0zM297.9 153.9c7.8-7.8 20.5-7.8 28.3 0l25.9 25.9 25.9-25.9c7.8-7.8 20.5-7.8 28.3 0s7.8 20.5 0 28.3l-25.9 25.9 25.9 25.9c7.8 7.8 7.8 20.5 0 28.3s-20.5 7.8-28.3 0l-25.9-25.9-25.9 25.9c-7.8 7.8-20.5 7.8-28.3 0s-7.8-20.5 0-28.3l25.9-25.9-25.9-25.9c-7.8-7.8-7.8-20.5 0-28.3z", "M464 256a208 208 0 1 0 -416 0 208 208 0 1 0 416 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zM134.1 153.9l25.9 25.9 25.9-25.9c7.8-7.8 20.5-7.8 28.3 0s7.8 20.5 0 28.3l-25.9 25.9 25.9 25.9c7.8 7.8 7.8 20.5 0 28.3s-20.5 7.8-28.3 0l-25.9-25.9-25.9 25.9c-7.8 7.8-20.5 7.8-28.3 0s-7.8-20.5 0-28.3l25.9-25.9-25.9-25.9c-7.8-7.8-7.8-20.5 0-28.3s20.5-7.8 28.3 0zm192 0l25.9 25.9 25.9-25.9c7.8-7.8 20.5-7.8 28.3 0s7.8 20.5 0 28.3l-25.9 25.9 25.9 25.9c7.8 7.8 7.8 20.5 0 28.3s-20.5 7.8-28.3 0l-25.9-25.9-25.9 25.9c-7.8 7.8-20.5 7.8-28.3 0s-7.8-20.5 0-28.3l25.9-25.9-25.9-25.9c-7.8-7.8-7.8-20.5 0-28.3s20.5-7.8 28.3 0zM256 288a64 64 0 1 1 0 128 64 64 0 1 1 0-128z"]],
    "bacteria": [640, 512, [], "e059", ["M94.1 190.1c-18.7 18.7-18.7 49.1 0 67.9s49.1 18.7 67.9 0l128-128c18.7-18.7 18.7-49.1 0-67.9s-49.1-18.7-67.9 0l-128 128zM160 216a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm64-64a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zM350.1 382.1c-18.7 18.7-18.7 49.1 0 67.9s49.1 18.7 67.9 0l128-128c18.7-18.7 18.7-49.1 0-67.9s-49.1-18.7-67.9 0l-128 128zM416 408a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M256-32c13.3 0 24 10.7 24 24l0 11c8.6 2.2 16.9 5.6 24.8 10.3L311 7c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-6.3 6.3c4.6 7.8 8 16.2 10.3 24.8l11 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-11 0c-2.2 8.6-5.6 16.9-10.3 24.8L345 151c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-4.1-4.1-30.1 30.1 4.1 4.1c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-4.1-4.1-30.1 30.1 4.1 4.1c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-6.3-6.3c-7.8 4.6-16.2 8-24.8 10.3l0 11c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-11c-8.6-2.2-16.9-5.6-24.8-10.3L73 313c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l6.3-6.3c-4.6-7.8-8-16.2-10.3-24.8l-11 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l11 0c2.2-8.6 5.6-16.9 10.3-24.8L39 169c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l4.1 4.1 30.1-30.1-4.1-4.1c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l4.1 4.1 30.1-30.1-4.1-4.1c-9.4-9.4-9.4-24.6 0-33.9S191.6-2.3 201 7l6.3 6.3c7.8-4.6 16.2-8 24.8-10.3l0-11c0-13.3 10.7-24 24-24zm33.9 161.9c18.7-18.7 18.7-49.1 0-67.9s-49.1-18.7-67.9 0l-128 128c-18.7 18.7-18.7 49.1 0 67.9s49.1 18.7 67.9 0l128-128zM136 192a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm40-40a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm360 32l0 11c8.6 2.2 16.9 5.6 24.8 10.3L567 199c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-6.3 6.3c4.6 7.8 8 16.2 10.3 24.8l11 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-11 0c-2.2 8.6-5.6 16.9-10.3 24.8L601 343c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-4.1-4.1-30.1 30.1 4.1 4.1c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-4.1-4.1-30.1 30.1 4.1 4.1c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-6.3-6.3c-7.8 4.6-16.2 8-24.8 10.3l0 11c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-11c-8.6-2.2-16.9-5.6-24.8-10.3L329 505c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l6.3-6.3c-4.6-7.8-8-16.2-10.3-24.8l-11 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l11 0c2.2-8.6 5.6-16.9 10.3-24.8L295 361c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l4.1 4.1 30.1-30.1-4.1-4.1c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l4.1 4.1 30.1-30.1-4.1-4.1c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l6.3 6.3c7.8-4.6 16.2-8 24.8-10.3l0-11c0-13.3 10.7-24 24-24s24 10.7 24 24zm9.9 70.1c-18.7-18.7-49.1-18.7-67.9 0l-128 128c-18.7 18.7-18.7 49.1 0 67.9s49.1 18.7 67.9 0l128-128c18.7-18.7 18.7-49.1 0-67.9zM368 408a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"]],
    "toggle-large-on": [576, 512, [], "e5b1", ["M240 256a144 144 0 1 0 288 0 144 144 0 1 0 -288 0z", "M192 64C86 64 0 150 0 256S86 448 192 448l192 0c106 0 192-86 192-192S490 64 384 64L192 64zm192 48a144 144 0 1 1 0 288 144 144 0 1 1 0-288z"]],
    "ear-deaf": [512, 512, ["deaf", "deafness", "hard-of-hearing"], "f2a4", ["M100 261c7.4-4.1 12.5-12 12.5-21 0-70.7 57.3-128 128-128 2.7 0 5.4 .1 8.1 .3l14.2 42.6c-7.1-1.9-14.6-2.8-22.3-2.8-48.6 0-88 39.4-88 88 0 13.3 10.7 24 24 24s24-10.7 24-24c0-22.1 17.9-40 40-40s40 17.9 40 40c0 11.3 7.9 20.9 18.5 23.4l25.3 75.8c-7 10.3-11.7 22.8-11.7 36.8 0 48.6-39.4 88-88 88-4.2 0-8.1 1.1-11.5 3l-47.3-86.2 19.8-19.8c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-9.9 9.9-41.6-75.9z", "M505.5 41l-64 64c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l64-64c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9zm-320 320L41.5 505c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l144-144c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9zm55-249c-70.7 0-128 57.3-128 128 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-97.2 78.8-176 176-176s176 78.8 176 176c0 47.5-18.8 90.6-49.4 122.2-4.8 4.9-6.6 9.9-6.6 13.8 0 75.1-60.9 136-136 136-13.3 0-24-10.7-24-24s10.7-24 24-24c48.6 0 88-39.4 88-88 0-19.1 8.9-35.5 20.1-47.1 22.3-23 35.9-54.4 35.9-88.9 0-70.7-57.3-128-128-128zm0 88c-22.1 0-40 17.9-40 40 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-48.6 39.4-88 88-88s88 39.4 88 88c0 13.3-10.7 24-24 24s-24-10.7-24-24c0-22.1-17.9-40-40-40z"]],
    "people-arrows": [512, 512, ["people-arrows-left-right"], "e068", ["M48 224c0-8.8 7.2-16 16-16l26.2 0 2.9-2.9c-28.1 28.1-28.1 73.7 0 101.8-1-1-1.9-1.9-2.9-2.9L64 304c-8.8 0-16-7.2-16-16l0-64zm370.9 82.9c27.2-27.2 28.1-70.6 2.9-98.9l26.2 0c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16l-26.2 0-2.9 2.9z", "M32 64A64 64 0 1 1 160 64 64 64 0 1 1 32 64zM64 208c-8.8 0-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16l26.2 0 69.8 69.8 0 114.2c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-136-32 0 0 136c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-144.6C12.9 332.4 0 311.7 0 288l0-64c0-35.3 28.7-64 64-64l64 0c3.2 0 6.4 .2 9.5 .7L90.2 208 64 208zM352 488l0-114.2 69.8-69.8 26.2 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16l-26.2 0-47.3-47.3c3.1-.5 6.3-.7 9.5-.7l64 0c35.3 0 64 28.7 64 64l0 64c0 23.7-12.9 44.4-32 55.4L480 488c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-136-32 0 0 136c0 13.3-10.7 24-24 24s-24-10.7-24-24zm0-424a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zM295 183c9.4-9.4 24.6-9.4 33.9 0l56 56c9.4 9.4 9.4 24.6 0 33.9l-56 56c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l15-15-108.1 0 15 15c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-56-56c-9.4-9.4-9.4-24.6 0-33.9l56-56c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-15 15 108.1 0-15-15c-9.4-9.4-9.4-24.6 0-33.9z"]],
    "treasure-chest": [512, 512, [], "f723", ["M48 160c0-32.8 19.7-61 48-73.3l0 161.3-48 0 0-88zm0 136l48 0 0 136-32 0c-8.8 0-16-7.2-16-16l0-120zM144 80l224 0 0 168-80 0 0-24c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 24-80 0 0-168zm0 216l80 0 0 24c0 17.7 14.3 32 32 32s32-14.3 32-32l0-24 80 0 0 136-224 0 0-136zM416 86.7c28.3 12.3 48 40.5 48 73.3l0 88-48 0 0-161.3zM416 296l48 0 0 120c0 8.8-7.2 16-16 16l-32 0 0-136z", "M144 80l224 0 0 168-80 0 0-24c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 24-80 0 0-168zm272 6.7c28.3 12.3 48 40.5 48 73.3l0 88-48 0 0-161.3zM464 296l0 120c0 8.8-7.2 16-16 16l-32 0 0-136 48 0zM368 432l-224 0 0-136 80 0 0 24c0 17.7 14.3 32 32 32s32-14.3 32-32l0-24 80 0 0 136zM96 432l-32 0c-8.8 0-16-7.2-16-16l0-120 48 0 0 136zM48 248l0-88c0-32.8 19.7-61 48-73.3l0 161.3-48 0zM128 32C57.3 32 0 89.3 0 160L0 416c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-256c0-70.7-57.3-128-128-128L128 32z"]],
    "caret-large-right": [256, 512, [], "e82e", ["M80.5 134.6L201.9 256 80.5 377.4 80.5 134.6z", "M247.1 233.4c12.5 12.5 12.5 32.8 0 45.2l-160 160c-9.2 9.2-22.9 11.9-34.9 6.9S32.5 428.9 32.5 416l0-320c0-12.9 7.8-24.6 19.8-29.6S78 64.2 87.1 73.4l160 160zM80.5 134.6L80.5 377.4 201.9 256 80.5 134.6z"]],
    "hands-clapping": [512, 512, [], "e1a8", ["M48 249.9c0 2.6 1 5.2 2.9 7 33.6 33.6 62.3 62.3 86.1 86.1 1.2 1.2 2.2 2.4 3.1 3.8 6.2 9.3 5.1 22-3.1 30.2-9.4 9.4-24.6 9.4-33.9 0L65 338.9c-1.9-1.9-4.4-2.9-7-2.9-5.5 0-9.9 4.5-9.9 9.9 0 2.6 1 5.2 2.9 7 32.2 32.2 47 47 71.7 71.7 25.2 25.2 59.4 39.4 95 39.4 74.2 0 134.4-60.2 134.4-134.4L352 208c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 40c0 6.1-2.3 12.3-7 17-2.3 2.3-5 4-7.8 5.2s-5.9 1.8-9.2 1.8c-6.1 0-12.3-2.3-17-7L169 154.9c-1.9-1.9-4.4-2.9-7-2.9-5.5 0-9.9 4.5-9.9 9.9 0 2.6 1 5.2 2.9 7L233 247c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0c-59.7-59.7-96.4-96.4-110.1-110.1-1.9-1.9-4.4-2.9-7-2.9-5.5 0-9.9 4.5-9.9 9.9 0 2.6 1 5.2 2.9 7 5.7 5.7 42.3 42.3 110.1 110.1 9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0L65 242.9c-1.9-1.9-4.4-2.9-7-2.9-5.5 0-9.9 4.5-9.9 9.9zM430.1 418.9c21.1-23.7 33.9-55 33.9-89.3L464 212c0-10.3-7.7-18.7-17.7-19.9 1.1 6.5 1.7 13.1 1.7 19.9l0 117.6c0 31.7-6.4 61.8-17.9 89.3z", "M344 8l0 64c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-64c0-13.3 10.7-24 24-24S344-5.3 344 8zM220 10.7l32 48c7.4 11 4.4 25.9-6.7 33.3s-25.9 4.4-33.3-6.7l-32-48c-7.4-11-4.4-25.9 6.7-33.3S212.6-.3 220 10.7zM152 161.9c0 2.6 1 5.2 2.9 7L233 247c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0c-59.7-59.7-96.4-96.4-110.1-110.1-1.9-1.9-4.4-2.9-7-2.9-5.5 0-9.9 4.5-9.9 9.9 0 2.6 1 5.2 2.9 7 5.7 5.7 42.3 42.3 110.1 110.1 9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-86.1-86.1 0 0c-1.9-1.9-4.4-2.9-7-2.9-5.5 0-9.9 4.5-9.9 9.9 0 2.6 1 5.2 2.9 7l48 48 0 0 38.1 38.1c1.2 1.2 2.2 2.4 3.1 3.8 6.2 9.3 5.1 22-3.1 30.2-9.4 9.4-24.6 9.4-33.9 0l-38.1-38.1 0 0c-1.9-1.9-4.4-2.9-7-2.9-5.5 0-9.9 4.5-9.9 9.9 0 2.6 1 5.2 2.9 7l22 22 0 0 16 16 0 0 33.6 33.6c25.2 25.2 59.4 39.4 95 39.4 74.2 0 134.4-60.2 134.4-134.4L352 208c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 40c0 6.1-2.3 12.3-7 17-2.3 2.3-5 4-7.8 5.2s-5.9 1.8-9.2 1.8c-6.1 0-12.3-2.3-17-7L169 154.9c-1.9-1.9-4.4-2.9-7-2.9-5.5 0-9.9 4.5-9.9 9.9zM0 249.9c0-21.2 11.4-39.8 28.4-49.9-2.9-7-4.4-14.5-4.4-22.1 0-32 25.9-57.9 57.9-57.9 11.4 0 22.5 3.4 31.9 9.6 10.4-15.4 28.1-25.6 48.1-25.6 15.4 0 30.1 6.1 41 17L274 192.1c7.1-27.6 32.2-48.1 62-48.1 35.3 0 64 28.7 64 64l0 121.6c0 100.7-81.7 182.4-182.4 182.4-48.4 0-94.8-19.2-129-53.4l-33.6-33.6 0 0-16-16 0 0-22-22C6.1 376 0 361.3 0 345.9 0 326.4 9.7 309 24.6 298.5L17 290.9C6.1 280 0 265.3 0 249.9zM427.4 146c5.3-1.3 10.9-2 16.6-2 37.6 0 68 30.4 68 68l0 117.6c0 89.7-64.7 164.2-150 179.5 29.6-23.8 53.1-54.8 68-90.2 21.1-23.7 33.9-55 33.9-89.3L464 212c0-10.3-7.7-18.7-17.7-19.9-2.9-16.9-9.5-32.5-18.9-46.1zM453.3 4c11 7.4 14 22.3 6.7 33.3l-32 48c-7.4 11-22.3 14-33.3 6.7s-14-22.3-6.7-33.3l32-48c7.4-11 22.3-14 33.3-6.7z"]],
    "circle-ampersand": [512, 512, [], "e0f8", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm96 61.5c0-21.2 10.1-41.1 27.2-53.6l24.7-18.1-9.2-9.2c-11.9-11.9-18.6-28.1-18.6-45 0-35.1 28.5-63.6 63.6-63.6l19.2 0c33.8 0 61.2 27.4 61.2 61.2 0 19.5-9.3 37.8-25 49.3l-17.6 12.9 28.7 28.7 26.2-37.8c7.5-10.9 22.5-13.6 33.4-6.1s13.6 22.5 6.1 33.4l-31.1 45 28.4 28.4c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-22.4-22.4c-15.1 18.5-37.8 29.4-62 29.4l-32.2 0c-36.7 0-66.5-29.8-66.5-66.5zm48 0c0 10.2 8.3 18.5 18.5 18.5l32.2 0c10.5 0 20.3-5.2 26.3-13.8l1.4-2-40.1-40.1-30.7 22.5c-4.7 3.5-7.5 9-7.5 14.9zm24-125.9c0 4.1 1.6 8.1 4.6 11l14.5 14.5 23.6-17.3c3.4-2.5 5.4-6.4 5.4-10.6 0-7.3-5.9-13.2-13.2-13.2l-19.2 0c-8.6 0-15.6 7-15.6 15.6z", "M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM216 191.6c0-8.6 7-15.6 15.6-15.6l19.2 0c7.3 0 13.2 5.9 13.2 13.2 0 4.2-2 8.1-5.4 10.6l-23.6 17.3-14.5-14.5c-2.9-2.9-4.6-6.9-4.6-11zm71 46.9c15.7-11.5 25-29.8 25-49.3 0-33.8-27.4-61.2-61.2-61.2l-19.2 0c-35.1 0-63.6 28.5-63.6 63.6 0 16.9 6.7 33 18.6 45l9.2 9.2-24.7 18.1c-17.1 12.5-27.2 32.4-27.2 53.6 0 36.7 29.8 66.5 66.5 66.5l32.2 0c24.1 0 46.9-10.9 62-29.4L327 377c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-28.4-28.4 31.1-45c7.5-10.9 4.8-25.8-6.1-33.4s-25.8-4.8-33.4 6.1l-26.2 37.8-28.7-28.7 17.6-12.9zm-87.5 64.1l30.7-22.5 40.1 40.1-1.4 2c-6 8.6-15.8 13.8-26.3 13.8l-32.2 0c-10.2 0-18.5-8.3-18.5-18.5 0-5.9 2.8-11.4 7.5-14.9z"]],
    "virus-covid-slash": [576, 512, [], "e4a9", ["M216 150.2c20.5-14 45.3-22.2 72-22.2 70.7 0 128 57.3 128 128 0 26.7-8.2 51.5-22.2 72L216 150.2z", "M41-24.9c-9.4-9.4-24.6-9.4-33.9 0S-2.3-.3 7 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-83-83 11.4-11.4c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-11.3 11.3-23.8-23.8c17.9-23.5 29.9-51.7 34.1-82.3l33.6 0 0 16c0 13.3 10.7 24 24 24s24-10.7 24-24l0-80c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 16-33.6 0c-4.2-30.7-16.3-58.8-34.1-82.3l23.8-23.8 11.3 11.3c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9L440.7 46.7c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l11.3 11.3-23.8 23.8C370.8 97.9 342.7 85.8 312 81.6l0-33.6 16 0c13.3 0 24-10.7 24-24S341.3 0 328 0L248 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l16 0 0 33.6c-30.7 4.2-58.8 16.3-82.3 34.1L157.9 92 169.2 80.6c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0L123.9 58.1 41-24.9zm175 175c20.5-14 45.3-22.2 72-22.2 70.7 0 128 57.3 128 128 0 26.7-8.2 51.5-22.2 72L216 150.2zM160 256c0-8.2 .8-16.2 2.2-23.9l-38.7-38.7c-4.7 12.3-8 25.2-9.9 38.7l-33.6 0 0-16c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 80c0 13.3 10.7 24 24 24s24-10.7 24-24l0-16 33.6 0c4.2 30.7 16.3 58.8 34.1 82.3l-23.8 23.8-11.3-11.3c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l56.6 56.6c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-11.3-11.3 23.8-23.8c23.5 17.9 51.7 29.9 82.3 34.1l0 33.6-16 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l80 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-16 0 0-33.6c13.4-1.8 26.4-5.2 38.7-9.9l-38.7-38.7c-7.8 1.5-15.8 2.2-23.9 2.2-70.7 0-128-57.3-128-128z"]],
    "chart-simple-horizontal": [448, 512, [], "e474", ["M48 48l0 48 288 0 0-48-288 0zm0 384l0 48 160 0 0-48-160 0z", "M336 96l0-48-288 0 0 48 288 0zm0 48L48 144C21.5 144 0 122.5 0 96L0 48C0 21.5 21.5 0 48 0L336 0c26.5 0 48 21.5 48 48l0 48c0 26.5-21.5 48-48 48zm64 96l-352 0 0 48 352 0 0-48zm48 48c0 26.5-21.5 48-48 48L48 336c-26.5 0-48-21.5-48-48l0-48c0-26.5 21.5-48 48-48l352 0c26.5 0 48 21.5 48 48l0 48zM208 432l-160 0 0 48 160 0 0-48zm48 48c0 26.5-21.5 48-48 48L48 528c-26.5 0-48-21.5-48-48l0-48c0-26.5 21.5-48 48-48l160 0c26.5 0 48 21.5 48 48l0 48z"]],
    "down-from-dotted-line": [384, 512, [], "e407", ["M105.9 368l86.1 86.1 86.1-86.1-30.1 0c-13.3 0-24-10.7-24-24l0-168-64 0c0 52 0 108 0 168 0 13.3-10.7 24-24 24l-30.1 0z", "M209 505c-9.4 9.4-24.6 9.4-33.9 0L31 361c-6.9-6.9-8.9-17.2-5.2-26.2S38.3 320 48 320l64 0 0-64 0 0 0-80c0-26.5 21.5-48 48-48l64 0c26.5 0 48 21.5 48 48l0 144 64 0c9.7 0 18.5 5.8 22.2 14.8s1.7 19.3-5.2 26.2L209 505zm15-249l0-80-64 0 0 80 0 0 0 88c0 13.3-10.7 24-24 24l-30.1 0 86.1 86.1 86.1-86.1-30.1 0c-13.3 0-24-10.7-24-24l0-88zM32 0a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM138.7 0a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM277.3 32a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM352 0a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]],
    "calendar-days": [448, 512, ["calendar-alt"], "f073", ["M48 224l0 80 88 0 0-80-88 0zm0 128l0 64c0 8.8 7.2 16 16 16l72 0 0-80-88 0zM184 224l0 80 80 0 0-80-80 0zm0 128l0 80 80 0 0-80-80 0zM312 224l0 80 88 0 0-80-88 0zm0 128l0 80 72 0c8.8 0 16-7.2 16-16l0-64-88 0z", "M120 0c13.3 0 24 10.7 24 24l0 40 160 0 0-40c0-13.3 10.7-24 24-24s24 10.7 24 24l0 40 32 0c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 128C0 92.7 28.7 64 64 64l32 0 0-40c0-13.3 10.7-24 24-24zM384 432c8.8 0 16-7.2 16-16l0-64-88 0 0 80 72 0zm16-128l0-80-88 0 0 80 88 0zm-136 0l0-80-80 0 0 80 80 0zm-128 0l0-80-88 0 0 80 88 0zM48 352l0 64c0 8.8 7.2 16 16 16l72 0 0-80-88 0zm136 0l0 80 80 0 0-80-80 0zM120 112l-56 0c-8.8 0-16 7.2-16 16l0 48 352 0 0-48c0-8.8-7.2-16-16-16l-264 0z"]],
    "lighthouse": [576, 512, [], "e612", ["M180.2 464l51.2-256 113.3 0 51.2 256-75.8 0 0-64c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 64-75.8 0zM240 81.7l48-29.5 48 29.5 0 78.3-96 0 0-78.3z", "M275.4 3.6c7.7-4.7 17.4-4.7 25.2 0l104 64c11.3 6.9 14.8 21.7 7.9 33-6 9.8-18 13.8-28.4 10.1l0 49.4 8 0c13.3 0 24 10.7 24 24 0 12.7-9.9 23.1-22.4 23.9L444.8 464 456 464c13.3 0 24 10.7 24 24s-10.7 24-24 24l-336 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l11.2 0 51.2-256.1c-12.5-.8-22.4-11.2-22.4-23.9 0-13.3 10.7-24 24-24l8 0 0-49.4c-10.4 3.7-22.4-.2-28.4-10.1-6.9-11.3-3.4-26.1 7.9-33l104-64zM336 81.7l-48-29.5-48 29.5 0 78.3 96 0 0-78.3zM180.2 464l75.8 0 0-64c0-17.7 14.3-32 32-32s32 14.3 32 32l0 64 75.8 0-51.2-256-113.3 0-51.2 256zM42.7 10.5l64 32c11.9 5.9 16.7 20.3 10.7 32.2S97.1 91.4 85.3 85.5l-64-32C9.4 47.5 4.6 33.1 10.5 21.3S30.9 4.6 42.7 10.5zm64 202.9l-64 32c-11.9 5.9-26.3 1.1-32.2-10.7s-1.1-26.3 10.7-32.2l64-32c11.9-5.9 26.3-1.1 32.2 10.7s1.1 26.3-10.7 32.2zM565.5 21.3c5.9 11.9 1.1 26.3-10.7 32.2l-64 32c-11.9 5.9-26.3 1.1-32.2-10.7s-1.1-26.3 10.7-32.2l64-32c11.9-5.9 26.3-1.1 32.2 10.7zm-106.9 160c5.9-11.9 20.3-16.7 32.2-10.7l64 32c11.9 5.9 16.7 20.3 10.7 32.2s-20.3 16.7-32.2 10.7l-64-32c-11.9-5.9-16.7-20.3-10.7-32.2z"]],
    "diamond-turn-right": [512, 512, ["directions"], "f5eb", ["M48 256c0 2.6 1 5.2 2.9 7L249 461.1c1.9 1.9 4.4 2.9 7 2.9s5.2-1 7-2.9L461.1 263c1.9-1.9 2.9-4.4 2.9-7s-1-5.2-2.9-7L263 50.9c-1.9-1.9-4.4-2.9-7-2.9s-5.2 1-7 2.9L50.9 249c-1.9 1.9-2.9 4.4-2.9 7zm112 32c0-39.8 32.2-72 72-72l54.1 0-23-23c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l64 64c9.4 9.4 9.4 24.6 0 33.9l-64 64c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l23-23-54.1 0c-13.3 0-24 10.7-24 24l0 24c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-24z", "M50.9 249L249 50.9c1.9-1.9 4.4-2.9 7-2.9s5.2 1 7 2.9L461.1 249c1.9 1.9 2.9 4.4 2.9 7s-1 5.2-2.9 7L263 461.1c-1.9 1.9-4.4 2.9-7 2.9s-5.2-1-7-2.9L50.9 263c-1.9-1.9-2.9-4.4-2.9-7s1-5.2 2.9-7zM215 17L17 215C6.1 225.9 0 240.6 0 256s6.1 30.1 17 41L215 495c10.9 10.9 25.6 17 41 17s30.1-6.1 41-17L495 297c10.9-10.9 17-25.6 17-41s-6.1-30.1-17-41L297 17C286.1 6.1 271.4 0 256 0s-30.1 6.1-41 17zM361 257c9.4-9.4 9.4-24.6 0-33.9l-64-64c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l23 23-54.1 0c-39.8 0-72 32.2-72 72l0 24c0 13.3 10.7 24 24 24s24-10.7 24-24l0-24c0-13.3 10.7-24 24-24l54.1 0-23 23c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l64-64z"]],
    "drone": [512, 512, [], "f85f", ["M208 224l0 64c0 8.8 7.2 16 16 16l64 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16l-64 0c-8.8 0-16 7.2-16 16z", "M417.7 338.5L396.2 317c2.5-9.3 3.8-19 3.8-29 61.9 0 112 50.1 112 112s-50.1 112-112 112-112-50.1-112-112c10 0 19.8-1.3 29-3.8l21.5 21.5c7.7 26.8 32.3 46.3 61.5 46.3 35.3 0 64-28.7 64-64 0-29.2-19.6-53.9-46.3-61.5zM112 0c61.9 0 112 50.1 112 112-10 0-19.8 1.3-29 3.8L173.5 94.3c-7.7-26.8-32.3-46.3-61.5-46.3-35.3 0-64 28.7-64 64 0 29.2 19.6 53.9 46.3 61.5L115.8 195c-2.5 9.3-3.8 19-3.8 29-61.9 0-112-50.1-112-112S50.1 0 112 0zM0 400c0-61.9 50.1-112 112-112 0 10 1.3 19.8 3.8 29L94.3 338.5c-26.8 7.7-46.3 32.3-46.3 61.5 0 35.3 28.7 64 64 64 29.2 0 53.9-19.6 61.5-46.3L195 396.2c9.3 2.5 19 3.8 29 3.8 0 61.9-50.1 112-112 112S0 461.9 0 400zM317 115.8c-9.3-2.5-19-3.8-29-3.8 0-61.9 50.1-112 112-112s112 50.1 112 112-50.1 112-112 112c0-10-1.3-19.8-3.8-29l21.5-21.5c26.8-7.7 46.3-32.3 46.3-61.5 0-35.3-28.7-64-64-64-29.2 0-53.9 19.6-61.5 46.3L317 115.8zM224 208c-8.8 0-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16l64 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16l-64 0zm-64 16c0-8.9 1.8-17.3 5.1-25L95 129c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l70 70c7.7-3.3 16.1-5.1 25-5.1l64 0c8.9 0 17.3 1.8 25 5.1l70-70c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-70 70c3.3 7.7 5.1 16.1 5.1 25l0 64c0 8.9-1.8 17.3-5.1 25l70 70c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-70-70c-7.7 3.3-16.1 5.1-25 5.1l-64 0c-8.9 0-17.3-1.8-25-5.1l-70 70c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l70-70c-3.3-7.7-5.1-16.1-5.1-25l0-64z"]],
    "text": [384, 512, [], "f893", ["", "M48 136l0-56 120 0 0 352-64 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l176 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-64 0 0-352 120 0 0 56c0 13.3 10.7 24 24 24s24-10.7 24-24l0-64c0-22.1-17.9-40-40-40L40 32C17.9 32 0 49.9 0 72l0 64c0 13.3 10.7 24 24 24s24-10.7 24-24z"]],
    "square-guarani": [448, 512, [], "e70e", ["M32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64C46.3 64 32 78.3 32 96zm72 160c0-60.8 45.3-111.1 104-118.9l0-17.1c0-8.8 7.2-16 16-16s16 7.2 16 16l0 17.1c26.3 3.5 50 15.6 68 33.2 6.3 6.2 6.4 16.3 .2 22.6s-16.3 6.4-22.6 .2c-12.3-12-28-20.5-45.6-23.7l0 70.6 88 0c8.8 0 16 7.2 16 16 0 60.8-45.3 111.1-104 118.9l0 17.1c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-17.1c-58.7-7.8-104-58.1-104-118.9zm32 0c0 43.1 31 79 72 86.6l0-173.1c-41 7.5-72 43.4-72 86.5zm104 16l0 70.6c35.8-6.6 64-34.8 70.6-70.6L240 272z", "M64 64C46.3 64 32 78.3 32 96l0 320c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L64 64zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm208 24c0-8.8 7.2-16 16-16s16 7.2 16 16l0 17.1c26.3 3.5 50 15.6 68 33.2 6.3 6.2 6.4 16.3 .2 22.6s-16.3 6.4-22.6 .2c-12.3-12-28-20.5-45.6-23.7l0 70.6 88 0c8.8 0 16 7.2 16 16 0 60.8-45.3 111.1-104 118.9l0 17.1c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-17.1c-58.7-7.8-104-58.1-104-118.9s45.3-111.1 104-118.9l0-17.1zM136 256c0 43.1 31 79 72 86.6l0-173.1c-41 7.5-72 43.4-72 86.5zm174.5 16l-70.6 0 0 70.6c35.8-6.6 64-34.8 70.6-70.6z"]],
    "toilet-paper-under-slash": [576, 512, ["toilet-paper-reverse-slash"], "e2a1", ["M145.8 80l210.9 0c-3 4.5-5.7 9.3-8.2 14.1-18.1 34.5-28.5 80.5-28.5 129.9 0 10.7 .5 21.3 1.4 31.6L145.8 80zM368 224c0-43.3 9.2-81.3 23-107.7 14.4-27.5 30.1-36.3 41-36.3s26.6 8.9 41 36.3c13.8 26.3 23 64.3 23 107.7s-9.2 81.3-23 107.7c-13.6 26-28.4 35.4-39.2 36.3l-48.4-48.4C374.8 294.2 368 261 368 224zm40 0c0 26.5 10.7 48 24 48s24-21.5 24-48-10.7-48-24-48-24 21.5-24 48z", "M41-24.9c-9.4-9.4-24.6-9.4-33.9 0S-2.3-.3 7 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-25.2-25.2c.2-1.9 .2-3.9 .2-5.9l0-248C544 174.5 533.5 128.6 515.5 94.1 498 60.7 469.7 32 432 32L144 32c-13.3 0-25.5 3.6-36.4 9.7L41-24.9zM145.8 80l210.9 0c-3 4.5-5.7 9.3-8.2 14.1-18.1 34.5-28.5 80.5-28.5 129.9 0 10.7 .5 21.3 1.4 31.6L145.8 80zM433.8 367.9l-48.4-48.4c-10.6-25.3-17.3-58.5-17.3-95.5 0-43.3 9.2-81.3 23-107.7 14.4-27.5 30.1-36.3 41-36.3s26.6 8.9 41 36.3c13.8 26.3 23 64.3 23 107.7s-9.2 81.3-23 107.7c-13.6 26-28.4 35.4-39.2 36.3zm37 37c9.4-5.7 17.8-13.2 25.2-21.8l0 47.1-25.2-25.2zM298.2 368L144 368c-10.9 0-26.6-8.9-41-36.3-13.8-26.3-23-64.3-23-107.7 0-24.1 2.9-46.6 7.8-66.4L49.4 119.2C38.2 149.6 32 185.8 32 224 32 273.5 42.5 319.4 60.5 353.9 78 387.3 106.3 416 144 416l16 0 0 56c0 39.8 32.2 72 72 72l240 0c.7 0 1.4 0 2.1 0l-48-48-194.2 0c-13.3 0-24-10.7-24-24l0-56 138.2 0-48-48zM456 224c0-26.5-10.7-48-24-48s-24 21.5-24 48 10.7 48 24 48 24-21.5 24-48z"]],
    "hand-point-up": [384, 512, [9757], "f0a6", ["M48 320l0 24c0 66.3 53.7 120 120 120l48 0c52.5 0 97.1-33.7 113.4-80.7-3.1 .5-6.2 .7-9.4 .7-20 0-37.9-9.2-49.7-23.6-9 4.9-19.4 7.6-30.3 7.6-15.1 0-29-5.3-40-14-11 8.8-24.9 14-40 14l-40 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l40 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-80 0c-17.7 0-32 14.3-32 32zM64 64l0 177.6c5.2-1 10.5-1.6 16-1.6l16 0 0-176c0-8.8-7.2-16-16-16S64 55.2 64 64zm80 144l0 32 16 0c5.5 0 10.9 .7 16 2l0-34c0-8.8-7.2-16-16-16s-16 7.2-16 16zm80 32l0 64c0 8.8 7.2 16 16 16s16-7.2 16-16l0-64c0-8.8-7.2-16-16-16s-16 7.2-16 16zm80 16l0 64c0 8.8 7.2 16 16 16s16-7.2 16-16l0-64c0-8.8-7.2-16-16-16s-16 7.2-16 16z", "M64 64l0 177.6c5.2-1 10.5-1.6 16-1.6l16 0 0-176c0-8.8-7.2-16-16-16S64 55.2 64 64zM80 288c-17.7 0-32 14.3-32 32l0 24c0 66.3 53.7 120 120 120l48 0c52.5 0 97.1-33.7 113.4-80.7-3.1 .5-6.2 .7-9.4 .7-20 0-37.9-9.2-49.7-23.6-9 4.9-19.4 7.6-30.3 7.6-15.1 0-29-5.3-40-14-11 8.8-24.9 14-40 14l-40 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l40 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-80 0zM0 320l0 0c0-18 6-34.6 16-48L16 64C16 28.7 44.7 0 80 0s64 28.7 64 64l0 82c5.1-1.3 10.5-2 16-2 25.3 0 47.2 14.7 57.6 36 7-2.6 14.5-4 22.4-4 20 0 37.9 9.2 49.7 23.6 9-4.9 19.4-7.6 30.3-7.6 35.3 0 64 28.7 64 64l0 88c0 92.8-75.2 168-168 168l-48 0C75.2 512 0 436.8 0 344l0-24zm336-64c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16s16-7.2 16-16l0-64zM160 240c5.5 0 10.9 .7 16 2l0-34c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 32 16 0zm64 24l0 40c0 8.8 7.2 16 16 16s16-7.2 16-16l0-64c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 24z"]],
    "pen-slash": [576, 512, [], "e213", ["M269.9 204c20.7-20.7 41.4-41.4 62.1-62.1L402.1 212 340 274.1 269.9 204z", "M41-24.9c-9.4-9.4-24.6-9.4-33.9 0S-2.3-.3 7 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9L373.9 308 522.8 159.1C536.4 145.6 544 127.2 544 108s-7.6-37.6-21.2-51.1L487.1 21.2C473.6 7.6 455.2 0 436 0s-37.6 7.6-51.1 21.2L236 170.1 41-24.9zM269.9 204L332 141.9 402.1 212 340 274.1 269.9 204zm2.2 137.9l-77.2 77.2c-4.9 4.9-10.9 8.4-17.6 10.3l-86.9 24.1 24.1-86.9c1.8-6.6 5.4-12.7 10.3-17.6l77.2-77.2-33.9-33.9-77.2 77.2c-10.7 10.7-18.5 24.1-22.6 38.7L32.9 481.6c-2.3 8.3 0 17.3 6.2 23.4s15.1 8.5 23.4 6.2l127.8-35.5c14.6-4.1 27.9-11.8 38.7-22.6l77.2-77.2-33.9-33.9zM418.8 55.1c4.6-4.6 10.7-7.1 17.2-7.1s12.6 2.6 17.2 7.1l35.7 35.7c4.6 4.6 7.1 10.7 7.1 17.2s-2.6 12.6-7.1 17.2L436 178.1 365.9 108 418.8 55.1z"]],
    "comment-plus": [512, 512, [], "f4b2", ["M48 240c0 42.8 15.1 82.4 41.2 114.7 12.2 15.1 14.1 36.1 4.8 53.2l-18 33.1 58.5-25.1c11.8-5.1 25.2-5.2 37.1-.3 25.7 10.5 54.2 16.4 84.3 16.4 117.8 0 208-88.8 208-192S373.8 48 256 48 48 136.8 48 240zm112 0c0-13.3 10.7-24 24-24l48 0 0-48c0-13.3 10.7-24 24-24s24 10.7 24 24l0 48 48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0 0 48c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-48-48 0c-13.3 0-24-10.7-24-24z", "M0 240c0 54.4 19.3 104.6 51.9 144.9L3.1 474.3c-2 3.7-3.1 7.9-3.1 12.2 0 14.1 11.4 25.5 25.5 25.5 4 0 7.8-.6 11.5-2.1L153.4 460c31.4 12.9 66.1 20 102.6 20 141.4 0 256-107.5 256-240S397.4 0 256 0 0 107.5 0 240zM94 407.9c9.3-17.1 7.4-38.1-4.8-53.2-26.1-32.3-41.2-71.9-41.2-114.7 0-103.2 90.2-192 208-192s208 88.8 208 192-90.2 192-208 192c-30.2 0-58.7-5.9-84.3-16.4-11.9-4.9-25.3-4.8-37.1 .3L76 440.9 94 407.9zM256 144c-13.3 0-24 10.7-24 24l0 48-48 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l48 0 0 48c0 13.3 10.7 24 24 24s24-10.7 24-24l0-48 48 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0 0-48c0-13.3-10.7-24-24-24z"]],
    "bezier-curve": [640, 512, [], "f55b", ["M48 112a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zM80 368l0 64 64 0 0-64-64 0zM288 80l0 64 64 0 0-64-64 0zM496 368l0 64 64 0 0-64-64 0zm64-256a16 16 0 1 0 32 0 16 16 0 1 0 -32 0z", "M352 80l0 64-64 0 0-64 64 0zM288 32c-26.5 0-48 21.5-48 48l0 8-116.7 0C113.9 64.5 90.9 48 64 48 28.7 48 0 76.7 0 112s28.7 64 64 64c26.9 0 49.9-16.5 59.3-40l79 0C138.2 173.8 93.9 241.5 88.5 320L80 320c-26.5 0-48 21.5-48 48l0 64c0 26.5 21.5 48 48 48l64 0c26.5 0 48-21.5 48-48l0-64c0-26.5-21.5-48-48-48l-7.3 0c5.9-68.4 49.2-126.1 109.4-152.6 8.2 14.7 23.9 24.6 41.9 24.6l64 0c18 0 33.7-9.9 41.9-24.6 60.2 26.4 103.5 84.1 109.4 152.6l-7.3 0c-26.5 0-48 21.5-48 48l0 64c0 26.5 21.5 48 48 48l64 0c26.5 0 48-21.5 48-48l0-64c0-26.5-21.5-48-48-48l-8.5 0c-5.3-78.5-49.7-146.2-113.8-184l79 0c9.5 23.5 32.5 40 59.3 40 35.3 0 64-28.7 64-64s-28.7-64-64-64c-26.9 0-49.9 16.5-59.3 40l-116.7 0 0-8c0-26.5-21.5-48-48-48l-64 0zM48 112a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm512 0a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM144 368l0 64-64 0 0-64 64 0zm352 0l64 0 0 64-64 0 0-64z"]],
    "clipboard-list-check": [384, 512, [], "f737", ["M48 96l0 352c0 8.8 7.2 16 16 16l256 0c8.8 0 16-7.2 16-16l0-352c0-8.8-7.2-16-16-16l-16.4 0c-4 36-34.5 64-71.6 64l-80 0c-37.1 0-67.6-28-71.6-64L64 80c-8.8 0-16 7.2-16 16zM73.9 244.9c-6.6-8.3-5.3-20.4 3-27s20.4-5.3 27 3l10 12.5 30.3-37.5c6.7-8.2 18.8-9.5 27-2.8s9.5 18.8 2.8 27l-45.3 56c-3.7 4.5-9.2 7.1-15 7.1s-11.3-2.7-14.9-7.2L73.9 244.9zM144 352a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm32 0c0-13.3 10.7-24 24-24l80 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24zm16-96c0-13.3 10.7-24 24-24l64 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-64 0c-13.3 0-24-10.7-24-24z", "M152 96l80 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0c-13.3 0-24 10.7-24 24s10.7 24 24 24zm0 48c-37.1 0-67.6-28-71.6-64L64 80c-8.8 0-16 7.2-16 16l0 352c0 8.8 7.2 16 16 16l256 0c8.8 0 16-7.2 16-16l0-352c0-8.8-7.2-16-16-16l-16.4 0c-4 36-34.5 64-71.6 64l-80 0zM232 0c25 0 47 12.7 59.9 32L320 32c35.3 0 64 28.7 64 64l0 352c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l28.1 0C105 12.7 127 0 152 0l80 0zM171.2 193.1c8.2 6.7 9.5 18.8 2.8 27l-45.3 56c-3.7 4.5-9.2 7.1-15 7.1s-11.3-2.7-14.9-7.2L73.9 244.9c-6.6-8.3-5.3-20.4 3-27s20.4-5.3 27 3l10 12.5 30.3-37.5c6.7-8.2 18.8-9.5 27-2.8zM192 256c0-13.3 10.7-24 24-24l64 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-64 0c-13.3 0-24-10.7-24-24zm-16 96c0-13.3 10.7-24 24-24l80 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24zm-64-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]],
    "lamp-desk": [576, 512, [], "e014", ["M257 65c17.1-17.1 44.9-17.1 62.1 0l40 40c4.5 4.5 10.6 7 17 7L494.1 112 304 302.1 304 184c0-6.4-2.5-12.5-7-17l-40-40c-17.1-17.1-17.1-44.9 0-62.1z", "M353 31c-35.9-35.9-94.1-35.9-129.9 0-35.3 35.3-35.9 92.3-1.6 128.3l-85.7 79.1c-6.7 6.1-9.3 15.5-6.8 24.2L186.5 464 56 464c-13.3 0-24 10.7-24 24s10.7 24 24 24l336 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-155.6 0-57.3-200.4 76.2-70.3 .7 .7 0 125.1c0 22.6 18.3 41 41 41 10.9 0 21.3-4.3 29-12L540 133.9c7.7-7.7 12-18.1 12-29 0-22.6-18.3-41-41-41l-125.1 0-33-33zM257 65c17.1-17.1 44.9-17.1 62.1 0l40 40c4.5 4.5 10.6 7 17 7L494.1 112 304 302.1 304 184c0-6.4-2.5-12.5-7-17l-40-40c-17.1-17.1-17.1-44.9 0-62.1z"]],
    "person-half-dress": [384, 512, [], "e548", ["M128.2 336l47.8-162.7 0 162.7-47.8 0z", "M192 80a56 56 0 1 0 0-112 56 56 0 1 0 0 112zm-16 32.8c-33.2 4-63.6 21.7-83.3 49.3L12.5 274c-7.7 10.8-5.2 25.8 5.5 33.5s25.8 5.2 33.5-5.5L113.6 215.3 70 363.5C67 373.7 74.7 384 85.4 384l42.6 0 0 136c0 13.3 10.7 24 24 24s24-10.7 24-24l0-184-47.8 0 47.8-162.7 0-60.5zm48 3.4L224 520c0 13.3 10.7 24 24 24s24-10.7 24-24l0-302.4 60.5 84.4c7.7 10.8 22.7 13.2 33.5 5.5s13.2-22.7 5.5-33.5L292.3 163.5c-16.8-23.5-41.1-40-68.3-47.3z"]],
    "peanut": [512, 512, [], "e430", ["M48 370l0 54c0 22.1 17.9 40 40 40l49.8 0c34 0 66.8-12.8 91.9-35.7l7.1-6.5c23.2-21.3 37.6-50.6 40.2-82l.2-2.2c2.7-32.2 28.3-57.8 60.5-60.5 32.8-2.7 63.4-17.7 85.6-42l3.2-3.5c24.2-26.4 37.6-60.8 37.6-96.6L464 88c0-22.1-17.9-40-40-40l-47.1 0c-35.8 0-70.2 13.4-96.6 37.6l-3.5 3.2c-24.3 22.2-39.3 52.8-42 85.6-2.7 32.2-28.3 57.8-60.5 60.5l-3.7 .3c-31 2.6-60 16-82 38l-1.1 1.1C62.3 299.7 48 334.1 48 370zm107.2 22a19.2 19.2 0 1 1 -38.4 0 19.2 19.2 0 1 1 38.4 0zm64-64a19.2 19.2 0 1 1 -38.4 0 19.2 19.2 0 1 1 38.4 0zm0 64a19.2 19.2 0 1 1 -38.4 0 19.2 19.2 0 1 1 38.4 0zm128-192a19.2 19.2 0 1 1 -38.4 0 19.2 19.2 0 1 1 38.4 0zm64-64a19.2 19.2 0 1 1 -38.4 0 19.2 19.2 0 1 1 38.4 0zm0 64a19.2 19.2 0 1 1 -38.4 0 19.2 19.2 0 1 1 38.4 0z", "M280.4 85.6C306.7 61.4 341.2 48 376.9 48L424 48c22.1 0 40 17.9 40 40l0 47.1c0 35.8-13.4 70.2-37.6 96.6l-3.2 3.5c-22.2 24.3-52.8 39.3-85.6 42-32.2 2.7-57.8 28.3-60.5 60.5l-.2 2.2c-2.6 31.4-17 60.7-40.2 82l-7.1 6.5c-25.1 23-57.9 35.7-91.9 35.7L88 464c-22.1 0-40-17.9-40-40l0-54c0-35.9 14.3-70.4 39.7-95.8l1.1-1.1c22-22 51-35.4 82-38l3.7-.3c32.2-2.7 57.8-28.3 60.5-60.5 2.7-32.8 17.7-63.4 42-85.6l3.5-3.2zM376.9 0c-47.8 0-93.8 17.9-129 50.2l-3.5 3.2c-33.2 30.4-53.7 72.2-57.4 117-.7 8.9-7.8 15.9-16.7 16.7l-3.7 .3c-42.3 3.5-81.9 21.9-111.9 51.9l-1.1 1.1C19.3 274.7 0 321.4 0 370l0 54c0 48.6 39.4 88 88 88l49.8 0c46 0 90.4-17.3 124.3-48.4l7.1-6.5c32.1-29.5 52-69.9 55.6-113.4l.2-2.2c.7-8.9 7.8-15.9 16.7-16.7 44.8-3.7 86.6-24.2 117-57.4l3.2-3.5c32.3-35.2 50.2-81.2 50.2-129L512 88c0-48.6-39.4-88-88-88L376.9 0zm34.3 136a19.2 19.2 0 1 0 -38.4 0 19.2 19.2 0 1 0 38.4 0zm-64 64a19.2 19.2 0 1 0 -38.4 0 19.2 19.2 0 1 0 38.4 0zm-192 192a19.2 19.2 0 1 0 -38.4 0 19.2 19.2 0 1 0 38.4 0zM200 411.2a19.2 19.2 0 1 0 0-38.4 19.2 19.2 0 1 0 0 38.4zM411.2 200a19.2 19.2 0 1 0 -38.4 0 19.2 19.2 0 1 0 38.4 0zM200 347.2a19.2 19.2 0 1 0 0-38.4 19.2 19.2 0 1 0 0 38.4z"]],
    "message-plus": [512, 512, ["comment-alt-plus"], "f4a8", ["M48 128l0 224c0 26.5 21.5 48 48 48l56 0c10.4 0 19.3 6.6 22.6 15.9 .9 2.5 1.4 5.2 1.4 8.1l0 49.7c32.7-23.1 63.3-44.7 91.9-64.9 8.1-5.7 17.8-8.8 27.7-8.8L416 400c26.5 0 48-21.5 48-48l0-224c0-26.5-21.5-48-48-48L96 80c-26.5 0-48 21.5-48 48zM160 240c0-13.3 10.7-24 24-24l48 0 0-48c0-13.3 10.7-24 24-24s24 10.7 24 24l0 48 48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0 0 48c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-48-48 0c-13.3 0-24-10.7-24-24z", "M203.7 512.9l0 0 91.9-64.9 120.4 0c53 0 96-43 96-96l0-224c0-53-43-96-96-96L96 32C43 32 0 75 0 128L0 352c0 53 43 96 96 96l32 0 0 72c0 9 5 17.2 13 21.3s17.6 3.5 24.9-1.7l37.8-26.7zM295.6 400c-9.9 0-19.6 3.1-27.7 8.8-28.6 20.2-59.3 41.8-91.9 64.9l0-49.7c0-2.8-.5-5.6-1.4-8.1-3.3-9.3-12.2-15.9-22.6-15.9l-56 0c-26.5 0-48-21.5-48-48l0-224c0-26.5 21.5-48 48-48l320 0c26.5 0 48 21.5 48 48l0 224c0 26.5-21.5 48-48 48l-120.4 0zM256 144c-13.3 0-24 10.7-24 24l0 48-48 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l48 0 0 48c0 13.3 10.7 24 24 24s24-10.7 24-24l0-48 48 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0 0-48c0-13.3-10.7-24-24-24z"]],
    "bracket-curly": [256, 512, ["bracket-curly-left"], "7b", ["", "M64.5 120c0-48.6 39.4-88 88-88l48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0c-22.1 0-40 17.9-40 40l0 45.5c0 23.3-9.3 45.7-25.8 62.2L58.4 256 86.7 284.3c16.5 16.5 25.8 38.9 25.8 62.2l0 45.5c0 22.1 17.9 40 40 40l48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0c-48.6 0-88-39.4-88-88l0-45.5c0-10.6-4.2-20.8-11.7-28.3L7.5 273c-9.4-9.4-9.4-24.6 0-33.9l45.3-45.3c7.5-7.5 11.7-17.7 11.7-28.3l0-45.5z"]],
    "square-poll-horizontal": [448, 512, ["poll-h"], "f682", ["M48 96l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16zm48 64c0-13.3 10.7-24 24-24l112 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-112 0c-13.3 0-24-10.7-24-24zm0 96c0-13.3 10.7-24 24-24l208 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-208 0c-13.3 0-24-10.7-24-24zm0 96c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24z", "M64 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm256 64c0 13.3-10.7 24-24 24l-112 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l112 0c13.3 0 24 10.7 24 24zm72 72c13.3 0 24 10.7 24 24s-10.7 24-24 24l-208 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l208 0zM192 352c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l48 0c13.3 0 24 10.7 24 24z"]],
    "nfc-signal": [576, 512, [], "e1fb", ["M80 96c0-8.8 7.2-16 16-16l320 0c8.8 0 16 7.2 16 16l0 170.5c-17 8-33.1 17.7-48 28.9L384 168c0-22.1-17.9-40-40-40l-72 0c-22.1 0-40 17.9-40 40l0 56c-9.7 7.3-16 18.9-16 32 0 22.1 17.9 40 40 40s40-17.9 40-40c0-13.1-6.3-24.7-16-32l0-48 56 0 0 160-160 0 0-160 8 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-16 0c-22.1 0-40 17.9-40 40l0 176c0 22.1 17.9 40 40 40l138.6 0c-8.4 15.2-15.4 31.2-20.9 48L96 432c-8.8 0-16-7.2-16-16L80 96z", "M416 80L96 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l189.7 0c-5.1 15.4-8.8 31.5-11.1 48L96 480c-35.3 0-64-28.7-64-64L32 96c0-35.3 28.7-64 64-64l320 0c35.3 0 64 28.7 64 64l0 153c-16.7 4.4-32.7 10.2-48 17.4L432 96c0-8.8-7.2-16-16-16zM306.6 384L168 384c-22.1 0-40-17.9-40-40l0-176c0-22.1 17.9-40 40-40l16 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-8 0 0 160 160 0 0-160-56 0 0 48c9.7 7.3 16 18.9 16 32 0 22.1-17.9 40-40 40s-40-17.9-40-40c0-13.1 6.3-24.7 16-32l0-56c0-22.1 17.9-40 40-40l72 0c22.1 0 40 17.9 40 40l0 127.3c-31.7 23.7-58.1 53.9-77.4 88.7zM552 288c13.3 0 24 10.7 24 24s-10.7 24-24 24c-101.6 0-184 82.4-184 184 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-128.1 103.9-232 232-232zm-8 192a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm32-72c0 13.3-10.7 24-24 24-48.6 0-88 39.4-88 88 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-75.1 60.9-136 136-136 13.3 0 24 10.7 24 24z"]],
    "box-isometric": [512, 512, [], "e797", ["M64 176.8l168 93.3 0 193.1-147.4-81.9c-12.7-7.1-20.6-20.4-20.6-35l0-169.6zM82.2 132l63.1-35.1 2 1.1 170.7 96-62.1 34.5-173.8-96.5zM194.6 69.6l41.9-23.3c12.1-6.7 26.8-6.7 38.9 0l154.4 85.8-62.5 34.7-172.7-97.1zM280 270.1l168-93.3 0 169.6c0 14.5-7.9 27.9-20.6 35L280 463.2 280 270.1z", "M232 270.1L64 176.8 64 346.3c0 14.5 7.9 27.9 20.6 35l147.4 81.9 0-193.1zM145.4 96.9l-63.1 35.1 173.8 96.5 62.1-34.5-170.7-96-2-1.1zm49.3-27.4l172.7 97.1 62.5-34.7-154.4-85.8c-12.1-6.7-26.8-6.7-38.9 0L194.6 69.6zM280 270.1l0 193.1 147.4-81.9c12.7-7.1 20.6-20.4 20.6-35l0-169.6-168 93.3zm18.7 237.6c-26.6 14.8-58.9 14.8-85.5 0l-152-84.4C33.3 407.8 16 378.3 16 346.3L16 161c0-29.1 15.8-55.8 41.1-69.9L213.2 4.3c26.6-14.8 58.9-14.8 85.5 0L454.8 91C480.2 105.1 496 131.9 496 161l0 185.4c0 32-17.3 61.4-45.3 76.9l-152 84.4z"]],
    "school-circle-xmark": [640, 512, [], "e56d", ["M48 192c0-8.8 7.2-16 16-16l72 0c5.4 0 10.6-1.8 14.9-5.2L288 62.6 425.1 170.8c4.2 3.3 9.5 5.2 14.9 5.2l72 0c8.8 0 16 7.2 16 16l0 18.7c-10.4-1.7-21.1-2.7-32-2.7-84 0-155.5 54-181.5 129.2-3.4-.8-6.9-1.2-10.5-1.2l-32 0c-26.5 0-48 21.5-48 48l0 80-160 0c-8.8 0-16-7.2-16-16l0-256zm48 48l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm0 128l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zM224 192a64 64 0 1 0 128 0 64 64 0 1 0 -128 0z", "M273.1 13.2c8.7-6.9 21-6.9 29.7 0L448.3 128 512 128c35.3 0 64 28.7 64 64l0 33.4c-15.1-6.9-31.2-11.9-48-14.8l0-18.7c0-8.8-7.2-16-16-16l-72 0c-5.4 0-10.6-1.8-14.9-5.2L288 62.6 150.9 170.8c-4.2 3.3-9.5 5.2-14.9 5.2l-72 0c-8.8 0-16 7.2-16 16l0 256c0 8.8 7.2 16 16 16l160 0 0-80c0-26.5 21.5-48 48-48l32 0c3.6 0 7.1 .4 10.5 1.2-6.8 19.7-10.5 40.8-10.5 62.8 0 41.8 13.4 80.5 36 112L64 512c-35.3 0-64-28.7-64-64L0 192c0-35.3 28.7-64 64-64l63.7 0 145.5-114.8zM144 416l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16zm16-144c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32zM288 128a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM496 256a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm22.6 144l36.7-36.7c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-36.7 36.7-36.7-36.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l36.7 36.7-36.7 36.7c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l36.7-36.7 36.7 36.7c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L518.6 400z"]],
    "person-seat-window": [448, 512, [], "e788", ["M144 224l0 88c0 13.3 10.7 24 24 24l8 0 0-112c0-8.8-7.2-16-16-16s-16 7.2-16 16zM336 96l0 96c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-96c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16z", "M160 128a56 56 0 1 0 0-112 56 56 0 1 0 0 112zM48 184c0-13.3-10.7-24-24-24S0 170.7 0 184L0 360c0 66.3 53.7 120 120 120l80 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0c-39.8 0-72-32.2-72-72l0-176zm112 24c8.8 0 16 7.2 16 16l0 112-8 0c-13.3 0-24-10.7-24-24l0-88c0-8.8 7.2-16 16-16zm64 128l0-112c0-35.3-28.7-64-64-64s-64 28.7-64 64l0 88c0 39.8 32.2 72 72 72l80 0c13.3 0 24 10.7 24 24l0 80c0 13.3 10.7 24 24 24l48 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-24 0 0-56c0-39.8-32.2-72-72-72l-24 0zM352 80l32 0c8.8 0 16 7.2 16 16l0 96c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-96c0-8.8 7.2-16 16-16zM288 96l0 96c0 35.3 28.7 64 64 64l32 0c35.3 0 64-28.7 64-64l0-96c0-35.3-28.7-64-64-64l-32 0c-35.3 0-64 28.7-64 64z"]],
    "grapes": [576, 512, [], "e306", ["M72.4 432a40 40 0 1 0 80 0 40 40 0 1 0 -80 0zm32-120a40 40 0 1 0 80 0 40 40 0 1 0 -80 0zm16-112a40 40 0 1 0 80 0 40 40 0 1 0 -80 0zm72 200a40 40 0 1 0 80 0 40 40 0 1 0 -80 0zm24-112a40 40 0 1 0 80 0 40 40 0 1 0 -80 0zm24-104a40 40 0 1 0 80 0 40 40 0 1 0 -80 0zm64 200a40 40 0 1 0 80 0 40 40 0 1 0 -80 0zm16-120a40 40 0 1 0 80 0 40 40 0 1 0 -80 0z", "M389.1-4.7L376.9 7.4c-31.2 31.2-31.2 81.9 0 113.1 15.6 15.6 31.2 31.2 46.9 46.9 31.2 31.2 81.9 31.2 113.1 0l12.1-12.1c6.2-6.2 6.2-16.4 0-22.6l-12.1-12.1c-31.2-31.2-81.9-31.2-113.1 0 31.2-31.2 31.2-81.9 0-113.1L411.7-4.7c-6.2-6.2-16.4-6.2-22.6 0zM440.4 264c0-44.2-35.8-80-80-80 0-44.2-35.8-80-80-80-28 0-52.6 14.4-66.9 36.1-14.1-12.5-32.7-20.1-53.1-20.1-44.2 0-80 35.8-80 80 0 18 6 34.6 16 48-19.4 14.6-32 37.8-32 64 0 17.6 5.7 33.8 15.2 47-27.9 12.5-47.2 40.5-47.2 73 0 44.2 35.8 80 80 80 32.5 0 60.5-19.4 73-47.2 13.2 9.6 29.4 15.2 47 15.2 26.2 0 49.4-12.6 64-32 13.4 10 30 16 48 16 44.2 0 80-35.8 80-80 0-20.4-7.6-39-20.1-53.1 21.8-14.3 36.1-38.9 36.1-66.9zm-160-120a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm-120 16a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm-56 152a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zm8 80a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm80 8a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zm152-56a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm-128-56a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zm144-64a40 40 0 1 1 0 80 40 40 0 1 1 0-80z"]],
    "hand-lizard": [512, 512, [], "f258", ["M48 136c0-13.3 10.7-24 24-24l209.6 0c32 0 62.2 14.7 81.9 39.9L441.9 252c14.3 18.3 22.1 40.9 22.1 64.1L464 424c0 13.3 10.7 24 24 24l-136 0c13.3 0 24-10.7 24-24l0-24c0-8.3-4.3-16-11.3-20.4l-64-40c-3.8-2.4-8.2-3.6-12.7-3.6l-152 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l104 0c35.3 0 64-28.7 64-64s-28.7-64-64-64L72 160c-13.3 0-24-10.7-24-24z", "M72 112c-13.3 0-24 10.7-24 24s10.7 24 24 24l168 0c35.3 0 64 28.7 64 64s-28.7 64-64 64l-104 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l152 0c4.5 0 8.9 1.3 12.7 3.6l64 40c7 4.4 11.3 12.1 11.3 20.4l0 24c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-10.7-46.9-29.3-145.1 0c-39.8 0-72-32.2-72-72s32.2-72 72-72l104 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L72 208c-39.8 0-72-32.2-72-72S32.2 64 72 64l209.6 0c46.7 0 90.9 21.5 119.7 58.3l78.4 100.1c20.9 26.7 32.3 59.7 32.3 93.7L512 424c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-107.9c0-23.2-7.8-45.8-22.1-64.1L363.5 151.9c-19.7-25.2-49.9-39.9-81.9-39.9L72 112z"]],
    "camera-slash": [576, 512, [], "e0d9", ["M190.8 125l27.6-41.4c1.5-2.2 4-3.6 6.7-3.6l125.7 0c2.7 0 5.2 1.3 6.7 3.6l33.2 49.8c4.5 6.7 11.9 10.7 20 10.7l69.3 0c8.8 0 16 7.2 16 16l0 256c0 3.9-1.4 7.6-3.8 10.4L388.1 322.3c7.6-15.1 11.9-32.2 11.9-50.3 0-61.9-50.1-112-112-112-18.1 0-35.2 4.3-50.3 11.9L190.8 125z", "M41-24.9c-9.4-9.4-24.6-9.4-33.9 0S-2.3-.3 7 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-42.8-42.8c11-11.5 17.8-27.1 17.8-44.3l0-256c0-35.3-28.7-64-64-64l-56.5 0-26-39.1C387.1 41.4 369.6 32 350.9 32L225.1 32c-18.7 0-36.2 9.4-46.6 24.9L156.2 90.4 41-24.9zM190.8 125l27.6-41.4c1.5-2.2 4-3.6 6.7-3.6l125.7 0c2.7 0 5.2 1.3 6.7 3.6l33.2 49.8c4.5 6.7 11.9 10.7 20 10.7l69.3 0c8.8 0 16 7.2 16 16l0 256c0 3.9-1.4 7.6-3.8 10.4L388.1 322.3c7.6-15.1 11.9-32.2 11.9-50.3 0-61.9-50.1-112-112-112-18.1 0-35.2 4.3-50.3 11.9L190.8 125zM350.7 284.9l-75.6-75.6c4.2-.8 8.5-1.3 12.9-1.3 35.3 0 64 28.7 64 64 0 4.4-.4 8.7-1.3 12.9zM47.9 117.7C38 129 32 143.8 32 160l0 256c0 35.3 28.7 64 64 64l314.2 0-48-48-266.2 0c-8.8 0-16-7.2-16-16l0-256c0-2.9 .8-5.7 2.2-8L47.9 117.7zM288 384c8.1 0 16-.9 23.7-2.5l-52.2-52.2c-12.5-6.2-22.6-16.4-28.8-28.8l-52.2-52.2c-1.6 7.6-2.5 15.5-2.5 23.7 0 61.9 50.1 112 112 112z"]],
    "chalkboard": [576, 512, ["blackboard"], "f51b", ["M80 120c0-4.4 3.6-8 8-8l400 0c4.4 0 8 3.6 8 8l0 280-48 0 0-40c0-30.9-25.1-56-56-56l-80 0c-30.9 0-56 25.1-56 56l0 40-176 0 0-280z", "M80 120l0 280 176 0 0-40c0-30.9 25.1-56 56-56l80 0c30.9 0 56 25.1 56 56l0 40 48 0 0-280c0-4.4-3.6-8-8-8L88 112c-4.4 0-8 3.6-8 8zM32 400l0-280c0-30.9 25.1-56 56-56l400 0c30.9 0 56 25.1 56 56l0 280 8 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 448c-13.3 0-24-10.7-24-24s10.7-24 24-24l8 0zm368-40c0-4.4-3.6-8-8-8l-80 0c-4.4 0-8 3.6-8 8l0 40 96 0 0-40z"]],
    "memo-pad": [384, 512, [], "e1da", ["M48 128l0 320c0 8.8 7.2 16 16 16l256 0c8.8 0 16-7.2 16-16l0-320-288 0zm40 72c0-13.3 10.7-24 24-24l152 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-152 0c-13.3 0-24-10.7-24-24zm0 96c0-13.3 10.7-24 24-24l152 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-152 0c-13.3 0-24-10.7-24-24zm0 96c0-13.3 10.7-24 24-24l88 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-88 0c-13.3 0-24-10.7-24-24z", "M336 128l0 320c0 8.8-7.2 16-16 16L64 464c-8.8 0-16-7.2-16-16l0-320 288 0zM64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-384c0-35.3-28.7-64-64-64L64 0zM88 200c0 13.3 10.7 24 24 24l152 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-152 0c-13.3 0-24 10.7-24 24zm0 96c0 13.3 10.7 24 24 24l152 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-152 0c-13.3 0-24 10.7-24 24zm0 96c0 13.3 10.7 24 24 24l88 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-88 0c-13.3 0-24 10.7-24 24z"]],
    "bluetooth": [320, 512, [], "f293", ["M184 77.2l0 128 75-61.8-75-66.2zm0 229.7l0 128 75-66.2-75-61.8z", "M150.1 2.1c8.6-3.9 18.7-2.4 25.7 3.9l136 120c5.3 4.7 8.2 11.4 8.1 18.4s-3.3 13.6-8.7 18.1L197.8 256 311.3 349.5c5.4 4.5 8.6 11.1 8.7 18.1s-2.8 13.8-8.1 18.4l-136 120c-7.1 6.2-17.1 7.8-25.7 3.9S136 497.4 136 488l0-181.1-96.7 79.7c-10.2 8.4-25.4 7-33.8-3.3s-7-25.4 3.3-33.8L122.2 256 8.7 162.5C-1.5 154.1-3 139 5.5 128.7S29 117 39.3 125.5L136 205.1 136 24c0-9.4 5.5-18 14.1-21.9zM184 306.9l0 128 75-66.2-75-61.8zm0-101.7l75-61.8-75-66.2 0 128z"]],
    "objects-align-center-horizontal": [448, 512, [], "e3bc", ["M48 112l0 64 352 0 0-64-352 0zm64 224l0 64 224 0 0-64-224 0z", "M248-8c0-13.3-10.7-24-24-24S200-21.3 200-8l0 72-152 0C21.5 64 0 85.5 0 112l0 64c0 26.5 21.5 48 48 48l152 0 0 64-88 0c-26.5 0-48 21.5-48 48l0 64c0 26.5 21.5 48 48 48l88 0 0 72c0 13.3 10.7 24 24 24s24-10.7 24-24l0-72 88 0c26.5 0 48-21.5 48-48l0-64c0-26.5-21.5-48-48-48l-88 0 0-64 152 0c26.5 0 48-21.5 48-48l0-64c0-26.5-21.5-48-48-48l-152 0 0-72zM400 112l0 64-352 0 0-64 352 0zM336 336l0 64-224 0 0-64 224 0z"]],
    "distribute-spacing-vertical": [512, 512, [], "e366", ["M144 208l0 96 224 0 0-96-224 0z", "M0 56C0 69.3 10.7 80 24 80l464 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L24 32C10.7 32 0 42.7 0 56zM368 208l0 96-224 0 0-96 224 0zM144 160c-26.5 0-48 21.5-48 48l0 96c0 26.5 21.5 48 48 48l224 0c26.5 0 48-21.5 48-48l0-96c0-26.5-21.5-48-48-48l-224 0zM24 432c-13.3 0-24 10.7-24 24s10.7 24 24 24l464 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L24 432z"]],
    "up-right-from-square": [512, 512, ["external-link-alt"], "f35d", ["M369.9 48l94.1 94.1 0-94.1-94.1 0z", "M312 0c-9.7 0-18.5 5.8-22.2 14.8S288.2 34.1 295 41l71 71-167 167c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l167-167 71 71c6.9 6.9 17.2 8.9 26.2 5.2S512 209.7 512 200l0-176c0-13.3-10.7-24-24-24L312 0zM464 142.1l-94.1-94.1 94.1 0 0 94.1zM80 96C35.8 96 0 131.8 0 176L0 432c0 44.2 35.8 80 80 80l256 0c44.2 0 80-35.8 80-80l0-88c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 88c0 17.7-14.3 32-32 32L80 464c-17.7 0-32-14.3-32-32l0-256c0-17.7 14.3-32 32-32l88 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L80 96z"]],
    "square-turkish-lira": [448, 512, [], "e71f", ["M48 96l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16zm64.8 149.1c-2.8-8.4 1.7-17.4 10.1-20.2l37.1-12.4 0-60.5c0-13.3 10.7-24 24-24s24 10.7 24 24l0 44.5 58.9-19.6c8.4-2.8 17.4 1.7 20.2 10.1s-1.7 17.4-10.1 20.2l-69.1 23 0 30.3 58.9-19.6c8.4-2.8 17.4 1.7 20.2 10.1s-1.7 17.4-10.1 20.2l-69.1 23 0 41.8 48 0c26.5 0 48-21.5 48-48 0-13.3 10.7-24 24-24s24 10.7 24 24c0 53-43 96-96 96l-72 0c-13.3 0-24-10.7-24-24l0-49.8-26.9 9c-8.4 2.8-17.4-1.7-20.2-10.1s1.7-17.4 10.1-20.2l37.1-12.4 0-30.3-26.9 9c-8.4 2.8-17.4-1.7-20.2-10.1z", "M64 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm184 32c13.3 0 24 10.7 24 24l0 44.5 58.9-19.6c8.4-2.8 17.4 1.7 20.2 10.1s-1.7 17.4-10.1 20.2l-69.1 23 0 30.3 58.9-19.6c8.4-2.8 17.4 1.7 20.2 10.1s-1.7 17.4-10.1 20.2l-69.1 23 0 41.8 48 0c26.5 0 48-21.5 48-48 0-13.3 10.7-24 24-24s24 10.7 24 24c0 53-43 96-96 96l-72 0c-13.3 0-24-10.7-24-24l0-49.8-26.9 9c-8.4 2.8-17.4-1.7-20.2-10.1s1.7-17.4 10.1-20.2l37.1-12.4 0-30.3-26.9 9c-8.4 2.8-17.4-1.7-20.2-10.1s1.7-17.4 10.1-20.2l37.1-12.4 0-60.5c0-13.3 10.7-24 24-24z"]],
    "rotate-exclamation": [512, 512, [], "e23c", ["", "M489.3 256.2c13.2 1.4 22.7 13.2 21.4 26.3-5.8 56.4-30.4 111.3-73.6 154.5-100 100-262.1 100-362 0L48 409.9 48 488c0 13.3-10.7 24-24 24S0 501.3 0 488L0 352c0-13.3 10.7-24 24-24l120.1 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-62.2 0 27.1 27.1c81.2 81.2 212.9 81.2 294.2 0 35.1-35.1 55-79.7 59.8-125.5 1.4-13.2 13.2-22.8 26.4-21.4zM256.1 384a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm0-256c18.2 0 32.7 15.5 31.4 33.7l-7.4 104c-.9 12.6-11.4 22.3-23.9 22.3-12.6 0-23-9.7-23.9-22.3l-7.4-104c-1.3-18.2 13.1-33.7 31.4-33.7zM488.2 0c13.3 0 24 10.7 24 24l0 136c0 13.3-10.7 24-24 24l-120.1 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l62.2 0-27.1-27.1c-81.2-81.2-212.9-81.2-294.2 0-35.1 35.1-55.1 79.7-59.8 125.6-1.4 13.2-13.2 22.7-26.3 21.4S.1 242.7 1.5 229.5c5.8-56.4 30.4-111.3 73.6-154.6 100-100 262.1-100 362 0l27.1 27.1 0-78.1c0-13.3 10.7-24 24-24z"]],
    "right-from-line": [512, 512, ["arrow-alt-from-left"], "f347", ["M176 224l0 64 168 0c13.3 0 24 10.7 24 24l0 30.1 86.1-86.1-86.1-86.1 0 30.1c0 6.4-2.5 12.5-7 17s-10.6 7-17 7c-60 0-116 0-168 0z", "M505 273c4.5-4.5 7-10.6 7-17s-2.5-12.5-7-17L361 95c-6.9-6.9-17.2-8.9-26.2-5.2S320 102.3 320 112l0 64-64 0 0 0-80 0c-26.5 0-48 21.5-48 48l0 64c0 26.5 21.5 48 48 48l144 0 0 64c0 9.7 5.8 18.5 14.8 22.2s19.3 1.7 26.2-5.2L505 273zM256 288l-80 0 0-64 80 0 0 0 88 0c6.4 0 12.5-2.5 17-7s7-10.6 7-17l0-30.1 86.1 86.1-86.1 86.1 0-30.1c0-13.3-10.7-24-24-24l-88 0zM24 64C10.7 64 0 74.7 0 88L0 424c0 13.3 10.7 24 24 24s24-10.7 24-24L48 88c0-13.3-10.7-24-24-24z"]],
    "circle-q": [512, 512, [], "e11e", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm88 0c0-66.3 53.7-120 120-120s120 53.7 120 120c0 24.5-7.3 47.2-19.9 66.2L369 335c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-12.9-12.9c-19 12.6-41.7 19.9-66.2 19.9-66.3 0-120-53.7-120-120zm48 0c0 39.8 32.2 72 72 72 11.1 0 21.6-2.5 31-7l-25.9-25.9c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0L321 287c4.5-9.4 7-19.9 7-31 0-39.8-32.2-72-72-72s-72 32.2-72 72z", "M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM184 256c0-39.8 32.2-72 72-72s72 32.2 72 72c0 11.1-2.5 21.6-7 31l-25.9-25.9c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9L287 321c-9.4 4.5-19.9 7-31 7-39.8 0-72-32.2-72-72zm192 0c0-66.3-53.7-120-120-120s-120 53.7-120 120 53.7 120 120 120c24.5 0 47.2-7.3 66.2-19.9L335 369c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-12.9-12.9c12.6-19 19.9-41.7 19.9-66.2z"]],
    "moon-over-sun": [576, 512, ["eclipse-alt"], "f74a", ["M84.2 171.4l47.3 71.3c5.3 8 5.3 18.5 0 26.5l-47.3 71.3 83.9 17c9.5 1.9 16.8 9.3 18.8 18.8l17 83.9 71.3-47.3c8-5.3 18.5-5.3 26.5 0l71.3 47.3 17-83.9c1.9-9.5 9.3-16.8 18.8-18.8l83.9-17-47.3-71.3c-5.3-8-5.3-18.5 0-26.5l47.3-71.3-83.9-17c-9.5-1.9-16.9-9.3-18.8-18.8l-17-83.9-71.3 47.3c-8 5.3-18.5 5.3-26.5 0l-71.3-47.3-17 83.9c-1.9 9.5-9.3 16.8-18.8 18.8l-83.9 17zM192.5 251c.1-1.6 .2-3.2 .4-4.8 .3-3.2 .8-6.4 1.5-9.5 1.3-6.2 3.2-12.3 5.6-18 4.9-11.5 11.9-21.8 20.6-30.5 17.4-17.4 41.4-28.1 67.9-28.1 5.6 0 11.1 .5 16.5 1.4 45.2 7.8 79.5 47.2 79.5 94.6 0 25.2-9.7 48.1-25.6 65.3-.2 .2-.3 .3-.5 .5-17.5 18.6-42.4 30.2-69.9 30.2-26.5 0-50.5-10.7-67.9-28.1-8.7-8.7-15.7-19-20.6-30.5-2.4-5.7-4.3-11.8-5.6-18-.6-3.1-1.1-6.3-1.5-9.5-.3-3.2-.5-6.5-.5-9.8 0-1.7 0-3.3 .1-5z", "M200.6-7.9c-6.7-4.4-15.1-5.2-22.5-2.2S165.4-.5 163.9 7.3L143 110.6 39.7 131.4c-7.8 1.6-14.4 7-17.4 14.3s-2.2 15.8 2.2 22.5L82.7 256 24.5 343.8c-4.4 6.7-5.2 15.1-2.2 22.5s9.6 12.8 17.4 14.3L143 401.4 163.9 504.7c1.6 7.8 7 14.4 14.3 17.4s15.8 2.2 22.5-2.2l87.8-58.2 87.8 58.2c6.7 4.4 15.1 5.2 22.5 2.2s12.8-9.6 14.3-17.4l20.9-103.2 103.2-20.9c7.8-1.6 14.4-7 17.4-14.3s2.2-15.8-2.2-22.5l-58.2-87.8 58.2-87.8c4.4-6.7 5.2-15.1 2.2-22.5s-9.6-12.8-17.4-14.3L433.8 110.6 413 7.3C411.4-.5 406-7 398.6-10.1s-15.8-2.2-22.5 2.2L288.4 50.3 200.6-7.9zM186.9 135.7l17-83.9 71.3 47.3c8 5.3 18.5 5.3 26.5 0l71.3-47.3 17 83.9c1.9 9.5 9.3 16.8 18.8 18.8l83.9 17-47.3 71.3c-5.3 8-5.3 18.5 0 26.5l47.3 71.3-83.9 17c-9.5 1.9-16.9 9.3-18.8 18.8l-17 83.9-71.3-47.3c-8-5.3-18.5-5.3-26.5 0l-71.3 47.3-17-83.9c-1.9-9.5-9.3-16.9-18.8-18.8l-83.9-17 47.3-71.3c5.3-8 5.3-18.5 0-26.5l-47.3-71.3 83.9-17c9.5-1.9 16.8-9.3 18.8-18.8zM192.4 256c0 53 43 96 96 96 27.6 0 52.4-11.6 69.9-30.2 4-4.3 5.4-10.4 3.5-16s-6.6-9.7-12.5-10.7c-30.1-5.2-53-31.5-53-63.1 0-17 6.6-32.4 17.4-43.9 4-4.3 5.4-10.4 3.5-16s-6.6-9.7-12.4-10.7c-5.4-.9-10.9-1.4-16.5-1.4-53 0-96 43-96 96z"]],
    "360-degrees": [640, 512, [], "e2dc", ["", "M608 64a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM24 64C10.7 64 0 74.7 0 88s10.7 24 24 24l83.2 0-71.1 106.7c-4.9 7.4-5.4 16.8-1.2 24.6S47.1 256 56 256l32 0c30.9 0 56 25.1 56 56l0 40c0 26.5-21.5 48-48 48l-1.5 0c-16 0-31-8-39.9-21.4L44 362.7c-7.4-11-22.3-14-33.3-6.7s-14 22.3-6.7 33.3l10.6 15.9C32.5 432 62.4 448 94.5 448l1.5 0c53 0 96-43 96-96l0-40c0-53.3-40-97.2-91.6-103.3L172 101.3c4.9-7.4 5.4-16.8 1.2-24.6S160.9 64 152 64L24 64zm440 80c0-17.7 14.3-32 32-32s32 14.3 32 32l0 224c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-224zM576 368l0-224c0-44.2-35.8-80-80-80s-80 35.8-80 80l0 224c0 44.2 35.8 80 80 80s80-35.8 80-80zM272 160c0-26.5 21.5-48 48-48 13.3 0 24-10.7 24-24s-10.7-24-24-24c-53 0-96 43-96 96l0 128 0 .2 0 79.8c0 44.2 35.8 80 80 80s80-35.8 80-80l0-96c0-44.2-35.8-80-80-80-11.4 0-22.2 2.4-32 6.7l0-38.7zm32 80c17.7 0 32 14.3 32 32l0 96c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-96c0-17.7 14.3-32 32-32z"]],
    "bracket-round-right": [192, 512, [], "29", ["", "M35.4 43.7c-6.8 11.4-3 26.1 8.3 32.9 33 19.6 100.3 84.1 100.3 179.4S76.7 415.7 43.7 435.4c-11.4 6.8-15.1 21.5-8.3 32.9s21.5 15.1 32.9 8.3C110 451.8 192 374.1 192 256S110 60.2 68.3 35.4c-11.4-6.8-26.1-3-32.9 8.3z"]],
    "square-full": [512, 512, [128997, 128998, 128999, 129000, 129001, 129002, 129003, 11035, 11036], "f45c", ["M48 64l0 384c0 8.8 7.2 16 16 16l384 0c8.8 0 16-7.2 16-16l0-384c0-8.8-7.2-16-16-16L64 48c-8.8 0-16 7.2-16 16z", "M448 48c8.8 0 16 7.2 16 16l0 384c0 8.8-7.2 16-16 16L64 464c-8.8 0-16-7.2-16-16L48 64c0-8.8 7.2-16 16-16l384 0zM64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-384c0-35.3-28.7-64-64-64L64 0z"]],
    "star-sharp": [512, 512, [], "e28b", ["M94 224l88.8 69.1c7.9 6.2 11.2 16.6 8.1 26.2l-32.5 102.3 82.9-64.5c8.7-6.7 20.8-6.7 29.5 0l82.9 64.5-32.5-102.3c-3-9.6 .2-20 8.1-26.2L418.1 224 312 224c-10.5 0-19.7-6.8-22.9-16.7L256 103.2 222.9 207.3c-3.2 10-12.4 16.7-22.9 16.7L94 224z", "M256 0c10.5 0 19.7 6.8 22.9 16.7L329.6 176 488 176c10.3 0 19.4 6.5 22.7 16.2s.1 20.4-8 26.7L371.9 320.7 422.9 480.7c3.2 10-.5 21-9.1 27s-20.2 5.7-28.5-.7L256 406.4 126.7 506.9c-8.3 6.5-19.8 6.8-28.5 .7s-12.3-16.9-9.1-27L140.1 320.7 9.3 218.9c-8.1-6.3-11.3-17-8-26.7S13.7 176 24 176l158.5 0 50.7-159.3C236.3 6.8 245.6 0 256 0zm0 103.2L222.9 207.3c-3.2 10-12.4 16.7-22.9 16.7L94 224 182.7 293.1c7.9 6.2 11.2 16.6 8.1 26.2l-32.5 102.3 82.9-64.5c8.7-6.7 20.8-6.7 29.5 0l82.9 64.5-32.5-102.3c-3-9.6 .2-20 8.1-26.2L418.1 224 312 224c-10.5 0-19.7-6.8-22.9-16.7L256 103.2z"]],
    "list-radio": [512, 512, [], "e1d0", ["M40 256a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm0 160a24 24 0 1 0 48 0 24 24 0 1 0 -48 0z", "M0 96A64 64 0 1 1 128 96 64 64 0 1 1 0 96zM88 256a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM0 256a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zM88 416a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM0 416a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zM216 72l272 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-272 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zm0 160l272 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-272 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zm0 160l272 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-272 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"]],
    "head-side-medical": [512, 512, [], "f809", ["M48 224c0-97.2 78.8-176 176-176 86.6 0 158.7 62.6 173.3 145.1 .9 4.8 3.2 9.3 6.7 12.8l52.2 52.2c5 5 7.9 11.9 7.9 19 0 14.9-12 26.9-26.9 26.9L424 304c-13.3 0-24 10.7-24 24l0 48c0 22.1-17.9 40-40 40l-48 0c-13.3 0-24 10.7-24 24l0 48c0 13.3 10.7 24 24 24-187.9 0-262.5 0-224 0 13.3 0 24-10.7 24-24l0-99.9c0-18.1-7.8-34.2-18.5-46-28.3-31.2-45.5-72.6-45.5-118.1zm88-16l0 32c0 8.8 7.2 16 16 16l40 0 0 40c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-40 40 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-40 0 0-40c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16l0 40-40 0c-8.8 0-16 7.2-16 16z", "M224 0C100.3 0 0 100.3 0 224 0 281.8 22 334.6 58 374.3 62.2 379 64 384 64 388.1L64 488c0 13.3 10.7 24 24 24s24-10.7 24-24l0-99.9c0-18.1-7.8-34.2-18.5-46-28.3-31.2-45.5-72.6-45.5-118.1 0-97.2 78.8-176 176-176 86.6 0 158.7 62.6 173.3 145.1 .9 4.8 3.2 9.3 6.7 12.8l52.2 52.2c5 5 7.9 11.9 7.9 19 0 14.9-12 26.9-26.9 26.9L424 304c-13.3 0-24 10.7-24 24l0 48c0 22.1-17.9 40-40 40l-48 0c-13.3 0-24 10.7-24 24l0 48c0 13.3 10.7 24 24 24s24-10.7 24-24l0-24 24 0c48.6 0 88-39.4 88-88l0-24.8c36.2-5.3 64-36.5 64-74.1 0-19.9-7.9-38.9-21.9-53l-47-47C421.5 75.9 331.7 0 224 0zM192 152l0 40-40 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l40 0 0 40c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-40 40 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-40 0 0-40c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16z"]],
    "tombstone": [448, 512, [], "f720", ["M80 192l0 272 288 0 0-272c0-79.5-64.5-144-144-144S80 112.5 80 192zm48 24c0-13.3 10.7-24 24-24l48 0 0-40c0-13.3 10.7-24 24-24s24 10.7 24 24l0 40 48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0 0 120c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-120-48 0c-13.3 0-24-10.7-24-24z", "M368 464l-288 0 0-272c0-79.5 64.5-144 144-144s144 64.5 144 144l0 272zM32 192l0 272-8 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l400 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-8 0 0-272C416 86 330 0 224 0S32 86 32 192zm216-40c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 40-48 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l48 0 0 120c0 13.3 10.7 24 24 24s24-10.7 24-24l0-120 48 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0 0-40z"]],
    "square-a-lock": [576, 512, [], "e44d", ["M80 96c0-8.8 7.2-16 16-16l320 0c8.8 0 16 7.2 16 16l0 52c-55.2 14.2-96 64.3-96 124l0 2.3-58.5-117.1c-4.1-8.1-12.4-13.3-21.5-13.3s-17.4 5.1-21.5 13.3l-88 176c-5.9 11.9-1.1 26.3 10.7 32.2s26.3 1.1 32.2-10.7l9.4-18.7 110.6 0c-3.5 10-5.4 20.7-5.4 31.9l0 64.1-208 0c-8.8 0-16-7.2-16-16L80 96zM222.8 288l33.2-66.3 33.2 66.3-66.3 0z", "M96 80l320 0c8.8 0 16 7.2 16 16l0 52c10.2-2.6 21-4 32-4 5.4 0 10.8 .3 16 1l0-49c0-35.3-28.7-64-64-64L96 32C60.7 32 32 60.7 32 96l0 320c0 35.3 28.7 64 64 64l209.3 0c-.9-5.2-1.3-10.6-1.3-16.1l0-31.9-208 0c-8.8 0-16-7.2-16-16L80 96c0-8.8 7.2-16 16-16zm181.5 77.3c-4.1-8.1-12.4-13.3-21.5-13.3s-17.4 5.1-21.5 13.3l-88 176c-5.9 11.9-1.1 26.3 10.7 32.2s26.3 1.1 32.2-10.7l9.4-18.7 110.6 0c5.4-15.4 14.7-29 26.6-39.6l0-22-58.5-117.1zM256 221.7l33.2 66.3-66.3 0 33.2-66.3zm240 50.4l0 47.9-64 0 0-47.9c0-17.7 14.3-32 32-32s32 14.3 32 32zM352 368l0 96c0 26.5 21.5 48 48 48l128 0c26.5 0 48-21.5 48-48l0-96c0-20.9-13.4-38.7-32-45.3l0-50.6c0-44.2-35.8-80-80-80s-80 35.8-80 80l0 50.6c-18.6 6.6-32 24.4-32 45.3z"]],
    "clover": [512, 512, [], "e139", ["M66 202.8l0 2.8 .2 3.2c.7 7.4 4 14.4 9.3 19.7L86 239 89 242.7c2.6 3.9 4 8.5 4 13.3s-1.4 9.4-4 13.3l-3 3.7-10.5 10.5c-6.1 6.1-9.5 14.3-9.5 22.9l0 2.8 .2 3c1.5 14.9 14.1 26.6 29.5 26.6 7.4 0 14.7-1.9 21.1-5.5l67.8-38.2 3.6-1.7c8.6-3.1 18.5-1.1 25.1 5.6s8.7 16.5 5.6 25.1l-1.7 3.6-38.2 67.8c-3.6 6.4-5.5 13.7-5.5 21.1 0 16.4 13.3 29.6 29.6 29.6l2.8 0c8.6 0 16.9-3.4 22.9-9.5l10.5-10.5 3.7-3c3.9-2.6 8.5-4 13.3-4 6.4 0 12.5 2.5 17 7l10.5 10.5 2.4 2.2c5.8 4.7 13 7.3 20.5 7.3l2.8 0c16.4 0 29.6-13.3 29.6-29.6 0-7.4-1.9-14.7-5.5-21.1l-38.2-67.8c-5.3-9.4-3.7-21.1 3.9-28.8s19.4-9.2 28.8-3.9l67.8 38.2c6.4 3.6 13.7 5.5 21.1 5.5 16.4 0 29.6-13.3 29.6-29.6l0-2.8c0-7.5-2.6-14.8-7.3-20.5l-2.2-2.4-10.5-10.5c-4.5-4.5-7-10.6-7-17s2.5-12.5 7-17l10.5-10.5 2.2-2.4c4.7-5.8 7.3-13 7.3-20.6l0-3c0-16.3-13.2-29.4-29.4-29.4-5.6 0-11.1 1.1-16.2 3.2l-5 2.4-66.3 38c-9.3 5.3-21.1 3.8-28.8-3.7-7.7-7.5-9.4-19.2-4.2-28.7l37.2-67.9 2.3-4.9c2-5.1 3-10.5 3-15.9 0-16.5-13.4-29.9-29.9-29.9l-2.5 0c-7.5 0-14.8 2.6-20.5 7.3l-2.4 2.2-10.5 10.5c-4.5 4.5-10.6 7-17 7s-12.5-2.5-17-7L228.8 75.2c-6.1-6.1-14.3-9.5-22.9-9.5l-2.8 0c-16.4 0-29.6 13.3-29.6 29.6 0 7.4 1.9 14.7 5.5 21.1l38.2 67.8 1.7 3.6c3.1 8.6 1.1 18.5-5.6 25.1-7.6 7.6-19.4 9.2-28.7 3.9l-67.8-38.2c-6.4-3.6-13.7-5.5-21.1-5.5-16.4 0-29.6 13.3-29.6 29.6z", "M205.9 17.7c18.4 0 36.2 6.4 50.4 17.8 14.2-11.5 32-17.8 50.4-17.8l2.5 0c43 0 77.9 34.9 77.9 77.9 0 13.1-2.9 26.1-8.3 38 12-5.6 25.1-8.5 38.3-8.5 42.8 0 77.4 34.7 77.4 77.4l0 3c0 18.4-6.3 36.2-17.8 50.4 11.4 14.2 17.8 32 17.8 50.4l0 2.8c0 42.9-34.8 77.6-77.6 77.6-13.3 0-26.4-3-38.4-8.5 5.6 12 8.5 25.1 8.5 38.4 0 42.9-34.8 77.6-77.6 77.6l-2.8 0c-18.4 0-36.2-6.3-50.4-17.8-14.2 11.4-32 17.8-50.4 17.8l-2.8 0c-42.9 0-77.6-34.8-77.6-77.6 0-13.3 2.9-26.4 8.5-38.4-12 5.6-25.1 8.5-38.4 8.5-40.2 0-73.2-30.5-77.2-69.7l-.4-7.9 0-2.8c0-18.4 6.4-36.2 17.8-50.4-9.8-12.2-15.9-26.9-17.4-42.4l-.4-8 0-2.8c0-42.9 34.8-77.6 77.6-77.6 13.3 0 26.4 3 38.4 8.5-5.6-12-8.5-25.1-8.5-38.4 0-42.9 34.8-77.6 77.6-77.6l2.8 0zm-2.8 48c-16.4 0-29.6 13.3-29.6 29.6 0 7.4 1.9 14.7 5.5 21.1l38.2 67.8 1.7 3.6c3.1 8.6 1.1 18.5-5.6 25.1-7.6 7.6-19.4 9.2-28.7 3.9l-67.8-38.2c-6.4-3.6-13.7-5.5-21.1-5.5-16.4 0-29.6 13.3-29.6 29.6l0 2.8 .2 3.2c.7 7.4 4 14.4 9.3 19.7L86 239 89 242.7c2.6 3.9 4 8.5 4 13.3s-1.4 9.4-4 13.3l-3 3.7-10.5 10.5c-6.1 6.1-9.5 14.3-9.5 22.9l0 2.8 .2 3c1.5 14.9 14.1 26.6 29.5 26.6 7.4 0 14.7-1.9 21.1-5.5l67.8-38.2 3.6-1.7c8.6-3.1 18.5-1.1 25.1 5.6s8.7 16.5 5.6 25.1l-1.7 3.6-38.2 67.8c-3.6 6.4-5.5 13.7-5.5 21.1 0 16.4 13.3 29.6 29.6 29.6l2.8 0c8.6 0 16.9-3.4 22.9-9.5l10.5-10.5 3.7-3c3.9-2.6 8.5-4 13.3-4 6.4 0 12.5 2.5 17 7l10.5 10.5 2.4 2.2c5.8 4.7 13 7.3 20.5 7.3l2.8 0c16.4 0 29.6-13.3 29.6-29.6 0-7.4-1.9-14.7-5.5-21.1l-38.2-67.8c-5.3-9.4-3.7-21.1 3.9-28.8s19.4-9.2 28.8-3.9l67.8 38.2c6.4 3.6 13.7 5.5 21.1 5.5 16.4 0 29.6-13.3 29.6-29.6l0-2.8c0-7.5-2.6-14.8-7.3-20.5l-2.2-2.4-10.5-10.5c-4.5-4.5-7-10.6-7-17s2.5-12.5 7-17l10.5-10.5 2.2-2.4c4.7-5.8 7.3-13 7.3-20.6l0-3c0-16.3-13.2-29.4-29.4-29.4-5.6 0-11.1 1.1-16.2 3.2l-5 2.4-66.3 38c-9.3 5.3-21.1 3.8-28.8-3.7-7.7-7.5-9.4-19.2-4.2-28.7l37.2-67.9 2.3-4.9c2-5.1 3-10.5 3-15.9 0-16.5-13.4-29.9-29.9-29.9l-2.5 0c-7.5 0-14.8 2.6-20.5 7.3l-2.4 2.2-10.5 10.5c-4.5 4.5-10.6 7-17 7s-12.5-2.5-17-7L228.8 75.2c-6.1-6.1-14.3-9.5-22.9-9.5l-2.8 0z"]],
    "signal-bars-fair": [448, 512, ["signal-alt-2"], "f692", ["", "M184 280c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 176c0 13.3 10.7 24 24 24s24-10.7 24-24l0-176zM56 408c0-13.3-10.7-24-24-24S8 394.7 8 408l0 48c0 13.3 10.7 24 24 24s24-10.7 24-24l0-48z"]],
    "folder-heart": [512, 512, [], "e189", ["M48 96l0 288c0 8.8 7.2 16 16 16l384 0c8.8 0 16-7.2 16-16l0-240c0-8.8-7.2-16-16-16l-149.3 0c-17.3 0-34.2-5.6-48-16L212.3 83.2c-2.8-2.1-6.1-3.2-9.6-3.2L64 80c-8.8 0-16 7.2-16 16zM160 240c0-26.5 21.5-48 48-48l2.9 0c13.5 0 26.5 5.4 36 14.9l9.1 9.1 9.1-9.1c9.5-9.5 22.5-14.9 36-14.9l2.9 0c26.5 0 48 21.5 48 48 0 53.4-66.9 95.7-89 108.2-4.4 2.5-9.6 2.5-14 0-22.1-12.5-89-54.8-89-108.2z", "M448 400L64 400c-8.8 0-16-7.2-16-16L48 96c0-8.8 7.2-16 16-16l138.7 0c3.5 0 6.8 1.1 9.6 3.2L250.7 112c13.8 10.4 30.7 16 48 16L448 128c8.8 0 16 7.2 16 16l0 240c0 8.8-7.2 16-16 16zM64 448l384 0c35.3 0 64-28.7 64-64l0-240c0-35.3-28.7-64-64-64L298.7 80c-6.9 0-13.7-2.2-19.2-6.4L241.1 44.8C230 36.5 216.5 32 202.7 32L64 32C28.7 32 0 60.7 0 96L0 384c0 35.3 28.7 64 64 64zM246.9 206.9c-9.5-9.5-22.5-14.9-36-14.9l-2.9 0c-26.5 0-48 21.5-48 48 0 53.4 66.9 95.7 89 108.2 4.4 2.5 9.6 2.5 14 0 22.1-12.5 89-54.8 89-108.2 0-26.5-21.5-48-48-48l-2.9 0c-13.5 0-26.5 5.4-36 14.9l-9.1 9.1-9.1-9.1z"]],
    "cloud-word": [576, 512, [], "e138", ["M48 336c0 53 43 96 96 96l304 0c44.2 0 80-35.8 80-80 0-37.4-25.7-68.9-60.5-77.6-7.5-1.9-13.6-7.2-16.5-14.3s-2.1-15.2 2-21.7c7-11.1 11-24.2 11-38.3 0-39.8-32.2-72-72-72-11.1 0-21.5 2.5-30.8 6.9-10.5 5-23.1 1.7-29.8-7.8-20.3-28.6-53.7-47.1-91.3-47.1-61.9 0-112 50.1-112 112 0 8.4 .9 16.6 2.7 24.5 2.7 12.1-4.3 24.3-16.1 28.1-38.7 12.4-66.6 48.7-66.6 91.4zm112-56c0-13.3 10.7-24 24-24l80 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24zm0 80c0-13.3 10.7-24 24-24l32 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-32 0c-13.3 0-24-10.7-24-24zm128 0c0-13.3 10.7-24 24-24l80 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24zm48-80c0-13.3 10.7-24 24-24l32 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-32 0c-13.3 0-24-10.7-24-24z", "M80 192c0-88.4 71.6-160 160-160 47.1 0 89.4 20.4 118.7 52.7 10.6-3.1 21.8-4.7 33.3-4.7 66.3 0 120 53.7 120 120 0 13.2-2.1 25.9-6.1 37.8 41.6 21.1 70.1 64.3 70.1 114.2 0 70.7-57.3 128-128 128l-304 0c-79.5 0-144-64.5-144-144 0-56.8 32.9-105.9 80.7-129.4-.4-4.8-.7-9.7-.7-14.6zM240 80c-61.9 0-112 50.1-112 112 0 8.4 .9 16.6 2.7 24.5 2.7 12.1-4.3 24.3-16.1 28.1-38.7 12.4-66.6 48.7-66.6 91.4 0 53 43 96 96 96l304 0c44.2 0 80-35.8 80-80 0-37.4-25.7-68.9-60.5-77.6-7.5-1.9-13.6-7.2-16.5-14.3s-2.1-15.2 2-21.7c7-11.1 11-24.2 11-38.3 0-39.8-32.2-72-72-72-11.1 0-21.5 2.5-30.8 6.9-10.5 5-23.1 1.7-29.8-7.8-20.3-28.6-53.7-47.1-91.3-47.1zm0 280c0 13.3-10.7 24-24 24l-32 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l32 0c13.3 0 24 10.7 24 24zM360 256l32 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-32 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zm56 104c0 13.3-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l80 0c13.3 0 24 10.7 24 24zM184 256l80 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"]],
    "screen-users": [640, 512, ["users-class"], "f63d", ["M112 64c0-8.8 7.2-16 16-16l384 0c8.8 0 16 7.2 16 16l0 145.1c-54.3 7.8-96 54.5-96 110.9 0-61.9-50.1-112-112-112S208 258.1 208 320c0-56.4-41.7-103.1-96-110.9L112 64z", "M128 416c35.3 0 64 28.7 64 64 0 17.7-14.3 32-32 32L32 512c-17.7 0-32-14.3-32-32 0-35.3 28.7-64 64-64l64 0zm224 0c35.3 0 64 28.7 64 64 0 17.7-14.3 32-32 32l-128 0c-17.7 0-32-14.3-32-32 0-35.3 28.7-64 64-64l64 0zm224 0c35.3 0 64 28.7 64 64 0 17.7-14.3 32-32 32l-128 0c-17.7 0-32-14.3-32-32 0-35.3 28.7-64 64-64l64 0zM96 384a64 64 0 1 1 0-128 64 64 0 1 1 0 128zm224 0a64 64 0 1 1 0-128 64 64 0 1 1 0 128zm224 0a64 64 0 1 1 0-128 64 64 0 1 1 0 128zM512 0c35.3 0 64 28.7 64 64l0 148.7c-10.1-3-20.9-4.7-32-4.7-5.4 0-10.8 .4-16 1.1L528 64c0-8.8-7.2-16-16-16L128 48c-8.8 0-16 7.2-16 16l0 145.1c-5.2-.7-10.6-1.1-16-1.1-11.1 0-21.9 1.6-32 4.7L64 64C64 28.7 92.7 0 128 0L512 0z"]],
    "teeth-open": [512, 512, [], "f62f", ["", "M64 32C28.7 32 0 60.7 0 96l0 80c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-80c0-35.3-28.7-64-64-64L64 32zm0 272c-35.3 0-64 28.7-64 64l0 48c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-48c0-35.3-28.7-64-64-64L64 304zm80-160c0-26.5 21.5-48 48-48s48 21.5 48 48l0 24c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-24zm128 0c0-26.5 21.5-48 48-48s48 21.5 48 48l0 24c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-24zM80 112c17.7 0 32 14.3 32 32l0 24c0 13.3-10.7 24-24 24l-16 0c-13.3 0-24-10.7-24-24l0-24c0-17.7 14.3-32 32-32zm320 32c0-17.7 14.3-32 32-32s32 14.3 32 32l0 24c0 13.3-10.7 24-24 24l-16 0c-13.3 0-24-10.7-24-24l0-24zM48 384l0-16c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 16c0 17.7-14.3 32-32 32s-32-14.3-32-32zm144 48c-26.5 0-48-21.5-48-48l0-16c0-8.8 7.2-16 16-16l64 0c8.8 0 16 7.2 16 16l0 16c0 26.5-21.5 48-48 48zm128 0c-26.5 0-48-21.5-48-48l0-16c0-8.8 7.2-16 16-16l64 0c8.8 0 16 7.2 16 16l0 16c0 26.5-21.5 48-48 48zm112-16c-17.7 0-32-14.3-32-32l0-16c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 16c0 17.7-14.3 32-32 32z"]],
    "circle-u": [512, 512, [], "e127", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm112-88c0-13.3 10.7-24 24-24s24 10.7 24 24l0 104c0 26.5 21.5 48 48 48s48-21.5 48-48l0-104c0-13.3 10.7-24 24-24s24 10.7 24 24l0 104c0 53-43 96-96 96s-96-43-96-96l0-104z", "M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM208 168c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 104c0 53 43 96 96 96s96-43 96-96l0-104c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 104c0 26.5-21.5 48-48 48s-48-21.5-48-48l0-104z"]],
    "calendar-heart": [448, 512, [], "e0d3", ["M48 128l0 288c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-288c0-8.8-7.2-16-16-16L64 112c-8.8 0-16 7.2-16 16zm64 114.7c0-32.4 26.3-58.7 58.7-58.7 18.5 0 35.9 8.7 46.9 23.5l6.4 8.5 6.4-8.5c11.1-14.8 28.5-23.5 46.9-23.5 32.4 0 58.7 26.3 58.7 58.7l0 5.3c0 49.1-65.8 98.1-96.5 118.3-9.5 6.2-21.5 6.2-30.9 0-30.7-20.2-96.5-69.3-96.5-118.3l0-5.3z", "M120 0c13.3 0 24 10.7 24 24l0 40 160 0 0-40c0-13.3 10.7-24 24-24s24 10.7 24 24l0 40 32 0c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 128C0 92.7 28.7 64 64 64l32 0 0-40c0-13.3 10.7-24 24-24zm0 112l-56 0c-8.8 0-16 7.2-16 16l0 288c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-288c0-8.8-7.2-16-16-16l-264 0zm97.6 95.5l6.4 8.5 6.4-8.5c11.1-14.8 28.5-23.5 46.9-23.5 32.4 0 58.7 26.3 58.7 58.7l0 5.3c0 49.1-65.8 98.1-96.5 118.3-9.5 6.2-21.5 6.2-30.9 0-30.7-20.2-96.5-69.3-96.5-118.3l0-5.3c0-32.4 26.3-58.7 58.7-58.7 18.5 0 35.9 8.7 46.9 23.5z"]],
    "narwhal": [640, 512, [], "f6fe", ["M128.9 395.9C146 435.9 185.7 464 232 464l232 0c70.3 0 128-58.1 128-129.2 0-69.8-56.6-126.8-125.5-126.8-41.4 0-81.3 15.2-112.2 42.7L209.8 379.1c-15.2 13.5-34.7 20.9-55 20.9-9 0-17.7-1.4-25.9-4.1zM520 304a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M639.4 20.5c2.3-7.7-1.6-16-9-19.2s-16-.4-20.1 6.5L516 167.3c-15.7-4.7-32.3-7.3-49.6-7.3-53.1 0-104.4 19.5-144.1 54.8L177.9 343.2c-6.4 5.7-14.6 8.8-23.1 8.8-19.2 0-34.8-15.6-34.8-34.8l0-58.5 37.9-26.5c21.4-15 34.1-39.4 34.1-65.5l0-54.7c0-6-3.3-11.4-8.6-14.2s-11.7-2.3-16.6 1.1L96 148.5 25.2 98.9c-4.9-3.4-11.3-3.8-16.6-1.1S0 106 0 112l0 54.7c0 26.1 12.7 50.6 34.1 65.5L72 258.7 72 352c0 88.4 71.6 160 160 160l232 0c97.2 0 176-80 176-177.2 0-50.1-21.2-95.5-55.1-127.5L639.4 20.5zM232 464c-46.3 0-86-28.1-103.1-68.1 8.1 2.7 16.8 4.1 25.9 4.1 20.3 0 39.8-7.4 55-20.9L354.2 250.7c30.9-27.5 70.9-42.7 112.2-42.7 68.9 0 125.5 57 125.5 126.8 0 71.1-57.7 129.2-128 129.2l-232 0zM496 328a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]],
    "bars-staggered": [512, 512, ["reorder", "stream"], "f550", ["", "M0 88C0 74.7 10.7 64 24 64l400 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 112C10.7 112 0 101.3 0 88zM64 256c0-13.3 10.7-24 24-24l400 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L88 280c-13.3 0-24-10.7-24-24zM448 424c0 13.3-10.7 24-24 24L24 448c-13.3 0-24-10.7-24-24s10.7-24 24-24l400 0c13.3 0 24 10.7 24 24z"]],
    "warehouse": [576, 512, [], "f494", ["M53.2 144c1.4-1.3 3.1-2.4 5-3.1L288 51.5 517.8 140.9c1.9 .7 3.6 1.8 5 3.1L53.2 144z", "M574.9 144c-4-21.5-18.8-39.8-39.7-47.9L305.4 6.8c-11.2-4.4-23.6-4.4-34.8 0L40.8 96.1C19.9 104.2 5.1 122.5 1.1 144 .4 147.8 0 151.8 0 155.8L0 488c0 13.3 10.7 24 24 24s24-10.7 24-24l0-296 480 0 0 296c0 13.3 10.7 24 24 24s24-10.7 24-24l0-332.2c0-4-.4-7.9-1.1-11.8zM53.2 144c1.4-1.3 3.1-2.4 5-3.1L288 51.5 517.8 140.9c1.9 .7 3.6 1.8 5 3.1L53.2 144zM120 256c-13.3 0-24 10.7-24 24s10.7 24 24 24l336 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-336 0zM96 376c0 13.3 10.7 24 24 24l336 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-336 0c-13.3 0-24 10.7-24 24zm24 72c-13.3 0-24 10.7-24 24s10.7 24 24 24l336 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-336 0z"]],
    "swatchbook": [512, 512, [], "f5c3", ["M48 304l128 0 0 96c0 35.3-28.7 64-64 64s-64-28.7-64-64l0-96zm40 96a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm121.9 64c42.7-42.7 85.3-85.3 128-128 34 0 68 0 102.1 0 13.3 0 24 10.7 24 24l0 80c0 13.3-10.7 24-24 24-76.7 0-153.4 0-230.1 0zM224 193.9c34.8-34.8 61.2-61.2 79-79 9.4-9.4 24.6-9.4 33.9 0 20 20 40.1 40.1 60.1 60.1 9.4 9.4 9.4 24.6 0 33.9-57.7 57.7-115.4 115.4-173.1 173.1l0-188.1z", "M0 400c0 61.9 50.1 112 112 112l328 0c39.8 0 72-32.2 72-72l0-80c0-35.4-25.6-64.9-59.3-70.9L405.8 336 440 336c13.3 0 24 10.7 24 24l0 80c0 13.3-10.7 24-24 24L209.9 464 431 242.9c28.1-28.1 28.1-73.7 0-101.8L370.9 81c-27.2-27.2-70.6-28.1-98.9-2.8l0 67.7 31-31c9.4-9.4 24.6-9.4 33.9 0L397.1 175c9.4 9.4 9.4 24.6 0 33.9L224 382.1 224 72c0-39.8-32.2-72-72-72L72 0C32.2 0 0 32.2 0 72L0 400zm112 64c-35.3 0-64-28.7-64-64l0-96 128 0 0 96c0 35.3-28.7 64-64 64zM48 256l0-80 128 0 0 80-128 0zm0-128l0-56c0-13.3 10.7-24 24-24l80 0c13.3 0 24 10.7 24 24l0 56-128 0zm64 296a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]],
    "circle-three-quarters": [512, 512, [], "e125", ["M48 256c0 114.9 93.1 208 208 208 98.3 0 180.8-68.3 202.4-160L272 304c-35.3 0-64-28.7-64-64l0-186.4C116.3 75.2 48 157.7 48 256z", "M208 53.6c-91.7 21.7-160 104.1-160 202.4 0 114.9 93.1 208 208 208 98.3 0 180.8-68.3 202.4-160L272 304c-35.3 0-64-28.7-64-64l0-186.4zM224.1 2C241.6-.2 256 14.3 256 32l0 208c0 8.8 7.2 16 16 16l208 0C497.7 256 512.2 270.4 510 287.9 494.3 414.2 386.6 512 256 512 114.6 512 0 397.4 0 256 0 125.4 97.8 17.7 224.1 2z"]],
    "circle-chf": [512, 512, [], "e72c", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm48-72c0-22.1 17.9-40 40-40s40 17.9 40 40l0 8c0 13.3-10.7 24-24 24-2.8 0-5.5-.5-8-1.4l0 82.7c2.5-.9 5.2-1.4 8-1.4 13.3 0 24 10.7 24 24l0 8c0 22.1-17.9 40-40 40s-40-17.9-40-40l0-144zm96-16c0-13.3 10.7-24 24-24s24 10.7 24 24l0 64 16 0 0-64c0-13.3 10.7-24 24-24s24 10.7 24 24l0 176c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-64-16 0 0 64c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-176zm128 0c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-24 0 0 40 16 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-16 0 0 64c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-176z", "M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM136 144c-22.1 0-40 17.9-40 40l0 144c0 22.1 17.9 40 40 40s40-17.9 40-40l0-8c0-13.3-10.7-24-24-24-2.8 0-5.5 .5-8 1.4l0-82.7c2.5 .9 5.2 1.4 8 1.4 13.3 0 24-10.7 24-24l0-8c0-22.1-17.9-40-40-40zm104 24c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 176c0 13.3 10.7 24 24 24s24-10.7 24-24l0-64 16 0 0 64c0 13.3 10.7 24 24 24s24-10.7 24-24l0-176c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 64-16 0 0-64zm104-24c-13.3 0-24 10.7-24 24l0 176c0 13.3 10.7 24 24 24s24-10.7 24-24l0-64 16 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-16 0 0-40 24 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0z"]],
    "campground": [512, 512, [9978], "f6bb", ["M48 392.7l208-247.4 208 247.4 0 39.3-63.2 0-15.3-16.4-112-120c-4.5-4.9-10.9-7.6-17.5-7.6s-13 2.8-17.5 7.6l-112 120-15.3 16.4-63.2 0 0-39.3z", "M335.4 13.6c10.1 8.5 11.5 23.7 2.9 33.8l-51 60.7 213.4 253.7c7.3 8.7 11.3 19.6 11.3 30.9l0 47.3c0 22.1-17.9 40-40 40L40 480c-22.1 0-40-17.9-40-40l0-47.3c0-11.3 4-22.2 11.3-30.9l213.4-253.7-51-60.7c-8.5-10.1-7.2-25.3 2.9-33.8s25.3-7.2 33.8 2.9L256 70.8 301.6 16.6c8.5-10.1 23.7-11.5 33.8-2.9zM48 392.7l0 39.3 63.2 0 15.3-16.4 112-120c4.5-4.9 10.9-7.6 17.5-7.6s13 2.8 17.5 7.6l112 120 15.3 16.4 63.2 0 0-39.3-208-247.4-208 247.4zM176.8 432l158.3 0-79.2-84.8-79.2 84.8z"]],
    "person-walking-arrow-right": [576, 512, [], "e552", ["M128.5 162.2c6-1.4 12.2-2.2 18.4-2.2 7.4 0 14.6 1 21.6 3l0 154.8-22.2-14.8c-11.1-7.4-17.8-19.9-17.8-33.3l0-107.6z", "M104.5 24a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm24 138.2l0 107.6c0 13.4 6.7 25.9 17.8 33.3l22.2 14.8 0-154.8c-7-2-14.2-3-21.6-3-6.3 0-12.4 .7-18.4 2.2zm-48 31.7L60.2 214.2c-7.5 7.5-11.7 17.7-11.7 28.3l0 53.5c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-53.5c0-23.3 9.3-45.7 25.8-62.2L57.5 149c23.7-23.7 55.8-37 89.4-37 35.8 0 70 15.2 93.9 41.8l22.4 24.9c7.6 8.4 18.4 13.2 29.7 13.2l35.5 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L293 240c-24.9 0-48.7-10.6-65.4-29.1l-11.1-12.3 0 151.3 21.2 14.1c21.1 14 35.1 36.5 38.4 61.6l12.2 91.3c1.8 13.1-7.5 25.2-20.6 27s-25.2-7.5-27-20.6l-12.2-91.3c-1.5-11.4-7.9-21.6-17.5-28L119.7 343c-24.5-16.3-39.2-43.8-39.2-73.2l0-75.8zm19.7 193.7l41.9 28-2 7c-4.1 14.4-11.8 27.5-22.4 38L41.5 537c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l76.3-76.3c4.8-4.8 8.3-10.8 10.2-17.3l6.2-21.8zM505.5 345c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l31-31-102.1 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l102.1 0-31-31c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l72 72c9.4 9.4 9.4 24.6 0 33.9l-72 72z"]],
    "spider-black-widow": [512, 512, [], "f718", ["M192 312l0 24c0 35.3 28.7 64 64 64l6.5-.3c32.3-3.3 57.5-30.5 57.5-63.7l0-24c0-18.9-8.2-35.9-21.4-47.7l-5.9-4.7c-9.6-6.7-12.9-19.4-7.8-29.9l1.3-3.3c1.2-3.3 1.8-6.8 1.8-10.4l0-40-.2-3.3c-1.5-15-13.5-27-28.6-28.6L256 144c-17.7 0-32 14.3-32 32l0 40c0 4.9 1.1 9.5 3.1 13.7 5 10.6 1.7 23.2-7.9 29.9-16.5 11.6-27.2 30.8-27.2 52.4zm24-18c0-3.3 2.7-6 6-6l68 0c3.3 0 6 2.7 6 6 0 1.3-.4 2.6-1.2 3.6L272 328 294.8 358.4c.8 1 1.2 2.3 1.2 3.6 0 3.3-2.7 6-6 6l-68 0c-3.3 0-6-2.7-6-6 0-1.3 .4-2.6 1.2-3.6L240 328 217.2 297.6c-.8-1-1.2-2.3-1.2-3.6z", "M142.8-31c11.9 3.5 19 15.5 16.8 27.4l-.6 2.4-36 122.3 53 53c1-43.3 36.4-78.2 79.9-78.2l8.2 .4c39.7 4 70.8 37.2 71.7 77.8l53.1-53-36-122.3-.6-2.4c-2.2-12 4.9-23.9 16.8-27.4s24.4 2.7 29 13.9l.8 2.3 40 136c2.5 8.4 .1 17.5-6.1 23.7l-64.1 64.1 76.4-20.8 19.9-59.8 .9-2.3c5-11.1 17.7-16.8 29.5-12.9 11.8 3.9 18.5 16.1 15.8 28l-.7 2.4-24 72-1.1 2.8c-3 6.2-8.6 11-15.3 12.8l-91.1 24.8 91.1 24.8c6.8 1.9 12.4 6.6 15.3 12.8l1.1 2.7 24 72 .7 2.4c2.6 11.9-4.1 24.1-15.8 28s-24.5-1.8-29.5-12.9l-.9-2.3-19.9-59.8-76.4-20.8 64.1 64.1c6.2 6.2 8.5 15.3 6.1 23.7l-40 136-.8 2.3c-4.6 11.3-17.1 17.4-29 13.9-11.9-3.5-19-15.5-16.8-27.4l.6-2.4 36-122.3-25.1-25.1c-12.6 45.6-53.2 79.5-102.1 82L256 448c-51.5 0-94.9-34.8-107.9-82.1l-25 25.1 36 122.3 .6 2.4c2.2 11.9-4.9 23.9-16.8 27.4-11.9 3.5-24.4-2.7-29-13.9l-.8-2.3-40-136c-2.5-8.4-.1-17.5 6.1-23.7l64.1-64.1-76.4 20.8-19.9 59.8-.9 2.3c-5 11.1-17.7 16.8-29.5 12.9S-2 382.7 .6 370.8l.7-2.4 24-72 1.1-2.7c3-6.3 8.6-11 15.3-12.8l91.1-24.8-91.1-24.8c-6.8-1.8-12.4-6.6-15.3-12.8l-1.1-2.8-24-72-.7-2.4c-2.7-11.9 4.1-24.1 15.8-28s24.5 1.8 29.5 12.9l.9 2.3 19.9 59.8 76.4 20.8-64.1-64.1c-6.2-6.2-8.5-15.3-6.1-23.7l40-136 .8-2.3c4.6-11.3 17.1-17.4 29-13.9zM256 144c-17.7 0-32 14.3-32 32l0 40c0 4.9 1.1 9.5 3.1 13.7 5 10.6 1.7 23.2-7.9 29.9-16.5 11.6-27.2 30.8-27.2 52.4l0 24c0 35.3 28.7 64 64 64l6.5-.3c32.3-3.3 57.5-30.5 57.5-63.7l0-24c0-18.9-8.2-35.9-21.4-47.7l-5.9-4.7c-9.6-6.7-12.9-19.4-7.8-29.9l1.3-3.3c1.2-3.3 1.8-6.8 1.8-10.4l0-40-.2-3.3c-1.5-15-13.5-27-28.6-28.6L256 144zm34 144c3.3 0 6 2.7 6 6 0 1.3-.4 2.6-1.2 3.6L272 328 294.8 358.4c.8 1 1.2 2.3 1.2 3.6 0 3.3-2.7 6-6 6l-68 0c-3.3 0-6-2.7-6-6 0-1.3 .4-2.6 1.2-3.6L240 328 217.2 297.6c-.8-1-1.2-2.3-1.2-3.6 0-3.3 2.7-6 6-6l68 0z"]],
    "glasses": [576, 512, [], "f530", ["M48 304l160 0 0 80c0 26.5-21.5 48-48 48l-64 0c-26.5 0-48-21.5-48-48l0-80zm320 0l160 0 0 80c0 26.5-21.5 48-48 48l-64 0c-26.5 0-48-21.5-48-48l0-80z", "M135.8 80c-17.7 0-33.3 11.7-38.4 28.6L53.8 256 224 256c17.7 0 32 14.3 32 32l64 0c0-17.7 14.3-32 32-32l170.2 0-43.7-147.4c-5-17-20.6-28.6-38.4-28.6L408 80c-13.3 0-24-10.7-24-24s10.7-24 24-24l32.2 0c39 0 73.3 25.6 84.4 63l47.8 161.3c2.4 8.1 3.6 16.5 3.6 25L576 384c0 53-43 96-96 96l-64 0c-53 0-96-43-96-96l0-48-64 0 0 48c0 53-43 96-96 96l-64 0c-53 0-96-43-96-96L0 281.3c0-8.5 1.2-16.9 3.6-25L51.4 95c11.1-37.4 45.4-63 84.4-63L168 32c13.3 0 24 10.7 24 24s-10.7 24-24 24l-32.2 0zM528 304l-160 0 0 80c0 26.5 21.5 48 48 48l64 0c26.5 0 48-21.5 48-48l0-80zM48 304l0 80c0 26.5 21.5 48 48 48l64 0c26.5 0 48-21.5 48-48l0-80-160 0z"]],
    "circle-pause": [512, 512, [62092, "pause-circle"], "f28b", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm128-72c0-13.3 10.7-24 24-24s24 10.7 24 24l0 144c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-144zm112 0c0-13.3 10.7-24 24-24s24 10.7 24 24l0 144c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-144z", "M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM224 184c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 144c0 13.3 10.7 24 24 24s24-10.7 24-24l0-144zm112 0c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 144c0 13.3 10.7 24 24 24s24-10.7 24-24l0-144z"]],
    "memory": [512, 512, [], "f538", ["M48 120l0 14.2c24.1 15.7 40 42.8 40 73.8s-15.9 58.1-40 73.8l0 22.2 416 0 0-22.2c-24.1-15.7-40-42.8-40-73.8s15.9-58.1 40-73.8l0-14.2c0-4.4-3.6-8-8-8L56 112c-4.4 0-8 3.6-8 8zm0 232l0 48 40 0c0-13.3 10.7-24 24-24s24 10.7 24 24l48 0c0-13.3 10.7-24 24-24s24 10.7 24 24l48 0c0-13.3 10.7-24 24-24s24 10.7 24 24l48 0c0-13.3 10.7-24 24-24s24 10.7 24 24l40 0 0-48-416 0zm80-184c0-13.3 10.7-24 24-24s24 10.7 24 24l0 80c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-80zm104 0c0-13.3 10.7-24 24-24s24 10.7 24 24l0 80c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-80zm104 0c0-13.3 10.7-24 24-24s24 10.7 24 24l0 80c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-80z", "M0 120C0 89.1 25.1 64 56 64l400 0c30.9 0 56 25.1 56 56l0 28.7c0 9.8-5.9 18.6-15 22.2-14.7 6-25 20.4-25 37.1s10.3 31.1 25 37.1c9.1 3.7 15 12.5 15 22.2L512 416c0 17.7-14.3 32-32 32L32 448c-17.7 0-32-14.3-32-32L0 267.3c0-9.8 5.9-18.6 15-22.2 14.7-6 25-20.4 25-37.1s-10.3-31.1-25-37.1c-9.1-3.7-15-12.5-15-22.2L0 120zm56-8c-4.4 0-8 3.6-8 8l0 14.2c24.1 15.7 40 42.8 40 73.8s-15.9 58.1-40 73.8l0 22.2 416 0 0-22.2c-24.1-15.7-40-42.8-40-73.8s15.9-58.1 40-73.8l0-14.2c0-4.4-3.6-8-8-8L56 112zM48 400l40 0c0-13.3 10.7-24 24-24s24 10.7 24 24l48 0c0-13.3 10.7-24 24-24s24 10.7 24 24l48 0c0-13.3 10.7-24 24-24s24 10.7 24 24l48 0c0-13.3 10.7-24 24-24s24 10.7 24 24l40 0 0-48-416 0 0 48zM176 168l0 80c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-80c0-13.3 10.7-24 24-24s24 10.7 24 24zm104 0l0 80c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-80c0-13.3 10.7-24 24-24s24 10.7 24 24zm104 0l0 80c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-80c0-13.3 10.7-24 24-24s24 10.7 24 24z"]],
    "gift": [512, 512, [127873], "f06b", ["M80 224l152 0 0 208-136 0c-8.8 0-16-7.2-16-16l0-192zm200 0l152 0 0 192c0 8.8-7.2 16-16 16l-136 0 0-208z", "M321.5 68.8C329.1 55.9 342.9 48 357.8 48l2.2 0c22.1 0 40 17.9 40 40s-17.9 40-40 40l-73.3 0 34.8-59.2zm-131 0l34.8 59.2-73.3 0c-22.1 0-40-17.9-40-40s17.9-40 40-40l2.2 0c14.9 0 28.8 7.9 36.3 20.8zm89.6-24.3l-24.1 41-24.1-41C215.7 16.9 186.1 0 154.2 0L152 0c-48.6 0-88 39.4-88 88 0 14.4 3.5 28 9.6 40L32 128c-17.7 0-32 14.3-32 32l0 32c0 17.7 14.3 32 32 32l0 192c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-192c17.7 0 32-14.3 32-32l0-32c0-17.7-14.3-32-32-32l-41.6 0c6.1-12 9.6-25.6 9.6-40 0-48.6-39.4-88-88-88l-2.2 0c-31.9 0-61.5 16.9-77.7 44.4zM80 224l152 0 0 208-136 0c-8.8 0-16-7.2-16-16l0-192zm200 0l152 0 0 192c0 8.8-7.2 16-16 16l-136 0 0-208z"]],
    "sprinkler-ceiling": [384, 512, [], "e44c", ["", "M0 0L0 96c0 11.5 8.2 21.4 19.5 23.6L128 140.2 128 91.4 48 76.1 48 0 0 0zM256 91.4l0 48.9 108.5-20.7C375.8 117.4 384 107.5 384 96l0-96-48 0 0 76.1-80 15.2zM160 344a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm-48 64c0-13.3-10.7-24-24-24s-24 10.7-24 24 10.7 24 24 24 24-10.7 24-24zM24 496c13.3 0 24-10.7 24-24s-10.7-24-24-24-24 10.7-24 24 10.7 24 24 24zM272 344a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm-80 88c13.3 0 24-10.7 24-24s-10.7-24-24-24-24 10.7-24 24 10.7 24 24 24zm-32 40c0-13.3-10.7-24-24-24s-24 10.7-24 24 10.7 24 24 24 24-10.7 24-24zm136-40c13.3 0 24-10.7 24-24s-10.7-24-24-24-24 10.7-24 24 10.7 24 24 24zm-24 40c0-13.3-10.7-24-24-24s-24 10.7-24 24 10.7 24 24 24 24-10.7 24-24zm88 24c13.3 0 24-10.7 24-24s-10.7-24-24-24-24 10.7-24 24 10.7 24 24 24zM216 56c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 152-80 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l208 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0 0-152z"]],
    "square-phone-hangup": [448, 512, ["phone-square-down"], "e27a", ["M48 96l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16zM81.7 308.6c-16.6-29.1-14-70.7 18.7-92 75-48.8 172.3-48.8 247.3 0 32.7 21.3 35.3 62.9 18.7 92l-1.4 2.5c-5.1 8.9-15.9 12.6-25.3 8.7l-48.7-20.1c-8.3-3.4-13.3-11.9-12.5-20.8l1.7-17.5c-36.1-13.3-75.9-14-112.4-1.9l1.9 19.4c.9 8.9-4.2 17.4-12.5 20.8l-48.7 20.1c-9.4 3.9-20.3 .2-25.3-8.7l-1.4-2.5z", "M64 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM364.9 311.1c-5.1 8.9-15.9 12.6-25.3 8.7l-48.7-20.1c-8.3-3.4-13.3-11.9-12.5-20.8l1.7-17.5c-36.1-13.3-75.9-14-112.4-1.9l1.9 19.4c.9 8.9-4.2 17.4-12.5 20.8l-48.7 20.1c-9.4 3.9-20.3 .2-25.3-8.7l-1.4-2.5c-16.6-29.1-14-70.7 18.7-92 75-48.8 172.3-48.8 247.3 0 32.7 21.3 35.3 62.9 18.7 92l-1.4 2.5z"]],
    "money-bill-wheat": [512, 512, [], "e52a", ["M48 359.5c28.9-3.6 51.9-26.6 55.5-55.5l305 0c3.6 29 26.6 51.9 55.5 55.5l0 49c-29 3.6-51.9 26.6-55.5 55.5l-305 0c-3.6-29-26.6-51.9-55.5-55.5l0-49zM192 384a64 64 0 1 0 128 0 64 64 0 1 0 -128 0z", "M176-16c-8.8 0-16 7.2-16 16 0 44.2 35.8 80 80 80 8.8 0 16-7.2 16-16 0-44.2-35.8-80-80-80zM56 0C42.7 0 32 10.7 32 24S42.7 48 56 48l48 0c13.3 0 24-10.7 24-24S117.3 0 104 0L56 0zM24 72C10.7 72 0 82.7 0 96s10.7 24 24 24l112 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L24 72zm8 96c0 13.3 10.7 24 24 24l48 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0c-13.3 0-24 10.7-24 24zM272 0c0 44.2 35.8 80 80 80 8.8 0 16-7.2 16-16 0-44.2-35.8-80-80-80-8.8 0-16 7.2-16 16zM400-16c-8.8 0-16 7.2-16 16 0 44.2 35.8 80 80 80 8.8 0 16-7.2 16-16 0-44.2-35.8-80-80-80zm80 144c0-8.8-7.2-16-16-16-44.2 0-80 35.8-80 80 0 8.8 7.2 16 16 16 44.2 0 80-35.8 80-80zM352 112c-44.2 0-80 35.8-80 80 0 8.8 7.2 16 16 16 44.2 0 80-35.8 80-80 0-8.8-7.2-16-16-16zm-96 16c0-8.8-7.2-16-16-16-44.2 0-80 35.8-80 80 0 8.8 7.2 16 16 16 44.2 0 80-35.8 80-80zM48 359.5c28.9-3.6 51.9-26.6 55.5-55.5l305 0c3.6 29 26.6 51.9 55.5 55.5l0 49c-29 3.6-51.9 26.6-55.5 55.5l-305 0c-3.6-29-26.6-51.9-55.5-55.5l0-49zM48 256c-26.5 0-48 21.5-48 48L0 464c0 26.5 21.5 48 48 48l416 0c26.5 0 48-21.5 48-48l0-160c0-26.5-21.5-48-48-48L48 256zM256 448a64 64 0 1 0 0-128 64 64 0 1 0 0 128z"]],
    "circle-florin": [512, 512, [], "e6e4", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm88 112c0-13.3 10.7-24 24-24l23.9 0c5 0 9.6-3 11.6-7.6l27.6-64.4-39 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l59.6 0 28.8-67.3c9.5-22.3 31.4-36.7 55.7-36.7l23.9 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-23.9 0c-5 0-9.6 3-11.6 7.6L295.8 224 328 224c13.3 0 24 10.7 24 24s-10.7 24-24 24l-52.7 0-35.7 83.3C230 377.6 208.1 392 183.9 392L160 392c-13.3 0-24-10.7-24-24z", "M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm16.4-355.3L243.6 224 184 224c-13.3 0-24 10.7-24 24s10.7 24 24 24l39 0-27.6 64.4c-2 4.6-6.5 7.6-11.6 7.6L160 344c-13.3 0-24 10.7-24 24s10.7 24 24 24l23.9 0c24.2 0 46.1-14.4 55.7-36.7l35.7-83.3 52.7 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-32.2 0 20.7-48.4c2-4.6 6.5-7.6 11.6-7.6l23.9 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-23.9 0c-24.2 0-46.1 14.4-55.7 36.7z"]],
    "dungeon": [512, 512, [], "f6d9", ["M48 256l0 64 48 0 0-64c0-5.8 .3-11.5 .9-17.1L50.5 223.5C48.9 234.1 48 244.9 48 256zm0 112l0 88c0 4.4 3.6 8 8 8l32 0c4.4 0 8-3.6 8-8l0-88-48 0zM63.5 177.2l45.7 15.2c13.9-32 37.8-58.5 67.9-75.6l-26.7-40c-38.9 23-69.6 58.2-86.9 100.4zM194.9 57.1l28.2 42.3C233.7 97.2 244.7 96 256 96s22.3 1.2 32.9 3.4l28.2-42.3C297.8 51.2 277.3 48 256 48s-41.8 3.2-61.1 9.1zM335 116.8c30.1 17.1 54 43.6 67.9 75.6l45.7-15.2c-17.3-42.2-48-77.4-86.9-100.4l-26.7 40zm80.1 122.1c.6 5.6 .9 11.3 .9 17.1l0 64 48 0 0-64c0-11.1-.9-21.9-2.5-32.5l-46.4 15.5zM416 368l0 88c0 4.4 3.6 8 8 8l32 0c4.4 0 8-3.6 8-8l0-88-48 0z", "M223.1 99.4L194.9 57.1C214.2 51.2 234.7 48 256 48s41.8 3.2 61.1 9.1L288.9 99.4C278.3 97.2 267.3 96 256 96s-22.3 1.2-32.9 3.4zm-19.3 57.5l.3 .4 3.4-2.3C222.1 148 238.6 144 256 144s33.9 4 48.6 11.1l3.4 2.3 .3-.4C343.8 175.7 368 213 368 256l0 200c0 30.9 25.1 56 56 56l32 0c30.9 0 56-25.1 56-56l0-200C512 114.6 397.4 0 256 0S0 114.6 0 256L0 456c0 30.9 25.1 56 56 56l32 0c30.9 0 56-25.1 56-56l0-200c0-43 24.2-80.3 59.8-99.1zM177 116.8c-30.1 17.1-54 43.6-67.9 75.6L63.5 177.2c17.3-42.2 48-77.4 86.9-100.4l26.7 40zM96.9 238.9c-.6 5.6-.9 11.3-.9 17.1l0 64-48 0 0-64c0-11.1 .9-21.9 2.5-32.5l46.4 15.5zM96 368l0 88c0 4.4-3.6 8-8 8l-32 0c-4.4 0-8-3.6-8-8l0-88 48 0zm320 0l48 0 0 88c0 4.4-3.6 8-8 8l-32 0c-4.4 0-8-3.6-8-8l0-88zm48-48l-48 0 0-64c0-5.8-.3-11.5-.9-17.1l46.4-15.5c1.7 10.6 2.5 21.5 2.5 32.5l0 64zM402.9 192.4c-13.9-32-37.8-58.5-67.9-75.6l26.7-40c38.9 23 69.6 58.2 86.9 100.4l-45.7 15.2zM216 192c-13.3 0-24 10.7-24 24l0 272c0 13.3 10.7 24 24 24s24-10.7 24-24l0-272c0-13.3-10.7-24-24-24zm80 0c-13.3 0-24 10.7-24 24l0 272c0 13.3 10.7 24 24 24s24-10.7 24-24l0-272c0-13.3-10.7-24-24-24z"]],
    "comet": [512, 512, [], "e003", ["M48 307.5c0 86.1 69.8 156.5 155.6 156.5 50.2 0 97.4-24.3 126.6-65.2l116.4-163-33.5 2.6c-8.4 .6-16.5-3.2-21.4-10.1s-5.8-15.8-2.4-23.5l64.5-146.6-147 64.7c-7.7 3.4-16.6 2.5-23.5-2.4s-10.7-13-10.1-21.4l3-40.6-164.8 122.4C71.6 210.6 48 257.8 48 307.5zm53.5-30.1c1.9-5.8 6.9-10 12.9-10.9l54.8-8 24.5-49.6c2.7-5.5 8.3-8.9 14.3-8.9s11.7 3.5 14.3 8.9l24.5 49.6 54.8 8c6 .9 11 5.1 12.9 10.9s.3 12.2-4 16.4l-39.6 38.6 9.4 54.5c1 6-1.4 12.1-6.4 15.7s-11.5 4.1-16.8 1.2l-49-25.8-49 25.8c-5.4 2.8-11.9 2.4-16.8-1.2s-7.4-9.6-6.4-15.7l9.4-54.5-39.6-38.6c-4.4-4.3-5.9-10.6-4-16.4z", "M459.8 3.2c4.7-2.1 9.8-3.2 15-3.2 20.6 0 37.2 16.7 37.2 37.2 0 5.2-1.1 10.3-3.2 15l-59.5 135.3 10.7-.8c33.9-2.6 55.4 35.5 35.6 63.1L369.2 426.7C331 480.2 269.3 512 203.6 512 91 512 0 419.8 0 307.5 0 242.7 30.6 181.2 82.7 142.5L261.6 9.6c27.5-20.4 66.3 .9 63.7 35.1L324 62.9 459.8 3.2zm-6 55.1l-147 64.7c-7.7 3.4-16.6 2.5-23.5-2.4s-10.7-13-10.1-21.4l3-40.6-164.8 122.4C71.6 210.6 48 257.8 48 307.5 48 393.6 117.8 464 203.6 464 253.8 464 301 439.7 330.2 398.8l116.4-163-33.5 2.6c-8.4 .6-16.5-3.2-21.4-10.1s-5.8-15.8-2.4-23.5L453.8 58.3zM208 200c6.1 0 11.7 3.5 14.3 8.9l24.5 49.6 54.8 8c6 .9 11 5.1 12.9 10.9s.3 12.2-4 16.4l-39.6 38.6 9.4 54.5c1 6-1.4 12.1-6.4 15.7s-11.5 4.1-16.8 1.2l-49-25.8-49 25.8c-5.4 2.8-11.9 2.4-16.8-1.2s-7.4-9.6-6.4-15.7l9.4-54.5-39.6-38.6c-4.4-4.3-5.9-10.6-4-16.4s6.9-10 12.9-10.9l54.8-8 24.5-49.6c2.7-5.5 8.3-8.9 14.3-8.9z"]],
    "face-holding-back-tears": [512, 512, [129401], "e482", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm28.2-77.5c-1.4-11 6.4-21 17.4-22.3l11.5-1.4c23.9-3 43.6-19.9 50.2-43.1l1.5-5.2c3-10.6 14.1-16.8 24.7-13.7s16.8 14.1 13.7 24.7l-1.5 5.2c-4.1 14.5-11.4 27.5-20.9 38.4 38.1 6.2 67.1 39.2 67.1 79l0 64c0 8.8-7.2 16-16 16s-16-7.2-16-16c-13.4 10-30 16-48 16-11.4 0-22.2-2.4-32-6.7l0 6.7c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-32c-10-13.4-16-30-16-48 0-16.3 4.9-31.5 13.3-44.2-8.8-1.2-16-8.1-17.1-17.3zm90.5 218.1c-9.2-9.6-8.9-24.8 .7-33.9s24.8-8.9 33.9 .7C211.7 374.2 229.8 386 256 386s44.3-11.8 54.7-22.6c9.2-9.6 24.4-9.9 33.9-.7s9.9 24.4 .7 33.9C327.9 414.8 297.9 434 256 434s-71.9-19.2-89.3-37.4zM272 240c0-39.8 29.1-72.8 67.1-79-9.5-10.9-16.8-23.9-20.9-38.4l-1.5-5.2c-3-10.6 3.1-21.7 13.7-24.7s21.7 3.1 24.7 13.7l1.5 5.2c6.6 23.1 26.4 40.1 50.2 43.1l11.5 1.4c11 1.4 18.7 11.4 17.4 22.3-1.1 9.2-8.4 16.1-17.1 17.3 8.4 12.7 13.3 27.8 13.3 44.2 0 18-6 34.6-16 48l0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-6.7c-9.8 4.3-20.6 6.7-32 6.7-44.2 0-80-35.8-80-80z", "M464 256a208 208 0 1 0 -416 0 208 208 0 1 0 416 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm208-16a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zm32 32l0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16c-13.4 10-30 16-48 16-11.4 0-22.2-2.4-32-6.7l0 6.7c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-32c-10-13.4-16-30-16-48 0-16.3 4.9-31.5 13.3-44.2-8.8-1.2-16-8.1-17.1-17.3-1.4-11 6.4-21 17.4-22.3l11.5-1.4c23.9-3 43.6-19.9 50.2-43.1l1.5-5.2c3-10.6 14.1-16.8 24.7-13.7s16.8 14.1 13.7 24.7l-1.5 5.2c-4.1 14.5-11.4 27.5-20.9 38.4 38.1 6.2 67.1 39.2 67.1 79l0 32zm112 16a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm64 0l0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-6.7c-9.8 4.3-20.6 6.7-32 6.7-44.2 0-80-35.8-80-80 0-39.8 29.1-72.8 67.1-79-9.5-10.9-16.8-23.9-20.9-38.4l-1.5-5.2c-3-10.6 3.1-21.7 13.7-24.7s21.7 3.1 24.7 13.7l1.5 5.2c6.6 23.1 26.4 40.1 50.2 43.1l11.5 1.4c11 1.4 18.7 11.4 17.4 22.3-1.1 9.2-8.4 16.1-17.1 17.3 8.4 12.7 13.3 27.8 13.3 44.2 0 18-6 34.6-16 48zM310.7 363.4c9.2-9.6 24.4-9.9 33.9-.7s9.9 24.4 .7 33.9C327.9 414.8 297.9 434 256 434s-71.9-19.2-89.3-37.4c-9.2-9.6-8.9-24.8 .7-33.9s24.8-8.9 33.9 .7C211.7 374.2 229.8 386 256 386s44.3-11.8 54.7-22.6zM128 240c17.7 0 32-14.3 32-32 17.7 0 32 14.3 32 32s-14.3 32-32 32-32-14.3-32-32zm224-32c17.7 0 32 14.3 32 32s-14.3 32-32 32-32-14.3-32-32c17.7 0 32-14.3 32-32z"]],
    "card-heart": [384, 512, [], "e3eb", ["M48 64l0 384c0 8.8 7.2 16 16 16l256 0c8.8 0 16-7.2 16-16l0-384c0-8.8-7.2-16-16-16L64 48c-8.8 0-16 7.2-16 16zM80 218.7c0-32.4 26.3-58.7 58.7-58.7 18.5 0 35.9 8.7 46.9 23.5l6.4 8.5 6.4-8.5c11.1-14.8 28.5-23.5 46.9-23.5 32.4 0 58.7 26.3 58.7 58.7l0 5.3c0 49.1-65.8 98.1-96.5 118.3-9.5 6.2-21.5 6.2-30.9 0-30.7-20.2-96.5-69.3-96.5-118.3l0-5.3z", "M64 48c-8.8 0-16 7.2-16 16l0 384c0 8.8 7.2 16 16 16l256 0c8.8 0 16-7.2 16-16l0-384c0-8.8-7.2-16-16-16L64 48zM0 64C0 28.7 28.7 0 64 0L320 0c35.3 0 64 28.7 64 64l0 384c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zM185.6 183.5l6.4 8.5 6.4-8.5c11.1-14.8 28.5-23.5 46.9-23.5 32.4 0 58.7 26.3 58.7 58.7l0 5.3c0 49.1-65.8 98.1-96.5 118.3-9.5 6.2-21.5 6.2-30.9 0-30.7-20.2-96.5-69.3-96.5-118.3l0-5.3c0-32.4 26.3-58.7 58.7-58.7 18.5 0 35.9 8.7 46.9 23.5z"]],
    "car-mirrors": [576, 512, [], "e343", ["M80 256l0 112 416 0 0-112c0-8.8-7.2-16-16-16L96 240c-8.8 0-16 7.2-16 16zm96 48a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm288 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M195.9 80c-20.7 0-39 13.2-45.5 32.8L124 192 452 192 425.6 112.8C419.1 93.2 400.8 80 380.1 80L195.9 80zM34 240l-10 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l49.4 0 31.5-94.4C117.9 58.4 154.6 32 195.9 32l184.2 0c41.3 0 78 26.4 91.1 65.6l31.5 94.4 49.4 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-10 0c1.3 5.1 2 10.5 2 16l0 200c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-40-416 0 0 40c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-200c0-5.5 .7-10.9 2-16zm62 0c-8.8 0-16 7.2-16 16l0 112 416 0 0-112c0-8.8-7.2-16-16-16L96 240zm16 64a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm320-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]],
    "suitcase-medical": [512, 512, ["medkit"], "f0fa", ["M48 160l0 256c0 8.8 7.2 16 16 16l32 0 0-288-32 0c-8.8 0-16 7.2-16 16zm96-16l0 288 224 0 0-288-224 0zm32 132c0-8.8 7.2-16 16-16l36 0 0-36c0-8.8 7.2-16 16-16l24 0c8.8 0 16 7.2 16 16l0 36 36 0c8.8 0 16 7.2 16 16l0 24c0 8.8-7.2 16-16 16l-36 0 0 36c0 8.8-7.2 16-16 16l-24 0c-8.8 0-16-7.2-16-16l0-36-36 0c-8.8 0-16-7.2-16-16l0-24zM416 144l0 288 32 0c8.8 0 16-7.2 16-16l0-256c0-8.8-7.2-16-16-16l-32 0z", "M192 56l0 40 128 0 0-40c0-4.4-3.6-8-8-8L200 48c-4.4 0-8 3.6-8 8zM144 96l0-40c0-30.9 25.1-56 56-56L312 0c30.9 0 56 25.1 56 56l0 40 80 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 160c0-35.3 28.7-64 64-64l80 0zm200 48l-200 0 0 288 224 0 0-288-24 0zm72 0l0 288 32 0c8.8 0 16-7.2 16-16l0-256c0-8.8-7.2-16-16-16l-32 0zM96 432l0-288-32 0c-8.8 0-16 7.2-16 16l0 256c0 8.8 7.2 16 16 16l32 0zM244 208l24 0c8.8 0 16 7.2 16 16l0 36 36 0c8.8 0 16 7.2 16 16l0 24c0 8.8-7.2 16-16 16l-36 0 0 36c0 8.8-7.2 16-16 16l-24 0c-8.8 0-16-7.2-16-16l0-36-36 0c-8.8 0-16-7.2-16-16l0-24c0-8.8 7.2-16 16-16l36 0 0-36c0-8.8 7.2-16 16-16z"]],
    "block-quote": [448, 512, [], "e0b5", ["", "M24 64C10.7 64 0 74.7 0 88s10.7 24 24 24l400 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L24 64zM152 232c-13.3 0-24 10.7-24 24s10.7 24 24 24l272 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-272 0zM128 424c0 13.3 10.7 24 24 24l272 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-272 0c-13.3 0-24 10.7-24 24zM0 424c0 13.3 10.7 24 24 24s24-10.7 24-24l0-176c0-13.3-10.7-24-24-24S0 234.7 0 248L0 424z"]],
    "hands-holding-heart": [640, 512, ["hands-heart"], "f4c3", ["M48 136l0 216.2c0 19.1 7.6 37.4 21.1 50.9L137 471c9.4 9.4 9.4 24.6 0 33.9-4.7 4.7-10.8 7-17 7 66.7 0 133.3 0 200 0-13.3 0-24-10.7-24-24l0-51.2c0-27.4-10.9-53.8-30.3-73.2l-61.4-61.4c-4-4-9.4-6.2-15-6.2-11.7 0-21.3 9.5-21.3 21.3 0 5.6 2.2 11 6.2 15 19.6 19.6 33.9 33.9 42.7 42.7 9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0c-22.2-22.2-57.9-57.9-58.7-58.7-18.1-18.1-28.3-42.7-28.3-68.4L96 136c0-13.3-10.7-24-24-24s-24 10.7-24 24zM320 512l200 0c-6.1 0-12.3-2.3-17-7-9.4-9.4-9.4-24.6 0-33.9l67.9-67.9c13.5-13.5 21.1-31.8 21.1-50.9L592 136c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 145.9c0 25.6-10.2 50.2-28.3 68.4-8.8 8.8-23.1 23.1-42.7 42.7l-16 16c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9c8.8-8.8 23.1-23.1 42.7-42.7 4-4 6.2-9.4 6.2-15 0-11.7-9.5-21.3-21.3-21.3-5.6 0-11 2.2-15 6.2l-61.4 61.4C354.9 383 344 409.4 344 436.8l0 51.2c0 13.3-10.7 24-24 24z", "M311.6 31C297.5 11.5 274.9 0 250.9 0 209.5 0 176 33.5 176 74.9l0 2.4c0 64.4 82 133.4 122.2 163.3 13 9.7 30.5 9.7 43.5 0 40.2-30 122.2-98.9 122.2-163.3l0-2.4c0-41.4-33.5-74.9-74.9-74.9-24 0-46.6 11.5-60.7 31L320 42.7 311.6 31zM144 136c0-39.8-32.2-72-72-72S0 96.2 0 136L0 352.2c0 31.8 12.6 62.3 35.1 84.9L103 505c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9L69.1 403.1C55.6 389.6 48 371.3 48 352.2L48 136c0-13.3 10.7-24 24-24s24 10.7 24 24l0 145.9c0 25.6 10.2 50.2 28.3 68.4l15.9 15.9 0 0 26.7 26.7 0 0 16 16c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-16-16 0 0-26.7-26.7c-4-4-6.2-9.4-6.2-15 0-11.7 9.5-21.3 21.3-21.3 5.6 0 11 2.2 15 6.2l61.4 61.4C285.1 383 296 409.4 296 436.8l0 51.2c0 13.3 10.7 24 24 24s24-10.7 24-24l0-51.2c0-27.4 10.9-53.8 30.3-73.2l61.4-61.4c4-4 9.4-6.2 15-6.2 11.7 0 21.3 9.5 21.3 21.3 0 5.6-2.2 11-6.2 15l-26.7 26.7 0 0-16 16c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l16-16 0 0 26.7-26.7 0 0 15.9-15.9c18.1-18.1 28.3-42.7 28.3-68.4L544 136c0-13.3 10.7-24 24-24s24 10.7 24 24l0 216.2c0 19.1-7.6 37.4-21.1 50.9L503 471c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l67.9-67.9c22.5-22.5 35.1-53 35.1-84.9L640 136c0-39.8-32.2-72-72-72s-72 32.2-72 72l0 128.8c-12.1-10.5-28-16.8-45.3-16.8-18.4 0-36 7.3-49 20.3l-61.4 61.4c-7.7 7.7-14.5 16.2-20.4 25.3-5.8-9.1-12.6-17.5-20.4-25.3l-61.4-61.4c-13-13-30.6-20.3-49-20.3-17.3 0-33.1 6.3-45.3 16.8L144 136z"]],
    "arrow-up-small-big": [512, 512, ["sort-size-up-alt"], "f88f", ["M336 80l0 64 64 0 0-64-64 0zm0 224l0 128 128 0 0-128-128 0z", "M336 144l0-64 64 0 0 64-64 0zm-48 0c0 26.5 21.5 48 48 48l64 0c26.5 0 48-21.5 48-48l0-64c0-26.5-21.5-48-48-48l-64 0c-26.5 0-48 21.5-48 48l0 64zm48 288l0-128 128 0 0 128-128 0zm-48 0c0 26.5 21.5 48 48 48l128 0c26.5 0 48-21.5 48-48l0-128c0-26.5-21.5-48-48-48l-128 0c-26.5 0-48 21.5-48 48l0 128zM145 39c-9.4-9.4-24.6-9.4-33.9 0L23 127c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l47-47 0 342.1c0 13.3 10.7 24 24 24s24-10.7 24-24l0-342.1 47 47c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9L145 39z"]],
    "sliders-simple": [512, 512, [], "e253", ["M48 368a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zM400 144a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M80 400a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm76.3-56c-10.2-32.5-40.5-56-76.3-56-44.2 0-80 35.8-80 80s35.8 80 80 80c35.8 0 66.1-23.5 76.3-56L488 392c13.3 0 24-10.7 24-24s-10.7-24-24-24l-331.7 0zM464 144a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM355.7 120L24 120c-13.3 0-24 10.7-24 24s10.7 24 24 24l331.7 0c10.2 32.5 40.5 56 76.3 56 44.2 0 80-35.8 80-80s-35.8-80-80-80c-35.8 0-66.1 23.5-76.3 56z"]],
    "person-cane": [448, 512, [], "e53c", ["M192 167.1l0 152.9 64 0 0-152.9c-9.9-4.6-20.8-7.1-32-7.1s-22.1 2.5-32 7.1z", "M232 80a56 56 0 1 0 0-112 56 56 0 1 0 0 112zm-8 80c11.2 0 22.1 2.5 32 7.1l0 152.9-64 0 0-152.9c9.9-4.6 20.8-7.1 32-7.1zm32 208l0 152c0 13.3 10.7 24 24 24s24-10.7 24-24l0-302.4 60.5 84.4c7.7 10.8 22.7 13.2 33.5 5.5s13.2-22.7 5.5-33.5L324.3 163.5C301.1 131.2 263.8 112 224 112s-77.2 19.2-100.3 51.5L44.5 274c-7.7 10.8-5.2 25.8 5.5 33.5s25.8 5.2 33.5-5.5L144 217.6 144 520c0 13.3 10.7 24 24 24s24-10.7 24-24l0-152 64 0zm136 16c4.4 0 8 3.6 8 8l0 128c0 13.3 10.7 24 24 24s24-10.7 24-24l0-128c0-30.9-25.1-56-56-56s-56 25.1-56 56c0 13.3 10.7 24 24 24s24-10.7 24-24c0-4.4 3.6-8 8-8z"]],
    "message-music": [512, 512, ["comment-alt-music"], "f8af", ["M48 128l0 224c0 26.5 21.5 48 48 48l56 0c10.4 0 19.3 6.6 22.6 15.9 .9 2.5 1.4 5.2 1.4 8.1l0 49.7c32.7-23.1 63.3-44.7 91.9-64.9 8.1-5.7 17.8-8.8 27.7-8.8L416 400c26.5 0 48-21.5 48-48l0-224c0-26.5-21.5-48-48-48L96 80c-26.5 0-48 21.5-48 48zM160 296c0-30.9 28.7-56 64-56 5.5 0 10.9 .6 16 1.8l0-89.8c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24l0 16c0 13.3-10.7 24-24 24l-24 0 0 104c0 30.9-28.7 56-64 56s-64-25.1-64-56z", "M203.7 512.9l0 0 91.9-64.9 120.4 0c53 0 96-43 96-96l0-224c0-53-43-96-96-96L96 32C43 32 0 75 0 128L0 352c0 53 43 96 96 96l32 0 0 72c0 9 5 17.2 13 21.3s17.6 3.5 24.9-1.7l37.8-26.7zM295.6 400c-9.9 0-19.6 3.1-27.7 8.8-28.6 20.2-59.3 41.8-91.9 64.9l0-49.7c0-2.8-.5-5.6-1.4-8.1-3.3-9.3-12.2-15.9-22.6-15.9l-56 0c-26.5 0-48-21.5-48-48l0-224c0-26.5 21.5-48 48-48l320 0c26.5 0 48 21.5 48 48l0 224c0 26.5-21.5 48-48 48l-120.4 0zM312 128l-48 0c-13.3 0-24 10.7-24 24l0 89.8c-5.1-1.2-10.5-1.8-16-1.8-35.3 0-64 25.1-64 56s28.7 56 64 56 64-25.1 64-56l0-104 24 0c13.3 0 24-10.7 24-24l0-16c0-13.3-10.7-24-24-24z"]],
    "gauge-low": [512, 512, ["tachometer-alt-slow"], "f627", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm96 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm9.8-86.8c-5.1-12.2 .7-26.3 12.9-31.4s26.3 .7 31.4 12.9l60.5 145.3c29.7 1.4 53.3 25.9 53.3 55.9 0 30.9-25.1 56-56 56s-56-25.1-56-56c0-14.4 5.4-27.5 14.4-37.5L153.8 169.2zM288 112a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm96 48a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm48 96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M256 464a208 208 0 1 0 0-416 208 208 0 1 0 0 416zM256 0a256 256 0 1 1 0 512 256 256 0 1 1 0-512zm32 112a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM256 408c-30.9 0-56-25.1-56-56 0-14.4 5.4-27.5 14.4-37.5L153.8 169.2c-5.1-12.2 .7-26.3 12.9-31.4s26.3 .7 31.4 12.9l60.5 145.3c29.7 1.4 53.3 25.9 53.3 55.9 0 30.9-25.1 56-56 56zM384 160a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm16 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM144 256a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z"]],
    "hexagon-equals": [576, 512, [], "e6b2", ["M75.2 244.1c-4.2 7.4-4.2 16.5 0 23.8L171.4 436c4.3 7.5 12.2 12.1 20.8 12.1l191.6 0c8.6 0 16.6-4.6 20.8-12.1L500.8 268c4.2-7.4 4.2-16.5 0-23.8L404.7 76.1C400.4 68.6 392.4 64 383.8 64L192.2 64c-8.6 0-16.6 4.6-20.8 12.1L75.2 244.1zM192 200c0-13.3 10.7-24 24-24l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24zm0 112c0-13.3 10.7-24 24-24l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24z", "M33.5 220.3c-12.7 22.2-12.7 49.4 0 71.5l96.2 168.1c12.8 22.4 36.7 36.2 62.5 36.2l191.6 0c25.8 0 49.7-13.8 62.5-36.2l96.2-168.1c12.7-22.2 12.7-49.4 0-71.5L446.3 52.2C433.5 29.8 409.6 16 383.8 16L192.2 16c-25.8 0-49.7 13.8-62.5 36.2L33.5 220.3zM75.2 268c-4.2-7.4-4.2-16.5 0-23.8L171.4 76.1c4.3-7.5 12.2-12.1 20.8-12.1l191.6 0c8.6 0 16.6 4.6 20.8 12.1l96.2 168.1c4.2 7.4 4.2 16.5 0 23.8L404.7 436c-4.3 7.5-12.2 12.1-20.8 12.1l-191.6 0c-8.6 0-16.6-4.6-20.8-12.1L75.2 268zM192 200c0 13.3 10.7 24 24 24l144 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-144 0c-13.3 0-24 10.7-24 24zm0 112c0 13.3 10.7 24 24 24l144 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-144 0c-13.3 0-24 10.7-24 24z"]],
    "capsule": [448, 512, [], "e75a", ["M48 344.2c0 48.5 39.3 87.8 87.8 87.8 23.3 0 45.6-9.2 62.1-25.7L269.1 335 145 210.9 73.7 282.2C57.2 298.6 48 321 48 344.2z", "M0 344.2c0-36 14.3-70.5 39.8-96L216.2 71.8c25.5-25.5 60-39.8 96-39.8 75 0 135.8 60.8 135.8 135.8 0 36-14.3 70.5-39.8 96L231.8 440.2c-25.5 25.5-60 39.8-96 39.8-75 0-135.8-60.8-135.8-135.8zM269.1 335L145 210.9 73.7 282.2c-16.5 16.5-25.7 38.8-25.7 62.1 0 48.5 39.3 87.8 87.8 87.8 23.3 0 45.6-9.2 62.1-25.7L269.1 335zM303 301.1l71.3-71.3c16.5-16.5 25.7-38.8 25.7-62.1 0-48.5-39.3-87.8-87.8-87.8-23.3 0-45.6 9.2-62.1 25.7L178.9 177 303 301.1z"]],
    "user-sith": [448, 512, [], "e7b8", ["M24 512c13.3 0 24-10.7 24-24 0-48.6 39.4-88 88-88l176 0c48.6 0 88 39.4 88 88 0 13.3 10.7 24 24 24L24 512zm80-56l0 32c0 13.3 10.7 24 24 24s24-10.7 24-24l0-32c0-13.3-10.7-24-24-24s-24 10.7-24 24zm40-312c0-17.7 14.3-32 32-32l16 0c8.8 0 16 7.2 16 16l0 16c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16zm56 312l0 32c0 13.3 10.7 24 24 24s24-10.7 24-24l0-32c0-13.3-10.7-24-24-24s-24 10.7-24 24zm40-328c0-8.8 7.2-16 16-16l16 0c17.7 0 32 14.3 32 32 0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-16zm56 328l0 32c0 13.3 10.7 24 24 24s24-10.7 24-24l0-32c0-13.3-10.7-24-24-24s-24 10.7-24 24z", "M216-16c-8.8 0-16 7.2-16 16l-8 0C139 0 96 43 96 96l0 64-52.4 104.8C38.3 275.5 46 288 57.9 288l72.5 0c10.5 9.9 24.7 16 40.3 16l106.7 0c15.6 0 29.8-6.1 40.3-16l72.5 0c11.9 0 19.6-12.5 14.3-23.2L352 160 352 96c0-53-43-96-96-96l-8 0c0-8.8-7.2-16-16-16l-16 0zM176 112l16 0c8.8 0 16 7.2 16 16l0 16c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16 0-17.7 14.3-32 32-32zm128 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-16c0-8.8 7.2-16 16-16l16 0c17.7 0 32 14.3 32 32zm-64 48l0 12 43.7 32.8c2.7 2 4.3 5.2 4.3 8.5 0 5.9-4.8 10.7-10.7 10.7l-106.7 0c-5.9 0-10.7-4.8-10.7-10.7 0-3.4 1.6-6.5 4.3-8.5l43.7-32.8 0-12c0-8.8 7.2-16 16-16s16 7.2 16 16zM136 400l176 0c48.6 0 88 39.4 88 88 0 13.3 10.7 24 24 24s24-10.7 24-24c0-75.1-60.9-136-136-136l-176 0c-75.1 0-136 60.9-136 136 0 13.3 10.7 24 24 24s24-10.7 24-24c0-48.6 39.4-88 88-88zm-8 32c-13.3 0-24 10.7-24 24l0 32c0 13.3 10.7 24 24 24s24-10.7 24-24l0-32c0-13.3-10.7-24-24-24zm96 0c-13.3 0-24 10.7-24 24l0 32c0 13.3 10.7 24 24 24s24-10.7 24-24l0-32c0-13.3-10.7-24-24-24zm96 0c-13.3 0-24 10.7-24 24l0 32c0 13.3 10.7 24 24 24s24-10.7 24-24l0-32c0-13.3-10.7-24-24-24z"]],
    "gauge": [512, 512, ["dashboard", "gauge-med", "tachometer-alt-average"], "f624", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm96 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm48-96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm8 192c0-22.3 13.1-41.6 32-50.6L232 128c0-13.3 10.7-24 24-24s24 10.7 24 24l0 173.4c18.9 9 32 28.3 32 50.6 0 30.9-25.1 56-56 56s-56-25.1-56-56zM384 160a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm48 96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm56-160c0-22.3-13.1-41.6-32-50.6L280 128c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 173.4c-18.9 9-32 28.3-32 50.6 0 30.9 25.1 56 56 56s56-25.1 56-56zM160 192a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm-16 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm256 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM384 160a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"]],
    "envelope-open-text": [576, 512, [], "f658", ["M80 224.3L234.8 341.8c11.2 8.5 24 14 37.2 16.4l0 73.8-176 0c-8.8 0-16-7.1-16-16l0-191.7z", "M523.5 125.2c7 4.8 12.4 11.3 16 18.8l-73.3 0-155.4-107.2c-13.7-9.4-31.7-9.4-45.4 0L80.4 164.4 263.8 303.5c2.6 1.9 5.3 3.5 8.2 4.8l0 49.9c-13.2-2.4-26-7.9-37.2-16.4L80 224.3 80 416c0 8.9 7.2 16 16 16l176 0 0 48-176 0c-35.4 0-64-28.7-64-64l0-252c.1-15.5 7.8-30 20.5-38.8L238-2.7c30.1-20.7 69.8-20.7 99.9 0L523.5 125.2zM320 240c0-26.5 21.5-48 48-48l160 0c26.5 0 48 21.5 48 48l0 224c0 26.5-21.5 48-48 48l-160 0c-26.5 0-48-21.5-48-48l0-224zm56 40c0 13.3 10.7 24 24 24l96 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-96 0c-13.3 0-24 10.7-24 24zm0 96c0 13.3 10.7 24 24 24l56 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-56 0c-13.3 0-24 10.7-24 24z"]],
    "toolbox": [512, 512, [129520], "f552", ["", "M184 48l144 0c4.4 0 8 3.6 8 8l0 40-160 0 0-40c0-4.4 3.6-8 8-8zm-56 8l0 40-28.1 0c-12.7 0-24.9 5.1-33.9 14.1L14.1 161.9c-9 9-14.1 21.2-14.1 33.9L0 416c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-220.1c0-12.7-5.1-24.9-14.1-33.9l-51.9-51.9c-9-9-21.2-14.1-33.9-14.1l-28.1 0 0-40c0-30.9-25.1-56-56-56L184 0c-30.9 0-56 25.1-56 56zM48 320l88 0 0 16c0 13.3 10.7 24 24 24s24-10.7 24-24l0-16 144 0 0 16c0 13.3 10.7 24 24 24s24-10.7 24-24l0-16 88 0 0 96c0 8.8-7.2 16-16 16L64 432c-8.8 0-16-7.2-16-16l0-96zm0-48l0-76.1 51.9-51.9 312.2 0 51.9 51.9 0 76.1-88 0 0-16c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 16-144 0 0-16c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 16-88 0z"]],
    "wheat-slash": [576, 512, [], "e339", ["M297.2 75.1L325.1 103c18.4 18.4 21.4 46.7 8.3 68.4l-27.9-27.9c-18.6-18.6-21.3-46.9-8.3-68.5zm75.3 135.4c21.8-13.1 50.1-10 68.5 8.3l27.9 27.9c-21.5 13-49.9 10.3-68.4-8.3l-27.9-27.9zM456 77c0-29.3 23.7-53 53-53l11 0 0 11-.3 5.4c-2.5 25-22.4 44.8-47.3 47.3l-5.4 .3-11 0 0-11z", "M7-24.9c8.8-8.8 22.7-9.3 32.1-1.7l1.8 1.7 528 528 1.7 1.8c7.7 9.4 7.1 23.3-1.7 32.1s-22.7 9.3-32.1 1.7L535 537.1 7 9.1 5.4 7.2C-2.3-2.2-1.8-16.1 7-24.9zM72 240c6.4 0 12.5 2.5 17 7L135 293.1c23.4 23.4 33.4 55.4 29.7 86.2 30.8-3.8 62.9 6.3 86.2 29.7L296.9 455c4.5 4.5 7 10.6 7 17s-2.5 12.5-7 17l-7.4 7.4C248.9 537 183 537 142.4 496.4l-30.5-30.5-63 63c-9.4 9.4-24.5 9.4-33.9 0-9.4-9.4-9.4-24.6 0-33.9l63-63-30.5-30.5C7 360.9 7 295.1 47.6 254.5l7.4-7.4 3.7-3c3.9-2.6 8.5-4 13.3-4zm145 202.9c-18.4-18.4-46.7-21.5-68.5-8.3l27.9 27.9c18.6 18.6 46.9 21.3 68.4 8.3l-27.9-27.9zm126.8-29.4c-31.6 4.8-65-4.8-89.3-29.1l-94.9-94.9c-24.3-24.3-34-57.7-29.2-89.3L343.7 413.5zM73.2 299.1c-13 21.5-10.2 49.9 8.3 68.5l27.9 27.9c13.1-21.8 10.1-50.1-8.3-68.4L73.2 299.1zM296 16c6.4 0 12.5 2.5 17 7L359 69.1c23.4 23.4 33.4 55.4 29.7 86.2 30.8-3.8 62.9 6.3 86.2 29.7L520.9 231c4.5 4.5 7 10.6 7 17s-2.5 12.5-7 17l-7.4 7.4C476.9 309 420 312.6 379.3 283.3L260.6 164.6c-29.2-40.6-25.5-97.6 11-134.1l7.4-7.4 3.7-3c3.9-2.6 8.5-4 13.3-4zm145 202.9c-18.4-18.4-46.7-21.5-68.5-8.3l27.9 27.9c18.6 18.6 46.9 21.3 68.4 8.3l-27.9-27.9zM297.2 75.1c-13 21.5-10.2 49.9 8.3 68.5l27.9 27.9c13.1-21.8 10.1-50.1-8.3-68.4L297.2 75.1zM544-24c6.4 0 12.5 2.5 17 7s7 10.6 7 17l0 35-.1 5.2c-2.6 51.7-44 93.1-95.7 95.7l-5.2 .1-35 0c-6.4 0-12.5-2.5-17-7s-7-10.6-7-17l0-35c0-55.8 45.2-101 101-101l35 0zM509 24c-29.3 0-53 23.7-53 53l0 11 11 0 5.4-.3c25-2.5 44.8-22.4 47.3-47.3l.3-5.4 0-11-11 0z"]],
    "power-off": [512, 512, [9211], "f011", ["M48 256c0 114.9 93.1 208 208 208s208-93.1 208-208c0-75.4-40.1-141.5-100.4-178-24.9-15.1-53.3-25.1-83.6-28.6L280 256c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-206.6C201.7 52.9 173.3 62.9 148.4 78 88.2 114.4 48 180.6 48 256z", "M280-8c0-13.3-10.7-24-24-24S232-21.3 232-8l0 264c0 13.3 10.7 24 24 24s24-10.7 24-24L280-8zM148.4 78c11.3-6.9 15-21.6 8.1-33s-21.6-15-33-8.1C49.5 81.7 0 163.1 0 256 0 397.4 114.6 512 256 512S512 397.4 512 256c0-92.9-49.5-174.3-123.5-219.1-11.3-6.9-26.1-3.2-33 8.1s-3.2 26.1 8.1 33c60.2 36.5 100.4 102.6 100.4 178 0 114.9-93.1 208-208 208S48 370.9 48 256c0-75.4 40.2-141.5 100.4-178z"]],
    "signal": [512, 512, [128246, "signal-5", "signal-perfect"], "f012", ["", "M488 56c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 400c0 13.3 10.7 24 24 24s24-10.7 24-24l0-400zM360 128c-13.3 0-24 10.7-24 24l0 304c0 13.3 10.7 24 24 24s24-10.7 24-24l0-304c0-13.3-10.7-24-24-24zM280 248c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 208c0 13.3 10.7 24 24 24s24-10.7 24-24l0-208zM152 320c-13.3 0-24 10.7-24 24l0 112c0 13.3 10.7 24 24 24s24-10.7 24-24l0-112c0-13.3-10.7-24-24-24zM48 384c-13.3 0-24 10.7-24 24l0 48c0 13.3 10.7 24 24 24s24-10.7 24-24l0-48c0-13.3-10.7-24-24-24z"]],
    "arrows-spin": [512, 512, [], "e4bb", ["", "M280.2 488c0-13.3-10.7-24-24-24-52.8 0-105.6-20-146.1-60L145.2 369c6.9-6.9 8.9-17.2 5.2-26.2S138 328 128.3 328L24.2 328c-13.3 0-24 10.7-24 24l0 104c0 9.7 5.8 18.5 14.8 22.2s19.3 1.7 26.2-5.2l35-35c49.8 49.4 115 74 180 74 13.3 0 24-10.7 24-24zM256.2 0c-13.3 0-24 10.7-24 24s10.7 24 24 24c52.8 0 105.6 20 146.1 60L367.2 143c-6.9 6.9-8.9 17.2-5.2 26.2S374.5 184 384.2 184l104.1 0c13.3 0 24-10.7 24-24l0-104c0-9.7-5.8-18.5-14.8-22.2s-19.3-1.7-26.2 5.2l-35 35c-49.8-49.4-115-74-180-74zM24.2 280c13.3 0 24-10.7 24-24 0-52.8 20-105.6 60-146.1L143.2 145c6.9 6.9 17.2 8.9 26.2 5.2s14.8-12.5 14.8-22.2l0-104.1c0-13.3-10.7-24-24-24L56.2 0C46.5 0 37.8 5.8 34 14.8S32.4 34.1 39.2 41l35 35c-49.4 49.8-74 115-74 180 0 13.3 10.7 24 24 24zm488-24c0-13.3-10.7-24-24-24s-24 10.7-24 24c0 52.8-20 105.6-60 146.1L369.2 367c-6.9-6.9-17.2-8.9-26.2-5.2s-14.8 12.5-14.8 22.2l0 104.1c0 13.3 10.7 24 24 24l104 0c9.7 0 18.5-5.8 22.2-14.8s1.7-19.3-5.2-26.2l-35-35c49.4-49.8 74-115 74-180z"]],
    "joint": [576, 512, [], "f595", ["M74.8 400l122.7 28.3c5.6 1.3 11.3 2.3 17.1 2.9L180.4 375.6 74.8 400zm164.3-32l39.4 64 74.8 0c1.7 0 3.5 0 5.2-.1l-39.3-63.9-80.1 0zm146.5 3.3l32.3 52.5 103.4-15.9c3.9-.6 6.7-3.9 6.7-7.9s-2.9-7.3-6.7-7.9L385.6 371.3z", "M360 0c-13.3 0-24 10.7-24 24l0 19c0 53 21.1 103.9 58.6 141.4l21 21C426.1 215.9 432 230.2 432 245l0 19c0 13.3 10.7 24 24 24s24-10.7 24-24l0-19c0-27.6-11-54-30.5-73.5l-21-21C400 122 384 83.3 384 43l0-19c0-13.3-10.7-24-24-24zM552 288c13.3 0 24-10.7 24-24l0-19c0-53-21.1-103.9-58.6-141.4l-21-21C485.9 72.1 480 57.8 480 43l0-19c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 19c0 27.6 11 54 30.5 73.5l21 21C512 166 528 204.7 528 245l0 19c0 13.3 10.7 24 24 24zM197.5 428.3L74.8 400 180.4 375.6 214.6 431.2c-5.7-.6-11.4-1.6-17.1-2.9zM353.3 432l-74.8 0-39.4-64 80.1 0 39.3 63.9c-1.7 .1-3.5 .1-5.2 .1zm64.6-8.2l-32.3-52.5 135.7 20.9c3.9 .6 6.7 3.9 6.7 7.9s-2.9 7.3-6.7 7.9L417.9 423.8zM186.7 324.9L31 360.8C12.9 365 0 381.4 0 400s12.9 35 31 39.2l155.7 35.9c14.2 3.3 28.6 4.9 43.2 4.9l123.5 0c9.8 0 19.5-.7 29.2-2.2l146-22.5c27.3-4.2 47.4-27.7 47.4-55.3s-20.1-51.1-47.4-55.3l-146-22.5c-9.7-1.5-19.4-2.2-29.2-2.2l-123.5 0c-14.5 0-29 1.6-43.2 4.9z"]],
    "down-from-line": [384, 512, ["arrow-alt-from-top"], "f349", ["M105.9 368l86.1 86.1 86.1-86.1-30.1 0c-6.4 0-12.5-2.5-17-7s-7-10.6-7-17l0-168-64 0c0 52 0 108 0 168 0 13.3-10.7 24-24 24l-30.1 0z", "M175 505c4.5 4.5 10.6 7 17 7s12.5-2.5 17-7L353 361c6.9-6.9 8.9-17.2 5.2-26.2S345.7 320 336 320l-64 0 0-144c0-26.5-21.5-48-48-48l-64 0c-26.5 0-48 21.5-48 48l0 80 0 0 0 64-64 0c-9.7 0-18.5 5.8-22.2 14.8S24.2 354.1 31 361L175 505zM160 256l0 0 0-80 64 0 0 168c0 6.4 2.5 12.5 7 17s10.6 7 17 7l30.1 0-86.1 86.1-86.1-86.1 30.1 0c13.3 0 24-10.7 24-24l0-88zM384 24c0-13.3-10.7-24-24-24L24 0C10.7 0 0 10.7 0 24S10.7 48 24 48l336 0c13.3 0 24-10.7 24-24z"]],
    "tablet-rugged": [448, 512, [], "f48f", ["M80 64l0 384c0 8.8 7.2 16 16 16l256 0c8.8 0 16-7.2 16-16l0-384c0-8.8-7.2-16-16-16L96 48c-8.8 0-16 7.2-16 16z", "M352 48c8.8 0 16 7.2 16 16l0 384c0 8.8-7.2 16-16 16L96 464c-8.8 0-16-7.2-16-16L80 64c0-8.8 7.2-16 16-16l256 0zM96 0C66.6 0 41.8 19.8 34.3 46.8L8.8 59.6C3.4 62.3 0 67.8 0 73.9l0 76.2c0 6.1 3.4 11.6 8.8 14.3L32 176 32 192 8.8 203.6C3.4 206.3 0 211.8 0 217.9l0 76.2c0 6.1 3.4 11.6 8.8 14.3L32 320 32 336 8.8 347.6C3.4 350.3 0 355.8 0 361.9l0 76.2c0 6.1 3.4 11.6 8.8 14.3l25.5 12.7C41.8 492.2 66.6 512 96 512l256 0c29.4 0 54.2-19.8 61.7-46.8l25.5-12.7c5.4-2.7 8.8-8.2 8.8-14.3l0-76.2c0-6.1-3.4-11.6-8.8-14.3l-23.2-11.6 0-16 23.2-11.6c5.4-2.7 8.8-8.2 8.8-14.3l0-76.2c0-6.1-3.4-11.6-8.8-14.3l-23.2-11.6 0-16 23.2-11.6c5.4-2.7 8.8-8.3 8.8-14.3l0-76.2c0-6.1-3.4-11.6-8.8-14.3L413.7 46.8C406.2 19.8 381.4 0 352 0L96 0z"]],
    "braille": [384, 512, [], "f2a1", ["", "M80 144a80 80 0 1 0 0-160 80 80 0 1 0 0 160zm0 192a80 80 0 1 0 0-160 80 80 0 1 0 0 160zm0 144c-17.7 0-32-14.3-32-32s14.3-32 32-32 32 14.3 32 32-14.3 32-32 32zm0 48c44.2 0 80-35.8 80-80s-35.8-80-80-80-80 35.8-80 80 35.8 80 80 80zm256-80c0 17.7-14.3 32-32 32s-32-14.3-32-32 14.3-32 32-32 32 14.3 32 32zm48 0c0-44.2-35.8-80-80-80s-80 35.8-80 80 35.8 80 80 80 80-35.8 80-80zM304 224a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm0 112a80 80 0 1 0 0-160 80 80 0 1 0 0 160zm0-192a80 80 0 1 0 0-160 80 80 0 1 0 0 160z"]],
    "basket-shopping": [576, 512, ["shopping-basket"], "f291", ["M84.4 192l47.9 227.3c1.6 7.4 8.1 12.7 15.7 12.7l280.1 0c7.6 0 14.1-5.3 15.7-12.7L491.6 192 84.4 192zM160 264c0-13.3 10.7-24 24-24s24 10.7 24 24l0 96c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-96zm104 0c0-13.3 10.7-24 24-24s24 10.7 24 24l0 96c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-96zm104 0c0-13.3 10.7-24 24-24s24 10.7 24 24l0 96c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-96z", "M142 192l349.6 0-47.9 227.3c-1.6 7.4-8.1 12.7-15.7 12.7l-280.1 0c-7.6 0-14.1-5.3-15.7-12.7L84.4 192 142 192zm226.1-48l-160.1 0 45.2-48 1.9-2 33-35 33 35 1.9 2 45.2 48zM536 144l-102 0c-12.5-13.3-49.5-52.6-111.1-117.9L305.5 7.5C300.9 2.7 294.6 0 288 0s-12.9 2.7-17.5 7.5c-1.2 1.3-33.7 35.8-97.5 103.5L142 144 40 144c-13.3 0-24 10.7-24 24 0 11.6 8.3 21.3 19.3 23.5l50 237.6c6.2 29.6 32.4 50.8 62.6 50.8l280.1 0c30.3 0 56.4-21.2 62.6-50.8l50-237.6c11-2.2 19.3-11.9 19.3-23.5 0-13.3-10.7-24-24-24zM208 264c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 96c0 13.3 10.7 24 24 24s24-10.7 24-24l0-96zm80-24c-13.3 0-24 10.7-24 24l0 96c0 13.3 10.7 24 24 24s24-10.7 24-24l0-96c0-13.3-10.7-24-24-24zm128 24c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 96c0 13.3 10.7 24 24 24s24-10.7 24-24l0-96z"]],
    "party-bell": [512, 512, [], "e31a", ["M48 224c0-97.2 78.8-176 176-176 27.8 0 54.1 6.5 77.5 17.9 .7 .4 1.2 .8 1.7 1.6 .5 .9 .9 2.1 .9 3.2 0 1.7-.7 3.4-1.9 4.6L75.3 302.1c-1.2 1.2-2.9 1.9-4.6 1.9-1.1 0-2.3-.3-3.2-.9-.7-.4-1.2-.9-1.6-1.7-11.5-23.4-17.9-49.7-17.9-77.5z", "M48 224c0-97.2 78.8-176 176-176 27.8 0 54.1 6.5 77.5 17.9 .7 .4 1.2 .8 1.7 1.6 .5 .9 .9 2.1 .9 3.2 0 1.7-.7 3.4-1.9 4.6L75.3 302.1c-1.2 1.2-2.9 1.9-4.6 1.9-1.1 0-2.3-.3-3.2-.9-.7-.4-1.2-.9-1.6-1.7-11.5-23.4-17.9-49.7-17.9-77.5zM224 0c-123.7 0-224 100.3-224 224 0 35.3 8.2 68.9 22.8 98.7 9.5 19.3 28.8 29.3 47.8 29.3 14.5 0 28.3-5.7 38.5-16L336 109.2c10.2-10.2 16-24.1 16-38.5 0-19-10.1-38.4-29.3-47.8-29.8-14.6-63.3-22.8-98.7-22.8zM480 96a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM352 512a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM32 480a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zM359 167c-9.4 9.4-9.4 24.6 0 33.9l8.2 8.3c24.4 24.4 56.4 39.8 90.7 43.6l27.4 3c13.2 1.5 25-8 26.5-21.2s-8-25-21.2-26.5l-27.4-3c-23.5-2.6-45.4-13.1-62.1-29.8L393 167c-9.4-9.4-24.6-9.4-33.9 0zM201 359c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l8.3 8.3c16.7 16.7 27.2 38.6 29.8 62.1l3 27.4c1.5 13.2 13.3 22.7 26.5 21.2s22.7-13.3 21.2-26.5l-3-27.4c-3.8-34.3-19.2-66.3-43.6-90.7L201 359zM503.5 506.3c10.1-8.6 11.4-23.7 2.8-33.8l-8.5-10c-4.9-5.8-7.5-13.2-7.3-20.7 1.1-42.5-31.7-78.3-74.2-80.8l-30-1.8c-16.6-1-29.4-15-29-31.6 .5-19.4-6.1-38.2-18.6-53l-8.5-10c-8.6-10.1-23.7-11.4-33.8-2.8s-11.4 23.7-2.8 33.8l8.5 10c4.9 5.8 7.5 13.2 7.3 20.7-1.1 42.5 31.7 78.3 74.2 80.8l30 1.8c16.6 1 29.4 15 29 31.6-.5 19.4 6.1 38.2 18.6 53l8.5 10c8.6 10.1 23.7 11.4 33.8 2.8z"]],
    "bra": [576, 512, [], "e6cf", ["M64 336c0 53 43 96 96 96 27.6 0 52.6-11.7 70.1-30.4l-6.7-9.4c-30.2-42.3-72-75.1-120.3-94.5L77.2 287.4C68.8 301.6 64 318.2 64 336zm281.9 65.6c17.6 18.8 42.5 30.4 70.1 30.4 53 0 96-43 96-96 0-17.8-4.8-34.4-13.2-48.6l-25.9 10.4c-48.3 19.3-90.1 52.1-120.3 94.5l-6.7 9.4z", "M143.5 60.7c2.6-13-5.8-25.6-18.8-28.2S99.1 38.3 96.5 51.3L60.3 232.1c-27.3 26.2-44.3 63.1-44.3 103.9 0 79.5 64.5 144 144 144 49.9 0 93.9-25.4 119.8-64l16.5 0c25.8 38.6 69.8 64 119.8 64 79.5 0 144-64.5 144-144 0-40.8-17-77.7-44.3-103.9L479.5 51.3c-2.6-13-15.2-21.4-28.2-18.8s-21.4 15.2-18.8 28.2l37.3 186.6-14.7 5.9c-56.8 22.7-106 61.3-141.6 111.1l-2.6 3.7-45.7 0-2.6-3.7c-35.6-49.8-84.7-88.4-141.6-111.1l-14.7-5.9 37.3-186.6zm79.9 331.5l6.7 9.4c-17.6 18.8-42.5 30.4-70.1 30.4-53 0-96-43-96-96 0-17.8 4.8-34.4 13.2-48.6l25.9 10.4c48.3 19.3 90.1 52.1 120.3 94.5zm129.1 0c30.2-42.3 72-75.1 120.3-94.5l25.9-10.4c8.4 14.3 13.2 30.9 13.2 48.6 0 53-43 96-96 96-27.6 0-52.6-11.7-70.1-30.4l6.7-9.4z"]],
    "car-wash": [448, 512, [], "f5e6", ["M48 336l0 80 352 0 0-80c0-8.8-7.2-16-16-16L64 320c-8.8 0-16 7.2-16 16zm72 32a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm256 0a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M224 96c26.5 0 48-16 48-48 0-22.2-23-52-37.2-68.2-5.8-6.7-15.9-6.7-21.7 0-14.2 16.3-37.2 46.1-37.2 68.2 0 26.5 21.5 48 48 48zm-84.7 96l169.4 0c10.5 0 19.8 6.8 22.9 16.8l19.7 63.2-254.7 0 19.7-63.2c3.1-10 12.4-16.8 22.9-16.8zm-68.7 2.5L45.5 274.7C19.2 282.6 0 307.1 0 336L0 488c0 13.3 10.7 24 24 24s24-10.7 24-24l0-24 352 0 0 24c0 13.3 10.7 24 24 24s24-10.7 24-24l0-152c0-28.9-19.2-53.4-45.5-61.3l-25.1-80.2C368 164.5 340.2 144 308.7 144l-169.4 0c-31.5 0-59.3 20.5-68.7 50.5zM400 384l0 32-352 0 0-80c0-8.8 7.2-16 16-16l320 0c8.8 0 16 7.2 16 16l0 48zM96 392a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm280-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM112 48C112 25.8 89-4 74.8-20.2 69-26.9 59-26.9 53.2-20.2 39-4 16 25.8 16 48 16 74.5 37.5 96 64 96s48-16 48-48zM384 96c26.5 0 48-16 48-48 0-22.2-23-52-37.2-68.2-5.8-6.7-15.9-6.7-21.7 0-14.2 16.3-37.2 46.1-37.2 68.2 0 26.5 21.5 48 48 48z"]],
    "face-sunglasses": [512, 512, [], "e398", ["M48 256c0 114.9 93.1 208 208 208s208-93.1 208-208c0-19-2.5-37.4-7.3-54.9l-2.9 29.2C450.5 263.1 423 288 390.1 288l-52.2 0c-32.9 0-60.4-24.9-63.7-57.6l-3.8-38.4-28.8 0-3.8 38.4C234.5 263.1 207 288 174.1 288l-52.2 0c-32.9 0-60.4-24.9-63.7-57.6l-2.9-29.2C50.5 218.6 48 237 48 256zM91.3 129c3.2-.7 6.4-1 9.8-1l93.9 0c14.3 0 27 6.2 35.8 16l50.5 0c8.8-9.8 21.5-16 35.8-16l93.9 0c3.4 0 6.6 .3 9.8 1-38-49.3-97.7-81-164.7-81S129.3 79.7 91.3 129zm51.4 239.6c-9.2-9.6-8.9-24.8 .7-33.9s24.8-8.9 33.9 .7C192.3 351 218.4 368 256 368s63.7-17 78.7-32.6c9.2-9.6 24.4-9.9 33.9-.7s9.9 24.4 .7 33.9c-22.1 23-60 47.4-113.3 47.4s-91.2-24.4-113.3-47.4z", "M256 464c-114.9 0-208-93.1-208-208 0-19 2.5-37.4 7.3-54.9l2.9 29.2C61.5 263.1 89 288 121.9 288l52.2 0c32.9 0 60.4-24.9 63.7-57.6l3.8-38.4 28.8 0 3.8 38.4c3.3 32.7 30.8 57.6 63.7 57.6l52.2 0c32.9 0 60.4-24.9 63.7-57.6l2.9-29.2c4.8 17.5 7.3 35.9 7.3 54.9 0 114.9-93.1 208-208 208zM91.3 129c38-49.3 97.7-81 164.7-81s126.7 31.7 164.7 81c-3.1-.7-6.4-1-9.8-1L317 128c-14.3 0-27 6.2-35.8 16l-50.5 0c-8.8-9.8-21.5-16-35.8-16L101 128c-3.4 0-6.6 .3-9.8 1zM256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM143.4 334.7c-9.6 9.2-9.9 24.4-.7 33.9 22.1 23 60 47.4 113.3 47.4s91.2-24.4 113.3-47.4c9.2-9.6 8.9-24.8-.7-33.9s-24.8-8.9-33.9 .7C319.7 351 293.6 368 256 368s-63.7-17-78.7-32.6c-9.2-9.6-24.4-9.9-33.9-.7z"]],
    "bridge": [512, 512, [], "e4c8", ["M48 192l0 49.8c29.7 19 48 51.9 48 87.6l0 102.6 48 0 0-64c0-61.9 50.1-112 112-112s112 50.1 112 112l0 64 48 0 0-102.6c0-35.7 18.3-68.7 48-87.6l0-49.8-416 0z", "M24 32C10.7 32 0 42.7 0 56S10.7 80 24 80l16 0 0 64-16 0c-13.3 0-24 10.7-24 24l0 88c0 9.1 5.1 17.4 13.3 21.5l3.8 1.9c19 9.5 31 28.9 31 50.1L48 440c0 22.1 17.9 40 40 40l64 0c22.1 0 40-17.9 40-40l0-72c0-35.3 28.7-64 64-64s64 28.7 64 64l0 72c0 22.1 17.9 40 40 40l64 0c22.1 0 40-17.9 40-40l0-110.6c0-21.2 12-40.6 31-50.1l3.8-1.9c8.1-4.1 13.3-12.4 13.3-21.5l0-88c0-13.3-10.7-24-24-24l-16 0 0-64 16 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L24 32zM424 80l0 64-80 0 0-64 80 0zM296 80l0 64-80 0 0-64 80 0zM168 80l0 64-80 0 0-64 80 0zm24 112l272 0 0 49.8c-29.7 19-48 51.9-48 87.6l0 102.6-48 0 0-64c0-61.9-50.1-112-112-112S144 306.1 144 368l0 64-48 0 0-102.6c0-35.7-18.3-68.7-48-87.6l0-49.8 144 0z"]],
    "arrows-from-line": [384, 512, [], "e0a4", ["", "M209-25c-9.4-9.4-24.6-9.4-33.9 0L103 47c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l31-31 0 102.1c0 13.3 10.7 24 24 24s24-10.7 24-24l0-102.1 31 31c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9L209-25zm7 385c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 102.1-31-31c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l72 72c9.4 9.4 24.6 9.4 33.9 0l72-72c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-31 31 0-102.1zM24 232c-13.3 0-24 10.7-24 24s10.7 24 24 24l336 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L24 232z"]],
    "up-long-to-line": [320, 512, [], "e6c6", ["M70.6 208l33.4 0c13.3 0 24 10.7 24 24l0 296 64 0 0-296c0-13.3 10.7-24 24-24l33.4 0-89.4-89.4-89.4 89.4z", "M296-64c13.3 0 24 10.7 24 24s-10.7 24-24 24L24-16C10.7-16 0-26.7 0-40S10.7-64 24-64l272 0zM249.4 208L160 118.6 70.6 208 104 208c13.3 0 24 10.7 24 24l0 296 64 0 0-296c0-13.3 10.7-24 24-24l33.4 0zM137.4 73.4c12.5-12.5 32.8-12.5 45.3 0l128 128c9.2 9.2 11.9 22.9 6.9 34.9l0 0c-5 12-16.6 19.8-29.6 19.8l-48 0 0 272c0 26.5-21.5 48-48 48l-64 0c-26.5 0-48-21.5-48-48l0-272-48 0c-12.9 0-24.6-7.8-29.6-19.8l0 0c-5-12-2.2-25.7 6.9-34.9l128-128z"]],
    "up-to-line": [384, 512, ["arrow-alt-to-top"], "f34d", ["M105.9 272l30.1 0c13.3 0 24 10.7 24 24 0 60 0 116 0 168l64 0 0-168c0-13.3 10.7-24 24-24l30.1 0-86.1-86.1-86.1 86.1z", "M0 24C0 37.3 10.7 48 24 48l336 0c13.3 0 24-10.7 24-24S373.3 0 360 0L24 0C10.7 0 0 10.7 0 24zM209 135c-9.4-9.4-24.6-9.4-33.9 0L31 279c-6.9 6.9-8.9 17.2-5.2 26.2S38.3 320 48 320l64 0 0 64 0 0 0 80c0 26.5 21.5 48 48 48l64 0c26.5 0 48-21.5 48-48l0-144 64 0c9.7 0 18.5-5.8 22.2-14.8s1.7-19.3-5.2-26.2L209 135zm15 249l0 80-64 0 0-80 0 0 0-88c0-13.3-10.7-24-24-24l-30.1 0 86.1-86.1 86.1 86.1-30.1 0c-13.3 0-24 10.7-24 24l0 88z"]],
    "plane-arrival": [576, 512, [128748], "f5af", ["M64.7 103.9l.5 96.7c.1 19.3 14 35.8 33.1 39.2l26.2 4.6 354.5 62.5c17.4 3.1 34-8.6 37.1-26s-8.6-34-26-37.1l-109-19.2c-6.6-1.2-12.5-5.1-16.1-10.7L242.4 21.5 214.6 16.6 237 167.2c1.1 7.6-1.5 15.3-7 20.7s-13.3 7.8-20.9 6.4L127.7 180c-6.3-1.1-11.8-4.7-15.5-9.9l-46.2-66-1.3-.2z", "M490.1 243.9c17.4 3.1 29 19.7 26 37.1s-19.7 29-37.1 26l-354.5-62.5-26.2-4.6c-19-3.4-33-19.8-33.1-39.2l-.5-96.7 1.3 .2 46.2 66c3.7 5.2 9.2 8.8 15.5 9.9l81.4 14.4c7.6 1.3 15.4-1.1 20.9-6.4s8.1-13.1 7-20.7L214.6 16.6 242.4 21.5 365 213.9c3.6 5.7 9.4 9.6 16.1 10.7l109 19.2zm73.2 45.4c7.7-43.5-21.4-85-64.9-92.7L399.8 179.2 277.2-13.2c-3.6-5.7-9.4-9.6-16.1-10.7L190.2-36.5c-7.6-1.3-15.4 1.1-20.9 6.4s-8.1 13.1-7 20.7l22.3 150.6-38.8-6.8-46.2-66c-3.7-5.2-9.2-8.8-15.5-9.9L44.7 51.6c-7-1.2-14.2 .7-19.6 5.3s-8.6 11.4-8.5 18.5l.7 125.5c.2 42.5 30.8 78.8 72.7 86.2 13.9 2.5 22.7 4 26.2 4.6l354.5 62.5c43.5 7.7 85-21.4 92.7-64.9zM224 400a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm128.5-15.6a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM24 464c-13.3 0-24 10.7-24 24s10.7 24 24 24l528 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L24 464z"]],
    "pot-food": [640, 512, [127858], "e43f", ["M112 272c0 71.3 42.4 132.8 103.5 160.5 11.5 5.2 20.4 14.7 25 26.4 1.2 3.1 4.2 5.1 7.5 5.1l144 0c3.3 0 6.3-2 7.5-5.1 4.5-11.7 13.5-21.2 25-26.4 61.1-27.7 103.5-89.2 103.5-160.5l-416 0z", "M112 24c0 26.5 10.5 38.7 25.9 56.1l.4 .4c16.5 18.6 37.7 42.4 37.7 87.5 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-26.5-10.5-38.7-25.9-56.1l-.4-.4C85.2 93 64 69.1 64 24 64 10.7 74.7 0 88 0s24 10.7 24 24zm112 0c0 26.5 10.5 38.7 25.9 56.1l.4 .4c16.5 18.6 37.7 42.4 37.7 87.5 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-26.5-10.5-38.7-25.9-56.1l-.4-.4C197.2 93 176 69.1 176 24 176 10.7 186.7 0 200 0s24 10.7 24 24zm208 88c50.7 0 93.6 33.7 107.4 80l-214.7 0c13.8-46.3 56.6-80 107.4-80zM16 280c0-13.3 10.7-24 24-24l26.7 0c6.6-18.6 24.4-32 45.3-32l416 0c20.9 0 38.7 13.4 45.3 32l26.7 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-26.3 0c-11 76.9-61.1 141.2-129.5 172.2-8.1 21-28.4 35.8-52.3 35.8l-144 0c-23.8 0-44.2-14.9-52.3-35.8-68.4-31-118.5-95.3-129.5-172.2L40 304c-13.3 0-24-10.7-24-24zM240.5 458.9c1.2 3.1 4.2 5.1 7.5 5.1l144 0c3.3 0 6.3-2 7.5-5.1 4.5-11.7 13.5-21.2 25-26.4 61.1-27.7 103.5-89.2 103.5-160.5l-416 0c0 71.3 42.4 132.8 103.5 160.5 11.5 5.2 20.4 14.7 25 26.4z"]],
    "cash-register": [512, 512, [], "f788", ["M48 432l0 16c0 8.8 7.2 16 16 16l384 0c8.8 0 16-7.2 16-16l0-16-416 0zm.5-48l415 0-23.2-162.3c-1.1-7.9-7.9-13.7-15.8-13.7l-337 0c-8 0-14.7 5.9-15.8 13.7L48.5 384zM136 256a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm48 80a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm48-80a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm48 80a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm48-80a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm48 80a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm48-80a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M96 0C60.7 0 32 28.7 32 64s28.7 64 64 64l48 0 0 32-56.5 0c-31.8 0-58.9 23.4-63.4 54.9L.6 379.5c-.4 3-.6 6-.6 9L0 448c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-59.5c0-3-.2-6.1-.6-9L487.8 214.9c-4.5-31.5-31.5-54.9-63.4-54.9l-216.5 0 0-32 48 0c35.3 0 64-28.7 64-64S291.3 0 256 0L96 0zm0 48l160 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L96 80c-8.8 0-16-7.2-16-16s7.2-16 16-16zM48 448l0-16 416 0 0 16c0 8.8-7.2 16-16 16L64 464c-8.8 0-16-7.2-16-16zM440.3 221.7l23.2 162.3-415 0 23.2-162.3c1.1-7.9 7.9-13.7 15.8-13.7l337 0c8 0 14.7 5.9 15.8 13.7zM112 232a24 24 0 1 0 0 48 24 24 0 1 0 0-48zm72 24a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm-24 56a24 24 0 1 0 0 48 24 24 0 1 0 0-48zm120-56a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm-24 56a24 24 0 1 0 0 48 24 24 0 1 0 0-48zm120-56a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm-24 56a24 24 0 1 0 0 48 24 24 0 1 0 0-48z"]],
    "ring": [512, 512, [], "f70b", ["M48 192c0 6.6 2.9 14.7 11.7 24 .8 .9 1.7 1.7 2.5 2.6 47.3-26.8 117.6-42.6 193.8-42.6s146.4 15.8 193.8 42.6c.9-.9 1.7-1.7 2.5-2.6 8.8-9.3 11.7-17.4 11.7-24s-2.9-14.7-11.7-24c-8.9-9.4-22.9-19-42.1-27.6-38.2-17.1-92.7-28.4-154.2-28.4s-116 11.2-154.2 28.4c-19.1 8.6-33.2 18.2-42.1 27.6-8.8 9.3-11.7 17.4-11.7 24zm0 76.6L48 320c0 6.6 2.9 14.7 11.7 24 8.9 9.4 22.9 19 42.1 27.6 38.2 17.1 92.7 28.4 154.2 28.4s116-11.2 154.2-28.4c19.1-8.6 33.2-18.2 42.1-27.6 8.8-9.3 11.7-17.4 11.7-24l0-51.4c-10.3 7.1-21.8 13.3-34.1 18.9-45.7 20.5-107.2 32.6-173.9 32.6S127.9 307.9 82.1 287.4c-12.4-5.5-23.9-11.8-34.1-18.9z", "M59.7 168c8.9-9.4 22.9-19 42.1-27.6 38.2-17.1 92.7-28.4 154.2-28.4s116 11.2 154.2 28.4c19.1 8.6 33.2 18.2 42.1 27.6 8.8 9.3 11.7 17.4 11.7 24s-2.9 14.7-11.7 24c-.8 .9-1.7 1.7-2.5 2.6-47.3-26.8-117.6-42.6-193.8-42.6S109.6 191.8 62.2 218.6c-.9-.9-1.7-1.7-2.5-2.6-8.8-9.3-11.7-17.4-11.7-24s2.9-14.7 11.7-24zM464 268.6l0 51.4c0 6.6-2.9 14.7-11.7 24-8.9 9.4-22.9 19-42.1 27.6-38.2 17.1-92.7 28.4-154.2 28.4s-116-11.2-154.2-28.4c-19.1-8.6-33.2-18.2-42.1-27.6-8.8-9.3-11.7-17.4-11.7-24l0-51.4c10.3 7.1 21.8 13.3 34.1 18.9 45.7 20.5 107.2 32.6 173.9 32.6s128.1-12.1 173.9-32.6c12.4-5.5 23.9-11.8 34.1-18.9zM0 192L0 320c0 22.1 10.1 41.4 24.8 57 14.6 15.4 34.5 28.2 57.4 38.5 45.7 20.5 107.2 32.6 173.9 32.6s128.1-12.1 173.9-32.6c22.8-10.2 42.8-23 57.4-38.5 14.7-15.6 24.8-34.9 24.8-57l0-128c0-22.1-10.1-41.4-24.8-57-14.6-15.4-34.5-28.2-57.4-38.5-45.7-20.5-107.2-32.6-173.9-32.6S127.9 76.1 82.1 96.6C59.3 106.8 39.3 119.6 24.8 135 10.1 150.6 0 169.9 0 192zm256 80c-56.1 0-106.4-9.3-143.8-24 37.1-14.5 87.3-24 143.8-24s106.7 9.5 143.8 24c-37.4 14.7-87.7 24-143.8 24z"]],
    "message-xmark": [512, 512, ["comment-alt-times", "message-times"], "f4ab", ["M48 128l0 224c0 26.5 21.5 48 48 48l56 0c10.4 0 19.3 6.6 22.6 15.9 .9 2.5 1.4 5.2 1.4 8.1l0 49.7c32.7-23.1 63.3-44.7 91.9-64.9 8.1-5.7 17.8-8.8 27.7-8.8L416 400c26.5 0 48-21.5 48-48l0-224c0-26.5-21.5-48-48-48L96 80c-26.5 0-48 21.5-48 48zm140.1 44.1c9.4-9.4 24.6-9.4 33.9 0l33.9 33.9 33.9-33.9c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-33.9 33.9 33.9 33.9c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-33.9-33.9-33.9 33.9c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l33.9-33.9-33.9-33.9c-9.4-9.4-9.4-24.6 0-33.9z", "M203.7 512.9l0 0 91.9-64.9 120.4 0c53 0 96-43 96-96l0-224c0-53-43-96-96-96L96 32C43 32 0 75 0 128L0 352c0 53 43 96 96 96l32 0 0 72c0 9 5 17.2 13 21.3s17.6 3.5 24.9-1.7l37.8-26.7zM295.6 400c-9.9 0-19.6 3.1-27.7 8.8-28.6 20.2-59.3 41.8-91.9 64.9l0-49.7c0-2.8-.5-5.6-1.4-8.1-3.3-9.3-12.2-15.9-22.6-15.9l-56 0c-26.5 0-48-21.5-48-48l0-224c0-26.5 21.5-48 48-48l320 0c26.5 0 48 21.5 48 48l0 224c0 26.5-21.5 48-48 48l-120.4 0zm28.3-227.9c-9.4-9.4-24.6-9.4-33.9 0l-33.9 33.9-33.9-33.9c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l33.9 33.9-33.9 33.9c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l33.9-33.9 33.9 33.9c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-33.9-33.9 33.9-33.9c9.4-9.4 9.4-24.6 0-33.9z"]],
    "share-nodes": [512, 512, ["share-alt"], "f1e0", ["M48 256a48 48 0 1 0 96 0 48 48 0 1 0 -96 0zM336 96a48 48 0 1 0 96 0 48 48 0 1 0 -96 0zm0 320a48 48 0 1 0 96 0 48 48 0 1 0 -96 0z", "M432 96a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zm48 0c0 53-43 96-96 96-27.4 0-52.1-11.5-69.6-29.9L188.9 231.8c2 7.7 3.1 15.8 3.1 24.2s-1.1 16.5-3.1 24.2l125.5 69.7c17.5-18.4 42.2-29.9 69.6-29.9 53 0 96 43 96 96s-43 96-96 96-96-43-96-96c0-8.3 1.1-16.5 3.1-24.2L165.6 322.1C148.1 340.5 123.4 352 96 352 43 352 0 309 0 256s43-96 96-96c27.4 0 52.1 11.5 69.6 29.9l125.5-69.7c-2-7.7-3.1-15.8-3.1-24.2 0-53 43-96 96-96s96 43 96 96zM144 256a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM384 464a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"]],
    "octagon-divide": [512, 512, [], "e203", ["M48.5 181.6l133.5-133.5 148.8 0 133.5 133.5 0 148.8-133.5 133.5-148.8 0-133.5-133.5 0-148.8zM144.4 256c0 13.3 10.7 24 24 24l176 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-176 0c-13.3 0-24 10.7-24 24zm80-96a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm0 192a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M330.9 .1c12.7 0 24.9 5.1 33.9 14.1L498.3 147.6c9 9 14.1 21.2 14.1 33.9l0 148.8c0 12.7-5.1 24.9-14.1 33.9L364.8 497.9c-9 9-21.2 14.1-33.9 14.1l-148.8 0c-12.7 0-24.9-5.1-33.9-14.1L14.6 364.4c-9-9-14.1-21.2-14.1-33.9l0-148.8c0-12.7 5.1-24.9 14.1-33.9L148.1 14.1c9-9 21.2-14.1 33.9-14.1l148.8 0zM48.5 181.6l0 148.8 133.5 133.5 148.8 0 133.5-133.5 0-148.8-133.5-133.5-148.8 0-133.5 133.5zM256.4 128a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm-88 104l176 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-176 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zm56 120a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"]],
    "folder-arrow-up": [512, 512, ["folder-upload"], "e054", ["M48 96l0 288c0 8.8 7.2 16 16 16l384 0c8.8 0 16-7.2 16-16l0-240c0-8.8-7.2-16-16-16l-149.3 0c-17.3 0-34.2-5.6-48-16L212.3 83.2c-2.8-2.1-6.1-3.2-9.6-3.2L64 80c-8.8 0-16 7.2-16 16zM175 239l64-64c9.4-9.4 24.6-9.4 33.9 0l64 64c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-23-23 0 86.1c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-86.1-23 23c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9z", "M464 384c0 8.8-7.2 16-16 16L64 400c-8.8 0-16-7.2-16-16L48 96c0-8.8 7.2-16 16-16l138.7 0c3.5 0 6.8 1.1 9.6 3.2L250.7 112c13.8 10.4 30.7 16 48 16L448 128c8.8 0 16 7.2 16 16l0 240zM64 448l384 0c35.3 0 64-28.7 64-64l0-240c0-35.3-28.7-64-64-64L298.7 80c-6.9 0-13.7-2.2-19.2-6.4L241.1 44.8C230 36.5 216.5 32 202.7 32L64 32C28.7 32 0 60.7 0 96L0 384c0 35.3 28.7 64 64 64zM273 175c-9.4-9.4-24.6-9.4-33.9 0l-64 64c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l23-23 0 86.1c0 13.3 10.7 24 24 24s24-10.7 24-24l0-86.1 23 23c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-64-64z"]],
    "arrows-minimize": [448, 512, ["compress-arrows"], "e0a5", ["", "M7.5 39c9.4-9.4 24.6-9.4 33.9 0l103 103 0-54.1c0-13.3 10.7-24 24-24s24 10.7 24 24l0 112c0 13.3-10.7 24-24 24l-112 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l54.1 0-103-103c-9.4-9.4-9.4-24.6 0-33.9zm433.9 0c9.4 9.4 9.4 24.6 0 33.9l-103 103 54.1 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-112 0c-13.3 0-24-10.7-24-24l0-112c0-13.3 10.7-24 24-24s24 10.7 24 24l0 54.1 103-103c9.4-9.4 24.6-9.4 33.9 0zM32.5 312c0-13.3 10.7-24 24-24l112 0c13.3 0 24 10.7 24 24l0 112c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-54.1-103 103c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l103-103-54.1 0c-13.3 0-24-10.7-24-24zm224 0c0-13.3 10.7-24 24-24l112 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-54.1 0 103 103c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-103-103 0 54.1c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-112z"]],
    "person-circle-exclamation": [640, 512, [], "e53f", ["M192 167.1l0 152.9 64 0 0-152.9c-9.9-4.6-20.8-7.1-32-7.1s-22.1 2.5-32 7.1z", "M224-32a56 56 0 1 1 0 112 56 56 0 1 1 0-112zM192 320l64 0 0-152.9c-9.9-4.6-20.8-7.1-32-7.1s-22.1 2.5-32 7.1L192 320zm0 48l0 152c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-302.4-60.5 84.4c-7.7 10.8-22.7 13.3-33.5 5.5S36.8 284.8 44.5 274l79.2-110.5C146.8 131.2 184.2 112 224 112s77.2 19.2 100.3 51.5L382.7 245c-13.1 9.6-24.9 20.8-35.2 33.3L304 217.6 304 520c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-152-64 0zM496 256a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm0 228a20 20 0 1 0 0-40 20 20 0 1 0 0 40zm0-180c-8.8 0-16 7.2-16 16l0 80c0 8.8 7.2 16 16 16s16-7.2 16-16l0-80c0-8.8-7.2-16-16-16z"]],
    "binoculars": [512, 512, [], "f1e5", ["M48 357.2L48 424c0 4.4 3.6 8 8 8l112 0c4.4 0 8-3.6 8-8l0-264-61.3 0c-3.9 0-7.2 2.8-7.9 6.6l-5 27.3C97.2 219.5 88 244 74.6 266.4l-2.6 4.4C56.3 296.9 48 326.7 48 357.2zM336 160l0 264c0 4.4 3.6 8 8 8l112 0c4.4 0 8-3.6 8-8l0-66.8c0-30.4-8.3-60.3-23.9-86.4l-2.6-4.4c-13.4-22.3-22.6-46.9-27.3-72.5l-5-27.3c-.7-3.8-4-6.6-7.9-6.6L336 160z", "M96 64c0-17.7 14.3-32 32-32l32 0c17.7 0 32 14.3 32 32l0 16-96 0 0-16zM59.6 158c4.8-26.6 28-46 55.1-46l85.3 0c13.3 0 24 10.7 24 24l0 24 64 0 0-24c0-13.3 10.7-24 24-24l85.3 0c27.1 0 50.3 19.4 55.1 46l5 27.3c3.6 19.9 10.8 39 21.2 56.4l2.6 4.4c20.1 33.6 30.8 72 30.8 111.1l0 66.8c0 30.9-25.1 56-56 56l-112 0c-30.9 0-56-25.1-56-56l0-136-64 0 0 136c0 30.9-25.1 56-56 56L56 480c-30.9 0-56-25.1-56-56l0-66.8C0 318 10.6 279.6 30.8 246l2.6-4.4c10.4-17.4 17.6-36.5 21.2-56.4l5-27.3zm55.1 2c-3.9 0-7.2 2.8-7.9 6.6l-5 27.3C97.2 219.5 88 244 74.6 266.4l-2.6 4.4C56.3 296.9 48 326.7 48 357.2L48 424c0 4.4 3.6 8 8 8l112 0c4.4 0 8-3.6 8-8l0-264-61.3 0zm282.6 0l-61.3 0 0 264c0 4.4 3.6 8 8 8l112 0c4.4 0 8-3.6 8-8l0-66.8c0-30.4-8.3-60.3-23.9-86.4l-2.6-4.4c-13.4-22.3-22.6-46.9-27.3-72.5l-5-27.3c-.7-3.8-4-6.6-7.9-6.6zM352 32l32 0c17.7 0 32 14.3 32 32l0 16-96 0 0-16c0-17.7 14.3-32 32-32z"]],
    "grid-round-5": [448, 512, [], "e5de", ["", "M28 32a28 28 0 1 0 0 56 28 28 0 1 0 0-56zM0 158a28 28 0 1 0 56 0 28 28 0 1 0 -56 0zm28 70a28 28 0 1 0 0 56 28 28 0 1 0 0-56zM0 354a28 28 0 1 0 56 0 28 28 0 1 0 -56 0zm0 98c0 15.5 12.5 28 28 28s28-12.5 28-28-12.5-28-28-28-28 12.5-28 28zm98 0c0 15.5 12.5 28 28 28s28-12.5 28-28-12.5-28-28-28-28 12.5-28 28zm126-28c-15.5 0-28 12.5-28 28s12.5 28 28 28 28-12.5 28-28-12.5-28-28-28zm70 28c0 15.5 12.5 28 28 28s28-12.5 28-28-12.5-28-28-28-28 12.5-28 28zm126-28c-15.5 0-28 12.5-28 28s12.5 28 28 28 28-12.5 28-28-12.5-28-28-28zM126 326a28 28 0 1 0 0 56 28 28 0 1 0 0-56zm70 28a28 28 0 1 0 56 0 28 28 0 1 0 -56 0zm126-28a28 28 0 1 0 0 56 28 28 0 1 0 0-56zm70 28a28 28 0 1 0 56 0 28 28 0 1 0 -56 0zM98 256a28 28 0 1 0 56 0 28 28 0 1 0 -56 0zm126-28a28 28 0 1 0 0 56 28 28 0 1 0 0-56zm70 28a28 28 0 1 0 56 0 28 28 0 1 0 -56 0zm126-28a28 28 0 1 0 0 56 28 28 0 1 0 0-56zM126 130a28 28 0 1 0 0 56 28 28 0 1 0 0-56zm70 28a28 28 0 1 0 56 0 28 28 0 1 0 -56 0zm126-28a28 28 0 1 0 0 56 28 28 0 1 0 0-56zm70 28a28 28 0 1 0 56 0 28 28 0 1 0 -56 0zM98 60a28 28 0 1 0 56 0 28 28 0 1 0 -56 0zM224 32a28 28 0 1 0 0 56 28 28 0 1 0 0-56zm70 28a28 28 0 1 0 56 0 28 28 0 1 0 -56 0zM420 32a28 28 0 1 0 0 56 28 28 0 1 0 0-56z"]],
    "kip-sign": [384, 512, [], "e1c4", ["", "M88 32c13.3 0 24 10.7 24 24l0 154.5 200.3-172.7c10-8.7 25.2-7.5 33.8 2.5s7.5 25.2-2.5 33.8L160.6 232 360 232c13.3 0 24 10.7 24 24s-10.7 24-24 24l-199.4 0 183.1 157.8c10 8.7 11.2 23.8 2.5 33.8s-23.8 11.2-33.8 2.5L112 301.5 112 457c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-177-40 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l40 0 0-176c0-13.3 10.7-24 24-24z"]],
    "hard-drive": [448, 512, [128436, "hdd"], "f0a0", ["M48 96l0 162c5.1-1.3 10.5-2 16-2l320 0c5.5 0 10.9 .7 16 2l0-162c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16zm0 224l0 96c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-96c0-8.8-7.2-16-16-16L64 304c-8.8 0-16 7.2-16 16zm216 48a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm96 0a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M64 80c-8.8 0-16 7.2-16 16l0 162c5.1-1.3 10.5-2 16-2l320 0c5.5 0 10.9 .7 16 2l0-162c0-8.8-7.2-16-16-16L64 80zM48 320l0 96c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-96c0-8.8-7.2-16-16-16L64 304c-8.8 0-16 7.2-16 16zM0 320L0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64l0-96zm216 48a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm120-24a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]],
    "ranking-star": [512, 512, [], "e561", ["M64 368l0 96 96 0 0-96-96 0zm144-64l0 160 96 0 0-160-96 0zm144 96l0 64 80 0 0-64-80 0z", "M308.9 256.3c24.2 2.5 43.1 22.9 43.1 47.8l0 48 80 0 4.9 .2c24.2 2.5 43.1 22.9 43.1 47.8l0 64-.2 4.9c-2.3 22.6-20.3 40.6-42.8 42.8l-4.9 .2-368 0c-26.5 0-48-21.5-48-48l0-96c0-26.5 21.5-48 48-48l96 0 0-16c0-24.9 18.9-45.3 43.1-47.8l4.9-.2 96 0 4.9 .2zM64 464l96 0 0-96-96 0 0 96zm144 0l96 0 0-160-96 0 0 160zm144 0l80 0 0-64-80 0 0 64zM245.8 6.3c4.3-8.6 16.5-8.3 20.4 0l23.6 47.8 52.3 7.5c9.3 1.4 13.2 13 6.4 19.8l-37.9 36.6 8.9 52.1c1.4 9.3-8.2 16.5-16.8 12.2l-46.5-24.4-46.9 24.8c-8.6 4.3-18.3-2.9-16.8-12.2l8.9-52.1-37.9-37c-6.8-6.8-2.9-18.3 6.4-19.8l52.3-7.5 23.6-47.8z"]],
    "user-tie": [448, 512, [], "f508", ["M24 512l168 0c-8.8 0-16.8-4.8-21-12.5L102.7 375C69.6 398.2 48 436.6 48 480l0 8c0 13.3-10.7 24-24 24zM144 128a80 80 0 1 0 160 0 80 80 0 1 0 -160 0zM256 512l168 0c-13.3 0-24-10.7-24-24l0-8c0-43.4-21.6-81.8-54.7-105L277 499.5c-4.2 7.7-12.3 12.5-21 12.5z", "M224 208a80 80 0 1 0 0-160 80 80 0 1 0 0 160zm128-80a128 128 0 1 1 -256 0 128 128 0 1 1 256 0zM193.5 304l61 0c9.7 0 17.5 7.8 17.5 17.5 0 4.2-1.5 8.2-4.2 11.4l-27.4 32 18.4 68.2 56.2-102.5C321 319.5 334.7 315 346.1 320.3 406.2 348.3 448 409.2 448 480l0 8c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-8c0-43.4-21.6-81.8-54.7-105L277 499.5c-4.2 7.7-12.3 12.5-21 12.5l-64 0c-8.8 0-16.8-4.8-21-12.5L102.7 375C69.6 398.2 48 436.6 48 480l0 8c0 13.3-10.7 24-24 24S0 501.3 0 488l0-8c0-70.8 41.8-131.7 101.9-159.7 11.5-5.3 25.1-.9 31.2 10.2l55.9 102 18.5-67.8-27.2-31.8c-2.7-3.2-4.2-7.2-4.2-11.4 0-9.7 7.8-17.5 17.5-17.5z"]],
    "square-bitcoin": [448, 512, [], "e6f2", ["M48 96l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16zm88 64c0-13.3 10.7-24 24-24l16 0 0-16c0-8.8 7.2-16 16-16s16 7.2 16 16l0 16 16 0 0-16c0-8.8 7.2-16 16-16s16 7.2 16 16l0 16.4c36 4 64 34.5 64 71.6 0 14.5-4.3 28-11.6 39.3 16.8 13.2 27.6 33.7 27.6 56.7 0 39.8-32.2 72-72 72l-8 0 0 16c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-16-16 0 0 16c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-16-13.9 0c-14.4 0-26.1-11.7-26.1-26.1L136 160zm48 24l0 48 64 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-64 0zm0 96l0 48 80 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0z", "M64 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm192 8c8.8 0 16 7.2 16 16l0 16 16 0 0-16c0-8.8 7.2-16 16-16s16 7.2 16 16l0 16.4c36 4 64 34.5 64 71.6 0 14.5-4.3 28-11.6 39.3 16.8 13.2 27.6 33.7 27.6 56.7 0 39.8-32.2 72-72 72l-8 0 0 16c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-16-16 0 0 16c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-16-13.9 0c-14.4 0-26.1-11.7-26.1-26.1L136 160c0-13.3 10.7-24 24-24l16 0 0-16c0-8.8 7.2-16 16-16zm-8 80l0 48 64 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-64 0zm0 96l0 48 80 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0z"]],
    "ellipsis": [448, 512, ["ellipsis-h"], "f141", ["", "M448 256a48 48 0 1 1 -96 0 48 48 0 1 1 96 0zm-176 0a48 48 0 1 1 -96 0 48 48 0 1 1 96 0zM48 304a48 48 0 1 1 0-96 48 48 0 1 1 0 96z"]],
    "arrow-turn-down-left": [512, 512, [], "e2e1", ["", "M464 88c0-13.3 10.7-24 24-24s24 10.7 24 24l0 96c0 53-43 96-96 96l-334.1 0 95 95c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0L7 273c-4.5-4.5-7-10.6-7-17s2.5-12.5 7-17L143 103c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-95 95 334.1 0c26.5 0 48-21.5 48-48l0-96z"]],
    "octagon-check": [512, 512, [], "e426", ["M48.5 181.6l133.5-133.5 148.8 0 133.5 133.5 0 148.8-133.5 133.5-148.8 0-133.5-133.5 0-148.8zm103.1 97.6c-9.4 9.4-9.4 24.6 0 33.9L207.5 369c5 5 11.9 7.5 18.8 6.9s13.4-4.1 17.5-9.8L366 198.2c7.8-10.7 5.4-25.7-5.3-33.5-10.7-7.8-25.7-5.4-33.5 5.3l-105.6 145.2-36-36c-9.4-9.4-24.6-9.4-33.9 0z", "M330.9 .1c12.7 0 25 5.1 34 14.1L498.3 147.6c9 9 14.1 21.2 14.1 33.9l0 148.8c0 12.7-5.1 25-14.1 34L364.8 497.9c-9 9-21.2 14.1-34 14.1l-148.8 0c-12.7 0-24.9-5.1-33.9-14.1L14.6 364.4c-9-9-14.1-21.2-14.1-34l0-148.8c0-12.7 5.1-24.9 14.1-33.9L148.1 14.1c9-9 21.2-14.1 33.9-14.1l148.8 0zM48.5 181.6l0 148.8 133.5 133.5 148.8 0 133.5-133.5 0-148.8-133.5-133.5-148.8 0-133.5 133.5zm278.7-11.6c7.8-10.7 22.8-13.1 33.5-5.3 10.7 7.8 13.1 22.8 5.3 33.5L243.9 366.1c-4.1 5.7-10.5 9.3-17.5 9.8s-13.9-2-18.8-6.9l-55.9-55.9c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l36 36 105.6-145.2z"]],
    "store-24": [576, 512, [], "e79b", ["M56.8 150.4L75.2 97.8C78.9 87.1 89 80 100.3 80l25.6 0-8.4 83.8c-1.6 16-15.1 28.2-31.1 28.2-21.6 0-36.7-21.3-29.5-41.6zM80.4 368l192 0 0 64-168 0c-13.3 0-24-10.7-24-24l0-40zm86.1-212.3l7.6-75.7 58.3 0 0 79c0 18.2-14.8 33-33 33-19.5 0-34.8-16.9-32.8-36.3zM280.4 80l58.3 0 7.6 75.7c1.9 19.4-13.3 36.3-32.8 36.3-18.2 0-33-14.8-33-33l0-79zm106.5 0l25.6 0c11.3 0 21.3 7.1 25.1 17.8L456 150.4c7.1 20.4-8 41.6-29.5 41.6-16.1 0-29.5-12.2-31.1-28.2L386.9 80z", "M100.3 32C68.6 32 40.4 52 29.9 81.9L11.5 134.5c-11 31.5-1 63.9 20.9 84.4l0 189.2c0 39.8 32.2 72 72 72l168 0 0-48-168 0c-13.3 0-24-10.7-24-24l0-40 192 0c0-19.1 8.4-36.3 21.7-48l-213.7 0 0-80.2c2 .1 3.9 .2 6 .2 21.8 0 41.8-8.9 56.2-23.3 14.6 14.4 34.6 23.3 56.9 23.3 22.2 0 42.4-9 57-23.5 14.6 14.5 34.8 23.5 57 23.5 22.3 0 42.3-8.9 56.9-23.3 14.4 14.5 34.3 23.3 56.2 23.3 2 0 4-.1 5.9-.2l0 64.2 48 0 0-85.2c21.9-20.4 31.9-52.8 20.9-84.4L482.9 81.9C472.5 52 444.2 32 412.5 32L100.3 32zM232.4 80l0 79c0 18.2-14.8 33-33 33-19.5 0-34.8-16.9-32.8-36.3l7.6-75.7 58.3 0zm48 0l58.3 0 7.6 75.7c1.9 19.4-13.3 36.3-32.8 36.3-18.2 0-33-14.8-33-33l0-79zm106.5 0l25.6 0c11.3 0 21.3 7.1 25.1 17.8L456 150.4c7.1 20.4-8 41.6-29.5 41.6-16.1 0-29.5-12.2-31.1-28.2L386.9 80zM117.5 163.8c-1.6 16-15.1 28.2-31.1 28.2-21.6 0-36.7-21.3-29.5-41.6L75.2 97.8C78.9 87.1 89 80 100.3 80l25.6 0-8.4 83.8zM316.4 400c0 11 9 20 20 20s20-9 20-20c0-6.6 5.4-12 12-12s12 5.4 12 12l0 1c0 4.8-1.8 9.4-4.9 13l-52.5 59.1c-4.2 4.7-6.5 10.8-6.5 17.1 0 14.2 11.5 25.8 25.8 25.8l58.2 0c11 0 20-9 20-20s-9-20-20-20l-26.6 0 31.5-35.5c9.7-10.9 15-25 15-39.6l0-1c0-28.7-23.3-52-52-52s-52 23.3-52 52zm128 32c0 5.3 2.1 10.4 5.9 14.1s8.8 5.9 14.1 5.9l44 0 0 44c0 11 9 20 20 20s20-9 20-20l0-128c0-11-9-20-20-20s-20 9-20 20l0 44-24 0 0-44c0-11-9-20-20-20s-20 9-20 20l0 64z"]],
    "store-slash": [576, 512, [], "e071", ["M145.8 80l118.2 0 0 79c0 10.7-5.1 20.2-12.9 26.2L145.8 80zM312 80l58.3 0 7.6 75.7c1.9 19.4-13.3 36.3-32.8 36.3-18.2 0-33-14.8-33-33l0-79zm106.5 0l25.6 0c11.3 0 21.3 7.1 25.1 17.8l18.4 52.6c7.1 20.4-8 41.6-29.5 41.6-16.1 0-29.5-12.2-31.1-28.2L418.5 80zm15.3 288l30.2 0 0 30.2-30.2-30.2z", "M41-24.9c-9.4-9.4-24.6-9.4-33.9 0S-2.3-.3 7 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-64-64c4.5-9.4 7-20 7-31.1l0-189.2c21.9-20.4 31.9-52.8 20.9-84.4L514.5 81.9C504 52 475.8 32 444.1 32L131.9 32c-10 0-19.6 2-28.4 5.6L41-24.9zM145.8 80l118.2 0 0 79c0 10.7-5.1 20.2-12.9 26.2L145.8 80zM285.1 219.3c1-.9 1.9-1.8 2.9-2.7 14.6 14.5 34.8 23.5 57 23.5 22.3 0 42.3-8.9 56.9-23.3 14.4 14.5 34.3 23.3 56.2 23.3 2 0 4-.1 5.9-.2l0 80.2-78.2 0-100.7-100.7zM433.8 368l30.2 0 0 30.2-30.2-30.2zM410.2 480l-48-48-226.2 0c-13.3 0-24-10.7-24-24l0-40 186.2 0-48-48-138.2 0 0-80.2c2 .1 3.9 .2 6 .2 14.9 0 28.9-4.1 40.9-11.3l-36.9-36.9c-1.3 .2-2.6 .3-4 .3-19.3 0-33.5-17.1-31.1-35.3l-38.2-38.2-5.6 16c-11 31.5-1 63.9 20.9 84.4L64 408c0 39.8 32.2 72 72 72l274.2 0zM312 80l58.3 0 7.6 75.7c1.9 19.4-13.3 36.3-32.8 36.3-18.2 0-33-14.8-33-33l0-79zm106.5 0l25.6 0c11.3 0 21.3 7.1 25.1 17.8l18.4 52.6c7.1 20.4-8 41.6-29.5 41.6-16.1 0-29.5-12.2-31.1-28.2L418.5 80z"]],
    "percent": [448, 512, [62101, 62785, "percentage"], "25", ["M48 128a48 48 0 1 0 96 0 48 48 0 1 0 -96 0zM304 384a48 48 0 1 0 96 0 48 48 0 1 0 -96 0z", "M96 80a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm0 144a96 96 0 1 0 0-192 96 96 0 1 0 0 192zM352 336a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm0 144a96 96 0 1 0 0-192 96 96 0 1 0 0 192zM441 73c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0L7 439c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0L441 73z"]],
    "circle-n": [512, 512, [], "e118", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm112-88c0-10.1 6.4-19.2 15.9-22.6s20.2-.4 26.6 7.4L304 276.8 304 168c0-13.3 10.7-24 24-24s24 10.7 24 24l0 176c0 10.1-6.4 19.2-15.9 22.6s-20.2 .4-26.6-7.4L208 235.2 208 344c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-176z", "M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM202.6 152.8c-6.4-7.9-17.1-10.8-26.6-7.4S160 157.9 160 168l0 176c0 13.3 10.7 24 24 24s24-10.7 24-24l0-108.8 101.4 124c6.4 7.9 17.1 10.8 26.6 7.4S352 354.1 352 344l0-176c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 108.8-101.4-124z"]],
    "file-zipper": [384, 512, ["file-archive"], "f1c6", ["M48 64l0 384c0 8.8 7.2 16 16 16l256 0c8.8 0 16-7.2 16-16l0-240-88 0c-39.8 0-72-32.2-72-72l0-88-112 0c-8.8 0-16 7.2-16 16zm32 40c0-13.3 10.7-24 24-24l16 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-16 0c-13.3 0-24-10.7-24-24zm0 80c0-13.3 10.7-24 24-24l32 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-32 0c-13.3 0-24-10.7-24-24zm0 88c0-17.7 14.3-32 32-32l32 0c17.7 0 32 14.3 32 32l0 48c0 26.5-21.5 48-48 48s-48-21.5-48-48l0-48z", "M64 48l112 0 0 88c0 39.8 32.2 72 72 72l88 0 0 240c0 8.8-7.2 16-16 16L64 464c-8.8 0-16-7.2-16-16L48 64c0-8.8 7.2-16 16-16zM224 67.9l92.1 92.1-68.1 0c-13.3 0-24-10.7-24-24l0-68.1zM64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-261.5c0-17-6.7-33.3-18.7-45.3L242.7 18.7C230.7 6.7 214.5 0 197.5 0L64 0zM80 104c0 13.3 10.7 24 24 24l16 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-16 0c-13.3 0-24 10.7-24 24zm0 80c0 13.3 10.7 24 24 24l32 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-32 0c-13.3 0-24 10.7-24 24zm64 56l-32 0c-17.7 0-32 14.3-32 32l0 48c0 26.5 21.5 48 48 48s48-21.5 48-48l0-48c0-17.7-14.3-32-32-32zm-16 64a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"]],
    "trash-can-xmark": [448, 512, [], "e2ae", ["M80 144l0 304c0 8.8 7.2 16 16 16l256 0c8.8 0 16-7.2 16-16l0-304-288 0zm76.1 76.1c9.4-9.4 24.6-9.4 33.9 0l33.9 33.9 33.9-33.9c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-33.9 33.9 33.9 33.9c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-33.9-33.9-33.9 33.9c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l33.9-33.9-33.9-33.9c-9.4-9.4-9.4-24.6 0-33.9z", "M166.2-16c-13.3 0-25.3 8.3-30 20.8L120 48 24 48C10.7 48 0 58.7 0 72S10.7 96 24 96l400 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-96 0-16.2-43.2C307.1-7.7 295.2-16 281.8-16L166.2-16zM32 144l0 304c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-304-48 0 0 304c0 8.8-7.2 16-16 16L96 464c-8.8 0-16-7.2-16-16l0-304-48 0zm259.9 76.1c-9.4-9.4-24.6-9.4-33.9 0l-33.9 33.9-33.9-33.9c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l33.9 33.9-33.9 33.9c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l33.9-33.9 33.9 33.9c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-33.9-33.9 33.9-33.9c9.4-9.4 9.4-24.6 0-33.9z"]],
    "display": [512, 512, [], "e163", ["M48 96l0 256c0 8.8 7.2 16 16 16l384 0c8.8 0 16-7.2 16-16l0-256c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16zM220.3 464l71.3 0-8-48-55.3 0-8 48z", "M64 80c-8.8 0-16 7.2-16 16l0 256c0 8.8 7.2 16 16 16l384 0c8.8 0 16-7.2 16-16l0-256c0-8.8-7.2-16-16-16L64 80zM0 96C0 60.7 28.7 32 64 32l384 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64l-115.7 0 8 48 51.7 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-272 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l51.7 0 8-48-115.7 0c-35.3 0-64-28.7-64-64L0 96zM228.3 416l-8 48 71.3 0-8-48-55.3 0z"]],
    "ellipsis-stroke": [512, 512, ["ellipsis-h-alt"], "f39b", ["M104 256a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm176 0a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm176 0a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M56 256a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm88 0a64 64 0 1 1 -128 0 64 64 0 1 1 128 0zm112-24a24 24 0 1 0 0 48 24 24 0 1 0 0-48zm0 88a64 64 0 1 1 0-128 64 64 0 1 1 0 128zm176-88a24 24 0 1 0 0 48 24 24 0 1 0 0-48zm0 88a64 64 0 1 1 0-128 64 64 0 1 1 0 128z"]],
    "air-conditioner": [576, 512, [], "f8f4", ["M48 128l0 128c0 8.8 7.2 16 16 16l448 0c8.8 0 16-7.2 16-16l0-128c0-8.8-7.2-16-16-16L64 112c-8.8 0-16 7.2-16 16zm48 72c0-13.3 10.7-24 24-24l336 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-336 0c-13.3 0-24-10.7-24-24z", "M64 112c-8.8 0-16 7.2-16 16l0 128c0 8.8 7.2 16 16 16l448 0c8.8 0 16-7.2 16-16l0-128c0-8.8-7.2-16-16-16L64 112zM0 128C0 92.7 28.7 64 64 64l448 0c35.3 0 64 28.7 64 64l0 128c0 35.3-28.7 64-64 64L64 320c-35.3 0-64-28.7-64-64L0 128zm120 48l336 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-336 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zm88 296l0-104 48 0 0 104c0 39.8-32.2 72-72 72s-72-32.2-72-72c0-13.3 10.7-24 24-24s24 10.7 24 24 10.7 24 24 24 24-10.7 24-24zM368 368l0 104c0 13.3 10.7 24 24 24s24-10.7 24-24 10.7-24 24-24 24 10.7 24 24c0 39.8-32.2 72-72 72s-72-32.2-72-72l0-104 48 0z"]],
    "file-xls": [576, 512, [], "e64d", ["M80 64c0-8.8 7.2-16 16-16l112 0 0 88c0 39.8 32.2 72 72 72l88 0 0 128-96 0c-35.3 0-64 28.7-64 64l0 64-112 0c-8.8 0-16-7.2-16-16L80 64z", "M208 48L96 48c-8.8 0-16 7.2-16 16l0 384c0 8.8 7.2 16 16 16l112 0 0 48-112 0c-35.3 0-64-28.7-64-64L32 64C32 28.7 60.7 0 96 0L229.5 0c17 0 33.3 6.7 45.3 18.7L397.3 141.3c12 12 18.7 28.3 18.7 45.3l0 149.5-48 0 0-128-88 0c-39.8 0-72-32.2-72-72l0-88zM348.1 160L256 67.9 256 136c0 13.3 10.7 24 24 24l68.1 0zM292 400c0 6.5 1.9 12.8 5.5 18.2l6.5 9.7 6.5-9.7c3.6-5.4 5.5-11.7 5.5-18.2 0-11 9-20 20-20s20 9 20 20c0 14.4-4.3 28.4-12.2 40.4L328 464 343.8 487.6c8 12 12.2 26 12.2 40.4 0 11-9 20-20 20s-20-9-20-20c0-6.5-1.9-12.8-5.5-18.2l-6.5-9.7-6.5 9.7c-3.6 5.4-5.5 11.7-5.5 18.2 0 11-9 20-20 20s-20-9-20-20c0-14.4 4.3-28.4 12.2-40.4L280 464 264.2 440.4c-8-12-12.2-26-12.2-40.4 0-11 9-20 20-20s20 9 20 20zM400 548c-11 0-20-9-20-20l0-128c0-11 9-20 20-20s20 9 20 20l0 108 12 0c11 0 20 9 20 20s-9 20-20 20l-32 0zm76-116c0-28.7 23.3-52 52-52l24 0c11 0 20 9 20 20s-9 20-20 20l-24 0c-6.6 0-12 5.4-12 12s5.4 12 12 12c28.7 0 52 23.3 52 52s-23.3 52-52 52l-32 0c-11 0-20-9-20-20s9-20 20-20l32 0c6.6 0 12-5.4 12-12s-5.4-12-12-12c-28.7 0-52-23.3-52-52z"]],
    "pinata": [512, 512, [], "e3c3", ["M48 104.3c0 15.3 8.6 29.2 22.2 36l60.5 30.2 2.9 1.7C140.1 176.7 144 184 144 192l0 37.6 12.1-7.9 5.1-2.8c10.5-4.7 22.7-4 32.6 1.8l4.8 3.3 18.7 15.3 26.8-17.5 5.1-2.8c10.5-4.7 22.7-4 32.6 1.8l4.8 3.3 18.7 15.3 26.8-17.5 5.1-2.8c10.5-4.7 22.7-4 32.6 1.8l4.8 3.3 18.7 15.3 26.8-17.5 5.1-2.8c10-4.5 21.5-4 31.2 1-9.7-16.7-27.7-27.9-48.4-27.9l-144 0c-13.3 0-24-10.7-24-24l0-136c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 8-.1 2.5C206.6 54.6 196.4 64 184 64L88.3 64C66 64 48 82 48 104.3zM192 120a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zM144 277.4l0 40.2 12.1-7.9 5.1-2.8c10.5-4.7 22.7-4 32.6 1.8l4.8 3.3 18.7 15.3 26.8-17.5 5.1-2.8c10.5-4.7 22.7-4 32.6 1.8l4.8 3.3 18.7 15.3 26.8-17.5 5.1-2.8c10.5-4.7 22.7-4 32.6 1.8l4.8 3.3 18.7 15.3 26.8-17.5 5.1-2.8c10.5-4.7 22.7-4 32.6 1.8l4.8 3.3 1.4 1.1 0-36.3-24.4-20-26.8 17.6c-11.5 7.5-26.1 7.8-37.8 1l-4.8-3.3-18.7-15.3-26.8 17.6c-11.5 7.5-26.1 7.8-37.8 1l-4.8-3.3-18.7-15.3-26.8 17.6c-11.5 7.5-26.1 7.8-37.7 1l-4.8-3.3-18.7-15.3-31.6 20.7zm0 88l0 82.6c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-40c0-13.3 10.7-24 24-24l144 0c13.3 0 24 10.7 24 24l0 40c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-83.3-24.4-20-26.8 17.6c-11.5 7.5-26.1 7.8-37.8 1l-4.8-3.3-18.7-15.3-26.8 17.6c-11.5 7.5-26.1 7.8-37.8 1l-4.8-3.3-18.7-15.3-26.8 17.6c-11.5 7.5-26.1 7.8-37.7 1l-4.8-3.3-18.7-15.3-31.6 20.7z", "M224-32c35.3 0 64 28.7 64 64l0 112 120 0c57.4 0 104 46.6 104 104l0 200c0 35.3-28.7 64-64 64l-32 0c-35.3 0-64-28.7-64-64l0-16-96 0 0 16c0 35.3-28.7 64-64 64l-32 0c-35.3 0-64-28.7-64-64l0-241.2-47.2-23.6C18.9 168.3 0 137.7 0 104.3 0 55.5 39.5 16 88.3 16l73.8 0c7.1-27.6 32.1-48 61.9-48zM412.8 362.3c-11.5 7.5-26.1 7.8-37.8 1l-4.8-3.3-18.7-15.3-26.8 17.6c-11.5 7.5-26.1 7.8-37.8 1l-4.8-3.3-18.7-15.3-26.8 17.6c-11.5 7.5-26.1 7.8-37.7 1l-4.8-3.3-18.7-15.3-31.6 20.7 0 82.6c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-40c0-13.3 10.7-24 24-24l144 0c13.3 0 24 10.7 24 24l0 40c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-83.3-24.4-20-26.8 17.6zm0-88c-11.5 7.5-26.1 7.8-37.8 1l-4.8-3.3-18.7-15.3-26.8 17.6c-11.5 7.5-26.1 7.8-37.8 1l-4.8-3.3-18.7-15.3-26.8 17.6c-11.5 7.5-26.1 7.8-37.7 1l-4.8-3.3-18.7-15.3-31.6 20.7 0 40.2 12.1-7.9 5.1-2.8c10.5-4.7 22.7-4 32.6 1.8l4.8 3.3 18.7 15.3 26.8-17.5 5.1-2.8c10.5-4.7 22.7-4 32.6 1.8l4.8 3.3 18.7 15.3 26.8-17.5 5.1-2.8c10.5-4.7 22.7-4 32.6 1.8l4.8 3.3 18.7 15.3 26.8-17.5 5.1-2.8c10.5-4.7 22.7-4 32.6 1.8l4.8 3.3 1.4 1.1 0-36.3-24.4-20-26.8 17.6zM224 16c-8.8 0-16 7.2-16 16l0 8-.1 2.5C206.6 54.6 196.4 64 184 64L88.3 64c-22.2 0-40.3 18-40.3 40.3 0 15.3 8.6 29.2 22.2 36l60.5 30.2 2.9 1.7C140.1 176.7 144 184 144 192l0 37.6 12.1-7.9 5.1-2.8c10.5-4.7 22.7-4 32.6 1.8l4.8 3.3 18.7 15.3 26.8-17.5 5.1-2.8c10.5-4.7 22.7-4 32.6 1.8l4.8 3.3 18.7 15.3 26.8-17.5 5.1-2.8c10.5-4.7 22.7-4 32.6 1.8l4.8 3.3 18.7 15.3 26.8-17.5 5.1-2.8c10-4.5 21.5-4 31.2 1-9.7-16.7-27.7-27.9-48.4-27.9l-144 0c-13.3 0-24-10.7-24-24l0-136c0-8.8-7.2-16-16-16zM168 144a24 24 0 1 1 0-48 24 24 0 1 1 0 48z"]],
    "chart-fft": [512, 512, [], "e69e", ["M48 304l72 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l56 0c10.2 0 19.4-6.5 22.7-16.2l60.7-176.2 38.9 82.6c4 8.4 12.4 13.8 21.7 13.8l66.2 0 49.1 84.1c6.7 11.4 21.4 15.3 32.8 8.6 7.5-4.4 11.8-12.2 11.9-20.4l0 103.6-400 0c-17.7 0-32-14.3-32-32l0-96z", "M48 56c0-13.3-10.7-24-24-24S0 42.7 0 56L0 400c0 44.2 35.8 80 80 80l408 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L80 432c-17.7 0-32-14.3-32-32L48 56zM277.7 85.8c-4.2-8.8-13.3-14.3-23-13.7s-18.2 6.9-21.4 16.1L158.9 304 120 304c-13.3 0-24 10.7-24 24s10.7 24 24 24l56 0c10.2 0 19.4-6.5 22.7-16.2l60.7-176.2 38.9 82.6c4 8.4 12.4 13.8 21.7 13.8l66.2 0 49.1 84.1c6.7 11.4 21.4 15.3 32.8 8.6s15.3-21.4 8.6-32.8l-56-96c-4.3-7.4-12.2-11.9-20.7-11.9l-64.8 0-57.5-122.2z"]],
    "circle-user-circle-exclamation": [640, 512, [], "e7a0", ["M80 256c0-114.9 93.1-208 208-208 98.4 0 180.8 68.3 202.5 160.1-75.1 2.1-139.4 47.4-169 111.9l-1.4 0-64 0c-53.5 0-99.4 32.9-118.5 79.6-35.6-37.3-57.5-87.9-57.5-143.6zm120-56a88 88 0 1 0 176 0 88 88 0 1 0 -176 0z", "M306.7 368c2.8-16.8 7.8-32.9 14.8-48l-1.4 0-64 0c-53.5 0-99.4 32.9-118.5 79.6-35.6-37.3-57.5-87.9-57.5-143.6 0-114.9 93.1-208 208-208 98.4 0 180.8 68.3 202.5 160.1 1.8-.1 3.7-.1 5.5-.1 15.3 0 30.2 1.8 44.4 5.2-20.4-121-125.6-213.2-252.4-213.2-141.4 0-256 114.6-256 256S146.6 512 288 512c16.7 0 33-1.6 48.8-4.6-9.3-13.8-16.9-28.9-22.4-45-8.6 1.1-17.4 1.7-26.3 1.7-40.6 0-78.4-11.6-110.5-31.7 7.3-36.7 39.7-64.3 78.5-64.3l50.7 0zM288 240a40 40 0 1 1 0-80 40 40 0 1 1 0 80zm-88-40a88 88 0 1 0 176 0 88 88 0 1 0 -176 0zM496 544a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm0-100a20 20 0 1 1 0 40 20 20 0 1 1 0-40zm0-140c8.8 0 16 7.2 16 16l0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80c0-8.8 7.2-16 16-16z"]],
    "phone-intercom": [512, 512, [], "e434", ["M48 96c0-8.8 7.2-16 16-16l48 0c8.8 0 16 7.2 16 16l0 320c0 8.8-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16L48 96zm128 0c0-8.8 7.2-16 16-16l256 0c8.8 0 16 7.2 16 16l0 320c0 8.8-7.2 16-16 16l-256 0c-8.8 0-16-7.2-16-16l0-320zm40 240a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm8-172.8l0 57.6c0 19.4 15.8 35.2 35.2 35.2l121.6 0c19.4 0 35.2-15.8 35.2-35.2l0-57.6c0-19.4-15.8-35.2-35.2-35.2l-121.6 0c-19.4 0-35.2 15.8-35.2 35.2zM296 336a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm80 0a24 24 0 1 0 48 0 24 24 0 1 0 -48 0z", "M64 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l48 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80zm88 386c-11 8.8-24.9 14-40 14l-48 0c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l48 0c15.1 0 29 5.3 40 14 11-8.8 24.9-14 40-14l256 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64l-256 0c-15.1 0-29-5.3-40-14zM176 96l0 320c0 8.8 7.2 16 16 16l256 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L192 80c-8.8 0-16 7.2-16 16zm40 240a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm104-24a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm56 24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM259.2 128l121.6 0c19.4 0 35.2 15.8 35.2 35.2l0 57.6c0 19.4-15.8 35.2-35.2 35.2l-121.6 0c-19.4 0-35.2-15.8-35.2-35.2l0-57.6c0-19.4 15.8-35.2 35.2-35.2z"]],
    "turn-left-up": [384, 512, [], "e638", ["M102.6 144l33.4 0c13.3 0 24 10.7 24 24l0 184c0 61.9 50.1 112 112 112l64 0 0-64-80 0c-17.7 0-32-14.3-32-32l0-200c0-13.3 10.7-24 24-24l33.4 0-89.4-89.4-89.4 89.4z", "M192 54.6l89.4 89.4-33.4 0c-13.3 0-24 10.7-24 24l0 200c0 17.7 14.3 32 32 32l80 0 0 64-64 0c-61.9 0-112-50.1-112-112l0-184c0-13.3-10.7-24-24-24l-33.4 0 89.4-89.4zM214.6 9.4c-12.5-12.5-32.8-12.5-45.3 0l-128 128c-9.2 9.2-11.9 22.9-6.9 34.9l0 0c5 12 16.6 19.8 29.6 19.8l48 0 0 160c0 88.4 71.6 160 160 160l80 0c17.7 0 32-14.3 32-32l0-96c0-17.7-14.3-32-32-32l-80 0 0-160 48 0c12.9 0 24.6-7.8 29.6-19.8l0 0c5-12 2.2-25.7-6.9-34.9l-128-128 0 0z"]],
    "scarf": [512, 512, [129507], "f7c1", ["M144.5 104c0-30.9 25.1-56 56-56l112 0c30.9 0 56 25.1 56 56l0 78.9c0 14.7-5.8 28.7-16 39.2l-70.1-70.1 6.1 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-25.4 0c-35.6 0-53.5 43.1-28.3 68.3l83.7 83.7-62.1 62.1-95.6-95.6c-10.5-10.5-16.4-24.7-16.4-39.6l0-78.9z", "M144.5 104c0-30.9 25.1-56 56-56l112 0c30.9 0 56 25.1 56 56l0 78.9c0 14.7-5.8 28.7-16 39.2l-70.1-70.1 6.1 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-25.4 0c-35.6 0-53.5 43.1-28.3 68.3l83.7 83.7-62.1 62.1-95.6-95.6c-10.5-10.5-16.4-24.7-16.4-39.6l0-78.9zm112 281.9l119 119c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-119-119 14.1-14.1 119 119c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-119-119 14.1-14.1 119 119c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-119-119c19.3-19.5 30.1-45.7 30.1-73.1l0-78.9c0-57.4-46.6-104-104-104l-112 0c-57.4 0-104 46.6-104 104l0 78.9c0 27.6 11 54 30.5 73.5 74 74 117.2 117.2 129.5 129.5zm-163.9-96L7.5 375c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l85.1-85.1-33.9-33.9zm48 48L55.5 423c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l85.1-85.1-33.9-33.9zm48 48L103.5 471c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l85.1-85.1-33.9-33.9z"]],
    "message-pen": [512, 512, ["comment-alt-edit", "message-edit"], "f4a4", ["M48 128c0-26.5 21.5-48 48-48l320 0c26.5 0 48 21.5 48 48l0 224c0 26.5-21.5 48-48 48l-120.4 0c-9.9 0-19.6 3.1-27.7 8.8L176 473.7 176 424c0-13.3-10.7-24-24-24l-56 0c-26.5 0-48-21.5-48-48l0-224zm96 209.8c0 7.9 6.4 14.2 14.2 14.2 1.2 0 2.3-.1 3.5-.4l49.4-12.3c8.4-2.1 16.1-6.5 22.3-12.6L354.7 205.3c8.5-8.5 13.3-20 13.3-32 0-25-20.3-45.3-45.3-45.3-12 0-23.5 4.8-32 13.3L169.4 262.6c-6.2 6.2-10.5 13.9-12.6 22.3l-12.3 49.4c-.3 1.1-.4 2.3-.4 3.5z", "M48 128c0-26.5 21.5-48 48-48l320 0c26.5 0 48 21.5 48 48l0 224c0 26.5-21.5 48-48 48l-120.4 0c-9.9 0-19.6 3.1-27.7 8.8L176 473.7 176 424c0-13.3-10.7-24-24-24l-56 0c-26.5 0-48-21.5-48-48l0-224zM96 32C43 32 0 75 0 128L0 352c0 53 43 96 96 96l32 0 0 72c0 9 5 17.2 13 21.3s17.6 3.5 24.9-1.7L295.6 448 416 448c53 0 96-43 96-96l0-224c0-53-43-96-96-96L96 32zm48.4 302.3c-.3 1.1-.4 2.3-.4 3.5 0 7.9 6.4 14.2 14.2 14.2 1.2 0 2.3-.1 3.5-.4l49.4-12.3c8.4-2.1 16.1-6.5 22.3-12.6L354.7 205.3c8.5-8.5 13.3-20 13.3-32 0-25-20.3-45.3-45.3-45.3-12 0-23.5 4.8-32 13.3L169.4 262.6c-6.2 6.2-10.5 13.9-12.6 22.3l-12.3 49.4z"]],
    "icons": [512, 512, ["heart-music-camera-bolt"], "f86d", ["M48 67l0 6.1c0 8.2 6.9 24.3 28.5 46.6 16.4 16.9 36 32 51.5 42.7 15.5-10.7 35.1-25.8 51.5-42.7 21.6-22.3 28.5-38.4 28.5-46.6l0-6.1c0-10.5-8.5-19-19-19-9.1 0-14.4 2.7-19.6 7.4-5.3 4.8-9.7 10.7-16 19.3-1.8 2.5-3.8 5.2-6.1 8.2-4.5 6-11.6 9.6-19.2 9.6S113.3 89 108.8 83c-2.4-3.3-4.6-6.2-6.5-8.9-6.1-8.3-10.3-14.1-15.5-18.8-5.1-4.6-10.4-7.4-19.7-7.4-10.5 0-19 8.5-19 19zm0 285l0 96c0 8.8 7.2 16 16 16l160 0c8.8 0 16-7.2 16-16l0-96c0-8.8-7.2-16-16-16-18.2 0-34.8-10.3-42.9-26.5l-2.7-5.5-68.7 0-2.7 5.5c-8.1 16.3-24.8 26.5-42.9 26.5-8.8 0-16 7.2-16 16zm136 40a40 40 0 1 1 -80 0 40 40 0 1 1 80 0z", "M147.2 83c2.2-3 4.3-5.7 6.1-8.2l0 0c6.3-8.6 10.7-14.5 16-19.3 5.2-4.7 10.5-7.4 19.6-7.4 10.5 0 19 8.5 19 19l0 6.1c0 8.2-6.9 24.3-28.5 46.6-16.4 16.9-36 32-51.5 42.7-15.5-10.7-35.1-25.8-51.5-42.7-21.6-22.3-28.5-38.4-28.5-46.6L48 67c0-10.5 8.5-19 19-19 9.3 0 14.6 2.7 19.7 7.4 5.2 4.7 9.4 10.4 15.5 18.8l0 0c2 2.7 4.1 5.6 6.5 8.9 4.5 6 11.6 9.6 19.2 9.6S142.7 89 147.2 83zM189 0c-22.3 0-38.7 8-51.8 19.8-3.2 2.9-6.2 6.1-9.1 9.4-2.9-3.3-5.9-6.5-9-9.3-13.1-11.8-29.6-19.8-52-19.8-37 0-67 30-67 67l0 6.1c0 56.1 75.2 112.1 110.3 135.3 10.8 7.1 24.5 7.1 35.3 0 35.1-23.1 110.3-79.2 110.3-135.3l0-6.1c0-37-30-67-67-67zM512 24c0-7.2-3.2-14-8.8-18.6s-12.9-6.4-19.9-5l-160 32C312.1 34.7 304 44.6 304 56l0 105.5c-5.1-1-10.5-1.5-16-1.5-35.3 0-64 21.5-64 48s28.7 48 64 48 64-21.5 64-48l0-132.3 112-22.4 0 76.2c-5.1-1-10.5-1.5-16-1.5-35.3 0-64 21.5-64 48s28.7 48 64 48 64-21.5 64-48l0-152zM106.9 309.5l2.7-5.5 68.7 0 2.7 5.5c8.1 16.3 24.8 26.5 42.9 26.5 8.8 0 16 7.2 16 16l0 96c0 8.8-7.2 16-16 16L64 464c-8.8 0-16-7.2-16-16l0-96c0-8.8 7.2-16 16-16 18.2 0 34.8-10.3 42.9-26.5zM224 288l-7.2-14.3c-5.4-10.8-16.5-17.7-28.6-17.7l-88.4 0c-12.1 0-23.2 6.9-28.6 17.7L64 288c-35.3 0-64 28.7-64 64l0 96c0 35.3 28.7 64 64 64l160 0c35.3 0 64-28.7 64-64l0-96c0-35.3-28.7-64-64-64zM184 392a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zM473.4 259.1c-6-4.4-14.3-4-19.9 .9l-128 112c-5 4.4-6.8 11.4-4.4 17.7s8.3 10.4 15 10.4l55.7 0-38.4 89.7c-2.9 6.9-.7 14.9 5.3 19.2s14.3 4 19.9-.9l128-112c5-4.4 6.8-11.4 4.4-17.7S502.7 368 496 368l-55.7 0 38.4-89.7c2.9-6.9 .7-14.9-5.3-19.2z"]],
    "file-xml": [640, 512, [], "e654", ["M112 64c0-8.8 7.2-16 16-16l112 0 0 88c0 39.8 32.2 72 72 72l88 0 0 128-128 0c-35.3 0-64 28.7-64 64l0 64-80 0c-8.8 0-16-7.2-16-16l0-384z", "M240 48L128 48c-8.8 0-16 7.2-16 16l0 384c0 8.8 7.2 16 16 16l80 0 0 48-80 0c-35.3 0-64-28.7-64-64L64 64C64 28.7 92.7 0 128 0L261.5 0c17 0 33.3 6.7 45.3 18.7L429.3 141.3c12 12 18.7 28.3 18.7 45.3l0 149.5-48 0 0-128-88 0c-39.8 0-72-32.2-72-72l0-88zM380.1 160L288 67.9 288 136c0 13.3 10.7 24 24 24l68.1 0zM544 532l0-128c0-11 9-20 20-20s20 9 20 20l0 108 12 0c11 0 20 9 20 20s-9 20-20 20l-32 0c-11 0-20-9-20-20zM421.1 393.7l30.9 51.4 30.9-51.4c4.6-7.7 13.8-11.4 22.5-9S520 395 520 404l0 128c0 11-9 20-20 20s-20-9-20-20l0-55.8-10.9 18.1c-3.6 6-10.1 9.7-17.1 9.7s-13.5-3.7-17.1-9.7L424 476.2 424 532c0 11-9 20-20 20s-20-9-20-20l0-128c0-9 6-16.9 14.7-19.3s17.9 1.3 22.5 9zM296 404c0 6.5 1.9 12.8 5.5 18.2l6.5 9.7 6.5-9.7c3.6-5.4 5.5-11.7 5.5-18.2 0-11 9-20 20-20s20 9 20 20c0 14.4-4.3 28.4-12.2 40.4L332 468 347.8 491.6c8 12 12.2 26 12.2 40.4 0 11-9 20-20 20s-20-9-20-20c0-6.5-1.9-12.8-5.5-18.2l-6.5-9.7-6.5 9.7c-3.6 5.4-5.5 11.7-5.5 18.2 0 11-9 20-20 20s-20-9-20-20c0-14.4 4.3-28.4 12.2-40.4L284 468 268.2 444.4c-8-12-12.2-26-12.2-40.4 0-11 9-20 20-20s20 9 20 20z"]],
    "ruler-vertical": [256, 512, [], "f548", ["M48 16l0 480 160 0 0-48-40 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l40 0 0-64-72 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l72 0 0-64-40 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l40 0 0-64-72 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l72 0 0-48-160 0z", "M48 496l0-480 160 0 0 48-72 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l72 0 0 64-40 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l40 0 0 64-72 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l72 0 0 64-40 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l40 0 0 48-160 0zM0 496c0 26.5 21.5 48 48 48l160 0c26.5 0 48-21.5 48-48l0-480c0-26.5-21.5-48-48-48L48-32C21.5-32 0-10.5 0 16L0 496z"]],
    "map-location-dot": [640, 512, ["map-marked-alt"], "f5a0", ["M112 127.2l96-45.2 0 299-96 45.2 0-299zM234.6 27.1c1.8 0 3.6 .2 5.4 .8l178.1 59.4-1.6 .8-172.5-58.7c-3.1-1-6.2-1.8-9.4-2.3zM256 84.2l128 43.5 0 106.7c-24.9 28.8-40 66.3-40 107.4 0 27.5 7.1 54.3 16.9 78.5l-104.9-35 0-301.1zM432 134l96-47.4 0 90.1c-5.3-.5-10.6-.7-16-.7-28.9 0-56.1 7.2-80 20l0-62z", "M576 48c0-8.3-4.3-16-11.3-20.4s-15.9-4.8-23.3-1.1L416.5 88.1 244 29.4c-13.7-4.7-28.7-3.8-41.9 2.3L77.8 90.3C69.4 94.2 64 102.7 64 112l0 352c0 8.2 4.2 15.9 11.1 20.3s15.6 4.9 23.1 1.4l127.3-59.9 167.3 55.8c-1.9-3-3.8-6-5.6-9.1-9.4-15.6-18.8-33.3-26.3-52.1l-104.9-35 0-301.1 128 43.5 0 106.7c13.4-15.6 29.7-28.6 48-38.4l0-62 96-47.4 0 90.1c16.8 1.6 32.9 5.6 48 11.7L576 48zM208 82.1l0 299-96 45.2 0-299 96-45.2zM512 224c-66.3 0-120 52.8-120 117.9 0 68.9 64.1 150.4 98.6 189.3 11.6 13 31.3 13 42.9 0 34.5-38.9 98.6-120.4 98.6-189.3 0-65.1-53.7-117.9-120-117.9zM472 344a40 40 0 1 1 80 0 40 40 0 1 1 -80 0z"]],
    "watermelon-slice": [512, 512, [], "e337", ["M115.4 350.6c28 21 62.9 33.4 100.6 33.4 92.8 0 168-75.2 168-168 0-37.7-12.4-72.6-33.4-100.6l-26.3 26.3 15 15c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-15-15-57.4 57.4 15 15c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-15-15-57.4 57.4 15 15c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-15-15-26.3 26.3zm113.3-41.9c6.2-6.2 16.4-6.2 22.6 0l16 16c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-16-16c-6.2-6.2-6.2-16.4 0-22.6zm80-80c6.2-6.2 16.4-6.2 22.6 0l16 16c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-16-16c-6.2-6.2-6.2-16.4 0-22.6z", "M0 408c0-6.4 2.5-12.5 7-17L391 7c9.4-9.4 24.6-9.4 33.9 0 115.6 115.6 116 302.6 .3 418.3S122.6 540.5 7 425c-4.5-4.5-7-10.6-7-17zm58.7-.8c97.4 80.4 241.5 75.3 332.6-15.8s96.2-235.2 15.8-332.6L384.8 81.2c29.6 37 47.2 83.8 47.2 134.8 0 119.3-96.7 216-216 216-51 0-97.9-17.7-134.8-47.2L58.7 407.2zM384 216c0-37.7-12.4-72.6-33.4-100.6l-26.3 26.3 15 15c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-15-15-57.4 57.4 15 15c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-15-15-57.4 57.4 15 15c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-15-15-26.3 26.3c28 21 62.9 33.4 100.6 33.4 92.8 0 168-75.2 168-168zm-52.7 12.7l16 16c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-16-16c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0zm-80 80l16 16c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-16-16c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0z"]],
    "jack-o-lantern": [512, 512, [127875], "f30e", ["M48 304c0 44.9 12.2 83.3 29.4 109.1 17.4 26.2 36.3 34.9 50.6 34.9 7.2 0 14.7-2 22.6-6.7 25.4-15.1 57.3-15.1 82.7 0 7.9 4.7 15.5 6.7 22.6 6.7s14.7-2 22.6-6.7c25.4-15.1 57.3-15.1 82.7 0 7.9 4.7 15.5 6.7 22.6 6.7 14.3 0 33.1-8.7 50.6-34.9 17.2-25.8 29.4-64.3 29.4-109.1s-12.2-83.3-29.4-109.1c-17.4-26.2-36.3-34.9-50.6-34.9-7.2 0-14.7 2-22.6 6.7-25.4 15.1-57.3 15.1-82.7 0-7.9-4.7-15.5-6.7-22.6-6.7s-14.7 2-22.6 6.7c-25.4 15.1-57.3 15.1-82.7 0-7.9-4.7-15.5-6.7-22.6-6.7-14.3 0-33.1 8.7-50.6 34.9-17.2 25.8-29.4 64.3-29.4 109.1zm74.1 18.6c-5-11 6.1-21 17.8-18 30.2 7.8 64.1 12.6 100 13.7l0 9.7c0 8.8 7.2 16 16 16s16-7.2 16-16l0-9.7c35.9-1.1 69.8-6 100-13.7 11.8-3 22.9 6.9 17.8 18-10.6 23.3-29.6 43.1-53.8 56.9l0-3.4c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 17c-15 4.5-31.2 6.9-48 6.9-16.8 0-33-2.4-48-6.9l0-17.1c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 3.5c-24.2-13.8-43.2-33.6-53.9-56.9zm34.6-57.3c-2.2-4.2-2-9.2 .6-13.1l25.6-38.4c2.4-3.6 6.4-5.7 10.7-5.7s8.3 2.1 10.7 5.7l25.6 38.4c2.6 3.9 2.9 9 .6 13.1s-6.6 6.8-11.3 6.8L168 272c-4.7 0-9.1-2.6-11.3-6.8zm124.8 0c-2.2-4.2-2-9.2 .6-13.1l25.6-38.4c2.4-3.6 6.4-5.7 10.6-5.7s8.3 2.1 10.6 5.7l25.6 38.4c2.6 3.9 2.9 9 .6 13.1S348.7 272 344 272l-51.2 0c-4.7 0-9.1-2.6-11.3-6.8z", "M232.5 64l47 0 23.6 61.4C288.6 116.8 272.6 112 256 112s-32.6 4.8-47.1 13.4L232.5 64zM191.6 36.5l-31.4 81.6c-10.3-4-21.1-6.1-32.2-6.1-70.7 0-128 86-128 192S57.3 496 128 496c16.7 0 32.6-4.8 47.2-13.5 10.3-6.1 23.4-6.1 33.7 0 14.6 8.7 30.5 13.5 47.2 13.5s32.6-4.8 47.2-13.5c10.3-6.1 23.4-6.1 33.7 0 14.6 8.7 30.5 13.5 47.2 13.5 70.7 0 128-86 128-192S454.7 112 384 112c-11.1 0-21.9 2.1-32.2 6.1L320.4 36.5C315.6 24.2 303.7 16 290.5 16l-69 0c-13.2 0-25.1 8.2-29.9 20.5zM128 448c-14.3 0-33.1-8.7-50.6-34.9-17.2-25.8-29.4-64.3-29.4-109.1s12.2-83.3 29.4-109.1c17.4-26.2 36.3-34.9 50.6-34.9 7.2 0 14.7 2 22.6 6.7 25.4 15.1 57.3 15.1 82.7 0 7.9-4.7 15.5-6.7 22.6-6.7s14.7 2 22.6 6.7c25.4 15.1 57.3 15.1 82.7 0 7.9-4.7 15.5-6.7 22.6-6.7 14.3 0 33.1 8.7 50.6 34.9 17.2 25.8 29.4 64.3 29.4 109.1s-12.2 83.3-29.4 109.1c-17.4 26.2-36.3 34.9-50.6 34.9-7.2 0-14.7-2-22.6-6.7-25.4-15.1-57.3-15.1-82.7 0-7.9 4.7-15.5 6.7-22.6 6.7s-14.7-2-22.6-6.7c-25.4-15.1-57.3-15.1-82.7 0-7.9 4.7-15.5 6.7-22.6 6.7zm76.3-234.3c-2.4-3.6-6.4-5.7-10.7-5.7s-8.3 2.1-10.7 5.7l-25.6 38.4c-2.6 3.9-2.9 9-.6 13.1s6.6 6.8 11.3 6.8l51.2 0c4.7 0 9.1-2.6 11.3-6.8s2-9.2-.6-13.1l-25.6-38.4zM318.4 208c-4.3 0-8.3 2.1-10.6 5.7l-25.6 38.4c-2.6 3.9-2.9 9-.6 13.1s6.6 6.8 11.3 6.8l51.2 0c4.7 0 9.1-2.6 11.3-6.8s2-9.2-.6-13.1L329 213.7c-2.4-3.6-6.4-5.7-10.6-5.7zM140 304.6c-11.8-3-22.9 7-17.8 18 10.6 23.3 29.6 43.1 53.9 56.9l0-3.5c0-8.8 7.2-16 16-16s16 7.2 16 16l0 17.1c15 4.5 31.1 6.9 48 6.9 16.8 0 33-2.4 48-6.9l0-17c0-8.8 7.2-16 16-16s16 7.2 16 16l0 3.4c24.2-13.8 43.2-33.6 53.8-56.9 5-11-6.1-21-17.8-18-30.2 7.8-64.1 12.6-100 13.7l0 9.7c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-9.7c-35.9-1.1-69.8-5.9-100-13.7z"]],
    "candy": [640, 512, [127852], "e3e7", ["M160.2 256c0 88.4 71.6 160 160 160 29.2 0 56.5-7.8 80.1-21.4L160.2 256zm80-138.6L480.2 256c0-88.3-71.6-160-160-160-29.1 0-56.5 7.8-80 21.4z", "M400.3 394.6l-240.1-138.6 0 0c0 88.4 71.6 160 160 160 29.2 0 56.5-7.8 80.1-21.4zM440 362.1c14.1-15.9 25.1-34.7 32-55.4L200.5 149.9c-14.1 15.9-25.1 34.7-32 55.4L440 362.1zM240.2 117.4L480.2 256c0-88.3-71.6-160-160-160-29.1 0-56.5 7.8-80 21.4zM528.2 256c0 114.9-93.1 208-208 208-39.6 0-76.5-11-108-30.2L180.1 539.2c-3.5 11.4-14.7 18.5-26.5 16.8s-20.5-11.8-20.5-23.7l0-41.9-28.3 12.9c-9.1 4.1-19.8 2.2-26.9-4.9s-9-17.8-4.9-26.9l12.9-28.3-41.9 0c-11.9 0-22-8.7-23.7-20.5s5.4-23 16.8-26.5L142.4 364c-19.2-31.5-30.2-68.5-30.2-108 0-114.9 93.1-208 208-208 39.6 0 76.5 11 108 30.2L460.3-27.2c3.5-11.4 14.7-18.5 26.5-16.8s20.5 11.8 20.5 23.7l0 41.9 28.3-12.9c9.1-4.1 19.8-2.2 26.9 4.9s9 17.8 4.9 26.9l-12.9 28.3 41.9 0c11.9 0 22 8.7 23.7 20.5s-5.4 23-16.7 26.5L498 148c19.2 31.5 30.2 68.5 30.2 108z"]],
    "heart-crack": [512, 512, [128148, "heart-broken"], "f7a9", ["M48 165.1c0 49.9 32 98.4 68.1 142.3 41.1 50 91.4 94 125.9 120.3 3.2 2.4 7.9 4.2 14 4.2s10.8-1.8 14-4.2c34.5-26.3 84.8-70.4 125.9-120.3 36.2-43.9 68.1-92.4 68.1-142.3 0-47-38.1-85.1-85.1-85.1-27.3 0-53 13.1-69 35.2l-3.9 5.4 13.2 27.9c1.8 3.8 .4 8.2-3.2 10.3l-88.9 51.9 59.7 97c2.1 3.4 1.4 7.8-1.7 10.4s-7.6 2.4-10.5-.3l-112-104c-1.6-1.5-2.5-3.5-2.6-5.7s.8-4.3 2.3-5.8l59.6-59.6-19.9-27.5c-16-22.1-41.7-35.2-69-35.2-47 0-85.1 38.1-85.1 85.1z", "M309.9 115.2l-3.9 5.4 13.2 27.9c1.8 3.8 .4 8.2-3.2 10.3l-88.9 51.9 59.7 97c2.1 3.4 1.4 7.8-1.7 10.4s-7.6 2.4-10.5-.3l-112-104c-1.6-1.5-2.5-3.5-2.6-5.7s.8-4.3 2.3-5.8l59.6-59.6-19.9-27.5c-16-22.1-41.7-35.2-69-35.2-47 0-85.1 38.1-85.1 85.1 0 49.9 32 98.4 68.1 142.3 41.1 50 91.4 94 125.9 120.3 3.2 2.4 7.9 4.2 14 4.2s10.8-1.8 14-4.2c34.5-26.3 84.8-70.4 125.9-120.3 36.2-43.9 68.1-92.4 68.1-142.3 0-47-38.1-85.1-85.1-85.1-27.3 0-53 13.1-69 35.2zM270.5 87.7l.5-.6c25-34.6 65.2-55.1 107.9-55.1 73.5 0 133.1 59.6 133.1 133.1 0 68.6-42.9 128.9-79.1 172.8-44.1 53.6-97.3 100.1-133.8 127.9-12.3 9.4-27.5 14.1-43.1 14.1s-30.8-4.7-43.1-14.1C176.4 438 123.2 391.5 79.1 338 42.9 294.1 0 233.7 0 165.1 0 91.6 59.6 32 133.1 32 175.8 32 216 52.5 241 87.1l7.4 10.2 6.8 4.6 15.3-14.1z"]],
    "cow": [640, 512, [128004], "f6c8", ["M144 152l0 248 32 0 0-64c0-53 43-96 96-96s96 43 96 96l0 64 32 0 0-192c0-10 6.2-18.9 15.5-22.4s19.8-1 26.5 6.5l64 72c3.9 4.4 6.1 10.1 6.1 15.9l0 49 38.5 60.6c4.1 6.5 11.3 10.4 19 10.4 12.4 0 22.5-10.1 22.5-22.5l0-102.6c0-1.8-.6-3.5-1.7-4.9L489.8 140c-13.6-17.6-34.7-28-57-28l-50.5 0c-3.1 14.5-10.3 28-21 38.6l-7.4 7.4C332.2 179.8 302.7 192 272 192s-60.2-12.2-81.9-33.9l-7.4-7.4c-9.2-9.2-15.9-20.5-19.5-32.8-11.5 7-19.2 19.7-19.2 34.1zM576 320a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M72 184c0-23 10.7-43.4 27.5-56.6-2.3 7.8-3.5 16.1-3.5 24.6l0 248c0 26.5 21.5 48 48 48l32 0c26.5 0 48-21.5 48-48l0-21.4c2.5 .6 5.2 1.2 8 1.7l0 11.6c0 8.8 7.2 16 16 16s16-7.2 16-16l0-8.1c2.6 .1 5.3 .1 8 .1s5.4 0 8-.1l0 8.1c0 8.8 7.2 16 16 16s16-7.2 16-16l0-11.6c2.8-.5 5.5-1.1 8-1.7l0 21.4c0 26.5 21.5 48 48 48l32 0c26.5 0 48-21.5 48-48l0-128.9 16 18 0 46.9c0 4.6 1.3 9 3.8 12.9l42.3 66.5c12.9 20.3 35.4 32.6 59.5 32.6 38.9 0 70.5-31.6 70.5-70.5l0-102.6c0-12.4-4.1-24.4-11.7-34.2l-4.3-5.6 0-67.1c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 5-48.2-62.4C505.1 81.2 470 64 432.9 64L144 64C77.7 64 24 117.7 24 184l0 54C9.4 249.8 0 267.8 0 288l0 17.6c0 8 6.4 14.4 14.4 14.4 31.8 0 57.6-25.8 57.6-57.6L72 184zm91.2-66.1c3.6 12.3 10.3 23.6 19.5 32.8l7.4 7.4C211.8 179.8 241.3 192 272 192s60.2-12.2 81.9-33.9l7.4-7.4c10.7-10.7 17.9-24.1 21-38.6l50.5 0c22.3 0 43.3 10.3 57 28L590.3 270c1.1 1.4 1.7 3.1 1.7 4.9l0 102.6c0 12.4-10.1 22.5-22.5 22.5-7.7 0-14.8-3.9-19-10.4L512 329 512 280c0-5.9-2.2-11.6-6.1-15.9l-64-72c-6.6-7.4-17.2-10-26.5-6.5S400 198 400 208l0 192-32 0 0-64c0-53-43-96-96-96s-96 43-96 96l0 64-32 0 0-248c0-14.5 7.7-27.1 19.2-34.1zm62.4 211.4l-1.1-.4C228 305.7 247.9 288 272 288s44 17.7 47.5 40.9l-1.1 .4c-9.7 3.2-25.1 6.8-46.4 6.8s-36.7-3.5-46.4-6.8zM576 320a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"]],
    "rss": [448, 512, ["feed"], "f09e", ["M48 416a16 16 0 1 0 32 0 16 16 0 1 0 -32 0z", "M0 56c0-13.3 10.7-24 24-24 234.2 0 424 189.8 424 424 0 13.3-10.7 24-24 24s-24-10.7-24-24C400 248.3 231.7 80 24 80 10.7 80 0 69.3 0 56zM64 432a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm0-80a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM24 176c154.6 0 280 125.4 280 280 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-128.1-103.9-232-232-232-13.3 0-24-10.7-24-24s10.7-24 24-24z"]],
    "magnifying-glass": [512, 512, [128269, "search"], "f002", ["M48 208a160 160 0 1 0 320 0 160 160 0 1 0 -320 0z", "M368 208a160 160 0 1 0 -320 0 160 160 0 1 0 320 0zM337.1 371.1C301.7 399.2 256.8 416 208 416 93.1 416 0 322.9 0 208S93.1 0 208 0 416 93.1 416 208c0 48.8-16.8 93.7-44.9 129.1L505 471c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0L337.1 371.1z"]],
    "objects-align-left": [512, 512, [], "e3be", ["M176 112l0 64 288 0 0-64-288 0zm0 224l0 64 160 0 0-64-160 0z", "M0 24C0 10.7 10.7 0 24 0S48 10.7 48 24l0 464c0 13.3-10.7 24-24 24S0 501.3 0 488L0 24zM176 176l288 0 0-64-288 0 0 64zm-48-64c0-26.5 21.5-48 48-48l288 0c26.5 0 48 21.5 48 48l0 64c0 26.5-21.5 48-48 48l-288 0c-26.5 0-48-21.5-48-48l0-64zm48 288l160 0 0-64-160 0 0 64zm-48-64c0-26.5 21.5-48 48-48l160 0c26.5 0 48 21.5 48 48l0 64c0 26.5-21.5 48-48 48l-160 0c-26.5 0-48-21.5-48-48l0-64z"]],
    "cloud-moon": [640, 512, [], "f6c3", ["M80 416c0 26.5 21.5 48 48 48l264 0c22.1 0 39.9-17.9 39.9-40 0-22.1-17.9-40-40-40-8.1 0-15.5-2.5-20.7-9-4.7-5.9-6.4-13.7-4.5-21 .8-3.2 1.3-6.5 1.3-10 0-22.1-17.9-40-40-40-12.6 0-23.8 5.8-31.1 14.9-5.8 7.1-15.1 10.4-24.1 8.3s-15.9-9.1-18-18c-4.9-21.3-24-37.2-46.8-37.2-26.5 0-48 21.5-48 48 0 5.9 1.1 11.5 3 16.7 3 8.1 1.4 17.1-4.1 23.7s-14.1 9.8-22.6 8.3c-2.7-.5-5.5-.7-8.3-.7-26.5 0-48 21.5-48 48z", "M480 0c-106 0-192 86-192 192 0 2.8 .1 5.6 .2 8.4 4.7 3.1 9.1 6.5 13.4 10.2 8.5-1.7 17.4-2.6 26.4-2.6 61.7 0 113.7 41 130.4 97.3 28.9 16.2 51.3 42.7 62.2 74.4 35.4-7.6 67.2-25 92.4-49.2 5.5-5.3 7.1-13.4 3.9-20.4s-10.3-11.2-17.8-10.6c-3.7 .3-7.4 .4-11.1 .4-76.2 0-138-61.8-138-138 0-54.1 31.1-101 76.6-123.6 6.8-3.4 10.8-10.7 9.8-18.3S529.9 6.4 522.5 4.7C508.8 1.6 494.6 0 480 0zM160 320c0-26.5 21.5-48 48-48 22.8 0 41.9 15.9 46.8 37.2 2.1 8.9 9 15.9 18 18s18.3-1.2 24.1-8.3c7.4-9.1 18.6-14.9 31.1-14.9 22.1 0 40 17.9 40 40 0 3.5-.4 6.8-1.3 10-1.9 7.3-.2 15.1 4.5 21 5.2 6.5 12.7 9 20.7 9 22.1 0 40 17.9 40 40 0 22.1-17.9 40-39.9 40l-264 0c-26.5 0-48-21.5-48-48s21.5-48 48-48c2.9 0 5.6 .2 8.3 .7 8.5 1.5 17.1-1.7 22.6-8.3s7-15.6 4.1-23.7c-1.9-5.2-3-10.8-3-16.7zm127.3-54.1c-17.3-25.3-46.3-41.9-79.3-41.9-53.5 0-96.7 44-96 97.3-45.4 7.6-80 47.1-80 94.7 0 53 43 96 96 96l264 0c48.6-.1 87.9-39.4 87.9-88 0-40.3-27.1-74.3-64.1-84.7-2.5-46.4-40.9-83.3-87.9-83.3-14.7 0-28.5 3.6-40.6 9.9z"]],
    "abacus": [576, 512, [129518], "f640", ["M48 96l0 112 80 0 0-32-8 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l8 0 0-48-64 0c-8.8 0-16 7.2-16 16zm0 144l0 176c0 8.8 7.2 16 16 16l64 0 0-48-8 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l8 0 0-24-8 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l8 0 0-24-80 0zM160 80l0 48 8 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-8 0 0 32 96 0 0-32-8 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l8 0 0-48-96 0zm0 160l0 24 8 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-8 0 0 24 8 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-8 0 0 48 96 0 0-48-8 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l8 0 0-24-8 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l8 0 0-24-96 0zM288 80l0 48 8 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-8 0 0 32 128 0 0-32-8 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l8 0 0-48-128 0zm0 160l0 24 8 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-8 0 0 24 8 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-8 0 0 48 128 0 0-48-8 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l8 0 0-96-128 0zM448 80l0 48 8 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-8 0 0 32 80 0 0-112c0-8.8-7.2-16-16-16l-64 0zm0 160l0 96 8 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-8 0 0 48 64 0c8.8 0 16-7.2 16-16l0-176-80 0z", "M512 80c8.8 0 16 7.2 16 16l0 112-80 0 0-32 8 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-8 0 0-48 64 0zm-96 48l-8 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l8 0 0 32-128 0 0-32 8 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-8 0 0-48 128 0 0 48zm-160 0l-8 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l8 0 0 32-96 0 0-32 8 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-8 0 0-48 96 0 0 48zm-128 0l-8 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l8 0 0 32-80 0 0-112c0-8.8 7.2-16 16-16l64 0 0 48zM48 416l0-176 80 0 0 24-8 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l8 0 0 24-8 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l8 0 0 48-64 0c-8.8 0-16-7.2-16-16zm112-32l8 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-8 0 0-24 8 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-8 0 0-24 96 0 0 24-8 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l8 0 0 24-8 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l8 0 0 48-96 0 0-48zm128-72l8 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-8 0 0-24 128 0 0 96-8 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l8 0 0 48-128 0 0-48 8 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-8 0 0-24zm160 72l8 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-8 0 0-96 80 0 0 176c0 8.8-7.2 16-16 16l-64 0 0-48zM64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l448 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32z"]],
    "boxes-stacked": [512, 512, [62625, "boxes", "boxes-alt"], "f468", ["M48 288l0 160c0 8.8 7.2 16 16 16l160 0c8.8 0 16-7.1 16-15.9 0-53.4 0-106.7 0-160.1-.1-8.9-7.2-16-16-16l-32 0 0 56c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-56-32 0c-8.8 0-16 7.2-16 16zM160 64l0 112 192 0 0-112c0-8.8-7.2-16-16-16l-32 0 0 56c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-56-32 0c-8.8 0-16 7.2-16 16zM334.9 464L448 464c8.8 0 16-7.2 16-16l0-160c0-8.8-7.2-16-16-16l-32 0 0 56c0 13.3-10.7 24-24 24l-48 0c-2.8 0-5.5-.5-8-1.4l0 97.4c0 5.4-.4 10.8-1.1 16z", "M336 48c8.8 0 16 7.2 16 16l0 112 48 0 0-112c0-35.3-28.7-64-64-64L176 0c-35.3 0-64 28.7-64 64l0 112 48 0 0-112c0-8.8 7.2-16 16-16l32 0 0 56c0 13.3 10.7 24 24 24l48 0c13.3 0 24-10.7 24-24l0-56 32 0zM315.9 512L448 512c35.3 0 64-28.7 64-64l0-160c0-35.3-28.7-64-64-64l-132.1 0c12.7 18.1 20.1 40.2 20.1 64l0 62.6c2.5 .9 5.2 1.4 8 1.4l48 0c13.3 0 24-10.7 24-24l0-56 32 0c8.8 0 16 7.2 16 16l0 160c0 8.8-7.2 16-16 16l-113.1 0c-2.5 17.7-9.2 34-18.9 48zM240 288l0 160c0 0 0 0 0 .1 0 8.8-7.2 15.9-16 15.9L64 464c-8.8 0-16-7.2-16-16l0-160c0-8.8 7.2-16 16-16l32 0 0 56c0 13.3 10.7 24 24 24l48 0c13.3 0 24-10.7 24-24l0-56 32 0c8.8 0 15.9 7.1 16 15.9l0 .1zM64 224c-35.3 0-64 28.7-64 64L0 448c0 35.3 28.7 64 64 64l160 0c35.3 0 64-28.7 64-64l0-160c0-35.3-28.7-64-64-64L64 224z"]],
    "code-branch": [448, 512, [], "f126", ["M48 80a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm0 352a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zM336 80a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M80 112a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm80-32c0 35.8-23.5 66.1-56 76.3l0 75.7 184 0c30.9 0 56-25.1 56-56l0-19.7c-32.5-10.2-56-40.5-56-76.3 0-44.2 35.8-80 80-80s80 35.8 80 80c0 35.8-23.5 66.1-56 76.3l0 19.7c0 57.4-46.6 104-104 104l-184 0 0 75.7c32.5 10.2 56 40.5 56 76.3 0 44.2-35.8 80-80 80S0 476.2 0 432c0-35.8 23.5-66.1 56-76.3l0-199.3C23.5 146.1 0 115.8 0 80 0 35.8 35.8 0 80 0s80 35.8 80 80zm240 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM80 464a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]],
    "ban": [512, 512, [128683, "cancel"], "f05e", ["M48 256c0 114.9 93.1 208 208 208 48.8 0 93.7-16.8 129.1-44.9L92.9 126.9C64.8 162.3 48 207.2 48 256zM126.9 92.9L419.1 385.1c28.1-35.5 44.9-80.3 44.9-129.1 0-114.9-93.1-208-208-208-48.8 0-93.7 16.8-129.1 44.9z", "M385.1 419.1L92.9 126.9c-28.1 35.5-44.9 80.3-44.9 129.1 0 114.9 93.1 208 208 208 48.8 0 93.7-16.8 129.1-44.9zm33.9-33.9c28.1-35.5 44.9-80.3 44.9-129.1 0-114.9-93.1-208-208-208-48.8 0-93.7 16.8-129.1 44.9L419.1 385.1zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0z"]],
    "person-carry-box": [384, 512, ["person-carry"], "f4cf", ["M48 176l0 95.4c0 10.6 4.2 20.8 11.7 28.3L80 320 80 176c0-8.8-7.2-16-16-16s-16 7.2-16 16zm192-32l0 96 96 0 0-96-96 0z", "M120 24A56 56 0 1 0 8 24 56 56 0 1 0 120 24zM64.4 112C28.8 112 0 140.8 0 176.4L0 272c0 27.7 13 53.8 35.2 70.4L112 400c10.1 7.6 16 19.4 16 32l0 88c0 13.3 10.7 24 24 24s24-10.7 24-24l0-88c0-27.7-13-53.8-35.2-70.4l-12.8-9.6 0-97.9c16.5 21.2 42.1 33.9 69.4 33.9L352 288c17.7 0 32-14.3 32-32l0-128c0-17.7-14.3-32-32-32L224 96c-17.7 0-32 14.3-32 32l0 111.6c-12.3-1.7-23.2-9-29.4-20l-42.1-74.8C109.1 124.5 87.6 112 64.4 112zM0 520c0 13.3 10.7 24 24 24s24-10.7 24-24l0-111-37-29.6c-3.9-3.1-7.6-6.4-11-9.9L0 520zM80 176l0 144-20.3-20.3C52.2 292.2 48 282 48 271.4L48 176c0-8.8 7.2-16 16-16s16 7.2 16 16zm160 64l0-96 96 0 0 96-96 0z"]],
    "circle-litecoin": [512, 512, [], "e6f4", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm96.8 5.1c-2.8-8.4 1.7-17.4 10.1-20.2l37.1-12.4 0-76.5c0-13.3 10.7-24 24-24s24 10.7 24 24l0 60.5 58.9-19.6c8.4-2.8 17.4 1.7 20.2 10.1s-1.7 17.4-10.1 20.2l-69.1 23 0 89.8 88 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-112 0c-13.3 0-24-10.7-24-24l0-97.8-26.9 9c-8.4 2.8-17.4-1.7-20.2-10.1z", "M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM216 128c-13.3 0-24 10.7-24 24l0 76.5-37.1 12.4c-8.4 2.8-12.9 11.9-10.1 20.2s11.9 12.9 20.2 10.1l26.9-9 0 97.8c0 13.3 10.7 24 24 24l112 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-88 0 0-89.8 69.1-23c8.4-2.8 12.9-11.9 10.1-20.2s-11.9-12.9-20.2-10.1L240 212.5 240 152c0-13.3-10.7-24-24-24z"]],
    "jug-detergent": [384, 512, [], "e519", ["M48 256l0 192c0 8.8 7.2 16 16 16l256 0c8.8 0 16-7.2 16-16l0-192c0-44.2-35.8-80-80-80l-128 0c-44.2 0-80 35.8-80 80zm176 0c0-17.7 14.3-32 32-32s32 14.3 32 32l0 96c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-96z", "M120 0C106.7 0 96 10.7 96 24l0 24-8 0C74.7 48 64 58.7 64 72S74.7 96 88 96l144 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-8 0 0-24c0-13.3-10.7-24-24-24L120 0zM256 176c44.2 0 80 35.8 80 80l0 192c0 8.8-7.2 16-16 16L64 464c-8.8 0-16-7.2-16-16l0-192c0-44.2 35.8-80 80-80l128 0zM128 128C57.3 128 0 185.3 0 256L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-192c0-70.7-57.3-128-128-128l-128 0zm128 96c-17.7 0-32 14.3-32 32l0 96c0 17.7 14.3 32 32 32s32-14.3 32-32l0-96c0-17.7-14.3-32-32-32z"]],
    "floppy-disk-pen": [640, 512, [], "e182", ["M112.1 96c0-8.8 7.2-16 16-16l32 0 0 96c0 17.7 14.3 32 32 32l160 0c17.7 0 32-14.3 32-32l0-89.4 75.3 75.3c3 3 4.7 7.1 4.7 11.3l0 78.7-148.2 148.2c-9.3 9.3-16.8 20-22.3 31.8l-165.5 0c-8.8 0-16-7.2-16-16l0-320zm112 224a64 64 0 1 0 128 0 64 64 0 1 0 -128 0z", "M128.1 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l165.5 0c-3.8 8.1-6.6 16.6-8.4 25.5l-4.5 22.5-152.6 0c-35.3 0-64-28.7-64-64l0-320c0-35.3 28.7-64 64-64l242.7 0c17 0 33.3 6.7 45.3 18.7L493.3 128c12 12 18.7 28.3 18.7 45.3l0 37.7c-9.3 4.8-18.1 11.2-25.9 19l-22.1 22.1 0-78.7c0-4.2-1.7-8.3-4.7-11.3l-75.3-75.3 0 89.4c0 17.7-14.3 32-32 32l-160 0c-17.7 0-32-14.3-32-32l0-96-32 0zm80 0l0 80 128 0 0-80-128 0zm16 240a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zM332.3 467c2.5-12.4 8.6-23.8 17.5-32.7l118.9-118.9 80 80-118.9 118.9c-8.9 8.9-20.3 15-32.7 17.5l-59.6 11.9c-.9 .2-1.9 .3-2.9 .3-8 0-14.6-6.5-14.6-14.6 0-1 .1-1.9 .3-2.9L332.3 467zM600.1 344l-28.8 28.8-80-80 28.8-28.8c22.1-22.1 57.9-22.1 80 0s22.1 57.9 0 80z"]],
    "lips": [640, 512, [128068, 128482], "f600", ["M78.7 256.3l64.9 82.9c37.9 48.4 96 76.7 157.5 76.7l37.7 0c61.5 0 119.6-28.3 157.5-76.7l64.9-82.9-102.4-125.1c-14.1-17.2-35.2-27.2-57.4-27.2-12.2 0-24.2 3-35 8.8l-35.2 18.8c-7.1 3.8-15.6 3.8-22.6 0l-35.2-18.8c-10.8-5.7-22.8-8.8-35-8.8-22.2 0-43.3 10-57.4 27.2L78.7 256.3zm57.4 2c-.7-7.2 1.8-14.3 6.9-19.3l64-64c6.4-6.4 15.9-8.7 24.6-5.8l88.4 29.5 88.4-29.5c8.6-2.9 18.1-.6 24.6 5.8l64 64c5.1 5.1 7.6 12.2 6.9 19.3S499.3 272 493.3 276l-47.6 31.8C410.2 331.4 368.5 344 325.9 344l-11.7 0c-42.6 0-84.3-12.6-119.8-36.3L146.7 276c-6-4-9.9-10.4-10.6-17.6z", "M238.5 56c-36.6 0-71.4 16.4-94.6 44.8L29.4 240.8c-7.1 8.7-7.2 21.1-.3 30l76.7 98.1c47 60.1 119 95.2 195.3 95.2l37.7 0c76.3 0 148.3-35.1 195.3-95.2l76.7-98.1c6.9-8.8 6.8-21.3-.3-30L496 100.8c-23.2-28.4-57.9-44.8-94.6-44.8-20.1 0-39.9 5-57.6 14.4L320 83.2 296.1 70.4C278.4 61 258.6 56 238.5 56zm-57.4 75.2c14.1-17.2 35.2-27.2 57.4-27.2 12.2 0 24.2 3 35 8.8l35.2 18.8c7.1 3.8 15.6 3.8 22.6 0l35.2-18.8c10.8-5.7 22.8-8.8 35-8.8 22.2 0 43.3 10 57.4 27.2l102.4 125.1-64.9 82.9c-37.9 48.4-96 76.7-157.5 76.7l-37.7 0c-61.5 0-119.6-28.3-157.5-76.7L78.7 256.3 181.1 131.2zm50.5 38c-8.6-2.9-18.1-.6-24.6 5.8l-64 64c-5.1 5.1-7.6 12.2-6.9 19.3s4.6 13.6 10.6 17.6l47.6 31.8c35.5 23.7 77.2 36.3 119.8 36.3l11.7 0c42.6 0 84.3-12.6 119.8-36.3L493.3 276c6-4 9.9-10.4 10.6-17.6s-1.8-14.3-6.9-19.3l-64-64c-6.4-6.4-15.9-8.7-24.6-5.8l-88.4 29.5-88.4-29.5zm-33.9 83l32.8-32.8 81.9 27.3c4.9 1.6 10.3 1.6 15.2 0l81.9-27.3 32.8 32.8-23.3 15.5c-27.6 18.4-60 28.2-93.2 28.2l-11.7 0c-33.2 0-65.6-9.8-93.2-28.2l-23.3-15.5z"]],
    "outlet": [448, 512, [], "e01c", ["M48 96l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16zM80 256c0-61.1 30.8-99.1 49.7-116.6 8.8-8.2 20.7-11.4 32.6-11.4l123.3 0c12 0 23.9 3.3 32.6 11.4 18.9 17.5 49.7 55.5 49.7 116.6s-30.8 99-49.7 116.6c-8.8 8.2-20.7 11.4-32.6 11.4l-123.3 0c-12 0-23.9-3.3-32.6-11.4-18.9-17.5-49.7-55.5-49.7-116.6z", "M64 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM80 256c0-61.1 30.8-99.1 49.7-116.6 8.8-8.2 20.7-11.4 32.6-11.4l123.3 0c12 0 23.9 3.3 32.6 11.4 18.9 17.5 49.7 55.5 49.7 116.6s-30.8 99-49.7 116.6c-8.8 8.2-20.7 11.4-32.6 11.4l-123.3 0c-12 0-23.9-3.3-32.6-11.4-18.9-17.5-49.7-55.5-49.7-116.6zm112-56c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 32c0 13.3 10.7 24 24 24s24-10.7 24-24l0-32zm112 0c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 32c0 13.3 10.7 24 24 24s24-10.7 24-24l0-32zM192 320l0 16 64 0 0-16c0-17.7-14.3-32-32-32s-32 14.3-32 32z"]],
    "reply": [512, 512, [61714, "mail-reply"], "f3e5", ["M54.6 208L176 329.4 176 264c0-13.3 10.7-24 24-24l120 0c66.2 0 122 44.7 138.8 105.5 3.3-12.4 5.2-26.2 5.2-41.5 0-70.7-57.3-128-128-128l-136 0c-13.3 0-24-10.7-24-24L176 86.6 54.6 208z", "M176 128l0 24c0 13.3 10.7 24 24 24l136 0c70.7 0 128 57.3 128 128 0 15.3-1.9 29.1-5.2 41.5-16.8-60.9-72.6-105.5-138.8-105.5l-120 0c-13.3 0-24 10.7-24 24L176 329.4 54.6 208 176 86.6 176 128zm80 160l64 0c53 0 96 43 96 96 0 17.3-4.2 30.5-9.5 40.2-1.6 2.9-3.3 5.5-5 7.9-2.6 3.5-5.3 6.4-7.7 8.6-.5 .5-1 .9-1.4 1.4-4.8 4.9-8.3 11.3-8.3 18.1 0 10.9 8.8 19.7 19.7 19.7 2.8 0 5.6-.6 8.1-1.9 2.6-1.4 6.3-3.5 10.8-6.5 2.7-1.8 5.7-3.8 8.9-6.2 3.7-2.7 7.6-5.8 11.7-9.3 30.2-25.8 68.7-74.1 68.7-152.1 0-97.2-78.8-176-176-176l-112 0 0-80c0-12.9-7.8-24.6-19.8-29.6s-25.7-2.2-34.9 6.9l-160 160c-12.5 12.5-12.5 32.8 0 45.3l160 160c9.2 9.2 22.9 11.9 34.9 6.9S224 380.9 224 368l0-80 32 0z"]],
    "sun-plant-wilt": [640, 512, [], "e57a", ["M70.4 159.9l21.3 12.9c9 5.4 13.4 16.1 10.9 26.3l-6 24.2 24.2-6 3.8-.6c8.9-.7 17.7 3.6 22.5 11.5l12.8 21.3 12.9-21.3 2.3-3.2c5.8-6.8 15.1-9.9 24-7.7l24.2 6-6-24.2c-2.5-10.2 1.9-20.8 10.9-26.3l21.3-12.9-21.3-12.9c-9-5.4-13.4-16.1-10.9-26.3l6-24.2-24.2 6c-10.2 2.5-20.9-1.9-26.3-10.9L160 70.3 147.2 91.6c-5.4 9-16.1 13.4-26.3 10.9l-24.2-6 6 24.2c2.5 10.2-1.9 20.8-10.9 26.3L70.4 159.9zM192 160a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M536 96c44.2 0 80 35.8 80 80l0 53.4c14.8 7.6 24 23.1 24 44.6 0 16.6-16 44-37.4 67.2-5.7 6.2-15.5 6.2-21.2 0-21.4-23.2-37.4-50.4-37.4-67.2 0-21.5 9.2-36.9 24-44.6l0-53.4c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 288 112 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 512c-13.2 0-24-10.7-24-24s10.7-24 24-24l432 0 0-192c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 21.4c14.8 7.6 24 23.1 24 44.6 0 16.6-16 44-37.4 67.2-5.7 6.2-15.5 6.2-21.2 0-21.4-23.2-37.4-50.4-37.4-67.2 0-21.5 9.2-36.9 24-44.6l0-21.4c0-44.2 35.8-80 80-80 11.4 0 22.2 2.4 32 6.7l0-22.7c0-44.2 35.8-80 80-80zM160.1-.2c8.4 0 16.2 4.4 20.5 11.6l24.3 40.2 45.6-11.2c8.2-2 16.8 .4 22.7 6.3s8.4 14.6 6.3 22.8l-11.3 45.6 40.3 24.3c7.2 4.3 11.6 12.1 11.6 20.5s-4.4 16.2-11.6 20.6l-40.3 24.3 11.3 45.6c2 8.2-.4 16.8-6.3 22.8-5.9 5.9-14.6 8.3-22.7 6.3l-45.6-11.3-24.3 40.2c-4.3 7.2-12.1 11.6-20.5 11.6s-16.2-4.4-20.6-11.6l-24.3-40.2-45.6 11.3c-8.2 2-16.8-.4-22.7-6.3s-8.3-14.6-6.3-22.8l11.2-45.6-40.2-24.3C4.4 176.1 0 168.3 0 159.9s4.4-16.2 11.6-20.5l40.2-24.3-11.2-45.6c-2-8.2 .4-16.8 6.3-22.8s14.6-8.3 22.7-6.3l45.6 11.2 24.3-40.2 1.8-2.6c4.5-5.7 11.4-9 18.8-9zM147.2 91.6c-5.4 9-16.1 13.4-26.3 10.9l-24.2-6 6 24.2c2.5 10.2-1.9 20.8-10.9 26.3l-21.3 12.9 21.3 12.9c9 5.4 13.4 16.1 10.9 26.3l-6 24.2 24.2-6 3.8-.6c8.9-.7 17.7 3.6 22.5 11.5l12.8 21.3 12.9-21.3 2.3-3.2c5.8-6.8 15.1-9.9 24-7.7l24.2 6-6-24.2c-2.5-10.2 1.9-20.8 10.9-26.3l21.3-12.9-21.3-12.9c-9-5.4-13.4-16.1-10.9-26.3l6-24.2-24.2 6c-10.2 2.5-20.9-1.9-26.3-10.9L160 70.3 147.2 91.6zM160 192a32 32 0 1 1 0-64 32 32 0 1 1 0 64z"]],
    "face-mask": [512, 512, [], "e37f", ["M49.4 280.4c4.8 41 21.5 78.3 46.6 108.5L96 320c0-6.4 .9-12.6 2.7-18.4L49.4 280.4zm.4-52.1l80.9 34.7c8.8-4.5 18.7-7.1 29.3-7.1l192 0c10.5 0 20.5 2.6 29.3 7.1l80.9-34.7C448.7 126.6 361.5 48 256 48S63.3 126.6 49.8 228.4zm59-22c-8-10.6-5.8-25.6 4.8-33.6L120 168c20.8-15.6 46-24 72-24l8 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-8 0c-15.6 0-30.7 5.1-43.2 14.4l-6.4 4.8c-10.6 8-25.6 5.8-33.6-4.8zM288 168c0-13.3 10.7-24 24-24l8 0c26 0 51.2 8.4 72 24l6.4 4.8c10.6 8 12.8 23 4.8 33.6s-23 12.8-33.6 4.8l-6.4-4.8C350.7 197.1 335.6 192 320 192l-8 0c-13.3 0-24-10.7-24-24zM413.3 301.6c1.8 5.8 2.7 12 2.7 18.4l0 68.9c25.1-30.1 41.8-67.5 46.6-108.5l-49.3 21.1z", "M401.6 466.6C468.3 420.4 512 343.3 512 256 512 114.6 397.4 0 256 0S0 114.6 0 256c0 87.3 43.7 164.4 110.4 210.6 16.9 27.3 47.2 45.4 81.6 45.4l128 0c34.5 0 64.7-18.2 81.6-45.4zM416 388.9l0-68.9c0-6.4-.9-12.6-2.7-18.4l49.3-21.1c-4.8 41-21.5 78.3-46.6 108.5zM256 48c105.5 0 192.7 78.6 206.2 180.4l-80.9 34.7c-8.8-4.5-18.7-7.1-29.3-7.1l-192 0c-10.5 0-20.5 2.6-29.3 7.1L49.8 228.4C63.3 126.6 150.5 48 256 48zM96 320l0 68.9c-25.1-30.1-41.8-67.5-46.6-108.5l49.3 21.1c-1.8 5.8-2.7 12-2.7 18.4zm48 0c0-8.8 7.2-16 16-16l192 0c8.8 0 16 7.2 16 16l0 96c0 26.5-21.5 48-48 48l-128 0c-26.5 0-48-21.5-48-48l0-96zM288 168c0 13.3 10.7 24 24 24l8 0c15.6 0 30.7 5.1 43.2 14.4l6.4 4.8c10.6 8 25.6 5.8 33.6-4.8s5.8-25.6-4.8-33.6L392 168c-20.8-15.6-46-24-72-24l-8 0c-13.3 0-24 10.7-24 24zm-88-24l-8 0c-26 0-51.2 8.4-72 24l-6.4 4.8c-10.6 8-12.8 23-4.8 33.6s23 12.8 33.6 4.8l6.4-4.8c12.5-9.3 27.6-14.4 43.2-14.4l8 0c13.3 0 24-10.7 24-24s-10.7-24-24-24zm-8 188c-11 0-20 9-20 20s9 20 20 20l128 0c11 0 20-9 20-20s-9-20-20-20l-128 0zm0 64c-11 0-20 9-20 20s9 20 20 20l128 0c11 0 20-9 20-20s-9-20-20-20l-128 0z"]],
    "falafel": [576, 512, [129478], "e40a", ["M61.2 342.7c2.9 11.4 2.9 23.3 0 34.7-2.1 8.2 .7 16.9 7.2 22.3 9 7.5 16 17.1 20.4 28 3.1 7.9 10.5 13.2 19 13.8 11.7 .7 23 4.4 33 10.7 7.2 4.5 16.3 4.5 23.5 0 9.9-6.3 21.2-10 33-10.7 8.5-.5 15.8-5.9 19-13.8 3.5-8.9 8.8-16.9 15.5-23.6-2.7-14.5-2.2-29.5 1.8-44-4-14.5-4.5-29.6-1.8-44-6.7-6.7-12-14.8-15.5-23.6-3.1-7.9-10.5-13.2-19-13.8-11.7-.7-23-4.4-33-10.7-7.2-4.5-16.3-4.5-23.5 0-9.9 6.3-21.2 10-33 10.7-8.5 .5-15.8 5.9-19 13.8-4.3 10.9-11.3 20.6-20.4 28-6.5 5.4-9.3 14.1-7.2 22.3zm75.3-6.7a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm32 64a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm28.7-273.3c2.9 11.4 2.9 23.3 0 34.7-1.5 5.9-.5 12 2.6 17 3.4 1.5 6.8 3.2 10 5 31.4 3.8 59.5 19.9 78.6 44.2 19.1-24.3 47.2-40.4 78.6-44.2 3.3-1.8 6.6-3.5 10-5 3.1-5 4.1-11.1 2.6-17-2.9-11.4-2.9-23.3 0-34.7 2.1-8.2-.7-16.9-7.2-22.3-9-7.5-16-17.1-20.4-28-3.1-7.9-10.5-13.2-19-13.8-11.7-.7-23-4.4-33-10.7-7.2-4.5-16.3-4.5-23.5 0-9.9 6.3-21.2 10-33 10.7-8.5 .5-15.8 5.9-19 13.8-4.3 10.9-11.3 20.5-20.4 28-6.5 5.4-9.3 14.1-7.2 22.3zm136 216c2.9 11.4 2.9 23.3 0 34.7-2.1 8.2 .7 16.9 7.2 22.3 9 7.5 16 17.1 20.4 28 3.1 7.9 10.5 13.2 19 13.8 11.7 .7 23 4.4 33 10.7 7.2 4.5 16.3 4.5 23.4 0 9.9-6.3 21.3-10 33-10.7 8.5-.5 15.8-5.9 19-13.8 4.3-10.9 11.3-20.6 20.4-28 6.5-5.4 9.3-14.1 7.2-22.3-2.9-11.4-2.9-23.3 0-34.7 2.1-8.2-.7-16.9-7.2-22.3-9-7.5-16-17.1-20.4-28-3.1-7.9-10.5-13.2-19-13.8-11.7-.7-23-4.4-33-10.7-7.2-4.5-16.3-4.5-23.4 0-9.9 6.3-21.3 10-33 10.7-8.5 .5-15.8 5.9-19 13.8-4.3 10.9-11.3 20.6-20.4 28-6.5 5.4-9.3 14.1-7.2 22.3zM424.5 400a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M251.1 11.3c-3.1 2-6.7 3.1-10.3 3.4-27 1.7-50.6 18.8-60.5 44-1.4 3.4-3.6 6.4-6.4 8.8-20.8 17.3-29.8 45-23.1 71.2 .9 3.6 .9 7.3 0 10.9-1.6 6.3-2.3 12.7-2.2 19.1 17.4-.6 35 2.7 51.3 9.9-3.1-5-4.1-11.1-2.6-17 2.9-11.4 2.9-23.3 0-34.7-2.1-8.2 .7-16.9 7.2-22.3 9-7.5 16-17.1 20.4-28 3.1-7.9 10.5-13.2 19-13.8 11.7-.7 23-4.4 33-10.7 7.2-4.5 16.3-4.5 23.5 0 9.9 6.3 21.3 10 33 10.7 8.5 .5 15.8 5.9 19 13.8 4.3 10.9 11.3 20.5 20.4 28 6.5 5.4 9.3 14.1 7.2 22.3-2.9 11.4-2.9 23.3 0 34.7 1.5 5.9 .5 12-2.6 17 16.3-7.2 33.9-10.4 51.3-9.9 .2-6.3-.5-12.7-2.2-19.1-.9-3.6-.9-7.3 0-10.9 6.7-26.2-2.3-53.9-23.1-71.2-2.8-2.3-5-5.4-6.4-8.8-10-25.1-33.5-42.3-60.5-44-3.7-.2-7.2-1.4-10.3-3.4-22.8-14.5-52-14.5-74.8 0zm210.8 216c-22.8-14.5-52-14.5-74.8 0-3.1 2-6.7 3.1-10.3 3.4-27 1.7-50.6 18.8-60.5 44-1.4 3.4-3.6 6.4-6.4 8.8-20.8 17.3-29.8 45-23.1 71.2 .9 3.6 .9 7.3 0 10.9-6.7 26.2 2.3 53.9 23.1 71.2 2.8 2.3 5 5.4 6.4 8.8 10 25.1 33.5 42.3 60.5 44 3.7 .2 7.2 1.4 10.3 3.4 22.8 14.5 52 14.5 74.8 0 3.1-2 6.7-3.1 10.3-3.4 27-1.7 50.6-18.8 60.5-44 1.4-3.4 3.6-6.4 6.4-8.8 20.8-17.3 29.8-45 23.1-71.2-.9-3.6-.9-7.3 0-10.9 6.7-26.2-2.3-53.9-23.1-71.2-2.8-2.3-5-5.4-6.4-8.8-10-25.1-33.5-42.3-60.5-44-3.7-.2-7.2-1.4-10.3-3.4zm-49.1 40.6c7.2-4.5 16.3-4.5 23.4 0 9.9 6.3 21.3 10 33 10.7 8.5 .5 15.8 5.9 19 13.8 4.3 10.9 11.3 20.6 20.4 28 6.5 5.4 9.3 14.1 7.2 22.3-2.9 11.4-2.9 23.3 0 34.7 2.1 8.2-.7 16.9-7.2 22.3-9 7.5-16 17.1-20.4 28-3.1 7.9-10.5 13.2-19 13.8-11.7 .7-23 4.4-33 10.7-7.2 4.5-16.3 4.5-23.4 0-9.9-6.3-21.3-10-33-10.7-8.5-.5-15.8-5.9-19-13.8-4.3-10.9-11.3-20.6-20.4-28-6.5-5.4-9.3-14.1-7.2-22.3 2.9-11.4 2.9-23.3 0-34.7-2.1-8.2 .7-16.9 7.2-22.3 9-7.5 16-17.1 20.4-28 3.1-7.9 10.5-13.2 19-13.8 11.7-.7 23-4.4 33-10.7zM136.5 336a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm8 88a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm256 0a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM200.2 230.6c-3.7-.2-7.2-1.4-10.3-3.4-22.8-14.5-52-14.5-74.8 0-3.1 2-6.7 3.1-10.3 3.4-27 1.7-50.6 18.8-60.5 44-1.4 3.4-3.6 6.4-6.4 8.8-20.8 17.3-29.8 45-23.1 71.2 .9 3.6 .9 7.3 0 10.9-6.7 26.2 2.3 53.9 23.1 71.2 2.8 2.3 5 5.4 6.4 8.8 10 25.1 33.5 42.3 60.5 44 3.7 .2 7.2 1.4 10.3 3.4 22.8 14.5 52 14.5 74.8 0 3.1-2 6.7-3.1 10.3-3.4 24-1.5 45.3-15.2 56.7-35.9-13.3-14-21.9-31.2-25.3-49.4-6.7 6.7-12 14.8-15.5 23.6-3.1 7.9-10.5 13.2-19 13.8-11.7 .7-23 4.4-33 10.7-7.2 4.5-16.3 4.5-23.5 0-9.9-6.3-21.2-10-33-10.7-8.5-.5-15.8-5.9-19-13.8-4.3-10.9-11.3-20.6-20.4-28-6.5-5.4-9.3-14.1-7.2-22.3 2.9-11.4 2.9-23.3 0-34.7-2.1-8.2 .7-16.9 7.2-22.3 9-7.5 16-17.1 20.4-28 3.1-7.9 10.5-13.2 19-13.8 11.7-.7 23-4.4 33-10.7 7.2-4.5 16.3-4.5 23.5 0 9.9 6.3 21.2 10 33 10.7 8.5 .5 15.8 5.9 19 13.8 3.5 8.9 8.8 16.9 15.5 23.6 3.4-18.2 12-35.4 25.3-49.4-11.4-20.7-32.7-34.4-56.7-35.9z"]],
    "tombstone-blank": [448, 512, [129702, "tombstone-alt"], "f721", ["M80 192l0 272 288 0 0-272c0-79.5-64.5-144-144-144S80 112.5 80 192z", "M368 192c0-79.5-64.5-144-144-144S80 112.5 80 192l0 272 288 0 0-272zM32 464l0-272C32 86 118 0 224 0S416 86 416 192l0 272 8 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 512c-13.3 0-24-10.7-24-24s10.7-24 24-24l8 0z"]],
    "circle-caret-up": [512, 512, ["caret-circle-up"], "f331", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm82 49.6c-3.8-8.7-2.1-18.9 4.4-25.9l104-112c4.5-4.9 10.9-7.7 17.6-7.7s13 2.8 17.6 7.7l104 112c6.5 7 8.2 17.2 4.4 25.9S369.5 320 360 320l-208 0c-9.5 0-18.2-5.7-22-14.4z", "M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm0-352c-6.7 0-13 2.8-17.6 7.7l-104 112c-6.5 7-8.2 17.2-4.4 25.9S142.5 320 152 320l208 0c9.5 0 18.2-5.7 22-14.4s2.1-18.9-4.4-25.9l-104-112c-4.5-4.9-10.9-7.7-17.6-7.7z"]],
    "lamp-street": [512, 512, [], "e1c5", ["M184.2 304l271.6 0c-19.8-55.9-73.1-96-135.8-96s-116.1 40.1-135.8 96z", "M172 48C103.5 48 48 103.5 48 172l0 316c0 13.3-10.7 24-24 24S0 501.3 0 488L0 172C0 77 77 0 172 0 263.4 0 338.2 71.4 343.7 161.4 428 171.8 495.5 236.9 509.4 320.1 512.3 337.6 497.7 352 480 352l-73.5 0c-7.5 41-43.4 72-86.5 72s-79-31-86.5-72L160 352c-17.7 0-32.3-14.4-29.4-31.9 13.9-83 80.9-147.9 164.9-158.6-5.3-63.6-58.6-113.5-123.6-113.5zM283.3 352c6.2 14.1 20.3 24 36.7 24s30.5-9.9 36.7-24l-73.3 0zm172.5-48c-19.8-55.9-73.1-96-135.8-96s-116.1 40.1-135.8 96l271.6 0z"]],
    "circle-b": [512, 512, [], "e0fd", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm128-88c0-13.3 10.7-24 24-24l68 0c37.6 0 68 30.4 68 68 0 12.7-3.5 24.7-9.6 34.8 15.6 12.5 25.6 31.6 25.6 53.2 0 37.6-30.4 68-68 68l-84 0c-13.3 0-24-10.7-24-24l0-176zm48 24l0 40 44 0c11 0 20-9 20-20s-9-20-20-20l-44 0zm0 88l0 40 60 0c11 0 20-9 20-20s-9-20-20-20l-60 0z", "M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM176 168l0 176c0 13.3 10.7 24 24 24l84 0c37.6 0 68-30.4 68-68 0-21.5-10-40.7-25.6-53.2 6.1-10.2 9.6-22.1 9.6-34.8 0-37.6-30.4-68-68-68l-68 0c-13.3 0-24 10.7-24 24zm112 44c0 11-9 20-20 20l-44 0 0-40 44 0c11 0 20 9 20 20zM224 320l0-40 60 0c11 0 20 9 20 20s-9 20-20 20l-60 0z"]],
    "butterfly": [512, 512, [], "e811", ["M48 81.8l0 81.9c0 63.7 43.8 117.2 102.9 131.9l3.1 1c6.9 2.7 12.2 8.6 14.2 15.9 2.3 8.3 0 17.3-6.2 23.4l-30.9 30.9c-7.1 7.1-11.1 16.8-11.1 26.9l.4 5.3c1.7 12.2 9.4 23 20.6 28.7 5.2 2.6 10.4 5.2 15.6 7.8 5.9 3 12.5 4.5 19.2 4.5 18.5 0 34.8-11.8 40.7-29.3l4.2-12.7 2.7-8.5c5.7-19.9 8.7-40.5 8.7-61.2l0-69.5c-.1-.7-.2-1.4-.2-2.1-2.8-95-78.3-171.8-172.8-176.6L49.8 80c-1 0-1.8 .8-1.8 1.8zM280 262.2l0 66.2c0 23.7 3.8 47.2 11.3 69.6l4.2 12.7 1.2 3.2c6.7 15.7 22.2 26.1 39.5 26.1l5-.3c4.9-.6 9.7-2 14.2-4.2l15.6-7.8c1.6-.9 3.1-1.8 4.6-2.7 8.7-6 14.5-15.4 16-25.9l.4-5.3c0-8.8-3.1-17.3-8.6-24.1l-2.5-2.8-30.9-30.9c-6.1-6.1-8.5-15-6.2-23.4s8.9-14.8 17.3-16.9C420.2 280.8 464 227.4 464 163.7l0-81.9c0-1-.8-1.8-1.8-1.8-100.6 0-182.2 81.6-182.2 182.2z", "M462.2 32C489.7 32 512 54.3 512 81.8l0 81.9c0 72.1-41.5 134.4-101.8 164.6l4.6 4.6 5.7 6.3c12.5 15.3 19.5 34.5 19.5 54.5l-.2 6.1c-2.1 30.2-20 57.2-47.3 70.8l0 0-15.6 7.8 0 0c-11 5.5-23.1 8.7-35.3 9.4l-5.3 .2c-34 0-64.6-18.9-80.2-48.2-15.6 29.3-46.2 48.2-80.2 48.2-14.1 0-28-3.3-40.6-9.6l0 0-15.6-7.8 0 0c-27.3-13.7-45.2-40.6-47.3-70.8l-.2-6.1c0-22.8 9.1-44.7 25.2-60.8l4.6-4.6C41.4 298.1 0 235.8 0 163.7L0 81.8C0 54.3 22.3 32 49.8 32l11.6 .3C146.9 36.5 219.9 87.4 255.9 160 293.6 84.1 371.8 32 462.2 32zM49.8 80c-1 0-1.8 .8-1.8 1.8l0 81.9c0 63.7 43.8 117.2 102.9 131.9l3.1 1c6.9 2.7 12.2 8.6 14.2 15.9 2.3 8.3 0 17.3-6.2 23.4l-30.9 30.9c-7.1 7.1-11.1 16.8-11.1 26.9l.4 5.3c1.7 12.2 9.4 23 20.6 28.7l0 0 15.6 7.8 0 0c6 3 12.5 4.5 19.2 4.5 18.5 0 34.8-11.8 40.7-29.3l4.2-12.7 2.7-8.5c5.7-19.9 8.7-40.5 8.7-61.2l0-69.5c-.1-.7-.2-1.4-.2-2.1-2.8-95-78.3-171.8-172.8-176.6L49.8 80zm412.4 0C361.6 80 280 161.6 280 262.2l0 66.2c0 23.7 3.8 47.2 11.3 69.6l4.2 12.7 1.2 3.2c6.7 15.7 22.2 26.1 39.5 26.1l5-.3c4.9-.6 9.7-2 14.2-4.2l15.6-7.8 0 0 4.6-2.7c8.7-6 14.5-15.4 16-25.9l.4-5.3c0-8.8-3.1-17.3-8.6-24.1l-2.5-2.8-30.9-30.9c-6.1-6.1-8.5-15-6.2-23.4s8.9-14.8 17.3-16.9C420.2 280.8 464 227.4 464 163.7l0-81.9c0-1-.8-1.8-1.8-1.8z"]],
    "bacterium": [576, 512, [], "e05a", ["M130.7 322.7c-25 25-25 65.5 0 90.5s65.5 25 90.5 0c74.7-74.7 149.3-149.3 224-224 25-25 25-65.5 0-90.5s-65.5-25-90.5 0c-74.7 74.7-149.3 149.3-224 224zM224 352a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm80-80a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M408 16c0-13.3-10.7-24-24-24S360 2.7 360 16l0 23.4c-13.9 5.3-26.9 13.5-38.2 24.5L305 47c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l16.8 16.8-30.1 30.1-16.8-16.8c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l16.8 16.8c-10 10-20 20-30.1 30.1L177 175c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l16.8 16.8-30.1 30.1-16.8-16.8c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l16.8 16.8c-11 11.3-19.2 24.3-24.5 38.2L48 328c-13.3 0-24 10.7-24 24s10.7 24 24 24l16.3 0c1.3 18.3 7.1 36.4 17.4 52.4L71 439c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l10.6-10.6c15.6 10 33.2 15.8 51 17.3l0 13.6c0 13.3 10.7 24 24 24s24-10.7 24-24l0-20.1c14.4-5.3 27.9-13.6 39.6-25L271 465c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-16.8-16.8 30.1-30.1 16.8 16.8c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-16.8-16.8c10-10 20-20 30.1-30.1L399 337c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-16.8-16.8 30.1-30.1 16.8 16.8c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-16.8-16.8c11-11.3 19.2-24.3 24.5-38.2l23.4 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-16.3 0c-1.3-18.3-7.1-36.4-17.4-52.4L505 73c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0L460.4 49.7c-16-10.3-34.1-16.1-52.4-17.4L408 16zm37.3 173.3c-74.7 74.7-149.3 149.3-224 224-25 25-65.5 25-90.5 0s-25-65.5 0-90.5c74.7-74.7 149.3-149.3 224-224 25-25 65.5-25 90.5 0s25 65.5 0 90.5zM224 352a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm48-48a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]],
    "square-7": [448, 512, [], "e25c", ["M48 96l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16zm96 72c0-13.3 10.7-24 24-24l112 0c8.3 0 16 4.3 20.4 11.4s4.8 15.9 1 23.4l-88 176c-5.9 11.9-20.3 16.7-32.2 10.7s-16.7-20.3-10.7-32.2L241.2 192 168 192c-13.3 0-24-10.7-24-24z", "M64 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm168 48l112 0c8.3 0 16 4.3 20.4 11.4s4.8 15.9 1 23.4l-88 176c-5.9 11.9-20.3 16.7-32.2 10.7s-16.7-20.3-10.7-32.2L241.2 192 168 192c-13.3 0-24-10.7-24-24s10.7-24 24-24z"]],
    "magnifying-glass-arrows-rotate": [512, 512, [], "e65e", ["M24 208c0-5.5 .2-10.9 .7-16.3 .8 .1 1.7 .2 2.5 .3l2.3 0c10.5-.5 19.9-8 22.2-18.8 15.9-71.6 79.8-125.2 156.2-125.2 39.6 0 75.9 14.4 103.8 38.2L279 119c-6.9 6.9-8.9 17.2-5.2 26.2S286.3 160 296 160l89.7 0c4.1 15.3 6.3 31.4 6.3 48 0 5.5-.2 10.9-.7 16.2-.7-.1-1.4-.2-2-.2l-3.2 0c-10.4 .7-19.4 8.1-21.8 18.8-15.9 71.7-79.8 125.2-156.2 125.2-39.6 0-75.9-14.4-103.8-38.2L137 297c6.9-6.9 8.9-17.2 5.2-26.2S129.7 256 120 256l-89.7 0c-4.1-15.3-6.3-31.4-6.3-48z", "M208 48c39.6 0 75.9 14.4 103.8 38.2L279 119c-6.9 6.9-8.9 17.2-5.2 26.2S286.3 160 296 160l96 0c13.3 0 24-10.7 24-24l0-96c0-9.7-5.8-18.5-14.8-22.2S381.9 16.2 375 23L345.8 52.2c-36.7-32.5-85-52.2-137.8-52.2-99.4 0-182.4 69.7-203.1 162.8-2.9 12.9 5.3 25.8 18.2 28.6 1.4 .3 2.7 .5 4.1 .5l2.3 0C40.1 191.5 49.4 184 51.8 173.2 67.7 101.6 131.6 48 208 48zM386 224c-10.4 .7-19.4 8.1-21.8 18.8-15.9 71.7-79.8 125.2-156.2 125.2-39.6 0-75.9-14.4-103.8-38.2L137 297c6.9-6.9 8.9-17.2 5.2-26.2S129.7 256 120 256l-96 0c-13.3 0-24 10.7-24 24l0 96c0 9.7 5.8 18.5 14.8 22.2S34.1 399.8 41 393l29.2-29.2c36.7 32.5 85 52.2 137.8 52.2 48.8 0 93.7-16.8 129.1-44.9L471 505c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9L371.1 337.1c19.2-24.2 33.1-52.8 40-84 2.9-12.9-5.3-25.8-18.2-28.6-1.2-.3-2.4-.4-3.6-.5l-3.2 0z"]],
    "square-i": [448, 512, [], "e272", ["M48 96l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16zm80 72c0-13.3 10.7-24 24-24l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0 0 128 48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l48 0 0-128-48 0c-13.3 0-24-10.7-24-24z", "M64 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm152 48l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0 0 128 48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l48 0 0-128-48 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"]],
    "standard-definition": [512, 512, ["rectangle-sd"], "e28a", ["M48 128l0 256c0 8.8 7.2 16 16 16l384 0c8.8 0 16-7.2 16-16l0-256c0-8.8-7.2-16-16-16L64 112c-8.8 0-16 7.2-16 16zm48 88c0-30.9 25.1-56 56-56l56 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-56 0c-4.4 0-8 3.6-8 8l0 8c0 4.4 3.6 8 8 8l32 0c30.9 0 56 25.1 56 56l0 8c0 30.9-25.1 56-56 56l-56 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l56 0c4.4 0 8-3.6 8-8l0-8c0-4.4-3.6-8-8-8l-32 0c-30.9 0-56-25.1-56-56l0-8zm176-32c0-13.3 10.7-24 24-24l48 0c39.8 0 72 32.2 72 72l0 48c0 39.8-32.2 72-72 72l-48 0c-13.3 0-24-10.7-24-24l0-144zm48 24l0 96 24 0c13.3 0 24-10.7 24-24l0-48c0-13.3-10.7-24-24-24l-24 0z", "M448 112c8.8 0 16 7.2 16 16l0 256c0 8.8-7.2 16-16 16L64 400c-8.8 0-16-7.2-16-16l0-256c0-8.8 7.2-16 16-16l384 0zM64 64C28.7 64 0 92.7 0 128L0 384c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L64 64zM96 216l0 8c0 30.9 25.1 56 56 56l32 0c4.4 0 8 3.6 8 8l0 8c0 4.4-3.6 8-8 8l-56 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l56 0c30.9 0 56-25.1 56-56l0-8c0-30.9-25.1-56-56-56l-32 0c-4.4 0-8-3.6-8-8l0-8c0-4.4 3.6-8 8-8l56 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-56 0c-30.9 0-56 25.1-56 56zm200-56c-13.3 0-24 10.7-24 24l0 144c0 13.3 10.7 24 24 24l48 0c39.8 0 72-32.2 72-72l0-48c0-39.8-32.2-72-72-72l-48 0zm24 144l0-96 24 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24l-24 0z"]],
    "alien-8bit": [576, 512, [128126, "alien-monster"], "f8f6", ["M112 288l0 48 352 0 0-48-8 0c-13.3 0-24-10.7-24-24l0-56-24 0c-13.3 0-24-10.7-24-24l0-8-192 0 0 8c0 13.3-10.7 24-24 24l-24 0 0 56c0 13.3-10.7 24-24 24l-8 0zm80-48c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 48c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-48zm128 0c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 48c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-48z", "M456 32c13.3 0 24 10.7 24 24l0 24-.1 2.5C478.6 94.6 468.4 104 456 104l-24 0 0 56 24 0c13.3 0 24 10.7 24 24l0 56 48 0 0-88c0-13.3 10.7-24 24-24s24 10.7 24 24l0 112c0 13.3-10.7 24-24 24l-40 0 0 72c0 13.3-10.7 24-24 24l-40 0 0 72c0 13.3-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l56 0 0-48-224 0 0 48 56 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24l0-72-40 0c-13.3 0-24-10.7-24-24l0-72-40 0c-13.3 0-24-10.7-24-24L0 152c0-13.3 10.7-24 24-24s24 10.7 24 24l0 88 48 0 0-56c0-13.3 10.7-24 24-24l24 0 0-56-24 0c-13.3 0-24-10.7-24-24l0-24c0-13.3 10.7-24 24-24s24 10.7 24 24l24 0 2.5 .1C182.6 57.4 192 67.6 192 80l0 48 192 0 0-48 .1-2.5C385.4 65.4 395.6 56 408 56l24 0c0-13.3 10.7-24 24-24zM192 184c0 13.3-10.7 24-24 24l-24 0 0 56c0 13.3-10.7 24-24 24l-8 0 0 48 352 0 0-48-8 0c-13.3 0-24-10.7-24-24l0-56-24 0c-13.3 0-24-10.7-24-24l0-8-192 0 0 8zm48 40c8.8 0 16 7.2 16 16l0 48c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-48c0-8.8 7.2-16 16-16l32 0zm128 0c8.8 0 16 7.2 16 16l0 48c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-48c0-8.8 7.2-16 16-16l32 0z"]],
    "vacuum": [640, 512, [], "e04d", ["M50.7 464c6.6-18.6 24.4-32 45.3-32l64 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L50.7 464zM432 416a48 48 0 1 1 -96 0 48 48 0 1 1 96 0zm-64 0a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm32-224c0-8.8 7.2-16 16-16 79.5 0 144 64.5 144 144l0 128c0 8.8-7.2 16-16 16l-41.3 0c6-14.8 9.3-31 9.3-48 0-65.3-48.9-119.1-112-127l0-97z", "M233.7 93.5C239.4 67 262.8 48 290 48l238 0c35.3 0 64 28.7 64 64 0 30.7-21.7 56.5-50.6 62.6-33.6-29-77.5-46.6-125.4-46.6-35.3 0-64 28.7-64 64l0 100c10.2-2.6 21-4 32-4 5.4 0 10.8 .3 16 1l0-97c0-8.8 7.2-16 16-16 79.5 0 144 64.5 144 144l0 128c0 8.8-7.2 16-16 16l-41.3 0c-7.5 18.6-19.3 35-34 48l75.3 0c35.3 0 64-28.7 64-64l0-128c0-39.5-11.9-76.1-32.3-106.6 38-17.9 64.3-56.6 64.3-101.4 0-61.9-50.1-112-112-112L290 0c-49.8 0-92.8 34.8-103.2 83.5L122.9 384 96 384c-53 0-96 43-96 96 0 17.7 14.3 32 32 32l128 0c35.3 0 64-28.7 64-64 0-31.3-22.5-57.4-52.3-62.9l62-291.5zM384 368a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm0 144a96 96 0 1 0 0-192 96 96 0 1 0 0 192zM96 432l64 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L50.7 464c6.6-18.6 24.4-32 45.3-32zm304-16a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"]],
    "bowl-chopsticks-noodles": [512, 512, [], "e2ea", ["M48 272l196.4 0-81.4 167.8c-3.4-2.9-7.3-5.4-11.5-7.3-61.1-27.7-103.5-89.2-103.5-160.5z", "M96 78L13.1 93.6c-7.6 1.4-13.1 8-13.1 15.7 0 9.8 8.8 17.3 18.5 15.8l77.5-12.1 0 28-80.3 2.5C7 143.8 0 151 0 159.7 0 168.7 7.3 176 16.2 176l79.8 0 0 48-48 0c-26.5 0-48 21.5-48 48 0 90.8 54.1 169 131.7 204.2 8.1 21 28.4 35.8 52.3 35.8l144 0c23.8 0 44.2-14.9 52.3-35.8 77.7-35.2 131.7-113.4 131.7-204.2 0-26.5-21.5-48-48-48l-224 0 0-184c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 184-48 0 0-168c0-13.3-10.7-24-24-24S96 42.7 96 56l0 22zm192 57l0 41 200.4 0c13 0 23.6-10.6 23.6-23.6 0-13.3-11-24-24.4-23.6L288 135zm0-93l0 41 204.3-31.9c11.3-1.8 19.7-11.5 19.7-23 0-14.6-13.3-25.6-27.6-22.9L288 42zM151.5 432.5C90.4 404.8 48 343.3 48 272l416 0c0 71.3-42.4 132.8-103.5 160.5-11.5 5.2-20.4 14.7-25 26.4-1.2 3.1-4.2 5.1-7.5 5.1l-144 0c-3.3 0-6.3-2-7.5-5.1-4.5-11.7-13.5-21.2-25-26.4z"]],
    "record-vinyl": [512, 512, [], "f8d9", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm304 0a96 96 0 1 1 -192 0 96 96 0 1 1 192 0z", "M464 256a208 208 0 1 0 -416 0 208 208 0 1 0 416 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm160 0a96 96 0 1 1 192 0 96 96 0 1 1 -192 0zm120 0a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"]],
    "floppy-disk": [448, 512, [128190, 128426, "save"], "f0c7", ["M48 96l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-242.7c0-4.2-1.7-8.3-4.7-11.3L320 86.6 320 176c0 17.7-14.3 32-32 32l-160 0c-17.7 0-32-14.3-32-32l0-96-32 0c-8.8 0-16 7.2-16 16zM288 320a64 64 0 1 1 -128 0 64 64 0 1 1 128 0z", "M64 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-242.7c0-4.2-1.7-8.3-4.7-11.3L320 86.6 320 176c0 17.7-14.3 32-32 32l-160 0c-17.7 0-32-14.3-32-32l0-96-32 0zm80 0l0 80 128 0 0-80-128 0zM0 96C0 60.7 28.7 32 64 32l242.7 0c17 0 33.3 6.7 45.3 18.7L429.3 128c12 12 18.7 28.3 18.7 45.3L448 416c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM160 320a64 64 0 1 1 128 0 64 64 0 1 1 -128 0z"]],
    "down-left": [448, 512, [], "e16a", ["M80.1 177.9l0 222.1 222.1 0-71-71c-9.4-9.4-9.4-24.6 0-33.9l151-151-46.1-46.1-151 151c-9.4 9.4-24.6 9.4-33.9 0l-71-71z", "M80.1 400l222.1 0-71-71c-9.4-9.4-9.4-24.6 0-33.9l151-151-46.1-46.1-151 151c-9.4 9.4-24.6 9.4-33.9 0l-71-71 0 222.1zm-16 48c-17.7 0-32-14.3-32-32l0-276.7c0-28.5 34.5-42.8 54.6-22.6L168.1 198.1 302.1 64c18.7-18.7 49.1-18.7 67.9 0l46.1 46.1c18.7 18.7 18.7 49.1 0 67.9L282 312 363.4 393.4c20.2 20.2 5.9 54.6-22.6 54.6L64.1 448z"]],
    "toilets-portable": [512, 512, [], "e584", ["M48 72l0 24 128 0 0-24c0-13.3-10.7-24-24-24L72 48C58.7 48 48 58.7 48 72zm0 72l0 288 128 0 0-112-24 0c-13.3 0-24-10.7-24-24l0-48c0-13.3 10.7-24 24-24l24 0 0-80-128 0zM336 72l0 24 128 0 0-24c0-13.3-10.7-24-24-24l-80 0c-13.3 0-24 10.7-24 24zm0 72l0 288 128 0 0-112-24 0c-13.3 0-24-10.7-24-24l0-48c0-13.3 10.7-24 24-24l24 0 0-80-128 0z", "M72 48l80 0c13.3 0 24 10.7 24 24l0 24-128 0 0-24c0-13.3 10.7-24 24-24zM0 96L0 488c0 13.3 10.7 24 24 24s24-10.7 24-24l0-8 128 0 0 8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-416c0-39.8-32.2-72-72-72L72 0C32.2 0 0 32.2 0 72L0 96zm176 48l0 80-24 0c-13.3 0-24 10.7-24 24l0 48c0 13.3 10.7 24 24 24l24 0 0 112-128 0 0-288 128 0zM360 48l80 0c13.3 0 24 10.7 24 24l0 24-128 0 0-24c0-13.3 10.7-24 24-24zM336 432l0-288 128 0 0 80-24 0c-13.3 0-24 10.7-24 24l0 48c0 13.3 10.7 24 24 24l24 0 0 112-128 0zm176 0l0-360c0-39.8-32.2-72-72-72L360 0c-39.8 0-72 32.2-72 72l0 416c0 13.3 10.7 24 24 24s24-10.7 24-24l0-8 128 0 0 8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-56z"]],
    "o": [448, 512, [111], "4f", ["", "M224 80a176 176 0 1 0 0 352 176 176 0 1 0 0-352zM448 256a224 224 0 1 1 -448 0 224 224 0 1 1 448 0z"]],
    "palette": [512, 512, [127912], "f53f", ["M48 256c0 114.9 93.1 208 208 208 2.9 0 5.8-.1 8.6-.2 .8 0 1.2-.2 1.6-.4 .4-.2 1.1-.7 2-1.8 1.9-2.3 3.8-6.5 3.8-11.8 0-1.7-.6-5.6-5.6-17.1-.5-1.2-1.2-2.7-1.9-4.3-4.2-9.5-11.1-25-14.4-40.6-1.4-6.4-2.1-13.1-2.1-19.8 0-53 43-96 96-96l97.9 0c7.7 0 14.1-2.7 17.8-5.8 3.3-2.7 4.2-5.3 4.2-8 0-.7 0-1.4 0-2.2 0-114.9-93.1-208-208-208S48 141.1 48 256zm112 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm32-96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm96-32a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm96 32a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M464 258.2c0 2.7-1 5.2-4.2 8-3.8 3.1-10.1 5.8-17.8 5.8L344 272c-53 0-96 43-96 96 0 6.8 .7 13.4 2.1 19.8 3.3 15.7 10.2 31.1 14.4 40.6l0 0c.7 1.6 1.4 3 1.9 4.3 5 11.5 5.6 15.4 5.6 17.1 0 5.3-1.9 9.5-3.8 11.8-.9 1.1-1.6 1.6-2 1.8-.3 .2-.8 .3-1.6 .4-2.9 .1-5.7 .2-8.6 .2-114.9 0-208-93.1-208-208S141.1 48 256 48 464 141.1 464 256c0 .7 0 1.4 0 2.2zm48 .5c0-.9 0-1.8 0-2.7 0-141.4-114.6-256-256-256S0 114.6 0 256 114.6 512 256 512c3.5 0 7.1-.1 10.6-.2 31.8-1.3 53.4-30.1 53.4-62 0-14.5-6.1-28.3-12.1-42-4.3-9.8-8.7-19.7-10.8-29.9-.7-3.2-1-6.5-1-9.9 0-26.5 21.5-48 48-48l97.9 0c36.5 0 69.7-24.8 70.1-61.3zM160 256a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm0-64a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm128-64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm64 64a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]],
    "paintbrush-fine-slash": [576, 512, [], "e74d", ["M301.9 236L482.1 55.9c5-5 11.9-7.9 19-7.9 6.4 0 12.2 2.2 16.8 5.9l4.2 4.2c3.7 4.6 5.9 10.4 5.9 16.8 0 7.1-2.8 14-7.9 19L340 274.1 301.9 236z", "M41-24.9c-9.4-9.4-24.6-9.4-33.9 0S-2.3-.3 7 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9L373.9 308 554.1 127.9c14.1-14 21.9-33.1 21.9-53 0-41.4-33.5-74.9-74.9-74.9-19.9 0-38.9 7.9-53 21.9L268 202.1 41-24.9zM301.9 236L482.1 55.9c5-5 11.9-7.9 19-7.9 14.9 0 26.9 12 26.9 26.9 0 7.1-2.8 14-7.9 19L340 274.1 301.9 236zM264.7 350.5c4.7 10.2 7.3 21.5 7.3 33.5 0 44.2-35.8 80-80 80l-92.1 0c.5-.7 1-1.5 1.5-2.2 11.5-17.5 16.6-39.9 12.2-62-1-5.1-1.6-10.4-1.6-15.8 0-44.2 35.8-80 80-80 12 0 23.3 2.6 33.5 7.3l-53.7-53.7c-61.1 9.7-107.8 62.6-107.8 126.4 0 8.6 .9 17.1 2.5 25.2 3.6 18.1-8.5 38.8-27 38.8L32 448c-17.7 0-32 14.3-32 32s14.3 32 32 32l160 0c63.8 0 116.7-46.7 126.4-107.8l-53.7-53.7z"]],
    "blueberries": [512, 512, [], "e2e8", ["M48 336a128 128 0 1 0 256 0 128 128 0 1 0 -256 0zm48-32c0-8.8 7.2-16 16-16l32 0 0-32c0-8.8 7.2-16 16-16s16 7.2 16 16l0 32 32 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-32 0 0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-32-32 0c-8.8 0-16-7.2-16-16z", "M512 176c0-97.2-78.8-176-176-176-80.6 0-148.6 54.2-169.4 128.2 3.1-.1 6.3-.2 9.4-.2 114.9 0 208 93.1 208 208 0 3.2-.1 6.3-.2 9.4 74-20.8 128.2-88.8 128.2-169.4zM384 64l0 32 32 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-32 0 0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-32-32 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l32 0 0-32c0-8.8 7.2-16 16-16s16 7.2 16 16zM176 208a128 128 0 1 1 0 256 128 128 0 1 1 0-256zm0 304a176 176 0 1 0 0-352 176 176 0 1 0 0 352zm0-256c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 32-32 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l32 0 0 32c0 8.8 7.2 16 16 16s16-7.2 16-16l0-32 32 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-32 0 0-32z"]],
    "fish-bones": [576, 512, [], "e304", ["M464 181.2l0 149.5c28.5-24.9 49.7-53.6 61.8-74.8-12.1-21.2-33.3-49.9-61.8-74.8z", "M96 166.9c0-7.2-3.3-14.1-8.9-18.7l-48-38.9c-8.8-7.1-21.3-7.1-30.1-.1s-11.5 19.2-6.6 29.3L54.9 245.4c3.3 6.7 3.3 14.5 0 21.2L2.5 373.4c-5 10.1-2.2 22.3 6.6 29.3s21.3 7 30.1-.1l48-38.9c5.6-4.6 8.9-11.4 8.9-18.7l0-41.1 0 0 0-24 40 0 0 72c0 13.3 10.7 24 24 24s24-10.7 24-24l0-72 48 0 0 72c0 13.3 10.7 24 24 24s24-10.7 24-24l0-72 48 0 0 72c0 13.3 10.7 24 24 24s24-10.7 24-24l0-72 40 0 0 101.1c0 16.9 17.1 28.4 31.8 20 16-9.1 30.6-19.7 43.7-30.7 39.1-33 66.9-72.4 81-99.8 4.7-9.2 4.7-20.1 0-29.3-14.1-27.4-41.9-66.8-81-99.8-13.1-11-27.7-21.6-43.7-30.7-14.7-8.4-31.8 3.1-31.8 20l0 101.1-40 0 0-72c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 72-48 0 0-72c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 72-48 0 0-72c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 72-40 0 0-24 0 0 0-41.1zM464 330.8l0-149.5c28.5 24.9 49.7 53.6 61.8 74.8-12.1 21.2-33.3 49.9-61.8 74.8z"]],
    "unlock": [384, 512, [128275], "f09c", ["M48 224l0 224c0 8.8 7.2 16 16 16l256 0c8.8 0 16-7.2 16-16l0-224c0-8.8-7.2-16-16-16l-208 0c-16 0-32 0-48 0-8.8 0-16 7.2-16 16z", "M112 96c0-44.2 35.8-80 80-80 42.1 0 76.6 32.5 79.8 73.8 1 13.2 12.6 23.1 25.8 22.1s23.1-12.6 22.1-25.8C314.5 20 259.4-32 192-32 121.3-32 64 25.3 64 96l0 64c-35.3 0-64 28.7-64 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-224c0-35.3-28.7-64-64-64l-208 0 0-64zM64 208l0 0 48 0 0 0 208 0c8.8 0 16 7.2 16 16l0 224c0 8.8-7.2 16-16 16L64 464c-8.8 0-16-7.2-16-16l0-224c0-8.8 7.2-16 16-16z"]],
    "fan-table": [448, 512, [], "e004", ["M48 224a176 176 0 1 0 352 0 176 176 0 1 0 -352 0zm70.4-26.4c-16.6-41 3.2-87.6 44.2-104.1 12.3-5 26.3 1 31.2 13.3l29.2 72.2c16.7-23.7 45.8-37.5 76.6-33.2 43.8 6.1 74.2 46.6 68.1 90.4-1.8 13.1-14 22.3-27.1 20.4l-77.1-10.8c12.2 26.4 9.6 58.4-9.6 82.9-27.2 34.8-77.5 41-112.3 13.8-10.4-8.2-12.3-23.2-4.1-33.7l47.9-61.4c-28.9-2.6-55.4-21-67-49.7z", "M224 400a176 176 0 1 0 0-352 176 176 0 1 0 0 352zM448 224c0 115.6-87.6 210.8-200 222.7l0 17.3 112 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L88 512c-13.3 0-24-10.7-24-24s10.7-24 24-24l112 0 0-17.3C87.6 434.8 0 339.6 0 224 0 100.3 100.3 0 224 0S448 100.3 448 224zM118.4 197.6c-16.6-41 3.2-87.6 44.2-104.1 12.3-5 26.3 1 31.2 13.3l29.2 72.2c16.7-23.7 45.8-37.5 76.6-33.2 43.8 6.1 74.2 46.6 68.1 90.4-1.8 13.1-14 22.3-27.1 20.4l-77.1-10.8c12.2 26.4 9.6 58.4-9.6 82.9-27.2 34.8-77.5 41-112.3 13.8-10.4-8.2-12.3-23.2-4.1-33.7l47.9-61.4c-28.9-2.6-55.4-21-67-49.7zM224 240a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"]],
    "ear-listen": [512, 512, ["assistive-listening-systems"], "f2a2", ["M99.5 261c7.4-4.1 12.5-12 12.5-21 0-70.7 57.3-128 128-128s128 57.3 128 128c0 34.5-13.7 65.9-35.9 88.9-11.2 11.6-20.1 28-20.1 47.1 0 48.6-39.4 88-88 88-4.2 0-8.1 1.1-11.5 3l-37-67.4c27.4-3.7 48.5-27.1 48.5-55.5 0-30.9-25.1-56-56-56-17.2 0-32.5 7.7-42.8 19.9L99.5 261zM152 240c0 13.3 10.7 24 24 24s24-10.7 24-24c0-22.1 17.9-40 40-40s40 17.9 40 40c0 13.3 10.7 24 24 24s24-10.7 24-24c0-48.6-39.4-88-88-88s-88 39.4-88 88z", "M388.9 3.8C450.6 43 493.6 105.8 508 177.6l3.5 17.7c2.6 13-5.8 25.6-18.8 28.2s-25.6-5.8-28.2-18.8L460.9 187c-11.8-58.9-47.1-110.5-97.8-142.7-11.2-7.1-14.5-22-7.4-33.1s21.9-14.5 33.1-7.4zM240 112c-70.7 0-128 57.3-128 128 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-97.2 78.8-176 176-176s176 78.8 176 176c0 47.5-18.8 90.6-49.4 122.2-4.8 4.9-6.6 9.9-6.6 13.8 0 75.1-60.9 136-136 136-13.3 0-24-10.7-24-24s10.7-24 24-24c48.6 0 88-39.4 88-88 0-19.1 8.9-35.5 20.1-47.1 22.3-23 35.9-54.4 35.9-88.9 0-70.7-57.3-128-128-128zm0 88c-22.1 0-40 17.9-40 40 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-48.6 39.4-88 88-88s88 39.4 88 88c0 13.3-10.7 24-24 24s-24-10.7-24-24c0-22.1-17.9-40-40-40zM168 320a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM24 464a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm57-97l64 64c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0L47 401c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0z"]],
    "code-pull-request": [512, 512, [], "e13c", ["M64 80a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm0 352a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm320 0a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M321 7c9.4 9.4 9.4 24.6 0 33.9l-15 15 46.1 0c48.6 0 88 39.4 88 88l0 211.7c32.5 10.2 56 40.5 56 76.3 0 44.2-35.8 80-80 80s-80-35.8-80-80c0-35.8 23.5-66.1 56-76.3L392 144c0-22.1-17.9-40-40-40l-46.1 0 15 15c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0L231 97c-9.4-9.4-9.4-24.6 0-33.9L287 7c9.4-9.4 24.6-9.4 33.9 0zM128 80a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm-8 76.3l0 199.3c32.5 10.2 56 40.5 56 76.3 0 44.2-35.8 80-80 80s-80-35.8-80-80c0-35.8 23.5-66.1 56-76.3l0-199.3C39.5 146.1 16 115.8 16 80 16 35.8 51.8 0 96 0s80 35.8 80 80c0 35.8-23.5 66.1-56 76.3zM128 432a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm288 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]],
    "thumbtack-angle": [512, 512, [], "e751", ["M108.3 208.1L304 403.8c18.6-30.5 24-66 16.9-99.3-1.6-7.3 .4-15 5.3-20.7L428 165.7 346.4 84.1 228.3 185.9c-5.7 4.9-13.3 6.9-20.7 5.3-33.2-7.1-68.8-1.7-99.3 16.9z", "M303.1 6.9c9.4-9.4 24.6-9.4 33.9 0 4 4 50.9 50.9 140.6 140.6L505.2 175c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-9.2-9.2-92 106.8c6.2 43.1-2.8 88.3-28 126.9l-3.2 4.9c-20.1-13.1-20.1-13.1 0 0-13.9 21.3-43.8 24.4-61.8 6.4L67.4 235c-18-18-14.8-47.9 6.4-61.8l4.8-3.2c38.6-25.2 83.8-34.2 126.9-28l106.8-92-9.2-9.2c-9.4-9.4-9.4-24.6 0-33.9zm43.2 77.2L228.3 185.9c-5.7 4.9-13.3 6.9-20.7 5.3-33.2-7.1-68.8-1.7-99.3 16.9L304 403.8c18.6-30.5 24-66 16.9-99.3-1.6-7.3 .4-15 5.3-20.7L428 165.7 346.4 84.1zM121.3 356.9L155.2 390.8 41.1 505c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9L121.3 356.9z"]],
    "key": [512, 512, [128273], "f084", ["M48 385.9l0 78.1 64 0 0-40c0-13.3 10.7-24 24-24l40 0 0-40c0-13.3 10.7-24 24-24l54.1 0 29.2-29.2c5.9-5.9 14.5-8.3 22.6-6.4 9.6 2.3 19.7 3.6 30.1 3.6 70.7 0 128-57.3 128-128S406.7 48 336 48 208 105.3 208 176c0 10.4 1.2 20.5 3.6 30.1 2 8.1-.4 16.7-6.4 22.6L48 385.9zM400 144a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M208 176c0-70.7 57.3-128 128-128s128 57.3 128 128-57.3 128-128 128c-10.4 0-20.5-1.2-30.1-3.6-8.1-2-16.7 .5-22.6 6.4L254.1 336 200 336c-13.3 0-24 10.7-24 24l0 40-40 0c-13.3 0-24 10.7-24 24l0 40-64 0 0-78.1 157.2-157.2c5.9-5.9 8.3-14.5 6.4-22.6-2.3-9.6-3.6-19.7-3.6-30.1zM336 0c-97.2 0-176 78.8-176 176 0 9.5 .7 18.8 2.2 27.9L7 359c-4.5 4.5-7 10.6-7 17L0 488c0 13.3 10.7 24 24 24l112 0c13.3 0 24-10.7 24-24l0-40 40 0c13.3 0 24-10.7 24-24l0-40 40 0c6.4 0 12.5-2.5 17-7l27.2-27.2c9.1 1.4 18.4 2.2 27.9 2.2 97.2 0 176-78.8 176-176S433.2 0 336 0zm32 176a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]],
    "snake": [512, 512, [128013], "f716", ["M103.7 407.8L35.6 440.7c-6 2.9-6 11.5 0 14.4l68.1 32.6 217.3 0C387.3 487.7 441 434 441 367.8s-53.7-120-119.9-120l-152.9 0c-26.5 0-47.9-21.5-47.9-47.9s21.5-47.9 47.9-47.9l125.7 0c25.6 37.1 74.6 49.8 115 29.9l49.6-24.4c17.7-8.7 29-26.8 29-46.6 0-19.9-11.4-38.1-29.4-46.7L409.8 40.9c-41-19.8-90.4-6.6-116 31.1L166.6 72C96.4 72 39.5 128.9 39.5 199.1S96.4 326.3 166.6 326.3l152.5 0c22.5 0 40.7 18.2 40.7 40.7s-18.2 40.7-40.7 40.7l-215.4 0z", "M305.6 96L168 96C110.6 96 64 142.6 64 200s46.6 104 104 104l152 0c35.3 0 64 28.7 64 64s-28.7 64-64 64l-201.3 0c-7.5 0-14.8 1.7-21.5 5.1L75.3 448 97.2 458.9c6.7 3.3 14 5.1 21.5 5.1L320 464c53 0 96-43 96-96s-43-96-96-96l-152 0c-39.8 0-72-32.2-72-72s32.2-72 72-72l137.6 0 14.4 17.5c11.6 14.1 29 22.5 47.6 22.5 9 0 17.9-2 26.1-5.8l54.4-25.4c9.6-4.5 15.8-14.2 15.8-24.8s-6.2-20.3-15.8-24.8L393.8 61.8c-8.2-3.8-17.1-5.8-26.1-5.8-18.6 0-36 8.4-47.6 22.5L305.6 96zM176 512l-57.3 0c-14.9 0-29.6-3.5-42.9-10.1L14.3 471.2C5.5 466.8 0 457.8 0 448s5.5-18.8 14.3-23.2l61.4-30.7c12.9-6.4 27.5-10.1 42.9-10.1L320 384c8.8 0 16-7.2 16-16s-7.2-16-16-16l-152 0c-17.3 0-33.9-2.9-49.3-8.2-5.7-2-11.3-4.2-16.7-6.8-50.9-24.6-86-76.7-86-137 0-83.9 68.1-152 152-152l114.9 0c20.6-25.1 51.6-40 84.7-40 16 0 31.9 3.5 46.4 10.3l54.4 25.4C495 56.1 512 82.7 512 112s-17 55.9-43.5 68.3l-49.6 23.1-4.9 2.3c-14.5 6.8-30.4 10.3-46.4 10.3-33.9 0-64.6-15.5-84.7-40L168 176c-13.3 0-24 10.7-24 24s10.7 24 24 24l152 0c16.7 0 32.7 2.8 47.7 8.1 16.5 5.8 31.6 14.5 44.7 25.5 31.6 26.4 51.6 66.1 51.6 110.5 0 79.5-64.5 144-144 144l-144 0zM352 88a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm16 32a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"]],
    "circle-waveform-lines": [512, 512, ["waveform-circle"], "e12d", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm72-40c0-13.3 10.7-24 24-24s24 10.7 24 24l0 80c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-80zm80-72c0-13.3 10.7-24 24-24s24 10.7 24 24l0 224c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-224zm80 56c0-13.3 10.7-24 24-24s24 10.7 24 24l0 112c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-112zm80 40c0-13.3 10.7-24 24-24s24 10.7 24 24l0 32c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-32z", "M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm-8-368c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 224c0 13.3 10.7 24 24 24s24-10.7 24-24l0-224zm80 56c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 112c0 13.3 10.7 24 24 24s24-10.7 24-24l0-112zM168 216c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 80c0 13.3 10.7 24 24 24s24-10.7 24-24l0-80zm240 24c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 32c0 13.3 10.7 24 24 24s24-10.7 24-24l0-32z"]],
    "empty-set": [512, 512, [8709, 216], "f656", ["", "M464 256c0-48.8-16.8-93.7-44.9-129.1L126.9 419.1c35.5 28.1 80.3 44.9 129.1 44.9 114.9 0 208-93.1 208-208zM453.2 92.7c36.7 44.3 58.8 101.2 58.8 163.3 0 141.4-114.6 256-256 256-62.1 0-118.9-22.1-163.3-58.8L41 505c-9.4 9.4-24.6 9.4-33.9 0S-2.3 480.4 7 471l51.8-51.8C22.1 374.9 0 318.1 0 256 0 114.6 114.6 0 256 0 318.1 0 374.9 22.1 419.3 58.8L471 7c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9L453.2 92.7zM92.9 385.1L385.1 92.9C349.7 64.8 304.8 48 256 48 141.1 48 48 141.1 48 256 48 304.8 64.8 349.7 92.9 385.1z"]],
    "circle-won": [512, 512, [], "e6ec", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm64 16c0-8.8 7.2-16 16-16l10.8 0-25.7-80.7c-4-12.6 3-26.1 15.6-30.2s26.1 3 30.2 15.6l30.4 95.3 19.3 0 24.3-94c2.7-10.6 12.2-17.9 23.1-18s20.5 7.2 23.3 17.8l25.4 94.2 19.3 0 29.2-95.1c3.9-12.7 17.3-19.8 30-15.9s19.8 17.3 15.9 30L374 256 384 256c8.8 0 16 7.2 16 16s-7.2 16-16 16l-19.8 0-29.2 95.1c-3.1 10.2-12.7 17.1-23.4 16.9s-20-7.4-22.7-17.8l-25.4-94.2-13.7 0-24.3 94c-2.7 10.4-11.9 17.7-22.6 18s-20.3-6.5-23.5-16.7l-30.4-95.3-21 0c-8.8 0-16-7.2-16-16z", "M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM128.7 145.1c-12.6 4-19.6 17.5-15.6 30.2l25.7 80.7-10.8 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l21 0 30.4 95.3c3.2 10.2 12.8 17 23.5 16.7s19.9-7.6 22.6-18l24.3-94 13.7 0 25.4 94.2c2.8 10.3 12.1 17.6 22.7 17.8s20.2-6.7 23.4-16.9l29.2-95.1 19.8 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-10 0 24.9-80.9c3.9-12.7-3.2-26.1-15.9-30s-26.1 3.2-30 15.9l-29.2 95.1-19.3 0-25.4-94.2c-2.8-10.5-12.4-17.8-23.3-17.8s-20.4 7.4-23.1 18l-24.3 94-19.3 0-30.4-95.3c-4-12.6-17.5-19.6-30.2-15.6zm71.2 144.2l-.4-1.4 .8 0-.4 1.4zm113.7 0l-.4-1.4 .8 0-.4 1.4z"]],
    "hockey-stick": [512, 512, [], "e7e6", ["M80.5 376l0 80c0 4.4 3.6 8 8 8l40 0 0-96-40 0c-4.4 0-8 3.6-8 8zm96-8l0 96 47.2 0c29.4 0 55.8-17.8 66.8-45.1L311 368 176.5 368z", "M466.2-17c5-12.3 18.9-18.2 31.2-13.3S515.7-11.3 510.7 1L335 436.9C316.7 482.3 272.6 512 223.7 512L88.5 512c-30.9 0-56-25.1-56-56l0-80c0-30.9 25.1-56 56-56l241.9 0 135.9-337zM176.5 464l47.2 0c29.4 0 55.8-17.8 66.8-45.1l20.5-50.9-134.5 0 0 96zm-88-96c-4.4 0-8 3.6-8 8l0 80c0 4.4 3.6 8 8 8l40 0 0-96-40 0z"]],
    "monkey": [576, 512, [128018], "f6fb", ["M208 416c0-75.6 47.7-140.1 114.7-165 20.7 19.5 47.5 32.6 77.3 36.1l0 56.9c-20.1-15.1-45-24-72-24l-16 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l16 0c39.8 0 72 32.2 72 72l0 24-192 0 0-48zM336 112c0-26.5 21.5-48 48-48l64 0c26.5 0 48 21.5 48 48 0 20.8-13.2 38.4-31.6 45.1-4.7 1.7-8.4 5.9-8.4 10.9 0 22.1-17.9 40-40 40s-40-17.9-40-40c0-5-3.7-9.2-8.4-10.9-18.5-6.7-31.6-24.4-31.6-45.1zm32 0a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm64 0a16 16 0 1 0 32 0 16 16 0 1 0 -32 0z", "M160 416c0-91.5 54.8-170.2 133.5-204.9 7.3 15.1 17.2 28.6 29.3 39.9-67 24.9-114.7 89.4-114.7 165l0 48 192 0 0-24c0-39.8-32.2-72-72-72l-16 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l16 0c27 0 51.9 8.9 72 24l0-56.9c5.2 .6 10.6 .9 16 .9 11 0 21.7-1.3 32-3.8l0 1.8 83.5 83.5C560 398 576 436.7 576 477l0 11c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-11c0-27.6-11-54-30.5-73.5l-49.5-49.5 0 110.1 8 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-304 0C68.1 512 0 443.9 0 360L0 120C0 53.7 53.7 0 120 0l8 0c53 0 96 43 96 96s-43 96-96 96l-8 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l8 0c26.5 0 48-21.5 48-48s-21.5-48-48-48l-8 0c-39.8 0-72 32.2-72 72l0 240c0 57.4 46.6 104 104 104l8 0 0-48zM448 251c-10.1 3.3-20.8 5-32 5-5.4 0-10.8-.4-16-1.2-13.5-2.1-26.1-6.8-37.4-13.5-16.4-9.8-29.9-24.1-38.8-41.1-1.4-2.7-2.7-5.4-3.8-8.2-35.3 0-64-28.7-64-64s28.6-64 64-64c15.7-37.6 52.8-64 96-64s80.4 26.4 96 64c35.3 0 64 28.7 64 64s-28.6 64-64 64c-11.6 27.9-35 49.6-64 59zM384 64c-26.5 0-48 21.5-48 48 0 20.8 13.2 38.4 31.6 45.1 4.7 1.7 8.4 5.9 8.4 10.9 0 22.1 17.9 40 40 40s40-17.9 40-40c0-5 3.7-9.2 8.4-10.9 18.5-6.7 31.6-24.4 31.6-45.1 0-26.5-21.5-48-48-48l-64 0zm0 32a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm48 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"]],
    "forklift": [576, 512, [], "f47a", ["M48 224l0 121.6c12-6.1 25.6-9.6 40-9.6 40.2 0 74.1 27 84.6 63.8 23.6 0 47.1 0 70.7 .2 10.5-37 44.5-64 84.7-64 2.7 0 5.4 .1 8 .4l0-48.4-128 0c-6.4 0-12.5-2.5-17-7l-73-73-54.1 0c-8.8 0-16 7.2-16 16z", "M496 24c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 432c0 13.3 10.7 24 24 24l80 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-56 0 0-408zM48 424a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zM0 224L0 424c0 48.6 39.4 88 88 88 40.3 0 74.2-27.1 84.7-64l70.6 0c10.4 36.9 44.4 64 84.7 64 48.6 0 88-39.4 88-88 0-27.3-12.5-51.7-32-67.9l0-90c0-10-2.1-19.9-6.1-29L300.3 60.7C292.6 43.2 275.4 32 256.3 32L144 32c-26.5 0-48 21.5-48 48l0 80-32 0c-35.3 0-64 28.7-64 64zM336 336.4c-2.6-.2-5.3-.4-8-.4-40.3 0-74.2 27.1-84.7 64l-70.6 0c-10.4-36.9-44.4-64-84.7-64-14.4 0-28 3.5-40 9.6L48 224c0-8.8 7.2-16 16-16l54.1 0 73 73c4.5 4.5 10.6 7 17 7l128 0 0 48.4zM326.7 240l-108.8 0-73-73c-.3-.3-.6-.6-1-.9l0-86.1 112.3 0 70.4 160zM288 424a40 40 0 1 1 80 0 40 40 0 1 1 -80 0z"]],
    "skull": [512, 512, [128128], "f54c", ["M48 240c0 59.4 29.3 113.2 76.8 149 12.1 9.1 19.2 23.3 19.2 38.4l0 36.6 40 0 0-24c0-13.3 10.7-24 24-24s24 10.7 24 24l0 24 48 0 0-24c0-13.3 10.7-24 24-24s24 10.7 24 24l0 24 40 0 0-36.6c0-15.1 7.1-29.3 19.2-38.4 47.6-35.8 76.8-89.6 76.8-149 0-103.2-90.2-192-208-192S48 136.8 48 240zm176 16a56 56 0 1 1 -112 0 56 56 0 1 1 112 0zm176 0a56 56 0 1 1 -112 0 56 56 0 1 1 112 0z", "M368 427.4c0-15.1 7.1-29.3 19.2-38.4 47.6-35.8 76.8-89.6 76.8-149 0-103.2-90.2-192-208-192S48 136.8 48 240c0 59.4 29.3 113.2 76.8 149 12.1 9.1 19.2 23.3 19.2 38.4l0 36.6 40 0 0-24c0-13.3 10.7-24 24-24s24 10.7 24 24l0 24 48 0 0-24c0-13.3 10.7-24 24-24s24 10.7 24 24l0 24 40 0 0-36.6zm48 0l0 36.6c0 26.5-21.5 48-48 48l-224 0c-26.5 0-48-21.5-48-48l0-36.6C37.5 383.4 0 315.8 0 240 0 107.5 114.6 0 256 0S512 107.5 512 240c0 75.8-37.5 143.4-96 187.4zM112 256a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm232-56a56 56 0 1 1 0 112 56 56 0 1 1 0-112z"]],
    "sneaker": [640, 512, [], "e6da", ["M48 218.2l0 85.8 534.3 0c-13.2-27.2-39-47.5-70.6-52.7l-71.7-11.9-4.7-.8-18.4 18.4c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l9.1-9.1-37.2-22.9-33.9 33.9c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l25.8-25.8-72.9-44.8 0 26.3c0 60.4-48.9 109.3-109.3 109.3-32.1 0-62.1-14-82.7-37.8z", "M417 257c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l9.1-9.1-37.2-22.9-33.9 33.9c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l25.8-25.8-72.9-44.8 0 26.3c0 60.4-48.9 109.3-109.3 109.3-32.1 0-62.1-14-82.7-37.8l0 85.8 534.3 0c-13.2-27.2-39-47.5-70.6-52.7l-71.7-11.9-4.7-.8-18.4 18.4zM48 352l0 32c0 8.8 7.2 16 16 16l512 0c8.8 0 16-7.2 16-16l0-32-544 0zM0 384L0 158.6c0-16.9 13.7-30.6 30.6-30.6 10.8 0 20.7 5.6 26.3 14.9l21.2 35.4c11.1 18.5 31 29.8 52.6 29.8 33.9 0 61.3-27.4 61.3-61.3l0-45.3c0-20.7 16.7-37.4 37.4-37.4 6.9 0 13.7 1.9 19.6 5.5L448 192 519.7 203.9C589.1 215.5 640 275.6 640 346l0 38c0 35.3-28.7 64-64 64L64 448c-35.3 0-64-28.7-64-64z"]],
    "gamepad-modern": [640, 512, [127918, 63676, "gamepad-alt"], "e5a2", ["M23.9 354.8c-5.2 28.2 4.1 55.3 22.2 74.2-9-15.3-14.1-33.1-14.1-52l0-66.1-8.1 43.9zM67.5 129.4c9.9-15 21.6-28.7 34.8-40.8-15.4 9.6-27.7 23.8-34.8 40.8zM80 248l0 129c0 30.4 24.6 55 55 55 23.7 0 44.7-15.2 52.2-37.6l7.7-23 3-12.3 1.1 0 2.2-6.6 1.5-3.5C206.8 341.1 215 336 224 336l192 0c10.3 0 19.5 6.6 22.8 16.4l14 42c7.5 22.5 28.5 37.6 52.2 37.6 30.4 0 55-24.6 55-55l0-129c0-92.8-75.2-168-168-168L248 80C155.2 80 80 155.2 80 248zm40-24c0-13.3 10.7-24 24-24l24 0 0-24c0-13.3 10.7-24 24-24s24 10.7 24 24l0 24 24 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-24 0 0 24c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-24-24 0c-13.3 0-24-10.7-24-24zm328 32a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm48-80a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm38.8-90.1c16.4 14.4 30.5 31.3 41.9 50-7.1-21.6-22.3-39.4-41.9-50zm59.5 342.5c16.7-18.1 25.4-43.6 20.9-70.3l-7.1-42.3 0 61.1c0 18.7-5 36.3-13.7 51.4z", "M392 32c119.3 0 216 96.7 216 216l0 129c0 56.9-46.1 103-103 103-44.3 0-83.7-28.4-97.8-70.4l-8.5-25.6-157.4 0-8.5 25.6c-14 42.1-53.4 70.4-97.7 70.4-56.9 0-103-46.1-103-103l0-129C32 128.7 128.7 32 248 32l144 0zM248 80C155.2 80 80 155.2 80 248l0 129c0 30.4 24.6 55 55 55 23.7 0 44.7-15.2 52.2-37.6l14-42 1.5-3.5C206.8 341.1 215 336 224 336l192 0c10.3 0 19.5 6.6 22.8 16.4l14 42c7.5 22.5 28.5 37.6 52.2 37.6 30.4 0 55-24.6 55-55l0-129c0-92.8-75.2-168-168-168L248 80zm-56 72c13.3 0 24 10.7 24 24l0 24 24 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-24 0 0 24c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-24-24 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l24 0 0-24c0-13.3 10.7-24 24-24zM416 288a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm48-80a32 32 0 1 1 0-64 32 32 0 1 1 0 64z"]],
    "square-k": [448, 512, [], "e274", ["M48 96l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16zm80 72c0-13.3 10.7-24 24-24s24 10.7 24 24l0 68.8 104.6-87.2c10.2-8.5 25.3-7.1 33.8 3.1s7.1 25.3-3.1 33.8l-67.3 56.1 70.6 86.2c8.4 10.3 6.9 25.4-3.4 33.8s-25.4 6.9-33.8-3.4l-70.3-85.9-31.1 25.9 0 44.8c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-176z", "M64 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm311.4 90.4l-67.3 56.1 70.6 86.2c8.4 10.3 6.9 25.4-3.4 33.8s-25.4 6.9-33.8-3.4l-70.3-85.9-31.1 25.9 0 44.8c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-176c0-13.3 10.7-24 24-24s24 10.7 24 24l0 68.8 104.6-87.2c10.2-8.5 25.3-7.1 33.8 3.1s7.1 25.3-3.1 33.8z"]],
    "comment-text": [512, 512, [], "e14d", ["M48 240c0 42.8 15.1 82.4 41.2 114.7 12.2 15.1 14.1 36.1 4.8 53.2l-18 33.1 58.5-25.1c11.8-5.1 25.2-5.2 37.1-.3 25.7 10.5 54.2 16.4 84.3 16.4 117.8 0 208-88.8 208-192S373.8 48 256 48 48 136.8 48 240zm112-72c0-13.3 10.7-24 24-24l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0 0 120c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-120-48 0c-13.3 0-24-10.7-24-24z", "M0 240c0 54.4 19.3 104.6 51.9 144.9L3.1 474.3c-2 3.7-3.1 7.9-3.1 12.2 0 14.1 11.4 25.5 25.5 25.5 4 0 7.8-.6 11.5-2.1L153.4 460c31.4 12.9 66.1 20 102.6 20 141.4 0 256-107.5 256-240S397.4 0 256 0 0 107.5 0 240zM94 407.9c9.3-17.1 7.4-38.1-4.8-53.2-26.1-32.3-41.2-71.9-41.2-114.7 0-103.2 90.2-192 208-192s208 88.8 208 192-90.2 192-208 192c-30.2 0-58.7-5.9-84.3-16.4-11.9-4.9-25.3-4.8-37.1 .3L76 440.9 94 407.9zM184 144c-13.3 0-24 10.7-24 24s10.7 24 24 24l48 0 0 120c0 13.3 10.7 24 24 24s24-10.7 24-24l0-120 48 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-144 0z"]],
    "mars-stroke-up": [384, 512, [9896, "mars-stroke-v"], "f22a", ["M64 352a128 128 0 1 0 256 0 128 128 0 1 0 -256 0z", "M192 224a128 128 0 1 0 0 256 128 128 0 1 0 0-256zM16 352c0-89.1 66.2-162.7 152-174.4l0-33.6-40 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l40 0 0-56-25.6 19.2c-10.6 8-25.6 5.8-33.6-4.8s-5.8-25.6 4.8-33.6l64-48c8.5-6.4 20.3-6.4 28.8 0l64 48c10.6 8 12.8 23 4.8 33.6s-23 12.8-33.6 4.8L216 40 216 96 256 96c13.3 0 24 10.7 24 24s-10.7 24-24 24l-40 0 0 33.6c85.8 11.7 152 85.3 152 174.4 0 97.2-78.8 176-176 176S16 449.2 16 352z"]],
    "cowbell": [448, 512, [], "f8b3", ["M49.6 368l64.2-244.1c1.8-7 8.2-11.9 15.5-11.9l189.3 0c7.3 0 13.6 4.9 15.5 11.9L398.4 368 49.6 368z", "M184 32l80 0c4.4 0 8 3.6 8 8l0 24-96 0 0-24c0-4.4 3.6-8 8-8zm-56 8l0 24c-28.5 .6-53.3 20-60.6 47.7l-66 251C.5 366.2 0 369.8 0 373.5 0 397 19 416 42.5 416l363 0c23.5 0 42.5-19 42.5-42.5 0-3.6-.5-7.3-1.4-10.8l-66-251C373.3 84 348.5 64.6 320 64l0-24c0-30.9-25.1-56-56-56l-80 0c-30.9 0-56 25.1-56 56zM49.6 368l64.2-244.1c1.8-7 8.2-11.9 15.5-11.9l189.3 0c7.3 0 13.6 4.9 15.5 11.9L398.4 368 49.6 368zM224 512c32.8 0 61-19.7 73.3-48l-146.7 0c12.3 28.3 40.5 48 73.3 48z"]],
    "fire-flame-simple": [384, 512, ["burn"], "f46a", ["M48 321.6c0-16.6 2.9-33.1 8.6-48.7l.7-1.9c29-79.8 75-152.2 134.7-212.2 59.7 60.1 105.7 132.5 134.7 212.2l.7 1.9c5.7 15.6 8.6 32.1 8.6 48.7 0 78.2-64.8 142.4-144 142.4S48 399.7 48 321.6zm48-2.1c0 53 43 96.5 96 96.5s96-43.5 96-96.5c0-10.1-2.1-20.3-6.2-29.5l-1.9-4.3c-15.8-35.4-37.9-67.7-65.3-95.1l-8.9-8.9C202 178 197.1 176 192 176s-10 2-13.6 5.6l-8.9 8.9c-27.4 27.4-49.6 59.7-65.3 95.1l-1.9 4.3c-4.1 9.3-6.2 19.4-6.2 29.5z", "M209.1 8.5c72.9 68 128.7 152.4 162.7 246.1l.7 1.9c7.6 20.9 11.5 42.9 11.5 65.1 0 105.2-86.8 190.4-192 190.4S0 426.7 0 321.6c0-22.2 3.9-44.2 11.5-65.1l.7-1.9 45.1 16.4-.7 1.9C50.9 288.5 48 305 48 321.6 48 399.7 112.8 464 192 464s144-64.3 144-142.4c0-16.6-2.9-33.1-8.6-48.7l0 0-.7-1.9c-29-79.8-75-152.2-134.7-212.2-59.7 60.1-105.7 132.5-134.7 212.2L12.2 254.6C46.2 160.8 102 76.5 174.9 8.5l3.3-3C181.9 2 186.9 0 192 0s10.1 2 13.8 5.5l3.3 3zm72.6 281.4c4.1 9.3 6.2 19.4 6.2 29.5 0 53-43 96.5-96 96.5s-96-43.5-96-96.5c0-10.1 2.1-20.3 6.2-29.5l1.9-4.3c15.8-35.4 37.9-67.7 65.3-95.1l8.9-8.9c3.6-3.6 8.5-5.6 13.6-5.6s10 2 13.6 5.6l8.9 8.9c27.4 27.4 49.6 59.7 65.3 95.1l1.9 4.3z"]],
    "tree": [448, 512, [127794], "f1bb", ["M76.4 400l296.2 0-88.8-104.5c-6.1-7.1-7.4-17.1-3.5-25.6S292.7 256 302.1 256l38.5 0-75.2-88.5c-6-7.1-7.4-17.1-3.5-25.6S274.3 128 283.7 128l24.9 0-84.1-99-84.1 99 24.9 0c9.3 0 17.9 5.5 21.8 13.9s2.5 18.5-3.5 25.6l-75.2 88.5 38.5 0c9.3 0 17.9 5.4 21.8 13.9s2.5 18.5-3.5 25.6L76.4 400z", "M224.5-32c7 0 13.7 3.1 18.3 8.5l136 160c6.1 7.1 7.4 17.1 3.5 25.6-3.9 8.5-12.4 13.9-21.8 13.9l-24.9 0 75.2 88.5c6 7.1 7.4 17.1 3.5 25.6S401.8 304 392.5 304l-38.5 0 88.8 104.5c6.1 7.1 7.4 17.1 3.5 25.6S433.8 448 424.5 448l-176 0 0 72c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-72-176 0c-9.4 0-17.9-5.4-21.8-13.9S.2 415.6 6.2 408.5L95 304 56.5 304c-9.4 0-17.9-5.4-21.8-13.9s-2.6-18.5 3.5-25.6l75.2-88.5-24.9 0c-9.4 0-17.9-5.4-21.8-13.9s-2.6-18.5 3.5-25.6l136-160 1.8-1.9c4.4-4.2 10.3-6.6 16.5-6.6zM140.4 128l24.9 0c9.3 0 17.9 5.5 21.8 13.9s2.5 18.5-3.5 25.6l-75.2 88.5 38.5 0c9.3 0 17.9 5.4 21.8 13.9s2.5 18.5-3.5 25.6L76.4 400 372.6 400 283.8 295.5c-6.1-7.1-7.4-17.1-3.5-25.6S292.7 256 302.1 256l38.5 0-75.2-88.5c-6-7.1-7.4-17.1-3.5-25.6S274.3 128 283.7 128l24.9 0-84.1-99-84.1 99z"]],
    "gauge-simple-min": [512, 512, ["tachometer-slowest"], "f62d", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm60.8-14.4c8-10.6 23-12.8 33.6-4.8l87.5 65.6c7.8-4.1 16.7-6.4 26.1-6.4 30.9 0 56 25.1 56 56s-25.1 56-56 56-56-25.1-56-56c0-3.8 .4-7.6 1.1-11.2l-87.5-65.6c-10.6-8-12.8-23-4.8-33.6z", "M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm56-160c0-30.9-25.1-56-56-56-9.4 0-18.3 2.3-26.1 6.4l-87.5-65.6c-10.6-8-25.6-5.8-33.6 4.8s-5.8 25.6 4.8 33.6l87.5 65.6c-.7 3.6-1.1 7.3-1.1 11.2 0 30.9 25.1 56 56 56s56-25.1 56-56z"]],
    "comments-question-check": [576, 512, [], "e14f", ["M48 144c0 25.1 8.1 48.7 22.6 68.8 9.6 13.3 11.7 30.6 5.6 45.9L64.8 287.2 115.3 267c10-4 21.1-4.5 31.4-1.5 14.2 4.2 29.4 6.5 45.3 6.5 83.5 0 144-61.2 144-128S275.6 16 192 16 48 77.2 48 144zm81.3-62.8c8.8-26.2 33.5-45.2 62.7-45.2 36.5 0 66.1 29.6 66.1 66.1 0 39.2-30 55.7-46.5 61.6-1.8 9.3-9.9 16.2-19.6 16.2-11 0-20-9-20-20 0-17.1 12.4-29.3 25-33.5 5.3-1.8 10.8-4.5 14.8-8.5 3.5-3.4 6.3-8.1 6.3-15.9 0-14.4-11.7-26.1-26.1-26.1-11.5 0-21.3 7.4-24.8 17.8-3.5 10.5-14.8 16.1-25.3 12.6s-16.1-14.8-12.6-25.3zM216 224a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm27.3 138.8c13.6 55.5 68.6 101.2 140.7 101.2 15.9 0 31.1-2.3 45.3-6.5 10.3-3.1 21.4-2.5 31.4 1.5l50.4 20.2-11.4-28.5c-6.1-15.2-4-32.6 5.6-45.9 14.5-20.1 22.6-43.7 22.6-68.8 0-56.5-43.3-109-107.2-123.9-16 47.1-48.2 86.8-89.7 114.3 6.4-.6 12.9 2.1 17 7.6l21.6 28.8 49.2-78.7c5.6-9 17.5-11.7 26.5-6.1s11.7 17.5 6.1 26.5L387.5 407c-3.4 5.4-9.1 8.7-15.5 9s-12.4-2.6-16.2-7.7l-38.4-51.2c-4.9-6.5-5-15.2-.9-21.7-22.4 12.7-47.2 22-73.2 27.4z", "M76.2 258.7c6.1-15.2 4-32.6-5.6-45.9-14.5-20.1-22.6-43.7-22.6-68.8 0-66.8 60.5-128 144-128s144 61.2 144 128-60.5 128-144 128c-15.9 0-31.1-2.3-45.3-6.5-10.3-3.1-21.4-2.5-31.4 1.5l-50.4 20.2 11.4-28.5zM0 144c0 35.8 11.6 69.1 31.7 96.8L1.9 315.2c-1.3 3.2-1.9 6.6-1.9 10 0 14.8 12 26.8 26.8 26.8 3.4 0 6.8-.7 10-1.9l96.3-38.5c18.6 5.5 38.4 8.4 58.9 8.4 106 0 192-78.8 192-176S298-32 192-32 0 46.8 0 144zM384 512c20.6 0 40.3-3 58.9-8.4l96.3 38.5c3.2 1.3 6.6 1.9 10 1.9 14.8 0 26.8-12 26.8-26.8 0-3.4-.7-6.8-1.9-10l-29.7-74.4c20-27.8 31.7-61.1 31.7-96.8 0-82.4-61.7-151.5-145-170.7-1.6 16.3-5.1 31.9-10.1 46.9 63.9 14.8 107.2 67.3 107.2 123.9 0 25.1-8.1 48.7-22.6 68.8-9.6 13.3-11.7 30.6-5.6 45.9l11.4 28.5-50.4-20.2c-10-4-21.1-4.5-31.4-1.5-14.2 4.2-29.4 6.5-45.3 6.5-72.2 0-127.1-45.7-140.7-101.2-15.6 3.2-31.7 5-48.1 5.2 16.4 81.9 94.7 144 188.8 144zM167.2 93.8c3.5-10.4 13.3-17.8 24.8-17.8 14.4 0 26.1 11.7 26.1 26.1 0 7.8-2.8 12.5-6.3 15.9-4 3.9-9.5 6.7-14.8 8.5-12.7 4.2-25 16.4-25 33.5 0 11 9 20 20 20 9.8 0 17.9-7 19.6-16.2 16.4-5.9 46.5-22.4 46.5-61.6 0-36.5-29.6-66.1-66.1-66.1-29.2 0-54 18.9-62.7 45.2-3.5 10.5 2.2 21.8 12.6 25.3s21.8-2.2 25.3-12.6zM192 248a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm259.5 56.6c5.6-9 2.9-20.8-6.1-26.5s-20.8-2.9-26.5 6.1l-49.2 78.7-21.6-28.8c-6.4-8.5-18.4-10.2-26.9-3.8s-10.2 18.4-3.8 26.9l38.4 51.2c3.8 5.1 9.8 7.9 16.2 7.7s12.1-3.6 15.5-9l64-102.4z"]],
    "smog": [576, 512, [], "f75f", ["M80 144c0 53 43 96 96 96l101 0c6.5 0 12.8 2.7 17.3 7.4 14.6 15.2 35 24.6 57.7 24.6s43.1-9.4 57.7-24.6c4.5-4.7 10.8-7.4 17.3-7.4l5 0c35.3 0 64-28.7 64-64s-28.7-64-64-64c-3.9 0-7.6 .3-11.2 1-11.2 2-22.2-4.2-26.5-14.7-11.8-29.5-40.7-50.3-74.3-50.3-20.4 0-39 7.6-53.1 20.2-8.7 7.8-21.8 8.1-30.9 .8-16.4-13.1-37.2-21-59.9-21-53 0-96 43-96 96z", "M32 144C32 64.5 96.5 0 176 0 203.2 0 228.6 7.5 250.3 20.6 270.4 7.6 294.3 0 320 0 367.4 0 408.8 25.8 430.9 64l1.1 0c61.9 0 112 50.1 112 112 0 60.3-47.6 109.4-107.2 111.9-22.6 20-52.3 32.1-84.8 32.1-32.5 0-62.1-12.1-84.7-32L176 288C96.5 288 32 223.5 32 144zM176 48c-53 0-96 43-96 96s43 96 96 96l101 0c6.5 0 12.8 2.7 17.3 7.4 14.6 15.2 35 24.6 57.7 24.6s43.1-9.4 57.7-24.6c4.5-4.7 10.8-7.4 17.3-7.4l5 0c35.3 0 64-28.7 64-64s-28.7-64-64-64c-3.9 0-7.6 .3-11.2 1-11.2 2-22.2-4.2-26.5-14.7-11.8-29.5-40.7-50.3-74.3-50.3-20.4 0-39 7.6-53.1 20.2-8.7 7.8-21.8 8.1-30.9 .8-16.4-13.1-37.2-21-59.9-21zM512 392c0 13.3-10.7 24-24 24L24 416c-13.3 0-24-10.7-24-24s10.7-24 24-24l464 0c13.3 0 24 10.7 24 24zM88 464l80 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zm176 0l288 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-288 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"]],
    "s": [320, 512, [115], "53", ["", "M0 151.7C0 85.6 53.6 32 119.7 32L280 32c13.3 0 24 10.7 24 24s-10.7 24-24 24L119.7 80c-39.6 0-71.7 32.1-71.7 71.7 0 34.8 25 64.6 59.2 70.6l113.9 20.1c57.2 10.1 98.9 59.8 98.9 117.9 0 66.1-53.6 119.7-119.7 119.7L40 480c-13.3 0-24-10.7-24-24s10.7-24 24-24l160.3 0c39.6 0 71.7-32.1 71.7-71.7 0-34.8-25-64.6-59.2-70.6L98.9 269.6C41.7 259.5 0 209.8 0 151.7z"]],
    "phone-arrow-up-right": [512, 512, ["phone-arrow-up", "phone-outgoing"], "e224", ["M57.4 163.4c27.1 153.8 137.4 264.2 291.2 291.3 48.4 8.5 91.9-25.3 107-70.5 1.3-4-.6-8.3-4.4-10L364 334.4c-3.4-1.5-7.4-.6-9.7 2.3l-33.5 41.9c-7 8.7-19 11.5-29 6.7-72.5-34.4-130.5-94.3-162.4-168.2-4.3-9.9-1.4-21.5 7-28.2l38.9-31.1c2.9-2.3 3.9-6.3 2.3-9.7L137.9 60.7c-1.7-3.8-6-5.7-10-4.4-45.2 15.1-79.1 58.6-70.5 107z", "M327 151c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l103-103 0 54.1c0 13.3 10.7 24 24 24s24-10.7 24-24l0-112c0-13.3-10.7-24-24-24L376 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l54.1 0-103 103zM181.6 40.9c-11.9-26.2-41.6-39.1-68.9-30-62.3 20.8-116.2 83.7-102.6 160.9 30.6 173.7 156.5 299.6 330.2 330.2 77.2 13.6 140.1-40.4 160.9-102.6 9.1-27.3-3.9-57-30-68.9l-87.3-39.7c-23.4-10.6-51-4-67.1 16l-21.2 26.6c-48.9-27.3-88.9-68.8-114.4-118.8l24.2-19.3c20.1-16.1 26.7-43.7 16-67.1L181.6 40.9zM127.9 56.4c4-1.3 8.3 .6 10 4.4L177.6 148c1.5 3.4 .6 7.4-2.3 9.7l-38.9 31.1c-8.4 6.8-11.3 18.3-7 28.2 31.9 73.9 89.9 133.8 162.4 168.2 10.1 4.8 22.1 2 29-6.7l33.5-41.9c2.3-2.9 6.3-3.9 9.7-2.3l87.3 39.7c3.8 1.7 5.7 6 4.4 10-15.1 45.3-58.6 79.1-107 70.5-153.8-27.1-264.1-137.4-291.2-291.3-8.5-48.4 25.3-91.9 70.5-107z"]],
    "teddy-bear": [512, 512, [], "e3cf", ["M48 400l0 24 .2 4.1C50.3 448.3 67.3 464 88 464l335.3 0 5.1-.3c18.7-2 33.6-17.1 35.4-35.9l.2-3.8 0-24-.1-2.4c-1.1-11.3-10.1-20.3-21.4-21.4L440 376c-11.8 0-21.7 8.6-23.6 20-1.9 11.5-11.9 20-23.7 20l-.7 0c-13.2 0-24-10.8-24-24l0-52.4c0-8.6 4.6-16.5 12-20.8 31.6-18.3 58.8-43.3 79.6-73.1l1.3-2.1c5.5-9.9 3.3-22.4-5.3-29.8l-1.9-1.5c-10.9-7.6-25.8-4.9-33.4 6-34 48.6-88.8 81.4-151.5 85.3l-3.4 .1c-3 .2-6.1 .3-9.2 .3l-7.8-.2c-.2 0-.5 0-.7-.1-56.3-2.4-106.6-27.9-141.5-67.5l-7.1-8.5-.4-.6-6.2-8.4c-.7-.9-1.4-1.8-2.1-2.7-6.9-7.9-18.3-10.3-27.8-6.1l-4 2.3c-10.1 7-13.1 20.5-7.3 31.1l1.6 2.6 8.5 11.5 7.5 9.1c18 20.7 39.4 38.4 63.3 52.2l2.6 1.8c5.8 4.5 9.3 11.5 9.3 19l0 52.4c0 13.2-10.8 24-24 24l-.7 0c-10.2 0-19.2-6.5-22.6-15.8L95.6 396c-1.7-9.9-9.5-17.8-19.3-19.6L72 376c-13.2 0-24 10.7-24 24zM120 80c0 13.1 7.9 24.4 19.3 29.4 10.3 4.4 16.1 15.4 14.1 26.4-.9 4.8-1.4 10.2-1.4 16.2 0 55.3 43.2 100.5 97.7 103.8 2.1 .1 4.2 .2 6.3 .2 57.4 0 104-46.6 104-104 0-5.9-.5-11.3-1.4-16.2-2.1-11 3.8-22 14.1-26.4 11.4-4.9 19.3-16.3 19.3-29.4 0-17.7-14.3-32-32-32-13.9 0-25.7 8.9-30.2 21.4-4.1 11.6-16.2 18.2-28.1 15.4-13.5-3.2-28.9-4.7-45.7-4.8s-32.2 1.6-45.7 4.8c-11.9 2.8-24-3.8-28.1-15.4-4.4-12.5-16.3-21.4-30.2-21.4-17.7 0-32 14.3-32 32zm108 64a20 20 0 1 1 -40 0 20 20 0 1 1 40 0zM192 400c0-35.3 28.7-64 64-64s64 28.7 64 64l0 16-128 0 0-16zm32-200c0-13.3 14.3-24 32-24s32 10.7 32 24-14.3 24-32 24-32-10.7-32-24zm100-56a20 20 0 1 1 -40 0 20 20 0 1 1 40 0z", "M360 0c44.2 0 80 35.8 80 80 0 26.3-12.7 49.5-32.2 64.1 .1 2.6 .2 5.2 .2 7.9 0 5.4-.3 10.7-.8 15.9 22.9-11.7 51.3-10.7 73.9 5.1l5.8 4.5c25.8 22.2 32.5 59.7 15.9 89.5l-3.9 6.2c-14.3 20.5-31.3 39.1-50.2 55.4 35.7 4.3 63.3 34.6 63.3 71.4l0 24-.4 8.4c-3.7 38.9-32.7 70.4-70.4 77.9l-8.2 1.2c-.4 0-.8 .1-1.2 .1l-6.5 .3c-.4 0-.8 0-1.3 0L88 512C42.5 512 5 477.4 .5 433l-.5-9 0-24c0-36.8 27.6-67.1 63.3-71.4-11-9.4-21.3-19.6-30.8-30.5l-8.9-10.8c-.1-.2-.3-.4-.4-.6l-9.6-12.9-1.2-1.7-2.6-4.2c-.2-.3-.4-.6-.6-1-17.7-31.9-8.8-72.7 21.8-94l5.8-3.7c21.5-12.1 47-12 68-1.4-.5-5.2-.8-10.5-.8-15.9 0-2.7 .1-5.3 .2-7.9-19.5-14.6-32.2-37.8-32.2-64.1 0-44.2 35.8-80 80-80 27.4 0 51.4 13.8 65.8 34.7 12.4-1.8 25.2-2.7 38.2-2.7 13 0 25.8 .9 38.2 2.7 14.4-20.9 38.4-34.7 65.8-34.7zm93.6 212.3c-10.9-7.6-25.8-4.9-33.4 6l0 0c-33.9 48.6-88.8 81.4-151.5 85.3l-3.4 .1c-3 .2-6.1 .3-9.2 .3l-7.8-.2c-.2 0-.5 0-.7-.1-56.3-2.4-106.6-27.9-141.5-67.5l-7.1-8.5-.4-.6-6.2-8.4 0 0-2.1-2.7c-6.9-7.9-18.3-10.3-27.8-6.1l-4 2.3c-10.1 7-13.1 20.5-7.3 31.1l1.6 2.6 8.5 11.5 7.5 9.1c18 20.7 39.4 38.4 63.3 52.2l2.6 1.8c5.8 4.5 9.3 11.5 9.3 19l0 52.4c0 13.2-10.8 24-24 24l-.7 0c-10.2 0-19.2-6.5-22.6-15.8L95.6 396c-1.7-9.9-9.5-17.8-19.3-19.6L72 376c-13.2 0-24 10.7-24 24l0 24 .2 4.1C50.3 448.3 67.3 464 88 464l335.3 0 5.1-.3c18.7-2 33.6-17.1 35.4-35.9l.2-3.8 0-24-.1-2.4c-1.1-11.3-10.1-20.3-21.4-21.4L440 376c-11.8 0-21.7 8.6-23.6 20-1.9 11.5-11.9 20-23.7 20l-.7 0c-13.2 0-24-10.8-24-24l0-52.4c0-8.6 4.6-16.5 12-20.8 31.6-18.3 58.8-43.3 79.6-73.1l1.3-2.1c5.5-9.9 3.3-22.4-5.3-29.8l-1.9-1.5zM256 336c35.3 0 64 28.7 64 64l0 16-128 0 0-16c0-35.3 28.7-64 64-64zM360 48c-13.9 0-25.7 8.9-30.2 21.4-4.1 11.6-16.2 18.2-28.1 15.4-13.5-3.2-28.9-4.7-45.7-4.8s-32.2 1.6-45.7 4.8c-11.9 2.8-24-3.8-28.1-15.4-4.4-12.5-16.3-21.4-30.2-21.4-17.7 0-32 14.3-32 32 0 13.1 7.9 24.4 19.3 29.4 10.3 4.4 16.1 15.4 14.1 26.4-.9 4.8-1.4 10.2-1.4 16.2 0 55.3 43.2 100.5 97.7 103.8 2.1 .1 4.2 .2 6.3 .2 57.4 0 104-46.6 104-104 0-5.9-.5-11.3-1.4-16.2-2.1-11 3.8-22 14.1-26.4 11.4-4.9 19.3-16.3 19.3-29.4 0-17.7-14.3-32-32-32zM256 176c17.7 0 32 10.7 32 24s-14.3 24-32 24-32-10.7-32-24 14.3-24 32-24zm-48-12a20 20 0 1 1 0-40 20 20 0 1 1 0 40zm96 0a20 20 0 1 1 0-40 20 20 0 1 1 0 40z"]],
    "slot-machine": [640, 512, [], "e3ce", ["M80 96l0 320c0 8.8 7.2 16 16 16l352 0c8.8 0 16-7.2 16-16l0-320c0-7.7-5.5-14.2-12.8-15.7L448 80 96 80c-8.8 0-16 7.2-16 16zm32 88c0-13.3 10.7-24 24-24l48 0c7.3 0 14.2 3.3 18.7 9s6.3 13.1 4.7 20.3l-32 144c-2.9 12.9-15.7 21.1-28.7 18.2s-21.1-15.7-18.2-28.7L154.1 208 136 208c-13.3 0-24-10.7-24-24zm112 0c0-13.3 10.7-24 24-24l48 0c7.3 0 14.2 3.3 18.7 9s6.3 13.1 4.7 20.3l-32 144c-2.9 12.9-15.7 21.1-28.7 18.2s-21.1-15.7-18.2-28.7L266.1 208 248 208c-13.3 0-24-10.7-24-24zm112 0c0-13.3 10.7-24 24-24l48 0c7.3 0 14.2 3.3 18.7 9s6.3 13.1 4.7 20.3l-32 144c-2.9 12.9-15.7 21.1-28.7 18.2s-21.1-15.7-18.2-28.7L378.1 208 360 208c-13.3 0-24-10.7-24-24z", "M454.5 32.3C486.8 35.6 512 62.9 512 96l0 320-.3 6.5c-.3 3.2-1 6.4-1.8 9.5l18.1 0c22.1 0 40-17.9 40-40l0-206.5c-14.3-8.3-24-23.8-24-41.5 0-26.5 21.5-48 48-48s48 21.5 48 48c0 17.8-9.7 33.2-24 41.5L616 392c0 48.6-39.4 88-88 88l-432 0-6.5-.3c-30.1-3.1-54.1-27-57.1-57.1L32 416 32 96c0-33.1 25.2-60.4 57.5-63.7l6.5-.3 352 0 6.5 .3zM96 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l352 0c8.8 0 16-7.2 16-16l0-320c0-7.7-5.5-14.2-12.8-15.7L448 80 96 80zm88 80c7.3 0 14.2 3.3 18.7 9s6.3 13.1 4.7 20.3l-32 144c-2.9 12.9-15.7 21.1-28.7 18.2s-21.1-15.7-18.2-28.7L154.1 208 136 208c-13.3 0-24-10.7-24-24s10.7-24 24-24l48 0zm112 0c7.3 0 14.2 3.3 18.7 9s6.3 13.1 4.7 20.3l-32 144c-2.9 12.9-15.7 21.1-28.7 18.2s-21.1-15.7-18.2-28.7L266.1 208 248 208c-13.3 0-24-10.7-24-24s10.7-24 24-24l48 0zm112 0c7.3 0 14.2 3.3 18.7 9s6.3 13.1 4.7 20.3l-32 144c-2.9 12.9-15.7 21.1-28.7 18.2s-21.1-15.7-18.2-28.7L378.1 208 360 208c-13.3 0-24-10.7-24-24s10.7-24 24-24l48 0z"]],
    "face-sleeping": [640, 512, [], "e38d", ["M112 256c0-114.9 93.1-208 208-208 5.4 0 10.7 .2 16 .6L336 .5C377.8 3.1 417 15.7 451 36l-43 0c-11 0-20 9-20 20s9 20 20 20l22.4 0-38 47.5c-4.8 6-5.7 14.2-2.4 21.2S400.3 156 408 156l64 0c11 0 20-9 20-20s-9-20-20-20l-22.4 0 38-47.5c1-1.2 1.8-2.5 2.4-3.9 41.4 36.8 70.7 86.8 81.5 143.4l-49.1 0c3.6 15.4 5.6 31.5 5.6 48 0 114.9-93.1 208-208 208S112 370.9 112 256zm44-8c0 33.1 26.9 60 60 60l16 0c33.1 0 60-26.9 60-60 0-11-9-20-20-20s-20 9-20 20-9 20-20 20l-16 0c-11 0-20-9-20-20s-9-20-20-20-20 9-20 20zM280 384a40 40 0 1 0 80 0 40 40 0 1 0 -80 0zm68-136c0 33.1 26.9 60 60 60l16 0c33.1 0 60-26.9 60-60 0-11-9-20-20-20s-20 9-20 20-9 20-20 20l-16 0c-11 0-20-9-20-20s-9-20-20-20-20 9-20 20z", "M532-40c0 11 9 20 20 20l22.4 0-38 47.5c-4.8 6-5.7 14.2-2.4 21.2S544.3 60 552 60l64 0c11 0 20-9 20-20s-9-20-20-20l-22.4 0 38-47.5c4.8-6 5.7-14.2 2.4-21.2S623.7-60 616-60l-64 0c-11 0-20 9-20 20zM388 56c0 11 9 20 20 20l22.4 0-38 47.5c-4.8 6-5.7 14.2-2.4 21.2S400.3 156 408 156l64 0c11 0 20-9 20-20s-9-20-20-20l-22.4 0 38-47.5c4.8-6 5.7-14.2 2.4-21.2S479.7 36 472 36l-64 0c-11 0-20 9-20 20zM336 .5C330.7 .2 325.4 0 320 0 178.6 0 64 114.6 64 256S178.6 512 320 512 576 397.4 576 256c0-16.4-1.5-32.5-4.5-48l-49.1 0c3.6 15.4 5.6 31.5 5.6 48 0 114.9-93.1 208-208 208S112 370.9 112 256 205.1 48 320 48c5.4 0 10.7 .2 16 .6L336 .5zM360 384a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zm48-116c-11 0-20-9-20-20s-9-20-20-20-20 9-20 20c0 33.1 26.9 60 60 60l16 0c33.1 0 60-26.9 60-60 0-11-9-20-20-20s-20 9-20 20-9 20-20 20l-16 0zM196 248c0-11-9-20-20-20s-20 9-20 20c0 33.1 26.9 60 60 60l16 0c33.1 0 60-26.9 60-60 0-11-9-20-20-20s-20 9-20 20-9 20-20 20l-16 0c-11 0-20-9-20-20z"]],
    "jedi": [576, 512, [], "f669", ["M64.1 233.5c.3-10.7 1.4-21.3 3.1-31.6l17.5 17.5c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L76.5 165.9c8.3-23.7 20.5-45.6 35.8-64.9-.2 3.6-.3 7.3-.3 11 0 44.9 16.8 85.8 44.4 116.9-17.9 25.8-28.4 57.3-28.4 91.1 0 44.5 18.1 84.7 47.4 113.7-54.9-32-94.9-86.6-107.4-151l16.6 16.6c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L64.1 233.5zM400.6 433.7c29.3-29 47.4-69.2 47.4-113.7 0-33.8-10.5-65.2-28.4-91.1 27.6-31.1 44.4-72 44.4-116.9 0-3.7-.1-7.4-.3-11 15.3 19.3 27.5 41.2 35.8 64.9l-30.8 30.8c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l17.5-17.5c1.8 10.3 2.8 20.9 3.1 31.6l-43.2 43.2c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l16.6-16.6c-12.4 64.4-52.5 119.1-107.4 151z", "M224.8 267.9L246 299.7c1.3 1.9 .2 4.5-2 4.9l-37.6 7.5c-3.7 .7-6.4 4-6.4 7.8s2.7 7.1 6.4 7.8l37.6 7.5c2.2 .4 3.3 3 2 4.9l-21.2 31.9c-2.1 3.2-1.7 7.4 1 10.1s6.9 3.1 10.1 1l26.9-17.9c2.2-1.4 5.1 .2 5 2.8l-2.1 61.7c-51.2-10.3-89.7-55.6-89.7-109.8 0-29.6 11.5-56.5 30.2-76.5 4.5-4.8 6.8-11.2 6.4-17.7s-3.3-12.6-8.3-16.9c-27.2-23.5-44.4-58.2-44.4-96.9 0-26.9 8.3-51.9 22.5-72.5 6.4-9.3 5.5-21.7-2.2-30s-20-10-29.7-4.4C70.1 52.4 16 139.9 16 240 16 390.2 137.8 512 288 512S560 390.2 560 240c0-100.1-54.1-187.6-134.6-234.8-9.7-5.7-22.1-3.9-29.7 4.4s-8.6 20.7-2.2 30c14.2 20.6 22.5 45.5 22.5 72.5 0 38.7-17.2 73.4-44.4 96.9-4.9 4.3-7.9 10.4-8.3 16.9s2 12.9 6.4 17.7c18.8 20 30.2 46.9 30.2 76.5 0 54.2-38.5 99.4-89.7 109.8l-2.1-61.7c-.1-2.6 2.8-4.2 5-2.8l26.9 17.9c3.2 2.1 7.4 1.7 10.1-1s3.1-6.9 1-10.1L330 340.3c-1.3-1.9-.2-4.5 2-4.9l37.5-7.5c3.7-.7 6.4-4 6.4-7.8s-2.7-7.1-6.4-7.8L332 304.6c-2.2-.4-3.3-3-2-4.9l21.2-31.9c2.1-3.2 1.7-7.4-1-10.1s-6.9-3.1-10.1-1l-30 20c-2.1 1.4-4.9 0-5-2.6L296.3 8c-.1-4.5-3.8-8-8.3-8s-8.1 3.5-8.3 8l-8.9 266.2c-.1 2.5-2.9 3.9-5 2.6l-30-20c-3.2-2.1-7.4-1.7-10.1 1s-3.1 6.9-1 10.1zM64.1 233.5c.3-10.7 1.4-21.3 3.1-31.6l17.5 17.5c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L76.5 165.9c8.3-23.7 20.5-45.6 35.8-64.9-.2 3.6-.3 7.3-.3 11 0 44.9 16.8 85.8 44.4 116.9-17.9 25.8-28.4 57.3-28.4 91.1 0 44.5 18.1 84.7 47.4 113.7-54.9-32-94.9-86.6-107.4-151l16.6 16.6c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L64.1 233.5zm447.8 0l-43.2 43.2c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l16.6-16.6c-12.4 64.4-52.5 119.1-107.4 151 29.3-29 47.4-69.2 47.4-113.7 0-33.8-10.5-65.2-28.4-91.1 27.6-31.1 44.4-72 44.4-116.9 0-3.7-.1-7.4-.3-11 15.3 19.3 27.5 41.2 35.8 64.9l-30.8 30.8c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l17.5-17.5c1.8 10.3 2.8 20.9 3.1 31.6z"]],
    "police-box": [384, 512, [], "e021", ["M80 109.3l0 354.7 224 0 0-354.7c-13.6-4.8-24.4-15.6-29.3-29.3L109.3 80c-4.8 13.6-15.6 24.4-29.3 29.3zM112 160c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm0 96c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm96-96c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32z", "M192 0c13.3 0 24 10.7 24 24l0 8 72 0c17.7 0 32 14.3 32 32 17.7 0 32 14.3 32 32l0 368 8 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 512c-13.3 0-24-10.7-24-24s10.7-24 24-24l8 0 0-368c0-17.7 14.3-32 32-32 0-17.7 14.3-32 32-32l72 0 0-8c0-13.3 10.7-24 24-24zM80 464l224 0 0-354.7c-13.6-4.8-24.4-15.6-29.3-29.3L109.3 80c-4.8 13.6-15.6 24.4-29.3 29.3L80 464zm48-320l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zm0 96l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zm80-80c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32z"]],
    "dog-leashed": [576, 512, [129454], "f6d4", ["M112 208l0 248c0 4.4 3.6 8 8 8l32 0c4.4 0 8-3.6 8-8l0-104c0-8.1 4.1-15.7 10.9-20.1s15.4-5.1 22.8-1.8l20 8.9 5.1 2.1c6.9 2.6 14 4.4 21.2 5.6l0-138.6-128 0zm176 0l0 134.8c3.5-1.1 6.9-2.4 10.2-3.9l20-8.9c7.4-3.3 16-2.6 22.8 1.8 6.8 4.4 10.9 12 10.9 20.1l0 104c0 4.4 3.6 8 8 8l32 0c4.4 0 8-3.6 8-8l0-218.5-68.9-29.5-43.1 0zm53.5-47.8l65.2 27.9 1.8-8.9 1.2-4C413.2 166.2 422 160 432 160l40 0c30.9 0 56-25.1 56-56l0-24-40 0c-6.4 0-12.5-2.5-17-7L457.8 59.7C450.3 52.2 440.1 48 429.5 48l-64.7 0-23.4 112.2zM452 88a20 20 0 1 1 -40 0 20 20 0 1 1 40 0z", "M328.5-12.9c2.7-13 15.4-21.3 28.4-18.6s21.3 15.4 18.6 28.4l-.7 3.1 54.7 0 8.7 .4c20.1 2 39.1 10.9 53.5 25.3l6.2 6.2 54.1 0 2.5 .1C566.6 33.4 576 43.6 576 56l0 48c0 57.4-46.6 104-104 104l-20.3 0-3.7 18.4 0 229.6c0 30.9-25.1 56-56 56l-32 0c-30.9 0-56-25.1-56-56l0-67.9c-31.2 10.4-64.8 10.4-96 0l0 67.9c0 30.9-25.1 56-56 56l-32 0c-30.9 0-56-25.1-56-56l0-251.4C27.1 194.1 0 160.3 0 120 0 106.8 10.7 96 24 96s24 10.7 24 24c0 20.7 15.7 37.8 35.9 39.8l4.1 .2 142 0-134.4-126.5-1.7-1.8c-8-9.2-7.8-23.1 .7-32.2s22.4-10 32-2.6l1.9 1.6 160 150.6 5.2 4.9 34.8-167zM112 456c0 4.4 3.6 8 8 8l32 0c4.4 0 8-3.6 8-8l0-104c0-8.1 4.1-15.7 10.9-20.1s15.4-5.1 22.8-1.8l20 8.9 5.1 2.1c6.9 2.6 14 4.4 21.2 5.6l0-138.6-128 0 0 248zM288 342.8c3.5-1.1 6.9-2.4 10.2-3.9l20-8.9c7.4-3.3 16-2.6 22.8 1.8 6.8 4.4 10.9 12 10.9 20.1l0 104c0 4.4 3.6 8 8 8l32 0c4.4 0 8-3.6 8-8l0-218.5-68.9-29.5-43.1 0 0 134.8zm53.5-182.6l65.2 27.9 1.8-8.9 1.2-4C413.2 166.2 422 160 432 160l40 0c30.9 0 56-25.1 56-56l0-24-40 0c-6.4 0-12.5-2.5-17-7L457.8 59.7C450.3 52.2 440.1 48 429.5 48l-64.7 0-23.4 112.2zM432 108a20 20 0 1 1 0-40 20 20 0 1 1 0 40z"]],
    "person-hiking": [448, 512, ["hiking"], "f6ec", ["M176 176c0-7.3 4.9-13.5 11.6-15.4 1.4-.4 2.9-.6 4.4-.6 6.8 0 12.7 4.3 15 10.3 .7 1.8 1 3.7 1 5.7l0 142.1-17-13.6c-9.5-7.6-15-19.1-15-31.2l0-97.2z", "M192 80a56 56 0 1 0 0-112 56 56 0 1 0 0 112zm-16 96c0-7.3 4.9-13.5 11.6-15.4 1.4-.4 2.9-.6 4.4-.6 6.8 0 12.7 4.3 15 10.3 .7 1.8 1 3.7 1 5.7l0 142.1-17-13.6c-9.5-7.6-15-19.1-15-31.2l0-97.2zm80 180.5l0-138.7C272.1 232 292.9 240 314.5 240l53.5 0 0 280c0 13.3 10.7 24 24 24s24-10.7 24-24l0-400c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 72-53.5 0c-10.6 0-20.8-4.2-28.3-11.7l-44.2-44.2c-11.6-14.5-29.4-23.9-49.4-24.1-.4 0-.8 0-1.3 0-35.1 .3-63.4 28.9-63.4 64l0 97.2c0 26.7 12.2 52 33 68.7l75.9 60.7c8 6.4 13.3 15.7 14.7 25.9l12.6 94.5c1.8 13.1 13.8 22.4 27 20.6s22.4-13.8 20.6-27l-12.6-94.5c-3-22.5-14.6-42.9-32.3-57.1L256 356.5zM132.4 375l-7.2 21.7c-1.6 4.8-4.1 9.3-7.4 13.2l-80 94.6c-8.6 10.1-7.3 25.3 2.8 33.8s25.3 7.3 33.8-2.8l80-94.6c7.2-8.5 12.8-18.4 16.3-29l1-3.1-36.2-31c-1.1-.9-2.1-1.8-3.1-2.8zM64 96C28.7 96 0 124.7 0 160l0 96c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-128c0-17.7-14.3-32-32-32z"]],
    "arrows-up-to-line": [448, 512, [], "e4c2", ["", "M24 0C10.7 0 0 10.7 0 24S10.7 48 24 48l400 0c13.3 0 24-10.7 24-24S437.3 0 424 0L24 0zm89 135c-9.4-9.4-24.6-9.4-33.9 0L7 207c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l31-31 0 278.1c0 13.3 10.7 24 24 24s24-10.7 24-24l0-278.1 31 31c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-72-72zm256 0c-9.4-9.4-24.6-9.4-33.9 0l-72 72c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l31-31 0 278.1c0 13.3 10.7 24 24 24s24-10.7 24-24l0-278.1 31 31c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-72-72z"]],
    "pen-line": [576, 512, [], "e212", ["M58.5 453.5l86.9-24.1c6.6-1.8 12.7-5.4 17.6-10.3L370.1 212 300 141.9 92.9 349.1c-4.9 4.9-8.4 10.9-10.3 17.6L58.5 453.5z", "M58.9 315.1c-10.7 10.7-18.5 24.1-22.6 38.7L.9 481.6c-2.3 8.3 0 17.3 6.2 23.4s15.1 8.5 23.4 6.2l127.8-35.5c14.6-4.1 27.9-11.8 38.7-22.6l294-294C504.4 145.6 512 127.2 512 108s-7.6-37.6-21.2-51.1L455.1 21.2C441.6 7.6 423.2 0 404 0s-37.6 7.6-51.1 21.2l-294 294zM404 48c6.4 0 12.6 2.6 17.2 7.1l35.7 35.7c4.6 4.6 7.1 10.7 7.1 17.2s-2.6 12.6-7.1 17.2L404 178.1 333.9 108 386.8 55.1c4.6-4.6 10.7-7.1 17.2-7.1zM92.9 349.1L300 141.9 370.1 212 162.9 419.1c-4.9 4.9-10.9 8.4-17.6 10.3l-86.9 24.1 24.1-86.9c1.8-6.6 5.4-12.7 10.3-17.6zM280 464c-13.3 0-24 10.7-24 24s10.7 24 24 24l272 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-272 0z"]],
    "badge-percent": [512, 512, [], "f646", ["M48 256c0 24.1 13.5 45.1 33.5 55.7 10.2 5.4 15.1 17.2 11.7 28.2-6.6 21.6-1.4 46.1 15.7 63.1s41.5 22.3 63.1 15.7c11-3.4 22.9 1.5 28.2 11.7 10.6 20 31.6 33.5 55.7 33.5s45.1-13.5 55.7-33.5c5.4-10.2 17.2-15.1 28.2-11.7 21.6 6.6 46.1 1.4 63.1-15.7s22.3-41.5 15.7-63.1c-3.4-11 1.5-22.9 11.7-28.2 20-10.6 33.5-31.6 33.5-55.7s-13.5-45.1-33.5-55.7c-10.2-5.4-15.1-17.2-11.7-28.2 6.6-21.6 1.4-46.1-15.7-63.1S361.6 86.6 340 93.2c-11 3.4-22.9-1.5-28.2-11.7-10.6-20-31.6-33.5-55.7-33.5s-45.1 13.5-55.7 33.5c-5.4 10.2-17.2 15.1-28.2 11.7-21.6-6.6-46.1-1.4-63.1 15.7S86.6 150.4 93.2 172c3.4 11-1.5 22.9-11.7 28.2-20 10.6-33.5 31.6-33.5 55.7zm176-64a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM175 303L303 175c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9L209 337c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9zm177 17a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M200.3 81.5C210.9 61.5 231.9 48 256 48s45.1 13.5 55.7 33.5c5.4 10.2 17.2 15.1 28.2 11.7 21.6-6.6 46.1-1.4 63.1 15.7s22.3 41.5 15.7 63.1c-3.4 11 1.5 22.9 11.7 28.2 20 10.6 33.5 31.6 33.5 55.7s-13.5 45.1-33.5 55.7c-10.2 5.4-15.1 17.2-11.7 28.2 6.6 21.6 1.4 46.1-15.7 63.1s-41.5 22.3-63.1 15.7c-11-3.4-22.9 1.5-28.2 11.7-10.6 20-31.6 33.5-55.7 33.5s-45.1-13.5-55.7-33.5c-5.4-10.2-17.2-15.1-28.2-11.7-21.6 6.6-46.1 1.4-63.1-15.7S86.6 361.6 93.2 340c3.4-11-1.5-22.9-11.7-28.2-20-10.6-33.5-31.6-33.5-55.7s13.5-45.1 33.5-55.7c10.2-5.4 15.1-17.2 11.7-28.2-6.6-21.6-1.4-46.1 15.7-63.1S150.4 86.6 172 93.2c11 3.4 22.9-1.5 28.2-11.7zM256 0c-35.9 0-67.8 17-88.1 43.4-33-4.3-67.6 6.2-93 31.6s-35.9 60-31.6 93C17 188.2 0 220.1 0 256s17 67.8 43.4 88.1c-4.3 33 6.2 67.6 31.6 93s60 35.9 93 31.6C188.2 495 220.1 512 256 512s67.8-17 88.1-43.4c33 4.3 67.6-6.2 93-31.6s35.9-60 31.6-93C495 323.8 512 291.9 512 256s-17-67.8-43.4-88.1c4.3-33-6.2-67.6-31.6-93s-60-35.9-93-31.6C323.8 17 291.9 0 256 0zM192 224a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM320 352a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm17-177c-9.4-9.4-24.6-9.4-33.9 0L175 303c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0L337 209c9.4-9.4 9.4-24.6 0-33.9z"]],
    "mars-double": [640, 512, [9891], "f227", ["M48 304a128 128 0 1 0 256 0 128 128 0 1 0 -256 0zM360 431.8c67-4.1 120-59.8 120-127.8 0-24.6-6.9-47.6-19-67.1-6.6 2-13.7 3.1-21 3.1-26.6 0-49.8-14.4-62.3-35.9l-.8 .8c14.8 29.9 23.1 63.5 23.1 99.1 0 47.5-14.8 91.5-40 127.8z", "M288 40c0-13.3 10.7-24 24-24l128 0c13.3 0 24 10.7 24 24l0 128c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-70.1-99.7 99.7c22.4 29.5 35.7 66.4 35.7 106.3 0 97.2-78.8 176-176 176S0 401.2 0 304 78.8 128 176 128c39.9 0 76.8 13.3 106.3 35.7L382.1 64 312 64c-13.3 0-24-10.7-24-24zM176 432a128 128 0 1 0 0-256 128 128 0 1 0 0 256zm142.5 44.8c15.8-13 29.8-28.2 41.5-45.1 67-4.1 120-59.8 120-127.8 0-24.6-6.9-47.6-19-67.1 16-4.9 29.6-15.1 38.7-28.6 17.9 27.6 28.3 60.4 28.3 95.7 0 97.2-78.8 176-176 176-11.4 0-22.6-1.1-33.5-3.2zM512 110.1l46.1-46.1-46.1 0 0-24c0-8.4-1.4-16.5-4.1-24L616 16c13.3 0 24 10.7 24 24l0 128c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-70.1-80.8 80.8c.5-3.5 .8-7.1 .8-10.7l0-57.9z"]],
    "thermometer": [512, 512, [], "f491", ["M144 293.3l0 74.7 74.7 0c2.1 0 4.2-.8 5.7-2.3L447.8 142.2c10.4-10.4 16.2-24.4 16.2-39 0-30.5-24.7-55.2-55.2-55.2-14.6 0-28.7 5.8-39 16.2l-7.8 7.8 23 23c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-23-23-46.1 46.1 23 23c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-23-23-46.1 46.1 23 23c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-23-23-21.7 21.7c-1.5 1.5-2.3 3.5-2.3 5.7z", "M218.7 368l-74.7 0 0-74.7c0-2.1 .8-4.2 2.3-5.7l21.7-21.7 23 23c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-23-23 46.1-46.1 23 23c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-23-23 46.1-46.1 23 23c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-23-23 7.8-7.8c10.3-10.4 24.4-16.2 39-16.2 30.5 0 55.2 24.7 55.2 55.2 0 14.6-5.8 28.7-16.2 39L224.4 365.7c-1.5 1.5-3.5 2.3-5.7 2.3zM41 505l89-89 88.8 0c14.9 0 29.1-5.9 39.6-16.4L481.8 176.2c19.4-19.4 30.2-45.6 30.2-73 0-57-46.2-103.2-103.2-103.2-27.4 0-53.6 10.9-73 30.2L112.4 253.7C101.9 264.2 96 278.4 96 293.3l0 88.8-89 89 0 0c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l0 0z"]],
    "paintbrush": [576, 512, [128396, "paint-brush"], "f1fc", ["M248 268.9c25.7 12.5 46.6 33.4 59.1 59.1 21.4-.6 41.5-10.7 54.8-27.6L521.7 95.8c4.1-5.2 6.3-11.6 6.3-18.2 0-16.3-13.2-29.6-29.6-29.6-6.6 0-13 2.2-18.2 6.3L275.7 214.1c-17 13.2-27.1 33.4-27.6 54.8z", "M498.4 0c-17.3 0-34.1 5.8-47.8 16.4L246.1 176.3c-25.3 19.7-41.4 48.6-45.2 80-2.9-.2-5.9-.3-8.9-.3-70.7 0-128 57.3-128 128 0 8.6 .9 17.1 2.5 25.2 3.6 18.1-8.5 38.8-27 38.8L32 448c-17.7 0-32 14.3-32 32s14.3 32 32 32l160 0c70.7 0 128-57.3 128-128 0-3-.1-5.9-.3-8.9 31.4-3.8 60.3-20 80-45.2L559.6 125.3C570.2 111.7 576 94.9 576 77.6 576 34.7 541.3 0 498.4 0zM307.1 328c-12.5-25.7-33.4-46.6-59.1-59.1 .6-21.4 10.7-41.5 27.6-54.8L480.2 54.3c5.2-4.1 11.6-6.3 18.2-6.3 16.3 0 29.6 13.2 29.6 29.6 0 6.6-2.2 13-6.3 18.2L361.9 300.3c-13.2 17-33.4 27.1-54.8 27.6zM272 384c0 44.2-35.8 80-80 80l-92.1 0c.5-.7 1-1.5 1.5-2.2 11.5-17.5 16.6-39.9 12.2-62-1-5.1-1.6-10.4-1.6-15.8 0-44.2 35.8-80 80-80s80 35.8 80 80z"]],
    "signal-stream": [576, 512, [], "f8dd", ["", "M107.2 62.1c9.9 8.8 10.7 24 1.9 33.9-38 42.5-61.1 98.5-61.1 160s23.1 117.5 61.1 160c8.8 9.9 8 25-1.9 33.9s-25 8-33.9-1.9C27.7 397.1 0 329.7 0 256S27.7 114.9 73.3 64c8.8-9.9 24-10.7 33.9-1.9zm361.5 0c9.9-8.8 25-8 33.9 1.9 45.6 50.9 73.3 118.3 73.3 192s-27.8 141.1-73.3 192c-8.8 9.9-24 10.7-33.9 1.9s-10.7-24-1.9-33.9c38-42.5 61.1-98.5 61.1-160S504.9 138.5 466.9 96c-8.8-9.9-8-25 1.9-33.9zM240 256a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm-46.3-86.5C172.7 192.3 160 222.6 160 256s12.7 63.7 33.7 86.5c9 9.8 8.3 24.9-1.4 33.9s-24.9 8.3-33.9-1.4C129.6 343.7 112 301.9 112 256s17.6-87.7 46.3-119c9-9.8 24.1-10.4 33.9-1.4s10.4 24.1 1.4 33.9zm224-32.5c28.7 31.3 46.3 73.1 46.3 119s-17.6 87.7-46.3 119c-9 9.8-24.1 10.4-33.9 1.4s-10.4-24.1-1.4-33.9C403.3 319.7 416 289.4 416 256s-12.7-63.7-33.7-86.5c-9-9.8-8.3-24.9 1.4-33.9s24.9-8.3 33.9 1.4z"]],
    "square-p": [448, 512, [], "e279", ["M48 96l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16zm96 72c0-13.3 10.7-24 24-24l68 0c46.4 0 84 37.6 84 84s-37.6 84-84 84l-44 0 0 32c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-176zm48 24l0 72 44 0c19.9 0 36-16.1 36-36s-16.1-36-36-36l-44 0z", "M64 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm168 48l68 0c46.4 0 84 37.6 84 84s-37.6 84-84 84l-44 0 0 32c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-176c0-13.3 10.7-24 24-24zm68 120c19.9 0 36-16.1 36-36s-16.1-36-36-36l-44 0 0 72 44 0z"]],
    "bee": [512, 512, [], "e0b2", ["M256 496l-80-80 160 0-80 80zm0-464c35.3 0 64 28.7 64 64l0 32c0 .9-.1 1.8-.2 2.7 90.9 15.2 160.2 94.2 160.2 189.3l0 48-32 0c-27.3 0-53.2-5.7-76.7-16l-230.5 0c-23.5 10.3-49.5 16-76.8 16l-32 0 0-48c0-95.2 69.3-174.2 160.1-189.3 0-.9-.1-1.8-.1-2.7l0-32c0-35.3 28.7-64 64-64zm0 160c-.2 0-.5-.1-.7-.1l0 .1 1.4 0 0-.1c-.2 0-.5 .1-.7 .1z", "M311 7c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9L329.8 56.1c9 13.8 14.2 30.2 14.2 47.9l0 13.4C440.2 139.2 512 225.2 512 328l0 32-.1 2.5C510.6 374.6 500.4 384 488 384l-40 0c-21.4 0-42.1-3.2-61.7-9-28.9 59.7-95.3 115.6-116 132.1l-3.2 2.1c-3.4 1.8-7.2 2.7-11.1 2.7s-7.7-.9-11.1-2.7l-3.2-2.1c-20.7-16.5-87.2-72.4-116.1-132.1-19.5 5.8-40.2 9-61.7 9l-40 0c-12.4 0-22.6-9.4-23.9-21.5L0 360 0 328C0 225.2 71.8 139.2 168 117.4l0-13.4c0-17.7 5.2-34.1 14.2-47.9L167 41 165.4 39.2c-7.7-9.4-7.1-23.3 1.7-32.1s22.7-9.3 32.1-1.7L201 7 218.4 24.5C229.8 19.1 242.5 16 256 16s26.1 3.1 37.5 8.5L311 7zM217.6 420c13.8 14.5 27.6 27.1 38.4 36.5 10.8-9.4 24.6-21.9 38.4-36.5l-76.9 0zm-47.6-63.8c3.8 7.4 8.5 15.4 14.4 23.8l143.3 0c5.9-8.4 10.6-16.4 14.4-23.8-.1-.1-.2-.1-.3-.2l-171.4 0c-.1 .1-.3 .1-.4 .2zM216 160c-92.8 0-168 75.2-168 168l0 8 16 0c92.8 0 168-75.2 168-168l0-8-16 0zm64 8c0 92.8 75.2 168 168 168l16 0 0-8c0-92.8-75.2-168-168-168l-16 0 0 8zm-24 98.9c-9.3 18-21 34.5-34.8 49.1l69.5 0c-13.7-14.6-25.5-31.1-34.7-49.1zM256 64c-22.1 0-40 17.9-40 40l0 8 80 0 0-8c0-22.1-17.9-40-40-40z"]],
    "music-slash": [576, 512, [], "f8d1", ["M224 113.7l0 44.5 3.2 3.2 236.8-52.6 0-44.9c0-5.1-4.7-8.9-9.7-7.8l-224 49.8c-3.7 .8-6.3 4.1-6.3 7.8zM380.4 314.5L432 366.2c18.6-4.4 32-16.2 32-30.2 0-17.7-21.5-32-48-32-14.1 0-26.8 4.1-35.6 10.5z", "M41-24.9c-9.4-9.4-24.6-9.4-33.9 0S-2.3-.3 7 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9L468.7 402.9C494.8 388.6 512 364 512 336l0-272.1c0-35.8-33.2-62.4-68.1-54.7L219.9 59c-24.5 5.4-42.2 26.5-43.7 51.3L41-24.9zM227.2 161.4l-3.2-3.2 0-44.5c0-3.7 2.6-7 6.3-7.8l224-49.8c5-1.1 9.7 2.7 9.7 7.8l0 44.9-236.8 52.6zm40.2 40.2l196.6-43.7 0 108.8c-14.1-6.8-30.5-10.7-48-10.7-27.3 0-51.9 9.5-69.4 24.7l-79.1-79.1zM380.4 314.5c8.8-6.5 21.5-10.5 35.6-10.5 26.5 0 48 14.3 48 32 0 13.9-13.3 25.8-32 30.2l-51.6-51.6zM176 245.8l0 84.9c-14.1-6.8-30.5-10.7-48-10.7-53 0-96 35.8-96 80s43 80 96 80 96-35.8 96-80l0-106.2-48-48zM176 400c0 17.7-21.5 32-48 32s-48-14.3-48-32 21.5-32 48-32 48 14.3 48 32z"]],
    "person-simple": [192, 512, [], "e220", ["M48 224c0-8.8 7.2-16 16-16l64 0c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16l-64 0c-8.8 0-16-7.2-16-16l0-64z", "M96 0A64 64 0 1 1 96 128 64 64 0 1 1 96 0zM48 224l0 64c0 8.8 7.2 16 16 16l64 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16l-64 0c-8.8 0-16 7.2-16 16zM0 224c0-35.3 28.7-64 64-64l64 0c35.3 0 64 28.7 64 64l0 64c0 23.7-12.9 44.4-32 55.4L160 488c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-136-32 0 0 136c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-144.6C12.9 332.4 0 311.7 0 288l0-64z"]],
    "album-collection-circle-user": [576, 512, [], "e48f", ["M64.5 240l261.8 0c-14.7 9.8-28 21.5-39.4 34.9-10.7-2-20.4-2.9-30.4-2.9-63.1 0-114.3 35.8-114.3 80 0 40.8 43.7 74.5 100.8 79.5 1.8 11.2 4.7 22.1 8.4 32.5l-154.9 0-32-224z", "M152.5 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l208 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-208 0zm-48 96c-13.3 0-24 10.7-24 24s10.7 24 24 24l304 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-304 0zM484.8 208.6C475.6 198 462.4 192 448.5 192l-384 0c-13.9 0-27.1 6-36.3 16.6S15 233 17 246.8l32 224C52.4 494.4 72.6 512 96.5 512l180 0c-10.5-14.6-19-30.7-25.1-48l-154.9 0-32-224 261.8 0c30.4-20.2 66.9-32 106.2-32 20.3 0 39.8 3.1 58.1 9-1.6-3-3.6-5.8-5.8-8.4zM256.5 272c-63.1 0-114.3 35.8-114.3 80 0 41 44.1 74.8 100.8 79.5-1.7-10.2-2.6-20.7-2.6-31.5 0-9.5 .7-18.8 2-27.8-10.7-3.6-18-11.3-18-20.2 0-11.7 12.9-21.4 29.3-22.3 7.9-20.2 19.2-38.7 33.1-54.8-9.7-1.9-19.9-2.9-30.4-2.9zm320 128a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-66.3 80.7C490 500.1 462.7 512 432.5 512s-57.5-11.9-77.7-31.3c6.2-19 24-32.7 45.1-32.7l65.2 0c21 0 38.9 13.7 45.1 32.7zM384.5 368a48 48 0 1 1 96 0 48 48 0 1 1 -96 0z"]],
    "whale": [640, 512, [128011], "f72c", ["M50.5 341.5C66.4 358 88.7 368 113 368l1 0c20 0 39.4-6.8 55-19.3L300.9 243.1c54.3-43.5 121.8-67.1 191.4-67.1 55 0 99.7 44.6 99.7 99.7L592 384c0 26.5-21.5 48-48 48l-381.6 0c-55 0-100.9-38.8-111.9-90.5zM368 304a24 24 0 1 0 48 0 24 24 0 1 0 -48 0z", "M175.8 13.4c-1-5.9-5.2-10.8-10.9-12.6s-12-.3-16.2 3.9L108 45.4C89.7 63.7 81.4 89.6 85.6 115.1l7.9 47.4-49.9 49.9C15.7 240.3 0 278.2 0 317.6 0 407.3 72.7 480 162.4 480L544 480c53 0 96-43 96-96l0-108.3c0-81.6-66.1-147.7-147.7-147.7-80.5 0-158.6 27.4-221.4 77.7L139 311.2c-7.1 5.7-15.9 8.8-25 8.8l-1 0c-19 0-35.2-13.7-38.4-32.5-1.7-9.9 .6-20.1 6.3-28.4 28-40.7 42.8-62.2 44.4-64.6l47.6 7.9c25.5 4.2 51.5-4.1 69.7-22.3l40.7-40.7c4.2-4.2 5.8-10.5 3.9-16.2s-6.7-9.9-12.6-10.9l-84.7-14.1-14.1-84.7zM50.5 341.5C66.4 358 88.7 368 113 368l1 0c20 0 39.4-6.8 55-19.3L300.9 243.1c54.3-43.5 121.8-67.1 191.4-67.1 55 0 99.7 44.6 99.7 99.7L592 384c0 26.5-21.5 48-48 48l-381.6 0c-55 0-100.9-38.8-111.9-90.5zM392 328a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]],
    "arrow-up-triangle-square": [512, 512, ["sort-shapes-up"], "f88a", ["M336 336l0 96 96 0 0-96-96 0zm1.6-160l92.8 0-46.4-77.4-46.4 77.4z", "M384 32c-9.9 0-19.1 5.2-24.2 13.7L275.6 186c-2.3 3.9-3.6 8.4-3.6 12.9 0 13.8 11.2 25.1 25.1 25.1l173.9 0c13.8 0 25.1-11.2 25.1-25.1 0-4.5-1.2-9-3.6-12.9L408.2 45.7C403.1 37.2 393.9 32 384 32zM336 432l0-96 96 0 0 96-96 0zM384 98.6l46.4 77.4-92.8 0 46.4-77.4zM288 432c0 26.5 21.5 48 48 48l96 0c26.5 0 48-21.5 48-48l0-96c0-26.5-21.5-48-48-48l-96 0c-26.5 0-48 21.5-48 48l0 96zM145 39c-9.4-9.4-24.6-9.4-33.9 0L23 127c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l47-47 0 342.1c0 13.3 10.7 24 24 24s24-10.7 24-24l0-342.1 47 47c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9L145 39z"]],
    "neuter": [384, 512, [9906], "f22c", ["M64 176a128 128 0 1 0 256 0 128 128 0 1 0 -256 0z", "M64 176a128 128 0 1 1 256 0 128 128 0 1 1 -256 0zM216 350.4C301.8 338.7 368 265.1 368 176 368 78.8 289.2 0 192 0S16 78.8 16 176c0 89.1 66.2 162.7 152 174.4L168 488c0 13.3 10.7 24 24 24s24-10.7 24-24l0-137.6z"]],
    "square-phone-flip": [448, 512, ["phone-square-alt"], "f87b", ["M48 96l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16zM96.7 328c-2.7-9.8 2.4-20.1 11.8-24l48.7-20.3c8.3-3.4 17.8-1.1 23.5 5.9L193 304.6c34.3-17.3 62-45.9 78.1-80.9l-13.6-11.1c-6.9-5.7-9.3-15.2-5.9-23.5l20.3-48.7c3.9-9.4 14.2-14.4 24-11.8l2.8 .8c32.3 8.8 59.9 40.1 51.8 78.2-18.5 87.5-87.4 156.3-174.9 174.9-38.1 8.1-69.4-19.5-78.2-51.8l-.8-2.8z", "M64 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm296 32.7l2.8 .8c32.3 8.8 59.9 40.1 51.8 78.2-18.5 87.5-87.4 156.3-174.9 174.9-38.1 8.1-69.4-19.5-78.2-51.8l-.8-2.8c-2.7-9.8 2.4-20.1 11.8-24l48.7-20.3c8.3-3.4 17.8-1.1 23.5 5.9L193 304.6c34.3-17.3 62-45.9 78.1-80.9l-13.6-11.1c-6.9-5.7-9.3-15.2-5.9-23.5l20.3-48.7c3.9-9.4 14.2-14.4 24-11.8z"]],
    "circle-g": [512, 512, [], "e10f", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm88 0c0-66.3 53.7-120 120-120 30.7 0 58.8 11.6 80 30.6 9.9 8.8 10.7 24 1.9 33.9s-24 10.7-33.9 1.9c-12.8-11.4-29.5-18.3-48-18.3-39.8 0-72 32.2-72 72s32.2 72 72 72c28.3 0 52.7-16.3 64.5-40L280 288c-13.3 0-24-10.7-24-24s10.7-24 24-24l71.7 0c6.7 0 13.1 2.8 17.7 7.7s6.8 11.5 6.3 18.2c-5.1 61.6-56.7 110-119.6 110-66.3 0-120-53.7-120-120z", "M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM184 256c0-39.8 32.2-72 72-72 18.5 0 35.2 6.9 48 18.3 9.9 8.8 25 8 33.9-1.9s8-25-1.9-33.9c-21.2-19-49.3-30.6-80-30.6-66.3 0-120 53.7-120 120s53.7 120 120 120c62.9 0 114.5-48.4 119.6-110 .6-6.7-1.7-13.3-6.3-18.2s-10.9-7.7-17.7-7.7L280 240c-13.3 0-24 10.7-24 24s10.7 24 24 24l40.5 0c-11.8 23.7-36.3 40-64.5 40-39.8 0-72-32.2-72-72z"]],
    "circle-down-right": [512, 512, [], "e108", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm103-81l24-24c9.4-9.4 24.6-9.4 33.9 0l67 67 35-35c6.9-6.9 17.2-8.9 26.2-5.2S352 190.3 352 200l0 128c0 13.3-10.7 24-24 24l-128 0c-9.7 0-18.5-5.8-22.2-14.8s-1.7-19.3 5.2-26.2l35-35-67-67c-9.4-9.4-9.4-24.6 0-33.9z", "M256 464a208 208 0 1 1 0-416 208 208 0 1 1 0 416zM256 0a256 256 0 1 0 0 512 256 256 0 1 0 0-512zM200 352l128 0c13.3 0 24-10.7 24-24l0-128c0-9.7-5.8-18.5-14.8-22.2s-19.3-1.7-26.2 5.2l-35 35-67-67c-9.4-9.4-24.6-9.4-33.9 0l-24 24c-9.4 9.4-9.4 24.6 0 33.9l67 67-35 35c-6.9 6.9-8.9 17.2-5.2 26.2S190.3 352 200 352z"]],
    "people-dress": [576, 512, [], "e217", ["M96.7 336l127.7 0-48.4-164.5c-2-6.7-8.3-11.5-15.5-11.5S147 164.8 145 171.5L96.7 336zm256 0l127.7 0-48.4-164.5c-2-6.7-8.3-11.5-15.5-11.5S403 164.8 401 171.5L352.7 336z", "M160.5-32a56 56 0 1 1 0 112 56 56 0 1 1 0-112zm63.9 368L176 171.5c-2-6.7-8.3-11.5-15.5-11.5S147 164.8 145 171.5L96.7 336 224.4 336zm43.6-35.6l-7.5-11.9 22.1 75c3 10.2-4.7 20.5-15.3 20.5l-42.6 0 0 136c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-136-32 0 0 136c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-136-42.6 0c-10.7 0-18.4-10.3-15.3-20.5l27.6-93.8-21.8 31.9c-7.5 10.9-22.4 13.7-33.4 6.3s-13.7-22.4-6.3-33.4L92 146.8C106.9 125 131.6 112 158 112l3.6 0c27.4 0 53 14.1 67.6 37.3l59.2 93.8 59.2-93.8c14.7-23.2 40.2-37.3 67.6-37.3l3.6 0c26.4 0 51.1 13 66 34.8l87.3 127.6c7.5 10.9 4.7 25.9-6.3 33.4s-25.9 4.7-33.4-6.3l-21.8-31.9 27.6 93.8c3 10.2-4.7 20.5-15.4 20.5l-42.6 0 0 136c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-136-32 0 0 136c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-136-42.6 0c-10.7 0-18.4-10.3-15.3-20.5l22.1-75-7.5 11.9c-1 1.6-2.2 3.2-3.6 4.6-2 2-4.4 3.7-7 4.8-6.5 3-13.8 2.8-20 0-2.6-1.2-4.9-2.8-7-4.8-1.4-1.4-2.6-2.9-3.6-4.6zM416.5 160c-7.2 0-13.5 4.8-15.5 11.5L352.7 336 480.3 336 432 171.5c-2-6.7-8.3-11.5-15.5-11.5zm0-192a56 56 0 1 1 0 112 56 56 0 1 1 0-112z"]],
    "circle-half": [512, 512, [], "e110", ["M48 256c0 98.3 68.3 180.8 160 202.4l0-404.9C116.3 75.2 48 157.7 48 256z", "M208 53.6C116.3 75.2 48 157.7 48 256s68.3 180.8 160 202.4l0-404.9zM224.1 2C241.6-.2 256 14.3 256 32l0 448C256 497.7 241.6 512.2 224.1 510 97.8 494.3 0 386.6 0 256S97.8 17.7 224.1 2z"]],
    "face-grin-tongue-squint": [512, 512, [128541, "grin-tongue-squint"], "f58a", ["M48 256c0 75.9 40.7 142.4 101.5 178.7-3.6-10.9-5.5-22.6-5.5-34.7l0-37.5c-10.2-12.6-18.3-26.9-23.8-42.4-4.1-11.6 7.8-21.4 19.6-17.8 34.7 10.6 74.2 16.5 116.1 16.5 42 0 81.5-6 116.3-16.6 11.8-3.6 23.7 6.1 19.6 17.8-5.5 15.6-13.6 29.9-23.8 42.5l0 37.5c0 12.1-1.9 23.8-5.5 34.7 60.8-36.3 101.5-102.7 101.5-178.7 0-114.9-93.1-208-208-208S48 141.1 48 256zm74.6-96.8c4.5-6.8 13.3-9.2 20.6-5.5l79.6 40c5.4 2.7 8.8 8.2 8.8 14.3s-3.4 11.6-8.8 14.3l-79.6 40c-7.3 3.6-16.1 1.3-20.6-5.5s-3.1-15.9 3.1-21.1L159 208 125.8 180.3c-6.2-5.2-7.6-14.3-3.1-21.1zM280.4 208c0-6 3.4-11.6 8.8-14.3l79.6-40c7.3-3.6 16.1-1.3 20.6 5.5s3.1 15.9-3.1 21.1L353 208 386.2 235.7c6.2 5.2 7.6 14.3 3.1 21.1s-13.3 9.2-20.6 5.5l-79.6-40c-5.4-2.7-8.8-8.2-8.8-14.3z", "M464 256c0-114.9-93.1-208-208-208S48 141.1 48 256c0 75.9 40.7 142.4 101.5 178.7-3.6-10.9-5.5-22.6-5.5-34.7l0-37.5c-10.2-12.6-18.3-26.9-23.8-42.4-4.1-11.6 7.8-21.4 19.6-17.8 34.7 10.6 74.2 16.5 116.1 16.5 42 0 81.5-6 116.3-16.6 11.8-3.6 23.7 6.1 19.6 17.8-5.5 15.6-13.6 29.9-23.8 42.5l0 37.5c0 12.1-1.9 23.8-5.5 34.7 60.8-36.3 101.5-102.7 101.5-178.7zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm125.8-75.7c-6.2-5.2-7.6-14.3-3.1-21.1s13.3-9.2 20.6-5.5l79.6 40c5.4 2.7 8.8 8.2 8.8 14.3s-3.4 11.6-8.8 14.3l-79.6 40c-7.3 3.6-16.1 1.3-20.6-5.5s-3.1-15.9 3.1-21.1L159 208 125.8 180.3zm263.6-21.1c4.5 6.8 3.1 15.9-3.1 21.1L353 208 386.2 235.7c6.2 5.2 7.6 14.3 3.1 21.1s-13.3 9.2-20.6 5.5l-79.6-40c-5.4-2.7-8.8-8.2-8.8-14.3s3.4-11.6 8.8-14.3l79.6-40c7.3-3.6 16.1-1.3 20.6 5.5zM320 416l0-37.4c0-14.7-11.9-26.6-26.6-26.6l-2 0c-11.3 0-21.1 7.9-23.6 18.9-2.8 12.6-20.8 12.6-23.6 0-2.5-11.1-12.3-18.9-23.6-18.9l-2 0c-14.7 0-26.6 11.9-26.6 26.6l0 37.4c0 35.3 28.7 64 64 64s64-28.7 64-64z"]],
    "pickaxe": [576, 512, [], "e5bf", ["M261.2 24.4c112.3 54.8 203.6 146 258.4 258.4 5.5-18.6 8.4-38.3 8.4-58.8 0-114.9-93.1-208-208-208-20.4 0-40.2 2.9-58.8 8.4z", "M528 224c0 20.4-2.9 40.2-8.4 58.8-54.8-112.3-146-203.6-258.4-258.4 18.6-5.5 38.3-8.4 58.8-8.4 114.9 0 208 93.1 208 208zm17.1 122l.4-.7c19.5-36.1 30.5-77.4 30.5-121.3 0-62-22.1-118.9-58.8-163.3L537 41c9.4-9.4 9.4-24.6 0-33.9S512.4-2.3 503 7L483.3 26.8C438.9-9.9 382-32 320-32 276.1-32 234.8-21 198.7-1.5l-.7 .4c-2.7 1.5-5.3 3-7.9 4.5-6.2 3.6-12.2 7.5-18 11.7-10.4 7.3-6.8 22.9 5.2 26.9 6.2 2.1 12.4 4.2 18.5 6.5 2.5 .9 5.1 1.9 7.6 2.9l.4 .2c58.3 23 111.4 56.4 157 97.9L39 471c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0L394.6 183.3c41.5 45.6 74.9 98.6 97.9 157l.2 .4c1 2.5 2 5 2.9 7.6 2.3 6.1 4.5 12.3 6.5 18.5 4 12.1 19.5 15.6 26.9 5.2 4.1-5.8 8-11.8 11.7-18 1.5-2.6 3-5.3 4.5-7.9z"]],
    "comment-dollar": [512, 512, [], "f651", ["M48 240c0 42.8 15.1 82.4 41.2 114.7 12.2 15.1 14.1 36.1 4.8 53.2l-18 33.1 58.5-25.1c11.8-5.1 25.2-5.2 37.1-.3 25.7 10.5 54.2 16.4 84.3 16.4 117.8 0 208-88.8 208-192S373.8 48 256 48 48 136.8 48 240zm140-35.5c0-28.8 23.2-52.2 52-52.5l0-4c0-11 9-20 20-20s20 9 20 20l0 4 8 0c11 0 20 9 20 20s-9 20-20 20l-47.5 0c-6.9 0-12.5 5.6-12.5 12.5 0 6.1 4.4 11.3 10.4 12.3l41.7 7c25.3 4.2 43.9 26.1 43.9 51.8 0 26.1-19 47.7-44 51.8l0 4.7c0 11-9 20-20 20s-20-9-20-20l0-4-24 0c-11 0-20-9-20-20s9-20 20-20l55.5 0c6.9 0 12.5-5.6 12.5-12.5 0-6.1-4.4-11.3-10.4-12.3l-41.7-7C206.5 252 188 230.1 188 204.5z", "M0 240c0 54.4 19.3 104.6 51.9 144.9L3.1 474.3c-2 3.7-3.1 7.9-3.1 12.2 0 14.1 11.4 25.5 25.5 25.5 4 0 7.8-.6 11.5-2.1L153.4 460c31.4 12.9 66.1 20 102.6 20 141.4 0 256-107.5 256-240S397.4 0 256 0 0 107.5 0 240zM94 407.9c9.3-17.1 7.4-38.1-4.8-53.2-26.1-32.3-41.2-71.9-41.2-114.7 0-103.2 90.2-192 208-192s208 88.8 208 192-90.2 192-208 192c-30.2 0-58.7-5.9-84.3-16.4-11.9-4.9-25.3-4.8-37.1 .3L76 440.9 94 407.9zM260 128c-11 0-20 9-20 20l0 4c-28.8 .3-52 23.7-52 52.5 0 25.7 18.5 47.6 43.9 51.8l41.7 7c6 1 10.4 6.2 10.4 12.3 0 6.9-5.6 12.5-12.5 12.5L216 288c-11 0-20 9-20 20s9 20 20 20l24 0 0 4c0 11 9 20 20 20s20-9 20-20l0-4.7c25-4.1 44-25.7 44-51.8 0-25.7-18.5-47.6-43.9-51.8l-41.7-7c-6-1-10.4-6.2-10.4-12.3 0-6.9 5.6-12.5 12.5-12.5l47.5 0c11 0 20-9 20-20s-9-20-20-20l-8 0 0-4c0-11-9-20-20-20z"]],
    "list-timeline": [512, 512, [], "e1d1", ["M168 96l.7-.7 39.3 39.3c.5 .5 1 .9 1.5 1.4l-1.5 0-40-40zm0 320l40-40 1.5 0c-.5 .4-1 .9-1.5 1.4l-39.3 39.3-.7-.7zM221.3 80l16-16 162.7 0 0 32-162.7 0-16-16zm0 176l16-16 226.7 0 0 32-226.7 0-16-16zm0 176l16-16 162.7 0 0 32-162.7 0-16-16z", "M208 486.6c6 6 14.1 9.4 22.6 9.4L416 496c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-185.4 0c-8.5 0-16.6 3.4-22.6 9.4l-43.3 43.3c-6.2 6.2-6.2 16.4 0 22.6L208 486.6zM221.3 80l16-16 162.7 0 0 32-162.7 0-16-16zm0 176l16-16 226.7 0 0 32-226.7 0-16-16zm0 176l16-16 162.7 0 0 32-162.7 0-16-16zM208 25.4L164.7 68.7c-6.2 6.2-6.2 16.4 0 22.6L208 134.6c6 6 14.1 9.4 22.6 9.4L416 144c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32L230.6 16c-8.5 0-16.6 3.4-22.6 9.4zM230.6 192c-8.5 0-16.6 3.4-22.6 9.4l-43.3 43.3c-6.2 6.2-6.2 16.4 0 22.6L208 310.6c6 6 14.1 9.4 22.6 9.4L480 320c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-249.4 0zM64 48a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm0 176a32 32 0 1 0 0 64 32 32 0 1 0 0-64zM96 432a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"]],
    "swords-laser": [640, 512, [], "e03d", ["M60.4-3.5L362.1 272 309 272 60.4-3.5zM387.5 170.6L579.7-3.7 406.2 187.6c-6.2-5.7-12.4-11.4-18.6-17z", "M406.2 187.6l35.4 32.4 177-195.1C635.7 6 635-23 617-41s-47-18.7-65.9-1.6L351.9 138.1 387.5 170.6 579.7-3.7 406.2 187.6zM280.9 391.1l-60.7-60.7c-11.4-11.4-16.8-25.3-17.5-38.9l-6.7-7.4-162 162c-18.7 18.7-18.7 49.1 0 67.9l28.1 28.1c18.7 18.7 49.1 18.7 67.9 0L280.9 391.1zm-57-10.9l-19.7 19.7-28.1-28.1 19.7-19.7 28.1 28.1zm-48 48l-79.9 79.9-28.1-28.1 79.9-79.9 28.1 28.1zM60.4-3.5L362.1 272 309 272 60.4-3.5zM21.3 24.8L250 278.2c-4.5 5.9-4.9 14.9 1.4 21.1 8 8 14.6 14.6 19.6 19.6l1 1 222.1 222.1c18.7 18.7 49.1 18.7 67.9 0l44.1-44.1c18.7-18.7 18.7-49.1 0-67.9L457.4 281.4c-6-6-14.1-9.4-22.6-9.4l-1.4 0-344.4-314.4C70.1-59.6 41-59 23-40.9 5-23 4.3 6 21.3 24.8zM528 508.1L458.9 439 503 394.9 572.1 464 528 508.1zm-103-103l-85.1-85.1 88.2 0 41 41-44.1 44.1z"]],
    "phone-waveform": [640, 512, [], "e6e2", ["M121.4 163.4c27.1 153.8 137.4 264.2 291.2 291.3 48.4 8.5 91.9-25.3 107-70.5 1.3-4-.6-8.3-4.4-10L428 334.4c-3.4-1.5-7.4-.6-9.7 2.3l-33.5 41.9c-7 8.7-19 11.5-29 6.7-72.5-34.4-130.5-94.3-162.4-168.2-4.3-9.9-1.4-21.5 7-28.2l38.9-31.1c2.9-2.3 3.9-6.3 2.3-9.7L201.9 60.7c-1.7-3.8-6-5.7-10-4.4-45.2 15.1-79.1 58.6-70.5 107z", "M480-8c0-13.3-10.7-24-24-24S432-21.3 432-8l0 208c0 13.3 10.7 24 24 24s24-10.7 24-24L480-8zm80 32c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 144c0 13.3 10.7 24 24 24s24-10.7 24-24l0-144zM400 40c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 112c0 13.3 10.7 24 24 24s24-10.7 24-24l0-112zM640 72c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 48c0 13.3 10.7 24 24 24s24-10.7 24-24l0-48zM245.6 40.9c-11.9-26.2-41.6-39.1-68.9-30-62.3 20.8-116.2 83.7-102.6 160.9 30.6 173.7 156.5 299.6 330.2 330.2 77.2 13.6 140.1-40.4 160.9-102.6 9.1-27.3-3.9-57-30-68.9l-87.3-39.7c-23.4-10.6-51-4-67.1 16l-21.2 26.6c-48.9-27.3-88.9-68.8-114.4-118.8l24.2-19.3c20.1-16.1 26.7-43.7 16-67.1L245.6 40.9zM191.9 56.4c4-1.3 8.3 .6 10 4.4L241.6 148c1.5 3.4 .6 7.4-2.3 9.7l-38.9 31.1c-8.4 6.8-11.3 18.3-7 28.2 31.9 73.9 89.9 133.8 162.4 168.2 10.1 4.8 22.1 2 29-6.7l33.5-41.9c2.3-2.9 6.3-3.9 9.7-2.3l87.3 39.7c3.8 1.7 5.7 6 4.4 10-15.1 45.3-58.6 79.1-107 70.5-153.8-27.1-264.1-137.4-291.2-291.3-8.5-48.4 25.3-91.9 70.5-107z"]],
    "hippo": [640, 512, [129435], "f6ed", ["M64 329.1l3.9-8.7c8-18 12.1-37.5 12.1-57.2 0-83.5 67.7-151.2 151.2-151.2l60 0c27.3 0 54.4 4.8 80 14.2-2.1 8.2-3.2 16.9-3.2 25.8l0 9.2c0 6.3-2 12.4-4.9 18-7.1 13.4-11.1 28.6-11.1 44.8 0 41.8 26.7 77.4 64 90.5l0 13.5c0 13.3 10.7 24 24 24l16 0c0 10.7 0 21.3 0 32l-24 0c-8.7 0-16.9-2.3-24-6.4l0 46.4c0 4.4-3.6 8-8 8l-48 0c-4.4 0-8-3.6-8-8l0-48c0-7.6-3.6-14.8-9.8-19.3s-14.1-5.8-21.4-3.6l-11.3 3.6c-29.6 9.3-61.4 9.3-91 0l-11.3-3.6c-7.3-2.3-15.2-1-21.4 3.6S168 368.4 168 376l0 48c0 4.4-3.6 8-8 8l-40 0c-4.4 0-8-3.6-8-8l0-48c0-13.3-10.7-24-24-24s-24 10.7-24 24c0 9.1 0-6.5 0-46.9zM400 224c0-8.2 2-15.7 5.5-22.4 5.4-10.1 10.5-24 10.5-40.4l0-9.2c0-30.9 25.1-56 56-56l32 0c30.9 0 56 25.1 56 56 0 14 6 27.2 16.2 36.4 9.8 8.9 15.8 21.5 15.8 35.6 0 26.5-21.5 48-48 48l-96 0c-26.5 0-48-21.5-48-48zm32 0a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm16-80a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm64 0a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm16 80a24 24 0 1 0 48 0 24 24 0 1 0 -48 0z", "M391 39c9.4-9.4 24.6-9.4 33.9 0l14.2 14.2C449.5 49.9 460.5 48 472 48l32 0c15.8 0 30.8 3.5 44.2 9.8L559 47c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-7 7c13.8 17.7 22 39.9 22 64 0 .3 .1 .6 .3 .7 19.4 17.6 31.7 43 31.7 71.3 0 28.4-12.4 54-32 71.6l0 .4 0 32c0 13.3-10.7 24-24 24l-16 0c-13.3 0-24-10.7-24-24l0-8-64 0 0 8c0 13.3-10.7 24-24 24l-16 0c-13.3 0-24-10.7-24-24l0-13.5c-37.3-13.2-64-48.7-64-90.5 0-16.2 4-31.4 11.1-44.8 2.9-5.6 4.9-11.7 4.9-18l0-9.2c0-8.9 1.1-17.5 3.2-25.8-25.6-9.4-52.7-14.2-80-14.2l-60 0c-83.5 0-151.2 67.7-151.2 151.2 0 19.7-4.1 39.2-12.1 57.2L45.9 369.7c-5.4 12.1-19.6 17.6-31.7 12.2S-3.3 362.4 2.1 350.3L24 300.9c5.3-11.9 8-24.7 8-37.7 0-110 89.2-199.2 199.2-199.2l60 0c35.1 0 69.9 6.6 102.6 19.5 1.2-1.4 2.4-2.7 3.7-4L391 73c-9.4-9.4-9.4-24.6 0-33.9zm81 57c-30.9 0-56 25.1-56 56l0 9.2c0 16.4-5.1 30.3-10.5 40.4-3.5 6.6-5.5 14.2-5.5 22.4 0 26.5 21.5 48 48 48l96 0c26.5 0 48-21.5 48-48 0-14.1-6-26.8-15.8-35.6-10.2-9.2-16.2-22.4-16.2-36.4 0-30.9-25.1-56-56-56l-32 0zM408 377.6c7.1 4.1 15.3 6.4 24 6.4l24 0 0 40c0 30.9-25.1 56-56 56l-48 0c-30.9 0-56-25.1-56-56l0-16.4c-26.4 5.4-53.6 5.4-80 0l0 16.4c0 30.9-25.1 56-56 56l-40 0c-30.9 0-56-25.1-56-56l0-48c0-13.3 10.7-24 24-24s24 10.7 24 24l0 48c0 4.4 3.6 8 8 8l40 0c4.4 0 8-3.6 8-8l0-48c0-7.6 3.6-14.8 9.8-19.3s14.1-5.8 21.4-3.6l11.3 3.6c29.6 9.3 61.4 9.3 91 0l11.3-3.6c7.3-2.3 15.2-1 21.4 3.6S344 368.4 344 376l0 48c0 4.4 3.6 8 8 8l48 0c4.4 0 8-3.6 8-8l0-46.4zM464 128a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm48 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm-56 56a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm72 24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"]],
    "sword-laser-alt": [640, 512, [], "e03c", ["M277.9 272L331 272 579.6-3.5 277.9 272z", "M331 272L277.9 272 579.6-3.5 331 272zm59.1 6.2L618.7 24.8C635.7 6 635-23 617-40.9 599-59 569.9-59.6 551.1-42.4l-344.4 314.4-1.4 0c-8.5 0-16.6 3.4-22.6 9.4L33.9 430.1c-18.7 18.7-18.7 49.1 0 67.9l44.1 44.1c18.7 18.7 49.1 18.7 67.9 0L368 320 369 319c5.1-5.1 11.6-11.6 19.6-19.6 6.2-6.2 5.9-15.2 1.4-21.1zM67.9 464L137 394.9 181.1 439 112 508.1 67.9 464zM300.1 320l-85.1 85.1-44.1-44.1 41-41 88.2 0z"]],
    "flower": [448, 512, [127804, 10047], "f7ff", ["M48 168c0 21.8 7.8 41.6 20.9 56.9 15.2 17.9 15.2 44.2 0 62.2-13.1 15.4-20.9 35.2-20.9 56.9 0 48.6 39.4 88 88 88 21.8 0 41.6-7.8 56.9-20.9 17.9-15.2 44.2-15.2 62.2 0 15.4 13.1 35.2 20.9 56.9 20.9 48.6 0 88-39.4 88-88 0-21.8-7.8-41.6-20.9-56.9-15.2-17.9-15.2-44.2 0-62.2 13.1-15.4 20.9-35.2 20.9-56.9 0-48.6-39.4-88-88-88-21.8 0-41.6 7.8-56.9 20.9-17.9 15.2-44.2 15.2-62.2 0-15.4-13.1-35.2-20.9-56.9-20.9-48.6 0-88 39.4-88 88zm256 88a80 80 0 1 1 -160 0 80 80 0 1 1 160 0z", "M448 168c0 33.6-12.2 64.3-32.3 88 20.1 23.7 32.3 54.4 32.3 88 0 75.1-60.9 136-136 136-33.6 0-64.3-12.2-88-32.3-23.7 20.1-54.4 32.3-88 32.3-75.1 0-136-60.9-136-136 0-33.6 12.2-64.3 32.3-88-20.1-23.7-32.3-54.4-32.3-88 0-75.1 60.9-136 136-136 33.6 0 64.3 12.2 88 32.3 23.7-20.1 54.4-32.3 88-32.3 75.1 0 136 60.9 136 136zM192.9 100.9c-15.4-13.1-35.2-20.9-56.9-20.9-48.6 0-88 39.4-88 88 0 21.8 7.8 41.6 20.9 56.9 15.2 17.9 15.2 44.2 0 62.2-13.1 15.4-20.9 35.2-20.9 56.9 0 48.6 39.4 88 88 88 21.8 0 41.6-7.8 56.9-20.9 17.9-15.2 44.2-15.2 62.2 0 15.4 13.1 35.2 20.9 56.9 20.9 48.6 0 88-39.4 88-88 0-21.8-7.8-41.6-20.9-56.9-15.2-17.9-15.2-44.2 0-62.2 13.1-15.4 20.9-35.2 20.9-56.9 0-48.6-39.4-88-88-88-21.8 0-41.6 7.8-56.9 20.9-17.9 15.2-44.2 15.2-62.2 0zM256 256a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm-112 0a80 80 0 1 1 160 0 80 80 0 1 1 -160 0z"]],
    "bowl-food": [512, 512, [], "e4c6", ["M49.8 304c6.9 38.7 32.9 70.9 68.1 86.3 12.9 5.7 22.7 16.7 26.8 30.3 2 6.6 8.2 11.4 15.3 11.4l192 0c7.2 0 13.4-4.8 15.3-11.4 4-13.5 13.8-24.6 26.8-30.3 35.2-15.4 61.2-47.6 68.1-86.3L49.8 304z", "M0 176c0 11.7 3.1 22.6 8.6 32l494.9 0c5.4-9.4 8.6-20.3 8.6-32 0-35.3-28.7-64-64-64-.5 0-1.1 0-1.6 0-7.4-36.5-39.7-64-78.4-64-15 0-29 4.1-40.9 11.2-13.3-25.7-40.1-43.2-71.1-43.2s-57.8 17.6-71.1 43.2c-12-7.1-26-11.2-40.9-11.2-38.7 0-71 27.5-78.4 64-.5 0-1.1 0-1.6 0-35.3 0-64 28.7-64 64zM144.7 420.6c-4-13.5-13.8-24.6-26.8-30.3-35.2-15.4-61.2-47.6-68.1-86.3l412.4 0c-6.9 38.7-32.9 70.9-68.1 86.3-12.9 5.7-22.7 16.7-26.8 30.3-2 6.6-8.2 11.4-15.3 11.4l-192 0c-7.2 0-13.4-4.8-15.3-11.4zM27.4 256C12.3 256 0 268.3 0 283.4 0 350.9 40.6 408.8 98.6 434.3 106.5 460.7 131 480 160 480l192 0c29 0 53.5-19.3 61.4-45.7 58.1-25.4 98.6-83.4 98.6-150.8 0-15.1-12.3-27.4-27.4-27.4L27.4 256z"]],
    "globe-pointer": [576, 512, [], "e60e", ["M96.6 271.9l133.3-39.2c3.7-1.1 7.3-1.8 10.9-2.3 3.1-50.9 15.3-97.4 32.1-131.5 21.5-43.7 41.4-51 47.2-51s25.7 7.3 47.2 51c17 34.5 29.2 81.6 32.1 133l-134.5 0c23.2 6 41.7 24.7 47.4 48l87.1 0c-3 51.5-15.2 98.6-32.1 133-21.5 43.7-41.4 51-47.2 51-5.2 0-22-6-41.1-39.6l-14.3 48.6c-.5-.1-1-.3-1.6-.4l46.8-159c14.3-48.6-30.9-93.8-79.5-79.5L96.7 273.5c0-.5-.1-1.1-.1-1.6zM113.4 232c8.6-74.6 56.7-137.3 122.8-166.4-24 42.8-40.3 102.4-43.6 166.4l-79.2 0zM403.8 65.6C470 94.7 518.1 157.4 526.6 232l-79.2 0c-3.3-64-19.6-123.6-43.6-166.4zm0 380.8c24-42.8 40.3-102.4 43.6-166.4l79.2 0c-8.6 74.6-56.7 137.3-122.8 166.4z", "M367.2 413c-21.5 43.7-41.4 51-47.2 51-5.2 0-22-6-41.1-39.6l-23.3 79.4c20.6 5.3 42.2 8.2 64.5 8.2 141.4 0 256-114.6 256-256S461.4 0 320 0 64 114.6 64 256c0 8.5 .4 16.9 1.2 25.1l164.6-48.4c3.7-1.1 7.3-1.8 10.9-2.3 3.1-50.9 15.3-97.4 32.1-131.5 21.5-43.7 41.4-51 47.2-51s25.7 7.3 47.2 51c17 34.5 29.2 81.6 32.1 133l-134.5 0c23.2 6 41.7 24.7 47.4 48l87.1 0c-3 51.5-15.2 98.6-32.1 133zm80.2-133l79.2 0c-8.6 74.6-56.7 137.3-122.8 166.4 24-42.8 40.3-102.4 43.6-166.4zm79.2-48l-79.2 0c-3.3-64-19.6-123.6-43.6-166.4 66.1 29.2 114.2 91.8 122.8 166.4zm-334 0l-79.2 0c8.6-74.6 56.7-137.3 122.8-166.4-24 42.8-40.3 102.4-43.6 166.4zM39 340.5c-13.9 4.1-15.6 23.2-2.6 29.7l57.3 28.7c1.3 .7 2.6 1.5 3.7 2.5l-88 88c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l88-88c1 1.1 1.9 2.3 2.5 3.7l28.7 57.3c6.5 13 25.6 11.3 29.7-2.6l60.2-204.8c3.6-12.2-7.7-23.4-19.9-19.9L39 340.5z"]],
    "eggplant": [512, 512, [], "e16c", ["M48 335.3c-.5-35.9 9.9-59.3 25.6-77.9 17.1-20.2 42.5-36.9 76.1-54.5 11-5.8 24.1-12.1 38-18.9 23.4-11.4 49-23.9 70.4-36.2 16-9.2 32.3-19.6 47.7-31.7 7 3.9 14.6 6.9 22.5 8.9 7.1 12.9 15.9 24.2 25.2 33.4s20.6 18.1 33.4 25.2c4.1 16 12.2 30.4 23.1 42.1-16.8 43.9-40.4 90.6-69.8 131.3-48.5 66.9-104.8 107-163.9 107-69.4-.1-127.4-58.8-128.5-128.7z", "M505 7c9.4 9.4 9.4 24.6 0 33.9l-9 9 0 142.1c0 8.8-7.2 16-16 16-26.5 0-48-21.5-48-48 0-5.8-4-10.7-9.4-12.7-13.3-4.8-25.4-13-35.1-22.8-9.7-9.8-17.9-21.9-22.8-35.2-2-5.4-6.9-9.4-12.6-9.4-26.5 0-48-21.5-48-48 0-8.8 7.2-16 16-16l141.9 0 9-9c9.4-9.4 24.6-9.4 33.9 0zM169.9 139.3c35.2-17.1 70.7-34.3 100.7-56.6 8.7 13.9 20.8 25.5 35.2 33.5-15.5 12.1-31.7 22.5-47.7 31.7-21.5 12.3-47 24.8-70.4 36.2l0 0c-13.9 6.8-27 13.2-38 18.9-33.6 17.6-59 34.3-76.1 54.5-15.7 18.5-26.2 42-25.6 77.9 1 70 59 128.7 128.5 128.7 59 .1 115.4-40.1 163.9-107 29.4-40.6 53.1-87.4 69.8-131.3 11.2 11.9 25.4 20.9 41.4 25.9-48.8 122.6-145.7 260.4-275.2 260.3-96.5-.1-175-80.8-176.4-176-1.7-113.5 83.3-154.7 169.9-196.7z"]],
    "folder-arrow-right": [512, 512, [], "e7d3", ["M48 96l0 288c0 8.8 7.2 16 16 16l384 0c8.8 0 16-7.2 16-16l0-240c0-8.8-7.2-16-16-16l-149.3 0c-15.1 0-29.9-4.3-42.7-12.3l-5.3-3.7-38.4-28.8c-2.1-1.6-4.5-2.6-7-3L202.7 80 64 80c-8.8 0-16 7.2-16 16zM160 264c0-13.3 10.7-24 24-24l86.1 0-23-23c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l64 64 1.7 1.8c7.7 9.4 7.1 23.3-1.7 32.1l-64 64-1.8 1.7c-9.4 7.7-23.3 7.1-32.1-1.7s-9.3-22.7-1.7-32.1l1.7-1.8 23-23-86.1 0c-13.3 0-24-10.7-24-24z", "M202.7 32c13.8 0 27.3 4.5 38.4 12.8l38.4 28.8c4.2 3.1 9 5.2 14.1 6l5.1 .4 149.3 0c35.3 0 64 28.7 64 64l0 240c0 35.3-28.7 64-64 64L64 448c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l138.7 0zM64 80c-8.8 0-16 7.2-16 16l0 288c0 8.8 7.2 16 16 16l384 0c8.8 0 16-7.2 16-16l0-240c0-8.8-7.2-16-16-16l-149.3 0c-15.1 0-29.9-4.3-42.7-12.3l-5.3-3.7-38.4-28.8c-2.1-1.6-4.5-2.6-7-3L202.7 80 64 80zM247 183c9.4-9.4 24.6-9.4 33.9 0l64 64 1.7 1.8c7.7 9.4 7.1 23.3-1.7 32.1l-64 64-1.8 1.7c-9.4 7.7-23.3 7.1-32.1-1.7s-9.3-22.7-1.7-32.1l1.7-1.8 23-23-86.1 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l86.1 0-23-23c-9.4-9.4-9.4-24.6 0-33.9z"]],
    "battery-slash": [640, 512, [], "f377", ["M209.8 112L528 112c17.7 0 32 14.3 32 32l0 224c0 17.7-14.3 32-32 32l-30.2 0-288-288z", "M73-24.9c-9.4-9.4-24.6-9.4-33.9 0S29.7-.3 39 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-56.8-56.8c36.4-7.5 63.8-39.7 63.8-78.4l0-48c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l0-48c0-44.2-35.8-80-80-80L161.8 64 73-24.9zM209.8 112L528 112c17.7 0 32 14.3 32 32l0 224c0 17.7-14.3 32-32 32l-30.2 0-288-288zM362.2 400L112 400c-17.7 0-32-14.3-32-32l0-224c0-7.4 2.5-14.1 6.6-19.5L52.6 90.4C39.8 104.6 32 123.4 32 144l0 224c0 44.2 35.8 80 80 80l298.2 0-48-48z"]],
    "film-slash": [576, 512, [], "e179", ["M224 80l0 78.2 128 128 0-206.2-128 0z", "M41-24.9c-9.4-9.4-24.6-9.4-33.9 0S-2.3-.3 7 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-62.1-62.1c3.3-7.7 5.1-16.2 5.1-25.1l0-320c0-35.3-28.7-64-64-64L128 32c-8.9 0-17.4 1.8-25.1 5.1l-62-62zM145.8 80l30.2 0 0 30.2-30.2-30.2zM224 158.2l0-78.2 128 0 0 206.2-128-128zm176 176l0-54.2 64 0 0 118.2-64-64zM362.2 432l-138.2 0 0-138.2-61.8-61.8-50.2 0 0-50.2-48-48 0 282.2c0 35.3 28.7 64 64 64l282.2 0-48-48zM176 280l0 56-64 0 0-56 64 0zm0 104l0 48-48 0c-8.8 0-16-7.2-16-16l0-32 64 0zM400 80l48 0c8.8 0 16 7.2 16 16l0 32-64 0 0-48zm64 96l0 56-64 0 0-56 64 0z"]],
    "square-virus": [448, 512, [], "e578", ["M48 96l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16zM80 256c0-13.3 10.7-24 24-24 22.9 0 34.4-27.7 18.2-43.9-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0c16.2 16.2 43.9 4.7 43.9-18.2 0-13.3 10.7-24 24-24s24 10.7 24 24c0 22.9 27.7 34.4 43.9 18.2 9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9c-16.2 16.2-4.7 43.9 18.2 43.9 13.3 0 24 10.7 24 24s-10.7 24-24 24c-22.9 0-34.4 27.7-18.2 43.9 9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0c-16.2-16.2-43.9-4.7-43.9 18.2 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-22.9-27.7-34.4-43.9-18.2-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9c16.2-16.2 4.7-43.9-18.2-43.9-13.3 0-24-10.7-24-24z", "M64 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm224 16c13.3 0 24 10.7 24 24 0 22.9 27.7 34.4 43.9 18.2 9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9c-16.2 16.2-4.7 43.9 18.2 43.9 13.3 0 24 10.7 24 24s-10.7 24-24 24c-22.9 0-34.4 27.7-18.2 43.9 9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0c-16.2-16.2-43.9-4.7-43.9 18.2 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-22.9-27.7-34.4-43.9-18.2-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9c16.2-16.2 4.7-43.9-18.2-43.9-13.3 0-24-10.7-24-24s10.7-24 24-24c22.9 0 34.4-27.7 18.2-43.9-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0c16.2 16.2 43.9 4.7 43.9-18.2 0-13.3 10.7-24 24-24zM192 248a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm88 40a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"]],
    "tricycle-adult": [640, 512, [], "e5c4", ["M48 336a64 64 0 1 0 128 0 64 64 0 1 0 -128 0zm448 16a48 48 0 1 0 96 0 48 48 0 1 0 -96 0z", "M288 88c0-13.3 10.7-24 24-24l48 0c7.8 0 15.1 3.8 19.6 10.2L511.5 261.6c10.1-3.6 21.1-5.6 32.5-5.6 53 0 96 43 96 96s-43 96-96 96-96-43-96-96c0-24.3 9-46.4 23.9-63.3l-19.2-27.3-64.9 64.9c-16.5 16.5-38.9 25.8-62.2 25.8l-102.6 0c-7.8 54.3-54.4 96-110.9 96-61.9 0-112-50.1-112-112 0-48.3 30.6-89.5 73.5-105.2-1.2-2.6-2.3-5.3-3.2-8L49.2 159.6C45 147 51.8 133.4 64.4 129.2s26.2 2.6 30.4 15.2l21.1 63.2c3.3 9.8 12.4 16.4 22.8 16.4l61.4 0c13.3 0 24 10.7 24 24 0 12-8.8 21.9-20.3 23.7 6.8 9.7 12.2 20.6 15.6 32.3l106.1 0c10.6 0 20.8-4.2 28.3-11.7l70.8-70.8-77-109.5-35.5 0c-13.3 0-24-10.7-24-24zM176 336a64 64 0 1 0 -128 0 64 64 0 1 0 128 0zm368 64a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"]],
    "circle-phone-flip": [512, 512, ["phone-circle-alt"], "e11c", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm80.7 72c-2.7-9.8 2.4-20.1 11.8-24l48.7-20.3c8.3-3.4 17.8-1.1 23.5 5.9L225 304.6c34.3-17.3 62-45.9 78.1-80.9l-13.6-11.1c-6.9-5.7-9.3-15.2-5.9-23.5l20.3-48.7c3.9-9.4 14.2-14.4 24-11.8l2.8 .8c32.3 8.8 59.9 40.1 51.8 78.2-18.5 87.5-87.4 156.3-174.9 174.9-38.1 8.1-69.4-19.5-78.2-51.8l-.8-2.8z", "M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm72-383.3c-9.8-2.7-20.1 2.4-24 11.8l-20.3 48.7c-3.4 8.3-1.1 17.8 5.9 23.5l13.6 11.1c-16.1 35-43.8 63.6-78.1 80.9l-12.3-15.1c-5.7-6.9-15.2-9.3-23.5-5.9l-48.7 20.3c-9.4 3.9-14.4 14.2-11.8 24l.8 2.8c8.8 32.3 40.1 59.9 78.2 51.8 87.5-18.5 156.3-87.4 174.9-174.9 8.1-38.1-19.5-69.4-51.8-78.2l-2.8-.8z"]],
    "cloud-sun-rain": [576, 512, [127782], "f743", ["M272 272c0 17.7 14.3 32 32 32l184 0c22.1 0 40-17.9 40-40 0-19.9-14.5-36.4-33.6-39.5-7.5-1.2-14-5.9-17.5-12.7s-3.6-14.8-.2-21.6c2.1-4.2 3.3-9 3.3-14.2 0-17.7-14.3-32-32-32-15.5 0-28.5 11.1-31.4 25.8-1.7 8.6-7.9 15.6-16.3 18.3s-17.5 .6-23.8-5.5c-4.3-4.1-10.1-6.6-16.5-6.6-13.3 0-24 10.7-24 24 0 3.1 .6 5.9 1.6 8.6 3.1 8.2 1.5 17.4-4.1 24.1s-14.5 9.7-23.1 8c-2-.4-4.2-.6-6.4-.6-17.7 0-32 14.3-32 32z", "M293.6-14.8c4.9 2 8.5 6.4 9.5 11.6L320 80 334 82.8c-24.8 5.5-46.6 18.6-63 36.7-16.9-14.7-38.9-23.5-63-23.5-53 0-96 43-96 96 0 42 26.9 77.6 64.4 90.7 2.2 26.4 12.4 50.5 28.2 69.9l-67.3 44.6c-4.4 2.9-10 3.5-14.9 1.4s-8.5-6.4-9.5-11.6L96 304 12.8 287.2c-5.2-1.1-9.5-4.6-11.6-9.5s-1.5-10.5 1.4-14.9L49.6 192 2.7 121.3c-2.9-4.4-3.5-10-1.4-14.9s6.4-8.5 11.6-9.5L96 80 112.8-3.2c1.1-5.2 4.6-9.5 9.5-11.6s10.5-1.5 14.9 1.4L208 33.6 278.7-13.3c4.4-2.9 10-3.5 14.9-1.4zM243.2 159.3c-28.7 15.5-50.8 41.7-61 73.1-13.4-8.5-22.2-23.5-22.2-40.5 0-26.5 21.5-48 48-48 13.9 0 26.4 5.9 35.2 15.3zm138.5-28c14.4-21.3 38.7-35.3 66.4-35.3 44.2 0 80 35.8 80 80 0 3.2-.2 6.3-.5 9.3 28.8 14.5 48.5 44.2 48.5 78.7 0 48.6-39.4 88-88 88l-184 0c-44.2 0-80-35.8-80-80 0-38.8 27.6-71.2 64.3-78.5 3.3-36.7 34.1-65.5 71.7-65.5 7.5 0 14.8 1.2 21.6 3.3zM448 144c-15.5 0-28.5 11.1-31.4 25.8-1.7 8.6-7.9 15.6-16.3 18.3s-17.5 .6-23.8-5.5c-4.3-4.1-10.1-6.6-16.5-6.6-13.3 0-24 10.7-24 24 0 3.1 .6 5.9 1.6 8.6 3.1 8.2 1.5 17.4-4.1 24.1s-14.5 9.7-23.1 8c-2-.4-4.2-.6-6.4-.6-17.7 0-32 14.3-32 32s14.3 32 32 32l184 0c22.1 0 40-17.9 40-40 0-19.9-14.5-36.4-33.6-39.5-7.5-1.2-14-5.9-17.5-12.7s-3.6-14.8-.2-21.6c2.1-4.2 3.3-9 3.3-14.2 0-17.7-14.3-32-32-32zM285 401.1c12.6 4.2 19.4 17.8 15.2 30.4l-21.4 64.1c-4.2 12.6-17.8 19.4-30.4 15.2S229 493 233.2 480.4l21.4-64.1c4.2-12.6 17.8-19.4 30.4-15.2zm120 0c12.6 4.2 19.4 17.8 15.2 30.4l-21.4 64.1c-4.2 12.6-17.8 19.4-30.4 15.2S349 493 353.2 480.4l21.4-64.1c4.2-12.6 17.8-19.4 30.4-15.2zm120 0c12.6 4.2 19.4 17.8 15.2 30.4l-21.4 64.1c-4.2 12.6-17.8 19.4-30.4 15.2S469 493 473.2 480.4l21.4-64.1c4.2-12.6 17.8-19.4 30.4-15.2z"]],
    "h4": [512, 512, [], "f86a", ["", "M48 88c0-13.3-10.7-24-24-24S0 74.7 0 88L0 424c0 13.3 10.7 24 24 24s24-10.7 24-24l0-144 128 0 0 144c0 13.3 10.7 24 24 24s24-10.7 24-24l0-336c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 144-128 0 0-144zm288 0c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 120c0 44.2 35.8 80 80 80l96 0 0 136c0 13.3 10.7 24 24 24s24-10.7 24-24l0-336c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 152-96 0c-17.7 0-32-14.3-32-32l0-120z"]],
    "circle-caret-right": [512, 512, ["caret-circle-right"], "f330", ["M464 256a208 208 0 1 1 -416 0 208 208 0 1 1 416 0zM192 152l0 208c0 9.5 5.7 18.2 14.4 22s18.9 2.1 25.9-4.4l112-104c4.9-4.5 7.7-10.9 7.7-17.6s-2.8-13-7.7-17.6l-112-104c-7-6.5-17.2-8.2-25.9-4.4S192 142.5 192 152z", "M464 256a208 208 0 1 1 -416 0 208 208 0 1 1 416 0zM0 256a256 256 0 1 0 512 0 256 256 0 1 0 -512 0zm352 0c0-6.7-2.8-13-7.7-17.6l-112-104c-7-6.5-17.2-8.2-25.9-4.4S192 142.5 192 152l0 208c0 9.5 5.7 18.2 14.4 22s18.9 2.1 25.9-4.4l112-104c4.9-4.5 7.7-10.9 7.7-17.6z"]],
    "keyboard-brightness-low": [512, 512, [], "e1c1", ["", "M256 192a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM96 256a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm352-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm32 192a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM64 384a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm88-16c-13.3 0-24 10.7-24 24s10.7 24 24 24l208 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-208 0z"]],
    "arrow-right-long": [576, 512, ["long-arrow-right"], "f178", ["", "M569 273c9.4-9.4 9.4-24.6 0-33.9L433 103c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l95 95-470.1 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l470.1 0-95 95c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0L569 273z"]],
    "font-case": [576, 512, [], "f866", ["", "M80 168l0 104 128 0 0-104c0-30.9-25.1-56-56-56l-16 0c-30.9 0-56 25.1-56 56zm0 152l0 104c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-256C32 110.6 78.6 64 136 64l16 0c57.4 0 104 46.6 104 104l0 256c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-104-128 0zm344-80c-30.9 0-56 25.1-56 56l0 48c0 30.9 25.1 56 56 56l16 0c30.9 0 56-25.1 56-56l0-48c0-30.9-25.1-56-56-56l-16 0zm73-31c3-9.8 12.1-17 23-17 13.3 0 24 10.7 24 24l0 118.5c0 24.9 4 49.7 11.9 73.4l2.9 8.6c4.2 12.6-2.6 26.2-15.2 30.4s-26.2-2.6-30.4-15.2l-2.9-8.6c-.2-.6-.4-1.2-.6-1.9-18.5 16.7-42.9 26.9-69.8 26.9l-16 0c-57.4 0-104-46.6-104-104l0-48c0-57.4 46.6-104 104-104l16 0c21.1 0 40.7 6.3 57 17z"]],
    "building-un": [512, 512, [], "e4d9", ["M80 64c0-8.8 7.2-16 16-16l256 0c8.8 0 16 7.2 16 16l0 272-64 0c-18.7 0-35.5 8-47.2 20.8-4.9-3-10.7-4.8-16.8-4.8l-32 0c-17.7 0-32 14.3-32 32l0 80-80 0c-8.8 0-16-7.2-16-16L80 64zm48 48l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm0 128l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zM256 112l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm0 128l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16z", "M352 48L96 48c-8.8 0-16 7.2-16 16l0 384c0 8.8 7.2 16 16 16l80 0 0-80c0-17.7 14.3-32 32-32l32 0c6.2 0 11.9 1.7 16.8 4.8-10.4 11.4-16.8 26.6-16.8 43.2l0 112-144 0c-35.3 0-64-28.7-64-64L32 64C32 28.7 60.7 0 96 0L352 0c35.3 0 64 28.7 64 64l0 272-48 0 0-272c0-8.8-7.2-16-16-16zM144 96l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zm112 16c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM144 224l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zm112 16c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM427.4 380.5c9-2.1 18.3 2.2 22.5 10.5l26.1 52.2 0-43.3c0-11 9-20 20-20s20 9 20 20l0 128c0 9.3-6.4 17.3-15.4 19.5s-18.3-2.2-22.5-10.5L452 484.7 452 528c0 11-9 20-20 20s-20-9-20-20l0-128c0-9.3 6.4-17.3 15.4-19.5zM324 400l0 96c0 6.6 5.4 12 12 12s12-5.4 12-12l0-96c0-11 9-20 20-20s20 9 20 20l0 96c0 28.7-23.3 52-52 52s-52-23.3-52-52l0-96c0-11 9-20 20-20s20 9 20 20z"]],
    "toilet-paper-xmark": [512, 512, [], "e5b3", ["M48 224c0-43.3 9.2-81.3 23-107.7 14.4-27.5 30.1-36.3 41-36.3l212.7 0c-3 4.5-5.7 9.3-8.2 14.1-18.1 34.5-28.5 80.5-28.5 129.9s10.5 95.4 28.5 129.9c2.5 4.8 5.3 9.5 8.2 14.1L112 368c-10.9 0-26.6-8.9-41-36.3-13.8-26.3-23-64.3-23-107.7zm60.1-67.9c-9.4 9.4-9.4 24.6 0 33.9l33.9 33.9-33.9 33.9c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l33.9-33.9 33.9 33.9c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-33.9-33.9 33.9-33.9c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-33.9 33.9-33.9-33.9c-9.4-9.4-24.6-9.4-33.9 0zM176 416l224 0c25.9 0 47.4-13.6 64-32.9l0 88.9c0 13.3-10.7 24-24 24l-240 0c-13.3 0-24-10.7-24-24l0-56zM336 224c0-43.3 9.2-81.3 23-107.7 14.4-27.5 30.1-36.3 41-36.3s26.6 8.9 41 36.3c13.8 26.3 23 64.3 23 107.7s-9.2 81.3-23 107.7c-14.4 27.5-30.1 36.3-41 36.3s-26.6-8.9-41-36.3c-13.8-26.3-23-64.3-23-107.7zm40 0c0 26.5 10.7 48 24 48s24-21.5 24-48-10.7-48-24-48-24 21.5-24 48z", "M48 224c0 43.3 9.2 81.3 23 107.7 14.4 27.5 30.1 36.3 41 36.3l212.7 0c-3-4.5-5.7-9.3-8.2-14.1-18.1-34.5-28.5-80.5-28.5-129.9s10.5-95.4 28.5-129.9c2.5-4.8 5.3-9.5 8.2-14.1L112 80c-10.9 0-26.6 8.9-41 36.3-13.8 26.3-23 64.3-23 107.7zM359 116.3c-13.8 26.3-23 64.3-23 107.7s9.2 81.3 23 107.7c14.4 27.5 30.1 36.3 41 36.3s26.6-8.9 41-36.3c13.8-26.3 23-64.3 23-107.7s-9.2-81.3-23-107.7C426.6 88.9 410.9 80 400 80s-26.6 8.9-41 36.3zM400 416l-224 0 0 56c0 13.3 10.7 24 24 24l240 0c13.3 0 24-10.7 24-24l0-88.9c-16.6 19.3-38.1 32.9-64 32.9zM128 472l0-56-16 0C74.3 416 46 387.3 28.5 353.9 10.5 319.4 0 273.5 0 224S10.5 128.6 28.5 94.1C46 60.7 74.3 32 112 32l288 0c37.7 0 66 28.7 83.5 62.1 18.1 34.5 28.5 80.5 28.5 129.9l0 248c0 39.8-32.2 72-72 72l-240 0c-39.8 0-72-32.2-72-72zM400 272c-13.3 0-24-21.5-24-48s10.7-48 24-48 24 21.5 24 48-10.7 48-24 48zM243.9 156.1c9.4 9.4 9.4 24.6 0 33.9l-33.9 33.9 33.9 33.9c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-33.9-33.9-33.9 33.9c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l33.9-33.9-33.9-33.9c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l33.9 33.9 33.9-33.9c9.4-9.4 24.6-9.4 33.9 0z"]],
    "temperature-low": [512, 512, [], "f76b", ["M96 368c0 53 43 96 96 96s96-43 96-96c0-25.2-9.7-48.1-25.6-65.3-4.1-4.4-6.4-10.3-6.4-16.3L256 112c0-35.3-28.7-64-64-64s-64 28.7-64 64l0 174.4c0 6.1-2.3 11.9-6.4 16.3-15.9 17.1-25.6 40-25.6 65.3zm48 0c0-17.8 9.7-33.3 24-41.6l0-38.4c0-13.3 10.7-24 24-24s24 10.7 24 24l0 38.4c14.3 8.3 24 23.8 24 41.6 0 26.5-21.5 48-48 48s-48-21.5-48-48z", "M128 112c0-35.3 28.7-64 64-64s64 28.7 64 64l0 174.4c0 6.1 2.3 11.9 6.4 16.3 15.9 17.1 25.6 40 25.6 65.3 0 53-43 96-96 96s-96-43-96-96c0-25.2 9.7-48.1 25.6-65.3 4.1-4.4 6.4-10.3 6.4-16.3L128 112zM192 0C130.1 0 80 50.1 80 112l0 165.5c-20 24.7-32 56.2-32 90.5 0 79.5 64.5 144 144 144s144-64.5 144-144c0-34.3-12-65.8-32-90.5L304 112C304 50.1 253.9 0 192 0zm0 416c26.5 0 48-21.5 48-48 0-17.8-9.7-33.3-24-41.6l0-38.4c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 38.4c-14.3 8.3-24 23.8-24 41.6 0 26.5 21.5 48 48 48zM400 80a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm112 0a80 80 0 1 0 -160 0 80 80 0 1 0 160 0z"]],
    "h2": [576, 512, [], "f314", ["", "M80 88c0-13.3-10.7-24-24-24S32 74.7 32 88l0 336c0 13.3 10.7 24 24 24s24-10.7 24-24l0-144 128 0 0 144c0 13.3 10.7 24 24 24s24-10.7 24-24l0-336c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 144-128 0 0-144zM360 64c-13.3 0-24 10.7-24 24s10.7 24 24 24l93.3 0c28 0 50.7 22.7 50.7 50.7 0 18.9-10.5 36.2-27.3 45l-82.5 43.1c-45.6 23.8-74.2 71-74.2 122.5l0 50.8c0 13.3 10.7 24 24 24l176 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-152 0 0-26.8c0-33.6 18.7-64.4 48.4-79.9l82.5-43c32.6-17 53-50.7 53-87.5 0-54.5-44.2-98.7-98.7-98.7L360 64z"]],
    "face-smile-halo": [512, 512, [], "e38f", ["M64 272c0-41.5 13.2-80 35.6-111.4-9.1-2-18-4.2-26.2-6.8 50.1 14.3 114.4 22.2 182.6 22.2s132.4-7.9 182.8-21.9c-8.4 2.3-17.2 4.5-26.4 6.5 22.4 31.4 35.6 69.9 35.6 111.4 0 106-86 192-192 192S64 378 64 272zm44-16l0 8c0 11 9 20 20 20s20-9 20-20l0-8c0-15.5 12.5-28 28-28s28 12.5 28 28l0 8c0 11 9 20 20 20s20-9 20-20l0-8c0-37.6-30.4-68-68-68s-68 30.4-68 68zm34.7 112.6c22.1 23 60 47.4 113.3 47.4s91.2-24.4 113.3-47.4c9.2-9.6 8.9-24.8-.7-33.9s-24.8-8.9-33.9 .7C319.7 351 293.6 368 256 368s-63.7-17-78.7-32.6c-9.2-9.6-24.4-9.9-33.9-.7s-9.9 24.4-.7 33.9zM268 256l0 8c0 11 9 20 20 20s20-9 20-20l0-8c0-15.5 12.5-28 28-28s28 12.5 28 28l0 8c0 11 9 20 20 20s20-9 20-20l0-8c0-37.6-30.4-68-68-68s-68 30.4-68 68z", "M512 48c0-44.2-114.6-80-256-80S0 3.8 0 48 114.6 128 256 128 512 92.2 512 48zm-64 0c0 17.7-86 32-192 32S64 65.7 64 48 150 16 256 16 448 30.3 448 48zm3.3 102.4c-12.1 3.8-25.2 7.2-39 10.2 22.4 31.4 35.6 69.9 35.6 111.4 0 106-86 192-192 192S64 378 64 272c0-41.5 13.2-80 35.6-111.4-13.8-3-26.8-6.4-39-10.2-3.3-1-6.5-2.1-9.7-3.2-22.2 36.4-35 79.1-35 124.8 0 132.5 107.5 240 240 240S496 404.5 496 272c0-45.7-12.8-88.4-35-124.8-3.2 1.1-6.4 2.2-9.7 3.2zm-308 184.3c-9.6 9.2-9.9 24.4-.7 33.9 22.1 23 60 47.4 113.3 47.4s91.2-24.4 113.3-47.4c9.2-9.6 8.9-24.8-.7-33.9s-24.8-8.9-33.9 .7C319.7 351 293.6 368 256 368s-63.7-17-78.7-32.6c-9.2-9.6-24.4-9.9-33.9-.7zM148 256c0-15.5 12.5-28 28-28s28 12.5 28 28l0 8c0 11 9 20 20 20s20-9 20-20l0-8c0-37.6-30.4-68-68-68s-68 30.4-68 68l0 8c0 11 9 20 20 20s20-9 20-20l0-8zm188-28c15.5 0 28 12.5 28 28l0 8c0 11 9 20 20 20s20-9 20-20l0-8c0-37.6-30.4-68-68-68s-68 30.4-68 68l0 8c0 11 9 20 20 20s20-9 20-20l0-8c0-15.5 12.5-28 28-28z"]],
    "rocket-vertical": [448, 512, [], "e7bd", ["M70 366.2l18.9 69.3 44.9-44.9c3.3-3.3 6.8-6.4 10.3-9.3-11.7-20.8-21.4-40.8-29.2-60l-45 45zm74.8-233c-17.1 51.5-15.3 124.4 41.8 225.5 24.6-7.6 51-7.6 75.5 0 57.1-101.2 58.9-174 41.8-225.5-15.8-47.6-49-81.2-79.6-103.9-30.6 22.7-63.8 56.3-79.6 103.9zM264.4 160a40 40 0 1 1 -80 0 40 40 0 1 1 80 0zm40.2 221.3c3.6 2.9 7 6 10.3 9.3l44.9 44.9 18.9-69.3-45-45c-7.9 19.2-17.5 39.2-29.2 60z", "M211.1-20c8.1-5.4 18.6-5.4 26.6 0 37.6 25.1 88.9 68.8 111.9 138.2 14.1 42.7 16.9 93.2 1.4 152.4l61.8 61.8c12.2 12.2 16.9 30 12.4 46.6l-26.2 95.9c-6.5 23.7-36.1 31.6-53.5 14.2l-64.4-64.4c-31.2-31.2-81.9-31.2-113.1 0L103.4 489c-17.4 17.4-47 9.5-53.5-14.2L23.7 378.9c-4.5-16.6 .2-34.4 12.4-46.6l61.8-61.8C82.3 211.4 85.1 160.9 99.2 118.2 122.2 48.8 173.4 5.1 211.1-20zm93.5 401.3c3.6 2.9 7 6 10.3 9.3l44.9 44.9 18.9-69.3-45-45c-7.9 19.2-17.5 39.2-29.2 60zM304 133.3c-15.8-47.6-49-81.2-79.6-103.9-30.6 22.7-63.8 56.3-79.6 103.9-17.1 51.5-15.3 124.4 41.8 225.5 24.6-7.6 51-7.6 75.5 0 57.1-101.2 58.9-174 41.8-225.5zm-189 188l-45 45 18.9 69.3 44.9-44.9c3.3-3.3 6.8-6.4 10.3-9.3-11.7-20.8-21.4-40.8-29.2-60zM224.4 120a40 40 0 1 1 0 80 40 40 0 1 1 0-80z"]],
    "door-open": [448, 512, [], "f52b", ["M80 64l0 400 192 0 0-400c0-8.8-7.2-16-16-16L96 48c-8.8 0-16 7.2-16 16zM240 256a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M96 48l160 0c8.8 0 16 7.2 16 16l0 400-192 0 0-400c0-8.8 7.2-16 16-16zM80 512l216 0c13.3 0 24-10.7 24-24l0-424c0-5.5-.7-10.9-2-16l34 0c8.8 0 16 7.2 16 16l0 424c0 13.3 10.7 24 24 24l32 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-8 0 0-400c0-35.3-28.7-64-64-64l-88 0 0 .5c-2.6-.3-5.3-.5-8-.5L96 0C60.7 0 32 28.7 32 64l0 400-8 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l56 0zm96-256a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z"]],
    "align-left": [448, 512, [], "f036", ["", "M24 40C10.7 40 0 50.7 0 64S10.7 88 24 88l240 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L24 40zm0 128c-13.3 0-24 10.7-24 24s10.7 24 24 24l400 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L24 168zM0 320c0 13.3 10.7 24 24 24l240 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L24 296c-13.3 0-24 10.7-24 24zM24 424c-13.3 0-24 10.7-24 24s10.7 24 24 24l400 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L24 424z"]],
    "pencil-slash": [576, 512, [], "e215", ["M269.9 204L332 141.9 402.1 212 340 274.1 269.9 204z", "M41-24.9c-9.4-9.4-24.6-9.4-33.9 0S-2.3-.3 7 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9L373.9 308 522.8 159.1C536.4 145.6 544 127.2 544 108s-7.6-37.6-21.2-51.1L487.1 21.2C473.6 7.6 455.2 0 436 0s-37.6 7.6-51.1 21.2L236 170.1 41-24.9zM269.9 204L332 141.9 402.1 212 340 274.1 269.9 204zm36.2 171.8l-33.9-33.9-60.1 60.1-70.1-70.1 60.1-60.1-33.9-33.9-77.2 77.2c-10.7 10.7-18.5 24.1-22.6 38.7L32.9 481.6c-2.3 8.3 0 17.3 6.2 23.4s15.1 8.5 23.4 6.2l127.8-35.5c14.6-4.1 27.9-11.8 38.7-22.6l77.2-77.2zM418.8 55.1c4.6-4.6 10.7-7.1 17.2-7.1s12.6 2.6 17.2 7.1l35.7 35.7c4.6 4.6 7.1 10.7 7.1 17.2s-2.6 12.6-7.1 17.2L436 178.1 365.9 108 418.8 55.1zM90.5 453.5l22.8-82.2 59.4 59.4-82.2 22.8z"]],
    "camera": [512, 512, [62258, "camera-alt"], "f030", ["M48 160l0 256c0 8.8 7.2 16 16 16l384 0c8.8 0 16-7.2 16-16l0-256c0-8.8-7.2-16-16-16l-69.3 0c-8 0-15.5-4-20-10.7L325.5 83.6c-1.5-2.2-4-3.6-6.7-3.6L193.1 80c-2.7 0-5.2 1.3-6.7 3.6l-33.2 49.8c-4.5 6.7-11.9 10.7-20 10.7L64 144c-8.8 0-16 7.2-16 16zM368 272a112 112 0 1 1 -224 0 112 112 0 1 1 224 0z", "M193.1 32c-18.7 0-36.2 9.4-46.6 24.9L120.5 96 64 96C28.7 96 0 124.7 0 160L0 416c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64l-56.5 0-26-39.1C355.1 41.4 337.6 32 318.9 32L193.1 32zm-6.7 51.6c1.5-2.2 4-3.6 6.7-3.6l125.7 0c2.7 0 5.2 1.3 6.7 3.6l33.2 49.8c4.5 6.7 11.9 10.7 20 10.7l69.3 0c8.8 0 16 7.2 16 16l0 256c0 8.8-7.2 16-16 16L64 432c-8.8 0-16-7.2-16-16l0-256c0-8.8 7.2-16 16-16l69.3 0c8 0 15.5-4 20-10.7l33.2-49.8zM256 384a112 112 0 1 0 0-224 112 112 0 1 0 0 224zM192 272a64 64 0 1 1 128 0 64 64 0 1 1 -128 0z"]],
    "hat-winter": [512, 512, [], "f7a8", ["M91.3 368l329.4 0c-3.8-18.7-8.5-37.3-14.4-55.2l-23.1 6.9c-21.5 6.4-44.6 4.4-64.6-5.6l-44.7-22.3c-11.3-5.6-24.5-5.6-35.8 0l-44.7 22.3c-20.1 10-43.2 12-64.6 5.6l-23.1-6.9c-5.9 17.9-10.6 36.5-14.4 55.2zm32.2-100l19.1 5.7c9.8 2.9 20.3 2 29.4-2.5l44.7-22.3c24.8-12.4 53.9-12.4 78.7 0L340 271.2c9.1 4.6 19.6 5.5 29.4 2.5l19.1-5.7c-30.3-63.3-73-100-132.5-100S153.8 204.7 123.5 268z", "M256 0c12.7 0 23 9.8 23.9 22.2 9.4-8.1 23.7-7.7 32.6 1.2s9.4 23.2 1.2 32.6C326.2 57 336 67.3 336 80s-9.8 23-22.2 23.9c6.5 7.5 7.5 18.1 3.2 26.6 88.6 32.9 134.1 137 152.7 237.7 23.9 2.8 42.4 23.1 42.4 47.7l0 48c0 26.5-21.5 48-48 48L48 512c-26.5 0-48-21.5-48-48l0-48c0-24.6 18.5-44.9 42.4-47.7 18.6-100.7 64.1-204.9 152.7-237.7-4.4-8.5-3.3-19.1 3.2-26.6-12.4-.9-22.2-11.3-22.2-23.9s9.8-23 22.2-23.9c-8.1-9.4-7.7-23.7 1.2-32.6s23.2-9.4 32.6-1.2C233 9.8 243.3 0 256 0zM91.3 368l329.4 0c-3.8-18.7-8.5-37.3-14.4-55.2l-23.1 6.9c-21.5 6.4-44.6 4.4-64.6-5.6l-44.7-22.3c-11.3-5.6-24.5-5.6-35.8 0l-44.7 22.3c-20.1 10-43.2 12-64.6 5.6l-23.1-6.9c-5.9 17.9-10.6 36.5-14.4 55.2zM256 168c-59.5 0-102.2 36.7-132.5 100l19.1 5.7c9.8 2.9 20.3 2 29.4-2.5l44.7-22.3c24.8-12.4 53.9-12.4 78.7 0L340 271.2c9.1 4.6 19.6 5.5 29.4 2.5l19.1-5.7c-30.3-63.3-73-100-132.5-100zM464 464l0-48-416 0 0 48 416 0z"]],
    "house-person-return": [640, 512, ["house-person-arrive", "house-return"], "e011", ["M96 145.1l95.6-81.3 89.1 79.2-.9 1-31.9 0c-39.8 0-72 32.2-72 72s32.2 72 72 72l24 0 0 8c0 4.4-3.6 8-8 8l-160 0c-4.4 0-8-3.6-8-8l0-150.9z", "M360 24a56 56 0 1 0 112 0 56 56 0 1 0 -112 0zm88 138.2l0 107.6c0 13.4-6.7 25.9-17.8 33.3L408 317.8 408 163c7-2 14.2-3 21.6-3 6.3 0 12.4 .7 18.4 2.2zm48 31.7l20.3 20.3c7.5 7.5 11.7 17.7 11.7 28.3l0 53.5c0 13.3 10.7 24 24 24s24-10.7 24-24l0-53.5c0-23.3-9.3-45.7-25.8-62.2L519 149c-23.7-23.7-55.8-37-89.4-37-35.8 0-70 15.2-93.9 41.8l-22.4 24.9c-7.6 8.4-18.4 13.2-29.7 13.2L248 192c-13.3 0-24 10.7-24 24s10.7 24 24 24l35.5 0c24.9 0 48.7-10.6 65.4-29.1l11.1-12.3 0 151.3-21.2 14.1c-21.1 14-35.1 36.5-38.4 61.6l-12.2 91.3c-1.8 13.1 7.5 25.2 20.6 27s25.2-7.5 27-20.6L348 431.9c1.5-11.4 7.9-21.6 17.5-28L456.8 343c24.5-16.3 39.2-43.8 39.2-73.2l0-75.8zM476.3 387.7l-41.9 28 2 7c4.1 14.4 11.8 27.5 22.4 38L535 537c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-76.3-76.3c-4.8-4.8-8.3-10.8-10.2-17.3l-6.2-21.8zM207.9 14.1c-8.9-7.9-22.4-8.1-31.5-.3l-160 136c-10.1 8.6-11.3 23.7-2.7 33.8s23.7 11.3 33.8 2.7l.5-.4 0 110.1c0 30.9 25.1 56 56 56l160 0c30.9 0 56-25.1 56-56l0-13c-11.8 3.3-24 5-36.5 5l-11.5 0 0 8c0 4.4-3.6 8-8 8l-160 0c-4.4 0-8-3.6-8-8l0-150.9 95.6-81.3 89.1 79.2 19.2-21.3c4.3-4.8 8.9-9.4 13.7-13.6l-105.8-94z"]],
    "knife": [512, 512, ["utensil-knife"], "f2e4", ["M258.1 288L454 92.1c19.4 33.6 14.7 77.4-14 106.2L321.1 317.1c-9.4 9.4-24.6 9.4-33.9 0L258.1 288z", "M439.1 39c9.4-9.4 24.6-9.4 33.9 0l.8 .8c53.1 53.1 53.1 139.2 0 192.3L355 351c-28.1 28.1-73.7 28.1-101.8 0l-29.1-29.1-183 183c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l432-432zM258.1 288l29.1 29.1c9.4 9.4 24.6 9.4 33.9 0L439.9 198.2c28.8-28.8 33.5-72.5 14-106.2L258.1 288z"]],
    "message-exclamation": [512, 512, ["comment-alt-exclamation"], "f4a5", ["M48 128l0 224c0 26.5 21.5 48 48 48l56 0c13.3 0 24 10.7 24 24l0 49.7 91.9-64.9c8.1-5.7 17.8-8.8 27.7-8.8L416 400c26.5 0 48-21.5 48-48l0-224c0-26.5-21.5-48-48-48L96 80c-26.5 0-48 21.5-48 48zM288 336a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM224.6 145.7c-1.3-18.2 13.1-33.7 31.4-33.7 18.2 0 32.7 15.5 31.4 33.7l-7.4 104c-.9 12.6-11.4 22.3-23.9 22.3-12.6 0-23-9.7-23.9-22.3l-7.4-104z", "M416 32c53 0 96 43 96 96l0 224c0 53-43 96-96 96l-120.4 0-129.8 91.6c-7.3 5.2-16.9 5.8-24.9 1.7S128 529 128 520l0-72-32 0c-53 0-96-43-96-96L0 128C0 75 43 32 96 32l320 0zM96 80c-26.5 0-48 21.5-48 48l0 224c0 26.5 21.5 48 48 48l56 0c13.3 0 24 10.7 24 24l0 49.7 91.9-64.9c8.1-5.7 17.8-8.8 27.7-8.8L416 400c26.5 0 48-21.5 48-48l0-224c0-26.5-21.5-48-48-48L96 80zM256 368a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm0-256c18.2 0 32.7 15.5 31.4 33.7l-7.4 104c-.9 12.6-11.4 22.3-23.9 22.3-12.6 0-23-9.7-23.9-22.3l-7.4-104C223.3 127.5 237.8 112 256 112z"]],
    "right-to-line": [512, 512, ["arrow-alt-to-right"], "f34c", ["M48 224l0 64 168 0c13.3 0 24 10.7 24 24l0 30.1 86.1-86.1-86.1-86.1 0 30.1c0 6.4-2.5 12.5-7 17s-10.6 7-17 7c-60 0-116 0-168 0z", "M488 64c-13.3 0-24 10.7-24 24l0 336c0 13.3 10.7 24 24 24s24-10.7 24-24l0-336c0-13.3-10.7-24-24-24zM377 273c4.5-4.5 7-10.6 7-17s-2.5-12.5-7-17L233 95c-6.9-6.9-17.2-8.9-26.2-5.2S192 102.3 192 112l0 64-64 0 0 0-80 0c-26.5 0-48 21.5-48 48l0 64c0 26.5 21.5 48 48 48l144 0 0 64c0 9.7 5.8 18.5 14.8 22.2s19.3 1.7 26.2-5.2L377 273zM128 288l-80 0 0-64 80 0 0 0 88 0c6.4 0 12.5-2.5 17-7s7-10.6 7-17l0-30.1 86.1 86.1-86.1 86.1 0-30.1c0-13.3-10.7-24-24-24l-88 0z"]],
    "mailbox": [576, 512, [128234], "f813", ["M251.3 112L416 112c61.9 0 112 50.1 112 112l0 192c0 8.8-7.2 16-16 16l-226 0c1.3-5.1 2-10.5 2-16l0-208c0-36.9-13.9-70.5-36.7-96zM336 232c0 13.3 10.7 24 24 24l24 0 0 40c0 13.3 10.7 24 24 24l48 0c13.3 0 24-10.7 24-24l0-64c0-13.3-10.7-24-24-24l-96 0c-13.3 0-24 10.7-24 24z", "M251.3 112c22.8 25.5 36.7 59.1 36.7 96l0 208c0 5.5-.7 10.9-2 16l226 0c8.8 0 16-7.2 16-16l0-192c0-61.9-50.1-112-112-112l-164.7 0zM144 112c-53 0-96 43-96 96l0 208c0 8.8 7.2 16 16 16l160 0c8.8 0 16-7.2 16-16l0-208c0-53-43-96-96-96zm0-48l272 0c88.4 0 160 71.6 160 160l0 192c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 208C0 128.5 64.5 64 144 64zM104 208l80 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zm232 24c0-13.3 10.7-24 24-24l96 0c13.3 0 24 10.7 24 24l0 64c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-40-24 0c-13.3 0-24-10.7-24-24z"]],
    "message-heart": [512, 512, [], "e5c9", ["M48 128l0 224c0 26.5 21.5 48 48 48l56 0c10.4 0 19.3 6.6 22.6 15.9 .9 2.5 1.4 5.2 1.4 8.1l0 49.7c32.7-23.1 63.3-44.7 91.9-64.9 8.1-5.7 17.8-8.8 27.7-8.8L416 400c26.5 0 48-21.5 48-48l0-224c0-26.5-21.5-48-48-48L96 80c-26.5 0-48 21.5-48 48zm96 90.7c0-32.4 26.3-58.7 58.7-58.7 18.5 0 35.9 8.7 46.9 23.5l6.4 8.5 6.4-8.5c11.1-14.8 28.5-23.5 46.9-23.5 32.4 0 58.7 26.3 58.7 58.7l0 5.3c0 49.1-65.8 98.1-96.5 118.3-9.5 6.2-21.5 6.2-30.9 0-30.7-20.2-96.5-69.3-96.5-118.3l0-5.3z", "M203.7 512.9l0 0 91.9-64.9 120.4 0c53 0 96-43 96-96l0-224c0-53-43-96-96-96L96 32C43 32 0 75 0 128L0 352c0 53 43 96 96 96l32 0 0 72c0 9 5 17.2 13 21.3s17.6 3.5 24.9-1.7l37.8-26.7zM295.6 400c-9.9 0-19.6 3.1-27.7 8.8-28.6 20.2-59.3 41.8-91.9 64.9l0-49.7c0-2.8-.5-5.6-1.4-8.1-3.3-9.3-12.2-15.9-22.6-15.9l-56 0c-26.5 0-48-21.5-48-48l0-224c0-26.5 21.5-48 48-48l320 0c26.5 0 48 21.5 48 48l0 224c0 26.5-21.5 48-48 48l-120.4 0zm-46-216.5c-11.1-14.8-28.5-23.5-46.9-23.5-32.4 0-58.7 26.3-58.7 58.7l0 5.3c0 49.1 65.8 98.1 96.5 118.3 9.5 6.2 21.5 6.2 30.9 0 30.7-20.2 96.5-69.3 96.5-118.3l0-5.3c0-32.4-26.3-58.7-58.7-58.7-18.5 0-35.9 8.7-46.9 23.5l-6.4 8.5-6.4-8.5z"]],
    "message-middle-top": [512, 512, ["comment-middle-top-alt"], "e1e2", ["M48 160l0 224c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-224c0-26.5-21.5-48-48-48l-68.8 0c-14.2 0-27.8-6.3-36.9-17.3L256 29.5 201.6 94.7C192.5 105.7 179 112 164.8 112L96 112c-26.5 0-48 21.5-48 48z", "M96 432c-26.5 0-48-21.5-48-48l0-224c0-26.5 21.5-48 48-48l68.8 0c14.2 0 27.8-6.3 36.9-17.3L256 29.5 310.4 94.7c9.1 10.9 22.6 17.3 36.9 17.3l68.8 0c26.5 0 48 21.5 48 48l0 224c0 26.5-21.5 48-48 48L96 432zM0 384c0 53 43 96 96 96l320 0c53 0 96-43 96-96l0-224c0-53-43-96-96-96l-68.8 0-72.8-87.4C269.9-28.8 263.1-32 256-32s-13.9 3.2-18.4 8.6L164.8 64 96 64C43 64 0 107 0 160L0 384z"]],
    "users-rays": [640, 512, [], "e593", ["M232 400c13.3 0 24-10.7 24-24l0-8c0-26.5 21.5-48 48-48l32 0c26.5 0 48 21.5 48 48l0 8c0 13.3 10.7 24 24 24l-176 0zM352 144a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M31-33C21.7-23.6 21.7-8.4 31 1L87 57c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9L65-33c-9.4-9.4-24.6-9.4-33.9 0zM609-33c-9.4-9.4-24.6-9.4-33.9 0L519 23c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0L609 1c9.4-9.4 9.4-24.6 0-33.9zM65 545l56-56c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0L31 511c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0zm544 0c9.4-9.4 9.4-24.6 0-33.9l-56-56c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l56 56c9.4 9.4 24.6 9.4 33.9 0zM320 112a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm0 112a80 80 0 1 0 0-160 80 80 0 1 0 0 160zM192 144c0-16.4 3.1-32 8.7-46.4-32.4 7-56.7 35.9-56.7 70.4 0 39.8 32.2 72 72 72 5.9 0 11.6-.7 17.1-2-25.3-23.4-41.1-56.8-41.1-94zm232 96c39.8 0 72-32.2 72-72 0-34.5-24.3-63.3-56.7-70.4 5.6 14.4 8.7 30 8.7 46.4 0 37.1-15.8 70.6-41.1 94 5.5 1.3 11.2 2 17.1 2zM202.5 272.2C152.1 275 112 316.8 112 368l0 8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-8c0-4.6 .6-9 1.8-13.1 4.9-31.8 19.5-60.4 40.7-82.7zm275.7 82.7c1.2 4.2 1.8 8.6 1.8 13.1l0 8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-8c0-51.2-40.1-93-90.5-95.8 21.2 22.3 35.8 50.9 40.7 82.7zM304 272c-53 0-96 43-96 96l0 8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-8c0-26.5 21.5-48 48-48l32 0c26.5 0 48 21.5 48 48l0 8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-8c0-53-43-96-96-96l-32 0z"]],
    "circles-overlap": [576, 512, [], "e600", ["M208 304c0 22.6 4.7 44 13.1 63.5 82.2-6.7 146.9-75.5 146.9-159.5 0-22.6-4.7-44-13.1-63.5-82.2 6.7-146.9 75.5-146.9 159.5z", "M168.5 363.1C163 344.4 160 324.5 160 304 160 203.4 231.4 119.5 326.2 100.2 297 68.1 254.8 48 208 48 119.6 48 48 119.6 48 208 48 282.7 99.2 345.5 168.5 363.1zm23.8 52.3C84.8 407.4 0 317.6 0 208 0 93.1 93.1 0 208 0 281.9 0 346.8 38.5 383.7 96.6 491.2 104.6 576 194.4 576 304 576 418.9 482.9 512 368 512 294.1 512 229.2 473.5 192.3 415.4zm57.4-3.6c29.3 32.1 71.4 52.2 118.2 52.2 88.4 0 160-71.6 160-160 0-74.7-51.2-137.5-120.5-155.1 5.5 18.7 8.5 38.6 8.5 59.1 0 100.6-71.4 184.5-166.2 203.8zM354.9 144.5c-82.2 6.7-146.9 75.5-146.9 159.5 0 22.6 4.7 44 13.1 63.5 82.2-6.7 146.9-75.5 146.9-159.5 0-22.6-4.7-44-13.1-63.5z"]],
    "rainbow": [640, 512, [127752], "f75b", ["M24 448c13.3 0 24-10.7 24-24l0-72C48 201.8 169.8 80 320 80S592 201.8 592 352l0 72c0 13.3 10.7 24 24 24l-112 0c13.3 0 24-10.7 24-24l0-72c0-114.9-93.1-208-208-208S112 237.1 112 352l0 72c0 13.3 10.7 24 24 24L24 448zm112 0c13.3 0 24-10.7 24-24l0-72c0-88.4 71.6-160 160-160s160 71.6 160 160l0 72c0 13.3 10.7 24 24 24l-112 0c13.3 0 24-10.7 24-24l0-72c0-53-43-96-96-96s-96 43-96 96l0 72c0 13.3 10.7 24 24 24l-112 0z", "M320 80C169.8 80 48 201.8 48 352l0 72c0 13.3-10.7 24-24 24S0 437.3 0 424l0-72C0 175.3 143.3 32 320 32S640 175.3 640 352l0 72c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-72C592 201.8 470.2 80 320 80zm0 112c-88.4 0-160 71.6-160 160l0 72c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-72c0-114.9 93.1-208 208-208s208 93.1 208 208l0 72c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-72c0-88.4-71.6-160-160-160zM272 352l0 72c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-72c0-53 43-96 96-96s96 43 96 96l0 72c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-72c0-26.5-21.5-48-48-48s-48 21.5-48 48z"]],
    "box-arrow-down-arrow-up": [448, 512, [], "e795", ["M48 176l0 240c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-240-352 0zm11-48l141 0 0-64-87.1 0c-5.2 0-10 2.5-13 6.7L59 128zM81.8 326.8c3.7-9 12.5-14.8 22.2-14.8l16 0 0-80c0-13.3 10.7-24 24-24s24 10.7 24 24l0 80 16 0c9.7 0 18.5 5.8 22.2 14.8s1.6 19.3-5.2 26.2l-40 40c-8.8 8.8-22.7 9.3-32.1 1.7L127 393 87 353c-6.9-6.9-8.9-17.2-5.2-26.2zm160-45.6c-3.7-9-1.6-19.3 5.2-26.2l40-40 1.8-1.7c9.4-7.7 23.3-7.1 32.1 1.7l40 40c6.9 6.9 8.9 17.2 5.2 26.2S353.7 296 344 296l-16 0 0 80c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-80-16 0c-9.7 0-18.5-5.8-22.2-14.8zM248 64l0 64 141 0-40.9-57.3c-3-4.2-7.9-6.7-13-6.7L248 64z", "M335.1 16c20.7 0 40.1 10 52.1 26.8l48.9 68.5c7.7 10.8 11.9 23.9 11.9 37.2l0 267.5-.3 6.5c-3.1 30.1-27 54.1-57.1 57.1l-6.5 .3-320 0-6.5-.3c-30.1-3.1-54.1-27-57.1-57.1L0 416 0 148.5c0-11.7 3.2-23.1 9.2-33l2.7-4.2 48.9-68.5c10.5-14.7 26.7-24.2 44.4-26.3l7.7-.5 222.1 0zM48 416c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-240-352 0 0 240zM288.8 213.4c9.4-7.7 23.3-7.1 32.1 1.7l40 40c6.9 6.9 8.9 17.2 5.2 26.2S353.7 296 344 296l-16 0 0 80c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-80-16 0c-9.7 0-18.5-5.8-22.2-14.8s-1.6-19.3 5.2-26.2l40-40 1.8-1.7zM144 208c13.3 0 24 10.7 24 24l0 80 16 0c9.7 0 18.5 5.8 22.2 14.8s1.6 19.3-5.2 26.2l-40 40c-8.8 8.8-22.7 9.3-32.1 1.7L127 393 87 353c-6.9-6.9-8.9-17.2-5.2-26.2S94.3 312 104 312l16 0 0-80c0-13.3 10.7-24 24-24zM112.9 64c-5.2 0-10 2.5-13 6.7l-40.9 57.3 141 0 0-64-87.1 0zM248 128l141 0-40.9-57.3c-3-4.2-7.9-6.7-13-6.7l-87.1 0 0 64z"]],
    "left-from-dotted-line": [512, 512, [], "e6c2", ["M57.9 256l86.1 86.1 0-30.1c0-13.3 10.7-24 24-24l168 0 0-64c-52 0-108 0-168 0-13.3 0-24-10.7-24-24l0-30.1-86.1 86.1z", "M7 273c-9.4-9.4-9.4-24.6 0-33.9L151 95c6.9-6.9 17.2-8.9 26.2-5.2S192 102.3 192 112l0 64 64 0 0 0 80 0c26.5 0 48 21.5 48 48l0 64c0 26.5-21.5 48-48 48l-144 0 0 64c0 9.7-5.8 18.5-14.8 22.2s-19.3 1.7-26.2-5.2L7 273zm249 15l80 0 0-64-80 0 0 0-88 0c-13.3 0-24-10.7-24-24l0-30.1-86.1 86.1 86.1 86.1 0-30.1c0-13.3 10.7-24 24-24l88 0zM512 96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm0 106.7a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM480 341.3a32 32 0 1 1 0-64 32 32 0 1 1 0 64zM512 416a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z"]],
    "sitemap": [512, 512, [], "f0e8", ["M48 400l0 32 32 0 0-32-32 0zM240 80l0 32 32 0 0-32-32 0zm0 320l0 32 32 0 0-32-32 0zm192 0l0 32 32 0 0-32-32 0z", "M240 80l32 0 0 32-32 0 0-32zM224 32c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32l8 0 0 64-120 0c-39.8 0-72 32.2-72 72l0 56-8 0c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-8 0 0-56c0-13.3 10.7-24 24-24l120 0 0 80-8 0c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-8 0 0-80 120 0c13.3 0 24 10.7 24 24l0 56-8 0c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-8 0 0-56c0-39.8-32.2-72-72-72l-120 0 0-64 8 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-64 0zM48 432l0-32 32 0 0 32-32 0zm192 0l0-32 32 0 0 32-32 0zm192 0l0-32 32 0 0 32-32 0z"]],
    "caravan-simple": [640, 512, ["caravan-alt"], "e000", ["M80 96l0 256c0 8.8 7.2 16 16 16l60.1 0c16.1-19.5 40.6-32 67.9-32s51.7 12.5 67.9 32l204.1 0 0-208c0-16.8-5.2-32.4-14.1-45.3-6.1-7.6-13.1-14.5-20.7-20.7-12.9-8.9-28.5-14.1-45.3-14.1L96 80c-8.8 0-16 7.2-16 16zm48 64c0-17.7 14.3-32 32-32l64 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-64zm192 0c0-17.7 14.3-32 32-32l64 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-64z", "M416 80c44.2 0 80 35.8 80 80l0 208-204.1 0c-16.1-19.5-40.6-32-67.9-32s-51.7 12.5-67.9 32L96 368c-8.8 0-16-7.2-16-16L80 96c0-8.8 7.2-16 16-16l320 0zM96 416l40.4 0c-.2 2.6-.4 5.3-.4 8 0 48.6 39.4 88 88 88s88-39.4 88-88c0-2.7-.1-5.4-.4-8L616 416c13.3 0 24-10.7 24-24s-10.7-24-24-24l-72 0 0-208c0-70.7-57.3-128-128-128L96 32C60.7 32 32 60.7 32 96l0 256c0 35.3 28.7 64 64 64zm64-288c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-64 0zm160 32l0 64c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-64 0c-17.7 0-32 14.3-32 32zM224 384a40 40 0 1 1 0 80 40 40 0 1 1 0-80z"]],
    "face-grin-stars": [512, 512, [129321, "grin-stars"], "f587", ["M14.2 171.6C41.3 94 104.8 33.4 184.2 10.2 191.1 15.8 197 23 201.4 31.8l10.3 20.9C226 49.6 240.8 48 256 48s30 1.6 44.3 4.7l10.3-20.9c4.4-8.9 10.3-16.1 17.2-21.6 79.4 23.2 142.9 83.8 170 161.4l-17.3 16.9 4.6 27c4.2 24.4-5.6 46.2-22 59.9-9.8 105.8-98.8 188.6-207.1 188.6S58.6 381.2 48.9 275.3c-16.4-13.7-26.1-35.4-22-59.9l4.6-27-17.3-16.9zm31.3-36.6l37.7 36.7-8.9 51.8c-2.2 13.1 11.5 23 23.2 16.9L144 216 190.5 240.5c11.7 6.2 25.5-3.8 23.2-16.9l-8.9-51.8 37.7-36.7c9.5-9.3 4.3-25.4-8.9-27.3l-52-7.6-23.3-47.2c-5.9-11.9-22.8-11.9-28.7 0l-23.3 47.2-52 7.6c-13.1 1.9-18.4 18-8.9 27.3zm74.7 185c19.8 55.9 73.1 95.9 135.8 95.9 62.7 0 116-40.1 135.8-96 4.1-11.6-7.8-21.4-19.6-17.8-34.8 10.6-74.3 16.6-116.3 16.6-41.9 0-81.4-6-116.1-16.5-11.8-3.6-23.7 6.1-19.6 17.8zm149.3-185l37.7 36.7-8.9 51.8c-2.2 13.1 11.5 23 23.2 16.9L368 216 414.5 240.5c11.7 6.2 25.5-3.8 23.2-16.9l-8.9-51.8 37.7-36.7c9.5-9.3 4.3-25.4-8.9-27.3l-52-7.6-23.3-47.2c-5.9-11.9-22.8-11.9-28.7 0l-23.3 47.2-52 7.6c-13.1 1.9-18.4 18-8.9 27.3z", "M0 256c0-29.6 5-57.9 14.2-84.4l17.3 16.9-4.6 27c-4.2 24.4 5.6 46.2 22 59.9 9.8 105.8 98.8 188.7 207.1 188.7s197.4-82.8 207.1-188.6c16.4-13.7 26.1-35.4 22-59.9l-4.6-27 17.3-16.9c9.2 26.4 14.2 54.8 14.2 84.4 0 141.4-114.6 256-256 256S0 397.4 0 256zM256 48c-15.2 0-30 1.6-44.3 4.7L201.4 31.8C197 23 191.1 15.8 184.2 10.2 207 3.6 231.1 0 256 0s49 3.6 71.8 10.2C320.9 15.8 315 23 310.6 31.8L300.3 52.7C286 49.6 271.2 48 256 48zM372.2 302.3c11.8-3.6 23.7 6.1 19.6 17.8-19.8 55.9-73.1 96-135.8 96-62.7 0-116-40-135.8-95.9-4.1-11.6 7.8-21.4 19.6-17.8 34.7 10.6 74.2 16.5 116.1 16.5 42 0 81.5-6 116.3-16.6zM353.7 53.1c5.9-11.9 22.8-11.9 28.7 0l23.3 47.2 52 7.6c13.1 1.9 18.4 18 8.9 27.3l-37.7 36.7 8.9 51.8c2.2 13.1-11.5 23-23.2 16.9L368 216 321.5 240.5c-11.7 6.2-25.5-3.8-23.2-16.9l8.9-51.8-37.7-36.7c-9.5-9.3-4.3-25.4 8.9-27.3l52-7.6 23.3-47.2zm-195.3 0l23.3 47.2 52 7.6c13.1 1.9 18.4 18 8.9 27.3l-37.7 36.7 8.9 51.8c2.2 13.1-11.5 23-23.2 16.9L144 216 97.5 240.5c-11.7 6.2-25.5-3.8-23.2-16.9l8.9-51.8-37.7-36.7c-9.5-9.3-4.3-25.4 8.9-27.3l52-7.6 23.3-47.2c5.9-11.9 22.8-11.9 28.7 0z"]],
    "message-sms": [512, 512, [], "e1e5", ["M48 128l0 224c0 26.5 21.5 48 48 48l56 0c10.4 0 19.3 6.6 22.6 15.9 .9 2.5 1.4 5.2 1.4 8.1l0 49.7c32.7-23.1 63.3-44.7 91.9-64.9 8.1-5.7 17.8-8.8 27.7-8.8L416 400c26.5 0 48-21.5 48-48l0-224c0-26.5-21.5-48-48-48L96 80c-26.5 0-48 21.5-48 48zm51.2 86.4c0-23 18.6-41.6 41.6-41.6l19.2 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-19.2 0c-5.3 0-9.6 4.3-9.6 9.6s4.3 9.6 9.6 9.6c23 0 41.6 18.6 41.6 41.6s-18.6 41.6-41.6 41.6l-25.6 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l25.6 0c5.3 0 9.6-4.3 9.6-9.6s-4.3-9.6-9.6-9.6c-23 0-41.6-18.6-41.6-41.6zm102.4-25.6c0-7.2 4.8-13.5 11.7-15.4s14.3 1 18 7.2l24.7 41.1 24.7-41.1c3.7-6.2 11.1-9.1 18-7.2s11.7 8.2 11.7 15.4l0 102.4c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-44.6-8.7 14.5c-2.9 4.8-8.1 7.8-13.7 7.8s-10.8-3-13.7-7.8l-8.7-14.5 0 44.6c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-102.4zm128 25.6c0-23 18.6-41.6 41.6-41.6l19.2 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-19.2 0c-5.3 0-9.6 4.3-9.6 9.6s4.3 9.6 9.6 9.6c23 0 41.6 18.6 41.6 41.6s-18.6 41.6-41.6 41.6l-25.6 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l25.6 0c5.3 0 9.6-4.3 9.6-9.6s-4.3-9.6-9.6-9.6c-23 0-41.6-18.6-41.6-41.6z", "M203.7 512.9l0 0 91.9-64.9 120.4 0c53 0 96-43 96-96l0-224c0-53-43-96-96-96L96 32C43 32 0 75 0 128L0 352c0 53 43 96 96 96l32 0 0 72c0 9 5 17.2 13 21.3s17.6 3.5 24.9-1.7l37.8-26.7zM295.6 400c-9.9 0-19.6 3.1-27.7 8.8-28.6 20.2-59.3 41.8-91.9 64.9l0-49.7c0-2.8-.5-5.6-1.4-8.1-3.3-9.3-12.2-15.9-22.6-15.9l-56 0c-26.5 0-48-21.5-48-48l0-224c0-26.5 21.5-48 48-48l320 0c26.5 0 48 21.5 48 48l0 224c0 26.5-21.5 48-48 48l-120.4 0zM140.8 172.8c-23 0-41.6 18.6-41.6 41.6S117.8 256 140.8 256c5.3 0 9.6 4.3 9.6 9.6s-4.3 9.6-9.6 9.6l-25.6 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l25.6 0c23 0 41.6-18.6 41.6-41.6S163.8 224 140.8 224c-5.3 0-9.6-4.3-9.6-9.6s4.3-9.6 9.6-9.6l19.2 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-19.2 0zm188.8 41.6c0 23 18.6 41.6 41.6 41.6 5.3 0 9.6 4.3 9.6 9.6s-4.3 9.6-9.6 9.6l-25.6 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l25.6 0c23 0 41.6-18.6 41.6-41.6S394.2 224 371.2 224c-5.3 0-9.6-4.3-9.6-9.6s4.3-9.6 9.6-9.6l19.2 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-19.2 0c-23 0-41.6 18.6-41.6 41.6zm-98.3-33.8c-3.7-6.2-11.1-9.1-18-7.2s-11.7 8.2-11.7 15.4l0 102.4c0 8.8 7.2 16 16 16s16-7.2 16-16l0-44.6 8.7 14.5c2.9 4.8 8.1 7.8 13.7 7.8s10.8-3 13.7-7.8l8.7-14.5 0 44.6c0 8.8 7.2 16 16 16s16-7.2 16-16l0-102.4c0-7.2-4.8-13.5-11.7-15.4s-14.3 1-18 7.2l-24.7 41.1-24.7-41.1z"]],
    "comments-question": [576, 512, [], "e14e", ["M48 144c0 25.1 8.1 48.7 22.6 68.8 9.6 13.3 11.7 30.6 5.6 45.9L64.8 287.2 115.3 267c10-4 21.1-4.5 31.4-1.5 14.2 4.2 29.4 6.5 45.3 6.5 83.5 0 144-61.2 144-128S275.6 16 192 16 48 77.2 48 144zm81.3-62.8c8.8-26.2 33.5-45.2 62.7-45.2 36.5 0 66.1 29.6 66.1 66.1 0 39.2-30 55.7-46.5 61.6-1.8 9.3-9.9 16.2-19.6 16.2-11 0-20-9-20-20 0-17.1 12.4-29.3 25-33.5 5.3-1.8 10.8-4.5 14.8-8.5 3.5-3.4 6.3-8.1 6.3-15.9 0-14.4-11.7-26.1-26.1-26.1-11.5 0-21.3 7.4-24.8 17.8-3.5 10.5-14.8 16.1-25.3 12.6s-16.1-14.8-12.6-25.3zM216 224a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm27.3 138.8c13.6 55.5 68.6 101.2 140.7 101.2 15.9 0 31.1-2.3 45.3-6.5 10.3-3.1 21.4-2.5 31.4 1.5l50.4 20.2-11.4-28.5c-6.1-15.2-4-32.6 5.6-45.9 14.5-20.1 22.6-43.7 22.6-68.8 0-56.5-43.3-109-107.2-123.9-26.1 76.8-95 133.7-177.6 150.7z", "M70.6 212.8c9.6 13.3 11.7 30.6 5.6 45.9L64.8 287.2 115.3 267c10-4 21.1-4.5 31.4-1.5 14.2 4.2 29.4 6.5 45.3 6.5 83.5 0 144-61.2 144-128S275.6 16 192 16 48 77.2 48 144c0 25.1 8.1 48.7 22.6 68.8zM31.7 240.8C11.7 213.1 0 179.8 0 144 0 46.8 86-32 192-32s192 78.8 192 176-86 176-192 176c-20.5 0-40.3-3-58.9-8.4L36.8 350.1c-3.2 1.3-6.6 1.9-10 1.9-14.8 0-26.8-12-26.8-26.8 0-3.4 .7-6.8 1.9-10l29.7-74.4zM195.2 368c16.4-.2 32.5-2 48.1-5.2 13.6 55.5 68.6 101.2 140.7 101.2 15.9 0 31.1-2.3 45.3-6.5 10.3-3.1 21.4-2.5 31.4 1.5l50.4 20.2-11.4-28.5c-6.1-15.2-4-32.6 5.6-45.9 14.5-20.1 22.6-43.7 22.6-68.8 0-56.6-43.3-109-107.2-123.9 5.1-14.9 8.5-30.6 10.1-46.9 83.3 19.2 145 88.3 145 170.7 0 35.8-11.6 69.1-31.7 96.8l29.7 74.4c1.3 3.2 1.9 6.6 1.9 10 0 14.8-12 26.8-26.8 26.8-3.4 0-6.8-.7-10-1.9l-96.3-38.5c-18.6 5.5-38.4 8.4-58.9 8.4-94.1 0-172.4-62.1-188.8-144zM192 76c-11.5 0-21.3 7.4-24.8 17.8-3.5 10.5-14.8 16.1-25.3 12.6s-16.1-14.8-12.6-25.3c8.8-26.2 33.5-45.2 62.7-45.2 36.5 0 66.1 29.6 66.1 66.1 0 39.2-30 55.7-46.5 61.6-1.8 9.3-9.9 16.2-19.6 16.2-11 0-20-9-20-20 0-17.1 12.4-29.3 25-33.5 5.3-1.8 10.8-4.5 14.8-8.5 3.5-3.4 6.3-8.1 6.3-15.9 0-14.4-11.7-26.1-26.1-26.1zM168 224a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"]],
    "sort-up": [384, 512, ["sort-asc"], "f0de", ["M70.6 176L190.3 56.3c1-.2 2-.3 3-.3l120 120-242.7 0z", "M70.6 176L192 54.6 313.4 176 70.6 176zM2.4 204.2c5 12 16.6 19.8 29.6 19.8l320 0c12.9 0 24.6-7.8 29.6-19.8s2.2-25.7-6.9-34.9l-160-160c-12.5-12.5-32.8-12.5-45.3 0l-160 160c-9.2 9.2-11.9 22.9-6.9 34.9z"]],
    "billboard": [576, 512, [], "e5cd", ["M80 128l0 240 416 0 0-240c0-8.8-7.2-16-16-16l-72 0 0 32 16 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l16 0 0-32-144 0 0 32 16 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l16 0 0-32-72 0c-8.8 0-16 7.2-16 16z", "M384 32c13.3 0 24 10.7 24 24l0 8 72 0c35.3 0 64 28.7 64 64l0 240 8 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-240 0 0 72c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-72-240 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l8 0 0-240c0-35.3 28.7-64 64-64l72 0 0-8c0-13.3 10.7-24 24-24s24 10.7 24 24l0 8 144 0 0-8c0-13.3 10.7-24 24-24zm112 96c0-8.8-7.2-16-16-16l-72 0 0 32 16 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l16 0 0-32-144 0 0 32 16 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l16 0 0-32-72 0c-8.8 0-16 7.2-16 16l0 240 416 0 0-240z"]],
    "eye": [576, 512, [128065], "f06e", ["M218.7 296c13.8 23.9 39.7 40 69.3 40 44.2 0 80-35.8 80-80 0-29.6-16.1-55.5-40-69.3-1.4 59.7-49.6 107.9-109.3 109.3z", "M288 80C222.8 80 169.2 109.6 128.1 147.7 89.6 183.5 63 226 49.4 256 63 286 89.6 328.5 128.1 364.3 169.2 402.4 222.8 432 288 432s118.8-29.6 159.9-67.7C486.4 328.5 513 286 526.6 256 513 226 486.4 183.5 447.9 147.7 406.8 109.6 353.2 80 288 80zM95.4 112.6C142.5 68.8 207.2 32 288 32s145.5 36.8 192.6 80.6c46.8 43.5 78.1 95.4 93 131.1 3.3 7.9 3.3 16.7 0 24.6-14.9 35.7-46.2 87.7-93 131.1-47.1 43.7-111.8 80.6-192.6 80.6S142.5 443.2 95.4 399.4c-46.8-43.5-78.1-95.4-93-131.1-3.3-7.9-3.3-16.7 0-24.6 14.9-35.7 46.2-87.7 93-131.1zM288 336c44.2 0 80-35.8 80-80 0-29.6-16.1-55.5-40-69.3-1.4 59.7-49.6 107.9-109.3 109.3 13.8 23.9 39.7 40 69.3 40zm-79.6-88.4c2.5 .3 5 .4 7.6 .4 35.3 0 64-28.7 64-64 0-2.6-.2-5.1-.4-7.6-37.4 3.9-67.2 33.7-71.1 71.1zm45.6-115c10.8-3 22.2-4.5 33.9-4.5 8.8 0 17.5 .9 25.8 2.6 .3 .1 .5 .1 .8 .2 57.9 12.2 101.4 63.7 101.4 125.2 0 70.7-57.3 128-128 128-61.6 0-113-43.5-125.2-101.4-1.8-8.6-2.8-17.5-2.8-26.6 0-11 1.4-21.8 4-32 .2-.7 .3-1.3 .5-1.9 11.9-43.4 46.1-77.6 89.5-89.5z"]],
    "arrow-down-small-big": [512, 512, ["sort-size-down-alt"], "f88d", ["M336 80l0 64 64 0 0-64-64 0zm0 224l0 128 128 0 0-128-128 0z", "M233 385l-88 88c-9.4 9.4-24.6 9.4-33.9 0L23 385c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l47 47 0-342.1c0-13.3 10.7-24 24-24s24 10.7 24 24l0 342.1 47-47c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9zM336 144l64 0 0-64-64 0 0 64zm-48 0l0-64c0-26.5 21.5-48 48-48l64 0c26.5 0 48 21.5 48 48l0 64c0 26.5-21.5 48-48 48l-64 0c-26.5 0-48-21.5-48-48zm48 288l128 0 0-128-128 0 0 128zm-48 0l0-128c0-26.5 21.5-48 48-48l128 0c26.5 0 48 21.5 48 48l0 128c0 26.5-21.5 48-48 48l-128 0c-26.5 0-48-21.5-48-48z"]],
    "axe": [640, 512, [129683], "f6b2", ["M89 425c-8.3 8.3-8.3 21.8 0 30.1s21.8 8.3 30.1 0L327 247 297 217 89 425zM275.9 128L415.6 267.7c10.5 10.5 16.4 24.7 16.4 39.6l0 60c84.4-7.6 151.7-74.8 159.3-159.3l-60 0c-14.9 0-29.1-5.9-39.6-16.4L352 51.9 275.9 128z", "M489 7l48 48c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0L455 41c-9.4-9.4-9.4-24.6 0-33.9S479.6-2.3 489 7zm2.7 184.6L352 51.9 275.9 128 415.6 267.7c10.5 10.5 16.4 24.7 16.4 39.6l0 60c84.4-7.6 151.7-74.8 159.3-159.3l-60 0c-14.9 0-29.1-5.9-39.6-16.4zM385.9 17.9L525.7 157.7c1.5 1.5 3.5 2.3 5.7 2.3l84.7 0c13.3 0 24 10.7 24 24l0 8c0 123.7-100.3 224-224 224l-8 0c-13.3 0-24-10.7-24-24l0-84.7c0-2.1-.8-4.2-2.3-5.7L361 281 153 489c-27 27-70.9 27-97.9 0S28 418.1 55 391l208-208-21.1-21.1c-18.7-18.7-18.7-49.1 0-67.9l76.1-76.1c18.7-18.7 49.1-18.7 67.9 0zM297 217L89 425c-8.3 8.3-8.3 21.8 0 30.1s21.8 8.3 30.1 0L327 247 297 217z"]],
    "caret-left": [256, 512, [], "f0d9", ["M54.9 256l89.4 89.4 0-178.8-89.4 89.4z", "M9.7 233.4c-11.6 12.9-12.8 32.4 0 45.2l128 128c9.1 9.2 22.9 11.9 34.9 6.9l4.3-2.2c9.5-5.7 15.5-16.1 15.5-27.4l0-256-.3-4.8c-1.4-9.4-7-17.7-15.1-22.6l-4.3-2.2c-12-4.9-25.7-2.2-34.9 6.9l-128 128zm134.6-66.8l0 178.8-89.4-89.4 89.4-89.4z"]],
    "apple-whole": [448, 512, [127822, 127823, "apple-alt"], "f5d1", ["M48 288c0-31.7 7.6-62.5 20.4-83.7 12.1-19.9 26.2-28.3 43.6-28.3 17.8 0 43.2 7.4 65.3 16 30 11.7 63.5 11.7 93.5 0 22.1-8.6 47.5-16 65.3-16 17.3 0 31.5 8.3 43.6 28.3 12.9 21.2 20.4 52.1 20.4 83.7 0 54.2-17 100-40.4 131.2-24 32-51.2 44.8-71.6 44.8-4.6 0-13.6-1.7-24.9-5.1-25.4-7.6-52.7-7.6-78.1 0-11.3 3.4-20.3 5.1-24.9 5.1-20.4 0-47.6-12.8-71.6-44.8-23.4-31.2-40.4-77-40.4-131.2z", "M224 112l16 0c44.2 0 80-35.8 80-80l0-16c0-8.8-7.2-16-16-16L288 0c-44.2 0-80 35.8-80 80l0 16c0 8.8 7.2 16 16 16zM48 288c0-31.7 7.6-62.5 20.4-83.7 12.1-19.9 26.2-28.3 43.6-28.3 17.8 0 43.2 7.4 65.3 16 30 11.7 63.5 11.7 93.5 0 22.1-8.6 47.5-16 65.3-16 17.3 0 31.5 8.3 43.6 28.3 12.9 21.2 20.4 52.1 20.4 83.7 0 54.2-17 100-40.4 131.2-24 32-51.2 44.8-71.6 44.8-4.6 0-13.6-1.7-24.9-5.1-25.4-7.6-52.7-7.6-78.1 0-11.3 3.4-20.3 5.1-24.9 5.1-20.4 0-47.6-12.8-71.6-44.8-23.4-31.2-40.4-77-40.4-131.2zm64-160c-76.3 0-112 83.7-112 160 0 128 80 224 160 224 11.9 0 26.5-3.4 38.8-7.1 16.4-4.9 34.1-4.9 50.5 0 12.2 3.7 26.8 7.1 38.8 7.1 80 0 160-96 160-224 0-76.3-35.7-160-112-160-27.3 0-59.7 10.3-82.7 19.3-18.8 7.3-39.9 7.3-58.7 0-22.9-8.9-55.4-19.3-82.7-19.3z"]],
    "scroll-torah": [576, 512, ["torah"], "f6a0", ["M48 88l0 336c0 13.3 10.7 24 24 24s24-10.7 24-24L96 88c0-13.3-10.7-24-24-24S48 74.7 48 88zm96 8l0 320 288 0 0-320-288 0zm32 108.5c0-6.9 5.6-12.5 12.5-12.5l56.9 0 30.5-49.2c2.6-4.2 7.2-6.8 12.2-6.8s9.6 2.6 12.2 6.8l30.5 49.2 56.9 0c6.9 0 12.5 5.6 12.5 12.5 0 2.3-.6 4.6-1.9 6.6l-27.8 45 27.8 45c1.2 2 1.9 4.2 1.9 6.6 0 6.9-5.6 12.5-12.5 12.5l-56.9 0-30.5 49.2c-2.6 4.2-7.2 6.8-12.2 6.8s-9.6-2.6-12.2-6.8l-30.5-49.2-56.9 0c-6.9 0-12.5-5.6-12.5-12.5 0-2.3 .6-4.6 1.9-6.6l27.8-45-27.8-45c-1.2-2-1.9-4.2-1.9-6.6zM480 88l0 336c0 13.3 10.7 24 24 24s24-10.7 24-24l0-336c0-13.3-10.7-24-24-24s-24 10.7-24 24z", "M96 88l0 336c0 13.3-10.7 24-24 24s-24-10.7-24-24L48 88c0-13.3 10.7-24 24-24S96 74.7 96 88zM72 496c25 0 47-12.7 59.9-32l312.2 0c12.9 19.3 34.9 32 59.9 32 39.8 0 72-32.2 72-72l0-336c0-39.8-32.2-72-72-72-25 0-47 12.7-59.9 32L131.9 48C119 28.7 97 16 72 16 32.2 16 0 48.2 0 88L0 424c0 39.8 32.2 72 72 72zM480 88c0-13.3 10.7-24 24-24s24 10.7 24 24l0 336c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-336zm-48 8l0 320-288 0 0-320 288 0zM177.9 301c-1.2 2-1.9 4.2-1.9 6.6 0 6.9 5.6 12.5 12.5 12.5l56.9 0 30.5 49.2c2.6 4.2 7.2 6.8 12.2 6.8s9.6-2.6 12.2-6.8l30.5-49.2 56.9 0c6.9 0 12.5-5.6 12.5-12.5 0-2.3-.6-4.6-1.9-6.6l-27.8-45 27.8-45c1.2-2 1.9-4.2 1.9-6.6 0-6.9-5.6-12.5-12.5-12.5l-56.9 0-30.5-49.2c-2.6-4.2-7.2-6.8-12.2-6.8s-9.6 2.6-12.2 6.8l-30.5 49.2-56.9 0c-6.9 0-12.5 5.6-12.5 12.5 0 2.3 .6 4.6 1.9 6.6l27.8 45-27.8 45z"]],
    "house-lock": [640, 512, [], "e510", ["M128 199.7l160-143.4 160 143.4 0 4.4c-29.3 23.5-48 59.5-48 99.9l0 24.4c-6.5 5.8-12.2 12.5-17 19.9-5.6-34.2-35.3-60.3-71.1-60.3l-48 0c-39.8 0-72 32.2-72 72l0 104-48 0c-8.8 0-16-7.2-16-16l0-248.3z", "M272 6.1c9.1-8.2 22.9-8.2 32 0L497.5 179.6c-18.4 4.5-35.2 13-49.6 24.4l0-4.4-160-143.4-160 143.4 0 248.3c0 8.8 7.2 16 16 16l48 0 0-104c0-39.8 32.2-72 72-72l48 0c35.8 0 65.5 26.1 71.1 60.3-9.5 14.9-15 32.6-15 51.6l0 96c0 5.5 .5 10.9 1.3 16.1L144 512c-35.3 0-64-28.7-64-64l0-205.3-8 7.2c-9.9 8.8-25 8-33.9-1.8s-8-25 1.8-33.9L272 6.1zM240 464l96 0 0-104c0-13.3-10.7-24-24-24l-48 0c-13.3 0-24 10.7-24 24l0 104zM560 304.1c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 47.9 64 0 0-47.9zM416 400c0-20.9 13.4-38.7 32-45.3l0-50.6c0-44.2 35.8-80 80-80s80 35.8 80 80l0 50.6c18.6 6.6 32 24.4 32 45.3l0 96c0 26.5-21.5 48-48 48l-128 0c-26.5 0-48-21.5-48-48l0-96z"]],
    "square-litecoin": [448, 512, [], "e6f7", ["M48 96l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16zm64.8 165.1c-2.8-8.4 1.7-17.4 10.1-20.2l37.1-12.4 0-76.5c0-13.3 10.7-24 24-24s24 10.7 24 24l0 60.5 58.9-19.6c8.4-2.8 17.4 1.7 20.2 10.1s-1.7 17.4-10.1 20.2l-69.1 23 0 89.8 88 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-112 0c-13.3 0-24-10.7-24-24l0-97.8-26.9 9c-8.4 2.8-17.4-1.7-20.2-10.1z", "M64 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm184 32c13.3 0 24 10.7 24 24l0 60.5 58.9-19.6c8.4-2.8 17.4 1.7 20.2 10.1s-1.7 17.4-10.1 20.2l-69.1 23 0 89.8 88 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-112 0c-13.3 0-24-10.7-24-24l0-97.8-26.9 9c-8.4 2.8-17.4-1.7-20.2-10.1s1.7-17.4 10.1-20.2l37.1-12.4 0-76.5c0-13.3 10.7-24 24-24z"]],
    "arrows-left-right-to-line": [576, 512, [], "e4ba", ["", "M48 120l0 272c0 13.3-10.7 24-24 24S0 405.3 0 392L0 120c0-13.3 10.7-24 24-24s24 10.7 24 24zm528 0l0 272c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-272c0-13.3 10.7-24 24-24s24 10.7 24 24zM473 239c9.4 9.4 9.4 24.6 0 33.9l-72 72c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l31-31-220.1 0 31 31c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-72-72c-9.4-9.4-9.4-24.6 0-33.9l72-72c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-31 31 220.1 0-31-31c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l72 72z"]],
    "trash": [448, 512, [], "f1f8", ["M76.9 144L99.5 449.2c.6 8.4 7.6 14.8 16 14.8l217.1 0c8.4 0 15.3-6.5 16-14.8L371.1 144 76.9 144z", "M136.2 4.8c4.7-12.5 16.6-20.8 30-20.8l115.6 0c13.3 0 25.3 8.3 30 20.8L328 48 424 48c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 96C10.7 96 0 85.3 0 72S10.7 48 24 48l96 0 16.2-43.2zm-84.6 448L28.7 144 76.9 144 99.5 449.2c.6 8.4 7.6 14.8 16 14.8l217.1 0c8.4 0 15.3-6.5 16-14.8l22.6-305.2 48.1 0-22.9 308.7c-2.5 33.4-30.3 59.3-63.8 59.3l-217.1 0c-33.5 0-61.3-25.9-63.8-59.3z"]],
    "face-sad-tear": [512, 512, [128546, "sad-tear"], "f5b4", ["M48 256c0 41.8 12.3 80.7 33.6 113.3 8.2 44.7 47.3 78.6 94.3 78.7 24.7 10.3 51.7 16 80.1 16 114.9 0 208-93.1 208-208S370.9 48 256 48 48 141.1 48 256zm80 92.8c0-17.2 11.2-34 20.3-47.4 5.7-8.5 11.9-16.7 18.3-24.6 2.4-2.9 5.7-4.8 9.4-4.8s7 1.9 9.4 4.8c6.5 7.8 12.6 16.1 18.3 24.6 9 13.4 20.3 30.2 20.3 47.4 0 28.3-21.5 51.2-48 51.2s-48-22.9-48-51.2zM208 208a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm52.9 99.1c8.7-2 17.8-3.1 27.1-3.1 40.2 0 75.7 19.8 97.5 50 7.7 10.8 5.3 25.8-5.5 33.5s-25.8 5.3-33.5-5.5c-13.1-18.2-34.4-30-58.5-30-5.5 0-10.9 .6-16 1.8 0-.6 0-1.2 0-1.8 0-16.2-4-31.5-11.1-44.9zM368 208a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M464 256c0-114.9-93.1-208-208-208S48 141.1 48 256c0 41.8 12.3 80.7 33.6 113.3 8.2 44.7 47.3 78.6 94.3 78.7 24.7 10.3 51.7 16 80.1 16 114.9 0 208-93.1 208-208zM288 352c-5.5 0-10.9 .6-16 1.8 0-.6 0-1.2 0-1.8 0-16.2-4-31.5-11.1-44.9 8.7-2 17.8-3.1 27.1-3.1 40.2 0 75.7 19.8 97.5 50 7.7 10.8 5.3 25.8-5.5 33.5s-25.8 5.3-33.5-5.5c-13.1-18.2-34.4-30-58.5-30zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm176-80a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm128 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM185.4 276.8c6.5 7.8 12.6 16.1 18.3 24.6 9 13.4 20.3 30.2 20.3 47.4 0 28.3-21.5 51.2-48 51.2s-48-22.9-48-51.2c0-17.2 11.2-34 20.3-47.4 5.7-8.5 11.9-16.7 18.3-24.6 2.4-2.9 5.7-4.8 9.4-4.8s7 1.9 9.4 4.8z"]],
    "tire-flat": [512, 512, [], "f632", ["M48 288c0 31 6.8 60.3 18.8 86.7 6.9 15.1 7 33-.8 48.5L48.4 458.5c-.3 .5-.4 1.1-.4 1.7 0 2.1 1.7 3.8 3.8 3.8l408.4 0c2.1 0 3.8-1.7 3.8-3.8 0-.6-.1-1.2-.4-1.7l-17.7-35.3c-7.8-15.6-7.7-33.4-.8-48.5 12.1-26.3 18.8-55.6 18.8-86.7 0-114.9-93.1-208-208-208S48 173.1 48 288zm376 0a168 168 0 1 1 -336 0 168 168 0 1 1 336 0z", "M464 288c0-114.9-93.1-208-208-208S48 173.1 48 288c0 31 6.8 60.3 18.8 86.7 6.9 15.1 7 33-.8 48.5L48.4 458.5c-.3 .5-.4 1.1-.4 1.7 0 2.1 1.7 3.8 3.8 3.8l408.4 0c2.1 0 3.8-1.7 3.8-3.8 0-.6-.1-1.2-.4-1.7l-17.7-35.3c-7.8-15.6-7.7-33.4-.8-48.5 12.1-26.3 18.8-55.6 18.8-86.7zm48 0c0 38.1-8.3 74.2-23.2 106.7-1 2.2-1 4.8 .1 7l17.7 35.3c3.6 7.2 5.5 15.1 5.5 23.2 0 28.6-23.2 51.8-51.8 51.8L51.8 512c-28.6 0-51.8-23.2-51.8-51.8 0-8 1.9-16 5.5-23.2l17.7-35.3c1.1-2.2 1.1-4.8 .1-7-14.9-32.5-23.2-68.6-23.2-106.7 0-141.4 114.6-256 256-256S512 146.6 512 288zm-136 0c0-31.2-11.9-59.6-31.4-80.9l-24.2 33.4c9.8 13.3 15.6 29.7 15.6 47.5l0 .9 39.2 12.8c.5-4.5 .8-9 .8-13.6zm-54.9 46.5c-10 14-24.4 24.6-41.2 29.9l0 41.3c34.4-7 63.5-28.7 80.4-58.3l-39.3-12.8zM232 364.3c-16.7-5.3-31.1-15.9-41.1-29.8l-39.3 12.8c16.8 29.6 45.9 51.3 80.3 58.3l0-41.3zM136 288c0 4.6 .3 9.2 .8 13.6l39.2-12.8 0-.9c0-17.8 5.8-34.2 15.6-47.5l-1.7-2.3-22.6-31.1C147.9 228.4 136 256.8 136 288zm120-80c9 0 17.6 1.5 25.6 4.2l24.2-33.4c-15.2-6.9-32-10.8-49.8-10.8s-34.6 3.9-49.8 10.8l22.6 31.2 1.6 2.2c8-2.7 16.6-4.2 25.6-4.2zM88 288a168 168 0 1 1 336 0 168 168 0 1 1 -336 0zm200 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"]],
    "melon": [512, 512, [], "e310", ["M48 256c0 25.8 4.7 50.4 13.2 73.2 14.9-51.3 51.2-110.5 104.3-163.6S277.9 76.1 329.2 61.2C306.4 52.7 281.8 48 256 48 141.1 48 48 141.1 48 256zm61 147c5.2 5.2 24.1 13.9 67.8-.7 40.7-13.6 89.9-44 135.7-89.9s76.3-95 89.9-135.7c14.6-43.7 5.8-62.6 .7-67.8s-24.1-13.9-67.8 .7c-40.7 13.6-89.8 44-135.7 89.9s-76.3 95-89.9 135.7c-14.6 43.7-5.8 62.6-.7 67.8zm73.8 47.7c22.8 8.6 47.4 13.2 73.2 13.2 114.9 0 208-93.1 208-208 0-25.8-4.7-50.4-13.2-73.2-14.9 51.3-51.2 110.5-104.3 163.6S234.1 435.9 182.8 450.8z", "M464 256c0-25.8-4.7-50.4-13.2-73.2-14.9 51.3-51.2 110.5-104.3 163.6S234.1 435.9 182.8 450.8c22.8 8.6 47.4 13.2 73.2 13.2 114.9 0 208-93.1 208-208zM61.2 329.2c14.9-51.3 51.2-110.5 104.3-163.6S277.9 76.1 329.2 61.2c-22.8-8.6-47.4-13.2-73.2-13.2-114.9 0-208 93.1-208 208 0 25.8 4.7 50.4 13.2 73.2zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zM403 109c-5.2-5.2-24.1-13.9-67.8 .7-40.7 13.6-89.8 44-135.7 89.9s-76.3 95-89.9 135.7c-14.6 43.7-5.8 62.6-.7 67.8s24.1 13.9 67.8-.7c40.7-13.6 89.9-44 135.7-89.9s76.3-95 89.9-135.7c14.6-43.7 5.8-62.6 .7-67.8z"]],
    "fax": [512, 512, [128224, 128439], "f1ac", ["M48 176l0 256 64 0 0-256-64 0zm112 64l0 192 304 0 0-192-304 0zm96 48a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm0 96a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm88-96a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm0 96a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm88-96a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm0 96a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M160 64c0-8.8 7.2-16 16-16l159.4 0c4.2 0 8.3 1.7 11.3 4.7l48.6 48.6c3 3 4.7 7.1 4.7 11.3l0 31.4 48 0 0-31.4c0-17-6.7-33.3-18.7-45.3L380.7 18.7C368.7 6.7 352.4 0 335.4 0L176 0c-35.3 0-64 28.7-64 64l0 64-72 0c-22.1 0-40 17.9-40 40L0 440c0 22.1 17.9 40 40 40l432 0c22.1 0 40-17.9 40-40l0-208c0-22.1-17.9-40-40-40l-312 0 0-128zM112 176l0 256-64 0 0-256 64 0zm48 256l0-192 304 0 0 192-304 0zm72-120a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm24 72a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm64-72a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm24 72a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm64-72a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm24 72a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"]],
    "arrow-left-long-to-line": [640, 512, [], "e3d4", ["", "M0 120L0 392c0 13.3 10.7 24 24 24s24-10.7 24-24l0-272c0-13.3-10.7-24-24-24S0 106.7 0 120zM135 239c-9.4 9.4-9.4 24.6 0 33.9L271 409c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-95-95 406.1 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-406.1 0 95-95c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0L135 239z"]],
    "user-music": [640, 512, [], "f8eb", ["M56 512c13.3 0 24-10.7 24-24l0-8c0-70.7 57.3-128 128-128l96 0c17 0 33.2 3.3 48 9.3l0 42.5c-15.3 3.8-29.7 10.5-42.1 19.7-20.7 15.5-37.9 40.6-37.9 72.3 0 5.6 .5 11 1.5 16.2L56 512zM336 128a80 80 0 1 1 -160 0 80 80 0 1 1 160 0z", "M176 128a80 80 0 1 1 160 0 80 80 0 1 1 -160 0zm208 0a128 128 0 1 0 -256 0 128 128 0 1 0 256 0zM80 480c0-70.7 57.3-128 128-128l96 0c17 0 33.2 3.3 48 9.3l0-50.7c-15.3-4.3-31.4-6.6-48-6.6l-96 0c-97.2 0-176 78.8-176 176l0 8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-8zM624 256c0-7.1-3.2-13.9-8.6-18.4s-12.7-6.5-19.7-5.2l-176 32c-11.4 2.1-19.7 12-19.7 23.6l0 161.6c-5.9-1.1-11.4-1.6-16-1.6-9.5 0-22.9 2.1-34.9 7.5-11.1 5-29.1 17.2-29.1 40.5s18 35.4 29.1 40.5c11.9 5.4 25.4 7.5 34.9 7.5s22.9-2.1 34.9-7.5c11.1-5 29.1-17.2 29.1-40.5l0-139.9 128-23.3 0 84.9c-5.9-1.1-11.4-1.6-16-1.6-9.5 0-22.9 2.1-34.9 7.5-11.1 5-29.1 17.2-29.1 40.5s18 35.4 29.1 40.5c11.9 5.4 25.4 7.5 34.9 7.5s22.9-2.1 34.9-7.5c11.1-5 29.1-17.2 29.1-40.5l0-208z"]],
    "person-circle-plus": [640, 512, [], "e541", ["M192 167.1l0 152.9 64 0 0-152.9c-9.9-4.6-20.8-7.1-32-7.1s-22.1 2.5-32 7.1z", "M224-32a56 56 0 1 1 0 112 56 56 0 1 1 0-112zM192 320l64 0 0-152.9c-9.9-4.6-20.8-7.1-32-7.1s-22.1 2.5-32 7.1L192 320zm0 48l0 152c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-302.4-60.5 84.4c-7.7 10.8-22.7 13.3-33.5 5.5S36.8 284.8 44.5 274l79.2-110.5C146.8 131.2 184.2 112 224 112s77.2 19.2 100.3 51.5L382.7 245c-13.1 9.6-24.9 20.8-35.2 33.3L304 217.6 304 520c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-152-64 0zM496 256a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm16 80c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 48-48 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l48 0 0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48 48 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-48 0 0-48z"]],
    "hamsa": [512, 512, [], "f665", ["M48 319.6c0 4.1 1.6 8.1 4.6 11l83.8 83.8C168.1 446.2 211.1 464 256 464s87.9-17.8 119.6-49.5l83.8-83.8c2.9-2.9 4.6-6.9 4.6-11 0-8.6-7-15.6-15.6-15.6L400 304c-13.3 0-24-10.7-24-24l0-176c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 96c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-128c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 128c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-96c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 176c0 13.3-10.7 24-24 24l-48.4 0C55 304 48 311 48 319.6zM160 352c0-5.2 1.8-10.1 5.4-13.8 13.8-14.4 52.2-50.2 90.6-50.2s76.8 35.8 90.6 50.2c3.6 3.7 5.4 8.7 5.4 13.8s-1.8 10.1-5.4 13.8C332.8 380.2 294.4 416 256 416s-76.8-35.8-90.6-50.2c-3.6-3.7-5.4-8.7-5.4-13.8z", "M184 104l0 96c0 13.3 10.7 24 24 24s24-10.7 24-24l0-128c0-13.3 10.7-24 24-24s24 10.7 24 24l0 128c0 13.3 10.7 24 24 24s24-10.7 24-24l0-96c0-13.3 10.7-24 24-24s24 10.7 24 24l0 176c0 13.3 10.7 24 24 24l48.4 0c8.6 0 15.6 7 15.6 15.6 0 4.1-1.6 8.1-4.6 11l-83.8 83.8C343.9 446.2 300.9 464 256 464s-87.9-17.8-119.6-49.5L52.6 330.6c-2.9-2.9-4.6-6.9-4.6-11 0-8.6 7-15.6 15.6-15.6l48.4 0c13.3 0 24-10.7 24-24l0-176c0-13.3 10.7-24 24-24s24 10.7 24 24zm7.8-64.6c-9.6-4.7-20.4-7.4-31.8-7.4-39.8 0-72 32.2-72 72l0 152-24.4 0c-35.1 0-63.6 28.5-63.6 63.6 0 16.9 6.7 33 18.6 45l83.8 83.8c40.7 40.7 96 63.6 153.5 63.6s112.8-22.9 153.5-63.6l83.8-83.8c11.9-11.9 18.6-28.1 18.6-45 0-35.1-28.5-63.6-63.6-63.6l-24.4 0 0-152c0-39.8-32.2-72-72-72-11.4 0-22.2 2.7-31.8 7.4-11.9-23.4-36.2-39.4-64.2-39.4s-52.3 16-64.2 39.4zM165.4 338.2c-3.6 3.7-5.4 8.7-5.4 13.8s1.8 10.1 5.4 13.8C179.2 380.2 217.6 416 256 416s76.8-35.8 90.6-50.2c3.6-3.7 5.4-8.7 5.4-13.8s-1.8-10.1-5.4-13.8C332.8 323.8 294.4 288 256 288s-76.8 35.8-90.6 50.2zM256 320a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]],
    "house-building": [640, 512, [], "e1b1", ["M80 263.1L80 448c0 8.8 7.2 16 16 16l224 0c8.8 0 16-7.2 16-16l0-184.9-128-111.3-128 111.3zM160 296c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-48z", "M576 48L352 48c-8.8 0-16 7.2-16 16l0 71.9-48-41.7 0-30.2c0-35.3 28.7-64 64-64L576 0c35.3 0 64 28.7 64 64l0 384c0 35.3-28.7 64-64 64l-164.1 0c9.8-14 16.4-30.3 18.9-48L576 464c8.8 0 16-7.2 16-16l0-384c0-8.8-7.2-16-16-16zm-96 64c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm16 80l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM480 304c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM400 96l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zm-176.3 5.9l184 160c10 8.7 11.1 23.9 2.4 33.9-6.7 7.7-17.1 10.1-26.1 6.9L384 448c0 35.3-28.7 64-64 64L96 512c-35.3 0-64-28.7-64-64l0-145.4c-9 3.2-19.5 .8-26.1-6.9-8.7-10-7.6-25.2 2.4-33.9l184-160c9-7.9 22.5-7.9 31.5 0zM336 263.1L208 151.8 80 263.1 80 448c0 8.8 7.2 16 16 16l224 0c8.8 0 16-7.2 16-16l0-184.9zM160 296c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-48z"]],
    "person-circle-question": [640, 512, [], "e542", ["M192 167.1l0 152.9 64 0 0-152.9c-9.9-4.6-20.8-7.1-32-7.1s-22.1 2.5-32 7.1z", "M224-32a56 56 0 1 1 0 112 56 56 0 1 1 0-112zM192 320l64 0 0-152.9c-9.9-4.6-20.8-7.1-32-7.1s-22.1 2.5-32 7.1L192 320zm0 48l0 152c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-302.4-60.5 84.4c-7.7 10.8-22.7 13.3-33.5 5.5S36.8 284.8 44.5 274l79.2-110.5C146.8 131.2 184.2 112 224 112s77.2 19.2 100.3 51.5L382.7 245c-13.1 9.6-24.9 20.8-35.2 33.3L304 217.6 304 520c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-152-64 0zM496 256a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm0 228a20 20 0 1 0 0-40 20 20 0 1 0 0 40zm0-140c13.3 0 24 10.7 24 24 0 7.2-4.2 13.7-10.8 16.6l-12.4 5.5c-10.2 4.5-16.8 14.7-16.8 25.9 0 8.8 7.2 16 16 16 8 0 14.6-5.9 15.8-13.5l10.4-4.6c18.1-8.1 29.8-26 29.8-45.9 0-30.9-25.1-56-56-56-27.1 0-49.7 19.2-54.9 44.8-1.8 8.7 3.8 17.1 12.5 18.9s17.1-3.8 18.9-12.5c2.2-11 11.9-19.2 23.5-19.2z"]],
    "crate-empty": [512, 512, [], "e151", ["M48 280l0 64 416 0 0-64c0-4.4-3.6-8-8-8L56 272c-4.4 0-8 3.6-8 8zm0 112l0 64c0 4.4 3.6 8 8 8l400 0c4.4 0 8-3.6 8-8l0-64-416 0zm64-88a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm0 128a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zM432 304a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm0 128a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M56 272c-4.4 0-8 3.6-8 8l0 64 416 0 0-64c0-4.4-3.6-8-8-8L56 272zM48 392l0 64c0 4.4 3.6 8 8 8l400 0c4.4 0 8-3.6 8-8l0-64-416 0zM0 280c0-30.9 25.1-56 56-56l400 0c30.9 0 56 25.1 56 56l0 176c0 30.9-25.1 56-56 56L56 512c-30.9 0-56-25.1-56-56L0 280zm400 24a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm16 112a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM80 304a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM96 416a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"]],
    "sun-haze": [576, 512, [], "f765", ["M83.8 171.4l83.9-17c9.5-1.9 16.8-9.3 18.8-18.8l17-83.9 71.3 47.3c8 5.3 18.5 5.3 26.5 0l71.3-47.3 17 83.9c1.9 9.5 9.3 16.8 18.8 18.8l83.9 17-47.3 71.3c-5.3 8-5.3 18.5 0 26.5l33.7 50.7-119 0c15.2-17 24.5-39.4 24.5-64 0-53-43-96-96-96s-96 43-96 96c0 24.6 9.2 47 24.5 64l-119 0 33.7-50.7c5.3-8 5.3-18.5 0-26.5L83.8 171.4z", "M200.2-7.9c-6.7-4.4-15.1-5.2-22.5-2.2S165-.5 163.4 7.3L142.6 110.6 39.3 131.4c-7.8 1.6-14.4 7-17.4 14.3s-2.2 15.8 2.2 22.5l58.2 87.8-42.5 64 57.6 0 33.7-50.7c5.3-8 5.3-18.5 0-26.5l-47.3-71.3 83.9-17c9.5-1.9 16.8-9.3 18.8-18.8l17-83.9 71.3 47.3c8 5.3 18.5 5.3 26.5 0l71.3-47.3 17 83.9c1.9 9.5 9.3 16.8 18.8 18.8l83.9 17-47.3 71.3c-5.3 8-5.3 18.5 0 26.5l33.7 50.7 57.6 0-42.5-64 58.2-87.8c4.4-6.7 5.2-15.1 2.2-22.5s-9.6-12.8-17.4-14.3L433.4 110.6 412.6 7.3C411-.5 405.6-7 398.2-10.1s-15.8-2.2-22.5 2.2L288 50.3 200.2-7.9zM192 256c0 24.6 9.2 47 24.5 64l143.1 0c15.2-17 24.5-39.4 24.5-64 0-53-43-96-96-96s-96 43-96 96zm48 0a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM512 392c0-13.3-10.7-24-24-24L24 368c-13.3 0-24 10.7-24 24s10.7 24 24 24l464 0c13.3 0 24-10.7 24-24zM64 488c0 13.3 10.7 24 24 24l80 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0c-13.3 0-24 10.7-24 24zm176 0c0 13.3 10.7 24 24 24l288 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-288 0c-13.3 0-24 10.7-24 24z"]],
    "circle-3": [512, 512, [], "e0f0", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm128-88c0-13.3 10.7-24 24-24l76 0c37.6 0 68 30.4 68 68 0 16.8-6.1 32.1-16.2 44 10.1 11.9 16.2 27.2 16.2 44 0 37.6-30.4 68-68 68l-76 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l76 0c11 0 20-9 20-20s-9-20-20-20l-52 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l52 0c11 0 20-9 20-20s-9-20-20-20l-76 0c-13.3 0-24-10.7-24-24z", "M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm20-280l-52 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l52 0c11 0 20 9 20 20s-9 20-20 20l-76 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l76 0c37.6 0 68-30.4 68-68 0-16.8-6.1-32.1-16.2-44 10.1-11.9 16.2-27.2 16.2-44 0-37.6-30.4-68-68-68l-76 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l76 0c11 0 20 9 20 20s-9 20-20 20z"]],
    "clipboard-check": [384, 512, [], "f46c", ["M48 96l0 352c0 8.8 7.2 16 16 16l256 0c8.8 0 16-7.2 16-16l0-352c0-8.8-7.2-16-16-16l-16.4 0c-4 36-34.5 64-71.6 64l-80 0c-37.1 0-67.6-28-71.6-64L64 80c-8.8 0-16 7.2-16 16zm70.8 242.2c-9.2-9.5-8.9-24.7 .6-33.9 9.5-9.2 24.7-9 33.9 .6l16.1 16.6 59.3-81.6c7.8-10.7 22.8-13.1 33.5-5.3s13.1 22.8 5.3 33.5L191.4 372.8c-4.2 5.7-10.7 9.3-17.8 9.8-7.1 .5-14-2.2-18.9-7.3l-35.9-37.2z", "M232 0c25 0 47 12.7 59.9 32l28.1 0 6.5 .3C358.8 35.6 384 62.9 384 96l0 352c0 33.1-25.2 60.4-57.5 63.7l-6.5 .3-256 0C30.9 512 3.6 486.8 .3 454.5L0 448 0 96C0 60.7 28.7 32 64 32l28.1 0C105 12.7 127 0 152 0l80 0zM64 80c-8.8 0-16 7.2-16 16l0 352c0 8.8 7.2 16 16 16l256 0c8.8 0 16-7.2 16-16l0-352c0-8.8-7.2-16-16-16l-16.4 0c-4 36-34.5 64-71.6 64l-80 0c-37.1 0-67.6-28-71.6-64L64 80zM228.7 239.9c7.8-10.7 22.8-13.1 33.5-5.3s13.1 22.8 5.3 33.5L191.4 372.8c-4.2 5.7-10.7 9.3-17.8 9.8-7.1 .5-14-2.2-18.9-7.3l-35.9-37.2c-9.2-9.5-8.9-24.7 .6-33.9 9.5-9.2 24.7-9 33.9 .6l16.1 16.6 59.3-81.6zM152 48c-13.3 0-24 10.7-24 24s10.7 24 24 24l80 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0z"]],
    "share-from-square": [576, 512, [61509, "share-square"], "f14d", ["M224.5 240c0 11.7 1.9 22.2 5.2 31.6 14.4-46.1 57.5-79.6 108.3-79.6l70.5 0c13.3 0 24 10.7 24 24l0 22.1 78.1-78.1-78.1-78.1 0 22.1c0 13.3-10.7 24-24 24l-72 0c-61.9 0-112 50.1-112 112z", "M425.5 7c-6.9-6.9-17.2-8.9-26.2-5.2S384.5 14.3 384.5 24l0 56-48 0c-88.4 0-160 71.6-160 160 0 46.7 20.7 80.4 43.6 103.4 8.1 8.2 16.5 14.9 24.3 20.4 9.2 6.5 21.7 5.7 30.1-1.9s10.2-20 4.5-29.8c-3.6-6.3-6.5-14.9-6.5-26.7 0-36.2 29.3-65.5 65.5-65.5l46.5 0 0 56c0 9.7 5.8 18.5 14.8 22.2s19.3 1.7 26.2-5.2l136-136c9.4-9.4 9.4-24.6 0-33.9L425.5 7zm7 97l0-22.1 78.1 78.1-78.1 78.1 0-22.1c0-13.3-10.7-24-24-24L338 192c-50.9 0-93.9 33.5-108.3 79.6-3.3-9.4-5.2-19.8-5.2-31.6 0-61.9 50.1-112 112-112l72 0c13.3 0 24-10.7 24-24zm-320-8c-44.2 0-80 35.8-80 80l0 256c0 44.2 35.8 80 80 80l256 0c44.2 0 80-35.8 80-80l0-24c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 24c0 17.7-14.3 32-32 32l-256 0c-17.7 0-32-14.3-32-32l0-256c0-17.7 14.3-32 32-32l24 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-24 0z"]],
    "fork-knife": [512, 512, ["utensils-alt"], "f2e6", ["M58.2 92.1L152.1 186c0 .7 0 1.4 0 2 0 20.4 3.9 40.3 11.3 58.9-7.1 7.1-14.2 14.2-21.2 21.2L72.3 198.2c-28.8-28.8-33.5-72.5-14-106.2zM248.1 188c0-20.2 10.5-39.9 27.7-52.8l122.7-92c10.6-8 12.8-23 4.8-33.6-.1-.2-.3-.4-.5-.6L442 48.1c-6.7-.5-13.7 1.8-18.8 7l-116 116c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l116-116c5.2-5.2 7.5-12.1 7-18.9L504 110c-.5-.4-1-.8-1.5-1.2-10.6-8-25.6-5.8-33.6 4.8l-92 122.7c-12.9 17.2-32.6 27.7-52.8 27.7-16.7 0-32.7-6.6-44.5-18.4l-13.1-13.1c-11.8-11.8-18.4-27.8-18.4-44.5z", "M403.3 9.6c8 10.6 5.8 25.6-4.8 33.6l-122.7 92c-17.2 12.9-27.7 32.5-27.7 52.8 0 16.7 6.6 32.7 18.4 44.5l13.1 13.1c11.8 11.8 27.8 18.4 44.5 18.4 20.2 0 39.9-10.5 52.8-27.7l92-122.7c8-10.6 23-12.8 33.6-4.8s12.8 23 4.8 33.6l-92 122.7c-21 27.9-54.3 46.9-91.2 46.9-24.5 0-48.1-8.1-67.3-22.8L41.1 505c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9L222.9 255.3c-14.7-19.2-22.8-42.8-22.8-67.3 0-36.9 19-70.2 46.9-91.2l122.7-92c10.6-8 25.6-5.8 33.6 4.8zM457.1 55c9.4 9.4 9.4 24.6 0 33.9l-116 116c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l116-116c9.4-9.4 24.6-9.4 33.9 0zM382.8 348.8L505.1 471c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-145-145c19.6-.3 38.8-4.1 56.7-11.2zM152.1 186L58.2 92.1c-19.4 33.6-14.7 77.4 14 106.2l69.9 69.9-33.9 33.9-69.9-69.9c-53.1-53.1-53.1-139.2 0-192.3l.8-.8c9.4-9.4 24.6-9.4 33.9 0l90.3 90.3c-7.1 17.9-11 37.1-11.2 56.7z"]],
    "receipt": [384, 512, [129534], "f543", ["M48 58.6l0 394.7 31.6-11.8c5.8-2.2 12.2-2 17.9 .4l45.8 19.6 38-19c6.8-3.4 14.7-3.4 21.5 0l38 19 45.8-19.6c5.7-2.4 12.1-2.6 17.9-.4l31.6 11.8 0-394.7-31.6 11.8c-5.8 2.2-12.2 2-17.9-.4l-45.8-19.6-38 19c-6.8 3.4-14.7 3.4-21.5 0l-38-19-45.8 19.6c-5.7 2.4-12.1 2.6-17.9 .4L48 58.6zM96 160c0-13.3 10.7-24 24-24l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24zm0 96c0-13.3 10.7-24 24-24l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24zm0 96c0-13.3 10.7-24 24-24l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24z", "M32.4 1.5C25.1-1.2 16.8-.2 10.3 4.3S0 16.1 0 24L0 488c0 7.9 3.9 15.2 10.3 19.7s14.7 5.5 22.1 2.7l55-20.6 47.1 20.2c6.5 2.8 13.9 2.6 20.2-.6l37.3-18.6 37.3 18.6c6.3 3.2 13.7 3.4 20.2 .6l47.1-20.2 55 20.6c7.4 2.8 15.6 1.7 22.1-2.7S384 495.9 384 488l0-464c0-7.9-3.9-15.2-10.3-19.7s-14.7-5.5-22.1-2.7l-55 20.6-47.1-20.2C243-.8 235.6-.6 229.3 2.5L192 21.2 154.7 2.5C148.4-.6 141-.8 134.5 1.9L87.4 22.1 32.4 1.5zM48 453.4L48 58.6 79.6 70.5c5.8 2.2 12.2 2 17.9-.4l45.8-19.6 38 19c6.8 3.4 14.7 3.4 21.5 0l38-19 45.8 19.6c5.7 2.4 12.1 2.6 17.9 .4l31.6-11.8 0 394.7-31.6-11.8c-5.8-2.2-12.2-2-17.9 .4l-45.8 19.6-38-19c-6.8-3.4-14.7-3.4-21.5 0l-38 19-45.8-19.6c-5.7-2.4-12.1-2.6-17.9-.4L48 453.4zM120 136c-13.3 0-24 10.7-24 24s10.7 24 24 24l144 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-144 0zm0 192c-13.3 0-24 10.7-24 24s10.7 24 24 24l144 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-144 0zM96 256c0 13.3 10.7 24 24 24l144 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-144 0c-13.3 0-24 10.7-24 24z"]],
    "equals": [448, 512, [62764], "3d", ["", "M24 128c-13.3 0-24 10.7-24 24s10.7 24 24 24l400 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L24 128zm0 208c-13.3 0-24 10.7-24 24s10.7 24 24 24l400 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L24 336z"]],
    "diagram-lean-canvas": [576, 512, [], "e156", ["M48 96c0-8.8 7.2-16 16-16l48 0 0 192-64 0 0-176zm0 224l216 0 0 112-200 0c-8.8 0-16-7.2-16-16l0-96zM160 80l48 0 0 80-48 0 0-80zm0 128l48 0 0 64-48 0 0-64zM256 80l64 0 0 192-64 0 0-192zm56 240l216 0 0 96c0 8.8-7.2 16-16 16l-200 0 0-112zM368 80l48 0 0 80-48 0 0-80zm0 128l48 0 0 64-48 0 0-64zM464 80l48 0c8.8 0 16 7.2 16 16l0 176-64 0 0-192z", "M464 80l0 192 64 0 0-176c0-8.8-7.2-16-16-16l-48 0zm-48 0l-48 0 0 80 48 0 0-80zm-96 0l-64 0 0 192 64 0 0-192zM208 80l-48 0 0 80 48 0 0-80zm-96 0L64 80c-8.8 0-16 7.2-16 16l0 176 64 0 0-192zM48 320l0 96c0 8.8 7.2 16 16 16l200 0 0-112-216 0zM312 432l200 0c8.8 0 16-7.2 16-16l0-96-216 0 0 112zM0 96C0 60.7 28.7 32 64 32l448 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM208 272l0-64-48 0 0 64 48 0zm208-64l-48 0 0 64 48 0 0-64z"]],
    "box-arrow-up": [448, 512, [], "e827", ["M48 176l0 240c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-240-352 0zm11-48l141 0 0-64-87.1 0c-5.2 0-10 2.5-13 6.7L59 128zM143 279l64-64 1.8-1.7c9.4-7.7 23.3-7.1 32.1 1.7l64 64 1.7 1.8c7.7 9.4 7.1 23.3-1.7 32.1s-22.7 9.3-32.1 1.7l-1.8-1.7-23-23 0 86.1c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-86.1-23 23c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9zM248 64l0 64 141 0-40.9-57.3c-3-4.2-7.9-6.7-13-6.7L248 64z", "M335.1 16c20.7 0 40.1 10 52.1 26.8l48.9 68.5c7.7 10.8 11.9 23.9 11.9 37.2l0 267.5-.3 6.5c-3.1 30.1-27 54.1-57.1 57.1l-6.5 .3-320 0-6.5-.3c-30.1-3.1-54.1-27-57.1-57.1L0 416 0 148.5c0-11.7 3.2-23.1 9.2-33l2.7-4.2 48.9-68.5c10.5-14.7 26.7-24.2 44.4-26.3l7.7-.5 222.1 0zM48 416c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-240-352 0 0 240zM208.8 213.4c9.4-7.7 23.3-7.1 32.1 1.7l64 64 1.7 1.8c7.7 9.4 7.1 23.3-1.7 32.1s-22.7 9.3-32.1 1.7l-1.8-1.7-23-23 0 86.1c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-86.1-23 23c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l64-64 1.8-1.7zM112.9 64c-5.2 0-10 2.5-13 6.7l-40.9 57.3 141 0 0-64-87.1 0zM248 128l141 0-40.9-57.3c-3-4.2-7.9-6.7-13-6.7l-87.1 0 0 64z"]],
    "chevron-up": [448, 512, [], "f077", ["", "M207.5 103c9.4-9.4 24.6-9.4 33.9 0l200 200c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-183-183-183 183c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l200-200z"]],
    "virus-slash": [576, 512, [], "e075", ["M191.2 125.3c37.8 10.7 80.8-16.5 80.8-61.3 0-8.8 7.2-16 16-16s16 7.2 16 16c0 56.6 68.4 84.9 108.5 44.9 6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6c-40 40-11.7 108.4 44.9 108.4 8.8 0 16 7.2 16 16s-7.2 16-16 16c-44.9 0-72 43-61.3 80.8L191.2 125.3z", "M41-24.9c-9.4-9.4-24.6-9.4-33.9 0S-2.3-.3 7 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-86.3-86.3c9.9-23.3 5.4-51.3-13.7-70.3-9.8-9.8-2.9-26.5 11-26.5 35.3 0 64-28.7 64-64s-28.7-64-64-64c-13.8 0-20.8-16.7-11-26.5 25-25 25-65.5 0-90.5s-65.5-25-90.5 0c-9.8 9.8-26.5 2.9-26.5-11 0-35.3-28.7-64-64-64s-64 28.7-64 64c0 13.8-16.7 20.8-26.5 11-19-19-47-23.6-70.3-13.7L41-24.9zM191.2 125.3c37.8 10.7 80.8-16.5 80.8-61.3 0-8.8 7.2-16 16-16s16 7.2 16 16c0 56.6 68.4 84.9 108.5 44.9 6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6c-40 40-11.7 108.4 44.9 108.4 8.8 0 16 7.2 16 16s-7.2 16-16 16c-44.9 0-72 43-61.3 80.8L191.2 125.3zM328.2 398c-14.4 11.2-24.2 28.5-24.2 50 0 8.8-7.2 16-16 16s-16-7.2-16-16c0-56.6-68.4-84.9-108.4-44.9-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6c40-40 11.7-108.5-44.9-108.5-8.8 0-16-7.2-16-16s7.2-16 16-16c21.4 0 38.8-9.8 50-24.2l-35-35c-1.8 6.2-7.3 11.2-14.9 11.2-35.3 0-64 28.7-64 64s28.7 64 64 64c13.8 0 20.8 16.7 11 26.5-25 25-25 65.5 0 90.5s65.5 25 90.5 0c9.8-9.8 26.5-2.9 26.5 11 0 35.3 28.7 64 64 64s64-28.7 64-64c0-7.6 5.1-13.1 11.2-14.9l-35-35z"]],
    "globe-stand": [448, 512, [], "f5f6", ["M112 208a96 96 0 1 0 192 0 96 96 0 1 0 -192 0z", "M15 367c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l18.5-18.5c34.3 27.7 74.9 43.8 116.5 48.3l0 33.3-96 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l240 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-96 0 0-33.3c49.1-5.3 96.8-26.7 134.4-64.3 81.7-81.7 87.1-211 16.1-298.9L401 49c9.4-9.4 9.4-24.6 0-33.9S376.4 5.7 367 15L332.5 49.6c-9.4 9.4-9.4 24.6 0 33.9 68.7 68.7 68.7 180.2 0 248.9s-180.2 68.7-248.9 0c-9.4-9.4-24.6-9.4-33.9 0L15 367zm97-159a96 96 0 1 1 192 0 96 96 0 1 1 -192 0zm240 0a144 144 0 1 0 -288 0 144 144 0 1 0 288 0z"]],
    "ring-diamond": [384, 512, [], "e5ab", ["M140.1 73.1l31.1 56c6.8-.7 13.8-1.1 20.8-1.1s14 .4 20.8 1.1l31.1-56-16.8-25.1-70.3 0-16.8 25.1z", "M144 0c-8 0-15.5 4-20 10.7l-32 48c-5 7.5-5.4 17.1-1 25l31.8 57.2C51 168.6 0 238.4 0 320 0 426 86 512 192 512s192-86 192-192c0-81.6-51-151.4-122.8-179.1L293 83.7c4.4-7.9 4-17.5-1-25l-32-48C255.5 4 248 0 240 0L144 0zm68.8 129.1C206 128.4 199 128 192 128s-14 .4-20.8 1.1l-31.1-56 16.8-25.1 70.3 0 16.8 25.1-31.1 56zM48 320a144 144 0 1 1 288 0 144 144 0 1 1 -288 0z"]],
    "phone-rotary": [512, 512, [9742], "f8d3", ["M80 373.8c0-4.7 1.4-9.4 4-13.3l96.9-145.4c3-4.5 8-7.1 13.3-7.1l123.5 0c5.4 0 10.3 2.7 13.3 7.1L428 360.5c2.6 3.9 4 8.6 4 13.3l0 42.2c0 8.8-7.2 16-16 16L96 432c-8.8 0-16-7.2-16-16l0-42.2zM192 320a64 64 0 1 0 128 0 64 64 0 1 0 -128 0z", "M0 147.9L0 176c0 26.5 21.5 48 48 48l11.6 0 32-48-43.6 0 0-25.9C78.3 126.6 151.7 80 256 80s177.7 46.6 208 70.1l0 25.9-43.6 0 32 48 11.6 0c26.5 0 48-21.5 48-48l0-28.1c0-12.7-5-24.9-15-32.9-32.8-26.2-118-83-241-83S47.7 88.8 15 115C5 123 0 135.2 0 147.9zM80 373.8c0-4.7 1.4-9.4 4-13.3l96.9-145.4c3-4.5 8-7.1 13.3-7.1l123.5 0c5.4 0 10.3 2.7 13.3 7.1L428 360.5c2.6 3.9 4 8.6 4 13.3l0 42.2c0 8.8-7.2 16-16 16L96 432c-8.8 0-16-7.2-16-16l0-42.2zm-48 0L32 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-42.2c0-14.2-4.2-28.1-12.1-39.9L371 188.5c-11.5-17.2-30.5-27.7-51-28.5l0-28c0-11-9-20-20-20s-20 9-20 20l0 28-48 0 0-28c0-11-9-20-20-20s-20 9-20 20l0 28c-20.5 .7-39.5 11.3-51 28.5L44.1 333.9C36.2 345.7 32 359.6 32 373.8zM320 320a64 64 0 1 0 -128 0 64 64 0 1 0 128 0z"]],
    "slash": [576, 512, [], "f715", ["", "M7-25c9.4-9.4 24.6-9.4 33.9 0L569 503c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0L7 9C-2.3-.4-2.3-15.6 7-25z"]],
    "arrow-down-to-dotted-line": [384, 512, [], "e095", ["", "M0 480c0 17.7 14.3 32 32 32s32-14.3 32-32-14.3-32-32-32-32 14.3-32 32zM175 377c9.4 9.4 24.6 9.4 33.9 0L345 241c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-95 95 0-278.1c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 278.1-95-95c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9L175 377zM138.7 512c17.7 0 32-14.3 32-32s-14.3-32-32-32-32 14.3-32 32 14.3 32 32 32zm74.7-32c0 17.7 14.3 32 32 32s32-14.3 32-32-14.3-32-32-32-32 14.3-32 32zM352 512c17.7 0 32-14.3 32-32s-14.3-32-32-32-32 14.3-32 32 14.3 32 32 32z"]],
    "saxophone-fire": [640, 512, ["sax-hot"], "f8db", ["M48 340.2C48 408.6 103.4 464 171.8 464l5.5 0c37.8 0 73.8-16.6 98.3-45.4l224.5-263c10.6-12.5 26.2-19.6 42.6-19.6l47.3 0-12.3-12.3c-7.5-7.5-17.7-11.7-28.3-11.7l-35 0c-10.6 0-20.8 4.2-28.3 11.7l-20.6 20.6c-.2 .2-.4 .5-.6 .7s-.5 .4-.7 .7L417.9 192c-.3 .3-.6 .7-1 1s-.7 .7-1 1l-45.8 45.8c-.4 .4-.8 .9-1.2 1.3s-.8 .8-1.3 1.2l-112.1 112c-8.7 8.7-20.6 13.6-33 13.6l-2.4 0c-24.4 0-44.3-19.8-44.3-44.3 0-5.2 .9-10.3 2.7-15.1l19.1-52.4-137.4 0-10.6 63.9c-1.1 6.7-1.7 13.5-1.7 20.3zM144 312a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M158.4 27.6c4.3-4.9 10.6-7.1 16.7-7.1 5.7 0 11.5 2.1 15.9 6.2 15.8 14.6 31.8 34.6 44 56.5 12.1 21.8 20.9 46.5 20.9 70.5 0 2.1-.1 4.2-.1 6.3L169 160c-9.9-16.7-24.8-30.9-33.6-38.6-4.3-3.7-10.5-3.7-14.8 0-8.8 7.7-23.7 21.9-33.6 38.6L.1 160c-.1-2.1-.1-4.2-.1-6.3 0-29.9 12.8-58.7 29.4-83.6 16.7-25 38-47.2 56.7-64.1 4.6-4.1 10.5-6.1 16.3-6 11.3 .3 19 9.1 26.2 17.3 1.6 1.9 3.2 3.7 4.8 5.3l15.2 15.9 9.8-11zM452.3 89.8C468.8 73.3 491.2 64 514.5 64l35 0c23.3 0 45.7 9.3 62.2 25.8l14.6 14.6c8.7 8.7 13.7 20.6 13.7 33 0 25.8-20.9 46.6-46.6 46.6l-50.6 0c-2.3 0-4.6 1-6.1 2.8l-224.5 263c-33.7 39.5-83 62.2-134.9 62.2l-5.5 0C76.9 512 0 435.1 0 340.2 0 330.8 .8 321.3 2.3 312l9.8-59.1C4.9 248.8 0 241 0 232 0 218.7 10.7 208 24 208l224 0c13.3 0 24 10.7 24 24 0 13-10.3 23.6-23.2 24l-21.2 58.3 90.4-90.3-7-7c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l7 7 14.1-14.1-7-7c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l7 7 14.1-14.1-7-7c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l7 7 4.3-4.3zM255.6 354.2c-8.7 8.7-20.6 13.6-33 13.6l-2.4 0c-24.4 0-44.3-19.8-44.3-44.3 0-5.2 .9-10.3 2.7-15.1l19.1-52.4-137.4 0-10.6 63.9c-1.1 6.7-1.7 13.5-1.7 20.3 0 68.4 55.4 123.8 123.8 123.8l5.5 0c37.8 0 73.8-16.6 98.3-45.4l224.5-263c10.6-12.5 26.2-19.6 42.6-19.6l47.3 0-12.3-12.3c-7.5-7.5-17.7-11.7-28.3-11.7l-35 0c-10.6 0-20.8 4.2-28.3 11.7l-20.6 20.6c-.2 .2-.4 .5-.6 .7s-.5 .4-.7 .7L417.9 192c-.3 .3-.6 .7-1 1s-.7 .7-1 1l-45.8 45.8c-.4 .4-.8 .9-1.2 1.3s-.8 .8-1.3 1.2l-112.1 112zM120 288a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]],
    "window-frame-open": [448, 512, [], "e050", ["M80 64l0 176 120 0 0-192-104 0c-8.8 0-16 7.2-16 16zM248 48l0 192 120 0 0-176c0-8.8-7.2-16-16-16L248 48z", "M368 240l-120 0 0-192 104 0c8.8 0 16 7.2 16 16l0 176zm-168 0L80 240 80 64c0-8.8 7.2-16 16-16l104 0 0 192zm216 48l0-224c0-35.3-28.7-64-64-64L96 0C60.7 0 32 28.7 32 64l0 224 384 0zM24 464c-13.3 0-24 10.7-24 24s10.7 24 24 24l400 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-8 0 0-128-48 0 0 128-288 0 0-128-48 0 0 128-8 0z"]],
    "circle-d": [512, 512, [], "e104", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm112-88c0-13.3 10.7-24 24-24l72 0c61.9 0 112 50.1 112 112S317.9 368 256 368l-72 0c-13.3 0-24-10.7-24-24l0-176zm48 24l0 128 48 0c35.3 0 64-28.7 64-64s-28.7-64-64-64l-48 0z", "M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM184 144c-13.3 0-24 10.7-24 24l0 176c0 13.3 10.7 24 24 24l72 0c61.9 0 112-50.1 112-112S317.9 144 256 144l-72 0zm72 176l-48 0 0-128 48 0c35.3 0 64 28.7 64 64s-28.7 64-64 64z"]],
    "expand": [448, 512, [], "f065", ["M0 168L0 344c0-13.3 10.7-24 24-24s24 10.7 24 24l0 88 88 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l176 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l88 0 0-88c0-13.3 10.7-24 24-24s24 10.7 24 24l0-176c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-88-88 0c-13.3 0-24-10.7-24-24s10.7-24 24-24L136 32c13.3 0 24 10.7 24 24s-10.7 24-24 24l-88 0 0 88c0 13.3-10.7 24-24 24S0 181.3 0 168z", "M136 32c13.3 0 24 10.7 24 24s-10.7 24-24 24l-88 0 0 88c0 13.3-10.7 24-24 24S0 181.3 0 168L0 56C0 42.7 10.7 32 24 32l112 0zM0 344c0-13.3 10.7-24 24-24s24 10.7 24 24l0 88 88 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 480c-13.3 0-24-10.7-24-24L0 344zM424 32c13.3 0 24 10.7 24 24l0 112c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-88-88 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l112 0zM400 344c0-13.3 10.7-24 24-24s24 10.7 24 24l0 112c0 13.3-10.7 24-24 24l-112 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l88 0 0-88z"]],
    "scooter": [512, 512, [], "e7c3", ["M48 400a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm352 0a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M256 56c0-13.3 10.7-24 24-24l72 0c11.1 0 20.7 7.6 23.3 18.3l64 264c.5 2 .7 4.1 .7 6.1 40.4 4 72 38.1 72 79.6 0 44.2-35.8 80-80 80-32.8 0-61-19.7-73.3-48l-205.3 0c-12.3 28.3-40.5 48-73.3 48-44.2 0-80-35.8-80-80s35.8-80 80-80c38.7 0 71 27.5 78.4 64l195.2 0c4.8-23.5 19.9-43.3 40.4-54.4-.5-1.3-1-2.6-1.3-3.9L333.1 80 280 80c-13.3 0-24-10.7-24-24zM112 400a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm352 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"]],
    "file-mp4": [576, 512, [], "e649", ["M80 64c0-8.8 7.2-16 16-16l112 0 0 88c0 39.8 32.2 72 72 72l88 0 0 128-160 0c-35.3 0-64 28.7-64 64l0 64-48 0c-8.8 0-16-7.2-16-16L80 64z", "M208 48L96 48c-8.8 0-16 7.2-16 16l0 384c0 8.8 7.2 16 16 16l48 0 0 48-48 0c-35.3 0-64-28.7-64-64L32 64C32 28.7 60.7 0 96 0L229.5 0c17 0 33.3 6.7 45.3 18.7L397.3 141.3c12 12 18.7 28.3 18.7 45.3l0 149.5-48 0 0-128-88 0c-39.8 0-72-32.2-72-72l0-88zM348.1 160L256 67.9 256 136c0 13.3 10.7 24 24 24l68.1 0zm-123 229.7l30.9 51.4 30.9-51.4c4.6-7.7 13.8-11.4 22.5-9S324 391 324 400l0 128c0 11-9 20-20 20s-20-9-20-20l0-55.8-10.9 18.1c-3.6 6-10.1 9.7-17.1 9.7s-13.5-3.7-17.1-9.7L228 472.2 228 528c0 11-9 20-20 20s-20-9-20-20l0-128c0-9 6-16.9 14.7-19.3s17.9 1.3 22.5 9zM368 380l32 0c33.1 0 60 26.9 60 60s-26.9 60-60 60l-12 0 0 28c0 11-9 20-20 20s-20-9-20-20l0-128c0-11 9-20 20-20zm32 80c11 0 20-9 20-20s-9-20-20-20l-12 0 0 40 12 0zm81.9 18.1c-3.8-3.8-5.9-8.8-5.9-14.1l0-64c0-11 9-20 20-20s20 9 20 20l0 44 24 0 0-44c0-11 9-20 20-20s20 9 20 20l0 128c0 11-9 20-20 20s-20-9-20-20l0-44-44 0c-5.3 0-10.4-2.1-14.1-5.9z"]],
    "note-sticky": [448, 512, [62026, "sticky-note"], "f249", ["M48 96l0 320c0 8.8 7.2 16 16 16l176 0 0-88c0-39.8 32.2-72 72-72l88 0 0-176c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16z", "M240 432L64 432c-8.8 0-16-7.2-16-16L48 96c0-8.8 7.2-16 16-16l320 0c8.8 0 16 7.2 16 16l0 176-88 0c-39.8 0-72 32.2-72 72l0 88zM380.1 320L288 412.1 288 344c0-13.3 10.7-24 24-24l68.1 0zM0 416c0 35.3 28.7 64 64 64l197.5 0c17 0 33.3-6.7 45.3-18.7L429.3 338.7c12-12 18.7-28.3 18.7-45.3L448 96c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416z"]],
    "dolphin": [512, 512, [], "e168", ["M422.7 115.2C463.4 161.9 488 222.9 488 289.7 488 368.3 424.3 432 345.7 432l-1.7 0c35.3 0 64-28.7 64-64l0-8c0-35.3-28.7-64-64-64l-16 0 0 26.7c0 11.8-9.5 21.3-21.3 21.3-5.6 0-10.9-2.2-14.9-6.1L248.9 296 66.2 296c-23.3 0-42.2-18.9-42.2-42.2 0-14.8 7.8-28.6 20.5-36.2l19.4-11.7C58.8 191.6 56 176.1 56 160 56 84.9 116.9 24 192 24l30.3 0c42.7 0 83.1 10.1 118.9 28 33.2-13.2 78.6-28 114.8-28 25.4 0-11.2 58.8-33.3 91.2z", "M80 160c0 13.3 2.3 26 6.5 37.8 3.9 10.8-.4 22.8-10.2 28.7l-19.4 11.7 0 0c-5.5 3.3-8.8 9.2-8.8 15.6 0 10.1 8.2 18.2 18.2 18.2l182.7 0c6.3 0 12.3 2.5 16.8 6.8l38.3 37.5 0-20.3c0-13.3 10.7-24 24-24l16 0c48.6 0 88 39.4 88 88l0 8c0 .9 0 1.8 0 2.6 19.9-21.2 32-49.6 32-81 0-60.8-22.4-116.2-59.4-158.7-7.2-8.2-7.9-20.3-1.7-29.3 10.4-15.3 23.4-35.5 31.4-51.9-27.3 4-58.4 14.3-84.2 24.6-6.4 2.5-13.5 2.2-19.6-.8-32.5-16.3-69.2-25.5-108.1-25.5L192 48C130.1 48 80 98.1 80 160zM277.7 408l66.3 0c22.1 0 40-17.9 40-40l0-8c0-19.4-13.7-35.5-32-39.2l0 1.9c0 25-20.3 45.3-45.3 45.3-11.8 0-23.2-4.6-31.7-12.9L239.1 320 66.2 320C29.6 320 0 290.4 0 253.8 0 230.5 12.2 209 32.1 197l3.7-2.2C33.3 183.6 32 171.9 32 160 32 71.6 103.6 0 192 0l30.3 0c42.7 0 83.3 9.3 119.8 25.9 32.7-12.4 76.5-25.9 113.8-25.9 7.8 0 17.9 2.4 25.2 11.3 6.7 8.1 7.5 17.4 7.3 23.2-.4 11.3-5.2 23.4-9.7 33.1-7 15-17.1 31.8-26.4 46.2 37.3 48.8 59.5 109.8 59.5 175.9 0 91.9-74.5 166.3-166.3 166.3l-68 0c-19.9 34.5-56.8 56-97 56l-4.7 0c-5.5 0-10.7-2.9-13.6-7.6s-3.2-10.6-.7-15.6l28.4-56.8-28.4-56.8c-2.5-5-2.2-10.9 .7-15.6s8.1-7.6 13.6-7.6l4.7 0c40.2 0 77.1 21.5 97 56zM136 160a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"]],
    "border-bottom": [448, 512, [], "f84d", ["M32 96c17.7 0 32-14.3 32-32l64 0c0 17.7 14.3 32 32 32s32-14.3 32-32l64 0c0 17.7 14.3 32 32 32s32-14.3 32-32l64 0c0 17.7 14.3 32 32 32l0 64c-17.7 0-32 14.3-32 32s14.3 32 32 32l0 64c-17.7 0-32 14.3-32 32s14.3 32 32 32l0 72c0 2.8-.4 5.4-1 8L33 432c-.7-2.6-1-5.2-1-8l0-72c17.7 0 32-14.3 32-32s-14.3-32-32-32l0-64c17.7 0 32-14.3 32-32s-14.3-32-32-32l0-64z", "M448 456c0 13.3-10.7 24-24 24L24 480c-13.3 0-24-10.7-24-24s10.7-24 24-24l400 0c13.3 0 24 10.7 24 24zM384 320a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM64 320a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM384 192a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM64 192a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM384 64a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM64 64A32 32 0 1 1 0 64 32 32 0 1 1 64 64zm192 0a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm-64 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z"]],
    "user-message": [576, 512, [], "e7b1", ["M25.4 512C38 511.3 48 500.8 48 488l0-8c0-70.7 57.3-128 128-128l96 0c70.7 0 128 57.3 128 128l0 8c0 12.6 9.7 22.9 22 24-132.2 0-264.4 0-396.6 0zM144 128c0-44.2 35.8-80 80-80 18 0 34.6 6 48 16l0 80c0 14.4 3.2 28 8.8 40.3-14.5 14.6-34.6 23.7-56.8 23.7-44.2 0-80-35.8-80-80z", "M272 48C272 35.4 274.4 23.3 278.9 12.3 262.2 4.4 243.6 0 224 0 153.3 0 96 57.3 96 128s57.3 128 128 128c33.8 0 64.5-13.1 87.4-34.5-13.1-9.6-23.7-22.4-30.5-37.2-14.5 14.6-34.6 23.7-56.8 23.7-44.2 0-80-35.8-80-80s35.8-80 80-80c18 0 34.6 6 48 16l0-16zM48 480c0-70.7 57.3-128 128-128l96 0c70.7 0 128 57.3 128 128l0 8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-8c0-97.2-78.8-176-176-176l-96 0C78.8 304 0 382.8 0 480l0 8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-8zM320 48l0 96c0 26.5 21.5 48 48 48l16 0 0 41.4c0 14.3 17.2 21.4 27.3 11.3l52.7-52.7 64 0c26.5 0 48-21.5 48-48l0-96c0-26.5-21.5-48-48-48L368 0c-26.5 0-48 21.5-48 48z"]],
    "signal-weak": [512, 512, ["signal-1"], "f68c", ["", "M48 384c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-48c0-13.3 10.7-24 24-24z"]],
    "table-columns": [448, 512, ["columns"], "f0db", ["M48 160l0 256c0 8.8 7.2 16 16 16l136 0 0-272-152 0zm200 0l0 272 136 0c8.8 0 16-7.2 16-16l0-256-152 0z", "M48 416l0-256 152 0 0 272-136 0c-8.8 0-16-7.2-16-16zm200 16l0-272 152 0 0 256c0 8.8-7.2 16-16 16l-136 0zM64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32z"]],
    "person-shelter": [512, 512, [], "e54f", ["M240 274.3c5.1-1.5 10.5-2.3 16-2.3s10.9 .8 16 2.3l0 93.7-32 0 0-93.7z", "M268.1 3.3c-7.5-4.4-16.8-4.4-24.3 0l-232 136C4.5 143.6 0 151.5 0 160L0 488c0 13.3 10.7 24 24 24s24-10.7 24-24L48 173.8 256 51.8 464 173.8 464 488c0 13.3 10.7 24 24 24s24-10.7 24-24l0-328c0-8.5-4.5-16.4-11.9-20.7l-232-136zM256 208a40 40 0 1 0 0-80 40 40 0 1 0 0 80zm-16 66.3c5.1-1.5 10.5-2.3 16-2.3s10.9 .8 16 2.3l0 93.7-32 0 0-93.7zM240 416l32 0 0 72c0 13.3 10.7 24 24 24s24-10.7 24-24l0-159.7 18.9 35c6.3 11.7 20.8 16 32.5 9.8s16-20.8 9.8-32.5l-33.2-61.7C329.7 245.1 294.4 224 256 224s-73.7 21.1-91.9 54.9l-33.2 61.7c-6.3 11.7-1.9 26.2 9.8 32.5s26.2 1.9 32.5-9.8l18.9-35 0 159.7c0 13.3 10.7 24 24 24s24-10.7 24-24l0-72z"]],
    "camera-security": [448, 512, ["camera-home"], "f8fe", ["M48 64l0 288c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-288c0-8.8-7.2-16-16-16L64 48c-8.8 0-16 7.2-16 16zM336 208a112 112 0 1 1 -224 0 112 112 0 1 1 224 0z", "M384 48c8.8 0 16 7.2 16 16l0 288c0 8.8-7.2 16-16 16L64 368c-8.8 0-16-7.2-16-16L48 64c0-8.8 7.2-16 16-16l320 0zM64 0C28.7 0 0 28.7 0 64L0 352c0 35.3 28.7 64 64 64l136 0 0 48-80 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l208 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0 0-48 136 0c35.3 0 64-28.7 64-64l0-288c0-35.3-28.7-64-64-64L64 0zM336 208a112 112 0 1 0 -224 0 112 112 0 1 0 224 0zM224 144a64 64 0 1 1 0 128 64 64 0 1 1 0-128z"]],
    "circle-notch": [512, 512, [], "f1ce", ["", "M223.2 25C226.4 37.9 218.6 50.9 205.7 54.1 115.1 76.6 48 158.5 48 256 48 370.9 141.1 464 256 464s208-93.1 208-208c0-97.5-67.1-179.4-157.7-201.9-12.9-3.2-20.7-16.2-17.5-29.1S305 4.3 317.9 7.5C429.4 35.2 512 135.9 512 256 512 397.4 397.4 512 256 512S0 397.4 0 256C0 135.9 82.6 35.2 194.1 7.5 207 4.3 220 12.2 223.2 25z"]],
    "water": [512, 512, [], "f773", ["M0 135.1c0 .9 .1 1.8 .2 2.8 1.8 13.1 13.8 22.4 27 20.6 28.2-3.8 53.6-18.9 74.2-34.5 21.3-16.1 49.9-16.1 71.2 0 24.2 18.3 52.3 35.9 83.4 35.9s59.1-17.7 83.4-35.9c21.3-16.1 49.9-16.1 71.2 0 20.7 15.6 46 30.7 74.2 34.5 13.1 1.8 25.2-7.5 27-20.6 .1-1 .2-1.9 .2-2.9l0 143.4c-.1-11.7-8.9-21.9-20.8-23.5-15.9-2.1-33.2-11.3-51.7-25.2-38.4-29-90.5-29-129 0-24 18.1-40.7 26.3-54.5 26.3s-30.5-8.2-54.5-26.3c-38.4-29-90.5-29-129 0-18.5 13.9-35.8 23.1-51.7 25.2-11.9 1.6-20.6 11.7-20.8 23.3L0 135.1zm0 144c0 .9 .1 1.8 .2 2.8 1.8 13.1 13.8 22.4 27 20.6 28.2-3.8 53.6-18.9 74.2-34.5 21.3-16.1 49.9-16.1 71.2 0 24.2 18.3 52.3 35.9 83.4 35.9s59.1-17.7 83.4-35.9c21.3-16.1 49.9-16.1 71.2 0 20.7 15.6 46 30.7 74.2 34.5 13.1 1.8 25.2-7.5 27-20.6 .1-1 .2-1.9 .2-2.9l0 143.4c-.1-11.7-8.9-21.9-20.8-23.5-15.9-2.1-33.2-11.3-51.7-25.2-38.4-29-90.5-29-129 0-24 18.1-40.7 26.3-54.5 26.3s-30.5-8.2-54.5-26.3c-38.4-29-90.5-29-129 0-18.5 13.9-35.8 23.1-51.7 25.2-11.9 1.6-20.6 11.7-20.8 23.3L0 279.1z", "M410.6 124.1c20.7 15.6 46 30.7 74.2 34.5 13.1 1.8 25.2-7.5 27-20.6s-7.5-25.2-20.6-27c-15.9-2.1-33.2-11.3-51.7-25.2-38.4-29-90.5-29-129 0-24 18.1-40.7 26.3-54.5 26.3s-30.5-8.2-54.5-26.3c-38.4-29-90.5-29-129 0-18.5 13.9-35.8 23.1-51.7 25.2-13.1 1.8-22.4 13.8-20.6 27s13.8 22.4 27 20.6c28.2-3.8 53.6-18.9 74.2-34.5 21.3-16.1 49.9-16.1 71.2 0 24.2 18.3 52.3 35.9 83.4 35.9s59.1-17.7 83.4-35.9c21.3-16.1 49.9-16.1 71.2 0zm0 144c20.7 15.6 46 30.7 74.2 34.5 13.1 1.8 25.2-7.5 27-20.6s-7.5-25.2-20.6-27c-15.9-2.1-33.2-11.3-51.7-25.2-38.4-29-90.5-29-129 0-24 18.1-40.7 26.3-54.5 26.3s-30.5-8.2-54.5-26.3c-38.4-29-90.5-29-129 0-18.5 13.9-35.8 23.1-51.7 25.2-13.1 1.7-22.4 13.8-20.6 27s13.8 22.4 27 20.6c28.2-3.8 53.6-18.9 74.2-34.5 21.3-16.1 49.9-16.1 71.2 0 24.2 18.3 52.3 35.9 83.4 35.9s59.1-17.7 83.4-35.9c21.3-16.1 49.9-16.1 71.2 0zm-71.2 144c21.3-16.1 49.9-16.1 71.2 0 20.7 15.6 46 30.7 74.2 34.5 13.1 1.8 25.2-7.5 27-20.6s-7.5-25.2-20.6-27c-15.9-2.1-33.2-11.3-51.7-25.2-38.4-29-90.5-29-129 0-24 18.1-40.7 26.3-54.5 26.3s-30.5-8.2-54.5-26.3c-38.4-29-90.5-29-129 0-18.5 13.9-35.8 23.1-51.7 25.2-13.1 1.8-22.4 13.8-20.6 27s13.8 22.4 27 20.6c28.2-3.8 53.6-18.9 74.2-34.5 21.3-16.1 49.9-16.1 71.2 0 24.2 18.3 52.3 35.9 83.4 35.9s59.1-17.7 83.4-35.9z"]],
    "delete-left": [640, 512, [9003, "backspace"], "f55a", ["M54.6 256L193.9 395.3c3 3 7.1 4.7 11.3 4.7L512 400c8.8 0 16-7.2 16-16l0-256c0-8.8-7.2-16-16-16l-306.7 0c-4.2 0-8.3 1.7-11.3 4.7L54.6 256zm229.5-67.9c9.4-9.4 24.6-9.4 33.9 0l33.9 33.9 33.9-33.9c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-33.9 33.9 33.9 33.9c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-33.9-33.9-33.9 33.9c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l33.9-33.9-33.9-33.9c-9.4-9.4-9.4-24.6 0-33.9z", "M205.3 64c-17 0-33.3 6.7-45.3 18.7L9.4 233.4c-6 6-9.4 14.1-9.4 22.6s3.4 16.6 9.4 22.6L160 429.3c12 12 28.3 18.7 45.3 18.7L512 448c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L205.3 64zM528 128l0 256c0 8.8-7.2 16-16 16l-306.7 0c-4.2 0-8.3-1.7-11.3-4.7L54.6 256 193.9 116.7c3-3 7.1-4.7 11.3-4.7L512 112c8.8 0 16 7.2 16 16zM284.1 188.1c-9.4 9.4-9.4 24.6 0 33.9l33.9 33.9-33.9 33.9c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l33.9-33.9 33.9 33.9c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-33.9-33.9 33.9-33.9c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-33.9 33.9-33.9-33.9c-9.4-9.4-24.6-9.4-33.9 0z"]],
    "circle-rupee": [512, 512, [], "e714", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm80-88c0-13.3 10.7-24 24-24l48 0c39.8 0 72 32.2 72 72 0 26.9-14.7 50.3-36.5 62.6l19.3 57.8c4.2 12.6-2.6 26.2-15.2 30.4s-26.2-2.6-30.4-15.2l-21.2-63.6-12 0 0 56c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-176zm48 24l0 48 24 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-24 0zm104 48.1c0-31 25.1-56.1 56.1-56.1l39.9 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-39.9 0c-4.5 0-8.1 3.6-8.1 8.1 0 3.6 2.3 6.7 5.8 7.8L368 258.1c23.7 7.1 40 29 40 53.7 0 31-25.1 56.1-56.1 56.1L312 368c-13.3 0-24-10.7-24-24s10.7-24 24-24l39.9 0c4.5 0 8.1-3.6 8.1-8.1 0-3.6-2.3-6.7-5.8-7.8L320 293.9c-23.7-7.1-40-29-40-53.7z", "M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM152 144c-13.3 0-24 10.7-24 24l0 176c0 13.3 10.7 24 24 24s24-10.7 24-24l0-56 12 0 21.2 63.6c4.2 12.6 17.8 19.4 30.4 15.2S259 349 254.8 336.4l-19.3-57.8c21.8-12.4 36.5-35.8 36.5-62.6 0-39.8-32.2-72-72-72l-48 0zm48 96l-24 0 0-48 24 0c13.3 0 24 10.7 24 24s-10.7 24-24 24zm80 .1c0 24.8 16.3 46.6 40 53.7l34.2 10.3c3.4 1 5.8 4.2 5.8 7.8 0 4.5-3.6 8.1-8.1 8.1L312 320c-13.3 0-24 10.7-24 24s10.7 24 24 24l39.9 0c31 0 56.1-25.1 56.1-56.1 0-24.8-16.3-46.6-40-53.7l-34.2-10.3c-3.4-1-5.8-4.2-5.8-7.8 0-4.5 3.6-8.1 8.1-8.1l39.9 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-39.9 0c-31 0-56.1 25.1-56.1 56.1z"]],
    "arrow-down-to-square": [448, 512, [], "e096", ["M48 160l0 288c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-288c0-8.8-7.2-16-16-16l-136 0 0 126.1 31-31c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-72 72c-9.4 9.4-24.6 9.4-33.9 0l-72-72c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l31 31 0-126.1-136 0c-8.8 0-16 7.2-16 16z", "M248-8c0-13.3-10.7-24-24-24S200-21.3 200-8l0 278.1-31-31c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l72 72c9.4 9.4 24.6 9.4 33.9 0l72-72c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-31 31 0-278.1zM48 160c0-8.8 7.2-16 16-16l40 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L64 96C28.7 96 0 124.7 0 160L0 448c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-288c0-35.3-28.7-64-64-64l-40 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l40 0c8.8 0 16 7.2 16 16l0 288c0 8.8-7.2 16-16 16L64 464c-8.8 0-16-7.2-16-16l0-288z"]],
    "square-b": [448, 512, [], "e264", ["M48 96l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16zm96 72c0-13.3 10.7-24 24-24l68 0c37.6 0 68 30.4 68 68 0 12.7-3.5 24.7-9.6 34.8 15.6 12.5 25.6 31.6 25.6 53.2 0 37.6-30.4 68-68 68l-84 0c-13.3 0-24-10.7-24-24l0-176zm48 24l0 40 44 0c11 0 20-9 20-20s-9-20-20-20l-44 0zm0 88l0 40 60 0c11 0 20-9 20-20s-9-20-20-20l-60 0z", "M64 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm144 72c0-13.3 10.7-24 24-24l68 0c37.6 0 68 30.4 68 68 0 12.7-3.5 24.7-9.6 34.8 15.6 12.5 25.6 31.6 25.6 53.2 0 37.6-30.4 68-68 68l-84 0c-13.3 0-24-10.7-24-24l0-176zm112 44c0-11-9-20-20-20l-44 0 0 40 44 0c11 0 20-9 20-20zM192 320l60 0c11 0 20-9 20-20s-9-20-20-20l-60 0 0 40z"]],
    "broom-ball": [576, 512, ["quidditch", "quidditch-broom-ball"], "f458", ["M88.1 464l106.8 0 4.9-.1c22.9-1.1 44.8-10.2 61.8-25.6l3.5-3.4c21-21 31.4-50.2 28.7-79.5l-.7-5.9-1.5-9.8-55.4-55.4-9.8-1.5c-31.3-4.8-63 5.6-85.4 28l-10.2 10.2c-5.1 5.1-9.2 11-12.3 17.3 13.5 4.3 24.7 14.6 30.1 28.2 7.2 18.4 2.4 39.3-12.1 52.7L88.1 464zM278.8 254.8l42.3 42.3 28.1-8-62.4-62.4-8 28.1zM464 464a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M496 544a80 80 0 1 1 0-160 80 80 0 1 1 0 160zM536.8 5.4C546.3-2.3 560.2-1.8 569 7s9.3 22.7 1.7 32.1L569 41 369 241 408 280c5.1 5.1 8 12.1 8 19.4l-.4 4.5c-1.7 10.3-9.2 18.9-19.5 21.8l-55.6 15.9 .1 .6c7.1 46.4-8.2 93.5-41.4 126.7l-5.3 5c-27 24.5-62.3 38.1-98.9 38.1l-172.7 0-4.5-.5c-8.7-1.8-15.6-8.6-17.3-17.3L0 489.8c0-6.2 2.6-12.1 7.2-16.3L104 384 81.3 384c-9.6 0-17.3-7.8-17.3-17.3 0-28 10.4-55 29.1-75.7l3.9-4 10.2-10.2c31.1-31.1 74.4-46.6 118-42.6l8.7 1.1 .6 .1 15.9-55.6c3.4-11.8 14.1-19.9 26.3-19.9 7.3 0 14.2 2.9 19.4 8l39 39 200-200 1.8-1.7zM496 432a32 32 0 1 0 0 64 32 32 0 1 0 0-64zM226.5 282.8c-31.3-4.8-63 5.6-85.4 28l-10.2 10.2c-5.1 5.1-9.2 11-12.3 17.3 13.5 4.3 24.7 14.6 30.1 28.2 7.2 18.4 2.4 39.3-12.1 52.7l-48.5 44.7 106.8 0 4.9-.1c22.9-1.1 44.8-10.2 61.8-25.6l3.5-3.4c21-21 31.4-50.2 28.7-79.5l-.7-5.9-1.5-9.8-55.4-55.4-9.8-1.5zm52.3-28l42.3 42.3 28.1-8-62.4-62.4-8 28.1z"]],
    "h6": [512, 512, [], "e413", ["", "M24 64c13.3 0 24 10.7 24 24l0 144 128 0 0-144c0-13.3 10.7-24 24-24s24 10.7 24 24l0 336c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-144-128 0 0 144c0 13.3-10.7 24-24 24S0 437.3 0 424L0 88C0 74.7 10.7 64 24 64zm360 48c-26.5 0-48 21.5-48 48l0 60.8c14.1-8.2 30.5-12.8 48-12.8l32 0c53 0 96 43 96 96l0 48c0 53-43 96-96 96l-32 0c-53 0-96-43-96-96l0-192c0-53 43-96 96-96l72 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-72 0zM336 304l0 48c0 26.5 21.5 48 48 48l32 0c26.5 0 48-21.5 48-48l0-48c0-26.5-21.5-48-48-48l-32 0c-26.5 0-48 21.5-48 48z"]],
    "j": [320, 512, [106], "4a", ["", "M296 32c13.3 0 24 10.7 24 24l0 264c0 88.4-71.6 160-160 160S0 408.4 0 320l0-40c0-13.3 10.7-24 24-24s24 10.7 24 24l0 40c0 61.9 50.1 112 112 112s112-50.1 112-112l0-264c0-13.3 10.7-24 24-24z"]],
    "shuttle-space": [576, 512, ["space-shuttle"], "f197", ["M48 80l0 48 48 0 0-48-48 0zm0 96l0 160 56 0c12.7 0 23.8-7.4 28.9-18.3 4-8.4 12.4-13.7 21.7-13.7L392 304c32.6 0 62.4-5.8 88-18.5l0-59.1c-25.6-12.6-55.4-18.5-88-18.5l-237.4 0c-9.3 0-17.7-5.3-21.7-13.7-5.2-10.9-16.2-18.3-28.9-18.3l-56 0zm0 208l0 48 48 0 0-48-48 0zM144 86.1l0 52.6c9.4 5.4 17.5 12.7 24 21.3l112 0-91.5-54.9c-14-8.4-28.9-14.7-44.5-19zm0 287.2l0 52.6c15.6-4.2 30.6-10.6 44.5-19L280 352 168 352c-6.5 8.6-14.6 15.9-24 21.3zM400 240c0-8.8 7.2-16 16-16s16 7.2 16 16l0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-32z", "M0 432L0 80C0 53.5 21.5 32 48 32l50 0c40.6 0 80.4 11 115.2 31.9L373.3 160 392 160c69.3 0 135 22.7 179.2 81.6 6.4 8.5 6.4 20.3 0 28.8-44.2 58.9-109.9 81.6-179.2 81.6l-18.7 0-160.1 96.1C178.4 469 138.6 480 98 480l-50 0c-26.5 0-48-21.5-48-48zm280-80l-112 0c-6.5 8.6-14.6 15.9-24 21.3l0 52.6c15.6-4.2 30.6-10.6 44.5-19L280 352zM96 432l0-48-48 0 0 48 48 0zM280 160l-91.5-54.9c-14-8.4-28.9-14.7-44.5-19l0 52.6c9.4 5.4 17.5 12.7 24 21.3l112 0zM48 80l0 48 48 0 0-48-48 0zm0 104l0 152 56 0c12.7 0 23.8-7.4 28.9-18.3 4-8.4 12.4-13.7 21.7-13.7L392 304c32.6 0 62.4-5.8 88-18.5l0-59.1c-25.6-12.6-55.4-18.5-88-18.5l-237.4 0c-9.3 0-17.7-5.3-21.7-13.7-5.2-10.9-16.2-18.3-28.9-18.3l-56 0 0 8zm368 40c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16z"]],
    "yin-yang": [512, 512, [9775], "f6ad", ["M48 256c0 64.2 29.1 121.6 74.8 159.8-4.5-13.8-7-28.5-7-43.8 0-77.4 62.9-140 140.2-140 50.8 0 92-41.2 92-92s-41.2-92-92-92C141.1 48 48 141.1 48 256zM288 144a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M464 256c0 114.9-93.1 208-208 208-50.9 0-92.2-41.2-92.2-92s41.3-92 92.2-92c77.3 0 140-62.7 140-140 0-15.4-2.5-30.1-7-44 45.9 38.2 75 95.7 75 160zM256 48c50.8 0 92 41.2 92 92s-41.2 92-92 92c-77.3 0-140.2 62.6-140.2 140 0 15.3 2.5 30 7 43.8-45.7-38.2-74.8-95.6-74.8-159.8 0-114.9 93.1-208 208-208zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm32-368a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM256 400a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]],
    "signal-good": [512, 512, ["signal-3"], "f68e", ["", "M280 248c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 208c0 13.3 10.7 24 24 24s24-10.7 24-24l0-208zM152 320c-13.3 0-24 10.7-24 24l0 112c0 13.3 10.7 24 24 24s24-10.7 24-24l0-112c0-13.3-10.7-24-24-24zM48 384c-13.3 0-24 10.7-24 24l0 48c0 13.3 10.7 24 24 24s24-10.7 24-24l0-48c0-13.3-10.7-24-24-24z"]],
    "image-stack": [512, 512, [], "e771", ["M48 224l0 192c0 8.8 7.2 16 16 16l384 0c8.8 0 16-7.2 16-16l0-192c0-8.8-7.2-16-16-16L64 208c-8.8 0-16 7.2-16 16zm96 48a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm10.5 114.7c-4.1-8.1-3.2-17.9 2.3-25.1l48-64c4.5-6 11.6-9.6 19.2-9.6s14.7 3.6 19.2 9.6L260 320 300.8 265.6c4.5-6 11.6-9.6 19.2-9.6s14.7 3.6 19.2 9.6l72 96c5.5 7.3 6.3 17 2.3 25.1S401.1 400 392 400l-216 0c-9.1 0-17.4-5.1-21.5-13.3z", "M96-8c0 13.3 10.7 24 24 24l272 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L120-32C106.7-32 96-21.3 96-8zM48 88c0 13.3 10.7 24 24 24l368 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L72 64C58.7 64 48 74.7 48 88zM448 208c8.8 0 16 7.2 16 16l0 192c0 8.8-7.2 16-16 16L64 432c-8.8 0-16-7.2-16-16l0-192c0-8.8 7.2-16 16-16l384 0zM64 160c-35.3 0-64 28.7-64 64L0 416c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-192c0-35.3-28.7-64-64-64L64 160zm48 144a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm208-48c-7.6 0-14.7 3.6-19.2 9.6L260 320 243.2 297.6c-4.5-6-11.6-9.6-19.2-9.6s-14.7 3.6-19.2 9.6l-48 64c-5.5 7.3-6.3 17-2.3 25.1S166.9 400 176 400l216 0c9.1 0 17.4-5.1 21.5-13.3s3.2-17.9-2.3-25.1l-72-96c-4.5-6-11.6-9.6-19.2-9.6z"]],
    "stop": [448, 512, [9209], "f04d", ["M48 96l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16z", "M384 80c8.8 0 16 7.2 16 16l0 320c0 8.8-7.2 16-16 16L64 432c-8.8 0-16-7.2-16-16L48 96c0-8.8 7.2-16 16-16l320 0zM64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32z"]],
    "trowel": [576, 512, [], "e589", ["M93.3 450.7l61.5-190 128.5 128.5-190 61.5zM404.4 110l87.9-87.9c8.2-8.2 21.4-8.2 29.6 0s8.2 21.4 0 29.6L434 139.6 404.4 110z", "M404.4 110l29.6 29.6 87.9-87.9c8.2-8.2 8.2-21.4 0-29.6s-21.4-8.2-29.6 0L404.4 110zM555.8-11.8c26.9 26.9 26.9 70.5 0 97.5l-95.4 95.4c-14.6 14.6-38.2 14.6-52.8 0l-5.4-5.4-132.3 132.3 75 75c5.9 5.9 8.3 14.5 6.4 22.6s-8 14.6-15.9 17.2l-272 88c-8.6 2.8-18 .5-24.4-5.9s-8.6-15.8-5.9-24.4l88-272c2.6-7.9 9.1-14 17.2-15.9s16.7 .5 22.6 6.4l75 75 132.3-132.3-5.4-5.4c-14.6-14.6-14.6-38.2 0-52.8l95.4-95.4c26.9-26.9 70.5-26.9 97.5 0zM93.3 450.7l190-61.5-128.5-128.5-61.5 190z"]],
    "circle-2": [512, 512, [], "e0ef", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm128 71.6c0-36.2 22.1-68.7 55.8-81.9l44.7-17.6c6.9-2.7 11.4-9.4 11.4-16.8 0-10-8.1-18-18-18l-62 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l62 0c36.5 0 66 29.6 66 66 0 27.1-16.6 51.5-41.9 61.4l-44.7 17.6c-12.9 5.1-22.1 16.3-24.6 29.6l79.3 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-104 0c-13.3 0-24-10.7-24-24l0-16.4z", "M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM208 145.3c-13.3 0-24 10.7-24 24s10.7 24 24 24l62 0c10 0 18 8.1 18 18 0 7.4-4.5 14.1-11.4 16.8l-44.7 17.6c-33.7 13.2-55.8 45.7-55.8 81.9l0 16.4c0 13.3 10.7 24 24 24l104 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-79.3 0c2.6-13.3 11.7-24.5 24.6-29.6l44.7-17.6c25.3-9.9 41.9-34.3 41.9-61.4 0-36.5-29.6-66-66-66l-62 0z"]],
    "drumstick": [512, 512, [127831], "f6d6", ["M208 176l0 96c0 17.7 14.3 32 32 32l96 0c70.7 0 128-57.3 128-128S406.7 48 336 48 208 105.3 208 176z", "M240 304c-17.7 0-32-14.3-32-32l0-96c0-70.7 57.3-128 128-128s128 57.3 128 128-57.3 128-128 128l-96 0zm-37.5 78c10.2-14.4 23.9-30 41.5-30l92 0c97.2 0 176-78.8 176-176S433.2 0 336 0 160 78.8 160 176l0 92c0 17.7-15.6 31.3-30 41.5-2.4 1.7-4.6 3.6-6.8 5.7-12 12-31.5 11.1-47.9 6.7-4.9-1.3-10-2-15.4-2-33.1 0-60 26.9-60 60s26.9 60 60 60c6.3 0 12 5.7 12 12 0 33.1 26.9 60 60 60s60-26.9 60-60c0-5.3-.7-10.5-2-15.4-4.3-16.4-5.2-35.9 6.8-47.9 2.1-2.1 4-4.4 5.7-6.7z"]],
    "square-x": [448, 512, [], "e286", ["M48 96l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16zm85.4 87.2c-8.4-10.3-6.9-25.4 3.4-33.8s25.4-6.9 33.8 3.4l53.4 65.3 53.4-65.3c8.4-10.3 23.5-11.8 33.8-3.4s11.8 23.5 3.4 33.8L255 256 314.6 328.8c8.4 10.3 6.9 25.4-3.4 33.8s-25.4 6.9-33.8-3.4l-53.4-65.3-53.4 65.3c-8.4 10.3-23.5 11.8-33.8 3.4s-11.8-23.5-3.4-33.8L193 256 133.4 183.2z", "M64 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm170.6 56.8l53.4 65.3 53.4-65.3c8.4-10.3 23.5-11.8 33.8-3.4s11.8 23.5 3.4 33.8L255 256 314.6 328.8c8.4 10.3 6.9 25.4-3.4 33.8s-25.4 6.9-33.8-3.4l-53.4-65.3-53.4 65.3c-8.4 10.3-23.5 11.8-33.8 3.4s-11.8-23.5-3.4-33.8L193 256 133.4 183.2c-8.4-10.3-6.9-25.4 3.4-33.8s25.4-6.9 33.8 3.4z"]],
    "peapod": [512, 512, [], "e31c", ["M48 416l0 48 48 0c203.2 0 368-164.8 368-368l0-48-48 0C212.8 48 48 212.8 48 416zm152-48a56 56 0 1 1 -112 0 56 56 0 1 1 112 0zM312 256a56 56 0 1 1 -112 0 56 56 0 1 1 112 0zM424 144a56 56 0 1 1 -112 0 56 56 0 1 1 112 0z", "M416 48C212.8 48 48 212.8 48 416l0 48 48 0c203.2 0 368-164.8 368-368l0-48-48 0zm0-48l48 0c26.5 0 48 21.5 48 48l0 48c0 229.8-186.2 416-416 416l-48 0c-26.5 0-48-21.5-48-48l0-48C0 186.2 186.2 0 416 0zM256 200a56 56 0 1 1 0 112 56 56 0 1 1 0-112zM88 368a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zM368 88a56 56 0 1 1 0 112 56 56 0 1 1 0-112z"]],
    "message-text": [512, 512, ["comment-alt-text"], "e1e6", ["M48 128l0 224c0 26.5 21.5 48 48 48l56 0c10.4 0 19.3 6.6 22.6 15.9 .9 2.5 1.4 5.2 1.4 8.1l0 49.7c32.7-23.1 63.3-44.7 91.9-64.9 8.1-5.7 17.8-8.8 27.7-8.8L416 400c26.5 0 48-21.5 48-48l0-224c0-26.5-21.5-48-48-48L96 80c-26.5 0-48 21.5-48 48zm112 40c0-13.3 10.7-24 24-24l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0 0 120c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-120-48 0c-13.3 0-24-10.7-24-24z", "M203.7 512.9l0 0 91.9-64.9 120.4 0c53 0 96-43 96-96l0-224c0-53-43-96-96-96L96 32C43 32 0 75 0 128L0 352c0 53 43 96 96 96l32 0 0 72c0 9 5 17.2 13 21.3s17.6 3.5 24.9-1.7l37.8-26.7zM295.6 400c-9.9 0-19.6 3.1-27.7 8.8-28.6 20.2-59.3 41.8-91.9 64.9l0-49.7c0-2.8-.5-5.6-1.4-8.1-3.3-9.3-12.2-15.9-22.6-15.9l-56 0c-26.5 0-48-21.5-48-48l0-224c0-26.5 21.5-48 48-48l320 0c26.5 0 48 21.5 48 48l0 224c0 26.5-21.5 48-48 48l-120.4 0zM184 144c-13.3 0-24 10.7-24 24s10.7 24 24 24l48 0 0 120c0 13.3 10.7 24 24 24s24-10.7 24-24l0-120 48 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-144 0z"]],
    "hand-back-fist": [384, 512, ["hand-rock"], "f255", ["M48 204c0-16.1 11.9-29.5 27.4-31.7 11.8-1.7 20.6-11.8 20.6-23.8L96 72c0-13.3 10.7-24 24-24 7.2 0 13.6 3.1 18 8.1 4.6 5.2 11.1 8.1 18 8.1s13.4-3 18-8.1c4.4-5 10.8-8.1 18-8.1 8.5 0 15.9 4.4 20.2 11.1 6.9 10.7 20.9 14.2 32 8 3.5-1.9 7.4-3.1 11.8-3.1 10.6 0 19.7 6.9 22.8 16.6 3.8 11.7 15.9 18.7 28 16 1.7-.4 3.4-.6 5.2-.6 13.3 0 24 10.7 24 24l0 92.2c0 14.4-3.5 28.5-10.2 41.2l-52.2 98.6-135.8 0-79.5-88.3C51.7 256.3 48 246.8 48 236.9L48 204z", "M96 400c-17.7 0-32 14.3-32 32l0 48c0 17.7 14.3 32 32 32l224 0c17.7 0 32-14.3 32-32l0-48c0-17.7-14.3-32-32-32L96 400zM73.2 352l64.6 0-79.5-88.3C51.7 256.3 48 246.8 48 236.9L48 204c0-16.1 11.9-29.5 27.4-31.7 11.8-1.7 20.6-11.8 20.6-23.8L96 72c0-13.3 10.7-24 24-24 7.2 0 13.6 3.1 18 8.1 4.6 5.2 11.1 8.1 18 8.1s13.4-3 18-8.1c4.4-5 10.8-8.1 18-8.1 8.5 0 15.9 4.4 20.2 11.1 6.9 10.7 20.9 14.2 32 8 3.5-1.9 7.4-3.1 11.8-3.1 10.6 0 19.7 6.9 22.8 16.6 3.8 11.7 15.9 18.7 28 16 1.7-.4 3.4-.6 5.2-.6 13.3 0 24 10.7 24 24l0 92.2c0 14.4-3.5 28.5-10.2 41.2l-52.2 98.6 54.3 0 40.3-76.2c10.4-19.6 15.8-41.5 15.8-63.6l0-92.2c0-38.4-30.1-69.8-68.1-71.9-12.9-19.3-34.9-32.1-59.9-32.1-5.7 0-11.2 .7-16.5 1.9-12.7-11.1-29.3-17.9-47.5-17.9-13.1 0-25.4 3.5-36 9.6-10.6-6.1-22.9-9.6-36-9.6-39.8 0-72 32.2-72 72l0 58.7C19.7 143 0 171.2 0 204l0 32.9c0 21.7 8 42.7 22.6 58.9L73.2 352z"]],
    "snowman-head": [448, 512, ["frosty-head"], "f79b", ["M64 352c0-43.6 17.4-83.1 45.7-112l228.5 0c28.3 28.9 45.7 68.4 45.7 112 0 43.1-17 82.1-44.7 110.9-.1 .1-.3 .2-.8 .4-.9 .4-2.5 .7-4.8 .7l-219.6 0c-2.2 0-3.8-.4-4.8-.7-.4-.2-.7-.3-.8-.4-27.7-28.8-44.7-67.8-44.7-110.9zm64-40a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm64 72.2c0 5.1 1.2 10.2 3.5 14.7l23.8 46.3c.9 1.7 2.7 2.8 4.7 2.8s3.8-1.1 4.7-2.8l23.8-46.3c2.3-4.5 3.5-9.6 3.5-14.7 0-17.7-14.3-32.2-32-32.2s-32 14.5-32 32.2zM272 312a24 24 0 1 0 48 0 24 24 0 1 0 -48 0z", "M336 144l0 48-224 0 0-48 224 0zM64 64l0 128-40 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l24.7 0C28 272.3 16 310.8 16 352 16 408 38.1 458.9 74.2 496.3 84.5 507 99.3 512 114.2 512l219.6 0c15 0 29.7-5 40.1-15.7 36-37.4 58.2-88.2 58.2-144.3 0-41.2-12-79.7-32.7-112l24.7 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-40 0 0-128c0-35.3-28.7-64-64-64L128 0C92.7 0 64 28.7 64 64zm0 288c0-43.6 17.4-83.1 45.7-112l228.5 0c28.3 28.9 45.7 68.4 45.7 112 0 43.1-17 82.1-44.7 110.9-.1 .1-.3 .2-.8 .4-.9 .4-2.5 .7-4.8 .7l-219.6 0c-2.2 0-3.8-.4-4.8-.7-.4-.2-.7-.3-.8-.4-27.7-28.8-44.7-67.8-44.7-110.9zm88-16a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm168-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM219.3 445.2c.9 1.7 2.7 2.8 4.7 2.8s3.8-1.1 4.7-2.8l23.8-46.3c2.3-4.5 3.5-9.6 3.5-14.7 0-17.7-14.3-32.2-32-32.2s-32 14.5-32 32.2c0 5.1 1.2 10.2 3.5 14.7l23.8 46.3z"]],
    "blanket": [448, 512, [], "f498", ["M48 120c0-22.1 17.9-40 40-40l272 0c22.1 0 40 17.9 40 40l0 124.1c-7.5-2.7-15.6-4.1-24-4.1l-256 0c-27 0-51.9 8.9-72 24l0-144z", "M48 120c0-22.1 17.9-40 40-40l272 0c22.1 0 40 17.9 40 40l0 124.1c-7.5-2.7-15.6-4.1-24-4.1l-256 0c-27 0-51.9 8.9-72 24l0-144zM.3 368C4.4 430.5 56.4 480 120 480l304 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-304 0c-39.8 0-72-32.2-72-72s32.2-72 72-72l256 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-256 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l256 0c39.8 0 72-32.2 72-72l0-192c0-48.6-39.4-88-88-88L88 32C39.4 32 0 71.4 0 120l0 248 .3 0z"]],
    "comment-xmark": [512, 512, ["comment-times"], "f4b5", ["M48 240c0 42.8 15.1 82.4 41.2 114.7 12.2 15.1 14.1 36.1 4.8 53.2l-18 33.1 58.5-25.1c11.8-5.1 25.2-5.2 37.1-.3 25.7 10.5 54.2 16.4 84.3 16.4 117.8 0 208-88.8 208-192S373.8 48 256 48 48 136.8 48 240zm140.1-67.9c9.4-9.4 24.6-9.4 33.9 0l33.9 33.9 33.9-33.9c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-33.9 33.9 33.9 33.9c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-33.9-33.9-33.9 33.9c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l33.9-33.9-33.9-33.9c-9.4-9.4-9.4-24.6 0-33.9z", "M0 240c0 54.4 19.3 104.6 51.9 144.9L3.1 474.3c-2 3.7-3.1 7.9-3.1 12.2 0 14.1 11.4 25.5 25.5 25.5 4 0 7.8-.6 11.5-2.1L153.4 460c31.4 12.9 66.1 20 102.6 20 141.4 0 256-107.5 256-240S397.4 0 256 0 0 107.5 0 240zM94 407.9c9.3-17.1 7.4-38.1-4.8-53.2-26.1-32.3-41.2-71.9-41.2-114.7 0-103.2 90.2-192 208-192s208 88.8 208 192-90.2 192-208 192c-30.2 0-58.7-5.9-84.3-16.4-11.9-4.9-25.3-4.8-37.1 .3L76 440.9 94 407.9zM323.9 172.1c-9.4-9.4-24.6-9.4-33.9 0l-33.9 33.9-33.9-33.9c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l33.9 33.9-33.9 33.9c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l33.9-33.9 33.9 33.9c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-33.9-33.9 33.9-33.9c9.4-9.4 9.4-24.6 0-33.9z"]],
    "person-dolly-empty": [512, 512, [], "f4d1", ["M48 176l0 95.4c0 10.6 4.2 20.8 11.7 28.3L80 320 80 176c0-8.8-7.2-16-16-16s-16 7.2-16 16z", "M120 24A56 56 0 1 0 8 24 56 56 0 1 0 120 24zM64.4 112C28.8 112 0 140.8 0 176.4L0 272c0 27.7 13 53.8 35.2 70.4L112 400c10.1 7.6 16 19.4 16 32l0 88c0 13.3 10.7 24 24 24s24-10.7 24-24l0-88c0-27.7-13-53.8-35.2-70.4l-12.8-9.6 0-97.9c16.5 21.2 42.1 33.9 69.4 33.9l58.6 0 0 162.7c-18.6 6.6-32 24.4-32 45.3 0 26.5 21.5 48 48 48 20.9 0 38.7-13.4 45.3-32L488 512c13.3 0 24-10.7 24-24s-10.7-24-24-24l-184 0 0-280c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 56-58.6 0c-14.5 0-27.8-7.8-34.9-20.4l-42.1-74.8C109.1 124.5 87.6 112 64.4 112zM0 520c0 13.3 10.7 24 24 24s24-10.7 24-24l0-111-37-29.6c-3.9-3.1-7.6-6.4-11-9.9L0 520zM80 176l0 144-20.3-20.3C52.2 292.2 48 282 48 271.4L48 176c0-8.8 7.2-16 16-16s16 7.2 16 16z"]],
    "signal-slash": [576, 512, [], "f695", ["", "M41-24.9c-9.4-9.4-24.6-9.4-33.9 0S-2.3-.3 7 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-49-49 0-398.2c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 350.2-56-56 0-198.2c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 150.2-327-327zM312 381.8l-48-48 0 122.2c0 13.3 10.7 24 24 24s24-10.7 24-24l0-74.2zM184 320c-13.3 0-24 10.7-24 24l0 112c0 13.3 10.7 24 24 24s24-10.7 24-24l0-112c0-13.3-10.7-24-24-24zM80 384c-13.3 0-24 10.7-24 24l0 48c0 13.3 10.7 24 24 24s24-10.7 24-24l0-48c0-13.3-10.7-24-24-24z"]],
    "hexagon-plus": [576, 512, ["plus-hexagon"], "f300", ["M75.2 244.1c-4.2 7.4-4.2 16.5 0 23.8L171.4 436c4.3 7.5 12.2 12.1 20.8 12.1l191.6 0c8.6 0 16.6-4.6 20.8-12.1L500.8 268c4.2-7.4 4.2-16.5 0-23.8L404.7 76.1C400.4 68.6 392.4 64 383.8 64L192.2 64c-8.6 0-16.6 4.6-20.8 12.1L75.2 244.1zM176 256c0-13.3 10.7-24 24-24l64 0 0-64c0-13.3 10.7-24 24-24s24 10.7 24 24l0 64 64 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-64 0 0 64c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-64-64 0c-13.3 0-24-10.7-24-24z", "M33.5 220.3c-12.7 22.2-12.7 49.4 0 71.5l96.2 168.1c12.8 22.4 36.7 36.2 62.5 36.2l191.6 0c25.8 0 49.7-13.8 62.5-36.2l96.2-168.1c12.7-22.2 12.7-49.4 0-71.5L446.3 52.2C433.5 29.8 409.6 16 383.8 16L192.2 16c-25.8 0-49.7 13.8-62.5 36.2L33.5 220.3zM75.2 268c-4.2-7.4-4.2-16.5 0-23.8L171.4 76.1c4.3-7.5 12.2-12.1 20.8-12.1l191.6 0c8.6 0 16.6 4.6 20.8 12.1l96.2 168.1c4.2 7.4 4.2 16.5 0 23.8L404.7 436c-4.3 7.5-12.2 12.1-20.8 12.1l-191.6 0c-8.6 0-16.6-4.6-20.8-12.1L75.2 268zM264 344c0 13.3 10.7 24 24 24s24-10.7 24-24l0-64 64 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-64 0 0-64c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 64-64 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l64 0 0 64z"]],
    "temperature-high": [512, 512, [], "f769", ["M96 368c0 53 43 96 96 96s96-43 96-96c0-25.2-9.7-48.1-25.6-65.3-4.1-4.4-6.4-10.3-6.4-16.3L256 112c0-35.3-28.7-64-64-64s-64 28.7-64 64l0 174.4c0 6.1-2.3 11.9-6.4 16.3-15.9 17.1-25.6 40-25.6 65.3zm48 0c0-17.8 9.7-33.3 24-41.6L168 112c0-13.3 10.7-24 24-24s24 10.7 24 24l0 214.4c14.3 8.3 24 23.8 24 41.6 0 26.5-21.5 48-48 48s-48-21.5-48-48z", "M128 112c0-35.3 28.7-64 64-64s64 28.7 64 64l0 174.4c0 6.1 2.3 11.9 6.4 16.3 15.9 17.1 25.6 40 25.6 65.3 0 53-43 96-96 96s-96-43-96-96c0-25.2 9.7-48.1 25.6-65.3 4.1-4.4 6.4-10.3 6.4-16.3L128 112zM192 0C130.1 0 80 50.1 80 112l0 165.5c-20 24.7-32 56.2-32 90.5 0 79.5 64.5 144 144 144s144-64.5 144-144c0-34.3-12-65.8-32-90.5L304 112C304 50.1 253.9 0 192 0zm0 416c26.5 0 48-21.5 48-48 0-17.8-9.7-33.3-24-41.6L216 112c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 214.4c-14.3 8.3-24 23.8-24 41.6 0 26.5 21.5 48 48 48zM400 80a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm112 0a80 80 0 1 0 -160 0 80 80 0 1 0 160 0z"]],
    "greater-than": [512, 512, [62769], "3e", ["", "M34.2 45.9c-5.6 12-.3 26.3 11.7 31.9l385 178.2-385 178.2c-12 5.6-17.3 19.8-11.7 31.9s19.8 17.3 31.9 11.7l432-200c8.5-3.9 13.9-12.4 13.9-21.8s-5.4-17.8-13.9-21.8l-432-200c-12-5.6-26.3-.3-31.9 11.7z"]],
    "toothbrush": [576, 512, [129701], "f635", ["M48 160c0 8.8 7.2 16 16 16l288 0c26.5 0 48-21.5 48-48 0-13.3-5.2-22.6-14.6-30.3-4.5-3.7-10.2-7-16.6-9.7-2.3 6.7-5.5 13.5-9.7 19.9-15.9 24.2-41.7 36.1-71 36.1L64 144c-8.8 0-16 7.2-16 16z", "M64 176c-8.8 0-16-7.2-16-16s7.2-16 16-16l224 0c29.4 0 55.1-11.9 71-36.1 4.3-6.5 7.4-13.2 9.7-19.9 6.4 2.7 12 6 16.6 9.7 9.5 7.7 14.6 17 14.6 30.3 0 26.5-21.5 48-48 48L64 176zM0 160c0 35.3 28.7 64 64 64l288 0c53 0 96-43 96-96 0-58.5-51.6-89.9-104-95.2-8.8-.9-15.8 6.4-16.4 15.2-1.5 25.3-8.4 48-39.6 48L64 96C28.7 96 0 124.7 0 160zM80 280c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 152-8 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l528 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-152 0 0-152c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 152-32 0 0-152c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 152-32 0 0-152c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 152-32 0 0-152c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 152-32 0 0-152z"]],
    "flute": [576, 512, [], "f8b9", ["M64 440l40 40 99-99-40-40-30.5 30.5c6.9 4.2 11.5 11.8 11.5 20.5 0 13.3-10.7 24-24 24-8.7 0-16.3-4.6-20.5-11.5L64 440zM197 307l40 40 275-275-40-40-51.5 51.5c6.9 4.2 11.5 11.8 11.5 20.5 0 13.3-10.7 24-24 24-8.7 0-16.3-4.6-20.5-11.5l-31 31c6.9 4.2 11.5 11.8 11.5 20.5 0 13.3-10.7 24-24 24-8.7 0-16.3-4.6-20.5-11.5l-31 31c6.9 4.2 11.5 11.8 11.5 20.5 0 13.3-10.7 24-24 24-8.7 0-16.3-4.6-20.5-11.5L197 307z", "M30.1 406.1l408-408c18.7-18.7 49.1-18.7 67.9 0l40 40c18.7 18.7 18.7 49.1 0 67.9l-408 408c-18.7 18.7-49.1 18.7-67.9 0l-40-40c-18.7-18.7-18.7-49.1 0-67.9zM472 32L420.5 83.5c6.9 4.2 11.5 11.8 11.5 20.5 0 13.3-10.7 24-24 24-8.7 0-16.3-4.6-20.5-11.5l-31 31c6.9 4.2 11.5 11.8 11.5 20.5 0 13.3-10.7 24-24 24-8.7 0-16.3-4.6-20.5-11.5l-31 31c6.9 4.2 11.5 11.8 11.5 20.5 0 13.3-10.7 24-24 24-8.7 0-16.3-4.6-20.5-11.5L197 307 237 347 512 72 472 32zM99.5 404.5l-35.5 35.5 40 40 99-99-40-40-30.5 30.5c6.9 4.2 11.5 11.8 11.5 20.5 0 13.3-10.7 24-24 24-8.7 0-16.3-4.6-20.5-11.5z"]],
    "lobster": [512, 512, [129438], "e421", ["M224 200l0 175.7 25.8 72.3 12.3 0 25.8-72.3 0-175.7c0-6.6-3.8-17-15.4-30.3-5.2-6-11-11.4-16.6-16-5.7 4.7-11.5 10.1-16.6 16-11.6 13.3-15.4 23.7-15.4 30.3z", "M80 8.2C80 4.6 77.5 1.3 73.9 .8 70.7 .3 67.4 0 64 0 28.7 0 0 28.7 0 64l0 64c0 35.3 28.7 64 64 64l.7 0 41.8 27.9C126.2 233 149.4 240 173.1 240l2.9 0 0 16-32.9 0c-7.5 0-14.8-1.7-21.5-5.1L87.2 233.7c-7.9-4-17.5-.7-21.5 7.2s-.7 17.5 7.2 21.5l34.5 17.2c11.1 5.6 23.4 8.4 35.8 8.4l32.9 0 0 16-53.6 0c-5.2 0-10.3-.8-15.2-2.5L69.1 288.8c-8.4-2.8-17.4 1.7-20.2 10.1s1.7 17.4 10.1 20.2l38.1 12.7c8.2 2.7 16.7 4.1 25.3 4.1l53.6 0 0 16-.9 0c-12.4 0-24.7 2.9-35.8 8.4l-18.5 9.2c-7.9 4-11.1 13.6-7.2 21.5s13.6 11.1 21.5 7.2l18.5-9.2c6.7-3.3 14-5.1 21.5-5.1l.9 0 23.8 66.6c-23.1 7.3-39.8 28.8-39.8 54.3 0 3.9 3.2 7.1 7.1 7.1l177.8 0c3.9 0 7.1-3.2 7.1-7.1 0-25.5-16.7-47-39.8-54.3l23.8-66.6 .9 0c7.4 0 14.8 1.7 21.5 5.1l18.5 9.2c7.9 4 17.5 .7 21.5-7.2s.7-17.5-7.2-21.5l-18.5-9.2c-11.1-5.6-23.4-8.4-35.8-8.4l-.9 0 0-16 53.6 0c8.6 0 17.1-1.4 25.3-4.1l38.1-12.7c8.4-2.8 12.9-11.9 10.1-20.2s-11.9-12.9-20.2-10.1l-38.1 12.7c-4.9 1.6-10 2.5-15.2 2.5l-53.6 0 0-16 32.9 0c12.4 0 24.7-2.9 35.8-8.4l34.5-17.2c7.9-4 11.1-13.6 7.2-21.5s-13.6-11.1-21.5-7.2l-34.5 17.2c-6.7 3.3-14 5.1-21.5 5.1l-32.9 0 0-16 2.9 0c23.7 0 46.9-7 66.6-20.2l41.8-27.9 .7 0c35.3 0 64-28.7 64-64l0-64c0-35.3-28.7-64-64-64-3.4 0-6.7 .3-9.9 .8-3.6 .6-6.1 3.8-6.1 7.5L432 72c0 7.7-9.8 11-14.4 4.8L397.4 49.9c-3.7-4.9-11.2-3.9-12.3 2.1-.7 3.9-1.1 7.9-1.1 11.9l0 64c0 14.9 5.1 28.6 13.6 39.4l-18.7 12.5C367 187.8 353.1 192 338.9 192l-3.4 0c-2.6-22.5-16-42.9-31.5-59.2l0-52.1c0-15.6 11.3-29 26.7-31.6l7.9-1.3c8.7-1.5 14.6-9.7 13.2-18.4s-9.7-14.6-18.4-13.2l-7.9 1.3C294.6 22.7 272 49.4 272 80.7l0 25c-3.2-2.2-6.3-4.1-9-5.8-4.3-2.6-9.7-2.6-14 0-2.8 1.6-5.8 3.6-9 5.8l0-25c0-31.3-22.6-58-53.5-63.1l-7.9-1.3c-8.7-1.5-17 4.4-18.4 13.2s4.4 17 13.2 18.4l7.9 1.3C196.7 51.7 208 65 208 80.7l0 52.1c-15.5 16.3-28.9 36.7-31.5 59.2l-3.4 0c-14.2 0-28.1-4.2-39.9-12.1l-18.7-12.5c8.5-10.9 13.6-24.6 13.6-39.4l0-64c0-4.1-.4-8.1-1.1-11.9-1.1-6-8.6-7.1-12.3-2.1L94.4 76.8C89.8 83 80 79.7 80 72L80 8.2zM262.2 448l-12.3 0-25.8-72.3 0-175.7c0-6.6 3.8-17 15.4-30.3 5.2-6 11-11.4 16.6-16 5.7 4.7 11.5 10.1 16.6 16 11.6 13.3 15.4 23.7 15.4 30.3l0 175.7-25.8 72.3z"]],
    "calendar-circle-exclamation": [576, 512, [], "e46e", ["M80 224l275.1 0c-67.8 29.6-115.1 97.3-115.1 176 0 10.9 .9 21.6 2.7 32L96 432c-8.8 0-16-7.2-16-16l0-192z", "M152 0c13.3 0 24 10.7 24 24l0 40 160 0 0-40c0-13.3 10.7-24 24-24s24 10.7 24 24l0 40 32 0c35.3 0 64 28.7 64 64l0 86c-15.3-3.9-31.4-6-48-6-27.3 0-53.3 5.7-76.9 16L80 224 80 416c0 8.8 7.2 16 16 16l146.7 0c2.8 16.8 7.8 32.9 14.8 48L96 480c-35.3 0-64-28.7-64-64l0-288c0-35.3 28.7-64 64-64l32 0 0-40c0-13.3 10.7-24 24-24zm0 112l-56 0c-8.8 0-16 7.2-16 16l0 48 352 0 0-48c0-8.8-7.2-16-16-16l-264 0zM432 256a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm0 228a20 20 0 1 0 0-40 20 20 0 1 0 0 40zm0-180c-8.8 0-16 7.2-16 16l0 80c0 8.8 7.2 16 16 16s16-7.2 16-16l0-80c0-8.8-7.2-16-16-16z"]],
    "mobile-rotate": [576, 512, [], "e813", ["M84.7 180.7c-6.2 6.2-6.2 16.4 0 22.6l255.4 255.4 2.2 2c6.2 4.8 15.3 4.4 21.1-1.3l128-128 2-2.3c3.8-5.7 3.6-13.2-.5-18.6l-2.3-2.6-255.1-255.1c-5.7-5.7-14.8-6.2-21-1.4l-2.3 2-127.4 127.4zM343 359l48-48 1.8-1.7c9.4-7.7 23.3-7.1 32.1 1.7s9.3 22.7 1.7 32.1l-1.7 1.8-48 48c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9z", "M52.7 339.3c6.2-6.2 16.4-6.2 22.6 0l48 48c3 3 4.7 7.1 4.7 11.3l0 1.4c0 8.8-7.2 16-16 16l-23.5 0c4 36 34.5 64 71.5 64 18.3 0 35-6.9 47.8-18.2l34.1 34c-21.4 20-50.2 32.2-81.8 32.2-63.6 0-115.6-49.5-119.7-112L16 416c-8.8 0-16-7.2-16-16l0-1.4c0-4.2 1.7-8.3 4.7-11.3l48-48zm130.9-325c25.1-20.5 62.2-19 85.7 4.4l256 256 4.4 4.8c20.5 25.1 19 62.2-4.4 85.7l-128 128-4.6 4.1c-21.9 18.1-53 19.4-76.2 3.9l-4.8-3.6-4.8-4.4-256-256c-23.4-23.4-24.9-60.5-4.4-85.7l4.4-4.8 128-128 4.8-4.4zm51.7 38.3c-5.7-5.7-14.8-6.2-21-1.4l-2.3 2-127.4 127.4c-6.2 6.2-6.2 16.4 0 22.6l255.4 255.4 2.2 2c6.2 4.8 15.3 4.4 21.1-1.3l128-128 2-2.3c3.8-5.7 3.6-13.2-.5-18.6l-2.3-2.6-255.1-255.1zM392.8 309.4c9.4-7.7 23.3-7.1 32.1 1.7s9.3 22.7 1.7 32.1l-1.7 1.8-48 48c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l48-48 1.8-1.7zM416-16c63.6 0 115.6 49.5 119.7 112L560 96c8.8 0 16 7.2 16 16l0 1.4c0 4.2-1.7 8.3-4.7 11.3l-48 48c-6.2 6.2-16.4 6.2-22.6 0l-48-48c-3-3-4.7-7.1-4.7-11.3l0-1.4c0-8.8 7.2-16 16-16l23.5 0c-4-36-34.5-64-71.5-64-18.3 0-35 6.9-47.8 18.2l-34.1-34C355.6-3.7 384.4-16 416-16z"]],
    "crutch": [512, 512, [], "f7f7", ["", "M295.5 7c9.4-9.4 24.6-9.4 33.9 0l176 176c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-15-15-156.3 156.3C283.7 374.7 261.3 384 238 384l-59 0c-10.6 0-20.8 4.2-28.3 11.7-67.1 67.1-103.5 103.5-109.3 109.3-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l24-24 0 0 85.3-85.3c7.5-7.5 11.7-17.7 11.7-28.3l0-59c0-23.3 9.3-45.7 25.8-62.2L310.6 56 295.5 41c-9.4-9.4-9.4-24.6 0-33.9zm49 82.9l-94.1 94.1 78.1 78.1 94.1-94.1-78.1-78.1zm-128 128l-28.3 28.3c-7.5 7.5-11.7 17.7-11.7 28.3l0 59c0 .8 0 1.7 0 2.5 .8 0 1.7 0 2.5 0l59 0c10.6 0 20.8-4.2 28.3-11.7l28.3-28.3-78.1-78.1z"]],
    "command": [512, 512, [], "e142", ["", "M96 192l48 0 0 128-48 0c-53 0-96 43-96 96s43 96 96 96 96-43 96-96l0-48 128 0 0 48c0 53 43 96 96 96s96-43 96-96-43-96-96-96l-48 0 0-128 48 0c53 0 96-43 96-96s-43-96-96-96-96 43-96 96l0 48-128 0 0-48c0-53-43-96-96-96S0 43 0 96 43 192 96 192zM256 320l-64 0 0-128 128 0 0 128-64 0zM96 144c-26.5 0-48-21.5-48-48s21.5-48 48-48 48 21.5 48 48l0 48-48 0zm48 272c0 26.5-21.5 48-48 48s-48-21.5-48-48 21.5-48 48-48l48 0 0 48zM368 144l0-48c0-26.5 21.5-48 48-48s48 21.5 48 48-21.5 48-48 48l-48 0zm48 224c26.5 0 48 21.5 48 48s-21.5 48-48 48-48-21.5-48-48l0-48 48 0z"]],
    "tv-retro": [512, 512, [128250], "f401", ["M48 160l0 256c0 8.8 7.2 16 16 16l384 0c8.8 0 16-7.2 16-16l0-256c0-8.8-7.2-16-16-16L64 144c-8.8 0-16 7.2-16 16zm48 80c0-26.5 21.5-48 48-48l160 0c26.5 0 48 21.5 48 48l0 96c0 26.5-21.5 48-48 48l-160 0c-26.5 0-48-21.5-48-48l0-96zm336-8a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm0 80a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M135 7c9.4-9.4 24.6-9.4 33.9 0l87 87 87-87c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-55 55 126.1 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 160c0-35.3 28.7-64 64-64l126.1 0-55-55c-9.4-9.4-9.4-24.6 0-33.9zM64 144c-8.8 0-16 7.2-16 16l0 256c0 8.8 7.2 16 16 16l384 0c8.8 0 16-7.2 16-16l0-256c0-8.8-7.2-16-16-16L64 144zm80 48l160 0c26.5 0 48 21.5 48 48l0 96c0 26.5-21.5 48-48 48l-160 0c-26.5 0-48-21.5-48-48l0-96c0-26.5 21.5-48 48-48zm240 40a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm24 56a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]],
    "paw-claws": [576, 512, [], "f702", ["M72 211.5l.2 3.5c.5 3.7 2 7.9 4.6 12.3l3.4 4.8c3.6 4.3 7.8 7.3 11.6 8.8 5.1 2.1 7.9 1.2 8.9 .7 .8-.4 2.5-1.8 3-6.2 .6-4.5-.4-11.2-4.7-18.2-4.2-7-10-11.6-15.1-13.6-3.8-1.6-6.4-1.4-7.8-1.1l-1.1 .4c-.6 .3-1.3 .9-1.9 2.1-.3 .6-.7 1.5-.9 2.6l-.4 3.9zm72 212.4c0 4.5 3.6 8.1 8.1 8.1l3.4 0c2.2 0 4.3-.4 6.3-1.2l72.7-29.1 6.5-2.4c32.6-11.3 68.3-10.5 100.5 2.4l72.7 29.1 3.1 .9c1.1 .2 2.1 .3 3.2 .3l3.4 0c4.5 0 8.1-3.6 8.1-8.1 0-4.3-.5-8-1.3-11.2l-.9-3C384.1 287.4 308.6 272 288 272 268 272 196.5 286.4 150.6 398.6l-4.3 11.2c-1.4 3.7-2.3 8.5-2.3 14.2zM176.3 95.8l-.3 5.7 .2 4.1c.3 4.2 1.2 8.6 2.7 13.1l1.6 4.2c4 9.5 9.9 16.5 15.9 20.7 6.8 4.7 12.2 4.9 15.6 3.8 3.3-1.1 7.5-4.4 10.1-12.1 2.6-7.7 3-18.5-.9-30.2s-10.7-20.1-17.5-24.8c-5.1-3.5-9.4-4.5-12.7-4.3l-2.9 .5c-4 1.3-10.2 6.9-11.7 19.3zM354 135.4c2.6 7.7 6.7 11 10.1 12.1 3.4 1.1 8.8 .9 15.6-3.8s13.6-13.2 17.5-24.8 3.5-22.4 .9-30.2c-2.6-7.7-6.7-11-10.1-12.1-3.4-1.1-8.8-.9-15.6 3.8s-13.6 13.2-17.5 24.8-3.5 22.4-.9 30.2zM472.2 235.5c.6 4.4 2.3 5.7 3 6.2 1 .5 3.8 1.4 8.9-.7 5.1-2.1 10.8-6.6 15.1-13.6 4.2-7 5.3-13.7 4.7-18.2-.6-4.4-2.3-5.7-3-6.2-1-.5-3.8-1.4-8.9 .7-5.1 2.1-10.8 6.6-15.1 13.6-4.2 7-5.3 13.7-4.7 18.2z", "M288 224c41.2 0 134.3 28.4 186.7 169 3.7 9.9 5.3 20.4 5.3 31l-.3 5.7C477 456 456 477 429.7 479.7l-5.7 .3-3.4 0-6.2-.3c-4.1-.4-8.2-1.2-12.1-2.3l-5.8-2-72.7-29.1c-22.9-9.2-48.4-9.2-71.3 0l-72.7 29.1-5.8 2c-4 1.2-8 2-12.1 2.3l-6.2 .3-3.4 0-5.7-.3C120 477 99 456 96.3 429.7l-.3-5.7c0-7.9 .9-15.8 2.9-23.4l2.4-7.5C153.7 252.4 246.8 224 288 224zm0 48c-20 0-91.5 14.4-137.4 126.6l-4.3 11.2c-1.4 3.7-2.3 8.5-2.3 14.2 0 4.5 3.6 8.1 8.1 8.1l3.4 0c2.2 0 4.3-.4 6.3-1.2l72.7-29.1 6.5-2.4c32.6-11.3 68.3-10.5 100.5 2.4l72.7 29.1 3.1 .9c1.1 .2 2.1 .3 3.2 .3l3.4 0c4.5 0 8.1-3.6 8.1-8.1 0-4.3-.5-8-1.3-11.2l-.9-3C384.1 287.4 308.6 272 288 272zM48 112c13.3 0 24 10.7 24 24l0 18.7c10.5-1.1 21 .7 30.2 4.5 15.2 6.2 28.8 18 38 33.3 9.2 15.3 13.3 32.7 11.2 49.1-2.1 16.5-10.7 33-27.5 42.2-16.5 9.1-35 7.9-50.2 1.7-13.3-5.4-25.4-15.1-34.3-27.7l-3.7-5.6C29 241 25.1 228.8 24.2 216.7l-.2-5.2 0-75.5c0-13.3 10.7-24 24-24zm480 0c13.3 0 24 10.7 24 24l0 72c0 .3 0 .7-.1 1 .5 14.6-3.6 29.7-11.7 43.2-9.2 15.3-22.8 27-38 33.2-15.2 6.2-33.7 7.4-50.2-1.7-16.7-9.2-25.4-25.7-27.5-42.2-2.1-16.4 2-33.8 11.3-49.1 9.2-15.3 22.8-27 38-33.3 9.2-3.8 19.7-5.6 30.2-4.5l0-18.7c0-13.3 10.7-24 24-24zM76.3 202.5l-1.1 .4c-.6 .3-1.3 .9-1.9 2.1-.3 .6-.7 1.5-.9 2.6l-.4 3.9 .2 3.5c.5 3.7 2 7.9 4.6 12.3l3.4 4.8c3.6 4.3 7.8 7.3 11.6 8.8 5.1 2.1 7.9 1.2 8.9 .7 .8-.4 2.5-1.8 3-6.2 .6-4.5-.4-11.2-4.7-18.2-4.2-7-10-11.6-15.1-13.6-3.8-1.6-6.4-1.4-7.8-1.1zm424.5 .4c-1-.5-3.8-1.4-8.9 .7-5.1 2.1-10.8 6.6-15.1 13.6-4.2 7-5.3 13.7-4.7 18.2 .6 4.4 2.3 5.7 3 6.2 1 .5 3.8 1.4 8.9-.7 5.1-2.1 10.8-6.6 15.1-13.6 4.2-7 5.3-13.7 4.7-18.2-.6-4.4-2.3-5.7-3-6.2zM152-16c13.3 0 24 10.7 24 24l0 22.1c19.9-5.4 39.6 .2 55 10.8 16.1 11.2 28.8 28.6 35.7 49.1s7.1 42.1 .8 60.7c-6.3 18.6-19.7 35.5-40.6 42.4-20.9 6.8-41.8 1.2-57.9-10-14.1-9.8-25.6-24.3-32.8-41.6l-2.8-7.5c-2.7-8.1-4.3-16.3-5-24.4l-.3-8 0-93.6c0-13.3 10.7-24 24-24zm272 0c13.3 0 24 10.7 24 24l0 93.6c0 .1 0 .3 0 .4-.1 10.5-1.8 21.4-5.3 31.9-6.9 20.5-19.6 37.9-35.7 49.1s-37 16.8-57.9 10c-20.9-6.8-34.3-23.8-40.6-42.4-6.2-18.6-6-40.1 .8-60.7S328.9 52.1 345 40.9c15.4-10.6 35.1-16.3 55-10.8l0-22.1 .1-2.5C401.4-6.6 411.6-16 424-16zM188 76.6c-4 1.3-10.2 6.9-11.7 19.3l-.3 5.7 .2 4.1c.3 4.2 1.2 8.6 2.7 13.1l1.6 4.2c4 9.5 9.9 16.5 15.9 20.7 6.8 4.7 12.2 4.9 15.6 3.8 3.3-1.1 7.5-4.4 10.1-12.1 2.6-7.7 3-18.5-.9-30.2s-10.7-20.1-17.5-24.8c-5.1-3.5-9.4-4.5-12.7-4.3l-2.9 .5zm199.9 0c-3.4-1.1-8.8-.9-15.6 3.8s-13.6 13.2-17.5 24.8-3.5 22.4-.9 30.2c2.6 7.7 6.7 11 10.1 12.1 3.4 1.1 8.8 .9 15.6-3.8s13.6-13.2 17.5-24.8 3.5-22.4 .9-30.2c-2.6-7.7-6.7-11-10.1-12.1z"]],
    "septagon": [576, 512, ["heptagon"], "e820", ["M57.5 294.9c-1.1 4.8 0 9.8 3.1 13.6L179.9 458c3 3.8 7.7 6 12.5 6l191.3 0c4.8 0 9.5-2.2 12.5-6L515.5 308.5c3-3.8 4.2-8.8 3.1-13.6L476.3 109.7c-1.5-5.2-3.8-9.6-9-12.1l-171-82.4c-2.7-1.1-5.3-2.2-8.4-2.2-3 0-5.6 1.1-8.3 2.2l-171 82.4c-5.1 2.5-7.5 6.9-9 12.1L57.5 294.9z", "M142.4 488L23 338.4c-12.5-15.7-15.5-34.8-12.3-54.2L53.3 97.7c5.6-19.3 16.9-33.8 34.6-43.4l172.4-83c9-3.7 17.9-6.3 27.8-6.3 9.9 0 18.8 2.6 27.8 6.3l172.4 83c17.7 9.6 29 24.1 34.6 43.4l42.6 186.5c3.2 19.3 .2 38.4-12.3 54.2L433.7 488c-13.4 15-29.9 23-50 24.1l-191.3 0c-20.1-1.1-36.6-9.1-50-24.1zM108.7 97.5c-5.1 2.5-7.5 6.9-9 12.1L57.5 294.9c-1.1 4.8 0 9.8 3.1 13.6L179.9 458c3 3.8 7.7 6 12.5 6l191.3 0c4.8 0 9.5-2.2 12.5-6L515.5 308.5c3-3.8 4.2-8.8 3.1-13.6L476.3 109.7c-1.5-5.2-3.8-9.6-9-12.1l-171-82.4c-2.7-1.1-5.3-2.2-8.4-2.2-3 0-5.6 1.1-8.3 2.2l-171 82.4z"]],
    "face-smile-upside-down": [512, 512, [], "e395", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm94.7-96.6c22.1-23 60-47.4 113.3-47.4s91.2 24.4 113.3 47.4c9.2 9.6 8.9 24.8-.7 33.9s-24.8 8.9-33.9-.7C319.7 177 293.6 160 256 160s-63.7 17-78.7 32.6c-9.2 9.6-24.4 9.9-33.9 .7s-9.9-24.4-.7-33.9zM208 304a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm160 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M48 256a208 208 0 1 1 416 0 208 208 0 1 1 -416 0zm464 0a256 256 0 1 0 -512 0 256 256 0 1 0 512 0zM177.3 192.6C192.3 177 218.4 160 256 160s63.7 17 78.7 32.6c9.2 9.6 24.4 9.9 33.9 .7s9.9-24.4 .7-33.9c-22.1-23-60-47.4-113.3-47.4s-91.2 24.4-113.3 47.4c-9.2 9.6-8.9 24.8 .7 33.9s24.8 8.9 33.9-.7zM208 304a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm128-32a32 32 0 1 0 0 64 32 32 0 1 0 0-64z"]],
    "glass-empty": [384, 512, [], "e191", ["", "M6.3 7.8C10.9 2.8 17.3 0 24 0L360 0c6.7 0 13.1 2.8 17.7 7.8s6.8 11.6 6.2 18.3L347.7 446.2C344.5 483.4 313.3 512 276 512L108 512c-37.4 0-68.5-28.6-71.7-65.8L.1 26.1C-.5 19.4 1.8 12.7 6.3 7.8zM50.2 48l34 394.1C85.2 454.5 95.6 464 108 464L276 464c12.5 0 22.8-9.5 23.9-21.9L333.8 48 50.2 48z"]],
    "ear": [384, 512, [128066], "f5f0", ["M48 192l0 192c0 44.2 35.8 80 80 80l9.3 0c32.7 0 62.1-19.9 74.3-50.3l20.1-50.2c9.9-24.7 27.5-42.4 44.3-54.5 36.4-26.2 60-68.9 60-117 0-79.5-64.5-144-144-144S48 112.5 48 192zm32 0c0-61.9 50.1-112 112-112s112 50.1 112 112l0 8c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-8c0-35.3-28.7-64-64-64s-64 28.7-64 64l0 16.4c36 4 64 34.5 64 71.6 0 39.8-32.2 72-72 72l-16 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l16 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-16 0c-13.3 0-24-10.7-24-24l0-40z", "M336 192c0 48.1-23.6 90.8-60 117-16.8 12.1-34.4 29.8-44.3 54.5l-20.1 50.2c-12.2 30.4-41.6 50.3-74.3 50.3l-9.3 0c-44.2 0-80-35.8-80-80l0-192c0-79.5 64.5-144 144-144s144 64.5 144 144zM276.3 381.4c5.5-13.7 15.8-24.8 27.8-33.4 48.4-34.9 80-91.7 80-156 0-106-86-192-192-192S0 86 0 192L0 384c0 70.7 57.3 128 128 128l9.3 0c52.3 0 99.4-31.9 118.8-80.5l20.1-50.2zM128 192c0-35.3 28.7-64 64-64s64 28.7 64 64l0 8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-8c0-61.9-50.1-112-112-112S80 130.1 80 192l0 40c0 13.3 10.7 24 24 24l16 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-16 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l16 0c39.8 0 72-32.2 72-72 0-37.1-28-67.6-64-71.6l0-16.4z"]],
    "street-view": [512, 512, [], "f21d", ["M192 248l0 26.7c0 2.1 .8 4.2 2.3 5.7L217 303c3.5 3.4 5.8 7.9 6.6 12.7l11.2 61.7c.7 3.8 4 6.6 7.9 6.6l26.6 0c3.9 0 7.2-2.8 7.9-6.6l11.2-61.7c.9-4.8 3.2-9.2 6.6-12.7l22.6-22.6c1.5-1.5 2.3-3.5 2.3-5.7l0-26.7c0-22.1-17.9-40-40-40l-48 0c-22.1 0-40 17.9-40 40zM232 72a24 24 0 1 0 48 0 24 24 0 1 0 -48 0z", "M232 72a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm96 0a72 72 0 1 0 -144 0 72 72 0 1 0 144 0zM144 248l0 26.7c0 14.9 5.9 29.1 16.4 39.6l17.3 17.3 9.9 54.3c4.8 26.6 28 46 55.1 46l26.6 0c27.1 0 50.3-19.4 55.1-46l9.9-54.3 17.3-17.3c10.5-10.5 16.4-24.7 16.4-39.6l0-26.7c0-48.6-39.4-88-88-88l-48 0c-48.6 0-88 39.4-88 88zm88-40l48 0c22.1 0 40 17.9 40 40l0 26.7c0 2.1-.8 4.2-2.3 5.7L295 303c-3.5 3.4-5.8 7.9-6.6 12.7l-11.2 61.7c-.7 3.8-4 6.6-7.9 6.6l-26.6 0c-3.9 0-7.2-2.8-7.9-6.6l-11.2-61.7c-.9-4.8-3.2-9.2-6.6-12.7l-22.6-22.6c-1.5-1.5-2.3-3.5-2.3-5.7l0-26.7c0-22.1 17.9-40 40-40zM133.9 344.5c-16.6 2.5-32.2 5.6-46.3 9.3-22.4 5.8-42.6 13.3-57.8 23.3-14.7 9.6-29.8 24.9-29.8 47s15.1 37.4 29.8 47C45 480.9 65.2 488.4 87.6 494.2 132.7 505.9 192.9 512 256 512s123.3-6.1 168.4-17.8c22.4-5.8 42.6-13.3 57.8-23.3 14.7-9.6 29.8-24.9 29.8-47s-15.1-37.4-29.8-47c-15.2-9.9-35.5-17.5-57.8-23.3-14.1-3.6-29.6-6.7-46.3-9.3l-5.3 47.8c14.4 2.2 27.7 4.9 39.6 8 56.6 14.6 56.6 32.9 0 47.5-39.9 10.3-95.8 16.2-156.4 16.2s-116.5-5.9-156.4-16.2c-56.6-14.6-56.6-32.9 0-47.5 11.9-3.1 25.2-5.8 39.6-8l-5.3-47.8z"]],
    "briefs": [512, 512, [], "e6d0", ["M48 128l0 16 416 0 0-16c0-8.8-7.2-16-16-16L64 112c-8.8 0-16 7.2-16 16zm0 64l0 32c0 3.4 1.3 8.2 6.9 14.6 5.9 6.6 15.1 13.2 26.1 17.8 14.8 6.3 28.8 14.2 41.6 23.6 14-24.9 21.4-53 21.4-81.7l0-6.3-96 0zM158.5 313.4c13.6 16 24.8 34 33.1 53.6 4.7 11 11.2 20.2 17.8 26.1 6.4 5.6 11.2 6.9 14.6 6.9l64 0c3.4 0 8.2-1.3 14.6-6.9 6.6-5.9 13.2-15.1 17.8-26.1 8.3-19.6 19.5-37.6 33.1-53.6-21.8-34.4-33.5-74.3-33.5-115l0-6.3-128 0 0 6.3c0 40.8-11.6 80.7-33.5 115zM368 192l0 6.3c0 28.7 7.4 56.8 21.4 81.7 12.8-9.4 26.8-17.3 41.6-23.6 11-4.7 20.2-11.2 26.1-17.8 5.6-6.4 6.9-11.2 6.9-14.6l0-32-96 0z", "M64 112c-8.8 0-16 7.2-16 16l0 16 416 0 0-16c0-8.8-7.2-16-16-16L64 112zm256 80l-128 0 0 6.3c0 40.8-11.6 80.7-33.5 115 13.6 16 24.8 34 33.1 53.6 4.7 11 11.2 20.2 17.8 26.1 6.4 5.6 11.2 6.9 14.6 6.9l64 0c3.4 0 8.2-1.3 14.6-6.9 6.6-5.9 13.2-15.1 17.8-26.1 8.3-19.6 19.5-37.6 33.1-53.6-21.8-34.4-33.5-74.3-33.5-115l0-6.3zm69.4 88c12.8-9.4 26.8-17.3 41.6-23.6 11-4.7 20.2-11.2 26.1-17.8 5.6-6.4 6.9-11.2 6.9-14.6l0-32-96 0 0 6.3c0 28.7 7.4 56.8 21.4 81.7zM48 192l0 32c0 3.4 1.3 8.2 6.9 14.6 5.9 6.6 15.1 13.2 26.1 17.8 14.8 6.3 28.8 14.2 41.6 23.6 14-24.9 21.4-53 21.4-81.7l0-6.3-96 0zM0 128C0 92.7 28.7 64 64 64l384 0c35.3 0 64 28.7 64 64l0 96c0 35.3-29.8 62.8-62.3 76.6-38.3 16.2-68.9 46.8-85.1 85.1-13.8 32.6-41.2 62.3-76.6 62.3l-64 0c-35.3 0-62.8-29.8-76.6-62.3-16.2-38.3-46.8-68.9-85.1-85.1-32.6-13.8-62.3-41.2-62.3-76.6l0-96z"]],
    "speakers": [448, 512, [], "f8e0", ["M144 32l0 352c0 8.8 7.2 16 16 16l224 0c8.8 0 16-7.2 16-16l0-352c0-8.8-7.2-16-16-16L160 16c-8.8 0-16 7.2-16 16zM368 272a96 96 0 1 1 -192 0 96 96 0 1 1 192 0zM304 80a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M160 16c-8.8 0-16 7.2-16 16l0 352c0 8.8 7.2 16 16 16l224 0c8.8 0 16-7.2 16-16l0-352c0-8.8-7.2-16-16-16L160 16zM96 32c0-35.3 28.7-64 64-64l224 0c35.3 0 64 28.7 64 64l0 352c0 35.3-28.7 64-64 64l-224 0c-35.3 0-64-28.7-64-64L96 32zM272 176a96 96 0 1 1 0 192 96 96 0 1 1 0-192zm48 96a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM240 80a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM48 88l0 392c0 8.8 7.2 16 16 16l264 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L64 544c-35.3 0-64-28.7-64-64L0 88C0 74.7 10.7 64 24 64S48 74.7 48 88z"]],
    "wave-square": [512, 512, [], "f83e", ["", "M80 88c0-13.3 10.7-24 24-24l152 0c13.3 0 24 10.7 24 24l0 312 104 0 0-152c0-13.3 10.7-24 24-24l80 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-56 0 0 152c0 13.3-10.7 24-24 24l-152 0c-13.3 0-24-10.7-24-24l0-312-104 0 0 152c0 13.3-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l56 0 0-152z"]],
    "angle-left": [256, 512, [8249], "f104", ["", "M15.5 239c-9.4 9.4-9.4 24.6 0 33.9l160 160c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-143-143 143-143c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0L15.5 239z"]],
    "turtle": [576, 512, [128034], "f726", ["M80 208l0 32 256 0 0-32c0-70.7-57.3-128-128-128S80 137.3 80 208zm32 160l0 64 32 0 0-64-32 0zm160 0l0 64 32 0 0-64-32 0z", "M336 240l0-32c0-70.7-57.3-128-128-128S80 137.3 80 208l0 32 256 0zm48-32l0 41.2c0 21.4-17.4 38.8-38.8 38.8L70.8 288C49.4 288 32 270.6 32 249.2L32 208c0-97.2 78.8-176 176-176s176 78.8 176 176zm96 80c-8.3 0-16.3-1.6-23.6-4.5-16.1 44.5-56.1 77.5-104.4 83.5l0 73c0 22.1-17.9 40-40 40l-48 0c-22.1 0-40-17.9-40-40l0-72-32 0 0 72c0 22.1-17.9 40-40 40l-48 0c-22.1 0-40-17.9-40-40l0-72-40 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l312 0c44.2 0 80-35.8 80-80l0-64c0-35.3 28.7-64 64-64 53 0 96 43 96 96l0 16c0 35.3-28.7 64-64 64l-32 0zM272 368l0 64 32 0 0-64-32 0zm-160 0l0 64 32 0 0-64-32 0zM496 224a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"]],
    "arrow-right-to-line": [512, 512, [8677, "arrow-to-right"], "f340", ["", "M512 88c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 336c0 13.3 10.7 24 24 24s24-10.7 24-24l0-336zM377 273c9.4-9.4 9.4-24.6 0-33.9L241 103c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l95 95-278.1 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l278.1 0-95 95c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0L377 273z"]],
    "pants-straight": [448, 512, [], "e6d6", ["M1.6 51C-.1 23.4 21.8 0 49.5 0 22.8 1.2 2 24.1 3.7 51l26 416c1.5 24.6 21.4 43.9 45.8 45-25.3 0-46.3-19.7-47.9-45L1.6 51zm50-3l345.8 0-3 48-49.9 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l46.9 0-20 320-122.9 0 0-280c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 280-122.9 0-20-320 46.9 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-49.9 0-3-48z", "M51.6 48l345.8 0-3 48-49.9 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l46.9 0-20 320-122.9 0 0-280c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 280-122.9 0-20-320 46.9 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-49.9 0-3-48zM397.4 0L51.6 0C23.9 0 1.9 23.4 3.7 51l26 416c1.6 25.3 22.6 45 47.9 45l293.8 0c25.3 0 46.3-19.7 47.9-45l26-416C447 23.4 425.1 0 397.4 0z"]],
    "screwdriver": [576, 512, [129691], "f54a", ["M68 416L194.1 289.9c16.6-16.6 43.5-16.6 60.1 0s16.6 43.5 0 60.1L128.1 476.1 68 416zM400.1 105.7l89.9-59.9 8.3 8.3-59.9 89.9-38.3 0 0-38.3z", "M485.2-8.7c6.3-4.2 14.8-3.4 20.2 2l45.4 45.4c5.4 5.4 6.2 13.8 2 20.2L473.6 177.8c-5.9 8.9-15.9 14.2-26.6 14.2l-60.9 0-83.2 83.2c19.7 34.5 14.8 79.3-14.7 108.8L162.1 510.1c-18.7 18.7-49.1 18.7-67.9 0L34.1 449.9c-18.7-18.7-18.7-49.1 0-67.9L160.1 256c29.5-29.5 74.2-34.4 108.8-14.7l83.2-83.2 0-60.9c0-10.7 5.3-20.7 14.2-26.6L485.2-8.7zM438.4 144l59.9-89.9-8.3-8.3-89.9 59.9 0 38.3 38.3 0zM68 416l60.1 60.1 126.1-126.1c16.6-16.6 16.6-43.5 0-60.1s-43.5-16.6-60.1 0L68 416z"]],
    "traffic-light-stop": [320, 512, [], "f63a", ["M48 32l0 352c0 61.9 50.1 112 112 112s112-50.1 112-112l0-352c0-8.8-7.2-16-16-16L64 16c-8.8 0-16 7.2-16 16zm168 80a56 56 0 1 1 -112 0 56 56 0 1 1 112 0zm0 144a56 56 0 1 1 -112 0 56 56 0 1 1 112 0zM104 400c0-30.9 25.1-56 56-56s56 25.1 56 56-25.1 56-56 56-56-25.1-56-56z", "M64 16c-8.8 0-16 7.2-16 16l0 352c0 61.9 50.1 112 112 112s112-50.1 112-112l0-352c0-8.8-7.2-16-16-16L64 16zM0 32C0-3.3 28.7-32 64-32l192 0c35.3 0 64 28.7 64 64l0 352c0 88.4-71.6 160-160 160S0 472.4 0 384L0 32zM160 344c30.9 0 56 25.1 56 56s-25.1 56-56 56-56-25.1-56-56 25.1-56 56-56zm56-88a56 56 0 1 1 -112 0 56 56 0 1 1 112 0zm-56-88a56 56 0 1 1 0-112 56 56 0 1 1 0 112zm24 88a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM160 424c13.3 0 24-10.7 24-24s-10.7-24-24-24-24 10.7-24 24 10.7 24 24 24z"]],
    "square-euro": [448, 512, [], "e732", ["M48 96l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16zm56 128c0-8.8 7.2-16 16-16l16.1 0c19.6-51.5 69.5-88 127.8-88l33 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-33 0c-31 0-58.3 15.9-74.2 40l50.3 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-63.3 0c-1 5.4-1.6 11-1.6 16.8 0 5.2 .4 10.3 1.3 15.2l63.5 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-51.2 0c15.7 24.9 43.5 41.5 75.2 41.5l33 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-33 0c-58.9 0-109.1-37.3-128.4-89.5L120 304c-8.8 0-16-7.2-16-16s7.2-16 16-16l8 0c-.6-5-.8-10.1-.8-15.2 0-5.7 .3-11.3 1-16.8l-8.2 0c-8.8 0-16-7.2-16-16z", "M64 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm263.9 24l33 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-33 0c-31 0-58.3 15.9-74.2 40l50.3 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-63.3 0c-1 5.4-1.6 11-1.6 16.8 0 5.2 .4 10.3 1.3 15.2l63.5 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-51.2 0c15.7 24.9 43.5 41.5 75.2 41.5l33 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-33 0c-58.9 0-109.1-37.3-128.4-89.5L120 304c-8.8 0-16-7.2-16-16s7.2-16 16-16l8 0c-.6-5-.8-10.1-.8-15.2 0-5.7 .3-11.3 1-16.8l-8.2 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l16.1 0c19.6-51.5 69.5-88 127.8-88z"]],
    "tractor": [576, 512, [128668], "f722", ["M50.6 328c13 .3 23.4 10.9 23.4 24s-10.4 23.7-23.4 24c2.9 13.1 8 25.4 15.1 36.4 9.4-9 24.3-8.8 33.5 .4s9.4 24.1 .4 33.5c11 7 23.3 12.2 36.4 15.1 .3-13 10.9-23.4 24-23.4s23.7 10.4 24 23.4c13.1-2.9 25.4-8 36.4-15.1-9-9.4-8.8-24.3 .4-33.5s24.1-9.4 33.5-.4c7-11 12.2-23.3 15.1-36.4-13-.3-23.4-10.9-23.4-24s10.4-23.7 23.4-24c-2.9-13.1-8-25.4-15.1-36.4-9.4 9-24.3 8.8-33.5-.4s-9.4-24.1-.4-33.5c-11-7-23.3-12.2-36.4-15.1-.3 13-10.9 23.4-24 23.4s-23.7-10.4-24-23.4c-13.1 2.9-25.4 8-36.4 15.1 9 9.4 8.8 24.3-.4 33.5s-24.1 9.4-33.5 .4c-7 11-12.2 23.3-15.1 36.4zM200 352a40 40 0 1 1 -80 0 40 40 0 1 1 80 0zm74.3-112c24.8 25.3 41.3 58.8 44.9 96l143.4 0 65.4-54.5 0-41.5-253.7 0zM440 424a40 40 0 1 0 80 0 40 40 0 1 0 -80 0z", "M244.8 32c16.9 0 32.5 8.8 41.2 23.3l82 136.7 64 0 0-72c0-13.3 10.7-24 24-24s24 10.7 24 24l0 72 48 0c26.5 0 48 21.5 48 48l0 41.5c0 14.2-6.3 27.8-17.3 36.9l-35 29.2c26.5 15.2 44.3 43.7 44.3 76.4 0 48.6-39.4 88-88 88s-88-39.4-88-88c0-14.4 3.5-28 9.6-40l-84.8 0C302 457 237.4 512 160 512 71.6 512 0 440.4 0 352 0 286.4 39.5 230 96 205.3L96 64c0-17.7 14.3-32 32-32l116.8 0zm29.4 208c24.8 25.3 41.3 58.8 44.9 96l143.4 0 65.4-54.5 0-41.5-253.7 0zM160 192l152 0-67.2-112-100.8 0 0 112 16 0zM480 384a40 40 0 1 0 0 80 40 40 0 1 0 0-80zM136 461.4c.3-13 10.9-23.4 24-23.4s23.7 10.4 24 23.4c13.1-2.9 25.4-8 36.4-15.1-9-9.4-8.8-24.3 .4-33.5s24.1-9.4 33.5-.4c7-11 12.2-23.3 15.1-36.4-13-.3-23.4-10.9-23.4-24s10.4-23.7 23.4-24c-2.9-13.1-8-25.4-15.1-36.4-9.4 9-24.3 8.8-33.5-.4s-9.4-24.1-.4-33.5c-11-7-23.3-12.2-36.4-15.1-.3 13-10.9 23.4-24 23.4s-23.7-10.4-24-23.4c-13.1 2.9-25.4 8-36.4 15.1 9 9.4 8.8 24.3-.4 33.5s-24.1 9.4-33.5 .4c-7 11-12.2 23.3-15.1 36.4 13 .3 23.4 10.9 23.4 24s-10.4 23.7-23.4 24c2.9 13.1 8 25.4 15.1 36.4 9.4-9 24.3-8.8 33.5 .4s9.4 24.1 .4 33.5c11 7 23.3 12.2 36.4 15.1zM160 312a40 40 0 1 1 0 80 40 40 0 1 1 0-80z"]],
    "bridge-circle-xmark": [576, 512, [], "e4cb", ["M48 192l416 0 0 18.7c-10.4-1.7-21.1-2.7-32-2.7-52.7 0-100.5 21.3-135.2 55.7-12.6-5-26.4-7.7-40.8-7.7-61.9 0-112 50.1-112 112l0 64-48 0 0-102.6c0-35.7-18.3-68.7-48-87.6L48 192z", "M24 32C10.7 32 0 42.7 0 56S10.7 80 24 80l16 0 0 64-16 0c-13.3 0-24 10.7-24 24l0 88c0 9.1 5.1 17.4 13.3 21.5l3.8 1.9c19 9.5 31 28.9 31 50.1L48 440c0 22.1 17.9 40 40 40l64 0c22.1 0 40-17.9 40-40l0-72c0-35.3 28.7-64 64-64 3.2 0 6.3 .2 9.3 .7 8.6-15.1 19.3-28.9 31.5-41-12.6-5-26.4-7.7-40.8-7.7-61.9 0-112 50.1-112 112l0 64-48 0 0-102.6c0-35.7-18.3-68.7-48-87.6l0-49.8 416 0 0 18.7c16.8 2.8 32.9 7.8 48 14.8l0-57.4c0-13.3-10.7-24-24-24l-16 0 0-64 16 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L24 32zM424 80l0 64-80 0 0-64 80 0zM296 80l0 64-80 0 0-64 80 0zM168 80l0 64-80 0 0-64 80 0zM432 544a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm59.3-180.7l-36.7 36.7 36.7 36.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-36.7-36.7-36.7 36.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l36.7-36.7-36.7-36.7c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l36.7 36.7 36.7-36.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6z"]],
    "vials": [512, 512, [], "f493", ["M80 240l0 176c0 26.5 21.5 48 48 48s48-21.5 48-48l0-176-96 0zm256 0l0 176c0 26.5 21.5 48 48 48s48-21.5 48-48l0-176-96 0z", "M24 0C10.7 0 0 10.7 0 24S10.7 48 24 48l8 0 0 368c0 53 43 96 96 96s96-43 96-96l0-368 64 0 0 368c0 53 43 96 96 96s96-43 96-96l0-368 8 0c13.3 0 24-10.7 24-24S501.3 0 488 0L24 0zM176 48l0 144-96 0 0-144 96 0zM80 416l0-176 96 0 0 176c0 26.5-21.5 48-48 48s-48-21.5-48-48zM432 48l0 144-96 0 0-144 96 0zM336 416l0-176 96 0 0 176c0 26.5-21.5 48-48 48s-48-21.5-48-48z"]],
    "starfighter-twin-ion-engine-advanced": [576, 512, ["starfighter-alt-advanced"], "e28e", ["M48 241.5l0 29.1 83.4 18.5c-2.2-10.7-3.4-21.7-3.4-33.1s1.2-22.4 3.4-33.1L48 241.5zM176 256a112 112 0 1 0 224 0 112 112 0 1 0 -224 0zm168 0a56 56 0 1 1 -112 0 56 56 0 1 1 112 0zm100.6-33.1c2.2 10.7 3.4 21.7 3.4 33.1s-1.2 22.4-3.4 33.1l83.4-18.5 0-29.1-83.4-18.5z", "M146.1 39.7c8.7-10 7.6-25.2-2.4-33.9s-25.2-7.6-33.9 2.4l-96.2 111C4.9 129.4 0 142.5 0 155.9L0 356.1c0 13.5 4.9 26.5 13.7 36.7l96.2 111c8.7 10 23.8 11.1 33.9 2.4s11.1-23.8 2.4-33.9L50 361.3c-1.3-1.5-2-3.3-2-5.2l0-36.4 105.8 23.5C182.4 387 231.8 416 288 416s105.6-29 134.2-72.8l105.8-23.5 0 28.9c0 1.8-.6 3.6-1.8 5L429.4 472.9c-8.4 10.3-6.8 25.4 3.5 33.8s25.4 6.8 33.8-3.5L563.5 384c8.1-10 12.5-22.5 12.5-35.3l0-200.1c0-14.1-5.3-27.7-15-38.1L465.6 7.7c-9-9.7-24.2-10.3-33.9-1.3s-10.3 24.2-1.3 33.9l95.4 102.8c1.4 1.5 2.1 3.4 2.1 5.4l0 43.7-105.8-23.5C393.6 125 344.2 96 288 96s-105.6 29-134.2 72.8L48 192.3 48 155.9c0-1.9 .7-3.8 2-5.2l96.2-111zM444.6 222.9l83.4 18.5 0 29.1-83.4 18.5c2.2-10.7 3.4-21.7 3.4-33.1s-1.2-22.4-3.4-33.1zM131.4 289.1l-83.4-18.5 0-29.1 83.4-18.5c-2.2 10.7-3.4 21.7-3.4 33.1s1.2 22.4 3.4 33.1zM288 144a112 112 0 1 1 0 224 112 112 0 1 1 0-224zm0 168a56 56 0 1 0 0-112 56 56 0 1 0 0 112z"]],
    "stethoscope": [576, 512, [129658], "f0f1", ["M448 192a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M32 48C32 21.5 53.5 0 80 0l56 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-56 0 0 128c0 61.9 50.1 112 112 112s112-50.1 112-112l0-128-56 0c-13.3 0-24-10.7-24-24S234.7 0 248 0l56 0c26.5 0 48 21.5 48 48l0 128c0 80.2-59 146.6-136 158.2l0 41.8c0 66.3 53.7 120 120 120s120-53.7 120-120l0-104c0-1.2 .1-2.4 .3-3.6-32.6-10.1-56.3-40.5-56.3-76.4 0-44.2 35.8-80 80-80s80 35.8 80 80c0 35.9-23.7 66.3-56.3 76.4 .2 1.2 .3 2.4 .3 3.6l0 104c0 92.8-75.2 168-168 168S168 468.8 168 376l0-41.8C91 322.6 32 256.2 32 176L32 48zM480 224a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]],
    "podcast": [448, 512, [], "f2ce", ["M180.6 224.5a42.9 42.9 0 1 0 85.8 0 42.9 42.9 0 1 0 -85.8 0zM264 224a40 40 0 1 1 -80 0 40 40 0 1 1 80 0zM205.5 353.7c.5 13.6 3.1 35.3 7 59 3.2 19.5 6.9 38 9.9 51.4 .5 0 1 0 1.5 0s1 0 1.5 0c3.1-13.4 6.8-32 10-51.5 3.9-23.7 6.5-45.3 7-58.8-.6-.1-1.4-.3-2.2-.4-4.3-.8-9.7-1.2-16.3-1.2s-12 .4-16.3 1.2c-.8 .1-1.5 .3-2.2 .4z", "M336 359.8c39.1-32.3 64-81.1 64-135.8 0-97.2-78.8-176-176-176S48 126.8 48 224C48 278.7 72.9 327.5 112 359.8 112.4 377.4 115.2 400.2 118.4 421.6 48 383.9 0 309.5 0 224 0 100.3 100.3 0 224 0S448 100.3 448 224c0 85.6-48 159.9-118.5 197.6 3.3-21.4 6-44.2 6.4-61.8zm-14-53.4c-8.3-12.6-19.2-21.6-30.4-27.8-2.1-1.1-4.2-2.2-6.3-3.2 11.7-13.9 18.8-31.9 18.8-51.5 0-44.2-35.8-80-80-80s-80 35.8-80 80c0 19.6 7.1 37.6 18.8 51.5-2.1 1-4.2 2-6.3 3.2-11.2 6.2-22.1 15.2-30.4 27.8-18.8-22.3-30.1-51-30.1-82.4 0-70.7 57.3-128 128-128s128 57.3 128 128c0 31.4-11.3 60.2-30.1 82.4zm-143 181.3c-8.1-29.6-21.5-103.7-21.5-138.2 0-36.5 32.4-45.5 66.6-45.5s66.6 9 66.6 45.5c0 34.3-13.4 108.3-21.4 138.2-5.3 19.8-25.5 24.3-45.1 24.3s-39.8-4.6-45.1-24.3zM225.5 464c3.1-13.4 6.8-32 10-51.5 3.9-23.7 6.5-45.3 7-58.8-.6-.1-1.4-.3-2.2-.4-4.3-.8-9.7-1.2-16.3-1.2s-12 .4-16.3 1.2c-.8 .1-1.5 .3-2.2 .4 .5 13.6 3.1 35.3 7 59 3.2 19.5 6.9 38 9.9 51.4 .5 0 1 0 1.5 0s1 0 1.5 0zM224 184a40 40 0 1 1 0 80 40 40 0 1 1 0-80z"]],
    "arrow-up-right-dots": [512, 512, [], "e4b7", ["", "M88.5 32c-13.3 0-24 10.7-24 24s10.7 24 24 24l54.1 0-135 135c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l135-135 0 54.1c0 13.3 10.7 24 24 24s24-10.7 24-24l0-112c0-13.3-10.7-24-24-24l-112 0zM404.3 70.1a38.1 38.1 0 1 0 76.2 0 38.1 38.1 0 1 0 -76.2 0zM280.2 194.2a38.1 38.1 0 1 0 76.2 0 38.1 38.1 0 1 0 -76.2 0zm162.2-38.1a38.1 38.1 0 1 0 0 76.2 38.1 38.1 0 1 0 0-76.2zM156.7 317.8a38.1 38.1 0 1 0 76.2 0 38.1 38.1 0 1 0 -76.2 0zm161.6-38.1a38.1 38.1 0 1 0 0 76.2 38.1 38.1 0 1 0 0-76.2zm86.1 38.1a38.1 38.1 0 1 0 76.2 0 38.1 38.1 0 1 0 -76.2 0zM70.6 403.8a38.1 38.1 0 1 0 0 76.2 38.1 38.1 0 1 0 0-76.2zm86.1 38.1a38.1 38.1 0 1 0 76.2 0 38.1 38.1 0 1 0 -76.2 0zm161.6-38.1a38.1 38.1 0 1 0 0 76.2 38.1 38.1 0 1 0 0-76.2zm86.1 38.1a38.1 38.1 0 1 0 76.2 0 38.1 38.1 0 1 0 -76.2 0z"]],
    "chess-queen": [512, 512, [9819], "f445", ["M78.6 193.5l88.1 158.5 179.7 0 88-158.5c-25.7 3.8-51.7-3.9-71.1-21l-4-3.7-24.6-24.6-23.2 18.6c-30.1 24.1-72.1 25.6-103.8 4.5l-6.2-4.5-23.3-18.6-24.6 24.6c-19.8 19.8-47.7 28.9-75.1 24.8zM118.2 464l276.7 0-46.6-64-183.6 0-46.6 64z", "M325.3 90.8c9.1-4.8 20.6-3.3 28.2 4.3l39.8 39.8 3.7 3.3c9.1 7.1 20.9 9.9 32.4 7.7l46.4-9.3 3.5-.4c8-.4 15.8 3.2 20.6 9.8 5.5 7.6 6.1 17.6 1.6 25.8l-112.6 202.6 51.5 70.9 1.8 2.7c4 6.6 6.2 14.2 6.2 22 0 23.3-18.9 42.1-42.1 42.1l-299.7 0c-21.8 0-39.8-16.6-41.9-37.8l-.2-4.3 .1-3.3c.6-7.7 3.4-15.1 7.9-21.4l51.5-70.9-112.5-202.6c-4.5-8.2-3.9-18.3 1.6-25.8s14.9-11.2 24.1-9.4l46.4 9.3c13.1 2.6 26.7-1.5 36.1-10.9L159.5 95 163 92.2c8.6-5.8 20.1-5.6 28.5 1.1l40 32 2.8 2.1c14.4 9.6 33.5 8.9 47.2-2.1l40-32 3.8-2.5zM164.7 400l-46.6 64 276.7 0-46.6-64-183.6 0zM311.5 162.8c-30.1 24.1-72.1 25.6-103.8 4.5l-6.2-4.5-23.3-18.6-24.6 24.6c-19.8 19.8-47.7 28.9-75.1 24.8l88.1 158.5 179.7 0 88-158.5c-25.7 3.8-51.7-3.9-71.1-21l-4-3.7-24.6-24.6-23.2 18.6zM256.5 72a40 40 0 1 1 0-80 40 40 0 1 1 0 80z"]],
    "anchor-circle-exclamation": [640, 512, [], "e4ab", ["M248 88a40 40 0 1 0 80 0 40 40 0 1 0 -80 0z", "M288 48a40 40 0 1 0 0 80 40 40 0 1 0 0-80zM200 88c0-48.6 39.4-88 88-88s88 39.4 88 88c0 40.3-27.1 74.2-64 84.7L312 345c-5.2 17.4-8 35.9-8 55 0 33.4 8.5 64.8 23.5 92.1-12.8 2.6-26 3.9-39.5 3.9-110.5 0-200-89.5-200-200l0-11.1-24.2 21.2c-10 8.7-25.1 7.7-33.9-2.3s-7.7-25.1 2.3-33.9l64-56c9-7.9 22.6-7.9 31.6 0l64 56c10 8.7 11 23.9 2.3 33.9s-23.9 11-33.9 2.3L136 284.9 136 296c0 75.8 55.5 138.6 128 150.1l0-273.4c-36.9-10.4-64-44.4-64-84.7zM496 256a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm0 228a20 20 0 1 0 0-40 20 20 0 1 0 0 40zm0-180c-8.8 0-16 7.2-16 16l0 80c0 8.8 7.2 16 16 16s16-7.2 16-16l0-80c0-8.8-7.2-16-16-16z"]],
    "ellipsis-vertical": [128, 512, ["ellipsis-v"], "f142", ["", "M112 80a48 48 0 1 1 -96 0 48 48 0 1 1 96 0zM16 256c0-26.5 21.5-48 48-48s48 21.5 48 48-21.5 48-48 48-48-21.5-48-48zm96 176c0 26.5-21.5 48-48 48s-48-21.5-48-48 21.5-48 48-48 48 21.5 48 48z"]],
    "acorn": [448, 512, [], "f6ae", ["M48 160l0 16 352 0 0-16c0-26.5-21.5-48-48-48L96 112c-26.5 0-48 21.5-48 48zm48 64l.3 12.9C99.5 303 127.7 389.5 224 428.8 326.7 386.9 352 291.3 352 224L96 224z", "M228.8 9.6c8-10.6 23-12.7 33.6-4.8 10.6 8 12.7 23 4.8 33.6l-4.8 6.4c-4.4 5.9-7.8 12.4-10.2 19.2l99.8 0 4.9 .1C407.7 66.7 448 108.6 448 160l0 32-.2 3.3c-1.5 15-13.5 27-28.6 28.6l-3.3 .2-16 0-.4 15.1c-3.8 78.1-38.6 190-165.5 237.3l-5 1.4c-3.4 .6-6.9 .6-10.3 0l-5-1.4C87 429.1 52.2 317.3 48.4 239.1l-.4-15.1-16 0-3.3-.2c-15.1-1.5-27-13.5-28.6-28.6L0 192 0 160c0-51.4 40.3-93.3 91.1-95.9L96 64 202.5 64c3.5-17.3 10.8-33.7 21.5-48l4.8-6.4zM96.3 236.9C99.5 303 127.7 389.5 224 428.8 326.7 386.9 352 291.3 352 224l-256 0 .3 12.9zM96 112c-26.5 0-48 21.5-48 48l0 16 352 0 0-16c0-26.5-21.5-48-48-48L96 112z"]],
    "ban-parking": [512, 512, ["parking-circle-slash"], "f616", ["M48 256c0 114.9 93.1 208 208 208 48.8 0 93.7-16.8 129.1-44.9l-99.2-99.2c-1.9 .1-3.9 .2-5.9 .2l-64 0 0 40c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-158.1-75.1-75.1C64.8 162.3 48 207.2 48 256zM126.9 92.9l47.7 47.7c5.8-7.7 15.1-12.6 25.5-12.6l80 0c53 0 96 43 96 96 0 32.1-15.8 60.6-40 78l83.1 83.1c28.1-35.5 44.9-80.3 44.9-129.1 0-114.9-93.1-208-208-208-48.8 0-93.7 16.8-129.1 44.9zM216 176l0 6.1 85.1 85.1c15.9-7.8 26.9-24.2 26.9-43.1 0-26.5-21.5-48-48-48l-64 0z", "M419.1 385.1L336 302c24.2-17.4 40-45.9 40-78 0-53-43-96-96-96l-80 0c-10.4 0-19.6 4.9-25.5 12.6L126.9 92.9c35.5-28.1 80.3-44.9 129.1-44.9 114.9 0 208 93.1 208 208 0 48.8-16.8 93.7-44.9 129.1zm-33.9 33.9c-35.5 28.1-80.3 44.9-129.1 44.9-114.9 0-208-93.1-208-208 0-48.8 16.8-93.7 44.9-129.1L168 201.9 168 360c0 13.3 10.7 24 24 24s24-10.7 24-24l0-40 64 0c2 0 3.9-.1 5.9-.2l99.2 99.2zM301.1 267.1l-85.1-85.1 0-6.1 64 0c26.5 0 48 21.5 48 48 0 18.9-11 35.3-26.9 43.1zM216 249.9l22.1 22.1-22.1 0 0-22.1zM256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512z"]],
    "square-dong": [448, 512, [], "e70f", ["M48 96l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16zm64 296c0-8.8 7.2-16 16-16l192 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-192 0c-8.8 0-16-7.2-16-16zm16-120c0-44.2 35.8-80 80-80 11.4 0 22.2 2.4 32 6.7l0-22.7-32 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l32 0 0-8c0-13.3 10.7-24 24-24s24 10.7 24 24l0 8 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0 0 152c0 13.3-10.7 24-24 24-7.6 0-14.4-3.6-18.8-9.1-11.1 5.8-23.7 9.1-37.2 9.1-44.2 0-80-35.8-80-80zm48 0a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M64 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm240 40c0-13.3 10.7-24 24-24s24 10.7 24 24l0 8 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0 0 152c0 13.3-10.7 24-24 24-7.6 0-14.4-3.6-18.8-9.1-11.1 5.8-23.7 9.1-37.2 9.1-44.2 0-80-35.8-80-80s35.8-80 80-80c11.4 0 22.2 2.4 32 6.7l0-22.7-32 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l32 0 0-8zM208 240a32 32 0 1 0 0 64 32 32 0 1 0 0-64zM112 392c0-8.8 7.2-16 16-16l192 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-192 0c-8.8 0-16-7.2-16-16z"]],
    "list-dropdown": [448, 512, [], "e1cf", ["M48 192l352 0 0 224c0 8.8-7.2 16-16 16L64 432c-8.8 0-16-7.2-16-16l0-224zm64 72c0 13.3 10.7 24 24 24l176 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-176 0c-13.3 0-24 10.7-24 24zm0 96c0 13.3 10.7 24 24 24l176 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-176 0c-13.3 0-24 10.7-24 24z", "M48 192l0 224c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-224-352 0zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM112 264c0-13.3 10.7-24 24-24l176 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-176 0c-13.3 0-24-10.7-24-24zm0 96c0-13.3 10.7-24 24-24l176 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-176 0c-13.3 0-24-10.7-24-24zM304 80c-6.5 0-12.3 3.9-14.8 9.9s-1.1 12.9 3.5 17.4l32 32c6.2 6.2 16.4 6.2 22.6 0l32-32c4.6-4.6 5.9-11.5 3.5-17.4S374.5 80 368 80l-64 0z"]],
    "camera-circle-ellipsis": [640, 512, [], "e766", ["M112 160c0-8.8 7.2-16 16-16l69.3 0c8 0 15.5-4 20-10.7l33.2-49.8c1.5-2.2 4-3.6 6.7-3.6l125.7 0c2.7 0 5.2 1.3 6.7 3.6l33.2 49.8c4.5 6.7 11.9 10.7 20 10.7l69.3 0c8.8 0 16 7.2 16 16l0 50.7c-10.4-1.7-21.1-2.7-32-2.7-26.7 0-52.1 5.4-75.1 15.3-18.1-37.4-56.5-63.3-100.9-63.3-61.9 0-112 50.1-112 112 0 56.7 42.1 103.5 96.7 111-.5 5.6-.7 11.3-.7 17 0 10.9 .9 21.6 2.7 32L128 432c-8.8 0-16-7.2-16-16l0-256z", "M257.1 32c-18.7 0-36.2 9.4-46.6 24.9L184.5 96 128 96c-35.3 0-64 28.7-64 64l0 256c0 35.3 28.7 64 64 64l193.4 0c-6.9-15.1-11.9-31.2-14.8-48L128 432c-8.8 0-16-7.2-16-16l0-256c0-8.8 7.2-16 16-16l69.3 0c8 0 15.5-4 20-10.7l33.2-49.8c1.5-2.2 4-3.6 6.7-3.6l125.7 0c2.7 0 5.2 1.3 6.7 3.6l33.2 49.8c4.5 6.7 11.9 10.7 20 10.7l69.3 0c8.8 0 16 7.2 16 16l0 50.7c16.8 2.8 32.9 7.8 48 14.8l0-65.4c0-35.3-28.7-64-64-64l-56.5 0-26-39.1C419.1 41.4 401.6 32 382.9 32L257.1 32zM320 160c-61.9 0-112 50.1-112 112 0 56.7 42.1 103.5 96.7 111 1.4-16.4 4.9-32.2 10.2-47.2-33-2.6-59-30.1-59-63.8 0-35.3 28.7-64 64-64 26.7 0 49.6 16.4 59.2 39.6 12.7-9.8 26.7-18 41.7-24.4-18.1-37.4-56.5-63.3-100.9-63.3zM640 400a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-164 0a20 20 0 1 1 40 0 20 20 0 1 1 -40 0zm84-20a20 20 0 1 1 0 40 20 20 0 1 1 0-40zM412 400a20 20 0 1 1 40 0 20 20 0 1 1 -40 0z"]],
    "family-dress": [512, 512, [], "e301", ["M63.7 336L92.7 234.7c4.5-15.8 19-26.7 35.4-26.7l37.5 0c3.3 9.3 7.9 17.9 13.7 25.6-31.1 23.3-51.2 60.5-51.2 102.4l-64.4 0zm160.4 0c0-17.7 14.3-32 32-32s32 14.3 32 32l0 16c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-16zM332.9 233.6c5.8-7.7 10.4-16.3 13.7-25.6l37.5 0c16.5 0 30.9 10.9 35.4 26.7l28.9 101.3-64.4 0c0-41.9-20.1-79.1-51.2-102.4z", "M128.1 0a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm32.5 166.5c-.3 3.1-.5 6.3-.5 9.5 0 11.2 1.9 22 5.5 32l-37.5 0c-16.5 0-30.9 10.9-35.4 26.7l-28.9 101.3 64.4 0 0 16c0 11.1 1.6 21.9 4.6 32l-20.6 0 0 104c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-104-21.6 0c-21.3 0-36.6-20.3-30.8-40.8L46.5 221.5c10.4-36.4 43.7-61.5 81.6-61.5 11.4 0 22.4 2.3 32.5 6.5zM384.1 208l-37.5 0c3.5-10 5.5-20.8 5.5-32 0-3.2-.2-6.4-.5-9.5 10.1-4.2 21.1-6.5 32.5-6.5 37.9 0 71.2 25.1 81.6 61.5l34.8 121.7c5.8 20.4-9.5 40.8-30.8 40.8l-21.6 0 0 104c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-104-20.6 0c3-10.1 4.6-20.9 4.6-32l0-16 64.4 0-28.9-101.3c-4.5-15.8-19-26.7-35.4-26.7zm0-208a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm-128 128a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm32 208c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 16c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-16zm48 16c0 24-13.2 44.9-32.7 55.8 .5 2.7 .7 5.4 .7 8.2l0 64c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-64c0-2.8 .2-5.5 .7-8.2-19.5-11-32.7-31.9-32.7-55.8l0-16c0-44.2 35.8-80 80-80s80 35.8 80 80l0 16z"]],
    "podium": [448, 512, [], "f680", ["M100.4 192l247.3 0-22.4 257.4c-.7 8.3-7.6 14.6-15.9 14.6l-170.6 0c-8.3 0-15.2-6.3-15.9-14.6L100.4 192z", "M182.4 72L168 72c-22.1 0-40 17.9-40 40l0 32 280 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-12.2 0-22.7 261.5c-2.9 33.1-30.6 58.5-63.8 58.5l-170.6 0c-33.2 0-60.9-25.4-63.8-58.5L52.2 192 40 192c-13.3 0-24-10.7-24-24s10.7-24 24-24l40 0 0-32c0-48.6 39.4-88 88-88l14.4 0C190.7 9.7 206.2 0 224 0l64 0c26.5 0 48 21.5 48 48s-21.5 48-48 48l-64 0c-17.8 0-33.3-9.7-41.6-24zM100.4 192l22.4 257.4c.7 8.3 7.6 14.6 15.9 14.6l170.6 0c8.3 0 15.2-6.3 15.9-14.6l22.4-257.4-247.3 0z"]],
    "robot-astromech": [512, 512, [], "e2d2", ["M60.9 464l17-38.3c1.4-3.1 2.1-6.4 2.1-9.7l0-216c0-4.4 3.6-8 8-8l24 0 0 272-51.1 0zM160 192l192 0 0 150.9-50.8 57.1-90.4 0-50.8-57.1 0-150.9zm32 48c0 8.8 7.2 16 16 16l96 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-96 0c-8.8 0-16 7.2-16 16zm0 64c0 8.8 7.2 16 16 16l96 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-96 0c-8.8 0-16 7.2-16 16zM400 192l24 0c4.4 0 8 3.6 8 8l0 216c0 3.4 .7 6.7 2.1 9.7l17 38.3-51.1 0 0-272z", "M256 0C185.3 0 128 57.3 128 128l0 16-40 0c-30.9 0-56 25.1-56 56l0 210.9-29.9 67.3c-3.3 7.4-2.6 16 1.8 22.8S15.9 512 24 512l112 0c13.3 0 24-10.7 24-24l0-72.9 22.1 24.8c4.6 5.1 11.1 8.1 17.9 8.1l112 0c6.9 0 13.4-2.9 17.9-8.1l22.1-24.8 0 72.9c0 13.3 10.7 24 24 24l112 0c8.1 0 15.7-4.1 20.1-10.9s5.1-15.4 1.8-22.8L480 410.9 480 200c0-30.9-25.1-56-56-56l-40 0 0-16C384 57.3 326.7 0 256 0zM192 96a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm112 0a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM88 192l24 0 0 272-51.1 0 17-38.3c1.4-3.1 2.1-6.4 2.1-9.7l0-216c0-4.4 3.6-8 8-8zm72 0l192 0 0 150.9-50.8 57.1-90.4 0-50.8-57.1 0-150.9zm240 0l24 0c4.4 0 8 3.6 8 8l0 216c0 3.4 .7 6.7 2.1 9.7l17 38.3-51.1 0 0-272zM208 224c-8.8 0-16 7.2-16 16s7.2 16 16 16l96 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-96 0zm0 64c-8.8 0-16 7.2-16 16s7.2 16 16 16l96 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-96 0z"]],
    "heart-circle-exclamation": [576, 512, [], "e4fe", ["M48 165.1c0-47 38.1-85.1 85.1-85.1 27.3 0 53 13.1 69 35.2l34.4 47.6c4.5 6.2 11.7 9.9 19.4 9.9s14.9-3.7 19.4-9.9l34.4-47.6c16-22.1 41.7-35.2 69-35.2 47 0 85.1 38.1 85.1 85.1 0 14.9-2.9 29.8-7.9 44.4-7.9-1-16-1.5-24.1-1.5-106 0-192 86-192 192 0 9.4 .7 18.7 2 27.7-34.5-26.3-84.7-70.3-125.8-120.3-36.2-43.9-68.1-92.4-68.1-142.3z", "M378.9 80c-27.3 0-53 13.1-69 35.2l-34.4 47.6c-4.5 6.2-11.7 9.9-19.4 9.9s-14.9-3.7-19.4-9.9l-34.4-47.6c-16-22.1-41.7-35.2-69-35.2-47 0-85.1 38.1-85.1 85.1 0 49.9 32 98.4 68.1 142.3 41.1 49.9 91.4 93.9 125.8 120.3 2.7 18.4 7.9 35.9 15.4 52.2-.5 0-.9 0-1.4 0-15.6 0-30.8-4.7-43.1-14.1-36.5-27.9-89.7-74.4-133.8-127.9-36.2-43.9-79.1-104.2-79.1-172.8 0-73.5 59.6-133.1 133.1-133.1 42.7 0 82.8 20.5 107.9 55.1l15 20.7 15-20.7c25-34.6 65.2-55.1 107.9-55.1 73.5 0 133.1 59.6 133.1 133.1 0 19.5-3.5 38.3-9.3 56.3-14.7-5.8-30.3-9.9-46.6-11.9 5-14.6 7.9-29.4 7.9-44.4 0-47-38.1-85.1-85.1-85.1zM432 256a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm0 228a20 20 0 1 0 0-40 20 20 0 1 0 0 40zm0-180c-8.8 0-16 7.2-16 16l0 80c0 8.8 7.2 16 16 16s16-7.2 16-16l0-80c0-8.8-7.2-16-16-16z"]],
    "building-circle-exclamation": [576, 512, [], "e4d3", ["M80 64c0-8.8 7.2-16 16-16l256 0c8.8 0 16 7.2 16 16l0 154.9c-17.3 6.1-33.4 14.6-48 25.1l0-4c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l4 0c-13.8 19.2-24.1 41-30.1 64.5-2-.4-3.9-.5-5.9-.5l-32 0c-17.7 0-32 14.3-32 32l0 80-80 0c-8.8 0-16-7.2-16-16L80 64zm48 48l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm0 128l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zM256 112l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16z", "M96 48l256 0c8.8 0 16 7.2 16 16l0 154.9c15.2-5.4 31.3-8.9 48-10.3L416 64c0-35.3-28.7-64-64-64L96 0C60.7 0 32 28.7 32 64l0 384c0 35.3 28.7 64 64 64l180 0c-22.7-31.5-36-70.2-36-112 0-16.4 2.1-32.3 5.9-47.5-1.9-.4-3.9-.5-5.9-.5l-32 0c-17.7 0-32 14.3-32 32l0 80-80 0c-8.8 0-16-7.2-16-16L80 64c0-8.8 7.2-16 16-16zM320 240c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l4 0c12.2-16.9 27-31.8 44-44l0-4zM128 112l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zM272 96c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0zM128 240l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zM432 544a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm0-100a20 20 0 1 1 0 40 20 20 0 1 1 0-40zm0-140c8.8 0 16 7.2 16 16l0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80c0-8.8 7.2-16 16-16z"]],
    "person-arrow-up-from-line": [576, 512, [], "e539", ["M160 167.1c9.9-4.6 20.8-7.1 32-7.1s22.1 2.5 32 7.1l0 152.9-64 0 0-152.9z", "M248 24a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zM160 167.1c9.9-4.6 20.8-7.1 32-7.1s22.1 2.5 32 7.1l0 152.9-64 0 0-152.9zM160 496l0-128 64 0 0 128-64 0zm-48 0l-88 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l528 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-280 0 0-278.4 60.5 84.4c7.7 10.8 22.7 13.2 33.5 5.5s13.2-22.7 5.5-33.5L292.3 163.5C269.1 131.2 231.8 112 192 112s-77.2 19.2-100.3 51.5L12.5 274c-7.7 10.8-5.2 25.8 5.5 33.5s25.8 5.2 33.5-5.5L112 217.6 112 496zM561 55L481-25c-9.4-9.4-24.6-9.4-33.9 0L367 55c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l39-39 0 150.1c0 13.3 10.7 24 24 24s24-10.7 24-24l0-150.1 39 39c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9z"]],
    "circle-arrow-down-left": [512, 512, [], "e0f9", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm112-40c0-13.3 10.7-24 24-24s24 10.7 24 24l0 54.1 103-103c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-103 103 54.1 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-112 0c-13.3 0-24-10.7-24-24l0-112z", "M256 48a208 208 0 1 0 0 416 208 208 0 1 0 0-416zm0 464a256 256 0 1 1 0-512 256 256 0 1 1 0 512zM208 216l0 54.1 103-103c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-103 103 54.1 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-112 0c-13.3 0-24-10.7-24-24l0-112c0-13.3 10.7-24 24-24s24 10.7 24 24z"]],
    "not-equal": [448, 512, [], "f53e", ["", "M379.8 69.5c7.5-11 4.6-25.9-6.4-33.3s-25.9-4.6-33.3 6.4L282 128 24 128c-13.3 0-24 10.7-24 24s10.7 24 24 24l225.4 0-108.8 160-116.6 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l83.9 0-39.8 58.5c-7.5 11-4.6 25.9 6.4 33.3s25.9 4.6 33.3-6.3L166 384 424 384c13.3 0 24-10.7 24-24s-10.7-24-24-24l-225.4 0 108.8-160 116.6 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-83.9 0 39.8-58.5z"]],
    "binary-circle-check": [576, 512, [], "e33c", ["", "M392 24l0 152 32 0c13.3 0 24 10.7 24 24 0 3-.6 5.9-1.6 8.5-4.8-.4-9.6-.5-14.4-.5-27.3 0-53.3 5.7-76.9 16L312 224c-13.3 0-24-10.7-24-24s10.7-24 24-24l32 0 0-118.7-16.4 5.5C315 67 301.4 60.2 297.2 47.6s2.6-26.2 15.2-30.4l48-16C367.7-1.2 375.8 0 382 4.5S392 16.3 392 24zM168 312l0 152 32 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L88 512c-13.3 0-24-10.7-24-24s10.7-24 24-24l32 0 0-118.7-16.4 5.5C91 355 77.4 348.2 73.2 335.6s2.6-26.2 15.2-30.4l48-16c7.3-2.4 15.4-1.2 21.6 3.3s10 11.8 10 19.5zM64 64C64 28.7 92.7 0 128 0l64 0c35.3 0 64 28.7 64 64l0 96c0 35.3-28.7 64-64 64l-64 0c-35.3 0-64-28.7-64-64l0-96zm64-16c-8.8 0-16 7.2-16 16l0 96c0 8.8 7.2 16 16 16l64 0c8.8 0 16-7.2 16-16l0-96c0-8.8-7.2-16-16-16l-64 0zM288 400a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm201.4-60.9c-7.1-5.2-17.2-3.6-22.4 3.5l-53 72.9-26.8-26.8c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l40 40c3.3 3.3 7.9 5 12.6 4.6s8.9-2.8 11.7-6.5l64-88c5.2-7.1 3.6-17.2-3.5-22.3z"]],
    "train-tram": [384, 512, [128650], "e5b4", ["M80 288l224 0 0 64c0 26.5-21.5 48-48 48l-128 0c-26.5 0-48-21.5-48-48l0-64zm32 56a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm112 0a24 24 0 1 0 48 0 24 24 0 1 0 -48 0z", "M0 8C0-5.3 10.7-16 24-16l336 0c13.3 0 24 10.7 24 24l0 32c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-8-120 0 0 64 40 0c53 0 96 43 96 96l0 160c0 31.2-14.9 59-38 76.5l64.3 76c8.6 10.1 7.3 25.3-2.8 33.8s-25.3 7.3-33.8-2.8l-74.6-88.1c-3.6 .4-7.3 .6-11.1 .6l-128 0c-3.8 0-7.5-.2-11.1-.6L42.3 535.5c-8.6 10.1-23.7 11.4-33.8 2.8s-11.4-23.7-2.8-33.8l64.3-76C46.9 411 32 383.2 32 352l0-160c0-53 43-96 96-96l40 0 0-64-120 0 0 8c0 13.3-10.7 24-24 24S0 53.3 0 40L0 8zM128 144c-26.5 0-48 21.5-48 48l0 48 224 0 0-48c0-26.5-21.5-48-48-48l-128 0zM80 288l0 64c0 26.5 21.5 48 48 48l128 0c26.5 0 48-21.5 48-48l0-64-224 0zm32 56a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm136-24a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]],
    "plane-departure": [640, 512, [128747], "f5b0", ["M79.2 225.5L128 309c9.8 16.7 30 24 48.2 17.4 13.3-4.8 21.6-7.9 25-9.1L539.5 194.2c16.6-6 25.2-24.4 19.1-41s-24.4-25.2-41-19.1l-104 37.8c-6.3 2.3-13.3 1.8-19.3-1.3L191.9 65.3 165.5 75 260.1 194.2c4.8 6 6.4 14 4.3 21.4s-7.6 13.4-14.9 16L171.8 260c-6 2.2-12.6 1.9-18.4-.8l-73-34-1.2 .4z", "M517.6 134.1c16.6-6 35 2.5 41 19.1s-2.5 35-19.1 41L201.2 317.4c-3.4 1.2-11.7 4.3-25 9.1-18.2 6.6-38.5-.7-48.2-17.4l-48.8-83.5 1.2-.4 73 34c5.8 2.7 12.4 3 18.4 .8l77.7-28.3c7.2-2.6 12.8-8.6 14.9-16s.5-15.4-4.3-21.4L165.5 75 191.9 65.3 394.4 170.7c6 3.1 13 3.6 19.3 1.3l104-37.8zm86.1 2.7c-15.1-41.5-61-62.9-102.5-47.8L407.1 123.2 204.7 17.9c-6-3.1-13-3.6-19.3-1.3L117.8 41.3c-7.2 2.6-12.8 8.6-14.9 16s-.5 15.4 4.3 21.4l94.6 119.2-37 13.5-73-34c-5.8-2.7-12.4-3-18.4-.8L35.8 190.3c-6.7 2.4-11.9 7.7-14.4 14.4s-1.7 14.1 1.9 20.3L86.6 333.3c21.5 36.7 66.1 52.8 106.1 38.3 13.3-4.8 21.6-7.9 25-9.1L555.9 239.3c41.5-15.1 62.9-61 47.8-102.5zM56.1 464c-13.3 0-24 10.7-24 24s10.7 24 24 24l528 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-528 0z"]],
    "microphone-stand": [512, 512, [127908], "f8cb", ["M72.7 390.2c-5.8 6.3-5.5 16 .5 22.1L99.8 439c6 6.1 15.8 6.3 22.1 .5L294 282.3 229.8 218.1 72.7 390.2zM260 166l.1 14.5 71.5 71.5 14.5 .1c16.6 .1 33.1-6.1 45.8-18.7l5.8-5.8-113.1-113.1-5.8 5.8c-12.6 12.6-18.9 29.1-18.7 45.8zm58.8-85.2L431.3 193.3c25.6-31.4 23.8-77.8-5.5-107.1s-75.6-31.1-107.1-5.5z", "M229.8 218.1L294 282.3 121.9 439.5c-6.3 5.8-16.1 5.5-22.1-.5L73.1 412.3c-6-6.1-6.3-15.8-.5-22.1L229.8 218.1zM331.6 252l-71.5-71.5-.1-14.5c-.1-16.6 6.1-33.1 18.7-45.8l5.8-5.8 113.1 113.1-5.8 5.8c-12.6 12.6-29.1 18.9-45.8 18.7l-14.5-.1zM318.8 80.8c31.4-25.6 77.8-23.8 107.1 5.5s31.1 75.6 5.5 107.1L318.8 80.8zm141-28.4c-50-50-131-50-181 0L244.8 86.3c-22.1 22.1-33 51.1-32.8 80.1L37.2 357.8c-23.1 25.2-22.2 64.2 2 88.4l26.6 26.7c24.2 24.2 63.2 25.2 88.5 2.1l77.9-71.1 0 116.2c0 13.3 10.7 24 24 24s24-10.7 24-24l0-160 65.6-59.9c29 .2 58-10.7 80.1-32.8l33.9-33.9c50-50 50-131 0-181z"]],
    "shop-24": [640, 512, [], "e79a", ["M64 204.2c0 2.1 1.7 3.8 3.8 3.8l440.4 0c2.1 0 3.8-1.7 3.8-3.8 0-.6-.1-1.2-.4-1.7L454.8 88.8c-2.7-5.4-8.2-8.8-14.3-8.8L135.6 80c-6.1 0-11.6 3.4-14.3 8.8L64.4 202.5c-.3 .5-.4 1.1-.4 1.7zM112 384l0 48 192 0 0-48-192 0z", "M64.4 202.5c-.3 .5-.4 1.1-.4 1.7 0 2.1 1.7 3.8 3.8 3.8l440.4 0c2.1 0 3.8-1.7 3.8-3.8 0-.6-.1-1.2-.4-1.7L454.8 88.8c-2.7-5.4-8.2-8.8-14.3-8.8L135.6 80c-6.1 0-11.6 3.4-14.3 8.8L64.4 202.5zM64 255.9c-26.8-1.9-48-24.3-48-51.6 0-8 1.9-16 5.5-23.2L78.3 67.4C89.2 45.7 111.3 32 135.6 32l304.9 0c24.2 0 46.4 13.7 57.2 35.4l56.8 113.7c3.6 7.2 5.5 15.1 5.5 23.2 0 27.3-21.2 49.7-48 51.6l0 48.1-48 0 0-48-112 0 0 48-48 0 0-48-192 0 0 80 192 0 0 48-192 0 0 48 192 0 0 48-192 0c-26.5 0-48-21.5-48-48l0-176 0-.1zM348 400c0-28.7 23.3-52 52-52s52 23.3 52 52l0 1c0 14.6-5.4 28.7-15 39.6L405.4 476 432 476c11 0 20 9 20 20s-9 20-20 20l-58.2 0c-14.2 0-25.8-11.5-25.8-25.8 0-6.3 2.3-12.4 6.5-17.1L407.1 414c3.2-3.6 4.9-8.2 4.9-13l0-1c0-6.6-5.4-12-12-12s-12 5.4-12 12c0 11-9 20-20 20s-20-9-20-20zm128 32l0-64c0-11 9-20 20-20s20 9 20 20l0 44 24 0 0-44c0-11 9-20 20-20s20 9 20 20l0 128c0 11-9 20-20 20s-20-9-20-20l0-44-44 0c-5.3 0-10.4-2.1-14.1-5.9S476 437.3 476 432z"]],
    "brightness": [512, 512, [], "e0c9", ["M208 256a48 48 0 1 0 96 0 48 48 0 1 0 -96 0z", "M232 88c0 13.3 10.7 24 24 24s24-10.7 24-24l0-64c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 64zm24 120a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm0 144a96 96 0 1 0 0-192 96 96 0 1 0 0 192zM0 256c0 13.3 10.7 24 24 24l64 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-64 0c-13.3 0-24 10.7-24 24zm424-24c-13.3 0-24 10.7-24 24s10.7 24 24 24l64 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-64 0zM256 512c13.3 0 24-10.7 24-24l0-64c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 64c0 13.3 10.7 24 24 24zM75 75c-9.4 9.4-9.4 24.6 0 33.9l45.3 45.3c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9L108.9 75c-9.4-9.4-24.6-9.4-33.9 0zM391.8 357.8c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9L403.1 437c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-45.3-45.3zM75 437c9.4 9.4 24.6 9.4 33.9 0l45.3-45.3c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0L75 403.1c-9.4 9.4-9.4 24.6 0 33.9zM357.8 120.2c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0L437 108.9c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-45.3 45.3z"]],
    "right-to-bracket": [512, 512, ["sign-in-alt"], "f2f6", ["M48 224l0 64 136 0c13.3 0 24 10.7 24 24l0 30.1 86.1-86.1-86.1-86.1 0 30.1c0 13.3-10.7 24-24 24L48 224z", "M201 95L345 239c9.4 9.4 9.4 24.6 0 33.9L201 417c-6.9 6.9-17.2 8.9-26.2 5.2S160 409.7 160 400l0-64-112 0c-26.5 0-48-21.5-48-48l0-64c0-26.5 21.5-48 48-48l112 0 0-64c0-9.7 5.8-18.5 14.8-22.2S194.1 88.2 201 95zm7 217l0 30.1 86.1-86.1-86.1-86.1 0 30.1c0 13.3-10.7 24-24 24l-136 0 0 64 136 0c13.3 0 24 10.7 24 24zM344 432l72 0c26.5 0 48-21.5 48-48l0-256c0-26.5-21.5-48-48-48l-72 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l72 0c53 0 96 43 96 96l0 256c0 53-43 96-96 96l-72 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"]],
    "sd-card": [384, 512, [], "f7c2", ["M48 125.3L48 448c0 8.8 7.2 16 16 16l256 0c8.8 0 16-7.2 16-16l0-384c0-8.8-7.2-16-16-16L125.3 48c-4.2 0-8.3 1.7-11.3 4.7L52.7 113.9c-3 3-4.7 7.1-4.7 11.3zM160 120c0-13.3 10.7-24 24-24s24 10.7 24 24l0 48c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-48zm88 0c0-13.3 10.7-24 24-24s24 10.7 24 24l0 48c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-48z", "M52.7 113.9c-3 3-4.7 7.1-4.7 11.3L48 448c0 8.8 7.2 16 16 16l256 0c8.8 0 16-7.2 16-16l0-384c0-8.8-7.2-16-16-16L125.3 48c-4.2 0-8.3 1.7-11.3 4.7L52.7 113.9zM320 0c35.3 0 64 28.7 64 64l0 384c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 125.3C0 108.3 6.7 92 18.7 80L80 18.7C92 6.7 108.3 0 125.3 0L320 0zM208 120l0 48c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-48c0-13.3 10.7-24 24-24s24 10.7 24 24zm88 0l0 48c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-48c0-13.3 10.7-24 24-24s24 10.7 24 24z"]],
    "dot": [192, 512, [], "e7d1", ["M72 264c0 12.7 9.9 23.1 22.4 24 1.1 0 2.2 0 3.2 0 12.5-.9 22.4-11.3 22.4-24 0-13.3-10.7-24-24-24s-24 10.7-24 24z", "M96 192c39.8 0 72 32.2 72 72s-32.2 72-72 72-72-32.2-72-72 32.2-72 72-72zm0 48c-13.3 0-24 10.7-24 24s10.7 24 24 24 24-10.7 24-24-10.7-24-24-24z"]],
    "house-circle-exclamation": [640, 512, [], "e50a", ["M128 199.7l160-143.4 172.9 155c-51.4 9.5-95.7 39.5-123.9 81.2-7.8-2.9-16.2-4.4-24.9-4.4l-48 0c-39.8 0-72 32.2-72 72l0 104-48 0c-8.8 0-16-7.2-16-16l0-248.3z", "M272 6.1c9.1-8.2 22.9-8.2 32 0L533.2 211.6c-12-2.4-24.5-3.6-37.2-3.6-12 0-23.8 1.1-35.1 3.2L288 56.2 128 199.7 128 448c0 8.8 7.2 16 16 16l48 0 0-104c0-39.8 32.2-72 72-72l48 0c8.8 0 17.2 1.6 24.9 4.4-9.1 13.5-16.6 28.1-22.1 43.7-.9-.1-1.9-.2-2.9-.2l-48 0c-13.3 0-24 10.7-24 24l0 104 74.9 0c6.1 17.3 14.6 33.4 25.1 48l-196 0c-35.3 0-64-28.7-64-64l0-205.3-8 7.2c-9.9 8.8-25 8-33.9-1.8s-8-25 1.8-33.9L272 6.1zM496 256a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm0 228a20 20 0 1 0 0-40 20 20 0 1 0 0 40zm0-180c-8.8 0-16 7.2-16 16l0 80c0 8.8 7.2 16 16 16s16-7.2 16-16l0-80c0-8.8-7.2-16-16-16z"]],
    "shekel-sign": [448, 512, [8362, "ils", "shekel", "sheqel", "sheqel-sign"], "f20b", ["", "M40 32C26.7 32 16 42.7 16 56l0 400c0 13.3 10.7 24 24 24s24-10.7 24-24l0-376 120 0c39.8 0 72 32.2 72 72l0 184c0 13.3 10.7 24 24 24s24-10.7 24-24l0-184c0-66.3-53.7-120-120-120L40 32zM312 480c66.3 0 120-53.7 120-120l0-304c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 304c0 39.8-32.2 72-72 72l-120 0 0-248c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 272c0 13.3 10.7 24 24 24l144 0z"]],
    "square-u": [448, 512, [], "e281", ["M48 96l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16zm80 72c0-13.3 10.7-24 24-24s24 10.7 24 24l0 104c0 26.5 21.5 48 48 48s48-21.5 48-48l0-104c0-13.3 10.7-24 24-24s24 10.7 24 24l0 104c0 53-43 96-96 96s-96-43-96-96l0-104z", "M64 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm176 72l0 104c0 26.5 21.5 48 48 48s48-21.5 48-48l0-104c0-13.3 10.7-24 24-24s24 10.7 24 24l0 104c0 53-43 96-96 96s-96-43-96-96l0-104c0-13.3 10.7-24 24-24s24 10.7 24 24z"]],
    "truck-container-empty": [640, 512, [], "e2b5", ["M480 304l0 35.3c7.6-2.2 15.7-3.3 24-3.3 39.8 0 73.5 26.4 84.3 62.7 2.2-1.4 3.7-3.9 3.7-6.7l0-88-112 0z", "M432 152c0-13.3 10.7-24 24-24l79.4 0c17 0 33.3 6.7 45.3 18.7l40.6 40.6c12 12 18.7 28.3 18.7 45.3L640 392c0 29.3-22.5 53.4-51.3 55.8-10.4 37-44.4 64.2-84.7 64.2-40.3 0-74.2-27.1-84.7-64l-118.6 0c-10.4 36.9-44.4 64-84.7 64-25.2 0-48-10.6-64-27.6-16 17-38.8 27.6-64 27.6-48.6 0-88-39.4-88-88s39.4-88 88-88c25.2 0 48 10.6 64 27.6 16-17 38.8-27.6 64-27.6 40.3 0 74.2 27.1 84.7 64l118.6 0c2.7-9.6 7.1-18.6 12.7-26.6L432 152zM592 392l0-88-112 0 0 35.3c7.6-2.2 15.7-3.3 24-3.3 39.8 0 73.5 26.4 84.3 62.7 2.2-1.4 3.7-3.9 3.7-6.7zm0-136l0-23.4c0-4.2-1.7-8.3-4.7-11.3l-40.6-40.6c-3-3-7.1-4.7-11.3-4.7l-55.4 0 0 80 112 0zM88 464a40 40 0 1 0 0-80 40 40 0 1 0 0 80zm456-40a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zM216 464a40 40 0 1 0 0-80 40 40 0 1 0 0 80z"]],
    "user-pilot-tie": [448, 512, [], "e2c1", ["M24 512c13.3 0 24-10.7 24-24l0-8c0-43.4 21.6-81.8 54.7-105L171 499.5c4.2 7.7 12.3 12.5 21 12.5L24 512zM144 133.7c23.2 5.7 50.9 10.3 80 10.3s56.8-4.6 80-10.3l0 10.3c0 44.2-35.8 80-80 80s-80-35.8-80-80l0-10.3zM256 512c8.8 0 16.8-4.8 21-12.5L345.3 375c20.2 14.1 36.1 33.9 45.4 57L360 432c-13.3 0-24 10.7-24 24s10.7 24 24 24l40 0 0 8c0 13.3 10.7 24 24 24l-168 0z", "M65.7 11.2L215.6-29.7c5.5-1.5 11.3-1.5 16.8 0L382.3 11.2c10.5 2.9 17.7 12.4 17.7 23.2 0 8.5-4.4 16.3-11.7 20.6L368 67.2 368 91.8c0 11.4-6 21.8-16 26.7l0 25.5c0 70.7-57.3 128-128 128S96 214.7 96 144l0-25.5c-10-5-16-15.4-16-26.7L80 67.2 59.7 55C52.4 50.7 48 42.8 48 34.4 48 23.5 55.3 14 65.7 11.2zM224 144c-29.1 0-56.8-4.6-80-10.3l0 10.3c0 44.2 35.8 80 80 80s80-35.8 80-80l0-10.3c-23.2 5.7-50.9 10.3-80 10.3zM193.5 304l61 0c9.7 0 17.5 7.8 17.5 17.5 0 4.2-1.5 8.2-4.2 11.4l-27.4 32 18.4 68.2 56.2-102.5C321 319.5 334.7 315 346.1 320.3 406.2 348.3 448 409.2 448 480l0 8c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-8-40 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l30.7 0c-9.3-23.1-25.2-42.8-45.4-57L277 499.5c-4.2 7.7-12.3 12.5-21 12.5l-64 0c-8.8 0-16.8-4.8-21-12.5L102.7 375C69.6 398.2 48 436.6 48 480l0 8c0 13.3-10.7 24-24 24S0 501.3 0 488l0-8c0-70.8 41.8-131.7 101.9-159.7 11.5-5.3 25.1-.9 31.2 10.2l55.9 102 18.5-67.8-27.2-31.8c-2.7-3.2-4.2-7.2-4.2-11.4 0-9.7 7.8-17.5 17.5-17.5zM183.2 33.7c-7.9-4-17.5-.7-21.5 7.2s-.7 17.5 7.2 21.5l48 24c4.5 2.3 9.8 2.3 14.3 0l48-24c7.9-4 11.1-13.6 7.2-21.5s-13.6-11.1-21.5-7.2L224 54.1 183.2 33.7z"]],
    "radio": [512, 512, [128251], "f8d7", ["M48 163.9c0-6.9 2.9-13.2 7.7-17.7 2.4-1.5 5.2-2.3 8.3-2.3l384 0c8.8 0 16 7.2 16 16l0 256c0 8.8-7.2 16-16 16L64 432c-8.8 0-16-7.2-16-16l0-252.1zM96 248c0 13.3 10.7 24 24 24l80 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0c-13.3 0-24 10.7-24 24zm0 96c0 13.3 10.7 24 24 24l80 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0c-13.3 0-24 10.7-24 24zm176-56a80 80 0 1 0 160 0 80 80 0 1 0 -160 0z", "M494.8 15c12.7-3.7 20-17.1 16.3-29.8S494-34.8 481.3-31L51.8 94.9C42.4 97.6 33.9 102.1 26.6 108 10.5 119.7 0 138.6 0 160L0 416c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L218.5 96 494.8 15zM48 163.9c0-6.9 2.9-13.2 7.7-17.7 2.4-1.5 5.2-2.3 8.3-2.3l384 0c8.8 0 16 7.2 16 16l0 256c0 8.8-7.2 16-16 16L64 432c-8.8 0-16-7.2-16-16l0-252.1zM352 256a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm0 112a80 80 0 1 0 0-160 80 80 0 1 0 0 160zM120 224c-13.3 0-24 10.7-24 24s10.7 24 24 24l80 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0zm0 96c-13.3 0-24 10.7-24 24s10.7 24 24 24l80 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0z"]],
    "hand-dots": [512, 512, ["allergies"], "f461", ["M53.2 292.7c-6.2 6.2-6.2 16.4 0 22.6L141 403.1c39 39 91.9 60.9 147.1 60.9l13.4 0c.6-.1 1.3-.1 1.9-.2 69.7-3.4 125.6-59.3 129-129 0-.6 .1-1.3 .2-1.9l0-172.9c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 72c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-136c0-8.8-7.2-16-16-16s-16 7.1-16 16l0 136c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-168c0-8.8-7.2-16-16-16s-16 7.2-16 16c0 4 0 60.2 0 168 0 13.3-10.7 24-24 24s-24-10.7-24-24l0-136.1c0-8.8-7.2-15.9-16-15.9-8.8 0-16 7.2-16 16l0 223.4c0 9.7-5.8 18.5-14.8 22.2s-19.3 1.7-26.2-5.2L75.8 292.7c-6.2-6.2-16.4-6.2-22.6 0zM248.5 352a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm64 64a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm16-112a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm64 64a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M256.5 0c-25.3 0-47.2 14.7-57.6 36-7-2.6-14.5-4-22.4-4-35.3 0-64 28.7-64 64l0 165.5-2.7-2.7c-25-25-65.5-25-90.5 0s-25 65.5 0 90.5L107 437c48 48 113.1 75 181 75l16.5 0c1.5 0 3-.1 4.5-.4 91.7-6.2 165-79.4 171.1-171.1 .3-1.5 .4-3 .4-4.5l0-176c0-35.3-28.7-64-64-64-5.5 0-10.9 .7-16 2l0-2c0-35.3-28.7-64-64-64-7.9 0-15.4 1.4-22.4 4-10.4-21.3-32.3-36-57.6-36zm-16 96.1l0-.1 0-32c0-8.8 7.2-16 16-16s16 7.2 16 16l0 168c0 13.3 10.7 24 24 24s24-10.7 24-24l0-136c0-8.8 7.2-16 16-16s16 7.2 16 16l0 136c0 13.3 10.7 24 24 24s24-10.7 24-24l0-72c0-8.8 7.2-16 16-16s16 7.2 16 16l0 172.9c-.1 .6-.1 1.3-.2 1.9-3.4 69.7-59.3 125.6-129 129-.6 0-1.3 .1-1.9 .2L288 464C232.9 464 180 442.1 141 403.1L53.2 315.3c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l43.7 43.7c6.9 6.9 17.2 8.9 26.2 5.2s14.8-12.5 14.8-22.2l0-223.4c0-8.8 7.2-16 16-16 8.8 0 16 7.1 16 15.9l0 136.1c0 13.3 10.7 24 24 24s24-10.7 24-24l0-135.9zm8 255.9a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm56-24a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm88 40a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm-104 72a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]],
    "pencil-line": [576, 512, [], "e74f", ["M116.3 325.6l3.2 16 50.9 50.9 16 3.2 183.7-183.7-70.1-70.1-183.7 183.7z", "M36.4 353.8c4.1-14.6 11.8-27.9 22.6-38.7l294-294C366.4 7.6 384.8 0 404 0s37.6 7.6 51.1 21.2l35.7 35.7C504.4 70.4 512 88.8 512 108s-7.6 37.6-21.2 51.1l-294 294c-10.7 10.7-24.1 18.5-38.7 22.6L30.4 511.1c-8.3 2.3-17.3 0-23.4-6.2s-8.5-15.1-6.2-23.4L36.4 353.8zM386.8 55.1l-52.9 52.9 70.1 70.1 52.9-52.9c4.6-4.6 7.1-10.7 7.1-17.2s-2.6-12.6-7.1-17.2L421.2 55.1C416.6 50.6 410.4 48 404 48s-12.6 2.6-17.2 7.1zM300 141.9L109.9 332 180 402.1 370.1 212 300 141.9zM58.5 453.5l82.2-22.8-59.4-59.4-22.8 82.2zM280 464l272 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-272 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"]],
    "hand-shaka": [576, 512, [], "e831", ["M73.2 79.3l18.1 57.2c3.2 10.1 4.8 20.7 4.8 31.3l0 116.6c0 99.2 80.4 179.7 179.7 179.7l8.9-.2c44.4-2.2 86.5-20.8 118.1-52.4L505.8 308.3c4-4 6.2-9.4 6.2-15.1 0-10.2-7.3-18.8-17-20.8l-4.3-.4c-5.6 0-11 2.2-15 6.2l-86.8 86.7-22.8 22.8c-13 13-30.6 20.3-49 20.3-31.3 0-57.8-20.8-66.3-49.4-4.5 .9-9.1 1.4-13.7 1.4-38.2 0-69.2-31-69.2-69.3 0-4.6 .5-9.2 1.4-13.7-28.5-8.6-49.4-35-49.4-66.3 0-18.4 7.3-36 20.3-49l3.4-3.4c-.8-12.4-2.9-24.6-6.7-36.4L119 64.8c-4-12.6-17.5-19.6-30.2-15.7-12.6 4-19.6 17.5-15.7 30.2zM168 210.8c0 11.7 9.5 21.2 21.2 21.2 5.6 0 11-2.2 15-6.2l45.5-45.5c4-4 6.2-9.4 6.2-15 0-11.7-9.5-21.3-21.2-21.3-5.6 0-11 2.2-15 6.2l-45.5 45.5c-4 4-6.2 9.4-6.2 15zm48 80c0 11.7 9.5 21.2 21.2 21.3 5.6 0 11-2.2 15-6.2l61.5-61.5c4-4 6.2-9.4 6.2-15 0-11.7-9.5-21.3-21.3-21.3-5.6 0-11 2.2-15 6.2l-61.5 61.5c-4 4-6.2 9.4-6.2 15zm80 48c0 11.7 9.5 21.2 21.3 21.3 5.6 0 11-2.2 15-6.2l45.5-45.5c4-4 6.2-9.4 6.2-15 0-11.7-9.5-21.2-21.3-21.2-5.6 0-11 2.2-15 6.2l-45.5 45.5c-4 4-6.2 9.4-6.2 15z", "M74.4 3.4c37.9-12 78.4 9.1 90.3 47l18.1 57.2c1 3 1.8 6.1 2.6 9.1l.4-.4c13-13 30.6-20.3 49-20.3 36.5 0 66.4 28.3 69 64.2 34.2 2.4 61.5 29.8 64 64 24.8 1.8 45.8 16.5 56.6 37.5l17.5-17.4c13-13 30.6-20.3 49-20.3 38.2 0 69.2 31 69.3 69.2 0 18.3-7.3 36-20.3 49L436.7 445.4c-40 40-93.4 63.6-149.7 66.4l-11.3 .3C150 512 48.1 410.1 48.1 284.3l0-116.6c0-5.7-.9-11.4-2.6-16.9L27.4 93.7c-12-37.9 9.1-78.4 47-90.3zM119 64.8c-4-12.6-17.5-19.6-30.2-15.7-12.6 4-19.6 17.5-15.7 30.2l18.1 57.2c3.2 10.1 4.8 20.7 4.8 31.3l0 116.6c0 99.2 80.4 179.7 179.7 179.7l8.9-.2c44.4-2.2 86.5-20.8 118.1-52.4L505.8 308.3c4-4 6.2-9.4 6.2-15.1 0-10.2-7.3-18.8-17-20.8l-4.3-.4c-5.6 0-11 2.2-15 6.2l-86.8 86.7-22.8 22.8c-13 13-30.6 20.3-49 20.3-31.3 0-57.8-20.8-66.3-49.4-4.5 .9-9.1 1.4-13.7 1.4-38.2 0-69.2-31-69.2-69.3 0-4.6 .5-9.2 1.4-13.7-28.5-8.6-49.4-35-49.4-66.3 0-18.4 7.3-36 20.3-49l3.4-3.4c-.8-12.4-2.9-24.6-6.7-36.4L119 64.8zM362.8 272c-5.6 0-11 2.2-15 6.2l-45.5 45.5c-4 4-6.2 9.4-6.2 15 0 11.7 9.5 21.2 21.3 21.3 5.6 0 11-2.2 15-6.2l45.5-45.5c4-4 6.2-9.4 6.2-15 0-11.7-9.5-21.2-21.3-21.2zm-64-64c-5.6 0-11 2.2-15 6.2l-61.5 61.5c-4 4-6.2 9.4-6.2 15 0 11.7 9.5 21.2 21.2 21.3 5.6 0 11-2.2 15-6.2l61.5-61.5c4-4 6.2-9.4 6.2-15 0-11.7-9.5-21.3-21.3-21.3zm-64-64c-5.6 0-11 2.2-15 6.2l-45.5 45.5c-4 4-6.2 9.4-6.2 15 0 11.7 9.5 21.2 21.2 21.2 5.6 0 11-2.2 15-6.2l45.5-45.5c4-4 6.2-9.4 6.2-15 0-11.7-9.5-21.3-21.2-21.3z"]],
    "flask-gear": [576, 512, [], "e5f1", ["M49 452.6l57.5-100.6 111.6 0c2.8 11.6 8.4 22.5 16.6 31.5-19.5 21.6-24.5 53.5-11 80.5L55.6 464c-5.8 0-9.4-6.5-6.6-11.4z", "M96 24c0-13.3 10.7-24 24-24L328 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-8 0 0 175.6-48 .4 0-176-96 0 0 176c0 4.2-1.1 8.3-3.2 11.9l-38.9 68.1 89.3 0c-7.4 15.4-8.9 32.3-5.1 48L106.5 352 49 452.6c-2.8 4.9 .8 11.4 6.6 11.4l168.1 0 26.9 48-195.1 0c-30.7 0-55.6-24.9-55.6-55.6 0-9.7 2.5-19.2 7.3-27.6L128 217.6 128 48 120 48c-13.3 0-24-10.7-24-24zM368.2 247.6c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24l0 6.1c0 18.9 24.1 32.8 40.5 23.4l5-2.9c11.6-6.7 26.5-2.6 33 9.1l22.4 40.2c6.2 11.2 2.6 25.2-8.2 32l-4.7 2.9c-16.2 10.1-16.2 39.9 0 50.1l4.6 2.9c10.8 6.8 14.5 20.8 8.3 32l-22.4 40.4c-6.5 11.7-21.4 15.9-33 9.1l-4.9-2.9c-16.4-9.5-40.5 4.5-40.5 23.4l0 6.1c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-5.9c0-19-24.2-33-40.7-23.5l-4.8 2.8c-11.6 6.7-26.4 2.6-33-9.1l-22.5-40.4c-6.3-11.2-2.6-25.3 8.3-32.1l4.4-2.7c16.3-10.1 16.3-40.1 0-50.2l-4.5-2.8c-10.9-6.8-14.5-20.9-8.3-32.1l22.5-40.3c6.5-11.7 21.4-15.8 32.9-9.1l4.8 2.8c16.5 9.5 40.7-4.5 40.7-23.5l0-5.9zm99.9 136.2a52 52 0 1 0 -104 0 52 52 0 1 0 104 0z"]],
    "book-skull": [448, 512, ["book-dead"], "f6b7", ["M48 88l0 270.7c9.8-4.3 20.6-6.7 32-6.7l296 0c13.3 0 24-10.7 24-24l0-256c0-13.3-10.7-24-24-24L88 48C65.9 48 48 65.9 48 88zm69.2 145.2c3.8-10.4 15.2-15.7 25.6-12l81.2 29.5 81.2-29.5c10.4-3.8 21.9 1.6 25.6 12s-1.6 21.9-12 25.6l-36.3 13.2 36.3 13.2c10.4 3.8 15.7 15.3 12 25.6s-15.3 15.7-25.6 12l-81.2-29.5-81.2 29.5c-10.4 3.8-21.9-1.6-25.6-12s1.6-21.9 12-25.6l36.3-13.2-36.3-13.2c-10.4-3.8-15.7-15.3-12-25.6zM144 144c0-35.3 35.8-64 80-64s80 28.7 80 64c0 20.9-12.6 39.5-32 51.2l0 4.8c0 8.8-7.2 16-16 16l-64 0c-8.8 0-16-7.2-16-16l0-4.8c-19.4-11.7-32-30.3-32-51.2zm32 0a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm64 0a16 16 0 1 0 32 0 16 16 0 1 0 -32 0z", "M0 88C0 39.4 39.4 0 88 0L376 0c39.8 0 72 32.2 72 72l0 256c0 25-12.7 47-32 59.9l0 76.1 8 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L80 512c-44.2 0-80-35.8-80-80L0 88zM80 400c-17.7 0-32 14.3-32 32s14.3 32 32 32l288 0 0-64-288 0zM48 358.7c9.8-4.3 20.6-6.7 32-6.7l296 0c13.3 0 24-10.7 24-24l0-256c0-13.3-10.7-24-24-24L88 48C65.9 48 48 65.9 48 88l0 270.7zM272 195.2l0 4.8c0 8.8-7.2 16-16 16l-64 0c-8.8 0-16-7.2-16-16l0-4.8c-19.4-11.7-32-30.3-32-51.2 0-35.3 35.8-64 80-64s80 28.7 80 64c0 20.9-12.6 39.5-32 51.2zM208 144a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm48 16a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm74.8 73.2c3.8 10.4-1.6 21.9-12 25.6l-36.3 13.2 36.3 13.2c10.4 3.8 15.7 15.3 12 25.6s-15.3 15.7-25.6 12l-81.2-29.5-81.2 29.5c-10.4 3.8-21.9-1.6-25.6-12s1.6-21.9 12-25.6l36.3-13.2-36.3-13.2c-10.4-3.8-15.7-15.3-12-25.6s15.2-15.7 25.6-12l81.2 29.5 81.2-29.5c10.4-3.8 21.9 1.6 25.6 12z"]],
    "unlock-keyhole": [384, 512, ["unlock-alt"], "f13e", ["M48 224c0-8.8 7.2-16 16-16 5.3 0 90.7 0 256 0 8.8 0 16 7.2 16 16l0 224c0 8.8-7.2 16-16 16L64 464c-8.8 0-16-7.2-16-16l0-224zm80 112c0 13.3 10.7 24 24 24l80 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0c-13.3 0-24 10.7-24 24z", "M192 16c-44.2 0-80 35.8-80 80l0 64 208 0c35.3 0 64 28.7 64 64l0 224c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 224c0-35.3 28.7-64 64-64l0-64c0-70.7 57.3-128 128-128 67.4 0 122.5 52 127.6 118.1 1 13.2-8.9 24.8-22.1 25.8s-24.8-8.9-25.8-22.1C268.6 48.5 234.1 16 192 16zM48 224l0 224c0 8.8 7.2 16 16 16l256 0c8.8 0 16-7.2 16-16l0-224c0-8.8-7.2-16-16-16l-208 0 0 0-48 0 0 0c-8.8 0-16 7.2-16 16zM232 360l-80 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l80 0c13.3 0 24 10.7 24 24s-10.7 24-24 24z"]],
    "truck-ramp": [576, 512, [], "f4e0", ["M368 96c0-8.8 7.2-16 16-16l192 0 0 304-9.6 0c-14.6-28.5-44.2-48-78.4-48-27.3 0-51.7 12.5-67.9 32l-52.1 0 0-272z", "M320 96c0-35.3 28.7-64 64-64l192 0 0 48-192 0c-8.8 0-16 7.2-16 16l0 272 52.1 0c16.1-19.5 40.6-32 67.9-32 48.6 0 88 39.4 88 88s-39.4 88-88 88-88-39.4-88-88c0-2.7 .1-5.4 .4-8l-52.8 0-316.6 95C18.2 514.8 4.8 507.6 1 494.9S4.4 468.8 17.1 465L320 374.1 320 96zM488 464a40 40 0 1 0 0-80 40 40 0 1 0 0 80z"]],
    "envelope-dot": [576, 512, ["envelope-badge"], "e16f", ["M80 125.4C80 118 86 112 93.4 112L372 112c7.9 30.7 27 57 52.6 74.2L312.2 271.5c-14.3 10.8-34.1 10.8-48.4 0L85.3 136.1c-3.3-2.5-5.3-6.5-5.3-10.7zm0 66.9L234.8 309.8c31.4 23.9 74.9 23.9 106.4 0l136-103.2c6.1 .9 12.4 1.4 18.8 1.4l0 176c0 8.8-7.2 16-16 16L96 400c-8.8 0-16-7.2-16-16l0-191.7z", "M496 0a80 80 0 1 1 0 160 80 80 0 1 1 0-160zM93.4 64L369 64c-.7 5.2-1 10.6-1 16 0 11 1.4 21.8 4 32L93.4 112c-7.4 0-13.4 6-13.4 13.4 0 4.2 2 8.2 5.3 10.7L263.8 271.5c14.3 10.8 34.1 10.8 48.4 0l112.4-85.3c15.5 10.4 33.3 17.5 52.6 20.4l-136 103.2c-31.4 23.9-74.9 23.9-106.4 0L80 192.3 80 384c0 8.8 7.2 16 16 16l384 0c8.8 0 16-7.2 16-16l0-176c17 0 33.2-3.3 48-9.3L544 384c0 35.3-28.7 64-64 64L96 448c-35.3 0-64-28.7-64-64l0-256 .1 0c0-.9-.1-1.7-.1-2.6 0-33.9 27.5-61.4 61.4-61.4z"]],
    "house-heart": [512, 512, ["home-heart"], "f4c9", ["M96 199.7L96 448c0 8.8 7.2 16 16 16l288 0c8.8 0 16-7.2 16-16L416 199.7 256 56.2 96 199.7zM160 288c0-26.5 21.5-48 48-48l2.9 0c13.5 0 26.5 5.4 36 14.9l9.1 9.1 9.1-9.1c9.5-9.5 22.5-14.9 36-14.9l2.9 0c26.5 0 48 21.5 48 48 0 53.4-66.9 95.7-89 108.2-4.4 2.5-9.6 2.5-14 0-22.1-12.5-89-54.8-89-108.2z", "M240 6.1c9.1-8.2 22.9-8.2 32 0l232 208c9.9 8.8 10.7 24 1.8 33.9s-24 10.7-33.9 1.8l-8-7.2 0 205.3c0 35.3-28.7 64-64 64l-288 0c-35.3 0-64-28.7-64-64l0-205.3-8 7.2c-9.9 8.8-25 8-33.9-1.8s-8-25 1.8-33.9L240 6.1zm16 50.1L96 199.7 96 448c0 8.8 7.2 16 16 16l288 0c8.8 0 16-7.2 16-16l0-248.3-160-143.4zm-9.1 198.7l9.1 9.1 9.1-9.1c9.5-9.5 22.5-14.9 36-14.9l2.9 0c26.5 0 48 21.5 48 48 0 53.4-66.9 95.7-89 108.2-4.4 2.5-9.6 2.5-14 0-22.1-12.5-89-54.8-89-108.2 0-26.5 21.5-48 48-48l2.9 0c13.5 0 26.5 5.4 36 14.9z"]],
    "file-arrow-up": [384, 512, ["file-upload"], "f574", ["M48 64l0 384c0 8.8 7.2 16 16 16l256 0c8.8 0 16-7.2 16-16l0-240-88 0c-39.8 0-72-32.2-72-72l0-88-112 0c-8.8 0-16 7.2-16 16zm63 247l64-64c9.4-9.4 24.6-9.4 33.9 0l64 64c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-23-23 0 86.1c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-86.1-23 23c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9z", "M64 48l112 0 0 88c0 39.8 32.2 72 72 72l88 0 0 240c0 8.8-7.2 16-16 16L64 464c-8.8 0-16-7.2-16-16L48 64c0-8.8 7.2-16 16-16zM224 67.9l92.1 92.1-68.1 0c-13.3 0-24-10.7-24-24l0-68.1zM64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-261.5c0-17-6.7-33.3-18.7-45.3L242.7 18.7C230.7 6.7 214.5 0 197.5 0L64 0zM209 247c-9.4-9.4-24.6-9.4-33.9 0l-64 64c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l23-23 0 86.1c0 13.3 10.7 24 24 24s24-10.7 24-24l0-86.1 23 23c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-64-64z"]],
    "game-console-handheld": [384, 512, [], "f8bb", ["M48 64l0 352c0 26.5 21.5 48 48 48l192 0c26.5 0 48-21.5 48-48l0-352c0-8.8-7.2-16-16-16L64 48c-8.8 0-16 7.2-16 16zM80 336c0-8.8 7.2-16 16-16l16 0 0-16c0-8.8 7.2-16 16-16s16 7.2 16 16l0 16 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0 0 16c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-16-16 0c-8.8 0-16-7.2-16-16zM96 112c0-8.8 7.2-16 16-16l160 0c8.8 0 16 7.2 16 16l0 112c0 17.7-14.3 32-32 32l-128 0c-17.7 0-32-14.3-32-32l0-112zM256 360a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm48-48a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M64 48c-8.8 0-16 7.2-16 16l0 352c0 26.5 21.5 48 48 48l192 0c26.5 0 48-21.5 48-48l0-352c0-8.8-7.2-16-16-16L64 48zM0 64C0 28.7 28.7 0 64 0L320 0c35.3 0 64 28.7 64 64l0 352c0 53-43 96-96 96L96 512c-53 0-96-43-96-96L0 64zM232 336a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm24-24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM128 288c8.8 0 16 7.2 16 16l0 16 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0 0 16c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-16-16 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0 0-16c0-8.8 7.2-16 16-16zM112 96l160 0c8.8 0 16 7.2 16 16l0 112c0 17.7-14.3 32-32 32l-128 0c-17.7 0-32-14.3-32-32l0-112c0-8.8 7.2-16 16-16z"]],
    "face-grin-tears": [640, 512, [128514, "grin-tears"], "f588", ["M64.2 246.8L90.9 243c10.6-1.5 19.6 7.5 18.1 18.1l-6.7 46.7c-2.2 15.2-10.8 28-22.9 35.8 5.6 15.2 12.5 29.8 20.7 43.5 14.6-8.2 26.9-20 35.8-34.3 34.9 66 104.2 111 184.1 111s149.2-45 184.1-111c8.9 14.3 21.2 26.1 35.8 34.3 8.2-13.7 15.2-28.3 20.7-43.5-12.1-7.9-20.7-20.7-22.9-35.8L531 261.1c-1.5-10.6 7.5-19.6 18.1-18.1l26.7 3.8c-.6-16.9-2.8-33.5-6.6-49.4l-13.4-1.9c-12.7-1.8-24.8 .2-35.4 5-24.3-87.9-104.9-152.5-200.5-152.5S143.8 112.6 119.5 200.5c-10.6-4.8-22.7-6.8-35.4-5l-13.4 1.9c-3.7 16-6 32.5-6.6 49.4zM172 208c0-37.6 30.4-68 68-68s68 30.4 68 68l0 8c0 11-9 20-20 20s-20-9-20-20l0-8c0-15.5-12.5-28-28-28s-28 12.5-28 28l0 8c0 11-9 20-20 20s-20-9-20-20l0-8zm12.2 112.1c-4.1-11.6 7.8-21.4 19.6-17.8 34.7 10.6 74.2 16.5 116.1 16.5 42 0 81.5-6 116.3-16.6 11.8-3.6 23.7 6.1 19.6 17.8-19.8 55.9-73.1 96-135.8 96-62.7 0-116-40-135.8-95.9zM332 208c0-37.6 30.4-68 68-68s68 30.4 68 68l0 8c0 11-9 20-20 20s-20-9-20-20l0-8c0-15.5-12.5-28-28-28s-28 12.5-28 28l0 8c0 11-9 20-20 20s-20-9-20-20l0-8z", "M504.1 353C512.9 367.2 525.3 379 539.8 387.2 495.1 462 413.4 512 320 512S144.9 462 100.2 387.2c14.6-8.2 26.9-20 35.8-34.3 34.9 66 104.2 111 184.1 111s149.2-45 184.1-111zm16.4-152.5C496.2 112.6 415.7 48 320 48S143.8 112.6 119.5 200.5c-10.6-4.8-22.7-6.8-35.4-5l-13.4 1.9C97.2 84.3 198.8 0 320 0S542.8 84.3 569.3 197.4l-13.4-1.9c-12.7-1.8-24.8 .2-35.4 5zM455.8 320c-19.8 55.9-73.1 96-135.8 96-62.7 0-116-40-135.8-95.9-4.1-11.6 7.8-21.4 19.6-17.8 34.7 10.6 74.2 16.5 116.1 16.5 42 0 81.5-6 116.3-16.6 11.8-3.6 23.7 6.1 19.6 17.8zM212 208l0 8c0 11-9 20-20 20s-20-9-20-20l0-8c0-37.6 30.4-68 68-68s68 30.4 68 68l0 8c0 11-9 20-20 20s-20-9-20-20l0-8c0-15.5-12.5-28-28-28s-28 12.5-28 28zm188-28c-15.5 0-28 12.5-28 28l0 8c0 11-9 20-20 20s-20-9-20-20l0-8c0-37.6 30.4-68 68-68s68 30.4 68 68l0 8c0 11-9 20-20 20s-20-9-20-20l0-8c0-15.5-12.5-28-28-28zM640 300.6c0 28.4-23 51.4-51.4 51.4-25.6 0-47.3-18.8-50.9-44.1L531 261.1c-1.5-10.6 7.5-19.6 18.1-18.1l46.7 6.7c25.3 3.6 44.1 25.3 44.1 50.9zm-640 0c0-25.6 18.8-47.3 44.1-50.9L90.9 243c10.6-1.5 19.6 7.5 18.1 18.1l-6.7 46.7C98.7 333.2 77 352 51.4 352 23 352 0 329 0 300.6z"]],
    "pen-to-square": [512, 512, ["edit"], "f044", ["M186.9 325.1l58.5-16.7c3.9-1.1 7.5-3.2 10.4-6.1L390.1 168 344 121.9 209.8 256.2c-2.9 2.9-5 6.5-6.1 10.4l-16.7 58.5z", "M441 58.9L453.1 71c9.4 9.4 9.4 24.6 0 33.9L424 134.1 377.9 88 407 58.9c9.4-9.4 24.6-9.4 33.9 0zM209.8 256.2L344 121.9 390.1 168 255.8 302.2c-2.9 2.9-6.5 5-10.4 6.1l-58.5 16.7 16.7-58.5c1.1-3.9 3.2-7.5 6.1-10.4zM373.1 25L175.8 222.2c-8.7 8.7-15 19.4-18.3 31.1l-28.6 100c-2.4 8.4-.1 17.4 6.1 23.6s15.2 8.5 23.6 6.1l100-28.6c11.8-3.4 22.5-9.7 31.1-18.3L487 138.9c28.1-28.1 28.1-73.7 0-101.8L474.9 25C446.8-3.1 401.2-3.1 373.1 25zM88 64C39.4 64 0 103.4 0 152L0 424c0 48.6 39.4 88 88 88l272 0c48.6 0 88-39.4 88-88l0-112c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 112c0 22.1-17.9 40-40 40L88 464c-22.1 0-40-17.9-40-40l0-272c0-22.1 17.9-40 40-40l112 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L88 64z"]],
    "earth-europe": [512, 512, ["globe-europe"], "f7a2", ["M48 256c0 114.9 93.1 208 208 208 5.8 0 11.5-.2 17.1-.7-.7-2.3-1.1-4.8-1.1-7.3 0-13.3-10.7-24-24-24l-21.3 0c-12 0-23.5-4.8-32-13.3l-16-16c-12-12-18.7-28.3-18.7-45.3l0-3.2c0-21.4 10.7-41.4 28.5-53.3l27.4-18.3c10.5-7 22.9-10.7 35.5-10.7l20.9 0c15.3 0 30 5.5 41.6 15.4l26.6 22.8c7.4 6.3 16.8 9.8 26.6 9.8 10.8 0 21.2 4.3 28.9 12l13.4 13.4c4.2 4.2 10 6.6 16 6.6 4.8 0 9.3 1.5 13 4.1 6.3-11.4 11.5-23.5 15.6-36.1l-7.3 0c-14.5 0-28.4-5.8-38.6-16l-18.3-18.3C386 282 384 277.1 384 272s2-10 5.7-13.7l7.5-7.5c1.8-1.8 2.8-4.3 2.8-6.8s-1-5-2.8-6.8l-6.5-6.5c-4.2-4.2-10-6.6-16-6.6l-11.3 0c-6.2 0-11.3-5.1-11.3-11.3 0-3 1.2-5.9 3.3-8L360 200c5.1-5.1 12.1-8 19.3-8l20.7 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-29.4 0c-10.3 0-18.6 8.3-18.6 18.6 0 8-5.1 15.1-12.7 17.6l-21.2 7.1c-7.5 2.5-11 11-7.5 18l1.1 2.3c3.8 7.5-1.7 16.4-10.1 16.4-3.6 0-6.9-1.7-9.1-4.5l-16.3-21.7c-2.7-3.6-6.9-5.7-11.4-5.7-5.4 0-10.4 3.1-12.8 7.9l-4 8.1c-4.9 9.8-15.1 16-26.1 16-16.4 0-29.9-13.3-29.9-29.7l0-4.3c0-9 3.6-17.6 9.9-24l17.9-17.9c2.6-2.6 4.1-6.2 4.1-10 0-6.1 3.9-11.5 9.6-13.4l26.5-8.8c7.8-2.6 14.9-7 20.7-12.8l19.9-19.9c2.1-2.1 3.3-5 3.3-8 0-6.2-5.1-11.3-11.3-11.3l-1 0c-2.4 0-4.8 .7-6.8 2.1l-41.8 27.9c-2 1.3-4.4 2.1-6.8 2.1-6.8 0-12.3-5.5-12.3-12.3l0-9.1c0-6.7 3.2-13 8.5-17.1l33.8-25.3c-3.4-.2-6.9-.3-10.3-.3-114.9 0-208 93.1-208 208zm84.7-123.3l32-32c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6l-32 32c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6z", "M256 464C141.1 464 48 370.9 48 256S141.1 48 256 48c3.5 0 6.9 .1 10.3 .3L232.5 73.6c-5.4 4-8.5 10.4-8.5 17.1l0 9.1c0 6.8 5.5 12.3 12.3 12.3 2.4 0 4.8-.7 6.8-2.1l41.8-27.9c2-1.3 4.4-2.1 6.8-2.1l1 0c6.2 0 11.3 5.1 11.3 11.3 0 3-1.2 5.9-3.3 8l-19.9 19.9c-5.8 5.8-12.9 10.2-20.7 12.8l-26.5 8.8c-5.8 1.9-9.6 7.3-9.6 13.4 0 3.7-1.5 7.3-4.1 10l-17.9 17.9c-6.4 6.4-9.9 15-9.9 24l0 4.3c0 16.4 13.6 29.7 29.9 29.7 11 0 21.2-6.2 26.1-16l4-8.1c2.4-4.8 7.4-7.9 12.8-7.9 4.5 0 8.7 2.1 11.4 5.7l16.3 21.7c2.1 2.9 5.5 4.5 9.1 4.5 8.4 0 13.9-8.9 10.1-16.4l-1.1-2.3c-3.5-7 0-15.5 7.5-18l21.2-7.1c7.6-2.5 12.7-9.6 12.7-17.6 0-10.3 8.3-18.6 18.6-18.6l29.4 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-20.7 0c-7.2 0-14.2 2.9-19.3 8l-4.7 4.7c-2.1 2.1-3.3 5-3.3 8 0 6.2 5.1 11.3 11.3 11.3l11.3 0c6 0 11.8 2.4 16 6.6l6.5 6.5c1.8 1.8 2.8 4.3 2.8 6.8s-1 5-2.8 6.8l-7.5 7.5C386 262 384 266.9 384 272s2 10 5.7 13.7L408 304c10.2 10.2 24.1 16 38.6 16l7.3 0c-4.1 12.6-9.3 24.7-15.6 36.1-3.7-2.6-8.2-4.1-13-4.1-6 0-11.8-2.4-16-6.6L396 332c-7.7-7.7-18-12-28.9-12-9.7 0-19.2-3.5-26.6-9.8L314 287.4c-11.6-9.9-26.4-15.4-41.6-15.4l-20.9 0c-12.6 0-25 3.7-35.5 10.7L188.5 301c-17.8 11.9-28.5 31.9-28.5 53.3l0 3.2c0 17 6.7 33.3 18.7 45.3l16 16c8.5 8.5 20 13.3 32 13.3l21.3 0c13.3 0 24 10.7 24 24 0 2.5 .4 5 1.1 7.3-5.7 .5-11.4 .7-17.1 .7zm0 48a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM187.3 123.3c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-32 32c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l32-32z"]],
    "table-picnic": [512, 512, [], "e32d", ["M158.2 240l53.1-128 89.3 0 53.1 128-195.5 0z", "M78.2 433.2c-5.1 12.2-19.1 18-31.3 13s-18-19.1-13-31.3l32.7-78.8 51.9 0-40.3 97.2zm400-18.4l.8 2.3c3.5 11.6-2.3 24.3-13.8 29s-24.5 0-30.3-10.8l-1-2.2-40.3-97.2 51.9 0 32.7 78.8zM424 64c13.3 0 24 10.7 24 24s-10.7 24-24 24l-71.4 0 53.1 128 82.3 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 288c-13.3 0-24-10.7-24-24s10.7-24 24-24l82.3 0 53.1-128-71.4 0c-13.3 0-24-10.7-24-24S74.7 64 88 64l336 0zM158.2 240l195.5 0-53.1-128-89.3 0-53.1 128z"]],
    "face-grin-beam-sweat": [576, 512, [128517, "grin-beam-sweat"], "f583", ["M80 256c0-114.9 93.1-208 208-208 34.7 0 67.4 8.5 96.4 23.6-.2 2.7-.4 5.5-.4 8.4 0 58.4 44.7 106.4 101.8 111.6 6.6 20.3 10.2 42 10.2 64.4 0 114.9-93.1 208-208 208S80 370.9 80 256zm60-48l0 8c0 11 9 20 20 20s20-9 20-20l0-8c0-15.5 12.5-28 28-28s28 12.5 28 28l0 8c0 11 9 20 20 20s20-9 20-20l0-8c0-37.6-30.4-68-68-68s-68 30.4-68 68zm12.2 112.1c19.8 55.9 73.1 95.9 135.8 95.9 62.7 0 116-40.1 135.8-96 4.1-11.6-7.8-21.4-19.6-17.8-34.8 10.6-74.3 16.6-116.3 16.6-41.9 0-81.4-6-116.1-16.5-11.8-3.6-23.7 6.1-19.6 17.8zM300 208l0 8c0 11 9 20 20 20s20-9 20-20l0-8c0-15.5 12.5-28 28-28s28 12.5 28 28l0 8c0 11 9 20 20 20s20-9 20-20l0-8c0-37.6-30.4-68-68-68s-68 30.4-68 68z", "M530.2 15.9c-8.8-10.7-18.5-20.9-29-30-3-2.6-7.4-2.6-10.4 0-10.5 9.1-20.1 19.3-29 30-14.7 17.8-29.8 40.1-29.8 64.1 0 36.4 27.6 64 64 64s64-27.6 64-64c0-24-15.2-46.3-29.8-64.1zm-132 8.9C364.8 8.9 327.4 0 288 0 146.6 0 32 114.6 32 256S146.6 512 288 512 544 397.4 544 256c0-24.4-3.4-48-9.8-70.4-11.9 4.2-24.7 6.4-38.2 6.4-3.4 0-6.8-.1-10.2-.4 6.6 20.3 10.2 41.9 10.2 64.4 0 114.9-93.1 208-208 208S80 370.9 80 256 173.1 48 288 48c34.8 0 67.5 8.5 96.3 23.6 1.4-17.4 6.9-33.1 13.8-46.8zM423.8 320c4.1-11.6-7.8-21.4-19.6-17.8-34.8 10.6-74.3 16.6-116.3 16.6-41.9 0-81.4-6-116.1-16.5-11.8-3.6-23.7 6.1-19.6 17.8 19.8 55.9 73.1 95.9 135.8 95.9 62.7 0 116-40.1 135.8-96zM180 208c0-15.5 12.5-28 28-28s28 12.5 28 28l0 8c0 11 9 20 20 20s20-9 20-20l0-8c0-37.6-30.4-68-68-68s-68 30.4-68 68l0 8c0 11 9 20 20 20s20-9 20-20l0-8zm188-28c15.5 0 28 12.5 28 28l0 8c0 11 9 20 20 20s20-9 20-20l0-8c0-37.6-30.4-68-68-68s-68 30.4-68 68l0 8c0 11 9 20 20 20s20-9 20-20l0-8c0-15.5 12.5-28 28-28z"]],
    "circle-half-stroke": [512, 512, [9680, "adjust"], "f042", ["M48 256c0 106.8 80.4 194.7 184 206.6l0-413.3C128.4 61.3 48 149.2 48 256z", "M280 462.6l0-413.3C383.6 61.3 464 149.2 464 256S383.6 450.7 280 462.6zm-48 0C128.4 450.7 48 362.8 48 256S128.4 61.3 232 49.4l0 413.3zM256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512z"]],
    "ruler-triangle": [512, 512, [128208], "f61c", ["M80 70.6L163.7 154.3 127 191c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l36.7-36.7 46.1 46.1-12.7 12.7c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l12.7-12.7 46.1 46.1-36.7 36.7c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l36.7-36.7 83.7 83.7-361.4 0 0-361.4zm80 204.7l0 68.6c0 4.4 3.6 8 8 8l68.6 0c4.3 0 6.4-5.2 3.4-8.2L168.2 272c-3-3-8.2-.9-8.2 3.4z", "M80 70.6L163.7 154.3 127 191c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l36.7-36.7 46.1 46.1-12.7 12.7c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l12.7-12.7 46.1 46.1-36.7 36.7c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l36.7-36.7 83.7 83.7-361.4 0 0-361.4zM86.6 9.4C77.5 .2 63.7-2.5 51.8 2.4S32 19.1 32 32l0 416c0 17.7 14.3 32 32 32l416 0c12.9 0 24.6-7.8 29.6-19.8s2.2-25.7-6.9-34.9L86.6 9.4zM168.2 272c-3-3-8.2-.9-8.2 3.4l0 68.6c0 4.4 3.6 8 8 8l68.6 0c4.3 0 6.4-5.2 3.4-8.2L168.2 272z"]],
    "octagon-plus": [512, 512, ["plus-octagon"], "f301", ["M48.5 181.6l133.5-133.5 148.8 0 133.5 133.5 0 148.8-133.5 133.5-148.8 0-133.5-133.5 0-148.8zM144.4 256c0 13.3 10.7 24 24 24l64 0 0 64c0 13.3 10.7 24 24 24s24-10.7 24-24l0-64 64 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-64 0 0-64c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 64-64 0c-13.3 0-24 10.7-24 24z", "M330.9 .1c12.7 0 24.9 5.1 33.9 14.1L498.3 147.6c9 9 14.1 21.2 14.1 33.9l0 148.8c0 12.7-5.1 24.9-14.1 33.9L364.8 497.9c-9 9-21.2 14.1-33.9 14.1l-148.8 0c-12.7 0-24.9-5.1-33.9-14.1L14.6 364.4c-9-9-14.1-21.2-14.1-33.9l0-148.8c0-12.7 5.1-24.9 14.1-33.9L148.1 14.1c9-9 21.2-14.1 33.9-14.1l148.8 0zM48.5 181.6l0 148.8 133.5 133.5 148.8 0 133.5-133.5 0-148.8-133.5-133.5-148.8 0-133.5 133.5zM232.4 344l0-64-64 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l64 0 0-64c0-13.3 10.7-24 24-24s24 10.7 24 24l0 64 64 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-64 0 0 64c0 13.3-10.7 24-24 24s-24-10.7-24-24z"]],
    "user-cowboy": [448, 512, [], "f8ea", ["M25.3 512c12.6-.7 22.7-11.1 22.7-24 0-66.3 53.7-120 120-120l112 0c66.3 0 120 53.7 120 120 0 13 10.3 23.5 23.2 24-132.6 0-265.2 0-397.8 0zm119-360.8c23.5 5.6 50 8.9 79.7 8.9s56.2-3.3 79.7-8.9C300.1 192 265.8 224 224 224s-76.1-32-79.7-72.9z", "M420.7 36.7c-10.6 10.6-38.6 29.6-83 43.2-9.8-53.7-29.9-111.9-64-111.9-8.9 0-17.7 3.8-25.5 8-7.7 4.2-17.4 8-24.1 8s-16.4-3.8-24.1-8c-7.9-4.3-16.6-8-25.5-8-34.1 0-54.2 58.2-64 111.9-44.4-13.6-72.4-32.5-83-43.2-5.5-5.5-14.3-6.3-20.7-1.7s-8.5 13.1-5 20.1c11.6 23.1 42 57 94.3 80l0 8.9c0 70.7 57.3 128 128 128s128-57.3 128-128l0-8.9c52.3-22.9 82.8-56.8 94.3-80 3.5-7 1.4-15.5-5-20.1s-15.1-3.9-20.7 1.7zm-117 114.5C300.1 192 265.8 224 224 224s-76.1-32-79.7-72.9c23.5 5.6 50 8.9 79.7 8.9s56.2-3.3 79.7-8.9zM48 488c0-66.3 53.7-120 120-120l112 0c66.3 0 120 53.7 120 120 0 13.3 10.7 24 24 24s24-10.7 24-24c0-92.8-75.2-168-168-168l-112 0c-92.8 0-168 75.2-168 168 0 13.3 10.7 24 24 24s24-10.7 24-24z"]],
    "bookmark-plus": [384, 512, [], "e755", ["M48 64c0-8.8 7.2-16 16-16l256 0c8.8 0 16 7.2 16 16l0 387.2-117.4-78.2c-16.1-10.7-37.1-10.7-53.2 0L48 451.2 48 64zM96 208c0 13.3 10.7 24 24 24l48 0 0 48c0 13.3 10.7 24 24 24s24-10.7 24-24l0-48 48 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0 0-48c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 48-48 0c-13.3 0-24 10.7-24 24z", "M64 0C28.7 0 0 28.7 0 64L0 481.1c0 25.6 28.5 40.8 49.8 26.6L192 412.8 334.2 507.7c21.3 14.2 49.8-1.1 49.8-26.6L384 64c0-35.3-28.7-64-64-64L64 0zM48 64c0-8.8 7.2-16 16-16l256 0c8.8 0 16 7.2 16 16l0 387.2-117.4-78.2c-16.1-10.7-37.1-10.7-53.2 0L48 451.2 48 64zm144 48c-13.3 0-24 10.7-24 24l0 48-48 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l48 0 0 48c0 13.3 10.7 24 24 24s24-10.7 24-24l0-48 48 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0 0-48c0-13.3-10.7-24-24-24z"]],
    "person-military-to-person": [512, 512, [], "e54c", ["M53 208.6c8.8-8 19.9-13.6 32.1-15.7L222.2 298.5c-3.8 10.9-13.3 19.2-25 21.1L53 208.6zM336 256c0-8.8 7.2-16 16-16l64 0c8.8 0 16 7.2 16 16l0 16-96 0 0-16z", "M71 12.5L182.2 .1C191.7-1 200 6.5 200 16l0 14.1c0 8.8-7.2 16-16 16l-111.1 0c-9.3 0-16.9-7.6-16.9-16.9 0-8.6 6.5-15.8 15-16.8zM384 32a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM336 256l0 16 96 0 0-16c0-8.8-7.2-16-16-16l-64 0c-8.8 0-16 7.2-16 16zm-48 0c0-35.3 28.7-64 64-64l64 0c35.3 0 64 28.7 64 64l0 32c0 17.7-14.3 32-32 32l-128 0c-17.7 0-32-14.3-32-32l0-32zM66 80l124 0c1.3 5.1 2 10.5 2 16 0 35.3-28.7 64-64 64S64 131.3 64 96c0-5.5 .7-10.9 2-16zM224 432c0 6.9-3 13.5-8.2 18.1l-64 56c-10 8.7-25.1 7.7-33.9-2.3s-7.7-25.1 2.3-33.9L136.1 456 24 456c-13.3 0-24-10.7-24-24s10.7-24 24-24l112.1 0-15.9-13.9c-10-8.7-11-23.9-2.3-33.9s23.9-11 33.9-2.3l64 56c5.2 4.6 8.2 11.1 8.2 18.1zm72.2 18.1c-5.2-4.6-8.2-11.1-8.2-18.1s3-13.5 8.2-18.1l64-56c10-8.7 25.1-7.7 33.9 2.3s7.7 25.1-2.3 33.9L375.9 408 488 408c13.3 0 24 10.7 24 24s-10.7 24-24 24l-112.1 0 15.9 13.9c10 8.7 11 23.9 2.3 33.9s-23.9 11-33.9 2.3l-64-56zM32 256c0-18.8 8.1-35.7 21-47.4l144.2 111c-1.7 .3-3.4 .4-5.2 .4L64 320c-17.7 0-32-14.3-32-32l0-32zm192 32c0 3.7-.6 7.2-1.8 10.5L85.1 192.9c3.6-.6 7.2-.9 10.9-.9l64 0c35.3 0 64 28.7 64 64l0 32z"]],
    "image-music": [640, 512, [], "e770", ["M112 96c0-8.8 7.2-16 16-16l320 0c8.8 0 16 7.2 16 16l0 111.4-52.9 9.6c-17.9 3.3-33.3 13-43.8 26.5l-18.6-31.6c-4.3-7.3-12.2-11.8-20.7-11.8s-16.4 4.5-20.7 11.8l-46.5 79-17.2-24.6c-4.5-6.4-11.8-10.2-19.7-10.2s-15.2 3.8-19.7 10.2l-56 80c-5.1 7.3-5.8 16.9-1.6 24.8S159.1 384 168 384l184 0 0 19.8c-15.3 3.8-29.7 10.5-42.1 19.7-3.4 2.6-6.8 5.4-9.9 8.5l-172 0c-8.8 0-16-7.2-16-16l0-320zm48 64a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M128 80l320 0c8.8 0 16 7.2 16 16l0 111.4 48-8.7 0-102.7c0-35.3-28.7-64-64-64L128 32C92.7 32 64 60.7 64 96l0 320c0 35.3 28.7 64 64 64l145.5 0c3.7-19.4 13.9-35.7 26.5-48l-172 0c-8.8 0-16-7.2-16-16l0-320c0-8.8 7.2-16 16-16zM348.7 211.8c-4.3-7.3-12.2-11.8-20.7-11.8s-16.4 4.5-20.7 11.8l-46.5 79-17.2-24.6c-4.5-6.4-11.8-10.2-19.7-10.2s-15.2 3.8-19.7 10.2l-56 80c-5.1 7.3-5.8 16.9-1.6 24.8S159.1 384 168 384l184 0 0-96.2c0-16.6 5.7-32.1 15.3-44.4l-18.6-31.6zM192 192a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm432 63.9c0-7.1-3.2-13.9-8.6-18.4s-12.7-6.5-19.7-5.2l-176 32c-11.4 2.1-19.7 12-19.7 23.6l0 161.6c-5.9-1.1-11.4-1.6-16-1.6-9.5 0-22.9 2.1-34.9 7.5-11.1 5-29.1 17.2-29.1 40.5s18 35.4 29.1 40.5c11.9 5.4 25.4 7.5 34.9 7.5s22.9-2.1 34.9-7.5c11.1-5 29.1-17.2 29.1-40.5l0-139.9 128-23.3 0 84.9c-5.9-1.1-11.4-1.6-16-1.6-9.5 0-22.9 2.1-34.9 7.5-11.1 5-29.1 17.2-29.1 40.5s18 35.4 29.1 40.5c11.9 5.4 25.4 7.5 34.9 7.5s22.9-2.1 34.9-7.5c11.1-5 29.1-17.2 29.1-40.5l0-208z"]],
    "person-pinball": [512, 512, [], "e21d", ["M208 299.5l256-53.9 0 106.4-256 0 0-52.5zM400 16l64 0 0 173-63-113.4c-.7-1.2-1-2.5-1-3.9L400 16z", "M490.5-31.9C502.6-30.6 512-20.4 512-8l0 528c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-120-256 0 0 120c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-234.1-89.2-114.7c-1.6-2-4-3.2-6.5-3.2-4.5 0-8.2 3.7-8.2 8.2l0 103.7c0 9.7 3.5 19.1 9.9 26.3l24.3 27.8 5 6.2c10.9 15 16.8 33.1 16.8 51.8L112 520c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-127.9c0-8.5-2.7-16.7-7.6-23.5l-2.3-2.8-24.3-27.8c-14-16-21.8-36.7-21.8-58L8 176.2c0-31.1 25.2-56.2 56.2-56.2 17.3 0 33.7 8 44.4 21.7l86.6 111.3 223.3-47-59.5-107.2c-4.6-8.3-7.1-17.7-7.1-27.2l0-79.7 .1-2.5C353.4-22.6 363.6-32 376-32l112 0 2.5 .1zM208 299.5l0 52.5 256 0 0-106.4-256 53.9zM400 71.7c0 1.4 .3 2.7 1 3.9l63 113.4 0-173-64 0 0 55.7zM64 80A56 56 0 1 1 64-32 56 56 0 1 1 64 80z"]],
    "mouse-field": [512, 512, [], "e5a8", ["M136 332.6c0 19.6 15.9 35.4 35.4 35.4l121.1 0 45.2-112.9C341.4 246 350.2 240 360 240l96 0c4.4 0 8-3.6 8-8l0-7.7c0-41.8-32.2-76.6-73.9-79.8l-8-.6C369.7 143 360 132.5 360 120l0-16c0-30.9-25.1-56-56-56s-56 25.1-56 56l0 3.2c0 22.4 13.4 42.6 33.9 51.5l7.5 3.2c10.5 4.5 16.3 15.7 14.1 26.9S291.4 208 280 208l-19.4 0C191.8 208 136 263.8 136 332.6zM416 196a20 20 0 1 1 -40 0 20 20 0 1 1 40 0zM393.4 50.8c8.4 14.1 13.6 30.4 14.5 47.8 11.9 2.2 23.2 6.1 33.6 11.4 4.1-6.3 6.5-13.8 6.5-21.9 0-22.1-17.9-40-40-40-5.2 0-10.1 1-14.6 2.8z", "M393.4 50.8c4.5-1.8 9.5-2.8 14.6-2.8 22.1 0 40 17.9 40 40 0 8.1-2.4 15.6-6.5 21.9-10.4-5.3-21.7-9.1-33.6-11.4-.9-17.4-6.1-33.7-14.5-47.8zm86.2 88.4C489.9 124.8 496 107.1 496 88 496 39.4 456.6 0 408 0 389.6 0 372.5 5.7 358.4 15.3 342.5 5.6 323.9 0 304 0 246.6 0 200 46.6 200 104l0 3.2c0 21.2 6.4 41.3 17.7 58.1-74.6 19-129.7 86.7-129.7 167.2 0 12.7 2.8 24.7 7.9 35.4L72 368c-39.8 0-72 32.2-72 72s32.2 72 72 72l384 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L72 464c-13.3 0-24-10.7-24-24s10.7-24 24-24l320 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-47.8 0 32-80 79.8 0c30.9 0 56-25.1 56-56l0-7.7c0-32.6-12.2-62.4-32.4-85.1zM292.6 368l-121.1 0c-19.6 0-35.4-15.9-35.4-35.4 0-68.8 55.8-124.6 124.6-124.6l19.4 0c11.4 0 21.2-8 23.5-19.2s-3.6-22.4-14.1-26.9l-7.5-3.2c-20.6-8.8-33.9-29.1-33.9-51.5l0-3.2c0-30.9 25.1-56 56-56s56 25.1 56 56l0 16c0 12.5 9.7 23 22.2 23.9l8 .6c41.7 3.2 73.9 38 73.9 79.8l0 7.7c0 4.4-3.6 8-8 8l-96 0c-9.8 0-18.6 6-22.3 15.1L292.6 368zM396 216a20 20 0 1 0 0-40 20 20 0 1 0 0 40z"]],
    "table-cells-column-lock": [640, 512, [], "e678", ["M112 216l0 200c0 8.8 7.2 16 16 16l72 0 0-216-88 0zm136 0l0 216 80 0 0-216-80 0zm128 0l0 113.5c5.6-12.7 13.8-24 24-33.1l0-24.4c0-20.1 4.6-39.1 12.9-56L376 216z", "M64 168l0 248c0 35.3 28.7 64 64 64l241.3 0c-.9-5.2-1.3-10.6-1.3-16.1l0-96c0-13.7 2.9-26.7 8-38.4l0-113.5 36.9 0c18.6-38.1 55.4-65.6 99.1-71l0-49c0-35.3-28.7-64-64-64L128 32C92.7 32 64 60.7 64 96l0 72zm264 48l0 216-80 0 0-216 80 0zM128 432c-8.8 0-16-7.2-16-16l0-200 88 0 0 216-72 0zM560 272.1l0 47.9-64 0 0-47.9c0-17.7 14.3-32 32-32s32 14.3 32 32zM416 368l0 96c0 26.5 21.5 48 48 48l128 0c26.5 0 48-21.5 48-48l0-96c0-20.9-13.4-38.7-32-45.3l0-50.6c0-44.2-35.8-80-80-80s-80 35.8-80 80l0 50.6c-18.6 6.6-32 24.4-32 45.3z"]],
    "truck-field-un": [640, 512, [], "e58e", ["M80 96l0 240 4.1 0c16.1-19.5 40.6-32 67.9-32s51.7 12.5 67.9 32l148.1 0 0-240c0-8.8-7.2-16-16-16L96 80c-8.8 0-16 7.2-16 16zm28 48c0-11 9-20 20-20s20 9 20 20l0 64c0 6.6 5.4 12 12 12s12-5.4 12-12l0-64c0-11 9-20 20-20s20 9 20 20l0 64c0 28.7-23.3 52-52 52s-52-23.3-52-52l0-64zm128 0c0-8.8 5.8-16.6 14.2-19.1s17.5 .7 22.4 8l27.4 41 0-29.9c0-11 9-20 20-20s20 9 20 20l0 96c0 8.8-5.8 16.6-14.2 19.1s-17.5-.7-22.4-8l-27.4-41 0 29.9c0 11-9 20-20 20s-20-9-20-20l0-96zM416 256l0 57.6c12-6.1 25.6-9.6 40-9.6 26.1 0 49.5 11.4 65.7 29.4 1.6 .8 3.2 1.7 4.8 2.6l33.6 0 0-80-144 0z", "M96 80c-8.8 0-16 7.2-16 16l0 240 4.1 0c16.1-19.5 40.6-32 67.9-32s51.7 12.5 67.9 32l148.1 0 0-240c0-8.8-7.2-16-16-16L96 80zM64.6 381.5C45.7 375.1 32 357.1 32 336l0-48c-17.7 0-32-14.3-32-32l0-96c0-17.7 14.3-32 32-32l0-32c0-35.3 28.7-64 64-64l256 0c29.8 0 54.9 20.4 62 48l18.6 0c28.6 0 54.5 16.9 66 43.1l37.1 84.9 24.3 0c26.5 0 48 21.5 48 48l0 80c0 26.5-21.5 48-48 48l-16.4 0c.2 2.6 .4 5.3 .4 8 0 48.6-39.4 88-88 88s-88-39.4-88-88c0-2.7 .1-5.4 .4-8l-128.7 0c.2 2.6 .4 5.3 .4 8 0 48.6-39.4 88-88 88s-88-39.4-88-88c0-3.6 .2-7.1 .6-10.5zM416 313.6c12-6.1 25.6-9.6 40-9.6 27.3 0 51.7 12.5 67.9 32l36.1 0 0-80-144 0 0 57.6zM416 208l67.3 0-28.7-65.6c-3.8-8.7-12.5-14.4-22-14.4l-16.6 0 0 80zM152 432a40 40 0 1 0 0-80 40 40 0 1 0 0 80zm344-40a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zM272.6 132.9l27.4 41 0-29.9c0-11 9-20 20-20s20 9 20 20l0 96c0 8.8-5.8 16.6-14.2 19.1s-17.5-.7-22.4-8l-27.4-41 0 29.9c0 11-9 20-20 20s-20-9-20-20l0-96c0-8.8 5.8-16.6 14.2-19.1s17.5 .7 22.4 8zM148 144l0 64c0 6.6 5.4 12 12 12s12-5.4 12-12l0-64c0-11 9-20 20-20s20 9 20 20l0 64c0 28.7-23.3 52-52 52s-52-23.3-52-52l0-64c0-11 9-20 20-20s20 9 20 20z"]],
    "clock": [512, 512, [128339, "clock-four"], "f017", ["M464 256a208 208 0 1 1 -416 0 208 208 0 1 1 416 0zM232 120l0 136c0 8 4 15.5 10.7 20l96 64c11 7.4 25.9 4.4 33.3-6.7s4.4-25.9-6.7-33.3L280 243.2 280 120c0-13.3-10.7-24-24-24s-24 10.7-24 24z", "M464 256a208 208 0 1 1 -416 0 208 208 0 1 1 416 0zM0 256a256 256 0 1 0 512 0 256 256 0 1 0 -512 0zM232 120l0 136c0 8 4 15.5 10.7 20l96 64c11 7.4 25.9 4.4 33.3-6.7s4.4-25.9-6.7-33.3L280 243.2 280 120c0-13.3-10.7-24-24-24s-24 10.7-24 24z"]],
    "layer-minus": [512, 512, ["layer-group-minus"], "f5fe", ["M81.2 224l171.4 79.2c2.1 1 4.6 1 6.7 0L430.8 224 259.4 144.7c-2.1-1-4.6-1-6.7 0L81.2 224zm0 160l171.4 79.2c2.1 1 4.6 1 6.7 0l171.4-79.2-58.7-27.1c-24.2 11.2-48.3 22.3-72.5 33.5-27.7 12.8-59.6 12.8-87.3 0-24.2-11.2-48.3-22.3-72.5-33.5L81.2 384z", "M376 24c-13.3 0-24 10.7-24 24s10.7 24 24 24l112 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L376 24zM259.4 144.7L430.8 224 259.4 303.2c-2.1 1-4.6 1-6.7 0L81.2 224 252.6 144.7c2.1-1 4.6-1 6.7 0zm20.1-43.6c-14.9-6.9-32.1-6.9-47 0L13.9 202.2C5.4 206.1 0 214.6 0 224s5.4 17.9 13.9 21.8l218.6 101c14.9 6.9 32.1 6.9 47 0l218.6-101c8.5-3.9 13.9-12.4 13.9-21.8s-5.4-17.9-13.9-21.8l-218.6-101zM82.7 330.4L13.9 362.2C5.4 366.1 0 374.6 0 384s5.4 17.9 13.9 21.8l218.6 101c14.9 6.9 32.1 6.9 47 0l218.6-101c8.5-3.9 13.9-12.4 13.9-21.8s-5.4-17.9-13.9-21.8l-68.7-31.8-57.2 26.4 58.7 27.1-171.4 79.2c-2.1 1-4.6 1-6.7 0L81.2 384 139.9 356.9 82.7 330.4z"]],
    "circle-euro": [512, 512, [], "e5ce", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm72-32c0-8.8 7.2-16 16-16l16.1 0c19.6-51.5 69.5-88 127.8-88l33 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-33 0c-31 0-58.3 15.9-74.2 40l50.3 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-63.3 0c-1 5.4-1.6 11-1.6 16.8 0 5.2 .4 10.3 1.3 15.2l63.5 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-51.2 0c15.7 24.9 43.5 41.5 75.2 41.5l33 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-33 0c-58.9 0-109.1-37.3-128.4-89.5L136 304c-8.8 0-16-7.2-16-16s7.2-16 16-16l8 0c-.6-5-.8-10.1-.8-15.2 0-5.7 .3-11.3 1-16.8l-8.2 0c-8.8 0-16-7.2-16-16z", "M464 256a208 208 0 1 0 -416 0 208 208 0 1 0 416 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zM279.9 120l33 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-33 0c-31 0-58.3 15.9-74.2 40l50.3 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-63.3 0c-1 5.4-1.6 11-1.6 16.8 0 5.2 .4 10.3 1.3 15.2l63.5 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-51.2 0c15.7 24.9 43.5 41.5 75.2 41.5l33 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-33 0c-58.9 0-109.1-37.3-128.4-89.5L136 304c-8.8 0-16-7.2-16-16s7.2-16 16-16l8 0c-.6-5-.8-10.1-.8-15.2 0-5.7 .3-11.3 1-16.8l-8.2 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l16.1 0c19.6-51.5 69.5-88 127.8-88z"]],
    "book": [448, 512, [128212], "f02d", ["M48 88l0 270.7c9.8-4.3 20.6-6.7 32-6.7l296 0c13.3 0 24-10.7 24-24l0-256c0-13.3-10.7-24-24-24L88 48C65.9 48 48 65.9 48 88zm80 64c0-13.3 10.7-24 24-24l176 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-176 0c-13.3 0-24-10.7-24-24zm0 96c0-13.3 10.7-24 24-24l176 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-176 0c-13.3 0-24-10.7-24-24z", "M88 0C39.4 0 0 39.4 0 88L0 432c0 44.2 35.8 80 80 80l344 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-8 0 0-76.1C435.3 375 448 353 448 328l0-256c0-39.8-32.2-72-72-72L88 0zM368 400l0 64-288 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l288 0zM80 352c-11.4 0-22.2 2.4-32 6.7L48 88c0-22.1 17.9-40 40-40l288 0c13.3 0 24 10.7 24 24l0 256c0 13.3-10.7 24-24 24L80 352zm48-200c0 13.3 10.7 24 24 24l176 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-176 0c-13.3 0-24 10.7-24 24zm24 72c-13.3 0-24 10.7-24 24s10.7 24 24 24l176 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-176 0z"]],
    "face-laugh-wink": [512, 512, ["laugh-wink"], "f59c", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm70.3 58.2c-4.2-13.7 7.1-26.2 21.4-26.2l232.6 0c14.3 0 25.6 12.5 21.4 26.2-18 58.9-72.9 101.8-137.7 101.8S136.3 373.1 118.3 314.2zM208 192a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm60 8c0-33.1 26.9-60 60-60l16 0c33.1 0 60 26.9 60 60 0 11-9 20-20 20s-20-9-20-20-9-20-20-20l-16 0c-11 0-20 9-20 20s-9 20-20 20-20-9-20-20z", "M464 256a208 208 0 1 0 -416 0 208 208 0 1 0 416 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm118.3 58.2c-4.2-13.7 7.1-26.2 21.4-26.2l232.6 0c14.3 0 25.6 12.5 21.4 26.2-18 58.9-72.9 101.8-137.7 101.8S136.3 373.1 118.3 314.2zM144 192a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm164 8c0 11-9 20-20 20s-20-9-20-20c0-33.1 26.9-60 60-60l16 0c33.1 0 60 26.9 60 60 0 11-9 20-20 20s-20-9-20-20-9-20-20-20l-16 0c-11 0-20 9-20 20z"]],
    "transducer": [384, 512, [], "e826", ["M48 432l0 64 48 0 0-64-48 0zm64-320l0 272 160 0 0-272-160 0zm32 320l0 64 96 0 0-64-96 0zm144 0l0 64 48 0 0-64-48 0z", "M248-32c13.3 0 24 10.7 24 24l0 72c26.5 0 48 21.5 48 48l0 272 16 0c26.5 0 48 21.5 48 48l0 64-.2 4.9C381.3 525.1 360.9 544 336 544L48 544C23.1 544 2.7 525.1 .2 500.9L0 496 0 432c0-26.5 21.5-48 48-48l16 0 0-272c0-26.5 21.5-48 48-48l0-72c0-13.3 10.7-24 24-24s24 10.7 24 24l0 72 64 0 0-72c0-13.3 10.7-24 24-24zM48 496l48 0 0-64-48 0 0 64zm96 0l96 0 0-64-96 0 0 64zm144 0l48 0 0-64-48 0 0 64zM112 384l160 0 0-272-160 0 0 272z"]],
    "user-doctor-hair-long": [448, 512, [], "e459", ["M25.4 512c39.5 0 79.1 0 118.6 0-26.5 0-48-21.5-48-48 0-17.8 9.7-33.3 24-41.6l0-44.4c-42.4 18.5-72 60.8-72 110 0 12.8-10 23.3-22.6 24zM144 128l0 16c0 44.2 35.8 80 80 80s80-35.8 80-80l0-16c0-20.2-7.5-38.6-19.8-52.7l-33.1 28.9c-17.5 15.3-40 23.8-63.2 23.8L144 128zm0 384l278 0c-12.3-1.1-22-11.4-22-24 0-55.2-37.3-101.7-88-115.7l0 36.7c21.2 9.3 36 30.4 36 55l0 24c0 11-9 20-20 20s-20-9-20-20l0-24c0-11-9-20-20-20s-20 9-20 20l0 24c0 11-9 20-20 20s-20-9-20-20l0-24c0-24.6 14.8-45.7 36-55l0-41-96 0 0 54.4c14.3 8.3 24 23.8 24 41.6 0 26.5-21.5 48-48 48z", "M304 128c0-20.2-7.5-38.6-19.8-52.7l-33.1 28.9c-17.5 15.3-40 23.8-63.2 23.8l-43.9 0 0 16c0 44.2 35.8 80 80 80s80-35.8 80-80l0-16zM96 128c0-38.9 17.4-73.8 44.8-97.3 3.6-3.8 7.9-7.1 12.6-9.5 20.2-13.4 44.5-21.2 70.6-21.2 70.7 0 128 57.3 128 128l0 24.2c0 25.5 10.1 49.9 28.1 67.9l13.3 13.3c4.2 4.2 6.6 10 6.6 16 0 12.5-10.1 22.6-22.6 22.6L70.6 272c-12.5 0-22.6-10.1-22.6-22.6 0-6 2.4-11.8 6.6-16l13.3-13.3c18-18 28.1-42.4 28.1-67.9L96 128zm72 294.4c14.3 8.3 24 23.8 24 41.6 0 26.5-21.5 48-48 48s-48-21.5-48-48c0-17.8 9.7-33.3 24-41.6l0-44.4c-42.4 18.5-72 60.8-72 110 0 13.3-10.7 24-24 24S0 501.3 0 488c0-92.8 75.2-168 168-168l112 0c92.8 0 168 75.2 168 168 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-55.2-37.3-101.7-88-115.7l0 36.7c21.2 9.3 36 30.4 36 55l0 24c0 11-9 20-20 20s-20-9-20-20l0-24c0-11-9-20-20-20s-20 9-20 20l0 24c0 11-9 20-20 20s-20-9-20-20l0-24c0-24.6 14.8-45.7 36-55l0-41-96 0 0 54.4z"]],
    "cloud-meatball": [512, 512, [], "f73b", ["M48 216c0-27.4 19.8-50.3 45.9-55.1 13-2.4 21.7-14.9 19.3-27.9-.8-4.2-1.2-8.5-1.2-13 0-39.8 32.2-72 72-72 28.9 0 53.9 17.1 65.4 41.8 3.3 7.1 9.9 12.2 17.6 13.6s15.7-1.2 21.2-6.8c10.2-10.3 24.2-16.6 39.8-16.6 30.9 0 56 25.1 56 56 0 13.3 10.7 24 24 24 30.9 0 56 25.1 56 56s-25.1 56-56 56l-59.2 0c-11.2-5.7-23.8-8.5-36.5-8.1-14.2-15.1-34.2-23.9-55.4-23.9l-2 0c-21.1 0-41.1 8.8-55.4 23.9-12.7-.4-25.2 2.4-36.5 8.1L104 272c-30.9 0-56-25.1-56-56z", "M184 48c-39.8 0-72 32.2-72 72 0 4.5 .4 8.8 1.2 13 2.4 13-6.3 25.5-19.3 27.9-26.1 4.8-45.9 27.6-45.9 55.1 0 30.9 25.1 56 56 56l59.2 0c-7.2 3.6-13.8 8.3-19.6 14.2l-1.4 1.4c-9.2 9.2-15.7 20.4-19.2 32.4L104 320c-57.4 0-104-46.6-104-104 0-43.3 26.4-80.3 64-96 0-66.3 53.7-120 120-120 37.9 0 71.7 17.6 93.7 45 14.9-8.3 32.1-13 50.3-13 50 0 91.7 35.3 101.7 82.3 47 10 82.3 51.7 82.3 101.7 0 57.4-46.6 104-104 104l-18.9 0c-3.5-12.1-10.1-23.3-19.2-32.4l-1.4-1.4c-5.8-5.8-12.4-10.6-19.6-14.2l59.2 0c30.9 0 56-25.1 56-56s-25.1-56-56-56c-13.3 0-24-10.7-24-24 0-30.9-25.1-56-56-56-15.6 0-29.6 6.3-39.8 16.6-5.5 5.6-13.4 8.1-21.2 6.8s-14.3-6.4-17.6-13.6C237.9 65.1 212.9 48 184 48zM156.5 424.3c-7.8-5.2-12.5-14-12.5-23.3l0-2c0-9.4 4.7-18.1 12.5-23.3 9.5-6.3 14.2-17.7 11.9-28.8-1.8-9.2 1-18.7 7.7-25.3l1.4-1.4c6.6-6.6 16.1-9.5 25.3-7.7 11.1 2.2 22.5-2.5 28.8-11.9 5.2-7.8 14-12.5 23.3-12.5l2 0c9.4 0 18.1 4.7 23.3 12.5 6.3 9.5 17.7 14.2 28.8 11.9 9.2-1.8 18.7 1 25.3 7.7l1.4 1.4c6.6 6.6 9.5 16.1 7.7 25.3-2.2 11.1 2.5 22.5 11.9 28.8 7.8 5.2 12.5 14 12.5 23.3l0 2c0 9.4-4.7 18.1-12.5 23.3-9.5 6.3-14.2 17.7-11.9 28.8 1.8 9.2-1 18.7-7.7 25.3l-1.4 1.4c-6.6 6.6-16.1 9.5-25.3 7.7-11.1-2.2-22.5 2.5-28.8 11.9-5.2 7.8-14 12.5-23.3 12.5l-2 0c-9.4 0-18.1-4.7-23.3-12.5-6.3-9.5-17.7-14.2-28.8-11.9-9.2 1.8-18.7-1-25.3-7.7l-1.4-1.4c-6.6-6.6-9.5-16.1-7.7-25.3 2.2-11.1-2.5-22.5-11.9-28.8zM48 352a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm416 0a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"]],
    "cloud-xmark": [576, 512, [], "e35f", ["M48 336c0 53 43 96 96 96l304 0c44.2 0 80-35.8 80-80 0-37.4-25.7-68.9-60.5-77.6-7.5-1.9-13.6-7.2-16.5-14.3s-2.1-15.2 2-21.7c7-11.1 11-24.2 11-38.3 0-39.8-32.2-72-72-72-11.1 0-21.5 2.5-30.8 6.9-10.5 5-23.1 1.7-29.8-7.8-20.3-28.6-53.7-47.1-91.3-47.1-61.9 0-112 50.1-112 112 0 8.4 .9 16.6 2.7 24.5 2.7 12.1-4.3 24.3-16.1 28.1-38.7 12.4-66.6 48.7-66.6 91.4zM220.1 220.1c9.4-9.4 24.6-9.4 33.9 0l33.9 33.9 33.9-33.9c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-33.9 33.9 33.9 33.9c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-33.9-33.9-33.9 33.9c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l33.9-33.9-33.9-33.9c-9.4-9.4-9.4-24.6 0-33.9z", "M240 32c-88.4 0-160 71.6-160 160 0 4.9 .2 9.8 .7 14.6-47.8 23.4-80.7 72.5-80.7 129.4 0 79.5 64.5 144 144 144l304 0c70.7 0 128-57.3 128-128 0-49.9-28.5-93-70.1-114.2 4-11.9 6.1-24.6 6.1-37.8 0-66.3-53.7-120-120-120-11.5 0-22.7 1.6-33.3 4.7-29.3-32.3-71.6-52.7-118.7-52.7zM128 192c0-61.9 50.1-112 112-112 37.7 0 71 18.6 91.3 47.1 6.7 9.5 19.3 12.8 29.8 7.8 9.3-4.4 19.7-6.9 30.8-6.9 39.8 0 72 32.2 72 72 0 14.1-4 27.2-11 38.3-4.1 6.5-4.8 14.6-2 21.7s9 12.5 16.5 14.3c34.8 8.7 60.5 40.2 60.5 77.6 0 44.2-35.8 80-80 80l-304 0c-53 0-96-43-96-96 0-42.7 27.9-79 66.6-91.4 11.8-3.8 18.8-16 16.1-28.1-1.8-7.9-2.7-16.1-2.7-24.5zm227.9 28.1c-9.4-9.4-24.6-9.4-33.9 0l-33.9 33.9-33.9-33.9c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l33.9 33.9-33.9 33.9c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l33.9-33.9 33.9 33.9c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-33.9-33.9 33.9-33.9c9.4-9.4 9.4-24.6 0-33.9z"]],
    "chart-area": [512, 512, ["area-chart"], "f1fe", ["M160 242.8l0 77.2 272 0 0-94.1-40-40-47 47c-4.6 4.6-10.9 7.2-17.5 7s-12.7-3-17.2-7.8l-70.3-76.7-80 87.3z", "M48 56c0-13.3-10.7-24-24-24S0 42.7 0 56L0 400c0 44.2 35.8 80 80 80l408 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L80 432c-17.7 0-32-14.3-32-32L48 56zm209.7 47.8c-4.5-5-11-7.8-17.7-7.8s-13.1 2.8-17.7 7.8l-104 113.5c-4.1 4.4-6.3 10.2-6.3 16.2L112 344c0 13.3 10.7 24 24 24l320 0c13.3 0 24-10.7 24-24l0-128c0-6.4-2.5-12.5-7-17l-64-64c-9.4-9.4-24.6-9.4-33.9 0l-46.3 46.3-71.1-77.5zM160 320l0-77.2 80-87.3 70.3 76.7c4.4 4.8 10.6 7.6 17.2 7.8s12.9-2.4 17.5-7l47-47 40 40 0 94.1-272 0z"]],
    "utility-pole-double": [512, 512, [], "e2c4", ["", "M280 24c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 56-104 0 0-24c0-13.3-10.7-24-24-24S80 42.7 80 56l0 24-15.6 0c-.3 0-.5 0-.8 0L48 80 48 56c0-13.3-10.7-24-24-24S0 42.7 0 56l0 48c0 13.3 10.7 24 24 24l33.1 0 174.9 109.3 0 34.7-104 0 0-24c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 24-15.6 0c-.3 0-.5 0-.8 0l-15.6 0 0-24c0-13.3-10.7-24-24-24S0 234.7 0 248l0 48c0 13.3 10.7 24 24 24l33.1 0 174.9 109.3 0 58.7c0 13.3 10.7 24 24 24s24-10.7 24-24l0-58.7 174.9-109.3 33.1 0c13.3 0 24-10.7 24-24l0-48c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 24-15.6 0c-.3 0-.5 0-.8 0l-15.6 0 0-24c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 24-104 0 0-34.7 174.9-109.3 33.1 0c13.3 0 24-10.7 24-24l0-48c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 24-15.6 0c-.3 0-.5 0-.8 0l-15.6 0 0-24c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 24-104 0 0-56zm84.3 104l-84.3 52.7 0-52.7 84.3 0zM232 180.7l-84.3-52.7 84.3 0 0 52.7zM364.3 320l-84.3 52.7 0-52.7 84.3 0zM232 372.7l-84.3-52.7 84.3 0 0 52.7z"]],
    "rupiah-sign": [512, 512, [], "e23d", ["", "M0 56C0 42.7 10.7 32 24 32l96 0c75.1 0 136 60.9 136 136 0 54.4-32 101.4-78.1 123.1l45.2 158.3c3.6 12.7-3.7 26-16.5 29.7s-26-3.7-29.7-16.5L131.5 303.5c-3.8 .3-7.6 .5-11.5 .5l-72 0 0 152c0 13.3-10.7 24-24 24S0 469.3 0 456L0 56zM48 256l72 0c48.6 0 88-39.4 88-88s-39.4-88-88-88l-72 0 0 176zm264-32l88 0c61.9 0 112 50.1 112 112S461.9 448 400 448l-64 0 0 72c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-272c0-13.3 10.7-24 24-24zm88 176c35.3 0 64-28.7 64-64s-28.7-64-64-64l-64 0 0 128 64 0z"]],
    "diagram-nested": [448, 512, [], "e157", ["M48 80l0 96 96 0 0-96-96 0zM304 336l0 96 96 0 0-96-96 0z", "M144 80l0 96-96 0 0-96 96 0zM48 32C21.5 32 0 53.5 0 80l0 96c0 26.5 21.5 48 48 48l24 0 0 96c0 48.6 39.4 88 88 88l96 0 0 24c0 26.5 21.5 48 48 48l96 0c26.5 0 48-21.5 48-48l0-96c0-26.5-21.5-48-48-48l-96 0c-26.5 0-48 21.5-48 48l0 24-96 0c-22.1 0-40-17.9-40-40l0-96 24 0c26.5 0 48-21.5 48-48l0-96c0-26.5-21.5-48-48-48L48 32zM400 336l0 96-96 0 0-96 96 0z"]],
    "square-quarters": [448, 512, [], "e44e", ["M52.7 84.7C55.6 81.8 59.6 80 64 80l320 0c4.4 0 8.4 1.8 11.3 4.7L224 256 52.7 84.7zm0 342.6L224 256 395.3 427.3c-2.9 2.9-6.9 4.7-11.3 4.7L64 432c-4.4 0-8.4-1.8-11.3-4.7z", "M52.7 84.7L224 256 395.3 84.7c-2.9-2.9-6.9-4.7-11.3-4.7L64 80c-4.4 0-8.4 1.8-11.3 4.7zm0 342.6c2.9 2.9 6.9 4.7 11.3 4.7l320 0c4.4 0 8.4-1.8 11.3-4.7L224 256 52.7 427.3zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96z"]],
    "print-slash": [576, 512, [], "f686", ["M306.3 240l128 128 62.2 0 0-112c0-8.8-7.2-16-16-16l-174.2 0z", "M7.5-24.9c9.4-9.4 24.6-9.4 33.9 0l73 73C121.5 20.5 146.6 0 176.5 0L358 0c17 0 33.3 6.8 45.3 18.8l42.5 42.5c12 12 18.7 28.3 18.8 45.3l0 37.5-48 0 0-37.5c0-4.2-1.7-8.3-4.7-11.3L369.3 52.7c-3-3-7.1-4.7-11.3-4.7L176.5 48c-8.8 0-16 7.2-16 16l0 30.2 97.8 97.8 222.2 0c35.3 0 64 28.7 64 64l0 128c0 17.7-14.3 32-32 32l-30.2 0 87.1 87.1c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0L7.5 9.1c-9.4-9.4-9.4-24.6 0-33.9zM122.7 192l48 48-74.2 0c-8.8 0-16 7.2-16 16l0 112 48 0 0-16c0-17.7 14.3-32 32-32l90.2 0 48 48-122.2 0 0 96 218.2 0 41.3 41.3c-5.4 4.2-12.2 6.7-19.5 6.7l-256 0c-17.7 0-32-14.3-32-32l0-64-64 0c-17.7 0-32-14.3-32-32l0-128c0-35.3 28.7-64 64-64l26.2 0zM434.3 368l62.2 0 0-112c0-8.8-7.2-16-16-16l-174.2 0 128 128z"]],
    "shield-keyhole": [512, 512, [], "e248", ["M64 139.7c.5 91.4 38.4 249.3 186.4 320.1 3.6 1.7 7.8 1.7 11.3 0 148-70.8 185.9-228.7 186.3-320.1 0-5-3.1-10.2-9-12.8L256 49.4 73.1 127c-5.9 2.5-9.1 7.8-9 12.8zM200 208c0-30.9 25.1-56 56-56s56 25.1 56 56c0 22.3-13.1 41.6-32 50.6l0 69.4c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-69.4c-18.9-9-32-28.3-32-50.6z", "M73.1 127L256 49.4 439 127c5.9 2.5 9.1 7.8 9 12.8-.4 91.4-38.4 249.3-186.3 320.1-3.6 1.7-7.8 1.7-11.3 0-148-70.8-185.9-228.7-186.4-320.1 0-5 3.1-10.2 9-12.8zM457.8 82.8L269.4 2.9C265.2 1 260.7 0 256 0s-9.2 1-13.4 2.9L54.3 82.8c-22 9.3-38.4 31-38.3 57.2 .5 99.2 41.3 280.7 213.6 363.2 16.7 8 36.1 8 52.8 0 172.4-82.5 213.1-264 213.6-363.2 .1-26.2-16.3-47.9-38.3-57.2zM312 208c0-30.9-25.1-56-56-56s-56 25.1-56 56c0 22.3 13.1 41.6 32 50.6l0 69.4c0 13.3 10.7 24 24 24s24-10.7 24-24l0-69.4c18.9-9 32-28.3 32-50.6z"]],
    "square-left": [448, 512, [11013, "arrow-alt-square-left"], "f351", ["M48 96l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16zM92.7 244.7l104-104c4.6-4.6 11.5-5.9 17.4-3.5s9.9 8.3 9.9 14.8l0 72 104 0c13.3 0 24 10.7 24 24l0 16c0 13.3-10.7 24-24 24l-104 0 0 72c0 6.5-3.9 12.3-9.9 14.8s-12.9 1.1-17.4-3.5l-104-104c-6.2-6.2-6.2-16.4 0-22.6z", "M48 416c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16l0 320zm16 64c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480zM92.7 244.7l104-104c4.6-4.6 11.5-5.9 17.4-3.5s9.9 8.3 9.9 14.8l0 72 104 0c13.3 0 24 10.7 24 24l0 16c0 13.3-10.7 24-24 24l-104 0 0 72c0 6.5-3.9 12.3-9.9 14.8s-12.9 1.1-17.4-3.5l-104-104c-6.2-6.2-6.2-16.4 0-22.6z"]],
    "text-width": [448, 512, [], "f035", ["", "M40 0C17.9 0 0 17.9 0 40l0 64c0 13.3 10.7 24 24 24s24-10.7 24-24l0-56 152 0 0 192-48 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l144 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0 0-192 152 0 0 56c0 13.3 10.7 24 24 24s24-10.7 24-24l0-64c0-22.1-17.9-40-40-40L40 0zm73 393c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0L7 431c-9.4 9.4-9.4 24.6 0 33.9l72 72c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-31-31 284.1 0-31 31c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l72-72c9.4-9.4 9.4-24.6 0-33.9l-72-72c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l31 31-284.1 0 31-31z"]],
    "circle-currency": [512, 512, [], "e6ee", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zM151 151c9.4-9.4 24.6-9.4 33.9 0l22.3 22.3c14.3-8.4 31-13.3 48.8-13.3s34.5 4.8 48.8 13.3L327 151c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-22.3 22.3c8.4 14.3 13.3 31 13.3 48.8s-4.8 34.5-13.3 48.8L361 327c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-22.3-22.3c-14.3 8.4-31 13.3-48.8 13.3s-34.5-4.8-48.8-13.3L185 361c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l22.3-22.3c-8.4-14.3-13.3-31-13.3-48.8s4.8-34.5 13.3-48.8L151 185c-9.4-9.4-9.4-24.6 0-33.9zm57 105a48 48 0 1 0 96 0 48 48 0 1 0 -96 0z", "M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM151 151c-9.4 9.4-9.4 24.6 0 33.9l22.3 22.3c-8.4 14.3-13.3 31-13.3 48.8s4.8 34.5 13.3 48.8L151 327c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l22.3-22.3c14.3 8.4 31 13.3 48.8 13.3s34.5-4.8 48.8-13.3L327 361c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-22.3-22.3c8.4-14.3 13.3-31 13.3-48.8s-4.8-34.5-13.3-48.8L361 185c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-22.3 22.3c-14.3-8.4-31-13.3-48.8-13.3s-34.5 4.8-48.8 13.3L185 151c-9.4-9.4-24.6-9.4-33.9 0zm105 57a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"]],
    "signature-lock": [576, 512, [], "e3ca", ["", "M112 128c0-26.5 21.5-48 48-48s48 21.5 48 48l0 7.9c0 25.7-2 51.4-6.1 76.8L91.5 250.5C55.9 262.7 32 296.1 32 333.7L32 410c0 38.6 31.3 70 70 70 24.6 0 47.4-12.9 60-34l15.9-26.4c29.6-49.4 51.1-103.3 63.6-159.5l1.8-8.1 .6-2.9 76.8-26.3-23.3 65.1c-2.6 7.4-1.5 15.5 3 21.9 3.9 5.5 9.9 9.1 16.5 10 5.1-8.8 11.6-16.7 19.1-23.4l0-24.4c0-39.4 17.8-74.6 45.8-98.1-1.1-2.5-2.7-4.8-4.7-6.8-6.5-6.6-16.1-8.8-24.9-5.9l-99.5 34.1c2.2-19.7 3.3-39.6 3.3-59.5l0-7.9c0-53-43-96-96-96S64 75 64 128l0 40c0 13.3 10.7 24 24 24s24-10.7 24-24l0-40zM257.5 368c-6.8 16.3-14.3 32.3-22.6 48l69.1 0 0-48-46.5 0zM107.1 295.9l83.3-28.5c-11.7 44.8-29.8 87.7-53.6 127.5l-15.9 26.4c-4 6.6-11.1 10.7-18.8 10.7-12.1 0-22-9.8-22-22l0-76.3c0-17.1 10.9-32.3 27.1-37.8zM496 272.1l0 47.9-64 0 0-47.9c0-17.7 14.3-32 32-32s32 14.3 32 32zM352 368l0 96c0 26.5 21.5 48 48 48l128 0c26.5 0 48-21.5 48-48l0-96c0-20.9-13.4-38.7-32-45.3l0-50.6c0-44.2-35.8-80-80-80s-80 35.8-80 80l0 50.6c-18.6 6.6-32 24.4-32 45.3z"]],
    "satellite": [512, 512, [128752], "f7bf", ["M67.1 263.1L248.9 445c4.6-14.1 7.1-29.2 7.1-45 0-79.5-64.5-144-144-144-15.7 0-30.8 2.5-45 7.1zm149-24.6c23 14.8 42.5 34.4 57.4 57.4l168-168-57.4-57.4-168 168z", "M199.1 7c9.4-9.4 24.6-9.4 33.9 0l73.4 73.4 55-55c12.5-12.5 32.8-12.5 45.3 0l80 80c12.5 12.5 12.5 32.8 0 45.3l-55 55 73.4 73.4c9.4 9.4 9.4 24.6 0 33.9l-96 96c-9.4 9.4-24.6 9.4-33.9 0l-73.4-73.4-6.5 6.5c5.8 18.3 8.9 37.7 8.9 57.9 0 40.6-12.6 78.3-34.2 109.4-5.4 7.7-16.3 8.2-23 1.5L141 405 89 457c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l52-52-105.9-105.9c-6.6-6.6-6.2-17.6 1.5-23 31-21.5 68.7-34.2 109.4-34.2 20.2 0 39.6 3.1 57.9 8.9l6.5-6.5-73.4-73.4c-9.4-9.4-9.4-24.6 0-33.9l96-96zM335.6 301.7l56.4 56.4 62.1-62.1-56.4-56.4-62.1 62.1zM210.4 176.4l62.1-62.1-56.4-56.4-62.1 62.1 56.4 56.4zM273.4 296l168-168-57.4-57.4-168 168c23 14.8 42.5 34.4 57.4 57.4zM256 400c0-79.5-64.5-144-144-144-15.7 0-30.8 2.5-45 7.1L248.9 445c4.6-14.1 7.1-29.2 7.1-45z"]],
    "ball-pile": [640, 512, [], "f77e", ["M64 432a48 48 0 1 0 96 0 48 48 0 1 0 -96 0zm52.7-87.9c43.4 2.3 78.5 36.1 82.9 79.1 .2-2.2 .3-4.5 .3-6.8 0-40.3-32.7-73-73-73-3.4 0-6.8 .2-10.2 .7zM168 256a48 48 0 1 0 96 0 48 48 0 1 0 -96 0zM272 80a48 48 0 1 0 96 0 48 48 0 1 0 -96 0zm0 352a48 48 0 1 0 96 0 48 48 0 1 0 -96 0zM376 256a48 48 0 1 0 96 0 48 48 0 1 0 -96 0zm63.1 160.4c0 4.1 .3 8.1 1 12 1.8-45.1 37.6-81.5 82.5-84.2-3.4-.5-6.9-.7-10.5-.7-40.3 0-73 32.7-73 73zM480 432a48 48 0 1 0 96 0 48 48 0 1 0 -96 0z", "M368 80a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM232 80a88 88 0 1 1 176 0 88 88 0 1 1 -176 0zm32 176a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zm-136 0a88 88 0 1 1 176 0 88 88 0 1 1 -176 0zm296 48a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm0-136a88 88 0 1 1 0 176 88 88 0 1 1 0-176zM368 432a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zm-136 0a88 88 0 1 1 176 0 88 88 0 1 1 -176 0zM112 480a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm0-136a88 88 0 1 1 0 176 88 88 0 1 1 0-176zm464 88a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zm-136 0a88 88 0 1 1 176 0 88 88 0 1 1 -176 0z"]],
    "seats": [512, 512, [], "e765", ["M48 304l0 48 416 0 0-48-416 0zM80 64l0 192 152 0 0-192c0-8.8-7.2-16-16-16L96 48c-8.8 0-16 7.2-16 16zm200 0l0 192 152 0 0-192c0-8.8-7.2-16-16-16L296 48c-8.8 0-16 7.2-16 16z", "M96 48c-8.8 0-16 7.2-16 16l0 192 152 0 0-192c0-8.8-7.2-16-16-16L96 48zM432 256l0-192c0-8.8-7.2-16-16-16L296 48c-8.8 0-16 7.2-16 16l0 192 152 0zm48 0l0 2.7c18.6 6.6 32 24.4 32 45.3l0 48c0 20.9-13.4 38.7-32 45.3l0 90.7c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-88-152 0 0 88c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-88-152 0 0 88c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-90.7C13.4 390.7 0 372.9 0 352l0-48c0-20.9 13.4-38.7 32-45.3L32 64C32 28.7 60.7 0 96 0L216 0c15.1 0 29 5.3 40 14 11-8.8 24.9-14 40-14L416 0c35.3 0 64 28.7 64 64l0 192zM56 352l408 0 0-48-416 0 0 48 8 0z"]],
    "file-eps": [576, 512, [], "e644", ["M80 64c0-8.8 7.2-16 16-16l112 0 0 88c0 39.8 32.2 72 72 72l88 0 0 128-128 0c-35.3 0-64 28.7-64 64l0 64-80 0c-8.8 0-16-7.2-16-16L80 64z", "M208 48L96 48c-8.8 0-16 7.2-16 16l0 384c0 8.8 7.2 16 16 16l80 0 0 48-80 0c-35.3 0-64-28.7-64-64L32 64C32 28.7 60.7 0 96 0L229.5 0c17 0 33.3 6.7 45.3 18.7L397.3 141.3c12 12 18.7 28.3 18.7 45.3l0 149.5-48 0 0-128-88 0c-39.8 0-72-32.2-72-72l0-88zM348.1 160L256 67.9 256 136c0 13.3 10.7 24 24 24l68.1 0zM240 380l64 0c11 0 20 9 20 20s-9 20-20 20l-44 0 0 24 28 0c11 0 20 9 20 20s-9 20-20 20l-28 0 0 24 44 0c11 0 20 9 20 20s-9 20-20 20l-64 0c-11 0-20-9-20-20l0-128c0-11 9-20 20-20zm128 0l32 0c33.1 0 60 26.9 60 60s-26.9 60-60 60l-12 0 0 28c0 11-9 20-20 20s-20-9-20-20l0-128c0-11 9-20 20-20zm32 80c11 0 20-9 20-20s-9-20-20-20l-12 0 0 40 12 0zm76-28c0-28.7 23.3-52 52-52l24 0c11 0 20 9 20 20s-9 20-20 20l-24 0c-6.6 0-12 5.4-12 12s5.4 12 12 12c28.7 0 52 23.3 52 52s-23.3 52-52 52l-32 0c-11 0-20-9-20-20s9-20 20-20l32 0c6.6 0 12-5.4 12-12s-5.4-12-12-12c-28.7 0-52-23.3-52-52z"]],
    "magnifying-glass-minus": [512, 512, ["search-minus"], "f010", ["M48 208a160 160 0 1 0 320 0 160 160 0 1 0 -320 0zm64 0c0-13.3 10.7-24 24-24l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24z", "M208 48a160 160 0 1 1 0 320 160 160 0 1 1 0-320zm0 368c48.8 0 93.7-16.8 129.1-44.9L471 505c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9L371.1 337.1C399.2 301.7 416 256.8 416 208 416 93.1 322.9 0 208 0S0 93.1 0 208 93.1 416 208 416zM136 184c-13.3 0-24 10.7-24 24s10.7 24 24 24l144 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-144 0z"]],
    "vent-damper": [640, 512, [], "e465", ["M112 128l0 256c0 8.8 7.2 16 16 16l384 0c8.8 0 16-7.2 16-16l0-256c0-8.8-7.2-16-16-16l-384 0c-8.8 0-16 7.2-16 16zm48 40c0-13.3 10.7-24 24-24l272 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-272 0c-13.3 0-24-10.7-24-24zm0 88c0-13.3 10.7-24 24-24l272 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-272 0c-13.3 0-24-10.7-24-24zm0 88c0-13.3 10.7-24 24-24l272 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-272 0c-13.3 0-24-10.7-24-24z", "M512 112c8.8 0 16 7.2 16 16l0 256c0 8.8-7.2 16-16 16l-384 0c-8.8 0-16-7.2-16-16l0-256c0-8.8 7.2-16 16-16l384 0zM128 64c-35.3 0-64 28.7-64 64l0 32-32 0c-17.7 0-32 14.3-32 32L0 320c0 17.7 14.3 32 32 32l32 0 0 32c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-32 32 0c17.7 0 32-14.3 32-32l0-128c0-17.7-14.3-32-32-32l-32 0 0-32c0-35.3-28.7-64-64-64L128 64zm56 80c-13.3 0-24 10.7-24 24s10.7 24 24 24l272 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-272 0zm0 88c-13.3 0-24 10.7-24 24s10.7 24 24 24l272 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-272 0zm0 88c-13.3 0-24 10.7-24 24s10.7 24 24 24l272 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-272 0z"]],
    "people-group": [512, 512, [], "e533", ["M192 288l0 16c0 19.9 9 37.6 23.3 49.4 5.5 4.6 8.7 11.3 8.7 18.5l0 84.1c0 4.4 3.6 8 8 8l48 0c4.4 0 8-3.6 8-8l0-84.1c0-7.2 3.2-13.9 8.7-18.5 14.3-11.8 23.3-29.5 23.3-49.4l0-16c0-35.3-28.7-64-64-64s-64 28.7-64 64z", "M256 0a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM40 88A56 56 0 1 1 152 88 56 56 0 1 1 40 88zm63.1 152.6c-31.2 4.3-55.1 31.1-55.1 63.4 0 19.9 9 37.6 23.3 49.4 5.5 4.6 8.7 11.3 8.7 18.5L80 456c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-73.6c-19.8-20.2-32-47.9-32-78.4 0-61.9 50.1-112 112-112 5.2 0 10.2 .3 15.2 1-10.5 14.2-18.7 30.3-24.1 47.6zm305.7 0c-5.4-17.3-13.6-33.3-24.1-47.6 5-.7 10.1-1 15.2-1 61.9 0 112 50.1 112 112 0 30.5-12.2 58.2-32 78.4l0 73.6c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-84.1c0-7.2 3.2-13.9 8.7-18.5 14.3-11.8 23.3-29.5 23.3-49.4 0-32.3-24-59.1-55.1-63.4zM472 88a56 56 0 1 1 -112 0 56 56 0 1 1 112 0zM256 224c-35.3 0-64 28.7-64 64l0 16c0 19.9 9 37.6 23.3 49.4 5.5 4.6 8.7 11.3 8.7 18.5l0 84.1c0 4.4 3.6 8 8 8l48 0c4.4 0 8-3.6 8-8l0-84.1c0-7.2 3.2-13.9 8.7-18.5 14.3-11.8 23.3-29.5 23.3-49.4l0-16c0-35.3-28.7-64-64-64zM144 288c0-61.9 50.1-112 112-112s112 50.1 112 112l0 16c0 30.5-12.2 58.2-32 78.4l0 73.6c0 30.9-25.1 56-56 56l-48 0c-30.9 0-56-25.1-56-56l0-73.6c-19.8-20.2-32-47.9-32-78.4l0-16z"]],
    "square-quote": [448, 512, [], "e329", ["M48 96l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16zm48 96c0-17.7 14.3-32 32-32l48 0c17.7 0 32 14.3 32 32l0 87.3c0 35.2-25.4 65.2-60.2 71l-7.9 1.3c-13.1 2.2-25.4-6.7-27.6-19.7s6.7-25.4 19.7-27.6l7.9-1.3c11.6-1.9 20.1-11.9 20.1-23.7l0-7.3-32 0c-17.7 0-32-14.3-32-32l0-48zm144 0c0-17.7 14.3-32 32-32l48 0c17.7 0 32 14.3 32 32l0 87.3c0 35.2-25.4 65.2-60.2 71l-7.9 1.3c-13.1 2.2-25.4-6.7-27.6-19.7s6.7-25.4 19.7-27.6l7.9-1.3c11.6-1.9 20.1-11.9 20.1-23.7l0-7.3-32 0c-17.7 0-32-14.3-32-32l0-48z", "M384 80c8.8 0 16 7.2 16 16l0 320c0 8.8-7.2 16-16 16L64 432c-8.8 0-16-7.2-16-16L48 96c0-8.8 7.2-16 16-16l320 0zM64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM208 240l0-48c0-17.7-14.3-32-32-32l-48 0c-17.7 0-32 14.3-32 32l0 48c0 17.7 14.3 32 32 32l32 0 0 7.3c0 11.7-8.5 21.7-20.1 23.7l-7.9 1.3c-13.1 2.2-21.9 14.5-19.7 27.6s14.5 21.9 27.6 19.7l7.9-1.3c34.7-5.8 60.2-35.8 60.2-71l0-39.3zm144 39.3l0-87.3c0-17.7-14.3-32-32-32l-48 0c-17.7 0-32 14.3-32 32l0 48c0 17.7 14.3 32 32 32l32 0 0 7.3c0 11.7-8.5 21.7-20.1 23.7l-7.9 1.3c-13.1 2.2-21.9 14.5-19.7 27.6s14.5 21.9 27.6 19.7l7.9-1.3c34.7-5.8 60.2-35.8 60.2-71z"]],
    "square-binary": [448, 512, [], "e69b", ["M48 96l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16zm52 56c0-24.3 19.7-44 44-44l32 0c24.3 0 44 19.7 44 44l0 40c0 24.3-19.7 44-44 44l-32 0c-24.3 0-44-19.7-44-44l0-40zm32 144c0-11 9-20 20-20l16 0c11 0 20 9 20 20l0 88c0 11-9 20-20 20s-20-9-20-20l0-68.4c-9.1-1.9-16-9.9-16-19.6zm8-144l0 40c0 2.2 1.8 4 4 4l32 0c2.2 0 4-1.8 4-4l0-40c0-2.2-1.8-4-4-4l-32 0c-2.2 0-4 1.8-4 4zm88 168c0-24.3 19.7-44 44-44l32 0c24.3 0 44 19.7 44 44l0 40c0 24.3-19.7 44-44 44l-32 0c-24.3 0-44-19.7-44-44l0-40zm32-192c0-11 9-20 20-20l16 0c11 0 20 9 20 20l0 88c0 11-9 20-20 20s-20-9-20-20l0-68.4c-9.1-1.9-16-9.9-16-19.6zm8 192l0 40c0 2.2 1.8 4 4 4l32 0c2.2 0 4-1.8 4-4l0-40c0-2.2-1.8-4-4-4l-32 0c-2.2 0-4 1.8-4 4z", "M384 80c8.8 0 16 7.2 16 16l0 320c0 8.8-7.2 16-16 16L64 432c-8.8 0-16-7.2-16-16L48 96c0-8.8 7.2-16 16-16l320 0zM64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm80 76c-24.3 0-44 19.7-44 44l0 40c0 24.3 19.7 44 44 44l32 0c24.3 0 44-19.7 44-44l0-40c0-24.3-19.7-44-44-44l-32 0zm-4 44c0-2.2 1.8-4 4-4l32 0c2.2 0 4 1.8 4 4l0 40c0 2.2-1.8 4-4 4l-32 0c-2.2 0-4-1.8-4-4l0-40zm140-44c-11 0-20 9-20 20 0 9.7 6.9 17.7 16 19.6l0 68.4c0 11 9 20 20 20s20-9 20-20l0-88c0-11-9-20-20-20l-16 0zM132 296c0 9.7 6.9 17.7 16 19.6l0 68.4c0 11 9 20 20 20s20-9 20-20l0-88c0-11-9-20-20-20l-16 0c-11 0-20 9-20 20zm96 24l0 40c0 24.3 19.7 44 44 44l32 0c24.3 0 44-19.7 44-44l0-40c0-24.3-19.7-44-44-44l-32 0c-24.3 0-44 19.7-44 44zm44-4l32 0c2.2 0 4 1.8 4 4l0 40c0 2.2-1.8 4-4 4l-32 0c-2.2 0-4-1.8-4-4l0-40c0-2.2 1.8-4 4-4z"]],
    "masks-theater": [640, 512, [127917, "theater-masks"], "f630", ["M272.5 136.8c-.1 .2-.1 .7-.1 1.4l0 161.7c0 68.6 43.9 129.4 108.9 151.1l23.4 7.8c7.6 2.5 15.8 2.5 23.5 0l23.4-7.8c65-21.7 108.9-82.5 108.9-151.1l0-161.7c0-.7-.1-1.1-.2-1.4-17.3-17.5-64.2-48.8-143.8-48.8s-126.5 31.3-143.9 48.8zm34 172.9c-1.4-7 7-11 12.7-6.6 26.9 20.6 60.6 32.9 97.2 32.9s70.2-12.3 97.2-32.9c5.7-4.4 14.1-.4 12.7 6.6-10.1 51.4-55.5 90.3-109.9 90.3s-99.8-38.8-109.9-90.3zm.5-85.5c6.5-18.8 24.4-32.3 45.4-32.3s38.9 13.5 45.4 32.3c2.9 8.4-4.5 15.7-13.4 15.7l-64 0c-8.8 0-16.3-7.4-13.4-15.7zm128 0c6.5-18.8 24.4-32.3 45.4-32.3s38.9 13.5 45.4 32.3c2.9 8.4-4.5 15.7-13.4 15.7l-64 0c-8.8 0-16.3-7.4-13.4-15.7z", "M145.3 156.5c-20.7 3.6-35.9 20-39.1 39.7-1.4 8.7 7.2 14.7 15.9 13.2l54.2-9.6 0-38.3c-9.2-4.9-20-6.9-31-5zM131.4 316.4c-1.9 9.7 7.2 17.2 16.9 15.5l29.1-5.1c-.7-7.7-1.1-15.5-1.1-23.3l0-51.4c-23.4 14-39.8 37.5-44.9 64.3zM86.7 284.5L58.6 125.3c-.1-.7-.1-1.1-.1-1.4 14-20.2 54.7-59.2 133.2-73 12.6-2.2 24.6-3.5 35.8-4 20.8-15.1 47.9-29.3 81.1-39.4-32.8-8.8-75-12.7-125.3-3.8-91.9 16.2-143.8 63-164.7 93.6-8.1 11.8-9.3 25.3-7.3 36.5L39.4 292.9c15.5 87.9 85.5 155.9 173.7 169L234 465c-13.7-16.8-25.3-35.3-34.3-55-57.9-16.6-102.3-64.9-112.9-125.4zM416.3 40c-93.3 0-152.5 37-178.5 63.6-10 10.2-13.5 23.4-13.5 34.6l0 161.7c0 89.2 57.1 168.4 141.7 196.6l23.4 7.8c17.5 5.8 36.3 5.8 53.8 0l23.4-7.8c84.6-28.2 141.7-107.4 141.7-196.6l0-161.7c0-11.3-3.5-24.4-13.5-34.6-26-26.5-85.2-63.6-178.5-63.6zm-144 98.2c0-.7 .1-1.1 .1-1.4 17.3-17.5 64.2-48.8 143.9-48.8s126.5 31.3 143.8 48.8c.1 .2 .2 .7 .2 1.4l0 161.7c0 68.6-43.9 129.4-108.9 151.1l-23.4 7.8c-7.6 2.5-15.8 2.5-23.5 0L381.3 451c-65-21.7-108.9-82.5-108.9-151.1l0-161.7zM307 224.3c-2.9 8.4 4.5 15.7 13.4 15.7l64 0c8.8 0 16.3-7.4 13.4-15.7-6.5-18.8-24.4-32.3-45.4-32.3s-38.9 13.5-45.4 32.3zM512.3 240c8.8 0 16.3-7.4 13.4-15.7-6.5-18.8-24.4-32.3-45.4-32.3s-38.9 13.5-45.4 32.3c-2.9 8.4 4.5 15.7 13.4 15.7l64 0zM306.5 309.7c10.1 51.4 55.5 90.3 109.9 90.3s99.8-38.8 109.9-90.3c1.4-7-7-11-12.7-6.6-26.9 20.6-60.6 32.9-97.2 32.9s-70.2-12.3-97.2-32.9c-5.7-4.4-14.1-.4-12.7 6.6z"]],
    "house-turret": [576, 512, [], "e1b4", ["M80 263.1L80 448c0 8.8 7.2 16 16 16l224 0c8.8 0 16-7.2 16-16l0-184.9-128-111.3-128 111.3zM160 296c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-48z", "M312 48l32 0 0 40c0 13.3 10.7 24 24 24s24-10.7 24-24l0-40 48 0 0 40c0 13.3 10.7 24 24 24s24-10.7 24-24l0-40 32 0c4.4 0 8 3.6 8 8l0 384c0 13.3-10.7 24-24 24l-73.1 0c-2.5 17.7-9.2 34-18.9 48l92.1 0c39.8 0 72-32.2 72-72l0-384c0-30.9-25.1-56-56-56L312 0c-30.9 0-56 25.1-56 56l0 10.3 48 41.7 0-52.1c0-4.4 3.6-8 8-8zm-88.2 53.9c-9-7.9-22.5-7.9-31.5 0l-184 160c-10 8.7-11.1 23.9-2.4 33.9 6.7 7.7 17.1 10.1 26.1 6.9L32 448c0 35.3 28.7 64 64 64l224 0c35.3 0 64-28.7 64-64l0-145.4c9 3.2 19.5 .8 26.1-6.9 8.7-10 7.6-25.2-2.4-33.9l-184-160zM336 263.1L336 448c0 8.8-7.2 16-16 16L96 464c-8.8 0-16-7.2-16-16l0-184.9 128-111.3 128 111.3zM160 296l0 48c0 13.3 10.7 24 24 24l48 0c13.3 0 24-10.7 24-24l0-48c0-13.3-10.7-24-24-24l-48 0c-13.3 0-24 10.7-24 24z"]],
    "cart-plus": [640, 512, [], "f217", ["M124.6 31.3l171.4 0 0 40.7-48 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l48 0 0 48c0 13.3 10.7 24 24 24s24-10.7 24-24l0-48 48 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0 0-40.7 224.2 0-1.1 6c-3-2.4-6.5-4.1-10.5-4.9-13-2.5-25.6 6-28.1 19L495.9 220.5c-2.2 11.3-12.1 19.5-23.6 19.5l-309.8 0-38-208.7z", "M0 8C0-5.3 10.7-16 24-16l45.3 0c27.1 0 50.3 19.4 55.1 46l38.2 210 309.8 0c11.5 0 21.4-8.2 23.6-19.5L528.4 51.5c2.5-13 15.1-21.5 28.1-19s21.5 15.1 19 28.1L543.1 229.6c-6.5 33.9-36.2 58.4-70.7 58.4l-301 0 5.1 28.3c2.1 11.4 12 19.7 23.6 19.7L456 336c13.3 0 24 10.7 24 24s-10.7 24-24 24l-255.9 0c-34.8 0-64.6-24.9-70.8-59.1L77.2 38.6c-.7-3.8-4-6.6-7.9-6.6L24 32C10.7 32 0 21.3 0 8zM160 464a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm224 0a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM320 0c13.3 0 24 10.7 24 24l0 48 48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0 0 48c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-48-48 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l48 0 0-48c0-13.3 10.7-24 24-24z"]],
    "hands-asl-interpreting": [640, 512, ["american-sign-language-interpreting", "asl-interpreting", "hands-american-sign-language-interpreting"], "f2a3", ["M48.1 230.5l-.1 .8 0 32.8c0 61.9 50.1 112 112 112l48 0c31.6 0 60.5-14.5 76.2-41.6 4.4-7.6 1.8-17.4-5.8-21.9-2.5-1.4-5.1-2.1-7.7-2.2-.4 0-.5 0-.6 0-5.5 .1-10.7 3-13.6 8-9.1 15.7-26.6 25.6-48.5 25.6-30.9 0-56-25.1-56-56s25.1-56 56-56c11.6 0 21.7 1.8 30.1 5.8 8.9 4.2 14.8 10.3 18.4 16.6 2.9 5 8.1 7.9 13.6 8 .4 0 .5 0 .6 0 2.6 0 5.2-.7 7.7-2.2 7.6-4.4 10.3-14.2 5.8-21.9-6-10.3-13.5-18-21.9-23.6-7.1-4.8-11.1-12.9-10.5-21.5s5.6-16.1 13.2-19.9l46.2-23.1c7.9-4 11.1-13.6 7.2-21.5s-13.6-11.1-21.5-7.2l-87.4 43.7c-9.5 4.8-21.1 2.7-28.3-5.2s-8.5-19.5-3-28.7l35.6-59.4c4.5-7.6 2.1-17.4-5.5-22s-17.4-2.1-22 5.5l-51.8 86.3c-5.8 9.6-17.4 14-28.1 10.5S89 138.6 90 127.5l5.9-61.9c.8-8.8-5.6-16.6-14.4-17.4S64.9 53.7 64.1 62.5l-16 168zM321.7 383.2c4 7.9 13.6 11.1 21.5 7.2l87.4-43.7c9.5-4.8 21.1-2.7 28.3 5.2s8.5 19.5 3 28.7l-35.6 59.4c-4.5 7.6-2.1 17.4 5.5 22s17.4 2.1 22-5.5l51.8-86.3c5.8-9.6 17.4-14 28.1-10.5S551 373.4 550 384.6l-5.9 61.9c-.8 8.8 5.6 16.6 14.4 17.4s16.6-5.6 17.4-14.4l16-168 .1-.8 0-32.8c0-61.9-50.1-112-112-112l-48 0c-31.6 0-60.5 14.5-76.2 41.6-4.4 7.6-1.8 17.4 5.8 21.9 2.5 1.4 5.1 2.1 7.7 2.2 .4 0 .5 0 .6 0 5.5-.1 10.7-3 13.6-8 9.1-15.7 26.6-25.6 48.5-25.6 30.9 0 56 25.1 56 56s-25.1 56-56 56c-11.6 0-21.7-1.8-30.1-5.8-8.9-4.2-14.8-10.3-18.4-16.6-2.9-5-8.1-7.9-13.6-8-.4 0-.5 0-.6 0-2.6 0-5.2 .7-7.7 2.2-7.7 4.4-10.3 14.2-5.8 21.9 6 10.3 13.5 18 21.9 23.6 7.1 4.8 11.1 12.9 10.6 21.5s-5.6 16.1-13.2 19.9l-46.2 23.1c-7.9 4-11.1 13.6-7.2 21.5z", "M186.3 55.8l-51.8 86.3c-5.8 9.6-17.4 14-28.1 10.5S89 138.6 90 127.5l5.9-61.9c.8-8.8-5.6-16.6-14.4-17.4S64.9 53.7 64.1 62.5l-16 168-.1 .8 0 32.8c0 61.9 50.1 112 112 112l48 0c31.6 0 60.5-14.5 76.2-41.6 4.4-7.6 1.8-17.4-5.8-21.9-2.5-1.4-5.1-2.1-7.7-2.2l-.3 0-.3 0c-5.5 .1-10.7 3-13.6 8-9.1 15.7-26.6 25.6-48.5 25.6-30.9 0-56-25.1-56-56s25.1-56 56-56c11.6 0 21.7 1.8 30.1 5.8 8.9 4.2 14.8 10.3 18.4 16.6 2.9 5 8.1 7.9 13.6 8l.3 0 .3 0c2.6 0 5.2-.7 7.7-2.2 7.6-4.4 10.3-14.2 5.8-21.9-6-10.3-13.5-18-21.9-23.6-7.1-4.8-11.1-12.9-10.5-21.5s5.6-16.1 13.2-19.9l46.2-23.1c7.9-4 11.1-13.6 7.2-21.5s-13.6-11.1-21.5-7.2l-87.4 43.7c-9.5 4.8-21.1 2.7-28.3-5.2s-8.5-19.5-3-28.7l35.6-59.4c4.5-7.6 2.1-17.4-5.5-22s-17.4-2.1-22 5.5zm92.8 349.5C257.5 417.8 232.7 424 208 424l-48 0C71.6 424 0 352.4 0 264l0-33.9c0-.8 0-1.5 .1-2.3l.2-1.9 16-168c3.4-35.2 34.6-61 69.8-57.6 24.7 2.4 44.9 18.5 53.4 40.1l5.6-9.3c18.2-30.3 57.5-40.1 87.8-22 26.9 16.2 37.7 49 27 77.4l15.4-7.7c31.4-15.7 69.5-3.2 85.5 28 21.6-12.6 46.3-18.7 71.1-18.7l48 0c88.4 0 160 71.6 160 160l0 33.9c0 .8 0 1.5-.1 2.3l-.2 1.9-16 168c-3.4 35.2-34.6 61-69.8 57.6-24.7-2.4-44.9-18.5-53.4-40.1l-5.6 9.3c-18.2 30.3-57.5 40.1-87.8 22-26.9-16.2-37.7-49-27-77.4l-15.4 7.7c-31.4 15.7-69.5 3.2-85.5-28zm174.6 51l51.8-86.3c5.8-9.6 17.4-14 28.1-10.5S551 373.4 550 384.6l-5.9 61.9c-.8 8.8 5.6 16.6 14.4 17.4s16.6-5.6 17.4-14.4l16-168 .1-.8 0-32.8c0-61.9-50.1-112-112-112l-48 0c-31.6 0-60.5 14.5-76.2 41.6-4.4 7.6-1.8 17.4 5.8 21.9 2.5 1.4 5.1 2.1 7.7 2.2l.3 0 .3 0c5.5-.1 10.7-3 13.6-8 9.1-15.7 26.6-25.6 48.5-25.6 30.9 0 56 25.1 56 56s-25.1 56-56 56c-11.6 0-21.7-1.8-30.1-5.8-8.9-4.2-14.8-10.3-18.4-16.6-2.9-5-8.1-7.9-13.6-8l-.3 0-.3 0c-2.6 0-5.2 .7-7.7 2.2-7.7 4.4-10.3 14.2-5.8 21.9 6 10.3 13.5 18 21.9 23.6 7.1 4.8 11.1 12.9 10.6 21.5s-5.6 16.1-13.2 19.9l-46.2 23.1c-7.9 4-11.1 13.6-7.2 21.5s13.6 11.1 21.5 7.2l87.4-43.7c9.5-4.8 21.1-2.7 28.3 5.2s8.5 19.5 3 28.7l-35.6 59.4c-4.5 7.6-2.1 17.4 5.5 22s17.4 2.1 22-5.5zM224 288a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm208-48a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"]],
    "face-anxious-sweat": [640, 512, [], "e36a", ["M112 256c0-114.9 93.1-208 208-208s208 93.1 208 208-93.1 208-208 208c-56.8 0-108.2-22.7-145.8-59.6 1.2-6.6 1.8-13.4 1.8-20.4 0-32.4-14.1-60-28.4-80.1-10.9-15.3-23.7-28.8-35.4-39.9-.1-2.7-.2-5.4-.2-8zm28.3-44.7c1.8 10.9 12.1 18.3 23 16.4l2.5-.4c33.7-5.6 64.8-21.6 89-45.8l7.4-7.4c7.8-7.8 7.8-20.5 0-28.3s-20.5-7.8-28.3 0l-7.4 7.4c-18.3 18.3-41.8 30.4-67.3 34.6l-2.5 .4c-10.9 1.8-18.3 12.1-16.4 23zM208 272a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm32 128c0 .5 0 .9 0 1.3 0 .8 0 1.6 0 2.4 0 1.4 .7 2.6 1.7 3.4 2.6 5.2 8.1 8.9 14.3 8.9l128 0c6.3 0 11.7-3.6 14.3-8.9 1-.8 1.7-2 1.7-3.4 0-.8 0-1.6 0-2.4 0-.4 0-.9 0-1.3 0-44.2-35.8-80-80-80s-80 35.8-80 80zM368 272a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm9.9-126.1c-7.8 7.8-7.8 20.5 0 28.3l7.4 7.4c24.2 24.2 55.3 40.2 89 45.8l2.5 .4c10.9 1.8 21.2-5.5 23-16.4s-5.5-21.2-16.4-23l-2.5-.4c-25.5-4.2-49-16.4-67.3-34.6l-7.4-7.4c-7.8-7.8-20.5-7.8-28.3 0z", "M528 256c0 114.9-93.1 208-208 208-56.8 0-108.2-22.7-145.8-59.6-3.1 17.4-10 33.3-19.9 46.8 44.7 38 102.5 60.8 165.7 60.8 141.4 0 256-114.6 256-256S461.4 0 320 0c-136 0-247.2 106.1-255.5 240 12.8 .1 25.6 4.6 36 13.5l.3 .3c3.6 3.1 7.4 6.6 11.4 10.3-.1-2.7-.2-5.4-.2-8 0-114.9 93.1-208 208-208s208 93.1 208 208zM320 320c-44.2 0-80 35.8-80 80 0 8.8 7.2 16 16 16l128 0c8.8 0 16-7.2 16-16 0-44.2-35.8-80-80-80zm48-48a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zM240 304a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm22.1-158.1c-7.8-7.8-20.5-7.8-28.3 0l-7.4 7.4c-18.3 18.3-41.8 30.4-67.3 34.6l-2.5 .4c-10.9 1.8-18.3 12.1-16.4 23s12.1 18.3 23 16.4l2.5-.4c33.7-5.6 64.8-21.6 89-45.8l7.4-7.4c7.8-7.8 7.8-20.5 0-28.3zm115.7 28.3l7.4 7.4c24.2 24.2 55.3 40.2 89 45.8l2.5 .4c10.9 1.8 21.2-5.5 23-16.4s-5.5-21.2-16.4-23l-2.5-.4c-25.5-4.2-49-16.4-67.3-34.6l-7.4-7.4c-7.8-7.8-20.5-7.8-28.3 0s-7.8 20.5 0 28.3zM128 384c0-36.9-32.5-71.1-58.8-94.1-3-2.6-7.4-2.6-10.4 0-26.3 23-58.8 57.2-58.8 94.1 0 36.4 27.6 64 64 64s64-27.6 64-64z"]],
    "message-smile": [512, 512, ["comment-alt-smile"], "f4aa", ["M48 128l0 224c0 26.5 21.5 48 48 48l56 0c10.4 0 19.3 6.6 22.6 15.9 .9 2.5 1.4 5.2 1.4 8.1l0 49.7c32.7-23.1 63.3-44.7 91.9-64.9 8.1-5.7 17.8-8.8 27.7-8.8L416 400c26.5 0 48-21.5 48-48l0-224c0-26.5-21.5-48-48-48L96 80c-26.5 0-48 21.5-48 48zM148.7 320c-8.8-9.9-8-25 1.9-33.9s25-8 33.9 1.9c17.6 19.7 43.1 32 71.6 32s53.9-12.3 71.6-32c8.8-9.9 24-10.7 33.9-1.9s10.7 24 1.9 33.9C337 349.4 298.6 368 256 368s-81-18.6-107.3-48zM224 192a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm128 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M203.7 512.9l0 0 91.9-64.9 120.4 0c53 0 96-43 96-96l0-224c0-53-43-96-96-96L96 32C43 32 0 75 0 128L0 352c0 53 43 96 96 96l32 0 0 72c0 9 5 17.2 13 21.3s17.6 3.5 24.9-1.7l37.8-26.7zM295.6 400c-9.9 0-19.6 3.1-27.7 8.8-28.6 20.2-59.3 41.8-91.9 64.9l0-49.7c0-2.8-.5-5.6-1.4-8.1-3.3-9.3-12.2-15.9-22.6-15.9l-56 0c-26.5 0-48-21.5-48-48l0-224c0-26.5 21.5-48 48-48l320 0c26.5 0 48 21.5 48 48l0 224c0 26.5-21.5 48-48 48l-120.4 0zM192 224a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm128 0a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM150.5 286.1c-9.9 8.8-10.7 24-1.9 33.9 26.3 29.4 64.7 48 107.3 48s81-18.6 107.3-48c8.8-9.9 8-25-1.9-33.9s-25-8-33.9 1.9c-17.6 19.7-43.1 32-71.6 32s-53.9-12.3-71.6-32c-8.8-9.9-24-10.7-33.9-1.9z"]],
    "location-exclamation": [384, 512, ["map-marker-exclamation"], "f608", ["M48 188.6c0 45.6 23.8 101.5 58.9 157.1 28.3 44.8 61 84.7 85.1 112 24.1-27.3 56.8-67.2 85.1-112 35.1-55.5 58.9-111.5 58.9-157.1 0-76.8-63.7-140.6-144-140.6S48 111.7 48 188.6zM224 320a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM160.6 129.7c-1.3-18.2 13.1-33.7 31.4-33.7 18.2 0 32.7 15.5 31.4 33.7l-7.4 104c-.9 12.6-11.4 22.3-23.9 22.3-12.6 0-23-9.7-23.9-22.3l-7.4-104z", "M192 0c106 0 192 84.4 192 188.6 0 119.3-120.2 262.3-170.4 316.8l0 0c-11.8 12.8-31.4 12.8-43.3 0l0 0C120.1 450.8 0 307.9 0 188.6 0 84.4 86 0 192 0zm0 48c-80.3 0-144 63.7-144 140.6 0 45.6 23.8 101.5 58.9 157.1 28.3 44.8 61 84.7 85.1 112 24.1-27.3 56.8-67.2 85.1-112 35.1-55.5 58.9-111.5 58.9-157.1 0-76.8-63.7-140.6-144-140.6zm0 304a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm0-256c18.2 0 32.7 15.5 31.4 33.7l-7.4 104c-.9 12.6-11.4 22.3-23.9 22.3-12.6 0-23-9.7-23.9-22.3l-7.4-104C159.3 111.5 173.8 96 192 96z"]],
    "square-naira": [448, 512, [], "e708", ["M48 96l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16zM96 272c0-8.8 7.2-16 16-16l16 0 0-104c0-10.5 6.8-19.8 16.8-22.9s20.9 .6 26.9 9.2l81.5 117.7 18.8 0 0-104c0-13.3 10.7-24 24-24s24 10.7 24 24l0 104 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0 0 72c0 10.5-6.8 19.8-16.8 22.9s-20.9-.6-26.9-9.2l-59.3-85.7-41 0 0 72c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-72-16 0c-8.8 0-16-7.2-16-16z", "M384 80c8.8 0 16 7.2 16 16l0 320c0 8.8-7.2 16-16 16L64 432c-8.8 0-16-7.2-16-16L48 96c0-8.8 7.2-16 16-16l320 0zM64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM171.7 138.3c-6-8.6-16.9-12.4-26.9-9.2S128 141.5 128 152l0 104-16 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l16 0 0 72c0 13.3 10.7 24 24 24s24-10.7 24-24l0-72 41 0 59.3 85.7c6 8.6 16.9 12.4 26.9 9.2S320 370.5 320 360l0-72 16 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0 0-104c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 104-18.8 0-81.5-117.7zM194.8 256l-18.8 0 0-27.2 18.8 27.2z"]],
    "table-cells-row-unlock": [640, 512, [], "e691", ["M112 216l0 200c0 8.8 7.2 16 16 16l72 0 0-216-88 0zm136 0l0 216 80 0 0-216-80 0zm128 0l0 113.5c5.6-12.7 13.8-24 24-33.1l0-24.4c0-20.1 4.6-39.1 12.9-56L376 216z", "M64 168l0 248c0 35.3 28.7 64 64 64l241.3 0c-.9-5.2-1.3-10.6-1.3-16.1l0-96c0-13.7 2.9-26.7 8-38.4l0-113.5 36.9 0c18.6-38.1 55.4-65.6 99.1-71l0-49c0-35.3-28.7-64-64-64L128 32C92.7 32 64 60.7 64 96l0 72zm264 48l0 216-80 0 0-216 80 0zM128 432c-8.8 0-16-7.2-16-16l0-200 88 0 0 216-72 0zM560 272l48 0c-.1-44.1-35.8-79.9-80-79.9-44.2 0-80 35.8-80 80l0 50.6c-18.6 6.6-32 24.4-32 45.3l0 96c0 26.5 21.5 48 48 48l128 0c26.5 0 48-21.5 48-48l0-96c0-26.5-21.5-48-48-48l-96 0 0-47.9c0-17.7 14.3-32 32-32 17.6 0 31.9 14.3 32 31.9z"]],
    "diamonds-4": [512, 512, [], "e68b", ["M48 256c0 2.6 1 5.2 2.9 7L99 311.1 154.2 256 99 200.9 50.9 249c-1.9 1.9-2.9 4.4-2.9 7zM200.9 99L256 154.2 311.1 99 263 50.9c-1.9-1.9-4.4-2.9-7-2.9s-5.2 1-7 2.9L200.9 99zm0 313.9L249 461.1c1.9 1.9 4.4 2.9 7 2.9s5.2-1 7-2.9L311.1 413 256 357.8 200.9 413zm157-157L413 311.1 461.1 263c1.9-1.9 2.9-4.4 2.9-7s-1-5.2-2.9-7L413 200.9 357.8 256z", "M345.1 133c18.7-18.7 18.7-49.1 0-67.9L297 17C286.1 6.1 271.4 0 256 0s-30.1 6.1-41 17L166.9 65.1c-18.7 18.7-18.7 49.1 0 67.9l55.1 55.1c18.7 18.7 49.1 18.7 67.9 0L345.1 133zM249 50.9c1.9-1.9 4.4-2.9 7-2.9s5.2 1 7 2.9L311.1 99 256 154.2 200.9 99 249 50.9zm-116 116c-18.7-18.7-49.1-18.7-67.9 0L17 215C6.1 225.9 0 240.6 0 256s6.1 30.1 17 41l48.1 48.1c18.7 18.7 49.1 18.7 67.9 0l55.1-55.1c18.7-18.7 18.7-49.1 0-67.9L133 166.9zM50.9 249l48.1-48.1 55.1 55.1-55.1 55.1-48.1-48.1 0 0c-1.9-1.9-2.9-4.4-2.9-7s1-5.2 2.9-7zM200.9 413L256 357.8 311.1 413 263 461.1c-1.9 1.9-4.4 2.9-7 2.9s-5.2-1-7-2.9L200.9 413zm89.1-89.1c-18.7-18.7-49.1-18.7-67.9 0L166.9 379c-18.7 18.7-18.7 49.1 0 67.9L215 495c10.9 10.9 25.6 17 41 17s30.1-6.1 41-17l48.1-48.1c18.7-18.7 18.7-49.1 0-67.9l-55.1-55.1zm157-157c-18.7-18.7-49.1-18.7-67.9 0l-55.1 55.1c-18.7 18.7-18.7 49.1 0 67.9L379 345.1c18.7 18.7 49.1 18.7 67.9 0L495 297c10.9-10.9 17-25.6 17-41s-6.1-30.1-17-41l-48.1-48.1zM461.1 249c1.9 1.9 2.9 4.4 2.9 7s-1 5.2-2.9 7L413 311.1 357.8 256 413 200.9 461.1 249z"]],
    "rocket": [512, 512, [], "f135", ["M52.8 272l74.5 0c6.4-23.3 13.6-44.6 21.6-64l-57.8 0-38.4 64zm121.6 10c24.6 11.2 44.5 31 55.7 55.7 109.9-30.6 162.5-79.9 187.2-127.7 23.7-45.9 23.8-94.6 18.1-133.2-38.6-5.8-87.3-5.6-133.2 18.1-47.8 24.7-97.1 77.3-127.7 187.2zM240 384.7l0 74.5 64-38.4 0-57.8c-19.4 8-40.7 15.2-64 21.6zM376 176a40 40 0 1 1 -80 0 40 40 0 1 1 80 0z", "M460.7 32.5c9.5 1.9 16.9 9.3 18.8 18.8 9 45 14.7 114-19.7 180.7-20.7 40-54.8 77.3-107.8 107.7l0 81.1c0 16.9-8.8 32.5-23.3 41.2l-88.2 52.9c-21.3 12.8-48.5-2.6-48.5-27.4L192 384c0-35.3-28.7-64-64-64L24.5 320c-24.9 0-40.2-27.1-27.4-48.5L50 183.3C58.7 168.8 74.3 160 91.2 160l81.1 0C202.7 106.9 240 72.8 280 52.2 346.7 17.7 415.7 23.5 460.7 32.5zM240 384.7l0 74.5 64-38.4 0-57.8c-19.4 8-40.7 15.2-64 21.6zM417.2 210c23.7-45.9 23.8-94.6 18.1-133.2-38.6-5.8-87.3-5.6-133.2 18.1-47.8 24.7-97.1 77.3-127.7 187.2 24.6 11.2 44.5 31 55.7 55.7 109.9-30.6 162.5-79.9 187.2-127.7zM149 208l-57.8 0-38.4 64 74.5 0c6.4-23.3 13.6-44.6 21.6-64zM336 136a40 40 0 1 1 0 80 40 40 0 1 1 0-80z"]],
    "file-circle-info": [576, 512, [58604], "e493", ["M80 64c0-8.8 7.2-16 16-16l112 0 0 88c0 39.8 32.2 72 72 72l88 0 0 10.9c-74.6 26.4-128 97.5-128 181.1 0 22.4 3.8 44 10.9 64L96 464c-8.8 0-16-7.2-16-16L80 64z", "M208 48L96 48c-8.8 0-16 7.2-16 16l0 384c0 8.8 7.2 16 16 16l154.9 0c6.1 17.3 14.6 33.4 25.1 48L96 512c-35.3 0-64-28.7-64-64L32 64C32 28.7 60.7 0 96 0L229.5 0c17 0 33.3 6.7 45.3 18.7L397.3 141.3c12 12 18.7 28.3 18.7 45.3l0 22.1c-16.7 1.4-32.8 4.9-48 10.3l0-10.9-88 0c-39.8 0-72-32.2-72-72l0-88zM348.1 160L256 67.9 256 136c0 13.3 10.7 24 24 24l68.1 0zM432 256a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm0 100a20 20 0 1 0 0-40 20 20 0 1 0 0 40zm-32 44c0 8.8 7.2 16 16 16l0 0 0 32 0 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l32 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l0-48c0-8.8-7.2-16-16-16l-16 0c-8.8 0-16 7.2-16 16z"]],
    "cloud-fog": [576, 512, [127787, "fog"], "f74e", ["M80 216c0 30.9 25.1 56 56 56l304 0c30.9 0 56-25.1 56-56s-25.1-56-56-56c-13.3 0-24-10.7-24-24 0-30.9-25.1-56-56-56-15.6 0-29.6 6.3-39.8 16.6-5.5 5.6-13.4 8.1-21.2 6.8s-14.3-6.4-17.6-13.6c-11.4-24.7-36.4-41.8-65.4-41.8-39.8 0-72 32.2-72 72 0 4.5 .4 8.8 1.2 13 2.4 13-6.3 25.5-19.3 27.9-26.1 4.8-45.9 27.6-45.9 55.1z", "M144 120c0-39.8 32.2-72 72-72 28.9 0 53.9 17.1 65.4 41.8 3.3 7.1 9.9 12.2 17.6 13.6s15.7-1.2 21.2-6.8c10.2-10.3 24.2-16.6 39.8-16.6 30.9 0 56 25.1 56 56 0 13.3 10.7 24 24 24 30.9 0 56 25.1 56 56s-25.1 56-56 56l-304 0c-30.9 0-56-25.1-56-56 0-27.4 19.8-50.3 45.9-55.1 13-2.4 21.7-14.9 19.3-27.9-.8-4.2-1.2-8.5-1.2-13zM216 0c-66.3 0-120 53.7-120 120-37.6 15.7-64 52.7-64 96 0 57.4 46.6 104 104 104l304 0c57.4 0 104-46.6 104-104 0-50-35.3-91.7-82.3-101.7-10-47-51.7-82.3-101.7-82.3-18.3 0-35.4 4.7-50.3 13-22-27.4-55.7-45-93.7-45zM512 392c0-13.3-10.7-24-24-24L24 368c-13.3 0-24 10.7-24 24s10.7 24 24 24l464 0c13.3 0 24-10.7 24-24zM64 488c0 13.3 10.7 24 24 24l80 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0c-13.3 0-24 10.7-24 24zm176 0c0 13.3 10.7 24 24 24l288 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-288 0c-13.3 0-24 10.7-24 24z"]],
    "option": [640, 512, [], "e318", ["", "M172.1 120.4c-4.6-5.3-11.2-8.4-18.2-8.4L24 112C10.7 112 0 101.3 0 88S10.7 64 24 64l129.9 0c21 0 41 9.2 54.7 25.1L467.9 391.6c4.6 5.3 11.2 8.4 18.2 8.4L616 400c13.3 0 24 10.7 24 24s-10.7 24-24 24l-129.9 0c-21 0-41-9.2-54.7-25.1L172.1 120.4zM616 64c13.3 0 24 10.7 24 24s-10.7 24-24 24l-176 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l176 0z"]],
    "utility-pole": [512, 512, [], "e2c3", ["", "M280 24c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 56-104 0 0-24c0-13.3-10.7-24-24-24S80 42.7 80 56l0 24-15.8 0c-.1 0-.3 0-.4 0L48 80 48 56c0-13.3-10.7-24-24-24S0 42.7 0 56l0 48c0 13.3 10.7 24 24 24L55.6 128 232 267.6 232 488c0 13.3 10.7 24 24 24s24-10.7 24-24l0-220.4 176.3-139.6 31.7 0c13.3 0 24-10.7 24-24l0-48c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 24-15.8 0c-.1 0-.3 0-.4 0l-15.8 0 0-24c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 24-104 0 0-56zm99 104l-99 78.4 0-78.4 99 0zM232 206.4l-99-78.4 99 0 0 78.4z"]],
    "shrimp": [512, 512, [129424], "e448", ["M113.3 176c9.5 72.2 71.4 128 146.2 128l36.5 0 0-128-182.7 0zM248 224a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm96-47.8l0 128.1c6.2 .6 12.2 1.8 18 3.8l78.3-78.3c-21.8-30.5-56.6-51.1-96.3-53.5zm57 160.7c9.4 13 15 29 15 46.3 0 8.2-1.2 16-3.4 23.4 31.2-23.3 51.4-60.6 51.4-102.6 0-9.3-1-18.4-2.9-27.2L401 336.9z", "M0 104C0 64.2 32.2 32 72 32l352 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L72 80c-13.3 0-24 10.7-24 24s10.7 24 24 24l264 0c97.2 0 176 78.8 176 176S433.2 480 336 480l-88 0c-13.3 0-24-10.7-24-24 0-12 8.8-21.9 20.2-23.7l-4.9-1.9c-12.4-4.8-18.5-18.7-13.7-31.1s18.7-18.5 31.1-13.7l68.7 26.7c20.5 8 42.6-7.1 42.6-29.1 0-17.3-14-31.2-31.2-31.2l-77.3 0C158 352 74.5 274.6 64.9 175.7 28.5 172.1 0 141.4 0 104zM464 304c0-9.3-1-18.4-2.9-27.2L401 336.9c9.4 13 15 29 15 46.3 0 8.2-1.2 16-3.4 23.4 31.2-23.3 51.4-60.6 51.4-102.6zm-23.7-74.2c-21.8-30.5-56.6-51.1-96.3-53.5l0 128.1c6.2 .6 12.2 1.8 18 3.8l78.3-78.3zM296 176l-182.7 0c9.5 72.2 71.4 128 146.2 128l36.5 0 0-128zm-72 24a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]],
    "alien": [448, 512, [128125], "f8f5", ["M48 224c0-97.2 78.8-176 176-176s176 78.8 176 176c0 50.4-28.2 101.3-68.2 146.9-39.2 44.7-84.2 78.1-105.6 92.7-1.3 .6-3.1 .7-4.4 0-21.4-14.6-66.4-48-105.6-92.7-40-45.6-68.2-96.5-68.2-146.9zm32 13.7c0 45.4 36.8 82.3 82.3 82.3l32 0c7.6 0 13.7-6.1 13.7-13.7 0-45.4-36.8-82.3-82.3-82.3l-32 0c-7.6 0-13.7 6.1-13.7 13.7zm160 68.6c0 7.6 6.1 13.7 13.7 13.7l32 0c45.4 0 82.3-36.8 82.3-82.3 0-7.6-6.1-13.7-13.7-13.7l-32 0c-45.4 0-82.3 36.8-82.3 82.3z", "M224 512C213.5 512 203.3 509.1 194.7 503.2 148.8 471.7 0 359.3 0 224 0 100.3 100.3 0 224 0S448 100.3 448 224c0 135.3-148.8 247.7-194.7 279.2-8.6 5.9-18.9 8.8-29.3 8.8zM48 224c0 50.4 28.2 101.3 68.2 146.9 39.2 44.7 84.2 78.1 105.6 92.7 1.3 .7 3.1 .7 4.4 0 21.4-14.6 66.4-48 105.6-92.7 40-45.6 68.2-96.5 68.2-146.9 0-97.2-78.8-176-176-176S48 126.8 48 224zm160 82.3c0 7.6-6.1 13.7-13.7 13.7l-32 0c-45.4 0-82.3-36.8-82.3-82.3 0-7.6 6.1-13.7 13.7-13.7l32 0c45.4 0 82.3 36.8 82.3 82.3zm32 0c0-45.4 36.8-82.3 82.3-82.3l32 0c7.6 0 13.7 6.1 13.7 13.7 0 45.4-36.8 82.3-82.3 82.3l-32 0c-7.6 0-13.7-6.1-13.7-13.7z"]],
    "skeleton": [512, 512, [], "f620", ["M96 512c13.3 0 24-10.7 24-24 0-22.1 17.9-40 40-40l192 0c22.1 0 40 17.9 40 40 0 13.3 10.7 24 24 24L96 512z", "M256 0c13.3 0 24 10.7 24 24l0 56 144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0 0 48 208 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-208 0 0 48 112 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-112 0 0 80 72 0c48.6 0 88 39.4 88 88 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-22.1-17.9-40-40-40l-192 0c-22.1 0-40 17.9-40 40 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-48.6 39.4-88 88-88l72 0 0-80-112 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l112 0 0-48-208 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l208 0 0-48-144 0c-13.3 0-24-10.7-24-24S74.7 80 88 80l144 0 0-56c0-13.3 10.7-24 24-24z"]],
    "tire-pressure-warning": [512, 512, [], "f633", ["M50.9 307.2c-4.3-39 7-74.8 22-105.3 7.8-15.8 16.1-33 22.2-51.5l2.5-7.4c9.5-28.6 14.4-58.4 14.4-88.5L112 24c0-13.3-10.7-24-24-24L424 0c-13.3 0-24 10.7-24 24l0 30.5c0 30.1 4.9 60 14.4 88.5l2.5 7.4c6.1 18.4 14.4 35.6 22.2 51.5 15 30.5 26.3 66.3 22 105.3-4 36.7-22.3 79.2-70.5 124.8l-269.3 0C73.2 386.4 55 343.9 50.9 307.2zM229.4 320a26.7 26.7 0 1 0 53.3 0 26.7 26.7 0 1 0 -53.3 0zM232 128l0 112c0 13.3 10.7 24 24 24s24-10.7 24-24l0-112c0-13.3-10.7-24-24-24s-24 10.7-24 24z", "M424 0c-13.3 0-24 10.7-24 24l0 30.5c0 30.1 4.9 60 14.4 88.5l2.5 7.4c6.1 18.4 14.4 35.6 22.2 51.5 15 30.5 26.3 66.3 22 105.3-4 36.7-22.3 79.2-70.5 124.8l-269.3 0c-48.2-45.6-66.4-88.1-70.5-124.8-4.3-39 7-74.8 22-105.3 7.8-15.8 16.1-33 22.2-51.5l2.5-7.4c9.5-28.6 14.4-58.4 14.4-88.5L112 24c0-13.3-10.7-24-24-24S64 10.7 64 24l0 30.5c0 24.9-4 49.7-11.9 73.4l-2.5 7.4c-5 15-11.9 29.6-19.7 45.4-17.2 34.9-32.4 80.2-26.7 131.8 5.5 49.7 30 102.1 84.8 154.1L88 488c0 13.3 10.7 24 24 24s24-10.7 24-24l0-8 48 0 0 8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-8 48 0 0 8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-8 48 0 0 8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-21.5c54.8-51.9 79.3-104.3 84.8-154.1 5.7-51.5-9.5-96.9-26.7-131.8-7.8-15.8-14.7-30.4-19.7-45.4l-2.5-7.4C452 104.2 448 79.4 448 54.5L448 24c0-13.3-10.7-24-24-24zM256 104c-13.3 0-24 10.7-24 24l0 112c0 13.3 10.7 24 24 24s24-10.7 24-24l0-112c0-13.3-10.7-24-24-24zm26.7 216a26.7 26.7 0 1 0 -53.3 0 26.7 26.7 0 1 0 53.3 0z"]],
    "nose": [448, 512, [], "e5bd", ["M48 392c0-39.8 32.2-72 72-72l16 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-16 0c-20.2 0-39.3 5-56 13.8L64 16 152 16c0 5.1 1.6 10.3 5 14.7L381.3 320.1c12.1 15.6 18.7 34.9 18.7 54.7 0 49.3-40 89.3-89.3 89.3l-38.7 0 0-16c0-44.2-35.8-80-80-80s-80 35.8-80 80l0 15.6c-36-4-64-34.5-64-71.6z", "M161.3-3c10.5-8.1 25.6-6.2 33.7 4.3L419.2 290.7c18.6 24.1 28.8 53.6 28.8 84.1 0 75.8-61.4 137.3-137.3 137.3L120 512C53.7 512 0 458.3 0 392S53.7 272 120 272l16 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-16 0c-39.8 0-72 32.2-72 72 0 37.1 28 67.6 64 71.6l0-15.6c0-44.2 35.8-80 80-80s80 35.8 80 80l0 16 38.7 0c49.3 0 89.3-40 89.3-89.3 0-19.8-6.6-39-18.7-54.7L157 30.7c-8.1-10.5-6.2-25.6 4.3-33.7zM224 464l0-16c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 16 64 0z"]],
    "sign-posts-wrench": [640, 512, [], "e626", ["M80 128c0-8.8 7.2-16 16-16l384 0c8.8 0 16 7.2 16 16l0 48.7c-89.7 8.1-160 83.5-160 175.3 0 16.6 2.3 32.7 6.6 48L96 400c-8.8 0-16-7.2-16-16l0-256z", "M96 64l0-24c0-13.3 10.7-24 24-24s24 10.7 24 24l0 24 288 0 0-24c0-13.3 10.7-24 24-24s24 10.7 24 24l0 24c35.3 0 64 28.7 64 64l0 50.9c-10.4-1.9-21.1-2.9-32-2.9-5.4 0-10.7 .2-16 .7l0-48.7c0-8.8-7.2-16-16-16L96 112c-8.8 0-16 7.2-16 16l0 256c0 8.8 7.2 16 16 16l246.6 0c4.9 17.2 12.3 33.4 21.8 48l-220.5 0 0 40c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-40c-35.3 0-64-28.7-64-64l0-256c0-35.3 28.7-64 64-64zM448 241.1c7.4-4.3 16 1.5 16 10l0 84.9c0 26.5 21.5 48 48 48s48-21.5 48-48l0-84.9c0-8.5 8.6-14.3 16-10 38.3 22.1 64 63.5 64 110.9s-25.7 88.7-64 110.9l0 45.1c0 19.9-16.1 36-36 36l-56 0c-19.9 0-36-16.1-36-36l0-45.1c-38.3-22.1-64-63.5-64-110.9s25.7-88.8 64-110.9z"]],
    "tenge-sign": [384, 512, [8376, "tenge"], "f7d7", ["", "M0 56C0 42.7 10.7 32 24 32l336 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 80C10.7 80 0 69.3 0 56zM0 168c0-13.3 10.7-24 24-24l336 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0 0 264c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-264-144 0c-13.3 0-24-10.7-24-24z"]],
    "face-scream": [576, 512, [], "e38b", ["M80 256C80 141.1 173.1 48 288 48s208 93.1 208 208c0 18.7-2.5 36.8-7.1 54-32.4 11.7-57.4 39.6-64.5 75-2.2 11.2-4.5 22.4-6.7 33.6-35.6 28.4-80.7 45.4-129.7 45.4s-94.2-17-129.7-45.4c-2.2-11.2-4.5-22.4-6.7-33.6-7.1-35.3-32.1-63.2-64.5-75-4.6-17.4-7.1-35.4-7.1-54zm62.6-67c-22.5 36.9-18.6 78.8 8.7 93.7s67.6-2.9 90.1-39.8 18.6-78.8-8.7-93.7-67.6 2.9-90.1 39.8zM240 352l0 16c0 26.5 21.5 48 48 48s48-21.5 48-48l0-16c0-26.5-21.5-48-48-48s-48 21.5-48 48zm94.6-109c22.5 36.9 62.8 54.7 90.1 39.8s31.1-56.8 8.7-93.7-62.8-54.7-90.1-39.8-31.1 56.9-8.7 93.7z", "M496 256c0 18.7-2.5 36.8-7.1 54 10.8-3.9 22.3-6 34.3-6 5.4 0 10.8 .4 16 1.3 3.1-15.9 4.7-32.4 4.7-49.3 0-141.4-114.6-256-256-256S32 114.6 32 256c0 16.9 1.6 33.3 4.7 49.3 5.2-.8 10.6-1.3 16-1.3 12 0 23.6 2.1 34.3 6-4.6-17.2-7.1-35.3-7.1-54 0-114.9 93.1-208 208-208s208 93.1 208 208zM288 464c-49.1 0-94.2-17-129.7-45.4l13.1 65.3C206.3 501.9 246 512 288 512s81.7-10.1 116.7-28.1l13.1-65.3C382.2 447 337.1 464 288 464zm0-160c-26.5 0-48 21.5-48 48l0 16c0 26.5 21.5 48 48 48s48-21.5 48-48l0-16c0-26.5-21.5-48-48-48zm-46.6-61c22.5-36.9 18.6-78.8-8.7-93.7s-67.6 2.9-90.1 39.8-18.6 78.8 8.7 93.7 67.6-2.9 90.1-39.8zm183.3 39.8c27.3-14.9 31.1-56.8 8.7-93.7s-62.8-54.7-90.1-39.8-31.1 56.9-8.7 93.7 62.8 54.7 90.1 39.8zM0 404.8l0 107.2 128 0-23.5-117.6C99.5 369.8 77.9 352 52.8 352 23.6 352 0 375.6 0 404.8zM523.2 352c-25.1 0-46.8 17.8-51.7 42.4L448 512 576 512 576 404.8c0-29.1-23.6-52.8-52.8-52.8z"]],
    "house-chimney-medical": [512, 512, ["clinic-medical"], "f7f2", ["M96 199.7L96 448c0 8.8 7.2 16 16 16l288 0c8.8 0 16-7.2 16-16L416 199.7 256 56.2 96 199.7zM168 272c0-8.8 7.2-16 16-16l40 0 0-40c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 40 40 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-40 0 0 40c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-40-40 0c-8.8 0-16-7.2-16-16l0-32z", "M272 6.1c-9.1-8.2-22.9-8.2-32 0L8 214.1c-9.9 8.8-10.7 24-1.8 33.9s24 10.7 33.9 1.8l8-7.2 0 205.3c0 35.3 28.7 64 64 64l288 0c35.3 0 64-28.7 64-64l0-205.3 8 7.2c9.9 8.8 25 8 33.9-1.8s8-25-1.8-33.9l-40-35.9 0-90.2c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 47.2-144-129.1zM416 199.7L416 448c0 8.8-7.2 16-16 16l-288 0c-8.8 0-16-7.2-16-16L96 199.7 256 56.2 416 199.7zM224 216l0 40-40 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l40 0 0 40c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-40 40 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-40 0 0-40c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16z"]],
    "square-arrow-left": [448, 512, ["arrow-square-left"], "f33a", ["M48 96l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16zm79 143l72-72c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-31 31 102.1 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-102.1 0 31 31c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-72-72c-9.4-9.4-9.4-24.6 0-33.9z", "M64 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM127 239l72-72c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-31 31 102.1 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-102.1 0 31 31c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-72-72c-9.4-9.4-9.4-24.6 0-33.9z"]],
    "circle-location-arrow": [512, 512, ["location-circle"], "f602", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm72.4 6.4c-2.1-10.2 3.3-20.5 12.9-24.6l196-84c8.5-3.5 18-1.7 24.2 4.7 6.4 6.3 8.2 15.9 4.7 24.2l-84 196c-3.5 8.1-11.4 13.3-20.2 13.3-1.4 0-2.9-.1-4.4-.4-10.2-2.1-17.6-11.2-17.6-21.6l0-90-90 0c-10.4 0-19.5-7.4-21.5-17.6z", "M464 256a208 208 0 1 0 -416 0 208 208 0 1 0 416 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm358.2-73.3l-84 196c-3.5 8.1-11.4 13.3-20.2 13.3-1.4 0-2.9-.1-4.4-.4-10.2-2.1-17.6-11.2-17.6-21.6l0-90-90 0c-10.4 0-19.5-7.4-21.5-17.6-2.1-10.2 3.3-20.5 12.9-24.6l196-84c8.5-3.5 18-1.7 24.2 4.7 6.4 6.3 8.2 15.9 4.7 24.2z"]],
    "users-slash": [640, 512, [], "e073", ["M168.5 480l274.2 0c-48-48-96-96-144-144l-2.2 0c-57.4 0-104 46.6-104 104l0 16c0 13.3-10.7 24-24 24zm88-352a64 64 0 1 0 128 0 64 64 0 1 0 -128 0z", "M73.5-24.9c-9.4-9.4-24.6-9.4-33.9 0S30.2-.3 39.5 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9L337.1 238.8c54-8 95.4-54.6 95.4-110.8 0-61.9-50.1-112-112-112-56.2 0-102.7 41.4-110.8 95.4L73.5-24.9zM636.1 469.8c2.7-3.9 4.4-8.7 4.4-13.8 0-83.1-66.6-150.6-149.3-152-.9 0-1.8 0-2.7 0l-18.2 0 54.5 54.5c28.2 10.5 50.6 32.9 61.1 61.1l50.2 50.2zM206.8 244.1l-37-37c-3 .6-6.1 .9-9.3 .9-26.5 0-48-21.5-48-48 0-3.2 .3-6.3 .9-9.3l-37-37c-7.6 13.7-11.9 29.5-11.9 46.3 0 53 43 96 96 96 16.8 0 32.6-4.3 46.3-11.9zM298.7 336l-42.6-42.6C191.8 311.1 144.5 370 144.5 440l0 16c0 13.3 10.7 24 24 24s24-10.7 24-24l0-16c0-57.4 46.6-104 104-104l2.2 0zM256.5 128a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zm204.8 76c-7.8 14.4-17.7 27.5-29.4 38.8 14.2 8.4 30.9 13.2 48.6 13.2 53 0 96-43 96-96s-43-96-96-96c-4.4 0-8.7 .3-12.9 .9 6.3 14.7 10.5 30.6 12.2 47.1l.8 0c26.5 0 48 21.5 48 48s-21.5 48-48 48c-6.8 0-13.3-1.4-19.2-4zM.5 456c0 13.3 10.7 24 24 24s24-10.7 24-24c0-43.6 26.8-80.9 64.8-96.4 9-20.6 21.5-39.4 36.5-55.6-82.7 1.4-149.3 68.9-149.3 152z"]],
    "traffic-cone": [512, 512, [], "f636", ["M89.4 464l333.2 0-38.5-96-256.2 0-38.5 96zm57.7-144l217.7 0-38.5-96-140.7 0-38.5 96zm57.7-144L307.1 176 256 48.6 204.9 176z", "M364.8 320l-217.7 0 38.5-96 140.7 0 38.5 96zm19.2 48l38.5 96-333.2 0 38.5-96 256.2 0zM256 48.6L307.1 176 204.9 176 256 48.6zM474.3 464L300.2 29.9C293 11.8 275.5 0 256 0s-37 11.8-44.2 29.9L37.7 464 24 464c-13.3 0-24 10.7-24 24s10.7 24 24 24l464 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-13.7 0z"]],
    "star-sharp-half-stroke": [512, 512, ["star-sharp-half-alt"], "e28d", ["M94 224l88.8 69.1c7.9 6.2 11.2 16.6 8.1 26.2l-32.5 102.3 77.7-60.4 0-195.1-13.1 41.3c-3.2 10-12.4 16.7-22.9 16.7L94 224z", "M278.9 16.7C275.7 6.8 266.5 0 256 0s-19.7 6.8-22.9 16.7L182.5 176 24 176c-10.3 0-19.4 6.5-22.7 16.2s-.1 20.4 8 26.7L140.1 320.7 89.1 480.7c-3.2 10 .5 21 9.1 27s20.2 5.7 28.5-.7L256 406.4 385.3 506.9c8.3 6.5 19.8 6.8 28.5 .7s12.3-16.9 9.1-27L371.9 320.7 502.7 218.9c8.1-6.3 11.3-17 8-26.7S498.3 176 488 176l-158.5 0-50.7-159.3zM236 166l0 195.1-77.7 60.4 32.5-102.3c3-9.6-.2-20-8.1-26.2L94 224 200 224c10.5 0 19.7-6.8 22.9-16.7L236 166zm40 195.1l0-195.1 13.1 41.3c3.2 10 12.4 16.7 22.9 16.7l106.1 0-88.8 69.1c-7.9 6.2-11.2 16.6-8.1 26.2l32.5 102.3-77.7-60.4z"]],
    "h1": [512, 512, [], "f313", ["", "M440 88c0-8.5-4.5-16.4-11.8-20.7s-16.4-4.4-23.8-.3l-72 40c-11.6 6.4-15.8 21-9.3 32.6s21 15.8 32.6 9.3l36.3-20.2 0 271.2-48 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l144 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0 0-312zM48 88c0-13.3-10.7-24-24-24S0 74.7 0 88L0 424c0 13.3 10.7 24 24 24s24-10.7 24-24l0-144 160 0 0 144c0 13.3 10.7 24 24 24s24-10.7 24-24l0-336c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 144-160 0 0-144z"]],
    "tamale": [320, 512, [129748], "e451", ["M32.3 192c13.3 0 26.6 0 39.9 0L51.8 38.8C70.7 29 105.8 16 160.3 16s89.6 13 108.5 22.8L248.4 192c115.8 0-208.1 0-216.1 0zM51.8 473.2L69 344c5.6 13.9 16.2 26 30.7 33.2 .4 .2 .8 .4 1.2 .6l-8.5 67.7c-1.4 11 6.4 21 17.4 22.3s21-6.4 22.3-17.4l8.5-67.7c6.9-1.4 13.6-3.9 19.7-7.4 8.5 4.9 18 7.8 27.8 8.4l8.3 66.6c1.4 11 11.4 18.7 22.3 17.4s18.7-11.4 17.4-22.3l-9-71.8c11.3-7.3 19.7-17.8 24.5-29.6l17.2 129.1c-18.9 9.9-54 22.8-108.5 22.8S70.7 483 51.8 473.2zM92.5 66.5l15.7 125.5 40.3 0-16.3-130.5c-1.4-11-11.4-18.7-22.3-17.4S91.1 55.5 92.5 66.5zM180.2 192l40.3 0 15.7-125.5c1.4-11-6.4-21-17.4-22.3s-21 6.4-22.3 17.4L180.2 192z", "M160.3 16C105.8 16 70.7 29 51.8 38.8L72.2 192 32.3 192c-2.9 0-5.7 .2-8.5 .6L4 43.4C1.7 26.1 7.7 8.7 22.8 0 47-14 91.6-32 160.3-32S273.6-14 297.8 0C313 8.7 319 26.1 316.7 43.4L296.8 192.6c-2.8-.4-5.6-.6-8.5-.6l-39.9 0 20.4-153.2C249.9 29 214.9 16 160.3 16zm60.2 176l-40.3 0 16.3-130.5c1.4-11 11.4-18.7 22.3-17.4s18.7 11.4 17.4 22.3L220.5 192zM140.6 382.8l-8.5 67.7c-1.4 11-11.4 18.7-22.3 17.4s-18.7-11.4-17.4-22.3l8.5-67.7c12.8 6.1 26.7 7.5 39.7 5zM256.3 320l32 0c2.9 0 5.7-.2 8.5-.6l19.9 149.1c2.3 17.3-3.7 34.7-18.8 43.4-24.2 14-68.9 32-137.5 32S47 526 22.8 512C7.7 503.3 1.7 485.9 4 468.6L23.9 319.4c2.8 .4 5.6 .6 8.5 .6l32 0c0 8.3 1.6 16.4 4.7 24L51.8 473.2c18.9 9.9 54 22.8 108.5 22.8s89.6-13 108.5-22.8L251.6 344c3.1-7.6 4.7-15.8 4.7-24zM236.2 445.5c1.4 11-6.4 21-17.4 22.3s-21-6.4-22.3-17.4l-8.3-66.6c11 .7 22.3-1.4 32.8-6.6 2.2-1.1 4.3-2.3 6.2-3.6l9 71.8zM148.5 192l-40.3 0-15.7-125.5c-1.4-11 6.4-21 17.4-22.3s21 6.4 22.3 17.4L148.5 192zM8.3 256c0-13.3 10.7-24 24-24l256 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-89.2 0 14.6 29.3c5.9 11.9 1.1 26.3-10.7 32.2s-26.3 1.1-32.2-10.7l-10.5-21.1-10.5 21.1c-5.9 11.9-20.3 16.7-32.2 10.7s-16.7-20.3-10.7-32.2l14.6-29.3-89.2 0c-13.3 0-24-10.7-24-24z"]],
    "route-highway": [448, 512, [], "f61a", ["M51.2 352.1c5.9 19.3 19.6 35.7 38.4 44.8l47.5 22.8-85.9-67.5z", "M236.3 3.4c-7.6-4.6-17.1-4.6-24.7 0L202.3 9c-37.5 22.5-83.6 25.1-123.3 7-18.7-8.5-40.7-1.4-50.9 16.4L7.4 68.7c-6.6 11.6-7 25.8-1 37.7l8.5 16.9c11.3 22.6 17.2 47.5 17.2 72.7 0 20.7-3.9 41.2-11.6 60.4L8.7 285.7C2.9 300 0 315.3 0 330.7 0 377.4 26.8 419.9 68.8 440.1l144.8 69.5c6.6 3.2 14.2 3.2 20.8 0l144.8-69.5c42.1-20.2 68.8-62.7 68.8-109.4 0-15.4-2.9-30.7-8.7-45.1l-11.7-29.2c-7.7-19.2-11.6-39.7-11.6-60.4 0-25.2 5.9-50.1 17.2-72.7l8.5-16.9c6-12 5.6-26.1-1-37.7L419.9 32.5c-10.2-17.8-32.2-24.9-50.9-16.4-39.8 18.1-85.9 15.4-123.3-7l-9.4-5.6zM394.8 303.5c3.5 8.7 5.2 17.9 5.2 27.2 0 28.2-16.2 53.9-41.6 66.1L224 461.4 89.6 396.9c-25.4-12.2-41.6-37.9-41.6-66.1 0-9.3 1.8-18.6 5.2-27.2l11.7-29.2c10-24.9 15.1-51.4 15.1-78.2 0-1.4 0-2.7 0-4.1L368 192c0 1.4 0 2.7 0 4.1 0 26.8 5.1 53.3 15.1 78.2l11.7 29.2z"]],
    "paper-plane": [576, 512, [61913], "f1d8", ["M88 185.3L256.6 253.8 457.4 53 88 185.3zM290.5 287.7L359 456.3 491.4 86.9 290.5 287.7z", "M290.5 287.7L491.4 86.9 359 456.3 290.5 287.7zM457.4 53L256.6 253.8 88 185.3 457.4 53zM38.1 216.8l205.8 83.6 83.6 205.8c5.3 13.1 18.1 21.7 32.3 21.7 14.7 0 27.8-9.2 32.8-23.1L570.6 8c3.5-9.8 1-20.6-6.3-28s-18.2-9.8-28-6.3L39.4 151.7c-13.9 5-23.1 18.1-23.1 32.8 0 14.2 8.6 27 21.7 32.3z"]],
    "object-intersect": [512, 512, [], "e49d", ["M208 224l0 80 80 0c8.8 0 16-7.2 16-16l0-80-80 0c-8.8 0-16 7.2-16 16z", "M64 48c-8.8 0-16 7.2-16 16l0 16-48 0 0-16C0 28.7 28.7 0 64 0l16 0 0 48-16 0zm160 0l-96 0 0-48 96 0 0 48zM48 128l0 96-48 0 0-96 48 0zM0 288l0-16 48 0 0 16c0 8.8 7.2 16 16 16l48 0 0 48-48 0c-35.3 0-64-28.7-64-64zm160 64l0-128c0-35.3 28.7-64 64-64l128 0 0 128c0 35.3-28.7 64-64 64l-128 0zm304-64l48 0 0 96-48 0 0-96zm48-48l-48 0 0-16c0-8.8-7.2-16-16-16l-48 0 0-48 48 0c35.3 0 64 28.7 64 64l0 16zm0 192l0 16c0 35.3-28.7 64-64 64l-16 0 0-48 16 0c8.8 0 16-7.2 16-16l0-16 48 0zM384 512l-96 0 0-48 96 0 0 48zM160 400l48 0 0 48c0 8.8 7.2 16 16 16l16 0 0 48-16 0c-35.3 0-64-28.7-64-64l0-48zM352 112l-48 0 0-48c0-8.8-7.2-16-16-16l-16 0 0-48 16 0c35.3 0 64 28.7 64 64l0 48zm-48 96l-80 0c-8.8 0-16 7.2-16 16l0 80 80 0c8.8 0 16-7.2 16-16l0-80z"]],
    "book-atlas": [448, 512, ["atlas"], "f558", ["M48 88l0 270.7c9.8-4.3 20.6-6.7 32-6.7l296 0c13.3 0 24-10.7 24-24l0-256c0-13.3-10.7-24-24-24L88 48C65.9 48 48 65.9 48 88zM344 200a120 120 0 1 1 -240 0 120 120 0 1 1 240 0z", "M0 88C0 39.4 39.4 0 88 0L376 0c39.8 0 72 32.2 72 72l0 256c0 25-12.7 47-32 59.9l0 76.1 8 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L80 512c-44.2 0-80-35.8-80-80L0 88zM48 432c0 17.7 14.3 32 32 32l288 0 0-64-288 0c-17.7 0-32 14.3-32 32zm0-73.3c9.8-4.3 20.6-6.7 32-6.7l296 0c13.3 0 24-10.7 24-24l0-256c0-13.3-10.7-24-24-24L88 48C65.9 48 48 65.9 48 88l0 270.7zM302.4 216l-26.9 0c-1.3 19.7-5 37.7-10.4 52.7 18.9-11.4 32.8-30.3 37.3-52.7zm-156.8 0c4.5 22.3 18.4 41.3 37.3 52.7-5.4-15-9.1-33-10.4-52.7l-26.9 0zm70.7 49.7c3.2 6.9 5.9 10.6 7.7 12.6 1.8-1.9 4.5-5.6 7.7-12.6 5.6-12.1 10.1-29.3 11.6-49.7l-38.8 0c1.6 20.4 6 37.6 11.6 49.7zm0-131.4c-5.6 12.1-10.1 29.3-11.6 49.7l38.8 0c-1.6-20.4-6-37.6-11.6-49.7-3.2-6.9-5.9-10.6-7.7-12.6-1.8 1.9-4.5 5.6-7.7 12.6zM302.4 184c-4.5-22.3-18.4-41.3-37.3-52.7 5.4 15 9.1 33 10.4 52.7l26.9 0zm-129.9 0c1.3-19.7 5-37.7 10.4-52.7-18.9 11.4-32.8 30.3-37.3 52.7l26.9 0zM104 200a120 120 0 1 1 240 0 120 120 0 1 1 -240 0z"]],
    "table": [448, 512, [], "f0ce", ["M48 160l0 112 152 0 0-112-152 0zm0 160l0 96c0 8.8 7.2 16 16 16l136 0 0-112-152 0zM248 160l0 112 152 0 0-112-152 0zm0 160l0 112 136 0c8.8 0 16-7.2 16-16l0-96-152 0z", "M48 272l152 0 0-112-152 0 0 112zM0 320L0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64l0-96zm400-48l0-112-152 0 0 112 152 0zm0 48l-152 0 0 112 136 0c8.8 0 16-7.2 16-16l0-96zM200 432l0-112-152 0 0 96c0 8.8 7.2 16 16 16l136 0z"]],
    "circle-sort": [512, 512, ["sort-circle"], "e030", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm105.8-46.8c-3.7-9-1.7-19.3 5.2-26.2l80-80c9.4-9.4 24.6-9.4 33.9 0l80 80c6.9 6.9 8.9 17.2 5.2 26.2S345.7 224 336 224l-160 0c-9.7 0-18.5-5.8-22.2-14.8zm0 93.6c3.7-9 12.5-14.8 22.2-14.8l160 0c9.7 0 18.5 5.8 22.2 14.8s1.7 19.3-5.2 26.2l-80 80c-9.4 9.4-24.6 9.4-33.9 0l-80-80c-6.9-6.9-8.9-17.2-5.2-26.2z", "M464 256a208 208 0 1 0 -416 0 208 208 0 1 0 416 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zM273 103l80 80c6.9 6.9 8.9 17.2 5.2 26.2S345.7 224 336 224l-160 0c-9.7 0-18.5-5.8-22.2-14.8s-1.7-19.3 5.2-26.2l80-80c9.4-9.4 24.6-9.4 33.9 0zM239 409l-80-80c-6.9-6.9-8.9-17.2-5.2-26.2S166.3 288 176 288l160 0c9.7 0 18.5 5.8 22.2 14.8s1.7 19.3-5.2 26.2l-80 80c-9.4 9.4-24.6 9.4-33.9 0z"]],
    "heart": [512, 512, [128153, 128154, 128155, 128156, 128420, 129293, 129294, 129505, 9829, 10084, 61578], "f004", ["M48 165.1c0 49.9 32 98.4 68.1 142.3 41.1 50 91.4 94 125.9 120.3 3.2 2.4 7.9 4.2 14 4.2s10.8-1.8 14-4.2c34.5-26.3 84.8-70.4 125.9-120.3 36.2-43.9 68.1-92.4 68.1-142.3 0-47-38.1-85.1-85.1-85.1-27.3 0-53 13.1-69 35.2l-34.4 47.6c-4.5 6.2-11.7 9.9-19.4 9.9s-14.9-3.7-19.4-9.9l-34.4-47.6c-16-22.1-41.7-35.2-69-35.2-47 0-85.1 38.1-85.1 85.1z", "M378.9 80c-27.3 0-53 13.1-69 35.2l-34.4 47.6c-4.5 6.2-11.7 9.9-19.4 9.9s-14.9-3.7-19.4-9.9l-34.4-47.6c-16-22.1-41.7-35.2-69-35.2-47 0-85.1 38.1-85.1 85.1 0 49.9 32 98.4 68.1 142.3 41.1 50 91.4 94 125.9 120.3 3.2 2.4 7.9 4.2 14 4.2s10.8-1.8 14-4.2c34.5-26.3 84.8-70.4 125.9-120.3 36.2-43.9 68.1-92.4 68.1-142.3 0-47-38.1-85.1-85.1-85.1zM271 87.1c25-34.6 65.2-55.1 107.9-55.1 73.5 0 133.1 59.6 133.1 133.1 0 68.6-42.9 128.9-79.1 172.8-44.1 53.6-97.3 100.1-133.8 127.9-12.3 9.4-27.5 14.1-43.1 14.1s-30.8-4.7-43.1-14.1C176.4 438 123.2 391.5 79.1 338 42.9 294.1 0 233.7 0 165.1 0 91.6 59.6 32 133.1 32 175.8 32 216 52.5 241 87.1l15 20.7 15-20.7z"]],
    "scythe": [576, 512, [], "f710", ["M66.9 176l428.5 0 26.5-128-211.2 0C212.8 48 121.9 96.2 66.9 176z", "M496 176l26.5-128-211.9 0C212.8 48 121.9 96.2 66.9 176L496 176zM472.9 288l13.2-64-462.1 0c-8.6 0-16.6-4.6-20.8-12.1s-4.2-16.7 .2-24.1L14.4 169C76.3 64.3 188.9 0 310.6 0L552 0c7.2 0 14.1 3.2 18.6 8.8s6.4 12.9 4.9 20l-96 464c-2.7 13-15.4 21.3-28.4 18.6s-21.3-15.4-18.6-28.4L462.9 336 344 336c-13.3 0-24-10.7-24-24s10.7-24 24-24l128.9 0z"]],
    "circle-chevron-up": [512, 512, ["chevron-circle-up"], "f139", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm87 15L239 167c9.4-9.4 24.6-9.4 33.9 0L377 271c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-87-87-87 87c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9z", "M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM377 271L273 167c-9.4-9.4-24.6-9.4-33.9 0L135 271c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l87-87 87 87c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9z"]],
    "apostrophe": [192, 512, [], "27", ["M48 96l0 64c0 8.8 7.2 16 16 16l64 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16z", "M128 176c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16l64 0zm16 46c-5.1 1.3-10.5 2-16 2l-64 0c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l64 0c35.3 0 64 28.7 64 64l0 136c0 66.3-53.7 120-120 120l-16 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l16 0c39.8 0 72-32.2 72-72l0-10z"]],
    "battery-half": [640, 512, ["battery-3"], "f242", ["M176 208l0 96 112 0 0-96-112 0z", "M528 112c17.7 0 32 14.3 32 32l0 224c0 17.7-14.3 32-32 32l-416 0c-17.7 0-32-14.3-32-32l0-224c0-17.7 14.3-32 32-32l416 0zM112 64c-44.2 0-80 35.8-80 80l0 224c0 44.2 35.8 80 80 80l416 0c44.2 0 80-35.8 80-80l0-48c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l0-48c0-44.2-35.8-80-80-80L112 64zm64 240l0-96 112 0 0 96-112 0zM128 184l0 144c0 13.3 10.7 24 24 24l160 0c13.3 0 24-10.7 24-24l0-144c0-13.3-10.7-24-24-24l-160 0c-13.3 0-24 10.7-24 24z"]],
    "font-awesome": [512, 512, [62501, 62694, "font-awesome-flag", "font-awesome-logo-full"], "f2b4", ["M80 144l0 256 356.4 0-48.2-108.5c-5.5-12.4-5.5-26.6 0-39L436.4 144 80 144z", "M91.7 96C106.3 86.8 116 70.5 116 52 116 23.3 92.7 0 64 0S12 23.3 12 52c0 16.7 7.8 31.5 20 41l0 419 48 0 0-64 389.6 0c14.6 0 26.4-11.8 26.4-26.4 0-3.7-.8-7.3-2.3-10.7L432 272 493.7 133.1c1.5-3.4 2.3-7 2.3-10.7 0-14.6-11.8-26.4-26.4-26.4L91.7 96zM80 400l0-256 356.4 0-48.2 108.5c-5.5 12.4-5.5 26.6 0 39L436.4 400 80 400z"]],
    "handcuffs": [576, 512, [], "e4f8", ["", "M320-32c0-17.7-14.3-32-32-32s-32 14.3-32 32 14.3 32 32 32 32-14.3 32-32zM192 64a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM152 96c-13.3 0-24 10.7-24 24l0 16c0 1 .1 1.9 .2 2.9-74.7 26.3-128.2 97.5-128.2 181.1 0 106 86 192 192 192s192-86 192-192c0-83.7-53.5-154.8-128.2-181.1 .1-.9 .2-1.9 .2-2.9l0-16c0-13.3-10.7-24-24-24l-80 0zM48 320a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm480 0c0 79.5-64.5 144-144 144-12.1 16.2-26.3 30.8-42 43.4 13.5 3 27.6 4.6 42 4.6 106 0 192-86 192-192 0-83.7-53.5-154.8-128.2-181.1 .1-.9 .2-1.9 .2-2.9l0-16c0-13.3-10.7-24-24-24l-80 0c-12.3 0-22.4 9.2-23.8 21.1 24.7 15.6 46.3 35.6 63.8 58.9 79.5 0 144 64.5 144 144zM384 64a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]],
    "square-bangladeshi-taka": [448, 512, [], "e744", ["M48 96l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16zm56.5 51.3c2.6-13 15.2-21.4 28.2-18.8l10.6 2.1c28.3 5.7 48.7 30.5 48.7 59.4l0 18 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0 0 83.4c0 6.9 5.6 12.6 12.6 12.6l24 0c37.2 0 67.4-30.2 67.4-67.4l0-16c0-6.9-5.6-12.6-12.6-12.6l-3.4 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l3.4 0c33.5 0 60.6 27.1 60.6 60.6l0 16C344 332.3 292.3 384 228.6 384l-24 0c-33.5 0-60.6-27.1-60.6-60.6l0-83.4-13.7 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l13.7 0 0-18c0-6-4.2-11.2-10.1-12.3l-10.6-2.1c-13-2.6-21.4-15.2-18.8-28.2z", "M64 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm104.5 51.3c2.6-13 15.2-21.4 28.2-18.8l10.6 2.1c28.3 5.7 48.7 30.5 48.7 59.4l0 18 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0 0 83.4c0 6.9 5.6 12.6 12.6 12.6l24 0c37.2 0 67.4-30.2 67.4-67.4l0-16c0-6.9-5.6-12.6-12.6-12.6l-3.4 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l3.4 0c33.5 0 60.6 27.1 60.6 60.6l0 16C344 332.3 292.3 384 228.6 384l-24 0c-33.5 0-60.6-27.1-60.6-60.6l0-83.4-13.7 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l13.7 0 0-18c0-6-4.2-11.2-10.1-12.3l-10.6-2.1c-13-2.6-21.4-15.2-18.8-28.2z"]],
    "hat-cowboy-side": [640, 512, [], "f8c1", ["M48 351.7L48 372c0 15.5 12.5 28 28 28l336.4 0-153.7-124.9C230.8 252.4 195.8 240 159.7 240 98 240 48 290 48 351.7zM204.5 196.9c23.1 5.2 45.2 14.3 65.2 27.1l171.8 0-26.9-121.2c-3-13.3-14.7-22.8-28.4-22.8l-1 0c-3.9 0-7.7 .9-11.1 2.6-34 17-74.1 17-108.1 0-3.5-1.7-7.3-2.6-11.1-2.6l-1 0c-13.6 0-25.4 9.5-28.4 22.8l-20.9 94.2zm290.5 46.8L529.8 400 564 400c15.5 0 28-12.5 28-28l0-4c0-60-41.3-110.3-96.9-124.2z", "M253.8 80c-13.6 0-25.4 9.5-28.4 22.8l-20.9 94.2c23.1 5.2 45.2 14.3 65.2 27.1l171.8 0-26.9-121.2c-3-13.3-14.7-22.8-28.4-22.8l-1 0c-3.9 0-7.7 .9-11.1 2.6-34 17-74.1 17-108.1 0-3.5-1.7-7.3-2.6-11.1-2.6l-1 0zM156.4 192l22.2-99.7C186.4 57.1 217.7 32 253.8 32l1 0c11.3 0 22.5 2.6 32.6 7.7 20.5 10.3 44.7 10.3 65.2 0 10.1-5.1 21.3-7.7 32.6-7.7l1 0c36.1 0 67.4 25.1 75.2 60.3l22.4 100.8C571.7 202.9 640 277.5 640 368l0 4c0 42-34 76-76 76L76 448c-42 0-76-34-76-76l0-20.3C0 264.6 69.7 193.8 156.4 192zm338.6 51.8L529.8 400 564 400c15.5 0 28-12.5 28-28l0-4c0-60-41.3-110.3-96.9-124.2zM478.9 392.2L452.2 272 331 272 478.9 392.2zM159.7 240C98 240 48 290 48 351.7L48 372c0 15.5 12.5 28 28 28l336.4 0-153.7-124.9c-28-22.7-62.9-35.1-99-35.1z"]],
    "sausage": [512, 512, [], "f820", ["M112 416c0-26.5 21.5-48 48-48 114.9 0 208-93.1 208-208 0-26.5 21.5-48 48-48s48 21.5 48 48c0 167.9-136.1 304-304 304-26.5 0-48-21.5-48-48z", "M447.5 69.3l15.2-41.9c.8-2.2 1.2-4.6 1.2-7 0-11.3-9.1-20.4-20.4-20.4L388.4 0c-11.3 0-20.4 9.1-20.4 20.4 0 2.4 .4 4.7 1.2 7l15.2 41.9c-37.5 13-64.5 48.7-64.5 90.7 0 88.4-71.6 160-160 160-42 0-77.7 26.9-90.7 64.5L27.4 369.2c-2.2-.8-4.6-1.2-7-1.2-11.3 0-20.4 9.1-20.4 20.4l0 55.2c0 11.3 9.1 20.4 20.4 20.4 2.4 0 4.7-.4 7-1.2l41.9-15.2c13 37.5 48.7 64.5 90.7 64.5 194.4 0 352-157.6 352-352 0-42-26.9-77.7-64.5-90.7zM112 416c0-26.5 21.5-48 48-48 114.9 0 208-93.1 208-208 0-26.5 21.5-48 48-48s48 21.5 48 48c0 167.9-136.1 304-304 304-26.5 0-48-21.5-48-48z"]],
    "chevrons-down": [448, 512, ["chevron-double-down"], "f322", ["", "M207.5 473c9.4 9.4 24.6 9.4 33.9 0l200-200c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-183 183-183-183c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l200 200zM7.5 81l200 200c9.4 9.4 24.6 9.4 33.9 0l200-200c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-183 183-183-183c-9.4-9.4-24.6-9.4-33.9 0S-1.8 71.6 7.5 81z"]],
    "industry": [512, 512, [], "f275", ["M48 88l0 328c0 8.8 7.2 16 16 16l384 0c8.8 0 16-7.2 16-16l0-260.1-139.1 89c-7.4 4.7-16.8 5-24.5 .8S288 233.4 288 224.6l0-70.9-139.9 81.6c-7.4 4.3-16.6 4.4-24 .1s-12-12.2-12-20.8L112 88c0-4.4-3.6-8-8-8L56 80c-4.4 0-8 3.6-8 8z", "M0 88C0 57.1 25.1 32 56 32l48 0c30.9 0 56 25.1 56 56l0 84.9 103.8-60.6c32-18.7 72.2 4.4 72.2 41.5l0 27 102.1-65.4C470.1 95 512 117.9 512 155.9L512 416c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 88zm56-8c-4.4 0-8 3.6-8 8l0 328c0 8.8 7.2 16 16 16l384 0c8.8 0 16-7.2 16-16l0-260.1-139.1 89c-7.4 4.7-16.8 5-24.5 .8S288 233.4 288 224.6l0-70.9-139.9 81.6c-7.4 4.3-16.6 4.4-24 .1s-12-12.2-12-20.8L112 88c0-4.4-3.6-8-8-8L56 80z"]],
    "people-dress-simple": [512, 512, [], "e218", ["M63.7 336l128.7 0-28.9-101.3c-4.5-15.8-19-26.7-35.4-26.7s-30.9 10.9-35.4 26.7L63.7 336zm256 0l128.7 0-28.9-101.3c-4.5-15.8-19-26.7-35.4-26.7s-30.9 10.9-35.4 26.7L319.7 336z", "M192.1 64a64 64 0 1 0 -128 0 64 64 0 1 0 128 0zm.4 272L63.7 336 92.7 234.7c4.5-15.8 19-26.7 35.4-26.7s30.9 10.9 35.4 26.7L192.5 336zM128.1 160c-37.9 0-71.2 25.1-81.6 61.5L11.8 343.2C5.9 363.7 21.3 384 42.5 384l21.6 0 0 104c0 13.3 10.7 24 24 24s24-10.7 24-24l0-104 32 0 0 104c0 13.3 10.7 24 24 24s24-10.7 24-24l0-104 21.6 0c21.3 0 36.6-20.3 30.8-40.8L209.7 221.5C199.3 185.1 166 160 128.1 160zm320-96a64 64 0 1 0 -128 0 64 64 0 1 0 128 0zm.4 272l-128.7 0 28.9-101.3c4.5-15.8 19-26.7 35.4-26.7s30.9 10.9 35.4 26.7L448.5 336zM384.1 160c-37.9 0-71.2 25.1-81.6 61.5L267.8 343.2c-5.8 20.4 9.5 40.8 30.8 40.8l21.6 0 0 104c0 13.3 10.7 24 24 24s24-10.7 24-24l0-104 32 0 0 104c0 13.3 10.7 24 24 24s24-10.7 24-24l0-104 21.6 0c21.3 0 36.6-20.3 30.8-40.8L465.7 221.5C455.3 185.1 422 160 384.1 160z"]],
    "lines-leaning": [384, 512, [], "e51e", ["", "M190.6 64.1c4.5-12.5-2-26.2-14.5-30.7s-26.2 2-30.7 14.5l-144 400c-4.5 12.5 2 26.2 14.5 30.7s26.2-2 30.7-14.5l144-400zm78.1-31.7c-13-2.6-25.6 5.8-28.2 18.8l-80 400c-2.6 13 5.8 25.6 18.8 28.2s25.6-5.8 28.2-18.8l80-400c2.6-13-5.8-25.6-18.8-28.2zM360 32c-13.3 0-24 10.7-24 24l0 400c0 13.3 10.7 24 24 24s24-10.7 24-24l0-400c0-13.3-10.7-24-24-24z"]],
    "passport": [384, 512, [], "f5ab", ["M48 64l0 384c0 8.8 7.2 16 16 16l256 0c8.8 0 16-7.2 16-16l0-384c0-8.8-7.2-16-16-16L64 48c-8.8 0-16 7.2-16 16zM312 200a120 120 0 1 1 -240 0 120 120 0 1 1 240 0zM96 392c0-13.3 10.7-24 24-24l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24z", "M320 48c8.8 0 16 7.2 16 16l0 384c0 8.8-7.2 16-16 16L64 464c-8.8 0-16-7.2-16-16L48 64c0-8.8 7.2-16 16-16l256 0zM64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-384c0-35.3-28.7-64-64-64L64 0zM96 392c0 13.3 10.7 24 24 24l144 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-144 0c-13.3 0-24 10.7-24 24zM270.4 216c-4.5 22.3-18.4 41.3-37.3 52.7 5.4-15 9.1-33 10.4-52.7l26.9 0zm-156.8 0l26.9 0c1.3 19.7 5 37.7 10.4 52.7-18.9-11.4-32.8-30.3-37.3-52.7zm70.7 49.7c-5.6-12.1-10.1-29.3-11.6-49.7l38.8 0c-1.6 20.4-6 37.6-11.6 49.7-3.2 6.9-5.9 10.6-7.7 12.6-1.8-1.9-4.5-5.6-7.7-12.6zm0-131.4c3.2-6.9 5.9-10.6 7.7-12.6 1.8 1.9 4.5 5.6 7.7 12.6 5.6 12.1 10.1 29.3 11.6 49.7l-38.8 0c1.6-20.4 6-37.6 11.6-49.7zM270.4 184l-26.9 0c-1.3-19.7-5-37.7-10.4-52.7 18.9 11.4 32.8 30.3 37.3 52.7zm-129.9 0l-26.9 0c4.5-22.3 18.4-41.3 37.3-52.7-5.4 15-9.1 33-10.4 52.7zM312 200a120 120 0 1 0 -240 0 120 120 0 1 0 240 0z"]],
    "infinity": [640, 512, [8734, 9854], "f534", ["", "M0 237.3c0-78 63.3-141.3 141.3-141.3 39 0 76.2 16.1 102.9 44.5L320 221 395.8 140.5C422.5 112.1 459.7 96 498.7 96 576.7 96 640 159.3 640 237.3l0 37.4c0 78-63.3 141.3-141.3 141.3-39 0-76.2-16.1-102.9-44.5L320 291 244.2 371.5C217.5 399.9 180.3 416 141.3 416 63.3 416 0 352.7 0 274.7l0-37.4zM287 256l-77.8-82.6c-17.6-18.7-42.2-29.4-68-29.4-51.5 0-93.3 41.8-93.3 93.3l0 37.4c0 51.5 41.8 93.3 93.3 93.3 25.7 0 50.3-10.6 68-29.4L287 256zm65.9 0l77.8 82.6c17.6 18.7 42.2 29.4 68 29.4 51.5 0 93.3-41.8 93.3-93.3l0-37.4c0-51.5-41.8-93.3-93.3-93.3-25.7 0-50.3 10.6-68 29.4L353 256z"]],
    "hand-heart": [640, 512, [], "f4bc", ["M117.2 292.7l2.5-2.1c6.2-4.1 14.7-3.4 20.1 2.1l43.7 43.7c6.9 6.9 17.2 8.9 26.2 5.2s14.8-12.5 14.8-22.2l0-223.4c0-8.8 7.2-16 16-16l3.2 .3c6.2 1.3 11.2 6.2 12.5 12.5l.3 3.2 0 136c0 13.3 10.7 24 24 24s24-10.7 24-24l0-168c0-8.8 7.2-16 16-16l3.2 .3c7.3 1.5 12.8 8 12.8 15.7l0 168c0 13.3 10.7 24 24 24s24-10.7 24-24l0-136 .3-3.2c1.5-7.3 8-12.8 15.7-12.8l3.2 .3c7.3 1.5 12.8 8 12.8 15.7l0 136c0 13.3 10.7 24 24 24s24-10.7 24-24l0-72c0-8.8 7.2-16 16-16l3.2 .3c7.3 1.5 12.8 8 12.8 15.7l0 108.1c-5.6 2.7-10.9 5.7-16 9.2-20.1-13.7-44.1-21.3-69.1-21.3-67.9 0-122.9 55-122.9 122.9l0 2.5c0 29.3 10.3 56.2 23.3 78.7-36.9-7.3-71.3-24.4-99.4-49.8l-7.5-7.1-87.8-87.8c-6.2-6.2-6.2-16.4 0-22.6z", "M549.6 304c41.4 0 74.9 33.5 74.9 74.9l0 2.5c0 64.4-82 133.4-122.2 163.3-13 9.7-30.5 9.7-43.5 0-40.2-30-122.2-98.9-122.3-163.3l0-2.5c0-41.3 33.5-74.9 74.9-74.9 24 0 46.6 11.5 60.7 31l8.4 11.7 8.4-11.7c14.1-19.5 36.7-31 60.7-31zM327 .3c22.5 2.3 41.5 16.3 51 35.8 7-2.6 14.6-4.1 22.5-4.1l6.5 .3c32.3 3.3 57.5 30.5 57.5 63.7l0 2.1c5.1-1.3 10.5-2.1 16-2.1l6.5 .3c32.3 3.3 57.5 30.5 57.5 63.7l0 96.2c-16.8 .7-33.1 4.8-48 11.9l0-108.1c0-7.7-5.5-14.2-12.8-15.7l-3.2-.3c-8.8 0-16 7.2-16 16l0 72c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-136c0-7.7-5.5-14.2-12.8-15.7l-3.2-.3c-7.7 0-14.2 5.5-15.7 12.8l-.3 3.2 0 136c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-168c0-7.7-5.5-14.2-12.8-15.7l-3.2-.3c-8.8 0-16 7.2-16 16l0 168c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-136-.3-3.2c-1.3-6.3-6.2-11.2-12.5-12.5l-3.2-.3c-8.8 0-16 7.2-16 16l0 223.4c0 9.7-5.9 18.4-14.8 22.2s-19.3 1.7-26.2-5.2l-43.7-43.7c-5.5-5.5-13.9-6.2-20.1-2.1l-2.5 2.1c-6.2 6.2-6.2 16.4 0 22.6l87.8 87.8 7.5 7.1c28.1 25.5 62.5 42.6 99.4 49.8 10.4 18.1 22.9 34.2 34.7 47.6 1.3 1.5 2.7 2.9 4 4.3-63.1-.4-123.7-24-170.3-66.2L171 437 83.2 349.3c-25-25-25-65.5 0-90.5l4.8-4.4c25.1-20.5 62.2-19 85.7 4.4l2.8 2.7 0-165.5c0-35.3 28.7-64 64-64l6.5 .3c5.5 .6 10.9 1.9 15.9 3.8 10.4-21.4 32.2-36.1 57.6-36.1L327 .3z"]],
    "clone": [512, 512, [], "f24d", ["M208 64l0 224c0 8.8 7.2 16 16 16l224 0c8.8 0 16-7.2 16-16l0-224c0-8.8-7.2-16-16-16L224 48c-8.8 0-16 7.2-16 16z", "M288 464L64 464c-8.8 0-16-7.2-16-16l0-224c0-8.8 7.2-16 16-16l48 0 0-48-48 0c-35.3 0-64 28.7-64 64L0 448c0 35.3 28.7 64 64 64l224 0c35.3 0 64-28.7 64-64l0-48-48 0 0 48c0 8.8-7.2 16-16 16zM224 304c-8.8 0-16-7.2-16-16l0-224c0-8.8 7.2-16 16-16l224 0c8.8 0 16 7.2 16 16l0 224c0 8.8-7.2 16-16 16l-224 0zm-64-16c0 35.3 28.7 64 64 64l224 0c35.3 0 64-28.7 64-64l0-224c0-35.3-28.7-64-64-64L224 0c-35.3 0-64 28.7-64 64l0 224z"]],
    "forward": [576, 512, [9193], "f04e", ["M112 90.7L112 421.3 284.4 256 112 90.7zm240 0L352 421.3 524.4 256 352 90.7z", "M112 421.3L112 90.7 284.4 256 112 421.3zM131.7 43.1C120.1 32 103 28.9 88.3 35.2S64 56 64 72l0 368c0 16 9.6 30.5 24.3 36.8s31.8 3.2 43.4-7.9L304 303.7 304 440c0 16 9.6 30.5 24.3 36.8s31.8 3.2 43.4-7.9l192-184c7.9-7.5 12.3-18 12.3-28.9s-4.5-21.3-12.3-28.9l-192-184C360.1 32 343 28.9 328.3 35.2S304 56 304 72l0 136.3-172.3-165.1zM524.4 256L352 421.3 352 90.7 524.4 256z"]],
    "square-r": [448, 512, [], "e27c", ["M48 96l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16zm96 72c0-13.3 10.7-24 24-24l80 0c39.8 0 72 32.2 72 72 0 28.9-17 53.8-41.6 65.3l30.2 50.3c6.8 11.4 3.1 26.1-8.2 32.9s-26.1 3.1-32.9-8.2l-41-68.3-34.4 0 0 56c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-176zm48 24l0 48 56 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-56 0z", "M64 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm168 48l80 0c39.8 0 72 32.2 72 72 0 28.9-17 53.8-41.6 65.3l30.2 50.3c6.8 11.4 3.1 26.1-8.2 32.9s-26.1 3.1-32.9-8.2l-41-68.3-34.4 0 0 56c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-176c0-13.3 10.7-24 24-24zm72 96l8 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-56 0 0 48 48 0z"]],
    "period": [192, 512, [], "2e", ["M72 416c0 13.3 10.7 24 24 24s24-10.7 24-24-10.7-24-24-24-24 10.7-24 24z", "M96 440c-13.3 0-24-10.7-24-24s10.7-24 24-24 24 10.7 24 24-10.7 24-24 24zm0 48c39.8 0 72-32.2 72-72s-32.2-72-72-72-72 32.2-72 72 32.2 72 72 72z"]],
    "m": [448, 512, [109], "4d", ["", "M17.1 33C27.3 30 38.2 34 44 42.8L224 316.3 403.9 42.8C409.8 34 420.7 30 430.9 33S448 45.4 448 56l0 400c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-319.9-155.9 237c-4.4 6.7-12 10.8-20.1 10.8s-15.6-4.1-20-10.8L48 136.1 48 456c0 13.3-10.7 24-24 24S0 469.3 0 456L0 56C0 45.4 7 36.1 17.1 33z"]],
    "money-check-pen": [640, 512, ["money-check-edit"], "f872", ["", "M480.1 112l-384 0c-8.8 0-16 7.2-16 16l0 256c0 8.8 7.2 16 16 16l220 0-.2 .2c-13.3 13.3-23 29.8-28.3 47.8L96.1 448c-35.3 0-64-28.7-64-64l0-256c0-35.3 28.7-64 64-64l384 0c35.3 0 64 28.7 64 64l0 72.5c-17.1 2.6-33.7 9.5-48 20.6l0-93.2c0-8.8-7.2-16-16-16zm-352 184c0-13.3 10.7-24 24-24l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24zm24-104l272 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-272 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zM332.3 466.9c2.5-12.4 8.6-23.8 17.5-32.7l118.9-118.9 80 80-118.9 118.9c-8.9 8.9-20.3 15-32.7 17.5l-59.6 11.9c-.9 .2-1.9 .3-2.9 .3-8 0-14.6-6.5-14.6-14.6 0-1 .1-1.9 .3-2.9l11.9-59.6zm267.8-123l-28.8 28.8-80-80 28.8-28.8c22.1-22.1 57.9-22.1 80 0s22.1 57.9 0 80z"]],
    "road-spikes": [640, 512, [], "e568", ["M112 222.5l0 81.5 54.3 0-54.3-81.5zm128 0l0 81.5 54.3 0-54.3-81.5zm128 0l0 81.5 54.3 0-54.3-81.5zm128 0l0 81.5 54.3 0-54.3-81.5z", "M192 352l-128 0 0-235.2c0-15.8 20.5-22 29.3-8.9 3.3 5 8.5 12.7 15.5 23.2l3.2 4.8 80 120 0-139.2c0-15.8 20.5-22 29.3-8.9 3.3 5 8.5 12.7 15.5 23.2l3.2 4.8 80 120 0-139.2c0-15.8 20.5-22 29.3-8.9 3.3 5 8.5 12.7 15.5 23.2l3.2 4.8 80 120 0-139.2c0-15.8 20.5-22 29.3-8.9 3.3 5 8.5 12.7 15.5 23.2L496 136 606.8 302.2c14.2 21.3-1.1 49.8-26.6 49.8L192 352zm-25.7-48l-54.3-81.5 0 81.5 54.3 0zM0 424c0-13.3 10.7-24 24-24l592 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 448c-13.3 0-24-10.7-24-24zM240 222.5l0 81.5 54.3 0-54.3-81.5zM422.3 304l-54.3-81.5 0 81.5 54.3 0zM496 222.5l0 81.5 54.3 0-54.3-81.5z"]],
    "fish-cooked": [576, 512, [], "f7fe", ["M58.5 350.1l59.2-44.4c10-7.5 24.2-6.1 32.4 3.4 19.9 22.6 47.5 45.7 78 63 30.7 17.4 62.7 28 91.8 28 44.8 0 97.6-25.1 140.5-58.9 21.1-16.6 38.7-34.5 50.7-50.7 12.8-17.2 16.8-29.1 16.8-34.4s-4-17.2-16.8-34.4c-12.1-16.2-29.6-34.1-50.7-50.7-42.9-33.8-95.7-58.9-140.5-58.9-29.2 0-61.3 10.6-92 28.1-30.6 17.3-58.2 40.5-78 63.1-8.2 9.4-22.2 10.9-32.2 3.5l-58.8-43.1 18.7 79.5c2 8.4 2 17.2 0 25.7L58.5 350.1zM223 207l48-48c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-48 48c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9zm32 96L383 175c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9L289 337c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9zm112 16l48-48c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-48 48c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9z", "M150 203.2c19.9-22.7 47.5-45.8 78-63.1 30.7-17.4 62.8-28.1 92-28.1 44.8 0 97.6 25.1 140.5 58.9 21.1 16.6 38.7 34.5 50.7 50.7 12.8 17.2 16.8 29.1 16.8 34.4s-4 17.2-16.8 34.4c-12.1 16.2-29.6 34.1-50.7 50.7-42.9 33.8-95.7 58.9-140.5 58.9-29.1 0-61.2-10.6-91.8-28-30.5-17.3-58.1-40.3-78-63-8.3-9.4-22.4-10.9-32.4-3.4l-59.2 44.4 19.1-81.3c2-8.4 2-17.2 0-25.7l-18.7-79.5 58.8 43.1c10 7.4 24 5.8 32.2-3.5zM320 64c-40.2 0-80.5 14.4-115.7 34.3-28.2 16-54.1 36.1-75.3 57.2L56.8 102.6C51 98.3 43.9 96 36.7 96 14.7 96-1.5 116.5 3.5 137.9L30.9 254.2c.3 1.2 .3 2.5 0 3.7L1.7 382.2c-2.5 10.8 .7 22.1 8.5 29.9l0 0c11.2 11.2 29 12.5 41.8 3l77.5-58.1c21.2 20.9 47 41 75.1 56.9 35.1 19.9 75.4 34.2 115.5 34.2 60.2 0 123.4-32.2 170.2-69.1 23.8-18.7 44.5-39.5 59.6-59.8 14.3-19.3 26.2-41.7 26.2-63.1s-11.9-43.8-26.2-63.1c-15-20.3-35.8-41.1-59.6-59.8-46.9-36.9-110-69.1-170.2-69.1zM305 193c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-48 48c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l48-48zm112 16c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0L255 303c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0L417 209zm32 96c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-48 48c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l48-48z"]],
    "person-seat-reclined": [512, 512, [], "e21f", ["M210.2 226.3c-2.1-9.4 5-18.3 14.6-18.3 7 0 13.1 4.8 14.6 11.7l26.4 116.3-11.6 0c-11.2 0-20.9-7.8-23.4-18.7l-20.7-91z", "M136 72a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zM67.2 160.5c13-2.7 25.7 5.7 28.3 18.7l40.2 195.4c6.9 33.5 36.4 57.5 70.5 57.5l89.8 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-89.8 0c-56.9 0-106.1-40-117.5-95.8L48.5 188.8c-2.7-13 5.7-25.7 18.7-28.3zm143.1 65.8l20.7 91c2.5 10.9 12.2 18.7 23.4 18.7l11.6 0-26.4-116.3c-1.6-6.8-7.6-11.7-14.6-11.7-9.6 0-16.8 8.9-14.6 18.3zM286.3 209l28.9 127 37.4 0c28.6 0 54.5 16.9 66 43.1l34.6 79.2 27.2-9.1c12.6-4.2 26.2 2.6 30.4 15.2s-2.6 26.2-15.2 30.4l-48 16c-11.8 3.9-24.6-1.8-29.6-13.1l-43.4-99.2c-3.8-8.7-12.5-14.4-22-14.4l-56.1 0c-.3 0-.7 0-1 0l-41.2 0c-33.6 0-62.8-23.3-70.2-56l-20.7-91c-9-39.4 21-77 61.4-77 29.4 0 54.9 20.4 61.4 49z"]],
    "mountain": [512, 512, [127956], "f6fc", ["M53.9 432l405.2 0-95-176-95.5 0-40.8 54.4c-4.5 6-11.5 9.5-19 9.6-6.5 .1-12.8-2.5-17.3-7.2l-1.8-2.1-41.4-53.3-94.2 174.5z", "M256.5 0c14.7 0 28.2 8.1 35.2 21l216 400c6.7 12.4 6.4 27.4-.8 39.5l-3 4.3c-6.4 8.2-15.8 13.5-26.2 14.8l-5.2 .3-432 0-5.2-.3C25 478.3 15.6 473 9.1 464.8l-3-4.3c-7.2-12.1-7.5-27.1-.8-39.5l216-400 2.9-4.6C231.7 6.2 243.6 0 256.5 0zm12 256l-40.8 54.4c-4.5 6-11.5 9.5-19 9.6-6.5 .1-12.8-2.5-17.3-7.2l-1.8-2.1-41.4-53.3-94.2 174.5 405.2 0-95-176-95.5 0zM173 211.3l35.1 45.1 29.2-38.8 1.8-2.2c4.5-4.7 10.8-7.4 17.4-7.4l81.6 0-81.6-151.2-83.4 154.5z"]],
    "circle-w": [512, 512, [], "e12c", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm80.8-81.7c-3.5-12.8 4.1-26 16.8-29.5s26 4.1 29.5 16.8l26.6 97.6 31.4-98.6c3.2-10 12.4-16.7 22.9-16.7s19.7 6.8 22.9 16.7l31.4 98.6 26.6-97.6c3.5-12.8 16.7-20.3 29.5-16.8s20.3 16.7 16.8 29.5l-48 176c-2.8 10.3-12 17.5-22.7 17.7s-20.1-6.6-23.4-16.7L256 247.2 222.9 351.3c-3.2 10.1-12.7 16.9-23.4 16.7s-19.9-7.4-22.7-17.7l-48-176z", "M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM175.2 161.7c-3.5-12.8-16.7-20.3-29.5-16.8s-20.3 16.7-16.8 29.5l48 176c2.8 10.3 12 17.5 22.7 17.7s20.1-6.6 23.4-16.7L256 247.2 289.1 351.3c3.2 10.1 12.7 16.9 23.4 16.7s19.9-7.4 22.7-17.7l48-176c3.5-12.8-4.1-26-16.8-29.5s-26 4.1-29.5 16.8l-26.6 97.6-31.4-98.6c-3.2-10-12.4-16.7-22.9-16.7s-19.7 6.8-22.9 16.7l-31.4 98.6-26.6-97.6z"]],
    "chess": [512, 512, [], "f439", ["M93.4 464l38.4-48 120.3 0 38.4 48-197.1 0zm32.2-320l132.7 0-28 56-76.7 0-28-56zm20.2 224l12-120 68.4 0 12 120-92.4 0z", "M192-32c13.3 0 24 10.7 24 24l0 16 16 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-16 0 0 40 78.1 0c14.3 0 25.9 11.6 25.9 25.9 0 4-.9 8-2.7 11.6l-33.5 66.8c11.4 1.8 20.2 11.7 20.2 23.7 0 13.3-10.7 24-24 24l-5.6 0 13.6 136 56.2 70.3c5 6.3 7.8 14.1 7.8 22.2 0 19.6-15.9 35.5-35.5 35.5L67.5 512c-19.6 0-35.5-15.9-35.5-35.5 0-8.1 2.7-15.9 7.8-22.2L96 384 109.6 248 104 248c-13.3 0-24-10.7-24-24 0-11.9 8.7-21.8 20.2-23.7L66.7 133.5c-1.8-3.6-2.7-7.6-2.7-11.6 0-14.3 11.6-25.9 25.9-25.9l78.1 0 0-40-16 0c-13.3 0-24-10.7-24-24S138.7 8 152 8l16 0 0-16c0-13.3 10.7-24 24-24zM490.5 160.1c12.1 1.2 21.5 11.5 21.5 23.9l0 104c0 4.7-1.4 9.4-4 13.3l-28 41.9 0 36.1 28.8 72.1 1.4 4c1.2 4 1.8 8.2 1.8 12.4 0 24.4-19.8 44.1-44.1 44.1L392 512c3.9-8.3 6.6-17.4 7.5-27l.4-8.5c0-4.2-.3-8.4-.9-12.5l63.1 0-19.2-48-67.9 0-38.4-48 95.4 0 0-32c0-4.7 1.4-9.4 4-13.3l28-42 0-72.7-32 0 0 24c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-24-33.8 0c-1.5-6.6-3.9-12.9-7.2-18.8l14.7-29.2 130.3 0 2.5 .1zM93.4 464l197.1 0-38.4-48-120.3 0-38.4 48zm52.4-96l92.4 0-12-120-68.4 0-12 120zm7.8-168l76.7 0 28-56-132.7 0 28 56z"]],
    "temperature-three-quarters": [320, 512, ["temperature-3", "thermometer-3", "thermometer-three-quarters"], "f2c8", ["M64 368c0 53 43 96 96 96s96-43 96-96c0-25.2-9.7-48.1-25.6-65.3-4.1-4.4-6.4-10.3-6.4-16.3L224 112c0-35.3-28.7-64-64-64S96 76.7 96 112l0 174.4c0 6.1-2.3 11.9-6.4 16.3-15.9 17.1-25.6 40-25.6 65.3zm48 0c0-17.8 9.7-33.3 24-41.6L136 176c0-13.3 10.7-24 24-24s24 10.7 24 24l0 150.4c14.3 8.3 24 23.8 24 41.6 0 26.5-21.5 48-48 48s-48-21.5-48-48z", "M160 48c-35.3 0-64 28.7-64 64l0 174.4c0 6.1-2.3 11.9-6.4 16.3-15.9 17.1-25.6 40-25.6 65.3 0 53 43 96 96 96s96-43 96-96c0-25.2-9.7-48.1-25.6-65.3-4.1-4.4-6.4-10.3-6.4-16.3L224 112c0-35.3-28.7-64-64-64zM48 112C48 50.1 98.1 0 160 0S272 50.1 272 112l0 165.5c20 24.7 32 56.2 32 90.5 0 79.5-64.5 144-144 144S16 447.5 16 368c0-34.3 12-65.8 32-90.5L48 112zM208 368c0 26.5-21.5 48-48 48s-48-21.5-48-48c0-17.8 9.7-33.3 24-41.6L136 176c0-13.3 10.7-24 24-24s24 10.7 24 24l0 150.4c14.3 8.3 24 23.8 24 41.6z"]],
    "b": [320, 512, [98], "42", ["", "M24 32C10.7 32 0 42.7 0 56L0 456c0 13.3 10.7 24 24 24l172 0c68.5 0 124-55.5 124-124 0-48.9-28.3-91.1-69.3-111.3 23-22.5 37.3-53.9 37.3-88.7 0-68.5-55.5-124-124-124L24 32zM164 232l-116 0 0-152 116 0c42 0 76 34 76 76s-34 76-76 76zM48 280l148 0c42 0 76 34 76 76s-34 76-76 76l-148 0 0-152z"]],
    "shield-virus": [512, 512, [], "e06c", ["M64 139.7c.5 91.4 38.4 249.3 186.4 320.1 3.6 1.7 7.8 1.7 11.3 0 148-70.8 185.9-228.7 186.3-320.1 0-5-3.1-10.2-9-12.8L256 49.4 73.1 127c-5.9 2.5-9.1 7.8-9 12.8zM112 240c0-13.3 10.7-24 24-24 22.9 0 34.4-27.7 18.2-43.9-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0c16.2 16.2 43.9 4.7 43.9-18.2 0-13.3 10.7-24 24-24s24 10.7 24 24c0 22.9 27.7 34.4 43.9 18.2 9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9c-16.2 16.2-4.7 43.9 18.2 43.9 13.3 0 24 10.7 24 24s-10.7 24-24 24c-22.9 0-34.4 27.7-18.2 43.9 9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0c-16.2-16.2-43.9-4.7-43.9 18.2 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-22.9-27.7-34.4-43.9-18.2-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9c16.2-16.2 4.7-43.9-18.2-43.9-13.3 0-24-10.7-24-24z", "M73.1 127L256 49.4 439 127c5.9 2.5 9.1 7.8 9 12.8-.4 91.4-38.4 249.3-186.3 320.1-3.6 1.7-7.8 1.7-11.3 0-148-70.8-185.9-228.7-186.4-320.1 0-5 3.1-10.2 9-12.8zM457.8 82.8L269.4 2.9C265.2 1 260.7 0 256 0s-9.2 1-13.4 2.9L54.3 82.8c-22 9.3-38.4 31-38.3 57.2 .5 99.2 41.3 280.7 213.6 363.2 16.7 8 36.1 8 52.8 0 172.4-82.5 213.1-264 213.6-363.2 .1-26.2-16.3-47.9-38.3-57.2zM256 96c-13.3 0-24 10.7-24 24 0 22.9-27.7 34.4-43.9 18.2-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9c16.2 16.2 4.7 43.9-18.2 43.9-13.3 0-24 10.7-24 24s10.7 24 24 24c22.9 0 34.4 27.7 18.2 43.9-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0c16.2-16.2 43.9-4.7 43.9 18.2 0 13.3 10.7 24 24 24s24-10.7 24-24c0-22.9 27.7-34.4 43.9-18.2 9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9c-16.2-16.2-4.7-43.9 18.2-43.9 13.3 0 24-10.7 24-24s-10.7-24-24-24c-22.9 0-34.4-27.7-18.2-43.9 9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0c-16.2 16.2-43.9 4.7-43.9-18.2 0-13.3-10.7-24-24-24zm-32 88a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm40 88a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"]],
    "triangle": [512, 512, [9650], "f2ec", ["M53.4 432L458.6 432 256 56.8 53.4 432z", "M256 56.8L53.4 432 458.6 432 256 56.8zM256 0c14.7 0 28.2 8.1 35.2 21l216 400c6.7 12.4 6.4 27.4-.8 39.5S486.1 480 472 480L40 480c-14.1 0-27.1-7.4-34.4-19.5s-7.5-27.1-.8-39.5l216-400c7-12.9 20.5-21 35.2-21z"]],
    "litecoin-sign": [384, 512, [], "e1d3", ["", "M112 56c0-13.3-10.7-24-24-24S64 42.7 64 56l0 164.5-46.2 12.3C5 236.2-2.6 249.4 .8 262.2s16.6 20.4 29.4 17l33.8-9 0 185.8c0 13.3 10.7 24 24 24l272 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-248 0 0-174.6 158.2-42.2c12.8-3.4 20.4-16.6 17-29.4s-16.6-20.4-29.4-17L112 207.7 112 56z"]],
    "dice-d6": [512, 512, [], "f6d1", ["M64 176.8l0 169.6c0 14.5 7.9 27.9 20.6 35l147.4 81.9 0-193.1-168-93.3zM82.2 132L256 228.6 429.8 132 275.4 46.3c-12.1-6.7-26.8-6.7-38.8 0L82.2 132zM280 270.1l0 193.1 147.5-81.9c12.7-7.1 20.6-20.4 20.6-35l0-169.6-168 93.3z", "M84.6 381.3c-12.7-7.1-20.6-20.4-20.6-35l0-169.6 168 93.3 0 193.1-147.4-81.9zM280 463.2l0-193.1 168-93.3 0 169.6c0 14.5-7.9 27.9-20.6 35L280 463.2zM429.8 132L256 228.6 82.2 132 236.6 46.3c12.1-6.7 26.8-6.7 38.8 0L429.8 132zM52.5 93.8C29.8 108.5 16 133.7 16 160.9l0 185.4c0 32 17.3 61.4 45.2 76.9l152 84.4c24.9 13.8 54.9 14.7 80.4 2.6l5-2.6 152-84.4c27.9-15.5 45.3-45 45.3-76.9l0-185.4c0-29-15.8-55.8-41.2-69.9L298.7 4.3c-26.6-14.8-58.9-14.8-85.5 0L57.2 91 52.5 93.8z"]],
    "grip-lines-vertical": [192, 512, [], "f7a5", ["", "M24 32C10.7 32 0 42.7 0 56L0 456c0 13.3 10.7 24 24 24s24-10.7 24-24L48 56c0-13.3-10.7-24-24-24zm144 0c-13.3 0-24 10.7-24 24l0 400c0 13.3 10.7 24 24 24s24-10.7 24-24l0-400c0-13.3-10.7-24-24-24z"]],
    "toggle-large-off": [576, 512, [], "e5b0", ["M336 256a144 144 0 1 1 -288 0 144 144 0 1 1 288 0z", "M192 400a144 144 0 1 1 0-288 144 144 0 1 1 0 288zm0 48l192 0c106 0 192-86 192-192S490 64 384 64L192 64C86 64 0 150 0 256S86 448 192 448zm127-48c39.9-35.2 65-86.7 65-144s-25.1-108.8-65-144l65 0c79.5 0 144 64.5 144 144S463.5 400 384 400l-65 0z"]],
    "golf-ball-tee": [384, 512, ["golf-ball"], "f450", ["M48 192c0-79.5 64.5-144 144-144s144 64.5 144 144c0 45.2-20.9 85.6-53.5 112 109.5 0-400.2 0-180.9 0-32.6-26.4-53.5-66.8-53.5-112zm112 16c0 8.8 7.2 16 16 16 26.5 0 48-21.5 48-48 0-8.8-7.2-16-16-16-7.7 0-14.2 5.5-15.7 12.8l-.6 6.4c-1.3 6.3-6.2 11.2-12.5 12.5l-6.4 .6c-7.3 1.5-12.8 8-12.8 15.7zm16 80c0 8.8 7.2 16 16 16 26.5 0 48-21.5 48-48 0-8.8-7.2-16-16-16-7.7 0-14.2 5.5-15.7 12.8l-.6 6.4c-1.3 6.3-6.2 11.2-12.5 12.5l-6.4 .6c-7.3 1.5-12.8 8-12.8 15.7zm64-64c0 8.8 7.2 16 16 16 26.5 0 48-21.5 48-48 0-8.8-7.2-16-16-16-7.7 0-14.2 5.5-15.7 12.8l-.6 6.4c-1.3 6.3-6.2 11.2-12.5 12.5l-6.4 .6c-7.3 1.5-12.8 8-12.8 15.7z", "M298.5 352.1c12.1 1.2 21.5 11.5 21.5 23.9s-9.4 22.6-21.5 23.9l-2.5 .1-80 0 0 88c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-88-80 0c-13.3 0-24-10.7-24-24 0-12.4 9.4-22.6 21.5-23.9l2.5-.1 208 0 2.5 .1zM192 0c106 0 192 86 192 192 0 41.8-13.4 80.5-36.1 112l-65.4 0c32.6-26.4 53.5-66.8 53.5-112 0-79.5-64.5-144-144-144S48 112.5 48 192c0 45.2 20.9 85.6 53.5 112l-65.4 0C13.4 272.5 0 233.8 0 192 0 86 86 0 192 0zm32 240c8.8 0 16 7.2 16 16 0 26.5-21.5 48-48 48-8.8 0-16-7.2-16-16 0-7.7 5.5-14.2 12.8-15.7l6.4-.6c6.3-1.3 11.2-6.2 12.5-12.5l.6-6.4c1.5-7.3 8-12.8 15.7-12.8zm64-64c8.8 0 16 7.2 16 16 0 26.5-21.5 48-48 48-8.8 0-16-7.2-16-16 0-7.7 5.5-14.2 12.8-15.7l6.4-.6c6.3-1.3 11.2-6.2 12.5-12.5l.6-6.4c1.5-7.3 8-12.8 15.7-12.8zm-80-16c8.8 0 16 7.2 16 16 0 26.5-21.5 48-48 48-8.8 0-16-7.2-16-16 0-7.7 5.5-14.2 12.8-15.7l6.4-.6c6.3-1.3 11.2-6.2 12.5-12.5l.6-6.4c1.5-7.3 8-12.8 15.7-12.8z"]],
    "hexagon": [576, 512, [11043], "f312", ["M75.2 244.1L171.4 76.1c4.3-7.5 12.2-12.1 20.8-12.1l191.6 0c8.6 0 16.6 4.6 20.8 12.1l96.2 168.1c4.2 7.4 4.2 16.5 0 23.8L404.7 436c-4.3 7.5-12.2 12.1-20.8 12.1l-191.6 0c-8.6 0-16.6-4.6-20.8-12.1L75.2 268c-4.2-7.4-4.2-16.5 0-23.8z", "M33.5 291.8c-12.7-22.2-12.7-49.4 0-71.5L129.7 52.2C142.5 29.8 166.4 16 192.2 16l191.6 0c25.8 0 49.7 13.8 62.5 36.2l96.2 168.1c12.7 22.2 12.7 49.4 0 71.5L446.3 459.9c-12.8 22.4-36.7 36.2-62.5 36.2l-191.6 0c-25.8 0-49.7-13.8-62.5-36.2L33.5 291.8zm41.7-47.7c-4.2 7.4-4.2 16.5 0 23.8L171.4 436c4.3 7.5 12.2 12.1 20.8 12.1l191.6 0c8.6 0 16.6-4.6 20.8-12.1L500.8 268c4.2-7.4 4.2-16.5 0-23.8L404.7 76.1C400.4 68.6 392.4 64 383.8 64L192.2 64c-8.6 0-16.6 4.6-20.8 12.1L75.2 244.1z"]],
    "kite": [640, 512, [129665], "f6f4", ["M289.1 284.9L322.6 84.5 406.1 168 289.1 284.9zM473.9 168l86.1-86.1 0 172.1-86.1-86.1z", "M560 0c26.5 0 48 21.5 48 48l0 231.3-.2 4.3c-1.9 21.5-18.2 39.4-39.9 43L264.7 377.2 141.9 500c-7.7 7.7-18.1 12-29 12-22.6 0-41-18.3-41-41l0-176-33.9 21.2c-4 2.5-8.5 3.8-13.2 3.8-13.7 0-24.9-11.1-24.9-24.9l0-46.3c0-13.7 11.1-24.9 24.9-24.9 4.7 0 9.2 1.3 13.2 3.8L72 249 72 200c0-13.3-10.7-24-24-24l-24 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l24 0c39.8 0 72 32.2 72 72l0 49 34-21.2c3.9-2.5 8.5-3.8 13.2-3.8 13.7 0 24.9 11.1 24.9 24.9l0 46.3c0 13.7-11.1 24.9-24.9 24.9-4.7 0-9.2-1.3-13.2-3.8l-34-21.2 0 159.1 110.8-110.8 50.5-303.2c3.6-21.7 21.5-38 43-39.9L328.6 0 560 0zM323.1 318.8l200.3-33.4-83.5-83.5-116.9 116.8zm-34-33.9L406.1 168 322.6 84.5 289.1 284.9zM473.9 168l86.1 86.1 0-172.1-86.1 86.1zM440 134.1L526.1 48 353.9 48 440 134.1z"]],
    "share-all": [576, 512, [], "f367", ["M48 304C48 319.4 49.9 333.3 53.2 345.7 70 284.7 125.8 240 192 240l56 0c13.3 0 24 10.7 24 24L272 329.4 393.4 208 272 86.6 272 152c0 13.3-10.7 24-24 24l-72 0c-70.7 0-128 57.3-128 128z", "M370.3 57l151 151-151 151c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0L566.6 230.6c12.5-12.5 12.5-32.8 0-45.3L404.3 23c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9zm23 151L272 329.4 272 264c0-13.3-10.7-24-24-24l-56 0c-66.2 0-122 44.7-138.8 105.7-3.2-12.4-5.2-26.2-5.2-41.7 0-70.7 57.3-128 128-128l72 0c13.3 0 24-10.7 24-24L272 86.6 393.4 208zM68.7 456.1c4.4-5.1 4.4-5.1 0 0 1.5 1.3 3 2.5 4.5 3.7 9.2 7.4 22.3 7.1 31.1-.8s10.6-20.9 4.2-30.9c-8.2-12.7-12.5-27.2-12.5-44.2 0-53 43-96 96-96l32 0 0 80c0 12.9 7.8 24.6 19.8 29.6l0 0c12 5 25.7 2.2 34.9-6.9l160-160c12.5-12.5 12.5-32.8 0-45.3l-160-160c-9.2-9.2-22.9-11.9-34.9-6.9S224 35.1 224 48l0 80-48 0C78.8 128 0 206.8 0 304 0 381.9 38.6 430.2 68.7 456.1z"]],
    "chemex": [384, 512, [], "e830", ["M28 224c0 11 9 20 20 20l100.4 0c-2.8-6.1-4.4-12.9-4.4-20s1.6-13.9 4.4-20L48 204c-11 0-20 9-20 20zm207.6-20c2.8 6.1 4.4 12.9 4.4 20s-1.6 13.9-4.4 20L336 244c11 0 20-9 20-20s-9-20-20-20l-100.4 0z", "M148.4 244c7.6 16.5 24.3 28 43.6 28s36-11.5 43.6-28l90.5 0 36.8 50.6c7.7 10.6 .1 25.4-12.9 25.4l-24.1 0 15.3 21.1c27.8 38.3 46.8 86.1 29.3 130l-2.7 6.4c-.9 2.1-1.9 4.2-2.9 6.3l-1.8 3.4c-9.7 16.3-28.5 24.7-47.8 24.7l-246.3 0-7.7-.4c-16.5-1.9-31.7-10.2-40.1-24.3l-1.8-3.4c-1-2.1-2-4.2-2.9-6.3l-2.7-6.4c-16.4-41.2-.8-85.8 24.1-122.8l5.1-7.3 15.3-21.1-24.2 0c-13.1 0-20.6-14.8-12.9-25.4l36.8-50.6 90.5 0zm-30.8 76L81.7 369.3c-24.9 34.3-31.6 63.6-23.5 84 1.2 3.1 2.6 6.1 4 9.1 .1 .1 .2 .1 .3 .2 1.1 .6 3.3 1.3 6.3 1.3l246.3 0c3 0 5.2-.7 6.3-1.3 .1-.1 .2-.2 .3-.2 1.4-3 2.8-6 4.1-9.1 8.1-20.4 1.4-49.8-23.5-84l-35.9-49.3-148.9 0zM351.5 .2c18.3 1.8 32.5 17.3 32.5 36 0 7.7-2.4 15.1-6.9 21.3l-51.3 70.5 24.1 0c13.1 0 20.6 14.8 12.9 25.4l-36.8 50.6-90.5 0c-7.6-16.5-24.2-28-43.6-28s-36 11.5-43.6 28l-90.5 0-36.8-50.6C13.4 142.8 21 128 34 128l24.2 0-51.2-70.5C2.4 51.3 0 43.9 0 36.2 0 16.2 16.2 0 36.2 0l311.6 0 3.7 .2zM117.5 128l148.9 0 58.2-80-265.2 0 58.2 80z"]],
    "folder-open": [576, 512, [128194, 128449, 61717], "f07c", ["M97.5 400l50-160 379.4 0-50 160-379.4 0z", "M97.5 400l50-160 379.4 0-50 160-379.4 0zm190.7 48L477 448c21 0 39.6-13.6 45.8-33.7l50-160c9.7-30.9-13.4-62.3-45.8-62.3l-379.4 0c-21 0-39.6 13.6-45.8 33.7L80.2 294.4 80.2 96c0-8.8 7.2-16 16-16l138.7 0c3.5 0 6.8 1.1 9.6 3.2L282.9 112c13.8 10.4 30.7 16 48 16l117.3 0c8.8 0 16 7.2 16 16l48 0c0-35.3-28.7-64-64-64L330.9 80c-6.9 0-13.7-2.2-19.2-6.4L273.3 44.8C262.2 36.5 248.8 32 234.9 32L96.2 32c-35.3 0-64 28.7-64 64l0 288c0 35.3 28.7 64 64 64l192 0z"]],
    "tick": [192, 512, [], "e32f", ["M72 104c0 2.9 .1 4.7 .4 6.1L96 252 119.6 110.1c.2-1.4 .4-3.2 .4-6.1 0-13.3-10.7-24-24-24S72 90.7 72 104z", "M96 80c-13.3 0-24 10.7-24 24 0 2.9 .1 4.7 .4 6.1L96 252 119.6 110.1c.2-1.4 .4-3.2 .4-6.1 0-13.3-10.7-24-24-24zM24 104c0-39.8 32.2-72 72-72s72 32.2 72 72c0 3.9-.1 8.8-1 14L142.6 264.5C138.8 287.3 119.1 304 96 304s-42.8-16.7-46.6-39.5L25 118c-.9-5.3-1-10.2-1-14z"]],
    "face-drooling": [512, 512, [], "e372", ["M48 256C48 141.1 141.1 48 256 48s208 93.1 208 208c0 40.8-11.7 78.8-32 110.9l0 75c-14.5 13.7-30.6 25.8-48 35.8L384 352c.5-.6 .9-1.3 1.4-1.9 7.8-10.7 5.4-25.7-5.3-33.5s-25.7-5.4-33.5 5.3c-20.4 28-53.4 46.1-90.6 46.1s-70.2-18.1-90.6-46.1c-7.8-10.7-22.8-13.1-33.5-5.3s-13.1 22.8-5.3 33.5C155.7 390 202.8 416 256 416l0 48c0 13.3 10.7 24 24 24s24-10.7 24-24l0-55.3c11.3-3.5 22-8.3 32-14.1L336 496c0 1.1 .1 2.2 .2 3.2-55.7 18.3-103.8 13-128.2 8.3l0-49.1C116.3 436.8 48 354.4 48 256zm64-24c0 13.3 10.7 24 24 24s24-10.7 24-24c0-22.1 17.9-40 40-40 13.3 0 24-10.7 24-24s-10.7-24-24-24c-48.6 0-88 39.4-88 88zm176-64c0 13.3 10.7 24 24 24 22.1 0 40 17.9 40 40 0 13.3 10.7 24 24 24s24-10.7 24-24c0-48.6-39.4-88-88-88-13.3 0-24 10.7-24 24z", "M464 256c0 40.8-11.7 78.8-32 110.9l0 75C481.3 395.2 512 329.2 512 256 512 114.6 397.4 0 256 0S0 114.6 0 256C0 381 89.6 485 208 507.5l0-49.1C116.3 436.8 48 354.4 48 256 48 141.1 141.1 48 256 48s208 93.1 208 208zM346.6 321.9c-20.4 28-53.4 46.1-90.6 46.1s-70.2-18.1-90.6-46.1c-7.8-10.7-22.8-13.1-33.5-5.3s-13.1 22.8-5.3 33.5C155.7 390 202.8 416 256 416l0 48c0 13.3 10.7 24 24 24s24-10.7 24-24l0-55.3c11.3-3.5 22-8.3 32-14.1L336 496c0 13.3 10.7 24 24 24s24-10.7 24-24l0-144c.5-.6 .9-1.3 1.4-1.9 7.8-10.7 5.4-25.7-5.3-33.5s-25.7-5.4-33.5 5.3zM112 232c0 13.3 10.7 24 24 24s24-10.7 24-24c0-22.1 17.9-40 40-40 13.3 0 24-10.7 24-24s-10.7-24-24-24c-48.6 0-88 39.4-88 88zm200-88c-13.3 0-24 10.7-24 24s10.7 24 24 24c22.1 0 40 17.9 40 40 0 13.3 10.7 24 24 24s24-10.7 24-24c0-48.6-39.4-88-88-88z"]],
    "bullseye-arrow": [576, 512, [127919], "f648", ["", "M386.7 64.2c-1.7-10.2 1.6-20.6 8.9-27.9l51.2-51.2C455-23 468.8-20.1 473-9.5L496 48 553.5 71c10.7 4.3 13.5 18 5.4 26.2l-51.2 51.2c-7.3 7.3-17.7 10.6-27.9 8.9L429.1 148.9 305 273c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l124.1-124.1-8.4-50.7zM489.9 205.6c16.4-1 32.2-7 45.1-17.3 5.9 21.6 9.1 44.3 9.1 67.8 0 141.4-114.6 256-256 256S32 397.4 32 256 146.6 0 288 0c23.5 0 46.2 3.2 67.8 9.1-10.3 12.9-16.4 28.7-17.3 45.1-16.1-4-33-6.2-50.4-6.2-114.9 0-208 93.1-208 208s93.1 208 208 208 208-93.1 208-208c0-17.4-2.1-34.3-6.2-50.4zM288 112c12.9 0 25.4 1.7 37.3 4.9L282 160.2c-50.2 3.1-90 44.8-90 95.8 0 53 43 96 96 96 51 0 92.7-39.8 95.8-90l43.3-43.3c3.2 11.9 4.9 24.4 4.9 37.3 0 79.5-64.5 144-144 144s-144-64.5-144-144 64.5-144 144-144z"]],
    "kaaba": [512, 512, [128331], "f66b", ["M48 146.8l0 36.7 205.2 77.8c1.8 .7 3.8 .7 5.7 0l205.2-77.8 0-36.7-188.1 71.4c-12.8 4.9-26.9 4.9-39.7 0L48 146.8zm0 88l0 36.7 80 30.3 0 51.3-80-30.3 0 60 208 78 208-78 0-60-80 30.3 0-51.3 80-30.3 0-36.7-188.1 71.4c-12.8 4.9-26.9 4.9-39.7 0L48 234.8zM176 320l77.2 29.3c1.8 .7 3.8 .7 5.7 0l77.2-29.3 0 51.3-60.1 22.8c-12.8 4.9-26.9 4.9-39.7 0L176 371.3 176 320z", "M48 146.8l0 36.7 205.2 77.8c1.8 .7 3.8 .7 5.7 0l205.2-77.8 0-36.7-188.1 71.4c-12.8 4.9-26.9 4.9-39.7 0L48 146.8zm371.2-34.3L256 51.3 92.8 112.4 253.2 173.3c1.8 .7 3.8 .7 5.7 0l160.3-60.8zM464 234.8L275.9 306.1c-12.8 4.9-26.9 4.9-39.7 0l-188.1-71.4 0 36.7 80 30.3 0 51.3-80-30.3 0 60 208 78 208-78 0-60-80 30.3 0-51.3 80-30.3 0-36.7zM0 382.7L0 129.3c0-20 12.4-37.9 31.1-44.9l208-78c10.9-4.1 22.8-4.1 33.7 0l208 78c18.7 7 31.1 24.9 31.1 44.9l0 253.5c0 20-12.4 37.9-31.1 44.9l-208 78c-10.9 4.1-22.8 4.1-33.7 0l-208-78C12.4 420.7 0 402.7 0 382.7zm176-11.4l0-51.3 77.2 29.3c1.8 .7 3.8 .7 5.7 0l77.2-29.3 0 51.3-60.1 22.8c-12.8 4.9-26.9 4.9-39.7 0L176 371.3z"]],
    "hand-back-point-right": [512, 512, [], "e1a1", ["M48 202.6L48 328c0 39.8 32.2 72 72 72l104 0c8.8 0 16-7.2 16-16 0-3.6-1.2-6.9-3.2-9.6-5.5-7.3-6.3-17-2.3-25.1S246.9 336 256 336c8.8 0 16-7.2 16-16 0-5.2-2.5-9.9-6.4-12.8-8.3-6.2-11.6-17-8.3-26.8S269.7 264 280 264l8 0c8.8 0 16-7.2 16-16 0-5.2-2.5-9.9-6.4-12.8-8.3-6.2-11.6-17-8.3-26.8S301.7 192 312 192l136 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-280 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l42.5 0-17.2-18.9C185.7 100.8 175 96 163.7 96l-10.2 0c-37 0-71.2 19.6-89.8 51.6l-1.5 2.6c-9.3 15.9-14.2 34-14.2 52.4z", "M512 176c0-35.3-28.7-64-64-64l-188.8 0c-3.6-5.2-7.6-10.2-12-14.9L228.8 76.8C212.1 58.5 188.5 48 163.7 48l-10.2 0C99.5 48 49.5 76.7 22.2 123.4L20.7 126C7.1 149.3 0 175.7 0 202.6L0 328c0 66.3 53.7 120 120 120l104 0c35.3 0 64-28.7 64-64 0-2.8-.2-5.6-.5-8.3 19.4-11 32.5-31.8 32.5-55.7 0-5.3-.7-10.5-1.9-15.5 20.2-10.8 33.9-32 33.9-56.5 0-2.7-.2-5.4-.5-8l96.5 0c35.3 0 64-28.7 64-64zm-64-16c8.8 0 16 7.2 16 16s-7.2 16-16 16l-136 0c-10.3 0-19.5 6.6-22.8 16.4s.1 20.6 8.3 26.8c3.9 3 6.4 7.6 6.4 12.8 0 8.8-7.2 16-16 16l-8 0c-10.3 0-19.5 6.6-22.8 16.4s.1 20.6 8.3 26.8c3.9 3 6.4 7.6 6.4 12.8 0 8.8-7.2 16-16 16-9.1 0-17.4 5.1-21.5 13.3s-3.2 17.9 2.3 25.1c2 2.7 3.2 6 3.2 9.6 0 8.8-7.2 16-16 16l-104 0c-39.8 0-72-32.2-72-72l0-125.4c0-18.4 4.9-36.5 14.2-52.4l0 0 1.5-2.6c18.6-32 52.8-51.6 89.8-51.6l10.2 0c11.3 0 22 4.8 29.6 13.1l17.2 18.9-42.5 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l280 0z"]],
    "starfighter-twin-ion-engine": [512, 512, ["starfighter-alt"], "e038", ["M48 241.7l0 28.6 49.9 10.7c-1.3-8.2-1.9-16.5-1.9-25s.7-16.9 1.9-25L48 241.7zM144 256a112 112 0 1 0 224 0 112 112 0 1 0 -224 0zm168 0a56 56 0 1 1 -112 0 56 56 0 1 1 112 0zm102.1-25c1.3 8.2 1.9 16.5 1.9 25s-.7 16.9-1.9 25l49.9-10.7 0-28.6-49.9-10.7z", "M48 56c0-13.3-10.7-24-24-24S0 42.7 0 56L0 456c0 13.3 10.7 24 24 24s24-10.7 24-24l0-136.6 68.3 14.6c27.4 48.9 79.7 82 139.7 82s112.3-33.1 139.7-82L464 319.4 464 456c0 13.3 10.7 24 24 24s24-10.7 24-24l0-400c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 136.6-68.3-14.6C368.3 129.1 316 96 256 96s-112.3 33.1-139.7 82L48 192.6 48 56zM414.1 231l49.9 10.7 0 28.6-49.9 10.7c1.3-8.2 1.9-16.5 1.9-25s-.7-16.9-1.9-25zM97.9 281L48 270.3 48 241.7 97.9 231c-1.3 8.2-1.9 16.5-1.9 25s.7 16.9 1.9 25zM256 144a112 112 0 1 1 0 224 112 112 0 1 1 0-224zm0 168a56 56 0 1 0 0-112 56 56 0 1 0 0 112z"]],
    "hand-holding": [576, 512, [], "f4bd", ["M0 376c0 13.3 10.7 24 24 24l48 0c4.7 0 9.4-1.4 13.3-4l79.9-53.3c6.6-4.4 14.3-6.7 22.2-6.7L320 336c8.8 0 16 7.2 16 16s-7.2 16-16 16l-64 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l144 0c4.8 0 9.6-1.5 13.6-4.2l76-52.1c10.7-7.3 25.4-4.1 32 7 6.1 10.2 3.2 23.5-6.6 30.2l-80.1 54.6c-12 8.2-26.1 12.5-40.6 12.5L24 464c-13.3 0-24 10.7-24 24L0 376z", "M165.2 342.7c6.6-4.4 14.3-6.7 22.2-6.7L320 336c8.8 0 16 7.2 16 16s-7.2 16-16 16l-64 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l144 0c4.8 0 9.6-1.5 13.6-4.2l76-52.1c10.7-7.3 25.4-4.1 32 7 6.1 10.2 3.2 23.5-6.6 30.2l-80.1 54.6c-12 8.2-26.1 12.5-40.6 12.5L24 464c-13.3 0-24 10.7-24 24s10.7 24 24 24l370.4 0c24.1 0 47.7-7.3 67.6-20.9l80.1-54.6c30.9-21 40-62.5 20.7-94.5-20.9-34.8-66.8-44.8-100.3-21.9L392.6 368 382 368c1.3-5.1 2-10.5 2-16 0-35.3-28.7-64-64-64l-132.6 0c-17.4 0-34.4 5.1-48.8 14.8L64.7 352 24 352c-13.3 0-24 10.7-24 24s10.7 24 24 24l48 0c4.7 0 9.4-1.4 13.3-4l79.9-53.3z"]],
    "badge-sheriff": [512, 512, [], "f8a2", ["M102.9 166.9l28.5 45.5c16.7 26.7 16.7 60.5 0 87.2l-28.5 45.5 56.2 0c29.7 0 57.1 16 71.7 41.9l25.5 45.3 25.5-45.3c14.6-25.9 42-41.9 71.7-41.9l56.2 0-28.5-45.5c-16.7-26.7-16.7-60.5 0-87.2l28.5-45.5-56.2 0c-29.7 0-57.1-16-71.7-41.9l-25.5-45.3-25.5 45.3c-14.6 25.9-42 41.9-71.7 41.9l-56.2 0zM311.7 256a55.7 55.7 0 1 1 -111.4 0 55.7 55.7 0 1 1 111.4 0z", "M296.3 8c0 10.3-3.9 19.6-10.2 26.7l37.5 66.7c6.1 10.8 17.5 17.5 29.9 17.5l79.8 0c3-8.8 9.1-16.5 17.8-21.5 19.1-11 43.6-4.5 54.6 14.6s4.5 43.6-14.6 54.6c-8.7 5-18.4 6.4-27.5 4.6l-41.6 66.5c-7 11.1-7 25.2 0 36.3l41.6 66.5c9.1-1.8 18.9-.4 27.5 4.6 19.1 11 25.7 35.5 14.6 54.6s-35.5 25.7-54.6 14.6c-8.7-5-14.7-12.7-17.8-21.5l-79.8 0c-12.4 0-23.8 6.7-29.9 17.5l-37.5 66.7c6.3 7.1 10.2 16.4 10.2 26.7 0 22.1-17.9 40-40 40s-40-17.9-40-40c0-10.3 3.9-19.6 10.2-26.7L189 410.6c-6.1-10.8-17.5-17.5-29.9-17.5l-79.8 0c-3 8.8-9.1 16.5-17.8 21.5-19.1 11-43.6 4.5-54.6-14.6s-4.5-43.6 14.6-54.6c8.7-5 18.4-6.4 27.5-4.6l41.6-66.5c6.9-11.1 6.9-25.2 0-36.3L49 171.3c-9.1 1.8-18.9 .4-27.5-4.6-19.1-11-25.7-35.5-14.6-54.6S42.4 86.3 61.5 97.4c8.7 5 14.7 12.7 17.8 21.5l79.8 0c12.4 0 23.8-6.7 29.9-17.5l37.5-66.7c-6.3-7.1-10.2-16.4-10.2-26.7 0-22.1 17.9-40 40-40s40 17.9 40 40zm-40 71.6l-25.5 45.3c-14.6 25.9-42 41.9-71.7 41.9l-56.2 0 28.5 45.5c16.7 26.7 16.7 60.5 0 87.2l-28.5 45.5 56.2 0c29.7 0 57.1 16 71.7 41.9l25.5 45.3 25.5-45.3c14.6-25.9 42-41.9 71.7-41.9l56.2 0-28.5-45.5c-16.7-26.7-16.7-60.5 0-87.2l28.5-45.5-56.2 0c-29.7 0-57.1-16-71.7-41.9L256.3 79.6zM255.7 200a56 56 0 1 1 .6 112 56 56 0 1 1 -.6-112z"]],
    "rainbow-half": [512, 512, [], "e7ca", ["M24 480c13.3 0 24-10.7 24-24 0-225.3 182.7-408 408-408 13.3 0 24-10.7 24-24l0 136c0-13.3-10.7-24-24-24-176.7 0-320 143.3-320 320 0 13.3 10.7 24 24 24L24 480zm136 0l136 0c-13.3 0-24-10.7-24-24 0-101.6 82.4-184 184-184 13.3 0 24 10.7 24 24l0-136c0 13.3-10.7 24-24 24-150.2 0-272 121.8-272 272 0 13.3-10.7 24-24 24z", "M456 48c-225.3 0-408 182.7-408 408 0 13.3-10.7 24-24 24S0 469.3 0 456C0 204.2 204.2 0 456 0 469.3 0 480 10.7 480 24s-10.7 24-24 24zm0 136c-150.2 0-272 121.8-272 272 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-176.7 143.3-320 320-320 13.3 0 24 10.7 24 24s-10.7 24-24 24zM320 456c0 13.3-10.7 24-24 24s-24-10.7-24-24c0-101.6 82.4-184 184-184 13.3 0 24 10.7 24 24s-10.7 24-24 24c-75.1 0-136 60.9-136 136z"]],
    "comment-lines": [512, 512, [], "f4b0", ["M48 240c0 42.8 15.1 82.4 41.2 114.7 12.2 15.1 14.1 36.1 4.8 53.2l-18 33.1 58.5-25.1c11.8-5.1 25.2-5.2 37.1-.3 25.7 10.5 54.2 16.4 84.3 16.4 117.8 0 208-88.8 208-192S373.8 48 256 48 48 136.8 48 240zm80-40c0-13.3 10.7-24 24-24l208 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-208 0c-13.3 0-24-10.7-24-24zm0 96c0-13.3 10.7-24 24-24l112 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-112 0c-13.3 0-24-10.7-24-24z", "M0 240c0 54.4 19.3 104.6 51.9 144.9L3.1 474.3c-2 3.7-3.1 7.9-3.1 12.2 0 14.1 11.4 25.5 25.5 25.5 4 0 7.8-.6 11.5-2.1L153.4 460c31.4 12.9 66.1 20 102.6 20 141.4 0 256-107.5 256-240S397.4 0 256 0 0 107.5 0 240zM94 407.9c9.3-17.1 7.4-38.1-4.8-53.2-26.1-32.3-41.2-71.9-41.2-114.7 0-103.2 90.2-192 208-192s208 88.8 208 192-90.2 192-208 192c-30.2 0-58.7-5.9-84.3-16.4-11.9-4.9-25.3-4.8-37.1 .3L76 440.9 94 407.9zM152 176c-13.3 0-24 10.7-24 24s10.7 24 24 24l208 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-208 0zm0 96c-13.3 0-24 10.7-24 24s10.7 24 24 24l112 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-112 0z"]],
    "single-quote-right": [192, 512, [], "e81c", ["M48 160l0 64c0 8.8 7.2 16 16 16l64 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16l-64 0c-8.8 0-16 7.2-16 16z", "M56 416c-13.3 0-24-10.7-24-24s10.7-24 24-24l16 0c39.8 0 72-32.2 72-72l0-10.1c-3.1 .8-6.2 1.4-9.5 1.7l-6.5 .3-64 0-6.5-.3C25.2 284.4 0 257.1 0 224l0-64 .3-6.5c3.1-30.1 27-54.1 57.1-57.1l6.5-.3 64 0 6.5 .3c30.1 3.1 54.1 27 57.1 57.1l.3 6.5 0 136c0 66.3-53.7 120-120 120l-16 0zm72-176c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16l-64 0c-8.8 0-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16l64 0z"]],
    "bottle-droplet": [320, 512, [], "e4c4", ["M48 288l0 168c0 22.1 17.9 40 40 40l144 0c22.1 0 40-17.9 40-40l0-168c0-45.4-27-84.5-65.9-102.1-8.6-3.9-14.1-12.4-14.1-21.9l0-132-64 0 0 132c0 9.4-5.5 18-14.1 21.9-38.9 17.6-65.9 56.7-65.9 102.1zm48 64c0-21.2 28.9-64.5 47.9-90.6 8.1-11.1 24.2-11.1 32.3 0 19 26.1 47.9 69.4 47.9 90.6 0 31.6-28.7 64-64 64s-64-32.4-64-64z", "M96-32c-17.7 0-32 14.3-32 32 0 11.8 6.4 22.2 16 27.7l0 121.7C32.2 177.1 0 228.7 0 288L0 456c0 48.6 39.4 88 88 88l144 0c48.6 0 88-39.4 88-88l0-168c0-59.3-32.2-110.9-80-138.6l0-121.7c9.6-5.5 16-15.9 16-27.7 0-17.7-14.3-32-32-32L96-32zm32 64l64 0 0 132c0 9.4 5.5 18 14.1 21.9 38.9 17.6 65.9 56.7 65.9 102.1l0 168c0 22.1-17.9 40-40 40L88 496c-22.1 0-40-17.9-40-40l0-168c0-45.4 27-84.5 65.9-102.1 8.6-3.9 14.1-12.4 14.1-21.9l0-132zm96 320c0-21.2-28.9-64.5-47.9-90.6-8.1-11.1-24.2-11.1-32.3 0-19 26.1-47.9 69.4-47.9 90.6 0 31.6 28.7 64 64 64s64-32.4 64-64z"]],
    "face-explode": [512, 512, ["exploding-head"], "e2fe", ["M50 285c13.1 2.3 26.6 1.4 39.3-2.9l70.7-23.6 70.7 23.6c16.4 5.5 34.2 5.5 50.6 0l70.7-23.6 70.7 23.6c12.7 4.2 26.2 5.2 39.3 2.9-14.1 101.1-101 179-206 179S64.1 386.2 50 285zm94 51a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm64 80l0 5.3c0 5.9 4.8 10.7 10.7 10.7l74.7 0c5.9 0 10.7-4.8 10.7-10.7l0-5.3c0-26.5-21.5-48-48-48s-48 21.5-48 48zm96-80a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M64 64c0 35.3 28.7 64 64 64l16 0c26.5 0 48 21.5 48 48l64 16 64-16c0-26.5 21.5-48 48-48l16 0c35.3 0 64-28.7 64-64S419.3 0 384 0c-5.5 0-10.9 .7-16 2 0-.7 0-1.3 0-2 0-35.3-28.7-64-64-64-19.1 0-36.3 8.4-48 21.7-11.7-13.3-28.9-21.7-48-21.7-35.3 0-64 28.7-64 64 0 .7 0 1.4 0 2-5.1-1.3-10.5-2-16-2-35.3 0-64 28.7-64 64zM2.6 219.5C.9 231.4 0 243.6 0 256 0 260.5 .1 264.9 .3 269.4 7.3 404.5 119.1 512 256 512S504.7 404.5 511.7 269.4c.2-4.4 .3-8.9 .3-13.4 0-12.4-.9-24.6-2.6-36.5l-46.5 15.5-4.8 1.6c-6.6 2.2-13.7 2.2-20.2 0l-75.8-25.3c-6.6-2.2-13.7-2.2-20.2 0l-75.8 25.3c-6.6 2.2-13.7 2.2-20.2 0l-75.8-25.3c-6.6-2.2-13.7-2.2-20.2 0L74.1 236.6c-6.6 2.2-13.7 2.2-20.2 0L49 235 2.6 219.5zM50 285c13.1 2.3 26.6 1.4 39.3-2.9l70.7-23.6 70.7 23.6c16.4 5.5 34.2 5.5 50.6 0l70.7-23.6 70.7 23.6c12.7 4.2 26.2 5.2 39.3 2.9-14.1 101.1-101 179-206 179S64.1 386.2 50 285zm158 51a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm128 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM208 416l0 5.3c0 5.9 4.8 10.7 10.7 10.7l74.7 0c5.9 0 10.7-4.8 10.7-10.7l0-5.3c0-26.5-21.5-48-48-48s-48 21.5-48 48z"]],
    "window-minimize": [512, 512, [128469], "f2d1", ["", "M0 424c0-13.3 10.7-24 24-24l464 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 448c-13.3 0-24-10.7-24-24z"]],
    "stadium": [576, 512, [], "e6cc", ["M48 224c0 3.6 2 10.2 12.4 19.2 10.4 8.9 26.8 18 49.1 26.2 11.5 4.2 24.2 8 38 11.3 7.3-12.1 25.4-22.7 50.3-30.2l-57-76.1-3.4-4.5c-10 2.7-19.3 5.6-27.9 8.7-22.4 8.1-38.8 17.2-49.1 26.2-10.4 9-12.4 15.5-12.4 19.2zm0 69.2l0 112c0 4.8 2.4 12.1 12.8 21.5s26.8 19 49.1 27.5c30.5 11.6 69.7 20.5 114.1 24.9l0-31c0-35.3 28.7-64 64-64s64 28.7 64 64l0 31c44.4-4.4 83.6-13.2 114.1-24.9 22.3-8.5 38.7-18.1 49.1-27.5S528 410 528 405.2l0-112c-13.2 8.1-28.5 15.2-45.1 21.2-51 18.6-119.9 29.6-194.9 29.6S144.1 333 93.1 314.4c-16.7-6.1-32-13.1-45.1-21.2zm141.4-134l60.9 81.2c12-1.2 24.6-1.9 37.7-1.9s25.7 .6 37.7 1.9l60.9-81.2c-30.1-4.6-63.4-7.2-98.6-7.2s-68.5 2.6-98.6 7.2zm188.8 91.3c24.9 7.5 43 18.1 50.3 30.2 13.8-3.3 26.5-7.1 38-11.3 22.4-8.1 38.8-17.2 49.1-26.2 10.4-9 12.4-15.5 12.4-19.2s-1.9-10.2-12.4-19.2c-10.4-8.9-26.8-18-49.1-26.2-8.6-3.1-18-6.1-27.9-8.7l-3.4 4.5-57 76.1z", "M256 32l0-44.8c0-10.6 8.6-19.2 19.2-19.2 3.2 0 6.3 .8 9.1 2.3L377 20.2c4.3 2.3 7 6.9 7 11.8s-2.7 9.5-7 11.8l-73 39.3 0 21.1c53 1.1 102.4 7.7 144 18.6L448 3.2c0-10.6 8.6-19.2 19.2-19.2 3.2 0 6.3 .8 9.1 2.3L569 36.2c4.3 2.3 7 6.9 7 11.8s-2.7 9.5-7 11.8l-73 39.3 0 39.6c20 8.3 37.4 18.2 50.9 29.8 16.3 14 29.1 32.7 29.1 55.6l0 181.2c0 23.1-12.3 42.3-28.7 57.1s-38.6 27-64.1 36.7c-51.1 19.6-120.2 31.1-195.2 31.1S143.9 518.5 92.8 499C67.3 489.2 45 477 28.7 462.3S0 428.3 0 405.2L0 224c0-22.9 12.8-41.6 29.1-55.6 9.7-8.4 21.6-15.9 34.9-22.5L64 3.2c0-10.6 8.6-19.2 19.2-19.2 3.2 0 6.3 .8 9.1 2.3L185 36.2c4.3 2.3 7 6.9 7 11.8s-2.7 9.5-7 11.8l-73 39.3 0 28.2c40.6-12.3 90.2-20.3 144-22.6L256 32zM438.6 169.9l-3.4 4.5-57 76.1c24.9 7.5 43 18.1 50.3 30.2 13.8-3.3 26.5-7.1 38-11.3 22.4-8.1 38.8-17.2 49.1-26.2 10.4-9 12.4-15.5 12.4-19.2s-1.9-10.2-12.4-19.2c-10.4-8.9-26.8-18-49.1-26.2-8.6-3.1-18-6.1-27.9-8.7zm-51.9-10.7c-30.1-4.6-63.4-7.2-98.6-7.2s-68.5 2.6-98.6 7.2l60.9 81.2c12-1.2 24.6-1.9 37.7-1.9s25.7 .6 37.7 1.9l60.9-81.2zM137.4 169.9c-10 2.7-19.3 5.6-27.9 8.7-22.4 8.1-38.8 17.2-49.1 26.2-10.4 9-12.4 15.5-12.4 19.2l0 0c0 3.6 2 10.2 12.4 19.2 10.4 8.9 26.8 18 49.1 26.2 11.5 4.2 24.2 8 38 11.3 7.3-12.1 25.4-22.7 50.3-30.2l-57-76.1-3.4-4.5zM528 293.2c-13.2 8.1-28.5 15.2-45.1 21.2-51 18.6-119.9 29.6-194.9 29.6S144.1 333 93.1 314.4c-16.7-6.1-32-13.1-45.1-21.2l0 112c0 4.8 2.4 12.1 12.8 21.5s26.8 19 49.1 27.5c30.5 11.6 69.7 20.5 114.1 24.9l0-31c0-35.3 28.7-64 64-64s64 28.7 64 64l0 31c44.4-4.4 83.6-13.2 114.1-24.9 22.3-8.5 38.7-18.1 49.1-27.5S528 410 528 405.2l0-112z"]],
    "megaphone": [512, 512, [128227], "f675", ["M48 236.4l0 39.3 416 117 0-273.3-416 117z", "M488 32c-13.3 0-24 10.7-24 24l0 13.5-416 117 0-2.5c0-13.3-10.7-24-24-24S0 170.7 0 184L0 328c0 13.3 10.7 24 24 24s24-10.7 24-24l0-2.5 86.3 24.3c-4.1 10.6-6.3 22.2-6.3 34.2 0 53 43 96 96 96 47 0 86.2-33.8 94.4-78.5l145.6 41 0 13.5c0 13.3 10.7 24 24 24s24-10.7 24-24l0-400c0-13.3-10.7-24-24-24zM464 392.6l-416-117 0-39.3 416-117 0 273.3zm-192.2-4.2c-2.2 24.4-22.8 43.6-47.8 43.6-26.5 0-48-21.5-48-48 0-7.6 1.8-14.8 4.9-21.1l90.9 25.6z"]],
    "burger-glass": [576, 512, [], "e0ce", ["M96 208l196.4 0c-36.3 22-58.3 50.9-70 71.4-12 20.9-14.3 42.7-14.3 59.1l0 125.5-68 0c-12.5 0-22.8-9.5-23.9-21.9L96 208z", "M56 0C49.3 0 42.9 2.8 38.3 7.8s-6.8 11.6-6.2 18.3L68.3 446.2C71.5 483.4 102.7 512 140 512l71 0c-2-8.1-3.1-16.6-3.1-25.3l0-22.7-68 0c-12.5 0-22.8-9.5-23.9-21.9L96 208 292.4 208c27.8-16.9 64.1-29.8 110.6-31.9l12.9-150c.6-6.7-1.7-13.3-6.2-18.3S398.7 0 392 0L56 0zM91.8 160l-9.7-112 283.7 0-9.7 112-264.4 0zM304 338.5c0-8.1 1.3-10.9 1.6-11.3 9.9-17.3 38.4-55.3 110.4-55.4 72 .1 100.5 38.1 110.4 55.4 .3 .4 1.6 3.2 1.6 11.3l0 29.3 48 0 0-29.3c0-12.3-1.8-24.6-7.9-35.2-15.8-27.5-58-79.4-152.1-79.5-94.1 .1-136.3 52-152.1 79.5-6.1 10.7-7.9 22.9-7.9 35.2l0 29.3 48 0 0-29.3zM256 486.7c0 31.6 25.6 57.1 57.1 57.1l205.7 0c31.6 0 57.1-25.6 57.1-57.1l0-6.9-48 0 0 6.9c0 5-4.1 9.1-9.1 9.1l-205.7 0c-5 0-9.1-4.1-9.1-9.1l0-6.9-48 0 0 6.9zm24-86.9c-13.3 0-24 10.7-24 24s10.7 24 24 24l272 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-272 0zM432 304a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm-80 48a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm144-16a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"]],
    "pen-paintbrush": [576, 512, ["pencil-paintbrush"], "f618", ["M90.5 453.5l86.9-24.1c6.6-1.8 12.7-5.4 17.6-10.3L402.1 212 332 141.9 124.9 349.1c-4.9 4.9-8.4 10.9-10.3 17.6L90.5 453.5z", "M116.1 222.1l33.9-33.9-94.2-94.2c-5-5-7.9-11.9-7.9-19 0-14.9 12-26.9 26.9-26.9 7.1 0 14 2.8 19 7.9l94.2 94.2 33.9-33.9-94.2-94.2C113.8 7.9 94.8 0 74.9 0 33.5 0 0 33.5 0 74.9 0 94.8 7.9 113.8 21.9 127.9l94.2 94.2zM284.9 465c23.5 28.7 59.2 47 99.1 47l160 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-7.5 0c-18.5 0-30.6-20.6-27-38.8 1.6-8.2 2.5-16.6 2.5-25.2 0-40-18.3-75.7-47-99.1l-34.2 34.2c20.1 14.5 33.3 38.2 33.3 64.9 0 5.5-.5 10.8-1.6 15.8-4.4 22.1 .7 44.5 12.2 62 .5 .7 1 1.5 1.5 2.2L384 464c-26.7 0-50.4-13.1-64.9-33.3L284.9 465zM90.9 315.1c-10.7 10.7-18.5 24.1-22.6 38.7L32.9 481.6c-2.3 8.3 0 17.3 6.2 23.4s15.1 8.5 23.4 6.2l127.8-35.5c14.6-4.1 27.9-11.8 38.7-22.6l294-294C536.4 145.6 544 127.2 544 108s-7.6-37.6-21.2-51.1L487.1 21.2C473.6 7.6 455.2 0 436 0s-37.6 7.6-51.1 21.2l-294 294zM436 48c6.4 0 12.6 2.6 17.2 7.1l35.7 35.7c4.6 4.6 7.1 10.7 7.1 17.2s-2.6 12.6-7.1 17.2L436 178.1 365.9 108 418.8 55.1c4.6-4.6 10.7-7.1 17.2-7.1zM124.9 349.1L332 141.9 402.1 212 194.9 419.1c-4.9 4.9-10.9 8.4-17.6 10.3l-86.9 24.1 24.1-86.9c1.8-6.6 5.4-12.7 10.3-17.6z"]],
    "lightbulb-slash": [576, 512, [], "f673", ["M172.2 106.4c26.2-35.4 68.3-58.4 115.8-58.4 79.5 0 144 64.5 144 144 0 38.4-15 73.2-39.5 99.1-5.5 5.8-11.1 12.1-16.5 19l-135-135c4-17.8 20-31.1 39-31.1 13.3 0 24-10.7 24-24s-10.7-24-24-24c-32 0-60.1 17.1-75.5 42.7l-32.3-32.3z", "M41-24.9c-9.4-9.4-24.6-9.4-33.9 0S-2.3-.3 7 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9L410.2 344.3c5.3-7.1 11.1-13.8 17.1-20.2 32.7-34.4 52.7-80.9 52.7-132.1 0-106-86-192-192-192-60.7 0-114.8 28.2-150 72.1l-97-97zM172.2 106.4c26.2-35.4 68.3-58.4 115.8-58.4 79.5 0 144 64.5 144 144 0 38.4-15 73.2-39.5 99.1-5.5 5.8-11.1 12.1-16.5 19l-135-135c4-17.8 20-31.1 39-31.1 13.3 0 24-10.7 24-24s-10.7-24-24-24c-32 0-60.1 17.1-75.5 42.7l-32.3-32.3zM314.2 384l-77.4 0c-8.4-39-32-70.5-53.3-92.9-19.4-20.4-32.8-46.4-37.6-75.3L97.6 167.4c-1 8.1-1.6 16.3-1.6 24.6 0 51.2 20 97.7 52.7 132.1 23.6 24.9 43.3 55.3 43.3 89.6l0 18.3c0 44.2 35.8 80 80 80l32 0c37.5 0 68.9-25.8 77.6-60.6L314.2 384z"]],
    "circle-australian-dollar": [512, 512, [], "e730", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm65.2 80.6l50.9-156.3C168 168.2 179.3 160 192 160s24 8.2 27.9 20.3l50.9 156.3c4.1 12.6-2.8 26.1-15.4 30.3s-26.1-2.8-30.3-15.4l-5-15.4-56.3 0-5 15.4c-4.1 12.6-17.6 19.5-30.3 15.4s-19.5-17.6-15.4-30.3zM179.5 288l25 0-12.5-38.4-12.5 38.4zM272 219.2c0-28.9 20.7-52.9 48-58.1l0-9.1c0-8.8 7.2-16 16-16s16 7.2 16 16l0 8 8 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-28.8 0c-6.2 0-11.2 5-11.2 11.2 0 5.3 3.8 9.9 9 11l23.5 4.7c27.7 5.5 47.6 29.8 47.6 58 0 28.9-20.7 52.9-48 58.1l0 9.1c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-8-16 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l36.8 0c6.2 0 11.2-5 11.2-11.2 0-5.3-3.8-9.9-9-11l-23.5-4.7c-27.7-5.5-47.6-29.8-47.6-58z", "M464 256a208 208 0 1 0 -416 0 208 208 0 1 0 416 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zM320 152c0-8.8 7.2-16 16-16s16 7.2 16 16l0 8 8 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-28.8 0c-6.2 0-11.2 5-11.2 11.2 0 5.3 3.8 9.9 9 11l23.5 4.7c27.7 5.5 47.6 29.8 47.6 58 0 28.9-20.7 52.9-48 58.1l0 9.1c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-8-16 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l36.8 0c6.2 0 11.2-5 11.2-11.2 0-5.3-3.8-9.9-9-11l-23.5-4.7c-27.7-5.5-47.6-29.8-47.6-58 0-28.9 20.7-52.9 48-58.1l0-9.1zM192 249.6l-12.5 38.4 25 0-12.5-38.4zm33.2 101.9l-5-15.4-56.3 0-5 15.4c-4.1 12.6-17.6 19.5-30.3 15.4s-19.5-17.6-15.4-30.3l50.9-156.3C168 168.2 179.3 160 192 160s24 8.2 27.9 20.3l50.9 156.3c4.1 12.6-2.8 26.1-15.4 30.3s-26.1-2.8-30.3-15.4z"]],
    "shuttle-space-vertical": [448, 512, [], "e7bf", ["M48 448l0 48 48 0 0-48-48 0zm6.1-48l52.6 0c5.4-9.4 12.7-17.5 21.3-24l0-112-54.9 91.5c-8.4 14-14.7 28.9-19 44.5zM144 440l0 56 160 0 0-56c0-12.7-7.4-23.8-18.3-28.9-8.4-4-13.7-12.4-13.7-21.7L272 152c0-32.6-5.8-62.4-18.5-88l-59.1 0C181.8 89.6 176 119.4 176 152l0 237.4c0 9.3-5.3 17.7-13.7 21.7-10.9 5.2-18.3 16.2-18.3 28.9zm48-312c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16zM320 264l0 112c8.6 6.5 15.9 14.6 21.3 24l52.6 0c-4.2-15.6-10.6-30.6-19-44.5L320 264zm32 184l0 48 48 0 0-48-48 0z", "M400 544L48 544c-26.5 0-48-21.5-48-48l0-50c0-40.6 11-80.4 31.9-115.2L128 170.7 128 152c0-69.3 22.7-135 81.6-179.2 8.5-6.4 20.3-6.4 28.8 0 58.9 44.2 81.6 109.9 81.6 179.2l0 18.7 96.1 160.1C437 365.6 448 405.4 448 446l0 50c0 26.5-21.5 48-48 48zM320 264l0 112c8.6 6.5 15.9 14.6 21.3 24l52.6 0c-4.2-15.6-10.6-30.6-19-44.5L320 264zm80 184l-48 0 0 48 48 0 0-48zM128 264L73.1 355.5c-8.4 14-14.7 28.9-19 44.5l52.6 0c5.4-9.4 12.7-17.5 21.3-24l0-112zM48 496l48 0 0-48-48 0 0 48zm104 0l152 0 0-56c0-12.7-7.4-23.8-18.3-28.9-8.4-4-13.7-12.4-13.7-21.7L272 152c0-32.6-5.8-62.4-18.5-88l-59.1 0C181.8 89.6 176 119.4 176 152l0 237.4c0 9.3-5.3 17.7-13.7 21.7-10.9 5.2-18.3 16.2-18.3 28.9l0 56 8 0zm40-368c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16z"]],
    "person-to-door": [576, 512, [58704], "e433", ["M168.3 287.1c24.5-83.2 36.9-125.5 37.4-127.1l10.7 0c12.1 0 23.3 5.4 30.8 14.5l-41.3 130.9-32-8.3c-4.4-1.1-6.9-5.7-5.7-10zM432.4 53.5c1-3.2 4.1-5.5 7.6-5.5l80 0c4.4 0 8 3.6 8 8l0 400c0 4.4-3.6 8-8 8l-80 0c-3.5 0-6.6-2.3-7.6-5.5l0-150.9c19.1-13 31.6-34.8 31.6-59.6s-12.5-46.7-31.6-59.6l0-134.9z", "M312 24a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zM107.9 169.8c2.5-6 8.3-9.8 14.8-9.8l33 0-2.7 9.2-30.7 104.3c-8.9 30.3 9 62 39.6 70l124.7 32.5-52.5 118.2c-5.4 12.1 .1 26.3 12.2 31.7s26.3-.1 31.7-12.2L334.3 387c10-22.6-2.6-48.7-26.5-55l-55.4-14.4 26.1-82.7 3.1 6.2c9.5 19 28.9 31 50.1 31l60.2 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-60.2 0c-3 0-5.8-1.7-7.2-4.4l-29.5-58.9c-14.9-29.8-45.4-48.6-78.7-48.6l-93.8 0c-25.8 0-49.1 15.5-59.1 39.4L33.8 222.8c-5.1 12.2 .7 26.3 12.9 31.4s26.3-.7 31.4-12.9l29.7-71.4zM199 182.8l6.7-22.8 10.7 0c12.1 0 23.3 5.4 30.8 14.5l-41.3 130.9-32-8.3c-4.4-1.1-6.9-5.7-5.7-10L199 182.8zM111.2 391.6c-2.4 6.7-6.5 12.6-12 17.2l-90.7 76c-10.2 8.5-11.5 23.7-3 33.8s23.7 11.5 33.8 3l90.7-76c12-10 21.1-23.1 26.4-37.8l5.2-14.6-11.9-3.1c-12-3.1-23-8.2-32.6-14.9l-5.9 16.4zM384 56l0 120 8 0c14.8 0 28.6 4.5 40 12.1L432 56c0-4.4 3.6-8 8-8l80 0c4.4 0 8 3.6 8 8l0 400c0 4.4-3.6 8-8 8l-80 0c-4.4 0-8-3.6-8-8l0-148.1c-11.4 7.7-25.2 12.1-40 12.1l-8 0 0 136c0 30.9 25.1 56 56 56l80 0c30.9 0 56-25.1 56-56l0-400c0-30.9-25.1-56-56-56L440 0c-30.9 0-56 25.1-56 56z"]],
    "face-viewfinder": [512, 512, [], "e2ff", ["M144 256a112 112 0 1 0 224 0 112 112 0 1 0 -224 0zm39.2 42c-5.5-9.6-2.3-21.8 7.3-27.3s21.8-2.3 27.3 7.3c7.6 13.2 21.9 22 38.1 22s30.5-8.8 38.1-22c5.5-9.6 17.8-12.8 27.3-7.3s12.8 17.8 7.3 27.3c-14.5 25.1-41.6 42-72.7 42s-58.3-16.9-72.8-42zM240 224a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm80 0a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M0 64l0 72c0 13.3 10.7 24 24 24s24-10.7 24-24l0-72c0-8.8 7.2-16 16-16l72 0c13.3 0 24-10.7 24-24S149.3 0 136 0L64 0C28.7 0 0 28.7 0 64zM352 24c0 13.3 10.7 24 24 24l72 0c8.8 0 16 7.2 16 16l0 72c0 13.3 10.7 24 24 24s24-10.7 24-24l0-72c0-35.3-28.7-64-64-64L376 0c-13.3 0-24 10.7-24 24zM24 352c-13.3 0-24 10.7-24 24l0 72c0 35.3 28.7 64 64 64l72 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-72 0c-8.8 0-16-7.2-16-16l0-72c0-13.3-10.7-24-24-24zm464 0c-13.3 0-24 10.7-24 24l0 72c0 8.8-7.2 16-16 16l-72 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l72 0c35.3 0 64-28.7 64-64l0-72c0-13.3-10.7-24-24-24zM256 144a112 112 0 1 1 0 224 112 112 0 1 1 0-224zm0 272a160 160 0 1 0 0-320 160 160 0 1 0 0 320zM216 248a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm104-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM217.9 278c-5.5-9.6-17.8-12.8-27.3-7.3s-12.8 17.8-7.3 27.3c14.5 25.1 41.6 42 72.8 42s58.3-16.9 72.7-42c5.5-9.6 2.3-21.8-7.3-27.3s-21.8-2.3-27.3 7.3c-7.6 13.2-21.9 22-38.1 22s-30.5-8.8-38.1-22z"]],
    "rectangle-video-on-demand": [640, 512, [], "e774", ["M64 128l0 256c0 8.8 7.2 16 16 16l480 0c8.8 0 16-7.2 16-16l0-256c0-8.8-7.2-16-16-16L80 112c-8.8 0-16 7.2-16 16zm32 56c0-13.3 10.7-24 24-24s24 10.7 24 24l0 64.2c0 16.5 5.7 32.5 16 45.3 10.3-12.8 16-28.7 16-45.3l0-64.2c0-13.3 10.7-24 24-24s24 10.7 24 24l0 64.2c0 31.8-12.6 62.3-35.1 84.9L177 345c-4.5 4.5-10.6 7-17 7s-12.5-2.5-17-7l-11.9-11.9c-22.5-22.5-35.1-53-35.1-84.9L96 184zm160 32c0-30.9 25.1-56 56-56l16 0c30.9 0 56 25.1 56 56l0 80c0 30.9-25.1 56-56 56l-16 0c-30.9 0-56-25.1-56-56l0-80zm48 0l0 80c0 4.4 3.6 8 8 8l16 0c4.4 0 8-3.6 8-8l0-80c0-4.4-3.6-8-8-8l-16 0c-4.4 0-8 3.6-8 8zm112-32c0-13.3 10.7-24 24-24l40 0c35.3 0 64 28.7 64 64l0 64c0 35.3-28.7 64-64 64l-40 0c-13.3 0-24-10.7-24-24l0-144zm48 24l0 96 16 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16l-16 0z", "M80 112c-8.8 0-16 7.2-16 16l0 256c0 8.8 7.2 16 16 16l480 0c8.8 0 16-7.2 16-16l0-256c0-8.8-7.2-16-16-16L80 112zM16 128c0-35.3 28.7-64 64-64l480 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64L80 448c-35.3 0-64-28.7-64-64l0-256zm128 56l0 64.2c0 16.5 5.7 32.5 16 45.3 10.3-12.8 16-28.7 16-45.3l0-64.2c0-13.3 10.7-24 24-24s24 10.7 24 24l0 64.2c0 31.8-12.6 62.3-35.1 84.9L177 345c-4.5 4.5-10.6 7-17 7s-12.5-2.5-17-7l-11.9-11.9c-22.5-22.5-35.1-53-35.1-84.9L96 184c0-13.3 10.7-24 24-24s24 10.7 24 24zm168 24c-4.4 0-8 3.6-8 8l0 80c0 4.4 3.6 8 8 8l16 0c4.4 0 8-3.6 8-8l0-80c0-4.4-3.6-8-8-8l-16 0zm-56 8c0-30.9 25.1-56 56-56l16 0c30.9 0 56 25.1 56 56l0 80c0 30.9-25.1 56-56 56l-16 0c-30.9 0-56-25.1-56-56l0-80zm184-56l40 0c35.3 0 64 28.7 64 64l0 64c0 35.3-28.7 64-64 64l-40 0c-13.3 0-24-10.7-24-24l0-144c0-13.3 10.7-24 24-24zm24 144l16 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16l-16 0 0 96z"]],
    "tennis-ball": [512, 512, [127934], "f45e", ["M48.2 264c4.1 108.5 91.3 195.7 199.8 199.8 0-55.2 21.1-110.4 63.3-152.6S408.6 248 463.8 248c-4.1-108.5-91.3-195.7-199.8-199.8 0 55.2-21.1 110.4-63.3 152.6S103.4 264 48.2 264zm3.7-48c41.7-1 83.1-17.3 114.9-49.2S215 93.6 216 51.9C133.2 68 68 133.2 51.9 216zM296 460.2c82.8-16.1 148-81.4 164.1-164.1-41.7 1-83.1 17.3-114.9 49.2S297 418.4 296 460.2z", "M248 463.8c0-55.2 21.1-110.4 63.3-152.6S408.6 248 463.8 248c-4.1-108.5-91.3-195.7-199.8-199.8 0 55.2-21.1 110.4-63.3 152.6S103.4 264 48.2 264C52.3 372.5 139.5 459.7 248 463.8zm48-3.7c82.8-16.1 148-81.4 164.1-164.1-41.7 1-83.1 17.3-114.9 49.2S297 418.4 296 460.2zM51.9 216c41.7-1 83.1-17.3 114.9-49.2S215 93.6 216 51.9C133.2 68 68 133.2 51.9 216zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0z"]],
    "chevron-right": [320, 512, [9002], "f054", ["", "M313.5 239c9.4 9.4 9.4 24.6 0 33.9l-200 200c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l183-183-183-183c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l200 200z"]],
    "egg": [384, 512, [129370], "f7fb", ["M48 288c0 84.6 69.3 160 144 160s144-75.4 144-160c0-48.3-14.1-107.7-41.3-153.5-27.1-45.7-61.8-70.5-102.7-70.5S116.4 88.8 89.3 134.5C62.1 180.3 48 239.7 48 288zm32 0c0-28.3 5.7-61.9 16.9-93.5 11.2-31.5 28.4-62.4 52.3-84.2 6.5-6 16.7-5.5 22.6 1s5.5 16.6-1 22.6c-18.8 17.1-33.6 42.7-43.7 71.2-10.1 28.4-15.1 58.3-15.1 82.8 0 8.8-7.2 16-16 16s-16-7.2-16-16z", "M192 448C117.3 448 48 372.6 48 288 48 239.7 62.1 180.3 89.3 134.5 116.4 88.8 151.1 64 192 64s75.6 24.8 102.7 70.5c27.2 45.9 41.3 105.3 41.3 153.5 0 84.6-69.3 160-144 160zM0 288C0 394 86 496 192 496S384 394 384 288c0-112-64-272-192-272S0 176 0 288zM170.8 134c6.5-6 7-16.1 1-22.6s-16.1-7-22.6-1c-23.9 21.8-41.1 52.7-52.3 84.2-11.2 31.6-16.9 65.1-16.9 93.5 0 8.8 7.2 16 16 16s16-7.2 16-16c0-24.5 5-54.4 15.1-82.8 10.1-28.5 25-54.1 43.7-71.2z"]],
    "conveyor-belt-arm": [640, 512, [], "e5f8", ["M48 416c0 26.5 21.5 48 48 48l448 0c26.5 0 48-21.5 48-48s-21.5-48-48-48L96 368c-26.5 0-48 21.5-48 48zm112 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm192 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm192 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M96 24c0-13.3 10.7-24 24-24L328 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0 0 80 127.4 0c.2 0 .4 0 .6 0l64 0c22.1 0 40 17.9 40 40l0 32c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-24-16 0 0 0-192 0c-13.3 0-24-10.7-24-24l0-104-80 0c-13.3 0-24-10.7-24-24zM416 280c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24l0 32c0 2.8-.5 5.5-1.4 8l33.4 0c53 0 96 43 96 96s-43 96-96 96L96 512c-53 0-96-43-96-96s43-96 96-96l1.4 0c-.9-2.5-1.4-5.2-1.4-8l0-32c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24l0 32c0 2.8-.5 5.5-1.4 8l66.7 0c-.9-2.5-1.4-5.2-1.4-8l0-32c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24l0 32c0 2.8-.5 5.5-1.4 8l66.7 0c-.9-2.5-1.4-5.2-1.4-8l0-32zM96 368c-26.5 0-48 21.5-48 48s21.5 48 48 48l448 0c26.5 0 48-21.5 48-48s-21.5-48-48-48L96 368zm32 16a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm160 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm224-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]],
    "landmark-dome": [512, 512, ["landmark-alt"], "f752", ["M112 256l64 0 0 112-64 0 0-112zm.9-48c8-72 69-128 143.1-128s135.2 56 143.1 128l-286.2 0zM224 256l64 0 0 112-64 0 0-112zm112 0l64 0 0 112-64 0 0-112z", "M256 0c13.3 0 24 10.7 24 24l0 9.5C369.5 44.6 439.9 117.4 447.3 208l8.7 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-8 0 0 112 8 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L56 416c-13.3 0-24-10.7-24-24s10.7-24 24-24l8 0 0-112-8 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l8.7 0C72.1 117.4 142.5 44.6 232 33.5l0-9.5c0-13.3 10.7-24 24-24zM112.9 208l286.2 0c-8-72-69-128-143.1-128S120.8 136 112.9 208zm-.9 48l0 112 64 0 0-112-64 0zm112 0l0 112 64 0 0-112-64 0zm112 0l0 112 64 0 0-112-64 0zM24 464l464 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 512c-13.3 0-24-10.7-24-24s10.7-24 24-24z"]],
    "grate": [448, 512, [], "e193", ["M48 88l0 144 48 0 0-152-40 0c-4.4 0-8 3.6-8 8zm0 192l0 144c0 4.4 3.6 8 8 8l40 0 0-152-48 0zM144 80l0 152 56 0 0-152-56 0zm0 200l0 152 56 0 0-152-56 0zM248 80l0 152 56 0 0-152-56 0zm0 200l0 152 56 0 0-152-56 0zM352 80l0 152 48 0 0-144c0-4.4-3.6-8-8-8l-40 0zm0 200l0 152 40 0c4.4 0 8-3.6 8-8l0-144-48 0z", "M56 32C25.1 32 0 57.1 0 88L0 424c0 30.9 25.1 56 56 56l336 0c30.9 0 56-25.1 56-56l0-336c0-30.9-25.1-56-56-56L56 32zM96 80l0 152-48 0 0-144c0-4.4 3.6-8 8-8l40 0zM48 280l48 0 0 152-40 0c-4.4 0-8-3.6-8-8l0-144zm96 152l0-152 56 0 0 152-56 0zm104 0l0-152 56 0 0 152-56 0zm104 0l0-152 48 0 0 144c0 4.4-3.6 8-8 8l-40 0zm48-200l-48 0 0-152 40 0c4.4 0 8 3.6 8 8l0 144zM304 80l0 152-56 0 0-152 56 0zM200 80l0 152-56 0 0-152 56 0z"]],
    "worm": [448, 512, [], "e599", ["M48 320l0 128c0 8.8 7.2 16 16 16s16-7.2 16-16l0-128c0-35.3 28.7-64 64-64s64 28.7 64 64l0 48c0 53 43 96 96 96s96-43 96-96l0-272c0-26.5-21.5-48-48-48l-48 0c-26.5 0-48 21.5-48 48s21.5 48 48 48l64 0 0 224c0 35.3-28.7 64-64 64s-64-28.7-64-64l0-48c0-53-43-96-96-96s-96 43-96 96zM368 96a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M368 192l0 176c0 35.3-28.7 64-64 64s-64-28.7-64-64l0-48c0-53-43-96-96-96s-96 43-96 96l0 128c0 8.8 7.2 16 16 16s16-7.2 16-16l0-128c0-35.3 28.7-64 64-64s64 28.7 64 64l0 48c0 53 43 96 96 96s96-43 96-96l0-272c0-26.5-21.5-48-48-48l-48 0c-26.5 0-48 21.5-48 48s21.5 48 48 48l64 0 0 48zM144 176c15.9 0 31.2 2.6 45.5 7.3 27.7 9.2 51.7 26.6 69 49.3 5.1 6.7 9.6 13.8 13.5 21.3 10.2 19.8 16 42.2 16 66l0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-176-16 0c-6.3 0-12.5-.6-18.5-1.8-27.6-5.4-51-22.6-64.7-46.2-8.2-14.1-12.8-30.5-12.8-48 0-53 43-96 96-96l48 0c53 0 96 43 96 96l0 272c0 79.5-64.5 144-144 144-55.7 0-104.1-31.7-128-78-10.2-19.8-16-42.2-16-66l0-48c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 128c0 35.3-28.7 64-64 64S0 483.3 0 448L0 320c0-79.5 64.5-144 144-144zM344 72a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]],
    "sack": [512, 512, [], "f81c", ["M64 416.8c0 26.1 21.1 47.2 47.2 47.2l289.6 0c26.1 0 47.2-21.1 47.2-47.2 0-108.3-70.2-172.4-161.7-256l-.9-.9-58.7 0-.9 .9C134.2 244.4 64 308.6 64 416.8zM183.3 48l36.6 64 72.3 0 36.6-64-145.4 0z", "M332.6 138L379 56.7c3.3-5.7 5-12.2 5-18.8 0-20.9-17-37.9-37.9-37.9L165.9 0c-20.9 0-37.9 17-37.9 37.9 0 6.6 1.7 13.1 5 18.8L179.4 138C95.5 214.5 16 291.7 16 416.8 16 469.4 58.6 512 111.2 512l289.6 0c52.6 0 95.2-42.6 95.2-95.2 0-125.1-79.5-202.3-163.4-278.8zm-47.2 22l.9 .9c91.5 83.6 161.7 147.7 161.7 256 0 26.1-21.1 47.2-47.2 47.2l-289.6 0c-26.1 0-47.2-21.1-47.2-47.2 0-108.3 70.2-172.4 161.7-256l.9-.9 58.7 0zm6.8-48l-72.3 0-36.6-64 145.4 0-36.6 64z"]],
    "user-injured": [448, 512, [], "f728", ["M145.6 144l156.8 0c-7.4 36.5-39.7 64-78.4 64s-71-27.5-78.4-64zm18.1 224.1c1.4-.1 2.9-.1 4.3-.1l112 0c66.3 0 120 53.7 120 120 0 12.6 9.7 22.9 22 24l-162 0c33.1 0 60-26.9 60-60s-26.9-60-60-60l-83.7 0-12.7-23.9zM201.7 440l58.3 0c6.6 0 12 5.4 12 12s-5.4 12-12 12l-45.6 0-12.7-24z", "M224 208c38.7 0 71-27.5 78.4-64l-156.8 0c7.4 36.5 39.7 64 78.4 64zm-.9-160c-32.4 .4-60.2 20-72.4 48l43.6 0 28.8-48zm40.4 10.4L240.9 96 297.3 96c-6.9-15.9-18.9-29.1-33.9-37.6zM352 128a128 128 0 1 1 -256 0 128 128 0 1 1 256 0zM50.4 464l109.7 0-44.5-84c-33.1 16.1-57.7 46.9-65.3 84zM24 512c-13.3 0-24-10.7-24-24 0-92.8 75.2-168 168-168l112 0c92.8 0 168 75.2 168 168 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-66.3-53.7-120-120-120l-112 0c-1.5 0-2.9 0-4.3 .1l12.7 23.9 83.7 0c33.1 0 60 26.9 60 60s-26.9 60-60 60l-59.5 0c-.3 0-.6 0-1 0L24 512zm190.4-48l45.6 0c6.6 0 12-5.4 12-12s-5.4-12-12-12l-58.3 0 12.7 24z"]],
    "midi": [512, 512, [], "e806", ["M48 256c0 114.9 93.1 208 208 208s208-93.1 208-208c0-92.5-60.4-170.9-144-197.9L320 96c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-37.9C108.4 85.1 48 163.5 48 256zm96 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm32.8 124.4a32 32 0 1 1 -45.3-45.2 32 32 0 1 1 45.3 45.2zM288 400a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm92.4-19.6a32 32 0 1 1 -45.2-45.2 32 32 0 1 1 45.2 45.2zM432 256a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M256 512a256 256 0 1 1 0-512 256 256 0 1 1 0 512zM320 96c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-37.9C108.4 85.1 48 163.5 48 256 48 370.9 141.1 464 256 464s208-93.1 208-208c0-92.5-60.4-170.9-144-197.9L320 96zM256 432a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm-79.2-51.6a32 32 0 1 1 -45.3-45.2 32 32 0 1 1 45.3 45.2zm203.6 0a32 32 0 1 1 -45.2-45.2 32 32 0 1 1 45.2 45.2zM112 288a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm288 0a32 32 0 1 1 0-64 32 32 0 1 1 0 64z"]],
    "moon-star": [512, 512, [], "e7c9", ["M48 256c0-109.3 84.2-198.8 191.3-207.3-43.9 42.2-71.3 101.6-71.3 167.3 0 110.5 77.2 202.9 180.6 226.3-27.9 13.9-59.3 21.7-92.6 21.7-114.9 0-208-93.1-208-208z", "M48 256c0-109.3 84.2-198.8 191.3-207.3-43.9 42.2-71.3 101.6-71.3 167.3 0 110.5 77.2 202.9 180.6 226.3-27.9 13.9-59.3 21.7-92.6 21.7-114.9 0-208-93.1-208-208zM256 0C114.6 0 0 114.6 0 256S114.6 512 256 512c68.8 0 131.3-27.2 177.3-71.4 7.3-7 9.4-17.9 5.3-27.1s-13.7-14.9-23.8-14.1c-4.9 .4-9.8 .6-14.8 .6-101.6 0-184-82.4-184-184 0-72.1 41.5-134.6 102.1-164.8 9.1-4.5 14.3-14.3 13.1-24.4S322.6 8.5 312.7 6.3C294.4 2.2 275.4 0 256 0zM371.2 236.8l16.6 58c1.6 5.5 6.6 9.2 12.2 9.2s10.7-3.8 12.2-9.2l16.6-58 58-16.6c5.5-1.6 9.2-6.6 9.2-12.2s-3.8-10.7-9.2-12.2l-58-16.6-16.6-58c-1.6-5.5-6.6-9.2-12.2-9.2s-10.7 3.8-12.2 9.2l-16.6 58-58 16.6c-5.5 1.6-9.2 6.6-9.2 12.2s3.8 10.7 9.2 12.2l58 16.6z"]],
    "strikethrough": [512, 512, [], "f0cc", ["", "M96 151.7C96 85.6 149.6 32 215.7 32L376 32c13.3 0 24 10.7 24 24s-10.7 24-24 24L215.7 80c-39.6 0-71.7 32.1-71.7 71.7 0 34.8 25 64.6 59.2 70.6L303.4 240 488 240c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 288c-13.3 0-24-10.7-24-24s10.7-24 24-24l110.9 0C110.8 217.9 96 186.3 96 151.7zM363.8 336l49.8 0c1.6 7.9 2.5 16 2.5 24.3 0 66.1-53.6 119.7-119.7 119.7L136 480c-13.3 0-24-10.7-24-24s10.7-24 24-24l160.3 0c39.6 0 71.7-32.1 71.7-71.7 0-8.5-1.5-16.7-4.2-24.3z"]],
    "calendar-circle-minus": [576, 512, [], "e46f", ["M80 224l275.1 0c-67.8 29.6-115.1 97.3-115.1 176 0 10.9 .9 21.6 2.7 32L96 432c-8.8 0-16-7.2-16-16l0-192z", "M152 0c13.3 0 24 10.7 24 24l0 40 160 0 0-40c0-13.3 10.7-24 24-24s24 10.7 24 24l0 40 32 0c35.3 0 64 28.7 64 64l0 86c-15.3-3.9-31.4-6-48-6-27.3 0-53.3 5.7-76.9 16L80 224 80 416c0 8.8 7.2 16 16 16l146.7 0c2.8 16.8 7.8 32.9 14.8 48L96 480c-35.3 0-64-28.7-64-64l0-288c0-35.3 28.7-64 64-64l32 0 0-40c0-13.3 10.7-24 24-24zm0 112l-56 0c-8.8 0-16 7.2-16 16l0 48 352 0 0-48c0-8.8-7.2-16-16-16l-264 0zM288 400a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm224 0c0-8.8-7.2-16-16-16l-128 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l128 0c8.8 0 16-7.2 16-16z"]],
    "blog": [512, 512, [], "f781", ["", "M224 24c0-13.3 10.7-24 24-24 145.8 0 264 118.2 264 264 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-119.3-96.7-216-216-216-13.3 0-24-10.7-24-24zM56 96c13.3 0 24 10.7 24 24l0 248c0 53 43 96 96 96s96-43 96-96-43-96-96-96l-24 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l24 0c79.5 0 144 64.5 144 144S255.5 512 176 512 32 447.5 32 368l0-248c0-13.3 10.7-24 24-24zm192 0c92.8 0 168 75.2 168 168 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-66.3-53.7-120-120-120-13.3 0-24-10.7-24-24s10.7-24 24-24z"]],
    "stopwatch-20": [448, 512, [], "e06f", ["M56 288a168 168 0 1 0 336 0 168 168 0 1 0 -336 0zm52-48c0-28.7 23.3-52 52-52s52 23.3 52 52l0 3.8c0 11.7-3.2 23.1-9.3 33L158.9 348 192 348c11 0 20 9 20 20s-9 20-20 20l-57.8 0c-14.5 0-26.2-11.7-26.2-26.2 0-4.9 1.3-9.6 3.9-13.8l56.7-92.1c2.2-3.6 3.4-7.8 3.4-12.1l0-3.8c0-6.6-5.4-12-12-12s-12 5.4-12 12c0 11-9 20-20 20s-20-9-20-20zm128 0c0-28.7 23.3-52 52-52s52 23.3 52 52l0 96c0 28.7-23.3 52-52 52s-52-23.3-52-52l0-96zm40 0l0 96c0 6.6 5.4 12 12 12s12-5.4 12-12l0-96c0-6.6-5.4-12-12-12s-12 5.4-12 12z", "M168 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l32 0 0 25.3C92 85.3 8 176.8 8 288 8 407.3 104.7 504 224 504s216-96.7 216-216c0-42.8-12.4-82.6-33.9-116.2L433 145c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-23.3 23.3c-33.7-33.2-78.2-55.5-127.8-61l0-25.3 32 0c13.3 0 24-10.7 24-24S293.3 0 280 0L168 0zm56 456a168 168 0 1 1 0-336 168 168 0 1 1 0 336zM108 240c0 11 9 20 20 20s20-9 20-20c0-6.6 5.4-12 12-12s12 5.4 12 12l0 3.8c0 4.3-1.2 8.4-3.4 12.1L111.9 348c-2.5 4.1-3.9 8.9-3.9 13.8 0 14.5 11.7 26.2 26.2 26.2l57.8 0c11 0 20-9 20-20s-9-20-20-20l-33.1 0 43.8-71.2c6.1-9.9 9.3-21.4 9.3-33l0-3.8c0-28.7-23.3-52-52-52s-52 23.3-52 52zm180-52c-28.7 0-52 23.3-52 52l0 96c0 28.7 23.3 52 52 52s52-23.3 52-52l0-96c0-28.7-23.3-52-52-52zm-12 52c0-6.6 5.4-12 12-12s12 5.4 12 12l0 96c0 6.6-5.4 12-12 12s-12-5.4-12-12l0-96z"]],
    "square-florin": [448, 512, [], "e717", ["M48 96l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16zm56 272c0-13.3 10.7-24 24-24l23.9 0c5 0 9.6-3 11.6-7.6l27.6-64.4-39 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l59.6 0 28.8-67.3c9.5-22.3 31.4-36.7 55.7-36.7l23.9 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-23.9 0c-5 0-9.6 3-11.6 7.6L263.8 224 296 224c13.3 0 24 10.7 24 24s-10.7 24-24 24l-52.7 0-35.7 83.3C198 377.6 176.1 392 151.9 392L128 392c-13.3 0-24-10.7-24-24z", "M64 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm240.4 60.7c9.5-22.3 31.4-36.7 55.7-36.7l23.9 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-23.9 0c-5 0-9.6 3-11.6 7.6L263.8 224 296 224c13.3 0 24 10.7 24 24s-10.7 24-24 24l-52.7 0-35.7 83.3C198 377.6 176.1 392 151.9 392L128 392c-13.3 0-24-10.7-24-24s10.7-24 24-24l23.9 0c5 0 9.6-3 11.6-7.6l27.6-64.4-39 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l59.6 0 28.8-67.3z"]],
    "binary": [384, 512, [], "e33b", ["", "M328 24l0 152 32 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-112 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l32 0 0-118.7-16.4 5.5C251 67 237.4 60.2 233.2 47.6s2.6-26.2 15.2-30.4l48-16C303.7-1.2 311.8 0 318 4.5S328 16.3 328 24zM104 312l0 152 32 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 512c-13.3 0-24-10.7-24-24s10.7-24 24-24l32 0 0-118.7-16.4 5.5C27 355 13.4 348.2 9.2 335.6s2.6-26.2 15.2-30.4l48-16c7.3-2.4 15.4-1.2 21.6 3.3s10 11.8 10 19.5zM0 64C0 28.7 28.7 0 64 0l64 0c35.3 0 64 28.7 64 64l0 96c0 35.3-28.7 64-64 64l-64 0c-35.3 0-64-28.7-64-64L0 64zM64 48c-8.8 0-16 7.2-16 16l0 96c0 8.8 7.2 16 16 16l64 0c8.8 0 16-7.2 16-16l0-96c0-8.8-7.2-16-16-16L64 48zM256 288l64 0c35.3 0 64 28.7 64 64l0 96c0 35.3-28.7 64-64 64l-64 0c-35.3 0-64-28.7-64-64l0-96c0-35.3 28.7-64 64-64zm-16 64l0 96c0 8.8 7.2 16 16 16l64 0c8.8 0 16-7.2 16-16l0-96c0-8.8-7.2-16-16-16l-64 0c-8.8 0-16 7.2-16 16z"]],
    "shield-check": [512, 512, [], "f2f7", ["M64 139.7c.5 91.4 38.4 249.3 186.4 320.1 3.6 1.7 7.8 1.7 11.3 0 148-70.8 185.9-228.7 186.3-320.1 0-5-3.1-10.2-9-12.7l-183-77.6-183 77.6c-5.9 2.5-9.1 7.7-9 12.7zM166.8 285.5c-9.2-9.5-9-24.7 .6-33.9 9.5-9.2 24.7-8.9 33.9 .6l26.5 27.4 85.6-117.7c7.8-10.7 22.8-13.1 33.5-5.3 10.7 7.8 13.1 22.8 5.3 33.5L249.8 330.9c-4.2 5.7-10.7 9.3-17.8 9.8s-14-2.2-18.9-7.3l-46.4-48z", "M256.1 0c4.6 0 9.2 1 13.3 2.9L457.8 82.8c22 9.3 38.4 31 38.3 57.2-.5 99.2-41.3 280.7-213.6 363.2-16.7 8-36.1 8-52.8 0-172.4-82.5-213.2-263.9-213.7-363.2-.1-26.2 16.3-47.9 38.3-57.2L242.7 2.9C246.8 1 251.4 0 256.1 0zM73.1 127c-5.9 2.5-9.1 7.7-9 12.7 .5 91.4 38.4 249.3 186.4 320.1 3.6 1.7 7.8 1.7 11.3 0 148-70.8 185.9-228.7 186.3-320.1 0-5-3.1-10.2-9-12.7l-183-77.6-183 77.6zm240.3 34.9c7.8-10.7 22.8-13.1 33.5-5.3 10.7 7.8 13.1 22.8 5.3 33.5L249.8 330.9c-4.2 5.7-10.7 9.3-17.8 9.8s-14-2.2-18.9-7.3l-46.4-48c-9.2-9.5-9-24.7 .6-33.9 9.5-9.2 24.7-8.9 33.9 .6l26.5 27.4 85.6-117.7z"]],
    "square-cruzeiro": [448, 512, [], "e6ed", ["M48 96l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16zM94 256c0-70.7 57.3-128 128-128 34 0 65 13.3 87.9 34.9 9.6 9.1 10.1 24.3 1 33.9s-24.3 10.1-33.9 1c-14.3-13.5-33.6-21.8-54.9-21.8-44.2 0-80 35.8-80 80 0 38 26.5 69.8 62 78l0-86c0-11 9-20 20-20 10.1 0 18.4 7.5 19.8 17.2 10.8-5.8 23.1-9.2 36.2-9.2 11 0 20 9 20 20s-9 20-20 20c-19.9 0-36 16.1-36 36l0 20.9c12.5-3.6 23.7-10.1 32.9-18.7 9.6-9.1 24.8-8.7 33.9 1s8.7 24.8-1 33.9C286.9 370.7 256 384 222 384 151.3 384 94 326.7 94 256z", "M64 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM142 256c0 38 26.5 69.8 62 78l0-86c0-11 9-20 20-20 10.1 0 18.4 7.5 19.8 17.2 10.8-5.8 23.1-9.2 36.2-9.2 11 0 20 9 20 20s-9 20-20 20c-19.9 0-36 16.1-36 36l0 20.9c12.5-3.6 23.7-10.1 32.9-18.7 9.6-9.1 24.8-8.7 33.9 1s8.7 24.8-1 33.9C286.9 370.7 256 384 222 384 151.3 384 94 326.7 94 256s57.3-128 128-128c34 0 65 13.3 87.9 34.9 9.6 9.1 10.1 24.3 1 33.9s-24.3 10.1-33.9 1c-14.3-13.5-33.6-21.8-54.9-21.8-44.2 0-80 35.8-80 80z"]],
    "truck-pickup": [640, 512, [128763], "f63c", ["M80 240l0 96 4.1 0c16.1-19.5 40.6-32 67.9-32s51.7 12.5 67.9 32l200.2 0c16.1-19.5 40.6-32 67.9-32s51.7 12.5 67.9 32l4.1 0 0-96-480 0z", "M272 192l168 0-62.5-104.2c-2.9-4.8-8.1-7.8-13.7-7.8l-91.8 0 0 112zm-48 0l0-128c0-17.7 14.3-32 32-32l107.8 0c22.5 0 43.3 11.8 54.9 31.1L496 192 560 192c26.5 0 48 21.5 48 48l0 96 8 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-40.4 0c.2 2.6 .4 5.3 .4 8 0 48.6-39.4 88-88 88s-88-39.4-88-88c0-2.7 .1-5.4 .4-8l-160.7 0c.2 2.6 .4 5.3 .4 8 0 48.6-39.4 88-88 88s-88-39.4-88-88c0-2.7 .1-5.4 .4-8L24 384c-13.3 0-24-10.7-24-24s10.7-24 24-24l8 0 0-96c0-26.5 21.5-48 48-48l144 0zm0 48l-144 0 0 96 4.1 0c16.1-19.5 40.6-32 67.9-32s51.7 12.5 67.9 32l200.2 0c16.1-19.5 40.6-32 67.9-32s51.7 12.5 67.9 32l4.1 0 0-96-336 0zM192 392a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zm296 40a40 40 0 1 0 0-80 40 40 0 1 0 0 80z"]],
    "seedling": [512, 512, [127793, "sprout"], "f4d8", ["M48 112l0 16c0 97.2 78.8 176 176 176l8 0 0-16c0-97.2-78.8-176-176-176l-8 0zM280 224l0 16c97.2 0 176-78.8 176-176l0-16c-97.2 0-176 78.8-176 176z", "M475.3 .2C491.4 1.8 504 15.4 504 32l0 32-.3 11.5c-5.8 114.5-97.7 206.4-212.2 212.2l-11.5 .3 0 200c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-136-8 0-11.5-.3C97.9 345.9 6.1 254.1 .3 139.5L0 128 0 96C0 79.4 12.6 65.8 28.7 64.2l3.3-.2 24 0 11.5 .3c72 3.7 135 41.4 173.3 97.3 26-89.8 106.7-156.4 203.6-161.3l11.5-.3 16 0 3.3 .2zM48 128c0 97.2 78.8 176 176 176l8 0 0-16c0-97.2-78.8-176-176-176l-8 0 0 16zM456 48c-97.2 0-176 78.8-176 176l0 16c97.2 0 176-78.8 176-176l0-16z"]],
    "circle-divide": [512, 512, [], "e106", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm96 0c0-13.3 10.7-24 24-24l176 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-176 0c-13.3 0-24-10.7-24-24zm144-96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm0 192a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm0-320a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm-88 40c-13.3 0-24 10.7-24 24s10.7 24 24 24l176 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-176 0zM288 352a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"]],
    "circle-kip": [512, 512, [], "e6fd", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm96.2 .2c0-8.8 7.2-16 16-16l15.8 0 0-88.2c0-13.3 10.7-24 24-24s24 10.7 24 24l0 54.5 88.8-73c10.2-8.4 25.4-6.9 33.8 3.3s6.9 25.4-3.3 33.8l-84.7 69.7 77.3 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-77.1 0 84.5 69.2c10.3 8.4 11.8 23.5 3.4 33.8S323 387 312.8 378.6L224 305.9 224 360c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-87.8-15.8 0c-8.8 0-16-7.2-16-16z", "M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm90.5-375.2c-8.4-10.2-23.5-11.7-33.8-3.3l-88.8 73 0-54.5c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 88.2-15.8 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l15.8 0 0 87.8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-54.1 88.8 72.7c10.3 8.4 25.4 6.9 33.8-3.4s6.9-25.4-3.4-33.8l-84.5-69.2 77.1 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-77.3 0 84.7-69.7c10.2-8.4 11.7-23.5 3.3-33.8z"]],
    "transgender": [576, 512, [9895, "transgender-alt"], "f225", ["M176 240a112 112 0 1 0 224 0 112 112 0 1 0 -224 0z", "M136-32c13.3 0 24 10.7 24 24s-10.7 24-24 24L81.9 16 128 62.1 143 47c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-15 15 22.2 22.2C212.1 94.4 248.4 80 288 80s75.9 14.4 103.8 38.2L494.1 16 440 16c-13.3 0-24-10.7-24-24s10.7-24 24-24l112 0c13.3 0 24 10.7 24 24l0 112c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-54.1-104.7 104.7c15.6 24.7 24.7 54 24.7 85.4 0 80.2-59 146.6-136 158.2l0 33.8 40 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-40 0 0 40c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-40-40 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l40 0 0-33.8c-77-11.6-136-78-136-158.2 0-31.4 9-60.7 24.7-85.4l-24.7-24.7-15 15c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9L94.1 96 48 49.9 48 104c0 13.3-10.7 24-24 24S0 117.3 0 104L0-8C0-21.3 10.7-32 24-32l112 0zM288 352a112 112 0 1 0 0-224 112 112 0 1 0 0 224z"]],
    "arrow-down-to-bracket": [448, 512, [], "e094", ["", "M377 209L241 345c-9.4 9.4-24.6 9.4-33.9 0L71 209c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l95 95 0-246.1c0-13.3 10.7-24 24-24s24 10.7 24 24l0 246.1 95-95c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9zM48 344l0 72c0 26.5 21.5 48 48 48l256 0c26.5 0 48-21.5 48-48l0-72c0-13.3 10.7-24 24-24s24 10.7 24 24l0 72c0 53-43 96-96 96L96 512c-53 0-96-43-96-96l0-72c0-13.3 10.7-24 24-24s24 10.7 24 24z"]],
    "unicorn": [640, 512, [129412], "f727", ["M112 224.2c0 8.2 1.6 16.3 4.6 23.9l21.9 54.6c4.4 11.1 4.6 23.5 .4 34.7l-8.2 21.7c-7.7 20.6-8.7 43.1-2.8 64.4l11.2 40.5 49.8 0-14.8-53.3c-3.2-11.4-2.6-23.6 1.5-34.6l12.1-32.3c2.8-7.5 4.3-15.4 4.3-23.5 0-.4 0-.9 0-1.3-.2-7.6 3.3-14.9 9.4-19.5s14-6.1 21.3-4l88 25.7c2.1 .6 4.2 1.1 6.3 1.6 11.1 2.3 19 12.1 19 23.5l0 117.8 48 0 0-145.8c0-6.5 2.6-12.7 7.3-17.2 15.1-14.8 24.7-35.3 24.7-58.8 0-.6 0-1.2 0-1.7 0-.5 0-1 0-1.5l0-55c0-10.2 6.4-19.3 16.1-22.6s20.3-.3 26.7 7.7l5.9 7.3c8.9 11.1 24.1 15.1 37.3 9.8 13.9-5.5 22.2-19.9 20-34.7l-9.9-69.2C509.3 62.6 492.4 48 472.5 48l-37.1 0c-.6 .1-1.3 .2-2 .2-50 3.1-90.5 41.6-96.6 90.8-1.5 12-11.7 21-23.8 21l-136.7 0c-35.5 0-64.2 28.8-64.2 64.2zM480 96a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M426.8 .6c1.7-.4 3.4-.6 5.2-.6l40.5 0c2.5 0 5 .1 7.5 .3l0-.3 56 0c13.3 0 24 10.7 24 24 0 8.5-4.4 16-11.1 20.3 3.5 6.1 6.3 12.7 8.3 19.7l73.5 0c5.1 0 9.3 4.2 9.3 9.3 0 4-2.6 7.6-6.4 8.8l-69.8 23.3 5.6 39.4c5.2 36.7-15.3 72.2-49.7 86-18.3 7.3-38 7.5-55.8 1.5l0 7.8 0 .7 0 1.6c0 33.2-12.2 62.9-32 85.5L432 464c0 26.5-21.5 48-48 48l-48 0c-26.5 0-48-21.5-48-48l0-99.5-51.8-15.1c-1 3.8-2.2 7.5-3.6 11.2l-12.1 32.3c-.6 1.6-.7 3.3-.2 5l14.8 53.3c8.5 30.6-14.5 60.8-46.2 60.8l-49.8 0c-21.6 0-40.5-14.4-46.2-35.2L81.6 436.4c-8.6-31-7.2-63.9 4.1-94.1l8.2-21.7-21.9-54.6c-5.3-13.3-8-27.4-8-41.7 0-2.9 .1-5.7 .3-8.5-9.9 7.3-16.3 19-16.3 32.2l0 64c0 13.3-10.7 24-24 24S0 325.3 0 312l0-64c0-47.3 37.3-85.9 84.1-87.9 20.3-29.1 54-48.1 92.1-48.1l117.1 0C309.8 51.5 362.6 6.1 426.8 .6zM416 239l0-55c0-10.2 6.4-19.3 16.1-22.6s20.3-.3 26.7 7.7l5.9 7.3c8.9 11.1 24.1 15.1 37.3 9.8 13.9-5.5 22.2-19.9 20-34.7l-9.9-69.2C509.3 62.6 492.4 48 472.5 48l-37.1 0c-.6 .1-1.3 .2-2 .2-50 3.1-90.5 41.6-96.6 90.8-1.5 12-11.7 21-23.8 21l-136.7 0c-35.5 0-64.2 28.8-64.2 64.2 0 8.2 1.6 16.3 4.6 23.9l21.9 54.6c4.4 11.1 4.6 23.5 .4 34.7l-8.2 21.7c-7.7 20.6-8.7 43.1-2.8 64.4l11.2 40.5 49.8 0-14.8-53.3c-3.2-11.4-2.6-23.6 1.5-34.6l12.1-32.3c2.8-7.5 4.3-15.4 4.3-23.5 0-.4 0-.9 0-1.3-.2-7.6 3.3-14.9 9.4-19.5s14-6.1 21.3-4l88 25.7c2.1 .6 4.2 1.1 6.3 1.6 11.1 2.3 19 12.1 19 23.5l0 117.8 48 0 0-145.8c0-6.5 2.6-12.7 7.3-17.2 15.1-14.8 24.7-35.3 24.7-58.8 0-.6 0-1.2 0-1.7 0-.5 0-1 0-1.5zM464 80a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"]],
    "left-from-bracket": [512, 512, [], "e66c", ["M57.9 256l86.1 86.1 0-30.1c0-13.3 10.7-24 24-24l136 0 0-64-136 0c-13.3 0-24-10.7-24-24l0-30.1-86.1 86.1z", "M7 239c-9.4 9.4-9.4 24.6 0 33.9L151 417c6.9 6.9 17.2 8.9 26.2 5.2S192 409.7 192 400l0-64 112 0c26.5 0 48-21.5 48-48l0-64c0-26.5-21.5-48-48-48l-112 0 0-64c0-9.7-5.8-18.5-14.8-22.2S157.9 88.2 151 95L7 239zm137 73l0 30.1-86.1-86.1 86.1-86.1 0 30.1c0 13.3 10.7 24 24 24l136 0 0 64-136 0c-13.3 0-24 10.7-24 24zM344 432c-13.3 0-24 10.7-24 24s10.7 24 24 24l72 0c53 0 96-43 96-96l0-256c0-53-43-96-96-96l-72 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l72 0c26.5 0 48 21.5 48 48l0 256c0 26.5-21.5 48-48 48l-72 0z"]],
    "ramp-loading": [384, 512, [], "f4d4", ["M77.7 464l48-96 132.7 0 48 96-228.7 0z", "M0 64C0 28.7 28.7 0 64 0L320 0c35.3 0 64 28.7 64 64l0 340.7-48-96 0-244.7c0-8.8-7.2-16-16-16L64 48c-8.8 0-16 7.2-16 16L48 308.7 0 404.7 0 64zM336 416l36.4 72.8c.1 .3 .2 .5 .4 .8 4.6 10.5-3.1 22.4-14.7 22.4L25.9 512c-11.6 0-19.3-11.9-14.7-22.4 .1-.3 .2-.5 .4-.8 23.8-47.7 49-98 75.6-151.2 5.4-10.8 16.5-17.7 28.6-17.7l152.4 0c12.1 0 23.2 6.8 28.6 17.7L336 416zM77.7 464l228.7 0-48-96-132.7 0-48 96z"]],
    "hand-holding-box": [576, 512, [], "f47b", ["M0 376c0 13.3 10.7 24 24 24l48 0c4.7 0 9.4-1.4 13.3-4l79.9-53.3c6.6-4.4 14.3-6.7 22.2-6.7L320 336c8.8 0 16 7.2 16 16s-7.2 16-16 16l-64 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l144 0c4.8 0 9.6-1.5 13.6-4.2l76-52.1c10.7-7.3 25.4-4.1 32 7 6.1 10.2 3.2 23.5-6.6 30.2l-80.1 54.6c-12 8.2-26.1 12.5-40.6 12.5L24 464c-13.3 0-24 10.7-24 24L0 376z", "M400 48l-48 0 0 73.7c0 3.5-2.8 6.3-6.3 6.3-1.1 0-2.2-.3-3.1-.8l-46.6-26.6c-4.9-2.8-11-2.8-15.9 0l-46.6 26.6c-1 .5-2 .8-3.1 .8-3.5 0-6.3-2.8-6.3-6.3l0-73.7-48 0 0 144 224 0 0-144zm0-48c26.5 0 48 21.5 48 48l0 144c0 26.5-21.5 48-48 48l-224 0c-26.5 0-48-21.5-48-48l0-144c0-26.5 21.5-48 48-48L400 0zM187.4 336c-7.9 0-15.6 2.3-22.2 6.7L85.3 396c-3.9 2.6-8.6 4-13.3 4l-48 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l40.7 0 73.8-49.2C153 293.1 170 288 187.4 288L320 288c35.3 0 64 28.7 64 64 0 5.5-.7 10.9-2 16l10.6 0 69.9-47.9c33.5-23 79.4-12.9 100.3 21.9 19.2 32 10.1 73.5-20.7 94.5L462 491.1c-19.9 13.6-43.5 20.9-67.6 20.9L24 512c-13.3 0-24-10.7-24-24s10.7-24 24-24l370.4 0c14.5 0 28.6-4.4 40.6-12.5L515 396.9c9.9-6.7 12.8-20 6.6-30.2-6.7-11.1-21.3-14.3-32-7l-76 52.1c-4 2.7-8.7 4.2-13.6 4.2l-144 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l64 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-132.6 0z"]],
    "star-half": [576, 512, [61731], "f089", ["M87.2 190.7L177 280.6c5.4 5.4 7.9 13.1 6.7 20.7l-19.8 125.5 92.2-46.9 0-272.6-25.8 50.6c-3.5 6.8-10 11.6-17.6 12.8l-125.5 20z", "M285.7-15.8c10.8 2.6 18.4 12.2 18.4 23.3l0 387.1c0 9-5.1 17.3-13.1 21.4L143.8 491c-8 4.1-17.7 3.3-25-2s-11-14.2-9.6-23.2L134.4 305.9 20 191.4c-6.4-6.4-8.6-15.8-5.8-24.4s10.1-14.9 19.1-16.3L193.1 125.3 258.8-3.3c5-9.9 16.2-15 27-12.4zM256.1 107.4L230.3 158c-3.5 6.8-10 11.6-17.6 12.8l-125.5 20 89.8 89.9c5.4 5.4 7.9 13.1 6.7 20.7l-19.8 125.5 92.2-46.9 0-272.6z"]],
    "arrow-down-to-line": [384, 512, ["arrow-to-bottom"], "f33d", ["", "M360 512c13.3 0 24-10.7 24-24s-10.7-24-24-24L24 464c-13.3 0-24 10.7-24 24s10.7 24 24 24l336 0zM175 377c9.4 9.4 24.6 9.4 33.9 0L345 241c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-95 95 0-278.1c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 278.1-95-95c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9L175 377z"]],
    "photo-film": [640, 512, ["photo-video"], "f87c", ["M240 64l0 224c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-224c0-8.8-7.2-16-16-16L256 48c-8.8 0-16 7.2-16 16zm96 48a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM274.4 258.5c-4-8.2-3-18 2.6-25.3l56-72c4.5-5.8 11.5-9.3 18.9-9.3s14.4 3.4 18.9 9.3l17.2 22.1 47.5-76.1C440 100.3 447.7 96 456 96s16 4.3 20.4 11.3l80 128c4.6 7.4 4.9 16.7 .6 24.4S544.7 272 536 272l-240 0c-9.2 0-17.5-5.2-21.6-13.5z", "M576 48c8.8 0 16 7.2 16 16l0 224c0 8.8-7.2 16-16 16l-320 0c-8.8 0-16-7.2-16-16l0-224c0-8.8 7.2-16 16-16l320 0zM256 0c-35.3 0-64 28.7-64 64l0 224c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-224c0-35.3-28.7-64-64-64L256 0zM456 96c-8.3 0-16 4.3-20.4 11.3l-47.5 76.1-17.2-22.1c-4.5-5.8-11.5-9.3-18.9-9.3s-14.4 3.4-18.9 9.3l-56 72c-5.6 7.2-6.6 17-2.6 25.3S286.8 272 296 272l240 0c8.7 0 16.8-4.7 21-12.4s4-17-.6-24.4l-80-128C472 100.3 464.3 96 456 96zM336 112a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM120 128l-56 0c-35.3 0-64 28.7-64 64L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-16-48 0 0 16c0 8.8-7.2 16-16 16l-32 0 0-32-48 0 0 32-160 0 0-304-24 0zM96 176l0 56-48 0 0-40c0-8.8 7.2-16 16-16l32 0zm0 256l-32 0c-8.8 0-16-7.2-16-16l0-40 48 0 0 56zM48 328l0-48 48 0 0 48-48 0z"]],
    "pi": [448, 512, [], "f67e", ["", "M24 32C10.8 32 0 42.7 0 56S10.8 80 24 80l88 0 0 229.4c0 44.9-11.4 89-33.2 128.2L75 444.3c-6.4 11.6-2.3 26.2 9.3 32.6s26.2 2.3 32.6-9.3l3.8-6.8c25.8-46.4 39.3-98.5 39.3-151.5l0-229.4 144 0 0 326.6c0 40.6 32.9 73.4 73.4 73.4 27.8 0 53.2-15.7 65.7-40.6l2.3-4.7c5.9-11.9 1.1-26.3-10.7-32.2s-26.3-1.1-32.2 10.7l-2.3 4.7c-4.3 8.6-13.1 14.1-22.8 14.1-14.1 0-25.4-11.4-25.4-25.4l0-326.6 72 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L24 32z"]],
    "picture-in-picture": [512, 512, [], "e80b", ["M48 96c0-8.8 7.2-16 16-16l384 0c8.8 0 16 7.2 16 16l0 112-160 0c-53 0-96 43-96 96 0 131 0 173.7 0 128L64 432c-8.8 0-16-7.2-16-16L48 96z", "M448 32c35.3 0 64 28.7 64 64l0 112-48 0 0-112c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l144 0 0 48-144 0-6.5-.3c-30.1-3.1-54.1-27-57.1-57.1L0 416 0 96C0 62.9 25.2 35.6 57.5 32.3L64 32 448 32zm16 224c26.5 0 48 21.5 48 48l0 128-.2 4.9C509.3 461.1 488.9 480 464 480l-160 0-4.9-.2c-22.6-2.3-40.6-20.3-42.8-42.8l-.2-4.9 0-128c0-26.5 21.5-48 48-48l160 0zM304 432l160 0 0-128-160 0 0 128z"]],
    "table-cells-lock": [640, 512, [], "e679", ["M112 96l0 72 88 0 0-88-72 0c-8.8 0-16 7.2-16 16zm0 120l0 80 88 0 0-80-88 0zm0 128l0 72c0 8.8 7.2 16 16 16l72 0 0-88-88 0zM248 80l0 88 80 0 0-88-80 0zm0 136l0 80 80 0 0-80-80 0zm0 128l0 88 80 0 0-88-80 0zM376 80l0 88 77.4 0c3.4-2.5 7-4.8 10.6-6.9L464 96c0-8.8-7.2-16-16-16l-72 0zm0 136l0 80 24 0 0-24c0-20.1 4.6-39.1 12.9-56L376 216z", "M376 80l72 0c8.8 0 16 7.2 16 16l0 65.1c14.5-8.4 30.7-14 48-16.1l0-49c0-35.3-28.7-64-64-64L128 32C92.7 32 64 60.7 64 96l0 320c0 35.3 28.7 64 64 64l241.3 0c-.9-5.2-1.3-10.6-1.3-16.1l0-96c0-28.5 12.4-54 32-71.5l0-.4-24 0 0-80 36.9 0c9.3-19.2 23.3-35.7 40.5-48l-77.4 0 0-88zm-48 0l0 88-80 0 0-88 80 0zM200 80l0 88-88 0 0-72c0-8.8 7.2-16 16-16l72 0zM112 296l0-80 88 0 0 80-88 0zm0 48l88 0 0 88-72 0c-8.8 0-16-7.2-16-16l0-72zm136 88l0-88 80 0 0 88-80 0zm0-136l0-80 80 0 0 80-80 0zm312-23.9l0 47.9-64 0 0-47.9c0-17.7 14.3-32 32-32s32 14.3 32 32zM416 368l0 96c0 26.5 21.5 48 48 48l128 0c26.5 0 48-21.5 48-48l0-96c0-20.9-13.4-38.7-32-45.3l0-50.6c0-44.2-35.8-80-80-80s-80 35.8-80 80l0 50.6c-18.6 6.6-32 24.4-32 45.3z"]],
    "pump-medical": [320, 512, [], "e06a", ["M48 192l0 256c0 8.8 7.2 16 16 16l192 0c8.8 0 16-7.2 16-16l0-256c0-8.8-7.2-16-16-16L64 176c-8.8 0-16 7.2-16 16zM80 308c0-8.8 7.2-16 16-16l36 0 0-36c0-8.8 7.2-16 16-16l24 0c8.8 0 16 7.2 16 16l0 36 36 0c8.8 0 16 7.2 16 16l0 24c0 8.8-7.2 16-16 16l-36 0 0 36c0 8.8-7.2 16-16 16l-24 0c-8.8 0-16-7.2-16-16l0-36-36 0c-8.8 0-16-7.2-16-16l0-24zM128 48l0 80 64 0 0-80-64 0z", "M128 128l64 0 0-80-64 0 0 80zm-48 0l0-96C80 14.3 94.3 0 112 0l96 0c17.7 0 32 14.3 32 32l0 8 56 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-56 0 0 40 16 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 192c0-35.3 28.7-64 64-64l16 0zm160 48L64 176c-8.8 0-16 7.2-16 16l0 256c0 8.8 7.2 16 16 16l192 0c8.8 0 16-7.2 16-16l0-256c0-8.8-7.2-16-16-16l-16 0zM132 256c0-8.8 7.2-16 16-16l24 0c8.8 0 16 7.2 16 16l0 36 36 0c8.8 0 16 7.2 16 16l0 24c0 8.8-7.2 16-16 16l-36 0 0 36c0 8.8-7.2 16-16 16l-24 0c-8.8 0-16-7.2-16-16l0-36-36 0c-8.8 0-16-7.2-16-16l0-24c0-8.8 7.2-16 16-16l36 0 0-36z"]],
    "fire": [448, 512, [128293], "f06d", ["M48 288c0 97.2 78.8 176 176 176s176-78.8 176-176c0-57.7-23.6-111.3-48.4-151.4-11.3-18.3-22.7-33.4-31.6-44.4-8.5 10.5-19.3 24.8-30.2 42.1-4.6 7.3-12.8 11.6-21.4 11.2s-16.4-5.4-20.3-13.2c-19-37.6-41.3-68.5-58.9-90.1-5.2-6.4-10-12-14.2-16.6-1.8 1.7-3.6 3.6-5.6 5.6-13.6 14-31.8 34.3-49.9 59.6-36.6 51-71.5 120.1-71.5 197zm64 18.8c0-47.5 33.2-86.5 51.5-104.3 6.3-6.1 16.1-5 21.5 1.9 16.2 20.5 48 60.9 65.3 83 6.2 7.9 18.1 8.2 24.7 .5l25.2-29.3c6.5-7.6 18-6.9 22.5 2 25.3 46.2 14 105-28.1 134.4-21.1 14-43.5 21-68.8 21-63.2 0-113.7-40.6-113.7-109.2z", "M160.5-26.4c9.3-7.8 23.1-7.4 31.9 .9 12.2 11.6 23.3 24.4 33.9 37.4 13.5 16.5 29.7 38.3 45.3 64.2 5.2-6.8 10-12.8 14.2-17.9 1.1-1.3 2.2-2.7 3.4-4.1 7.8-9.8 17.7-22.1 30.8-22.1 13.4 0 22.8 11.9 30.8 22.1 1.3 1.7 2.6 3.3 3.9 4.8 10.3 12.4 24 30.3 37.7 52.4 27.2 43.9 55.6 106.4 55.6 176.6 0 123.7-100.3 224-224 224S0 411.7 0 288c0-91.1 41.1-170 80.5-225 19.9-27.7 39.7-49.9 54.6-65.1 8.2-8.4 16.5-16.7 25.5-24.2zM289.8 134.3c-4.6 7.3-12.8 11.6-21.4 11.2s-16.4-5.4-20.3-13.2c-19-37.6-41.3-68.5-58.9-90.1-5.2-6.4-10-12-14.2-16.6-1.8 1.7-3.6 3.6-5.6 5.6-13.6 14-31.8 34.3-49.9 59.6-36.6 51-71.5 120.1-71.5 197 0 97.2 78.8 176 176 176s176-78.8 176-176c0-57.7-23.6-111.3-48.4-151.4-11.3-18.3-22.7-33.4-31.6-44.4-8.5 10.5-19.3 24.8-30.2 42.1zM225.7 416c-63.2 0-113.7-40.6-113.7-109.2 0-47.5 33.2-86.5 51.5-104.3 6.3-6.1 16.1-5 21.5 1.9 16.2 20.5 48 60.9 65.3 83 6.2 7.9 18.1 8.2 24.7 .5l25.2-29.3c6.5-7.6 18-6.9 22.5 2 25.3 46.2 14 105-28.1 134.4-21.1 14-43.5 21-68.8 21z"]],
    "face-smile-plus": [640, 512, ["smile-plus"], "f5b9", ["M48 272a192 192 0 1 0 384 0 192 192 0 1 0 -384 0zm62.6 78.1c-7.8-10.7-5.4-25.7 5.3-33.5s25.7-5.4 33.5 5.3c20.4 28 53.4 46.1 90.6 46.1s70.2-18.1 90.6-46.1c7.8-10.7 22.8-13.1 33.5-5.3s13.1 22.8 5.3 33.5C340.3 390 293.2 416 240 416s-100.3-26-129.4-65.9zM192 224a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm160 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M568-40c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 48-48 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l48 0 0 48c0 13.3 10.7 24 24 24s24-10.7 24-24l0-48 48 0c13.3 0 24-10.7 24-24S629.3 8 616 8l-48 0 0-48zM240 80a192 192 0 1 1 0 384 192 192 0 1 1 0-384zm0 432a240 240 0 1 0 0-480 240 240 0 1 0 0 480zM149.4 321.9c-7.8-10.7-22.8-13.1-33.5-5.3s-13.1 22.8-5.3 33.5C139.7 390 186.8 416 240 416s100.3-26 129.4-65.9c7.8-10.7 5.4-25.7-5.3-33.5s-25.7-5.4-33.5 5.3c-20.4 28-53.4 46.1-90.6 46.1s-70.2-18.1-90.6-46.1zM192 224a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm128 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]],
    "magnifying-glass-plus": [512, 512, ["search-plus"], "f00e", ["M48 208a160 160 0 1 0 320 0 160 160 0 1 0 -320 0zm64 0c0-13.3 10.7-24 24-24l48 0 0-48c0-13.3 10.7-24 24-24s24 10.7 24 24l0 48 48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0 0 48c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-48-48 0c-13.3 0-24-10.7-24-24z", "M208 48a160 160 0 1 1 0 320 160 160 0 1 1 0-320zm0 368c48.8 0 93.7-16.8 129.1-44.9L471 505c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9L371.1 337.1C399.2 301.7 416 256.8 416 208 416 93.1 322.9 0 208 0S0 93.1 0 208 93.1 416 208 416zm0-304c-13.3 0-24 10.7-24 24l0 48-48 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l48 0 0 48c0 13.3 10.7 24 24 24s24-10.7 24-24l0-48 48 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0 0-48c0-13.3-10.7-24-24-24z"]],
    "swap": [576, 512, [], "e609", ["", "M28.4 158.2l43.6 0 0 201.8c0 66.3 53.7 120 120 120s120-53.7 120-120l0-208c0-39.8 32.2-72 72-72s72 32.2 72 72l0 200-43.6 0c-15.7 0-28.4 12.7-28.4 28.4 0 7.5 3 14.8 8.3 20.1L463 471.2c9.4 9.4 24.6 9.4 33.9 0l70.7-70.7c5.3-5.3 8.3-12.6 8.3-20.1 0-15.7-12.7-28.4-28.4-28.4l-43.6 0 0-200c0-66.3-53.7-120-120-120S264 85.7 264 152l0 208c0 39.8-32.2 72-72 72s-72-32.2-72-72l0-201.8 43.6 0c15.7 0 28.4-12.7 28.4-28.4 0-7.5-3-14.8-8.3-20.1L113 39c-9.4-9.4-24.6-9.4-33.9 0L8.3 109.7C3 115.1 0 122.3 0 129.8 0 145.5 12.7 158.2 28.4 158.2z"]],
    "comment-heart": [512, 512, [], "e5c8", ["M48 240c0 42.8 15.1 82.4 41.2 114.7 12.2 15.1 14.1 36.1 4.8 53.2l-18 33.1 58.5-25.1c11.8-5.1 25.2-5.2 37.1-.3 25.7 10.5 54.2 16.4 84.3 16.4 117.8 0 208-88.8 208-192S373.8 48 256 48 48 136.8 48 240zm96-21.3c0-32.4 26.3-58.7 58.7-58.7 18.5 0 35.9 8.7 46.9 23.5l6.4 8.5 6.4-8.5c11.1-14.8 28.5-23.5 46.9-23.5 32.4 0 58.7 26.3 58.7 58.7l0 5.3c0 49.1-65.8 98.1-96.5 118.3-9.5 6.2-21.5 6.2-30.9 0-30.7-20.2-96.5-69.3-96.5-118.3l0-5.3z", "M0 240c0 54.4 19.3 104.6 51.9 144.9L3.1 474.3c-2 3.7-3.1 7.9-3.1 12.2 0 14.1 11.4 25.5 25.5 25.5 4 0 7.8-.6 11.5-2.1L153.4 460c31.4 12.9 66.1 20 102.6 20 141.4 0 256-107.5 256-240S397.4 0 256 0 0 107.5 0 240zM94 407.9c9.3-17.1 7.4-38.1-4.8-53.2-26.1-32.3-41.2-71.9-41.2-114.7 0-103.2 90.2-192 208-192s208 88.8 208 192-90.2 192-208 192c-30.2 0-58.7-5.9-84.3-16.4-11.9-4.9-25.3-4.8-37.1 .3L76 440.9 94 407.9zM249.6 183.5c-11.1-14.8-28.5-23.5-46.9-23.5-32.4 0-58.7 26.3-58.7 58.7l0 5.3c0 49.1 65.8 98.1 96.5 118.3 9.5 6.2 21.5 6.2 30.9 0 30.7-20.2 96.5-69.3 96.5-118.3l0-5.3c0-32.4-26.3-58.7-58.7-58.7-18.5 0-35.9 8.7-46.9 23.5l-6.4 8.5-6.4-8.5z"]],
    "face-smile-tear": [512, 512, [], "e393", ["M48 256c0 114.9 93.1 208 208 208 28.4 0 55.5-5.7 80.1-16 47-.1 86.1-34 94.3-78.7 21.2-32.6 33.6-71.5 33.6-113.3 0-114.9-93.1-208-208-208S48 141.1 48 256zm94.7 96.6c-9.2-9.6-8.9-24.8 .7-33.9s24.8-8.9 33.9 .7c12.8 13.3 33.6 27.6 62.7 31.6l0 1.1c0 17.5 4.7 33.9 12.8 48-51.6-.9-88.5-24.8-110.1-47.4zM208 208a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm80 140.8c0-17.2 11.2-34 20.3-47.4 5.7-8.5 11.8-16.7 18.3-24.6 2.4-2.9 5.7-4.8 9.4-4.8s7 1.9 9.4 4.8c6.5 7.8 12.6 16.1 18.3 24.6 9 13.4 20.3 30.2 20.3 47.4 0 28.3-21.5 51.2-48 51.2s-48-22.9-48-51.2zM368 208a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M256 464C141.1 464 48 370.9 48 256S141.1 48 256 48 464 141.1 464 256c0 41.8-12.3 80.7-33.6 113.3-8.2 44.7-47.3 78.6-94.3 78.7-24.7 10.3-51.7 16-80.1 16zM142.7 352.6c21.6 22.5 58.5 46.4 110.1 47.4-8.2-14.1-12.8-30.5-12.8-48l0-1.1c-29.1-3.9-49.9-18.2-62.7-31.6-9.2-9.6-24.4-9.9-33.9-.7s-9.9 24.4-.7 33.9zM256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM176 240a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm192-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm-22.6 68.8c-2.4-2.9-5.7-4.8-9.4-4.8s-7 1.9-9.4 4.8c-6.5 7.8-12.6 16.1-18.3 24.6-9 13.4-20.3 30.2-20.3 47.4 0 28.3 21.5 51.2 48 51.2s48-22.9 48-51.2c0-17.2-11.2-34-20.3-47.4-5.7-8.5-11.8-16.7-18.3-24.6z"]],
    "wheat": [576, 512, [], "f72d", ["M73.7 299.1L101.6 327c18.4 18.4 21.4 46.7 8.3 68.4L82 367.6c-18.6-18.6-21.3-46.9-8.3-68.5zM149 434.6c21.8-13.1 50.1-10 68.5 8.3l27.9 27.9c-21.5 13-49.9 10.3-68.4-8.3L149 434.6zm36.7-247.4L213.6 215c18.4 18.4 21.4 46.7 8.3 68.4L194 255.6c-18.6-18.6-21.3-46.9-8.3-68.5zM261 322.6c21.8-13.1 50.1-10 68.5 8.3l27.9 27.9c-21.5 13-49.9 10.3-68.4-8.3L261 322.6zM297.7 75.1L325.6 103c18.4 18.4 21.4 46.7 8.3 68.4L306 143.6c-18.6-18.6-21.3-46.9-8.3-68.5zM373 210.6c21.8-13.1 50.1-10 68.5 8.3l27.9 27.9c-21.5 13-49.9 10.3-68.4-8.3L373 210.6zM456.5 77c0-29.3 23.7-53 53-53l11 0 0 11-.3 5.4c-2.5 25-22.4 44.8-47.3 47.3l-5.4 .3-11 0 0-11z", "M72.5 240c6.4 0 12.5 2.5 17 7l46.1 46.1c23.4 23.4 33.4 55.4 29.7 86.2 30.8-3.8 62.9 6.3 86.2 29.7L297.4 455c4.5 4.5 7 10.6 7 17s-2.5 12.5-7 17l-7.4 7.4c-40.6 40.6-106.5 40.6-147.1 0l-30.5-30.5-63 63c-9.4 9.4-24.5 9.4-33.9 0-9.4-9.4-9.4-24.6 0-33.9l63-63-30.5-30.5c-40.6-40.6-40.6-106.5 0-147.1l7.4-7.4 3.7-3c3.9-2.6 8.5-4 13.3-4zm145 202.9c-18.4-18.4-46.7-21.5-68.5-8.3l27.9 27.9c18.6 18.6 46.9 21.3 68.4 8.3l-27.9-27.9zM184.5 128c6.4 0 12.5 2.5 17 7l46.1 46.1c23.4 23.4 33.4 55.4 29.7 86.2 30.8-3.8 62.9 6.3 86.2 29.7L409.4 343c4.5 4.5 7 10.6 7 17s-2.5 12.5-7 17l-7.4 7.4c-40.6 40.6-106.5 40.6-147.1 0l-94.9-94.9c-40.6-40.6-40.6-106.5 0-147.1l7.4-7.4 3.7-3c3.9-2.6 8.5-4 13.3-4zM73.7 299.1c-13 21.5-10.2 49.9 8.3 68.5l27.9 27.9c13.1-21.8 10.1-50.1-8.3-68.4L73.7 299.1zm255.8 31.8c-18.4-18.4-46.7-21.5-68.5-8.3l27.9 27.9c18.6 18.6 46.9 21.3 68.4 8.3l-27.9-27.9zM296.5 16c6.4 0 12.5 2.5 17 7l46.1 46.1c23.4 23.4 33.4 55.4 29.7 86.2 30.8-3.8 62.9 6.3 86.2 29.7L521.4 231c4.5 4.5 7 10.6 7 17s-2.5 12.5-7 17l-7.4 7.4c-40.6 40.6-106.5 40.6-147.1 0l-94.9-94.9c-40.6-40.6-40.6-106.5 0-147.1l7.4-7.4 3.7-3c3.9-2.6 8.5-4 13.3-4zM185.7 187.1c-13 21.5-10.2 49.9 8.3 68.5l27.9 27.9c13.1-21.8 10.1-50.1-8.3-68.4l-27.9-27.9zm255.8 31.8c-18.4-18.4-46.7-21.5-68.5-8.3l27.9 27.9c18.6 18.6 46.9 21.3 68.4 8.3l-27.9-27.9zM297.7 75.1c-13 21.5-10.2 49.9 8.3 68.5l27.9 27.9c13.1-21.8 10.1-50.1-8.3-68.4L297.7 75.1zM544.5-24c6.4 0 12.5 2.5 17 7s7 10.6 7 17l0 35-.1 5.2c-2.6 51.7-44 93.1-95.7 95.7l-5.2 .1-35 0c-6.4 0-12.5-2.5-17-7s-7-10.6-7-17l0-35c0-55.8 45.2-101 101-101l35 0zm-35 48c-29.3 0-53 23.7-53 53l0 11 11 0 5.4-.3c25-2.5 44.8-22.4 47.3-47.3l.3-5.4 0-11-11 0z"]],
    "barcode-scan": [576, 512, [], "f465", ["", "M96 32C78.3 32 64 46.3 64 64l0 160-40 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l528 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-40 0 0-168c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 168-48 0 0-168c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 168-48 0 0-160c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 160-48 0 0-168c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 168-32 0 0-160c0-17.7-14.3-32-32-32zM64 448c0 17.7 14.3 32 32 32s32-14.3 32-32l0-128-64 0 0 128zm96 8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-136-48 0 0 136zm96-8c0 17.7 14.3 32 32 32s32-14.3 32-32l0-128-64 0 0 128zm112 8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-136-48 0 0 136zm96 0c0 13.3 10.7 24 24 24s24-10.7 24-24l0-136-48 0 0 136z"]],
    "ear-circle-checkmark": [576, 512, [], "e75b", ["M112 192c0-79.5 64.5-144 144-144s144 64.5 144 144c0 6.4-.4 12.7-1.2 18.9-90.2 15.7-158.8 94.4-158.8 189.1 0 17.3 2.3 34 6.6 50-13.1 9-28.8 14-45.2 14l-9.3 0c-44.2 0-80-35.8-80-80l0-192zm32 0l0 40c0 13.3 10.7 24 24 24l16 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-16 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l16 0c39.8 0 72-32.2 72-72 0-37.1-28-67.6-64-71.6l0-16.4c0-35.3 28.7-64 64-64s64 28.7 64 64l0 8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-8c0-61.9-50.1-112-112-112S144 130.1 144 192z", "M400 192c0 6.4-.4 12.7-1.2 18.9 10.8-1.9 21.9-2.9 33.2-2.9 5.1 0 10.2 .2 15.3 .6 .5-5.5 .7-11 .7-16.6 0-106-86-192-192-192S64 86 64 192l0 192c0 70.7 57.3 128 128 128l9.3 0c22.9 0 44.8-6.1 63.8-17-8-14-14.3-29.1-18.5-45-13 8.9-28.7 14-45.2 14l-9.3 0c-44.2 0-80-35.8-80-80l0-192c0-79.5 64.5-144 144-144s144 64.5 144 144zm-208 0c0-35.3 28.7-64 64-64s64 28.7 64 64l0 8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-8c0-61.9-50.1-112-112-112S144 130.1 144 192l0 40c0 13.3 10.7 24 24 24l16 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-16 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l16 0c39.8 0 72-32.2 72-72 0-37.1-28-67.6-64-71.6l0-16.4zM576 400a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-86.6-60.9c7.1 5.2 8.7 15.2 3.5 22.3l-64 88c-2.8 3.8-7 6.2-11.7 6.5s-9.3-1.3-12.6-4.6l-40-40c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l26.8 26.8 53-72.9c5.2-7.1 15.2-8.7 22.4-3.5z"]],
    "galaxy": [512, 512, [], "e008", ["M49.5 235.9c9.6 65.7 66.2 116.1 134.5 116.1 27 0 52.1-7.8 73.2-21.4 7.9-5.1 18.1-5 26 .1s12.1 14.4 10.6 23.7c-6.3 41.5-26.8 79.7-58 108.1 65.7-9.6 116.1-66.2 116.1-134.5 0-27-7.8-52.1-21.4-73.2-5.1-7.9-5-18.1 .1-26s14.4-12.1 23.7-10.6c41.5 6.3 79.7 26.8 108.1 58-9.6-65.7-66.2-116.1-134.6-116.1-27 0-52.1 7.8-73.2 21.4-7.9 5.1-18.1 5-26-.1s-12.1-14.4-10.6-23.7c6.3-41.5 26.8-79.7 58-108.1-65.7 9.6-116.1 66.2-116.1 134.5 0 27 7.8 52.1 21.4 73.2 5.1 7.9 5 18.1-.1 26s-14.4 12.1-23.7 10.6c-41.5-6.3-79.7-26.8-108.1-58zM288 256a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M160 184c0-68.3 50.4-124.9 116.1-134.5-31.2 28.4-51.6 66.6-58 108.1-1.4 9.3 2.7 18.6 10.6 23.7s18.1 5.2 26 .1c21.1-13.5 46.2-21.4 73.2-21.4 68.3 0 124.9 50.4 134.6 116.1-28.4-31.2-66.6-51.6-108.1-58-9.3-1.4-18.6 2.7-23.7 10.6s-5.2 18.1-.1 26c13.5 21.1 21.4 46.2 21.4 73.2 0 68.3-50.4 124.9-116.1 134.5 31.2-28.4 51.6-66.6 58-108.1 1.4-9.3-2.7-18.6-10.6-23.7s-18.1-5.2-26-.1c-21.1 13.5-46.2 21.4-73.2 21.4-68.3 0-124.9-50.4-134.5-116.1 28.4 31.2 66.6 51.6 108.1 58 9.3 1.4 18.6-2.7 23.7-10.6s5.2-18.1 .1-26C167.8 236.1 160 211 160 184zM296 0c-101.6 0-184 82.4-184 184 0 15.9 2 31.3 5.8 46-16.4-9.4-30.8-22.2-42.2-37.9l-13-17.9c-6.5-9-16.9-14.2-28-14.2-19.1 0-34.6 15.5-34.6 34.6L0 216c0 101.6 82.4 184 184 184 15.9 0 31.3-2 46-5.8-9.4 16.4-22.2 30.8-37.9 42.2l-17.9 13c-9 6.5-14.2 16.9-14.2 28 0 19.1 15.5 34.6 34.6 34.6l21.4 0c101.6 0 184-82.4 184-184 0-15.9-2-31.3-5.8-46 16.4 9.4 30.8 22.2 42.2 37.9l13 17.9c6.5 9 16.9 14.2 28 14.2 19.1 0 34.6-15.5 34.6-34.6l0-21.4c0-101.6-82.4-184-184-184-15.9 0-31.3 2-46 5.8 9.4-16.4 22.2-30.8 37.9-42.2l17.9-13 0 0c9-6.5 14.2-16.9 14.2-28 0-19.1-15.5-34.6-34.6-34.6L296 0zM256 288a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]],
    "flask": [448, 512, [], "f0c3", ["M48 456.4c0 4.2 3.4 7.6 7.6 7.6l336.8 0c4.2 0 7.6-3.4 7.6-7.6 0-1.3-.3-2.6-1-3.8L341.5 352 106.5 352 49 452.6c-.7 1.1-1 2.4-1 3.8z", "M96 24c0-13.3 10.7-24 24-24L328 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-8 0 0 169.6 120.7 211.2c4.8 8.4 7.3 17.9 7.3 27.6 0 30.7-24.9 55.6-55.6 55.6L55.6 512c-30.7 0-55.6-24.9-55.6-55.6 0-9.7 2.5-19.2 7.3-27.6L128 217.6 128 48 120 48c-13.3 0-24-10.7-24-24zm80 24l0 176c0 4.2-1.1 8.3-3.2 11.9l-38.9 68.1 180.1 0-38.9-68.1c-2.1-3.6-3.2-7.7-3.2-11.9l0-176-96 0zM106.5 352L49 452.6c-.7 1.1-1 2.4-1 3.8 0 4.2 3.4 7.6 7.6 7.6l336.8 0c4.2 0 7.6-3.4 7.6-7.6 0-1.3-.3-2.6-1-3.8l-57.5-100.6-235 0z"]],
    "car-key": [576, 512, [], "e7c0", ["M48 256c0-8.8 7.2-16 16-16l240 0c0 52.4 25.2 98.8 64 128l-320 0 0-112zm32 48a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M118.4 112.8C124.9 93.2 143.2 80 163.9 80l184.2 0c15.6 0 29.9 7.6 38.8 19.8 14.2-7.8 29.6-13.5 46-16.7-16.4-31-48.9-51-84.8-51L163.9 32c-41.3 0-78 26.4-91.1 65.6l-33 99.1C16.4 206.3 0 229.2 0 256L0 456c0 13.3 10.7 24 24 24s24-10.7 24-24l0-40 320 0 0-48-320 0 0-112c0-8.8 7.2-16 16-16l240 0c0-16.7 2.6-32.8 7.3-48L92 192 118.4 112.8zM112 336a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm464-96c0-61.9-50.1-112-112-112S352 178.1 352 240c0 44.7 26.2 83.2 64 101.2l0 116.2c0 4.2 1.7 8.3 4.7 11.3l32 32c6.2 6.2 16.4 6.2 22.6 0l41.4-41.4c6.2-6.2 6.2-16.4 0-22.6L496 416 517.9 394.1c5.8-5.8 6.3-14.9 1.2-21.3l-20.9-26.1C543.3 332.3 576 289.9 576 240zM432 224a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"]],
    "fireplace": [576, 512, [], "f79a", ["M48 48l480 0 0 64-480 0 0-64zM80 160l416 0 0 304-32 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l-352 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-32 0 0-304zm77.1 221.2c0 72.5 57.6 130.8 130.9 130.8 72.6 0 130.9-58.2 130.9-130.8 0-24.5-9-49.8-21.4-72.1-12.5-22.4-28.9-42.8-45-57.8-4.6-4.3-10.4-6.4-16.3-6.4-6.2 0-12.7 2.3-17.1 7.2l-10 11.3s-20.1-24-31.8-33.3c-4.4-3.5-9.4-6-15.4-6.1s-11.9 1.9-16.6 6.1c-19.1 17.3-40.9 40-58 65.6-17 25.5-30.1 54.9-30.1 85.5z", "M48 48l480 0 0 64-480 0 0-64zM32 0C14.3 0 0 14.3 0 32l0 96c0 17.7 14.3 32 32 32l0 328c0 13.3 10.7 24 24 24l56 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-32 0 0-304 416 0 0 304-32 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l56 0c13.3 0 24-10.7 24-24l0-328c17.7 0 32-14.3 32-32l0-96c0-17.7-14.3-32-32-32L32 0zM309 263.5s-20.1-24-31.8-33.3c-4.4-3.5-9.4-6-15.4-6.1s-11.9 1.9-16.6 6.1c-19.1 17.3-40.9 40-58 65.6-17 25.5-30.1 54.9-30.1 85.5 0 72.5 57.6 130.8 130.9 130.8 72.6 0 130.9-58.2 130.9-130.8 0-24.5-9-49.8-21.4-72.1-12.5-22.4-28.9-42.8-45-57.8-4.6-4.3-10.4-6.4-16.3-6.4-6.2 0-12.7 2.3-17.1 7.2l-10 11.3zm31.3 157c0 28.9-23.4 52.4-52.4 52.4s-52.4-23.4-52.4-52.4c0-29.9 30.3-59.7 44.8-72.3 4.4-3.8 10.7-3.8 15.1 0 14.5 12.6 44.8 42.5 44.8 72.3z"]],
    "flower-tulip": [448, 512, [127799], "f801", ["M49.5 368c8.8 54.4 56 96 113 96l33.5 0c-14.2-55.2-64.3-96-124-96l-22.5 0zM112 76.9l0 51.1c0 44.2 35.8 80 80 80l64 0c44.2 0 80-35.8 80-80l0-51.1-38.2 17c-10 4.4-21.7 1.6-28.5-6.9L224 30.4 178.8 87c-6.8 8.5-18.5 11.4-28.5 6.9L112 76.9zM252 464l33.5 0c56.9 0 104.1-41.6 113-96L376 368c-59.6 0-109.8 40.8-124 96z", "M224-32c7.3 0 14.2 3.3 18.7 9l52.4 65.5 55.1-24.5 2.8-1c6.7-2 14-1 20 2.8 6.8 4.4 10.9 12 10.9 20.1l0 88c0 70.7-57.3 128-128 128l-8 0 0 119.2c30.2-31.9 72.1-52.6 118.9-55l9.1-.2 42.5 0 3 .2c14.9 1.5 26.5 14.1 26.5 29.4l-.2 8.4C443.6 441 377 507.6 293.9 511.8l-8.4 .2-123.1 0-8.4-.2C71 507.6 4.4 441 .2 357.9L0 349.5c0-15.3 11.6-27.9 26.5-29.4l3-.2 42.5 0 9.1 .2c46.8 2.4 88.8 23 118.9 55l0-119.2-8 0c-70.7 0-128-57.3-128-128l0-88 .2-3c.9-6.9 4.8-13.2 10.8-17.1 6.8-4.4 15.4-5.1 22.8-1.8l55.1 24.5 52.4-65.5 1.8-2c4.5-4.5 10.6-7 16.9-7zM49.5 368c8.8 54.4 56 96 113 96l33.5 0c-14.2-55.2-64.3-96-124-96l-22.5 0zM376 368c-59.6 0-109.8 40.8-124 96l33.5 0c56.9 0 104.1-41.6 113-96L376 368zM178.8 87c-6.8 8.5-18.5 11.4-28.5 6.9l-38.2-17 0 51.1c0 44.2 35.8 80 80 80l64 0c44.2 0 80-35.8 80-80l0-51.1-38.2 17c-10 4.4-21.7 1.6-28.5-6.9L224 30.4 178.8 87z"]],
    "inboxes": [512, 512, [], "e1bb", ["M48 192l83.2 0 20.1 30.2c7.4 11.1 19.9 17.8 33.3 17.8l142.9 0c13.4 0 25.9-6.7 33.3-17.8l20.1-30.2 83.2 0 0 96-416 0 0-96zm0 144l79.8 0 21.9 54.9c6.1 15.2 20.8 25.1 37.1 25.1l138.3 0c16.4 0 31.1-10 37.1-25.1l21.9-54.9 79.8 0 0 112c0 8.8-7.2 16-16 16L64 464c-8.8 0-16-7.2-16-16l0-112z", "M87.7 48c-7.4 0-13.9 5.1-15.6 12.3l-19.7 83.7 83 0c13.4 0 25.9 6.7 33.3 17.8l20.1 30.2 134.3 0 20.1-30.2c7.4-11.1 19.9-17.8 33.3-17.8l83 0-19.7-83.7c-1.7-7.2-8.2-12.3-15.6-12.3L87.7 48zM48 288l416 0 0-96-83.2 0-20.1 30.2c-7.4 11.1-19.9 17.8-33.3 17.8l-142.9 0c-13.4 0-25.9-6.7-33.3-17.8l-20.1-30.2-83.2 0 0 96zM0 288L0 164.6c0-4.9 .6-9.9 1.7-14.7L25.4 49.3C32.2 20.4 58 0 87.7 0L424.3 0c29.7 0 55.5 20.4 62.3 49.3L510.3 150c1.1 4.8 1.7 9.7 1.7 14.7L512 448c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 288zm48 48l0 112c0 8.8 7.2 16 16 16l384 0c8.8 0 16-7.2 16-16l0-112-79.8 0-21.9 54.9C356.2 406 341.5 416 325.2 416l-138.3 0c-16.4 0-31.1-10-37.1-25.1L127.8 336 48 336zm131.4 0l12.8 32 127.5 0 12.8-32-153.1 0z"]],
    "rectangle-vertical": [384, 512, ["rectangle-portrait"], "f2fb", ["M48 64l0 384c0 8.8 7.2 16 16 16l256 0c8.8 0 16-7.2 16-16l0-384c0-8.8-7.2-16-16-16L64 48c-8.8 0-16 7.2-16 16z", "M336 448c0 8.8-7.2 16-16 16L64 464c-8.8 0-16-7.2-16-16L48 64c0-8.8 7.2-16 16-16l256 0c8.8 0 16 7.2 16 16l0 384zM384 64c0-35.3-28.7-64-64-64L64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-384z"]],
    "align-right": [448, 512, [], "f038", ["", "M424 40c13.3 0 24 10.7 24 24s-10.7 24-24 24L184 88c-13.3 0-24-10.7-24-24s10.7-24 24-24l240 0zm0 128c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 216c-13.3 0-24-10.7-24-24s10.7-24 24-24l400 0zm24 152c0 13.3-10.7 24-24 24l-240 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l240 0c13.3 0 24 10.7 24 24zM424 424c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 472c-13.3 0-24-10.7-24-24s10.7-24 24-24l400 0z"]],
    "transporter-6": [576, 512, [], "e2a7", ["", "M240-32c-8.8 0-16 7.2-16 16s7.2 16 16 16l96 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-96 0zM144 224c-8.8 0-16 7.2-16 16s7.2 16 16 16l288 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-288 0zm8 272c-13.3 0-24 10.7-24 24s10.7 24 24 24l272 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-272 0zM64 32L56.7 6.6C55.6 2.7 52.1 0 48 0s-7.6 2.7-8.7 6.6L32 32 6.6 39.3C2.7 40.4 0 43.9 0 48s2.7 7.6 6.6 8.7L32 64 39.3 89.4C40.4 93.3 43.9 96 48 96s7.6-2.7 8.7-6.6L64 64 89.4 56.7C93.3 55.6 96 52.1 96 48s-2.7-7.6-6.6-8.7L64 32zM536.7 358.6c-1.1-3.9-4.7-6.6-8.7-6.6s-7.6 2.7-8.7 6.6l-7.3 25.4-25.4 7.3c-3.9 1.1-6.6 4.7-6.6 8.7s2.7 7.6 6.6 8.7l25.4 7.3 7.3 25.4c1.1 3.9 4.7 6.6 8.7 6.6s7.6-2.7 8.7-6.6l7.3-25.4 25.4-7.3c3.9-1.1 6.6-4.7 6.6-8.7s-2.7-7.6-6.6-8.7l-25.4-7.3-7.3-25.4z"]],
    "cable-car": [512, 512, [128673, 57551, "tram"], "f7da", ["M80 392l0 56c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-56-352 0z", "M288 32c17.7 0 32-14.3 32-32s-14.3-32-32-32-32 14.3-32 32 14.3 32 32 32zm-64-8a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM160 272l0 72-80 0 0-56c0-8.8 7.2-16 16-16l64 0zm48 72l0-72 96 0 0 72-96 0zm144 0l0-72 64 0c8.8 0 16 7.2 16 16l0 56-80 0zm80 48l0 56c0 8.8-7.2 16-16 16L96 464c-8.8 0-16-7.2-16-16l0-56 352 0zM96 224c-35.3 0-64 28.7-64 64l0 160c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-160c0-35.3-28.7-64-64-64l-136 0 0-109.9 206.6-59c12.7-3.6 20.1-16.9 16.5-29.7S486.2 5.3 473.4 8.9l-224 64 0 0-224 64c-12.7 3.6-20.1 16.9-16.5 29.7s16.9 20.1 29.7 16.5l193.4-55.3 0 96.2-136 0z"]],
    "kit-medical": [512, 512, ["first-aid"], "f479", ["M48 128l0 256c0 8.8 7.2 16 16 16l32 0 0-288-32 0c-8.8 0-16 7.2-16 16zm96-16l0 288 224 0 0-288-224 0zm32 132c0-8.8 7.2-16 16-16l36 0 0-36c0-8.8 7.2-16 16-16l24 0c8.8 0 16 7.2 16 16l0 36 36 0c8.8 0 16 7.2 16 16l0 24c0 8.8-7.2 16-16 16l-36 0 0 36c0 8.8-7.2 16-16 16l-24 0c-8.8 0-16-7.2-16-16l0-36-36 0c-8.8 0-16-7.2-16-16l0-24zM416 112l0 288 32 0c8.8 0 16-7.2 16-16l0-256c0-8.8-7.2-16-16-16l-32 0z", "M144 400l224 0 0-288-224 0 0 288zm-48 0l0-288-32 0c-8.8 0-16 7.2-16 16l0 256c0 8.8 7.2 16 16 16l32 0zM64 64l384 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64L64 448c-35.3 0-64-28.7-64-64L0 128C0 92.7 28.7 64 64 64zM416 400l32 0c8.8 0 16-7.2 16-16l0-256c0-8.8-7.2-16-16-16l-32 0 0 288zM228 192c0-8.8 7.2-16 16-16l24 0c8.8 0 16 7.2 16 16l0 36 36 0c8.8 0 16 7.2 16 16l0 24c0 8.8-7.2 16-16 16l-36 0 0 36c0 8.8-7.2 16-16 16l-24 0c-8.8 0-16-7.2-16-16l0-36-36 0c-8.8 0-16-7.2-16-16l0-24c0-8.8 7.2-16 16-16l36 0 0-36z"]],
    "grip-lines": [448, 512, [], "f7a4", ["", "M448 184c0-13.3-10.7-24-24-24L24 160c-13.3 0-24 10.7-24 24s10.7 24 24 24l400 0c13.3 0 24-10.7 24-24zm0 144c0-13.3-10.7-24-24-24L24 304c-13.3 0-24 10.7-24 24s10.7 24 24 24l400 0c13.3 0 24-10.7 24-24z"]],
    "burger": [512, 512, ["hamburger"], "f805", ["M80 202c0-11.3 1.6-19 3.9-24.4 .3-.8 .7-1.5 1.1-2.2 17.5-32.1 64.3-95.4 171-95.4s153.5 63.3 171 95.4c2.9 5.4 5 13.7 5 26.6l0 38-352 0 0-38zm0 182l352 0 0 16c0 17.7-14.3 32-32 32l-288 0c-17.7 0-32-14.3-32-32l0-16zm56-224a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm96-32a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm96 32a24 24 0 1 0 48 0 24 24 0 1 0 -48 0z", "M32.3 192c.9-13.8 3.9-27.4 10.5-39.5 2.8-5.1 6.2-10.9 10.2-17 4.5-6.9 9.9-14.2 16.2-21.7 21.7-25.7 54.2-53.1 101.5-68.8 24.4-8.1 52.6-13.1 85.3-13.1 130.7 0 190.9 79.5 213.2 120.5 6.6 12.2 9.6 25.7 10.5 39.5 .2 3.3 .3 6.6 .3 10l0 38-48 0 0-38c0-12.9-2-21.1-5-26.6-17.5-32.1-64.3-95.4-171-95.4S102.5 143.3 85 175.4c-.4 .7-.7 1.4-1.1 2.2-2.4 5.4-3.9 13.1-3.9 24.4l0 38-48 0 0-38c0-3.3 .1-6.7 .3-10zm6.3 240c-4.3-9.8-6.7-20.6-6.7-32l0-16 48 0 0 16c0 17.7 14.3 32 32 32l288 0c17.7 0 32-14.3 32-32l0-16 48 0 0 16c0 11.4-2.4 22.2-6.7 32-12.3 28.3-40.5 48-73.3 48l-288 0c-32.8 0-61-19.7-73.3-48zM0 312c0-13.3 10.7-24 24-24l464 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 336c-13.3 0-24-10.7-24-24zM256 104a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM136 160a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm216-24a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]],
    "raindrops": [448, 512, [], "f75c", ["M240 390c0 40.9 33.1 74 74 74l12 0c40.9 0 74-33.1 74-74 0-13.7-3.8-27.1-10.9-38.7L320 238.7 250.9 351.3c-7.1 11.6-10.9 25-10.9 38.7z", "M102.4 101.6L148.5 7.2C150.6 2.8 155.1 0 160 0s9.4 2.8 11.5 7.2l46.1 94.4c4.2 8.6 6.4 18 6.4 27.6 0 34.7-28.1 62.8-62.8 62.8l-2.4 0c-34.7 0-62.8-28.1-62.8-62.8 0-9.6 2.2-19 6.4-27.6zm-96 224l46.1-94.4c2.1-4.4 6.6-7.2 11.5-7.2s9.4 2.8 11.5 7.2l46.1 94.4c4.2 8.6 6.4 18 6.4 27.6 0 34.7-28.1 62.8-62.8 62.8l-2.4 0c-34.7 0-62.8-28.1-62.8-62.8 0-9.6 2.2-19 6.4-27.6zM320 160c5 0 9.6 2.6 12.2 6.8l14.7 24 1.2 2 0 0 81.8 133.3c11.8 19.2 18 41.3 18 63.8 0 67.4-54.6 122-122 122l-12 0c-67.4 0-122-54.6-122-122 0-22.5 6.2-44.6 18-63.8l81.8-133.3 0 0 1.2-2 14.7-24c2.6-4.2 7.2-6.8 12.2-6.8zM250.9 351.3c-7.1 11.6-10.9 25-10.9 38.7 0 40.9 33.1 74 74 74l12 0c40.9 0 74-33.1 74-74 0-13.7-3.8-27.1-10.9-38.7L320 238.7 250.9 351.3z"]],
    "snowman": [640, 512, [9731, 9924], "f7d0", ["M168 376c0 48.8 22.9 92.2 58.7 120l186.6 0c35.8-27.8 58.7-71.2 58.7-120 0-54.3-28.4-101.9-71.3-128.8-6.3-3.9-10.4-10.6-11.1-18s2-14.7 7.4-19.8c21.6-20.4 35.1-49.3 35.1-81.4 0-61.9-50.1-112-112-112S208 66.1 208 128c0 32.1 13.4 60.9 35.1 81.4 5.4 5.1 8.1 12.4 7.4 19.8s-4.8 14-11.1 18C196.4 274.1 168 321.7 168 376zM296 96a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm-8 63.6c0-17.5 14.2-31.6 31.6-31.6l.8 0c17.5 0 31.6 14.2 31.6 31.6 0 5.5-1.4 10.9-4.2 15.7L327 211.8c-3.1 5.4-10.8 5.4-13.9 0l-20.9-36.6c-2.7-4.8-4.2-10.2-4.2-15.7zM344 320a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm0 96a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zM392 96a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M320 16c-61.9 0-112 50.1-112 112 0 32.1 13.4 60.9 35.1 81.4 5.4 5.1 8.1 12.4 7.4 19.8s-4.8 14-11.1 18c-42.9 26.9-71.3 74.6-71.3 128.8 0 48.8 22.9 92.2 58.7 120l186.6 0c35.8-27.8 58.7-71.2 58.7-120 0-54.3-28.4-101.9-71.3-128.8-6.3-3.9-10.4-10.6-11.1-18s2-14.7 7.4-19.8c21.6-20.4 35.1-49.3 35.1-81.4 0-61.9-50.1-112-112-112zM160 128c0-88.4 71.6-160 160-160S480 39.6 480 128c0 35.6-11.6 68.4-31.2 95 18.4 15.5 34 34.3 45.9 55.5l33.4-14.3 0-40.2c0-13.3 10.7-24 24-24s24 10.7 24 24l0 19.6 22.5-9.7c12.2-5.2 26.3 .4 31.5 12.6s-.4 26.3-12.6 31.5L512.9 322.9c4.6 16.9 7.1 34.7 7.1 53.1 0 67.7-33.6 127.5-85 163.6-4 2.8-8.9 4.4-13.8 4.4l-202.4 0c-4.9 0-9.8-1.5-13.8-4.4-51.3-36.2-85-96-85-163.6 0-18.4 2.5-36.2 7.1-53.1-31.2-13.4-66-28.3-104.6-44.8-12.2-5.2-17.8-19.3-12.6-31.5s19.3-17.8 31.5-12.6L64 243.6 64 224c0-13.3 10.7-24 24-24s24 10.7 24 24l0 40.2 33.4 14.3c11.9-21.2 27.4-40 45.9-55.5-19.6-26.6-31.2-59.4-31.2-95zM296 416a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm24-120a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM248 96a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM368 72a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM292.2 175.3c-2.7-4.8-4.2-10.2-4.2-15.7 0-17.5 14.2-31.6 31.6-31.6l.8 0c17.5 0 31.6 14.2 31.6 31.6 0 5.5-1.4 10.9-4.2 15.7L327 211.8c-3.1 5.4-10.8 5.4-13.9 0l-20.9-36.6z"]],
    "hotel": [512, 512, [127976], "f594", ["M80 48l0 416 144 0 0-80-48 0c-8.8 0-16.1-7.2-14.7-15.9 7.6-45.4 47.1-80.1 94.7-80.1s87.1 34.6 94.7 80.1c1.5 8.7-5.8 15.9-14.7 15.9l-48 0 0 80 144 0 0-416-352 0zm48 64c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm0 96c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm96-96c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm0 96c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm96-96c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm0 96c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32z", "M24 0C10.7 0 0 10.7 0 24S10.7 48 24 48l8 0 0 416-8 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l464 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-8 0 0-416 8 0c13.3 0 24-10.7 24-24S501.3 0 488 0L24 0zM432 464l-144 0 0-80 48 0c8.8 0 16.1-7.2 14.7-15.9-7.6-45.4-47.1-80.1-94.7-80.1s-87.1 34.6-94.7 80.1c-1.5 8.7 5.8 15.9 14.7 15.9l48 0 0 80-144 0 0-416 352 0 0 416zM144 96c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0zm80 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zM336 96c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0zM128 208l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm112-16c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0zm80 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16z"]],
    "print": [512, 512, [128424, 128438, 9113], "f02f", ["M48 256l0 112 48 0 0-16c0-17.7 14.3-32 32-32l256 0c17.7 0 32 14.3 32 32l0 16 48 0 0-112c0-8.8-7.2-16-16-16L64 240c-8.8 0-16 7.2-16 16z", "M384 144l48 0 0-37.5c0-17-6.7-33.3-18.7-45.3L370.7 18.7C358.7 6.7 342.5 0 325.5 0L144 0C108.7 0 80 28.7 80 64l0 80 48 0 0-80c0-8.8 7.2-16 16-16l181.5 0c4.2 0 8.3 1.7 11.3 4.7l42.5 42.5c3 3 4.7 7.1 4.7 11.3l0 37.5zM368 368l0 96-224 0 0-96 224 0zM128 320c-17.7 0-32 14.3-32 32l0 16-48 0 0-112c0-8.8 7.2-16 16-16l384 0c8.8 0 16 7.2 16 16l0 112-48 0 0-16c0-17.7-14.3-32-32-32l-256 0zm288 96l64 0c17.7 0 32-14.3 32-32l0-128c0-35.3-28.7-64-64-64L64 192c-35.3 0-64 28.7-64 64L0 384c0 17.7 14.3 32 32 32l64 0 0 64c0 17.7 14.3 32 32 32l256 0c17.7 0 32-14.3 32-32l0-64z"]],
    "dial-min": [576, 512, [], "e161", ["M193.7 348.4L271 271c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-77.4 77.4c43.4 27.8 101.7 22.8 139.6-15.1 43.7-43.7 43.7-114.7 0-158.4s-114.7-43.7-158.4 0c-37.9 37.9-43 96.2-15.1 139.6z", "M288 64a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM271 271l-77.4 77.4c-27.8-43.4-22.8-101.7 15.1-139.6 43.7-43.7 114.7-43.7 158.4 0s43.7 114.7 0 158.4c-37.9 37.9-96.2 43-139.6 15.1L305 305c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0zM174.9 401.1A160 160 0 1 0 401.1 174.9 160 160 0 1 0 174.9 401.1zM576 288a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM32 320a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM128 96a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm352 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM128 480a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm352 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]],
    "circle-polish-zloty": [512, 512, [], "e700", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm80-40c0-13.3 10.7-24 24-24l96 0c8.7 0 16.7 4.7 20.9 12.3s4.1 16.8-.5 24.3L202.8 336 248 336c13.3 0 24 10.7 24 24s-10.7 24-24 24l-88 0c-8.7 0-16.7-4.7-20.9-12.3s-4.1-16.8 .5-24.3L205.2 240 152 240c-13.3 0-24-10.7-24-24zm145.1 61.9c-3.3-8.2 .7-17.5 8.9-20.8l21.4-8.6 0-96.6c0-13.3 10.7-24 24-24s24 10.7 24 24l0 77.4 10.6-4.2c8.2-3.3 17.5 .7 20.8 8.9s-.7 17.5-8.9 20.8l-22.5 9 0 96.1c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-76.9-9.5 3.8c-8.2 3.3-17.5-.7-20.8-8.9z", "M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm95.4-360c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 96.6-21.4 8.6c-8.2 3.3-12.2 12.6-8.9 20.8s12.6 12.2 20.8 8.9l9.5-3.8 0 76.9c0 13.3 10.7 24 24 24s24-10.7 24-24l0-96.1 22.5-9c8.2-3.3 12.2-12.6 8.9-20.8s-12.6-12.2-20.8-8.9l-10.6 4.2 0-77.4zM128 216c0 13.3 10.7 24 24 24l53.2 0-65.7 107.5c-4.5 7.4-4.7 16.7-.5 24.3S151.3 384 160 384l88 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-45.2 0 65.7-107.5c4.5-7.4 4.7-16.7 .5-24.3S256.7 192 248 192l-96 0c-13.3 0-24 10.7-24 24z"]],
    "family": [512, 512, [], "e300", ["M80.1 224c0-8.8 7.2-16 16-16l69.5 0c3.3 9.3 7.9 17.9 13.7 25.6-22.9 17.2-39.8 41.9-47.2 70.4l-36 0c-8.8 0-16-7.2-16-16l0-64zm144 112c0-17.7 14.3-32 32-32s32 14.3 32 32l0 16c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-16zM332.9 233.6c5.8-7.7 10.4-16.3 13.7-25.6l37.5 0c16.5 0 30.9 10.9 35.4 26.7l28.9 101.3-64.4 0c0-41.9-20.1-79.1-51.2-102.4z", "M128.1 0a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm-48 224l0 64c0 8.8 7.2 16 16 16l36 0c-2.6 10.2-4 21-4 32l0 16-16 0 0 136c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-144.6c-19.1-11.1-32-31.7-32-55.4l0-64c0-35.3 28.7-64 64-64l64 0c.4 0 .9 0 1.3 0-.9 5.2-1.3 10.5-1.3 16 0 11.2 1.9 22 5.5 32l-69.5 0c-8.8 0-16 7.2-16 16zm304-16l-37.5 0c3.5-10 5.5-20.8 5.5-32 0-3.2-.2-6.4-.5-9.5 10.1-4.2 21.1-6.5 32.5-6.5 37.9 0 71.2 25.1 81.6 61.5l34.8 121.7c5.8 20.4-9.5 40.8-30.8 40.8l-21.6 0 0 104c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-104-20.6 0c3-10.1 4.6-20.9 4.6-32l0-16 64.4 0-28.9-101.3c-4.5-15.8-19-26.7-35.4-26.7zm0-208a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm-128 128a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm32 208c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 16c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-16zm48 16c0 24-13.2 44.9-32.7 55.8 .5 2.7 .7 5.4 .7 8.2l0 64c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-64c0-2.8 .2-5.5 .7-8.2-19.5-11-32.7-31.9-32.7-55.8l0-16c0-44.2 35.8-80 80-80s80 35.8 80 80l0 16z"]],
    "starfighter": [640, 512, [], "e037", ["M176 296l0 128c0 4.4 3.6 8 8 8l32 0c4.4 0 8-3.6 8-8l0-128c0-4.4-3.6-8-8-8l-32 0c-4.4 0-8 3.6-8 8zm96-14.5L272 424c0 4.4 3.6 8 8 8l80 0c4.4 0 8-3.6 8-8l0-142.5-29.2-233.5-37.6 0-29.2 233.5zM288 256c0-17.7 14.3-32 32-32s32 14.3 32 32l0 48c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-48zm128 40l0 128c0 4.4 3.6 8 8 8l32 0c4.4 0 8-3.6 8-8l0-128c0-4.4-3.6-8-8-8l-32 0c-4.4 0-8 3.6-8 8z", "M254.4 35C256.9 15 274 0 294.1 0l51.8 0c20.2 0 37.2 15 39.7 35l25.8 206.4c4.1-.9 8.3-1.4 12.6-1.4l32 0c30.9 0 56 25.1 56 56l0 56 56 0 0-184c-13.3 0-24-10.7-24-24s10.7-24 24-24l0-24c0-13.3 10.7-24 24-24s24 10.7 24 24l0 24c13.3 0 24 10.7 24 24s-10.7 24-24 24l0 280c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-2.7-88 29.3 0 5.3c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-.6c-8.8-1.3-17-4.6-24-9.5-9.1 6.3-20.1 10-32 10l-80 0c-11.9 0-22.9-3.7-32-10-7 4.9-15.2 8.2-24 9.5l0 .6c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-5.3-88-29.3 0 2.7c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-280c-13.3 0-24-10.7-24-24s10.7-24 24-24l0-24c0-13.3 10.7-24 24-24S72 82.7 72 96l0 24c13.3 0 24 10.7 24 24s-10.7 24-24 24l0 184 56 0 0-56c0-30.9 25.1-56 56-56l32 0c4.3 0 8.6 .5 12.6 1.4L254.4 35zM368 424l0-142.5-29.2-233.5-37.6 0-29.2 233.5 0 142.5c0 4.4 3.6 8 8 8l80 0c4.4 0 8-3.6 8-8zm48-128l0 128c0 4.4 3.6 8 8 8l32 0c4.4 0 8-3.6 8-8l0-128c0-4.4-3.6-8-8-8l-32 0c-4.4 0-8 3.6-8 8zm-200-8l-32 0c-4.4 0-8 3.6-8 8l0 128c0 4.4 3.6 8 8 8l32 0c4.4 0 8-3.6 8-8l0-128c0-4.4-3.6-8-8-8zm104-64c17.7 0 32 14.3 32 32l0 48c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-48c0-17.7 14.3-32 32-32z"]],
    "cart-circle-arrow-down": [640, 512, [], "e3ef", ["M133.5 80l381.5 0-24.5 127.6-.1 .5c-37.1 1.1-71.5 12.7-100.5 31.9l-227.3 0-29.1-160z", "M0 8C0-5.3 10.7-16 24-16l45.3 0c27.1 0 50.3 19.4 55.1 46l.4 2 399.9 0c25.1 0 44 22.9 39.3 47.6L538.3 212.7c-13.6-3.1-27.8-4.7-42.3-4.7-1.9 0-3.8 0-5.7 .1l.1-.5 24.5-127.6-381.5 0 29.1 160 227.3 0c-19.4 12.9-36.2 29.2-49.8 48l-168.7 0 5.1 28.3c2.1 11.4 12 19.7 23.6 19.7l114.9 0c-5.4 15.2-8.9 31.3-10.3 48l-104.6 0c-34.8 0-64.6-24.9-70.8-59.1L77.2 38.6c-.7-3.8-4-6.6-7.9-6.6L24 32C10.7 32 0 21.3 0 8zM208 416a48 48 0 1 1 0 96 48 48 0 1 1 0-96zM496 256a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm67.3 140.7c-6.2-6.2-16.4-6.2-22.6 0L512 425.4 512 336c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 89.4-28.7-28.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l56 56c6.2 6.2 16.4 6.2 22.6 0l56-56c6.2-6.2 6.2-16.4 0-22.6z"]],
    "message-medical": [512, 512, ["comment-alt-medical"], "f7f4", ["M48 128l0 224c0 26.5 21.5 48 48 48l56 0c10.4 0 19.3 6.6 22.6 15.9 .9 2.5 1.4 5.2 1.4 8.1l0 49.7c32.7-23.1 63.3-44.7 91.9-64.9 8.1-5.7 17.8-8.8 27.7-8.8L416 400c26.5 0 48-21.5 48-48l0-224c0-26.5-21.5-48-48-48L96 80c-26.5 0-48 21.5-48 48zm120 96c0-8.8 7.2-16 16-16l40 0 0-40c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 40 40 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-40 0 0 40c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-40-40 0c-8.8 0-16-7.2-16-16l0-32z", "M203.7 512.9l0 0 91.9-64.9 120.4 0c53 0 96-43 96-96l0-224c0-53-43-96-96-96L96 32C43 32 0 75 0 128L0 352c0 53 43 96 96 96l32 0 0 72c0 9 5 17.2 13 21.3s17.6 3.5 24.9-1.7l37.8-26.7zM295.6 400c-9.9 0-19.6 3.1-27.7 8.8-28.6 20.2-59.3 41.8-91.9 64.9l0-49.7c0-2.8-.5-5.6-1.4-8.1-3.3-9.3-12.2-15.9-22.6-15.9l-56 0c-26.5 0-48-21.5-48-48l0-224c0-26.5 21.5-48 48-48l320 0c26.5 0 48 21.5 48 48l0 224c0 26.5-21.5 48-48 48l-120.4 0zM224 168l0 40-40 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l40 0 0 40c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-40 40 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-40 0 0-40c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16z"]],
    "circle-arrow-down-right": [512, 512, [], "e0fa", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm119-89c9.4-9.4 24.6-9.4 33.9 0l103 103 0-54.1c0-13.3 10.7-24 24-24s24 10.7 24 24l0 112c0 13.3-10.7 24-24 24l-112 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l54.1 0-103-103c-9.4-9.4-9.4-24.6 0-33.9z", "M256 464a208 208 0 1 1 0-416 208 208 0 1 1 0 416zM256 0a256 256 0 1 0 0 512 256 256 0 1 0 0-512zm48 216l0 54.1-103-103c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l103 103-54.1 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l112 0c13.3 0 24-10.7 24-24l0-112c0-13.3-10.7-24-24-24s-24 10.7-24 24z"]],
    "volleyball": [512, 512, [127952, "volleyball-ball"], "f45f", ["M49 235.2c35.1-52 84.7-95.1 146.2-122.2-8.7-15.7-18.8-30.5-30-44.3-63.5 30.8-108.9 93-116.2 166.4zm9.2 85.2c9.1 27.9 23.8 53.2 43 74.5 26.6-60.7 70.8-114.3 130.5-152.1-1.3-30-7.2-58.9-16.8-85.9-74.7 32.8-129.2 92.9-156.7 163.6zm81.1 107.8c33.3 22.6 73.5 35.8 116.7 35.8 42.8 0 82.5-12.9 115.6-35.1-71.4 7-145.1-8.1-210-47-8.8 14.8-16.2 30.3-22.3 46.2zm50.2-85.6c75.2 43.8 163.5 50.9 242.2 24.8 9.2-14.5 16.7-30.1 22.1-46.7-65.9 7.4-134.4-4.1-197.1-36.9-25.9 16.5-48.4 36.5-67.2 58.9zM213.2 52.4c39.3 53.4 63.5 118.5 66.5 189.2 25.8 13.4 52.7 22.5 79.9 27.8 4.6-84.1-27-162.9-81.8-220.3-7.2-.7-14.4-1.1-21.8-1.1-14.7 0-29 1.5-42.8 4.4zM357.6 74.5c35.7 58.4 54.3 127.7 49.8 200.3 18.8 .5 37.6-.8 56.1-3.8 .4-5 .6-10 .6-15 0-78-42.9-145.9-106.4-181.5z", "M256 512a256 256 0 1 1 0-512 256 256 0 1 1 0 512zM161.6 381.9c-8.8 14.8-16.2 30.3-22.3 46.2 33.3 22.6 73.5 35.8 116.7 35.8 42.8 0 82.5-12.9 115.6-35.1-71.4 7-145.1-8.1-210-47zm53.3-225.1c-74.7 32.8-129.2 92.9-156.7 163.6 9.1 27.9 23.8 53.2 43 74.5 26.6-60.7 70.8-114.3 130.5-152.1-1.3-30-7.2-58.9-16.8-85.9zm41.7 126.8c-25.9 16.5-48.4 36.5-67.2 58.9 75.2 43.8 163.5 50.9 242.2 24.8 9.2-14.5 16.7-30.1 22.1-46.7-65.9 7.4-134.4-4.1-197.1-36.9zM357.6 74.5c35.7 58.4 54.3 127.7 49.8 200.3 18.8 .5 37.6-.8 56.1-3.8 .4-5 .6-10 .6-15 0-78-42.9-145.9-106.4-181.5zM256 48c-14.7 0-29 1.5-42.8 4.4 39.3 53.4 63.5 118.5 66.5 189.2 25.8 13.4 52.7 22.5 79.9 27.8 4.6-84.1-27-162.9-81.8-220.3-7.2-.7-14.4-1.1-21.8-1.1zM165.2 68.8c-63.5 30.8-108.9 93-116.2 166.4 35.1-52 84.7-95.1 146.2-122.2-8.7-15.7-18.8-30.5-30-44.3z"]],
    "arrow-turn-down-right": [512, 512, [], "e3d6", ["", "M48 88c0-13.3-10.7-24-24-24S0 74.7 0 88l0 96c0 53 43 96 96 96l334.1 0-95 95c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0L505 273c4.5-4.5 7-10.6 7-17s-2.5-12.5-7-17L369 103c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l95 95-334.1 0c-26.5 0-48-21.5-48-48l0-96z"]],
    "traffic-light": [320, 512, [128678], "f637", ["M48 32l0 352c0 61.9 50.1 112 112 112s112-50.1 112-112l0-352c0-8.8-7.2-16-16-16L64 16c-8.8 0-16 7.2-16 16zm168 80a56 56 0 1 1 -112 0 56 56 0 1 1 112 0zm0 144a56 56 0 1 1 -112 0 56 56 0 1 1 112 0zM104 400c0-30.9 25.1-56 56-56s56 25.1 56 56-25.1 56-56 56-56-25.1-56-56z", "M64 16c-8.8 0-16 7.2-16 16l0 352c0 61.9 50.1 112 112 112s112-50.1 112-112l0-352c0-8.8-7.2-16-16-16L64 16zM0 32C0-3.3 28.7-32 64-32l192 0c35.3 0 64 28.7 64 64l0 352c0 88.4-71.6 160-160 160S0 472.4 0 384L0 32zM160 344c30.9 0 56 25.1 56 56s-25.1 56-56 56-56-25.1-56-56 25.1-56 56-56zm56-88a56 56 0 1 1 -112 0 56 56 0 1 1 112 0zm-56-88a56 56 0 1 1 0-112 56 56 0 1 1 0 112z"]],
    "plane-circle-check": [640, 512, [], "e555", ["M80 330.6l128-117.3 0 102.8-128 42.7 0-28.1zM193.6 488.3L249 433c4.5-4.5 7-10.6 7-17l0-256c0-.4 0-.9 0-1.3L256 48c0-17.7 14.3-32 32-32s32 14.3 32 32l0 110c0 .7 0 1.3 .1 2-.1 54.4-.1 108.8-.1 163.1-10.3 23.5-16 49.5-16 76.9 0 25.1 4.8 49.1 13.6 71l-23.4-6.2c-4.1-1.1-8.3-1.1-12.4 0l-88.2 23.5zM368 210.9l28.5 24.9c-10.1 6.2-19.7 13.2-28.5 21.1l0-46z", "M288-32c-44.2 0-80 35.8-80 80l0 100.1-168.2 154.2c-5 4.5-7.8 11-7.8 17.7l0 72c0 7.7 3.7 15 10 19.5s14.3 5.7 21.6 3.3l144.4-48.1 0 39.4-57 57c-4.5 4.5-7 10.6-7 17l0 40c0 7.5 3.5 14.5 9.4 19s13.6 6.1 20.8 4.2l113.8-30.4 67.5 18c-16.1-17.3-29-37.5-37.9-59.8l-23.4-6.2c-4.1-1.1-8.3-1.1-12.4 0L193.6 488.3 249 433c4.5-4.5 7-10.6 7-17l0-256 0 0c0-.4 0-.9 0-1.3L256 48c0-17.7 14.3-32 32-32s32 14.3 32 32l0 110c0 .7 0 1.3 .1 2l-.1 0 0 163.1c11.1-25.4 27.6-48 48-66.3l0-46 28.5 24.9c15.1-9.1 31.5-16.3 48.9-21L368 147.1 368 48c0-44.2-35.8-80-80-80zM208 213.2l0 102.8-128 42.7 0-28.1 128-117.3zM640 400a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-86.6-60.9c7.1 5.2 8.7 15.2 3.5 22.3l-64 88c-2.8 3.8-7 6.2-11.7 6.5s-9.3-1.3-12.6-4.6l-40-40c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l26.8 26.8 53-72.9c5.2-7.1 15.2-8.7 22.4-3.5z"]],
    "square-peso": [448, 512, [], "e71a", ["M48 96l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16zm64 104c0-8.8 7.2-16 16-16l8 0 0-40c0-13.3 10.7-24 24-24l64 0c43.3 0 80.4 26.4 96 64l16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-8.3 0c.4 5.3 .4 10.7 0 16l8.3 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0c-15.7 37.6-52.8 64-96 64l-40 0 0 40c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-104-8 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l8 0 0-16-8 0c-8.8 0-16-7.2-16-16zm72-32l0 16 79.2 0c-10.1-9.9-23.9-16-39.2-16l-40 0zm0 48l0 16 95.4 0c.4-2.6 .6-5.3 .6-8s-.2-5.4-.6-8L184 216zm0 48l0 16 40 0c15.3 0 29.1-6.1 39.2-16L184 264z", "M64 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm136 48c0-13.3 10.7-24 24-24l64 0c43.3 0 80.4 26.4 96 64l16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-8.3 0c.4 5.3 .4 10.7 0 16l8.3 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0c-15.7 37.6-52.8 64-96 64l-40 0 0 40c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-104-8 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l8 0 0-16-8 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l8 0 0-40zm88 24l-40 0 0 16 79.2 0c-10.1-9.9-23.9-16-39.2-16zm-40 64l95.4 0c.4-2.6 .6-5.3 .6-8s-.2-5.4-.6-8l-95.4 0 0 16zm0 32l0 16 40 0c15.3 0 29.1-6.1 39.2-16L184 264z"]],
    "house-water": [640, 512, ["house-flood"], "f74f", ["M176 212l144-138.7 144 138.7 0 141c-6-.7-12-1-18-.9-32.5 .2-64.9 10.7-92.4 31.4-22.1 16.6-29.1 16.6-51.2 0-28.1-21.1-61.3-31.6-94.4-31.4-10.7 .1-21.5 1.3-32 3.6L176 212zm96 36l0 48c0 13.3 10.7 24 24 24l48 0c13.3 0 24-10.7 24-24l0-48c0-13.3-10.7-24-24-24l-48 0c-13.3 0-24 10.7-24 24z", "M303.4 22.7c9.3-8.9 24-8.9 33.3 0l216 208c9.5 9.2 9.8 24.4 .6 33.9s-24.4 9.8-33.9 .6l-7.4-7.1 0 108.2c-15.4-7.1-31.6-11.6-48-13.4l0-141-144-138.7-144 138.7 0 143.6c-16.7 3.7-32.9 10.1-48 19.4l0-116.8-7.4 7.1c-9.5 9.2-24.7 8.9-33.9-.6s-8.9-24.7 .6-33.9l216-208zM296 224l48 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-48c0-13.3 10.7-24 24-24zM403.4 476.1C379.1 494.3 351.1 512 320 512s-59.1-17.7-83.4-35.9c-21.3-16.1-49.9-16.1-71.2 0-23.8 17.9-54.1 35.5-88.1 35.3-20.4-.1-40.7-6.7-59.8-21.1-10.6-8-12.7-23-4.7-33.6s23-12.7 33.6-4.7c11.3 8.5 21.6 11.4 31.2 11.5 17.6 .1 37.3-9.4 58.9-25.7 38.4-29 90.5-29 129 0 24 18.1 40.7 26.3 54.5 26.3s30.5-8.2 54.5-26.3c38.4-29 90.5-29 129 0 16.9 12.7 32.9 21.5 47.8 24.6 13.7 2.8 27.4 .9 42.3-10.3 10.6-8 25.6-5.9 33.6 4.7s5.9 25.6-4.7 33.6c-26.4 19.9-54.2 24.4-80.7 19.1-25.3-5.1-48.1-18.9-67.2-33.3-21.3-16.1-49.9-16.1-71.2 0z"]],
    "users": [640, 512, [], "f0c0", ["M168 480c13.3 0 24-10.7 24-24l0-16c0-57.4 46.6-104 104-104l48 0c57.4 0 104 46.6 104 104l0 16c0 13.3 10.7 24 24 24l-304 0zM384 128a64 64 0 1 1 -128 0 64 64 0 1 1 128 0z", "M320 192a64 64 0 1 0 0-128 64 64 0 1 0 0 128zm0-176a112 112 0 1 1 0 224 112 112 0 1 1 0-224zM296 336c-57.4 0-104 46.6-104 104l0 16c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-16c0-83.9 68.1-152 152-152l48 0c83.9 0 152 68.1 152 152l0 16c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-16c0-57.4-46.6-104-104-104l-48 0zm135.4-93.2c11.7-11.3 21.6-24.4 29.4-38.8 5.9 2.6 12.4 4 19.2 4 26.5 0 48-21.5 48-48s-21.5-48-48-48l-.8 0c-1.6-16.6-5.8-32.4-12.1-47.1 4.2-.6 8.6-.9 12.9-.9 53 0 96 43 96 96s-43 96-96 96c-17.7 0-34.3-4.8-48.6-13.2zM160 64c4.4 0 8.7 .3 12.9 .9-6.3 14.7-10.5 30.6-12.1 47.1l-.8 0c-26.5 0-48 21.5-48 48s21.5 48 48 48c6.8 0 13.3-1.4 19.2-4 7.8 14.4 17.7 27.5 29.4 38.8-14.2 8.4-30.8 13.2-48.6 13.2-53 0-96-43-96-96s43-96 96-96zM149.3 304c-15.1 16.3-27.5 35-36.5 55.6-38 15.5-64.8 52.8-64.8 96.4 0 13.3-10.7 24-24 24S0 469.3 0 456c0-83.1 66.6-150.6 149.3-152zm377.9 55.6c-9-20.6-21.5-39.4-36.5-55.6 82.7 1.4 149.3 68.9 149.3 152 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-43.6-26.8-80.9-64.8-96.4z"]],
    "certificate": [576, 512, [], "f0a3", ["M88.5 202.5l37.3 36.3c4.6 4.5 7.3 10.7 7.3 17.2s-2.6 12.7-7.3 17.2L88.5 309.5 139 322.3c6.3 1.6 11.6 5.7 14.9 11.3s4.1 12.3 2.3 18.5l-14.2 50.1 50.1-14.2c6.2-1.8 12.9-.9 18.5 2.3s9.7 8.6 11.3 14.9l12.8 50.5 36.3-37.3c4.5-4.6 10.7-7.3 17.2-7.3s12.7 2.6 17.2 7.3l36.3 37.3 12.8-50.5c1.6-6.3 5.7-11.7 11.3-14.9s12.3-4.1 18.5-2.3l50.1 14.2-14.2-50.1c-1.8-6.2-.9-12.9 2.3-18.5s8.6-9.7 14.9-11.3l50.5-12.8-37.3-36.3c-4.6-4.5-7.3-10.7-7.3-17.2s2.6-12.7 7.3-17.2l37.3-36.3-50.5-12.8c-6.3-1.6-11.6-5.7-14.9-11.3s-4.1-12.3-2.3-18.5l14.2-50.1-50.1 14.2c-6.2 1.8-12.9 .9-18.5-2.3s-9.7-8.6-11.3-14.9l-12.8-50.5-36.3 37.3c-4.5 4.6-10.7 7.3-17.2 7.3s-12.7-2.6-17.2-7.3l-36.3-37.3-12.8 50.5c-1.6 6.3-5.7 11.6-11.3 14.9s-12.3 4.1-18.5 2.3l-50.1-14.2 14.2 50.1c1.8 6.2 .9 12.9-2.3 18.5s-8.6 9.7-14.9 11.3L88.5 202.5z", "M215.8-14.5c8.4-2.2 17.3 .2 23.4 6.4L288.3 42.4 337.3-8c6.1-6.2 15-8.7 23.4-6.4s14.9 8.9 17.1 17.3L395.1 71 462.8 51.9c8.4-2.4 17.4 0 23.5 6.1s8.5 15.1 6.1 23.5l-19.1 67.7 68.2 17.3c8.4 2.1 15 8.7 17.3 17.1s-.2 17.3-6.4 23.4l-50.4 49.1 50.4 49.1c6.2 6.1 8.7 15 6.4 23.4s-8.9 14.9-17.3 17.1l-68.2 17.3 19.1 67.7c2.4 8.4 0 17.4-6.1 23.5s-15.1 8.5-23.5 6.1l-67.7-19.1-17.3 68.2c-2.1 8.4-8.7 15-17.1 17.3s-17.3-.2-23.4-6.4l-49.1-50.4-49.1 50.4c-6.1 6.2-15 8.7-23.4 6.4s-14.9-8.9-17.1-17.3l-17.3-68.2-67.7 19.1c-8.4 2.4-17.4 0-23.5-6.1s-8.5-15.1-6.1-23.5l19.1-67.7-68.2-17.3c-8.4-2.1-15-8.7-17.3-17.1s.2-17.4 6.4-23.4L74.7 256 24.3 206.9c-6.2-6.1-8.7-15-6.4-23.4s8.9-14.9 17.3-17.1l68.2-17.3-19.1-67.7c-2.4-8.4 0-17.4 6.1-23.5s15.1-8.5 23.5-6.1L181.5 71 198.8 2.8c2.1-8.4 8.7-15 17.1-17.3zm18.9 70.7l-12.8 50.5c-1.6 6.3-5.7 11.6-11.3 14.9s-12.3 4.1-18.5 2.3l-50.1-14.2 14.2 50.1c1.8 6.2 .9 12.9-2.3 18.5s-8.6 9.7-14.9 11.3l-50.5 12.8 37.3 36.3c4.6 4.5 7.3 10.7 7.3 17.2s-2.6 12.7-7.3 17.2L88.5 309.5 139 322.3c6.3 1.6 11.6 5.7 14.9 11.3s4.1 12.3 2.3 18.5l-14.2 50.1 50.1-14.2c6.2-1.8 12.9-.9 18.5 2.3s9.7 8.6 11.3 14.9l12.8 50.5 36.3-37.3c4.5-4.6 10.7-7.3 17.2-7.3s12.7 2.6 17.2 7.3l36.3 37.3 12.8-50.5c1.6-6.3 5.7-11.7 11.3-14.9s12.3-4.1 18.5-2.3l50.1 14.2-14.2-50.1c-1.8-6.2-.9-12.9 2.3-18.5s8.6-9.7 14.9-11.3l50.5-12.8-37.3-36.3c-4.6-4.5-7.3-10.7-7.3-17.2s2.6-12.7 7.3-17.2l37.3-36.3-50.5-12.8c-6.3-1.6-11.6-5.7-14.9-11.3s-4.1-12.3-2.3-18.5l14.2-50.1-50.1 14.2c-6.2 1.8-12.9 .9-18.5-2.3s-9.7-8.6-11.3-14.9l-12.8-50.5-36.3 37.3c-4.5 4.6-10.7 7.3-17.2 7.3s-12.7-2.6-17.2-7.3L234.7 56.2z"]],
    "alarm-clock": [512, 512, [9200], "f34e", ["M80 288a176 176 0 1 0 352 0 176 176 0 1 0 -352 0zM232 184c0-13.3 10.7-24 24-24s24 10.7 24 24l0 94.1 41 41c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-48-48c-4.5-4.5-7-10.6-7-17l0-104z", "M402.6 50.2c-5.4 1.7-11.3 1.8-16.2-.9-5.8-3.2-11.8-6.2-17.8-8.9-10.4-4.7-13.7-18.3-4.1-24.6 15-9.9 33-15.7 52.3-15.7 52.6 0 95.2 42.6 95.2 95.2 0 13.2-2.7 25.8-7.6 37.3-4.5 10.5-18.4 9.8-24.9 .4-3.8-5.5-7.8-10.8-12-16-3.5-4.4-4.5-10.2-3.8-15.8 .2-1.9 .4-3.9 .4-5.9 0-26.1-21.2-47.2-47.2-47.2-4.9 0-9.7 .8-14.2 2.2zM32.5 132.9c-6.5 9.4-20.5 10.1-24.9-.4-4.9-11.5-7.6-24.1-7.6-37.3 0-52.6 42.6-95.2 95.2-95.2 19.3 0 37.3 5.8 52.3 15.7 9.6 6.3 6.3 19.9-4.1 24.6-6.1 2.8-12 5.7-17.8 8.9-4.9 2.7-10.9 2.6-16.2 .9-4.5-1.4-9.2-2.2-14.2-2.2-26.1 0-47.2 21.2-47.2 47.2 0 2 .1 4 .4 5.9 .7 5.6-.3 11.4-3.8 15.8-4.2 5.2-8.2 10.5-12 16zM432 288a176 176 0 1 0 -352 0 176 176 0 1 0 352 0zM396.5 462.5C358.1 493.4 309.2 512 256 512s-102.1-18.6-140.5-49.5L73 505c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l42.5-42.5C50.6 390.1 32 341.2 32 288 32 164.3 132.3 64 256 64S480 164.3 480 288c0 53.2-18.6 102.1-49.5 140.5L473 471c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-42.5-42.5zM280 184l0 94.1 41 41c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-48-48c-4.5-4.5-7-10.6-7-17l0-104c0-13.3 10.7-24 24-24s24 10.7 24 24z"]],
    "helicopter-symbol": [512, 512, [], "e502", ["M0 256c0-10.8 .7-21.5 2-32l48.5 0C64.2 134.7 134.7 64.2 224 50.4L224 2c10.5-1.3 21.2-2 32-2s21.5 .7 32 2l0 48.5C377.3 64.2 447.8 134.7 461.6 224l48.5 0c1.3 10.5 2 21.2 2 32s-.7 21.5-2 32l-48.5 0C447.8 377.3 377.3 447.8 288 461.6l0 48.5c-10.5 1.3-21.2 2-32 2s-21.5-.7-32-2l0-48.5C134.7 447.8 64.2 377.3 50.4 288L2 288c-1.3-10.5-2-21.2-2-32zm144-96l0 192c0 13.3 10.7 24 24 24s24-10.7 24-24l0-72 128 0 0 72c0 13.3 10.7 24 24 24s24-10.7 24-24l0-192c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 72-128 0 0-72c0-13.3-10.7-24-24-24s-24 10.7-24 24z", "M461.6 224l48.5 0C495.6 108.2 403.8 16.4 288 2l0 48.5C377.3 64.2 447.8 134.7 461.6 224zM510 288l-48.5 0C447.8 377.3 377.3 447.8 288 461.6l0 48.5c115.8-14.4 207.6-106.2 222-222zM2 288C16.4 403.8 108.2 495.6 224 510l0-48.5C134.7 447.8 64.2 377.3 50.4 288L2 288zm0-64l48.5 0C64.2 134.7 134.7 64.2 224 50.4L224 2C108.2 16.4 16.4 108.2 2 224zm190-64c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 192c0 13.3 10.7 24 24 24s24-10.7 24-24l0-72 128 0 0 72c0 13.3 10.7 24 24 24s24-10.7 24-24l0-192c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 72-128 0 0-72z"]],
    "house-chimney-crack": [512, 512, ["house-damage"], "f6f1", ["M96 199.7L96 448c0 8.8 7.2 16 16 16l85.9 0-30.3-48.1c-4.4-6.9-2.8-16 3.6-21.1l84.8-67.3-58.1-76.1c-11.3-14.8 7.4-33.6 22.3-22.5l115.2 86.2c8.4 6.3 8.6 18.8 .4 25.3L256 403.8 293.9 464 400 464c8.8 0 16-7.2 16-16L416 199.7 256 56.2 96 199.7z", "M272 6.1c-9.1-8.2-22.9-8.2-32 0L8 214.1c-9.9 8.8-10.7 24-1.8 33.9s24 10.7 33.9 1.8l8-7.2 0 205.3c0 35.3 28.7 64 64 64l288 0c35.3 0 64-28.7 64-64l0-205.3 8 7.2c9.9 8.8 25 8 33.9-1.8s8-25-1.8-33.9l-40-35.9 0-90.2c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 47.2-144-129.1zM416 199.7L416 448c0 8.8-7.2 16-16 16l-106.1 0-37.9-60.2 79.7-63.3c8.2-6.5 8-19.1-.4-25.3L220.2 229c-14.9-11.1-33.6 7.8-22.3 22.5l58.1 76.1-84.8 67.3c-6.4 5.1-7.9 14.2-3.6 21.1l30.3 48.1-85.9 0c-8.8 0-16-7.2-16-16L96 199.7 256 56.2 416 199.7z"]],
    "dryer-heat": [448, 512, ["dryer-alt"], "f862", ["M48 64l0 384c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-384c0-8.8-7.2-16-16-16L64 48c-8.8 0-16 7.2-16 16zm80 40a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zM368 288a144 144 0 1 1 -288 0 144 144 0 1 1 288 0zM208 104a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M64 48c-8.8 0-16 7.2-16 16l0 384c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-384c0-8.8-7.2-16-16-16L64 48zM0 64C0 28.7 28.7 0 64 0L384 0c35.3 0 64 28.7 64 64l0 384c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zM104 80a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm56 24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM80 288a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm107.3-83.3c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6L177.4 240c4.2 4.2 6.6 10 6.6 16s-2.4 11.8-6.6 16l-9.4 9.4c-10.2 10.2-16 24.1-16 38.6s5.8 28.4 16 38.6l12.7 12.7c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L190.6 336c-4.2-4.2-6.6-10-6.6-16s2.4-11.8 6.6-16l9.4-9.4c10.2-10.2 16-24.1 16-38.6s-5.8-28.4-16-38.6l-12.7-12.7zm80 0c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6L257.4 240c4.2 4.2 6.6 10 6.6 16s-2.4 11.8-6.6 16l-9.4 9.4c-10.2 10.2-16 24.1-16 38.6s5.8 28.4 16 38.6l12.7 12.7c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L270.6 336c-4.2-4.2-6.6-10-6.6-16s2.4-11.8 6.6-16l9.4-9.4c10.2-10.2 16-24.1 16-38.6s-5.8-28.4-16-38.6l-12.7-12.7z"]],
    "bring-forward": [512, 512, [], "f856", ["M208 400l0 48c0 8.8 7.2 16 16 16l224 0c8.8 0 16-7.2 16-16l0-224c0-8.8-7.2-16-16-16l-48 0 0 80c0 61.9-50.1 112-112 112l-80 0z", "M224 464l224 0c8.8 0 16-7.2 16-16l0-224c0-8.8-7.2-16-16-16l-48 0 0-48 48 0c35.3 0 64 28.7 64 64l0 224c0 35.3-28.7 64-64 64l-224 0c-35.3 0-64-28.7-64-64l0-48 48 0 0 48c0 8.8 7.2 16 16 16zm64-112L64 352c-35.3 0-64-28.7-64-64L0 64C0 28.7 28.7 0 64 0L288 0c35.3 0 64 28.7 64 64l0 224c0 35.3-28.7 64-64 64z"]],
    "dial-low": [576, 512, [], "e15d", ["M178.6 264L288 264c13.3 0 24 10.7 24 24s-10.7 24-24 24l-109.4 0c11 50.3 55.8 88 109.4 88 61.9 0 112-50.1 112-112S349.9 176 288 176c-53.6 0-98.4 37.7-109.4 88z", "M288 64a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm0 336c-53.6 0-98.4-37.7-109.4-88L288 312c13.3 0 24-10.7 24-24s-10.7-24-24-24l-109.4 0c11-50.3 55.8-88 109.4-88 61.9 0 112 50.1 112 112S349.9 400 288 400zM128 288a160 160 0 1 0 320 0 160 160 0 1 0 -320 0zm448 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM32 320a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM128 96a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm352 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM128 480a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm352 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]],
    "circle-wifi-circle-wifi": [640, 512, ["circle-wifi-group"], "e67e", ["M80 256c0-114.9 93.1-208 208-208 98.4 0 180.8 68.3 202.5 160.1-12.5 .4-24.7 1.9-36.5 4.5-1.3-2.6-3.1-4.9-5.4-7-42.5-38.3-98.9-61.6-160.6-61.6s-118.1 23.3-160.6 61.6c-9.8 8.9-10.6 24-1.8 33.9s24 10.6 33.9 1.8c34-30.7 79-49.3 128.5-49.3 43.8 0 84.1 14.6 116.3 39.3-15.4 8.4-29.5 18.8-42 30.9-21.4-14-46.9-22.1-74.4-22.1-35.1 0-67.1 13.3-91.2 35.1-9.8 8.9-10.6 24.1-1.7 33.9s24.1 10.6 33.9 1.7c15.6-14.1 36.3-22.7 59-22.7 16.1 0 31.2 4.3 44.1 11.9-8.8 14.4-15.8 30-20.6 46.5-5.9-6.4-14.3-10.4-23.6-10.4-17.7 0-32 14.3-32 32s14.3 32 32 32c5.8 0 11.3-1.6 16-4.3 0 1.4 0 2.9 0 4.3 0 21.8 3.6 42.8 10.3 62.3-8.6 1.1-17.4 1.7-26.3 1.7-114.9 0-208-93.1-208-208z", "M288 48c98.4 0 180.8 68.3 202.5 160.1 1.8-.1 3.7-.1 5.5-.1 15.3 0 30.2 1.8 44.4 5.2-20.4-121-125.6-213.2-252.4-213.2-141.4 0-256 114.6-256 256S146.6 512 288 512c16.7 0 33-1.6 48.8-4.6-9.3-13.8-16.9-28.9-22.4-45-8.6 1.1-17.4 1.7-26.3 1.7-114.9 0-208-93.1-208-208S173.1 48 288 48zM448.6 205.6C406.1 167.3 349.7 144 288 144s-118.1 23.3-160.6 61.6c-9.8 8.9-10.6 24-1.8 33.9s24 10.6 33.9 1.8c34-30.7 79-49.3 128.5-49.3 43.8 0 84.1 14.6 116.3 39.3 15.4-8.4 32-14.7 49.6-18.6-1.3-2.6-3.1-4.9-5.4-7zM288 240c-35.1 0-67.1 13.3-91.2 35.1-9.8 8.9-10.6 24.1-1.7 33.9s24.1 10.6 33.9 1.7c15.6-14.1 36.3-22.7 59-22.7 16.1 0 31.2 4.3 44.1 11.9 8.5-13.8 18.6-26.5 30.2-37.7-21.4-14-46.9-22.1-74.4-22.1zm0 96c-17.7 0-32 14.3-32 32s14.3 32 32 32c5.8 0 11.3-1.6 16-4.3 .4-17.1 3-33.6 7.5-49.3-5.8-6.4-14.3-10.4-23.6-10.4zm352 64a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zM496 352c-27.2 0-51.9 10.2-70.6 27.1-6.6 5.9-16.7 5.4-22.6-1.2s-5.4-16.7 1.2-22.6c24.4-21.9 56.6-35.3 92-35.3s67.7 13.4 92 35.3c6.6 5.9 7.1 16 1.2 22.6s-16 7.1-22.6 1.2C547.9 362.2 523.2 352 496 352zM476 464a20 20 0 1 1 40 0 20 20 0 1 1 -40 0zm-11.5-35.9c-6.6 5.9-16.7 5.4-22.6-1.1s-5.4-16.7 1.1-22.6c14-12.7 32.6-20.4 53-20.4s39 7.7 53 20.4c6.6 5.9 7.1 16 1.1 22.6s-16 7.1-22.6 1.1c-8.3-7.5-19.4-12.1-31.5-12.1s-23.2 4.6-31.5 12.1z"]],
    "display-medical": [512, 512, ["desktop-medical"], "e166", ["M48 96l0 256c0 8.8 7.2 16 16 16l384 0c8.8 0 16-7.2 16-16l0-256c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16zM168 208c0-8.8 7.2-16 16-16l40 0 0-40c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 40 40 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-40 0 0 40c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-40-40 0c-8.8 0-16-7.2-16-16l0-32zm52.3 256l71.3 0-8-48-55.3 0-8 48z", "M448 80c8.8 0 16 7.2 16 16l0 256c0 8.8-7.2 16-16 16L64 368c-8.8 0-16-7.2-16-16L48 96c0-8.8 7.2-16 16-16l384 0zM64 32C28.7 32 0 60.7 0 96L0 352c0 35.3 28.7 64 64 64l115.7 0-8 48-51.7 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l272 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-51.7 0-8-48 115.7 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L64 32zM220.3 464l8-48 55.3 0 8 48-71.3 0zM224 152l0 40-40 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l40 0 0 40c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-40 40 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-40 0 0-40c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16z"]],
    "person-military-pointing": [512, 512, [], "e54a", ["M240 272l72 0c.5 0 1 0 1.4 0L240 354.1 240 272zm0 160l96 0 0 32-96 0 0-32zm16-320c0-5.8 1.6-11.3 4.3-16l55.4 0c2.7 4.7 4.3 10.2 4.3 16 0 17.7-14.3 32-32 32s-32-14.3-32-32zm21.7 272l58.3-65.2 0 65.2-58.3 0z", "M192 39c0-13 10-23.8 22.9-24.9L366.7 1.4C376 .7 384 8 384 17.4L384 48c0 8.8-7.2 16-16 16L217 64c-13.8 0-25-11.2-25-25zM0 248c0-13.3 10.7-24 24-24l288.6 0c42.9 0 82.5 22.9 103.9 60l92.3 160c6.6 11.5 2.7 26.2-8.8 32.8s-26.2 2.7-32.8-8.8L384 323.8 384 480c0 17.7-14.3 32-32 32l-128 0c-17.7 0-32-14.3-32-32l0-208-168 0c-13.3 0-24-10.7-24-24zm240 24l0 82.1 73.4-82.1c-.5 0-1 0-1.4 0l-72 0zm0 192l96 0 0-32-96 0 0 32zm96-145.2l-58.3 65.2 58.3 0 0-65.2zM208 112c0-5.5 .6-10.8 1.6-16l50.7 0c-2.7 4.7-4.3 10.2-4.3 16 0 17.7 14.3 32 32 32s32-14.3 32-32c0-5.8-1.6-11.3-4.3-16l50.7 0c1 5.2 1.6 10.5 1.6 16 0 44.2-35.8 80-80 80s-80-35.8-80-80z"]],
    "database": [448, 512, [], "f1c0", ["M48 86l0 88.7c13.3 7.2 31.6 14.2 54.8 19.9 34 8.4 75.7 13.4 121.2 13.4s87.3-5 121.2-13.4c23.1-5.7 41.5-12.7 54.8-19.9l0-88.7-.6-.5C394.1 81 383.5 74.8 366.2 68.6 332.1 56.5 281.8 48 224 48S115.9 56.5 81.8 68.6C64.5 74.8 53.9 81 48.6 85.5L48 86zm0 141.5l0 75.2c13.3 7.2 31.6 14.2 54.8 19.9 34 8.4 75.7 13.4 121.2 13.4s87.3-5 121.2-13.4c23.1-5.7 41.5-12.7 54.8-19.9l0-75.2c-13.3 5.3-27.9 9.9-43.3 13.7-38.2 9.4-83.9 14.8-132.7 14.8s-94.5-5.4-132.7-14.8c-15.4-3.8-30-8.3-43.3-13.7zm0 128l0 70.4 .6 .5c5.3 4.5 15.9 10.7 33.2 16.9 34.1 12.2 84.4 20.6 142.2 20.6s108.1-8.5 142.2-20.6c17.3-6.2 27.8-12.4 33.2-16.9l.6-.5 0-70.4c-13.3 5.3-27.9 9.9-43.3 13.7-38.2 9.4-83.9 14.8-132.7 14.8s-94.5-5.4-132.7-14.8c-15.4-3.8-30-8.3-43.3-13.7z", "M400 86l0 88.7c-13.3 7.2-31.6 14.2-54.8 19.9-34 8.4-75.7 13.4-121.2 13.4s-87.3-5-121.2-13.4C79.6 188.9 61.3 182 48 174.7l0-88.7 .6-.5C53.9 81 64.5 74.8 81.8 68.6 115.9 56.5 166.2 48 224 48s108.1 8.5 142.2 20.6c17.3 6.2 27.8 12.4 33.2 16.9l.6 .5zM400 426l-.6 .5c-5.3 4.5-15.9 10.7-33.2 16.9-34.1 12.2-84.4 20.6-142.2 20.6s-108.1-8.5-142.2-20.6c-17.3-6.2-27.8-12.4-33.2-16.9l-.6-.5 0-70.4c13.3 5.3 27.9 9.9 43.3 13.7 38.2 9.4 83.9 14.8 132.7 14.8s94.5-5.4 132.7-14.8c15.4-3.8 30-8.3 43.3-13.7l0 70.4zm0-123.3c-13.3 7.2-31.6 14.2-54.8 19.9-34 8.4-75.7 13.4-121.2 13.4s-87.3-5-121.2-13.4C79.6 316.9 61.3 310 48 302.7l0-75.2c13.3 5.3 27.9 9.9 43.3 13.7 38.2 9.4 83.9 14.8 132.7 14.8s94.5-5.4 132.7-14.8c15.4-3.8 30-8.3 43.3-13.7l0 75.2zM448 432l0-352C448 35.8 347.7 0 224 0S0 35.8 0 80L0 432c0 44.2 100.3 80 224 80s224-35.8 224-80z"]],
    "newspaper": [512, 512, [128240], "f1ea", ["M139.9 432L440 432c13.3 0 24-10.7 24-24l0-304c0-13.3-10.7-24-24-24L168 80c-13.3 0-24 10.7-24 24l0 304c0 8.4-1.4 16.5-4.1 24zM192 152c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-48zm0 128c0-13.3 10.7-24 24-24l176 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-176 0c-13.3 0-24-10.7-24-24zm0 80c0-13.3 10.7-24 24-24l176 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-176 0c-13.3 0-24-10.7-24-24zM320 200c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24z", "M168 80c-13.3 0-24 10.7-24 24l0 304c0 8.4-1.4 16.5-4.1 24L440 432c13.3 0 24-10.7 24-24l0-304c0-13.3-10.7-24-24-24L168 80zM72 480c-39.8 0-72-32.2-72-72L0 112C0 98.7 10.7 88 24 88s24 10.7 24 24l0 296c0 13.3 10.7 24 24 24s24-10.7 24-24l0-304c0-39.8 32.2-72 72-72l272 0c39.8 0 72 32.2 72 72l0 304c0 39.8-32.2 72-72 72L72 480zM192 152c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-48zm152 24l48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zM216 256l176 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-176 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zm0 80l176 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-176 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"]],
    "cloud-rain": [512, 512, [127783, 9926], "f73d", ["M48 216c0 30.9 25.1 56 56 56l304 0c30.9 0 56-25.1 56-56s-25.1-56-56-56c-13.3 0-24-10.7-24-24 0-30.9-25.1-56-56-56-15.6 0-29.6 6.3-39.8 16.6-5.5 5.6-13.4 8.1-21.2 6.8s-14.3-6.4-17.6-13.6c-11.4-24.7-36.4-41.8-65.4-41.8-39.8 0-72 32.2-72 72 0 4.5 .4 8.8 1.2 13 2.4 13-6.3 25.5-19.3 27.9-26.1 4.8-45.9 27.6-45.9 55.1z", "M112 120c0-39.8 32.2-72 72-72 28.9 0 53.9 17.1 65.4 41.8 3.3 7.1 9.9 12.2 17.6 13.6s15.7-1.2 21.2-6.8c10.2-10.3 24.2-16.6 39.8-16.6 30.9 0 56 25.1 56 56 0 13.3 10.7 24 24 24 30.9 0 56 25.1 56 56s-25.1 56-56 56l-304 0c-30.9 0-56-25.1-56-56 0-27.4 19.8-50.3 45.9-55.1 13-2.4 21.7-14.9 19.3-27.9-.8-4.2-1.2-8.5-1.2-13zM184 0C117.7 0 64 53.7 64 120 26.4 135.7 0 172.7 0 216 0 273.4 46.6 320 104 320l304 0c57.4 0 104-46.6 104-104 0-50-35.3-91.7-82.3-101.7-10-47-51.7-82.3-101.7-82.3-18.3 0-35.4 4.7-50.3 13-22-27.4-55.7-45-93.7-45zM97.6 388.2L67.4 456.3c-2.2 5.1-3.4 10.5-3.4 16 0 21.9 18.1 39.6 40 39.6s40-17.7 40-39.6c0-5.5-1.2-11-3.4-16l-30.2-68.2c-1.1-2.5-3.6-4.2-6.4-4.2s-5.3 1.6-6.4 4.2zm152 0l-30.2 68.2c-2.2 5.1-3.4 10.5-3.4 16 0 21.9 18.1 39.6 40 39.6s40-17.7 40-39.6c0-5.5-1.2-11-3.4-16l-30.2-68.2c-1.1-2.5-3.6-4.2-6.4-4.2s-5.3 1.6-6.4 4.2zm121.8 68.2c-2.2 5.1-3.4 10.5-3.4 16 0 21.9 18.1 39.6 40 39.6s40-17.7 40-39.6c0-5.5-1.2-11-3.4-16l-30.2-68.2c-1.1-2.5-3.6-4.2-6.4-4.2s-5.3 1.6-6.4 4.2l-30.2 68.2z"]],
    "signal-strong": [512, 512, ["signal-4"], "f68f", ["", "M384 152c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 304c0 13.3 10.7 24 24 24s24-10.7 24-24l0-304zM256 224c-13.3 0-24 10.7-24 24l0 208c0 13.3 10.7 24 24 24s24-10.7 24-24l0-208c0-13.3-10.7-24-24-24zM176 344c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 112c0 13.3 10.7 24 24 24s24-10.7 24-24l0-112zM72 408c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 48c0 13.3 10.7 24 24 24s24-10.7 24-24l0-48z"]],
    "maximize": [448, 512, ["expand-arrows-alt"], "f31e", ["M48 80L124.1 80 48 156.1 48 80zm0 275.9l76.1 76.1-76.1 0 0-76.1zM323.9 80l76.1 0 0 76.1-76.1-76.1zm0 352l76.1-76.1 0 76.1-76.1 0z", "M124.1 80L48 80 48 156.1 124.1 80zM0 192L0 64C0 46.3 14.3 32 32 32l128 0c17.7 0 32 14.3 32 32l0 2.7c0 8.5-3.4 16.6-9.4 22.6l-45.7 45.7 87 87 87-87-45.7-45.7c-6-6-9.4-14.1-9.4-22.6l0-2.7c0-17.7 14.3-32 32-32l128 0c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32l-2.7 0c-8.5 0-16.6-3.4-22.6-9.4l-45.7-45.7-87 87 87 87 45.7-45.7c6-6 14.1-9.4 22.6-9.4l2.7 0c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32l-128 0c-17.7 0-32-14.3-32-32l0-2.7c0-8.5 3.4-16.6 9.4-22.6l45.7-45.7-87-87-87 87 45.7 45.7c6 6 9.4 14.1 9.4 22.6l0 2.7c0 17.7-14.3 32-32 32L32 480c-17.7 0-32-14.3-32-32L0 320c0-17.7 14.3-32 32-32l2.7 0c8.5 0 16.6 3.4 22.6 9.4l45.7 45.7 87-87-87-87-45.7 45.7c-6 6-14.1 9.4-22.6 9.4L32 224c-17.7 0-32-14.3-32-32zM323.9 432l76.1 0 0-76.1-76.1 76.1zM48 355.9l0 76.1 76.1 0-76.1-76.1zM323.9 80l76.1 76.1 0-76.1-76.1 0z"]],
    "location-arrow": [512, 512, [], "f124", ["M79.4 222.9l134.5 44.8c14.3 4.8 25.6 16 30.4 30.4L289.1 432.6 420.1 91.9 79.4 222.9z", "M213.9 267.8c14.3 4.8 25.6 16 30.4 30.4L289.1 432.6 420.1 91.9 79.4 222.9 213.9 267.8zM470.6 41.4c8.9 8.9 11.8 22.3 7.2 34.1l-160 416c-4.8 12.6-17.1 20.8-30.6 20.5s-25.4-9.1-29.6-21.9L198.7 313.3 21.9 254.4C9.1 250.1 .3 238.2 0 224.7S7.9 199 20.5 194.1l416-160c11.8-4.5 25.2-1.7 34.1 7.2z"]],
    "city": [576, 512, [127961], "f64f", ["M48 160l0 288c0 8.8 7.2 16 16 16l146 0c-1.3-5.1-2-10.5-2-16l0-304-144 0c-8.8 0-16 7.2-16 16zm48 48c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm0 96c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM256 64l0 384c0 8.8 7.2 16 16 16l240 0c8.8 0 16-7.2 16-16l0-192c0-8.8-7.2-16-16-16l-72 0c-13.3 0-24-10.7-24-24l0-152c0-8.8-7.2-16-16-16L272 48c-8.8 0-16 7.2-16 16zm48 48c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm0 96c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm0 96c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm112 0c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32z", "M272 48l128 0c8.8 0 16 7.2 16 16l0 152c0 13.3 10.7 24 24 24l72 0c8.8 0 16 7.2 16 16l0 192c0 8.8-7.2 16-16 16l-240 0c-8.8 0-16-7.2-16-16l0-384c0-8.8 7.2-16 16-16zM208 448c0 5.5 .7 10.9 2 16L64 464c-8.8 0-16-7.2-16-16l0-288c0-8.8 7.2-16 16-16l144 0 0 304zm0-384l0 32-32 0 0-72c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 72-32 0 0-72C96 10.7 85.3 0 72 0S48 10.7 48 24l0 74c-27.6 7.1-48 32.2-48 62L0 448c0 35.3 28.7 64 64 64l448 0c35.3 0 64-28.7 64-64l0-192c0-35.3-28.7-64-64-64l-48 0 0-128c0-35.3-28.7-64-64-64L272 0c-35.3 0-64 28.7-64 64zm96 48l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zM432 288c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0zM304 208l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zM112 192c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0zM304 304l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zM112 288c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0z"]],
    "rectangle-code": [512, 512, [], "e322", ["M48 128l0 256c0 8.8 7.2 16 16 16l384 0c8.8 0 16-7.2 16-16l0-256c0-8.8-7.2-16-16-16L64 112c-8.8 0-16 7.2-16 16zm79 111l64-64c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-47 47 47 47c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-64-64c-9.4-9.4-9.4-24.6 0-33.9zm160-64c9.4-9.4 24.6-9.4 33.9 0l64 64c9.4 9.4 9.4 24.6 0 33.9l-64 64c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l47-47-47-47c-9.4-9.4-9.4-24.6 0-33.9z", "M448 112c8.8 0 16 7.2 16 16l0 256c0 8.8-7.2 16-16 16L64 400c-8.8 0-16-7.2-16-16l0-256c0-8.8 7.2-16 16-16l384 0zM64 64C28.7 64 0 92.7 0 128L0 384c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L64 64zM287 175c-9.4 9.4-9.4 24.6 0 33.9l47 47-47 47c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l64-64c9.4-9.4 9.4-24.6 0-33.9l-64-64c-9.4-9.4-24.6-9.4-33.9 0zM225 209c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-64 64c-9.4 9.4-9.4 24.6 0 33.9l64 64c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-47-47 47-47z"]],
    "toilet-paper-check": [512, 512, [], "e5b2", ["M48 224l0 248c0 13.3 10.7 24 24 24l192 0c13.3 0 24-10.7 24-24l0-248c0-49.5 10.4-95.5 28.5-129.9 2.5-4.8 5.3-9.5 8.2-14.1L112 80c-10.9 0-26.6 8.9-41 36.3-13.8 26.3-23 64.3-23 107.7zm46.8 34.2c-9.2-9.5-9-24.7 .6-33.9 9.5-9.2 24.7-9 33.9 .6l16.1 16.6 59.3-81.6c7.8-10.7 22.8-13.1 33.5-5.3s13.1 22.8 5.3 33.5L167.4 292.8c-4.2 5.7-10.7 9.3-17.8 9.8s-14-2.2-18.9-7.3L94.8 258.2zM336 224c0 43.3 9.2 81.3 23 107.7 14.4 27.5 30.1 36.3 41 36.3s26.6-8.9 41-36.3c13.8-26.3 23-64.3 23-107.7s-9.2-81.3-23-107.7C426.6 88.9 410.9 80 400 80s-26.6 8.9-41 36.3c-13.8 26.3-23 64.3-23 107.7zm40 0c0-26.5 10.7-48 24-48s24 21.5 24 48-10.7 48-24 48-24-21.5-24-48z", "M400 32c37.7 0 66 28.7 83.5 62.1 18.1 34.5 28.5 80.5 28.5 129.9s-10.4 95.5-28.5 129.9c-17.5 33.3-45.8 62.1-83.5 62.1-25.9 0-47.4-13.6-64-32.9l0 88.9c0 39.8-32.2 72-72 72L72 544c-39.8 0-72-32.2-72-72L0 224C0 174.5 10.4 128.5 28.5 94.1 46 60.7 74.3 32 112 32l288 0zM112 80c-10.9 0-26.6 8.9-41 36.3-13.8 26.3-23 64.3-23 107.7l0 248c0 13.3 10.7 24 24 24l192 0c13.3 0 24-10.7 24-24l0-248c0-49.5 10.4-95.5 28.5-129.9 2.5-4.8 5.3-9.5 8.2-14.1L112 80zm288 0c-10.9 0-26.6 8.9-41 36.3-13.8 26.3-23 64.3-23 107.7s9.2 81.3 23 107.7c14.4 27.5 30.1 36.3 41 36.3s26.6-8.9 41-36.3c13.8-26.3 23-64.3 23-107.7s-9.2-81.3-23-107.7C426.6 88.9 410.9 80 400 80zM204.7 159.9c7.8-10.7 22.8-13.1 33.5-5.3s13.1 22.8 5.3 33.5L167.4 292.8c-4.2 5.7-10.7 9.3-17.8 9.8s-14-2.2-18.9-7.3L94.8 258.2c-9.2-9.5-9-24.7 .6-33.9 9.5-9.2 24.7-9 33.9 .6l16.1 16.6 59.3-81.6zM400 176c13.3 0 24 21.5 24 48s-10.7 48-24 48-24-21.5-24-48 10.7-48 24-48z"]],
    "seal-question": [512, 512, [], "e243", ["M52.5 255.5l45.6 45.6c9 9 14.1 21.2 14.1 33.9l0 64.9 64.9 0c12.7 0 24.9 5.1 33.9 14.1l45.1 45.1 45.1-45.1c9-9 21.2-14.1 33.9-14.1l64.9 0 0-64.9c0-12.7 5.1-24.9 14.1-33.9l45.6-45.6-45.6-45.6c-9-9-14.1-21.2-14.1-33.9l0-64-64 0c-12.7 0-24.9-5.1-33.9-14.1l-46.1-46.1-46.1 46.1c-9 9-21.2 14.1-33.9 14.1l-64 0 0 64c0 12.7-5.1 24.9-14.1 33.9L52.5 255.5zm126.4-42.3c0-42.6 34.6-77.2 77.2-77.2s77.2 34.6 77.2 77.2c0 45.5-34.5 64.7-53.7 71.8-2.3 10.8-11.9 19-23.5 19-13.3 0-24-10.7-24-24 0-20.2 14.6-34.6 29.5-39.5 6-2 12.3-5.1 16.8-9.5 3.9-3.8 6.9-9 6.9-17.7 0-16.1-13.1-29.2-29.2-29.2s-29.2 13.1-29.2 29.2c0 13.3-10.7 24-24 24s-24-10.7-24-24zM284.1 352a28 28 0 1 1 -56 0 28 28 0 1 1 56 0z", "M176.1 112c12.7 0 24.9-5.1 33.9-14.1l46.1-46.1 46.1 46.1c9 9 21.2 14.1 33.9 14.1l64 0 0 64c0 12.7 5.1 24.9 14.1 33.9l45.6 45.6-45.6 45.6c-9 9-14.1 21.2-14.1 33.9l0 64.9-64.9 0c-12.7 0-24.9 5.1-33.9 14.1l-45.1 45.1-45.1-45.1c-9-9-21.2-14.1-33.9-14.1l-64.9 0 0-64.9c0-12.7-5.1-24.9-14.1-33.9l-45.6-45.6 45.6-45.6c9-9 14.1-21.2 14.1-33.9l0-64 64 0zM290.1 17.9C271.3-.8 241-.8 222.2 17.9l-46.1 46.1-64 0c-26.5 0-48 21.5-48 48l0 64-45.6 45.6c-18.7 18.7-18.7 49.1 0 67.9l45.6 45.6 0 64.9c0 26.5 21.5 48 48 48l64.9 0 45.1 45.1c18.7 18.7 49.1 18.7 67.9 0l45.1-45.1 64.9 0c26.5 0 48-21.5 48-48l0-64.9 45.6-45.6c18.7-18.7 18.7-49.1 0-67.9l-45.6-45.6 0-64c0-26.5-21.5-48-48-48l-64 0-46.1-46.1zM256.1 184c16.1 0 29.2 13.1 29.2 29.2 0 8.7-3.1 13.9-6.9 17.7-4.5 4.4-10.7 7.5-16.8 9.5-14.9 5-29.5 19.3-29.5 39.5 0 13.3 10.7 24 24 24 11.5 0 21.2-8.1 23.5-19 19.2-7.1 53.7-26.3 53.7-71.8 0-42.6-34.6-77.2-77.2-77.2s-77.2 34.6-77.2 77.2c0 13.3 10.7 24 24 24s24-10.7 24-24c0-16.1 13.1-29.2 29.2-29.2zm28 168a28 28 0 1 0 -56 0 28 28 0 1 0 56 0z"]],
    "x-ray": [512, 512, [], "f497", ["M80 80l0 352 352 0 0-352-352 0zm48 176c0-13.3 10.7-24 24-24l80 0 0-40-64 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l64 0 0-8c0-13.3 10.7-24 24-24s24 10.7 24 24l0 8 64 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-64 0 0 40 80 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0 0 40 64 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-64 0 0 8c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-8-64 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l64 0 0-40-80 0c-13.3 0-24-10.7-24-24z", "M24 32C10.7 32 0 42.7 0 56S10.7 80 24 80l8 0 0 352-8 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l464 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-8 0 0-352 8 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L24 32zM80 432l0-352 352 0 0 352-352 0zM280 136c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 8-64 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l64 0 0 40-80 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l80 0 0 40-64 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l64 0 0 8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-8 64 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-64 0 0-40 80 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0 0-40 64 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-64 0 0-8z"]],
    "umbrella-beach": [512, 512, [127958], "f5ca", ["M96.4 122.6l362.1 181c3.6-15.3 5.5-31.2 5.5-47.6 0-114.9-93.1-208-208-208-64 0-121.4 28.9-159.6 74.6z", "M464 256c0 16.4-1.9 32.3-5.5 47.6L96.4 122.6C134.6 76.9 192 48 256 48 370.9 48 464 141.1 464 256zm-7.6 100.2c15.8 7.9 35.2 1.5 41.1-15.1 9.4-26.6 14.5-55.3 14.5-85.1 0-141.4-114.6-256-256-256-88.8 0-167 45.2-212.9 113.8-9.8 14.7-3.3 34.1 12.5 42l172.5 86.3-1.6 3.2-109.4 218.7-93.2 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l464 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-317.2 0 98.6-197.3 1.6-3.2 185.4 92.7z"]],
    "arrow-right-to-bracket": [512, 512, ["sign-in"], "f090", ["", "M209 409L345 273c9.4-9.4 9.4-24.6 0-33.9L209 103c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l95 95-246.1 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l246.1 0-95 95c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0zM344 80l72 0c26.5 0 48 21.5 48 48l0 256c0 26.5-21.5 48-48 48l-72 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l72 0c53 0 96-43 96-96l0-256c0-53-43-96-96-96l-72 0c-13.3 0-24 10.7-24 24s10.7 24 24 24z"]],
    "headset": [448, 512, [], "f590", ["M48 288c0-26.5 21.5-48 48-48l16 0 0 96-16 0c-26.5 0-48-21.5-48-48zm288-48l16 0c26.5 0 48 21.5 48 48s-21.5 48-48 48l-16 0 0-96z", "M49.1 204.2C58.9 116.3 133.5 48 224 48s165.1 68.3 174.9 156.2C385 196.4 369 192 352 192l-16 0c-26.5 0-48 21.5-48 48l0 96c0 26.5 21.5 48 48 48l16 0c17.5 0 33.9-4.7 48-12.8l0 20.9c0 39.8-32.3 72-72 72l-40 0 0 0c0-26.5-21.5-48-48-48l-32 0c-26.5 0-48 21.5-48 48s21.5 48 48 48c44 0 36 0 119.9 .1 66.3 0 120.1-53.7 120.1-120L448 224C448 100.3 347.7 0 224 0S0 100.3 0 224l0 64c0 53 43 96 96 96l16 0c26.5 0 48-21.5 48-48l0-96c0-26.5-21.5-48-48-48l-16 0c-17 0-33 4.4-46.9 12.2zM352 240c26.5 0 48 21.5 48 48s-21.5 48-48 48l-16 0 0-96 16 0zM48 288c0-26.5 21.5-48 48-48l16 0 0 96-16 0c-26.5 0-48-21.5-48-48z"]],
    "thumbtack-angle-slash": [576, 512, [], "e752", ["M255.7 189.8l122.6-105.7 81.6 81.6-105.7 122.6-98.5-98.5z", "M41-24.9c-9.4-9.4-24.6-9.4-33.9 0S-2.3-.3 7 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-180.7-180.7 105.7-122.6 9.2 9.2c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9c-4-4-50.9-50.9-140.6-140.6L369 6.9c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9L344.2 50.1 221.6 155.8 41-24.9zM255.7 189.8l122.6-105.7 81.6 81.6-105.7 122.6-98.5-98.5zM104.3 174.2c-20 14.2-22.7 43.3-5.1 60.9L309 444.7c17.6 17.6 46.6 15 60.9-5.1L104.3 174.2zm48.9 182.7L39 471c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l114.2-114.2-33.9-33.9z"]],
    "camera-polaroid": [576, 512, [], "f8aa", ["M68.4 336l32.9-49.3c7-10.5 10.7-22.9 10.7-35.5L112 96c0-8.8 7.2-16 16-16l320 0c8.8 0 16 7.2 16 16l0 155.2c0 12.6 3.7 25 10.7 35.5l32.9 49.3-439.3 0zM208 208a80 80 0 1 0 160 0 80 80 0 1 0 -160 0zm176-72a24 24 0 1 0 48 0 24 24 0 1 0 -48 0z", "M512 432L64 432c-8.8 0-16-7.2-16-16l0-32 480 0 0 32c0 8.8-7.2 16-16 16zM68.4 336l32.9-49.3c7-10.5 10.7-22.9 10.7-35.5L112 96c0-8.8 7.2-16 16-16l320 0c8.8 0 16 7.2 16 16l0 155.2c0 12.6 3.7 25 10.7 35.5l32.9 49.3-439.3 0zM64 480l448 0c35.3 0 64-28.7 64-64l0-44.6c0-12.6-3.7-25-10.7-35.5L514.7 260c-1.8-2.6-2.7-5.7-2.7-8.9L512 96c0-35.3-28.7-64-64-64L128 32C92.7 32 64 60.7 64 96l0 155.2c0 3.2-.9 6.2-2.7 8.9L10.7 335.9C3.7 346.4 0 358.7 0 371.4L0 416c0 35.3 28.7 64 64 64zM408 112a24 24 0 1 0 0 48 24 24 0 1 0 0-48zM288 288a80 80 0 1 0 0-160 80 80 0 1 0 0 160zm-32-80a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"]],
    "face-saluting": [640, 512, [129761], "e484", ["M146.1 285.1c14.1 101.1 101 178.9 206 178.9 114.9 0 208-93.1 208-208S467 48 352.1 48c-37.8 0-73.2 10.1-103.7 27.7l-6.1 6c2.2 1.8 4.4 3.7 6.4 5.8 24.2 24.2 29.6 59.9 16.4 89.4 2.3-.5 4.6-.8 7-.8 17.7 0 32 14.3 32 32s-14.3 32-32 32c-17.3 0-31.4-13.7-32-30.9l-45.5 45.5c-14.1 14.1-30.8 24.3-48.5 30.4zm92.7 67.6c-9.2-9.6-8.9-24.8 .7-33.9s24.8-8.9 33.9 .7c15 15.7 41.1 32.6 78.7 32.6s63.7-17 78.7-32.6c9.2-9.6 24.4-9.9 33.9-.7s9.9 24.4 .7 33.9c-22.1 23-60 47.4-113.3 47.4s-91.2-24.4-113.3-47.4zM464.1 208a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M230.7-38.6c-12.5-12.5-32.8-12.5-45.3 0L43.4 103.4c-31.2 31.2-31.2 81.9 0 113.1l4.1 4.1c31.2 31.2 81.9 31.2 113.1 0l54.1-54.1c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-41.1 41.1-26.2-27.3 128.5-128.5c12.5-12.5 12.5-32.8 0-45.3zM98.6 292c17.5 124.3 124.3 220 253.5 220 141.4 0 256-114.6 256-256S493.5 0 352.1 0c-23.6 0-46.4 3.2-68 9.1-3.8 11.5-10.3 22.3-19.4 31.4L231.1 74.1c3.3 1.8 6.4 3.9 9.5 6.2 32.2-20.5 70.5-32.4 111.5-32.4 114.9 0 208 93.1 208 208S467 464 352.1 464c-105 0-191.8-77.8-206-178.9-15.3 5.3-31.5 7.6-47.5 6.9zm140.9 26.7c-9.6 9.2-9.9 24.4-.7 33.9 22.1 23 60 47.4 113.3 47.4s91.2-24.4 113.3-47.4c9.2-9.6 8.9-24.8-.7-33.9s-24.8-8.9-33.9 .7c-15 15.7-41.1 32.6-78.7 32.6s-63.7-17-78.7-32.6c-9.2-9.6-24.4-9.9-33.9-.7zM272.1 240a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm192-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"]],
    "hand-horns": [384, 512, [], "e1a9", ["M48 320l0 24c0 66.3 53.7 120 120 120l48 0c66.3 0 120-53.7 120-120l0-216c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 176c0 35.3-28.7 64-64 64-15.1 0-29-5.3-40-14-11 8.8-24.9 14-40 14l-40 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l40 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-80 0c-17.7 0-32 14.3-32 32zM64 64l0 177.6c5.2-1 10.5-1.6 16-1.6l16 0 0-176c0-8.8-7.2-16-16-16S64 55.2 64 64zm80 144l0 32 16 0c5.5 0 10.9 .7 16 2l0-34c0-8.8-7.2-16-16-16s-16 7.2-16 16zm80 32l0 64c0 8.8 7.2 16 16 16s16-7.2 16-16l0-64c0-8.8-7.2-16-16-16s-16 7.2-16 16z", "M80 48c8.8 0 16 7.2 16 16l0 176-16 0c-5.5 0-10.8 .6-16 1.6L64 64c0-8.8 7.2-16 16-16zM16 64l0 208C6 285.4 0 302 0 320l0 24c0 92.8 75.2 168 168 168l48 0c92.8 0 168-75.2 168-168l0-216c0-35.3-28.7-64-64-64s-64 28.7-64 64l0 50c-5.1-1.3-10.5-2-16-2-7.9 0-15.4 1.4-22.4 4-10.4-21.3-32.3-36-57.6-36-5.5 0-10.9 .7-16 2l0-82c0-35.3-28.7-64-64-64S16 28.7 16 64zM336 256l0 88c0 66.3-53.7 120-120 120l-48 0c-66.3 0-120-53.7-120-120l0-24c0-17.7 14.3-32 32-32l80 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-40 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l40 0c15.1 0 29-5.3 40-14 11 8.8 24.9 14 40 14 35.3 0 64-28.7 64-64l0-176c0-8.8 7.2-16 16-16s16 7.2 16 16l0 128zM160 240l-16 0 0-32c0-8.8 7.2-16 16-16s16 7.2 16 16l0 34c-5.1-1.3-10.5-2-16-2zm96 16l0 48c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-64c0-8.8 7.2-16 16-16s16 7.2 16 16l0 16z"]],
    "file-exclamation": [384, 512, [], "f31a", ["M48 64l0 384c0 8.8 7.2 16 16 16l256 0c8.8 0 16-7.2 16-16l0-240-88 0c-39.8 0-72-32.2-72-72l0-88-112 0c-8.8 0-16 7.2-16 16zM160 408c0-17.7 14.3-32 32-32s32 14.3 32 32-14.3 32-32 32-32-14.3-32-32zm1-141.4c-2-18.5 12.4-34.6 31-34.6s33 16.1 31 34.6l-7.1 64.1C214.5 342.8 204.2 352 192 352s-22.5-9.2-23.8-21.3L161 266.6z", "M203.8 .3c14.7 1.5 28.4 7.9 38.9 18.4L365.3 141.2c12 12 18.7 28.3 18.7 45.2l0 261.5-.3 6.5c-3.1 30.1-27 54.1-57.1 57.1l-6.5 .3-256 0c-35.3 0-64-28.7-64-64L0 64C0 28.7 28.7 0 64 0l133.5 0 6.3 .3zM64 48c-8.8 0-16 7.2-16 16l0 384c0 8.8 7.2 16 16 16l256 0c8.8 0 16-7.2 16-16l0-240-88 0c-39.8 0-72-32.2-72-72l0-88-112 0zM192 376c17.7 0 32 14.3 32 32s-14.3 32-32 32-32-14.3-32-32 14.3-32 32-32zm0-144c18.6 0 33 16.1 31 34.6l-7.1 64.1C214.5 342.8 204.2 352 192 352s-22.5-9.2-23.8-21.3L161 266.6c-2-18.5 12.4-34.6 31-34.6zm32-96c0 13.3 10.7 24 24 24l68.1 0-92.1-92.1 0 68.1z"]],
    "head-side-circuit": [512, 512, [], "e75e", ["M48 224c0-47.4 18.7-90.4 49.2-122.1l3.4 5.1c4.8 7.2 7.4 15.7 7.4 24.4l0 26c-12 6.9-20 19.8-20 34.6 0 22.1 17.9 40 40 40s40-17.9 40-40c0-14.8-8-27.7-20-34.6l0-26c0-16.6-4.9-32.8-14.1-46.6l-5.7-8.5c22.3-14.5 48-24.1 75.8-27.2l0 44.2c-12 6.9-20 19.8-20 34.6 0 22.1 17.9 40 40 40s40-17.9 40-40c0-14.8-8-27.7-20-34.6l0-44.2c27.7 3.1 53.5 12.7 75.8 27.2l-5.7 8.5c-9.2 13.8-14.1 30-14.1 46.6l0 26c-12 6.9-20 19.8-20 34.6 0 22.1 17.9 40 40 40s40-17.9 40-40c0-14.8-8-27.7-20-34.6l0-26c0-8.7 2.6-17.2 7.4-24.4l3.4-5.1c23.7 24.6 40.3 56.1 46.5 91.2 .9 4.8 3.2 9.3 6.7 12.8l52.2 52.2c5 5 7.9 11.9 7.9 19 0 14.9-12 26.9-26.9 26.9L424 304c-13.3 0-24 10.7-24 24l0 48c0 22.1-17.9 40-40 40l-48 0c-13.3 0-24 10.7-24 24l0 48c0 13.3 10.7 24 24 24L88 512c13.3 0 24-10.7 24-24l0-99.9c0-18.1-7.8-34.2-18.5-46-28.3-31.2-45.5-72.6-45.5-118.1zm136 32a40 40 0 1 0 80 0 40 40 0 1 0 -80 0z", "M224 0C100.3 0 0 100.3 0 224 0 281.8 22 334.6 58 374.3 62.2 379 64 384 64 388.1L64 488c0 13.3 10.7 24 24 24s24-10.7 24-24l0-99.9c0-18.1-7.8-34.2-18.5-46-28.3-31.2-45.5-72.6-45.5-118.1 0-47.4 18.7-90.4 49.2-122.1l3.4 5.1c4.8 7.2 7.4 15.7 7.4 24.4l0 26c-12 6.9-20 19.8-20 34.6 0 22.1 17.9 40 40 40s40-17.9 40-40c0-14.8-8-27.7-20-34.6l0-26c0-16.6-4.9-32.8-14.1-46.6l-5.7-8.5c22.3-14.5 48-24.1 75.8-27.2l0 44.2c-12 6.9-20 19.8-20 34.6 0 22.1 17.9 40 40 40s40-17.9 40-40c0-14.8-8-27.7-20-34.6l0-44.2c27.7 3.1 53.5 12.7 75.8 27.2l-5.7 8.5c-9.2 13.8-14.1 30-14.1 46.6l0 26c-12 6.9-20 19.8-20 34.6 0 22.1 17.9 40 40 40s40-17.9 40-40c0-14.8-8-27.7-20-34.6l0-26c0-8.7 2.6-17.2 7.4-24.4l3.4-5.1c23.7 24.6 40.3 56.1 46.5 91.2 .9 4.8 3.2 9.3 6.7 12.8l52.2 52.2c5 5 7.9 11.9 7.9 19 0 14.9-12 26.9-26.9 26.9L424 304c-13.3 0-24 10.7-24 24l0 48c0 22.1-17.9 40-40 40l-48 0c-13.3 0-24 10.7-24 24l0 48c0 13.3 10.7 24 24 24s24-10.7 24-24l0-24 24 0c48.6 0 88-39.4 88-88l0-24.8c36.2-5.3 64-36.5 64-74.1 0-19.9-7.9-38.9-21.9-53l-47-47C421.5 75.9 331.7 0 224 0zm40 256a40 40 0 1 0 -80 0 40 40 0 1 0 80 0z"]],
    "pipe-circle-check": [576, 512, [], "e436", ["M80 176l416 0 0 42.9c-20-7.1-41.6-10.9-64-10.9-83.6 0-154.7 53.4-181.1 128L80 336 80 176z", "M56 96c13.3 0 24 10.7 24 24l0 8 416 0 0-8c0-13.3 10.7-24 24-24s24 10.7 24 24l0 124c-14.6-10.5-30.7-19-48-25.1l0-42.9-416 0 0 160 170.9 0c-5.4 15.2-8.9 31.3-10.3 48l-160.7 0 0 8c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-272c0-13.3 10.7-24 24-24zM288 400a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm201.4-60.9c-7.1-5.2-17.2-3.6-22.4 3.5l-53 72.9-26.8-26.8c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l40 40c3.3 3.3 7.9 5 12.6 4.6s8.9-2.8 11.7-6.5l64-88c5.2-7.1 3.6-17.2-3.5-22.3z"]],
    "splotch": [512, 512, [], "f5bc", ["M48 140.9c0 3.1 .9 6.2 2.6 8.8l40.5 61.8c12.7 19.4 19.7 41.9 20.2 65 .7 27.8-8.1 55-24.8 77.3l-18.8 25c-2.5 3.3-3.8 7.4-3.8 11.5 0 11.3 9.7 20.2 20.9 19.1l102.7-9.3c1.4-.1 2.9-.2 4.3-.2 31.6 0 62.3 10.8 87 30.5l37.1 29.7c3.1 2.5 6.9 3.8 10.9 3.8 10.4 0 18.4-9 17.3-19.3L341.7 422c-5.2-47.1 14.8-93.4 52.7-121.8l62-46.5c4.8-3.6 7.6-9.2 7.6-15.2 0-7.9-4.9-15.1-12.4-17.8l-32.3-12.1c-46.6-17.5-82.8-55-98.5-102.2l-15-45.1c-2.6-7.9-10-13.2-18.3-13.2-5.7 0-11.1 2.5-14.8 6.9L250.4 81.7c-34.2 41.1-87.9 60.6-140.6 51L67 125c-9.9-1.8-19 5.8-19 15.9z", "M187.7 400.2L84.9 409.5c-11.2 1-20.9-7.8-20.9-19.1 0-4.2 1.3-8.2 3.8-11.5l18.8-25c16.7-22.3 25.4-49.5 24.8-77.3-.5-23.1-7.5-45.7-20.2-65L50.6 149.7c-1.7-2.6-2.6-5.7-2.6-8.8 0-10.1 9.1-17.7 19-15.9l42.8 7.8c52.6 9.6 106.3-9.9 140.6-51l22.3-26.8c3.7-4.4 9.1-6.9 14.8-6.9 8.3 0 15.7 5.3 18.3 13.2l15 45.1c15.7 47.2 51.9 84.7 98.5 102.2l32.3 12.1c7.4 2.8 12.4 9.9 12.4 17.8 0 6-2.8 11.6-7.6 15.2l-62 46.5c-37.9 28.4-57.9 74.7-52.7 121.8l2.5 22.7c1.1 10.3-6.9 19.3-17.3 19.3-3.9 0-7.8-1.3-10.9-3.8L279 430.5c-24.7-19.8-55.4-30.5-87-30.5-1.5 0-2.9 .1-4.3 .2zM51 237.8c7.8 11.9 12.1 25.7 12.4 39.8 .4 17-4.9 33.7-15.2 47.4l-18.8 25c-8.7 11.6-13.4 25.8-13.4 40.3 0 39.5 33.9 70.5 73.3 66.9L192 448c20.7 0 40.8 7 57 20l37.1 29.7c11.6 9.3 26 14.3 40.9 14.3 39 0 69.3-33.9 65-72.6l-2.5-22.7c-3.4-30.2 9.5-59.9 33.8-78.1l62-46.5c16.9-12.7 26.8-32.5 26.8-53.6 0-28-17.3-53-43.5-62.8l-32.3-12.1c-33-12.4-58.7-39-69.8-72.4L351.3 46c-9.2-27.5-34.9-46-63.8-46-20 0-38.9 8.9-51.7 24.2L213.5 51C190.3 78.8 154 92 118.4 85.5L75.6 77.7C36.2 70.6 0 100.8 0 140.9 0 153.3 3.6 165.6 10.5 176L51 237.8z"]],
    "square-shekel": [448, 512, [], "e735", ["M48 96l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80c-8.8 0-16 7.2-16 16zm48 64c0-13.3 10.7-24 24-24l88 0c39.8 0 72 32.2 72 72l0 56c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-56c0-13.3-10.7-24-24-24l-64 0 0 168c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-192zm72 88c0-13.3 10.7-24 24-24s24 10.7 24 24l0 80 64 0c13.3 0 24-10.7 24-24l0-144c0-13.3 10.7-24 24-24s24 10.7 24 24l0 144c0 39.8-32.2 72-72 72l-88 0c-6.4 0-12.5-2.5-17-7s-7-10.6-7-17l0-104z", "M64 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L64 80zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm120 40l88 0c39.8 0 72 32.2 72 72l0 56c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-56c0-13.3-10.7-24-24-24l-64 0 0 168c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-192c0-13.3 10.7-24 24-24zm232 24l0 144c0 39.8-32.2 72-72 72l-88 0c-6.4 0-12.5-2.5-17-7s-7-10.6-7-17l0-104c0-13.3 10.7-24 24-24s24 10.7 24 24l0 80 64 0c13.3 0 24-10.7 24-24l0-144c0-13.3 10.7-24 24-24s24 10.7 24 24z"]],
    "up-long": [320, 512, ["long-arrow-alt-up"], "f30c", ["M70.6 112l33.4 0c13.3 0 24 10.7 24 24l0 360 64 0 0-360c0-13.3 10.7-24 24-24l33.4 0-89.4-89.4-89.4 89.4z", "M160 22.6L70.6 112 104 112c13.3 0 24 10.7 24 24l0 360 64 0 0-360c0-13.3 10.7-24 24-24l33.4 0-89.4-89.4zM137.4-22.6c12.5-12.5 32.8-12.5 45.3 0l128 128c9.2 9.2 11.9 22.9 6.9 34.9l0 0c-5 12-16.6 19.8-29.6 19.8l-48 0 0 336c0 26.5-21.5 48-48 48l-64 0c-26.5 0-48-21.5-48-48l0-336-48 0c-12.9 0-24.6-7.8-29.6-19.8l0 0c-5-12-2.2-25.7 6.9-34.9l128-128 0 0z"]],
    "face-unamused": [512, 512, [], "e39f", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm47-40c0-13.3 10.7-24 24-24l65 0c22.1 0 40 17.9 40 40s-17.9 40-40 40c-19.4 0-35.5-13.7-39.2-32L119 240c-13.3 0-24-10.7-24-24zm63.5 154c21.7-30.2 57.3-50 97.5-50s75.7 19.8 97.5 50c7.7 10.8 5.3 25.8-5.5 33.5s-25.8 5.3-33.5-5.5c-13.1-18.2-34.4-30-58.5-30s-45.4 11.8-58.5 30c-7.7 10.8-22.7 13.2-33.5 5.5s-13.2-22.7-5.5-33.5zM288 216c0-13.3 10.7-24 24-24l64 0c22.1 0 40 17.9 40 40s-17.9 40-40 40c-19.4 0-35.5-13.7-39.2-32L312 240c-13.3 0-24-10.7-24-24z", "M464 256a208 208 0 1 0 -416 0 208 208 0 1 0 416 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zM197.5 398c-7.7 10.8-22.7 13.2-33.5 5.5s-13.2-22.7-5.5-33.5c21.7-30.2 57.3-50 97.5-50s75.7 19.8 97.5 50c7.7 10.8 5.3 25.8-5.5 33.5s-25.8 5.3-33.5-5.5c-13.1-18.2-34.4-30-58.5-30s-45.4 11.8-58.5 30zM119 192l65 0c22.1 0 40 17.9 40 40s-17.9 40-40 40c-19.4 0-35.5-13.7-39.2-32L119 240c-13.3 0-24-10.7-24-24s10.7-24 24-24zm169 24c0-13.3 10.7-24 24-24l64 0c22.1 0 40 17.9 40 40s-17.9 40-40 40c-19.4 0-35.5-13.7-39.2-32L312 240c-13.3 0-24-10.7-24-24z"]],
    "circle-indian-rupee": [512, 512, [], "e734", ["M48 256a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zM160 144c0-13.3 10.7-24 24-24l152 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-44.1 0c9.3 11.3 15.9 25 18.7 40l25.5 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-25.5 0c-6.1 33-30.5 59.5-62.3 68.6L319 349.3c10.3 8.3 12 23.4 3.7 33.7s-23.4 12-33.7 3.8l-120-96c-8-6.4-11-17.1-7.7-26.7S173.8 248 184 248l40 0c16.4 0 30.5-9.9 36.7-24L176 224c-8.8 0-16-7.2-16-16s7.2-16 16-16l84.7 0c-6.2-14.1-20.3-24-36.7-24l-40 0c-13.3 0-24-10.7-24-24z", "M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM184 120c-13.3 0-24 10.7-24 24s10.7 24 24 24l40 0c16.4 0 30.5 9.9 36.7 24L176 192c-8.8 0-16 7.2-16 16s7.2 16 16 16l84.7 0c-6.2 14.1-20.3 24-36.7 24l-40 0c-10.2 0-19.3 6.4-22.6 16.1s-.3 20.3 7.7 26.7l120 96c10.3 8.3 25.5 6.6 33.7-3.8s6.6-25.5-3.7-33.7l-70.8-56.6c31.8-9.1 56.3-35.6 62.3-68.6l25.5 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-25.5 0c-2.8-15-9.3-28.7-18.7-40l44.1 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-152 0z"]],
    "spinner-scale": [448, 512, [], "e62a", ["M371.1 131.5a16 16 0 1 1 -22.6-22.6 16 16 0 1 1 22.6 22.6z", "M224 52a12 12 0 1 1 0 24 12 12 0 1 1 0-24zM172 64a52 52 0 1 0 104 0 52 52 0 1 0 -104 0zm20 384c0 17.7 14.3 32 32 32s32-14.3 32-32-14.3-32-32-32-32 14.3-32 32zM448 256a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM32 220a36 36 0 1 0 0 72 36 36 0 1 0 0-72zm339.1-88.5a16 16 0 1 1 -22.6-22.6 16 16 0 1 1 22.6 22.6zm28.3-50.9a56 56 0 1 0 -79.2 79.2 56 56 0 1 0 79.2-79.2zM65.6 369.1a32 32 0 1 0 45.3 45.3 32 32 0 1 0 -45.3-45.3zm316.8 45.3a32 32 0 1 0 -45.3-45.3 32 32 0 1 0 45.3 45.3zM93.9 125.9a8 8 0 1 1 -11.3-11.3 8 8 0 1 1 11.3 11.3zm28.3-39.6a48 48 0 1 0 -67.9 67.9 48 48 0 1 0 67.9-67.9z"]],
    "hexagon-nodes": [448, 512, [], "e699", ["M43.2 148a24 24 0 1 0 41.6 24A24 24 0 1 0 43.2 148zm0 216a24 24 0 1 0 41.6-24A24 24 0 1 0 43.2 364zM200 64a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm0 192a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm0 192a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zM363.2 172a24 24 0 1 0 41.6-24 24 24 0 1 0 -41.6 24zm0 168a24 24 0 1 0 41.6 24 24 24 0 1 0 -41.6-24z", "M224 88a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm64-24c0 26.9-16.5 49.9-40 59.3l0 73.3c23.5 9.5 40 32.5 40 59.3c0 3.4-.3 6.7-.8 10l58.2 34.9c4.5-3.4 9.4-6.1 14.5-8.2l0-73.3c-5.2-2.1-10-4.8-14.5-8.2l-29.4 17.6c-4.7-15.8-13.3-29.9-24.7-41.1l29.4-17.6c-4-25.4 7.7-51.7 31.2-65.4c30.6-17.7 69.8-7.2 87.4 23.4s7.2 69.8-23.4 87.4c-2.6 1.5-5.3 2.8-8 3.9l0 73.3c2.7 1.1 