/*!
 * Font Awesome Pro 7.1.0 by @fontawesome - https://fontawesome.com
 * License - https://fontawesome.com/license (Commercial License)
 * Copyright 2025 Fonticons, Inc.
 */
(function () {
  'use strict';

  var _WINDOW = {};
  var _DOCUMENT = {};
  try {
    if (typeof window !== 'undefined') _WINDOW = window;
    if (typeof document !== 'undefined') _DOCUMENT = document;
  } catch (e) {} // eslint-disable-line no-empty

  var _ref = _WINDOW.navigator || {},
    _ref$userAgent = _ref.userAgent,
    userAgent = _ref$userAgent === void 0 ? '' : _ref$userAgent;
  var WINDOW = _WINDOW;
  var DOCUMENT = _DOCUMENT;
  var IS_BROWSER = !!WINDOW.document;
  var IS_DOM = !!DOCUMENT.documentElement && !!DOCUMENT.head && typeof DOCUMENT.addEventListener === 'function' && typeof DOCUMENT.createElement === 'function';
  var IS_IE = ~userAgent.indexOf('MSIE') || ~userAgent.indexOf('Trident/');

  function _arrayLikeToArray(r, a) {
    (null == a || a > r.length) && (a = r.length);
    for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e];
    return n;
  }
  function _arrayWithoutHoles(r) {
    if (Array.isArray(r)) return _arrayLikeToArray(r);
  }
  function _defineProperty(e, r, t) {
    return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, {
      value: t,
      enumerable: !0,
      configurable: !0,
      writable: !0
    }) : e[r] = t, e;
  }
  function _iterableToArray(r) {
    if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r);
  }
  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }
  function ownKeys(e, r) {
    var t = Object.keys(e);
    if (Object.getOwnPropertySymbols) {
      var o = Object.getOwnPropertySymbols(e);
      r && (o = o.filter(function (r) {
        return Object.getOwnPropertyDescriptor(e, r).enumerable;
      })), t.push.apply(t, o);
    }
    return t;
  }
  function _objectSpread2(e) {
    for (var r = 1; r < arguments.length; r++) {
      var t = null != arguments[r] ? arguments[r] : {};
      r % 2 ? ownKeys(Object(t), !0).forEach(function (r) {
        _defineProperty(e, r, t[r]);
      }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) {
        Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r));
      });
    }
    return e;
  }
  function _toConsumableArray(r) {
    return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread();
  }
  function _toPrimitive(t, r) {
    if ("object" != typeof t || !t) return t;
    var e = t[Symbol.toPrimitive];
    if (void 0 !== e) {
      var i = e.call(t, r || "default");
      if ("object" != typeof i) return i;
      throw new TypeError("@@toPrimitive must return a primitive value.");
    }
    return ("string" === r ? String : Number)(t);
  }
  function _toPropertyKey(t) {
    var i = _toPrimitive(t, "string");
    return "symbol" == typeof i ? i : i + "";
  }
  function _unsupportedIterableToArray(r, a) {
    if (r) {
      if ("string" == typeof r) return _arrayLikeToArray(r, a);
      var t = {}.toString.call(r).slice(8, -1);
      return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0;
    }
  }

  var _dt;
  var q = {
      classic: {
        fa: "solid",
        fas: "solid",
        "fa-solid": "solid",
        far: "regular",
        "fa-regular": "regular",
        fal: "light",
        "fa-light": "light",
        fat: "thin",
        "fa-thin": "thin",
        fab: "brands",
        "fa-brands": "brands"
      },
      duotone: {
        fa: "solid",
        fad: "solid",
        "fa-solid": "solid",
        "fa-duotone": "solid",
        fadr: "regular",
        "fa-regular": "regular",
        fadl: "light",
        "fa-light": "light",
        fadt: "thin",
        "fa-thin": "thin"
      },
      sharp: {
        fa: "solid",
        fass: "solid",
        "fa-solid": "solid",
        fasr: "regular",
        "fa-regular": "regular",
        fasl: "light",
        "fa-light": "light",
        fast: "thin",
        "fa-thin": "thin"
      },
      "sharp-duotone": {
        fa: "solid",
        fasds: "solid",
        "fa-solid": "solid",
        fasdr: "regular",
        "fa-regular": "regular",
        fasdl: "light",
        "fa-light": "light",
        fasdt: "thin",
        "fa-thin": "thin"
      },
      slab: {
        "fa-regular": "regular",
        faslr: "regular"
      },
      "slab-press": {
        "fa-regular": "regular",
        faslpr: "regular"
      },
      thumbprint: {
        "fa-light": "light",
        fatl: "light"
      },
      whiteboard: {
        "fa-semibold": "semibold",
        fawsb: "semibold"
      },
      notdog: {
        "fa-solid": "solid",
        fans: "solid"
      },
      "notdog-duo": {
        "fa-solid": "solid",
        fands: "solid"
      },
      etch: {
        "fa-solid": "solid",
        faes: "solid"
      },
      jelly: {
        "fa-regular": "regular",
        fajr: "regular"
      },
      "jelly-fill": {
        "fa-regular": "regular",
        fajfr: "regular"
      },
      "jelly-duo": {
        "fa-regular": "regular",
        fajdr: "regular"
      },
      chisel: {
        "fa-regular": "regular",
        facr: "regular"
      },
      utility: {
        "fa-semibold": "semibold",
        fausb: "semibold"
      },
      "utility-duo": {
        "fa-semibold": "semibold",
        faudsb: "semibold"
      },
      "utility-fill": {
        "fa-semibold": "semibold",
        faufsb: "semibold"
      }
    };
  var i = "classic",
    t = "duotone",
    d = "sharp",
    l = "sharp-duotone",
    f = "chisel",
    n = "etch",
    h = "jelly",
    o = "jelly-duo",
    u = "jelly-fill",
    g = "notdog",
    s = "notdog-duo",
    y = "slab",
    m = "slab-press",
    e = "thumbprint",
    p = "utility",
    a = "utility-duo",
    w = "utility-fill",
    x = "whiteboard",
    b = "Classic",
    c = "Duotone",
    I = "Sharp",
    F = "Sharp Duotone",
    v = "Chisel",
    S = "Etch",
    A = "Jelly",
    P = "Jelly Duo",
    j = "Jelly Fill",
    B = "Notdog",
    N = "Notdog Duo",
    k = "Slab",
    D = "Slab Press",
    T = "Thumbprint",
    C = "Utility",
    W = "Utility Duo",
    K = "Utility Fill",
    R = "Whiteboard",
    dt = (_dt = {}, _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_dt, i, b), t, c), d, I), l, F), f, v), n, S), h, A), o, P), u, j), g, B), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_dt, s, N), y, k), m, D), e, T), p, C), a, W), w, K), x, R));
  var gt = {
      classic: {
        900: "fas",
        400: "far",
        normal: "far",
        300: "fal",
        100: "fat"
      },
      duotone: {
        900: "fad",
        400: "fadr",
        300: "fadl",
        100: "fadt"
      },
      sharp: {
        900: "fass",
        400: "fasr",
        300: "fasl",
        100: "fast"
      },
      "sharp-duotone": {
        900: "fasds",
        400: "fasdr",
        300: "fasdl",
        100: "fasdt"
      },
      slab: {
        400: "faslr"
      },
      "slab-press": {
        400: "faslpr"
      },
      whiteboard: {
        600: "fawsb"
      },
      thumbprint: {
        300: "fatl"
      },
      notdog: {
        900: "fans"
      },
      "notdog-duo": {
        900: "fands"
      },
      etch: {
        900: "faes"
      },
      chisel: {
        400: "facr"
      },
      jelly: {
        400: "fajr"
      },
      "jelly-fill": {
        400: "fajfr"
      },
      "jelly-duo": {
        400: "fajdr"
      },
      utility: {
        600: "fausb"
      },
      "utility-duo": {
        600: "faudsb"
      },
      "utility-fill": {
        600: "faufsb"
      }
    };
  var _t = {
      chisel: {
        regular: "facr"
      },
      classic: {
        brands: "fab",
        light: "fal",
        regular: "far",
        solid: "fas",
        thin: "fat"
      },
      duotone: {
        light: "fadl",
        regular: "fadr",
        solid: "fad",
        thin: "fadt"
      },
      etch: {
        solid: "faes"
      },
      jelly: {
        regular: "fajr"
      },
      "jelly-duo": {
        regular: "fajdr"
      },
      "jelly-fill": {
        regular: "fajfr"
      },
      notdog: {
        solid: "fans"
      },
      "notdog-duo": {
        solid: "fands"
      },
      sharp: {
        light: "fasl",
        regular: "fasr",
        solid: "fass",
        thin: "fast"
      },
      "sharp-duotone": {
        light: "fasdl",
        regular: "fasdr",
        solid: "fasds",
        thin: "fasdt"
      },
      slab: {
        regular: "faslr"
      },
      "slab-press": {
        regular: "faslpr"
      },
      thumbprint: {
        light: "fatl"
      },
      utility: {
        semibold: "fausb"
      },
      "utility-duo": {
        semibold: "faudsb"
      },
      "utility-fill": {
        semibold: "faufsb"
      },
      whiteboard: {
        semibold: "fawsb"
      }
    };
  var qt = {
      kit: {
        fak: "kit",
        "fa-kit": "kit"
      },
      "kit-duotone": {
        fakd: "kit-duotone",
        "fa-kit-duotone": "kit-duotone"
      }
    },
    Ht = ["kit"];
  var L = "kit",
    r = "kit-duotone",
    U = "Kit",
    J = "Kit Duotone",
    $t = _defineProperty(_defineProperty({}, L, U), r, J);
  var ol = {
    kit: {
      "fa-kit": "fak"
    },
    "kit-duotone": {
      "fa-kit-duotone": "fakd"
    }
  };
  var fl = {
      kit: {
        fak: "fa-kit"
      },
      "kit-duotone": {
        fakd: "fa-kit-duotone"
      }
    };
  var ul = {
      kit: {
        kit: "fak"
      },
      "kit-duotone": {
        "kit-duotone": "fakd"
      }
    };

  var _ml;
  var l$1 = {
      GROUP: "duotone-group",
      SWAP_OPACITY: "swap-opacity",
      PRIMARY: "primary",
      SECONDARY: "secondary"
    };
  var n$1 = "classic",
    o$1 = "duotone",
    u$1 = "sharp",
    s$1 = "sharp-duotone",
    h$1 = "chisel",
    g$1 = "etch",
    y$1 = "jelly",
    e$1 = "jelly-duo",
    m$1 = "jelly-fill",
    p$1 = "notdog",
    a$1 = "notdog-duo",
    w$1 = "slab",
    b$1 = "slab-press",
    r$1 = "thumbprint",
    c$1 = "utility",
    i$1 = "utility-duo",
    x$1 = "utility-fill",
    I$1 = "whiteboard",
    F$1 = "Classic",
    v$1 = "Duotone",
    S$1 = "Sharp",
    A$1 = "Sharp Duotone",
    P$1 = "Chisel",
    j$1 = "Etch",
    B$1 = "Jelly",
    N$1 = "Jelly Duo",
    k$1 = "Jelly Fill",
    D$1 = "Notdog",
    C$1 = "Notdog Duo",
    T$1 = "Slab",
    L$1 = "Slab Press",
    W$1 = "Thumbprint",
    R$1 = "Utility",
    K$1 = "Utility Duo",
    U$1 = "Utility Fill",
    J$1 = "Whiteboard",
    ml$1 = (_ml = {}, _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_ml, n$1, F$1), o$1, v$1), u$1, S$1), s$1, A$1), h$1, P$1), g$1, j$1), y$1, B$1), e$1, N$1), m$1, k$1), p$1, D$1), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_ml, a$1, C$1), w$1, T$1), b$1, L$1), r$1, W$1), c$1, R$1), i$1, K$1), x$1, U$1), I$1, J$1));
  var E$1 = "kit",
    d$1 = "kit-duotone",
    _$1 = "Kit",
    M$1 = "Kit Duotone",
    rt$1 = _defineProperty(_defineProperty({}, E$1, _$1), d$1, M$1);
  var $t$1 = {
      classic: {
        "fa-brands": "fab",
        "fa-duotone": "fad",
        "fa-light": "fal",
        "fa-regular": "far",
        "fa-solid": "fas",
        "fa-thin": "fat"
      },
      duotone: {
        "fa-regular": "fadr",
        "fa-light": "fadl",
        "fa-thin": "fadt"
      },
      sharp: {
        "fa-solid": "fass",
        "fa-regular": "fasr",
        "fa-light": "fasl",
        "fa-thin": "fast"
      },
      "sharp-duotone": {
        "fa-solid": "fasds",
        "fa-regular": "fasdr",
        "fa-light": "fasdl",
        "fa-thin": "fasdt"
      },
      slab: {
        "fa-regular": "faslr"
      },
      "slab-press": {
        "fa-regular": "faslpr"
      },
      whiteboard: {
        "fa-semibold": "fawsb"
      },
      thumbprint: {
        "fa-light": "fatl"
      },
      notdog: {
        "fa-solid": "fans"
      },
      "notdog-duo": {
        "fa-solid": "fands"
      },
      etch: {
        "fa-solid": "faes"
      },
      jelly: {
        "fa-regular": "fajr"
      },
      "jelly-fill": {
        "fa-regular": "fajfr"
      },
      "jelly-duo": {
        "fa-regular": "fajdr"
      },
      chisel: {
        "fa-regular": "facr"
      },
      utility: {
        "fa-semibold": "fausb"
      },
      "utility-duo": {
        "fa-semibold": "faudsb"
      },
      "utility-fill": {
        "fa-semibold": "faufsb"
      }
    },
    z = {
      classic: ["fas", "far", "fal", "fat", "fad"],
      duotone: ["fadr", "fadl", "fadt"],
      sharp: ["fass", "fasr", "fasl", "fast"],
      "sharp-duotone": ["fasds", "fasdr", "fasdl", "fasdt"],
      slab: ["faslr"],
      "slab-press": ["faslpr"],
      whiteboard: ["fawsb"],
      thumbprint: ["fatl"],
      notdog: ["fans"],
      "notdog-duo": ["fands"],
      etch: ["faes"],
      jelly: ["fajr"],
      "jelly-fill": ["fajfr"],
      "jelly-duo": ["fajdr"],
      chisel: ["facr"],
      utility: ["fausb"],
      "utility-duo": ["faudsb"],
      "utility-fill": ["faufsb"]
    },
    Ht$1 = {
      classic: {
        fab: "fa-brands",
        fad: "fa-duotone",
        fal: "fa-light",
        far: "fa-regular",
        fas: "fa-solid",
        fat: "fa-thin"
      },
      duotone: {
        fadr: "fa-regular",
        fadl: "fa-light",
        fadt: "fa-thin"
      },
      sharp: {
        fass: "fa-solid",
        fasr: "fa-regular",
        fasl: "fa-light",
        fast: "fa-thin"
      },
      "sharp-duotone": {
        fasds: "fa-solid",
        fasdr: "fa-regular",
        fasdl: "fa-light",
        fasdt: "fa-thin"
      },
      slab: {
        faslr: "fa-regular"
      },
      "slab-press": {
        faslpr: "fa-regular"
      },
      whiteboard: {
        fawsb: "fa-semibold"
      },
      thumbprint: {
        fatl: "fa-light"
      },
      notdog: {
        fans: "fa-solid"
      },
      "notdog-duo": {
        fands: "fa-solid"
      },
      etch: {
        faes: "fa-solid"
      },
      jelly: {
        fajr: "fa-regular"
      },
      "jelly-fill": {
        fajfr: "fa-regular"
      },
      "jelly-duo": {
        fajdr: "fa-regular"
      },
      chisel: {
        facr: "fa-regular"
      },
      utility: {
        fausb: "fa-semibold"
      },
      "utility-duo": {
        faudsb: "fa-semibold"
      },
      "utility-fill": {
        faufsb: "fa-semibold"
      }
    },
    G$1 = ["solid", "regular", "light", "thin", "duotone", "brands", "semibold"],
    O$1 = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
    V$1 = O$1.concat([11, 12, 13, 14, 15, 16, 17, 18, 19, 20]),
    $$1 = ["aw", "fw", "pull-left", "pull-right"],
    to = [].concat(_toConsumableArray(Object.keys(z)), G$1, $$1, ["2xs", "xs", "sm", "lg", "xl", "2xl", "beat", "border", "fade", "beat-fade", "bounce", "flip-both", "flip-horizontal", "flip-vertical", "flip", "inverse", "layers", "layers-bottom-left", "layers-bottom-right", "layers-counter", "layers-text", "layers-top-left", "layers-top-right", "li", "pull-end", "pull-start", "pulse", "rotate-180", "rotate-270", "rotate-90", "rotate-by", "shake", "spin-pulse", "spin-reverse", "spin", "stack-1x", "stack-2x", "stack", "ul", "width-auto", "width-fixed", l$1.GROUP, l$1.SWAP_OPACITY, l$1.PRIMARY, l$1.SECONDARY]).concat(O$1.map(function (t) {
      return "".concat(t, "x");
    })).concat(V$1.map(function (t) {
      return "w-".concat(t);
    }));

  var NAMESPACE_IDENTIFIER = '___FONT_AWESOME___';
  var PRODUCTION = function () {
    try {
      return "production" === 'production';
    } catch (e$$1) {
      return false;
    }
  }();
  function familyProxy(obj) {
    // Defaults to the classic family if family is not available
    return new Proxy(obj, {
      get: function get(target, prop) {
        return prop in target ? target[prop] : target[i];
      }
    });
  }
  var _PREFIX_TO_STYLE = _objectSpread2({}, q);

  // We changed FACSSClassesToStyleId in the icons repo to be canonical and as such, "classic" family does not have any
  // duotone styles.  But we do still need duotone in _PREFIX_TO_STYLE below, so we are manually adding
  // {'fa-duotone': 'duotone'}
  _PREFIX_TO_STYLE[i] = _objectSpread2(_objectSpread2(_objectSpread2(_objectSpread2({}, {
    'fa-duotone': 'duotone'
  }), q[i]), qt['kit']), qt['kit-duotone']);
  var PREFIX_TO_STYLE = familyProxy(_PREFIX_TO_STYLE);
  var _STYLE_TO_PREFIX = _objectSpread2({}, _t);

  // We changed FAStyleIdToShortPrefixId in the icons repo to be canonical and as such, "classic" family does not have any
  // duotone styles.  But we do still need duotone in _STYLE_TO_PREFIX below, so we are manually adding {duotone: 'fad'}
  _STYLE_TO_PREFIX[i] = _objectSpread2(_objectSpread2(_objectSpread2(_objectSpread2({}, {
    duotone: 'fad'
  }), _STYLE_TO_PREFIX[i]), ul['kit']), ul['kit-duotone']);
  var STYLE_TO_PREFIX = familyProxy(_STYLE_TO_PREFIX);
  var _PREFIX_TO_LONG_STYLE = _objectSpread2({}, Ht$1);
  _PREFIX_TO_LONG_STYLE[i] = _objectSpread2(_objectSpread2({}, _PREFIX_TO_LONG_STYLE[i]), fl['kit']);
  var PREFIX_TO_LONG_STYLE = familyProxy(_PREFIX_TO_LONG_STYLE);
  var _LONG_STYLE_TO_PREFIX = _objectSpread2({}, $t$1);
  _LONG_STYLE_TO_PREFIX[i] = _objectSpread2(_objectSpread2({}, _LONG_STYLE_TO_PREFIX[i]), ol['kit']);
  var LONG_STYLE_TO_PREFIX = familyProxy(_LONG_STYLE_TO_PREFIX);
  var _FONT_WEIGHT_TO_PREFIX = _objectSpread2({}, gt);
  var FONT_WEIGHT_TO_PREFIX = familyProxy(_FONT_WEIGHT_TO_PREFIX);
  var RESERVED_CLASSES = [].concat(_toConsumableArray(Ht), _toConsumableArray(to));

  function bunker(fn) {
    try {
      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }
      fn.apply(void 0, args);
    } catch (e) {
      if (!PRODUCTION) {
        throw e;
      }
    }
  }

  var w$2 = WINDOW || {};
  if (!w$2[NAMESPACE_IDENTIFIER]) w$2[NAMESPACE_IDENTIFIER] = {};
  if (!w$2[NAMESPACE_IDENTIFIER].styles) w$2[NAMESPACE_IDENTIFIER].styles = {};
  if (!w$2[NAMESPACE_IDENTIFIER].hooks) w$2[NAMESPACE_IDENTIFIER].hooks = {};
  if (!w$2[NAMESPACE_IDENTIFIER].shims) w$2[NAMESPACE_IDENTIFIER].shims = [];
  var namespace = w$2[NAMESPACE_IDENTIFIER];

  function normalizeIcons(icons) {
    return Object.keys(icons).reduce(function (acc, iconName) {
      var icon = icons[iconName];
      var expanded = !!icon.icon;
      if (expanded) {
        acc[icon.iconName] = icon.icon;
      } else {
        acc[iconName] = icon;
      }
      return acc;
    }, {});
  }
  function defineIcons(prefix, icons) {
    var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    var _params$skipHooks = params.skipHooks,
      skipHooks = _params$skipHooks === void 0 ? false : _params$skipHooks;
    var normalized = normalizeIcons(icons);
    if (typeof namespace.hooks.addPack === 'function' && !skipHooks) {
      namespace.hooks.addPack(prefix, normalizeIcons(icons));
    } else {
      namespace.styles[prefix] = _objectSpread2(_objectSpread2({}, namespace.styles[prefix] || {}), normalized);
    }

    /**
     * Font Awesome 4 used the prefix of `fa` for all icons. With the introduction
     * of new styles we needed to differentiate between them. Prefix `fa` is now an alias
     * for `fas` so we'll ease the upgrade process for our users by automatically defining
     * this as well.
     */
    if (prefix === 'fas') {
      defineIcons('fa', icons);
    }
  }

  var icons = {
    "0": [320, 512, [], "30", ["", "M0 192C0 103.6 71.6 32 160 32s160 71.6 160 160l0 128c0 88.4-71.6 160-160 160S0 408.4 0 320L0 192zM160 48C80.5 48 16 112.5 16 192l0 128c0 79.5 64.5 144 144 144s144-64.5 144-144l0-128c0-79.5-64.5-144-144-144z"]],
    "1": [256, 512, [], "31", ["", "M8 32c-4.4 0-8 3.6-8 8s3.6 8 8 8l112 0 0 416-112 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l240 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-112 0 0-424c0-4.4-3.6-8-8-8L8 32z"]],
    "2": [384, 512, [], "32", ["", "M48 40c0-4.4 3.6-8 8-8l203.3 0c55.6 0 100.7 45.1 100.7 100.7 0 39.3-22.8 75-58.5 91.4L117.7 308.9C75.2 328.6 48 371.1 48 417.9l0 46.1 296 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L40 480c-4.4 0-8-3.6-8-8l0-54.1c0-53 30.8-101.3 79-123.5l183.8-84.8c30-13.8 49.2-43.9 49.2-76.9 0-46.8-37.9-84.7-84.7-84.7L56 48c-4.4 0-8-3.6-8-8z"]],
    "3": [320, 512, [], "33", ["", "M56 264c-4.4 0-8-3.6-8-8s3.6-8 8-8l148 0c55.2 0 100-44.8 100-100S259.2 48 204 48L16 48c-4.4 0-8-3.6-8-8s3.6-8 8-8l188 0c64.1 0 116 51.9 116 116 0 49.1-30.5 91.1-73.6 108 43.1 16.9 73.6 58.9 73.6 108 0 64.1-51.9 116-116 116L8 480c-4.4 0-8-3.6-8-8s3.6-8 8-8l196 0c55.2 0 100-44.8 100-100S259.2 264 204 264L56 264z"]],
    "4": [384, 512, [], "34", ["", "M16 40c0-4.4-3.6-8-8-8s-8 3.6-8 8L0 288c0 35.3 28.7 64 64 64l240 0 0 120c0 4.4 3.6 8 8 8s8-3.6 8-8l0-120 56 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-56 0 0-296c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 296-240 0c-26.5 0-48-21.5-48-48L16 40z"]],
    "5": [320, 512, [], "35", ["", "M0 40c0-4.4 3.6-8 8-8l272 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-264 0 0 176 176 0c70.7 0 128 57.3 128 128S262.7 480 192 480L8 480c-4.4 0-8-3.6-8-8s3.6-8 8-8l184 0c61.9 0 112-50.1 112-112S253.9 240 192 240L8 240c-4.4 0-8-3.6-8-8L0 40z"]],
    "6": [384, 512, [], "36", ["", "M280 32c4.4 0 8 3.6 8 8s-3.6 8-8 8L144 48C82.1 48 32 98.1 32 160l0 125c22.4-41.1 65.9-69 116-69l72 0c72.9 0 132 59.1 132 132S292.9 480 220 480l-72 0c-71.1 0-129.1-56.3-131.9-126.7-.1-.4-.1-.9-.1-1.3l0-192C16 89.3 73.3 32 144 32l136 0zM32 348c0 64.1 51.9 116 116 116l72 0c64.1 0 116-51.9 116-116S284.1 232 220 232l-72 0C83.9 232 32 283.9 32 348z"]],
    "7": [320, 512, [], "37", ["", "M0 40c0-4.4 3.6-8 8-8l304 0c2.9 0 5.6 1.6 7 4.1s1.3 5.7-.2 8.1l-272 432c-2.4 3.7-7.3 4.9-11 2.5s-4.9-7.3-2.5-11L297.5 48 8 48c-4.4 0-8-3.6-8-8z"]],
    "8": [320, 512, [], "38", ["", "M296 148c0-64.1-51.9-116-116-116l-40 0C75.9 32 24 83.9 24 148 24 193.2 49.9 232.4 87.6 251.5 37.3 264.2 0 309.7 0 364 0 428.1 51.9 480 116 480l88 0c64.1 0 116-51.9 116-116 0-54.3-37.3-99.8-87.6-112.5 37.7-19.1 63.6-58.3 63.6-103.5zM180.1 264l23.9 0c55.2 0 100 44.8 100 100S259.2 464 204 464l-88 0C60.8 464 16 419.2 16 364S60.8 264 116 264l64.1 0zm0-16l-40.1 0C84.7 248 40 203.2 40 148 40 92.8 84.8 48 140 48l40 0c55.2 0 100 44.8 100 100 0 55.2-44.7 100-99.9 100z"]],
    "9": [384, 512, [], "39", ["", "M352 168l0 184c0 70.7-57.3 128-128 128L88 480c-4.4 0-8-3.6-8-8s3.6-8 8-8l136 0c61.9 0 112-50.1 112-112l0-119.9C313.1 274.9 267.9 304 216 304l-64 0C76.9 304 16 243.1 16 168S76.9 32 152 32l64 0c71.6 0 130.2 55.3 135.6 125.5 .3 .8 .4 1.6 .4 2.5l0 8zm-16 0c0-66.3-53.7-120-120-120l-64 0C85.7 48 32 101.7 32 168S85.7 288 152 288l64 0c66.3 0 120-53.7 120-120z"]],
    "chess-pawn-piece": [320, 512, ["chess-pawn-alt"], "f444", ["M32 476.5c0 10.8 8.7 19.5 19.5 19.5l216.9 0c9.4 0 17.3-6.7 19.1-15.6l.4-3.9c0-3.3-.8-6.6-2.4-9.4l-1.8-2.7-51.7-64.7 0 .4-144 0 0-.4-51.7 64.7c-2.8 3.5-4.3 7.8-4.3 12.2zM80 128c0 26.2 12.7 49.4 32.2 64l95.7 0c19.5-14.6 32.2-37.8 32.2-64 0-44.2-35.8-80-80-80S80 83.8 80 128zM96.1 384l127.9 0-14.7-176-98.6 0-14.7 176z", "M160 32c53 0 96 43 96 96 0 24.6-9.3 47-24.5 64l.5 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-6.7 0 14.7 176 56.2 70.3c5 6.3 7.8 14.1 7.8 22.2 0 19.6-15.9 35.5-35.5 35.5L51.5 512c-19.6 0-35.5-15.9-35.5-35.5 0-8.1 2.7-15.9 7.8-22.2L80 384 94.7 208 88 208c-4.4 0-8-3.6-8-8s3.6-8 8-8l.5 0c-15.2-17-24.5-39.4-24.5-64 0-53 43-96 96-96zm72 368l-144 0 0-.4-51.7 64.7c-2.8 3.5-4.3 7.8-4.3 12.2 0 10.8 8.7 19.5 19.5 19.5l216.9 0c9.4 0 17.3-6.7 19.1-15.6l.4-3.9c0-3.3-.8-6.6-2.4-9.4l-1.8-2.7-51.7-64.7 0 .4zM96.1 384l127.9 0-14.7-176-98.6 0-14.7 176zM160 48c-44.2 0-80 35.8-80 80 0 26.2 12.7 49.4 32.2 64l95.7 0c19.5-14.6 32.2-37.8 32.2-64 0-44.2-35.8-80-80-80z"]],
    "dollar-sign": [320, 512, [128178, 61781, "dollar", "usd"], "24", ["", "M152 8c0-4.4 3.6-8 8-8s8 3.6 8 8l0 56 96 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-96 0 0 0-8 0-47 0c-44.7 0-80.9 36.2-80.9 80.9 0 41 30.7 75.6 71.5 80.4l114.9 13.5c48.8 5.7 85.6 47.1 85.6 96.3 0 53.5-43.4 96.9-96.9 96.9l-39.1 0 0 56c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-56-112 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l167.1 0c44.7 0 80.9-36.2 80.9-80.9 0-41-30.7-75.6-71.5-80.4L101.6 257.2C52.8 251.4 16 210.1 16 160.9 16 107.4 59.4 64 112.9 64l39.1 0 0-56z"]],
    "layer-plus": [512, 512, ["layer-group-plus"], "f5ff", ["M16.3 224c0 3.4 1.6 6 4.4 7.3l218.6 101c10.6 4.9 22.9 4.9 33.6 0l218.6-101c2.7-1.3 4.4-3.9 4.4-7.3s-1.6-6-4.4-7.3l-218.6-101c-10.6-4.9-22.9-4.9-33.6 0L20.6 216.7c-2.7 1.3-4.4 3.9-4.4 7.3zm0 160c0 3.4 1.6 6 4.4 7.3l218.6 101c10.6 4.9 22.9 4.9 33.6 0l218.6-101c2.7-1.3 4.4-3.9 4.4-7.3s-1.6-6-4.4-7.3l-81.1-37.5c-36.9 17-73.7 34.1-110.6 51.1-27.7 12.8-59.6 12.8-87.3 0-36.9-17-73.7-34.1-110.6-51.1L20.6 376.7c-2.7 1.3-4.4 3.9-4.4 7.3z", "M440-24l0 64 64 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-64 0 0 64c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-64-64 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l64 0 0-64c0-4.4 3.6-8 8-8s8 3.6 8 8zM239.2 115.7L20.6 216.7c-2.7 1.3-4.4 3.9-4.4 7.3s1.6 6 4.4 7.3l218.6 101c10.6 4.9 22.9 4.9 33.6 0l218.6-101c2.7-1.3 4.4-3.9 4.4-7.3s-1.6-6-4.4-7.3l-218.6-101c-10.6-4.9-22.9-4.9-33.6 0zm-6.7-14.5c14.9-6.9 32.1-6.9 47 0l218.6 101c18.2 8.4 18.2 35.2 0 43.6l-218.6 101c-14.9 6.9-32.1 6.9-47 0L13.9 245.8c-18.2-8.4-18.2-35.2 0-43.6l218.6-101zM13.9 362.2l68.7-31.8 19.1 8.8-81.1 37.5c-2.7 1.3-4.4 3.9-4.4 7.3s1.6 6 4.4 7.3l218.6 101c10.6 4.9 22.9 4.9 33.6 0l218.6-101c2.7-1.3 4.4-3.9 4.4-7.3s-1.6-6-4.4-7.3l-81.1-37.5 19.1-8.8 68.7 31.8c18.2 8.4 18.2 35.2 0 43.6l-218.6 101c-14.9 6.9-32.1 6.9-47 0L13.9 405.8c-18.2-8.4-18.2-35.2 0-43.6z"]],
    "grid-4": [448, 512, [], "e198", ["M16 48l0 48 48 0 0-48-48 0zm0 122.7l0 48 48 0 0-48-48 0zm0 122.7l0 48 48 0 0-48-48 0zM16 416l0 48 48 0 0-48-48 0zM138.7 48l0 48 48 0 0-48-48 0zm0 122.7l0 48 48 0 0-48-48 0zm0 122.7l0 48 48 0 0-48-48 0zm0 122.7l0 48 48 0 0-48-48 0zM261.3 48l0 48 48 0 0-48-48 0zm0 122.7l0 48 48 0 0-48-48 0zm0 122.7l0 48 48 0 0-48-48 0zm0 122.7l0 48 48 0 0-48-48 0zM384 48l0 48 48 0 0-48-48 0zm0 122.7l0 48 48 0 0-48-48 0zm0 122.7l0 48 48 0 0-48-48 0zM384 416l0 48 48 0 0-48-48 0z", "M16 32C7.2 32 0 39.2 0 48L0 96c0 8.8 7.2 16 16 16l48 0c8.8 0 16-7.2 16-16l0-48c0-8.8-7.2-16-16-16L16 32zM64 48l0 48-48 0 0-48 48 0zM16 154.7c-8.8 0-16 7.2-16 16l0 48c0 8.8 7.2 16 16 16l48 0c8.8 0 16-7.2 16-16l0-48c0-8.8-7.2-16-16-16l-48 0zm48 16l0 48-48 0 0-48 48 0zM16 277.3c-8.8 0-16 7.2-16 16l0 48c0 8.8 7.2 16 16 16l48 0c8.8 0 16-7.2 16-16l0-48c0-8.8-7.2-16-16-16l-48 0zm48 16l0 48-48 0 0-48 48 0zM0 416c0-8.8 7.2-16 16-16l48 0c8.8 0 16 7.2 16 16l0 48c0 8.8-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16l0-48zm16 0l0 48 48 0 0-48-48 0zm106.7 0c0-8.8 7.2-16 16-16l48 0c8.8 0 16 7.2 16 16l0 48c0 8.8-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16l0-48zm16 0l0 48 48 0 0-48-48 0zm122.7-16c-8.8 0-16 7.2-16 16l0 48c0 8.8 7.2 16 16 16l48 0c8.8 0 16-7.2 16-16l0-48c0-8.8-7.2-16-16-16l-48 0zm48 16l0 48-48 0 0-48 48 0zm58.7 0c0-8.8 7.2-16 16-16l48 0c8.8 0 16 7.2 16 16l0 48c0 8.8-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16l0-48zm16 0l0 48 48 0 0-48-48 0zM122.7 293.3c0-8.8 7.2-16 16-16l48 0c8.8 0 16 7.2 16 16l0 48c0 8.8-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16l0-48zm16 0l0 48 48 0 0-48-48 0zm122.7-16c-8.8 0-16 7.2-16 16l0 48c0 8.8 7.2 16 16 16l48 0c8.8 0 16-7.2 16-16l0-48c0-8.8-7.2-16-16-16l-48 0zm48 16l0 48-48 0 0-48 48 0zm58.7 0c0-8.8 7.2-16 16-16l48 0c8.8 0 16 7.2 16 16l0 48c0 8.8-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16l0-48zm16 0l0 48 48 0 0-48-48 0zM122.7 170.7c0-8.8 7.2-16 16-16l48 0c8.8 0 16 7.2 16 16l0 48c0 8.8-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16l0-48zm16 0l0 48 48 0 0-48-48 0zm122.7-16c-8.8 0-16 7.2-16 16l0 48c0 8.8 7.2 16 16 16l48 0c8.8 0 16-7.2 16-16l0-48c0-8.8-7.2-16-16-16l-48 0zm48 16l0 48-48 0 0-48 48 0zm58.7 0c0-8.8 7.2-16 16-16l48 0c8.8 0 16 7.2 16 16l0 48c0 8.8-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16l0-48zm16 0l0 48 48 0 0-48-48 0zM122.7 48c0-8.8 7.2-16 16-16l48 0c8.8 0 16 7.2 16 16l0 48c0 8.8-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16l0-48zm16 0l0 48 48 0 0-48-48 0zM261.3 32c-8.8 0-16 7.2-16 16l0 48c0 8.8 7.2 16 16 16l48 0c8.8 0 16-7.2 16-16l0-48c0-8.8-7.2-16-16-16l-48 0zm48 16l0 48-48 0 0-48 48 0zM368 48c0-8.8 7.2-16 16-16l48 0c8.8 0 16 7.2 16 16l0 48c0 8.8-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16l0-48zm16 0l0 48 48 0 0-48-48 0z"]],
    "dog": [576, 512, [128021], "f6d3", ["M80 176l0 296c0 13.3 10.7 24 24 24l32 0c13.3 0 24-10.7 24-24l0-128c0-2.6 1.3-5.1 3.5-6.6s5-1.8 7.5-.8l32.5 13c28.6 11.4 60.5 11.4 89.1 0l32.5-13c2.5-1 5.3-.7 7.5 .8s3.5 4 3.5 6.6l0 128c0 13.3 10.7 24 24 24l32 0c13.3 0 24-10.7 24-24L416 228.9 310.1 176 80 176zm241.3-12.3l97.4 48.7 13.6-54.3 1.1-2.4c1.4-2.2 3.9-3.6 6.7-3.6l48 0c39.8 0 72-32.2 72-72l0-24c0-4.4-3.6-8-8-8l-56 0c-2.1 0-4.2-.8-5.7-2.3L477.1 32.4C466.6 21.9 452.3 16 437.5 16l-79.3 0-37 147.7zM448 64a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M361.9-31.7c3.8 .9 6.2 4.4 6.1 8.1l-.2 1.6-5.5 22.1 75.3 0c19.1 0 37.4 7.6 50.9 21.1L499.3 32 552 32c13.3 0 24 10.7 24 24l0 24c0 48.6-39.4 88-88 88l-41.8 0-14.2 56.9 0 247.1c0 22.1-17.9 40-40 40l-32 0c-22.1 0-40-17.9-40-40l0-116.2-21.5 8.6c-30.4 12.2-64.1 12.9-94.9 2.3l-6.1-2.3-21.5-8.6 0 116.2c0 22.1-17.9 40-40 40l-32 0c-22.1 0-40-17.9-40-40l0-296.5c-36-4-64-34.4-64-71.5 0-4.4 3.6-8 8-8s8 3.6 8 8c0 29 22 52.8 50.3 55.7l5.7 .3 233.8 0 46.5-185.9 .5-1.5c1.6-3.4 5.4-5.2 9.2-4.3zM80 472c0 13.3 10.7 24 24 24l32 0c13.3 0 24-10.7 24-24l0-128c0-2.6 1.3-5.1 3.5-6.6s5-1.8 7.5-.8l32.5 13c28.6 11.4 60.5 11.4 89.1 0l32.5-13c2.5-1 5.3-.7 7.5 .8s3.5 4 3.5 6.6l0 128c0 13.3 10.7 24 24 24l32 0c13.3 0 24-10.7 24-24l0-243.1-105.9-52.9-230.1 0 0 296zM321.3 163.7l97.4 48.7 13.6-54.3 1.1-2.4c1.4-2.2 3.9-3.6 6.7-3.6l48 0c39.8 0 72-32.2 72-72l0-24c0-4.4-3.6-8-8-8l-56 0c-2.1 0-4.2-.8-5.7-2.3L477.1 32.4C466.6 21.9 452.3 16 437.5 16l-79.3 0-37 147.7zM432 80a16 16 0 1 1 0-32 16 16 0 1 1 0 32z"]],
    "truck-moving": [640, 512, [], "f4df", ["M16 96l0 277.4c15.9-22.6 42.2-37.4 72-37.4 35.5 0 66.1 21 80 51.3 13.9-30.3 44.5-51.3 80-51.3 48.6 0 88 39.4 88 88 0 2.7-.1 5.4-.4 8l96.7 0c-.2-2.6-.4-5.3-.4-8 0-27.3 12.5-51.7 32-67.9L464 96c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96zM480 272l0 73.6c12-6.1 25.6-9.6 40-9.6 47.2 0 85.7 37.2 87.9 83.9 9.9-8.8 16.1-21.6 16.1-35.9l0-112-144 0z", "M64 48l352 0c26.5 0 48 21.5 48 48l0 260.1c-19.5 16.1-32 40.6-32 67.9 0 2.7 .1 5.4 .4 8l-96.7 0c.2-2.6 .4-5.3 .4-8 0-48.6-39.4-88-88-88-35.5 0-66.1 21-80 51.3-13.9-30.3-44.5-51.3-80-51.3-29.8 0-56.1 14.8-72 37.4L16 96c0-26.5 21.5-48 48-48zM0 384l0 40c0 48.6 39.4 88 88 88 35.5 0 66.1-21 80-51.3 13.9 30.3 44.5 51.3 80 51.3 40.3 0 74.2-27.1 84.7-64l102.6 0c10.4 36.9 44.4 64 84.7 64 43 0 78.9-30.9 86.5-71.7 20-10.8 33.5-32 33.5-56.3l0-164.1c0-14.9-5.9-29.1-16.4-39.6l-35.9-35.9C577.2 133.9 563 128 548.1 128l-68.1 0 0-32c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 384zm480-38.4l0-73.6 144 0 0 112c0 14.3-6.2 27.1-16.1 35.9-2.2-46.7-40.7-83.9-87.9-83.9-14.4 0-28 3.5-40 9.6zM624 256l-144 0 0-112 68.1 0c10.6 0 20.8 4.2 28.3 11.7l35.9 35.9c7.5 7.5 11.7 17.7 11.7 28.3l0 36.1zM88 352a72 72 0 1 1 0 144 72 72 0 1 1 0-144zm360 72a72 72 0 1 1 144 0 72 72 0 1 1 -144 0zM248 352a72 72 0 1 1 0 144 72 72 0 1 1 0-144z"]],
    "rotate": [512, 512, [128260, "sync-alt"], "f2f1", ["M16 376l0 112c0 3.2 1.9 6.2 4.9 7.4s6.4 .6 8.7-1.7l112-112c2.3-2.3 3-5.7 1.7-8.7s-4.2-4.9-7.4-4.9L24 368c-4.4 0-8 3.6-8 8zM368.6 139.1c1.2 3 4.2 4.9 7.4 4.9l112 0c4.4 0 8-3.6 8-8l0-112c0-3.2-1.9-6.2-4.9-7.4s-6.4-.6-8.7 1.7l-112 112c-2.3 2.3-3 5.7-1.7 8.7z", "M376 144c-3.2 0-6.2-1.9-7.4-4.9s-.6-6.4 1.7-8.7l112-112c2.3-2.3 5.7-3 8.7-1.7S496 20.8 496 24l0 112c0 4.4-3.6 8-8 8l-112 0zm0 16l112 0c13.3 0 24-10.7 24-24l0-112c0-9.7-5.8-18.5-14.8-22.2S477.9 .2 471 7L419.3 58.8C318.7-24.7 169.2-19.3 75 75 27.1 122.8 2.2 184.9 .1 247.6 0 252 3.5 255.7 7.9 255.9s8.1-3.3 8.3-7.7c1.9-58.8 25.3-117 70.2-161.9 88-88 227.3-93.4 321.6-16.1L359 119c-6.9 6.9-8.9 17.2-5.2 26.2S366.3 160 376 160zM136 368c3.2 0 6.2 1.9 7.4 4.9s.6 6.4-1.7 8.7l-112 112c-2.3 2.3-5.7 3-8.7 1.7S16 491.2 16 488l0-112c0-4.4 3.6-8 8-8l112 0zm0-16L24 352c-13.3 0-24 10.7-24 24L0 488c0 9.7 5.8 18.5 14.8 22.2S34.1 511.8 41 505l51.8-51.8c100.6 83.5 250 78.1 344.3-16.2 47.8-47.8 72.8-109.9 74.8-172.6 .1-4.4-3.3-8.1-7.7-8.3s-8.1 3.3-8.3 7.7c-1.9 58.8-25.3 117-70.2 161.8-88 88-227.3 93.4-321.6 16.1L153 393c6.9-6.9 8.9-17.2 5.2-26.2S145.7 352 136 352z"]],
    "arrow-u-turn-up-left": [512, 512, [], "e7ed", ["", "M138.3-13.7l-136 136c-3.1 3.1-3.1 8.2 0 11.3l136 136c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3L27.3 136 332 136c90.6 0 164 73.4 164 164S422.6 464 332 464L72 464c-4.3 .4-8 3.3-8 8s3.7 7.6 8 8l260 0c99.4 0 180-80.6 180-180S431.4 120 332 120L27.3 120 149.7-2.3c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0z"]],
    "keyboard-brightness": [640, 512, [], "e1c0", ["", "M101.7 178.3c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l104 104c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-104-104zM312 240c0 4.4 3.6 8 8 8s8-3.6 8-8l0-144c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 144zm122.3 42.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l104-104c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0l-104 104zM0 408c0 4.4 3.6 8 8 8l112 0c4.4 0 8-3.6 8-8s-3.6-8-8-8L8 400c-4.4 0-8 3.6-8 8zm200-8c-4.4 0-8 3.6-8 8s3.6 8 8 8l240 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-240 0zm320 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l112 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-112 0z"]],
    "tent-double-peak": [576, 512, [], "e627", ["M16 189.7l0 50.3 544 0 0-50.3c0-11.9-6.9-23.5-18.3-30.5-33.7-20.8-78.9-56-113.1-110.3-.2-.3-.9-1.1-2.6-1.1s-2.6 .6-2.9 .9c-23 28.9-70.9 77.9-135.2 77.9s-112.2-49-135.2-77.9c-.3-.3-1.2-1-2.9-.9s-2.4 .8-2.6 1.1c-34.2 54.3-79.4 89.5-113.1 110.3-11.4 7-18.3 18.6-18.3 30.5zM16 256l0 192c0 26.5 21.5 48 48 48l208 0 0-240-256 0zm281 0l123.9 240 91.1 0c26.5 0 48-21.5 48-48l0-192-263 0z", "M541.7 159.2c-33.7-20.8-78.9-56-113.1-110.3-.2-.3-.9-1.1-2.6-1.1s-2.6 .6-2.9 .9c-23 28.9-70.9 77.9-135.2 77.9s-112.2-49-135.2-77.9c-.3-.3-1.2-1-2.9-.9s-2.4 .8-2.6 1.1c-34.2 54.3-79.4 89.5-113.1 110.3-11.4 7-18.3 18.6-18.3 30.5l0 50.3 544 0 0-50.3c0-11.9-6.9-23.5-18.3-30.5zM560 256l-263 0 123.9 240 91.1 0c26.5 0 48-21.5 48-48l0-192zm-272 0l0 0zm-16 0l-256 0 0 192c0 26.5 21.5 48 48 48l208 0 0-240zm16 240L402.9 496 288 273.4 288 496zM25.9 145.6c32.3-19.9 75.4-53.6 107.9-105.2 6.8-10.8 23.6-11.6 31.6-1.6 22.6 28.4 66.3 71.8 122.6 71.8S388 67.2 410.6 38.7c7.9-10 24.8-9.1 31.6 1.6 32.5 51.6 75.6 85.3 107.9 105.2 15.5 9.5 25.9 25.9 25.9 44.1L576 448c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 189.7c0-18.2 10.4-34.6 25.9-44.1z"]],
    "square-minus": [448, 512, [61767, "minus-square"], "f146", ["M16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96zm96 160c0-4.4 3.6-8 8-8l208 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-208 0c-4.4 0-8-3.6-8-8z", "M64 48C37.5 48 16 69.5 16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM120 248l208 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-208 0c-4.4 0-8-3.6-8-8s3.6-8 8-8z"]],
    "water-arrow-up": [512, 512, ["water-rise"], "f775", ["M0 359.8c0 42.4 0 84.8 0 127.3 0-4.1 3.1-7.6 7.3-8 22.2-2 44.5-13.6 65.7-28.7 34.3-24.5 80.6-24.5 115 0 25.4 18.1 47.2 29.6 68.1 29.6s42.7-11.5 68.1-29.6c34.3-24.5 80.6-24.5 115 0 21.2 15.1 43.4 26.7 65.7 28.7 4.1 .4 7.2 3.8 7.3 8l0-127.9c0 .2 0 .4 0 .6-.4 4.4-4.3 7.6-8.7 7.2-26.5-2.4-51.5-15.9-73.5-31.6-28.8-20.5-67.6-20.5-96.4 0-25.5 18.2-51 32.6-77.4 32.6s-51.9-14.4-77.4-32.6c-28.8-20.5-67.6-20.5-96.4 0-22 15.7-47 29.2-73.5 31.6-4.4 .4-8.3-2.8-8.7-7.2zm324.1-37.4c34.3-24.5 80.6-24.5 115.8 .6l-.8-.6c-34.3-24.5-80.6-24.5-115 0z", "M264 232c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-204.7-74.3 74.3c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l88-88c3.1-3.1 8.2-3.1 11.3 0l88 88c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L264 27.3 264 232zM429.8 335.4c-28.8-20.5-67.6-20.5-96.4 0-25.5 18.2-51 32.6-77.4 32.6s-51.9-14.4-77.4-32.6c-28.8-20.5-67.6-20.5-96.4 0-22 15.7-47 29.2-73.5 31.6-4.4 .4-8.3-2.8-8.7-7.2s2.8-8.3 7.2-8.7c22.2-2 44.5-13.6 65.7-28.7 34.3-24.5 80.6-24.5 115 0 25.4 18.1 47.2 29.6 68.1 29.6s42.7-11.5 68.1-29.6c34.3-24.5 80.6-24.5 115 0 21.2 15.1 43.4 26.7 65.7 28.7 4.4 .4 7.6 4.3 7.2 8.7s-4.3 7.6-8.7 7.2c-26.5-2.4-51.5-15.9-73.5-31.6zm0 128c-28.8-20.5-67.6-20.5-96.4 0-25.5 18.2-51 32.6-77.4 32.6s-51.9-14.4-77.4-32.6c-28.8-20.5-67.6-20.5-96.4 0-22 15.7-47 29.2-73.5 31.6-4.4 .4-8.3-2.8-8.7-7.2s2.8-8.3 7.2-8.7c22.2-2 44.5-13.6 65.7-28.7 34.3-24.5 80.6-24.5 115 0 25.4 18.1 47.2 29.6 68.1 29.6s42.7-11.5 68.1-29.6c34.3-24.5 80.6-24.5 115 0 21.2 15.1 43.4 26.7 65.7 28.7 4.4 .4 7.6 4.3 7.2 8.7s-4.3 7.6-8.7 7.2c-26.5-2.4-51.5-15.9-73.5-31.6z"]],
    "xmark-to-slot": [576, 512, ["times-to-slot", "vote-nay"], "f771", ["M112 96l0 224c0 26.5 21.5 48 48 48l256 0c26.5 0 48-21.5 48-48l0-224c0-26.5-21.5-48-48-48L160 48c-26.5 0-48 21.5-48 48zm97.7 116.9c-2.7-3.5-2.1-8.5 1.4-11.2s8.5-2.1 11.2 1.4l48.9 62.9 82-134.1c2.3-3.8 7.2-5 11-2.7s5 7.2 2.7 11l-88 144c-1.4 2.2-3.8 3.7-6.4 3.8s-5.2-1-6.8-3.1l-56-72z", "M416 48c26.5 0 48 21.5 48 48l0 224c0 26.5-21.5 48-48 48l-256 0c-26.5 0-48-21.5-48-48l0-224c0-26.5 21.5-48 48-48l256 0zM160 32c-35.3 0-64 28.7-64 64l0 224c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-224c0-35.3-28.7-64-64-64L160 32zM8 288c-4.4 0-8 3.6-8 8L0 424c0 30.9 25.1 56 56 56l464 0c30.9 0 56-25.1 56-56l0-128c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 128c0 22.1-17.9 40-40 40L56 464c-22.1 0-40-17.9-40-40l0-128c0-4.4-3.6-8-8-8zM366.8 140.2c2.3-3.8 1.1-8.7-2.7-11s-8.7-1.1-11 2.7l-82 134.1-48.9-62.9c-2.7-3.5-7.7-4.1-11.2-1.4s-4.1 7.7-1.4 11.2l56 72c1.6 2.1 4.1 3.2 6.8 3.1s5-1.6 6.4-3.8l88-144z"]],
    "sensor-cloud": [576, 512, ["sensor-smoke"], "e02c", ["M80 96c0-26.5 21.5-48 48-48l320 0c26.5 0 48 21.5 48 48l0 175.4c-12.4-4.8-25.9-7.4-40-7.4-5.8 0-11.4 .4-17 1.3-22.2-15.9-49.5-25.3-79-25.3-68.7 0-125.5 50.9-134.7 117.1-30 24.2-49.3 61.2-49.3 102.9 0 1.3 0 2.7 .1 4L128 464c-26.5 0-48-21.5-48-48L80 96zm64 40l0 112c0 4.4 3.6 8 8 8s8-3.6 8-8l0-112c0-4.4-3.6-8-8-8s-8 3.6-8 8zm64 0l0 112c0 4.4 3.6 8 8 8s8-3.6 8-8l0-112c0-4.4-3.6-8-8-8s-8 3.6-8 8z", "M128 48l320 0c26.5 0 48 21.5 48 48l0 175.4c5.6 2.1 10.9 4.7 16 7.6l0-183c0-35.3-28.7-64-64-64L128 32C92.7 32 64 60.7 64 96l0 320c0 35.3 28.7 64 64 64l49.5 0c-.8-5.2-1.3-10.6-1.4-16L128 464c-26.5 0-48-21.5-48-48L80 96c0-26.5 21.5-48 48-48zm32 88c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 112c0 4.4 3.6 8 8 8s8-3.6 8-8l0-112zm64 0c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 112c0 4.4 3.6 8 8 8s8-3.6 8-8l0-112zm64.9 251.6c-7-42.8 27.3-83.6 71.1-83.6 22.5 0 42.6 10.3 55.8 26.5 2.3 2.8 6.2 3.7 9.4 2.3 36.4-16.2 80.3 13 78.7 53.5-.2 3.7 2.3 7.1 5.9 8 28.9 7.8 50.1 34.3 50.1 65.6 0 37.5-30.4 67.9-67.9 67.9l-184.2 0c-37.5 0-67.9-30.4-67.9-67.9 0-29 18.2-53.9 43.9-63.6 3.6-1.3 5.7-5 5.1-8.8zM360 288c-51.5 0-92 45.8-87.6 95.9-28.6 13.4-48.4 42.4-48.4 76.1 0 46.3 37.6 83.9 83.9 83.9l184.2 0c46.3 0 83.9-37.6 83.9-83.9 0-36.6-23.4-67.7-56.1-79.2-2.2-47.2-51.6-79.9-95.6-64.8-16.1-17.2-39-28-64.4-28z"]],
    "lychee": [512, 512, [], "e824", ["M17 284.5c2.1 5.9 4.4 11.6 6.8 17.3l1 2.3c3.5 8 1.9 15.1 .4 19.5-1.4 4.1-3.1 8.1-4.7 12-1.4 3.3-2.7 6.5-3.8 9.6-1 3.1-.5 6.9 2.3 11 4.3 5.3 9 10.2 14.1 15.3 6 5.8 7.5 13.2 7.9 17.9 .2 3.3 .2 6.7 .2 10 0 4.8-.1 9.5 .7 14.3 .7 2.7 2.6 5.5 6.2 7.8 2.3 1.2 4.8 2.1 7.7 3.3 1.5 .6 3.2 1.2 5 2 4.8 2 10.3 5.2 14.7 9.7 4.5 4.4 7.7 9.9 9.7 14.7 .7 1.8 1.4 3.5 2 5 1.1 2.9 2.1 5.4 3.3 7.7 2.3 3.6 5.1 5.6 7.8 6.2 4.7 .7 9.5 .7 14.3 .7 3.4 0 6.7 0 10 .2 4.8 .3 12.1 1.9 17.9 7.9 5.2 5.1 10.1 9.8 15.3 14.1 4.1 2.8 7.9 3.3 11 2.3 3.1-1.1 6.3-2.4 9.6-3.8 3.9-1.6 7.9-3.2 12-4.7 4.3-1.5 11.5-3 19.5 .4l2.3 1c5.7 2.4 11.5 4.7 17.3 6.8 4.8 1.3 8.6 .6 11.2-1.3 2.2-1.6 4.4-3.4 6.7-5.1 3.8-3 7.7-6.1 12-8.9 5.4-4 13.1-5.6 19.6-4.3 7.1 1.3 14 2.5 21 3.4 5.1 .3 8.6-1 10.8-3.4 1.9-2.1 3.8-4.3 5.7-6.5 3.1-3.6 6.3-7.3 9.9-10.9 4.9-4.9 11.7-8 18.6-8l2.2 0c6.4-.1 12.8-.2 19.2-.5 4.9-.7 8-2.7 9.8-5.4 1.5-2.4 3-5 4.5-7.7 2.3-4.1 4.8-8.4 7.5-12.6 2.8-4 8.1-9.6 16.4-11.3 6.9-1.5 13.6-3.1 20.2-4.9 4.8-1.7 7.5-4.4 8.6-7.6 .9-2.9 1.8-6 2.7-9.2 1.2-4.3 2.5-8.8 4-13.2 1.7-4.5 5.2-11.3 12.9-15.1 6.3-3.4 12.3-6.7 18.1-10.4 4-3 5.6-6.5 5.7-9.7 0-3.2-.2-6.5-.5-9.9-.3-4.2-.5-8.5-.5-13 0-4.7 1-12.3 6.8-18.7 4.7-5.5 9.1-10.6 13.1-16.1 2.5-4.3 2.8-8.1 1.6-11.1-1.4-3.5-3.1-7-4.9-10.7-2.2-4.4-4.4-9-6.1-13.7-1.2-4.3-1.9-9.8 .1-15.8 .4-1.2 .8-2.4 1.2-3.6 1.8-5.6 3.2-9.8 3.2-14.4 0-10.1-3-16.7-7.7-22-5.2-5.9-13-11-24-16.6-4.5-2.3-9.2-4.4-14.2-6.8l-3.3-1.5c-6.2-2.9-12.9-6-19.5-9.5-14.1-7.4-28.2-16.5-39.5-27.8S360.5 106 353.1 91.9c-3.5-6.6-6.6-13.3-9.5-19.5l-1.5-3.3c-2.3-5-4.5-9.7-6.8-14.2-5.6-11-10.7-18.9-16.6-24-5.3-4.7-11.9-7.7-22-7.7-4.6 0-8.8 1.4-14.4 3.2-1.1 .4-2.3 .8-3.6 1.2-6 2-11.6 1.3-15.8 .1-4.7-1.7-9.3-3.9-13.7-6.1-3.7-1.8-7.2-3.5-10.7-4.9-3-1.2-6.8-.9-11.1 1.6-5.5 3.9-10.7 8.3-16.1 13.1-6.3 5.8-14 6.8-18.7 6.8-4.5 0-8.8-.3-13-.5-3.4-.2-6.7-.4-9.9-.5-3.2 .1-6.6 1.7-9.7 5.7-3.7 5.8-7 11.8-10.4 18.1-3.9 7.6-10.6 11.2-15.1 12.9-4.4 1.5-8.9 2.8-13.2 4-3.2 .9-6.3 1.8-9.2 2.7-3.1 1.1-5.9 3.8-7.6 8.6-1.9 6.6-3.4 13.3-4.9 20.2-1.7 8.3-7.3 13.6-11.3 16.4-4.1 2.7-8.5 5.2-12.6 7.5-2.7 1.5-5.3 3-7.7 4.5-2.7 1.7-4.8 4.8-5.4 9.8-.4 6.4-.4 12.8-.5 19.2l0 2.2c0 6.9-3.1 13.7-8 18.6-3.6 3.6-7.3 6.8-10.9 9.9-2.3 1.9-4.5 3.8-6.5 5.7-2.4 2.2-3.7 5.7-3.4 10.8 .9 6.9 2.1 13.9 3.4 21 1.2 6.5-.3 14.2-4.3 19.6-2.9 4.3-6 8.3-8.9 12-1.8 2.3-3.5 4.5-5.1 6.7-1.9 2.7-2.6 6.4-1.2 11.2zm127.4 73.9l5.9-29.5c1.9-9.5 9.3-16.9 18.8-18.8l29.6-5.9c4.3-.9 8.5 1.9 9.4 6.3s-2 8.5-6.3 9.4l-29.5 5.9c-3.2 .6-5.6 3.1-6.3 6.3l-5.9 29.5c-.9 4.3-5.1 7.1-9.4 6.3s-7.1-5.1-6.3-9.4zm32-160l5.9-29.5c1.9-9.5 9.3-16.9 18.8-18.8l29.6-5.9c4.3-.9 8.5 2 9.4 6.3s-2 8.5-6.3 9.4l-29.5 5.9c-3.2 .6-5.6 3.1-6.3 6.3l-5.9 29.5c-.9 4.3-5.1 7.1-9.4 6.3s-7.1-5.1-6.3-9.4zm128 128l5.9-29.5c1.9-9.5 9.3-16.9 18.8-18.8l29.6-5.9c4.3-.9 8.5 1.9 9.4 6.3s-2 8.5-6.3 9.4l-29.5 5.9c-3.2 .6-5.6 3.1-6.3 6.3l-5.9 29.5c-.9 4.3-5.1 7.1-9.4 6.3s-7.1-5.1-6.3-9.4z", "M450.9 116c7.4-15.3 7.6-34.3-6.3-48.2s-33-13.8-48.2-6.3L365 80.1c-2.4-4.8-4.7-9.7-6.9-14.4l-1.4-3c-2.4-5.1-4.7-10.2-7.1-15-5.8-11.5-12-21.6-20.3-28.8S310.7 7.2 296.7 7.2c-7.4 0-14.5 2.4-20.1 4.3-1 .3-1.9 .6-2.8 .9-2.8 .9-5.8 .3-8.3-.7-4.1-1.4-8-3.4-11.9-5.3-4-2-8.1-4.1-12.4-5.5-7.4-1.8-16.6-.1-22.8 4.3-6.3 4.5-12.1 9.5-17.7 14.3-2.4 1.9-5 2.7-8.1 2.7-7.1 0-14.8-.9-22.8-1-9.2 0-17.7 5.4-22.9 12.7-4.2 6.5-7.8 13.2-11.3 19.7-1.6 2.6-3.7 4.3-6.6 5.3-7.3 1.8-14.8 4.1-22 6.5-8.2 2.8-15.5 10.4-17.7 18.9-2.1 7.3-3.7 14.6-5.3 21.7-.7 2.9-2.5 5.1-4.9 6.8-3.4 2.5-7.1 4.5-10.9 6.5-3 1.6-6 3.2-8.8 5.1-7 4.5-12.8 13.5-12.8 22-.4 7.5-.6 15.1-.6 22.6 0 2.9-1.5 5.4-3.4 7.5-2.8 2.8-6 5.5-9.3 8.4-2.5 2.1-5.1 4.4-7.6 6.7-6.3 6.3-9.5 15.2-8.4 24.1 1 7.5 2.3 14.9 3.6 22.1 .7 2.7-.4 5.7-1.9 8-2.2 3.4-4.9 6.8-7.7 10.3-2 2.5-4.1 5.2-6.1 7.9-5.8 5.8-6.5 18.5-3.5 25.7 1.8 5 3.8 9.9 5.8 14.8 .8 2.1 1.7 4.1 2.5 6.2 1.2 2.7 .8 5.7-.2 8.4-1 3.3-2.5 6.5-3.9 9.7-1.7 3.8-3.4 7.6-4.4 11.6-2.8 8.5-.8 18.9 4.9 25.9 4.8 5.9 10.1 11.5 15.5 16.8 2.1 2 3 4.8 3.2 7.7 .3 3.7 .3 7.4 .4 11.1 .1 5.1 .1 10.2 .8 15.4 1.8 7.8 7.2 14.6 14.2 18.5 3.3 1.7 7.3 3.3 10.8 4.6 1.3 .5 2.6 1 3.7 1.5 4.6 1.9 7.4 4.2 9.4 6.3 2 1.9 4.4 4.7 6.2 9.4 .5 1.1 .9 2.4 1.5 3.7 1.3 3.5 2.9 7.5 4.6 10.8 3.9 6.9 10.7 12.4 18.5 14.2 5.1 .6 10.2 .7 15.4 .8 3.7 0 7.4 .1 11.1 .4 2.8 .2 5.7 1.1 7.7 3.2 5.4 5.4 10.9 10.7 16.8 15.5 6.9 5.8 17.4 7.7 25.9 4.9 4-1 7.8-2.7 11.6-4.4 3.2-1.5 6.4-2.9 9.7-3.9 2.7-1 5.7-1.4 8.4-.2 2.1 .8 4.1 1.7 6.2 2.5 4.9 2 9.8 4 14.8 5.8 7.2 3.1 19.8 2.4 25.7-3.5 2.7-2 5.3-4.1 7.9-6.1 3.5-2.8 7-5.5 10.3-7.7 2.3-1.4 5.2-2.6 8-1.9 7.2 1.3 14.6 2.6 22.1 3.6 8.9 1.1 17.8-2.1 24.1-8.4 2.3-2.5 4.6-5.1 6.7-7.6 2.9-3.3 5.6-6.5 8.4-9.3 2-1.9 4.6-3.4 7.5-3.4 7.5 0 15.1-.2 22.6-.6 8.5 0 17.6-5.8 22-12.8 1.9-2.8 3.5-5.8 5.1-8.8 2-3.7 4-7.5 6.5-10.9 1.7-2.4 3.9-4.2 6.7-4.9 7.1-1.6 14.4-3.2 21.7-5.3 8.5-2.1 16.1-9.5 18.9-17.7 2.4-7.2 4.7-14.7 6.5-22 1-2.9 2.7-5 5.3-6.6 6.5-3.5 13.2-7.1 19.7-11.3 7.3-5.2 12.7-13.7 12.7-22.9-.1-8.1-1-15.8-1-22.8 0-3.1 .8-5.7 2.7-8.1 4.8-5.5 9.8-11.3 14.3-17.7 4.4-6.2 6.2-15.4 4.3-22.8-1.4-4.3-3.5-8.4-5.5-12.4-2-3.9-4-7.8-5.3-11.9-1.1-2.5-1.7-5.5-.7-8.3 .3-.9 .6-1.8 .9-2.8 1.9-5.6 4.3-12.7 4.3-20.1 0-14-4.4-24.3-11.7-32.6s-17.4-14.5-28.8-20.3c-4.8-2.4-9.8-4.8-15-7.1l-3-1.4c-4.8-2.2-9.6-4.5-14.4-6.9L450.9 116zM75.6 436.6c-4.4-4.5-9.9-7.7-14.7-9.7-1.8-.7-3.5-1.4-5-2-2.9-1.1-5.4-2.1-7.7-3.3-3.6-2.3-5.6-5.1-6.2-7.8-.7-4.7-.7-9.5-.7-14.3 0-3.4 0-6.7-.2-10-.3-4.8-1.9-12.1-7.9-17.9-5.1-5.2-9.8-10.1-14.1-15.3-2.8-4.1-3.3-7.9-2.3-11 1.1-3.1 2.4-6.3 3.8-9.6 1.6-3.9 3.2-7.9 4.7-12 1.5-4.3 3-11.5-.4-19.5l-1-2.3c-2.4-5.7-4.7-11.5-6.8-17.3-1.3-4.8-.6-8.6 1.2-11.2 1.6-2.2 3.4-4.4 5.1-6.7 3-3.8 6.1-7.7 8.9-12 4-5.4 5.6-13.1 4.3-19.6-1.3-7.1-2.5-14-3.4-21-.3-5.1 1.1-8.6 3.4-10.8 2.1-1.9 4.3-3.8 6.5-5.7 3.6-3.1 7.3-6.3 10.9-9.9 4.9-4.9 8-11.7 8-18.6l0-2.2c.1-6.4 .2-12.8 .5-19.2 .7-4.9 2.7-8 5.4-9.8 2.4-1.5 5-3 7.7-4.5 4.1-2.3 8.4-4.8 12.6-7.5 4-2.8 9.6-8.1 11.3-16.4 1.5-6.9 3.1-13.6 4.9-20.2 1.7-4.8 4.4-7.5 7.6-8.6 2.9-.9 6-1.8 9.2-2.7 4.3-1.2 8.8-2.5 13.2-4 4.5-1.7 11.3-5.2 15.1-12.9 3.4-6.3 6.7-12.3 10.4-18.1 3-4 6.5-5.6 9.7-5.7 3.2 0 6.5 .2 9.9 .5 4.2 .3 8.5 .5 13 .5 4.7 0 12.3-1 18.7-6.8 5.5-4.7 10.6-9.1 16.1-13.1 4.3-2.5 8.1-2.8 11.1-1.6 3.5 1.4 7 3.1 10.7 4.9 4.4 2.2 9 4.4 13.7 6.1 4.3 1.2 9.8 1.9 15.8-.1 1.2-.4 2.4-.8 3.6-1.2 5.6-1.8 9.8-3.2 14.4-3.2 10.1 0 16.7 3 22 7.7 5.9 5.2 11 13 16.6 24 2.3 4.5 4.4 9.2 6.8 14.2l1.5 3.3c2.9 6.2 6 12.9 9.5 19.5 7.4 14.1 16.5 28.1 27.8 39.4s25.4 20.5 39.5 27.8c6.6 3.5 13.3 6.6 19.5 9.5l3.3 1.5c5 2.3 9.7 4.5 14.2 6.8 11 5.6 18.9 10.7 24 16.6 4.7 5.3 7.7 11.9 7.7 22 0 4.6-1.4 8.8-3.2 14.4-.4 1.1-.8 2.3-1.2 3.6-2 6-1.3 11.6-.1 15.8 1.7 4.7 3.9 9.3 6.1 13.7 1.8 3.7 3.5 7.2 4.9 10.7 1.2 3 .9 6.8-1.6 11.1-3.9 5.5-8.3 10.7-13.1 16.1-5.8 6.3-6.8 14-6.8 18.7 0 4.5 .3 8.8 .5 13 .2 3.4 .4 6.7 .5 9.9-.1 3.2-1.7 6.6-5.7 9.7-5.8 3.7-11.8 7-18.1 10.4-7.6 3.9-11.2 10.6-12.9 15.1-1.5 4.4-2.8 8.9-4 13.2-.9 3.2-1.8 6.3-2.7 9.2-1.1 3.1-3.8 5.9-8.6 7.6-6.6 1.9-13.3 3.4-20.2 4.9-8.3 1.7-13.6 7.3-16.4 11.3-2.7 4.1-5.2 8.5-7.5 12.6-1.5 2.7-3 5.3-4.5 7.7-1.7 2.7-4.8 4.8-9.8 5.4-6.4 .4-12.8 .4-19.2 .5l-2.2 0c-6.9 0-13.7 3.1-18.6 8-3.6 3.6-6.8 7.3-9.9 10.9-1.9 2.3-3.8 4.5-5.7 6.5-2.2 2.4-5.7 3.7-10.8 3.4-6.9-.9-13.9-2.1-21-3.4-6.5-1.2-14.2 .3-19.6 4.3-4.3 2.9-8.3 6-12 8.9-2.3 1.8-4.5 3.5-6.7 5.1-2.7 1.9-6.4 2.6-11.2 1.3-5.9-2.1-11.6-4.4-17.3-6.8l-2.3-1c-8-3.5-15.1-1.9-19.5-.4-4.1 1.4-8.1 3.1-12 4.7-3.3 1.4-6.5 2.7-9.6 3.8-3.1 1-6.9 .5-11-2.3-5.3-4.3-10.2-9-15.3-14.1-5.8-6-13.2-7.5-17.9-7.9-3.3-.2-6.7-.2-10-.2-4.8 0-9.5 .1-14.3-.7-2.7-.7-5.5-2.6-7.8-6.2-1.2-2.3-2.1-4.8-3.3-7.7-.6-1.5-1.2-3.2-2-5-2-4.8-5.2-10.3-9.7-14.7zM418.1 139.5c-9.3-5.6-17.9-12-25.9-19.5-7.5-7.9-13.8-16.5-19.5-25.8l30.9-18.5c10.8-5.1 21.8-4.4 29.6 3.4s8.5 18.7 3.4 29.6l-18.5 30.9zM198.7 304.2c4.3-.9 8.5 1.9 9.4 6.3s-2 8.5-6.3 9.4l-29.5 5.9c-3.2 .6-5.6 3.1-6.3 6.3l-5.9 29.5c-.9 4.3-5.1 7.1-9.4 6.3s-7.1-5.1-6.3-9.4l5.9-29.5c1.9-9.5 9.3-16.9 18.8-18.8l29.6-5.9zm160-32c4.3-.9 8.5 1.9 9.4 6.3s-2 8.5-6.3 9.4l-29.5 5.9c-3.2 .6-5.6 3.1-6.3 6.3l-5.9 29.5c-.9 4.3-5.1 7.1-9.4 6.3s-7.1-5.1-6.3-9.4l5.9-29.5c1.9-9.5 9.3-16.9 18.8-18.8l29.6-5.9zm-128-128c4.3-.9 8.5 2 9.4 6.3s-2 8.5-6.3 9.4l-29.5 5.9c-3.2 .6-5.6 3.1-6.3 6.3l-5.9 29.5c-.9 4.3-5.1 7.1-9.4 6.3s-7.1-5.1-6.3-9.4l5.9-29.5c1.9-9.5 9.3-16.9 18.8-18.8l29.6-5.9z"]],
    "align-justify": [448, 512, [], "f039", ["", "M8 56c-4.4 0-8 3.6-8 8s3.6 8 8 8l432 0c4.4 0 8-3.6 8-8s-3.6-8-8-8L8 56zM0 192c0 4.4 3.6 8 8 8l432 0c4.4 0 8-3.6 8-8s-3.6-8-8-8L8 184c-4.4 0-8 3.6-8 8zM8 312c-4.4 0-8 3.6-8 8s3.6 8 8 8l432 0c4.4 0 8-3.6 8-8s-3.6-8-8-8L8 312zM8 440c-4.4 0-8 3.6-8 8s3.6 8 8 8l432 0c4.4 0 8-3.6 8-8s-3.6-8-8-8L8 440z"]],
    "sunglasses": [576, 512, [128374], "f892", ["M45.4 445.9C59.2 457.2 76.8 464 96 464l64 0c44.1 0 79.9-35.7 80-79.8 0-32.3 0-64.3 0-96.2 0-1.4-.2-2.7-.5-3.9l-2.4 2-191.8 159.8zm320 0C379.2 457.2 396.8 464 416 464l64 0c44.2 0 80-35.8 80-80l0-96c0-1.3-.2-2.6-.5-3.9l-2.4 2-191.8 159.8z", "M120.3 48c-25 0-47 16.6-53.8 40.6l-48.3 169c-.2 .6-.3 1.2-.5 1.8 4.3-2.2 9.2-3.4 14.3-3.4l192 0c17.7 0 32 14.3 32 32l0 8 64 0 0-8c0-17.7 14.3-32 32-32l192 0c5.2 0 10 1.2 14.3 3.4-.2-.6-.3-1.2-.5-1.8l-48.3-169c-6.9-24-28.8-40.6-53.8-40.6L424 48c-4.4 0-8-3.6-8-8s3.6-8 8-8l31.7 0c32.1 0 60.4 21.3 69.2 52.2l48.3 169c1.8 6.4 2.8 13.1 2.8 19.8l0 111c0 53-43 96-96 96l-64 0c-53 0-96-43-96-96l0-72-64 0 0 72c0 53-43 96-96 96l-64 0c-53 0-96-43-96-96L0 273c0-6.7 .9-13.3 2.8-19.8L51 84.2C59.9 53.3 88.1 32 120.3 32L152 32c4.4 0 8 3.6 8 8s-3.6 8-8 8l-31.7 0zM548.4 272.6c-1.4-.4-2.9-.6-4.4-.6l-192 0c-8.8 0-16 7.2-16 16l0 96c0 19.2 6.8 36.8 18 50.6l.9-.7 193.5-161.2zm11.2 11.5l-2.4 2-191.8 159.8C379.2 457.2 396.8 464 416 464l64 0c44.2 0 80-35.8 80-80l0-96c0-1.3-.2-2.6-.5-3.9zM240 304l0-16c0-1.3-.2-2.6-.5-3.9l-2.4 2-191.8 159.8C59.2 457.2 76.8 464 96 464l64 0c44.2 0 80-35.8 80-80l0-80zm-13.1-30.1l1.5-1.2c-1.4-.4-2.9-.6-4.4-.6L32 272c-8.8 0-16 7.2-16 16l0 96c0 19.2 6.8 36.8 18 50.6l.9-.7 192-160z"]],
    "cloud-check": [576, 512, [], "e35c", ["M16 336c0 70.7 57.3 128 128 128l304 0c61.9 0 112-50.1 112-112 0-48.1-30.3-89.1-72.8-105-2.3-.8-4-2.7-4.8-5s-.4-4.8 .9-6.9c8-12.5 12.8-27.3 12.8-43.2 0-44.2-35.8-80-80-80-17.6 0-33.8 5.7-47 15.3-2 1.4-4.4 1.9-6.8 1.2s-4.3-2.3-5.3-4.5c-19.9-44.9-64.8-76.1-117-76.1-70.7 0-128 57.3-128 128 0 9.4 1 18.6 2.9 27.4 .9 4.1-1.6 8.3-5.7 9.4-53.8 15.1-93.3 64.6-93.3 123.2zm178.5-33.4c3.2-3.1 8.2-3 11.3 .2l55.7 57.6 108.1-148.7c2.6-3.6 7.6-4.3 11.2-1.7 3.6 2.6 4.3 7.6 1.8 11.2L268.9 377.5c-1.4 1.9-3.6 3.1-5.9 3.3s-4.7-.7-6.3-2.4l-62.3-64.5c-3.1-3.2-3-8.2 .2-11.3z", "M240 32c55.4 0 103.5 31.4 127.5 77.2 14.2-8.4 30.8-13.2 48.5-13.2 53 0 96 43 96 96 0 15.8-3.9 30.5-10.7 43.6 44 20.2 74.7 64.7 74.7 116.4 0 70.7-57.3 128-128 128l-304 0C64.5 480 0 415.5 0 336 0 272.6 41 218.8 97.9 199.6 96.6 191.9 96 184 96 176 96 96.5 160.5 32 240 32zm0 16c-70.7 0-128 57.3-128 128 0 9.4 1 18.6 2.9 27.4 .9 4.1-1.6 8.3-5.7 9.4-53.8 15.1-93.3 64.6-93.3 123.2 0 70.7 57.3 128 128 128l304 0c61.9 0 112-50.1 112-112 0-48.1-30.3-89.1-72.8-105-2.3-.8-4-2.7-4.8-5s-.4-4.8 .9-6.9c8-12.5 12.8-27.3 12.8-43.2 0-44.2-35.8-80-80-80-17.6 0-33.8 5.7-47 15.3-2 1.4-4.4 1.9-6.8 1.2s-4.3-2.3-5.3-4.5C337.1 79.3 292.2 48 240 48zM369.7 211.7c2.6-3.6 7.6-4.3 11.2-1.7 3.6 2.6 4.3 7.6 1.8 11.2L268.9 377.5c-1.4 1.9-3.6 3.1-5.9 3.3s-4.7-.7-6.3-2.4l-62.3-64.5c-3.1-3.2-3-8.2 .2-11.3s8.2-3 11.3 .2l55.7 57.6 108.1-148.7z"]],
    "message-minus": [512, 512, ["comment-alt-minus"], "f4a7", ["M16 128l0 224c0 44.2 35.8 80 80 80l32 0c8.8 0 16 7.2 16 16l0 75.9c0 2.3 2 4 4.1 4.1 .8 0 1.7-.2 2.4-.7 3.3-2.3 6.3-4.5 9.1-6.4l.4-.3c6.7-4.7 30.4-21.5 117.2-82.7 5.4-3.8 11.8-5.9 18.5-5.9L416 432c44.2 0 80-35.8 80-80l0-224c0-44.2-35.8-80-80-80L96 48c-44.2 0-80 35.8-80 80zM160 240c0-4.4 3.6-8 8-8l176 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-176 0c-4.4 0-8-3.6-8-8z", "M144 448l0 75.9c0 2.3 2 4 4.1 4.1 .8 0 1.7-.2 2.4-.7 3.3-2.3 6.3-4.5 9.1-6.4l.4-.3c6.7-4.7 30.4-21.5 117.2-82.7 5.4-3.8 11.8-5.9 18.5-5.9L416 432c44.2 0 80-35.8 80-80l0-224c0-44.2-35.8-80-80-80L96 48c-44.2 0-80 35.8-80 80l0 224c0 44.2 35.8 80 80 80l32 0c8.8 0 16 7.2 16 16zM0 128C0 75 43 32 96 32l320 0c53 0 96 43 96 96l0 224c0 53-43 96-96 96l-120.4 0c-3.3 0-6.5 1-9.2 2.9L159.8 540.3c-3.4 2.4-7.5 3.7-11.6 3.7-11.1 0-20.1-9-20.1-20.1l0-75.9-32 0c-53 0-96-43-96-96L0 128zM168 232l176 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-176 0c-4.4 0-8-3.6-8-8s3.6-8 8-8z"]],
    "face-clouds": [640, 512, [], "e47d", ["M80 256c0-16.4 1.7-32.5 4.8-48L224 208c61.9 0 112-50.1 112-112 0-31-12.6-59.1-33-79.4 5.6-.4 11.3-.6 17-.6 132.5 0 240 107.5 240 240 0 5.1-.2 10.2-.5 15.2-12.3-4.6-25.6-7.2-39.5-7.2-5.8 0-11.4 .4-17 1.3-22.2-15.9-49.5-25.3-79-25.3-68.7 0-125.5 50.9-134.7 117.1-30 24.2-49.3 61.2-49.3 102.9 0 7.9 .7 15.6 2 23-94.3-32.4-162-121.8-162-227zm144-32a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm160 0a16 16 0 1 0 32 0 16 16 0 1 0 -32 0z", "M144-16c32.2 0 59.5 21.2 68.7 50.4 1 3.3 4.1 5.6 7.6 5.6 28.6 .2 51.7 23.4 51.7 52 0 28.7-23.3 52-52 52L68 144c-28.7 0-52-23.3-52-52 0-28.6 23.1-51.8 51.7-52 3.5 0 6.5-2.3 7.6-5.6 9.2-29.2 36.5-50.4 68.7-50.4zM61.9 24.3C27.2 27.4 0 56.5 0 92 0 129.6 30.4 160 68 160l152 0c37.6 0 68-30.4 68-68 0-35.5-27.2-64.6-61.9-67.7-12.7-32.9-44.7-56.3-82.1-56.3S74.6-8.6 61.9 24.3zM64 256c0 115.9 77 213.8 182.6 245.3-1.9-5.9-3.5-12-4.6-18.3-94.3-32.4-162-121.8-162-227 0-16.4 1.7-32.5 4.8-48l-16.3 0c-2.9 15.5-4.5 31.6-4.5 48zM320 16c132.5 0 240 107.5 240 240 0 5.1-.2 10.2-.5 15.2 5.4 2 10.6 4.5 15.5 7.3 .6-7.4 1-14.9 1-22.4 0-141.4-114.6-256-256-256-11.7 0-23.3 .8-34.6 2.3 6.3 4.2 12.2 9 17.6 14.3 5.6-.4 11.3-.6 17-.6zM256 224a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm160 0a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM352.9 387.6c-7-42.8 27.3-83.6 71.1-83.6 22.5 0 42.6 10.3 55.8 26.5 2.3 2.8 6.2 3.7 9.4 2.3 36.4-16.2 80.3 13 78.7 53.5-.2 3.7 2.3 7.1 5.9 8 28.9 7.8 50.1 34.3 50.1 65.6 0 37.5-30.4 67.9-67.9 67.9l-184.2 0c-37.5 0-67.9-30.4-67.9-67.9 0-29 18.2-53.9 43.9-63.6 3.6-1.3 5.7-5 5.1-8.8zM424 288c-51.5 0-92 45.8-87.6 95.9-28.6 13.4-48.4 42.4-48.4 76.1 0 46.3 37.6 83.9 83.9 83.9l184.2 0c46.3 0 83.9-37.6 83.9-83.9 0-36.6-23.4-67.7-56.1-79.2-2.2-47.2-51.6-79.9-95.6-64.8-16.1-17.2-39-28-64.4-28z"]],
    "left-long-to-line": [640, 512, [], "e41e", ["M148.7 244.7l128-128c4.6-4.6 11.5-5.9 17.4-3.5s9.9 8.3 9.9 14.8l0 72c0 4.4 3.6 8 8 8l280 0c17.7 0 32 14.3 32 32l0 32c0 17.7-14.3 32-32 32l-280 0c-4.4 0-8 3.6-8 8l0 72c0 6.5-3.9 12.3-9.9 14.8s-12.9 1.1-17.4-3.5l-128-128c-6.2-6.2-6.2-16.4 0-22.6z", "M148.7 244.7c-6.2 6.2-6.2 16.4 0 22.6l128 128c4.6 4.6 11.5 5.9 17.4 3.5s9.9-8.3 9.9-14.8l0-72c0-4.4 3.6-8 8-8l280 0c17.7 0 32-14.3 32-32l0-32c0-17.7-14.3-32-32-32l-280 0c-4.4 0-8-3.6-8-8l0-72c0-6.5-3.9-12.3-9.9-14.8s-12.9-1.1-17.4 3.5l-128 128zm-11.3 33.9c-12.5-12.5-12.5-32.8 0-45.3l128-128c9.2-9.2 22.9-11.9 34.9-6.9S320 115.1 320 128l0 64 272 0c26.5 0 48 21.5 48 48l0 32c0 26.5-21.5 48-48 48l-272 0 0 64c0 12.9-7.8 24.6-19.8 29.6s-25.7 2.2-34.9-6.9l-128-128zM0 104c0-4.4 3.6-8 8-8s8 3.6 8 8l0 304c0 4.4-3.6 8-8 8s-8-3.6-8-8L0 104z"]],
    "plane-landing-gear": [640, 512, [], "e7bc", ["M34.9 208L73.4 329c7.4 23.2 29 39 53.4 39l425.7 0c21.9 0 39.6-17.7 39.7-39.5 .1-21.9-17.7-39.8-39.6-39.8l-127.5-.2c-2.2 0-4.4-.9-5.9-2.6L244.5 96 179 96 237.1 277.7c.8 2.4 .3 5.1-1.2 7.2s-3.9 3.3-6.5 3.3L136 288c-2.8 0-5.2-1.4-6.6-3.6L68.2 208 34.9 208z", "M592.2 328.5c.1-21.9-17.7-39.8-39.6-39.8l-127.5-.2c-2.2 0-4.4-.9-5.9-2.6L244.5 96 179 96 237.1 277.7c.8 2.4 .3 5.1-1.2 7.2s-3.9 3.3-6.5 3.3L136 288c-2.8 0-5.2-1.4-6.6-3.6L68.2 208 34.9 208 73.4 329c7.4 23.2 29 39 53.4 39l425.7 0c21.9 0 39.6-17.7 39.7-39.5zm-39.6-55.8c30.8 0 55.7 25.1 55.6 55.9-.1 30.7-25 55.5-55.7 55.5l-425.7 0c-31.4 0-59.1-20.3-68.6-50.2L16.4 202.4c-.8-2.4-.3-5.1 1.2-7.1S21.4 192 24 192l48 0c2.4 0 4.7 1.1 6.2 3l61.6 77.1 78.6 .1-58.2-181.7c-.8-2.4-.3-5.1 1.2-7.2S165.4 80 168 80l80 0c2.2 0 4.4 .9 5.9 2.6l174.7 189.9 124 .2zM256 464a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm0-48a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm176 32a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm-48 0a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"]],
    "calendar-check": [448, 512, [], "f274", ["M16 128l0 288c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-288c0-26.5-21.5-48-48-48l-48 0 0 24c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-24-192 0 0 24c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-24-48 0c-26.5 0-48 21.5-48 48zm98.3 170.3c3.1-3.1 8.2-3.1 11.3 0L191 363.7 321.4 184.4c2.6-3.6 7.6-4.3 11.2-1.8s4.4 7.6 1.8 11.2L198.5 380.7c-1.4 1.9-3.5 3.1-5.8 3.3s-4.6-.7-6.3-2.3l-72-72c-3.1-3.1-3.1-8.2 0-11.3z", "M328 0c4.4 0 8 3.6 8 8l0 56 48 0c35.3 0 64 28.7 64 64l0 288c0 33.1-25.2 60.4-57.5 63.7l-6.5 .3-320 0-6.5-.3c-30.1-3.1-54.1-27-57.1-57.1L0 416 0 128C0 92.7 28.7 64 64 64l48 0 0-56c0-4.4 3.6-8 8-8s8 3.6 8 8l0 56 192 0 0-56c0-4.4 3.6-8 8-8zM64 80c-26.5 0-48 21.5-48 48l0 288c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-288c0-26.5-21.5-48-48-48l-48 0 0 24c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-24-192 0 0 24c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-24-48 0zM321.4 184.4c2.6-3.6 7.6-4.3 11.2-1.8s4.4 7.6 1.8 11.2L198.5 380.7c-1.4 1.9-3.5 3.1-5.8 3.3s-4.6-.7-6.3-2.3l-72-72c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0L191 363.7 321.4 184.4z"]],
    "square-ring": [448, 512, [], "e44f", ["M16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96zM352 256a128 128 0 1 1 -256 0 128 128 0 1 1 256 0z", "M64 48C37.5 48 16 69.5 16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM336 256a112 112 0 1 0 -224 0 112 112 0 1 0 224 0zM96 256a128 128 0 1 1 256 0 128 128 0 1 1 -256 0z"]],
    "face-kiss": [512, 512, [128535, "kiss"], "f596", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zm176-48a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm56 96c0-4.4 3.6-8 8-8l24 0c22.1 0 40 17.9 40 40 0 13.1-6.3 24.7-16 32 9.7 7.3 16 18.9 16 32 0 22.1-17.9 40-40 40l-24 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l24 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-24 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l24 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-24 0c-4.4 0-8-3.6-8-8zm104-96a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M496 256a240 240 0 1 0 -480 0 240 240 0 1 0 480 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm248 48c0-4.4 3.6-8 8-8l24 0c22.1 0 40 17.9 40 40 0 13.1-6.3 24.7-16 32 9.7 7.3 16 18.9 16 32 0 22.1-17.9 40-40 40l-24 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l24 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-24 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l24 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-24 0c-4.4 0-8-3.6-8-8zm-88-96a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm176-16a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"]],
    "circle-video": [512, 512, ["video-circle"], "e12b", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zm112-56c0-22.1 17.9-40 40-40l112 0c22.1 0 40 17.9 40 40l0 12.2 69-27.6c2.5-1 5.3-.7 7.5 .8s3.5 4 3.5 6.6l0 128c0 2.7-1.3 5.1-3.5 6.6s-5 1.8-7.5 .8l-69-27.6 0 12.2c0 22.1-17.9 40-40 40l-112 0c-22.1 0-40-17.9-40-40l0-112z", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm24-336c13.3 0 24 10.7 24 24l0 112c0 13.3-10.7 24-24 24l-112 0c-13.3 0-24-10.7-24-24l0-112c0-13.3 10.7-24 24-24l112 0zm40 36.2l0-12.2c0-22.1-17.9-40-40-40l-112 0c-22.1 0-40 17.9-40 40l0 112c0 22.1 17.9 40 40 40l112 0c22.1 0 40-17.9 40-40l0-12.2 69 27.6c2.5 1 5.3 .7 7.5-.8s3.5-4 3.5-6.6l0-128c0-2.7-1.3-5.1-3.5-6.6s-5-1.8-7.5-.8l-69 27.6zm0 17.2l64-25.6 0 104.4-64-25.6 0-53.2z"]],
    "cart-shopping-fast": [640, 512, [], "e0dc", ["M160 48l43.8 224 321.4 0c26 0 48.6-17.9 54.5-43.3L615 77.5c3.5-15.1-7.9-29.5-23.4-29.5L160 48zm80 416a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm224 0a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M64 8c0-4.4 3.6-8 8-8l45.7 0c19 0 35.4 13.4 39.2 32l434.8 0c25.8 0 44.8 24 39 49.1L595.3 232.4c-7.6 32.6-36.7 55.6-70.1 55.6l-318.3 0 9.3 47.7c3.7 18.8 20.1 32.3 39.3 32.3L552 368c4.4 0 8 3.6 8 8s-3.6 8-8 8l-296.5 0c-26.8 0-49.8-19-55-45.2L141.2 35.4C139 24.1 129.1 16 117.7 16L72 16c-4.4 0-8-3.6-8-8zM203.8 272l321.4 0c26 0 48.6-17.9 54.5-43.3L615 77.5c3.5-15.1-7.9-29.5-23.4-29.5L160 48 203.8 272zM272 496a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm0-80a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm256 48a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm-80 0a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM8 96l80 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L8 112c-4.4 0-8-3.6-8-8s3.6-8 8-8zm0 96l96 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L8 208c-4.4 0-8-3.6-8-8s3.6-8 8-8zm0 96l112 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L8 304c-4.4 0-8-3.6-8-8s3.6-8 8-8z"]],
    "desktop-arrow-down": [512, 512, [], "e155", ["M16 96c0-26.5 21.5-48 48-48l128 0 0-16 56 0 0 196.7-74.3-74.3c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l88 88c3.1 3.1 8.2 3.1 11.3 0l88-88c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0l-74.3 74.3 0-196.7 56 0 0 16 128 0c26.5 0 48 21.5 48 48l0 224-480 0 0-224zM193.4 496l13.3-80 98.4 0 13.3 80-125.1 0z", "M264 8l0 220.7 74.3-74.3c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3l-88 88c-3.1 3.1-8.2 3.1-11.3 0l-88-88c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0L248 228.7 248 8c0-4.4 3.6-8 8-8s8 3.6 8 8zM64 32l128 0 0 16-128 0C37.5 48 16 69.5 16 96l0 224 480 0 0-224c0-26.5-21.5-48-48-48l-128 0 0-16 128 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64l-126.6 0 13.3 80 73.2 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-304 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l73.2 0 13.3-80-126.6 0c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32zM496 352l0-16-480 0 0 16c0 26.5 21.5 48 48 48l384 0c26.5 0 48-21.5 48-48zM193.4 496l125.1 0-13.3-80-98.4 0-13.3 80z"]],
    "banjo": [512, 512, [129685], "f8a3", ["M31.7 333.8c.2 .7 .3 1.4 .3 2.2s-.1 1.5-.3 2.2c.6 38.2 16 72.8 40.7 98.3 .6 .4 1.2 .8 1.8 1.3s1 1.1 1.3 1.8c25.5 24.7 60.1 40.1 98.3 40.7 .7-.2 1.4-.3 2.2-.3s1.5 .1 2.2 .3c38.2-.6 72.8-16 98.3-40.7 .4-.6 .8-1.2 1.3-1.8s1.1-1 1.8-1.3c24.7-25.5 40.1-60.1 40.7-98.3-.2-.7-.3-1.4-.3-2.2s.1-1.5 .3-2.2c-1.2-78-64.1-141-142.1-142.1-.7 .2-1.4 .3-2.2 .3s-1.5-.1-2.2-.3c-38.2 .6-72.8 16-98.3 40.7-.4 .6-.8 1.2-1.3 1.8s-1.1 1-1.8 1.3C47.7 261 32.3 295.6 31.7 333.8zm74.6-3.5c3.1-3.1 8.2-3.1 11.3 0l64 64c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-64-64c-3.1-3.1-3.1-8.2 0-11.3zM378.2 133.8l63.5-12.7c1.5-.3 3-1.1 4.1-2.2L492.7 72c2.1-2.1 3.3-5 3.3-8s-1.2-5.9-3.3-8L456 19.3c-2.1-2.1-5-3.3-8-3.3s-5.9 1.2-8 3.3L393.1 66.2c-1.1 1.1-1.9 2.5-2.2 4.1l-12.7 63.5z", "M448 16c-3 0-5.9 1.2-8 3.3L393.1 66.2c-1.1 1.1-1.9 2.5-2.2 4.1l-12.7 63.5 63.5-12.7c1.5-.3 3-1.1 4.1-2.2L492.7 72c2.1-2.1 3.3-5 3.3-8s-1.2-5.9-3.3-8L456 19.3c-2.1-2.1-5-3.3-8-3.3zM360.6 140.1l14.6-72.9c.9-4.6 3.2-8.9 6.6-12.3L428.7 8c5.1-5.1 12.1-8 19.3-8s14.2 2.9 19.3 8L504 44.7c5.1 5.1 8 12.1 8 19.3s-2.9 14.2-8 19.3l-46.9 46.9c-3.4 3.4-7.6 5.6-12.3 6.6l-72.9 14.6-77.3 77.3c24 26.5 39.3 61.2 41.2 99.3l8.2 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-8.2 0c-1.9 38.2-17.1 72.8-41.2 99.3l5.8 5.8c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-5.8-5.8c-26.5 24-61.2 39.3-99.3 41.2l0 8.2c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-8.2c-38.2-1.9-72.8-17.1-99.3-41.2l-5.8 5.8c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l5.8-5.8c-24-26.5-39.3-61.2-41.2-99.3L8 344c-4.4 0-8-3.6-8-8s3.6-8 8-8l8.2 0c1.9-38.2 17.1-72.8 41.2-99.3l-5.8-5.8c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0l5.8 5.8c26.5-24 61.2-39.3 99.3-41.2l0-8.2c0-4.4 3.6-8 8-8s8 3.6 8 8l0 8.2c38.2 1.9 72.8 17.1 99.3 41.2l77.3-77.3zM72.4 235.5c-24.7 25.5-40.1 60.1-40.7 98.3 .2 .7 .3 1.4 .3 2.2s-.1 1.5-.3 2.2c.6 38.2 16 72.8 40.7 98.3 .6 .4 1.2 .8 1.8 1.3s1 1.1 1.3 1.8c25.5 24.7 60.1 40.1 98.3 40.7 .7-.2 1.4-.3 2.2-.3s1.5 .1 2.2 .3c38.2-.6 72.8-16 98.3-40.7 .4-.6 .8-1.2 1.3-1.8s1.1-1 1.8-1.3c24.7-25.5 40.1-60.1 40.7-98.3-.2-.7-.3-1.4-.3-2.2s.1-1.5 .3-2.2c-1.2-78-64.1-141-142.1-142.1-.7 .2-1.4 .3-2.2 .3s-1.5-.1-2.2-.3c-38.2 .6-72.8 16-98.3 40.7-.4 .6-.8 1.2-1.3 1.8s-1.1 1-1.8 1.3zm45.2 94.8l64 64c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-64-64c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0z"]],
    "cloud-hail-mixed": [512, 512, [], "f73a", ["M16 224c0 44.2 35.8 80 80 80l320 0c44.2 0 80-35.8 80-80s-35.8-80-80-80c-3.8 0-7.6 .3-11.3 .8-2.8 .4-5.6-.7-7.3-2.9s-2.3-5.1-1.3-7.8c2.5-6.9 3.9-14.3 3.9-22.1 0-35.3-28.7-64-64-64-23.7 0-44.4 12.9-55.5 32-1.6 2.7-4.5 4.2-7.6 4s-5.8-2.3-6.8-5.2c-13.5-36.7-48.8-62.8-90.1-62.8-53 0-96 43-96 96 0 8.4 1.1 16.6 3.1 24.4 .5 2.1 .2 4.3-.9 6.1s-2.9 3.2-5 3.7C42.1 154.6 16 186.3 16 224z", "M176 0c-61.9 0-112 50.1-112 112 0 7.1 .7 14.1 1.9 20.8-38.3 12.6-65.9 48.7-65.9 91.2 0 53 43 96 96 96l320 0c53 0 96-43 96-96s-43-96-96-96c-.5 0-1.1 0-1.6 0 1.1-5.2 1.6-10.5 1.6-16 0-44.2-35.8-80-80-80-24.3 0-46.1 10.9-60.8 28-18.7-35.7-56.1-60-99.2-60zM80 112c0-53 43-96 96-96 41.3 0 76.6 26.1 90.1 62.8 1.1 2.9 3.7 4.9 6.8 5.2s6.1-1.3 7.6-4c11.1-19.2 31.8-32 55.5-32 35.3 0 64 28.7 64 64 0 7.8-1.4 15.2-3.9 22.1-1 2.6-.5 5.6 1.3 7.8s4.6 3.3 7.3 2.9c3.7-.5 7.5-.8 11.3-.8 44.2 0 80 35.8 80 80s-35.8 80-80 80L96 304c-44.2 0-80-35.8-80-80 0-37.7 26.1-69.4 61.3-77.8 2.1-.5 3.9-1.8 5-3.7s1.4-4.1 .9-6.1c-2-7.8-3.1-16-3.1-24.4zM77 378.4c1.4-4.2-.9-8.7-5.1-10.1s-8.7 .9-10.1 5.1L40.4 437.5c-1.4 4.2 .9 8.7 5.1 10.1s8.7-.9 10.1-5.1L77 378.4zm128 0c1.4-4.2-.9-8.7-5.1-10.1s-8.7 .9-10.1 5.1L147.1 501.5c-1.4 4.2 .9 8.7 5.1 10.1s8.7-.9 10.1-5.1L205 378.4zm128 0c1.4-4.2-.9-8.7-5.1-10.1s-8.7 .9-10.1 5.1l-21.4 64.1c-1.4 4.2 .9 8.7 5.1 10.1s8.7-.9 10.1-5.1L333 378.4zm128 0c1.4-4.2-.9-8.7-5.1-10.1s-8.7 .9-10.1 5.1L403.1 501.5c-1.4 4.2 .9 8.7 5.1 10.1s8.7-.9 10.1-5.1L461 378.4zM48 496a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm240 16a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"]],
    "square-half-stroke": [448, 512, [], "e793", ["M16 96l0 320c0 26.5 21.5 48 48 48l152 0 0-416-152 0C37.5 48 16 69.5 16 96z", "M232 48l0 416 152 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L232 48zm-16 0L64 48C37.5 48 16 69.5 16 96l0 320c0 26.5 21.5 48 48 48l152 0 0-416zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96z"]],
    "kitchen-set": [576, 512, [], "e51a", ["M16 144a128 128 0 1 0 256 0 128 128 0 1 0 -256 0zm224 0a96 96 0 1 1 -192 0 96 96 0 1 1 192 0zM48 336l0 96c0 8.8 7.2 16 16 16l64 0c8.8 0 16-7.2 16-16l0-96-96 0zM64 144a80 80 0 1 0 160 0 80 80 0 1 0 -160 0zM288 336l0 128c0 17.7 14.3 32 32 32l160 0c17.7 0 32-14.3 32-32l0-128-224 0zm80-192c0 8.8 7.2 16 16 16l128 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-128 0c-8.8 0-16 7.2-16 16z", "M144 272a128 128 0 1 0 0-256 128 128 0 1 0 0 256zM287.8 152C283.6 227.8 220.8 288 144 288 64.5 288 0 223.5 0 144S64.5 0 144 0c76.8 0 139.6 60.2 143.8 136l65.2 0c3.6-13.8 16.1-24 31-24l128 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-128 0c-14.9 0-27.4-10.2-31-24l-65.2 0zm96.2 8l128 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-128 0c-8.8 0-16 7.2-16 16s7.2 16 16 16zM264 320l72 0 0-24c0-13.3 10.7-24 24-24l80 0c13.3 0 24 10.7 24 24l0 24 72 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-8 0 0 128c0 26.5-21.5 48-48 48l-160 0c-26.5 0-48-21.5-48-48l0-128-8 0c-4.4 0-8-3.6-8-8s3.6-8 8-8zm88 0l96 0 0-24c0-4.4-3.6-8-8-8l-80 0c-4.4 0-8 3.6-8 8l0 24zm160 16l-224 0 0 128c0 17.7 14.3 32 32 32l160 0c17.7 0 32-14.3 32-32l0-128zM224 144a80 80 0 1 0 -160 0 80 80 0 1 0 160 0zM48 144a96 96 0 1 1 192 0 96 96 0 1 1 -192 0zM0 504c0-4.4 3.6-8 8-8l208 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L8 512c-4.4 0-8-3.6-8-8zM160 336l0 64 16 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-16 0zm16 80l-16 0 0 16c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-96c0-8.8 7.2-16 16-16l128 0c26.5 0 48 21.5 48 48s-21.5 48-48 48zM48 336l0 96c0 8.8 7.2 16 16 16l64 0c8.8 0 16-7.2 16-16l0-96-96 0z"]],
    "dna": [384, 512, [129516], "f471", ["M24.2 64c9.1 29.9 25.4 56.1 46.3 80.1 .5-.1 1-.1 1.5-.1l240 0c.5 0 1 0 1.5 .1 20.9-24 37.2-50.2 46.3-80.1L24.2 64zm0 384l335.7 0c-9.1-29.9-25.4-56.1-46.3-80.1-.5 .1-1 .1-1.5 .1L72 368c-.5 0-1 0-1.5-.1-20.9 24-37.2 50.2-46.3 80.1zm61-288c30.6 31 68.2 58.4 106.8 86.1 38.6-27.7 76.2-55.2 106.8-86.1L85.2 160zm0 192l213.6 0c-30.6-31-68.2-58.4-106.8-86.1-38.6 27.7-76.2 55.2-106.8 86.1z", "M376 0c4.4 0 8 3.6 8 8 0 60.3-24.1 107.6-59.5 147.9-32.9 37.4-75.9 69.2-118.8 100.1 42.9 30.9 85.9 62.7 118.8 100.1 35.4 40.3 59.5 87.6 59.5 147.9 0 4.4-3.6 8-8 8s-8-3.6-8-8c0-14.1-1.4-27.4-4.1-40L20.1 464c-2.7 12.6-4.1 25.9-4.1 40 0 4.4-3.6 8-8 8s-8-3.6-8-8C0 443.7 24.1 396.4 59.5 356.1 92.4 318.7 135.4 286.9 178.3 256 135.4 225.1 92.4 193.3 59.5 155.9 24.1 115.6 0 68.3 0 8 0 3.6 3.6 0 8 0s8 3.6 8 8c0 14.1 1.4 27.4 4.1 40l343.9 0c2.6-12.6 4.1-25.9 4.1-40 0-4.4 3.6-8 8-8zM24.2 64c9.1 29.9 25.4 56.1 46.3 80.1 .5-.1 1-.1 1.5-.1l240 0c.5 0 1 0 1.5 .1 20.9-24 37.2-50.2 46.3-80.1L24.2 64zm61 96c30.6 31 68.2 58.4 106.8 86.1 38.6-27.7 76.2-55.2 106.8-86.1L85.2 160zM192 265.9C153.4 293.6 115.8 321 85.2 352l213.6 0c-30.6-31-68.2-58.4-106.8-86.1zm121.5 102c-.5 .1-1 .1-1.5 .1L72 368c-.5 0-1 0-1.5-.1-20.9 24-37.2 50.2-46.3 80.1l335.7 0c-9.1-29.9-25.4-56.1-46.3-80.1z"]],
    "circle-bangladeshi-taka": [512, 512, [], "e701", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zm130.3-32c0-4.4 3.6-8 8-8l45.7 0 0-41c0-14-10.1-25.9-23.9-28.2l-17.4-2.9c-4.4-.7-7.3-4.8-6.6-9.2s4.8-7.3 9.2-6.6l17.4 2.9c21.5 3.6 37.2 22.2 37.2 44l0 41 32 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-32 0 0 107.4c0 15.8 12.8 28.6 28.6 28.6l3.4 0c57.4 0 104-46.6 104-104l0-3.4c0-15.8-12.8-28.6-28.6-28.6L312 232c-4.4 0-8-3.6-8-8s3.6-8 8-8l11.4 0c24.6 0 44.6 20 44.6 44.6l0 3.4c0 66.3-53.7 120-120 120l-3.4 0C220 384 200 364 200 339.4l0-107.4-45.7 0c-4.4 0-8-3.6-8-8z", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM152.1 134.7c-.7 4.4 2.2 8.5 6.6 9.2l17.4 2.9C189.9 149.1 200 161 200 175l0 41-45.7 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l45.7 0 0 107.4c0 24.6 20 44.6 44.6 44.6l3.4 0c66.3 0 120-53.7 120-120l0-3.4c0-24.6-20-44.6-44.6-44.6L312 216c-4.4 0-8 3.6-8 8s3.6 8 8 8l11.4 0c15.8 0 28.6 12.8 28.6 28.6l0 3.4c0 57.4-46.6 104-104 104l-3.4 0c-15.8 0-28.6-12.8-28.6-28.6l0-107.4 32 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-32 0 0-41c0-21.8-15.8-40.4-37.2-44l-17.4-2.9c-4.4-.7-8.5 2.2-9.2 6.6z"]],
    "box-circle-check": [576, 512, [], "e0c4", ["M48.2 144l415.6 0c.1 1.5 .2 3 .2 4.5l0 62.1c-10.4-1.7-21.1-2.7-32-2.7-106 0-192 86-192 192 0 22.4 3.8 44 10.9 64L96 464c-26.5 0-48-21.5-48-48l0-267.5c0-1.5 .1-3 .2-4.5zm4.4-16c1.2-2.6 2.7-5 4.3-7.4l48.9-68.5c9-12.6 23.6-20.1 39.1-20.1l103.1 0 0 96-195.4 0zM264 32l103.1 0c15.5 0 30 7.5 39.1 20.1l48.9 68.5c1.7 2.3 3.1 4.8 4.3 7.4l-195.4 0 0-96z", "M464 148.5l0 62.1c5.4 .9 10.7 2 16 3.4l0-65.5c0-13.3-4.2-26.3-11.9-37.2L419.1 42.8C407.1 26 387.7 16 367.1 16L144.9 16c-20.7 0-40.1 10-52.1 26.8L43.9 111.3C36.2 122.2 32 135.2 32 148.5L32 416c0 35.3 28.7 64 64 64l161.4 0c-2.4-5.2-4.6-10.6-6.5-16L96 464c-26.5 0-48-21.5-48-48l0-267.5c0-1.5 .1-3 .2-4.5l415.6 0c.1 1.5 .2 3 .2 4.5zM52.6 128c1.2-2.6 2.7-5 4.3-7.4l48.9-68.5c9-12.6 23.6-20.1 39.1-20.1l103.1 0 0 96-195.4 0zM264 128l0-96 103.1 0c15.5 0 30 7.5 39.1 20.1l48.9 68.5c1.7 2.3 3.1 4.8 4.3 7.4L264 128zM432 272a128 128 0 1 1 0 256 128 128 0 1 1 0-256zm0 272a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm60.7-212.5c-3.6-2.6-8.6-1.8-11.2 1.8l-74 101.7-33.4-40.1c-2.8-3.4-7.9-3.9-11.3-1s-3.9 7.9-1 11.3l40 48c1.6 1.9 3.9 3 6.4 2.9s4.8-1.3 6.2-3.3l80-110c2.6-3.6 1.8-8.6-1.8-11.2z"]],
    "trillium": [448, 512, [], "e588", ["M10.7 368.3c-.8 3.4 1.1 6.6 4.4 7.7l14.2 4c16.3 4.3 38.6 9 62.3 10.8 31.9 2.5 65.4-.3 91.1-15.1l5.5-3.5c12.5-8.5 22.2-19.8 28.7-32.5l1.3-1.8c1.5-1.6 3.6-2.5 5.8-2.5 3 0 5.7 1.7 7.1 4.3 7.5 14.5 19.1 27.1 34.2 35.9l4.9 2.7c25 12.5 56.3 14.8 86.2 12.5 31.7-2.5 60.7-10.1 76.5-14.8l2.2-1.2c1.3-1 2.1-2.4 2.3-4l-.1-2.5c-3.7-16.1-11.7-45-25.4-73.7-12.9-27.1-30.6-53.1-53.9-68.4l-4.7-2.9c-13.8-8-28.8-11.8-43.7-11.8-2.8 0-5.4-1.4-6.8-3.8s-1.6-5.3-.3-7.8c6.1-12 9.5-25.5 9.5-39.9l-.2-5.6c-1.6-27.9-15.3-56.2-32.3-80.9-13.5-19.7-28.7-36.6-40.6-48.6L228.6 14.7c-1.9-1.8-4.5-2.3-6.7-1.4l-2.1 1.4c-12 11.3-33.1 32.6-51.1 58.8-18.1 26.4-32.5 56.8-32.5 86.5 0 14.4 3.4 27.9 9.5 39.9 1.3 2.5 1.1 5.4-.3 7.8s-4 3.8-6.8 3.8c-13 0-26.2 2.9-38.6 9l-5.2 2.8c-25.7 14.8-44.9 42.5-58.7 71.3-10.3 21.5-17.3 43.2-21.8 59.4l-3.6 14.2zM272.2 240a48 48 0 1 1 -96 0 48 48 0 1 1 96 0z", "M212.3 .3C220.8-5 231.9-4.1 239.5 3l10.9 10.7c12.3 12.5 28.2 30.1 42.4 50.8 7 10.2 13.7 21.2 19.3 32.9 15.4-1.7 30.9-1.6 45.6-.5 25 2 48.3 6.9 65.2 11.3l14.7 4.2c11.4 3.5 18.1 15 15.4 26.6l-3.8 14.8c-4.6 16.9-12 39.5-22.7 62.1-5.8 12.1-12.8 24.4-20.9 35.9 8.1 11.5 15.1 23.8 20.9 36 14.4 30.2 22.6 60.3 26.5 77l.6 4.3c.3 8.6-4.3 16.6-11.9 20.6l-4.1 1.7c-16.4 5-46.6 12.9-79.9 15.5-14.8 1.2-30.5 1.2-46-.5-5.6 11.6-12.1 22.8-19.1 32.9-18.9 27.6-40.9 49.8-53.4 61.4l-3.5 2.7c-8.5 5.3-19.6 4.4-27.2-2.7L197.7 490c-12.3-12.5-28.2-30.1-42.4-50.8-7-10.2-13.6-21.3-19.2-33-15.4 1.7-31 1.7-45.7 .6-25-2-48.3-6.9-65.2-11.3l-14.7-4.2c-11.4-3.5-18.1-15-15.4-26.6l3.8-14.8c4.6-16.9 12-39.5 22.8-62.1 5.8-12.2 12.8-24.5 20.9-36-8.1-11.5-15.1-23.7-20.9-35.8-14.4-30.2-22.6-60.3-26.5-77l-.6-4.3c-.3-8.6 4.3-16.5 11.9-20.6l4.1-1.7c16.3-5 46.6-12.9 79.9-15.5 14.8-1.2 30.4-1.2 45.8 .5 5.6-11.6 12.3-22.7 19.3-32.9 18.9-27.6 40.9-49.8 53.4-61.4l3.5-2.7zm11.8 358.6c-7.1 10.2-16.1 19.3-26.8 26.6l-6.5 4.1c-11.8 6.8-24.7 11.3-38.1 14.1 4.7 9.1 10 18 15.8 26.5 13.5 19.7 28.7 36.6 40.6 48.6L219.6 489c1.9 1.8 4.5 2.3 6.7 1.4l2.1-1.4c12-11.3 33.1-32.6 51.1-58.8 5.8-8.5 11.1-17.4 15.8-26.5-11.2-2.4-22.1-5.9-32.2-11l-5.7-3.1c-13.7-7.9-24.9-18.5-33.4-30.7zM221.9 13.3l-2.1 1.4c-12 11.3-33.1 32.6-51.1 58.8-18.1 26.4-32.5 56.8-32.5 86.5 0 14.4 3.4 27.9 9.5 39.9 1.3 2.5 1.1 5.4-.3 7.8s-4 3.8-6.8 3.8c-13 0-26.2 2.9-38.6 9l-5.2 2.8c-25.7 14.8-44.9 42.5-58.7 71.3-10.3 21.5-17.3 43.2-21.8 59.4l-3.6 14.2c-.8 3.4 1.1 6.6 4.4 7.7l14.2 4c16.3 4.3 38.6 9 62.3 10.8 31.9 2.5 65.4-.3 91.1-15.1l5.5-3.5c12.5-8.5 22.2-19.8 28.7-32.5l1.3-1.8c1.5-1.6 3.6-2.5 5.8-2.5 3 0 5.7 1.7 7.1 4.3 7.5 14.5 19.1 27.1 34.2 35.9l4.9 2.7c25 12.5 56.3 14.8 86.2 12.5 31.7-2.5 60.7-10.1 76.5-14.8l2.2-1.2c1.3-1 2.1-2.4 2.3-4l-.1-2.5c-3.7-16.1-11.7-45-25.4-73.7-12.9-27.1-30.6-53.1-53.9-68.4l-4.7-2.9c-13.8-8-28.8-11.8-43.7-11.8-2.8 0-5.4-1.4-6.8-3.8s-1.6-5.3-.3-7.8c6.1-12 9.5-25.5 9.5-39.9l-.2-5.6c-1.6-27.9-15.3-56.2-32.3-80.9-13.5-19.7-28.7-36.6-40.6-48.6L228.6 14.7c-1.9-1.8-4.5-2.3-6.7-1.4zM224.2 288a48 48 0 1 1 0-96 48 48 0 1 1 0 96zm0-80a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm-94.7-95.2c-12.5-1.1-25.3-1-37.9 0-31.7 2.5-60.7 10.1-76.5 14.8l-2.2 1.2c-1.3 1-2.1 2.4-2.3 4l.1 2.5c3.7 16.1 11.7 45 25.4 73.7 4.9 10.2 10.4 20.1 16.7 29.5 9.8-11.5 21-21.6 34-29l6.2-3.3c10.8-5.3 22.3-8.6 33.7-9.9-4.2-11.3-6.5-23.5-6.5-36.2 0-16.1 3.6-32 9.3-47.2zm227.1 0c-12.5-1-25.3-1.1-37.8 0 5.7 15.2 9.4 31.1 9.4 47.2l-.2 6.3c-.6 10.5-2.8 20.5-6.3 29.9 13.6 1.6 27.2 5.9 39.8 13.2l5.5 3.4c10.6 7 20 15.8 28.4 25.6 6.3-9.3 11.9-19.3 16.7-29.4 10.3-21.5 17.3-43.2 21.8-59.4l3.6-14.2c.8-3.4-1.1-6.6-4.4-7.7l-14.2-4c-16.3-4.3-38.6-9-62.3-10.8z"]],
    "delete-right": [640, 512, [], "e154", ["M80 128c0-26.5 21.5-48 48-48l306.7 0c12.7 0 24.9 5.1 33.9 14.1L619.3 244.7c3 3 4.7 7.1 4.7 11.3s-1.7 8.3-4.7 11.3L468.7 417.9c-9 9-21.2 14.1-33.9 14.1L128 432c-26.5 0-48-21.5-48-48l0-256zm142.8 62.8c-3.1 3.1-3.1 8.2 0 11.3l53.8 53.8-53.8 53.8c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l53.8-53.8 53.8 53.8c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-53.8-53.8 53.8-53.8c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0l-53.8 53.8-53.8-53.8c-3.1-3.1-8.2-3.1-11.3 0z", "M80 128c0-26.5 21.5-48 48-48l306.7 0c12.7 0 24.9 5.1 33.9 14.1L619.3 244.7c3 3 4.7 7.1 4.7 11.3s-1.7 8.3-4.7 11.3L468.7 417.9c-9 9-21.2 14.1-33.9 14.1L128 432c-26.5 0-48-21.5-48-48l0-256zM630.6 233.4L480 82.7C468 70.7 451.7 64 434.7 64L128 64c-35.3 0-64 28.7-64 64l0 256c0 35.3 28.7 64 64 64l306.7 0c17 0 33.3-6.7 45.3-18.7L630.6 278.6c6-6 9.4-14.1 9.4-22.6s-3.4-16.6-9.4-22.6zM222.8 309.8c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l53.8-53.8 53.8 53.8c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-53.8-53.8 53.8-53.8c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0l-53.8 53.8-53.8-53.8c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l53.8 53.8-53.8 53.8z"]],
    "circle-colon": [512, 512, [], "e6fc", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zm114.5 0c0-67.9 52.8-123.4 119.6-127.7l6.3-18.8c1.4-4.2 5.9-6.5 10.1-5.1s6.5 5.9 5.1 10.1L267 128.3c15.4 1 30.1 4.8 43.5 10.8l9.9-29.6c1.4-4.2 5.9-6.5 10.1-5.1s6.5 5.9 5.1 10.1l-10.7 32c7.7 4.7 14.9 10.2 21.4 16.4 3.2 3 3.4 8.1 .3 11.3s-8.1 3.4-11.3 .3c-4.8-4.6-10.1-8.7-15.7-12.4L251.2 367.8c2.4 .2 4.9 .2 7.3 .2 29.8 0 56.8-11.6 76.9-30.5 3.2-3 8.3-2.9 11.3 .3s2.9 8.3-.3 11.3c-22.9 21.6-53.8 34.9-87.9 34.9-4.2 0-8.4-.2-12.5-.6l-6.4 19.1c-1.4 4.2-5.9 6.5-10.1 5.1s-6.5-5.9-5.1-10.1l5.6-16.7c-14.9-3.4-28.9-9.4-41.3-17.5l-13.1 39.3c-1.4 4.2-5.9 6.5-10.1 5.1s-6.5-5.9-5.1-10.1l14.8-44.3c-27.3-23.5-44.7-58.3-44.7-97.2zm16 0c0 31.6 13.1 60.2 34.2 80.6l63.9-191.7c-55.3 6.8-98.1 54-98.1 111.1zm47.4 91.5c12.1 8.6 26.1 14.8 41.1 18l70.4-211.3c-13.4-6.2-28.1-9.8-43.7-10.2L193.9 347.5z", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm15.6-397.5c1.4-4.2-.9-8.7-5.1-10.1s-8.7 .9-10.1 5.1l-6.3 18.8c-66.8 4.3-119.6 59.8-119.6 127.7 0 38.9 17.3 73.7 44.7 97.2l-14.8 44.3c-1.4 4.2 .9 8.7 5.1 10.1s8.7-.9 10.1-5.1l13.1-39.3c12.4 8.1 26.4 14.1 41.3 17.5l-5.6 16.7c-1.4 4.2 .9 8.7 5.1 10.1s8.7-.9 10.1-5.1l6.4-19.1c4.1 .4 8.3 .6 12.5 .6 34 0 64.9-13.3 87.9-34.9 3.2-3 3.4-8.1 .3-11.3s-8.1-3.4-11.3-.3c-20.1 18.9-47.1 30.5-76.9 30.5-2.5 0-4.9-.1-7.3-.2l68.5-205.6c5.6 3.7 10.8 7.8 15.7 12.4 3.2 3 8.3 2.9 11.3-.3s2.9-8.3-.3-11.3c-6.5-6.2-13.7-11.7-21.4-16.4l10.7-32c1.4-4.2-.9-8.7-5.1-10.1s-8.7 .9-10.1 5.1L310.6 139c-13.5-6-28.1-9.7-43.5-10.8l4.6-13.7zm33.9 39.8L235.1 365.5c-15-3.2-29-9.4-41.1-18L261.8 144c15.6 .4 30.4 4.1 43.7 10.2zm-60.9-9.4L180.7 336.6c-21.1-20.4-34.2-48.9-34.2-80.6 0-57.2 42.8-104.3 98.1-111.1z"]],
    "child-reaching": [320, 512, [], "e59d", ["M80 172c24.3 13 51.7 20 80 20s55.7-7.1 80-20c0 58.2 0 78.2 0 60 0-4.4-3.6-8-8-8s-8 3.6-8 8l0 248c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-248c0-4.4-3.6-8-8-8s-8 3.6-8 8c0 14.7 0-5.3 0-60zM208 64a48 48 0 1 1 -96 0 48 48 0 1 1 96 0z", "M160 16a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm0 112a64 64 0 1 0 0-128 64 64 0 1 0 0 128zm0 48c-49.6 0-96.1-23.9-125-64.2L14.5 83.3c-2.6-3.6-7.6-4.4-11.2-1.8s-4.4 7.6-1.8 11.2L22 121.2C53.9 165.6 105.3 192 160 192s106.1-26.4 138-70.8l20.5-28.5c2.6-3.6 1.8-8.6-1.8-11.2s-8.6-1.8-11.2 1.8L285 111.8C256.1 152.1 209.6 176 160 176zM96 232c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 248c0 17.7 14.3 32 32 32s32-14.3 32-32l0-80c0-8.8 7.2-16 16-16s16 7.2 16 16l0 80c0 17.7 14.3 32 32 32s32-14.3 32-32l0-248c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 248c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-248z"]],
    "face-confounded": [512, 512, [], "e36c", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zm104.8-67.6c2-4 6.8-5.6 10.7-3.6l96 48c2.7 1.4 4.4 4.1 4.4 7.2s-1.7 5.8-4.4 7.2l-96 48c-4 2-8.8 .4-10.7-3.6s-.4-8.8 3.6-10.7l81.7-40.8-81.7-40.8c-4-2-5.6-6.8-3.6-10.7zm0 176c2-4 6.8-5.6 10.7-3.6l27.8 13.9 44.1-29.4c2.7-1.8 6.2-1.8 8.9 0l43.6 29 43.6-29c2.7-1.8 6.2-1.8 8.9 0l44.1 29.4 27.8-13.9c4-2 8.8-.4 10.7 3.6s.4 8.8-3.6 10.7l-32 16c-2.6 1.3-5.6 1.1-8-.5l-43.6-29-43.6 29c-2.7 1.8-6.2 1.8-8.9 0l-43.6-29-43.6 29c-2.4 1.6-5.4 1.8-8 .5l-32-16c-4-2-5.6-6.8-3.6-10.7zM280 240c0-3 1.7-5.8 4.4-7.2l96-48c4-2 8.8-.4 10.7 3.6s.4 8.8-3.6 10.7l-81.7 40.8 81.7 40.8c4 2 5.6 6.8 3.6 10.7s-6.8 5.6-10.7 3.6l-96-48c-2.7-1.4-4.4-4.1-4.4-7.2z", "M496 256a240 240 0 1 0 -480 0 240 240 0 1 0 480 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm212.4 89.3l43.6 29 43.6-29c2.7-1.8 6.2-1.8 8.9 0l44.1 29.4 27.8-13.9c4-2 8.8-.4 10.7 3.6s.4 8.8-3.6 10.7l-32 16c-2.6 1.3-5.6 1.1-8-.5l-43.6-29-43.6 29c-2.7 1.8-6.2 1.8-8.9 0l-43.6-29-43.6 29c-2.4 1.6-5.4 1.8-8 .5l-32-16c-4-2-5.6-6.8-3.6-10.7s6.8-5.6 10.7-3.6l27.8 13.9 44.1-29.4c2.7-1.8 6.2-1.8 8.9 0zM120.8 188.4c2-4 6.8-5.6 10.7-3.6l96 48c2.7 1.4 4.4 4.1 4.4 7.2s-1.7 5.8-4.4 7.2l-96 48c-4 2-8.8 .4-10.7-3.6s-.4-8.8 3.6-10.7l81.7-40.8-81.7-40.8c-4-2-5.6-6.8-3.6-10.7zm266.7 10.7l-81.7 40.8 81.7 40.8c4 2 5.6 6.8 3.6 10.7s-6.8 5.6-10.7 3.6l-96-48c-2.7-1.4-4.4-4.1-4.4-7.2s1.7-5.8 4.4-7.2l96-48c4-2 8.8-.4 10.7 3.6s.4 8.8-3.6 10.7z"]],
    "sidebar": [512, 512, [], "e24e", ["M224 80l0 352 224 0c26.5 0 48-21.5 48-48l0-256c0-26.5-21.5-48-48-48L224 80z", "M448 80c26.5 0 48 21.5 48 48l0 256c0 26.5-21.5 48-48 48l-224 0 0-352 224 0zM64 80l144 0 0 352-144 0c-26.5 0-48-21.5-48-48l0-256c0-26.5 21.5-48 48-48zm0-16C28.7 64 0 92.7 0 128L0 384c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L64 64zm8 80c-4.4 0-8 3.6-8 8s3.6 8 8 8l80 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-80 0zm0 64c-4.4 0-8 3.6-8 8s3.6 8 8 8l80 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-80 0zm0 64c-4.4 0-8 3.6-8 8s3.6 8 8 8l80 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-80 0z"]],
    "paste": [512, 512, ["file-clipboard"], "f0ea", ["M240 224l0 224c0 26.5 21.5 48 48 48l160 0c26.5 0 48-21.5 48-48l0-168.6c0-13.1-5.3-25.6-14.8-34.6l-57.7-55.4c-8.9-8.6-20.9-13.4-33.2-13.4L288 176c-26.5 0-48 21.5-48 48z", "M64 16l224 0c26.5 0 48 21.5 48 48l0 48 16 0 0-48c0-35.3-28.7-64-64-64L64 0C28.7 0 0 28.7 0 64L0 384c0 35.3 28.7 64 64 64l112 0 0-16-112 0c-26.5 0-48-21.5-48-48L16 64c0-26.5 21.5-48 48-48zm46.6 80L88 96c-4.4 0-8 3.6-8 8s3.6 8 8 8l144 0c4.4 0 8-3.6 8-8s-3.6-8-8-8L110.6 96zM448 496l-160 0c-26.5 0-48-21.5-48-48l0-224c0-26.5 21.5-48 48-48l102.3 0c12.4 0 24.3 4.8 33.2 13.4l57.7 55.4c9.4 9.1 14.8 21.6 14.8 34.6L496 448c0 26.5-21.5 48-48 48zM224 224l0 224c0 35.3 28.7 64 64 64l160 0c35.3 0 64-28.7 64-64l0-168.6c0-17.4-7.1-34.1-19.7-46.2l-57.8-55.4c-11.9-11.4-27.8-17.8-44.3-17.8L288 160c-35.3 0-64 28.7-64 64z"]],
    "inhaler": [640, 512, [], "f5f9", ["M240 264l0 176c0 13.3 10.7 24 24 24l196.5 0c17.6 0 33.1-11.5 38.2-28.2l55.7-181-147.6-117.4-31.2 97.1c-1.1 3.3-4.1 5.6-7.6 5.6l-104 0c-13.3 0-24 10.7-24 24z", "M423.1 34.4c6.5-20.2 27.6-31.8 48.2-26.5L593.7 39.8c22 5.7 34.8 28.7 28.1 50.5L514.1 440.5C506.8 464 485.1 480 460.6 480L264 480c-22.1 0-40-17.9-40-40l0-176c0-22.1 17.9-40 40-40l98.2 0 61-189.6zm44.1-11c-12.3-3.2-25 3.8-28.9 15.9l-26.3 81.8 .9 .7 146.6 116.6 47-152.7c4-13.1-3.7-26.8-16.9-30.3L467.3 23.4zm87.2 231.3l-147.6-117.4-31.2 97.1c-1.1 3.3-4.1 5.6-7.6 5.6l-104 0c-13.3 0-24 10.7-24 24l0 176c0 13.3 10.7 24 24 24l196.5 0c17.6 0 33.1-11.5 38.2-28.2l55.7-181zM32 336a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM48 448a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm80-160a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM48 256a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm80 128a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"]],
    "meteor": [512, 512, [9732], "f753", ["M16 313.1c0 100.5 81.5 182.9 181.9 182.9 58.9 0 114.2-28.5 148.3-76.6L487.5 220.6c3.8-5.3 0-12.6-6.5-12.6l-47.4 0c-2.7 0-5.2-1.4-6.7-3.6s-1.7-5.1-.6-7.6L494.6 41.4c.9-2 1.4-4.2 1.4-6.4l0-3c0-8.8-7.2-16-16-16l-3 0c-2.2 0-4.4 .5-6.4 1.4L315.2 85.7c-2.5 1.1-5.3 .9-7.6-.6s-3.6-4-3.6-6.7l0-54.7c0-6.6-7.5-10.3-12.7-6.4L90.6 165.1C43.7 199.6 16 254.9 16 313.1zM320 320a128 128 0 1 1 -256 0 128 128 0 1 1 256 0zM144 288a16 16 0 1 0 32 0 16 16 0 1 0 -32 0z", "M320 23.7c0-19.7-22.4-31-38.2-19.3 4.7 6.4 4.7 6.4 0 0L81.1 152.2C30.1 189.8 0 249.8 0 313.1 0 422.4 88.6 512 197.9 512 262.1 512 322.2 481 359.3 428.7L500.6 229.9C511.9 214 500.5 192 481 192l-35.1 0 63.4-144.2c1.8-4.1 2.7-8.5 2.7-12.9l0-3c0-17.7-14.3-32-32-32l-3 0c-4.4 0-8.8 .9-12.9 2.7l0 0-144.2 63.4 0-42.5zm-28.7-6.4c5.3-3.9 12.7-.1 12.7 6.4l0 54.7c0 2.7 1.4 5.2 3.6 6.7s5.1 1.7 7.6 .6L470.6 17.4c2-.9 4.2-1.4 6.4-1.4l3 0c8.8 0 16 7.2 16 16l0 3c0 2.2-.5 4.4-1.4 6.4L426.3 196.8c-1.1 2.5-.9 5.3 .6 7.6s4 3.6 6.7 3.6l47.4 0c6.5 0 10.3 7.3 6.5 12.6L346.3 419.4c-34.1 48-89.4 76.6-148.3 76.6-100.4 0-181.9-82.3-181.9-182.9 0-58.3 27.7-113.5 74.6-148L291.3 17.2zM64 320a128 128 0 1 0 256 0 128 128 0 1 0 -256 0zm16 0a112 112 0 1 1 224 0 112 112 0 1 1 -224 0zm144 48a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm-48-80a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm-16-32a32 32 0 1 0 0 64 32 32 0 1 0 0-64z"]],
    "honey-pot": [448, 512, [127855], "e418", ["M16 224c0 5.4 .1 10.8 .4 16l415.3 0c.2-5.2 .4-10.6 .4-16 0-61.9-50.1-112-112-112l-80 0 0-16 136 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-168 0 0 92c0 15.5-12.5 28-28 28s-28-12.5-28-28l0-92-80 0C58.7 48 48 58.7 48 72S58.7 96 72 96l56 0 0 16C66.1 112 16 162.1 16 224zM43 352c24.9 54.7 60.9 89 80.4 104.7 5.9 4.8 13.9 7.3 23 7.3l155.3 0c9.1 0 17.1-2.5 23-7.3 19.5-15.7 55.4-50.1 80.4-104.7L43 352z", "M376 48c13.3 0 24 10.7 24 24s-10.7 24-24 24l-136 0 0 16 80 0c61.9 0 112 50.1 112 112 0 5.4-.1 10.8-.4 16L16.4 240c-.2-5.2-.4-10.6-.4-16 0-61.9 50.1-112 112-112l0-16-56 0C58.7 96 48 85.3 48 72S58.7 48 72 48l80 0 0 92c0 15.5 12.5 28 28 28s28-12.5 28-28l0-92 168 0zm54.5 208c-2.9 30-9.7 56.6-18.7 80L36.3 336c-9-23.4-15.8-50-18.7-80l413 0zM405 352c-24.9 54.7-60.9 89-80.4 104.7-5.9 4.8-13.9 7.3-23 7.3l-155.3 0c-9.1 0-17.1-2.5-23-7.3-19.5-15.7-55.4-50.1-80.4-104.7l362 0zM168 48l24 0 0 92c0 6.6-5.4 12-12 12s-12-5.4-12-12l0-92zM32 72c0 20.3 15.1 37 34.6 39.6-39.7 21.7-66.6 63.9-66.6 112.4 0 138.8 79.6 217.9 113.3 245.1 9.3 7.5 21.1 10.9 33.1 10.9l155.3 0c12 0 23.7-3.3 33.1-10.9 33.6-27.2 113.3-106.3 113.3-245.1 0-48.5-26.9-90.6-66.6-112.4 19.6-2.6 34.6-19.4 34.6-39.6 0-22.1-17.9-40-40-40L72 32C49.9 32 32 49.9 32 72z"]],
    "laptop-slash": [640, 512, [], "e1c7", ["M123.6 48.2L411.4 336 560 336 560 96c0-26.5-21.5-48-48-48L128 48c-1.5 0-2.9 .1-4.4 .2zM475.4 400l64 64 23.8 0c33.6 0 60.8-27.2 60.8-60.8 0-1.8-1.4-3.2-3.2-3.2l-145.4 0z", "M45.7-29.8c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l560 560c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-50.2-50.2 7.8 0c42.4 0 76.8-34.4 76.8-76.8 0-10.6-8.6-19.2-19.2-19.2L459.4 384 123.6 48.2c1.4-.1 2.9-.2 4.4-.2l384 0c26.5 0 48 21.5 48 48l0 240 16 0 0-240c0-35.3-28.7-64-64-64L128 32c-6.3 0-12.3 .9-18 2.6L45.7-29.8zM475.4 400l145.4 0c1.8 0 3.2 1.4 3.2 3.2 0 33.6-27.2 60.8-60.8 60.8l-23.8 0-64-64zm-26.6 64l-372 0c-33.6 0-60.8-27.2-60.8-60.8 0-1.8 1.4-3.2 3.2-3.2l365.6 0-16-16-349.6 0C8.6 384 0 392.6 0 403.2 0 445.6 34.4 480 76.8 480l388 0-16-16zM80 95.2L65.8 81C64.6 85.8 64 90.8 64 96l0 240 16 0 0-240 0-.8z"]],
    "gears": [576, 512, ["cogs"], "f085", ["M18 153.2l6.5 24.2c2 7.3 8.8 12.2 16.3 11.8l29.8-1.6c2.7-.1 5.2 1 6.8 3.2 5.7 7.6 12.5 14.4 20.2 20.2 2.1 1.6 3.3 4.2 3.2 6.8l-1.6 29.7c-.4 7.6 4.5 14.4 11.8 16.3l24.2 6.5c7.3 2 15-1.5 18.4-8.2l13.5-26.6c1.2-2.4 3.5-4 6.1-4.3 9.6-1.2 18.8-3.7 27.6-7.4 2.5-1 5.3-.8 7.5 .7l25 16.3c6.3 4.1 14.7 3.3 20.1-2.1L271.1 221c5.4-5.4 6.2-13.7 2.1-20.1l-16.3-25c-1.5-2.2-1.7-5-.7-7.5 1.8-4.3 3.4-8.9 4.6-13.6s2.2-9.4 2.8-14.1c.3-2.6 2-4.9 4.3-6.1l26.6-13.5c6.7-3.4 10.2-11.1 8.2-18.4l-6.5-24.2c-2-7.3-8.8-12.2-16.3-11.8l-29.8 1.6c-2.7 .1-5.2-1-6.8-3.2-5.7-7.6-12.5-14.4-20.2-20.2-2.1-1.6-3.3-4.2-3.2-6.8l1.6-29.7c.4-7.6-4.5-14.4-11.8-16.3l-24.2-6.5c-7.3-2-15 1.5-18.4 8.2L153.7 20.4c-1.2 2.4-3.5 4-6.1 4.3-9.6 1.2-18.8 3.7-27.6 7.4-2.5 1-5.3 .8-7.5-.7l-25-16.3c-6.3-4.1-14.7-3.3-20.1 2.1L49.7 35c-5.4 5.4-6.2 13.7-2.1 20.1l16.3 25c1.5 2.2 1.7 5 .7 7.5-1.8 4.3-3.4 8.9-4.6 13.6s-2.2 9.4-2.8 14.1c-.3 2.6-2 4.9-4.3 6.1L26.3 134.8c-6.7 3.4-10.2 11.1-8.2 18.4zm188.7-12.7a48 48 0 1 1 -92.7-24.8 48 48 0 1 1 92.7 24.8zM274 358.8c-2 7.3 1.5 15 8.2 18.4l26.6 13.5c2.4 1.2 4 3.5 4.3 6.1 .6 4.7 1.5 9.4 2.8 14.1s2.8 9.2 4.6 13.6c1 2.4 .8 5.2-.7 7.5l-16.3 25c-4.1 6.3-3.3 14.7 2.1 20.1l17.7 17.7c5.4 5.4 13.7 6.2 20.1 2.1l25-16.3c2.2-1.5 5-1.7 7.5-.7 8.8 3.7 18 6.2 27.6 7.4 2.6 .3 4.9 1.9 6.1 4.3l13.5 26.6c3.4 6.7 11.1 10.2 18.4 8.2l24.2-6.5c7.3-2 12.2-8.8 11.8-16.3L476 473.8c-.1-2.7 1-5.2 3.2-6.8 7.7-5.8 14.5-12.6 20.2-20.2 1.6-2.1 4.2-3.3 6.8-3.2l29.8 1.6c7.6 .4 14.4-4.5 16.3-11.8l6.5-24.2c2-7.3-1.5-15-8.2-18.4l-26.6-13.5c-2.4-1.2-4-3.5-4.3-6.1-.6-4.7-1.5-9.4-2.8-14.1s-2.8-9.2-4.6-13.6c-1-2.4-.8-5.2 .7-7.5l16.3-25c4.1-6.3 3.3-14.7-2.1-20.1l-17.7-17.7c-5.4-5.4-13.7-6.2-20.1-2.1l-25 16.3c-2.2 1.5-5 1.7-7.5 .7-8.8-3.7-18-6.2-27.6-7.4-2.6-.3-4.9-1.9-6.1-4.3l-13.5-26.6c-3.4-6.7-11.1-10.2-18.4-8.2L367 248.1c-7.3 2-12.2 8.8-11.8 16.3l1.6 29.7c.1 2.7-1 5.2-3.2 6.8-7.7 5.8-14.5 12.6-20.2 20.2-1.6 2.1-4.2 3.3-6.8 3.2l-29.8-1.6c-7.6-.4-14.4 4.5-16.3 11.8L274 358.8zm188.7 12.7a48 48 0 1 1 -92.7 24.8 48 48 0 1 1 92.7-24.8z", "M185.6-14.3c-7.3-2-15 1.5-18.4 8.2L153.7 20.4c-1.2 2.4-3.5 4-6.1 4.3-9.6 1.2-18.8 3.7-27.6 7.4-2.5 1-5.3 .8-7.5-.7l-25-16.3c-6.3-4.1-14.7-3.3-20.1 2.1L49.7 35c-5.4 5.4-6.2 13.7-2.1 20.1l16.3 25c1.5 2.2 1.7 5 .7 7.5-1.8 4.3-3.4 8.9-4.6 13.6s-2.2 9.4-2.8 14.1c-.3 2.6-2 4.9-4.3 6.1L26.3 134.8c-6.7 3.4-10.2 11.1-8.2 18.4l6.5 24.2c2 7.3 8.8 12.2 16.3 11.8l29.8-1.6c2.7-.1 5.2 1 6.8 3.2 5.7 7.6 12.5 14.4 20.2 20.2 2.1 1.6 3.3 4.2 3.2 6.8l-1.6 29.7c-.4 7.6 4.5 14.4 11.8 16.3l24.2 6.5c7.3 2 15-1.5 18.4-8.2l13.5-26.6c1.2-2.4 3.5-4 6.1-4.3 9.6-1.2 18.8-3.7 27.6-7.4 2.5-1 5.3-.8 7.5 .7l25 16.3c6.3 4.1 14.7 3.3 20.1-2.1L271.1 221c5.4-5.4 6.2-13.7 2.1-20.1l-16.3-25c-1.5-2.2-1.7-5-.7-7.5 1.8-4.3 3.4-8.9 4.6-13.6s2.2-9.4 2.8-14.1c.3-2.6 2-4.9 4.3-6.1l26.6-13.5c6.7-3.4 10.2-11.1 8.2-18.4l-6.5-24.2c-2-7.3-8.8-12.2-16.3-11.8l-29.8 1.6c-2.7 .1-5.2-1-6.8-3.2-5.7-7.6-12.5-14.4-20.2-20.2-2.1-1.6-3.3-4.2-3.2-6.8l1.6-29.7c.4-7.6-4.5-14.4-11.8-16.3l-24.2-6.5zm-32.7 1c6.8-13.5 22.2-20.4 36.8-16.4l24.2 6.5c14.6 3.9 24.5 17.5 23.7 32.6l-1.4 25.6c6.4 5.2 12.1 11 17.3 17.3L279 50.8c15.1-.8 28.7 9.1 32.6 23.7l6.5 24.2c3.9 14.6-2.9 30-16.4 36.8l-22.9 11.6c-.6 4-1.5 8-2.6 11.9s-2.3 7.9-3.8 11.6l14 21.5c8.3 12.7 6.5 29.4-4.2 40.1L264.7 250c-10.7 10.7-27.4 12.4-40.1 4.2l-21.5-14c-7.6 2.9-15.5 5-23.6 6.3l-11.6 22.9c-6.8 13.5-22.2 20.4-36.8 16.4l-24.2-6.5c-14.6-3.9-24.5-17.5-23.7-32.6l1.4-25.6c-6.4-5.2-12.1-11-17.3-17.3l-25.6 1.4C26.6 206 13 196.1 9.1 181.5L2.6 157.3c-3.9-14.6 2.9-30 16.4-36.8l22.9-11.6c.6-4 1.5-8 2.6-11.9s2.3-7.9 3.8-11.6l-14-21.5c-8.3-12.7-6.5-29.4 4.2-40.1L56.1 6C66.8-4.7 83.5-6.4 96.2 1.8l21.5 14c7.6-2.9 15.5-5 23.6-6.3l11.6-22.9zM148 174.4A48 48 0 1 1 172.8 81.6 48 48 0 1 1 148 174.4zm43.3-38.1a32 32 0 1 0 -61.8-16.6 32 32 0 1 0 61.8 16.6zM367 248.1c-7.3 2-12.2 8.8-11.8 16.3l1.6 29.7c.1 2.7-1 5.2-3.2 6.8-7.7 5.8-14.5 12.6-20.2 20.2-1.6 2.1-4.2 3.3-6.8 3.2l-29.8-1.6c-7.6-.4-14.4 4.5-16.3 11.8L274 358.8c-2 7.3 1.5 15 8.2 18.4l26.6 13.5c2.4 1.2 4 3.5 4.3 6.1 .6 4.7 1.5 9.4 2.8 14.1s2.8 9.2 4.6 13.6c1 2.4 .8 5.2-.7 7.5l-16.3 25c-4.1 6.3-3.3 14.7 2.1 20.1l17.7 17.7c5.4 5.4 13.7 6.2 20.1 2.1l25-16.3c2.2-1.5 5-1.7 7.5-.7 8.8 3.7 18 6.2 27.6 7.4 2.6 .3 4.9 1.9 6.1 4.3l13.5 26.6c3.4 6.7 11.1 10.2 18.4 8.2l24.2-6.5c7.3-2 12.2-8.8 11.8-16.3L476 473.8c-.1-2.7 1-5.2 3.2-6.8 7.7-5.8 14.5-12.6 20.2-20.2 1.6-2.1 4.2-3.3 6.8-3.2l29.8 1.6c7.6 .4 14.4-4.5 16.3-11.8l6.5-24.2c2-7.3-1.5-15-8.2-18.4l-26.6-13.5c-2.4-1.2-4-3.5-4.3-6.1-.6-4.7-1.5-9.4-2.8-14.1s-2.8-9.2-4.6-13.6c-1-2.4-.8-5.2 .7-7.5l16.3-25c4.1-6.3 3.3-14.7-2.1-20.1l-17.7-17.7c-5.4-5.4-13.7-6.2-20.1-2.1l-25 16.3c-2.2 1.5-5 1.7-7.5 .7-8.8-3.7-18-6.2-27.6-7.4-2.6-.3-4.9-1.9-6.1-4.3l-13.5-26.6c-3.4-6.7-11.1-10.2-18.4-8.2L367 248.1zm-27.8 17.2c-.8-15.1 9.1-28.7 23.7-32.6l24.2-6.5c14.6-3.9 30 2.9 36.8 16.4l11.6 22.9c8.1 1.3 16 3.4 23.6 6.3l21.5-14c12.7-8.3 29.4-6.5 40.1 4.2l17.7 17.7c10.7 10.7 12.4 27.4 4.2 40.1l-14 21.5c1.4 3.8 2.7 7.7 3.8 11.6s1.9 8 2.6 11.9l22.9 11.6c13.5 6.8 20.4 22.2 16.4 36.8l-6.5 24.2c-3.9 14.6-17.5 24.5-32.6 23.7l-25.6-1.4c-5.1 6.3-10.9 12.1-17.3 17.3l1.4 25.6c.8 15.1-9.1 28.7-23.7 32.6l-24.2 6.5c-14.6 3.9-30-2.9-36.8-16.4l-11.6-22.9c-8.1-1.3-16-3.4-23.6-6.3l-21.5 14c-12.7 8.3-29.4 6.5-40.1-4.2l-17.7-17.7c-10.7-10.7-12.4-27.4-4.2-40.1l14-21.5c-1.4-3.8-2.7-7.7-3.8-11.6s-1.9-8-2.6-11.9L275 391.5c-13.5-6.8-20.4-22.2-16.4-36.8l6.5-24.2c3.9-14.6 17.5-24.5 32.6-23.7l25.6 1.4c5.1-6.3 10.9-12.1 17.3-17.3l-1.4-25.6zm89.6 165a48 48 0 1 1 -24.9-92.7 48 48 0 1 1 24.9 92.7zm18.5-54.6a32 32 0 1 0 -61.8 16.6 32 32 0 1 0 61.8-16.6z"]],
    "wave-sine": [576, 512, [8767], "f899", ["", "M46.1 133.7c17.2-42.2 58.3-69.7 103.8-69.7 47.7 0 90.3 30.2 105.9 75.3l79.3 228.1c13.4 38.7 49.9 64.6 90.8 64.6 39.1 0 74.2-23.6 89-59.8L560.6 261c1.7-4.1 6.3-6 10.4-4.4s6 6.3 4.4 10.4L529.9 378.3c-17.2 42.2-58.3 69.7-103.8 69.7-47.7 0-90.3-30.2-105.9-75.3L240.8 144.6c-13.4-38.7-49.9-64.6-90.8-64.6-39.1 0-74.2 23.6-89 59.8L15.4 251c-1.7 4.1-6.3 6-10.4 4.4s-6-6.3-4.4-10.4L46.1 133.7z"]],
    "arrow-turn-left-up": [384, 512, [], "e634", ["", "M376 496c4.4 0 8 3.6 8 8s-3.6 8-8 8l-96 0c-53 0-96-43-96-96L184 27.3 45.7 165.7c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l152-152c3.1-3.1 8.2-3.1 11.3 0l152 152c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L200 27.3 200 416c0 44.2 35.8 80 80 80l96 0z"]],
    "garage": [576, 512, [], "e009", ["M8 512c4.4 0 8-3.6 8-8l0-312 544 0 0 312c0 4.4 3.6 8 8 8-32 0-64 0-96 0 4.4 0 8-3.6 8-8l0-224c0-13.3-10.7-24-24-24l-336 0c-13.3 0-24 10.7-24 24l0 224c0 4.4 3.6 8 8 8-32 0-64 0-96 0zm8-361.7C16 133.8 26.1 119 41.5 113L276.4 21.7c7.5-2.9 15.7-2.9 23.2 0L534.5 113c15.4 6 25.5 20.8 25.5 37.3l0 25.7-544 0 0-25.7z", "M576 150.3L576 504c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-312-544 0 0 312c0 4.4-3.6 8-8 8s-8-3.6-8-8L0 150.3c0-23.1 14.2-43.8 35.7-52.2L270.6 6.8c11.2-4.4 23.6-4.4 34.8 0L540.3 98.1c21.5 8.4 35.7 29.1 35.7 52.2zm-16 0c0-16.5-10.1-31.3-25.5-37.3L299.6 21.7c-7.5-2.9-15.7-2.9-23.2 0L41.5 113C26.1 119 16 133.8 16 150.3l0 25.7 544 0 0-25.7zM112 280l0 88 352 0 0-88c0-4.4-3.6-8-8-8l-336 0c-4.4 0-8 3.6-8 8zM464 504l0-120-352 0 0 120c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-224c0-13.3 10.7-24 24-24l336 0c13.3 0 24 10.7 24 24l0 224c0 4.4-3.6 8-8 8s-8-3.6-8-8zM224 464l128 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-128 0c-4.4 0-8-3.6-8-8s3.6-8 8-8z"]],
    "flatbread-stuffed": [512, 512, [129369], "e40c", ["M109 425.7c-6.7 6.7-5.4 15.7-.1 19.8 40.7 31.6 91.7 50.4 147.2 50.4 132.5 0 240-107.5 240-240 0-55.5-18.8-106.6-50.4-147.2-4.1-5.3-13.2-6.5-19.8 .1L109 425.7zM136.1 248c0 17 5.3 32.8 14.4 45.8 37.1-37.1 74.3-74.2 111.4-111.4-13-9.1-28.7-14.4-45.8-14.4-44.2 0-80 35.8-80 80zm104 168a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm96 0a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M393.2 31.9c5.5-.2 10.8 1.2 15.3 3.7L396.2 48c-.8-.1-1.6-.2-2.4-.1l-63.5 2.2c-9.6 .3-19-2.4-26.9-7.7L250.6 6.8c-5.1-3.4-12-3-16.7 1.3L186.4 51c-7.1 6.4-16 10.5-25.5 11.5L97.7 69.6c-6.2 .7-11.3 5.6-12.2 12l-9.3 63.5c-1.4 9.5-5.7 18.3-12.2 25.2L19.9 216.8c-4.4 4.7-5.2 11.8-1.9 17.2l33.3 54.4c5 8.2 7.3 17.7 6.7 27.2l-4.4 64c-.2 3.2 .6 6.2 2.2 8.7L44.5 399.7c-4.8-5.8-7.3-13.3-6.8-21.2l4.4-64c.4-6.2-1.1-12.5-4.3-17.8L4.4 242.3c-7.1-11.6-5.5-26.7 3.9-36.6l44.1-46.4c4.3-4.5 7.1-10.3 8-16.5l9.3-63.5c2-13.6 12.8-24.1 26.3-25.6l63.2-7.1c6.2-.7 12-3.3 16.6-7.5L223.2-3.8c10.1-9.2 25.1-10.2 36.4-2.7l52.7 35.5c5.1 3.5 11.2 5.2 17.4 5l63.5-2.2zM108.9 445.6c40.7 31.6 91.7 50.4 147.2 50.4 132.5 0 240-107.5 240-240 0-55.5-18.8-106.6-50.4-147.2-4.1-5.3-13.2-6.5-19.8 .1L109 425.7c-6.7 6.7-5.4 15.7-.1 19.8zM99 458.2c-13.9-10.9-13.8-31.3-1.3-43.8L414.5 97.6c12.5-12.5 32.9-12.6 43.8 1.3 33.7 43.4 53.8 97.9 53.8 157 0 141.4-114.6 256-256 256-59.2 0-113.7-20.1-157-53.8zm109-42.2a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm112-16a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm-104-248c21.4 0 41.2 7 57.2 18.9l-11.5 11.5c-13-9.1-28.7-14.4-45.8-14.4-44.2 0-80 35.8-80 80 0 17 5.3 32.8 14.4 45.8L139 305.2c-11.9-16-18.9-35.8-18.9-57.2 0-53 43-96 96-96z"]],
    "u-turn-down-left": [512, 512, [], "e7ef", ["M16 384c0-4.1 1.6-7.5 5.1-11.7L132.7 260.7c10-10 27.3-2.8 27.3 11.3l0 56c0 4.4 3.6 8 8 8l136 0c53 0 96-43 96-96s-43-96-96-96L96 144c-9.4 0-15.2-7.4-16-16l0-64c0-9.4 7.4-15.2 16-16l208 0c106 0 192 86 192 192S410 432 304 432l-136 0c-4.2 0-8 3.8-8 8l0 56c-1 13.3-16.9 21.7-27.3 11.3L21 395.6c-2.9-3.6-4.5-7.1-5-11.6z", "M0 384c0 8.1 3.6 16.8 9.3 22.6l112 112c20.8 20.8 52.7 4 54.6-22.6l0-48 128 0c114.9 0 208-93.1 208-208S418.9 32 304 32L96 32c-17.4 .8-32 13.9-32 32l0 64c.8 17.4 13.9 32 32 32l208 0c44.2 0 80 35.8 80 80s-35.8 80-80 80l-128 0 0-48c0-12.9-7.8-24.6-19.7-29.6-11.9-4.9-25.7-2.2-34.9 6.9l-112 112C3.6 367.2 0 375.9 0 384zm16 0c0-4.1 1.6-7.5 5.1-11.7L132.7 260.7c10-10 27.3-2.8 27.3 11.3l0 56c0 4.4 3.6 8 8 8l136 0c53 0 96-43 96-96s-43-96-96-96L96 144c-9.4 0-15.2-7.4-16-16l0-64c0-9.4 7.4-15.2 16-16l208 0c106 0 192 86 192 192S410 432 304 432l-136 0c-4.2 0-8 3.8-8 8l0 56c-1 13.3-16.9 21.7-27.3 11.3L21 395.6c-2.9-3.6-4.5-7.1-5-11.6z"]],
    "face-shaking-horizontal": [640, 512, [], "e79d", ["M48 256c0-132.5 107.5-240 240-240 98.4 0 183 59.2 220 144l17.4 0c6.2 15.3 11 31.4 14.1 48L456 208c-4.4 0-8 3.6-8 8s3.6 8 8 8l86 0c2.2 17.9 3.9 46.4-2.5 80L456 304c-4.4 0-8 3.6-8 8s3.6 8 8 8l79.9 0c-4.3 16.7-10.3 32.8-17.7 48l-17.9 0C460.1 444.1 380.1 496 288 496 155.5 496 48 388.5 48 256zm64-24c0 4.4 3.6 8 8 8s8-3.6 8-8c0-22.1 17.9-40 40-40l16 0c22.1 0 40 17.9 40 40 0 4.4 3.6 8 8 8s8-3.6 8-8c0-30.9-25.1-56-56-56l-16 0c-30.9 0-56 25.1-56 56zm24.6 110.1c27.8 35.3 71 57.9 119.4 57.9s91.6-22.7 119.4-57.9c2.7-3.5 2.1-8.5-1.3-11.2s-8.5-2.1-11.2 1.3C337.9 363.7 299.3 384 256 384s-81.9-20.3-106.8-51.8c-2.7-3.5-7.8-4.1-11.2-1.3s-4.1 7.8-1.3 11.2zM272 232c0 4.4 3.6 8 8 8s8-3.6 8-8c0-22.1 17.9-40 40-40l16 0c22.1 0 40 17.9 40 40 0 4.4 3.6 8 8 8s8-3.6 8-8c0-30.9-25.1-56-56-56l-16 0c-30.9 0-56 25.1-56 56z", "M288 496c92.1 0 172.1-51.9 212.3-128l17.9 0c-41.5 85.3-129 144-230.3 144-141.4 0-256-114.6-256-256S146.6 0 288 0C395.4 0 487.4 66.2 525.4 160L508 160C471 75.2 386.4 16 288 16 155.5 16 48 123.5 48 256S155.5 496 288 496zM149.2 332.2C174.1 363.7 212.7 384 256 384s81.9-20.3 106.8-51.8c2.7-3.5 7.8-4.1 11.2-1.3s4.1 7.8 1.3 11.2C347.6 377.3 304.4 400 256 400s-91.6-22.7-119.4-57.9c-2.7-3.5-2.1-8.5 1.3-11.2s8.5-2.1 11.2 1.3zM168 192c-22.1 0-40 17.9-40 40 0 4.4-3.6 8-8 8s-8-3.6-8-8c0-30.9 25.1-56 56-56l16 0c30.9 0 56 25.1 56 56 0 4.4-3.6 8-8 8s-8-3.6-8-8c0-22.1-17.9-40-40-40l-16 0zm120 40c0 4.4-3.6 8-8 8s-8-3.6-8-8c0-30.9 25.1-56 56-56l16 0c30.9 0 56 25.1 56 56 0 4.4-3.6 8-8 8s-8-3.6-8-8c0-22.1-17.9-40-40-40l-16 0c-22.1 0-40 17.9-40 40zM544 72c0-4.4 3.6-8 8-8l8 0c44.2 0 80 35.8 80 80s-35.8 80-80 80l-104 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l104 0c35.3 0 64-28.7 64-64s-28.7-64-64-64l-8 0c-4.4 0-8-3.6-8-8zm16 232c24.3 0 45.4-13.5 56.2-33.4 7.5-3.1 14.7-6.8 21.4-11.2-8.7 34.8-40.1 60.6-77.6 60.6l-104 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l104 0z"]],
    "eyes": [576, 512, [], "e367", ["M16 288a64 64 0 1 0 128 0 64 64 0 1 0 -128 0zm280.1-3.4c-.1 1.1-.1 2.2-.1 3.4 0 1.1 0 2.1 .1 3.4 1.7 33.7 29.6 60.6 63.9 60.6 35.3 0 64-28.7 64-64s-28.7-64-64-64c-34.3 0-62.3 27-63.9 60.6z", "M280 256c0 59.2-15.9 112-40.7 149.6-24.9 37.7-57.5 58.4-91.3 58.4s-66.4-20.7-91.3-58.4c-10.4-15.7-19.2-34.1-26-54.5 13.6 10.6 30.7 17 49.3 17 44.2 0 80-35.8 80-80s-35.8-80-80-80c-25.9 0-49 12.3-63.6 31.4 2.7-52.4 17.8-99 40.3-133 24.9-37.7 57.5-58.4 91.3-58.4s66.4 20.7 91.3 58.4C264.1 144 280 196.8 280 256zm8-72.8C268 95.2 212.9 32 148 32 66.3 32 0 132.3 0 256S66.3 480 148 480c64.9 0 120-63.2 140-151.2 20 88 75.1 151.2 140 151.2 81.7 0 148-100.3 148-224S509.7 32 428 32c-64.9 0-120 63.2-140 151.2zM310.7 351c13.6 10.6 30.7 17 49.3 17 44.2 0 80-35.8 80-80s-35.8-80-80-80c-25.9 0-49 12.3-63.6 31.4 2.7-52.4 17.8-99 40.3-133 24.9-37.7 57.5-58.4 91.3-58.4s66.4 20.7 91.3 58.4C544.1 144 560 196.8 560 256s-15.9 112-40.7 149.6C494.4 443.3 461.8 464 428 464s-66.4-20.7-91.3-58.4c-10.4-15.7-19.2-34.1-26-54.5zM16 288a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zm344-64a64 64 0 1 1 0 128 64 64 0 1 1 0-128z"]],
    "dash": [512, 512, ["minus-large"], "e404", ["", "M0 256c0-4.4 3.6-8 8-8l496 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L8 264c-4.4 0-8-3.6-8-8z"]],
    "photo-film-music": [640, 512, [], "e228", ["M208 64c0-26.5 21.5-48 48-48l288 0c26.5 0 48 21.5 48 48l0 119.1c-17 3.5-34.1 7.1-51.1 10.6l-55.7-83.5c-5.9-8.9-15.9-14.2-26.6-14.2s-20.7 5.3-26.6 14.2l-44.7 67-19.8-22.5c-6.5-7.4-16-11.4-25.9-10.8s-18.8 5.6-24.5 13.7l-55.4 79.9c-6.8 9.8-7.6 22.5-2.1 33.1s16.4 17.2 28.4 17.2l96 0 0 48.2-128 0c-26.5 0-48-21.5-48-48l0-224zm40 32a40 40 0 1 0 80 0 40 40 0 1 0 -80 0z", "M544 16L256 16c-26.5 0-48 21.5-48 48l0 224c0 26.5 21.5 48 48 48l128 0 0 16-128 0c-35.3 0-64-28.7-64-64l0-224c0-35.3 28.7-64 64-64L544 0c35.3 0 64 28.7 64 64l0 115.8-16 3.3 0-119.1c0-26.5-21.5-48-48-48zm-3.1 177.8l-16.9 3.5-52.1-78.2c-3-4.4-8-7.1-13.3-7.1s-10.3 2.7-13.3 7.1l-50.5 75.7c-1.4 2.1-3.6 3.4-6.1 3.5s-4.9-.8-6.5-2.7l-26.7-30.3c-3.3-3.7-8-5.7-12.9-5.4s-9.4 2.8-12.2 6.9l-55.4 79.9c-3.4 4.9-3.8 11.3-1 16.5s8.2 8.6 14.2 8.6l96.3 0c-.2 2.2-.3 4.4-.3 6.7l0 9.3-96 0c-11.9 0-22.8-6.6-28.4-17.2s-4.7-23.3 2.1-33.1l55.4-79.9c5.6-8.1 14.6-13.1 24.5-13.7s19.4 3.4 25.9 10.8l19.8 22.5 44.7-67c5.9-8.9 15.9-14.2 26.6-14.2s20.7 5.3 26.6 14.2l55.7 83.5zM276.2 464c-1.6 5.1-2.8 10.4-3.4 16L64 480c-35.3 0-64-28.7-64-64L0 192c0-35.3 28.7-64 64-64l80 0 0 16-32 0 0 320 164.2 0zM288 72a24 24 0 1 0 0 48 24 24 0 1 0 0-48zm40 24a40 40 0 1 1 -80 0 40 40 0 1 1 80 0zM16 368l0 48c0 26.5 21.5 48 48 48l32 0 0-96-80 0zm0-16l80 0 0-96-80 0 0 96zm0-112l80 0 0-96-32 0c-26.5 0-48 21.5-48 48l0 48zm624 1.7l0 218.3c0 28.7-28.6 52-64 52s-64-23.3-64-52 28.6-52 64-52c19.1 0 36.3 6.8 48 17.6l0-103.9-176 36.7 0 133.6c0 28.7-28.6 52-64 52s-64-23.3-64-52 28.6-52 64-52c19.1 0 36.3 6.8 48 17.6l0-179.2c0-7.6 5.3-14.1 12.7-15.7l176-36.7c9.9-2.1 19.3 5.5 19.3 15.7zm-16 63.7l0-63.7-176 36.7 0 63.7 176-36.7zM384 455.9c-29.7 0-48 19-48 36s18.3 36 48 36 48-19 48-36-18.3-36-48-36zm240 4c0-17-18.3-36-48-36s-48 19-48 36 18.3 36 48 36 48-19 48-36z"]],
    "location-arrow-slash": [576, 512, [], "e77a", ["M198.5 155.1L474.3 49.1c5.9-2.3 12.6-.9 17.1 3.6s5.9 11.2 3.6 17.1L388.9 345.5 198.5 155.1z", "M13.7-29.8c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l560 560c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3L401.3 357.9 509.9 75.5c4.5-11.8 1.7-25.2-7.2-34.1s-22.3-11.8-34.1-7.2L186.1 142.7 13.7-29.8zM198.5 155.1L474.3 49.1c5.9-2.3 12.6-.9 17.1 3.6s5.9 11.2 3.6 17.1L388.9 345.5 198.5 155.1zM58.3 209.1l74.8-28.8-12.4-12.4-68.2 26.2C39.9 199 31.7 211.2 32 224.7s9.1 25.4 21.9 29.6l176.8 58.9 58.9 176.8c4.3 12.8 16.1 21.6 29.6 21.9s25.7-7.9 30.6-20.5l26.2-68.2-12.4-12.4-28.8 74.8c-2.4 6.3-8.5 10.4-15.3 10.3s-12.7-4.5-14.8-10.9L245.9 308.2c-1.6-4.8-5.3-8.5-10.1-10.1L58.9 239.2c-6.4-2.1-10.8-8.1-10.9-14.8s3.9-12.9 10.3-15.3z"]],
    "circle-m": [512, 512, [], "e115", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zm144-88c0-3.5 2.2-6.5 5.5-7.6s6.9 .1 8.9 2.9L256 274.5 337.5 163.3c2-2.8 5.7-3.9 8.9-2.9s5.5 4.1 5.5 7.6l0 176c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-151.6-73.5 100.3c-1.5 2.1-3.9 3.3-6.5 3.3s-4.9-1.2-6.5-3.3L176 192.4 176 344c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-176z", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM174.5 163.3c-2-2.8-5.7-3.9-8.9-2.9s-5.5 4.1-5.5 7.6l0 176c0 4.4 3.6 8 8 8s8-3.6 8-8l0-151.6 73.5 100.3c1.5 2.1 3.9 3.3 6.5 3.3s4.9-1.2 6.5-3.3L336 192.4 336 344c0 4.4 3.6 8 8 8s8-3.6 8-8l0-176c0-3.5-2.2-6.5-5.5-7.6s-6.9 .1-8.9 2.9L256 274.5 174.5 163.3z"]],
    "arrow-up-to-dotted-line": [384, 512, [], "e0a1", ["", "M16 0a16 16 0 1 0 0 32 16 16 0 1 0 0-32zM349.7 282.3l-152-152c-3.1-3.1-8.2-3.1-11.3 0l-152 152c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L184 155.3 184 504c0 4.4 3.6 8 8 8s8-3.6 8-8l0-348.7 138.3 138.3c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3zM88 16a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zM192 0a16 16 0 1 0 0 32 16 16 0 1 0 0-32zm72 16a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zM368 0a16 16 0 1 0 0 32 16 16 0 1 0 0-32z"]],
    "file-circle-plus": [576, 512, [58606], "e494", ["M48 64c0-26.5 21.5-48 48-48l133.5 0c3.6 0 7.1 .4 10.5 1.2L240 120c0 30.9 25.1 56 56 56l102.8 0c.8 3.4 1.2 6.9 1.2 10.5l0 24.1c-90.8 15.2-160 94.2-160 189.3 0 35 9.3 67.8 25.7 96L96 496c-26.5 0-48-21.5-48-48L48 64z", "M96 16l133.5 0c3.6 0 7.1 .4 10.5 1.2L240 120c0 30.9 25.1 56 56 56l102.8 0c.8 3.4 1.2 6.9 1.2 10.5l0 24.1c5.3-.9 10.6-1.6 16-2l0-22.1c0-17-6.7-33.3-18.7-45.3L274.7 18.7C262.7 6.7 246.5 0 229.5 0L96 0C60.7 0 32 28.7 32 64l0 384c0 35.3 28.7 64 64 64l180 0c-3.7-5.1-7.2-10.5-10.3-16L96 496c-26.5 0-48-21.5-48-48L48 64c0-26.5 21.5-48 48-48zM392 160l-96 0c-22.1 0-40-17.9-40-40l0-96c2.7 1.8 5.1 3.8 7.4 6.1L385.9 152.6c2.3 2.3 4.3 4.8 6.1 7.4zM304 400a128 128 0 1 1 256 0 128 128 0 1 1 -256 0zm272 0a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zM440 336c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 56-56 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l56 0 0 56c0 4.4 3.6 8 8 8s8-3.6 8-8l0-56 56 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-56 0 0-56z"]],
    "mustache": [640, 512, [], "e5bc", ["M16.2 169L16 203.7c0 95.1 77.1 172.3 172.3 172.3 41.7 0 82-15.1 113.4-42.6l13-11.4c3-2.6 7.5-2.6 10.5 0l13 11.4C369.7 360.9 410 376 451.7 376 546.9 376 624 298.9 624 203.7l-.2-34.7c-45.3 37.1-112.2 31.8-151.8-11.1-17.4-18.9-42.2-29.9-67.8-29.9-21.5 0-42.4 7.5-58.9 21.3l-20.2 16.8c-3 2.5-7.3 2.5-10.2 0l-20.2-16.8c-16.5-13.8-37.4-21.3-58.9-21.3-25.7 0-50.4 11-67.8 29.9-39.6 42.9-106.5 48.2-151.8 11.1z", "M235.8 112c-30.2 0-59.2 12.9-79.6 35-34 36.8-91.2 41.3-129.9 9.6L13.1 145.8c-3.4-2.8-8.5-2.3-11.3 1.1-1.2 1.5-1.8 3.3-1.8 5.1l0 51.7c0 104 84.3 188.3 188.3 188.3 45.6 0 89.7-16.6 124-46.6l7.8-6.8 7.8 6.8c34.3 30 78.4 46.6 124 46.6 104 0 188.3-84.3 188.3-188.3l0-51.7c0-1.8-.6-3.6-1.8-5.1-2.8-3.4-7.8-3.9-11.3-1.1l-13.2 10.8c-38.7 31.6-95.9 27.2-129.9-9.6-20.4-22.1-49.4-35-79.6-35-25.3 0-49.7 8.9-69.1 25L320 149.6 304.9 137c-19.4-16.2-43.9-25-69.2-25zm388.1 57l.2 34.7c0 95.1-77.1 172.3-172.3 172.3-41.7 0-82-15.1-113.4-42.6l-13-11.4c-3-2.6-7.5-2.6-10.5 0l-13 11.4C270.3 360.9 230 376 188.3 376 93.1 376 16 298.9 16 203.7l.2-34.7c45.3 37.1 112.2 31.8 151.8-11.1 17.4-18.9 42.2-29.9 67.8-29.9 21.5 0 42.4 7.5 58.9 21.3l20.2 16.8c3 2.5 7.3 2.5 10.2 0l20.2-16.8c16.5-13.8 37.4-21.3 58.9-21.3 25.7 0 50.4 11 67.8 29.9 39.6 42.9 106.5 48.2 151.8 11.1z"]],
    "window-frame": [448, 512, [129695], "e04f", ["M48 64l0 184 168 0 0-232-120 0C69.5 16 48 37.5 48 64zm0 200l0 232 168 0 0-232-168 0zM232 16l0 232 168 0 0-184c0-26.5-21.5-48-48-48L232 16zm0 248l0 232 168 0 0-232-168 0z", "M416 256l0 240 24 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L8 512c-4.4 0-8-3.6-8-8s3.6-8 8-8l24 0 0-432C32 28.7 60.7 0 96 0L352 0c35.3 0 64 28.7 64 64l0 192zm-16 8l-168 0 0 232 168 0 0-232zm0-16l0-184c0-26.5-21.5-48-48-48l-120 0 0 232 168 0zm-184 0l0-232-120 0C69.5 16 48 37.5 48 64l0 184 168 0zM48 264l0 232 168 0 0-232-168 0z"]],
    "house-night": [640, 512, [], "e010", ["M16 80c0 53 43 96 96 96 28.4 0 54-12.3 71.6-32-48.4-.2-87.6-39.5-87.6-88 0-28.7 13.7-54.1 34.9-70.2-6.1-1.2-12.4-1.8-18.9-1.8-53 0-96 43-96 96zM192 260.8L192 488c0 22.1 17.9 40 40 40l272 0c22.1 0 40-17.9 40-40l0-227.2-176-169.7-176 169.7zM312 312c0-17.7 14.3-32 32-32l48 0c17.7 0 32 14.3 32 32l0 48c0 17.7-14.3 32-32 32l-48 0c-17.7 0-32-14.3-32-32l0-48z", "M272-40c-4.4 0-8 3.6-8 8l0 40-40 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l40 0 0 40c0 4.4 3.6 8 8 8s8-3.6 8-8l0-40 40 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-40 0 0-40c0-4.4-3.6-8-8-8zM96 56c0 48.5 39.2 87.8 87.6 88-17.6 19.7-43.1 32-71.6 32-53 0-96-43-96-96s43-96 96-96c6.5 0 12.8 .6 18.9 1.8-21.2 16.1-34.9 41.5-34.9 70.2zm56.9-80.3C140.3-29.3 126.4-32 112-32 50.1-32 0 18.1 0 80S50.1 192 112 192c40.3 0 75.6-21.2 95.3-53.1 3.9-6.2-3.2-13.3-10.4-12-4.2 .8-8.5 1.1-12.9 1.1-39.8 0-72-32.2-72-72 0-28.2 16.2-52.6 39.8-64.4 6.6-3.3 8-13.2 1.1-15.9zM373.6 74.2c-3.1-3-8-3-11.1 0l-224 216c-3.2 3.1-3.3 8.1-.2 11.3s8.1 3.3 11.3 .2L176 276.3 176 488c0 30.9 25.1 56 56 56l272 0c30.9 0 56-25.1 56-56l0-211.7 26.4 25.5c3.2 3.1 8.2 3 11.3-.2s3-8.2-.2-11.3l-224-216zM544 260.8L544 488c0 22.1-17.9 40-40 40l-272 0c-22.1 0-40-17.9-40-40l0-227.2 176-169.7 176 169.7zM312 312l0 48c0 17.7 14.3 32 32 32l48 0c17.7 0 32-14.3 32-32l0-48c0-17.7-14.3-32-32-32l-48 0c-17.7 0-32 14.3-32 32zm32-16l48 0c8.8 0 16 7.2 16 16l0 48c0 8.8-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16l0-48c0-8.8 7.2-16 16-16zM560 24c-4.4 0-8 3.6-8 8l0 40-40 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l40 0 0 40c0 4.4 3.6 8 8 8s8-3.6 8-8l0-40 40 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-40 0 0-40c0-4.4-3.6-8-8-8z"]],
    "reel": [448, 512, [], "e238", ["M64 96l0 64c0 4.4 3.6 8 8 8l304 0c4.4 0 8-3.6 8-8l0-64-16 0 0-32-288 0 0 32-16 0zm0 64l0 64c0-4.4 3.6-8 8-8l312 0 0-56c0-4.4-3.6-8-8-8L72 152c-4.4 0-8 3.6-8 8zm0 64l0 64c0 4.4 3.6 8 8 8l304 0c4.4 0 8-3.6 8-8l0-56-312 0c-4.4 0-8-3.6-8-8zm0 64l0 64c0-4.4 3.6-8 8-8l304 0c4.4 0 8 3.6 8 8l0-64c0-4.4-3.6-8-8-8L72 280c-4.4 0-8 3.6-8 8zm0 64l0 64 16 0 0 32 288 0 0-32 16 0 0-64c0 4.4-3.6 8-8 8L72 360c-4.4 0-8-3.6-8-8z", "M64 16c-8.8 0-16 7.2-16 16s7.2 16 16 16l320 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L64 16zM32 32C32 14.3 46.3 0 64 0L384 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l0 32-16 0 0-32-288 0 0 32-16 0 0-32C46.3 64 32 49.7 32 32zM64 464c-8.8 0-16 7.2-16 16s7.2 16 16 16l320 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L64 464zM32 480c0-17.7 14.3-32 32-32l0-32 16 0 0 32 288 0 0-32 16 0 0 32c17.7 0 32 14.3 32 32s-14.3 32-32 32L64 512c-17.7 0-32-14.3-32-32zM64 160c0-4.4 3.6-8 8-8l304 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L72 168c-4.4 0-8-3.6-8-8zm8 56l368 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L72 232c-4.4 0-8-3.6-8-8s3.6-8 8-8zm-8 72c0-4.4 3.6-8 8-8l304 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L72 296c-4.4 0-8-3.6-8-8zm8 56l304 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L72 360c-4.4 0-8-3.6-8-8s3.6-8 8-8z"]],
    "icicles": [512, 512, [], "f7ad", ["M16 28.8c0 1.3 .2 2.6 .6 3.8L96.2 286 136.4 165.5c1.1-3.4 4.4-5.6 8-5.5s6.6 2.7 7.4 6.2L192 340.4 232.2 166.2c.8-3.5 3.8-6 7.4-6.2s6.8 2.1 8 5.5l39.9 119.7 48.8-167.4c1-3.6 4.4-5.9 8.1-5.8s6.8 2.9 7.5 6.5L416 460.5 495.8 32.5c.2-.8 .2-1.7 .2-2.6 0-7.7-6.3-14-14-14L28.8 16C21.7 16 16 21.7 16 28.8z", "M0 28.8C0 12.9 12.9 0 28.8 0L482 0c16.6 0 30 13.4 30 30 0 1.8-.2 3.7-.5 5.5l-87.6 470c-.7 3.8-4 6.5-7.9 6.5s-7.2-2.7-7.9-6.5l-65.8-351.1-46.6 159.9c-1 3.4-4 5.7-7.5 5.8s-6.6-2.2-7.7-5.5l-39-117-41.6 180.3c-.8 3.6-4.1 6.2-7.8 6.2s-7-2.6-7.8-6.2l-41.6-180.3-39 117c-1.1 3.3-4.2 5.5-7.7 5.5s-6.5-2.3-7.6-5.6l-87-277C.4 34.6 0 31.7 0 28.8zM28.8 16c-7.1 0-12.8 5.7-12.8 12.8 0 1.3 .2 2.6 .6 3.8L96.2 286 136.4 165.5c1.1-3.4 4.4-5.6 8-5.5s6.6 2.7 7.4 6.2L192 340.4 232.2 166.2c.8-3.5 3.8-6 7.4-6.2s6.8 2.1 8 5.5l39.9 119.7 48.8-167.4c1-3.6 4.4-5.9 8.1-5.8s6.8 2.9 7.5 6.5L416 460.5 495.8 32.5c.2-.8 .2-1.7 .2-2.6 0-7.7-6.3-14-14-14L28.8 16z"]],
    "binary-slash": [576, 512, [], "e33e", ["", "M13.7-29.8c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l560 560c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3L480 436.6 480 352c0-35.3-28.7-64-64-64l-48 0c-10.6 0-20.6 2.6-29.4 7.2l-87.7-87.7c13-11.7 21.1-28.7 21.1-47.5l0-96c0-35.3-28.7-64-64-64L160 0c-31.8 0-58.1 23.1-63.1 53.5L13.7-29.8zM112 68.6l0-4.6c0-26.5 21.5-48 48-48l48 0c26.5 0 48 21.5 48 48l0 96c0 14.4-6.4 27.4-16.4 36.2L112 68.6zM350.6 307.2c5.4-2.1 11.2-3.2 17.4-3.2l48 0c26.5 0 48 21.5 48 48l0 68.6-113.4-113.4zm-30.6 60l-16-16 0 .8 0 96c0 35.3 28.7 64 64 64l48 0c13.8 0 26.6-4.4 37-11.8l-11.5-11.5c-7.4 4.6-16.1 7.3-25.5 7.3l-48 0c-26.5 0-48-21.5-48-48l0-80.8zM412.8 1.6c-2-1.5-4.7-2-7.1-1.2l-80 24c-4.2 1.3-6.6 5.7-5.4 10s5.7 6.6 10 5.4l69.7-20.9 0 189.2-72 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l144 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-56 0 0-200c0-2.5-1.2-4.9-3.2-6.4zm-224 288c-2-1.5-4.7-2-7.1-1.2l-80 24c-4.2 1.3-6.6 5.7-5.4 10s5.7 6.6 10 5.4l69.7-20.9 0 189.2-72 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l144 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-56 0 0-200c0-2.5-1.2-4.9-3.2-6.4z"]],
    "square-sliders-vertical": [448, 512, ["sliders-v-square"], "f3f2", ["M16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96zm56 96c0-17.7 14.3-32 32-32l24 0 0-56c0-4.4 3.6-8 8-8s8 3.6 8 8l0 56 24 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-24 0 0 184c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-184-24 0c-17.7 0-32-14.3-32-32zM248 320c0-17.7 14.3-32 32-32l24 0 0-184c0-4.4 3.6-8 8-8s8 3.6 8 8l0 184 24 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-24 0 0 56c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-56-24 0c-17.7 0-32-14.3-32-32z", "M384 48c26.5 0 48 21.5 48 48l0 320c0 26.5-21.5 48-48 48L64 464c-26.5 0-48-21.5-48-48L16 96c0-26.5 21.5-48 48-48l320 0zM64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm72 64c-4.4 0-8 3.6-8 8l0 56-24 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l24 0 0 184c0 4.4 3.6 8 8 8s8-3.6 8-8l0-184 24 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-24 0 0-56c0-4.4-3.6-8-8-8zm0 112l-32 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l64 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-32 0zM320 104c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 184-24 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l24 0 0 56c0 4.4 3.6 8 8 8s8-3.6 8-8l0-56 24 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-24 0 0-184zm24 232l-64 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l64 0c8.8 0 16 7.2 16 16s-7.2 16-16 16z"]],
    "arrow-trend-up": [576, 512, [], "e098", ["M0 408c0 2.1 .8 4.1 2.3 5.7 3.1 3.1 8.2 3.1 11.3 0L192 235.3 314.3 357.7c3.1 3.1 8.2 3.1 11.3 0L560 123.3 560 296c0 4.4 3.6 8 8 8s8-3.6 8-8l0 152c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64l0-40z", "M368 104c0-4.4 3.6-8 8-8l192 0c4.4 0 8 3.6 8 8l0 192c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-172.7-234.3 234.3c-3.1 3.1-8.2 3.1-11.3 0L192 235.3 13.7 413.7c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l184-184c3.1-3.1 8.2-3.1 11.3 0L320 340.7 548.7 112 376 112c-4.4 0-8-3.6-8-8z"]],
    "timeline-arrow": [576, 512, [], "e29d", ["M40 88A56 56 0 1 0 152 88 56 56 0 1 0 40 88zM168.1 420.1c2.1 29 26.3 51.9 55.9 51.9s53.8-22.9 55.9-51.9C277.8 390.9 253.6 368 224 368s-53.8 22.9-55.9 52.1zM296 88a56 56 0 1 0 112 0 56 56 0 1 0 -112 0z", "M152 88A56 56 0 1 0 40 88 56 56 0 1 0 152 88zm16 0c0 37.1-28 67.6-64 71.6l0 96.4 240 0 0-96.4c-36-4-64-34.5-64-71.6 0-39.8 32.2-72 72-72s72 32.2 72 72c0 37.1-28 67.6-64 71.6l0 96.4 188.7 0-58.3-58.3c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0l72 72c3.1 3.1 3.1 8.2 0 11.3l-72 72c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l58.3-58.3-316.7 0 0 80-16 0 0-80-208 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l80 0 0-96.4c-36-4-64-34.5-64-71.6 0-39.8 32.2-72 72-72s72 32.2 72 72zm56 408a72 72 0 1 1 0-144 72 72 0 1 1 0 144zM352 144a56 56 0 1 0 0-112 56 56 0 1 0 0 112zM280 424a56 56 0 1 0 -112 0 56 56 0 1 0 112 0z"]],
    "fort": [576, 512, [], "e486", ["M16 112l0 104c0 13.3 10.7 24 24 24l176 0c13.3 0 24-10.7 24-24l0-104-224 0zM64 256l0 192c0 26.5 21.5 48 48 48l96 0 0-80c0-44.2 35.8-80 80-80s80 35.8 80 80l0 80 96 0c26.5 0 48-21.5 48-48l0-192-152 0c-22.1 0-40-17.9-40-40l0-32-64 0 0 32c0 22.1-17.9 40-40 40L64 256zM336 112l0 104c0 13.3 10.7 24 24 24l176 0c13.3 0 24-10.7 24-24l0-104-224 0z", "M8 32c4.4 0 8 3.6 8 8l0 56 104 0 0-56c0-4.4 3.6-8 8-8s8 3.6 8 8l0 56 104 0 0-56c0-4.4 3.6-8 8-8s8 3.6 8 8l0 128 64 0 0-128c0-4.4 3.6-8 8-8s8 3.6 8 8l0 56 104 0 0-56c0-4.4 3.6-8 8-8s8 3.6 8 8l0 56 104 0 0-56c0-4.4 3.6-8 8-8s8 3.6 8 8l0 176c0 22.1-17.9 40-40 40l-8 0 0 192c0 35.3-28.7 64-64 64l-352 0c-35.3 0-64-28.7-64-64l0-192-8 0c-22.1 0-40-17.9-40-40L0 40c0-4.4 3.6-8 8-8zM224 496l128 0 0-80c0-35.3-28.7-64-64-64s-64 28.7-64 64l0 80zm144 0l96 0c26.5 0 48-21.5 48-48l0-192-152 0c-22.1 0-40-17.9-40-40l0-32-64 0 0 32c0 22.1-17.9 40-40 40l-152 0 0 192c0 26.5 21.5 48 48 48l96 0 0-80c0-44.2 35.8-80 80-80s80 35.8 80 80l0 80zM240 168l0-56-224 0 0 104c0 13.3 10.7 24 24 24l176 0c13.3 0 24-10.7 24-24l0-48zm96 48c0 13.3 10.7 24 24 24l176 0c13.3 0 24-10.7 24-24l0-104-224 0 0 104z"]],
    "circle-v": [512, 512, [], "e12a", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zm144.8-84.4c-2-4-.4-8.8 3.6-10.7s8.8-.4 10.7 3.6L256 326.1 336.8 164.4c2-4 6.8-5.6 10.7-3.6s5.6 6.8 3.6 10.7l-88 176c-1.4 2.7-4.1 4.4-7.2 4.4s-5.8-1.7-7.2-4.4l-88-176z", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM175.2 164.4c-2-4-6.8-5.6-10.7-3.6s-5.6 6.8-3.6 10.7l88 176c1.4 2.7 4.1 4.4 7.2 4.4s5.8-1.7 7.2-4.4l88-176c2-4 .4-8.8-3.6-10.7s-8.8-.4-10.7 3.6L256 326.1 175.2 164.4z"]],
    "hexagon-nodes-bolt": [576, 512, [], "e69a", ["M90.6 180A40 40 0 1 1 21.4 140a40 40 0 1 1 69.3 40zm0 152A40 40 0 1 1 21.4 372a40 40 0 1 1 69.3-40zM264 56a40 40 0 1 1 -80 0 40 40 0 1 1 80 0zm0 200a40 40 0 1 1 -80 0 40 40 0 1 1 80 0zm0 200a40 40 0 1 1 -80 0 40 40 0 1 1 80 0zm93.4-276c-11-19.1-4.5-43.6 14.6-54.6s43.6-4.5 54.6 14.6c10.5 18.1 5.1 41.1-11.8 52.8c4.2-.4 8.5-.7 12.8-.8c-8.8 9.8-21.5 15.9-35.7 15.9c-7.7 0-14.9-1.8-21.4-5c4-1.5 8.1-2.8 12.2-4c-10.4-2.4-19.7-9-25.5-18.9z", "M184 56a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zm48 55.4c27.1-3.9 48-27.2 48-55.4c0-30.9-25.1-56-56-56s-56 25.1-56 56c0 28.2 20.9 51.6 48 55.4l0 89.1c-14.6 2.1-27.5 9.9-36.2 21l-71.7-41c10.1-25.4 .3-55-24.1-69.1C57.2 96 23 105.2 7.5 132S1.2 193 28 208.5c6.4 3.7 13.1 6 20 6.9l0 81.1c-6.9 1-13.6 3.3-20 6.9C1.2 319-8 353.2 7.5 380S57.2 416 84 400.5c24.4-14.1 34.2-43.7 24.1-69.1l43.8-25c-3.1-4.4-5.7-9-8-13.9l-43.8 25c-9.1-11.7-22.2-18.9-36.2-21l0-81.1c14-2 27.1-9.3 36.2-21l71.7 41c-2.5 6.4-3.9 13.3-3.9 20.6c0 28.2 20.9 51.6 48 55.4l0 89.1c-27.1 3.9-48 27.2-48 55.4c0 30.9 25.1 56 56 56c30.7 0 55.6-24.7 56-55.2c-7.5-12.9-13.5-26.8-17.6-41.5c-8.2-7.7-18.7-13-30.4-14.7l0-89.1c14.6-2.1 27.5-9.9 36.2-21l4.6 2.6c2.3-4.8 4.8-9.6 7.5-14.2l-4.1-2.3c2.5-6.4 3.9-13.3 3.9-20.6c0-28.2-20.9-51.6-48-55.4l0-89.1zM440.5 132C425 105.2 390.8 96 364 111.5c-24.4 14.1-34.2 43.7-24.1 69l-43.8 25c3.1 4.4 5.7 9 8 13.9l43.8-25c3.8 4.9 8.4 9.1 13.4 12.4c7-3.1 14.2-5.7 21.6-7.9c-10.4-2.4-19.7-9-25.5-18.9c-11-19.1-4.5-43.6 14.6-54.6s43.6-4.5 54.6 14.6c10.5 18.1 5.1 41.1-11.8 52.8c5.6-.5 11.3-.8 17.1-.8c2 0 4 0 5.9 .1c12.1-17.3 13.8-40.6 2.6-60.1zM21.4 140a40 40 0 1 1 69.3 40A40 40 0 1 1 21.4 140zM184 456a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zM90.6 332A40 40 0 1 1 21.4 372a40 40 0 1 1 69.3-40zM224 216a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm208 24a128 128 0 1 1 0 256 128 128 0 1 1 0-256zm0 272a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm36.5-230.6c-3-2-6.9-1.8-9.7 .6l-112 96c-2.5 2.2-3.5 5.7-2.3 8.8s4.2 5.2 7.5 5.2l58.2 0-17.8 53.5c-1.1 3.4 .1 7.2 3.1 9.2s6.9 1.8 9.7-.6l112-96c2.5-2.2 3.5-5.7 2.3-8.8s-4.2-5.2-7.5-5.2l-58.2 0 17.8-53.5c1.1-3.4-.1-7.2-3.1-9.2zM373.6 376l73.7-63.1-12.2 36.6c-.8 2.4-.4 5.1 1.1 7.2s3.9 3.3 6.5 3.3l47.7 0-73.7 63.1 12.2-36.6c.8-2.4 .4-5.1-1.1-7.2s-3.9-3.3-6.5-3.3l-47.7 0z"]],
    "light-emergency-on": [640, 512, [], "e420", ["M112 368l0 64c0 17.7 14.3 32 32 32l352 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-352 0c-17.7 0-32 14.3-32 32zm64-176l0 128 288 0 0-128c0-79.5-64.5-144-144-144S176 112.5 176 192zm48 8c0-57.4 46.6-104 104-104 4.4 0 8 3.6 8 8s-3.6 8-8 8c-48.6 0-88 39.4-88 88 0 4.4-3.6 8-8 8s-8-3.6-8-8z", "M44.1 33.1l80 48c3.8 2.3 5 7.2 2.7 11s-7.2 5-11 2.7l-80-48c-3.8-2.3-5-7.2-2.7-11s7.2-5 11-2.7zm560 13.7l-80 48c-3.8 2.3-8.7 1-11-2.7s-1-8.7 2.7-11l80-48c3.8-2.3 8.7-1 11 2.7s1 8.7-2.7 11zM8 192l80 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L8 208c-4.4 0-8-3.6-8-8s3.6-8 8-8zm544 0l80 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-80 0c-4.4 0-8-3.6-8-8s3.6-8 8-8zM480 320l16 0c26.5 0 48 21.5 48 48l0 64c0 26.5-21.5 48-48 48l-352 0c-26.5 0-48-21.5-48-48l0-64c0-26.5 21.5-48 48-48l16 0 0-128c0-88.4 71.6-160 160-160s160 71.6 160 160l0 128zm-16 0l0-128c0-79.5-64.5-144-144-144S176 112.5 176 192l0 128 288 0zM112 368l0 64c0 17.7 14.3 32 32 32l352 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-352 0c-17.7 0-32 14.3-32 32zM328 112c-48.6 0-88 39.4-88 88 0 4.4-3.6 8-8 8s-8-3.6-8-8c0-57.4 46.6-104 104-104 4.4 0 8 3.6 8 8s-3.6 8-8 8z"]],
    "question": [320, 512, [10067, 10068, 61736], "3f", ["", "M16 160C16 80.5 80.5 16 160 16S304 80.5 304 160c0 58.5-34.9 108.9-85.1 131.5-33.2 14.9-66.9 44.4-66.9 84.5l0 24c0 4.4 3.6 8 8 8s8-3.6 8-8l0-24c0-30.5 26.2-55.9 57.4-69.9 55.7-25 94.6-81 94.6-146.1 0-88.4-71.6-160-160-160S0 71.6 0 160c0 4.4 3.6 8 8 8s8-3.6 8-8zM160 512c8.8 0 16-7.2 16-16s-7.2-16-16-16-16 7.2-16 16 7.2 16 16 16z"]],
    "square-lira": [448, 512, [], "e6e7", ["M16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96zM121.3 371.7l34.1-53.6c2.9-4.5 5.2-9.2 7-14.1L136 304c-4.4 0-8-3.6-8-8s3.6-8 8-8l30.3 0c1.4-10.6 .5-21.6-2.7-32L136 256c-4.4 0-8-3.6-8-8s3.6-8 8-8l21.8 0-5.6-15.1c-17.3-47 17.5-96.9 67.6-96.9l3.1 0c23.3 0 45.7 9.3 62.2 25.8l8.6 8.6c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-8.6-8.6C260.3 151.6 242 144 222.9 144l-3.1 0c-39 0-66 38.8-52.5 75.4l7.6 20.6 105.2 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-99.8 0c2.7 10.5 3.4 21.4 2.2 32l97.5 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-100.8 0c-2.4 7.9-5.8 15.6-10.4 22.7L142.6 368 312 368c4.4 0 8 3.6 8 8s-3.6 8-8 8l-184 0c-2.9 0-5.6-1.6-7-4.2s-1.3-5.7 .3-8.1z", "M64 48C37.5 48 16 69.5 16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm219.8 32l3.1 0c23.3 0 45.7 9.3 62.2 25.8l8.6 8.6c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-8.6-8.6C260.3 151.6 242 144 222.9 144l-3.1 0c-39 0-66 38.8-52.5 75.4l7.6 20.6 105.2 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-99.8 0c2.7 10.5 3.4 21.4 2.2 32l97.5 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-100.8 0c-2.4 7.9-5.8 15.6-10.4 22.7L142.6 368 312 368c4.4 0 8 3.6 8 8s-3.6 8-8 8l-184 0c-2.9 0-5.6-1.6-7-4.2s-1.3-5.7 .3-8.1l34.1-53.6c2.9-4.5 5.2-9.2 7-14.1L136 304c-4.4 0-8-3.6-8-8s3.6-8 8-8l30.3 0c1.4-10.6 .5-21.6-2.7-32L136 256c-4.4 0-8-3.6-8-8s3.6-8 8-8l21.8 0-5.6-15.1c-17.3-47 17.5-96.9 67.6-96.9z"]],
    "square-dashed-circle-plus": [576, 512, [], "e5c2", ["", "M120 32l16 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-16 0c-39.8 0-72 32.2-72 72l0 16c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-16c0-48.6 39.4-88 88-88zM40 192c4.4 0 8 3.6 8 8l0 112c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-112c0-4.4 3.6-8 8-8zm8 184l0 16c0 39.8 32.2 72 72 72l130.9 0c1.9 5.4 4.1 10.8 6.5 16L120 480c-48.6 0-88-39.4-88-88l0-16c0-4.4 3.6-8 8-8s8 3.6 8 8zM480 120l0 94c-5.3-1.4-10.6-2.5-16-3.4l0-90.7c0-39.8-32.2-72-72-72l-16 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l16 0c48.6 0 88 39.4 88 88zM320 40c0 4.4-3.6 8-8 8L200 48c-4.4 0-8-3.6-8-8s3.6-8 8-8l112 0c4.4 0 8 3.6 8 8zM560 400a128 128 0 1 0 -256 0 128 128 0 1 0 256 0zm-272 0a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm152-64l0 56 56 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-56 0 0 56c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-56-56 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l56 0 0-56c0-4.4 3.6-8 8-8s8 3.6 8 8z"]],
    "chair-office": [384, 512, [], "f6c1", ["M16 304l0 48c0 17.7 14.3 32 32 32l288 0c17.7 0 32-14.3 32-32l0-48c0-17.7-14.3-32-32-32L48 272c-17.7 0-32 14.3-32 32zM80 64l0 192 224 0 0-192c0-26.5-21.5-48-48-48L128 16c-26.5 0-48 21.5-48 48z", "M128 16c-26.5 0-48 21.5-48 48l0 192 224 0 0-192c0-26.5-21.5-48-48-48L128 16zM320 64l0 192 16 0c26.5 0 48 21.5 48 48l0 48c0 26.5-21.5 48-48 48l-136 0 0 96 80 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-176 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l80 0 0-96-136 0c-26.5 0-48-21.5-48-48l0-48c0-26.5 21.5-48 48-48l16 0 0-192C64 28.7 92.7 0 128 0L256 0c35.3 0 64 28.7 64 64zM48 272c-17.7 0-32 14.3-32 32l0 48c0 17.7 14.3 32 32 32l288 0c17.7 0 32-14.3 32-32l0-48c0-17.7-14.3-32-32-32L48 272zM16 136l0 80c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-80c0-4.4 3.6-8 8-8s8 3.6 8 8zm368 0l0 80c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-80c0-4.4 3.6-8 8-8s8 3.6 8 8z"]],
    "user-magnifying-glass": [576, 512, [], "e5c5", ["M8 512c4.4 0 8-3.6 8-8l0-24c0-88.4 71.6-160 160-160l65.7 0c-1.1 7.9-1.7 15.9-1.7 24.1 0 90.9 72.2 164.9 162.3 167.9L8 512zM336 128a112 112 0 1 1 -224 0 112 112 0 1 1 224 0z", "M224 16a112 112 0 1 1 0 224 112 112 0 1 1 0-224zM334.2 193.1C345.5 174 352 151.8 352 128 352 57.3 294.7 0 224 0S96 57.3 96 128 153.3 256 224 256c16.5 0 32.3-3.1 46.7-8.8 16.2-22.9 38-41.6 63.5-54.1zM244.8 304L176 304C78.8 304 0 382.8 0 480l0 24c0 4.4 3.6 8 8 8s8-3.6 8-8l0-24c0-88.4 71.6-160 160-160l65.7 0c.8-5.4 1.8-10.8 3.1-16zM408 240.1a104 104 0 1 1 0 208 104 104 0 1 1 0-208zm0 224c30.3 0 57.9-11.2 79.1-29.7l75.3 75.4c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-75.3-75.4c18.5-21.1 29.6-48.7 29.6-79 0-66.3-53.7-120-120-120s-120 53.7-120 120 53.7 120 120 120z"]],
    "container-storage": [576, 512, [], "f4b7", ["M48 48l480 0 0 416-480 0 0-416zm88 88l0 240c0 4.4 3.6 8 8 8s8-3.6 8-8l0-240c0-4.4-3.6-8-8-8s-8 3.6-8 8zm96 0l0 240c0 4.4 3.6 8 8 8s8-3.6 8-8l0-240c0-4.4-3.6-8-8-8s-8 3.6-8 8zm96 0l0 240c0 4.4 3.6 8 8 8s8-3.6 8-8l0-240c0-4.4-3.6-8-8-8s-8 3.6-8 8zm96 0l0 240c0 4.4 3.6 8 8 8s8-3.6 8-8l0-240c0-4.4-3.6-8-8-8s-8 3.6-8 8z", "M0 40c0-4.4 3.6-8 8-8l560 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-24 0 0 416 24 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L8 480c-4.4 0-8-3.6-8-8s3.6-8 8-8l24 0 0-416-24 0c-4.4 0-8-3.6-8-8zm48 8l0 416 480 0 0-416-480 0zm88 88c0-4.4 3.6-8 8-8s8 3.6 8 8l0 240c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-240zm200-8c4.4 0 8 3.6 8 8l0 240c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-240c0-4.4 3.6-8 8-8zm88 8c0-4.4 3.6-8 8-8s8 3.6 8 8l0 240c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-240zm-184-8c4.4 0 8 3.6 8 8l0 240c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-240c0-4.4 3.6-8 8-8z"]],
    "arrow-left-to-bracket": [512, 512, [], "e669", ["", "M314.3 98.3l-152 152c-3.1 3.1-3.1 8.2 0 11.3l152 152c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3L187.3 264 504 264c4.4 0 8-3.6 8-8s-3.6-8-8-8l-316.7 0 138.3-138.3c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0zM184 464l-88 0c-44.2 0-80-35.8-80-80l0-256c0-44.2 35.8-80 80-80l88 0c4.4 0 8-3.6 8-8s-3.6-8-8-8L96 32C43 32 0 75 0 128L0 384c0 53 43 96 96 96l88 0c4.4 0 8-3.6 8-8s-3.6-8-8-8z"]],
    "sparkle": [512, 512, [], "e5d6", ["M16 256c0 3.3 2.1 6.3 5.2 7.5l158.6 59.4c4.3 1.6 7.8 5 9.4 9.4l59.4 158.6c1.2 3.1 4.2 5.2 7.5 5.2s6.3-2.1 7.5-5.2l59.4-158.6c1.6-4.3 5-7.8 9.4-9.4l158.6-59.4c3.1-1.2 5.2-4.2 5.2-7.5s-2.1-6.3-5.2-7.5L332.2 189.2c-4.3-1.6-7.8-5-9.4-9.4L263.5 21.2c-1.2-3.1-4.2-5.2-7.5-5.2s-6.3 2.1-7.5 5.2L189.2 179.8c-1.6 4.3-5 7.8-9.4 9.4L21.2 248.5c-3.1 1.2-5.2 4.2-5.2 7.5z", "M332.2 189.2l158.6 59.4c3.1 1.2 5.2 4.2 5.2 7.5s-2.1 6.3-5.2 7.5L332.2 322.8c-4.3 1.6-7.8 5-9.4 9.4L263.5 490.8c-1.2 3.1-4.2 5.2-7.5 5.2s-6.3-2.1-7.5-5.2L189.2 332.2c-1.6-4.3-5-7.8-9.4-9.4L21.2 263.5c-3.1-1.2-5.2-4.2-5.2-7.5s2.1-6.3 5.2-7.5l158.6-59.4c4.3-1.6 7.8-5 9.4-9.4L248.5 21.2c1.2-3.1 4.2-5.2 7.5-5.2s6.3 2.1 7.5 5.2l59.4 158.6c1.6 4.3 5 7.8 9.4 9.4zm5.6-15L278.5 15.6C275 6.2 266 0 256 0s-19 6.2-22.5 15.6L174.2 174.2 15.6 233.5C6.2 237 0 246 0 256s6.2 19 15.6 22.5l158.6 59.4 59.4 158.6C237 505.8 246 512 256 512s19-6.2 22.5-15.6l59.4-158.6 158.6-59.4C505.8 275 512 266 512 256s-6.2-19-15.6-22.5L337.8 174.2z"]],
    "campfire": [512, 512, [], "f6ba", ["M126.5 174c0 46 23.1 86.7 58.6 110.2-9.4-13-14.9-28.7-14.9-45.6 0-52.2 58-100.4 79.4-116.5 4.7-3.5 11-3.5 15.7 0 21.5 16.1 79.4 64.4 79.4 116.5 0 15-4.4 29.1-12 41.2 32-24 52.8-62.6 52.8-105.9 0-23.4-8.7-48.8-22.1-72.5-13.3-23.7-30.9-45.3-47.9-61.1-2-1.9-5.2-1.9-7.2 0-7.8 7.2-15.1 16.2-21.8 24.7-1.4 1.7-3.4 2.8-5.6 2.8s-4.3-1-5.7-2.7c-14.5-17.7-30.1-34.1-46.7-49.3-1-.9-2.2-1.4-3.5-1.4-1.3 0-2.6 .5-3.6 1.4-21.4 19.4-45.2 44.1-63.7 71.6-18.5 27.5-31.2 57.2-31.2 86.6z", "M225 14.5c1.3 0 2.5 .5 3.5 1.4 16.6 15.2 32.2 31.6 46.7 49.3 1.4 1.7 3.5 2.7 5.7 2.7s4.3-1 5.6-2.8c6.7-8.6 14.1-17.6 21.8-24.7 2-1.9 5.2-1.8 7.2 0 17 15.9 34.6 37.4 47.9 61.1 13.3 23.8 22.1 49.1 22.1 72.5 0 43.3-20.7 81.9-52.8 105.9 7.6-12.1 12-26.2 12-41.2 0-52.2-58-100.4-79.4-116.5-4.7-3.5-11-3.5-15.7 0-21.5 16.1-79.4 64.4-79.4 116.5 0 16.9 5.5 32.6 14.9 45.6-35.5-23.5-58.6-64.2-58.6-110.2 0-29.4 12.7-59 31.2-86.6 18.5-27.5 42.3-52.2 63.7-71.6 1-.9 2.3-1.4 3.6-1.4zM256 305.5c-1.5 0-2.9 0-4.4-.1-38.2-2.8-66.9-32.4-66.9-66.7 0-20.9 11.8-42.7 28.3-62.5 15.7-18.8 34-33.9 44.4-41.8 10.5 7.9 28.7 22.9 44.4 41.8 16.4 19.7 28.3 41.5 28.3 62.5 0 32.9-26.3 61.4-62.1 66.2-4 .4-8 .6-12.1 .6zM211.6 5.1c-21.8 19.8-46.6 45.4-66 74.2-19.3 28.7-33.7 61.2-33.7 94.7 0 80 63.2 146 144.1 146 80 0 144.1-65.9 144.1-146 0-26.8-9.9-54.6-23.9-79.6-14.1-25.1-32.6-47.8-50.7-64.6-7.6-7.1-19.4-7.1-27-.1-6.4 5.9-12.4 12.8-17.8 19.4-13.3-15.7-27.4-30.3-42.4-43.9-3.7-3.4-8.5-5.1-13.2-5.2-4.8 0-9.6 1.7-13.5 5.1zM11.1 288.6c-4.1-1.7-8.8 .2-10.5 4.3s.2 8.8 4.3 10.5L235.3 400 4.9 496.6c-4.1 1.7-6 6.4-4.3 10.5s6.4 6 10.5 4.3L256 408.7 500.9 511.4c4.1 1.7 8.8-.2 10.5-4.3s-.2-8.8-4.3-10.5L276.7 400 507.1 303.4c4.1-1.7 6-6.4 4.3-10.5s-6.4-6-10.5-4.3L256 391.3 11.1 288.6z"]],
    "hands-bound": [576, 512, [], "e4f9", ["M16 32l0 181.9c0 10.4 3.7 20.4 10.5 28.3L129.6 362.4c1.5 1.7 3.3 3.1 5.3 4l3.3 1.5 101.9 0 0-109.9c0-20.7-7.6-40.7-21.4-56.2L172 149.4c-5.8-6.5-15.6-7.2-22.3-1.6s-7.6 15.5-2.2 22.2l27.6 34.5c13.1 16.4 8.7 40.6-9.4 51.3-15.2 8.9-34.6 5-45.2-9L51.2 154.4 48 150.1 48 32c0-8.8-7.2-16-16-16S16 23.2 16 32zM144 464l0 24c0 4.4 3.6 8 8 8l80 0c4.4 0 8-3.6 8-8l0-24-96 0zM336 258.1l0 109.9 101.9 0 3.3-1.5c2-1 3.8-2.3 5.3-4L549.5 242.1c6.7-7.9 10.5-17.9 10.5-28.3L560 32c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 118.1-3.2 4.3-69.3 92.4c-10.6 14.1-30 18-45.2 9-18.1-10.7-22.6-34.9-9.4-51.3L428.5 170c5.4-6.8 4.5-16.6-2.2-22.2s-16.5-4.9-22.3 1.6l-46.7 52.5c-13.8 15.5-21.4 35.5-21.4 56.2zM336 464l0 24c0 4.4 3.6 8 8 8l80 0c4.4 0 8-3.6 8-8l0-24-96 0z", "M240 368l0-109.9c0-20.7-7.6-40.7-21.4-56.2L172 149.4c-5.8-6.5-15.6-7.2-22.3-1.6s-7.6 15.5-2.2 22.2l27.6 34.5c13.1 16.4 8.7 40.6-9.4 51.3-15.2 8.9-34.6 5-45.2-9L51.2 154.4 48 150.1 48 32c0-8.8-7.2-16-16-16S16 23.2 16 32l0 181.9c0 10.4 3.7 20.4 10.5 28.3L129.6 362.4c1.5 1.7 3.3 3.1 5.3 4l3.3 1.5 101.9 0zm16-16l0 16 64 0 0-109.9c0-24.6 9-48.4 25.4-66.8l46.7-52.5c11.5-13 31.3-14.4 44.5-3.2s15.2 30.9 4.4 44.5l-27.6 34.5c-7 8.8-4.7 21.8 5.1 27.5 8.1 4.8 18.6 2.7 24.2-4.8L512 144.8 512 32c0-17.7 14.3-32 32-32s32 14.3 32 32l0 181.9c0 14.2-5.1 27.9-14.3 38.7l-99 115.5 17.3 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L96 384c-4.4 0-8-3.6-8-8s3.6-8 8-8l17.3 0-99-115.5C5.1 241.8 0 228 0 213.9L0 32C0 14.3 14.3 0 32 0S64 14.3 64 32l0 112.8 69.3 92.4c5.7 7.6 16.1 9.6 24.2 4.8 9.7-5.7 12.1-18.7 5.1-27.5L135 180c-10.8-13.5-8.9-33.3 4.4-44.5s33-9.8 44.5 3.2l46.7 52.5C247 209.7 256 233.4 256 258.1l0 93.9zm181.9 16l3.3-1.5c2-1 3.8-2.3 5.3-4L549.5 242.1c6.7-7.9 10.5-17.9 10.5-28.3L560 32c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 118.1-3.2 4.3-69.3 92.4c-10.6 14.1-30 18-45.2 9-18.1-10.7-22.6-34.9-9.4-51.3L428.5 170c5.4-6.8 4.5-16.6-2.2-22.2s-16.5-4.9-22.3 1.6l-46.7 52.5c-13.8 15.5-21.4 35.5-21.4 56.2l0 109.9 101.9 0zM144 464l0 24c0 4.4 3.6 8 8 8l80 0c4.4 0 8-3.6 8-8l0-24 16 0 0 24c0 13.3-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24l0-24 16 0zm176 0l16 0 0 24c0 4.4 3.6 8 8 8l80 0c4.4 0 8-3.6 8-8l0-24 16 0 0 24c0 13.3-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24l0-24zM96 416l384 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L96 432c-4.4 0-8-3.6-8-8s3.6-8 8-8z"]],
    "panel-fire": [576, 512, [], "e42f", ["M48 96c0-26.5 21.5-48 48-48l320 0c26.5 0 48 21.5 48 48l0 78.6c-6.4 1.8-12.5 4.7-18.1 8.5-7.9-7.9-15.9-15.6-24.2-23.1-1.8-1.6-3.7-3.2-5.7-4.5l0-27.6c0-17.7-14.3-32-32-32L128 96c-17.7 0-32 14.3-32 32l0 96c0 17.7 14.3 32 32 32l126.1 0c-2.3 3.4-4.5 6.9-6.6 10.3-21.4 34.7-39.5 76.1-39.5 115.8 0 28.8 5.9 56.6 16.6 82-42.9 0-85.7 0-128.6 0-26.5 0-48-21.5-48-48L48 96zM96 336a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm64 0a16 16 0 1 0 32 0 16 16 0 1 0 -32 0z", "M96 48l320 0c26.5 0 48 21.5 48 48l0 78.6c5.2-1.5 10.6-2.3 16-2.4L480 96c0-35.3-28.7-64-64-64L96 32C60.7 32 32 60.7 32 96l0 320c0 35.3 28.7 64 64 64l136.1 0c-2.7-5.2-5.3-10.6-7.6-16L96 464c-26.5 0-48-21.5-48-48L48 96c0-26.5 21.5-48 48-48zm320 80c0-17.7-14.3-32-32-32L128 96c-17.7 0-32 14.3-32 32l0 96c0 17.7 14.3 32 32 32l126.1 0c3.5-5.3 7.2-10.7 11.1-16L128 240c-8.8 0-16-7.2-16-16l0-96c0-8.8 7.2-16 16-16l256 0c8.8 0 16 7.2 16 16l0 19.4c5.6 1.9 11 4.6 16 8.2l0-27.6zM128 336a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm48 16a16 16 0 1 0 0-32 16 16 0 1 0 0 32zM381.5 207.9c1.5 0 2.9 .5 4 1.5 18.5 16.7 35.8 34.8 51.9 54.3 1.5 1.9 3.8 2.9 6.2 2.9s4.7-1.1 6.2-3c7.4-9.4 15.6-19.3 24.3-27.2 2.3-2.1 5.9-2.1 8.2 0 18.9 17.4 38.4 41.2 53.2 67.2 14.8 26.1 24.5 54 24.5 79.7 0 49.7-25.1 93.8-63.4 119.8 9.7-14 15.4-30.7 15.4-48.7 0-57.4-63.8-110.5-87.4-128.2-5.2-3.9-12.1-3.9-17.3 0-23.6 17.7-87.4 70.8-87.4 128.2 0 18.2 5.8 35 15.7 49.2-38.7-26-63.7-70.3-63.7-120.3 0-32.3 14.1-64.9 34.7-95.2 20.5-30.2 47-57.4 70.8-78.7 1.1-1 2.6-1.5 4.1-1.5zm34.5 320c-2.7 0-5.5-.1-8.2-.2-41.2-3.8-71.8-36-71.8-73.2 0-23 13-47 31.1-68.7 17.3-20.7 37.4-37.2 48.9-45.9 11.5 8.7 31.6 25.2 48.9 45.9 18.1 21.7 31.1 45.7 31.1 68.7 0 37.2-30.6 69.4-71.7 73.2-2.7 .2-5.5 .2-8.3 .2zM366.7 197.5c-24.3 21.8-51.8 50-73.3 81.6-21.5 31.6-37.4 67.4-37.4 104.2 0 88.1 70.3 160.6 160 160.6 88.8 0 160-72.4 160-160.6 0-29.5-11-60.1-26.6-87.6-15.6-27.6-36.2-52.6-56.3-71.1-8.4-7.7-21.4-7.8-29.8-.1-7.1 6.5-13.8 14.1-19.9 21.5-14.8-17.3-30.6-33.4-47.2-48.4-4.2-3.8-9.4-5.6-14.6-5.7-5.3 0-10.6 1.8-14.9 5.6z"]],
    "clock-seven-thirty": [512, 512, [], "e351", ["M496 256a240 240 0 1 1 -480 0 240 240 0 1 1 480 0zM185.3 347.6c-2.5 3.7-1.5 8.6 2.2 11.1s8.6 1.5 11.1-2.2l49.3-74 0 125.6c0 4.4 3.6 8 8 8s8-3.6 8-8l0-152c0-3.5-2.3-6.6-5.7-7.7s-7 .3-9 3.2l-64 96z", "M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zm496 0a256 256 0 1 1 -512 0 256 256 0 1 1 512 0zM248 408l0-125.6-49.3 74c-2.5 3.7-7.4 4.7-11.1 2.2s-4.7-7.4-2.2-11.1l64-96c2-2.9 5.6-4.2 9-3.2s5.7 4.1 5.7 7.7l0 152c0 4.4-3.6 8-8 8s-8-3.6-8-8z"]],
    "tugrik-sign": [384, 512, [], "e2ba", ["", "M8 32c-4.4 0-8 3.6-8 8s3.6 8 8 8l176 0 0 169.8-121.9 30.5c-4.3 1.1-6.9 5.4-5.8 9.7s5.4 6.9 9.7 5.8l118.1-29.5 0 79.5-121.9 30.5c-4.3 1.1-6.9 5.4-5.8 9.7s5.4 6.9 9.7 5.8L184 330.2 184 472c0 4.4 3.6 8 8 8s8-3.6 8-8l0-145.8 121.9-30.5c4.3-1.1 6.9-5.4 5.8-9.7s-5.4-6.9-9.7-5.8l-118.1 29.5 0-79.5 121.9-30.5c4.3-1.1 6.9-5.4 5.8-9.7s-5.4-6.9-9.7-5.8L200 213.8 200 48 376 48c4.4 0 8-3.6 8-8s-3.6-8-8-8L8 32z"]],
    "audio-description-slash": [576, 512, [], "e0a8", ["M123.4 80L480 80c26.5 0 48 21.5 48 48l0 256c0 26.5-21.5 48-48 48l-4.6 0-82.1-82.1c31.4-7.8 54.7-36.1 54.7-69.9l0-48c0-39.8-32.2-72-72-72l-56 0c-4.4 0-8 3.6-8 8L312 268.6 123.4 80zM328 176l48 0c30.9 0 56 25.1 56 56l0 48c0 29.8-23.3 54.2-52.7 55.9L328 284.6 328 176z", "M13.7-29.8c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l560 560c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-83.1-83.1c30.3-5 53.5-31.4 53.5-63.1l0-256c0-35.3-28.7-64-64-64L107.4 64 13.7-29.8zM123.4 80L480 80c26.5 0 48 21.5 48 48l0 256c0 26.5-21.5 48-48 48l-4.6 0-82.1-82.1c31.4-7.8 54.7-36.1 54.7-69.9l0-48c0-39.8-32.2-72-72-72l-56 0c-4.4 0-8 3.6-8 8L312 268.6 123.4 80zM379.3 335.9l-51.3-51.3 0-108.6 48 0c30.9 0 56 25.1 56 56l0 48c0 29.8-23.3 54.2-52.7 55.9zM55.3 102.5L43.8 91C36.4 101.4 32 114.2 32 128l0 256c0 35.3 28.7 64 64 64l304.8 0-16-16-288.8 0c-26.5 0-48-21.5-48-48l0-256c0-9.4 2.7-18.1 7.3-25.5zM139.8 187c-7.4 10.5-11.8 23.2-11.8 37l0 120c0 4.4 3.6 8 8 8s8-3.6 8-8l0-72 80.8 0-16-16-64.8 0 0-32c0-9.4 2.7-18.1 7.3-25.5L139.8 187zM248 344c0 4.4 3.6 8 8 8s8-3.6 8-8l0-32.8-16-16 0 48.8z"]],
    "face-thermometer": [640, 512, [], "e39a", ["M80.3 256c0 132.5 107.5 240 240 240s240-107.5 240-240c0-1.6 0-3.1 0-4.6L439 372.5c-1.6 1.6-3.8 2.5-6.1 2.3s-4.4-1.2-5.8-3C402.2 340.3 363.6 320 320.3 320s-81.9 20.3-106.8 51.8c-2.7 3.5-7.8 4.1-11.2 1.3s-4.1-7.8-1.3-11.2c27.8-35.3 71-57.9 119.4-57.9 11.4 0 22.4 1.2 33.1 3.6L527 134c-41.8-70.6-118.7-118-206.7-118-132.5 0-240 107.5-240 240zm176-48a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm160 0a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M320.3 496c-132.5 0-240-107.5-240-240S187.7 16 320.3 16c88 0 164.9 47.4 206.7 118L353.3 307.6c-10.6-2.4-21.7-3.6-33.1-3.6-48.4 0-91.6 22.7-119.4 57.9-2.7 3.5-2.1 8.5 1.3 11.2s8.5 2.1 11.2-1.3c24.9-31.6 63.5-51.8 106.8-51.8s81.9 20.3 106.8 51.8c1.4 1.8 3.5 2.9 5.8 3s4.5-.7 6.1-2.3L560.2 251.4c0 1.5 0 3.1 0 4.6 0 132.5-107.5 240-240 240zM538.6 122.3C493.6 48.9 412.6 0 320.3 0 178.9 0 64.3 114.6 64.3 256s114.6 256 256 256 256-114.6 256-256c0-6.7-.3-13.3-.8-19.9l38.4-38.4c20.8-20.8 20.8-54.5 0-75.3-20.8-20.8-54.5-20.8-75.3 0zM240.3 224a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm176-16a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM370.9 312.6l179-179c14.5-14.5 38.1-14.5 52.7 0s14.6 38.1 0 52.7l-10.3 10.3-2.3-2.3-16-16c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l16 16 2.3 2.3-36.7 36.7-2.3-2.3-16-16c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l16 16 2.3 2.3-36.7 36.7-18.3-18.3c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l18.3 18.3-51 51c-16.9-19-38.5-33.7-63-42.4z"]],
    "lightbulb-cfl-on": [640, 512, [], "e5a7", ["M176.1 68.3c0 20 18.8 34.7 38.2 29.9 27.5-6.9 54.9-13.7 82.3-20.6 13.8-3.5 23.3-15.8 23.3-29.9 0-20-18.8-34.7-38.3-29.9L199.4 38.4c-13.7 3.4-23.3 15.8-23.3 29.9zm0 80c0 20 18.8 34.7 38.3 29.9l207.4-51.8 18.8-4.7c13.7-3.4 23.3-15.8 23.3-29.9 0-20-18.8-34.7-38.3-29.9-212.4 53.1-223.7 55.9-226.2 56.5-13.7 3.4-23.3 15.8-23.3 29.9zm0 80c0 20 18.8 34.7 38.3 29.9 61.1-15.3 130.1-32.5 207.4-51.9l18.7-4.7c13.7-3.4 23.3-15.8 23.3-29.9 0-20-18.8-34.7-38.3-29.9l-207.3 51.8-18.8 4.7c-13.7 3.4-23.3 15.8-23.3 29.9zM240 416l0 16c0 35.3 28.7 64 64 64l32 0c35.3 0 64-28.7 64-64l0-16c0-8.8-7.2-16-16-16l-128 0c-8.8 0-16 7.2-16 16zm32-155.8l0 29 16-4 0 98.8 63.9 0 0-61.5c0-11 7.5-20.6 18.2-23.3l70.5-17.6c13.7-3.4 23.3-15.8 23.3-29.9 0-20-18.8-34.7-38.3-29.9-86.1 21.5-137.4 34.3-153.6 38.4z", "M320 47.7c0 14.1-9.6 26.4-23.2 29.9l-.1 0-82.2 20.6 0 0c-19.4 4.8-38.2-9.9-38.2-29.9 0-14.1 9.6-26.5 23.3-29.9l82.2-20.6C301.1 13 320 27.7 320 47.7zM160.1 68.3c0 17.2 9.2 31.9 22.5 40-13.7 8.3-22.5 23.3-22.5 40 0 17.2 9.2 31.9 22.5 40-13.7 8.3-22.5 23.3-22.5 40 0 30.5 28.6 52.8 58.2 45.4l95.6-23.9 0 0 111.7-27.9 .1 0c19.4-4.8 38.2 9.9 38.2 29.9 0 14.1-9.6 26.5-23.3 29.9l-70.5 17.6c-10.7 2.7-18.2 12.3-18.2 23.3l0 61.5-63.9 0 0-98.8-16 4 0 94.8-16 0c-17.7 0-32 14.3-32 32l0 16c0 44.2 35.8 80 80 80l32 0c44.2 0 80-35.8 80-80l0-16c0-17.7-14.3-32-32-32l-16.1 0 0-61.5c0-3.7 2.5-6.9 6.1-7.8l70.5-17.6c20.8-5.2 35.5-23.9 35.5-45.4 0-17.2-9.2-31.9-22.5-40 13.7-8.3 22.5-23.3 22.5-40 0-17.2-9.2-31.9-22.5-40 13.7-8.3 22.5-23.3 22.5-40 0-30.5-28.6-52.8-58.2-45.4L330.8 69.1c3.3-6.4 5.1-13.7 5.1-21.3 0-30.5-28.6-52.8-58.2-45.4L195.6 22.9c-20.8 5.2-35.5 23.9-35.5 45.4zm39.3 50.1l18.8-4.7 .1 0 82.2-20.6 .1 0 125-31.3c19.4-4.9 38.3 9.8 38.3 29.9 0 14.1-9.6 26.5-23.3 29.9l-18.8 4.7-207.4 51.8c-19.4 4.9-38.3-9.8-38.3-29.9 0-14.1 9.6-26.5 23.3-29.9zm222.4 87.9l-.1 0c-77.1 19.3-146.3 36.6-207.3 51.8-19.4 4.9-38.3-9.8-38.3-29.9 0-14.1 9.6-26.5 23.3-29.9l18.8-4.7 207.3-51.8c19.4-4.9 38.3 9.8 38.3 29.9 0 14.1-9.6 26.5-23.3 29.9l-18.7 4.7zM384 400c8.8 0 16 7.2 16 16l0 16c0 35.3-28.7 64-64 64l-32 0c-35.3 0-64-28.7-64-64l0-16c0-8.8 7.2-16 16-16l128 0zM36.4 25.3c-3.7-2.5-8.6-1.5-11.1 2.2s-1.5 8.6 2.2 11.1l48 32c3.7 2.5 8.6 1.5 11.1-2.2s1.5-8.6-2.2-11.1l-48-32zm576 13.3c3.7-2.5 4.7-7.4 2.2-11.1s-7.4-4.7-11.1-2.2l-48 32c-3.7 2.5-4.7 7.4-2.2 11.1s7.4 4.7 11.1 2.2l48-32zM16 184c-4.4 0-8 3.6-8 8s3.6 8 8 8l48 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-48 0zm560 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l48 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-48 0zM84.4 326.7c3.7-2.5 4.7-7.4 2.2-11.1s-7.4-4.7-11.1-2.2l-48 32c-3.7 2.5-4.7 7.4-2.2 11.1s7.4 4.7 11.1 2.2l48-32zm480-13.3c-3.7-2.5-8.6-1.5-11.1 2.2s-1.5 8.6 2.2 11.1l48 32c3.7 2.5 8.6 1.5 11.1-2.2s1.5-8.6-2.2-11.1l-48-32z"]],
    "clock-three": [512, 512, [], "e356", ["M496 256a240 240 0 1 1 -480 0 240 240 0 1 1 480 0zM248 104l0 152c0 4.4 3.6 8 8 8l120 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-112 0 0-144c0-4.4-3.6-8-8-8s-8 3.6-8 8z", "M496 256a240 240 0 1 1 -480 0 240 240 0 1 1 480 0zM0 256a256 256 0 1 0 512 0 256 256 0 1 0 -512 0zM248 104l0 152c0 4.4 3.6 8 8 8l120 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-112 0 0-144c0-4.4-3.6-8-8-8s-8 3.6-8 8z"]],
    "person-walking-luggage": [512, 512, [], "e554", ["M10.2 486.1c-4 7.9-.7 17.5 7.2 21.5l37.1 18.5c7.9 4 17.5 .7 21.5-7.2 16.8-33.7 33.7-67.4 50.6-101.3 3.8-7.9 .6-17.3-7.3-21.2L82.2 377.9c-7.9-4-17.5-.7-21.5 7.2L10.2 486.1zM176.3 250.5l0 37.5c0 8.8 7.2 16 16 16s16-7.2 16-16l0-37.5c0-12.7 5.1-24.9 14.1-33.9L245 193.9c4.6-4.6 11.5-5.9 17.4-3.5s9.9 8.3 9.9 14.8l0 69.3c0 23.4 10.2 45.5 27.9 60.7l71.4 61.2c8.8 7.6 14.6 18.1 16.3 29.7l12.6 88.1c1.2 8.7 9.4 14.8 18.1 13.6s14.8-9.4 13.6-18.1l-12.6-88.1c-2.7-19.2-12.4-36.8-27.1-49.4l-34.5-29.6c-3.5-3-5.6-7.5-5.6-12.1l0-115.2c0-6.8 4.3-12.8 10.7-15.1s13.5-.2 17.8 5.1l3.8 4.7c15.2 19 38.2 30 62.5 30l33.2 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-33.2 0c-14.6 0-28.4-6.6-37.5-18l-17.9-22.4c-20-25-50.3-39.6-82.3-39.6-28 0-54.8 11.1-74.5 30.9l-35.1 35.1c-15 15-23.4 35.4-23.4 56.6zm12.1 250.8c-5.9 6.6-5.4 16.7 1.2 22.6s16.7 5.4 22.6-1.2l72-80c1.6-1.8 2.8-4 3.5-6.3l8.7-30.6c-8.9-7.6-17.8-15.3-26.7-22.9l-10.7 37.6-1 3.6-2.5 2.7-67 74.5zM280.3 24a40 40 0 1 0 80 0 40 40 0 1 0 -80 0z", "M272.3 205.3c0-6.5-3.9-12.3-9.9-14.8s-12.9-1.1-17.4 3.5l-22.6 22.6c-9 9-14.1 21.2-14.1 33.9l0 37.5c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-37.5c0-21.2 8.4-41.6 23.4-56.6l35.1-35.1c19.8-19.8 46.6-30.9 74.5-30.9 32 0 62.3 14.6 82.3 39.6L409.6 190c9.1 11.4 22.9 18 37.5 18l33.2 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-33.2 0c-24.3 0-47.3-11-62.5-30l-3.8-4.7c-4.2-5.3-11.4-7.4-17.8-5.1s-10.7 8.3-10.7 15.1l0 115.2c0 4.7 2 9.1 5.6 12.1l34.5 29.6c14.7 12.6 24.4 30.2 27.1 49.4l12.6 88.1c1.3 8.7-4.8 16.9-13.6 18.1s-16.9-4.8-18.1-13.6l-12.6-88.1c-1.6-11.5-7.4-22.1-16.3-29.7l-71.4-61.2c-17.7-15.2-27.9-37.4-27.9-60.7l0-69.3zm8-181.3a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zM233.7 227.9c2.9-2.9 10.4-10.4 22.6-22.6l0 69.3c0 28 12.2 54.7 33.5 72.9l71.4 61.2c5.9 5.1 9.8 12.1 10.9 19.8l12.6 88.1c2.5 17.5 18.7 29.7 36.2 27.2S450.5 525 448 507.5l-12.6-88.1c-3.3-23.1-14.9-44.1-32.6-59.3l-34.5-29.6 0-115.2 3.8 4.7c3.7 4.6 7.8 8.9 12.2 12.7 17.3 14.9 39.5 23.4 62.8 23.4l33.2 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-33.2 0c-9.7 0-18.9-4.4-25-12l-17.9-22.4c-23-28.8-57.9-45.6-94.8-45.6-32.2 0-63.1 12.8-85.8 35.6l-35.1 35.1c-18 18-28.1 42.4-28.1 67.9l0 37.5c0 17.7 14.3 32 32 32s32-14.3 32-32l0-37.5c0-8.5 3.4-16.6 9.4-22.6zM320.3 80a56 56 0 1 0 0-112 56 56 0 1 0 0 112zM243.6 416.1l-67 74.5c-11.8 13.1-10.8 33.4 2.4 45.2s33.4 10.8 45.2-2.4l72-80c3.3-3.6 5.6-7.9 7-12.6l6.7-23.5-13.4-11.5-8.7 30.6c-.7 2.3-1.9 4.5-3.5 6.3l-72 80c-5.9 6.6-16 7.1-22.6 1.2s-7.1-16-1.2-22.6l67-74.5 2.5-2.7 1-3.6 10.7-37.6-13.4-11.5-12.8 44.7zM82.2 377.9l37.1 18.5c7.8 3.9 11 13.4 7.3 21.2-16.9 33.9-33.8 67.6-50.6 101.3-4 7.9-13.6 11.1-21.5 7.2L17.4 507.6c-7.9-4-11.1-13.6-7.2-21.5L60.7 385c4-7.9 13.6-11.1 21.5-7.2zm33.3 97.7L140.7 425c.1-.1 .1-.2 .2-.3l34.6-69.1c2-4 .4-8.8-3.6-10.7s-8.8-.4-10.7 3.6l-22.3 44.7c-3-4.5-7.2-8.4-12.4-11L89.4 363.6c-15.8-7.9-35-1.5-42.9 14.3L-4.1 479c-7.9 15.8-1.5 35 14.3 42.9l37.1 18.5c15.8 7.9 35 1.5 42.9-14.3l25.3-50.5z"]],
    "file-arrow-down": [384, 512, ["file-download"], "f56d", ["M16 64l0 384c0 26.5 21.5 48 48 48l256 0c26.5 0 48-21.5 48-48l0-261.5c0-3.6-.4-7.1-1.2-10.5L264 176c-30.9 0-56-25.1-56-56l0-102.8c-3.4-.8-6.9-1.2-10.5-1.2L64 16C37.5 16 16 37.5 16 64zm98.3 282.3c3.1-3.1 8.2-3.1 11.3 0L184 404.7 184 248c0-4.4 3.6-8 8-8s8 3.6 8 8l0 156.7 58.3-58.3c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3l-72 72c-3.1 3.1-8.2 3.1-11.3 0l-72-72c-3.1-3.1-3.1-8.2 0-11.3z", "M197.5 16c3.6 0 7.1 .4 10.5 1.2L208 120c0 30.9 25.1 56 56 56l102.8 0c.8 3.4 1.2 6.9 1.2 10.5L368 448c0 26.5-21.5 48-48 48L64 496c-26.5 0-48-21.5-48-48L16 64c0-26.5 21.5-48 48-48l133.5 0zM353.9 152.6c2.3 2.3 4.3 4.8 6.1 7.4l-96 0c-22.1 0-40-17.9-40-40l0-96c2.7 1.8 5.1 3.8 7.4 6.1L353.9 152.6zM64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-261.5c0-17-6.7-33.3-18.7-45.3L242.7 18.7C230.7 6.7 214.5 0 197.5 0L64 0zM186.3 429.7c3.1 3.1 8.2 3.1 11.3 0l72-72c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0L200 404.7 200 248c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 156.7-58.3-58.3c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l72 72z"]],
    "person-booth": [576, 512, [], "f756", ["M48 171.1c0-23.8 19.3-43.1 43.1-43.1 18.3 0 35.5 8.8 46.1 23.7l48.7 68.2c9 12.6 23.6 20.1 39.1 20.1l31.1 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-31.1 0c-25.8 0-50.1-12.5-65.1-33.5l-17.3-24.3c-2-2.8-5.6-4-9-3s-5.6 4.1-5.6 7.6l0 115.2c0 2.3 1 4.6 2.8 6.1l33.3 28.5c17.7 15.2 27.9 37.4 27.9 60.7l0 82.6c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-82.6c0-14-6.1-27.3-16.8-36.4L75.9 335.3C58.2 320.1 48 297.9 48 274.6l0-103.5zm0 214c10.7 9.1 21.3 18.3 32 27.4L80 512c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-126.9zM136 24a40 40 0 1 1 -80 0 40 40 0 1 1 80 0zm149-7.7c1-.2 2-.3 3-.3l256 0c8.8 0 16 7.2 16 16l0 400-198.2 0 38.1-190.4c.4-1.8 .1-3.6-.7-5.3l-112-216-2.1-4z", "M56 24a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zm96 0A56 56 0 1 0 40 24 56 56 0 1 0 152 24zM32 171.1l0 103.5c0 28 12.2 54.7 33.5 72.9l67.3 57.7c7.1 6.1 11.2 15 11.2 24.3l0 82.6c0 17.7 14.3 32 32 32s32-14.3 32-32l0-82.6c0-28-12.2-54.7-33.5-72.9l-30.5-26.1 0-86.6 2.8 3.9c18 25.2 47.1 40.2 78.1 40.2l31.1 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-31.1 0c-10.3 0-20-5-26-13.4l-48.7-68.2C136.6 123.3 114.5 112 91.1 112 58.5 112 32 138.5 32 171.1zM91.1 128c18.3 0 35.5 8.8 46.1 23.7l48.7 68.2c9 12.6 23.6 20.1 39.1 20.1l31.1 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-31.1 0c-25.8 0-50.1-12.5-65.1-33.5l-17.3-24.3c-2-2.8-5.6-4-9-3s-5.6 4.1-5.6 7.6l0 115.2c0 2.3 1 4.6 2.8 6.1l33.3 28.5c17.7 15.2 27.9 37.4 27.9 60.7l0 82.6c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-82.6c0-14-6.1-27.3-16.8-36.4L75.9 335.3C58.2 320.1 48 297.9 48 274.6l0-103.5C48 147.3 67.3 128 91.1 128zM32 370.9L32 512c0 17.7 14.3 32 32 32s32-14.3 32-32l0-85.7-16-13.7 0 99.5c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-126.9-8.5-7.3c-2.6-2.2-5.1-4.5-7.5-6.9zM285 16.3c1-.2 2-.3 3-.3l256 0c8.8 0 16 7.2 16 16l0 400-198.2 0 38.1-190.4c.4-1.8 .1-3.6-.7-5.3l-112-216-2.1-4zM560 448l0 88c0 4.4 3.6 8 8 8s8-3.6 8-8l0-504c0-17.7-14.3-32-32-32L288 0c-17.7 0-32 14.3-32 32l0 144 16 0 0-144c0-1.6 .2-3.2 .7-4.7l.2 .4 110.7 213.5-39.4 197.2c-.5 2.3 .1 4.8 1.7 6.6s3.8 2.9 6.2 2.9l208 0zM256 336l0 200c0 4.4 3.6 8 8 8s8-3.6 8-8l0-200-16 0z"]],
    "locust": [576, 512, [], "e520", ["M48 294.2c0-29.9 24.3-54.2 54.2-54.2l67.1 0-79.7 107.9-10-4.6c-19.3-8.8-31.6-28-31.6-49.2zm56.5 60.6L189.2 240 480 240c44.2 0 80 35.8 80 80s-35.8 80-80 80l-210.3 0c-38.2 0-76-7.2-111.4-21.1l-15-6.4-38.8-17.7zM464 320a16 16 0 1 0 32 0 16 16 0 1 0 -32 0z", "M344 32c128.1 0 232 103.9 232 232l0 56-.1 4.9c-2 39-27.2 71.7-62.1 84.8l29.3 58.7c2 3.9 .4 8.7-3.6 10.7s-8.7 .4-10.7-3.6l-30.7-61.3c-5.9 1.1-12 1.8-18.2 1.8l-171.6 0-37.7 60.2c-2.3 3.7-7.3 4.9-11 2.5s-4.9-7.3-2.5-11l32.3-51.8-19.9 0-17.2-.5c-20.5-1.1-40.7-4.2-60.6-9.2 .1 1.8-.3 3.7-1.5 5.3l-48 65.2c-2.6 3.6-7.6 4.3-11.2 1.7s-4.3-7.6-1.7-11.2l47.8-64.9c-8.4-2.5-16.7-5.4-24.9-8.6l-15.8-6.7-41.9-19.2-80.3 108.9c-2.6 3.6-7.6 4.3-11.2 1.7s-4.3-7.6-1.7-11.2l78.3-106.2-6.9-3.2C49.6 347.2 34 324.6 32.2 299.3l-.2-5.1c0-36.3 27.6-66.2 63-69.8l7.2-.4 78.9 0 68.5-92.8 1.3-1.4c1.5-1.2 3.4-1.9 5.3-1.8 2.6 .1 5 1.4 6.5 3.6l57.9 86.9 56.7-86.9 1.3-1.6c1.5-1.4 3.5-2.1 5.6-2.1 2.8 .1 5.3 1.6 6.7 4l53.7 92 35.4 0c33.4 0 62.8 17.1 80 43l0-3c0-119.3-96.7-216-216-216l-32 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l32 0zM104.5 354.7l38.8 17.7 15 6.4c35.4 13.9 73.2 21.1 111.4 21.1L480 400c44.2 0 80-35.8 80-80s-35.8-80-80-80l-290.8 0-84.7 114.7zM102.2 240c-29.9 0-54.2 24.3-54.2 54.2 0 21.2 12.4 40.4 31.6 49.2l10 4.6 79.7-107.9-67.1 0zM480 336a16 16 0 1 1 0-32 16 16 0 1 1 0 32zM201 224l104.1 0-49.4-74.1-54.7 74.1zm135.2 0l89.9 0-42.5-72.8-47.4 72.8z"]],
    "window": [512, 512, [], "f40e", ["M16 128l0 80 480 0 0-80c0-26.5-21.5-48-48-48L64 80c-26.5 0-48 21.5-48 48zm96 16a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm96 0a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm96 0a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M448 80c26.5 0 48 21.5 48 48l0 80-480 0 0-80c0-26.5 21.5-48 48-48l384 0zm48 144l0 160c0 26.5-21.5 48-48 48L64 432c-26.5 0-48-21.5-48-48l0-160 480 0zM64 64C28.7 64 0 92.7 0 128L0 384c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L64 64zm48 80a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm80 16a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm112-16a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"]],
    "right-long": [576, 512, ["long-arrow-alt-right"], "f30b", ["M16 240l0 32c0 17.7 14.3 32 32 32l344 0c4.4 0 8 3.6 8 8l0 72c0 6.5 3.9 12.3 9.9 14.8s12.9 1.1 17.4-3.5l128-128c6.2-6.2 6.2-16.4 0-22.6l-128-128c-4.6-4.6-11.5-5.9-17.4-3.5S400 121.5 400 128l0 72c0 4.4-3.6 8-8 8L48 208c-17.7 0-32 14.3-32 32z", "M555.3 267.3c6.2-6.2 6.2-16.4 0-22.6l-128-128c-4.6-4.6-11.5-5.9-17.4-3.5S400 121.5 400 128l0 72c0 4.4-3.6 8-8 8L48 208c-17.7 0-32 14.3-32 32l0 32c0 17.7 14.3 32 32 32l344 0c4.4 0 8 3.6 8 8l0 72c0 6.5 3.9 12.3 9.9 14.8s12.9 1.1 17.4-3.5l128-128zm11.3-33.9c12.5 12.5 12.5 32.8 0 45.3l-128 128c-9.2 9.2-22.9 11.9-34.9 6.9l0 0c-12-5-19.8-16.6-19.8-29.6l0-64-336 0c-26.5 0-48-21.5-48-48l0-32c0-26.5 21.5-48 48-48l336 0 0-64c0-12.9 7.8-24.6 19.8-29.6s25.7-2.2 34.9 6.9l128 128z"]],
    "truck-droplet": [576, 512, [], "e58c", ["M16 96l0 288c0 26.5 21.5 48 48 48l.4 0c-.2-2.6-.4-5.3-.4-8 0-48.6 39.4-88 88-88s88 39.4 88 88c0 2.7-.1 5.4-.4 8l96.7 0c-.2-2.6-.4-5.3-.4-8 0-40.3 27.1-74.2 64-84.7L400 96c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96zM136 232c0-33.2 34.5-78 55.8-102.4 8.7-10 23.8-10 32.5 0 21.2 24.4 55.8 69.1 55.8 102.4 0 48-32.2 72-72 72s-72-32.2-72-72zm280 40l0 64.4c2.6-.2 5.3-.4 8-.4 48.6 0 88 39.4 88 88 0 2.7-.1 5.4-.4 8l.4 0c26.5 0 48-21.5 48-48l0-112-144 0z", "M352 48c26.5 0 48 21.5 48 48l0 243.3c-36.9 10.4-64 44.4-64 84.7 0 2.7 .1 5.4 .4 8l-96.7 0c.2-2.6 .4-5.3 .4-8 0-48.6-39.4-88-88-88s-88 39.4-88 88c0 2.7 .1 5.4 .4 8l-.4 0c-26.5 0-48-21.5-48-48L16 96c0-26.5 21.5-48 48-48l288 0zM64 448l3.3 0c10.4 36.9 44.4 64 84.7 64s74.2-27.1 84.7-64l102.6 0c10.4 36.9 44.4 64 84.7 64s74.2-27.1 84.7-64l3.3 0c35.3 0 64-28.7 64-64l0-149.5c0-19.1-7.6-37.4-21.1-50.9l-34.5-34.5c-13.5-13.5-31.8-21.1-50.9-21.1l-53.5 0 0-32c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 384c0 35.3 28.7 64 64 64zM416 144l53.5 0c14.9 0 29.1 5.9 39.6 16.4l34.5 34.5c10.5 10.5 16.4 24.7 16.4 39.6l0 21.5-144 0 0-112zm0 192.4l0-64.4 144 0 0 112c0 26.5-21.5 48-48 48l-.4 0c.2-2.6 .4-5.3 .4-8 0-48.6-39.4-88-88-88-2.7 0-5.4 .1-8 .4zM80 424a72 72 0 1 1 144 0 72 72 0 1 1 -144 0zm272 0a72 72 0 1 1 144 0 72 72 0 1 1 -144 0zM264 232c0 20.2-6.7 33.7-15.9 42.2-9.5 8.7-23.3 13.8-40.1 13.8-30.9 0-56-25.1-56-56 0-11.9 6.6-28.2 17.6-46.1 10.6-17.3 23.9-33.9 34.3-45.7 2.3-2.7 6-2.7 8.4 0 10.3 11.9 23.6 28.4 34.3 45.7 11 17.9 17.6 34.2 17.6 46.1zm16 0c0-33.2-34.5-78-55.8-102.4-8.7-10-23.8-10-32.5 0-21.2 24.4-55.8 69.1-55.8 102.4 0 39.8 32.2 72 72 72s72-24 72-72z"]],
    "hand-holding-medical": [576, 512, [], "e05c", ["M0 392c0 4.4 3.6 8 8 8l64 0c1.6 0 3.1-.5 4.4-1.3l79.9-53.3c9.2-6.1 20-9.4 31.1-9.4L336 336c17.7 0 32 14.3 32 32s-14.3 32-32 32l-88 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l148.6 0c1.5 0 3.1-.4 4.3-1.3l114.2-74c4.7-3 10.3-4.7 15.9-4.7 15.9 0 29 12.9 29 28.6 0 9.5-4.7 18.3-12.5 23.7L412 480.7c-14.6 10-31.9 15.3-49.6 15.3L8 496c-4.4 0-8 3.6-8 8L0 392z", "M256 48l0 40c0 4.4-3.6 8-8 8l-40 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l40 0c4.4 0 8 3.6 8 8l0 40c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-40c0-4.4 3.6-8 8-8l40 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-40 0c-4.4 0-8-3.6-8-8l0-40c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm16-32l32 0c17.7 0 32 14.3 32 32l0 32 32 0c17.7 0 32 14.3 32 32l0 32c0 17.7-14.3 32-32 32l-32 0 0 32c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-32-32 0c-17.7 0-32-14.3-32-32l0-32c0-17.7 14.3-32 32-32l32 0 0-32c0-17.7 14.3-32 32-32zM147.4 332.1c11.8-7.9 25.7-12.1 39.9-12.1L336 320c26.5 0 48 21.5 48 48 0 12.3-4.6 23.5-12.2 32l22.4 0 112.2-72.8c7.3-4.7 15.9-7.2 24.6-7.2 24.6 0 45 19.9 45 44.6 0 14.8-7.3 28.6-19.5 36.9L421 493.9c-17.3 11.8-37.7 18.1-58.6 18.1L8 512c-4.4 0-8-3.6-8-8s3.6-8 8-8l354.4 0c17.7 0 35-5.3 49.6-15.3l135.5-92.4c7.8-5.3 12.5-14.2 12.5-23.7 0-15.7-13-28.6-29-28.6-5.6 0-11.2 1.6-15.9 4.7l-114.2 74c-1.3 .8-2.8 1.3-4.3 1.3L248 416c-4.4 0-8-3.6-8-8s3.6-8 8-8l88 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-148.6 0c-11.1 0-21.9 3.3-31.1 9.4L76.4 398.7c-1.3 .9-2.9 1.3-4.4 1.3L8 400c-4.4 0-8-3.6-8-8s3.6-8 8-8l61.6 0 77.9-51.9z"]],
    "hand-point-left": [512, 512, [], "f0a5", ["M16 160c0 17.7 14.3 32 32 32l208 0 0-56c0-2.7 .1-5.4 .4-8L48 128c-17.7 0-32 14.3-32 32zm152 80c0 17.7 14.3 32 32 32l68.2 0c-7.6-8.5-12.2-19.7-12.2-32l0-32-56 0c-17.7 0-32 14.3-32 32zm32 80c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0c-17.7 0-32 14.3-32 32zm16 80c0 17.7 14.3 32 32 32l56 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-56 0c-17.7 0-32 14.3-32 32zm56-264l0 104c0 17.7 14.3 32 32 32s32-14.3 32-32l0-72c0-4.4 3.6-8 8-8s8 3.6 8 8l0 72c0 18.5-10.5 34.6-25.9 42.6 10.9 8.8 17.9 22.3 17.9 37.4s-7 28.6-17.9 37.4c15.4 8 25.9 24.1 25.9 42.6 0 12.3-4.6 23.5-12.2 32l20.2 0c75.1 0 136-60.9 136-136l0-80c0-75.1-60.9-136-136-136l-32 0c-30.9 0-56 25.1-56 56z", "M48 128c-17.7 0-32 14.3-32 32s14.3 32 32 32l208 0 0-56c0-2.7 .1-5.4 .4-8L48 128zm224 64l0 48c0 17.7 14.3 32 32 32s32-14.3 32-32l0-72c0-4.4 3.6-8 8-8s8 3.6 8 8l0 72c0 18.5-10.5 34.6-25.9 42.6 10.9 8.8 17.9 22.3 17.9 37.4s-7 28.6-17.9 37.4c15.4 8 25.9 24.1 25.9 42.6 0 12.3-4.6 23.5-12.2 32l20.2 0c75.1 0 136-60.9 136-136l0-80c0-75.1-60.9-136-136-136l-32 0c-30.9 0-56 25.1-56 56l0 56zm-16 16l-56 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l68.2 0c-7.6-8.5-12.2-19.7-12.2-32l0-32zm-91.8 0L48 208c-26.5 0-48-21.5-48-48s21.5-48 48-48l212.1 0C270 84 296.6 64 328 64l32 0c83.9 0 152 68.1 152 152l0 80c0 83.9-68.1 152-152 152l-112 0c-26.5 0-48-21.5-48-48 0-13.8 5.8-26.3 15.2-35-18.2-6.8-31.2-24.4-31.2-45 0-12.4 4.7-23.6 12.3-32.1-24.8-1.9-44.3-22.6-44.3-47.9 0-12.3 4.6-23.5 12.2-32zM272 288l-40 0c-17.7 0-32 14.3-32 32 0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-24 0zm8 144l24 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-56 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l32 0z"]],
    "calculator": [384, 512, [128425], "f1ec", ["M16 64l0 384c0 26.5 21.5 48 48 48l256 0c26.5 0 48-21.5 48-48l0-384c0-26.5-21.5-48-48-48L64 16C37.5 16 16 37.5 16 64zM64 96c0-17.7 14.3-32 32-32l192 0c17.7 0 32 14.3 32 32l0 32c0 17.7-14.3 32-32 32L96 160c-17.7 0-32-14.3-32-32l0-32zm64 128a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm0 96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM64 416c0-17.7 14.3-32 32-32l96 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-96 0c-17.7 0-32-14.3-32-32zM224 224a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm0 96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm96-96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm0 96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm-64 96c0-17.7 14.3-32 32-32s32 14.3 32 32-14.3 32-32 32-32-14.3-32-32z", "M64 16C37.5 16 16 37.5 16 64l0 384c0 26.5 21.5 48 48 48l256 0c26.5 0 48-21.5 48-48l0-384c0-26.5-21.5-48-48-48L64 16zM0 64C0 28.7 28.7 0 64 0L320 0c35.3 0 64 28.7 64 64l0 384c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zM96 80c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l192 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16L96 80zM64 96c0-17.7 14.3-32 32-32l192 0c17.7 0 32 14.3 32 32l0 32c0 17.7-14.3 32-32 32L96 160c-17.7 0-32-14.3-32-32l0-32zM80 224a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm16 32a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm0 80a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm32-16a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm64 80l-96 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l96 0c8.8 0 16-7.2 16-16s-7.2-16-16-16zM96 384l96 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-96 0c-17.7 0-32-14.3-32-32s14.3-32 32-32zm96-144a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm32-16a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm-48 96a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm16 32a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm96-112a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm32-16a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm-48 96a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm16 32a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm0 80c8.8 0 16-7.2 16-16s-7.2-16-16-16-16 7.2-16 16 7.2 16 16 16zm-32-16c0-17.7 14.3-32 32-32s32 14.3 32 32-14.3 32-32 32-32-14.3-32-32z"]],
    "oil-temperature": [640, 512, ["oil-temp"], "f614", ["M256 304a64 64 0 1 0 128 0 64 64 0 1 0 -128 0z", "M578.9 375.2c5.8-10.6 20.5-10.6 26.3 0 14.2 26.2 34.9 67.8 34.9 88.8 0 32-21.5 48-48 48s-48-21.5-48-48c0-21 20.7-62.6 34.9-88.8zm13.1 9.4c-6.8 12.6-14.8 28.3-21.2 43.2-7 16.4-10.8 29.3-10.8 36.2 0 17.7 14.3 32 32 32 10.1 0 18-3.1 23.1-7.8 4.9-4.5 8.9-12 8.9-24.2 0-6.8-3.8-19.8-10.8-36.2-6.4-14.9-14.4-30.6-21.2-43.2zm22.4-163.8c18.1-4 30.8 17.5 18.6 31.4L451.1 458.3c-12.1 13.8-29.6 21.7-48 21.7l-259.1 0-4.9-.2C114.9 477.3 96 456.8 96 432l0-22.9-66.9-28.7C11.5 372.9 0 355.5 0 336.3L0 272c0-26.5 21.5-48 48-48l172.1 0c-4 5-7.7 10.4-10.9 16l-97.2 0 0 192c0 17.7 14.3 32 32 32l259.1 0c13.8 0 26.9-5.9 36-16.2L621 241.7c.7-.8 .8-1.4 .9-1.8 0-.5-.1-1.2-.5-1.9s-1-1.2-1.4-1.4c-.4-.2-1-.4-2-.1L444.6 274.9c-1.2-5.3-2.7-10.4-4.6-15.4l174.4-38.7zM48 240c-17.7 0-32 14.3-32 32l0 64.3c0 12.8 7.6 24.4 19.4 29.4l60.6 26 0-151.7-48 0zM408 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-80 0 0 80 80 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-80 0 0 112.4c40.4 4 72 38.1 72 79.6 0 44.2-35.8 80-80 80s-80-35.8-80-80c0-41.5 31.6-75.6 72-79.6L312 8c0-4.4 3.6-8 8-8l88 0zM320 240a64 64 0 1 0 0 128 64 64 0 1 0 0-128z"]],
    "minus": [448, 512, [8211, 8722, 10134, "subtract"], "f068", ["", "M0 256c0-4.4 3.6-8 8-8l432 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L8 264c-4.4 0-8-3.6-8-8z"]],
    "message-arrow-down": [512, 512, ["comment-alt-arrow-down"], "e1db", ["M16 128l0 224c0 44.2 35.8 80 80 80l32 0c8.8 0 16 7.2 16 16l0 75.9c0 2.3 2 4 4.1 4.1 .8 0 1.7-.2 2.4-.7 3.3-2.3 6.3-4.5 9.1-6.4l.4-.3c6.7-4.7 30.4-21.5 117.2-82.7 5.4-3.8 11.8-5.9 18.5-5.9L416 432c44.2 0 80-35.8 80-80l0-224c0-44.2-35.8-80-80-80L96 48c-44.2 0-80 35.8-80 80zM178.3 250.3c3.1-3.1 8.2-3.1 11.3 0L248 308.7 248 152c0-4.4 3.6-8 8-8s8 3.6 8 8l0 156.7 58.3-58.3c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3l-72 72c-3.1 3.1-8.2 3.1-11.3 0l-72-72c-3.1-3.1-3.1-8.2 0-11.3z", "M144 448l0 75.9c0 2.3 2 4 4.1 4.1 .8 0 1.7-.2 2.4-.7 3.3-2.3 6.3-4.5 9.1-6.4l.4-.3c6.7-4.7 30.4-21.5 117.2-82.7 5.4-3.8 11.8-5.9 18.5-5.9L416 432c44.2 0 80-35.8 80-80l0-224c0-44.2-35.8-80-80-80L96 48c-44.2 0-80 35.8-80 80l0 224c0 44.2 35.8 80 80 80l32 0c8.8 0 16 7.2 16 16zM0 128C0 75 43 32 96 32l320 0c53 0 96 43 96 96l0 224c0 53-43 96-96 96l-120.4 0c-3.3 0-6.5 1-9.2 2.9L159.8 540.3c-3.4 2.4-7.5 3.7-11.6 3.7-11.1 0-20.1-9-20.1-20.1l0-75.9-32 0c-53 0-96-43-96-96L0 128zM250.3 333.7l-72-72c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0L248 308.7 248 152c0-4.4 3.6-8 8-8s8 3.6 8 8l0 156.7 58.3-58.3c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3l-72 72c-3.1 3.1-8.2 3.1-11.3 0z"]],
    "shoe": [640, 512, [], "e6d8", ["M16 224l0 144 607.7 0c-3-43.1-30.7-80.9-71.5-96.6l-92.8-35.7c-10.2-3.9-20.1-8.7-29.6-14.2l-48.1 48.1c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l45.6-45.6c-7.3-5.1-14.4-10.6-21-16.6l-35.7-32.1-49.6 49.6c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l49-49-74-66.6c-4.8-4.3-11-6.7-17.5-6.7-11.7 0-22 7.7-25.2 19l-1.9 6.7C214.1 156.8 167.5 192 114.3 192L48 192c-17.7 0-32 14.3-32 32z", "M195.8 384l428.2 0 0 16c0 17.7-14.3 32-32 32l-273.8 0c-17.4 0-34.5-4-50.1-11.8l-69-34.5-3.4-1.7zM176 384l0 16c0 17.7-14.3 32-32 32l-96 0c-17.7 0-32-14.3-32-32l0-16 160 0zM16 368l0-144c0-17.7 14.3-32 32-32l66.3 0c53.1 0 99.8-35.2 114.4-86.3l1.9-6.7c3.2-11.2 13.5-19 25.2-19 6.5 0 12.7 2.4 17.5 6.7l74 66.6-49 49c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l49.6-49.6 35.7 32.1c6.7 6 13.7 11.5 21 16.6l-45.6 45.6c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l48.1-48.1c9.5 5.5 19.4 10.2 29.6 14.2l92.8 35.7c40.8 15.7 68.5 53.5 71.5 96.6L16 368zm245 66.5c17.8 8.9 37.4 13.5 57.2 13.5L592 448c26.5 0 48-21.5 48-48l0-24.1c0-53-32.6-100.5-82.1-119.5l-92.8-35.7c-21.9-8.4-42.1-20.8-59.5-36.5L284 74.8c-7.7-7-17.8-10.8-28.2-10.8-18.8 0-35.4 12.5-40.6 30.6l-1.9 6.7c-12.6 44.2-53 74.7-99 74.7L48 176c-26.5 0-48 21.5-48 48L0 400c0 26.5 21.5 48 48 48l96 0c20.7 0 38.4-13.1 45.1-31.6 1.9-5.1 2.9-10.7 2.9-16.4 4 2 27 13.5 69 34.5z"]],
    "game-board-simple": [448, 512, ["game-board-alt"], "f868", ["M63.4 111.8l0 128.2c0 1.5 .2 2.9 .6 4.3L64 128c0-16.6 12.6-30.2 28.7-31.8L96 96 210.5 96c-.8-.1-1.7-.2-2.5-.2l-128.6 0c-8.8 0-16 7.2-16 16zM80 128l0 120 136 0 0-136-120 0c-8.8 0-16 7.2-16 16zM232 264l0 136 120 0c8.8 0 16-7.2 16-16l0-120-136 0zm2.8 152c1.6 .6 3.4 .9 5.2 .9l127.8 0c8.8 0 16-7.2 16-16l0-13.4c-1.6 15-13.6 26.8-28.5 28.4l-3.3 .2-117.2 0z", "M390.5 32.3C422.8 35.6 448 62.9 448 96l0 320-.3 6.5c-3.1 30.1-27 54.1-57.1 57.1l-6.5 .3-320 0-6.5-.3c-30.1-3.1-54.1-27-57.1-57.1L0 416 0 96C0 62.9 25.2 35.6 57.5 32.3l6.5-.3 320 0 6.5 .3zM64 48C37.5 48 16 69.5 16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48zM355.3 96.2C371.4 97.8 384 111.4 384 128l0 256-.2 3.3c-1.5 15.1-13.5 27-28.6 28.6l-3.3 .2-256 0-3.3-.2c-15.1-1.5-27-13.5-28.6-28.6L64 384 64 128c0-16.6 12.6-30.2 28.7-31.8l3.3-.2 256 0 3.3 .2zM232 400l120 0c8.8 0 16-7.2 16-16l0-120-136 0 0 136zM80 384c0 8.8 7.2 16 16 16l120 0 0-136-136 0 0 120zM232 248l136 0 0-120c0-8.8-7.2-16-16-16l-120 0 0 136zM96 112c-8.8 0-16 7.2-16 16l0 120 136 0 0-136-120 0z"]],
    "arrow-turn-left": [512, 512, [], "e632", ["", "M496 440c0 4.4 3.6 8 8 8s8-3.6 8-8l0-96c0-53-43-96-96-96L27.3 248 165.7 109.7c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0l-152 152c-3.1 3.1-3.1 8.2 0 11.3l152 152c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3L27.3 264 416 264c44.2 0 80 35.8 80 80l0 96z"]],
    "circle-4": [512, 512, [], "e0f1", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zm160-88c0-4.4 3.6-8 8-8s8 3.6 8 8l0 80c0 13.3 10.7 24 24 24l88 0 0-104c0-4.4 3.6-8 8-8s8 3.6 8 8l0 104 8 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-8 0 0 56c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-56-88 0c-22.1 0-40-17.9-40-40l0-80z", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM184 160c-4.4 0-8 3.6-8 8l0 80c0 22.1 17.9 40 40 40l88 0 0 56c0 4.4 3.6 8 8 8s8-3.6 8-8l0-56 8 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-8 0 0-104c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 104-88 0c-13.3 0-24-10.7-24-24l0-80c0-4.4-3.6-8-8-8z"]],
    "hammer-war": [448, 512, [], "f6e4", ["M16 68.9l0 198.2c0 9.7 8.6 17.2 18.3 15.8l187.5-26.8c1.5-.2 3-.2 4.5 0l187.5 26.8c9.6 1.4 18.3-6.1 18.3-15.8l0-198.2c0-9.7-8.6-17.2-18.3-15.8L226.3 79.8c-1.5 .2-3 .2-4.5 0L34.3 53.1C24.6 51.7 16 59.2 16 68.9z", "M192 59.4L192 32c0-17.7 14.3-32 32-32s32 14.3 32 32l0 27.4 155.5-22.2C430.8 34.5 448 49.4 448 68.9l0 198.2c0 19.5-17.2 34.4-36.5 31.7L256 276.6 256 512c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-235.4-155.5 22.2C17.2 301.5 0 286.6 0 267.1L0 68.9C0 49.4 17.2 34.5 36.5 37.2L192 59.4zm16 2.3l16 2.3 16-2.3 0-29.7c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 29.7zm18.3 194.4l187.5 26.8c9.6 1.4 18.3-6.1 18.3-15.8l0-198.2c0-9.7-8.6-17.2-18.3-15.8L226.3 79.8c-1.5 .2-3 .2-4.5 0L34.3 53.1C24.6 51.7 16 59.2 16 68.9l0 198.2c0 9.7 8.6 17.2 18.3 15.8l187.5-26.8c1.5-.2 3-.2 4.5 0zM208 512c0 8.8 7.2 16 16 16s16-7.2 16-16l0-237.7-16-2.3-16 2.3 0 237.7z"]],
    "light-emergency": [448, 512, [], "e41f", ["M16 368l0 64c0 17.7 14.3 32 32 32l352 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32L48 336c-17.7 0-32 14.3-32 32zM80 192l0 128 288 0 0-128c0-79.5-64.5-144-144-144S80 112.5 80 192zm48 8c0-57.4 46.6-104 104-104 4.4 0 8 3.6 8 8s-3.6 8-8 8c-48.6 0-88 39.4-88 88 0 4.4-3.6 8-8 8s-8-3.6-8-8z", "M400 320l-16 0 0-128c0-88.4-71.6-160-160-160S64 103.6 64 192l0 128-16 0c-26.5 0-48 21.5-48 48l0 64c0 26.5 21.5 48 48 48l352 0c26.5 0 48-21.5 48-48l0-64c0-26.5-21.5-48-48-48zM368 192l0 128-288 0 0-128c0-79.5 64.5-144 144-144s144 64.5 144 144zM48 336l352 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32L48 464c-17.7 0-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32zm96-136c0-48.6 39.4-88 88-88 4.4 0 8-3.6 8-8s-3.6-8-8-8c-57.4 0-104 46.6-104 104 0 4.4 3.6 8 8 8s8-3.6 8-8z"]],
    "arrow-up-z-a": [512, 512, ["sort-alpha-up-alt"], "f882", ["", "M312 32c-4.4 0-8 3.6-8 8s3.6 8 8 8l127.1 0-133.3 162.9c-2 2.4-2.4 5.7-1 8.5s4.1 4.6 7.2 4.6l144 0c4.4 0 8-3.6 8-8s-3.6-8-8-8L328.9 208 462.2 45.1c2-2.4 2.4-5.7 1-8.5S459.1 32 456 32L312 32zm79.2 260.4c-1.4-2.7-4.1-4.4-7.2-4.4s-5.8 1.7-7.2 4.4l-63.9 127.9-.1 .3-23.9 47.8c-2 4-.4 8.8 3.6 10.7s8.8 .4 10.7-3.6l21.8-43.6 118.1 0 21.8 43.6c2 4 6.8 5.6 10.7 3.6s5.6-6.8 3.6-10.7l-23.9-47.8-.1-.3-63.9-127.9zM384 313.9L435.1 416 332.9 416 384 313.9zM133.7 34.3c-3.1-3.1-8.2-3.1-11.3 0l-104 104c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L120 59.3 120 472c0 4.4 3.6 8 8 8s8-3.6 8-8l0-412.7 90.3 90.3c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-104-104z"]],
    "microphone-slash": [576, 512, [], "f131", ["M208 96l0 68.6 125.3 125.3C354.3 275.5 368 251.4 368 224l0-128c0-44.2-35.8-80-80-80s-80 35.8-80 80z", "M13.7-29.8c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l560 560c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3L413.1 369.7c41-35.2 66.9-87.4 66.9-145.7l0-56c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 56c0 53.8-24.2 102-62.3 134.3l-56.9-56.9C368.6 283.9 384 255.8 384 224l0-128c0-53-43-96-96-96s-96 43-96 96l0 52.6-178.3-178.3zM208 164.6L208 96c0-44.2 35.8-80 80-80s80 35.8 80 80l0 128c0 27.4-13.7 51.5-34.7 65.9L208 164.6zM343.8 391c-17.5 5.9-36.3 9-55.8 9-97.2 0-176-78.8-176-176l0-56c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 56c0 103.4 81.7 187.6 184 191.8l0 80.2-72 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l160 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-72 0 0-80.2c21.2-.9 41.4-5.2 60.3-12.3L343.8 391z"]],
    "square-pen": [448, 512, ["pen-square", "pencil-square"], "f14b", ["M16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96zM96.5 364l15-60.1c1.4-5.6 4.3-10.8 8.4-14.9L275.4 133.5c15.6-15.6 41-15.6 56.6 0l14.4 14.4c15.6 15.6 15.6 40.9 0 56.6L190.9 359.9c-4.1 4.1-9.2 7-14.9 8.4l-60.1 15c-5.5 1.4-11.2-.2-15.2-4.2s-5.6-9.7-4.2-15.2z", "M64 48C37.5 48 16 69.5 16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM100.7 379.2c-4-4-5.6-9.7-4.2-15.2l15-60.1c1.4-5.6 4.3-10.8 8.4-14.9L275.4 133.5c15.6-15.6 41-15.6 56.6 0l14.4 14.4c15.6 15.6 15.6 40.9 0 56.6L190.9 359.9c-4.1 4.1-9.2 7-14.9 8.4l-3.9-15.5c2.8-.7 5.4-2.2 7.4-4.2l118.9-118.9-48.3-48.3-118.9 118.9c-2.1 2.1-3.5 4.6-4.2 7.4-8.1 32.5-13.1 52.6-15 60.1 7.6-1.9 27.6-6.9 60.1-15l3.9 15.5-60.1 15c-5.5 1.4-11.2-.2-15.2-4.2zM335 193.1c9.4-9.4 9.4-24.6 0-33.9l-14.4-14.4c-9.4-9.4-24.6-9.4-33.9 0l-25.3 25.3 48.3 48.3 25.3-25.3z"]],
    "bell-plus": [448, 512, [], "f849", ["M16 379.2c0 11.5 9.3 20.8 20.8 20.8l374.3 0c11.5 0 20.8-9.3 20.8-20.8 0-4.1-1.2-8.1-3.5-11.6L405.4 333C381 296.4 368 253.4 368 209.4l0-17.4c0-79.5-64.5-144-144-144S80 112.5 80 192l0 17.4c0 44-13 87-37.4 123.6L19.5 367.6C17.2 371 16 375 16 379.2zM136 224c0-4.4 3.6-8 8-8l72 0 0-72c0-4.4 3.6-8 8-8s8 3.6 8 8l0 72 72 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-72 0 0 72c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-72-72 0c-4.4 0-8-3.6-8-8z", "M216 8c0-4.4 3.6-8 8-8s8 3.6 8 8l0 24.2c84.6 4.2 152 74.1 152 159.8l0 17.4c0 40.8 12.1 80.8 34.8 114.8l23.1 34.6c4 6.1 6.2 13.2 6.2 20.4 0 20.3-16.5 36.8-36.8 36.8L36.8 416c-20.3 0-36.8-16.5-36.8-36.8 0-7.3 2.2-14.4 6.2-20.4l23.1-34.6C51.9 290.1 64 250.2 64 209.4L64 192c0-85.7 67.4-155.6 152-159.8L216 8zM80 209.4c0 44-13 87-37.4 123.6L19.5 367.6C17.2 371 16 375 16 379.2 16 390.7 25.3 400 36.8 400l374.3 0c11.5 0 20.8-9.3 20.8-20.8 0-4.1-1.2-8.1-3.5-11.6L405.4 333C381 296.4 368 253.4 368 209.4l0-17.4c0-79.5-64.5-144-144-144S80 112.5 80 192l0 17.4zM224 512c-31.3 0-58-20-67.9-48l17.3 0c9 18.9 28.3 32 50.6 32s41.6-13.1 50.6-32l17.3 0c-9.9 28-36.6 48-67.9 48zm0-376c4.4 0 8 3.6 8 8l0 72 72 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-72 0 0 72c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-72-72 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l72 0 0-72c0-4.4 3.6-8 8-8z"]],
    "hand-fist": [384, 512, [9994, "fist-raised"], "f6de", ["M16.1 284.4C18 246.3 49.5 216 88 216l80 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-64 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l64 0c26.5 0 48-21.5 48-48 0-15.1-7-28.6-17.9-37.4 5.9-3.1 11.1-7.4 15.3-12.5 8 15.4 24.1 25.9 42.6 25.9 13.8 0 26.3-5.8 35-15.2 6.8 18.2 24.4 31.2 45 31.2 12.3 0 23.5-4.6 32-12.2l0 36.2c0 41.3-20.9 77.8-52.7 99.4-6.6 4.5-11.3 12.1-11.3 20.8L304 504c0 4.4 3.6 8 8 8l-208 0c4.4 0 8-3.6 8-8l0-99.3c0-12.1-8.9-21.5-19.5-24.4-42.8-11.7-74.5-50-76.4-96zM64 80c0-17.7 14.3-32 32-32s32 14.3 32 32l0 106.3c0 5-1.1 9.6-3 13.7l-37 0c-6.8 0-13.4 .8-19.8 2.2-2.7-4.8-4.2-10.2-4.2-15.9L64 80zm80-32c0-17.7 14.3-32 32-32s32 14.3 32 32l0 120c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-120zm80 32c0-17.7 14.3-32 32-32s32 14.3 32 32l0 96c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-96zm80 32c0-17.7 14.3-32 32-32s32 14.3 32 32l0 80c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-80z", "M208 48c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 120c0 17.7 14.3 32 32 32s32-14.3 32-32l0-120zM176 0c25.3 0 46 19.5 47.9 44.3 8.5-7.7 19.8-12.3 32.1-12.3 25.3 0 46 19.5 47.9 44.3 8.5-7.7 19.8-12.3 32.1-12.3 26.5 0 48 21.5 48 48l0 80c0 1.9-.1 3.8-.3 5.7 .2 .7 .3 1.5 .3 2.3l0 64c0 46.8-23.7 88.1-59.7 112.6-2.8 1.9-4.3 4.8-4.3 7.5L320 504c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-119.9c0-8.7 4.7-16.2 11.3-20.8 31.8-21.6 52.7-58 52.7-99.4l0-36.2c-8.5 7.6-19.7 12.2-32 12.2-20.6 0-38.2-13-45-31.2-8.8 9.3-21.2 15.2-35 15.2-18.5 0-34.6-10.5-42.6-25.9-4.2 5.2-9.4 9.4-15.3 12.5 10.9 8.8 17.9 22.3 17.9 37.4 0 26.5-21.5 48-48 48l-64 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l64 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-80 0c-38.5 0-70 30.3-71.9 68.4 1.9 46 33.7 84.3 76.4 96 10.6 2.9 19.5 12.3 19.5 24.4l0 99.3c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-99.3c0-3.8-2.9-7.7-7.7-9-47.6-13-83.4-54.5-87.8-105.1-.3-.8-.5-1.8-.5-2.7 0-1.2 0-2.5 .1-3.7-.1-1.4-.1-2.9-.1-4.3 0-1.2 .3-2.3 .7-3.3 4-31.2 24.3-57.2 52.1-69.4-3.1-6.4-4.8-13.6-4.8-21L48 80C48 53.5 69.5 32 96 32 108.4 32 119.6 36.7 128.1 44.3 130 19.5 150.7 0 176 0zM68.2 202.2c6.4-1.5 13-2.2 19.8-2.2l37 0c1.9-4.1 3-8.7 3-13.7L128 80c0-17.7-14.3-32-32-32S64 62.3 64 80l0 106.3c0 5.7 1.5 11.1 4.2 15.9zM288 176l0-96c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 96c0 17.7 14.3 32 32 32s32-14.3 32-32zm16-64l0 80c0 17.7 14.3 32 32 32s32-14.3 32-32l0-80c0-17.7-14.3-32-32-32s-32 14.3-32 32z"]],
    "pants": [512, 512, [], "e6d5", ["M25 466.9c-3.2 17.4 8.3 34.1 25.7 37.3l87.8 16.1c16.9 3.1 33.3-7.7 37-24.5l73.1-329.5c.8-3.7 4.1-6.3 7.8-6.3s7 2.6 7.8 6.3l73.1 329.5c3.7 16.8 20.1 27.6 37 24.5l87.8-16.1c17.4-3.2 28.9-19.9 25.7-37.3l-66.1-354.9-61.3 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l58.3 0-10-53.9C405.9 27 392.7 16 377.2 16L135.6 16c-15.4 0-28.6 11-31.5 26.1l-10 53.9 58.3 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L91.1 112 25 466.9z", "M88.4 39.2C92.6 16.5 112.4 0 135.6 0L377.2 0c23.1 0 43 16.5 47.2 39.2L503.5 464c4.9 26.1-12.4 51.2-38.6 56L377.2 536c-25.4 4.6-49.9-11.6-55.5-36.8l-65.3-294.3-65.3 294.3c-5.6 25.2-30.1 41.5-55.5 36.8L47.9 520c-26.1-4.8-43.4-29.9-38.5-56L88.4 39.2zM135.6 16c-15.4 0-28.6 11-31.5 26.1l-10 53.9 58.3 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L91.1 112 25 466.9c-3.2 17.4 8.3 34.1 25.7 37.3l87.8 16.1c16.9 3.1 33.3-7.7 37-24.5l73.1-329.5c.8-3.7 4.1-6.3 7.8-6.3s7 2.6 7.8 6.3l73.1 329.5c3.7 16.8 20.1 27.6 37 24.5l87.8-16.1c17.4-3.2 28.9-19.9 25.7-37.3l-66.1-354.9-61.3 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l58.3 0-10-53.9C405.9 27 392.7 16 377.2 16L135.6 16z"]],
    "comment-sms": [512, 512, ["sms"], "f7cd", ["M16 240c0 51.7 18.8 99.4 50.5 137.4 4.1 4.9 4.9 11.7 2 17.4l-49.4 98.7 124.8-49.9c3.9-1.6 8.3-1.5 12.2 .1 30.4 13 64.2 20.2 99.9 20.2 133.5 0 240-101.2 240-224S389.5 16 256 16 16 117.2 16 240zm72-32c0-22.1 17.9-40 40-40l24 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-24 0c-13.3 0-24 10.7-24 24s10.7 24 24 24c22.1 0 40 17.9 40 40s-17.9 40-40 40l-32 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l32 0c13.3 0 24-10.7 24-24s-10.7-24-24-24c-22.1 0-40-17.9-40-40zm112-32c0-3.6 2.4-6.7 5.9-7.7s7.1 .5 9 3.6l41.1 68.6 41.1-68.6c1.8-3.1 5.5-4.6 9-3.6s5.9 4.1 5.9 7.7l0 128c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-99.1-33.1 55.2c-1.4 2.4-4.1 3.9-6.9 3.9s-5.4-1.5-6.9-3.9L216 204.9 216 304c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-128zm144 32c0-22.1 17.9-40 40-40l24 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-24 0c-13.3 0-24 10.7-24 24s10.7 24 24 24c22.1 0 40 17.9 40 40s-17.9 40-40 40l-32 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l32 0c13.3 0 24-10.7 24-24s-10.7-24-24-24c-22.1 0-40-17.9-40-40z", "M68.5 394.8c2.8-5.7 2-12.5-2-17.4-31.7-38-50.5-85.7-50.5-137.4 0-122.8 106.5-224 240-224S496 117.2 496 240 389.5 464 256 464c-35.7 0-69.5-7.3-99.9-20.2-3.9-1.7-8.3-1.7-12.2-.1L19.1 493.5 68.5 394.8zM0 240c0 55.7 20.2 106.9 54.2 147.7L1.4 493.3C-4 504 7.6 515.4 18.4 511l131.5-52.6c32.3 13.8 68.3 21.5 106.2 21.5 141.4 0 256-107.5 256-240S397.4 0 256 0 0 107.5 0 240zm128-72c-22.1 0-40 17.9-40 40s17.9 40 40 40c13.3 0 24 10.7 24 24s-10.7 24-24 24l-32 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l32 0c22.1 0 40-17.9 40-40s-17.9-40-40-40c-13.3 0-24-10.7-24-24s10.7-24 24-24l24 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-24 0zm216 40c0 22.1 17.9 40 40 40 13.3 0 24 10.7 24 24s-10.7 24-24 24l-32 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l32 0c22.1 0 40-17.9 40-40s-17.9-40-40-40c-13.3 0-24-10.7-24-24s10.7-24 24-24l24 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-24 0c-22.1 0-40 17.9-40 40zM214.9 171.9c-1.8-3.1-5.5-4.6-9-3.6s-5.9 4.1-5.9 7.7l0 128c0 4.4 3.6 8 8 8s8-3.6 8-8l0-99.1 33.1 55.2c1.4 2.4 4 3.9 6.9 3.9s5.4-1.5 6.9-3.9l33.1-55.2 0 99.1c0 4.4 3.6 8 8 8s8-3.6 8-8l0-128c0-3.6-2.4-6.7-5.9-7.7s-7.1 .5-9 3.6l-41.1 68.6-41.1-68.6z"]],
    "head-side-gear": [512, 512, [], "e611", ["M16 216c0-110.5 89.5-200 200-200 101.8 0 185.8 76 198.4 174.4 .1 1.1 .3 2.2 .4 3.3 .2 1.7 .9 3.3 2.1 4.5l54.7 59.7c5.5 6 8.5 13.8 8.5 21.8 0 17.8-14.5 32.3-32.3 32.3L416 312c-4.4 0-8 3.6-8 8l0 56c0 30.9-25.1 56-56 56l-40 0c-4.4 0-8 3.6-8 8l0 64c0 4.4 3.6 8 8 8L88 512c4.4 0 8-3.6 8-8l0-124c0-2.5-1.1-4.8-3.1-6.3-1.7-1.3-3.3-2.6-4.9-4-22-18.3-40-41.3-52.5-67.4-6.3-13.1-11.1-26.9-14.4-41.3-1.7-7.2-2.9-14.6-3.8-22.1-.4-3.7-.7-7.5-1-11.3S16 219.9 16 216zm88.9-56.1c-5 8.9-2.1 20.2 6.6 25.7l3.6 2.3c6.4 4 9.7 11.4 9.6 19l0 1.2 0 1.1c.1 7.6-3.2 15-9.7 19l-3.5 2.2c-8.7 5.4-11.6 16.7-6.6 25.7l18 32.3c5.2 9.4 17.1 12.6 26.4 7.3l3.8-2.2c6.6-3.8 14.7-3.2 21.3 .6s11.3 10.5 11.3 18.2l0 4.7c0 10.6 8.6 19.2 19.2 19.2l38.4 0c10.6 0 19.2-8.6 19.2-19.2l0-4.9c0-7.6 4.6-14.2 11.2-18 6.6-3.8 14.6-4.5 21.2-.7l4 2.3c9.3 5.4 21.2 2.1 26.4-7.3l17.9-32.3c5-8.9 2-20.2-6.6-25.6l-3.7-2.3c-6.4-4-9.7-11.4-9.6-18.9l0-1 0-1.1c-.1-7.5 3.2-14.9 9.6-18.9l3.8-2.3c8.7-5.4 11.6-16.7 6.6-25.6l-17.9-32.2c-5.2-9.4-17.1-12.7-26.4-7.3l-4 2.3c-6.6 3.8-14.6 3.1-21.2-.7-6.5-3.8-11.2-10.5-11.2-18l0-4.9c0-10.6-8.6-19.2-19.2-19.2l-38.4 0c-10.6 0-19.2 8.6-19.2 19.2l0 4.7c0 7.6-4.7 14.3-11.3 18.2s-14.7 4.4-21.3 .6l-3.8-2.2c-9.3-5.4-21.1-2.1-26.4 7.3l-18 32.2zm143.1 48a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M16 216c0-110.5 89.5-200 200-200 102.9 0 187.7 77.7 198.8 177.7 .2 1.7 .9 3.3 2.1 4.5l54.7 59.7c5.5 6 8.5 13.8 8.5 21.8 0 17.8-14.5 32.3-32.3 32.3L416 312c-4.4 0-8 3.6-8 8l0 56c0 30.9-25.1 56-56 56l-40 0c-4.4 0-8 3.6-8 8l0 64c0 4.4 3.6 8 8 8s8-3.6 8-8l0-56 32 0c39.8 0 72-32.2 72-72l0-48 23.7 0c26.7 0 48.3-21.6 48.3-48.3 0-12.1-4.5-23.7-12.7-32.6l-52.9-57.7C417.2 82.6 326.2 0 216 0 96.7 0 0 96.7 0 216 0 283.7 31.2 344.2 80 383.8L80 504c0 4.4 3.6 8 8 8s8-3.6 8-8l0-124c0-2.5-1.1-4.8-3.1-6.3-46.8-36.6-76.9-93.6-76.9-157.7zM243.3 95.9c1.8 0 3.2 1.4 3.2 3.2l0 4.9c0 14.4 8.7 25.8 19.2 31.9 10.5 6.1 24.8 7.8 37.2 .7l4-2.3c1.5-.9 3.5-.3 4.4 1.2l17.9 32.2c.8 1.5 .3 3.4-1.1 4.3l-3.8 2.3c-12 7.5-17.3 20.7-17.1 32.7l0 .9 0 .9c-.1 12 5.1 25.2 17.2 32.7l3.7 2.3c1.4 .9 1.9 2.8 1.1 4.3l-17.9 32.3c-.9 1.6-2.8 2.1-4.4 1.2l-4-2.3c-12.4-7.2-26.7-5.4-37.2 .7-10.4 6.1-19.2 17.5-19.2 31.9l0 4.9c0 1.8-1.4 3.2-3.2 3.2l-38.4 0c-1.8 0-3.2-1.4-3.2-3.2l0-4.7c0-14.4-8.8-25.9-19.3-32-10.6-6.1-24.8-7.8-37.3-.6l-3.8 2.2c-1.5 .9-3.5 .3-4.4-1.2l-18-32.3c-.8-1.5-.3-3.4 1.1-4.3l3.5-2.2c12.1-7.5 17.4-20.7 17.2-32.7l0-.9 0-1c.1-12-5.1-25.2-17.2-32.7l-3.6-2.3c-1.5-.9-1.9-2.8-1.1-4.3l18-32.2c.9-1.6 2.8-2.1 4.4-1.2l3.8 2.2c12.4 7.2 26.7 5.5 37.3-.7 10.5-6.1 19.3-17.6 19.3-32l0-4.7c0-1.8 1.4-3.2 3.2-3.2l38.4 0zm-38.4-16c-10.6 0-19.2 8.6-19.2 19.2l0 4.7c0 7.6-4.7 14.3-11.3 18.2s-14.7 4.4-21.3 .6l-3.8-2.2c-9.3-5.4-21.1-2.1-26.4 7.3l-18 32.2c-5 8.9-2.1 20.2 6.6 25.7l3.6 2.3c6.4 4 9.7 11.4 9.6 19l0 1.2 0 1.1c.1 7.6-3.2 15-9.7 19l-3.5 2.2c-8.7 5.4-11.6 16.7-6.6 25.7l18 32.3c5.2 9.4 17.1 12.6 26.4 7.3l3.8-2.2c6.6-3.8 14.7-3.2 21.3 .6s11.3 10.5 11.3 18.2l0 4.7c0 10.6 8.6 19.2 19.2 19.2l38.4 0c10.6 0 19.2-8.6 19.2-19.2l0-4.9c0-7.6 4.6-14.2 11.2-18 6.6-3.8 14.6-4.5 21.2-.7l4 2.3c9.3 5.4 21.2 2.1 26.4-7.3l17.9-32.3c5-8.9 2-20.2-6.6-25.6l-3.7-2.3c-6.4-4-9.7-11.4-9.6-18.9l0-1 0-1.1c-.1-7.5 3.2-14.9 9.6-18.9l3.8-2.3c8.7-5.4 11.6-16.7 6.6-25.6l-17.9-32.2c-5.2-9.4-17.1-12.7-26.4-7.3l-4 2.3c-6.6 3.8-14.6 3.1-21.2-.7-6.5-3.8-11.2-10.5-11.2-18l0-4.9c0-10.6-8.6-19.2-19.2-19.2l-38.4 0zM224 231.8a24 24 0 1 1 0-48 24 24 0 1 1 0 48zm-40-24a40 40 0 1 0 80 0 40 40 0 1 0 -80 0z"]],
    "transporter-1": [576, 512, [], "e043", ["M130.8 271l64.1-93.8c21-30.8 55.9-49.1 93.1-49.1s72.1 18.4 93.1 49.1L445.2 271c5 7.3 3.1 17.3-4.2 22.2s-17.3 3.1-22.2-4.2l-52.2-76.4c-2-2.9-5.6-4.2-9-3.1s-5.6 4.1-5.6 7.6l0 102.8-128 0 0-102.8c0-3.5-2.3-6.6-5.6-7.6s-7 .2-9 3.1L157.2 289c-5 7.3-14.9 9.2-22.2 4.2s-9.2-14.9-4.2-22.2zM328 24a40 40 0 1 1 -80 0 40 40 0 1 1 80 0z", "M248 24a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zm96 0a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zM194.9 177.1c21-30.8 55.9-49.1 93.1-49.1s72.1 18.4 93.1 49.1L445.2 271c5 7.3 3.1 17.3-4.2 22.2s-17.3 3.1-22.2-4.2l-52.2-76.4c-2-2.9-5.6-4.2-9-3.1s-5.6 4.1-5.6 7.6l0 102.8 16 0 0-76.9 37.6 55c10 14.6 29.9 18.3 44.5 8.4s18.3-29.9 8.4-44.5l-64.1-93.8C370.3 133 330.5 112 288 112s-82.3 21-106.3 56.1l-64.1 93.8c-10 14.6-6.2 34.5 8.4 44.5s34.5 6.2 44.5-8.4l37.6-55 0 76.9 16 0 0-102.8c0-3.5-2.3-6.6-5.6-7.6s-7 .2-9 3.1L157.2 289c-5 7.3-14.9 9.2-22.2 4.2s-9.2-14.9-4.2-22.2l64.1-93.8zM136 528c-4.4 0-8 3.6-8 8s3.6 8 8 8l304 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-304 0zM528 128c-4.4 0-8 3.6-8 8l0 32-32 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l32 0 0 32c0 4.4 3.6 8 8 8s8-3.6 8-8l0-32 32 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-32 0 0-32c0-4.4-3.6-8-8-8zM48 320c-4.4 0-8 3.6-8 8l0 32-32 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l32 0 0 32c0 4.4 3.6 8 8 8s8-3.6 8-8l0-32 32 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-32 0 0-32c0-4.4-3.6-8-8-8zm152 64c-4.4 0-8 3.6-8 8s3.6 8 8 8l176 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-176 0zm0 64c-4.4 0-8 3.6-8 8s3.6 8 8 8l176 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-176 0z"]],
    "scanner-touchscreen": [512, 512, [], "f48a", ["M16 160l0 288c0 26.5 21.5 48 48 48l192 0c26.5 0 48-21.5 48-48l0-288c0-26.5-21.5-48-48-48L64 112c-26.5 0-48 21.5-48 48zm48 24c0-13.3 10.7-24 24-24l144 0c13.3 0 24 10.7 24 24l0 240c0 13.3-10.7 24-24 24L88 448c-13.3 0-24-10.7-24-24l0-240zm16 0l0 240c0 4.4 3.6 8 8 8l144 0c4.4 0 8-3.6 8-8l0-240c0-4.4-3.6-8-8-8L88 176c-4.4 0-8 3.6-8 8z", "M152 0c-4.4 0-8 3.6-8 8l0 40 16 0 0-40c0-4.4-3.6-8-8-8zM320 8c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 50.8c5.6 2.7 11 5.8 16 9.3L320 8zM256 8c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 40 16 0 0-40zM208 8c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 40 16 0 0-40zM392 0c-4.4 0-8 3.6-8 8l0 240c0 4.4 3.6 8 8 8s8-3.6 8-8L400 8c0-4.4-3.6-8-8-8zm40 8l0 240c0 4.4 3.6 8 8 8s8-3.6 8-8L448 8c0-4.4-3.6-8-8-8s-8 3.6-8 8zm72-8c-4.4 0-8 3.6-8 8l0 240c0 4.4 3.6 8 8 8s8-3.6 8-8L512 8c0-4.4-3.6-8-8-8zM304 160l0 288c0 26.5-21.5 48-48 48L64 496c-26.5 0-48-21.5-48-48l0-288c0-26.5 21.5-48 48-48l192 0c26.5 0 48 21.5 48 48zM64 96C28.7 96 0 124.7 0 160L0 448c0 35.3 28.7 64 64 64l192 0c35.3 0 64-28.7 64-64l0-288c0-35.3-28.7-64-64-64L64 96zm176 88l0 240c0 4.4-3.6 8-8 8L88 432c-4.4 0-8-3.6-8-8l0-240c0-4.4 3.6-8 8-8l144 0c4.4 0 8 3.6 8 8zM88 160c-13.3 0-24 10.7-24 24l0 240c0 13.3 10.7 24 24 24l144 0c13.3 0 24-10.7 24-24l0-240c0-13.3-10.7-24-24-24L88 160z"]],
    "flask-round-potion": [384, 512, ["flask-potion"], "f6e1", ["M16.2 329.3l4-2.5 27.4-17.1c21.4-13.4 46-20.8 71.2-21.7 1.5 0 2.9 0 4.4 0l1.6 0c31.3 0 61.8 10.7 86.2 30.2 27.3 21.8 61.2 33.8 96.2 33.8l57.9 0c-15 81.9-86.8 144-173.1 144-94.1 0-170.9-73.8-175.8-166.7z", "M88 16l24 0 0 129.4C45.9 175.7 0 242.5 0 320 0 426 86 512 192 512s192-86 192-192c0-77.5-45.9-144.3-112-174.6l0-129.4 24 0c4.4 0 8-3.6 8-8s-3.6-8-8-8L88 0c-4.4 0-8 3.6-8 8s3.6 8 8 8zm40 134.6l0-134.6 128 0 0 134.6c0 3.2 1.9 6.1 4.9 7.4 63 26.8 107.1 89.3 107.1 162 0 5.4-.2 10.7-.7 16l-60.1 0c-31.3 0-61.8-10.7-86.2-30.2-27.3-21.8-61.2-33.8-96.2-33.8l-1.6 0c-29.7 0-58.8 8.4-84 24.1L16.3 310.4c3.7-68.6 46.7-126.8 106.9-152.4 3-1.3 4.9-4.2 4.9-7.4zM16.2 329.3l4-2.5 27.4-17.1C70.3 295.5 96.5 288 123.2 288l1.6 0c31.3 0 61.8 10.7 86.2 30.2 27.3 21.8 61.2 33.8 96.2 33.8l57.9 0c-15 81.9-86.8 144-173.1 144-94.1 0-170.9-73.8-175.8-166.7z"]],
    "car-bolt": [512, 512, [], "e341", ["M16 256l0 128 480 0 0-128c0-26.5-21.5-48-48-48l-66 0c-.7-2.9-1.7-5.7-2.8-8.5-1.1-2.6-2.3-5.1-3.7-7.5l52.4 0c-3.8-.5-7.8-.8-11.7-.8l-180 0-24.8 24.8 108.7 0c3.2 0 6.2 1.9 7.4 4.9s.6 6.4-1.7 8.7l-96 96c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3L300.7 232 192 232c-3.2 0-6.2-1.9-7.4-4.9s-.6-6.4 1.7-8.7l27.1-27.1-117.8 0c-4 0-7.9 .3-11.7 .8l52.7 0c-2.9 5-5.1 10.4-6.5 16l-66 0c-26.5 0-48 21.5-48 48zm112 32a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm320 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M99.3 93.3L59.8 192.1c1.4-.1 2.8-.1 4.2-.1l72.6 0c-2.9 5-5.1 10.4-6.5 16l-66 0c-26.5 0-48 21.5-48 48l0 128 480 0 0-128c0-26.5-21.5-48-48-48l-66 0c-.7-2.9-1.7-5.7-2.8-8.5-1.1-2.6-2.3-5.1-3.7-7.5l72.6 0c1.4 0 2.8 0 4.2 .1L412.7 93.3C401.8 65.9 375.3 48 345.8 48L166.2 48c-29.4 0-55.9 17.9-66.9 45.3zM40.9 196.3l43.6-109C97.8 53.9 130.2 32 166.2 32l179.7 0c36 0 68.3 21.9 81.7 55.3l43.6 109C495 205.6 512 228.8 512 256l0 192c0 17.7-14.3 32-32 32l-16 0c-17.7 0-32-14.3-32-32l0-48-352 0 0 48c0 17.7-14.3 32-32 32l-16 0c-17.7 0-32-14.3-32-32L0 256c0-27.2 17-50.4 40.9-59.7zM448 400l0 48c0 8.8 7.2 16 16 16l16 0c8.8 0 16-7.2 16-16l0-48-48 0zM16 400l0 48c0 8.8 7.2 16 16 16l16 0c8.8 0 16-7.2 16-16l0-48-48 0zm96-112a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm-48 0a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm352 16a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm0-48a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM293.7 133.7L211.3 216 320 216c3.2 0 6.2 1.9 7.4 4.9s.6 6.4-1.7 8.7l-96 96c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3L300.7 232 192 232c-3.2 0-6.2-1.9-7.4-4.9s-.6-6.4 1.7-8.7l96-96c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3z"]],
    "table-rows": [448, 512, ["rows"], "e292", ["M144 48l0 200 288 0 0-152c0-26.5-21.5-48-48-48L144 48zm0 216l0 200 240 0c26.5 0 48-21.5 48-48l0-152-288 0z", "M16 96c0-26.5 21.5-48 48-48l64 0 0 416-64 0c-26.5 0-48-21.5-48-48L16 96zM384 464l-240 0 0-200 288 0 0 152c0 26.5-21.5 48-48 48zm48-216l-288 0 0-200 240 0c26.5 0 48 21.5 48 48l0 152zM0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416z"]],
    "cloud-slash": [576, 512, [], "e137", ["M139.8 96.3c23.5-29.4 59.6-48.3 100.2-48.3 52.2 0 97.1 31.2 117 76 1 2.2 2.9 3.9 5.2 4.5s4.8 .2 6.8-1.3c13.2-9.6 29.4-15.2 47-15.2 44.2 0 80 35.8 80 80 0 15.9-4.7 30.8-12.7 43.2-1.3 2-1.6 4.6-.9 6.8s2.5 4.1 4.8 5c42.5 15.9 72.8 56.9 72.8 104.9 0 44.5-25.9 82.9-63.5 101L139.8 96.3z", "M13.7-29.8C10.5-33 5.5-33 2.3-29.8s-3.1 8.2 0 11.3l560 560c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-65.3-65.3c40.2-21.6 67.6-64 67.6-112.9 0-51.6-30.5-96.1-74.5-116.3 6.7-13.1 10.5-28 10.5-43.7 0-53-43-96-96-96-17.7 0-34.2 4.8-48.4 13.1-24.1-45.8-72.2-77.1-127.6-77.1-45 0-85.2 20.6-111.6 52.9L13.7-29.8zM139.8 96.3c23.5-29.4 59.6-48.3 100.2-48.3 52.2 0 97.1 31.2 117 76 1 2.2 2.9 3.9 5.2 4.5s4.8 .2 6.8-1.3c13.2-9.6 29.4-15.2 47-15.2 44.2 0 80 35.8 80 80 0 15.9-4.7 30.8-12.7 43.2-1.3 2-1.6 4.6-.9 6.8s2.5 4.1 4.8 5c42.5 15.9 72.8 56.9 72.8 104.9 0 44.5-25.9 82.9-63.5 101L139.8 96.3zM416.8 464L144 464c-70.7 0-128-57.3-128-128 0-58.6 39.5-108.1 93.3-123.2 4.1-1.1 6.6-5.3 5.7-9.4-1.9-8.8-2.9-18-2.9-27.4 0-5.4 .3-10.6 1-15.8L99.1 146.3c-2 9.6-3.1 19.5-3.1 29.7 0 8 .7 15.9 1.9 23.5-56.9 19.2-97.9 73-97.9 136.5 0 79.5 64.5 144 144 144l288.8 0-16-16z"]],
    "face-hand-yawn": [512, 512, [], "e379", ["M16 256c0 54 17.9 103.9 48 144l0 25.3c16.2 18.3 34.9 34.3 55.7 47.4-5-12.7-7.7-26.4-7.7-40.9l0-100.4c0-18 14.6-32.5 32.5-32.5 5.8 0 11.2 1.5 15.9 3.9 1.6-16.7 7.4-32.1 16.4-45.1-2.5-1.1-5.1-2.1-7.7-2.9 18.6-28.2 50.6-46.7 86.8-46.7 34.2 0 64.6 16.5 83.5 42-3.4-.2-6.8-.1-10.1 .1 12 14.2 19.9 31.9 22 51.4 4.2 1.9 8.1 4.5 11.5 8 15.4 15.4 15.4 40.3 0 55.6l-10.1 10.1c7.8 1.2 15.2 4.9 21.2 10.8 15.1 15.1 15.1 39.5 0 54.6l-66.2 66.2c45-9.3 85.7-30.3 118.7-59.8 3.9-9.4 6.1-19.2 6.7-29.1 39-42.7 62.8-99.5 62.8-161.9 0-132.5-107.5-240-240-240S16 123.5 16 256zm105.6-59.2c-2.7-3.5-1.9-8.5 1.6-11.2l64-48c3.5-2.7 8.5-1.9 11.2 1.6s1.9 8.5-1.6 11.2l-64 48c-3.5 2.7-8.5 1.9-11.2-1.6zm192-57.6c2.6-3.5 7.7-4.3 11.2-1.6l64 48c3.5 2.7 4.2 7.7 1.6 11.2s-7.7 4.3-11.2 1.6l-64-48c-3.5-2.7-4.2-7.7-1.6-11.2z", "M16 256C16 123.5 123.5 16 256 16S496 123.5 496 256c0 62.4-23.8 119.2-62.8 161.9-.5 9.9-2.7 19.8-6.7 29.1 52.4-46.9 85.5-115 85.5-190.9 0-141.4-114.6-256-256-256S0 114.6 0 256c0 64.9 24.2 124.2 64 169.3L64 400c-30.1-40.1-48-90-48-144zm240-48c-36.3 0-68.2 18.6-86.8 46.7 5.2 1.7 10.2 3.9 14.9 6.5 15.9-22.5 42.2-37.3 71.9-37.3 25.1 0 47.7 10.5 63.7 27.3 6.6-1.2 13.2-1.6 19.8-1.3-19-25.5-49.3-42-83.5-42zm46.8 74c-15.1-15.1-39.5-15.1-54.6 0l-71.1 71.1 0-21.6c0-18-14.6-32.5-32.5-32.5S112 313.5 112 331.5l0 100.4c0 61.9 50.2 112.1 112.1 112.1 29.7 0 58.3-11.8 79.3-32.8L374 440.6c15.1-15.1 15.1-39.5 0-54.6-6-6-13.4-9.6-21.2-10.8L362.9 365c15.4-15.4 15.4-40.3 0-55.6-13.4-13.4-33.9-15.1-49.2-5.2-1.1-8.1-4.7-16-11-22.2zm27.9 115.3l0 0c8.8-8.8 23.2-8.8 32 0s8.8 23.2 0 32l-70.6 70.6c-18 18-42.5 28.2-68 28.2-53.1 0-96.1-43-96.1-96.1l0-100.4c0-9.1 7.4-16.5 16.5-16.5s16.5 7.4 16.5 16.5l0 31c0 10.8 13 16.2 20.6 8.6l77.7-77.7c8.8-8.8 23.2-8.8 32 0s8.8 23.1 0 32l0 0-52 52c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l52-52 0 0 15.8-15.8c9.1-9.1 23.9-9.1 33 0s9.1 23.9 0 33c-20.9 20.9-43.5 43.5-67.8 67.9-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l35.6-35.6zM198.4 139.2c-2.7-3.5-7.7-4.3-11.2-1.6l-64 48c-3.5 2.7-4.3 7.7-1.6 11.2s7.7 4.3 11.2 1.6l64-48c3.5-2.7 4.3-7.7 1.6-11.2zm116.8 11.2l64 48c3.5 2.7 8.6 1.9 11.2-1.6s1.9-8.5-1.6-11.2l-64-48c-3.5-2.7-8.6-1.9-11.2 1.6s-1.9 8.5 1.6 11.2z"]],
    "tickets": [640, 512, [], "e658", ["M112 96l0 50c27.6 7.1 48 32.2 48 62s-20.4 54.9-48 62l0 50c0 26.5 21.5 48 48 48l384 0c26.5 0 48-21.5 48-48l0-50c-27.6-7.1-48-32.2-48-62s20.4-54.9 48-62l0-50c0-26.5-21.5-48-48-48L160 48c-26.5 0-48 21.5-48 48zm112 72c0-22.1 17.9-40 40-40l176 0c22.1 0 40 17.9 40 40l0 80c0 22.1-17.9 40-40 40l-176 0c-22.1 0-40-17.9-40-40l0-80zm16 0l0 80c0 13.3 10.7 24 24 24l176 0c13.3 0 24-10.7 24-24l0-80c0-13.3-10.7-24-24-24l-176 0c-13.3 0-24 10.7-24 24z", "M96 96c0-35.3 28.7-64 64-64l384 0c35.3 0 64 28.7 64 64l0 56.6c0 4-2.9 7.4-6.9 7.9-23.3 3.3-41.1 23.3-41.1 47.5s17.9 44.2 41.1 47.5c3.9 .6 6.9 3.9 6.9 7.9l0 56.6c0 35.3-28.7 64-64 64l-384 0c-35.3 0-64-28.7-64-64l0-56.6c0-4 2.9-7.4 6.9-7.9 23.3-3.3 41.1-23.3 41.1-47.5s-17.9-44.2-41.1-47.5c-3.9-.6-6.9-3.9-6.9-7.9L96 96zm64-48c-26.5 0-48 21.5-48 48l0 50c27.6 7.1 48 32.2 48 62s-20.4 54.9-48 62l0 50c0 26.5 21.5 48 48 48l384 0c26.5 0 48-21.5 48-48l0-50c-27.6-7.1-48-32.2-48-62s20.4-54.9 48-62l0-50c0-26.5-21.5-48-48-48L160 48zM8 128c4.4 0 8 3.6 8 8l0 296c0 17.7 14.3 32 32 32l456 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L48 480c-26.5 0-48-21.5-48-48L0 136c0-4.4 3.6-8 8-8zm256 16c-13.3 0-24 10.7-24 24l0 80c0 13.3 10.7 24 24 24l176 0c13.3 0 24-10.7 24-24l0-80c0-13.3-10.7-24-24-24l-176 0zm-40 24c0-22.1 17.9-40 40-40l176 0c22.1 0 40 17.9 40 40l0 80c0 22.1-17.9 40-40 40l-176 0c-22.1 0-40-17.9-40-40l0-80z"]],
    "sim-card": [384, 512, [], "f7c4", ["M16 64c0-26.5 21.5-48 48-48l194.7 0c12.7 0 24.9 5.1 33.9 14.1l61.3 61.3c9 9 14.1 21.2 14.1 33.9L368 448c0 26.5-21.5 48-48 48L64 496c-26.5 0-48-21.5-48-48L16 64zM64 288l0 128c0 17.7 14.3 32 32 32l192 0c17.7 0 32-14.3 32-32l0-128c0-17.7-14.3-32-32-32L96 256c-17.7 0-32 14.3-32 32z", "M64 16C37.5 16 16 37.5 16 64l0 384c0 26.5 21.5 48 48 48l256 0c26.5 0 48-21.5 48-48l0-322.7c0-12.7-5.1-24.9-14.1-33.9L365.3 80c12 12 18.7 28.3 18.7 45.3L384 448c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64C0 28.7 28.7 0 64 0L258.7 0c17 0 33.3 6.7 45.3 18.7l61.3 61.3-11.3 11.3-61.3-61.3c-9-9-21.2-14.1-33.9-14.1L64 16zM80 360l0 56c0 8.8 7.2 16 16 16l128 0 0-72-144 0zm160 72l48 0c8.8 0 16-7.2 16-16l0-56-64 0 0 72zM80 344l64 0 0-72-48 0c-8.8 0-16 7.2-16 16l0 56zm80-72l0 72 144 0 0-56c0-8.8-7.2-16-16-16l-128 0zm128-16c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32L96 448c-17.7 0-32-14.3-32-32l0-128c0-17.7 14.3-32 32-32l192 0z"]],
    "shield-quartered": [512, 512, [], "e575", ["M42.8 232l205.2 0 0 260.4c-3.9-.7-7.8-1.9-11.4-3.7-119.7-57.3-173.3-165.1-193.8-256.7zM264 19.4c3.7 .6 7.3 1.7 10.8 3.1l176.7 75c16.6 7.1 28.6 23.2 28.5 42.4-.1 22-2.3 48.1-7.5 76.1L264 216 264 19.4z", "M274.8 22.6c-3.5-1.5-7.1-2.5-10.8-3.1l0 196.6 208.6 0c5.2-28 7.4-54.1 7.5-76.1 .1-19.1-11.9-35.3-28.5-42.4l-176.7-75zM469.3 232l-205.3 0 0 260.4c3.9-.7 7.8-1.9 11.5-3.7 119.7-57.3 173.3-165.1 193.8-256.7zM248 216l0-196.6c-3.6 .6-7.2 1.7-10.7 3.1L60.6 97.5c-16.6 7.1-28.6 23.2-28.5 42.4 .1 22 2.3 48.1 7.5 76.1L248 216zM42.8 232c20.5 91.6 74.1 199.4 193.8 256.7 3.7 1.8 7.5 3 11.4 3.7l0-260.4-205.2 0zM231.1 7.8c16-6.8 34-6.8 50 0l176.7 75c22 9.3 38.4 31 38.3 57.2-.5 99.2-41.3 280.7-213.6 363.2-16.7 8-36.1 8-52.8 0-172.4-82.5-213.2-264-213.6-363.2-.1-26.2 16.3-47.9 38.3-57.2l176.7-75z"]],
    "square-ellipsis-vertical": [448, 512, [], "e26f", ["M16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96zm224 64a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm0 96a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm0 96a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M64 48C37.5 48 16 69.5 16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM224 240a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm-16-80a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm16 176a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"]],
    "oven": [448, 512, [], "e01d", ["M16 96l0 96 416 0 0-96c0-44.2-35.8-80-80-80L96 16C51.8 16 16 51.8 16 96zm0 112l0 240c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-240-416 0zm80-96a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm0 168c0-4.4 3.6-8 8-8l240 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-240 0c-4.4 0-8-3.6-8-8zm96-168a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm96 0a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm96 0a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M352 16L96 16C51.8 16 16 51.8 16 96l0 96 416 0 0-96c0-44.2-35.8-80-80-80zm80 192l-416 0 0 240c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-240zM0 200L0 96C0 43 43 0 96 0L352 0c53 0 96 43 96 96l0 352c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 200zm64-88a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM176 96a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm80 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM368 96a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM96 280c0-4.4 3.6-8 8-8l240 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-240 0c-4.4 0-8-3.6-8-8z"]],
    "scale-balanced": [640, 512, [9878, "balance-scale"], "f24e", ["M16.2 304l223 0c-2.7 20.9-15.5 45-35.8 64-20.5 19.2-47.1 32-75.7 32S72.4 387.2 52 368c-20.3-19-33.1-43.1-35.8-64zm384.7 0l223 0c-2.7 20.9-15.5 45-35.8 64-20.5 19.2-47.1 32-75.7 32s-55.2-12.8-75.7-32c-20.3-19-33.1-43.1-35.8-64z", "M384.7 64c0 32.6-24.4 59.6-56 63.5l0 368.5 208 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L104 512c-4.4 0-8-3.6-8-8s3.6-8 8-8l208.7 0 0-368.5c-31.6-3.9-56-30.9-56-63.5L104 64c-4.4 0-8-3.6-8-8s3.6-8 8-8l154.7 0c7.1-27.6 32.2-48 62-48s54.9 20.4 62 48L536 48c4.4 0 8 3.6 8 8s-3.6 8-8 8L384.7 64zm52 304c20.5 19.2 47.1 32 75.7 32s55.2-12.8 75.7-32c20.3-19 33.1-43.1 35.8-64l-223 0c2.7 20.9 15.5 45 35.8 64zm75.7-254.2L407.8 288 616.9 288 512.4 113.8zM635.8 288.4c3 5 4.7 10.7 4.1 16.4-5.8 51.3-60.7 111.2-127.5 111.2S390.7 356.2 384.9 304.8c-.7-5.8 1.1-11.5 4-16.4L500.3 102.9c2.6-4.3 7.2-6.9 12.1-6.9s9.6 2.6 12.1 6.9L635.8 288.4zM16.2 304c2.7 20.9 15.5 45 35.8 64 20.5 19.2 47.1 32 75.7 32s55.2-12.8 75.7-32c20.3-19 33.1-43.1 35.8-64l-223 0zm6.9-16L232.2 288 127.6 113.8 23.1 288zM139.7 102.9L251.1 288.4c3 5 4.7 10.7 4.1 16.4-5.8 51.3-60.7 111.2-127.5 111.2S6 356.2 .1 304.8c-.7-5.8 1.1-11.5 4.1-16.4L115.5 102.9c2.6-4.3 7.2-6.9 12.1-6.9s9.6 2.6 12.1 6.9zM320.7 112a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"]],
    "car": [512, 512, [128664, "automobile"], "f1b9", ["M16 256l0 128 480 0 0-128c0-26.5-21.5-48-48-48L64 208c-26.5 0-48 21.5-48 48zm112 32a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm320 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M99.3 93.3L59.8 192.1c1.4-.1 2.8-.1 4.2-.1l384 0c1.4 0 2.8 0 4.2 .1L412.7 93.3C401.8 65.9 375.3 48 345.8 48L166.2 48c-29.4 0-55.9 17.9-66.9 45.3zM40.9 196.3l43.6-109C97.8 53.9 130.2 32 166.2 32l179.7 0c36 0 68.3 21.9 81.7 55.3l43.6 109C495 205.6 512 228.8 512 256l0 192c0 17.7-14.3 32-32 32l-16 0c-17.7 0-32-14.3-32-32l0-48-352 0 0 48c0 17.7-14.3 32-32 32l-16 0c-17.7 0-32-14.3-32-32L0 256c0-27.2 17-50.4 40.9-59.7zM64 208c-26.5 0-48 21.5-48 48l0 128 480 0 0-128c0-26.5-21.5-48-48-48L64 208zM448 400l0 48c0 8.8 7.2 16 16 16l16 0c8.8 0 16-7.2 16-16l0-48-48 0zM16 400l0 48c0 8.8 7.2 16 16 16l16 0c8.8 0 16-7.2 16-16l0-48-48 0zm96-112a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm-48 0a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm352 16a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm0-48a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]],
    "circle-baht": [512, 512, [], "e72d", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zM161.8 142.2c0-7.9 6.4-14.2 14.2-14.2l72 0 0-24c0-4.4 3.6-8 8-8s8 3.6 8 8l0 24 25.3 0c37.6 0 68 30.4 68 68 0 23-11.4 43.4-28.9 55.7 26.7 9.2 45.9 34.5 45.9 64.3 0 37.6-30.4 68-68 68l-42.2 0 0 24c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-24-70.8 0c-8.5 0-15.5-6.9-15.5-15.5l0-226.3zm16 1.8l0 104 70.2 0 0-104-70.2 0zm0 120l0 104 70.2 0 0-104-70.2 0zM264 144l0 104 25.3 0c28.7 0 52-23.3 52-52s-23.3-52-52-52L264 144zm0 120l0 104 42.2 0c28.7 0 52-23.3 52-52s-23.3-52-52-52L264 264z", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm-8-408l0 24-72 0c-7.9 0-14.2 6.4-14.2 14.2l0 226.3c0 8.5 6.9 15.5 15.5 15.5l70.8 0 0 24c0 4.4 3.6 8 8 8s8-3.6 8-8l0-24 42.2 0c37.6 0 68-30.4 68-68 0-29.8-19.2-55.2-45.9-64.3 17.5-12.3 28.9-32.6 28.9-55.7 0-37.6-30.4-68-68-68l-25.3 0 0-24c0-4.4-3.6-8-8-8s-8 3.6-8 8zm-70.2 40l70.2 0 0 104-70.2 0 0-104zm86.2 0l25.3 0c28.7 0 52 23.3 52 52s-23.3 52-52 52l-25.3 0 0-104zM177.8 264l70.2 0 0 104-70.2 0 0-104zm86.2 0l42.2 0c28.7 0 52 23.3 52 52s-23.3 52-52 52l-42.2 0 0-104z"]],
    "badger-honey": [640, 512, [129441], "f6b4", ["M16 220c0-47 30.1-87 72-101.9l0 9.8c0 70.8 57.4 128.1 128.1 128.1 22.3 0 44.2-5.8 63.6-16.9l81.3-46.4c36.9-21.1 78.7-32.4 121.2-32.7-1.4 2.4-2.1 5.1-2.1 8 0 8.8 7.2 16 16 16s16-7.2 16-16c0-2.9-.8-5.6-2.1-8l110.9 0c2.1 5.4 3.3 11.3 3.3 17.3 0 12.4-4.9 24.3-13.7 33.1-8.7 8.7-20.7 13.6-33.7 14.7-75.5 6.8-149.2 45-192.6 78.2-2.4 1.8-3.5 4.7-3 7.7l20.8 125.1c2.4 14.6-8.8 27.9-23.7 27.9l-31.1 0c-11.7 0-21.7-8.5-23.7-20.1L305.2 334.7c-.6-3.9-4-6.7-7.9-6.7L192 328c-3.2 0-6.1 1.9-7.4 4.8l-19.4 45.3c-3.7 8.6-4.2 18.3-1.5 27.3l8.3 27.7c4.6 15.4-6.9 30.9-23 30.9l-29.2 0c-10.6 0-19.9-7-23-17.1L83.7 403.2c-2.2-7.3-2.2-15.1-.1-22.5L97.2 333c1.2-4.2-1.2-8.5-5.3-9.8-25.1-7.8-46.3-24.6-59.9-46.5l0 26.5c.4 .4 .8 .8 1.1 1.2-7.1-7.3-12.9-15.9-17.1-25.3L16 224c0-.3 0-.6 0-.9 0-1 0-2.1 0-3.1z", "M395.9 95c-22.1 11.1-46.9 17-71.7 17L124 112c-6.8 0-13.5 .6-20 1.8l0 14c0 61.9 50.2 112.1 112.1 112.1 19.5 0 38.7-5.1 55.6-14.8L353 178.8C392.9 156 438 144 484 144l126.3 0c-3.3-3.3-7.1-6.2-11.4-8.5L524.9 96.3c-20.3-10.7-42.9-16.3-65.8-16.3-21.8 0-43.7 5.2-63.2 15zM88 118.1c-41.9 14.8-72 54.8-72 101.9 0 1.1 0 2.1 0 3.1 0 .3 0 .6 0 .9l0 96c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-96c0-.3 0-.5 0-.8 0-1.1 0-2.1 0-3.2 0-68.5 55.5-124 124-124l200.2 0c22.3 0 44.6-5.3 64.5-15.3 21.7-10.9 46-16.7 70.3-16.7 25.5 0 50.7 6.2 73.3 18.2l74.1 39.2c20.7 10.9 33.6 32.5 33.6 55.9 0 16.6-6.6 32.6-18.3 44.4-11.8 11.8-27.6 17.9-43.5 19.4-6.5 .6-13 1.4-19.5 2.5 .9 1.3 1.4 2.8 1.4 4.5l0 32c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-32c0-.6 .1-1.2 .2-1.8-57.3 12.3-111.2 40.8-146.6 66.9l20 120.3c4.1 24.4-14.7 46.6-39.5 46.6l-31.1 0c-19.6 0-36.2-14.1-39.5-33.4l-17.1-102.6-93.3 0-17.3 40.5c-2.2 5.2-2.5 11-.9 16.3l8.3 27.7C195 454.2 175.8 480 149 480l-29.2 0c-17.7 0-33.2-11.6-38.3-28.5L68.4 407.8c-3.1-10.3-3.1-21.2-.2-31.5l11.6-40.4c-18.4-7-34.7-18.4-47.7-32.7l0-26.5c13.5 22 34.7 38.7 59.9 46.5 4.1 1.3 6.5 5.7 5.3 9.8L83.6 380.7c-2.1 7.4-2 15.2 .1 22.5l13.1 43.7c3 10.2 12.4 17.1 23 17.1l29.2 0c16.1 0 27.6-15.5 23-30.9l-8.3-27.7c-2.7-9-2.1-18.6 1.5-27.3l19.4-45.3c1.3-2.9 4.2-4.8 7.4-4.8l105.3 0c3.9 0 7.2 2.8 7.9 6.7l18.2 109.3c1.9 11.6 11.9 20.1 23.7 20.1l31.1 0c14.8 0 26.1-13.3 23.7-27.9L381.1 311c-.5-2.9 .7-5.9 3-7.7 43.4-33.2 117.1-71.4 192.6-78.2 13-1.2 25-6.1 33.7-14.7 8.7-8.7 13.7-20.7 13.7-33.1 0-6-1.1-11.9-3.3-17.3l-110.9 0c1.4 2.4 2.1 5.1 2.1 8 0 8.8-7.2 16-16 16s-16-7.2-16-16c0-2.9 .8-5.6 2.1-8-42.5 .3-84.3 11.6-121.2 32.7l-81.3 46.4C260.3 250.2 238.4 256 216.1 256 145.4 256 88 198.6 88 127.9l0-9.8z"]],
    "crop-simple": [512, 512, ["crop-alt"], "f565", ["M112 112l264 0c.7 0 1.4 0 2 .1 12.3 1.1 22 11.4 22 23.9l0 264-264 0c-.7 0-1.4 0-2-.1-12.3-1.1-22-11.4-22-23.9l0-264z", "M112 8c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 88-88 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l88 0 0 264c0 22.1 17.9 40 40 40l216 0 0-16-216 0c-13.3 0-24-10.7-24-24L112 8zM400 504c0 4.4 3.6 8 8 8s8-3.6 8-8l0-88 88 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-88 0 0-264c0-22.1-17.9-40-40-40l-216 0 0 16 216 0c13.3 0 24 10.7 24 24l0 368z"]],
    "timer": [512, 512, [], "e29e", ["M16 256c0-66.3 26.9-126.3 70.3-169.7l68 68c-3.1 3.1-3.1 8.2 0 11.3l96 96c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-5.7-5.7 0-116.7c4.4 0 8-3.6 8-8l0-103.9c128.8 4.2 232 110 232 239.9 0 132.5-107.5 240-240 240S16 388.5 16 256z", "M256 0c-4.4 0-8 3.6-8 8l0 112c0 4.4 3.6 8 8 8s8-3.6 8-8l0-103.9c128.8 4.2 232 110 232 239.9 0 132.5-107.5 240-240 240S16 388.5 16 256c0-66.3 26.9-126.3 70.3-169.7 3.1-3.1 3.1-8.2 0-11.3S78.1 71.9 75 75C28.7 121.3 0 185.3 0 256 0 397.4 114.6 512 256 512S512 397.4 512 256 397.4 0 256 0zM165.7 154.3c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l96 96c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-96-96z"]],
    "square-dollar": [448, 512, ["dollar-square", "usd-square"], "f2e9", ["M16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96zM160 210.7c0-28 22.7-50.7 50.7-50.7l5.3 0 0-24c0-4.4 3.6-8 8-8s8 3.6 8 8l0 24 40 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-61.3 0c-19.1 0-34.7 15.5-34.7 34.7 0 17.4 12.9 32.1 30.1 34.4l46 6.1c25.2 3.4 44 24.8 44 50.2 0 28-22.7 50.7-50.7 50.7l-13.3 0 0 24c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-24-40 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l69.3 0c19.1 0 34.7-15.5 34.7-34.7 0-17.4-12.9-32.1-30.1-34.4l-46-6.1c-25.2-3.4-44-24.8-44-50.2z", "M64 48C37.5 48 16 69.5 16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm224 32c4.4 0 8 3.6 8 8l0 24 40 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-61.3 0c-19.1 0-34.7 15.5-34.7 34.7 0 17.4 12.9 32.1 30.1 34.4l46 6.1c25.2 3.4 44 24.8 44 50.2 0 28-22.7 50.7-50.7 50.7l-13.3 0 0 24c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-24-40 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l69.3 0c19.1 0 34.7-15.5 34.7-34.7 0-17.4-12.9-32.1-30.1-34.4l-46-6.1c-25.2-3.4-44-24.8-44-50.2 0-28 22.7-50.7 50.7-50.7l5.3 0 0-24c0-4.4 3.6-8 8-8z"]],
    "medal": [448, 512, [127941], "f5a2", ["M48 320a176 176 0 1 0 352 0 176 176 0 1 0 -352 0zm71.9-11.2c-14.2-13.9-6.4-38.1 13.3-40.9l47.9-7 21.4-43.4c8.8-17.8 34.2-17.8 43 0l21.4 43.4 47.9 7c19.7 2.9 27.5 27.1 13.3 40.9l-34.6 33.8 8.2 47.7c3.4 19.6-17.2 34.6-34.8 25.3L224 393 181.2 415.5c-17.6 9.3-38.2-5.7-34.8-25.3l8.2-47.7-34.6-33.8z", "M206.6 128.8L132.1-7.8c-4.1-7.6-13.5-10.5-21.2-6.6L25.9 28c-8.1 4.1-11.2 14-6.9 22L90.8 181.7c30.6-29.5 71-48.9 115.8-53zM146.1-15.5L224 127.3 301.9-15.5c8.2-15.1 27-21 42.4-13.3l85 42.5c16.2 8.1 22.5 28 13.8 43.9L368.8 193.9c29.4 33.7 47.2 77.8 47.2 126.1 0 106-86 192-192 192S32 426 32 320c0-48.3 17.8-92.4 47.2-126.1L4.9 57.7C-3.8 41.8 2.5 21.8 18.7 13.7l85-42.5c15.4-7.7 34.2-1.8 42.4 13.3zM429.1 50c4.3-8 1.2-17.9-6.9-22l-85-42.5c-7.7-3.9-17.1-.9-21.2 6.6L241.4 128.8c44.8 4 85.2 23.5 115.8 53L429.1 50zM400 320a176 176 0 1 0 -352 0 176 176 0 1 0 352 0zM245.6 217.5l21.4 43.4 47.9 7c19.7 2.9 27.5 27.1 13.3 40.9l-34.6 33.8 8.2 47.7c3.4 19.6-17.2 34.6-34.8 25.3L224 393 181.2 415.5c-17.6 9.3-38.2-5.7-34.8-25.3l8.2-47.7-34.6-33.8c-14.2-13.9-6.4-38.1 13.3-40.9l47.9-7 21.4-43.4c8.8-17.8 34.2-17.8 43 0zm-28.7 7.1l-23.3 47.2c-1.2 2.4-3.4 4-6 4.4l-52 7.6c-6.6 1-9.2 9-4.4 13.6L168.7 334c1.9 1.8 2.7 4.5 2.3 7.1L162.2 393c-1.1 6.5 5.7 11.5 11.6 8.4l46.5-24.5c2.3-1.2 5.1-1.2 7.4 0l46.5 24.5c5.9 3.1 12.7-1.9 11.6-8.4L277 341.1c-.4-2.6 .4-5.2 2.3-7.1L317 297.3c4.7-4.6 2.1-12.7-4.4-13.6l-52-7.6c-2.6-.4-4.9-2-6-4.4l-23.3-47.2c-2.9-5.9-11.4-5.9-14.3 0z"]],
    "scroll": [576, 512, [128220], "f70e", ["M106.3 48L360 48c39.8 0 72 32.2 72 72l0 200-168 0c-22.1 0-40 17.9-40 40l0 56c0 26.5-21.5 48-48 48s-48-21.5-48-48l0-320c0-19.1-8.4-36.3-21.7-48z", "M16 96c0-26.5 21.5-48 48-48s48 21.5 48 48l0 80-80 0c-8.8 0-16-7.2-16-16l0-64zm90.3-48L360 48c39.8 0 72 32.2 72 72l0 200-168 0c-22.1 0-40 17.9-40 40l0 56c0 26.5-21.5 48-48 48s-48-21.5-48-48l0-320c0-19.1-8.4-36.3-21.7-48zM448 320l0-200c0-48.6-39.4-88-88-88L64 32C28.7 32 0 60.7 0 96l0 64c0 17.7 14.3 32 32 32l80 0 0 224c0 35.3 28.7 64 64 64l280 0c48.6 0 88-39.4 88-88l0-32c0-22.1-17.9-40-40-40l-56 0zm8 144l-237.7 0c13.3-11.7 21.7-28.9 21.7-48l0-56c0-13.3 10.7-24 24-24l240 0c13.3 0 24 10.7 24 24l0 32c0 39.8-32.2 72-72 72z"]],
    "calendars": [512, 512, [], "e0d7", ["M112 192l0 160c0 26.5 21.5 48 48 48l288 0c26.5 0 48-21.5 48-48l0-160-384 0z", "M192 8c0-4.4 3.6-8 8-8s8 3.6 8 8l0 56 192 0 0-56c0-4.4 3.6-8 8-8s8 3.6 8 8l0 56 32 0c35.3 0 64 28.7 64 64l0 224c0 35.3-28.7 64-64 64l-288 0c-35.3 0-64-28.7-64-64l0-224c0-35.3 28.7-64 64-64l32 0 0-56zM448 80L160 80c-26.5 0-48 21.5-48 48l0 48 384 0 0-48c0-26.5-21.5-48-48-48zM112 352c0 26.5 21.5 48 48 48l288 0c26.5 0 48-21.5 48-48l0-160-384 0 0 160zM16 168l0 280c0 26.5 21.5 48 48 48l344 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L64 512c-35.3 0-64-28.7-64-64L0 168c0-4.4 3.6-8 8-8s8 3.6 8 8z"]],
    "apple-core": [384, 512, [], "e08f", ["M40.8 154.7c43.5 35.2 71.3 89 71.3 149.3 0 59.3-26.9 112.4-69.2 147.6-.2 .2-.4 .4-.5 .6 26 28.6 56.7 43.8 85.7 43.8 9.5 0 22.2-2.8 34.1-6.4 19.4-5.8 40.3-5.8 59.7 0 11.9 3.6 24.7 6.4 34.1 6.4 29 0 59.7-15.2 85.7-43.7-.2-.3-.3-.5-.5-.7-42.3-35.2-69.2-88.3-69.2-147.6 0-60.3 27.8-114.2 71.3-149.3-11.1-6.7-24.1-10.7-39.3-10.7-24.1 0-54.2 9.4-76.9 18.2-22.5 8.8-47.8 8.8-70.3 0-22.7-8.8-52.7-18.2-76.9-18.2-15.2 0-28.2 3.9-39.3 10.7zM192.1 80l0 16 16 0c35.3 0 64-28.7 64-64l0-16-16 0c-35.3 0-64 28.7-64 64z", "M208.1 96c35.3 0 64-28.7 64-64l0-16-16 0c-35.3 0-64 28.7-64 64l0 16 16 0zm0 16l-16 0c-8.8 0-16-7.2-16-16l0-16c0-44.2 35.8-80 80-80l16 0c8.8 0 16 7.2 16 16l0 16c0 44.2-35.8 80-80 80zM43 451.6c-.2 .2-.4 .4-.5 .6l0 .1c26 28.5 56.7 43.7 85.7 43.7 9.5 0 22.2-2.8 34.1-6.4 19.4-5.8 40.3-5.8 59.7 0 11.9 3.6 24.7 6.4 34.1 6.4 29 0 59.7-15.2 85.7-43.7l0-.1c-.1-.2-.3-.4-.5-.6-42.3-35.2-69.2-88.3-69.2-147.6 0-60.3 27.8-114.2 71.3-149.3-11.1-6.7-24.1-10.7-39.3-10.7-24.1 0-54.2 9.4-76.9 18.2-22.5 8.8-47.8 8.8-70.3 0-22.7-8.8-52.7-18.2-76.9-18.2-15.2 0-28.2 3.9-39.3 10.7 43.5 35.2 71.3 89 71.3 149.3 0 59.3-26.9 112.4-69.2 147.6zM30 462.4c-6.2-6.8-4.4-17.3 2.7-23.1 38.8-32.3 63.4-80.9 63.4-135.3 0-55.4-25.6-104.7-65.5-137-8-6.5-9.3-18.7-.7-24.3 14.2-9.3 30.9-14.7 50.3-14.7 27.3 0 59.7 10.3 82.7 19.3 18.8 7.3 39.9 7.3 58.7 0 22.9-8.9 55.4-19.3 82.7-19.3 19.3 0 36.1 5.4 50.3 14.7 8.6 5.6 7.3 17.9-.7 24.3-40 32.3-65.5 81.7-65.5 137 0 54.4 24.7 103 63.4 135.3 7 5.9 8.8 16.3 2.7 23.1-28.3 31.3-63.2 49.6-98.1 49.6-11.9 0-26.5-3.4-38.8-7.1-16.4-4.9-34.1-4.9-50.5 0-12.2 3.7-26.8 7.1-38.8 7.1-34.9 0-69.8-18.3-98.1-49.6z"]],
    "file-excel": [384, 512, [], "f1c3", ["M16 64l0 384c0 26.5 21.5 48 48 48l256 0c26.5 0 48-21.5 48-48l0-261.5c0-3.6-.4-7.1-1.2-10.5L264 176c-30.9 0-56-25.1-56-56l0-102.8c-3.4-.8-6.9-1.2-10.5-1.2L64 16C37.5 16 16 37.5 16 64zM121.8 269c-2.8-3.4-2.2-8.5 1.2-11.2s8.5-2.2 11.2 1.2L192 331.2 249.8 259c2.8-3.4 7.8-4 11.2-1.2s4 7.8 1.2 11.2l-60 75 60 75c2.8 3.4 2.2 8.5-1.2 11.2s-8.5 2.2-11.2-1.2L192 356.8 134.2 429c-2.8 3.4-7.8 4-11.2 1.2s-4-7.8-1.2-11.2l60-75-60-75z", "M197.5 16c3.6 0 7.1 .4 10.5 1.2L208 120c0 30.9 25.1 56 56 56l102.8 0c.8 3.4 1.2 6.9 1.2 10.5L368 448c0 26.5-21.5 48-48 48L64 496c-26.5 0-48-21.5-48-48L16 64c0-26.5 21.5-48 48-48l133.5 0zM353.9 152.6c2.3 2.3 4.3 4.8 6.1 7.4l-96 0c-22.1 0-40-17.9-40-40l0-96c2.7 1.8 5.1 3.8 7.4 6.1L353.9 152.6zM64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-261.5c0-17-6.7-33.3-18.7-45.3L242.7 18.7C230.7 6.7 214.5 0 197.5 0L64 0zm70.2 259c-2.8-3.4-7.8-4-11.2-1.2s-4 7.8-1.2 11.2l60 75-60 75c-2.8 3.4-2.2 8.5 1.2 11.2s8.5 2.2 11.2-1.2L192 356.8 249.8 429c2.8 3.4 7.8 4 11.2 1.2s4-7.8 1.2-11.2l-60-75 60-75c2.8-3.4 2.2-8.5-1.2-11.2s-8.5-2.2-11.2 1.2L192 331.2 134.2 259z"]],
    "diamond-half": [512, 512, [], "e5b7", ["M16 256c0 11.1 4.4 21.8 12.3 29.7L226.3 483.7c2.5 2.5 5.2 4.6 8.2 6.4 .8 .5 1.3 .5 1.6 .5 .4 0 .9-.2 1.5-.6 1.2-.9 2.4-2.9 2.4-5.4l0-457.1c0-2.5-1.2-4.5-2.4-5.4-.6-.4-1.1-.6-1.5-.6-.3 0-.8 0-1.6 .5-3 1.8-5.7 3.9-8.2 6.4L28.3 226.3C20.4 234.2 16 244.9 16 256z", "M247.2 9.3c5.4 4.1 8.8 10.9 8.8 18.2l0 457.1c0 7.3-3.4 14.1-8.8 18.2-5.7 4.3-13.6 5.4-20.9 1.1-4.1-2.4-7.9-5.4-11.3-8.8L17 297C6.1 286.1 0 271.4 0 256s6.1-30.1 17-41L215 17c3.4-3.4 7.2-6.4 11.3-8.8 7.3-4.3 15.2-3.2 20.9 1.1zM236.1 21.4c-.3 0-.8 0-1.6 .5-3 1.8-5.7 3.9-8.2 6.4L28.3 226.3C20.4 234.2 16 244.9 16 256s4.4 21.8 12.3 29.7L226.3 483.7c2.5 2.5 5.2 4.6 8.2 6.4 .8 .5 1.3 .5 1.6 .5 .4 0 .9-.2 1.5-.6 1.2-.9 2.4-2.9 2.4-5.4l0-457.1c0-2.5-1.2-4.5-2.4-5.4-.6-.4-1.1-.6-1.5-.6z"]],
    "baguette": [640, 512, [129366], "e3d8", ["M34.8 446.1c34.3 51.5 103.8 65.4 155.3 31.1l384-256c51.5-34.3 65.4-103.8 31.1-155.3S501.3 .5 449.9 34.8l-88.6 59.1 60.4 60.4c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L347.6 103 246 170.7 309.7 234.3c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-65.9-65.9-101.6 67.7 66.8 66.8c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-69.1-69.1-51.4 34.2C14.4 325.1 .5 394.7 34.8 446.1z", "M605.2 65.9C570.9 14.4 501.3 .5 449.9 34.8l-88.6 59.1 60.4 60.4c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L347.6 103 246 170.7 309.7 234.3c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-65.9-65.9-101.6 67.7 66.8 66.8c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-69.1-69.1-51.4 34.2C14.4 325.1 .5 394.7 34.8 446.1s103.8 65.4 155.3 31.1l384-256c51.5-34.3 65.4-103.8 31.1-155.3zM618.5 57c39.2 58.8 23.3 138.3-35.5 177.5l-384 256C140.2 529.7 60.7 513.8 21.5 455S-1.8 316.7 57 277.5l384-256C499.8-17.7 579.3-1.8 618.5 57z"]],
    "ear-triangle-exclamation": [576, 512, [], "e75c", ["M80 192C80 94.8 158.8 16 256 16S432 94.8 432 192c0 2 0 3.9-.1 5.8-10-3.8-20.8-5.8-31.9-5.8-11.1 0-21.9 2-32 5.9l0-5.9c0-61.9-50.1-112-112-112S144 130.1 144 192l0 40c0 4.4 3.6 8 8 8l16 0c22.1 0 40 17.9 40 40s-17.9 40-40 40l-16 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l16 0c30.9 0 56-25.1 56-56s-25.1-56-56-56l-8 0 0-32c0-53 43-96 96-96s96 43 96 96l0 8c0 1.8 .6 3.5 1.6 4.8-12.6 7.6-23.4 18.2-31.2 31.3L188 462.7c-5.9 9.9-9.7 20.9-11.2 32.3-54.6-7.4-96.8-54.3-96.8-111l0-192z", "M432 192c0 2 0 3.9-.1 5.8 5.5 2.1 10.7 4.6 15.6 7.7 .3-4.5 .5-9 .5-13.5 0-106-86-192-192-192S64 86 64 192l0 192c0 65.3 48.9 119.2 112.1 127-.1-1.6-.1-3.2-.1-4.7 0-3.8 .3-7.6 .8-11.3-54.6-7.4-96.8-54.3-96.8-111l0-192C80 94.8 158.8 16 256 16S432 94.8 432 192zm-80 8c0 1.8 .6 3.5 1.6 4.8 4.6-2.7 9.4-5.1 14.4-7l0-5.9c0-61.9-50.1-112-112-112S144 130.1 144 192l0 40c0 4.4 3.6 8 8 8l16 0c22.1 0 40 17.9 40 40s-17.9 40-40 40l-16 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l16 0c30.9 0 56-25.1 56-56s-25.1-56-56-56l-8 0 0-32c0-53 43-96 96-96s96 43 96 96l0 8zM243 495.4L377.5 268.9c4.7-7.9 13.3-12.8 22.5-12.8s17.8 4.9 22.5 12.8L557 495.4c2 3.3 3 7.1 3 10.9 0 11.8-9.6 21.4-21.4 21.4l-277.1 0c-11.8 0-21.4-9.6-21.4-21.4 0-3.9 1-7.6 3-10.9zm-13.8-8.2c-3.4 5.8-5.2 12.4-5.2 19.1 0 20.7 16.8 37.4 37.4 37.4l277.1 0c20.7 0 37.4-16.8 37.4-37.4 0-6.7-1.8-13.3-5.2-19.1L436.3 260.7c-7.6-12.8-21.4-20.6-36.3-20.6s-28.7 7.8-36.3 20.6L229.2 487.3zM400 480.1a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm0-168.9c-4.4 0-8 3.6-8 8l0 88.9c0 4.4 3.6 8 8 8s8-3.6 8-8l0-88.9c0-4.4-3.6-8-8-8z"]],
    "h5": [576, 512, [], "e412", ["", "M48 72c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 368c0 4.4 3.6 8 8 8s8-3.6 8-8l0-176 192 0 0 176c0 4.4 3.6 8 8 8s8-3.6 8-8l0-368c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 176-192 0 0-176zm280-8c-4.4 0-8 3.6-8 8l0 176c0 4.4 3.6 8 8 8l120 0c48.6 0 88 39.4 88 88s-39.4 88-88 88l-120 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l120 0c57.4 0 104-46.6 104-104S505.4 240 448 240l-112 0 0-160 184 0c4.4 0 8-3.6 8-8s-3.6-8-8-8L328 64z"]],
    "person-ski-lift": [512, 512, ["ski-lift"], "f7c8", ["M80 80a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm35 131.3l32.9 71.2c6.5 14.1 22.3 21.5 37.3 17.5l66.7-17.8c4.8-1.3 9.9-.3 13.9 2.8s6.3 7.7 6.3 12.7l0 134 32-12.2 0-153c0-15.8-14.9-27.3-30.2-23.2l-55.9 14.9c-7.6 2-15.5-1.7-18.7-8.8l-28.8-63.4c-4.9-10.9-15.8-17.9-27.8-17.9-22.3 0-37 23.1-27.7 43.3z", "M248 0c4.4 0 8 3.6 8 8l0 190.3-16 4.3 0-194.6c0-4.4 3.6-8 8-8zm24 297.7l0 134 32-12.2 0-153c0-15.8-14.9-27.3-30.2-23.2l-55.9 14.9c-7.6 2-15.5-1.7-18.7-8.8l-28.8-63.4c-4.9-10.9-15.8-17.9-27.8-17.9-22.3 0-37 23.1-27.7 43.3l32.9 71.2c6.5 14.1 22.3 21.5 37.3 17.5l66.7-17.8c4.8-1.3 9.9-.3 13.9 2.8s6.3 7.7 6.3 12.7zm48-31.2l0 147 145-55.1c18.6-7.1 31-24.9 31-44.9l0-17.4c0-4.4 3.6-8 8-8s8 3.6 8 8l0 17.4c0 26.6-16.4 50.4-41.3 59.8L106.8 511.5c-4.1 1.6-8.8-.5-10.3-4.6s.5-8.8 4.6-10.3l154.8-58.8 0-140c-4.9 1.3-27.1 7.2-66.7 17.8-22.6 6-46.2-5.1-55.9-26.3L100.4 218c-14.2-30.8 8.3-66 42.2-66 18.2 0 34.8 10.7 42.3 27.3l28.8 63.4 55.9-14.9c25.4-6.8 50.3 12.4 50.3 38.6zM144 80a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM112 32a48 48 0 1 1 0 96 48 48 0 1 1 0-96zM15.4 164.8L87.1 332.2c11.9 27.7 43.5 41 71.6 30.2l46.5-17.9c4.1-1.6 8.8 .5 10.3 4.6s-.5 8.8-4.6 10.3l-46.5 17.9c-36.1 13.9-76.8-3.3-92-38.8L.6 171.2c-1.7-4.1 .1-8.8 4.2-10.5s8.8 .1 10.5 4.2z"]],
    "square-cedi": [448, 512, [], "e729", ["M16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96zM97.9 256c0-67.5 52-122.8 118.1-128.1l0-23.9c0-4.4 3.6-8 8-8s8 3.6 8 8l0 23.5c32 1.3 61 14.4 82.8 35 3.4 3.2 3.6 8.7 .3 12.1s-8.7 3.6-12.1 .3c-18.7-17.7-43.5-28.9-71-30.3l0 222.6c27.4-1.3 52.3-12.6 71-30.3 3.4-3.3 8.9-3.1 12.1 .3s3.1 8.9-.3 12.1c-21.8 20.6-50.8 33.6-82.8 35l0 23.5c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-23.9C149.9 378.8 97.9 323.5 97.9 256zm17.1 0c0 58 44.3 105.6 100.9 110.9l0-221.9C159.4 150.4 115.1 198 115.1 256z", "M64 48C37.5 48 16 69.5 16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm232 8l0 23.5c32 1.3 61 14.4 82.8 35 3.4 3.2 3.6 8.7 .3 12.1s-8.7 3.6-12.1 .3c-18.7-17.7-43.5-28.9-71-30.3l0 222.6c27.4-1.3 52.3-12.6 71-30.3 3.4-3.3 8.9-3.1 12.1 .3s3.1 8.9-.3 12.1c-21.8 20.6-50.8 33.6-82.8 35l0 23.5c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-23.9C149.9 378.8 97.9 323.5 97.9 256s52-122.8 118.1-128.1l0-23.9c0-4.4 3.6-8 8-8s8 3.6 8 8zM115.1 256c0 58 44.3 105.6 100.9 110.9l0-221.9C159.4 150.4 115.1 198 115.1 256z"]],
    "filter": [512, 512, [], "f0b0", ["M17.2 89.9c-2.5 6-1.1 12.9 3.5 17.4l185 185c1.5 1.5 2.3 3.5 2.3 5.7L208 416c0 4.2 1.7 8.3 4.7 11.3l64 64c4.6 4.6 11.5 5.9 17.4 3.5s9.9-8.3 9.9-14.8l0-182.1c0-2.1 .8-4.2 2.3-5.7l185-185c4.6-4.6 5.9-11.5 3.5-17.4S486.5 80 480 80L32 80c-6.5 0-12.3 3.9-14.8 9.9z", "M32 80c-6.5 0-12.3 3.9-14.8 9.9s-1.1 12.9 3.5 17.4l185 185c1.5 1.5 2.3 3.5 2.3 5.7L208 416c0 4.2 1.7 8.3 4.7 11.3l64 64c4.6 4.6 11.5 5.9 17.4 3.5s9.9-8.3 9.9-14.8l0-182.1c0-2.1 .8-4.2 2.3-5.7l185-185c4.6-4.6 5.9-11.5 3.5-17.4S486.5 80 480 80L32 80zM2.4 83.8C7.4 71.8 19.1 64 32 64l448 0c12.9 0 24.6 7.8 29.6 19.8l0 0c5 12 2.2 25.7-6.9 34.9L320 301.3 320 480c0 12.9-7.8 24.6-19.8 29.6s-25.7 2.2-34.9-6.9l-64-64c-6-6-9.4-14.1-9.4-22.6L192 301.3 9.4 118.6C.2 109.5-2.5 95.7 2.4 83.8z"]],
    "calculator-simple": [512, 512, ["calculator-alt"], "f64c", ["", "M256 0c4.4 0 8 3.6 8 8l0 240 240 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-240 0 0 240c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-240-240 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l240 0 0-240c0-4.4 3.6-8 8-8zm88 104l48 0 0-64c0-4.4 3.6-8 8-8s8 3.6 8 8l0 64 64 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-64 0 0 64c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-64-64 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l16 0zM50.7 338.7c3.1-3.1 8.2-3.1 11.3 0l49.9 49.9 49.9-49.9c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3l-49.9 49.9 49.9 49.9c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L112 411.3 62.1 461.3c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l49.9-49.9-49.9-49.9c-3.1-3.1-3.1-8.2 0-11.3zM40 104l144 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L40 120c-4.4 0-8-3.6-8-8s3.6-8 8-8zM328 360l144 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-144 0c-4.4 0-8-3.6-8-8s3.6-8 8-8zm0 64l144 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-144 0c-4.4 0-8-3.6-8-8s3.6-8 8-8z"]],
    "coin-blank": [512, 512, [], "e3fb", ["M16 208C16 137.3 123.5 80 256 80S496 137.3 496 208 388.5 336 256 336 16 278.7 16 208zm0 50.2c11 16.7 27.4 31.9 48 45l0 82.8C31.7 365.8 16 342.2 16 320l0-61.8zm64 54.3c27.1 14.4 59.8 25.6 96 32.3l0 80.6c-36.1-6.2-68.1-16.3-93.9-29.2-.7-.4-1.4-.7-2.1-1.1l0-82.5zm112 34.9c20.5 3 41.9 4.5 64 4.5s43.5-1.6 64-4.5l0 80.4c-20.3 2.7-41.8 4.2-64 4.2s-43.7-1.5-64-4.2l0-80.4zm144-2.6c36.2-6.7 68.9-17.8 96-32.3l0 82.5c-.7 .4-1.4 .7-2.1 1.1-25.8 12.9-57.8 23.1-93.9 29.2l0-80.6zm112-41.6c20.6-13.1 37-28.3 48-45l0 61.8c0 22.2-15.7 45.8-48 66.1l0-82.8z", "M256 352c22.1 0 43.5-1.6 64-4.5l0 80.4c-20.3 2.7-41.8 4.2-64 4.2s-43.7-1.5-64-4.2l0-80.4c20.5 3 41.9 4.5 64 4.5zM80 312.6c27.1 14.4 59.8 25.6 96 32.3l0 80.6c-36.1-6.2-68.1-16.3-93.9-29.2-.7-.4-1.4-.7-2.1-1.1l0-82.5zM16 258.2c11 16.7 27.4 31.9 48 45l0 82.8C31.7 365.8 16 342.2 16 320l0-61.8zM256 64C114.6 64 0 128.5 0 208L0 320c0 70.7 114.6 128 256 128s256-57.3 256-128l0-112c0-79.5-114.6-144-256-144zM448 303.3c20.6-13.1 37-28.3 48-45l0 61.8c0 22.2-15.7 45.8-48 66.1l0-82.8zM336 344.8c36.2-6.7 68.9-17.8 96-32.3l0 82.5c-.7 .4-1.4 .7-2.1 1.1-25.8 12.9-57.8 23.1-93.9 29.2l0-80.6zM16 208C16 137.3 123.5 80 256 80S496 137.3 496 208 388.5 336 256 336 16 278.7 16 208z"]],
    "intersection": [384, 512, [8898], "f668", ["", "M8 480c4.4 0 8-3.6 8-8l0-248C16 126.8 94.8 48 192 48s176 78.8 176 176l0 248c0 4.4 3.6 8 8 8s8-3.6 8-8l0-248c0-106-86-192-192-192S0 118 0 224L0 472c0 4.4 3.6 8 8 8z"]],
    "drum": [512, 512, [129345], "f569", ["M16 247.9c15.1 17.9 40 33.3 72 45.3l0 142.8c-2.3-.9-4.5-1.8-6.7-2.8-45.3-19.6-65.3-43.7-65.3-65.3l0-120.1zm88 50.8c40.5 12.8 90.2 20.5 144 21.2l0 144c-54.7-.7-104.5-8.8-144-22l0-143.2zm160 21.2c53.8-.7 103.5-8.4 144-21.2l0 143.2c-39.5 13.2-89.3 21.3-144 22l0-144zm160-26.7c32-12 56.9-27.4 72-45.3L496 368c0 21.6-20 45.8-65.3 65.3-2.2 .9-4.4 1.9-6.7 2.8l0-142.8z", "M508.3 46.7c3.7-2.4 4.8-7.4 2.4-11.1s-7.4-4.8-11.1-2.4l-114.4 74C347.4 99.6 303.2 96 256 96 114.6 96 0 128 0 208L0 368c0 32 28.6 60 75 80 5.8 2.5 12 4.9 18.3 7.2 44.2 15.6 100.8 24.8 162.7 24.8s118.5-9.2 162.7-24.8c6.4-2.3 12.5-4.6 18.4-7.2 46.3-20 75-48 75-80l0-160c0-48.1-41.4-78.8-105-95.7L508.3 46.7zM365.7 120L227.7 209.3c-3.7 2.4-4.8 7.4-2.4 11.1s7.4 4.8 11.1 2.4l152.1-98.4c15.6 3.4 30 7.6 42.8 12.6 43.8 17 64.8 40.9 64.8 71.1 0 21.6-20 45.7-65.3 65.3-43.8 18.9-105.6 30.7-174.7 30.7S125.2 292.2 81.3 273.3c-45.3-19.6-65.3-43.7-65.3-65.3 0-30.2 21-54.1 64.8-71.1 43.6-17 105.4-24.9 175.2-24.9 39.8 0 77 2.6 109.7 8zM424 293.2c32-12 56.9-27.4 72-45.3L496 368c0 21.6-20 45.8-65.3 65.3-2.2 .9-4.4 1.9-6.7 2.8l0-142.8zM264 319.9c53.8-.7 103.5-8.4 144-21.2l0 143.2c-39.5 13.2-89.3 21.3-144 22l0-144zM104 298.8c40.5 12.8 90.2 20.5 144 21.2l0 144c-54.7-.7-104.5-8.8-144-22l0-143.2zM16 247.9c15.1 17.9 40 33.3 72 45.3l0 142.8c-2.3-.9-4.5-1.8-6.7-2.8-45.3-19.6-65.3-43.7-65.3-65.3l0-120.1z"]],
    "map-pin": [320, 512, [128205], "f276", ["M32 144a128 128 0 1 0 256 0 128 128 0 1 0 -256 0zm32-8c0-48.6 39.4-88 88-88 4.4 0 8 3.6 8 8s-3.6 8-8 8c-39.8 0-72 32.2-72 72 0 4.4-3.6 8-8 8s-8-3.6-8-8z", "M160 272a128 128 0 1 0 0-256 128 128 0 1 0 0 256zM304 144c0 76.8-60.2 139.6-136 143.8L168 504c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-216.2C76.2 283.6 16 220.8 16 144 16 64.5 80.5 0 160 0S304 64.5 304 144zM80 136c0 4.4-3.6 8-8 8s-8-3.6-8-8c0-48.6 39.4-88 88-88 4.4 0 8 3.6 8 8s-3.6 8-8 8c-39.8 0-72 32.2-72 72z"]],
    "circle-house": [512, 512, [], "e6c8", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zm97.8-10.9c-2.8-3.4-2.3-8.5 1.1-11.3l136-112c3-2.4 7.2-2.4 10.2 0l136 112c3.4 2.8 3.9 7.9 1.1 11.3s-7.8 3.9-11.3 1.1L368 230.6 368 336c0 26.5-21.5 48-48 48l-128 0c-26.5 0-48-21.5-48-48l0-105.4-18.9 15.6c-3.4 2.8-8.5 2.3-11.3-1.1zM232 298.8l0 69.2 48 0 0-69.2c-5.9-6.6-14.4-10.8-24-10.8s-18.1 4.2-24 10.8z", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM232 296c0-4.4 3.6-8 8-8l32 0c4.4 0 8 3.6 8 8l0 72-48 0 0-72zm-16 72l-24 0c-17.7 0-32-14.3-32-32l0-118.6 96-79.1 96 79.1 0 118.6c0 17.7-14.3 32-32 32l-24 0 0-72c0-13.3-10.7-24-24-24l-32 0c-13.3 0-24 10.7-24 24l0 72zM144 230.6L144 336c0 26.5 21.5 48 48 48l128 0c26.5 0 48-21.5 48-48l0-105.4 18.9 15.6c3.4 2.8 8.5 2.3 11.3-1.1s2.3-8.5-1.1-11.3l-136-112c-3-2.4-7.2-2.4-10.2 0l-136 112c-3.4 2.8-3.9 7.9-1.1 11.3s7.9 3.9 11.3 1.1L144 230.6z"]],
    "table-pivot": [576, 512, [], "e291", ["M80 96l0 64 112 0 0-112-64 0c-26.5 0-48 21.5-48 48zm0 80l0 240c0 26.5 21.5 48 48 48l64 0 0-288-112 0zM208 48l0 112 288 0 0-64c0-26.5-21.5-48-48-48L208 48z", "M200 32l248 0c35.3 0 64 28.7 64 64l0 112.6c-5.3-.8-10.7-.8-16 0l0-32.6-288 0 0 288 32.6 0c-.8 5.3-.8 10.7 0 16L128 480c-35.3 0-64-28.7-64-64L64 96c0-35.3 28.7-64 64-64l72 0zM80 160l112 0 0-112-64 0c-26.5 0-48 21.5-48 48l0 64zm0 16l0 240c0 26.5 21.5 48 48 48l64 0 0-288-112 0zm416-16l0-64c0-26.5-21.5-48-48-48l-240 0 0 112 288 0zm13.7 98.3l48 48c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L512 283.3 512 416c0 35.3-28.7 64-64 64l-132.7 0 34.3 34.3c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-48-48c-3.1-3.1-3.1-8.2 0-11.3l48-48c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3L315.3 464 448 464c26.5 0 48-21.5 48-48l0-132.7-34.3 34.3c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l48-48c3.1-3.1 8.2-3.1 11.3 0z"]],
    "bridge-suspension": [512, 512, [], "e4cd", ["M16 272l480 0 0 74.5-6.9 2.6c-34.3 12.9-57.1 45.7-57.1 82.4l0 56.6c0 4.4-3.6 8-8 8l-64 0c-4.4 0-8-3.6-8-8l0-40c0-53-43-96-96-96s-96 43-96 96l0 40c0 4.4-3.6 8-8 8l-64 0c-4.4 0-8-3.6-8-8l0-56.6c0-36.7-22.8-69.5-57.1-82.4L16 346.5 16 272z", "M88 256L88 63.5c-15 30.3-39 56-67.7 74.2-3.7 2.4-8.7 1.2-11-2.5s-1.2-8.7 2.5-11c41.3-26.1 71.2-68.4 76.3-116.8 .1-.7 .2-1.4 .4-2 .4-1.1 1.1-2.2 1.9-3s1.8-1.5 3-1.9C94.2 .2 95.1 0 96 0s1.8 .2 2.7 .5c1.1 .4 2.1 1.1 3 1.9s1.5 1.8 1.9 3c.2 .6 .4 1.3 .4 2 7.7 71.9 72.4 128.7 152 128.7S400.4 79.2 408 7.3c.1-.7 .2-1.4 .4-2 .4-1.1 1.1-2.1 1.9-3s1.8-1.5 3-1.9c.8-.3 1.8-.5 2.7-.5s1.8 .2 2.7 .5c1.1 .4 2.2 1.1 3 1.9 .8 .8 1.5 1.8 1.9 3 .2 .6 .4 1.3 .4 2 5.1 48.4 35 90.8 76.3 116.8 3.7 2.4 4.9 7.3 2.5 11s-7.3 4.9-11 2.5C463 119.5 439 93.9 424 63.5l0 192.5 80 0c4.4 0 8 3.6 8 8l0 88c0 3.3-2.1 6.3-5.2 7.5L494.7 364c-28.1 10.5-46.7 37.4-46.7 67.4l0 56.6c0 13.3-10.7 24-24 24l-64 0c-13.3 0-24-10.7-24-24l0-40c0-44.2-35.8-80-80-80s-80 35.8-80 80l0 40c0 13.3-10.7 24-24 24l-64 0c-13.3 0-24-10.7-24-24l0-56.6c0-30-18.6-56.9-46.7-67.4L5.2 359.5C2.1 358.3 0 355.3 0 352l0-88c0-4.4 3.6-8 8-8l80 0zM408 62.2c-16.8 32.7-45.2 59.1-80 74.6l0 119.2 80 0 0-193.8zM312 143c-17.5 5.8-36.4 9-56 9s-38.5-3.2-56-9l0 113 112 0 0-113zm-128-6.2c-34.8-15.5-63.2-41.9-80-74.6l0 193.8 80 0 0-119.2zM16 272l0 74.5 6.9 2.6C57.2 361.9 80 394.8 80 431.4L80 488c0 4.4 3.6 8 8 8l64 0c4.4 0 8-3.6 8-8l0-40c0-53 43-96 96-96s96 43 96 96l0 40c0 4.4 3.6 8 8 8l64 0c4.4 0 8-3.6 8-8l0-56.6c0-36.7 22.8-69.5 57.1-82.4l6.9-2.6 0-74.5-480 0z"]],
    "scale-unbalanced-flip": [640, 512, ["balance-scale-right"], "f516", ["M16.2 272c2.7 20.9 15.5 44.9 35.8 64 20.5 19.2 47.1 32 75.7 32s55.2-12.8 75.7-32c20.3-19 33.1-43.1 35.8-64l-223 0zm384 128c2.7 20.9 15.5 44.9 35.8 64 20.5 19.2 47.1 32 75.7 32s55.2-12.8 75.7-32c20.3-19 33.1-43.1 35.8-64l-223 0z", "M95.8 5.5c-1.4 4.2 .9 8.7 5.1 10.1L255.4 67.1c1.5 31.2 25.4 56.6 55.9 60.4l0 368.5-208 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l216 0c4.4 0 8-3.6 8-8l0-376.5c16.5-2.1 31.1-10.4 41.3-22.7l164.2 54.7c4.2 1.4 8.7-.9 10.1-5.1s-.9-8.7-5.1-10.1L377.4 90.9c3.8-8.2 5.9-17.3 5.9-26.9 0-35.3-28.7-64-64-64-30.8 0-56.5 21.7-62.6 50.7L105.9 .4c-4.2-1.4-8.7 .9-10.1 5.1zM587.3 464c-20.5 19.2-47.1 32-75.7 32s-55.2-12.8-75.7-32c-20.3-19-33.1-43.1-35.8-64l223 0c-2.7 20.9-15.5 44.9-35.8 64zM511.6 209.8L616.2 384 407.1 384 511.6 209.8zM388.2 384.4c-3 5-4.7 10.7-4 16.4 5.8 51.3 60.7 111.2 127.5 111.2s121.7-59.8 127.5-111.2c.7-5.8-1.1-11.5-4.1-16.4L523.7 198.9c-2.6-4.3-7.2-6.9-12.1-6.9s-9.6 2.6-12.1 6.9L388.2 384.4zM239.1 272c-2.7 20.9-15.5 44.9-35.8 64-20.5 19.2-47.1 32-75.7 32S72.4 355.2 52 336c-20.3-19-33.1-43.1-35.8-64l223 0zm-6.9-16L23.1 256 127.6 81.8 232.2 256zM115.5 70.9L4.2 256.4C1.2 261.4-.5 267.1 .1 272.8 6 324.2 60.8 384 127.6 384s121.7-59.8 127.5-111.2c.7-5.8-1.1-11.5-4.1-16.4L139.7 70.9c-2.6-4.3-7.2-6.9-12.1-6.9s-9.6 2.6-12.1 6.9zM319.3 16a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"]],
    "light-switch": [384, 512, [], "e017", ["M16 64l0 384c0 26.5 21.5 48 48 48l256 0c26.5 0 48-21.5 48-48l0-384c0-26.5-21.5-48-48-48L64 16C37.5 16 16 37.5 16 64zm80 80c0-26.5 21.5-48 48-48l96 0c26.5 0 48 21.5 48 48l0 224c0 26.5-21.5 48-48 48l-96 0c-26.5 0-48-21.5-48-48l0-224z", "M64 16C37.5 16 16 37.5 16 64l0 384c0 26.5 21.5 48 48 48l256 0c26.5 0 48-21.5 48-48l0-384c0-26.5-21.5-48-48-48L64 16zM0 64C0 28.7 28.7 0 64 0L320 0c35.3 0 64 28.7 64 64l0 384c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zM112 264l0 104c0 17.7 14.3 32 32 32l96 0c17.7 0 32-14.3 32-32l0-104-160 0zm160-16l0-104c0-17.7-14.3-32-32-32l-96 0c-17.7 0-32 14.3-32 32l0 104 160 0zM96 144c0-26.5 21.5-48 48-48l96 0c26.5 0 48 21.5 48 48l0 224c0 26.5-21.5 48-48 48l-96 0c-26.5 0-48-21.5-48-48l0-224z"]],
    "arrows-to-circle": [512, 512, [], "e4bd", ["M216 256a40 40 0 1 0 80 0 40 40 0 1 0 -80 0z", "M498.3 509.7c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3L347.3 336 440 336c4.4 0 8-3.6 8-8s-3.6-8-8-8l-112 0c-4.4 0-8 3.6-8 8l0 112c0 4.4 3.6 8 8 8s8-3.6 8-8l0-92.7 162.3 162.3zM184 64c-4.4 0-8 3.6-8 8L176 164.7 13.7 2.3C10.5-.8 5.5-.8 2.3 2.3s-3.1 8.2 0 11.3L164.7 176 72 176c-4.4 0-8 3.6-8 8s3.6 8 8 8l112 0c4.4 0 8-3.6 8-8l0-112c0-4.4-3.6-8-8-8zM509.7 2.3c-3.1-3.1-8.2-3.1-11.3 0L336 164.7 336 72c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 112c0 4.4 3.6 8 8 8l112 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-92.7 0 162.3-162.3c3.1-3.1 3.1-8.2 0-11.3zM72 336l92.7 0-162.3 162.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L176 347.3 176 440c0 4.4 3.6 8 8 8s8-3.6 8-8l0-112c0-4.4-3.6-8-8-8L72 320c-4.4 0-8 3.6-8 8s3.6 8 8 8zM256 216a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm0 96a56 56 0 1 0 0-112 56 56 0 1 0 0 112z"]],
    "ampersand": [384, 512, [], "26", ["", "M64 112l0 2.9c0 26.7 10.8 52.2 29.9 70.9l36.5 35.5 55.1-15.5c41.7-11.7 70.5-50 70.5-93.4 0-53.1-43-96.4-96-96.4-53 0-96 43-96 96zM189.8 221.2l-46.2 13 146.8 142.9 64.4-55.2c3.4-2.9 8.4-2.5 11.3 .9s2.5 8.4-.9 11.3l-63.3 54.2 63.6 62c3.2 3.1 3.2 8.1 .2 11.3s-8.1 3.2-11.3 .2l-64.7-63-43.9 37.7C213 464.5 171.2 480 128 480l-1.7 0C56.6 480 0 423.4 0 353.7 0 297 37.6 247.4 92.1 232l20.5-5.8-29.9-29.1C60.5 175.6 48 145.9 48 114.9l0-2.9c0-61.9 50.1-112 112-112 61.9 0 112 50.6 112 112.4 0 50.5-33.6 95.1-82.2 108.8zM128 464c39.4 0 77.5-14.1 107.4-39.7l42.8-36.7-152.4-148.4-29.4 8.3C48.9 260.8 16 304.2 16 353.7 16 414.6 65.4 464 126.3 464l1.7 0z"]],
    "chess-clock": [576, 512, [], "f43d", ["M16 160l0 224c0 26.5 21.5 48 48 48l448 0c26.5 0 48-21.5 48-48l0-224c0-26.5-21.5-48-48-48L64 112c-26.5 0-48 21.5-48 48zM272 272a104 104 0 1 1 -208 0 104 104 0 1 1 208 0zm240 0a104 104 0 1 1 -208 0 104 104 0 1 1 208 0z", "M216 32c4.4 0 8 3.6 8 8s-3.6 8-8 8l-64 0 0 48 360 0 6.5 .3C550.8 99.6 576 126.9 576 160l0 224-.3 6.5c-3.1 30.1-27 54.1-57.1 57.1l-6.5 .3-448 0-6.5-.3c-30.1-3.1-54.1-27-57.1-57.1L0 384 0 160c0-33.1 25.2-60.4 57.5-63.7l6.5-.3 72 0 0-48-64 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l144 0zM64 112c-26.5 0-48 21.5-48 48l0 224c0 26.5 21.5 48 48 48l448 0c26.5 0 48-21.5 48-48l0-224c0-26.5-21.5-48-48-48L64 112zM168 376a104 104 0 1 1 0-208 104 104 0 1 1 0 208zm240 0a104 104 0 1 1 0-208 104 104 0 1 1 0 208zM168 184a88 88 0 1 0 0 176 88 88 0 1 0 0-176zm240 0a88 88 0 1 0 0 176 88 88 0 1 0 0-176zM168 200c4.4 0 8 3.6 8 8l0 64c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-64c0-4.4 3.6-8 8-8zm291.4 33.1c3.8-2.2 8.7-.9 10.9 2.9s.9 8.7-2.9 10.9l-55.4 32c-3.8 2.2-8.7 .9-10.9-2.9s-.9-8.7 2.9-10.9l55.4-32zM488 48c4.4 0 8 3.6 8 8s-3.6 8-8 8L344 64c-4.4 0-8-3.6-8-8s3.6-8 8-8l144 0z"]],
    "envelope": [512, 512, [128386, 9993, 61443], "f0e0", ["M16 119.9c0 12.6 6 24.5 16.1 32L222.6 293.3c19.8 14.7 46.9 14.7 66.7 0L479.9 151.9c10.1-7.5 16.1-19.4 16.1-32 0-22-17.9-39.9-39.9-39.9L55.9 80C33.9 80 16 97.9 16 119.9zM16 159l0 225c0 26.5 21.5 48 48 48l384 0c26.5 0 48-21.5 48-48l0-225c-2 2.1-4.2 4-6.6 5.7L298.9 306.1c-25.5 18.9-60.3 18.9-85.8 0L22.6 164.8C20.2 163 18 161.1 16 159z", "M55.9 64C25 64 0 89 0 119.9L0 384c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-264.1C512 89 487 64 456.1 64L55.9 64zM496 159l0 225c0 26.5-21.5 48-48 48L64 432c-26.5 0-48-21.5-48-48l0-225c2 2.1 4.2 4 6.6 5.7L213.1 306.1c25.5 18.9 60.3 18.9 85.8 0L489.4 164.8c2.4-1.8 4.6-3.7 6.6-5.7zM16 119.9C16 97.9 33.9 80 55.9 80l400.2 0c22 0 39.9 17.9 39.9 39.9 0 12.6-6 24.5-16.1 32L289.4 293.3c-19.8 14.7-46.9 14.7-66.7 0L32.1 151.9C22 144.4 16 132.5 16 119.9z"]],
    "baby": [384, 512, [], "f77c", ["M20.6 153.9c-7.8 10.7-5.4 25.7 5.3 33.5l36.2 26.4c12.7 9.2 26.2 17 40.4 23.3 5.8 2.6 9.5 8.3 9.5 14.6l0 36.3 160 0 0-36.3c0-6.3 3.7-12.1 9.5-14.6 14.2-6.3 27.7-14.1 40.4-23.3l36.2-26.4c10.7-7.8 13.1-22.8 5.3-33.5s-22.8-13.1-33.5-5.3l-36.2 26.4C264.1 196.4 228.5 208 192 208s-72.1-11.6-101.6-33.1L54.1 148.6c-10.7-7.8-25.7-5.4-33.5 5.3zM61.1 409.2c-7.5 9.6-6.6 23.2 1.9 31.7l48 48c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-23-23c-5.7-5.7-6.3-14.8-1.3-21.2l27.8-35.5-38.5-28.9s-33 42.6-48.8 62.8zM136 88a56 56 0 1 0 112 0 56 56 0 1 0 -112 0zm99.7 287.2l27.7 35.6c5 6.4 4.4 15.4-1.3 21.1l-23 23c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l48-48c8.6-8.6 9.4-22.2 2-31.7-15.9-20.4-48.8-62.9-48.8-62.9l-38.5 28.9z", "M222.2 384l-60.2 0-28.7 36.7 23 23c15.6 15.6 15.6 40.9 0 56.6s-40.9 15.6-56.6 0l-48-48c-14.3-14.3-15.7-37-3.2-52.9l47.5-60.8 0-86.9c-15.2-6.7-29.7-15.1-43.3-25L16.5 200.3c-17.9-13-21.8-38-8.8-55.9s38-21.8 55.9-8.8L99.8 162c26.8 19.5 59.1 30 92.2 30s65.4-10.5 92.2-30l36.2-26.4c17.9-13 42.9-9 55.9 8.8s9 42.9-8.8 55.9l-36.2 26.4c-13.6 9.9-28.1 18.2-43.3 25l0 86.6 47.6 61.2c12.4 15.9 11 38.6-3.3 52.8l-48 48c-15.6 15.6-40.9 15.6-56.6 0s-15.6-40.9 0-56.6l23-23-28.5-36.7zm59.3-147c14.2-6.3 27.7-14.1 40.4-23.3l36.2-26.4c10.7-7.8 13.1-22.8 5.3-33.5s-22.8-13.1-33.5-5.3l-36.2 26.4C264.1 196.4 228.5 208 192 208s-72.1-11.6-101.6-33.1L54.1 148.6c-10.7-7.8-25.7-5.4-33.5 5.3s-5.4 25.7 5.3 33.5l36.2 26.4c12.7 9.2 26.2 17 40.4 23.3 5.8 2.6 9.5 8.3 9.5 14.6l0 36.3 160 0 0-36.3c0-6.3 3.7-12.1 9.5-14.6zM112 304l0 24 53.3 40 53.3 0 53.3-40 0-24-160 0zm162.2 42.4l-38.5 28.9 27.7 35.6c5 6.4 4.4 15.4-1.3 21.1l-23 23c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l48-48c8.6-8.6 9.4-22.2 2-31.7-15.9-20.4-48.8-62.9-48.8-62.9zm-164.3 .1s-33 42.6-48.8 62.8c-7.5 9.6-6.6 23.2 1.9 31.7l48 48c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-23-23c-5.7-5.7-6.3-14.8-1.3-21.2l27.8-35.5-38.5-28.9zM120 88a72 72 0 1 1 144 0 72 72 0 1 1 -144 0zm128 0a56 56 0 1 0 -112 0 56 56 0 1 0 112 0z"]],
    "nfc-lock": [576, 512, [], "e1f8", ["M48 96c0-26.5 21.5-48 48-48l320 0c26.5 0 48 21.5 48 48l0 80c-23.8 0-45.9 7.4-64 20.1l0-60.1c0-13.3-10.7-24-24-24l-104 0c-13.3 0-24 10.7-24 24l0 72.7c-22.7 3.8-40 23.6-40 47.3 0 26.5 21.5 48 48 48s48-21.5 48-48c0-23.8-17.3-43.5-40-47.3l0-72.7c0-4.4 3.6-8 8-8l104 0c4.4 0 8 3.6 8 8l0 73.6c-19.8 20.2-32 47.9-32 78.4l0 28.7c-24.3 14.1-41.9 38.5-46.7 67.3L136 384c-4.4 0-8-3.6-8-8l0-240c0-4.4 3.6-8 8-8l48 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-48 0c-13.3 0-24 10.7-24 24l0 240c0 13.3 10.7 24 24 24 56 0 112 0 168-.1l0 64.1-208 0c-26.5 0-48-21.5-48-48L48 96z", "M416 48L96 48C69.5 48 48 69.5 48 96l0 320c0 26.5 21.5 48 48 48l208 0 0 16-208 0c-35.3 0-64-28.7-64-64L32 96c0-35.3 28.7-64 64-64l320 0c35.3 0 64 28.7 64 64l0 81.1c-5.2-.7-10.6-1.1-16-1.1l0-80c0-26.5-21.5-48-48-48zm-16 88l0 60.1c-5.8 4-11.1 8.5-16 13.5l0-73.6c0-4.4-3.6-8-8-8l-104 0c-4.4 0-8 3.6-8 8l0 72.7c22.7 3.8 40 23.6 40 47.3 0 26.5-21.5 48-48 48s-48-21.5-48-48c0-23.8 17.3-43.5 40-47.3l0-72.7c0-13.3 10.7-24 24-24l104 0c13.3 0 24 10.7 24 24zM304 399.9l0 .1-168 0c-13.3 0-24-10.7-24-24l0-240c0-13.3 10.7-24 24-24l48 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-48 0c-4.4 0-8 3.6-8 8l0 240c0 4.4 3.6 8 8 8l169.3 0c-.9 5.2-1.3 10.5-1.3 15.9zM256 224a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm256 64.1c0-26.5-21.5-48-48-48s-48 21.5-48 48l0 63.9 96 0 0-63.9zM368 400l0 96c0 17.7 14.3 32 32 32l128 0c17.7 0 32-14.3 32-32l0-96c0-17.7-14.3-32-32-32l0 .1-128 0 0-.1c-17.7 0-32 14.3-32 32zM528 288.1l0 63.9c26.5 0 48 21.5 48 48l0 96c0 26.5-21.5 48-48 48l-128 0c-26.5 0-48-21.5-48-48l0-96c0-26.5 21.5-48 48-48l0-63.9c0-35.3 28.7-64 64-64s64 28.7 64 64z"]],
    "square-caret-down": [448, 512, ["caret-square-down"], "f150", ["M16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96zM96 217.2c0-13.9 11.3-25.2 25.2-25.2l205.6 0c13.9 0 25.2 11.3 25.2 25.2 0 6.4-2.4 12.5-6.8 17.2L243.3 343.6c-5 5.4-12 8.4-19.3 8.4s-14.3-3-19.3-8.4L102.8 234.4c-4.4-4.7-6.8-10.8-6.8-17.2z", "M64 464c-26.5 0-48-21.5-48-48L16 96c0-26.5 21.5-48 48-48l320 0c26.5 0 48 21.5 48 48l0 320c0 26.5-21.5 48-48 48L64 464zM0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416zm224-64c7.3 0 14.3-3 19.3-8.4L345.2 234.4c4.4-4.7 6.8-10.8 6.8-17.2 0-13.9-11.3-25.2-25.2-25.2l-205.6 0c-13.9 0-25.2 11.3-25.2 25.2 0 6.4 2.4 12.5 6.8 17.2L204.7 343.6c5 5.4 12 8.4 19.3 8.4zm-7.6-19.3L114.5 223.5c-1.6-1.7-2.5-4-2.5-6.3 0-5.1 4.1-9.2 9.2-9.2l205.6 0c5.1 0 9.2 4.1 9.2 9.2 0 2.3-.9 4.6-2.5 6.3L231.6 332.7c-2 2.1-4.7 3.3-7.6 3.3s-5.6-1.2-7.6-3.3z"]],
    "hyphen": [320, 512, [], "2d", ["", "M0 256c0-4.4 3.6-8 8-8l304 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L8 264c-4.4 0-8-3.6-8-8z"]],
    "plane-prop": [576, 512, [], "e22b", ["M16 256c0 10 7.2 18.6 17 20.3l95.8 16.9c10.6 1.9 21.3 2.8 32 2.8L520 296c22.1 0 40-17.9 40-40s-17.9-40-40-40l-359.2 0c-10.7 0-21.4 .9-32 2.8L33.1 235.7C23.2 237.4 16 246 16 256zm34.3-39.6L126 203c.4-.1 .8-.1 1.3-.2l-9-24.6-19-34.2-29.2 0-19.7 72.4zm0 79.2l19.7 72.4 29.2 0 20-36.1 8.5-22.7c-.6-.1-1.2-.2-1.8-.3L50.4 295.6zM192 84c0 6.6 5.4 12 12 12l22.1 0 3.8-24-25.8 0c-6.6 0-12 5.4-12 12zm0 344c0 6.6 5.4 12 12 12l25.8 0-3.8-24-22.1 0c-6.6 0-12 5.4-12 12zm33.9-228l100.2 0-29-184-42.3 0-28.9 184zm0 112l28.9 184 42.3 0 29-184-100.2 0zM322.2 72l3.8 24 62.1 0c6.6 0 12-5.4 12-12s-5.4-12-12-12l-65.8 0zm0 368l65.8 0c6.6 0 12-5.4 12-12s-5.4-12-12-12l-62.1 0-3.8 24z", "M248 0c-3.9 0-7.3 2.9-7.9 6.8L232.3 56 204 56c-15.5 0-28 12.5-28 28s12.5 28 28 28l19.5 0-13.8 88-48.9 0c-4 0-7.9 .1-11.9 .4L111 132.1c-1.4-2.5-4.1-4.1-7-4.1l-40 0c-3.6 0-6.8 2.4-7.7 5.9l-23.3 85.6-2.6 .5C12.8 223 0 238.2 0 256s12.8 33 30.2 36.1l2.6 .5 23.3 85.6c.9 3.5 4.1 5.9 7.7 5.9l40 0c2.9 0 5.6-1.6 7-4.1l37.9-68.2c4 .2 7.9 .4 11.9 .4l48.9 0 13.8 88-19.5 0c-15.5 0-28 12.5-28 28s12.5 28 28 28l28.3 0 7.7 49.2c.6 3.9 4 6.8 7.9 6.8l56 0c3.9 0 7.3-2.9 7.9-6.8l7.7-49.2 48.3 0 0 24c0 4.4 3.6 8 8 8s8-3.6 8-8l0-24 4 0c15.5 0 28-12.5 28-28s-12.5-28-28-28l-4 0 0-24c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 24-39.5 0 13.8-88 177.7 0c30.9 0 56-25.1 56-56s-25.1-56-56-56l-177.7 0-13.8-88 39.5 0 0 24c0 4.4 3.6 8 8 8s8-3.6 8-8l0-24 4 0c15.5 0 28-12.5 28-28s-12.5-28-28-28l-4 0 0-24c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 24-48.3 0-7.7-49.2c-.6-3.9-4-6.8-7.9-6.8L248 0zM131.6 309.9L99.3 368 70.1 368 50.4 295.6 126 309c1.8 .3 3.7 .6 5.5 .9zM99.3 144l32.3 58.1c-1.9 .3-3.7 .6-5.5 .9l-75.7 13.4 19.7-72.4 29.2 0zM325.9 96l-3.8-24 65.8 0c6.6 0 12 5.4 12 12s-5.4 12-12 12l-62.1 0zm.2 104l-100.2 0 28.9-184 42.3 0 29 184zm0 112l-29 184-42.3 0-28.9-184 100.2 0zm-3.9 128l3.8-24 62.1 0c6.6 0 12 5.4 12 12s-5.4 12-12 12l-65.8 0zm-96.1-24l3.8 24-25.8 0c-6.6 0-12-5.4-12-12s5.4-12 12-12l22.1 0zm0-320L204 96c-6.6 0-12-5.4-12-12s5.4-12 12-12l25.8 0-3.8 24zM520 216c22.1 0 40 17.9 40 40s-17.9 40-40 40l-359.2 0c-10.7 0-21.4-.9-32-2.8L33.1 276.3C23.2 274.6 16 266 16 256s7.2-18.6 17-20.3l95.8-16.9c10.6-1.9 21.3-2.8 32-2.8L520 216z"]],
    "tent": [512, 512, [], "e57d", ["M19.6 446.4c-.9 9.4 6.5 17.6 15.9 17.6l212.7 0 0-406.3c-3.6 .8-7.1 2.2-10.3 4.3L64.7 172.7c-12.4 7.9-20.5 21.1-21.9 35.8L19.6 446.4zM264.2 58.2l0 179.4 148.3 226.4 64.4 0c9.5 0 16.8-8.2 15.9-17.6L469.6 208.7c-1.4-14.7-9.6-28-22.1-35.9L272.3 61.9c-2.6-1.6-5.3-2.8-8.1-3.7z", "M42.8 208.5L19.6 446.4c-.9 9.4 6.5 17.6 15.9 17.6l212.7 0 0-406.3c-3.6 .8-7.1 2.2-10.3 4.3L64.7 172.7c-12.4 7.9-20.5 21.1-21.9 35.8zM264.2 58.2l0 179.4 148.3 226.4 64.4 0c9.5 0 16.8-8.2 15.9-17.6L469.6 208.7c-1.4-14.7-9.6-28-22.1-35.9L272.3 61.9c-2.6-1.6-5.3-2.8-8.1-3.7zm0 208.6l0 197.2 129.2 0-129.2-197.2zM3.7 444.9L26.9 206.9c1.9-19.5 12.7-37.1 29.2-47.7L229.3 48.5c15.7-10 35.8-10.1 51.5-.1L456.1 159.3c16.7 10.6 27.5 28.2 29.5 47.8l23.2 237.8c1.8 18.8-12.9 35.1-31.8 35.1L35.5 480c-18.9 0-33.7-16.3-31.8-35.1z"]],
    "chimney": [448, 512, [], "f78b", ["M16 64l0 64c0 8.8 7.2 16 16 16l384 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16L32 48c-8.8 0-16 7.2-16 16zM40 480l128 0c-4.4 0-8-3.6-8-8l0-88-112 0 0 88c0 4.4-3.6 8-8 8zm8-320l0 96 112 0 0-96-112 0zm0 112l0 96 224 0 0-96-224 0zM168 480l240 0c-4.4 0-8-3.6-8-8l0-88-224 0 0 88c0 4.4-3.6 8-8 8zm8-320l0 96 224 0 0-96-224 0zM288 272l0 96 112 0 0-96-112 0z", "M32 48c-8.8 0-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16l384 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16L32 48zM0 64C0 46.3 14.3 32 32 32l384 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l0 312c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-88-224 0 0 88c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-88-112 0 0 88c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-312c-17.7 0-32-14.3-32-32L0 64zm48 96l0 96 112 0 0-96-112 0zm128 0l0 96 224 0 0-96-224 0zm-8 208l104 0 0-96-224 0 0 96 120 0zm120 0l112 0 0-96-112 0 0 96z"]],
    "a": [384, 512, [97], "41", ["", "M199.4 36.9c-1.3-3-4.2-4.9-7.4-4.9s-6.1 1.9-7.4 4.9L.6 468.9c-1.7 4.1 .2 8.8 4.2 10.5s8.8-.2 10.5-4.2L61 368 323 368 368.6 475.1c1.7 4.1 6.4 6 10.5 4.2s6-6.4 4.2-10.5l-184-432zM316.2 352L67.8 352 192 60.4 316.2 352z"]],
    "circle-small": [320, 512, [], "e122", ["M16 256a144 144 0 1 0 288 0 144 144 0 1 0 -288 0z", "M160 112a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm0 304a160 160 0 1 0 0-320 160 160 0 1 0 0 320z"]],
    "parachute-box": [512, 512, [], "f4cd", ["M16.1 208l112.1 0c3-97.6 33.4-180.4 75.9-218.2-100.3 22.7-184.1 109.3-188 218.2zm128.1 0l223.5 0C365.8 145.7 352.3 90.4 332.2 50.1 309.9 5.5 282-16 256-16S202.1 5.5 179.8 50.1c-20.1 40.3-33.6 95.6-35.5 157.9zM176 384l0 64c0 26.5 21.5 48 48 48l64 0c26.5 0 48-21.5 48-48l0-64c0-26.5-21.5-48-48-48l-64 0c-26.5 0-48 21.5-48 48zM307.8-10.2c42.6 37.7 72.9 120.5 75.9 218.2l112.1 0c-3.9-108.8-87.8-195.4-188-218.2z", "M32.3 224l215.7 0 0 96-24 0c-15.8 0-30.2 5.7-41.3 15.1L32.3 224zM248 208l-103.7 0C146.2 145.7 159.7 90.4 179.8 50.1 202.1 5.5 230-16 256-16s53.9 21.5 76.2 66.1c20.1 40.3 33.6 95.6 35.5 157.9L248 208zm16 16l215.7 0-150.4 111.1C318.2 325.7 303.8 320 288 320l-24 0 0-96zM3.2 222.4L171.8 347c-7.4 10.4-11.8 23.2-11.8 37l0 64c0 35.3 28.7 64 64 64l64 0c35.3 0 64-28.7 64-64l0-64c0-13.8-4.4-26.6-11.8-37L508.8 222.4c2-1.5 3.2-3.9 3.2-6.4 0-140.9-124.1-248-256-248S0 75.1 0 216c0 2.5 1.2 4.9 3.2 6.4zM16.1 208c3.9-108.8 87.8-195.4 188-218.2-42.6 37.7-72.9 120.5-75.9 218.2L16.1 208zm367.6 0c-3-97.6-33.4-180.4-75.9-218.2 100.3 22.7 184.1 109.3 188 218.2l-112.1 0zM224 336l64 0c26.5 0 48 21.5 48 48l0 64c0 26.5-21.5 48-48 48l-64 0c-26.5 0-48-21.5-48-48l0-64c0-26.5 21.5-48 48-48z"]],
    "cart-flatbed-boxes": [576, 512, ["dolly-flatbed-alt"], "f475", ["M176 104l0 208c0 13.3 10.7 24 24 24l112 0c13.3 0 24-10.7 24-24l0-208c0-13.3-10.7-24-24-24L200 80c-13.3 0-24 10.7-24 24zm0 360a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zM352 200l0 112c0 13.3 10.7 24 24 24l96 0c13.3 0 24-10.7 24-24l0-112c0-13.3-10.7-24-24-24l-96 0c-13.3 0-24 10.7-24 24zm80 264a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M0 8C0 3.6 3.6 0 8 0L56 0C78.1 0 96 17.9 96 40l0 336c0 22.1 17.9 40 40 40l432 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-68.2 0c7.6 8.5 12.2 19.7 12.2 32 0 26.5-21.5 48-48 48s-48-21.5-48-48c0-12.3 4.6-23.5 12.2-32l-184.4 0c7.6 8.5 12.2 19.7 12.2 32 0 26.5-21.5 48-48 48s-48-21.5-48-48c0-12.3 4.6-23.5 12.2-32L136 432c-30.9 0-56-25.1-56-56L80 40c0-13.3-10.7-24-24-24L8 16c-4.4 0-8-3.6-8-8zM464 432a32 32 0 1 0 0 64 32 32 0 1 0 0-64zM176 464a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zM312 80L200 80c-13.3 0-24 10.7-24 24l0 208c0 13.3 10.7 24 24 24l112 0c13.3 0 24-10.7 24-24l0-208c0-13.3-10.7-24-24-24zm40 88c6.7-5 15-8 24-8l96 0c22.1 0 40 17.9 40 40l0 112c0 22.1-17.9 40-40 40l-96 0c-13.1 0-24.7-6.3-32-16-7.3 9.7-18.9 16-32 16l-112 0c-22.1 0-40-17.9-40-40l0-208c0-22.1 17.9-40 40-40l112 0c22.1 0 40 17.9 40 40l0 64zm0 32l0 112c0 13.3 10.7 24 24 24l96 0c13.3 0 24-10.7 24-24l0-112c0-13.3-10.7-24-24-24l-96 0c-13.3 0-24 10.7-24 24z"]],
    "cart-arrow-down": [640, 512, [], "f218", ["M92.7 31.3l235.3 0 0 133.4-58.3-58.3c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l72 72c3.1 3.1 8.2 3.1 11.3 0l72-72c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0l-58.3 58.3 0-133.4 224.2 0-.2 .7c-3.6 0-7 2.5-7.8 6.2L518.6 216.4C511 248.9 482 272 448.5 272L139.8 272 92.9 32.3c-.1-.4-.1-.7-.2-1zM240 464a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm224 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M0 8C0 3.6 3.6 0 8 0L53.7 0C72.8 0 89.2 13.5 92.9 32.3l46.9 239.7 308.7 0c33.5 0 62.5-23.1 70.1-55.6L560.2 38.2c1-4.3 5.3-7 9.6-6s7 5.3 6 9.6L534.2 220c-9.3 39.8-44.8 68-85.7 68l-305.6 0 9.3 47.7c3.7 18.8 20.1 32.3 39.3 32.3L488 368c4.4 0 8 3.6 8 8s-3.6 8-8 8l-296.5 0c-26.8 0-49.8-19-55-45.2L77.2 35.4C75 24.1 65.1 16 53.7 16L8 16c-4.4 0-8-3.6-8-8zM208 496a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm0-80a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm256 48a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm-80 0a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM330.3 189.7l-72-72c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0L328 164.7 328 8c0-4.4 3.6-8 8-8s8 3.6 8 8l0 156.7 58.3-58.3c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3l-72 72c-3.1 3.1-8.2 3.1-11.3 0z"]],
    "circle-7": [512, 512, [], "e0f4", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zm176-88c0-4.4 3.6-8 8-8l128 0c3 0 5.7 1.6 7.1 4.3s1.2 5.8-.5 8.2l-120 176c-2.5 3.7-7.5 4.6-11.1 2.1s-4.6-7.5-2.1-11.1L312.9 176 200 176c-4.4 0-8-3.6-8-8z", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM200 160c-4.4 0-8 3.6-8 8s3.6 8 8 8l112.9 0-111.5 163.5c-2.5 3.6-1.5 8.6 2.1 11.1s8.6 1.5 11.1-2.1l120-176c1.7-2.4 1.8-5.6 .5-8.2S331 160 328 160l-128 0z"]],
    "lock-hashtag": [384, 512, [], "e423", ["M16 224c0-26.5 21.5-48 48-48l256 0c26.5 0 48 21.5 48 48l0 224c0 26.5-21.5 48-48 48L64 496c-26.5 0-48-21.5-48-48l0-224zm80 72c0 4.4 3.6 8 8 8l40 0 0 64-40 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l40 0 0 40c0 4.4 3.6 8 8 8s8-3.6 8-8l0-40 64 0 0 40c0 4.4 3.6 8 8 8s8-3.6 8-8l0-40 40 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-40 0 0-64 40 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-40 0 0-40c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 40-64 0 0-40c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 40-40 0c-4.4 0-8 3.6-8 8zm64 8l64 0 0 64-64 0 0-64z", "M192-16c61.9 0 112 50.1 112 112l0 64-224 0 0-64C80 34.2 130.1-16 192-16zM64 96l0 64c-35.3 0-64 28.7-64 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-224c0-35.3-28.7-64-64-64l0-64c0-70.7-57.3-128-128-128S64 25.3 64 96zM16 224c0-26.5 21.5-48 48-48l256 0c26.5 0 48 21.5 48 48l0 224c0 26.5-21.5 48-48 48L64 496c-26.5 0-48-21.5-48-48l0-224zm136 16c-4.4 0-8 3.6-8 8l0 40-40 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l40 0 0 64-40 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l40 0 0 40c0 4.4 3.6 8 8 8s8-3.6 8-8l0-40 64 0 0 40c0 4.4 3.6 8 8 8s8-3.6 8-8l0-40 40 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-40 0 0-64 40 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-40 0 0-40c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 40-64 0 0-40c0-4.4-3.6-8-8-8zm8 128l0-64 64 0 0 64-64 0z"]],
    "circle-sterling": [512, 512, [], "e5cf", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zm137.3 99.7l34.1-53.6c8.8-13.9 12.7-30.1 11.4-46.1L168 256c-4.4 0-8-3.6-8-8s3.6-8 8-8l27.6 0c-.4-1.2-.8-2.3-1.2-3.5l-10.2-27.6c-17.3-47 17.5-96.9 67.6-96.9l3.1 0c23.3 0 45.7 9.3 62.2 25.8l8.6 8.6c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-8.6-8.6C292.3 135.6 274 128 254.9 128l-3.1 0c-39 0-66 38.8-52.5 75.4L209.4 231c1.1 3 2 6 2.8 9l99.8 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-97.2 0c1.3 19-3.4 38.2-13.9 54.7L174.6 352 344 352c4.4 0 8 3.6 8 8s-3.6 8-8 8l-184 0c-2.9 0-5.6-1.6-7-4.2s-1.3-5.7 .3-8.1z", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM184.2 208.9l10.2 27.6c.4 1.2 .8 2.3 1.2 3.5L168 240c-4.4 0-8 3.6-8 8s3.6 8 8 8l30.7 0c1.3 16-2.5 32.2-11.4 46.1l-34.1 53.6c-1.6 2.5-1.7 5.6-.3 8.1s4.1 4.2 7 4.2l184 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-169.4 0 26.3-41.3c10.5-16.5 15.2-35.7 13.9-54.7l97.2 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-99.8 0c-.8-3-1.7-6-2.8-9l-10.2-27.6c-13.5-36.6 13.6-75.4 52.5-75.4l3.1 0c19.1 0 37.4 7.6 50.9 21.1l8.6 8.6c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-8.6-8.6c-16.5-16.5-38.9-25.8-62.2-25.8l-3.1 0c-50.1 0-84.9 49.9-67.6 96.9z"]],
    "bridge-circle-exclamation": [576, 512, [], "e4ca", ["M16 160l480 0 0 58.9c-20-7.1-41.6-10.9-64-10.9-59 0-111.8 26.6-147 68.5-9.2-2.9-18.9-4.5-29-4.5-53 0-96 43-96 96l0 88c0 4.4-3.6 8-8 8l-64 0c-4.4 0-8-3.6-8-8l0-120.6c0-36.7-22.8-69.5-57.1-82.4L16 250.5 16 160z", "M8 32c-4.4 0-8 3.6-8 8s3.6 8 8 8l48 0 0 96-48 0c-4.4 0-8 3.6-8 8L0 256c0 3.3 2.1 6.3 5.2 7.5L17.3 268C45.4 278.6 64 305.4 64 335.4L64 456c0 13.3 10.7 24 24 24l64 0c13.3 0 24-10.7 24-24l0-88c0-44.2 35.8-80 80-80 6.4 0 12.6 .7 18.5 2.2 3.3-4.7 6.8-9.3 10.5-13.7-9.2-2.9-18.9-4.5-29-4.5-53 0-96 43-96 96l0 88c0 4.4-3.6 8-8 8l-64 0c-4.4 0-8-3.6-8-8l0-120.6c0-36.7-22.8-69.5-57.1-82.4l-6.9-2.6 0-90.5 480 0 0 58.9c5.4 1.9 10.8 4.1 16 6.5l0-73.4c0-4.4-3.6-8-8-8l-48 0 0-96 48 0c4.4 0 8-3.6 8-8s-3.6-8-8-8L8 32zM440 48l0 96-112 0 0-96 112 0zM312 48l0 96-112 0 0-96 112 0zM184 48l0 96-112 0 0-96 112 0zM304 400a128 128 0 1 1 256 0 128 128 0 1 1 -256 0zm272 0a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zM432 476a12 12 0 1 0 0-24 12 12 0 1 0 0 24zm0-164c-4.4 0-8 3.6-8 8l0 96c0 4.4 3.6 8 8 8s8-3.6 8-8l0-96c0-4.4-3.6-8-8-8z"]],
    "cloud-arrow-up": [576, 512, [62338, "cloud-upload", "cloud-upload-alt"], "f0ee", ["M16 336c0 70.7 57.3 128 128 128l304 0c61.9 0 112-50.1 112-112 0-48-30.2-89-72.8-104.9-2.3-.8-4-2.7-4.8-5s-.4-4.8 .9-6.8c8-12.5 12.7-27.3 12.7-43.2 0-44.2-35.8-80-80-80-17.6 0-33.8 5.7-47 15.2-2 1.4-4.4 1.9-6.8 1.3s-4.3-2.3-5.2-4.5c-19.9-44.8-64.8-76-117-76-70.7 0-128 57.3-128 128 0 9.4 1 18.6 2.9 27.4 .9 4.1-1.6 8.3-5.7 9.4-53.8 15.1-93.3 64.6-93.3 123.2zm194.3-69.7l72-72c3.1-3.1 8.2-3.1 11.3 0l72 72c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L296 219.3 296 376c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-156.7-58.3 58.3c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3z", "M240 32c-79.5 0-144 64.5-144 144 0 8 .7 15.9 1.9 23.5-56.9 19.2-97.9 73-97.9 136.5 0 79.5 64.5 144 144 144l304 0c70.7 0 128-57.3 128-128 0-51.6-30.5-96.1-74.5-116.3 6.7-13.1 10.5-28 10.5-43.7 0-53-43-96-96-96-17.7 0-34.2 4.8-48.4 13.1-24.1-45.8-72.2-77.1-127.6-77.1zM112 176c0-70.7 57.3-128 128-128 52.2 0 97.1 31.2 117 76 1 2.2 2.9 3.9 5.2 4.5s4.8 .2 6.8-1.3c13.2-9.6 29.4-15.2 47-15.2 44.2 0 80 35.8 80 80 0 15.9-4.7 30.8-12.7 43.2-1.3 2-1.6 4.6-.9 6.8s2.5 4.1 4.8 5C529.8 263 560 304 560 352 560 413.9 509.9 464 448 464l-304 0c-70.7 0-128-57.3-128-128 0-58.6 39.5-108.1 93.3-123.2 4.1-1.1 6.6-5.3 5.7-9.4-1.9-8.8-2.9-18-2.9-27.4zm181.7 18.3c-3.1-3.1-8.2-3.1-11.3 0l-72 72c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L280 219.3 280 376c0 4.4 3.6 8 8 8s8-3.6 8-8l0-156.7 58.3 58.3c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-72-72z"]],
    "at": [512, 512, [61946], "40", ["", "M256 16C123.5 16 16 123.5 16 256S123.5 496 256 496c4.4 0 8 3.6 8 8s-3.6 8-8 8C114.6 512 0 397.4 0 256S114.6 0 256 0 512 114.6 512 256l0 20c0 46.4-37.6 84-84 84-36.8 0-68.1-23.6-79.4-56.6-17.2 33.6-52.2 56.6-92.6 56.6-57.4 0-104-46.6-104-104s46.6-104 104-104c37.1 0 69.6 19.4 88 48.5l0-32.5c0-4.4 3.6-8 8-8s8 3.6 8 8l0 108c0 37.6 30.4 68 68 68s68-30.4 68-68l0-20C496 123.5 388.5 16 256 16zm88 240a88 88 0 1 0 -176 0 88 88 0 1 0 176 0z"]],
    "indian-rupee-sign": [320, 512, ["indian-rupee", "inr"], "e1bc", ["", "M0 40c0-4.4 3.6-8 8-8l104 0c2.2 0 4.3 0 6.5 .1 .5-.1 1-.1 1.5-.1l192 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L178 48c44.1 22.8 74.9 67.7 77.7 120l56.2 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-56.2 0c-4.2 75.8-66.9 136-143.8 136l-77.6 0 218 145.3c3.7 2.5 4.7 7.4 2.2 11.1s-7.4 4.7-11.1 2.2l-240-160c-2.9-2-4.2-5.6-3.2-9S4.5 304 8 304l104 0c68 0 123.6-53 127.8-120L8 184c-4.4 0-8-3.6-8-8s3.6-8 8-8l231.8 0C235.6 101 180 48 112 48L8 48c-4.4 0-8-3.6-8-8z"]],
    "truck": [576, 512, [128666, 9951], "f0d1", ["M16 96l0 288c0 26.5 21.5 48 48 48l.4 0c-.2-2.6-.4-5.3-.4-8 0-48.6 39.4-88 88-88s88 39.4 88 88c0 2.7-.1 5.4-.4 8l96.7 0c-.2-2.6-.4-5.3-.4-8 0-40.3 27.1-74.2 64-84.7L400 96c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96zM416 272l0 64.4c2.6-.2 5.3-.4 8-.4 48.6 0 88 39.4 88 88 0 2.7-.1 5.4-.4 8l.4 0c26.5 0 48-21.5 48-48l0-112-144 0z", "M64 48C37.5 48 16 69.5 16 96l0 288c0 26.5 21.5 48 48 48l.4 0c-.2-2.6-.4-5.3-.4-8 0-48.6 39.4-88 88-88s88 39.4 88 88c0 2.7-.1 5.4-.4 8l96.7 0c-.2-2.6-.4-5.3-.4-8 0-40.3 27.1-74.2 64-84.7L400 96c0-26.5-21.5-48-48-48L64 48zm3.3 400L64 448c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l288 0c35.3 0 64 28.7 64 64l0 32 53.5 0c19.1 0 37.4 7.6 50.9 21.1l34.5 34.5c13.5 13.5 21.1 31.8 21.1 50.9L576 384c0 35.3-28.7 64-64 64l-3.3 0c-10.4 36.9-44.4 64-84.7 64s-74.2-27.1-84.7-64l-102.6 0c-10.4 36.9-44.4 64-84.7 64s-74.2-27.1-84.7-64zM416 256l144 0 0-21.5c0-14.9-5.9-29.1-16.4-39.6l-34.5-34.5c-10.5-10.5-24.7-16.4-39.6-16.4l-53.5 0 0 112zm0 16l0 64.4c2.6-.2 5.3-.4 8-.4 48.6 0 88 39.4 88 88 0 2.7-.1 5.4-.4 8l.4 0c26.5 0 48-21.5 48-48l0-112-144 0zM152 496a72 72 0 1 0 0-144 72 72 0 1 0 0 144zm272 0a72 72 0 1 0 0-144 72 72 0 1 0 0 144z"]],
    "game-console-handheld-crank": [576, 512, [], "e5b9", ["M16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96zm48 32c0-17.7 14.3-32 32-32l256 0c17.7 0 32 14.3 32 32l0 112c0 17.7-14.3 32-32 32L96 272c-17.7 0-32-14.3-32-32l0-112zm0 240c0-4.4 3.6-8 8-8l32 0 0-32c0-4.4 3.6-8 8-8s8 3.6 8 8l0 32 32 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-32 0 0 32c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-32-32 0c-4.4 0-8-3.6-8-8zm208-16a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm80 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM496 152l0 40 55.9 0c4.4 0 8-3.6 8-8l0-32c0-4.4-3.6-8-8-8L504 144c-4.4 0-8 3.6-8 8z", "M384 48L64 48C37.5 48 16 69.5 16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48zm64 48l0 176 32 0 0-120c0-13.3 10.7-24 24-24l47.9 0c13.3 0 24 10.7 24 24l0 32c0 13.3-10.7 24-24 24l-55.9 0 0 72c0 4.4-3.6 8-8 8l-40 0 0 128c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64zm-96 16L96 112c-8.8 0-16 7.2-16 16l0 112c0 8.8 7.2 16 16 16l256 0c8.8 0 16-7.2 16-16l0-112c0-8.8-7.2-16-16-16zM96 96l256 0c17.7 0 32 14.3 32 32l0 112c0 17.7-14.3 32-32 32L96 272c-17.7 0-32-14.3-32-32l0-112c0-17.7 14.3-32 32-32zm24 232l0 32 32 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-32 0 0 32c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-32-32 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l32 0 0-32c0-4.4 3.6-8 8-8s8 3.6 8 8zm120 8a16 16 0 1 0 0 32 16 16 0 1 0 0-32zm32 16a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm32 0a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm16 32a32 32 0 1 1 0-64 32 32 0 1 1 0 64zM504 144c-4.4 0-8 3.6-8 8l0 40 55.9 0c4.4 0 8-3.6 8-8l0-32c0-4.4-3.6-8-8-8L504 144z"]],
    "chalkboard-user": [640, 512, ["chalkboard-teacher"], "f51c", ["M144 96c0-26.5 21.5-48 48-48l352 0c26.5 0 48 21.5 48 48l0 288c0 26.5-21.5 48-48 48l-32 0 0-48c0-17.7-14.3-32-32-32l-96 0c-17.7 0-32 14.3-32 32l0 48-23.4 0c-13.1-38.9-42.7-70.2-80.5-85.6 15-21 23.8-46.7 23.8-74.4 0-70.7-57.3-128-128-128l0-48z", "M192 48l352 0c26.5 0 48 21.5 48 48l0 288c0 26.5-21.5 48-48 48l-32 0 0-48c0-17.7-14.3-32-32-32l-96 0c-17.7 0-32 14.3-32 32l0 48-23.4 0c1.8 5.2 3.2 10.5 4.4 16l211 0c35.3 0 64-28.7 64-64l0-288c0-35.3-28.7-64-64-64L192 32c-35.3 0-64 28.7-64 64l0 49c5.2-.7 10.6-1 16-1l0-48c0-26.5 21.5-48 48-48zM496 384l0 48-128 0 0-48c0-8.8 7.2-16 16-16l96 0c8.8 0 16 7.2 16 16zM144 216a56 56 0 1 1 0 112 56 56 0 1 1 0-112zm0 128a72 72 0 1 0 0-144 72 72 0 1 0 0 144zM0 480l0 24c0 4.4 3.6 8 8 8s8-3.6 8-8l0-24c0-44.2 35.8-80 80-80l96 0c44.2 0 80 35.8 80 80l0 24c0 4.4 3.6 8 8 8s8-3.6 8-8l0-24c0-53-43-96-96-96l-96 0c-53 0-96 43-96 96z"]],
    "user-check": [640, 512, [], "f4fc", ["M40.1 512c4.4 0 8-3.6 8-8l0-24c0-88.4 71.6-160 160-160l96 0c88.4 0 160 71.6 160 160l0 24c0 4.4 3.6 8 8 8l-432 0zm328-384a112 112 0 1 1 -224 0 112 112 0 1 1 224 0z", "M304.1 304c97.2 0 176 78.8 176 176l0 24c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-24c0-88.4-71.6-160-160-160l-96 0c-88.4 0-160 71.6-160 160l0 24c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-24c0-97.2 78.8-176 176-176l96 0zM609.8 99.7c2.6-3.6 7.6-4.3 11.2-1.7s4.3 7.6 1.8 11.2L509 265.5c-1.4 1.9-3.6 3.1-5.9 3.3s-4.7-.7-6.3-2.4l-62.3-64.5c-3.1-3.2-3-8.2 .2-11.3s8.2-3 11.3 .2l55.7 57.6 108.1-148.7zM256.1 256a128 128 0 1 1 0-256 128 128 0 1 1 0 256zm0-240a112 112 0 1 0 0 224 112 112 0 1 0 0-224z"]],
    "chart-pie-simple-circle-currency": [640, 512, [], "e604", ["M48 272c0-109.5 78.6-200.6 182.4-220.1 .5-.1 1-.2 1.5-.3 1 0 1.9 0 2.8 .1 2.9 .8 5.3 3.5 5.3 7.3l0 205c0 22.1 17.9 40 40 40l49.7 0c-16.3 28.2-25.7 61-25.7 96 0 32.3 8 62.7 22.1 89.4-17.3 4.3-35.4 6.6-54.1 6.6-123.7 0-224-100.3-224-224z", "M333.8 18c99.8 13.3 179 92.4 192.2 192.2l0 .2c5.4 .9 10.8 1.9 16 3.2 .1-1.8 .1-3.6-.2-5.5-14.2-107-99-191.7-206-206-17.5-2.3-31.9 12.2-31.9 29.9l0 176c0 17.7 14.3 32 32 32l53.8 0c9.2-6.1 19-11.5 29.3-16L336 224c-8.8 0-16-7.2-16-16l0-176c0-9.5 7.3-14.9 13.8-14zM272 512c21.6 0 42.5-2.9 62.4-8.2-3-4.7-5.8-9.4-8.4-14.4-17.3 4.3-35.4 6.6-54.1 6.6-123.7 0-224-100.3-224-224 0-110 79.3-201.5 183.9-220.4 4-.7 8.1 2.4 8.1 7.4l0 205c0 22.1 17.9 40 40 40l49.7 0c3.2-5.5 6.6-10.9 10.3-16l-60 0c-13.3 0-24-10.7-24-24l0-205c0-14-12.3-25.8-27-23.1-112 20.3-197 118.3-197 236.2 0 132.5 107.5 240 240 240zM496 272a128 128 0 1 1 0 256 128 128 0 1 1 0-256zm0 272a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm0-192a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm50.6 87.2C555 428.4 560 414.8 560 400s-5-28.4-13.4-39.2l19.1-19.1c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0l-19.1 19.1C524.4 341 510.8 336 496 336s-28.4 5-39.2 13.4l-19.1-19.1c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l19.1 19.1C437 371.6 432 385.2 432 400s5 28.4 13.4 39.2l-19.1 19.1c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l19.1-19.1C467.6 459 481.2 464 496 464s28.4-5 39.2-13.4l19.1 19.1c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-19.1-19.1z"]],
    "face-fearful": [512, 512, [], "e375", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zm216-32a72 72 0 1 1 -144 0 72 72 0 1 1 144 0zM94.7 130.7c26.1-29.1 63.2-48.2 104.9-50.4 4.4-.2 8.2 3.1 8.4 7.6s-3.1 8.2-7.6 8.4c-37.2 2-70.5 19-93.8 45.1-2.9 3.3-8 3.6-11.3 .6s-3.6-8-.6-11.3zM168 403.8c0-46.3 37.5-83.8 83.8-83.8l8.4 0c46.3 0 83.8 37.5 83.8 83.8 0 6.7-5.5 12.2-12.2 12.2l-151.6 0c-6.7 0-12.2-5.5-12.2-12.2zM424 224a72 72 0 1 1 -144 0 72 72 0 1 1 144 0zM312 87.5c.3-4.4 4.1-7.8 8.5-7.5 36.7 2.3 69.6 18.6 93.3 43.7 3 3.2 2.9 8.3-.3 11.3s-8.3 2.9-11.3-.3c-21.1-22.2-50.2-36.7-82.7-38.7-4.4-.3-7.8-4.1-7.5-8.5z", "M496 256a240 240 0 1 0 -480 0 240 240 0 1 0 480 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm251.8 64l8.4 0c46.3 0 83.8 37.5 83.8 83.8 0 6.7-5.5 12.2-12.2 12.2l-151.6 0c-6.7 0-12.2-5.5-12.2-12.2 0-46.3 37.5-83.8 83.8-83.8zm8.4 16l-8.4 0c-36.2 0-65.7 28.3-67.7 64l143.8 0c-2-35.7-31.5-64-67.7-64zM144 224a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm208-16a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM312 87.5c.3-4.4 4.1-7.8 8.5-7.5 36.7 2.3 69.6 18.6 93.3 43.7 3 3.2 2.9 8.3-.3 11.3s-8.3 2.9-11.3-.3c-21.1-22.2-50.2-36.7-82.7-38.7-4.4-.3-7.8-4.1-7.5-8.5zM200.4 96.2c-37.2 2-70.5 19-93.8 45.1-2.9 3.3-8 3.6-11.3 .6s-3.6-8-.6-11.3c26.1-29.1 63.2-48.2 104.9-50.4 4.4-.2 8.2 3.1 8.4 7.6s-3.1 8.2-7.6 8.4zM160 168a56 56 0 1 0 0 112 56 56 0 1 0 0-112zm72 56a72 72 0 1 1 -144 0 72 72 0 1 1 144 0zm64 0a56 56 0 1 0 112 0 56 56 0 1 0 -112 0zm56 72a72 72 0 1 1 0-144 72 72 0 1 1 0 144z"]],
    "user-ninja": [448, 512, [129399], "f504", ["M8 512c4.4 0 8-3.6 8-8l0-24c0-76.3 53.4-140.1 124.8-156.1 53.4 67.4 100.4 126.7 140.9 177.8 2.7 3.5 7.8 4 11.2 1.3s4-7.8 1.3-11.2l-60.1-75.8 73-92.1C378.6 339.9 432 403.7 432 480l0 24c0 4.4 3.6 8 8 8L8 512zM116.6 160l214.7 0c-13.8 46.3-56.6 80-107.4 80s-93.6-33.7-107.4-80zm6.1-80c18-37.8 56.5-64 101.2-64s83.2 26.2 101.2 64L122.8 80z", "M334.9 144l-221.7 0c-.7-5.2-1.1-10.6-1.1-16 0-11.1 1.6-21.9 4.6-32l214.7 0c3 10.1 4.6 20.9 4.6 32 0 5.4-.4 10.8-1.1 16zM224 16c44.7 0 83.2 26.2 101.2 64L122.8 80c18-37.8 56.5-64 101.2-64zM116.6 160l214.7 0c-13.8 46.3-56.6 80-107.4 80s-93.6-33.7-107.4-80zM224 256c70.7 0 128-57.3 128-128S294.7 0 224 0C164.2 0 113.9 41.1 99.9 96.6L61.7 58.3c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3L92.7 112 50.3 154.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L96 131.3C97.8 200.5 154.4 256 224 256zm-83.2 67.9c53.4 67.4 100.4 126.7 140.9 177.8 2.7 3.5 7.8 4 11.2 1.3s4-7.8 1.3-11.2l-60.1-75.8 73-92.1C378.6 339.9 432 403.7 432 480l0 24c0 4.4 3.6 8 8 8s8-3.6 8-8l0-24c0-85.7-61.3-157.2-142.5-172.8-2.9-.6-5.9 .6-7.8 2.9l-73.7 93-73.7-93c-1.2-1.5-2.8-2.5-4.6-2.9-.6-.1-1.2-.2-1.8-.2-.5 0-1 .1-1.5 .2-81.1 15.7-142.3 87.1-142.3 172.8l0 24c0 4.4 3.6 8 8 8s8-3.6 8-8l0-24c0-76.3 53.4-140.1 124.8-156.1z"]],
    "frame": [512, 512, [], "e495", ["M80 80l0 352 352 0 0-352-352 0z", "M512 72c0-4.4-3.6-8-8-8l-56 0 0-56c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 56-352 0 0-56c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 56-56 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l56 0 0 352-56 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l56 0 0 56c0 4.4 3.6 8 8 8s8-3.6 8-8l0-56 352 0 0 56c0 4.4 3.6 8 8 8s8-3.6 8-8l0-56 56 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-56 0 0-352 56 0c4.4 0 8-3.6 8-8zm-80 8l0 352-352 0 0-352 352 0z"]],
    "plant-wilt": [512, 512, [], "e5aa", ["M16 331.1c0 9.9 4.8 25.7 15.6 44.5 9.2 16.1 22.2 33.1 38.1 48.7l7 6.6c.7 .6 1.8 1.1 3.3 1.1 .7 0 1.4-.1 1.9-.3l1.3-.8c19.1-17.3 34.6-37 45.1-55.3 10.8-18.8 15.6-34.6 15.6-44.5 0-39.2-26.5-67.1-64-67.1s-64 27.8-64 67.1zm352-160c0 9.9 4.8 25.7 15.6 44.5 9.2 16.1 22.2 33.1 38.1 48.7l7 6.6c.7 .6 1.8 1.1 3.3 1.1 .7 0 1.4-.1 1.9-.3l1.3-.8c19.1-17.3 34.6-37 45.1-55.3 10.8-18.8 15.6-34.6 15.6-44.5 0-39.2-26.5-67.1-64-67.1s-64 27.8-64 67.1z", "M344-32c53 0 96 43 96 96l0 24.4 .7 0c39.6 3.8 67.4 33.9 71 73.9l.4 8.7c0 26.2-22.3 69-58.5 104.6l-7.5 7c-3.8 3.5-8.8 5.3-14 5.3l-3.8-.3c-3.8-.7-7.3-2.3-10.2-4.9-40.7-36.8-66-83.7-66-111.7l.4-8.7c3.6-40.3 31.7-70.4 71.6-74L424 64c0-44.2-35.8-80-80-80s-80 35.8-80 80l0 472c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-344c0-44.2-35.8-80-80-80s-80 35.8-80 80l0 56.2 0 .1 .7 .1c39.6 3.8 67.4 33.9 71 73.9l.4 8.7c0 26.2-22.3 69-58.5 104.6l-7.5 7c-3.8 3.5-8.8 5.3-14 5.3l-3.8-.3c-3.8-.7-7.3-2.3-10.2-4.9-40.7-36.8-66-83.7-66-111.7l.4-8.7c3.6-40.3 31.7-70.4 71.6-74L72 192c0-53 43-96 96-96 33.4 0 62.8 17.1 80 43l0-75c0-53 43-96 96-96zM80 264c-37.5 0-64 27.8-64 67.1 0 9.9 4.8 25.7 15.6 44.5 9.2 16.1 22.2 33.1 38.1 48.7l7 6.6c.7 .6 1.8 1.1 3.3 1.1 .7 0 1.4-.1 1.9-.3l1.3-.8c19.1-17.3 34.6-37 45.1-55.3 10.8-18.8 15.6-34.6 15.6-44.5 0-39.2-26.5-67.1-64-67.1zM432 104c-37.5 0-64 27.8-64 67.1 0 9.9 4.8 25.7 15.6 44.5 9.2 16.1 22.2 33.1 38.1 48.7l7 6.6c.7 .6 1.8 1.1 3.3 1.1 .7 0 1.4-.1 1.9-.3l1.3-.8c19.1-17.3 34.6-37 45.1-55.3 10.8-18.8 15.6-34.6 15.6-44.5 0-39.2-26.5-67.1-64-67.1z"]],
    "weight-scale": [448, 512, ["weight"], "f496", ["M16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48l-52.7 0c22.8 25.5 36.7 59.1 36.7 96 0 22-4.9 42.8-13.7 61.4-5.7 12.1-18.5 18.6-31.9 18.6l-196.8 0c-13.3 0-26.2-6.5-31.9-18.6-8.8-18.6-13.7-39.5-13.7-61.4 0-36.9 13.9-70.5 36.7-96L64 48C37.5 48 16 69.5 16 96z", "M339.8 198.6c7.8-16.5 12.2-35 12.2-54.6 0-70.7-57.3-128-128-128S96 73.3 96 144c0 19.6 4.4 38.1 12.2 54.6 2.5 5.3 8.8 9.4 17.4 9.4l92.6 0 30.2-90.5c1.4-4.2 5.9-6.5 10.1-5.1s6.5 5.9 5.1 10.1l-28.5 85.5 87.3 0c8.6 0 14.9-4.1 17.4-9.4zm14.5 6.8c-5.7 12.1-18.5 18.6-31.9 18.6l-196.8 0c-13.3 0-26.2-6.5-31.9-18.6-8.8-18.6-13.7-39.5-13.7-61.4 0-36.9 13.9-70.5 36.7-96L64 48C37.5 48 16 69.5 16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48l-52.7 0c22.8 25.5 36.7 59.1 36.7 96 0 22-4.9 42.8-13.7 61.4zM64 32l69.5 0C158.2 12 189.7 0 224 0s65.8 12 90.5 32L384 32c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32z"]],
    "farm": [576, 512, ["barn-silo"], "f864", ["M16 80l0 32 122.8 0c10.3-18.5 26.3-33.3 45.8-42.1 7.1-3.2 14.3-6.4 21.4-9.6-9.1-43.6-47.7-76.3-94-76.3-53 0-96 43-96 96zm0 48l0 320c0 26.5 21.5 48 48 48l53.5 0c-3.5-10-5.5-20.8-5.5-32l0-134c-19.4-13.8-32-36.4-32-62 0-9.9 1.9-19.8 5.7-29 15.2-37 30.5-74 45.7-111L16 128zM144 268c0 6.6 5.4 12 12 12l12 0c4.4 0 8 3.6 8 8l0 176c0 17.7 14.3 32 32 32l64 0 0-104c0-30.9 25.1-56 56-56l48 0c30.9 0 56 25.1 56 56l0 104 64 0c17.7 0 32-14.3 32-32l0-176c0-4.4 3.6-8 8-8l12 0c6.6 0 12-5.4 12-12 0-1.6-.3-3.1-.9-4.6l-48-116.6c-3.4-8.2-9.8-14.9-17.9-18.5L366.3 71.2c-9.1-4.1-19.5-4.1-28.6 0L210.8 128.3c-8.1 3.7-14.5 10.3-17.9 18.5l-48 116.6c-.6 1.5-.9 3-.9 4.6zm144-76c0-17.7 14.3-32 32-32l64 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-64z", "M206 60.3C196.9 16.7 158.3-16 112-16 59-16 16 27 16 80l0 32 122.8 0c-1.9 3.4-3.6 6.9-5 10.4l-2.3 5.6-115.4 0 0 320c0 26.5 21.5 48 48 48l53.5 0c2 5.6 4.5 10.9 7.4 16L64 512c-35.3 0-64-28.7-64-64L0 80C0 18.1 50.1-32 112-32 164.8-32 209 4.5 220.9 53.6L206 60.3zM337.7 71.2L210.8 128.3c-8.1 3.7-14.5 10.3-17.9 18.5l-48 116.6c-.6 1.5-.9 3-.9 4.6 0 6.6 5.4 12 12 12l12 0c4.4 0 8 3.6 8 8l0 176c0 17.7 14.3 32 32 32l64 0 0-104c0-30.9 25.1-56 56-56l48 0c30.9 0 56 25.1 56 56l0 104 64 0c17.7 0 32-14.3 32-32l0-176c0-4.4 3.6-8 8-8l12 0c6.6 0 12-5.4 12-12 0-1.6-.3-3.1-.9-4.6l-48-116.6c-3.4-8.2-9.8-14.9-17.9-18.5L366.3 71.2c-9.1-4.1-19.5-4.1-28.6 0zM496 512l-288 0c-26.5 0-48-21.5-48-48l0-168-4 0c-15.5 0-28-12.6-28-28 0-3.7 .7-7.3 2.1-10.7l48-116.6c4.9-12 14.3-21.7 26.2-27L331.1 56.6c13.3-6 28.5-6 41.7 0l126.9 57.1c11.8 5.3 21.2 15 26.2 27l48 116.6c1.4 3.4 2.1 7 2.1 10.7 0 15.5-12.6 28-28 28l-4 0 0 168c0 26.5-21.5 48-48 48zM416 392c0-22.1-17.9-40-40-40l-48 0c-22.1 0-40 17.9-40 40l0 104 128 0 0-104zM320 176c-8.8 0-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16l64 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16l-64 0zm-32 16c0-17.7 14.3-32 32-32l64 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-64z"]],
    "caret-right": [256, 512, [], "f0da", ["M80.3 128l0 256c0 6.5 3.9 12.3 9.9 14.8s12.9 1.1 17.4-3.5l128-128c5.8-5.8 6.2-15.5-.5-23.1L107.6 116.7c-4.6-4.6-11.5-5.9-17.4-3.5s-9.9 8.3-9.9 14.8z", "M246.9 233.4c11.6 12.9 12.8 32.4 0 45.2l-128 128c-9.1 9.2-22.9 11.9-34.9 6.9l-4.3-2.2c-9.5-5.7-15.5-16.1-15.5-27.4l0-256 .3-4.8c1.4-9.4 7-17.7 15.1-22.6l4.3-2.2c10.5-4.3 22.3-2.8 31.2 3.8l3.7 3.1 128 128zm-11.3 33.9c5.8-5.8 6.2-15.5-.5-23.1L107.6 116.7c-4.6-4.6-11.5-5.9-17.4-3.5s-9.9 8.3-9.9 14.8l0 256c0 6.5 3.9 12.3 9.9 14.8s12.9 1.1 17.4-3.5l128-128z"]],
    "hexagon-divide": [576, 512, [], "e1ad", ["M47.4 228.2c-9.8 17.2-9.9 38.3-.1 55.5 32.1 56.1 64.2 112.2 96.3 168.2 9.9 17.3 28.2 28 48 28.2 .2 0 .4 0 .6 0l191.6 0c.2 0 .4 0 .6 0 19.7-.2 37.9-10.8 47.8-27.9 .1-.1 .1-.2 .2-.3l96.2-168.1c9.9-17.4 9.8-38.5 0-55.6L432.4 60.2C422.5 42.8 403.9 32 383.8 32L192.2 32c-20.1 0-38.6 10.8-48.6 28.2-32.1 56-64.1 112-96.2 168.1zM176 256c0-4.4 3.6-8 8-8l208 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-208 0c-4.4 0-8-3.6-8-8zm144-96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm0 192a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M47.4 283.9l96.2 168.1c10 17.4 28.5 28.2 48.6 28.2l191.6 0c20.1 0 38.6-10.8 48.6-28.2l96.2-168.1c9.9-17.2 9.9-38.4 0-55.6L432.4 60.2C422.5 42.8 403.9 32 383.8 32L192.2 32c-20.1 0-38.6 10.8-48.6 28.2L47.4 228.2c-9.9 17.2-9.9 38.4 0 55.6zm-13.9 7.9c-12.7-22.2-12.7-49.4 0-71.5L129.7 52.2C142.5 29.8 166.4 16 192.2 16l191.6 0c25.8 0 49.7 13.8 62.5 36.2l96.2 168.1c12.7 22.2 12.7 49.4 0 71.5L446.3 459.9c-12.8 22.4-36.7 36.2-62.5 36.2l-191.6 0c-25.8 0-49.7-13.8-62.5-36.2L33.5 291.8zM304 160a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm-48 0a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm-72 88l208 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-208 0c-4.4 0-8-3.6-8-8s3.6-8 8-8zM288 368a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm0-48a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]],
    "florin-sign": [384, 512, [], "e184", ["", "M323 32c-29.3 0-55.6 17.7-66.7 44.8L189.9 240 40 240c-4.4 0-8 3.6-8 8s3.6 8 8 8l143.4 0-70.5 173.1C104.2 450.2 83.7 464 61 464L8 464c-4.4 0-8 3.6-8 8s3.6 8 8 8l53 0c29.3 0 55.6-17.7 66.7-44.8l73-179.2 143.4 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-136.8 0 64-157.1C279.8 61.8 300.3 48 323 48l53 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-53 0z"]],
    "lightbulb-exclamation-on": [640, 512, [], "e1ca", ["M144 192c0 46.9 18.4 89.5 48.3 121.1 21.7 22.9 42.3 52.4 46.8 86.9l161.8 0c4.4-34.5 25-64 46.8-86.9 29.9-31.6 48.3-74.1 48.3-121.1 0-97.2-78.8-176-176-176S144 94.8 144 192zm96 224l0 16c0 35.3 28.7 64 64 64l32 0c33.1 0 60.4-25.2 63.7-57.5l.3-6.5 0-16-160 0zm96-104a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zM305.9 102.7C305.5 94.7 312 88 320 88l2.9 .3c6.6 1.4 11.5 7.4 11.2 14.4L328 248.3c-.2 4.3-3.7 7.7-8 7.7s-7.8-3.4-8-7.7l-6.1-145.6z", "M320 0c106 0 192 86 192 192 0 51.2-20 97.7-52.7 132.1l-8.6 9.6c-19.6 22.9-34.7 50-34.7 80l0 18.4c0 44.2-35.8 80-80 80l-32 0c-44.2 0-80-35.8-80-80l0-18.4c0-34.3-19.7-64.7-43.3-89.6-32.6-34.4-52.7-80.9-52.7-132.1 0-106 86-192 192-192zM240 432c0 35.3 28.7 64 64 64l32 0c33.1 0 60.4-25.2 63.7-57.5l.3-6.5 0-16-160 0 0 16zM320 16c-97.2 0-176 78.8-176 176 0 46.9 18.4 89.5 48.3 121.1 21.7 22.9 42.3 52.4 46.8 86.9l161.8 0c4.4-34.5 25-64 46.8-86.9 29.9-31.6 48.3-74.1 48.3-121.1 0-97.2-78.8-176-176-176zM75.6 313.3c3.7-2.5 8.6-1.5 11.1 2.2s1.5 8.6-2.2 11.1l-48 32c-3.7 2.5-8.6 1.5-11.1-2.2s-1.5-8.6 2.2-11.1l48-32zm477.8 2.2c2.5-3.7 7.4-4.7 11.1-2.2l48 32c3.7 2.5 4.7 7.4 2.2 11.1s-7.4 4.7-11.1 2.2l-48-32c-3.7-2.5-4.7-7.4-2.2-11.1zM320 328a16 16 0 1 1 0-32 16 16 0 1 1 0 32zm2.9-239.7c6.6 1.4 11.5 7.4 11.2 14.4L328 248.3c-.2 4.3-3.7 7.7-8 7.7s-7.8-3.4-8-7.7l-6.1-145.6C305.5 94.7 312 88 320 88l2.9 .3zM64 184c4.4 0 8 3.6 8 8s-3.6 8-8 8l-48 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l48 0zm560 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-48 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l48 0zM25.3 27.6c2.5-3.7 7.4-4.7 11.1-2.2l48 32c3.7 2.5 4.7 7.4 2.2 11.1s-7.4 4.7-11.1 2.2l-48-32c-3.7-2.5-4.7-7.4-2.2-11.1zm578.2-2.2c3.7-2.5 8.6-1.5 11.1 2.2s1.5 8.6-2.2 11.1l-48 32c-3.7 2.5-8.6 1.5-11.1-2.2s-1.5-8.6 2.2-11.1l48-32z"]],
    "bell": [448, 512, [128276, 61602], "f0f3", ["M16 379.2c0 11.5 9.3 20.8 20.8 20.8l374.3 0c11.5 0 20.8-9.3 20.8-20.8 0-4.1-1.2-8.1-3.5-11.6L405.4 333C381 296.4 368 253.4 368 209.4l0-17.4c0-79.5-64.5-144-144-144S80 112.5 80 192l0 17.4c0 44-13 87-37.4 123.6L19.5 367.6C17.2 371 16 375 16 379.2z", "M224 0c-4.4 0-8 3.6-8 8l0 24.2C131.4 36.4 64 106.3 64 192l0 17.4c0 40.8-12.1 80.8-34.8 114.8L6.2 358.7C2.2 364.8 0 371.9 0 379.2 0 399.5 16.5 416 36.8 416l374.3 0c20.3 0 36.8-16.5 36.8-36.8 0-7.3-2.2-14.4-6.2-20.4l-23.1-34.6c-22.7-34-34.8-73.9-34.8-114.8l0-17.4c0-85.7-67.4-155.6-152-159.8L232 8c0-4.4-3.6-8-8-8zM80 192c0-79.5 64.5-144 144-144s144 64.5 144 144l0 17.4c0 44 13 87 37.4 123.6l23.1 34.6c2.3 3.4 3.5 7.4 3.5 11.6 0 11.5-9.3 20.8-20.8 20.8L36.8 400c-11.5 0-20.8-9.3-20.8-20.8 0-4.1 1.2-8.1 3.5-11.6L42.6 333C67 296.4 80 253.4 80 209.4L80 192zm76.1 272c9.9 28 36.6 48 67.9 48s58-20 67.9-48l-17.3 0c-9 18.9-28.3 32-50.6 32s-41.6-13.1-50.6-32l-17.3 0z"]],
    "hand-back-point-left": [512, 512, [], "e19f", ["M16 172c0 19.9 16.1 36 36 36l154.5 0c3.2 0 6.1 1.9 7.4 4.9s.6 6.4-1.6 8.7c-7.6 7.9-12.2 18.6-12.2 30.5 0 19.9 13.2 36.7 31.3 42.1 2.2 .7 4.1 2.3 5 4.4s.9 4.6-.1 6.7c-2.7 5.7-4.2 12.1-4.2 18.8 0 19 12.1 35.2 29 41.4 4 1.5 6.2 5.8 4.9 9.8-1.2 4-1.9 8.3-1.9 12.8 0 23.1 17.9 42.1 40.6 43.9 .3 0 .6 .1 1 .1L408 432c48.6 0 88-39.4 88-88l0-142c0-20.9-5.4-41.4-15.8-59.5l-10.3-18C448.5 87.1 408.8 64 365.7 64l-24 0c-16.5 0-32.1 7.3-42.7 19.8L274.2 113c-1.9 2.3-3.7 4.6-5.5 7l75.2 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L52 136c-19.9 0-36 16.1-36 36z", "M0 172c0-28.7 23.3-52 52-52l197.6 0c3.7-6 7.8-11.8 12.5-17.3l24.7-29.2c13.7-16.2 33.8-25.5 55-25.5l24 0c48.8 0 93.9 26.2 118.1 68.5l10.3 18C505.8 155.1 512 178.3 512 202l0 142c0 57.4-46.6 104-104 104l-104 0c-.8 0-1.5-.1-2.2-.3-30.2-3.1-53.8-28.6-53.8-59.7 0-3.6 .3-7.1 .9-10.5-19.5-9.9-32.9-30.2-32.9-53.5 0-6.1 .9-12 2.6-17.6-20.5-9.6-34.6-30.3-34.6-54.4 0-10.1 2.5-19.6 6.9-28L52 224c-28.7 0-52-23.3-52-52zm268.8-52l75.2 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L52 136c-19.9 0-36 16.1-36 36s16.1 36 36 36l154.5 0c3.2 0 6.1 1.9 7.4 4.9s.6 6.4-1.6 8.7c-7.6 7.9-12.2 18.6-12.2 30.5 0 19.9 13.2 36.7 31.3 42.1 2.2 .7 4.1 2.3 5 4.4s.9 4.6-.1 6.7c-2.7 5.7-4.2 12.1-4.2 18.8 0 19 12.1 35.2 29 41.4 4 1.5 6.2 5.8 4.9 9.8-1.2 4-1.9 8.3-1.9 12.8 0 23.1 17.9 42.1 40.6 43.9 .3 0 .6 .1 1 .1L408 432c48.6 0 88-39.4 88-88l0-142c0-20.9-5.4-41.4-15.8-59.5l-10.3-18C448.5 87.1 408.8 64 365.7 64l-24 0c-16.5 0-32.1 7.3-42.7 19.8L274.2 113c-1.9 2.3-3.7 4.6-5.5 7z"]],
    "lari-sign": [384, 512, [], "e1c8", ["", "M136 0c4.4 0 8 3.6 8 8l0 62.4c15.9-4.2 32.6-6.4 49.9-6.4 10.3 0 20.3 .8 30.1 2.3L224 8c0-4.4 3.6-8 8-8s8 3.6 8 8l0 61.5c72.4 17.5 128.9 75.3 143.8 148.1 .9 4.3-1.9 8.6-6.2 9.4s-8.6-1.9-9.4-6.2C354.8 155.4 304.7 103.1 240 86l0 162c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-165.5c-15.6-2.6-45.2-5.5-80 4.5l0 161c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-155.5C62.3 118.4 16 181.9 16 256 16 353.1 95.6 432 193.9 432L376 432c4.4 0 8 3.6 8 8s-3.6 8-8 8L8 448c-4.4 0-8-3.6-8-8s3.6-8 8-8l108.3 0C47.9 402.4 0 334.8 0 256 0 172.8 53.4 102.1 128 75.4L128 8c0-4.4 3.6-8 8-8z"]],
    "rectangle-plus": [512, 512, [], "e6b5", ["M16 128l0 256c0 26.5 21.5 48 48 48l384 0c26.5 0 48-21.5 48-48l0-256c0-26.5-21.5-48-48-48L64 80c-26.5 0-48 21.5-48 48zM144 256c0-4.4 3.6-8 8-8l96 0 0-96c0-4.4 3.6-8 8-8s8 3.6 8 8l0 96 96 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-96 0 0 96c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-96-96 0c-4.4 0-8-3.6-8-8z", "M64 80c-26.5 0-48 21.5-48 48l0 256c0 26.5 21.5 48 48 48l384 0c26.5 0 48-21.5 48-48l0-256c0-26.5-21.5-48-48-48L64 80zM0 128C0 92.7 28.7 64 64 64l384 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64L64 448c-35.3 0-64-28.7-64-64L0 128zM248 360l0-96-96 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l96 0 0-96c0-4.4 3.6-8 8-8s8 3.6 8 8l0 96 96 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-96 0 0 96c0 4.4-3.6 8-8 8s-8-3.6-8-8z"]],
    "cucumber": [512, 512, [129362], "e401", ["M49.3 304.8c-43.7 43.7-43.7 114.7 0 158.4 42.5 42.5 110.8 43.7 154.7 3.5 4.2-3.9 10.2-5.2 15.6-3.4 5.6 1.8 11.8 .4 16.2-3.9 4.3-4.3 5.7-10.6 4-16.1-1.8-5.7-.2-11.9 4-16.1L427.7 243.2c4.2-4.2 10.4-5.7 16.1-4 5.5 1.7 11.8 .4 16.1-4 4.4-4.4 5.7-10.6 3.9-16.2-1.7-5.4-.4-11.4 3.4-15.6 40.2-43.9 39-112.2-3.5-154.7-43.7-43.7-114.7-43.7-158.4 0l-124 124c-4.2 4.2-10.4 5.7-16.1 4-5.5-1.7-11.8-.4-16.1 4s-5.7 10.6-4 16.1c1.8 5.7 .2 11.9-4 16.1l-92 92zM176.5 320a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm192-192a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm0 128a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M219.7 463.3c5.6 1.8 11.8 .4 16.2-3.9 4.3-4.3 5.7-10.6 4-16.1-1.8-5.7-.2-11.9 4-16.1L427.7 243.2c4.2-4.2 10.4-5.7 16.1-4 5.5 1.7 11.8 .4 16.1-4 4.4-4.4 5.7-10.6 3.9-16.2-1.7-5.4-.4-11.4 3.4-15.6 40.2-43.9 39-112.2-3.5-154.7-43.7-43.7-114.7-43.7-158.4 0l-124 124c-4.2 4.2-10.4 5.7-16.1 4-5.5-1.7-11.8-.4-16.1 4s-5.7 10.6-4 16.1c1.8 5.7 .2 11.9-4 16.1l-92 92c-43.7 43.7-43.7 114.7 0 158.4 42.5 42.5 110.8 43.7 154.7 3.5 4.2-3.9 10.2-5.2 15.6-3.4zM475 37.5c48.6 48.6 49.9 126.6 4 176.8 3.5 11 .9 23.6-7.9 32.3-8.7 8.7-21.2 11.3-32.2 7.9L255.1 438.5c3.4 11 .8 23.5-7.9 32.2-8.7 8.7-21.3 11.4-32.3 7.9-50.2 45.9-128.2 44.6-176.8-4-50-50-50-131 0-181l92-92c-3.4-11-.8-23.5 7.9-32.2S159 158 170 161.4l124-124c50-50 131-50 181 0zM336.5 128a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm16 112a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm-192 64a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"]],
    "seal": [512, 512, [], "e241", ["", "M17.5 330.3c-6.8 16.3 1 35 17.3 41.8l56 23.2c11.8 4.9 21.1 14.2 26 26l23.2 56c6.8 16.3 25.5 24.1 41.8 17.3l56-23.2c11.8-4.9 25-4.9 36.7 0l56 23.2c16.3 6.8 35-1 41.8-17.3l23.2-56c4.9-11.8 14.2-21.1 26-26l56-23.2c16.3-6.8 24.1-25.5 17.3-41.8l-23.2-56c-4.9-11.8-4.9-25 0-36.7l23.2-56c6.8-16.3-1-35-17.3-41.8l-56-23.2c-11.8-4.9-21.1-14.2-26-26l-23.2-56c-6.8-16.3-25.5-24.1-41.8-17.3l-56 23.2c-11.8 4.9-25 4.9-36.7 0l-56-23.2c-16.3-6.8-35 1-41.8 17.3l-23.2 56c-4.9 11.8-14.2 21.1-26 26l-56 23.2c-16.3 6.8-24.1 25.5-17.3 41.8l23.2 56c4.9 11.8 4.9 25 0 36.7l-23.2 56zm11.2 56.6c-24.5-10.1-36.1-38.2-26-62.7l23.2-56c3.2-7.8 3.2-16.6 0-24.5l-23.2-56c-10.1-24.5 1.5-52.6 26-62.7l56-23.2c7.8-3.2 14.1-9.5 17.3-17.3l23.2-56c10.1-24.5 38.2-36.1 62.7-26l56 23.2c7.8 3.2 16.7 3.2 24.5 0l56-23.2c24.5-10.1 52.6 1.5 62.7 26l23.2 56c3.2 7.8 9.5 14.1 17.3 17.3l56 23.2c24.5 10.1 36.1 38.2 26 62.7l-23.2 56c-3.2 7.8-3.2 16.7 0 24.5l23.2 56c10.1 24.5-1.5 52.6-26 62.7l-56 23.2c-7.8 3.2-14.1 9.5-17.3 17.3l-23.2 56c-10.1 24.5-38.2 36.1-62.7 26l-56-23.2c-7.8-3.2-16.7-3.2-24.5 0l-56 23.2c-24.5 10.1-52.6-1.5-62.7-26l-23.2-56c-3.2-7.8-9.5-14.1-17.3-17.3l-56-23.2z"]],
    "circle-caret-down": [512, 512, ["caret-circle-down"], "f32d", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zm112-38.8c0-13.9 11.3-25.2 25.2-25.2l205.6 0c13.9 0 25.2 11.3 25.2 25.2 0 6.4-2.4 12.5-6.8 17.2L275.3 343.6c-5 5.4-12 8.4-19.3 8.4s-14.3-3-19.3-8.4L134.8 234.4c-4.4-4.7-6.8-10.8-6.8-17.2z", "M256 16a240 240 0 1 0 0 480 240 240 0 1 0 0-480zm0 496a256 256 0 1 1 0-512 256 256 0 1 1 0 512zm0-160c-7.3 0-14.3-3-19.3-8.4L134.8 234.4c-4.4-4.7-6.8-10.8-6.8-17.2 0-13.9 11.3-25.2 25.2-25.2l205.6 0c13.9 0 25.2 11.3 25.2 25.2 0 6.4-2.4 12.5-6.8 17.2L275.3 343.6c-5 5.4-12 8.4-19.3 8.4zm-7.6-19.3c2 2.1 4.7 3.3 7.6 3.3s5.6-1.2 7.6-3.3L365.5 223.5c1.6-1.7 2.5-4 2.5-6.3 0-5.1-4.1-9.2-9.2-9.2l-205.6 0c-5.1 0-9.2 4.1-9.2 9.2 0 2.3 .9 4.6 2.5 6.3L248.4 332.7z"]],
    "mill-sign": [384, 512, [], "e1ed", ["", "M295.4 3c1.7-4.1-.3-8.8-4.4-10.4s-8.8 .3-10.4 4.4L235.2 108.7c-19.2 10.8-34.5 27.7-43.2 48.1-15.3-35.7-50.7-60.7-92-60.7-35.2 0-66.2 18.2-84 45.7L16 104c0-4.4-3.6-8-8-8s-8 3.6-8 8L0 424c0 4.4 3.6 8 8 8s8-3.6 8-8l0-228c0-46.4 37.6-84 84-84s84 37.6 84 84L184 234.7 72.6 509c-1.7 4.1 .3 8.8 4.4 10.4s8.8-.3 10.4-4.4L184 277.3 184 424c0 4.4 3.6 8 8 8s8-3.6 8-8l0-186.1 47.8-117.7c11-5.2 23.2-8.2 36.2-8.2 46.4 0 84 37.6 84 84l0 228c0 4.4 3.6 8 8 8s8-3.6 8-8l0-228c0-55.2-44.8-100-100-100-9.7 0-19.1 1.4-28 4L295.4 3zM223.4 137.9L200 195.4c.2-22.3 9-42.5 23.3-57.5z"]],
    "mug-tea-saucer": [576, 512, [], "e1f5", ["M80 64l0 224c0 44.2 35.8 80 80 80l192 0c44.2 0 80-35.8 80-80l0-240-232 0 0 37 46.1 52.7c6.4 7.3 9.9 16.7 9.9 26.3l0 52c0 22.1-17.9 40-40 40l-48 0c-22.1 0-40-17.9-40-40l0-52c0-9.7 3.5-19 9.9-26.3L184 85 184 48 96 48c-8.8 0-16 7.2-16 16z", "M200 48l0 37 46.1 52.7c6.4 7.3 9.9 16.7 9.9 26.3l0 52c0 22.1-17.9 40-40 40l-48 0c-22.1 0-40-17.9-40-40l0-52c0-9.7 3.5-19 9.9-26.3L184 85 184 48 96 48c-8.8 0-16 7.2-16 16l0 224c0 44.2 35.8 80 80 80l192 0c44.2 0 80-35.8 80-80l0-240-232 0zm248 0l0 176 24 0c48.6 0 88-39.4 88-88s-39.4-88-88-88l-24 0zm0 192l0 48c0 53-43 96-96 96l-192 0c-53 0-96-43-96-96L64 64c0-17.7 14.3-32 32-32l376 0c57.4 0 104 46.6 104 104S529.4 240 472 240l-24 0zM32 472c0-4.4 3.6-8 8-8l440 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L40 480c-4.4 0-8-3.6-8-8zM149.9 148.2c-3.8 4.4-5.9 10-5.9 15.8l0 52c0 13.3 10.7 24 24 24l48 0c13.3 0 24-10.7 24-24l0-52c0-5.8-2.1-11.4-5.9-15.8l-42.1-48.1-42.1 48.1z"]],
    "cart-circle-check": [640, 512, [], "e3f1", ["M96 48l431.7 0c15.5 0 26.9 14.4 23.4 29.5L520.2 209.5c-7.9-1-16-1.5-24.2-1.5-56.9 0-108 24.7-143.1 64L139.8 272 96 48zM240 464a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M8 0C3.6 0 0 3.6 0 8s3.6 8 8 8l45.7 0C65.1 16 75 24.1 77.2 35.4l59.4 303.4c5.1 26.3 28.2 45.2 55 45.2l113.1 0c.4-5.4 1.1-10.7 2-16l-115.1 0c-19.1 0-35.6-13.5-39.3-32.3L142.9 288 340 288c4-5.6 8.3-10.9 12.9-16L139.8 272 96 48 527.7 48c15.5 0 26.9 14.4 23.4 29.5L520.2 209.5c5.3 .7 10.6 1.6 15.8 2.7L566.6 81.1C572.5 56 553.4 32 527.7 32L92.8 32C89 13.4 72.7 0 53.7 0L8 0zM176 464a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm80 0a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM496 272a128 128 0 1 1 0 256 128 128 0 1 1 0-256zm0 272a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm60.7-212.5c-3.6-2.6-8.6-1.8-11.2 1.8l-74 101.7-33.4-40.1c-2.8-3.4-7.9-3.9-11.3-1s-3.9 7.9-1 11.3l40 48c1.6 1.9 3.9 3 6.4 2.9s4.8-1.3 6.2-3.3l80-110c2.6-3.6 1.8-8.6-1.8-11.2z"]],
    "album": [448, 512, [128189], "f89f", ["M16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96zM384 256a160 160 0 1 1 -320 0 160 160 0 1 1 320 0zm-176 0a16 16 0 1 0 32 0 16 16 0 1 0 -32 0z", "M384 48c26.5 0 48 21.5 48 48l0 320c0 26.5-21.5 48-48 48L64 464c-26.5 0-48-21.5-48-48L16 96c0-26.5 21.5-48 48-48l320 0zM64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm160 80a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm0 304a160 160 0 1 0 0-320 160 160 0 1 0 0 320zM208 256a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm48 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"]],
    "left-to-line": [512, 512, ["arrow-alt-to-left"], "f34b", ["M146.3 250.3l144-144c2.3-2.3 5.7-3 8.7-1.7s4.9 4.2 4.9 7.4l0 88c0 4.4 3.6 8 8 8 46.7 0 97.3 0 152 0 17.7 0 32 14.3 32 32l0 32c0 17.7-14.3 32-32 32l-152 0c-4.4 0-8 3.6-8 8l0 88c0 3.2-1.9 6.2-4.9 7.4s-6.4 .6-8.7-1.7l-144-144c-3.1-3.1-3.1-8.2 0-11.3z", "M8 64c4.4 0 8 3.6 8 8l0 368c0 4.4-3.6 8-8 8s-8-3.6-8-8L0 72c0-4.4 3.6-8 8-8zM146.3 250.3c-3.1 3.1-3.1 8.2 0 11.3l144 144c2.3 2.3 5.7 3 8.7 1.7s4.9-4.2 4.9-7.4l0-88c0-4.4 3.6-8 8-8l152 0c17.7 0 32-14.3 32-32l0-32c0-17.7-14.3-32-32-32l-80 0 0 0-72 0c-4.4 0-8-3.6-8-8l0-88c0-3.2-1.9-6.2-4.9-7.4s-6.4-.6-8.7 1.7l-144 144zM384 192l0 0 80 0c26.5 0 48 21.5 48 48l0 32c0 26.5-21.5 48-48 48l-144 0 0 80c0 9.7-5.8 18.5-14.8 22.2s-19.3 1.7-26.2-5.2L135 273c-9.4-9.4-9.4-24.6 0-33.9L279 95c6.9-6.9 17.2-8.9 26.2-5.2S320 102.3 320 112l0 80 64 0z"]],
    "person-snowboarding": [576, 512, [127938, "snowboarding"], "f7ce", ["M176 285l0 143.2 32 6.3 0-138.5c0-4.4 3.6-8 8-8l18.5 0c1.9 0 3.7 .7 5.1 1.9l52.9 44C299.8 340 304 349 304 358.5l0 94.8 32 6.3 0-101c0-19-8.4-37-23-49.2l-39.3-32.8c-1.8-1.5-2.9-3.7-2.9-6.1s1-4.6 2.8-6.1l74.1-63.5c2.8-2.4 6.8-2.6 9.8-.5l97.3 68.7c7.2 5.1 17.2 3.4 22.3-3.8s3.4-17.2-3.8-22.3l-272-192c-7.2-5.1-17.2-3.4-22.3 3.8s-3.4 17.2 3.8 22.3l96.5 68.1c2 1.4 3.2 3.7 3.4 6.1s-.9 4.8-2.7 6.4l-76.6 67.1C186 240 176 262 176 285zM384 72a40 40 0 1 0 80 0 40 40 0 1 0 -80 0z", "M424 112a40 40 0 1 0 0-80 40 40 0 1 0 0 80zm0-96a56 56 0 1 1 0 112 56 56 0 1 1 0-112zM26.3 370.3c3.1-3.1 8.2-3.1 11.3 0l26.2 26.2c7.9 7.9 17.9 13.2 28.8 15.4l67.3 13.2 0-140c0-27.7 12-54 32.8-72.2l69-60.4-88.2-62.3c-14.4-10.2-17.9-30.2-7.7-44.6s30.2-17.9 44.6-7.7l272 192c14.4 10.2 17.9 30.2 7.7 44.6s-30.2 17.9-44.6 7.7l-92.2-65.1-62.2 53.3 32.1 26.7c18.2 15.2 28.8 37.7 28.8 61.5l0 104.2 74.4 14.6c8.7 1.7 17.6 1.3 26.1-1.1l41.2-11.8c4.2-1.2 8.7 1.2 9.9 5.5s-1.2 8.7-5.5 9.9L457 491.5c-10.9 3.1-22.4 3.6-33.6 1.4L89.6 427.6c-14.1-2.7-27-9.6-37.1-19.7L26.3 381.7c-3.1-3.1-3.1-8.2 0-11.3zM336 459.5l0-101c0-19-8.4-37-23-49.2l-39.3-32.8c-1.8-1.5-2.9-3.7-2.9-6.1s1-4.6 2.8-6.1l74.1-63.5c2.8-2.4 6.8-2.6 9.8-.5l97.3 68.7c7.2 5.1 17.2 3.4 22.3-3.8s3.4-17.2-3.8-22.3l-272-192c-7.2-5.1-17.2-3.4-22.3 3.8s-3.4 17.2 3.8 22.3l96.5 68.1c2 1.4 3.2 3.7 3.4 6.1s-.9 4.8-2.7 6.4l-76.6 67.1C186 240 176 262 176 285l0 143.2 32 6.3 0-138.5c0-4.4 3.6-8 8-8l18.5 0c1.9 0 3.7 .7 5.1 1.9l52.9 44C299.8 340 304 349 304 358.5l0 94.8 32 6.3zm-48-9.4l0-91.6c0-4.7-2.1-9.3-5.8-12.3l-50.6-42.2-7.6 0 0 133.6 64 12.5z"]],
    "tty": [512, 512, ["teletype"], "f1e4", ["M30.7 239.9l3 5.2c4.9 8.6 15.4 12.2 24.6 8.4l81.2-33.4c8-3.3 12.9-11.5 12.1-20.1l-5.4-53.9c-.7-7.4 3.7-14.4 10.8-16.7 64.4-21.8 134.8-20.6 198.5 3.5 6.8 2.6 11 9.4 10.3 16.6L360.6 200c-.9 8.6 4 16.8 12.1 20.1l81.2 33.4c9.1 3.8 19.7 .2 24.6-8.4l3-5.2c24.7-43.2 19.7-102.6-26-132.6-120.7-79.1-278-79.1-398.7 0-45.7 30-50.7 89.4-26 132.6zM48 352a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm0 96a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm96-96a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm0 96c0 8.8 7.2 16 16 16l192 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-192 0c-8.8 0-16 7.2-16 16zm96-96a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm96 0a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm96 0a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm0 96a16 16 0 1 0 32 0 16 16 0 1 0 -32 0z", "M156.9 129.4c-7.1 2.4-11.5 9.3-10.8 16.7l5.4 53.9c.9 8.6-4 16.8-12.1 20.1L58.2 253.6c-9.1 3.8-19.7 .2-24.6-8.4l-3-5.2c-24.7-43.2-19.7-102.6 26-132.6 120.7-79.1 278-79.1 398.7 0 45.8 30 50.7 89.4 26 132.6l-3 5.2c-4.9 8.6-15.4 12.2-24.6 8.4l-81.2-33.4c-8-3.3-12.9-11.5-12.1-20.1l5.1-50.6c.7-7.2-3.5-14-10.3-16.6-63.7-24.1-134.2-25.3-198.5-3.5zm290.9 139c16.6 6.8 35.7 .3 44.6-15.3l3-5.2c27.7-48.4 23.5-118.1-31.2-153.9-126-82.6-290.2-82.6-416.2 0-54.7 35.8-58.8 105.5-31.2 153.9l3 5.2c8.9 15.6 28 22.1 44.6 15.3l81.2-33.4c14.6-6 23.5-20.9 21.9-36.5L162 144.5c60.9-20.6 127.5-19.5 187.7 3.3l-5.1 50.6c-1.6 15.7 7.3 30.5 21.9 36.5l81.2 33.4zM80 352a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zM64 320a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm112 32a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm-16-32a32 32 0 1 0 0 64 32 32 0 1 0 0-64zM64 432a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM32 448a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm432 0a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm-16-32a32 32 0 1 0 0 64 32 32 0 1 0 0-64zM256 336a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm-32 16a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm144 0a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm-16-32a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm96 16a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm-32 16a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zM160 432l192 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-192 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zm0-16c-17.7 0-32 14.3-32 32s14.3 32 32 32l192 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-192 0z"]],
    "slider-circle": [576, 512, [], "e750", ["M240 256a112 112 0 1 0 224 0 112 112 0 1 0 -224 0z", "M464 256a112 112 0 1 0 -224 0 112 112 0 1 0 224 0zm15.8 8c-4.1 67-59.7 120-127.8 120-70.7 0-128-57.3-128-128s57.3-128 128-128c68 0 123.6 53 127.8 120l88.2 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-88.2 0zM176.2 248c-.2 5.3-.2 10.7 0 16L8 264c-4.4 0-8-3.6-8-8s3.6-8 8-8l168.2 0z"]],
    "users-rectangle": [576, 512, [], "e594", ["M168 400c4.4 0 8-3.6 8-8l0-8c0-44.2 35.8-80 80-80l64 0c44.2 0 80 35.8 80 80l0 8c0 4.4 3.6 8 8 8l-240 0zM352 160a64 64 0 1 1 -128 0 64 64 0 1 1 128 0z", "M64 16C37.5 16 16 37.5 16 64l0 384c0 26.5 21.5 48 48 48l448 0c26.5 0 48-21.5 48-48l0-384c0-26.5-21.5-48-48-48L64 16zM0 64C0 28.7 28.7 0 64 0L512 0c35.3 0 64 28.7 64 64l0 384c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zM288 224a64 64 0 1 0 0-128 64 64 0 1 0 0 128zm0-144a80 80 0 1 1 0 160 80 80 0 1 1 0-160zM184 240c1.3 0 2.7 0 4-.1 4 5 8.4 9.7 13.1 14.1-5.5 1.3-11.2 2-17.1 2-39.8 0-72-32.2-72-72 0-34.5 24.3-63.3 56.7-70.4-2.3 5.9-4.2 12.1-5.6 18.4-20.6 8.3-35.1 28.4-35.1 52 0 30.9 25.1 56 56 56zm208 16c-5.9 0-11.6-.7-17.1-2 4.7-4.4 9.1-9.1 13.1-14.1 1.3 .1 2.6 .1 4 .1 30.9 0 56-25.1 56-56 0-23.5-14.5-43.7-35.1-52-1.4-6.3-3.3-12.5-5.6-18.4 32.4 7 56.7 35.9 56.7 70.4 0 39.8-32.2 72-72 72zM151.8 291.1c-7 7.8-13.2 16.2-18.6 25.3-22.4 14.2-37.3 39.2-37.3 67.6l0 8c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-8c0-44.7 30.5-82.2 71.8-92.9zm290.9 25.3c-5.3-9.1-11.6-17.5-18.6-25.3 41.3 10.7 71.8 48.3 71.8 92.9l0 8c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-8c0-28.5-14.9-53.5-37.3-67.6zM256 288l64 0c53 0 96 43 96 96l0 8c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-8c0-44.2-35.8-80-80-80l-64 0c-44.2 0-80 35.8-80 80l0 8c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-8c0-53 43-96 96-96z"]],
    "mobile": [384, 512, [128241, "mobile-android", "mobile-phone"], "f3ce", ["M32 64l0 384c0 26.5 21.5 48 48 48l224 0c26.5 0 48-21.5 48-48l0-384c0-26.5-21.5-48-48-48L80 16C53.5 16 32 37.5 32 64zM144 440c0-4.4 3.6-8 8-8l80 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-80 0c-4.4 0-8-3.6-8-8z", "M80 16C53.5 16 32 37.5 32 64l0 384c0 26.5 21.5 48 48 48l224 0c26.5 0 48-21.5 48-48l0-384c0-26.5-21.5-48-48-48L80 16zM16 64C16 28.7 44.7 0 80 0L304 0c35.3 0 64 28.7 64 64l0 384c0 35.3-28.7 64-64 64L80 512c-35.3 0-64-28.7-64-64L16 64zM152 432l80 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-80 0c-4.4 0-8-3.6-8-8s3.6-8 8-8z"]],
    "arrows-turn-to-dots": [448, 512, [], "e4c1", ["M112 96a48 48 0 1 1 -96 0 48 48 0 1 1 96 0zM432 368a48 48 0 1 1 -96 0 48 48 0 1 1 96 0z", "M250.3 18.3c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3L203.3 88 352 88c53 0 96 43 96 96l0 32c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-32c0-44.2-35.8-80-80-80l-148.7 0 58.3 58.3c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-72-72c-3.1-3.1-3.1-8.2 0-11.3l72-72zm-52.7 272l72 72c3.1 3.1 3.1 8.2 0 11.3l-72 72c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3L244.7 376 96 376c-44.2 0-80 35.8-80 80l0 32c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-32c0-53 43-96 96-96l148.7 0-58.3-58.3c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0zM384 416a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm0-112a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM16 96a48 48 0 1 0 96 0 48 48 0 1 0 -96 0zm112 0A64 64 0 1 1 0 96 64 64 0 1 1 128 96z"]],
    "exclamation": [64, 512, [10069, 10071, 61738], "21", ["", "M32 480c8.8 0 16 7.2 16 16s-7.2 16-16 16-16-7.2-16-16 7.2-16 16-16zM32 0c8.9 0 16 7.3 15.8 16.2L40 376.2c-.1 4.3-3.7 7.8-8 7.8s-7.9-3.5-8-7.8l-7.8-360C16 7.3 23.1 0 32 0z"]],
    "location-xmark": [384, 512, ["map-marker-times", "map-marker-xmark"], "f60e", ["M16 188.6C16 93.5 94.5 16 192 16S368 93.5 368 188.6c0 55-28 117.3-63.9 174.2-35.6 56.3-77.5 104.9-102.2 131.8-5.5 6-14.3 6-19.7 0-24.8-26.9-66.7-75.5-102.3-131.8-35.9-56.8-63.9-119.2-63.9-174.2zm110.8-61.7c-3.1 3.1-3.1 8.2 0 11.3l53.8 53.8-53.8 53.8c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l53.8-53.8 53.8 53.8c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-53.8-53.8 53.8-53.8c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0l-53.8 53.8-53.8-53.8c-3.1-3.1-8.2-3.1-11.3 0z", "M16 188.6C16 93.5 94.5 16 192 16S368 93.5 368 188.6c0 55-28 117.3-63.9 174.2-35.6 56.3-77.5 104.9-102.2 131.8-5.5 6-14.3 6-19.7 0-24.8-26.9-66.7-75.5-102.3-131.8-35.9-56.8-63.9-119.2-63.9-174.2zM192 0C86 0 0 84.4 0 188.6 0 307.9 120.2 450.9 170.4 505.4 182.2 518.2 201.8 518.2 213.6 505.4 263.8 450.9 384 307.9 384 188.6 384 84.4 298 0 192 0zM126.8 245.8c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l53.8-53.8 53.8 53.8c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-53.8-53.8 53.8-53.8c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0l-53.8 53.8-53.8-53.8c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l53.8 53.8-53.8 53.8z"]],
    "church": [512, 512, [9962], "f51d", ["M16 328.7L16 464c0 17.7 14.3 32 32 32l48 0 0-227.1-62.3 31.2C22.8 305.5 16 316.6 16 328.7zm96-111.1l0 278.4 80 0 0-112c0-35.3 28.7-64 64-64s64 28.7 64 64l0 112 80 0 0-278.4c0-8.2-4.2-15.9-11.2-20.3L256 113.5 123.2 197.3c-7 4.4-11.2 12.1-11.2 20.3zm304 51.3l0 227.1 48 0c17.7 0 32-14.3 32-32l0-135.3c0-12.1-6.8-23.2-17.7-28.6L416 268.9z", "M256-32c4.4 0 8 3.6 8 8l0 40 48 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-48 0 0 67.6 133.4 84.2c11.6 7.3 18.6 20.1 18.6 33.8l0 33.4 69.5 34.7c16.3 8.1 26.5 24.8 26.5 42.9L512 464c0 26.5-21.5 48-48 48L48 512c-26.5 0-48-21.5-48-48L0 328.7c0-18.2 10.3-34.8 26.5-42.9l69.5-34.7 0-33.4c0-13.7 7-26.5 18.6-33.8L248 99.6 248 32 200 32c-4.4 0-8-3.6-8-8s3.6-8 8-8l48 0 0-40c0-4.4 3.6-8 8-8zM416 496l48 0c17.7 0 32-14.3 32-32l0-135.3c0-12.1-6.8-23.2-17.7-28.6L416 268.9 416 496zm-16 0l0-278.4c0-8.2-4.2-15.9-11.2-20.3L256 113.5 123.2 197.3c-7 4.4-11.2 12.1-11.2 20.3l0 278.4 80 0 0-112c0-35.3 28.7-64 64-64s64 28.7 64 64l0 112 80 0zM33.7 300.1C22.8 305.5 16 316.6 16 328.7L16 464c0 17.7 14.3 32 32 32l48 0 0-227.1-62.3 31.2zM304 496l0-112c0-26.5-21.5-48-48-48s-48 21.5-48 48l0 112 96 0z"]],
    "toggle-off": [576, 512, [], "f204", ["M240 256a80 80 0 1 1 -160 0 80 80 0 1 1 160 0z", "M416 112c79.5 0 144 64.5 144 144S495.5 400 416 400l-256 0C80.5 400 16 335.5 16 256S80.5 112 160 112l256 0zM576 256c0-88.4-71.6-160-160-160L160 96C71.6 96 0 167.6 0 256S71.6 416 160 416l256 0c88.4 0 160-71.6 160-160zm-336 0a80 80 0 1 1 -160 0 80 80 0 1 1 160 0zM64 256a96 96 0 1 0 192 0 96 96 0 1 0 -192 0z"]],
    "face-nauseated": [512, 512, [], "e381", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zm88.8-92.4c-2-4-.4-8.8 3.6-10.7l64-32c4-2 8.8-.4 10.7 3.6s.4 8.8-3.6 10.7l-64 32c-4 2-8.8 .4-10.7-3.6zm48.2 113c2.2-3.8 7.1-5.1 10.9-2.9 19.3 11.2 33 31.1 35.6 54.4l112.9 0c2.6-23.3 16.2-43.2 35.6-54.4 3.8-2.2 8.7-.9 10.9 2.9s.9 8.7-2.9 10.9c-16.8 9.7-28 27.8-28 48.5s11.2 38.8 28 48.5c3.8 2.2 5.1 7.1 2.9 10.9s-7.1 5.1-10.9 2.9c-19.3-11.2-33-31.1-35.6-54.4l-112.9 0c-2.6 23.3-16.2 43.2-35.6 54.4-3.8 2.2-8.7 .9-10.9-2.9s-.9-8.7 2.9-10.9c16.8-9.7 28-27.8 28-48.5s-11.2-38.8-28-48.5c-3.8-2.2-5.1-7.1-2.9-10.9zM192 208a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm160 0a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm-23.2-83.6c2-4 6.8-5.6 10.7-3.6l64 32c4 2 5.6 6.8 3.6 10.7s-6.8 5.6-10.7 3.6l-64-32c-4-2-5.6-6.8-3.6-10.7z", "M496 256a240 240 0 1 0 -480 0 240 240 0 1 0 480 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm164 17.6c19.3 11.2 33 31.1 35.6 54.4l112.9 0c2.6-23.3 16.2-43.2 35.6-54.4 3.8-2.2 8.7-.9 10.9 2.9s.9 8.7-2.9 10.9c-16.8 9.7-28 27.8-28 48.5s11.2 38.8 28 48.5c3.8 2.2 5.1 7.1 2.9 10.9s-7.1 5.1-10.9 2.9c-19.3-11.2-33-31.1-35.6-54.4l-112.9 0c-2.6 23.3-16.2 43.2-35.6 54.4-3.8 2.2-8.7 .9-10.9-2.9s-.9-8.7 2.9-10.9c16.8-9.7 28-27.8 28-48.5s-11.2-38.8-28-48.5c-3.8-2.2-5.1-7.1-2.9-10.9s7.1-5.1 10.9-2.9zM336 192a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM192 208a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm-12.4-72.8l-64 32c-4 2-8.8 .4-10.7-3.6s-.4-8.8 3.6-10.7l64-32c4-2 8.8-.4 10.7 3.6s.4 8.8-3.6 10.7zm149.3-10.7c2-4 6.8-5.6 10.7-3.6l64 32c4 2 5.6 6.8 3.6 10.7s-6.8 5.6-10.7 3.6l-64-32c-4-2-5.6-6.8-3.6-10.7z"]],
    "deer": [512, 512, [129420], "f78e", ["M16 264l0 24.8c3.8 7.5 9.2 14.1 16 19.3l0-23.4c3 4.8 7 9 11.8 12.2l4.2 2.8c15 10 24 26.8 24 44.8 0 5.8-.9 11.5-2.8 17l-8.8 26.3c-2.6 7.9-2.7 16.4-.3 24.4l22.3 72.4c2.1 6.7 8.3 11.3 15.3 11.3l37.8 0c10.8 0 18.5-10.4 15.3-20.7l-13.4-43.4c-6.4-20.9 1.6-43.5 19.8-55.7 10.9-7.3 16.6-20.3 14.4-33.3l-3.6-21.6c-.5-3.3 1-6.5 3.8-8.2s6.5-1.4 9 .7l2.7 2.2c22.7 18.2 50.9 28 80 28l24.3 0c4.4 0 8 3.6 8 8l0 128c0 8.8 7.2 16 16 16l40 0c8.8 0 16-7.2 16-16l0-169.6c0-5 .7-9.9 2-14.7l22.3-81.8c.9-3.5 4.1-5.9 7.7-5.9l70.1 0c14.3 0 25.9-11.6 25.9-25.9 0-6.9-2.7-13.5-7.6-18.3l-57.2-57.2c-17-17-40-26.5-63.9-26.5-14 0-27.9 3.3-40.4 9.5l-51 25.5c-2.3 1.2-3.8 3.5-3.8 6.1 0 3.8 3.1 6.8 6.8 6.8l57.2 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-.6 0-15 42.7c-1.1 3.2-4.2 5.3-7.5 5.3L88 192c-39.8 0-72 32.2-72 72zM416 144a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M240 8c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 24c0 26.5 21.5 48 48 48l38.1 0-41.5 20.7c-7.7 3.9-12.6 11.8-12.6 20.4 0 12.6 10.2 22.8 22.8 22.8l39.7 0-11.3 32-219.2 0c-48.6 0-88 39.4-88 88l0 48c0 4.4 3.6 8 8 8s8-3.6 8-8l0-48c0-39.8 32.2-72 72-72l224.9 0c3.4 0 6.4-2.1 7.5-5.3l15-42.7 .6 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-57.2 0c-3.8 0-6.8-3.1-6.8-6.8 0-2.6 1.5-5 3.8-6.1l51-25.5c12.6-6.3 26.4-9.5 40.4-9.5 24 0 47 9.5 63.9 26.5l57.2 57.2c4.9 4.9 7.6 11.5 7.6 18.3 0 14.3-11.6 25.9-25.9 25.9L400 208c-3.6 0-6.8 2.4-7.7 5.9L370 295.7c-1.3 4.8-2 9.8-2 14.7L368 480c0 8.8-7.2 16-16 16l-40 0c-8.8 0-16-7.2-16-16l0-128c0-4.4-3.6-8-8-8l-24.3 0c-29.1 0-57.3-9.9-80-28l-2.7-2.2c-2.6-2.1-6.2-2.3-9-.7s-4.4 4.9-3.8 8.2l3.6 21.6c2.2 13-3.5 26-14.4 33.3-18.2 12.1-26.3 34.8-19.8 55.7l13.4 43.4c3.2 10.3-4.5 20.7-15.3 20.7l-37.8 0c-7 0-13.2-4.6-15.3-11.3L60.2 412.3c-2.5-8-2.4-16.5 .3-24.4l8.8-26.3c1.8-5.5 2.8-11.2 2.8-17 0-18-9-34.8-24-44.8l-4.2-2.8C39 293.7 35 289.5 32 284.7l0 23.4c1 .7 1.9 1.4 3 2.1l4.2 2.8c10.5 7 16.9 18.9 16.9 31.5 0 4.1-.7 8.1-1.9 12l-8.8 26.3c-3.7 11.1-3.8 23-.4 34.2l22.3 72.4C71.3 502.8 83.7 512 97.7 512l37.8 0c21.5 0 36.9-20.8 30.6-41.4l-13.4-43.4c-4.4-14.1 1.1-29.4 13.4-37.7 16.2-10.8 24.5-30.1 21.3-49.3l-.4-2.3C210 352.3 236.5 360 263.7 360l16.3 0 0 120c0 17.7 14.3 32 32 32l40 0c17.7 0 32-14.3 32-32l0-169.6c0-3.6 .5-7.1 1.4-10.5l20.7-75.9 63.9 0c23.2 0 41.9-18.8 41.9-41.9 0-11.1-4.4-21.8-12.3-29.7L442.5 95.2c-5.8-5.8-12.2-10.9-19.1-15.2l.6 0c26.5 0 48-21.5 48-48l0-24c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 24c0 17.7-14.3 32-32 32l-84.2 0c7.6-8.5 12.2-19.7 12.2-32l0-24c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 24c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-24zM416 144a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"]],
    "box-open-full": [576, 512, ["box-full"], "f49c", ["M64 276.6l0 69.6c0 20.4 11.1 39.2 29 49.1l168 92.7c6 3.3 12.5 5.5 19.1 6.4l0-199.4-25.6 59.7c-2.8 6.6-8.2 11.2-14.4 13.3-6.3 2.1-13.4 1.6-19.6-1.9L64 276.6zm232-15.9l0 233.6c6.6-.9 13.1-3.1 19.1-6.4l168-92.7c17.9-9.9 29-28.6 29-49.1L512 145 296 260.8z", "M336 128c0-61.9-50.1-112-112-112-52.2 0-96.1 35.7-108.5 84.1L101 92.3C116.5 39 165.7 0 224 0 272.2 0 314.2 26.6 336 66l0-18c0-26.5 21.5-48 48-48l32 0c26.5 0 48 21.5 48 48l0 50.2-16 8.6 0-58.8c0-17.7-14.3-32-32-32l-32 0c-17.7 0-32 14.3-32 32l0 80c0 11.2-1.4 22.1-4.1 32.4l-20.6 11c5.6-13.4 8.7-28 8.7-43.4zM220.5 366L64 276.6 64 346.2c0 20.4 11.1 39.2 29 49.1l168 92.7c6 3.3 12.5 5.5 19.1 6.4l0-199.4-25.6 59.7c-5.6 13.2-21.5 18.5-34 11.4zm19.3-17.7l38.1-88.8-217.5-116.5-.9-.5-31.3 87.5c-1.3 3.7 .2 7.7 3.6 9.6L228.4 352.2c4.2 2.4 9.4 .6 11.3-3.8zM552.8 211.6l-24.9-49.7 0 184.4c0 26.2-14.3 50.4-37.2 63l-168 92.7c-21.6 11.9-47.9 11.9-69.5 0l-168-92.7c-23-12.7-37.2-36.8-37.2-63l0-78.7-24.4-13.9c-10.1-5.8-14.6-18-10.7-28.9l35.5-99.4c.8-2.2 2.5-4 4.7-4.8s4.6-.7 6.7 .5L288 246.9 516.1 121c1.9-1.1 4.2-1.3 6.2-.6s3.8 2.1 4.8 4.1l40 80c2 4 .4 8.8-3.6 10.7s-8.8 .4-10.7-3.6zM512 145L296 260.8 296 494.4c6.6-.9 13.1-3.1 19.1-6.4l168-92.7c17.9-9.9 29-28.6 29-49.1L512 145z"]],
    "cherries": [576, 512, [], "e0ec", ["M16 304c0 87.1 77.5 160 176 160s176-72.9 176-160c0-53-43-96-96-96-26.9 0-51.1 11-68.6 28.8-3 3.1-7.1 4.8-11.4 4.8s-8.4-1.7-11.4-4.8c-17.4-17.8-41.7-28.8-68.6-28.8-53 0-96 43-96 96zM361.4 462.7c7.4 .9 14.9 1.3 22.6 1.3 98.5 0 176-72.9 176-160 0-53-43-96-96-96-19.7 0-38.1 5.9-53.3 16.2 13.6 23.5 21.3 50.8 21.3 79.8 0 63.2-27.3 118.7-70.6 158.7z", "M294.7-4.4c-1.6-2.5-4.5-3.8-7.4-3.6s-5.5 2.1-6.7 4.8L185.3 219.3C165.7 202.3 140 192 112 192 50.1 192 0 242.1 0 304 0 401.2 86 480 192 480s192-78.8 192-176c0-61.9-50.1-112-112-112-25.2 0-48.5 8.3-67.2 22.4L289.5 16.9 412.2 204.6c-3.5 1.8-7 3.9-10.2 6.1 3.1 4.3 6 8.8 8.7 13.4 15.3-10.2 33.6-16.2 53.3-16.2 53 0 96 43 96 96 0 87.1-77.5 160-176 160-7.7 0-15.2-.4-22.6-1.3-5.2 4.8-10.6 9.4-16.2 13.7 12.5 2.4 25.5 3.6 38.8 3.6 106 0 192-78.8 192-176 0-61.9-50.1-112-112-112-12.9 0-25.3 2.2-36.8 6.2L294.7-4.4zM192 241.6c4.3 0 8.4-1.7 11.4-4.8 17.4-17.8 41.7-28.8 68.6-28.8 53 0 96 43 96 96 0 87.1-77.5 160-176 160S16 391.1 16 304c0-53 43-96 96-96 26.9 0 51.1 11 68.6 28.8 3 3.1 7.1 4.8 11.4 4.8z"]],
    "vacuum-robot": [512, 512, [], "e04e", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zm106.3 26.3c3.1-3.1 8.2-3.1 11.3 0l96 96c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-96-96c-3.1-3.1-3.1-8.2 0-11.3zm8-136l9.6-9.6c31.2-31.2 73.5-48.7 117.7-48.7 91.9 0 166.4 74.5 166.4 166.4 0 44.1-17.5 86.5-48.7 117.7l-9.6 9.6c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l9.6-9.6c28.2-28.2 44-66.5 44-106.3 0-83.1-67.3-150.4-150.4-150.4-39.9 0-78.1 15.8-106.3 44l-9.6 9.6c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3zm56 72c3.1-3.1 8.2-3.1 11.3 0l96 96c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-96-96c-3.1-3.1-3.1-8.2 0-11.3z", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm1.6-408c83.1 0 150.4 67.3 150.4 150.4 0 39.9-15.8 78.1-44 106.3l-9.6 9.6c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l9.6-9.6c31.2-31.2 48.7-73.5 48.7-117.7 0-91.9-74.5-166.4-166.4-166.4-44.1 0-86.5 17.5-117.7 48.7l-9.6 9.6c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l9.6-9.6c28.2-28.2 66.5-44 106.3-44zm-60 114.3c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l96 96c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-96-96zm-64 64c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l96 96c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-96-96z"]],
    "circle-eurozone": [512, 512, [], "e745", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zm112-88c0-4.4 3.6-8 8-8l80 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-72 0 0 75.2 64 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-64 0 0 68.8 73.6 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L136 352c-4.4 0-8-3.6-8-8l0-176zm144 0c0-4.4 3.6-8 8-8l96 0c2.8 0 5.4 1.5 6.9 3.9s1.5 5.4 .1 7.9L293.5 336 376 336c4.4 0 8 3.6 8 8s-3.6 8-8 8l-96 0c-2.8 0-5.4-1.5-6.9-3.9s-1.5-5.4-.1-7.9L362.5 176 280 176c-4.4 0-8-3.6-8-8z", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM136 160c-4.4 0-8 3.6-8 8l0 176c0 4.4 3.6 8 8 8l81.6 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-73.6 0 0-68.8 64 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-64 0 0-75.2 72 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-80 0zm144 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l82.5 0-89.5 164.2c-1.4 2.5-1.3 5.5 .1 7.9s4.1 3.9 6.9 3.9l96 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-82.5 0 89.5-164.2c1.4-2.5 1.3-5.5-.1-7.9s-4.1-3.9-6.9-3.9l-96 0z"]],
    "shoe-prints": [576, 512, [], "f54b", ["M16 400c0-35.4 28.6-64 64-64l32 0 0 128-32 0c-35.3 0-64-28.7-64-64zM80 112c0-35.3 28.7-64 64-64l32 0 0 128-32 0c-35.3 0-64-28.7-64-64zm48 224c51.1 0 85.4-12.9 115.9-25.1l3.6-1.4c28.7-11.5 53.4-21.4 88.5-21.4 38.3 0 79.5 7.7 110.5 24.1 30.7 16.2 49.5 39.7 49.5 71.9 0 30.6-24.7 58.4-67.2 79.7-41.6 20.8-95.1 32.3-140.8 32.3-29.9 0-70.3-7.6-104.2-15.6-16.8-3.9-31.6-7.9-42.2-10.8-5.3-1.5-9.6-2.7-12.5-3.6-.4-.1-.8-.2-1.1-.3L128 336zM192 46.3c.3-.1 .7-.2 1.1-.3 2.9-.9 7.2-2.1 12.5-3.6 10.6-3 25.4-6.9 42.2-10.8 33.9-8 74.4-15.6 104.2-15.6 45.7 0 99.3 11.5 140.8 32.3 42.5 21.2 67.2 49.1 67.2 79.7 0 32.2-18.8 55.6-49.5 71.9-31 16.4-72.3 24.1-110.5 24.1-35 0-59.7-9.9-88.5-21.4l-3.6-1.4C277.4 188.9 243.1 176 192 176l0-129.7z", "M192 46.3L192 176c51.1 0 85.4 12.9 115.9 25.1l3.6 1.4c28.7 11.5 53.4 21.4 88.5 21.4 38.3 0 79.5-7.7 110.5-24.1 30.7-16.2 49.5-39.7 49.5-71.9 0-30.6-24.7-58.4-67.2-79.7-41.6-20.8-95.1-32.3-140.8-32.3-29.9 0-70.3 7.6-104.2 15.6-16.8 3.9-31.6 7.9-42.2 10.8-5.3 1.5-9.6 2.7-12.5 3.6-.4 .1-.8 .2-1.1 .3zM176 176l0-128-32 0c-35.3 0-64 28.7-64 64s28.6 64 64 64l32 0zm8-144S288.3 0 352 0c96 0 224 48 224 128S480 240 400 240c-38.2 0-65.4-10.9-93.9-22.4-31.2-12.5-63.9-25.6-114.1-25.6l-48 0c-44.2 0-80-35.8-80-80s35.8-80 80-80l40 0zM112 464l0-128-32 0c-35.3 0-64 28.6-64 64s28.7 64 64 64l32 0zm17.1 2c2.9 .9 7.2 2.1 12.5 3.6 10.6 3 25.4 6.9 42.2 10.8 33.9 8 74.4 15.6 104.2 15.6 45.7 0 99.3-11.5 140.8-32.3 42.5-21.2 67.2-49.1 67.2-79.7 0-32.2-18.8-55.6-49.5-71.9-31-16.4-72.3-24.1-110.5-24.1-35 0-59.7 9.9-88.5 21.4l-3.6 1.4C213.4 323.1 179.1 336 128 336l0 129.7c.3 .1 .7 .2 1.1 .3zM120 480l-40 0c-44.2 0-80-35.8-80-80s35.8-80 80-80l48 0c50.2 0 82.9-13.1 114.1-25.6 28.5-11.4 55.7-22.4 93.9-22.4 80 0 176 32 176 112S384 512 288 512c-63.7 0-168-32-168-32z"]],
    "squirrel": [512, 512, [], "f71a", ["M16 140.3C16 71.6 71.6 16 140.3 16S264.5 71.6 264.5 140.3l0 33.1c0 4.4 3.6 8 8 8 3.4 0 6.3-2.1 7.5-5.1l0 83.4c-6.9 8.5-14.7 17.5-23.5 27.6-2.8 3.2-5.7 6.6-8.7 10l-11.2 13c-18.7 21.6-28.6 53.7-28.6 81.8 0 4.4 3.6 8 8 8s8-3.6 8-8c0-24.9 9-53.1 24.7-71.3l11.2-13c3-3.4 5.8-6.7 8.7-10 19.6-22.6 35.8-41.2 47.2-61.6 13.3-23.9 20.2-50 20.2-87.9L336 80c13.3 0 24 10.7 24 24 0 4.4 3.6 8 8 8s8-3.6 8-8c0-13.3 10.7-24 24-24l0 24c0 4.4 3.6 8 8 8l15.6 0c37 0 68 28 71.6 64.8l.6 5.9-4.5 10.5c-10.1 23.5-33.2 38.8-58.8 38.8L416 232c-4.4 0-8 3.6-8 8l0 100.8c-13.7-8.1-29.7-12.8-46.8-12.8-9.6 0-18.9 1.5-27.6 4.2-4.2 1.3-6.6 5.8-5.2 10s5.8 6.6 10 5.2c7.2-2.3 14.8-3.5 22.8-3.5 42 0 76 34 76 76s-34 76-76 76L256 496c-59.5 0-107.7-48.2-107.7-107.7 0-23.1 7.2-44.4 19.6-61.9 8.5-12.1 11.9-28.9 4-43.2-6.3-11.5-18.4-18.6-31.5-18.6-68.6 0-124.3-55.6-124.3-124.3zM400 160a16 16 0 1 0 32 0 16 16 0 1 0 -32 0z", "M140.3 16C71.6 16 16 71.6 16 140.3S71.6 264.5 140.3 264.5c13.1 0 25.2 7.1 31.5 18.6 7.9 14.3 4.5 31.1-4 43.2-12.3 17.5-19.6 38.9-19.6 61.9 0 59.5 48.2 107.7 107.7 107.7l105.2 0c42 0 76-34 76-76s-34-76-76-76c-8 0-15.6 1.2-22.8 3.5-4.2 1.3-8.7-1-10-5.2s1-8.7 5.2-10c8.7-2.7 18-4.2 27.6-4.2 17.1 0 33.1 4.7 46.8 12.8L408 240c0-4.4 3.6-8 8-8l16.5 0c25.6 0 48.7-15.3 58.8-38.8l4.5-10.5-.6-5.9C491.6 140 460.6 112 423.6 112L408 112c-4.4 0-8-3.6-8-8l0-24c-13.3 0-24 10.7-24 24 0 4.4-3.6 8-8 8s-8-3.6-8-8c0-13.3-10.7-24-24-24l0 68.2c0 37.9-6.8 64.1-20.2 87.9-11.4 20.4-27.6 39-47.2 61.6-2.8 3.2-5.7 6.6-8.7 10l-11.2 13c-15.7 18.2-24.7 46.4-24.7 71.3 0 4.4-3.6 8-8 8s-8-3.6-8-8c0-28.1 10-60.2 28.6-81.8l11.2-13c3-3.5 5.9-6.8 8.7-10l0 0c19.8-22.8 34.8-40 45.3-58.9 11.8-21.1 18.1-44.4 18.1-80.1L320 80c0-8.8 7.2-16 16-16 13.1 0 24.7 6.3 32 16 7.3-9.7 18.9-16 32-16 8.8 0 16 7.2 16 16l0 16 7.6 0c45.2 0 83.1 34.3 87.6 79.2l.8 8c.1 1.3-.1 2.7-.6 3.9l-5.3 12.4c-12.6 29.4-41.5 48.5-73.5 48.5l-8.5 0 0 104-.8 0c18.5 16.8 30 41.1 30 68 0 31.6-15.9 59.4-40.1 76l58.9 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-216 0c-68.3 0-123.7-55.4-123.7-123.7 0-26.5 8.3-51 22.5-71.1 6-8.5 7.2-18.6 3-26.3-3.5-6.4-10.2-10.3-17.5-10.3-77.5 0-140.3-62.8-140.3-140.3S62.8 0 140.3 0 280.5 62.8 280.5 140.3l0 33.1c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-33.1C264.5 71.6 208.9 16 140.3 16zM416 144a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"]],
    "circle-cedi": [512, 512, [], "e742", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zm113.9 0c0-67.5 52-122.8 118.1-128.1l0-23.9c0-4.4 3.6-8 8-8s8 3.6 8 8l0 23.5c32 1.3 61 14.4 82.8 35 3.4 3.2 3.6 8.7 .3 12.1s-8.7 3.6-12.1 .3c-18.7-17.7-43.5-28.9-71-30.3l0 222.6c27.4-1.3 52.3-12.6 71-30.3 3.4-3.3 8.9-3.1 12.1 .3s3.1 8.9-.3 12.1c-21.8 20.6-50.8 33.6-82.8 35l0 23.5c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-23.9c-66.1-5.3-118.1-60.7-118.1-128.1zm17.1 0c0 58 44.3 105.6 100.9 110.9l0-221.9C191.4 150.4 147.1 198 147.1 256z", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm8-408c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 23.9c-66.1 5.3-118.1 60.7-118.1 128.1s52 122.8 118.1 128.1l0 23.9c0 4.4 3.6 8 8 8s8-3.6 8-8l0-23.5c32-1.3 61-14.4 82.8-35 3.4-3.2 3.6-8.7 .3-12.1s-8.7-3.6-12.1-.3c-18.7 17.7-43.5 28.9-71 30.3l0-222.6c27.4 1.3 52.3 12.6 71 30.3 3.4 3.2 8.9 3.1 12.1-.3s3.1-8.9-.3-12.1c-21.8-20.6-50.8-33.6-82.8-35l0-23.5zM147.1 256c0-58 44.3-105.6 100.9-110.9l0 221.9C191.4 361.6 147.1 314 147.1 256z"]],
    "file-circle-exclamation": [576, 512, [], "e4eb", ["M48 64c0-26.5 21.5-48 48-48l133.5 0c3.6 0 7.1 .4 10.5 1.2L240 120c0 30.9 25.1 56 56 56l102.8 0c.8 3.4 1.2 6.9 1.2 10.5l0 24.1c-90.8 15.2-160 94.2-160 189.3 0 35 9.3 67.8 25.7 96L96 496c-26.5 0-48-21.5-48-48L48 64z", "M96 16l133.5 0c3.6 0 7.1 .4 10.5 1.2L240 120c0 30.9 25.1 56 56 56l102.8 0c.8 3.4 1.2 6.9 1.2 10.5l0 24.1c5.3-.9 10.6-1.6 16-2l0-22.1c0-17-6.7-33.3-18.7-45.3L274.7 18.7C262.7 6.7 246.5 0 229.5 0L96 0C60.7 0 32 28.7 32 64l0 384c0 35.3 28.7 64 64 64l180 0c-3.7-5.1-7.2-10.5-10.3-16L96 496c-26.5 0-48-21.5-48-48L48 64c0-26.5 21.5-48 48-48zM392 160l-96 0c-22.1 0-40-17.9-40-40l0-96c2.7 1.8 5.1 3.8 7.4 6.1L385.9 152.6c2.3 2.3 4.3 4.8 6.1 7.4zM304 400a128 128 0 1 1 256 0 128 128 0 1 1 -256 0zm272 0a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zM432 476a12 12 0 1 0 0-24 12 12 0 1 0 0 24zm0-164c-4.4 0-8 3.6-8 8l0 96c0 4.4 3.6 8 8 8s8-3.6 8-8l0-96c0-4.4-3.6-8-8-8z"]],
    "wallet": [512, 512, [], "f555", ["M16 104c0-30.9 25.1-56 56-56l400 0c4.4 0 8-3.6 8-8l0 68.1C468.6 100.5 454.8 96 440 96L104 96c-4.4 0-8 3.6-8 8s3.6 8 8 8l336 0c30.9 0 56 25.1 56 56l0 208c0 30.9-25.1 56-56 56L72 432c-30.9 0-56-25.1-56-56l0-272zM352 272a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M72 32C32.2 32 0 64.2 0 104L0 376c0 39.8 32.2 72 72 72l368 0c39.8 0 72-32.2 72-72l0-208c0-39.8-32.2-72-72-72L104 96c-4.4 0-8 3.6-8 8s3.6 8 8 8l336 0c30.9 0 56 25.1 56 56l0 208c0 30.9-25.1 56-56 56L72 432c-30.9 0-56-25.1-56-56l0-272c0-30.9 25.1-56 56-56l400 0c4.4 0 8-3.6 8-8s-3.6-8-8-8L72 32zM368 272a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm48 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"]],
    "square-tugrik": [448, 512, [], "e728", ["M16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96zm96 40c0-4.4 3.6-8 8-8l208 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-96 0 0 84.9 61.5-20.5c4.2-1.4 8.7 .9 10.1 5.1s-.9 8.7-5.1 10.1l-66.5 22.2 0 47.1 61.5-20.5c4.2-1.4 8.7 .9 10.1 5.1s-.9 8.7-5.1 10.1L232 309.8 232 376c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-60.9-61.5 20.5c-4.2 1.4-8.7-.9-10.1-5.1s.9-8.7 5.1-10.1l66.5-22.2 0-47.1-61.5 20.5c-4.2 1.4-8.7-.9-10.1-5.1s.9-8.7 5.1-10.1l66.5-22.2 0-90.2-96 0c-4.4 0-8-3.6-8-8z", "M64 48C37.5 48 16 69.5 16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm112 40c0-4.4 3.6-8 8-8l208 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-96 0 0 84.9 61.5-20.5c4.2-1.4 8.7 .9 10.1 5.1s-.9 8.7-5.1 10.1l-66.5 22.2 0 47.1 61.5-20.5c4.2-1.4 8.7 .9 10.1 5.1s-.9 8.7-5.1 10.1L232 309.8 232 376c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-60.9-61.5 20.5c-4.2 1.4-8.7-.9-10.1-5.1s.9-8.7 5.1-10.1l66.5-22.2 0-47.1-61.5 20.5c-4.2 1.4-8.7-.9-10.1-5.1s.9-8.7 5.1-10.1l66.5-22.2 0-90.2-96 0c-4.4 0-8-3.6-8-8z"]],
    "message": [512, 512, ["comment-alt"], "f27a", ["M16 128l0 224c0 44.2 35.8 80 80 80l32 0c8.8 0 16 7.2 16 16l0 75.9c0 2.3 2 4 4.1 4.1 .8 0 1.7-.2 2.4-.7 3.3-2.3 6.3-4.5 9.1-6.4l.4-.3c6.7-4.7 30.4-21.5 117.2-82.7 5.4-3.8 11.8-5.9 18.5-5.9L416 432c44.2 0 80-35.8 80-80l0-224c0-44.2-35.8-80-80-80L96 48c-44.2 0-80 35.8-80 80z", "M144 492.7l0-44.7c0-8.8-7.2-16-16-16l-32 0c-44.2 0-80-35.8-80-80l0-224c0-44.2 35.8-80 80-80l320 0c44.2 0 80 35.8 80 80l0 224c0 44.2-35.8 80-80 80l-120.4 0c-6.6 0-13.1 2-18.5 5.9L176 509.3c-.2 .2-5.6 3.9-16 11.3l-.4 .3c-2.8 2-5.8 4.1-9.1 6.4-.7 .5-1.6 .7-2.4 .7-2.1-.1-4.1-1.8-4.1-4.1l0-31.2zM96 32C43 32 0 75 0 128L0 352c0 53 43 96 96 96l32 0 0 75.9c0 11.1 9 20.1 20.1 20.1 4.2 0 8.2-1.3 11.6-3.7l126.6-89.4c2.7-1.9 5.9-2.9 9.2-2.9L416 448c53 0 96-43 96-96l0-224c0-53-43-96-96-96L96 32z"]],
    "trophy": [512, 512, [127942], "f091", ["M113.1 47.6c6.3 165.9 45.5 245.5 80.2 283.6 17.3 19 33.8 28.1 45.5 32.5 13.6 5.1 21.2 5.1 34.8 0 11.7-4.4 28.2-13.5 45.5-32.5 34.7-38.1 73.9-117.8 80.2-283.6 .7-17.1-13.4-31.6-31.1-31.6l-224 0c-17.7 0-31.8 14.5-31.1 31.6z", "M144.3 16l224 0c17.7 0 31.8 14.5 31.1 31.6-6.3 165.9-45.5 245.5-80.2 283.6-17.3 19-33.8 28.1-45.5 32.5-13.6 5.1-21.2 5.1-34.8 0-11.7-4.4-28.2-13.5-45.5-32.5-34.7-38.1-73.9-117.8-80.2-283.6-.7-17.1 13.4-31.6 31.1-31.6zm224-16l-224 0c-26.5 0-48.1 21.8-47.1 48.2 .2 5.3 .4 10.6 .7 15.8L32.3 64c-17.5 0-32.4 14.4-31.2 32.6 4.4 65.7 26.5 112.8 55.9 145.8 29 32.5 64.6 50.8 96.2 59.8 35.6 63.4 77.8 77.7 95.1 81l0 113-112 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l240 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-112 0 0-113c17.6-3.3 61-18.1 97-84.4 65.5-20.8 141.3-78.2 150.1-202.1 1.3-18.2-13.6-32.6-31.1-32.6l-65.6 0c.3-5.2 .5-10.4 .7-15.8 1-26.5-20.6-48.2-47.1-48.2zm45.4 80l66.6 0c9 0 15.8 7.2 15.2 15.4-7.6 106.6-67.4 159.8-124 182.6 19.9-44.6 36.2-108 42.3-198zM142.9 281.9c-25.2-9.4-51.7-25.3-73.9-50.2-26.8-30.1-47.7-73.7-51.9-136.2-.6-8.3 6.2-15.5 15.2-15.5l66.6 0c6.3 92.7 23.3 157.1 44 201.9z"]],
    "face-dizzy": [512, 512, ["dizzy"], "f567", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zm90.3-117.7c3.1-3.1 8.2-3.1 11.3 0l42.3 42.3 42.3-42.3c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3l-42.3 42.3 42.3 42.3c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-42.3-42.3-42.3 42.3c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l42.3-42.3-42.3-42.3c-3.1-3.1-3.1-8.2 0-11.3zM328 352a72 72 0 1 1 -144 0 72 72 0 1 1 144 0zM298.3 138.3c3.1-3.1 8.2-3.1 11.3 0l42.3 42.3 42.3-42.3c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3l-42.3 42.3 42.3 42.3c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-42.3-42.3-42.3 42.3c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l42.3-42.3-42.3-42.3c-3.1-3.1-3.1-8.2 0-11.3z", "M496 256a240 240 0 1 0 -480 0 240 240 0 1 0 480 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zM117.7 138.3l42.3 42.3 42.3-42.3c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3l-42.3 42.3 42.3 42.3c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-42.3-42.3-42.3 42.3c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l42.3-42.3-42.3-42.3c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0zm192 0l42.3 42.3 42.3-42.3c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3l-42.3 42.3 42.3 42.3c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-42.3-42.3-42.3 42.3c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l42.3-42.3-42.3-42.3c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0zM200 352a56 56 0 1 0 112 0 56 56 0 1 0 -112 0zm56 72a72 72 0 1 1 0-144 72 72 0 1 1 0 144z"]],
    "bacteria": [640, 512, [], "e059", ["M71.4 167.4c-31.2 31.2-31.2 81.9 0 113.1s81.9 31.2 113.1 0l128-128c31.2-31.2 31.2-81.9 0-113.1s-81.9-31.2-113.1 0l-128 128zM144 224a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm64-64a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zM327.4 359.4c-31.2 31.2-31.2 81.9 0 113.1s81.9 31.2 113.1 0l128-128c31.2-31.2 31.2-81.9 0-113.1s-81.9-31.2-113.1 0l-128 128zM400 416a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M256-24c4.4 0 8 3.6 8 8L264 .3c19.3 1.6 38.3 9.1 54 22.4l12.3-12.3c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3L329.3 34c13.3 15.7 20.8 34.6 22.4 54L368 88c4.4 0 8 3.6 8 8s-3.6 8-8 8l-16.3 0c-1.6 19.3-9.1 38.3-22.4 54l12.3 12.3c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-12.1-12.1-52.7 52.7 12.1 12.1c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-12.1-12.1-52.7 52.7 12.1 12.1c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L190 297.3c-15.7 13.3-34.6 20.8-54 22.4l0 16.3c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-16.3c-19.3-1.6-38.3-9.1-54-22.4L53.7 309.7c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3L54.7 286c-13.3-15.7-20.8-34.6-22.4-54L16 232c-4.4 0-8-3.6-8-8s3.6-8 8-8l16.3 0c1.6-19.3 9.1-38.3 22.4-54L42.3 149.7c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0l12.1 12.1 52.7-52.7-12.1-12.1c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0l12.1 12.1 52.7-52.7-12.1-12.1c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0L194 22.7C209.7 9.4 228.7 1.9 248 .3L248-16c0-4.4 3.6-8 8-8zm56.6 176.6c31.2-31.2 31.2-81.9 0-113.1s-81.9-31.2-113.1 0l-128 128c-31.2 31.2-31.2 81.9 0 113.1s81.9 31.2 113.1 0l128-128zM128 208a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm48-48a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm344 16l0 16.3c19.3 1.6 38.3 9.1 54 22.4l12.3-12.3c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3L585.3 226c13.3 15.7 20.8 34.6 22.4 54l16.3 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-16.3 0c-1.6 19.3-9.1 38.3-22.4 54l12.3 12.3c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-12.1-12.1-52.7 52.7 12.1 12.1c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-12.1-12.1-52.7 52.7 12.1 12.1c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L446 489.3c-15.7 13.3-34.6 20.8-54 22.4l0 16.3c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-16.3c-19.3-1.6-38.3-9.1-54-22.4l-12.3 12.3c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3L310.7 478c-13.3-15.7-20.8-34.6-22.4-54L272 424c-4.4 0-8-3.6-8-8s3.6-8 8-8l16.3 0c1.6-19.3 9.1-38.3 22.4-54l-12.4-12.3c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0l12.1 12.1 52.7-52.7-12.1-12.1c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0l12.1 12.1 52.7-52.7-12.1-12.1c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0L450 214.7c15.7-13.3 34.6-20.8 54-22.4l0-16.3c0-4.4 3.6-8 8-8s8 3.6 8 8zm48.6 55.4c-31.2-31.2-81.9-31.2-113.1 0l-128 128c-31.2 31.2-31.2 81.9 0 113.1s81.9 31.2 113.1 0l128-128c31.2-31.2 31.2-81.9 0-113.1zM368 416a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"]],
    "toggle-large-on": [576, 512, [], "e5b1", ["M16 256c0 79.5 64.5 144 144 144l186.2 0C292.8 374.1 256 319.3 256 256s36.8-118.1 90.2-144L160 112C80.5 112 16 176.5 16 256z", "M416 112a144 144 0 1 0 0 288 144 144 0 1 0 0-288zm0 304l-256 0C71.6 416 0 344.4 0 256S71.6 96 160 96l256 0c88.4 0 160 71.6 160 160S504.4 416 416 416zm-69.8-16C292.8 374.1 256 319.3 256 256s36.8-118.1 90.2-144L160 112C80.5 112 16 176.5 16 256S80.5 400 160 400l186.2 0z"]],
    "ear-deaf": [512, 512, ["deaf", "deafness", "hard-of-hearing"], "f2a4", ["M75.6 245.3c2.6-1.3 4.4-4 4.4-7.1 0-87.3 71.6-158.2 160-158.2s160 70.9 160 158.2c0 46.2-20.1 87.9-52.1 116.8-8.9 8-15.1 19.4-15.1 32.2l0 4.8c0 57.4-46.6 104-104 104l-22.4 0c-1.3 0-2.5 .3-3.6 .9l-59.2-117.1 46.1-46.1c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0L136 364.7 75.6 245.3zM128 240c0 4.4 3.6 8 8 8s8-3.6 8-8c0-53 43-96 96-96s96 43 96 96c0 4.4 3.6 8 8 8s8-3.6 8-8c0-61.9-50.1-112-112-112S128 178.1 128 240z", "M509.7 13.7l-80 80c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l80-80c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3zm-320 320l-176 176c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l176-176c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3zM240 80c-88.4 0-160 70.9-160 158.2 0 4.4-3.6 8-8 8s-8-3.6-8-8C64 141.9 142.9 64 240 64s176 77.9 176 174.2c0 51-22.2 96.8-57.4 128.7-6.1 5.6-9.8 12.9-9.8 20.4l0 4.8c0 66.3-53.7 120-120 120l-22.4 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l22.4 0c57.4 0 104-46.6 104-104l0-4.8c0-12.8 6.2-24.2 15.1-32.2 32.1-28.9 52.1-70.6 52.1-116.8 0-87.3-71.6-158.2-160-158.2zm0 64c-53 0-96 43-96 96 0 4.4-3.6 8-8 8s-8-3.6-8-8c0-61.9 50.1-112 112-112s112 50.1 112 112c0 4.4-3.6 8-8 8s-8-3.6-8-8c0-53-43-96-96-96z"]],
    "people-arrows": [512, 512, ["people-arrows-left-right"], "e068", ["M16 232l0 48c0 20.7 11.2 38.8 28 48.5 2.5 1.4 4 4.1 4 6.9L48 464c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32 0-42.9 0-85.7 0-128.8-13.2-13.2-26.4-26.4-39.6-39.6-21.9-21.9-21.9-57.3 0-79.2 12.1-12.1 24.3-24.3 36.4-36.4-6.4-2.6-13.5-4-20.8-4l-48 0c-30.9 0-56 25.1-56 56zM48 64a48 48 0 1 0 96 0 48 48 0 1 0 -96 0zM360 343.2c2.7-2.6 5.3-5.2 8-7.8L368 464c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-128.6c0-2.9 1.5-5.5 4-6.9 16.8-9.7 28-27.8 28-48.5l0-48c0-30.9-25.1-56-56-56l-48 0c-7.4 0-14.4 1.4-20.8 4 12.1 12.1 24.3 24.3 36.4 36.4 21.9 21.9 21.9 57.3 0 79.2L360 343.2zM368 64a48 48 0 1 0 96 0 48 48 0 1 0 -96 0z", "M96 112a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM96 0A64 64 0 1 1 96 128 64 64 0 1 1 96 0zM72 176c-30.9 0-56 25.1-56 56l0 48c0 20.7 11.2 38.8 28 48.5 2.5 1.4 4 4.1 4 6.9L48 464c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-128.6 0-.2 16 16 0 112.8c0 26.5-21.5 48-48 48l-32 0c-26.5 0-48-21.5-48-48l0-124.1C12.7 327 0 305 0 280l0-48c0-39.8 32.2-72 72-72l48 0c11.8 0 23 2.9 32.9 7.9L140.8 180c-6.4-2.6-13.5-4-20.8-4l-48 0zM352 464l0-112.8 16-16 0 .2 0 128.6c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-128.6c0-2.9 1.5-5.5 4-6.9 16.8-9.7 28-27.8 28-48.5l0-48c0-30.9-25.1-56-56-56l-48 0c-7.4 0-14.4 1.4-20.8 4l-12.1-12.1c9.9-5.1 21-7.9 32.9-7.9l48 0c39.8 0 72 32.2 72 72l0 48c0 25-12.7 47-32 59.9L480 464c0 26.5-21.5 48-48 48l-32 0c-26.5 0-48-21.5-48-48zm64-352a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM416 0a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM213.7 197.7l-50.3 50.3 185.4 0-50.3-50.3c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0l64 64c3.1 3.1 3.1 8.2 0 11.3l-64 64c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l50.3-50.3-185.4 0 50.3 50.3c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-64-64c-3.1-3.1-3.1-8.2 0-11.3l64-64c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3z"]],
    "treasure-chest": [512, 512, [], "f723", ["M16 160l0 104 96 0 0-214.9C57.7 56.9 16 103.6 16 160zm0 120l0 136c0 26.5 21.5 48 48 48l48 0 0-184-96 0zM128 48l0 216 96 0 0-40c0-17.7 14.3-32 32-32s32 14.3 32 32l0 40 96 0 0-216-256 0zm0 232l0 184 256 0 0-184-96 0 0 40c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-40-96 0zM400 49.1l0 214.9 96 0 0-104c0-56.4-41.7-103.1-96-110.9zM400 280l0 184 48 0c26.5 0 48-21.5 48-48l0-136-96 0z", "M384 48l0 216-96 0 0-40c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 40-96 0 0-216 256 0zm16 1.1c54.3 7.8 96 54.4 96 110.9l0 104-96 0 0-214.9zM496 280l0 136c0 26.5-21.5 48-48 48l-48 0 0-184 96 0zM384 464l-256 0 0-184 96 0 0 40c0 17.7 14.3 32 32 32s32-14.3 32-32l0-40 96 0 0 184zm-272 0l-48 0c-26.5 0-48-21.5-48-48l0-136 96 0 0 184zM16 264l0-104c0-56.4 41.7-103.1 96-110.9l0 214.9-96 0zM128 32C57.3 32 0 89.3 0 160L0 416c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-256c0-70.7-57.3-128-128-128L128 32zM272 320c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-96c0-8.8 7.2-16 16-16s16 7.2 16 16l0 96z"]],
    "caret-large-right": [256, 512, [], "e82e", ["M48 97.9c0-9.6 7.6-17.5 17.1-17.9 3.8 .3 7.4 1.9 10.2 4.7l160 160c3.1 3.1 4.7 7.2 4.7 11.3 0 4.1-1.6 8.2-4.7 11.3l-160 160c-2.8 2.8-6.5 4.4-10.2 4.6-9.5-.4-17.1-8.3-17.1-17.9L48 97.9z", "M256 256c0 10.2-4.1 20.1-11.3 27.3L89.9 438.1c-6.4 6.4-15 9.9-24 9.9l-3.5-.2c-16-1.6-28.7-14.3-30.3-30.3l-.2-3.5 0-316.1c0-17.6 13.4-32 30.5-33.8l3.5-.2c7.9 0 15.5 2.7 21.5 7.7l2.5 2.3 154.8 154.7c7.2 7.2 11.3 17.1 11.3 27.3zm-16 0c0-6-2.4-11.8-6.6-16L78.6 85.2C75.3 81.9 70.7 80 65.9 80 56 80 48 88 48 97.9l0 316.1c0 9.9 8 17.9 17.9 17.9 4.8 0 9.3-1.9 12.7-5.3L233.4 272c4.2-4.2 6.6-10 6.6-16z"]],
    "hands-clapping": [512, 512, [], "e1a8", ["M24 257.9c0 6.9 2.7 13.5 7.6 18.3 33.7 33.7 62.3 62.3 86.1 86.1 3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L68.3 335.6c-4.9-4.9-11.5-7.6-18.3-7.6-14.3 0-25.9 11.6-25.9 25.9 0 6.9 2.7 13.5 7.6 18.3 30.8 30.8 48.3 48.3 79.7 79.7 28.2 28.2 66.5 44 106.3 44 83.1 0 150.4-67.3 150.4-150.4L368 200c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 80c0 4.4-3.6 8-8 8-2.2 0-4.2-.9-5.7-2.3L172.3 151.6c-4.9-4.9-11.5-7.6-18.3-7.6-14.3 0-25.9 11.6-25.9 25.9 0 6.9 2.7 13.5 7.6 18.3l78.1 78.1c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0c-59.7-59.7-96.4-96.4-110.1-110.1-4.9-4.9-11.5-7.6-18.3-7.6-14.3 0-25.9 11.6-25.9 25.9 0 6.9 2.7 13.5 7.6 18.3 5.7 5.7 42.4 42.4 110.1 110.1 3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L68.3 239.6c-4.9-4.9-11.5-7.6-18.3-7.6-14.3 0-25.9 11.6-25.9 25.9zM372.8 493.6C442.9 480.7 496 419.4 496 345.6L496 200c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 80c0 4.4-3.6 8-8 8s-8-3.6-8-8l0 65.6c0 57.4-22.5 109.5-59.2 147.9z", "M328 8c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 72c0 4.4 3.6 8 8 8s8-3.6 8-8l0-72zM219.4 25.5c-3.6 2.6-4.4 7.6-1.9 11.2l40 56c2.6 3.6 7.6 4.4 11.2 1.9s4.4-7.6 1.9-11.2l-40-56c-2.6-3.6-7.6-4.4-11.2-1.9zm201.3 0c-3.6-2.6-8.6-1.7-11.2 1.9l-40 56c-2.6 3.6-1.7 8.6 1.9 11.2s8.6 1.7 11.2-1.9l40-56c2.6-3.6 1.7-8.6-1.9-11.2zM153.9 144c6.9 0 13.5 2.7 18.3 7.6L306.3 285.7c1.4 1.4 3.4 2.3 5.7 2.3 4.4 0 8-3.6 8-8l0-80c0-13.3 10.7-24 24-24s24 10.7 24 24l0 145.6c0 83.1-67.3 150.4-150.4 150.4-39.9 0-78.1-15.8-106.3-44l-41.6-41.6 0 0c-9.7-9.7-22.3-22.3-38.1-38.1-4.9-4.9-7.6-11.5-7.6-18.3 0-14.3 11.6-25.9 25.9-25.9 6.9 0 13.5 2.7 18.3 7.6l0 0 38.1 38.1c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3c-23.7-23.7-52.4-52.4-86.1-86.1-4.9-4.9-7.6-11.5-7.6-18.3 0-14.3 11.6-25.9 25.9-25.9 6.9 0 13.5 2.7 18.3 7.6l0 0 86.1 86.1c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3c-67.7-67.7-104.4-104.4-110.1-110.1-4.9-4.9-7.6-11.5-7.6-18.3 0-14.3 11.6-25.9 25.9-25.9 6.9 0 13.5 2.7 18.3 7.6 13.7 13.7 50.3 50.3 110.1 110.1 3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-78.1-78.1c-4.9-4.9-7.6-11.5-7.6-18.3 0-14.3 11.6-25.9 25.9-25.9zM45 216.3c-20.8 2.5-37 20.2-37 41.7 0 11.1 4.4 21.8 12.3 29.7L45 312.3c-20.8 2.5-37 20.2-37 41.7 0 11.1 4.4 21.8 12.3 29.7 15.7 15.7 28.4 28.4 38.1 38.1l0 0 41.6 41.6c31.2 31.2 73.5 48.7 117.7 48.7 91.9 0 166.4-74.5 166.4-166.4L384 200c0-22.1-17.9-40-40-40s-40 17.9-40 40l0 60.7-120.4-120.4c-7.9-7.9-18.5-12.3-29.7-12.3-21.5 0-39.2 16.2-41.7 37l-8.7-8.7c-7.9-7.9-18.5-12.3-29.7-12.3-23.2 0-41.9 18.8-41.9 41.9 0 11.1 4.4 21.8 12.3 29.7l.7 .7zM512 345.6L512 200c0-22.1-17.9-40-40-40s-40 17.9-40 40l0 80c0 4.4 3.6 8 8 8s8-3.6 8-8l0-80c0-13.3 10.7-24 24-24s24 10.7 24 24l0 145.6c0 73.8-53.1 135.2-123.2 147.9-6.2 6.5-12.8 12.6-19.8 18.3 88.5-3.9 159-76.8 159-166.2z"]],
    "circle-ampersand": [512, 512, [], "e0f8", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zm128 67.3c0-19.7 9.6-38.2 25.7-49.6l45-31.7-23.1-23.1c-10-10-15.6-23.5-15.6-37.7 0-29.4 23.8-53.3 53.3-53.3l18.7 0c26.5 0 48 21.5 48 48l0 3.3c0 15.6-7.6 30.2-20.3 39.2l-36.3 25.6 70.6 70.6 43.7-55.6c2.7-3.5 7.8-4.1 11.2-1.3s4.1 7.8 1.3 11.2l-44.9 57.1 44.3 44.3c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-42.9-42.9-16.3 20.8C283 375 264.4 384 244.8 384l-40.1 0c-33.5 0-60.7-27.2-60.7-60.7zm16 0c0 24.7 20 44.7 44.7 44.7l40.1 0c14.7 0 28.6-6.8 37.7-18.3l17.5-22.3-73.9-73.9-47.2 33.3c-11.9 8.4-18.9 22-18.9 36.5zm32-142.1c0 9.9 3.9 19.4 10.9 26.3l25 25 38.5-27.2c8.5-6 13.5-15.7 13.5-26.1l0-3.3c0-17.7-14.3-32-32-32l-18.7 0c-20.6 0-37.3 16.7-37.3 37.3z", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM192 181.3c0-20.6 16.7-37.3 37.3-37.3l18.7 0c17.7 0 32 14.3 32 32l0 3.3c0 10.4-5.1 20.1-13.5 26.1l-38.5 27.2-25-25c-7-7-10.9-16.5-10.9-26.3zm83.7 37.2c12.7-9 20.3-23.6 20.3-39.2l0-3.3c0-26.5-21.5-48-48-48l-18.7 0c-29.4 0-53.3 23.8-53.3 53.3 0 14.1 5.6 27.7 15.6 37.7l23.1 23.1-45 31.7c-16.1 11.4-25.7 29.9-25.7 49.6 0 33.5 27.2 60.7 60.7 60.7l40.1 0c19.6 0 38.2-9 50.3-24.5l16.3-20.8 42.9 42.9c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-44.3-44.3 44.9-57.1c2.7-3.5 2.1-8.5-1.3-11.2s-8.5-2.1-11.2 1.3l-43.7 55.6-70.6-70.6 36.3-25.6zm-96.8 68.3l47.2-33.3 73.9 73.9-17.5 22.3c-9.1 11.6-23 18.3-37.7 18.3l-40.1 0c-24.7 0-44.7-20-44.7-44.7 0-14.5 7.1-28.1 18.9-36.5z"]],
    "virus-covid-slash": [576, 512, [], "e4a9", ["M169.4 126L418 374.6c28.6-31.3 46-72.9 46-118.6 0-97.2-78.8-176-176-176-45.7 0-87.3 17.4-118.6 46z", "M13.7-29.8c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l560 560c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-104.6-104.6 22.6-22.6c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0l-22.6 22.6-28.4-28.4c29.8-32.4 48.6-75 50.5-121.9l40.2 0 0 32c0 4.4 3.6 8 8 8s8-3.6 8-8l0-80c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 32-40.2 0c-1.9-47-20.7-89.6-50.5-122l28.4-28.4 0 0 22.6 22.6c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3L435.1 52.4c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l22.6 22.6 0 0-28.4 28.4c-32.4-29.8-75-48.6-122-50.5l0-40.2 32 0c4.4 0 8-3.6 8-8s-3.6-8-8-8L248 8c-4.4 0-8 3.6-8 8s3.6 8 8 8l32 0 0 40.2c-47 1.9-89.6 20.7-121.9 50.5l-28.4-28.4 22.6-22.6c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0L118.3 74.9 13.7-29.8zM169.4 126c31.3-28.6 72.9-46 118.6-46 97.2 0 176 78.8 176 176 0 45.7-17.4 87.3-46 118.6L169.4 126zM112 256c0-28.2 6.6-54.8 18.4-78.4l-11.9-11.9c-13.2 24.7-21.1 52.6-22.3 82.3l-40.2 0 0-32c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 80c0 4.4 3.6 8 8 8s8-3.6 8-8l0-32 40.2 0c1.9 47 20.7 89.6 50.5 122l-28.4 28.4 0 0-22.6-22.6c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l56.6 56.6c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-22.6-22.6 0 0 28.4-28.4c32.4 29.8 75 48.6 122 50.5l0 40.2-32 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l80 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-32 0 0-40.2c29.7-1.2 57.6-9.2 82.3-22.3l-11.9-11.9c-23.6 11.8-50.2 18.4-78.4 18.4-97.2 0-176-78.8-176-176z"]],
    "chart-simple-horizontal": [448, 512, [], "e474", ["M16 48l0 32c0 17.7 14.3 32 32 32l288 0c17.7 0 32-14.3 32-32l0-32c0-17.7-14.3-32-32-32L48 16C30.3 16 16 30.3 16 48zm0 384l0 32c0 17.7 14.3 32 32 32l160 0c17.7 0 32-14.3 32-32l0-32c0-17.7-14.3-32-32-32L48 400c-17.7 0-32 14.3-32 32z", "M368 48l0 32c0 17.7-14.3 32-32 32L48 112c-17.7 0-32-14.3-32-32l0-32c0-17.7 14.3-32 32-32l288 0c17.7 0 32 14.3 32 32zM336 0L48 0C21.5 0 0 21.5 0 48L0 80c0 26.5 21.5 48 48 48l288 0c26.5 0 48-21.5 48-48l0-32c0-26.5-21.5-48-48-48zm96 272c0 17.7-14.3 32-32 32L48 304c-17.7 0-32-14.3-32-32l0-32c0-17.7 14.3-32 32-32l352 0c17.7 0 32 14.3 32 32l0 32zm16-32c0-26.5-21.5-48-48-48L48 192c-26.5 0-48 21.5-48 48l0 32c0 26.5 21.5 48 48 48l352 0c26.5 0 48-21.5 48-48l0-32zM240 464c0 17.7-14.3 32-32 32L48 496c-17.7 0-32-14.3-32-32l0-32c0-17.7 14.3-32 32-32l160 0c17.7 0 32 14.3 32 32l0 32zm16-32c0-26.5-21.5-48-48-48L48 384c-26.5 0-48 21.5-48 48l0 32c0 26.5 21.5 48 48 48l160 0c26.5 0 48-21.5 48-48l0-32z"]],
    "down-from-dotted-line": [384, 512, [], "e407", ["M40.6 340.9c-1.2 3-.6 6.4 1.7 8.7l144 144c3.1 3.1 8.2 3.1 11.3 0l144-144c2.3-2.3 3-5.7 1.7-8.7s-4.2-4.9-7.4-4.9l-88 0c-4.4 0-8-3.6-8-8l0-152c0-17.7-14.3-32-32-32l-32 0c-17.7 0-32 14.3-32 32l0 152c0 4.4-3.6 8-8 8l-88 0c-3.2 0-6.2 1.9-7.4 4.9z", "M186.3 493.7l-144-144c-2.3-2.3-3-5.7-1.7-8.7S44.8 336 48 336l88 0c4.4 0 8-3.6 8-8l0-152c0-17.7 14.3-32 32-32l32 0c17.7 0 32 14.3 32 32l0 152c0 4.4 3.6 8 8 8l88 0c3.2 0 6.2 1.9 7.4 4.9l0 0c1.2 3 .6 6.4-1.7 8.7l-144 144c-3.1 3.1-8.2 3.1-11.3 0zM256 256l0-80c0-26.5-21.5-48-48-48l-32 0c-26.5 0-48 21.5-48 48l0 144-80 0c-9.7 0-18.5 5.8-22.2 14.8S24.2 354.1 31 361l144 144 0 0c9.4 9.4 24.6 9.4 33.9 0L353 361c6.9-6.9 8.9-17.2 5.2-26.2S345.7 320 336 320l-80 0 0-64zM0 16A16 16 0 1 0 32 16 16 16 0 1 0 0 16zm88 0a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zM192 32a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm72-16a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zM368 32a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"]],
    "calendar-days": [448, 512, ["calendar-alt"], "f073", ["M16 192l0 80 128 0 0-80-128 0zm0 96l0 80 128 0 0-80-128 0zm0 96l0 32c0 26.5 21.5 48 48 48l80 0 0-80-128 0zM160 192l0 80 128 0 0-80-128 0zm0 96l0 80 128 0 0-80-128 0zm0 96l0 80 128 0 0-80-128 0zM304 192l0 80 128 0 0-80-128 0zm0 96l0 80 128 0 0-80-128 0zm0 96l0 80 80 0c26.5 0 48-21.5 48-48l0-32-128 0z", "M128 8c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 56-48 0C28.7 64 0 92.7 0 128L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-288c0-35.3-28.7-64-64-64l-48 0 0-56c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 56-192 0 0-56zM112 80l0 24c0 4.4 3.6 8 8 8s8-3.6 8-8l0-24 192 0 0 24c0 4.4 3.6 8 8 8s8-3.6 8-8l0-24 48 0c26.5 0 48 21.5 48 48l0 48-416 0 0-48c0-26.5 21.5-48 48-48l48 0zM304 192l128 0 0 80-128 0 0-80zm-16 0l0 80-128 0 0-80 128 0zm-144 0l0 80-128 0 0-80 128 0zM16 288l128 0 0 80-128 0 0-80zm0 96l128 0 0 80-80 0c-26.5 0-48-21.5-48-48l0-32zm144 80l0-80 128 0 0 80-128 0zm144 0l0-80 128 0 0 32c0 26.5-21.5 48-48 48l-80 0zm128-96l-128 0 0-80 128 0 0 80zm-144 0l-128 0 0-80 128 0 0 80z"]],
    "lighthouse": [576, 512, [], "e612", ["M144.3 496l103.7 0 0-72c0-22.1 17.9-40 40-40s40 17.9 40 40l0 72 103.7 0-61-320-165.5 0-61 320zM208 68.9l0 91.1 160 0 0-91.1-80-51.4-80 51.4z", "M283.7 1.3c2.6-1.7 6-1.7 8.7 0l112 72c3.7 2.4 4.8 7.3 2.4 11.1s-7.3 4.8-11.1 2.4l-11.7-7.5 0 80.8 16 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-13 0 61 320 24 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-368 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l24 0 61-320-12.9 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l16 0 0-80.8-11.7 7.5c-3.7 2.4-8.7 1.3-11.1-2.4s-1.3-8.7 2.4-11.1l112-72zM264 496l48 0 0-72c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 72zm64 0l103.7 0-61-320-165.5 0-61 320 103.7 0 0-72c0-22.1 17.9-40 40-40s40 17.9 40 40l0 72zM368 68.9l-80-51.4-80 51.4 0 91.1 160 0 0-91.1zM35.6 24.8l64 32c4 2 5.6 6.8 3.6 10.7s-6.8 5.6-10.7 3.6l-64-32c-4-2-5.6-6.8-3.6-10.7s6.8-5.6 10.7-3.6zm64 174.3l-64 32c-4 2-8.8 .4-10.7-3.6s-.4-8.8 3.6-10.7l64-32c4-2 8.8-.4 10.7 3.6s.4 8.8-3.6 10.7zM551.2 28.4c2 4 .4 8.8-3.6 10.7l-64 32c-4 2-8.8 .4-10.7-3.6s-.4-8.8 3.6-10.7l64-32c4-2 8.8-.4 10.7 3.6zm-78.3 160c2-4 6.8-5.6 10.7-3.6l64 32c4 2 5.6 6.8 3.6 10.7s-6.8 5.6-10.7 3.6l-64-32c-4-2-5.6-6.8-3.6-10.7z"]],
    "diamond-turn-right": [512, 512, ["directions"], "f5eb", ["M16 256c0 11.1 4.4 21.8 12.3 29.7L226.3 483.7c7.9 7.9 18.5 12.3 29.7 12.3s21.8-4.4 29.7-12.3L483.7 285.7c7.9-7.9 12.3-18.5 12.3-29.7s-4.4-21.8-12.3-29.7L285.7 28.3C277.8 20.4 267.1 16 256 16s-21.8 4.4-29.7 12.3L28.3 226.3C20.4 234.2 16 244.9 16 256zm168 8c0-26.5 21.5-48 48-48l124.7 0-58.3-58.3c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0l72 72c3.1 3.1 3.1 8.2 0 11.3l-72 72c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3L356.7 232 232 232c-17.7 0-32 14.3-32 32l0 64c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-64z", "M28.3 226.3C20.4 234.2 16 244.9 16 256s4.4 21.8 12.3 29.7L226.3 483.7c7.9 7.9 18.5 12.3 29.7 12.3s21.8-4.4 29.7-12.3L483.7 285.7c7.9-7.9 12.3-18.5 12.3-29.7s-4.4-21.8-12.3-29.7L285.7 28.3C277.8 20.4 267.1 16 256 16s-21.8 4.4-29.7 12.3L28.3 226.3zM17 215L215 17C225.9 6.1 240.6 0 256 0s30.1 6.1 41 17L495 215c10.9 10.9 17 25.6 17 41s-6.1 30.1-17 41L297 495c-10.9 10.9-25.6 17-41 17s-30.1-6.1-41-17L17 297C6.1 286.1 0 271.4 0 256s6.1-30.1 17-41zm292.7-68.7l72 72c3.1 3.1 3.1 8.2 0 11.3l-72 72c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3L356.7 232 232 232c-17.7 0-32 14.3-32 32l0 64c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-64c0-26.5 21.5-48 48-48l124.7 0-58.3-58.3c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0z"]],
    "drone": [512, 512, [], "f85f", ["M176 224l0 64c0 26.5 21.5 48 48 48l64 0c26.5 0 48-21.5 48-48l0-64c0-26.5-21.5-48-48-48l-64 0c-26.5 0-48 21.5-48 48z", "M496 400c0-53-43-96-96-96l-1.1 0c.7-5.2 1.1-10.6 1.1-16 61.9 0 112 50.1 112 112s-50.1 112-112 112-112-50.1-112-112c5.4 0 10.8-.4 16-1.1l0 1.1c0 53 43 96 96 96s96-43 96-96zM398.9 208l1.1 0c53 0 96-43 96-96s-43-96-96-96-96 43-96 96l0 1.1c-5.2-.7-10.6-1.1-16-1.1 0-61.9 50.1-112 112-112s112 50.1 112 112-50.1 112-112 112c0-5.4-.4-10.8-1.1-16zM224 112c-5.4 0-10.8 .4-16 1.1l0-1.1c0-53-43-96-96-96s-96 43-96 96 43 96 96 96l1.1 0c-.7 5.2-1.1 10.6-1.1 16-61.9 0-112-50.1-112-112S50.1 0 112 0 224 50.1 224 112zM112 288c0 5.4 .4 10.8 1.1 16l-1.1 0c-53 0-96 43-96 96s43 96 96 96 96-43 96-96l0-1.1c5.2 .7 10.6 1.1 16 1.1 0 61.9-50.1 112-112 112S0 461.9 0 400 50.1 288 112 288zM224 176c-26.5 0-48 21.5-48 48l0 64c0 26.5 21.5 48 48 48l64 0c26.5 0 48-21.5 48-48l0-64c0-26.5-21.5-48-48-48l-64 0zm-64 48c0-14.8 5-28.4 13.4-39.2l-67.1-67.1c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0l67.1 67.1C195.6 165 209.2 160 224 160l64 0c14.8 0 28.4 5 39.2 13.4l67.1-67.1c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3l-67.1 67.1C347 195.6 352 209.2 352 224l0 64c0 14.8-5 28.4-13.4 39.2l67.1 67.1c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-67.1-67.1C316.4 347 302.8 352 288 352l-64 0c-14.8 0-28.4-5-39.2-13.4l-67.1 67.1c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l67.1-67.1C165 316.4 160 302.8 160 288l0-64z"]],
    "text": [384, 512, [], "f893", ["", "M16 72c0-13.3 10.7-24 24-24l144 0 0 416-96 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l208 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-96 0 0-416 144 0c13.3 0 24 10.7 24 24l0 80c0 4.4 3.6 8 8 8s8-3.6 8-8l0-80c0-22.1-17.9-40-40-40L40 32C17.9 32 0 49.9 0 72l0 80c0 4.4 3.6 8 8 8s8-3.6 8-8l0-80z"]],
    "square-guarani": [448, 512, [], "e70e", ["M16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96zm88 160c0-63.6 49.5-115.6 112-119.7l0-16.3c0-4.4 3.6-8 8-8s8 3.6 8 8l0 16.3c29.5 1.9 56.1 14.6 76 34 3.2 3.1 3.2 8.2 .1 11.3s-8.2 3.2-11.3 .1c-17-16.7-39.6-27.5-64.8-29.4l0 95.7 104 0c4.4 0 8 3.6 8 8 0 63.6-49.5 115.6-112 119.7l0 16.3c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-16.3c-62.5-4.1-112-56.2-112-119.7zm16 0c0 54.7 42.3 99.6 96 103.7l0-207.4c-53.7 4.1-96 49-96 103.7zm112 8l0 95.7c51.1-3.9 91.8-44.6 95.7-95.7L232 264z", "M64 48C37.5 48 16 69.5 16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm216 24c0-4.4 3.6-8 8-8s8 3.6 8 8l0 16.3c29.5 1.9 56.1 14.6 76 34 3.2 3.1 3.2 8.2 .1 11.3s-8.2 3.2-11.3 .1c-17-16.7-39.6-27.5-64.8-29.4l0 95.7 104 0c4.4 0 8 3.6 8 8 0 63.6-49.5 115.6-112 119.7l0 16.3c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-16.3c-62.5-4.1-112-56.2-112-119.7s49.5-115.6 112-119.7l0-16.3zM120 256c0 54.7 42.3 99.6 96 103.7l0-207.4c-53.7 4.1-96 49-96 103.7zm207.7 8l-95.7 0 0 95.7c51.1-3.9 91.8-44.6 95.7-95.7z"]],
    "toilet-paper-under-slash": [576, 512, ["toilet-paper-reverse-slash"], "e2a1", ["M106 62.6l219 219c-3.3-18.2-5.1-37.6-5.1-57.7 0-51.9 11.9-99.3 31.5-134 9.8-17.3 21.7-31.8 35.3-42L144 48c-13.1 0-26 5-38 14.6zM336 224c0 28.4 3.7 55.2 10.3 78.9l96 96c20.8-4.2 40.6-21.2 56.2-48.8 18-31.9 29.4-76.5 29.4-126.2s-11.4-94.3-29.4-126.2C480.4 65.7 456.6 48 432 48s-48.4 17.7-66.6 49.8C347.4 129.7 336 174.3 336 224zm62 0c0-13.2 2.3-26 6.6-36 2.1-5 5.1-10 9.2-14.1 4.2-4.1 10.4-7.9 18.2-7.9s14.1 3.8 18.2 7.9c4.1 4 7 9.1 9.2 14.1 4.3 10 6.6 22.8 6.6 36s-2.3 26-6.6 36c-2.1 5-5.1 10-9.2 14.1-4.2 4.1-10.4 7.9-18.2 7.9s-14.1-3.8-18.2-7.9c-4.1-4-7-9.1-9.2-14.1-4.3-10-6.6-22.8-6.6-36zm57.3 187.9l72.7 72.7 0-161.1c-4.4 12.5-9.6 24.1-15.5 34.6-14.7 26-34.3 45.7-57.2 53.9z", "M13.7-29.8c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l560 560c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-30.8-30.8c.8-3.7 1.2-7.5 1.2-11.4l0-264c0-51.9-11.9-99.3-31.5-134-19.5-34.5-47.6-58-80.5-58L144 32c-18.1 0-34.8 7.1-49.3 19.3l-81-81zM106 62.6C118 53 130.9 48 144 48l242.8 0c-13.6 10.2-25.5 24.7-35.3 42-19.6 34.7-31.5 82.1-31.5 134 0 20.1 1.8 39.4 5.1 57.7L106 62.6zM346.3 302.9c-6.6-23.7-10.3-50.5-10.3-78.9 0-49.7 11.4-94.3 29.4-126.2 18.2-32.1 42-49.8 66.6-49.8s48.4 17.7 66.6 49.8c18 31.9 29.4 76.5 29.4 126.2s-11.4 94.3-29.4 126.2c-15.6 27.6-35.4 44.5-56.2 48.8l-96-96zm109 109c22.9-8.1 42.5-27.9 57.2-53.9 5.9-10.4 11.1-22 15.5-34.6l0 161.1-72.7-72.7zM192 416l176.8 0-16-16-208.8 0c-24.6 0-48.4-17.7-66.6-49.8-18-31.9-29.4-76.5-29.4-126.2 0-41 7.7-78.5 20.6-108.2L56.5 103.7c-15.4 33-24.5 75-24.5 120.3 0 51.9 11.9 99.3 31.5 134 19.5 34.5 47.6 58 80.5 58l32 0 0 72c0 30.9 25.1 56 56 56l256 0c2.8 0 5.5-.2 8.2-.6L480.8 528 232 528c-22.1 0-40-17.9-40-40l0-72zM432 282c7.9 0 14.1-3.8 18.2-7.9 4.1-4 7-9.1 9.2-14.1 4.3-10 6.6-22.8 6.6-36s-2.3-26-6.6-36c-2.1-5-5.1-10-9.2-14.1-4.2-4.1-10.4-7.9-18.2-7.9s-14.1 3.8-18.2 7.9c-4.1 4-7 9.1-9.2 14.1-4.3 10-6.6 22.8-6.6 36s2.3 26 6.6 36c2.1 5 5.1 10 9.2 14.1 4.2 4.1 10.4 7.9 18.2 7.9zm18-58c0 23.2-8.1 42-18 42s-18-18.8-18-42 8.1-42 18-42 18 18.8 18 42z"]],
    "hand-point-up": [384, 512, [9757], "f0a6", ["M16 328l0 32c0 75.1 60.9 136 136 136l80 0c75.1 0 136-60.9 136-136l0-20.2c-8.5 7.6-19.7 12.2-32 12.2-18.5 0-34.6-10.5-42.6-25.9-8.8 10.9-22.3 17.9-37.4 17.9s-28.6-7-37.4-17.9c-8 15.4-24.1 25.9-42.6 25.9l-72 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l72 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L72 272c-30.9 0-56 25.1-56 56zM64 48l0 208.4c2.6-.3 5.3-.4 8-.4l56 0 0-208c0-17.7-14.3-32-32-32S64 30.3 64 48zm80 152l0 56 32 0c12.3 0 23.5 4.6 32 12.2l0-68.2c0-17.7-14.3-32-32-32s-32 14.3-32 32zm80 32l0 64c0 17.7 14.3 32 32 32s32-14.3 32-32l0-64c0-17.7-14.3-32-32-32-17.7 0-32 14.3-32 32zm80 16l0 56c0 17.7 14.3 32 32 32s32-14.3 32-32l0-56c0-17.7-14.3-32-32-32s-32 14.3-32 32z", "M64 48c0-17.7 14.3-32 32-32s32 14.3 32 32l0 208-56 0c-2.7 0-5.4 .1-8 .4L64 48zm64 224l48 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-72 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l72 0c18.5 0 34.6-10.5 42.6-25.9 8.8 10.9 22.3 17.9 37.4 17.9s28.6-7 37.4-17.9c8 15.4 24.1 25.9 42.6 25.9 12.3 0 23.5-4.6 32-12.2l0 20.2c0 75.1-60.9 136-136 136l-80 0C76.9 496 16 435.1 16 360l0-32c0-30.9 25.1-56 56-56l56 0zm16-16l0-56c0-17.7 14.3-32 32-32s32 14.3 32 32l0 68.2c-8.5-7.6-19.7-12.2-32-12.2l-32 0zm0-91.8L144 48c0-26.5-21.5-48-48-48S48 21.5 48 48l0 212.1C20 270 0 296.6 0 328l0 32c0 83.9 68.1 152 152 152l80 0c83.9 0 152-68.1 152-152l0-112c0-26.5-21.5-48-48-48-13.8 0-26.3 5.8-35 15.2-6.8-18.2-24.4-31.2-45-31.2-12.4 0-23.6 4.7-32.1 12.3-1.9-24.8-22.6-44.3-47.9-44.3-12.3 0-23.5 4.6-32 12.2zM224 272l0-40c0-17.7 14.3-32 32-32 17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-24zm144 8l0 24c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-56c0-17.7 14.3-32 32-32s32 14.3 32 32l0 32z"]],
    "pen-slash": [576, 512, [], "e213", ["M236 192.6c28.2-28.2 56.4-56.4 84.6-84.6 38.4 38.4 76.9 76.9 115.3 115.3L351.4 308c-38.4-38.4-76.9-76.9-115.3-115.3z", "M13.7-29.8c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l560 560c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-211-211 160.2-160.2C536.4 145.6 544 127.2 544 108s-7.6-37.6-21.2-51.1L487.1 21.2C473.6 7.6 455.2 0 436 0s-37.6 7.6-51.1 21.2L224.7 181.3 13.7-29.8zM236 192.6L320.7 108 436 223.3 351.4 308 236 192.6zM102.2 326.4l88.5-88.5-11.3-11.3-88.5 88.5c-10.7 10.7-18.5 24.1-22.6 38.7L32.9 481.6c-2.3 8.3 0 17.3 6.2 23.4s15.1 8.5 23.4 6.2l127.8-35.5c14.6-4.1 27.9-11.8 38.7-22.6l88.5-88.5-11.3-11.3-88.5 88.5c-8.8 8.8-19.7 15.1-31.6 18.5L58.1 495.7c-2.8 .8-5.8 0-7.8-2.1s-2.8-5-2.1-7.8L83.8 358.1c3.3-12 9.7-22.9 18.5-31.6zm294-294C406.8 21.9 421.1 16 436 16s29.2 5.9 39.8 16.5l35.7 35.7C522.1 78.8 528 93.1 528 108s-5.9 29.2-16.5 39.8L447.3 212 332 96.7 396.2 32.5z"]],
    "comment-plus": [512, 512, [], "f4b2", ["M16 240c0 51.7 18.8 99.4 50.5 137.4 4.1 4.9 4.9 11.7 2 17.4l-49.4 98.7 124.8-49.9c3.9-1.6 8.3-1.5 12.2 .1 30.4 13 64.2 20.2 99.9 20.2 133.5 0 240-101.2 240-224S389.5 16 256 16 16 117.2 16 240zm152 0c0-4.4 3.6-8 8-8l72 0 0-72c0-4.4 3.6-8 8-8s8 3.6 8 8l0 72 72 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-72 0 0 72c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-72-72 0c-4.4 0-8-3.6-8-8z", "M68.5 394.8c2.8-5.7 2-12.5-2-17.4-31.7-38-50.5-85.7-50.5-137.4 0-122.8 106.5-224 240-224S496 117.2 496 240 389.5 464 256 464c-35.7 0-69.5-7.3-99.9-20.2-3.9-1.7-8.3-1.7-12.2-.1L19.1 493.5 68.5 394.8zM0 240c0 55.7 20.2 106.9 54.2 147.7L1.4 493.3C-4 504 7.6 515.4 18.4 511l131.5-52.6c32.3 13.8 68.3 21.5 106.2 21.5 141.4 0 256-107.5 256-240S397.4 0 256 0 0 107.5 0 240zm256-88c-4.4 0-8 3.6-8 8l0 72-72 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l72 0 0 72c0 4.4 3.6 8 8 8s8-3.6 8-8l0-72 72 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-72 0 0-72c0-4.4-3.6-8-8-8z"]],
    "bezier-curve": [640, 512, [], "f55b", ["M16 128a40 40 0 1 0 80 0 40 40 0 1 0 -80 0zM48 360l0 48c0 13.3 10.7 24 24 24l48 0c13.3 0 24-10.7 24-24l0-48c0-13.3-10.7-24-24-24l-48 0c-13.3 0-24 10.7-24 24zM272 104l0 48c0 13.3 10.7 24 24 24l48 0c13.3 0 24-10.7 24-24l0-48c0-13.3-10.7-24-24-24l-48 0c-13.3 0-24 10.7-24 24zM496 360l0 48c0 13.3 10.7 24 24 24l48 0c13.3 0 24-10.7 24-24l0-48c0-13.3-10.7-24-24-24l-48 0c-13.3 0-24 10.7-24 24zm48-232a40 40 0 1 0 80 0 40 40 0 1 0 -80 0z", "M344 80c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-48c0-13.3 10.7-24 24-24l48 0zm80.1 56L528 136c.2 0 .4 0 .6 0 3.9 27.1 27.2 48 55.4 48 30.9 0 56-25.1 56-56s-25.1-56-56-56c-28.2 0-51.6 20.9-55.4 48-.2 0-.4 0-.6 0l-144 0 0-16c0-22.1-17.9-40-40-40l-48 0c-22.1 0-40 17.9-40 40l0 16-144 0c-.2 0-.4 0-.6 0-3.9-27.1-27.2-48-55.4-48-30.9 0-56 25.1-56 56s25.1 56 56 56c28.2 0 51.6-20.9 55.4-48 .2 0 .4 0 .6 0l103.9 0C143.1 166.4 91.3 237 88.2 320L72 320c-22.1 0-40 17.9-40 40l0 48c0 22.1 17.9 40 40 40l48 0c22.1 0 40-17.9 40-40l0-48c0-22.1-17.9-40-40-40l-15.8 0c3.6-88.7 67.5-162 151.8-179.8l0 11.8c0 22.1 17.9 40 40 40l48 0c22.1 0 40-17.9 40-40l0-11.8C468.3 158 532.2 231.3 535.8 320L520 320c-22.1 0-40 17.9-40 40l0 48c0 22.1 17.9 40 40 40l48 0c22.1 0 40-17.9 40-40l0-48c0-22.1-17.9-40-40-40l-16.2 0c-3.1-83-54.9-153.6-127.7-184zM16 128a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zm528 0a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zM72 336l48 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-48c0-13.3 10.7-24 24-24zm424 24c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-48z"]],
    "clipboard-list-check": [384, 512, [], "f737", ["M16 96l0 352c0 26.5 21.5 48 48 48l256 0c26.5 0 48-21.5 48-48l0-352c0-26.5-21.5-48-48-48l-16 0c0 17.4-9.2 32.6-23.1 41-4.3 4.3-10.3 7-16.9 7L120 96c-6.6 0-12.6-2.7-16.9-7-13.8-8.4-23.1-23.6-23.1-41L64 48C37.5 48 16 69.5 16 96zM82.6 301.9c-2.8-3.5-2.2-8.5 1.2-11.2s8.5-2.2 11.2 1.2l18.7 23.3 39.1-48.3c2.8-3.4 7.8-4 11.3-1.2s4 7.8 1.2 11.3L120 333c-1.5 1.9-3.8 3-6.2 3s-4.7-1.1-6.2-3L82.6 301.9zM128 208a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zM96 400c0-8.8 7.2-16 16-16s16 7.2 16 16-7.2 16-16 16-16-7.2-16-16zm80-192c0-4.4 3.6-8 8-8l112 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-112 0c-4.4 0-8-3.6-8-8zm0 192c0-4.4 3.6-8 8-8l112 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-112 0c-4.4 0-8-3.6-8-8zm16-96c0-4.4 3.6-8 8-8l96 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-96 0c-4.4 0-8-3.6-8-8z", "M128 80l128 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L128 16c-17.7 0-32 14.3-32 32s14.3 32 32 32zm0 16c-26.5 0-48-21.5-48-48L64 48C37.5 48 16 69.5 16 96l0 352c0 26.5 21.5 48 48 48l256 0c26.5 0 48-21.5 48-48l0-352c0-26.5-21.5-48-48-48l-16 0c0 26.5-21.5 48-48 48L128 96zM256 0c20.9 0 38.7 13.4 45.3 32L320 32c35.3 0 64 28.7 64 64l0 352c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l18.7 0C89.3 13.4 107.1 0 128 0L256 0zM184 200l112 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-112 0c-4.4 0-8-3.6-8-8s3.6-8 8-8zm0 192l112 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-112 0c-4.4 0-8-3.6-8-8s3.6-8 8-8zm-88 8c0-8.8 7.2-16 16-16s16 7.2 16 16-7.2 16-16 16-16-7.2-16-16zm16-176a16 16 0 1 1 0-32 16 16 0 1 1 0 32zm52.1 41.8c3.4 2.8 4 7.8 1.2 11.3L120 333c-1.5 1.9-3.8 3-6.2 3s-4.7-1.1-6.2-3L82.6 301.9c-2.8-3.5-2.2-8.5 1.2-11.2s8.5-2.2 11.2 1.2l18.7 23.3 39.1-48.3c2.8-3.4 7.8-4 11.3-1.2zM200 296l96 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-96 0c-4.4 0-8-3.6-8-8s3.6-8 8-8z"]],
    "lamp-desk": [512, 512, [], "e014", ["M197.7 37.7c23.4-23.4 61.3-23.4 84.7 0l40 40c1.5 1.5 3.5 2.3 5.7 2.3l135 0c5 0 9 4 9 9 0 2.4-.9 4.7-2.6 6.3L255.3 309.4c-1.7 1.7-4 2.6-6.3 2.6-5 0-9-4-9-9l0-135c0-2.1-.8-4.2-2.3-5.7l-40-40c-23.4-23.4-23.4-61.3 0-84.7z", "M293.7 26.3C264-3.3 216-3.3 186.3 26.3s-29.6 77.7 0 107.3l26.3 26.3-90.3 90.3c-2 2-2.8 4.9-2.1 7.7L181.7 496 8 496c-4.4 0-8 3.6-8 8s3.6 8 8 8l368 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-177.8 0-61.3-237.6 87.1-87.1 0 131.7c0 13.8 11.2 25 25 25 6.6 0 13-2.6 17.7-7.3L480.7 106.6c4.7-4.7 7.3-11 7.3-17.7 0-13.8-11.2-25-25-25l-131.7 0-37.7-37.7zm-96 11.3c23.4-23.4 61.3-23.4 84.7 0l40 40c1.5 1.5 3.5 2.3 5.7 2.3l135 0c5 0 9 4 9 9 0 2.4-.9 4.7-2.6 6.3L255.3 309.4c-1.7 1.7-4 2.6-6.3 2.6-5 0-9-4-9-9l0-135c0-2.1-.8-4.2-2.3-5.7l-40-40c-23.4-23.4-23.4-61.3 0-84.7z"]],
    "person-half-dress": [384, 512, [], "e548", ["M49.2 287.6l56.2-107.2c14.4-27.4 40.7-46.1 70.6-51.1l0 254.7-96.6 0c-5.6 0-9.5-5.7-7.4-10.9l63.5-162.2c1.6-4.1-.4-8.8-4.5-10.4s-8.8 .4-10.4 4.5L88.9 286 49.2 287.6zM128 400l32 0 0 112c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-112zM152 24c0-22.1 17.9-40 40-40 0 26.7 0 53.3 0 80-22.1 0-40-17.9-40-40z", "M232 24a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zm-96 0a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zM79.5 400c-16.9 0-28.5-17-22.3-32.7l63.5-162.2c1.6-4.1 6.3-6.1 10.4-4.5s6.1 6.3 4.5 10.4L72 373.1c-2.1 5.2 1.8 10.9 7.4 10.9l96.6 0 0 128c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-112-32.6 0zM91.2 173c17.1-32.7 48.9-54.8 84.8-59.9l0 16.2c-29.9 5-56.2 23.7-70.6 51.1L47.1 291.7c-2 3.9-6.9 5.4-10.8 3.4s-5.4-6.9-3.4-10.8L91.2 173zM128 512c0 8.8 7.2 16 16 16s16-7.2 16-16l0-112-32 0 0 112zm80-144l0-.3 0-27.4c9.6 5.5 16 15.9 16 27.7l0 144c0 8.8 7.2 16 16 16s16-7.2 16-16l0-294.8c0-3.5 2.3-6.6 5.6-7.6s7 .2 9 3.1L322.8 289c5 7.3 14.9 9.2 22.2 4.2s9.2-14.9 4.2-22.2l-64.1-93.8c-18-26.3-46.1-43.6-77.1-48l0-16.1c36.4 4.5 69.4 24.5 90.3 55.1l64.1 93.8c10 14.6 6.2 34.5-8.4 44.5s-34.5 6.2-44.5-8.4l-37.6-55 0 268.9c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-144z"]],
    "peanut": [512, 512, [], "e430", ["M16 362.9c0-42.7 19-83.3 51.8-110.6l5.1-4.2c19.6-16.4 43.3-27.2 68.5-31.4l19.4-3.2c27-4.5 48.1-25.6 52.6-52.6l1.1-6.5c5.5-32.9 21.1-63.3 44.7-86.8l4.6-4.6c30-30 70.7-46.9 113.1-46.9L432 16c35.3 0 64 28.7 64 64l0 55.1c0 42.4-16.9 83.1-46.9 113.1l-4.6 4.6c-23.6 23.6-53.9 39.2-86.8 44.7l-6.5 1.1c-27 4.5-48.1 25.6-52.6 52.6l-1.9 11.6c-4.9 29.6-19 56.9-40.2 78.2l-12.9 12.9c-27 27-63.6 42.2-101.8 42.2L80 496c-35.3 0-64-28.7-64-64l0-69.1zM112 416a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm64-64a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm0 64a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zM336 192a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm64-64a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm0 64a16 16 0 1 0 32 0 16 16 0 1 0 -32 0z", "M16 362.9L16 432c0 35.3 28.7 64 64 64l61.7 0c38.2 0 74.8-15.2 101.8-42.2l12.9-12.9c21.2-21.2 35.3-48.5 40.2-78.2l1.9-11.6c4.5-27 25.6-48.1 52.6-52.6l6.5-1.1c32.9-5.5 63.3-21.1 86.8-44.7l4.6-4.6c30-30 46.9-70.7 46.9-113.1L496 80c0-35.3-28.7-64-64-64l-55.1 0c-42.4 0-83.1 16.9-113.1 46.9l-4.6 4.6C235.6 91 220 121.4 214.5 154.3l-1.1 6.5c-4.5 27-25.6 48.1-52.6 52.6l-19.4 3.2c-25.2 4.2-48.9 15-68.5 31.4l-5.1 4.2C35 279.7 16 320.2 16 362.9zM0 432l0-69.1C0 315.5 21.1 270.4 57.6 240l5.1-4.2c21.8-18.2 48.1-30.2 76.1-34.9l19.4-3.2c20.2-3.4 36.1-19.2 39.5-39.5l1.1-6.5c6-36.2 23.2-69.6 49.2-95.5l4.6-4.6C285.5 18.5 330.2 0 376.9 0L432 0c44.2 0 80 35.8 80 80l0 55.1c0 46.7-18.5 91.4-51.5 124.5l-4.6 4.6c-25.9 25.9-59.3 43.1-95.5 49.2l-6.5 1.1c-20.2 3.4-36.1 19.2-39.5 39.5l-1.9 11.6c-5.5 32.9-21.1 63.3-44.7 86.8l-12.9 12.9c-30 30-70.7 46.9-113.1 46.9L80 512c-44.2 0-80-35.8-80-80zm112-16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM352 176a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM176 416a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM416 176a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM176 352a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM416 112a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"]],
    "message-plus": [512, 512, ["comment-alt-plus"], "f4a8", ["M16 128l0 224c0 44.2 35.8 80 80 80l32 0c8.8 0 16 7.2 16 16l0 75.9c0 2.3 2 4 4.1 4.1 .8 0 1.7-.2 2.4-.7 3.3-2.3 6.3-4.5 9.1-6.4l.4-.3c6.7-4.7 30.4-21.5 117.2-82.7 5.4-3.8 11.8-5.9 18.5-5.9L416 432c44.2 0 80-35.8 80-80l0-224c0-44.2-35.8-80-80-80L96 48c-44.2 0-80 35.8-80 80zM168 240c0-4.4 3.6-8 8-8l72 0 0-72c0-4.4 3.6-8 8-8s8 3.6 8 8l0 72 72 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-72 0 0 72c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-72-72 0c-4.4 0-8-3.6-8-8z", "M144 448l0 75.9c0 2.3 2 4 4.1 4.1 .8 0 1.7-.2 2.4-.7 3.3-2.3 6.3-4.5 9.1-6.4l.4-.3c6.7-4.7 30.4-21.5 117.2-82.7 5.4-3.8 11.8-5.9 18.5-5.9L416 432c44.2 0 80-35.8 80-80l0-224c0-44.2-35.8-80-80-80L96 48c-44.2 0-80 35.8-80 80l0 224c0 44.2 35.8 80 80 80l32 0c8.8 0 16 7.2 16 16zM0 128C0 75 43 32 96 32l320 0c53 0 96 43 96 96l0 224c0 53-43 96-96 96l-120.4 0c-3.3 0-6.5 1-9.2 2.9L159.8 540.3c-3.4 2.4-7.5 3.7-11.6 3.7-11.1 0-20.1-9-20.1-20.1l0-75.9-32 0c-53 0-96-43-96-96L0 128zm256 24c4.4 0 8 3.6 8 8l0 72 72 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-72 0 0 72c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-72-72 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l72 0 0-72c0-4.4 3.6-8 8-8z"]],
    "bracket-curly": [256, 512, ["bracket-curly-left"], "7b", ["", "M64 88c0-30.9 25.1-56 56-56l80 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-80 0C97.9 48 80 65.9 80 88l0 77.5c0 19.1-7.6 37.4-21.1 50.9L19.3 256 58.9 295.6C72.4 309.1 80 327.4 80 346.5L80 424c0 22.1 17.9 40 40 40l80 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-80 0c-30.9 0-56-25.1-56-56l0-77.5c0-14.9-5.9-29.1-16.4-39.6L2.3 261.7c-3.1-3.1-3.1-8.2 0-11.3l45.3-45.3C58.1 194.6 64 180.3 64 165.5L64 88z"]],
    "square-poll-horizontal": [448, 512, ["poll-h"], "f682", ["M16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96zm80 48c0-17.7 14.3-32 32-32l96 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-96 0c-17.7 0-32-14.3-32-32zm0 112c0-17.7 14.3-32 32-32l192 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-192 0c-17.7 0-32-14.3-32-32zm0 112c0-17.7 14.3-32 32-32l32 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32z", "M64 48C37.5 48 16 69.5 16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm112 48c0 8.8 7.2 16 16 16l96 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-96 0c-8.8 0-16 7.2-16 16zm0 112c0 8.8 7.2 16 16 16l192 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-192 0c-8.8 0-16 7.2-16 16zm0 112c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm16-256l96 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-96 0c-17.7 0-32-14.3-32-32s14.3-32 32-32zm0 112l192 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-192 0c-17.7 0-32-14.3-32-32s14.3-32 32-32zm0 112l32 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32s14.3-32 32-32z"]],
    "nfc-signal": [576, 512, [], "e1fb", ["M48 96c0-26.5 21.5-48 48-48l320 0c26.5 0 48 21.5 48 48l0 157.7c-22.8 7.4-44.2 17.7-64 30.5L400 136c0-13.3-10.7-24-24-24l-104 0c-13.3 0-24 10.7-24 24l0 72.7c-22.7 3.8-40 23.6-40 47.3 0 26.5 21.5 48 48 48s48-21.5 48-48c0-23.8-17.3-43.5-40-47.3l0-72.7c0-4.4 3.6-8 8-8l104 0c4.4 0 8 3.6 8 8l0 159.3c-31.7 23.7-58.1 53.9-77.4 88.7L136 384c-4.4 0-8-3.6-8-8l0-240c0-4.4 3.6-8 8-8l48 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-48 0c-13.3 0-24 10.7-24 24l0 240c0 13.3 10.7 24 24 24l162.5 0c-9.5 20.1-16.6 41.6-21.1 64L96 464c-26.5 0-48-21.5-48-48L48 96zM560 512a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M416 48L96 48C69.5 48 48 69.5 48 96l0 320c0 26.5 21.5 48 48 48l181.4 0c-1.1 5.3-2 10.6-2.7 16L96 480c-35.3 0-64-28.7-64-64L32 96c0-35.3 28.7-64 64-64l320 0c35.3 0 64 28.7 64 64l0 153c-5.4 1.4-10.7 3-16 4.7L464 96c0-26.5-21.5-48-48-48zm-16 88l0 148.2c-5.5 3.5-10.8 7.2-16 11.1L384 136c0-4.4-3.6-8-8-8l-104 0c-4.4 0-8 3.6-8 8l0 72.7c22.7 3.8 40 23.6 40 47.3 0 26.5-21.5 48-48 48s-48-21.5-48-48c0-23.8 17.3-43.5 40-47.3l0-72.7c0-13.3 10.7-24 24-24l104 0c13.3 0 24 10.7 24 24zM298.5 400L136 400c-13.3 0-24-10.7-24-24l0-240c0-13.3 10.7-24 24-24l48 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-48 0c-4.4 0-8 3.6-8 8l0 240c0 4.4 3.6 8 8 8l170.6 0c-2.9 5.2-5.6 10.6-8.2 16zM256 224a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm312 64c4.4 0 8 3.6 8 8s-3.6 8-8 8c-128.1 0-232 103.9-232 232 0 4.4-3.6 8-8 8s-8-3.6-8-8c0-137 111-248 248-248zM528 512a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm48 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm0-120c0 4.4-3.6 8-8 8-75.1 0-136 60.9-136 136 0 4.4-3.6 8-8 8s-8-3.6-8-8c0-83.9 68.1-152 152-152 4.4 0 8 3.6 8 8z"]],
    "box-isometric": [512, 512, [], "e797", ["M32.5 164.7l0 181.6c0 20.4 11.1 39.2 29 49.1l168 92.7c6 3.3 12.5 5.5 19.1 6.4l0-233.6-213-114.1c-1.9 5.7-3 11.8-3 18zm10.2-32.3l213.8 114.5 106-56.8-218.5-122.9-83.8 49.1c-7 4.1-12.9 9.6-17.5 16.1zM159.8 57.9l219.3 123.4 91.2-48.8c-4.5-6.4-10.5-12-17.5-16.1l-168-98.5c-17.5-10.3-39.2-10.3-56.7 0l-68.3 40zM264.4 260.8l0 233.6c6.6-1 13.1-3.1 19.1-6.4l168-92.7c17.9-9.9 29-28.6 29-49.1l0-181.6c0-6.2-1-12.3-3-18L264.4 260.8z", "M229.4 488c6 3.3 12.5 5.5 19.1 6.4l0-233.6-213-114.1c-1.9 5.7-3 11.8-3 18l0 181.6c0 20.4 11.1 39.2 29 49.1l168 92.7zm54.1 0l168-92.7c17.9-9.9 29-28.6 29-49.1l0-181.6c0-6.2-1-12.3-3-18l-213.1 114.2 0 233.6c6.6-1 13.1-3.1 19.1-6.4zm95.6-306.7l91.2-48.8c-4.5-6.4-10.5-12-17.5-16.1l-168-98.5c-17.5-10.3-39.2-10.3-56.7 0l-68.3 40 219.3 123.4zm-16.7 8.9L143.9 67.2 60.1 116.3c-7 4.1-12.9 9.6-17.5 16.1l213.8 114.5 106-56.8zM291.2 501.9c-21.6 11.9-47.9 11.9-69.5 0l-168-92.7c-23-12.7-37.2-36.8-37.2-63l0-181.6c0-25.5 13.5-49.2 35.6-62.1l168-98.5c22.5-13.2 50.3-13.2 72.8 0l168 98.5c22 12.9 35.6 36.5 35.6 62.1l0 181.6c0 26.2-14.3 50.4-37.2 63l-168 92.7z"]],
    "school-circle-xmark": [640, 512, [], "e56d", ["M16 192c0-26.5 21.5-48 48-48l72 0c1.9 0 3.7-.7 5.2-1.9L282.8 22.8c3-2.5 7.3-2.5 10.3 0L434.8 142.1c1.4 1.2 3.3 1.9 5.2 1.9l72 0c26.5 0 48 21.5 48 48l0 26.9c-20-7.1-41.6-10.9-64-10.9-89.7 0-165 61.5-186.1 144.6-1.9-.4-3.9-.5-5.9-.5l-7.3 0c-.2 0-.5 0-.7 0l-16 0c-.2 0-.5 0-.7 0l-7.3 0c-17.7 0-32 14.3-32 32l0 112-176 0c-26.5 0-48-21.5-48-48l0-256zm64 40l0 24c0 13.3 10.7 24 24 24l24 0c13.3 0 24-10.7 24-24l0-24c0-13.3-10.7-24-24-24l-24 0c-13.3 0-24 10.7-24 24zm0 128l0 24c0 13.3 10.7 24 24 24l24 0c13.3 0 24-10.7 24-24l0-24c0-13.3-10.7-24-24-24l-24 0c-13.3 0-24 10.7-24 24zM224 192a64 64 0 1 0 128 0 64 64 0 1 0 -128 0z", "M282.8 22.8c3-2.5 7.3-2.5 10.3 0L434.8 142.1c1.4 1.2 3.3 1.9 5.2 1.9l72 0c26.5 0 48 21.5 48 48l0 26.9c5.4 1.9 10.8 4.1 16 6.5l0-33.4c0-35.3-28.7-64-64-64l-69.1 0-139.5-117.4c-8.9-7.5-22-7.5-30.9 0L133.1 128 64 128c-35.3 0-64 28.7-64 64L0 448c0 35.3 28.7 64 64 64l276 0c-3.7-5.1-7.2-10.5-10.4-16l-9.7 0 0 0-64 0 0-112c0-8.8 7.2-16 16-16l32 0c.9 0 1.8 .1 2.6 .2 .9-5.3 2-10.5 3.3-15.7-1.9-.4-3.9-.5-5.9-.5l-32 0c-17.7 0-32 14.3-32 32l0 112-176 0c-26.5 0-48-21.5-48-48l0-256c0-26.5 21.5-48 48-48l72 0c1.9 0 3.7-.7 5.2-1.9L282.8 22.8zM240 192a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm112 0a64 64 0 1 0 -128 0 64 64 0 1 0 128 0zM104 208c-13.3 0-24 10.7-24 24l0 24c0 13.3 10.7 24 24 24l24 0c13.3 0 24-10.7 24-24l0-24c0-13.3-10.7-24-24-24l-24 0zm-8 24c0-4.4 3.6-8 8-8l24 0c4.4 0 8 3.6 8 8l0 24c0 4.4-3.6 8-8 8l-24 0c-4.4 0-8-3.6-8-8l0-24zM80 360l0 24c0 13.3 10.7 24 24 24l24 0c13.3 0 24-10.7 24-24l0-24c0-13.3-10.7-24-24-24l-24 0c-13.3 0-24 10.7-24 24zm24-8l24 0c4.4 0 8 3.6 8 8l0 24c0 4.4-3.6 8-8 8l-24 0c-4.4 0-8-3.6-8-8l0-24c0-4.4 3.6-8 8-8zm264 48a128 128 0 1 1 256 0 128 128 0 1 1 -256 0zm272 0a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-90.3-42.3c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0l-42.3 42.3-42.3-42.3c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l42.3 42.3-42.3 42.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l42.3-42.3 42.3 42.3c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-42.3-42.3 42.3-42.3z"]],
    "person-seat-window": [448, 512, [], "e788", ["M112 216c0-22.1 17.9-40 40-40s40 17.9 40 40l0 112c0 4.4 3.6 8 8 8l40 0c35.3 0 64 28.7 64 64l0 56c0 4.4 3.6 8 8 8l24 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16l0-80c0-17.7-14.3-32-32-32l-80 0c-26.5 0-48-21.5-48-48l0-104zM200 72a40 40 0 1 1 -80 0 40 40 0 1 1 80 0zM304 96c0-26.5 21.5-48 48-48l32 0c26.5 0 48 21.5 48 48l0 96c0 26.5-21.5 48-48 48l-32 0c-26.5 0-48-21.5-48-48l0-96z", "M200 72a40 40 0 1 1 -80 0 40 40 0 1 1 80 0zM160 16a56 56 0 1 0 0 112 56 56 0 1 0 0-112zm-8 144c-30.9 0-56 25.1-56 56l0 104c0 35.3 28.7 64 64 64l80 0c8.8 0 16 7.2 16 16l0 80c0 17.7 14.3 32 32 32l48 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-16 0 0-48c0-44.2-35.8-80-80-80l-32 0 0-104c0-30.9-25.1-56-56-56zm-40 56c0-22.1 17.9-40 40-40s40 17.9 40 40l0 112c0 4.4 3.6 8 8 8l40 0c35.3 0 64 28.7 64 64l0 56c0 4.4 3.6 8 8 8l24 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16l0-80c0-17.7-14.3-32-32-32l-80 0c-26.5 0-48-21.5-48-48l0-104zM40 160c-4.4 0-8 3.6-8 8l0 176c0 57.4 46.6 104 104 104l80 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-80 0c-48.6 0-88-39.4-88-88l0-176c0-4.4-3.6-8-8-8zM352 48l32 0c26.5 0 48 21.5 48 48l0 96c0 26.5-21.5 48-48 48l-32 0c-26.5 0-48-21.5-48-48l0-96c0-26.5 21.5-48 48-48zM288 96l0 96c0 35.3 28.7 64 64 64l32 0c35.3 0 64-28.7 64-64l0-96c0-35.3-28.7-64-64-64l-32 0c-35.3 0-64 28.7-64 64z"]],
    "grapes": [576, 512, [], "e306", ["M48.4 456a40 40 0 1 0 80 0 40 40 0 1 0 -80 0zm32-144a40 40 0 1 0 80 0 40 40 0 1 0 -80 0zm24-136a40 40 0 1 0 80 0 40 40 0 1 0 -80 0zm88 248a40 40 0 1 0 80 0 40 40 0 1 0 -80 0zm24-136a40 40 0 1 0 80 0 40 40 0 1 0 -80 0zm24-136a40 40 0 1 0 80 0 40 40 0 1 0 -80 0zm88 248a40 40 0 1 0 80 0 40 40 0 1 0 -80 0zm24-136a40 40 0 1 0 80 0 40 40 0 1 0 -80 0zM382.6 13.1c-28.1 28.1-28.1 73.7 0 101.8l17.8 17.8 17.8-17.8c28.1-28.1 28.1-73.7 0-101.8L406 1c-3.1-3.1-8.2-3.1-11.3 0L382.6 13.1zM411.7 144l17.8 17.8c28.1 28.1 73.7 28.1 101.8 0l12.1-12.1c3.1-3.1 3.1-8.2 0-11.3l-12.1-12.1c-28.1-28.1-73.7-28.1-101.8 0-5.9 5.9-11.9 11.9-17.8 17.8z", "M406 1l12.1 12.1c28.1 28.1 28.1 73.7 0 101.8l-17.8 17.8-17.8-17.8c-28.1-28.1-28.1-73.7 0-101.8L394.7 1c3.1-3.1 8.2-3.1 11.3 0zm23.5 125.2c28.1-28.1 73.7-28.1 101.8 0l12.1 12.1c3.1 3.1 3.1 8.2 0 11.3l-12.1 12.1c-28.1 28.1-73.7 28.1-101.8 0l-17.8-17.8 17.8-17.8c0 0 0 0 0 0zm20.3-31.6c11.6-31.2 4.8-67.7-20.3-92.8L417.3-10.3c-9.4-9.4-24.6-9.4-33.9 0L371.3 1.8c-34.4 34.4-34.4 90.1 0 124.5 15.6 15.6 31.2 31.2 46.9 46.9 34.4 34.4 90.1 34.4 124.4 0L554.7 161c9.4-9.4 9.4-24.6 0-33.9l-12.1-12.1C517.5 89.8 481 83 449.8 94.6zM280.4 112a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm-136 24a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm-24 136a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm-32 144a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm144-32a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm136-24a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm-112-112a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm136-24a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm-56-72a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zm-192 80a56 56 0 1 0 0-112 56 56 0 1 0 0 112zm32 80a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zm-32 144a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zm144-32a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zm80 32a56 56 0 1 0 0-112 56 56 0 1 0 0 112zm-56-168a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zm80 32a56 56 0 1 0 0-112 56 56 0 1 0 0 112z"]],
    "hand-lizard": [512, 512, [], "f258", ["M16 112c0-17.7 14.3-32 32-32l245.6 0c28.9 0 56 14.2 72.4 38L480.4 283.9c10.1 14.7 15.6 32.1 15.6 50L496 440c0 4.4 3.6 8 8 8l-144 0c4.4 0 8-3.6 8-8l0-23.9c0-7.7-3.7-14.9-9.9-19.4l-77.2-56.2c-4.1-3-9-4.6-14.1-4.6L112 336c-17.7 0-32-14.3-32-32s14.3-32 32-32l128 0c35.3 0 64-28.7 64-64s-28.7-64-64-64L48 144c-17.7 0-32-14.3-32-32z", "M0 112C0 85.5 21.5 64 48 64l245.6 0c34.2 0 66.2 16.8 85.6 45L493.6 274.8c12 17.4 18.4 38 18.4 59L512 440c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-106.1c0-17.8-5.4-35.3-15.6-50L366 118c-16.4-23.8-43.5-38-72.4-38L48 80c-17.7 0-32 14.3-32 32s14.3 32 32 32l192 0c35.3 0 64 28.7 64 64s-28.7 64-64 64l-128 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l154.8 0c5.1 0 10 1.6 14.1 4.6l77.2 56.2c6.2 4.5 9.9 11.7 9.9 19.4l0 23.9c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-23.9c0-2.6-1.2-5-3.3-6.5l-77.2-56.1c-1.4-1-3-1.5-4.7-1.5L112 352c-26.5 0-48-21.5-48-48s21.5-48 48-48l128 0c26.5 0 48-21.5 48-48s-21.5-48-48-48L48 160c-26.5 0-48-21.5-48-48z"]],
    "camera-slash": [576, 512, [], "e0d9", ["M155.4 112l7.3 0c2.8 0 5.5-1.5 6.9-4l25.8-44.2C201.1 54 211.6 48 223 48l130 0c11.4 0 21.9 6 27.6 15.9L406.4 108c1.4 2.5 4.1 4 6.9 4l66.7 0c26.5 0 48 21.5 48 48l0 256c0 18.6-10.5 34.7-25.9 42.6L385.9 342.5c9-16.1 14.1-34.7 14.1-54.5 0-61.9-50.1-112-112-112-19.8 0-38.4 5.1-54.5 14.1L155.4 112z", "M13.7-29.8c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l560 560c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-59.9-59.9C531.9 459.1 544 438.9 544 416l0-256c0-35.3-28.7-64-64-64l-62.1 0-23.4-40.2C385.9 41.1 370.1 32 353 32L223 32c-17.1 0-32.9 9.1-41.5 23.8L158.1 96 139.4 96 13.7-29.8zM155.4 112l7.3 0c2.8 0 5.5-1.5 6.9-4l25.8-44.2C201.1 54 211.6 48 223 48l130 0c11.4 0 21.9 6 27.6 15.9L406.4 108c1.4 2.5 4.1 4 6.9 4l66.7 0c26.5 0 48 21.5 48 48l0 256c0 18.6-10.5 34.7-25.9 42.6L385.9 342.5c9-16.1 14.1-34.7 14.1-54.5 0-61.9-50.1-112-112-112-19.8 0-38.4 5.1-54.5 14.1L155.4 112zM374 330.6L245.4 202c12.8-6.4 27.3-10 42.6-10 53 0 96 43 96 96 0 15.3-3.6 29.8-10 42.6zm-34 56.6l-11.9-11.9c-12.2 5.6-25.8 8.7-40.1 8.7-53 0-96-43-96-96 0-14.3 3.1-27.9 8.7-40.1L188.8 236c-8.2 15.5-12.8 33.2-12.8 52 0 61.9 50.1 112 112 112 18.8 0 36.5-4.6 52-12.8zM48 160c0-17.6 9.4-32.9 23.5-41.3L59.9 107.1C43.1 118.7 32 138 32 160l0 256c0 35.3 28.7 64 64 64l336.8 0-16-16-320.8 0c-26.5 0-48-21.5-48-48l0-256z"]],
    "chalkboard": [576, 512, ["blackboard"], "f51b", ["M48 112l0 320 240 0 0-40c0-22.1 17.9-40 40-40l80 0c22.1 0 40 17.9 40 40l0 40 80 0 0-320c0-17.7-14.3-32-32-32L80 80c-17.7 0-32 14.3-32 32z", "M80 80l416 0c17.7 0 32 14.3 32 32l0 320-80 0 0-40c0-22.1-17.9-40-40-40l-80 0c-22.1 0-40 17.9-40 40l0 40-240 0 0-320c0-17.7 14.3-32 32-32zM432 432l-128 0 0-40c0-13.3 10.7-24 24-24l80 0c13.3 0 24 10.7 24 24l0 40zM32 112l0 320-24 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l560 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-24 0 0-320c0-26.5-21.5-48-48-48L80 64c-26.5 0-48 21.5-48 48z"]],
    "memo-pad": [384, 512, [], "e1da", ["M16 128l0 320c0 26.5 21.5 48 48 48l256 0c26.5 0 48-21.5 48-48l0-320-352 0zm80 88c0-4.4 3.6-8 8-8l176 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-176 0c-4.4 0-8-3.6-8-8zm0 96c0-4.4 3.6-8 8-8l176 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-176 0c-4.4 0-8-3.6-8-8zm0 96c0-4.4 3.6-8 8-8l112 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-112 0c-4.4 0-8-3.6-8-8z", "M320 16c26.5 0 48 21.5 48 48l0 48-352 0 0-48c0-26.5 21.5-48 48-48l256 0zm48 112l0 320c0 26.5-21.5 48-48 48L64 496c-26.5 0-48-21.5-48-48l0-320 352 0zM64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-384c0-35.3-28.7-64-64-64L64 0zM96 216c0 4.4 3.6 8 8 8l176 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-176 0c-4.4 0-8 3.6-8 8zm0 96c0 4.4 3.6 8 8 8l176 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-176 0c-4.4 0-8 3.6-8 8zm0 96c0 4.4 3.6 8 8 8l112 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-112 0c-4.4 0-8 3.6-8 8z"]],
    "bluetooth": [320, 512, [], "f293", ["M168 25.2L168 239.5 299.3 135.8 168 25.2zm0 251.7l0 210.6 131.2-103.6-131.2-107z", "M156.6 .7c2.8-1.3 6.1-.9 8.5 1.1l152 128c1.8 1.5 2.9 3.8 2.8 6.2s-1.2 4.7-3 6.2L170.3 258.1 317.1 377.8c1.9 1.5 3 3.8 2.9 6.3s-1.1 4.7-3 6.2l-152 120c-2.4 1.9-5.7 2.3-8.4 .9s-4.5-4.1-4.5-7.2l0-231.5-139 109.8C9.5 385 4.5 384.4 1.7 381S-.4 372.5 3 369.7L144.7 257.9 2.9 142.2c-3.4-2.8-3.9-7.8-1.1-11.3s7.8-3.9 11.3-1.1L152 243.1 152 8c0-3.1 1.8-5.9 4.6-7.3zM168 276.9l0 210.6 131.2-103.6-131.2-107zm0-37.4L299.3 135.8 168 25.2 168 239.5z"]],
    "objects-align-center-horizontal": [448, 512, [], "e3bc", ["M16 112l0 64c0 17.7 14.3 32 32 32l352 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32L48 80c-17.7 0-32 14.3-32 32zM80 336l0 64c0 17.7 14.3 32 32 32l224 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-224 0c-17.7 0-32 14.3-32 32z", "M232-24c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 88-168 0C21.5 64 0 85.5 0 112l0 64c0 26.5 21.5 48 48 48l168 0 0 64-104 0c-26.5 0-48 21.5-48 48l0 64c0 26.5 21.5 48 48 48l104 0 0 88c0 4.4 3.6 8 8 8s8-3.6 8-8l0-88 104 0c26.5 0 48-21.5 48-48l0-64c0-26.5-21.5-48-48-48l-104 0 0-64 168 0c26.5 0 48-21.5 48-48l0-64c0-26.5-21.5-48-48-48l-168 0 0-88zm-8 328l112 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-224 0c-17.7 0-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32l112 0zm0-96L48 208c-17.7 0-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32l352 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-176 0z"]],
    "distribute-spacing-vertical": [512, 512, [], "e366", ["M112 208l0 96c0 17.7 14.3 32 32 32l224 0c17.7 0 32-14.3 32-32l0-96c0-17.7-14.3-32-32-32l-224 0c-17.7 0-32 14.3-32 32z", "M512 472c0-4.4-3.6-8-8-8L8 464c-4.4 0-8 3.6-8 8s3.6 8 8 8l496 0c4.4 0 8-3.6 8-8zM144 336c-17.7 0-32-14.3-32-32l0-96c0-17.7 14.3-32 32-32l224 0c17.7 0 32 14.3 32 32l0 96c0 17.7-14.3 32-32 32l-224 0zm224 16c26.5 0 48-21.5 48-48l0-96c0-26.5-21.5-48-48-48l-224 0c-26.5 0-48 21.5-48 48l0 96c0 26.5 21.5 48 48 48l224 0zM504 48c4.4 0 8-3.6 8-8s-3.6-8-8-8L8 32c-4.4 0-8 3.6-8 8s3.6 8 8 8l496 0z"]],
    "up-right-from-square": [512, 512, ["external-link-alt"], "f35d", ["M304.7 20.9c-1.2 3-.6 6.4 1.7 8.7l176.1 176c2.3 2.3 5.7 3 8.7 1.7s4.9-4.2 4.9-7.4l0-176c0-4.4-3.6-8-8-8L312.1 16c-3.2 0-6.2 1.9-7.4 4.9z", "M306.4 29.7l176.1 176 0 0c2.3 2.3 5.7 3 8.7 1.7s4.9-4.2 4.9-7.4l0-176c0-4.4-3.6-8-8-8L312.1 16c-3.2 0-6.2 1.9-7.4 4.9s-.6 6.4 1.7 8.7l0 0zM471.2 217l-82.4-82.4-183.1 183.1c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3L377.5 123.3 295.1 41c-6.9-6.9-8.9-17.2-5.2-26.2S302.4 0 312.1 0L488.2 0c13.3 0 24 10.7 24 24l0 176c0 9.7-5.8 18.5-14.8 22.2s-19.3 1.7-26.2-5.2zM.1 176.1C.1 131.9 36 96 80.2 96l103.9 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L80.2 112c-35.4 0-64.1 28.7-64.1 64.1l0 255.7c0 35.4 28.7 64.1 64.1 64.1L336 496c35.4 0 64.1-28.7 64.1-64.1l0-103.9c0-4.4 3.6-8 8-8s8 3.6 8 8l0 103.9c0 44.3-35.9 80.1-80.1 80.1L80.2 512C36 512 .1 476.1 .1 431.9l0-255.7z"]],
    "square-turkish-lira": [448, 512, [], "e71f", ["M16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96zM120.4 242.5c-1.4-4.2 .9-8.7 5.1-10.1l34.5-11.5 0-84.9c0-4.4 3.6-8 8-8s8 3.6 8 8l0 79.6 93.5-31.2c4.2-1.4 8.7 .9 10.1 5.1s-.9 8.7-5.1 10.1l-98.5 32.8 0 47.1 93.5-31.2c4.2-1.4 8.7 .9 10.1 5.1s-.9 8.7-5.1 10.1l-98.5 32.8 0 71.6 56 0c44.2 0 80-35.8 80-80 0-4.4 3.6-8 8-8s8 3.6 8 8c0 53-43 96-96 96l-64 0c-4.4 0-8-3.6-8-8l0-74.2-29.5 9.8c-4.2 1.4-8.7-.9-10.1-5.1s.9-8.7 5.1-10.1l34.5-11.5 0-47.1-29.5 9.8c-4.2 1.4-8.7-.9-10.1-5.1z", "M64 48C37.5 48 16 69.5 16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm168 32c4.4 0 8 3.6 8 8l0 79.6 93.5-31.2c4.2-1.4 8.7 .9 10.1 5.1s-.9 8.7-5.1 10.1l-98.5 32.8 0 47.1 93.5-31.2c4.2-1.4 8.7 .9 10.1 5.1s-.9 8.7-5.1 10.1l-98.5 32.8 0 71.6 56 0c44.2 0 80-35.8 80-80 0-4.4 3.6-8 8-8s8 3.6 8 8c0 53-43 96-96 96l-64 0c-4.4 0-8-3.6-8-8l0-74.2-29.5 9.8c-4.2 1.4-8.7-.9-10.1-5.1s.9-8.7 5.1-10.1l34.5-11.5 0-47.1-29.5 9.8c-4.2 1.4-8.7-.9-10.1-5.1s.9-8.7 5.1-10.1l34.5-11.5 0-84.9c0-4.4 3.6-8 8-8z"]],
    "rotate-exclamation": [512, 512, [], "e23c", ["", "M504.1 256c4.4 .1 7.9 3.9 7.8 8.3-2 62.7-27 124.9-74.8 172.8-100 100-262.1 100-362.1 0l-59-59 0 125.9c0 4.4-3.6 8-8 8s-8-3.6-8-8L0 358.7c0-2.1 .8-4.2 2.3-5.7s3.5-2.3 5.7-2.3l128 0c4.4 0 8 3.6 8 8 0 4.4-3.6 8-8 8l-108.7 0 59 59c93.7 93.7 245.7 93.7 339.4 0 44.9-44.9 68.3-103.2 70.2-162 .2-4.4 3.8-7.9 8.2-7.7zM256 384a16 16 0 1 1 0-32 16 16 0 1 1 0 32zm2.9-255.7c6.6 1.4 11.5 7.4 11.3 14.4L264 304.3c-.2 4.3-3.7 7.7-8 7.7s-7.8-3.4-8-7.7l-6.2-161.6c-.3-8 6.1-14.7 14.2-14.7l2.9 .3zM504 0c4.4 0 8 3.6 8 8l0 145.3c0 2.1-.8 4.2-2.3 5.7s-3.5 2.3-5.7 2.3l-128 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l108.7 0-59-59c-93.7-93.7-245.7-93.7-339.4 0-44.9 44.9-68.3 103.2-70.2 162-.1 4.4-3.8 7.9-8.3 7.8S0 252.2 .1 247.7C2.1 185 27.1 122.8 75 75 174.9-25 337.1-25 437 75l59 59 0-125.9c0-4.4 3.6-8 8-8z"]],
    "right-from-line": [512, 512, ["arrow-alt-from-left"], "f347", ["M144 240l0 32c0 17.7 14.3 32 32 32l152 0c4.4 0 8 3.6 8 8l0 88c0 3.2 1.9 6.2 4.9 7.4s6.4 .6 8.7-1.7l144-144c3.1-3.1 3.1-8.2 0-11.3l-144-144c-2.3-2.3-5.7-3-8.7-1.7s-4.9 4.2-4.9 7.4l0 88c0 4.4-3.6 8-8 8l-152 0c-17.7 0-32 14.3-32 32z", "M493.7 250.3l-144-144c-2.3-2.3-5.7-3-8.7-1.7s-4.9 4.2-4.9 7.4l0 88c0 4.4-3.6 8-8 8l-152 0c-17.7 0-32 14.3-32 32l0 32c0 17.7 14.3 32 32 32l152 0c4.4 0 8 3.6 8 8l0 88c0 3.2 1.9 6.2 4.9 7.4l0 0c3 1.2 6.4 .6 8.7-1.7l144-144c3.1-3.1 3.1-8.2 0-11.3zM256 320l-80 0c-26.5 0-48-21.5-48-48l0-32c0-26.5 21.5-48 48-48l144 0 0-80c0-9.7 5.8-18.5 14.8-22.2S354.1 88.2 361 95l144 144 0 0c9.4 9.4 9.4 24.6 0 33.9L361 417c-6.9 6.9-17.2 8.9-26.2 5.2S320 409.7 320 400l0-80-64 0zM8 64c4.4 0 8 3.6 8 8l0 368c0 4.4-3.6 8-8 8s-8-3.6-8-8L0 72c0-4.4 3.6-8 8-8z"]],
    "circle-q": [512, 512, [], "e11e", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zm136 0c0-57.4 46.6-104 104-104s104 46.6 104 104c0 25.8-9.4 49.5-25 67.7l22.7 22.7c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L323.7 335c-18.2 15.6-41.8 25-67.7 25-57.4 0-104-46.6-104-104zm16 0c0 48.6 39.4 88 88 88 21.4 0 41.1-7.7 56.3-20.4l-36.5-36.5c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0l36.5 36.5c12.7-15.3 20.4-34.9 20.4-56.3 0-48.6-39.4-88-88-88s-88 39.4-88 88z", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM168 256c0-48.6 39.4-88 88-88s88 39.4 88 88c0 21.4-7.7 41.1-20.4 56.3l-36.5-36.5c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l36.5 36.5c-15.3 12.7-34.9 20.4-56.3 20.4-48.6 0-88-39.4-88-88zm192 0c0-57.4-46.6-104-104-104s-104 46.6-104 104 46.6 104 104 104c25.8 0 49.5-9.4 67.7-25l22.7 22.7c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3L335 323.7c15.6-18.2 25-41.8 25-67.7z"]],
    "moon-over-sun": [576, 512, ["eclipse-alt"], "f74a", ["M37.2 152c-1 2.4-.9 5.2 .5 7.4l61.2 92.2c1.8 2.7 1.8 6.2 0 8.8L37.7 352.6c-1.5 2.2-1.5 5-.5 7.4s3 4.3 5.6 4.9l108.4 21.9c3.2 .6 5.6 3.1 6.3 6.3l21.9 108.4c.5 2.6 2.4 4.6 4.9 5.6s5.2 .9 7.4-.5l92.2-61.2c2.7-1.8 6.2-1.8 8.8 0l92.2 61.2c2.2 1.5 5 1.5 7.4 .5s4.3-3 4.9-5.6l21.9-108.4c.6-3.2 3.1-5.6 6.3-6.3l108.4-21.9c2.6-.5 4.6-2.4 5.6-4.9s.9-5.2-.5-7.4l-61.2-92.2c-1.8-2.7-1.8-6.2 0-8.8l61.2-92.2c1.5-2.2 1.5-5 .5-7.4s-3-4.3-5.6-4.9L425.3 125.2c-3.2-.6-5.6-3.1-6.3-6.3L397.1 10.5c-.5-2.6-2.4-4.6-4.9-5.6s-5.2-.9-7.4 .5L292.7 66.6c-2.7 1.8-6.2 1.8-8.8 0L191.7 5.4c-2.2-1.5-5-1.5-7.4-.5s-4.3 3-4.9 5.6L157.5 118.9c-.6 3.2-3.1 5.6-6.3 6.3L42.8 147.1c-2.6 .5-4.6 2.4-5.6 4.9zM399.7 256a111.7 111.7 0 1 1 -223.5 0 111.7 111.7 0 1 1 223.5 0zM288.3 232c0 39.8 32.2 72 72 72 4 0 7.9-.3 11.7-.9 7.8-13.9 12.3-30 12.3-47.1 0-39.2-23.5-73-57.3-87.9-23 12-38.7 36.1-38.7 63.9z", "M392.3 4.9c-2.4-1-5.2-.9-7.4 .5L292.7 66.6c-2.7 1.8-6.2 1.8-8.8 0L191.7 5.4c-2.2-1.5-5-1.5-7.4-.5s-4.3 3-4.9 5.6L157.5 118.9c-.6 3.2-3.1 5.6-6.3 6.3L42.8 147.1c-2.6 .5-4.6 2.4-5.6 4.9s-.9 5.2 .5 7.4l61.2 92.2c1.8 2.7 1.8 6.2 0 8.8L37.7 352.6c-1.5 2.2-1.5 5-.5 7.4s3 4.3 5.6 4.9l108.4 21.9c3.2 .6 5.6 3.1 6.3 6.3l21.9 108.4c.5 2.6 2.4 4.6 4.9 5.6s5.2 .9 7.4-.5l92.2-61.2c2.7-1.8 6.2-1.8 8.8 0l92.2 61.2c2.2 1.5 5 1.5 7.4 .5s4.3-3 4.9-5.6l21.9-108.4c.6-3.2 3.1-5.6 6.3-6.3l108.4-21.9c2.6-.5 4.6-2.4 5.6-4.9s.9-5.2-.5-7.4l-61.2-92.2c-1.8-2.7-1.8-6.2 0-8.8l61.2-92.2c1.5-2.2 1.5-5 .5-7.4s-3-4.3-5.6-4.9L425.3 125.2c-3.2-.6-5.6-3.1-6.3-6.3L397.1 10.5c-.5-2.6-2.4-4.6-4.9-5.6zM376-7.9c7.4-4.9 16-4.6 22.4-2S411-1.4 412.8 7.3l20.9 103.2 103.2 20.9c8.8 1.8 14.6 8.1 17.2 14.4s3 14.9-2 22.4l-58.2 87.8 58.2 87.8c4.9 7.4 4.6 16 2 22.4s-8.4 12.6-17.2 14.4l-103.2 20.9-20.9 103.2c-1.8 8.8-8.1 14.6-14.4 17.2s-14.9 3-22.4-2l-87.8-58.2-87.8 58.2c-7.4 4.9-16 4.6-22.4 2s-12.7-8.4-14.4-17.2L142.8 401.4 39.6 380.5c-8.8-1.8-14.6-8.1-17.2-14.4l0 0c-2.6-6.3-3-14.9 2-22.4L82.6 256 24.4 168.2c-4.9-7.4-4.6-16-2-22.4s8.4-12.6 17.2-14.4L142.8 110.6 163.7 7.3c1.8-8.8 8.1-14.6 14.4-17.2s14.9-3 22.4 2l0 0 87.8 58.2 87.8-58.2zM175.7 256a112.3 112.3 0 1 1 224.5 0 112.3 112.3 0 1 1 -224.5 0zm196.2 47c7.8-13.9 12.3-30 12.3-47.1 0-39.2-23.5-73-57.3-87.9-23 12-38.7 36.1-38.7 63.9 0 39.8 32.2 72 72 72 4 0 7.9-.3 11.7-.9zM307.1 161.8c-6.1-1.2-12.4-1.9-18.9-1.9-53 0-96 43-96 96s43 96 96 96c28.4 0 54-12.4 71.5-32-48.4-.2-87.5-39.5-87.5-88 0-28.6 13.7-54.1 34.9-70.2z"]],
    "360-degrees": [640, 512, [], "e2dc", ["M592 32a16 16 0 1 0 32 0 16 16 0 1 0 -32 0z", "M592 32a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm48 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM8 64c-4.4 0-8 3.6-8 8s3.6 8 8 8L142.9 80 33.9 210.9c-2 2.4-2.4 5.7-1.1 8.5S36.9 224 40 224l32 0c57.4 0 104 46.6 104 104l0 19.4c0 46.7-37.9 84.6-84.6 84.6-25.1 0-48.9-11.2-65-30.4L14.1 386.9c-2.8-3.4-7.9-3.9-11.3-1s-3.9 7.9-1 11.3l12.2 14.7C33.2 434.7 61.5 448 91.4 448 147 448 192 403 192 347.4l0-19.4c0-66.3-53.7-120-120-120L57.1 208 166.1 77.1c2-2.4 2.4-5.7 1.1-8.5S163.1 64 160 64L8 64zm424 80c0-35.3 28.7-64 64-64s64 28.7 64 64l0 224c0 35.3-28.7 64-64 64s-64-28.7-64-64l0-224zM576 368l0-224c0-44.2-35.8-80-80-80s-80 35.8-80 80l0 224c0 44.2 35.8 80 80 80s80-35.8 80-80zM344 80c4.4 0 8-3.6 8-8s-3.6-8-8-8c-66.3 0-120 53.7-120 120l0 104 0 .1 0 79.9c0 44.2 35.8 80 80 80s80-35.8 80-80l0-80c0-44.2-35.8-80-80-80-26.2 0-49.4 12.6-64 32l0-56c0-57.4 46.6-104 104-104zM240 288c0-35.3 28.7-64 64-64s64 28.7 64 64l0 80c0 35.3-28.7 64-64 64s-64-28.7-64-64l0-80z"]],
    "bracket-round-right": [192, 512, [], "29", ["", "M32.8 36.4c-2 4-.4 8.8 3.6 10.7 23.1 11.5 58.2 36.1 87.4 71.7 29.2 35.6 52.2 81.9 52.2 137.1s-23 101.5-52.2 137.1c-29.2 35.7-64.3 60.2-87.4 71.7-4 2-5.6 6.8-3.6 10.7s6.8 5.6 10.7 3.6c24.9-12.5 61.8-38.3 92.6-75.9 30.8-37.6 55.8-87.3 55.8-147.3s-25-109.7-55.8-147.3c-30.8-37.5-67.7-63.4-92.6-75.9-4-2-8.8-.4-10.7 3.6z"]],
    "square-full": [512, 512, [128997, 128998, 128999, 129000, 129001, 129002, 129003, 11035, 11036], "f45c", ["M16 64l0 384c0 26.5 21.5 48 48 48l384 0c26.5 0 48-21.5 48-48l0-384c0-26.5-21.5-48-48-48L64 16C37.5 16 16 37.5 16 64z", "M448 16c26.5 0 48 21.5 48 48l0 384c0 26.5-21.5 48-48 48L64 496c-26.5 0-48-21.5-48-48L16 64c0-26.5 21.5-48 48-48l384 0zM64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-384c0-35.3-28.7-64-64-64L64 0z"]],
    "star-sharp": [512, 512, [], "e28b", ["M16 194.9c0 .9 .4 1.7 1 2.2L157.1 313.9c2.5 2.1 3.5 5.4 2.5 8.5L107.4 494.1c-.3 .9 .4 1.9 1.4 1.9 .3 0 .6-.1 .9-.3l141.4-110c2.9-2.2 6.9-2.2 9.8 0l141.4 110c.3 .2 .6 .3 .9 .3 1 0 1.7-.9 1.4-1.9L352.3 322.3c-.9-3.1 .1-6.4 2.5-8.5L495 197.1c.7-.6 1-1.4 1-2.2 0-1.6-1.3-2.9-2.9-2.9L320 192c-3.5 0-6.6-2.3-7.6-5.6L258.8 18c-.4-1.2-1.5-2-2.8-2s-2.4 .8-2.8 2L199.6 186.4c-1.1 3.3-4.1 5.6-7.6 5.6L18.9 192c-1.6 0-2.9 1.3-2.9 2.9z", "M256 16c-1.3 0-2.4 .8-2.8 2L199.6 186.4c-1.1 3.3-4.1 5.6-7.6 5.6L18.9 192c-1.6 0-2.9 1.3-2.9 2.9 0 .9 .4 1.7 1 2.2L157.1 313.9c2.5 2.1 3.5 5.4 2.5 8.5L107.4 494.1c-.3 .9 .4 1.9 1.4 1.9 .3 0 .6-.1 .9-.3l141.4-110c2.9-2.2 6.9-2.2 9.8 0l141.4 110c.3 .2 .6 .3 .9 .3 1 0 1.7-.9 1.4-1.9L352.3 322.3c-.9-3.1 .1-6.4 2.5-8.5L495 197.1c.7-.6 1-1.4 1-2.2 0-1.6-1.3-2.9-2.9-2.9L320 192c-3.5 0-6.6-2.3-7.6-5.6L258.8 18c-.4-1.2-1.5-2-2.8-2zm-18-2.8C240.5 5.3 247.8 0 256 0s15.5 5.3 18 13.2l51.8 162.8 167.3 0c10.4 0 18.9 8.5 18.9 18.9 0 5.6-2.5 10.9-6.8 14.5l-136 113.3 50.7 166.7c3.4 11.2-5 22.5-16.7 22.5-3.9 0-7.7-1.3-10.7-3.7L256 402.1 119.5 508.3c-3.1 2.4-6.8 3.7-10.7 3.7-11.7 0-20.1-11.3-16.7-22.5l50.7-166.7-136-113.3C2.5 205.8 0 200.5 0 194.9 0 184.5 8.5 176 18.9 176L186.2 176 238 13.2z"]],
    "list-radio": [512, 512, [], "e1d0", ["M16 96c0 10.4 3.3 20 8.9 27.8l1.5-1.5 64-64 1.5-1.5C84 51.3 74.4 48 64 48 37.5 48 16 69.5 16 96zm0 160a48 48 0 1 0 96 0 48 48 0 1 0 -96 0zm0 160a48 48 0 1 0 96 0 48 48 0 1 0 -96 0zM36.2 135.1c7.8 5.6 17.4 8.9 27.8 8.9 26.5 0 48-21.5 48-48 0-10.4-3.3-20-8.9-27.8l-1.5 1.5-64 64-1.5 1.5z", "M103.1 68.2l-1.5 1.5-64 64-1.5 1.5c7.8 5.6 17.4 8.9 27.8 8.9 26.5 0 48-21.5 48-48 0-10.4-3.3-20-8.9-27.8zM91.8 56.9c-7.8-5.6-17.4-8.9-27.8-8.9-26.5 0-48 21.5-48 48 0 10.4 3.3 20 8.9 27.8l1.5-1.5 64-64 1.5-1.5zM64 160a64 64 0 1 1 0-128 64 64 0 1 1 0 128zm0 48a48 48 0 1 0 0 96 48 48 0 1 0 0-96zm0 112a64 64 0 1 1 0-128 64 64 0 1 1 0 128zm48 96a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM0 416a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zM192 96c0-4.4 3.6-8 8-8l304 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-304 0c-4.4 0-8-3.6-8-8zm0 160c0-4.4 3.6-8 8-8l304 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-304 0c-4.4 0-8-3.6-8-8zm0 160c0-4.4 3.6-8 8-8l304 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-304 0c-4.4 0-8-3.6-8-8z"]],
    "head-side-medical": [512, 512, [], "f809", ["M16 216c0 61.8 28 117 72 153.7 1.6 1.4 3.3 2.7 4.9 4 1.9 1.5 3.1 3.8 3.1 6.3l0 124c0 4.4-3.6 8-8 8l224 0c-4.4 0-8-3.6-8-8l0-64c0-4.4 3.6-8 8-8l40 0c30.9 0 56-25.1 56-56l0-56c0-4.4 3.6-8 8-8l31.7 0c17.8 0 32.3-14.5 32.3-32.3 0-8.1-3-15.9-8.5-21.8l-54.7-59.7c-1.1-1.3-1.9-2.8-2.1-4.5-.1-1.1-.3-2.2-.4-3.3-12.6-98.4-96.6-174.4-198.4-174.4-110.5 0-200 89.5-200 200zm112-8c0-13.3 10.7-24 24-24l32 0 0-32c0-13.3 10.7-24 24-24l32 0c13.3 0 24 10.7 24 24l0 32 32 0c13.3 0 24 10.7 24 24l0 32c0 13.3-10.7 24-24 24l-32 0 0 32c0 13.3-10.7 24-24 24l-32 0c-13.3 0-24-10.7-24-24l0-32-32 0c-13.3 0-24-10.7-24-24l0-32z", "M16 216c0-110.5 89.5-200 200-200 102.9 0 187.7 77.7 198.8 177.7 .2 1.7 .9 3.3 2.1 4.5l54.7 59.7c5.5 6 8.5 13.8 8.5 21.8 0 17.8-14.5 32.3-32.3 32.3L416 312c-4.4 0-8 3.6-8 8l0 56c0 30.9-25.1 56-56 56l-40 0c-4.4 0-8 3.6-8 8l0 64c0 4.4 3.6 8 8 8s8-3.6 8-8l0-56 32 0c39.8 0 72-32.2 72-72l0-48 23.7 0c26.7 0 48.3-21.6 48.3-48.3 0-12.1-4.5-23.7-12.7-32.6l-52.9-57.7C417.2 82.6 326.2 0 216 0 96.7 0 0 96.7 0 216 0 283.7 31.2 344.2 80 383.8L80 504c0 4.4 3.6 8 8 8s8-3.6 8-8l0-124c0-2.5-1.1-4.8-3.1-6.3-46.8-36.6-76.9-93.6-76.9-157.7zm184-64c0-4.4 3.6-8 8-8l32 0c4.4 0 8 3.6 8 8l0 40c0 4.4 3.6 8 8 8l40 0c4.4 0 8 3.6 8 8l0 32c0 4.4-3.6 8-8 8l-40 0c-4.4 0-8 3.6-8 8l0 40c0 4.4-3.6 8-8 8l-32 0c-4.4 0-8-3.6-8-8l0-40c0-4.4-3.6-8-8-8l-40 0c-4.4 0-8-3.6-8-8l0-32c0-4.4 3.6-8 8-8l40 0c2.1 0 4.2-.8 5.7-2.3s2.3-3.5 2.3-5.7l0-40zm8-24c-13.3 0-24 10.7-24 24l0 32-32 0c-13.3 0-24 10.7-24 24l0 32c0 13.3 10.7 24 24 24l32 0 0 32c0 13.3 10.7 24 24 24l32 0c13.3 0 24-10.7 24-24l0-32 32 0c13.3 0 24-10.7 24-24l0-32c0-13.3-10.7-24-24-24l-32 0 0-32c0-13.3-10.7-24-24-24l-32 0z"]],
    "tombstone": [448, 512, [], "f720", ["M48 192l0 304 352 0 0-304c0-97.2-78.8-176-176-176S48 94.8 48 192zm88 32c0-4.4 3.6-8 8-8l72 0 0-72c0-4.4 3.6-8 8-8s8 3.6 8 8l0 72 72 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-72 0 0 136c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-136-72 0c-4.4 0-8-3.6-8-8z", "M400 496l-352 0 0-304C48 94.8 126.8 16 224 16S400 94.8 400 192l0 304zM32 192l0 304-24 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l432 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-24 0 0-304C416 86 330 0 224 0S32 86 32 192zm200-48c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 72-72 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l72 0 0 136c0 4.4 3.6 8 8 8s8-3.6 8-8l0-136 72 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-72 0 0-72z"]],
    "square-a-lock": [576, 512, [], "e44d", ["M48 96c0-26.5 21.5-48 48-48l320 0c26.5 0 48 21.5 48 48 0 16 0 32 0 48-61.9 0-112 50.1-112 112l0 28.8c-7.6 4.4-14.5 9.8-20.6 16L263.2 164.4c-1.4-2.7-4.1-4.4-7.2-4.4s-5.8 1.7-7.2 4.4l-88 176c-2 4-.4 8.8 3.6 10.7s8.8 .4 10.7-3.6l21.8-43.6 118.1 0 5.2 10.4C310 329.7 304 348.1 304 367.9l0 96.1-208 0c-26.5 0-48-21.5-48-48L48 96zM204.9 288L256 185.9 307.1 288 204.9 288z", "M96 48l320 0c26.5 0 48 21.5 48 48l0 48c5.4 0 10.8 .4 16 1.1L480 96c0-35.3-28.7-64-64-64L96 32C60.7 32 32 60.7 32 96l0 320c0 35.3 28.7 64 64 64l209.3 0c-.9-5.2-1.3-10.5-1.3-16L96 464c-26.5 0-48-21.5-48-48L48 96c0-26.5 21.5-48 48-48zM263.2 164.4c-1.4-2.7-4.1-4.4-7.2-4.4s-5.8 1.7-7.2 4.4l-88 176c-2 4-.4 8.8 3.6 10.7s8.8 .4 10.7-3.6l21.8-43.6 118.1 0 5.2 10.4c3.3-4.9 7-9.4 11.1-13.6L263.2 164.4zM256 185.9L307.1 288 204.9 288 256 185.9zm256 70.2l0 63.9-96 0 0-63.9c0-26.5 21.5-48 48-48s48 21.5 48 48zM368 368c0-17.7 14.3-32 32-32l0 .1 128 0 0-.1c17.7 0 32 14.3 32 32l0 96c0 17.7-14.3 32-32 32l-128 0c-17.7 0-32-14.3-32-32l0-96zM528 256.1c0-35.3-28.7-64-64-64s-64 28.7-64 64l0 63.9c-26.5 0-48 21.5-48 48l0 96c0 26.5 21.5 48 48 48l128 0c26.5 0 48-21.5 48-48l0-96c0-26.5-21.5-48-48-48l0-63.9z"]],
    "clover": [512, 512, [], "e139", ["M33 199.5c0 11.2 4.5 22 12.4 29.9l20.8 20.9c3.1 3.1 3.1 8.2 0 11.3L45.4 282.5c-7.9 7.9-12.4 18.7-12.4 29.9 0 23.4 19 42.4 42.3 42.4l4.4 0c9.5 0 18.9-2.3 27.4-6.6l94.2-47.9c3.1-1.6 6.8-1 9.3 1.5 2.4 2.4 3 6.2 1.5 9.3l-47.9 94.1c-4.3 8.5-6.6 17.9-6.6 27.4l0 4.4c0 23.4 19 42.3 42.3 42.3 11.2 0 22-4.5 29.9-12.4l20.9-20.8 1.2-1c1.3-.9 2.9-1.3 4.4-1.3 2.1 0 4.2 .9 5.7 2.3L282.9 467c7.9 7.9 18.7 12.4 29.9 12.4 23.4 0 42.4-19 42.4-42.3l0-4.4c0-7.1-1.3-14.2-3.8-20.9l-2.8-6.5-47.9-94.1c-1.6-3.1-1-6.9 1.5-9.3s6.2-3 9.3-1.5l94.1 47.9 6.5 2.8c6.7 2.5 13.8 3.7 20.9 3.8l4.4 0c23.4 0 42.3-19 42.3-42.4 0-11.2-4.5-22-12.4-29.9l-20.8-20.8c-1.5-1.5-2.3-3.5-2.3-5.7s.9-4.2 2.3-5.7l20.8-20.9c7.9-7.9 12.4-18.7 12.4-29.9 0-23.4-19-42.3-42.3-42.3l-4.3 0c-9.6 0-19.1 2.3-27.6 6.7l-92.7 47.8c-3.1 1.6-6.8 1-9.3-1.4s-3.1-6.2-1.6-9.2l46.9-94.3 2.8-6.5c2.4-6.6 3.6-13.6 3.6-20.6l0-4.7c0-23.4-19-42.3-42.4-42.3-9.8 0-19.3 3.4-26.8 9.6l-3.1 2.8-20.8 20.8c-1.5 1.5-3.5 2.3-5.7 2.3s-4.2-.8-5.7-2.3L229.9 45c-7.9-7.9-18.7-12.4-29.9-12.4-23.4 0-42.3 19-42.3 42.3l0 4.4c0 9.5 2.2 18.9 6.6 27.4l47.9 94.2c1.6 3.1 1 6.8-1.5 9.3s-6.2 3-9.3 1.5l-94.2-47.9c-8.5-4.3-17.9-6.6-27.4-6.6l-4.4 0c-23.4 0-42.3 19-42.3 42.3z", "M312.9 16.6c32.2 0 58.4 26.1 58.4 58.3l0 4.7c0 10.4-2.1 20.6-6.2 30.2l-1.8 4-36 72.4 71.1-36.6c10.8-5.6 22.8-8.5 35-8.5l4.3 0c32.2 0 58.3 26.1 58.3 58.3 0 15.5-6.1 30.3-17.1 41.2l-15.2 15.2 15.2 15.2c10.9 10.9 17.1 25.8 17.1 41.3 0 32.2-26.1 58.4-58.3 58.4l-4.4 0c-10.5 0-21-2.2-30.6-6.4l-4.1-1.9-72.2-36.7 36.7 72.2 1.9 4.1c4.2 9.6 6.4 20.1 6.4 30.6l0 4.4c0 32.2-26.1 58.3-58.4 58.3-15.5 0-30.3-6.1-41.3-17.1l-15.2-15.2-15.2 15.2c-10.9 10.9-25.8 17.1-41.2 17.1-32.2 0-58.3-26.1-58.3-58.3l0-4.4c0-12.1 2.8-23.9 8.3-34.7l36.7-72.2-72.2 36.8c-10.7 5.5-22.6 8.3-34.7 8.3l-4.4 0c-32.2 0-58.3-26.2-58.3-58.4 0-15.5 6.2-30.3 17.1-41.3L49.3 256 34.1 240.8C23.2 229.8 17 215 17 199.5 17 167.3 43.1 141.2 75.3 141.2l4.4 0c12.1 0 23.9 2.8 34.7 8.3l72.2 36.8-36.8-72.2c-5.5-10.7-8.3-22.6-8.3-34.7l0-4.4c0-32.2 26.1-58.3 58.3-58.3 15.5 0 30.3 6.2 41.2 17.1l15.2 15.2 15.2-15.2 4.3-3.9c10.4-8.5 23.4-13.2 37-13.2zm0 16c-9.8 0-19.3 3.4-26.8 9.6l-3.1 2.8-20.8 20.8c-1.5 1.5-3.5 2.3-5.7 2.3s-4.2-.8-5.7-2.3L229.9 45c-7.9-7.9-18.7-12.4-29.9-12.4-23.4 0-42.3 19-42.3 42.3l0 4.4c0 9.5 2.2 18.9 6.6 27.4l47.9 94.2c1.6 3.1 1 6.8-1.5 9.3s-6.2 3-9.3 1.5l-94.2-47.9c-8.5-4.3-17.9-6.6-27.4-6.6l-4.4 0c-23.4 0-42.3 19-42.3 42.3 0 11.2 4.5 22 12.4 29.9l20.8 20.9c3.1 3.1 3.1 8.2 0 11.3L45.4 282.5c-7.9 7.9-12.4 18.7-12.4 29.9 0 23.4 19 42.4 42.3 42.4l4.4 0c9.5 0 18.9-2.3 27.4-6.6l94.2-47.9c3.1-1.6 6.8-1 9.3 1.5 2.4 2.4 3 6.2 1.5 9.3l-47.9 94.1c-4.3 8.5-6.6 17.9-6.6 27.4l0 4.4c0 23.4 19 42.3 42.3 42.3 11.2 0 22-4.5 29.9-12.4l20.9-20.8 1.2-1c1.3-.9 2.9-1.3 4.4-1.3 2.1 0 4.2 .9 5.7 2.3L282.9 467c7.9 7.9 18.7 12.4 29.9 12.4 23.4 0 42.4-19 42.4-42.3l0-4.4c0-7.1-1.3-14.2-3.8-20.9l-2.8-6.5-47.9-94.1c-1.6-3.1-1-6.9 1.5-9.3s6.2-3 9.3-1.5l94.1 47.9 6.5 2.8c6.7 2.5 13.8 3.7 20.9 3.8l4.4 0c23.4 0 42.3-19 42.3-42.4 0-11.2-4.5-22-12.4-29.9l-20.8-20.8c-1.5-1.5-2.3-3.5-2.3-5.7s.9-4.2 2.3-5.7l20.8-20.9c7.9-7.9 12.4-18.7 12.4-29.9 0-23.4-19-42.3-42.3-42.3l-4.3 0c-9.6 0-19.1 2.3-27.6 6.7l-92.7 47.8c-3.1 1.6-6.8 1-9.3-1.4s-3.1-6.2-1.6-9.2l46.9-94.3 2.8-6.5c2.4-6.6 3.6-13.6 3.6-20.6l0-4.7c0-23.4-19-42.3-42.4-42.3z"]],
    "signal-bars-fair": [448, 512, ["signal-alt-2"], "f692", ["", "M160 264c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 208c0 4.4 3.6 8 8 8s8-3.6 8-8l0-208zM16 392c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 80c0 4.4 3.6 8 8 8s8-3.6 8-8l0-80z"]],
    "folder-heart": [512, 512, [], "e189", ["M16 96l0 288c0 26.5 21.5 48 48 48l384 0c26.5 0 48-21.5 48-48l0-240c0-26.5-21.5-48-48-48L298.7 96c-10.4 0-20.5-3.4-28.8-9.6L231.5 57.6c-8.3-6.2-18.4-9.6-28.8-9.6L64 48C37.5 48 16 69.5 16 96zM144 237.3c0-33.9 27.5-61.3 61.3-61.3 19.3 0 37.5 9.1 49.1 24.5l1.6 2.1 1.6-2.1c11.6-15.4 29.8-24.5 49.1-24.5 33.9 0 61.3 27.5 61.3 61.3l0 2.7c0 32-22.8 60.8-45.8 82.1-23.4 21.6-49.1 37.3-58.5 42.7-4.8 2.8-10.6 2.8-15.4 0-9.5-5.5-35.1-21.1-58.5-42.7-23-21.3-45.8-50.1-45.8-82.1l0-2.7z", "M448 432L64 432c-26.5 0-48-21.5-48-48L16 96c0-26.5 21.5-48 48-48l138.7 0c10.4 0 20.5 3.4 28.8 9.6l38.4 28.8c8.3 6.2 18.4 9.6 28.8 9.6L448 96c26.5 0 48 21.5 48 48l0 240c0 26.5-21.5 48-48 48zM64 448l384 0c35.3 0 64-28.7 64-64l0-240c0-35.3-28.7-64-64-64L298.7 80c-6.9 0-13.7-2.2-19.2-6.4L241.1 44.8C230 36.5 216.5 32 202.7 32L64 32C28.7 32 0 60.7 0 96L0 384c0 35.3 28.7 64 64 64zm96-210.7c0-25 20.3-45.3 45.3-45.3 14.3 0 27.7 6.7 36.3 18.1l8 10.7c1.5 2 3.9 3.2 6.4 3.2s4.9-1.2 6.4-3.2l8-10.7c8.6-11.4 22-18.1 36.3-18.1 25 0 45.3 20.3 45.3 45.3l0 2.7c0 24.8-18.1 49.5-40.6 70.4-21.9 20.2-46.1 35.1-55.4 40.5-9.3-5.4-33.5-20.2-55.4-40.5-22.5-20.8-40.6-45.6-40.6-70.4l0-2.7zM205.3 176c-33.9 0-61.3 27.5-61.3 61.3l0 2.7c0 32 22.8 60.8 45.8 82.1 23.4 21.6 49.1 37.3 58.5 42.7 4.8 2.8 10.6 2.8 15.4 0 9.5-5.5 35.1-21.1 58.5-42.7 23-21.3 45.8-50.1 45.8-82.1l0-2.7c0-33.9-27.5-61.3-61.3-61.3-19.3 0-37.5 9.1-49.1 24.5l-1.6 2.1-1.6-2.1c-11.6-15.4-29.8-24.5-49.1-24.5z"]],
    "cloud-word": [576, 512, [], "e138", ["M16 336c0 70.7 57.3 128 128 128l304 0c61.9 0 112-50.1 112-112 0-48-30.2-89-72.8-104.9-2.3-.8-4-2.7-4.8-5s-.4-4.8 .9-6.8c8-12.5 12.7-27.3 12.7-43.2 0-44.2-35.8-80-80-80-17.6 0-33.8 5.7-47 15.2-2 1.4-4.4 1.9-6.8 1.3s-4.3-2.3-5.2-4.5c-19.9-44.8-64.8-76-117-76-70.7 0-128 57.3-128 128 0 9.4 1 18.6 2.9 27.4 .9 4.1-1.6 8.3-5.7 9.4-53.8 15.1-93.3 64.6-93.3 123.2zm144-56c0-4.4 3.6-8 8-8l112 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-112 0c-4.4 0-8-3.6-8-8zm0 80c0-4.4 3.6-8 8-8l64 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-64 0c-4.4 0-8-3.6-8-8zm128 0c0-4.4 3.6-8 8-8l112 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-112 0c-4.4 0-8-3.6-8-8zm48-80c0-4.4 3.6-8 8-8l64 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-64 0c-4.4 0-8-3.6-8-8z", "M96 176c0-79.5 64.5-144 144-144 55.4 0 103.5 31.3 127.6 77.1 14.2-8.3 30.8-13.1 48.4-13.1 53 0 96 43 96 96 0 15.7-3.8 30.6-10.5 43.7 44 20.3 74.5 64.7 74.5 116.3 0 70.7-57.3 128-128 128l-304 0C64.5 480 0 415.5 0 336 0 272.6 41 218.8 97.9 199.5 96.7 191.9 96 184 96 176zM240 48c-70.7 0-128 57.3-128 128 0 9.4 1 18.6 2.9 27.4 .9 4.1-1.6 8.3-5.7 9.4-53.8 15.1-93.3 64.6-93.3 123.2 0 70.7 57.3 128 128 128l304 0c61.9 0 112-50.1 112-112 0-48-30.2-89-72.8-104.9-2.3-.8-4-2.7-4.8-5s-.4-4.8 .9-6.8c8-12.5 12.7-27.3 12.7-43.2 0-44.2-35.8-80-80-80-17.6 0-33.8 5.7-47 15.2-2 1.4-4.4 1.9-6.8 1.3s-4.3-2.3-5.2-4.5c-19.9-44.8-64.8-76-117-76zM160 280c0-4.4 3.6-8 8-8l112 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-112 0c-4.4 0-8-3.6-8-8zm176 0c0-4.4 3.6-8 8-8l64 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-64 0c-4.4 0-8-3.6-8-8zm72 72c4.4 0 8 3.6 8 8s-3.6 8-8 8l-112 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l112 0zm-176 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-64 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l64 0z"]],
    "screen-users": [640, 512, ["users-class"], "f63d", ["M80 64c0-26.5 21.5-48 48-48l384 0c26.5 0 48 21.5 48 48l0 145.1c-5.2-.7-10.6-1.1-16-1.1-61.9 0-112 50.1-112 112 0-61.9-50.1-112-112-112S208 258.1 208 320c0-61.9-50.1-112-112-112-5.4 0-10.8 .4-16 1.1L80 64z", "M512 16L128 16c-26.5 0-48 21.5-48 48l0 145.1c-5.5 .8-10.8 2-16 3.5L64 64C64 28.7 92.7 0 128 0L512 0c35.3 0 64 28.7 64 64l0 148.6c-5.2-1.5-10.5-2.7-16-3.5L560 64c0-26.5-21.5-48-48-48zM96 368a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm0-112a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM320 368a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm0-112a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm272 64a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zm-112 0a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zM16 488l0 16c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-16c0-39.8 32.2-72 72-72l48 0c39.8 0 72 32.2 72 72l0 16c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-16c0-30.9-25.1-56-56-56l-48 0c-30.9 0-56 25.1-56 56zm280-56c-30.9 0-56 25.1-56 56l0 16c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-16c0-39.8 32.2-72 72-72l48 0c39.8 0 72 32.2 72 72l0 16c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-16c0-30.9-25.1-56-56-56l-48 0zm168 56l0 16c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-16c0-39.8 32.2-72 72-72l48 0c39.8 0 72 32.2 72 72l0 16c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-16c0-30.9-25.1-56-56-56l-48 0c-30.9 0-56 25.1-56 56z"]],
    "teeth-open": [512, 512, [], "f62f", ["M16 96l0 96c0 23.6 17 43.2 39.4 47.2-4.7-6.6-7.4-14.6-7.4-23.2l0-24c0-30.9 25.1-56 56-56 16.9 0 32.1 7.5 42.3 19.3 7.2-25 30.3-43.3 57.7-43.3 22.2 0 41.6 12.1 52 30 10.4-18 29.8-30 52-30 27.4 0 50.4 18.3 57.7 43.3 10.3-11.9 25.4-19.3 42.3-19.3 30.9 0 56 25.1 56 56l0 24c0 8.7-2.8 16.7-7.4 23.2 22.4-4 39.4-23.7 39.4-47.2l0-96c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96zm0 272l0 80c0 26.5 21.5 48 48 48l384 0c26.5 0 48-21.5 48-48l0-80c0-22.1-15-40.8-35.4-46.3 2.2 4.3 3.4 9.2 3.4 14.3l0 24c0 30.9-25.1 56-56 56-18 0-34-8.5-44.3-21.7-8.8 22.1-30.5 37.7-55.7 37.7-22.2 0-41.6-12.1-52-30-10.4 18-29.8 30-52 30-25.3 0-46.9-15.6-55.7-37.7-10.2 13.2-26.3 21.7-44.3 21.7-30.9 0-56-25.1-56-56l0-24c0-5.1 1.2-10 3.4-14.3-20.4 5.5-35.4 24.2-35.4 46.3z", "M448 48c26.5 0 48 21.5 48 48l0 96c0 23.6-17 43.2-39.4 47.2 4.7-6.6 7.4-14.6 7.4-23.2l0-24c0-30.9-25.1-56-56-56-16.9 0-32.1 7.5-42.3 19.3-7.2-25-30.3-43.3-57.7-43.3-22.2 0-41.6 12.1-52 30-10.4-18-29.8-30-52-30-27.4 0-50.4 18.3-57.7 43.3-10.3-11.9-25.4-19.3-42.3-19.3-30.9 0-56 25.1-56 56l0 24c0 8.7 2.8 16.7 7.4 23.2-22.4-4-39.4-23.7-39.4-47.2l0-96c0-26.5 21.5-48 48-48l384 0zM144 216c0 13.3-10.7 24-24 24l-32 0c-13.3 0-24-10.7-24-24l0-24c0-22.1 17.9-40 40-40s40 17.9 40 40l0 24zm104 0c0 13.3-10.7 24-24 24l-40 0c-13.3 0-24-10.7-24-24l0-44c0-24.3 19.7-44 44-44s44 19.7 44 44l0 44zm104 0c0 13.3-10.7 24-24 24l-40 0c-13.3 0-24-10.7-24-24l0-44c0-24.3 19.7-44 44-44s44 19.7 44 44l0 44zm96 0c0 13.3-10.7 24-24 24l-32 0c-13.3 0-24-10.7-24-24l0-24c0-22.1 17.9-40 40-40s40 17.9 40 40l0 24zM64 256l384 0c35.3 0 64-28.7 64-64l0-96c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96l0 96c0 35.3 28.7 64 64 64zm40 160c18 0 34-8.5 44.3-21.7 8.8 22.1 30.5 37.7 55.7 37.7 22.2 0 41.6-12.1 52-30 10.4 18 29.8 30 52 30 25.3 0 46.9-15.6 55.7-37.7 10.2 13.2 26.3 21.7 44.3 21.7 30.9 0 56-25.1 56-56l0-24c0-5.1-1.2-10-3.4-14.3 20.4 5.5 35.4 24.2 35.4 46.3l0 80c0 26.5-21.5 48-48 48L64 496c-26.5 0-48-21.5-48-48l0-80c0-22.1 15-40.8 35.4-46.3-2.2 4.3-3.4 9.2-3.4 14.3l0 24c0 30.9 25.1 56 56 56zM80 320l48 0c8.8 0 16 7.2 16 16l0 24c0 22.1-17.9 40-40 40s-40-17.9-40-40l0-24c0-8.8 7.2-16 16-16zm352 0c8.8 0 16 7.2 16 16l0 24c0 22.1-17.9 40-40 40s-40-17.9-40-40l0-24c0-8.8 7.2-16 16-16l48 0zm-96 0c8.8 0 16 7.2 16 16l0 36c0 24.3-19.7 44-44 44s-44-19.7-44-44l0-36c0-8.8 7.2-16 16-16l56 0zm-104 0c8.8 0 16 7.2 16 16l0 36c0 24.3-19.7 44-44 44s-44-19.7-44-44l0-36c0-8.8 7.2-16 16-16l56 0zm200-16L64 304c-35.3 0-64 28.7-64 64l0 80c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-80c0-35.3-28.7-64-64-64l-16 0z"]],
    "circle-u": [512, 512, [], "e127", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zm160-88c0-4.4 3.6-8 8-8s8 3.6 8 8l0 104c0 35.3 28.7 64 64 64s64-28.7 64-64l0-104c0-4.4 3.6-8 8-8s8 3.6 8 8l0 104c0 44.2-35.8 80-80 80s-80-35.8-80-80l0-104z", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM192 168c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 104c0 44.2 35.8 80 80 80s80-35.8 80-80l0-104c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 104c0 35.3-28.7 64-64 64s-64-28.7-64-64l0-104z"]],
    "calendar-heart": [448, 512, [], "e0d3", ["M16 128l0 288c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-288c0-26.5-21.5-48-48-48l-48 0 0 24c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-24-192 0 0 24c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-24-48 0c-26.5 0-48 21.5-48 48zm96 125.3c0-33.9 27.5-61.3 61.3-61.3 19.3 0 37.5 9.1 49.1 24.5l1.6 2.1 1.6-2.1c11.6-15.4 29.8-24.5 49.1-24.5 33.9 0 61.3 27.5 61.3 61.3l0 2.7c0 32-22.8 60.8-45.8 82.1-23.4 21.6-49.1 37.3-58.5 42.7-4.8 2.8-10.6 2.8-15.4 0-9.5-5.5-35.1-21.1-58.5-42.7-23-21.3-45.8-50.1-45.8-82.1l0-2.7zm16 0l0 2.3c.2-25.4 20.2-46.2 45.3-47.6-25 0-45.3 20.3-45.3 45.3zM274.7 208c24.4 1.4 43.9 20.9 45.3 45.3 0-25-20.3-45.3-45.3-45.3z", "M120 0c4.4 0 8 3.6 8 8l0 56 192 0 0-56c0-4.4 3.6-8 8-8s8 3.6 8 8l0 56 48 0c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 128C0 92.7 28.7 64 64 64l48 0 0-56c0-4.4 3.6-8 8-8zm-8 104l0-24-48 0c-26.5 0-48 21.5-48 48l0 288c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-288c0-26.5-21.5-48-48-48l-48 0 0 24c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-24-192 0 0 24c0 4.4-3.6 8-8 8s-8-3.6-8-8zm16 149.3l0 2.7c0 24.8 18.1 49.5 40.6 70.4 21.9 20.2 46.1 35.1 55.4 40.5 9.3-5.4 33.5-20.2 55.4-40.5 22.5-20.8 40.6-45.6 40.6-70.4l0-2.7c0-25-20.3-45.3-45.3-45.3-14.3 0-27.7 6.7-36.3 18.1l-8 10.7c-1.5 2-3.9 3.2-6.4 3.2s-4.9-1.2-6.4-3.2l-8-10.7c-8.6-11.4-22-18.1-36.3-18.1-25 0-45.3 20.3-45.3 45.3zM173.3 192c19.3 0 37.5 9.1 49.1 24.5l1.6 2.1 1.6-2.1c11.6-15.4 29.8-24.5 49.1-24.5 33.9 0 61.3 27.5 61.3 61.3l0 2.7c0 32-22.8 60.8-45.8 82.1-23.4 21.6-49.1 37.3-58.5 42.7-4.8 2.8-10.6 2.8-15.4 0-9.5-5.5-35.1-21.1-58.5-42.7-23-21.3-45.8-50.1-45.8-82.1l0-2.7c0-33.9 27.5-61.3 61.3-61.3z"]],
    "narwhal": [640, 512, [], "f6fe", ["M16 112l0 59.8c0 22.5 11.8 43.3 31.1 54.9 19.7 11.8 30.6 18.4 32.9 19.8L80 352c0 79.5 64.5 144 144 144l240 0c88.4 0 160-71.6 160-160 0-88.3-72.4-160-160.9-160-47.3 0-93.4 16.3-130.1 46L164.2 359.2c-20.9 17-52.2 2.1-52.2-24.8l0-88c2.3-1.4 13.3-8 32.9-19.8 19.3-11.6 31.1-32.4 31.1-54.9l0-59.8-70.8 49.6-9.2 6.4-9.2-6.4-70.8-49.6zM512 304a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M639.7 10.2c1-3.6-.6-7.5-3.9-9.2s-7.4-1-9.9 1.9L490.5 162.1c-8.9-1.4-18.1-2.1-27.4-2.1-50.9 0-100.7 17.5-140.2 49.6L154.1 346.8c-10.5 8.5-26.1 1.1-26.1-12.4l0-78.9 25.2-15.1c24.1-14.5 38.8-40.5 38.8-68.6l0-59.8c0-6-3.3-11.4-8.6-14.2s-11.7-2.3-16.6 1.1L96 148.5 25.2 98.9c-4.9-3.4-11.3-3.8-16.6-1.1S0 106 0 112l0 59.8c0 28.1 14.7 54.1 38.8 68.6L64 255.5 64 352c0 88.4 71.6 160 160 160l240 0c97.2 0 176-78.8 176-176 0-50.4-21.5-95.9-55.7-128L639.7 10.2zM570.9 196.6c-18.4-14.1-39.6-24.7-62.6-30.7L614.5 41 570.9 196.6zM96 168l9.2-6.4 70.8-49.6 0 59.8c0 22.5-11.8 43.3-31.1 54.9-19.7 11.8-30.6 18.4-32.9 19.8l0 88c0 26.9 31.3 41.8 52.2 24.8L333 222c36.6-29.8 82.8-46 130.1-46 88.5 0 160.9 71.7 160.9 160 0 88.4-71.6 160-160 160l-240 0c-79.5 0-144-64.5-144-144l0-105.6c-2.3-1.4-13.3-8-32.9-19.8-19.3-11.6-31.1-32.4-31.1-54.9L16 112 86.8 161.6 96 168zM512 304a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"]],
    "bars-staggered": [512, 512, ["reorder", "stream"], "f550", ["", "M0 72c0-4.4 3.6-8 8-8l432 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L8 80c-4.4 0-8-3.6-8-8zM64 256c0-4.4 3.6-8 8-8l432 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L72 264c-4.4 0-8-3.6-8-8zM448 440c0 4.4-3.6 8-8 8L8 448c-4.4 0-8-3.6-8-8s3.6-8 8-8l432 0c4.4 0 8 3.6 8 8z"]],
    "warehouse": [576, 512, [], "f494", ["M16 150.3l0 25.7 544 0 0-25.7c0-16.5-10.1-31.3-25.5-37.3L299.6 21.7c-7.5-2.9-15.7-2.9-23.2 0L41.5 113C26.1 119 16 133.8 16 150.3z", "M576 150.3L576 504c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-312-544 0 0 312c0 4.4-3.6 8-8 8s-8-3.6-8-8L0 150.3c0-23.1 14.2-43.8 35.7-52.2L270.6 6.8c11.2-4.4 23.6-4.4 34.8 0L540.3 98.1c21.5 8.4 35.7 29.1 35.7 52.2zm-16 0c0-16.5-10.1-31.3-25.5-37.3L299.6 21.7c-7.5-2.9-15.7-2.9-23.2 0L41.5 113C26.1 119 16 133.8 16 150.3l0 25.7 544 0 0-25.7zM104 272l368 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-368 0c-4.4 0-8-3.6-8-8s3.6-8 8-8zM96 376c0-4.4 3.6-8 8-8l368 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-368 0c-4.4 0-8-3.6-8-8zm8 88l368 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-368 0c-4.4 0-8-3.6-8-8s3.6-8 8-8z"]],
    "swatchbook": [512, 512, [], "f5c3", ["M16 56c0-22.1 17.9-40 40-40l80 0c22.1 0 40 17.9 40 40l0 360c0 44.2-35.8 80-80 80-44.2 0-80-35.8-80-80L16 56zM48 72l0 48c0 13.3 10.7 24 24 24l48 0c13.3 0 24-10.7 24-24l0-48c0-13.3-10.7-24-24-24L72 48C58.7 48 48 58.7 48 72zm0 128l0 48c0 13.3 10.7 24 24 24l48 0c13.3 0 24-10.7 24-24l0-48c0-13.3-10.7-24-24-24l-48 0c-13.3 0-24 10.7-24 24zM64 416a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm87.8 80l160-160c43.1 0 91.2 0 144.2 0 22.1 0 40 17.9 40 40l0 80c0 22.1-17.9 40-40 40l-304.2 0zm38.3-61c1.2-6.2 1.9-12.5 1.9-19l0-209.1c31-31 65-65 102-102 15.6-15.6 40.9-15.6 56.6 0l56.6 56.6c15.6 15.6 15.6 40.9 0 56.6l-217 217z", "M120 48L72 48C58.7 48 48 58.7 48 72l0 48c0 13.3 10.7 24 24 24l48 0c13.3 0 24-10.7 24-24l0-48c0-13.3-10.7-24-24-24zM64 72c0-4.4 3.6-8 8-8l48 0c4.4 0 8 3.6 8 8l0 48c0 4.4-3.6 8-8 8l-48 0c-4.4 0-8-3.6-8-8l0-48zm8 104l48 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-48c0-13.3 10.7-24 24-24zm0 16c-4.4 0-8 3.6-8 8l0 48c0 4.4 3.6 8 8 8l48 0c4.4 0 8-3.6 8-8l0-48c0-4.4-3.6-8-8-8l-48 0zM96 384a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm16 32a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zM136 0L56 0C25.1 0 0 25.1 0 56L0 416c0 53 43 96 96 96l360 0c30.9 0 56-25.1 56-56l0-80c0-30.9-25.1-56-56-56l-61.1 0-16 16 77.1 0c22.1 0 40 17.9 40 40l0 80c0 22.1-17.9 40-40 40l-304.2 0 266.7-266.7c21.9-21.9 21.9-57.3 0-79.2L361.9 93.6c-21.9-21.9-57.3-21.9-79.2 0l-42.7 42.7 0 22.6 54-54c15.6-15.6 40.9-15.6 56.6 0l56.6 56.6c15.6 15.6 15.6 40.9 0 56.6l-217 217c1.2-6.2 1.9-12.5 1.9-19l0-360c0-30.9-25.1-56-56-56zm16.6 472.6c-14.5 14.5-34.5 23.4-56.6 23.4-44.2 0-80-35.8-80-80L16 56c0-22.1 17.9-40 40-40l80 0c22.1 0 40 17.9 40 40l0 360c0 22.1-8.9 42.1-23.4 56.6z"]],
    "circle-three-quarters": [512, 512, [], "e125", ["M16 256c0 132.6 107.5 240 240 240 122.4 0 223.4-91.6 238.2-210 .8-6.7-4.7-14-14.2-14l-208 0c-17.7 0-32-14.3-32-32l0-208c0-9.4-7.3-15-14-14.1-118.4 14.7-210 115.8-210 238.1z", "M226 17.9c-118.4 14.7-210 115.8-210 238.1 0 132.6 107.5 240 240 240 122.4 0 223.4-91.6 238.2-210 .8-6.7-4.7-14-14.2-14l-208 0c-17.7 0-32-14.3-32-32l0-208c0-9.4-7.3-15-14-14.1zM224.1 2C241.6-.2 256 14.3 256 32l0 208c0 8.8 7.2 16 16 16l208 0C497.7 256 512.2 270.4 510 287.9 494.3 414.2 386.6 512 256 512 114.6 512 0 397.4 0 256 0 125.4 97.8 17.7 224.1 2z"]],
    "circle-chf": [512, 512, [], "e72c", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zm80-68c0-24.3 19.7-44 44-44s44 19.7 44 44l0 4c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-4c0-15.5-12.5-28-28-28s-28 12.5-28 28l0 136c0 15.5 12.5 28 28 28s28-12.5 28-28l0-4c0-4.4 3.6-8 8-8s8 3.6 8 8l0 4c0 24.3-19.7 44-44 44s-44-19.7-44-44l0-136zm112-36c0-4.4 3.6-8 8-8s8 3.6 8 8l0 96 64 0 0-96c0-4.4 3.6-8 8-8s8 3.6 8 8l0 208c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-96-64 0 0 96c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-208zm128 0c0-4.4 3.6-8 8-8l64 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-56 0 0 80 48 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-48 0 0 104c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-208z", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM140 144c-24.3 0-44 19.7-44 44l0 136c0 24.3 19.7 44 44 44s44-19.7 44-44l0-4c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 4c0 15.5-12.5 28-28 28s-28-12.5-28-28l0-136c0-15.5 12.5-28 28-28s28 12.5 28 28l0 4c0 4.4 3.6 8 8 8s8-3.6 8-8l0-4c0-24.3-19.7-44-44-44zm84 8c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 208c0 4.4 3.6 8 8 8s8-3.6 8-8l0-96 64 0 0 96c0 4.4 3.6 8 8 8s8-3.6 8-8l0-208c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 96-64 0 0-96zm120-8c-4.4 0-8 3.6-8 8l0 208c0 4.4 3.6 8 8 8s8-3.6 8-8l0-104 48 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-48 0 0-80 56 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-64 0z"]],
    "campground": [512, 512, [9978], "f6bb", ["M16 401l0 55c0 4.4 3.6 8 8 8l93.5 0 4.3-5.2 128-152c1.5-1.8 3.8-2.8 6.1-2.8s4.6 1 6.1 2.8l128 152 4.3 5.2 93.5 0c4.4 0 8-3.6 8-8l0-55c0-3.8-1.4-7.6-3.9-10.5L256 118.1 19.9 390.5c-2.5 2.9-3.9 6.6-3.9 10.5z", "M325.2 26c3.3 2.9 3.7 7.9 .8 11.3L266.6 105.8 504.2 380c5 5.8 7.8 13.3 7.8 21l0 55c0 13.3-10.7 24-24 24L24 480c-13.3 0-24-10.7-24-24l0-55c0-7.7 2.8-15.1 7.8-21L245.4 105.8 186 37.2c-2.9-3.3-2.5-8.4 .8-11.3s8.4-2.5 11.3 .8l58 66.9 58-66.9c2.9-3.3 7.9-3.7 11.3-.8zM19.9 390.5c-2.5 2.9-3.9 6.6-3.9 10.5l0 55c0 4.4 3.6 8 8 8l93.5 0 4.3-5.2 128-152c1.5-1.8 3.8-2.8 6.1-2.8s4.6 1 6.1 2.8l128 152 4.3 5.2 93.5 0c4.4 0 8-3.6 8-8l0-55c0-3.8-1.4-7.6-3.9-10.5L256 118.1 19.9 390.5zM138.5 464L373.5 464 256 324.4 138.5 464z"]],
    "person-walking-arrow-right": [576, 512, [], "e552", ["M9.4 489.4c-12.5 12.5-12.5 32.8 0 45.3 7.3 7.3 17.1 10.3 26.6 9.1-6.2-.8-12.3-3.4-17.3-8-13.1-11.8-14.2-32.1-2.4-45.2l67-74.5c.8-2.9 1.6-5.7 2.5-8.8-1.6 5.4-4.4 10.1-8.1 13.8L9.4 489.4zM16 250.5L16 288c0 8.8 7.2 16 16 16s16-7.2 16-16l0-37.5c0-12.7 5.1-24.9 14.1-33.9l22.6-22.6c4.6-4.6 11.5-5.9 17.4-3.5s9.9 8.3 9.9 14.8l0 69.3c0 23.4 10.2 45.5 27.9 60.7l71.4 61.2c8.8 7.6 14.6 18.1 16.3 29.7l12.6 88.1c1.2 8.7 9.4 14.8 18.1 13.6s14.8-9.4 13.6-18.1l-12.6-88.1c-2.7-19.2-12.4-36.8-27.1-49.4l-34.5-29.6c-3.5-3-5.6-7.5-5.6-12.1l0-115.2c0-6.8 4.3-12.8 10.7-15.1s13.5-.2 17.8 5.1l3.8 4.7c15.2 19 38.2 30 62.5 30l33.2 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-33.2 0c-14.6 0-28.4-6.6-37.5-18l-17.9-22.4c-20-25-50.3-39.6-82.3-39.6-28 0-54.8 11.1-74.5 30.9L39.4 193.9c-15 15-23.4 35.4-23.4 56.6zM28.1 501.3c-5.9 6.6-5.4 16.7 1.2 22.6s16.7 5.4 22.6-1.2l72-80c1.6-1.8 2.8-4 3.5-6.3l8.7-30.6c-8.9-7.6-17.8-15.3-26.7-22.9l-10.7 37.6-1 3.6-2.5 2.7-67 74.5zM120 24a40 40 0 1 0 80 0 40 40 0 1 0 -80 0z", "M102.1 190.5c6 2.5 9.9 8.3 9.9 14.8l0 69.3c0 23.4 10.2 45.5 27.9 60.7l71.4 61.2c8.8 7.6 14.6 18.1 16.3 29.7l12.6 88.1c1.2 8.7 9.4 14.8 18.1 13.6s14.8-9.4 13.6-18.1l-12.6-88.1c-2.7-19.2-12.4-36.8-27.1-49.4l-34.5-29.6c-3.5-3-5.6-7.5-5.6-12.1l0-115.2c0-6.8 4.3-12.8 10.7-15.1s13.5-.2 17.8 5.1l3.8 4.7c15.2 19 38.2 30 62.5 30l33.2 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-33.2 0c-14.6 0-28.4-6.6-37.5-18l-17.9-22.4c-20-25-50.3-39.6-82.3-39.6-28 0-54.8 11.1-74.5 30.9L39.4 193.9c-15 15-23.4 35.4-23.4 56.6L16 288c0 8.8 7.2 16 16 16s16-7.2 16-16l0-37.5c0-12.7 5.1-24.9 14.1-33.9l22.6-22.6c4.6-4.6 11.5-5.9 17.4-3.5zM160 64a40 40 0 1 0 0-80 40 40 0 1 0 0 80zM80 221.3l-6.6 6.6c-6 6-9.4 14.1-9.4 22.6L64 288c0 17.7-14.3 32-32 32S0 305.7 0 288l0-37.5c0-25.5 10.1-49.9 28.1-67.9l35.1-35.1c22.8-22.8 53.6-35.6 85.8-35.6 36.9 0 71.8 16.8 94.8 45.6L261.8 180c6.1 7.6 15.3 12 25 12l33.2 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-33.2 0c-23.2 0-45.5-8.4-62.8-23.4-4.4-3.8-8.5-8-12.2-12.7l-3.8-4.7 0 115.2 34.5 29.6c17.7 15.2 29.3 36.2 32.6 59.3l12.6 88.1c2.5 17.5-9.7 33.7-27.2 36.2s-33.7-9.7-36.2-27.2l-12.6-88.1c-1.1-7.7-5-14.7-10.9-19.8l-71.4-61.2C108.2 329.2 96 302.6 96 274.6l0-69.3-16 16zM104 24a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zM96 371.4l13.4 11.5-10.7 37.6-1 3.6-2.5 2.7-67 74.5c-5.9 6.6-5.4 16.7 1.2 22.6s16.7 5.4 22.6-1.2l72-80c1.6-1.8 2.8-4 3.5-6.3l8.7-30.6 13.4 11.5-6.7 23.5c-1.3 4.7-3.7 9-7 12.6l-72 80c-11.8 13.1-32.1 14.2-45.2 2.4s-14.2-32.1-2.4-45.2l67-74.5 12.8-44.7zm405.6-37.8c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3L548.7 264 392 264c-4.4 0-8-3.6-8-8s3.6-8 8-8l156.7 0-58.3-58.3c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0l72 72c3.1 3.1 3.1 8.2 0 11.3l-72 72z"]],
    "spider-black-widow": [512, 512, [], "f718", ["M160 340c0 50.8 41.2 92 92 92l8 0 9.4-.5c46.4-4.7 82.6-43.9 82.6-91.5 0-33.5-18-62.9-44.9-78.9-2-1.2-3.4-3.2-3.8-5.5s.2-4.7 1.8-6.5c8.6-10.2 14-23.1 14.9-37.3l0-37.9-.2-4.4c-3.1-30.1-27-54.1-57.1-57.1L256 112c-35.3 0-64 28.7-64 64l0 32c0 15.6 5.6 29.9 14.9 41.1 1.5 1.8 2.1 4.2 1.8 6.5-.4 2.3-1.8 4.3-3.8 5.5-26.9 16.1-44.9 45.4-44.9 78.9zm48-38c0-7.7 6.3-14 14-14l68 0c7.7 0 14 6.3 14 14 0 2.3-.6 4.5-1.6 6.5l-1.2 1.9-19.2 25.6 19.2 25.6 1.2 1.9c1 2 1.6 4.2 1.6 6.5 0 7.7-6.3 14-14 14l-68 0c-7.7 0-14-6.3-14-14 0-3 1-6 2.8-8.4L230 336 210.8 310.4C209 308 208 305 208 302z", "M365.1-23.5c3.6-1.4 7.6 0 9.6 3.1l.7 1.4 56 144c1 2.7 .5 5.7-1.2 7.9l-88.6 109 124.1-32.7 22.6-67.9 .7-1.5c1.9-3.2 5.8-4.8 9.5-3.6 3.7 1.2 5.8 4.8 5.4 8.5l-.3 1.6-24 72c-.9 2.6-3 4.5-5.6 5.2L351.5 256 474.1 288.2c2.6 .7 4.7 2.7 5.6 5.2l24 72 .3 1.6c.4 3.7-1.8 7.3-5.4 8.5-3.7 1.2-7.6-.4-9.5-3.6l-.7-1.5-22.6-67.9-119.2-31.4 91.1 91.1c2.1 2.1 2.8 5.1 2 7.9l-48 160c-1.3 4.2-5.7 6.6-9.9 5.3-4.2-1.3-6.6-5.7-5.4-10l46.6-155.4-58.9-58.9c2.5 9.1 3.9 18.7 3.9 28.6 0 57.8-45.4 104.9-102.4 107.8l-5.6 .2-8 0c-59.6 0-108-48.4-108-108 0-9.9 1.4-19.5 3.9-28.6l-58.8 58.9 46.6 155.4c1.3 4.2-1.1 8.7-5.3 10-4.2 1.3-8.7-1.1-10-5.3l-48-160c-.8-2.8-.1-5.9 2-8l91-91.1-119.1 31.4-22.6 67.9-.7 1.5c-1.9 3.2-5.8 4.8-9.5 3.6-3.7-1.2-5.8-4.8-5.4-8.5l.3-1.6 24-72c.9-2.6 3-4.5 5.6-5.2L160.6 256 38 223.7c-2.6-.7-4.7-2.7-5.6-5.2l-24-72-.3-1.6c-.4-3.7 1.7-7.3 5.4-8.5 3.7-1.2 7.6 .4 9.5 3.6l.7 1.5 22.6 67.9 124.1 32.7-88.5-109c-1.8-2.2-2.3-5.3-1.3-7.9l56-144 .8-1.4c2-3.1 6-4.5 9.6-3.1s5.6 5.2 5 8.8l-.4 1.6-54.3 139.7 81 99.7c-1.4-5.8-2.1-12-2.1-18.2l0-32c0-44.2 35.8-80 80-80l8.2 .4c40.3 4.1 71.8 38.2 71.8 79.6l0 32c0 6.3-.8 12.4-2.2 18.3l81.1-99.7-54.3-139.7-.4-1.6c-.6-3.7 1.4-7.4 5-8.8zM256 112c-35.3 0-64 28.7-64 64l0 32c0 15.6 5.6 29.9 14.9 41.1 1.5 1.8 2.1 4.2 1.8 6.5-.4 2.3-1.8 4.3-3.8 5.5-26.9 16.1-44.9 45.4-44.9 78.9 0 50.8 41.2 92 92 92l8 0 9.4-.5c46.4-4.7 82.6-43.9 82.6-91.5 0-33.5-18-62.9-44.9-78.9-2-1.2-3.4-3.2-3.8-5.5s.2-4.7 1.8-6.5c9.3-11.1 15-25.4 15-41.1l0-32-.3-6.5c-3.1-30.1-27-54.1-57.1-57.1L256 112zm34 176c7.7 0 14 6.3 14 14 0 2.3-.6 4.5-1.6 6.5l-1.2 1.9-19.2 25.6 19.2 25.6 1.2 1.9c1 2 1.6 4.2 1.6 6.5 0 7.7-6.3 14-14 14l-68 0c-7.7 0-14-6.3-14-14 0-3 1-6 2.8-8.4L230 336 210.8 310.4c-1.8-2.4-2.8-5.4-2.8-8.4 0-7.7 6.3-14 14-14l68 0zm-43.6 43.2c2.1 2.8 2.1 6.8 0 9.6l-20.4 27.2 60 0-20.4-27.2c-2.1-2.8-2.1-6.8 0-9.6l20.4-27.2-60 0 20.4 27.2z"]],
    "glasses": [576, 512, [], "f530", ["M16 288l0 96c0 44.2 35.8 80 80 80l64 0c44.2 0 80-35.8 80-80l0-96c0-8.8-7.2-16-16-16L32 272c-8.8 0-16 7.2-16 16zm320 0l0 96c0 44.2 35.8 80 80 80l64 0c44.2 0 80-35.8 80-80l0-96c0-8.8-7.2-16-16-16l-192 0c-8.8 0-16 7.2-16 16z", "M120.3 48c-25 0-47 16.6-53.8 40.6l-48.3 169c-.2 .6-.3 1.2-.5 1.8 4.3-2.2 9.2-3.4 14.3-3.4l192 0c17.7 0 32 14.3 32 32l0 8 64 0 0-8c0-17.7 14.3-32 32-32l192 0c5.2 0 10 1.2 14.3 3.4-.2-.6-.3-1.2-.5-1.8l-48.3-169c-6.9-24-28.8-40.6-53.8-40.6L424 48c-4.4 0-8-3.6-8-8s3.6-8 8-8l31.7 0c32.1 0 60.4 21.3 69.2 52.2l48.3 169c1.8 6.4 2.8 13.1 2.8 19.8l0 111c0 53-43 96-96 96l-64 0c-53 0-96-43-96-96l0-72-64 0 0 72c0 53-43 96-96 96l-64 0c-53 0-96-43-96-96L0 273c0-6.7 .9-13.3 2.8-19.8L51 84.2C59.9 53.3 88.1 32 120.3 32L152 32c4.4 0 8 3.6 8 8s-3.6 8-8 8l-31.7 0zM560 288c0-8.8-7.2-16-16-16l-192 0c-8.8 0-16 7.2-16 16l0 96c0 44.2 35.8 80 80 80l64 0c44.2 0 80-35.8 80-80l0-96zM240 304l0-16c0-8.8-7.2-16-16-16L32 272c-8.8 0-16 7.2-16 16l0 96c0 44.2 35.8 80 80 80l64 0c44.2 0 80-35.8 80-80l0-80z"]],
    "circle-pause": [512, 512, [62092, "pause-circle"], "f28b", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zm176-88c0-4.4 3.6-8 8-8s8 3.6 8 8l0 176c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-176zm112 0c0-4.4 3.6-8 8-8s8 3.6 8 8l0 176c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-176z", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM208 168c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 176c0 4.4 3.6 8 8 8s8-3.6 8-8l0-176zm112 0c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 176c0 4.4 3.6 8 8 8s8-3.6 8-8l0-176z"]],
    "memory": [512, 512, [], "f538", ["M16 120l0 12.1C35.3 145 48 167 48 192s-12.7 47-32 59.9l0 52.1 480 0 0-52.1C476.7 239 464 217 464 192s12.7-47 32-59.9l0-12.1c0-22.1-17.9-40-40-40L56 80c-22.1 0-40 17.9-40 40zm0 200l0 96c0 8.8 7.2 16 16 16l64 0 0-40c0-4.4 3.6-8 8-8s8 3.6 8 8l0 40 88 0 0-40c0-4.4 3.6-8 8-8s8 3.6 8 8l0 40 80 0 0-40c0-4.4 3.6-8 8-8s8 3.6 8 8l0 40 88 0 0-40c0-4.4 3.6-8 8-8s8 3.6 8 8l0 40 64 0c8.8 0 16-7.2 16-16l0-96-480 0zM96 160c0-17.7 14.3-32 32-32s32 14.3 32 32l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64zm128 0c0-17.7 14.3-32 32-32s32 14.3 32 32l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64zm128 0c0-17.7 14.3-32 32-32s32 14.3 32 32l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64z", "M0 120C0 89.1 25.1 64 56 64l400 0c30.9 0 56 25.1 56 56l0 16.6c0 2.9-1.5 5.5-4 6.9-16.8 9.7-28 27.8-28 48.5s11.2 38.8 28 48.5c2.5 1.4 4 4.1 4 6.9L512 416c0 17.7-14.3 32-32 32L32 448c-17.7 0-32-14.3-32-32L0 247.4c0-2.9 1.5-5.5 4-6.9 16.8-9.7 28-27.8 28-48.5S20.8 153.2 4 143.5c-2.5-1.4-4-4.1-4-6.9L0 120zM416 392l0 40 64 0c8.8 0 16-7.2 16-16l0-96-480 0 0 96c0 8.8 7.2 16 16 16l64 0 0-40c0-4.4 3.6-8 8-8s8 3.6 8 8l0 40 88 0 0-40c0-4.4 3.6-8 8-8s8 3.6 8 8l0 40 80 0 0-40c0-4.4 3.6-8 8-8s8 3.6 8 8l0 40 88 0 0-40c0-4.4 3.6-8 8-8s8 3.6 8 8zm80-140.1C476.7 239 464 217 464 192s12.7-47 32-59.9l0-12.1c0-22.1-17.9-40-40-40L56 80c-22.1 0-40 17.9-40 40l0 12.1C35.3 145 48 167 48 192s-12.7 47-32 59.9l0 52.1 480 0 0-52.1zM128 144c-8.8 0-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16s16-7.2 16-16l0-64c0-8.8-7.2-16-16-16zm128 0c-8.8 0-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16s16-7.2 16-16l0-64c0-8.8-7.2-16-16-16zm128 0c-8.8 0-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16s16-7.2 16-16l0-64c0-8.8-7.2-16-16-16zM128 128c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32zm128 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32zm128 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32z"]],
    "gift": [512, 512, [127873], "f06b", ["M16 176l0 32c0 17.7 14.3 32 32 32l416 0c17.7 0 32-14.3 32-32l0-32c0-17.7-14.3-32-32-32L48 144c-17.7 0-32 14.3-32 32zm32 80l0 160c0 26.5 21.5 48 48 48l152 0 0-208-200 0zm216 0l0 208 152 0c26.5 0 48-21.5 48-48l0-160-200 0z", "M309.4 47.1c9.5-19.1 29.1-31.1 50.4-31.1 31 0 56.2 25.1 56.2 56 0 30.9-25.1 56-56 56l-91.1 0 40.4-80.9zm-106.8 0l40.4 80.9-91.1 0c-30.9 0-56-25.1-56-56 0-30.9 25.2-56 56.2-56 21.3 0 40.9 12.1 50.4 31.1zM80 72c0 22.6 10.4 42.8 26.7 56L48 128c-26.5 0-48 21.5-48 48l0 32c0 20.9 13.4 38.7 32 45.3L32 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-162.7c18.6-6.6 32-24.4 32-45.3l0-32c0-26.5-21.5-48-48-48l-58.7 0c16.3-13.2 26.7-33.4 26.7-56 0-39.8-32.4-72-72.2-72-27.4 0-52.5 15.5-64.8 40L256 118.1 216.9 40C204.7 15.5 179.5 0 152.2 0 112.4 0 80 32.2 80 72zM48 144l416 0c17.7 0 32 14.3 32 32l0 32c0 17.7-14.3 32-32 32L48 240c-17.7 0-32-14.3-32-32l0-32c0-17.7 14.3-32 32-32zm0 272l0-160 200 0 0 208-152 0c-26.5 0-48-21.5-48-48zm216 48l0-208 200 0 0 160c0 26.5-21.5 48-48 48l-152 0z"]],
    "sprinkler-ceiling": [384, 512, [], "e44c", ["M176 64l0 176 32 0 0-176c0-8.8-7.2-16-16-16s-16 7.2-16 16z", "M0 0L0 96c0 3.6 2.5 6.8 6 7.7L128 135.6 128 119 16 89.8 16 0 0 0zM256 119l0 16.5 122-31.8c3.5-.9 6-4.1 6-7.7l0-96-16 0 0 89.8-112 29.2zM192 48c8.8 0 16 7.2 16 16l0 176-32 0 0-176c0-8.8 7.2-16 16-16zm32 192l0-176c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 176-88 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l240 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-88 0zM144 352a16 16 0 1 0 0-32 16 16 0 1 0 0 32zM80 416c8.8 0 16-7.2 16-16s-7.2-16-16-16-16 7.2-16 16 7.2 16 16 16zm176-80a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm-64 80c8.8 0 16-7.2 16-16s-7.2-16-16-16-16 7.2-16 16 7.2 16 16 16zm-32 48c0-8.8-7.2-16-16-16s-16 7.2-16 16 7.2 16 16 16 16-7.2 16-16zm80 16c8.8 0 16-7.2 16-16s-7.2-16-16-16-16 7.2-16 16 7.2 16 16 16zm144-16c0-8.8-7.2-16-16-16s-16 7.2-16 16 7.2 16 16 16 16-7.2 16-16zm-80-48c8.8 0 16-7.2 16-16s-7.2-16-16-16-16 7.2-16 16 7.2 16 16 16zM32 464c0-8.8-7.2-16-16-16s-16 7.2-16 16 7.2 16 16 16 16-7.2 16-16z"]],
    "square-phone-hangup": [448, 512, ["phone-square-down"], "e27a", ["M16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96zM82.7 309.2c-16.7-29.2-14.5-72 19.3-94.1 73.9-48.5 170.2-48.5 244.2 0 33.8 22.1 36 64.9 19.3 94.1l-1.7 3c-6.2 10.8-19.3 15.3-30.8 10.6l-46.7-19.2c-10.1-4.2-16.2-14.4-15.2-25.3l1.1-11.4c-31.3-9.5-65-8.9-96 1.7l1 9.7c1.1 10.8-5.1 21.1-15.2 25.3l-46.7 19.2c-11.5 4.7-24.7 .2-30.8-10.6l-1.7-3z", "M64 48C37.5 48 16 69.5 16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM98.3 304.2c2.2 3.8 6.8 5.4 10.8 3.7l46.7-19.2c3.5-1.5 5.7-5.1 5.3-8.9l-1.6-15.9c-.4-3.6 1.7-7 5.1-8.3 38-14.7 80.3-15.4 118.7-2 3.5 1.2 5.7 4.7 5.3 8.4l-1.8 17.8c-.4 3.8 1.8 7.4 5.3 8.9l46.7 19.2c4 1.7 8.7 .1 10.8-3.7l1.7-3c13.7-24 10.7-56.5-14.1-72.8-68.6-45-158-45-226.6 0-24.9 16.3-27.8 48.8-14.1 72.8l1.7 3zm16.9 18.5c-11.5 4.7-24.7 .2-30.8-10.6l-1.7-3c-16.7-29.2-14.5-72 19.3-94.1 73.9-48.5 170.2-48.5 244.2 0 33.8 22.1 36 64.9 19.3 94.1l-1.7 3c-6.2 10.8-19.3 15.3-30.8 10.6l-46.7-19.2c-10.1-4.2-16.2-14.4-15.2-25.3l1.1-11.4c-31.3-9.5-65-8.9-96 1.7l1 9.7c1.1 10.8-5.1 21.1-15.2 25.3l-46.7 19.2z"]],
    "money-bill-wheat": [512, 512, [], "e52a", ["M16 304c0-17.7 14.3-32 32-32l24 0c0 30.9-25.1 56-56 56l0-24zm0 40c39.8 0 72-32.2 72-72l336 0c0 39.8 32.2 72 72 72l0 80c-39.8 0-72 32.2-72 72L88 496c0-39.8-32.2-72-72-72l0-80zm0 96c30.9 0 56 25.1 56 56l-24 0c-17.7 0-32-14.3-32-32l0-24zm176-56a64 64 0 1 0 128 0 64 64 0 1 0 -128 0zM440 272l24 0c17.7 0 32 14.3 32 32l0 24c-30.9 0-56-25.1-56-56zm0 224c0-30.9 25.1-56 56-56l0 24c0 17.7-14.3 32-32 32l-24 0z", "M218.3 16c-11.3-10-26.1-16-42.3-16 0 35.3 28.7 64 64 64 0-19.1-8.4-36.3-21.7-48zm112 0c-11.3-10-26.1-16-42.3-16 0 35.3 28.7 64 64 64 0-19.1-8.4-36.3-21.7-48zm112 0c-11.3-10-26.1-16-42.3-16 0 35.3 28.7 64 64 64 0-19.1-8.4-36.3-21.7-48zM352 128c-35.3 0-64 28.7-64 64 16.2 0 31-6 42.3-16 13.3-11.7 21.7-28.9 21.7-48zm-112 0c-35.3 0-64 28.7-64 64 16.2 0 31.1-6 42.3-16 13.3-11.7 21.7-28.9 21.7-48zm224 0c-35.3 0-64 28.7-64 64 16.2 0 31-6 42.3-16 13.3-11.7 21.7-28.9 21.7-48zM160 0c0-8.8 7.2-16 16-16 44.2 0 80 35.8 80 80 0 8.8-7.2 16-16 16-44.2 0-80-35.8-80-80zM272 0c0-8.8 7.2-16 16-16 44.2 0 80 35.8 80 80 0 8.8-7.2 16-16 16-44.2 0-80-35.8-80-80zM400-16c44.2 0 80 35.8 80 80 0 8.8-7.2 16-16 16-44.2 0-80-35.8-80-80 0-8.8 7.2-16 16-16zM368 128c0 44.2-35.8 80-80 80-8.8 0-16-7.2-16-16 0-44.2 35.8-80 80-80 8.8 0 16 7.2 16 16zM240 112c8.8 0 16 7.2 16 16 0 44.2-35.8 80-80 80-8.8 0-16-7.2-16-16 0-44.2 35.8-80 80-80zm240 16c0 44.2-35.8 80-80 80-8.8 0-16-7.2-16-16 0-44.2 35.8-80 80-80 8.8 0 16 7.2 16 16zM8 88l144 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L8 104c-4.4 0-8-3.6-8-8s3.6-8 8-8zM32 24c0-4.4 3.6-8 8-8l80 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L40 32c-4.4 0-8-3.6-8-8zm8 136l80 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-80 0c-4.4 0-8-3.6-8-8s3.6-8 8-8zM16 328c30.9 0 56-25.1 56-56l-24 0c-17.7 0-32 14.3-32 32l0 24zm0 16l0 80c39.8 0 72 32.2 72 72l336 0c0-39.8 32.2-72 72-72l0-80c-39.8 0-72-32.2-72-72L88 272c0 39.8-32.2 72-72 72zm424-72c0 30.9 25.1 56 56 56l0-24c0-17.7-14.3-32-32-32l-24 0zm56 168c-30.9 0-56 25.1-56 56l24 0c17.7 0 32-14.3 32-32l0-24zM72 496c0-30.9-25.1-56-56-56l0 24c0 17.7 14.3 32 32 32l24 0zm184-64a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm0-112a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM0 304c0-26.5 21.5-48 48-48l416 0c26.5 0 48 21.5 48 48l0 160c0 26.5-21.5 48-48 48L48 512c-26.5 0-48-21.5-48-48L0 304z"]],
    "circle-florin": [512, 512, [], "e6e4", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zM152 376c0-4.4 3.6-8 8-8l23.2 0c11.7 0 22.2-7.1 26.5-18l37.6-94-71.4 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l77.8 0 33.6-84c6.8-16.9 23.2-28 41.4-28l23.2 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-23.2 0c-11.7 0-22.2 7.1-26.5 18l-31.2 78 65 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-71.4 0-40 100c-6.8 16.9-23.2 28-41.4 28L160 384c-4.4 0-8-3.6-8-8z", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm31.4-356l-33.6 84-77.8 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l71.4 0-37.6 94c-4.3 10.8-14.8 18-26.5 18L160 368c-4.4 0-8 3.6-8 8s3.6 8 8 8l23.2 0c18.2 0 34.6-11.1 41.4-28l40-100 71.4 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-65 0 31.2-78c4.3-10.8 14.8-18 26.5-18l23.2 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-23.2 0c-18.2 0-34.6 11.1-41.4 28z"]],
    "dungeon": [512, 512, [], "f6d9", ["M16 256l0 16 96 0 0-16c0-20.3 4.2-39.6 11.8-57.2l-86-43C23.8 186.3 16 220.3 16 256zm0 32l0 96 96 0 0-96-96 0zm0 112l0 64c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-64-96 0zM45 141.6l86 43c14.9-26.1 37.8-47.1 65.4-59.6L142.7 44.4c-41.3 22.2-75.3 56-97.7 97.2zM157.1 37.3L211.6 119c14-4.5 28.9-7 44.4-7s30.4 2.4 44.4 7l54.5-81.7C324.7 23.6 291.3 16 256 16s-68.7 7.6-98.9 21.3zm158.6 87.7c27.5 12.6 50.4 33.5 65.4 59.6l86-43c-22.4-41.1-56.4-75-97.7-97.2l-53.7 80.5zm72.5 73.9c7.6 17.5 11.8 36.9 11.8 57.2l0 16 96 0 0-16c0-35.7-7.8-69.7-21.8-100.1l-86 43zM400 288l0 96 96 0 0-96-96 0zm0 112l0 64c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-64-96 0z", "M211.6 119L157.1 37.3C187.3 23.6 220.7 16 256 16s68.7 7.6 98.9 21.3L300.4 119c-14-4.5-28.9-7-44.4-7s-30.4 2.4-44.4 7zm-15.3 5.9c-27.5 12.6-50.4 33.5-65.4 59.6l-86-43c22.4-41.1 56.4-75 97.7-97.2l53.7 80.5zm-72.5 73.9C116.2 216.4 112 235.7 112 256l0 16-96 0 0-16c0-35.7 7.8-69.7 21.8-100.1l86 43zM112 288l0 96-96 0 0-96 96 0zm0 112l0 64c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-64 96 0zM369.3 44.4c41.3 22.2 75.3 56 97.7 97.2l-86 43c-15-26.1-37.8-47.1-65.4-59.6l53.7-80.5zM474.2 155.9c14 30.5 21.8 64.4 21.8 100.1l0 16-96 0 0-16c0-20.3-4.2-39.6-11.8-57.2l86-43zM496 288l0 96-96 0 0-96 96 0zm0 112l0 64c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-64 96 0zM128 256c0-70.7 57.3-128 128-128s128 57.3 128 128l0 208c0 26.5 21.5 48 48 48l32 0c26.5 0 48-21.5 48-48l0-208C512 114.6 397.4 0 256 0S0 114.6 0 256L0 464c0 26.5 21.5 48 48 48l32 0c26.5 0 48-21.5 48-48l0-208zm128-72c-4.4 0-8 3.6-8 8l0 312c0 4.4 3.6 8 8 8s8-3.6 8-8l0-312c0-4.4-3.6-8-8-8zm-64 32c-4.4 0-8 3.6-8 8l0 280c0 4.4 3.6 8 8 8s8-3.6 8-8l0-280c0-4.4-3.6-8-8-8zm128 0c-4.4 0-8 3.6-8 8l0 280c0 4.4 3.6 8 8 8s8-3.6 8-8l0-280c0-4.4-3.6-8-8-8z"]],
    "comet": [512, 512, [], "e003", ["M16 313.1c0 100.5 81.5 182.9 181.9 182.9 58.9 0 114.2-28.5 148.3-76.6L487.5 220.6c3.8-5.3 0-12.6-6.5-12.6l-47.4 0c-2.7 0-5.2-1.4-6.7-3.6s-1.7-5.1-.6-7.6L494.6 41.4c.9-2 1.4-4.2 1.4-6.4l0-3c0-8.8-7.2-16-16-16l-3 0c-2.2 0-4.4 .5-6.4 1.4L315.2 85.7c-2.5 1.1-5.3 .9-7.6-.6s-3.6-4-3.6-6.7l0-54.7c0-6.6-7.5-10.3-12.7-6.4L90.6 165.1C43.7 199.6 16 254.9 16 313.1zm70.3-40.7c1.9-5.8 6.9-10 12.9-10.9l65.3-9.5 29.2-59.2c2.7-5.5 8.3-8.9 14.3-8.9s11.7 3.5 14.3 8.9l29.2 59.2 65.3 9.5c6 .9 11 5.1 12.9 10.9s.3 12.2-4 16.4l-47.2 46 11.2 65c1 6-1.4 12.1-6.4 15.7s-11.5 4.1-16.8 1.2l-58.4-30.7-58.4 30.7c-5.4 2.8-11.9 2.4-16.8-1.2s-7.4-9.6-6.4-15.7l11.2-65-47.2-46c-4.4-4.3-5.9-10.6-4-16.4z", "M320 23.7c0-19.7-22.4-31-38.2-19.3 4.7 6.4 4.7 6.4 0 0L81.1 152.2C30.1 189.8 0 249.8 0 313.1 0 422.4 88.6 512 197.9 512 262.1 512 322.2 481 359.3 428.7L500.6 229.9C511.9 214 500.5 192 481 192l-35.1 0 63.4-144.2c1.8-4.1 2.7-8.5 2.7-12.9l0-3c0-17.7-14.3-32-32-32l-3 0c-4.4 0-8.8 .9-12.9 2.7l0 0-144.2 63.4 0-42.5zm-28.7-6.4c5.3-3.9 12.7-.1 12.7 6.4l0 54.7c0 2.7 1.4 5.2 3.6 6.7s5.1 1.7 7.6 .6L470.6 17.4c2-.9 4.2-1.4 6.4-1.4l3 0c8.8 0 16 7.2 16 16l0 3c0 2.2-.5 4.4-1.4 6.4L426.3 196.8c-1.1 2.5-.9 5.3 .6 7.6s4 3.6 6.7 3.6l47.4 0c6.5 0 10.3 7.3 6.5 12.6L346.3 419.4c-34.1 48-89.4 76.6-148.3 76.6-100.4 0-181.9-82.3-181.9-182.9 0-58.3 27.7-113.5 74.6-148L291.3 17.2zM166.8 267.9c5.2-.8 9.7-4 12-8.8L208 200 237.2 259.2c2.3 4.7 6.8 8 12 8.8l65.3 9.5-47.2 46c-3.8 3.7-5.5 9-4.6 14.2l11.2 65-58.4-30.7c-4.7-2.5-10.2-2.5-14.9 0l-58.4 30.7 11.2-65c.9-5.2-.8-10.5-4.6-14.2l-47.2-46 65.3-9.5zm55.6-75c-2.7-5.5-8.3-8.9-14.3-8.9s-11.7 3.5-14.3 8.9l-29.2 59.2-65.3 9.5c-6 .9-11 5.1-12.9 10.9s-.3 12.2 4 16.4l47.2 46-11.2 65c-1 6 1.4 12.1 6.4 15.7s11.5 4.1 16.8 1.2l58.4-30.7 58.4 30.7c5.4 2.8 11.9 2.4 16.8-1.2s7.4-9.6 6.4-15.7l-11.2-65 47.2-46c4.4-4.3 5.9-10.6 4-16.4s-6.9-10-12.9-10.9l-65.3-9.5-29.2-59.2z"]],
    "face-holding-back-tears": [512, 512, [129401], "e482", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zm64.2-70.3c-1-4.3 1.8-8.6 6.1-9.5l8.5-1.9c37-8.2 67.3-34.6 80.6-70l1.2-3.1c1.6-4.1 6.2-6.2 10.3-4.7s6.2 6.2 4.7 10.3l-1.2 3.1c-7.3 19.5-19.2 36.6-34.2 50.2 1.3-.1 2.6-.1 3.9-.1 44.2 0 80 35.8 80 80 0 12.5-2.9 24.4-8 34.9l0 29.1c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-6.9c-14.4 14.1-34.2 22.9-56 22.9-18 0-34.6-6-48-16l0 16c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-32c-10-13.4-16-30-16-48 0-18.9 6.5-36.2 17.5-49.9l-7.7 1.7c-4.3 1-8.6-1.8-9.5-6.1zm48.1 50.1c-.2 1.4-.3 2.7-.3 4.1 0 17.7 14.3 32 32 32s32-14.3 32-32c0-12-6.6-22.4-16.3-27.9-2 15.7-15.5 27.9-31.7 27.9-5.7 0-11.1-1.5-15.7-4.1zm36.6 149.9c-2.7-3.5-2.1-8.5 1.3-11.2s8.5-2.1 11.2 1.3C195.8 399.1 224.1 414 256 414s60.2-14.9 78.6-38.1c2.7-3.5 7.8-4.1 11.2-1.3s4.1 7.8 1.3 11.2C325.9 412.7 293 430 256 430s-69.9-17.3-91.1-44.2zM272 240c0-44.2 35.8-80 80-80 1.3 0 2.6 0 3.9 .1-15-13.5-26.9-30.6-34.2-50.2l-1.2-3.1c-1.6-4.1 .5-8.7 4.7-10.3s8.7 .5 10.3 4.7l1.2 3.1c13.3 35.5 43.6 61.8 80.6 70l8.5 1.9c4.3 1 7 5.2 6.1 9.5s-5.2 7-9.5 6.1l-7.7-1.7c10.9 13.7 17.5 31 17.5 49.9 0 18-6 34.6-16 48l0 32c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-16c-13.4 10-30 16-48 16-44.2 0-80-35.8-80-80zm48.3-4.1c-.2 1.4-.3 2.7-.3 4.1 0 17.7 14.3 32 32 32s32-14.3 32-32c0-12-6.6-22.4-16.3-27.9-2 15.7-15.5 27.9-31.7 27.9-5.7 0-11.1-1.5-15.7-4.1z", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM325.2 96.5c-4.1 1.6-6.2 6.2-4.7 10.3l1.2 3.1c7.3 19.5 19.2 36.6 34.2 50.2-1.3-.1-2.6-.1-3.9-.1-44.2 0-80 35.8-80 80s35.8 80 80 80c18 0 34.6-6 48-16l0 16c0 4.4 3.6 8 8 8s8-3.6 8-8l0-32c10-13.4 16-30 16-48 0-18.9-6.5-36.2-17.5-49.9l7.7 1.7c4.3 1 8.6-1.8 9.5-6.1s-1.8-8.6-6.1-9.5l-8.5-1.9c-37-8.2-67.3-34.6-80.6-70l-1.2-3.1c-1.6-4.1-6.2-6.2-10.3-4.7zM191.5 106.8c1.6-4.1-.5-8.7-4.7-10.3s-8.7 .5-10.3 4.7l-1.2 3.1c-13.3 35.5-43.6 61.8-80.6 70l-8.5 1.9c-4.3 1-7 5.2-6.1 9.5s5.2 7 9.5 6.1l7.7-1.7c-10.9 13.7-17.5 31-17.5 49.9 0 18 6 34.6 16 48l0 32c0 4.4 3.6 8 8 8s8-3.6 8-8l0-16c13.4 10 30 16 48 16 21.8 0 41.6-8.7 56-22.9l0 6.9c0 4.4 3.6 8 8 8s8-3.6 8-8l0-29.1c5.1-10.6 8-22.4 8-34.9 0-44.2-35.8-80-80-80-1.3 0-2.6 0-3.9 .1 15-13.5 26.9-30.6 34.2-50.2l1.2-3.1zM160 176a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm128 64a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zM160 272c-17.7 0-32-14.3-32-32 0-1.4 .1-2.8 .3-4.1 4.6 2.6 10 4.1 15.7 4.1 16.3 0 29.7-12.1 31.7-27.9 9.7 5.5 16.3 15.9 16.3 27.9 0 17.7-14.3 32-32 32zm-44.6-49.7c-2.2 5.5-3.4 11.4-3.4 17.7 0 26.5 21.5 48 48 48s48-21.5 48-48c0-22.1-15-40.8-35.4-46.3-4-1.1-8.3-1.7-12.6-1.7-3.5 0-6.9 .4-10.2 1.1 5.9 2.3 10.1 8.1 10.2 14.8l0 .1c0 8.8-7.2 16-16 16-3.6 0-6.9-1.2-9.6-3.2-3.9-2.9-6.4-7.6-6.4-12.8 0-1.5 .2-2.9 .6-4.3-1.5 1.3-3 2.8-4.4 4.3-3.7 4.2-6.8 9-8.9 14.3zM384 240c0 17.7-14.3 32-32 32s-32-14.3-32-32c0-1.4 .1-2.8 .3-4.1 4.6 2.6 10 4.1 15.7 4.1 16.3 0 29.7-12.1 31.7-27.9 9.7 5.5 16.3 15.9 16.3 27.9zm-80 0c0 26.5 21.5 48 48 48s48-21.5 48-48c0-22.1-15-40.8-35.4-46.3-4-1.1-8.3-1.7-12.6-1.7-3.5 0-6.9 .4-10.2 1.1 6 2.3 10.2 8.1 10.2 14.9 0 8.8-7.2 16-16 16-3.6 0-6.9-1.2-9.6-3.2-3.9-2.9-6.4-7.6-6.4-12.8 0-1.5 .2-2.9 .6-4.3-1.5 1.3-3 2.8-4.4 4.3-7.4 8.3-12.2 19.4-12.2 32zm41.8 134.6c-3.5-2.7-8.5-2.1-11.2 1.3-18.3 23.2-46.7 38.1-78.6 38.1s-60.2-14.9-78.6-38.1c-2.7-3.5-7.8-4.1-11.2-1.3s-4.1 7.8-1.3 11.2C186.1 412.7 219 430 256 430s69.9-17.3 91.1-44.2c2.7-3.5 2.1-8.5-1.3-11.2z"]],
    "card-heart": [384, 512, [], "e3eb", ["M16 64l0 384c0 26.5 21.5 48 48 48l256 0c26.5 0 48-21.5 48-48l0-384c0-26.5-21.5-48-48-48L64 16C37.5 16 16 37.5 16 64zM80 221.3c0-33.9 27.5-61.3 61.3-61.3 19.3 0 37.5 9.1 49.1 24.5l1.6 2.1 1.6-2.1c11.6-15.4 29.8-24.5 49.1-24.5 33.9 0 61.3 27.5 61.3 61.3l0 2.7c0 32-22.8 60.8-45.8 82.1-23.4 21.6-49.1 37.3-58.5 42.7-4.8 2.8-10.6 2.8-15.4 0-9.5-5.5-35.1-21.1-58.5-42.7-23-21.3-45.8-50.1-45.8-82.1l0-2.7zm23.7 31.9c7.4 14.6 19.4 28.6 33 41.2 4.9 4.5 9.9 8.8 14.8 12.7l-45.8-51.2c-.6-.8-1.2-1.6-2-2.7zM236 304.3c3.8-3.1 7.6-6.4 11.4-9.9 11.2-10.4 21.3-21.7 28.7-33.5l-40 43.4z", "M64 16C37.5 16 16 37.5 16 64l0 384c0 26.5 21.5 48 48 48l256 0c26.5 0 48-21.5 48-48l0-384c0-26.5-21.5-48-48-48L64 16zM0 64C0 28.7 28.7 0 64 0L320 0c35.3 0 64 28.7 64 64l0 384c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zM96 221.3l0 2.7c0 24.8 18.1 49.5 40.6 70.4 21.9 20.2 46.1 35.1 55.4 40.5 9.3-5.4 33.5-20.2 55.4-40.5 22.5-20.8 40.6-45.6 40.6-70.4l0-2.7c0-25-20.3-45.3-45.3-45.3-14.3 0-27.7 6.7-36.3 18.1l-8 10.7c-1.5 2-3.9 3.2-6.4 3.2s-4.9-1.2-6.4-3.2l-8-10.7c-8.6-11.4-22-18.1-36.3-18.1-25 0-45.3 20.3-45.3 45.3zM141.3 160c19.3 0 37.5 9.1 49.1 24.5l1.6 2.1 1.6-2.1c11.6-15.4 29.8-24.5 49.1-24.5 33.9 0 61.3 27.5 61.3 61.3l0 2.7c0 32-22.8 60.8-45.8 82.1-23.4 21.6-49.1 37.3-58.5 42.7-4.8 2.8-10.6 2.8-15.4 0-9.5-5.5-35.1-21.1-58.5-42.7-23-21.3-45.8-50.1-45.8-82.1l0-2.7c0-33.9 27.5-61.3 61.3-61.3z"]],
    "car-mirrors": [576, 512, [], "e343", ["M16 176c0 8.8 7.2 16 16 16l42.6 0 12.8-32-55.4 0c-8.8 0-16 7.2-16 16zm32 80l0 128 480 0 0-128c0-26.5-21.5-48-48-48L96 208c-26.5 0-48 21.5-48 48zm112 32a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm320 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm8.6-128l12.8 32 42.6 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-55.4 0z", "M131.3 93.3L91.8 192.1c1.4-.1 2.8-.1 4.2-.1l384 0c1.4 0 2.8 0 4.2 .1L444.7 93.3C433.8 65.9 407.3 48 377.8 48L198.2 48c-29.4 0-55.9 17.9-66.9 45.3zM93.8 144l22.7-56.7C129.8 53.9 162.2 32 198.2 32l179.7 0c36 0 68.3 21.9 81.7 55.3l22.7 56.7 61.8 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-21.7 0c13.3 11.7 21.7 28.9 21.7 48l0 192c0 17.7-14.3 32-32 32l-16 0c-17.7 0-32-14.3-32-32l0-48-352 0 0 48c0 17.7-14.3 32-32 32l-16 0c-17.7 0-32-14.3-32-32l0-192c0-19.1 8.4-36.3 21.7-48L32 208c-17.7 0-32-14.3-32-32s14.3-32 32-32l61.8 0zm-6.4 16L32 160c-8.8 0-16 7.2-16 16s7.2 16 16 16l42.6 0 12.8-32zM544 192c8.8 0 16-7.2 16-16s-7.2-16-16-16l-55.4 0 12.8 32 42.6 0zM96 208c-26.5 0-48 21.5-48 48l0 128 480 0 0-128c0-26.5-21.5-48-48-48L96 208zM480 400l0 48c0 8.8 7.2 16 16 16l16 0c8.8 0 16-7.2 16-16l0-48-48 0zM48 400l0 48c0 8.8 7.2 16 16 16l16 0c8.8 0 16-7.2 16-16l0-48-48 0zm96-112a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm-48 0a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm352 16a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm0-48a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]],
    "suitcase-medical": [512, 512, ["medkit"], "f0fa", ["M16 160l0 256c0 26.5 21.5 48 48 48l32 0 0-352-32 0c-26.5 0-48 21.5-48 48zm96-48l0 352 288 0 0-352-288 0zm48 160c0-13.3 10.7-24 24-24l32 0 0-32c0-13.3 10.7-24 24-24l32 0c13.3 0 24 10.7 24 24l0 32 32 0c13.3 0 24 10.7 24 24l0 32c0 13.3-10.7 24-24 24l-32 0 0 32c0 13.3-10.7 24-24 24l-32 0c-13.3 0-24-10.7-24-24l0-32-32 0c-13.3 0-24-10.7-24-24l0-32zM416 112l0 352 32 0c26.5 0 48-21.5 48-48l0-256c0-26.5-21.5-48-48-48l-32 0z", "M176 40l0 56 160 0 0-56c0-13.3-10.7-24-24-24L200 16c-13.3 0-24 10.7-24 24zM160 96l0-56c0-22.1 17.9-40 40-40L312 0c22.1 0 40 17.9 40 40l0 56 96 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 160c0-35.3 28.7-64 64-64l96 0zm184 16l-232 0 0 352 288 0 0-352-56 0zm72 0l0 352 32 0c26.5 0 48-21.5 48-48l0-256c0-26.5-21.5-48-48-48l-32 0zM96 464l0-352-32 0c-26.5 0-48 21.5-48 48l0 256c0 26.5 21.5 48 48 48l32 0zM240 208c-4.4 0-8 3.6-8 8l0 40c0 2.1-.8 4.2-2.3 5.7s-3.5 2.3-5.7 2.3l-40 0c-4.4 0-8 3.6-8 8l0 32c0 4.4 3.6 8 8 8l40 0c4.4 0 8 3.6 8 8l0 40c0 4.4 3.6 8 8 8l32 0c4.4 0 8-3.6 8-8l0-40c0-4.4 3.6-8 8-8l40 0c4.4 0 8-3.6 8-8l0-32c0-4.4-3.6-8-8-8l-40 0c-4.4 0-8-3.6-8-8l0-40c0-4.4-3.6-8-8-8l-32 0zm-24 8c0-13.3 10.7-24 24-24l32 0c13.3 0 24 10.7 24 24l0 32 32 0c13.3 0 24 10.7 24 24l0 32c0 13.3-10.7 24-24 24l-32 0 0 32c0 13.3-10.7 24-24 24l-32 0c-13.3 0-24-10.7-24-24l0-32-32 0c-13.3 0-24-10.7-24-24l0-32c0-13.3 10.7-24 24-24l32 0 0-32z"]],
    "block-quote": [448, 512, [], "e0b5", ["", "M8 64c-4.4 0-8 3.6-8 8s3.6 8 8 8l432 0c4.4 0 8-3.6 8-8s-3.6-8-8-8L8 64zM136 248c-4.4 0-8 3.6-8 8s3.6 8 8 8l304 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-304 0zm-8 192c0 4.4 3.6 8 8 8l304 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-304 0c-4.4 0-8 3.6-8 8zM0 440c0 4.4 3.6 8 8 8s8-3.6 8-8l0-208c0-4.4-3.6-8-8-8s-8 3.6-8 8L0 440z"]],
    "hands-holding-heart": [640, 512, ["hands-heart"], "f4c3", ["M16 112c0-17.7 14.3-32 32-32s32 14.3 32 32l0 147c0 20.7 8.2 40.6 22.9 55.2 7 7 32.1 32.1 75.5 75.5 2.7 2.7 5.3 5.3 8 8 3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-8-8c-18.6-18.6-37.3-37.3-55.9-55.9-10.6-10.6-11.3-27.7-1.5-39.1 10.9-12.7 30.3-13.5 42.2-1.6l92.8 92.7c13.3 13.3 20.8 31.4 20.8 50.3l0 79.2c0 4.4 3.6 8 8 8l-168 0c2.1 0 4.1-.8 5.7-2.3 3.1-3.1 3.1-8.2 0-11.3L41.8 406.5C25.3 390 16 367.6 16 344.2L16 112zM344 512c4.4 0 8-3.6 8-8l0-79.2c0-18.9 7.5-37 20.8-50.3l92.8-92.7c11.8-11.8 31.3-11.1 42.2 1.6 9.8 11.4 9.1 28.4-1.5 39.1-18.7 18.7-37.3 37.3-55.9 55.9-2.7 2.7-5.3 5.3-8 8-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l8-8c43.3-43.3 68.5-68.5 75.5-75.5 14.6-14.6 22.9-34.5 22.9-55.2l0-147c0-17.7 14.3-32 32-32s32 14.3 32 32l0 232.2c0 23.3-9.3 45.7-25.8 62.2l-91.9 91.9c-3.1 3.1-3.1 8.2 0 11.3 1.6 1.6 3.6 2.3 5.6 2.3l-168 0z", "M341.4 40.4c11.1-15.3 28.8-24.4 47.7-24.4 32.5 0 58.9 26.4 58.9 58.9 0 32.1-19.8 61.1-42.1 86.5-24.5 27.8-54 51.8-73.8 66.5-7.3 5.5-17 5.5-24.4 0-19.7-14.7-49.3-38.6-73.8-66.5-22.3-25.3-42-54.4-42-86.5 0-32.5 26.4-58.9 58.9-58.9 18.9 0 36.6 9.1 47.7 24.4L313.5 61c1.5 2.1 3.9 3.3 6.5 3.3s5-1.2 6.5-3.3l14.9-20.6zM389.1 0c-24 0-46.6 11.5-60.7 31L320 42.7 311.6 31c-14.1-19.5-36.7-31-60.7-31-41.4 0-74.9 33.5-74.9 74.9 0 38.4 23.5 71.4 46 97 25.5 29 56.1 53.8 76.2 68.7 13 9.7 30.5 9.7 43.5 0 20.1-15 50.7-39.7 76.2-68.7 22.5-25.6 46-58.6 46-97 0-41.4-33.5-74.9-74.9-74.9zM96 112c0-26.5-21.5-48-48-48S0 85.5 0 112L0 344.2c0 27.6 11 54 30.5 73.5l91.9 91.9c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3L41.8 406.5C25.3 390 16 367.6 16 344.2L16 112c0-17.7 14.3-32 32-32s32 14.3 32 32l0 147c0 20.7 8.2 40.6 22.9 55.2 7 7 32.1 32.1 75.5 75.5l0 0 8 8c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-8-8 0 0-55.9-55.9 0 0c-10.6-10.6-11.3-27.6-1.5-39.1 10.9-12.7 30.3-13.5 42.2-1.6l92.8 92.7c13.3 13.3 20.8 31.4 20.8 50.3l0 79.2c0 4.4 3.6 8 8 8s8-3.6 8-8l0-79.2c0-23.1-9.2-45.3-25.5-61.6l-92.8-92.8c-18.4-18.4-48.7-17.3-65.6 2.5-6.2 7.2-9.7 15.9-10.6 24.7-8.7-10.9-13.5-24.6-13.5-38.7l0-147zM592 64c-26.5 0-48 21.5-48 48l0 147c0 14.1-4.8 27.8-13.5 38.7-.9-8.8-4.4-17.5-10.6-24.7-17-19.8-47.2-21-65.6-2.5l-92.7 92.8c-16.3 16.3-25.5 38.5-25.5 61.6l0 79.2c0 4.4 3.6 8 8 8s8-3.6 8-8l0-79.2c0-18.9 7.5-37 20.8-50.3l92.8-92.7c11.8-11.8 31.3-11.1 42.2 1.6 9.8 11.4 9.1 28.4-1.5 39.1l0 0-55.9 55.9 0 0-8 8c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l8-8c43.3-43.3 68.5-68.5 75.5-75.5 14.6-14.6 22.9-34.5 22.9-55.2l0-147c0-17.7 14.3-32 32-32s32 14.3 32 32l0 232.2c0 23.3-9.3 45.7-25.8 62.2l-91.9 91.9c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l91.9-91.9c19.5-19.5 30.5-46 30.5-73.5L640 112c0-26.5-21.5-48-48-48z"]],
    "arrow-up-small-big": [512, 512, ["sort-size-up-alt"], "f88f", ["M304 80c0-17.7 14.3-32 32-32l64 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-64zm0 224c0-17.7 14.3-32 32-32l128 0c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32l-128 0c-17.7 0-32-14.3-32-32l0-128z", "M133.7 34.3c-3.1-3.1-8.2-3.1-11.3 0l-104 104c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L120 59.3 120 472c0 4.4 3.6 8 8 8s8-3.6 8-8l0-412.7 90.3 90.3c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-104-104zM304 80c0-17.7 14.3-32 32-32l64 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-64zm-16 0l0 64c0 26.5 21.5 48 48 48l64 0c26.5 0 48-21.5 48-48l0-64c0-26.5-21.5-48-48-48l-64 0c-26.5 0-48 21.5-48 48zm16 224c0-17.7 14.3-32 32-32l128 0c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32l-128 0c-17.7 0-32-14.3-32-32l0-128zm-16 0l0 128c0 26.5 21.5 48 48 48l128 0c26.5 0 48-21.5 48-48l0-128c0-26.5-21.5-48-48-48l-128 0c-26.5 0-48 21.5-48 48z"]],
    "sliders-simple": [512, 512, [], "e253", ["M16 368a64 64 0 1 0 128 0 64 64 0 1 0 -128 0zM368 144a64 64 0 1 0 128 0 64 64 0 1 0 -128 0z", "M80 432a64 64 0 1 1 0-128 64 64 0 1 1 0 128zm79.6-72c-4-40.4-38.1-72-79.6-72-44.2 0-80 35.8-80 80s35.8 80 80 80c41.5 0 75.6-31.6 79.6-72L504 376c4.4 0 8-3.6 8-8s-3.6-8-8-8l-344.4 0zM496 144a64 64 0 1 1 -128 0 64 64 0 1 1 128 0zm-143.6-8L8 136c-4.4 0-8 3.6-8 8s3.6 8 8 8l344.4 0c4 40.4 38.1 72 79.6 72 44.2 0 80-35.8 80-80s-35.8-80-80-80c-41.5 0-75.6 31.6-79.6 72z"]],
    "person-cane": [448, 512, [], "e53c", ["M46.3 260.9c-10.5 14.2-7.6 34.2 6.6 44.8 6.9 5.1 15.1 7 23 6.1-4.9-.6-9.6-2.4-14-5.3-14.6-10-18.3-29.9-8.4-44.5l64.1-93.8c21.3-31.2 55.1-51.2 92.1-55.4-36.9 3.9-70.7 23.1-93 53.2l-70.5 95zm20.5 10c-5 7.3-3.1 17.3 4.2 22.2s17.3 3.1 22.2-4.2l52.2-76.4c2-2.9 5.6-4.2 9-3.1s5.6 4.1 5.6 7.6L160 512c0 8.8 7.2 16 16 16s16-7.2 16-16l0-144c0-17.3 13.7-31.4 30.8-32 .8-.1 1.6-.1 2.3 0 17.2 .6 30.9 14.7 30.9 32l0 144c0 8.8 7.2 16 16 16s16-7.2 16-16l0-294.8c0-3.5 2.3-6.6 5.6-7.6s7 .2 9 3.1L354.8 289c5 7.3 14.9 9.2 22.2 4.2s9.2-14.9 4.2-22.2l-64.1-93.8c-21-30.8-55.9-49.1-93.1-49.1s-72.1 18.4-93.1 49.1L66.8 271zM192 24a40 40 0 1 0 80 0 40 40 0 1 0 -80 0zm46.2 88.8c37.1 4.1 70.8 24.2 92.1 55.4l64.1 93.8c10 14.6 6.2 34.5-8.4 44.5-4.3 3-9.1 4.7-14 5.3 7.9 1 16.1-1 23-6.1 14.2-10.5 17.2-30.6 6.6-44.8l-70.5-95c-22.3-30.1-56.2-49.3-93-53.2z", "M272 24a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zm-96 0a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm48 104c-37.2 0-72.1 18.4-93.1 49.1L66.8 271c-5 7.3-3.1 17.3 4.2 22.2s17.3 3.1 22.2-4.2l52.2-76.4c2-2.9 5.6-4.2 9-3.1s5.6 4.1 5.6 7.6L160 512c0 8.8 7.2 16 16 16s16-7.2 16-16l0-144c0-17.7 14.3-32 32-32s32 14.3 32 32l0 144c0 8.8 7.2 16 16 16s16-7.2 16-16l0-294.8c0-3.5 2.3-6.6 5.6-7.6s7 .2 9 3.1L354.8 289c5 7.3 14.9 9.2 22.2 4.2s9.2-14.9 4.2-22.2l-64.1-93.8c-21-30.8-55.9-49.1-93.1-49.1zM117.7 168.1C141.7 133 181.5 112 224 112s82.3 21 106.3 56.1l64.1 93.8c10 14.6 6.2 34.5-8.4 44.5s-34.5 6.2-44.5-8.4l-37.6-55 0 268.9c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-144c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 144c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-268.9-37.6 55c-10 14.6-29.9 18.3-44.5 8.4s-18.3-29.9-8.4-44.5l64.1-93.8zM408 352c-13.3 0-24 10.7-24 24l0 16c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-16c0-22.1 17.9-40 40-40s40 17.9 40 40l0 160c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-160c0-13.3-10.7-24-24-24z"]],
    "message-music": [512, 512, ["comment-alt-music"], "f8af", ["M16 128l0 224c0 44.2 35.8 80 80 80l32 0c8.8 0 16 7.2 16 16l0 75.9c0 2.3 2 4 4.1 4.1 .8 0 1.7-.2 2.4-.7 3.3-2.3 6.3-4.5 9.1-6.4l.4-.3c6.7-4.7 30.4-21.5 117.2-82.7 5.4-3.8 11.8-5.9 18.5-5.9L416 432c44.2 0 80-35.8 80-80l0-224c0-44.2-35.8-80-80-80L96 48c-44.2 0-80 35.8-80 80z", "M144 448l0 75.9c0 2.3 2 4 4.1 4.1 .8 0 1.7-.2 2.4-.7 3.3-2.3 6.3-4.5 9.1-6.4l.4-.3c6.7-4.7 30.4-21.5 117.2-82.7 5.4-3.8 11.8-5.9 18.5-5.9L416 432c44.2 0 80-35.8 80-80l0-224c0-44.2-35.8-80-80-80L96 48c-44.2 0-80 35.8-80 80l0 224c0 44.2 35.8 80 80 80l32 0c8.8 0 16 7.2 16 16zM0 128C0 75 43 32 96 32l320 0c53 0 96 43 96 96l0 224c0 53-43 96-96 96l-120.4 0c-3.3 0-6.5 1-9.2 2.9L159.8 540.3c-3.4 2.4-7.5 3.7-11.6 3.7-11.1 0-20.1-9-20.1-20.1l0-75.9-32 0c-53 0-96-43-96-96L0 128zm288 16c0-8.8 7.2-16 16-16l24 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-24 0 0 140.2c-.1 33.1-28.7 59.8-64 59.8-35.3 0-64-26.9-64-60s28.7-60 64-60c19.1 0 36.3 7.9 48 20.3L288 144zm-48 96c-27.5 0-48 20.7-48 44s20.5 44 48 44 48-20.7 48-44-20.5-44-48-44z"]],
    "gauge-low": [512, 512, ["tachometer-alt-slow"], "f627", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zm96-16a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm24.8-108.4c-2-4-.4-8.8 3.6-10.7s8.8-.4 10.7 3.6l83.6 167.2c6.6-2.3 13.8-3.6 21.2-3.6 35.3 0 64 28.7 64 64s-28.7 64-64 64-64-28.7-64-64c0-22.2 11.3-41.7 28.4-53.2L136.8 131.6zM272 80a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm112 48a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm48 112a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M256 496a240 240 0 1 0 0-480 240 240 0 1 0 0 480zM256 0a256 256 0 1 1 0 512 256 256 0 1 1 0-512zm16 80a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zM208 352a48 48 0 1 0 96 0 48 48 0 1 0 -96 0zm-16 0c0-22.2 11.3-41.7 28.4-53.2L136.8 131.6c-2-4-.4-8.8 3.6-10.7s8.8-.4 10.7 3.6l83.6 167.2c6.6-2.3 13.8-3.6 21.2-3.6 35.3 0 64 28.7 64 64s-28.7 64-64 64-64-28.7-64-64zM384 128a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm32 96a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM112 240a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z"]],
    "hexagon-equals": [576, 512, [], "e6b2", ["M47.4 228.2c-9.8 17.2-9.9 38.3-.1 55.5 32.1 56.1 64.2 112.1 96.3 168.2 9.9 17.3 28.2 28 48 28.2 .2 0 .4 0 .6 0l191.6 0c.2 0 .4 0 .6 0 19.7-.2 37.9-10.8 47.8-27.9 .1-.1 .1-.2 .2-.3l96.2-168.1c9.9-17.4 9.8-38.5 0-55.6-32.1-56-64.1-112-96.2-168.1-10-17.4-28.5-28.2-48.6-28.2L192.2 32c-20.1 0-38.6 10.8-48.6 28.2-32.1 56-64.1 112-96.2 168.1zM192 200c0-4.4 3.6-8 8-8l176 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-176 0c-4.4 0-8-3.6-8-8zm0 112c0-4.4 3.6-8 8-8l176 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-176 0c-4.4 0-8-3.6-8-8z", "M47.4 283.9l96.2 168.1c10 17.4 28.5 28.2 48.6 28.2l191.6 0c20.1 0 38.6-10.8 48.6-28.2l96.2-168.1c9.9-17.2 9.9-38.4 0-55.6L432.4 60.2C422.5 42.8 403.9 32 383.8 32L192.2 32c-20.1 0-38.6 10.8-48.6 28.2L47.4 228.2c-9.9 17.2-9.9 38.4 0 55.6zm-13.9 7.9c-12.7-22.2-12.7-49.4 0-71.5L129.7 52.2C142.5 29.8 166.4 16 192.2 16l191.6 0c25.8 0 49.7 13.8 62.5 36.2l96.2 168.1c12.7 22.2 12.7 49.4 0 71.5L446.3 459.9c-12.8 22.4-36.7 36.2-62.5 36.2l-191.6 0c-25.8 0-49.7-13.8-62.5-36.2L33.5 291.8zM192 200c0-4.4 3.6-8 8-8l176 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-176 0c-4.4 0-8-3.6-8-8zm0 112c0-4.4 3.6-8 8-8l176 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-176 0c-4.4 0-8-3.6-8-8z"]],
    "capsule": [448, 512, [], "e75a", ["M16 344.2c0 66.1 53.6 119.8 119.8 119.8 31.8 0 62.2-12.6 84.7-35.1L303 346.3 133.7 177 51.1 259.5C28.6 282 16 312.5 16 344.2z", "M303 346.3L133.7 177 51.1 259.5C28.6 282 16 312.5 16 344.2 16 410.4 69.6 464 135.8 464 167.5 464 198 451.4 220.5 428.9L303 346.3zM314.3 335l82.6-82.6C419.4 230 432 199.5 432 167.8 432 101.6 378.4 48 312.2 48 280.5 48 250 60.6 227.5 83.1L145 165.7 314.3 335zm93.9-71.3L231.8 440.2c-25.5 25.5-60 39.8-96 39.8-75 0-135.8-60.8-135.8-135.8 0-36 14.3-70.5 39.8-96L216.2 71.8c25.5-25.5 60-39.8 96-39.8 75 0 135.8 60.8 135.8 135.8 0 36-14.3 70.5-39.8 96z"]],
    "user-sith": [448, 512, [], "e7b8", ["M8 512c4.4 0 8-3.6 8-8 0-75.1 60.9-136 136-136l144 0c75.1 0 136 60.9 136 136 0 4.4 3.6 8 8 8L8 512zM67.8 272l43.6-109c.4-.9 .6-2 .6-3l0-16c0-26.5 21.5-48 48-48l56 0 0 24c0 4.4 3.6 8 8 8s8-3.6 8-8l0-24 56 0c26.5 0 48 21.5 48 48l0 16c0 1 .2 2 .6 3l43.6 109-75.7 0-48.4-66.6 0-13.4c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 13.4-48.4 66.6-75.7 0zM88 456l0 48c0 4.4 3.6 8 8 8s8-3.6 8-8l0-48c0-4.4-3.6-8-8-8s-8 3.6-8 8zM112 96c0-44.2 35.8-80 80-80l64 0c44.2 0 80 35.8 80 80l0 5.7C324.3 88.4 307.1 80 288 80L160 80c-19.1 0-36.3 8.4-48 21.7l0-5.7zM216 456l0 48c0 4.4 3.6 8 8 8s8-3.6 8-8l0-48c0-4.4-3.6-8-8-8s-8 3.6-8 8zm128 0l0 48c0 4.4 3.6 8 8 8s8-3.6 8-8l0-48c0-4.4-3.6-8-8-8s-8 3.6-8 8z", "M216-8c0-4.4 3.6-8 8-8s8 3.6 8 8l0 8 24 0c53 0 96 43 96 96l0 62.5 47.4 118.6c1 2.5 .7 5.3-.8 7.5s-4 3.5-6.6 3.5l-75.9 0 2.4 3.3c1.8 2.4 2 5.7 .7 8.3S315 304 312 304l-176 0c-3 0-5.8-1.7-7.1-4.4s-1.1-5.9 .7-8.3l2.4-3.3-75.9 0c-2.7 0-5.1-1.3-6.6-3.5s-1.8-5-.8-7.5L96 158.5 96 96c0-53 43-96 96-96l24 0 0-8zM112 160c0 1-.2 2-.6 3l-43.6 109 75.7 0 48.4-66.6 0-13.4c0-17.7 14.3-32 32-32s32 14.3 32 32l0 13.4 48.4 66.6 75.7 0-43.6-109c-.4-.9-.6-2-.6-3l0-16c0-26.5-21.5-48-48-48l-56 0 0 24c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-24-56 0c-26.5 0-48 21.5-48 48l0 16zm48-80l128 0c19.1 0 36.3 8.4 48 21.7l0-5.7c0-44.2-35.8-80-80-80l-64 0c-44.2 0-80 35.8-80 80l0 5.7C123.7 88.4 140.9 80 160 80zM296 287.6l-54.5-74.9c-1-1.4-1.5-3-1.5-4.7l0-16c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 16c0 1.7-.5 3.3-1.5 4.7l-54.5 74.9 0 .4 144 0 0-.4zM16 504c0 4.4-3.6 8-8 8s-8-3.6-8-8c0-83.9 68.1-152 152-152l144 0c83.9 0 152 68.1 152 152 0 4.4-3.6 8-8 8s-8-3.6-8-8c0-75.1-60.9-136-136-136l-144 0C76.9 368 16 428.9 16 504zm88-48l0 48c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-48c0-4.4 3.6-8 8-8s8 3.6 8 8zm128 0l0 48c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-48c0-4.4 3.6-8 8-8s8 3.6 8 8zm128 0l0 48c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-48c0-4.4 3.6-8 8-8s8 3.6 8 8z"]],
    "gauge": [512, 512, ["dashboard", "gauge-med", "tachometer-alt-average"], "f624", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zm96-16a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm48-112a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm32 224c0-32.6 24.4-59.6 56-63.5L248 80c0-4.4 3.6-8 8-8s8 3.6 8 8l0 208.5c31.6 3.9 56 30.9 56 63.5 0 35.3-28.7 64-64 64s-64-28.7-64-64zM384 128a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm48 112a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm0-208a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm0 112c35.3 0 64-28.7 64-64 0-32.6-24.4-59.6-56-63.5L264 80c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 208.5c-31.6 3.9-56 30.9-56 63.5 0 35.3 28.7 64 64 64zM144 144a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm-32 96a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm304 16a16 16 0 1 0 0-32 16 16 0 1 0 0 32zM384 128a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"]],
    "envelope-open-text": [576, 512, [], "f658", ["M48 199.9c65.7 48.8 131.4 97.5 197.1 146.2 8.2 6.1 17.4 10.2 26.9 12.4l0 105-183.2 0C65.7 460 48 440.1 48 416l0-216.1z", "M96 480c-35.3 0-64-28.7-64-64l0-248c0-12.6 6-24.5 16.1-32l197-146.2c25.5-18.9 60.3-18.9 85.8 0L527.9 136c3.1 2.3 5.8 5 8 8L511.8 144 321.4 2.7C301.6-12 274.4-12 254.6 2.7L57.6 148.9c-6 4.5-9.6 11.6-9.6 19.1s3.6 14.6 9.6 19.1l197 146.2c5.4 4 11.2 6.9 17.4 8.7l0 16.5c-9.5-2.2-18.7-6.3-26.9-12.4L48.1 200 48 199.9 48 416c0 26.5 21.5 48 48 48l176 0 0 16-176 0zM528 208l-160 0c-17.7 0-32 14.3-32 32l0 224c0 17.7 14.3 32 32 32l160 0c17.7 0 32-14.3 32-32l0-224c0-17.7-14.3-32-32-32zM368 192l160 0c26.5 0 48 21.5 48 48l0 224c0 26.5-21.5 48-48 48l-160 0c-26.5 0-48-21.5-48-48l0-224c0-26.5 21.5-48 48-48zm24 96l112 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-112 0c-4.4 0-8-3.6-8-8s3.6-8 8-8zm0 64l96 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-96 0c-4.4 0-8-3.6-8-8s3.6-8 8-8z"]],
    "toolbox": [512, 512, [129520], "f552", ["", "M168 16l176 0c13.3 0 24 10.7 24 24l0 56-224 0 0-56c0-13.3 10.7-24 24-24zM128 40l0 56-28.1 0c-12.7 0-24.9 5.1-33.9 14.1L14.1 161.9c-9 9-14.1 21.2-14.1 33.9L0 416c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-220.1c0-12.7-5.1-24.9-14.1-33.9l-51.9-51.9c-9-9-21.2-14.1-33.9-14.1l-28.1 0 0-56c0-22.1-17.9-40-40-40L168 0c-22.1 0-40 17.9-40 40zM16 312l136 0 0 40c0 4.4 3.6 8 8 8s8-3.6 8-8l0-40 176 0 0 40c0 4.4 3.6 8 8 8s8-3.6 8-8l0-40 136 0 0 104c0 26.5-21.5 48-48 48L64 464c-26.5 0-48-21.5-48-48l0-104zm0-16l0-100.1c0-8.5 3.4-16.6 9.4-22.6l51.9-51.9c6-6 14.1-9.4 22.6-9.4l312.2 0c8.5 0 16.6 3.4 22.6 9.4l51.9 51.9c6 6 9.4 14.1 9.4 22.6l0 100.1-136 0 0-40c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 40-176 0 0-40c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 40-136 0z"]],
    "wheat-slash": [576, 512, [], "e339", ["M277.2 61.8C260.4 91.1 264.6 129 289.6 154l43.8 43.8 7.8-10c22.2-28.6 21.3-68.6-1.5-96l-4.8-5.3-42.7-42.7-3.6 3.7c-4.4 4.4-8.2 9.3-11.4 14.4zm69 148.8L390 254.4c25 25 62.9 29.1 92.2 12.4 5.1-3.2 9.9-7 14.3-11.4l3.6-3.7-42.6-42.6c-27.4-27.3-70.8-30-101.3-6.3l-10.1 7.8zM432 80c0 10.7 0 21.3 0 32 10.7 0 21.4 0 32 0 1 0 2 0 3 0 42.2-1.6 76-35.8 77-78.1 0-11.3 0-22.6 0-33.9L512 0c-44.2 0-80 35.8-80 80z", "M2.4-29.7c2.7-2.7 7-3.1 10.1-1l1.2 1 560 560 1 1.3c2 3.1 1.7 7.3-1 10.1s-7 3.1-10.1 1l-1.3-1-560-560-1-1.2c-2-3.1-1.7-7.3 1-10.1zm77 263.1c3.1-2 7.3-1.7 10 1l48.8 48.8 5.8 6.4c22.9 27.6 27.4 65.6 12.9 97.5 34.5-15.7 76.1-9.1 104 18.7l48.8 48.8c1.5 1.5 2.3 3.5 2.3 5.7 0 1.6-.5 3.1-1.3 4.4l-1 1.2-7.9 7.8c-36.2 36.2-94.9 36.2-131.1 0l-44.6-44.6-88.5 88.5c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l88.5-88.5-44.6-44.6c-36.2-36.2-36.2-94.9 0-131.1l7.8-7.9 1.3-1zM249.6 417.1c-27.3-27.3-70.8-30-101.3-6.3l-10.1 7.8 43.8 43.8c30 29.9 78.5 29.9 108.5 0l2.2-2.2-43.1-43.1zM81.6 253.5c-30 30-30 78.5 0 108.5l43.8 43.8 7.8-10c22.2-28.6 21.3-68.6-1.5-96l-4.8-5.3-43.1-43.1-2.2 2.2zm81.8-42.9c1.5 17.3 8.9 34.2 22.2 47.4l43.8 43.8 7.8-10c1.1-1.4 2.1-2.9 3.1-4.3l16.3 16.3c-1.5 1-2.9 2-4.3 3.1l-10.1 7.8 43.8 43.8c13.2 13.2 30.1 20.5 47.3 22.1l15.9 15.9c-26.6 2.6-54.2-6.3-74.6-26.7L174.3 269.3c-20.4-20.4-29.3-48-26.7-74.6l15.9 15.9zm124-185.3c3.1-2 7.3-1.7 10 1l48.8 48.8 5.8 6.4c22.9 27.6 27.4 65.6 12.9 97.5 34.5-15.7 76.1-9.1 104 18.8l48.8 48.8c1.5 1.5 2.3 3.5 2.3 5.7 0 1.6-.5 3.1-1.3 4.4l-1 1.2-7.9 7.8c-36.2 36.2-94.9 36.2-131.1 0L278.3 165.3c-36.2-36.2-36.2-94.9 0-131.1l7.8-7.9 1.3-1zM457.6 209.1c-27.4-27.3-70.8-30-101.3-6.3l-10.1 7.8 43.8 43.8c30 29.9 78.5 29.9 108.5 0l2.2-2.2-43.1-43.1zM289.6 45.5c-30 30-30 78.5 0 108.5l43.8 43.8 7.8-10c22.2-28.6 21.3-68.6-1.5-96l-4.8-5.3-43.1-43.1-2.2 2.2zM552-16c2.1 0 4.2 .8 5.7 2.3S560-10.1 560-8l0 40c0 53-43 96-96 96l-40 0c-2.1 0-4.2-.8-5.7-2.3s-2.3-3.5-2.3-5.7l0-40c0-53 43-96 96-96l40 0zM512 0c-44.2 0-80 35.8-80 80l0 32 32 0c44.2 0 80-35.8 80-80l0-32-32 0z"]],
    "power-off": [512, 512, [9211], "f011", ["M16 256c0 132.5 107.5 240 240 240S496 388.5 496 256C496 159.4 438.9 76.1 356.6 38 328.3 25 297 17.2 264 16.1L264 256c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-239.9C215 17.2 183.7 25 155.4 38 73.1 76.1 16 159.4 16 256z", "M264-24c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 280c0 4.4 3.6 8 8 8s8-3.6 8-8l0-280zM155.4 38c4-1.9 5.8-6.6 3.9-10.6s-6.6-5.8-10.6-3.9C60.9 64.1 0 152.9 0 256 0 397.4 114.6 512 256 512S512 397.4 512 256c0-103.1-60.9-191.9-148.7-232.5-4-1.9-8.8-.1-10.6 3.9s-.1 8.8 3.9 10.6C438.9 76.1 496 159.4 496 256 496 388.5 388.5 496 256 496S16 388.5 16 256C16 159.4 73.1 76.1 155.4 38z"]],
    "signal": [448, 512, [128246, "signal-5", "signal-perfect"], "f012", ["", "M448 40c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 432c0 4.4 3.6 8 8 8s8-3.6 8-8l0-432zM328 128c-4.4 0-8 3.6-8 8l0 336c0 4.4 3.6 8 8 8s8-3.6 8-8l0-336c0-4.4-3.6-8-8-8zM232 232c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 240c0 4.4 3.6 8 8 8s8-3.6 8-8l0-240zM120 320c-4.4 0-8 3.6-8 8l0 144c0 4.4 3.6 8 8 8s8-3.6 8-8l0-144c0-4.4-3.6-8-8-8zM8 384c-4.4 0-8 3.6-8 8l0 80c0 4.4 3.6 8 8 8s8-3.6 8-8l0-80c0-4.4-3.6-8-8-8z"]],
    "arrows-spin": [512, 512, [], "e4bb", ["M16 376l0 96c0 3.2 1.9 6.2 4.9 7.4s6.4 .6 8.7-1.7l96-96c2.3-2.3 3-5.7 1.7-8.7s-4.2-4.9-7.4-4.9l-96 0c-4.4 0-8 3.6-8 8zM32.6 20.9c-1.2 3-.6 6.4 1.7 8.7l96 96c2.3 2.3 5.7 3 8.7 1.7s4.9-4.2 4.9-7.4l0-96c0-4.4-3.6-8-8-8L40 16c-3.2 0-6.2 1.9-7.4 4.9zM368 392l0 96c0 4.4 3.6 8 8 8l96 0c3.2 0 6.2-2 7.4-4.9s.6-6.4-1.7-8.7l-96-96c-2.3-2.3-5.7-3-8.7-1.7s-4.9 4.2-4.9 7.4zm16.6-252.9c1.2 3 4.2 4.9 7.4 4.9l96 0c4.4 0 8-3.6 8-8l0-96c0-3.2-1.9-6.2-4.9-7.4s-6.4-.6-8.7 1.7l-96 96c-2.3 2.3-3 5.7-1.7 8.7z", "M416.1 77.9L375 119c-6.9 6.9-8.9 17.2-5.2 26.2S382.3 160 392 160l96 0c13.3 0 24-10.7 24-24l0-96c0-9.7-5.8-18.5-14.8-22.2S477.9 16.2 471 23L427.4 66.6c-.1-.1-.2-.2-.3-.3l-5.5-5.5c-.2-.2-.3-.3-.5-.4-58.7-49.7-134.6-68.7-206.4-57.1-4.4 .7-7.3 4.8-6.6 9.2s4.8 7.3 9.2 6.6C284.6 8.2 355.6 26 410.6 72.4l5.3 5.3c.1 .1 .2 .2 .3 .3zM488 144l-96 0c-3.2 0-6.2-1.9-7.4-4.9s-.6-6.4 1.7-8.7l96-96c2.3-2.3 5.7-3 8.7-1.7S496 36.8 496 40l0 96c0 4.4-3.6 8-8 8zM77.9 95.9L119 137c6.9 6.9 17.2 8.9 26.2 5.2S160 129.7 160 120l0-96c0-13.3-10.7-24-24-24L40 0C30.3 0 21.5 5.8 17.8 14.8S16.2 34.1 23 41L66.6 84.6c-.1 .1-.2 .2-.3 .3l-5.5 5.5c-.2 .2-.3 .3-.4 .5-49.7 58.7-68.7 134.6-57.1 206.4 .7 4.4 4.8 7.3 9.2 6.6s7.3-4.8 6.6-9.2C8.2 227.4 26 156.4 72.4 101.4l5.3-5.3c.1-.1 .2-.2 .3-.3zM144 24l0 96c0 3.2-1.9 6.2-4.9 7.4s-6.4 .6-8.7-1.7l-96-96c-2.3-2.3-3-5.7-1.7-8.7S36.8 16 40 16l96 0c4.4 0 8 3.6 8 8zM95.9 434.1L137 393c6.9-6.9 8.9-17.2 5.2-26.2S129.7 352 120 352l-96 0c-13.3 0-24 10.7-24 24l0 96c0 9.7 5.8 18.5 14.8 22.2S34.1 495.8 41 489l43.6-43.6c.1 .1 .2 .2 .3 .3l5.5 5.5c.2 .2 .3 .3 .5 .5 58.8 49.8 134.7 68.8 206.6 57 4.4-.7 7.3-4.8 6.6-9.2s-4.8-7.3-9.2-6.6c-67.3 11-138.3-6.8-193.4-53.2l-5.3-5.3c-.1-.1-.2-.2-.3-.3zM24 368l96 0c3.2 0 6.2 1.9 7.4 4.9s.6 6.4-1.7 8.7l-96 96c-2.3 2.3-5.7 3-8.7 1.7S16 475.2 16 472l0-96c0-4.4 3.6-8 8-8zm410.1 48.1L393 375c-6.9-6.9-17.2-8.9-26.2-5.2S352 382.3 352 392l0 96c0 13.3 10.7 24 24 24l96 0c9.7 0 18.5-5.8 22.2-14.8s1.7-19.3-5.2-26.2l-43.6-43.6c.1-.1 .2-.2 .3-.3l5.5-5.5c.2-.2 .3-.3 .4-.5 49.8-58.8 68.8-134.7 57-206.6-.7-4.4-4.8-7.3-9.2-6.6s-7.3 4.8-6.6 9.2c11 67.3-6.8 138.3-53.2 193.4l-5.3 5.3c-.1 .1-.2 .2-.3 .3zM368 488l0-96c0-3.2 1.9-6.2 4.9-7.4s6.4-.6 8.7 1.7l96 96c2.3 2.3 3 5.7 1.7 8.7s-4.2 4.9-7.4 4.9l-96 0c-4.4 0-8-3.6-8-8z"]],
    "joint": [576, 512, [], "f595", ["M16 400c0 11.3 7.8 21.1 18.6 23.6l155.7 35.9c13 3 26.3 4.5 39.6 4.5l27.2 0-74.8-121.6-147.6 34.1C23.8 378.9 16 388.7 16 400zm182.8-61.2l77.1 125.2 77.5 0c9 0 17.9-.7 26.8-2l18-2.8-75.8-123.2-92.4 0c-10.4 0-20.8 .9-31.1 2.8zM341.1 336l74.2 120.5 110.9-17.1c19.5-3 33.9-19.8 33.9-39.5s-14.4-36.5-33.9-39.5L380.1 338c-8.9-1.4-17.8-2-26.8-2l-12.2 0z", "M392 0c-4.4 0-8 3.6-8 8l0 35c0 44.6 17.7 87.3 49.2 118.8l21 21C470.7 199.3 480 221.7 480 245l0 35c0 4.4 3.6 8 8 8s8-3.6 8-8l0-35c0-27.6-11-54-30.5-73.5l-21-21C416 122 400 83.3 400 43l0-35c0-4.4-3.6-8-8-8zM552 288c4.4 0 8-3.6 8-8l0-35c0-44.6-17.7-87.3-49.2-118.8l-21-21C473.3 88.7 464 66.3 464 43l0-35c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 35c0 27.6 11 54 30.5 73.5l21 21C528 166 544 204.7 544 245l0 35c0 4.4 3.6 8 8 8zM34.6 376.4l147.6-34.1 74.8 121.6-27.2 0c-13.3 0-26.6-1.5-39.6-4.5L34.6 423.6C23.8 421.1 16 411.3 16 400s7.8-21.1 18.6-23.6zM275.9 464L198.8 338.8c10.3-1.8 20.7-2.8 31.1-2.8l92.4 0 75.8 123.2-18 2.8c-8.9 1.4-17.8 2-26.8 2l-77.5 0zm139.4-7.5l-74.2-120.5 12.2 0c9 0 17.9 .7 26.8 2l146 22.5c19.5 3 33.9 19.8 33.9 39.5s-14.4 36.5-33.9 39.5L415.3 456.5zM186.7 324.9L31 360.8C12.9 365 0 381.4 0 400s12.9 35 31 39.2l155.7 35.9c14.2 3.3 28.6 4.9 43.2 4.9l123.5 0c9.8 0 19.5-.7 29.2-2.2l146-22.5c27.3-4.2 47.4-27.7 47.4-55.3s-20.1-51.1-47.4-55.3l-146-22.5c-9.7-1.5-19.4-2.2-29.2-2.2l-123.5 0c-14.5 0-29 1.6-43.2 4.9z"]],
    "down-from-line": [384, 512, ["arrow-alt-from-top"], "f349", ["M40.6 340.9c-1.2 3-.6 6.4 1.7 8.7l144 144c3.1 3.1 8.2 3.1 11.3 0l144-144c2.3-2.3 3-5.7 1.7-8.7s-4.2-4.9-7.4-4.9l-88 0c-4.4 0-8-3.6-8-8l0-152c0-17.7-14.3-32-32-32l-32 0c-17.7 0-32 14.3-32 32l0 152c0 4.4-3.6 8-8 8l-88 0c-3.2 0-6.2 1.9-7.4 4.9z", "M197.7 493.7l144-144c2.3-2.3 3-5.7 1.7-8.7s-4.2-4.9-7.4-4.9l-88 0c-4.4 0-8-3.6-8-8l0-152c0-17.7-14.3-32-32-32l-32 0c-17.7 0-32 14.3-32 32l0 152c0 4.4-3.6 8-8 8l-88 0c-3.2 0-6.2 1.9-7.4 4.9l0 0c-1.2 3-.6 6.4 1.7 8.7l144 144c3.1 3.1 8.2 3.1 11.3 0zM128 256l0-80c0-26.5 21.5-48 48-48l32 0c26.5 0 48 21.5 48 48l0 144 80 0c9.7 0 18.5 5.8 22.2 14.8s1.7 19.3-5.2 26.2l-144 144 0 0c-9.4 9.4-24.6 9.4-33.9 0L31 361c-6.9-6.9-8.9-17.2-5.2-26.2S38.3 320 48 320l80 0 0-64zM384 8c0 4.4-3.6 8-8 8L8 16c-4.4 0-8-3.6-8-8S3.6 0 8 0L376 0c4.4 0 8 3.6 8 8z"]],
    "tablet-rugged": [448, 512, [], "f48f", ["M112 96l0 320c0 8.8 7.2 16 16 16l192 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L128 80c-8.8 0-16 7.2-16 16z", "M48 176l0 16c0 6.1-3.4 11.6-8.8 14.3l-23.2 11.6 0 76.2 23.2 11.6c5.4 2.7 8.8 8.2 8.8 14.3l0 16c0 6.1-3.4 11.6-8.8 14.3l-23.2 11.6 0 76.2 25.5 12.7c4 2 7.1 5.7 8.3 10 5.6 20.3 24.2 35.1 46.3 35.1l256 0c22 0 40.6-14.9 46.3-35.1 1.2-4.4 4.2-8 8.3-10l25.5-12.7 0-76.2-23.2-11.6c-5.4-2.7-8.8-8.2-8.8-14.3l0-16c0-6.1 3.4-11.6 8.8-14.3l23.2-11.6 0-76.2-23.2-11.6c-5.4-2.7-8.8-8.3-8.8-14.3l0-16c0-6.1 3.4-11.6 8.8-14.3l23.2-11.6 0-76.2-25.5-12.7c-4.1-2-7.1-5.7-8.3-10-5.6-20.3-24.2-35.1-46.3-35.1L96 16c-22 0-40.6 14.9-46.3 35.1-1.2 4.4-4.2 8-8.3 10L16 73.9 16 150.1 39.2 161.7c5.4 2.7 8.8 8.3 8.8 14.3zm391.2-11.6l-23.2 11.6 0 16 23.2 11.6c5.4 2.7 8.8 8.3 8.8 14.3l0 76.2c0 6.1-3.4 11.6-8.8 14.3l-23.2 11.6 0 16 23.2 11.6c5.4 2.7 8.8 8.2 8.8 14.3l0 76.2c0 6.1-3.4 11.6-8.8 14.3l-25.5 12.7c-7.5 27-32.3 46.8-61.7 46.8L96 512c-29.4 0-54.2-19.8-61.7-46.8L8.8 452.4C3.4 449.7 0 444.2 0 438.1l0-76.2c0-6.1 3.4-11.6 8.8-14.3L32 336 32 320 8.8 308.4C3.4 305.7 0 300.2 0 294.1l0-76.2c0-6.1 3.4-11.6 8.8-14.3L32 192 32 176 8.8 164.4C3.4 161.7 0 156.2 0 150.1L0 73.9c0-6.1 3.4-11.6 8.8-14.3L34.3 46.8C41.8 19.8 66.6 0 96 0L352 0c29.4 0 54.2 19.8 61.7 46.8l25.5 12.7c5.4 2.7 8.8 8.3 8.8 14.3l0 76.2c0 6.1-3.4 11.6-8.8 14.3zM128 80c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l192 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16L128 80zM96 96c0-17.7 14.3-32 32-32l192 0c17.7 0 32 14.3 32 32l0 320c0 17.7-14.3 32-32 32l-192 0c-17.7 0-32-14.3-32-32L96 96z"]],
    "braille": [384, 512, [], "f2a1", ["M16 64A64 64 0 1 0 144 64 64 64 0 1 0 16 64zm0 192a64 64 0 1 0 128 0 64 64 0 1 0 -128 0zM96 64a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm0 192a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zM240 64a64 64 0 1 0 128 0 64 64 0 1 0 -128 0zm80 0a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M80 0A64 64 0 1 1 80 128 64 64 0 1 1 80 0zm0 144a80 80 0 1 0 0-160 80 80 0 1 0 0 160zm0 48a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm0 144a80 80 0 1 0 0-160 80 80 0 1 0 0 160zm64 112c0 35.3-28.7 64-64 64s-64-28.7-64-64 28.7-64 64-64 64 28.7 64 64zm16 0c0-44.2-35.8-80-80-80s-80 35.8-80 80 35.8 80 80 80 80-35.8 80-80zm144 64c-35.3 0-64-28.7-64-64s28.7-64 64-64 64 28.7 64 64-28.7 64-64 64zm0 16c44.2 0 80-35.8 80-80s-35.8-80-80-80-80 35.8-80 80 35.8 80 80 80zM240 256a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zm144 0a80 80 0 1 0 -160 0 80 80 0 1 0 160 0zM304 0a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm0 144a80 80 0 1 0 0-160 80 80 0 1 0 0 160zM80 80a16 16 0 1 0 0-32 16 16 0 1 0 0 32zM96 256a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM304 80a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"]],
    "basket-shopping": [576, 512, ["shopping-basket"], "f291", ["M51.5 176l473 0-49.9 249.4c-4.5 22.4-24.2 38.6-47.1 38.6l-279.1 0c-22.9 0-42.6-16.2-47.1-38.6L51.5 176zM176 264l0 112c0 4.4 3.6 8 8 8s8-3.6 8-8l0-112c0-4.4-3.6-8-8-8s-8 3.6-8 8zm104 0l0 112c0 4.4 3.6 8 8 8s8-3.6 8-8l0-112c0-4.4-3.6-8-8-8s-8 3.6-8 8zm104 0l0 112c0 4.4 3.6 8 8 8s8-3.6 8-8l0-112c0-4.4-3.6-8-8-8s-8 3.6-8 8z", "M288 0c2.3 0 4.4 1 6 2.7L434.7 160c166.3 0 90.5 0 117.3 0 4.4 0 8 3.6 8 8s-3.6 8-8 8l-11.2 0-50.5 252.6c-6 29.9-32.2 51.4-62.8 51.4l-279.1 0c-30.5 0-56.8-21.5-62.8-51.4L35.2 176 24 176c-4.4 0-8-3.6-8-8s3.6-8 8-8l8 0 0 0 109.3 0 140.8-157.3C283.6 1 285.7 0 288 0zm0 20L162.7 160 413.3 160 288 20zM51.5 176l49.9 249.4c4.5 22.4 24.2 38.6 47.1 38.6l279.1 0c22.9 0 42.6-16.2 47.1-38.6l49.9-249.4-473 0zM192 264l0 112c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-112c0-4.4 3.6-8 8-8s8 3.6 8 8zm96-8c4.4 0 8 3.6 8 8l0 112c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-112c0-4.4 3.6-8 8-8zm112 8l0 112c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-112c0-4.4 3.6-8 8-8s8 3.6 8 8z"]],
    "party-bell": [512, 512, [], "e31a", ["M16 224c0-114.9 93.1-208 208-208 36.2 0 70.2 9.2 99.9 25.5 5.3 2.9 9.4 7.2 12.2 12.2 7 12.5 4.8 28-5.3 38.1l-239 239c-10.1 10.1-25.7 12.3-38.1 5.3-5-2.8-9.3-6.9-12.2-12.2-16.3-29.7-25.5-63.7-25.5-99.9z", "M355.1 161.7c-3.5 2.7-4.1 7.7-1.4 11.2l4.8 6.2c34 43.7 84.6 71.4 139.8 76.4l5 .5c4.4 .4 8.3-2.8 8.7-7.2s-2.8-8.3-7.2-8.7l-5-.5c-50.7-4.6-97.3-30.1-128.6-70.3l-4.8-6.2c-2.7-3.5-7.7-4.1-11.2-1.4zM480 48a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm0 48a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM368 480a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm-48 0a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zM80 480a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm-48 0a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zM172.9 353.7c-3.5-2.7-8.5-2.1-11.2 1.4s-2.1 8.5 1.4 11.2l28.1 21.9c26.2 20.4 42.8 50.8 45.8 83.9l3 32.7c.4 4.4 4.3 7.6 8.7 7.2s7.6-4.3 7.2-8.7l-3-32.7c-3.4-37.5-22.2-71.9-51.9-95l-28.1-21.9zM509.3 510c3.3-2.9 3.6-8 .7-11.3l-14.8-16.8c-8.4-9.5-12.9-21.9-12.5-34.6 .9-33.2-23-62-55.9-67.2l-43.9-6.9c-30.1-4.7-52.9-29.6-55.1-59.9-1.3-17.2-7.9-33.5-19.1-46.7l-6.6-7.7c-2.9-3.4-7.9-3.8-11.3-.9s-3.8 7.9-.9 11.3l6.6 7.7c8.9 10.6 14.3 23.7 15.3 37.5 2.8 37.8 31.2 68.6 68.6 74.6l43.9 6.9c24.9 3.9 43 25.7 42.4 51-.5 16.7 5.5 33 16.5 45.6L498 509.3c2.9 3.3 8 3.6 11.3 .7zM16 224c0-114.9 93.1-208 208-208 36.2 0 70.2 9.2 99.9 25.5 5.3 2.9 9.4 7.2 12.2 12.2 7 12.5 4.8 28-5.3 38.1l-239 239c-10.1 10.1-25.7 12.3-38.1 5.3-5-2.8-9.3-6.9-12.2-12.2-16.3-29.7-25.5-63.7-25.5-99.9zM45.9 350.1c18.7 10.5 42.1 7.2 57.2-7.9l239-239c15.2-15.2 18.4-38.5 7.9-57.2-4.1-7.4-10.4-14-18.5-18.4-32-17.5-68.7-27.5-107.6-27.5-123.7 0-224 100.3-224 224 0 38.9 10 75.6 27.5 107.6 4.4 8.1 11 14.3 18.4 18.5z"]],
    "bra": [576, 512, [], "e6cf", ["M32 336c0-33.8 13.1-64.5 34.5-87.4L115 268c54 21.6 100.7 58.2 134.5 105.6l20.3 28.4C247.3 439.2 206.5 464 160 464 89.3 464 32 406.7 32 336zm274.3 65.9l20.2-28.4C360.3 326.3 407 289.6 461 268l48.2-19.3 .4-.1c21.4 22.9 34.4 53.6 34.4 87.3 0 70.7-57.3 128-128 128-46.5 0-87.3-24.8-109.7-62.1z", "M127.7 42.2c1.2-4.3-1.3-8.7-5.5-9.9s-8.7 1.3-9.9 5.5L57 235.4c-25.4 26-41 61.5-41 100.6 0 79.5 64.5 144 144 144 53.3 0 99.8-29 124.7-72l6.5 0c24.9 43 71.4 72 124.7 72 79.5 0 144-64.5 144-144 0-40.6-16.8-77.3-43.9-103.5L463.7 37.9c-1.1-4.3-5.5-6.8-9.8-5.6s-6.8 5.5-5.6 9.8l52 193-45.2 18.1c-56.8 22.7-106 61.3-141.6 111.1l-19.8 27.7-11.4 0-19.8-27.7c-35.6-49.8-84.7-88.4-141.6-111.1L73.9 234.4 127.7 42.2zM32 336c0-33.8 13.1-64.5 34.5-87.4L115 268c54 21.6 100.7 58.2 134.5 105.6l20.3 28.4C247.3 439.2 206.5 464 160 464 89.3 464 32 406.7 32 336zm477.6-87.3c21.4 22.9 34.4 53.6 34.4 87.3 0 70.7-57.3 128-128 128-46.5 0-87.3-24.8-109.7-62.1l20.2-28.4C360.3 326.3 407 289.6 461 268l48.2-19.3 .4-.1z"]],
    "car-wash": [448, 512, [], "f5e6", ["M16 336l0 96 416 0 0-96c0-26.5-21.5-48-48-48L64 288c-26.5 0-48 21.5-48 48zm112 16a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm256 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M256 48c0 12.2-4 19.7-8.9 24.2-5.1 4.7-13 7.8-23.1 7.8-17.7 0-32-14.3-32-32 0-6.4 3.7-16.2 10.9-28 6.5-10.5 14.5-20.7 21.1-28.3 6.6 7.7 14.6 17.8 21.1 28.3 7.2 11.8 10.9 21.6 10.9 28zm16 0c0-22.2-23-52-37.2-68.2-5.8-6.7-15.9-6.7-21.7 0-14.2 16.3-37.2 46.1-37.2 68.2 0 26.5 21.5 48 48 48s48-16 48-48zM123.3 160l201.4 0c17.5 0 33 11.4 38.2 28.1l26.3 84.1c-1.7-.1-3.4-.2-5.2-.2L64 272c-1.7 0-3.5 .1-5.2 .2l26.3-84.1c5.2-16.7 20.7-28.1 38.2-28.1zM69.8 183.3L40.8 276.4C16.9 285.7 0 308.9 0 336L0 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-32 320 0 0 32c0 17.7 14.3 32 32 32s32-14.3 32-32l0-144c0-27.1-16.9-50.3-40.8-59.6l-29.1-93.1c-7.3-23.4-29-39.3-53.5-39.3l-201.4 0c-24.5 0-46.1 15.9-53.5 39.3zM400 432l-384 0 0-96c0-26.5 21.5-48 48-48l320 0c26.5 0 48 21.5 48 48l0 96-32 0zm0 48l0-32 32 0 0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16zM48 448l0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-32 32 0zm32-96a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm48 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm224-16a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm0 48a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM87.1 72.2C82 77 74.1 80 64 80 46.3 80 32 65.7 32 48 32 41.6 35.7 31.8 42.9 20 49.4 9.5 57.4-.6 64-8.3 70.6-.6 78.6 9.5 85.1 20 92.3 31.8 96 41.6 96 48 96 60.2 92 67.7 87.1 72.2zM64 96C90.5 96 112 80 112 48 112 25.8 89-4 74.8-20.2 69-26.9 59-26.9 53.2-20.2 39-4 16 25.8 16 48 16 74.5 37.5 96 64 96zM416 48c0 12.2-4 19.7-8.9 24.2-5.1 4.7-13 7.8-23.1 7.8-17.7 0-32-14.3-32-32 0-6.4 3.7-16.2 10.9-28 6.5-10.5 14.5-20.7 21.1-28.3 6.6 7.7 14.6 17.8 21.1 28.3 7.2 11.8 10.9 21.6 10.9 28zm16 0c0-22.2-23-52-37.2-68.2-5.8-6.7-15.9-6.7-21.7 0-14.2 16.3-37.2 46.1-37.2 68.2 0 26.5 21.5 48 48 48s48-16 48-48z"]],
    "face-sunglasses": [512, 512, [], "e398", ["M0 256c0-31.1 5.6-61 15.7-88.5 0 2.9 .2 5.9 .6 8.9l9.6 64C30.1 267.7 53.6 288 81.3 288l101.3 0c27.7 0 51.3-20.3 55.4-47.7l9.6-64c5.6-.3 11.1-.3 16.7-.3 3.2 21.6 6.4 43 9.6 64.3 4.1 27.4 27.7 47.7 55.4 47.7l101.3 0c27.7 0 51.3-20.3 55.4-47.7l9.6-64c.4-3 .7-5.9 .6-8.9 10.2 27.6 15.7 57.4 15.7 88.5 0 22.1-2.8 43.5-8.1 64l-16.6 0c-28 101.5-121 176-231.4 176S52.6 421.5 24.6 320L8.1 320C2.8 299.5 0 278.1 0 256zM36.2 124.7c9.7-16.1 21-31.1 33.9-44.7l22.7 0C135.7 40.3 193 16 256 16S376.3 40.3 419.2 80l22.7 0c12.9 13.6 24.2 28.5 33.9 44.7-9.6-7.9-21.9-12.7-35.5-12.7l-120.5 0c-28.6 0-51.6 21.3-55.4 48l-16.6 0c-3.8-26.7-26.8-48-55.4-48L71.7 112c-13.6 0-25.9 4.8-35.5 12.7zM136.6 358.1c27.8 35.3 71 57.9 119.4 57.9s91.6-22.7 119.4-57.9c2.7-3.5 2.1-8.5-1.3-11.2s-8.5-2.1-11.2 1.3C337.9 379.7 299.3 400 256 400s-81.9-20.3-106.8-51.8c-2.7-3.5-7.8-4.1-11.2-1.3s-4.1 7.8-1.3 11.2z", "M487.4 320c-28 101.5-121 176-231.4 176S52.6 421.5 24.6 320L8.1 320C36.5 430.4 136.7 512 256 512s219.5-81.6 247.9-192l-16.6 0zM92.8 80C135.7 40.3 193 16 256 16S376.3 40.3 419.2 80l22.7 0C395.2 30.7 329.2 0 256 0S116.8 30.7 70.1 80l22.7 0zm45.1 266.8c-3.5 2.7-4.1 7.8-1.3 11.2 27.8 35.3 71 57.9 119.4 57.9s91.6-22.7 119.4-57.9c2.7-3.5 2.1-8.5-1.3-11.2s-8.5-2.1-11.2 1.3C337.9 379.7 299.3 400 256 400s-81.9-20.3-106.8-51.8c-2.7-3.5-7.8-4.1-11.2-1.3zM264.3 176l0 .3 9.6 64c4.1 27.4 27.7 47.7 55.4 47.7l101.3 0c27.7 0 51.3-20.3 55.4-47.7l9.6-64c5.1-33.9-21.1-64.3-55.4-64.3l-120.5 0c-28.6 0-51.6 21.3-55.4 48l-16.6 0c-3.8-26.7-26.8-48-55.4-48L71.7 112c-34.2 0-60.5 30.4-55.4 64.3l9.6 64C30.1 267.7 53.6 288 81.3 288l101.3 0c27.7 0 51.3-20.3 55.4-47.7l9.6-64 0-.3 16.6 0zm15.7-3.4l0-9.3c2.3-19.6 19-35.3 39.7-35.3l31.8 0-45.5 136.5c-8.5-6.1-14.6-15.5-16.3-26.6l-9.6-64c-.1-.5-.1-.9-.2-1.3zM329.3 272c-2.9 0-5.8-.3-8.6-.9l46.8-140.5 .8-2.5 71.1 0-47.2 141.5-.8 2.5-62.2 0zM455.4 131c16.5 6.7 27.2 24.1 24.4 43l-9.6 64c-2.9 19.6-19.8 34.1-39.6 34.1l-22.2 0 47-141zM232 172.6c-.1 .4-.1 .9-.2 1.3l-9.6 64c-2.9 19.6-19.8 34.1-39.6 34.1l-22.2 0 47-141c13.3 5.4 22.9 17.8 24.6 32.3l0 9.3zM191.6 128l-47.2 141.5-.8 2.5-62.2 0c-2.9 0-5.8-.3-8.6-.9l46.8-140.5 .8-2.5 71.1 0zm-88 0L58.1 264.5c-8.5-6.1-14.6-15.5-16.3-26.6l-9.6-64C28.6 149.7 47.3 128 71.7 128l31.8 0z"]],
    "bridge": [512, 512, [], "e4c8", ["M16 160l0 90.5 6.9 2.6C57.2 265.9 80 298.8 80 335.4L80 456c0 4.4 3.6 8 8 8l64 0c4.4 0 8-3.6 8-8l0-88c0-50.6 39.2-92.1 88.9-95.7 4.7-.4 9.6-.4 14.3 0 49.7 3.6 88.9 45.1 88.9 95.7l0 88c0 4.4 3.6 8 8 8l64 0c4.4 0 8-3.6 8-8l0-120.6c0-36.7 22.8-69.5 57.1-82.4l6.9-2.6 0-90.5-480 0z", "M8 32c-4.4 0-8 3.6-8 8s3.6 8 8 8l48 0 0 96-48 0c-4.4 0-8 3.6-8 8L0 256c0 3.3 2.1 6.3 5.2 7.5L17.3 268C45.4 278.6 64 305.4 64 335.4L64 456c0 13.3 10.7 24 24 24l64 0c13.3 0 24-10.7 24-24l0-88c0-44.2 35.8-80 80-80s80 35.8 80 80l0 88c0 13.3 10.7 24 24 24l64 0c13.3 0 24-10.7 24-24l0-120.6c0-30 18.6-56.9 46.7-67.4l12.1-4.5c3.1-1.2 5.2-4.2 5.2-7.5l0-104c0-4.4-3.6-8-8-8l-48 0 0-96 48 0c4.4 0 8-3.6 8-8s-3.6-8-8-8L8 32zM440 48l0 96-112 0 0-96 112 0zm8 112l48 0 0 90.5-6.9 2.6c-34.3 12.9-57.1 45.7-57.1 82.4L432 456c0 4.4-3.6 8-8 8l-64 0c-4.4 0-8-3.6-8-8l0-88c0-53-43-96-96-96s-96 43-96 96l0 88c0 4.4-3.6 8-8 8l-64 0c-4.4 0-8-3.6-8-8l0-120.6c0-36.7-22.8-69.5-57.1-82.4l-6.9-2.6 0-90.5 432 0zM312 48l0 96-112 0 0-96 112 0zM184 48l0 96-112 0 0-96 112 0z"]],
    "arrows-from-line": [384, 512, [], "e0a4", ["", "M186.3-29.7c3.1-3.1 8.2-3.1 11.3 0l88 88c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L200-4.7 200 184c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-188.7-74.3 74.3c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l88-88zm11.3 571.3c-3.1 3.1-8.2 3.1-11.3 0l-88-88c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0L184 516.7 184 328c0-4.4 3.6-8 8-8s8 3.6 8 8l0 188.7 74.3-74.3c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3l-88 88zM8 248l368 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L8 264c-4.4 0-8-3.6-8-8s3.6-8 8-8z"]],
    "up-long-to-line": [320, 512, [], "e6c6", ["M17.2 230.1c2.5 6 8.3 9.9 14.8 9.9l72 0c4.4 0 8 3.6 8 8l0 280c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-280c0-4.4 3.6-8 8-8l72 0c6.5 0 12.3-3.9 14.8-9.9s1.1-12.9-3.5-17.4l-128-128c-6.2-6.2-16.4-6.2-22.6 0l-128 128c-4.6 4.6-5.9 11.5-3.5 17.4z", "M171.3 84.7c-6.2-6.2-16.4-6.2-22.6 0l-128 128c-4.6 4.6-5.9 11.5-3.5 17.4S25.5 240 32 240l72 0c4.4 0 8 3.6 8 8l0 280c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-280c0-4.4 3.6-8 8-8l72 0c6.5 0 12.3-3.9 14.8-9.9s1.1-12.9-3.5-17.4l-128-128zM137.4 73.4c12.5-12.5 32.8-12.5 45.3 0l128 128c9.2 9.2 11.9 22.9 6.9 34.9S300.9 256 288 256l-64 0 0 272c0 26.5-21.5 48-48 48l-32 0c-26.5 0-48-21.5-48-48l0-272-64 0c-12.9 0-24.6-7.8-29.6-19.8S.2 210.5 9.4 201.4l128-128zM312-64c4.4 0 8 3.6 8 8s-3.6 8-8 8L8-48c-4.4 0-8-3.6-8-8s3.6-8 8-8l304 0z"]],
    "up-to-line": [384, 512, ["arrow-alt-to-top"], "f34d", ["M40.6 299.1c1.2 3 4.2 4.9 7.4 4.9l88 0c4.4 0 8 3.6 8 8 0 46.7 0 97.3 0 152 0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-152c0-4.4 3.6-8 8-8l88 0c3.2 0 6.2-1.9 7.4-4.9s.6-6.4-1.7-8.7l-144-144c-3.1-3.1-8.2-3.1-11.3 0l-144 144c-2.3 2.3-3 5.7-1.7 8.7z", "M0 8c0 4.4 3.6 8 8 8l368 0c4.4 0 8-3.6 8-8s-3.6-8-8-8L8 0C3.6 0 0 3.6 0 8zM186.3 146.3c3.1-3.1 8.2-3.1 11.3 0l144 144c2.3 2.3 3 5.7 1.7 8.7s-4.2 4.9-7.4 4.9l-88 0c-4.4 0-8 3.6-8 8l0 152c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-80 0 0 0-72c0-4.4-3.6-8-8-8l-88 0c-3.2 0-6.2-1.9-7.4-4.9s-.6-6.4 1.7-8.7l144-144zM128 384l0 0 0 80c0 26.5 21.5 48 48 48l32 0c26.5 0 48-21.5 48-48l0-144 80 0c9.7 0 18.5-5.8 22.2-14.8s1.7-19.3-5.2-26.2L209 135c-9.4-9.4-24.6-9.4-33.9 0L31 279c-6.9 6.9-8.9 17.2-5.2 26.2S38.3 320 48 320l80 0 0 64z"]],
    "plane-arrival": [576, 512, [128748], "f5af", ["M35.5 98.4L52.4 224.2c3.2 24.2 21.8 43.5 45.8 47.7l9.1 1.6c44.6 7.9 144.5 25.5 299.4 52.8l94.5 16.7c21.8 3.8 42.5-10.7 46.3-32.4s-10.7-42.5-32.4-46.3L404.8 244.7c-2.2-.4-4.2-1.7-5.4-3.6L261.3 24.5 196.9 13.1 225 202.3c.4 2.5-.5 5.1-2.3 6.9s-4.4 2.6-7 2.1l-94.5-16.7c-2.4-.4-4.5-1.9-5.6-4l-47.3-86.5-32.7-5.8zM208 384a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm96 16a16 16 0 1 0 32 0 16 16 0 1 0 -32 0z", "M547.5 310.5c-3.8 21.8-24.6 36.3-46.3 32.4-44.6-7.9-144.4-25.5-299.4-52.8l-94.5-16.7-9.1-1.6c-24-4.2-42.5-23.5-45.8-47.7l-16.9-125.8 32.7 5.8 47.3 86.5c1.2 2.1 3.2 3.6 5.6 4l94.5 16.7c2.5 .4 5.1-.4 7-2.1s2.7-4.4 2.3-6.9L196.9 13.1 261.3 24.5 399.4 241.1c1.2 1.9 3.1 3.2 5.4 3.6l110.3 19.4c21.8 3.8 36.3 24.6 32.4 46.3zm-443-21.3c44.6 7.9 144.5 25.5 299.4 52.8l94.5 16.7c30.5 5.4 59.5-15 64.9-45.4s-15-59.5-45.4-64.9L411 229.6 272.9 12.9c-1.2-1.9-3.1-3.2-5.4-3.6L188.8-4.6c-2.5-.4-5.1 .4-7 2.1s-2.7 4.4-2.3 6.9l28.1 189.2-79.8-14.1-47.3-86.5c-1.2-2.1-3.2-3.6-5.6-4L27.5 80.7c-2.5-.4-5.1 .3-6.9 2.1s-2.7 4.3-2.4 6.8L36.6 226.3c4.2 31.1 28 55.9 58.9 61.3l9.1 1.6zM208 384a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm48 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm64 0a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm0 48a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM8 496c-4.4 0-8 3.6-8 8s3.6 8 8 8l560 0c4.4 0 8-3.6 8-8s-3.6-8-8-8L8 496z"]],
    "pot-food": [640, 512, [127858], "e43f", ["M82 256.9l1.6 27.3c4.5 77.3 50.9 142.7 116.4 174.7 4.5 2.2 7.7 6.4 8.7 11.3 2.9 14.7 15.9 25.8 31.4 25.8l160 0c15.5 0 28.5-11.1 31.4-25.8 1-4.9 4.2-9.1 8.7-11.3 65.5-32 111.8-97.4 116.4-174.7l1.6-27.3c.5-9.2-6.8-16.9-16-16.9L97.9 240c-9.2 0-16.5 7.7-16 16.9zM341.5 192l181.1 0c-13.2-37.3-48.7-64-90.5-64s-77.4 26.7-90.5 64z", "M112 8c0-4.4-3.6-8-8-8s-8 3.6-8 8c0 27.4 5.1 46.4 13.3 61.1 8 14.4 18.6 23.9 28.3 32.6l.3 .3c9.9 8.9 18.7 16.9 25.3 28.7 6.5 11.7 11.2 27.9 11.2 53.3 0 4.4 3.6 8 8 8s8-3.6 8-8c0-27.4-5.1-46.4-13.3-61.1-8-14.4-18.6-23.9-28.3-32.6l-.3-.3c-9.9-8.9-18.7-16.9-25.3-28.7-6.5-11.7-11.2-27.9-11.2-53.3zm97.6 0c0-4.4-3.6-8-8-8s-8 3.6-8 8c0 27.4 5.1 46.4 13.3 61.1 8 14.4 18.6 23.9 28.3 32.6l.3 .3c9.9 8.9 18.7 16.9 25.3 28.7 6.5 11.7 11.2 27.9 11.2 53.3 0 4.4 3.6 8 8 8s8-3.6 8-8c0-27.4-5.1-46.4-13.3-61.1-8-14.4-18.6-23.9-28.3-32.6l-.3-.3c-9.9-8.9-18.7-16.9-25.3-28.7-6.5-11.7-11.2-27.9-11.2-53.3zM32 256c-4.4 0-8 3.6-8 8s3.6 8 8 8l34.8 0 .8 13.2c4.9 83.3 54.8 153.7 125.3 188.2 4.3 22 23.8 38.7 47.1 38.7l160 0c23.3 0 42.8-16.6 47.1-38.7 70.5-34.5 120.4-104.9 125.3-188.2l.8-13.2 34.8 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-33.9 0c0-17.5-14.2-32-32-32L97.9 224c-17.8 0-32 14.5-32 32L32 256zm490.5-64l16.8 0c-13.8-46.3-56.6-80-107.4-80s-93.6 33.7-107.4 80l16.8 0c13.2-37.3 48.7-64 90.5-64s77.4 26.7 90.5 64zM208.6 470.2c-1-4.9-4.2-9.1-8.7-11.3-65.5-32-111.8-97.4-116.4-174.7L82 256.9c-.5-9.2 6.8-16.9 16-16.9l444.1 0c9.2 0 16.5 7.7 16 16.9l-1.6 27.3c-4.5 77.3-50.9 142.7-116.4 174.7-4.5 2.2-7.7 6.4-8.7 11.3-2.9 14.7-15.9 25.8-31.4 25.8l-160 0c-15.5 0-28.5-11.1-31.4-25.8z"]],
    "cash-register": [512, 512, [], "f788", ["M16 400l0 48c0 26.5 21.5 48 48 48l384 0c26.5 0 48-21.5 48-48l0-48-480 0zm.5-18.2c-.1 .7-.2 1.5-.3 2.2l479.6 0c-.1-.7-.2-1.5-.3-2.2L472 217.2c-3.4-23.6-23.6-41.2-47.5-41.2l-337 0c-23.9 0-44.1 17.6-47.5 41.2L16.5 381.8zM128 240a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm48 80a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm48-80a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm48 80a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm48-80a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm48 80a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm48-80a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M96 16C69.5 16 48 37.5 48 64s21.5 48 48 48l160 0c26.5 0 48-21.5 48-48s-21.5-48-48-48L96 16zM256 128l-72 0 0 32 240.5 0c31.8 0 58.9 23.4 63.4 54.9l23.5 164.5c.4 3 .6 6 .6 9l0 59.5c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64l0-59.5c0-3 .2-6.1 .6-9L24.2 214.9C28.7 183.4 55.7 160 87.5 160l80.5 0 0-32-72 0c-35.3 0-64-28.7-64-64S60.7 0 96 0L256 0c35.3 0 64 28.7 64 64s-28.7 64-64 64zm-88 48l-80.5 0c-23.9 0-44.1 17.6-47.5 41.2L16.5 381.8c-.1 .7-.2 1.5-.3 2.2l479.6 0c-.1-.7-.2-1.5-.3-2.2L472 217.2c-3.4-23.6-23.6-41.2-47.5-41.2L168 176zM16 400l0 48c0 26.5 21.5 48 48 48l384 0c26.5 0 48-21.5 48-48l0-48-480 0zM128 240a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm80 16a16 16 0 1 1 0-32 16 16 0 1 1 0 32zm-32 64a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm128-64a16 16 0 1 1 0-32 16 16 0 1 1 0 32zm-32 64a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm128-64a16 16 0 1 1 0-32 16 16 0 1 1 0 32zm-32 64a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zM96 56l160 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L96 72c-4.4 0-8-3.6-8-8s3.6-8 8-8z"]],
    "ring": [512, 512, [], "f70b", ["M16 192c0 18.7 10.5 37.3 30.4 53.9 9.2-6.6 19.6-12.6 30.8-18 46.2-22.3 109.4-35.9 178.8-35.9s132.7 13.6 178.8 35.9c11.2 5.4 21.5 11.4 30.8 18 19.9-16.6 30.4-35.2 30.4-53.9 0-28.3-24-56.3-68.1-77.7-43.6-21.1-104.3-34.3-171.9-34.3S127.7 93.3 84.1 114.3C40 135.7 16 163.7 16 192zm0 45.2l0 83.3c0 28.2 24 56 68.1 77.3 43.6 21 104.3 34.2 171.9 34.2s128.3-13.2 171.9-34.2C472 376.5 496 348.7 496 320.5l0-83.3c-13.6 18.4-35.1 34.2-61.2 46.8-46.2 22.3-109.4 35.9-178.8 35.9S123.3 306.4 77.2 284.1C51.1 271.4 29.6 255.6 16 237.2z", "M84.1 114.3C127.7 93.3 188.5 80 256 80s128.3 13.3 171.9 34.3c44.1 21.4 68.1 49.3 68.1 77.7 0 18.7-10.5 37.3-30.4 53.9-9.2-6.6-19.6-12.6-30.8-18-46.2-22.3-109.4-35.9-178.8-35.9S123.3 205.6 77.2 227.9c-11.2 5.4-21.5 11.4-30.8 18-19.9-16.6-30.4-35.2-30.4-53.9 0-28.3 24-56.3 68.1-77.7zM511.5 184C507.4 149.6 477.2 120.5 434.8 99.9 388.7 77.6 325.4 64 256 64S123.3 77.6 77.2 99.9C34.8 120.5 4.6 149.6 .5 184L0 184 0 320.5c0 37.8 31.6 69.7 77.2 91.7 46.2 22.2 109.4 35.8 178.8 35.8s132.7-13.5 178.8-35.8c45.6-22 77.2-53.9 77.2-91.7l0-136.5-.5 0zM496 237.2l0 83.3c0 28.2-24 56-68.1 77.3-43.6 21-104.3 34.2-171.9 34.2S127.7 418.8 84.1 397.8C40 376.5 16 348.7 16 320.5l0-83.3c13.6 18.4 35.1 34.2 61.2 46.8 46.2 22.3 109.4 35.9 178.8 35.9s132.7-13.6 178.8-35.9c26.1-12.6 47.5-28.5 61.2-46.8zM84.1 269.7c-8.9-4.3-17-8.9-24.2-13.7 7.2-4.8 15.3-9.4 24.2-13.7 43.6-21.1 104.3-34.3 171.9-34.3s128.3 13.3 171.9 34.3c8.9 4.3 17 8.9 24.2 13.7-7.2 4.8-15.3 9.4-24.2 13.7-43.6 21.1-104.3 34.3-171.9 34.3S127.7 290.7 84.1 269.7z"]],
    "message-xmark": [512, 512, ["comment-alt-times", "message-times"], "f4ab", ["M16 128l0 224c0 44.2 35.8 80 80 80l32 0c8.8 0 16 7.2 16 16l0 75.9c0 2.3 2 4 4.1 4.1 .8 0 1.7-.2 2.4-.7 3.3-2.3 6.3-4.5 9.1-6.4l.4-.3c6.7-4.7 30.4-21.5 117.2-82.7 5.4-3.8 11.8-5.9 18.5-5.9L416 432c44.2 0 80-35.8 80-80l0-224c0-44.2-35.8-80-80-80L96 48c-44.2 0-80 35.8-80 80zm174.8 46.8c3.1-3.1 8.2-3.1 11.3 0l53.8 53.8 53.8-53.8c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3l-53.8 53.8 53.8 53.8c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-53.8-53.8-53.8 53.8c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l53.8-53.8-53.8-53.8c-3.1-3.1-3.1-8.2 0-11.3z", "M144 448l0 75.9c0 2.3 2 4 4.1 4.1 .8 0 1.7-.2 2.4-.7 3.3-2.3 6.3-4.5 9.1-6.4l.4-.3c6.7-4.7 30.4-21.5 117.2-82.7 5.4-3.8 11.8-5.9 18.5-5.9L416 432c44.2 0 80-35.8 80-80l0-224c0-44.2-35.8-80-80-80L96 48c-44.2 0-80 35.8-80 80l0 224c0 44.2 35.8 80 80 80l32 0c8.8 0 16 7.2 16 16zM0 128C0 75 43 32 96 32l320 0c53 0 96 43 96 96l0 224c0 53-43 96-96 96l-120.4 0c-3.3 0-6.5 1-9.2 2.9L159.8 540.3c-3.4 2.4-7.5 3.7-11.6 3.7-11.1 0-20.1-9-20.1-20.1l0-75.9-32 0c-53 0-96-43-96-96L0 128zM190.8 293.8l53.8-53.8-53.8-53.8c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0l53.8 53.8 53.8-53.8c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3l-53.8 53.8 53.8 53.8c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-53.8-53.8-53.8 53.8c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3z"]],
    "share-nodes": [512, 512, ["share-alt"], "f1e0", ["M29.3 256a66.7 66.7 0 1 0 133.3 0 66.7 66.7 0 1 0 -133.3 0zm288-160a66.7 66.7 0 1 0 133.3 0 66.7 66.7 0 1 0 -133.3 0zm0 320a66.7 66.7 0 1 0 133.3 0 66.7 66.7 0 1 0 -133.3 0z", "M450.7 96a66.7 66.7 0 1 0 -133.3 0 66.7 66.7 0 1 0 133.3 0zM464 96c0 44.2-35.8 80-80 80-27.2 0-51.3-13.6-65.7-34.3L169.5 224.3c4.2 9.7 6.5 20.4 6.5 31.7s-2.3 22-6.5 31.7l148.8 82.7c14.5-20.8 38.5-34.3 65.7-34.3 44.2 0 80 35.8 80 80s-35.8 80-80 80-80-35.8-80-80c0-11.3 2.3-22 6.5-31.7L161.7 301.7c-14.5 20.8-38.5 34.3-65.7 34.3-44.2 0-80-35.8-80-80s35.8-80 80-80c27.2 0 51.3 13.6 65.7 34.3l148.8-82.7c-4.2-9.7-6.5-20.4-6.5-31.7 0-44.2 35.8-80 80-80s80 35.8 80 80zM162.7 256a66.7 66.7 0 1 0 -133.3 0 66.7 66.7 0 1 0 133.3 0zM384 482.7a66.7 66.7 0 1 0 0-133.3 66.7 66.7 0 1 0 0 133.3z"]],
    "octagon-divide": [512, 512, [], "e203", ["M16.5 181.6l0 148.8c0 8.5 3.4 16.6 9.4 22.6L159.4 486.6c6 6 14.1 9.4 22.6 9.4l148.8 0c8.5 0 16.6-3.4 22.6-9.4L487 353c6-6 9.4-14.1 9.4-22.6l0-148.8c0-8.5-3.4-16.6-9.4-22.6L353.5 25.4c-6-6-14.1-9.4-22.6-9.4L182 16.1c-8.5 0-16.6 3.4-22.6 9.4L25.9 159c-6 6-9.4 14.1-9.4 22.6zM144.4 256c0-4.4 3.6-8 8-8l208 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-208 0c-4.4 0-8-3.6-8-8zm144-96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm0 192a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M159.4 25.4c6-6 14.1-9.4 22.6-9.4l148.8 0c8.5 0 16.6 3.4 22.6 9.4L487 159c6 6 9.4 14.1 9.4 22.6l0 148.8c0 8.5-3.4 16.6-9.4 22.6L353.5 486.6c-6 6-14.1 9.4-22.6 9.4l-148.8 0c-8.5 0-16.6-3.4-22.6-9.4L25.9 353c-6-6-9.4-14.1-9.4-22.6l0-148.8c0-8.5 3.4-16.6 9.4-22.6L159.4 25.4zM182 .1c-12.7 0-24.9 5.1-33.9 14.1L14.6 147.6c-9 9-14.1 21.2-14.1 33.9l0 148.8c0 12.7 5.1 24.9 14.1 33.9L148.1 497.9c9 9 21.2 14.1 33.9 14.1l148.8 0c12.7 0 24.9-5.1 33.9-14.1L498.3 364.4c9-9 14.1-21.2 14.1-33.9l0-148.8c0-12.7-5.1-24.9-14.1-33.9L364.8 14.1c-9-9-21.2-14.1-33.9-14.1L182 .1zM240.4 160a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm48 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm-136 88c-4.4 0-8 3.6-8 8s3.6 8 8 8l208 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-208 0zm104 88a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm0 48a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]],
    "folder-arrow-up": [512, 512, ["folder-upload"], "e054", ["M16 96l0 288c0 26.5 21.5 48 48 48l384 0c26.5 0 48-21.5 48-48l0-240c0-26.5-21.5-48-48-48L298.7 96c-10.4 0-20.5-3.4-28.8-9.6L231.5 57.6c-8.3-6.2-18.4-9.6-28.8-9.6L64 48C37.5 48 16 69.5 16 96zM178.3 242.3l72-72c3.1-3.1 8.2-3.1 11.3 0l72 72c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L264 195.3 264 352c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-156.7-58.3 58.3c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3z", "M496 384c0 26.5-21.5 48-48 48L64 432c-26.5 0-48-21.5-48-48L16 96c0-26.5 21.5-48 48-48l138.7 0c10.4 0 20.5 3.4 28.8 9.6l38.4 28.8c8.3 6.2 18.4 9.6 28.8 9.6L448 96c26.5 0 48 21.5 48 48l0 240zM64 448l384 0c35.3 0 64-28.7 64-64l0-240c0-35.3-28.7-64-64-64L298.7 80c-6.9 0-13.7-2.2-19.2-6.4L241.1 44.8C230 36.5 216.5 32 202.7 32L64 32C28.7 32 0 60.7 0 96L0 384c0 35.3 28.7 64 64 64zM261.7 170.3c-3.1-3.1-8.2-3.1-11.3 0l-72 72c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L248 195.3 248 352c0 4.4 3.6 8 8 8s8-3.6 8-8l0-156.7 58.3 58.3c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-72-72z"]],
    "arrows-minimize": [448, 512, ["compress-arrows"], "e0a5", ["", "M2.3 34.3c3.1-3.1 8.2-3.1 11.3 0L176 196.7 176 88c0-4.4 3.6-8 8-8s8 3.6 8 8l0 128c0 4.4-3.6 8-8 8L56 224c-4.4 0-8-3.6-8-8s3.6-8 8-8L164.7 208 2.3 45.7c-3.1-3.1-3.1-8.2 0-11.3zm443.3 0c3.1 3.1 3.1 8.2 0 11.3L283.3 208 392 208c4.4 0 8 3.6 8 8s-3.6 8-8 8l-128 0c-4.4 0-8-3.6-8-8l0-128c0-4.4 3.6-8 8-8s8 3.6 8 8l0 108.7 162.3-162.3c3.1-3.1 8.2-3.1 11.3 0zM56 304c-4.4 0-8-3.6-8-8s3.6-8 8-8l128 0c4.4 0 8 3.6 8 8l0 128c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-108.7-162.3 162.3c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3L164.7 304 56 304zm200-8c0-4.4 3.6-8 8-8l128 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-108.7 0 162.3 162.3c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L272 315.3 272 424c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-128z"]],
    "person-circle-exclamation": [640, 512, [], "e53f", ["M66.8 271l64.1-93.8c21-30.8 55.9-49.1 93.1-49.1s72.1 18.4 93.1 49.1l53.1 77.8c-8.2 7.1-15.8 15-22.8 23.4l-44.9-65.7c-2-2.9-5.6-4.2-9-3.1s-5.6 4.1-5.6 7.6L288 512c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-144c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 144c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-294.8c0-3.5-2.3-6.6-5.6-7.6s-7 .2-9 3.1L93.2 289c-5 7.3-14.9 9.2-22.2 4.2s-9.2-14.9-4.2-22.2zM264 24a40 40 0 1 1 -80 0 40 40 0 1 1 80 0z", "M184 24a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zm96 0a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zM130.9 177.1c21-30.8 55.9-49.1 93.1-49.1s72.1 18.4 93.1 49.1l53.1 77.8c4-3.5 8.2-6.8 12.5-10l-52.5-76.8C306.3 133 266.5 112 224 112s-82.3 21-106.3 56.1L53.6 261.9c-10 14.6-6.2 34.5 8.4 44.5s34.5 6.2 44.5-8.4l37.6-55 0 268.9c0 17.7 14.3 32 32 32s32-14.3 32-32l0-144c0-8.8 7.2-16 16-16s16 7.2 16 16l0 144c0 17.7 14.3 32 32 32s32-14.3 32-32l0-268.9 33.3 48.8c3.2-4.7 6.6-9.2 10.1-13.5l-44.9-65.7c-2-2.9-5.6-4.2-9-3.1s-5.6 4.1-5.6 7.6L288 512c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-144c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 144c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-294.8c0-3.5-2.3-6.6-5.6-7.6s-7 .2-9 3.1L93.2 289c-5 7.3-14.9 9.2-22.2 4.2s-9.2-14.9-4.2-22.2l64.1-93.8zM368 400a128 128 0 1 1 256 0 128 128 0 1 1 -256 0zm272 0a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zM496 476a12 12 0 1 0 0-24 12 12 0 1 0 0 24zm0-164c-4.4 0-8 3.6-8 8l0 96c0 4.4 3.6 8 8 8s8-3.6 8-8l0-96c0-4.4-3.6-8-8-8z"]],
    "binoculars": [512, 512, [], "f1e5", ["M16 356.9L16 432c0 17.7 14.3 32 32 32l128 0c17.7 0 32-14.3 32-32l0-312c0-4.4-3.6-8-8-8l-93.6 0c-16.1 0-29.8 12-31.8 28l-5.7 45.9c-3.6 28.6-13.1 56.2-27.9 80.9-16.3 27.2-25 58.4-25 90.1zM112 64l0 32 80 0 0-32c0-8.8-7.2-16-16-16l-48 0c-8.8 0-16 7.2-16 16zm112 80l0 128 64 0 0-128-64 0zm80-24l0 312c0 17.7 14.3 32 32 32l128 0c17.7 0 32-14.3 32-32l0-75.1c0-31.7-8.6-62.9-25-90.1-14.8-24.7-24.3-52.3-27.9-80.9L437.4 140c-2-16-15.6-28-31.8-28L312 112c-4.4 0-8 3.6-8 8zm16-56l0 32 80 0 0-32c0-8.8-7.2-16-16-16l-48 0c-8.8 0-16 7.2-16 16z", "M128 48c-8.8 0-16 7.2-16 16l0 32 80 0 0-32c0-8.8-7.2-16-16-16l-48 0zM96 97.1L96 64c0-17.7 14.3-32 32-32l48 0c17.7 0 32 14.3 32 32l0 33.4c9.3 3.3 16 12.2 16 22.6l0 8 64 0 0-8c0-10.4 6.7-19.3 16-22.6L304 64c0-17.7 14.3-32 32-32l48 0c17.7 0 32 14.3 32 32l0 33.1c19.5 4.3 34.7 20.4 37.3 40.9L459 184c3.3 26.4 12.1 51.8 25.8 74.6 17.8 29.7 27.2 63.7 27.2 98.3l0 75.1c0 26.5-21.5 48-48 48l-128 0c-26.5 0-48-21.5-48-48l0-144-64 0 0 144c0 26.5-21.5 48-48 48L48 480c-26.5 0-48-21.5-48-48l0-75.1c0-34.6 9.4-68.6 27.2-98.3 13.7-22.8 22.5-48.2 25.8-74.6L58.7 138c2.6-20.5 17.8-36.6 37.3-40.9zM106.4 112c-16.1 0-29.8 12-31.8 28l-5.7 45.9c-3.6 28.6-13.1 56.2-27.9 80.9-16.3 27.2-25 58.4-25 90.1L16 432c0 17.7 14.3 32 32 32l128 0c17.7 0 32-14.3 32-32l0-312c0-4.4-3.6-8-8-8l-93.6 0zm299.3 0L312 112c-4.4 0-8 3.6-8 8l0 312c0 17.7 14.3 32 32 32l128 0c17.7 0 32-14.3 32-32l0-75.1c0-31.7-8.6-62.9-25-90.1-14.8-24.7-24.3-52.3-27.9-80.9L437.4 140c-2-16-15.6-28-31.8-28zM320 96l80 0 0-32c0-8.8-7.2-16-16-16l-48 0c-8.8 0-16 7.2-16 16l0 32zM224 272l64 0 0-128-64 0 0 128z"]],
    "grid-round-5": [448, 512, [], "e5de", ["", "M28 72a12 12 0 1 0 0-24 12 12 0 1 0 0 24zM56 60A28 28 0 1 1 0 60 28 28 0 1 1 56 60zM16 158a12 12 0 1 0 24 0 12 12 0 1 0 -24 0zm12 28a28 28 0 1 1 0-56 28 28 0 1 1 0 56zm0 82a12 12 0 1 0 0-24 12 12 0 1 0 0 24zm28-12a28 28 0 1 1 -56 0 28 28 0 1 1 56 0zM16 354a12 12 0 1 0 24 0 12 12 0 1 0 -24 0zm12 28a28 28 0 1 1 0-56 28 28 0 1 1 0 56zM16 452c0 6.6 5.4 12 12 12s12-5.4 12-12-5.4-12-12-12-12 5.4-12 12zm12-28c15.5 0 28 12.5 28 28s-12.5 28-28 28-28-12.5-28-28 12.5-28 28-28zm86 28c0 6.6 5.4 12 12 12s12-5.4 12-12-5.4-12-12-12-12 5.4-12 12zm12-28c15.5 0 28 12.5 28 28s-12.5 28-28 28-28-12.5-28-28 12.5-28 28-28zm98 40c6.6 0 12-5.4 12-12s-5.4-12-12-12-12 5.4-12 12 5.4 12 12 12zm-28-12c0-15.5 12.5-28 28-28s28 12.5 28 28-12.5 28-28 28-28-12.5-28-28zm114 0c0 6.6 5.4 12 12 12s12-5.4 12-12-5.4-12-12-12-12 5.4-12 12zm12-28c15.5 0 28 12.5 28 28s-12.5 28-28 28-28-12.5-28-28 12.5-28 28-28zm98 40c6.6 0 12-5.4 12-12s-5.4-12-12-12-12 5.4-12 12 5.4 12 12 12zm-28-12c0-15.5 12.5-28 28-28s28 12.5 28 28-12.5 28-28 28-28-12.5-28-28zM126 366a12 12 0 1 0 0-24 12 12 0 1 0 0 24zm28-12a28 28 0 1 1 -56 0 28 28 0 1 1 56 0zm58 0a12 12 0 1 0 24 0 12 12 0 1 0 -24 0zm12 28a28 28 0 1 1 0-56 28 28 0 1 1 0 56zm98-16a12 12 0 1 0 0-24 12 12 0 1 0 0 24zm28-12a28 28 0 1 1 -56 0 28 28 0 1 1 56 0zm58 0a12 12 0 1 0 24 0 12 12 0 1 0 -24 0zm12 28a28 28 0 1 1 0-56 28 28 0 1 1 0 56zM114 256a12 12 0 1 0 24 0 12 12 0 1 0 -24 0zm12 28a28 28 0 1 1 0-56 28 28 0 1 1 0 56zm98-16a12 12 0 1 0 0-24 12 12 0 1 0 0 24zm28-12a28 28 0 1 1 -56 0 28 28 0 1 1 56 0zm58 0a12 12 0 1 0 24 0 12 12 0 1 0 -24 0zm12 28a28 28 0 1 1 0-56 28 28 0 1 1 0 56zm98-16a12 12 0 1 0 0-24 12 12 0 1 0 0 24zm28-12a28 28 0 1 1 -56 0 28 28 0 1 1 56 0zM126 170a12 12 0 1 0 0-24 12 12 0 1 0 0 24zm28-12a28 28 0 1 1 -56 0 28 28 0 1 1 56 0zm58 0a12 12 0 1 0 24 0 12 12 0 1 0 -24 0zm12 28a28 28 0 1 1 0-56 28 28 0 1 1 0 56zm98-16a12 12 0 1 0 0-24 12 12 0 1 0 0 24zm28-12a28 28 0 1 1 -56 0 28 28 0 1 1 56 0zm58 0a12 12 0 1 0 24 0 12 12 0 1 0 -24 0zm12 28a28 28 0 1 1 0-56 28 28 0 1 1 0 56zM114 60a12 12 0 1 0 24 0 12 12 0 1 0 -24 0zm12 28a28 28 0 1 1 0-56 28 28 0 1 1 0 56zm98-16a12 12 0 1 0 0-24 12 12 0 1 0 0 24zm28-12a28 28 0 1 1 -56 0 28 28 0 1 1 56 0zm58 0a12 12 0 1 0 24 0 12 12 0 1 0 -24 0zm12 28a28 28 0 1 1 0-56 28 28 0 1 1 0 56zm98-16a12 12 0 1 0 0-24 12 12 0 1 0 0 24zm28-12a28 28 0 1 1 -56 0 28 28 0 1 1 56 0z"]],
    "kip-sign": [384, 512, [], "e1c4", ["", "M88 32c4.4 0 8 3.6 8 8L96 238.8 338.8 33.9c3.4-2.8 8.4-2.4 11.3 1s2.4 8.4-1 11.3L109.9 248 376 248c4.4 0 8 3.6 8 8s-3.6 8-8 8l-266.1 0 239.3 201.9c3.4 2.9 3.8 7.9 1 11.3s-7.9 3.8-11.3 1L96 273.2 96 473c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-209-72 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l72 0 0-208c0-4.4 3.6-8 8-8z"]],
    "hard-drive": [448, 512, [128436, "hdd"], "f0a0", ["M16 96l0 213.7C27.7 296.4 44.9 288 64 288l320 0c19.1 0 36.3 8.4 48 21.7L432 96c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96zm0 256l0 64c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-64c0-26.5-21.5-48-48-48L64 304c-26.5 0-48 21.5-48 48zm272 32a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm96 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M64 48C37.5 48 16 69.5 16 96l0 213.7C27.7 296.4 44.9 288 64 288l320 0c19.1 0 36.3 8.4 48 21.7L432 96c0-26.5-21.5-48-48-48L64 48zM16 352l0 64c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-64c0-26.5-21.5-48-48-48L64 304c-26.5 0-48 21.5-48 48zM0 352L0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64l0-64zm256 16a16 16 0 1 0 0 32 16 16 0 1 0 0-32zm32 16a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm48 0a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm16 32a32 32 0 1 1 0-64 32 32 0 1 1 0 64z"]],
    "ranking-star": [512, 512, [], "e561", ["M16 368l0 96c0 17.7 14.3 32 32 32l112 0 0-160-112 0c-17.7 0-32 14.3-32 32zm160-64l0 192 160 0 0-192c0-17.7-14.3-32-32-32l-96 0c-17.7 0-32 14.3-32 32zm12.5-199.1l30.1 30.2c1.8 1.8 2.6 4.4 2.2 6.9l-6.7 42.1 38-19.3 1.8-.7c1.8-.4 3.8-.2 5.5 .7l37.9 19.3-6.6-42.1c-.4-2.5 .4-5.1 2.2-6.9l30.1-30.2-42.1-6.7c-2.5-.4-4.7-2-5.9-4.3l-19.3-38-19.3 38c-1.2 2.3-3.4 3.8-5.9 4.3l-42.1 6.7zM352 368l0 128 112 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-112 0z", "M304 256c26.5 0 48 21.5 48 48l0 48 112 0 4.9 .2c24.2 2.5 43.1 22.9 43.1 47.8l0 64-.2 4.9c-2.3 22.6-20.3 40.6-42.8 42.8l-4.9 .2-416 0-4.9-.2C18.9 509.3 0 488.8 0 464l0-96c0-24.9 18.9-45.3 43.1-47.8l4.9-.2 112 0 0-16c0-26.5 21.5-48 48-48l96 0zM48 336c-17.7 0-32 14.3-32 32l0 96c0 17.7 14.3 32 32 32l112 0 0-160-112 0zm160-64c-17.7 0-32 14.3-32 32l0 192 160 0 0-192c0-17.7-14.3-32-32-32l-96 0zM352 496l112 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-112 0 0 128zM255.8 30.4c3 0 5.8 1.7 7.1 4.4l24.6 48.3 53.5 8.5c3 .5 5.4 2.6 6.3 5.4s.2 6-1.9 8.1l-38.3 38.4 8.4 53.6c.5 3-.8 6-3.2 7.7s-5.7 2-8.3 .7l-48.3-24.6-48.3 24.6c-2.7 1.4-5.9 1.1-8.3-.7s-3.7-4.8-3.2-7.7l8.4-53.6-38.2-38.4c-2.1-2.1-2.9-5.3-1.9-8.1s3.4-4.9 6.3-5.4l53.5-8.5 24.7-48.3 1.2-1.8c1.5-1.6 3.6-2.6 5.9-2.6zM236.5 94c-1.2 2.3-3.4 3.8-5.9 4.3l-42.1 6.7 30.1 30.2c1.8 1.8 2.6 4.4 2.2 6.9l-6.7 42.1 38-19.3 1.8-.7c1.8-.4 3.8-.2 5.5 .7l37.9 19.3-6.6-42.1c-.4-2.5 .4-5.1 2.2-6.9l30.1-30.2-42.1-6.7c-2.5-.4-4.7-2-5.9-4.3l-19.3-38-19.3 38z"]],
    "user-tie": [448, 512, [], "f508", ["M8 512l216 0c-2.8 0-5.3-1.4-6.8-3.8L108.9 334.7C54 360.1 16 415.6 16 480l0 24c0 4.4-3.6 8-8 8zM112 128a112 112 0 1 0 224 0 112 112 0 1 0 -224 0zm80 198.6c0 1.9 .8 3.8 2.3 5l29.7 25.7 29.7-25.7c1.5-1.3 2.3-3.1 2.3-5 0-3.7-3-6.6-6.6-6.6l-50.7 0c-3.7 0-6.6 3-6.6 6.6zm2.3 114.7l29.7 47.6 29.7-47.6-3-8.9-26.7-48-26.7 48-3 8.8zM224 512l216 0c-4.4 0-8-3.6-8-8l0-24c0-64.4-38-119.9-92.9-145.3L230.8 508.2c-1.5 2.3-4 3.8-6.8 3.8z", "M224 16a112 112 0 1 1 0 224 112 112 0 1 1 0-224zM96 128a128 128 0 1 0 256 0 128 128 0 1 0 -256 0zM198.6 304c-12.5 0-22.6 10.1-22.6 22.6 0 6.6 2.9 12.8 7.8 17.1l30 26-30.2 54.4-64.8-103.8c-2.1-3.3-6.2-4.6-9.8-3.2-63.9 26.4-109 89.3-109 162.8l0 24c0 4.4 3.6 8 8 8s8-3.6 8-8l0-24c0-64.4 38-119.9 92.9-145.3L217.2 508.2c1.5 2.3 4 3.8 6.8 3.8s5.3-1.4 6.8-3.8L339.1 334.7C394 360.1 432 415.6 432 480l0 24c0 4.4 3.6 8 8 8s8-3.6 8-8l0-24c0-73.5-45-136.4-109-162.8-3.6-1.5-7.8-.2-9.8 3.2l-64.8 103.8-30.2-54.4 30-26c5-4.3 7.8-10.5 7.8-17.1 0-12.5-10.1-22.6-22.6-22.6l-50.7 0zM224 488.9l-30.7-49.2 30.7-55.3 30.7 55.3-30.7 49.2zM192 326.6c0-3.7 3-6.6 6.6-6.6l50.7 0c3.7 0 6.6 3 6.6 6.6 0 1.9-.8 3.8-2.3 5l-29.7 25.7-29.7-25.7c-1.5-1.3-2.3-3.1-2.3-5z"]],
    "square-bitcoin": [448, 512, [], "e6f2", ["M16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96zm113.8 46.2c0-7.9 6.4-14.2 14.2-14.2l32 0 0-24c0-4.4 3.6-8 8-8s8 3.6 8 8l0 24 48 0 0-24c0-4.4 3.6-8 8-8s8 3.6 8 8l0 24 1.3 0c37.6 0 68 30.4 68 68 0 23-11.4 43.4-28.9 55.7 26.7 9.2 45.9 34.5 45.9 64.3 0 37.6-30.4 68-68 68l-18.2 0 0 24c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-24-48 0 0 24c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-24-30.8 0c-8.5 0-15.5-6.9-15.5-15.5l0-226.3zm16 1.8l0 104 111.5 0c28.7 0 52-23.3 52-52s-23.3-52-52-52l-111.5 0zm0 120l0 104 128.5 0c28.7 0 52-23.3 52-52s-23.3-52-52-52l-128.5 0z", "M64 48C37.5 48 16 69.5 16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm184 0c4.4 0 8 3.6 8 8l0 24 48 0 0-24c0-4.4 3.6-8 8-8s8 3.6 8 8l0 24 1.3 0c37.6 0 68 30.4 68 68 0 23-11.4 43.4-28.9 55.7 26.7 9.2 45.9 34.5 45.9 64.3 0 37.6-30.4 68-68 68l-18.2 0 0 24c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-24-48 0 0 24c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-24-30.8 0c-8.5 0-15.5-6.9-15.5-15.5l0-226.3c0-7.9 6.4-14.2 14.2-14.2l32 0 0-24c0-4.4 3.6-8 8-8zm90.2 272c28.7 0 52-23.3 52-52s-23.3-52-52-52l-128.5 0 0 104 128.5 0zM184 144l-38.2 0 0 104 111.5 0c28.7 0 52-23.3 52-52s-23.3-52-52-52L184 144z"]],
    "ellipsis": [448, 512, ["ellipsis-h"], "f141", ["", "M448 256a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm-208 0a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zM16 272a16 16 0 1 1 0-32 16 16 0 1 1 0 32z"]],
    "arrow-turn-down-left": [512, 512, [], "e2e1", ["", "M496 72c0-4.4 3.6-8 8-8s8 3.6 8 8l0 96c0 53-43 96-96 96L27.3 264 165.7 402.3c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-152-152c-3.1-3.1-3.1-8.2 0-11.3l152-152c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3L27.3 248 416 248c44.2 0 80-35.8 80-80l0-96z"]],
    "octagon-check": [512, 512, [], "e426", ["M16.5 181.6l0 148.8c0 8.5 3.4 16.6 9.4 22.6L159.4 486.6c6 6 14.1 9.4 22.6 9.4l148.8 0c8.5 0 16.6-3.4 22.6-9.4L487 353c6-6 9.4-14.1 9.4-22.6l0-148.8c0-8.5-3.4-16.6-9.4-22.6L353.5 25.4c-6-6-14.1-9.4-22.6-9.4L182 16.1c-8.5 0-16.6 3.4-22.6 9.4L25.9 158.9c-6 6-9.4 14.1-9.4 22.6zm130.3 92.8c3.1-3.1 8.2-3.1 11.3 0l65.4 65.4 130.4-179.3c2.6-3.6 7.6-4.3 11.2-1.7s4.4 7.6 1.8 11.2L230.9 356.7c-1.4 1.9-3.5 3.1-5.8 3.3s-4.6-.7-6.3-2.3l-72-72c-3.1-3.1-3.1-8.2 0-11.3z", "M330.9 .1c12.7 0 25 5.1 34 14.1L498.3 147.6c9 9 14.1 21.2 14.1 33.9l0 148.8c0 12.7-5.1 25-14.1 34L364.8 497.9c-9 9-21.2 14.1-34 14.1l-148.8 0c-12.7 0-24.9-5.1-33.9-14.1L14.6 364.4c-9-9-14.1-21.2-14.1-34l0-148.8c0-12.7 5.1-24.9 14.1-33.9L148.1 14.1c9-9 21.2-14.1 33.9-14.1l148.8 0zM182 16.1c-8.5 0-16.6 3.4-22.6 9.4L25.9 158.9c-6 6-9.4 14.1-9.4 22.6l0 148.8c0 8.5 3.4 16.6 9.4 22.6L159.4 486.6c6 6 14.1 9.4 22.6 9.4l148.8 0c8.5 0 16.6-3.4 22.6-9.4L487 353c6-6 9.4-14.1 9.4-22.6l0-148.8c0-8.5-3.4-16.6-9.4-22.6L353.5 25.4c-6-6-14.1-9.4-22.6-9.4L182 16.1zM353.9 160.4c2.6-3.6 7.6-4.3 11.2-1.7s4.4 7.6 1.8 11.2L230.9 356.7c-1.4 1.9-3.5 3.1-5.8 3.3s-4.6-.7-6.3-2.3l-72-72c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0l65.4 65.4 130.4-179.3z"]],
    "store-24": [576, 512, [], "e79b", ["", "M84.4 32C59.5 32 37.6 48.4 30.7 72.3L7.3 152.5c-8.5 29 3.1 58 25.1 74.3l0 181.2c0 39.8 32.2 72 72 72l168 0 0-16-168 0c-30.9 0-56-25.1-56-56l0-56 226 0c1.5-5.7 3.7-11 6.5-16l-232.6 0 0-100.5c7.5 2.9 15.8 4.5 24.5 4.5 26.3 0 49.4-14.9 60.8-37.1 11.6 21.9 34.6 37.1 61.4 37.1 26.6 0 49.7-15 61.3-37 11.6 22 34.7 37 61.3 37 26.8 0 49.8-15.1 61.4-37.1 11.4 22.1 34.5 37.1 60.8 37.1 8.7 0 16.9-1.6 24.5-4.5l0 68.5 16 0 0-77.2c22-16.3 33.6-45.3 25.1-74.3L482.2 72.3c-7-23.9-28.9-40.3-53.8-40.3l-344 0zM386.9 164.9L377.1 48 428.4 48c17.8 0 33.4 11.7 38.4 28.8L490.2 157c9.8 33.5-15.4 67-50.3 67-27.2 0-49.9-20.9-52.2-48l-.9-11 0-.1zM361.1 48l9.9 118.2c2.6 31.1-21.9 57.8-53.2 57.8-29.5 0-53.3-23.9-53.3-53.3l0-122.7 96.6 0zM151.8 48l96.6 0 0 122.7c0 29.5-23.9 53.3-53.3 53.3-31.2 0-55.7-26.7-53.2-57.7l0 0 9.9-118.2zm-16.1 0l-9.7 116.9 0 0-.9 11c-2.3 27.1-24.9 48-52.2 48-34.9 0-60-33.5-50.3-67L46 76.8C51 59.7 66.6 48 84.4 48l51.3 0zM328.4 408c0 4.4 3.6 8 8 8s8-3.6 8-8c0-13.3 10.7-24 24-24s24 10.7 24 24l0 1c0 7.7-2.8 15.2-8 21L331.9 489c-2.2 2.5-3.5 5.8-3.5 9.2 0 7.6 6.2 13.8 13.8 13.8l58.2 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-53.3 0 49.3-55.4c7.7-8.7 12-19.9 12-31.6l0-1c0-22.1-17.9-40-40-40s-40 17.9-40 40zm128 32c0 2.1 .8 4.2 2.3 5.7s3.5 2.3 5.7 2.3l56 0 0 56c0 4.4 3.6 8 8 8s8-3.6 8-8l0-128c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 56-48 0 0-56c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 64z"]],
    "store-slash": [576, 512, [], "e071", ["M96.5 53.1C102.3 49.8 109 48 116 48l51.3 0-5.8 70.1-65-65zm79.8 79.8l7.1-84.9 96.6 0 0 122.7c0 17.9-8.9 33.8-22.4 43.5l-81.3-81.3zM296 48l96.6 0 9.9 118.2c2.5 30.2-20.6 56.2-50.5 57.8-.9 0-1.8 0-2.7 0-29.5 0-53.3-23.9-53.3-53.3L296 48zm99.4 304l100.6 0 0 56c0 12.6-4.1 24.1-11.1 33.5L395.4 352zM408.7 48L460 48c17.8 0 33.4 11.7 38.4 28.8L521.8 157c9.8 33.5-15.4 67-50.3 67-27.2 0-49.9-20.9-52.2-48-.3-3.7-.6-7.3-.9-11.1L408.7 48z", "M13.7-29.8c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l560 560c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-77.4-77.4C506.1 440.6 512 425 512 408l0-181.2c22-16.3 33.6-45.3 25.1-74.3L513.8 72.3C506.8 48.4 484.9 32 460 32L116 32c-11.4 0-22.1 3.4-31.1 9.5L13.7-29.8zM96.5 53.1C102.3 49.8 109 48 116 48l51.3 0-5.8 70.1-65-65zm79.8 79.8l7.1-84.9 96.6 0 0 122.7c0 17.9-8.9 33.8-22.4 43.5l-81.3-81.3zM269 225.6c7.8-6.1 14.3-13.7 19-22.6 11.6 22 34.7 37 61.3 37 26.8 0 49.8-15.1 61.4-37.1 11.4 22.1 34.5 37.1 60.8 37.1 8.7 0 16.9-1.6 24.5-4.5L496 336 379.4 336 269 225.6zM395.4 352l100.6 0 0 56c0 12.6-4.1 24.1-11.1 33.5L395.4 352zM80 352l224.8 0-16-16-208.8 0 0-100.5c7.5 2.9 15.8 4.5 24.5 4.5 23.9 0 45-12.3 57.3-31l-11.6-11.6c-9 16-26.2 26.7-45.6 26.7-34.9 0-60-33.5-50.3-67l12.6-43-12.9-12.9-15 51.5c-8.5 29 3.1 58 25.1 74.3L64 408c0 39.8 32.2 72 72 72l296.8 0-16-16-280.8 0c-30.9 0-56-25.1-56-56l0-56zM408.7 48L460 48c17.8 0 33.4 11.7 38.4 28.8L521.8 157c9.8 33.5-15.4 67-50.3 67-27.2 0-49.9-20.9-52.2-48l-.9-11 0-.1-9.7-116.9zm-6.2 118.2c2.6 31.1-21.9 57.8-53.2 57.8-29.5 0-53.3-23.9-53.3-53.3l0-122.7 96.6 0 9.9 118.2z"]],
    "percent": [448, 512, [62101, 62785, "percentage"], "25", ["M16 128a80 80 0 1 0 160 0 80 80 0 1 0 -160 0zM272 384a80 80 0 1 0 160 0 80 80 0 1 0 -160 0z", "M445.7 34.3c3.1 3.1 3.1 8.2 0 11.3l-432 432c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l432-432c3.1-3.1 8.2-3.1 11.3 0zM96 208a80 80 0 1 0 0-160 80 80 0 1 0 0 160zM96 32a96 96 0 1 1 0 192 96 96 0 1 1 0-192zM432 384a80 80 0 1 0 -160 0 80 80 0 1 0 160 0zm-176 0a96 96 0 1 1 192 0 96 96 0 1 1 -192 0z"]],
    "circle-n": [512, 512, [], "e118", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zm160-88c0-3.4 2.1-6.4 5.3-7.5s6.7-.1 8.9 2.5L320 321.6 320 168c0-4.4 3.6-8 8-8s8 3.6 8 8l0 176c0 3.4-2.1 6.4-5.3 7.5s-6.7 .2-8.9-2.5L192 190.4 192 344c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-176z", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM190.2 162.9c-2.1-2.6-5.7-3.6-8.9-2.5s-5.3 4.2-5.3 7.5l0 176c0 4.4 3.6 8 8 8s8-3.6 8-8l0-153.6 129.8 158.7c2.1 2.6 5.7 3.6 8.9 2.5s5.3-4.2 5.3-7.5l0-176c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 153.6-129.8-158.7z"]],
    "file-zipper": [384, 512, ["file-archive"], "f1c6", ["M16 64l0 384c0 26.5 21.5 48 48 48l256 0c26.5 0 48-21.5 48-48l0-261.5c0-3.6-.4-7.1-1.2-10.5L264 176c-30.9 0-56-25.1-56-56l0-102.8c-3.4-.8-6.9-1.2-10.5-1.2L64 16C37.5 16 16 37.5 16 64zm48-8c0-4.4 3.6-8 8-8l80 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L72 64c-4.4 0-8-3.6-8-8zm0 48c0-4.4 3.6-8 8-8l80 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-80 0c-4.4 0-8-3.6-8-8zm0 48c0-4.4 3.6-8 8-8l80 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-80 0c-4.4 0-8-3.6-8-8zm0 72c0-8.9 3.7-17 9.5-22.9 2.6-5.4 8.1-9.1 14.5-9.1l48 0c6.4 0 11.9 3.7 14.5 9.1 5.9 5.9 9.5 13.9 9.5 22.9l0 48c0 26.5-21.5 48-48 48s-48-21.5-48-48l0-48z", "M64 16C37.5 16 16 37.5 16 64l0 384c0 26.5 21.5 48 48 48l256 0c26.5 0 48-21.5 48-48l0-261.5c0-3.6-.4-7.1-1.2-10.5L264 176c-30.9 0-56-25.1-56-56l0-102.8c-3.4-.8-6.9-1.2-10.5-1.2L64 16zM360 160c-1.8-2.7-3.8-5.1-6.1-7.4L231.4 30.1c-2.3-2.3-4.8-4.3-7.4-6.1l0 96c0 22.1 17.9 40 40 40l96 0zM0 64C0 28.7 28.7 0 64 0L197.5 0c17 0 33.3 6.7 45.3 18.7L365.3 141.3c12 12 18.7 28.3 18.7 45.3L384 448c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zm64-8c0-4.4 3.6-8 8-8l80 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L72 64c-4.4 0-8-3.6-8-8zm0 48c0-4.4 3.6-8 8-8l80 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-80 0c-4.4 0-8-3.6-8-8zm0 48c0-4.4 3.6-8 8-8l80 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-80 0c-4.4 0-8-3.6-8-8zm64 56l-32 0c-8.8 0-16 7.2-16 16l0 48c0 17.7 14.3 32 32 32s32-14.3 32-32l0-48c0-8.8-7.2-16-16-16zm0-16c17.7 0 32 14.3 32 32l0 48c0 26.5-21.5 48-48 48s-48-21.5-48-48l0-48c0-17.7 14.3-32 32-32l32 0zM96 272a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"]],
    "trash-can-xmark": [448, 512, [], "e2ae", ["M48 128l0 320c0 26.5 21.5 48 48 48l256 0c26.5 0 48-21.5 48-48l0-320-352 0zm83.8-64l184.4 0-19.6-48.9C293 6 284.1 0 274.3 0L173.7 0c-9.8 0-18.6 6-22.3 15.1L131.8 64zm27 158.8c3.1-3.1 8.2-3.1 11.3 0l53.8 53.8 53.8-53.8c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3l-53.8 53.8 53.8 53.8c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-53.8-53.8-53.8 53.8c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l53.8-53.8-53.8-53.8c-3.1-3.1-3.1-8.2 0-11.3z", "M151.4 15.1C155 6 163.9 0 173.7 0L274.3 0c9.8 0 18.6 6 22.3 15.1l19.6 48.9-184.4 0 19.6-48.9zM114.6 64L8 64c-4.4 0-8 3.6-8 8s3.6 8 8 8l432 0c4.4 0 8-3.6 8-8s-3.6-8-8-8L333.4 64 311.5 9.1C305.4-6 290.7-16 274.3-16L173.7-16c-16.4 0-31.1 10-37.1 25.1L114.6 64zM32 128l0 320c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-320-16 0 0 320c0 26.5-21.5 48-48 48L96 496c-26.5 0-48-21.5-48-48l0-320-16 0zM158.8 341.8c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l53.8-53.8 53.8 53.8c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-53.8-53.8 53.8-53.8c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0l-53.8 53.8-53.8-53.8c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l53.8 53.8-53.8 53.8z"]],
    "display": [512, 512, [], "e163", ["M80 112l352 0 0 224-352 0 0-224zM193.4 496l13.3-80 98.4 0 13.3 80-125.1 0z", "M448 48c26.5 0 48 21.5 48 48l0 256c0 26.5-21.5 48-48 48L64 400c-26.5 0-48-21.5-48-48L16 96c0-26.5 21.5-48 48-48l384 0zM64 416l126.6 0-13.3 80-73.2 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l304 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-73.2 0-13.3-80 126.6 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 352c0 35.3 28.7 64 64 64zm129.4 80l13.3-80 98.4 0 13.3 80-125.1 0zM80 112l352 0 0 224-352 0 0-224zm-16 0l0 224c0 8.8 7.2 16 16 16l352 0c8.8 0 16-7.2 16-16l0-224c0-8.8-7.2-16-16-16L80 96c-8.8 0-16 7.2-16 16z"]],
    "ellipsis-stroke": [512, 512, ["ellipsis-h-alt"], "f39b", ["M128 256a48 48 0 1 1 -96 0 48 48 0 1 1 96 0zm176 0a48 48 0 1 1 -96 0 48 48 0 1 1 96 0zm176 0a48 48 0 1 1 -96 0 48 48 0 1 1 96 0z", "M32 256a48 48 0 1 0 96 0 48 48 0 1 0 -96 0zm112 0a64 64 0 1 1 -128 0 64 64 0 1 1 128 0zm112-48a48 48 0 1 0 0 96 48 48 0 1 0 0-96zm0 112a64 64 0 1 1 0-128 64 64 0 1 1 0 128zM432 208a48 48 0 1 0 0 96 48 48 0 1 0 0-96zm0 112a64 64 0 1 1 0-128 64 64 0 1 1 0 128z"]],
    "air-conditioner": [576, 512, [], "f8f4", ["M16 128l0 96c0 26.5 21.5 48 48 48l448 0c26.5 0 48-21.5 48-48l0-96c0-26.5-21.5-48-48-48L64 80c-26.5 0-48 21.5-48 48zm80 72c0-4.4 3.6-8 8-8l368 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-368 0c-4.4 0-8-3.6-8-8z", "M64 80c-26.5 0-48 21.5-48 48l0 96c0 26.5 21.5 48 48 48l448 0c26.5 0 48-21.5 48-48l0-96c0-26.5-21.5-48-48-48L64 80zM0 128C0 92.7 28.7 64 64 64l448 0c35.3 0 64 28.7 64 64l0 96c0 35.3-28.7 64-64 64L64 288c-35.3 0-64-28.7-64-64l0-96zm104 64l368 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-368 0c-4.4 0-8-3.6-8-8s3.6-8 8-8zM336 488c0 22.1 17.9 40 40 40s40-17.9 40-40l0-8c0-4.4 3.6-8 8-8s8 3.6 8 8l0 8c0 30.9-25.1 56-56 56s-56-25.1-56-56l0-152 16 0 0 152zM240 336l16 0 0 152c0 30.9-25.1 56-56 56s-56-25.1-56-56l0-8c0-4.4 3.6-8 8-8s8 3.6 8 8l0 8c0 22.1 17.9 40 40 40s40-17.9 40-40l0-152z"]],
    "file-xls": [576, 512, [], "e64d", ["M48 64c0-26.5 21.5-48 48-48l133.5 0c3.6 0 7.1 .4 10.5 1.2L240 120c0 30.9 25.1 56 56 56l102.8 0c.8 3.4 1.2 6.9 1.2 10.5l0 149.5-144 0c-26.5 0-48 21.5-48 48l0 112-112 0c-26.5 0-48-21.5-48-48L48 64z", "M96 16l133.5 0c3.6 0 7.1 .4 10.5 1.2L240 120c0 30.9 25.1 56 56 56l102.8 0c.8 3.4 1.2 6.9 1.2 10.5l0 149.5 16 0 0-149.5c0-17-6.7-33.3-18.7-45.3L274.7 18.7C262.7 6.7 246.5 0 229.5 0L96 0C60.7 0 32 28.7 32 64l0 384c0 35.3 28.7 64 64 64l112 0 0-16-112 0c-26.5 0-48-21.5-48-48L48 64c0-26.5 21.5-48 48-48zM392 160l-96 0c-22.1 0-40-17.9-40-40l0-96c2.7 1.8 5.1 3.8 7.4 6.1L385.9 152.6c2.3 2.3 4.3 4.8 6.1 7.4zM280 408c0-4.4-3.6-8-8-8s-8 3.6-8 8c0 12 3.6 23.8 10.2 33.8l20.2 30.2-20.2 30.2c-6.7 10-10.2 21.7-10.2 33.8 0 4.4 3.6 8 8 8s8-3.6 8-8c0-8.9 2.6-17.5 7.5-24.9l16.5-24.7 16.5 24.7c4.9 7.4 7.5 16 7.5 24.9 0 4.4 3.6 8 8 8s8-3.6 8-8c0-12-3.6-23.8-10.2-33.8l-20.2-30.2 20.2-30.2c6.7-10 10.2-21.7 10.2-33.8 0-4.4-3.6-8-8-8s-8 3.6-8 8c0 8.9-2.6 17.5-7.5 24.9l-16.5 24.7-16.5-24.7c-4.9-7.4-7.5-16-7.5-24.9zM400 544l32 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-24 0 0-120c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 128c0 4.4 3.6 8 8 8zm88-104c0 22.1 17.9 40 40 40 13.3 0 24 10.7 24 24s-10.7 24-24 24l-32 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l32 0c22.1 0 40-17.9 40-40s-17.9-40-40-40c-13.3 0-24-10.7-24-24s10.7-24 24-24l24 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-24 0c-22.1 0-40 17.9-40 40z"]],
    "pinata": [512, 512, [], "e3c3", ["M16 102.7c0 21.9 13 41.6 33.1 50.3l74 31.7c2.9 1.3 4.8 4.1 4.8 7.3l0 57.8 32-19.2 3.2-1.6c7.7-3.2 16.7-2.1 23.5 3l25.4 19.1c2.6 1.9 6.1 2.1 8.9 .4L256 230.7c8.4-5 18.9-4.5 26.7 1.4l25.4 19.1c2.6 1.9 6.1 2.1 8.9 .4L352 230.7c8.4-5 18.9-4.5 26.7 1.4l25.4 19.1c2.6 1.9 6.1 2.1 8.9 .4l34.9-20.9 3.2-1.6c7.7-3.2 16.7-2.1 23.5 3l21.3 15.9 0-16c0-39.8-32.2-72-72-72l-160 0c-4.4 0-8-3.6-8-8l0-140c0-15.5-12.5-28-28-28S200-3.5 200 12l0 28c0 4.4-3.6 8-8 8L70.7 48C40.5 48 16 72.5 16 102.7zM128 268.5l0 61.3 32-19.2 3.2-1.6c7.7-3.2 16.7-2.1 23.5 3l25.4 19.1c2.6 1.9 6.1 2.1 8.9 .4l34.9-20.9 3.2-1.6c7.7-3.2 16.7-2.1 23.5 3l25.4 19.1 2.1 1.1c2.2 .8 4.7 .6 6.8-.7l34.9-20.9 3.2-1.6c7.7-3.2 16.7-2.1 23.5 3l25.4 19.1c2.6 1.9 6.1 2.1 8.9 .4l34.9-20.9 3.2-1.6c7.7-3.2 16.7-2.1 23.5 3l21.3 15.9 0-60-30.9-23.2c-2.6-1.9-6.1-2.1-8.9-.4l-34.9 20.9c-8.4 5-18.9 4.5-26.7-1.4l-25.5-19.1c-2.6-1.9-6.1-2.1-8.9-.4l-34.9 20.9c-8.4 5-18.9 4.5-26.7-1.4l-25.5-19.1c-2.6-1.9-6.1-2.1-8.9-.4l-34.9 20.9c-8.4 5-18.9 4.5-26.8-1.4l-25.5-19.1c-1.9-1.5-4.4-1.9-6.7-1.3l-2.2 .9-40.2 24.1zm0 80L128 456c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-64c0-4.4 3.6-8 8-8l160 0c4.4 0 8 3.6 8 8l0 64c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-108-30.9-23.2c-1.9-1.5-4.4-1.9-6.7-1.3l-2.2 .9-34.9 20.9c-8.4 5-18.9 4.5-26.7-1.4l-25.5-19.1c-1.9-1.5-4.4-1.9-6.7-1.3l-2.2 .9-34.9 20.9c-7.3 4.4-16.3 4.5-23.7 .6l-3.1-2-25.5-19.1c-1.9-1.5-4.4-1.9-6.7-1.3l-2.2 .9-34.9 20.9c-8.4 5-18.9 4.5-26.8-1.4l-25.5-19.1c-1.9-1.5-4.4-1.9-6.7-1.3l-2.2 .9-40.2 24.1zM192 112a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M228-32c24.3 0 44 19.7 44 44l0 132 152 0c48.6 0 88 39.4 88 88l0 224c0 26.5-21.5 48-48 48l-32 0c-26.5 0-48-21.5-48-48l0-56-144 0 0 56c0 26.5-21.5 48-48 48l-32 0c-26.5 0-48-21.5-48-48l0-258.8-69.2-29.6C16.9 156.5 0 131 0 102.7 0 63.7 31.7 32 70.7 32l113.3 0 0-20c0-24.3 19.7-44 44-44zM458.4 323.5l-2.2 .9-34.9 20.9c-8.4 5-18.9 4.5-26.7-1.4l-25.5-19.1c-1.9-1.5-4.4-1.9-6.7-1.3l-2.2 .9-34.9 20.9c-7.3 4.4-16.3 4.5-23.7 .6l-3.1-2-25.5-19.1c-1.9-1.5-4.4-1.9-6.7-1.3l-2.2 .9-34.9 20.9c-8.4 5-18.9 4.5-26.8-1.4l-25.5-19.1c-1.9-1.5-4.4-1.9-6.7-1.3l-2.2 .9-40.2 24.1 0 107.5c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-64c0-4.4 3.6-8 8-8l160 0c4.4 0 8 3.6 8 8l0 64c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-108-30.9-23.2c-1.9-1.5-4.4-1.9-6.7-1.3zm6.7-78.7c-2.6-1.9-6.1-2.1-8.9-.4l-34.9 20.9c-8.4 5-18.9 4.5-26.7-1.4l-25.5-19.1c-2.6-1.9-6.1-2.1-8.9-.4l-34.9 20.9c-8.4 5-18.9 4.5-26.7-1.4l-25.5-19.1c-2.6-1.9-6.1-2.1-8.9-.4l-34.9 20.9c-8.4 5-18.9 4.5-26.8-1.4l-25.5-19.1c-1.9-1.5-4.4-1.9-6.7-1.3l-2.2 .9-40.2 24.1 0 61.3 32-19.2 3.2-1.6c7.7-3.2 16.7-2.1 23.5 3l25.4 19.1c2.6 1.9 6.1 2.1 8.9 .4l34.9-20.9 3.2-1.6c7.7-3.2 16.7-2.1 23.5 3l25.4 19.1 2.1 1.1c2.2 .8 4.7 .6 6.8-.7l34.9-20.9 3.2-1.6c7.7-3.2 16.7-2.1 23.5 3l25.4 19.1c2.6 1.9 6.1 2.1 8.9 .4l34.9-20.9 3.2-1.6c7.7-3.2 16.7-2.1 23.5 3l21.3 15.9 0-60-30.9-23.2zM228-16c-15.5 0-28 12.5-28 28l0 28c0 4.4-3.6 8-8 8L70.7 48c-30.2 0-54.7 24.5-54.7 54.7 0 21.9 13 41.6 33.1 50.3l74 31.7c2.9 1.3 4.8 4.1 4.8 7.3l0 57.8 32-19.2 3.2-1.6c7.7-3.2 16.7-2.1 23.5 3l25.4 19.1c2.6 1.9 6.1 2.1 8.9 .4L256 230.7c8.4-5 18.9-4.5 26.7 1.4l25.4 19.1c2.6 1.9 6.1 2.1 8.9 .4L352 230.7c8.4-5 18.9-4.5 26.7 1.4l25.4 19.1c2.6 1.9 6.1 2.1 8.9 .4l34.9-20.9 3.2-1.6c7.7-3.2 16.7-2.1 23.5 3l21.3 15.9 0-16c0-39.8-32.2-72-72-72l-160 0c-4.4 0-8-3.6-8-8l0-140c0-15.5-12.5-28-28-28zM176 128a16 16 0 1 1 0-32 16 16 0 1 1 0 32z"]],
    "chart-fft": [512, 512, [], "e69e", ["M16 320l88 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l64 0c3.3 0 6.3-2.1 7.5-5.2l81.3-214.4 56 118.9c1.3 2.8 4.1 4.6 7.2 4.6l76 0 69.6 92.8c2.6 3.5 7.7 4.2 11.2 1.6 2.1-1.6 3.2-3.9 3.2-6.3l0 135.9-400 0c-35.3 0-64-28.7-64-64l0-80z", "M16 40c0-4.4-3.6-8-8-8s-8 3.6-8 8L0 400c0 44.2 35.8 80 80 80l424 0c4.4 0 8-3.6 8-8s-3.6-8-8-8L80 464c-35.3 0-64-28.7-64-64L16 40zM263.2 92.6c-1.4-2.9-4.3-4.7-7.5-4.6s-6 2.2-7.2 5.2l-86 226.8-58.5 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l64 0c3.3 0 6.3-2.1 7.5-5.2l81.3-214.4 56 118.9c1.3 2.8 4.1 4.6 7.2 4.6l76 0 69.6 92.8c2.6 3.5 7.7 4.2 11.2 1.6s4.2-7.7 1.6-11.2l-72-96c-1.5-2-3.9-3.2-6.4-3.2l-74.9 0-61.8-131.4z"]],
    "circle-user-circle-exclamation": [640, 512, [], "e7a0", ["M48 256c0-132.5 107.5-240 240-240 116.8 0 214.1 83.4 235.6 194-9-1.3-18.2-2-27.6-2-77.5 0-144.3 45.9-174.6 112l-1.4 0-64 0C189.5 320 134.9 370.6 128.6 435.4 79.2 391.5 48 327.4 48 256zm160-64a80 80 0 1 0 160 0 80 80 0 1 0 -160 0z", "M320 320l1.4 0c-2.4 5.2-4.6 10.5-6.5 16L256 336c-61.9 0-112 50.1-112 112l0 0c40.1 30.1 90 48 144 48 13.6 0 26.9-1.1 39.8-3.3 2.8 5 5.8 9.9 9 14.6-15.8 3-32.1 4.6-48.8 4.6-141.4 0-256-114.6-256-256S146.6 0 288 0c126.8 0 232.1 92.2 252.4 213.2-5.5-1.3-11.1-2.4-16.8-3.2-21.5-110.5-118.8-194-235.6-194-132.5 0-240 107.5-240 240 0 71.4 31.2 135.5 80.6 179.4 6.3-64.8 60.9-115.4 127.4-115.4l64 0zM208 192a80 80 0 1 1 160 0 80 80 0 1 1 -160 0zm80 64a64 64 0 1 0 0-128 64 64 0 1 0 0 128zM624 400a128 128 0 1 0 -256 0 128 128 0 1 0 256 0zm-272 0a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm144 52a12 12 0 1 1 0 24 12 12 0 1 1 0-24zm0-140c4.4 0 8 3.6 8 8l0 96c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-96c0-4.4 3.6-8 8-8z"]],
    "phone-intercom": [512, 512, [], "e434", ["M16 80l0 352c0 17.7 14.3 32 32 32l48 0c16.9 0 30.8-13.2 32-30.9 0-.2 0-.3 0-.5L128 80c0-17.7-14.3-32-32-32L48 48C30.3 48 16 62.3 16 80zM144 96l0 320c0 26.5 21.5 48 48 48l256 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L192 48c-26.5 0-48 21.5-48 48zm48 32c0-17.7 14.3-32 32-32l192 0c17.7 0 32 14.3 32 32l0 96c0 17.7-14.3 32-32 32l-192 0c-17.7 0-32-14.3-32-32l0-96zm48 224a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm96 0a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm96 0a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M48 48C30.3 48 16 62.3 16 80l0 352c0 17.7 14.3 32 32 32l48 0c17.7 0 32-14.3 32-32l0-352c0-17.7-14.3-32-32-32L48 48zm91.4 404.5C131.7 468.8 115.2 480 96 480l-48 0c-26.5 0-48-21.5-48-48L0 80C0 53.5 21.5 32 48 32l48 0C115.2 32 131.7 43.2 139.4 59.5 151 42.9 170.2 32 192 32l256 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64l-256 0c-21.8 0-41-10.9-52.6-27.5zM144 416c0 26.5 21.5 48 48 48l256 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L192 48c-26.5 0-48 21.5-48 48l0 320zM416 112l-192 0c-8.8 0-16 7.2-16 16l0 96c0 8.8 7.2 16 16 16l192 0c8.8 0 16-7.2 16-16l0-96c0-8.8-7.2-16-16-16zM224 96l192 0c17.7 0 32 14.3 32 32l0 96c0 17.7-14.3 32-32 32l-192 0c-17.7 0-32-14.3-32-32l0-96c0-17.7 14.3-32 32-32zm0 240a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm112 16a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm80-16a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"]],
    "turn-left-up": [384, 512, [], "e638", ["M49.2 166.1c2.5 6 8.3 9.9 14.8 9.9l72 0c4.4 0 8 3.6 8 8l0 168c0 79.5 64.5 144 144 144l64 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16l-64 0c-26.5 0-48-21.5-48-48l0-168c0-4.4 3.6-8 8-8l72 0c6.5 0 12.3-3.9 14.8-9.9s1.1-12.9-3.5-17.4l-128-128c-6.2-6.2-16.4-6.2-22.6 0l-128 128c-4.6 4.6-5.9 11.5-3.5 17.4z", "M180.7 20.7c6.2-6.2 16.4-6.2 22.6 0l128 128c4.6 4.6 5.9 11.5 3.5 17.4S326.5 176 320 176l-72 0c-4.4 0-8 3.6-8 8l0 168c0 26.5 21.5 48 48 48l64 0c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16l-64 0c-79.5 0-144-64.5-144-144l0-168c0-4.4-3.6-8-8-8l-72 0c-6.5 0-12.3-3.9-14.8-9.9s-1.1-12.9 3.5-17.4l128-128zM214.6 9.4c-12.5-12.5-32.8-12.5-45.3 0l-128 128c-9.2 9.2-11.9 22.9-6.9 34.9l0 0c5 12 16.6 19.8 29.6 19.8l64 0 0 160c0 88.4 71.6 160 160 160l64 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-64 0c-17.7 0-32-14.3-32-32l0-160 64 0c12.9 0 24.6-7.8 29.6-19.8s2.2-25.7-6.9-34.9l-128-128z"]],
    "scarf": [512, 512, [129507], "f7c1", ["M112 104c0-48.6 39.4-88 88-88l112 0c48.6 0 88 39.4 88 88l0 56.2c0 23.3-9.3 45.7-25.8 62.2l-22.2 22.2-89.4-89.4c-10.1-10.1-2.9-27.3 11.3-27.3l14.1 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-14.1 0c-28.5 0-42.8 34.5-22.6 54.6L340.7 256c-6.6 6.6-27.8 27.8-84.7 84.7L137.8 222.5C121.3 206 112 183.6 112 160.2l0-56.2z", "M112 104c0-48.6 39.4-88 88-88l112 0c48.6 0 88 39.4 88 88l0 56.2c0 23.3-9.3 45.7-25.8 62.2l-22.2 22.2-89.4-89.4c-10.1-10.1-2.9-27.3 11.3-27.3l14.1 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-14.1 0c-28.5 0-42.8 34.5-22.6 54.6L340.7 256c-6.6 6.6-27.8 27.8-84.7 84.7L137.8 222.5C121.3 206 112 183.6 112 160.2l0-56.2zM256 363.3L394.3 501.7c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3L267.3 352 304 315.3 442.3 453.7c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3L315.3 304c35.3-35.3 24.9-24.9 36.7-36.7L490.3 405.7c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3L363.3 256 385.5 233.8c19.5-19.5 30.5-46 30.5-73.5l0-56.2C416 46.6 369.4 0 312 0L200 0C142.6 0 96 46.6 96 104l0 56.2c0 27.6 11 54 30.5 73.5L244.7 352 256 363.3zM114.7 289.9L10.3 394.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l104.4-104.4-11.3-11.3zm48 48L58.3 442.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l104.4-104.4-11.3-11.3zm48 48L106.3 490.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l104.4-104.4-11.3-11.3z"]],
    "message-pen": [512, 512, ["comment-alt-edit", "message-edit"], "f4a4", ["M16 128l0 224c0 44.2 35.8 80 80 80l32 0c8.8 0 16 7.2 16 16l0 75.9c0 2.3 2 4 4.1 4.1 .8 0 1.7-.2 2.4-.7 3.3-2.3 6.3-4.5 9.1-6.4l.4-.3c6.7-4.7 30.4-21.5 117.2-82.7 5.4-3.8 11.8-5.9 18.5-5.9L416 432c44.2 0 80-35.8 80-80l0-224c0-44.2-35.8-80-80-80L96 48c-44.2 0-80 35.8-80 80zM136.7 332.4L149 283c2.5-9.8 7.6-18.8 14.7-26L285.1 135.6c10-10 23.5-15.6 37.7-15.6 29.4 0 53.3 23.8 53.3 53.3 0 14.1-5.6 27.7-15.6 37.7L239.1 332.3c-7.2 7.2-16.2 12.3-26 14.7l-49.4 12.4c-15.9 4-30.9-11.1-27-27z", "M144 448l0 75.9c0 2.3 2 4 4.1 4.1 .8 0 1.7-.2 2.4-.7 3.3-2.3 6.3-4.5 9.1-6.4l.4-.3c6.7-4.7 30.4-21.5 117.2-82.7 5.4-3.8 11.8-5.9 18.5-5.9L416 432c44.2 0 80-35.8 80-80l0-224c0-44.2-35.8-80-80-80L96 48c-44.2 0-80 35.8-80 80l0 224c0 44.2 35.8 80 80 80l32 0c8.8 0 16 7.2 16 16zM0 128C0 75 43 32 96 32l320 0c53 0 96 43 96 96l0 224c0 53-43 96-96 96l-120.4 0c-3.3 0-6.5 1-9.2 2.9L159.8 540.3c-3.4 2.4-7.5 3.7-11.6 3.7-11.1 0-20.1-9-20.1-20.1l0-75.9-32 0c-53 0-96-43-96-96L0 128zm296.4 18.9L175.1 268.3c-5.1 5.1-8.8 11.5-10.5 18.6l-12.4 49.4c-1.1 4.5 3.1 8.7 7.6 7.6l49.4-12.3c7-1.8 13.5-5.4 18.6-10.5L349.1 199.6c7-7 10.9-16.5 10.9-26.3 0-20.6-16.7-37.3-37.3-37.3-9.9 0-19.4 3.9-26.3 10.9zM322.7 120c29.4 0 53.3 23.8 53.3 53.3 0 14.1-5.6 27.7-15.6 37.7L239.1 332.3c-7.2 7.2-16.2 12.3-26 14.7l-49.4 12.4c-15.9 4-30.9-11.1-27-27L149 283c2.5-9.8 7.6-18.8 14.7-26L285.1 135.6c10-10 23.5-15.6 37.7-15.6z"]],
    "icons": [512, 512, ["heart-music-camera-bolt"], "f86d", ["M16 67l0 6.1c0 21.4 14.8 45.5 37.5 68.8 22 22.7 48.5 41.8 65.6 53 5.5 3.6 12.3 3.6 17.7 0 17.1-11.3 43.6-30.3 65.6-53 22.7-23.4 37.5-47.4 37.5-68.8l0-6.1c0-28.2-22.9-51-51-51-16.1 0-31.2 7.6-40.8 20.4L134.4 54.7c-1.5 2-3.9 3.2-6.4 3.2s-4.9-1.2-6.4-3.2L107.9 36.4C98.2 23.6 83.1 16 67 16 38.9 16 16 38.9 16 67zm0 285l0 112c0 17.7 14.3 32 32 32l192 0c17.7 0 32-14.3 32-32l0-112c0-17.7-14.3-32-32-32l-30.9 0c-2.7 0-5.2-1.3-6.7-3.6l-14.2-21.3c-3-4.5-8-7.1-13.3-7.1l-61.7 0c-5.3 0-10.3 2.7-13.3 7.1L85.6 316.4c-1.5 2.2-4 3.6-6.7 3.6L48 320c-17.7 0-32 14.3-32 32zm184 48a56 56 0 1 1 -112 0 56 56 0 1 1 112 0zm40-179.5c0 7.1 3.8 14.7 12.3 21.1s21.1 10.9 35.7 10.9 27.1-4.4 35.7-10.9 12.3-14.1 12.3-21.1-3.8-14.7-12.3-21.1-21.1-10.9-35.7-10.9-27.1 4.4-35.7 10.9-12.3 14.1-12.3 21.1zm96 161.3c0 1.2 1 2.2 2.2 2.2l53.8 0c2.6 0 5 1.3 6.5 3.4s1.9 4.8 1 7.3l-33.8 94.7 129.2-100.5c.7-.5 1.1-1.3 1.1-2.2 0-1.5-1.2-2.7-2.7-2.7L440 384c-2.6 0-5-1.3-6.5-3.4s-1.9-4.8-1-7.3l33.8-94.7-129.4 101.5c-.5 .4-.8 1-.8 1.7zm64-209.3c0 7.1 3.8 14.7 12.3 21.1s21.1 10.9 35.7 10.9 27.1-4.4 35.7-10.9 12.3-14.1 12.3-21.1-3.8-14.7-12.3-21.1-21.1-10.9-35.7-10.9-27.1 4.4-35.7 10.9-12.3 14.1-12.3 21.1z", "M496 24c0-5-4.6-8.8-9.6-7.8l-128 25.6c-3.7 .7-6.4 4-6.4 7.8l0 170.9c0 26.5-28.7 48-64 48s-64-21.5-64-48 28.7-48 64-48c19.1 0 36.3 6.3 48 16.3l0-139.1c0-11.4 8.1-21.3 19.3-23.5L483.3 .5C498.1-2.5 512 8.9 512 24l0 148.5c0 26.5-28.7 48-64 48s-64-21.5-64-48 28.7-48 64-48c19.1 0 36.3 6.3 48 16.3L496 24zM323.7 199.4c-8.6-6.4-21.1-10.9-35.7-10.9s-27.1 4.4-35.7 10.9-12.3 14.1-12.3 21.1 3.8 14.7 12.3 21.1 21.1 10.9 35.7 10.9 27.1-4.4 35.7-10.9 12.3-14.1 12.3-21.1l0 0c0-7.1-3.8-14.7-12.3-21.1zm160-48c-8.6-6.4-21.1-10.9-35.7-10.9s-27.1 4.4-35.7 10.9-12.3 14.1-12.3 21.1 3.8 14.7 12.3 21.1 21.1 10.9 35.7 10.9 27.1-4.4 35.7-10.9 12.3-14.1 12.3-21.1l0 0c0-7.1-3.8-14.7-12.3-21.1zM148.1 36.4L134.4 54.7c-1.5 2-3.9 3.2-6.4 3.2s-4.9-1.2-6.4-3.2L107.9 36.4C98.2 23.6 83.1 16 67 16 38.9 16 16 38.9 16 67l0 6.1c0 21.4 14.8 45.5 37.5 68.8 22 22.7 48.5 41.8 65.6 53 5.5 3.6 12.3 3.6 17.7 0 17.1-11.3 43.6-30.3 65.6-53 22.7-23.4 37.5-47.4 37.5-68.8l0-6.1c0-28.2-22.9-51-51-51-16.1 0-31.2 7.6-40.8 20.4zM189 0c37 0 67 30 67 67l0 6.1c0 56.1-75.2 112.1-110.3 135.3-10.8 7.1-24.5 7.1-35.3 0-35.1-23.1-110.3-79.2-110.3-135.3L0 67C0 30 30 0 67 0 88.2 0 108 9.9 120.7 26.8l7.3 9.8 7.3-9.8C148 9.9 167.8 0 189 0zM113.1 288c-5.3 0-10.3 2.7-13.3 7.1L85.6 316.4c-1.5 2.2-4 3.6-6.7 3.6L48 320c-17.7 0-32 14.3-32 32l0 112c0 17.7 14.3 32 32 32l192 0c17.7 0 32-14.3 32-32l0-112c0-17.7-14.3-32-32-32l-30.9 0c-2.7 0-5.2-1.3-6.7-3.6l-14.2-21.3c-3-4.5-8-7.1-13.3-7.1l-61.7 0zm-26.6-1.8c5.9-8.9 15.9-14.2 26.6-14.2l61.7 0c10.7 0 20.7 5.3 26.6 14.2l11.8 17.8 26.7 0c26.5 0 48 21.5 48 48l0 112c0 26.5-21.5 48-48 48L48 512c-26.5 0-48-21.5-48-48L0 352c0-26.5 21.5-48 48-48l26.7 0 11.8-17.8zM144 360a40 40 0 1 0 0 80 40 40 0 1 0 0-80zm56 40a56 56 0 1 1 -112 0 56 56 0 1 1 112 0zM465.8 258.7c2.2-1.7 4.9-2.7 7.7-2.7 8.7 0 14.7 8.6 11.8 16.7l-34 95.3 41.9 0c10.4 0 18.7 8.4 18.7 18.7 0 5.8-2.7 11.2-7.2 14.8L366.1 509.4c-2.2 1.7-4.9 2.6-7.7 2.6-8.7 0-14.7-8.6-11.8-16.8l34-95.2-42.5 0c-10 0-18.2-8.1-18.2-18.2 0-5.6 2.6-10.9 7-14.3L465.8 258.7zm.4 20L336.8 380.1c-.5 .4-.8 1-.8 1.7 0 1.2 1 2.2 2.2 2.2l53.8 0c2.6 0 5 1.3 6.5 3.4s1.9 4.8 1 7.3l-33.8 94.7 129.2-100.5c.7-.5 1.1-1.3 1.1-2.2 0-1.5-1.2-2.7-2.7-2.7L440 384c-2.6 0-5-1.3-6.5-3.4s-1.9-4.8-1-7.3l33.8-94.7z"]],
    "file-xml": [576, 512, [], "e654", ["M48 64c0-26.5 21.5-48 48-48l133.5 0c3.6 0 7.1 .4 10.5 1.2L240 120c0 30.9 25.1 56 56 56l102.8 0c.8 3.4 1.2 6.9 1.2 10.5l0 149.5-176 0c-26.5 0-48 21.5-48 48l0 112-80 0c-26.5 0-48-21.5-48-48L48 64z", "M96 16l133.5 0c3.6 0 7.1 .4 10.5 1.2L240 120c0 30.9 25.1 56 56 56l102.8 0c.8 3.4 1.2 6.9 1.2 10.5l0 149.5 16 0 0-149.5c0-17-6.7-33.3-18.7-45.3L274.7 18.7C262.7 6.7 246.5 0 229.5 0L96 0C60.7 0 32 28.7 32 64l0 384c0 35.3 28.7 64 64 64l80 0 0-16-80 0c-26.5 0-48-21.5-48-48L48 64c0-26.5 21.5-48 48-48zM392 160l-96 0c-22.1 0-40-17.9-40-40l0-96c2.7 1.8 5.1 3.8 7.4 6.1L385.9 152.6c2.3 2.3 4.3 4.8 6.1 7.4zM520 536c0 4.4 3.6 8 8 8l32 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-24 0 0-120c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 128zM374.9 403.9c-1.8-3.1-5.5-4.6-9-3.6s-5.9 4.1-5.9 7.7l0 128c0 4.4 3.6 8 8 8s8-3.6 8-8l0-99.1 33.1 55.2c1.4 2.4 4.1 3.9 6.9 3.9s5.4-1.5 6.9-3.9l33.1-55.2 0 99.1c0 4.4 3.6 8 8 8s8-3.6 8-8l0-128c0-3.6-2.4-6.8-5.9-7.7s-7.1 .5-9 3.6l-41.1 68.6-41.1-68.6zM248 408c0-4.4-3.6-8-8-8s-8 3.6-8 8c0 12 3.6 23.8 10.2 33.8l20.2 30.2-20.2 30.2c-6.7 10-10.2 21.7-10.2 33.8 0 4.4 3.6 8 8 8s8-3.6 8-8c0-8.9 2.6-17.5 7.5-24.9l16.5-24.7 16.5 24.7c4.9 7.4 7.5 16 7.5 24.9 0 4.4 3.6 8 8 8s8-3.6 8-8c0-12-3.6-23.8-10.2-33.8l-20.2-30.2 20.2-30.2c6.7-10 10.2-21.7 10.2-33.8 0-4.4-3.6-8-8-8s-8 3.6-8 8c0 8.9-2.6 17.5-7.5 24.9l-16.5 24.7-16.5-24.7c-4.9-7.4-7.5-16-7.5-24.9z"]],
    "ruler-vertical": [256, 512, [], "f548", ["M16 16l0 480c0 17.7 14.3 32 32 32l160 0c17.7 0 32-14.3 32-32l0-48-104 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l104 0 0-80-72 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l72 0 0-72-104 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l104 0 0-72-72 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l72 0 0-80-104 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l104 0 0-48c0-17.7-14.3-32-32-32L48-16C30.3-16 16-1.7 16 16z", "M16 496L16 16C16-1.7 30.3-16 48-16l160 0c17.7 0 32 14.3 32 32l0 48-104 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l104 0 0 80-72 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l72 0 0 72-104 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l104 0 0 72-72 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l72 0 0 80-104 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l104 0 0 48c0 17.7-14.3 32-32 32L48 528c-17.7 0-32-14.3-32-32zM256 72l0-56c0-26.5-21.5-48-48-48L48-32C21.5-32 0-10.5 0 16L0 496c0 26.5 21.5 48 48 48l160 0c26.5 0 48-21.5 48-48l0-424z"]],
    "map-location-dot": [640, 512, ["map-marked-alt"], "f5a0", ["M80 112.8l144-73.1 0 376.1-144 65.1 0-368.1zM240 36.4l176 58.7 0 110.7c-43.4 29.8-72 79.4-72 136.1 0 33.2 10.4 65.4 23.2 93.1 4.7 10.1 9.8 20 15.3 29.5L240 416.9 240 36.4zM432 96.1l128-64.4 0 151.2c-15.2-4.5-31.4-6.9-48-6.9-28.9 0-56.1 7.2-80 20l0-99.9z", "M576 18.7c0-2.8-1.4-5.4-3.8-6.8s-5.3-1.6-7.8-.3l-138.8 69.9-183.1-61c-6.1-2-12.7-1.5-18.5 1.4l-155.7 79c-2.7 1.4-4.4 4.1-4.4 7.1l0 385.4c0 2.7 1.4 5.3 3.7 6.7s5.2 1.7 7.6 .6l155-70.1 165.1 55c-2.8-4.3-5.5-8.7-8.2-13.1-1.6-2.6-3.1-5.3-4.7-8l-142.5-47.5 0-380.5 176 58.7 0 110.7c5.1-3.5 10.5-6.8 16-9.7l0-99.9 128-64.4 0 151.2c5.4 1.6 10.8 3.5 16 5.6l0-169.8zM224 415.8l-144 65.1 0-368.1 144-73.1 0 376.1zM512 240c57.7 0 104 45.9 104 101.9 0 30-14.2 64.6-34.1 97.6-19.6 32.7-43.6 61.9-60.5 81-5.2 5.9-13.7 5.9-18.9 0-16.9-19.1-40.9-48.3-60.5-81-19.9-33.1-34.1-67.6-34.1-97.6 0-56 46.3-101.9 104-101.9zM392 341.9c0 68.9 64.1 150.4 98.6 189.3 11.6 13 31.3 13 42.9 0 34.5-38.9 98.6-120.4 98.6-189.3 0-65.1-53.7-117.9-120-117.9S392 276.8 392 341.9zM512 376a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm-48-32a48 48 0 1 0 96 0 48 48 0 1 0 -96 0z"]],
    "watermelon-slice": [512, 512, [], "e337", ["M67.7 373L373 67.6c36.6 38.7 59 90.9 59 148.4 0 119.3-96.7 216-216 216-57.4 0-109.7-22.4-148.4-59zm94.7-50.7c-3.1 3.1-3.1 8.2 0 11.3l24 24c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-24-24c-3.1-3.1-8.2-3.1-11.3 0zm80-80c-3.1 3.1-3.1 8.2 0 11.3l24 24c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-24-24c-3.1-3.1-8.2-3.1-11.3 0zm8 88c-3.1 3.1-3.1 8.2 0 11.3l24 24c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-24-24c-3.1-3.1-8.2-3.1-11.3 0zm72-168c-3.1 3.1-3.1 8.2 0 11.3l24 24c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-24-24c-3.1-3.1-8.2-3.1-11.3 0zm8 88c-3.1 3.1-3.1 8.2 0 11.3l24 24c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-24-24c-3.1-3.1-8.2-3.1-11.3 0z", "M415.7 2.3c3.1-3.1 8.2-3.1 11.3 0 54.4 54.4 85 128.3 85 205.2l0 4.2C512 377.6 377.6 512 211.7 512l-4.2 0c-77 0-150.8-30.6-205.2-85-3.1-3.1-3.1-8.2 0-11.3L415.7 2.3zm5.6 17.1L384.3 56.3c39.5 41.6 63.7 97.8 63.7 159.7 0 128.1-103.9 232-232 232-61.9 0-118.1-24.2-159.7-63.7L19.4 421.3C70.2 469.2 137.5 496 207.6 496l4.2 0C368.7 496 496 368.7 496 211.7l0-4.2c0-70.1-26.8-137.4-74.7-188.2zM67.7 373c38.7 36.6 90.9 59 148.4 59 119.3 0 216-96.7 216-216 0-57.4-22.4-109.7-59-148.4L67.7 373zm266-210.7l24 24c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-24-24c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0zm-80 80l24 24c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-24-24c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0zm88 8l24 24c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-24-24c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0zm-168 72l24 24c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-24-24c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0zm88 8l24 24c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-24-24c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0z"]],
    "jack-o-lantern": [512, 512, [127875], "f30e", ["M16 304c0 50.3 13.6 95.1 34.8 126.9 21.3 31.9 48.9 49.1 77.2 49.1 13.5 0 26.6-3.8 39-11.2 15.3-9.1 34.7-9.1 50 0 12.4 7.4 25.5 11.2 39 11.2s26.6-3.8 39-11.2c15.3-9.1 34.7-9.1 50 0 12.4 7.4 25.5 11.2 39 11.2 28.3 0 55.9-17.2 77.2-49.1 21.2-31.8 34.8-76.6 34.8-126.9s-13.6-95.1-34.8-126.9c-21.3-31.9-48.9-49.1-77.2-49.1-13.5 0-26.6 3.8-39 11.2-15.3 9.1-34.7 9.1-50 0-12.4-7.4-25.5-11.2-39-11.2s-26.6 3.8-39 11.2c-15.3 9.1-34.7 9.1-50 0-12.4-7.4-25.5-11.2-39-11.2-28.3 0-55.9 17.2-77.2 49.1-21.2 31.8-34.8 76.6-34.8 126.9zm86.5 13.3c-3.4-11.7 8.4-21 20-17.3 39.9 12.8 85.3 20 133.5 20s93.6-7.2 133.5-20c11.6-3.7 23.4 5.6 20 17.3-19.5 66.3-80.9 114.7-153.5 114.7S122 383.6 102.5 317.3zm27.4-53.7c-2.8-5.2-2.5-11.5 .8-16.4l32-48c3-4.5 8-7.1 13.3-7.1s10.3 2.7 13.3 7.1l32 48c3.3 4.9 3.6 11.2 .8 16.4S213.9 272 208 272l-64 0c-5.9 0-11.3-3.2-14.1-8.5zm160 0c-2.8-5.2-2.5-11.5 .8-16.4l32-48c3-4.5 8-7.1 13.3-7.1s10.3 2.7 13.3 7.1l32 48c3.3 4.9 3.6 11.2 .8 16.4S373.9 272 368 272l-64 0c-5.9 0-11.3-3.2-14.1-8.5z", "M221.6 16c-6.8 0-12.8 4.3-15.1 10.6l-34.6 97C158.2 116.1 143.4 112 128 112 57.3 112 0 198 0 304S57.3 496 128 496c16.7 0 32.6-4.8 47.2-13.5 10.3-6.1 23.4-6.1 33.7 0 14.6 8.7 30.5 13.5 47.2 13.5s32.6-4.8 47.2-13.5c10.3-6.1 23.4-6.1 33.7 0 14.6 8.7 30.5 13.5 47.2 13.5 70.7 0 128-86 128-192S454.7 112 384 112c-15.4 0-30.2 4.1-43.9 11.6l-34.6-97c-2.3-6.4-8.3-10.6-15.1-10.6l-68.7 0zM325.2 129.6c-7.5 1.2-15.4-.2-22.1-4.2-14.6-8.7-30.5-13.5-47.2-13.5s-32.6 4.8-47.2 13.5c-6.7 4-14.5 5.4-22.1 4.2l34.9-97.6 68.7 0 34.9 97.6zM167 468.8c-12.4 7.4-25.5 11.2-39 11.2-28.3 0-55.9-17.2-77.2-49.1-21.2-31.8-34.8-76.6-34.8-126.9s13.6-95.1 34.8-126.9c21.3-31.9 48.9-49.1 77.2-49.1 13.5 0 26.6 3.8 39 11.2 15.3 9.1 34.7 9.1 50 0 12.4-7.4 25.5-11.2 39-11.2s26.6 3.8 39 11.2c15.3 9.1 34.7 9.1 50 0 12.4-7.4 25.5-11.2 39-11.2 28.3 0 55.9 17.2 77.2 49.1 21.2 31.8 34.8 76.6 34.8 126.9s-13.6 95.1-34.8 126.9c-21.3 31.9-48.9 49.1-77.2 49.1-13.5 0-26.6-3.8-39-11.2-15.3-9.1-34.7-9.1-50 0-12.4 7.4-25.5 11.2-39 11.2s-26.6-3.8-39-11.2c-15.3-9.1-34.7-9.1-50 0zM208 256l-64 0 32-48 32 48zm-18.7-56.9c-3-4.5-8-7.1-13.3-7.1s-10.3 2.7-13.3 7.1l-32 48c-3.3 4.9-3.6 11.2-.8 16.4s8.2 8.5 14.1 8.5l64 0c5.9 0 11.3-3.2 14.1-8.5s2.5-11.5-.8-16.4l-32-48zM336 208l32 48-64 0 32-48zm0-16c-5.4 0-10.3 2.7-13.3 7.1l-32 48c-3.3 4.9-3.6 11.2-.8 16.4s8.2 8.5 14.1 8.5l64 0c5.9 0 11.3-3.2 14.1-8.5s2.5-11.5-.8-16.4l-32-48c-3-4.5-8-7.1-13.3-7.1zM264 335.9c46.4-.7 90.2-8 129.3-20.4-10 31.4-30.4 58.2-57.3 76.2l0-15.8c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 24c0 .3 0 .7 .1 1-19.3 9.6-41 15-64.1 15s-44.8-5.4-64.1-15c0-.3 .1-.7 .1-1l0-24c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 15.8c-26.9-18-47.3-44.7-57.3-76.2 39.1 12.4 82.9 19.6 129.3 20.4 0 0 0 0 0 .1l0 24c0 4.4 3.6 8 8 8s8-3.6 8-8l0-24.1zM389.5 300c-39.9 12.8-85.3 20-133.5 20s-93.6-7.2-133.5-20c-11.6-3.7-23.4 5.6-20 17.3 19.5 66.3 80.9 114.7 153.5 114.7s134-48.4 153.5-114.7c3.4-11.7-8.4-21-20-17.3z"]],
    "candy": [576, 512, [127852], "e3e7", ["M96 256c0 106 86 192 192 192 46.5 0 89.1-16.5 122.4-44L98.2 226.5C96.7 236.1 96 246 96 256zm67.8-146.4L476.5 292.7c2.3-11.9 3.5-24.1 3.5-36.6 0-106-86-192-192-192-47.4 0-90.7 17.2-124.2 45.6z", "M576 87.4c.3 3.4-1.7 6.6-4.8 8L462 142.1c21.4 32.7 33.9 71.9 33.9 113.9 0 114.9-93.1 208-208 208-42 0-81.2-12.5-113.9-33.9l-46.7 109c-1.4 3.2-4.6 5.1-8 4.8s-6.3-2.7-7.1-6l-13.9-55.6-39.8 13.3c-2.9 1-6 .2-8.2-1.9s-2.9-5.3-1.9-8.2l13.3-39.8-55.6-13.9c-3.3-.8-5.8-3.7-6-7.1s1.7-6.6 4.8-8l109-46.7C92.4 337.2 80 298.1 80 256 80 141.1 173.1 48 288 48 330 48 369.2 60.5 401.9 82L448.6-27.2c1.4-3.2 4.6-5.1 8-4.8s6.3 2.7 7.1 6l13.9 55.6 39.8-13.3c2.9-1 6-.2 8.2 1.9s2.9 5.3 1.9 8.2l-13.3 39.8 55.6 13.9c3.3 .8 5.8 3.7 6 7.1zM415.2 91.5c14 10.8 26.5 23.4 37.3 37.3l.3-.1 90.2-38.6-41-10.2c-2.2-.5-4-2-5.1-3.9s-1.3-4.3-.6-6.4l10.9-32.8-32.8 10.9c-2.1 .7-4.4 .5-6.4-.6s-3.4-2.9-3.9-5.1l-10.2-41-38.6 90.2-.1 .3zM410.3 404L98.2 226.5c-1.5 9.6-2.3 19.5-2.3 29.5 0 106 86 192 192 192 46.5 0 89.1-16.5 122.4-44zm12.5-11.3c23.2-22.9 40.6-51.6 49.8-83.8L151.5 121c-24 24.2-41.5 54.8-50 89L422.8 392.7zm53.7-100c2.3-11.9 3.5-24.1 3.5-36.6 0-106-86-192-192-192-47.4 0-90.7 17.2-124.2 45.6L476.5 292.7zM123.4 383.2l-.2 .1-90.2 38.6 41 10.2c2.2 .5 4 2 5.1 3.9s1.3 4.3 .6 6.4l-10.9 32.8 32.8-10.9c2.1-.7 4.4-.5 6.4 .6s3.4 2.9 3.9 5.1l10.2 41 38.6-90.2 .1-.2c-14-10.8-26.5-23.4-37.4-37.4z"]],
    "heart-crack": [512, 512, [128148, "heart-broken"], "f7a9", ["M16 165.1c0 60.1 36.9 115.8 75.4 162.7 43.1 52.4 95.4 98 131.2 125.4 9.3 7.1 21 10.8 33.4 10.8s24.1-3.7 33.4-10.8c35.8-27.4 88.1-73 131.2-125.4 38.6-46.9 75.4-102.6 75.4-162.7 0-64.7-52.4-117.1-117.1-117.1-37.6 0-72.9 18-94.9 48.5l-20 27.6 0 16.6 45.7 45.7c1.7 1.7 2.5 4.1 2.3 6.4s-1.5 4.5-3.5 5.9l-88.7 59.2 58.5 73.2c2.8 3.4 2.2 8.5-1.2 11.2s-8.5 2.2-11.2-1.2l-64-80c-1.4-1.8-2-4-1.7-6.2s1.6-4.2 3.5-5.4l87.9-58.6-41.1-41.1c-1.5-1.5-2.3-3.5-2.3-5.7l0-19.9-20-27.6C206 66 170.7 48 133.1 48 68.4 48 16 100.4 16 165.1z", "M284 96.5c22-30.5 57.3-48.5 94.9-48.5 64.7 0 117.1 52.4 117.1 117.1 0 60.1-36.9 115.8-75.4 162.7-43.1 52.4-95.4 98-131.2 125.4-9.3 7.1-21 10.8-33.4 10.8s-24.1-3.7-33.4-10.8C186.8 425.8 134.6 380.2 91.4 327.8 52.9 280.9 16 225.2 16 165.1 16 100.4 68.4 48 133.1 48 170.7 48 206 66 228 96.5l20 27.6 0 19.9c0 2.1 .8 4.2 2.3 5.7l41.1 41.1-87.9 58.6c-1.9 1.2-3.1 3.2-3.5 5.4s.3 4.5 1.7 6.2l64 80c2.8 3.4 7.8 4 11.2 1.2s4-7.8 1.2-11.2l-58.5-73.2 88.7-59.2c2-1.3 3.3-3.5 3.5-5.9s-.6-4.8-2.3-6.4l-45.7-45.7 0-16.6 20-27.6zM378.9 32C336.2 32 296 52.5 271 87.1l-15 20.7-15-20.7C216 52.5 175.8 32 133.1 32 59.6 32 0 91.6 0 165.1 0 231.3 40.4 290.9 79.1 338 123.2 391.5 176.4 438 212.9 465.9 225.2 475.4 240.4 480 256 480s30.8-4.6 43.1-14.1C335.6 438 388.8 391.5 432.9 338 471.6 290.9 512 231.3 512 165.1 512 91.6 452.4 32 378.9 32z"]],
    "cow": [640, 512, [128004], "f6c8", ["M16 288l0 15.9c17.9-1.6 32-16.7 32-35.1l0-26.1c-18.6 6.6-32 24.4-32 45.3zm96-152l0 280c0 8.8 7.2 16 16 16l48 0c8.8 0 16-7.2 16-16l0-88c0-44.2 35.8-80 80-80s80 35.8 80 80l0 88c0 8.8 7.2 16 16 16l48 0c8.8 0 16-7.2 16-16l0-168c0-3 1.6-5.7 4.2-7.1s5.8-1.2 8.2 .4l48 32c2.2 1.5 3.6 4 3.6 6.7l0 53.3c0 5.2 1.7 10.2 4.8 14.4L552 416c7.6 10.1 19.4 16 32 16 22.1 0 40-17.9 40-40l0-93.4c0-5.1-1.7-10.2-4.7-14.3l-9.7-13.1c-1-1.4-1.6-3-1.6-4.8l0-58.4c0-8.8-7.2-16-16-16-7.6 0-13.9 5.2-15.6 12.3-.7 3-3.1 5.4-6.2 6s-6.2-.6-8-3.1l-67.9-91.6C477.8 93.2 451.5 80 423.6 80L384 80c0 27.8-11 54.3-30.5 73.8l-3.1 3.1c-22.5 22.5-53 35.1-84.9 35.1l-3.2 0c-31.8 0-62.3-12.6-84.9-35.1l-3.1-3.1c-18.3-18.3-29.1-42.7-30.3-68.4-19 9-32.1 28.3-32.1 50.7zM584 320a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M120 80c-30.9 0-56 25.1-56 56l0 132.8C64 297.1 41.1 320 12.8 320 5.7 320 0 314.3 0 307.2L0 288c0-29.8 20.4-54.9 48-62l0-90c0-39.8 32.2-72 72-72l303.6 0c33 0 64 15.6 83.6 42.1l60.3 81.4c5.9-7 14.7-11.4 24.5-11.4 17.7 0 32 14.3 32 32l0 55.8 8.1 11c5.1 6.9 7.9 15.2 7.9 23.8l0 93.4c0 30.9-25.1 56-56 56-17.6 0-34.2-8.3-44.8-22.4L488 357.3c-5.2-6.9-8-15.3-8-24l0-49.1-32-21.3 0 153.1c0 17.7-14.3 32-32 32l-48 0c-17.7 0-32-14.3-32-32l0-54-6.7 1.5c-8.4 1.9-16.8 3.3-25.3 4.3l0 .2 0 16c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-14.7c-10.7 .6-21.3 .6-32 0l0 14.7c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-16 0-.2c-8.5-1-16.9-2.5-25.3-4.3l-6.7-1.5 0 54c0 17.7-14.3 32-32 32l-48 0c-17.7 0-32-14.3-32-32l0-280c0-22.6 10.4-42.8 26.7-56L120 80zm88 265.6l10.2 2.3c35.4 7.9 72.2 7.9 107.6 0l10.2-2.3 0-17.6c0-35.3-28.7-64-64-64s-64 28.7-64 64l0 17.6zm-48-265c.1 23.2 9.3 45.5 25.8 61.9l3.1 3.1c19.5 19.5 46 30.5 73.5 30.5l3.2 0c27.6 0 54-11 73.5-30.5l3.1-3.1C358.7 126 368 103.6 368 80.2l0-.2-200 0c-2.7 0-5.4 .2-8 .6zm-15.9 4.8c-19 9-32.1 28.3-32.1 50.7l0 280c0 8.8 7.2 16 16 16l48 0c8.8 0 16-7.2 16-16l0-88c0-44.2 35.8-80 80-80s80 35.8 80 80l0 88c0 8.8 7.2 16 16 16l48 0c8.8 0 16-7.2 16-16l0-168c0-3 1.6-5.7 4.2-7.1s5.8-1.2 8.2 .4l48 32c2.2 1.5 3.6 4 3.6 6.7l0 53.3c0 5.2 1.7 10.2 4.8 14.4L552 416c7.6 10.1 19.4 16 32 16 22.1 0 40-17.9 40-40l0-93.4c0-5.1-1.7-10.2-4.7-14.3l-9.7-13.1c-1-1.4-1.6-3-1.6-4.8l0-58.4c0-8.8-7.2-16-16-16-7.6 0-13.9 5.2-15.6 12.3-.7 3-3.1 5.4-6.2 6s-6.2-.6-8-3.1l-67.9-91.6C477.8 93.2 451.5 80 423.6 80l-39.6 0 0 .2c0 27.6-11 54-30.5 73.5l-3.1 3.1c-22.5 22.5-53 35.1-84.9 35.1l-3.2 0c-31.8 0-62.3-12.6-84.9-35.1l-3.1-3.1c-18.3-18.3-29.1-42.7-30.3-68.4zM16 288l0 15.9c17.9-1.6 32-16.7 32-35.1l0-26.1c-18.6 6.6-32 24.4-32 45.3zm536 32a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"]],
    "rss": [448, 512, ["feed"], "f09e", ["M16 416a48 48 0 1 0 96 0 48 48 0 1 0 -96 0z", "M8 32c-4.4 0-8 3.6-8 8s3.6 8 8 8c234.2 0 424 189.8 424 424 0 4.4 3.6 8 8 8s8-3.6 8-8C448 229 251 32 8 32zM8 176c-4.4 0-8 3.6-8 8s3.6 8 8 8c154.6 0 280 125.4 280 280 0 4.4 3.6 8 8 8s8-3.6 8-8C304 308.5 171.5 176 8 176zm8 240a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm112 0a64 64 0 1 0 -128 0 64 64 0 1 0 128 0z"]],
    "magnifying-glass": [512, 512, [128269, "search"], "f002", ["M16 208a192 192 0 1 0 384 0 192 192 0 1 0 -384 0z", "M400 208a192 192 0 1 0 -384 0 192 192 0 1 0 384 0zM349.3 360.6C312.2 395 262.6 416 208 416 93.1 416 0 322.9 0 208S93.1 0 208 0 416 93.1 416 208c0 54.6-21 104.2-55.4 141.3l149 149c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-149-149z"]],
    "objects-align-left": [512, 512, [], "e3be", ["M112 112l0 64c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32L144 80c-17.7 0-32 14.3-32 32zm0 224l0 64c0 17.7 14.3 32 32 32l192 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-192 0c-17.7 0-32 14.3-32 32z", "M0 8C0 3.6 3.6 0 8 0s8 3.6 8 8l0 496c0 4.4-3.6 8-8 8s-8-3.6-8-8L0 8zM112 176c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32L144 80c-17.7 0-32 14.3-32 32l0 64zM96 112c0-26.5 21.5-48 48-48l320 0c26.5 0 48 21.5 48 48l0 64c0 26.5-21.5 48-48 48l-320 0c-26.5 0-48-21.5-48-48l0-64zm16 288c0 17.7 14.3 32 32 32l192 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-192 0c-17.7 0-32 14.3-32 32l0 64zM96 336c0-26.5 21.5-48 48-48l192 0c26.5 0 48 21.5 48 48l0 64c0 26.5-21.5 48-48 48l-192 0c-26.5 0-48-21.5-48-48l0-64z"]],
    "cloud-moon": [640, 512, [], "f6c3", ["M48 416c0 44.2 35.8 80 80 80l272 0c35.3 0 63.9-28.7 63.9-64 0-34.2-26.8-62.1-60.5-63.9-2.5-.1-4.8-1.4-6.2-3.5s-1.7-4.7-.9-7.1c2.4-6.7 3.7-13.9 3.7-21.4 0-35.3-28.7-64-64-64-16.5 0-31.6 6.2-42.9 16.5-1.9 1.7-4.5 2.4-6.9 1.9s-4.6-2.1-5.7-4.4c-12.8-27.2-40.4-46-72.4-46-44.2 0-80 35.8-80 80 0 2.6 .1 5.1 .4 7.6 .2 2.1-.5 4.2-1.8 5.9s-3.3 2.7-5.5 2.8C80.1 339.8 48 374.1 48 416zM304 192c0 6.7 .4 13.3 1.1 19.7 9.9-2.4 20.2-3.7 30.8-3.7 65.5 0 119.5 49.2 127.1 112.6 19 10.8 35 26.3 46.4 45 35.6-6 67.6-22.7 92.6-46.6 .6-.6 .8-1.5 .4-2.3s-1.1-1.2-2-1.2c-4.1 .3-8.2 .5-12.4 .5-85.1 0-154-68.9-154-154 0-60.4 34.8-112.7 85.4-137.9 .8-.4 1.2-1.2 1.1-2s-.7-1.5-1.5-1.7c-12.5-2.8-25.6-4.3-39-4.3-97.2 0-176 78.8-176 176z", "M480 16c13.4 0 26.4 1.5 39 4.3 .8 .2 1.4 .9 1.5 1.7s-.3 1.7-1.1 2c-50.6 25.2-85.4 77.5-85.4 137.9 0 85.1 68.9 154 154 154 4.2 0 8.3-.2 12.4-.5 .8-.1 1.6 .4 2 1.2s.2 1.7-.4 2.3c-24.9 24-56.9 40.6-92.6 46.6 2.9 4.8 5.5 9.7 7.7 14.9 36.8-7.2 69.9-24.9 95.9-49.9 5.5-5.3 7.1-13.4 3.9-20.4s-10.3-11.2-17.8-10.6c-3.7 .3-7.4 .4-11.1 .4-76.2 0-138-61.8-138-138 0-54.1 31.1-101 76.6-123.6 6.8-3.4 10.8-10.7 9.8-18.3S529.9 6.4 522.5 4.7c-13.7-3.1-27.9-4.7-42.5-4.7-106 0-192 86-192 192 0 2.8 .1 5.6 .2 8.4 5.3 3.6 10.4 7.5 15.2 11.8 .6-.1 1.1-.3 1.7-.4-.7-6.5-1.1-13.1-1.1-19.7 0-97.2 78.8-176 176-176zM128 320c0-44.2 35.8-80 80-80 32 0 59.6 18.8 72.4 46 1.1 2.3 3.2 3.9 5.7 4.4s5.1-.2 6.9-1.9c11.4-10.3 26.4-16.5 42.9-16.5 35.3 0 64 28.7 64 64 0 7.5-1.3 14.7-3.7 21.4-.8 2.4-.5 5 .9 7.1s3.7 3.4 6.2 3.5c33.7 1.8 60.5 29.7 60.5 63.9 0 35.3-28.6 64-63.9 64l-272 0c-44.2 0-80-35.8-80-80 0-41.8 32.1-76.2 73.1-79.7 2.1-.2 4.1-1.2 5.5-2.8s2-3.8 1.8-5.9c-.2-2.5-.4-5-.4-7.6zm162.2-49.6c-16.8-27.8-47.3-46.4-82.2-46.4-53.5 0-96.7 44-96 97.3-45.4 7.6-80 47.1-80 94.7 0 53 43 96 96 96l272 0c44.1 0 79.9-35.8 79.9-80 0-39.4-28.4-72.1-65.8-78.7 1.2-5.6 1.9-11.3 1.9-17.2 0-44.2-35.8-80-80-80-17 0-32.8 5.3-45.8 14.4z"]],
    "abacus": [576, 512, [129518], "f640", ["M16 96l0 104 120 0 0-40-8 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l8 0 0-48-72 0C37.5 48 16 69.5 16 96zm0 120l0 200c0 26.5 21.5 48 48 48l72 0 0-48-8 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l8 0 0-32-8 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l8 0 0-40-120 0zM152 48l0 48 8 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-8 0 0 40 112 0 0-40-8 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l8 0 0-48-112 0zm0 168l0 40 8 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-8 0 0 32 8 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-8 0 0 48 112 0 0-48-8 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l8 0 0-32-8 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l8 0 0-40-112 0zM280 48l0 48 8 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-8 0 0 40 144 0 0-40-8 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l8 0 0-48-144 0zm0 168l0 40 8 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-8 0 0 32 8 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-8 0 0 48 144 0 0-48-8 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l8 0 0-136-144 0zM440 48l0 48 8 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-8 0 0 40 120 0 0-104c0-26.5-21.5-48-48-48l-72 0zm0 168l0 136 8 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-8 0 0 48 72 0c26.5 0 48-21.5 48-48l0-200-120 0z", "M440 48l0 48 8 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-8 0 0 40 120 0 0-104c0-26.5-21.5-48-48-48l-72 0zM416 160c-17.7 0-32-14.3-32-32s14.3-32 32-32l8 0 0-48-144 0 0 48 8 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-8 0 0 40 144 0 0-40-8 0zM264 96l0-48-112 0 0 48 8 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-8 0 0 40 112 0 0-40-8 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l8 0zM128 160c-17.7 0-32-14.3-32-32s14.3-32 32-32l8 0 0-48-72 0C37.5 48 16 69.5 16 96l0 104 120 0 0-40-8 0zM144 32l368 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l80 0zM16 216l0 200c0 26.5 21.5 48 48 48l72 0 0-48-8 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l8 0 0-32-8 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l8 0 0-40-120 0zM152 464l112 0 0-48-8 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l8 0 0-32-8 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l8 0 0-40-112 0 0 40 8 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-8 0 0 32 8 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-8 0 0 48zm128-48l0 48 144 0 0-48-8 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l8 0 0-136-144 0 0 40 8 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-8 0 0 32 8 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-8 0zm160-64l8 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-8 0 0 48 72 0c26.5 0 48-21.5 48-48l0-200-120 0 0 136zM128 112c-8.8 0-16 7.2-16 16s7.2 16 16 16l32 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-32 0zM112 288c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm16 80c-8.8 0-16 7.2-16 16s7.2 16 16 16l32 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-32 0zM240 128c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm16 144c-8.8 0-16 7.2-16 16s7.2 16 16 16l32 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-32 0zM240 384c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zM416 112c-8.8 0-16 7.2-16 16s7.2 16 16 16l32 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-32 0zM400 384c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16z"]],
    "boxes-stacked": [512, 512, [62625, "boxes", "boxes-alt"], "f468", ["M16 288l0 160c0 26.5 21.5 48 48 48l160 0c26.5 0 48-21.5 48-48l0-160c0-26.5-21.5-48-48-48l-32 0 0 64c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-64-32 0c-26.5 0-48 21.5-48 48zM128 64l0 112 256 0 0-112c0-26.5-21.5-48-48-48l-32 0 0 64c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-64-32 0c-26.5 0-48 21.5-48 48zM325.2 496L448 496c26.5 0 48-21.5 48-48l0-160c0-26.5-21.5-48-48-48l-32 0 0 64c0 17.7-14.3 32-32 32l-48 0 0 112c0 17.2-3.9 33.5-10.8 48z", "M336 16c26.5 0 48 21.5 48 48l0 112 16 0 0-112c0-35.3-28.7-64-64-64L176 0c-35.3 0-64 28.7-64 64l0 112 16 0 0-112c0-26.5 21.5-48 48-48l32 0 0 64c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-64 32 0zM224 16l64 0 0 64c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-64zm91.9 496L448 512c35.3 0 64-28.7 64-64l0-160c0-35.3-28.7-64-64-64l-132.1 0c3.5 5 6.6 10.4 9.3 16l74.8 0 0 64c0 8.8-7.2 16-16 16l-48 0 0 16 48 0c17.7 0 32-14.3 32-32l0-64 32 0c26.5 0 48 21.5 48 48l0 160c0 26.5-21.5 48-48 48l-122.8 0c-2.7 5.6-5.8 11-9.3 16zM240 448.1l0-.1 0-160 0 0 0 160 0 .1zM224 240c26.5 0 48 21.5 48 48l0 160c0 26.5-21.5 48-48 48L64 496c-26.5 0-48-21.5-48-48l0-160c0-26.5 21.5-48 48-48l32 0 0 64c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-64 32 0zm-112 0l64 0 0 64c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-64zm112-16L64 224c-35.3 0-64 28.7-64 64L0 448c0 35.3 28.7 64 64 64l160 0c35.3 0 64-28.7 64-64l0-160c0-35.3-28.7-64-64-64z"]],
    "code-branch": [448, 512, [], "f126", ["M16 72A56 56 0 1 0 128 72 56 56 0 1 0 16 72zm0 368a56 56 0 1 0 112 0 56 56 0 1 0 -112 0zM320 72a56 56 0 1 0 112 0 56 56 0 1 0 -112 0z", "M72 128a56 56 0 1 0 0-112 56 56 0 1 0 0 112zm72-56c0 37.1-28 67.6-64 71.6l0 112.4 216 0c39.8 0 72-32.2 72-72l0-40.4c-36-4-64-34.5-64-71.6 0-39.8 32.2-72 72-72s72 32.2 72 72c0 37.1-28 67.6-64 71.6l0 40.4c0 48.6-39.4 88-88 88l-216 0 0 96.4c36 4 64 34.5 64 71.6 0 39.8-32.2 72-72 72S0 479.8 0 440c0-37.1 28-67.6 64-71.6l0-224.9C28 139.6 0 109.1 0 72 0 32.2 32.2 0 72 0s72 32.2 72 72zm232 56a56 56 0 1 0 0-112 56 56 0 1 0 0 112zM16 440a56 56 0 1 0 112 0 56 56 0 1 0 -112 0z"]],
    "ban": [512, 512, [128683, "cancel"], "f05e", ["M16 256c0 132.5 107.5 240 240 240 63.4 0 121.1-24.6 164-64.7L80.7 92C40.6 134.9 16 192.6 16 256zM92 80.7L431.3 420c40.2-42.9 64.7-100.6 64.7-164 0-132.5-107.5-240-240-240-63.4 0-121.1 24.6-164 64.7z", "M420 431.3L80.7 92c-40.2 42.9-64.7 100.6-64.7 164 0 132.5 107.5 240 240 240 63.4 0 121.1-24.6 164-64.7zM431.3 420c40.2-42.9 64.7-100.6 64.7-164 0-132.5-107.5-240-240-240-63.4 0-121.1 24.6-164 64.7L431.3 420zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0z"]],
    "person-carry-box": [384, 512, ["person-carry"], "f4cf", ["M16 171.1c0-23.8 19.3-43.1 43.1-43.1 18.3 0 35.5 8.8 46.1 23.7l48.7 68.2c9 12.6 23.6 20.1 39.1 20.1l31.1 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-31.1 0c-25.8 0-50.1-12.5-65.1-33.5l-17.3-24.3c-2-2.8-5.6-4-9-3s-5.6 4.1-5.6 7.6l0 115.2c0 2.3 1 4.6 2.8 6.1l33.3 28.5c17.7 15.2 27.9 37.4 27.9 60.7l0 82.6c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-82.6c0-14-6.1-27.3-16.8-36.4L43.9 335.3C26.2 320.1 16 297.9 16 274.6l0-103.5zm0 214c10.7 9.1 21.3 18.3 32 27.4L48 512c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-126.9zM104 24a40 40 0 1 1 -80 0 40 40 0 1 1 80 0zM32 544c17.6 0 31.9-14.2 32-32 0 17.7-14.3 32-32 32zM208 144c0-17.7 14.3-32 32-32l96 0c17.7 0 32 14.3 32 32l0 96c0 17.7-14.3 32-32 32l-84.3 0c2.7-4.7 4.3-10.2 4.3-16 0-17.7-14.3-32-32-32l-16 0 0-80z", "M64-16a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm0 96A56 56 0 1 0 64-32 56 56 0 1 0 64 80zm-4.9 32C26.5 112 0 138.5 0 171.1L0 274.6c0 28 12.2 54.7 33.5 72.9l67.3 57.7c7.1 6.1 11.2 15 11.2 24.3l0 82.6c0 17.7 14.3 32 32 32s32-14.3 32-32l0-82.6c0-28-12.2-54.7-33.5-72.9l-30.5-26.1 0-86.6 2.8 3.9c18 25.2 47.1 40.2 78.1 40.2l31.1 0c2.5 0 4.9-.3 7.2-.8 2.9 .5 5.8 .8 8.8 .8l96 0c26.5 0 48-21.5 48-48l0-96c0-26.5-21.5-48-48-48l-96 0c-26.5 0-48 21.5-48 48l0 80c-10-.3-19.3-5.2-25.1-13.4l-48.7-68.2C104.6 123.3 82.5 112 59.1 112zM208 224l0-80c0-17.7 14.3-32 32-32l96 0c17.7 0 32 14.3 32 32l0 96c0 17.7-14.3 32-32 32l-84.3 0c2.7-4.7 4.3-10.2 4.3-16 0-17.7-14.3-32-32-32l-16 0zM16 171.1c0-23.8 19.3-43.1 43.1-43.1 18.3 0 35.5 8.8 46.1 23.7l48.7 68.2c9 12.6 23.6 20.1 39.1 20.1l31.1 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-31.1 0c-25.8 0-50.1-12.5-65.1-33.5l-17.3-24.3c-2-2.8-5.6-4-9-3s-5.6 4.1-5.6 7.6l0 115.2c0 2.3 1 4.6 2.8 6.1l33.3 28.5c17.7 15.2 27.9 37.4 27.9 60.7l0 82.6c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-82.6c0-14-6.1-27.3-16.8-36.4L43.9 335.3C26.2 320.1 16 297.9 16 274.6l0-103.5zM0 512c0 17.7 14.3 32 32 32s32-14.3 32-32l0-85.7-16-13.7 0 99.5c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-126.9-8.5-7.3c-2.6-2.2-5.1-4.5-7.5-6.9L0 512z"]],
    "circle-litecoin": [512, 512, [], "e6f4", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zm136.4 2.5c-1.4-4.2 .9-8.7 5.1-10.1l50.5-16.8 0-95.6c0-4.4 3.6-8 8-8s8 3.6 8 8l0 90.2 77.5-25.8c4.2-1.4 8.7 .9 10.1 5.1s-.9 8.7-5.1 10.1l-82.5 27.5 0 124.9 120 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-128 0c-2.1 0-4.2-.8-5.7-2.3s-2.3-3.5-2.3-5.7l0-127.6-45.5 15.2c-4.2 1.4-8.7-.9-10.1-5.1z", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM216 128c-4.4 0-8 3.6-8 8l0 95.6-50.5 16.8c-4.2 1.4-6.5 5.9-5.1 10.1s5.9 6.5 10.1 5.1L208 248.4 208 376c0 2.1 .8 4.2 2.3 5.7s3.5 2.3 5.7 2.3l128 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-120 0 0-124.9 82.5-27.5c4.2-1.4 6.5-5.9 5.1-10.1s-5.9-6.5-10.1-5.1L224 226.2 224 136c0-4.4-3.6-8-8-8z"]],
    "jug-detergent": [384, 512, [], "e519", ["M16 256l0 192c0 26.5 21.5 48 48 48l256 0c26.5 0 48-21.5 48-48l0-192c0-61.9-50.1-112-112-112l-128 0C66.1 144 16 194.1 16 256zM112 24l0 56 96 0 0-56c0-4.4-3.6-8-8-8l-80 0c-4.4 0-8 3.6-8 8zM240 248c0-22.1 17.9-40 40-40s40 17.9 40 40l0 80c0 22.1-17.9 40-40 40s-40-17.9-40-40l0-80z", "M120 16l80 0c4.4 0 8 3.6 8 8l0 56-96 0 0-56c0-4.4 3.6-8 8-8zM96 80L72 80c-4.4 0-8 3.6-8 8s3.6 8 8 8l176 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-24 0 0-56c0-13.3-10.7-24-24-24L120 0C106.7 0 96 10.7 96 24l0 56zm160 64c61.9 0 112 50.1 112 112l0 192c0 26.5-21.5 48-48 48L64 496c-26.5 0-48-21.5-48-48l0-192c0-61.9 50.1-112 112-112l128 0zM128 128C57.3 128 0 185.3 0 256L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-192c0-70.7-57.3-128-128-128l-128 0zm152 80c-22.1 0-40 17.9-40 40l0 80c0 22.1 17.9 40 40 40s40-17.9 40-40l0-80c0-22.1-17.9-40-40-40zm-24 40c0-13.3 10.7-24 24-24s24 10.7 24 24l0 80c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-80z"]],
    "floppy-disk-pen": [640, 512, [], "e182", ["M80 96c0-26.5 21.5-48 48-48l32 0 0 128c0 17.7 14.3 32 32 32l160 0c17.7 0 32-14.3 32-32l0-126.1c7.7 2.2 14.9 6.4 20.7 12.2L482 139.3c9 9 14.1 21.2 14.1 33.9l0 47.7c-3.6 2.7-7 5.7-10.3 9L315.5 400.2c-15.6 15.6-26.3 35.5-30.6 57.2-.4 2.2-.9 4.4-1.3 6.5L128 464c-26.5 0-48-21.5-48-48L80 96zM224 320a64 64 0 1 0 128 0 64 64 0 1 0 -128 0z", "M128 48c-26.5 0-48 21.5-48 48l0 320c0 26.5 21.5 48 48 48l155.5 0-3.2 16-152.3 0c-35.3 0-64-28.7-64-64L64 96c0-35.3 28.7-64 64-64l242.7 0c17 0 33.3 6.7 45.3 18.7L493.3 128c12 12 18.7 28.3 18.7 45.3l0 37.5c-5.6 2.8-10.9 6.2-16 10.1l0-47.7c0-12.7-5.1-24.9-14.1-33.9L404.7 62.1c-5.8-5.8-12.9-10-20.7-12.2L384 176c0 17.7-14.3 32-32 32l-160 0c-17.7 0-32-14.3-32-32l0-128-32 0zm48 0l0 128c0 8.8 7.2 16 16 16l160 0c8.8 0 16-7.2 16-16l0-128-192 0zM288 368a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm0-112a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm48.4 271.6l57.5-11.5c9.3-1.9 17.8-6.4 24.5-13.1L551 370.4 493.6 313 361 445.6c-6.7 6.7-11.3 15.2-13.1 24.5l-11.5 57.5zM588.7 332.7c15.8-15.8 15.8-41.5 0-57.4s-41.5-15.8-57.4 0l-26.4 26.4 57.4 57.4 26.4-26.4zM320.3 526.6L332.2 467c2.5-12.4 8.6-23.8 17.5-32.7L520 264c22.1-22.1 57.9-22.1 80 0s22.1 57.9 0 80L429.7 514.3c-8.9 8.9-20.3 15-32.7 17.5l-59.6 11.9c-.9 .2-1.9 .3-2.9 .3-8 0-14.6-6.5-14.6-14.6 0-1 .1-1.9 .3-2.9z"]],
    "lips": [576, 512, [128068, 128482], "f600", ["M26.2 256.1l72.8 93C140 401.4 202.7 432 269.1 432l37.7 0c66.4 0 129.2-30.6 170.1-82.9l72.8-93-110.5-135c-17.1-20.9-42.7-33.1-69.8-33.1-14.8 0-29.4 3.7-42.5 10.6l-35.2 18.8c-2.4 1.3-5.2 1.3-7.5 0L249 98.6c-13.1-7-27.7-10.6-42.5-10.6-27 0-52.7 12.1-69.8 33.1L26.2 256.1zm93.8 .7c-.2-2.4 .6-4.7 2.3-6.4l64-64c2.1-2.1 5.3-2.9 8.2-1.9l93.5 31.2 93.5-31.2c2.9-1 6-.2 8.2 1.9l64 64c1.7 1.7 2.5 4.1 2.3 6.4s-1.5 4.5-3.5 5.9l-47.6 31.8C372 316.3 333.4 328 293.9 328l-11.7 0c-39.5 0-78.1-11.7-110.9-33.6l-47.6-31.8c-2-1.3-3.3-3.5-3.5-5.9z", "M206.5 72c-31.8 0-62 14.3-82.2 38.9L9.8 250.9c-2.4 2.9-2.4 7-.1 10L86.4 359c44 56.2 111.4 89 182.7 89l37.7 0c71.4 0 138.7-32.8 182.7-89l76.7-98.1c2.3-2.9 2.3-7.1-.1-10l-114.5-140c-20.2-24.6-50.3-38.9-82.2-38.9-17.5 0-34.6 4.3-50 12.5L288 101.3 256.6 84.5C241.2 76.3 224 72 206.5 72zm-69.8 49.1c17.1-20.9 42.7-33.1 69.8-33.1 14.8 0 29.4 3.7 42.5 10.6l35.2 18.8c2.4 1.3 5.2 1.3 7.5 0L327 98.6c13.1-7 27.7-10.6 42.5-10.6 27 0 52.7 12.1 69.8 33.1l110.5 135-72.8 93C436 401.4 373.3 432 306.9 432l-37.7 0C202.7 432 140 401.4 99 349.1l-72.8-93 110.5-135zm57.8 63.3c-2.9-1-6-.2-8.2 1.9l-64 64c-1.7 1.7-2.5 4.1-2.3 6.4s1.5 4.5 3.5 5.9l47.6 31.8C204 316.3 242.6 328 282.1 328l11.7 0c39.5 0 78.1-11.7 110.9-33.6l47.6-31.8c2-1.3 3.3-3.5 3.5-5.9s-.6-4.7-2.3-6.4l-64-64c-2.1-2.1-5.3-2.9-8.2-1.9l-93.5 31.2-93.5-31.2zm-54 70.3l53.6-53.6 91.3 30.4c1.6 .5 3.4 .5 5.1 0l91.3-30.4 53.6 53.6-39.5 26.3C365.7 301.2 330.2 312 293.9 312l-11.7 0c-36.3 0-71.8-10.8-102.1-30.9l-39.5-26.3z"]],
    "outlet": [448, 512, [], "e01c", ["M16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96zM80 256c0-61.1 30.8-99.1 49.7-116.6 8.8-8.2 20.7-11.4 32.6-11.4l123.3 0c12 0 23.9 3.3 32.6 11.4 18.9 17.5 49.7 55.5 49.7 116.6s-30.8 99-49.7 116.6c-8.8 8.2-20.7 11.4-32.6 11.4l-123.3 0c-12 0-23.9-3.3-32.6-11.4-18.9-17.5-49.7-55.5-49.7-116.6zm128 48l0 16 32 0 0-16c0-8.8-7.2-16-16-16s-16 7.2-16 16z", "M64 48C37.5 48 16 69.5 16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM96 256c0 55.2 27.7 89.2 44.6 104.8 5 4.6 12.5 7.2 21.8 7.2l123.3 0c9.3 0 16.8-2.6 21.8-7.2 16.9-15.7 44.6-49.7 44.6-104.8s-27.7-89.2-44.6-104.8c-5-4.6-12.5-7.2-21.8-7.2l-123.3 0c-9.3 0-16.8 2.6-21.8 7.2-16.9 15.7-44.6 49.7-44.6 104.8zm-16 0c0-61.1 30.8-99.1 49.7-116.6 8.8-8.2 20.7-11.4 32.6-11.4l123.3 0c12 0 23.9 3.3 32.6 11.4 18.9 17.5 49.7 55.5 49.7 116.6s-30.8 99-49.7 116.6c-8.8 8.2-20.7 11.4-32.6 11.4l-123.3 0c-12 0-23.9-3.3-32.6-11.4-18.9-17.5-49.7-55.5-49.7-116.6zm88-64c4.4 0 8 3.6 8 8l0 48c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-48c0-4.4 3.6-8 8-8zm112 0c4.4 0 8 3.6 8 8l0 48c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-48c0-4.4 3.6-8 8-8zm-56 80c17.7 0 32 14.3 32 32l0 24c0 4.4-3.6 8-8 8l-48 0c-4.4 0-8-3.6-8-8l0-24c0-17.7 14.3-32 32-32zm-16 32l0 16 32 0 0-16c0-8.8-7.2-16-16-16s-16 7.2-16 16z"]],
    "reply": [512, 512, [61714, "mail-reply"], "f3e5", ["M20.7 196.7l160-160c4.6-4.6 11.5-5.9 17.4-3.5S208 41.5 208 48l0 80c0 8.8 7.2 16 16 16l112 0c88.4 0 160 71.6 160 160 0 104.2-74.6 150.7-91.8 160-.1 0-.2 0-.6 0-2 0-3.7-1.6-3.7-3.7 0-1.4 1-4.4 4.7-7.8 12.1-11.3 27.3-32.9 27.3-68.4 0-61.9-50.1-112-112-112l-96 0c-8.8 0-16 7.2-16 16l0 80c0 6.5-3.9 12.3-9.9 14.8s-12.9 1.1-17.4-3.5l-160-160c-6.2-6.2-6.2-16.4 0-22.6z", "M224 144c-8.8 0-16-7.2-16-16l0-80c0-6.5-3.9-12.3-9.9-14.8s-12.9-1.1-17.4 3.5l-160 160-11.3-11.3 160-160c9.2-9.2 22.9-11.9 34.9-6.9S224 35.1 224 48l0 80 112 0c97.2 0 176 78.8 176 176 0 113.3-81.5 163.9-100.2 174.1-2.5 1.4-5.3 1.9-8.1 1.9-10.9 0-19.7-8.9-19.7-19.7 0-7.5 4.3-14.4 9.8-19.5 9.4-8.8 22.2-26.4 22.2-56.7 0-53-43-96-96-96l-96 0 0 80c0 12.9-7.8 24.6-19.8 29.6s-25.7 2.2-34.9-6.9l-160-160c-12.5-12.5-12.5-32.8 0-45.3l11.3 11.3c-6.2 6.2-6.2 16.4 0 22.6l0 0 160 160c4.6 4.6 11.5 5.9 17.4 3.5s9.9-8.3 9.9-14.8l0-80c0-8.8 7.2-16 16-16l96 0c61.9 0 112 50.1 112 112 0 35.5-15.2 57.1-27.3 68.4-3.7 3.5-4.7 6.5-4.7 7.8 0 2.1 1.7 3.7 3.7 3.7 .3 0 .5 0 .6 0 17.1-9.3 91.8-55.7 91.8-160 0-88.4-71.6-160-160-160l-112 0z"]],
    "sun-plant-wilt": [640, 512, [], "e57a", ["M24.8 160l53 28.6c3.3 1.8 5 5.7 3.9 9.3l-17.3 57.6 57.7-17.2 1.4-.3c3.2-.4 6.4 1.2 8 4.2l28.6 53 28.6-53 .8-1.2c2-2.5 5.4-3.6 8.6-2.7l57.6 17.2-17.2-57.6c-1.1-3.6 .5-7.5 3.9-9.3l53-28.6-53-28.6c-3.3-1.8-5-5.7-3.9-9.3l17.2-57.7-57.6 17.3c-3.6 1.1-7.5-.5-9.3-3.9l-28.6-53-28.6 53c-1.8 3.3-5.7 5-9.3 3.9L64.4 64.4 81.7 122.1c1 3.2-.2 6.6-2.7 8.6l-1.2 .8-53 28.6zm183.8 1.2a48 48 0 1 1 -96 0 48 48 0 1 1 96 0zM328 338.1c0 7.4 4.3 19 12.8 32.7 7.1 11.3 16.6 23.2 27.2 33.9 10.6-10.8 20.1-22.7 27.2-34 8.5-13.7 12.8-25.3 12.8-32.6 0-14.1-4.4-24.4-11.1-31.3S380.3 296 368 296 345.8 300 339.1 306.8 328 324 328 338.1zm216-64c0 7.4 4.3 19 12.8 32.7 7.1 11.3 16.6 23.2 27.2 33.9 10.6-10.8 20.1-22.7 27.2-34 8.5-13.7 12.8-25.3 12.8-32.6 0-14.1-4.4-24.4-11.1-31.3S596.3 232 584 232 561.8 236 555.1 242.8 544 260 544 274.1z", "M536 104c30.9 0 56 25.1 56 56l0 56.5c12.6 1.5 23.8 6.5 32.3 15.1 10.2 10.3 15.7 25 15.7 42.5 0 12-6.4 26.8-15.3 41-9.1 14.6-21.5 29.8-35.2 42.7l-1.3 1c-3 1.9-7.1 1.6-9.8-1-13.7-12.9-26.1-28.1-35.2-42.6-8.9-14.2-15.3-29-15.3-41.1 0-17.5 5.5-32.2 15.7-42.5 8.5-8.6 19.7-13.6 32.3-15.1l0-56.5c0-22.1-17.9-40-40-40s-40 17.9-40 40l0 336 136 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L8 512c-4.4 0-8-3.6-8-8s3.6-8 8-8l472 0 0-236c0-28.7-23.3-52-52-52s-52 23.3-52 52l0 20.5c12.6 1.5 23.8 6.5 32.3 15.1 10.2 10.3 15.7 25 15.7 42.5 0 12-6.4 26.8-15.3 41-9.1 14.6-21.5 29.8-35.2 42.7l-1.3 1c-3 1.9-7.1 1.6-9.8-1-13.7-12.9-26.1-28.1-35.2-42.6-8.9-14.2-15.3-29-15.3-41.1 0-17.5 5.5-32.2 15.7-42.5 8.5-8.6 19.7-13.6 32.3-15.1l0-20.5c0-37.6 30.4-68 68-68 20.9 0 39.5 9.4 52 24.2l0-56.2c0-30.9 25.1-56 56-56zM368 296c-12.3 0-22.2 4-28.9 10.8S328 324 328 338.1c0 7.4 4.3 19 12.8 32.7 7.1 11.3 16.6 23.2 27.2 33.9 10.6-10.8 20.1-22.7 27.2-34 8.5-13.7 12.8-25.3 12.8-32.6 0-14.1-4.4-24.4-11.1-31.3S380.3 296 368 296zm216-64c-12.3 0-22.2 4-28.9 10.8S544 260 544 274.1c0 7.4 4.3 19 12.8 32.7 7.1 11.3 16.6 23.2 27.2 33.9 10.6-10.8 20.1-22.7 27.2-34 8.5-13.7 12.8-25.3 12.8-32.6 0-14.1-4.4-24.4-11.1-31.3S596.3 232 584 232zM160 0c2.9 0 5.6 1.6 7 4.2l32.5 60.3 65.6-19.7c2.8-.8 5.9 0 7.9 2s2.9 5.1 2 7.9l-19.7 65.6 60.3 32.6c2.6 1.4 4.2 4.1 4.2 7s-1.6 5.6-4.2 7l-60.3 32.5 19.7 65.6c.8 2.8 0 5.9-2 7.9s-5.1 2.9-7.9 2l-65.6-19.7-32.5 60.3c-1.4 2.6-4.1 4.2-7 4.2s-5.6-1.6-7-4.2l-32.6-60.3-65.6 19.7c-2.8 .8-5.9 0-7.9-2s-2.9-5.1-2-7.9L64.5 199.6 4.2 167c-2.6-1.4-4.2-4.1-4.2-7s1.6-5.6 4.2-7l60.3-32.6-19.7-65.6c-.8-2.8 0-5.9 2-7.9s5.1-2.9 7.9-2l65.6 19.7 32.6-60.3 1.3-1.8C155.7 .9 157.8 0 160 0zM131.4 77.8c-1.8 3.3-5.7 5-9.3 3.9L64.4 64.4 81.7 122.1c1 3.2-.2 6.6-2.7 8.6l-1.2 .8-53 28.6 53 28.6c3.3 1.8 5 5.7 3.9 9.3l-17.3 57.6 57.7-17.2 1.4-.3c3.2-.4 6.4 1.2 8 4.2l28.6 53 28.6-53 .8-1.2c2-2.5 5.4-3.6 8.6-2.7l57.6 17.2-17.2-57.6c-1.1-3.6 .5-7.5 3.9-9.3l53-28.6-53-28.6c-3.3-1.8-5-5.7-3.9-9.3l17.2-57.7-57.6 17.3c-3.6 1.1-7.5-.5-9.3-3.9l-28.6-53-28.6 53zm29.2 131.3a48 48 0 1 1 0-96 48 48 0 1 1 0 96zm0-80a32 32 0 1 0 0 64 32 32 0 1 0 0-64z"]],
    "face-mask": [512, 512, [], "e37f", ["M16 256c0 72.2 31.9 136.9 82.3 180.9-1.5-6.7-2.3-13.7-2.3-20.9l0-96c0-13.8 4.4-26.7 11.9-37.1L16.7 237.3c-.5 6.2-.7 12.4-.7 18.7zm2.6-35.6l100.6 50.3c11.1-9.2 25.3-14.7 40.8-14.7l192 0c15.5 0 29.7 5.5 40.8 14.7l100.6-50.3C476.2 104.7 376.4 16 256 16S35.8 104.7 18.6 220.4zm95-23.6c-2.7-3.5-1.9-8.5 1.6-11.2l6.4-4.8c18-13.5 39.9-20.8 62.4-20.8l32 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-32 0c-19 0-37.6 6.2-52.8 17.6l-6.4 4.8c-3.5 2.7-8.5 1.9-11.2-1.6zM288 168c0-4.4 3.6-8 8-8l32 0c22.5 0 44.4 7.3 62.4 20.8l6.4 4.8c3.5 2.7 4.3 7.7 1.6 11.2s-7.7 4.3-11.2 1.6l-6.4-4.8C365.6 182.2 347 176 328 176l-32 0c-4.4 0-8-3.6-8-8zM404.1 282.9c7.5 10.5 11.9 23.3 11.9 37.1l0 96c0 7.2-.8 14.2-2.3 20.9 50.4-44 82.3-108.7 82.3-180.9 0-6.3-.2-12.5-.7-18.7l-91.1 45.6z", "M401.6 466.6C468.3 420.4 512 343.3 512 256 512 114.6 397.4 0 256 0S0 114.6 0 256c0 87.3 43.7 164.4 110.4 210.6 16.9 27.3 47.2 45.4 81.6 45.4l128 0c34.5 0 64.7-18.2 81.6-45.4zm12.1-29.7c1.5-6.7 2.3-13.7 2.3-20.9l0-96c0-13.8-4.4-26.7-11.9-37.1l91.1-45.6c.5 6.2 .7 12.4 .7 18.7 0 72.2-31.9 136.9-82.3 180.9zM256 16c120.4 0 220.2 88.7 237.4 204.4L392.8 270.7C381.7 261.5 367.5 256 352 256l-192 0c-15.5 0-29.7 5.5-40.8 14.7L18.6 220.4C35.8 104.7 135.6 16 256 16zM96 320l0 96c0 7.2 .8 14.2 2.3 20.9-50.4-44-82.3-108.7-82.3-180.9 0-6.3 .2-12.5 .7-18.7l91.1 45.6C100.4 293.3 96 306.2 96 320zm16 0c0-26.5 21.5-48 48-48l192 0c26.5 0 48 21.5 48 48l0 96c0 44.2-35.8 80-80 80l-128 0c-44.2 0-80-35.8-80-80l0-96zM288 168c0 4.4 3.6 8 8 8l32 0c19 0 37.6 6.2 52.8 17.6l6.4 4.8c3.5 2.7 8.6 1.9 11.2-1.6s1.9-8.5-1.6-11.2l-6.4-4.8c-18-13.5-39.9-20.8-62.4-20.8l-32 0c-4.4 0-8 3.6-8 8zm-72-8l-32 0c-22.5 0-44.4 7.3-62.4 20.8l-6.4 4.8c-3.5 2.7-4.3 7.7-1.6 11.2s7.7 4.3 11.2 1.6l6.4-4.8C146.4 182.2 165 176 184 176l32 0c4.4 0 8-3.6 8-8s-3.6-8-8-8zM168 336c-4.4 0-8 3.6-8 8s3.6 8 8 8l176 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-176 0zm0 80c-4.4 0-8 3.6-8 8s3.6 8 8 8l176 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-176 0z"]],
    "falafel": [576, 512, [129478], "e40a", ["M22.4 342.5c5.7-6.7 7.7-15.7 5.5-24.2-3.3-12.8 3.1-26.1 15.2-31.5 8-3.6 13.8-10.8 15.5-19.4 2.6-13 14.2-22.2 27.4-21.8 8.8 .2 17.2-3.8 22.5-10.8 8-10.6 22.4-13.8 34.2-7.8 7.8 4 17.1 4 24.9 0 11.8-6.1 26.2-2.8 34.2 7.8 5.3 7 13.7 11 22.5 10.8 13.2-.4 24.8 8.8 27.4 21.8 1.7 8.6 7.5 15.8 15.5 19.4 2.3 1 4.3 2.3 6.1 3.8-5.7 12.1-8.2 25.6-6.8 39.3-14.1 23.4-14.1 52.9 0 76.3-.9 9-.2 17.9 2.1 26.4-.5 .2-.9 .5-1.4 .7-8 3.6-13.8 10.8-15.5 19.4-2.6 13-14.2 22.2-27.4 21.8-8.8-.2-17.2 3.8-22.5 10.8-8 10.6-22.4 13.8-34.2 7.8-7.8-4-17.1-4-24.9 0-11.8 6.1-26.2 2.8-34.2-7.8-5.3-7-13.7-11-22.5-10.8-13.2 .4-24.8-8.8-27.4-21.8-1.7-8.6-7.5-15.8-15.5-19.4-12.1-5.4-18.5-18.7-15.2-31.5 2.2-8.5 .1-17.5-5.5-24.2-8.5-10.1-8.5-24.9 0-34.9zM64 368a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm32 64a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm78.3-297.5c5.5-6.7 7.6-15.7 5.4-24.2-3.2-12.8 3-26.1 14.9-31.5 7.8-3.6 13.5-10.8 15.2-19.4 2.5-13 13.8-22.2 26.8-21.8 8.6 .2 16.8-3.8 21.9-10.8 7.8-10.6 21.9-13.8 33.4-7.8 7.6 4 16.7 4 24.4 0 11.5-6.1 25.6-2.8 33.4 7.8 5.2 7 13.4 11 21.9 10.8 12.9-.4 24.2 8.8 26.8 21.8 1.7 8.6 7.3 15.9 15.2 19.4 11.8 5.4 18.1 18.7 14.9 31.5-2.1 8.5-.1 17.5 5.4 24.2 8.3 10.1 8.3 24.9 0 34.9-5.5 6.7-7.6 15.7-5.4 24.2 .1 .3 .2 .6 .2 .9-25-7-52 .1-70.5 18.3-25.6 3.4-47 20.2-57.1 43.2-3.1-2.9-6.6-5.6-10.3-7.9-9.2-26.8-32.9-46.7-61.6-50.1-13.7-13.8-32-21.6-50.9-22.1-1-2.3-2.3-4.5-4-6.5-8.3-10.1-8.3-24.9 0-34.9zm135.6 217c5.2-6.3 7.1-14.8 5.1-22.8-3-12 2.9-24.6 14-29.6 7.4-3.4 12.7-10.2 14.3-18.3 2.4-12.2 13-20.9 25.2-20.5 8.1 .2 15.8-3.6 20.7-10.2 7.3-9.9 20.6-13 31.4-7.3 7.2 3.8 15.7 3.8 22.9 0 10.8-5.7 24.1-2.6 31.4 7.3 4.9 6.6 12.6 10.4 20.7 10.2 12.2-.3 22.8 8.3 25.2 20.5 1.6 8.1 6.9 14.9 14.3 18.3 11.1 5.1 17 17.6 14 29.6-2 8-.1 16.5 5.1 22.8 7.9 9.5 7.9 23.4 0 32.9-5.2 6.3-7.1 14.8-5.1 22.8 3 12-2.9 24.6-14 29.6-7.4 3.4-12.7 10.2-14.3 18.3-2.4 12.2-13 20.9-25.2 20.5-8.1-.2-15.8 3.6-20.7 10.2-7.3 9.9-20.6 13-31.4 7.3-7.2-3.8-15.7-3.8-22.9 0-10.8 5.7-24.1 2.6-31.4-7.3-4.9-6.6-12.6-10.4-20.7-10.2-12.2 .3-22.8-8.3-25.2-20.5-1.6-8.1-6.9-14.9-14.3-18.3-11.1-5.1-17-17.6-14-29.6 2-8 .1-16.5-5.1-22.8-7.9-9.5-7.9-23.4 0-32.9zM384 400a16 16 0 1 0 32 0 16 16 0 1 0 -32 0z", "M160.4 177.7c-11.7-15.9-11.2-38 1.5-53.4 2.3-2.7 3.1-6.5 2.2-10.1-5.1-20.1 4.7-41.3 23.7-50 3.1-1.4 5.4-4.3 6.1-7.9 4-20.4 21.9-35.3 42.9-34.7 3.3 .1 6.5-1.4 8.6-4.3 12.4-16.8 35.1-22.2 53.7-12.4 3 1.6 6.5 1.6 9.4 0 18.6-9.8 41.3-4.4 53.7 12.4 2.1 2.9 5.3 4.4 8.6 4.3 21-.6 39 14.3 42.9 34.7 .7 3.6 3.1 6.5 6.1 7.9 19 8.7 28.8 29.9 23.7 50-.9 3.6 0 7.4 2.2 10.1 13.2 16 13.2 39.3 0 55.3-2.3 2.7-3.1 6.5-2.2 10.1 .2 1 .5 2 .6 3-4.2 .6-8.4 1.6-12.5 3-1.1-.4-2.3-.7-3.5-1.1-.1-.3-.1-.6-.2-.9-2.1-8.5-.1-17.5 5.4-24.2 8.3-10.1 8.3-24.9 0-34.9-5.5-6.7-7.6-15.7-5.4-24.2 3.2-12.8-3-26.1-14.9-31.5-7.8-3.6-13.5-10.8-15.2-19.4-2.5-13-13.8-22.2-26.8-21.8-8.6 .2-16.8-3.8-21.9-10.8-7.8-10.6-21.9-13.8-33.4-7.8-7.6 4-16.7 4-24.4 0-11.5-6.1-25.6-2.8-33.4 7.8-5.2 7-13.3 11-21.9 10.8-12.9-.4-24.2 8.8-26.8 21.8-1.7 8.6-7.3 15.9-15.2 19.4-11.8 5.4-18.1 18.7-14.9 31.5 2.1 8.5 .1 17.5-5.4 24.2-8.3 10.1-8.3 24.9 0 34.9 1.7 2 3 4.2 4 6.5-5.9-.2-11.9 .4-17.9 1.7zM267.2 433.2c.5-.2 1-.4 1.4-.7 1.4 5.2 3.3 10.2 5.8 15l-.7 .3c-3.3 1.5-5.7 4.4-6.4 8-4.1 20.6-22.5 35.2-43.5 34.6-3.6-.1-7.1 1.6-9.2 4.4-12.7 16.8-35.6 22-54.3 12.4-3.2-1.7-7.1-1.7-10.3 0-18.7 9.6-41.6 4.4-54.3-12.4-2.2-2.9-5.6-4.5-9.2-4.4-21 .6-39.4-14-43.5-34.6-.7-3.5-3.1-6.5-6.4-8-19.2-8.6-29.4-29.7-24.2-50.1 .9-3.5 .1-7.1-2.3-9.9-13.6-16.1-13.6-39.6 0-55.6 2.3-2.7 3.2-6.4 2.3-9.9-5.3-20.4 5-41.5 24.2-50.1 3.3-1.5 5.7-4.5 6.4-8 4.1-20.6 22.5-35.2 43.5-34.6 3.6 .1 7.1-1.6 9.2-4.4 12.7-16.8 35.6-22 54.3-12.4 3.2 1.7 7.1 1.7 10.3 0 18.7-9.6 41.6-4.4 54.3 12.4 2.2 2.9 5.6 4.5 9.2 4.4 21-.6 39.4 14 43.5 34.6 .7 3.5 3.1 6.5 6.4 8 2.9 1.3 5.6 2.9 8.1 4.7-3.3 4.3-6.1 8.9-8.4 13.7-1.8-1.5-3.9-2.8-6.1-3.8-8-3.6-13.8-10.8-15.5-19.4-2.6-13-14.2-22.2-27.4-21.8-8.8 .2-17.2-3.8-22.5-10.8-8-10.6-22.4-13.8-34.2-7.8-7.8 4-17.1 4-24.9 0-11.8-6.1-26.2-2.8-34.2 7.8-5.3 7-13.7 11-22.5 10.8-13.2-.4-24.8 8.8-27.4 21.8-1.7 8.6-7.5 15.8-15.5 19.4-12.1 5.4-18.5 18.7-15.2 31.5 2.2 8.5 .1 17.5-5.5 24.2-8.5 10.1-8.5 24.9 0 34.9 5.7 6.7 7.7 15.7 5.5 24.2-3.3 12.8 3.1 26.1 15.2 31.5 8 3.6 13.8 10.8 15.5 19.4 2.6 13 14.2 22.2 27.4 21.8 8.8-.2 17.2 3.8 22.5 10.8 8 10.6 22.4 13.8 34.2 7.8 7.8-4 17.1-4 24.9 0 11.8 6.1 26.2 2.8 34.2-7.8 5.3-7 13.7-11 22.5-10.8 13.2 .4 24.8-8.8 27.4-21.8 1.7-8.6 7.5-15.8 15.5-19.4zM64 368a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm48 48a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM443.5 242.8c-7.2 3.8-15.7 3.8-22.9 0-10.8-5.7-24.1-2.6-31.4 7.3-4.9 6.6-12.6 10.4-20.7 10.2-12.2-.3-22.8 8.3-25.2 20.5-1.6 8.1-6.9 14.9-14.3 18.3-11.1 5.1-17 17.6-14 29.6 2 8 .1 16.5-5.1 22.8-7.9 9.5-7.9 23.4 0 32.9 5.2 6.3 7.1 14.8 5.1 22.8-3 12 2.9 24.6 14 29.6 7.4 3.4 12.7 10.2 14.3 18.3 2.4 12.2 13 20.9 25.2 20.5 8.1-.2 15.8 3.6 20.7 10.2 7.3 9.9 20.6 13 31.4 7.3 7.2-3.8 15.7-3.8 22.9 0 10.8 5.7 24.1 2.6 31.4-7.3 4.9-6.6 12.6-10.4 20.7-10.2 12.2 .3 22.8-8.3 25.2-20.5 1.6-8.1 6.9-14.9 14.3-18.3 11.1-5.1 17-17.6 14-29.6-2-8-.1-16.5 5.1-22.8 7.9-9.5 7.9-23.4 0-32.9-5.2-6.3-7.1-14.8-5.1-22.8 3-12-2.9-24.6-14-29.6-7.4-3.4-12.7-10.2-14.3-18.3-2.4-12.2-13-20.9-25.2-20.5-8.1 .2-15.8-3.6-20.7-10.2-7.3-9.9-20.6-13-31.4-7.3zm51.6 1.5c20.2-.6 37.5 13.8 41.4 33.4 .6 3.1 2.6 5.6 5.2 6.8 18.3 8.4 27.7 28.8 22.8 48.1-.8 3.1 0 6.3 1.9 8.7 12.8 15.4 12.8 37.9 0 53.3-1.9 2.3-2.7 5.6-1.9 8.7 4.9 19.4-4.5 39.7-22.8 48.1-2.6 1.2-4.6 3.7-5.2 6.8-3.8 19.6-21.1 34-41.4 33.4-2.8-.1-5.5 1.2-7.3 3.7-12 16.2-33.8 21.4-51.8 12-2.5-1.3-5.5-1.3-8 0-17.9 9.4-39.8 4.2-51.8-12-1.8-2.4-4.6-3.7-7.3-3.7-20.2 .6-37.5-13.8-41.4-33.4-.6-3.1-2.6-5.6-5.2-6.8-18.3-8.4-27.7-28.8-22.8-48.1 .8-3.1 0-6.3-1.9-8.7-12.8-15.4-12.8-37.9 0-53.3 1.9-2.3 2.7-5.6 1.9-8.7-4.9-19.4 4.5-39.7 22.8-48.1 2.6-1.2 4.6-3.7 5.2-6.8 3.8-19.6 21.1-34 41.4-33.4 2.8 .1 5.5-1.2 7.3-3.7 12-16.2 33.8-21.4 51.8-12 2.5 1.3 5.5 1.3 8 0 17.9-9.4 39.8-4.2 51.8 12 1.8 2.4 4.6 3.7 7.3 3.7zM400 384a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"]],
    "tombstone-blank": [448, 512, [129702, "tombstone-alt"], "f721", ["M48 192l0 304 352 0 0-304c0-97.2-78.8-176-176-176S48 94.8 48 192z", "M400 192c0-97.2-78.8-176-176-176S48 94.8 48 192l0 304 352 0 0-304zM32 496l0-304C32 86 118 0 224 0S416 86 416 192l0 304 24 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L8 512c-4.4 0-8-3.6-8-8s3.6-8 8-8l24 0z"]],
    "circle-caret-up": [512, 512, ["caret-circle-up"], "f331", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zm112 38.8c0-6.4 2.4-12.5 6.8-17.2L236.7 168.4c5-5.4 12-8.4 19.3-8.4s14.3 3 19.3 8.4L377.2 277.6c4.4 4.7 6.8 10.8 6.8 17.2 0 13.9-11.3 25.2-25.2 25.2l-205.6 0c-13.9 0-25.2-11.3-25.2-25.2z", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm0-352c-7.3 0-14.3 3-19.3 8.4L134.8 277.6c-4.4 4.7-6.8 10.8-6.8 17.2 0 13.9 11.3 25.2 25.2 25.2l205.6 0c13.9 0 25.2-11.3 25.2-25.2 0-6.4-2.4-12.5-6.8-17.2L275.3 168.4c-5-5.4-12-8.4-19.3-8.4zm-7.6 19.3c2-2.1 4.7-3.3 7.6-3.3s5.6 1.2 7.6 3.3L365.5 288.5c1.6 1.7 2.5 4 2.5 6.3 0 5.1-4.1 9.2-9.2 9.2l-205.6 0c-5.1 0-9.2-4.1-9.2-9.2 0-2.3 .9-4.6 2.5-6.3L248.4 179.3z"]],
    "lamp-street": [512, 512, [], "e1c5", ["M146.4 322.8c-1 5.9 3.9 13.2 13.6 13.2l320 0c9.7 0 14.6-7.4 13.6-13.2-13.9-83.3-86.4-146.8-173.6-146.8S160.3 239.5 146.4 322.8z", "M16 164C16 82.3 82.3 16 164 16l4 0c79.5 0 144 64.5 144 144 0 .1 0 .1 0 .2-91.6 3.8-166.6 71.7-181.4 160-2.9 17.4 11.7 31.9 29.4 31.9l81.6 0c7.4 36.5 39.7 64 78.4 64s71-27.5 78.4-64l81.6 0c17.7 0 32.3-14.4 29.4-31.9-14.8-88.3-89.8-156.2-181.4-160 0-.1 0-.1 0-.2 0-88.4-71.6-160-160-160l-4 0C73.4 0 0 73.4 0 164L0 504c0 4.4 3.6 8 8 8s8-3.6 8-8l0-340zm304 12c87.2 0 159.7 63.5 173.6 146.8 1 5.9-3.9 13.2-13.6 13.2l-320 0c-9.7 0-14.6-7.4-13.6-13.2 13.9-83.3 86.4-146.8 173.6-146.8zm0 224c-29.8 0-54.9-20.4-62-48l124 0c-7.1 27.6-32.2 48-62 48z"]],
    "circle-b": [512, 512, [], "e0fd", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zm176-88c0-4.4 3.6-8 8-8l68 0c28.7 0 52 23.3 52 52 0 15.7-6.9 29.7-17.9 39.2 19.8 7.4 33.9 26.4 33.9 48.8 0 28.7-23.3 52-52 52l-84 0c-4.4 0-8-3.6-8-8l0-176zm16 8l0 72 60 0c19.9 0 36-16.1 36-36s-16.1-36-36-36l-60 0zm0 88l0 72 76 0c19.9 0 36-16.1 36-36s-16.1-36-36-36l-76 0z", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM192 168l0 176c0 4.4 3.6 8 8 8l84 0c28.7 0 52-23.3 52-52 0-22.3-14.1-41.4-33.9-48.8 11-9.5 17.9-23.6 17.9-39.2 0-28.7-23.3-52-52-52l-68 0c-4.4 0-8 3.6-8 8zm112 44c0 19.9-16.1 36-36 36l-60 0 0-72 60 0c19.9 0 36 16.1 36 36zM208 336l0-72 76 0c19.9 0 36 16.1 36 36s-16.1 36-36 36l-76 0z"]],
    "butterfly": [512, 512, [], "e811", ["M16 67.6l0 96.1c0 74.7 53.9 136.8 125 149.5 3 .5 5.4 2.7 6.3 5.7s-.1 6.1-2.3 8.1l-31.3 28.4c-11.3 10.2-17.7 24.8-17.7 40l.1 3.7c1.2 18.2 11.6 34.7 27.7 43.6l25.5 14.2 6.4 3.1c6.6 2.6 13.7 4 20.8 4l4.6-.2c22.7-1.9 42.3-17.4 49.1-39.4l6.3-20.5 2.7-9.3c5.8-21.7 8.8-44.1 8.8-66.7l0-70.9c0-.3-.1-.6-.1-.9-2.2-111.8-90.6-202.3-201.5-207.9L35.6 48C24.8 48 16 56.8 16 67.6zM264 260.4l0 67.5c0 25.7 3.9 51.3 11.4 75.9l6.3 20.5 1.5 4.3c8.5 21.2 29 35.3 52.1 35.3 9.5 0 18.9-2.4 27.3-7.1l25.5-14.2 3.1-1.9c14.3-9.3 23.4-24.7 24.6-41.7l.1-3.7c0-13.3-4.9-26.1-13.7-36l-4-4.1-31.3-28.4c-2.3-2.1-3.2-5.2-2.3-8.1s3.3-5.1 6.3-5.7c71.1-12.7 125-74.8 125-149.5l0-96.1C496 56.8 487.2 48 476.4 48 359.1 48 264 143.1 264 260.4z", "M476.4 32C496.1 32 512 47.9 512 67.6l0 96.1c0 77.2-52.1 142.1-122.9 161.7l20 18.2 5.2 5.2c11.4 12.8 17.8 29.4 17.8 46.6l-.2 4.7c-1.5 22-13.3 42.1-31.8 54.1l-4.1 2.4-25.5 14.2c-10.7 6-22.8 9.1-35 9.1-29.7 0-56.1-18.2-67-45.4l-2-5.6-6.3-20.5c-1.5-5-2.9-10.1-4.2-15.2-.4 1.8-.8 3.6-1.3 5.3l-2.8 9.8-6.3 20.5c-8.7 28.4-33.9 48.3-63.1 50.7l-5.9 .2c-10.7 0-21.3-2.4-31-7l-4.1-2.1-25.5-14.2c-20.9-11.6-34.3-32.9-35.9-56.5l-.2-4.7c0-19.7 8.3-38.6 22.9-51.8l19.9-18.2C52 305.7 0 240.8 0 163.7L0 67.6C0 47.9 15.9 32 35.6 32l11.6 .3C147.5 37.3 230.6 107.1 255.9 200.6 282.2 103.5 371 32 476.4 32zM35.6 48C24.8 48 16 56.8 16 67.6l0 96.1c0 74.7 53.9 136.8 125 149.5 3 .5 5.4 2.7 6.3 5.7s-.1 6.1-2.3 8.1l-31.3 28.4c-11.3 10.2-17.7 24.8-17.7 40l.1 3.7c1.2 18.2 11.6 34.7 27.7 43.6l25.5 14.2 6.4 3.1c6.6 2.6 13.7 4 20.8 4l4.6-.2c22.7-1.9 42.3-17.4 49.1-39.4l6.3-20.5 2.7-9.3c5.8-21.7 8.8-44.1 8.8-66.7l0-70.9c0-.3-.1-.6-.1-.9-2.2-111.8-90.6-202.3-201.5-207.9L35.6 48zm440.9 0C359.1 48 264 143.1 264 260.4l0 67.5c0 25.7 3.9 51.3 11.4 75.9l6.3 20.5 1.5 4.3c8.5 21.2 29 35.3 52.1 35.3 9.5 0 18.9-2.4 27.3-7.1l25.5-14.2 3.1-1.9c14.3-9.3 23.4-24.7 24.6-41.7l.1-3.7c0-13.3-4.9-26.1-13.7-36l-4-4.1-31.3-28.4c-2.3-2.1-3.2-5.2-2.3-8.1s3.3-5.1 6.3-5.7c71.1-12.7 125-74.8 125-149.5l0-96.1c0-10.8-8.8-19.6-19.6-19.6z"]],
    "bacterium": [512, 512, [], "e05a", ["M76.1 300.1c-37.5 37.5-37.5 98.3 0 135.8s98.3 37.5 135.8 0c74.7-74.7 149.3-149.3 224-224 37.5-37.5 37.5-98.3 0-135.8s-98.3-37.5-135.8 0c-74.7 74.7-149.3 149.3-224 224zM192 352a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm80-80a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M360 16c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 18.6c-20.2 4.4-39.5 14.5-55.2 30.2l-10.3 10.3-16.8-16.8c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l16.8 16.8-52.7 52.7-16.8-16.8c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l16.8 16.8c-17.6 17.6-35.1 35.1-52.7 52.7l-16.8-16.8c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l16.8 16.8-52.7 52.7-16.8-16.8c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l16.8 16.8-10.3 10.3C49.1 304.5 39 323.8 34.6 344L16 344c-4.4 0-8 3.6-8 8s3.6 8 8 8l16.3 0c-2 28.8 7 58.2 27.1 81.3l-9 9c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l9-9c22.8 19.8 51.6 28.8 80 27.1l0 13.4c0 4.4 3.6 8 8 8s8-3.6 8-8l0-15.6c20.7-4.3 40.5-14.4 56.6-30.5l10.3-10.3 16.8 16.8c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-16.8-16.8 52.7-52.7 16.8 16.8c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-16.8-16.8 52.7-52.7 16.8 16.8c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-16.8-16.8 52.7-52.7 16.8 16.8c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-16.8-16.8 10.3-10.3c15.7-15.7 25.8-35 30.2-55.2l18.6 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-16.3 0c2-28.8-7-58.2-27.1-81.3l9-9c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0l-9 9C418.2 39.3 388.8 30.2 360 32.3L360 16zm75.9 195.9c-74.7 74.7-149.3 149.3-224 224-37.5 37.5-98.3 37.5-135.8 0s-37.5-98.3 0-135.8c74.7-74.7 149.3-149.3 224-224 37.5-37.5 98.3-37.5 135.8 0s37.5 98.3 0 135.8zM160 368a16 16 0 1 1 0-32 16 16 0 1 1 0 32zm-32-16a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm128-80a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm-16-32a32 32 0 1 0 0 64 32 32 0 1 0 0-64z"]],
    "square-7": [448, 512, [], "e25c", ["M16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96zm144 72c0-4.4 3.6-8 8-8l128 0c3 0 5.7 1.6 7.1 4.3s1.2 5.8-.5 8.2l-120 176c-2.5 3.7-7.5 4.6-11.1 2.1s-4.6-7.5-2.1-11.1L280.9 176 168 176c-4.4 0-8-3.6-8-8z", "M64 48C37.5 48 16 69.5 16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm168 64l128 0c3 0 5.7 1.6 7.1 4.3s1.2 5.8-.5 8.2l-120 176c-2.5 3.7-7.5 4.6-11.1 2.1s-4.6-7.5-2.1-11.1L280.9 176 168 176c-4.4 0-8-3.6-8-8s3.6-8 8-8z"]],
    "magnifying-glass-arrows-rotate": [512, 512, [], "e65e", ["M7.9 208c4.4 .1 8-3.3 8.2-7.7 4-102.5 88.4-184.3 191.8-184.3 44.4 0 85.2 15 117.7 40.3L279 103c-6.9 6.9-8.9 17.2-5.2 26.2S286.3 144 296 144l96 0c1.8 0 3.6-.2 5.3-.6 6.9 20.3 10.7 42 10.8 64.7-4.5-.1-8.1 3.3-8.3 7.7-4.1 102.4-88.4 184.2-191.8 184.2-44.4 0-85.2-15-117.7-40.3-13.5 13.5 2.1-2.1 46.7-46.7 6.9-6.9 8.9-17.2 5.2-26.2S129.7 272 120 272l-96 0c-1.8 0-3.6 .2-5.3 .6-6.9-20.3-10.7-42-10.7-64.6z", "M392 128l-96 0c-3.2 0-6.2-1.9-7.4-4.9s-.6-6.4 1.7-8.7l96-96c2.3-2.3 5.7-3 8.7-1.7S400 20.8 400 24l0 96c0 4.4-3.6 8-8 8zm0 16c13.3 0 24-10.7 24-24l0-96c0-9.7-5.8-18.5-14.8-22.2S381.9 .2 375 7L337.1 44.9C301.7 16.8 256.8 0 208 0 95.9 0 4.5 88.7 .2 199.7 0 204.1 3.4 207.8 7.8 208s8.1-3.3 8.3-7.7C20.2 97.8 104.5 16 208 16 252.4 16 293.2 31 325.7 56.3L279 103c-6.9 6.9-8.9 17.2-5.2 26.2S286.3 144 296 144l96 0zM24 288l96 0c3.2 0 6.2 1.9 7.4 4.9s.6 6.4-1.7 8.7l-96 96c-2.3 2.3-5.7 3-8.7 1.7S16 395.2 16 392l0-96c0-4.4 3.6-8 8-8zm0-16c-13.3 0-24 10.7-24 24l0 96c0 9.7 5.8 18.5 14.8 22.2S34.1 415.8 41 409l96-96c6.9-6.9 8.9-17.2 5.2-26.2S129.7 272 120 272l-96 0zm336.6 77.3c32.6-35.2 53.2-81.6 55.2-132.9 .2-4.4-3.3-8.1-7.7-8.3s-8.1 3.3-8.3 7.7c-4.1 102.4-88.4 184.2-191.8 184.2-44.4 0-85.2-15-117.7-40.3L78.9 371.1c35.5 28.1 80.3 44.9 129.1 44.9 54.6 0 104.2-21 141.3-55.4l149 149c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-149-149z"]],
    "square-i": [448, 512, [], "e272", ["M16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96zm128 72c0-4.4 3.6-8 8-8l144 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-64 0 0 160 64 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-144 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l64 0 0-160-64 0c-4.4 0-8-3.6-8-8z", "M64 48C37.5 48 16 69.5 16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm152 64l144 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-64 0 0 160 64 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-144 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l64 0 0-160-64 0c-4.4 0-8-3.6-8-8s3.6-8 8-8z"]],
    "standard-definition": [512, 512, ["rectangle-sd"], "e28a", ["M16 128l0 256c0 26.5 21.5 48 48 48l384 0c26.5 0 48-21.5 48-48l0-256c0-26.5-21.5-48-48-48L64 80c-26.5 0-48 21.5-48 48zm80 80c0-26.5 21.5-48 48-48l72 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-72 0c-17.7 0-32 14.3-32 32l0 8c0 17.7 14.3 32 32 32l40 0c26.5 0 48 21.5 48 48l0 8c0 26.5-21.5 48-48 48l-72 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l72 0c17.7 0 32-14.3 32-32l0-8c0-17.7-14.3-32-32-32l-40 0c-26.5 0-48-21.5-48-48l0-8zm184-40c0-4.4 3.6-8 8-8l56 0c39.8 0 72 32.2 72 72l0 48c0 39.8-32.2 72-72 72l-56 0c-4.4 0-8-3.6-8-8l0-176zm16 8l0 160 48 0c30.9 0 56-25.1 56-56l0-48c0-30.9-25.1-56-56-56l-48 0z", "M448 80c26.5 0 48 21.5 48 48l0 256c0 26.5-21.5 48-48 48L64 432c-26.5 0-48-21.5-48-48l0-256c0-26.5 21.5-48 48-48l384 0zM64 64C28.7 64 0 92.7 0 128L0 384c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L64 64zM96 208l0 8c0 26.5 21.5 48 48 48l40 0c17.7 0 32 14.3 32 32l0 8c0 17.7-14.3 32-32 32l-72 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l72 0c26.5 0 48-21.5 48-48l0-8c0-26.5-21.5-48-48-48l-40 0c-17.7 0-32-14.3-32-32l0-8c0-17.7 14.3-32 32-32l72 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-72 0c-26.5 0-48 21.5-48 48zm192-48c-4.4 0-8 3.6-8 8l0 176c0 4.4 3.6 8 8 8l56 0c39.8 0 72-32.2 72-72l0-48c0-39.8-32.2-72-72-72l-56 0zm8 176l0-160 48 0c30.9 0 56 25.1 56 56l0 48c0 30.9-25.1 56-56 56l-48 0z"]],
    "alien-8bit": [576, 512, [128126, "alien-monster"], "f8f6", ["M16 144l0 152c0 4.4 3.6 8 8 8l48 0c4.4 0 8 3.6 8 8l0 48c0 4.4 3.6 8 8 8l400 0c4.4 0 8-3.6 8-8l0-48c0-4.4 3.6-8 8-8l48 0c4.4 0 8-3.6 8-8l0-152c0-4.4-3.6-8-8-8l-32 0c-4.4 0-8 3.6-8 8l0 96c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-64-96 0c-4.4 0-8-3.6-8-8l0-56-32 0c-4.4 0-8 3.6-8 8l0 48c0 4.4-3.6 8-8 8l-112 0c-4.4 0-8-3.6-8-8l0-48c0-4.4-3.6-8-8-8l-32 0 0 56c0 4.4-3.6 8-8 8l-96 0 0 64c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-96c0-4.4-3.6-8-8-8l-32 0c-4.4 0-8 3.6-8 8zM120 56l0 32c0 4.4 3.6 8 8 8l40 0 0-40c0-4.4-3.6-8-8-8l-32 0c-4.4 0-8 3.6-8 8zm24 328l0 72c0 4.4 3.6 8 8 8l80 0c4.4 0 8-3.6 8-8l0-16c0-4.4-3.6-8-8-8l-40 0c-4.4 0-8-3.6-8-8l0-40-40 0zm48-152c0-4.4 3.6-8 8-8s8 3.6 8 8l0 80c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-80zM336 440l0 16c0 4.4 3.6 8 8 8l80 0c4.4 0 8-3.6 8-8l0-72-40 0 0 40c0 4.4-3.6 8-8 8l-40 0c-4.4 0-8 3.6-8 8zm32-208c0-4.4 3.6-8 8-8s8 3.6 8 8l0 80c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-80zM408 56l0 40 40 0c4.4 0 8-3.6 8-8l0-32c0-4.4-3.6-8-8-8l-32 0c-4.4 0-8 3.6-8 8z", "M120 56l0 32c0 4.4 3.6 8 8 8l40 0 0-40c0-4.4-3.6-8-8-8l-32 0c-4.4 0-8 3.6-8 8zm64 0l0 40 32 0c13.3 0 24 10.7 24 24l0 40 96 0 0-40c0-13.3 10.7-24 24-24l32 0 0-40c0-13.3 10.7-24 24-24l32 0c13.3 0 24 10.7 24 24l0 32c0 13.3-10.7 24-24 24l-40 0 0 48 88 0 0-16c0-13.3 10.7-24 24-24l32 0c13.3 0 24 10.7 24 24l0 152c0 13.3-10.7 24-24 24l-40 0 0 40c0 13.3-10.7 24-24 24l-40 0 0 72c0 13.3-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24l0-16c0-13.3 10.7-24 24-24l32 0 0-32-176 0 0 32 32 0c13.3 0 24 10.7 24 24l0 16c0 13.3-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24l0-72-40 0c-13.3 0-24-10.7-24-24l0-40-40 0c-13.3 0-24-10.7-24-24L0 144c0-13.3 10.7-24 24-24l32 0c13.3 0 24 10.7 24 24l0 16 88 0 0-48-40 0c-13.3 0-24-10.7-24-24l0-32c0-13.3 10.7-24 24-24l32 0c13.3 0 24 10.7 24 24zM80 176l0 64c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-96c0-4.4-3.6-8-8-8l-32 0c-4.4 0-8 3.6-8 8l0 152c0 4.4 3.6 8 8 8l48 0c4.4 0 8 3.6 8 8l0 48c0 4.4 3.6 8 8 8l400 0c4.4 0 8-3.6 8-8l0-48c0-4.4 3.6-8 8-8l48 0c4.4 0 8-3.6 8-8l0-152c0-4.4-3.6-8-8-8l-32 0c-4.4 0-8 3.6-8 8l0 96c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-64-96 0c-4.4 0-8-3.6-8-8l0-56-32 0c-4.4 0-8 3.6-8 8l0 48c0 4.4-3.6 8-8 8l-112 0c-4.4 0-8-3.6-8-8l0-48c0-4.4-3.6-8-8-8l-32 0 0 56c0 4.4-3.6 8-8 8l-96 0zM448 96c4.4 0 8-3.6 8-8l0-32c0-4.4-3.6-8-8-8l-32 0c-4.4 0-8 3.6-8 8l0 40 40 0zM144 456c0 4.4 3.6 8 8 8l80 0c4.4 0 8-3.6 8-8l0-16c0-4.4-3.6-8-8-8l-40 0c-4.4 0-8-3.6-8-8l0-40-40 0 0 72zm248-32c0 4.4-3.6 8-8 8l-40 0c-4.4 0-8 3.6-8 8l0 16c0 4.4 3.6 8 8 8l80 0c4.4 0 8-3.6 8-8l0-72-40 0 0 40zM208 232l0 80c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-80c0-4.4 3.6-8 8-8s8 3.6 8 8zm176 0l0 80c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-80c0-4.4 3.6-8 8-8s8 3.6 8 8z"]],
    "vacuum": [640, 512, [], "e04d", ["M16 490.3c0-4.3 1-8.5 2.9-12.3l1.9-3.8C33.7 448.3 60.1 432 89 432l46.8 0c.1 0 .2 0 .3 0l39.8 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L21.7 496c-3.2 0-5.7-2.6-5.7-5.7zM464 416a80 80 0 1 1 -160 0 80 80 0 1 1 160 0zm-112 0a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm16-224c0-26.5 21.5-48 48-48 97.2 0 176 78.8 176 176l0 128c0 26.5-21.5 48-48 48l-60.1 0c17.6-21.9 28.1-49.7 28.1-80 0-70.7-57.3-128-128-128-5.4 0-10.8 .3-16 1l0-97z", "M308.4 0C259.9 0 217.9 33.4 207 80.6L129.6 416 89 416c-35 0-66.9 19.7-82.5 51l-1.9 3.8c-3 6-4.6 12.7-4.6 19.4 0 12 9.7 21.7 21.7 21.7L176 512c26.5 0 48-21.5 48-48s-21.5-48-48-48l-29.9 0 76.6-331.8C231.8 44.3 267.4 16 308.4 16L528 16c53 0 96 43 96 96 0 39.5-23.9 73.4-58 88.2-35.2-44-89.3-72.2-150-72.2-35.3 0-64 28.7-64 64l0 100c5.2-1.3 10.6-2.4 16-3l0-97c0-26.5 21.5-48 48-48 97.2 0 176 78.8 176 176l0 128c0 26.5-21.5 48-48 48l-60.1 0c-4.6 5.8-9.7 11.1-15.3 16l75.3 0c35.3 0 64-28.7 64-64l0-128c0-39.5-11.9-76.1-32.3-106.6 38-17.9 64.3-56.6 64.3-101.4 0-61.9-50.1-112-112-112L308.4 0zM135.8 432c.1 0 .2 0 .3 0l39.8 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L21.7 496c-3.2 0-5.7-2.6-5.7-5.7 0-4.3 1-8.5 2.9-12.3l1.9-3.8C33.7 448.3 60.1 432 89 432l46.8 0zM384 336a80 80 0 1 1 0 160 80 80 0 1 1 0-160zm0 176a96 96 0 1 0 0-192 96 96 0 1 0 0 192zm-16-96a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm48 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"]],
    "bowl-chopsticks-noodles": [512, 512, [], "e2ea", ["M18 256.9l1.6 27.3c4.5 77.3 50.9 142.7 116.4 174.7 2 1 3.8 2.4 5.2 4.1L252 240 33.9 240c-9.2 0-16.5 7.7-16 16.9z", "M505.6 15.8c4.3-.9 7.1-5.1 6.2-9.5s-5.1-7.1-9.5-6.2L224 58.5 224 74.9 505.6 15.8zM96 85.4L6.4 104.2c-4.3 .9-7.1 5.1-6.2 9.5s5.1 7.1 9.5 6.2L96 101.7 96 146.3 7.5 152c-4.4 .3-7.8 4.1-7.5 8.5s4.1 7.8 8.5 7.5l87.5-5.6 0 61.7-62.1 0C15.5 224 .9 239.5 2 257.9l1.6 27.3c4.9 83.3 54.8 153.7 125.3 188.2 4.3 22 23.8 38.7 47.1 38.7l160 0c23.3 0 42.8-16.6 47.1-38.7 70.5-34.5 120.4-104.9 125.3-188.2l1.6-27.3c1.1-18.4-13.5-33.9-31.9-33.9L176 224 176 32c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 192-48 0 0-176c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 37.4zM504.5 136c4.4-.3 7.8-4.1 7.5-8.5s-4.1-7.8-8.5-7.5l-279.5 18 0 16 280.5-18.1zm-368.6 323c-65.5-32-111.8-97.4-116.4-174.7L18 256.9c-.5-9.2 6.8-16.9 16-16.9l444.1 0c9.2 0 16.5 7.7 16 16.9l-1.6 27.3c-4.5 77.3-50.9 142.7-116.4 174.7-4.5 2.2-7.7 6.4-8.7 11.3-2.9 14.7-15.9 25.8-31.4 25.8l-160 0c-15.5 0-28.5-11.1-31.4-25.8-1-4.9-4.2-9.1-8.7-11.3z"]],
    "record-vinyl": [512, 512, [], "f8d9", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zm368 0a128 128 0 1 1 -256 0 128 128 0 1 1 256 0z", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM384 256a128 128 0 1 0 -256 0 128 128 0 1 0 256 0zM256 144a112 112 0 1 1 0 224 112 112 0 1 1 0-224zm0 128a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"]],
    "floppy-disk": [448, 512, [128190, 128426, "save"], "f0c7", ["M16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-242.7c0-12.7-5.1-24.9-14.1-33.9L340.7 62.1c-5.8-5.8-12.9-10-20.7-12.2L320 176c0 17.7-14.3 32-32 32l-160 0c-17.7 0-32-14.3-32-32l0-128-32 0C37.5 48 16 69.5 16 96zM288 320a64 64 0 1 1 -128 0 64 64 0 1 1 128 0z", "M64 48C37.5 48 16 69.5 16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-242.7c0-12.7-5.1-24.9-14.1-33.9L340.7 62.1c-5.8-5.8-12.9-10-20.7-12.2L320 176c0 17.7-14.3 32-32 32l-160 0c-17.7 0-32-14.3-32-32l0-128-32 0zm48 0l0 128c0 8.8 7.2 16 16 16l160 0c8.8 0 16-7.2 16-16l0-128-192 0zM0 96C0 60.7 28.7 32 64 32l242.7 0c17 0 33.3 6.7 45.3 18.7L429.3 128c12 12 18.7 28.3 18.7 45.3L448 416c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM224 368a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm0-112a64 64 0 1 1 0 128 64 64 0 1 1 0-128z"]],
    "down-left": [448, 512, [], "e16a", ["M48.2 134.6l0 289.4c0 4.4 3.6 8 8 8l281.4 0c7.1 0 10.7-8.6 5.7-13.7l-92.7-92.7c-3.1-3.1-3.1-8.2 0-11.3L412 153c9.4-9.4 9.4-24.6 0-33.9L361.7 68.8c-9.5-9.5-25-9.3-34.3 .4L174 229.5c-1.5 1.6-3.5 2.4-5.7 2.5s-4.2-.8-5.7-2.3L61.9 129c-5-5-13.7-1.5-13.7 5.7zm117.4 75.4l2.5 2.5 110-115-112.5 112.5zM267.6 320l87 87c2.7 2.7 4.5 5.6 5.7 8.8 0-6.2-2.5-12.3-7-16.8l-82.3-82.3-3.3 3.3z", "M56.2 432c-4.4 0-8-3.6-8-8l0-289.4c0-7.1 8.6-10.7 13.7-5.7L162.6 229.7c1.5 1.5 3.6 2.4 5.7 2.3s4.2-.9 5.7-2.5L327.4 69.2c9.3-9.7 24.8-9.9 34.3-.4L412 119c9.4 9.4 9.4 24.6 0 33.9L250.6 314.3c-3.1 3.1-3.1 8.2 0 11.3l92.7 92.7c5 5 1.5 13.7-5.7 13.7L56.2 432zm-24-8c0 13.3 10.7 24 24 24l281.4 0c21.4 0 32.1-25.9 17-41l-87-87 155.7-155.7c15.6-15.6 15.6-40.9 0-56.6L373 57.5c-15.9-15.9-41.7-15.6-57.2 .6L168.1 212.6 73.2 117.7c-15.1-15.1-41-4.4-41 17l0 289.4z"]],
    "toilets-portable": [512, 512, [], "e584", ["M16 56l0 40 192 0 0-40c0-22.1-17.9-40-40-40L56 16C33.9 16 16 33.9 16 56zm0 56l0 336 192 0 0-120-24 0c-13.3 0-24-10.7-24-24l0-64c0-13.3 10.7-24 24-24l24 0 0-104-192 0zM304 56l0 40 192 0 0-40c0-22.1-17.9-40-40-40L344 16c-22.1 0-40 17.9-40 40zm0 56l0 336 192 0 0-120-24 0c-13.3 0-24-10.7-24-24l0-64c0-13.3 10.7-24 24-24l24 0 0-104-192 0z", "M56 16C33.9 16 16 33.9 16 56l0 40 192 0 0-40c0-22.1-17.9-40-40-40L56 16zm152 96l-192 0 0 336 192 0 0-120-24 0c-13.3 0-24-10.7-24-24l0-64c0-13.3 10.7-24 24-24l24 0 0-104zM184 312l24 0 0-80-24 0c-4.4 0-8 3.6-8 8l0 64c0 4.4 3.6 8 8 8zM224 56l0 448c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-40-192 0 0 40c0 4.4-3.6 8-8 8s-8-3.6-8-8L0 56C0 25.1 25.1 0 56 0L168 0c30.9 0 56 25.1 56 56zM344 16c-22.1 0-40 17.9-40 40l0 40 192 0 0-40c0-22.1-17.9-40-40-40L344 16zm152 96l-192 0 0 336 192 0 0-120-24 0c-13.3 0-24-10.7-24-24l0-64c0-13.3 10.7-24 24-24l24 0 0-104zM472 312l24 0 0-80-24 0c-4.4 0-8 3.6-8 8l0 64c0 4.4 3.6 8 8 8zM512 56l0 448c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-40-192 0 0 40c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-448c0-30.9 25.1-56 56-56L456 0c30.9 0 56 25.1 56 56z"]],
    "o": [448, 512, [111], "4f", ["", "M224 48a208 208 0 1 0 0 416 208 208 0 1 0 0-416zM448 256a224 224 0 1 1 -448 0 224 224 0 1 1 448 0z"]],
    "palette": [512, 512, [127912], "f53f", ["M16 256c0 132.5 107.5 240 240 240 3.3 0 6.6-.1 9.9-.2 21.1-.9 38.1-20.4 38.1-46 0-8.9-3.2-18.1-8.2-29.8-.7-1.7-1.5-3.5-2.3-5.3-4.3-9.8-9.5-21.5-12-33.5-.9-4.3-1.4-8.7-1.4-13.2 0-35.3 28.7-64 64-64l97.9 0c30.4 0 53.8-20.2 54.1-45.5 0-.8 0-1.7 0-2.5 0-132.5-107.5-240-240-240S16 123.5 16 256zm128 40a40 40 0 1 1 -80 0 40 40 0 1 1 80 0zm32-128a40 40 0 1 1 -80 0 40 40 0 1 1 80 0zm128-64a40 40 0 1 1 -80 0 40 40 0 1 1 80 0zm128 64a40 40 0 1 1 -80 0 40 40 0 1 1 80 0z", "M496 258.5c-.3 25.3-23.7 45.5-54.1 45.5L344 304c-35.3 0-64 28.7-64 64 0 4.5 .5 9 1.4 13.2 2.5 12 7.7 23.6 12 33.4l0 0c.8 1.8 1.6 3.6 2.3 5.3 5.1 11.7 8.2 20.9 8.2 29.8 0 25.5-16.9 45.1-38.1 46-3.3 .1-6.6 .2-9.9 .2-132.5 0-240-107.5-240-240S123.5 16 256 16 496 123.5 496 256c0 .8 0 1.7 0 2.5zm16 .2c0-.9 0-1.8 0-2.7 0-141.4-114.6-256-256-256S0 114.6 0 256 114.6 512 256 512c3.5 0 7.1-.1 10.6-.2 31.8-1.3 53.4-30.1 53.4-62 0-14.5-6.1-28.3-12.1-42-4.3-9.8-8.7-19.7-10.8-29.9-.7-3.2-1-6.5-1-9.9 0-26.5 21.5-48 48-48l97.9 0c36.5 0 69.7-24.8 70.1-61.3zM104 272a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm0 64a40 40 0 1 0 0-80 40 40 0 1 0 0 80zm8-168a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm64 0a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zm88-88a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm0 64a40 40 0 1 0 0-80 40 40 0 1 0 0 80zm104 24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm64 0a40 40 0 1 0 -80 0 40 40 0 1 0 80 0z"]],
    "paintbrush-fine-slash": [576, 512, [], "e74d", ["M279.4 236L486.7 28.6c8-8 19-12.6 30.3-12.6 23.7 0 42.9 19.2 42.9 42.9 0 11.4-4.5 22.3-12.6 30.3L340 296.6 279.4 236z", "M13.7-29.8c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l560 560c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3L351.4 308 558.7 100.6c11-11 17.3-26 17.3-41.7 0-32.5-26.4-58.9-58.9-58.9-15.6 0-30.6 6.2-41.7 17.3L268 224.6 13.7-29.8zM279.4 236L486.7 28.6c8-8 19-12.6 30.3-12.6 23.7 0 42.9 19.2 42.9 42.9 0 11.4-4.5 22.3-12.6 30.3L340 296.6 279.4 236zm15.4 106l-15.2 15.2c-11.4-27.4-33.3-49.3-60.7-60.7l15.2-15.2-11.3-11.3-21 21c-8.3-1.9-16.9-3-25.7-3-61.9 0-112 50.1-112 112 0 3.9 .2 7.8 .6 11.6 1.8 17.5-10.2 36.4-27.8 36.4L32 448c-17.7 0-32 14.3-32 32s14.3 32 32 32l144 0c61.9 0 112-50.1 112-112 0-8.9-1-17.5-3-25.7l21-21-11.3-11.3zM272 400c0 53-43 96-96 96L32 496c-8.8 0-16-7.2-16-16s7.2-16 16-16l4.8 0c15 0 26.9-8.1 34.2-18.3 7.2-10 10.8-23 9.5-35.8-.3-3.3-.5-6.6-.5-10 0-53 43-96 96-96s96 43 96 96z"]],
    "blueberries": [512, 512, [], "e2e8", ["M16 336a160 160 0 1 0 320 0 160 160 0 1 0 -320 0zm88-48c0-4.4 3.6-8 8-8l40 0 0-40c0-4.4 3.6-8 8-8s8 3.6 8 8l0 40 40 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-40 0 0 40c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-40-40 0c-4.4 0-8-3.6-8-8zm79.3-159.9c109.1 3.8 196.8 91.5 200.6 200.6 65-20.3 112.1-81 112.1-152.7 0-88.4-71.6-160-160-160-71.7 0-132.4 47.1-152.7 112.1zM296 128c0-4.4 3.6-8 8-8l40 0 0-40c0-4.4 3.6-8 8-8s8 3.6 8 8l0 40 40 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-40 0 0 40c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-40-40 0c-4.4 0-8-3.6-8-8z", "M383.9 328.7c65-20.3 112.1-81 112.1-152.7 0-88.4-71.6-160-160-160-71.7 0-132.4 47.1-152.7 112.1-4.5-.2-10.1-.2-16.7 .1 20.8-74 88.8-128.2 169.4-128.2 97.2 0 176 78.8 176 176 0 80.6-54.2 148.6-128.2 169.4 .3-6.6 .2-12.3 .1-16.7zM336 336a160 160 0 1 0 -320 0 160 160 0 1 0 320 0zM0 336a176 176 0 1 1 352 0 176 176 0 1 1 -352 0zm168-96l0 40 40 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-40 0 0 40c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-40-40 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l40 0 0-40c0-4.4 3.6-8 8-8s8 3.6 8 8zM360 80l0 40 40 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-40 0 0 40c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-40-40 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l40 0 0-40c0-4.4 3.6-8 8-8s8 3.6 8 8z"]],
    "fish-bones": [576, 512, [], "e304", ["M21.6 128l39 120 35.3 0 0-95.9c0 1.6-.5 3.2-1.5 4.5-2.6 3.6-7.6 4.4-11.2 1.9L31 121.1c-1-.7-2.3-1.1-3.6-1.1-4.2 0-7.1 4.1-5.8 8zm0 255.9c-1.3 4 1.7 8 5.8 8 1.3 0 2.5-.4 3.6-1.1l52.3-37.4c3.6-2.6 8.6-1.7 11.2 1.9 .9 1.3 1.4 2.8 1.5 4.3l0-95.6-35.3 0-39 120zM432 130.9l0 250.3c0 2.9 1.4 5 3 6 1.4 .9 3 1.1 4.8 .1 15.1-8.6 28.9-18.5 41.3-29 37.3-31.5 63.8-69.2 77.1-94.9 2.4-4.6 2.4-10.1 0-14.7-13.2-25.7-39.8-63.4-77.1-94.9-12.4-10.5-26.2-20.4-41.3-29-1.8-1-3.4-.9-4.8 .1-1.6 1-3 3.1-3 6z", "M27.5 120c-4.2 0-7.1 4.1-5.8 8l39 120 83.3 0 0-88c0-4.4 3.6-8 8-8s8 3.6 8 8l0 88 80 0 0-88c0-4.4 3.6-8 8-8s8 3.6 8 8l0 88 80 0 0-88c0-4.4 3.6-8 8-8s8 3.6 8 8l0 88 64 0 0-117.1c0-16.9 17.1-28.4 31.8-20 16 9.1 30.6 19.7 43.7 30.7 39.1 33 66.9 72.4 81 99.8 4.7 9.2 4.7 20.1 0 29.3-14.1 27.4-41.9 66.8-81 99.8-13.1 11-27.7 21.6-43.7 30.7-14.7 8.4-31.8-3.1-31.8-20l0-117.1-64 0 0 88c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-88-80 0 0 88c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-88-80 0 0 88c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-88-83.3 0-39 120c-1.3 4 1.7 8 5.8 8 1.3 0 2.5-.4 3.6-1.1l0 0 52.3-37.4c3.6-2.6 8.6-1.7 11.2 1.9s1.7 8.6-1.9 11.2L40.3 403.9c-3.8 2.7-8.3 4.1-12.9 4.1-15 0-25.7-14.7-21.1-29l0 0 40-123-40-123c-4.7-14.3 6-29 21.1-29 4.6 0 9.1 1.4 12.9 4.1l52.3 37.4c3.6 2.6 4.4 7.6 1.9 11.2s-7.6 4.4-11.2 1.9L31 121.1c-1-.7-2.3-1.1-3.6-1.1zM432 256l0 125.1c0 2.9 1.4 5 3 6 1.4 .9 3 1.1 4.8 .1 15.1-8.6 28.9-18.5 41.3-29 37.3-31.5 63.8-69.2 77.1-94.9 2.4-4.6 2.4-10.1 0-14.7-13.2-25.7-39.8-63.4-77.1-94.9-12.4-10.5-26.2-20.4-41.3-29-1.8-1-3.4-.9-4.8 .1-1.6 1-3 3.1-3 6L432 256z"]],
    "unlock": [384, 512, [128275], "f09c", ["M16 224l0 224c0 26.5 21.5 48 48 48l256 0c26.5 0 48-21.5 48-48l0-224c0-26.5-21.5-48-48-48L64 176c-26.5 0-48 21.5-48 48z", "M80 96C80 34.2 130.1-16 192-16S304 34.2 304 96l0 8c0 4.4 3.6 8 8 8s8-3.6 8-8l0-8c0-70.7-57.3-128-128-128S64 25.3 64 96l0 64c-35.3 0-64 28.7-64 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-224c0-35.3-28.7-64-64-64l-240 0 0-64zM64 176l256 0c26.5 0 48 21.5 48 48l0 224c0 26.5-21.5 48-48 48L64 496c-26.5 0-48-21.5-48-48l0-224c0-26.5 21.5-48 48-48z"]],
    "fan-table": [448, 512, [], "e004", ["M16 224a208 208 0 1 0 416 0 208 208 0 1 0 -416 0zm92-30.8c-19.9-49.2 3.9-105.1 53-125 12.3-5 26.3 1 31.2 13.3l34.5 85.3c20.6-21 50.5-32.2 81.9-27.8 52.5 7.4 89.1 55.9 81.7 108.4-1.8 13.1-14 22.3-27.1 20.4L272.2 255c7.9 28.3 2.6 59.9-16.8 84.8-32.6 41.8-93 49.2-134.8 16.5-10.4-8.2-12.3-23.2-4.1-33.7l56.6-72.5c-28.5-7.4-53.2-27.6-65-57z", "M432 224a208 208 0 1 0 -416 0 208 208 0 1 0 416 0zm16 0c0 121-96 219.6-216 223.9l0 48.1 144 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L72 512c-4.4 0-8-3.6-8-8s3.6-8 8-8l144 0 0-48.1C96 443.6 0 345 0 224 0 100.3 100.3 0 224 0S448 100.3 448 224zM192.3 81.5l34.5 85.3c20.6-21 50.5-32.2 81.9-27.8 52.5 7.4 89.1 55.9 81.7 108.4-1.8 13.1-14 22.3-27.1 20.4L272.2 255c7.9 28.3 2.6 59.9-16.8 84.8-32.6 41.8-93 49.2-134.8 16.5l0 0c-10.4-8.2-12.3-23.2-4.1-33.7l56.6-72.5c-28.5-7.4-53.2-27.6-65-57-19.9-49.2 3.9-105.1 53-125 12.3-5 26.3 1 31.2 13.3zm-25.2 1.6c-41 16.6-60.8 63.2-44.2 104.1 11.4 28.3 37.2 46.5 65.5 49.6 2.9 .3 5.4 2.2 6.5 4.8s.7 5.7-1.1 8L129 332.5c-2.7 3.5-2.1 8.5 1.4 11.2 34.8 27.2 85.1 21 112.3-13.8 18.8-24 21.7-55.4 10.2-81.5-1.2-2.7-.8-5.7 .9-8s4.6-3.5 7.5-3.1L365.5 252c4.4 .6 8.4-2.4 9-6.8 6.1-43.8-24.3-84.2-68.1-90.4-30.2-4.2-58.8 8.9-75.7 31.9-1.7 2.3-4.6 3.6-7.4 3.2s-5.3-2.3-6.4-4.9L177.5 87.5c-1.7-4.1-6.3-6.1-10.4-4.4zM224 208a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"]],
    "ear-listen": [512, 512, ["assistive-listening-systems"], "f2a2", ["M48 480a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zM75.6 245.3c2.6-1.3 4.4-4 4.4-7.1 0-87.3 71.6-158.2 160-158.2s160 70.9 160 158.2c0 46.2-20.1 87.9-52.1 116.8-8.9 8-15.1 19.4-15.1 32.2l0 4.8c0 57.4-46.6 104-104 104l-22.4 0c-1.3 0-2.5 .3-3.6 .9L157.8 408c.7 0 1.4 0 2.2 0 30.9 0 56-25.1 56-56s-25.1-56-56-56c-19.3 0-36.3 9.7-46.3 24.6l-38-75.3zM128 240c0 4.4 3.6 8 8 8s8-3.6 8-8c0-53 43-96 96-96s96 43 96 96c0 4.4 3.6 8 8 8s8-3.6 8-8c0-61.9-50.1-112-112-112S128 178.1 128 240zm48 112a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M365 4.1c2.1-3.9 7-5.3 10.9-3.1 81.1 45 136.1 131.6 136.1 231 0 4.4-3.6 8-8 8s-8-3.6-8-8c0-93.4-51.6-174.7-127.8-217-3.9-2.1-5.3-7-3.1-10.9zM160 336a16 16 0 1 0 0 32 16 16 0 1 0 0-32zm32 16a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM32 464a16 16 0 1 0 0 32 16 16 0 1 0 0-32zm32 16a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm69.7-37.7c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-64-64c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0l64 64zM240 80c-88.4 0-160 70.9-160 158.2 0 4.4-3.6 8-8 8s-8-3.6-8-8C64 141.9 142.9 64 240 64s176 77.9 176 174.2c0 51-22.2 96.8-57.4 128.7-6.1 5.6-9.8 12.9-9.8 20.4l0 4.8c0 66.3-53.7 120-120 120l-22.4 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l22.4 0c57.4 0 104-46.6 104-104l0-4.8c0-12.8 6.2-24.2 15.1-32.2 32.1-28.9 52.1-70.6 52.1-116.8 0-87.3-71.6-158.2-160-158.2zm0 64c-53 0-96 43-96 96 0 4.4-3.6 8-8 8s-8-3.6-8-8c0-61.9 50.1-112 112-112s112 50.1 112 112c0 4.4-3.6 8-8 8s-8-3.6-8-8c0-53-43-96-96-96z"]],
    "code-pull-request": [512, 512, [], "e13c", ["M32 72A56 56 0 1 0 144 72 56 56 0 1 0 32 72zm0 368a56 56 0 1 0 112 0 56 56 0 1 0 -112 0zm336 0a56 56 0 1 0 112 0 56 56 0 1 0 -112 0z", "M309.7 5.7c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0l-72 72c-3.1 3.1-3.1 8.2 0 11.3l72 72c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3L251.3 80 360 80c30.9 0 56 25.1 56 56l0 232.4c-36 4-64 34.5-64 71.6 0 39.8 32.2 72 72 72s72-32.2 72-72c0-37.1-28-67.6-64-71.6L432 136c0-39.8-32.2-72-72-72L251.3 64 309.7 5.7zM32 72A56 56 0 1 1 144 72 56 56 0 1 1 32 72zm64 71.6c36-4 64-34.5 64-71.6 0-39.8-32.2-72-72-72S16 32.2 16 72c0 37.1 28 67.6 64 71.6l0 224.9c-36 4-64 34.5-64 71.6 0 39.8 32.2 72 72 72s72-32.2 72-72c0-37.1-28-67.6-64-71.6l0-224.9zM32 440a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm392-56a56 56 0 1 1 0 112 56 56 0 1 1 0-112z"]],
    "thumbtack-angle": [512, 512, [], "e751", ["M55.6 232.7L279.3 456.4c7.2 7.2 19.2 5.9 24.7-2.6l8.6-13.1c23-35.3 31.2-76.5 25.5-115.9l-.5-3.6c-.3-2.3 .3-4.6 1.9-6.4L455.5 180.1 331.9 56.5 197.2 172.6c-1.8 1.5-4.1 2.2-6.4 1.9l-3.6-.5c-39.4-5.7-80.6 2.5-115.9 25.5L58.2 208c-8.5 5.6-9.8 17.5-2.6 24.7z", "M290.3 2.3c3.1-3.1 8.2-3.1 11.3 0l208 208c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-30.9-30.9-113.6 131.7c6.2 43.1-2.8 88.3-28 126.9l-8.6 13.1c-11.1 17-35.1 19.5-49.4 5.1L44.3 244.1c-14.4-14.4-11.9-38.3 5.1-49.4l13.1-8.5c38.6-25.2 83.8-34.2 126.9-28L321.2 44.5 290.3 13.7c-3.1-3.1-3.1-8.2 0-11.3zm41.5 54.1L197.2 172.6c-1.8 1.5-4.1 2.2-6.4 1.9l-3.6-.5c-39.4-5.7-80.6 2.5-115.9 25.5L58.2 208c-8.5 5.6-9.8 17.5-2.6 24.7L279.3 456.4c7.2 7.2 19.2 5.9 24.7-2.6l8.6-13.1c23-35.3 31.2-76.5 25.5-115.9l-.5-3.6c-.3-2.3 .3-4.6 1.9-6.4L455.5 180.1 331.9 56.5zM116.5 384.2l11.3 11.3-114.2 114.2c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3L116.5 384.2z"]],
    "key": [512, 512, [128273], "f084", ["M16 408l0 80c0 4.4 3.6 8 8 8l80 0c4.4 0 8-3.6 8-8l0-40c0-8.8 7.2-16 16-16l40 0c4.4 0 8-3.6 8-8l0-40c0-8.8 7.2-16 16-16l40 0c2.1 0 4.2-.8 5.7-2.3L271 332.3c4.2-4.2 10.5-5.8 16.2-3.9 15.4 4.9 31.8 7.6 48.8 7.6 88.4 0 160-71.6 160-160S424.4 16 336 16 176 87.6 176 176c0 17.1 2.7 33.5 7.6 48.8 1.8 5.7 .3 12-3.9 16.2L18.3 402.3c-1.5 1.5-2.3 3.5-2.3 5.7zM408 144a40 40 0 1 1 -80 0 40 40 0 1 1 80 0z", "M287.2 328.4c15.4 4.9 31.8 7.6 48.8 7.6 88.4 0 160-71.6 160-160S424.4 16 336 16 176 87.6 176 176c0 17.1 2.7 33.5 7.6 48.8 1.8 5.7 .3 12-3.9 16.2L18.3 402.3c-1.5 1.5-2.3 3.5-2.3 5.7l0 80c0 4.4 3.6 8 8 8l80 0c4.4 0 8-3.6 8-8l0-40c0-8.8 7.2-16 16-16l40 0c4.4 0 8-3.6 8-8l0-40c0-8.8 7.2-16 16-16l40 0c2.1 0 4.2-.8 5.7-2.3L271 332.3c4.2-4.2 10.5-5.8 16.2-3.9zM336 352c-18.7 0-36.8-2.9-53.7-8.3L249 377c-4.5 4.5-10.6 7-17 7l-40 0 0 40c0 13.3-10.7 24-24 24l-40 0 0 40c0 13.3-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24l0-80c0-6.4 2.5-12.5 7-17L168.3 229.7c-5.4-16.9-8.3-35-8.3-53.7 0-97.2 78.8-176 176-176s176 78.8 176 176-78.8 176-176 176zm32-248a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm24 40a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"]],
    "snake": [512, 512, [128013], "f716", ["M96.4 424.1L16.7 456.5c-6.6 2.7-6.6 12.1 0 14.8l79.7 32.8 250.9 0c68.7 0 124.5-55.7 124.5-124.5S416 255.2 347.2 255.2l-178.6 0c-26.5 0-48-21.5-48-48l0-7.3c0-26.5 21.5-48 48-48l127.5 0c18.4 41.9 67.7 60.5 109.2 41.2l65.8-30.6c19.9-9.3 32.7-29.2 32.7-51.2 0-22.5-13.4-42.9-34-51.8L403.8 30.8c-41.1-17.8-88.9 .5-107.6 41.2L168.1 72c-70.7 0-128 57.3-128 128l0 7.5c0 70.7 57.3 128 128 128l179.1 0c24.5 0 44.3 19.8 44.3 44.3s-19.8 44.3-44.3 44.3l-250.8 0z", "M301.9 80L172 80C103.5 80 48 135.5 48 204s55.5 124 124 124l176 0c28.7 0 52 23.3 52 52s-23.3 52-52 52l-232.8 0c-10.6 0-21 2.1-30.8 6.2l-62 25.8 62 25.8c9.7 4.1 20.2 6.2 30.8 6.2L348 496c64.1 0 116-51.9 116-116S412.1 264 348 264l-176 0c-33.1 0-60-26.9-60-60s26.9-60 60-60l129.9 0c3.6 6.3 5.6 9.9 6.2 10.8 13.1 23 37.6 37.2 64 37.2 10.8 0 21.4-2.4 31.2-6.9L469 154.4c16.5-7.7 27-24.2 27-42.4s-10.5-34.7-27-42.4L403.3 38.9c-9.8-4.6-20.4-6.9-31.2-6.9-26.5 0-50.9 14.2-64 37.2-.6 1-2.6 4.6-6.2 10.8zM176 512l-60.8 0c-12.7 0-25.2-2.5-36.9-7.4L7.4 475.1C2.9 473.2 0 468.8 0 464s2.9-9.2 7.4-11.1l70.9-29.5c11.7-4.9 24.2-7.4 36.9-7.4L348 416c19.9 0 36-16.1 36-36s-16.1-36-36-36l-176 0C94.7 344 32 281.3 32 204S94.7 64 172 64l120.6 0 1.6-2.8c16-28 45.7-45.2 77.9-45.2 13.1 0 26.1 2.9 38 8.4l65.7 30.7C497.9 65.4 512 87.6 512 112s-14.1 46.6-36.2 56.9L410 199.6c-11.9 5.5-24.8 8.4-38 8.4-32.2 0-61.9-17.3-77.9-45.2l-1.6-2.8-120.6 0c-24.3 0-44 19.7-44 44s19.7 44 44 44l176 0c72.9 0 132 59.1 132 132S420.9 512 348 512l-172 0zM352 80a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm16 48a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"]],
    "circle-waveform-lines": [512, 512, ["waveform-circle"], "e12d", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zm112-88c0-4.4 3.6-8 8-8s8 3.6 8 8l0 176c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-176zm64 40c0-4.4 3.6-8 8-8s8 3.6 8 8l0 96c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-96zm64-72c0-4.4 3.6-8 8-8s8 3.6 8 8l0 240c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-240zm64 56c0-4.4 3.6-8 8-8s8 3.6 8 8l0 128c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-128zm64 40c0-4.4 3.6-8 8-8s8 3.6 8 8l0 48c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-48z", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm16-376c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 240c0 4.4 3.6 8 8 8s8-3.6 8-8l0-240zM144 168c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 176c0 4.4 3.6 8 8 8s8-3.6 8-8l0-176zm192 24c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 128c0 4.4 3.6 8 8 8s8-3.6 8-8l0-128zM208 208c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 96c0 4.4 3.6 8 8 8s8-3.6 8-8l0-96zm192 24c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 48c0 4.4 3.6 8 8 8s8-3.6 8-8l0-48z"]],
    "empty-set": [512, 512, [8709, 216], "f656", ["", "M509.7 13.7c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0L431.3 69.4C385.5 26.4 323.8 0 256 0 114.6 0 0 114.6 0 256 0 323.8 26.4 385.5 69.4 431.3L2.3 498.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l67.1-67.1c45.8 43 107.5 69.4 175.3 69.4 141.4 0 256-114.6 256-256 0-67.8-26.4-129.5-69.4-175.3l67.1-67.1zM420 80.7L80.7 420C40.6 377.1 16 319.4 16 256 16 123.5 123.5 16 256 16 319.4 16 377.1 40.6 420 80.7zM92 431.3L431.3 92c40.2 42.9 64.7 100.6 64.7 164 0 132.5-107.5 240-240 240-63.4 0-121.1-24.6-164-64.7z"]],
    "circle-won": [512, 512, [], "e6ec", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zm96 8c0-4.4 3.6-8 8-8l21.4 0-29.1-93.6c-1.3-4.2 1-8.7 5.3-10s8.7 1 10 5.3l30.5 98.4 61.8 0 28.3-106.1c.9-3.5 4.1-5.9 7.7-5.9s6.8 2.4 7.7 5.9l28.3 106.1 61.8 0 30.5-98.4c1.3-4.2 5.8-6.6 10-5.3s6.6 5.8 5.3 10L370.6 256 392 256c4.4 0 8 3.6 8 8s-3.6 8-8 8l-26.4 0-38 122.4c-1.1 3.4-4.2 5.7-7.8 5.6s-6.6-2.5-7.6-5.9l-32.5-122.1-47.4 0-32.6 122.1c-.9 3.4-4 5.9-7.6 5.9s-6.7-2.2-7.8-5.6l-38-122.4-26.4 0c-4.4 0-8-3.6-8-8zm51.1 8l28.3 91.1 24.3-91.1-52.6 0zm73.4-16l38.9 0-19.4-72.9-19.5 72.9zm59.7 16l24.3 91.1 28.3-91.1-52.6 0z", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm0-368c-3.6 0-6.8 2.4-7.7 5.9l-28.3 106.1-61.8 0-30.5-98.4c-1.3-4.2-5.8-6.6-10-5.3s-6.6 5.8-5.3 10l29.1 93.6-21.4 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l26.4 0 38 122.4c1.1 3.4 4.2 5.7 7.8 5.6s6.7-2.5 7.6-5.9l32.6-122.1 47.4 0 32.5 122.1c.9 3.4 4 5.9 7.6 5.9s6.7-2.2 7.8-5.6l38-122.4 26.4 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-21.4 0 29.1-93.6c1.3-4.2-1-8.7-5.3-10s-8.7 1-10 5.3l-30.5 98.4-61.8 0-28.3-106.1c-.9-3.5-4.1-5.9-7.7-5.9zm64.6 219.1l-24.3-91.1 52.6 0-28.3 91.1zM256 183.1l19.4 72.9-38.9 0 19.5-72.9zM163.1 272l52.6 0-24.3 91.1-28.3-91.1z"]],
    "hockey-stick": [512, 512, [], "e7e6", ["M48.5 376l0 96c0 13.3 10.7 24 24 24l56 0 0-144-56 0c-13.3 0-24 10.7-24 24zm96-24l0 144 86.6 0c36.2 0 68.6-22.1 81.9-55.8l34.8-88.2-203.3 0z", "M497.1-26.9c1.6-4.1 6.3-6.1 10.4-4.5s6.1 6.3 4.5 10.4l-184 467.2c-15.7 39.8-54.1 65.9-96.8 65.9L72.5 512c-22.1 0-40-17.9-40-40l0-96c0-22.1 17.9-40 40-40l281.6 0 143-362.9zM144.5 496l86.6 0c36.2 0 68.6-22.1 81.9-55.8l34.8-88.2-203.3 0 0 144zm-72-144c-13.3 0-24 10.7-24 24l0 96c0 13.3 10.7 24 24 24l56 0 0-144-56 0z"]],
    "monkey": [576, 512, [128018], "f6fb", ["M192 431c0-93.2 59.6-175.7 147.5-205.2 20 18.7 46.9 30.2 76.5 30.2 11.1 0 21.9-1.6 32-4.6l0 41.5-2.2-2.3c-2.2-2.4-5.7-3.2-8.8-2s-5 4.2-5 7.4l0 105.1c-18.4-29.6-51.3-49.1-88.3-49.1L328 352c-4.4 0-8 3.6-8 8s3.6 8 8 8l15.7 0c45.8 0 83.9 35.1 87.7 80.7l.7 8c.3 4.1 3.8 7.3 8 7.3l40 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-288 0 0-65zm80-319c0-21.9 17.6-39.6 39.4-40-4.8 12.4-7.4 25.9-7.4 40l0 32c0 2.4 .1 4.9 .2 7.2-18.4-3.6-32.2-19.8-32.2-39.2zm48 0c0-53 43-96 96-96s96 43 96 96l0 32c0 53-43 96-96 96s-96-43-96-96l0-32zm16 0c0 22.3 13.1 41.6 32 50.6l0 5.4c0 26.5 21.5 48 48 48s48-21.5 48-48l0-5.4c18.9-9 32-28.3 32-50.6 0-30.9-25.1-56-56-56l-48 0c-30.9 0-56 25.1-56 56zM520.6 72c21.8 .3 39.4 18.1 39.4 40 0 19.4-13.9 35.6-32.2 39.2 .2-2.4 .2-4.8 .2-7.2l0-32c0-14.1-2.6-27.6-7.4-40z", "M104 16c-48.6 0-88 39.4-88 88l0 272c0 66.3 53.7 120 120 120l40 0 0-65c0-97.8 61-184.5 151.8-218-10.2-13.1-17.6-28.5-21.3-45.3-28.4-2.8-50.5-26.7-50.5-55.7 0-30.9 25.1-56 56-56l7 0c19.4-33.5 55.6-56 97-56s77.7 22.5 97 56l7 0c30.9 0 56 25.1 56 56 0 29.1-22.2 53-50.5 55.7-10.9 50.5-55.8 88.3-109.5 88.3-29.6 0-56.5-11.5-76.5-30.2-87.9 29.5-147.5 112-147.5 205.2l0 65 288 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-40 0c-4.2 0-7.6-3.2-8-7.3l-.7-8c-3.8-45.6-41.9-80.7-87.7-80.7L328 368c-4.4 0-8-3.6-8-8s3.6-8 8-8l15.7 0c37.1 0 69.9 19.5 88.3 49.1L432 296c0-3.3 2-6.2 5-7.4s6.5-.4 8.8 2l93.2 99c23.7 25.2 37 58.6 37 93.2l0 21.2c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-21.2c0-30.6-11.7-60-32.6-82.2l-79.4-84.3 0 131.8 32 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-344 0C60.9 512 0 451.1 0 376L0 104C0 46.6 46.6 0 104 0l32 0c48.6 0 88 39.4 88 88s-39.4 88-88 88l-32 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l32 0c39.8 0 72-32.2 72-72s-32.2-72-72-72l-32 0zM512 144l0-32c0-53-43-96-96-96s-96 43-96 96l0 32c0 53 43 96 96 96s96-43 96-96zM311.4 72c-21.8 .3-39.4 18.1-39.4 40 0 19.4 13.9 35.6 32.2 39.2-.2-2.4-.2-4.8-.2-7.2l0-32c0-14.1 2.6-27.6 7.4-40zM528 112l0 32c0 2.4-.1 4.9-.2 7.2 18.4-3.6 32.2-19.8 32.2-39.2 0-21.9-17.6-39.6-39.4-40 4.7 12.4 7.4 25.9 7.4 40zm-160 0a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm80-16a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm-96 16c0 17.4 11.1 32.2 26.7 37.7 3.2 1.1 5.3 4.2 5.3 7.5l0 10.7c0 17.7 14.3 32 32 32s32-14.3 32-32l0-10.7c0-3.4 2.1-6.4 5.3-7.5 15.5-5.5 26.7-20.3 26.7-37.7 0-22.1-17.9-40-40-40l-48 0c-22.1 0-40 17.9-40 40zm40-56l48 0c30.9 0 56 25.1 56 56 0 22.3-13.1 41.6-32 50.6l0 5.4c0 26.5-21.5 48-48 48s-48-21.5-48-48l0-5.4c-18.9-9-32-28.3-32-50.6 0-30.9 25.1-56 56-56z"]],
    "forklift": [576, 512, [], "f47a", ["M16 208c0-17.7 14.3-32 32-32l52.9 0 101.7 93.9c1.5 1.4 3.4 2.1 5.4 2.1l160 0 0 73.6c-12-6.1-25.6-9.6-40-9.6-48.6 0-88 39.4-88 88 0 2.7 .1 5.4 .4 8l-64.7 0c.2-2.6 .4-5.3 .4-8 0-48.6-39.4-88-88-88-29.8 0-56.1 14.8-72 37.4L16 208z", "M464 8c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 464c0 4.4 3.6 8 8 8l104 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-96 0 0-456zM16 424a72 72 0 1 1 144 0 72 72 0 1 1 -144 0zm0-216c0-17.7 14.3-32 32-32l52.9 0 101.7 93.9c1.5 1.4 3.4 2.1 5.4 2.1l160 0 0 73.6c-12-6.1-25.6-9.6-40-9.6-48.6 0-88 39.4-88 88 0 2.7 .1 5.4 .4 8l-64.7 0c.2-2.6 .4-5.3 .4-8 0-48.6-39.4-88-88-88-29.8 0-56.1 14.8-72 37.4L16 208zm347.5 48l-152.3 0-99.1-91.5 0-84.5c0-17.7 14.3-32 32-32l102.5 0c12.5 0 23.8 7.2 29 18.5l88 189.5zM96 160l-48 0c-26.5 0-48 21.5-48 48L0 424c0 48.6 39.4 88 88 88 40.3 0 74.2-27.1 84.7-64l70.6 0c10.4 36.9 44.4 64 84.7 64 48.6 0 88-39.4 88-88 0-27.3-12.5-51.7-32-67.9l0-88.6c0-3.5-.8-6.9-2.2-10.1L290 59.8C282.1 42.8 265.2 32 246.5 32L144 32c-26.5 0-48 21.5-48 48l0 80zM256 424a72 72 0 1 1 144 0 72 72 0 1 1 -144 0z"]],
    "skull": [512, 512, [128128], "f54c", ["M16 240c0 70.3 34.7 133.3 89.6 174.6 4 3 6.4 7.8 6.4 12.8l0 36.6c0 17.7 14.3 32 32 32l40 0 0-40c0-4.4 3.6-8 8-8s8 3.6 8 8l0 40 48 0 0-40c0-4.4 3.6-8 8-8s8 3.6 8 8l0 40 48 0 0-40c0-4.4 3.6-8 8-8s8 3.6 8 8l0 40 40 0c17.7 0 32-14.3 32-32l0-36.6c0-5 2.4-9.8 6.4-12.8 54.9-41.2 89.6-104.3 89.6-174.6 0-122.8-106.5-224-240-224S16 117.2 16 240zm208 16a64 64 0 1 1 -128 0 64 64 0 1 1 128 0zm192 0a64 64 0 1 1 -128 0 64 64 0 1 1 128 0z", "M406.4 414.6C461.3 373.3 496 310.3 496 240 496 117.2 389.5 16 256 16S16 117.2 16 240c0 70.3 34.7 133.3 89.6 174.6 4 3 6.4 7.8 6.4 12.8l0 36.6c0 17.7 14.3 32 32 32l40 0 0-40c0-4.4 3.6-8 8-8s8 3.6 8 8l0 40 48 0 0-40c0-4.4 3.6-8 8-8s8 3.6 8 8l0 40 48 0 0-40c0-4.4 3.6-8 8-8s8 3.6 8 8l0 40 40 0c17.7 0 32-14.3 32-32l0-36.6c0-5 2.4-9.8 6.4-12.8zM184 512l-40 0c-26.5 0-48-21.5-48-48l0-36.6C37.5 383.4 0 315.8 0 240 0 107.5 114.6 0 256 0S512 107.5 512 240c0 75.8-37.5 143.4-96 187.4l0 36.6c0 26.5-21.5 48-48 48l-184 0zm24-256a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM96 256a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zm256 48a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm0-112a64 64 0 1 1 0 128 64 64 0 1 1 0-128z"]],
    "sneaker": [640, 512, [], "e6da", ["M16 158.6l0 193.4 608 0 0-6c0-62.6-45.2-116-107-126.3l-71.7-11.9-1.6-.3-46.1 46.1c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l43-43-65.2-40.1-54.5 54.5c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l51.8-51.8-109.5-67.4c-3.4-2.1-7.3-3.2-11.2-3.2-11.8 0-21.4 9.6-21.4 21.4l0 45.3c0 42.7-34.6 77.3-77.3 77.3-27.2 0-52.3-14.2-66.3-37.5L43.2 151.1c-2.6-4.4-7.4-7.1-12.6-7.1-8.1 0-14.6 6.6-14.6 14.6z", "M397.7 253.7c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l43-43-65.2-40.1-54.5 54.5c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l51.8-51.8-109.5-67.4c-3.4-2.1-7.3-3.2-11.2-3.2-11.8 0-21.4 9.6-21.4 21.4l0 45.3c0 42.7-34.6 77.3-77.3 77.3-27.2 0-52.3-14.2-66.3-37.5L43.2 151.1c-2.6-4.4-7.4-7.1-12.6-7.1-8.1 0-14.6 6.6-14.6 14.6l0 193.4 608 0 0-6c0-62.6-45.2-116-107-126.3l-71.7-11.9-1.6-.3-46.1 46.1zM16 368l0 16c0 26.5 21.5 48 48 48l512 0c26.5 0 48-21.5 48-48l0-16-608 0zM0 384L0 158.6c0-16.9 13.7-30.6 30.6-30.6 10.8 0 20.7 5.6 26.3 14.9l21.2 35.4c11.1 18.5 31 29.8 52.6 29.8 33.9 0 61.3-27.4 61.3-61.3l0-45.3c0-20.7 16.7-37.4 37.4-37.4 6.9 0 13.7 1.9 19.6 5.5L448 192 519.7 203.9C589.1 215.5 640 275.6 640 346l0 38c0 35.3-28.7 64-64 64L64 448c-35.3 0-64-28.7-64-64z"]],
    "gamepad-modern": [576, 512, [127918, 63676, "gamepad-alt"], "e5a2", ["M16 232l0 151.7c0 44.4 36 80.3 80.3 80.3 34.6 0 65.3-22.1 76.2-54.9l11.9-35.6 1.2-2.2c1.5-2 3.8-3.3 6.4-3.3l192 0c3.4 0 6.5 2.2 7.6 5.5l11.9 35.6c10.9 32.8 41.6 54.9 76.2 54.9 44.4 0 80.3-36 80.3-80.3L560 232c0-101.6-82.4-184-184-184L200 48C98.4 48 16 130.4 16 232zm88-8c0-4.4 3.6-8 8-8l40 0 0-40c0-4.4 3.6-8 8-8s8 3.6 8 8l0 40 40 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-40 0 0 40c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-40-40 0c-4.4 0-8-3.6-8-8zm296 32a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm48-80a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M376 32c110.5 0 200 89.5 200 200l0 151.7c0 53.2-43.1 96.3-96.3 96.3-41.5 0-78.3-26.5-91.4-65.9l-10.1-30.1-180.4 0-10.1 30.1C174.6 453.5 137.8 480 96.3 480 43.1 480 0 436.9 0 383.7L0 232C0 121.5 89.5 32 200 32l176 0zM200 48C98.4 48 16 130.4 16 232l0 151.7c0 44.4 36 80.3 80.3 80.3 34.6 0 65.3-22.1 76.2-54.9l11.9-35.6 1.2-2.2c1.5-2 3.8-3.3 6.4-3.3l192 0c3.4 0 6.5 2.2 7.6 5.5l11.9 35.6c10.9 32.8 41.6 54.9 76.2 54.9 44.4 0 80.3-36 80.3-80.3L560 232c0-101.6-82.4-184-184-184L200 48zM160 168c4.4 0 8 3.6 8 8l0 40 40 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-40 0 0 40c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-40-40 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l40 0 0-40c0-4.4 3.6-8 8-8zM384 272a16 16 0 1 1 0-32 16 16 0 1 1 0 32zm48-80a16 16 0 1 1 0-32 16 16 0 1 1 0 32z"]],
    "square-k": [448, 512, [], "e274", ["M16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96zm128 72c0-4.4 3.6-8 8-8s8 3.6 8 8L160 270.3 282.7 162c3.3-2.9 8.4-2.6 11.3 .7s2.6 8.4-.7 11.3l-75.9 67 76.9 98.1c2.7 3.5 2.1 8.5-1.4 11.2s-8.5 2.1-11.2-1.4l-76.4-97.3-45.3 40 0 52.4c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-176z", "M64 48C37.5 48 16 69.5 16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm293.3 78l-75.9 67 76.9 98.1c2.7 3.5 2.1 8.5-1.4 11.2s-8.5 2.1-11.2-1.4l-76.4-97.3-45.3 40 0 52.4c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-176c0-4.4 3.6-8 8-8s8 3.6 8 8L160 270.3 282.7 162c3.3-2.9 8.4-2.6 11.3 .7s2.6 8.4-.7 11.3z"]],
    "comment-text": [512, 512, [], "e14d", ["M16 240c0 51.7 18.8 99.4 50.5 137.4 4.1 4.9 4.9 11.7 2 17.4l-49.4 98.7 124.8-49.9c3.9-1.6 8.3-1.5 12.2 .1 30.4 13 64.2 20.2 99.9 20.2 133.5 0 240-101.2 240-224S389.5 16 256 16 16 117.2 16 240zm160-56c0-4.4 3.6-8 8-8l144 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-64 0 0 136c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-136-64 0c-4.4 0-8-3.6-8-8z", "M68.5 394.8c2.8-5.7 2-12.5-2-17.4-31.7-38-50.5-85.7-50.5-137.4 0-122.8 106.5-224 240-224S496 117.2 496 240 389.5 464 256 464c-35.7 0-69.5-7.3-99.9-20.2-3.9-1.7-8.3-1.7-12.2-.1L19.1 493.5 68.5 394.8zM0 240c0 55.7 20.2 106.9 54.2 147.7L1.4 493.3C-4 504 7.6 515.4 18.4 511l131.5-52.6c32.3 13.8 68.3 21.5 106.2 21.5 141.4 0 256-107.5 256-240S397.4 0 256 0 0 107.5 0 240zm184-64c-4.4 0-8 3.6-8 8s3.6 8 8 8l64 0 0 136c0 4.4 3.6 8 8 8s8-3.6 8-8l0-136 64 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-144 0z"]],
    "mars-stroke-up": [384, 512, [9896, "mars-stroke-v"], "f22a", ["M32 336a160 160 0 1 0 320 0 160 160 0 1 0 -320 0z", "M192 176l0 0c-88.4 0-160 71.6-160 160s71.6 160 160 160 160-71.6 160-160-71.6-160-160-160zM16 336c0-94.5 74.5-171.6 168-175.8l0-48.2-56 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l56 0 0-102.4-50.7 44.4c-3.3 2.9-8.4 2.6-11.3-.8s-2.6-8.4 .8-11.3l64-56c3-2.6 7.5-2.6 10.5 0l64 56c3.3 2.9 3.7 8 .8 11.3s-8 3.7-11.3 .8L200-6.4 200 96 256 96c4.4 0 8 3.6 8 8s-3.6 8-8 8l-56 0 0 48.2c93.5 4.2 168 81.3 168 175.8 0 97.2-78.8 176-176 176S16 433.2 16 336z"]],
    "cowbell": [448, 512, [], "f8b3", ["M16 373.5C16 388.1 27.9 400 42.5 400l363 0c14.6 0 26.5-11.9 26.5-26.5 0-2.3-.3-4.5-.9-6.7l-66-251C359.5 94.7 340.5 80 318.7 80L129.3 80c-21.8 0-40.9 14.7-46.4 35.8l-66 251c-.6 2.2-.9 4.5-.9 6.7z", "M184 0l80 0c22.1 0 40 17.9 40 40l0 24-160 0 0-24c0-22.1 17.9-40 40-40zM128 40l0 24c-28.5 .6-53.3 20-60.6 47.7l-66 251C.5 366.2 0 369.8 0 373.5 0 397 19 416 42.5 416l363 0c23.5 0 42.5-19 42.5-42.5 0-3.6-.5-7.3-1.4-10.8l-66-251C373.3 84 348.5 64.6 320 64l0-24c0-30.9-25.1-56-56-56l-80 0c-30.9 0-56 25.1-56 56zm8 40l182.7 0c21.8 0 40.9 14.7 46.4 35.8l66 251c.6 2.2 .9 4.5 .9 6.7 0 14.6-11.9 26.5-26.5 26.5l-363 0c-14.6 0-26.5-11.9-26.5-26.5 0-2.3 .3-4.5 .9-6.7l66-251C88.5 94.7 107.5 80 129.3 80l6.7 0zm88 432c32.8 0 61-19.7 73.3-48l-17.9 0c-11.1 19.1-31.8 32-55.4 32s-44.4-12.9-55.4-32l-17.9 0c12.3 28.3 40.5 48 73.3 48z"]],
    "fire-flame-simple": [384, 512, ["burn"], "f46a", ["M16 321.6C16 417.7 95.5 496 192 496s176-78.3 176-174.4c0-20.3-3.6-40.5-10.5-59.6l-.7-1.9C323.6 168.7 269.2 86.5 198.2 20.2l-3.3-3c-.8-.7-1.8-1.2-2.9-1.2s-2.1 .4-2.9 1.2l-3.3 3C114.8 86.5 60.4 168.7 27.2 260l-.7 1.9C19.6 281 16 301.2 16 321.6zm64-2.1c0-12.4 2.6-24.7 7.6-36l1.9-4.3c16.5-37.2 39.8-71.1 68.6-99.9l8.9-8.9c6.6-6.6 15.6-10.3 24.9-10.3s18.3 3.7 24.9 10.3l8.9 8.9c28.8 28.8 52.1 62.7 68.6 99.9l1.9 4.3c5 11.3 7.6 23.7 7.6 36 0 61.7-50 112.5-112 112.5S80 381.2 80 319.5z", "M209.1 8.5c72.9 68 128.7 152.4 162.7 246.1l.7 1.9c7.6 20.9 11.5 42.9 11.5 65.1 0 105.2-86.8 190.4-192 190.4S0 426.7 0 321.6c0-22.2 3.9-44.2 11.5-65.1l.7-1.9C46.2 160.8 102 76.5 174.9 8.5l3.3-3C181.9 2 186.9 0 192 0s10.1 2 13.8 5.5l3.3 3zM356.8 260C323.6 168.7 269.2 86.5 198.2 20.2l-3.3-3c-.8-.7-1.8-1.2-2.9-1.2s-2.1 .4-2.9 1.2l-3.3 3C114.8 86.5 60.4 168.7 27.2 260l-.7 1.9C19.6 281 16 301.2 16 321.6 16 417.7 95.5 496 192 496s176-78.3 176-174.4c0-20.3-3.6-40.5-10.5-59.6l-.7-1.9zm-60.4 23.4c5 11.3 7.6 23.7 7.6 36 0 61.7-50 112.5-112 112.5S80 381.2 80 319.5c0-12.4 2.6-24.7 7.6-36l1.9-4.3c16.5-37.2 39.8-71.1 68.6-99.9l8.9-8.9c6.6-6.6 15.6-10.3 24.9-10.3s18.3 3.7 24.9 10.3l8.9 8.9c28.8 28.8 52.1 62.7 68.6 99.9l1.9 4.3zM205.6 181.6C202 178 197.1 176 192 176s-10 2-13.6 5.6l-8.9 8.9c-27.4 27.4-49.6 59.7-65.3 95.1l-1.9 4.3c-4.1 9.3-6.2 19.4-6.2 29.5 0 53 43 96.5 96 96.5s96-43.5 96-96.5c0-10.1-2.1-20.3-6.2-29.5l-1.9-4.3c-15.8-35.4-37.9-67.7-65.3-95.1l-8.9-8.9z"]],
    "tree": [448, 512, [127794], "f1bb", ["M25.8 432l397.4 0-118-138.8c-2-2.4-2.5-5.7-1.2-8.5 1.3-2.8 4.2-4.7 7.3-4.7l79.9 0-104.4-122.8c-2-2.4-2.5-5.7-1.2-8.5 1.3-2.8 4.2-4.7 7.3-4.7L359 144 224.5-11.8 90 144 156.1 144c3.1 0 6 1.8 7.3 4.7 1.3 2.8 .8 6.2-1.2 8.5L57.8 280 137.7 280c3.1 0 6 1.8 7.3 4.7 1.3 2.8 .8 6.2-1.2 8.5L25.8 432z", "M224.5-32c2.3 0 4.5 1 6.1 2.8l152 176c2 2.4 2.5 5.7 1.2 8.6s-4.2 4.7-7.3 4.7l-66.3 0 104.4 122.8c2 2.4 2.5 5.7 1.2 8.5s-4.1 4.6-7.2 4.7l-79.9 0 118 138.8c2 2.4 2.5 5.7 1.2 8.5s-4.1 4.6-7.2 4.7l-208 0 0 88c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-88-208 0c-3.1 0-5.9-1.8-7.2-4.7s-.9-6.2 1.2-8.5l118-138.8-79.9 0c-3.1 0-5.9-1.8-7.2-4.7s-.9-6.2 1.2-8.5L138.8 160 72.5 160c-3.1 0-6-1.8-7.3-4.7s-.8-6.2 1.2-8.6l152-176 1.3-1.2c1.4-1 3-1.6 4.8-1.6zM90 144l66.1 0c3.1 0 6 1.8 7.3 4.7 1.3 2.8 .8 6.2-1.2 8.5L57.8 280 137.7 280c3.1 0 6 1.8 7.3 4.7 1.3 2.8 .8 6.2-1.2 8.5l-118 138.8 397.4 0-118-138.8c-2-2.4-2.5-5.7-1.2-8.5 1.3-2.8 4.2-4.7 7.3-4.7l79.9 0-104.4-122.8c-2-2.4-2.5-5.7-1.2-8.5 1.3-2.8 4.2-4.7 7.3-4.7L359 144 224.5-11.8 90 144z"]],
    "gauge-simple-min": [512, 512, ["tachometer-slowest"], "f62d", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zm73.4-20.6c2.5-3.6 7.5-4.5 11.1-2l108 75.6c11.7-12.9 28.6-21 47.4-21 35.3 0 64 28.7 64 64s-28.7 64-64 64-64-28.7-64-64c0-10.8 2.7-21 7.4-29.9l-108-75.6c-3.6-2.5-4.5-7.5-2-11.1z", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm0-208a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm0 112c35.3 0 64-28.7 64-64s-28.7-64-64-64c-18.8 0-35.7 8.1-47.4 21l-108-75.6c-3.6-2.5-8.6-1.7-11.1 2s-1.7 8.6 2 11.1l108 75.6c-4.7 8.9-7.4 19.1-7.4 29.9 0 35.3 28.7 64 64 64z"]],
    "comments-question-check": [576, 512, [], "e14f", ["M16 144c0 33.3 11.2 64.2 30.4 89.9 3.2 4.3 4.1 10 2.2 15.1l-31.1 85.4 106.8-38.8c3.3-1.2 6.9-1.3 10.3-.2 17.9 5.6 37.2 8.7 57.3 8.7 98.5 0 176-72.9 176-160S290.5-16 192-16 16 56.9 16 144zm114.8-42.8C130.8 67.4 158.2 40 192 40s61.2 27.4 61.2 61.2c0 31.3-21 47.1-37.4 54.4-9.5 4.3-15.9 12.3-15.9 20.4 0 4.4-3.6 8-8 8s-8-3.6-8-8c0-16.6 12.3-29.2 25.3-35 13.6-6.1 27.9-17.5 27.9-39.8 0-25-20.2-45.2-45.2-45.2s-45.2 20.2-45.2 45.2c0 4.4-3.6 8-8 8s-8-3.6-8-8zM208 232a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm3.4 135.3c15.9 72.6 86.1 128.7 172.6 128.7 20.1 0 39.4-3.1 57.3-8.7 3.4-1 7-1 10.2 .2l106.8 38.8-31.1-85.4c-1.8-5.1-1-10.7 2.2-15.1 19.3-25.7 30.4-56.7 30.4-89.9 0-73.4-55-136.7-131.2-154.8-11.5 65.1-52.6 119.2-108.7 152.2l47.1 60.6 82-134.1c2.3-3.8 7.2-5 11-2.7s5 7.2 2.7 11l-88 144c-1.4 2.2-3.8 3.7-6.4 3.8s-5.2-1-6.8-3.1l-56-72c-28.6 14.7-60.7 23.8-94.3 26.4z", "M48.7 249c1.8-5.1 1-10.7-2.2-15.1-19.3-25.7-30.4-56.7-30.4-89.9 0-87.1 77.5-160 176-160s176 72.9 176 160-77.5 160-176 160c-20.1 0-39.4-3.1-57.3-8.7-3.3-1-7-1-10.3 .2L17.6 334.4 48.7 249zM0 144c0 36.9 12.4 71.2 33.6 99.5L.8 333.7c-.5 1.5-.8 3.1-.8 4.6 0 7.5 6.1 13.6 13.6 13.6 1.6 0 3.2-.3 4.6-.8l111.6-40.6c19.5 6.1 40.4 9.4 62.1 9.4 106 0 192-78.8 192-176S298-32 192-32 0 46.8 0 144zM384 512c21.7 0 42.6-3.3 62.1-9.4l111.6 40.6c1.5 .5 3.1 .8 4.6 .8 7.5 0 13.6-6.1 13.6-13.6 0-1.6-.3-3.2-.8-4.6l-32.8-90.2c21.2-28.3 33.6-62.6 33.6-99.5 0-82.4-61.7-151.5-145-170.7-.5 5.4-1.3 10.7-2.2 15.9 76.2 18.1 131.2 81.4 131.2 154.8 0 33.3-11.2 64.2-30.4 89.9-3.2 4.3-4.1 10-2.2 15.1l31.1 85.4-106.8-38.8c-3.3-1.2-6.9-1.3-10.2-.2-17.9 5.6-37.2 8.7-57.3 8.7-86.5 0-156.7-56.1-172.6-128.7-5.4 .4-10.8 .6-16.2 .7 16.4 81.9 94.7 144 188.8 144zM146.8 101.2C146.8 76.2 167 56 192 56s45.2 20.2 45.2 45.2c0 22.3-14.3 33.7-27.9 39.8-13 5.8-25.3 18.4-25.3 35 0 4.4 3.6 8 8 8s8-3.6 8-8c0-8.1 6.4-16.1 15.9-20.4 16.4-7.3 37.4-23.1 37.4-54.4 0-33.8-27.4-61.2-61.2-61.2s-61.2 27.4-61.2 61.2c0 4.4 3.6 8 8 8s8-3.6 8-8zM192 248a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm270.8 20.2c2.3-3.8 1.1-8.7-2.7-11s-8.7-1.1-11 2.7l-82 134.1-48.9-62.9c-2.7-3.5-7.7-4.1-11.2-1.4s-4.1 7.7-1.4 11.2l56 72c1.6 2.1 4.1 3.2 6.8 3.1s5-1.6 6.4-3.8l88-144z"]],
    "smog": [576, 512, [], "f75f", ["M48 144c0 70.7 57.3 128 128 128l94.4 0c2 0 4 .8 5.4 2.1 20 18.5 46.7 29.9 76.1 29.9s56.2-11.3 76.2-29.9c1.4-1.3 3.3-2.1 5.3-2.1 52.3-.8 94.5-43.5 94.5-96 0-53-43-96-96-96-1.8 0-3.6 0-5.3 .1-3.1 .2-6.1-1.5-7.5-4.3-18.8-35.6-56.1-59.9-99.2-59.9-24.2 0-46.6 7.7-64.9 20.7-2.7 1.9-6.3 2-9 .2-20.1-13.2-44.2-20.9-70.1-20.9-70.7 0-128 57.3-128 128z", "M32 144C32 64.5 96.5 0 176 0 203.2 0 228.6 7.5 250.3 20.6 270.4 7.6 294.3 0 320 0 367.4 0 408.8 25.8 430.9 64l1.1 0c61.9 0 112 50.1 112 112 0 60.3-47.6 109.4-107.2 111.9-22.6 20-52.3 32.1-84.8 32.1-32.5 0-62.1-12.1-84.7-32L176 288C96.5 288 32 223.5 32 144zM176 16C105.3 16 48 73.3 48 144s57.3 128 128 128l94.4 0c2 0 4 .8 5.4 2.1 20 18.5 46.7 29.9 76.1 29.9s56.2-11.3 76.2-29.9c1.4-1.3 3.3-2.1 5.3-2.1 52.3-.8 94.5-43.5 94.5-96 0-53-43-96-96-96-1.8 0-3.6 0-5.3 .1-3.1 .2-6.1-1.5-7.5-4.3-18.8-35.6-56.1-59.9-99.2-59.9-24.2 0-46.6 7.7-64.9 20.7-2.7 1.9-6.3 2-9 .2-20.1-13.2-44.2-20.9-70.1-20.9zM512 392c0 4.4-3.6 8-8 8L8 400c-4.4 0-8-3.6-8-8s3.6-8 8-8l496 0c4.4 0 8 3.6 8 8zM72 480l112 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L72 496c-4.4 0-8-3.6-8-8s3.6-8 8-8zm176 0l320 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-320 0c-4.4 0-8-3.6-8-8s3.6-8 8-8z"]],
    "s": [320, 512, [115], "53", ["", "M0 143.5C0 81.9 49.9 32 111.5 32L296 32c4.4 0 8 3.6 8 8s-3.6 8-8 8L111.5 48c-52.8 0-95.5 42.8-95.5 95.5 0 47 34.2 87 80.6 94.4l129.2 20.4c54.2 8.6 94.1 55.3 94.1 110.2 0 61.6-49.9 111.5-111.5 111.5L24 480c-4.4 0-8-3.6-8-8s3.6-8 8-8l184.5 0c52.8 0 95.5-42.8 95.5-95.5 0-47-34.2-87-80.6-94.4L94.1 253.7C39.9 245.1 0 198.4 0 143.5z"]],
    "phone-arrow-up-right": [512, 512, ["phone-arrow-up", "phone-outgoing"], "e224", ["M18.4 155.8c35.2 169.3 168.5 302.6 337.8 337.8 65.7 13.7 121.1-33.7 137-91.8l1.9-6.9c3.5-12.8-3.1-26.3-15.3-31.4l-96.4-40.2c-10.8-4.5-23.2-1.4-30.6 7.7l-44.8 54.7c-2.3 2.8-6.3 3.7-9.6 2.2-76.5-36-137.7-99.2-171.1-177.1-1.4-3.3-.5-7.1 2.3-9.3L181 159.3c9-7.4 12.2-19.9 7.7-30.6L148.5 32.3C143.4 20 130 13.4 117.1 16.9l-6.9 1.9C52.1 34.7 4.7 90.1 18.4 155.8z", "M322.4 178.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L496 27.3 496 152c0 4.4 3.6 8 8 8s8-3.6 8-8L512 8c0-4.4-3.6-8-8-8L360 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l124.7 0-162.3 162.3zM117.1 16.9c12.8-3.5 26.3 3.1 31.4 15.3l40.2 96.4c4.5 10.8 1.4 23.2-7.7 30.6l-51.5 42.1c-2.8 2.3-3.7 6.1-2.3 9.3 33.4 77.9 94.6 141.1 171.1 177.1 3.3 1.6 7.3 .7 9.6-2.2L352.7 331c7.4-9 19.9-12.2 30.6-7.7l96.4 40.2c12.3 5.1 18.8 18.5 15.3 31.4l-1.9 6.9c-15.9 58.1-71.3 105.5-137 91.8-169.3-35.2-302.6-168.5-337.8-337.8-13.7-65.7 33.7-121.1 91.8-137l6.9-1.9zm46.1 9.2C155.1 6.4 133.5-4.1 112.9 1.5L106 3.4C42 20.8-13.1 82.9 2.7 159.1 39.3 334.6 177.4 472.8 352.9 509.3 429.1 525.1 491.2 470 508.6 406l1.9-6.9c5.6-20.6-4.9-42.1-24.6-50.3l-96.4-40.2c-17.3-7.2-37.3-2.2-49.2 12.3l-40.8 49.9C231 336.9 175.8 279.9 144.3 210l46.8-38.3c14.5-11.9 19.5-31.9 12.3-49.2L163.3 26.1z"]],
    "teddy-bear": [512, 512, [], "e3cf", ["M16.3 405.2c.1 1 .3 2.1 .5 3.2l1.1 4.8-1.8 24.7 0 2.1c1.5 31.8 24.9 54.3 56.4 56l367.2 0c31.5-1.7 54.9-24.2 56.4-56l0-32c-1.2-21.7-17.4-40-40-40-22.1 0-40 17.9-40 40 0 4.4-3.6 8-8 8l-32 0c-4.4 0-8-3.6-8-8l0-67.8c0-3 1.7-5.8 4.5-7.2 40.3-19.8 74.8-49.6 100.2-86.1 10.6-17.2 9.3-39.5-6.7-53.2-18.3-14.2-45-12.4-58.9 7.4-31.3 44.7-81.8 74.9-139.4 78.5l-23.3 0c-57.7-3.6-108.2-33.8-139.4-78.5-13.9-19.8-40.6-21.6-58.9-7.4-16 13.8-17.3 36-6.7 53.2 25.4 36.5 59.9 66.2 100.2 86.1 2.7 1.3 4.5 4.1 4.5 7.2l0 67.8c0 4.4-3.6 8-8 8l-32 0c-4.4 0-8-3.6-8-8 0-22.1-17.9-40-40-40-21.7 0-37.4 16.8-39.8 37.2zM104 64c0 19.7 11.9 36.7 29 44.1 3.4 1.5 5.4 5.1 4.7 8.8-1.1 5.9-1.7 12.3-1.7 19.1 0 66.3 53.7 120 120 120 66.3 0 120-53.7 120-120 0-6.9-.6-13.2-1.7-19.1-.7-3.7 1.3-7.3 4.7-8.8 17.1-7.4 29-24.3 29-44.1 0-26.5-21.5-48-48-48-20.9 0-38.7 13.4-45.3 32.1-1.4 3.8-5.4 6-9.4 5.1-14.9-3.5-31.7-5.2-49.4-5.2s-34.5 1.7-49.4 5.2c-4 .9-8-1.3-9.4-5.1-6.6-18.7-24.4-32.1-45.2-32.1-26.5 0-48 21.5-48 48zm80 328c0-39.8 32.2-72 72-72s72 32.2 72 72l0 16c0 4.4-3.6 8-8 8l-128 0c-4.4 0-8-3.6-8-8l0-16zm40-264a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm-8 56c0-9.7 5.3-17.9 12.6-23.4s17-8.6 27.4-8.6 20.1 3.1 27.4 8.6 12.6 13.7 12.6 23.4-5.3 17.9-12.6 23.4-17 8.6-27.4 8.6-20.1-3.1-27.4-8.6-12.6-13.7-12.6-23.4zm104-56a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M256 320c39.8 0 72 32.2 72 72l0 16c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-16c0-30.9-25.1-56-56-56s-56 25.1-56 56l0 16c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-16c0-39.8 32.2-72 72-72zm0-168c10.4 0 20.1 3.1 27.4 8.6s12.6 13.7 12.6 23.4-5.3 17.9-12.6 23.4-17 8.6-27.4 8.6-20.1-3.1-27.4-8.6-12.6-13.7-12.6-23.4 5.3-17.9 12.6-23.4 17-8.6 27.4-8.6zm0 16c-7.3 0-13.5 2.2-17.8 5.4s-6.2 7-6.2 10.6 1.9 7.4 6.2 10.6 10.5 5.4 17.8 5.4 13.5-2.2 17.8-5.4 6.2-7 6.2-10.6-1.9-7.4-6.2-10.6-10.5-5.4-17.8-5.4zm-48-24a16 16 0 1 1 0-32 16 16 0 1 1 0 32zm96 0a16 16 0 1 1 0-32 16 16 0 1 1 0 32zm56-144c35.3 0 64 28.7 64 64 0 24.1-13.4 45-33.1 55.9 .7 5.1 1.1 10.5 1.1 16.1 0 40.4-17.7 76.7-45.7 101.6 18.7-11.9 34.9-27.4 47.6-45.6 20.7-26.6 55.8-31 82.5-10.4 22.3 19.2 24.4 50.5 9.4 74.5-26 37.3-61 68-101.8 89l0 55 16.6 0c3.9-27.1 27.2-48 55.4-48 30.9 0 56 25.1 56 56l0 32c-1.8 40.2-31.9 69.9-71.6 72L71.6 512C31.9 509.9 1.9 480.2 0 440l0-32c0-30.9 25.1-56 56-56 28.2 0 51.5 20.9 55.4 48l16.6 0 0-55c-40.8-21-75.8-51.7-101.8-89-15-24-12.9-55.3 9.4-74.5 26.7-20.6 61.7-16.2 82.5 10.4 12.7 18.2 28.9 33.7 47.6 45.6-28-24.9-45.7-61.2-45.7-101.6 0-5.6 .4-10.9 1.1-16.1-19.7-10.9-33.1-31.8-33.1-55.9 0-35.3 28.7-64 64-64 25.4 0 47.3 14.9 57.6 36.3 14.6-2.9 30.2-4.3 46.4-4.3 16.2 0 31.9 1.4 46.4 4.3 10.3-21.4 32.2-36.3 57.6-36.3zM466 193.7c-18.3-14.2-45-12.4-58.9 7.4l0 0c-31.2 44.8-81.7 74.9-139.4 78.5l-23.3 0C186.7 276 136.2 245.9 105 201.1l0 0c-13.9-19.9-40.6-21.7-58.9-7.4-16 13.8-17.3 36-6.7 53.2 25.4 36.5 59.9 66.2 100.2 86.1 2.7 1.3 4.5 4.1 4.5 7.2l0 67.8c0 4.4-3.6 8-8 8l-32 0c-4.4 0-8-3.6-8-8 0-22.1-17.9-40-40-40-22.6 0-38.8 18.3-40 40l0 32c1.5 31.8 24.9 54.3 56.4 56l367.2 0c31.5-1.7 54.9-24.2 56.4-56l0-32c-1.2-21.7-17.4-40-40-40-22.1 0-40 17.9-40 40 0 4.4-3.6 8-8 8l-32 0c-4.4 0-8-3.6-8-8l0-67.8c0-3 1.7-5.8 4.5-7.2 40.3-19.8 74.8-49.6 100.2-86.1 10.6-17.2 9.3-39.5-6.7-53.2zM360.1 16c-20.9 0-38.7 13.4-45.3 32.1-1.4 3.8-5.4 6-9.4 5.1-14.9-3.5-31.7-5.2-49.4-5.2s-34.5 1.7-49.4 5.2c-4 .9-8-1.3-9.4-5.1-6.6-18.7-24.4-32.1-45.2-32.1-26.5 0-48 21.5-48 48 0 19.7 11.9 36.7 29 44.1 3.4 1.5 5.4 5.1 4.7 8.8-1.1 5.9-1.7 12.3-1.7 19.1 0 66.3 53.7 120 120 120l0 0c66.3 0 120-53.7 120-120 0-6.9-.6-13.2-1.7-19.1-.7-3.7 1.3-7.3 4.7-8.8 17.1-7.4 29-24.3 29-44.1 0-26.5-21.5-48-48-48z"]],
    "slot-machine": [640, 512, [], "e3ce", ["M48.2 91.1L48 96 48 416c0 26.5 21.5 48 48 48l352 0c26.5 0 48-21.5 48-48l0-320c0-24.9-18.9-45.3-43.1-47.8L448 48 96 48C71.1 48 50.7 66.9 48.2 91.1zM128 168c0-4.4 3.6-8 8-8l56 0c2.5 0 4.8 1.2 6.3 3.2s2 4.5 1.4 6.9l-48 176c-1.2 4.3-5.6 6.8-9.8 5.6s-6.8-5.6-5.6-9.8L181.5 176 136 176c-4.4 0-8-3.6-8-8zm112 0c0-4.4 3.6-8 8-8l56 0c2.5 0 4.8 1.2 6.3 3.2s2 4.5 1.4 6.9l-48 176c-1.2 4.3-5.6 6.8-9.8 5.6s-6.8-5.6-5.6-9.8L293.5 176 248 176c-4.4 0-8-3.6-8-8zm112 0c0-4.4 3.6-8 8-8l56 0c2.5 0 4.8 1.2 6.3 3.2s2 4.5 1.4 6.9l-48 176c-1.2 4.3-5.6 6.8-9.8 5.6s-6.8-5.6-5.6-9.8L405.5 176 360 176c-4.4 0-8-3.6-8-8zm208-24a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M454.5 32.3C486.8 35.6 512 62.9 512 96l0 320-.3 6.5C510 439 502 453.6 490.2 464l37.8 0c30.9 0 56-25.1 56-56l0-216.7c-22.7-3.8-40-23.5-40-47.3 0-26.5 21.5-48 48-48s48 21.5 48 48c0 23.8-17.3 43.5-40 47.3L600 408c0 39.8-32.2 72-72 72l-432 0-6.5-.3c-30.1-3.1-54.1-27-57.1-57.1L32 416 32 96c0-33.1 25.2-60.4 57.5-63.7l6.5-.3 352 0 6.5 .3zM96 48C71.1 48 50.7 66.9 48.2 91.1L48 96 48 416c0 26.5 21.5 48 48 48l352 0c26.5 0 48-21.5 48-48l0-320c0-24.9-18.9-45.3-43.1-47.8L448 48 96 48zm96 112c2.5 0 4.8 1.2 6.3 3.2s2 4.5 1.4 6.9l-48 176c-1.2 4.3-5.6 6.8-9.8 5.6s-6.8-5.6-5.6-9.8L181.5 176 136 176c-4.4 0-8-3.6-8-8s3.6-8 8-8l56 0zm112 0c2.5 0 4.8 1.2 6.3 3.2s2 4.5 1.4 6.9l-48 176c-1.2 4.3-5.6 6.8-9.8 5.6s-6.8-5.6-5.6-9.8L293.5 176 248 176c-4.4 0-8-3.6-8-8s3.6-8 8-8l56 0zm112 0c2.5 0 4.8 1.2 6.3 3.2s2 4.5 1.4 6.9l-48 176c-1.2 4.3-5.6 6.8-9.8 5.6s-6.8-5.6-5.6-9.8L405.5 176 360 176c-4.4 0-8-3.6-8-8s3.6-8 8-8l56 0zm176-48a32 32 0 1 0 0 64 32 32 0 1 0 0-64z"]],
    "face-sleeping": [640, 512, [], "e38d", ["M80 256c0-132.5 107.5-240 240-240 5.4 0 10.7 .2 16 .5l0-16C375 2.9 411.7 14 444 32l-52 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l62.9 0-69.1 82.9c-2 2.4-2.4 5.7-1.1 8.5s4.1 4.6 7.2 4.6l80 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-62.9 0 64.2-77.1c45.9 34.4 79.9 83.9 94.6 141.1l-16.6 0c5.6 20.4 8.6 41.8 8.6 64 0 132.5-107.5 240-240 240S80 388.5 80 256zm80-24c0 30.9 25.1 56 56 56l16 0c30.9 0 56-25.1 56-56 0-4.4-3.6-8-8-8s-8 3.6-8 8c0 22.1-17.9 40-40 40l-16 0c-22.1 0-40-17.9-40-40 0-4.4-3.6-8-8-8s-8 3.6-8 8zM272 384a48 48 0 1 0 96 0 48 48 0 1 0 -96 0zm80-152c0 30.9 25.1 56 56 56l16 0c30.9 0 56-25.1 56-56 0-4.4-3.6-8-8-8s-8 3.6-8 8c0 22.1-17.9 40-40 40l-16 0c-22.1 0-40-17.9-40-40 0-4.4-3.6-8-8-8s-8 3.6-8 8z", "M544-56c0 4.4 3.6 8 8 8l62.9 0-69.1 82.9c-2 2.4-2.4 5.7-1.1 8.5S548.9 48 552 48l80 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-62.9 0 69.1-82.9c2-2.4 2.4-5.7 1.1-8.5S635.1-64 632-64l-80 0c-4.4 0-8 3.6-8 8zM384 40c0 4.4 3.6 8 8 8l62.9 0-69.1 82.9c-2 2.4-2.4 5.7-1.1 8.5s4.1 4.6 7.2 4.6l80 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-62.9 0 69.1-82.9c2-2.4 2.4-5.7 1.1-8.5S475.1 32 472 32l-80 0c-4.4 0-8 3.6-8 8zM336 .5C330.7 .2 325.4 0 320 0 178.6 0 64 114.6 64 256S178.6 512 320 512 576 397.4 576 256c0-22.1-2.8-43.5-8.1-64l-16.6 0c5.6 20.4 8.6 41.8 8.6 64 0 132.5-107.5 240-240 240S80 388.5 80 256 187.5 16 320 16c5.4 0 10.7 .2 16 .5l0-16zM320 416a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm-48-32a48 48 0 1 0 96 0 48 48 0 1 0 -96 0zM408 272c-22.1 0-40-17.9-40-40 0-4.4-3.6-8-8-8s-8 3.6-8 8c0 30.9 25.1 56 56 56l16 0c30.9 0 56-25.1 56-56 0-4.4-3.6-8-8-8s-8 3.6-8 8c0 22.1-17.9 40-40 40l-16 0zM176 232c0-4.4-3.6-8-8-8s-8 3.6-8 8c0 30.9 25.1 56 56 56l16 0c30.9 0 56-25.1 56-56 0-4.4-3.6-8-8-8s-8 3.6-8 8c0 22.1-17.9 40-40 40l-16 0c-22.1 0-40-17.9-40-40z"]],
    "jedi": [576, 512, [], "f669", ["M32 235.4c0 1.5 0 3.1 0 4.6 0 141.4 114.6 256 256 256S544 381.4 544 240c0-1.6 0-3.1 0-4.6l-58.3 58.3c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l64-64 4.4-4.4c-2.1-20.8-6.7-40.9-13.5-59.9l-75.6 75.6c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l80-80 .5-.5c-18.4-42.2-47.8-78.5-84.7-105.2 6.4 17.3 9.8 35.9 9.8 55.4 0 57.3-30.2 107.6-75.5 135.9 26.6 23.4 43.5 57.8 43.5 96.1 0 70.7-57.3 128-128 128S160 390.7 160 320c0-38.3 16.8-72.7 43.5-96.1-45.3-28.2-75.5-78.5-75.5-135.9 0-19.5 3.5-38.1 9.8-55.4-36.8 26.7-66.3 63-84.7 105.2l.5 .5 80 80c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L46.8 154.1c-6.8 19-11.4 39.1-13.5 59.9l4.4 4.4 64 64c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L32 235.4z", "M288 0c4.4 0 8 3.6 8 8l0 300.7 42.9-42.9c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3L307.3 320 368 320c4.4 0 8 3.6 8 8s-3.6 8-8 8l-60.7 0 42.9 42.9c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-42.9-42.9 0 84.4c58.1-4.1 104-52.6 104-111.7 0-37.3-18.2-70.4-46.3-90.7-2.2-1.6-3.5-4.3-3.3-7.1s1.8-5.2 4.3-6.5c46-24.1 77.4-72.2 77.4-127.7 0-26.8-7.3-51.8-20-73.2-1.8-3.1-1.4-7.1 1.2-9.7s6.5-3.1 9.7-1.3C504.8 50.6 560 138.8 560 240 560 390.2 438.2 512 288 512S16 390.2 16 240c0-101.2 55.2-189.4 137.1-236.3 3.2-1.8 7.1-1.3 9.7 1.3s3 6.6 1.2 9.7c-12.7 21.5-20 46.5-20 73.2 0 55.5 31.4 103.6 77.4 127.7 2.5 1.3 4.1 3.7 4.3 6.5s-1 5.4-3.3 7.1c-28.1 20.4-46.3 53.4-46.3 90.7 0 59.2 45.9 107.6 104 111.7l0-84.4-42.9 42.9c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l42.9-42.9-60.7 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l60.7 0-42.9-42.9c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0L280 308.7 280 8c0-4.4 3.6-8 8-8zM160 320c0-38.3 16.8-72.7 43.5-96.1-45.3-28.2-75.5-78.5-75.5-135.9 0-19.5 3.5-38.1 9.8-55.4-36.8 26.7-66.3 63-84.7 105.2l.5 .5 80 80c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L46.8 154.1c-6.8 19-11.4 39.1-13.5 59.9l4.4 4.4 64 64c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L32 235.4c0 1.5 0 3.1 0 4.6 0 141.4 114.6 256 256 256S544 381.4 544 240c0-1.6 0-3.1 0-4.6l-58.3 58.3c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l64-64 4.4-4.4c-2.1-20.8-6.7-40.9-13.5-59.9l-75.6 75.6c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l80-80 .5-.5c-18.4-42.2-47.8-78.5-84.7-105.2 6.4 17.3 9.8 35.9 9.8 55.4 0 57.3-30.2 107.6-75.5 135.9 26.6 23.4 43.5 57.8 43.5 96.1 0 70.7-57.3 128-128 128S160 390.7 160 320z"]],
    "police-box": [384, 512, [], "e021", ["M48 96l0 400 288 0 0-400c0-8.8-7.2-16-16-16s-16-7.2-16-16-7.2-16-16-16L96 48c-8.8 0-16 7.2-16 16s-7.2 16-16 16-16 7.2-16 16zm48 56c0-13.3 10.7-24 24-24l32 0c13.3 0 24 10.7 24 24l0 32c0 13.3-10.7 24-24 24l-32 0c-13.3 0-24-10.7-24-24l0-32zm0 112c0-13.3 10.7-24 24-24l32 0c13.3 0 24 10.7 24 24l0 32c0 13.3-10.7 24-24 24l-32 0c-13.3 0-24-10.7-24-24l0-32zM208 152c0-13.3 10.7-24 24-24l32 0c13.3 0 24 10.7 24 24l0 32c0 13.3-10.7 24-24 24l-32 0c-13.3 0-24-10.7-24-24l0-32z", "M200 8c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 24-88 0c-17.7 0-32 14.3-32 32-17.7 0-32 14.3-32 32l0 400-24 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l368 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-24 0 0-400c0-17.7-14.3-32-32-32 0-17.7-14.3-32-32-32l-88 0 0-24zM320 80c8.8 0 16 7.2 16 16l0 400-288 0 0-400c0-8.8 7.2-16 16-16s16-7.2 16-16 7.2-16 16-16l192 0c8.8 0 16 7.2 16 16s7.2 16 16 16zM120 240c-13.3 0-24 10.7-24 24l0 32c0 13.3 10.7 24 24 24l32 0c13.3 0 24-10.7 24-24l0-32c0-13.3-10.7-24-24-24l-32 0zm-8 24c0-4.4 3.6-8 8-8l32 0c4.4 0 8 3.6 8 8l0 32c0 4.4-3.6 8-8 8l-32 0c-4.4 0-8-3.6-8-8l0-32zM96 152l0 32c0 13.3 10.7 24 24 24l32 0c13.3 0 24-10.7 24-24l0-32c0-13.3-10.7-24-24-24l-32 0c-13.3 0-24 10.7-24 24zm24-8l32 0c4.4 0 8 3.6 8 8l0 32c0 4.4-3.6 8-8 8l-32 0c-4.4 0-8-3.6-8-8l0-32c0-4.4 3.6-8 8-8zm112-16c-13.3 0-24 10.7-24 24l0 32c0 13.3 10.7 24 24 24l32 0c13.3 0 24-10.7 24-24l0-32c0-13.3-10.7-24-24-24l-32 0zm-8 24c0-4.4 3.6-8 8-8l32 0c4.4 0 8 3.6 8 8l0 32c0 4.4-3.6 8-8 8l-32 0c-4.4 0-8-3.6-8-8l0-32z"]],
    "dog-leashed": [576, 512, [129454], "f6d4", ["M80 176l0 296c0 13.3 10.7 24 24 24l32 0c13.3 0 24-10.7 24-24l0-128c0-2.6 1.3-5.1 3.5-6.6s5-1.8 7.5-.8l32.5 13c21.9 8.8 45.7 10.8 68.6 6.1l0-179.7-192 0zm208 0l0 175.3c1.5-.5 3.1-1.1 4.6-1.7l32.5-13c2.5-1 5.3-.7 7.5 .8s3.5 4 3.5 6.6l0 128c0 13.3 10.7 24 24 24l32 0c13.3 0 24-10.7 24-24l0-243.1-105.9-52.9-22.1 0zm33.3-12.3l97.4 48.7 13.6-54.3 1.1-2.4c1.4-2.2 3.9-3.6 6.7-3.6l48 0c39.8 0 72-32.2 72-72l0-24c0-4.4-3.6-8-8-8l-56 0c-2.1 0-4.2-.8-5.7-2.3L477.1 32.4C466.6 21.9 452.3 16 437.5 16l-79.3 0-37 147.7zM448 64a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M361.9-31.8c3.7 .9 6.2 4.4 6.1 8.1l-.2 1.6-5.5 22.1 75.3 0c19.1 0 37.4 7.6 50.9 21.1L499.3 32 552 32c13.2 0 24 10.8 24 24l0 24c0 48.6-39.4 88-88 88l-41.8 0-14.2 56.9 0 247.1c0 22.1-17.9 40-40 40l-32 0c-22.1 0-40-17.9-40-40l0-116.2-21.5 8.6c-30.4 12.2-64.1 12.9-94.9 2.3l-6.1-2.3-21.5-8.6 0 116.2c0 22.1-17.9 40-40 40l-32 0c-22.1 0-40-17.9-40-40l0-296.5c-36-4-64-34.5-64-71.5 0-4.4 3.6-8 8-8s8 3.6 8 8c0 29 22 52.9 50.3 55.7l5.7 .3 188.7 0-162.1-146-1.1-1.2c-2.2-3-2.1-7.2 .5-10.1 2.6-2.9 6.8-3.5 10-1.6l1.3 1 175.2 157.9 21.2 0 46.5-185.9 .5-1.5c1.6-3.3 5.4-5.2 9.2-4.3zM80 472c0 13.3 10.7 24 24 24l32 0c13.3 0 24-10.7 24-24l0-128c0-2.6 1.3-5.1 3.5-6.6s5-1.8 7.5-.8l32.5 13c21.9 8.8 45.7 10.8 68.6 6.1l0-179.7-192 0 0 296zM288 351.2c1.5-.5 3.1-1.1 4.6-1.7l32.5-13c2.5-1 5.3-.7 7.5 .8s3.5 4 3.5 6.6l0 128c0 13.3 10.7 24 24 24l32 0c13.3 0 24-10.7 24-24l0-243.1-105.9-52.9-22.1 0 0 175.3zm33.3-187.6l97.4 48.7 13.6-54.3 1.1-2.4c1.4-2.2 3.9-3.6 6.7-3.6l48 0c39.8 0 72-32.2 72-72l0-24c0-4.4-3.6-8-8-8l-56 0c-2.1 0-4.2-.8-5.7-2.3L477.1 32.4C466.6 21.9 452.3 16 437.5 16l-79.3 0-37 147.7zM432 80a16 16 0 1 1 0-32 16 16 0 1 1 0 32z"]],
    "person-hiking": [448, 512, ["hiking"], "f6ec", ["M16 160l0 96c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-128c0-8.8-7.2-16-16-16-26.5 0-48 21.5-48 48zM51.7 501.8c-5.7 6.8-4.7 16.9 2 22.5s16.9 4.7 22.5-2l72.3-86.7c6.4-7.7 11.3-16.5 14.4-25.9l2.1-6.4c-8.7-7.5-17.5-15-26.2-22.5l-6.3 18.8c-1.9 5.7-4.8 11-8.7 15.5L51.7 501.8zM144 173.6l0 101c0 23.4 10.2 45.5 27.9 60.7l71.4 61.2c8.8 7.6 14.6 18.1 16.3 29.7l12.6 88.1c1.3 8.7 9.4 14.8 18.1 13.6s14.8-9.4 13.6-18.1l-12.6-88.1c-2.7-19.2-12.4-36.8-27.1-49.4l-34.5-29.6c-3.5-3-5.6-7.5-5.6-12.1l0-109.2c0-6.5 3.9-12.3 9.9-14.8s12.9-1.1 17.4 3.5l6.6 6.6c15 15 35.4 23.4 56.6 23.4l37.5 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-37.5 0c-12.7 0-24.9-5.1-33.9-14.1l-48.2-48.2c-11.3-11.3-26.7-17.7-42.7-17.7-25.2 0-45.6 20.4-45.6 45.6zM152 24a40 40 0 1 0 80 0 40 40 0 1 0 -80 0z", "M233.9 206.5c6-2.5 12.9-1.1 17.4 3.5l6.6 6.6c15 15 35.4 23.4 56.6 23.4l37.5 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-37.5 0c-12.7 0-24.9-5.1-33.9-14.1l-48.2-48.2c-11.3-11.3-26.7-17.7-42.7-17.7-25.2 0-45.6 20.4-45.6 45.6l0 101c0 23.4 10.2 45.5 27.9 60.7l71.4 61.2c8.8 7.6 14.6 18.1 16.3 29.7l12.6 88.1c1.3 8.7 9.4 14.8 18.1 13.6s14.8-9.4 13.6-18.1l-12.6-88.1c-2.7-19.2-12.4-36.8-27.1-49.4l-34.5-29.6c-3.5-3-5.6-7.5-5.6-12.1l0-109.2c0-6.5 3.9-12.3 9.9-14.8zM352 192c5.8 0 11.3 1.6 16 4.3l0-92.3c0-4.4 3.6-8 8-8s8 3.6 8 8l0 432c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-284.3c-4.7 2.7-10.2 4.3-16 4.3l-37.5 0c-21.3 0-41.8-7.1-58.5-19.9-3.3-2.5-6.4-5.3-9.4-8.2l-6.6-6.6 0 109.2 34.5 29.6c17.7 15.2 29.3 36.2 32.6 59.3l12.6 88.1c2.5 17.5-9.7 33.7-27.2 36.2s-33.7-9.7-36.2-27.2l-12.6-88.1c-1.1-7.7-5-14.7-10.9-19.8l-71.4-61.2c-21.3-18.2-33.5-44.9-33.5-72.9l0-101c0-34 27.6-61.6 61.6-61.6 20.3 0 39.7 8.1 54 22.4l48.2 48.2c6 6 14.1 9.4 22.6 9.4l37.5 0zM192 64a40 40 0 1 0 0-80 40 40 0 1 0 0 80zM64 112c-26.5 0-48 21.5-48 48l0 96c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-128c0-8.8-7.2-16-16-16zM192-32a56 56 0 1 1 0 112 56 56 0 1 1 0-112zM0 160c0-35.3 28.7-64 64-64 17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-96zM117.5 394.4l8.5-25.6c3 3.1 6.2 6.1 9.5 9l3.4 2.9-6.2 18.7c-1.9 5.7-4.8 11-8.7 15.5L51.7 501.8c-5.7 6.8-4.7 16.9 2 22.5s16.9 4.7 22.5-2l72.3-86.7c6.4-7.7 11.3-16.5 14.4-25.9l2.1-6.4 13.1 11.2-.1 .2c-3.8 11.4-9.7 21.9-17.3 31.1L88.6 532.5c-11.3 13.6-31.5 15.4-45.1 4.1s-15.4-31.5-4.1-45.1l72.3-86.7c2.6-3.1 4.5-6.6 5.8-10.4z"]],
    "arrows-up-to-line": [448, 512, [], "e4c2", ["", "M8 0C3.6 0 0 3.6 0 8s3.6 8 8 8l432 0c4.4 0 8-3.6 8-8s-3.6-8-8-8L8 0zm93.7 98.3c-3.1-3.1-8.2-3.1-11.3 0l-88 88c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L88 123.3 88 504c0 4.4 3.6 8 8 8s8-3.6 8-8l0-380.7 74.3 74.3c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-88-88zm256 0c-3.1-3.1-8.2-3.1-11.3 0l-88 88c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L344 123.3 344 504c0 4.4 3.6 8 8 8s8-3.6 8-8l0-380.7 74.3 74.3c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-88-88z"]],
    "pen-line": [576, 512, [], "e212", ["M16.3 485.9c-.8 2.8 0 5.8 2.1 7.8s5 2.8 7.8 2.1l127.8-35.5c12-3.3 22.9-9.7 31.6-18.5L404 223.3 288.7 108 70.2 326.4c-8.8 8.8-15.1 19.7-18.5 31.6L16.3 485.9z", "M404 16c-14.9 0-29.2 5.9-39.8 16.5L300 96.7 415.3 212 479.5 147.8C490.1 137.2 496 122.9 496 108s-5.9-29.2-16.5-39.8L443.8 32.5C433.2 21.9 418.9 16 404 16zM70.2 326.4c-8.8 8.8-15.1 19.7-18.5 31.6L16.3 485.9c-.8 2.8 0 5.8 2.1 7.8s5 2.8 7.8 2.1l127.8-35.5c12-3.3 22.9-9.7 31.6-18.5L404 223.3 288.7 108 70.2 326.4zM352.9 21.2C366.4 7.6 384.8 0 404 0s37.6 7.6 51.1 21.2l35.7 35.7C504.4 70.4 512 88.8 512 108s-7.6 37.6-21.2 51.1l-294 294c-10.7 10.7-24.1 18.5-38.7 22.6L30.4 511.1c-8.3 2.3-17.3 0-23.4-6.2s-8.5-15.1-6.2-23.4L36.4 353.8c4.1-14.6 11.8-27.9 22.6-38.7l294-294zM264 496l304 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-304 0c-4.4 0-8-3.6-8-8s3.6-8 8-8z"]],
    "badge-percent": [512, 512, [], "f646", ["M16 256c0 32.6 18.3 60.9 45.2 75.2 3.4 1.8 5 5.8 3.9 9.4-8.9 29.1-1.9 62.1 21.1 85.1s56 30.1 85.1 21.1c3.7-1.1 7.6 .5 9.4 3.9 14.3 26.9 42.6 45.2 75.2 45.2s60.9-18.3 75.2-45.2c1.8-3.4 5.8-5 9.4-3.9 29.1 8.9 62.1 1.9 85.1-21.1s30.1-56 21.1-85.1c-1.1-3.7 .5-7.6 3.9-9.4 26.9-14.3 45.2-42.6 45.2-75.2s-18.3-60.9-45.2-75.2c-3.4-1.8-5-5.7-3.9-9.4 8.9-29.1 1.9-62.1-21.1-85.1s-56-30.1-85.1-21.1c-3.7 1.1-7.6-.5-9.4-3.9-14.3-26.9-42.6-45.2-75.2-45.2s-60.9 18.3-75.2 45.2c-1.8 3.4-5.7 5-9.4 3.9-29.1-8.9-62.1-1.9-85.1 21.1s-30.1 56-21.1 85.1c1.1 3.7-.5 7.6-3.9 9.4-26.9 14.3-45.2 42.6-45.2 75.2zm208-64a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM170.3 330.3l160-160c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3l-160 160c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3zM352 320a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M180.8 61.2C195.1 34.3 223.4 16 256 16s60.9 18.3 75.2 45.2c1.8 3.4 5.7 5 9.4 3.9 29.1-8.9 62.1-1.9 85.1 21.1s30.1 56 21.1 85.1c-1.1 3.7 .5 7.6 3.9 9.4 26.9 14.3 45.2 42.6 45.2 75.2s-18.3 60.9-45.2 75.2c-3.4 1.8-5 5.8-3.9 9.4 8.9 29.1 1.9 62.1-21.1 85.1s-56 30.1-85.1 21.1c-3.7-1.1-7.6 .5-9.4 3.9-14.3 26.9-42.6 45.2-75.2 45.2s-60.9-18.3-75.2-45.2c-1.8-3.4-5.7-5-9.4-3.9-29.1 8.9-62.1 1.9-85.1-21.1s-30.1-56-21.1-85.1c1.1-3.7-.5-7.6-3.9-9.4-26.9-14.3-45.2-42.6-45.2-75.2s18.3-60.9 45.2-75.2c3.4-1.8 5-5.7 3.9-9.4-8.9-29.1-1.9-62.1 21.1-85.1s56-30.1 85.1-21.1c3.7 1.1 7.6-.5 9.4-3.9zM256 0c-36.4 0-68.3 19.3-86.1 48.2-33-7.9-69.2 1.1-94.9 26.8s-34.7 61.9-26.8 94.9C19.3 187.7 0 219.6 0 256s19.3 68.3 48.2 86.1c-7.9 33 1.1 69.2 26.8 94.9s61.9 34.7 94.9 26.8C187.7 492.7 219.6 512 256 512s68.3-19.3 86.1-48.2c33 7.9 69.2-1.1 94.9-26.8s34.7-61.9 26.8-94.9C492.7 324.3 512 292.4 512 256s-19.3-68.3-48.2-86.1c7.9-33-1.1-69.2-26.8-94.9s-62-34.7-94.9-26.8C324.3 19.3 292.4 0 256 0zM176 192a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm48 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm80 128a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm48 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM341.7 170.3c-3.1-3.1-8.2-3.1-11.3 0l-160 160c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l160-160c3.1-3.1 3.1-8.2 0-11.3z"]],
    "mars-double": [640, 512, [9891], "f227", ["M16 304a160 160 0 1 0 320 0 160 160 0 1 0 -320 0zM336 460.8c50.8 10.3 105.7-4.2 145.1-43.6 57.3-57.3 62.1-147.3 14.2-210-9.1 21.6-30.4 36.9-55.4 36.9-17.8 0-33.7-7.7-44.7-20l-10 0c9.5 24.8 14.7 51.8 14.7 80 0 61-24.4 116.4-64 156.8z", "M481.1 417.1c57.3-57.3 62.1-147.3 14.2-210 2.6-6.1 4.1-12.7 4.5-19.7 61.2 69.1 58.7 174.8-7.5 241-46.2 46.2-111.6 61.3-170.5 45.5 4.9-4.2 9.5-8.6 14-13.1 50.8 10.3 105.7-4.2 145.1-43.6zM624 59.3l-124 124 0-22.6 112.7-112.7-112.7 0 0-8c0-2.7-.2-5.4-.5-8L632 32c2.1 0 4.2 .8 5.7 2.3S640 37.9 640 40l0 144c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-124.7zM296 48c-4.4 0-8-3.6-8-8s3.6-8 8-8l144 0c4.4 0 8 3.6 8 8l0 144c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-124.7-126 126c28.6 31.3 46 72.9 46 118.7 0 97.2-78.8 176-176 176S0 401.2 0 304 78.8 128 176 128c45.7 0 87.4 17.4 118.7 46L420.7 48 296 48zM176 464a160 160 0 1 0 0-320 160 160 0 1 0 0 320z"]],
    "thermometer": [512, 512, [], "f491", ["M112 299.9l0 100.1 100.1 0c10.6 0 20.8-4.2 28.3-11.7L471.8 156.9c15.5-15.5 24.2-36.5 24.2-58.3 0-45.6-36.9-82.5-82.5-82.5-21.9 0-42.9 8.7-58.3 24.2L315.3 80 365.7 130.3c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L304 91.3 251.3 144 301.7 194.3c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-50.3-50.3-52.7 52.7 50.3 50.3c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-50.3-50.3-52.3 52.3c-7.5 7.5-11.7 17.7-11.7 28.3z", "M355.1 40.2c15.5-15.5 36.5-24.2 58.3-24.2 45.6 0 82.5 36.9 82.5 82.5 0 21.9-8.7 42.9-24.2 58.3L240.4 388.3c-7.5 7.5-17.7 11.7-28.3 11.7l-100.1 0 0-100.1c0-10.6 4.2-20.8 11.7-28.3l52.3-52.3 50.3 50.3c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-50.3-50.3 52.7-52.7 50.3 50.3c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3L251.3 144 304 91.3 354.3 141.7c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3L315.3 80 355.1 40.2zM96 299.9l0 104.8-93.7 93.7c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l93.7-93.7 104.8 0c14.9 0 29.1-5.9 39.6-16.4L483.1 168.2c18.5-18.5 28.9-43.5 28.9-69.7 0-54.4-44.1-98.5-98.5-98.5-26.1 0-51.2 10.4-69.7 28.9L112.4 260.3C101.9 270.8 96 285 96 299.9z"]],
    "paintbrush": [576, 512, [128396, "paint-brush"], "f1fc", ["M208 265.9l0 26.8c36.1 10.8 64.6 39.2 75.4 75.4l26.8 0c.3 0 .5 0 .8 0 28.4-.3 54.9-14.2 71.2-37.4l169.4-241c5.5-7.9 8.5-17.2 8.5-26.9 0-25.8-20.9-46.7-46.7-46.7-9.6 0-19 3-26.9 8.5l-241 169.4c-23.4 16.5-37.4 43.3-37.4 72z", "M513.3 0c-12.9 0-25.5 4-36.1 11.4l-241 169.4C208.5 200.3 192 232 192 265.9l0 23.3c-5.2-.7-10.6-1.1-16-1.1-61.9 0-112 50.1-112 112 0 3.9 .2 7.8 .6 11.6 1.8 17.5-10.2 36.4-27.8 36.4L32 448c-17.7 0-32 14.3-32 32s14.3 32 32 32l144 0c61.9 0 112-50.1 112-112 0-5.4-.4-10.8-1.1-16l23.3 0c33.9 0 65.6-16.5 85.1-44.2l169.4-241C572 88.2 576 75.6 576 62.7 576 28.1 547.9 0 513.3 0zM283.4 368c-10.8-36.1-39.2-64.6-75.4-75.4l0-26.8c0-28.7 14-55.5 37.4-72l241-169.4c7.9-5.5 17.2-8.5 26.9-8.5 25.8 0 46.7 20.9 46.7 46.7 0 9.6-3 19-8.5 26.9l-169.4 241c-16.5 23.4-43.3 37.4-72 37.4l-26.8 0zM272 400c0 53-43 96-96 96L32 496c-8.8 0-16-7.2-16-16s7.2-16 16-16l4.8 0c15 0 26.9-8.1 34.2-18.3 7.2-10 10.8-23 9.5-35.8-.3-3.3-.5-6.6-.5-10 0-53 43-96 96-96s96 43 96 96z"]],
    "signal-stream": [576, 512, [], "f8dd", ["M256 256a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M89.7 58.2c3.2 3 3.4 8.1 .3 11.3-45.9 48.7-74 114.3-74 186.5S44.1 393.8 90 442.5c3 3.2 2.9 8.3-.3 11.3s-8.3 2.9-11.3-.3C29.8 401.9 0 332.4 0 256S29.8 110.1 78.4 58.5c3-3.2 8.1-3.4 11.3-.3zm396.6 0c3.2-3 8.3-2.9 11.3 .3 48.6 51.6 78.4 121 78.4 197.5s-29.8 145.9-78.4 197.5c-3 3.2-8.1 3.4-11.3 .3s-3.4-8.1-.3-11.3c45.9-48.7 74-114.3 74-186.5S531.9 118.2 486 69.5c-3-3.2-2.9-8.3 .3-11.3zM240 256a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm48 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM176.1 141.7C146.4 170.7 128 211.2 128 256s18.4 85.3 48.1 114.3c3.2 3.1 3.2 8.2 .1 11.3s-8.2 3.2-11.3 .1C132.3 349.8 112 305.3 112 256s20.3-93.8 52.9-125.8c3.2-3.1 8.2-3 11.3 .1s3 8.2-.1 11.3zm235-11.4C443.7 162.2 464 206.7 464 256s-20.3 93.8-52.9 125.8c-3.2 3.1-8.2 3-11.3-.1s-3-8.2 .1-11.3C429.6 341.3 448 300.8 448 256s-18.4-85.3-48.1-114.3c-3.2-3.1-3.2-8.2-.1-11.3s8.2-3.2 11.3-.1z"]],
    "square-p": [448, 512, [], "e279", ["M16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96zm144 72c0-4.4 3.6-8 8-8l68 0c37.6 0 68 30.4 68 68s-30.4 68-68 68l-60 0 0 48c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-176zm16 8l0 104 60 0c28.7 0 52-23.3 52-52s-23.3-52-52-52l-60 0z", "M64 48C37.5 48 16 69.5 16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm168 64l68 0c37.6 0 68 30.4 68 68s-30.4 68-68 68l-60 0 0 48c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-176c0-4.4 3.6-8 8-8zm68 120c28.7 0 52-23.3 52-52s-23.3-52-52-52l-60 0 0 104 60 0z"]],
    "bee": [448, 512, [], "e0b2", ["M16 320l0 48 16 0c101.6 0 184-82.4 184-184l0-48-16 0C98.4 136 16 218.4 16 320zm124.5 32l167.1 0c-39.9-25.8-70-65.4-83.5-112-13.6 46.6-43.7 86.2-83.5 112zm12.7 80c26.5 29.5 54.5 53 66.6 62.6l1.9 1c.7 .2 1.5 .4 2.4 .4 1.8 0 3.2-.6 4.3-1.4L241.2 484c14.2-12.1 34.4-30.4 53.7-52l-141.8 0zM160 96l0 28c12.9-2.6 26.3-4 40-4l48 0c13.7 0 27.1 1.4 40 4l0-28c0-35.3-28.7-64-64-64s-64 28.7-64 64zm72 40l0 48c0 101.6 82.4 184 184 184l16 0 0-48c0-101.6-82.4-184-184-184l-16 0z", "M307.6 1.3c3.1-2 7.3-1.7 10.1 1s3.1 7 1 10.1l-1 1.2-31.8 31.7C297.2 59.2 304 76.8 304 96l0 32c83.2 24.2 144 101 144 192l0 56-.2 1.6c-.7 3.6-4 6.4-7.8 6.4l-24 0c-21.4 0-42-3.4-61.4-9.6-28.7 59.9-95.6 116.2-116.3 132.7l-3.2 2.1c-3.4 1.8-7.2 2.8-11.1 2.8s-7.7-.9-11.1-2.8l-3.2-2.1C188.9 490.6 122 434.3 93.3 374.4 74 380.6 53.4 384 32 384L8 384c-3.9 0-7.1-2.7-7.8-6.4L0 376 0 320c0-91 60.8-167.8 144-192l0-32c0-19.2 6.8-36.8 18.1-50.6l-31.7-31.7-1-1.2c-2-3.1-1.7-7.3 1-10.1s7-3.1 10.1-1l1.2 1 31.7 31.7C187.2 22.8 204.8 16 224 16s36.8 6.8 50.6 18.1l31.7-31.7 1.3-1zM153.1 432c26.5 29.5 54.5 53 66.6 62.6l1.9 1c.7 .2 1.5 .4 2.4 .4 1.8 0 3.2-.6 4.3-1.4L241.2 484c14.2-12.1 34.4-30.4 53.7-52l-141.8 0zm-42.7-64c-.7 .3-1.4 .5-2 .8 7.7 15.7 18.6 31.7 31.1 47.2l169 0c12.5-15.5 23.3-31.5 31-47.2-.7-.3-1.3-.5-2-.8l-227.1 0zM200 136C98.4 136 16 218.4 16 320l0 48 16 0c101.6 0 184-82.4 184-184l0-48-16 0zm32 48c0 101.6 82.4 184 184 184l16 0 0-48c0-101.6-82.4-184-184-184l-16 0 0 48zm-8 56c-13.6 46.6-43.7 86.2-83.5 112l167.1 0c-39.9-25.8-70-65.4-83.5-112zm0-208c-35.3 0-64 28.7-64 64l0 28c12.9-2.6 26.3-4 40-4l48 0c13.7 0 27.1 1.4 40 4l0-28c0-35.3-28.7-64-64-64z"]],
    "music-slash": [576, 512, [], "f8d1", ["M224 89.7l0 84.4 272-60.4 0-73.7c0-15.4-14.2-26.8-29.2-23.4l-224 49.8c-11 2.4-18.8 12.2-18.8 23.4zM347 303.6L440.4 397c32.3-8.2 55.6-32.4 55.6-61 0-35.3-35.8-64-80-64-29.4 0-55.1 12.7-69 31.6z", "M13.7-29.8c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l560 560c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3L453.2 409.8C487.7 397.7 512 369.2 512 336l0-296.1c0-25.6-23.7-44.6-48.7-39l-224 49.8C221 54.7 208 70.9 208 89.7l0 74.9-194.3-194.3zM232 188.6l264-58.7 0 161.8c-17.2-21.6-46.6-35.8-80-35.8-33.6 0-63.2 14.4-80.4 36.2L232 188.6zm115 115c13.9-18.9 39.6-31.6 69-31.6 44.2 0 80 28.7 80 64l0 0c0 28.5-23.4 52.7-55.6 61L347 303.6zM208 255.2l0 100.6c-17.2-21.6-46.6-35.8-80-35.8-53 0-96 35.8-96 80s43 80 96 80 96-35.8 96-80l0-128.8-16-16zM466.8 16.5c15-3.3 29.2 8.1 29.2 23.4l0 73.7-272 60.4 0-84.4c0-11.2 7.8-21 18.8-23.4l224-49.8zM208 400l0 0c0 35.3-35.8 64-80 64s-80-28.7-80-64 35.8-64 80-64 80 28.7 80 64z"]],
    "person-simple": [192, 512, [], "e220", ["M16 232c0-30.9 25.1-56 56-56l48 0c30.9 0 56 25.1 56 56l0 48c0 20.7-11.2 38.8-28 48.5-2.5 1.4-4 4.1-4 6.9L144 464c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-128.6c0-2.9-1.5-5.5-4-6.9-16.8-9.7-28-27.8-28-48.5l0-48zM144 64a48 48 0 1 1 -96 0 48 48 0 1 1 96 0z", "M48 64a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm112 0A64 64 0 1 0 32 64 64 64 0 1 0 160 64zM16 232c0-30.9 25.1-56 56-56l48 0c30.9 0 56 25.1 56 56l0 48c0 20.7-11.2 38.8-28 48.5-2.5 1.4-4 4.1-4 6.9L144 464c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-128.6c0-2.9-1.5-5.5-4-6.9-16.8-9.7-28-27.8-28-48.5l0-48zm56-72c-39.8 0-72 32.2-72 72l0 48c0 25 12.7 47 32 59.9L32 464c0 26.5 21.5 48 48 48l32 0c26.5 0 48-21.5 48-48l0-124.1C179.3 327 192 305 192 280l0-48c0-39.8-32.2-72-72-72l-48 0z"]],
    "album-collection-circle-user": [576, 512, [], "e48f", ["M32.7 212c-1.1-9.1 1.7-18.3 7.8-25.1S55.3 176 64.5 176l384 0c9.2 0 17.9 3.9 24 10.8s8.9 16 7.8 25.1l-.2 2c-15.2-3.9-31.1-5.9-47.5-5.9-39.1 0-75.5 11.7-105.8 31.8-20.5-10-44.5-15.8-70.2-15.8-75.7 0-137.1 50.1-137.1 112 0 59.1 56.1 107.5 127.1 111.7 4.4 17.1 11.1 33.4 19.7 48.3L96.5 496c-16.1 0-29.8-12-31.8-28l-32-256z", "M128.5 8c0 4.4 3.6 8 8 8l240 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-240 0c-4.4 0-8 3.6-8 8zm-48 80c0 4.4 3.6 8 8 8l336 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-336 0c-4.4 0-8 3.6-8 8zm-40 98.8c6.1-6.9 14.8-10.8 24-10.8l384 0c9.2 0 17.9 3.9 24 10.8l0 0c6.1 6.9 8.9 16 7.8 25.1l-.2 2c5.3 1.3 10.5 2.9 15.5 4.7l.6-4.6c1.7-13.7-2.5-27.4-11.6-37.7s-22.2-16.2-36-16.2l-384 0c-13.8 0-26.9 5.9-36 16.2S15.2 200.3 16.9 214l32 256c3 24 23.4 42 47.6 42l180 0c-3.7-5.1-7.2-10.5-10.3-16L96.5 496c-16.1 0-29.8-12-31.8-28l-32-256c-1.1-9.1 1.7-18.3 7.8-25.1zm216 37.2c-75.7 0-137.1 50.1-137.1 112 0 59.1 56.1 107.5 127.1 111.7-1.4-5.3-2.5-10.8-3.4-16.3-63.1-5.4-107.7-48.6-107.7-95.4 0-50.1 51.1-96 121.1-96 20.3 0 39.1 3.9 55.4 10.6 4.7-3.8 9.7-7.4 14.8-10.8-20.5-10-44.5-15.8-70.2-15.8zm0 80c-19.1 0-37.4 12.9-37.4 32 0 14.7 10.8 25.6 24.4 30 .9-5.3 2.1-10.5 3.5-15.6-7.6-2.9-11.9-8.9-11.9-14.3 0-7.4 8-16 21.4-16 .5 0 .9 0 1.4 0 2.4-5.1 4.9-10.2 7.7-15-3-.6-6-1-9.1-1zM507 495l3.3 6.6c-21.6 16.6-48.6 26.4-77.9 26.4s-56.3-9.8-77.9-26.4L358 495c9.5-19 28.9-31 50.1-31l48.9 0c21.2 0 40.6 12 50.1 31zm15.8-4.2l-1.5-2.9c-12.2-24.4-37.1-39.8-64.4-39.8L408 448c-27.3 0-52.2 15.4-64.4 39.8l-1.5 2.9c-23.3-23.2-37.7-55.3-37.7-90.7 0-70.7 57.3-128 128-128s128 57.3 128 128c0 35.5-14.4 67.5-37.7 90.7zM576.5 400a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-144-64a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm0 80a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"]],
    "whale": [640, 512, [128011], "f72c", ["M16 317.6C16 398.5 81.5 464 162.4 464L544 464c44.2 0 80-35.8 80-80l0-111.9c0-70.7-57.3-128.1-128.1-128.1-78.7 0-154.9 28.2-214.6 79.4L166.8 321.6C155.9 330.9 142 336 127.7 336l-1.1 0c-25.2 0-47.5-16.1-55.5-40-5.5-16.5-3.4-34.7 5.9-49.5l37.6-60.1c3.4-5.5 9.8-8.4 16.2-7.3l44.7 7.5c20.4 3.4 41.2-3.3 55.8-17.9L272 128 187.3 113.9c-6.7-1.1-12-6.4-13.2-13.2L160 16 119.3 56.7C104.7 71.3 98 92.1 101.4 112.5l7.9 47.4c.8 5.1-.8 10.3-4.5 13.9L54.9 223.7C30 248.6 16 282.4 16 317.6zM416 304a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M174.1 100.7L160 16 119.3 56.7C104.7 71.3 98 92.1 101.4 112.5l7.9 47.4c.8 5.1-.8 10.3-4.5 13.9L54.9 223.7C30 248.6 16 282.4 16 317.6 16 398.5 81.5 464 162.4 464L544 464c44.2 0 80-35.8 80-80l0-111.9c0-70.7-57.3-128.1-128.1-128.1-78.7 0-154.9 28.2-214.6 79.4L166.8 321.6C155.9 330.9 142 336 127.7 336l-1.1 0c-25.2 0-47.5-16.1-55.5-40-5.5-16.5-3.4-34.7 5.9-49.5l37.6-60.1c3.4-5.5 9.8-8.4 16.2-7.3l44.7 7.5c20.4 3.4 41.2-3.3 55.8-17.9L272 128 187.3 113.9c-6.7-1.1-12-6.4-13.2-13.2zm1.7-87.4l14.1 84.7 84.7 14.1c5.9 1 10.8 5.2 12.6 10.9s.3 12-3.9 16.2L242.6 180c-18.3 18.3-44.2 26.6-69.7 22.3l-44.7-7.5-37.6 60.1c-6.7 10.7-8.3 23.9-4.3 35.9 5.8 17.3 22 29 40.3 29l1.1 0c10.5 0 20.7-3.8 28.6-10.6l114.5-98.2c62.7-53.7 142.5-83.2 225-83.2 79.6 0 144.1 64.5 144.1 144.1L640 384c0 53-43 96-96 96l-381.6 0C72.7 480 0 407.3 0 317.6 0 278.2 15.7 240.3 43.6 212.4l49.9-49.9-7.9-47.4C81.4 89.6 89.7 63.7 108 45.4L148.7 4.7c4.2-4.2 10.5-5.8 16.2-3.9s9.9 6.7 10.9 12.6zM400 288a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"]],
    "arrow-up-triangle-square": [512, 512, ["sort-shapes-up"], "f88a", ["M288 198.9c0 5 4.1 9.1 9.1 9.1l173.9 0c5 0 9.1-4.1 9.1-9.1 0-1.6-.4-3.3-1.3-4.7L394.5 54c-2.2-3.7-6.2-6-10.5-6s-8.3 2.3-10.5 6L289.3 194.3c-.8 1.4-1.3 3-1.3 4.7zM304 336l0 96c0 17.7 14.3 32 32 32l96 0c17.7 0 32-14.3 32-32l0-96c0-17.7-14.3-32-32-32l-96 0c-17.7 0-32 14.3-32 32z", "M133.7 34.3c-3.1-3.1-8.2-3.1-11.3 0l-104 104c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L120 59.3 120 472c0 4.4 3.6 8 8 8s8-3.6 8-8l0-412.7 90.3 90.3c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-104-104zM384 32c-9.9 0-19.1 5.2-24.2 13.7L275.6 186c-2.3 3.9-3.6 8.4-3.6 12.9 0 13.8 11.2 25.1 25.1 25.1l173.9 0c13.8 0 25.1-11.2 25.1-25.1 0-4.5-1.2-9-3.6-12.9L408.2 45.7C403.1 37.2 393.9 32 384 32zM304 432l0-96c0-17.7 14.3-32 32-32l96 0c17.7 0 32 14.3 32 32l0 96c0 17.7-14.3 32-32 32l-96 0c-17.7 0-32-14.3-32-32zM289.3 194.3L373.5 54c2.2-3.7 6.2-6 10.5-6s8.3 2.3 10.5 6l84.2 140.3c.8 1.4 1.3 3 1.3 4.7 0 5-4.1 9.1-9.1 9.1l-173.9 0c-5 0-9.1-4.1-9.1-9.1 0-1.6 .4-3.3 1.3-4.7zM288 432c0 26.5 21.5 48 48 48l96 0c26.5 0 48-21.5 48-48l0-96c0-26.5-21.5-48-48-48l-96 0c-26.5 0-48 21.5-48 48l0 96z"]],
    "neuter": [384, 512, [9906], "f22c", ["M32 176a160 160 0 1 0 320 0 160 160 0 1 0 -320 0z", "M32 176a160 160 0 1 1 320 0 160 160 0 1 1 -320 0zM200 351.8c93.5-4.2 168-81.3 168-175.8 0-97.2-78.8-176-176-176S16 78.8 16 176c0 94.5 74.5 171.6 168 175.8L184 504c0 4.4 3.6 8 8 8s8-3.6 8-8l0-152.2z"]],
    "square-phone-flip": [448, 512, ["phone-square-alt"], "f87b", ["M16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96zM96.9 326.3c-3.3-12 2.9-24.5 14.3-29.3l46.6-19.4c10.1-4.2 21.7-1.3 28.6 7.1l7.3 8.9c28.8-15.4 52.3-39.6 66.6-69.1l-7.5-6.2c-8.4-6.9-11.3-18.5-7.1-28.6l19.4-46.6c4.8-11.4 17.3-17.6 29.3-14.3l3.3 .9c32.5 8.9 61.2 40.6 52.9 80.2-18 86.5-86.1 154.6-172.6 172.6-39.5 8.2-71.3-20.4-80.2-52.9l-.9-3.3z", "M64 48C37.5 48 16 69.5 16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm290.1 48.3c-4.2-1.1-8.6 1-10.3 5L260.4 196c-1.5 3.5-.5 7.6 2.5 10l12.4 10.1c2.8 2.3 3.7 6.1 2.3 9.4-16.5 37.3-45.8 67.6-82.5 85.4-3.3 1.6-7.3 .7-9.7-2.1L174 294.9c-2.4-3-6.5-4-10-2.5l-46.6 19.4c-4 1.7-6.2 6.1-5 10.3l.9 3.3c7.3 26.6 32.3 47.5 61.5 41.5 80.3-16.7 143.5-79.9 160.2-160.2 6.1-29.1-14.9-54.2-41.5-61.5l-3.3-.9zm-25-1.1c4.8-11.4 17.3-17.6 29.3-14.3l3.3 .9c32.5 8.9 61.2 40.6 52.9 80.2-18 86.5-86.1 154.6-172.6 172.6-39.5 8.2-71.3-20.4-80.2-52.9l-.9-3.3c-3.3-12 2.9-24.5 14.3-29.3l46.6-19.4c10.1-4.2 21.7-1.3 28.6 7.1l7.3 8.9c28.8-15.4 52.3-39.6 66.6-69.1l-7.5-6.2c-8.4-6.9-11.3-18.5-7.1-28.6l19.4-46.6z"]],
    "circle-g": [512, 512, [], "e10f", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zm136 0c0-57.4 46.6-104 104-104 26.6 0 50.9 10 69.3 26.5 3.3 2.9 3.6 8 .6 11.3s-8 3.6-11.3 .6c-15.6-13.9-36.1-22.4-58.7-22.4-48.6 0-88 39.4-88 88s39.4 88 88 88c45.9 0 83.6-35.1 87.7-80l-78.2 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l86.5 0c4.4 0 8 3.6 8 8 0 57.4-46.6 104-104 104S152 313.4 152 256z", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM168 256c0-48.6 39.4-88 88-88 22.5 0 43.1 8.5 58.7 22.4 3.3 2.9 8.3 2.7 11.3-.6s2.7-8.3-.6-11.3c-18.4-16.5-42.7-26.5-69.3-26.5-57.4 0-104 46.6-104 104s46.6 104 104 104 104-46.6 104-104c0-4.4-3.6-8-8-8l-86.5 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l78.2 0c-4 44.9-41.8 80-87.7 80-48.6 0-88-39.4-88-88z"]],
    "circle-down-right": [512, 512, [], "e108", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zm135-81l24-24c9.4-9.4 24.6-9.4 33.9 0l67 67 35-35c6.9-6.9 17.2-8.9 26.2-5.2S352 190.3 352 200l0 128c0 13.3-10.7 24-24 24l-128 0c-9.7 0-18.5-5.8-22.2-14.8s-1.7-19.3 5.2-26.2l35-35-67-67c-9.4-9.4-9.4-24.6 0-33.9z", "M256 496a240 240 0 1 1 0-480 240 240 0 1 1 0 480zM256 0a256 256 0 1 0 0 512 256 256 0 1 0 0-512zm80 328c0 4.4-3.6 8-8 8l-128 0c-3.2 0-6.2-1.9-7.4-4.9s-.6-6.4 1.7-8.7L235 281.7c3.1-3.1 3.1-8.2 0-11.3l-72.7-72.7c-3.1-3.1-3.1-8.2 0-11.3l24-24c3.1-3.1 8.2-3.1 11.3 0L270.3 235c3.1 3.1 8.2 3.1 11.3 0l40.7-40.7c2.3-2.3 5.7-3 8.7-1.7s4.9 4.2 4.9 7.4l0 128zm-8 24c13.3 0 24-10.7 24-24l0-128c0-9.7-5.8-18.5-14.8-22.2s-19.3-1.7-26.2 5.2l-35 35-67-67c-9.4-9.4-24.6-9.4-33.9 0l-24 24c-9.4 9.4-9.4 24.6 0 33.9l67 67-35 35c-6.9 6.9-8.9 17.2-5.2 26.2S190.3 352 200 352l128 0z"]],
    "people-dress": [576, 512, [], "e217", ["M40.5 304L82.5 183.1C94 150.1 125.1 128 160 128s66 22.1 77.5 55.1l42.1 120.9-26 0-29.9-98.3c-1.3-4.2-5.8-6.6-10-5.3s-6.6 5.8-5.3 10l49.7 163.3c1.6 5.1-2.3 10.3-7.7 10.3L69.6 384c-5.4 0-9.2-5.2-7.7-10.3l49.7-163.3c1.3-4.2-1.1-8.7-5.3-10s-8.7 1.1-10 5.3L66.4 304 40.5 304zM96 400l32 0 0 112c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-112zM200 24a40 40 0 1 1 -80 0 40 40 0 1 1 80 0zm-8 376l32 0 0 112c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-112zm104.5-96l42.1-120.9C350 150.1 381.1 128 416 128s66 22.1 77.5 55.1l42.1 120.9-26 0-29.9-98.3c-1.3-4.2-5.8-6.6-10-5.3s-6.6 5.8-5.3 10l49.7 163.3c1.6 5.1-2.3 10.3-7.7 10.3l-180.8 0c-5.4 0-9.2-5.2-7.7-10.3l49.7-163.3c1.3-4.2-1.1-8.7-5.3-10s-8.7 1.1-10 5.3l-29.9 98.3-25.9 0zM352 400l32 0 0 112c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-112zM456 24a40 40 0 1 1 -80 0 40 40 0 1 1 80 0zm-8 376l32 0 0 112c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-112z", "M416 64a40 40 0 1 0 0-80 40 40 0 1 0 0 80zm0-96a56 56 0 1 1 0 112 56 56 0 1 1 0-112zm32 432l0 112c0 8.8 7.2 16 16 16s16-7.2 16-16l0-112-32 0zm48 0l0 112c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-112-32 0 0 112c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-112-10.4 0c-16.1 0-27.7-15.6-23-31l49.7-163.3c1.3-4.2 5.8-6.6 10-5.3s6.6 5.8 5.3 10L317.9 373.7c-1.6 5.1 2.3 10.3 7.7 10.3l180.8 0c5.4 0 9.2-5.2 7.7-10.3L464.4 210.3c-1.3-4.2 1.1-8.7 5.3-10s8.7 1.1 10 5.3L529.4 369c4.7 15.4-6.8 31-23 31L496 400zm-112 0l-32 0 0 112c0 8.8 7.2 16 16 16s16-7.2 16-16l0-112zM136 384l114.4 0c5.4 0 9.2-5.2 7.7-10.3L208.3 210.3c-1.3-4.2 1.1-8.7 5.3-10s8.7 1.1 10 5.3L273.4 369c4.7 15.4-6.8 31-23 31l-10.4 0 0 112c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-112-32 0 0 112c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-112-10.4 0c-16.1 0-27.7-15.6-23-31L96.3 205.7c1.3-4.2 5.8-6.6 10-5.3s6.6 5.8 5.3 10L61.9 373.7c-1.6 5.1 2.3 10.3 7.7 10.3l66.4 0zm56 16l0 112c0 8.8 7.2 16 16 16s16-7.2 16-16l0-112-32 0zm-96 0l0 112c0 8.8 7.2 16 16 16s16-7.2 16-16l0-112-32 0zM160 64a40 40 0 1 0 0-80 40 40 0 1 0 0 80zm0-96a56 56 0 1 1 0 112 56 56 0 1 1 0-112zm0 160c-34.9 0-66 22.1-77.5 55.1l-43 123.6c-1.5 4.2-6 6.4-10.2 4.9s-6.4-6-4.9-10.2l43-123.6C81.1 138.4 118.3 112 160 112s78.9 26.4 92.6 65.8L288 279.7 323.4 177.8C337.1 138.4 374.3 112 416 112s78.9 26.4 92.6 65.8l43 123.6c1.5 4.2-.8 8.7-4.9 10.2s-8.7-.8-10.2-4.9l-43-123.6C482 150.1 450.9 128 416 128s-66 22.1-77.5 55.1l-43 123.6c-.5 1.5-1.5 2.8-2.6 3.7-.4 .3-.8 .6-1.3 .8-.9 .5-1.9 .8-3 .8-.4 0-.8 0-1.3 0-1.1-.1-2.1-.4-3-.8-.5-.2-.9-.5-1.3-.8-1.2-.9-2.1-2.2-2.6-3.7l-43-123.6C226 150.1 194.9 128 160 128z"]],
    "circle-half": [512, 512, [], "e110", ["M16 256c0 122.4 91.6 223.4 210 238.2 6.7 .8 14-4.7 14-14.2l0-448c0-9.4-7.3-15-14-14.1-118.4 14.7-210 115.8-210 238.1z", "M226 17.9C107.6 32.6 16 133.6 16 256s91.6 223.4 210 238.2c6.7 .8 14-4.7 14-14.2l0-448c0-9.4-7.3-15-14-14.1zM224.1 2C241.6-.2 256 14.3 256 32l0 448C256 497.7 241.6 512.2 224.1 510 97.8 494.3 0 386.6 0 256S97.8 17.7 224.1 2z"]],
    "face-grin-tongue-squint": [512, 512, [128541, "grin-tongue-squint"], "f58a", ["M16 256C16 123.5 123.5 16 256 16S496 123.5 496 256c0 92.9-52.8 173.5-130 213.4-1.4 7.2-3.5 14.1-6.1 20.7-31.5 14-66.3 21.8-102.9 21.9 39.3-.5 71.1-32.6 71.1-72l0-25.1c39.1-19.7 68.9-55 81.5-97.7 1.7-5.7-.3-10.8-4.1-14.2L408 296c-3 1.3-5.9 2.6-8.8 3.8-3-.8-6.4-.8-9.7 .2-39.9 12.8-85.3 20-133.5 20s-93.6-7.2-133.5-20c-3.3-1.1-6.7-1.1-9.7-.2-3.1-1.3-6-2.6-8.8-3.8l2.4 7.2c-3.7 3.3-5.6 8.4-4 14 12.6 42.7 42.4 78 81.5 97.7l0 25.1c0 39.4 31.7 71.5 71.1 72-36.6-.1-71.4-8-102.9-21.9-2.7-6.6-4.7-13.5-6.1-20.7-77.2-39.9-130-120.5-130-213.4zM120.8 140.4c-2 4-.4 8.8 3.6 10.7l81.7 40.8-81.7 40.8c-4 2-5.6 6.8-3.6 10.7s6.8 5.6 10.7 3.6l96-48c2.7-1.4 4.4-4.1 4.4-7.2s-1.7-5.8-4.4-7.2l-96-48c-4-2-8.8-.4-10.7 3.6zM280 192c0 3 1.7 5.8 4.4 7.2l96 48c4 2 8.8 .4 10.7-3.6s.4-8.8-3.6-10.7l-81.7-40.8 81.7-40.8c4-2 5.6-6.8 3.6-10.7s-6.8-5.6-10.7-3.6l-96 48c-2.7 1.4-4.4 4.1-4.4 7.2z", "M496 256c0 92.9-52.8 173.5-130 213.4-1.4 7.2-3.5 14.1-6.1 20.7 89.7-39.8 152.2-129.6 152.2-234.1 0-141.4-114.6-256-256-256S0 114.6 0 256c0 104.4 62.5 194.2 152.2 234.1-2.7-6.6-4.7-13.5-6.1-20.7-77.2-39.9-130-120.5-130-213.4 0-132.5 107.5-240 240-240S496 123.5 496 256zM327.7 396.9c-2.5-20.8-20.2-36.9-41.6-36.9-11.1 0-21.8 4.4-29.7 12.3l-.4 .4-.4-.4c-7.9-7.9-18.5-12.3-29.7-12.3-21.5 0-39.2 16.1-41.6 36.9-30.9-17.8-54.6-46.7-65.6-81.3 41.3 13.1 88 20.4 137.3 20.4s96-7.3 137.3-20.4c-11 34.6-34.7 63.5-65.6 81.3zm.3 18c39.1-19.7 68.9-55 81.5-97.7 3.4-11.7-8.4-21-20-17.3-39.9 12.8-85.3 20-133.5 20s-93.6-7.2-133.5-20c-11.6-3.7-23.4 5.6-20 17.3 12.6 42.7 42.4 78 81.5 97.7l0 25.1c0 39.8 32.2 72 72 72s72-32.2 72-72l0-25.1zM124.4 151.2l81.7 40.8-81.7 40.8c-4 2-5.6 6.8-3.6 10.7s6.8 5.6 10.7 3.6l96-48c2.7-1.4 4.4-4.1 4.4-7.2s-1.7-5.8-4.4-7.2l-96-48c-4-2-8.8-.4-10.7 3.6s-.4 8.8 3.6 10.7zm266.7-10.7c-2-4-6.8-5.6-10.7-3.6l-96 48c-2.7 1.4-4.4 4.1-4.4 7.2s1.7 5.8 4.4 7.2l96 48c4 2 8.8 .4 10.7-3.6s.4-8.8-3.6-10.7l-81.7-40.8 81.7-40.8c4-2 5.6-6.8 3.6-10.7zM244.3 383.6l3.7 3.7 0 28.7c0 4.4 3.6 8 8 8s8-3.6 8-8l0-28.7 3.7-3.7c4.9-4.9 11.5-7.6 18.3-7.6 14.3 0 25.9 11.6 25.9 25.9l0 38.1c0 30.9-25.1 56-56 56s-56-25.1-56-56l0-38.1c0-14.3 11.6-25.9 25.9-25.9 6.9 0 13.5 2.7 18.3 7.6z"]],
    "pickaxe": [576, 512, [], "e5bf", ["M183 26.9C340.3 79.3 464.7 203.7 517.1 361 544.1 322.2 560 275 560 224 560 91.5 452.5-16 320-16 269-16 221.8-.1 183 26.9z", "M560 224C560 275 544.1 322.2 517.1 361 464.7 203.7 340.3 79.3 183 26.9 221.8-.1 269-16 320-16 452.5-16 560 91.5 560 224zM502.1 366.7c4 12.1 19.5 15.6 26.9 5.2 29.6-41.8 47-92.8 47-147.9 0-67.8-26.4-129.5-69.4-175.3l27.1-27.1c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0L495.3 37.4c-45.8-43-107.5-69.4-175.3-69.4-55.1 0-106.2 17.4-147.9 47-10.4 7.3-6.8 22.9 5.2 26.9 73.9 24.5 140.4 65.4 195 118.4l-330 330c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l330-330c53 54.7 93.9 121.1 118.4 195z"]],
    "comment-dollar": [512, 512, [], "f651", ["M16 240c0 51.7 18.8 99.4 50.5 137.4 4.1 4.9 4.9 11.7 2 17.4l-49.4 98.7 124.8-49.9c3.9-1.6 8.3-1.5 12.2 .1 30.4 13 64.2 20.2 99.9 20.2 133.5 0 240-101.2 240-224S389.5 16 256 16 16 117.2 16 240zm184-37.4c0-23.6 19.1-42.6 42.6-42.6l5.4 0 0-16c0-4.4 3.6-8 8-8s8 3.6 8 8l0 16 24 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-45.4 0c-14.7 0-26.6 11.9-26.6 26.6 0 13 9.4 24.1 22.3 26.3l38.1 6.3c20.6 3.4 35.6 21.2 35.6 42.1 0 23.6-19.1 42.6-42.6 42.6l-5.4 0 0 16c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-16-32 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l53.4 0c14.7 0 26.6-11.9 26.6-26.6 0-13-9.4-24.1-22.3-26.3l-38.1-6.3c-20.6-3.4-35.6-21.2-35.6-42.1z", "M68.5 394.8c2.8-5.7 2-12.5-2-17.4-31.7-38-50.5-85.7-50.5-137.4 0-122.8 106.5-224 240-224S496 117.2 496 240 389.5 464 256 464c-35.7 0-69.5-7.3-99.9-20.2-3.9-1.7-8.3-1.7-12.2-.1L19.1 493.5 68.5 394.8zM0 240c0 55.7 20.2 106.9 54.2 147.7L1.4 493.3C-4 504 7.6 515.4 18.4 511l131.5-52.6c32.3 13.8 68.3 21.5 106.2 21.5 141.4 0 256-107.5 256-240S397.4 0 256 0 0 107.5 0 240zM256 136c-4.4 0-8 3.6-8 8l0 16-5.4 0c-23.6 0-42.6 19.1-42.6 42.6 0 20.8 15.1 38.6 35.6 42.1l38.1 6.3c12.9 2.1 22.3 13.3 22.3 26.3 0 14.7-11.9 26.6-26.6 26.6L216 304c-4.4 0-8 3.6-8 8s3.6 8 8 8l32 0 0 16c0 4.4 3.6 8 8 8s8-3.6 8-8l0-16 5.4 0c23.6 0 42.6-19.1 42.6-42.6 0-20.8-15.1-38.6-35.6-42.1l-38.1-6.3c-12.8-2.1-22.3-13.3-22.3-26.3 0-14.7 11.9-26.6 26.6-26.6l45.4 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-24 0 0-16c0-4.4-3.6-8-8-8z"]],
    "list-timeline": [512, 512, [], "e1d1", ["M128 80l43.3 43.3c3 3 7.1 4.7 11.3 4.7L416 128c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16L182.6 32c-4.2 0-8.3 1.7-11.3 4.7L128 80zm0 176l43.3 43.3c3 3 7.1 4.7 11.3 4.7L480 304c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16l-297.4 0c-4.2 0-8.3 1.7-11.3 4.7L128 256zm0 176l43.3 43.3c3 3 7.1 4.7 11.3 4.7L416 480c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16l-233.4 0c-4.2 0-8.3 1.7-11.3 4.7L128 432z", "M160 486.6l-43.3-43.3c-6.2-6.2-6.2-16.4 0-22.6L160 377.4c6-6 14.1-9.4 22.6-9.4L416 368c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-233.4 0c-8.5 0-16.6-3.4-22.6-9.4zM128 432l43.3 43.3c3 3 7.1 4.7 11.3 4.7L416 480c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16l-233.4 0c-4.2 0-8.3 1.7-11.3 4.7L128 432zM171.3 36.7L128 80 171.3 123.3c3 3 7.1 4.7 11.3 4.7L416 128c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16L182.6 32c-4.2 0-8.3 1.7-11.3 4.7zm0 176L128 256 171.3 299.3c3 3 7.1 4.7 11.3 4.7L480 304c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16l-297.4 0c-4.2 0-8.3 1.7-11.3 4.7zM182.6 16L416 16c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-233.4 0c-8.5 0-16.6-3.4-22.6-9.4L116.7 91.3c-6.2-6.2-6.2-16.4 0-22.6L160 25.4c6-6 14.1-9.4 22.6-9.4zM160 201.4c6-6 14.1-9.4 22.6-9.4L480 192c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-297.4 0c-8.5 0-16.6-3.4-22.6-9.4l-43.3-43.3c-6.2-6.2-6.2-16.4 0-22.6L160 201.4zM32 96a16 16 0 1 1 0-32 16 16 0 1 1 0 32zM16 256a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM32 448a16 16 0 1 1 0-32 16 16 0 1 1 0 32z"]],
    "swords-laser": [640, 512, [], "e03d", ["M37.2-4.5L283.8 272 387.6 272 59.7-26.8c-6.3-5.7-15.9-5.5-21.9 .5-5.9 5.9-6.2 15.5-.6 21.7zM352.1 165.1l60.5 55.2 .7-.7-7.8-7.1 189.7-209.1c5.6-6.2 5.4-15.8-.5-21.7s-15.5-6.2-21.7-.5l-211.2 191.5-8.9-8.1-.7 .6z", "M37.8-26.3c-5.9 5.9-6.2 15.5-.6 21.7L283.8 272 387.6 272 59.7-26.8c-6.3-5.7-15.9-5.5-21.9 .5zM70.4-38.6L411.3 272 419 272c8.5 0 16.6 3.4 22.6 9.4l176 176c12.5 12.5 12.5 32.8 0 45.3l-50.7 50.7c-12.5 12.5-32.8 12.5-45.3 0-155.7-155.7-110.5-110.5-262.1-262.1-2.1-2.1-3.3-5-3.3-8 0-4.7 2.9-8.7 6.9-10.4L25.3 6.1c-11.2-12.6-10.7-31.8 1.2-43.7 12-12 31.4-12.5 43.9-1zM532.9 542.1c6.2 6.2 16.4 6.2 22.6 0l19.7-19.7-111-111-31 31 99.7 99.7zm53.7-31l19.7-19.7c6.2-6.2 6.2-16.4 0-22.6l-99.7-99.7-31 31 111 111zM421.9 431l73.4-73.4-65-65c-3-3-7.1-4.7-11.3-4.7l-140.1 0 143 143zM33.2 451.7l177.5-177.5 5.6 6.3c-.1 1-.1 1.9-.1 2.9 0 2.5 .2 5 .5 7.5l-21.2 21.2 68.7 68.7 14.1-14.1 11.3 11.3-165.1 165.1c-15.6 15.6-40.9 15.6-56.6 0L33.2 508.3c-15.6-15.6-15.6-40.9 0-56.6zM607 14.1L417.3 223.3 405.4 212.5 595.1 3.4c5.6-6.2 5.4-15.8-.5-21.7s-15.5-6.2-21.7-.5L361.7 172.7 349.8 161.8 562.1-30.7c12.5-11.4 31.8-10.9 43.8 1.1S618.4 1.6 607 14.1zM147.6 360l68.7 68.7 36.7-36.7-68.7-68.7-36.7 36.7zm-11.3 11.3L44.5 463c-9.4 9.4-9.4 24.6 0 33.9l34.7 34.7c9.4 9.4 24.6 9.4 33.9 0l91.7-91.7-68.7-68.7z"]],
    "phone-waveform": [640, 512, [], "e6e2", ["M82.4 155.8c35.2 169.3 168.5 302.6 337.8 337.8 65.7 13.7 121.1-33.7 137-91.8l1.9-6.9c3.5-12.8-3.1-26.3-15.3-31.4l-96.4-40.2c-10.8-4.5-23.2-1.4-30.6 7.7l-44.8 54.7c-2.3 2.8-6.3 3.7-9.6 2.2-76.5-36-137.7-99.2-171.1-177.1-1.4-3.3-.5-7.1 2.3-9.3L245 159.3c9-7.4 12.2-19.9 7.7-30.6L212.5 32.3c-5.1-12.3-18.5-18.8-31.4-15.3l-6.9 1.9c-58.1 15.9-105.5 71.3-91.8 137z", "M464-16c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 224c0 4.4 3.6 8 8 8s8-3.6 8-8l0-224zm80 32c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 160c0 4.4 3.6 8 8 8s8-3.6 8-8l0-160zM384 32c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 128c0 4.4 3.6 8 8 8s8-3.6 8-8l0-128zM624 64c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 64c0 4.4 3.6 8 8 8s8-3.6 8-8l0-64zM181.1 16.9c12.8-3.5 26.3 3.1 31.4 15.3l40.2 96.4c4.5 10.8 1.4 23.2-7.7 30.6l-51.5 42.1c-2.8 2.3-3.7 6.1-2.3 9.3 33.4 77.9 94.6 141.1 171.1 177.1 3.3 1.6 7.3 .7 9.6-2.2L416.7 331c7.4-9 19.9-12.2 30.6-7.7l96.4 40.2c12.3 5.1 18.8 18.5 15.3 31.4l-1.9 6.9c-15.9 58.1-71.3 105.5-137 91.8-169.3-35.2-302.6-168.5-337.8-337.8-13.7-65.7 33.7-121.1 91.8-137l6.9-1.9zm46.1 9.2C219 6.4 197.5-4.1 176.9 1.5L170 3.4C106 20.8 50.9 82.9 66.7 159.1 103.2 334.6 241.4 472.8 416.9 509.3 493.1 525.1 555.2 470 572.6 406l1.9-6.9c5.6-20.6-4.9-42.1-24.6-50.3l-96.4-40.2c-17.3-7.2-37.3-2.2-49.2 12.3l-40.8 49.9C294.9 336.9 239.8 279.9 208.3 210l46.8-38.3c14.5-11.9 19.5-31.9 12.3-49.2L227.2 26.1z"]],
    "hippo": [640, 512, [129435], "f6ed", ["M46.8 308.8c.8-5.8 1.2-11.8 1.2-17.7 0-27.9 0-42.3 0-43.1 0-92.8 75.2-168 168-168l79.4 0c25.9 0 51.6 4.7 75.8 13.8l24.2 9.1c-7.2 12-11.4 26.1-11.4 41.2l0 16c0 10.1-5.1 19.3-11.7 26.8-12.6 14.1-20.3 32.8-20.3 53.2 0 38.7 27.5 71 64 78.4l0 17.6c0 13.3 10.7 24 24 24l8 0 0 24-8 0c-2.7 0-5.4-.2-8-.7l0 56.7c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-80c0-2.6-1.2-5-3.3-6.5s-4.8-1.9-7.2-1.1l-16.3 5.4c-34.5 11.5-71.8 11.5-106.3 0l-16.3-5.4c-2.4-.8-5.1-.4-7.2 1.1s-3.3 3.9-3.3 6.5l0 80c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-96c0-4.4-3.6-8-8-8-3.6 0-6.6 2.3-7.6 5.6L46.8 308.8zM368 240c0-16.4 6.1-31.2 16.2-42.6 8.1-9.1 15.8-21.9 15.8-37.4l0-16c0-13.4 4.1-25.7 11-35.9l7.4-10.9c-7.1-7.1-11.7-11.7-13.8-13.8-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0c11.8 11.8 18.7 18.7 20.8 20.8l7.8-1c2.6-.3 5.4-.5 8.1-.5l32 0c6.5 0 12.8 1 18.6 2.8l9.2 2.8c4-4 9.6-9.6 16.9-16.9 6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6c-4.1 4.1-9 9-14.6 14.6l5 10.2c4.1 8.4 6.3 17.8 6.3 27.8 0 18.4 13 31.7 26.2 37.6 1.7 .7 3.3 1.6 4.9 2.4-26.1 .5-47 21.8-47 48 0 4.4 3.6 8 8 8s8-3.6 8-8c0-17.7 14.3-32 32-32 11.1 0 20.8 5.6 26.6 14.2 3.5 7.9 5.4 16.6 5.4 25.8 0 20.9-10 39.5-25.6 51.2l-6 4.5-6.8 3c-7.8 3.4-16.5 5.3-25.6 5.3l-134.5 0-6.3-1.3C390 296.8 368 270.9 368 240zm40-8c0 4.4 3.6 8 8 8s8-3.6 8-8c0-17.7 14.3-32 32-32s32 14.3 32 32c0 4.4 3.6 8 8 8s8-3.6 8-8c0-26.5-21.5-48-48-48s-48 21.5-48 48zm40-88a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm64 0a16 16 0 1 0 32 0 16 16 0 1 0 -32 0z", "M411 108.1c-7 10.2-11 22.6-11 35.9l0 16c0 15.5-7.7 28.3-15.8 37.4-10.1 11.3-16.2 26.2-16.2 42.6 0 30.9 22 56.8 51.2 62.7l6.3 1.3 134.5 0c9.1 0 17.8-1.9 25.6-5.3l6.8-3 6-4.5c15.6-11.7 25.6-30.3 25.6-51.2 0-9.2-1.9-17.9-5.4-25.8-5.7-8.5-15.5-14.2-26.6-14.2-17.7 0-32 14.3-32 32 0 4.4-3.6 8-8 8s-8-3.6-8-8c0-26.2 21-47.5 47-48-1.6-.9-3.2-1.7-4.9-2.4-13.2-5.9-26.2-19.2-26.2-37.6 0-10-2.3-19.4-6.3-27.8l-5-10.2c5.6-5.6 10.5-10.5 14.6-14.6 6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0c-7.3 7.3-12.9 12.9-16.9 16.9l-9.2-2.8C508.8 81 502.5 80 496 80l-32 0c-2.8 0-5.5 .2-8.1 .5l-7.8 1c-2.1-2.1-9-9-20.8-20.8-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6c2.1 2.1 6.7 6.7 13.8 13.8L411 108.1zM639.8 233.9c.2 2 .2 4 .2 6.1 0 26.2-12.6 49.4-32 64l0 32c0 13.3-10.7 24-24 24l-24 0c-13.3 0-24-10.7-24-24l0-16-48 0 0 16c0 13.3-10.7 24-24 24l-24 0c-13.3 0-24-10.7-24-24l0-17.6c-36.5-7.4-64-39.7-64-78.4 0-20.4 7.7-39.1 20.3-53.2 6.7-7.5 11.7-16.7 11.7-26.8l0-16c0-15.1 4.2-29.2 11.4-41.2l-24.2-9.1C347 84.7 321.3 80 295.4 80L216 80c-92.8 0-168 75.2-168 168 0 8.8 0 11.2 0 43.1 0 30.9-10.5 60.9-29.8 85L14.2 381c-2.8 3.4-7.8 4-11.2 1.2s-4-7.8-1.2-11.2l3.9-4.9c17-21.3 26.3-47.7 26.3-75 0-63 0-24.7 0-43.1 0-101.6 82.4-184 184-184l79.4 0c27.8 0 55.4 5 81.5 14.8l8.8 3.3c-3.7-11.1-1.1-23.8 7.8-32.7 12.5-12.5 32.8-12.5 45.3 0l15.3 15.3c3.3-.4 6.7-.6 10.1-.6l32 0c8.1 0 15.9 1.2 23.3 3.4l10.1-10.1c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3l-6.6 6.6c5.1 10.5 7.9 22.3 7.9 34.8 0 10.2 7.4 18.8 16.7 23 17.6 7.9 31.8 22 39.9 39.5 4.7 7.4 7.3 16.1 7.3 25.5 0 .7-.1 1.3-.2 1.9zM592 313.3c-10.3 4.5-21.3 6.7-32 6.7l-8 0 0 16c0 4.4 3.6 8 8 8l24 0c4.4 0 8-3.6 8-8l0-22.7zM440 344l24 0c4.4 0 8-3.6 8-8l0-16-40 0 0 16c0 4.4 3.6 8 8 8zm-8 39.3c2.6 .4 5.3 .7 8 .7l8 0 0 56c0 22.1-17.9 40-40 40l-48 0c-22.1 0-40-17.9-40-40l0-68.9-5.8 1.9c-37.8 12.6-78.6 12.6-116.4 0l-5.8-1.9 0 68.9c0 22.1-17.9 40-40 40l-48 0c-22.1 0-40-17.9-40-40l0-96c0-4.4 3.6-8 8-8s8 3.6 8 8l0 96c0 13.3 10.7 24 24 24l48 0c13.3 0 24-10.7 24-24l0-80c0-2.6 1.2-5 3.3-6.5s4.8-1.9 7.2-1.1l16.3 5.4c34.5 11.5 71.8 11.5 106.3 0l16.3-5.4c2.4-.8 5.1-.4 7.2 1.1s3.3 3.9 3.3 6.5l0 80c0 13.3 10.7 24 24 24l48 0c13.3 0 24-10.7 24-24l0-56.7zM464 128a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm48 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm-56 56c-17.7 0-32 14.3-32 32 0 4.4-3.6 8-8 8s-8-3.6-8-8c0-26.5 21.5-48 48-48s48 21.5 48 48c0 4.4-3.6 8-8 8s-8-3.6-8-8c0-17.7-14.3-32-32-32z"]],
    "sword-laser-alt": [640, 512, [], "e03c", ["M252.9 272L356.7 272 603.3-4.5c5.6-6.3 5.3-15.8-.6-21.7-6-6-15.6-6.2-21.9-.5L252.9 272z", "M580.8-26.8L252.9 272 356.7 272 603.3-4.5c5.6-6.3 5.3-15.8-.6-21.7-6-6-15.6-6.2-21.9-.5zM229.1 272L570-38.6c12.6-11.5 31.9-11 43.9 1 11.9 11.9 12.5 31.1 1.2 43.7L377.3 272.9c4.1 1.7 6.9 5.7 6.9 10.4 0 3-1.2 5.9-3.3 8l-151 151-11.3 11.3-99.7 99.7c-12.5 12.5-32.8 12.5-45.3 0l11.3-11.3c6.2 6.2 16.4 6.2 22.6 0l99.7-99.7-31-31-111 111 19.7 19.7-11.3 11.3-50.7-50.7c-12.5-12.5-12.5-32.8 0-45.3l99.7-99.7 11.3-11.3 65-65c6-6 14.1-9.4 22.6-9.4l7.6 0zM34.2 491.3l19.7 19.7 111-111-31-31-99.7 99.7c-6.2 6.2-6.2 16.4 0 22.6zm111-133.7l73.4 73.4 143-143-140.1 0c-4.2 0-8.3 1.7-11.3 4.7l-65 65z"]],
    "flower": [448, 512, [127804, 10047], "f7ff", ["M16 168c0 29.6 10.7 56.7 28.5 77.6 5.1 6 5.1 14.7 0 20.7-17.8 20.9-28.5 48-28.5 77.6 0 66.3 53.7 120 120 120 29.6 0 56.7-10.7 77.6-28.5 6-5.1 14.7-5.1 20.7 0 20.9 17.8 48 28.5 77.6 28.5 66.3 0 120-53.7 120-120 0-29.6-10.7-56.7-28.5-77.6-5.1-6-5.1-14.7 0-20.7 17.8-20.9 28.5-48 28.5-77.6 0-66.3-53.7-120-120-120-29.6 0-56.7 10.7-77.6 28.5-6 5.1-14.7 5.1-20.7 0-20.9-17.8-48-28.5-77.6-28.5-66.3 0-120 53.7-120 120zm288 88a80 80 0 1 1 -160 0 80 80 0 1 1 160 0z", "M448 168c0 33.6-12.2 64.3-32.3 88 20.1 23.7 32.3 54.4 32.3 88 0 75.1-60.9 136-136 136-33.6 0-64.3-12.2-88-32.3-23.7 20.1-54.4 32.3-88 32.3-75.1 0-136-60.9-136-136 0-33.6 12.2-64.3 32.3-88-20.1-23.7-32.3-54.4-32.3-88 0-75.1 60.9-136 136-136 33.6 0 64.3 12.2 88 32.3 23.7-20.1 54.4-32.3 88-32.3 75.1 0 136 60.9 136 136zM213.6 76.5c-20.9-17.8-48-28.5-77.6-28.5-66.3 0-120 53.7-120 120 0 29.6 10.7 56.7 28.5 77.6 5.1 6 5.1 14.7 0 20.7-17.8 20.9-28.5 48-28.5 77.6 0 66.3 53.7 120 120 120 29.6 0 56.7-10.7 77.6-28.5 6-5.1 14.7-5.1 20.7 0 20.9 17.8 48 28.5 77.6 28.5 66.3 0 120-53.7 120-120 0-29.6-10.7-56.7-28.5-77.6-5.1-6-5.1-14.7 0-20.7 17.8-20.9 28.5-48 28.5-77.6 0-66.3-53.7-120-120-120-29.6 0-56.7 10.7-77.6 28.5-6 5.1-14.7 5.1-20.7 0zM288 256a64 64 0 1 0 -128 0 64 64 0 1 0 128 0zm-144 0a80 80 0 1 1 160 0 80 80 0 1 1 -160 0z"]],
    "bowl-food": [512, 512, [], "e4c6", ["M16 283.4c0 59.9 35.5 111.6 86.7 135.1 3.5 1.6 6.2 4.4 7.8 7.7L248.8 272 27.4 272c-6.3 0-11.4 5.1-11.4 11.4z", "M194.3 70.8C205.9 47.7 229.3 32 256 32s50.1 15.7 61.7 38.8l3.9 7.8 7.4-4.6c10.4-6.4 22.5-10.1 35.4-10.1 33.4 0 61.6 24.5 68.1 57.6l1.3 6.6 6.8-.2c.4 0 .9 0 1.3 0 29.6 0 54 24.8 54 56 0 7.5-1.4 14.6-4 21.1-1.6 4.1 .4 8.8 4.5 10.4s8.8-.4 10.4-4.5c3.3-8.3 5.1-17.4 5.1-26.9 0-37.9-28.6-69.3-65.2-71.8-10.1-36.9-43-64.2-82.3-64.2-13.1 0-25.5 3-36.6 8.4-15.2-24.2-41.7-40.4-71.9-40.4s-56.8 16.2-71.9 40.4c-11.1-5.4-23.5-8.4-36.6-8.4-39.4 0-72.3 27.3-82.3 64.2-36.6 2.6-65.2 34-65.2 71.8 0 9.5 1.8 18.6 5.1 26.9 1.6 4.1 6.3 6.1 10.4 4.5s6.1-6.3 4.5-10.4c-2.5-6.5-4-13.6-4-21.1 0-31.2 24.4-56 54-56 .4 0 .9 0 1.3 0l6.8 .2 1.3-6.6c6.5-33 34.7-57.6 68.1-57.6 13 0 25.1 3.7 35.5 10.1l7.4 4.6 3.9-7.8zM112 432.7c-.1-6.1-3.8-11.6-9.3-14.2-51.2-23.5-86.7-75.2-86.7-135.1 0-6.3 5.1-11.4 11.4-11.4l457.1 0c6.3 0 11.4 5.1 11.4 11.4 0 59.9-35.5 111.6-86.7 135.1-5.6 2.6-9.2 8.1-9.3 14.2-.4 17.3-14.6 31.3-32 31.3l-224 0c-17.4 0-31.6-13.9-32-31.3zM27.4 256c-15.1 0-27.4 12.3-27.4 27.4 0 66.4 39.4 123.7 96 149.7 .6 26 21.8 46.9 48 46.9l224 0c26.1 0 47.4-20.9 48-46.9 56.7-26 96-83.2 96-149.7 0-15.1-12.3-27.4-27.4-27.4L27.4 256z"]],
    "globe-pointer": [576, 512, [], "e60e", ["M80.1 248l103.4 0c2.9-.8 5.8-1.7 8.6-2.5 2.2-96.5 34.2-185.2 78.4-224.4-106.3 22.3-186.8 114.9-190.4 226.9zm128.1-7.3c7.4-2.2 14.7-4.3 22.1-6.5 48.6-14.3 93.8 30.9 79.5 79.5-14.6 49.6-29.2 99.3-43.8 148.9 17.5 22.3 36.4 33.4 54 33.4 25.2 0 53.2-22.8 75.9-68.8 21.1-42.9 35-101.2 36.1-163.2l-111.9 0 0-16 111.9 0C430.8 186.1 417 127.7 395.9 84.8 373.2 38.8 345.2 16 320 16s-53.2 22.8-75.9 68.8c-20.3 41.2-33.9 96.7-35.9 155.9zM369.4 21.1c44.7 39.5 76.8 129.4 78.5 226.9l111.9 0C556.2 136 475.7 43.4 369.4 21.1zm0 469.8C475.7 468.6 556.2 376 559.9 264l-111.9 0c-1.7 97.5-33.8 187.4-78.5 226.9z", "M320 496c25.2 0 53.2-22.8 75.9-68.8 21.1-42.9 35-101.2 36.1-163.2l-111.9 0 0-16 111.9 0C430.8 186.1 417 127.7 395.9 84.8 373.2 38.8 345.2 16 320 16s-53.2 22.8-75.9 68.8c-20.3 41.2-33.9 96.7-35.9 155.9l-16.1 4.7C194.3 149 226.3 60.2 270.6 21.1 164.3 43.4 83.8 136 80.1 248l103.4 0-54.4 16-49 0c.2 4.7 .4 9.5 .9 14.1l-15.6 4.6C64.5 273.9 64 265 64 256 64 114.6 178.6 0 320 0S576 114.6 576 256 461.4 512 320 512c-22.8 0-45-3-66-8.6l4.5-15.4c4 1.1 8 2 12.1 2.9-3.4-3-6.7-6.3-10-9.9l5.4-18.4c17.5 22.3 36.4 33.4 54 33.4zM200.6 344.8l-.3-1.6 .9-.3-.6 1.9zM369.4 490.9C475.7 468.6 556.2 376 559.9 264l-111.9 0c-1.7 97.5-33.8 187.4-78.5 226.9zm0-469.8c44.7 39.5 76.8 129.4 78.5 226.9l111.9 0C556.2 136 475.7 43.4 369.4 21.1zM248.4 295.6l-204.8 60.2 86.9 43.4c6.2 3.1 11.2 8.1 14.3 14.3l43.4 86.9 60.2-204.8zm-4.5-15.4c12.1-3.6 23.4 7.7 19.9 19.9L203.5 505c-4.1 13.9-23.2 15.6-29.7 2.6l-42-84.1-94.1 94.1c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l94.1-94.1-84.1-42c-13-6.5-11.3-25.6 2.6-29.7l204.8-60.2z"]],
    "eggplant": [512, 512, [], "e16c", ["M16 335.8c-.6-43.5 12.5-74.5 33.2-99.1 21.2-25.1 51.2-44.1 85.7-62.2 12.9-6.7 26.8-13.5 41-20.4 22.4-10.9 45.4-22.1 66.4-34.1 6-3.4 11.9-7 17.7-10.7 10.8 12.2 25.5 20.4 43 23.2 8.5 36.3 40.9 67.1 77.4 77.1 4.1 17.6 13 33 26.4 44.2 6.3 5.3 13.5 9.4 21.4 12.5-16.6 37.5-37.4 75.4-62 109.5-50.8 70-115.5 120.2-189.8 120.2-87.5-.1-159.1-73.4-160.4-160.3zM296 48c0-4.4 3.6-8 8-8l112 0c30.9 0 56 25.1 56 56l0 112c0 4.4-3.6 8-8 8l-5.8 0c-12.5 0-22.5-10.1-22.5-22.5l0-10.9c0-15.3-12.4-27.6-27.6-27.6-28.1 0-50.9-22.8-50.9-50.9 0-15.3-12.4-27.6-27.6-27.6l-10.9 0c-12.5 0-22.5-10.1-22.5-22.5l0-5.8z", "M509.7 13.7L472.3 51.1C482.1 63.4 488 79 488 96l0 112c0 13.3-10.7 24-24 24l-5.8 0c-21.3 0-38.5-17.3-38.5-38.5l0-10.9c0-6.4-5.2-11.6-11.6-11.6-37 0-66.9-30-66.9-66.9 0-6.4-5.2-11.6-11.6-11.6l-10.9 0c-21.3 0-38.5-17.3-38.5-38.5l0-5.8c0-13.3 10.7-24 24-24l112 0c17 0 32.6 5.9 44.9 15.7L498.3 2.3c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3zM304 40c-4.4 0-8 3.6-8 8l0 5.8c0 12.5 10.1 22.5 22.5 22.5l10.9 0c15.3 0 27.6 12.4 27.6 27.6 0 28.1 22.8 50.9 50.9 50.9 15.3 0 27.6 12.4 27.6 27.6l0 10.9c0 12.5 10.1 22.5 22.5 22.5l5.8 0c4.4 0 8-3.6 8-8l0-112c0-30.9-25.1-56-56-56L304 40zM169.9 139.3c27.9-13.5 55.9-27.1 81.3-43.3 2.6 4.7 5.5 9.2 8.9 13.3-5.8 3.7-11.8 7.3-17.8 10.7-20.9 12-44 23.2-66.4 34.1l0 0c-14.2 6.9-28.1 13.7-41 20.4-34.5 18-64.4 37.1-85.7 62.2-20.8 24.5-33.9 55.5-33.2 99.1 1.3 86.8 72.9 160.2 160.4 160.3 74.3 .1 139-50.1 189.8-120.2 24.7-34.1 45.5-72.1 61.9-109.5 5 1.9 10.2 3.3 15.6 4.2-51 117.4-144.5 241.6-267.3 241.5-96.5-.1-175-80.8-176.4-176-1.7-113.5 83.3-154.7 169.9-196.7z"]],
    "folder-arrow-right": [512, 512, [], "e7d3", ["M16 96l0 288c0 26.5 21.5 48 48 48l384 0c26.5 0 48-21.5 48-48l0-240c0-26.5-21.5-48-48-48L298.7 96c-9.1 0-18-2.6-25.6-7.4l-3.2-2.2-38.4-28.8C223.2 51.4 213 48 202.7 48L64 48C37.5 48 16 69.5 16 96zM160 264c0-4.4 3.6-8 8-8l156.7 0-58.3-58.3c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0l72 72 1 1.3c2 3.1 1.7 7.3-1 10.1l-72 72-1.3 1c-3.1 2.1-7.3 1.7-10.1-1s-3.1-7-1-10.1l1-1.3 58.3-58.3-156.7 0c-4.4 0-8-3.6-8-8z", "M202.7 32c13.8 0 27.3 4.5 38.4 12.8l38.4 28.8c4.2 3.1 9 5.2 14.1 6l5.1 .4 149.3 0c35.3 0 64 28.7 64 64l0 240c0 35.3-28.7 64-64 64L64 448c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l138.7 0zM64 48C37.5 48 16 69.5 16 96l0 288c0 26.5 21.5 48 48 48l384 0c26.5 0 48-21.5 48-48l0-240c0-26.5-21.5-48-48-48L298.7 96c-9.1 0-18-2.6-25.6-7.4l-3.2-2.2-38.4-28.8C223.2 51.4 213 48 202.7 48L64 48zM266.3 186.3c3.1-3.1 8.2-3.1 11.3 0l72 72 1 1.3c2 3.1 1.7 7.3-1 10.1l-72 72-1.3 1c-3.1 2.1-7.3 1.7-10.1-1s-3.1-7-1-10.1l1-1.3 58.3-58.3-156.7 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l156.7 0-58.3-58.3c-3.1-3.1-3.1-8.2 0-11.3z"]],
    "battery-slash": [640, 512, [], "f377", ["M155.4 80L512 80c35.3 0 64 28.7 64 64l0 224c0 35.3-28.7 64-64 64l-4.6 0-352-352z", "M45.7-29.8c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l560 560c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-83-83c39.1-5.2 69.3-38.7 69.3-79.3l0-32 16 0c17.7 0 32-14.3 32-32l0-96c0-17.7-14.3-32-32-32l-16 0 0-32c0-44.2-35.8-80-80-80L139.4 64 45.7-29.8zM155.4 80L512 80c35.3 0 64 28.7 64 64l0 224c0 35.3-28.7 64-64 64l-4.6 0-352-352zM416.8 432L112 432c-35.3 0-64-28.7-64-64l0-224c0-22 11.1-41.3 27.9-52.9L64.5 79.7C44.8 94.2 32 117.6 32 144l0 224c0 44.2 35.8 80 80 80l320.8 0-16-16zM592 192l16 0c8.8 0 16 7.2 16 16l0 96c0 8.8-7.2 16-16 16l-16 0 0-128z"]],
    "film-slash": [576, 512, [], "e179", ["M176 48l0 84.6 224 224 0-308.6-224 0z", "M13.7-29.8c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l560 560c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-75.1-75.1C507 444.4 512 430.8 512 416l0-320c0-35.3-28.7-64-64-64L128 32c-14.8 0-28.4 5-39.2 13.4L13.7-29.8zm86.6 86.6c7.8-5.6 17.4-8.8 27.8-8.8l32 0 0 68.6-59.8-59.8zM176 132.6l0-84.6 224 0 0 308.6-224-224zM419.4 376l76.6 0 0 40c0 10.3-3.3 19.9-8.8 27.8L419.4 376zM160 207.2l0 40.8-80 0 0-120.8-16-16 0 304.8c0 35.3 28.7 64 64 64l304.8 0-16-16-240.8 0 0-240.8-16-16zM80 264l80 0 0 96-80 0 0-96zm80 112l0 88-32 0c-26.5 0-48-21.5-48-48l0-40 80 0zM416 144l0-96 32 0c26.5 0 48 21.5 48 48l0 48-80 0zm80 16l0 88-80 0 0-88 80 0zm0 104l0 96-80 0 0-96 80 0z"]],
    "square-virus": [448, 512, [], "e578", ["M16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96zM79.1 256c0-17.7 14.3-32 32-32 13.2 0 19.8-15.9 10.4-25.2-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0c9.3 9.3 25.2 2.7 25.2-10.4 0-17.7 14.3-32 32-32s32 14.3 32 32c0 13.2 15.9 19.8 25.2 10.4 12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3c-9.3 9.3-2.7 25.2 10.4 25.2 17.7 0 32 14.3 32 32s-14.3 32-32 32c-13.2 0-19.8 15.9-10.4 25.2 12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0c-9.3-9.3-25.2-2.7-25.2 10.4 0 17.7-14.3 32-32 32s-32-14.3-32-32c0-13.2-15.9-19.8-25.2-10.4-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3c9.3-9.3 2.7-25.2-10.4-25.2-17.7 0-32-14.3-32-32z", "M64 48C37.5 48 16 69.5 16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm224 15.1c17.7 0 32 14.3 32 32 0 13.2 15.9 19.8 25.2 10.4 12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3c-9.3 9.3-2.7 25.2 10.4 25.2 17.7 0 32 14.3 32 32s-14.3 32-32 32c-13.2 0-19.8 15.9-10.4 25.2 12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0c-9.3-9.3-25.2-2.7-25.2 10.4 0 17.7-14.3 32-32 32s-32-14.3-32-32c0-13.2-15.9-19.8-25.2-10.4-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3c9.3-9.3 2.7-25.2-10.4-25.2-17.7 0-32-14.3-32-32s14.3-32 32-32c13.2 0 19.8-15.9 10.4-25.2-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0c9.3 9.3 25.2 2.7 25.2-10.4 0-17.7 14.3-32 32-32zm-16 32c0 27.4-33.2 41.2-52.5 21.8-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6c19.4 19.4 5.7 52.5-21.8 52.5-8.8 0-16 7.2-16 16s7.2 16 16 16c27.4 0 41.2 33.2 21.8 52.5-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0c19.4-19.4 52.5-5.7 52.5 21.8 0 8.8 7.2 16 16 16s16-7.2 16-16c0-27.4 33.2-41.2 52.5-21.8 6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6c-19.4-19.4-5.7-52.5 21.8-52.5 8.8 0 16-7.2 16-16s-7.2-16-16-16c-27.4 0-41.2-33.2-21.8-52.5 6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0c-19.4 19.4-52.5 5.7-52.5-21.8 0-8.8-7.2-16-16-16s-16 7.2-16 16zM192 208a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm48 80a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"]],
    "tricycle-adult": [640, 512, [], "e5c4", ["M16 336a96 96 0 1 0 192 0 96 96 0 1 0 -192 0zm448 16c0 44.2 35.8 80 80 80s80-35.8 80-80-35.8-80-80-80c-16.2 0-31.2 4.8-43.8 13.1l-4.3 3C476.5 302.7 464 325.9 464 352z", "M288 72c0-4.4 3.6-8 8-8l48 0c2.6 0 5 1.3 6.5 3.4l142.9 203c14.7-9.1 32-14.4 50.6-14.4 53 0 96 43 96 96s-43 96-96 96-96-43-96-96c0-28.7 12.6-54.5 32.6-72l-15.4-21.8-72.8 72.8c-13.5 13.5-31.8 21.1-50.9 21.1l-118.6 0c-7.8 54.3-54.4 96-110.9 96-61.9 0-112-50.1-112-112 0-57.8 43.8-105.4 100.1-111.4-6.5-6.2-11.6-14-14.6-22.9L64.4 138.5c-1.4-4.2 .9-8.7 5.1-10.1s8.7 .9 10.1 5.1l21.1 63.2c5.4 16.3 20.7 27.4 37.9 27.4l77.4 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-46.3 0c32.5 19.6 54.3 55.3 54.3 96l117.5 0c14.9 0 29.1-5.9 39.6-16.4l74.8-74.8-116-164.8-43.8 0c-4.4 0-8-3.6-8-8zM500.2 285.1l-4.3 3c-19.4 14.6-31.9 37.8-31.9 63.9 0 44.2 35.8 80 80 80s80-35.8 80-80-35.8-80-80-80c-16.2 0-31.2 4.8-43.8 13.1zM208 336a96 96 0 1 0 -192 0 96 96 0 1 0 192 0z"]],
    "circle-phone-flip": [512, 512, ["phone-circle-alt"], "e11c", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zm112.9 70.3c-3.3-12 2.9-24.5 14.3-29.3l46.6-19.4c10.1-4.2 21.7-1.3 28.6 7.1l7.3 8.9c28.8-15.4 52.2-39.6 66.6-69.1l-7.5-6.2c-8.4-6.9-11.3-18.5-7.2-28.6l19.4-46.6c4.8-11.4 17.3-17.6 29.3-14.3l3.3 .9c32.5 8.9 61.2 40.6 52.9 80.2-18 86.5-86.1 154.6-172.6 172.6-39.5 8.2-71.3-20.4-80.2-52.9l-.9-3.3z", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm66.1-367.7l3.3 .9c26.6 7.3 47.5 32.3 41.5 61.5-16.7 80.3-79.9 143.5-160.2 160.2-29.1 6.1-54.2-14.9-61.5-41.5l-.9-3.3c-1.1-4.2 1-8.6 5-10.3L196 292.4c3.5-1.5 7.6-.5 10 2.5l11.4 13.9c2.3 2.9 6.3 3.7 9.7 2.1 36.6-17.7 66-48 82.5-85.4 1.4-3.3 .5-7.1-2.3-9.4L294.9 206c-3-2.4-4-6.5-2.5-10l19.4-46.6c1.7-4 6.1-6.2 10.3-5zm-25-1.1l-19.4 46.6c-4.2 10.1-1.3 21.7 7.2 28.6l7.5 6.2c-14.4 29.4-37.8 53.7-66.6 69.1l-7.3-8.9c-6.9-8.4-18.5-11.3-28.6-7.1l-46.6 19.4c-11.4 4.8-17.6 17.3-14.3 29.3l.9 3.3c8.9 32.5 40.6 61.1 80.2 52.9 86.5-18 154.6-86.1 172.6-172.6 8.2-39.5-20.4-71.3-52.9-80.2l-3.3-.9c-12-3.3-24.5 2.9-29.3 14.3z"]],
    "cloud-sun-rain": [576, 512, [127782], "f743", ["M16.3 112.4l88.1-17.8c3.2-.6 5.6-3.1 6.3-6.3L128.4 .3 203.6 49.9c1.3 .9 2.9 1.3 4.4 1.3s3.1-.4 4.4-1.3l75.1-49.6 16 79.2c-22.3 8.6-41.2 24.2-54 44.2-12.1-7.4-26.4-11.7-41.6-11.7-44.2 0-80 35.8-80 80 0 32.8 19.8 61 48 73.4 0 .9 0 1.8 0 2.6 0 26 7.5 50.3 20.5 70.8l-68 45-17.9-88.1c-.6-3.2-3.1-5.6-6.3-6.3l-88.2-18.1 49.7-74.9c1.8-2.7 1.8-6.2 0-8.8L16.3 112.4zM240 268c0-31.4 21.2-57.8 50.1-65.6 3.6-1 6.1-4.3 5.9-8-1.6-40.6 42.3-69.7 78.7-53.5 3.3 1.5 7.2 .5 9.4-2.3 13.2-16.2 33.3-26.5 55.8-26.5 43.7 0 78 40.8 71.1 83.6-.6 3.8 1.5 7.4 5.1 8.8 25.7 9.7 43.9 34.6 43.9 63.6 0 37.5-30.4 67.9-67.9 67.9l-184.2 0c-37.5 0-67.9-30.4-67.9-67.9z", "M137.3 397.3L206 351.7c-3.4-4.1-6.5-8.5-9.4-13l-68 45-17.9-88.1c-.6-3.2-3.1-5.6-6.3-6.3l-88.2-18.1 49.7-74.9c1.8-2.7 1.8-6.2 0-8.8l-49.6-75.1 88.1-17.8c3.2-.6 5.6-3.1 6.3-6.3L128.4 .3 203.6 49.9c1.3 .9 2.9 1.3 4.4 1.3s3.1-.4 4.4-1.3l75.1-49.6 16 79.2c5-1.9 10.1-3.5 15.4-4.7l-15.8-78c-1.1-5.7-5.3-9.6-9.6-11.4s-10-2-14.8 1.2L208 33.6 137.3-13.3c-4.8-3.2-10.5-3-14.8-1.2S114-8.9 112.8-3.2L96 80 12.8 96.8c-5.7 1.2-9.6 5.3-11.4 9.6s-2 10 1.2 14.8L49.6 192 2.7 262.7c-3.2 4.8-3 10.5-1.2 14.8s5.7 8.5 11.4 9.6L96 304 112.8 387.2c1.2 5.7 5.3 9.6 9.6 11.4s10 2 14.8-1.2zM208 112c-44.2 0-80 35.8-80 80 0 32.8 19.8 61 48 73.4 .1-5.8 .6-11.5 1.4-17.1-19.9-10.8-33.5-32-33.5-56.3 0-35.3 28.7-64 64-64 12.5 0 24.1 3.6 34 9.7 2.2-4.9 4.8-9.6 7.7-14.1-12.1-7.4-26.4-11.7-41.6-11.7zm232 0c43.7 0 78 40.8 71.1 83.6-.6 3.8 1.5 7.4 5.1 8.8 25.7 9.7 43.9 34.6 43.9 63.6 0 37.5-30.4 67.9-67.9 67.9l-184.2 0c-37.5 0-67.9-30.4-67.9-67.9 0-31.4 21.2-57.8 50.1-65.6 3.6-1 6.1-4.3 5.9-8-1.6-40.6 42.3-69.7 78.7-53.5 3.3 1.5 7.2 .5 9.4-2.3 13.2-16.2 33.3-26.5 55.8-26.5zm87.6 79.9c4.4-50.1-36.1-95.9-87.6-95.9-25.4 0-48.3 10.8-64.4 28-43.9-15.1-93.3 17.6-95.6 64.8-32.7 11.5-56.1 42.6-56.1 79.2 0 46.3 37.6 83.9 83.9 83.9l184.2 0c46.3 0 83.9-37.6 83.9-83.9 0-33.7-19.8-62.7-48.4-76.1zM290.3 410.4c1.4-4.2-.9-8.7-5.1-10.1s-8.7 .9-10.1 5.1l-32.1 96.1c-1.4 4.2 .9 8.7 5.1 10.1s8.7-.9 10.1-5.1l32.1-96.1zm128 0c1.4-4.2-.9-8.7-5.1-10.1s-8.7 .9-10.1 5.1l-32.1 96.1c-1.4 4.2 .9 8.7 5.1 10.1s8.7-.9 10.1-5.1l32.1-96.1zm128 0c1.4-4.2-.9-8.7-5.1-10.1s-8.7 .9-10.1 5.1l-32.1 96.1c-1.4 4.2 .9 8.7 5.1 10.1s8.7-.9 10.1-5.1l32.1-96.1z"]],
    "h4": [512, 512, [], "f86a", ["", "M16 72c0-4.4-3.6-8-8-8s-8 3.6-8 8L0 440c0 4.4 3.6 8 8 8s8-3.6 8-8l0-176 192 0 0 176c0 4.4 3.6 8 8 8s8-3.6 8-8l0-368c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 176-192 0 0-176zm288 0c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 120c0 44.2 35.8 80 80 80l128 0 0 168c0 4.4 3.6 8 8 8s8-3.6 8-8l0-368c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 184-128 0c-35.3 0-64-28.7-64-64l0-120z"]],
    "circle-caret-right": [512, 512, ["caret-circle-right"], "f330", ["M496 256a240 240 0 1 1 -480 0 240 240 0 1 1 480 0zM192 153.2l0 205.6c0 13.9 11.3 25.2 25.2 25.2 6.4 0 12.5-2.4 17.2-6.8L343.6 275.3c5.4-5 8.4-12 8.4-19.3s-3-14.3-8.4-19.3L234.4 134.8c-4.7-4.4-10.8-6.8-17.2-6.8-13.9 0-25.2 11.3-25.2 25.2z", "M496 256a240 240 0 1 1 -480 0 240 240 0 1 1 480 0zM0 256a256 256 0 1 0 512 0 256 256 0 1 0 -512 0zm352 0c0-7.3-3-14.3-8.4-19.3L234.4 134.8c-4.7-4.4-10.8-6.8-17.2-6.8-13.9 0-25.2 11.3-25.2 25.2l0 205.6c0 13.9 11.3 25.2 25.2 25.2 6.4 0 12.5-2.4 17.2-6.8L343.6 275.3c5.4-5 8.4-12 8.4-19.3zm-19.3-7.6c2.1 2 3.3 4.7 3.3 7.6s-1.2 5.6-3.3 7.6L223.5 365.5c-1.7 1.6-4 2.5-6.3 2.5-5.1 0-9.2-4.1-9.2-9.2l0-205.6c0-5.1 4.1-9.2 9.2-9.2 2.3 0 4.6 .9 6.3 2.5L332.7 248.4z"]],
    "keyboard-brightness-low": [512, 512, [], "e1c1", ["", "M256 176a16 16 0 1 0 0-32 16 16 0 1 0 0 32zM136 400c-4.4 0-8 3.6-8 8s3.6 8 8 8l240 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-240 0zM96 240a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm336 16a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm80 144a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM16 416a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"]],
    "arrow-right-long": [576, 512, ["long-arrow-right"], "f178", ["", "M573.7 261.7c3.1-3.1 3.1-8.2 0-11.3l-152-152c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3L548.7 248 8 248c-4.4 0-8 3.6-8 8s3.6 8 8 8l540.7 0-138.3 138.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l152-152z"]],
    "font-case": [576, 512, [], "f866", ["", "M48 168l0 104 192 0 0-104c0-48.6-39.4-88-88-88l-16 0c-48.6 0-88 39.4-88 88zm0 120l0 152c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-272C32 110.6 78.6 64 136 64l16 0c57.4 0 104 46.6 104 104l0 272c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-152-192 0zm379.4-76.2c-49.9-1.9-91.4 38-91.4 87.9l0 44.2c0 48.6 39.4 88 88 88l16 0c48.6 0 88-39.4 88-88l0-43.6c0-47.3-37.4-86.1-84.6-87.9l-16-.6zM528 244.9l0-28.9c0-4.4 3.6-8 8-8s8 3.6 8 8l0 134.5c0 26.7 4.3 53.1 12.7 78.4l2.9 8.6c1.4 4.2-.9 8.7-5.1 10.1s-8.7-.9-10.1-5.1l-2.9-8.6c-4.4-13.2-7.8-26.8-10-40.5-17.6 32.5-52 54.6-91.5 54.6l-16 0c-57.4 0-104-46.6-104-104l0-44.2c0-59 49-106.2 108-103.9l16 .6c35.5 1.4 66.3 20.4 84 48.5z"]],
    "building-un": [512, 512, [], "e4d9", ["M48 64c0-26.5 21.5-48 48-48l256 0c26.5 0 48 21.5 48 48l0 272-96 0c-24.1 0-45.1 13.3-56 33-2.6-.7-5.3-1-8-1l-32 0c-17.7 0-32 14.3-32 32l0 96-80 0c-26.5 0-48-21.5-48-48L48 64zm80 56l0 24c0 13.3 10.7 24 24 24l24 0c13.3 0 24-10.7 24-24l0-24c0-13.3-10.7-24-24-24l-24 0c-13.3 0-24 10.7-24 24zm0 120l0 24c0 13.3 10.7 24 24 24l24 0c13.3 0 24-10.7 24-24l0-24c0-13.3-10.7-24-24-24l-24 0c-13.3 0-24 10.7-24 24zM248 120l0 24c0 13.3 10.7 24 24 24l24 0c13.3 0 24-10.7 24-24l0-24c0-13.3-10.7-24-24-24l-24 0c-13.3 0-24 10.7-24 24zm0 120l0 24c0 13.3 10.7 24 24 24l24 0c13.3 0 24-10.7 24-24l0-24c0-13.3-10.7-24-24-24l-24 0c-13.3 0-24 10.7-24 24z", "M352 16L96 16C69.5 16 48 37.5 48 64l0 384c0 26.5 21.5 48 48 48l80 0 0-96c0-17.7 14.3-32 32-32l32 0c2.8 0 5.4 .3 8 1-2.6 4.7-4.6 9.8-6 15.1-.7-.1-1.3-.1-2-.1l-32 0c-8.8 0-16 7.2-16 16l0 96 48 0 0 16-144 0c-35.3 0-64-28.7-64-64L32 64C32 28.7 60.7 0 96 0L352 0c35.3 0 64 28.7 64 64l0 272-16 0 0-272c0-26.5-21.5-48-48-48zM152 216l24 0c13.3 0 24 10.7 24 24l0 24c0 13.3-10.7 24-24 24l-24 0c-13.3 0-24-10.7-24-24l0-24c0-13.3 10.7-24 24-24zm-8 24l0 24c0 4.4 3.6 8 8 8l24 0c4.4 0 8-3.6 8-8l0-24c0-4.4-3.6-8-8-8l-24 0c-4.4 0-8 3.6-8 8zM128 120c0-13.3 10.7-24 24-24l24 0c13.3 0 24 10.7 24 24l0 24c0 13.3-10.7 24-24 24l-24 0c-13.3 0-24-10.7-24-24l0-24zm24-8c-4.4 0-8 3.6-8 8l0 24c0 4.4 3.6 8 8 8l24 0c4.4 0 8-3.6 8-8l0-24c0-4.4-3.6-8-8-8l-24 0zM272 96l24 0c13.3 0 24 10.7 24 24l0 24c0 13.3-10.7 24-24 24l-24 0c-13.3 0-24-10.7-24-24l0-24c0-13.3 10.7-24 24-24zm-8 24l0 24c0 4.4 3.6 8 8 8l24 0c4.4 0 8-3.6 8-8l0-24c0-4.4-3.6-8-8-8l-24 0c-4.4 0-8 3.6-8 8zM248 240c0-13.3 10.7-24 24-24l24 0c13.3 0 24 10.7 24 24l0 24c0 13.3-10.7 24-24 24l-24 0c-13.3 0-24-10.7-24-24l0-24zm24-8c-4.4 0-8 3.6-8 8l0 24c0 4.4 3.6 8 8 8l24 0c4.4 0 8-3.6 8-8l0-24c0-4.4-3.6-8-8-8l-24 0zM430.2 400.2c3.6-.9 7.3 .9 9 4.2l48.8 97.7 0-94.1c0-4.4 3.6-8 8-8s8 3.6 8 8l0 128c0 3.7-2.6 6.9-6.2 7.8s-7.3-.9-9-4.2L440 441.9 440 536c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-128c0-3.7 2.6-6.9 6.2-7.8zM312 408l0 96c0 13.3 10.7 24 24 24s24-10.7 24-24l0-96c0-4.4 3.6-8 8-8s8 3.6 8 8l0 96c0 22.1-17.9 40-40 40s-40-17.9-40-40l0-96c0-4.4 3.6-8 8-8s8 3.6 8 8z"]],
    "toilet-paper-xmark": [512, 512, [], "e5b3", ["M16 224C16 174.3 27.4 129.7 45.4 97.8 63.6 65.7 87.4 48 112 48l242.8 0c-13.6 10.2-25.5 24.7-35.3 42-19.6 34.7-31.5 82.1-31.5 134s11.9 99.3 31.5 134c9.8 17.3 21.7 31.8 35.3 42L112 400c-24.6 0-48.4-17.7-66.6-49.8-18-31.9-29.4-76.5-29.4-126.2zm78.8-65.2c-3.1 3.1-3.1 8.2 0 11.3l53.8 53.8-53.8 53.8c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l53.8-53.8 53.8 53.8c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-53.8-53.8 53.8-53.8c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0l-53.8 53.8-53.8-53.8c-3.1-3.1-8.2-3.1-11.3 0zM160 416l240 0c32.9 0 61-23.5 80.5-58 5.9-10.4 11.1-22 15.5-34.6L496 488c0 22.1-17.9 40-40 40l-256 0c-22.1 0-40-17.9-40-40l0-72zM304 224c0-49.7 11.4-94.3 29.4-126.2 18.2-32.1 42-49.8 66.6-49.8s48.4 17.7 66.6 49.8c18 31.9 29.4 76.5 29.4 126.2s-11.4 94.3-29.4 126.2c-18.2 32.1-42 49.8-66.6 49.8s-48.4-17.7-66.6-49.8C315.4 318.3 304 273.7 304 224zm62 0c0 13.2 2.3 26 6.6 36 2.1 5 5.1 10 9.2 14.1 4.2 4.1 10.4 7.9 18.2 7.9s14.1-3.8 18.2-7.9c4.1-4 7-9.1 9.2-14.1 4.3-10 6.6-22.8 6.6-36s-2.3-26-6.6-36c-2.1-5-5.1-10-9.2-14.1-4.2-4.1-10.4-7.9-18.2-7.9s-14.1 3.8-18.2 7.9c-4.1 4-7 9.1-9.2 14.1-4.3 10-6.6 22.8-6.6 36z", "M16 224C16 174.3 27.4 129.7 45.4 97.8 63.6 65.7 87.4 48 112 48l242.8 0c-13.6 10.2-25.5 24.7-35.3 42-19.6 34.7-31.5 82.1-31.5 134s11.9 99.3 31.5 134c9.8 17.3 21.7 31.8 35.3 42L112 400c-24.6 0-48.4-17.7-66.6-49.8-18-31.9-29.4-76.5-29.4-126.2zM333.4 97.8C351.6 65.7 375.4 48 400 48s48.4 17.7 66.6 49.8c18 31.9 29.4 76.5 29.4 126.2s-11.4 94.3-29.4 126.2c-18.2 32.1-42 49.8-66.6 49.8s-48.4-17.7-66.6-49.8C315.4 318.3 304 273.7 304 224s11.4-94.3 29.4-126.2zM496 323.5L496 488c0 22.1-17.9 40-40 40l-256 0c-22.1 0-40-17.9-40-40l0-72 240 0c32.9 0 61-23.5 80.5-58 5.9-10.4 11.1-22 15.5-34.6zM144 416l0 72c0 30.9 25.1 56 56 56l256 0c30.9 0 56-25.1 56-56l0-264c0-51.9-11.9-99.3-31.5-134-19.5-34.5-47.6-58-80.5-58L112 32C79.1 32 51 55.5 31.5 90 11.9 124.7 0 172.1 0 224s11.9 99.3 31.5 134C51 392.5 79.1 416 112 416l32 0zM418.2 274.1c4.1-4 7-9.1 9.2-14.1 4.3-10 6.6-22.8 6.6-36s-2.3-26-6.6-36c-2.1-5-5.1-10-9.2-14.1-4.2-4.1-10.4-7.9-18.2-7.9s-14.1 3.8-18.2 7.9c-4.1 4-7 9.1-9.2 14.1-4.3 10-6.6 22.8-6.6 36s2.3 26 6.6 36c2.1 5 5.1 10 9.2 14.1 4.2 4.1 10.4 7.9 18.2 7.9s14.1-3.8 18.2-7.9zM400 266c-9.9 0-18-18.8-18-42s8.1-42 18-42 18 18.8 18 42-8.1 42-18 42zM94.8 277.8c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l53.8-53.8 53.8 53.8c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-53.8-53.8 53.8-53.8c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0l-53.8 53.8-53.8-53.8c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l53.8 53.8-53.8 53.8z"]],
    "temperature-low": [448, 512, [], "f76b", ["M32 368c0 70.7 57.3 128 128 128s128-57.3 128-128c0-39.1-17.5-74.1-45.2-97.6-1.8-1.5-2.8-3.7-2.8-6.1L240 96c0-44.2-35.8-80-80-80S80 51.8 80 96l0 168.3c0 2.3-1 4.6-2.8 6.1-27.7 23.5-45.2 58.5-45.2 97.6zm64 0c0-32.6 24.4-59.6 56-63.5l0-24.5c0-4.4 3.6-8 8-8s8 3.6 8 8l0 24.5c31.6 3.9 56 30.9 56 63.5 0 35.3-28.7 64-64 64s-64-28.7-64-64z", "M80 96c0-44.2 35.8-80 80-80s80 35.8 80 80l0 168.3c0 2.3 1 4.6 2.8 6.1 27.7 23.5 45.2 58.5 45.2 97.6 0 70.7-57.3 128-128 128S32 438.7 32 368c0-39.1 17.5-74.1 45.2-97.6 1.8-1.5 2.8-3.8 2.8-6.1L80 96zM160 0C107 0 64 43 64 96l0 164.7C34.6 287 16 325.4 16 368 16 447.5 80.5 512 160 512s144-64.5 144-144c0-42.6-18.6-81-48-107.3L256 96c0-53-43-96-96-96zM112 368a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm112 0c0-32.6-24.4-59.6-56-63.5l0-24.5c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 24.5c-31.6 3.9-56 30.9-56 63.5 0 35.3 28.7 64 64 64s64-28.7 64-64zM336 64a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm112 0a64 64 0 1 0 -128 0 64 64 0 1 0 128 0z"]],
    "h2": [576, 512, [], "f314", ["", "M48 72c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 368c0 4.4 3.6 8 8 8s8-3.6 8-8l0-176 192 0 0 176c0 4.4 3.6 8 8 8s8-3.6 8-8l0-368c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 176-192 0 0-176zm296-8c-4.4 0-8 3.6-8 8s3.6 8 8 8l123.6 0c37.8 0 68.4 30.6 68.4 68.4 0 24.2-12.8 46.6-33.6 58.9L386.7 275.9c-41.3 24.5-66.7 69-66.7 117l0 47.1c0 4.4 3.6 8 8 8l208 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-200 0 0-39.1c0-42.4 22.4-81.6 58.8-103.2l115.8-68.6c25.7-15.2 41.4-42.8 41.4-72.6 0-46.6-37.8-84.4-84.4-84.4L344 64z"]],
    "face-smile-halo": [512, 512, [], "e38f", ["M32 272c0-38.9 9.9-75.6 27.4-107.5 1.3 .4 2.7 .9 4 1.3 51.8 16.7 119.9 26.1 192.6 26.1s140.7-9.4 192.6-26.1c1.3-.4 2.7-.9 4-1.3 17.5 31.9 27.4 68.5 27.4 107.5 0 123.7-100.3 224-224 224S32 395.7 32 272zm88-16l0 16c0 4.4 3.6 8 8 8s8-3.6 8-8l0-16c0-22.1 17.9-40 40-40s40 17.9 40 40l0 16c0 4.4 3.6 8 8 8s8-3.6 8-8l0-16c0-30.9-25.1-56-56-56s-56 25.1-56 56zm16.6 102.1c27.8 35.3 71 57.9 119.4 57.9s91.6-22.7 119.4-57.9c2.7-3.5 2.1-8.5-1.3-11.2s-8.5-2.1-11.2 1.3C337.9 379.7 299.3 400 256 400s-81.9-20.3-106.8-51.8c-2.7-3.5-7.8-4.1-11.2-1.3s-4.1 7.8-1.3 11.2zM280 256l0 16c0 4.4 3.6 8 8 8s8-3.6 8-8l0-16c0-22.1 17.9-40 40-40s40 17.9 40 40l0 16c0 4.4 3.6 8 8 8s8-3.6 8-8l0-16c0-30.9-25.1-56-56-56s-56 25.1-56 56z", "M16 56c0 7.4 4.7 15.9 16.3 24.8 11.5 8.8 28.8 17.1 50.8 24.2 43.9 14.2 105 23 172.9 23s129-8.9 172.9-23c22-7.1 39.2-15.4 50.8-24.2 11.7-8.9 16.3-17.3 16.3-24.8s-4.7-15.9-16.3-24.8C468.1 22.4 450.9 14.1 428.9 7 385-7.1 323.9-16 256-16S127-7.1 83.1 7C61.1 14.1 43.9 22.4 32.3 31.2 20.7 40.1 16 48.6 16 56zM256-32c69.1 0 131.9 9 177.8 23.8 22.9 7.4 42 16.3 55.5 26.7 13.4 10.2 22.6 22.8 22.6 37.5s-9.2 27.3-22.6 37.5c-13.6 10.3-32.7 19.3-55.5 26.7-45.9 14.8-108.7 23.8-177.8 23.8s-131.9-9-177.8-23.8C55.3 112.8 36.2 103.8 22.6 93.5 9.2 83.3 0 70.7 0 56S9.2 28.7 22.6 18.5C36.2 8.2 55.3-.8 78.2-8.2 124.1-23 186.9-32 256-32zM44.2 159c5 2 10.1 3.8 15.2 5.5-17.5 31.9-27.4 68.5-27.4 107.5 0 123.7 100.3 224 224 224S480 395.7 480 272c0-38.9-9.9-75.6-27.4-107.5 5.1-1.7 10.2-3.6 15.2-5.5 18 33.7 28.2 72.1 28.2 113 0 132.5-107.5 240-240 240S16 404.5 16 272c0-40.8 10.2-79.3 28.2-113zm93.7 187.8c3.5-2.7 8.5-2.1 11.2 1.3 24.9 31.6 63.5 51.8 106.8 51.8s81.9-20.3 106.8-51.8c2.7-3.5 7.8-4.1 11.2-1.3s4.1 7.8 1.3 11.2C347.6 393.3 304.4 416 256 416s-91.6-22.7-119.4-57.9c-2.7-3.5-2.1-8.5 1.3-11.2zM136 256l0 16c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-16c0-30.9 25.1-56 56-56s56 25.1 56 56l0 16c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-16c0-22.1-17.9-40-40-40s-40 17.9-40 40zm200-40c-22.1 0-40 17.9-40 40l0 16c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-16c0-30.9 25.1-56 56-56s56 25.1 56 56l0 16c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-16c0-22.1-17.9-40-40-40z"]],
    "rocket-vertical": [448, 512, [], "e7bd", ["M39.1 374.7l26.2 95.9c3.2 11.9 18.1 15.8 26.7 7.1l75.7-75.7c-27-45.3-44.8-86.3-55.4-123.4L47.4 343.6c-8.1 8.1-11.3 20-8.2 31zm82.6-232c-14.4 59.5-5.6 140.4 58.6 249 26.6-17.6 61.5-17.6 88.1 0 64.2-108.6 72.9-189.5 58.6-249-15.1-62.7-56.7-105.3-94.8-133.6-4.7-3.5-11-3.5-15.7 0-38.1 28.4-79.6 70.9-94.8 133.6zM272.4 160a48 48 0 1 1 -96 0 48 48 0 1 1 96 0zm8.6 241.9l75.7 75.7c8.7 8.7 23.5 4.7 26.7-7.1l26.2-95.9c3-11.1-.1-22.9-8.2-31l-65.1-65.1c-10.6 37.1-28.4 78.1-55.4 123.4z", "M268.4 391.7c64.2-108.6 72.9-189.5 58.6-249-15.1-62.7-56.7-105.3-94.8-133.6-4.7-3.5-11-3.5-15.7 0-38.1 28.4-79.6 70.9-94.8 133.6-14.4 59.5-5.6 140.4 58.6 249 26.6-17.6 61.5-17.6 88.1 0zM167.8 401.9c-27-45.3-44.8-86.3-55.4-123.4L47.4 343.6c-8.1 8.1-11.3 20-8.2 31l26.2 95.9c3.2 11.9 18.1 15.8 26.7 7.1l75.7-75.7zm-60-141.4c-32.2-139.1 39.5-219.9 99.2-264.3 10.4-7.7 24.5-7.7 34.8 0 59.7 44.4 131.4 125.2 99.2 264.3l71.7 71.7c12.2 12.2 16.9 30 12.4 46.6l-26.2 95.9c-6.5 23.7-36.1 31.6-53.5 14.2l-75.8-75.8c-25-25-65.5-25-90.5 0L103.4 489c-17.4 17.4-47 9.5-53.5-14.2L23.7 378.9c-4.5-16.6 .2-34.4 12.4-46.6l71.7-71.7zm228.5 18c-10.6 37.1-28.4 78.1-55.4 123.4l75.7 75.7c8.7 8.7 23.5 4.7 26.7-7.1l26.2-95.9c3-11.1-.1-22.9-8.2-31l-65.1-65.1zM224.4 128a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm48 32a48 48 0 1 1 -96 0 48 48 0 1 1 96 0z"]],
    "door-open": [448, 512, [], "f52b", ["M48 64l0 432 256 0 0-432c0-26.5-21.5-48-48-48L96 16C69.5 16 48 37.5 48 64zM192 256c0-4.4 .9-8.6 2.5-12.5 .4-.9 .9-1.9 1.4-2.8 .5-.8 1-1.7 1.6-2.6 1.2-1.7 2.5-3.3 3.9-4.8 5.8-5.8 13.8-9.4 22.6-9.4 8.9 0 16.9 3.6 22.7 9.5 1.5 1.5 2.8 3.1 3.9 4.8 1 1.5 2 3.3 2.8 5.3 1.6 3.9 2.5 8.1 2.5 12.5 0 4.4-.9 8.6-2.5 12.5-.8 2-1.8 3.8-2.9 5.4-1.2 1.7-2.5 3.3-3.9 4.8-5.8 5.8-13.8 9.4-22.6 9.4-8.9 0-16.9-3.6-22.7-9.5-1.4-1.5-2.7-3.1-3.9-4.8-.5-.8-1-1.6-1.5-2.4-.5-1-1-1.9-1.4-2.8-1.6-3.8-2.5-8-2.5-12.5z", "M96 16l160 0c26.5 0 48 21.5 48 48l0 432-256 0 0-432c0-26.5 21.5-48 48-48zm202.3 0L352 16c26.5 0 48 21.5 48 48l0 440c0 4.4 3.6 8 8 8l32 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-24 0 0-432c0-35.3-28.7-64-64-64L96 0C60.7 0 32 28.7 32 64l0 432-24 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l312 0 0-448c0-19.1-8.4-36.3-21.7-48zM240 256a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm-16-32a32 32 0 1 0 0 64 32 32 0 1 0 0-64z"]],
    "align-left": [448, 512, [], "f036", ["", "M8 56c-4.4 0-8 3.6-8 8s3.6 8 8 8l272 0c4.4 0 8-3.6 8-8s-3.6-8-8-8L8 56zM8 184c-4.4 0-8 3.6-8 8s3.6 8 8 8l432 0c4.4 0 8-3.6 8-8s-3.6-8-8-8L8 184zM0 320c0 4.4 3.6 8 8 8l272 0c4.4 0 8-3.6 8-8s-3.6-8-8-8L8 312c-4.4 0-8 3.6-8 8zM8 440c-4.4 0-8 3.6-8 8s3.6 8 8 8l432 0c4.4 0 8-3.6 8-8s-3.6-8-8-8L8 440z"]],
    "pencil-slash": [576, 512, [], "e215", ["M236 192.6L320.7 108 436 223.3 351.4 308 236 192.6z", "M13.7-29.8c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l560 560c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-211-211 160.2-160.2C536.4 145.6 544 127.2 544 108s-7.6-37.6-21.2-51.1L487.1 21.2C473.6 7.6 455.2 0 436 0s-37.6 7.6-51.1 21.2L224.7 181.3 13.7-29.8zM236 192.6L320.7 108 436 223.3 351.4 308 236 192.6zM102.2 326.4l88.5-88.5-11.3-11.3-88.5 88.5c-10.7 10.7-18.5 24.1-22.6 38.7L32.9 481.6c-2.3 8.3 0 17.3 6.2 23.4s15.1 8.5 23.4 6.2l127.8-35.5c14.6-4.1 27.9-11.8 38.7-22.6l88.5-88.5-11.3-11.3-88.5 88.5c-.8 .7-1.5 1.5-2.3 2.2L100.1 328.7c.7-.8 1.4-1.5 2.2-2.3zM436 16c14.9 0 29.2 5.9 39.8 16.5l35.7 35.7C522.1 78.8 528 93.1 528 108s-5.9 29.2-16.5 39.8L447.3 212 332 96.7 396.2 32.5C406.8 21.9 421.1 16 436 16zM90.5 341.8L202.2 453.5c-5.1 2.9-10.5 5.2-16.2 6.7L58.1 495.7c-2.8 .8-5.8 0-7.8-2.1s-2.8-5-2.1-7.8L83.8 358.1c1.6-5.7 3.8-11.1 6.7-16.2z"]],
    "camera": [512, 512, [62258, "camera-alt"], "f030", ["M16 160l0 256c0 26.5 21.5 48 48 48l384 0c26.5 0 48-21.5 48-48l0-256c0-26.5-21.5-48-48-48l-66.7 0c-2.8 0-5.5-1.5-6.9-4L348.7 63.9C342.9 54 332.4 48 321 48L191 48c-11.4 0-21.9 6-27.6 15.9L137.6 108c-1.4 2.5-4.1 4-6.9 4L64 112c-26.5 0-48 21.5-48 48zM368 288a112 112 0 1 1 -224 0 112 112 0 1 1 224 0z", "M191 32c-17.1 0-32.9 9.1-41.5 23.8L126.1 96 64 96C28.7 96 0 124.7 0 160L0 416c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64l-62.1 0-23.4-40.2C353.9 41.1 338.1 32 321 32L191 32zM163.3 63.9C169.1 54 179.6 48 191 48l130 0c11.4 0 21.9 6 27.6 15.9L374.4 108c1.4 2.5 4.1 4 6.9 4l66.7 0c26.5 0 48 21.5 48 48l0 256c0 26.5-21.5 48-48 48L64 464c-26.5 0-48-21.5-48-48l0-256c0-26.5 21.5-48 48-48l66.7 0c2.8 0 5.5-1.5 6.9-4l25.8-44.2zM256 400a112 112 0 1 0 0-224 112 112 0 1 0 0 224zM160 288a96 96 0 1 1 192 0 96 96 0 1 1 -192 0z"]],
    "hat-winter": [512, 512, [], "f7a8", ["M56.1 384c4.9-29.7 12.3-59.7 22.6-87.9l47.2 18.9c22 8.8 47 6.2 66.7-6.9l32.5-21.7c18.8-12.5 43.3-12.5 62.1 0L319.5 308c19.7 13.2 44.7 15.8 66.7 6.9l47.2-18.9c10.2 28.3 17.6 58.3 22.6 87.9L56.1 384zM84.4 281.1c3.1-7.5 6.3-14.8 9.8-22 33-67.5 84.5-115.1 161.8-115.1s128.8 47.6 161.8 115.1c3.5 7.2 6.8 14.5 9.8 22l-47.4 18.9c-17.1 6.8-36.5 4.8-51.9-5.4L295.9 273c-24.2-16.1-55.7-16.1-79.9 0l-32.5 21.7c-15.3 10.2-34.7 12.2-51.9 5.4L84.4 281.1z", "M240.9 32.1c3.2-4.9 8.8-8.1 15-8.1s11.8 3.2 15 8.1c1.8 2.7 5.1 4.1 8.2 3.4 5.7-1.2 11.9 .5 16.3 4.9s6.1 10.6 4.9 16.3c-.6 3.2 .7 6.4 3.4 8.2 4.9 3.2 8.1 8.8 8.1 15s-3.2 11.8-8.1 15c-2.7 1.8-4.1 5.1-3.4 8.2 1.2 5.7-.5 11.9-4.9 16.3-5.5 5.5-13.6 6.7-20.2 3.6-2.7-1.2-5.9-.9-8.3 1-3.1 2.4-6.9 3.8-11.1 3.8s-8-1.4-11.1-3.8c-2.4-1.8-5.5-2.2-8.3-1-6.7 3.1-14.8 1.8-20.2-3.6-4.4-4.4-6.1-10.6-4.9-16.3 .6-3.2-.7-6.4-3.4-8.2-4.9-3.2-8.1-8.8-8.1-15s3.2-11.8 8.1-15c2.7-1.8 4.1-5.1 3.4-8.2-1.2-5.7 .5-11.9 4.9-16.3s10.6-6.1 16.3-4.9c3.2 .6 6.4-.7 8.2-3.4zM256 8c-10 0-19 4.3-25.2 11.2-9.2-.4-18.6 2.9-25.7 9.9s-10.4 16.5-9.9 25.7C188.3 61 184 70 184 80s4.3 19 11.2 25.2c-.4 9.2 2.9 18.6 9.9 25.7 1.1 1.1 2.4 2.2 3.6 3.1-102.3 27.1-151.5 142.3-169 250.7-22.6 3.9-39.7 23.6-39.7 47.3l0 32c0 26.5 21.5 48 48 48l416 0c26.5 0 48-21.5 48-48l0-32c0-23.7-17.2-43.4-39.7-47.3-17.5-108.5-66.6-223.6-169-250.8 1.2-.9 2.4-2 3.6-3.1 7.1-7.1 10.4-16.5 9.9-25.7 6.8-6.2 11.2-15.2 11.2-25.2s-4.3-19-11.2-25.2c.4-9.2-2.9-18.6-9.9-25.7s-16.5-10.4-25.7-9.9C274.9 12.3 265.9 8 256 8zM78.6 296.1l47.2 18.9c22 8.8 47 6.2 66.7-6.9l32.5-21.7c18.8-12.5 43.3-12.5 62.1 0L319.5 308c19.7 13.2 44.7 15.8 66.7 6.9l47.2-18.9c10.2 28.3 17.6 58.3 22.6 87.9L56.1 384c4.9-29.7 12.3-59.7 22.6-87.9zm5.7-14.9c3.1-7.5 6.3-14.8 9.8-22 33-67.5 84.5-115.1 161.8-115.1s128.8 47.6 161.8 115.1c3.5 7.2 6.8 14.5 9.8 22l-47.4 18.9c-17.1 6.8-36.5 4.8-51.9-5.4L295.9 273c-24.2-16.1-55.7-16.1-79.9 0l-32.5 21.7c-15.3 10.2-34.7 12.2-51.9 5.4L84.4 281.1zM48 496c-17.7 0-32-14.3-32-32l0-32c0-17.7 14.3-32 32-32l416 0c17.7 0 32 14.3 32 32l0 32c0 17.7-14.3 32-32 32L48 496z"]],
    "house-person-return": [640, 512, ["house-person-arrive", "house-return"], "e011", ["M64 151.3L64 312c0 13.3 10.7 24 24 24l216 0 0-32.8c-4.9 .5-9.8 .8-14.8 .8L256 304c-44.2 0-80-35.8-80-80s35.8-80 80-80l25.6 0c3.4-4.2 6.8-8.5 10.1-12.7L191.9 42.6 64 151.3z", "M473.9 190.5c-6 2.5-9.9 8.3-9.9 14.8l0 69.3c0 23.4-10.2 45.5-27.9 60.7l-71.4 61.2c-8.8 7.6-14.6 18.1-16.3 29.7l-12.6 88.1c-1.3 8.7-9.4 14.8-18.1 13.6s-14.8-9.4-13.6-18.1l12.6-88.1c2.7-19.2 12.4-36.8 27.1-49.4l34.5-29.6c3.5-3 5.6-7.5 5.6-12.1l0-115.2c0-6.8-4.3-12.8-10.7-15.1s-13.5-.2-17.8 5.1l-3.8 4.7c-15.2 19-38.2 30-62.5 30L256 240c-8.8 0-16-7.2-16-16s7.2-16 16-16l33.2 0c14.6 0 28.4-6.6 37.5-18l17.9-22.4c20-25 50.3-39.6 82.3-39.6 28 0 54.8 11.1 74.5 30.9l35.1 35.1c15 15 23.4 35.4 23.4 56.6l0 37.5c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-37.5c0-12.7-5.1-24.9-14.1-33.9l-22.6-22.6c-4.6-4.6-11.5-5.9-17.4-3.5zM416-16a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm80 237.3l6.6 6.6c6 6 9.4 14.1 9.4 22.6l0 37.5c0 17.7 14.3 32 32 32s32-14.3 32-32l0-37.5c0-25.5-10.1-49.9-28.1-67.9l-35.1-35.1c-22.8-22.8-53.6-35.6-85.8-35.6-36.9 0-71.8 16.8-94.8 45.6L314.2 180c-6.1 7.6-15.3 12-25 12L256 192c-17.7 0-32 14.3-32 32s14.3 32 32 32l33.2 0c23.2 0 45.5-8.4 62.8-23.4 4.4-3.8 8.5-8 12.2-12.7l3.8-4.7 0 115.2-34.5 29.6c-17.7 15.2-29.3 36.2-32.6 59.3l-12.6 88.1c-2.5 17.5 9.7 33.7 27.2 36.2s33.7-9.7 36.2-27.2l12.6-88.1c1.1-7.7 5-14.7 10.9-19.8l71.4-61.2c21.3-18.2 33.5-44.9 33.5-72.9l0-69.3 16 16zM360 24a56 56 0 1 0 112 0 56 56 0 1 0 -112 0zM480 371.4l-13.4 11.5 10.7 37.6 1 3.6 2.5 2.7 67 74.5c5.9 6.6 5.4 16.7-1.2 22.6s-16.7 5.4-22.6-1.2l-72-80c-1.6-1.8-2.8-4-3.5-6.3l-8.7-30.6-13.4 11.5 6.7 23.5c1.3 4.7 3.7 9 7 12.6l72 80c11.8 13.1 32.1 14.2 45.2 2.4s14.2-32.1 2.4-45.2l-67-74.5-12.8-44.7zM197.3 26c-3-2.6-7.5-2.7-10.5-.1l-160 136c-3.4 2.9-3.8 7.9-.9 11.3s7.9 3.8 11.3 .9L48 164.9 48 312c0 22.1 17.9 40 40 40l200 0 0-16-200 0c-13.3 0-24-10.7-24-24l0-160.7 127.9-108.7 99.8 88.7 3-3.7c2.3-2.9 4.8-5.8 7.3-8.5L197.3 26z"]],
    "knife": [512, 512, ["utensil-knife"], "f2e4", ["M235.4 288L472 51.5c35.9 40.9 34.3 103.1-4.7 142.1L321.1 339.7c-9.4 9.4-24.6 9.4-33.9 0L235.4 288z", "M466.5 34.3c3.1-3.1 8.2-3.1 11.3 0l.8 .8c46.9 46.9 46.9 122.8 0 169.7L332.4 351c-15.6 15.6-40.9 15.6-56.6 0L224.1 299.3 13.8 509.7c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l464-464zM235.4 288l51.7 51.7c9.4 9.4 24.6 9.4 33.9 0L467.3 193.5c39-39 40.6-101.2 4.7-142.1L235.4 288z"]],
    "message-exclamation": [512, 512, ["comment-alt-exclamation"], "f4a5", ["M16 128l0 224c0 44.2 35.8 80 80 80l32 0c8.8 0 16 7.2 16 16l0 75.8c0 3.1 4 5.2 6.5 3.4l126.6-89.4c5.4-3.8 11.9-5.8 18.5-5.8L416 432c44.2 0 80-35.8 80-80l0-224c0-44.2-35.8-80-80-80L96 48c-44.2 0-80 35.8-80 80zM272 352a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zM241.8 126.7c-.3-8 6.1-14.7 14.2-14.7l2.9 .3c6.6 1.4 11.5 7.4 11.3 14.4L264 288.3c-.2 4.3-3.7 7.7-8 7.7s-7.8-3.4-8-7.7l-6.2-161.6z", "M416 32c53 0 96 43 96 96l0 224c0 53-43 96-96 96l-120.4 0c-3.3 0-6.6 1-9.3 2.9L159.8 540.3c-3.4 2.4-7.4 3.7-11.6 3.7-11.1 0-20.2-9-20.2-20.2l0-75.8-32 0c-53 0-96-43-96-96L0 128C0 75 43 32 96 32l320 0zM96 48c-44.2 0-80 35.8-80 80l0 224c0 44.2 35.8 80 80 80l32 0c8.8 0 16 7.2 16 16l0 75.8c0 3.1 4 5.2 6.5 3.4l126.6-89.4c5.4-3.8 11.9-5.8 18.5-5.8L416 432c44.2 0 80-35.8 80-80l0-224c0-44.2-35.8-80-80-80L96 48zM256 368a16 16 0 1 1 0-32 16 16 0 1 1 0 32zm2.9-255.7c6.6 1.4 11.5 7.4 11.3 14.4L264 288.3c-.2 4.3-3.7 7.7-8 7.7s-7.8-3.4-8-7.7l-6.2-161.6c-.3-8 6.1-14.7 14.2-14.7l2.9 .3z"]],
    "right-to-line": [512, 512, ["arrow-alt-to-right"], "f34c", ["M16 240l0 32c0 17.7 14.3 32 32 32l152 0c4.4 0 8 3.6 8 8l0 88c0 3.2 1.9 6.2 4.9 7.4s6.4 .6 8.7-1.7l144-144c3.1-3.1 3.1-8.2 0-11.3l-144-144c-2.3-2.3-5.7-3-8.7-1.7s-4.9 4.2-4.9 7.4l0 88c0 4.4-3.6 8-8 8-46.7 0-97.3 0-152 0-17.7 0-32 14.3-32 32z", "M504 64c-4.4 0-8 3.6-8 8l0 368c0 4.4 3.6 8 8 8s8-3.6 8-8l0-368c0-4.4-3.6-8-8-8zM365.7 250.3c3.1 3.1 3.1 8.2 0 11.3l-144 144c-2.3 2.3-5.7 3-8.7 1.7s-4.9-4.2-4.9-7.4l0-88c0-4.4-3.6-8-8-8L48 304c-17.7 0-32-14.3-32-32l0-32c0-17.7 14.3-32 32-32l80 0 0 0 72 0c4.4 0 8-3.6 8-8l0-88c0-3.2 1.9-6.2 4.9-7.4s6.4-.6 8.7 1.7l144 144zM128 192l0 0-80 0c-26.5 0-48 21.5-48 48l0 32c0 26.5 21.5 48 48 48l144 0 0 80c0 9.7 5.8 18.5 14.8 22.2s19.3 1.7 26.2-5.2L377 273c9.4-9.4 9.4-24.6 0-33.9L233 95c-6.9-6.9-17.2-8.9-26.2-5.2S192 102.3 192 112l0 80-64 0z"]],
    "mailbox": [576, 512, [128234], "f813", ["M210 80l206 0c79.5 0 144 64.5 144 144l0 192c0 26.5-21.5 48-48 48l-245.7 0c13.3-11.7 21.7-28.9 21.7-48l0-208c0-55.7-31.7-104.1-78-128zM352 232c0 4.4 3.6 8 8 8l72 0 0 72c0 13.3 10.7 24 24 24l32 0c13.3 0 24-10.7 24-24l0-64c0-13.3-10.7-24-24-24l-128 0c-4.4 0-8 3.6-8 8z", "M210 80c46.3 23.9 78 72.3 78 128l0 208c0 19.1-8.4 36.3-21.7 48L512 464c26.5 0 48-21.5 48-48l0-192c0-79.5-64.5-144-144-144L210 80zm-66 0C73.3 80 16 137.3 16 208l0 208c0 26.5 21.5 48 48 48l160 0c26.5 0 48-21.5 48-48l0-208c0-70.7-57.3-128-128-128zm0-16l272 0c88.4 0 160 71.6 160 160l0 192c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 208C0 128.5 64.5 64 144 64zM80 224l128 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L80 240c-4.4 0-8-3.6-8-8s3.6-8 8-8zm272 8c0-4.4 3.6-8 8-8l128 0c13.3 0 24 10.7 24 24l0 64c0 13.3-10.7 24-24 24l-32 0c-13.3 0-24-10.7-24-24l0-72-72 0c-4.4 0-8-3.6-8-8zm96 8l0 72c0 4.4 3.6 8 8 8l32 0c4.4 0 8-3.6 8-8l0-64c0-4.4-3.6-8-8-8l-40 0z"]],
    "message-heart": [512, 512, [], "e5c9", ["M16 128l0 224c0 44.2 35.8 80 80 80l32 0c8.8 0 16 7.2 16 16l0 75.9c0 2.3 2 4 4.1 4.1 .8 0 1.7-.2 2.4-.7 3.3-2.3 6.3-4.5 9.1-6.4l.4-.3c6.7-4.7 30.4-21.5 117.2-82.7 5.4-3.8 11.8-5.9 18.5-5.9L416 432c44.2 0 80-35.8 80-80l0-224c0-44.2-35.8-80-80-80L96 48c-44.2 0-80 35.8-80 80zm128 93.3c0-33.9 27.5-61.3 61.3-61.3 19.3 0 37.5 9.1 49.1 24.5l1.6 2.1 1.6-2.1c11.6-15.4 29.8-24.5 49.1-24.5 33.9 0 61.3 27.5 61.3 61.3l0 2.7c0 32-22.8 60.8-45.8 82.1-23.4 21.6-49.1 37.3-58.5 42.7-4.8 2.8-10.6 2.8-15.4 0-9.5-5.5-35.1-21.1-58.5-42.7-23-21.3-45.8-50.1-45.8-82.1l0-2.7zm16 0l0 2.2c.2-25.4 20.2-46.1 45.3-47.6-25 0-45.3 20.3-45.3 45.3zM306.7 176c24.4 1.4 43.9 20.9 45.3 45.3 0-25-20.3-45.3-45.3-45.3z", "M144 448l0 75.9c0 2.3 2 4 4.1 4.1 .8 0 1.7-.2 2.4-.7 3.3-2.3 6.3-4.5 9.1-6.4l.4-.3c6.7-4.7 30.4-21.5 117.2-82.7 5.4-3.8 11.8-5.9 18.5-5.9L416 432c44.2 0 80-35.8 80-80l0-224c0-44.2-35.8-80-80-80L96 48c-44.2 0-80 35.8-80 80l0 224c0 44.2 35.8 80 80 80l32 0c8.8 0 16 7.2 16 16zM0 128C0 75 43 32 96 32l320 0c53 0 96 43 96 96l0 224c0 53-43 96-96 96l-120.4 0c-3.3 0-6.5 1-9.2 2.9L159.8 540.3c-3.4 2.4-7.5 3.7-11.6 3.7-11.1 0-20.1-9-20.1-20.1l0-75.9-32 0c-53 0-96-43-96-96L0 128zm160 93.3l0 2.7c0 24.8 18.1 49.5 40.6 70.4 21.9 20.2 46.1 35.1 55.4 40.5 9.3-5.4 33.5-20.2 55.4-40.5 22.5-20.8 40.6-45.6 40.6-70.4l0-2.7c0-25-20.3-45.3-45.3-45.3-14.3 0-27.7 6.7-36.3 18.1l-8 10.7c-1.5 2-3.9 3.2-6.4 3.2s-4.9-1.2-6.4-3.2l-8-10.7c-8.6-11.4-22-18.1-36.3-18.1-25 0-45.3 20.3-45.3 45.3zM205.3 160c19.3 0 37.5 9.1 49.1 24.5l1.6 2.1 1.6-2.1c11.6-15.4 29.8-24.5 49.1-24.5 33.9 0 61.3 27.5 61.3 61.3l0 2.7c0 32-22.8 60.8-45.8 82.1-23.4 21.6-49.1 37.3-58.5 42.7-4.8 2.8-10.6 2.8-15.4 0-9.5-5.5-35.1-21.1-58.5-42.7-23-21.3-45.8-50.1-45.8-82.1l0-2.7c0-33.9 27.5-61.3 61.3-61.3z"]],
    "message-middle-top": [512, 512, ["comment-middle-top-alt"], "e1e2", ["M16 160l0 224c0 44.2 35.8 80 80 80l320 0c44.2 0 80-35.8 80-80l0-224c0-44.2-35.8-80-80-80l-68 0c-10.1 0-19.6-4.7-25.6-12.8l-60-80c-1.5-2-3.9-3.2-6.4-3.2s-4.9 1.2-6.4 3.2l-60 80C183.6 75.3 174.1 80 164 80L96 80c-44.2 0-80 35.8-80 80z", "M0 384c0 53 43 96 96 96l320 0c53 0 96-43 96-96l0-224c0-53-43-96-96-96l-68 0c-5 0-9.8-2.4-12.8-6.4l-60-80c-4.5-6-11.6-9.6-19.2-9.6s-14.7 3.6-19.2 9.6l-60 80c-3 4-7.8 6.4-12.8 6.4L96 64C43 64 0 107 0 160L0 384zm96 80c-44.2 0-80-35.8-80-80l0-224c0-44.2 35.8-80 80-80l68 0c10.1 0 19.6-4.7 25.6-12.8l60-80c1.5-2 3.9-3.2 6.4-3.2s4.9 1.2 6.4 3.2l60 80c6 8.1 15.5 12.8 25.6 12.8l68 0c44.2 0 80 35.8 80 80l0 224c0 44.2-35.8 80-80 80L96 464z"]],
    "users-rays": [576, 512, [], "e593", ["M168 400c4.4 0 8-3.6 8-8l0-8c0-44.2 35.8-80 80-80l64 0c44.2 0 80 35.8 80 80l0 8c0 4.4 3.6 8 8 8l-240 0zM352 160a64 64 0 1 1 -128 0 64 64 0 1 1 128 0z", "M10.3-21.7c-3.1 3.1-3.1 8.2 0 11.3l56 56c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-56-56c-3.1-3.1-8.2-3.1-11.3 0zm555.3 0c-3.1-3.1-8.2-3.1-11.3 0l-56 56c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l56-56c3.1-3.1 3.1-8.2 0-11.3zM21.7 533.7l56-56c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0l-56 56c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0zm544 0c3.1-3.1 3.1-8.2 0-11.3l-56-56c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l56 56c3.1 3.1 8.2 3.1 11.3 0zM288 96a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm0 144a80 80 0 1 0 0-160 80 80 0 1 0 0 160zm-104 0c-30.9 0-56-25.1-56-56 0-23.5 14.5-43.7 35.1-52 1.4-6.3 3.3-12.5 5.6-18.4-32.4 7-56.7 35.9-56.7 70.4 0 39.8 32.2 72 72 72 5.9 0 11.6-.7 17.1-2-4.7-4.4-9.1-9.1-13.1-14.1-1.3 .1-2.6 .1-4 .1zm208 16c39.8 0 72-32.2 72-72 0-34.5-24.3-63.3-56.7-70.4 2.3 5.9 4.2 12.1 5.6 18.4 20.6 8.3 35.1 28.4 35.1 52 0 30.9-25.1 56-56 56-1.3 0-2.7 0-4-.1-4 5-8.4 9.7-13.1 14.1 5.5 1.3 11.2 2 17.1 2zM151.8 291.1C110.5 301.8 80 339.3 80 384l0 8c0 4.4 3.6 8 8 8s8-3.6 8-8l0-8c0-28.5 14.9-53.5 37.3-67.6 5.3-9.1 11.6-17.5 18.6-25.3zm290.9 25.3C465.1 330.5 480 355.5 480 384l0 8c0 4.4 3.6 8 8 8s8-3.6 8-8l0-8c0-44.7-30.5-82.2-71.8-92.9 7 7.8 13.2 16.2 18.6 25.3zM256 288c-53 0-96 43-96 96l0 8c0 4.4 3.6 8 8 8s8-3.6 8-8l0-8c0-44.2 35.8-80 80-80l64 0c44.2 0 80 35.8 80 80l0 8c0 4.4 3.6 8 8 8s8-3.6 8-8l0-8c0-53-43-96-96-96l-64 0z"]],
    "circles-overlap": [576, 512, [], "e600", ["M176 304c0 34.9 9.3 67.7 25.6 95.9 2.1 .1 4.2 .1 6.4 .1 106 0 192-86 192-192 0-34.9-9.3-67.7-25.6-95.9-2.1-.1-4.2-.1-6.4-.1-106 0-192 86-192 192z", "M400 208c0 106-86 192-192 192-2.1 0-4.3 0-6.4-.1-16.3-28.2-25.6-61-25.6-95.9 0-106 86-192 192-192 2.1 0 4.3 0 6.4 .1 16.3 28.2 25.6 61 25.6 95.9zM364 96c-113 2.1-204 94.4-204 208 0 34 8.1 66 22.6 94.3-94-12.4-166.6-92.9-166.6-190.3 0-106 86-192 192-192 64.3 0 121.1 31.6 156 80zm19.7 .5C346.8 38.5 281.9 0 208 0 93.1 0 0 93.1 0 208 0 317.6 84.8 407.4 192.3 415.4 229.2 473.5 294.1 512 368 512 482.9 512 576 418.9 576 304 576 194.4 491.2 104.6 383.7 96.6zm9.8 17.1c94 12.4 166.6 92.9 166.6 190.3 0 106-86 192-192 192-64.3 0-121.1-31.6-156-80 113-2.1 204-94.4 204-208 0-34-8.1-66-22.6-94.3z"]],
    "rainbow": [640, 512, [127752], "f75b", ["M8 448c4.4 0 8-3.6 8-8l0-88C16 184.1 152.1 48 320 48S624 184.1 624 352l0 88c0 4.4 3.6 8 8 8l-112 0c4.4 0 8-3.6 8-8l0-88c0-114.9-93.1-208-208-208S112 237.1 112 352l0 88c0 4.4 3.6 8 8 8L8 448zm112 0c4.4 0 8-3.6 8-8l0-88c0-106 86-192 192-192s192 86 192 192l0 88c0 4.4 3.6 8 8 8l-112 0c4.4 0 8-3.6 8-8l0-88c0-53-43-96-96-96s-96 43-96 96l0 88c0 4.4 3.6 8 8 8l-112 0z", "M320 48C152.1 48 16 184.1 16 352l0 88c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-88C0 175.3 143.3 32 320 32S640 175.3 640 352l0 88c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-88C624 184.1 487.9 48 320 48zm0 112c-106 0-192 86-192 192l0 88c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-88c0-114.9 93.1-208 208-208s208 93.1 208 208l0 88c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-88c0-106-86-192-192-192zM240 352l0 88c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-88c0-53 43-96 96-96s96 43 96 96l0 88c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-88c0-44.2-35.8-80-80-80s-80 35.8-80 80z"]],
    "box-arrow-down-arrow-up": [448, 512, [], "e795", ["M16.2 144c-.1 1.5-.2 3-.2 4.5L16 416c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-267.5c0-1.5-.1-3-.2-4.5L16.2 144zm4.4-16l195.4 0 0-96-103.1 0c-15.5 0-30.1 7.5-39.1 20.1L24.9 120.6c-1.7 2.3-3.1 4.8-4.3 7.4zM74.3 330.3c3.1-3.1 8.2-3.1 11.3 0L128 372.7 128 216c0-4.4 3.6-8 8-8s8 3.6 8 8l0 156.7 42.3-42.3 1.2-1c3.1-2.1 7.3-1.7 10.1 1s3.1 7 1 10.1l-1 1.3-56 56c-2.7 2.7-7 3.1-10.1 1l-1.2-1-56-56c-3.1-3.1-3.1-8.2 0-11.3zM232 32l0 96 195.4 0c-1.2-2.6-2.6-5-4.3-7.4L374.1 52.1c-7.9-11-20-18.1-33.3-19.8L335.1 32 232 32zm18.3 234.3l56-56 1.3-1c3.1-2.1 7.3-1.7 10.1 1l56 56 1 1.3c2.1 3.1 1.7 7.3-1 10.1s-7 3.1-10.1 1l-1.3-1-42.3-42.3 0 156.7c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-156.7-42.3 42.3c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3z", "M335.1 16c20.7 0 40.1 10 52.1 26.8l48.9 68.5c7.7 10.8 11.9 23.9 11.9 37.2l0 267.5-.3 6.5c-3.1 30.1-27 54.1-57.1 57.1l-6.5 .3-320 0-6.5-.3c-30.1-3.1-54.1-27-57.1-57.1L0 416 0 148.5c0-11.7 3.2-23.1 9.2-33l2.7-4.2 48.9-68.5c10.5-14.7 26.7-24.2 44.4-26.3l7.7-.5 222.1 0zM16 148.5L16 416c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-267.5c0-1.5-.1-3-.2-4.5L16.2 144c-.1 1.5-.2 3-.2 4.5zm291.6 60.8c3.1-2.1 7.3-1.7 10.1 1l56 56 1 1.3c2.1 3.1 1.7 7.3-1 10.1s-7 3.1-10.1 1l-1.3-1-42.3-42.3 0 156.7c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-156.7-42.3 42.3c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l56-56 1.3-1zM136 208c4.4 0 8 3.6 8 8l0 156.7 42.3-42.3 1.2-1c3.1-2.1 7.3-1.7 10.1 1s3.1 7 1 10.1l-1 1.3-56 56c-2.7 2.7-7 3.1-10.1 1l-1.2-1-56-56c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0L128 372.7 128 216c0-4.4 3.6-8 8-8zM112.9 32c-15.5 0-30.1 7.5-39.1 20.1L24.9 120.6c-1.7 2.3-3.1 4.8-4.3 7.4l195.4 0 0-96-103.1 0zM232 128l195.4 0c-1.2-2.6-2.6-5-4.3-7.4L374.1 52.1c-7.9-11-20-18.1-33.3-19.8l-5.8-.3-103.1 0 0 96z"]],
    "left-from-dotted-line": [512, 512, [], "e6c2", ["M18.3 250.3l144-144c2.3-2.3 5.7-3 8.7-1.7s4.9 4.2 4.9 7.4l0 88c0 4.4 3.6 8 8 8l152 0c17.7 0 32 14.3 32 32l0 32c0 17.7-14.3 32-32 32l-152 0c-4.4 0-8 3.6-8 8l0 88c0 3.2-1.9 6.2-4.9 7.4s-6.4 .6-8.7-1.7l-144-144c-3.1-3.1-3.1-8.2 0-11.3z", "M18.3 250.3l144-144c2.3-2.3 5.7-3 8.7-1.7s4.9 4.2 4.9 7.4l0 88c0 4.4 3.6 8 8 8l152 0c17.7 0 32 14.3 32 32l0 32c0 17.7-14.3 32-32 32l-152 0c-4.4 0-8 3.6-8 8l0 88c0 3.2-1.9 6.2-4.9 7.4l0 0c-3 1.2-6.4 .6-8.7-1.7l-144-144c-3.1-3.1-3.1-8.2 0-11.3zM256 320l80 0c26.5 0 48-21.5 48-48l0-32c0-26.5-21.5-48-48-48l-144 0 0-80c0-9.7-5.8-18.5-14.8-22.2S157.9 88.2 151 95L7 239 7 239c-9.4 9.4-9.4 24.6 0 33.9L151 417c6.9 6.9 17.2 8.9 26.2 5.2S192 409.7 192 400l0-80 64 0zM496 64a16 16 0 1 0 0 32 16 16 0 1 0 0-32zm0 88a16 16 0 1 0 0 32 16 16 0 1 0 0-32zM480 256a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm16 72a16 16 0 1 0 0 32 16 16 0 1 0 0-32zM480 432a16 16 0 1 0 32 0 16 16 0 1 0 -32 0z"]],
    "sitemap": [512, 512, [], "f0e8", ["M16 384l0 64c0 8.8 7.2 16 16 16l64 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16l-64 0c-8.8 0-16 7.2-16 16zM208 64l0 64c0 8.8 7.2 16 16 16l64 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16l-64 0c-8.8 0-16 7.2-16 16zm0 320l0 64c0 8.8 7.2 16 16 16l64 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16l-64 0c-8.8 0-16 7.2-16 16zm192 0l0 64c0 8.8 7.2 16 16 16l64 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16l-64 0c-8.8 0-16 7.2-16 16z", "M288 48c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16l-64 0c-8.8 0-16-7.2-16-16l0-64c0-8.8 7.2-16 16-16l64 0zM224 32c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32l24 0 0 80-136 0c-30.9 0-56 25.1-56 56l0 56-24 0c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-24 0 0-56c0-22.1 17.9-40 40-40l136 0 0 96-24 0c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-24 0 0-96 136 0c22.1 0 40 17.9 40 40l0 56-24 0c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-24 0 0-56c0-30.9-25.1-56-56-56l-136 0 0-80 24 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-64 0zM32 368l64 0c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16l-64 0c-8.8 0-16-7.2-16-16l0-64c0-8.8 7.2-16 16-16zm192 0l64 0c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16l-64 0c-8.8 0-16-7.2-16-16l0-64c0-8.8 7.2-16 16-16zm192 0l64 0c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16l-64 0c-8.8 0-16-7.2-16-16l0-64c0-8.8 7.2-16 16-16z"]],
    "caravan-simple": [640, 512, ["caravan-alt"], "e000", ["M48 96l0 256c0 26.5 21.5 48 48 48l43.3 0c10.4-36.9 44.4-64 84.7-64s74.2 27.1 84.7 64l219.3 0 0-240c0-61.9-50.1-112-112-112L96 48C69.5 48 48 69.5 48 96zm80 72c0-22.1 17.9-40 40-40l48 0c22.1 0 40 17.9 40 40l0 48c0 22.1-17.9 40-40 40l-48 0c-22.1 0-40-17.9-40-40l0-48zm192 0c0-22.1 17.9-40 40-40l48 0c22.1 0 40 17.9 40 40l0 48c0 22.1-17.9 40-40 40l-48 0c-22.1 0-40-17.9-40-40l0-48z", "M416 48c61.9 0 112 50.1 112 112l0 240-219.3 0c-10.4-36.9-44.4-64-84.7-64s-74.2 27.1-84.7 64L96 400c-26.5 0-48-21.5-48-48L48 96c0-26.5 21.5-48 48-48l320 0zM96 416l40.4 0c-.2 2.6-.4 5.3-.4 8 0 48.6 39.4 88 88 88s88-39.4 88-88c0-2.7-.1-5.4-.4-8L632 416c4.4 0 8-3.6 8-8s-3.6-8-8-8l-88 0 0-240c0-70.7-57.3-128-128-128L96 32C60.7 32 32 60.7 32 96l0 256c0 35.3 28.7 64 64 64zm72-272l48 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-48c0-13.3 10.7-24 24-24zm-40 24l0 48c0 22.1 17.9 40 40 40l48 0c22.1 0 40-17.9 40-40l0-48c0-22.1-17.9-40-40-40l-48 0c-22.1 0-40 17.9-40 40zm280-24c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-48c0-13.3 10.7-24 24-24l48 0zm-48-16c-22.1 0-40 17.9-40 40l0 48c0 22.1 17.9 40 40 40l48 0c22.1 0 40-17.9 40-40l0-48c0-22.1-17.9-40-40-40l-48 0zM224 352a72 72 0 1 1 0 144 72 72 0 1 1 0-144z"]],
    "face-grin-stars": [512, 512, [129321, "grin-stars"], "f587", ["M11.1 181.1c3.4-11.2 7.6-22.1 12.5-32.6 12.3 12 23.6 23 34.9 34.1l-8.2 47.7c-3.4 19.6 17.2 34.6 34.8 25.3L128 233 170.8 255.5c17.6 9.3 38.2-5.7 34.8-25.3l-8.2-47.7 34.6-33.8c14.2-13.9 6.4-38.1-13.3-40.9l-47.9-7-21.4-43.4c-8.8-17.8-34.2-17.8-43 0l-21.4 43.4-36.7 5.3c27.3-37.9 64.8-67.9 108.4-86.3 5.1 3 9.8 6.9 13.8 11.7 26.5-10.1 55.3-15.7 85.4-15.7s58.9 5.5 85.4 15.7c4-4.8 8.7-8.7 13.8-11.7 43.6 18.4 81 48.4 108.4 86.3l-36.7-5.3-21.4-43.4c-8.8-17.8-34.2-17.8-43 0l-21.4 43.4-47.9 7c-19.7 2.9-27.5 27.1-13.3 40.9l34.6 33.8-8.2 47.7c-3.4 19.6 17.2 34.6 34.8 25.3L384 233 426.8 255.5c17.6 9.3 38.2-5.7 34.8-25.3l-8.2-47.7 34.9-34.1c4.9 10.5 9 21.4 12.4 32.6l-13 12.7c5.3 19.9 8.2 40.7 8.2 62.3 0 132.5-107.5 240-240 240S16 388.5 16 256c0-21.5 2.8-42.4 8.2-62.3-4.3-4.2-8.7-8.5-13-12.7zm91.3 152.2C122 399.6 183.4 448 256 448s134-48.4 153.5-114.7c3.4-11.7-8.4-21-20-17.3-39.9 12.8-85.3 20-133.5 20s-93.6-7.2-133.5-20c-11.6-3.7-23.4 5.6-20 17.3z", "M496 256c0 132.5-107.5 240-240 240S16 388.5 16 256c0-21.5 2.8-42.4 8.2-62.3l0 0-13-12.7C3.9 204.8 0 229.9 0 256 0 397.4 114.6 512 256 512S512 397.4 512 256c0-26.1-3.9-51.2-11.1-74.9l-13 12.7 0 0c5.3 19.8 8.2 40.7 8.2 62.2zM256 16c30.1 0 58.9 5.5 85.4 15.7 4-4.8 8.7-8.7 13.8-11.7-30.5-12.9-64.1-20-99.3-20s-68.7 7.1-99.3 20c5.1 3 9.8 6.9 13.8 11.7 26.5-10.1 55.3-15.7 85.4-15.7zm0 336c49.3 0 96-7.3 137.3-20.4-18.5 58.2-73 100.4-137.3 100.4S137.2 389.8 118.7 331.6C160 344.7 206.7 352 256 352zm153.5-18.7c3.4-11.7-8.4-21-20-17.3-39.9 12.8-85.3 20-133.5 20s-93.6-7.2-133.5-20c-11.6-3.7-23.4 5.6-20 17.3 19.5 66.3 80.9 114.7 153.5 114.7s134-48.4 153.5-114.7zm-47-275.7l-21.4 43.4-47.9 7c-19.7 2.9-27.5 27.1-13.3 40.9l34.6 33.8-8.2 47.7c-3.4 19.6 17.2 34.6 34.8 25.3L384 233 426.8 255.5c17.6 9.3 38.2-5.7 34.8-25.3l-8.2-47.7 34.6-33.8c14.2-13.9 6.4-38.1-13.3-40.9l-47.9-7-21.4-43.4c-8.8-17.8-34.2-17.8-43 0zm28.7 7.1l23.3 47.2c1.2 2.4 3.4 4 6 4.4l52 7.6c6.6 1 9.2 9 4.4 13.6L439.3 174c-1.9 1.8-2.7 4.5-2.3 7.1l8.9 51.8c1.1 6.5-5.7 11.5-11.6 8.4l-46.5-24.5c-2.3-1.2-5.1-1.2-7.4 0l-46.5 24.5c-5.9 3.1-12.7-1.9-11.6-8.4l8.9-51.8c.4-2.6-.4-5.2-2.3-7.1l-37.7-36.7c-4.7-4.6-2.1-12.7 4.4-13.6l52-7.6c2.6-.4 4.9-2 6-4.4l23.3-47.2c2.9-5.9 11.4-5.9 14.3 0zM149.5 57.5c-8.8-17.8-34.2-17.8-43 0l-21.4 43.4-47.9 7c-19.7 2.9-27.5 27.1-13.3 40.9l34.6 33.8-8.2 47.7c-3.4 19.6 17.2 34.6 34.8 25.3L128 233 170.8 255.5c17.6 9.3 38.2-5.7 34.8-25.3l-8.2-47.7 34.6-33.8c14.2-13.9 6.4-38.1-13.3-40.9l-47.9-7-21.4-43.4zm-28.7 7.1c2.9-5.9 11.4-5.9 14.3 0l23.3 47.2c1.2 2.4 3.4 4 6 4.4l52 7.6c6.6 1 9.2 9 4.4 13.6L183.3 174c-1.9 1.8-2.7 4.5-2.3 7.1l8.9 51.8c1.1 6.5-5.7 11.5-11.6 8.4l-46.5-24.5c-2.3-1.2-5.1-1.2-7.4 0L77.7 241.4c-5.9 3.1-12.7-1.9-11.6-8.4L75 181.1c.4-2.6-.4-5.2-2.3-7.1L35.1 137.3c-4.7-4.6-2.1-12.7 4.4-13.6l52-7.6c2.6-.4 4.9-2 6-4.4l23.3-47.2z"]],
    "message-sms": [512, 512, [], "e1e5", ["M16 128l0 224c0 44.2 35.8 80 80 80l32 0c8.8 0 16 7.2 16 16l0 75.9c0 2.3 2 4 4.1 4.1 .8 0 1.7-.2 2.4-.7 3.3-2.3 6.3-4.5 9.1-6.4l.4-.3c6.7-4.7 30.4-21.5 117.2-82.7 5.4-3.8 11.8-5.9 18.5-5.9L416 432c44.2 0 80-35.8 80-80l0-224c0-44.2-35.8-80-80-80L96 48c-44.2 0-80 35.8-80 80zm72 80c0-22.1 17.9-40 40-40l24 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-24 0c-13.3 0-24 10.7-24 24s10.7 24 24 24c22.1 0 40 17.9 40 40s-17.9 40-40 40l-32 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l32 0c13.3 0 24-10.7 24-24s-10.7-24-24-24c-22.1 0-40-17.9-40-40zm112-32c0-3.6 2.4-6.7 5.9-7.7s7.1 .5 9 3.6l41.1 68.6 41.1-68.6c1.8-3.1 5.5-4.6 9-3.6s5.9 4.1 5.9 7.7l0 128c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-99.1-33.1 55.2c-1.4 2.4-4.1 3.9-6.9 3.9s-5.4-1.5-6.9-3.9L216 204.9 216 304c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-128zm144 32c0-22.1 17.9-40 40-40l24 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-24 0c-13.3 0-24 10.7-24 24s10.7 24 24 24c22.1 0 40 17.9 40 40s-17.9 40-40 40l-32 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l32 0c13.3 0 24-10.7 24-24s-10.7-24-24-24c-22.1 0-40-17.9-40-40z", "M144 448l0 75.9c0 2.3 2 4 4.1 4.1 .8 0 1.7-.2 2.4-.7 3.3-2.3 6.3-4.5 9.1-6.4l.4-.3c6.7-4.7 30.4-21.5 117.2-82.7 5.4-3.8 11.8-5.9 18.5-5.9L416 432c44.2 0 80-35.8 80-80l0-224c0-44.2-35.8-80-80-80L96 48c-44.2 0-80 35.8-80 80l0 224c0 44.2 35.8 80 80 80l32 0c8.8 0 16 7.2 16 16zM0 128C0 75 43 32 96 32l320 0c53 0 96 43 96 96l0 224c0 53-43 96-96 96l-120.4 0c-3.3 0-6.5 1-9.2 2.9L159.8 540.3c-3.4 2.4-7.5 3.7-11.6 3.7-11.1 0-20.1-9-20.1-20.1l0-75.9-32 0c-53 0-96-43-96-96L0 128zm128 40l24 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-24 0c-13.3 0-24 10.7-24 24s10.7 24 24 24c22.1 0 40 17.9 40 40s-17.9 40-40 40l-32 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l32 0c13.3 0 24-10.7 24-24s-10.7-24-24-24c-22.1 0-40-17.9-40-40s17.9-40 40-40zm216 40c0-22.1 17.9-40 40-40l24 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-24 0c-13.3 0-24 10.7-24 24s10.7 24 24 24c22.1 0 40 17.9 40 40s-17.9 40-40 40l-32 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l32 0c13.3 0 24-10.7 24-24s-10.7-24-24-24c-22.1 0-40-17.9-40-40zM214.9 171.9l41.1 68.6 41.1-68.6c1.8-3.1 5.5-4.6 9-3.6s5.9 4.1 5.9 7.7l0 128c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-99.1-33.1 55.2c-1.4 2.4-4.1 3.9-6.9 3.9s-5.4-1.5-6.9-3.9L216 204.9 216 304c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-128c0-3.6 2.4-6.7 5.9-7.7s7.1 .5 9 3.6z"]],
    "comments-question": [576, 512, [], "e14e", ["M16 144c0 33.3 11.2 64.2 30.4 89.9 3.2 4.3 4.1 10 2.2 15.1l-31.1 85.4 106.8-38.8c3.3-1.2 6.9-1.3 10.3-.2 17.9 5.6 37.2 8.7 57.3 8.7 98.5 0 176-72.9 176-160S290.5-16 192-16 16 56.9 16 144zm114.8-42.8C130.8 67.4 158.2 40 192 40s61.2 27.4 61.2 61.2c0 31.3-21 47.1-37.4 54.4-9.5 4.3-15.9 12.3-15.9 20.4 0 4.4-3.6 8-8 8s-8-3.6-8-8c0-16.6 12.3-29.2 25.3-35 13.6-6.1 27.9-17.5 27.9-39.8 0-25-20.2-45.2-45.2-45.2s-45.2 20.2-45.2 45.2c0 4.4-3.6 8-8 8s-8-3.6-8-8zM208 232a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm3.4 135.3c15.9 72.6 86.1 128.7 172.6 128.7 20.1 0 39.4-3.1 57.3-8.7 3.4-1 7-1 10.2 .2l106.8 38.8-31.1-85.4c-1.8-5.1-1-10.7 2.2-15.1 19.3-25.7 30.4-56.7 30.4-89.9 0-73.4-55-136.7-131.2-154.8-18.1 102.5-109.9 177.9-217.4 186.1z", "M46.4 233.9c3.2 4.3 4.1 10 2.2 15.1l-31.1 85.4 106.8-38.8c3.3-1.2 6.9-1.3 10.3-.2 17.9 5.6 37.2 8.7 57.3 8.7 98.5 0 176-72.9 176-160S290.5-16 192-16 16 56.9 16 144c0 33.3 11.2 64.2 30.4 89.9zm-12.8 9.6C12.4 215.2 0 180.9 0 144 0 46.8 86-32 192-32s192 78.8 192 176-86 176-192 176c-21.7 0-42.6-3.3-62.1-9.4L18.3 351.2c-1.5 .5-3.1 .8-4.6 .8-7.5 0-13.6-6.1-13.6-13.6 0-1.6 .3-3.2 .8-4.6l32.8-90.2zM195.2 368c5.4-.1 10.9-.3 16.2-.7 15.9 72.6 86.1 128.7 172.6 128.7 20.1 0 39.4-3.1 57.3-8.7 3.4-1 7-1 10.2 .2l106.8 38.8-31.1-85.4c-1.8-5.1-1-10.7 2.2-15.1 19.3-25.7 30.4-56.7 30.4-89.9 0-73.4-55-136.7-131.2-154.8 .9-5.2 1.7-10.5 2.2-15.9 83.3 19.2 145 88.3 145 170.7 0 36.9-12.4 71.2-33.6 99.5l32.8 90.2c.5 1.5 .8 3.1 .8 4.6 0 7.5-6.1 13.6-13.6 13.6-1.6 0-3.2-.3-4.6-.8L446.1 502.6c-19.5 6.1-40.4 9.4-62.1 9.4-94.1 0-172.4-62.1-188.8-144zM192 56c-25 0-45.2 20.2-45.2 45.2 0 4.4-3.6 8-8 8s-8-3.6-8-8C130.8 67.4 158.2 40 192 40s61.2 27.4 61.2 61.2c0 31.3-21 47.1-37.4 54.4-9.5 4.3-15.9 12.3-15.9 20.4 0 4.4-3.6 8-8 8s-8-3.6-8-8c0-16.6 12.3-29.2 25.3-35 13.6-6.1 27.9-17.5 27.9-39.8 0-25-20.2-45.2-45.2-45.2zM176 232a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"]],
    "sort-up": [384, 512, ["sort-asc"], "f0de", ["M16 190.9c.6 9 7.3 16.1 16 17.1 .6 0 1.3 0 1.9 0 105.4 0 210.7 0 316.1 0 .7 0 1.3 0 1.9 0 8.6-1 15.4-8.1 16-17.1-.3-3.8-1.9-7.4-4.6-10.2l-160-160c-2.7-2.7-6.1-4.2-9.6-4.6-.6-.1-1.1-.1-1.7-.1s-1.1 0-1.7 .1c-3.5 .4-6.9 1.9-9.6 4.6l-160 160c-2.8 2.8-4.4 6.5-4.7 10.2z", "M176 22.6c4.2-4.2 10-6.6 16-6.6s11.8 2.4 16 6.6L362.7 177.4c3.4 3.4 5.3 7.9 5.3 12.7 0 9.9-8 17.9-17.9 17.9L33.9 208c-9.9 0-17.9-8-17.9-17.9 0-4.8 1.9-9.3 5.3-12.7L176 22.6zM164.7 11.3L9.9 166.1c-6.4 6.4-9.9 15-9.9 24 0 18.7 15.2 33.9 33.9 33.9l316.1 0c18.7 0 33.9-15.2 33.9-33.9 0-9-3.6-17.6-9.9-24L219.3 11.3C212.1 4.1 202.2 0 192 0s-20.1 4.1-27.3 11.3z"]],
    "billboard": [576, 512, [], "e5cd", ["M48 128l0 272 480 0 0-272c0-26.5-21.5-48-48-48l-88 0 0 64 40 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-96 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l40 0 0-64-176 0 0 64 40 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-96 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l40 0 0-64-88 0c-26.5 0-48 21.5-48 48z", "M384 32c4.4 0 8 3.6 8 8l0 24 88 0c35.3 0 64 28.7 64 64l0 272 24 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-272 0 0 88c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-88-272 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l24 0 0-272c0-35.3 28.7-64 64-64l88 0 0-24c0-4.4 3.6-8 8-8s8 3.6 8 8l0 24 176 0 0-24c0-4.4 3.6-8 8-8zM288 400l240 0 0-272c0-26.5-21.5-48-48-48l-88 0 0 64 40 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-96 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l40 0 0-64-176 0 0 64 40 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-96 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l40 0 0-64-88 0c-26.5 0-48 21.5-48 48l0 272 240 0z"]],
    "eye": [576, 512, [128065], "f06e", ["M176.5 266.7c5.4 56.8 53.3 101.3 111.5 101.3 61.9 0 112-50.1 112-112 0-58.2-44.5-106.1-101.3-111.5 3.4 9.9 5.3 20.5 5.3 31.5 0 53-43 96-96 96-11 0-21.6-1.9-31.5-5.3z", "M288 48c-75.6 0-136.6 34.4-181.7 76.3-44.9 41.7-75 91.7-89.1 125.6-1.6 3.9-1.6 8.4 0 12.3 14.1 33.9 44.1 83.8 89.1 125.6 45.1 41.9 106.1 76.3 181.7 76.3s136.6-34.4 181.7-76.3c44.9-41.7 75-91.7 89.1-125.6 1.6-3.9 1.6-8.4 0-12.3-14.1-33.9-44.1-83.8-89.1-125.6-45.1-41.9-106.1-76.3-181.7-76.3zM95.4 112.6C142.5 68.8 207.2 32 288 32s145.5 36.8 192.6 80.6c46.8 43.5 78.1 95.4 93 131.1 3.3 7.9 3.3 16.7 0 24.6-14.9 35.7-46.2 87.7-93 131.1-47.1 43.7-111.8 80.6-192.6 80.6S142.5 443.2 95.4 399.4c-46.8-43.5-78.1-95.4-93-131.1-3.3-7.9-3.3-16.7 0-24.6 14.9-35.7 46.2-87.7 93-131.1zM288 368c61.9 0 112-50.1 112-112 0-58.2-44.5-106.1-101.3-111.5 3.4 9.9 5.3 20.5 5.3 31.5 0 53-43 96-96 96-11 0-21.6-1.9-31.5-5.3 5.4 56.8 53.3 101.3 111.5 101.3zM160 256c0-5 .3-9.9 .8-14.7l.1-.6c7-58.4 53.3-104.8 111.8-111.8 5-.6 10.1-.9 15.3-.9l.4 0c.9 0 1.9 0 2.8 0 69.2 1.7 124.8 58.3 124.8 128 0 70.7-57.3 128-128 128S160 326.7 160 256zm16.2-6.6c9.7 4.2 20.5 6.6 31.8 6.6 44.2 0 80-35.8 80-80 0-11.3-2.3-22.1-6.6-31.8-56.6 3.3-102 48.6-105.2 105.2z"]],
    "arrow-down-small-big": [512, 512, ["sort-size-down-alt"], "f88d", ["M304 80c0-17.7 14.3-32 32-32l64 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-64zm0 224c0-17.7 14.3-32 32-32l128 0c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32l-128 0c-17.7 0-32-14.3-32-32l0-128z", "M237.7 373.7l-104 104c-3.1 3.1-8.2 3.1-11.3 0l-104-104c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0L120 452.7 120 40c0-4.4 3.6-8 8-8s8 3.6 8 8l0 412.7 90.3-90.3c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3zM304 80l0 64c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-64 0c-17.7 0-32 14.3-32 32zm-16 0c0-26.5 21.5-48 48-48l64 0c26.5 0 48 21.5 48 48l0 64c0 26.5-21.5 48-48 48l-64 0c-26.5 0-48-21.5-48-48l0-64zm16 224l0 128c0 17.7 14.3 32 32 32l128 0c17.7 0 32-14.3 32-32l0-128c0-17.7-14.3-32-32-32l-128 0c-17.7 0-32 14.3-32 32zm-16 0c0-26.5 21.5-48 48-48l128 0c26.5 0 48 21.5 48 48l0 128c0 26.5-21.5 48-48 48l-128 0c-26.5 0-48-21.5-48-48l0-128z"]],
    "axe": [640, 512, [129683], "f6b2", ["M53.7 453.7c-10.1 10.1-10.1 26.6 0 36.7s26.6 10.1 36.7 0l240-240-36.7-36.7-240 240zM247.6 111c-9.4 9.4-9.4 24.6 0 33.9L393 290.3c4.5 4.5 7 10.6 7 17l0 84.7c0 4.4 3.6 8 8 8l8 0c114.9 0 208-93.1 208-208l0-8c0-4.4-3.6-8-8-8l-84.7 0c-6.4 0-12.5-2.5-17-7L369 23.6c-9.4-9.4-24.6-9.4-33.9 0L247.6 111zM437.7 69.7l36.7 36.7 23-23c6.2-6.2 6.2-16.4 0-22.6L483.3 46.6c-6.2-6.2-16.4-6.2-22.6 0l-23 23z", "M514.3 169L369 23.6c-9.4-9.4-24.6-9.4-33.9 0L247.6 111c-9.4 9.4-9.4 24.6 0 33.9L393 290.3c4.5 4.5 7 10.6 7 17l0 84.7c0 4.4 3.6 8 8 8l8 0c114.9 0 208-93.1 208-208l0-8c0-4.4-3.6-8-8-8l-84.7 0c-6.4 0-12.5-2.5-17-7zm-28.7-51.3l40 40c1.5 1.5 3.5 2.3 5.7 2.3l84.7 0c13.3 0 24 10.7 24 24l0 8c0 123.7-100.3 224-224 224l-8 0c-13.3 0-24-10.7-24-24l0-84.7c0-2.1-.8-4.2-2.3-5.7l-40-40-240 240c-16.4 16.4-42.9 16.4-59.3 0s-16.4-42.9 0-59.3l240-240-46.1-46.1c-15.6-15.6-15.6-40.9 0-56.6l87.4-87.4c15.6-15.6 40.9-15.6 56.6 0l46.1 46.1 23-23c12.5-12.5 32.8-12.5 45.3 0l14.1 14.1c12.5 12.5 12.5 32.8 0 45.3l-23 23zm-11.3-11.3l23-23c6.2-6.2 6.2-16.4 0-22.6L483.3 46.6c-6.2-6.2-16.4-6.2-22.6 0l-23 23 36.7 36.7zM293.7 213.7l-240 240c-10.1 10.1-10.1 26.6 0 36.7s26.6 10.1 36.7 0l240-240-36.7-36.7z"]],
    "caret-left": [256, 512, [], "f0d9", ["M21 267.3c-5.8-5.8-6.2-15.5 .5-23.1L149 116.7c4.6-4.6 11.5-5.9 17.4-3.5s9.9 8.3 9.9 14.8l0 256c0 6.5-3.9 12.3-9.9 14.8s-12.9 1.1-17.4-3.5L21 267.3z", "M9.7 233.4c-11.6 12.9-12.8 32.4 0 45.2l128 128c9.1 9.2 22.9 11.9 34.9 6.9l4.3-2.2c9.5-5.7 15.5-16.1 15.5-27.4l0-256-.3-4.8c-1.4-9.4-7-17.7-15.1-22.6l-4.3-2.2c-10.5-4.3-22.3-2.8-31.2 3.8l-3.7 3.1-128 128zM21 267.3c-5.8-5.8-6.2-15.5 .5-23.1L149 116.7c4.6-4.6 11.5-5.9 17.4-3.5s9.9 8.3 9.9 14.8l0 256c0 6.5-3.9 12.3-9.9 14.8s-12.9 1.1-17.4-3.5L21 267.3z"]],
    "apple-whole": [448, 512, [127822, 127823, "apple-alt"], "f5d1", ["M16 288c0-36 8.5-72.9 25.1-100.3 16.3-27 39.7-43.7 70.9-43.7 24.1 0 54.2 9.4 76.9 18.2 22.5 8.8 47.8 8.8 70.3 0 22.7-8.8 52.7-18.2 76.9-18.2 31.2 0 54.6 16.7 70.9 43.7 16.6 27.4 25.1 64.3 25.1 100.3 0 60.7-19 113.3-46.8 150.4-28 37.3-63.7 57.6-97.2 57.6-9.5 0-22.2-2.8-34.1-6.4-19.4-5.8-40.3-5.8-59.7 0-11.9 3.6-24.7 6.4-34.1 6.4-33.5 0-69.2-20.3-97.2-57.6-27.8-37.1-46.8-89.7-46.8-150.4zM224 80c0-35.3 28.7-64 64-64l16 0 0 16c0 35.3-28.7 64-64 64l-16 0 0-16z", "M240 96l-16 0 0-16c0-35.3 28.7-64 64-64l16 0 0 16c0 35.3-28.7 64-64 64zm0 16c44.2 0 80-35.8 80-80l0-16c0-8.8-7.2-16-16-16L288 0c-44.2 0-80 35.8-80 80l0 16c0 8.8 7.2 16 16 16l16 0zM16 288c0-36 8.5-72.9 25.1-100.3 16.3-27 39.7-43.7 70.9-43.7 24.1 0 54.2 9.4 76.9 18.2 22.5 8.8 47.8 8.8 70.3 0 22.7-8.8 52.7-18.2 76.9-18.2 31.2 0 54.6 16.7 70.9 43.7 16.6 27.4 25.1 64.3 25.1 100.3 0 60.7-19 113.3-46.8 150.4-28 37.3-63.7 57.6-97.2 57.6-9.5 0-22.2-2.8-34.1-6.4-19.4-5.8-40.3-5.8-59.7 0-11.9 3.6-24.7 6.4-34.1 6.4-33.5 0-69.2-20.3-97.2-57.6-27.8-37.1-46.8-89.7-46.8-150.4zm96-160c-76.3 0-112 83.7-112 160 0 128 80 224 160 224 11.9 0 26.5-3.4 38.8-7.1 16.4-4.9 34.1-4.9 50.5 0 12.2 3.7 26.8 7.1 38.8 7.1 80 0 160-96 160-224 0-76.3-35.7-160-112-160-27.3 0-59.7 10.3-82.7 19.3-18.8 7.3-39.9 7.3-58.7 0-22.9-8.9-55.4-19.3-82.7-19.3z"]],
    "scroll-torah": [576, 512, ["torah"], "f6a0", ["M16 72l0 368c0 21.1 16.4 38.4 37.1 39.9 1.9 .1 3.9 .1 5.7 0 20.8-1.5 37.2-18.8 37.2-39.9L96 72C96 50.9 79.6 33.5 58.8 32.1 57 32 55 32 53.1 32.1 32.4 33.6 16 50.9 16 72zm96-8l0 384 352 0 0-384-352 0zm73 140.1c1.4-2.6 4.1-4.1 7-4.1l56.2 0 33-52.3c1.5-2.3 4-3.7 6.8-3.7s5.3 1.4 6.8 3.7l33 52.3 56.2 0c2.9 0 5.6 1.6 7 4.1s1.3 5.7-.2 8.1l-27.6 43.7 27.6 43.7c1.6 2.5 1.6 5.6 .2 8.1s-4.1 4.1-7 4.1l-56.2 0-33 52.3c-1.5 2.3-4 3.7-6.8 3.7s-5.3-1.4-6.8-3.7l-33-52.3-56.2 0c-2.9 0-5.6-1.6-7-4.1s-1.3-5.7 .2-8.1l27.6-43.7-27.6-43.7c-1.6-2.5-1.6-5.6-.2-8.1zM480 72l0 368c0 21.1 16.4 38.4 37.2 39.9 1.9 .1 3.8 .1 5.7 0 20.7-1.5 37.1-18.8 37.1-39.9l0-368c0-21.1-16.4-38.4-37.1-39.9-1.9-.1-3.9-.1-5.7 0-20.8 1.5-37.2 18.8-37.2 39.9z", "M96 72l0 368c0 22.1-17.9 40-40 40s-40-17.9-40-40L16 72c0-22.1 17.9-40 40-40S96 49.9 96 72zM56 496c22.3 0 41.6-13.1 50.6-32l362.8 0c9 18.9 28.3 32 50.6 32 30.9 0 56-25.1 56-56l0-368c0-30.9-25.1-56-56-56-22.3 0-41.6 13.1-50.6 32L106.6 48C97.6 29.1 78.3 16 56 16 25.1 16 0 41.1 0 72L0 440c0 30.9 25.1 56 56 56zM480 72c0-22.1 17.9-40 40-40s40 17.9 40 40l0 368c0 22.1-17.9 40-40 40s-40-17.9-40-40l0-368zm-16 0l0 376-352 0 0-384 352 0 0 8zM294.8 147.7c-1.5-2.3-4-3.7-6.8-3.7s-5.3 1.4-6.8 3.7l-33 52.3-56.2 0c-2.9 0-5.6 1.6-7 4.1s-1.3 5.7 .2 8.1l27.6 43.7-27.6 43.7c-1.6 2.5-1.6 5.6-.2 8.1s4.1 4.1 7 4.1l56.2 0 33 52.3c1.5 2.3 4 3.7 6.8 3.7s5.3-1.4 6.8-3.7l33-52.3 56.2 0c2.9 0 5.6-1.6 7-4.1s1.3-5.7-.2-8.1l-27.6-43.7 27.6-43.7c1.6-2.5 1.6-5.6 .2-8.1s-4.1-4.1-7-4.1l-56.2 0-33-52.3zm-35.4 64.5L288 167 316.6 212.3c1.5 2.3 4 3.7 6.8 3.7l46.1 0-22.6 35.7c-1.6 2.6-1.6 5.9 0 8.5l22.6 35.7-46.1 0c-2.7 0-5.3 1.4-6.8 3.7L288 345 259.4 299.7c-1.5-2.3-4-3.7-6.8-3.7l-46.1 0 22.6-35.7c1.6-2.6 1.6-5.9 0-8.5l-22.6-35.7 46.1 0c2.7 0 5.3-1.4 6.8-3.7z"]],
    "house-lock": [640, 512, [], "e510", ["M96 198.1L288 18.9 472.2 190.9C438.6 210.2 416 246.5 416 288l0 28.7c-28.7 16.6-48 47.6-48 83.2l0-23.9c0-30.9-25.1-56-56-56l-48 0c-30.9 0-56 25.1-56 56l0 120-72 0c-22.1 0-40-17.9-40-40l0-257.9z", "M277.1 7.2c6.1-5.7 15.7-5.7 21.8 0L487.7 183.5c-5.4 2.1-10.6 4.6-15.5 7.4L288 18.9 96 198.1 96 456c0 22.1 17.9 40 40 40l72 0 0-120c0-30.9 25.1-56 56-56l48 0c30.9 0 56 25.1 56 56l0 120c0 5.5 .5 10.8 1.3 16L136 512c-30.9 0-56-25.1-56-56l0-242.9-26.5 24.8c-3.2 3-8.3 2.8-11.3-.4s-2.8-8.3 .4-11.3L277.1 7.2zM224 496l128 0 0-120c0-22.1-17.9-40-40-40l-48 0c-22.1 0-40 17.9-40 40l0 120zM576 288.1c0-26.5-21.5-48-48-48s-48 21.5-48 48l0 63.9 96 0 0-63.9zM432 400l0 96c0 17.7 14.3 32 32 32l128 0c17.7 0 32-14.3 32-32l0-96c0-17.7-14.3-32-32-32l0 .1-128 0 0-.1c-17.7 0-32 14.3-32 32zM592 288.1l0 63.9c26.5 0 48 21.5 48 48l0 96c0 26.5-21.5 48-48 48l-128 0c-26.5 0-48-21.5-48-48l0-96c0-26.5 21.5-48 48-48l0-63.9c0-35.3 28.7-64 64-64s64 28.7 64 64z"]],
    "square-litecoin": [448, 512, [], "e6f7", ["M16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96zM120.4 258.5c-1.4-4.2 .9-8.7 5.1-10.1l50.5-16.8 0-95.6c0-4.4 3.6-8 8-8s8 3.6 8 8l0 90.2 77.5-25.8c4.2-1.4 8.7 .9 10.1 5.1s-.9 8.7-5.1 10.1l-82.5 27.5 0 124.9 120 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-128 0c-2.1 0-4.2-.8-5.7-2.3s-2.3-3.5-2.3-5.7l0-127.6-45.5 15.2c-4.2 1.4-8.7-.9-10.1-5.1z", "M64 48C37.5 48 16 69.5 16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm184 32c4.4 0 8 3.6 8 8l0 90.2 77.5-25.8c4.2-1.4 8.7 .9 10.1 5.1s-.9 8.7-5.1 10.1l-82.5 27.5 0 124.9 120 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-128 0c-2.1 0-4.2-.8-5.7-2.3s-2.3-3.5-2.3-5.7l0-127.6-45.5 15.2c-4.2 1.4-8.7-.9-10.1-5.1s.9-8.7 5.1-10.1l50.5-16.8 0-95.6c0-4.4 3.6-8 8-8z"]],
    "arrows-left-right-to-line": [576, 512, [], "e4ba", ["", "M16 104l0 304c0 4.4-3.6 8-8 8s-8-3.6-8-8L0 104c0-4.4 3.6-8 8-8s8 3.6 8 8zm560 0l0 304c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-304c0-4.4 3.6-8 8-8s8 3.6 8 8zM493.7 261.7l-88 88c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l74.3-74.3-361.4 0 74.3 74.3c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-88-88c-3.1-3.1-3.1-8.2 0-11.3l88-88c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3l-74.3 74.3 361.4 0-74.3-74.3c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0l88 88c3.1 3.1 3.1 8.2 0 11.3z"]],
    "trash": [448, 512, [], "f1f8", ["M43.6 128l24 323.5c1.9 25.1 22.7 44.5 47.9 44.5l217.1 0c25.1 0 46-19.4 47.9-44.5l24-323.5-360.8 0zm88.2-64l184.4 0-19.6-48.9C293 6 284.1 0 274.3 0L173.7 0c-9.8 0-18.6 6-22.3 15.1L131.8 64z", "M173.7 0c-9.8 0-18.6 6-22.3 15.1L131.8 64 316.2 64 296.6 15.1C293 6 284.1 0 274.3 0L173.7 0zM136.5 9.1C142.6-6 157.3-16 173.7-16l100.7 0c16.4 0 31.1 10 37.1 25.1L333.4 64 440 64c4.4 0 8 3.6 8 8s-3.6 8-8 8L8 80c-4.4 0-8-3.6-8-8s3.6-8 8-8l106.6 0 21.9-54.9zM51.6 452.7l-24.1-324.7 16 0 24 323.5c1.9 25.1 22.7 44.5 47.9 44.5l217.1 0c25.1 0 46-19.4 47.9-44.5l24-323.5 16 0-24.1 324.7c-2.5 33.4-30.3 59.3-63.8 59.3l-217.1 0c-33.5 0-61.3-25.9-63.8-59.3z"]],
    "face-sad-tear": [512, 512, [128546, "sad-tear"], "f5b4", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zM120 358.4c0-19.4 13.1-38.3 23.6-53.4 6.7-9.6 13.8-18.8 21.4-27.6 6-7 15.9-7 21.9 0 7.6 8.8 14.7 18.1 21.4 27.6 10.5 15.1 23.6 34 23.6 53.4 0 31.8-25.1 57.6-56 57.6s-56-25.8-56-57.6zM192 208a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm80.5 113.1c5.1-.8 10.2-1.1 15.5-1.1 36.2 0 68 18.5 86.7 46.5 2.4 3.7 1.4 8.6-2.2 11.1s-8.6 1.4-11.1-2.2c-15.8-23.7-42.7-39.3-73.3-39.3-3.6 0-7.2 .2-10.6 .6-1.2-5.3-2.9-10.5-4.9-15.5zM352 208a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM192 208a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm144 16a16 16 0 1 0 0-32 16 16 0 1 0 0 32zM195.3 314.2c5.3 7.6 10.6 15.3 14.6 23.1s6.1 14.9 6.1 21c0 23.4-18.3 41.6-40 41.6s-40-18.2-40-41.6c0-6.2 2.1-13.2 6.1-21s9.3-15.5 14.6-23.1c6-8.6 12.5-17 19.3-25 6.8 8 13.2 16.4 19.3 25zM165 277.4c-7.6 8.8-14.7 18.1-21.4 27.6-10.5 15.1-23.6 34-23.6 53.4 0 31.8 25.1 57.6 56 57.6s56-25.8 56-57.6c0-19.4-13.1-38.3-23.6-53.4-6.7-9.6-13.8-18.8-21.4-27.6-6-7-15.9-7-21.9 0zM288 336c30.6 0 57.6 15.6 73.3 39.3 2.4 3.7 7.4 4.7 11.1 2.2s4.7-7.4 2.2-11.1c-18.6-28-50.5-46.5-86.7-46.5-5.3 0-10.4 .4-15.5 1.1 2 5 3.6 10.2 4.9 15.5 3.5-.4 7-.6 10.6-.6z"]],
    "tire-flat": [512, 512, [], "f632", ["M16 288c0 42.4 11 82.2 30.3 116.8 6 10.8 2.5 23.4-5.8 30.3L25.9 447.2c-6.3 5.2-9.9 13-9.9 21.2 0 15.2 12.4 27.6 27.6 27.6l424.8 0c15.2 0 27.6-12.4 27.6-27.6 0-8.2-3.6-15.9-9.9-21.2l-14.5-12.1c-8.3-6.9-11.9-19.5-5.8-30.3 19.3-34.6 30.3-74.4 30.3-116.8 0-132.5-107.5-240-240-240S16 155.5 16 288zm400 0a160 160 0 1 1 -320 0 160 160 0 1 1 320 0z", "M496 288C496 155.5 388.5 48 256 48S16 155.5 16 288c0 42.4 11 82.2 30.3 116.8 6 10.8 2.5 23.4-5.8 30.3L25.9 447.2c-6.3 5.2-9.9 13-9.9 21.2 0 15.2 12.4 27.6 27.6 27.6l424.8 0c15.2 0 27.6-12.4 27.6-27.6 0-8.2-3.6-15.9-9.9-21.2l-14.5-12.1c-8.3-6.9-11.9-19.5-5.8-30.3 19.3-34.6 30.3-74.4 30.3-116.8zm16 0c0 45.2-11.7 87.7-32.3 124.6-1.9 3.4-.9 7.7 2.1 10.2l14.5 12.1c9.9 8.3 15.7 20.5 15.7 33.5 0 24.1-19.5 43.6-43.6 43.6L43.6 512C19.5 512 0 492.5 0 468.4 0 455.5 5.7 443.2 15.7 434.9l14.5-12.1c3-2.5 4-6.8 2.1-10.2-20.6-36.9-32.3-79.4-32.3-124.6 0-141.4 114.6-256 256-256S512 146.6 512 288zm-112 0c0-45-20.6-85.2-52.9-111.6l-47.2 65c12.4 11.7 20.1 28.2 20.1 46.6 0 4.1-.4 8.2-1.1 12.1L395.2 325c3.1-11.8 4.8-24.2 4.8-37zm-86.1 27.3c-9.2 19.4-27.8 33.5-49.9 36.2l0 80.3c57.7-3.2 106.3-40.2 126.3-91.6l-76.4-24.9zm-66 36.2c-22.1-2.8-40.7-16.8-49.8-36.2l-76.4 24.9c20 51.4 68.6 88.4 126.2 91.6l0-80.3zM112 288c0 12.8 1.7 25.2 4.8 37l76.4-24.9c-.8-3.9-1.1-8-1.1-12.1 0-18.4 7.7-34.9 20.1-46.6-1.3-1.8-17.1-23.5-47.2-65-32.3 26.4-52.9 66.6-52.9 111.6zm144-64c11.2 0 21.8 2.9 31 8l47.1-65c-22.5-14.6-49.3-23-78.1-23s-55.6 8.5-78.1 23c30.1 41.5 45.8 63.2 47.1 65 9.2-5.1 19.7-8 31-8zM96 288a160 160 0 1 1 320 0 160 160 0 1 1 -320 0zm208 0a48 48 0 1 0 -96 0 48 48 0 1 0 96 0z"]],
    "melon": [512, 512, [], "e310", ["M16 256c0 47.7 13.9 92.1 37.9 129.5-3.9-59.8 37.6-145.8 111.7-219.9S325.7 50 385.5 53.9C348.1 29.9 303.7 16 256 16 123.5 16 16 123.5 16 256zm63.3 69.1C63.5 372.4 68 407.3 86.3 425.7s53.2 22.8 100.6 7.1c46.3-15.4 99.6-49 148.2-97.6s82.2-101.9 97.6-148.2c15.8-47.3 11.3-82.2-7.1-100.6s-53.2-22.9-100.6-7.1c-46.3 15.4-99.6 49-148.2 97.6S94.7 278.8 79.3 325.1zm47.2 133c37.4 24 81.8 37.9 129.5 37.9 132.5 0 240-107.5 240-240 0-47.7-13.9-92.1-37.9-129.5 3.9 59.8-37.6 145.8-111.7 219.9S186.4 462 126.5 458.1z", "M496 256c0-47.7-13.9-92.1-37.9-129.5 3.9 59.8-37.6 145.8-111.7 219.9S186.4 462 126.5 458.1c37.4 24 81.8 37.9 129.5 37.9 132.5 0 240-107.5 240-240zM53.9 385.5C50 325.7 91.5 239.7 165.6 165.6S325.7 50 385.5 53.9C348.1 29.9 303.7 16 256 16 123.5 16 16 123.5 16 256 16 303.7 29.9 348.1 53.9 385.5zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zM425.7 86.3c-18.4-18.4-53.2-22.9-100.6-7.1-46.3 15.4-99.6 49-148.2 97.6S94.7 278.8 79.3 325.1C63.5 372.4 68 407.3 86.3 425.7s53.2 22.8 100.6 7.1c46.3-15.4 99.6-49 148.2-97.6s82.2-101.9 97.6-148.2c15.8-47.3 11.3-82.2-7.1-100.6z"]],
    "fax": [512, 512, [128224, 128439], "f1ac", ["M16 168l0 272c0 13.3 10.7 24 24 24l48 0c13.3 0 24-10.7 24-24l0-272c0-13.2-10.8-24-24-24l-48 0c-13.3 0-24 10.7-24 24zm112 64l0 208c0 13.3 10.7 24 24 24l320 0c13.3 0 24-10.7 24-24l0-208c0-13.3-10.7-24-24-24l-320 0c-13.3 0-24 10.7-24 24zm120 56a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm0 96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm96-96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm0 96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm96-96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm0 96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M128 56c0-22.1 17.9-40 40-40l172.1 0c10.6 0 20.8 4.2 28.3 11.7l51.9 51.9c7.5 7.5 11.7 17.7 11.7 28.3l0 36.1 16 0 0-36.1c0-14.9-5.9-29.1-16.4-39.6L379.7 16.4C369.2 5.9 355 0 340.1 0L168 0c-30.9 0-56 25.1-56 56l0 80c-6.7-5-15-8-24-8l-48 0c-22.1 0-40 17.9-40 40L0 440c0 22.1 17.9 40 40 40l48 0c13.1 0 24.7-6.3 32-16 7.3 9.7 18.9 16 32 16l320 0c22.1 0 40-17.9 40-40l0-208c0-22.1-17.9-40-40-40l-320 0c-9 0-17.3 3-24 8l0-144zM112 168l0 272c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-272c0-13.3 10.7-24 24-24l48 0c13.2 0 24 10.7 24 24zm16 272l0-208c0-13.3 10.7-24 24-24l320 0c13.3 0 24 10.7 24 24l0 208c0 13.3-10.7 24-24 24l-320 0c-13.3 0-24-10.7-24-24zm88-24a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm-16-32a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm144 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm-32-16a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm96 48a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm-16-32a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM248 288a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm-32-16a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm96 48a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm-16-32a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm144 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm-32-16a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"]],
    "arrow-left-long-to-line": [640, 512, [], "e3d4", ["", "M130.3 250.3c-3.1 3.1-3.1 8.2 0 11.3l152 152c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3L155.3 264 632 264c4.4 0 8-3.6 8-8s-3.6-8-8-8l-476.7 0 138.3-138.3c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0l-152 152zM0 408c0 4.4 3.6 8 8 8s8-3.6 8-8l0-304c0-4.4-3.6-8-8-8s-8 3.6-8 8L0 408z"]],
    "user-music": [640, 512, [], "f8eb", ["M40 512c4.4 0 8-3.6 8-8l0-24c0-88.4 71.6-160 160-160l96 0c29.1 0 56.5 7.8 80 21.4l0 50.7c-52.1 0-112 35.9-112 100 0 7 .7 13.6 2 19.9L40 512zM368 128a112 112 0 1 1 -224 0 112 112 0 1 1 224 0z", "M144 128a112 112 0 1 1 224 0 112 112 0 1 1 -224 0zm240 0a128 128 0 1 0 -256 0 128 128 0 1 0 256 0zM48 480c0-88.4 71.6-160 160-160l96 0c29.1 0 56.5 7.8 80 21.4l0-18.2c-24-12.3-51.2-19.2-80-19.2l-96 0c-97.2 0-176 78.8-176 176l0 24c0 4.4 3.6 8 8 8s8-3.6 8-8l0-24zM640 241.8c0-10.1-9.3-17.7-19.3-15.7l-176 36.7c-7.4 1.5-12.7 8.1-12.7 15.7l0 179.2c-11.7-10.8-28.9-17.6-48-17.6-35.4 0-64 23.3-64 52s28.6 52 64 52 64-23.3 64-52l0-133.6 176-36.7 0 103.9c-11.7-10.8-28.9-17.6-48-17.6-35.4 0-64 23.3-64 52s28.6 52 64 52 64-23.3 64-52l0-218.3zm-16 63.7l-176 36.7 0-63.7 176-36.7 0 63.7zM384 456.1c29.7 0 48 19 48 36s-18.3 36-48 36-48-19-48-36 18.3-36 48-36zm240 4c0 17-18.3 36-48 36s-48-19-48-36 18.3-36 48-36 48 19 48 36z"]],
    "person-circle-plus": [640, 512, [], "e541", ["M66.8 271l64.1-93.8c21-30.8 55.9-49.1 93.1-49.1s72.1 18.4 93.1 49.1l53.1 77.8c-8.2 7.1-15.8 15-22.8 23.4l-44.9-65.7c-2-2.9-5.6-4.2-9-3.1s-5.6 4.1-5.6 7.6L288 512c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-144c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 144c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-294.8c0-3.5-2.3-6.6-5.6-7.6s-7 .2-9 3.1L93.2 289c-5 7.3-14.9 9.2-22.2 4.2s-9.2-14.9-4.2-22.2zM264 24a40 40 0 1 1 -80 0 40 40 0 1 1 80 0z", "M184 24a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zm96 0a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zM130.9 177.1c21-30.8 55.9-49.1 93.1-49.1s72.1 18.4 93.1 49.1l53.1 77.8c4-3.5 8.2-6.8 12.5-10l-52.5-76.8C306.3 133 266.5 112 224 112s-82.3 21-106.3 56.1L53.6 261.9c-10 14.6-6.2 34.5 8.4 44.5s34.5 6.2 44.5-8.4l37.6-55 0 268.9c0 17.7 14.3 32 32 32s32-14.3 32-32l0-144c0-8.8 7.2-16 16-16s16 7.2 16 16l0 144c0 17.7 14.3 32 32 32s32-14.3 32-32l0-268.9 33.3 48.8c3.2-4.7 6.6-9.2 10.1-13.5l-44.9-65.7c-2-2.9-5.6-4.2-9-3.1s-5.6 4.1-5.6 7.6L288 512c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-144c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 144c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-294.8c0-3.5-2.3-6.6-5.6-7.6s-7 .2-9 3.1L93.2 289c-5 7.3-14.9 9.2-22.2 4.2s-9.2-14.9-4.2-22.2l64.1-93.8zM368 400a128 128 0 1 1 256 0 128 128 0 1 1 -256 0zm272 0a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zM504 336c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 56-56 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l56 0 0 56c0 4.4 3.6 8 8 8s8-3.6 8-8l0-56 56 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-56 0 0-56z"]],
    "hamsa": [512, 512, [], "f665", ["M16 319.6c0 8.4 3.3 16.4 9.3 22.3l99.8 99.8C159.8 476.5 206.9 496 256 496s96.2-19.5 130.9-54.2l99.8-99.8c5.9-5.9 9.3-14 9.3-22.3 0-17.4-14.1-31.6-31.6-31.6L400 288c-4.4 0-8-3.6-8-8l0-184c0-22.1-17.9-40-40-40s-40 17.9-40 40l0 120c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-160c0-22.1-17.9-40-40-40s-40 17.9-40 40l0 160c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-120c0-22.1-17.9-40-40-40s-40 17.9-40 40l0 184c0 4.4-3.6 8-8 8l-64.4 0C30.1 288 16 302.1 16 319.6zM152 352c0-7 2.5-14.1 7.6-19.4 7.1-7.4 20.6-20.4 37.4-31.6 16.6-11.1 37.4-21 58.9-21s42.3 10 58.9 21c16.8 11.2 30.3 24.2 37.4 31.6 5.2 5.3 7.6 12.4 7.6 19.4s-2.5 14.1-7.6 19.4c-7.1 7.4-20.6 20.4-37.4 31.6-16.6 11.1-37.4 21-58.9 21s-42.3-10-58.9-21c-16.8-11.2-30.3-24.2-37.4-31.6-5.2-5.3-7.6-12.4-7.6-19.4zm88 0a16 16 0 1 0 32 0 16 16 0 1 0 -32 0z", "M256 16c22.1 0 40 17.9 40 40l0 160c0 4.4 3.6 8 8 8s8-3.6 8-8l0-120c0-22.1 17.9-40 40-40s40 17.9 40 40l0 184c0 4.4 3.6 8 8 8l64.4 0c17.4 0 31.6 14.1 31.6 31.6 0 8.4-3.3 16.4-9.3 22.3l-99.8 99.8C352.2 476.5 305.1 496 256 496s-96.2-19.5-130.9-54.2L25.3 341.9C19.3 336 16 328 16 319.6 16 302.1 30.1 288 47.6 288l64.4 0c4.4 0 8-3.6 8-8l0-184c0-22.1 17.9-40 40-40s40 17.9 40 40l0 120c0 4.4 3.6 8 8 8s8-3.6 8-8l0-160c0-22.1 17.9-40 40-40zM200 56l0 .8c-10.2-10.4-24.3-16.8-40-16.8-30.9 0-56 25.1-56 56l0 176-56.4 0C21.3 272 0 293.3 0 319.6 0 332.2 5 344.3 13.9 353.3l99.8 99.8C151.5 490.8 202.7 512 256 512s104.5-21.2 142.2-58.9l99.8-99.8c8.9-8.9 13.9-21 13.9-33.7 0-26.3-21.3-47.6-47.6-47.6l-56.4 0 0-176c0-30.9-25.1-56-56-56-15.7 0-29.8 6.4-40 16.8l0-.8c0-30.9-25.1-56-56-56s-56 25.1-56 56zM171.2 343.7c6.7-7 19.3-19.1 34.8-29.4 15.6-10.4 33.2-18.3 50.1-18.3s34.5 7.9 50.1 18.3c15.5 10.3 28.1 22.4 34.8 29.4 2 2.1 3.2 5 3.2 8.3s-1.2 6.2-3.2 8.3c-6.7 7-19.3 19.1-34.8 29.4-15.6 10.4-33.2 18.3-50.1 18.3s-34.5-7.9-50.1-18.3c-15.5-10.3-28.1-22.4-34.8-29.4-2-2.1-3.2-5-3.2-8.3s1.2-6.2 3.2-8.3zM256 280c-21.5 0-42.3 10-58.9 21-16.8 11.2-30.3 24.2-37.4 31.6-5.2 5.3-7.6 12.4-7.6 19.4s2.5 14.1 7.6 19.4c7.1 7.4 20.6 20.4 37.4 31.6 16.6 11.1 37.4 21 58.9 21s42.3-10 58.9-21c16.8-11.2 30.3-24.2 37.4-31.6 5.2-5.3 7.6-12.4 7.6-19.4s-2.5-14.1-7.6-19.4c-7.1-7.4-20.6-20.4-37.4-31.6-16.6-11.1-37.4-21-58.9-21zm-16 72a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm48 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"]],
    "house-building": [640, 512, [], "e1b1", ["M48 248.8L48 456c0 22.1 17.9 40 40 40l240 0c22.1 0 40-17.9 40-40l0-207.2-160-134.4-160 134.4zM160 296c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-48z", "M576 16L352 16c-26.5 0-48 21.5-48 48l0 47.5-16-13.4 0-34.1c0-35.3 28.7-64 64-64L576 0c35.3 0 64 28.7 64 64l0 384c0 35.3-28.7 64-64 64l-160.3 0c3.2-5.1 6-10.4 8.4-16l152 0c26.5 0 48-21.5 48-48l0-384c0-26.5-21.5-48-48-48zM480 120c0-13.3 10.7-24 24-24l16 0c13.3 0 24 10.7 24 24l0 16c0 13.3-10.7 24-24 24l-16 0c-13.3 0-24-10.7-24-24l0-16zm24-8c-4.4 0-8 3.6-8 8l0 16c0 4.4 3.6 8 8 8l16 0c4.4 0 8-3.6 8-8l0-16c0-4.4-3.6-8-8-8l-16 0zm0 80l16 0c13.3 0 24 10.7 24 24l0 16c0 13.3-10.7 24-24 24l-16 0c-13.3 0-24-10.7-24-24l0-16c0-13.3 10.7-24 24-24zm-8 24l0 16c0 4.4 3.6 8 8 8l16 0c4.4 0 8-3.6 8-8l0-16c0-4.4-3.6-8-8-8l-16 0c-4.4 0-8 3.6-8 8zm-16 96c0-13.3 10.7-24 24-24l16 0c13.3 0 24 10.7 24 24l0 16c0 13.3-10.7 24-24 24l-16 0c-13.3 0-24-10.7-24-24l0-16zm24-8c-4.4 0-8 3.6-8 8l0 16c0 4.4 3.6 8 8 8l16 0c4.4 0 8-3.6 8-8l0-16c0-4.4-3.6-8-8-8l-16 0zM408 96l16 0c13.3 0 24 10.7 24 24l0 16c0 13.3-10.7 24-24 24l-16 0c-13.3 0-24-10.7-24-24l0-16c0-13.3 10.7-24 24-24zm-8 24l0 16c0 4.4 3.6 8 8 8l16 0c4.4 0 8-3.6 8-8l0-16c0-4.4-3.6-8-8-8l-16 0c-4.4 0-8 3.6-8 8zM213.1 97.9l200 168c3.4 2.8 3.8 7.9 1 11.3s-7.9 3.8-11.3 1L384 262.3 384 456c0 30.9-25.1 56-56 56L88 512c-30.9 0-56-25.1-56-56l0-193.7-18.9 15.8c-3.4 2.8-8.4 2.4-11.3-1s-2.4-8.4 1-11.3l200-168c3-2.5 7.3-2.5 10.3 0zM368 248.8L208 114.4 48 248.8 48 456c0 22.1 17.9 40 40 40l240 0c22.1 0 40-17.9 40-40l0-207.2zM232 288l-48 0c-4.4 0-8 3.6-8 8l0 48c0 4.4 3.6 8 8 8l48 0c4.4 0 8-3.6 8-8l0-48c0-4.4-3.6-8-8-8zm-48-16l48 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-48c0-13.3 10.7-24 24-24z"]],
    "person-circle-question": [640, 512, [], "e542", ["M66.8 271l64.1-93.8c21-30.8 55.9-49.1 93.1-49.1s72.1 18.4 93.1 49.1l53.1 77.8c-8.2 7.1-15.8 15-22.8 23.4l-44.9-65.7c-2-2.9-5.6-4.2-9-3.1s-5.6 4.1-5.6 7.6L288 512c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-144c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 144c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-294.8c0-3.5-2.3-6.6-5.6-7.6s-7 .2-9 3.1L93.2 289c-5 7.3-14.9 9.2-22.2 4.2s-9.2-14.9-4.2-22.2zM264 24a40 40 0 1 1 -80 0 40 40 0 1 1 80 0z", "M184 24a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zm96 0a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zM130.9 177.1c21-30.8 55.9-49.1 93.1-49.1s72.1 18.4 93.1 49.1l53.1 77.8c4-3.5 8.2-6.8 12.5-10l-52.5-76.8C306.3 133 266.5 112 224 112s-82.3 21-106.3 56.1L53.6 261.9c-10 14.6-6.2 34.5 8.4 44.5s34.5 6.2 44.5-8.4l37.6-55 0 268.9c0 17.7 14.3 32 32 32s32-14.3 32-32l0-144c0-8.8 7.2-16 16-16s16 7.2 16 16l0 144c0 17.7 14.3 32 32 32s32-14.3 32-32l0-268.9 33.3 48.8c3.2-4.7 6.6-9.2 10.1-13.5l-44.9-65.7c-2-2.9-5.6-4.2-9-3.1s-5.6 4.1-5.6 7.6L288 512c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-144c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 144c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-294.8c0-3.5-2.3-6.6-5.6-7.6s-7 .2-9 3.1L93.2 289c-5 7.3-14.9 9.2-22.2 4.2s-9.2-14.9-4.2-22.2l64.1-93.8zM368 400a128 128 0 1 1 256 0 128 128 0 1 1 -256 0zm272 0a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zM496 476a12 12 0 1 0 0-24 12 12 0 1 0 0 24zm0-140c17.7 0 32 14.3 32 32l0 .3c0 10.1-6 19.3-15.2 23.5l-5.4 2.4c-11.8 5.2-19.4 16.9-19.4 29.8 0 4.4 3.6 8 8 8s8-3.6 8-8c0-6.6 3.9-12.5 9.9-15.2l5.4-2.4c15.1-6.7 24.8-21.6 24.8-38.1l0-.3c0-26.5-21.5-48-48-48-23.2 0-42.6 16.5-47 38.4-.9 4.3 1.9 8.6 6.2 9.4s8.6-1.9 9.4-6.2c3-14.6 15.9-25.6 31.4-25.6z"]],
    "crate-empty": [512, 512, [], "e151", ["M16 280l0 80 480 0 0-80c0-22.1-17.9-40-40-40L56 240c-22.1 0-40 17.9-40 40zm0 96l0 80c0 22.1 17.9 40 40 40l400 0c22.1 0 40-17.9 40-40l0-80-480 0zm80-72a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm0 128a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zM448 304a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm0 128a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M496 376l0 80c0 22.1-17.9 40-40 40L56 496c-22.1 0-40-17.9-40-40l0-80 480 0zm0-16l-480 0 0-80c0-22.1 17.9-40 40-40l400 0c22.1 0 40 17.9 40 40l0 80zm16 0l0-80c0-30.9-25.1-56-56-56L56 224c-30.9 0-56 25.1-56 56L0 456c0 30.9 25.1 56 56 56l400 0c30.9 0 56-25.1 56-56l0-96zM96 304a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm336 16a16 16 0 1 0 0-32 16 16 0 1 0 0 32zM96 432a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm336 16a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"]],
    "sun-haze": [576, 512, [], "f765", ["M36.9 152c1-2.4 3-4.3 5.6-4.9l108.4-21.9c3.2-.6 5.6-3.1 6.3-6.3L179.1 10.5c.5-2.6 2.4-4.6 4.9-5.6s5.2-.9 7.4 .5l92.2 61.2c2.7 1.8 6.2 1.8 8.8 0L384.6 5.4c2.2-1.5 5-1.5 7.4-.5s4.3 3 4.9 5.6l21.9 108.4c.6 3.2 3.1 5.6 6.3 6.3l108.4 21.9c2.6 .5 4.6 2.4 5.6 4.9s.9 5.2-.5 7.4l-61.2 92.2c-1.8 2.7-1.8 6.2 0 8.8L516.9 320c42 0-252.9 0-137 0 12.7-18.1 20.1-40.2 20.1-64 0-61.9-50.1-112-112-112S176 194.1 176 256c0 23.8 7.4 45.9 20.1 64 42.7 0-252.7 0-137 0l39.5-59.6c1.8-2.7 1.8-6.2 0-8.8L37.4 159.4c-1.5-2.2-1.5-5-.5-7.4z", "M384.6 5.4c2.2-1.5 5-1.5 7.4-.5s4.3 3 4.9 5.6l21.9 108.4c.6 3.2 3.1 5.6 6.3 6.3l108.4 21.9c2.6 .5 4.6 2.4 5.6 4.9s.9 5.2-.5 7.4l-61.2 92.2c-1.8 2.7-1.8 6.2 0 8.8l39.5 59.6 19.2 0-42.5-64 58.2-87.8c4.9-7.4 4.6-16 2-22.4s-8.4-12.6-17.2-14.4L433.4 110.6 412.6 7.3c-1.8-8.8-8.1-14.6-14.4-17.2s-14.9-3-22.4 2l-87.8 58.2-87.8-58.2 0 0c-7.4-4.9-16-4.6-22.4-2S165.2-1.4 163.4 7.3L142.6 110.6 39.3 131.4c-8.8 1.8-14.6 8.1-17.2 14.4s-3 14.9 2 22.4l58.2 87.8-42.5 64 19.2 0 39.5-59.6c1.8-2.7 1.8-6.2 0-8.8L37.4 159.4c-1.5-2.2-1.5-5-.5-7.4s3-4.3 5.6-4.9l108.4-21.9c3.2-.6 5.6-3.1 6.3-6.3L179.1 10.5c.5-2.6 2.4-4.6 4.9-5.6s5.2-.9 7.4 .5l92.2 61.2c2.7 1.8 6.2 1.8 8.8 0L384.6 5.4zM400 256c0-61.9-50.1-112-112-112S176 194.1 176 256c0 23.8 7.4 45.9 20.1 64l20.4 0c-15.2-17-24.5-39.4-24.5-64 0-53 43-96 96-96s96 43 96 96c0 24.6-9.2 47-24.5 64l20.4 0c12.7-18.1 20.1-40.2 20.1-64zM512 392c0-4.4-3.6-8-8-8L8 384c-4.4 0-8 3.6-8 8s3.6 8 8 8l496 0c4.4 0 8-3.6 8-8zM64 488c0 4.4 3.6 8 8 8l112 0c4.4 0 8-3.6 8-8s-3.6-8-8-8L72 480c-4.4 0-8 3.6-8 8zm176 0c0 4.4 3.6 8 8 8l320 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-320 0c-4.4 0-8 3.6-8 8z"]],
    "circle-3": [512, 512, [], "e0f0", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zm176-88c0-4.4 3.6-8 8-8l76 0c28.7 0 52 23.3 52 52 0 18.5-9.7 34.8-24.3 44 14.6 9.2 24.3 25.5 24.3 44 0 28.7-23.3 52-52 52l-76 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l76 0c19.9 0 36-16.1 36-36s-16.1-36-36-36l-60 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l60 0c19.9 0 36-16.1 36-36s-16.1-36-36-36l-76 0c-4.4 0-8-3.6-8-8z", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm20-264l-60 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l60 0c19.9 0 36 16.1 36 36s-16.1 36-36 36l-76 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l76 0c28.7 0 52-23.3 52-52 0-18.5-9.7-34.8-24.3-44 14.6-9.2 24.3-25.5 24.3-44 0-28.7-23.3-52-52-52l-76 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l76 0c19.9 0 36 16.1 36 36s-16.1 36-36 36z"]],
    "clipboard-check": [384, 512, [], "f46c", ["M16 96l0 352c0 26.5 21.5 48 48 48l256 0c26.5 0 48-21.5 48-48l0-352c0-26.5-21.5-48-48-48l-16 0c0 17.4-9.2 32.6-23.1 41-4.3 4.3-10.3 7-16.9 7L120 96c-6.6 0-12.6-2.7-16.9-7-13.8-8.4-23.1-23.6-23.1-41L64 48C37.5 48 16 69.5 16 96zM98.5 302.6c3.2-3.1 8.2-3 11.3 .2l55.7 57.6 108.1-148.7c2.6-3.6 7.6-4.3 11.2-1.7 3.6 2.6 4.3 7.6 1.8 11.2L172.9 377.5c-1.4 1.9-3.6 3.1-5.9 3.3s-4.7-.7-6.3-2.4L98.3 313.9c-3.1-3.2-3-8.2 .2-11.3z", "M256 0c20.9 0 38.7 13.4 45.3 32L320 32c35.3 0 64 28.7 64 64l0 352c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l18.7 0C89.3 13.4 107.1 0 128 0L256 0zM64 48C37.5 48 16 69.5 16 96l0 352c0 26.5 21.5 48 48 48l256 0c26.5 0 48-21.5 48-48l0-352c0-26.5-21.5-48-48-48l-16 0c0 26.5-21.5 48-48 48L128 96c-26.5 0-48-21.5-48-48L64 48zM273.7 211.7c2.6-3.6 7.6-4.3 11.2-1.7 3.6 2.6 4.3 7.6 1.8 11.2L172.9 377.5c-1.4 1.9-3.6 3.1-5.9 3.3s-4.7-.7-6.3-2.4L98.3 313.9c-3.1-3.2-3-8.2 .2-11.3s8.2-3 11.3 .2l55.7 57.6 108.1-148.7zM128 16c-17.7 0-32 14.3-32 32s14.3 32 32 32l128 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L128 16z"]],
    "share-from-square": [576, 512, [61509, "share-square"], "f14d", ["M176.5 240c0 41.5 18.2 71.3 39 92.1 21 21 44.1 32.3 52.1 35.8 .9 .4 2.4 .4 3.7-.3 .6-.3 .9-.6 1-.8 .1-.2 .2-.3 .2-.6 0-.6-.9-3.7-5.9-7.1-12.6-8.7-26.1-25.3-26.1-53.6 0-53.8 43.6-97.5 97.5-97.5l54.5 0c4.4 0 8 3.6 8 8l0 80c0 6.8 8.8 10.5 13.7 5.7l136-136c3.1-3.1 3.1-8.2 0-11.3l-136-136c-4.8-4.8-13.7-1.2-13.7 5.7l0 80c0 4.4-3.6 8-8 8l-88 0c-70.7 0-128 57.3-128 128z", "M400.5 24c0-6.8 8.8-10.5 13.7-5.7l136 136c3.1 3.1 3.1 8.2 0 11.3l-136 136c-4.8 4.8-13.7 1.2-13.7-5.7l0-80c0-4.4-3.6-8-8-8L338 208c-53.8 0-97.5 43.6-97.5 97.5 0 28.3 13.5 44.9 26.1 53.6 5 3.5 5.9 6.5 5.9 7.1 0 .3-.1 .5-.2 .6-.1 .2-.5 .5-1 .8-1.3 .7-2.8 .7-3.7 .3-8-3.5-31.1-14.8-52.1-35.8-20.7-20.8-39-50.6-39-92.1 0-70.7 57.3-128 128-128l88 0c4.4 0 8-3.6 8-8l0-80zm25-17c-14.9-14.9-41-4.1-41 17l0 72-80 0c-79.5 0-144 64.5-144 144 0 93.4 82.8 134.8 100.6 142.6 5.8 2.5 12.3 1.9 17.4-.7 5.3-2.7 9.9-8.1 9.9-15.7 0-8.3-5.9-15.5-12.8-20.3-8.9-6.2-19.2-18.2-19.2-40.5 0-45 36.5-81.5 81.5-81.5l46.5 0 0 72c0 21.1 26.1 31.9 41 17l136-136c9.4-9.4 9.4-24.6 0-33.9L425.5 7zm-313 89c-44.2 0-80 35.8-80 80l0 256c0 44.2 35.8 80 80 80l256 0c44.2 0 80-35.8 80-80l0-40c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 40c0 35.3-28.7 64-64 64l-256 0c-35.3 0-64-28.7-64-64l0-256c0-35.3 28.7-64 64-64l40 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-40 0z"]],
    "fork-knife": [512, 512, ["utensils-alt"], "f2e6", ["M40.3 51.5L210.9 222.1c-22.9 22.9-45.8 45.8-68.7 68.7L45 193.5C6 154.6 4.4 92.3 40.3 51.5zM281.6 206.2c-31.8-31.8-27-84.6 10-110.1L401.1 20.3c3.6-2.5 4.5-7.5 2-11.1 10.6 10.6 21.3 21.3 31.9 31.9-3-2.1-7.1-1.9-10 .6L306.3 149.2c-3.3 3-3.5 8-.6 11.3s8 3.5 11.3 .6L435.9 53.6c3-2.7 3.5-7.3 1.2-10.5l32 32c-3.3-2.3-7.8-1.8-10.5 1.2L351 195c-3 3.3-2.7 8.3 .6 11.3s8.3 2.7 11.3-.6L470.4 87c2.6-2.8 2.7-7 .6-10l32 32c-3.7-2.5-8.7-1.6-11.2 2L416.1 220.5c-25.6 37-78.4 41.7-110.1 10l-24.3-24.3z", "M403.1 9.2c2.5 3.6 1.6 8.6-2 11.1L291.6 96c-37 25.6-41.7 78.4-10 110.1l24.3 24.3c31.8 31.8 84.6 27 110.1-10L491.8 111c2.5-3.6 7.5-4.5 11.1-2s4.5 7.5 2 11.1L429.2 229.6c-31.2 45.2-95.8 51-134.6 12.2L288.1 235.3 14.4 509c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l273.7-273.7-6.5-6.5c-38.8-38.8-33-103.4 12.2-134.6L392 7.1c3.6-2.5 8.6-1.6 11.1 2zm33.3 33.1c3 3.3 2.7 8.3-.6 11.3L317.1 161.1c-3.3 3-8.3 2.7-11.3-.6s-2.7-8.3 .6-11.3L425.1 41.7c3.3-3 8.3-2.7 11.3 .6zm33.4 33.4c3.3 3 3.5 8 .6 11.3L362.9 205.8c-3 3.3-8 3.5-11.3 .6s-3.5-8-.6-11.3L458.5 76.2c3-3.3 8-3.5 11.3-.6zM45.8 34.3L201.4 190c3.1 10.3 7.3 20.1 12.3 29.3l-2.8 2.8-170.6-170.6C4.4 92.3 6 154.6 45 193.5l97.2 97.2-11.3 11.3-97.2-97.2C-13.2 158-13.2 82 33.6 35.1l.8-.8c3.1-3.1 8.2-3.1 11.3 0zM498.5 509.7L290 301.3 301.4 289.9 509.8 498.3c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0z"]],
    "receipt": [384, 512, [129534], "f543", ["M16 23.5l0 464.9 43.4-31c2.6-1.9 6.1-2 8.9-.3l59.8 37.4 59.8-37.4c2.6-1.6 5.9-1.6 8.5 0l59.8 37.4 59.8-37.4c2.7-1.7 6.3-1.6 8.9 .3l43.4 31 0-464.9-43.4 31c-2.6 1.9-6.1 2-8.9 .3L256 17.4 196.2 54.8c-2.6 1.6-5.9 1.6-8.5 0L128 17.4 68.2 54.8c-2.7 1.7-6.3 1.6-8.9-.3L16 23.5zM88 160c0-4.4 3.6-8 8-8l192 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L96 168c-4.4 0-8-3.6-8-8zm0 96c0-4.4 3.6-8 8-8l192 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L96 264c-4.4 0-8-3.6-8-8zm0 96c0-4.4 3.6-8 8-8l192 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L96 360c-4.4 0-8-3.6-8-8z", "M12.6 1.5C10.2-.3 7-.5 4.3 .9S0 5 0 8L0 504c0 3 1.7 5.7 4.3 7.1s5.9 1.1 8.3-.6l51.6-36.9 59.5 37.2c2.6 1.6 5.9 1.6 8.5 0l59.8-37.4 59.8 37.4c2.6 1.6 5.9 1.6 8.5 0l59.5-37.2 51.6 36.9c2.4 1.7 5.6 2 8.3 .6S384 507 384 504L384 8c0-3-1.7-5.7-4.3-7.1s-5.9-1.1-8.3 .6L319.7 38.4 260.2 1.2c-2.6-1.6-5.9-1.6-8.5 0L192 38.6 132.2 1.2c-2.6-1.6-5.9-1.6-8.5 0L64.3 38.4 12.6 1.5zM68.2 54.8L128 17.4 187.8 54.8c2.6 1.6 5.9 1.6 8.5 0L256 17.4 315.8 54.8c2.7 1.7 6.3 1.6 8.9-.3l43.4-31 0 464.9-43.4-31c-2.6-1.9-6.1-2-8.9-.3l-59.8 37.4-59.8-37.4c-2.6-1.6-5.9-1.6-8.5 0L128 494.6 68.2 457.2c-2.7-1.7-6.3-1.6-8.9 .3l-43.4 31 0-464.9 43.4 31c2.6 1.9 6.1 2 8.9 .3zM96 152c-4.4 0-8 3.6-8 8s3.6 8 8 8l192 0c4.4 0 8-3.6 8-8s-3.6-8-8-8L96 152zM88 352c0 4.4 3.6 8 8 8l192 0c4.4 0 8-3.6 8-8s-3.6-8-8-8L96 344c-4.4 0-8 3.6-8 8zm8-104c-4.4 0-8 3.6-8 8s3.6 8 8 8l192 0c4.4 0 8-3.6 8-8s-3.6-8-8-8L96 248z"]],
    "equals": [448, 512, [62764], "3d", ["", "M8 128c-4.4 0-8 3.6-8 8s3.6 8 8 8l432 0c4.4 0 8-3.6 8-8s-3.6-8-8-8L8 128zM8 368c-4.4 0-8 3.6-8 8s3.6 8 8 8l432 0c4.4 0 8-3.6 8-8s-3.6-8-8-8L8 368z"]],
    "diagram-lean-canvas": [576, 512, [], "e156", ["M16 96c0-26.5 21.5-48 48-48l64 0 0 256-112 0 0-208zm0 224l264 0 0 144-216 0c-26.5 0-48-21.5-48-48l0-96zM144 48l80 0 0 128-80 0 0-128zm0 144l80 0 0 112-80 0 0-112zM240 48l96 0 0 256-96 0 0-256zm56 272l264 0 0 96c0 26.5-21.5 48-48 48l-216 0 0-144zM352 48l80 0 0 128-80 0 0-128zm0 144l80 0 0 112-80 0 0-112zM448 48l64 0c26.5 0 48 21.5 48 48l0 208-112 0 0-256z", "M448 48l0 256 112 0 0-208c0-26.5-21.5-48-48-48l-64 0zm-16 0l-80 0 0 128 80 0 0-128zm-96 0l-96 0 0 256 96 0 0-256zM224 48l-80 0 0 128 80 0 0-128zm-96 0L64 48C37.5 48 16 69.5 16 96l0 208 112 0 0-256zM16 320l0 96c0 26.5 21.5 48 48 48l216 0 0-144-264 0zM296 464l216 0c26.5 0 48-21.5 48-48l0-96-264 0 0 144zM0 96C0 60.7 28.7 32 64 32l448 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM224 304l0-112-80 0 0 112 80 0zM432 192l-80 0 0 112 80 0 0-112z"]],
    "box-arrow-up": [448, 512, [], "e827", ["M16.2 144c-.1 1.5-.2 3-.2 4.5L16 416c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-267.5c0-1.5-.1-3-.2-4.5L16.2 144zm4.4-16l195.4 0 0-96-103.1 0c-15.5 0-30.1 7.5-39.1 20.1L24.9 120.6c-1.7 2.3-3.1 4.8-4.3 7.4zM146.3 282.3l72-72 1.2-1c3.1-2.1 7.3-1.7 10.1 1l72 72 1 1.3c2.1 3.1 1.7 7.3-1 10.1s-7 3.1-10.1 1l-1.3-1-58.3-58.3 0 156.7c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-156.7-58.3 58.3c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3zM232 32l0 96 195.4 0c-1.2-2.6-2.6-5-4.3-7.4L374.1 52.1c-7.9-11-20-18.1-33.3-19.8L335.1 32 232 32z", "M335.1 16c20.7 0 40.1 10 52.1 26.8l48.9 68.5c7.7 10.8 11.9 23.9 11.9 37.2l0 267.5-.3 6.5c-3.1 30.1-27 54.1-57.1 57.1l-6.5 .3-320 0-6.5-.3c-30.1-3.1-54.1-27-57.1-57.1L0 416 0 148.5c0-11.7 3.2-23.1 9.2-33l2.7-4.2 48.9-68.5c10.5-14.7 26.7-24.2 44.4-26.3l7.7-.5 222.1 0zM16 148.5L16 416c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-267.5c0-1.5-.1-3-.2-4.5L16.2 144c-.1 1.5-.2 3-.2 4.5zm203.6 60.8c3.1-2.1 7.3-1.7 10.1 1l72 72 1 1.3c2.1 3.1 1.7 7.3-1 10.1s-7 3.1-10.1 1l-1.3-1-58.3-58.3 0 156.7c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-156.7-58.3 58.3c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l72-72 1.2-1zM112.9 32c-15.5 0-30.1 7.5-39.1 20.1L24.9 120.6c-1.7 2.3-3.1 4.8-4.3 7.4l195.4 0 0-96-103.1 0zM232 128l195.4 0c-1.2-2.6-2.6-5-4.3-7.4L374.1 52.1c-7.9-11-20-18.1-33.3-19.8l-5.8-.3-103.1 0 0 96z"]],
    "chevron-up": [448, 512, [], "f077", ["", "M218.3 98.3c3.1-3.1 8.2-3.1 11.3 0l216 216c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L224 115.3 13.7 325.7c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l216-216z"]],
    "virus-slash": [576, 512, [], "e075", ["M124.2 80.7c9.8-5 22.1-3.4 30.3 4.8l4.3 4.3C197.5 128.7 264 101.2 264 46.3l0-6.3c0-13.3 10.7-24 24-24s24 10.7 24 24l0 6.3c0 54.9 66.5 82.4 105.3 43.5l5.6-5.7c9.6-9.6 25.2-9.9 35.1-.5 10.2 9.6 10.6 25.8 .8 35.9l-6.3 6.5c-38.6 39.6-10.5 106 44.7 106l6.9 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-6.4 0c-55 0-82.5 66.5-43.6 105.3l4.3 4.3c8.1 8.1 9.7 20.3 4.8 30.1l-339-339z", "M13.7-29.8c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l560 560c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-98.8-98.8c11-16.3 9.3-38.6-5.2-53.1l-4.3-4.3c-28.8-28.8-8.4-78 32.3-78l6.4 0c22.1 0 40-17.9 40-40s-17.9-40-40-40l-6.9 0c-41.1 0-61.9-49.4-33.3-78.9l6.3-6.5c16.1-16.5 15.5-42.9-1.2-58.7-16.2-15.3-41.6-14.9-57.4 .9l-5.6 5.7C377.2 107.3 328 87 328 46.3l0-6.3c0-22.1-17.9-40-40-40s-40 17.9-40 40l0 6.3c0 40.7-49.2 61-77.9 32.2l-4.3-4.3c-14.5-14.5-36.9-16.2-53.3-5.1L13.7-29.8zM124.2 80.7c9.8-5 22.1-3.4 30.3 4.8l4.3 4.3C197.5 128.7 264 101.2 264 46.3l0-6.3c0-13.3 10.7-24 24-24s24 10.7 24 24l0 6.3c0 54.9 66.5 82.4 105.3 43.5l5.6-5.7c9.6-9.6 25.2-9.9 35.1-.5 10.2 9.6 10.6 25.8 .8 35.9l-6.3 6.5c-38.6 39.6-10.5 106 44.7 106l6.9 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-6.4 0c-55 0-82.5 66.5-43.6 105.3l4.3 4.3c8.1 8.1 9.7 20.3 4.8 30.1l-339-339zM78.4 232c31 0 53.3-21.2 59.8-46.6l-14.1-14.1c-.7 23-18.8 44.7-45.8 44.7L72 216c-22.1 0-40 17.9-40 40s17.9 40 40 40l6.4 0c40.7 0 61.1 49.2 32.3 78l-4.3 4.3c-16.4 16.4-16.4 42.9 0 59.3s42.9 16.4 59.3 0l4.3-4.3c28.8-28.8 78-8.4 78 32.3l0 6.4c0 22.1 17.9 40 40 40s40-17.9 40-40l0-6.4c0-27 21.7-45.1 44.7-45.8l-14.1-14.1c-25.4 6.5-46.6 28.8-46.6 59.8l0 6.4c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-6.4c0-55-66.5-82.5-105.3-43.6l-4.3 4.3c-10.1 10.1-26.6 10.1-36.7 0s-10.1-26.6 0-36.7l4.3-4.3C160.9 346.5 133.3 280 78.4 280L72 280c-13.3 0-24-10.7-24-24s10.7-24 24-24l6.4 0z"]],
    "globe-stand": [384, 512, [], "f5f6", ["M32.5 192a144 144 0 1 0 288 0 144 144 0 1 0 -288 0z", "M2.8 354.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l15.4-15.4c43.5 40.4 99.5 59.6 155 57.6l0 88.1-144 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l304 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-144 0 0-89.3c47-5.2 92.7-25.9 128.7-61.9 82.5-82.5 84.3-215 5.6-299.7l15.4-15.4c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0L317.9 39.3c-3.1 3.1-3.1 8.2 0 11.3 78.1 78.1 78.1 204.7 0 282.8s-204.7 78.1-282.8 0c-3.1-3.1-8.2-3.1-11.3 0L2.8 354.3zM32.5 192a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm304 0a160 160 0 1 0 -320 0 160 160 0 1 0 320 0z"]],
    "ring-diamond": [384, 512, [], "e5ab", ["M118.9 72l39.3 59c11-1.9 22.2-3 33.7-3s22.8 1 33.7 3l39.3-59-146.1 0zm.6-16l144.9 0-26.2-36.6c-1.5-2.1-3.9-3.4-6.5-3.4l-79.5 0c-2.6 0-5 1.2-6.5 3.4L119.5 56z", "M132.7 10.1C137.2 3.7 144.5 0 152.2 0l79.5 0c7.8 0 15 3.7 19.5 10.1l32 44.8c3.9 5.4 4 12.6 .3 18.2l-41.1 61.7C324 156.9 384 231.4 384 320 384 426 298 512 192 512S0 426 0 320c0-88.6 60-163.1 141.5-185.3L100.4 73c-3.7-5.5-3.6-12.8 .3-18.2l32-44.8zM265.1 72l-146.1 0 39.3 59c11-1.9 22.2-3 33.7-3s22.8 1 33.7 3l39.3-59zm-.6-16L238.3 19.4c-1.5-2.1-3.9-3.4-6.5-3.4l-79.5 0c-2.6 0-5 1.2-6.5 3.4L119.5 56 264.5 56zM192 496a176 176 0 1 0 0-352 176 176 0 1 0 0 352z"]],
    "phone-rotary": [512, 512, [9742], "f8d3", ["M48 373.8c0-11.1 3.3-21.9 9.4-31.1l96.9-145.4c8.9-13.4 23.9-21.4 39.9-21.4l123.5 0c16.1 0 31 8 39.9 21.4l96.9 145.4c6.1 9.2 9.4 20 9.4 31.1l0 42.2c0 26.5-21.5 48-48 48L96 464c-26.5 0-48-21.5-48-48l0-42.2zM176 320a80 80 0 1 0 160 0 80 80 0 1 0 -160 0z", "M16 176l0-28.1c0-8.6 3.4-15.9 8.9-20.4 31.2-25 113-79.5 231.1-79.5s199.8 54.5 231.1 79.5c5.6 4.5 8.9 11.7 8.9 20.4l0 28.1c0 17.7-14.3 32-32 32l-22.3 0 10.7 16 11.6 0c26.5 0 48-21.5 48-48l0-28.1c0-12.7-5-24.9-15-32.9-32.8-26.2-118-83-241-83S47.7 88.8 15 115C5 123 0 135.2 0 147.9L0 176c0 26.5 21.5 48 48 48l11.6 0 10.7-16-22.3 0c-17.7 0-32-14.3-32-32zM48 373.8c0-11.1 3.3-21.9 9.4-31.1l96.9-145.4c8.9-13.4 23.9-21.4 39.9-21.4l123.5 0c16.1 0 31 8 39.9 21.4l96.9 145.4c6.1 9.2 9.4 20 9.4 31.1l0 42.2c0 26.5-21.5 48-48 48L96 464c-26.5 0-48-21.5-48-48l0-42.2zm-16 0L32 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-42.2c0-14.2-4.2-28.1-12.1-39.9L371 188.5c-11.5-17.2-30.5-27.7-51-28.5l0-40c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 40-96 0 0-40c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 40c-20.5 .7-39.5 11.3-51 28.5L44.1 333.9C36.2 345.7 32 359.6 32 373.8zM256 256a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm0 144a80 80 0 1 0 0-160 80 80 0 1 0 0 160z"]],
    "slash": [576, 512, [], "f715", ["", "M2.3-29.8c3.1-3.1 8.2-3.1 11.3 0l560 560c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L2.3-18.5c-3.1-3.1-3.1-8.2 0-11.3z"]],
    "arrow-down-to-dotted-line": [384, 512, [], "e095", ["", "M16 512c-8.8 0-16-7.2-16-16s7.2-16 16-16 16 7.2 16 16-7.2 16-16 16zM349.7 229.7l-152 152c-3.1 3.1-8.2 3.1-11.3 0l-152-152c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0L184 356.7 184 8c0-4.4 3.6-8 8-8s8 3.6 8 8l0 348.7 138.3-138.3c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3zM88 496c0-8.8 7.2-16 16-16s16 7.2 16 16-7.2 16-16 16-16-7.2-16-16zm104 16c-8.8 0-16-7.2-16-16s7.2-16 16-16 16 7.2 16 16-7.2 16-16 16zm72-16c0-8.8 7.2-16 16-16s16 7.2 16 16-7.2 16-16 16-16-7.2-16-16zm104 16c-8.8 0-16-7.2-16-16s7.2-16 16-16 16 7.2 16 16-7.2 16-16 16z"]],
    "saxophone-fire": [640, 512, ["sax-hot"], "f8db", ["M16 349.6l0 2.1c0 79.7 64.6 144.3 144.3 144.3 43 0 83.8-19.2 111.2-52.4L520.2 142.5c7.6-9.2 18.9-14.5 30.8-14.5l64 0c5 0 9-4 9-9 0-2.4-.9-4.7-2.6-6.3L605.1 96.4C594.6 85.9 580.3 80 565.5 80l-27 0c-14.8 0-29.1 5.9-39.6 16.4l-277 276.8c-6.8 6.8-16 10.6-25.7 10.6l-2 0c-19 0-34.3-15.4-34.3-34.3 0-4.7 1-9.4 2.9-13.8L211.8 224 46 224 21.6 309.4C17.9 322.5 16 336 16 349.6zM96 368a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm32-96a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M148.6 38.6L133.4 22.7c-1.6-1.7-3.2-3.5-4.8-5.3-7.2-8.2-14.9-17-26.2-17.3-5.8-.1-11.7 1.9-16.3 6-18.7 16.9-40 39.1-56.7 64.1-16.6 24.9-29.4 53.7-29.4 83.6 0 2.1 0 4.2 .1 6.3l96.3 0c1.1-1.6 2.2-3.2 3.4-4.8 8.7-11.8 19.2-21.8 26-27.7 1.3-1.1 3-1.1 4.3 0 6.9 6 17.3 15.9 26 27.7 1.2 1.6 2.3 3.2 3.4 4.8l96.3 0c.1-2.1 .1-4.2 .1-6.3 0-24-8.8-48.7-20.9-70.5-12.2-21.9-28.2-41.9-44-56.5-4.5-4.2-10.2-6.2-15.9-6.2-6.1 0-12.4 2.2-16.7 7.1l-9.8 11zM538.5 64c-19.1 0-37.4 7.6-50.9 21.1L452 120.7 429.7 98.3c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l22.3 22.3-36.7 36.7-22.3-22.3c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l22.3 22.3-36.7 36.7-22.3-22.3c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l22.3 22.3-134 133.9c-3.8 3.8-9 5.9-14.3 5.9l-2 0c-10.1 0-18.3-8.2-18.3-18.3 0-2.5 .5-5 1.5-7.3L229.2 224 248 224c4.4 0 8-3.6 8-8s-3.6-8-8-8L8 208c-4.4 0-8 3.6-8 8s3.6 8 8 8l21.4 0-23.1 81C2.1 319.5 0 334.5 0 349.6l0 2.1c0 88.5 71.8 160.3 160.3 160.3 47.8 0 93.1-21.3 123.6-58.2L532.6 152.7c4.6-5.5 11.3-8.7 18.5-8.7l64 0c13.8 0 25-11.2 25-25 0-6.6-2.6-13-7.3-17.7L616.4 85.1C602.9 71.6 584.6 64 565.5 64l-27 0zM46 224l165.7 0-48.9 111.7c-1.9 4.3-2.9 9-2.9 13.8 0 19 15.4 34.3 34.3 34.3l2 0c9.6 0 18.8-3.8 25.7-10.6l277-276.8C509.4 85.9 523.7 80 538.5 80l27 0c14.9 0 29.1 5.9 39.6 16.4l16.3 16.3c1.7 1.7 2.6 4 2.6 6.3 0 5-4 9-9 9l-64 0c-11.9 0-23.2 5.3-30.8 14.5L271.5 443.6C244.1 476.8 203.3 496 160.3 496 80.6 496 16 431.4 16 351.7l0-2.1c0-13.6 1.9-27.1 5.6-40.2L46 224zM80 384a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm48-112a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"]],
    "window-frame-open": [448, 512, [], "e050", ["M48 64l0 208 168 0 0-256-120 0C69.5 16 48 37.5 48 64zM232 16l0 256 168 0 0-208c0-26.5-21.5-48-48-48L232 16z", "M232 16l0 256 168 0 0-208c0-26.5-21.5-48-48-48L232 16zM416 64l0 224-384 0 0-224C32 28.7 60.7 0 96 0L352 0c35.3 0 64 28.7 64 64zM216 272l0-256-120 0C69.5 16 48 37.5 48 64l0 208 168 0zM8 496l24 0 0-160 16 0 0 160 352 0 0-160 16 0 0 160 24 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L8 512c-4.4 0-8-3.6-8-8s3.6-8 8-8z"]],
    "circle-d": [512, 512, [], "e104", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zm160-88c0-4.4 3.6-8 8-8l72 0c53 0 96 43 96 96s-43 96-96 96l-72 0c-4.4 0-8-3.6-8-8l0-176zm16 8l0 160 64 0c44.2 0 80-35.8 80-80s-35.8-80-80-80l-64 0z", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM184 160c-4.4 0-8 3.6-8 8l0 176c0 4.4 3.6 8 8 8l72 0c53 0 96-43 96-96s-43-96-96-96l-72 0zm72 176l-64 0 0-160 64 0c44.2 0 80 35.8 80 80s-35.8 80-80 80z"]],
    "expand": [448, 512, [], "f065", ["M0 184L0 328c0-4.4 3.6-8 8-8s8 3.6 8 8l0 136 136 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l144 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l136 0 0-136c0-4.4 3.6-8 8-8s8 3.6 8 8l0-144c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-136-136 0c-4.4 0-8-3.6-8-8s3.6-8 8-8L152 32c4.4 0 8 3.6 8 8s-3.6 8-8 8L16 48 16 184c0 4.4-3.6 8-8 8s-8-3.6-8-8z", "M152 32c4.4 0 8 3.6 8 8s-3.6 8-8 8L16 48 16 184c0 4.4-3.6 8-8 8s-8-3.6-8-8L0 40c0-4.4 3.6-8 8-8l144 0zM0 328c0-4.4 3.6-8 8-8s8 3.6 8 8l0 136 136 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L8 480c-4.4 0-8-3.6-8-8L0 328zM296 32l144 0c4.4 0 8 3.6 8 8l0 144c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-136-136 0c-4.4 0-8-3.6-8-8s3.6-8 8-8zM448 328l0 144c0 4.4-3.6 8-8 8l-144 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l136 0 0-136c0-4.4 3.6-8 8-8s8 3.6 8 8z"]],
    "scooter": [512, 512, [], "e7c3", ["M16 400a64 64 0 1 0 128 0 64 64 0 1 0 -128 0zm352 0a64 64 0 1 0 128 0 64 64 0 1 0 -128 0z", "M256 40c0-4.4 3.6-8 8-8l88 0c3.7 0 7 2.6 7.8 6.2l64 280 .5 2.2c2.5-.2 5.1-.4 7.7-.4 44.2 0 80 35.8 80 80s-35.8 80-80 80c-38.7 0-71-27.5-78.4-64l-195.2 0c-7.4 36.5-39.7 64-78.4 64-44.2 0-80-35.8-80-80s35.8-80 80-80 80 35.8 80 80l192 0c0-36 23.8-66.5 56.6-76.5l-.4-1.7-62.6-273.8-81.6 0c-4.4 0-8-3.6-8-8zM144 400a64 64 0 1 0 -128 0 64 64 0 1 0 128 0zm352 0a64 64 0 1 0 -128 0 64 64 0 1 0 128 0z"]],
    "file-mp4": [576, 512, [], "e649", ["M48 64c0-26.5 21.5-48 48-48l133.5 0c3.6 0 7.1 .4 10.5 1.2L240 120c0 30.9 25.1 56 56 56l102.8 0c.8 3.4 1.2 6.9 1.2 10.5l0 149.5-208 0c-26.5 0-48 21.5-48 48l0 112-48 0c-26.5 0-48-21.5-48-48L48 64z", "M96 16l133.5 0c3.6 0 7.1 .4 10.5 1.2L240 120c0 30.9 25.1 56 56 56l102.8 0c.8 3.4 1.2 6.9 1.2 10.5l0 149.5 16 0 0-149.5c0-17-6.7-33.3-18.7-45.3L274.7 18.7C262.7 6.7 246.5 0 229.5 0L96 0C60.7 0 32 28.7 32 64l0 384c0 35.3 28.7 64 64 64l48 0 0-16-48 0c-26.5 0-48-21.5-48-48L48 64c0-26.5 21.5-48 48-48zM392 160l-96 0c-22.1 0-40-17.9-40-40l0-96c2.7 1.8 5.1 3.8 7.4 6.1L385.9 152.6c2.3 2.3 4.3 4.8 6.1 7.4zM214.9 403.9c-1.8-3.1-5.5-4.6-9-3.6s-5.9 4.1-5.9 7.7l0 128c0 4.4 3.6 8 8 8s8-3.6 8-8l0-99.1 33.1 55.2c1.4 2.4 4 3.9 6.9 3.9s5.4-1.5 6.9-3.9l33.1-55.2 0 99.1c0 4.4 3.6 8 8 8s8-3.6 8-8l0-128c0-3.6-2.4-6.8-5.9-7.7s-7.1 .5-9 3.6l-41.1 68.6-41.1-68.6zM368 400c-4.4 0-8 3.6-8 8l0 128c0 4.4 3.6 8 8 8s8-3.6 8-8l0-40 24 0c26.5 0 48-21.5 48-48s-21.5-48-48-48l-32 0zm32 80l-24 0 0-64 24 0c17.7 0 32 14.3 32 32s-14.3 32-32 32zm90.3-2.3c1.5 1.5 3.5 2.3 5.7 2.3l56 0 0 56c0 4.4 3.6 8 8 8s8-3.6 8-8l0-128c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 56-48 0 0-56c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 64c0 2.1 .8 4.2 2.3 5.7z"]],
    "note-sticky": [448, 512, [62026, "sticky-note"], "f249", ["M16 96l0 320c0 26.5 21.5 48 48 48l197.5 0c3.6 0 7.1-.4 10.5-1.2L272 360c0-30.9 25.1-56 56-56l102.8 0c.8-3.4 1.2-6.9 1.2-10.5L432 96c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96z", "M64 464c-26.5 0-48-21.5-48-48L16 96c0-26.5 21.5-48 48-48l320 0c26.5 0 48 21.5 48 48l0 197.5c0 3.6-.4 7.1-1.2 10.5L328 304c-30.9 0-56 25.1-56 56l0 102.8c-3.4 .8-6.9 1.2-10.5 1.2L64 464zM424 320c-1.8 2.7-3.8 5.1-6.1 7.4L295.4 449.9c-2.3 2.3-4.8 4.3-7.4 6.1l0-96c0-22.1 17.9-40 40-40l96 0zM0 416c0 35.3 28.7 64 64 64l197.5 0c17 0 33.3-6.7 45.3-18.7L429.3 338.7c12-12 18.7-28.3 18.7-45.3L448 96c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416z"]],
    "dolphin": [512, 512, [], "e168", ["M16 245.8C16 260.3 27.7 272 42.2 272l163.6 0c2.8-.8 5.8-.1 7.9 2l74.1 72.6c3.5 3.5 8.3 5.4 13.3 5.4 10.5 0 19-8.5 19-19l0-61c0-4.4 3.6-8 8-8l4 0c42 0 76 34 76 76s-34 76-76 76l-71.2 0c-2.9 0-5.5-1.5-6.9-4-14.9-25.9-42.1-42.5-72.2-43.9l33.3 60c1.3 2.4 1.3 5.4 0 7.8l-33.3 60c30.1-1.4 57.2-18 72.2-43.9 1.4-2.5 4.1-4 6.9-4l87 0c81.9 0 148.3-66.4 148.3-148.3 0-71.1-26.1-136-69.3-185.8-2.3-2.6-2.6-6.3-.8-9.3 11.1-18.7 24.7-43.5 32.6-63.3 4-10.1 6.1-18 6.1-22.9 0-1.2-.1-2-.2-2.4-.1 0-.2 0-.4 0-36.1 0-85.1 15.5-120.8 29-2.1 .8-4.4 .7-6.4-.3-37.6-18.4-79.9-28.7-124.6-28.7L172 16c-68.5 0-124 55.5-124 124 0 20.1 4.8 39 13.2 55.7 1.9 3.8 .5 8.4-3.1 10.5L29 223.2c-8 4.7-13 13.3-13 22.6zM160 144a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M48 140C48 71.5 103.5 16 172 16l40.3 0c44.7 0 87 10.3 124.6 28.7 2 1 4.3 1.1 6.4 .3 35.7-13.5 84.7-29 120.8-29 .2 0 .3 0 .4 0 .1 .4 .2 1.1 .2 2.4 0 4.9-2.1 12.8-6.1 22.9-7.9 19.9-21.5 44.6-32.6 63.3-1.8 3-1.4 6.7 .8 9.3 43.2 49.8 69.3 114.7 69.3 185.8 0 81.9-66.4 148.3-148.3 148.3l-87 0c-2.9 0-5.5 1.5-6.9 4-14.9 25.9-42.1 42.5-72.2 43.9l33.3-60c1.3-2.4 1.3-5.4 0-7.8l-33.3-60c30.1 1.4 57.2 18 72.2 43.9 1.4 2.5 4.1 4 6.9 4l71.2 0c42 0 76-34 76-76s-34-76-76-76l-4 0c-4.4 0-8 3.6-8 8l0 61c0 10.5-8.5 19-19 19-5 0-9.7-1.9-13.3-5.4L213.6 274c-2.1-2-5.1-2.8-7.9-2L42.2 272c-14.4 0-26.2-11.7-26.2-26.2 0-9.3 4.9-17.9 13-22.6l29.1-17c3.7-2.1 5-6.7 3.1-10.5-8.4-16.7-13.2-35.7-13.2-55.7zM42.2 288l162.9 0 71.5 70c6.5 6.4 15.3 10 24.5 10 19.3 0 35-15.7 35-35l0-52.9c31.3 2.1 56 28.1 56 59.9 0 33.1-26.9 60-60 60l-66.7 0c-18.9-29.6-51.8-48-87.6-48l-9.6 0c-2.8 0-5.5 1.5-6.9 3.9s-1.5 5.5-.1 7.9L198.8 432 161 500.1c-1.4 2.5-1.3 5.5 .1 7.9s4.1 3.9 6.9 3.9l9.6 0c35.8 0 68.7-18.4 87.6-48l82.5 0c90.7 0 164.3-73.5 164.3-164.3 0-73-26.1-139.9-69.5-191.9 10.6-18.2 23.2-41.3 30.8-60.7 4.1-10.3 7.2-20.6 7.2-28.7 0-4.1-.7-8.8-3.7-12.6-3.3-4.2-8-5.9-13-5.9-38.1 0-87.7 15.6-123.2 28.9-39-18.5-82.5-28.9-128.5-28.9L172 0c-77.3 0-140 62.7-140 140 0 19.9 4.2 38.9 11.7 56.1L20.9 209.4C8 217 0 230.8 0 245.8 0 269.1 18.9 288 42.2 288zM144 160a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"]],
    "border-bottom": [448, 512, [], "f84d", ["M32 80l0 64c8.8 0 16 7.2 16 16s-7.2 16-16 16l0 64c8.8 0 16 7.2 16 16s-7.2 16-16 16l0 64c8.8 0 16 7.2 16 16s-7.2 16-16 16l0 96 384 0 0-96c-8.8 0-16-7.2-16-16s7.2-16 16-16l0-64c-8.8 0-16-7.2-16-16s7.2-16 16-16l0-64c-8.8 0-16-7.2-16-16s7.2-16 16-16l0-64c-8.8 0-16-7.2-16-16l-64 0c0 8.8-7.2 16-16 16s-16-7.2-16-16l-64 0c0 8.8-7.2 16-16 16s-16-7.2-16-16l-64 0c0 8.8-7.2 16-16 16s-16-7.2-16-16L48 64c0 8.8-7.2 16-16 16z", "M448 472c0 4.4-3.6 8-8 8L8 480c-4.4 0-8-3.6-8-8s3.6-8 8-8l432 0c4.4 0 8 3.6 8 8zM16 352a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm416 0a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zM16 160a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm416 0a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zM16 256a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm416 0a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zM16 64a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm416 0a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zM208 64a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm-64 0a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm160 0a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"]],
    "user-message": [576, 512, [], "e7b1", ["M9.4 511.9c3.8-.6 6.6-3.9 6.6-7.9l0-24c0-88.4 71.6-160 160-160l96 0c88.4 0 160 71.6 160 160l0 24c0 3.7 2.5 6.9 6 8-142.9 0-285.7 0-428.6-.1zM29.6 382.2c13.6-22.8 33.3-41.5 56.9-53.8-22.7 13.5-42.2 31.9-56.9 53.8zM112 128c0-61.9 50.1-112 112-112 18 0 35 4.3 50.1 11.8-1.4 6.5-2.1 13.3-2.1 20.2l0 96c0 26.1 10.4 49.7 27.2 67-19.9 18-46.3 29-75.2 29-61.9 0-112-50.1-112-112zM367.2 332c17.3 10.2 32.3 24 43.9 40.3-12.2-15.8-27.1-29.4-43.9-40.3z", "M224 240c-61.9 0-112-50.1-112-112S162.1 16 224 16c18 0 35 4.3 50.1 11.8 1.1-5.3 2.7-10.5 4.7-15.5-16.6-7.9-35.2-12.3-54.9-12.3-70.7 0-128 57.3-128 128s57.3 128 128 128c33.8 0 64.5-13.1 87.4-34.5-4.3-3.2-8.4-6.7-12.2-10.6-19.9 18-46.3 29-75.2 29zM16 480c0-88.4 71.6-160 160-160l96 0c88.4 0 160 71.6 160 160l0 24c0 4.4 3.6 8 8 8s8-3.6 8-8l0-24c0-97.2-78.8-176-176-176l-96 0C78.8 304 0 382.8 0 480l0 24c0 4.4 3.6 8 8 8s8-3.6 8-8l0-24zM400 192c0-8.8-7.2-16-16-16l-16 0c-17.7 0-32-14.3-32-32l0-96c0-17.7 14.3-32 32-32l160 0c17.7 0 32 14.3 32 32l0 96c0 17.7-14.3 32-32 32l-64 0c-4.2 0-8.3 1.7-11.3 4.7L400 233.4 400 192zm-80-48c0 26.5 21.5 48 48 48l16 0 0 41.4c0 14.3 17.2 21.4 27.3 11.3l52.7-52.7 64 0c26.5 0 48-21.5 48-48l0-96c0-26.5-21.5-48-48-48L368 0c-26.5 0-48 21.5-48 48l0 96z"]],
    "signal-weak": [448, 512, ["signal-1"], "f68c", ["", "M8 384c4.4 0 8 3.6 8 8l0 80c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-80c0-4.4 3.6-8 8-8z"]],
    "table-columns": [448, 512, ["columns"], "f0db", ["M16 176l0 240c0 26.5 21.5 48 48 48l152 0 0-288-200 0zm216 0l0 288 152 0c26.5 0 48-21.5 48-48l0-240-200 0z", "M16 96c0-26.5 21.5-48 48-48l320 0c26.5 0 48 21.5 48 48l0 64-416 0 0-64zm0 320l0-240 200 0 0 288-152 0c-26.5 0-48-21.5-48-48zm216 48l0-288 200 0 0 240c0 26.5-21.5 48-48 48l-152 0zM0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416z"]],
    "person-shelter": [512, 512, [], "e54f", ["M200 265c14.1-15.7 34.3-25 56-25s41.9 9.3 56 25l0 32.3-8 0 0 6.7c-4.4 0-8 3.6-8 8l0 168c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-96c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 96c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-168c0-4.4-3.6-8-8-8 0-2.2 0-4.5 0-6.7l-8 0 0-32.3zm80-97a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M260.2 1.2c-2.6-1.6-5.8-1.6-8.4 0l-248 152c-2.4 1.5-3.8 4-3.8 6.8L0 504c0 4.4 3.6 8 8 8s8-3.6 8-8L16 164.5 256 17.4 496 164.5 496 504c0 4.4 3.6 8 8 8s8-3.6 8-8l0-344c0-2.8-1.4-5.4-3.8-6.8l-248-152zM232 168a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm64 0a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zM216 312c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 168c0 17.7 14.3 32 32 32 9.6 0 18.1-4.2 24-10.8 5.9 6.6 14.4 10.8 24 10.8 17.7 0 32-14.3 32-32l0-168c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 168c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-96c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 96c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-168zm-27.1-30.8C201.8 255.9 227.7 240 256 240s54.2 15.9 67.1 41.2l37.8 74.5c2 3.9 6.8 5.5 10.8 3.5s5.5-6.8 3.5-10.8l-37.8-74.5c-15.5-30.6-47-49.9-81.3-49.9s-65.8 19.3-81.3 49.9l-37.8 74.5c-2 3.9-.4 8.8 3.5 10.8s8.8 .4 10.8-3.5l37.8-74.5z"]],
    "camera-security": [448, 512, ["camera-home"], "f8fe", ["M16 64l0 288c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-288c0-26.5-21.5-48-48-48L64 16C37.5 16 16 37.5 16 64zM336 208a112 112 0 1 1 -224 0 112 112 0 1 1 224 0z", "M64 16l320 0c26.5 0 48 21.5 48 48l0 288c0 26.5-21.5 48-48 48L64 400c-26.5 0-48-21.5-48-48L16 64c0-26.5 21.5-48 48-48zM232 416l152 0c35.3 0 64-28.7 64-64l0-288c0-35.3-28.7-64-64-64L64 0C28.7 0 0 28.7 0 64L0 352c0 35.3 28.7 64 64 64l152 0 0 80-80 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l176 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-80 0 0-80zM128 208a96 96 0 1 1 192 0 96 96 0 1 1 -192 0zm208 0a112 112 0 1 0 -224 0 112 112 0 1 0 224 0z"]],
    "circle-notch": [512, 512, [], "f1ce", ["", "M224 9.9c.7 4.4-2.3 8.5-6.6 9.2-114.2 18.5-201.4 117.5-201.4 236.9 0 132.5 107.5 240 240 240S496 388.5 496 256c0-119.4-87.2-218.4-201.4-236.9-4.4-.7-7.3-4.8-6.6-9.2s4.8-7.3 9.2-6.6C419 23 512 128.6 512 256 512 397.4 397.4 512 256 512S0 397.4 0 256c0-127.4 93-233 214.8-252.7 4.4-.7 8.5 2.3 9.2 6.6z"]],
    "water": [512, 512, [], "f773", ["M0 135.1c0 .3 0 .5 0 .7 .4 4.4 4.3 7.6 8.7 7.2 26.5-2.4 51.5-15.9 73.5-31.6 28.8-20.5 67.6-20.5 96.4 0 25.5 18.2 51 32.6 77.4 32.6s51.9-14.4 77.4-32.6c28.8-20.5 67.6-20.5 96.4 0 22 15.7 47 29.2 73.5 31.6 4.4 .4 8.3-2.8 8.7-7.2 0-.2 0-.4 0-.6l0 144c-.1-4.3-3.2-7.7-7.3-8.1-22.2-2-44.5-13.6-65.7-28.7-34.3-24.5-80.6-24.5-115 0-25.4 18.1-47.2 29.6-68.1 29.6s-42.7-11.5-68.1-29.6c-34.3-24.5-80.6-24.5-115 0-21.2 15.1-43.4 26.7-65.7 28.7-4.1 .4-7.3 3.8-7.3 7.9L0 135.1zM0 279c0 .3 0 .5 0 .8 .4 4.4 4.3 7.6 8.7 7.2 26.5-2.4 51.5-15.9 73.5-31.6 28.8-20.5 67.6-20.5 96.4 0 25.5 18.2 51 32.6 77.4 32.6s51.9-14.4 77.4-32.6c28.8-20.5 67.6-20.5 96.4 0 22 15.7 47 29.2 73.5 31.6 4.4 .4 8.3-2.8 8.7-7.2 0-.2 0-.4 0-.6l0 143.9c-.1-4.2-3.2-7.6-7.3-8-22.2-2-44.5-13.6-65.7-28.7-34.3-24.5-80.6-24.5-115 0-25.4 18.1-47.2 29.6-68.1 29.6s-42.7-11.5-68.1-29.6c-34.3-24.5-80.6-24.5-115 0-21.2 15.1-43.4 26.7-65.7 28.7-4.1 .4-7.3 3.8-7.3 8L0 279z", "M429.8 111.4c22 15.7 47 29.2 73.5 31.6 4.4 .4 8.3-2.8 8.7-7.2s-2.8-8.3-7.2-8.7c-22.2-2-44.5-13.6-65.7-28.7-34.3-24.5-80.6-24.5-115 0-25.4 18.1-47.2 29.6-68.1 29.6s-42.7-11.5-68.1-29.6c-34.3-24.5-80.6-24.5-115 0-21.2 15.1-43.4 26.7-65.7 28.7-4.4 .4-7.6 4.3-7.2 8.7s4.3 7.6 8.7 7.2c26.5-2.4 51.5-15.9 73.5-31.6 28.8-20.5 67.6-20.5 96.4 0 25.5 18.2 51 32.6 77.4 32.6s51.9-14.4 77.4-32.6c28.8-20.5 67.6-20.5 96.4 0zm0 144c22 15.7 47 29.2 73.5 31.6 4.4 .4 8.3-2.8 8.7-7.2s-2.8-8.3-7.2-8.7c-22.2-2-44.5-13.6-65.7-28.7-34.3-24.5-80.6-24.5-115 0-25.4 18.1-47.2 29.6-68.1 29.6s-42.7-11.5-68.1-29.6c-34.3-24.5-80.6-24.5-115 0-21.2 15.1-43.4 26.7-65.7 28.7-4.4 .4-7.6 4.3-7.2 8.7s4.3 7.6 8.7 7.2c26.5-2.4 51.5-15.9 73.5-31.6 28.8-20.5 67.6-20.5 96.4 0 25.5 18.2 51 32.6 77.4 32.6s51.9-14.4 77.4-32.6c28.8-20.5 67.6-20.5 96.4 0zm-96.4 144c28.8-20.5 67.6-20.5 96.4 0 22 15.7 47 29.2 73.5 31.6 4.4 .4 8.3-2.8 8.7-7.2s-2.8-8.3-7.2-8.7c-22.2-2-44.5-13.6-65.7-28.7-34.3-24.5-80.6-24.5-115 0-25.4 18.1-47.2 29.6-68.1 29.6s-42.7-11.5-68.1-29.6c-34.3-24.5-80.6-24.5-115 0-21.2 15.1-43.4 26.7-65.7 28.7-4.4 .4-7.6 4.3-7.2 8.7s4.3 7.6 8.7 7.2c26.5-2.4 51.5-15.9 73.5-31.6 28.8-20.5 67.6-20.5 96.4 0 25.5 18.2 51 32.6 77.4 32.6s51.9-14.4 77.4-32.6z"]],
    "delete-left": [640, 512, [9003, "backspace"], "f55a", ["M16 256c0 4.2 1.7 8.3 4.7 11.3L171.3 417.9c9 9 21.2 14.1 33.9 14.1L512 432c26.5 0 48-21.5 48-48l0-256c0-26.5-21.5-48-48-48L205.3 80c-12.7 0-24.9 5.1-33.9 14.1L20.7 244.7c-3 3-4.7 7.1-4.7 11.3zm270.8-65.2c3.1-3.1 8.2-3.1 11.3 0l53.8 53.8 53.8-53.8c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3l-53.8 53.8 53.8 53.8c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-53.8-53.8-53.8 53.8c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l53.8-53.8-53.8-53.8c-3.1-3.1-3.1-8.2 0-11.3z", "M560 128c0-26.5-21.5-48-48-48L205.3 80c-12.7 0-24.9 5.1-33.9 14.1L20.7 244.7c-3 3-4.7 7.1-4.7 11.3s1.7 8.3 4.7 11.3L171.3 417.9c9 9 21.2 14.1 33.9 14.1L512 432c26.5 0 48-21.5 48-48l0-256zM9.4 233.4L160 82.7c12-12 28.3-18.7 45.3-18.7L512 64c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64l-306.7 0c-17 0-33.3-6.7-45.3-18.7L9.4 278.6c-6-6-9.4-14.1-9.4-22.6s3.4-16.6 9.4-22.6zm407.8 76.5c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-53.8-53.8-53.8 53.8c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l53.8-53.8-53.8-53.8c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0l53.8 53.8 53.8-53.8c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3l-53.8 53.8 53.8 53.8z"]],
    "circle-rupee": [512, 512, [], "e714", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zm112-88c0-4.4 3.6-8 8-8l64 0c35.3 0 64 28.7 64 64 0 28.8-19.1 53.2-45.3 61.2L247.4 357c1.6 4.1-.4 8.8-4.5 10.4s-8.8-.4-10.4-4.5l-30-75c-.9 0-1.7 .1-2.6 .1l-56 0 0 72c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-192zm16 8l0 96 56 0c26.5 0 48-21.5 48-48s-21.5-48-48-48l-56 0zm152 75.2c0-23.8 19.3-43.2 43.2-43.2l36.8 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-36.8 0c-15 0-27.2 12.2-27.2 27.2 0 12.9 9.1 24.1 21.8 26.6l23.5 4.7c20.2 4 34.7 21.8 34.7 42.3 0 23.8-19.3 43.2-43.2 43.2L312 368c-4.4 0-8-3.6-8-8s3.6-8 8-8l36.8 0c15 0 27.2-12.2 27.2-27.2 0-13-9.1-24.1-21.8-26.6l-23.5-4.7c-20.2-4-34.7-21.8-34.7-42.3z", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM136 160c-4.4 0-8 3.6-8 8l0 192c0 4.4 3.6 8 8 8s8-3.6 8-8l0-72 56 0c.9 0 1.7 0 2.6-.1l30 75c1.6 4.1 6.3 6.1 10.4 4.5s6.1-6.3 4.5-10.4l-28.7-71.8c26.2-8 45.3-32.4 45.3-61.2 0-35.3-28.7-64-64-64l-64 0zm64 112l-56 0 0-96 56 0c26.5 0 48 21.5 48 48s-21.5 48-48 48zm96-20.8c0 20.6 14.5 38.3 34.7 42.3l23.5 4.7c12.7 2.5 21.8 13.7 21.8 26.6 0 15-12.2 27.2-27.2 27.2L312 352c-4.4 0-8 3.6-8 8s3.6 8 8 8l36.8 0c23.8 0 43.2-19.3 43.2-43.2 0-20.6-14.5-38.3-34.7-42.3l-23.5-4.7c-12.7-2.5-21.8-13.7-21.8-26.6 0-15 12.2-27.2 27.2-27.2l36.8 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-36.8 0c-23.8 0-43.2 19.3-43.2 43.2z"]],
    "arrow-down-to-square": [448, 512, [], "e096", ["M16 160l0 288c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-288c0-26.5-21.5-48-48-48l-152 0 0 212.7 74.3-74.3c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3l-88 88c-3.1 3.1-8.2 3.1-11.3 0l-88-88c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0l74.3 74.3 0-212.7-152 0c-26.5 0-48 21.5-48 48z", "M232-24c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 348.7-74.3-74.3c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l88 88c3.1 3.1 8.2 3.1 11.3 0l88-88c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0L232 324.7 232-24zM16 160c0-26.5 21.5-48 48-48l56 0c4.4 0 8-3.6 8-8s-3.6-8-8-8L64 96C28.7 96 0 124.7 0 160L0 448c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-288c0-35.3-28.7-64-64-64l-56 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l56 0c26.5 0 48 21.5 48 48l0 288c0 26.5-21.5 48-48 48L64 496c-26.5 0-48-21.5-48-48l0-288z"]],
    "square-b": [448, 512, [], "e264", ["M16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96zm144 72c0-4.4 3.6-8 8-8l68 0c28.7 0 52 23.3 52 52 0 15.7-6.9 29.7-17.9 39.2 19.8 7.4 33.9 26.4 33.9 48.8 0 28.7-23.3 52-52 52l-84 0c-4.4 0-8-3.6-8-8l0-176zm16 8l0 72 60 0c19.9 0 36-16.1 36-36s-16.1-36-36-36l-60 0zm0 88l0 72 76 0c19.9 0 36-16.1 36-36s-16.1-36-36-36l-76 0z", "M64 48C37.5 48 16 69.5 16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm160 72c0-4.4 3.6-8 8-8l68 0c28.7 0 52 23.3 52 52 0 15.7-6.9 29.7-17.9 39.2 19.8 7.4 33.9 26.4 33.9 48.8 0 28.7-23.3 52-52 52l-84 0c-4.4 0-8-3.6-8-8l0-176zm112 44c0-19.9-16.1-36-36-36l-60 0 0 72 60 0c19.9 0 36-16.1 36-36zM176 336l76 0c19.9 0 36-16.1 36-36s-16.1-36-36-36l-76 0 0 72z"]],
    "broom-ball": [576, 512, ["quidditch", "quidditch-broom-ball"], "f458", ["M16 490.1l.5 2.3c.9 2.1 3 3.6 5.4 3.6l175.1 0 6.2-.2c29.2-1.4 56.9-12.9 78.6-32.5l4.5-4.3c24.5-24.5 37.8-57.8 37-92.2l-.3-6.9-2.5-32.8-71.7-71.7-32.8-2.5c-36.8-2.8-73 10.6-99.1 36.7l-8.7 8.7C90.2 316.4 80 341.1 80 366.7l.4 .9c.2 .2 .6 .4 .9 .4l30.7 0 2.5 .2c5.7 .9 10.5 4.8 12.5 10.3 2.3 6.3 .5 13.3-4.6 17.7L18.1 485.6c-1.3 1.1-2.1 2.7-2.1 4.5zM264.9 248.9l62.1 62.1 45.2-5.6c2.2-.3 3.8-2.1 3.8-4.3 0-1.1-.5-2.3-1.3-3.1L278 201.3c-.8-.8-1.9-1.3-3.1-1.3-2.2 0-4 1.6-4.3 3.8l-5.7 45.1zM432 464a64 64 0 1 0 128 0 64 64 0 1 0 -128 0z", "M496 544a80 80 0 1 1 0-160 80 80 0 1 1 0 160zm0-144a64 64 0 1 0 0 128 64 64 0 1 0 0-128zM562.3 2.3c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3L343.3 244 386 286.7c3.8 3.8 6 9 6 14.4 0 10.2-7.6 18.9-17.8 20.2l-37.8 4.7 2.5 32.7c3.2 41.4-11.9 82.2-41.3 111.6l-5.1 4.9C266.5 498.8 232.4 512 197 512l-175.1 0-4.4-.5c-8.6-1.8-15.3-8.5-17.1-17L0 490.1c0-5.6 2.1-10.9 5.9-15l1.8-1.7 104.3-89.4-30.7 0-3.5-.3c-6.8-1.4-12.1-6.7-13.5-13.5l-.3-3.5c0-28 10.4-55 29.1-75.7l3.9-4 8.7-8.7c27.6-27.6 65.1-42.5 103.8-41.7l7.8 .4 32.7 2.5 4.8-37.7c1.3-10.2 9.9-17.8 20.2-17.8 5.4 0 10.6 2.2 14.4 6L332 232.7 562.3 2.3zM216.1 253c-36.8-2.8-73 10.6-99.1 36.7l-8.7 8.7C90.2 316.4 80 341.1 80 366.7l.4 .9c.2 .2 .6 .4 .9 .4l30.7 0 2.5 .2c5.7 .9 10.5 4.8 12.5 10.3 2.3 6.3 .5 13.3-4.6 17.7L18.1 485.6c-1.3 1.1-2.1 2.7-2.1 4.5l.5 2.3c.9 2.1 3 3.6 5.4 3.6l175.1 0 6.2-.2c29.2-1.4 56.9-12.9 78.6-32.5l4.5-4.3c24.5-24.5 37.8-57.8 37-92.2l-.3-6.9-2.5-32.8-71.7-71.7-32.8-2.5zm58.8-53c-2.2 0-4 1.6-4.3 3.8l-5.7 45.1 62.1 62.1 45.2-5.6c2.2-.3 3.8-2.1 3.8-4.3 0-1.1-.5-2.3-1.3-3.1L278 201.3c-.8-.8-1.9-1.3-3.1-1.3z"]],
    "h6": [512, 512, [], "e413", ["", "M8 64c4.4 0 8 3.6 8 8l0 176 192 0 0-176c0-4.4 3.6-8 8-8s8 3.6 8 8l0 368c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-176-192 0 0 176c0 4.4-3.6 8-8 8s-8-3.6-8-8L0 72c0-4.4 3.6-8 8-8zM384 80c-44.2 0-80 35.8-80 80l0 90.9C321.2 225 350.6 208 384 208l32 0c53 0 96 43 96 96l0 48c0 53-43 96-96 96l-32 0c-53 0-96-43-96-96l0-192c0-53 43-96 96-96l88 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-88 0zM304 304l0 48c0 44.2 35.8 80 80 80l32 0c44.2 0 80-35.8 80-80l0-48c0-44.2-35.8-80-80-80l-32 0c-44.2 0-80 35.8-80 80z"]],
    "j": [320, 512, [106], "4a", ["", "M312 32c4.4 0 8 3.6 8 8l0 280c0 88.4-71.6 160-160 160S0 408.4 0 320l0-56c0-4.4 3.6-8 8-8s8 3.6 8 8l0 56c0 79.5 64.5 144 144 144s144-64.5 144-144l0-280c0-4.4 3.6-8 8-8z"]],
    "shuttle-space": [576, 512, ["space-shuttle"], "f197", ["M16 80l0 48 80 0 0-80-48 0C30.3 48 16 62.3 16 80zm0 64l0 104 136 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-136 0 0 104 104 0c20.7 0 38.8-11.2 48.5-28 1.4-2.5 4.1-4 6.9-4L392 336c55.7 0 119.6-29.3 158.6-71.6 4.4-4.8 4.4-12 0-16.8-39-42.3-102.9-71.6-158.6-71.6l-216.6 0c-2.9 0-5.5-1.5-6.9-4-9.7-16.8-27.8-28-48.5-28L16 144zm0 240l0 48c0 17.7 14.3 32 32 32l48 0 0-80-80 0zM112 48.5l0 79.5 8 0c25 0 47 12.7 59.9 32L342.2 160 205 77.6c-28.3-17-60.2-26.9-93-29.2zM112 384l0 79.5c32.8-2.2 64.7-12.2 93-29.2l137.3-82.4-162.4 0C167 371.3 145 384 120 384l-8 0zM432 224c0-4.4 3.6-8 8-8s8 3.6 8 8l0 64c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-64z", "M213.2 448.1L373.3 352 392 352c60.5 0 128.5-31.4 170.4-76.8 10-10.9 10-27.6 0-38.5-41.8-45.4-109.9-76.8-170.4-76.8l-18.7 0-160.1-96.1C178.4 43 138.6 32 98 32L48 32C21.5 32 0 53.5 0 80L0 432c0 26.5 21.5 48 48 48l50 0c40.6 0 80.4-11 115.2-31.9zM16 384l80 0 0 80-48 0c-17.7 0-32-14.3-32-32l0-48zm189 50.4c-28.3 17-60.2 26.9-93 29.2l0-79.5 8 0c25 0 47-12.7 59.9-32l162.4 0-137.3 82.4zM16 368l0-104 136 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-136 0 0-104 104 0c20.7 0 38.8 11.2 48.5 28 1.4 2.5 4.1 4 6.9 4L392 176c55.7 0 119.6 29.3 158.6 71.6 4.4 4.8 4.4 12 0 16.8-39 42.3-102.9 71.6-158.6 71.6l-216.6 0c-2.9 0-5.5 1.5-6.9 4-9.7 16.8-27.8 28-48.5 28L16 368zm0-240l0-48c0-17.7 14.3-32 32-32l48 0 0 80-80 0zm104 0l-8 0 0-79.5c32.8 2.2 64.7 12.2 93 29.2l137.3 82.4-162.4 0C167 140.7 145 128 120 128zm320 88c-4.4 0-8 3.6-8 8l0 64c0 4.4 3.6 8 8 8s8-3.6 8-8l0-64c0-4.4-3.6-8-8-8z"]],
    "yin-yang": [512, 512, [9775], "f6ad", ["M16 256c0 100.4 61.6 186.4 149.1 222.2-27.7-24.1-45.1-59.1-45.1-98.2 0-73.1 61.1-132 136-132 66.5 0 120-52.2 120-116S322.5 16 256 16C123.5 16 16 123.5 16 256zM296 128a40 40 0 1 1 -80 0 40 40 0 1 1 80 0zM232 384a24 24 0 1 0 48 0 24 24 0 1 0 -48 0z", "M496 256c0 132.5-107.5 240-240 240-66.5 0-120-52.2-120-116s53.5-116 120-116c74.9 0 136-58.9 136-132 0-39.1-17.4-74.1-45.1-98.2 87.5 35.8 149.1 121.8 149.1 222.2zM256 16c66.5 0 120 52.2 120 116S322.5 248 256 248c-74.9 0-136 58.9-136 132 0 39.1 17.4 74.1 45.1 98.2-87.5-35.8-149.1-121.8-149.1-222.2 0-132.5 107.5-240 240-240zm0 496a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm0-104a24 24 0 1 1 0-48 24 24 0 1 1 0 48zm-40-24a40 40 0 1 0 80 0 40 40 0 1 0 -80 0zm64-256a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zM256 88a40 40 0 1 0 0 80 40 40 0 1 0 0-80z"]],
    "signal-good": [448, 512, ["signal-3"], "f68e", ["", "M232 232c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 240c0 4.4 3.6 8 8 8s8-3.6 8-8l0-240zM120 320c-4.4 0-8 3.6-8 8l0 144c0 4.4 3.6 8 8 8s8-3.6 8-8l0-144c0-4.4-3.6-8-8-8zM8 384c-4.4 0-8 3.6-8 8l0 80c0 4.4 3.6 8 8 8s8-3.6 8-8l0-80c0-4.4-3.6-8-8-8z"]],
    "image-stack": [512, 512, [], "e771", ["M16 224l0 192c0 26.5 21.5 48 48 48l384 0c26.5 0 48-21.5 48-48l0-192c0-26.5-21.5-48-48-48L64 176c-26.5 0-48 21.5-48 48zm112 32a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm3.2 141.9c-5.3-11.1-3.8-24.2 3.9-33.9l64-80c10.9-13.6 30.7-16 44.5-5.4L266 296 310.4 236.8c6.3-8.4 16.4-13.2 27-12.8s20.2 6.1 25.8 15l80 128c6.2 9.9 6.5 22.3 .9 32.5S427.6 416 416 416l-256 0c-12.3 0-23.5-7-28.8-18.1z", "M104-16l304 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L104 0c-4.4 0-8-3.6-8-8s3.6-8 8-8zM56 80l400 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L56 96c-4.4 0-8-3.6-8-8s3.6-8 8-8zm8 96c-26.5 0-48 21.5-48 48l0 192c0 26.5 21.5 48 48 48l384 0c26.5 0 48-21.5 48-48l0-192c0-26.5-21.5-48-48-48L64 176zM0 224c0-35.3 28.7-64 64-64l384 0c35.3 0 64 28.7 64 64l0 192c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 224zm112 32a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm-48 0a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm272.7-16c-5.3-.2-10.3 2.2-13.5 6.4L274 312c-1.3 1.7-3.2 2.8-5.3 3.1s-4.3-.3-6-1.6l-28.9-22.3c-6.9-5.3-16.8-4.1-22.2 2.7l-64 80c-3.8 4.8-4.6 11.4-1.9 16.9s8.3 9.1 14.4 9.1l256 0c5.8 0 11.2-3.2 14-8.2s2.7-11.3-.4-16.2l-80-128c-2.8-4.5-7.6-7.3-12.9-7.5zm-26.3-3.2c6.3-8.4 16.4-13.2 27-12.8s20.2 6.1 25.8 15l80 128c6.2 9.9 6.5 22.3 .9 32.5S427.6 416 416 416l-256 0c-12.3 0-23.5-7-28.8-18.1s-3.8-24.2 3.9-33.9l64-80c10.9-13.6 30.7-16 44.5-5.4L266 296 310.4 236.8z"]],
    "stop": [448, 512, [9209], "f04d", ["M16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96z", "M384 48c26.5 0 48 21.5 48 48l0 320c0 26.5-21.5 48-48 48L64 464c-26.5 0-48-21.5-48-48L16 96c0-26.5 21.5-48 48-48l320 0zM64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32z"]],
    "trowel": [576, 512, [], "e589", ["M56.9 477.1c-2 6.2 3.9 12 10 10l249.5-78.8c5.7-1.8 7.5-9 3.2-13.3L149 224.3c-4.2-4.2-11.5-2.5-13.3 3.2L56.9 477.1zM374.3 94.9c-8.3 8.3-8.3 21.8 0 30.2l44.7 44.7c8.3 8.3 21.8 8.3 30.2 0l95.4-95.4c20.7-20.7 20.7-54.2 0-74.8s-54.2-20.7-74.8 0L374.3 94.9z", "M374.3 94.9c-8.3 8.3-8.3 21.8 0 30.2l44.7 44.7c8.3 8.3 21.8 8.3 30.2 0l95.4-95.4c20.7-20.7 20.7-54.2 0-74.8s-54.2-20.7-74.8 0L374.3 94.9zm-11.3 41.5c-14.6-14.6-14.6-38.2 0-52.8l95.4-95.4c26.9-26.9 70.5-26.9 97.5 0s26.9 70.5 0 97.5l-95.4 95.4c-14.6 14.6-38.2 14.6-52.8 0L390.9 164.4 251.3 304 331 383.7c12.7 12.7 7.4 34.4-9.7 39.9L71.8 502.4c-18.5 5.8-36-11.6-30.1-30.1l78.8-249.5c5.4-17.2 27.1-22.5 39.9-9.7l79.7 79.7 139.6-139.6-16.7-16.7zM149 224.3c-4.2-4.2-11.5-2.5-13.3 3.2L56.9 477.1c-2 6.2 3.9 12 10 10l249.5-78.8c5.7-1.8 7.5-9 3.2-13.3L149 224.3z"]],
    "circle-2": [512, 512, [], "e0ef", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zm176-86.7c0-4.4 3.6-8 8-8l73.8 0c25.5 0 46.2 20.7 46.2 46.3 0 18-10.4 34.4-26.8 41.9l-52.8 24.5c-19.8 9.2-32.4 29-32.4 50.8l0 11.2 104 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-112 0c-4.4 0-8-3.6-8-8l0-19.2c0-28 16.3-53.5 41.7-65.3L286.5 235c10.7-5 17.5-15.7 17.5-27.4 0-16.7-13.5-30.3-30.2-30.3l-73.8 0c-4.4 0-8-3.6-8-8z", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM200 161.3c-4.4 0-8 3.6-8 8s3.6 8 8 8l73.8 0c16.7 0 30.2 13.5 30.2 30.3 0 11.8-6.8 22.5-17.5 27.4l-52.8 24.5c-25.4 11.8-41.7 37.3-41.7 65.3l0 19.2c0 4.4 3.6 8 8 8l112 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-104 0 0-11.2c0-21.8 12.6-41.6 32.4-50.8l52.8-24.5c16.3-7.6 26.8-23.9 26.8-41.9 0-25.5-20.7-46.3-46.2-46.3l-73.8 0z"]],
    "drumstick": [512, 512, [127831], "f6d6", ["M176 185.9C176 92.1 252.1 16 345.9 16 428.8 16 496 83.2 496 166.1 496 259.9 419.9 336 326.1 336l-97 0c-29.3 0-53.1-23.8-53.1-53.1l0-97z", "M176 185.9C176 92.1 252.1 16 345.9 16 428.8 16 496 83.2 496 166.1 496 259.9 419.9 336 326.1 336l-97 0c-29.3 0-53.1-23.8-53.1-53.1l0-97zm336-19.8C512 74.4 437.6 0 345.9 0 243.2 0 160 83.2 160 185.9l0 97c0 .6 0 1.2 0 1.8l-45.8 45.8c-3.1 3.1-9.6 3.6-15.7-.3-10-6.4-21.9-10.1-34.6-10.1-35.3 0-64 28.7-64 64s28.7 64 64 64c0 35.3 28.7 64 64 64s64-28.7 64-64c0-12.7-3.7-24.6-10.1-34.6-3.9-6.1-3.4-12.6-.3-15.7L227.3 352c.6 0 1.2 0 1.8 0l97 0C428.8 352 512 268.8 512 166.1zM208 348.7l-37.7 37.7c-10.3 10.3-8.2 25.8-1.8 35.6 4.8 7.5 7.6 16.4 7.6 25.9 0 26.5-21.5 48-48 48s-48-21.5-48-48c0-8.7-7.3-16-16-16-26.5 0-48-21.5-48-48s21.5-48 48-48c9.6 0 18.5 2.8 25.9 7.6 9.8 6.3 25.3 8.5 35.6-1.8L163.3 304c6.8 21.2 23.5 37.9 44.7 44.7z"]],
    "square-x": [448, 512, [], "e286", ["M16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96zm129.8 77.1c-2.8-3.4-2.3-8.5 1.1-11.3s8.5-2.3 11.3 1.1l65.8 80.4 65.8-80.4c2.8-3.4 7.8-3.9 11.3-1.1s3.9 7.8 1.1 11.3l-67.9 82.9 67.9 82.9c2.8 3.4 2.3 8.5-1.1 11.3s-8.5 2.3-11.3-1.1l-65.8-80.4-65.8 80.4c-2.8 3.4-7.8 3.9-11.3 1.1s-3.9-7.8-1.1-11.3l67.9-82.9-67.9-82.9z", "M64 48C37.5 48 16 69.5 16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm158.2 66.9l65.8 80.4 65.8-80.4c2.8-3.4 7.8-3.9 11.3-1.1s3.9 7.8 1.1 11.3l-67.9 82.9 67.9 82.9c2.8 3.4 2.3 8.5-1.1 11.3s-8.5 2.3-11.3-1.1l-65.8-80.4-65.8 80.4c-2.8 3.4-7.8 3.9-11.3 1.1s-3.9-7.8-1.1-11.3l67.9-82.9-67.9-82.9c-2.8-3.4-2.3-8.5 1.1-11.3s8.5-2.3 11.3 1.1z"]],
    "peapod": [512, 512, [], "e31c", ["M16 416l0 48c0 17.7 14.3 32 32 32l48 0c220.9 0 400-179.1 400-400l0-48c0-17.7-14.3-32-32-32l-48 0C195.1 16 16 195.1 16 416zm192-48a64 64 0 1 1 -128 0 64 64 0 1 1 128 0zM320 256a64 64 0 1 1 -128 0 64 64 0 1 1 128 0zM432 144a64 64 0 1 1 -128 0 64 64 0 1 1 128 0z", "M416 16C195.1 16 16 195.1 16 416l0 48c0 17.7 14.3 32 32 32l48 0c220.9 0 400-179.1 400-400l0-48c0-17.7-14.3-32-32-32l-48 0zm0-16l48 0c26.5 0 48 21.5 48 48l0 48c0 229.8-186.2 416-416 416l-48 0c-26.5 0-48-21.5-48-48l0-48C0 186.2 186.2 0 416 0zM304 144a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zm64 48a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm-112 0a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm48 64a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM144 304a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm48 64a48 48 0 1 0 -96 0 48 48 0 1 0 96 0z"]],
    "message-text": [512, 512, ["comment-alt-text"], "e1e6", ["M16 128l0 224c0 44.2 35.8 80 80 80l32 0c8.8 0 16 7.2 16 16l0 75.9c0 2.3 2 4 4.1 4.1 .8 0 1.7-.2 2.4-.7 3.3-2.3 6.3-4.5 9.1-6.4l.4-.3c6.7-4.7 30.4-21.5 117.2-82.7 5.4-3.8 11.8-5.9 18.5-5.9L416 432c44.2 0 80-35.8 80-80l0-224c0-44.2-35.8-80-80-80L96 48c-44.2 0-80 35.8-80 80zm160 56c0-4.4 3.6-8 8-8l144 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-64 0 0 136c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-136-64 0c-4.4 0-8-3.6-8-8z", "M144 448l0 75.9c0 2.3 2 4 4.1 4.1 .8 0 1.7-.2 2.4-.7 3.3-2.3 6.3-4.5 9.1-6.4l.4-.3c6.7-4.7 30.4-21.5 117.2-82.7 5.4-3.8 11.8-5.9 18.5-5.9L416 432c44.2 0 80-35.8 80-80l0-224c0-44.2-35.8-80-80-80L96 48c-44.2 0-80 35.8-80 80l0 224c0 44.2 35.8 80 80 80l32 0c8.8 0 16 7.2 16 16zM0 128C0 75 43 32 96 32l320 0c53 0 96 43 96 96l0 224c0 53-43 96-96 96l-120.4 0c-3.3 0-6.5 1-9.2 2.9L159.8 540.3c-3.4 2.4-7.5 3.7-11.6 3.7-11.1 0-20.1-9-20.1-20.1l0-75.9-32 0c-53 0-96-43-96-96L0 128zm184 48l144 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-64 0 0 136c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-136-64 0c-4.4 0-8-3.6-8-8s3.6-8 8-8z"]],
    "hand-back-fist": [384, 512, ["hand-rock"], "f255", ["M16 191c.5-23.7 18.2-43.2 41.1-46.5 3.9-.6 6.9-3.9 6.9-7.9 0-26.9 0-53.7 0-80.6 0-.2 0-.4 0-.6 1.2-22.7 18.6-39.4 40-39.4 13.9 0 26.2 7.1 33.3 17.9 1.5 2.2 4 3.6 6.7 3.6s5.2-1.3 6.7-3.6c7.2-10.8 19.4-17.9 33.3-17.9 15.5 0 28.9 8.8 35.6 21.7 1.1 2.1 3.1 3.6 5.4 4.1s4.7 0 6.6-1.5c6.8-5.2 15.2-8.3 24.4-8.3 17.8 0 32.8 11.6 38 27.6 1.3 3.9 5.3 6.2 9.3 5.3 2.8-.6 5.7-.9 8.6-.9 21.1 0 38.4 16.3 39.9 36.8 .1 1.1 .1 2.1 .1 3.2 0 2.7 0 5.3 0 8 0 47.4 0 80.6 0 99.5-.2 22.2-7.5 43.8-20.8 61.6l-47.2 62.9-194.3 0-59-64.4c-8.8-9.5-13.9-21.8-14.7-34.7 0-1 0-2.1 0-3.2 0-14.3 0-28.5 0-42.8zM48 416c0-8.8 7.2-16 16-16l256 0c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16L64 496c-8.8 0-16-7.2-16-16l0-64z", "M18.9 282.4C6.8 269.1 0 251.8 0 233.8L0 192c0-29.8 20.4-54.9 48-62l0-74c0-30.9 25.1-56 56-56 15.7 0 29.8 6.4 40 16.8 10.2-10.4 24.3-16.8 40-16.8 18.5 0 35 9 45.1 22.9 8-4.4 17.1-6.9 26.9-6.9 22.4 0 41.8 13.2 50.7 32.2 1.7-.2 3.5-.2 5.3-.2 30.9 0 56 25.1 56 56l0 72 0 .1 0 34.6c0 26-8.4 51.2-24 72l-40 53.3-20 0 47.2-62.9c13.5-18 20.8-39.9 20.8-62.4l0-34.7 0-.1 0-71.9c0-22.1-17.9-40-40-40-3 0-5.9 .3-8.6 .9-4 .9-8-1.4-9.3-5.3-5.2-16-20.3-27.6-38-27.6-9.2 0-17.7 3.1-24.4 8.3-1.9 1.5-4.3 2-6.6 1.5s-4.3-2-5.4-4.1c-6.7-12.9-20.1-21.7-35.6-21.7-13.9 0-26.2 7.1-33.3 17.9-1.5 2.2-4 3.6-6.7 3.6s-5.2-1.3-6.7-3.6C130.2 23.1 117.9 16 104 16 81.9 16 64 33.9 64 56l0 80.6c0 4-2.9 7.4-6.9 7.9-23.3 3.3-41.1 23.3-41.1 47.5l0 41.8c0 14 5.3 27.5 14.7 37.8l59 64.4-21.7 0-49.1-53.6zM48 416l0 64c0 8.8 7.2 16 16 16l256 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16L64 400c-8.8 0-16 7.2-16 16zM32 480l0-64c0-17.7 14.3-32 32-32l256 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32L64 512c-17.7 0-32-14.3-32-32z"]],
    "snowman-head": [448, 512, ["frosty-head"], "f79b", ["M80 64c0-26.5 21.5-48 48-48l192 0c26.5 0 48 21.5 48 48l0 112-288 0 0-112zM192 366.8c0-17 13.8-30.8 30.8-30.8l2.3 0c17 0 30.8 13.8 30.8 30.8 0 4.8-1.1 9.5-3.3 13.8l-28.7 57.5-28.7-57.5c-2.1-4.3-3.3-9-3.3-13.8z", "M128 16l192 0c26.5 0 48 21.5 48 48l0 112 16 0 0-112c0-35.3-28.7-64-64-64L128 0C92.7 0 64 28.7 64 64l0 112 16 0 0-112c0-26.5 21.5-48 48-48zM368 224l5.9 0c26.4 32.9 42.1 74.6 42.1 120 0 56.8-24.6 107.8-63.8 142.9-6.6 5.9-15.9 9.1-26.4 9.1l-203.5 0c-10.5 0-19.9-3.2-26.4-9.1-39.2-35.2-63.8-86.2-63.8-142.9 0-45.4 15.8-87.1 42.1-120L368 224zM8 208c-4.4 0-8 3.6-8 8s3.6 8 8 8l46.1 0c-24 33.9-38.1 75.3-38.1 120 0 61.5 26.7 116.8 69.1 154.8 10.1 9.1 23.6 13.2 37.1 13.2l203.5 0c13.6 0 27-4.1 37.1-13.2 42.4-38.1 69.1-93.3 69.1-154.8 0-44.7-14.1-86.1-38.1-120l46.1 0c4.4 0 8-3.6 8-8s-3.6-8-8-8L8 208zM144 320a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm176-16a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm-97.2 16c-25.9 0-46.8 21-46.8 46.8 0 7.3 1.7 14.4 4.9 20.9l35.9 71.8c1.4 2.7 4.1 4.4 7.2 4.4s5.8-1.7 7.2-4.4l35.9-71.8c3.3-6.5 4.9-13.7 4.9-20.9 0-25.9-21-46.8-46.8-46.8l-2.3 0zm-27.6 60.6c-2.1-4.3-3.3-9-3.3-13.8 0-17 13.8-30.8 30.8-30.8l2.3 0c17 0 30.8 13.8 30.8 30.8 0 4.8-1.1 9.5-3.3 13.8l-28.7 57.5-28.7-57.5z"]],
    "blanket": [448, 512, [], "f498", ["M16 120c0-39.8 32.2-72 72-72l272 0c39.8 0 72 32.2 72 72l0 196.2c-8.5-7.6-19.7-12.2-32-12.2L88 304c-29.8 0-56.1 14.8-72 37.4L16 120z", "M16 120l0 221.4C31.9 318.8 58.2 304 88 304l312 0c12.3 0 23.5 4.6 32 12.2L432 120c0-39.8-32.2-72-72-72L88 48c-39.8 0-72 32.2-72 72zM.4 384L0 384 0 120C0 71.4 39.4 32 88 32l272 0c48.6 0 88 39.4 88 88l0 232c0 26.5-21.5 48-48 48L88 400c-4.4 0-8-3.6-8-8s3.6-8 8-8l312 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L88 320c-39.8 0-72 32.2-72 72s32.2 72 72 72l352 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L88 480c-48.6 0-88-39.4-88-88 0-2.7 .1-5.4 .4-8z"]],
    "comment-xmark": [512, 512, ["comment-times"], "f4b5", ["M16 240c0 51.7 18.8 99.4 50.5 137.4 4.1 4.9 4.9 11.7 2 17.4l-49.4 98.7 124.8-49.9c3.9-1.6 8.3-1.5 12.2 .1 30.4 13 64.2 20.2 99.9 20.2 133.5 0 240-101.2 240-224S389.5 16 256 16 16 117.2 16 240zm174.8-65.2c3.1-3.1 8.2-3.1 11.3 0l53.8 53.8 53.8-53.8c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3l-53.8 53.8 53.8 53.8c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-53.8-53.8-53.8 53.8c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l53.8-53.8-53.8-53.8c-3.1-3.1-3.1-8.2 0-11.3z", "M68.5 394.8c2.8-5.7 2-12.5-2-17.4-31.7-38-50.5-85.7-50.5-137.4 0-122.8 106.5-224 240-224S496 117.2 496 240 389.5 464 256 464c-35.7 0-69.5-7.3-99.9-20.2-3.9-1.7-8.3-1.7-12.2-.1L19.1 493.5 68.5 394.8zM0 240c0 55.7 20.2 106.9 54.2 147.7L1.4 493.3C-4 504 7.6 515.4 18.4 511l131.5-52.6c32.3 13.8 68.3 21.5 106.2 21.5 141.4 0 256-107.5 256-240S397.4 0 256 0 0 107.5 0 240zm190.8 53.8c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l53.8-53.8 53.8 53.8c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-53.8-53.8 53.8-53.8c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0l-53.8 53.8-53.8-53.8c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l53.8 53.8-53.8 53.8z"]],
    "person-dolly-empty": [512, 512, [], "f4d1", ["M16.5 171.1l0 103.5c0 23.4 10.2 45.5 27.9 60.7L111.7 393c10.6 9.1 16.8 22.4 16.8 36.4l0 82.6c0 8.8 7.2 16 16 16s16-7.2 16-16l0-82.6c0-23.4-10.2-45.5-27.9-60.7L99.3 340.2c-1.8-1.5-2.8-3.7-2.8-6.1l0-115.2c0-3.5 2.2-6.6 5.6-7.6s6.9 .1 9 3l17.3 24.3c15 21 39.3 33.5 65.1 33.5l31.1 0c8.8 0 15.9-7 16-15.7l0-.5c-.1-8.7-7.2-15.7-16-15.7l-31.1 0c-15.5 0-30-7.5-39.1-20.1l-48.7-68.2C95 136.8 77.9 128 59.6 128 35.8 128 16.5 147.3 16.5 171.1zm0 214l0 126.9c0 8.8 7.2 16 16 16s16-7.2 16-16l0-99.5c-10.7-9.1-21.3-18.3-32-27.4zM24.5 24a40 40 0 1 0 80 0 40 40 0 1 0 -80 0zm8 520c17.7 0 32-14.3 32-32-.1 17.8-14.4 32-32 32z", "M104.5 24a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zm-96 0a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zM.5 171.1c0-32.6 26.5-59.1 59.1-59.1 23.5 0 45.5 11.3 59.1 30.4l48.7 68.2c6 8.4 15.7 13.4 26 13.4l31.1 0c5.8 0 11.3 1.6 16 4.3l0-68.3c0-4.4 3.6-8 8-8s8 3.6 8 8l0 304c19.4 0 35.5 13.7 39.2 32l184.8 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-184.8 0c-3.7 18.3-19.8 32-39.2 32-22.1 0-40-17.9-40-40 0-16.4 9.9-30.5 24-36.7l0-183.6c-4.7 2.7-10.2 4.3-16 4.3l-31.1 0c-31 0-60.1-15-78.1-40.2l-2.8-3.9 0 86.6 30.5 26.1c21.3 18.2 33.5 44.9 33.5 72.9l0 82.6c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-82.6c0-9.3-4.1-18.2-11.2-24.3L34 347.5C12.7 329.2 .5 302.6 .5 274.6l0-103.5zm240 84.7c-.1-8.7-7.2-15.7-16-15.7l-31.1 0c-15.5 0-30-7.5-39.1-20.1l-48.7-68.2C95 136.8 77.9 128 59.6 128 35.8 128 16.5 147.3 16.5 171.1l0 103.5c0 23.4 10.2 45.5 27.9 60.7L111.7 393c10.6 9.1 16.8 22.4 16.8 36.4l0 82.6c0 8.8 7.2 16 16 16s16-7.2 16-16l0-82.6c0-23.4-10.2-45.5-27.9-60.7L99.3 340.2c-1.8-1.5-2.8-3.7-2.8-6.1l0-115.2c0-3.5 2.2-6.6 5.6-7.6s6.9 .1 9 3l17.3 24.3c15 21 39.3 33.5 65.1 33.5l31.1 0c8.8 0 15.9-7 16-15.7l0-.5zM.5 370.9c2.4 2.4 4.9 4.7 7.5 6.9l8.5 7.3 0 126.9c0 8.8 7.2 16 16 16s16-7.2 16-16l0-99.5 16 13.7 0 85.7c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-141.1zM280.5 504a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"]],
    "signal-slash": [576, 512, [], "f695", ["", "M13.7-29.8c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l560 560c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3L512 468.6 512 40c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 412.6-96-96 0-220.6c0-4.4-3.6-8-8-8s-8 3.6-8 8L384 340.6 13.7-29.8zM296 343.2l-16-16 0 144.8c0 4.4 3.6 8 8 8s8-3.6 8-8l0-128.8zM184 320c-4.4 0-8 3.6-8 8l0 144c0 4.4 3.6 8 8 8s8-3.6 8-8l0-144c0-4.4-3.6-8-8-8zM72 384c-4.4 0-8 3.6-8 8l0 80c0 4.4 3.6 8 8 8s8-3.6 8-8l0-80c0-4.4-3.6-8-8-8z"]],
    "hexagon-plus": [576, 512, ["plus-hexagon"], "f300", ["M47.4 228.2c-9.8 17.2-9.9 38.3-.1 55.5 32.1 56.1 64.2 112.1 96.3 168.2 9.9 17.3 28.2 28 48 28.2 .2 0 .4 0 .6 0l191.6 0c.2 0 .4 0 .6 0 19.7-.2 37.9-10.8 47.8-27.9 .1-.1 .1-.2 .2-.3l96.2-168.1c9.9-17.4 9.8-38.5 0-55.6-32.1-56-64.1-112-96.2-168.1-10-17.4-28.5-28.2-48.6-28.2L192.2 32c-20.1 0-38.6 10.8-48.6 28.2-32.1 56-64.1 112-96.2 168.1zM176 256c0-4.4 3.6-8 8-8l96 0 0-96c0-4.4 3.6-8 8-8s8 3.6 8 8l0 96 96 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-96 0 0 96c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-96-96 0c-4.4 0-8-3.6-8-8z", "M47.4 283.9l96.2 168.1c10 17.4 28.5 28.2 48.6 28.2l191.6 0c20.1 0 38.6-10.8 48.6-28.2l96.2-168.1c9.9-17.2 9.9-38.4 0-55.6L432.4 60.2C422.5 42.8 403.9 32 383.8 32L192.2 32c-20.1 0-38.6 10.8-48.6 28.2L47.4 228.2c-9.9 17.2-9.9 38.4 0 55.6zm-13.9 7.9c-12.7-22.2-12.7-49.4 0-71.5L129.7 52.2C142.5 29.8 166.4 16 192.2 16l191.6 0c25.8 0 49.7 13.8 62.5 36.2l96.2 168.1c12.7 22.2 12.7 49.4 0 71.5L446.3 459.9c-12.8 22.4-36.7 36.2-62.5 36.2l-191.6 0c-25.8 0-49.7-13.8-62.5-36.2L33.5 291.8zM280 360l0-96-96 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l96 0 0-96c0-4.4 3.6-8 8-8s8 3.6 8 8l0 96 96 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-96 0 0 96c0 4.4-3.6 8-8 8s-8-3.6-8-8z"]],
    "temperature-high": [448, 512, [], "f769", ["M32 368c0 70.7 57.3 128 128 128s128-57.3 128-128c0-39.1-17.5-74.1-45.2-97.6-1.8-1.5-2.8-3.7-2.8-6.1L240 96c0-44.2-35.8-80-80-80S80 51.8 80 96l0 168.3c0 2.3-1 4.6-2.8 6.1-27.7 23.5-45.2 58.5-45.2 97.6zm64 0c0-32.6 24.4-59.6 56-63.5L152 96c0-4.4 3.6-8 8-8s8 3.6 8 8l0 208.5c31.6 3.9 56 30.9 56 63.5 0 35.3-28.7 64-64 64s-64-28.7-64-64z", "M80 96c0-44.2 35.8-80 80-80s80 35.8 80 80l0 168.3c0 2.3 1 4.6 2.8 6.1 27.7 23.5 45.2 58.5 45.2 97.6 0 70.7-57.3 128-128 128S32 438.7 32 368c0-39.1 17.5-74.1 45.2-97.6 1.8-1.5 2.8-3.8 2.8-6.1L80 96zM160 0C107 0 64 43 64 96l0 164.7C34.6 287 16 325.4 16 368 16 447.5 80.5 512 160 512s144-64.5 144-144c0-42.6-18.6-81-48-107.3L256 96c0-53-43-96-96-96zM112 368a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm112 0c0-32.6-24.4-59.6-56-63.5L168 96c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 208.5c-31.6 3.9-56 30.9-56 63.5 0 35.3 28.7 64 64 64s64-28.7 64-64zM336 64a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm112 0a64 64 0 1 0 -128 0 64 64 0 1 0 128 0z"]],
    "greater-than": [512, 512, [62769], "3e", ["", "M32.7 36.6c-1.9 4-.1 8.8 3.9 10.6L485 256 36.6 464.8c-4 1.9-5.7 6.6-3.9 10.6s6.6 5.7 10.6 3.9l464-216c2.8-1.3 4.6-4.1 4.6-7.3s-1.8-5.9-4.6-7.3l-464-216c-4-1.9-8.8-.1-10.6 3.9z"]],
    "toothbrush": [576, 512, [129701], "f635", ["M16 160c0 26.5 21.5 48 48 48l288 0c44.2 0 80-35.8 80-80 0-23.9-10.3-42-26.5-55.1-16.2-13.2-38.6-21.5-61.9-24-.8 13.3-3 28.9-11.3 41.4-9.2 14-24.1 21.7-44.3 21.7L64 112c-26.5 0-48 21.5-48 48zm0 288c0 8.8 7.2 16 16 16l536 0c4.4 0 8 3.6 8 8.1l0-48.1c0 4.4-3.6 8-8 8L32 432c-8.8 0-16 7.2-16 16z", "M64 208c-26.5 0-48-21.5-48-48s21.5-48 48-48l224 0c20.2 0 35.1-7.8 44.3-21.7 8.3-12.5 10.5-28.2 11.3-41.4l0-.1c23.4 2.6 45.7 10.8 61.9 24 16.1 13.1 26.5 31.2 26.5 55.1 0 44.2-35.8 80-80 80L64 208zM0 160c0 35.3 28.7 64 64 64l288 0c53 0 96-43 96-96 0-58.5-51.6-89.9-104-95.2-8.8-.9-15.8 6.4-16.4 15.2-1.5 25.3-8.4 48-39.6 48L64 96C28.7 96 0 124.7 0 160zM64 264c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 152-16 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l536 0c4.4 0 8-3.6 8-8s-3.6-8-8-8L32 464c-8.8 0-16-7.2-16-16s7.2-16 16-16l536 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-184 0 0-152c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 152-48 0 0-152c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 152-48 0 0-152c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 152-48 0 0-152c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 152-48 0 0-152c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 152-48 0 0-152z"]],
    "flute": [576, 512, [], "f8b9", ["M41.4 417.4c-12.5 12.5-12.5 32.8 0 45.3l40 40c12.5 12.5 32.8 12.5 45.3 0L237 392.3 151.7 307 41.4 417.4zM144 416a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm19-120.3L248.3 381 534.6 94.6c12.5-12.5 12.5-32.8 0-45.3l-40-40c-12.5-12.5-32.8-12.5-45.3 0L163 295.7zM312 248a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm64-64a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm64-64a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M449.4 9.4L163 295.7 248.3 381 534.6 94.6c12.5-12.5 12.5-32.8 0-45.3l-40-40c-12.5-12.5-32.8-12.5-45.3 0zM151.7 307L41.4 417.4c-12.5 12.5-12.5 32.8 0 45.3l40 40c12.5 12.5 32.8 12.5 45.3 0L237 392.3 151.7 307zM438.1-1.9c18.7-18.7 49.1-18.7 67.9 0l40 40c18.7 18.7 18.7 49.1 0 67.9l-408 408c-18.7 18.7-49.1 18.7-67.9 0l-40-40c-18.7-18.7-18.7-49.1 0-67.9l408-408zM280 248a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM128 400a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM344 184a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm80-80a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"]],
    "lobster": [512, 512, [129438], "e421", ["M16 72l0 56c0 26.5 21.5 48 48 48s48-21.5 48-48l0-48c0-4.4 3.5-7.9 8-8-12.9 0-25.7 0-38.6 0l-9.6 41.8c-1 4.3-5.3 7-9.6 6s-7-5.3-6-9.6L77.9 16 72 16C41.1 16 16 41.1 16 72zM176 492.8c0 1.8 1.4 3.2 3.2 3.2l153.6 0c1.8 0 3.2-1.4 3.2-3.2 0-20.3-16.5-36.8-36.8-36.8l-2.7 0c-2.5 0-4.8-1.2-6.3-3.1s-2-4.5-1.4-6.9l8.9-33.5-4.4 1.3c-24.4 7-50.3 7-74.7 0l-4.4-1.3 8.9 33.5c.6 2.4 .1 5-1.4 6.9s-3.9 3.1-6.3 3.1l-2.7 0c-20.3 0-36.8 16.5-36.8 36.8zM200 208l0 89.8 26.9 6.7c19.1 4.8 39.1 4.8 58.2 0l26.9-6.7 0-89.8c0-22.2-8.8-42.8-20.5-59.8-11.5-16.6-25.5-29-35.5-35.1-10 6.1-23.9 18.5-35.5 35.1-11.7 16.9-20.5 37.6-20.5 59.8zm0 106.2l0 31.5 26.9 6.7c19.1 4.8 39.1 4.8 58.2 0l26.9-6.7 0-31.5-23 5.8c-21.7 5.4-44.3 5.4-66 0l-23-5.8zm.9 48.2l8.5 31.9 13.6 3.9c21.5 6.2 44.4 6.2 65.9 0l13.6-3.9 8.5-31.9-22.1 5.5c-21.7 5.4-44.3 5.4-66 0l-22.1-5.5zM392 72c4.4 0 8 3.6 8 8l0 48c0 26.5 21.5 48 48 48s48-21.5 48-48l0-56c0-30.9-25.1-56-56-56l-5.9 0 21.7 94.2c1 4.3-1.7 8.6-6 9.6s-8.6-1.7-9.6-6L430.6 72 392 72z", "M72 16C41.1 16 16 41.1 16 72l0 56c0 26.5 21.5 48 48 48s48-21.5 48-48l0-48c0-4.4 3.6-8 8-8s8 3.6 8 8l0 48c0 18.6-7.9 35.4-20.6 47.1l23.9 20c10.1 8.4 22.8 13 35.9 13l16.8 0c0-26.4 10.4-50.2 23.4-68.9 2.8-4 5.7-7.8 8.6-11.3L216 64c0-17.7-14.3-32-32-32l-8 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l8 0c26.5 0 48 21.5 48 48l0 47.3c5.8-5.1 11.4-9.3 16.4-12.3 4.7-2.8 10.5-2.8 15.1 0 5 3 10.6 7.1 16.4 12.3L280 64c0-26.5 21.5-48 48-48l8 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-8 0c-17.7 0-32 14.3-32 32l0 63.8c3 3.6 5.9 7.3 8.6 11.3 13 18.7 23.4 42.5 23.4 68.9l16.8 0c13.1 0 25.8-4.6 35.8-13l23.9-20C391.9 163.4 384 146.6 384 128l0-48c0-4.4 3.6-8 8-8s8 3.6 8 8l0 48c0 26.5 21.5 48 48 48s48-21.5 48-48l0-56c0-30.9-25.1-56-56-56l-5.9 0 21.7 94.2c1 4.3-1.7 8.6-6 9.6s-8.6-1.7-9.6-6l-24-104c-.5-2.4 0-4.9 1.5-6.8s3.8-3 6.3-3l16 0c39.8 0 72 32.2 72 72l0 56c0 35.3-28.7 64-64 64-10.8 0-20.9-2.7-29.9-7.4l-27.2 22.7C378 218.1 361.7 224 344.8 224l-16.8 0 0 32 40.9 0c8.7 0 17.3-2 25-5.9l34.5-17.2c4-2 8.8-.4 10.7 3.6s.4 8.8-3.6 10.7l-34.5 17.2c-10 5-21 7.6-32.2 7.6l-40.9 0 0 32 59.7 0c7.1 0 14.2-1.4 20.8-4L437 288.6c4.1-1.6 8.8 .4 10.4 4.5s-.4 8.8-4.5 10.4l-28.6 11.4c-8.5 3.4-17.6 5.1-26.7 5.1l-59.7 0 0 32 4.6 0c14.2 0 28.1 4.2 39.9 12.1l7.9 5.3c3.7 2.5 4.7 7.4 2.2 11.1s-7.4 4.7-11.1 2.2l-7.9-5.3c-9.2-6.1-20-9.4-31.1-9.4l-6.5 0-19.3 72.5c25.6 3.7 45.2 25.7 45.2 52.3 0 10.6-8.6 19.2-19.2 19.2l-153.6 0c-10.6 0-19.2-8.6-19.2-19.2 0-26.6 19.6-48.6 45.2-52.3l-19.3-72.5-6.5 0c-11.1 0-21.9 3.3-31.1 9.4l-7.9 5.3c-3.7 2.5-8.6 1.5-11.1-2.2s-1.5-8.6 2.2-11.1l7.9-5.3c11.8-7.9 25.7-12.1 39.9-12.1l4.6 0 0-32-59.7 0c-9.2 0-18.2-1.7-26.7-5.1L69 303.4c-4.1-1.6-6.1-6.3-4.5-10.4s6.3-6.1 10.4-4.5L103.5 300c6.6 2.6 13.7 4 20.8 4l59.7 0 0-32-40.9 0c-11.2 0-22.2-2.6-32.2-7.6L76.4 247.2c-4-2-5.6-6.8-3.6-10.7s6.8-5.6 10.7-3.6l34.5 17.2c7.8 3.9 16.4 5.9 25 5.9l40.9 0 0-32-16.8 0c-16.8 0-33.2-5.9-46.1-16.7L93.9 184.6c-8.9 4.7-19.1 7.4-29.9 7.4-35.3 0-64-28.7-64-64L0 72C0 32.2 32.2 0 72 0L88 0c2.4 0 4.7 1.1 6.3 3s2.1 4.4 1.5 6.8l-24 104c-1 4.3-5.3 7-9.6 6s-7-5.3-6-9.6L77.9 16 72 16zM200 216l0 81.8 26.9 6.7c19.1 4.8 39.1 4.8 58.2 0l26.9-6.7 0-89.8c0-22.2-8.8-42.8-20.5-59.8-11.5-16.6-25.5-29-35.5-35.1-10 6.1-23.9 18.5-35.5 35.1-11.7 16.9-20.5 37.6-20.5 59.8l0 8zm0 129.8l26.9 6.7c19.1 4.8 39.1 4.8 58.2 0l26.9-6.7 0-31.5-23 5.8c-21.7 5.4-44.3 5.4-66 0l-23-5.8 0 31.5zm.9 16.7l8.5 31.9 13.6 3.9c21.5 6.2 44.4 6.2 65.9 0l13.6-3.9 8.5-31.9-22.1 5.5c-21.7 5.4-44.3 5.4-66 0l-22.1-5.5zm22.3 83.5c.6 2.4 .1 5-1.4 6.9s-3.9 3.1-6.3 3.1l-2.7 0c-20.3 0-36.8 16.5-36.8 36.8 0 1.8 1.4 3.2 3.2 3.2l153.6 0c1.8 0 3.2-1.4 3.2-3.2 0-20.3-16.5-36.8-36.8-36.8l-2.7 0c-2.5 0-4.8-1.2-6.3-3.1s-2-4.5-1.4-6.9l8.9-33.5-4.4 1.3c-24.4 7-50.3 7-74.7 0l-4.4-1.3 8.9 33.5z"]],
    "calendar-circle-exclamation": [576, 512, [], "e46e", ["M48 192l432 0 0 22c-15.3-3.9-31.4-6-48-6-106 0-192 86-192 192 0 22.4 3.8 44 10.9 64L96 464c-26.5 0-48-21.5-48-48l0-224z", "M160 8c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 56-48 0c-35.3 0-64 28.7-64 64l0 288c0 35.3 28.7 64 64 64l161.4 0c-2.4-5.2-4.6-10.6-6.5-16L96 464c-26.5 0-48-21.5-48-48l0-224 432 0 0-64c0-35.3-28.7-64-64-64l-48 0 0-56c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 56-192 0 0-56zM144 80l0 24c0 4.4 3.6 8 8 8s8-3.6 8-8l0-24 192 0 0 24c0 4.4 3.6 8 8 8s8-3.6 8-8l0-24 48 0c26.5 0 48 21.5 48 48l0 48-416 0 0-48c0-26.5 21.5-48 48-48l48 0zM304 400a128 128 0 1 1 256 0 128 128 0 1 1 -256 0zm272 0a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zM432 476a12 12 0 1 0 0-24 12 12 0 1 0 0 24zm0-164c-4.4 0-8 3.6-8 8l0 96c0 4.4 3.6 8 8 8s8-3.6 8-8l0-96c0-4.4-3.6-8-8-8z"]],
    "mobile-rotate": [576, 512, [], "e813", ["M62.1 158.1c-18.7 18.7-18.7 49.1 0 67.9l255.8 255.8 4 3.7c18.8 15.2 46.5 14.1 64.1-3.4l128-128 3.1-3.4c14.5-17.6 14.6-43.2 .2-60.8-1.2-1.3-2.4-2.6-3.5-3.9L258 30.1c-17.5-17.5-45.2-18.7-64.1-3.5l-4 3.7-127.8 127.8zM362.3 394.3l64-64 1.3-1c3.1-2 7.3-1.7 10.1 1s3.1 7 1 10.1l-1 1.2-64 64c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3z", "M58.3 338.3c3.1-3.1 8.2-3.1 11.3 0l56 56 1 1.3c2.1 3.1 1.7 7.3-1 10.1s-7 3.1-10.1 1l-1.2-1-42.3-42.3 0 56.7c0 50.8 41.2 92 92 92 25.9 0 49.3-10.8 66-28l11.3 11.3c-19.6 20.1-47 32.7-77.3 32.7-59.6 0-108-48.4-108-108l0-56.7-42.3 42.3-1.3 1c-3.1 2-7.3 1.7-10.1-1s-3.1-7-1-10.1l1-1.3 56-56zm125.3-324c25.1-20.5 62.2-19 85.7 4.4l256 256 4.4 4.8c20.5 25.1 19 62.2-4.4 85.7l-128 128-4.6 4.1c-21.9 18.1-53 19.4-76.2 3.9l-4.8-3.6-4.8-4.4-256-256c-23.4-23.4-24.9-60.5-4.4-85.7l4.4-4.8 128-128 4.8-4.4zM258 30.1c-17.5-17.5-45.2-18.7-64.1-3.5l-4 3.7-127.8 127.8c-18.7 18.7-18.7 49.1 0 67.9l255.8 255.8 4 3.7c18.8 15.2 46.5 14.1 64.1-3.4l128-128 3.1-3.4c14.5-17.6 14.6-43.2 .2-60.8l0 0-3.5-3.9-255.8-255.8zM427.6 329.3c3.1-2 7.3-1.7 10.1 1s3.1 7 1 10.1l-1 1.2-64 64c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l64-64 1.3-1zM412-16c59.6 0 108 48.4 108 108l0 56.7 42.3-42.3 1.3-1c3.1-2 7.3-1.7 10.1 1s3.1 7 1 10.1l-1 1.3-56 56c-3.1 3.1-8.2 3.1-11.3 0l-56-56-1-1.3c-2-3.1-1.7-7.3 1-10.1s7-3.1 10.1-1l1.2 1 42.3 42.3 0-56.7c0-50.8-41.2-92-92-92-25.9 0-49.3 10.8-66 28L334.7 16.7C354.3-3.5 381.7-16 412-16z"]],
    "crutch": [512, 512, [], "f7f7", ["M316.7 28.7c-6.2 6.2-6.2 16.4 0 22.6l144 144c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-144-144c-6.2-6.2-16.4-6.2-22.6 0z", "M350.6 17.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l6.3 6.3-162.6 162.6c-13.5 13.5-21.1 31.8-21.1 50.9l0 67c0 14.9-5.9 29.1-16.4 39.6l0 0-69.3 69.3 0 0-40 40c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0c21.8-21.8 58.2-58.2 109.3-109.3 10.5-10.5 24.7-16.4 39.6-16.4l67 0c19.1 0 37.4-7.6 50.9-21.1l162.6-162.6 6.3 6.3c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-144-144zM431.7 189L332 288.7 223.3 180 323 80.3 431.7 189zM339.3 28.7l144 144c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-144-144c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0zM160.4 242.9L212 191.3 320.7 300 269.1 351.6c-10.5 10.5-24.7 16.4-39.6 16.4l-67 0c-7.5 0-14.9 1.2-21.9 3.4 2.2-7 3.4-14.4 3.4-21.9l0-67c0-14.9 5.9-29.1 16.4-39.6z"]],
    "command": [512, 512, [], "e142", ["", "M96 192l80 0 0 128-80 0c-53 0-96 43-96 96s43 96 96 96 96-43 96-96l0-80 128 0 0 80c0 53 43 96 96 96s96-43 96-96-43-96-96-96l-80 0 0-128 80 0c53 0 96-43 96-96s-43-96-96-96-96 43-96 96l0 80-128 0 0-80c0-53-43-96-96-96S0 43 0 96 43 192 96 192zM256 320l-64 0 0-128 128 0 0 128-64 0zM96 176c-44.2 0-80-35.8-80-80s35.8-80 80-80 80 35.8 80 80l0 80-80 0zm80 240c0 44.2-35.8 80-80 80s-80-35.8-80-80 35.8-80 80-80l80 0 0 80zM336 176l0-80c0-44.2 35.8-80 80-80s80 35.8 80 80-35.8 80-80 80l-80 0zm80 160c44.2 0 80 35.8 80 80s-35.8 80-80 80-80-35.8-80-80l0-80 80 0z"]],
    "tv-retro": [512, 512, [128250], "f401", ["M16 160l0 256c0 26.5 21.5 48 48 48l384 0c26.5 0 48-21.5 48-48l0-256c0-26.5-21.5-48-48-48L64 112c-26.5 0-48 21.5-48 48zm48 48c0-26.5 21.5-48 48-48l224 0c26.5 0 48 21.5 48 48l0 160c0 26.5-21.5 48-48 48l-224 0c-26.5 0-48-21.5-48-48l0-160zm400 4a28 28 0 1 1 -56 0 28 28 0 1 1 56 0zm0 80a28 28 0 1 1 -56 0 28 28 0 1 1 56 0z", "M146.3 2.3c3.1-3.1 8.2-3.1 11.3 0l93.7 93.7 9.4 0 93.7-93.7c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3L283.3 96 448 96c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 160c0-35.3 28.7-64 64-64l164.7 0-82.3-82.3c-3.1-3.1-3.1-8.2 0-11.3zM264 112L64 112c-26.5 0-48 21.5-48 48l0 256c0 26.5 21.5 48 48 48l384 0c26.5 0 48-21.5 48-48l0-256c0-26.5-21.5-48-48-48l-184 0zM436 224a12 12 0 1 0 0-24 12 12 0 1 0 0 24zm0-40a28 28 0 1 1 0 56 28 28 0 1 1 0-56zm0 120a12 12 0 1 0 0-24 12 12 0 1 0 0 24zm0-40a28 28 0 1 1 0 56 28 28 0 1 1 0-56zM112 176c-17.7 0-32 14.3-32 32l0 160c0 17.7 14.3 32 32 32l224 0c17.7 0 32-14.3 32-32l0-160c0-17.7-14.3-32-32-32l-224 0zM64 208c0-26.5 21.5-48 48-48l224 0c26.5 0 48 21.5 48 48l0 160c0 26.5-21.5 48-48 48l-224 0c-26.5 0-48-21.5-48-48l0-160z"]],
    "paw-claws": [512, 512, [], "f702", ["M16.2 213.8l-.2 4.8 .1 3.5c.6 8.4 3.4 17.5 8.7 26.2l2.8 4.3c7 9.7 16 16.8 25.2 20.5 10.5 4.3 20.7 4.1 28.6-.2 7.8-4.3 12.9-12.5 14.2-23 1.3-10.6-1.2-23.2-8.5-35.2s-17.5-20.6-28-24.8c-9.2-3.7-18.1-4.1-25.5-1.2l-3.1 1.4c-8 4.4-13.2 12.9-14.3 23.8zM80 431.7l0 4.4c0 15.4 12.5 27.9 27.9 27.9 11.7 0 23.3-1.8 34.5-5.3l80.2-25 8.2-2.2c19.3-4.5 39.6-3.7 58.6 2.2l80.2 25 8.5 2.3c8.5 2 17.3 3 26 3 15.4 0 27.9-12.5 27.9-27.9l0-4.4c0-6.6-.8-13-2.3-19l-1.9-5.9C377.3 270.7 289.5 240 256 240 223.6 240 140.1 268.8 89.1 394.3l-4.8 12.4c-2.9 7.7-4.2 16.2-4.2 24.9zm48.1-335l-.1 4.5 .3 6.4c.5 6.5 1.9 13.2 4.1 20l2.4 6.3c6 14.3 15.3 25.6 25.6 32.8 11.8 8.2 24.6 10.7 35.8 7 11.2-3.7 19.9-13.2 24.5-26.7s4.7-30.6-1.1-47.8-16.2-30.9-28-39.1c-10.3-7.2-21.4-10-31.5-8.1L155.8 53c-15.4 5.1-26.4 21.6-27.7 43.7zM291.3 147c4.6 13.5 13.3 23 24.5 26.7 11.2 3.7 24 1.2 35.8-7 10.3-7.2 19.6-18.5 25.6-32.8l2.4-6.3c2.2-6.7 3.6-13.5 4.1-20l.3-6.4-.1-4.5c-1.3-22.1-12.3-38.6-27.7-43.7l-4.3-1.1c-10.1-1.9-21.2 .9-31.5 8.1-11.8 8.2-22.2 21.9-28 39.1s-5.6 34.3-1.1 47.8zm125 103c1.3 10.5 6.4 18.7 14.3 23 7.9 4.4 18.1 4.5 28.6 .2 9.2-3.7 18.2-10.8 25.2-20.5l2.8-4.3c5.3-8.7 8.1-17.8 8.7-26.2l.1-3.5-.2-4.8c-1.2-10.9-6.4-19.3-14.3-23.8l-3.1-1.4c-7.4-2.9-16.3-2.5-25.5 1.2-10.5 4.3-20.8 12.8-28 24.8s-9.8 24.7-8.5 35.2z", "M256 224c41.3 0 134.4 35.9 186.8 177.2 3.6 9.7 5.2 20.1 5.2 30.5l0 4.4-.2 4.5c-2.3 22.1-21 39.4-43.7 39.4l-10-.4c-6.6-.5-13.2-1.5-19.7-3l-9.6-2.6-80.2-25.1c-18.6-5.8-38.6-5.8-57.2 0l-80.2 25.1-9.6 2.6c-9.7 2.2-19.7 3.4-29.7 3.4l-4.5-.2c-20.7-2.1-37.1-18.5-39.2-39.2l-.2-4.5 0-4.4c0-7.8 .9-15.6 2.9-23.1l2.3-7.4C121.6 259.9 214.7 224 256 224zm0 16c-32.4 0-115.9 28.8-166.9 154.3l-4.8 12.4c-2.9 7.7-4.2 16.2-4.2 24.9l0 4.4c0 15.4 12.5 27.9 27.9 27.9 11.7 0 23.3-1.8 34.5-5.3l80.2-25 8.2-2.2c19.3-4.5 39.6-3.7 58.6 2.2l80.2 25 8.5 2.3c8.5 2 17.3 3 26 3 15.4 0 27.9-12.5 27.9-27.9l0-4.4c0-6.6-.8-13-2.3-19l-1.9-5.9C377.3 270.7 289.5 240 256 240zM8 120c4.4 0 8 3.6 8 8l0 52.8c2.1-1.8 4.3-3.4 6.8-4.8l5-2.3c11.9-4.7 25.2-3.6 37.3 1.3 13.9 5.7 26.7 16.6 35.7 31.4s12.5 31 10.7 45.5c-1.8 14.6-9.2 27.8-22.4 35-13.1 7.2-28.5 6.7-42.4 1-12.1-5-23.5-14-32.1-26l-3.5-5.3C4.6 245.9 1 234.4 .2 223.4L0 218.7 0 128c0-4.4 3.6-8 8-8zm496 0c4.4 0 8 3.6 8 8l0 90.7-.2 4.7c-.8 11.1-4.5 22.6-10.9 33.3l-3.5 5.3c-8.6 12.1-20 21.1-32.1 26-13.9 5.7-29.3 6.2-42.4-1-13.2-7.3-20.5-20.5-22.4-35-1.8-14.5 1.7-30.8 10.7-45.5s21.8-25.7 35.7-31.4c12.1-4.9 25.4-6 37.3-1.3l5 2.3c2.5 1.4 4.8 3 6.8 4.8l0-52.8c0-4.4 3.6-8 8-8zM59.2 189.9c-9.2-3.7-18.1-4.1-25.5-1.2l-3.1 1.4c-8 4.4-13.2 12.9-14.3 23.8l-.2 4.8 .1 3.5c.6 8.4 3.4 17.5 8.7 26.2l2.8 4.3c7 9.7 16 16.8 25.2 20.5 10.5 4.3 20.7 4.1 28.6-.2 7.8-4.3 12.9-12.5 14.2-23 1.3-10.6-1.2-23.2-8.5-35.2s-17.5-20.6-28-24.8zm419.2-1.2c-7.4-2.9-16.3-2.5-25.5 1.2-10.5 4.3-20.8 12.8-28 24.8s-9.8 24.7-8.5 35.2c1.3 10.5 6.4 18.7 14.3 23 7.9 4.4 18.1 4.5 28.6 .2 9.2-3.7 18.2-10.8 25.2-20.5l2.8-4.3c5.3-8.7 8.1-17.8 8.7-26.2l.1-3.5-.2-4.8c-1.2-10.9-6.4-19.3-14.3-23.8l-3.1-1.4zM120-16c4.4 0 8 3.6 8 8l0 61.3c6-7.1 13.6-12.5 22.8-15.5l6.4-1.6c15.1-2.8 30.4 1.7 43.4 10.7 14.9 10.3 27.3 26.9 34.1 47.2s6.8 40.9 1 58.1-17.6 31.2-34.7 36.8c-17 5.6-35 1.3-49.9-9.1-13.1-9-24.2-22.9-31.3-39.8l-2.8-7.4c-2.6-7.9-4.3-15.9-4.9-23.7L112 101.2 112-8c0-4.4 3.6-8 8-8zm272 0c4.4 0 8 3.6 8 8l0 109.2-.3 7.7c-.6 7.8-2.3 15.8-4.9 23.7L392 140c-7.1 16.9-18.2 30.7-31.3 39.8-14.9 10.3-32.8 14.6-49.9 9.1-17.1-5.6-28.9-19.6-34.7-36.8s-5.7-37.8 1-58.1 19.2-36.8 34.1-47.2c13-9 28.4-13.5 43.4-10.7l6.4 1.6c9.2 3 16.8 8.4 22.8 15.5L384-8c0-4.4 3.6-8 8-8zM191.6 60c-10.3-7.2-21.4-10-31.5-8.1L155.8 53c-15.4 5.1-26.4 21.6-27.7 43.7l-.1 4.5 .3 6.4c.5 6.5 1.9 13.2 4.1 20l2.4 6.3c6 14.3 15.3 25.6 25.6 32.8 11.8 8.2 24.6 10.7 35.8 7 11.2-3.7 19.9-13.2 24.5-26.7s4.7-30.6-1.1-47.8-16.2-30.9-28-39.1zm160.3-8.1c-10.1-1.9-21.2 .9-31.5 8.1-11.8 8.2-22.2 21.9-28 39.1s-5.6 34.3-1.1 47.8 13.3 23 24.5 26.7c11.2 3.7 24 1.2 35.8-7 10.3-7.2 19.6-18.5 25.6-32.8l2.4-6.3c2.2-6.7 3.6-13.5 4.1-20l.3-6.4-.1-4.5c-1.3-22.1-12.3-38.6-27.7-43.7l-4.3-1.1z"]],
    "septagon": [576, 512, ["heptagon"], "e820", ["M26.7 287.8C23.5 302 26.9 317 36 328.4l119.3 149.6 3.6 4.1c8.9 8.9 21.1 14 33.9 14l191.3 0c14.6 0 28.4-6.6 37.5-18.1l119-149.3 3.6-5c5.6-9.1 8.1-19.7 6.9-30.3l-.9-5.6-42.6-186.5c-2.8-12.3-10.4-23-20.9-29.8l-5.4-3-172-82.8c-11.5-5.5-24.6-6.2-36.6-2.1l-5.1 2.1-172.4 83C83.9 74.2 75.2 83.9 71 95.6l-1.7 6-42.5 186.2z", "M267.4-31.5c15.9-5.5 33.5-4.6 48.8 2.8l172.4 83 6.3 3.5c14.2 9 24.5 23.3 28.3 39.9l42.6 186.5 1.2 7.2c1.6 14.3-1.7 28.8-9.4 41.1l-4.2 5.9-119.3 149.6-4.8 5.4c-10.2 10.2-23.6 16.6-38 18.3l-7.3 .4-191.3 0-7.2-.4c-14.4-1.6-27.7-8.1-38-18.3L142.8 488 23.5 338.4C12.8 325.1 8 308.1 9.9 291.4l1.2-7.2 42.6-186.5 2-7c4.9-13.9 14.4-25.7 27-33.4l5.6-3 172.4-83 6.7-2.8zm41.9 17.2c-11.5-5.5-24.6-6.2-36.6-2.1l-5.1 2.1-172.4 83C83.9 74.2 75.2 83.9 71 95.6l-1.7 6-42.5 186.2C23.5 302 26.9 317 36 328.4l119.3 149.6 3.6 4.1c8.9 8.9 21.1 14 33.9 14l191.3 0c14.6 0 28.4-6.6 37.5-18.1l119-149.3 3.6-5c5.6-9.1 8.1-19.7 6.9-30.3l-.9-5.6-42.6-186.5c-2.8-12.3-10.4-23-20.9-29.8l-5.4-3-172-82.8z"]],
    "face-smile-upside-down": [512, 512, [], "e395", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zm120.6-86.1c27.8-35.3 71-57.9 119.4-57.9s91.6 22.7 119.4 57.9c2.7 3.5 2.1 8.5-1.3 11.2s-8.5 2.1-11.2-1.3C337.9 148.3 299.3 128 256 128s-81.9 20.3-106.8 51.8c-2.7 3.5-7.8 4.1-11.2 1.3s-4.1-7.8-1.3-11.2zM192 304a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm160 0a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M16 256a240 240 0 1 1 480 0 240 240 0 1 1 -480 0zm496 0a256 256 0 1 0 -512 0 256 256 0 1 0 512 0zM149.2 179.8C174.1 148.3 212.7 128 256 128s81.9 20.3 106.8 51.8c2.7 3.5 7.8 4.1 11.2 1.3s4.1-7.8 1.3-11.2C347.6 134.7 304.4 112 256 112s-91.6 22.7-119.4 57.9c-2.7 3.5-2.1 8.5 1.3 11.2s8.5 2.1 11.2-1.3zM192 304a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm144-16a16 16 0 1 0 0 32 16 16 0 1 0 0-32z"]],
    "glass-empty": [384, 512, [], "e191", ["", "M32.5 16c-9.3 0-16.7 8-15.9 17.3L51.3 459.2C53 480 70.4 496 91.2 496l202.6 0c20.8 0 38.2-16 39.9-36.8L368.4 33.3c.8-9.3-6.6-17.3-15.9-17.3L32.5 16zM.7 34.6C-.9 16 13.8 0 32.5 0L352.4 0c18.7 0 33.4 16 31.9 34.6l-34.7 426c-2.4 29.1-26.6 51.4-55.8 51.4L91.2 512c-29.2 0-53.4-22.4-55.8-51.4L.7 34.6z"]],
    "ear": [384, 512, [128066], "f5f0", ["M16 192l0 192c0 61.9 50.1 112 112 112l9.3 0c45.8 0 87-27.9 104-70.4l20.1-50.2c6.9-17.4 19.7-30.7 33.3-40.5 44.4-32 73.3-84.1 73.3-143 0-97.2-78.8-176-176-176S16 94.8 16 192zm64 0c0-61.9 50.1-112 112-112s112 50.1 112 112l0 8c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-8c0-53-43-96-96-96s-96 43-96 96l0 32 8 0c30.9 0 56 25.1 56 56s-25.1 56-56 56l-16 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l16 0c22.1 0 40-17.9 40-40s-17.9-40-40-40l-16 0c-4.4 0-8-3.6-8-8l0-40z", "M368 192c0 58.9-28.9 111-73.3 143-13.6 9.8-26.3 23.1-33.3 40.5l-20.1 50.2c-17 42.5-58.2 70.4-104 70.4l-9.3 0C66.1 496 16 445.9 16 384l0-192C16 94.8 94.8 16 192 16S368 94.8 368 192zM276.3 381.4c5.5-13.7 15.8-24.8 27.8-33.4 48.4-34.9 80-91.7 80-156 0-106-86-192-192-192S0 86 0 192L0 384c0 70.7 57.3 128 128 128l9.3 0c52.3 0 99.4-31.9 118.8-80.5l20.1-50.2zM96 192c0-53 43-96 96-96s96 43 96 96l0 8c0 4.4 3.6 8 8 8s8-3.6 8-8l0-8c0-61.9-50.1-112-112-112S80 130.1 80 192l0 40c0 4.4 3.6 8 8 8l16 0c22.1 0 40 17.9 40 40s-17.9 40-40 40l-16 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l16 0c30.9 0 56-25.1 56-56s-25.1-56-56-56l-8 0 0-32z"]],
    "street-view": [512, 512, [], "f21d", ["M176 224l0 48c0 8.8 7.2 16 16 16l1.8 0c8.2 0 15 6.1 15.9 14.2l11.1 99.5c.9 8.1 7.7 14.2 15.9 14.2l38.7 0c8.2 0 15-6.1 15.9-14.2l11.1-99.5c.9-8.1 7.8-14.2 15.9-14.2l1.8 0c8.8 0 16-7.2 16-16l0-48c0-26.5-21.5-48-48-48l-64 0c-26.5 0-48 21.5-48 48zM208 64a48 48 0 1 0 96 0 48 48 0 1 0 -96 0z", "M318.2 288c-8.2 0-15 6.1-15.9 14.2l-11.1 99.5c-.9 8.1-7.8 14.2-15.9 14.2l-38.7 0c-8.2 0-15-6.1-15.9-14.2l-11.1-99.5c-.9-8.1-7.7-14.2-15.9-14.2l-1.8 0c-8.8 0-16-7.2-16-16l0-48c0-26.5 21.5-48 48-48l64 0c26.5 0 48 21.5 48 48l0 48c0 8.8-7.2 16-16 16l-1.8 0zM208 64a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM320 304c17.7 0 32-14.3 32-32l0-48c0-35.3-28.7-64-64-64l-64 0c-35.3 0-64 28.7-64 64l0 48c0 17.7 14.3 32 32 32l1.8 0 11.1 99.5c1.8 16.2 15.5 28.5 31.8 28.5l38.7 0c16.3 0 30-12.3 31.8-28.5l11.1-99.5 1.8 0zM256 128a64 64 0 1 0 0-128 64 64 0 1 0 0 128zM16 425.5c0-9.1 7.5-19.9 26.5-30.8 18.4-10.6 45.3-19.9 78.4-26.9l-3.3-15.7c-33.9 7.1-62.6 16.9-83.1 28.7-19.9 11.5-34.5 26.4-34.5 44.7 0 14.5 9.3 26.9 22.7 37 13.5 10.1 32.6 18.9 55.5 26.2 45.9 14.5 108.7 23.4 177.8 23.4s131.9-8.9 177.8-23.4c22.9-7.2 42-16 55.5-26.2 13.4-10 22.7-22.4 22.7-37 0-18.3-14.6-33.2-34.5-44.7-20.4-11.8-49.1-21.5-83.1-28.7l-3.3 15.7c33.1 6.9 60 16.2 78.4 26.9 18.9 10.9 26.5 21.7 26.5 30.8 0 7.2-4.6 15.4-16.3 24.2-11.6 8.6-28.8 16.8-50.8 23.7-43.9 13.9-105 22.6-172.9 22.6s-129-8.7-172.9-22.6c-22-7-39.2-15.1-50.8-23.7-11.7-8.8-16.3-17-16.3-24.2z"]],
    "briefs": [512, 512, [], "e6d0", ["M16 112l0 32 480 0 0-32c0-17.7-14.3-32-32-32L48 80c-17.7 0-32 14.3-32 32zm0 48l0 80c0 16.9 14.6 33.2 36 39.8 24.8 7.7 47.2 20.6 65.9 37.6l5.2-7C147.1 278.6 160 239.8 160 200l0-40-144 0zM129.4 328.7c17.5 19 30.9 41.9 38.7 67.2 6.6 21.4 22.9 36 39.8 36l96 0c16.9 0 33.2-14.6 39.8-36 7.8-25.3 21.2-48.2 38.7-67.2L376 320c-26-34.6-40-76.7-40-120l0-40-160 0 0 40c0 43.3-14 85.4-40 120l-6.6 8.7zM352 160l0 40c0 39.8 12.9 78.6 36.8 110.4l5.2 7c18.8-16.9 41.2-29.9 65.9-37.6 21.4-6.6 36-22.9 36-39.8l0-80-144 0z", "M48 80c-17.7 0-32 14.3-32 32l0 32 480 0 0-32c0-17.7-14.3-32-32-32L48 80zM16 160l0 80c0 16.9 14.6 33.2 36 39.8 24.8 7.7 47.2 20.6 65.9 37.6l5.2-7C147.1 278.6 160 239.8 160 200l0-40-144 0zM168.2 396c6.6 21.4 22.9 36 39.8 36l96 0c16.9 0 33.2-14.6 39.8-36 7.8-25.3 21.2-48.2 38.7-67.2L376 320c-26-34.6-40-76.7-40-120l0-40-160 0 0 40c0 43.3-14 85.4-40 120l-6.6 8.7c17.5 19 30.9 41.9 38.7 67.2zM394 317.4c18.8-16.9 41.2-29.9 65.9-37.6 21.4-6.6 36-22.9 36-39.8l0-80-144 0 0 40c0 39.8 12.9 78.6 36.8 110.4l5.2 7zM0 112C0 85.5 21.5 64 48 64l416 0c26.5 0 48 21.5 48 48l0 128c0 26.5-22 47.3-47.3 55.1-50.3 15.6-90 55.3-105.6 105.6-7.8 25.3-28.6 47.3-55.1 47.3l-96 0c-26.5 0-47.3-22-55.1-47.3-15.6-50.3-55.3-90-105.6-105.6-25.3-7.8-47.3-28.6-47.3-55.1L0 112z"]],
    "speakers": [448, 512, [], "f8e0", ["M112 32c0-26.5 21.5-48 48-48l224 0c26.5 0 48 21.5 48 48l0 352c0 26.5-21.5 48-48 48l-224 0c-26.5 0-48-21.5-48-48l0-352zm64 256a96 96 0 1 0 192 0 96 96 0 1 0 -192 0zM232 80a40 40 0 1 0 80 0 40 40 0 1 0 -80 0z", "M160-16c-26.5 0-48 21.5-48 48l0 352c0 26.5 21.5 48 48 48l224 0c26.5 0 48-21.5 48-48l0-352c0-26.5-21.5-48-48-48L160-16zM96 32c0-35.3 28.7-64 64-64l224 0c35.3 0 64 28.7 64 64l0 352c0 35.3-28.7 64-64 64l-224 0c-35.3 0-64-28.7-64-64L96 32zM352 288a80 80 0 1 0 -160 0 80 80 0 1 0 160 0zm-176 0a96 96 0 1 1 192 0 96 96 0 1 1 -192 0zm96-184a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm0-64a40 40 0 1 1 0 80 40 40 0 1 1 0-80zM16 72l0 416c0 22.1 17.9 40 40 40l288 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L56 544c-30.9 0-56-25.1-56-56L0 72c0-4.4 3.6-8 8-8s8 3.6 8 8z"]],
    "wave-square": [512, 512, [], "f83e", ["", "M104 80c-4.4 0-8 3.6-8 8l0 160c0 13.3-10.7 24-24 24L8 272c-4.4 0-8-3.6-8-8s3.6-8 8-8l64 0c4.4 0 8-3.6 8-8L80 88c0-13.3 10.7-24 24-24l136 0c13.3 0 24 10.7 24 24l0 336c0 4.4 3.6 8 8 8l136 0c4.4 0 8-3.6 8-8l0-160c0-13.3 10.7-24 24-24l64 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-64 0c-4.4 0-8 3.6-8 8l0 160c0 13.3-10.7 24-24 24l-136 0c-13.3 0-24-10.7-24-24l0-336c0-4.4-3.6-8-8-8L104 80z"]],
    "angle-left": [256, 512, [8249], "f104", ["", "M18.3 261.7c-3.1-3.1-3.1-8.2 0-11.3l176-176c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3L35.3 256 205.7 426.3c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-176-176z"]],
    "turtle": [576, 512, [128034], "f726", ["M16 344c0 13.3 10.7 24 24 24l56 0 0 72c0 13.3 10.7 24 24 24l16 0c13.3 0 24-10.7 24-24l0-72 96 0 0 72c0 13.3 10.7 24 24 24l16 0c13.3 0 24-10.7 24-24l0-72 35.7 0c51.7 0 97.5-33.1 113.8-82.1l2.8-8.5c1.1-3.3 4.1-5.5 7.6-5.5l40 0c22.1 0 40-17.9 40-40l0-16c0-39.8-32.2-72-72-72-30.9 0-56 25.1-56 56l0 56c0 35.3-28.7 64-64 64L40 320c-13.3 0-24 10.7-24 24zm24-72l335.8 0c-4.3-.1-7.8-3.7-7.8-8l0-56c0-88.4-71.6-160-160-160S48 119.6 48 208l0 56c0 4.4-3.6 8-8 8zm472-64a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M208 48C119.6 48 48 119.6 48 208l0 56c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-56c0-97.2 78.8-176 176-176s176 78.8 176 176l0 56c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-56c0-88.4-71.6-160-160-160zM416 200c0-39.8 32.2-72 72-72 48.6 0 88 39.4 88 88l0 16c0 30.9-25.1 56-56 56l-34.2 0-1 3c-18.5 55.5-70.5 93-129 93l-19.7 0 0 56c0 22.1-17.9 40-40 40l-16 0c-22.1 0-40-17.9-40-40l0-56-64 0 0 56c0 22.1-17.9 40-40 40l-16 0c-22.1 0-40-17.9-40-40l0-56-40 0c-22.1 0-40-17.9-40-40s17.9-40 40-40l328 0c26.5 0 48-21.5 48-48l0-56zM240 368l16 0 0 72c0 13.3 10.7 24 24 24l16 0c13.3 0 24-10.7 24-24l0-72 35.7 0c51.7 0 97.5-33.1 113.8-82.1l2.8-8.5c1.1-3.3 4.1-5.5 7.6-5.5l40 0c22.1 0 40-17.9 40-40l0-16c0-39.8-32.2-72-72-72-30.9 0-56 25.1-56 56l0 56c0 35.3-28.7 64-64 64L40 320c-13.3 0-24 10.7-24 24s10.7 24 24 24l56 0 0 72c0 13.3 10.7 24 24 24l16 0c13.3 0 24-10.7 24-24l0-72 80 0zM496 192a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"]],
    "arrow-right-to-line": [512, 512, [8677, "arrow-to-right"], "f340", ["", "M512 72c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 368c0 4.4 3.6 8 8 8s8-3.6 8-8l0-368zM381.7 261.7c3.1-3.1 3.1-8.2 0-11.3l-152-152c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3L356.7 248 8 248c-4.4 0-8 3.6-8 8s3.6 8 8 8l348.7 0-138.3 138.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l152-152z"]],
    "pants-straight": [448, 512, [], "e6d6", ["M17.6 50l2.9 46 82 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-81 0 22.1 354c1.1 16.9 15 30 31.9 30l141 0 0-312c0-4.4 3.6-8 8-8s8 3.6 8 8l0 312 136.8 0c16.9 0 30.9-13.1 31.9-30l22.1-354-81 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l82 0 2.9-46c1.1-18.4-13.5-34-31.9-34L49.5 16C31 16 16.4 31.6 17.6 50zm10 417c1.7 25.4 22.6 45 47.9 45-25.3 0-46.3-19.7-47.9-45z", "M49.5 16C31 16 16.4 31.6 17.6 50l2.9 46 82 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-81 0 22.1 354c1.1 16.9 15 30 31.9 30l141 0 0-312c0-4.4 3.6-8 8-8s8 3.6 8 8l0 312 136.8 0c16.9 0 30.9-13.1 31.9-30l22.1-354-81 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l82 0 2.9-46c1.1-18.4-13.5-34-31.9-34L49.5 16zm175 496l-149 0c-25.3 0-46.3-19.7-47.9-45L1.6 51C-.1 23.4 21.8 0 49.5 0L395.3 0c27.7 0 49.6 23.4 47.9 51l-26 416c-1.6 25.3-22.6 45-47.9 45l-144.8 0z"]],
    "screwdriver": [576, 512, [129691], "f54a", ["M45.4 393.4c-12.5 12.5-12.5 32.8 0 45.3l60.1 60.1c12.5 12.5 32.8 12.5 45.3 0L268.8 380.7c29.1-29.1 29.1-76.3 0-105.4s-76.3-29.1-105.4 0L45.4 393.4zM368.1 97.1l0 78.9 78.9 0c3.7 0 7.3-1.3 10.1-3.6l5.7-7.3 76.7-115.1-45.4-45.4-118.8 79.2c-4.5 3-7.1 8-7.1 13.3z", "M368.1 176l0-78.9c0-5.3 2.7-10.3 7.1-13.3L494.1 4.6 539.5 50 460.3 168.9c-3 4.5-8 7.1-13.3 7.1l-78.9 0zM485.2-8.7L366.4 70.5c-8.9 5.9-14.2 15.9-14.2 26.6l0 83.6-77.9 77.9c-35.6-29.8-88.7-28-122.1 5.4L34.1 382.1c-18.7 18.7-18.7 49.1 0 67.9l60.1 60.1c18.7 18.7 49.1 18.7 67.9 0L280.1 392c33.4-33.4 35.2-86.5 5.4-122.1l77.9-77.9 83.6 0c10.7 0 20.7-5.3 26.6-14.2L552.8 58.9c4.2-6.3 3.4-14.8-2-20.2L505.4-6.7c-5.4-5.4-13.8-6.2-20.2-2zM45.4 438.6c-12.5-12.5-12.5-32.8 0-45.3L163.4 275.3c29.1-29.1 76.3-29.1 105.4 0s29.1 76.3 0 105.4L150.7 498.7c-12.5 12.5-32.8 12.5-45.3 0L45.4 438.6z"]],
    "traffic-light-stop": [320, 512, [], "f63a", ["M16 32l0 352c0 79.5 64.5 144 144 144s144-64.5 144-144l0-352c0-26.5-21.5-48-48-48L64-16C37.5-16 16 5.5 16 32zm200 80a56 56 0 1 1 -112 0 56 56 0 1 1 112 0zm0 144a56 56 0 1 1 -112 0 56 56 0 1 1 112 0zM104 400c0-30.9 25.1-56 56-56s56 25.1 56 56-25.1 56-56 56-56-25.1-56-56z", "M256-16c26.5 0 48 21.5 48 48l0 352c0 79.5-64.5 144-144 144S16 463.5 16 384L16 32C16 5.5 37.5-16 64-16l192 0zM64-32C28.7-32 0-3.3 0 32L0 384c0 88.4 71.6 160 160 160s160-71.6 160-160l0-352c0-35.3-28.7-64-64-64L64-32zm96 392c22.1 0 40 17.9 40 40s-17.9 40-40 40-40-17.9-40-40 17.9-40 40-40zm0-16c-30.9 0-56 25.1-56 56s25.1 56 56 56 56-25.1 56-56-25.1-56-56-56zm40-88a40 40 0 1 1 -80 0 40 40 0 1 1 80 0zm-96 0a56 56 0 1 0 112 0 56 56 0 1 0 -112 0zm56-104a40 40 0 1 1 0-80 40 40 0 1 1 0 80zm0-96a56 56 0 1 0 0 112 56 56 0 1 0 0-112zm0 40a16 16 0 1 0 0 32 16 16 0 1 0 0-32z"]],
    "square-euro": [448, 512, [], "e732", ["M16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96zm88 128c0-4.4 3.6-8 8-8l29.7 0c17.1-51.1 65.3-88 122.2-88l41 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-41 0c-47.9 0-88.8 29.9-105.2 72l73.3 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-78.1 0c-1.8 8-2.7 16.3-2.7 24.8 0 8 .8 15.7 2.4 23.2l78.4 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-73.8 0c15.9 42.9 57.3 73.5 105.7 73.5l41 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-41 0c-57.4 0-106.1-37.6-122.7-89.5L112 296c-4.4 0-8-3.6-8-8s3.6-8 8-8l25.2 0c-1.4-7.5-2.1-15.3-2.1-23.2 0-8.5 .8-16.7 2.4-24.8L112 232c-4.4 0-8-3.6-8-8z", "M64 48C37.5 48 16 69.5 16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM137.5 232L112 232c-4.4 0-8-3.6-8-8s3.6-8 8-8l29.7 0c17.1-51.1 65.3-88 122.2-88l41 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-41 0c-47.9 0-88.8 29.9-105.2 72l73.3 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-78.1 0c-1.8 8-2.7 16.3-2.7 24.8 0 8 .8 15.7 2.4 23.2l78.4 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-73.8 0c15.9 42.9 57.3 73.5 105.7 73.5l41 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-41 0c-57.4 0-106.1-37.6-122.7-89.5L112 296c-4.4 0-8-3.6-8-8s3.6-8 8-8l25.2 0c-1.4-7.5-2.1-15.3-2.1-23.2 0-8.5 .8-16.7 2.4-24.8z"]],
    "tractor": [576, 512, [128668], "f722", ["M16.2 344L30 344c4.4 0 8 3.6 8 8s-3.6 8-8 8l-13.8 0c1.8 33.7 15.3 64.4 36.5 88l9.7-9.7c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3L64 459.3c23.6 21.1 54.3 34.6 88 36.5l0-13.8c0-4.4 3.6-8 8-8s8 3.6 8 8l0 13.8c33.7-1.8 64.4-15.3 88-36.5l-9.7-9.7c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0l9.7 9.7c21.1-23.6 34.6-54.3 36.5-88L290 360c-4.4 0-8-3.6-8-8s3.6-8 8-8l13.8 0c-1.8-33.7-15.3-64.4-36.5-88l-9.7 9.7c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l9.7-9.7c-23.6-21.1-54.3-34.6-88-36.5l0 13.8c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-13.8c-33.7 1.8-64.4 15.3-88 36.5l9.7 9.7c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L52.7 256c-21.1 23.6-34.6 54.3-36.5 88zM240 352a80 80 0 1 1 -160 0 80 80 0 1 1 160 0zM229.8 208c53.4 25.9 90.2 80.7 90.2 144 0 5.4-.3 10.7-.8 16l92.9 0c16.1-19.5 40.6-32 67.9-32 9.6 0 18.8 1.5 27.4 4.3l41.1-34.2C555.8 300 560 291 560 281.5l0-41.5c0-17.7-14.3-32-32-32l-298.2 0zM408 424a72 72 0 1 0 144 0 72 72 0 1 0 -144 0z", "M235.8 48c16.9 0 32.5 8.8 41.2 23.3L349.3 192 160 192c-16.7 0-32.8 2.6-48 7.3L112 64c0-8.8 7.2-16 16-16l107.8 0zM96 64l0 141.3C39.5 230 0 286.4 0 352 0 440.4 71.6 512 160 512 237.4 512 302 457 316.8 384l84.8 0c-6.1 12-9.6 25.6-9.6 40 0 48.6 39.4 88 88 88s88-39.4 88-88c0-32.7-17.8-61.2-44.3-76.4l35-29.2c10.9-9.1 17.3-22.6 17.3-36.9l0-41.5c0-26.5-21.5-48-48-48l-64 0 0-88c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 88-80 0-77.4-128.9C279.1 43.8 258.2 32 235.8 32L128 32c-17.7 0-32 14.3-32 32zM400 368l-80.8 0c.5-5.3 .8-10.6 .8-16 0-63.3-36.8-118.1-90.2-144L528 208c17.7 0 32 14.3 32 32l0 41.5c0 9.5-4.2 18.5-11.5 24.6l-41.1 34.2c-8.6-2.8-17.8-4.3-27.4-4.3-27.3 0-51.7 12.5-67.9 32L400 368zm8 56a72 72 0 1 1 144 0 72 72 0 1 1 -144 0zM290 344c-4.4 0-8 3.6-8 8s3.6 8 8 8l13.8 0c-1.8 33.7-15.3 64.4-36.5 88l-9.7-9.7c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l9.7 9.7c-23.6 21.1-54.3 34.6-88 36.5l0-13.8c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 13.8c-33.7-1.8-64.4-15.3-88-36.5l9.7-9.7c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0L52.7 448c-21.1-23.6-34.6-54.3-36.5-88L30 360c4.4 0 8-3.6 8-8s-3.6-8-8-8l-13.8 0c1.8-33.7 15.3-64.4 36.5-88l9.7 9.7c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3L64 244.7c23.6-21.1 54.3-34.6 88-36.5l0 13.8c0 4.4 3.6 8 8 8s8-3.6 8-8l0-13.8c33.7 1.8 64.4 15.3 88 36.5l-9.7 9.7c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l9.7-9.7c21.1 23.6 34.6 54.3 36.5 88L290 344zM96 352a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zm144 0a80 80 0 1 0 -160 0 80 80 0 1 0 160 0z"]],
    "bridge-circle-xmark": [576, 512, [], "e4cb", ["M16 160l480 0 0 58.9c-20-7.1-41.6-10.9-64-10.9-59 0-111.8 26.6-147 68.5-9.2-2.9-18.9-4.5-29-4.5-53 0-96 43-96 96l0 88c0 4.4-3.6 8-8 8l-64 0c-4.4 0-8-3.6-8-8l0-120.6c0-36.7-22.8-69.5-57.1-82.4L16 250.5 16 160z", "M8 32c-4.4 0-8 3.6-8 8s3.6 8 8 8l48 0 0 96-48 0c-4.4 0-8 3.6-8 8L0 256c0 3.3 2.1 6.3 5.2 7.5L17.3 268C45.4 278.6 64 305.4 64 335.4L64 456c0 13.3 10.7 24 24 24l64 0c13.3 0 24-10.7 24-24l0-88c0-44.2 35.8-80 80-80 6.4 0 12.6 .7 18.5 2.2 3.3-4.7 6.8-9.3 10.5-13.7-9.2-2.9-18.9-4.5-29-4.5-53 0-96 43-96 96l0 88c0 4.4-3.6 8-8 8l-64 0c-4.4 0-8-3.6-8-8l0-120.6c0-36.7-22.8-69.5-57.1-82.4l-6.9-2.6 0-90.5 480 0 0 58.9c5.4 1.9 10.8 4.1 16 6.5l0-73.4c0-4.4-3.6-8-8-8l-48 0 0-96 48 0c4.4 0 8-3.6 8-8s-3.6-8-8-8L8 32zM440 48l0 96-112 0 0-96 112 0zM312 48l0 96-112 0 0-96 112 0zM184 48l0 96-112 0 0-96 112 0zM304 400a128 128 0 1 1 256 0 128 128 0 1 1 -256 0zm272 0a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-90.3-42.3c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0l-42.3 42.3-42.3-42.3c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l42.3 42.3-42.3 42.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l42.3-42.3 42.3 42.3c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-42.3-42.3 42.3-42.3z"]],
    "vials": [512, 512, [], "f493", ["M48 208l0 208c0 44.2 35.8 80 80 80s80-35.8 80-80l0-208-160 0zm256 0l0 208c0 44.2 35.8 80 80 80s80-35.8 80-80l0-208-160 0z", "M8 0C3.6 0 0 3.6 0 8s3.6 8 8 8l24 0 0 400c0 53 43 96 96 96s96-43 96-96l0-400 64 0 0 400c0 53 43 96 96 96s96-43 96-96l0-400 24 0c4.4 0 8-3.6 8-8s-3.6-8-8-8L8 0zM304 16l160 0 0 176-160 0 0-176zm-96 0l0 176-160 0 0-176 160 0zM48 416l0-208 160 0 0 208c0 44.2-35.8 80-80 80s-80-35.8-80-80zm256 0l0-208 160 0 0 208c0 44.2-35.8 80-80 80s-80-35.8-80-80z"]],
    "starfighter-twin-ion-engine-advanced": [576, 512, ["starfighter-alt-advanced"], "e28e", ["M16 230.4l0 51.2 120.8 26.8C131.1 292 128 274.4 128 256s3.1-36 8.8-52.4L16 230.4zM144 256a144 144 0 1 0 288 0 144 144 0 1 0 -288 0zm224 0a80 80 0 1 1 -160 0 80 80 0 1 1 160 0zm71.2-52.4c5.7 16.4 8.8 34.1 8.8 52.4s-3.1 36-8.8 52.4l120.8-26.8 0-51.2-120.8-26.8z", "M450 13.3c-2.9-3.3-2.6-8.4 .8-11.3s8.4-2.6 11.3 .8l104.1 119c6.4 7.3 9.9 16.7 9.9 26.3l0 201c0 8.9-3 17.5-8.4 24.6L462.3 508.9c-2.7 3.5-7.7 4.1-11.2 1.4s-4.1-7.7-1.4-11.2L554.9 363.8c3.3-4.2 5.1-9.4 5.1-14.7l0-51-128.3 28.5C405.6 379.5 351.1 416 288 416s-117.6-36.5-143.7-89.5L16 298 16 356.5c0 5.6 1.9 11 5.5 15.3L126.2 498.9c2.8 3.4 2.3 8.5-1.1 11.3s-8.5 2.3-11.3-1.1L9.1 381.9C3.2 374.8 0 365.8 0 356.5l0-201c0-9.3 3.2-18.3 9.1-25.4L113.8 2.9c2.8-3.4 7.9-3.9 11.3-1.1s3.9 7.9 1.1 11.3L21.5 140.2c-3.5 4.3-5.5 9.7-5.5 15.3l0 58.5 128.3-28.5C170.4 132.5 224.9 96 288 96s117.6 36.5 143.7 89.5L560 214 560 148c0-5.8-2.1-11.4-5.9-15.8L450 13.3zM560 230.4L439.2 203.6c5.7 16.4 8.8 34.1 8.8 52.4s-3.1 36-8.8 52.4l120.8-26.8 0-51.2zm-423.2 78C131.1 292 128 274.4 128 256s3.1-36 8.8-52.4L16 230.4 16 281.6 136.8 308.4zM288 400a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm0-224a80 80 0 1 1 0 160 80 80 0 1 1 0-160zm64 80a64 64 0 1 0 -128 0 64 64 0 1 0 128 0z"]],
    "stethoscope": [512, 512, [129658], "f0f1", ["M400 192a48 48 0 1 0 96 0 48 48 0 1 0 -96 0z", "M0 32C0 14.3 14.3 0 32 0L88 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L32 16c-8.8 0-16 7.2-16 16l0 144c0 79.5 64.5 144 144 144s144-64.5 144-144l0-144c0-8.8-7.2-16-16-16l-56 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l56 0c17.7 0 32 14.3 32 32l0 144c0 85.7-67.4 155.6-152 159.8l0 56.2c0 75.1 60.9 136 136 136s136-60.9 136-136l0-136.5c-31.6-3.9-56-30.9-56-63.5 0-35.3 28.7-64 64-64s64 28.7 64 64c0 32.6-24.4 59.6-56 63.5L456 392c0 83.9-68.1 152-152 152S152 475.9 152 392l0-56.2C67.4 331.6 0 261.7 0 176L0 32zM448 240a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"]],
    "podcast": [448, 512, [], "f2ce", ["M173.4 349.5c0 40.4 13 104.9 20.9 134 1.2 4.6 4 7.5 8.7 9.4 5.1 2.1 12.2 3.1 21 3.1s15.9-.9 21-3c4.7-2 7.5-4.8 8.7-9.4 3.8-14.2 9.1-39.8 13.4-65.9 4.3-26.2 7.5-52.4 7.5-68.1 0-6.4-1.6-11.1-4.1-14.6-2.5-3.6-6.2-6.5-10.9-8.7-9.8-4.6-22.9-6.1-35.6-6.1s-25.8 1.5-35.6 6.1c-4.8 2.3-8.4 5.2-10.9 8.7-2.4 3.5-4.1 8.2-4.1 14.6zM192 224a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M432 224c0 75.2-39.9 141-99.6 177.6-.9 6.7-1.8 13.4-2.8 20.1 70.5-37.7 118.5-112.1 118.5-197.6 0-123.7-100.3-224-224-224S0 100.3 0 224c0 85.5 48 159.9 118.4 197.6-1-6.6-2-13.4-2.8-20.1-59.7-36.5-99.6-102.4-99.6-177.6 0-114.9 93.1-208 208-208s208 93.1 208 208zm-96 0c0 26.4-9.1 50.6-24.4 69.8 3.7 3.7 7.2 8 10.3 12.7 18.8-22.3 30.1-51 30.1-82.4 0-70.7-57.3-128-128-128S96 153.3 96 224c0 31.4 11.3 60.2 30.1 82.4 3.1-4.7 6.6-8.9 10.3-12.7-15.3-19.1-24.4-43.4-24.4-69.8 0-61.9 50.1-112 112-112s112 50.1 112 112zM224 192a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm0 80a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm-46.5 62.9c2.5-3.6 6.2-6.5 10.9-8.7 9.8-4.6 23-6.1 35.6-6.1s25.8 1.5 35.6 6.1c4.8 2.3 8.4 5.2 10.9 8.7 2.4 3.5 4.1 8.2 4.1 14.6 0 15.7-3.2 41.9-7.5 68.1-4.3 26.1-9.5 51.7-13.4 65.9-1.2 4.6-4 7.5-8.7 9.4-5.1 2.1-12.2 3-21 3s-15.9-.9-21-3.1c-4.7-2-7.5-4.8-8.7-9.4l0 0c-7.9-29.1-20.9-93.6-20.9-134 0-6.4 1.6-11.1 4.1-14.6zm4-23.2c-6.6 3.2-12.7 7.7-17.2 14.1-4.5 6.5-6.9 14.4-6.9 23.7 0 42.4 13.4 108.6 21.5 138.2 2.7 10.1 9.5 16.5 18 20 8 3.4 17.7 4.3 27.1 4.3s19.1-.9 27.1-4.3c8.4-3.5 15.2-9.9 18-20l0 0c4-15 9.4-41.1 13.7-67.5 4.3-26.3 7.7-53.6 7.7-70.7 0-9.4-2.4-17.3-6.9-23.7-4.4-6.4-10.6-10.9-17.2-14.1-13-6.2-29.1-7.7-42.4-7.7s-29.4 1.5-42.4 7.7z"]],
    "arrow-up-right-dots": [512, 512, [], "e4b7", ["", "M88 32c-4.4 0-8 3.6-8 8s3.6 8 8 8L196.7 48 18.3 226.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L208 59.3 208 168c0 4.4 3.6 8 8 8s8-3.6 8-8l0-128c0-4.4-3.6-8-8-8L88 32zM464 70.1a22.1 22.1 0 1 1 -44.2 0 22.1 22.1 0 1 1 44.2 0zM441.9 32a38.1 38.1 0 1 0 0 76.2 38.1 38.1 0 1 0 0-76.2zM339.8 194.2a22.1 22.1 0 1 1 -44.2 0 22.1 22.1 0 1 1 44.2 0zm-22.1-38.1a38.1 38.1 0 1 0 0 76.2 38.1 38.1 0 1 0 0-76.2zm124.2 16a22.1 22.1 0 1 1 0 44.2 22.1 22.1 0 1 1 0-44.2zm-38.1 22.1a38.1 38.1 0 1 0 76.2 0 38.1 38.1 0 1 0 -76.2 0zM216.3 317.8a22.1 22.1 0 1 1 -44.2 0 22.1 22.1 0 1 1 44.2 0zm-22.1-38.1a38.1 38.1 0 1 0 0 76.2 38.1 38.1 0 1 0 0-76.2zm123.5 16a22.1 22.1 0 1 1 0 44.2 22.1 22.1 0 1 1 0-44.2zm-38.1 22.1a38.1 38.1 0 1 0 76.2 0 38.1 38.1 0 1 0 -76.2 0zm184.3 0a22.1 22.1 0 1 1 -44.2 0 22.1 22.1 0 1 1 44.2 0zm-22.1-38.1a38.1 38.1 0 1 0 0 76.2 38.1 38.1 0 1 0 0-76.2zM70.1 419.8a22.1 22.1 0 1 1 0 44.2 22.1 22.1 0 1 1 0-44.2zM32 441.9a38.1 38.1 0 1 0 76.2 0 38.1 38.1 0 1 0 -76.2 0zm184.3 0a22.1 22.1 0 1 1 -44.2 0 22.1 22.1 0 1 1 44.2 0zm-22.1-38.1a38.1 38.1 0 1 0 0 76.2 38.1 38.1 0 1 0 0-76.2zm123.5 16a22.1 22.1 0 1 1 0 44.2 22.1 22.1 0 1 1 0-44.2zm-38.1 22.1a38.1 38.1 0 1 0 76.2 0 38.1 38.1 0 1 0 -76.2 0zm184.3 0a22.1 22.1 0 1 1 -44.2 0 22.1 22.1 0 1 1 44.2 0zm-22.1-38.1a38.1 38.1 0 1 0 0 76.2 38.1 38.1 0 1 0 0-76.2z"]],
    "chess-queen": [512, 512, [9819], "f445", ["M6.7 151.3c-.2 2.3 0 4.8 .8 7.2 .3 1 .7 1.9 1.2 2.8l34 62-36-72zm17.6-.5l116.6 233.2 230.1 0 116.6-233.2-43.4 16.7c-26.2 10.1-55.8 3.9-75.8-15.3l-3.9-4-28.5-32-21.2 24.8c-14.7 17.2-36.3 27.1-58.9 27.1-19.8 0-38.8-7.6-53.1-21l-5.8-6.1-21.2-24.8-28.4 32c-19.9 22.4-51.7 30.1-79.7 19.4L24.3 150.8zM80.2 477.9c.7 5.8 3 11 6.5 15.3 2.5 1.8 5.6 2.8 8.9 2.8l320.6 0c3.3 0 6.4-1 8.9-2.8 3.5-4.3 5.9-9.6 6.6-15.4-.4-2.7-1.5-5.2-3.2-7.3l-56.4-70.5-232.3 0-56.4 70.5c-1.7 2.1-2.8 4.7-3.2 7.4zm52.4-337.3c1-1 2-2 2.9-3l26.4-29.6c-5 2.5-9.4 6.1-12.8 10.7l-16.5 22zm55-35.4l21.7 25.3 4.6 4.8c11.4 10.6 26.4 16.7 42.1 16.7 18 0 35.1-7.9 46.8-21.5l21.7-25.3c-5.4 1.4-10.5 4.1-14.8 7.8l-32.6 28.5c-12.1 10.6-30.1 10.6-42.2 0L202.3 113c-4.3-3.7-9.3-6.4-14.8-7.8zM221.7 32a34.3 34.3 0 1 0 68.6 0 34.3 34.3 0 1 0 -68.6 0zm128.5 75.9l26.4 29.6 3 3.1c-5.6-7.4-11.1-14.7-16.6-22.1-3.4-4.6-7.8-8.2-12.8-10.7zm77.9 47.6c3.5-.6 7-1.6 10.5-2.9l42.8-16.5c-.9-.1-1.8-.1-2.7-.1l-1.1 0c-3.7 0-7.4 .8-10.7 2.3l-38.8 17.2zm16 118.2l56.6-99.9c2.2-3.8 3.3-8.1 3.3-12.5 0-2.1-.2-4.1-.7-6L444.1 273.7z", "M335.9 96c2.3 0 4.5 1 6 2.7l34.6 38.9 3 3.1c15.6 15 38.6 19.8 59 11.9l62.6-24.1c3.1-1.2 6.6-.4 8.8 2.1 1.7 1.8 2.4 4.3 2 6.7l-.7 2.3-125.7 251.4 55.6 69.5c4.5 5.6 6.9 12.6 6.9 19.8 0 17.5-14.2 31.7-31.7 31.7L95.7 512c-17.5 0-31.7-14.2-31.7-31.7 0-7.2 2.4-14.2 6.9-19.8L126.5 391 .9 139.6c-1.5-2.9-1-6.5 1.2-8.9 2.2-2.4 5.7-3.3 8.8-2.1l62.6 24.1c21.8 8.4 46.5 2.4 62-15.1l34.6-38.9 1.2-1.2c1.4-1 3.1-1.5 4.8-1.5 2.3 0 4.5 1 6 2.8l27.2 31.7 4.6 4.8c11.4 10.6 26.4 16.7 42.1 16.7 18 0 35.1-7.9 46.8-21.5l27.2-31.7 1.3-1.2c1.4-1 3-1.6 4.7-1.6zM139.9 400L83.4 470.5c-2.2 2.8-3.4 6.2-3.4 9.8 0 8.7 7 15.7 15.7 15.7l320.6 0c8.7 0 15.7-7 15.7-15.7 0-3.6-1.2-7-3.4-9.8l-56.4-70.5-232.3 0zM314.9 140.9c-14.7 17.2-36.3 27.1-58.9 27.1-19.8 0-38.8-7.6-53.1-21l-5.8-6.1-21.2-24.8-28.4 32c-19.9 22.4-51.7 30.1-79.7 19.4l-43.4-16.7 116.6 233.2 230.1 0 116.6-233.2-43.4 16.7c-26.2 10.1-55.8 3.9-75.8-15.3l-3.9-4-28.5-32-21.2 24.8zM256 80a48 48 0 1 1 0-96 48 48 0 1 1 0 96zm0-82.3a34.3 34.3 0 1 0 0 68.6 34.3 34.3 0 1 0 0-68.6z"]],
    "anchor-circle-exclamation": [640, 512, [], "e4ab", ["M215.4 80.6c0 37.4 28.3 68.2 64.6 72.2l0-9.2c-35.7-4-63.6-34.1-64-72.4-.4 3.2-.6 6.3-.6 9.5zM232 72a56 56 0 1 0 112 0 56 56 0 1 0 -112 0zm64 71.6l0 9.2c36.3-4 64.6-34.8 64.6-72.2 0-3.2-.2-6.3-.6-9.4-.4 38.3-28.3 68.4-64 72.3z", "M288 16a56 56 0 1 0 0 112 56 56 0 1 0 0-112zM216 72c0-39.8 32.2-72 72-72s72 32.2 72 72c0 37.1-28 67.6-64 71.6l0 336.3c8.2-.4 16.2-1.4 24-2.9 2.2 5.1 4.6 10 7.3 14.8-12.7 2.8-25.8 4.2-39.3 4.2-101.6 0-184-82.4-184-184l0-54.4-50.7 44.4c-3.3 2.9-8.4 2.6-11.3-.8s-2.6-8.4 .8-11.3l64-56c3-2.6 7.5-2.6 10.5 0l64 56c3.3 2.9 3.7 8 .8 11.3s-8 3.7-11.3 .8L120 257.6 120 312c0 90.1 70.9 163.6 160 167.8l0-336.3c-36-4-64-34.5-64-71.6zM624 400a128 128 0 1 0 -256 0 128 128 0 1 0 256 0zm-272 0a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm144 52a12 12 0 1 1 0 24 12 12 0 1 1 0-24zm0-140c4.4 0 8 3.6 8 8l0 96c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-96c0-4.4 3.6-8 8-8z"]],
    "ellipsis-vertical": [64, 512, ["ellipsis-v"], "f142", ["", "M32 448c8.8 0 16 7.2 16 16s-7.2 16-16 16-16-7.2-16-16 7.2-16 16-16zm0-208c8.8 0 16 7.2 16 16s-7.2 16-16 16-16-7.2-16-16 7.2-16 16-16zM16 48a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"]],
    "acorn": [448, 512, [], "f6ae", ["M16 160l0 16c0 8.8 7.2 16 16 16l384 0c8.8 0 16-7.2 16-16l0-16c0-44.2-35.8-80-80-80L96 80c-44.2 0-80 35.8-80 80zm48 48l0 16c0 75 29.1 190.3 155.5 237.4l2.2 .6c2.3 .4 4.6 .2 6.8-.6l11.6-4.6C356.7 407.2 384 296.6 384 224l0-16-320 0z", "M250.3 2.3c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3L252.3 23c-11.1 11.1-18 25.6-19.8 41L352 64c53 0 96 43 96 96l0 16c0 17.7-14.3 32-32 32l-16 0 0 16c0 78.1-30.5 201.9-165.9 252.4l-5 1.4c-3.4 .6-6.9 .6-10.3 0l-5-1.4C78.5 425.9 48 302.1 48 224l0-16-16 0-3.3-.2C12.6 206.2 0 192.6 0 176l0-16c0-53 43-96 96-96l120.4 0c1.9-19.7 10.5-38.2 24.6-52.3l9.4-9.4zM64 224c0 75 29.1 190.3 155.5 237.4l2.2 .6c2.3 .4 4.6 .2 6.8-.6l11.6-4.6C356.7 407.2 384 296.6 384 224l0-16-320 0 0 16zM96 80c-44.2 0-80 35.8-80 80l0 16c0 8.8 7.2 16 16 16l384 0c8.8 0 16-7.2 16-16l0-16c0-44.2-35.8-80-80-80L96 80z"]],
    "ban-parking": [512, 512, ["parking-circle-slash"], "f616", ["M16 256c0 132.5 107.5 240 240 240 63.4 0 121.1-24.6 164-64.7L292.6 303.9c-1.5 .1-3 .1-4.6 .1l-96 0 0 72c0 4.4-3.6 8-8 8s-8-3.6-8-8L176 187.3 80.7 92C40.6 134.9 16 192.6 16 256zM92 80.7l84 84 0-20.7c0-8.8 7.2-16 16-16l96 0c48.6 0 88 39.4 88 88 0 40.3-27.1 74.2-64 84.7L431.3 420c40.2-42.9 64.7-100.6 64.7-164 0-132.5-107.5-240-240-240-63.4 0-121.1 24.6-164 64.7zM192 144l0 36.7 106.5 106.5c34.8-5.1 61.5-35.1 61.5-71.2 0-39.8-32.2-72-72-72l-96 0zm0 59.3l0 84.7 84.7 0-84.7-84.7z", "M431.3 420L312 300.7c36.9-10.4 64-44.4 64-84.7 0-48.6-39.4-88-88-88l-96 0c-8.8 0-16 7.2-16 16l0 20.7-84-84c42.9-40.2 100.6-64.7 164-64.7 132.5 0 240 107.5 240 240 0 63.4-24.6 121.1-64.7 164zM420 431.3C377.1 471.4 319.4 496 256 496 123.5 496 16 388.5 16 256 16 192.6 40.6 134.9 80.7 92L176 187.3 176 376c0 4.4 3.6 8 8 8s8-3.6 8-8l0-72 96 0c1.5 0 3.1 0 4.6-.1L420 431.3zm-121.4-144l-106.5-106.5 0-36.7 96 0c39.8 0 72 32.2 72 72 0 36.2-26.7 66.1-61.5 71.2zM192 203.3l84.7 84.7-84.7 0 0-84.7zM256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512z"]],
    "square-dong": [448, 512, [], "e70f", ["M16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96zm96 312c0-4.4 3.6-8 8-8l208 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-208 0c-4.4 0-8-3.6-8-8zm16-136c0-44.2 35.8-80 80-80 26.2 0 49.4 12.6 64 32l0-80-72 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l72 0 0-24c0-4.4 3.6-8 8-8s8 3.6 8 8l0 24 24 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-24 0 0 200c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-24c-14.6 19.4-37.8 32-64 32-44.2 0-80-35.8-80-80zm16 0a64 64 0 1 0 128 0 64 64 0 1 0 -128 0z", "M64 48C37.5 48 16 69.5 16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm272 8c0-4.4 3.6-8 8-8s8 3.6 8 8l0 24 24 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-24 0 0 200c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-24c-14.6 19.4-37.8 32-64 32-44.2 0-80-35.8-80-80s35.8-80 80-80c26.2 0 49.4 12.6 64 32l0-80-72 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l72 0 0-24zM208 208a64 64 0 1 0 0 128 64 64 0 1 0 0-128zM112 408c0-4.4 3.6-8 8-8l208 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-208 0c-4.4 0-8-3.6-8-8z"]],
    "list-dropdown": [448, 512, [], "e1cf", ["M16 192l0 224c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-224-416 0zm80 88c0-4.4 3.6-8 8-8l240 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-240 0c-4.4 0-8-3.6-8-8zm0 96c0-4.4 3.6-8 8-8l240 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-240 0c-4.4 0-8-3.6-8-8z", "M64 48C37.5 48 16 69.5 16 96l0 80 416 0 0-80c0-26.5-21.5-48-48-48L64 48zM0 184L0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 184zm432 8l-416 0 0 224c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-224zM96 280c0-4.4 3.6-8 8-8l240 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-240 0c-4.4 0-8-3.6-8-8zm0 96c0-4.4 3.6-8 8-8l240 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-240 0c-4.4 0-8-3.6-8-8zM309.7 90.3l26.3 26.3 26.3-26.3c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3l-32 32c-3.1 3.1-8.2 3.1-11.3 0l-32-32c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0z"]],
    "camera-circle-ellipsis": [640, 512, [], "e766", ["M80 160c0-26.5 21.5-48 48-48l66.7 0c2.8 0 5.5-1.5 6.9-4l25.8-44.2C233.1 54 243.6 48 255 48l130 0c11.4 0 21.9 6 27.6 15.9L438.4 108c1.4 2.5 4.1 4 6.9 4l66.7 0c26.5 0 48 21.5 48 48l0 58.9c-20-7.1-41.6-10.9-64-10.9-29.5 0-57.4 6.6-82.4 18.5-20-30.4-54.5-50.5-93.6-50.5-61.9 0-112 50.1-112 112 0 56.4 41.7 103.1 96 110.9 0 .4 0 .8 0 1.1 0 22.4 3.8 44 10.9 64L128 464c-26.5 0-48-21.5-48-48l0-256z", "M255 32c-17.1 0-32.9 9.1-41.5 23.8L190.1 96 128 96c-35.3 0-64 28.7-64 64l0 256c0 35.3 28.7 64 64 64l193.4 0c-2.4-5.2-4.6-10.6-6.5-16L128 464c-26.5 0-48-21.5-48-48l0-256c0-26.5 21.5-48 48-48l66.7 0c2.8 0 5.5-1.5 6.9-4l25.8-44.2C233.1 54 243.6 48 255 48l130 0c11.4 0 21.9 6 27.6 15.9L438.4 108c1.4 2.5 4.1 4 6.9 4l66.7 0c26.5 0 48 21.5 48 48l0 58.9c5.4 1.9 10.8 4.1 16 6.5l0-65.4c0-35.3-28.7-64-64-64l-62.1 0-23.4-40.2C417.9 41.1 402.1 32 385 32L255 32zm65 144c-61.9 0-112 50.1-112 112 0 56.4 41.7 103.1 96 110.9 0-5.4 .3-10.8 .8-16.1-45.8-7.3-80.8-47-80.8-94.8 0-53 43-96 96-96 33 0 62.1 16.7 79.4 42 4.6-2.7 9.4-5.2 14.2-7.5-20-30.4-54.5-50.5-93.6-50.5zM496 528a128 128 0 1 1 0-256 128 128 0 1 1 0 256zm0-272a144 144 0 1 0 0 288 144 144 0 1 0 0-288zm16 144a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm-80-16a16 16 0 1 0 0 32 16 16 0 1 0 0-32zm144 16a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"]],
    "family-dress": [512, 512, [], "e301", ["M25.2 347.3l38-123.4c8.8-28.5 35-47.9 64.8-47.9 8.4 0 16.5 1.5 24.1 4.4 0 1.2-.1 2.4-.1 3.6 0 21.3 6.4 41.2 17.5 57.7-25.5 23.4-41.5 57-41.5 94.3l0 32c0 28.5 12.4 54 32 71.5 0 55.7 0 73.5 0 52.2-4.7 2.7-10.2 4.3-16 4.3l-32 0c-17.7 0-32-14.3-32-32l0-88c0-4.4-3.6-8-8-8l-31.5 0c-10.8 0-18.5-10.4-15.3-20.7zM176 64a48 48 0 1 1 -96 0 48 48 0 1 1 96 0zm16 272c0-35.3 28.7-64 64-64s64 28.7 64 64l0 32c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-32zM296 184a40 40 0 1 1 -80 0 40 40 0 1 1 80 0zM432 64a48 48 0 1 1 -96 0 48 48 0 1 1 96 0zM342.6 241.7c11-16.5 17.5-36.3 17.5-57.7 0-1.2 0-2.4-.1-3.6 7.5-2.9 15.7-4.4 24.1-4.4 29.8 0 56.1 19.4 64.8 47.9l38 123.4c3.2 10.3-4.5 20.7-15.3 20.7L440 368c-4.4 0-8 3.6-8 8l0 88c0 17.7-14.3 32-32 32l-32 0c-5.8 0-11.3-1.6-16-4.3l0-52.2c19.6-17.6 32-43.1 32-71.5l0-32c0-37.3-16-70.9-41.5-94.3z", "M176 64a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM64 64A64 64 0 1 1 192 64 64 64 0 1 1 64 64zm-.8 159.9l-38 123.4C22.1 357.6 29.8 368 40.5 368L72 368c4.4 0 8 3.6 8 8l0 88c0 17.7 14.3 32 32 32l32 0c5.8 0 11.3-1.6 16-4.3l0 17.5c-5 1.8-10.4 2.7-16 2.7l-32 0c-26.5 0-48-21.5-48-48l0-80-23.5 0C19 384 3.6 363.2 9.9 342.6l38-123.4c10.8-35.2 43.3-59.2 80.1-59.2 9 0 17.7 1.4 25.9 4.1-1 5.3-1.7 10.8-1.8 16.3-7.5-2.9-15.7-4.4-24.1-4.4-29.8 0-56.1 19.4-64.8 47.9zM368 512c-5.6 0-11-1-16-2.7l0-17.5c4.7 2.7 10.2 4.3 16 4.3l32 0c17.7 0 32-14.3 32-32l0-88c0-4.4 3.6-8 8-8l31.5 0c10.8 0 18.5-10.4 15.3-20.7l-38-123.4c-8.8-28.5-35-47.9-64.8-47.9-8.4 0-16.5 1.5-24.1 4.4-.2-5.6-.8-11-1.8-16.3 8.2-2.7 16.9-4.1 25.9-4.1 36.8 0 69.3 24 80.1 59.2l38 123.4c6.3 20.6-9.1 41.4-30.6 41.4l-23.5 0 0 80c0 26.5-21.5 48-48 48l-32 0zM432 64a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM320 64a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zM296 184a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zm-96 0a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zM320 336c0-35.3-28.7-64-64-64s-64 28.7-64 64l0 32c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-32zm-144 0c0-44.2 35.8-80 80-80s80 35.8 80 80l0 32c0 20.9-13.4 38.7-32 45.3l0 90.7c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-88-64 0 0 88c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-90.7c-18.6-6.6-32-24.4-32-45.3l0-32z"]],
    "podium": [384, 512, [], "f680", ["M34.8 176l24 276.2C61 477 81.8 496 106.7 496l170.6 0c24.9 0 45.7-19 47.8-43.8l24-276.2-314.3 0zM160 40c0 13.3 10.7 24 24 24l80 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0c-13.3 0-24 10.7-24 24z", "M184 16c-13.3 0-24 10.7-24 24s10.7 24 24 24l80 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0zM144.8 32C148.5 13.7 164.6 0 184 0l80 0c22.1 0 40 17.9 40 40s-17.9 40-40 40l-80 0c-19.4 0-35.5-13.7-39.2-32L136 48c-30.9 0-56 25.1-56 56l0 56 296 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-10.8 0-24.1 277.5c-2.9 33.1-30.6 58.5-63.8 58.5l-170.6 0c-33.2 0-60.9-25.4-63.8-58.5L18.8 176 8 176c-4.4 0-8-3.6-8-8s3.6-8 8-8l56 0 0-56c0-39.8 32.2-72 72-72l8.8 0zM349.2 176l-314.3 0 24 276.2C61 477 81.8 496 106.7 496l170.6 0c24.9 0 45.7-19 47.8-43.8l24-276.2z"]],
    "robot-astromech": [512, 512, [], "e2d2", ["M128 144c0-70.7 57.3-128 128-128S384 73.3 384 144l0 32-256 0 0-32zm56-48a40 40 0 1 0 80 0 40 40 0 1 0 -80 0zm104 16a16 16 0 1 0 32 0 16 16 0 1 0 -32 0z", "M256 0C176.5 0 112 64.5 112 144l0 32-24 0c-30.9 0-56 25.1-56 56l0 190.1-29.8 59.6C.8 484.6 0 487.8 0 491.1 0 502.6 9.4 512 20.9 512l83.1 0c13.3 0 24-10.7 24-24l0-99 50 56.3c1.5 1.7 3.7 2.7 6 2.7l144 0c2.3 0 4.5-1 6-2.7l50-56.3 0 99c0 13.3 10.7 24 24 24l83.1 0c11.6 0 20.9-9.4 20.9-20.9 0-3.3-.8-6.5-2.2-9.4L480 422.1 480 232c0-30.9-25.1-56-56-56l-24 0 0-32C400 64.5 335.5 0 256 0zM400 192l24 0c22.1 0 40 17.9 40 40l0 192c0 1.2 .3 2.5 .8 3.6l30.6 61.3c.3 .7 .5 1.4 .5 2.2 0 2.7-2.2 4.9-4.9 4.9L408 496c-4.4 0-8-3.6-8-8l0-296zm-16 0l0 173-59.6 67-136.8 0-59.6-67 0-173 256 0zm-272 0l0 296c0 4.4-3.6 8-8 8l-83.1 0c-2.7 0-4.9-2.2-4.9-4.9 0-.8 .2-1.5 .5-2.2l30.6-61.3c.6-1.1 .8-2.3 .8-3.6l0-192c0-22.1 17.9-40 40-40l24 0zm16-48c0-70.7 57.3-128 128-128S384 73.3 384 144l0 32-256 0 0-32zm72-48a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm64 0a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zm40 32a16 16 0 1 0 0-32 16 16 0 1 0 0 32zM192 248c0 4.4 3.6 8 8 8l112 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-112 0c-4.4 0-8 3.6-8 8zm0 64c0 4.4 3.6 8 8 8l112 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-112 0c-4.4 0-8 3.6-8 8z"]],
    "heart-circle-exclamation": [576, 512, [], "e4fe", ["M16 165.1C16 100.4 68.4 48 133.1 48 170.7 48 206 66 228 96.5l21.5 29.7c1.5 2.1 3.9 3.3 6.5 3.3s5-1.2 6.5-3.3L284 96.5c22-30.5 57.3-48.5 94.9-48.5 64.7 0 117.1 52.4 117.1 117.1 0 17.4-3.1 34.5-8.4 51-17.6-5.3-36.2-8.2-55.6-8.2-106 0-192 86-192 192 0 22.4 3.8 43.8 10.8 63.8-10.5-.9-20.2-4.5-28.2-10.6-35.8-27.4-88-73-131.2-125.4-38.6-46.9-75.4-102.6-75.4-162.7z", "M378.9 48C341.3 48 306 66 284 96.5l-21.5 29.7c-1.5 2.1-3.9 3.3-6.5 3.3s-5-1.2-6.5-3.3L228 96.5c-22-30.5-57.3-48.5-94.9-48.5-64.7 0-117.1 52.4-117.1 117.1 0 60.1 36.9 115.8 75.4 162.7 43.1 52.4 95.4 98 131.2 125.4 8 6.1 17.8 9.7 28.2 10.6 1.9 5.5 4.1 10.9 6.6 16.2-.5 0-.9 0-1.4 0-15.5 0-30.8-4.6-43.1-14.1-36.5-27.9-89.7-74.4-133.8-127.9-38.7-47-79.1-106.6-79.1-172.8 0-73.5 59.6-133.1 133.1-133.1 42.7 0 82.8 20.5 107.9 55.1l15 20.7 15-20.7c25-34.6 65.2-55.1 107.9-55.1 73.5 0 133.1 59.6 133.1 133.1 0 19.4-3.5 38.2-9.3 56.3-4.9-2-10-3.7-15.1-5.3 5.3-16.6 8.4-33.6 8.4-51 0-64.7-52.4-117.1-117.1-117.1zM560 400a128 128 0 1 0 -256 0 128 128 0 1 0 256 0zm-272 0a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm144 52a12 12 0 1 1 0 24 12 12 0 1 1 0-24zm0-140c4.4 0 8 3.6 8 8l0 96c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-96c0-4.4 3.6-8 8-8z"]],
    "building-circle-exclamation": [576, 512, [], "e4d3", ["M48 64c0-26.5 21.5-48 48-48l256 0c26.5 0 48 21.5 48 48l0 146.7c-29.5 4.9-56.7 16.6-80 33.4l0-4c0-13.3-10.7-24-24-24l-24 0c-13.3 0-24 10.7-24 24l0 24c0 13.3 10.7 24 24 24l4 0c-16.8 23.3-28.5 50.6-33.4 80.1-.9-.1-1.7-.1-2.6-.1l-32 0c-17.7 0-32 14.3-32 32l0 96-80 0c-26.5 0-48-21.5-48-48L48 64zm80 56l0 24c0 13.3 10.7 24 24 24l24 0c13.3 0 24-10.7 24-24l0-24c0-13.3-10.7-24-24-24l-24 0c-13.3 0-24 10.7-24 24zm0 120l0 24c0 13.3 10.7 24 24 24l24 0c13.3 0 24-10.7 24-24l0-24c0-13.3-10.7-24-24-24l-24 0c-13.3 0-24 10.7-24 24zM248 120l0 24c0 13.3 10.7 24 24 24l24 0c13.3 0 24-10.7 24-24l0-24c0-13.3-10.7-24-24-24l-24 0c-13.3 0-24 10.7-24 24z", "M352 16L96 16C69.5 16 48 37.5 48 64l0 384c0 26.5 21.5 48 48 48l80 0 0-96c0-17.7 14.3-32 32-32l32 0c.9 0 1.8 0 2.6 .1-.9 5.2-1.5 10.5-2 15.9-.2 0-.4 0-.7 0l-32 0c-8.8 0-16 7.2-16 16l0 96 73.7 0c3.2 5.5 6.6 10.9 10.3 16L96 512c-35.3 0-64-28.7-64-64L32 64C32 28.7 60.7 0 96 0L352 0c35.3 0 64 28.7 64 64l0 144.7c-5.4 .4-10.7 1.1-16 2L400 64c0-26.5-21.5-48-48-48zM320 244c-5.6 4-10.9 8.3-16 12.9l0-16.9c0-4.4-3.6-8-8-8l-24 0c-4.4 0-8 3.6-8 8l0 24c0 4.4 3.6 8 8 8l16.9 0c-4.6 5.1-8.9 10.4-12.9 16l-4 0c-13.3 0-24-10.7-24-24l0-24c0-13.3 10.7-24 24-24l24 0c13.3 0 24 10.7 24 24l0 4zM152 216l24 0c13.3 0 24 10.7 24 24l0 24c0 13.3-10.7 24-24 24l-24 0c-13.3 0-24-10.7-24-24l0-24c0-13.3 10.7-24 24-24zm-8 24l0 24c0 4.4 3.6 8 8 8l24 0c4.4 0 8-3.6 8-8l0-24c0-4.4-3.6-8-8-8l-24 0c-4.4 0-8 3.6-8 8zM128 120c0-13.3 10.7-24 24-24l24 0c13.3 0 24 10.7 24 24l0 24c0 13.3-10.7 24-24 24l-24 0c-13.3 0-24-10.7-24-24l0-24zm24-8c-4.4 0-8 3.6-8 8l0 24c0 4.4 3.6 8 8 8l24 0c4.4 0 8-3.6 8-8l0-24c0-4.4-3.6-8-8-8l-24 0zM272 96l24 0c13.3 0 24 10.7 24 24l0 24c0 13.3-10.7 24-24 24l-24 0c-13.3 0-24-10.7-24-24l0-24c0-13.3 10.7-24 24-24zm-8 24l0 24c0 4.4 3.6 8 8 8l24 0c4.4 0 8-3.6 8-8l0-24c0-4.4-3.6-8-8-8l-24 0c-4.4 0-8 3.6-8 8zM560 400a128 128 0 1 0 -256 0 128 128 0 1 0 256 0zm-272 0a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm144 52a12 12 0 1 1 0 24 12 12 0 1 1 0-24zm0-140c4.4 0 8 3.6 8 8l0 96c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-96c0-4.4 3.6-8 8-8z"]],
    "person-arrow-up-from-line": [576, 512, [], "e539", ["M34.8 271c-5 7.3-3.1 17.3 4.2 22.2s17.3 3.1 22.2-4.2l52.2-76.4c2-2.9 5.6-4.2 9-3.1s5.6 4.1 5.6 7.6L128 512c0 8.8 7.2 16 16 16s16-7.2 16-16l0-144c0-17.7 14.3-32 32-32s32 14.3 32 32l0 144c0 8.8 7.2 16 16 16s16-7.2 16-16l0-294.8c0-3.5 2.3-6.6 5.6-7.6s7 .2 9 3.1L322.8 289c5 7.3 14.9 9.2 22.2 4.2s9.2-14.9 4.2-22.2l-64.1-93.8c-21-30.8-55.9-49.1-93.1-49.1s-72.1 18.4-93.1 49.1L34.8 271zM152 24a40 40 0 1 0 80 0 40 40 0 1 0 -80 0z", "M192-16a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm0 96a56 56 0 1 0 0-112 56 56 0 1 0 0 112zm0 48c37.2 0 72.1 18.4 93.1 49.1L349.2 271c5 7.3 3.1 17.3-4.2 22.2s-17.3 3.1-22.2-4.2l-52.2-76.4c-2-2.9-5.6-4.2-9-3.1s-5.6 4.1-5.6 7.6L256 512c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-144c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 144c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-294.8c0-3.5-2.3-6.6-5.6-7.6s-7 .2-9 3.1L61.2 289c-5 7.3-14.9 9.2-22.2 4.2s-9.2-14.9-4.2-22.2l64.1-93.8c21-30.8 55.9-49.1 93.1-49.1zm75.7 400c2.7-4.7 4.3-10.2 4.3-16l0-268.9 37.6 55c10 14.6 29.9 18.3 44.5 8.4s18.3-29.9 8.4-44.5l-64.1-93.8C274.3 133 234.5 112 192 112s-82.3 21-106.3 56.1L21.6 261.9c-10 14.6-6.2 34.5 8.4 44.5s34.5 6.2 44.5-8.4l37.6-55 0 268.9c0 5.8 1.6 11.3 4.3 16L8 528c-4.4 0-8 3.6-8 8s3.6 8 8 8l560 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-300.3 0zm-55.4 0l-40.6 0c2.7-4.7 4.3-10.2 4.3-16l0-144c0-8.8 7.2-16 16-16s16 7.2 16 16l0 144c0 5.8 1.6 11.3 4.3 16zM549.7 61.7c3.1-3.1 3.1-8.2 0-11.3l-80-80c-3.1-3.1-8.2-3.1-11.3 0l-80 80c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L456-4.7 456 184c0 4.4 3.6 8 8 8s8-3.6 8-8l0-188.7 66.3 66.3c3.1 3.1 8.2 3.1 11.3 0z"]],
    "circle-arrow-down-left": [512, 512, [], "e0f9", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zm144-40c0-4.4 3.6-8 8-8s8 3.6 8 8l0 108.7 162.3-162.3c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3L187.3 336 296 336c4.4 0 8 3.6 8 8s-3.6 8-8 8l-128 0c-4.4 0-8-3.6-8-8l0-128z", "M256 16a240 240 0 1 0 0 480 240 240 0 1 0 0-480zm0 496a256 256 0 1 1 0-512 256 256 0 1 1 0 512zM168 352c-4.4 0-8-3.6-8-8l0-128c0-4.4 3.6-8 8-8s8 3.6 8 8l0 108.7 162.3-162.3c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3L187.3 336 296 336c4.4 0 8 3.6 8 8s-3.6 8-8 8l-128 0z"]],
    "not-equal": [448, 512, [], "f53e", ["", "M382.5 44.6c2.5-3.6 1.7-8.6-1.9-11.1s-8.6-1.7-11.1 1.9L304.3 128 8 128c-4.4 0-8 3.6-8 8s3.6 8 8 8L293 144 135.4 368 8 368c-4.4 0-8 3.6-8 8s3.6 8 8 8l116.1 0-58.7 83.4c-2.5 3.6-1.7 8.6 1.9 11.1s8.6 1.7 11.1-1.9L143.7 384 440 384c4.4 0 8-3.6 8-8s-3.6-8-8-8l-285 0 157.6-224 127.4 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-116.1 0 58.7-83.4z"]],
    "binary-circle-check": [576, 512, [], "e33c", ["", "M384 8c0-2.5-1.2-4.9-3.2-6.4s-4.7-2-7.1-1.2l-80 24c-4.2 1.3-6.6 5.7-5.4 10s5.7 6.6 10 5.4l69.7-20.9 0 189.2-72 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l59.1 0c23.5-10.3 49.5-16 76.8-16L384 208 384 8zm56 200l-7.9 0c3.3 0 6.6 .1 9.9 .3-.6-.2-1.3-.3-2-.3zM160 296c0-2.5-1.2-4.9-3.2-6.4s-4.7-2-7.1-1.2l-80 24c-4.2 1.3-6.6 5.7-5.4 10s5.7 6.6 10 5.4l69.7-20.9 0 189.2-72 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l144 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-56 0 0-200zM128 0C92.7 0 64 28.7 64 64l0 96c0 35.3 28.7 64 64 64l48 0c35.3 0 64-28.7 64-64l0-96c0-35.3-28.7-64-64-64L128 0zM80 64c0-26.5 21.5-48 48-48l48 0c26.5 0 48 21.5 48 48l0 96c0 26.5-21.5 48-48 48l-48 0c-26.5 0-48-21.5-48-48l0-96zM432 272a128 128 0 1 1 0 256 128 128 0 1 1 0-256zm0 272a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm60.7-212.5c-3.6-2.6-8.6-1.8-11.2 1.8l-74 101.7-33.4-40.1c-2.8-3.4-7.9-3.9-11.3-1s-3.9 7.9-1 11.3l40 48c1.6 1.9 3.9 3 6.4 2.9s4.8-1.3 6.2-3.3l80-110c2.6-3.6 1.8-8.6-1.8-11.2z"]],
    "train-tram": [384, 512, [128650], "e5b4", ["M48 288l288 0 0 64c0 44.2-35.8 80-80 80l-128 0c-44.2 0-80-35.8-80-80l0-64zm64 64a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm128 0a16 16 0 1 0 32 0 16 16 0 1 0 -32 0z", "M0-8c0-4.4 3.6-8 8-8l368 0c4.4 0 8 3.6 8 8l0 48c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-40-168 0 0 96 56 0c53 0 96 43 96 96l0 160c0 36.3-20.2 67.9-49.9 84.2l80 94.6c2.9 3.4 2.4 8.4-.9 11.3s-8.4 2.4-11.3-.9L286.8 443c-9.7 3.3-20 5-30.8 5l-128 0c-10.8 0-21.1-1.8-30.8-5L14.1 541.2c-2.9 3.4-7.9 3.8-11.3 .9s-3.8-7.9-.9-11.3l80-94.6C52.2 419.9 32 388.3 32 352l0-160c0-53 43-96 96-96l56 0 0-96-168 0 0 40c0 4.4-3.6 8-8 8s-8-3.6-8-8L0-8zM48 288l0 64c0 44.2 35.8 80 80 80l128 0c44.2 0 80-35.8 80-80l0-64-288 0zm288-16l0-80c0-44.2-35.8-80-80-80l-128 0c-44.2 0-80 35.8-80 80l0 80 288 0zM112 352a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm144-16a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"]],
    "plane-departure": [640, 512, [128747], "f5b0", ["M43.5 238.2l77.5 100.5c14.9 19.3 40.6 26.8 63.5 18.4l8.6-3.1c42.6-15.5 137.8-50.2 285.7-104l90.2-32.8c20.8-7.6 31.5-30.5 23.9-51.3s-30.5-31.5-51.3-23.9L436.5 180.3c-2.1 .8-4.4 .6-6.4-.4L202.1 61.3 140.7 83.6 259.6 233.5c1.6 2 2.1 4.7 1.4 7.1s-2.5 4.5-5 5.3l-90.2 32.8c-2.3 .8-4.8 .6-6.9-.7l-84.2-51.3-31.2 11.4z", "M593 165.9c7.6 20.8-3.1 43.7-23.9 51.3-42.6 15.5-137.8 50.2-285.7 104l-90.2 32.8-8.6 3.1c-22.9 8.3-48.6 .9-63.5-18.4l-77.5-100.5 31.2-11.4 84.2 51.3c2.1 1.3 4.6 1.5 6.9 .7L256.1 246c2.4-.9 4.3-2.9 5-5.3s.2-5.1-1.4-7.1L140.7 83.6 202.1 61.3 430 179.9c2 1 4.3 1.2 6.4 .4L541.7 142c20.8-7.6 43.7 3.1 51.3 23.9zM198.7 369c42.6-15.5 137.8-50.2 285.7-104l90.2-32.8c29.1-10.6 44-42.7 33.5-71.8s-42.7-44-71.8-33.5L434.3 164.1 206.4 45.5c-2-1-4.3-1.2-6.4-.4L124.8 72.4c-2.4 .9-4.3 2.9-5 5.3s-.2 5.1 1.4 7.1l118.9 149.8-76.2 27.7-84.2-51.3c-2.1-1.3-4.6-1.5-6.9-.7L27.8 226.9c-2.4 .9-4.2 2.8-4.9 5.3s-.2 5.1 1.3 7.1l84.2 109.2c19.2 24.8 52.2 34.4 81.6 23.7l8.6-3.1zM40.2 496c-4.4 0-8 3.6-8 8s3.6 8 8 8l560 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-560 0z"]],
    "microphone-stand": [512, 512, [127908], "f8cb", ["M49 368.6c-17.3 18.9-16.6 48.1 1.5 66.3L77 461.6c18.1 18.2 47.4 18.9 66.3 1.5l185-168.9-110.6-110.6-168.9 185zm179-202.4l0 4.8 113 113 4.8 0c24.9 .2 49.7-9.2 68.7-28.1L431.5 238.9 273.2 80.5 256 97.6c-18.9 18.9-28.3 43.8-28.1 68.7zm56.5-97.1l158.4 158.4 5.5-5.5c43.7-43.7 43.7-114.7 0-158.4S333.7 19.9 290 63.7l-5.5 5.5z", "M217.9 183.6l110.6 110.6-185 168.9c-19 17.3-48.2 16.6-66.3-1.5L50.4 434.9c-18.1-18.2-18.8-47.3-1.5-66.3l168.9-185zM341 284.1l-113-113 0-4.8c-.2-24.9 9.2-49.7 28.1-68.7l17.1-17.1 158.4 158.4-17.1 17.1c-18.9 18.9-43.8 28.3-68.7 28.1l-4.8 0zM284.5 69.2l5.5-5.5c43.7-43.7 114.7-43.7 158.4 0s43.7 114.7 0 158.4l-5.5 5.5-158.4-158.4zM459.7 52.3c-50-50-131-50-181 0L244.7 86.3c-22.1 22.1-33 51.1-32.8 80.1L37.1 357.8c-23.1 25.2-22.2 64.2 2 88.4l26.6 26.7c24.2 24.2 63.2 25.2 88.5 2.1l93.9-85.7 0 146.8c0 4.4 3.6 8 8 8s8-3.6 8-8l0-161.4 81.6-74.5c29 .2 58-10.7 80.1-32.8l33.9-33.9c50-50 50-131 0-181z"]],
    "shop-24": [640, 512, [], "e79a", ["M32 204.2C32 224 48 240 67.8 240l440.4 0c19.8 0 35.8-16 35.8-35.8 0-5.6-1.3-11-3.8-16L483.4 74.5C475.2 58.3 458.6 48 440.4 48L135.6 48c-18.2 0-34.8 10.3-42.9 26.5L35.8 188.2c-2.5 5-3.8 10.4-3.8 16zM80 384l0 48c0 17.7 14.3 32 32 32l192 0 0-80-224 0z", "M35.8 188.2c-2.5 5-3.8 10.4-3.8 16 0 19.8 16 35.8 35.8 35.8l440.4 0c19.8 0 35.8-16 35.8-35.8 0-5.6-1.3-11-3.8-16L483.4 74.5C475.2 58.3 458.6 48 440.4 48L135.6 48c-18.2 0-34.8 10.3-42.9 26.5L35.8 188.2zM64 255.9c-26.8-1.9-48-24.3-48-51.6 0-8 1.9-16 5.5-23.2L78.3 67.4C89.2 45.7 111.3 32 135.6 32l304.9 0c24.2 0 46.4 13.7 57.2 35.4l56.8 113.7c3.6 7.2 5.5 15.1 5.5 23.2 0 27.3-21.2 49.7-48 51.6l0 48.1-16 0 0-48-144 0 0 50c-5.7 1.5-11 3.7-16 6.5l0-56.6-256 0 0 112 224 0 0 16-224 0 0 48c0 17.7 14.3 32 32 32l192 0 0 16-192 0c-26.5 0-48-21.5-48-48l0-176.1zM360 408c0-22.1 17.9-40 40-40s40 17.9 40 40l0 1c0 11.6-4.3 22.9-12 31.6L378.7 496 432 496c4.4 0 8 3.6 8 8s-3.6 8-8 8l-58.2 0c-7.6 0-13.8-6.2-13.8-13.8 0-3.4 1.2-6.6 3.5-9.2L416 429.9c5.1-5.8 8-13.2 8-21l0-1c0-13.3-10.7-24-24-24s-24 10.7-24 24c0 4.4-3.6 8-8 8s-8-3.6-8-8zm128 32l0-64c0-4.4 3.6-8 8-8s8 3.6 8 8l0 56 48 0 0-56c0-4.4 3.6-8 8-8s8 3.6 8 8l0 128c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-56-56 0c-2.1 0-4.2-.8-5.7-2.3s-2.3-3.5-2.3-5.7z"]],
    "brightness": [512, 512, [], "e0c9", ["M176 256a80 80 0 1 0 160 0 80 80 0 1 0 -160 0z", "M248 104c0 4.4 3.6 8 8 8s8-3.6 8-8l0-96c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 96zm8 72a80 80 0 1 1 0 160 80 80 0 1 1 0-160zm0 176a96 96 0 1 0 0-192 96 96 0 1 0 0 192zm0 160c4.4 0 8-3.6 8-8l0-96c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 96c0 4.4 3.6 8 8 8zM0 256c0 4.4 3.6 8 8 8l96 0c4.4 0 8-3.6 8-8s-3.6-8-8-8L8 248c-4.4 0-8 3.6-8 8zm408-8c-4.4 0-8 3.6-8 8s3.6 8 8 8l96 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-96 0zM75 437c3.1 3.1 8.2 3.1 11.3 0l67.9-67.9c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0L75 425.7c-3.1 3.1-3.1 8.2 0 11.3zM357.8 142.9c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L437 86.3c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0l-67.9 67.9zM75 75c-3.1 3.1-3.1 8.2 0 11.3l67.9 67.9c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3L86.3 75c-3.1-3.1-8.2-3.1-11.3 0zM369.1 357.8c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3L425.7 437c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-67.9-67.9z"]],
    "right-to-bracket": [512, 512, ["sign-in-alt"], "f2f6", ["M16 240l0 32c0 17.7 14.3 32 32 32l120 0c4.4 0 8 3.6 8 8l0 88c0 3.2 1.9 6.2 4.9 7.4s6.4 .6 8.7-1.7l144-144c3.1-3.1 3.1-8.2 0-11.3l-144-144c-2.3-2.3-5.7-3-8.7-1.7s-4.9 4.2-4.9 7.4l0 88c0 4.4-3.6 8-8 8L48 208c-17.7 0-32 14.3-32 32z", "M333.7 261.7c3.1-3.1 3.1-8.2 0-11.3l-144-144c-2.3-2.3-5.7-3-8.7-1.7l0 0c-3 1.2-4.9 4.2-4.9 7.4l0 88c0 4.4-3.6 8-8 8L48 208c-17.7 0-32 14.3-32 32l0 32c0 17.7 14.3 32 32 32l120 0c4.4 0 8 3.6 8 8l0 88c0 3.2 1.9 6.2 4.9 7.4s6.4 .6 8.7-1.7l144-144zM201 95L345 239c9.4 9.4 9.4 24.6 0 33.9L201 417c-6.9 6.9-17.2 8.9-26.2 5.2S160 409.7 160 400l0-80-112 0c-26.5 0-48-21.5-48-48l0-32c0-26.5 21.5-48 48-48l112 0 0-80c0-9.7 5.8-18.5 14.8-22.2S194.1 88.2 201 95zM328 464l88 0c44.2 0 80-35.8 80-80l0-256c0-44.2-35.8-80-80-80l-88 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l88 0c53 0 96 43 96 96l0 256c0 53-43 96-96 96l-88 0c-4.4 0-8-3.6-8-8s3.6-8 8-8z"]],
    "sd-card": [384, 512, [], "f7c2", ["M16 122.5L16 448c0 26.5 21.5 48 48 48l256 0c26.5 0 48-21.5 48-48l0-384c0-26.5-21.5-48-48-48L122.5 16c-12.7 0-24.9 5.1-33.9 14.1L30.1 88.6c-9 9-14.1 21.2-14.1 33.9zM128 72c0-4.4 3.6-8 8-8s8 3.6 8 8l0 80c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-80zm80 0c0-4.4 3.6-8 8-8s8 3.6 8 8l0 80c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-80zm80 0c0-4.4 3.6-8 8-8s8 3.6 8 8l0 80c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-80z", "M30.1 88.6c-9 9-14.1 21.2-14.1 33.9L16 448c0 26.5 21.5 48 48 48l256 0c26.5 0 48-21.5 48-48l0-384c0-26.5-21.5-48-48-48L122.5 16c-12.7 0-24.9 5.1-33.9 14.1L30.1 88.6zM18.7 77.3L77.3 18.7C89.3 6.7 105.5 0 122.5 0L320 0c35.3 0 64 28.7 64 64l0 384c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 122.5c0-17 6.7-33.3 18.7-45.3zM144 72l0 80c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-80c0-4.4 3.6-8 8-8s8 3.6 8 8zm80 0l0 80c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-80c0-4.4 3.6-8 8-8s8 3.6 8 8zm80 0l0 80c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-80c0-4.4 3.6-8 8-8s8 3.6 8 8z"]],
    "dot": [128, 512, [], "e7d1", ["M16 256c0 26.5 21.5 48 48 48s48-21.5 48-48-21.5-48-48-48-48 21.5-48 48z", "M64 192c35.3 0 64 28.7 64 64s-28.7 64-64 64-64-28.7-64-64 28.7-64 64-64zm0 16c-26.5 0-48 21.5-48 48s21.5 48 48 48 48-21.5 48-48-21.5-48-48-48z"]],
    "house-circle-exclamation": [640, 512, [], "e50a", ["M96 198.1L288 18.9 490.6 208.1c-75.5 2.1-140.1 47.7-169.6 112.7-3-.5-6-.7-9.1-.7l-48 0c-30.9 0-56 25.1-56 56l0 120-72 0c-22.1 0-40-17.9-40-40l0-257.9z", "M277.1 7.2c6.1-5.7 15.7-5.7 21.8 0L515 208.9c-6.2-.6-12.6-.9-19-.9-1.8 0-3.6 0-5.4 .1L288 18.9 96 198.1 96 456c0 22.1 17.9 40 40 40l72 0 0-120c0-30.9 25.1-56 56-56l48 0c3.1 0 6.1 .2 9.1 .7-2.3 5-4.3 10.1-6.2 15.4-1-.1-1.9-.1-2.9-.1l-48 0c-22.1 0-40 17.9-40 40l0 120 105.7 0c3.2 5.5 6.6 10.9 10.3 16l-204 0c-30.9 0-56-25.1-56-56l0-242.9-26.5 24.8c-3.2 3-8.3 2.8-11.3-.4s-2.8-8.3 .4-11.3L277.1 7.2zM624 400a128 128 0 1 0 -256 0 128 128 0 1 0 256 0zm-272 0a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm144 52a12 12 0 1 1 0 24 12 12 0 1 1 0-24zm0-140c4.4 0 8 3.6 8 8l0 96c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-96c0-4.4 3.6-8 8-8z"]],
    "shekel-sign": [448, 512, [8362, "ils", "shekel", "sheqel", "sheqel-sign"], "f20b", ["", "M56 32C33.9 32 16 49.9 16 72l0 400c0 4.4 3.6 8 8 8s8-3.6 8-8L32 72c0-13.3 10.7-24 24-24l136 0c48.6 0 88 39.4 88 88l0 216c0 4.4 3.6 8 8 8s8-3.6 8-8l0-216c0-57.4-46.6-104-104-104L56 32zM328 480c57.4 0 104-46.6 104-104l0-336c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 336c0 48.6-39.4 88-88 88l-136 0c-13.3 0-24-10.7-24-24l0-272c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 272c0 22.1 17.9 40 40 40l136 0z"]],
    "square-u": [448, 512, [], "e281", ["M16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96zm128 72c0-4.4 3.6-8 8-8s8 3.6 8 8l0 104c0 35.3 28.7 64 64 64s64-28.7 64-64l0-104c0-4.4 3.6-8 8-8s8 3.6 8 8l0 104c0 44.2-35.8 80-80 80s-80-35.8-80-80l0-104z", "M64 48C37.5 48 16 69.5 16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm160 72l0 104c0 35.3 28.7 64 64 64s64-28.7 64-64l0-104c0-4.4 3.6-8 8-8s8 3.6 8 8l0 104c0 44.2-35.8 80-80 80s-80-35.8-80-80l0-104c0-4.4 3.6-8 8-8s8 3.6 8 8z"]],
    "truck-container-empty": [640, 512, [], "e2b5", ["M480 272l0 67.3c7.6-2.2 15.7-3.3 24-3.3 48.6 0 88 39.4 88 88 0 1.8-.1 3.6-.2 5.3 17.8-6.2 30.7-22.5 32.1-41.8 .1-1.2 .1-2.3 .1-3.5l0-112-144 0z", "M496 128c-17.7 0-32 14.3-32 32l0 185.6c-28.5 14.6-48 44.2-48 78.4 0 2.7 .1 5.4 .4 8l-80.7 0c.2-2.6 .4-5.3 .4-8 0-48.6-39.4-88-88-88-35.5 0-66.1 21-80 51.3-13.9-30.3-44.5-51.3-80-51.3-48.6 0-88 39.4-88 88s39.4 88 88 88c35.5 0 66.1-21 80-51.3 13.9 30.3 44.5 51.3 80 51.3 40.3 0 74.2-27.1 84.7-64l86.6 0c10.4 36.9 44.4 64 84.7 64 40.8 0 75.1-27.7 85.1-65.3 29.1-6 50.9-31.8 50.9-62.7l0-149.5c0-19.1-7.6-37.4-21.1-50.9l-34.5-34.5c-13.5-13.5-31.8-21.1-50.9-21.1L496 128zm95.8 301.3c.1-1.8 .2-3.5 .2-5.3 0-48.6-39.4-88-88-88-8.3 0-16.4 1.2-24 3.3l0-67.3 144 0 0 112c0 21-13.4 38.8-32.2 45.3zM624 234.5l0 21.5-144 0 0-96c0-8.8 7.2-16 16-16l37.5 0c14.9 0 29.1 5.9 39.6 16.4l34.5 34.5c10.5 10.5 16.4 24.7 16.4 39.6zM16 424a72 72 0 1 1 144 0 72 72 0 1 1 -144 0zm232-72a72 72 0 1 1 0 144 72 72 0 1 1 0-144zm184 72a72 72 0 1 1 144 0 72 72 0 1 1 -144 0z"]],
    "user-pilot-tie": [448, 512, [], "e2c1", ["M16 480l0 32 208 0c-2.8 0-5.3-1.4-6.8-3.8L108.9 334.7C54 360.1 16 415.6 16 480zM64 42.4c0 7.1 3.7 13.6 9.8 17.2l14.5 8.7c4.2 2.5 7 6.8 7.6 11.6 .1 .7 .1 1.3 .1 2 0 6.2 0 12.3 0 18.4 20.7 8.4 71.9 26.5 128 26.5s107.3-18.1 128-26.5L352 82c0-.7 0-1.4 0-2 .8-4.9 3.6-9.2 7.8-11.7l14.5-8.7c6.1-3.6 9.8-10.2 9.8-17.2 0-9.1-6.1-17-14.8-19.4l-141-38.5c-2.8-.8-5.7-.8-8.4 0L78.8 23C70.1 25.4 64 33.3 64 42.4zm104.8 2c2-4 6.8-5.6 10.7-3.6L224 63.1 268.4 40.8c4-2 8.8-.4 10.7 3.6s.4 8.8-3.6 10.7l-48 24c-2.3 1.1-4.9 1.1-7.2 0l-48-24c-4-2-5.6-6.8-3.6-10.7zM182.2 422l1.4 2.2 22-39.6-23.4 37.4zm9.8-95.4c0 1.9 .8 3.8 2.3 5l29.7 25.7 29.7-25.7c1.5-1.3 2.3-3.1 2.3-5 0-3.7-3-6.6-6.6-6.6l-50.7 0c-3.7 0-6.6 3-6.6 6.6zm1.3 113.1l30.7 49.2 30.7-49.2-30.7-55.3-30.7 55.3zM224 512l208 0 0-32c0-64.4-38-119.9-92.9-145.3L230.8 508.2c-1.5 2.3-4 3.8-6.8 3.8zm18.4-127.4l22 39.6 1.4-2.2-23.4-37.4zM312 456c0-4.4 3.6-8 8-8l64 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-64 0c-4.4 0-8-3.6-8-8z", "M368 82l14.5-8.7c10.9-6.5 17.5-18.3 17.5-30.9 0-16.3-10.9-30.5-26.6-34.8l-141-38.5c-5.5-1.5-11.3-1.5-16.8 0L74.6 7.6C58.9 11.9 48 26.1 48 42.4 48 55.1 54.7 66.8 65.5 73.3L80 82 80 100.7c0 6.2 3.5 11.8 9.3 14.1 2 .8 4.2 1.7 6.7 2.7l0 25.3c0 70.7 57.3 128 128 128s128-57.3 128-128l0-25.3c2.5-1 4.8-1.9 6.7-2.7 5.7-2.3 9.3-7.9 9.3-14.1L368 82zm-16 0l0 18.3c-20.7 8.4-71.9 26.5-128 26.5S116.7 108.7 96 100.3L96 82c0-5.6-2.9-10.8-7.8-13.7L73.8 59.6C67.7 56 64 49.5 64 42.4 64 33.3 70.1 25.4 78.8 23l141-38.5c2.8-.8 5.7-.8 8.4 0L369.2 23c8.7 2.4 14.8 10.3 14.8 19.4 0 7.1-3.7 13.6-9.8 17.2l-14.5 8.7C355 71.2 352 76.4 352 82zM112 142.8l0-19.6c26.9 9 67.8 19.6 112 19.6s85.1-10.6 112-19.6l0 19.6c0 61.9-50.1 112-112 112s-112-50.1-112-112zM198.6 304c-12.5 0-22.6 10.1-22.6 22.6 0 6.6 2.9 12.8 7.8 17.1l30 26-30.2 54.4-64.8-103.8c-2.1-3.3-6.2-4.6-9.8-3.2-63.9 26.4-109 89.3-109 162.8l0 24c0 4.4 3.6 8 8 8s8-3.6 8-8l0-24c0-64.4 38-119.9 92.9-145.3L217.2 508.2c1.5 2.3 4 3.8 6.8 3.8s5.3-1.4 6.8-3.8L339.1 334.7C394 360.1 432 415.6 432 480l0 24c0 4.4 3.6 8 8 8s8-3.6 8-8l0-24c0-73.5-45-136.4-109-162.8-3.6-1.5-7.8-.2-9.8 3.2l-64.8 103.8-30.2-54.4 30-26c5-4.3 7.8-10.5 7.8-17.1 0-12.5-10.1-22.6-22.6-22.6l-50.7 0zM224 488.9l-30.7-49.2 30.7-55.3 30.7 55.3-30.7 49.2zM192 326.6c0-3.7 3-6.6 6.6-6.6l50.7 0c3.7 0 6.6 3 6.6 6.6 0 1.9-.8 3.8-2.3 5l-29.7 25.7-29.7-25.7c-1.5-1.3-2.3-3.1-2.3-5zM168.8 44.4c-2 4-.4 8.8 3.6 10.7l48 24c2.3 1.1 4.9 1.1 7.2 0l48-24c4-2 5.6-6.8 3.6-10.7s-6.8-5.6-10.7-3.6L224 63.1 179.6 40.8c-4-2-8.8-.4-10.7 3.6zM320 448c-4.4 0-8 3.6-8 8s3.6 8 8 8l64 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-64 0z"]],
    "radio": [512, 512, [128251], "f8d7", ["M16 160.8c0-3.8 .4-7.6 1.1-11.2 4.8-21.5 23.9-37.6 46.9-37.6l384 0c26.5 0 48 21.5 48 48l0 256c0 26.5-21.5 48-48 48L64 464c-26.5 0-48-21.5-48-48l0-255.2zM72 232c0 4.4 3.6 8 8 8l112 0c4.4 0 8-3.6 8-8s-3.6-8-8-8L80 224c-4.4 0-8 3.6-8 8zm0 56c0 4.4 3.6 8 8 8l112 0c4.4 0 8-3.6 8-8s-3.6-8-8-8L80 280c-4.4 0-8 3.6-8 8zm0 56c0 4.4 3.6 8 8 8l112 0c4.4 0 8-3.6 8-8s-3.6-8-8-8L80 336c-4.4 0-8 3.6-8 8zm184-56a96 96 0 1 0 192 0 96 96 0 1 0 -192 0z", "M506.1-16.3c4.3-1.2 6.8-5.6 5.6-9.8s-5.6-6.8-9.8-5.6L53 91.4c-26.4 7.2-46 28.7-51.4 54.7-1 4.5-1.5 9.1-1.5 13.9L0 416c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L96.6 96 506.1-16.3zM16 160.8c0-3.8 .4-7.6 1.1-11.2 4.8-21.5 23.9-37.6 46.9-37.6l384 0c26.5 0 48 21.5 48 48l0 256c0 26.5-21.5 48-48 48L64 464c-26.5 0-48-21.5-48-48l0-255.2zM352 208a80 80 0 1 1 0 160 80 80 0 1 1 0-160zm0 176a96 96 0 1 0 0-192 96 96 0 1 0 0 192zM80 224c-4.4 0-8 3.6-8 8s3.6 8 8 8l112 0c4.4 0 8-3.6 8-8s-3.6-8-8-8L80 224zm0 56c-4.4 0-8 3.6-8 8s3.6 8 8 8l112 0c4.4 0 8-3.6 8-8s-3.6-8-8-8L80 280zm0 56c-4.4 0-8 3.6-8 8s3.6 8 8 8l112 0c4.4 0 8-3.6 8-8s-3.6-8-8-8L80 336z"]],
    "hand-dots": [512, 512, ["allergies"], "f461", ["M25.4 273.4c-12.5 12.5-12.5 32.8 0 45.3L137.1 430.4c42 42 99 65.6 158.4 65.6l8.5 0c83.9 0 152-68.1 152-152l0-200c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 104c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-168c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 168c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-200c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 200c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-168c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 255.4c0 3.2-1.9 6.2-4.9 7.4s-6.4 .6-8.7-1.7L70.6 273.4c-12.5-12.5-32.8-12.5-45.3 0zM240 352a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm64 64a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm16-112a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm64 64a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M232 48l0 200c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-168c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 255.4c0 3.2-1.9 6.2-4.9 7.4s-6.4 .6-8.7-1.7L70.6 273.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L137.1 430.4c42 42 99 65.6 158.4 65.6l8.5 0c83.9 0 152-68.1 152-152l0-200c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 104c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-168c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 168c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-200c0-17.7-14.3-32-32-32s-32 14.3-32 32zM264 0c25.3 0 46 19.5 47.9 44.3 8.5-7.7 19.8-12.3 32.1-12.3 26.5 0 48 21.5 48 48l0 28.2c8.5-7.6 19.7-12.2 32-12.2 26.5 0 48 21.5 48 48l0 200c0 92.8-75.2 168-168 168l-8.5 0c-63.7 0-124.7-25.3-169.7-70.3L14.1 329.9c-18.7-18.7-18.7-49.1 0-67.9s49.1-18.7 67.9 0L136 316.1 136 80c0-26.5 21.5-48 48-48 12.4 0 23.6 4.7 32.1 12.3 1.9-24.8 22.6-44.3 47.9-44.3zM208 352a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm96-64a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm48 80a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm-64 32a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"]],
    "pencil-line": [576, 512, [], "e74f", ["M68.1 328.7l31.3 31.3 4.7 0 0 4.7 43.3 43.3 4.7 0 0 4.7 31.3 31.3c.8-.7 1.5-1.4 2.3-2.2L404 223.3 288.7 108 70.2 326.4c-.8 .8-1.5 1.5-2.2 2.3z", "M364.2 32.5C374.8 21.9 389.1 16 404 16s29.2 5.9 39.8 16.5l35.7 35.7C490.1 78.8 496 93.1 496 108s-5.9 29.2-16.5 39.8L415.3 212 300 96.7 364.2 32.5zM288.7 108L404 223.3 185.6 441.8c-.8 .7-1.5 1.5-2.3 2.2L68.1 328.7c.7-.8 1.4-1.5 2.2-2.3L288.7 108zM51.8 358.1c1.6-5.7 3.8-11.1 6.7-16.2L170.2 453.5c-5.1 2.9-10.5 5.2-16.2 6.7L26.1 495.7c-2.8 .8-5.8 0-7.8-2.1s-2.8-5-2.1-7.8L51.8 358.1zM404 0c-19.2 0-37.6 7.6-51.1 21.2l-294 294c-10.7 10.7-18.5 24.1-22.6 38.7L.9 481.6c-2.3 8.3 0 17.3 6.2 23.4s15.1 8.5 23.4 6.2l127.8-35.5c14.6-4.1 27.9-11.8 38.7-22.6l294-294C504.4 145.6 512 127.2 512 108s-7.6-37.6-21.2-51.1L455.1 21.2C441.6 7.6 423.2 0 404 0zM264 496c-4.4 0-8 3.6-8 8s3.6 8 8 8l304 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-304 0z"]],
    "hand-shaka": [576, 512, [], "e831", ["M41.9 68.1l17.3 54.8C62.4 133 64 143.6 64 154.2l0 140.5 .2 10.3c5.4 106.4 93.4 191 201.1 191 53.4 0 104.6-21.2 142.3-59L533.1 311.6c6.1-6.1 9.9-14.1 10.7-22.7l.2-3.7c0-20.6-16.7-37.2-37.3-37.3-9.9 0-19.4 3.9-26.3 10.9L373 366.3c-14.1 14-28.1 28-42.1 42.1-10 10-23.5 15.6-37.7 15.6-29.4 0-53.2-23.8-53.3-53.2 0-.7 .1-1.4 .1-2.1-8.1 4.7-17.3 7.3-26.8 7.3-29.4 0-53.2-23.8-53.3-53.2 0-9.5 2.6-18.8 7.3-26.9-.7 0-1.4 .1-2.1 .1-29.4 0-53.2-23.8-53.3-53.2 0-14.1 5.6-27.7 15.6-37.7l16.4-16.4 0-34.4c0-18.8-2.9-37.5-8.5-55.4L118.2 44C111.5 22.9 89 11.2 68 17.9 46.9 24.5 35.2 47 41.9 68.1zM128 242.7c0 20.6 16.7 37.2 37.3 37.2 9.9 0 19.4-3.9 26.3-10.9l61.5-61.5c7-7 10.9-16.5 10.9-26.3 0-20.6-16.7-37.2-37.2-37.2-9.9 0-19.4 3.9-26.3 10.9l-61.5 61.5c-7 7-10.9 16.5-10.9 26.3zm48 80c0 20.6 16.7 37.2 37.3 37.2 9.9 0 19.4-3.9 26.3-10.9l77.5-77.5c7-7 10.9-16.5 10.9-26.3 0-20.6-16.7-37.2-37.3-37.2-9.9 0-19.4 3.9-26.3 10.9l-77.5 77.5c-7 7-10.9 16.5-10.9 26.3zm80 48c0 20.6 16.7 37.2 37.3 37.2 9.9 0 19.4-3.9 26.3-10.9l61.5-61.5c7-7 10.9-16.5 10.9-26.3 0-20.6-16.7-37.3-37.3-37.3-9.9 0-19.4 3.9-26.3 10.9l-61.5 61.5c-7 7-10.9 16.5-10.9 26.3z", "M63.2 2.6c29.5-9.3 61 7 70.3 36.5L150.8 94c6.1 19.5 9.3 39.8 9.3 60.2l0 18.4 29.1-29.1c10-10 23.5-15.6 37.7-15.6 29.4 0 53.2 23.8 53.2 53.2 0 4.2-.6 8.2-1.5 12.2 4-.9 8.1-1.5 12.2-1.5 29.4 0 53.2 23.8 53.3 53.2 0 4.2-.6 8.2-1.5 12.2 4-.9 8.1-1.5 12.2-1.5 29.2 0 52.9 23.6 53.2 52.7l61.2-61.1c10-10 23.5-15.6 37.7-15.6 29.4 0 53.2 23.9 53.3 53.3l-.2 5.2c-1.2 12.2-6.6 23.7-15.3 32.4L419 448.4c-40.7 40.7-96 63.6-153.7 63.7-120 0-217.3-97.3-217.3-217.3l0-140.5c0-9-1.4-17.9-4.1-26.5L26.6 72.9c-9.3-29.5 7-61 36.5-70.3zm55 41.3C111.5 22.9 89 11.2 68 17.9 46.9 24.5 35.2 47 41.9 68.1l17.3 54.8C62.4 133 64 143.6 64 154.2l0 140.5 .2 10.3c5.4 106.4 93.4 191 201.1 191 53.4 0 104.6-21.2 142.3-59L533.1 311.6c6.1-6.1 9.9-14.1 10.7-22.7l.2-3.7c0-20.6-16.7-37.2-37.3-37.3-9.9 0-19.4 3.9-26.3 10.9l-107.4 107.4-.1 0-42.1 42.1c-10 10-23.5 15.6-37.7 15.6-29.4 0-53.2-23.8-53.3-53.2 0-.7 .1-1.4 .1-2.1-8.1 4.7-17.3 7.3-26.8 7.3-29.4 0-53.2-23.8-53.3-53.2 0-9.5 2.6-18.8 7.3-26.9-.7 0-1.4 .1-2.1 .1-29.4 0-53.2-23.8-53.3-53.2 0-14.1 5.6-27.7 15.6-37.7l16.4-16.4 0-34.4c0-18.8-2.9-37.5-8.5-55.4L118.2 44zM354.8 272c-9.9 0-19.4 3.9-26.3 10.9l-61.5 61.5c-7 7-10.9 16.5-10.9 26.3 0 20.6 16.7 37.2 37.3 37.2 9.9 0 19.4-3.9 26.3-10.9l61.5-61.5c7-7 10.9-16.5 10.9-26.3 0-20.6-16.7-37.3-37.3-37.3zm-64-64c-9.9 0-19.4 3.9-26.3 10.9l-77.5 77.5c-7 7-10.9 16.5-10.9 26.3 0 20.6 16.7 37.2 37.3 37.2 9.9 0 19.4-3.9 26.3-10.9l77.5-77.5c7-7 10.9-16.5 10.9-26.3 0-20.6-16.7-37.2-37.3-37.2zm-64-64c-9.9 0-19.4 3.9-26.3 10.9l-61.5 61.5c-7 7-10.9 16.5-10.9 26.3 0 20.6 16.7 37.2 37.3 37.2 9.9 0 19.4-3.9 26.3-10.9l61.5-61.5c7-7 10.9-16.5 10.9-26.3 0-20.6-16.7-37.2-37.2-37.2z"]],
    "flask-gear": [576, 512, [], "e5f1", ["M16 462.5c0-6.4 1.8-12.7 5.3-18.1L91 336 216.1 336c.2 17.4 6.7 34.4 18.6 47.5-20.2 22.3-24.8 55.8-9.4 83.4 5.4 9.7 10.8 19.4 16.2 29.1l-192 0C31 496 16 481 16 462.5z", "M91 336L21.3 444.4C17.8 449.8 16 456.1 16 462.5 16 481 31 496 49.5 496l192 0 6.3 11.3c.9 1.6 1.9 3.2 2.9 4.7L49.5 512c-27.3 0-49.5-22.1-49.5-49.5 0-9.5 2.7-18.8 7.9-26.7 41.7-64.8 86.6-134.8 134.9-209.8 .8-1.3 1.3-2.8 1.3-4.3l0-205.7-24 0c-4.4 0-8-3.6-8-8s3.6-8 8-8L328 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-24 0 0 205.7c0 .5 .1 1.1 .2 1.6-5.3 .5-10.6 1.6-15.7 3.2-.3-1.6-.5-3.2-.5-4.8l0-205.7-128 0 0 205.7c0 4.6-1.3 9.1-3.8 13l-54.9 85.4 116.4 0c-1.1 5.3-1.7 10.7-1.6 16L91 336zm349.1-96.1l-48 0c-4.4 0-8 3.6-8 8l0 5.9c0 16.3-10 29.5-22.1 36.5-12.2 7.1-28.5 8.9-42.6 .8l-4.8-2.8c-3.9-2.2-8.8-.9-11 3l-22.5 40.3c-2.1 3.7-.9 8.4 2.8 10.7l4.5 2.8c13.7 8.5 19.8 23.6 19.6 37.5l0 1.3 0 1.2c.2 13.9-6 29-19.7 37.5l-4.4 2.7c-3.6 2.3-4.9 7-2.8 10.7l22.5 40.4c2.2 3.9 7.1 5.3 11 3l4.8-2.8c14.1-8.1 30.4-6.2 42.6 .8 12.1 7 22.1 20.2 22.1 36.5l0 5.9c0 4.4 3.6 8 8 8l48 0c4.4 0 8-3.6 8-8l0-6.1c0-16.3 9.9-29.4 22-36.4 12.2-7.1 28.5-9 42.5-.8l4.9 2.9c3.9 2.2 8.8 .9 11-3L550.9 436c2.1-3.7 .8-8.4-2.8-10.7l-4.6-2.9c-13.6-8.5-19.7-23.5-19.6-37.4l0-1.1 0-1.2c-.2-13.9 5.9-28.9 19.5-37.4l4.7-2.9c3.6-2.3 4.8-6.9 2.7-10.7l-22.4-40.2c-2.2-3.9-7.1-5.3-11-3l-5 2.9c-14.1 8.1-30.3 6.2-42.5-.8-12.1-7-22-20.1-22-36.4l0-6.1c0-4.4-3.6-8-8-8zm-48-16l48 0c13.3 0 24 10.7 24 24l0 6.1c0 9.4 5.8 17.8 14 22.6 8.2 4.8 18.3 5.6 26.5 .8l5-2.9c11.6-6.7 26.5-2.6 33 9.1l22.4 40.2c6.2 11.2 2.6 25.2-8.2 32l-4.7 2.9c-8 5-12.1 14.2-12 23.7l0 1.4 0 1.3c-.1 9.4 4 18.7 12.1 23.7l4.6 2.9c10.8 6.8 14.5 20.8 8.3 32l-22.4 40.4c-6.5 11.7-21.4 15.9-33 9.1l-4.9-2.9c-8.2-4.7-18.3-3.9-26.5 .8-8.2 4.7-14 13.1-14 22.6l0 6.1c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-5.9c0-9.5-5.9-17.9-14.1-22.7s-18.4-5.6-26.6-.8l-4.8 2.8c-11.6 6.7-26.4 2.6-33-9.1l-22.5-40.4c-6.3-11.2-2.6-25.3 8.3-32.1l4.4-2.7c8-5 12.2-14.3 12.1-23.7l0-1.4 0-1.5c.1-9.5-4-18.7-12.1-23.7l-4.5-2.8c-10.9-6.8-14.5-20.9-8.3-32.1l22.5-40.3c6.5-11.7 21.4-15.8 32.9-9.1l4.8 2.8c8.2 4.8 18.4 3.9 26.6-.8s14.1-13.2 14.1-22.7l0-5.9c0-13.3 10.7-24 24-24zM360 383.8a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm56 40a40 40 0 1 0 0-80 40 40 0 1 0 0 80z"]],
    "book-skull": [448, 512, ["book-dead"], "f6b7", ["M16 56l0 360.8C26.2 406.4 40.3 400 56 400l352 0c13.3 0 24-10.7 24-24l0-336c0-13.3-10.7-24-24-24L56 16C33.9 16 16 33.9 16 56zM120.7 252.7c1.8-4 6.6-5.8 10.6-3.9l92.7 42.5 92.7-42.5c4-1.8 8.8-.1 10.6 3.9s.1 8.8-3.9 10.6l-80.1 36.7 80.1 36.7c4 1.8 5.8 6.6 3.9 10.6s-6.6 5.8-10.6 3.9l-92.7-42.5-92.7 42.5c-4 1.8-8.8 .1-10.6-3.9s-.1-8.8 3.9-10.6l80.1-36.7-80.1-36.7c-4-1.8-5.8-6.6-3.9-10.6zM136 140c0-43.1 40.7-76 88-76s88 32.9 88 76c0 23.9-12.7 44.9-32 58.7l0 9.3c0 13.3-10.7 24-24 24l-64 0c-13.3 0-24-10.7-24-24l0-9.3c-19.3-13.7-32-34.7-32-58.7z", "M0 56C0 25.1 25.1 0 56 0L408 0c22.1 0 40 17.9 40 40l0 336c0 19.4-13.7 35.5-32 39.2l0 80.8 24 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L56 512c-30.9 0-56-25.1-56-56L0 56zM56 416c-22.1 0-40 17.9-40 40s17.9 40 40 40l344 0 0-80-344 0zm-40 .8C26.2 406.4 40.3 400 56 400l352 0c13.3 0 24-10.7 24-24l0-336c0-13.3-10.7-24-24-24L56 16C33.9 16 16 33.9 16 56l0 360.8zM224 80c-41 0-72 28-72 60 0 19 10.8 36.5 28.3 47.7 2.3 1.5 3.7 4 3.7 6.7l0 13.6c0 4.4 3.6 8 8 8l64 0c4.4 0 8-3.6 8-8l0-13.6c0-2.7 1.4-5.3 3.7-6.7 17.6-11.2 28.3-28.6 28.3-47.7 0-32-31-60-72-60zm-88 60c0-43.1 40.7-76 88-76s88 32.9 88 76c0 23.9-12.7 44.9-32 58.7l0 9.3c0 13.3-10.7 24-24 24l-64 0c-13.3 0-24-10.7-24-24l0-9.3c-19.3-13.7-32-34.7-32-58.7zm40 4a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm80-16a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm71.3 124.7c1.8 4 .1 8.8-3.9 10.6l-80.1 36.7 80.1 36.7c4 1.8 5.8 6.6 3.9 10.6s-6.6 5.8-10.6 3.9l-92.7-42.5-92.7 42.5c-4 1.8-8.8 .1-10.6-3.9s-.1-8.8 3.9-10.6l80.1-36.7-80.1-36.7c-4-1.8-5.8-6.6-3.9-10.6s6.6-5.8 10.6-3.9l92.7 42.5 92.7-42.5c4-1.8 8.8-.1 10.6 3.9z"]],
    "unlock-keyhole": [384, 512, ["unlock-alt"], "f13e", ["M16 224c0-26.5 21.5-48 48-48l256 0c26.5 0 48 21.5 48 48l0 224c0 26.5-21.5 48-48 48L64 496c-26.5 0-48-21.5-48-48l0-224zM128 336c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0c-17.7 0-32 14.3-32 32z", "M192-16C130.1-16 80 34.2 80 96l0 64 240 0c35.3 0 64 28.7 64 64l0 224c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 224c0-35.3 28.7-64 64-64l0-64C64 25.3 121.3-32 192-32S320 25.3 320 96l0 8c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-8c0-61.9-50.1-112-112-112zM16 224l0 224c0 26.5 21.5 48 48 48l256 0c26.5 0 48-21.5 48-48l0-224c0-26.5-21.5-48-48-48L64 176c-26.5 0-48 21.5-48 48zM240 336c0-8.8-7.2-16-16-16l-64 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l64 0c8.8 0 16-7.2 16-16zm-16-32c17.7 0 32 14.3 32 32s-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l64 0z"]],
    "truck-ramp": [576, 512, [], "f4e0", ["M336 96c0-26.5 21.5-48 48-48l192 0 0 350.6-3.7 .1c-10.9-36.3-44.5-62.7-84.3-62.7-40.3 0-74.2 27.1-84.7 64l-67.3 0 0-304z", "M320 96c0-35.3 28.7-64 64-64l192 0 0 16-192 0c-26.5 0-48 21.5-48 48l0 304 67.3 0c10.4-36.9 44.4-64 84.7-64 48.6 0 88 39.4 88 88s-39.4 88-88 88-88-39.4-88-88c0-2.7 .1-5.4 .4-8l-71.2 0-318.9 95.7c-4.2 1.3-8.7-1.1-10-5.4s1.1-8.7 5.4-10L320 402 320 96zM488 496a72 72 0 1 0 0-144 72 72 0 1 0 0 144z"]],
    "envelope-dot": [576, 512, ["envelope-badge"], "e16f", ["M48 119.9C48 97.9 65.9 80 87.9 80L368 80c0 53.9 33.4 100.1 80.6 118.9L321.4 293.3c-19.8 14.7-46.9 14.7-66.7 0L64.1 151.9C54 144.4 48 132.5 48 119.9zM48 159c2 2.1 4.2 4 6.6 5.7L245.1 306.1c25.5 18.9 60.3 18.9 85.8 0L467.5 204.8c9.2 2.1 18.7 3.2 28.5 3.2 11.1 0 21.8-1.4 32-4l0 180c0 26.5-21.5 48-48 48L96 432c-26.5 0-48-21.5-48-48l0-225z", "M560 80a64 64 0 1 0 -128 0 64 64 0 1 0 128 0zM416 80a80 80 0 1 1 160 0 80 80 0 1 1 -160 0zM87.9 64L369 64c-.7 5.2-1 10.6-1 16L87.9 80c-22 0-39.9 17.9-39.9 39.9 0 12.6 6 24.5 16.1 32L254.6 293.3c19.8 14.7 46.9 14.7 66.7 0l127.2-94.4c6.1 2.4 12.4 4.4 18.9 5.9L330.9 306.1c-25.5 18.9-60.3 18.9-85.8 0L54.6 164.8C52.2 163 50 161.1 48 159l0 225c0 26.5 21.5 48 48 48l384 0c26.5 0 48-21.5 48-48l0-180c5.5-1.4 10.8-3.2 16-5.3L544 384c0 35.3-28.7 64-64 64L96 448c-35.3 0-64-28.7-64-64l0-264.1C32 89 57 64 87.9 64z"]],
    "house-heart": [512, 512, ["home-heart"], "f4c9", ["M64 198.1L64 456c0 22.1 17.9 40 40 40l304 0c22.1 0 40-17.9 40-40L448 198.1 256 18.9 64 198.1zm80 87.2c0-33.9 27.5-61.3 61.3-61.3 19.3 0 37.5 9.1 49.1 24.5l1.6 2.1 1.6-2.1c11.6-15.4 29.8-24.5 49.1-24.5 33.9 0 61.3 27.5 61.3 61.3l0 2.7c0 32-22.8 60.8-45.8 82.1-23.4 21.6-49.1 37.3-58.5 42.7-4.8 2.8-10.6 2.8-15.4 0-9.5-5.5-35.1-21.1-58.5-42.7-23-21.3-45.8-50.1-45.8-82.1l0-2.7zm31.4 44.7c6.9 9.9 15.7 19.5 25.2 28.3 5.3 4.9 10.8 9.6 16.2 13.8-14.4-13.3-29.5-27.6-41.4-42.1zm122.7 39.7c4.4-3.6 8.9-7.4 13.3-11.5 9.8-9 18.7-18.8 25.7-28.9-11.1 13.7-25 27.3-38.9 40.4z", "M245.1 7.2c6.1-5.7 15.7-5.7 21.8 0L501.5 226.2c3.2 3 3.4 8.1 .4 11.3s-8.1 3.4-11.3 .4L464 213.1 464 456c0 30.9-25.1 56-56 56l-304 0c-30.9 0-56-25.1-56-56l0-242.9-26.5 24.8c-3.2 3-8.3 2.8-11.3-.4s-2.8-8.3 .4-11.3L245.1 7.2zM256 18.9L64 198.1 64 456c0 22.1 17.9 40 40 40l304 0c22.1 0 40-17.9 40-40l0-257.9-192-179.2zM160 285.3l0 2.7c0 24.8 18.1 49.5 40.6 70.4 21.9 20.2 46.1 35.1 55.4 40.5 9.3-5.4 33.5-20.2 55.4-40.5 22.5-20.8 40.6-45.6 40.6-70.4l0-2.7c0-25-20.3-45.3-45.3-45.3-14.3 0-27.7 6.7-36.3 18.1l-8 10.7c-1.5 2-3.9 3.2-6.4 3.2s-4.9-1.2-6.4-3.2l-8-10.7c-8.6-11.4-22-18.1-36.3-18.1-25 0-45.3 20.3-45.3 45.3zM205.3 224c19.3 0 37.5 9.1 49.1 24.5l1.6 2.1 1.6-2.1c11.6-15.4 29.8-24.5 49.1-24.5 33.9 0 61.3 27.5 61.3 61.3l0 2.7c0 32-22.8 60.8-45.8 82.1-23.4 21.6-49.1 37.3-58.5 42.7-4.8 2.8-10.6 2.8-15.4 0-9.5-5.5-35.1-21.1-58.5-42.7-23-21.3-45.8-50.1-45.8-82.1l0-2.7c0-33.9 27.5-61.3 61.3-61.3z"]],
    "file-arrow-up": [384, 512, ["file-upload"], "f574", ["M16 64l0 384c0 26.5 21.5 48 48 48l256 0c26.5 0 48-21.5 48-48l0-261.5c0-3.6-.4-7.1-1.2-10.5L264 176c-30.9 0-56-25.1-56-56l0-102.8c-3.4-.8-6.9-1.2-10.5-1.2L64 16C37.5 16 16 37.5 16 64zm98.3 250.3l72-72c3.1-3.1 8.2-3.1 11.3 0l72 72c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L200 267.3 200 424c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-156.7-58.3 58.3c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3z", "M197.5 16c3.6 0 7.1 .4 10.5 1.2L208 120c0 30.9 25.1 56 56 56l102.8 0c.8 3.4 1.2 6.9 1.2 10.5L368 448c0 26.5-21.5 48-48 48L64 496c-26.5 0-48-21.5-48-48L16 64c0-26.5 21.5-48 48-48l133.5 0zM353.9 152.6c2.3 2.3 4.3 4.8 6.1 7.4l-96 0c-22.1 0-40-17.9-40-40l0-96c2.7 1.8 5.1 3.8 7.4 6.1L353.9 152.6zM64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-261.5c0-17-6.7-33.3-18.7-45.3L242.7 18.7C230.7 6.7 214.5 0 197.5 0L64 0zM197.7 242.3c-3.1-3.1-8.2-3.1-11.3 0l-72 72c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L184 267.3 184 424c0 4.4 3.6 8 8 8s8-3.6 8-8l0-156.7 58.3 58.3c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-72-72z"]],
    "game-console-handheld": [384, 512, [], "f8bb", ["M16 64l0 352c0 44.2 35.8 80 80 80l192 0c44.2 0 80-35.8 80-80l0-352c0-26.5-21.5-48-48-48L64 16C37.5 16 16 37.5 16 64zM64 80c0-8.8 7.2-16 16-16l224 0c8.8 0 16 7.2 16 16l0 144c0 17.7-14.3 32-32 32L96 256c-17.7 0-32-14.3-32-32L64 80zm0 256c0-4.4 3.6-8 8-8l32 0 0-32c0-4.4 3.6-8 8-8s8 3.6 8 8l0 32 32 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-32 0 0 32c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-32-32 0c-4.4 0-8-3.6-8-8zm200 24a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm64-48a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M64 16C37.5 16 16 37.5 16 64l0 352c0 44.2 35.8 80 80 80l192 0c44.2 0 80-35.8 80-80l0-352c0-26.5-21.5-48-48-48L64 16zM0 64C0 28.7 28.7 0 64 0L320 0c35.3 0 64 28.7 64 64l0 352c0 53-43 96-96 96L96 512c-53 0-96-43-96-96L0 64zM80 80l0 144c0 8.8 7.2 16 16 16l192 0c8.8 0 16-7.2 16-16l0-144-224 0zM64 80c0-8.8 7.2-16 16-16l224 0c8.8 0 16 7.2 16 16l0 144c0 17.7-14.3 32-32 32L96 256c-17.7 0-32-14.3-32-32L64 80zM232 344a16 16 0 1 0 0 32 16 16 0 1 0 0-32zm32 16a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm16-48a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm16 32a32 32 0 1 1 0-64 32 32 0 1 1 0 64zM104 296c0-4.4 3.6-8 8-8s8 3.6 8 8l0 32 32 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-32 0 0 32c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-32-32 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l32 0 0-32z"]],
    "face-grin-tears": [640, 512, [128514, "grin-tears"], "f588", ["M64.1 248c.5-16.8 2.7-33.3 6.3-49.2l17-2.1C113.8 92.8 207.9 16 320 16S526.2 92.8 552.6 196.7l17 2.1c3.6 15.9 5.8 32.3 6.3 49.2l-43.5-5.4c-10.4-1.3-19.2 7.5-17.9 17.9l6.9 55.5c2.5 20.1 14.9 36.8 31.9 45.5-6.6 14.7-14.6 28.6-23.8 41.7-4.7-2.5-9.2-5.4-13.5-8.6-43.5 61.4-115.1 101.5-196 101.5S167.4 455.9 124 394.5c-4.3 3.2-8.8 6.1-13.5 8.6-9.2-13.1-17.2-27-23.8-41.7 8.5-4.4 15.8-10.7 21.4-18.5 2.8-3.9 5.1-8.1 6.9-12.7 .9-2.3 1.6-4.6 2.3-7s1.1-4.8 1.4-7.4c2.3-18.5 4.6-37 6.9-55.5 1.3-10.4-7.5-19.2-17.9-17.9L64.1 248zm102.4 69.3C186 383.6 247.4 432 320 432s134-48.4 153.5-114.7c3.4-11.7-8.4-21-20-17.3-39.9 12.8-85.3 20-133.5 20s-93.6-7.2-133.5-20c-11.6-3.7-23.4 5.6-20 17.3zM184 210l0 16c0 4.4 3.6 8 8 8s8-3.6 8-8l0-16c0-22.1 17.9-40 40-40s40 17.9 40 40l0 16c0 4.4 3.6 8 8 8s8-3.6 8-8l0-16c0-30.9-25.1-56-56-56s-56 25.1-56 56zm160 0l0 16c0 4.4 3.6 8 8 8s8-3.6 8-8l0-16c0-22.1 17.9-40 40-40s40 17.9 40 40l0 16c0 4.4 3.6 8 8 8s8-3.6 8-8l0-16c0-30.9-25.1-56-56-56s-56 25.1-56 56z", "M320 496c81 0 152.6-40.1 196-101.5 4.3 3.2 8.8 6.1 13.5 8.6-46.3 65.8-122.9 108.9-209.5 108.9S156.8 469 110.5 403.1c4.7-2.5 9.2-5.4 13.5-8.6 43.5 61.4 115.1 101.5 196 101.5zM320 0C441.7 0 543.6 85 569.6 198.8l-17-2.1C526.2 92.8 432.1 16 320 16S113.8 92.8 87.4 196.7l-17 2.1C96.4 85 198.3 0 320 0zM457.3 315.6C416 328.7 369.3 336 320 336s-96-7.3-137.3-20.4C201.2 373.8 255.7 416 320 416s118.8-42.2 137.3-100.4zM453.5 300c11.6-3.7 23.4 5.6 20 17.3-19.5 66.3-80.9 114.7-153.5 114.7S186 383.6 166.5 317.3c-3.4-11.7 8.4-21 20-17.3 39.9 12.8 85.3 20 133.5 20s93.6-7.2 133.5-20zM200 210l0 16c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-16c0-30.9 25.1-56 56-56s56 25.1 56 56l0 16c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-16c0-22.1-17.9-40-40-40s-40 17.9-40 40zm200-40c-22.1 0-40 17.9-40 40l0 16c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-16c0-30.9 25.1-56 56-56s56 25.1 56 56l0 16c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-16c0-22.1-17.9-40-40-40zM16 308.5c0 24 19.5 43.5 43.5 43.5 21.9 0 40.4-16.3 43.2-38.1l6.9-55.5-55.5 6.9C32.3 268.1 16 286.6 16 308.5zm569.9-43.1l-55.5-6.9 6.9 55.5c2.7 21.8 21.2 38.1 43.2 38.1 24 0 43.5-19.5 43.5-43.5 0-21.9-16.3-40.4-38.1-43.2zM52.1 249.5l55.5-6.9c10.4-1.3 19.2 7.5 17.9 17.9l-6.9 55.5c-3.7 29.8-29 52.1-59 52.1-32.9 0-59.5-26.6-59.5-59.5 0-30 22.3-55.3 52.1-59zm535.8 0c29.8 3.7 52.1 29 52.1 59 0 32.9-26.6 59.5-59.5 59.5-30 0-55.3-22.3-59-52.1l-6.9-55.5c-1.3-10.4 7.5-19.2 17.9-17.9l55.5 6.9z"]],
    "pen-to-square": [512, 512, ["edit"], "f044", ["M146.7 365.3l78.1-18c7.3-1.7 14-5.4 19.3-10.7L428.7 152 360 83.3 175.4 267.9c-5.3 5.3-9 12-10.7 19.3l-18 78.1z", "M460.3 39.6l12.1 12.1c15.6 15.6 15.6 40.9 0 56.6L440 140.7 371.3 72 403.7 39.6c15.6-15.6 40.9-15.6 56.6 0zM175.4 267.9L360 83.3 428.7 152 244.1 336.6c-5.3 5.3-12 9-19.3 10.7l-78.1 18 18-78.1c1.7-7.3 5.4-14 10.7-19.3zm217-239.6L164.1 256.6c-7.4 7.4-12.6 16.8-15 27l-20.9 90.6c-.6 2.7 .2 5.5 2.1 7.5s4.8 2.8 7.5 2.1l90.6-20.9c10.2-2.4 19.6-7.5 27-15L483.7 119.6c21.9-21.9 21.9-57.3 0-79.2L471.6 28.3c-21.9-21.9-57.3-21.9-79.2 0zM72 64C32.2 64 0 96.2 0 136L0 440c0 39.8 32.2 72 72 72l304 0c39.8 0 72-32.2 72-72l0-144c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 144c0 30.9-25.1 56-56 56L72 496c-30.9 0-56-25.1-56-56l0-304c0-30.9 25.1-56 56-56l144 0c4.4 0 8-3.6 8-8s-3.6-8-8-8L72 64z"]],
    "earth-europe": [512, 512, ["globe-europe"], "f7a2", ["M168 354.3l0 3.2c0 14.9 5.9 29.1 16.4 39.6l16 16c7 7 16.5 10.9 26.3 10.9 29.4 0 53.3 23.8 53.3 53.3l0 17.6c64.1-6.4 120.8-38 160-84.7l0-35.5c0-8.1-6.6-14.6-14.6-14.6-8.1 0-15.9-3.2-21.7-9l-13.4-13.4c-6.2-6.2-14.5-9.6-23.2-9.6-11.7 0-22.9-4.2-31.8-11.8l-26.6-22.8c-10.1-8.7-23.1-13.5-36.4-13.5l-20.9 0c-11.1 0-21.9 3.3-31.1 9.4l-27.4 18.3C177.4 318 168 335.5 168 354.3zm32-148.2l0 4.3c0 11.9 9.9 21.7 21.9 21.7 8 0 15.4-4.5 18.9-11.6l4-8.1c3.8-7.6 11.5-12.3 20-12.3 7 0 13.6 3.3 17.8 8.9L299 230.7c.6 .8 1.6 1.3 2.7 1.3 2.5 0 4.1-2.6 3-4.8l-2.2-4.3c-5-10.1-1.8-22.3 7.6-28.5l33-22c1.8-1.2 3.2-2.8 4.2-4.7 4.8-9.6 14.6-15.6 25.3-15.6l27.5 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-20.7 0c-5.1 0-10 2-13.7 5.7l-4.7 4.7c-.6 .6-1 1.5-1 2.3 0 1.8 1.5 3.3 3.3 3.3l11.3 0c8.1 0 15.9 3.2 21.7 9l6.5 6.5c3.3 3.3 5.2 7.8 5.2 12.5s-1.9 9.2-5.2 12.5l-7.5 7.5c-2.1 2.1-3.3 5-3.3 8s1.2 5.9 3.3 8l18.3 18.3c8.7 8.7 20.6 13.7 33 13.7l42.8 0c4.3-18 6.6-36.7 6.6-56 0-110-74-202.7-175-231.1L237.7 80.5c-3.6 2.4-5.7 6.4-5.7 10.7l0 8.6c0 2.4 1.9 4.3 4.3 4.3 .8 0 1.7-.3 2.4-.7l41.8-27.9c3.3-2.2 7.2-3.4 11.3-3.4l1 0c10.7 0 19.3 8.6 19.3 19.3 0 5.1-2 10-5.7 13.7l-19.9 19.9c-6.7 6.7-14.8 11.7-23.8 14.7l-26.5 8.8c-2.5 .8-4.2 3.2-4.2 5.8 0 5.9-2.3 11.5-6.5 15.6l-17.9 17.9c-4.9 4.9-7.6 11.5-7.6 18.3z", "M489.4 312l-42.8 0c-12.4 0-24.2-4.9-33-13.7L395.3 280c-2.1-2.1-3.3-5-3.3-8s1.2-5.9 3.3-8l7.5-7.5c3.3-3.3 5.2-7.8 5.2-12.5s-1.9-9.2-5.2-12.5l-6.5-6.5c-5.7-5.7-13.5-9-21.7-9l-11.3 0c-1.8 0-3.3-1.5-3.3-3.3 0-.9 .3-1.7 1-2.3l4.7-4.7c3.6-3.6 8.5-5.7 13.7-5.7l20.7 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-27.5 0c-10.7 0-20.5 6-25.3 15.6-1 1.9-2.4 3.5-4.2 4.7l-33 22c-9.4 6.2-12.6 18.5-7.6 28.5l2.2 4.3c1.1 2.2-.5 4.8-3 4.8-1 0-2-.5-2.7-1.3l-16.3-21.7c-4.2-5.6-10.8-8.9-17.8-8.9-8.5 0-16.2 4.8-20 12.3l-4 8.1c-3.5 7-10.9 11.6-18.9 11.6-12.1 0-21.9-9.8-21.9-21.7l0-4.3c0-6.9 2.7-13.5 7.6-18.3l17.9-17.9c4.1-4.1 6.5-9.8 6.5-15.6 0-2.6 1.7-5 4.2-5.8l26.5-8.8c9-3 17.1-8 23.8-14.7L306.3 105c3.6-3.6 5.7-8.5 5.7-13.7 0-10.7-8.6-19.3-19.3-19.3l-1 0c-4 0-7.9 1.2-11.3 3.4l-41.8 27.9c-.7 .5-1.5 .7-2.4 .7-2.4 0-4.3-1.9-4.3-4.3l0-8.6c0-4.3 2.1-8.3 5.7-10.7L321 24.9c100.9 28.4 175 121.1 175 231.1 0 19.3-2.3 38-6.6 56zM485 328c-6.8 21.7-16.7 42.1-29 60.7l0-14.1c0-16.9-13.7-30.6-30.6-30.6-3.9 0-7.6-1.5-10.3-4.3l-13.4-13.4c-9.2-9.2-21.6-14.3-34.5-14.3-7.8 0-15.4-2.8-21.4-7.9l-26.6-22.8c-13-11.2-29.7-17.3-46.9-17.3l-20.9 0c-14.2 0-28.1 4.2-39.9 12.1l-27.4 18.3c-20 13.4-32.1 35.8-32.1 59.9l0 3.2c0 19.1 7.6 37.4 21.1 50.9l16 16c10 10 23.5 15.6 37.7 15.6 20.6 0 37.3 16.7 37.3 37.3l0 18.6c-2.7 .1-5.3 .1-8 .1-132.5 0-240-107.5-240-240S123.5 16 256 16c14.9 0 29.5 1.4 43.6 4L228.8 67.2c-8 5.3-12.8 14.4-12.8 24l0 8.6c0 11.2 9.1 20.3 20.3 20.3 4 0 7.9-1.2 11.2-3.4l41.8-27.9c.7-.5 1.5-.7 2.4-.7l1 0c1.8 0 3.3 1.5 3.3 3.3 0 .9-.3 1.7-1 2.3l-19.9 19.9c-4.9 4.9-10.9 8.6-17.5 10.8l-26.5 8.8c-9 3-15.1 11.5-15.1 21 0 1.6-.6 3.2-1.8 4.3l-17.9 17.9c-7.9 7.9-12.3 18.5-12.3 29.7l0 4.3c0 20.9 17.2 37.7 37.9 37.7 13.9 0 26.9-7.9 33.2-20.4l4-8.1c1.1-2.1 3.3-3.5 5.6-3.5 2 0 3.9 .9 5 2.5l16.3 21.7c3.7 4.9 9.4 7.7 15.5 7.7 14.4 0 23.7-15.1 17.3-28l-2.2-4.3c-1.4-2.8-.5-6.3 2.1-8.1l33-22c4.1-2.7 7.4-6.5 9.6-10.9 2.1-4.1 6.3-6.8 11-6.8l27.5 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-20.7 0c-9.4 0-18.3 3.7-25 10.3l-4.7 4.7c-3.6 3.6-5.7 8.5-5.7 13.7 0 10.7 8.6 19.3 19.3 19.3l11.3 0c3.9 0 7.6 1.5 10.3 4.3l6.5 6.5c.3 .3 .5 .7 .5 1.2s-.2 .9-.5 1.2l-7.5 7.5c-5.1 5.1-8 12.1-8 19.3s2.9 14.2 8 19.3l18.3 18.3C414.1 321.4 430 328 446.6 328l38.4 0zm-45 82.1c-39.2 46.8-95.9 78.4-160 84.7l0-17.6c0-29.4-23.8-53.3-53.3-53.3-9.9 0-19.4-3.9-26.3-10.9l-16-16c-10.5-10.5-16.4-24.7-16.4-39.6l0-3.2c0-18.7 9.4-36.2 24.9-46.6l27.4-18.3c9.2-6.1 20-9.4 31.1-9.4l20.9 0c13.4 0 26.3 4.8 36.4 13.5l26.6 22.8c8.8 7.6 20.1 11.8 31.8 11.8 8.7 0 17 3.5 23.2 9.6L403.7 351c5.7 5.7 13.5 9 21.7 9 8.1 0 14.6 6.6 14.6 14.6l0 35.5zM256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM181.7 106.3c-3.1-3.1-8.2-3.1-11.3 0l-32 32c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l32-32c3.1-3.1 3.1-8.2 0-11.3z"]],
    "table-picnic": [512, 512, [], "e32d", ["M126.4 256l259.3 0-73-172.9c-.4-1-.6-2.1-.6-3.1-37.3 0-74.7 0-112 0 0 1-.2 2.1-.6 3.1L126.4 256z", "M47.4 443.1c-1.7 4.1-6.4 6-10.5 4.2-4.1-1.7-6-6.4-4.2-10.5L82 320 99.4 320 47.4 443.1zm432-6.2c1.7 4.1-.2 8.8-4.2 10.5s-8.8-.2-10.5-4.2l-52-123.1 17.4 0 49.3 116.9zM440 64c4.4 0 8 3.6 8 8s-3.6 8-8 8l-111.3 0 74.3 176 101 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L8 272c-4.4 0-8-3.6-8-8s3.6-8 8-8L109 256 183.3 80 72 80c-4.4 0-8-3.6-8-8s3.6-8 8-8l368 0zM200 80c0 1-.2 2.1-.6 3.1l-73 172.9 259.3 0-73-172.9c-.4-1-.6-2.1-.6-3.1L200 80z"]],
    "face-grin-beam-sweat": [512, 512, [128517, "grin-beam-sweat"], "f583", ["M16 256c0-132.5 107.5-240 240-240 34.7 0 67.7 7.4 97.6 20.7-1.1 1.9-2.1 3.7-3.1 5.7-7 13.5-14.5 32.1-14.5 53.7 0 22.5 6.6 43.4 18 61-5.7-1.9-11.7-3-18-3-30.9 0-56 25.1-56 56l0 16c0 4.4 3.6 8 8 8s8-3.6 8-8l0-16c0-22.1 17.9-40 40-40s40 17.9 40 40l0 16c0 4.4 3.6 8 8 8s8-3.6 8-8l0-16c0-6.7-1.2-13.1-3.3-19 17.2 10.8 37.5 17 59.3 17 14.6 0 28.6-2.8 41.4-7.9 4.3 17.9 6.6 36.7 6.6 55.9 0 132.5-107.5 240-240 240S16 388.5 16 256zm86.5 61.3C122 383.6 183.4 432 256 432s134-48.4 153.5-114.7c3.4-11.7-8.4-21-20-17.3-39.9 12.8-85.3 20-133.5 20s-93.6-7.2-133.5-20c-11.6-3.7-23.4 5.6-20 17.3zM120 210l0 16c0 4.4 3.6 8 8 8s8-3.6 8-8l0-16c0-22.1 17.9-40 40-40s40 17.9 40 40l0 16c0 4.4 3.6 8 8 8s8-3.6 8-8l0-16c0-30.9-25.1-56-56-56s-56 25.1-56 56z", "M362.1 22.9C329.8 8.2 293.8 0 256 0 114.6 0 0 114.6 0 256S114.6 512 256 512 512 397.4 512 256c0-21.8-2.7-42.9-7.8-63.1-4.7 2.7-9.6 5.1-14.7 7.2 4.3 17.9 6.6 36.7 6.6 55.9 0 132.5-107.5 240-240 240S16 388.5 16 256 123.5 16 256 16c34.7 0 67.7 7.4 97.6 20.7 2.8-4.9 5.7-9.5 8.5-13.7zm31.2 292.6C374.8 373.8 320.3 416 256 416S137.2 373.8 118.7 315.6C160 328.7 206.7 336 256 336s96-7.3 137.3-20.4zM389.5 300c-39.9 12.8-85.3 20-133.5 20s-93.6-7.2-133.5-20c-11.6-3.7-23.4 5.6-20 17.3 19.5 66.3 80.9 114.7 153.5 114.7s134-48.4 153.5-114.7c3.4-11.7-8.4-21-20-17.3zM136 210c0-22.1 17.9-40 40-40s40 17.9 40 40l0 16c0 4.4 3.6 8 8 8s8-3.6 8-8l0-16c0-30.9-25.1-56-56-56s-56 25.1-56 56l0 16c0 4.4 3.6 8 8 8s8-3.6 8-8l0-16zm200-40c22.1 0 40 17.9 40 40l0 16c0 4.4 3.6 8 8 8s8-3.6 8-8l0-16c0-30.9-25.1-56-56-56s-56 25.1-56 56l0 16c0 4.4 3.6 8 8 8s8-3.6 8-8l0-16c0-22.1 17.9-40 40-40zM448 18.8c7.7 7.2 15 15.1 21.8 23.3 14.6 17.7 26.2 36.1 26.2 53.9 0 27.6-20.4 48-48 48s-48-20.4-48-48c0-17.8 11.6-36.2 26.2-53.9 6.8-8.3 14.1-16.1 21.8-23.3zm34.2 13.1c-8.8-10.7-18.5-20.9-29-30-3-2.6-7.4-2.6-10.4 0-10.5 9.1-20.1 19.3-29 30-14.7 17.8-29.8 40.1-29.8 64.1 0 36.4 27.6 64 64 64s64-27.6 64-64c0-24-15.2-46.3-29.8-64.1z"]],
    "circle-half-stroke": [512, 512, [9680, "adjust"], "f042", ["M16 256c0 129.9 103.2 235.6 232 239.9l0-479.7C119.2 20.4 16 126.1 16 256z", "M264 495.9l0-479.7c128.8 4.2 232 110 232 239.9S392.8 491.6 264 495.9zm-16 0C119.2 491.6 16 385.9 16 256S119.2 20.4 248 16.1l0 479.7zm8 16.1a256 256 0 1 0 0-512 256 256 0 1 0 0 512z"]],
    "ruler-triangle": [512, 512, [128208], "f61c", ["M48 32l0 416c0 8.8 7.2 16 16 16l416 0c6.5 0 12.3-3.9 14.8-9.9s1.1-12.9-3.5-17.4l-42.3-42.3-19.3 19.3c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l19.3-19.3-68.7-68.7-35.3 35.3c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l35.3-35.3-68.7-68.7-19.3 19.3c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l19.3-19.3-68.7-68.7-35.3 35.3c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3L197.7 143 129 74.3 109.7 93.7c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3L117.7 63 75.3 20.7c-4.6-4.6-11.5-5.9-17.4-3.5S48 25.5 48 32zm96 212.5c0-3.2 1.9-6.2 4.9-7.4s6.4-.6 8.7 1.7L273.2 354.3c2.3 2.3 3 5.7 1.7 8.7s-4.2 4.9-7.4 4.9L152 368c-4.4 0-8-3.6-8-8l0-115.5z", "M75.3 20.7L117.7 63 98.3 82.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l19.3-19.3 68.7 68.7-35.3 35.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l35.3-35.3 68.7 68.7-19.3 19.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l19.3-19.3 68.7 68.7-35.3 35.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l35.3-35.3 68.7 68.7-19.3 19.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l19.3-19.3 42.3 42.3c4.6 4.6 5.9 11.5 3.5 17.4S486.5 464 480 464L64 464c-8.8 0-16-7.2-16-16L48 32c0-6.5 3.9-12.3 9.9-14.8s12.9-1.1 17.4 3.5zM86.6 9.4C77.5 .2 63.7-2.5 51.8 2.4S32 19.1 32 32l0 416c0 17.7 14.3 32 32 32l416 0c12.9 0 24.6-7.8 29.6-19.8s2.2-25.7-6.9-34.9L86.6 9.4zm71 229.4c-2.3-2.3-5.7-3-8.7-1.7s-4.9 4.2-4.9 7.4L144 360c0 4.4 3.6 8 8 8l115.5 0c3.2 0 6.2-1.9 7.4-4.9s.6-6.4-1.7-8.7L157.7 238.8zM160 352l0-88.2 88.2 88.2-88.2 0z"]],
    "octagon-plus": [512, 512, ["plus-octagon"], "f301", ["M16.5 181.6l0 148.8c0 8.5 3.4 16.6 9.4 22.6L159.4 486.6c6 6 14.1 9.4 22.6 9.4l148.8 0c8.5 0 16.6-3.4 22.6-9.4L487 353c6-6 9.4-14.1 9.4-22.6l0-148.8c0-8.5-3.4-16.6-9.4-22.6L353.5 25.4c-6-6-14.1-9.4-22.6-9.4L182 16.1c-8.5 0-16.6 3.4-22.6 9.4L25.9 159c-6 6-9.4 14.1-9.4 22.6zM144.4 256c0-4.4 3.6-8 8-8l96 0 0-96c0-4.4 3.6-8 8-8s8 3.6 8 8l0 96 96 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-96 0 0 96c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-96-96 0c-4.4 0-8-3.6-8-8z", "M159.4 25.4c6-6 14.1-9.4 22.6-9.4l148.8 0c8.5 0 16.6 3.4 22.6 9.4L487 159c6 6 9.4 14.1 9.4 22.6l0 148.8c0 8.5-3.4 16.6-9.4 22.6L353.5 486.6c-6 6-14.1 9.4-22.6 9.4l-148.8 0c-8.5 0-16.6-3.4-22.6-9.4L25.9 353c-6-6-9.4-14.1-9.4-22.6l0-148.8c0-8.5 3.4-16.6 9.4-22.6L159.4 25.4zM182 .1c-12.7 0-24.9 5.1-33.9 14.1L14.6 147.6c-9 9-14.1 21.2-14.1 33.9l0 148.8c0 12.7 5.1 24.9 14.1 33.9L148.1 497.9c9 9 21.2 14.1 33.9 14.1l148.8 0c12.7 0 24.9-5.1 33.9-14.1L498.3 364.4c9-9 14.1-21.2 14.1-33.9l0-148.8c0-12.7-5.1-24.9-14.1-33.9L364.8 14.1c-9-9-21.2-14.1-33.9-14.1L182 .1zM248.4 360c0 4.4 3.6 8 8 8s8-3.6 8-8l0-96 96 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-96 0 0-96c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 96-96 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l96 0 0 96z"]],
    "user-cowboy": [448, 512, [], "f8ea", ["M8 512c4.4 0 8-3.6 8-8l0-8c0-88.4 71.6-160 160-160l96 0c88.4 0 160 71.6 160 160l0 8c0 4.4 3.6 8 8 8L8 512zM114.4 102.4c3.2-20.7 8.8-46.3 17.1-68.6 5.5-14.8 12-27.6 19.5-36.6 7.5-9 15.1-13.3 23-13.3 7.4 0 15.1 2.6 23.4 5.9 7.9 3.2 18.6 6.4 26.6 6.4s18.7-3.2 26.6-6.4c8.3-3.3 16-5.9 23.4-5.9 7.9 0 15.6 4.3 23 13.3 7.5 9 14 21.8 19.5 36.6 8.3 22.3 13.9 47.8 17.1 68.6-29 10.4-65.3 17.6-109.6 17.6s-80.6-7.2-109.6-17.6z", "M114.4 102.4c3.2-20.7 8.8-46.3 17.1-68.6 5.5-14.8 12-27.6 19.5-36.6 7.5-9 15.1-13.3 23-13.3 7.4 0 15.1 2.6 23.4 5.9 7.9 3.2 18.6 6.4 26.6 6.4s18.7-3.2 26.6-6.4c8.3-3.3 16-5.9 23.4-5.9 7.9 0 15.6 4.3 23 13.3 7.5 9 14 21.8 19.5 36.6 8.3 22.3 13.9 47.8 17.1 68.6-29 10.4-65.3 17.6-109.6 17.6s-80.6-7.2-109.6-17.6zM425 36.2c-8.4 15.3-32.6 41.2-76.1 60.2-3.4-20.9-9-45.9-17.3-68.1-5.8-15.6-13.1-30.3-22.2-41.2-9.1-11-20.9-19-35.3-19-10.7 0-20.9 3.7-29.3 7.1-7.5 3-15.8 5.3-20.7 5.3s-13.1-2.2-20.7-5.3c-8.4-3.4-18.6-7.1-29.3-7.1-14.5 0-26.2 8.1-35.3 19-9.1 11-16.4 25.7-22.2 41.2-8.3 22.2-13.9 47.2-17.3 68.1-43.6-19-67.7-44.9-76.1-60.2-2.1-3.9-7-5.3-10.9-3.2S6.9 40 9 43.8c10.5 19.3 38.5 48.3 87 68.6L96 144c0 70.7 57.3 128 128 128s128-57.3 128-128l0-31.6c48.5-20.3 76.5-49.3 87-68.6 2.1-3.9 .7-8.7-3.2-10.9s-8.7-.7-10.9 3.2zm-89 84.2l0 23.6c0 61.9-50.1 112-112 112S112 205.9 112 144l0-23.5 .2-1.9C142.5 129 179.6 136 224 136s81.5-7 111.8-17.4l.2 1.8zM16 496c0-88.4 71.6-160 160-160l96 0c88.4 0 160 71.6 160 160l0 8c0 4.4 3.6 8 8 8s8-3.6 8-8l0-8c0-97.2-78.8-176-176-176l-96 0C78.8 320 0 398.8 0 496l0 8c0 4.4 3.6 8 8 8s8-3.6 8-8l0-8z"]],
    "bookmark-plus": [384, 512, [], "e755", ["M16 56c0-22.1 17.9-40 40-40l272 0c22.1 0 40 17.9 40 40l0 442.3-164.2-92.8c-7.3-4.1-16.3-4.1-23.6 0L16 498.3 16 56zm88 152c0 4.4 3.6 8 8 8l72 0 0 72c0 4.4 3.6 8 8 8s8-3.6 8-8l0-72 72 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-72 0 0-72c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 72-72 0c-4.4 0-8 3.6-8 8z", "M56 0C25.1 0 0 25.1 0 56L0 498.3c0 12.3 13.2 20 23.9 13.9l164.2-92.8c2.4-1.4 5.4-1.4 7.9 0l164.2 92.8c10.7 6 23.9-1.7 23.9-13.9L384 56c0-30.9-25.1-56-56-56L56 0zM16 56c0-22.1 17.9-40 40-40l272 0c22.1 0 40 17.9 40 40l0 442.3-164.2-92.8c-7.3-4.1-16.3-4.1-23.6 0L16 498.3 16 56zm176 64c-4.4 0-8 3.6-8 8l0 72-72 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l72 0 0 72c0 4.4 3.6 8 8 8s8-3.6 8-8l0-72 72 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-72 0 0-72c0-4.4-3.6-8-8-8z"]],
    "person-military-to-person": [512, 512, [], "e54c", ["M48 256c0-16.7 8.5-31.4 21.5-40L194 303.9c-.6 .1-1.3 .1-2 .1L64 304c-8.8 0-16-7.2-16-16l0-32zM64 41.2c0-3.4 2.5-6.2 5.9-6.7L192 18.3 192 48 70.7 48C67 48 64 45 64 41.2zM80 96c0-5.6 1-11 2.7-16 30.2 0 60.4 0 90.5 0 1.8 5 2.7 10.4 2.7 16 0 26.5-21.5 48-48 48S80 122.5 80 96zm7.1 112.8c2.9-.5 5.9-.8 8.9-.8l64 0c26.5 0 48 21.5 48 48l0 32c0 1.9-.3 3.8-1 5.5l-120-84.7zM304 256c0-26.5 21.5-48 48-48l64 0c26.5 0 48 21.5 48 48l0 32c0 8.8-7.2 16-16 16l-128 0c-8.8 0-16-7.2-16-16l0-32zM432 96a48 48 0 1 1 -96 0 48 48 0 1 1 96 0z", "M69.9 34.6C66.5 35 64 37.9 64 41.2 64 45 67 48 70.7 48L192 48 192 18.3 69.9 34.6zM48 41.2c0-11.4 8.4-21 19.7-22.5L189.9 2.4C199.5 1.1 208 8.6 208 18.3L208 48c0 8.8-7.2 16-16 16L70.7 64C58.2 64 48 53.8 48 41.2zM432 96a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM304 256l0 32c0 8.8 7.2 16 16 16l128 0c8.8 0 16-7.2 16-16l0-32c0-26.5-21.5-48-48-48l-64 0c-26.5 0-48 21.5-48 48zM384 32a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM352 192l64 0c35.3 0 64 28.7 64 64l0 32c0 17.7-14.3 32-32 32l-128 0c-17.7 0-32-14.3-32-32l0-32c0-35.3 28.7-64 64-64zM64 96c0-5.5 .7-10.9 2-16l16.7 0c-1.8 5-2.7 10.4-2.7 16 0 26.5 21.5 48 48 48s48-21.5 48-48c0-5.6-1-11-2.7-16L190 80c1.3 5.1 2 10.5 2 16 0 35.3-28.7 64-64 64S64 131.3 64 96zM48 256l0 32c0 8.8 7.2 16 16 16l128 0c.7 0 1.3 0 2-.1L69.5 216C56.5 224.6 48 239.3 48 256zm48-48c-3.1 0-6 .3-8.9 .8l120 84.7c.6-1.7 1-3.6 1-5.5l0-32c0-26.5-21.5-48-48-48l-64 0zM32 256c0-35.3 28.7-64 64-64l64 0c35.3 0 64 28.7 64 64l0 32c0 17.7-14.3 32-32 32L64 320c-17.7 0-32-14.3-32-32l0-32zM138 362.7c2.9-3.3 8-3.6 11.3-.7l72 64c1.7 1.5 2.7 3.7 2.7 6s-1 4.5-2.7 6l-72 64c-3.3 2.9-8.4 2.6-11.3-.7s-2.6-8.4 .7-11.3L195 440 8 440c-4.4 0-8-3.6-8-8s3.6-8 8-8l187 0-56.3-50c-3.3-2.9-3.6-8-.7-11.3zm224.7-.7c3.3-2.9 8.4-2.6 11.3 .7s2.6 8.4-.7 11.3l-56.3 50 187 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-187 0 56.3 50c3.3 2.9 3.6 8 .7 11.3s-8 3.6-11.3 .7l-72-64c-1.7-1.5-2.7-3.7-2.7-6s1-4.5 2.7-6l72-64z"]],
    "image-music": [640, 512, [], "e770", ["M80 96c0-26.5 21.5-48 48-48l320 0c26.5 0 48 21.5 48 48l0 107.1c-20.3 4.2-40.7 8.5-61.1 12.7-24.7 5.1-43.6 24.1-49.2 47.8L364 224.5c-5.6-10.2-16.4-16.5-28-16.5s-22.3 6.3-28 16.5l-35.8 64.5-26.5-24.5c-6.9-6.4-16.2-9.4-25.5-8.3s-17.6 6.2-22.8 14l-64 96c-6.5 9.8-7.2 22.4-1.6 32.9S148.2 416 160 416l151.2 0c-16 11.9-28.8 28-35 48L128 464c-26.5 0-48-21.5-48-48L80 96zm64 64a48 48 0 1 0 96 0 48 48 0 1 0 -96 0z", "M448 48L128 48c-26.5 0-48 21.5-48 48l0 320c0 26.5 21.5 48 48 48l148.2 0c-1.6 5.1-2.8 10.4-3.4 16L128 480c-35.3 0-64-28.7-64-64L64 96c0-35.3 28.7-64 64-64l320 0c35.3 0 64 28.7 64 64l0 103.8-16 3.3 0-107.1c0-26.5-21.5-48-48-48zM364 224.5l21.8 39.2c-1.1 4.8-1.7 9.8-1.7 14.9l0 14.9-34-61.2c-2.8-5.1-8.2-8.2-14-8.2s-11.2 3.2-14 8.2l-40.8 73.4c-1.2 2.1-3.3 3.6-5.7 4s-4.9-.4-6.7-2l-34-31.4c-3.4-3.2-8.1-4.7-12.7-4.1s-8.8 3.1-11.4 7l-64 96c-3.3 4.9-3.6 11.2-.8 16.4s8.2 8.5 14.1 8.5l180.9 0c-10.6 3.9-20.7 9.3-29.7 16L160 416c-11.8 0-22.6-6.5-28.2-16.9s-5-23 1.6-32.9l64-96c5.2-7.8 13.5-12.9 22.8-14s18.6 1.9 25.5 8.3l26.5 24.5 35.8-64.5c5.6-10.2 16.4-16.5 28-16.5s22.3 6.3 28 16.5zM192 192a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm0-80a48 48 0 1 1 0 96 48 48 0 1 1 0-96zM640 241.7l0 218.3c0 28.7-28.6 52-64 52s-64-23.3-64-52 28.6-52 64-52c19.1 0 36.3 6.8 48 17.6l0-103.9-176 36.7 0 133.6c0 28.7-28.6 52-64 52s-64-23.3-64-52 28.6-52 64-52c19.1 0 36.3 6.8 48 17.6l0-179.2c0-7.6 5.3-14.1 12.7-15.7l176-36.7c9.9-2.1 19.3 5.5 19.3 15.7zm-16 63.7l0-63.7-176 36.7 0 63.7 176-36.7zM384 455.9c-29.7 0-48 19-48 36s18.3 36 48 36 48-19 48-36-18.3-36-48-36zm240 4c0-17-18.3-36-48-36s-48 19-48 36 18.3 36 48 36 48-19 48-36z"]],
    "person-pinball": [512, 512, [], "e21d", ["M104 24a40 40 0 1 1 -80 0 40 40 0 1 1 80 0zm72 254.6l320-61 0 150.4-320 0 0-89.4zM384-16l112 0 0 210.5-105.4-110.8c-4.2-4.5-6.6-10.4-6.6-16.5L384-16z", "M505.6-31.8c3.6 .8 6.4 4 6.4 7.8l0 560c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-152-320 0 0 152c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-261.8-73.3-119.9C79.7 142.9 67.4 136 54.1 136 33.1 136 16 153.1 16 174.1l0 103.4c0 14.8 5.9 29.1 16.4 39.6l42.5 42.5 4.8 5.3C90.2 377.7 96 393.8 96 410.5L96 536c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-125.5c0-13-4.5-25.5-12.7-35.5l-3.7-4.1-42.5-42.5C7.6 314.9 0 296.6 0 277.5L0 174.1c0-29.9 24.2-54.1 54.1-54.1 18.9 0 36.4 9.8 46.2 25.9L171.9 263.1 482.8 203.9 379 94.8c-7.1-7.4-11-17.3-11-27.6l0-91.2 .2-1.6c.7-3.6 4-6.4 7.8-6.4l128 0 1.6 .2zM176 278.6l0 89.4 320 0 0-150.4-320 61zM384 67.2c0 6.2 2.4 12.1 6.6 16.5L496 194.5 496-16 384-16 384 67.2zM64 80A56 56 0 1 1 64-32 56 56 0 1 1 64 80zm0-96a40 40 0 1 0 0 80 40 40 0 1 0 0-80z"]],
    "mouse-field": [512, 512, [], "e5a8", ["M367.3 256l98.6 0c17.2 0 31.2-14 31.2-31.2 0-40.9-21.8-76.7-54.5-96.3 17.8-11.7 29.6-31.8 29.6-54.7 0-36.1-29.3-65.3-65.3-65.3-19.9 0-37.7 8.9-49.7 22.9-15-14.2-35.3-22.9-57.6-22.9-46.3 0-83.9 37.6-83.9 83.9l0 1.5c0 35.3 21.7 67 54.7 79.7l8.7 3.4-14.6 0c-88.4 0-160 71.6-160 160l0 7c0 35.3 28.7 64 64 64l199.6 0c12.8 0 23.3-10.4 23.3-23.3 0-10.1-6.5-19.1-16.2-22.1l-49-15.7 41.1-90.8z", "M402.7 16.2C390.6 17.4 379.6 22.4 371 30l0 0c-.6 .5-1.1 1-1.6 1.5 14.1 16.2 22.7 37.3 22.7 60.5l0 12.6 .8 .1c17 1.2 32.9 5.9 47.2 13.4 1.8-1.2 3.5-2.6 5.1-4l0 0c2.9-2.6 5.5-5.4 7.9-8.5 .9-1.2 1.7-2.4 2.5-3.6 5.5-8.6 8.6-18.9 8.6-29.9 0-30.9-25.1-56-56-56-1.8 0-3.5 .1-5.3 .2zM408 0c39.8 0 72 32.2 72 72 0 2.7-.1 5.3-.4 8-1.2 10.9-4.8 21.1-10.3 29.9-3.7 6-8.3 11.5-13.6 16.1l0 0c-.4 .3-.8 .7-1.2 1 30.1 21.8 49.6 57.3 49.6 97 0 22.1-17.9 39.9-39.9 39.9l-90.9 0-35.8 78.8 40.8 12.5c13 4 21.9 16 21.9 29.6 0 17.1-13.9 31-31 31L56 416c-22.1 0-40 17.9-40 40s17.9 40 40 40l416 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L56 512c-30.9 0-56-25.1-56-56s25.1-56 56-56l66.7 0C106.4 386.8 96 366.6 96 344l0-8c0-87.3 66.6-159 151.7-167.2-24.3-14.8-39.7-41.5-39.7-70.8l0-6c0-50.8 41.2-92 92-92 21.9 0 42 7.6 57.8 20.4 .8-.8 1.7-1.6 2.6-2.4l0 0c3.8-3.4 8-6.4 12.5-8.9 10.4-5.8 22.4-9.1 35.1-9.1zM328 88c4.4 0 8 3.6 8 8l0 32c0 4.4-3.6 8-8 8l-32 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l24 0 0-24c0-4.4 3.6-8 8-8zm88 88a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM112 344c0 30.9 25.1 56 56 56l201 0c8.3 0 15-6.7 15-15 0-6.6-4.3-12.4-10.6-14.3l-87.8-27c-4.2-1.3-6.6-5.8-5.3-10s5.8-6.6 10-5.3l31.6 9.7 38.8-85.4c1.3-2.9 4.1-4.7 7.3-4.7l96.1 0c13.2 0 23.9-10.7 23.9-23.9 0-54.4-42.1-99.6-96.4-103.5l-8.2-.6c-4.2-.3-7.4-3.8-7.4-8l0-20c0-42-34-76-76-76s-76 34-76 76l0 6c0 28.8 18.4 54.4 45.8 63.5l20.7 6.9c3.7 1.2 6 5 5.4 8.9s-4 6.7-7.9 6.7l-24 0c-83.9 0-152 68.1-152 152l0 8z"]],
    "table-cells-column-lock": [640, 512, [], "e678", ["M80 192l0 224c0 26.5 21.5 48 48 48l80 0 0-272-128 0zm144 0l0 272 128 0 0-272-128 0zm144 0l0 175.9c0-35.5 19.3-66.6 48-83.2l0-28.7c0-23.8 7.4-45.9 20.1-64L368 192z", "M128 48l320 0c26.5 0 48 21.5 48 48l0 52.6c5.2-1.5 10.5-2.7 16-3.5L512 96c0-35.3-28.7-64-64-64L128 32C92.7 32 64 60.7 64 96l0 320c0 35.3 28.7 64 64 64l241.3 0c-.9-5.2-1.3-10.5-1.3-16l0-272 68.1 0c4-5.8 8.6-11.1 13.5-16L80 176 80 96c0-26.5 21.5-48 48-48zM80 192l128 0 0 272-80 0c-26.5 0-48-21.5-48-48l0-224zM224 464l0-272 128 0 0 272-128 0zM576 256.1l0 63.9-96 0 0-63.9c0-26.5 21.5-48 48-48s48 21.5 48 48zM432 368c0-17.7 14.3-32 32-32l0 .1 128 0 0-.1c17.7 0 32 14.3 32 32l0 96c0 17.7-14.3 32-32 32l-128 0c-17.7 0-32-14.3-32-32l0-96zM592 256.1c0-35.3-28.7-64-64-64s-64 28.7-64 64l0 63.9c-26.5 0-48 21.5-48 48l0 96c0 26.5 21.5 48 48 48l128 0c26.5 0 48-21.5 48-48l0-96c0-26.5-21.5-48-48-48l0-63.9z"]],
    "truck-field-un": [640, 512, [], "e58e", ["M16 160l0 96c0 8.8 7.2 16 16 16l0-128c-8.8 0-16 7.2-16 16zM48 96l0 240c0 13.4 8.3 24.9 20 29.7 11.2-35.7 44.6-61.7 84-61.7 40.3 0 74.2 27.1 84.7 64l163.3 0 0-272c0-26.5-21.5-48-48-48L96 48C69.5 48 48 69.5 48 96zm72 48c0-4.4 3.6-8 8-8s8 3.6 8 8l0 64c0 13.3 10.7 24 24 24s24-10.7 24-24l0-64c0-4.4 3.6-8 8-8s8 3.6 8 8l0 64c0 22.1-17.9 40-40 40s-40-17.9-40-40l0-64zm128 0c0-3.5 2.3-6.6 5.7-7.7s7 .3 9 3.2l49.3 74 0-69.6c0-4.4 3.6-8 8-8s8 3.6 8 8l0 96c0 3.5-2.3 6.6-5.7 7.7s-7-.3-9-3.2l-49.3-74 0 69.6c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-96zm168 80l0 117.4c15.9-22.6 42.2-37.4 72-37.4 39.4 0 72.8 25.9 84 61.7 11.7-4.7 20-16.2 20-29.7l0-80c0-17.7-14.3-32-32-32l-144 0z", "M96 48C69.5 48 48 69.5 48 96l0 240c0 13.4 8.3 24.9 20 29.7 11.2-35.7 44.6-61.7 84-61.7 40.3 0 74.2 27.1 84.7 64l163.3 0 0-272c0-26.5-21.5-48-48-48L96 48zM32 336l0-48c-17.7 0-32-14.3-32-32l0-96c0-17.7 14.3-32 32-32l0-32c0-35.3 28.7-64 64-64l256 0c35.3 0 64 28.7 64 64l32.6 0c22.2 0 42.4 13.2 51.3 33.6l34.3 78.4 25.8 0c26.5 0 48 21.5 48 48l0 80c0 21.1-13.7 39.1-32.6 45.5 .4 3.4 .6 7 .6 10.5 0 48.6-39.4 88-88 88s-88-39.4-88-88c0-2.7 .1-5.4 .4-8l-160.7 0c.2 2.6 .4 5.3 .4 8 0 48.6-39.4 88-88 88s-88-39.4-88-88c0-3.6 .2-7.1 .6-10.5-19-6.4-32.6-24.4-32.6-45.5zm0-192c-8.8 0-16 7.2-16 16l0 96c0 8.8 7.2 16 16 16l0-128zM416 341.4c15.9-22.6 42.2-37.4 72-37.4 39.4 0 72.8 25.9 84 61.7 11.7-4.7 20-16.2 20-29.7l0-80c0-17.7-14.3-32-32-32l-144 0 0 117.4zM416 208l100.8 0-31.5-72c-6.4-14.6-20.8-24-36.6-24l-32.6 0 0 96zM152 464a72 72 0 1 0 0-144 72 72 0 1 0 0 144zm408-72a72 72 0 1 0 -144 0 72 72 0 1 0 144 0zM262.7 139.6l49.3 74 0-69.6c0-4.4 3.6-8 8-8s8 3.6 8 8l0 96c0 3.5-2.3 6.6-5.7 7.7s-7-.3-9-3.2l-49.3-74 0 69.6c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-96c0-3.5 2.3-6.6 5.7-7.7s7 .3 9 3.2zM136 144l0 64c0 13.3 10.7 24 24 24s24-10.7 24-24l0-64c0-4.4 3.6-8 8-8s8 3.6 8 8l0 64c0 22.1-17.9 40-40 40s-40-17.9-40-40l0-64c0-4.4 3.6-8 8-8s8 3.6 8 8z"]],
    "clock": [512, 512, [128339, "clock-four"], "f017", ["M496 256a240 240 0 1 1 -480 0 240 240 0 1 1 480 0zM248 104l0 152c0 2.7 1.3 5.2 3.6 6.7l96 64c3.7 2.5 8.6 1.5 11.1-2.2s1.5-8.6-2.2-11.1L264 251.7 264 104c0-4.4-3.6-8-8-8s-8 3.6-8 8z", "M496 256a240 240 0 1 1 -480 0 240 240 0 1 1 480 0zM0 256a256 256 0 1 0 512 0 256 256 0 1 0 -512 0zM248 104l0 152c0 2.7 1.3 5.2 3.6 6.7l96 64c3.7 2.5 8.6 1.5 11.1-2.2s1.5-8.6-2.2-11.1L264 251.7 264 104c0-4.4-3.6-8-8-8s-8 3.6-8 8z"]],
    "layer-minus": [512, 512, ["layer-group-minus"], "f5fe", ["M16 224c0-3.1 1.8-6 4.6-7.3l218.6-101c10.6-4.9 22.9-4.9 33.6 0l218.6 101c2.8 1.3 4.6 4.1 4.6 7.3s-1.8 6-4.6 7.3l-218.6 101c-10.6 4.9-22.9 4.9-33.6 0L20.6 231.2c-2.8-1.3-4.6-4.1-4.6-7.3zm0 160c0-3.1 1.8-6 4.6-7.3l81.1-37.5c36.9 17 73.8 34.1 110.6 51.1 27.7 12.8 59.6 12.8 87.3 0 36.9-17 73.8-34.1 110.6-51.1l81.1 37.5c2.8 1.3 4.6 4.1 4.6 7.3s-1.8 6-4.6 7.3l-218.6 101c-10.6 4.9-22.9 4.9-33.6 0L20.6 391.2c-2.8-1.3-4.6-4.1-4.6-7.3z", "M360 40l144 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L360 56c-4.4 0-8-3.6-8-8s3.6-8 8-8zm-87.2 75.7c-10.6-4.9-22.9-4.9-33.6 0L20.6 216.7C17.8 218 16 220.9 16 224s1.8 6 4.6 7.3l-6.7 14.5C5.4 241.8 0 233.3 0 224s5.4-17.9 13.9-21.8l218.6-101c14.9-6.9 32.1-6.9 47 0l218.6 101c8.5 3.9 13.9 12.4 13.9 21.8s-5.4 17.9-13.9 21.8l-218.6 101c-14.9 6.9-32.1 6.9-47 0l-218.6-101 6.7-14.5 218.6 101c10.6 4.9 22.9 4.9 33.6 0l218.6-101c2.8-1.3 4.6-4.1 4.6-7.3s-1.8-6-4.6-7.3l-218.6-101zM82.7 330.4l19.1 8.8-81.1 37.5C17.8 378 16 380.9 16 384s1.8 6 4.6 7.3l218.6 101c10.6 4.9 22.9 4.9 33.6 0l218.6-101c2.8-1.3 4.6-4.1 4.6-7.3s-1.8-6-4.6-7.3l-81.1-37.5 19.1-8.8 68.7 31.8c8.5 3.9 13.9 12.4 13.9 21.8s-5.4 17.9-13.9 21.8l-218.6 101c-14.9 6.9-32.1 6.9-47 0L13.9 405.8C5.4 401.8 0 393.3 0 384s5.4-17.9 13.9-21.8l68.7-31.8z"]],
    "circle-euro": [512, 512, [], "e5ce", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zm104-32c0-4.4 3.6-8 8-8l29.7 0c17.1-51.1 65.3-88 122.2-88l41 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-41 0c-47.9 0-88.8 29.9-105.2 72l73.3 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-78.1 0c-1.8 8-2.7 16.3-2.7 24.8 0 8 .8 15.7 2.4 23.2l78.4 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-73.8 0c15.9 42.9 57.3 73.5 105.7 73.5l41 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-41 0c-57.4 0-106.1-37.6-122.7-89.5L128 296c-4.4 0-8-3.6-8-8s3.6-8 8-8l25.2 0c-1.4-7.5-2.1-15.3-2.1-23.2 0-8.5 .8-16.7 2.4-24.8L128 232c-4.4 0-8-3.6-8-8z", "M496 256a240 240 0 1 0 -480 0 240 240 0 1 0 480 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm153.5-24L128 232c-4.4 0-8-3.6-8-8s3.6-8 8-8l29.7 0c17.1-51.1 65.3-88 122.2-88l41 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-41 0c-47.9 0-88.8 29.9-105.2 72l73.3 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-78.1 0c-1.8 8-2.7 16.3-2.7 24.8 0 8 .8 15.7 2.4 23.2l78.4 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-73.8 0c15.9 42.9 57.3 73.5 105.7 73.5l41 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-41 0c-57.4 0-106.1-37.6-122.7-89.5L128 296c-4.4 0-8-3.6-8-8s3.6-8 8-8l25.2 0c-1.4-7.5-2.1-15.3-2.1-23.2 0-8.5 .8-16.7 2.4-24.8z"]],
    "book": [448, 512, [128212], "f02d", ["M16 56l0 360.8C26.2 406.4 40.3 400 56 400l352 0c13.3 0 24-10.7 24-24l0-336c0-13.3-10.7-24-24-24L56 16C33.9 16 16 33.9 16 56zm112 80c0-4.4 3.6-8 8-8l208 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-208 0c-4.4 0-8-3.6-8-8zm0 96c0-4.4 3.6-8 8-8l208 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-208 0c-4.4 0-8-3.6-8-8z", "M0 56C0 25.1 25.1 0 56 0L408 0c22.1 0 40 17.9 40 40l0 336c0 19.4-13.7 35.5-32 39.2l0 80.8 24 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L56 512c-30.9 0-56-25.1-56-56L0 56zM56 416c-22.1 0-40 17.9-40 40s17.9 40 40 40l344 0 0-80-344 0zm-40 .8C26.2 406.4 40.3 400 56 400l352 0c13.3 0 24-10.7 24-24l0-336c0-13.3-10.7-24-24-24L56 16C33.9 16 16 33.9 16 56l0 360.8zM136 128l208 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-208 0c-4.4 0-8-3.6-8-8s3.6-8 8-8zm0 96l208 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-208 0c-4.4 0-8-3.6-8-8s3.6-8 8-8z"]],
    "face-laugh-wink": [512, 512, ["laugh-wink"], "f59c", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zm85.6 58c-3.7-13.7 7.5-26 21.7-26l265.4 0c14.2 0 25.4 12.3 21.7 26-18.5 68-80.6 118-154.4 118S120 382 101.6 314zM192 192a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm80 24c0-30.9 25.1-56 56-56l16 0c30.9 0 56 25.1 56 56 0 4.4-3.6 8-8 8s-8-3.6-8-8c0-22.1-17.9-40-40-40l-16 0c-22.1 0-40 17.9-40 40 0 4.4-3.6 8-8 8s-8-3.6-8-8z", "M496 256a240 240 0 1 0 -480 0 240 240 0 1 0 480 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zM256 416c66.4 0 122.4-45 139-106.2 .4-1.3 .1-2.4-.8-3.5-1.1-1.2-3-2.3-5.4-2.3l-265.4 0c-2.4 0-4.4 1.1-5.4 2.3-.9 1.1-1.2 2.2-.8 3.5 16.6 61.2 72.6 106.2 139 106.2zM123.3 288l265.4 0c14.2 0 25.4 12.3 21.7 26-18.5 68-80.6 118-154.4 118S120 382 101.6 314c-3.7-13.7 7.5-26 21.7-26zM160 192a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm128 24c0 4.4-3.6 8-8 8s-8-3.6-8-8c0-30.9 25.1-56 56-56l16 0c30.9 0 56 25.1 56 56 0 4.4-3.6 8-8 8s-8-3.6-8-8c0-22.1-17.9-40-40-40l-16 0c-22.1 0-40 17.9-40 40z"]],
    "transducer": [384, 512, [], "e826", ["M16 448l0 48c0 17.7 14.3 32 32 32l48 0 0-112-48 0c-17.7 0-32 14.3-32 32zM80 112l0 288 224 0 0-288c0-17.7-14.3-32-32-32L112 80c-17.7 0-32 14.3-32 32zm32 304l0 112 160 0 0-112-160 0zm176 0l0 112 48 0c17.7 0 32-14.3 32-32l0-48c0-17.7-14.3-32-32-32l-48 0z", "M248-32c4.4 0 8 3.6 8 8l0 88 16 0c26.5 0 48 21.5 48 48l0 288 16 0c26.5 0 48 21.5 48 48l0 48c0 26.5-21.5 48-48 48L48 544C23.1 544 2.7 525.1 .2 500.9L0 496 0 448c0-26.5 21.5-48 48-48l16 0 0-288c0-26.5 21.5-48 48-48l16 0 0-88c0-4.4 3.6-8 8-8s8 3.6 8 8l0 88 96 0 0-88c0-4.4 3.6-8 8-8zM48 416c-17.7 0-32 14.3-32 32l0 48c0 17.7 14.3 32 32 32l48 0 0-112-48 0zm64 112l160 0 0-112-160 0 0 112zm176 0l48 0c17.7 0 32-14.3 32-32l0-48c0-17.7-14.3-32-32-32l-48 0 0 112zM112 80c-17.7 0-32 14.3-32 32l0 288 224 0 0-288c0-17.7-14.3-32-32-32L112 80z"]],
    "user-doctor-hair-long": [448, 512, [], "e459", ["M9.4 511.9c44.9 .1 89.8 .1 134.6 .1-30.9 0-56-25.1-56-56 0-28.2 20.9-51.6 48-55.4l0-59.5C67 358.8 16 421.4 16 496l0 8c0 4-2.9 7.2-6.6 7.9zM29.6 398.2c14.7-21.9 34.1-40.4 56.9-53.8-23.6 12.4-43.3 31.1-56.9 53.8zM72 251.6c0 2.4 2 4.4 4.4 4.4l85.6 0c-25.9-14.3-46.2-37.4-57.1-65.2-3.4 10-7.9 19.5-13.5 28.5L72.7 249.2c-.4 .7-.7 1.5-.7 2.4zM104 456c0 22.1 17.9 40 40 40s40-17.9 40-40-17.9-40-40-40-40 17.9-40 40zm9.1-344l79.6 0c18.6 0 36.7-5.9 51.8-16.8L305.3 51c-20.4-21.5-49.3-35-81.3-35-56.4 0-103.1 41.7-110.9 96zM144 512l294 0c-3.4-1.1-6-4.3-6-8l0-8c0-74.6-51-137.2-120-155l0 59.5c27.1 3.9 48 27.2 48 55.4l0 40c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-40c0-22.1-17.9-40-40-40s-40 17.9-40 40l0 40c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-40c0-28.2 20.9-51.6 48-55.4l0-62.8c-7.8-1.2-15.8-1.8-24-1.8l-96 0c-8.2 0-16.2 .6-24 1.8l0 62.8c27.1 3.9 48 27.2 48 55.4 0 30.9-25.1 56-56 56zM286 256l85.5 0c2.5 0 4.4-2 4.4-4.4 0-.8-.2-1.6-.7-2.4l-18.7-29.8c-5.6-9-10.1-18.6-13.5-28.5-10.9 27.8-31.3 50.8-57.1 65.2zm81.2 92c16.8 10.8 31.7 24.4 43.9 40.3-11.7-16.3-26.6-30-43.9-40.3z", "M224 16c-56.4 0-103.1 41.7-110.9 96l79.6 0c18.6 0 36.7-5.9 51.8-16.8L305.3 51C284.9 29.4 256 16 224 16zm30 92.1C236.2 121 214.8 128 192.8 128l-80.8 0 0 16c0 61.9 50.1 112 112 112s112-50.1 112-112l0-16c0-24.1-7.6-46.4-20.5-64.6L254 108.1zM96 128C96 57.3 153.3 0 224 0S352 57.3 352 128l0 19.3c0 22.5 6.3 44.5 18.2 63.6l18.7 29.8c2 3.2 3.1 7 3.1 10.8 0 11.3-9.1 20.4-20.4 20.4L76.4 272c-11.3 0-20.4-9.1-20.4-20.4 0-3.8 1.1-7.6 3.1-10.8l18.7-29.8C89.7 191.8 96 169.8 96 147.3L96 128zm8.8 62.8c-3.4 10-7.9 19.5-13.5 28.5L72.7 249.2c-.4 .7-.7 1.5-.7 2.4 0 2.4 2 4.4 4.4 4.4l85.6 0c-25.9-14.3-46.2-37.4-57.1-65.2zM286 256l85.5 0c2.5 0 4.4-2 4.4-4.4 0-.8-.2-1.6-.7-2.4l0 0-18.7-29.8c-5.6-9-10.1-18.6-13.5-28.5-10.9 27.8-31.3 50.8-57.1 65.2zM16 496l0 8c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-8c0-97.2 78.8-176 176-176l96 0c97.2 0 176 78.8 176 176l0 8c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-8c0-74.6-51-137.2-120-155l0 59.5c27.1 3.9 48 27.2 48 55.4l0 40c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-40c0-22.1-17.9-40-40-40s-40 17.9-40 40l0 40c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-40c0-28.2 20.9-51.6 48-55.4l0-62.8c-7.8-1.2-15.8-1.8-24-1.8l-96 0c-8.2 0-16.2 .6-24 1.8l0 62.8c27.1 3.9 48 27.2 48 55.4 0 30.9-25.1 56-56 56s-56-25.1-56-56c0-28.2 20.9-51.6 48-55.4l0-59.5C67 358.8 16 421.4 16 496zm168-40c0-22.1-17.9-40-40-40s-40 17.9-40 40 17.9 40 40 40 40-17.9 40-40z"]],
    "cloud-meatball": [512, 512, [], "f73b", ["M16 224c0-37.7 26.1-69.4 61.3-77.8 2.1-.5 3.9-1.8 5-3.7s1.4-4.1 .9-6.1c-2-7.8-3.1-16-3.1-24.4 0-53 43-96 96-96 41.3 0 76.6 26.1 90.1 62.8 1.1 2.9 3.7 4.9 6.8 5.2s6.1-1.3 7.6-4c11.1-19.2 31.8-32 55.5-32 35.3 0 64 28.7 64 64 0 7.8-1.4 15.2-3.9 22.1-1 2.6-.5 5.6 1.3 7.8s4.6 3.3 7.3 2.9c3.7-.5 7.5-.8 11.3-.8 44.2 0 80 35.8 80 80s-35.8 80-80 80l-33.9 0c-3.7-6.5-8.1-12.3-13-17.2-13.4-13.4-33.6-23.6-56.8-22.9-15.9-16.9-37.5-24-56.4-24s-40.4 7.1-56.4 24c-23.2-.7-43.4 9.6-56.8 22.9-4.9 4.9-9.3 10.7-13 17.2L96 304c-44.2 0-80-35.8-80-80z", "M176 0c-61.9 0-112 50.1-112 112 0 7.1 .7 14.1 1.9 20.8-38.3 12.6-65.9 48.7-65.9 91.2 0 53 43 96 96 96l27 0c1.7-5.7 4-11.1 6.8-16L96 304c-44.2 0-80-35.8-80-80 0-37.7 26.1-69.4 61.3-77.8 2.1-.5 3.9-1.8 5-3.7s1.4-4.1 .9-6.1c-2-7.8-3.1-16-3.1-24.4 0-53 43-96 96-96 41.3 0 76.6 26.1 90.1 62.8 1.1 2.9 3.7 4.9 6.8 5.2s6.1-1.3 7.6-4c11.1-19.2 31.8-32 55.5-32 35.3 0 64 28.7 64 64 0 7.8-1.4 15.2-3.9 22.1-1 2.6-.5 5.6 1.3 7.8s4.6 3.3 7.3 2.9c3.7-.5 7.5-.8 11.3-.8 44.2 0 80 35.8 80 80s-35.8 80-80 80l-33.8 0c2.8 4.9 5.1 10.3 6.8 16l27 0c53 0 96-43 96-96s-43-96-96-96c-.5 0-1.1 0-1.6 0 1.1-5.2 1.6-10.5 1.6-16 0-44.2-35.8-80-80-80-24.3 0-46.1 10.9-60.8 28-18.7-35.7-56.1-60-99.2-60zM16 400a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm80 0a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zm336 0a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm80 0a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM245 309.4c2.3-3.4 6.4-5.4 11-5.4s8.8 2 11 5.4c9.9 14.9 27.8 22.3 45.3 18.8 4-.8 8.3 .7 11.6 4s4.8 7.6 4 11.6c-3.5 17.5 3.9 35.4 18.8 45.3 3.4 2.3 5.4 6.4 5.4 11s-2 8.8-5.4 11c-14.9 9.9-22.3 27.8-18.8 45.3 .8 4-.7 8.3-4 11.6s-7.6 4.8-11.6 4c-17.5-3.5-35.4 3.9-45.3 18.8-2.3 3.4-6.4 5.4-11 5.4s-8.8-2-11-5.4c-9.9-14.9-27.8-22.3-45.3-18.8-4 .8-8.3-.7-11.6-4s-4.8-7.6-4-11.6c3.5-17.5-3.9-35.4-18.8-45.3-3.4-2.3-5.4-6.4-5.4-11s2-8.8 5.4-11c14.9-9.9 22.3-27.8 18.8-45.3-.8-4 .7-8.3 4-11.6s7.6-4.8 11.6-4c17.5 3.5 35.4-3.9 45.3-18.8zm35.3-8.9C274.6 291.9 265 288 256 288s-18.6 4-24.3 12.5c-6.3 9.5-17.7 14.2-28.8 11.9-10.1-2-19.7 1.9-26.1 8.3s-10.4 16-8.3 26.1c2.2 11.1-2.5 22.5-11.9 28.8-8.6 5.7-12.5 15.3-12.5 24.3s4 18.6 12.5 24.3c9.5 6.3 14.2 17.7 11.9 28.8-2 10.1 1.9 19.7 8.3 26.1s16 10.4 26.1 8.3c11.1-2.2 22.5 2.5 28.8 11.9 5.7 8.6 15.3 12.5 24.3 12.5s18.6-4 24.3-12.5c6.3-9.5 17.7-14.2 28.8-11.9 10.1 2 19.7-1.9 26.1-8.3s10.4-16 8.3-26.1c-2.2-11.1 2.5-22.5 11.9-28.8 8.6-5.7 12.5-15.3 12.5-24.3s-4-18.6-12.5-24.3c-9.5-6.3-14.2-17.7-11.9-28.8 2-10.1-1.9-19.7-8.3-26.1s-16-10.4-26.1-8.3c-11.1 2.2-22.5-2.5-28.8-11.9z"]],
    "cloud-xmark": [576, 512, [], "e35f", ["M16 336c0 70.7 57.3 128 128 128l304 0c61.9 0 112-50.1 112-112 0-48-30.2-89-72.8-104.9-2.3-.8-4-2.7-4.8-5s-.4-4.8 .9-6.8c8-12.5 12.7-27.3 12.7-43.2 0-44.2-35.8-80-80-80-17.6 0-33.8 5.7-47 15.2-2 1.4-4.4 1.9-6.8 1.3s-4.3-2.3-5.2-4.5c-19.9-44.8-64.8-76-117-76-70.7 0-128 57.3-128 128 0 9.4 1 18.6 2.9 27.4 .9 4.1-1.6 8.3-5.7 9.4-53.8 15.1-93.3 64.6-93.3 123.2zM222.8 222.8c3.1-3.1 8.2-3.1 11.3 0l53.8 53.8 53.8-53.8c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3l-53.8 53.8 53.8 53.8c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-53.8-53.8-53.8 53.8c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l53.8-53.8-53.8-53.8c-3.1-3.1-3.1-8.2 0-11.3z", "M240 32c-79.5 0-144 64.5-144 144 0 8 .7 15.9 1.9 23.5-56.9 19.2-97.9 73-97.9 136.5 0 79.5 64.5 144 144 144l304 0c70.7 0 128-57.3 128-128 0-51.6-30.5-96.1-74.5-116.3 6.7-13.1 10.5-28 10.5-43.7 0-53-43-96-96-96-17.7 0-34.2 4.8-48.4 13.1-24.1-45.8-72.2-77.1-127.6-77.1zM112 176c0-70.7 57.3-128 128-128 52.2 0 97.1 31.2 117 76 1 2.2 2.9 3.9 5.2 4.5s4.8 .2 6.8-1.3c13.2-9.6 29.4-15.2 47-15.2 44.2 0 80 35.8 80 80 0 15.9-4.7 30.8-12.7 43.2-1.3 2-1.6 4.6-.9 6.8s2.5 4.1 4.8 5C529.8 263 560 304 560 352 560 413.9 509.9 464 448 464l-304 0c-70.7 0-128-57.3-128-128 0-58.6 39.5-108.1 93.3-123.2 4.1-1.1 6.6-5.3 5.7-9.4-1.9-8.8-2.9-18-2.9-27.4zM222.8 341.8c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l53.8-53.8 53.8 53.8c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-53.8-53.8 53.8-53.8c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0l-53.8 53.8-53.8-53.8c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l53.8 53.8-53.8 53.8z"]],
    "chart-area": [512, 512, ["area-chart"], "f1fe", ["M112 250.9L112 360c0 4.4 3.6 8 8 8l336 0c4.4 0 8-3.6 8-8l0-144c0-2.1-.8-4.2-2.3-5.7l-64-64c-3.1-3.1-8.2-3.1-11.3 0l-46.3 46.3c-3.1 3.1-7.3 4.8-11.7 4.7s-8.5-2-11.4-5.2l-71.1-77.5c-1.5-1.7-3.7-2.6-5.9-2.6s-4.4 .9-5.9 2.6l-120 130.9c-1.4 1.5-2.1 3.4-2.1 5.4z", "M16 40c0-4.4-3.6-8-8-8s-8 3.6-8 8L0 400c0 44.2 35.8 80 80 80l424 0c4.4 0 8-3.6 8-8s-3.6-8-8-8L80 464c-35.3 0-64-28.7-64-64L16 40zM317 192.1c2.9 3.2 7.1 5.1 11.4 5.2s8.6-1.6 11.7-4.7l46.3-46.3c3.1-3.1 8.2-3.1 11.3 0l64 64c1.5 1.5 2.3 3.5 2.3 5.7l0 144c0 4.4-3.6 8-8 8l-336 0c-4.4 0-8-3.6-8-8l0-109.1c0-2 .8-3.9 2.1-5.4l120-130.9c1.5-1.7 3.7-2.6 5.9-2.6s4.4 .9 5.9 2.6L317 192.1zM480 216c0-6.4-2.5-12.5-7-17l-64-64c-9.4-9.4-24.6-9.4-33.9 0-27.2 27.2-42.7 42.7-46.3 46.3l-10.8-11.8-60.2-65.7c-4.5-5-11-7.8-17.7-7.8s-13.1 2.8-17.7 7.8l-120 130.9c-4.1 4.4-6.3 10.2-6.3 16.2L96 360c0 13.3 10.7 24 24 24l336 0c13.3 0 24-10.7 24-24l0-144z"]],
    "utility-pole-double": [512, 512, [], "e2c4", ["", "M256 0c4.4 0 8 3.6 8 8l0 88 144 0 0-56c0-4.4 3.6-8 8-8s8 3.6 8 8l0 56 23.9 0c.1 0 .2 0 .3 0l47.9 0 0-56c0-4.4 3.6-8 8-8s8 3.6 8 8l0 64c0 4.4-3.6 8-8 8l-53.7 0-186.3 116.4 0 59.6 144 0 0-40c0-4.4 3.6-8 8-8s8 3.6 8 8l0 40 72 0 0-40c0-4.4 3.6-8 8-8s8 3.6 8 8l0 48c0 4.4-3.6 8-8 8l-53.7 0-186.3 116.4 0 83.6c0 4.4-3.6 8-8 8s-8-3.6-8-8L248 420.4 61.7 304 8 304c-4.4 0-8-3.6-8-8l0-48c0-4.4 3.6-8 8-8s8 3.6 8 8l0 40 72 0 0-40c0-4.4 3.6-8 8-8s8 3.6 8 8l0 40 144 0 0-59.6-186.3-116.4-53.7 0c-4.4 0-8-3.6-8-8L0 40c0-4.4 3.6-8 8-8s8 3.6 8 8l0 56 47.9 0c.1 0 .2 0 .3 0L88 96 88 40c0-4.4 3.6-8 8-8s8 3.6 8 8l0 56 144 0 0-88c0-4.4 3.6-8 8-8zm-8 112L91.9 112 248 209.6 248 112zm16 97.6l156.1-97.6-156.1 0 0 97.6zM248 304L91.9 304 248 401.6 248 304zm16 97.6l156.1-97.6-156.1 0 0 97.6z"]],
    "rupiah-sign": [512, 512, [], "e23d", ["", "M0 40c0-4.4 3.6-8 8-8l112 0c75.1 0 136 60.9 136 136 0 63.6-43.7 117-102.6 131.9l46.4 170c1.2 4.3-1.4 8.7-5.6 9.8s-8.7-1.4-9.8-5.6L137.6 302.9c-5.8 .7-11.6 1.1-17.6 1.1l-104 0 0 168c0 4.4-3.6 8-8 8s-8-3.6-8-8L0 40zM16 288l104 0c66.3 0 120-53.7 120-120S186.3 48 120 48L16 48 16 288zm288-24l0 168 96 0c53 0 96-43 96-96s-43-96-96-96l-72 0c-13.3 0-24 10.7-24 24zm96 184l-96 0 0 88c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-272c0-22.1 17.9-40 40-40l72 0c61.9 0 112 50.1 112 112S461.9 448 400 448z"]],
    "diagram-nested": [448, 512, [], "e157", ["M16 80l0 96c0 17.7 14.3 32 32 32l96 0c17.7 0 32-14.3 32-32l0-96c0-17.7-14.3-32-32-32L48 48C30.3 48 16 62.3 16 80zM272 336l0 96c0 17.7 14.3 32 32 32l96 0c17.7 0 32-14.3 32-32l0-96c0-17.7-14.3-32-32-32l-96 0c-17.7 0-32 14.3-32 32z", "M144 48c17.7 0 32 14.3 32 32l0 96c0 17.7-14.3 32-32 32l-96 0c-17.7 0-32-14.3-32-32l0-96c0-17.7 14.3-32 32-32l96 0zM48 32C21.5 32 0 53.5 0 80l0 96c0 26.5 21.5 48 48 48l40 0 0 96c0 39.8 32.2 72 72 72l96 0 0 40c0 26.5 21.5 48 48 48l96 0c26.5 0 48-21.5 48-48l0-96c0-26.5-21.5-48-48-48l-96 0c-26.5 0-48 21.5-48 48l0 40-96 0c-30.9 0-56-25.1-56-56l0-96 40 0c26.5 0 48-21.5 48-48l0-96c0-26.5-21.5-48-48-48L48 32zM400 304c17.7 0 32 14.3 32 32l0 96c0 17.7-14.3 32-32 32l-96 0c-17.7 0-32-14.3-32-32l0-96c0-17.7 14.3-32 32-32l96 0z"]],
    "square-quarters": [448, 512, [], "e44e", ["M16 96l0 320c0 10.4 3.3 20 8.9 27.8L212.7 256 24.9 68.2C19.3 76 16 85.6 16 96zM235.3 256L423.1 443.8c5.6-7.8 8.9-17.4 8.9-27.8l0-320c0-10.4-3.3-20-8.9-27.8L235.3 256z", "M64 48c-10.4 0-20 3.3-27.8 8.9L224 244.7 411.8 56.9C404 51.3 394.4 48 384 48L64 48zM24.9 68.2C19.3 76 16 85.6 16 96l0 320c0 10.4 3.3 20 8.9 27.8L212.7 256 24.9 68.2zM36.2 455.1C44 460.7 53.6 464 64 464l320 0c10.4 0 20-3.3 27.8-8.9L224 267.3 36.2 455.1zm386.9-11.3c5.6-7.8 8.9-17.4 8.9-27.8l0-320c0-10.4-3.3-20-8.9-27.8L235.3 256 423.1 443.8zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96z"]],
    "print-slash": [576, 512, [], "f686", ["M251.4 208l192 192 68.6 0c8.8 0 16-7.2 16-16l0-128c0-26.5-21.5-48-48-48l-228.6 0z", "M2.3-29.8c3.1-3.1 8.2-3.1 11.3 0L112 68.6 112 64c0-35.3 28.7-64 64-64L357.5 0c17 0 33.3 6.7 45.3 18.7l42.5 42.5c12 12 18.7 28.3 18.7 45.3l0 37.5-16 0 0-37.5c0-12.7-5.1-24.9-14.1-33.9L391.4 30.1c-9-9-21.2-14.1-33.9-14.1L176 16c-26.5 0-48 21.5-48 48L128 84.6 235.4 192 480 192c35.3 0 64 28.7 64 64l0 128c0 17.7-14.3 32-32 32l-52.6 0 114.2 114.2c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L2.3-18.4c-3.1-3.1-3.1-8.2 0-11.3zM443.4 400l68.6 0c8.8 0 16-7.2 16-16l0-128c0-26.5-21.5-48-48-48l-228.6 0 192 192zM304.8 352L144 352c-8.8 0-16 7.2-16 16l0 112c0 8.8 7.2 16 16 16l288 0c4.6 0 8.8-2 11.7-5.1L455 502.2c-5.8 6-14 9.8-23 9.8l-288 0c-17.7 0-32-14.3-32-32l0-64-48 0c-17.7 0-32-14.3-32-32l0-128c0-35.3 28.7-64 64-64l48.8 0 16 16-64.8 0c-26.5 0-48 21.5-48 48l0 128c0 8.8 7.2 16 16 16l48 0 0-32c0-17.7 14.3-32 32-32l144.8 0 16 16zM456 268a12 12 0 1 1 24 0 12 12 0 1 1 -24 0z"]],
    "shield-keyhole": [512, 512, [], "e248", ["M32 139.9c.5 96.6 40.3 270.2 204.6 348.8 12.3 5.9 26.7 5.9 39 0 164.2-78.6 204-252.2 204.5-348.8 .1-19.1-11.9-35.3-28.5-42.4l-176.7-75c-12-5.1-25.5-5.1-37.5 0L60.6 97.5c-16.6 7.1-28.6 23.2-28.5 42.4zM208 208c0-26.5 21.5-48 48-48s48 21.5 48 48c0 23.8-17.3 43.5-40 47.3l0 72.7c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-72.7c-22.7-3.8-40-23.6-40-47.3z", "M237.3 22.6c12-5.1 25.5-5.1 37.5 0l176.7 75c16.6 7.1 28.6 23.2 28.5 42.4-.5 96.6-40.3 270.2-204.5 348.8-12.3 5.9-26.7 5.9-39 0-164.2-78.6-204.1-252.2-204.6-348.8-.1-19.1 11.9-35.3 28.5-42.4l176.7-75zM281.1 7.8c-16-6.8-34-6.8-50 0L54.3 82.8c-22 9.3-38.4 31-38.3 57.2 .5 99.2 41.3 280.7 213.6 363.2 16.7 8 36.1 8 52.8 0 172.4-82.5 213.1-264 213.6-363.2 .1-26.2-16.3-47.9-38.3-57.2L281.1 7.8zM256 176a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm48 32c0-26.5-21.5-48-48-48s-48 21.5-48 48c0 23.8 17.3 43.5 40 47.3l0 72.7c0 4.4 3.6 8 8 8s8-3.6 8-8l0-72.7c22.7-3.8 40-23.6 40-47.3z"]],
    "square-left": [448, 512, [11013, "arrow-alt-square-left"], "f351", ["M16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96zM95 239l88-88c6.9-6.9 17.2-8.9 26.2-5.2S224 158.3 224 168l0 40 104 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24l-104 0 0 40c0 9.7-5.8 18.5-14.8 22.2s-19.3 1.7-26.2-5.2L95 273c-9.4-9.4-9.4-24.6 0-33.9z", "M16 416c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96l0 320zm48 64c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480zm42.3-218.3l88 88c2.3 2.3 5.7 3 8.7 1.7s4.9-4.2 4.9-7.4l0-48c0-4.4 3.6-8 8-8l112 0c4.4 0 8-3.6 8-8l0-48c0-4.4-3.6-8-8-8l-112 0c-4.4 0-8-3.6-8-8l0-48c0-3.2-1.9-6.2-4.9-7.4s-6.4-.6-8.7 1.7l-88 88c-3.1 3.1-3.1 8.2 0 11.3zM95 239l88-88c6.9-6.9 17.2-8.9 26.2-5.2S224 158.3 224 168l0 40 104 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24l-104 0 0 40c0 9.7-5.8 18.5-14.8 22.2s-19.3 1.7-26.2-5.2L95 273c-9.4-9.4-9.4-24.6 0-33.9z"]],
    "text-width": [448, 512, [], "f035", ["", "M40 0C17.9 0 0 17.9 0 40l0 80c0 4.4 3.6 8 8 8s8-3.6 8-8l0-80c0-13.3 10.7-24 24-24l176 0 0 256-80 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l176 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-80 0 0-256 176 0c13.3 0 24 10.7 24 24l0 80c0 4.4 3.6 8 8 8s8-3.6 8-8l0-80c0-22.1-17.9-40-40-40L40 0zm61.7 365.7c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0l-88 88c-3.1 3.1-3.1 8.2 0 11.3l88 88c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-74.3-74.3 393.4 0-74.3 74.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l88-88c3.1-3.1 3.1-8.2 0-11.3l-88-88c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l74.3 74.3-393.4 0 74.3-74.3z"]],
    "circle-currency": [512, 512, [], "e6ee", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zM146.3 146.3c3.1-3.1 8.2-3.1 11.3 0L194 182.7c16.7-14.2 38.4-22.7 62-22.7s45.3 8.5 62 22.7l36.4-36.4c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3L329.3 194c14.2 16.7 22.7 38.4 22.7 62s-8.5 45.3-22.7 62l36.4 36.4c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L318 329.3c-16.7 14.2-38.4 22.7-62 22.7s-45.3-8.5-62-22.7l-36.4 36.4c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3L182.7 318c-14.2-16.7-22.7-38.4-22.7-62s8.5-45.3 22.7-62l-36.4-36.4c-3.1-3.1-3.1-8.2 0-11.3zM176 256a80 80 0 1 0 160 0 80 80 0 1 0 -160 0z", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM146.3 146.3c-3.1 3.1-3.1 8.2 0 11.3L182.7 194c-14.2 16.7-22.7 38.4-22.7 62s8.5 45.3 22.7 62l-36.4 36.4c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L194 329.3c16.7 14.2 38.4 22.7 62 22.7s45.3-8.5 62-22.7l36.4 36.4c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3L329.3 318c14.2-16.7 22.7-38.4 22.7-62s-8.5-45.3-22.7-62l36.4-36.4c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0L318 182.7c-16.7-14.2-38.4-22.7-62-22.7s-45.3 8.5-62 22.7l-36.4-36.4c-3.1-3.1-8.2-3.1-11.3 0zM256 176a80 80 0 1 1 0 160 80 80 0 1 1 0-160z"]],
    "signature-lock": [576, 512, [], "e3ca", ["M368 368c0-17.7 14.3-32 32-31.9l112 0c5.3 0 10.7 0 16-.1 17.7 0 32 14.3 32 32l0 96c0 17.7-14.3 32-32 32l-128 0c-17.7 0-32-14.3-32-32l0-96z", "M64 120c0-39.8 32.2-72 72-72s72 32.2 72 72l0 15.9c0 25.1-1.9 50.2-5.6 74.9L81.7 250C52.1 259.7 32 287.3 32 318.5l0 108.6c0 29.2 23.7 52.9 52.9 52.9 19.6 0 37.6-10.8 46.8-28.2l27-51c21.8-41.2 37.9-85 48-130.5l4.8-21.8c1.9-8.5 3.6-17 5-25.5l124.9-40.6-68.3 109.4c-1.5 2.5-1.6 5.6-.2 8.1s4.1 4.1 7 4.1l48.4 0c2.4-2.7 4.9-5.2 7.6-7.6l0-8.4-41.6 0 72.3-115.8c1.8-2.9 1.6-6.5-.5-9.2s-5.6-3.7-8.8-2.7L219.3 205.3c3.1-23 4.7-46.2 4.7-69.4l0-15.9c0-48.6-39.4-88-88-88S48 71.4 48 120l0 40c0 4.4 3.6 8 8 8s8-3.6 8-8l0-40zM226.7 368c-2.1 5.4-4.4 10.7-6.7 16l83.9 0 0-16-77.3 0zM86.7 265.2l112.7-36.6c-1 5.5-2.2 11-3.4 16.4l-4.8 21.8c-9.8 44.1-25.5 86.6-46.6 126.5l-27 51c-6.4 12.1-19 19.7-32.6 19.7-20.4 0-36.9-16.5-36.9-36.9l0-108.6c0-24.3 15.6-45.8 38.7-53.3zM512 256.1l0 63.9-96 0 0-63.9c0-26.5 21.5-48 48-48s48 21.5 48 48zM368 368c0-17.7 14.3-32 32-32l0 .1 128 0 0-.1c17.7 0 32 14.3 32 32l0 96c0 17.7-14.3 32-32 32l-128 0c-17.7 0-32-14.3-32-32l0-96zM528 256.1c0-35.3-28.7-64-64-64s-64 28.7-64 64l0 63.9c-26.5 0-48 21.5-48 48l0 96c0 26.5 21.5 48 48 48l128 0c26.5 0 48-21.5 48-48l0-96c0-26.5-21.5-48-48-48l0-63.9z"]],
    "satellite": [512, 512, [128752], "f7bf", ["M13.1 254.4c28.2-19.2 62.3-30.4 98.9-30.4 20.9 0 40.9 3.6 59.5 10.3 49.5 17.8 88.7 57 106.3 106.6 6.6 18.5 10.2 38.4 10.2 59.1 0 36.7-11.2 70.8-30.4 98.9L13.1 254.4zM186.5 223L372.7 36.7c6.2-6.2 16.4-6.2 22.6 0l80 80c6.2 6.2 6.2 16.4 0 22.6L289.1 325.6c-19.4-46.2-56.4-83.2-102.6-102.6z", "M210.4 18.3l-96 96c-3.1 3.1-3.1 8.2 0 11.3L187.8 199 295.1 91.7 221.7 18.3c-3.1-3.1-8.2-3.1-11.3 0zm-33.9 192L103.1 137c-9.4-9.4-9.4-24.6 0-33.9l96-96c9.4-9.4 24.6-9.4 33.9 0l73.4 73.4 55-55 0 0c12.5-12.5 32.8-12.5 45.3 0l80 80c12.5 12.5 12.5 32.8 0 45.3l0 0-55 55 73.4 73.4c9.4 9.4 9.4 24.6 0 33.9l-96 96c-9.4 9.4-24.6 9.4-33.9 0l-73.4-73.4-6.5 6.5c5.8 18.3 8.9 37.7 8.9 57.9 0 40.6-12.6 78.3-34.2 109.4-5.2 7.5-16.1 8.3-23 1.5l-117.2-117.2-68 68c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l68-68-117.2-117.2c-6.8-6.8-6-17.7 1.5-23 31-21.5 68.7-34.2 109.4-34.2 20.2 0 39.6 3.1 57.9 8.9l6.5-6.5zm10 12.6c46.2 19.4 83.2 56.4 102.6 102.6l186.3-186.3 0 0c6.2-6.2 6.2-16.4 0-22.6l-80-80c-6.2-6.2-16.4-6.2-22.6 0L186.5 223zM313 324.3l73.4 73.4c3.1 3.1 8.2 3.1 11.3 0l96-96c3.1-3.1 3.1-8.2 0-11.3L420.3 217 313 324.3zM13.1 254.4L257.6 498.9c19.2-28.2 30.4-62.2 30.4-98.9 0-97.2-78.8-176-176-176-36.7 0-70.8 11.2-98.9 30.4z"]],
    "ball-pile": [576, 512, [], "f77e", ["M16 432a64 64 0 1 0 128 0 64 64 0 1 0 -128 0zm96-184a64 64 0 1 0 128 0 64 64 0 1 0 -128 0zM224 80a64 64 0 1 0 128 0 64 64 0 1 0 -128 0zm0 352a64 64 0 1 0 128 0 64 64 0 1 0 -128 0zM336 248a64 64 0 1 0 128 0 64 64 0 1 0 -128 0zm96 184a64 64 0 1 0 128 0 64 64 0 1 0 -128 0z", "M80 512a80 80 0 1 1 0-160 80 80 0 1 1 0 160zm208 0a80 80 0 1 1 0-160 80 80 0 1 1 0 160zm208 0a80 80 0 1 1 0-160 80 80 0 1 1 0 160zM80 368a64 64 0 1 0 0 128 64 64 0 1 0 0-128zm208 0a64 64 0 1 0 0 128 64 64 0 1 0 0-128zm208 0a64 64 0 1 0 0 128 64 64 0 1 0 0-128zM176 328a80 80 0 1 1 0-160 80 80 0 1 1 0 160zm224 0a80 80 0 1 1 0-160 80 80 0 1 1 0 160zm0-144a64 64 0 1 0 0 128 64 64 0 1 0 0-128zm-224 0a64 64 0 1 0 0 128 64 64 0 1 0 0-128zm112-24a80 80 0 1 1 0-160 80 80 0 1 1 0 160zm0-144a64 64 0 1 0 0 128 64 64 0 1 0 0-128z"]],
    "seats": [512, 512, [], "e765", ["M16 304c0-17.7 14.3-32 32-32l416 0c17.7 0 32 14.3 32 32l0 48c0 17.7-14.3 32-32 32L48 384c-17.7 0-32-14.3-32-32l0-48zM48 64c0-26.5 21.5-48 48-48l104 0c26.5 0 48 21.5 48 48l0 192-200 0 0-192zm216 0c0-26.5 21.5-48 48-48l104 0c26.5 0 48 21.5 48 48l0 192-200 0 0-192z", "M96 16C69.5 16 48 37.5 48 64l0 192 200 0 0-192c0-26.5-21.5-48-48-48L96 16zM464 256l0-192c0-26.5-21.5-48-48-48L312 16c-26.5 0-48 21.5-48 48l0 192 200 0zm16 0l0 2.7c18.6 6.6 32 24.4 32 45.3l0 48c0 20.9-13.4 38.7-32 45.3L480 504c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-104-200 0 0 104c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-104-200 0 0 104c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-106.7C13.4 390.7 0 372.9 0 352l0-48c0-20.9 13.4-38.7 32-45.3L32 64C32 28.7 60.7 0 96 0L200 0c24.1 0 45.1 13.3 56 33 10.9-19.7 31.9-33 56-33L416 0c35.3 0 64 28.7 64 64l0 192zM16 304l0 48c0 17.7 14.3 32 32 32l416 0c17.7 0 32-14.3 32-32l0-48c0-17.7-14.3-32-32-32L48 272c-17.7 0-32 14.3-32 32z"]],
    "file-eps": [576, 512, [], "e644", ["M48 64c0-26.5 21.5-48 48-48l133.5 0c3.6 0 7.1 .4 10.5 1.2L240 120c0 30.9 25.1 56 56 56l102.8 0c.8 3.4 1.2 6.9 1.2 10.5l0 149.5-176 0c-26.5 0-48 21.5-48 48l0 112-80 0c-26.5 0-48-21.5-48-48L48 64z", "M96 16l133.5 0c3.6 0 7.1 .4 10.5 1.2L240 120c0 30.9 25.1 56 56 56l102.8 0c.8 3.4 1.2 6.9 1.2 10.5l0 149.5 16 0 0-149.5c0-17-6.7-33.3-18.7-45.3L274.7 18.7C262.7 6.7 246.5 0 229.5 0L96 0C60.7 0 32 28.7 32 64l0 384c0 35.3 28.7 64 64 64l80 0 0-16-80 0c-26.5 0-48-21.5-48-48L48 64c0-26.5 21.5-48 48-48zM392 160l-96 0c-22.1 0-40-17.9-40-40l0-96c2.7 1.8 5.1 3.8 7.4 6.1L385.9 152.6c2.3 2.3 4.3 4.8 6.1 7.4zM240 400c-4.4 0-8 3.6-8 8l0 128c0 4.4 3.6 8 8 8l64 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-56 0 0-48 40 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-40 0 0-48 56 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-64 0zm128 0c-4.4 0-8 3.6-8 8l0 128c0 4.4 3.6 8 8 8s8-3.6 8-8l0-40 24 0c26.5 0 48-21.5 48-48s-21.5-48-48-48l-32 0zm32 80l-24 0 0-64 24 0c17.7 0 32 14.3 32 32s-14.3 32-32 32zm88-40c0 22.1 17.9 40 40 40 13.3 0 24 10.7 24 24s-10.7 24-24 24l-32 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l32 0c22.1 0 40-17.9 40-40s-17.9-40-40-40c-13.3 0-24-10.7-24-24s10.7-24 24-24l24 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-24 0c-22.1 0-40 17.9-40 40z"]],
    "magnifying-glass-minus": [512, 512, ["search-minus"], "f010", ["M16 208a192 192 0 1 0 384 0 192 192 0 1 0 -384 0zm96 0c0-4.4 3.6-8 8-8l176 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-176 0c-4.4 0-8-3.6-8-8z", "M208 16a192 192 0 1 1 0 384 192 192 0 1 1 0-384zm0 400c54.6 0 104.2-21 141.3-55.4l149 149c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-149-149C395 312.2 416 262.6 416 208 416 93.1 322.9 0 208 0S0 93.1 0 208 93.1 416 208 416zM120 200c-4.4 0-8 3.6-8 8s3.6 8 8 8l176 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-176 0z"]],
    "vent-damper": [640, 512, [], "e465", ["M16 192l0 128c0 8.8 7.2 16 16 16l32 0 0-160-32 0c-8.8 0-16 7.2-16 16zm64-64l0 256c0 26.5 21.5 48 48 48l384 0c26.5 0 48-21.5 48-48l0-256c0-26.5-21.5-48-48-48L128 80c-26.5 0-48 21.5-48 48zm80 40c0-4.4 3.6-8 8-8l304 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-304 0c-4.4 0-8-3.6-8-8zm0 88c0-4.4 3.6-8 8-8l304 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-304 0c-4.4 0-8-3.6-8-8zm0 88c0-4.4 3.6-8 8-8l304 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-304 0c-4.4 0-8-3.6-8-8zM576 176l0 160 32 0c8.8 0 16-7.2 16-16l0-128c0-8.8-7.2-16-16-16l-32 0z", "M512 80c26.5 0 48 21.5 48 48l0 256c0 26.5-21.5 48-48 48l-384 0c-26.5 0-48-21.5-48-48l0-256c0-26.5 21.5-48 48-48l384 0zM64 128l0 32-32 0c-17.7 0-32 14.3-32 32L0 320c0 17.7 14.3 32 32 32l32 0 0 32c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-32 32 0c17.7 0 32-14.3 32-32l0-128c0-17.7-14.3-32-32-32l-32 0 0-32c0-35.3-28.7-64-64-64L128 64c-35.3 0-64 28.7-64 64zm0 48l0 160-32 0c-8.8 0-16-7.2-16-16l0-128c0-8.8 7.2-16 16-16l32 0zM608 336l-32 0 0-160 32 0c8.8 0 16 7.2 16 16l0 128c0 8.8-7.2 16-16 16zM168 160c-4.4 0-8 3.6-8 8s3.6 8 8 8l304 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-304 0zm0 88c-4.4 0-8 3.6-8 8s3.6 8 8 8l304 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-304 0zm0 88c-4.4 0-8 3.6-8 8s3.6 8 8 8l304 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-304 0z"]],
    "people-group": [512, 512, [], "e533", ["M168 280c0-45.9 35.2-83.6 80.1-87.7 5.2-.4 10.7-.4 15.9 0 44.9 4 80.1 41.7 80.1 87.7l0 24c0 29.4-14.4 55.5-36.7 71.5-2.1 1.5-3.3 3.9-3.3 6.5l0 82c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-82c0-2.6-1.2-5-3.3-6.5-22.2-16-36.7-42.1-36.7-71.5l0-24zM304 64a48 48 0 1 1 -96 0 48 48 0 1 1 96 0z", "M304 64a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM192 64a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zM96 128a40 40 0 1 0 0-80 40 40 0 1 0 0 80zm0-96a56 56 0 1 1 0 112 56 56 0 1 1 0-112zm320 96a40 40 0 1 0 0-80 40 40 0 1 0 0 80zm0-96a56 56 0 1 1 0 112 56 56 0 1 1 0-112zM16 296c0 26.1 11.3 49.5 29.3 65.6 1.7 1.5 2.7 3.7 2.7 6L48 472c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-101c-19.7-18.9-32-45.6-32-75 0-57.4 46.6-104 104-104 7.3 0 14.5 .8 21.4 2.2-2.9 4.8-5.5 9.7-7.8 14.8-4.4-.7-9-1-13.6-1-48.6 0-88 39.4-88 88zm378.4-87c-2.3-5.1-4.9-10.1-7.8-14.8 6.9-1.4 14.1-2.2 21.4-2.2 57.4 0 104 46.6 104 104 0 29.5-12.3 56.1-32 75l0 101c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-104.4c0-2.3 1-4.4 2.7-6 18-16.1 29.3-39.5 29.3-65.6 0-48.6-39.4-88-88-88-4.6 0-9.2 .4-13.6 1zM256 192c-48.6 0-88 39.4-88 88l0 24c0 29.4 14.4 55.5 36.7 71.5 2.1 1.5 3.3 3.9 3.3 6.5l0 82c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-82c0-2.6 1.2-5 3.3-6.5 22.2-16 36.7-42.1 36.7-71.5l0-24c0-48.6-39.4-88-88-88zM152 280c0-57.4 46.6-104 104-104s104 46.6 104 104l0 24c0 33.3-15.7 63-40 82l0 78c0 26.5-21.5 48-48 48l-32 0c-26.5 0-48-21.5-48-48l0-78c-24.3-19-40-48.7-40-82l0-24z"]],
    "square-quote": [448, 512, [], "e329", ["M16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96zM96 208c0-26.5 21.5-48 48-48l16 0c26.5 0 48 21.5 48 48l0 78.4c0 27.9-20.5 51.5-48.1 55.4l-14.8 2.1c-4.4 .6-8.4-2.4-9.1-6.8s2.4-8.4 6.8-9l14.8-2.1c19.7-2.8 34.3-19.7 34.3-39.6l0-26.6c-8.5 7.6-19.7 12.2-32 12.2l-16 0c-26.5 0-48-21.5-48-48l0-16zm16 0l0 16c0 17.7 14.3 32 32 32l16 0c17.7 0 32-14.3 32-32l0-16c0-17.7-14.3-32-32-32l-16 0c-17.7 0-32 14.3-32 32zm128 0c0-26.5 21.5-48 48-48l16 0c26.5 0 48 21.5 48 48l0 78.4c0 27.9-20.5 51.5-48.1 55.4l-14.8 2.1c-4.4 .6-8.4-2.4-9.1-6.8s2.4-8.4 6.8-9l14.8-2.1c19.7-2.8 34.3-19.7 34.3-39.6l0-26.6c-8.5 7.6-19.7 12.2-32 12.2l-16 0c-26.5 0-48-21.5-48-48l0-16zm16 0l0 16c0 17.7 14.3 32 32 32l16 0c17.7 0 32-14.3 32-32l0-16c0-17.7-14.3-32-32-32l-16 0c-17.7 0-32 14.3-32 32z", "M384 48c26.5 0 48 21.5 48 48l0 320c0 26.5-21.5 48-48 48L64 464c-26.5 0-48-21.5-48-48L16 96c0-26.5 21.5-48 48-48l320 0zM64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm80 224c-17.7 0-32-14.3-32-32l0-16c0-17.7 14.3-32 32-32l16 0c17.7 0 32 14.3 32 32l0 16c0 17.7-14.3 32-32 32l-16 0zm64-40l0-8c0-26.5-21.5-48-48-48l-16 0c-26.5 0-48 21.5-48 48l0 16c0 26.5 21.5 48 48 48l16 0c12.3 0 23.5-4.6 32-12.2l0 26.6c0 19.9-14.6 36.8-34.3 39.6l-14.8 2.1c-4.4 .6-7.4 4.7-6.8 9s4.7 7.4 9.1 6.8l14.8-2.1c27.6-3.9 48.1-27.6 48.1-55.4l0-70.4zm80 40c-17.7 0-32-14.3-32-32l0-16c0-17.7 14.3-32 32-32l16 0c17.7 0 32 14.3 32 32l0 16c0 17.7-14.3 32-32 32l-16 0zm64-40l0-8c0-26.5-21.5-48-48-48l-16 0c-26.5 0-48 21.5-48 48l0 16c0 26.5 21.5 48 48 48l16 0c12.3 0 23.5-4.6 32-12.2l0 26.6c0 19.9-14.6 36.8-34.3 39.6l-14.8 2.1c-4.4 .6-7.4 4.7-6.8 9s4.7 7.4 9.1 6.8l14.8-2.1c27.6-3.9 48.1-27.6 48.1-55.4l0-70.4z"]],
    "square-binary": [448, 512, [], "e69b", ["M16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96zm96 48c0-17.7 14.3-32 32-32l48 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-48 0c-17.7 0-32-14.3-32-32l0-64zm16 0l0 64c0 8.8 7.2 16 16 16l48 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16l-48 0c-8.8 0-16 7.2-16 16zm0 144c0-4.4 3.6-8 8-8l32 0c4.4 0 8 3.6 8 8l0 112c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-104-24 0c-4.4 0-8-3.6-8-8zm96 24c0-17.7 14.3-32 32-32l48 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-48 0c-17.7 0-32-14.3-32-32l0-64zm16 0l0 64c0 8.8 7.2 16 16 16l48 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16l-48 0c-8.8 0-16 7.2-16 16zm16-192c0-4.4 3.6-8 8-8l32 0c4.4 0 8 3.6 8 8l0 112c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-104-24 0c-4.4 0-8-3.6-8-8z", "M384 48c26.5 0 48 21.5 48 48l0 320c0 26.5-21.5 48-48 48L64 464c-26.5 0-48-21.5-48-48L16 96c0-26.5 21.5-48 48-48l320 0zM64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm48 112l0 64c0 17.7 14.3 32 32 32l48 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-48 0c-17.7 0-32 14.3-32 32zm32-16l48 0c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16l0-64c0-8.8 7.2-16 16-16zM256 280c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32l48 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-48 0zm-16 32c0-8.8 7.2-16 16-16l48 0c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16l0-64zM128 288c0 4.4 3.6 8 8 8l24 0 0 104c0 4.4 3.6 8 8 8s8-3.6 8-8l0-112c0-4.4-3.6-8-8-8l-32 0c-4.4 0-8 3.6-8 8zM264 112c-4.4 0-8 3.6-8 8s3.6 8 8 8l24 0 0 104c0 4.4 3.6 8 8 8s8-3.6 8-8l0-112c0-4.4-3.6-8-8-8l-32 0z"]],
    "masks-theater": [640, 512, [127917, "theater-masks"], "f630", ["M240.4 126.6l0 172.1c0 81 50.7 153.4 126.9 181.1l19.1 6.9c19.4 7.1 40.7 7.1 60.1 0l19.1-6.9c76.2-27.7 126.9-100.1 126.9-181.1l0-172.1c0-10.6-3.3-20.2-10.1-26.3-25-22.6-79.5-54.4-165.9-54.4S275.4 77.6 250.5 100.3c-6.8 6.2-10.1 15.7-10.1 26.3zm48.3 181c-1.5-7.7 2.6-14.1 8.3-17 5.5-2.8 12.6-2.5 18.3 1.8 28 21.5 63.1 34.2 101.1 34.2s73.1-12.7 101.1-34.2c5.6-4.3 12.8-4.6 18.3-1.8 5.7 2.9 9.8 9.2 8.3 17-11.8 59.8-64.4 104.9-127.7 104.9S300.4 367.4 288.7 307.6zm15-102.8c7.4-16.9 24.3-28.8 44-28.8s36.6 11.9 44 28.8c1.8 4-.1 8.8-4.1 10.5s-8.8-.1-10.5-4.1c-4.9-11.3-16.2-19.2-29.3-19.2s-24.4 7.9-29.3 19.2c-1.8 4-6.5 5.9-10.5 4.1s-5.9-6.5-4.1-10.5zm137.3 0c7.4-16.9 24.3-28.8 44-28.8s36.6 11.9 44 28.8c1.8 4-.1 8.8-4.1 10.5s-8.8-.1-10.5-4.1C509.4 199.9 498.1 192 485 192s-24.4 7.9-29.3 19.2c-1.8 4-6.5 5.9-10.5 4.1s-5.9-6.5-4.1-10.5z", "M188.1 343.9c1 5.3 2.1 10.5 3.4 15.6l-29.8 5.3c-14 2.5-29.3-8.5-26.2-24.9 5.6-28.9 23.2-54.2 48.4-69.4l0 19.4c-16.9 13-28.6 31.9-32.7 53.1-.4 1.9 .3 3.4 1.6 4.6 1.4 1.2 3.6 2 6.1 1.6l29.2-5.1zm53.4 113.9c4.6 5.5 9.4 10.8 14.4 15.9-8.7 .7-17.6 .3-26.3-1.2l-20-3.5C123.3 453.7 55.6 386 40.3 299.6L9.1 122.7c-1.5-8.7-.5-18.3 5.1-26.4 20.2-29.5 72.8-77.9 168.5-94.8 51.8-9.1 94.9-5.3 128.1 3.5-10.1 3.1-19.6 6.6-28.5 10.4-27-4.2-59.4-4.7-96.8 1.9-91.4 16.1-140.3 62.1-158.1 88.1-2.6 3.8-3.5 9-2.5 14.6L56.1 296.8c14.1 79.8 76.6 142.3 156.4 156.3l20 3.5c3 .5 6.1 .9 9.1 1.1zM184 169.7l0 20.7c-7.1-8.5-18.5-13.1-30.1-11-12.9 2.3-22.7 12-25.6 24-1 4.3-5.4 6.9-9.7 5.9s-6.9-5.4-5.9-9.7c4.3-18 18.9-32.6 38.3-36 11.8-2.1 23.4 .3 32.9 6zm55.7-81.3c27.8-25.2 86.2-58.6 176.7-58.6S565.2 63.2 593 88.4c11.2 10.1 15.3 24.6 15.3 38.2l0 172.1c0 87.8-54.9 166.2-137.4 196.2l-19.1 6.9c-23 8.3-48.1 8.3-71.1 0l-19.1-6.9c-82.5-30-137.4-108.4-137.4-196.2l0-172.1c0-13.6 4.2-28.1 15.3-38.2zM416.4 45.8c-86.4 0-140.9 31.8-165.9 54.4-6.8 6.2-10.1 15.7-10.1 26.3l0 172.1c0 81 50.7 153.4 126.9 181.1l19.1 6.9c19.4 7.1 40.7 7.1 60.1 0l19.1-6.9c76.2-27.7 126.9-100.1 126.9-181.1l0-172.1c0-10.6-3.3-20.2-10.1-26.3-25-22.6-79.5-54.4-165.9-54.4zM347.7 192c-13.1 0-24.4 7.9-29.3 19.2-1.8 4-6.5 5.9-10.5 4.1s-5.9-6.5-4.1-10.5c7.4-16.9 24.3-28.8 44-28.8s36.6 11.9 44 28.8c1.8 4-.1 8.8-4.1 10.5s-8.8-.1-10.5-4.1c-4.9-11.3-16.2-19.2-29.3-19.2zm108 19.2c-1.8 4-6.5 5.9-10.5 4.1s-5.9-6.5-4.1-10.5c7.4-16.9 24.3-28.8 44-28.8s36.6 11.9 44 28.8c1.8 4-.1 8.8-4.1 10.5s-8.8-.1-10.5-4.1C509.4 199.9 498.1 192 485 192s-24.4 7.9-29.3 19.2zM304.5 304.8c10.4 52.3 56.6 91.6 111.9 91.6s101.5-39.4 111.9-91.6c-.1 0-.2 0-.3 0-.2 0-.5 .1-.8 .3-30.7 23.5-69.2 37.5-110.8 37.5s-80.1-14-110.9-37.5c-.3-.2-.6-.3-.8-.3-.1 0-.2 0-.3 0zM297 290.6c5.5-2.8 12.6-2.5 18.3 1.8 28 21.5 63.1 34.2 101.1 34.2s73.1-12.7 101.1-34.2c5.6-4.3 12.8-4.6 18.3-1.8 5.7 2.9 9.8 9.2 8.3 17-11.8 59.8-64.4 104.9-127.7 104.9S300.4 367.4 288.7 307.6c-1.5-7.7 2.6-14.1 8.3-17z"]],
    "house-turret": [576, 512, [], "e1b4", ["M48 248.8L48 456c0 22.1 17.9 40 40 40l240 0c22.1 0 40-17.9 40-40l0-207.2-160-134.4-160 134.4zM160 296c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-48z", "M296 16l56 0 0 72c0 4.4 3.6 8 8 8s8-3.6 8-8l0-72 96 0 0 72c0 4.4 3.6 8 8 8s8-3.6 8-8l0-72 56 0c13.3 0 24 10.7 24 24l0 416c0 22.1-17.9 40-40 40l-96 0c-2.3 5.6-5.1 10.9-8.4 16L520 512c30.9 0 56-25.1 56-56l0-416c0-22.1-17.9-40-40-40L296 0c-22.1 0-40 17.9-40 40l0 31.2 16 13.4 0-44.6c0-13.3 10.7-24 24-24zM213.2 97.9c-3-2.5-7.3-2.5-10.3 0l-200 168c-3.4 2.8-3.8 7.9-1 11.3s7.9 3.8 11.3 1L32 262.3 32 456c0 30.9 25.1 56 56 56l240 0c30.9 0 56-25.1 56-56l0-193.7 18.9 15.8c3.4 2.8 8.4 2.4 11.3-1s2.4-8.4-1-11.3l-200-168zM368 248.8L368 456c0 22.1-17.9 40-40 40L88 496c-22.1 0-40-17.9-40-40l0-207.2 160-134.4 160 134.4zM232 288c4.4 0 8 3.6 8 8l0 48c0 4.4-3.6 8-8 8l-48 0c-4.4 0-8-3.6-8-8l0-48c0-4.4 3.6-8 8-8l48 0zm-48-16c-13.3 0-24 10.7-24 24l0 48c0 13.3 10.7 24 24 24l48 0c13.3 0 24-10.7 24-24l0-48c0-13.3-10.7-24-24-24l-48 0z"]],
    "cart-plus": [640, 512, [], "f217", ["M92.7 31.3l219.3 0 0 56.7-64 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l64 0 0 64c0 4.4 3.6 8 8 8s8-3.6 8-8l0-64 64 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-64 0 0-56.7 240.2 0-.1 .7c-3.7 0-7 2.5-7.8 6.2L518.6 216.4C511 248.9 482 272 448.5 272L139.8 272 92.9 32.3c-.1-.4-.1-.7-.2-1zM240 464a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm224 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm33.7-191.1c17.2-8.6 30.2-24.8 34.2-44.7-6.3 18.6-18.5 34.2-34.2 44.7z", "M0 8C0 3.6 3.6 0 8 0L53.7 0C72.8 0 89.2 13.5 92.9 32.3l46.9 239.7 308.7 0c33.5 0 62.5-23.1 70.1-55.6L560.2 38.2c1-4.3 5.3-7 9.6-6s7 5.3 6 9.6L534.2 220c-9.3 39.8-44.8 68-85.7 68l-305.6 0 9.3 47.7c3.7 18.8 20.1 32.3 39.3 32.3L488 368c4.4 0 8 3.6 8 8s-3.6 8-8 8l-296.5 0c-26.8 0-49.8-19-55-45.2L77.2 35.4C75 24.1 65.1 16 53.7 16L8 16c-4.4 0-8-3.6-8-8zM208 496a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm0-80a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm256 48a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm-80 0a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM320 16c4.4 0 8 3.6 8 8l0 64 64 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-64 0 0 64c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-64-64 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l64 0 0-64c0-4.4 3.6-8 8-8z"]],
    "hands-asl-interpreting": [640, 512, ["american-sign-language-interpreting", "asl-interpreting", "hands-american-sign-language-interpreting"], "f2a3", ["M16 270.4c0 53.9 43.7 97.6 97.6 97.6l94.4 0c1.3 0 2.6-.1 3.9-.3 .2 0 .4-.1 .6-.1 30.5-2.8 56.7-20.5 71.2-45.6 6.6-11.5 2.7-26.2-8.8-32.8s-26.2-2.7-32.8 8.8c-7.7 13.2-21.9 22-38.1 22-24.3 0-44-19.7-44-44s19.7-44 44-44c16.2 0 30.5 8.8 38.1 22 6.6 11.5 21.3 15.4 32.8 8.8s15.4-21.3 8.8-32.8c-11.6-20.1-30.6-35.4-53.4-42.2-3.4-1-5.7-4.1-5.7-7.7s2.3-6.7 5.7-7.7L302.8 151c12.7-3.8 20-17.1 16.2-29.8s-17.1-20-29.8-16.2l-76.1 22.6c-3.5 1-7.3-.5-9.2-3.7s-1.3-7.2 1.4-9.8l59.3-56.7c9.6-9.2 9.9-24.4 .8-33.9s-24.4-9.9-33.9-.8l-88.3 84.5c-2.7 2.6-6.9 3-10 .8s-4.3-6.1-2.9-9.6l20.1-49.3c5-12.3-.9-26.3-13.2-31.3s-26.3 .9-31.3 13.2L23.2 233.6c-4.8 11.7-7.2 24.2-7.2 36.8zM321 390.8c3.8 12.7 17.1 20 29.8 16.2l76.1-22.6c3.5-1 7.3 .5 9.2 3.7s1.3 7.2-1.4 9.8l-59.3 56.7c-9.6 9.2-9.9 24.4-.8 33.9s24.4 9.9 33.9 .8l88.3-84.5c2.7-2.6 6.9-3 10-.8s4.3 6.1 2.9 9.6l-20.1 49.3c-5 12.3 .9 26.3 13.2 31.3s26.3-.9 31.3-13.2l82.6-202.6c4.8-11.7 7.2-24.2 7.2-36.8 0-53.9-43.7-97.6-97.6-97.6L432 144c-1.3 0-2.6 .1-3.9 .3-.2 0-.4 .1-.6 .1-30.5 2.8-56.7 20.4-71.2 45.6-6.6 11.5-2.7 26.2 8.8 32.8s26.2 2.7 32.8-8.8c7.6-13.2 21.9-22 38.1-22 24.3 0 44 19.7 44 44s-19.7 44-44 44c-16.2 0-30.5-8.8-38.1-22-6.6-11.5-21.3-15.4-32.8-8.8s-15.4 21.3-8.8 32.8c11.6 20.1 30.6 35.4 53.4 42.2 3.4 1 5.7 4.1 5.7 7.7s-2.3 6.7-5.7 7.7L337.2 361c-12.7 3.8-20 17.1-16.2 29.8z", "M143.1 3C122.6-5.4 99.3 4.5 91 24.9L8.4 227.6C2.9 241.2 0 255.7 0 270.4 0 333.1 50.9 384 113.6 384l94.4 0c2.1 0 4.1-.2 6.2-.5 35.7-3.3 66.4-24.1 83.4-53.5 10.9-18.8 4.8-42.7-13.6-54 18.3-11.3 24.4-35.3 13.6-54-9.8-16.9-24.1-31-41.2-40.5l51.1-15.1c21.2-6.3 33.3-28.5 27-49.7s-28.5-33.3-49.7-27l-44.4 13.2 35.5-33.9c16-15.3 16.5-40.6 1.3-56.6s-40.6-16.5-56.6-1.3L159.1 69.7 165 55.1c8.3-20.5-1.5-43.8-22-52.1zM228.3 262c3.4 5.9 8.1 10.6 13.5 14-5.4 3.4-10.1 8.1-13.5 14-4.9 8.5-14 14-24.3 14-15.5 0-28-12.5-28-28s12.5-28 28-28c10.3 0 19.4 5.6 24.3 14zM105.8 30.9c5-12.3 19-18.2 31.3-13.2s18.2 19 13.2 31.3L130.1 98.3c-1.4 3.5-.2 7.5 2.9 9.6s7.3 1.8 10-.8l88.3-84.5c9.6-9.2 24.8-8.8 33.9 .8s8.8 24.8-.8 33.9l-59.3 56.7c-2.7 2.6-3.2 6.6-1.4 9.8s5.7 4.7 9.2 3.7L289.2 105c12.7-3.8 26.1 3.5 29.8 16.2s-3.5 26.1-16.2 29.8l-72.5 21.5c-3.4 1-5.7 4.1-5.7 7.7s2.3 6.7 5.7 7.7c22.7 6.8 41.7 22.1 53.4 42.2 6.6 11.5 2.7 26.2-8.8 32.8s-26.2 2.7-32.8-8.8c-7.7-13.2-21.9-22-38.1-22-24.3 0-44 19.7-44 44s19.7 44 44 44c16.2 0 30.5-8.8 38.1-22 6.6-11.5 21.3-15.4 32.8-8.8s15.4 21.3 8.8 32.8c-14.5 25.1-40.7 42.8-71.2 45.6-.2 0-.4 0-.6 .1-1.3 .2-2.6 .3-3.9 .3l-94.4 0c-53.9 0-97.6-43.7-97.6-97.6 0-12.6 2.4-25.1 7.2-36.8L105.8 30.9zM496.9 509c20.5 8.3 43.8-1.5 52.1-22l82.6-202.6c5.5-13.6 8.4-28.2 8.4-42.9 0-62.7-50.9-113.6-113.6-113.6L432 128c-2.1 0-4.1 .2-6.2 .5-35.7 3.3-66.4 24.1-83.4 53.5-10.9 18.8-4.8 42.7 13.6 54-18.3 11.3-24.4 35.3-13.6 54 9.8 16.9 24.1 31 41.2 40.5l-51.1 15.1c-21.2 6.3-33.3 28.5-27 49.7s28.5 33.3 49.7 27l44.4-13.2-35.5 33.9c-16 15.3-16.5 40.6-1.3 56.6s40.6 16.5 56.6 1.3l61.3-58.6-5.9 14.6c-8.3 20.5 1.5 43.8 22 52.1zM411.7 250c-3.4-5.9-8.1-10.6-13.5-14 5.4-3.4 10.1-8.1 13.5-14 4.9-8.5 14-14 24.3-14 15.5 0 28 12.5 28 28s-12.5 28-28 28c-10.3 0-19.4-5.6-24.3-14zM534.2 481.1c-5 12.3-19 18.2-31.3 13.2s-18.2-19-13.2-31.3l20.1-49.3c1.4-3.5 .2-7.5-2.9-9.6s-7.3-1.8-10 .8l-88.3 84.5c-9.6 9.2-24.8 8.8-33.9-.8s-8.8-24.8 .8-33.9l59.3-56.7c2.7-2.6 3.2-6.6 1.4-9.8s-5.7-4.7-9.2-3.7L350.8 407c-12.7 3.8-26.1-3.5-29.8-16.2s3.5-26.1 16.2-29.8l72.5-21.5c3.4-1 5.7-4.1 5.7-7.7s-2.3-6.7-5.7-7.7c-22.7-6.8-41.7-22.1-53.4-42.2-6.6-11.5-2.7-26.2 8.8-32.8s26.2-2.7 32.8 8.8c7.6 13.2 21.9 22 38.1 22 24.3 0 44-19.7 44-44s-19.7-44-44-44c-16.2 0-30.5 8.8-38.1 22-6.6 11.5-21.3 15.4-32.8 8.8s-15.4-21.3-8.8-32.8c14.5-25.2 40.7-42.8 71.2-45.6 .2 0 .4 0 .6-.1 1.3-.2 2.6-.3 3.9-.3l94.4 0c53.9 0 97.6 43.7 97.6 97.6 0 12.6-2.5 25.1-7.2 36.8L534.2 481.1z"]],
    "face-anxious-sweat": [640, 512, [], "e36a", ["M80.4 242.4C87.6 116 192.1 16 320 16 452.5 16 560 123.5 560 256S452.5 496 320 496c-60.1 0-115-22.1-157.1-58.5 8.4-15.8 13.1-34 13.1-53.5 0-32.4-14.1-60-28.4-80.1-14.6-20.5-32.5-37.6-46.8-50.2l-.3-.3c-6-5.2-12.9-8.9-20.1-11zm71.7-33.1c.7 4.4 4.8 7.3 9.2 6.6l2.5-.4c31.2-5.2 60.1-20.1 82.5-42.5l7.4-7.4c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0l-7.4 7.4c-20 20-45.8 33.3-73.8 38l-2.5 .4c-4.4 .7-7.3 4.8-6.6 9.2zM224 272a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm8 131.8c0 6.7 5.5 12.2 12.2 12.2l151.6 0c6.7 0 12.2-5.5 12.2-12.2 0-46.3-37.5-83.8-83.8-83.8l-8.4 0c-46.3 0-83.8 37.5-83.8 83.8zM384 272a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm2.3-117.7c-3.1 3.1-3.1 8.2 0 11.3l7.4 7.4c22.4 22.4 51.2 37.2 82.5 42.5l2.5 .4c4.4 .7 8.5-2.2 9.2-6.6s-2.2-8.5-6.6-9.2l-2.5-.4c-28-4.7-53.8-17.9-73.8-38l-7.4-7.4c-3.1-3.1-8.2-3.1-11.3 0z", "M560 256c0 132.5-107.5 240-240 240-60.1 0-115-22.1-157.1-58.5-2.5 4.8-5.4 9.4-8.6 13.7 44.7 38 102.5 60.8 165.7 60.8 141.4 0 256-114.6 256-256S461.4 0 320 0C184 0 72.8 106.1 64.5 240 69.8 240 75.2 240.9 80.4 242.4 87.4 116.2 192 16 320 16 452.5 16 560 123.5 560 256zM315.8 320c-46.3 0-83.8 37.5-83.8 83.8 0 6.7 5.5 12.2 12.2 12.2l151.6 0c6.7 0 12.2-5.5 12.2-12.2 0-46.3-37.5-83.8-83.8-83.8l-8.4 0zm8.4 16c36.2 0 65.7 28.3 67.7 64l-143.8 0c2-35.7 31.5-64 67.7-64l8.4 0zM384 272a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zM240 288a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm13.7-133.7c-3.1-3.1-8.2-3.1-11.3 0l-7.4 7.4c-20 20-45.8 33.3-73.8 38l-2.5 .4c-4.4 .7-7.3 4.8-6.6 9.2s4.8 7.3 9.2 6.6l2.5-.4c31.2-5.2 60.1-20.1 82.5-42.5l7.4-7.4c3.1-3.1 3.1-8.2 0-11.3zm132.7 11.3l7.4 7.4c22.4 22.4 51.2 37.2 82.5 42.5l2.5 .4c4.4 .7 8.5-2.2 9.2-6.6s-2.2-8.5-6.6-9.2l-2.5-.4c-28-4.7-53.8-17.9-73.8-38l-7.4-7.4c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3zM85.8 330.1l0 0c14.6 17.7 26.2 36.1 26.2 53.9 0 27.6-20.4 48-48 48s-48-20.4-48-48c0-17.8 11.6-36.2 26.2-53.9 6.8-8.2 14.1-16.1 21.8-23.3 7.7 7.2 15 15.1 21.8 23.3zm12.4-10.2c-8.8-10.7-18.5-20.9-29-30-3-2.6-7.4-2.6-10.4 0-10.5 9.1-20.1 19.3-29 30-14.7 17.8-29.8 40.1-29.8 64.1 0 36.4 27.6 64 64 64s64-27.6 64-64c0-24-15.2-46.3-29.8-64.1z"]],
    "message-smile": [512, 512, ["comment-alt-smile"], "f4aa", ["M16 128l0 224c0 44.2 35.8 80 80 80l32 0c8.8 0 16 7.2 16 16l0 75.9c0 2.3 2 4 4.1 4.1 .8 0 1.7-.2 2.4-.7 3.3-2.3 6.3-4.5 9.1-6.4l.4-.3c6.7-4.7 30.4-21.5 117.2-82.7 5.4-3.8 11.8-5.9 18.5-5.9L416 432c44.2 0 80-35.8 80-80l0-224c0-44.2-35.8-80-80-80L96 48c-44.2 0-80 35.8-80 80zM160.6 301.3c-2.9-3.3-2.7-8.3 .6-11.3s8.3-2.7 11.3 .6C193 313.6 222.8 328 256 328s63-14.4 83.5-37.3c2.9-3.3 8-3.6 11.3-.6s3.6 8 .6 11.3C328 327.5 293.9 344 256 344s-72-16.5-95.4-42.7zM208 192a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm128 0a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M144 448l0 75.9c0 2.3 2 4 4.1 4.1 .8 0 1.7-.2 2.4-.7 3.3-2.3 6.3-4.5 9.1-6.4l.4-.3c6.7-4.7 30.4-21.5 117.2-82.7 5.4-3.8 11.8-5.9 18.5-5.9L416 432c44.2 0 80-35.8 80-80l0-224c0-44.2-35.8-80-80-80L96 48c-44.2 0-80 35.8-80 80l0 224c0 44.2 35.8 80 80 80l32 0c8.8 0 16 7.2 16 16zM0 128C0 75 43 32 96 32l320 0c53 0 96 43 96 96l0 224c0 53-43 96-96 96l-120.4 0c-3.3 0-6.5 1-9.2 2.9L159.8 540.3c-3.4 2.4-7.5 3.7-11.6 3.7-11.1 0-20.1-9-20.1-20.1l0-75.9-32 0c-53 0-96-43-96-96L0 128zm192 48a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm128 0a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM161.2 290c3.3-2.9 8.3-2.7 11.3 .6 20.5 22.9 50.3 37.3 83.5 37.3s63-14.4 83.5-37.3c2.9-3.3 8-3.6 11.3-.6s3.6 8 .6 11.3C328 327.5 293.9 344 256 344s-72-16.5-95.4-42.7c-2.9-3.3-2.7-8.3 .6-11.3z"]],
    "location-exclamation": [384, 512, ["map-marker-exclamation"], "f608", ["M16 188.6c0 55 28 117.3 63.9 174.2 35.6 56.3 77.5 104.9 102.3 131.8 5.5 6 14.3 6 19.8 0 24.8-26.9 66.7-75.5 102.2-131.8 35.9-56.8 63.9-119.2 63.9-174.2 0-95-78.5-172.6-176-172.6S16 93.5 16 188.6zM208 336a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zM177.8 110.7c-.3-8 6.1-14.7 14.2-14.7l2.9 .3c6.6 1.4 11.5 7.4 11.3 14.4L200 272.3c-.2 4.3-3.7 7.7-8 7.7s-7.8-3.4-8-7.7l-6.2-161.6z", "M192 0c106 0 192 84.4 192 188.6 0 119.3-120.2 262.3-170.4 316.8l0 0c-11.8 12.8-31.4 12.8-43.3 0l0 0C120.1 450.8 0 307.9 0 188.6 0 84.4 86 0 192 0zm0 16c-97.5 0-176 77.5-176 172.6 0 55 28 117.3 63.9 174.2 35.6 56.3 77.5 104.9 102.3 131.8 5.5 6 14.3 6 19.8 0 24.8-26.9 66.7-75.5 102.2-131.8 35.9-56.8 63.9-119.2 63.9-174.2 0-95-78.5-172.6-176-172.6zm0 336a16 16 0 1 1 0-32 16 16 0 1 1 0 32zm2.9-255.7c6.6 1.4 11.5 7.4 11.3 14.4L200 272.3c-.2 4.3-3.7 7.7-8 7.7s-7.8-3.4-8-7.7l-6.2-161.6c-.3-8 6.1-14.7 14.2-14.7l2.9 .3z"]],
    "square-naira": [448, 512, [], "e708", ["M16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96zM96 264c0-4.4 3.6-8 8-8l24 0 0-120c0-3.5 2.2-6.5 5.5-7.6s6.9 .1 8.9 2.9l91.5 124.7 70.1 0 0-120c0-4.4 3.6-8 8-8s8 3.6 8 8l0 120 24 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-24 0 0 104c0 3.5-2.2 6.5-5.5 7.6s-6.9-.1-8.9-2.9l-79.7-108.7-81.8 0 0 104c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-104-24 0c-4.4 0-8-3.6-8-8zm48-103.6l0 95.6 70.1 0-70.1-95.6zM245.7 272l58.3 79.6 0-79.6-58.3 0z", "M64 48C37.5 48 16 69.5 16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm133.5 32.4c3.3-1.1 6.9 .1 8.9 2.9l91.5 124.7 70.1 0 0-120c0-4.4 3.6-8 8-8s8 3.6 8 8l0 120 24 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-24 0 0 104c0 3.5-2.2 6.5-5.5 7.6s-6.9-.1-8.9-2.9l-79.7-108.7-81.8 0 0 104c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-104-24 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l24 0 0-120c0-3.5 2.2-6.5 5.5-7.6zM304 351.6l0-79.6-58.3 0 58.3 79.6zM144 160.4l0 95.6 70.1 0-70.1-95.6z"]],
    "table-cells-row-unlock": [640, 512, [], "e691", ["M80 192l0 224c0 26.5 21.5 48 48 48l80 0 0-272-128 0zm144 0l0 272 128 0 0-272-128 0zm144 0l0 175.9c0-35.5 19.3-66.6 48-83.2l0-28.7c0-23.8 7.4-45.9 20.1-64L368 192z", "M128 48l320 0c26.5 0 48 21.5 48 48l0 52.6c5.2-1.5 10.5-2.7 16-3.5L512 96c0-35.3-28.7-64-64-64L128 32C92.7 32 64 60.7 64 96l0 320c0 35.3 28.7 64 64 64l241.3 0c-.9-5.2-1.3-10.5-1.3-16l0-272 68.1 0c4-5.8 8.6-11.1 13.5-16L80 176 80 96c0-26.5 21.5-48 48-48zM80 192l128 0 0 272-80 0c-26.5 0-48-21.5-48-48l0-224zM224 464l0-272 128 0 0 272-128 0zM576 272l16 0 0-15.9c0-35.3-28.7-64-64-64s-64 28.7-64 64l0 63.9c-26.5 0-48 21.5-48 48l0 96c0 26.5 21.5 48 48 48l128 0c26.5 0 48-21.5 48-48l0-96c0-26.5-21.5-48-48-48l-112 0 0-63.9c0-26.5 21.5-48 48-48s48 21.5 48 48l0 15.9zM432 368c0-17.7 14.3-32 32-32l0 .1 80 0 0-.1 48 0c17.7 0 32 14.3 32 32l0 96c0 17.7-14.3 32-32 32l-128 0c-17.7 0-32-14.3-32-32l0-96z"]],
    "diamonds-4": [512, 512, [], "e68b", ["M16 256c0 11.1 4.4 21.8 12.3 29.7l48.1 48.1c12.5 12.5 32.8 12.5 45.3 0l55.1-55.1c12.5-12.5 12.5-32.8 0-45.3l-55.1-55.1c-12.5-12.5-32.8-12.5-45.3 0L28.3 226.3C20.4 234.2 16 244.9 16 256zM178.2 76.4c-12.5 12.5-12.5 32.8 0 45.3l55.1 55.1c12.5 12.5 32.8 12.5 45.3 0l55.1-55.1c12.5-12.5 12.5-32.8 0-45.3L285.7 28.3C277.8 20.4 267.1 16 256 16s-21.8 4.4-29.7 12.3L178.2 76.4zm0 313.9c-12.5 12.5-12.5 32.8 0 45.3l48.1 48.1c7.9 7.9 18.5 12.3 29.7 12.3s21.8-4.4 29.7-12.3l48.1-48.1c12.5-12.5 12.5-32.8 0-45.3l-55.1-55.1c-12.5-12.5-32.8-12.5-45.3 0l-55.1 55.1zm157-157c-12.5 12.5-12.5 32.8 0 45.3l55.1 55.1c12.5 12.5 32.8 12.5 45.3 0l48.1-48.1c7.9-7.9 12.3-18.5 12.3-29.7s-4.4-21.8-12.3-29.7l-48.1-48.1c-12.5-12.5-32.8-12.5-45.3 0l-55.1 55.1z", "M233.4 335.2c12.5-12.5 32.8-12.5 45.3 0l55.1 55.1c12.5 12.5 12.5 32.8 0 45.3l-48.1 48.1c-7.9 7.9-18.5 12.3-29.7 12.3s-21.8-4.4-29.7-12.3l-48.1-48.1c-12.5-12.5-12.5-32.8 0-45.3l55.1-55.1zM28.3 285.7C20.4 277.8 16 267.1 16 256s4.4-21.8 12.3-29.7l48.1-48.1c12.5-12.5 32.8-12.5 45.3 0l55.1 55.1c12.5 12.5 12.5 32.8 0 45.3l-55.1 55.1c-12.5 12.5-32.8 12.5-45.3 0L28.3 285.7zm149.9-164c-12.5-12.5-12.5-32.8 0-45.3l48.1-48.1C234.2 20.4 244.9 16 256 16s21.8 4.4 29.7 12.3l48.1 48.1c12.5 12.5 12.5 32.8 0 45.3l-55.1 55.1c-12.5 12.5-32.8 12.5-45.3 0l-55.1-55.1zm212.1 56.6c12.5-12.5 32.8-12.5 45.3 0l48.1 48.1c7.9 7.9 12.3 18.5 12.3 29.7s-4.4 21.8-12.3 29.7l-48.1 48.1c-12.5 12.5-32.8 12.5-45.3 0l-55.1-55.1c-12.5-12.5-12.5-32.8 0-45.3l55.1-55.1zM166.9 379c-18.7 18.7-18.7 49.1 0 67.9L215 495c10.9 10.9 25.6 17 41 17s30.1-6.1 41-17l48.1-48.1c18.7-18.7 18.7-49.1 0-67.9l-55.1-55.1c-18.7-18.7-49.1-18.7-67.9 0L166.9 379zM65.1 345.1c18.7 18.7 49.1 18.7 67.9 0l55.1-55.1c18.7-18.7 18.7-49.1 0-67.9L133 166.9c-18.7-18.7-49.1-18.7-67.9 0L17 215C6.1 225.9 0 240.6 0 256s6.1 30.1 17 41l48.1 48.1zM166.9 133l55.1 55.1c18.7 18.7 49.1 18.7 67.9 0L345.1 133c18.7-18.7 18.7-49.1 0-67.9L297 17C286.1 6.1 271.4 0 256 0s-30.1 6.1-41 17L166.9 65.1c-18.7 18.7-18.7 49.1 0 67.9zM379 166.9l-55.1 55.1c-18.7 18.7-18.7 49.1 0 67.9L379 345.1c18.7 18.7 49.1 18.7 67.9 0L495 297c10.9-10.9 17-25.6 17-41s-6.1-30.1-17-41l-48.1-48.1c-18.7-18.7-49.1-18.7-67.9 0z"]],
    "rocket": [512, 512, [], "f135", ["M10.8 279.8C4.4 290.4 12.1 304 24.5 304L128 304c1.2 0 2.4 0 3.5 .1 12-51.5 27.6-93.7 45.7-128.1l-86 0c-11.2 0-21.7 5.9-27.4 15.5L10.8 279.8zm136.6 26.6c28.6 7.1 51.1 29.6 58.2 58.2 127.5-29.9 193.4-81.9 226.5-135.8 34.7-56.5 35.4-118.1 28.3-166.1-.8-5.8-5.3-10.3-11.1-11.1-48-7-109.7-6.4-166.1 28.3-53.8 33.1-105.8 99-135.8 226.5zM208 380.5c.1 1.2 .1 2.3 .1 3.5l0 103.5c0 12.4 13.6 20.1 24.2 13.7l88.2-52.9c9.6-5.8 15.5-16.2 15.5-27.4l0-86c-34.4 18.1-76.6 33.7-128.1 45.7zM400 160a48 48 0 1 1 -96 0 48 48 0 1 1 96 0z", "M128.1 320L24.5 320c-24.9 0-40.2-27.1-27.4-48.5L50 183.3C58.7 168.8 74.3 160 91.2 160l95 0c76.1-128.9 189.6-135.4 265.5-124.3 12.8 1.9 22.8 11.9 24.6 24.6 11.1 75.9 4.6 189.4-124.3 265.5l0 95c0 16.9-8.8 32.5-23.3 41.2l-88.2 52.9c-21.3 12.8-48.5-2.6-48.5-27.4L192 384c0-35.3-28.6-64-63.9-64zm77.6 44.6c127.5-29.9 193.4-81.9 226.5-135.8 34.7-56.5 35.4-118.1 28.3-166.1-.8-5.8-5.3-10.3-11.1-11.1-48-7-109.7-6.4-166.1 28.3-53.8 33.1-105.8 99-135.8 226.5 28.6 7.1 51.1 29.6 58.2 58.2zm2.3 15.9c.1 1.2 .1 2.3 .1 3.5l0 103.5c0 12.4 13.6 20.1 24.2 13.7l88.2-52.9c9.6-5.8 15.5-16.2 15.5-27.4l0-86c-34.4 18.1-76.6 33.7-128.1 45.7zm-76.4-76.4c12-51.5 27.6-93.7 45.7-128.1l-86 0c-11.2 0-21.7 5.9-27.4 15.5L10.8 279.8C4.4 290.4 12.1 304 24.5 304L128 304c1.2 0 2.4 0 3.5 .1zM352 192a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm0-80a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"]],
    "file-circle-info": [576, 512, [58604], "e493", ["M48 64c0-26.5 21.5-48 48-48l133.5 0c3.6 0 7.1 .4 10.5 1.2L240 120c0 30.9 25.1 56 56 56l102.8 0c.8 3.4 1.2 6.9 1.2 10.5l0 24.1c-90.8 15.2-160 94.2-160 189.3 0 35 9.3 67.8 25.7 96L96 496c-26.5 0-48-21.5-48-48L48 64z", "M96 16l133.5 0c3.6 0 7.1 .4 10.5 1.2L240 120c0 30.9 25.1 56 56 56l102.8 0c.8 3.4 1.2 6.9 1.2 10.5l0 24.1c5.3-.9 10.6-1.6 16-2l0-22.1c0-17-6.7-33.3-18.7-45.3L274.7 18.7C262.7 6.7 246.5 0 229.5 0L96 0C60.7 0 32 28.7 32 64l0 384c0 35.3 28.7 64 64 64l180 0c-3.7-5.1-7.2-10.5-10.3-16L96 496c-26.5 0-48-21.5-48-48L48 64c0-26.5 21.5-48 48-48zM392 160l-96 0c-22.1 0-40-17.9-40-40l0-96c2.7 1.8 5.1 3.8 7.4 6.1L385.9 152.6c2.3 2.3 4.3 4.8 6.1 7.4zM304 400a128 128 0 1 1 256 0 128 128 0 1 1 -256 0zm272 0a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zM432 324a12 12 0 1 0 0 24 12 12 0 1 0 0-24zM408 472c0 4.4 3.6 8 8 8l32 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-8 0 0-80c0-4.4-3.6-8-8-8l-16 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l8 0 0 72-8 0c-4.4 0-8 3.6-8 8z"]],
    "cloud-fog": [576, 512, [127787, "fog"], "f74e", ["M48 224c0 44.2 35.8 80 80 80l320 0c44.2 0 80-35.8 80-80s-35.8-80-80-80c-3.8 0-7.6 .3-11.3 .8-2.8 .4-5.6-.7-7.3-2.9s-2.3-5.1-1.3-7.8c2.5-6.9 3.9-14.3 3.9-22.1 0-35.3-28.7-64-64-64-23.7 0-44.4 12.9-55.5 32-1.6 2.7-4.5 4.2-7.6 4s-5.8-2.3-6.8-5.2c-13.5-36.7-48.8-62.8-90.1-62.8-53 0-96 43-96 96 0 8.4 1.1 16.6 3.1 24.4 .5 2.1 .2 4.3-.9 6.1s-2.9 3.2-5 3.7C74.1 154.6 48 186.3 48 224z", "M208 0c-61.9 0-112 50.1-112 112 0 7.1 .7 14.1 1.9 20.8-38.3 12.6-65.9 48.7-65.9 91.2 0 53 43 96 96 96l320 0c53 0 96-43 96-96s-43-96-96-96c-.5 0-1.1 0-1.6 0 1.1-5.2 1.6-10.5 1.6-16 0-44.2-35.8-80-80-80-24.3 0-46.1 10.9-60.8 28-18.7-35.7-56.1-60-99.2-60zM112 112c0-53 43-96 96-96 41.3 0 76.6 26.1 90.1 62.8 1.1 2.9 3.7 4.9 6.8 5.2s6.1-1.3 7.6-4c11.1-19.2 31.8-32 55.5-32 35.3 0 64 28.7 64 64 0 7.8-1.4 15.2-3.9 22.1-1 2.6-.5 5.6 1.3 7.8s4.6 3.3 7.3 2.9c3.7-.5 7.5-.8 11.3-.8 44.2 0 80 35.8 80 80s-35.8 80-80 80l-320 0c-44.2 0-80-35.8-80-80 0-37.7 26.1-69.4 61.3-77.8 2.1-.5 3.9-1.8 5-3.7s1.4-4.1 .9-6.1c-2-7.8-3.1-16-3.1-24.4zM512 392c0-4.4-3.6-8-8-8L8 384c-4.4 0-8 3.6-8 8s3.6 8 8 8l496 0c4.4 0 8-3.6 8-8zM64 488c0 4.4 3.6 8 8 8l112 0c4.4 0 8-3.6 8-8s-3.6-8-8-8L72 480c-4.4 0-8 3.6-8 8zm176 0c0 4.4 3.6 8 8 8l320 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-320 0c-4.4 0-8 3.6-8 8z"]],
    "option": [640, 512, [], "e318", ["", "M463.8 417.5c7.6 9.2 18.9 14.5 30.8 14.5L632 432c4.4 0 8 3.6 8 8s-3.6 8-8 8l-137.4 0c-16.7 0-32.5-7.5-43.2-20.3L176.2 94.5C168.6 85.3 157.3 80 145.4 80L8 80c-4.4 0-8-3.6-8-8s3.6-8 8-8l137.4 0c16.7 0 32.5 7.5 43.2 20.3L463.8 417.5zM424 80c-4.4 0-8-3.6-8-8s3.6-8 8-8l208 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L424 80z"]],
    "utility-pole": [512, 512, [], "e2c3", ["", "M256 0c4.4 0 8 3.6 8 8l0 88 144 0 0-56c0-4.4 3.6-8 8-8s8 3.6 8 8l0 56 23.9 0 .1 0 47.9 0 0-56c0-4.4 3.6-8 8-8s8 3.6 8 8l0 64c0 4.4-3.6 8-8 8L450.8 112 264 259.9 264 504c0 4.4-3.6 8-8 8s-8-3.6-8-8L248 259.9 61.2 112 8 112c-4.4 0-8-3.6-8-8L0 40c0-4.4 3.6-8 8-8s8 3.6 8 8l0 56 47.9 0 .1 0 23.9 0 0-56c0-4.4 3.6-8 8-8s8 3.6 8 8l0 56 144 0 0-88c0-4.4 3.6-8 8-8zm-8 112L87 112 248 239.5 248 112zm16 127.5l161-127.5-161 0 0 127.5z"]],
    "shrimp": [512, 512, [129424], "e448", ["M80 144c0 88.4 71.6 160 160 160l108 0c28.7 0 52 23.3 52 52l0 4.8c0 22-15.5 40.9-37.1 45.2-7 1.4-14.3 1.6-21.4 .7l-83.8-11.2 35.5 30.4c1.9 1.6 2.9 4 2.8 6.4s-1.3 4.7-3.3 6.2L257 464 336 464c2.7 0 5.4-.1 8-.2l0-31.8c0-4.4 3.6-8 8-8s8 3.6 8 8l0 30.2c46.8-7 87-34.3 111.3-72.7l-41.8-13.9c-4.2-1.4-6.5-5.9-5.1-10.1s5.9-6.5 10.1-5.1l44.7 14.9c10.7-21.5 16.7-45.7 16.7-71.3 0-24.7-5.6-48.2-15.6-69.1l-42.7 42.7c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l46-46C444.2 174.5 393.7 144 336 144l0 104c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-104-240 0zm128 48a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M0 88C0 57.1 25.1 32 56 32l384 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L56 48C33.9 48 16 65.9 16 88s17.9 40 40 40l280 0c97.2 0 176 78.8 176 176S433.2 480 336 480l-104 0c-4.4 0-8-3.6-8-8 0-2.7 1.4-5.1 3.4-6.6l47.6-34-48.2-41.4c-2.7-2.3-3.5-6.1-2.1-9.3s4.8-5.1 8.4-4.7l110.6 14.7c5.4 .7 10.8 .5 16.2-.5 14.1-2.8 24.2-15.2 24.2-29.6l0-4.8c0-19.9-16.1-36-36-36l-108 0c-97.2 0-176-78.8-176-176l-8 0C25.1 144 0 118.9 0 88zM336 464c2.7 0 5.4-.1 8-.2l0-31.8c0-4.4 3.6-8 8-8s8 3.6 8 8l0 30.2c46.8-7 87-34.3 111.3-72.7l-41.8-13.9c-4.2-1.4-6.5-5.9-5.1-10.1s5.9-6.5 10.1-5.1l44.7 14.9c10.7-21.5 16.7-45.7 16.7-71.3 0-24.7-5.6-48.2-15.6-69.1l-42.7 42.7c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l46-46C444.2 174.5 393.7 144 336 144l0 104c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-104-240 0c0 88.4 71.6 160 160 160l108 0c28.7 0 52 23.3 52 52l0 4.8c0 22-15.5 40.9-37.1 45.2-7 1.4-14.3 1.6-21.4 .7l-83.8-11.2 35.5 30.4c1.9 1.6 2.9 4 2.8 6.4s-1.3 4.7-3.3 6.2L257 464 336 464zM192 176a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"]],
    "alien": [448, 512, [128125], "f8f5", ["M16 224c0 61.9 34.2 120.2 76.1 168 41.7 47.5 89.1 82.6 111.6 98 5.7 3.9 12.7 6 20.3 6s14.6-2.1 20.3-6c22.4-15.4 69.9-50.5 111.6-98 42-47.8 76.2-106.1 76.2-168 0-114.9-93.1-208-208-208S16 109.1 16 224zm48 0c0-8.8 7.2-16 16-16l32 0c53 0 96 43 96 96 0 8.8-7.2 16-16 16l-32 0c-53 0-96-43-96-96zm176 80c0-53 43-96 96-96l32 0c8.8 0 16 7.2 16 16 0 53-43 96-96 96l-32 0c-8.8 0-16-7.2-16-16z", "M224 16c-114.9 0-208 93.1-208 208 0 61.9 34.2 120.2 76.1 168 41.7 47.5 89.1 82.6 111.6 98 5.7 3.9 12.7 6 20.3 6s14.6-2.1 20.3-6c22.4-15.4 69.9-50.5 111.6-98 42-47.8 76.2-106.1 76.2-168 0-114.9-93.1-208-208-208zM0 224C0 100.3 100.3 0 224 0S448 100.3 448 224c0 135.3-148.8 247.7-194.7 279.2-8.6 5.9-18.9 8.8-29.3 8.8s-20.7-2.9-29.3-8.8C148.8 471.7 0 359.3 0 224zm368 0l-32 0c-44.2 0-80 35.8-80 80l32 0c44.2 0 80-35.8 80-80zm-32-16l32 0c8.8 0 16 7.2 16 16 0 53-43 96-96 96l-32 0c-8.8 0-16-7.2-16-16 0-53 43-96 96-96zM112 224l-32 0c0 44.2 35.8 80 80 80l32 0c0-44.2-35.8-80-80-80zm96 80c0 8.8-7.2 16-16 16l-32 0c-53 0-96-43-96-96 0-8.8 7.2-16 16-16l32 0c53 0 96 43 96 96z"]],
    "skeleton": [512, 512, [], "f620", ["M104 512c4.4 0 8-3.6 8-8l0-16c0-30.9 25.1-56 56-56l176 0c30.9 0 56 25.1 56 56l0 16c0 4.4 3.6 8 8 8l-304 0z", "M256 0c4.4 0 8 3.6 8 8l0 104 168 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-168 0 0 80 232 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-232 0 0 80 136 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-136 0 0 96 80 0c39.8 0 72 32.2 72 72l0 16c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-16c0-30.9-25.1-56-56-56l-176 0c-30.9 0-56 25.1-56 56l0 16c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-16c0-39.8 32.2-72 72-72l80 0 0-96-136 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l136 0 0-80-232 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l232 0 0-80-168 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l168 0 0-104c0-4.4 3.6-8 8-8z"]],
    "tire-pressure-warning": [512, 512, [], "f633", ["M26 288.7c-.6-49.5 18.6-93.2 36.9-124.7 .1-.1 .2-.3 .2-.5l5-9.9C86.5 117 96 76.6 96 35.6L96 8c0-4.4-3.6-8-8-8L424 0c-4.4 0-8 3.6-8 8l0 27.6c0 41 9.5 81.4 27.9 118.1l5 9.9c.1 .2 .2 .3 .2 .5 18.3 31.4 37.5 75.1 36.9 124.7-.6 48.6-20.4 103.7-81.1 159.3l-297.8 0C46.4 392.4 26.6 337.2 26 288.7zM248 128l0 137.3c0 4.4 3.6 8 8 8s8-3.6 8-8L264 128c0-4.4-3.6-8-8-8s-8 3.6-8 8z", "M424 0c-4.4 0-8 3.6-8 8l0 27.6c0 41 9.5 81.4 27.9 118.1l5 9.9c.1 .2 .2 .3 .2 .5 18.3 31.4 37.5 75.1 36.9 124.7-.6 48.6-20.4 103.7-81.1 159.3l-297.8 0c-60.7-55.6-80.5-110.8-81.1-159.3-.6-49.5 18.6-93.2 36.9-124.7 .1-.1 .2-.3 .2-.5l5-9.9C86.5 117 96 76.6 96 35.6L96 8c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 27.6c0 38.5-9 76.5-26.2 110.9L49 156.2c-19 32.6-39.7 79.2-39 132.7 .7 53.3 22.6 112.5 86 170.6L96 504c0 4.4 3.6 8 8 8s8-3.6 8-8l0-40 88 0 0 40c0 4.4 3.6 8 8 8s8-3.6 8-8l0-40 80 0 0 40c0 4.4 3.6 8 8 8s8-3.6 8-8l0-40 88 0 0 40c0 4.4 3.6 8 8 8s8-3.6 8-8l0-44.5c63.4-58.2 85.3-117.3 86-170.6 .7-53.6-20-100.2-39-132.7l-4.9-9.7C441 112 432 74.1 432 35.6L432 8c0-4.4-3.6-8-8-8zM256 120c-4.4 0-8 3.6-8 8l0 137.3c0 4.4 3.6 8 8 8s8-3.6 8-8L264 128c0-4.4-3.6-8-8-8zm13.3 200a13.3 13.3 0 1 0 -26.7 0 13.3 13.3 0 1 0 26.7 0z"]],
    "nose": [448, 512, [], "e5bd", ["M16 400c0-53 43-96 96-96l16 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-16 0c-17.2 0-33.5 3.9-48 10.8L64 16 164.2 16 407.5 316.5c15.9 19.6 24.5 44.1 24.5 69.3 0 60.8-49.3 110.2-110.2 110.2l-81.8 0c-.1-8-.1-16-.1-24 0-35.3-28.7-64-64-64s-64 28.7-64 64l0 24c-53 0-96-43-96-96z", "M163 1.8C166.4-1 171.4-.5 174.2 3L419.9 306.5c18.2 22.5 28.1 50.5 28.1 79.4 0 69.7-56.5 126.2-126.2 126.2L112 512C50.1 512 0 461.9 0 400S50.1 288 112 288l16 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-16 0c-53 0-96 43-96 96s43 96 96 96l0-24c0-35.3 28.7-64 64-64s64 28.7 64 64l0 24 81.8 0c60.8 0 110.2-49.3 110.2-110.2 0-25.2-8.7-49.7-24.5-69.3L161.8 13C159 9.6 159.5 4.6 163 1.8zM224 496l0-24c0-26.5-21.5-48-48-48s-48 21.5-48 48l0 24 96 0z"]],
    "sign-posts-wrench": [640, 512, [], "e626", ["M48 128c0-26.5 21.5-48 48-48l384 0c26.5 0 48 21.5 48 48l0 48.7c-5.3-.5-10.6-.7-16-.7-97.2 0-176 78.8-176 176 0 28.8 6.9 56 19.2 80L96 432c-26.5 0-48-21.5-48-48l0-256z", "M112 24l0 40-16 0c-35.3 0-64 28.7-64 64l0 256c0 35.3 28.7 64 64 64l16 0 0 56c0 4.4 3.6 8 8 8s8-3.6 8-8l0-56 236.5 0c-3.4-5.2-6.5-10.5-9.3-16L96 432c-26.5 0-48-21.5-48-48l0-256c0-26.5 21.5-48 48-48l384 0c26.5 0 48 21.5 48 48l0 48.7c5.4 .5 10.7 1.2 16 2.2l0-50.9c0-35.3-28.7-64-64-64l-16 0 0-40c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 40-320 0 0-40c0-4.4-3.6-8-8-8s-8 3.6-8 8zM464 245.8c0-2.8-1.5-5.4-3.9-6.9s-5.4-1.5-7.9-.2c-40.6 21.4-68.3 64.1-68.3 113.2 0 47.4 25.8 88.8 64 110.9l0 73.1c0 4.4 3.6 8 8 8s8-3.6 8-8l0-77.8c0-3-1.6-5.7-4.3-7.1-35.5-18.8-59.7-56.1-59.7-99.1 0-38.1 19-71.7 48-91.9l0 59.9c0 35.3 28.7 64 64 64s64-28.7 64-64l0-59.9c29 20.2 48 53.9 48 91.9 0 43-24.2 80.3-59.7 99.1-2.6 1.4-4.3 4.1-4.3 7.1l0 77.8c0 4.4 3.6 8 8 8s8-3.6 8-8l0-73.1c38.2-22.1 64-63.5 64-110.9 0-49.1-27.7-91.8-68.3-113.2-2.5-1.3-5.5-1.2-7.9 .2s-3.9 4-3.9 6.9l0 74.2c0 26.5-21.5 48-48 48s-48-21.5-48-48l0-74.2z"]],
    "tenge-sign": [384, 512, [8376, "tenge"], "f7d7", ["", "M0 40c0-4.4 3.6-8 8-8l368 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L8 48c-4.4 0-8-3.6-8-8zM0 168c0-4.4 3.6-8 8-8l368 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-176 0 0 296c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-296-176 0c-4.4 0-8-3.6-8-8z"]],
    "face-scream": [576, 512, [], "e38b", ["M48 256C48 123.5 155.5 16 288 16S528 123.5 528 256c0 16.4-1.7 32.5-4.8 48-48 0-89.3 33.9-98.7 81-5.2 26.2-10.5 52.3-15.7 78.5-35.5 20.7-76.7 32.5-120.8 32.5s-85.3-11.9-120.8-32.5c-5.2-26.2-10.5-52.3-15.7-78.5-9.4-47.1-50.8-81-98.8-81-3.1-15.5-4.8-31.6-4.8-48zm72.3-11.1c1.7 18.9 10.6 35.9 27.1 44.9 16.4 9 36 7.7 53.9-.2 17.9-7.9 34.8-22.7 46.9-42.4s17.2-41.1 15.5-60c-1.7-18.9-10.6-35.9-27.1-44.9-16.4-9-36-7.7-53.9 .2-17.9 7.9-34.8 22.7-46.9 42.4s-17.2 41.1-15.5 60zM224 368l0 16c0 35.3 28.7 64 64 64s64-28.7 64-64l0-16c0-35.3-28.7-64-64-64s-64 28.7-64 64zm88.3-180.9c-1.7 18.9 3.5 40.3 15.5 60s28.9 34.5 46.9 42.4c17.9 7.9 37.5 9.1 53.9 .2 16.5-9 25.4-26 27.1-44.9 1.7-18.9-3.5-40.3-15.5-60s-28.9-34.5-46.9-42.4c-17.9-7.9-37.5-9.1-53.9-.2-16.5 9-25.4 26-27.1 44.9z", "M528 256c0 16.4-1.7 32.5-4.8 48l0 0c5.4 0 10.8 .4 16 1.3 3.1-15.9 4.7-32.4 4.7-49.3 0-141.4-114.6-256-256-256S32 114.6 32 256c0 16.9 1.6 33.3 4.7 49.3 5.2-.8 10.6-1.3 16-1.3l0 0C49.7 288.5 48 272.4 48 256 48 123.5 155.5 16 288 16S528 123.5 528 256zM288 496c-44 0-85.3-11.9-120.8-32.5l4.1 20.5C206.3 501.9 246 512 288 512s81.7-10.1 116.7-28.1l4.1-20.5C373.3 484.1 332 496 288 496zM88.8 397.5l22.9 114.5 16.3 0-23.5-117.6C99.5 369.8 77.9 352 52.8 352 23.6 352 0 375.6 0 404.8l0 107.2 16 0 0-107.2c0-20.3 16.5-36.8 36.8-36.8 17.5 0 32.6 12.4 36 29.5zM464.3 512l22.9-114.5c3.4-17.2 18.5-29.5 36-29.5 20.3 0 36.8 16.5 36.8 36.8l0 107.2 16 0 0-107.2c0-29.1-23.6-52.8-52.8-52.8-25.1 0-46.8 17.8-51.7 42.4L448 512 464.3 512zM149.5 193.2c10.5-17.2 25-29.7 39.7-36.1 14.7-6.5 28.9-6.7 39.8-.8 10.8 5.9 17.5 17.3 18.9 32.3 1.4 15-2.7 33-13.2 50.2s-25 29.7-39.7 36.1c-14.7 6.5-28.9 6.7-39.8 .8-10.8-5.9-17.5-17.3-18.9-32.3-1.4-15 2.7-33 13.2-50.2zm87.1-51c-16.4-9-36-7.7-53.9 .2-17.9 7.9-34.8 22.7-46.9 42.4s-17.2 41.1-15.5 60c1.7 18.9 10.6 35.9 27.1 44.9 16.4 9 36 7.7 53.9-.2 17.9-7.9 34.8-22.7 46.9-42.4s17.2-41.1 15.5-60c-1.7-18.9-10.6-35.9-27.1-44.9zm150.3 14.8c14.7 6.5 29.2 19 39.7 36.1s14.6 35.2 13.2 50.2c-1.4 15-8.1 26.5-18.9 32.3-10.9 5.9-25 5.7-39.8-.8-14.7-6.5-29.2-19-39.7-36.1s-14.6-35.2-13.2-50.2c1.4-15 8.1-26.5 18.9-32.3 10.9-5.9 25-5.7 39.8 .8zm6.5-14.6c-17.9-7.9-37.5-9.1-53.9-.2-16.5 9-25.4 26-27.1 44.9-1.7 18.9 3.5 40.3 15.5 60s28.9 34.5 46.9 42.4c17.9 7.9 37.5 9.1 53.9 .2 16.5-9 25.4-26 27.1-44.9 1.7-18.9-3.5-40.3-15.5-60s-28.9-34.5-46.9-42.4zM336 368l0 16c0 26.5-21.5 48-48 48s-48-21.5-48-48l0-16c0-26.5 21.5-48 48-48s48 21.5 48 48zm-112 0l0 16c0 35.3 28.7 64 64 64s64-28.7 64-64l0-16c0-35.3-28.7-64-64-64s-64 28.7-64 64z"]],
    "house-chimney-medical": [512, 512, ["clinic-medical"], "f7f2", ["M64 198.1L64 456c0 22.1 17.9 40 40 40l304 0c22.1 0 40-17.9 40-40L448 198.1 256 18.9 64 198.1zM160 272c0-13.3 10.7-24 24-24l32 0 0-32c0-13.3 10.7-24 24-24l32 0c13.3 0 24 10.7 24 24l0 32 32 0c13.3 0 24 10.7 24 24l0 32c0 13.3-10.7 24-24 24l-32 0 0 32c0 13.3-10.7 24-24 24l-32 0c-13.3 0-24-10.7-24-24l0-32-32 0c-13.3 0-24-10.7-24-24l0-32zM384 64l0 52.5 64 59.7 0-112.3c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16z", "M266.9 7.2c-6.1-5.7-15.7-5.7-21.8 0L10.5 226.2c-3.2 3-3.4 8.1-.4 11.3s8.1 3.4 11.3 .4L48 213.1 48 456c0 30.9 25.1 56 56 56l304 0c30.9 0 56-25.1 56-56l0-242.9 26.5 24.8c3.2 3 8.3 2.8 11.3-.4s2.8-8.3-.4-11.3L464 191.2 464 64c0-17.7-14.3-32-32-32l-32 0c-17.7 0-32 14.3-32 32l0 37.6-101.1-94.3zM448 198.1L448 456c0 22.1-17.9 40-40 40l-304 0c-22.1 0-40-17.9-40-40L64 198.1 256 18.9 448 198.1zM448 64l0 112.3-64-59.7 0-52.5c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16zM232 216c0-4.4 3.6-8 8-8l32 0c4.4 0 8 3.6 8 8l0 40c0 4.4 3.6 8 8 8l40 0c4.4 0 8 3.6 8 8l0 32c0 4.4-3.6 8-8 8l-40 0c-4.4 0-8 3.6-8 8l0 40c0 4.4-3.6 8-8 8l-32 0c-4.4 0-8-3.6-8-8l0-40c0-4.4-3.6-8-8-8l-40 0c-4.4 0-8-3.6-8-8l0-32c0-4.4 3.6-8 8-8l40 0c2.1 0 4.2-.8 5.7-2.3s2.3-3.5 2.3-5.7l0-40zm8-24c-13.3 0-24 10.7-24 24l0 32-32 0c-13.3 0-24 10.7-24 24l0 32c0 13.3 10.7 24 24 24l32 0 0 32c0 13.3 10.7 24 24 24l32 0c13.3 0 24-10.7 24-24l0-32 32 0c13.3 0 24-10.7 24-24l0-32c0-13.3-10.7-24-24-24l-32 0 0-32c0-13.3-10.7-24-24-24l-32 0z"]],
    "square-arrow-left": [448, 512, ["arrow-square-left"], "f33a", ["M16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96zM130.3 250.3l72-72c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3L155.3 248 312 248c4.4 0 8 3.6 8 8s-3.6 8-8 8l-156.7 0 58.3 58.3c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-72-72c-3.1-3.1-3.1-8.2 0-11.3z", "M64 48C37.5 48 16 69.5 16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM130.3 250.3l72-72c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3L155.3 248 312 248c4.4 0 8 3.6 8 8s-3.6 8-8 8l-156.7 0 58.3 58.3c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-72-72c-3.1-3.1-3.1-8.2 0-11.3z"]],
    "circle-location-arrow": [512, 512, ["location-circle"], "f602", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zm87.5 7.2c-2.4-11.4 3.7-23.1 14.5-27.7L338.5 141c9.5-3.9 20.2-1.9 27.3 5.3 7.2 7.1 9.2 17.8 5.2 27.2L276.5 394c-3.9 9.1-12.9 15-22.8 15-13.4 0-24.7-11.3-24.7-24.8l0-101.2-101.3 0c-11.7 0-21.9-8.3-24.2-19.8z", "M127.7 283c-11.7 0-21.9-8.3-24.2-19.8-2.4-11.4 3.7-23.1 14.5-27.7L338.5 141c9.5-3.9 20.2-1.9 27.3 5.3 7.2 7.1 9.2 17.8 5.2 27.2L276.5 394c-3.9 9.1-12.9 15-22.8 15-13.4 0-24.7-11.3-24.7-24.8l0-101.2-101.3 0zm-3.4-32.8c-8.5 3.6-5.8 16.8 3.4 16.8L229 267c8.8 0 16 7.2 16 16l0 101.2c0 9.5 13.1 12 16.8 3.4l94.5-220.5c3.2-7.4-4.4-14.4-11.6-11.5L124.3 250.2zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm496 0a240 240 0 1 0 -480 0 240 240 0 1 0 480 0z"]],
    "users-slash": [640, 512, [], "e073", ["M152 480c4.4 0 8-3.6 8-8l0-40c0-70.7 57.3-128 128-128l.8 0c58.7 58.7 117.3 117.3 176 176L152 480zm72-352c0-53 43-96 96-96 26.5 0 50.5 10.7 67.9 28.1 8.7 8.7 15.7 19 20.6 30.5 2.4 5.7 4.3 11.8 5.6 18 .6 3.2 1.1 6.4 1.5 9.7 .2 1.6 .3 3.2 .4 4.8 .1 1.5 .1 3.1 .1 5.1 0 3.5-.2 6.6-.5 9.7-.3 3.2-.8 6.4-1.5 9.5-1.3 6.2-3.2 12.3-5.6 18-4.9 11.5-11.9 21.8-20.6 30.5-17.4 17.4-41.4 28.1-67.9 28.1-8.1 0-16-1-23.5-2.9l-69.6-69.6C225 144 224 136.1 224 128z", "M45.7-29.8c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l560 560c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3L315.3 239.9c1.6 .1 3.1 .1 4.7 .1 61.9 0 112-50.1 112-112S381.9 16 320 16 208 66.1 208 128c0 1.6 0 3.1 .1 4.7L45.7-29.8zM226.9 151.5c-1.9-7.5-2.9-15.4-2.9-23.5 0-53 43-96 96-96s96 43 96 96-43 96-96 96c-8.1 0-16-1-23.5-2.9l-69.6-69.6zM624 450.2l16 16 0-26.2c0-75.1-60.9-136-136-136l-12.4 0c4.3 5.1 8.4 10.5 12.3 16l.1 0c66.3 0 120 53.7 120 120l0 10.2zM288.8 304l-15.3-15.3C200.8 296 144 357.4 144 432l0 40c0 4.4 3.6 8 8 8s8-3.6 8-8l0-40c0-70.7 57.3-128 128-128l.8 0zm-80.3-80.3c-13.4 10.3-30.2 16.3-48.5 16.3-44.2 0-80-35.8-80-80 0-18.2 6.1-35 16.3-48.5L84.9 100.1c-13.1 16.4-20.9 37.2-20.9 59.9 0 53 43 96 96 96 22.6 0 43.4-7.8 59.9-20.9l-11.4-11.4zm223 19.2c14.2 8.4 30.9 13.2 48.6 13.2 53 0 96-43 96-96s-43-96-96-96c-4.4 0-8.7 .3-12.9 .9 2.2 5 4.1 10.2 5.7 15.5 2.4-.2 4.8-.3 7.2-.3 44.2 0 80 35.8 80 80s-35.8 80-80 80c-13.5 0-26.2-3.3-37.4-9.2-3.5 4.2-7.3 8.2-11.2 12.1zM136.1 320c3.9-5.5 7.9-10.9 12.3-16L136 304C60.9 304 0 364.9 0 440l0 32c0 4.4 3.6 8 8 8s8-3.6 8-8l0-32c0-66.3 53.7-120 120-120l.1 0z"]],
    "traffic-cone": [512, 512, [], "f636", ["M43.9 496l424.3 0-58.1-144-308.2 0-58.1 144zm64.5-160l295.3 0-58.1-144-179.1 0-58.1 144zm64.5-160l166.2 0-60.5-150c-2.4-6.1-8.3-10-14.8-10l-15.6 0c-6.5 0-12.4 4-14.8 10L172.9 176z", "M248.2 16l15.6 0c6.5 0 12.4 4 14.8 10l60.5 150-166.2 0 60.5-150c2.4-6.1 8.3-10 14.8-10zm97.4 176l58.1 144-295.3 0 58.1-144 179.1 0zm64.5 160l58.1 144-424.3 0 58.1-144 308.2 0zM218.5 20L26.6 496 8 496c-4.4 0-8 3.6-8 8s3.6 8 8 8l496 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-18.6 0-191.9-476C288.6 7.9 276.9 0 263.8 0L248.2 0c-13.1 0-24.8 7.9-29.7 20z"]],
    "star-sharp-half-stroke": [512, 512, ["star-sharp-half-alt"], "e28d", ["M16 194.9c0 .9 .4 1.7 1 2.2L157.1 313.9c2.5 2.1 3.5 5.4 2.5 8.5L107.4 494.1c-.3 .9 .4 1.9 1.4 1.9 .3 0 .6-.1 .9-.3l138.4-107.6 0-353.7-48.4 152c-1.1 3.3-4.1 5.6-7.6 5.6L18.9 192c-1.6 0-2.9 1.3-2.9 2.9z", "M248 34.4l0 353.7-138.4 107.6c-.3 .2-.6 .3-.9 .3-1 0-1.7-.9-1.4-1.9l52.3-171.8c.9-3.1-.1-6.4-2.5-8.5L17 197.1c-.7-.6-1-1.4-1-2.2 0-1.6 1.3-2.9 2.9-2.9L192 192c3.5 0 6.6-2.3 7.6-5.6L248 34.4zm16 353.7l0-353.7 48.4 152c1.1 3.3 4.1 5.6 7.6 5.6l173.1 0c1.6 0 2.9 1.3 2.9 2.9 0 .9-.4 1.7-1 2.2L354.9 313.9c-2.5 2.1-3.5 5.4-2.5 8.5l52.3 171.8c.3 .9-.4 1.9-1.4 1.9-.3 0-.6-.1-.9-.3L264 388.1zM256 0c-8.2 0-15.5 5.3-18 13.2L186.2 176 18.9 176c-10.4 0-18.9 8.5-18.9 18.9 0 5.6 2.5 10.9 6.8 14.5l136 113.3-50.7 166.7c-3.4 11.2 5 22.5 16.7 22.5 3.9 0 7.7-1.3 10.7-3.7L256 402.1 392.5 508.3c3.1 2.4 6.8 3.7 10.7 3.7 11.7 0 20.1-11.3 16.7-22.5l-50.7-166.7 136-113.3c4.3-3.6 6.8-8.9 6.8-14.5 0-10.4-8.5-18.9-18.9-18.9L325.8 176 274 13.2C271.5 5.3 264.2 0 256 0z"]],
    "h1": [512, 512, [], "f313", ["", "M424 72c0-2.7-1.4-5.3-3.7-6.7s-5.2-1.7-7.6-.6l-88 40c-4 1.8-5.8 6.6-4 10.6s6.6 5.8 10.6 4l76.7-34.9 0 347.6-80 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l176 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-80 0 0-360zM16 72c0-4.4-3.6-8-8-8s-8 3.6-8 8L0 440c0 4.4 3.6 8 8 8s8-3.6 8-8l0-176 224 0 0 176c0 4.4 3.6 8 8 8s8-3.6 8-8l0-368c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 176-224 0 0-176z"]],
    "tamale": [320, 512, [129748], "e451", ["M19.8 41.3C18.1 28.6 22.8 18.5 30.8 13.9 52.7 1.2 94.6-16 160.3-16S267.9 1.2 289.9 13.9c8 4.6 12.6 14.7 10.9 27.4l-22.2 166.7-72.2 0 17.9-143c.5-4.4-2.6-8.4-6.9-8.9s-8.4 2.6-8.9 6.9l-18.1 145-51.9 0-18.1-145c-.5-4.4-4.5-7.5-8.9-6.9s-7.5 4.5-6.9 8.9l17.9 143-80.2 0-22.2-166.7zm0 429.4l22.2-166.7 41 0c-8 22.5 1.9 48 23.8 58.9 2.5 1.3 5.1 2.3 7.7 3l-10.1 81c-.5 4.4 2.6 8.4 6.9 8.9s8.4-2.6 8.9-6.9l10.1-81c11-.5 21.6-4.8 29.9-12.2 10.3 9.2 24.2 13.6 37.9 11.9L208.4 449c.6 4.4 4.5 7.5 8.9 6.9s7.5-4.5 6.9-8.9c-3.5-28-7-56-10.5-84.1 21.9-11 31.8-36.4 23.8-58.9l41 0 22.2 166.7c1.7 12.7-2.9 22.8-10.9 27.4-21.9 12.6-63.8 29.9-129.5 29.9S52.7 510.8 30.8 498.1c-8-4.6-12.6-14.7-10.9-27.4z", "M30.8 13.9C52.7 1.2 94.6-16 160.3-16S267.9 1.2 289.9 13.9c8 4.6 12.6 14.7 10.9 27.4l-22.2 166.7 16.1 0 21.9-164.6C319 26.1 313 8.7 297.8 0 273.6-14 229-32 160.3-32S47-14 22.8 0C7.7 8.7 1.7 26.1 4 43.4L25.9 208 42.1 208 19.8 41.3c-1.7-12.7 2.9-22.8 10.9-27.4zM42.1 304L25.9 304 4 468.6c-2.3 17.3 3.7 34.7 18.8 43.4 24.2 14 68.9 32 137.5 32s113.3-18 137.5-32c15.1-8.7 21.1-26.1 18.8-43.4l-21.9-164.6-16.1 0 22.2 166.7c1.7 12.7-2.9 22.8-10.9 27.4-21.9 12.6-63.8 29.9-129.5 29.9S52.7 510.8 30.8 498.1c-8-4.6-12.6-14.7-10.9-27.4L42.1 304zm164.3-96L224.3 65c.5-4.4-2.6-8.4-6.9-8.9s-8.4 2.6-8.9 6.9l-18.1 145 16.1 0zm17.9 239L213.8 363c-5 2.5-10.3 4-15.5 4.7L208.4 449c.6 4.4 4.5 7.5 8.9 6.9s7.5-4.5 6.9-8.9zm-93.9-79c-5.3 .2-10.6-.4-15.9-2l-10.1 81c-.5 4.4 2.6 8.4 6.9 8.9s8.4-2.6 8.9-6.9l10.1-81zm8-160L120.3 63c-.5-4.4-4.5-7.5-8.9-6.9s-7.5 4.5-6.9 8.9l17.9 143 16.1 0zM24.3 256c0 4.4 3.6 8 8 8l115.1 0-26.2 52.4c-2 4-.4 8.8 3.6 10.7s8.8 .4 10.7-3.6l24.8-49.7 24.8 49.7c2 4 6.8 5.6 10.7 3.6s5.6-6.8 3.6-10.7l-26.2-52.4 115.1 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-256 0c-4.4 0-8 3.6-8 8z"]],
    "route-highway": [448, 512, [], "f61a", ["M16 346.3c0 34.4 20.2 65.5 51.6 79.5L224 495.2 380.4 425.8c31.4-14 51.6-45.1 51.6-79.5 0-11.1-2.1-22-6.2-32.3l-11.5-28.7C404.9 261.7 400 236.5 400 211l0-19-352 0 0 19c0 25.4-4.9 50.7-14.3 74.3L22.2 314c-4.1 10.3-6.2 21.2-6.2 32.3z", "M228.1 1.1c-2.5-1.5-5.7-1.5-8.2 0l-16.5 9.9c-37.5 22.5-83.6 25.1-123.4 7-15.5-7-33.7-2.4-43.9 11.2L12.9 60.1C4.1 71.8 3.1 87.6 10.4 100.3 24.6 125.1 32 153.1 32 181.7L32 211c0 23.4-4.5 46.6-13.2 68.3L7.4 308C2.5 320.2 0 333.2 0 346.3 0 387 24 423.8 61.1 440.4l159.6 70.9c2.1 .9 4.4 .9 6.5 0l159.6-70.9c37.2-16.5 61.1-53.4 61.1-94.1 0-13.1-2.5-26.1-7.4-38.2l-11.5-28.7C420.5 257.6 416 234.4 416 211l0-29.4c0-28.5 7.4-56.6 21.6-81.3 7.3-12.7 6.3-28.5-2.5-40.2L412 29.3c-10.2-13.6-28.5-18.3-43.9-11.2-39.8 18.1-85.9 15.5-123.4-7L228.1 1.1zM400.1 176L47.9 176c-.9-29.4-9-58.1-23.6-83.6-4.1-7.2-3.5-16.1 1.4-22.6L48.8 38.9c5.7-7.6 15.9-10.2 24.5-6.3 44.6 20.3 96.3 17.3 138.3-7.9l12.4-7.5 12.4 7.5c42 25.2 93.7 28.1 138.3 7.9 8.6-3.9 18.8-1.3 24.5 6.3l23.1 30.8c4.9 6.6 5.5 15.5 1.4 22.6-14.6 25.5-22.7 54.3-23.6 83.6zM48 192l352 0 0 19c0 25.4 4.9 50.7 14.3 74.3L425.8 314c4.1 10.3 6.2 21.2 6.2 32.3 0 34.4-20.2 65.5-51.6 79.5L224 495.2 67.6 425.8c-31.4-14-51.6-45.1-51.6-79.5 0-11.1 2.1-22 6.2-32.3l11.5-28.7C43.1 261.7 48 236.5 48 211l0-19z"]],
    "paper-plane": [576, 512, [61913], "f1d8", ["M32.3 184.5c0 7.7 4.6 14.6 11.8 17.5l204 82.9 296.7-296.7c-1 .1-2.1 .3-3.1 .6L44.8 166.8c-7.5 2.7-12.5 9.8-12.5 17.8zM259.4 296.2l82.9 204c2.9 7.1 9.8 11.8 17.5 11.8 8 0 15.1-5 17.8-12.5L555.6 2.6c.4-1 .6-2.1 .6-3.1L259.4 296.2z", "M259.4 296.2L556.2-.5c-.1 1-.3 2.1-.6 3.1l-178 496.9c-2.7 7.5-9.8 12.5-17.8 12.5-7.7 0-14.6-4.6-17.5-11.8l-82.9-204zM544.9-11.8L248.1 284.9 44.1 202c-7.1-2.9-11.8-9.8-11.8-17.5 0-8 5-15.1 12.5-17.8l496.9-178c1-.4 2.1-.6 3.1-.6zM38.1 216.8l205.8 83.6 83.6 205.8c5.3 13.1 18.1 21.7 32.3 21.7 14.7 0 27.8-9.2 32.8-23.1L570.6 8c3.5-9.8 1-20.6-6.3-28s-18.2-9.8-28-6.3L39.4 151.7c-13.9 5-23.1 18.1-23.1 32.8 0 14.2 8.6 27 21.7 32.3z"]],
    "object-intersect": [512, 512, [], "e49d", ["M176 224l0 112 112 0c26.5 0 48-21.5 48-48l0-112-112 0c-26.5 0-48 21.5-48 48z", "M64 16C37.5 16 16 37.5 16 64l0 16-16 0 0-16C0 28.7 28.7 0 64 0l16 0 0 16-16 0zm160 0l-96 0 0-16 96 0 0 16zM16 128l0 96-16 0 0-96 16 0zM0 288l0-16 16 0 0 16c0 26.5 21.5 48 48 48l48 0 0 16-48 0c-35.3 0-64-28.7-64-64zm160 64l0-128c0-35.3 28.7-64 64-64l128 0 0 128c0 35.3-28.7 64-64 64l-128 0zm336-64l16 0 0 96-16 0 0-96zm16-48l-16 0 0-16c0-26.5-21.5-48-48-48l-48 0 0-16 48 0c35.3 0 64 28.7 64 64l0 16zm0 192l0 16c0 35.3-28.7 64-64 64l-16 0 0-16 16 0c26.5 0 48-21.5 48-48l0-16 16 0zM384 512l-96 0 0-16 96 0 0 16zM160 400l16 0 0 48c0 26.5 21.5 48 48 48l16 0 0 16-16 0c-35.3 0-64-28.7-64-64l0-48zM352 112l-16 0 0-48c0-26.5-21.5-48-48-48l-16 0 0-16 16 0c35.3 0 64 28.7 64 64l0 48zm-16 64l-112 0c-26.5 0-48 21.5-48 48l0 112 112 0c26.5 0 48-21.5 48-48l0-112z"]],
    "book-atlas": [448, 512, ["atlas"], "f558", ["M16 56l0 360.8C26.2 406.4 40.3 400 56 400l352 0c13.3 0 24-10.7 24-24l0-336c0-13.3-10.7-24-24-24L56 16C33.9 16 16 33.9 16 56zM96.2 201.4c.1-2.2 .3-4.3 .5-6.5 .4-4.3 1.1-8.5 1.9-12.7 1.7-8.3 4.2-16.4 7.5-24 6.5-15.3 15.8-29.1 27.4-40.7 23.2-23.2 55.2-37.5 90.5-37.5 70.7 0 128 57.3 128 128S294.7 336 224 336c-35.3 0-67.3-14.3-90.5-37.5-11.6-11.6-21-25.4-27.4-40.7-3.2-7.7-5.8-15.7-7.5-24-.9-4.2-1.5-8.4-1.9-12.7-.2-2.2-.4-4.3-.5-6.5-.1-2.1-.2-4.3-.2-6.6s.1-4.5 .2-6.6z", "M0 56C0 25.1 25.1 0 56 0L408 0c22.1 0 40 17.9 40 40l0 336c0 19.4-13.7 35.5-32 39.2l0 80.8 24 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L56 512c-30.9 0-56-25.1-56-56L0 56zM56 416c-22.1 0-40 17.9-40 40s17.9 40 40 40l344 0 0-80-344 0zm-40 .8C26.2 406.4 40.3 400 56 400l352 0c13.3 0 24-10.7 24-24l0-336c0-13.3-10.7-24-24-24L56 16C33.9 16 16 33.9 16 56l0 360.8zm208-95.9c7.4 0 18.6-6.9 29-28.8 9-19.2 15.2-46 16.1-76.6l-90.1 0c.9 30.5 7.1 57.4 16.1 76.6 10.3 21.9 21.6 28.8 29 28.8zM178.9 200.5l90.1 0c-.9-30.5-7.1-57.4-16.1-76.6-10.3-21.9-21.6-28.8-29-28.8s-18.6 6.9-29 28.8c-9 19.2-15.2 46-16.1 76.6zm77.2 115.8c44.4-13.2 77.4-52.9 80.6-100.8l-52.6 0c-1.2 42.5-12.1 79.4-28 100.8zm28-115.8l52.6 0c-3.2-47.9-36.2-87.6-80.6-100.8 16 21.4 26.9 58.3 28 100.8zM191.9 99.7c-44.4 13.2-77.4 52.9-80.6 100.8l52.6 0c1.2-42.5 12.1-79.4 28-100.8zm0 216.6c-16-21.4-26.9-58.3-28-100.8l-52.6 0c3.2 47.9 36.2 87.6 80.6 100.8zM224 336a128 128 0 1 1 0-256 128 128 0 1 1 0 256z"]],
    "table": [448, 512, [], "f0ce", ["M16 176l0 128 200 0 0-128-200 0zm0 144l0 96c0 26.5 21.5 48 48 48l152 0 0-144-200 0zM232 176l0 128 200 0 0-128-200 0zm0 144l0 144 152 0c26.5 0 48-21.5 48-48l0-96-200 0z", "M16 160l416 0 0-64c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96l0 64zm0 16l0 128 200 0 0-128-200 0zm216 0l0 128 200 0 0-128-200 0zM216 320l-200 0 0 96c0 26.5 21.5 48 48 48l152 0 0-144zm16 144l152 0c26.5 0 48-21.5 48-48l0-96-200 0 0 144zM64 480c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480z"]],
    "circle-sort": [512, 512, ["sort-circle"], "e030", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zm137.8-46.8c-3.7-9-1.7-19.3 5.2-26.2l80-80c9.4-9.4 24.6-9.4 33.9 0l80 80c6.9 6.9 8.9 17.2 5.2 26.2S345.7 224 336 224l-160 0c-9.7 0-18.5-5.8-22.2-14.8zm0 93.6c3.7-9 12.5-14.8 22.2-14.8l160 0c9.7 0 18.5 5.8 22.2 14.8s1.7 19.3-5.2 26.2l-80 80c-9.4 9.4-24.6 9.4-33.9 0l-80-80c-6.9-6.9-8.9-17.2-5.2-26.2z", "M496 256a240 240 0 1 0 -480 0 240 240 0 1 0 480 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zM261.7 114.3c-3.1-3.1-8.2-3.1-11.3 0l-80 80c-2.3 2.3-3 5.7-1.7 8.7s4.2 4.9 7.4 4.9l160 0c3.2 0 6.2-1.9 7.4-4.9s.6-6.4-1.7-8.7l-80-80zM239 103c9.4-9.4 24.6-9.4 33.9 0l80 80c6.9 6.9 8.9 17.2 5.2 26.2S345.7 224 336 224l-160 0c-9.7 0-18.5-5.8-22.2-14.8s-1.7-19.3 5.2-26.2l80-80zm11.3 294.6c3.1 3.1 8.2 3.1 11.3 0l80-80c2.3-2.3 3-5.7 1.7-8.7s-4.2-4.9-7.4-4.9l-160 0c-3.2 0-6.2 1.9-7.4 4.9s-.6 6.4 1.7 8.7l80 80zM273 409c-9.4 9.4-24.6 9.4-33.9 0l-80-80c-6.9-6.9-8.9-17.2-5.2-26.2S166.3 288 176 288l160 0c9.7 0 18.5 5.8 22.2 14.8s1.7 19.3-5.2 26.2l-80 80z"]],
    "heart": [512, 512, [128153, 128154, 128155, 128156, 128420, 129293, 129294, 129505, 9829, 10084, 61578], "f004", ["M16 165.1c0 60.1 36.9 115.8 75.4 162.7 43.1 52.4 95.4 98 131.2 125.4 9.3 7.1 21 10.8 33.4 10.8s24.1-3.7 33.4-10.8c35.8-27.4 88.1-73 131.2-125.4 38.6-46.9 75.4-102.6 75.4-162.7 0-64.7-52.4-117.1-117.1-117.1-37.6 0-72.9 18-94.9 48.5l-21.5 29.7c-1.5 2.1-3.9 3.3-6.5 3.3s-5-1.2-6.5-3.3L228 96.5C206 66 170.7 48 133.1 48 68.4 48 16 100.4 16 165.1z", "M378.9 48C341.3 48 306 66 284 96.5l-21.5 29.7c-1.5 2.1-3.9 3.3-6.5 3.3s-5-1.2-6.5-3.3L228 96.5c-22-30.5-57.3-48.5-94.9-48.5-64.7 0-117.1 52.4-117.1 117.1 0 60.1 36.9 115.8 75.4 162.7 43.1 52.4 95.4 98 131.2 125.4 9.3 7.1 21 10.8 33.4 10.8s24.1-3.7 33.4-10.8c35.8-27.4 88.1-73 131.2-125.4 38.6-46.9 75.4-102.6 75.4-162.7 0-64.7-52.4-117.1-117.1-117.1zM271 87.1c25-34.6 65.2-55.1 107.9-55.1 73.5 0 133.1 59.6 133.1 133.1 0 66.2-40.4 125.8-79.1 172.8-44.1 53.6-97.3 100.1-133.8 127.9-12.4 9.4-27.6 14.1-43.1 14.1s-30.8-4.6-43.1-14.1C176.4 438 123.2 391.5 79.1 338 40.4 290.9 0 231.3 0 165.1 0 91.6 59.6 32 133.1 32 175.8 32 216 52.5 241 87.1l15 20.7 15-20.7z"]],
    "scythe": [576, 512, [], "f710", ["M21.9 208l489.5 0 46.5-192-245 0C201.3 16 98.3 75.5 42.6 172.1L21.9 208z", "M42.6 172.1l-20.7 35.9 489.5 0 46.5-192-245 0C201.3 16 98.3 75.5 42.6 172.1zM492 288L507.5 224 8 224c-2.9 0-5.5-1.5-6.9-4s-1.4-5.5 0-8l27.6-47.9C87.3 62.6 195.6 0 312.8 0L568 0c2.5 0 4.8 1.1 6.3 3.1s2.1 4.4 1.5 6.8l-120 496c-1 4.3-5.4 6.9-9.7 5.9s-6.9-5.4-5.9-9.7L488.2 304 328 304c-4.4 0-8-3.6-8-8s3.6-8 8-8l164 0z"]],
    "circle-chevron-up": [512, 512, ["chevron-circle-up"], "f139", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zm114.3 26.3l120-120c3.1-3.1 8.2-3.1 11.3 0l120 120c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L256 179.3 141.7 293.7c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3z", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM381.7 282.3l-120-120c-3.1-3.1-8.2-3.1-11.3 0l-120 120c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L256 179.3 370.3 293.7c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3z"]],
    "apostrophe": [192, 512, [], "27", ["M16 104l0 48c0 30.9 25.1 56 56 56l48 0c30.9 0 56-25.1 56-56l0-48c0-30.9-25.1-56-56-56L72 48c-30.9 0-56 25.1-56 56z", "M80 352c61.9 0 112-50.1 112-112l0-136c0-39.8-32.2-72-72-72L72 32C32.2 32 0 64.2 0 104l0 48c0 39.8 32.2 72 72 72l48 0c22.6 0 42.8-10.4 56-26.7l0 42.7c0 53-43 96-96 96l-8 0c-4.4 0-8 3.6-8 8s3.6 8 8 8l8 0zm96-200c0 30.9-25.1 56-56 56l-48 0c-30.9 0-56-25.1-56-56l0-48c0-30.9 25.1-56 56-56l48 0c30.9 0 56 25.1 56 56l0 48z"]],
    "battery-half": [640, 512, ["battery-3"], "f242", ["M128 176l0 160c0 8.8 7.2 16 16 16l144 0c8.8 0 16-7.2 16-16l0-160c0-8.8-7.2-16-16-16l-144 0c-8.8 0-16 7.2-16 16z", "M512 80c35.3 0 64 28.7 64 64l0 224c0 35.3-28.7 64-64 64l-400 0c-35.3 0-64-28.7-64-64l0-224c0-35.3 28.7-64 64-64l400 0zm80 288l0-32 16 0c17.7 0 32-14.3 32-32l0-96c0-17.7-14.3-32-32-32l-16 0 0-32c0-44.2-35.8-80-80-80L112 64c-44.2 0-80 35.8-80 80l0 224c0 44.2 35.8 80 80 80l400 0c44.2 0 80-35.8 80-80zm0-48l0-128 16 0c8.8 0 16 7.2 16 16l0 96c0 8.8-7.2 16-16 16l-16 0zM144 160l144 0c8.8 0 16 7.2 16 16l0 160c0 8.8-7.2 16-16 16l-144 0c-8.8 0-16-7.2-16-16l0-160c0-8.8 7.2-16 16-16zm-32 16l0 160c0 17.7 14.3 32 32 32l144 0c17.7 0 32-14.3 32-32l0-160c0-17.7-14.3-32-32-32l-144 0c-17.7 0-32 14.3-32 32z"]],
    "font-awesome": [512, 512, [62501, 62694, "font-awesome-flag", "font-awesome-logo-full"], "f2b4", ["M48 112l0 320 421.6 0c5.7 0 10.4-4.7 10.4-10.4 0-1.5-.3-2.9-.9-4.2L417.4 278.5c-1.8-4.1-1.8-8.9 0-13l61.7-138.9c.6-1.3 .9-2.8 .9-4.2 0-5.7-4.7-10.4-10.4-10.4L48 112z", "M102.8 56a38.8 38.8 0 1 0 -77.5 0 38.8 38.8 0 1 0 77.5 0zM32 512l0-410C17.5 91.8 8 75 8 56 8 25.1 33.1 0 64 0s56 25.1 56 56c0 15.7-6.4 29.8-16.8 40l366.4 0c14.6 0 26.4 11.8 26.4 26.4 0 3.7-.8 7.3-2.3 10.7-7.3-3.2-7.3-3.2 0 0l-61.7 138.9 61.7 138.9 0 0c1.5 3.4 2.3 7 2.3 10.7 0 14.6-11.8 26.4-26.4 26.4l-421.6 0 0 64-16 0zm16-80l421.6 0c5.7 0 10.4-4.7 10.4-10.4 0-1.5-.3-2.9-.9-4.2L417.4 278.5c-1.8-4.1-1.8-8.9 0-13l61.7-138.9c.6-1.3 .9-2.8 .9-4.2 0-5.7-4.7-10.4-10.4-10.4L48 112 48 432z"]],
    "handcuffs": [576, 512, [], "e4f8", ["", "M304-32c0 8.8-7.2 16-16 16s-16-7.2-16-16 7.2-16 16-16 16 7.2 16 16zM192 16a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm-64 88l0 34.9c20-7.1 41.6-10.9 64-10.9s44 3.8 64 10.9l0-34.9c0-4.4-3.6-8-8-8L136 96c-4.4 0-8 3.6-8 8zm-16 41.4l0-41.4c0-13.3 10.7-24 24-24l112 0c13.3 0 24 10.7 24 24l0 41.4c66.1 30.3 112 97.1 112 174.6 0 106-86 192-192 192S0 426 0 320c0-77.5 45.9-144.3 112-174.6zM192 496a176 176 0 1 0 0-352 176 176 0 1 0 0 352zM48 320a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zM192 448a128 128 0 1 0 0-256 128 128 0 1 0 0 256zM326.4 96c-1.1-5.6-2.8-10.9-5.1-16L440 80c13.3 0 24 10.7 24 24l0 41.4c66.1 30.3 112 97.1 112 174.6 0 106-86 192-192 192-14.4 0-28.5-1.6-42-4.6 5.3-4.2 10.4-8.7 15.3-13.4 8.7 1.3 17.6 2 26.7 2 97.2 0 176-78.8 176-176S481.2 144 384 144c-9.1 0-18 .7-26.7 2-4.9-4.7-10-9.1-15.3-13.4 13.5-3 27.6-4.6 42-4.6 22.4 0 44 3.8 64 10.9l0-34.9c0-4.4-3.6-8-8-8L326.4 96zm69 96.5c-3.6-5.7-7.3-11.2-11.4-16.5 79.5 0 144 64.5 144 144S463.5 464 384 464c4-5.3 7.8-10.8 11.4-16.5 65.4-5.8 116.6-60.6 116.6-127.5S460.7 198.3 395.4 192.5zM384 16a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"]],
    "square-bangladeshi-taka": [448, 512, [], "e744", ["M16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96zm98.3 128c0-4.4 3.6-8 8-8l45.7 0 0-41c0-14-10.1-25.9-23.9-28.2l-17.4-2.9c-4.4-.7-7.3-4.8-6.6-9.2s4.8-7.3 9.2-6.6l17.4 2.9c21.5 3.6 37.2 22.2 37.2 44l0 41 32 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-32 0 0 107.4c0 15.8 12.8 28.6 28.6 28.6l3.4 0c57.4 0 104-46.6 104-104l0-3.4c0-15.8-12.8-28.6-28.6-28.6L280 232c-4.4 0-8-3.6-8-8s3.6-8 8-8l11.4 0c24.6 0 44.6 20 44.6 44.6l0 3.4c0 66.3-53.7 120-120 120l-3.4 0C188 384 168 364 168 339.4l0-107.4-45.7 0c-4.4 0-8-3.6-8-8z", "M64 48C37.5 48 16 69.5 16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm120.1 38.7c.7-4.4 4.8-7.3 9.2-6.6l17.4 2.9c21.5 3.6 37.2 22.2 37.2 44l0 41 32 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-32 0 0 107.4c0 15.8 12.8 28.6 28.6 28.6l3.4 0c57.4 0 104-46.6 104-104l0-3.4c0-15.8-12.8-28.6-28.6-28.6L280 232c-4.4 0-8-3.6-8-8s3.6-8 8-8l11.4 0c24.6 0 44.6 20 44.6 44.6l0 3.4c0 66.3-53.7 120-120 120l-3.4 0C188 384 168 364 168 339.4l0-107.4-45.7 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l45.7 0 0-41c0-14-10.1-25.9-23.9-28.2l-17.4-2.9c-4.4-.7-7.3-4.8-6.6-9.2z"]],
    "hat-cowboy-side": [640, 512, [], "f8c1", ["M16 370.8L16 386c0 25.4 20.6 46 46 46l440.4 0-240.7-166.6C230.3 243.6 193 232 154.8 232 78.2 232 16 294.2 16 370.8zM167.5 216l305 0-26.7-120.2c-6.2-27.9-31-47.8-59.6-47.8l-1 0c-8.8 0-17.5 2.1-25.5 6-25 12.5-54.5 12.5-79.5 0-7.9-4-16.6-6-25.5-6l-1 0c-28.6 0-53.4 19.9-59.6 47.8L167.5 216zm325.2 17.1L536.9 432 578 432c25.3 0 46-21 46-46.5 0-77-57.2-141.7-131.2-152.1l-.1-.4z", "M253.8 48l1 0c8.8 0 17.5 2.1 25.5 6 25 12.5 54.5 12.5 79.5 0 7.9-4 16.6-6 25.5-6l1 0c28.6 0 53.4 19.9 59.6 47.8l26.7 120.2-305 0 26.7-120.2c6.2-27.9 31-47.8 59.6-47.8zM536.9 432L492.8 233.4C566.8 243.8 624 308.5 624 385.5 624 411 603.3 432 578 432l-41.1 0zM472 232c1.4 0 2.7 0 4.1 .1l42.6 191.8-247.8-171.6c-11.6-8-24-14.8-36.8-20.2l238 0zm17.1-15.1L461.4 92.3C453.6 57.1 422.3 32 386.2 32l-1 0c-11.3 0-22.5 2.6-32.6 7.7-20.5 10.3-44.7 10.3-65.2 0-10.1-5.1-21.3-7.7-32.6-7.7l-1 0c-36.1 0-67.4 25.1-75.2 60.3L151.1 216C67.3 218 0 286.6 0 370.8L0 386c0 34.2 27.8 62 62 62l516 0c34.3 0 62-28.4 62-62.5 0-86.9-66.1-159.9-150.9-168.6zM154.8 232c38.2 0 75.5 11.6 106.9 33.4L502.4 432 62 432c-25.4 0-46-20.6-46-46l0-15.2C16 294.2 78.2 232 154.8 232z"]],
    "sausage": [512, 512, [], "f820", ["M16 388.9l0 70.1 20.4-10.2c4-2 8.8-.4 10.7 3.6 .3 .5 .5 1 .6 1.6l0-60c-.1 .5-.3 1.1-.6 1.6-2 4-6.8 5.6-10.7 3.6L16 388.9zM80 424c0 39.8 32.2 72 72 72 92.8 0 178.4-42.5 239.9-104.1S496 244.8 496 152c0-39.8-32.2-72-72-72s-72 32.2-72 72c0 48.6-22.8 99-61.9 138.1S200.6 352 152 352c-39.8 0-72 32.2-72 72zm80-32c0-4.4 3.6-8 8-8 119.3 0 216-96.7 216-216 0-4.4 3.6-8 8-8s8 3.6 8 8c0 128.1-103.9 232-232 232-4.4 0-8-3.6-8-8zM388.9 16l10.2 20.4c2 4 .4 8.8-3.6 10.7-.7 .3-1.4 .6-2.2 .7l61.2 0c-.7-.1-1.5-.4-2.2-.7-4-2-5.6-6.8-3.6-10.7l10.2-20.4-70.1 0z", "M369.2 3.8c1.5-2.4 4-3.8 6.8-3.8l96 0c2.8 0 5.3 1.4 6.8 3.8s1.6 5.3 .3 7.8l-16 32c-2 4-6.8 5.6-10.7 3.6s-5.6-6.8-3.6-10.7l10.2-20.4-70.1 0 10.2 20.4c2 4 .4 8.8-3.6 10.7s-8.8 .4-10.7-3.6l-16-32c-1.2-2.5-1.1-5.4 .3-7.8zM16 400l0 59.1 20.4-10.2c4-2 8.8-.4 10.7 3.6s.4 8.8-3.6 10.7l-32 16c-2.5 1.2-5.4 1.1-7.8-.3S0 474.8 0 472l0-96c0-2.8 1.4-5.3 3.8-6.8s5.3-1.6 7.8-.3l32 16c4 2 5.6 6.8 3.6 10.7s-6.8 5.6-10.7 3.6L16 388.9 16 400zM424 80c-39.8 0-72 32.2-72 72 0 48.6-22.8 99-61.9 138.1S200.6 352 152 352c-39.8 0-72 32.2-72 72s32.2 72 72 72c92.8 0 178.4-42.5 239.9-104.1S496 244.8 496 152c0-39.8-32.2-72-72-72zm0-16c48.6 0 88 39.4 88 88 0 97.7-44.7 187.2-108.8 251.2S249.7 512 152 512c-48.6 0-88-39.4-88-88s39.4-88 88-88c43.7 0 90.2-20.6 126.8-57.2S336 195.7 336 152c0-48.6 39.4-88 88-88zM400 168c0 128.1-103.9 232-232 232-4.4 0-8-3.6-8-8s3.6-8 8-8c119.3 0 216-96.7 216-216 0-4.4 3.6-8 8-8s8 3.6 8 8z"]],
    "chevrons-down": [448, 512, ["chevron-double-down"], "f322", ["", "M2.3 69.7l216 216c3.1 3.1 8.2 3.1 11.3 0l216-216c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0L224 268.7 13.7 58.3c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3zm0 192l216 216c3.1 3.1 8.2 3.1 11.3 0l216-216c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0L224 460.7 13.7 250.3c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3z"]],
    "industry": [512, 512, [], "f275", ["M16 72l0 352c0 22.1 17.9 40 40 40l400 0c22.1 0 40-17.9 40-40l0-271.1c0-12.2-13.2-19.9-23.8-14L331.9 217.5c-2.5 1.4-5.5 1.4-8-.1s-4-4.1-4-6.9l0-56.8c0-12.3-13.4-20-24.1-13.8L156 221.6c-2.5 1.4-5.5 1.5-8 0s-4-4.1-4-6.9L144 72c0-13.3-10.7-24-24-24L40 48C26.7 48 16 58.7 16 72z", "M40 48C26.7 48 16 58.7 16 72l0 352c0 22.1 17.9 40 40 40l400 0c22.1 0 40-17.9 40-40l0-271.1c0-12.2-13.2-19.9-23.8-14L331.9 217.5c-2.5 1.4-5.5 1.4-8-.1s-4-4.1-4-6.9l0-56.8c0-12.3-13.4-20-24.1-13.8L156 221.6c-2.5 1.4-5.5 1.5-8 0s-4-4.1-4-6.9L144 72c0-13.3-10.7-24-24-24L40 48zM0 72C0 49.9 17.9 32 40 32l80 0c22.1 0 40 17.9 40 40l0 128.7 127.9-74.6c21.3-12.4 48.1 2.9 48.1 27.6l0 43.1 128.4-71.9c21.3-11.9 47.6 3.5 47.6 27.9L512 424c0 30.9-25.1 56-56 56L56 480c-30.9 0-56-25.1-56-56L0 72z"]],
    "people-dress-simple": [512, 512, [], "e218", ["M25.2 347.3C22.1 357.6 29.8 368 40.5 368L72 368c4.4 0 8 3.6 8 8l0 88c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-88c0-4.4 3.6-8 8-8l31.5 0c10.8 0 18.5-10.4 15.3-20.7l-38-123.4c-8.8-28.5-35-47.9-64.8-47.9S72 195.4 63.2 223.9l-38 123.4zM80 64a48 48 0 1 0 96 0 48 48 0 1 0 -96 0zM281.2 347.3c-3.2 10.3 4.5 20.7 15.3 20.7l31.5 0c4.4 0 8 3.6 8 8l0 88c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-88c0-4.4 3.6-8 8-8l31.5 0c10.8 0 18.5-10.4 15.3-20.7l-38-123.4c-8.8-28.5-35-47.9-64.8-47.9s-56.1 19.4-64.8 47.9l-38 123.4zM336 64a48 48 0 1 0 96 0 48 48 0 1 0 -96 0z", "M128 112a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM128 0a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm0 176c-29.8 0-56.1 19.4-64.8 47.9l-38 123.4C22.1 357.6 29.8 368 40.5 368L72 368c4.4 0 8 3.6 8 8l0 88c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-88c0-4.4 3.6-8 8-8l31.5 0c10.8 0 18.5-10.4 15.3-20.7l-38-123.4c-8.8-28.5-35-47.9-64.8-47.9zM47.9 219.2C58.7 184 91.2 160 128 160s69.3 24 80.1 59.2l38 123.4c6.3 20.6-9.1 41.4-30.6 41.4l-23.5 0 0 80c0 26.5-21.5 48-48 48l-32 0c-26.5 0-48-21.5-48-48l0-80-23.5 0C19 384 3.6 363.2 9.9 342.6l38-123.4zM384 112a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM384 0a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm0 176c-29.8 0-56.1 19.4-64.8 47.9l-38 123.4c-3.2 10.3 4.5 20.7 15.3 20.7l31.5 0c4.4 0 8 3.6 8 8l0 88c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-88c0-4.4 3.6-8 8-8l31.5 0c10.8 0 18.5-10.4 15.3-20.7l-38-123.4c-8.8-28.5-35-47.9-64.8-47.9zm-80.1 43.2C314.7 184 347.2 160 384 160s69.3 24 80.1 59.2l38 123.4c6.3 20.6-9.1 41.4-30.6 41.4l-23.5 0 0 80c0 26.5-21.5 48-48 48l-32 0c-26.5 0-48-21.5-48-48l0-80-23.5 0c-21.5 0-36.9-20.8-30.6-41.4l38-123.4z"]],
    "lines-leaning": [384, 512, [], "e51e", ["", "M376 32c-4.4 0-8 3.6-8 8l0 432c0 4.4 3.6 8 8 8s8-3.6 8-8l0-432c0-4.4-3.6-8-8-8zm-94 .3c-4.3-1.1-8.6 1.5-9.8 5.7l-112 432c-1.1 4.3 1.5 8.6 5.7 9.8s8.6-1.5 9.8-5.7l112-432c1.1-4.3-1.5-8.6-5.7-9.8zM191.4 43c1.7-4.1-.3-8.8-4.4-10.4s-8.8 .3-10.4 4.4L.6 469c-1.7 4.1 .3 8.8 4.4 10.4s8.8-.3 10.4-4.4l176-432z"]],
    "passport": [384, 512, [], "f5ab", ["M16 64l0 384c0 26.5 21.5 48 48 48l256 0c26.5 0 48-21.5 48-48l0-384c0-26.5-21.5-48-48-48L64 16C37.5 16 16 37.5 16 64zM320 208a128 128 0 1 1 -256 0 128 128 0 1 1 256 0zM96 392c0-4.4 3.6-8 8-8l176 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-176 0c-4.4 0-8-3.6-8-8z", "M320 16c26.5 0 48 21.5 48 48l0 384c0 26.5-21.5 48-48 48L64 496c-26.5 0-48-21.5-48-48L16 64c0-26.5 21.5-48 48-48l256 0zM64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-384c0-35.3-28.7-64-64-64L64 0zM96 392c0 4.4 3.6 8 8 8l176 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-176 0c-4.4 0-8 3.6-8 8zm96-71.1c-7.4 0-18.6-6.9-29-28.8-9-19.2-15.2-46-16.1-76.6l90.1 0c-.9 30.5-7.1 57.4-16.1 76.6-10.3 21.9-21.6 28.8-29 28.8zM146.9 200.5c.9-30.5 7.1-57.4 16.1-76.6 10.3-21.9 21.6-28.8 29-28.8s18.6 6.9 29 28.8c9 19.2 15.2 46 16.1 76.6l-90.1 0zm77.2 115.8c16-21.4 26.9-58.3 28-100.8l52.6 0c-3.2 47.9-36.2 87.6-80.6 100.8zm28-115.8c-1.2-42.5-12.1-79.4-28-100.8 44.4 13.2 77.4 52.9 80.6 100.8l-52.6 0zM159.9 99.7c-16 21.4-26.9 58.3-28 100.8l-52.6 0c3.2-47.9 36.2-87.6 80.6-100.8zm0 216.6c-44.4-13.2-77.4-52.9-80.6-100.8l52.6 0c1.2 42.5 12.1 79.4 28 100.8zM192 80a128 128 0 1 0 0 256 128 128 0 1 0 0-256z"]],
    "infinity": [640, 512, [8734, 9854], "f534", ["", "M0 240.2c0-70.8 57.4-128.2 128.2-128.2 32.7 0 64.2 12.5 88 35L320 245 423.8 147c23.8-22.5 55.3-35 88-35 70.8 0 128.2 57.4 128.2 128.2l0 31.6c0 70.8-57.4 128.2-128.2 128.2-32.7 0-64.2-12.5-88-35L320 267 216.2 365c-23.8 22.5-55.3 35-88 35-70.8 0-128.2-57.4-128.2-128.2l0-31.6zM308.3 256L205.3 158.6C184.4 139 156.9 128 128.2 128 66.2 128 16 178.2 16 240.2l0 31.6c0 62 50.2 112.2 112.2 112.2 28.7 0 56.2-11 77-30.6L308.3 256zm23.3 0l103.1 97.4c20.8 19.7 48.4 30.6 77 30.6 62 0 112.2-50.2 112.2-112.2l0-31.6c0-62-50.2-112.2-112.2-112.2-28.6 0-56.2 11-77 30.6L331.7 256z"]],
    "hand-heart": [640, 512, [], "f4bc", ["M89.9 273.4c12.5-12.5 32.8-12.5 45.2 0l67.7 67.7c2.3 2.3 5.7 3 8.7 1.8s4.9-4.2 4.9-7.4l0-255.4c0-17.7 14.3-32 32-32l3.3 .2c15 1.5 27 13.5 28.6 28.6l.2 3.3 0 168c0 4.4 3.6 8 8 8s8-3.6 8-8l0-200c0-17.7 14.3-32 32-32l3.3 .2c16.1 1.6 28.7 15.3 28.7 31.8l0 200c0 4.4 3.6 8 8 8s8-3.6 8-8l0-168 .2-3.3c1.6-16.1 15.3-28.7 31.8-28.7 17.7 0 32 14.3 32 32l0 168c0 4.4 3.6 8 8 8s8-3.6 8-8l0-104c0-17.7 14.3-32 32-32s32 14.3 32 32l0 115.5c-14.3 3.5-27.9 9.5-40 17.7-20.1-13.7-44.1-21.3-69.1-21.3-67.9 0-122.9 55-122.9 122.9 0 48.9 25.2 88.6 47.1 115.7-46.8-5.1-90.9-24.8-125.9-56.5l-8-7.7-111.7-111.8c-12.5-12.5-12.5-32.8 0-45.2z", "M549.6 304c41.4 0 74.9 33.5 74.9 74.9 0 38.4-23.5 71.4-46 97-25.5 29-56.1 53.8-76.2 68.7-13 9.7-30.5 9.7-43.5 0-20.1-15-50.7-39.7-76.2-68.7-22.5-25.6-46-58.6-46-97 0-41.4 33.5-74.9 74.9-74.9 24 0 46.6 11.5 60.7 31l8.4 11.7 8.4-11.7c14.1-19.5 36.7-31 60.7-31zm0 16c-18.9 0-36.6 9.1-47.7 24.4L487 365c-1.5 2.1-3.9 3.3-6.5 3.3s-5-1.2-6.5-3.3l-14.9-20.6c-11.1-15.3-28.8-24.4-47.7-24.4-32.5 0-58.9 26.4-58.9 58.9 0 32.1 19.8 61.2 42.1 86.5 24.5 27.8 54 51.8 73.8 66.5 7.3 5.5 17 5.5 24.4 0 19.7-14.7 49.3-38.6 73.8-66.5 22.3-25.3 42.1-54.4 42.1-86.5 0-32.5-26.4-58.9-58.9-58.9zM333.4 .2c23 2.3 41.2 21 42.9 44.2 8.5-7.7 19.8-12.4 32.2-12.4 26.5 0 48 21.5 48 48l0 28.3c8.5-7.6 19.7-12.3 32-12.3 26.5 0 48 21.5 48 48l0 112.8c-5.4 .6-10.8 1.5-16 2.8l0-115.5c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 104c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-168c0-17.7-14.3-32-32-32-16.6 0-30.2 12.6-31.8 28.7l-.2 3.3 0 168c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-200c0-16.6-12.6-30.2-28.7-31.8l-3.3-.2c-17.7 0-32 14.3-32 32l0 200c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-168-.2-3.3c-1.5-15.1-13.5-27-28.6-28.6l-3.3-.2c-17.7 0-32 14.3-32 32l0 255.4c0 3.2-2 6.2-4.9 7.4s-6.4 .5-8.7-1.8l-67.7-67.7c-12.5-12.5-32.8-12.5-45.2 0s-12.5 32.8 0 45.2l111.7 111.8 8 7.7c35 31.7 79.2 51.4 125.9 56.5 3.7 4.6 7.3 8.9 10.9 13 1.2 1.4 2.5 2.8 3.8 4.2-56.2-2.3-109.7-24.2-151.4-61.8l-8.6-8.2-111.8-111.8c-18.7-18.7-18.7-49.1 0-67.9s49.1-18.7 67.9 0l54.1 54 0-236.1c0-26.5 21.5-48 48-48l4.9 .2c10.4 1.1 19.9 5.5 27.2 12.2 1.8-24.8 22.5-44.4 47.8-44.4l4.9 .2z"]],
    "clone": [512, 512, [], "f24d", ["M176 64l0 224c0 26.5 21.5 48 48 48l224 0c26.5 0 48-21.5 48-48l0-224c0-26.5-21.5-48-48-48L224 16c-26.5 0-48 21.5-48 48z", "M288 496L64 496c-26.5 0-48-21.5-48-48l0-224c0-26.5 21.5-48 48-48l48 0 0-16-48 0c-35.3 0-64 28.7-64 64L0 448c0 35.3 28.7 64 64 64l224 0c35.3 0 64-28.7 64-64l0-48-16 0 0 48c0 26.5-21.5 48-48 48zM176 288l0-224c0-26.5 21.5-48 48-48l224 0c26.5 0 48 21.5 48 48l0 224c0 26.5-21.5 48-48 48l-224 0c-26.5 0-48-21.5-48-48zm-16 0c0 35.3 28.7 64 64 64l224 0c35.3 0 64-28.7 64-64l0-224c0-35.3-28.7-64-64-64L224 0c-35.3 0-64 28.7-64 64l0 224z"]],
    "forward": [576, 512, [9193], "f04e", ["M80 72l0 368c0 9.6 5.7 18.3 14.6 22.1s19.1 1.9 26-4.7L304 281.6 304 230.4 120.6 54.7c-6.9-6.7-17.2-8.5-26-4.7S80 62.4 80 72zm240 0l0 368c0 9.6 5.7 18.3 14.6 22.1s19.1 1.9 26-4.7l192-184c4.7-4.5 7.4-10.8 7.4-17.3s-2.7-12.8-7.4-17.3l-192-184c-6.9-6.7-17.2-8.5-26-4.7S320 62.4 320 72z", "M120.6 54.7l183.4 175.8 0 51.1-183.4 175.8c-6.9 6.7-17.2 8.5-26 4.7S80 449.6 80 440L80 72c0-9.6 5.7-18.3 14.6-22.1s19.1-1.9 26 4.7zM304 208.3L131.7 43.1C120.1 32 103 28.9 88.3 35.2S64 56 64 72l0 368c0 16 9.6 30.5 24.3 36.8s31.8 3.2 43.4-7.9L304 303.7 304 440c0 16 9.6 30.5 24.3 36.8s31.8 3.2 43.4-7.9l192-184c7.9-7.5 12.3-18 12.3-28.9s-4.5-21.3-12.3-28.9l-192-184C360.1 32 343 28.9 328.3 35.2S304 56 304 72l0 136.3zM334.6 49.9c8.8-3.8 19.1-1.9 26 4.7l192 184c4.7 4.5 7.4 10.8 7.4 17.3s-2.7 12.8-7.4 17.3l-192 184c-6.9 6.7-17.2 8.5-26 4.7S320 449.6 320 440l0-368c0-9.6 5.7-18.3 14.6-22.1z"]],
    "square-r": [448, 512, [], "e27c", ["M16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96zm144 72c0-4.4 3.6-8 8-8l76 0c33.1 0 60 26.9 60 60 0 29.6-21.4 54.2-49.6 59.1l40.3 60.5c2.5 3.7 1.5 8.6-2.2 11.1s-8.6 1.5-11.1-2.2l-45.6-68.4-59.7 0 0 64c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-176zm16 8l0 88 68 0c24.3 0 44-19.7 44-44s-19.7-44-44-44l-68 0z", "M64 48C37.5 48 16 69.5 16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm168 64l76 0c33.1 0 60 26.9 60 60 0 29.6-21.4 54.2-49.6 59.1l40.3 60.5c2.5 3.7 1.5 8.6-2.2 11.1s-8.6 1.5-11.1-2.2l-45.6-68.4-59.7 0 0 64c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-176c0-4.4 3.6-8 8-8zm72 104l4 0c24.3 0 44-19.7 44-44s-19.7-44-44-44l-68 0 0 88 64 0z"]],
    "period": [128, 512, [], "2e", ["M16 416c0 26.5 21.5 48 48 48s48-21.5 48-48-21.5-48-48-48-48 21.5-48 48z", "M64 464c-26.5 0-48-21.5-48-48s21.5-48 48-48 48 21.5 48 48-21.5 48-48 48zm0 16c35.3 0 64-28.7 64-64s-28.7-64-64-64-64 28.7-64 64 28.7 64 64 64z"]],
    "m": [448, 512, [109], "4d", ["", "M5.6 32.4c3.3-1.1 6.9 .1 9 3L224 330.2 433.5 35.4c2-2.8 5.6-4 9-3S448 36.5 448 40l0 424c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-398.9-201.5 283.6c-1.5 2.1-3.9 3.4-6.5 3.4s-5-1.3-6.5-3.4L16 65.1 16 472c0 4.4-3.6 8-8 8s-8-3.6-8-8L0 40c0-3.5 2.3-6.6 5.6-7.6z"]],
    "money-check-pen": [640, 512, ["money-check-edit"], "f872", ["", "M480 80L96 80c-26.5 0-48 21.5-48 48l0 256c0 26.5 21.5 48 48 48l197.2 0c-2.4 5.2-4.4 10.5-6 16L96 448c-35.3 0-64-28.7-64-64l0-256c0-35.3 28.7-64 64-64l384 0c35.3 0 64 28.7 64 64l0 72.5c-5.4 .8-10.8 2.1-16 3.7l0-76.2c0-26.5-21.5-48-48-48zM128 296c0-4.4 3.6-8 8-8l176 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-176 0c-4.4 0-8-3.6-8-8zm8-88l304 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-304 0c-4.4 0-8-3.6-8-8s3.6-8 8-8zM336.4 527.5L393.9 516c9.3-1.9 17.8-6.4 24.5-13.1L551 370.3 493.6 312.9 361 445.5c-6.7 6.7-11.3 15.2-13.1 24.5l-11.5 57.5zM588.7 332.6c15.8-15.8 15.8-41.5 0-57.4s-41.5-15.8-57.4 0l-26.4 26.4 57.4 57.4 26.4-26.4zM320.3 526.5l11.9-59.6c2.5-12.4 8.6-23.8 17.5-32.7L520 263.9c22.1-22.1 57.9-22.1 80 0s22.1 57.9 0 80L429.7 514.2c-8.9 8.9-20.3 15-32.7 17.5l-59.6 11.9c-.9 .2-1.9 .3-2.9 .3-8 0-14.6-6.5-14.6-14.6 0-1 .1-1.9 .3-2.9z"]],
    "road-spikes": [640, 512, [], "e568", ["M80 116.8l0 219.2 112 0 0-51.2-112-168zm128 0l0 219.2 112 0 0-51.2-112-168zm128 0l0 219.2 112 0 0-51.2-112-168zm128 0l0 219.2 116.2 0c12.8 0 20.4-14.2 13.3-24.9L464 116.8z", "M580.2 336c12.8 0 20.4-14.2 13.3-24.9L464 116.8 464 336 580.2 336zM448 256l0-139.2c0-15.8 20.5-22 29.3-8.9L606.8 302.2c14.2 21.3-1.1 49.8-26.6 49.8l-244.2 0 0 0-272 0 0-235.2c0-15.8 20.5-22 29.3-8.9l98.7 148 0-139.2c0-15.8 20.5-22 29.3-8.9l98.7 148 0-139.2c0-15.8 20.5-22 29.3-8.9L448 256zm0 28.8l-112-168 0 219.2 112 0 0-51.2zM320 336l0-51.2-112-168 0 219.2 112 0zM80 116.8l0 219.2 112 0 0-51.2-112-168zM0 440c0-4.4 3.6-8 8-8l624 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L8 448c-4.4 0-8-3.6-8-8z"]],
    "fish-cooked": [576, 512, [], "f7fe", ["M19.7 120.6L46.4 247.8c1.1 5.4 1.1 11 0 16.5L19.7 391.4c-.9 4.4 2.5 8.6 7 8.6 1.6 0 3.2-.6 4.5-1.6l88.1-70.5c3.3-2.7 8.1-2.2 11 .9 22.6 25.4 52.5 51.3 85.7 70.8 33.2 19.5 69.1 32.4 103.9 32.4 55.9 0 116.2-28.8 162.9-66.2 23.2-18.6 42.7-39.1 56.4-58.6 13.8-19.7 20.9-37.6 20.9-51.2s-7.1-31.5-20.9-51.2c-13.6-19.5-33.1-40-56.4-58.6-46.6-37.3-106.9-66.2-162.9-66.2-34.8 0-70.7 12.8-103.9 32.4-33.1 19.5-63 45.4-85.7 70.8-2.8 3.2-7.6 3.6-11 .9L31.2 113.6c-1.3-1-2.8-1.6-4.5-1.6-4.5 0-7.9 4.2-7 8.6zm214.7 97.7l64-64c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3l-64 64c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3zm16 112l160-160c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3l-160 160c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3zm112 16l64-64c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3l-64 64c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3z", "M130.3 183.2c22.6-25.4 52.5-51.3 85.7-70.8 33.2-19.5 69.1-32.4 103.9-32.4 55.9 0 116.2 28.8 162.9 66.2 23.2 18.6 42.7 39.1 56.4 58.6 13.8 19.7 20.9 37.6 20.9 51.2s-7.1 31.5-20.9 51.2c-13.6 19.5-33.1 40-56.4 58.6-46.6 37.4-106.9 66.2-162.9 66.2-34.8 0-70.7-12.8-103.9-32.4-33.1-19.5-63-45.4-85.7-70.8-2.8-3.2-7.6-3.6-11-.9L31.2 398.4c-1.3 1-2.8 1.6-4.5 1.6-4.5 0-7.9-4.2-7-8.6L46.4 264.2c1.1-5.4 1.1-11 0-16.5L19.7 120.6c-.9-4.4 2.5-8.6 7-8.6 1.6 0 3.2 .6 4.5 1.6l88.1 70.5c3.3 2.7 8.1 2.3 11-.9zM319.9 64c-38.6 0-77.4 14.2-112 34.6-32.3 19-61.5 43.7-84.4 68.3L41.2 101.1C37 97.8 31.9 96 26.7 96 12 96 1 109.5 4 123.9L30.8 251.1c.7 3.3 .7 6.6 0 9.9L4 388.1c-3 14.4 8 27.9 22.7 27.9 5.3 0 10.4-1.8 14.5-5.1l82.3-65.8c22.9 24.6 52.1 49.3 84.4 68.3 34.7 20.4 73.4 34.6 112 34.6 60.9 0 124.7-31.1 172.9-69.7 24.2-19.4 44.8-40.9 59.5-61.9 14.5-20.8 23.8-41.9 23.8-60.4s-9.3-39.6-23.8-60.4c-14.6-21-35.3-42.5-59.5-61.9-48.2-38.6-112-69.7-172.9-69.7zM309.7 165.7c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0l-64 64c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l64-64zm112 16c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0l-160 160c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l160-160zm16 112c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0l-64 64c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l64-64z"]],
    "person-seat-reclined": [512, 512, [], "e21f", ["M152 72a40 40 0 1 0 80 0 40 40 0 1 0 -80 0zm29 146.6l22.2 110.8c4.5 22.4 24.2 38.6 47.1 38.6l100.5 0c13.3 0 25.3 8.3 30 20.8L417 485.6c3 8.1 11.9 12.3 20 9.6l48-16c8.4-2.8 12.9-11.9 10.1-20.2s-11.9-12.9-20.2-10.1l-18.7 6.2c-8.2 2.7-17-1.5-20-9.6l-25.5-68c-9.4-25-33.2-41.5-59.9-41.5l-60.5 0c-7.6 0-14.2-5.4-15.7-12.9L250.9 204.6c-3.3-16.6-17.9-28.6-34.9-28.6-22.5 0-39.3 20.6-34.9 42.6z", "M274.6 323.1L250.9 204.6c-3.3-16.6-17.9-28.6-34.9-28.6-22.5 0-39.3 20.6-34.9 42.6l22.2 110.8c4.5 22.4 24.2 38.6 47.1 38.6l100.5 0c13.3 0 25.3 8.3 30 20.8L417 485.6c3 8.1 11.9 12.3 20 9.6l48-16c8.4-2.8 12.9-11.9 10.1-20.2s-11.9-12.9-20.2-10.1l-18.7 6.2c-8.2 2.7-17-1.5-20-9.6l-25.5-68c-9.4-25-33.2-41.5-59.9-41.5l-60.5 0c-7.6 0-14.2-5.4-15.7-12.9zM232 72a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zM192 16a56 56 0 1 1 0 112 56 56 0 1 1 0-112zm74.5 185.5l23.7 118.5 60.5 0c33.3 0 63.2 20.7 74.9 51.9l25.5 68 18.7-6.2c16.8-5.6 34.9 3.5 40.5 20.2s-3.5 34.9-20.2 40.5l-48 16c-16.3 5.4-34-3-40.1-19.1l-36.3-96.9c-2.3-6.2-8.3-10.4-15-10.4l-100.5 0c-30.5 0-56.8-21.5-62.8-51.4L165.3 221.7c-6.4-31.9 18-61.7 50.6-61.7 24.6 0 45.8 17.4 50.6 41.5zM95.8 166.2l46.6 198c9.4 39.8 44.8 67.8 85.7 67.8l84 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-84 0c-48.3 0-90.2-33.2-101.2-80.2l-46.6-198c-1-4.3 1.7-8.6 6-9.6s8.6 1.7 9.6 6z"]],
    "mountain": [512, 512, [127956], "f6fc", ["M20.3 429.4c-3.7 6.9-3.6 15.3 .5 22.1l1.7 2.4c4.2 5.3 10.7 8.5 17.6 8.5l432 0c6.9 0 13.4-3.2 17.6-8.5l1.7-2.4c3.5-5.9 4.1-13.1 1.7-19.4l-1.2-2.7-110.9-205.4-121.5 0-61.7 61.7c-3.1 3.1-8.2 3.1-11.3 0L128.9 228.2 20.3 429.4z", "M261.5 .4C274 2.1 285.1 9.7 291.2 21l216 400c6.7 12.4 6.4 27.4-.8 39.5l-3 4.3c-6.4 8.2-15.8 13.5-26.2 14.8l-5.2 .3-432 0-5.2-.3c-10.3-1.4-19.7-6.7-26.2-14.8l-3-4.3c-6.3-10.6-7.4-23.4-3-34.7l2.2-4.8 216-400 2.9-4.6C231.2 6.2 243.2 0 256 0l5.4 .4zM259.3 224l-61.7 61.7c-3.1 3.1-8.2 3.1-11.3 0L128.9 228.2 20.3 429.4c-3.7 6.9-3.6 15.3 .5 22.1l1.7 2.4c4.2 5.3 10.7 8.5 17.6 8.5l432 0c6.9 0 13.4-3.2 17.6-8.5l1.7-2.4c3.5-5.9 4.1-13.1 1.7-19.4l-1.2-2.7-110.9-205.4-121.5 0zM256 17.6c-7 0-13.6 3.3-17.8 8.8l-2.3 3.7-99.1 183.4 55.2 55.2 58.3-58.3 1.2-1c1.3-.9 2.9-1.3 4.4-1.3l116.2 0-96.5-178.6c-3.4-6.3-9.6-10.6-16.7-11.6l-3-.2z"]],
    "circle-w": [512, 512, [], "e12c", ["M16 256a240 240 0 1 0 480 0 240 240 0 1 0 -480 0zm128.3-85.9c-1.2-4.3 1.4-8.7 5.6-9.8s8.7 1.4 9.8 5.6l40.9 149.9 47.8-150.2c1.1-3.3 4.1-5.6 7.6-5.6s6.6 2.3 7.6 5.6l47.8 150.2 40.9-149.9c1.2-4.3 5.6-6.8 9.8-5.6s6.8 5.6 5.6 9.8l-48 176c-.9 3.4-4 5.8-7.6 5.9s-6.7-2.2-7.8-5.6l-48.4-152-48.4 152c-1.1 3.4-4.2 5.6-7.8 5.6s-6.6-2.5-7.6-5.9l-48-176z", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM159.7 165.9c-1.2-4.3-5.6-6.8-9.8-5.6s-6.8 5.6-5.6 9.8l48 176c.9 3.4 4 5.8 7.6 5.9s6.7-2.2 7.8-5.6l48.4-152 48.4 152c1.1 3.4 4.2 5.6 7.8 5.6s6.6-2.5 7.6-5.9l48-176c1.2-4.3-1.4-8.7-5.6-9.8s-8.7 1.4-9.8 5.6l-40.9 149.9-47.8-150.2c-1.1-3.3-4.1-5.6-7.6-5.6s-6.6 2.3-7.6 5.6l-47.8 150.2-40.9-149.9z"]],
    "chess": [512, 512, [], "f439", ["M48 476.5c0 10.8 8.7 19.5 19.5 19.5l248.9 0c9.4 0 17.3-6.7 19.1-15.6l.4-3.9c0-3.3-.8-6.6-2.4-9.4l-1.8-2.7-51.7-64.7 0 .4-176 0 0-.4-51.7 64.7c-2.8 3.5-4.3 7.8-4.3 12.2zM80.2 119.9l-.2 2c0 1.6 .4 3.1 1 4.4l44.8 89.7 132.2 0 44.8-89.7 .7-2.1c.2-.7 .3-1.5 .3-2.3 0-4.8-3.4-8.8-7.9-9.7l-2-.2-204.2 0c-4.8 0-8.8 3.4-9.7 7.9zM112.1 384l159.9 0-15.2-152-129.4 0-15.2 152z", "M192-32c4.4 0 8 3.6 8 8l0 48 48 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-48 0 0 56 94.1 0c14.3 0 25.9 11.6 25.9 25.9 0 4-.9 8-2.7 11.6l-41.3 82.5 4 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-7.2 0 15.2 152 56.2 70.3c5 6.3 7.8 14.1 7.8 22.2 0 19.6-15.9 35.5-35.5 35.5L67.5 512c-19.6 0-35.5-15.9-35.5-35.5 0-8.1 2.7-15.9 7.8-22.2L96 384 111.2 232 104 232c-4.4 0-8-3.6-8-8s3.6-8 8-8l4 0-41.3-82.5c-1.8-3.6-2.7-7.6-2.7-11.6 0-14.3 11.6-25.9 25.9-25.9l94.1 0 0-56-48 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l48 0 0-48c0-4.4 3.6-8 8-8zM480 160c17.7 0 32 14.3 32 32l0 72c0 6.9-2.3 13.6-6.4 19.2l-41.6 55.5 0 50.9 41.5 62.2 2.8 5c2.4 5.1 3.7 10.8 3.7 16.5 0 21.4-17.3 38.7-38.7 38.7L392 512c2.4-5.1 4.3-10.4 5.6-16l75.7 0c12.5 0 22.7-10.2 22.7-22.7 0-3.4-.7-6.6-2.2-9.7l-1.7-2.9-40.5-60.7-89.5 0-12.8-16 98.6 0 0-48c0-1.7 .6-3.4 1.6-4.8l43.2-57.6c2.1-2.8 3.2-6.1 3.2-9.6l0-72c0-8.8-7.2-16-16-16l-56 0 0 40c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-40-58.3 0 8-16 122.3 0zM280 400l-176 0 0-.4-51.7 64.7c-2.8 3.5-4.3 7.8-4.3 12.2 0 10.8 8.7 19.5 19.5 19.5l248.9 0c9.4 0 17.3-6.7 19.1-15.6l.4-3.9c0-3.3-.8-6.6-2.4-9.4l-1.8-2.7-51.7-64.7 0 .4zM112.1 384l159.9 0-15.2-152-129.4 0-15.2 152zM89.9 112c-4.8 0-8.8 3.4-9.7 7.9l-.2 2c0 1.6 .4 3.1 1 4.4l44.8 89.7 132.2 0 44.8-89.7 .7-2.1c.2-.7 .3-1.5 .3-2.3 0-4.8-3.4-8.8-7.9-9.7l-2-.2-204.2 0z"]],
    "temperature-three-quarters": [320, 512, ["temperature-3", "thermometer-3", "thermometer-three-quarters"], "f2c8", ["M32 368c0 70.7 57.3 128 128 128s128-57.3 128-128c0-39.1-17.5-74.1-45.2-97.6-1.8-1.5-2.8-3.7-2.8-6.1L240 96c0-44.2-35.8-80-80-80S80 51.8 80 96l0 168.3c0 2.3-1 4.6-2.8 6.1-27.7 23.5-45.2 58.5-45.2 97.6zm64 0c0-32.6 24.4-59.6 56-63.5L152 168c0-4.4 3.6-8 8-8s8 3.6 8 8l0 136.5c31.6 3.9 56 30.9 56 63.5 0 35.3-28.7 64-64 64s-64-28.7-64-64z", "M160 16c-44.2 0-80 35.8-80 80l0 168.3c0 2.3-1 4.6-2.8 6.1-27.7 23.5-45.2 58.5-45.2 97.6 0 70.7 57.3 128 128 128s128-57.3 128-128c0-39.1-17.5-74.1-45.2-97.6-1.8-1.5-2.8-3.7-2.8-6.1L240 96c0-44.2-35.8-80-80-80zM64 96c0-53 43-96 96-96s96 43 96 96l0 164.7c29.4 26.4 48 64.7 48 107.3 0 79.5-64.5 144-144 144S16 447.5 16 368c0-42.6 18.6-81 48-107.3L64 96zm96 320c26.5 0 48-21.5 48-48s-21.5-48-48-48-48 21.5-48 48 21.5 48 48 48zm0 16c-35.3 0-64-28.7-