/*!
 * Font Awesome Pro 7.1.0 by @fontawesome - https://fontawesome.com
 * License - https://fontawesome.com/license (Commercial License)
 * Copyright 2025 Fonticons, Inc.
 */
(function () {
  'use strict';

  var _WINDOW = {};
  var _DOCUMENT = {};
  try {
    if (typeof window !== 'undefined') _WINDOW = window;
    if (typeof document !== 'undefined') _DOCUMENT = document;
  } catch (e) {} // eslint-disable-line no-empty

  var _ref = _WINDOW.navigator || {},
    _ref$userAgent = _ref.userAgent,
    userAgent = _ref$userAgent === void 0 ? '' : _ref$userAgent;
  var WINDOW = _WINDOW;
  var DOCUMENT = _DOCUMENT;
  var IS_BROWSER = !!WINDOW.document;
  var IS_DOM = !!DOCUMENT.documentElement && !!DOCUMENT.head && typeof DOCUMENT.addEventListener === 'function' && typeof DOCUMENT.createElement === 'function';
  var IS_IE = ~userAgent.indexOf('MSIE') || ~userAgent.indexOf('Trident/');

  function _arrayLikeToArray(r, a) {
    (null == a || a > r.length) && (a = r.length);
    for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e];
    return n;
  }
  function _arrayWithoutHoles(r) {
    if (Array.isArray(r)) return _arrayLikeToArray(r);
  }
  function _defineProperty(e, r, t) {
    return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, {
      value: t,
      enumerable: !0,
      configurable: !0,
      writable: !0
    }) : e[r] = t, e;
  }
  function _iterableToArray(r) {
    if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r);
  }
  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }
  function ownKeys(e, r) {
    var t = Object.keys(e);
    if (Object.getOwnPropertySymbols) {
      var o = Object.getOwnPropertySymbols(e);
      r && (o = o.filter(function (r) {
        return Object.getOwnPropertyDescriptor(e, r).enumerable;
      })), t.push.apply(t, o);
    }
    return t;
  }
  function _objectSpread2(e) {
    for (var r = 1; r < arguments.length; r++) {
      var t = null != arguments[r] ? arguments[r] : {};
      r % 2 ? ownKeys(Object(t), !0).forEach(function (r) {
        _defineProperty(e, r, t[r]);
      }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) {
        Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r));
      });
    }
    return e;
  }
  function _toConsumableArray(r) {
    return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread();
  }
  function _toPrimitive(t, r) {
    if ("object" != typeof t || !t) return t;
    var e = t[Symbol.toPrimitive];
    if (void 0 !== e) {
      var i = e.call(t, r || "default");
      if ("object" != typeof i) return i;
      throw new TypeError("@@toPrimitive must return a primitive value.");
    }
    return ("string" === r ? String : Number)(t);
  }
  function _toPropertyKey(t) {
    var i = _toPrimitive(t, "string");
    return "symbol" == typeof i ? i : i + "";
  }
  function _unsupportedIterableToArray(r, a) {
    if (r) {
      if ("string" == typeof r) return _arrayLikeToArray(r, a);
      var t = {}.toString.call(r).slice(8, -1);
      return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0;
    }
  }

  var _dt;
  var q = {
      classic: {
        fa: "solid",
        fas: "solid",
        "fa-solid": "solid",
        far: "regular",
        "fa-regular": "regular",
        fal: "light",
        "fa-light": "light",
        fat: "thin",
        "fa-thin": "thin",
        fab: "brands",
        "fa-brands": "brands"
      },
      duotone: {
        fa: "solid",
        fad: "solid",
        "fa-solid": "solid",
        "fa-duotone": "solid",
        fadr: "regular",
        "fa-regular": "regular",
        fadl: "light",
        "fa-light": "light",
        fadt: "thin",
        "fa-thin": "thin"
      },
      sharp: {
        fa: "solid",
        fass: "solid",
        "fa-solid": "solid",
        fasr: "regular",
        "fa-regular": "regular",
        fasl: "light",
        "fa-light": "light",
        fast: "thin",
        "fa-thin": "thin"
      },
      "sharp-duotone": {
        fa: "solid",
        fasds: "solid",
        "fa-solid": "solid",
        fasdr: "regular",
        "fa-regular": "regular",
        fasdl: "light",
        "fa-light": "light",
        fasdt: "thin",
        "fa-thin": "thin"
      },
      slab: {
        "fa-regular": "regular",
        faslr: "regular"
      },
      "slab-press": {
        "fa-regular": "regular",
        faslpr: "regular"
      },
      thumbprint: {
        "fa-light": "light",
        fatl: "light"
      },
      whiteboard: {
        "fa-semibold": "semibold",
        fawsb: "semibold"
      },
      notdog: {
        "fa-solid": "solid",
        fans: "solid"
      },
      "notdog-duo": {
        "fa-solid": "solid",
        fands: "solid"
      },
      etch: {
        "fa-solid": "solid",
        faes: "solid"
      },
      jelly: {
        "fa-regular": "regular",
        fajr: "regular"
      },
      "jelly-fill": {
        "fa-regular": "regular",
        fajfr: "regular"
      },
      "jelly-duo": {
        "fa-regular": "regular",
        fajdr: "regular"
      },
      chisel: {
        "fa-regular": "regular",
        facr: "regular"
      },
      utility: {
        "fa-semibold": "semibold",
        fausb: "semibold"
      },
      "utility-duo": {
        "fa-semibold": "semibold",
        faudsb: "semibold"
      },
      "utility-fill": {
        "fa-semibold": "semibold",
        faufsb: "semibold"
      }
    };
  var i = "classic",
    t = "duotone",
    d = "sharp",
    l = "sharp-duotone",
    f = "chisel",
    n = "etch",
    h = "jelly",
    o = "jelly-duo",
    u = "jelly-fill",
    g = "notdog",
    s = "notdog-duo",
    y = "slab",
    m = "slab-press",
    e = "thumbprint",
    p = "utility",
    a = "utility-duo",
    w = "utility-fill",
    x = "whiteboard",
    b = "Classic",
    c = "Duotone",
    I = "Sharp",
    F = "Sharp Duotone",
    v = "Chisel",
    S = "Etch",
    A = "Jelly",
    P = "Jelly Duo",
    j = "Jelly Fill",
    B = "Notdog",
    N = "Notdog Duo",
    k = "Slab",
    D = "Slab Press",
    T = "Thumbprint",
    C = "Utility",
    W = "Utility Duo",
    K = "Utility Fill",
    R = "Whiteboard",
    dt = (_dt = {}, _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_dt, i, b), t, c), d, I), l, F), f, v), n, S), h, A), o, P), u, j), g, B), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_dt, s, N), y, k), m, D), e, T), p, C), a, W), w, K), x, R));
  var gt = {
      classic: {
        900: "fas",
        400: "far",
        normal: "far",
        300: "fal",
        100: "fat"
      },
      duotone: {
        900: "fad",
        400: "fadr",
        300: "fadl",
        100: "fadt"
      },
      sharp: {
        900: "fass",
        400: "fasr",
        300: "fasl",
        100: "fast"
      },
      "sharp-duotone": {
        900: "fasds",
        400: "fasdr",
        300: "fasdl",
        100: "fasdt"
      },
      slab: {
        400: "faslr"
      },
      "slab-press": {
        400: "faslpr"
      },
      whiteboard: {
        600: "fawsb"
      },
      thumbprint: {
        300: "fatl"
      },
      notdog: {
        900: "fans"
      },
      "notdog-duo": {
        900: "fands"
      },
      etch: {
        900: "faes"
      },
      chisel: {
        400: "facr"
      },
      jelly: {
        400: "fajr"
      },
      "jelly-fill": {
        400: "fajfr"
      },
      "jelly-duo": {
        400: "fajdr"
      },
      utility: {
        600: "fausb"
      },
      "utility-duo": {
        600: "faudsb"
      },
      "utility-fill": {
        600: "faufsb"
      }
    };
  var _t = {
      chisel: {
        regular: "facr"
      },
      classic: {
        brands: "fab",
        light: "fal",
        regular: "far",
        solid: "fas",
        thin: "fat"
      },
      duotone: {
        light: "fadl",
        regular: "fadr",
        solid: "fad",
        thin: "fadt"
      },
      etch: {
        solid: "faes"
      },
      jelly: {
        regular: "fajr"
      },
      "jelly-duo": {
        regular: "fajdr"
      },
      "jelly-fill": {
        regular: "fajfr"
      },
      notdog: {
        solid: "fans"
      },
      "notdog-duo": {
        solid: "fands"
      },
      sharp: {
        light: "fasl",
        regular: "fasr",
        solid: "fass",
        thin: "fast"
      },
      "sharp-duotone": {
        light: "fasdl",
        regular: "fasdr",
        solid: "fasds",
        thin: "fasdt"
      },
      slab: {
        regular: "faslr"
      },
      "slab-press": {
        regular: "faslpr"
      },
      thumbprint: {
        light: "fatl"
      },
      utility: {
        semibold: "fausb"
      },
      "utility-duo": {
        semibold: "faudsb"
      },
      "utility-fill": {
        semibold: "faufsb"
      },
      whiteboard: {
        semibold: "fawsb"
      }
    };
  var qt = {
      kit: {
        fak: "kit",
        "fa-kit": "kit"
      },
      "kit-duotone": {
        fakd: "kit-duotone",
        "fa-kit-duotone": "kit-duotone"
      }
    },
    Ht = ["kit"];
  var L = "kit",
    r = "kit-duotone",
    U = "Kit",
    J = "Kit Duotone",
    $t = _defineProperty(_defineProperty({}, L, U), r, J);
  var ol = {
    kit: {
      "fa-kit": "fak"
    },
    "kit-duotone": {
      "fa-kit-duotone": "fakd"
    }
  };
  var fl = {
      kit: {
        fak: "fa-kit"
      },
      "kit-duotone": {
        fakd: "fa-kit-duotone"
      }
    };
  var ul = {
      kit: {
        kit: "fak"
      },
      "kit-duotone": {
        "kit-duotone": "fakd"
      }
    };

  var _ml;
  var l$1 = {
      GROUP: "duotone-group",
      SWAP_OPACITY: "swap-opacity",
      PRIMARY: "primary",
      SECONDARY: "secondary"
    };
  var n$1 = "classic",
    o$1 = "duotone",
    u$1 = "sharp",
    s$1 = "sharp-duotone",
    h$1 = "chisel",
    g$1 = "etch",
    y$1 = "jelly",
    e$1 = "jelly-duo",
    m$1 = "jelly-fill",
    p$1 = "notdog",
    a$1 = "notdog-duo",
    w$1 = "slab",
    b$1 = "slab-press",
    r$1 = "thumbprint",
    c$1 = "utility",
    i$1 = "utility-duo",
    x$1 = "utility-fill",
    I$1 = "whiteboard",
    F$1 = "Classic",
    v$1 = "Duotone",
    S$1 = "Sharp",
    A$1 = "Sharp Duotone",
    P$1 = "Chisel",
    j$1 = "Etch",
    B$1 = "Jelly",
    N$1 = "Jelly Duo",
    k$1 = "Jelly Fill",
    D$1 = "Notdog",
    C$1 = "Notdog Duo",
    T$1 = "Slab",
    L$1 = "Slab Press",
    W$1 = "Thumbprint",
    R$1 = "Utility",
    K$1 = "Utility Duo",
    U$1 = "Utility Fill",
    J$1 = "Whiteboard",
    ml$1 = (_ml = {}, _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_ml, n$1, F$1), o$1, v$1), u$1, S$1), s$1, A$1), h$1, P$1), g$1, j$1), y$1, B$1), e$1, N$1), m$1, k$1), p$1, D$1), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_ml, a$1, C$1), w$1, T$1), b$1, L$1), r$1, W$1), c$1, R$1), i$1, K$1), x$1, U$1), I$1, J$1));
  var E$1 = "kit",
    d$1 = "kit-duotone",
    _$1 = "Kit",
    M$1 = "Kit Duotone",
    rt$1 = _defineProperty(_defineProperty({}, E$1, _$1), d$1, M$1);
  var $t$1 = {
      classic: {
        "fa-brands": "fab",
        "fa-duotone": "fad",
        "fa-light": "fal",
        "fa-regular": "far",
        "fa-solid": "fas",
        "fa-thin": "fat"
      },
      duotone: {
        "fa-regular": "fadr",
        "fa-light": "fadl",
        "fa-thin": "fadt"
      },
      sharp: {
        "fa-solid": "fass",
        "fa-regular": "fasr",
        "fa-light": "fasl",
        "fa-thin": "fast"
      },
      "sharp-duotone": {
        "fa-solid": "fasds",
        "fa-regular": "fasdr",
        "fa-light": "fasdl",
        "fa-thin": "fasdt"
      },
      slab: {
        "fa-regular": "faslr"
      },
      "slab-press": {
        "fa-regular": "faslpr"
      },
      whiteboard: {
        "fa-semibold": "fawsb"
      },
      thumbprint: {
        "fa-light": "fatl"
      },
      notdog: {
        "fa-solid": "fans"
      },
      "notdog-duo": {
        "fa-solid": "fands"
      },
      etch: {
        "fa-solid": "faes"
      },
      jelly: {
        "fa-regular": "fajr"
      },
      "jelly-fill": {
        "fa-regular": "fajfr"
      },
      "jelly-duo": {
        "fa-regular": "fajdr"
      },
      chisel: {
        "fa-regular": "facr"
      },
      utility: {
        "fa-semibold": "fausb"
      },
      "utility-duo": {
        "fa-semibold": "faudsb"
      },
      "utility-fill": {
        "fa-semibold": "faufsb"
      }
    },
    z = {
      classic: ["fas", "far", "fal", "fat", "fad"],
      duotone: ["fadr", "fadl", "fadt"],
      sharp: ["fass", "fasr", "fasl", "fast"],
      "sharp-duotone": ["fasds", "fasdr", "fasdl", "fasdt"],
      slab: ["faslr"],
      "slab-press": ["faslpr"],
      whiteboard: ["fawsb"],
      thumbprint: ["fatl"],
      notdog: ["fans"],
      "notdog-duo": ["fands"],
      etch: ["faes"],
      jelly: ["fajr"],
      "jelly-fill": ["fajfr"],
      "jelly-duo": ["fajdr"],
      chisel: ["facr"],
      utility: ["fausb"],
      "utility-duo": ["faudsb"],
      "utility-fill": ["faufsb"]
    },
    Ht$1 = {
      classic: {
        fab: "fa-brands",
        fad: "fa-duotone",
        fal: "fa-light",
        far: "fa-regular",
        fas: "fa-solid",
        fat: "fa-thin"
      },
      duotone: {
        fadr: "fa-regular",
        fadl: "fa-light",
        fadt: "fa-thin"
      },
      sharp: {
        fass: "fa-solid",
        fasr: "fa-regular",
        fasl: "fa-light",
        fast: "fa-thin"
      },
      "sharp-duotone": {
        fasds: "fa-solid",
        fasdr: "fa-regular",
        fasdl: "fa-light",
        fasdt: "fa-thin"
      },
      slab: {
        faslr: "fa-regular"
      },
      "slab-press": {
        faslpr: "fa-regular"
      },
      whiteboard: {
        fawsb: "fa-semibold"
      },
      thumbprint: {
        fatl: "fa-light"
      },
      notdog: {
        fans: "fa-solid"
      },
      "notdog-duo": {
        fands: "fa-solid"
      },
      etch: {
        faes: "fa-solid"
      },
      jelly: {
        fajr: "fa-regular"
      },
      "jelly-fill": {
        fajfr: "fa-regular"
      },
      "jelly-duo": {
        fajdr: "fa-regular"
      },
      chisel: {
        facr: "fa-regular"
      },
      utility: {
        fausb: "fa-semibold"
      },
      "utility-duo": {
        faudsb: "fa-semibold"
      },
      "utility-fill": {
        faufsb: "fa-semibold"
      }
    },
    G$1 = ["solid", "regular", "light", "thin", "duotone", "brands", "semibold"],
    O$1 = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
    V$1 = O$1.concat([11, 12, 13, 14, 15, 16, 17, 18, 19, 20]),
    $$1 = ["aw", "fw", "pull-left", "pull-right"],
    to = [].concat(_toConsumableArray(Object.keys(z)), G$1, $$1, ["2xs", "xs", "sm", "lg", "xl", "2xl", "beat", "border", "fade", "beat-fade", "bounce", "flip-both", "flip-horizontal", "flip-vertical", "flip", "inverse", "layers", "layers-bottom-left", "layers-bottom-right", "layers-counter", "layers-text", "layers-top-left", "layers-top-right", "li", "pull-end", "pull-start", "pulse", "rotate-180", "rotate-270", "rotate-90", "rotate-by", "shake", "spin-pulse", "spin-reverse", "spin", "stack-1x", "stack-2x", "stack", "ul", "width-auto", "width-fixed", l$1.GROUP, l$1.SWAP_OPACITY, l$1.PRIMARY, l$1.SECONDARY]).concat(O$1.map(function (t) {
      return "".concat(t, "x");
    })).concat(V$1.map(function (t) {
      return "w-".concat(t);
    }));

  var NAMESPACE_IDENTIFIER = '___FONT_AWESOME___';
  var PRODUCTION = function () {
    try {
      return "production" === 'production';
    } catch (e$$1) {
      return false;
    }
  }();
  function familyProxy(obj) {
    // Defaults to the classic family if family is not available
    return new Proxy(obj, {
      get: function get(target, prop) {
        return prop in target ? target[prop] : target[i];
      }
    });
  }
  var _PREFIX_TO_STYLE = _objectSpread2({}, q);

  // We changed FACSSClassesToStyleId in the icons repo to be canonical and as such, "classic" family does not have any
  // duotone styles.  But we do still need duotone in _PREFIX_TO_STYLE below, so we are manually adding
  // {'fa-duotone': 'duotone'}
  _PREFIX_TO_STYLE[i] = _objectSpread2(_objectSpread2(_objectSpread2(_objectSpread2({}, {
    'fa-duotone': 'duotone'
  }), q[i]), qt['kit']), qt['kit-duotone']);
  var PREFIX_TO_STYLE = familyProxy(_PREFIX_TO_STYLE);
  var _STYLE_TO_PREFIX = _objectSpread2({}, _t);

  // We changed FAStyleIdToShortPrefixId in the icons repo to be canonical and as such, "classic" family does not have any
  // duotone styles.  But we do still need duotone in _STYLE_TO_PREFIX below, so we are manually adding {duotone: 'fad'}
  _STYLE_TO_PREFIX[i] = _objectSpread2(_objectSpread2(_objectSpread2(_objectSpread2({}, {
    duotone: 'fad'
  }), _STYLE_TO_PREFIX[i]), ul['kit']), ul['kit-duotone']);
  var STYLE_TO_PREFIX = familyProxy(_STYLE_TO_PREFIX);
  var _PREFIX_TO_LONG_STYLE = _objectSpread2({}, Ht$1);
  _PREFIX_TO_LONG_STYLE[i] = _objectSpread2(_objectSpread2({}, _PREFIX_TO_LONG_STYLE[i]), fl['kit']);
  var PREFIX_TO_LONG_STYLE = familyProxy(_PREFIX_TO_LONG_STYLE);
  var _LONG_STYLE_TO_PREFIX = _objectSpread2({}, $t$1);
  _LONG_STYLE_TO_PREFIX[i] = _objectSpread2(_objectSpread2({}, _LONG_STYLE_TO_PREFIX[i]), ol['kit']);
  var LONG_STYLE_TO_PREFIX = familyProxy(_LONG_STYLE_TO_PREFIX);
  var _FONT_WEIGHT_TO_PREFIX = _objectSpread2({}, gt);
  var FONT_WEIGHT_TO_PREFIX = familyProxy(_FONT_WEIGHT_TO_PREFIX);
  var RESERVED_CLASSES = [].concat(_toConsumableArray(Ht), _toConsumableArray(to));

  function bunker(fn) {
    try {
      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }
      fn.apply(void 0, args);
    } catch (e) {
      if (!PRODUCTION) {
        throw e;
      }
    }
  }

  var w$2 = WINDOW || {};
  if (!w$2[NAMESPACE_IDENTIFIER]) w$2[NAMESPACE_IDENTIFIER] = {};
  if (!w$2[NAMESPACE_IDENTIFIER].styles) w$2[NAMESPACE_IDENTIFIER].styles = {};
  if (!w$2[NAMESPACE_IDENTIFIER].hooks) w$2[NAMESPACE_IDENTIFIER].hooks = {};
  if (!w$2[NAMESPACE_IDENTIFIER].shims) w$2[NAMESPACE_IDENTIFIER].shims = [];
  var namespace = w$2[NAMESPACE_IDENTIFIER];

  function normalizeIcons(icons) {
    return Object.keys(icons).reduce(function (acc, iconName) {
      var icon = icons[iconName];
      var expanded = !!icon.icon;
      if (expanded) {
        acc[icon.iconName] = icon.icon;
      } else {
        acc[iconName] = icon;
      }
      return acc;
    }, {});
  }
  function defineIcons(prefix, icons) {
    var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    var _params$skipHooks = params.skipHooks,
      skipHooks = _params$skipHooks === void 0 ? false : _params$skipHooks;
    var normalized = normalizeIcons(icons);
    if (typeof namespace.hooks.addPack === 'function' && !skipHooks) {
      namespace.hooks.addPack(prefix, normalizeIcons(icons));
    } else {
      namespace.styles[prefix] = _objectSpread2(_objectSpread2({}, namespace.styles[prefix] || {}), normalized);
    }

    /**
     * Font Awesome 4 used the prefix of `fa` for all icons. With the introduction
     * of new styles we needed to differentiate between them. Prefix `fa` is now an alias
     * for `fas` so we'll ease the upgrade process for our users by automatically defining
     * this as well.
     */
    if (prefix === 'fas') {
      defineIcons('fa', icons);
    }
  }

  var icons = {
    "question": [504, 560, [10067, 10068, 61736], "3f", "M168 266l91 0c11.6 0 21-9.4 21-21s-9.4-21-21-21L0 224C0 84.8 112.8-28 252-28S504 84.8 504 224c0 88.1-45.2 165.6-113.7 210.7-1.7-.4-3.5-.7-5.3-.7l-84 0c-11.6 0-21 9.4-21 21s9.4 21 21 21l35 0 0 112-168 0 0-322z"],
    "minus": [560, 560, [8211, 8722, 10134, "subtract"], "f068", "M0 196l560 0 0 168-560 0z"],
    "microphone-slash": [616, 560, [], "f131", "M84.2-23.2L5 56 168.2 219.2 168.2 308c0 53.1 29.5 99.3 73.2 123 10.2 5.5 13.9 18.3 8.4 28.5s-18.3 13.9-28.5 8.4c-56.6-30.8-95.1-90.9-95.1-159.9l0-28-98 0 0 28c0 154.6 125.4 280 280 280 64.3 0 123.5-21.7 170.7-58.1l53.3 53.3 79.2-79.2-59-59c22.8-40.5 35.8-87.3 35.8-137l0-28-98 0 0 28c0 22.3-4 43.7-11.4 63.4L445 337.7c2.1-9.6 3.1-19.5 3.1-29.7l0-196c0-77.3-62.7-140-140-140-46.2 0-87.1 22.3-112.6 56.8L330 163.2c8.2 8.2 8.2 21.5 0 29.7s-21.5 8.2-29.7 0L84.2-23.2z"],
    "car": [616, 560, [128664, "automobile"], "f1b9", "M176.5 28c-38 0-71.3 25.5-81.1 62.3L70.8 182 427 182c11.6 0 21 9.4 21 21s-9.4 21-21 21l-427 0 0 112 56 0 0 224 112 0 0-84 280 0 0 84 112 0 0-224 56 0 0-112-59.5 0-35.8-133.7C510.8 53.5 477.6 28 439.5 28L176.5 28zM182 308a42 42 0 1 1 0 84 42 42 0 1 1 0-84zm210 42a42 42 0 1 1 84 0 42 42 0 1 1 -84 0z"],
    "filter": [616, 560, [], "f0b0", "M0 84l224 224 63 0c11.6 0 21 9.4 21 21s-9.4 21-21 21l-63 0 0 126 168 112 0-280 224-224 0-56-616 0 0 56z"],
    "envelope": [560, 560, [128386, 9993, 61443], "f0e0", "M560 504l0-448-560 0 0 82.8 280 159.1 164.6-93.5c10.1-5.7 22.9-2.2 28.6 7.9s2.2 22.9-7.9 28.6L290.4 340.3c-6.4 3.7-14.3 3.7-20.7 0L0 187.1 0 504 560 504z"],
    "at": [560, 560, [61946], "40", "M554.6 335c3.5-17.8 5.4-36.2 5.4-55 0-154.6-125.4-280-280-280S0 125.4 0 280 125.4 560 280 560c106 0 198.3-58.9 245.8-145.9-11.3 3.8-23.3 5.9-35.8 5.9-61.9 0-112-50.1-112-112l0-28c0-54.1-43.9-98-98-98s-98 43.9-98 98 43.9 98 98 98l7 0c11.6 0 21 9.4 21 21s-9.4 21-21 21l-7 0c-77.3 0-140-62.7-140-140s62.7-140 140-140 140 62.7 140 140l0 28c0 38.7 31.3 70 70 70 29.1 0 54-17.7 64.6-43z"],
    "truck": [616, 560, [128666, 9951], "f0d1", "M0 28l420 0 0 371c0 11.6 9.4 21 21 21s21-9.4 21-21l0-246.1 80.9 10.6c41.8 5.5 73.1 41.1 73.1 83.3l0 229.2-84 0c0 46.4-37.6 84-84 84s-84-37.6-84-84l-140 0c0 46.4-37.6 84-84 84s-84-37.6-84-84L0 476 0 28z"],
    "bell": [560, 560, [128276, 61602], "f0f3", "M84 168C84 59.8 171.8-28 280-28S476 59.8 476 168l0 168 84 112-140 0c0 77.3-62.7 140-140 140-62.7 0-115.8-41.2-133.6-98L287 490c11.6 0 21-9.4 21-21s-9.4-21-21-21L0 448 84 336 84 168z"],
    "mobile": [392, 560, [128241, "mobile-android", "mobile-phone"], "f3ce", "M0 0L392 0 392 560 0 560 0 0zM112 105c0 11.6 9.4 21 21 21l126 0c11.6 0 21-9.4 21-21s-9.4-21-21-21L133 84c-11.6 0-21 9.4-21 21zm84 371c15.5 0 28-12.5 28-28s-12.5-28-28-28-28 12.5-28 28 12.5 28 28 28z"],
    "trophy": [560, 560, [127942], "f091", "M98 56L0 56 0 196c0 46.4 37.6 84 84 84l37.6 0c16.9 47.7 54.7 85.6 102.4 102.4l0 65.6-112 0 0 112 336 0 0-112-112 0 0-65.6c47.7-16.9 85.6-54.7 102.4-102.4l37.6 0c46.4 0 84-37.6 84-84l0-140-98 0 0 119c0 11.6-9.4 21-21 21s-21-9.4-21-21l0-175-280 0 0 175c0 11.6-9.4 21-21 21s-21-9.4-21-21L98 56z"],
    "camera-slash": [616, 560, [], "e0d9", "M84.2-23.2l-79.2 79.2 23.2 23.2 0 424.8 424.8 0 79.2 79.2 79.2-79.2-23.2-23.2 0-368.8-106.4 0-33.6-84-253.4 0 275.2 275.2c8.2 8.2 8.2 21.5 0 29.7s-21.5 8.2-29.7 0L84.2-23.2z"],
    "signal-bars-fair": [616, 560, ["signal-alt-2"], "f692", "M0 504l280 0 0-308-126 0 0 203c0 11.6-9.4 21-21 21s-21-9.4-21-21l0-119-112 0 0 224z"],
    "gift": [616, 560, [127873], "f06b", "M308 84l60.8-60.8C383.7 8.3 403.8 0 424.8 0 468.5 0 504 35.5 504 79.2l0 32.8 112 0 0 112-56 0 0 308-231 0 0-259c0-11.6-9.4-21-21-21s-21 9.4-21 21l0 259-231 0 0-308-56 0 0-112 112 0 0-32.8c0-43.7 35.5-79.2 79.2-79.2 21 0 41.1 8.3 56 23.2L308 84z"],
    "gauge": [616, 560, ["dashboard", "gauge-med", "tachometer-alt-average"], "f624", "M545.6 532c44-53.3 70.4-121.5 70.4-196 0-170.1-137.9-308-308-308S0 165.9 0 336c0 74.5 26.4 142.7 70.4 196l195.5 0 56.9-208.5c3.1-11.2 14.6-17.8 25.8-14.7s17.8 14.6 14.7 25.8L309.4 532 545.6 532zM84 336a28 28 0 1 1 56 0 28 28 0 1 1 -56 0zM308 112a28 28 0 1 1 0 56 28 28 0 1 1 0-56zM476 336a28 28 0 1 1 56 0 28 28 0 1 1 -56 0zM149.6 217.2a28 28 0 1 1 39.6-39.6 28 28 0 1 1 -39.6 39.6zm316.8-39.6a28 28 0 1 1 -39.6 39.6 28 28 0 1 1 39.6-39.6z"],
    "share-nodes": [616, 560, ["share-alt"], "f1e0", "M476 196c61.9 0 112-50.1 112-112S537.9-28 476-28C415.3-28 365.8 20.4 364 80.7l-152.3 82c7.1 6.1 13.7 12.8 19.6 20 7.3 9 6 22.2-3 29.5s-22.2 6-29.5-3C178.3 184.1 147 168 112 168 50.1 168 0 218.1 0 280S50.1 392 112 392c21.6 0 41.8-6.1 58.9-16.7l152.3 82c1.5-12.3 4.5-24.5 8.9-36.1 4.1-10.8 16.2-16.3 27.1-12.2s16.3 16.2 12.2 27.1c-5.2 13.7-7.7 28.4-7.3 43.2 1.7 59.2 51.5 108.7 112 108.7 61.9 0 112-50.1 112-112S537.9 364 476 364c-21.6 0-41.8 6.1-58.9 16.7l-187-100.7 187-100.7C434.2 189.9 454.4 196 476 196z"],
    "percent": [616, 560, [62101, 62785, "percentage"], "25", "M0 154c0 97.5 76.7 177.1 173 181.8L4.8 504 84 583.2 252.2 415c4.7 96.3 84.3 173 181.8 173 100.5 0 182-81.5 182-182 0-97.5-76.7-177.1-173-181.8L611.2 56 532-23.2 363.8 145C359.1 48.7 279.5-28 182-28 81.5-28 0 53.5 0 154zm140 0a42 42 0 1 1 84 0 42 42 0 1 1 -84 0zM434 364a42 42 0 1 1 0 84 42 42 0 1 1 0-84z"],
    "magnifying-glass": [616, 560, [128269, "search"], "f002", "M504 224c0 49.3-14.2 95.3-38.6 134.2L611.2 504 532 583.2 386.2 437.4C347.3 461.8 301.3 476 252 476 112.8 476 0 363.2 0 224S112.8-28 252-28 504 84.8 504 224zM345.8 252.6c-3.4 11.1 2.9 22.8 14 26.2s22.8-2.9 26.2-14c14.5-47.8 2.9-101.9-35-139.8-54.7-54.7-143.3-54.7-198 0s-54.7 143.3 0 198c37.9 37.9 92 49.5 139.8 35 11.1-3.4 17.4-15.1 14-26.2s-15.1-17.4-26.2-14c-33.6 10.2-71.4 2-97.9-24.5-38.3-38.3-38.3-100.3 0-138.6s100.3-38.3 138.6 0c26.5 26.5 34.7 64.3 24.5 97.9z"],
    "palette": [560, 560, [127912], "f53f", "M560 280c0 24.2-3.1 47.6-8.8 70L357 350c-11.6 0-21 9.4-21 21s9.4 21 21 21l179.7 0C493.5 490.9 394.8 560 280 560 125.4 560 0 434.6 0 280S125.4 0 280 0 560 125.4 560 280zM280 140a28 28 0 1 0 0-56 28 28 0 1 0 0 56zM141.4 379A28 28 0 1 0 181 418.6 28 28 0 1 0 141.4 379zM379 181A28 28 0 1 0 418.6 141.4 28 28 0 1 0 379 181zM112 252a28 28 0 1 0 0 56 28 28 0 1 0 0-56zm69-71A28 28 0 1 0 141.4 141.4 28 28 0 1 0 181 181z"],
    "key": [616, 560, [128273], "f084", "M406 392c116 0 210-94 210-210S522-28 406-28 196 66 196 182c0 21.2 3.1 41.7 9 61l-205 205 0 140 140 0 41.2-41.2-35-35c-8.2-8.2-8.2-21.5 0-29.7s21.5-8.2 29.7 0l35 35 54.3-54.3-35-35c-8.2-8.2-8.2-21.5 0-29.7s21.5-8.2 29.7 0l35 35 50.1-50.1c19.3 5.8 39.8 9 61 9zm0-266c-30.9 0-56 25.1-56 56 0 11.6-9.4 21-21 21s-21-9.4-21-21c0-54.1 43.9-98 98-98s98 43.9 98 98-43.9 98-98 98c-11.6 0-21-9.4-21-21s9.4-21 21-21c30.9 0 56-25.1 56-56s-25.1-56-56-56z"],
    "skull": [504, 560, [128128], "f54c", "M84 476l0 84 84 0 0-63c0-11.6 9.4-21 21-21s21 9.4 21 21l0 63 84 0 0-63c0-11.6 9.4-21 21-21s21 9.4 21 21l0 63 84 0 0-84c0-52.2 35.7-96 84-108.5L504 252C504 112.8 391.2 0 252 0S0 112.8 0 252L0 367.5C48.3 380 84 423.8 84 476zm70-280a42 42 0 1 1 0 84 42 42 0 1 1 0-84zm154 42a42 42 0 1 1 84 0 42 42 0 1 1 -84 0zm-37.2 81.6l21 42c6.9 13.7-3.4 30.4-18.8 30.4l-42 0c-15.3 0-25.6-16.7-18.8-30.4l21-42c7.6-15.2 30-15.2 37.6 0z"],
    "tree": [560, 560, [127794], "f1bb", "M56 196l224-224 224 224-231 0c-11.6 0-21 9.4-21 21s9.4 21 21 21l161 0 98 98-112 0 140 140-224 0 0 112-112 0 0-112-224 0 98-98 189 0c11.6 0 21-9.4 21-21s-9.4-21-21-21l-259 0 140-140-112 0z"],
    "flower": [616, 560, [127804, 10047], "f7ff", "M434.1 98c0-69.6-56.4-126-126-126s-126 56.4-126 126c0 3 .1 6 .3 9-2.8-1.1-5.6-2.1-8.5-3.1-66.2-21.5-137.3 14.7-158.8 80.9S29.9 322.1 96.1 343.6c2.9 .9 5.8 1.8 8.7 2.5-1.9 2.3-3.8 4.7-5.6 7.1-40.9 56.3-28.4 135.1 27.9 176s135.1 28.4 176-27.9c1.8-2.5 3.5-4.9 5-7.5 1.6 2.5 3.3 5 5 7.5 40.9 56.3 119.7 68.8 176 27.9s68.8-119.7 27.9-176c-1.8-2.4-3.6-4.8-5.6-7.1 2.9-.7 5.8-1.5 8.7-2.5 66.2-21.5 102.4-92.6 80.9-158.8S508.5 82.4 442.3 103.9c-2.9 .9-5.7 2-8.5 3.1 .2-3 .3-6 .3-9zm-196 182c0 24.7 12.8 46.5 32.3 59 9.8 6.3 12.6 19.3 6.3 29s-19.3 12.6-29 6.3c-31-19.9-51.6-54.7-51.6-94.3 0-61.9 50.1-112 112-112s112 50.1 112 112c0 39.6-20.6 74.4-51.6 94.3-9.8 6.3-22.8 3.4-29-6.3s-3.4-22.8 6.3-29c19.5-12.5 32.3-34.2 32.3-59 0-38.7-31.3-70-70-70s-70 31.3-70 70z"],
    "camera": [560, 560, [62258, "camera-alt"], "f030", "M140 28l280 0 33.6 84 106.4 0 0 392-560 0 0-392 106.4 0 33.6-84zm93.9 165.5c10.2-5.5 14.1-18.2 8.6-28.4s-18.2-14.1-28.4-8.6c-44.1 23.5-74.1 70-74.1 123.5 0 77.3 62.7 140 140 140s140-62.7 140-140c0-53.5-30-100-74.1-123.5-10.2-5.5-23-1.6-28.4 8.6s-1.6 23 8.6 28.4c30.9 16.5 51.9 49.1 51.9 86.5 0 54.1-43.9 98-98 98s-98-43.9-98-98c0-37.4 21-70 51.9-86.5z"],
    "eye": [672, 560, [128065], "f06e", "M0 280L110 138.5C164.3 68.8 247.7 28 336 28S507.7 68.8 562 138.5L672 280 562 421.5C507.7 491.2 424.3 532 336 532S164.3 491.2 110 421.5L0 280zm289.9-86.5c10.2-5.5 14.1-18.2 8.6-28.4s-18.2-14.1-28.4-8.6c-44.1 23.5-74.1 70-74.1 123.5 0 77.3 62.7 140 140 140s140-62.7 140-140c0-53.5-30-100-74.1-123.5-10.2-5.5-23-1.6-28.4 8.6s-1.6 23 8.6 28.4c30.9 16.5 51.9 49.1 51.9 86.5 0 54.1-43.9 98-98 98s-98-43.9-98-98c0-37.4 21-70 51.9-86.5z"],
    "trash": [560, 560, [], "f1f8", "M84 0l392 0 0 84 84 0 0 112-84 0 0 364-392 0 0-322 259 0c11.6 0 21-9.4 21-21s-9.4-21-21-21L0 196 0 84 84 84 84 0z"],
    "equals": [560, 560, [62764], "3d", "M560 476l0-392-560 0 0 175 427 0c11.6 0 21 9.4 21 21s-9.4 21-21 21l-427 0 0 175 560 0z"],
    "expand": [504, 560, [], "f065", "M252 379l-87 87 66 66-231 0 0-231 66 66 57.3-57.3 36.9 36.9c8.2 8.2 21.5 8.2 29.7 0s8.2-21.5 0-29.7l-124.9-124.9-65 67 0-231 224 0-61.5 63.5 89.5 89.5 87-87-66-66 231 0 0 231-66-66-57.3 57.3-36.9-36.9c-8.2-8.2-21.5-8.2-29.7 0s-8.2 21.5 0 29.7l124.9 124.9 65-67 0 231-224 0 61.5-63.5-89.5-89.5z"],
    "stop": [504, 560, [9209], "f04d", "M0 28l504 0 0 504-504 0 0-504z"],
    "tv-retro": [560, 560, [128250], "f401", "M280 83L138.6-32.5 85.4 32.5 148.5 84 0 84 0 532 560 532 560 84 411.5 84 474.6 32.5 421.4-32.5 280 83zM105 168l266 0c11.6 0 21 9.4 21 21l0 238c0 11.6-9.4 21-21 21l-266 0c-11.6 0-21-9.4-21-21l0-70c0-11.6 9.4-21 21-21s21 9.4 21 21l0 49 224 0 0-196-245 0c-11.6 0-21-9.4-21-21s9.4-21 21-21zm343 56a28 28 0 1 1 56 0 28 28 0 1 1 -56 0zm28 84a28 28 0 1 1 0 56 28 28 0 1 1 0-56z"],
    "angle-left": [392, 560, [8249], "f104", "M-6.5 280L252.3 21.2 371.1 140 203.9 307.1c-8.2 8.2-8.2 21.5 0 29.7s21.5 8.2 29.7 0L260.8 309.7 371.1 420 252.3 538.8-6.5 280z"],
    "circle-half-stroke": [560, 560, [9680, "adjust"], "f042", "M280 0C125.4 0 0 125.4 0 280S125.4 560 280 560 560 434.6 560 280C560 139.6 456.7 23.4 322 3.1l0 114.2c72.5 18.6 126 84.4 126 162.7S394.5 424.1 322 442.7l0 40.3c0 11.6-9.4 21-21 21s-21-9.4-21-21L280 0z"],
    "clock": [560, 560, [128339, "clock-four"], "f017", "M280 560a280 280 0 1 0 0-560 280 280 0 1 0 0 560zm21-427l0 138.3 84.8 84.9c8.2 8.2 8.2 21.5 0 29.7s-21.5 8.2-29.7 0l-91-91c-3.9-3.9-6.2-9.3-6.2-14.8l0-147c0-11.6 9.4-21 21-21s21 9.4 21 21z"],
    "book": [448, 560, [128212], "f02d", "M84 0C37.6 0 0 37.6 0 84L0 476c0 46.4 37.6 84 84 84l364 0 0-84-343 0c-11.6 0-21-9.4-21-21s9.4-21 21-21l343 0 0-434-364 0zM189 154l154 0c11.6 0 21 9.4 21 21s-9.4 21-21 21l-154 0c-11.6 0-21-9.4-21-21s9.4-21 21-21z"],
    "paper-plane": [616, 560, [61913], "f1d8", "M560 28L0 224 218.6 339.7 356.2 202.2c8.2-8.2 21.5-8.2 29.7 0s8.2 21.5 0 29.7L248.3 369.4 364 588 560 28z"],
    "heart": [616, 560, [128153, 128154, 128155, 128156, 128420, 129293, 129294, 129505, 9829, 10084, 61578], "f004", "M278.3 82.3C245.6 49.6 205.8 28 158.4 28 70.9 28 0 98.9 0 186.4 0 228.4 16.7 268.7 46.4 298.4L308 560 569.6 298.4c29.7-29.7 46.4-70 46.4-112 0-87.5-70.9-158.4-158.4-158.4-41.7 0-82.5 16.9-112 46.4L230.2 189.8c-8.2 8.2-21.5 8.2-29.7 0s-8.2-21.5 0-29.7l77.8-77.8z"],
    "font-awesome": [560, 560, [62501, 62694, "font-awesome-flag", "font-awesome-logo-full"], "f2b4", "M140 42c0 15.8-5.2 30.3-14 42l434 0-112 196 112 196-406 0 0-259c0-11.6-9.4-21-21-21s-21 9.4-21 21l0 343-84 0 0-462C11 85.2 0 64.9 0 42 0 3.3 31.3-28 70-28s70 31.3 70 70z"],
    "clone": [560, 560, [], "f24d", "M168 0l392 0 0 392-168 0 0 168-392 0 0-392 392 0 0 91c0 11.6 9.4 21 21 21s21-9.4 21-21l0-112c0-11.6-9.4-21-21-21l-245 0 0-126z"],
    "forward": [672, 560, [9193], "f04e", "M308 532L672 280 308 28 308 202.5 56 28 56 532 266 386.6 266 301c0-11.6 9.4-21 21-21s21 9.4 21 21l0 231z"],
    "triangle": [616, 560, [9650], "f2ec", "M616 532L0 532 308 0 616 532z"],
    "star-half": [672, 560, [61731], "f089", "M138.6 551.8l197.5-103.8 0-504-98.7 200.1-220.8 32.1 159.8 155.7-37.7 219.9z"],
    "arrow-down-to-line": [448, 560, ["arrow-to-bottom"], "f33d", "M308-28l0 280 112 0 0 56-161.8 161.8c-8.2 8.2-8.2 21.5 0 29.7s21.5 8.2 29.7 0l51.5-51.5 108.6 0 0 112-448 0 0-112 168 0-140-140 0-56 112 0 0-280 168 0z"],
    "fire": [448, 560, [128293], "f06d", "M196-28L45.1 209.1C15.6 255.4 0 309.1 0 364 0 487.7 100.3 588 224 588S448 487.7 448 364l0-13.7c0-46.4-9.6-92.2-28.2-134.7L350 56 265.2 206.8c-5.7 10.1-18.5 13.7-28.6 8s-13.7-18.5-8-28.6L277.2 99.7 196-28zM154 364c0 38.7 31.3 70 70 70s70-31.3 70-70c0-11.6 9.4-21 21-21s21 9.4 21 21c0 61.9-50.1 112-112 112S112 425.9 112 364c0-11.6 9.4-21 21-21s21 9.4 21 21z"],
    "rectangle-vertical": [448, 560, ["rectangle-portrait"], "f2fb", "M448 0L448 560 0 560 0 0 448 0z"],
    "print": [560, 560, [128424, 128438, 9113], "f02f", "M140 0l280 0 0 98-175 0c-11.6 0-21 9.4-21 21s9.4 21 21 21l315 0 0 308-140 0 0 112-280 0 0-196 315 0c11.6 0 21-9.4 21-21s-9.4-21-21-21l-336 0c-11.6 0-21 9.4-21 21l0 105-98 0 0-308 140 0 0-140z"],
    "users": [560, 560, [], "f0c0", "M192 178c19.5-15.4 32-39.2 32-66 0-46.4-37.6-84-84-84S56 65.6 56 112c0 26.8 12.5 50.6 32 66-51.6 20.6-88 71.1-88 130l0 196 560 0 0-168c0-58.9-36.4-109.4-88-130 19.5-15.4 32-39.2 32-66 0-46.4-37.6-84-84-84s-84 37.6-84 84c0 26.8 12.5 50.6 32 66-22.1 8.9-41.5 23.2-56.4 41.4 6.7 19 10.4 39.4 10.4 60.7l0 63c0 11.6-9.4 21-21 21s-21-9.4-21-21l0-63c0-58.9-36.4-109.4-88-130z"],
    "alarm-clock": [616, 560, [9200], "f34e", "M67.7 231.9c-40.6-24.5-67.7-69-67.7-119.9 0-77.3 62.7-140 140-140 42.4 0 80.3 18.8 106 48.6-47.4 10.2-90.6 31.8-126.5 61.8-8.9 7.4-10.1 20.7-2.6 29.6s20.7 10.1 29.6 2.6c45.1-37.7 102.9-58.6 161.6-58.6 61.5 0 117.8 22 161.6 58.6 8.9 7.4 22.1 6.3 29.6-2.6s6.3-22.1-2.6-29.6c-35.9-30-79.1-51.7-126.5-61.8 25.7-29.7 63.6-48.6 106-48.6 77.3 0 140 62.7 140 140 0 50.9-27.1 95.4-67.7 119.9 7.6 24 11.7 49.6 11.7 76.1 0 49.3-14.2 95.3-38.6 134.2l64.2 64.2-79.2 79.2-64.2-64.2C403.3 545.8 357.3 560 308 560s-95.3-14.2-134.2-38.6l-64.2 64.2-79.2-79.2 64.2-64.2C70.2 403.3 56 357.3 56 308 56 281.5 60.1 255.9 67.7 231.9zM308 196c-11.6 0-21 9.4-21 21l0 91c0 5.6 2.2 10.9 6.2 14.8l63 63c8.2 8.2 21.5 8.2 29.7 0s8.2-21.5 0-29.7L329 299.3 329 217c0-11.6-9.4-21-21-21z"],
    "database": [448, 560, [], "f1c0", "M224-28C100.3-28 0 22.1 0 84l0 42c0 30.9 25 58.9 65.6 79.2 40.5 20.3 96.5 32.8 158.4 32.8 30.6 0 59.9-3.1 86.7-8.7 11.4-2.4 22.5 4.9 24.9 16.2s-4.9 22.5-16.2 24.9c-29.7 6.2-62 9.6-95.3 9.6-67 0-129.7-13.5-177.2-37.2-16.4-8.2-32.8-18.6-46.8-31.3L0 308c0 30.9 25 58.9 65.6 79.2 40.5 20.3 96.5 32.8 158.4 32.8 30.6 0 59.9-3.1 86.7-8.7 11.4-2.4 22.5 4.9 24.9 16.2s-4.9 22.5-16.2 24.9c-29.7 6.2-62 9.6-95.3 9.6-67 0-129.7-13.5-177.2-37.2-16.4-8.2-32.8-18.6-46.8-31.3L0 476c0 61.9 100.3 112 224 112s224-50.1 224-112l0-392C448 22.1 347.7-28 224-28z"],
    "newspaper": [560, 560, [128240], "f1ea", "M84 140L0 140 0 420c0 46.4 37.6 84 84 84l392 0c46.4 0 84-37.6 84-84l0-364-434 0 0 343c0 11.6-9.4 21-21 21s-21-9.4-21-21l0-259zm161 14l210 0c11.6 0 21 9.4 21 21s-9.4 21-21 21l-210 0c-11.6 0-21-9.4-21-21s9.4-21 21-21zm0 140l210 0c11.6 0 21 9.4 21 21s-9.4 21-21 21l-210 0c-11.6 0-21-9.4-21-21s9.4-21 21-21z"],
    "location-arrow": [616, 560, [], "f124", "M0 224L560 28 364 588 238 350 0 224z"],
    "arrow-right-to-bracket": [560, 560, ["sign-in"], "f090", "M560 560l0-560-224 0 35.1 87.7 100.5 100.5c8.2 8.2 8.2 21.5 0 29.7s-21.5 8.2-29.7 0l-133.8-133.8-56 0 0 112-252 0 0 168 252 0 0 112 56 0 102.7-102.7-74.7 186.7 224 0z"],
    "video-slash": [616, 560, [], "f4e2", "M84.2-23.2l-79.2 79.2 23.2 23.2 0 424.8 424.8 0 79.2 79.2 79.2-79.2-23.2-23.2 0-396.8-168 98 0-126-197.4 0 107.2 107.2c8.2 8.2 8.2 21.5 0 29.7s-21.5 8.2-29.7 0L84.2-23.2z"],
    "comment": [560, 560, [128489, 61669], "f075", "M0 56l560 0 0 420-252 0-168 112 0-112-140 0 0-420zM133 182c-11.6 0-21 9.4-21 21s9.4 21 21 21l294 0c11.6 0 21-9.4 21-21s-9.4-21-21-21l-294 0zm0 126c-11.6 0-21 9.4-21 21s9.4 21 21 21l294 0c11.6 0 21-9.4 21-21s-9.4-21-21-21l-294 0z"],
    "video": [560, 560, ["video-camera"], "f03d", "M0 56l392 0 0 126 168-98 0 392-126-73.5 0-101.5c0-11.6-9.4-21-21-21s-21 9.4-21 21l0 203-392 0 0-448z"],
    "clipboard": [448, 560, [128203], "f328", "M98 28l-98 0 0 532 448 0 0-532-98 0 0 35c0 11.6-9.4 21-21 21s-21-9.4-21-21l0-91-168 0 0 168 147 0c11.6 0 21 9.4 21 21s-9.4 21-21 21l-168 0c-11.6 0-21-9.4-21-21L98 28z"],
    "laptop": [616, 560, [128187], "f109", "M56 28l504 0 0 308 56 126 0 70-616 0 0-70 56-126 371 0c11.6 0 21-9.4 21-21s-9.4-21-21-21L56 294 56 28z"],
    "thumbs-down": [616, 560, [128078, 61576], "f165", "M336 588l-112-168 0-231c0-11.6-9.4-21-21-21s-21 9.4-21 21l0 231-154 0 0-364 460.8 0c41.1 0 76.1 29.7 82.9 70.2l44.3 265.8-196 0 0 112c0 46.4-37.6 84-84 84z"],
    "utensils": [672, 560, [127860, 61685, "cutlery"], "f2e7", "M224-28l-55.2 55.2 98 98c8.2 8.2 8.2 21.5 0 29.7s-21.5 8.2-29.7 0l-98-98-54.3 54.3 98 98c8.2 8.2 8.2 21.5 0 29.7s-21.5 8.2-29.7 0L55.2 140.8 0 196 136.6 332.6c19.6 19.6 46.5 27.5 71.9 23.7l-136.1 136.1 79.2 79.2 84-84 13 13c32.8 32.8 86 32.8 118.8 0l11.3-11.3-64.6-64.6c-8.2-8.2-8.2-21.5 0-29.7s21.5-8.2 29.7 0l176.6 176.6 79.2-79.2-112-112 16.4-16.4c86.4-86.4 119.1-212.8 85.4-330.3l-13-45.3-152.2 152.2c7.4 33.3 1.1 69-18.8 98.2l36.3 36.3c8.2 8.2 8.2 21.5 0 29.7s-21.5 8.2-29.7 0l-49.6-49.6c-8.1-8.1-8.2-21.1-.4-29.3 12.3-12.9 19.7-28.9 22.2-45.4 3.8-25.5-4.1-52.3-23.7-71.9L224-28z"],
    "microphone": [560, 560, [], "f130", "M280-28c-77.3 0-140 62.7-140 140l0 196c0 53.1 29.5 99.3 73.2 123 10.2 5.5 13.9 18.3 8.4 28.5s-18.3 13.9-28.5 8.4C136.5 437.1 98 377.1 98 308l0-28-98 0 0 28C0 462.6 125.4 588 280 588S560 462.6 560 308l0-28-98 0 0 28c0 69.1-38.5 129.1-95.1 159.9-10.2 5.5-22.9 1.8-28.5-8.4s-1.8-22.9 8.4-28.5c43.6-23.8 73.2-70 73.2-123l-91 0c-11.6 0-21-9.4-21-21s9.4-21 21-21l91 0 0-84-91 0c-11.6 0-21-9.4-21-21s9.4-21 21-21l91 0 0-28c0-77.3-62.7-140-140-140z"],
    "crown": [560, 560, [128081], "f521", "M135.2 179.6L0 112 28 532 532 532 560 112 424.8 179.6 458.1 249.9c5 10.5 .5 23-10 28s-23 .5-28-10L280-28 139.8 267.9c-5 10.5-17.5 15-28 10s-15-17.5-10-28l33.3-70.3zM238 378a42 42 0 1 1 84 0 42 42 0 1 1 -84 0z"],
    "arrow-up-wide-short": [560, 560, ["sort-amount-up"], "f161", "M196 0l-196 196 0 56 112 0 0 308 280 0 0-112-91 0c-11.6 0-21-9.4-21-21s9.4-21 21-21l147 0 0-105-147 0c-11.6 0-21-9.4-21-21s9.4-21 21-21l203 0 0-105-203 0c-11.6 0-21-9.4-21-21s9.4-21 21-21l259 0 0-112-364 0z"],
    "sun": [672, 560, [9728], "f185", "M427.3 59.6L336-56 244.7 59.6 98.4 42.4 115.6 188.7 0 280 115.6 371.3 98.4 517.6 244.7 500.4 336 616 427.3 500.4 573.6 517.6 556.4 371.3 672 280 556.4 188.7 573.6 42.4 427.3 59.6zM289.9 366.5c10.2 5.5 14.1 18.2 8.6 28.4s-18.2 14.1-28.4 8.6c-44.1-23.5-74.1-70-74.1-123.5 0-77.3 62.7-140 140-140s140 62.7 140 140c0 53.5-30 100-74.1 123.5-10.2 5.5-23 1.6-28.4-8.6s-1.6-23 8.6-28.4c30.9-16.5 51.9-49.1 51.9-86.5 0-54.1-43.9-98-98-98s-98 43.9-98 98c0 37.4 21 70 51.9 86.5z"],
    "image": [504, 560, [], "f03e", "M0 28l504 0 0 504-418.3 0 145.3-145.3 41.2 41.1c8.2 8.2 21.5 8.2 29.7 0l112-112c8.2-8.2 8.2-21.5 0-29.7s-21.5-8.2-29.7 0l-97.2 97.1-41.2-41.1c-8.2-8.2-21.5-8.2-29.7 0L26.3 532 0 532 0 28zM154 224a42 42 0 1 0 0-84 42 42 0 1 0 0 84z"],
    "notdef": [448, 560, [], "e1fe", "M0 33.6L158.6 231.9c7.2 9.1 20.5 10.5 29.5 3.3s10.5-20.5 3.3-29.5L26.9 0 421.1 0 256.6 205.7c-7.2 9.1-5.8 22.3 3.3 29.5s22.3 5.8 29.5-3.3L448 33.6 448 526.4 289.4 328.2c-7.2-9.1-20.5-10.5-29.5-3.3s-10.5 20.5-3.3 29.5L421.1 560 26.9 560 191.4 354.4c7.2-9.1 5.8-22.3-3.3-29.5s-22.3-5.8-29.5 3.3L0 526.4 0 33.6z"],
    "pencil": [616, 560, [9999, 61504, "pencil-alt"], "f303", "M28 560l0-168 265.2-265.2 91 91c8.2 8.2 21.5 8.2 29.7 0s8.2-21.5 0-29.7L322.8 97.2 448-28 616 140 196 560 28 560z"],
    "lightbulb": [504, 560, [128161], "f0eb", "M504 224c0 87.4-44.5 164.4-112 209.6l0 154.4-280 0 0-112 140 0c11.6 0 21-9.4 21-21l0-189 42 0c11.6 0 21-9.4 21-21s-9.4-21-21-21l-126 0c-11.6 0-21 9.4-21 21s9.4 21 21 21l42 0 0 167.6-119 0C44.5 388.4 0 311.4 0 224 0 84.8 112.8-28 252-28S504 84.8 504 224z"],
    "code": [672, 560, [], "f121", "M277.7 170.3L196.2 88.8 5 280 191.9 466.9 150.3 560.4 252.6 605.9 416.8 236.6c4.7-10.6 17.1-15.4 27.7-10.7s15.4 17.1 10.7 27.7L394.7 389.7 476.2 471.2 667.4 280 480.5 93.1 522.1-.4 419.8-45.9 255.6 323.4c-4.7 10.6-17.1 15.4-27.7 10.7s-15.4-17.1-10.7-27.7l60.5-136z"],
    "address-card": [560, 560, [62140, "contact-card", "vcard"], "f2bb", "M0 56l56 0 0 35c0 11.6 9.4 21 21 21s21-9.4 21-21l0-35 56 0 0 35c0 11.6 9.4 21 21 21s21-9.4 21-21l0-35 63 0 0 35c0 11.6 9.4 21 21 21s21-9.4 21-21l0-35 63 0 0 35c0 11.6 9.4 21 21 21s21-9.4 21-21l0-35 56 0 0 35c0 11.6 9.4 21 21 21s21-9.4 21-21l0-35 56 0 0 448-560 0 0-448zM329 238c-11.6 0-21 9.4-21 21s9.4 21 21 21l126 0c11.6 0 21-9.4 21-21s-9.4-21-21-21l-126 0zm0 98c-11.6 0-21 9.4-21 21s9.4 21 21 21l126 0c11.6 0 21-9.4 21-21s-9.4-21-21-21l-126 0zM154 266c23.2 0 42 18.8 42 42s-18.8 42-42 42c-11.6 0-21 9.4-21 21s9.4 21 21 21c46.4 0 84-37.6 84-84s-37.6-84-84-84-84 37.6-84 84c0 11.6 9.4 21 21 21s21-9.4 21-21c0-23.2 18.8-42 42-42z"],
    "angle-right": [392, 560, [8250], "f105", "M399.1 280L140.3 21.2 21.5 140 188.7 307.1c8.2 8.2 8.2 21.5 0 29.7s-21.5 8.2-29.7 0L131.8 309.7 21.5 420 140.3 538.8 399.1 280z"],
    "face-meh": [560, 560, [128528, "meh"], "f11a", "M280 560a280 280 0 1 0 0-560 280 280 0 1 0 0 560zM161 336l238 0c11.6 0 21 9.4 21 21s-9.4 21-21 21l-238 0c-11.6 0-21-9.4-21-21s9.4-21 21-21zM140 210a42 42 0 1 1 84 0 42 42 0 1 1 -84 0zm238-42a42 42 0 1 1 0 84 42 42 0 1 1 0-84z"],
    "map": [560, 560, [128506, 62072], "f279", "M378 80.5L168 28 0 84 0 532 140 485.3 140 189c0-11.6 9.4-21 21-21s21 9.4 21 21l0 290.5 210 52.5 168-56 0-448-140 46.7 0 282.3c0 11.6-9.4 21-21 21s-21-9.4-21-21l0-276.5z"],
    "thumbtack": [616, 560, [128204, 128392, "thumb-tack"], "f08d", "M276.1 109.5L448-28 616 140 452.1 344.9 515.6 408.4 436.4 487.6 328.5 379.7 28 560 208.3 259.5 100.4 151.6 179.6 72.4 384.1 277c8.2 8.2 21.5 8.2 29.7 0s8.2-21.5 0-29.7L276.1 109.5z"],
    "money-bill-wave": [616, 560, [], "f53a", "M0 84L148.4 65.5c49.8-6.2 100.3-1.2 147.9 14.6l23.4 7.8c47.6 15.9 98.1 20.9 147.9 14.6l148.4-18.5 0 171.2-93.5 11c-11.5 1.4-19.8 11.8-18.4 23.3s11.8 19.8 23.3 18.4l88.5-10.4 0 178.6-148.4 18.5c-49.8 6.2-100.3 1.2-147.9-14.6l-23.4-7.8c-47.6-15.9-98.1-20.9-147.9-14.6L0 476 0 304.9 93.5 293.9c11.5-1.4 19.8-11.8 18.4-23.3s-11.8-19.8-23.3-18.4L0 262.6 0 84zM329 217c0-11.6-9.4-21-21-21s-21 9.4-21 21l0 126c0 11.6 9.4 21 21 21s21-9.4 21-21l0-126z"],
    "folder": [672, 560, [128193, 128447, 61716, "folder-blank"], "f07b", "M56 504l0-476 196 0 56 56 280 0 0 126-371 0c-9 0-17.1 5.8-19.9 14.4l-46.7 140c-3.7 11 2.3 22.9 13.3 26.6s22.9-2.3 26.6-13.3l41.9-125.6 439.9 0-84 252-532 0z"],
    "arrow-up-from-bracket": [560, 560, [], "e09a", "M280-28l-196 196 0 56 112 0 0 145.2 70.8 28.3c10.8 4.3 16 16.5 11.7 27.3s-16.5 16-27.3 11.7l-251.2-100.5 0 224 560 0 0-224-196 78.4 0-190.4 112 0 0-56-196-196z"],
    "cloud": [672, 560, [9729], "f0c2", "M560 140c-21.2 0-41 5.9-57.8 16.1-32.5 19.6-54.2 55.2-54.2 95.9 0 19.3 4.8 37.3 13.4 53.1 5.5 10.2 1.7 22.9-8.5 28.5s-22.9 1.7-28.5-8.5c-11.8-21.8-18.4-46.7-18.4-73.1 0-60.2 34.6-112.4 85-137.7-26.9-67-92.4-114.3-169-114.3-100.5 0-182 81.5-182 182 0 24.4 4.8 47.8 13.5 69 4.4 10.7-.7 23-11.5 27.4s-23-.7-27.4-11.5C105.7 245.1 100.1 221.5 98.5 196.8 43 203.5 0 250.7 0 308l0 196 672 0 0-252c0-61.9-50.1-112-112-112z"],
    "circle": [560, 560, [128308, 128309, 128992, 128993, 128994, 128995, 128996, 9679, 9898, 9899, 11044, 61708, 61915], "f111", "M0 280a280 280 0 1 1 560 0 280 280 0 1 1 -560 0z"],
    "backward": [672, 560, [9194], "f04a", "M364 532L0 280 364 28 364 202.5 616 28 616 532 406 386.6 406 301c0-11.6-9.4-21-21-21s-21 9.4-21 21l0 231z"],
    "link": [616, 560, [128279, "chain"], "f0c1", "M462.8 405.2L558 310c37.1-37.1 58-87.5 58-140 0-109.3-88.6-198-198-198-52.5 0-102.9 20.9-140 58l-95.2 95.2 74.2 74.2c8.2 8.2 8.2 21.5 0 29.7l-110 110c-13.5 13.5-21.1 31.8-21.1 50.9 0 39.8 32.2 72 72 72 19.1 0 37.4-7.6 50.9-21.1l23.3-23.3c8.2-8.2 21.5-8.2 29.7 0s8.2 21.5 0 29.7l-23.3 23.3c-21.4 21.4-50.4 33.4-80.6 33.4-63 0-114-51-114-114 0-30.2 12-59.2 33.4-80.6l95.2-95.2-59.4-59.4-95.2 95.2c-37.1 37.1-58 87.5-58 140 0 109.3 88.6 198 198 198 52.5 0 102.9-20.9 140-58l95.2-95.2-74.2-74.2c-8.2-8.2-8.2-21.5 0-29.7l110-110c13.5-13.5 21.1-31.8 21.1-50.9 0-39.8-32.2-72-72-72-19.1 0-37.4 7.6-50.9 21.1l-23.3 23.3c-8.2 8.2-21.5 8.2-29.7 0s-8.2-21.5 0-29.7l23.3-23.3c21.4-21.4 50.4-33.4 80.6-33.4 63 0 114 51 114 114 0 30.2-12 59.2-33.4 80.6l-95.2 95.2 59.4 59.4z"],
    "backward-step": [448, 560, ["step-backward"], "f048", "M140 171.1L448 0 448 560 182 412.2 182 301c0-11.6-9.4-21-21-21s-21 9.4-21 21l0 259-140 0 0-560 140 0 0 171.1z"],
    "circle-user": [560, 560, [62142, "user-circle"], "f2bd", "M280 560c154.6 0 280-125.4 280-280S434.6 0 280 0 0 125.4 0 280c0 78.3 32.2 149.1 84 200l0-4c0-62.5 29.2-118.1 74.7-154-11.9-20.6-18.7-44.5-18.7-70 0-77.3 62.7-140 140-140s140 62.7 140 140c0 25.5-6.8 49.4-18.7 70 13.4 10.5 25.3 22.8 35.5 36.4 7 9.3 5.1 22.4-4.2 29.4s-22.4 5.1-29.4-4.2c-8-10.7-17.4-20.3-28-28.6L361 343.7c-8.2-6.5-10.4-18-5.2-27l9.1-15.7c8.3-14.4 13.1-31.1 13.1-49 0-54.1-43.9-98-98-98s-98 43.9-98 98c0 17.9 4.8 34.6 13.1 49l9.1 15.7c5.2 9 3 20.5-5.2 27L184.7 355c-35.8 28.3-58.7 72-58.7 121l0 37.9C170.2 543 223.1 560 280 560z"],
    "hand": [616, 560, [129306, 9995, "hand-paper"], "f256", "M182.2 367.6l0-339.6 98 0 0 224c0 11.6 9.4 21 21 21s21-9.4 21-21l0-280 98 0 0 280c0 11.6 9.4 21 21 21s21-9.4 21-21l0-168 98 0 0 239.9c0 130.4-105.7 236.1-236.1 236.1-55 0-108.2-19.2-150.5-54.2l-153-126.6 71.4-86.3 90.3 74.7z"],
    "thumbs-up": [616, 560, [128077, 61575], "f164", "M336-28l-112 168 0 231c0 11.6-9.4 21-21 21s-21-9.4-21-21l0-231-154 0 0 364 460.8 0c41.1 0 76.1-29.7 82.9-70.2L616 168 420 168 420 56c0-46.4-37.6-84-84-84z"],
    "building": [448, 560, [127970, 61687], "f1ad", "M0 0l448 0 0 560-203 0 0-91c0-11.6-9.4-21-21-21s-21 9.4-21 21l0 91-203 0 0-560zM126 105c0-11.6-9.4-21-21-21s-21 9.4-21 21l0 70c0 11.6 9.4 21 21 21s21-9.4 21-21l0-70zm119 0c0-11.6-9.4-21-21-21s-21 9.4-21 21l0 70c0 11.6 9.4 21 21 21s21-9.4 21-21l0-70zm119 0c0-11.6-9.4-21-21-21s-21 9.4-21 21l0 70c0 11.6 9.4 21 21 21s21-9.4 21-21l0-70zM126 273c0-11.6-9.4-21-21-21s-21 9.4-21 21l0 70c0 11.6 9.4 21 21 21s21-9.4 21-21l0-70zm119 0c0-11.6-9.4-21-21-21s-21 9.4-21 21l0 70c0 11.6 9.4 21 21 21s21-9.4 21-21l0-70zm119 0c0-11.6-9.4-21-21-21s-21 9.4-21 21l0 70c0 11.6 9.4 21 21 21s21-9.4 21-21l0-70z"],
    "gear": [616, 560, [9881, "cog"], "f013", "M146.8 454.8c25.7 23.7 56.6 41.9 90.8 52.5l14.7 80.7 112 0 14.7-80.7c34.2-10.6 65.1-28.8 90.8-52.5l77.3 27.7 56-97-62.5-53c3.8-16.9 5.8-34.4 5.8-52.5s-2-35.6-5.8-52.5l62.5-53-56-97-77.3 27.7C444 81.4 413.1 63.3 378.9 52.7l-14.7-80.7-112 0-14.7 80.7c-34.2 10.6-65.1 28.8-90.8 52.5l-77.3-27.7-56 97 62.5 53c-3.8 16.9-5.8 34.4-5.8 52.5s2 35.6 5.8 52.5l-62.5 53 56 97 77.3-27.7zM262.1 193.5c-30.9 16.5-51.9 49.1-51.9 86.5 0 54.1 43.9 98 98 98s98-43.9 98-98c0-37.4-21-70-51.9-86.5-10.2-5.5-14.1-18.2-8.6-28.4s18.2-14.1 28.4-8.6c44.1 23.5 74.1 70 74.1 123.5 0 77.3-62.7 140-140 140s-140-62.7-140-140c0-53.5 30.1-100 74.1-123.5 10.2-5.5 23-1.6 28.4 8.6s1.6 23-8.6 28.4z"],
    "circle-question": [560, 560, [62108, "question-circle"], "f059", "M0 280a280 280 0 1 1 560 0 280 280 0 1 1 -560 0zM308 420a28 28 0 1 0 -56 0 28 28 0 1 0 56 0zm-7-287c0-11.6-9.4-21-21-21s-21 9.4-21 21l0 182c0 11.6 9.4 21 21 21s21-9.4 21-21l0-182z"],
    "file": [448, 560, [128196, 128459, 61462], "f15b", "M210 0l-210 0 0 560 448 0 0-364-196-196 0 182 63 0c11.6 0 21 9.4 21 21s-9.4 21-21 21l-84 0c-11.6 0-21-9.4-21-21L210 0z"],
    "volume-slash": [616, 560, [128263], "f2e2", "M84.2-23.2l-79.2 79.2 84 84-60.8 0 0 280 84 0 140 140 56 0c57.1 0 110.1-17.1 154.4-46.4l69.6 69.6 79.2-79.2-69.6-69.6c29.3-44.3 46.4-97.3 46.4-154.4 0-154.6-125.4-280-280-280l-56 0-42.7 42.7c56.7 56.7 140.7 140.7 252 252 .5-4.8 .7-9.7 .7-14.7 0-50.4-24.2-95.1-61.6-123.2-9.3-7-11.1-20.1-4.2-29.4s20.1-11.1 29.4-4.2c47.5 35.7 78.4 92.7 78.4 156.8 0 22.2-3.7 43.6-10.5 63.5-2.3 6.9-8.1 12-15.1 13.7s-14.5-.5-19.6-5.6L84.2-23.2z"],
    "arrow-up": [448, 560, [8593], "f062", "M0 196l224-224 224 224 0 56-112 0 0 308-224 0 0-266 91 0c11.6 0 21-9.4 21-21s-9.4-21-21-21L0 252 0 196z"],
    "rectangle": [560, 560, [9644, "rectangle-landscape"], "f2fa", "M0 56l560 0 0 448-560 0z"],
    "grid": [504, 560, ["grid-3"], "e195", "M231 28L0 28 0 259 175 259c11.6 0 21 9.4 21 21s-9.4 21-21 21l-175 0 0 231 231 0 0-175c0-11.6 9.4-21 21-21s21 9.4 21 21l0 175 231 0 0-231-175 0c-11.6 0-21-9.4-21-21s9.4-21 21-21l175 0 0-231-231 0 0 175c0 11.6-9.4 21-21 21s-21-9.4-21-21l0-175z"],
    "shirt": [672, 560, [128085, "t-shirt", "tshirt"], "f553", "M0 65.3L203.6 5.9c6.5 67.4 63.3 120.1 132.4 120.1 24.2 0 46.9-6.5 66.5-17.8 10-5.8 13.5-18.7 7.7-28.7S391.5 66 381.5 71.8C368.1 79.6 352.6 84 336 84 288.1 84 248.8 47 245.3 0l202.7 0 224 65.3-28 214.7-89.3-29.8-4.6-49.1c-1.1-11.5-11.3-20-22.9-18.9s-20 11.3-18.9 22.9l30.6 326.9-405.8 0 30.6-326.9c1.1-11.5-7.4-21.8-18.9-22.9s-21.8 7.4-22.9 18.9L117.3 250.2 28 280 0 65.3z"],
    "suitcase": [616, 560, [129523], "f0f2", "M476 0l-336 0 0 399c0 11.6-9.4 21-21 21s-21-9.4-21-21l0-259-98 0 0 392 616 0 0-392-98 0 0 259c0 11.6-9.4 21-21 21s-21-9.4-21-21L476 0zM245 98l126 0c11.6 0 21 9.4 21 21s-9.4 21-21 21l-126 0c-11.6 0-21-9.4-21-21s9.4-21 21-21z"],
    "play": [560, 560, [9654], "f04b", "M56 560L56 0 560 280 56 560z"],
    "paperclip": [448, 560, [128206], "f0c6", "M84-28L0-28 0 364C0 487.7 100.3 588 224 588S448 487.7 448 364l0-238c0-85.1-68.9-154-154-154l-168 0 0 392c0 54.1 43.9 98 98 98s98-43.9 98-98l0-224c0-23.2-18.8-42-42-42s-42 18.8-42 42l0 231c0 11.6-9.4 21-21 21s-21-9.4-21-21l0-231c0-46.4 37.6-84 84-84s84 37.6 84 84l0 224c0 77.3-62.7 140-140 140S84 441.3 84 364L84-28z"],
    "signal-bars-weak": [616, 560, ["signal-alt-1"], "f691", "M0 504l0-196 112 0 0 196-112 0z"],
    "wrench": [616, 560, [128295], "f0ad", "M616 168c0 108.2-87.8 196-196 196-22.9 0-44.9-3.9-65.3-11.1L140 588 0 448 235.1 233.3c-7.2-20.4-11.1-42.4-11.1-65.3 0-108.2 87.8-196 196-196 46.6 0 89.3 16.2 123 43.4L405.2 153.2c-8.2 8.2-8.2 21.5 0 29.7s21.5 8.2 29.7 0L572.7 45C599.8 78.7 616 121.4 616 168z"],
    "life-ring": [616, 560, [], "f1cd", "M541.7 125.6l58-58-79.2-79.2-58 58C418.2 17.1 365.2 0 308.1 0S197.9 17.1 153.7 46.4l-58-58-79.2 79.2 58 58C45.2 169.8 28.1 222.9 28.1 280S45.2 390.1 74.5 434.4l-58 58 79.2 79.2 58-58C197.9 542.9 251 560 308.1 560s110.1-17.1 154.4-46.4l58 58 79.2-79.2-58-58c29.3-44.3 46.4-97.3 46.4-154.4S571 169.9 541.7 125.6zM262 366.5c10.2 5.5 14.1 18.2 8.6 28.4s-18.2 14.1-28.4 8.6c-44.1-23.5-74.1-70-74.1-123.5 0-77.3 62.7-140 140-140s140 62.7 140 140c0 53.5-30 100-74.1 123.5-10.2 5.5-23 1.6-28.4-8.6s-1.6-23 8.6-28.4c30.9-16.5 51.9-49.1 51.9-86.5 0-54.1-43.9-98-98-98s-98 43.9-98 98c0 37.4 21 70 51.9 86.5z"],
    "calendar": [504, 560, [128197, 128198], "f133", "M168 0l-112 0 0 56-56 0 0 140 371 0c11.6 0 21 9.4 21 21s-9.4 21-21 21l-371 0 0 294 504 0 0-476-56 0 0-56-112 0 0 56-168 0 0-56z"],
    "check": [616, 560, [10003, 10004], "f00c", "M623.1 140L504.3 21.2 254 271.5 282.5 300.2c8.2 8.2 8.2 21.5 0 29.7s-21.5 8.2-29.7 0L112.3 189.2-6.5 308 224.3 538.8 623.1 140z"],
    "house": [504, 560, [127968, 63498, 63500, "home", "home-alt", "home-lg-alt"], "f015", "M273 532l231 0 0-336-252-224-252 224 0 336 231 0 0-175c0-11.6 9.4-21 21-21s21 9.4 21 21l0 175z"],
    "play-pause": [560, 560, [], "e22f", "M0 56l0 448 238-119 0-56c0-11.6 9.4-21 21-21s21 9.4 21 21l0 175 119 0 0-343c0-11.6 9.4-21 21-21s21 9.4 21 21l0 343 119 0 0-448-280 0 0 140-280-140z"],
    "sliders": [560, 560, ["sliders-h"], "f1de", "M476 0l-140 0 0 84-336 0 0 168 70 0 0-49c0-11.6 9.4-21 21-21l84 0c11.6 0 21 9.4 21 21s-9.4 21-21 21l-63 0 0 84-112 0 0 168 112 0 0 84 140 0 0-84 308 0 0-168-84 0 0-56 84 0 0-168-84 0 0-84zM336 189l0 147 91 0c11.6 0 21 9.4 21 21s-9.4 21-21 21l-112 0c-11.6 0-21-9.4-21-21l0-56-49 0c-11.6 0-21-9.4-21-21s9.4-21 21-21l49 0 0-70c0-11.6 9.4-21 21-21s21 9.4 21 21z"],
    "face-frown": [560, 560, [9785, "frown"], "f119", "M280 560a280 280 0 1 0 0-560 280 280 0 1 0 0 560zM182 168a42 42 0 1 1 0 84 42 42 0 1 1 0-84zm154 42a42 42 0 1 1 84 0 42 42 0 1 1 -84 0zM178 390.3c-6.8 9.4-20 11.5-29.3 4.6s-11.5-20-4.6-29.3c30.5-42 80.1-69.3 136-69.3s105.5 27.4 136 69.3c6.8 9.4 4.7 22.5-4.6 29.3s-22.5 4.7-29.3-4.6c-22.9-31.6-60.1-52-102-52s-79.1 20.5-102 52z"],
    "forward-step": [448, 560, ["step-forward"], "f051", "M308 171.1L0 0 0 560 266 412.2 266 301c0-11.6 9.4-21 21-21s21 9.4 21 21l0 259 140 0 0-560-140 0 0 171.1z"],
    "sort": [448, 560, ["unsorted"], "f0dc", "M0 196l224-224 224 224 0 168-224 224-224-224 0-63 315 0c11.6 0 21-9.4 21-21s-9.4-21-21-21L0 259 0 196z"],
    "user": [504, 560, [128100, 62144, 62470, "user-alt", "user-large"], "f007", "M392 140c0 40.5-17.2 77.1-44.8 102.6 92 37.6 156.8 127.9 156.8 233.4l0 56-504 0 0-56C0 386.2 47 307.4 117.6 262.8 150.9 299.2 198.8 322 252 322l7 0c11.6 0 21-9.4 21-21s-9.4-21-21-21l-7 0c-36.8 0-70.3-14.2-95.2-37.4-27.5-25.6-44.8-62.1-44.8-102.6 0-77.3 62.7-140 140-140S392 62.7 392 140z"],
    "signal-bars": [616, 560, ["signal-alt", "signal-alt-4", "signal-bars-strong"], "f690", "M0 504l616 0 0-476-126 0 0 371c0 11.6-9.4 21-21 21s-21-9.4-21-21l0-287-126 0 0 287c0 11.6-9.4 21-21 21s-21-9.4-21-21l0-203-126 0 0 203c0 11.6-9.4 21-21 21s-21-9.4-21-21l0-119-112 0 0 224z"],
    "snowflake": [560, 560, [10052, 10054], "f2dc", "M395.4 38.5L280.2-28 165.1 38.5 242.4 172.5c5.8 10 2.4 22.9-7.7 28.7s-22.9 2.4-28.7-7.7l-77.4-134-115.2 66.5 0 133 154.7 0c11.6 0 21 9.4 21 21s-9.4 21-21 21l-154.7 0 0 133 115.2 66.5 77.4-134c5.8-10 18.6-13.5 28.7-7.7s13.5 18.6 7.7 28.7l-77.4 134 115.2 66.5 115.2-66.5-77.4-134c-5.8-10-2.4-22.9 7.7-28.7s22.9-2.4 28.7 7.7l77.4 134 115.2-66.5 0-133-154.7 0c-11.6 0-21-9.4-21-21s9.4-21 21-21l154.7 0 0-133-115.2-66.5-77.4 134c-5.8 10-18.6 13.5-28.7 7.7s-13.5-18.6-7.7-28.7l77.4-134z"],
    "ticket": [616, 560, [127903], "f145", "M616 56L0 56 0 196c46.4 0 84 37.6 84 84S46.4 364 0 364l0 140 616 0 0-140c-46.4 0-84-37.6-84-84s37.6-84 84-84l0-140zM189 140l98 0c11.6 0 21 9.4 21 21s-9.4 21-21 21l-77 0 0 196 196 0 0-217c0-11.6 9.4-21 21-21s21 9.4 21 21l0 238c0 11.6-9.4 21-21 21l-238 0c-11.6 0-21-9.4-21-21l0-238c0-11.6 9.4-21 21-21z"],
    "wheelchair": [560, 560, [], "f193", "M336 84l23.9-63.7C370.8-8.8 398.6-28 429.6-28 470.7-28 504 5.3 504 46.4l0 65.6-66.5 0-63 168 185.5 0-105 280-142.4 0c46.6-33.5 79.8-84.5 90.1-143.3 2-11.4-5.7-22.3-17.1-24.3s-22.3 5.7-24.3 17.1c-14.3 82.2-83.8 145.4-168.9 150.2-3.5 .2-6.9 .3-10.4 .3-100.5 0-182-81.5-182-182 0-78.3 49.5-145.1 118.9-170.8l-35 93.4c-2.4 6.4-1.5 13.7 2.4 19.3s10.4 9 17.3 9L224 329c8.8 0 16.6-5.4 19.7-13.6l42-112c4.1-10.9-1.4-23-12.3-27s-23 1.4-27 12.3l-36.9 98.4-75.6 0 55.7-148.5C201.9 105.7 233.2 84 268.2 84L336 84z"],
    "bookmark": [392, 560, [128278, 61591], "f02e", "M392-28L0-28 0 588 237.2 350.8c8.2-8.2 21.5-8.2 29.7 0s8.2 21.5 0 29.7L225.7 421.7 392 588 392-28z"],
    "bomb": [616, 560, [128163], "f1e2", "M364.2 0L306.8 57.4c-8.7-.9-17.6-1.4-26.6-1.4-139.2 0-252 112.8-252 252s112.8 252 252 252 252-112.8 252-252c0-9-.5-17.9-1.4-26.6l57.4-57.4-72.4-72.4 95.6-95.6-79.2-79.2-65.9 65.9 24.9 24.9c8.2 8.2 8.2 21.5 0 29.7s-21.5 8.2-29.7 0L364.2 0zm-231 280c11.6 0 21 9.4 21 21 0 73.5 59.5 133 133 133 11.6 0 21 9.4 21 21s-9.4 21-21 21c-96.6 0-175-78.3-175-175 0-11.6 9.4-21 21-21z"],
    "arrow-right": [672, 560, [8594], "f061", "M448 56l224 224-224 224-56 0 0-112-308 0 0-224 266 0 0 91c0 11.6 9.4 21 21 21s21-9.4 21-21l0-203 56 0z"],
    "battery-bolt": [672, 560, [], "f376", "M532 56l-504 0 0 448 504 0 0-203c0-11.6 9.4-21 21-21s21 9.4 21 21l0 119 98 0 0-280-140 0 0-84zM301 189l0 142.8 114.4-76.2c9.6-6.4 22.7-3.8 29.1 5.8s3.8 22.7-5.8 29.1l-147 98c-6.4 4.3-14.7 4.7-21.6 1S259 378.7 259 371l0-142.8-114.4 76.2c-9.7 6.4-22.7 3.8-29.1-5.8s-3.8-22.7 5.8-29.1l147-98c6.4-4.3 14.7-4.7 21.6-1S301 181.3 301 189z"],
    "buildings": [504, 560, [], "e0cc", "M0 0l252 0 0 427c0 11.6 9.4 21 21 21s21-9.4 21-21l0-371 210 84 0 420-357 0 0-91c0-11.6-9.4-21-21-21s-21 9.4-21 21l0 91-105 0 0-560zM126 84c-11.6 0-21 9.4-21 21l0 42c0 11.6 9.4 21 21 21s21-9.4 21-21l0-42c0-11.6-9.4-21-21-21zm0 140c-11.6 0-21 9.4-21 21l0 42c0 11.6 9.4 21 21 21s21-9.4 21-21l0-42c0-11.6-9.4-21-21-21zm294-28c0-11.6-9.4-21-21-21s-21 9.4-21 21l0 35c0 11.6 9.4 21 21 21s21-9.4 21-21l0-35zm0 133c0-11.6-9.4-21-21-21s-21 9.4-21 21l0 42c0 11.6 9.4 21 21 21s21-9.4 21-21l0-42z"],
    "xmark": [504, 560, [128473, 10005, 10006, 10060, 215, "close", "multiply", "remove", "times"], "f00d", "M509.8 141.4L371.2 280 509.8 418.6 391 537.4 252.4 398.8 113.8 537.4-5 418.6 133.6 280-5 141.4 113.8 22.6 296.9 205.8c8.2 8.2 21.5 8.2 29.7 0s8.2-21.5 0-29.7L282.1 131.5 391 22.6 509.8 141.4z"],
    "lock-open": [616, 560, [], "f3c1", "M476-28c-77.3 0-140 62.7-140 140l0 112-252 0 0 336 448 0 0-336-56 0c-11.6 0-21-9.4-21-21l0-91c0-11.6 9.4-21 21-21s21 9.4 21 21l0 70 119 0 0-70c0-77.3-62.7-140-140-140zM252 392c0-11.6 9.4-21 21-21l70 0c11.6 0 21 9.4 21 21s-9.4 21-21 21l-70 0c-11.6 0-21-9.4-21-21z"],
    "droplet": [504, 560, [128167, "tint"], "f043", "M84.3 149.1L252 0 419.7 149.1C473.3 196.7 504 265.1 504 336.8 504 475.5 390.7 588 252 588S0 475.5 0 336.8c0-71.8 30.7-140.1 84.3-187.7zM126 336c0-11.6-9.4-21-21-21s-21 9.4-21 21c0 92.8 75.2 168 168 168 11.6 0 21-9.4 21-21s-9.4-21-21-21c-69.6 0-126-56.4-126-126z"],
    "shop": [616, 560, ["store-alt"], "f54f", "M560 224l56 0-84-196-448 0-84 196 427 0c11.6 0 21 9.4 21 21s-9.4 21-21 21l-371 0 0 266 294 0 0-126-84 0 0 21c0 11.6-9.4 21-21 21s-21-9.4-21-21l0-42c0-11.6 9.4-21 21-21l126 0c11.6 0 21 9.4 21 21l0 147 168 0 0-308z"],
    "film": [560, 560, [127902, 62368, "film-alt", "film-simple"], "f008", "M98 56l-98 0 0 448 98 0 0-63c0-11.6 9.4-21 21-21s21 9.4 21 21l0 63 280 0 0-63c0-11.6 9.4-21 21-21s21 9.4 21 21l0 63 98 0 0-448-98 0 0 63c0 11.6-9.4 21-21 21s-21-9.4-21-21l0-63-280 0 0 63c0 11.6-9.4 21-21 21s-21-9.4-21-21l0-63zm42 161l0 126c0 11.6-9.4 21-21 21s-21-9.4-21-21l0-126c0-11.6 9.4-21 21-21s21 9.4 21 21zm322 0l0 126c0 11.6-9.4 21-21 21s-21-9.4-21-21l0-126c0-11.6 9.4-21 21-21s21 9.4 21 21z"],
    "comments": [616, 560, [128490, 61670], "f086", "M168 28l448 0 0 392-126-84 0-161c0-11.6-9.4-21-21-21l-168 0c-11.6 0-21 9.4-21 21s9.4 21 21 21l147 0 0 308-210 0-126 84 0-84-112 0 0-308 168 0 0-168z"],
    "moon": [560, 560, [127769, 9214], "f186", "M153.3 30.2C62.3 76.5 0 171 0 280 0 434.6 125.4 560 280 560S560 434.6 560 280 434.6 0 280 0c-25.6 0-50.4 3.4-74 9.9-15.4 33.2-24 70.1-24 109.1 0 129.8 95.5 237.4 220.1 256.1 11.5 1.7 19.4 12.4 17.6 23.9s-12.4 19.4-23.9 17.6C251 394.9 140 269.9 140 119 140 88.1 144.7 58.3 153.3 30.2z"],
    "plane": [616, 560, [], "f072", "M255.2 12.6L210 182 210 259c0 11.6-9.4 21-21 21s-21-9.4-21-21l0-63-168 84 0 84 219.9 0 21.6 91.7-101.5 20.3 0 84 336 0 0-84-101.5-20.3 21.6-91.7 219.9 0 0-84-168-84 0 63c0 11.6-9.4 21-21 21s-21-9.4-21-21l0-77-45.2-169.4C354.4-11.3 332.8-28 308-28s-46.4 16.7-52.8 40.6z"],
    "images": [560, 560, [], "f302", "M168 0l392 0 0 110.3-105 105-41.2-41.2c-8.2-8.2-21.5-8.2-29.7 0l-98 98c-8.2 8.2-8.2 21.5 0 29.7s21.5 8.2 29.7 0l83.2-83.1 41.2 41.1c8.2 8.2 21.5 8.2 29.7 0l90.2-90.1 0 222.3-168 0 0 168-392 0 0-392 126 0 0 245c0 11.6 9.4 21 21 21l112 0c11.6 0 21-9.4 21-21s-9.4-21-21-21l-91 0 0-392z"],
    "bag-shopping": [504, 560, ["shopping-bag"], "f290", "M28 168l231 0c11.6 0 21-9.4 21-21s-9.4-21-21-21l-146.3 0C119.7 55.3 179.4 0 252 0 329.3 0 392 62.7 392 140l0 28 84 0 28 364-504 0 28-364z"],
    "phone": [616, 560, [128222, 128379], "f095", "M168-28l-69 55.2 64.2 78.5c7.3 9 6 22.2-3 29.6s-22.2 6-29.6-3L66.2 53.4 28 84 28 154c0 224.2 181.8 406 406 406l70 0 30.6-38.2-78.9-64.5c-9-7.3-10.3-20.6-3-29.6s20.6-10.3 29.6-3L560.8 489 616 420 448 280 344.3 404.5c-74.7-26.8-134-86-160.7-160.7L308 140 168-28z"],
    "leaf": [616, 560, [], "f06c", "M294.5 32.6L588.2 0 555.6 293.7c-13.3 119.7-114.5 210.3-235 210.3-43.8 0-84.8-11.9-120-32.7L302 369.9c8.2-8.2 8.2-21.5 0-29.7s-21.5-8.2-29.7 0L57.9 554.7-1.5 495.3 113 380.8c-18.4-33.6-28.8-72.2-28.8-113.2 0-120.5 90.6-221.7 210.3-235z"],
    "universal-access": [560, 560, [], "f29a", "M280 560a280 280 0 1 0 0-560 280 280 0 1 0 0 560zm0-448a35 35 0 1 1 0 70 35 35 0 1 1 0-70zM140 245c0-11.6 9.4-21 21-21l238 0c11.6 0 21 9.4 21 21s-9.4 21-21 21l-98 0 0 36.8 60.6 114.4c5.4 10.3 1.5 23-8.7 28.4s-23 1.5-28.4-8.7l-44.4-83.9-44.4 83.9c-5.4 10.3-18.1 14.2-28.4 8.7s-14.2-18.1-8.7-28.4l60.6-114.4 0-36.8-98 0c-11.6 0-21-9.4-21-21z"],
    "hourglass": [448, 560, [9203, 62032, "hourglass-empty"], "f254", "M32.6 387.4C11.7 408.4 0 436.8 0 466.4l0 93.6 448 0 0-93.6c0-29.7-11.8-58.2-32.8-79.2l-77.5-77.5-49.9 49.9c-8.2 8.2-21.5 8.2-29.7 0s-8.2-21.5 0-29.7c0 0 105-104.7 157.3-157.3 20.9-21 32.6-49.4 32.6-79L448 0 0 0 0 93.6c0 29.7 11.8 58.2 32.8 79.2l77.5 77.5 49.9-49.9c8.2-8.2 21.5-8.2 29.7 0s8.2 21.5 0 29.7c0 0-105 104.7-157.3 157.3z"],
    "fish": [672, 560, [128031], "f578", "M616 0L475.2 0C401.1 0 329.6 24.4 271.4 68.9 199.7 39.4 114.2 53.8 56 112l86.8 86.8c-34.4 51.9-41.7 116.4-22 173.7L0 448 112 504 168 616 243.5 495.2c49.9 17.1 105.2 13.8 153-10L341 398.1c-6.2-9.8-3.3-22.8 6.4-29s22.8-3.3 29 6.4L476 532 486.9 521.1c43.4-43.4 60.4-104.6 48.5-162 51.8-60.6 80.5-138 80.5-218.3L616 0zM476 112a28 28 0 1 1 56 0 28 28 0 1 1 -56 0z"],
    "chart-simple": [616, 560, [], "e473", "M0 280l0 252 616 0 0-364-182 0 0 231c0 11.6-9.4 21-21 21s-21-9.4-21-21l0-343-168 0 0 343c0 11.6-9.4 21-21 21s-21-9.4-21-21l0-119-182 0z"],
    "list": [560, 560, ["list-squares"], "f03a", "M560 56l-560 0 0 448 126 0 0-112-49 0c-11.6 0-21-9.4-21-21s9.4-21 21-21l49 0 0-126-49 0c-11.6 0-21-9.4-21-21s9.4-21 21-21l49 0 0-49c0-11.6 9.4-21 21-21s21 9.4 21 21l0 49 287 0c11.6 0 21 9.4 21 21s-9.4 21-21 21l-287 0 0 126 287 0c11.6 0 21 9.4 21 21s-9.4 21-21 21l-287 0 0 112 392 0 0-448z"],
    "headphones": [560, 560, [127911, 62863, "headphones-alt", "headphones-simple"], "f025", "M84 280C84 171.8 171.8 84 280 84s196 87.8 196 196l0 119c0 11.6-9.4 21-21 21s-21-9.4-21-21l0-91-98 0 0 224 224 0 0-252C560 125.4 434.6 0 280 0S0 125.4 0 280l0 252 224 0 0-224-98 0 0 91c0 11.6-9.4 21-21 21s-21-9.4-21-21l0-119z"],
    "bus": [560, 560, [128653], "f207", "M259 0L168 0C106.1 0 56 50.1 56 112l0 28-56 0 0 196 56 0 0 224 112 0 0-56 224 0 0 56 112 0 0-224 56 0 0-196-56 0 0-28C504 50.1 453.9 0 392 0l-91 0 0 210 98 0c11.6 0 21 9.4 21 21s-9.4 21-21 21l-238 0c-11.6 0-21-9.4-21-21s9.4-21 21-21l98 0 0-210zM182 336a42 42 0 1 1 0 84 42 42 0 1 1 0-84zm154 42a42 42 0 1 1 84 0 42 42 0 1 1 -84 0z"],
    "quote-left": [504, 560, [8220, "quote-left-alt"], "f10d", "M280 119c0-50.3 40.7-91 91-91l133 0 0 182-119 0c-11.6 0-21 9.4-21 21s9.4 21 21 21l119 0 0 280-224 0 0-301c0-11.6-9.4-21-21-21l-140 0c-11.6 0-21 9.4-21 21s9.4 21 21 21l119 0 0 280-238 0 0-392C0 78.1 50.1 28 112 28l162 0c-22.3 23.8-36 55.8-36 91 0 11.6 9.4 21 21 21s21-9.4 21-21z"],
    "martini-glass": [560, 560, [127864, "glass-martini-alt"], "f57b", "M495.1 3l-40.5 81 105.4 0-224 291.2 0 72.8 112 0 0 112-336 0 0-112 112 0 0-72.8-94.8-123.2 157.8 0c11.6 0 21-9.4 21-21s-9.4-21-21-21L96.9 210 0 84 329.4 84 395-47.1 495.1 3z"],
    "rectangle-wide": [672, 560, [], "f2fc", "M0 84l672 0 0 392-672 0z"],
    "angle-down": [504, 560, [8964], "f107", "M252.3 482.8L-6.5 224 112.3 105.2 279.4 272.4c8.2 8.2 21.5 8.2 29.7 0s8.2-21.5 0-29.7L282 215.5 392.3 105.2 511.1 224 252.3 482.8z"],
    "chart-pie": [560, 560, ["pie-chart"], "f200", "M308 0C447.2 0 560 112.8 560 252l-62.2 0c4.1 18 6.2 36.8 6.2 56 0 139.2-112.8 252-252 252S0 447.2 0 308 112.8 56 252 56c4.7 0 9.4 .1 14 .4L266 273c0 11.6 9.4 21 21 21l84 0c11.6 0 21-9.4 21-21s-9.4-21-21-21l-63 0 0-252z"],
    "inbox": [560, 560, [], "f01c", "M560 532l0-224-84-280-392 0-79.8 266 128.8 0c6.6 0 12.8 3.1 16.8 8.4l56.7 75.6 147 0 56.7-75.6c7-9.3 20.1-11.2 29.4-4.2s11.2 20.1 4.2 29.4l-63 84c-4 5.3-10.2 8.4-16.8 8.4l-168 0c-6.6 0-12.8-3.1-16.8-8.4L122.5 336 0 336 0 532 560 532z"],
    "credit-card": [560, 560, [128179, 62083, "credit-card-alt"], "f09d", "M0 56l560 0 0 112-427 0c-11.6 0-21 9.4-21 21s9.4 21 21 21l427 0 0 294-560 0 0-448zM308 399c0 11.6 9.4 21 21 21l126 0c11.6 0 21-9.4 21-21s-9.4-21-21-21l-126 0c-11.6 0-21 9.4-21 21z"],
    "wand-magic-sparkles": [616, 560, ["magic-wand-sparkles"], "e2ca", "M115.8 591.4l292.3-292.3 12.3 36.9-28 84 84-28 84 28-28-84 28-84-84 28-36.9-12.3 180.3-180.3-118.8-118.8-111.2 111.2 38.4 38.4c8.2 8.2 8.2 21.5 0 29.7s-21.5 8.2-29.7 0l-38.4-38.4-152.9 152.9-24.9-66.3 42-112-112 42-112-42 42 112-42 112 112-42 66.3 24.9-181.7 181.7 118.8 118.8z"],
    "bell-slash": [616, 560, [128277, 61943], "f1f6", "M84.2-23.2L5 56 112.3 163.3c0 1.6-.1 3.2-.1 4.7l0 168-84 112 140 0c0 77.3 62.7 140 140 140 61.9 0 114.4-40.2 132.9-95.9l91.1 91.1 79.2-79.2-107.2-107.2 0-228.8c0-108.2-87.8-196-196-196-47.4 0-90.8 16.8-124.7 44.7L386 219.2c8.2 8.2 8.2 21.5 0 29.7s-21.5 8.2-29.7 0L84.2-23.2z"],
    "folders": [616, 560, [], "f660", "M448 532l0-140 168 0 0-336-224 0-56-56-168 0 0 126 4.6 0c5.6 0 10.9 2.2 14.8 6.2L237.3 182 469 182c11.6 0 21 9.4 21 21l0 56c0 11.6-9.4 21-21 21s-21-9.4-21-21l0-35-219.4 0c-5.6 0-10.9-2.2-14.8-6.2L163.9 168 0 168 0 532 448 532z"],
    "star": [672, 560, [11088, 61446], "f005", "M336.1-56L434.8 144.1 655.6 176.2 495.8 331.9 533.6 551.8 336.1 448 138.6 551.8 176.3 331.9 16.5 176.2 237.3 144.1 336.1-56z"],
    "flag": [504, 560, [127988, 61725], "f024", "M0 28L123.1 10.4c47.8-6.8 96.5-1 141.3 16.9 46.8 18.7 97.9 24.3 147.7 16l91.9-15.3 0 364-91.9 15.3c-49.8 8.3-100.8 2.8-147.7-16-35.2-14.1-72.8-20.7-110.4-19.6L154 161c0-11.6-9.4-21-21-21s-21 9.4-21 21l0 371-112 0 0-504z"],
    "triangle-exclamation": [616, 560, [9888, "exclamation-triangle", "warning"], "f071", "M0 532L308 0 616 532 0 532zM336 420a28 28 0 1 0 -56 0 28 28 0 1 0 56 0zm-7-231c0-11.6-9.4-21-21-21s-21 9.4-21 21l0 126c0 11.6 9.4 21 21 21s21-9.4 21-21l0-126z"],
    "lock": [448, 560, [128274], "f023", "M84 112C84 34.7 146.7-28 224-28S364 34.7 364 112l0 112 84 0 0 336-448 0 0-336 84 0 0-112zm161-7c0-11.6-9.4-21-21-21s-21 9.4-21 21l0 98c0 11.6 9.4 21 21 21s21-9.4 21-21l0-98zm0 252c0-11.6-9.4-21-21-21s-21 9.4-21 21l0 70c0 11.6 9.4 21 21 21s21-9.4 21-21l0-70z"],
    "anchor": [504, 560, [9875], "f13d", "M308 181c33.5-19.4 56-55.6 56-97 0-61.9-50.1-112-112-112S140 22.1 140 84c0 41.5 22.5 77.7 56 97l0 274c0 11.6-9.4 21-21 21s-21-9.4-21-21l0-126-154-77 0 196c0 61.9 50.1 112 112 112l280 0c61.9 0 112-50.1 112-112l0-196-154 77 0 126c0 11.6-9.4 21-21 21s-21-9.4-21-21l0-274z"],
    "scissors": [504, 560, [9984, 9986, 9988, "cut"], "f0c4", "M100.4 280L37.2 216.8C13.3 192.9 0 159.9 0 126.4 0 56.8 56.4 0 126 0 195.6 0 253.3 58.9 252 128.4l100.4-100.4 151.6 0 0 95.6-126.7 126.7-61.4-61.4c-8.2-8.2-21.5-8.2-29.7 0s-8.2 21.5 0 29.7l217.8 217.8 0 95.6-151.6 0-161.5-161.5c-8.2-8.2-21.5-8.2-29.7 0s-8.2 21.5 0 29.7l81.5 81.5c-18.8 46-64 78.3-116.7 78.3-1.1 0-2.1 0-3.2 0-68.1-1.7-122.8-57.8-122.8-126.3 0-33.6 13.3-66.6 37.2-90.4L100.4 280zm45.4-173.8a28 28 0 1 0 -39.6 39.6 28 28 0 1 0 39.6-39.6z"],
    "bug": [504, 560, [], "f188", "M233.3 28.9L205.5-36.1 102.5 8.1 129.5 71c-34.4 27.6-59.3 66.4-69 111L315 182c11.6 0 21 9.4 21 21s-9.4 21-21 21l-315 0 0 119 63 0c11.6 0 21 9.4 21 21s-9.4 21-21 21l-63 0 0 119 91.1 0c35.4 50.8 94.3 84 160.9 84s125.5-33.2 160.9-84l91.1 0 0-119-63 0c-11.6 0-21-9.4-21-21s9.4-21 21-21l63 0 0-119-56 0c0-61.9-28.7-117.1-73.5-153l27-62.9-102.9-44.1-27.8 64.9c-6.2-.6-12.4-.9-18.7-.9s-12.5 .3-18.7 .9z"],
    "arrow-right-from-bracket": [616, 560, ["sign-out"], "f08b", "M616 280l-196-196-56 0 0 112-145.2 0-28.3 70.8c-4.3 10.8-16.5 16-27.3 11.7s-16-16.5-11.7-27.3l100.5-251.2-224 0 0 560 224 0-78.4-196 190.4 0 0 112 56 0 196-196z"],
    "arrow-right-arrow-left": [616, 560, [8644, "exchange"], "f0ec", "M602 126L476 0 420 0 420 84 0 84 0 360.6 116.5 244.2c3.9-3.9 9.3-6.2 14.8-6.2l85.7 0c11.6 0 21 9.4 21 21l0 84c0 11.6-9.4 21-21 21s-21-9.4-21-21l0-63-56 0-140 140 140 140 56 0 0-84 420 0 0-304.6-116.5 116.5c-3.9 3.9-9.3 6.2-14.8 6.2L399 294c-11.6 0-21-9.4-21-21l0-84c0-11.6 9.4-21 21-21s21 9.4 21 21l0 63 56 0 126-126z"],
    "arrow-up-from-line": [448, 560, [8613, "arrow-from-bottom"], "f342", "M224-28l-196 196 0 56 112 0 0 224-140 0 0 112 448 0 0-112-203 0c-11.6 0-21-9.4-21-21s9.4-21 21-21l63 0 0-182 112 0 0-56-196-196z"],
    "font": [448, 560, [], "f031", "M84 0C37.6 0 0 37.6 0 84l0 476 203 0 0-175c0-11.6 9.4-21 21-21s21 9.4 21 21l0 175 203 0 0-476c0-46.4-37.6-84-84-84L84 0zM245 133l0 98c0 11.6-9.4 21-21 21s-21-9.4-21-21l0-98c0-11.6 9.4-21 21-21s21 9.4 21 21z"],
    "language": [616, 560, [], "f1ab", "M252 0l-112 0 0 56-140 0 0 112 75.6 0c8.4 41.2 25.7 79 50 111.5-4.5 .4-9 .5-13.6 .5l-112 0 0 112 112 0c51 0 98.8-13.6 140-37.5l0 205.5 147 0 0-63c0-11.6 9.4-21 21-21s21 9.4 21 21l0 63 147 0 0-280c0-46.4-37.6-84-84-84l-168 0c-18.9 0-36.4 6.2-50.4 16.8-9.3 7-22.4 5.1-29.4-4.2s-5.1-22.4 4.2-29.4C281.4 163.4 307.7 154 336 154l52.9 0c2.1-13.7 3.1-27.7 3.1-42l0-56-140 0 0-56zM420 280c11.6 0 21 9.4 21 21l0 70c0 11.6-9.4 21-21 21s-21-9.4-21-21l0-70c0-11.6 9.4-21 21-21z"],
    "person-biking": [616, 560, [128692, "biking"], "f84a", "M252 112l67.2-89.6C329.8 8.3 346.4 0 364 0 394.9 0 420 25.1 420 56l0 56-70 0 33.6 44.8c5.3 7.1 13.6 11.2 22.4 11.2l70 0 0 98-70 0c-30.5 0-59.7-9.9-83.6-27.7-9.3-6.9-22.5-5-29.4 4.3s-5 22.5 4.3 29.4c31 23.1 69 36 108.7 36l84 0c69.6 0 126 56.4 126 126S559.6 560 490 560c-39.6 0-74.9-18.3-98-46.8L392 413c0-11.6-9.4-21-21-21s-21 9.4-21 21l0 91-98 0 0-98c0-8.8-4.1-17.1-11.2-22.4l-53.2-39.9c-9.3-7-22.4-5.1-29.4 4.2s-5.1 22.4 4.2 29.4L210 413 210 525c0 .9 .1 1.9 .2 2.8-22.3 20-51.8 32.2-84.2 32.2-69.6 0-126-56.4-126-126 0-61.9 44.6-113.4 103.5-124L252 112z"],
    "globe": [560, 560, [127760], "f0ac", "M280 560c154.6 0 280-125.4 280-280S434.6 0 280 0C132.4 0 11.5 114.2 .8 259l111.9 0c3.2-46.9 17.2-90.9 39.6-129.5 5.8-10 18.7-13.5 28.7-7.7s13.5 18.7 7.7 28.7C169.9 182.9 158 219.7 154.8 259l104.2 0 0-154c0-11.6 9.4-21 21-21s21 9.4 21 21l0 154 104.1 0c-3.1-39.3-15.1-76.1-33.8-108.5-5.8-10-2.4-22.9 7.7-28.7s22.9-2.4 28.7 7.7c25.5 44 40.1 96.1 40.3 150.5-.2 54.4-14.8 106.5-40.3 150.5-5.8 10-18.7 13.5-28.7 7.7s-13.5-18.7-7.7-28.7c18.7-32.4 30.6-69.2 33.8-108.5l-104.1 0 0 154c0 11.6-9.4 21-21 21s-21-9.4-21-21l0-154-104.2 0c3.2 39.3 15.1 76.1 33.8 108.5 5.8 10 2.4 22.9-7.7 28.7s-22.9 2.4-28.7-7.7C130 391.9 116 347.9 112.7 301L.8 301C11.5 445.8 132.4 560 280 560z"],
    "arrow-left": [672, 560, [8592], "f060", "M224 504l-224-224 224-224 56 0 0 112 308 0 0 224-266 0 0-91c0-11.6-9.4-21-21-21s-21 9.4-21 21l0 203-56 0z"],
    "paw": [560, 560, [], "f1b0", "M126 72.8L28 112 28 380.5C10.2 400 0 425.6 0 452.7l0 10.9c0 53.2 43.1 96.4 96.4 96.4 10.4 0 20.6-1.7 30.5-4.9L280 504 433.2 555.1c9.8 3.3 20.1 4.9 30.5 4.9 53.2 0 96.4-43.1 96.4-96.4l0-10.9c0-27.1-10.2-52.8-28-72.3l0-268.5-98-39.2 0 151.2c0 11.6-9.4 21-21 21s-21-9.4-21-21l0-224-91 0 0 224c0 11.6-9.4 21-21 21s-21-9.4-21-21l0-224-91 0 0 224c0 11.6-9.4 21-21 21s-21-9.4-21-21l0-151.2z"],
    "bed": [616, 560, [128716], "f236", "M0 28l112 0 0 112 112 0c46.4 0 84 37.6 84 84l0 14-175 0c-11.6 0-21 9.4-21 21s9.4 21 21 21l483 0 0 252-112 0 0-84-392 0 0 84-112 0 0-504z"],
    "landmark": [560, 560, [127963], "f66f", "M280-28L0 168 371 168c11.6 0 21 9.4 21 21l0 182c0 11.6-9.4 21-21 21s-21-9.4-21-21l0-161-140 0 0 161c0 11.6-9.4 21-21 21s-21-9.4-21-21l0-161-112 0 0 238-56 84 560 0-56-84 0-280 56 0-280-196z"],
    "music": [616, 560, [127925], "f001", "M560-39.1l-420 76.4 0 257.3c14.3 1.1 28.2 3.9 41.5 8.1 11 3.5 17.1 15.4 13.6 26.4s-15.4 17.1-26.4 13.6c-13.4-4.3-27.8-6.6-42.6-6.6-69.6 0-126 50.1-126 112s56.4 112 126 112 126-50.1 126-112l0-317.3 196-35.6 0 143.4c14.3 1.1 28.2 3.9 41.5 8.1 11 3.5 17.1 15.4 13.6 26.4s-15.4 17.1-26.4 13.6c-13.4-4.3-27.8-6.6-42.6-6.6-69.6 0-126 50.1-126 112s56.4 112 126 112 126-50.1 126-112l0-431.1z"],
    "files": [504, 560, [], "e178", "M168-28l196 0 140 140 0 336-168 0 0 140-336 0 0-476 194.3 0 141.7 141.7 0 89.3c0 11.6 9.4 21 21 21s21-9.4 21-21l0-98c0-5.6-2.2-10.9-6.2-14.8l-154-154c-3.9-3.9-9.3-6.2-14.8-6.2l-35 0 0-98z"],
    "plus": [560, 560, [10133, 61543, "add"], "2b", "M364 0l0 196 196 0 0 168-196 0 0 196-168 0 0-196-196 0 0-168 259 0c11.6 0 21-9.4 21-21s-9.4-21-21-21l-63 0 0-154 168 0z"],
    "box": [504, 560, [128230], "f466", "M231 0l0 231c0 11.6 9.4 21 21 21s21-9.4 21-21L273 0 392 0 504 196 504 532 0 532 0 196 112 0 231 0z"],
    "arrow-rotate-right": [560, 560, [8635, "arrow-right-rotate", "arrow-rotate-forward", "redo"], "f01e", "M560 0l0 252-252 0-42-42 63.8-63.8c8.2-8.2 8.2-21.5 0-29.7s-21.5-8.2-29.7 0l-78.7 78.7c-8.2 8.2-8.2 21.5 0 29.7l63 63c3.9 3.9 9.3 6.2 14.8 6.2l260.4 0C552.4 442.1 429.9 560 280 560 125.4 560 0 434.6 0 280S125.4 0 280 0c55.8 0 107.8 16.3 151.5 44.5L518-42 560 0z"],
    "signal-bars-slash": [616, 560, ["signal-alt-slash"], "f694", "M84-23.2L4.8 56 154 205.2 154 399c0 11.6-9.4 21-21 21s-21-9.4-21-21l0-119-112 0 0 224 452.8 0 81.6 81.6 81.6-81.6 0-476-126 0 0 301c0 11.6-9.4 21-21 21s-21-9.4-21-21l0-217-126 0 0 43.4 35.8 35.8c8.2 8.2 8.2 21.5 0 29.7s-21.5 8.2-29.7 0L84-23.2z"],
    "arrow-down-wide-short": [560, 560, ["sort-amount-asc", "sort-amount-down"], "f160", "M196 560l-196-196 0-56 112 0 0-308 448 0 0 112-259 0c-11.6 0-21 9.4-21 21s9.4 21 21 21l203 0 0 105-203 0c-11.6 0-21 9.4-21 21s9.4 21 21 21l147 0 0 105-147 0c-11.6 0-21 9.4-21 21s9.4 21 21 21l91 0 0 112-196 0z"],
    "compress": [616, 560, [], "f066", "M287.5 539l0-175c0-11.6 9.4-21 21-21s21 9.4 21 21l0 175 69.5-69.5 112 112 99-99-112-112 69.5-69.5-175 0c-11.6 0-21-9.4-21-21s9.4-21 21-21l175 0-69.5-69.5 112-112-99-99-112 112-69.5-69.5 0 175c0 11.6-9.4 21-21 21s-21-9.4-21-21l0-175-69.5 69.5-112-112-99 99 112 112-69.5 69.5 175 0c11.6 0 21 9.4 21 21s-9.4 21-21 21l-175 0 69.5 69.5-112 112 99 99 112-112 69.5 69.5z"],
    "eye-slash": [672, 560, [], "f070", "M112-23.2L32.8 56 112.4 135.6S37.4 231.9 0 280L110 421.5c54.2 69.7 137.6 110.5 226 110.5 48.7 0 95.9-12.4 137.6-35.2l86.4 86.4 79.2-79.2-79.6-79.6S634.6 328.1 672 280L562 138.5C507.7 68.8 424.3 28 336 28 302.7 28 270 33.8 239.4 44.8L497.8 303.2c8.2 8.2 8.2 21.5 0 29.7s-21.5 8.2-29.7 0L112-23.2z"],
    "mug-hot": [560, 560, [9749], "f7b6", "M201.9-28l-117.9 0 28 84-28 84-56 0 0 336c0 46.4 37.6 84 84 84l224 0c46.4 0 84-37.6 84-84l0-203c0-11.6 9.4-21 21-21s21 9.4 21 21l0 147 14 0c46.4 0 84-37.6 84-84l0-112c0-46.4-37.6-84-84-84l-112 0 28-84-28-84-117.9 0 25.8 77.4c1.4 4.3 1.4 9 0 13.3l-21 62.9c-3.7 11-15.6 16.9-26.6 13.3s-17-15.6-13.3-26.6l18.8-56.3-28-84z"],
    "bolt": [560, 560, [9889, "zap"], "f0e7", "M0 336L364-56 334.1 182.9 560 224 196 616 235 303.7c1.4-11.5-6.7-22-18.2-23.4s-22 6.7-23.4 18.2L184.5 369.5 0 336z"],
    "arrow-rotate-left": [560, 560, [8634, "arrow-left-rotate", "arrow-rotate-back", "arrow-rotate-backward", "undo"], "f0e2", "M0 0l0 252 252 0 42-42-63.8-63.8c-8.2-8.2-8.2-21.5 0-29.7s21.5-8.2 29.7 0l78.7 78.7c8.2 8.2 8.2 21.5 0 29.7l-63 63c-3.9 3.9-9.3 6.2-14.8 6.2L.3 294C7.6 442.1 130.1 560 280 560 434.6 560 560 434.6 560 280S434.6 0 280 0C224.2 0 172.2 16.3 128.5 44.5L42-42 0 0z"],
    "wifi": [672, 560, ["wifi-3", "wifi-strong"], "f1eb", "M0 167.4c185.9-185.9 486.1-185.9 672 0L336 504 227.2 395c27.9-27.8 66.3-45 108.8-45 2.1 0 4.2 0 6.2 .1 11.6 .5 21.4-8.6 21.8-20.2s-8.6-21.4-20.2-21.8c-2.6-.1-5.2-.2-7.9-.2-54.1 0-103 21.9-138.5 57.3l-89-89.2c58.3-58.2 138.7-94.1 227.5-94.1 49.4 0 96.1 11.1 137.9 30.9 10.5 5 23 .5 28-10s.5-23-10-28c-47.3-22.4-100.2-35-155.9-35-100.4 0-191.3 40.7-257.2 106.4L0 167.4z"],
    "volume": [560, 560, [128265, "volume-medium"], "f6a8", "M252 0l-28 0-140 140-84 0 0 280 84 0 140 140 56 0C434.6 560 560 434.6 560 280 560 130.1 442.1 7.6 294 .3l0 84.1c101.7 7.2 182 92 182 195.5 0 108.2-87.8 196-196 196l-7 0c-11.6 0-21-9.4-21-21l0-210c0-11.6 9.4-21 21-21s21 9.4 21 21l0 188.4c78.5-7.1 140-73 140-153.4 0-85.1-68.9-154-154-154l-7 0c-11.6 0-21-9.4-21-21L252 0z"],
    "tag": [616, 560, [127991], "f02b", "M56 28L56 308 336 588 616 308 336 28 56 28zM182 196c0 23.2 18.8 42 42 42 11.6 0 21 9.4 21 21s-9.4 21-21 21c-46.4 0-84-37.6-84-84s37.6-84 84-84 84 37.6 84 84c0 11.6-9.4 21-21 21s-21-9.4-21-21c0-23.2-18.8-42-42-42s-42 18.8-42 42z"],
    "compact-disc": [560, 560, [128191, 128192, 128440], "f51f", "M280 560a280 280 0 1 0 0-560 280 280 0 1 0 0 560zM210 280c0 22.4 10.5 42.3 26.9 55.2 9.1 7.1 10.8 20.3 3.6 29.5s-20.3 10.8-29.5 3.6c-26.2-20.5-43.1-52.4-43.1-88.3 0-61.9 50.1-112 112-112s112 50.1 112 112c0 35.9-16.9 67.8-43.1 88.3-9.1 7.1-22.3 5.5-29.5-3.6s-5.5-22.3 3.6-29.5c16.4-12.8 26.9-32.8 26.9-55.2 0-38.7-31.3-70-70-70s-70 31.3-70 70z"],
    "phone-slash": [616, 560, [], "f3dd", "M532-23.2l-318 318c-8.2 8.2-21.5 8.2-29.7 0s-8.2-21.5 0-29.7L308.6 140.8 168-28 99 27.2 163.3 105.7c7.3 9 6 22.2-3 29.6s-22.2 6-29.6-3L66.2 53.4 28 84 28 154c0 91.9 30.5 176.7 82 244.8L4.8 504 84 583.2 189.2 478c68.1 51.5 152.8 82 244.8 82l70 0 30.6-38.2-78.9-64.5c-9-7.3-10.3-20.6-3-29.6s20.6-10.3 29.6-3L560.8 489 616 420 447.2 279.4 322.8 403.7c-8.2 8.2-21.5 8.2-29.7 0s-8.2-21.5 0-29.7L611.2 56 532-23.2z"],
    "arrow-up-right-from-square": [560, 560, ["external-link"], "f08e", "M28 56l220.6 0 56.8 56.8-180.3 180.3c-8.2 8.2-8.2 21.5 0 29.7l112 112c8.2 8.2 21.5 8.2 29.7 0l63-63c8.2-8.2 8.2-21.5 0-29.7s-21.5-8.2-29.7 0L252 390.3 169.7 308 350 127.7c8.2-8.2 8.2-21.5 0-29.7l-56-56 42-42 224 0 0 224-42 42-56-56c-8.2-8.2-21.5-8.2-29.7 0s-8.2 21.5 0 29.7l71.7 71.7 0 220.6-476 0 0-476z"],
    "rectangle-tall": [392, 560, [], "e791", "M392-56l0 672-392 0 0-672 392 0z"],
    "compass": [560, 560, [129517], "f14e", "M280 560a280 280 0 1 0 0-560 280 280 0 1 0 0 560zM418.8 168.1l-63 175c-2.1 5.9-6.8 10.5-12.6 12.6l-175 63c-7.7 2.8-16.2 .8-22-4.9s-7.7-14.3-4.9-22l42.8-119c3.9-10.9 16-16.6 26.9-12.6s16.6 16 12.6 26.9l-27.7 77 123.7-44.5 44.5-123.7-77 27.7c-10.9 3.9-22.9-1.7-26.9-12.6s1.7-22.9 12.6-26.9l119-42.8c7.7-2.8 16.2-.8 22 4.9s7.7 14.3 4.9 22z"],
    "square": [504, 560, [9632, 9723, 9724, 61590], "f0c8", "M0 28l504 0 0 504-504 0z"],
    "face-grin": [560, 560, [128512, "grin"], "f580", "M280 560a280 280 0 1 0 0-560 280 280 0 1 0 0 560zM182 168a42 42 0 1 1 0 84 42 42 0 1 1 0-84zm154 42a42 42 0 1 1 84 0 42 42 0 1 1 -84 0zM161 308l126 0c11.6 0 21 9.4 21 21s-9.4 21-21 21l-104 0c6.8 47.5 47.6 84 97 84 54.1 0 98-43.9 98-98l0-7c0-11.6 9.4-21 21-21s21 9.4 21 21l0 7c0 77.3-62.7 140-140 140S140 413.3 140 336l0-7c0-11.6 9.4-21 21-21z"],
    "angle-up": [504, 560, [8963], "f106", "M252.3 77.2L-6.5 336 112.3 454.8 279.4 287.6c8.2-8.2 21.5-8.2 29.7 0s8.2 21.5 0 29.7L282 344.5 392.3 454.8 511.1 336 252.3 77.2z"],
    "face-smile": [560, 560, [128578, "smile"], "f118", "M280 560a280 280 0 1 0 0-560 280 280 0 1 0 0 560zM182 168a42 42 0 1 1 0 84 42 42 0 1 1 0-84zm154 42a42 42 0 1 1 84 0 42 42 0 1 1 -84 0zM178 340c22.9 31.6 60.1 52 102 52s79.1-20.5 102-52c6.8-9.4 20-11.5 29.3-4.6s11.5 20 4.6 29.3c-30.5 42-80 69.3-136 69.3s-105.5-27.4-136-69.3c-6.8-9.4-4.7-22.5 4.6-29.3s22.5-4.7 29.3 4.6z"],
    "umbrella": [560, 560, [], "f0e9", "M280 0C125.4 0 0 125.4 0 280l99.7 0c12.2-62.1 36.6-116.1 69.6-153.8 7.6-8.7 20.9-9.6 29.6-2s9.6 20.9 2 29.6c-26 29.7-46.9 73.7-58.3 126.2l81.5 0 0 112-112 0 0 56c0 61.9 50.1 112 112 112s112-50.1 112-112l0-168 81.5 0c-11.4-52.5-32.3-96.5-58.3-126.2-7.6-8.7-6.7-22 2-29.6s22-6.7 29.6 2c33 37.7 57.4 91.7 69.6 153.8l99.7 0C560 125.4 434.6 0 280 0z"],
    "pause": [448, 560, [9208], "f04c", "M448 0l-448 0 0 560 203 0 0-427c0-11.6 9.4-21 21-21s21 9.4 21 21l0 427 203 0 0-560z"],
    "desktop": [560, 560, [128421, 61704, "desktop-alt"], "f390", "M0 28l560 0 0 364-112 0 0 140-336 0 0-98 203 0c11.6 0 21-9.4 21-21s-9.4-21-21-21L0 392 0 28z"],
    "arrow-down": [448, 560, [8595], "f063", "M0 392l224 224 224-224 0-56-112 0 0-308-224 0 0 266 91 0c11.6 0 21 9.4 21 21s-9.4 21-21 21L0 336 0 392z"],
    "location-dot": [504, 560, ["map-marker-alt"], "f3c5", "M84.3 438.9L252 588 419.7 438.9C473.3 391.3 504 322.9 504 251.2 504 112.5 390.7 0 252 0S0 112.5 0 251.2c0 71.8 30.7 140.1 84.3 187.7zM182 252c0 22.4 10.5 42.3 26.9 55.2 9.1 7.1 10.8 20.3 3.6 29.5s-20.3 10.8-29.5 3.6c-26.2-20.5-43.1-52.4-43.1-88.3 0-61.9 50.1-112 112-112s112 50.1 112 112c0 35.9-16.9 67.8-43.1 88.3-9.1 7.1-22.3 5.5-29.5-3.6s-5.5-22.3 3.6-29.5c16.4-12.8 26.9-32.8 26.9-55.2 0-38.7-31.3-70-70-70s-70 31.3-70 70z"],
    "bars": [560, 560, ["navicon"], "f0c9", "M0 56l560 0 0 126-203 0c-11.6 0-21 9.4-21 21s9.4 21 21 21l203 0 0 112-203 0c-11.6 0-21 9.4-21 21s9.4 21 21 21l203 0 0 126-560 0 0-126 203 0c11.6 0 21-9.4 21-21s-9.4-21-21-21l-203 0 0-112 203 0c11.6 0 21-9.4 21-21s-9.4-21-21-21L0 182 0 56z"],
    "battery-empty": [672, 560, ["battery-0"], "f244", "M28 56l504 0 0 84 140 0 0 280-98 0 0-119c0-11.6-9.4-21-21-21s-21 9.4-21 21l0 203-504 0 0-448z"],
    "stopwatch": [560, 560, [9201], "f2f2", "M168.1 56l56 0 0 34.2c-112.2 25.5-196 125.8-196 245.8 0 139.2 112.8 252 252 252s252-112.8 252-252c0-49.3-14.2-95.3-38.6-134.2l50.2-50.2-79.2-79.2-50.2 50.2c-23.7-14.9-50-26-78.2-32.4l0-34.2 56 0 0-112-224 0 0 112zm133 161l0 126c0 11.6-9.4 21-21 21s-21-9.4-21-21l0-126c0-11.6 9.4-21 21-21s21 9.4 21 21z"],
    "train": [448, 560, [128646], "f238", "M112 0l91 0 0 210-98 0c-11.6 0-21 9.4-21 21s9.4 21 21 21l238 0c11.6 0 21-9.4 21-21s-9.4-21-21-21l-98 0 0-210 91 0c61.9 0 112 50.1 112 112l0 280c0 42.8-24 80-59.4 98.9l57.6 69.1-145.8 0-46.7-56-59.5 0-46.7 56-145.8 0 57.6-69.1C24 472 0 434.8 0 392L0 112C0 50.1 50.1 0 112 0zM224 420a42 42 0 1 0 0-84 42 42 0 1 0 0 84z"],
    "gamepad": [672, 560, [], "f11b", "M0 476L70.5 123.5C78.3 84.3 112.8 56 152.9 56l366.3 0c40 0 74.5 28.3 82.4 67.5l70.5 352.5-168 56-63-126 42 0c11.6 0 21-9.4 21-21s-9.4-21-21-21l-322 0c-11.6 0-21 9.4-21 21s9.4 21 21 21l42 0-63 126-140-56zM224 140c-11.6 0-21 9.4-21 21l0 28-28 0c-11.6 0-21 9.4-21 21s9.4 21 21 21l28 0 0 28c0 11.6 9.4 21 21 21s21-9.4 21-21l0-28 28 0c11.6 0 21-9.4 21-21s-9.4-21-21-21l-28 0 0-28c0-11.6-9.4-21-21-21zm196 56a28 28 0 1 0 0-56 28 28 0 1 0 0 56zm84 56a28 28 0 1 0 -56 0 28 28 0 1 0 56 0z"],
    "ship": [560, 560, [128674], "f21a", "M140 0l280 0 0 170.4-133.4-44.5c-4.3-1.4-9-1.4-13.3 0l-35 11.7c-11 3.7-16.9 15.6-13.3 26.6s15.6 16.9 26.6 13.3l28.4-9.5 252 84-56.8 170.5c10.5 1.7 20.9 4.2 31 7.6l53.8 17.9 0 112-560 0 0-112 53.8-17.9c20-6.7 41-10.1 62.1-10.1 16 0 32 2 47.6 5.9l61.8 15.5c17.8 4.4 36 6.7 54.3 6.7 23.5 0 46-4.4 68.7-10.1 11.3-2.8 18.1-14.2 15.3-25.5s-14.2-18.1-25.5-15.3c-19.3 4.8-38.4 8.8-58.5 8.8-14.9 0-29.7-1.8-44.1-5.4l-61.8-15.5c-18.9-4.7-38.3-7.1-57.8-7.1-14.9 0-29.8 1.4-44.4 4.2L28 252 140 214.7 140 0z"],
    "arrows-rotate": [560, 560, [128472, "refresh", "sync"], "f021", "M559.7 294c-7.3 148.1-129.7 266-279.7 266-70.2 0-134.4-25.8-183.5-68.5l-54.5 54.5-42-42 0-196 196 0 42 42-49 49c-8.2 8.2-8.2 21.5 0 29.7s21.5 8.2 29.7 0l63.8-63.9c8.2-8.2 8.2-21.5 0-29.7l-63-63c-3.9-3.9-9.3-6.2-14.8-6.2L.3 266C7.6 117.9 130.1 0 280 0 350.2 0 414.4 25.8 463.5 68.5l54.5-54.5 42 42 0 196-196 0-42-42 49-49c8.2-8.2 8.2-21.5 0-29.7s-21.5-8.2-29.7 0l-63.8 63.8c-8.2 8.2-8.2 21.5 0 29.7l63 63c3.9 3.9 9.3 6.2 14.8 6.2l204.4 0z"],
    "book-open": [560, 560, [128214, 128366], "f518", "M259 73.5L215.3 51.6C184.2 36.1 149.9 28 115.1 28L0 28 0 476 115.1 476c34.8 0 69.1 8.1 100.2 23.6L280 532 344.7 499.6c31.1-15.6 65.4-23.6 100.2-23.6l115.1 0 0-448-115.1 0c-34.8 0-69.1 8.1-100.2 23.6L301 73.5 301 399c0 11.6-9.4 21-21 21s-21-9.4-21-21l0-325.5z"],
    "box-archive": [616, 560, ["archive"], "f187", "M616 28L0 28 0 140 427 140c11.6 0 21 9.4 21 21s-9.4 21-21 21l-371 0 0 350 504 0 0-392 56 0 0-112zM224 301c0-11.6 9.4-21 21-21l126 0c11.6 0 21 9.4 21 21s-9.4 21-21 21l-126 0c-11.6 0-21-9.4-21-21z"],
    "cake-candles": [560, 560, [127874, "birthday-cake", "cake"], "f1fd", "M84 28l70 0 0 119c0 11.6 9.4 21 21 21s21-9.4 21-21l0-119 63 0 0 119c0 11.6 9.4 21 21 21s21-9.4 21-21l0-119 63 0 0 119c0 11.6 9.4 21 21 21s21-9.4 21-21l0-119 70 0 0 140c46.4 0 84 37.6 84 84l0 252-560 0 0-162.6 117.2 21.3c5.8 1.1 11.7 1.1 17.5 0l144-26.2c.8-.2 1.7-.2 2.5 0l142 25.8c11.4 2.1 22.3-5.5 24.4-16.9s-5.5-22.3-16.9-24.4l-142-25.8c-5.8-1.1-11.7-1.1-17.5 0l-144 26.2c-.8 .2-1.7 .2-2.5 0L0 298.7 0 252c0-46.4 37.6-84 84-84L84 28z"],
    "signal-bars-good": [616, 560, ["signal-alt-3"], "f693", "M0 504l448 0 0-392-126 0 0 287c0 11.6-9.4 21-21 21s-21-9.4-21-21l0-203-126 0 0 203c0 11.6-9.4 21-21 21s-21-9.4-21-21l0-119-112 0 0 224z"],
    "circle-info": [560, 560, ["info-circle"], "f05a", "M0 280a280 280 0 1 1 560 0 280 280 0 1 1 -560 0zM308 140a28 28 0 1 0 -56 0 28 28 0 1 0 56 0zm-91 84c-11.6 0-21 9.4-21 21s9.4 21 21 21l49 0 0 140-49 0c-11.6 0-21 9.4-21 21s9.4 21 21 21l126 0c11.6 0 21-9.4 21-21s-9.4-21-21-21l-35 0 0-161c0-11.6-9.4-21-21-21l-70 0z"],
    "layer-group": [560, 560, [], "f5fd", "M0 112l280-140 280 140-168 84 168 84-168 84 168 84-280 140-280-140 121-60.5 128.6 64.3c10.4 5.2 23 1 28.2-9.4s1-23-9.4-28.2L0 280 121 219.5 249.6 283.8c10.4 5.2 23 1 28.2-9.4s1-23-9.4-28.2L0 112z"],
    "shield": [560, 560, [128737, "shield-blank"], "f132", "M259-19.6L0 84C0 420 280 588 280 588S560 420 560 84L301-19.6 301 399c0 11.6-9.4 21-21 21s-21-9.4-21-21l0-418.6z"],
    "cart-shopping": [672, 560, [128722, "shopping-cart"], "f07a", "M0 28l644 0-53.6 308.1c-.8-.1-1.6-.1-2.4-.1l-399 0c-11.6 0-21 9.4-21 21s9.4 21 21 21l371 0 0 98c0 46.4-37.6 84-84 84s-84-37.6-84-84l-140 0c0 46.4-37.6 84-84 84s-84-37.6-84-84l0-336-84 0 0-112z"]
  };

  bunker(function () {
    defineIcons('faes', icons);
  });

}());
