/*!
 * Font Awesome Pro 7.1.0 by @fontawesome - https://fontawesome.com
 * License - https://fontawesome.com/license (Commercial License)
 * Copyright 2025 Fonticons, Inc.
 */
(function () {
  'use strict';

  var _WINDOW = {};
  var _DOCUMENT = {};
  try {
    if (typeof window !== 'undefined') _WINDOW = window;
    if (typeof document !== 'undefined') _DOCUMENT = document;
  } catch (e) {} // eslint-disable-line no-empty

  var _ref = _WINDOW.navigator || {},
    _ref$userAgent = _ref.userAgent,
    userAgent = _ref$userAgent === void 0 ? '' : _ref$userAgent;
  var WINDOW = _WINDOW;
  var DOCUMENT = _DOCUMENT;
  var IS_BROWSER = !!WINDOW.document;
  var IS_DOM = !!DOCUMENT.documentElement && !!DOCUMENT.head && typeof DOCUMENT.addEventListener === 'function' && typeof DOCUMENT.createElement === 'function';
  var IS_IE = ~userAgent.indexOf('MSIE') || ~userAgent.indexOf('Trident/');

  function _arrayLikeToArray(r, a) {
    (null == a || a > r.length) && (a = r.length);
    for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e];
    return n;
  }
  function _arrayWithoutHoles(r) {
    if (Array.isArray(r)) return _arrayLikeToArray(r);
  }
  function _defineProperty(e, r, t) {
    return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, {
      value: t,
      enumerable: !0,
      configurable: !0,
      writable: !0
    }) : e[r] = t, e;
  }
  function _iterableToArray(r) {
    if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r);
  }
  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }
  function ownKeys(e, r) {
    var t = Object.keys(e);
    if (Object.getOwnPropertySymbols) {
      var o = Object.getOwnPropertySymbols(e);
      r && (o = o.filter(function (r) {
        return Object.getOwnPropertyDescriptor(e, r).enumerable;
      })), t.push.apply(t, o);
    }
    return t;
  }
  function _objectSpread2(e) {
    for (var r = 1; r < arguments.length; r++) {
      var t = null != arguments[r] ? arguments[r] : {};
      r % 2 ? ownKeys(Object(t), !0).forEach(function (r) {
        _defineProperty(e, r, t[r]);
      }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) {
        Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r));
      });
    }
    return e;
  }
  function _toConsumableArray(r) {
    return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread();
  }
  function _toPrimitive(t, r) {
    if ("object" != typeof t || !t) return t;
    var e = t[Symbol.toPrimitive];
    if (void 0 !== e) {
      var i = e.call(t, r || "default");
      if ("object" != typeof i) return i;
      throw new TypeError("@@toPrimitive must return a primitive value.");
    }
    return ("string" === r ? String : Number)(t);
  }
  function _toPropertyKey(t) {
    var i = _toPrimitive(t, "string");
    return "symbol" == typeof i ? i : i + "";
  }
  function _unsupportedIterableToArray(r, a) {
    if (r) {
      if ("string" == typeof r) return _arrayLikeToArray(r, a);
      var t = {}.toString.call(r).slice(8, -1);
      return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0;
    }
  }

  var _dt;
  var q = {
      classic: {
        fa: "solid",
        fas: "solid",
        "fa-solid": "solid",
        far: "regular",
        "fa-regular": "regular",
        fal: "light",
        "fa-light": "light",
        fat: "thin",
        "fa-thin": "thin",
        fab: "brands",
        "fa-brands": "brands"
      },
      duotone: {
        fa: "solid",
        fad: "solid",
        "fa-solid": "solid",
        "fa-duotone": "solid",
        fadr: "regular",
        "fa-regular": "regular",
        fadl: "light",
        "fa-light": "light",
        fadt: "thin",
        "fa-thin": "thin"
      },
      sharp: {
        fa: "solid",
        fass: "solid",
        "fa-solid": "solid",
        fasr: "regular",
        "fa-regular": "regular",
        fasl: "light",
        "fa-light": "light",
        fast: "thin",
        "fa-thin": "thin"
      },
      "sharp-duotone": {
        fa: "solid",
        fasds: "solid",
        "fa-solid": "solid",
        fasdr: "regular",
        "fa-regular": "regular",
        fasdl: "light",
        "fa-light": "light",
        fasdt: "thin",
        "fa-thin": "thin"
      },
      slab: {
        "fa-regular": "regular",
        faslr: "regular"
      },
      "slab-press": {
        "fa-regular": "regular",
        faslpr: "regular"
      },
      thumbprint: {
        "fa-light": "light",
        fatl: "light"
      },
      whiteboard: {
        "fa-semibold": "semibold",
        fawsb: "semibold"
      },
      notdog: {
        "fa-solid": "solid",
        fans: "solid"
      },
      "notdog-duo": {
        "fa-solid": "solid",
        fands: "solid"
      },
      etch: {
        "fa-solid": "solid",
        faes: "solid"
      },
      jelly: {
        "fa-regular": "regular",
        fajr: "regular"
      },
      "jelly-fill": {
        "fa-regular": "regular",
        fajfr: "regular"
      },
      "jelly-duo": {
        "fa-regular": "regular",
        fajdr: "regular"
      },
      chisel: {
        "fa-regular": "regular",
        facr: "regular"
      },
      utility: {
        "fa-semibold": "semibold",
        fausb: "semibold"
      },
      "utility-duo": {
        "fa-semibold": "semibold",
        faudsb: "semibold"
      },
      "utility-fill": {
        "fa-semibold": "semibold",
        faufsb: "semibold"
      }
    };
  var i = "classic",
    t = "duotone",
    d = "sharp",
    l = "sharp-duotone",
    f = "chisel",
    n = "etch",
    h = "jelly",
    o = "jelly-duo",
    u = "jelly-fill",
    g = "notdog",
    s = "notdog-duo",
    y = "slab",
    m = "slab-press",
    e = "thumbprint",
    p = "utility",
    a = "utility-duo",
    w = "utility-fill",
    x = "whiteboard",
    b = "Classic",
    c = "Duotone",
    I = "Sharp",
    F = "Sharp Duotone",
    v = "Chisel",
    S = "Etch",
    A = "Jelly",
    P = "Jelly Duo",
    j = "Jelly Fill",
    B = "Notdog",
    N = "Notdog Duo",
    k = "Slab",
    D = "Slab Press",
    T = "Thumbprint",
    C = "Utility",
    W = "Utility Duo",
    K = "Utility Fill",
    R = "Whiteboard",
    dt = (_dt = {}, _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_dt, i, b), t, c), d, I), l, F), f, v), n, S), h, A), o, P), u, j), g, B), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_dt, s, N), y, k), m, D), e, T), p, C), a, W), w, K), x, R));
  var gt = {
      classic: {
        900: "fas",
        400: "far",
        normal: "far",
        300: "fal",
        100: "fat"
      },
      duotone: {
        900: "fad",
        400: "fadr",
        300: "fadl",
        100: "fadt"
      },
      sharp: {
        900: "fass",
        400: "fasr",
        300: "fasl",
        100: "fast"
      },
      "sharp-duotone": {
        900: "fasds",
        400: "fasdr",
        300: "fasdl",
        100: "fasdt"
      },
      slab: {
        400: "faslr"
      },
      "slab-press": {
        400: "faslpr"
      },
      whiteboard: {
        600: "fawsb"
      },
      thumbprint: {
        300: "fatl"
      },
      notdog: {
        900: "fans"
      },
      "notdog-duo": {
        900: "fands"
      },
      etch: {
        900: "faes"
      },
      chisel: {
        400: "facr"
      },
      jelly: {
        400: "fajr"
      },
      "jelly-fill": {
        400: "fajfr"
      },
      "jelly-duo": {
        400: "fajdr"
      },
      utility: {
        600: "fausb"
      },
      "utility-duo": {
        600: "faudsb"
      },
      "utility-fill": {
        600: "faufsb"
      }
    };
  var _t = {
      chisel: {
        regular: "facr"
      },
      classic: {
        brands: "fab",
        light: "fal",
        regular: "far",
        solid: "fas",
        thin: "fat"
      },
      duotone: {
        light: "fadl",
        regular: "fadr",
        solid: "fad",
        thin: "fadt"
      },
      etch: {
        solid: "faes"
      },
      jelly: {
        regular: "fajr"
      },
      "jelly-duo": {
        regular: "fajdr"
      },
      "jelly-fill": {
        regular: "fajfr"
      },
      notdog: {
        solid: "fans"
      },
      "notdog-duo": {
        solid: "fands"
      },
      sharp: {
        light: "fasl",
        regular: "fasr",
        solid: "fass",
        thin: "fast"
      },
      "sharp-duotone": {
        light: "fasdl",
        regular: "fasdr",
        solid: "fasds",
        thin: "fasdt"
      },
      slab: {
        regular: "faslr"
      },
      "slab-press": {
        regular: "faslpr"
      },
      thumbprint: {
        light: "fatl"
      },
      utility: {
        semibold: "fausb"
      },
      "utility-duo": {
        semibold: "faudsb"
      },
      "utility-fill": {
        semibold: "faufsb"
      },
      whiteboard: {
        semibold: "fawsb"
      }
    };
  var qt = {
      kit: {
        fak: "kit",
        "fa-kit": "kit"
      },
      "kit-duotone": {
        fakd: "kit-duotone",
        "fa-kit-duotone": "kit-duotone"
      }
    },
    Ht = ["kit"];
  var L = "kit",
    r = "kit-duotone",
    U = "Kit",
    J = "Kit Duotone",
    $t = _defineProperty(_defineProperty({}, L, U), r, J);
  var ol = {
    kit: {
      "fa-kit": "fak"
    },
    "kit-duotone": {
      "fa-kit-duotone": "fakd"
    }
  };
  var fl = {
      kit: {
        fak: "fa-kit"
      },
      "kit-duotone": {
        fakd: "fa-kit-duotone"
      }
    };
  var ul = {
      kit: {
        kit: "fak"
      },
      "kit-duotone": {
        "kit-duotone": "fakd"
      }
    };

  var _ml;
  var l$1 = {
      GROUP: "duotone-group",
      SWAP_OPACITY: "swap-opacity",
      PRIMARY: "primary",
      SECONDARY: "secondary"
    };
  var n$1 = "classic",
    o$1 = "duotone",
    u$1 = "sharp",
    s$1 = "sharp-duotone",
    h$1 = "chisel",
    g$1 = "etch",
    y$1 = "jelly",
    e$1 = "jelly-duo",
    m$1 = "jelly-fill",
    p$1 = "notdog",
    a$1 = "notdog-duo",
    w$1 = "slab",
    b$1 = "slab-press",
    r$1 = "thumbprint",
    c$1 = "utility",
    i$1 = "utility-duo",
    x$1 = "utility-fill",
    I$1 = "whiteboard",
    F$1 = "Classic",
    v$1 = "Duotone",
    S$1 = "Sharp",
    A$1 = "Sharp Duotone",
    P$1 = "Chisel",
    j$1 = "Etch",
    B$1 = "Jelly",
    N$1 = "Jelly Duo",
    k$1 = "Jelly Fill",
    D$1 = "Notdog",
    C$1 = "Notdog Duo",
    T$1 = "Slab",
    L$1 = "Slab Press",
    W$1 = "Thumbprint",
    R$1 = "Utility",
    K$1 = "Utility Duo",
    U$1 = "Utility Fill",
    J$1 = "Whiteboard",
    ml$1 = (_ml = {}, _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_ml, n$1, F$1), o$1, v$1), u$1, S$1), s$1, A$1), h$1, P$1), g$1, j$1), y$1, B$1), e$1, N$1), m$1, k$1), p$1, D$1), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_ml, a$1, C$1), w$1, T$1), b$1, L$1), r$1, W$1), c$1, R$1), i$1, K$1), x$1, U$1), I$1, J$1));
  var E$1 = "kit",
    d$1 = "kit-duotone",
    _$1 = "Kit",
    M$1 = "Kit Duotone",
    rt$1 = _defineProperty(_defineProperty({}, E$1, _$1), d$1, M$1);
  var $t$1 = {
      classic: {
        "fa-brands": "fab",
        "fa-duotone": "fad",
        "fa-light": "fal",
        "fa-regular": "far",
        "fa-solid": "fas",
        "fa-thin": "fat"
      },
      duotone: {
        "fa-regular": "fadr",
        "fa-light": "fadl",
        "fa-thin": "fadt"
      },
      sharp: {
        "fa-solid": "fass",
        "fa-regular": "fasr",
        "fa-light": "fasl",
        "fa-thin": "fast"
      },
      "sharp-duotone": {
        "fa-solid": "fasds",
        "fa-regular": "fasdr",
        "fa-light": "fasdl",
        "fa-thin": "fasdt"
      },
      slab: {
        "fa-regular": "faslr"
      },
      "slab-press": {
        "fa-regular": "faslpr"
      },
      whiteboard: {
        "fa-semibold": "fawsb"
      },
      thumbprint: {
        "fa-light": "fatl"
      },
      notdog: {
        "fa-solid": "fans"
      },
      "notdog-duo": {
        "fa-solid": "fands"
      },
      etch: {
        "fa-solid": "faes"
      },
      jelly: {
        "fa-regular": "fajr"
      },
      "jelly-fill": {
        "fa-regular": "fajfr"
      },
      "jelly-duo": {
        "fa-regular": "fajdr"
      },
      chisel: {
        "fa-regular": "facr"
      },
      utility: {
        "fa-semibold": "fausb"
      },
      "utility-duo": {
        "fa-semibold": "faudsb"
      },
      "utility-fill": {
        "fa-semibold": "faufsb"
      }
    },
    z = {
      classic: ["fas", "far", "fal", "fat", "fad"],
      duotone: ["fadr", "fadl", "fadt"],
      sharp: ["fass", "fasr", "fasl", "fast"],
      "sharp-duotone": ["fasds", "fasdr", "fasdl", "fasdt"],
      slab: ["faslr"],
      "slab-press": ["faslpr"],
      whiteboard: ["fawsb"],
      thumbprint: ["fatl"],
      notdog: ["fans"],
      "notdog-duo": ["fands"],
      etch: ["faes"],
      jelly: ["fajr"],
      "jelly-fill": ["fajfr"],
      "jelly-duo": ["fajdr"],
      chisel: ["facr"],
      utility: ["fausb"],
      "utility-duo": ["faudsb"],
      "utility-fill": ["faufsb"]
    },
    Ht$1 = {
      classic: {
        fab: "fa-brands",
        fad: "fa-duotone",
        fal: "fa-light",
        far: "fa-regular",
        fas: "fa-solid",
        fat: "fa-thin"
      },
      duotone: {
        fadr: "fa-regular",
        fadl: "fa-light",
        fadt: "fa-thin"
      },
      sharp: {
        fass: "fa-solid",
        fasr: "fa-regular",
        fasl: "fa-light",
        fast: "fa-thin"
      },
      "sharp-duotone": {
        fasds: "fa-solid",
        fasdr: "fa-regular",
        fasdl: "fa-light",
        fasdt: "fa-thin"
      },
      slab: {
        faslr: "fa-regular"
      },
      "slab-press": {
        faslpr: "fa-regular"
      },
      whiteboard: {
        fawsb: "fa-semibold"
      },
      thumbprint: {
        fatl: "fa-light"
      },
      notdog: {
        fans: "fa-solid"
      },
      "notdog-duo": {
        fands: "fa-solid"
      },
      etch: {
        faes: "fa-solid"
      },
      jelly: {
        fajr: "fa-regular"
      },
      "jelly-fill": {
        fajfr: "fa-regular"
      },
      "jelly-duo": {
        fajdr: "fa-regular"
      },
      chisel: {
        facr: "fa-regular"
      },
      utility: {
        fausb: "fa-semibold"
      },
      "utility-duo": {
        faudsb: "fa-semibold"
      },
      "utility-fill": {
        faufsb: "fa-semibold"
      }
    },
    G$1 = ["solid", "regular", "light", "thin", "duotone", "brands", "semibold"],
    O$1 = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
    V$1 = O$1.concat([11, 12, 13, 14, 15, 16, 17, 18, 19, 20]),
    $$1 = ["aw", "fw", "pull-left", "pull-right"],
    to = [].concat(_toConsumableArray(Object.keys(z)), G$1, $$1, ["2xs", "xs", "sm", "lg", "xl", "2xl", "beat", "border", "fade", "beat-fade", "bounce", "flip-both", "flip-horizontal", "flip-vertical", "flip", "inverse", "layers", "layers-bottom-left", "layers-bottom-right", "layers-counter", "layers-text", "layers-top-left", "layers-top-right", "li", "pull-end", "pull-start", "pulse", "rotate-180", "rotate-270", "rotate-90", "rotate-by", "shake", "spin-pulse", "spin-reverse", "spin", "stack-1x", "stack-2x", "stack", "ul", "width-auto", "width-fixed", l$1.GROUP, l$1.SWAP_OPACITY, l$1.PRIMARY, l$1.SECONDARY]).concat(O$1.map(function (t) {
      return "".concat(t, "x");
    })).concat(V$1.map(function (t) {
      return "w-".concat(t);
    }));

  var NAMESPACE_IDENTIFIER = '___FONT_AWESOME___';
  var PRODUCTION = function () {
    try {
      return "production" === 'production';
    } catch (e$$1) {
      return false;
    }
  }();
  function familyProxy(obj) {
    // Defaults to the classic family if family is not available
    return new Proxy(obj, {
      get: function get(target, prop) {
        return prop in target ? target[prop] : target[i];
      }
    });
  }
  var _PREFIX_TO_STYLE = _objectSpread2({}, q);

  // We changed FACSSClassesToStyleId in the icons repo to be canonical and as such, "classic" family does not have any
  // duotone styles.  But we do still need duotone in _PREFIX_TO_STYLE below, so we are manually adding
  // {'fa-duotone': 'duotone'}
  _PREFIX_TO_STYLE[i] = _objectSpread2(_objectSpread2(_objectSpread2(_objectSpread2({}, {
    'fa-duotone': 'duotone'
  }), q[i]), qt['kit']), qt['kit-duotone']);
  var PREFIX_TO_STYLE = familyProxy(_PREFIX_TO_STYLE);
  var _STYLE_TO_PREFIX = _objectSpread2({}, _t);

  // We changed FAStyleIdToShortPrefixId in the icons repo to be canonical and as such, "classic" family does not have any
  // duotone styles.  But we do still need duotone in _STYLE_TO_PREFIX below, so we are manually adding {duotone: 'fad'}
  _STYLE_TO_PREFIX[i] = _objectSpread2(_objectSpread2(_objectSpread2(_objectSpread2({}, {
    duotone: 'fad'
  }), _STYLE_TO_PREFIX[i]), ul['kit']), ul['kit-duotone']);
  var STYLE_TO_PREFIX = familyProxy(_STYLE_TO_PREFIX);
  var _PREFIX_TO_LONG_STYLE = _objectSpread2({}, Ht$1);
  _PREFIX_TO_LONG_STYLE[i] = _objectSpread2(_objectSpread2({}, _PREFIX_TO_LONG_STYLE[i]), fl['kit']);
  var PREFIX_TO_LONG_STYLE = familyProxy(_PREFIX_TO_LONG_STYLE);
  var _LONG_STYLE_TO_PREFIX = _objectSpread2({}, $t$1);
  _LONG_STYLE_TO_PREFIX[i] = _objectSpread2(_objectSpread2({}, _LONG_STYLE_TO_PREFIX[i]), ol['kit']);
  var LONG_STYLE_TO_PREFIX = familyProxy(_LONG_STYLE_TO_PREFIX);
  var _FONT_WEIGHT_TO_PREFIX = _objectSpread2({}, gt);
  var FONT_WEIGHT_TO_PREFIX = familyProxy(_FONT_WEIGHT_TO_PREFIX);
  var RESERVED_CLASSES = [].concat(_toConsumableArray(Ht), _toConsumableArray(to));

  function bunker(fn) {
    try {
      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }
      fn.apply(void 0, args);
    } catch (e) {
      if (!PRODUCTION) {
        throw e;
      }
    }
  }

  var w$2 = WINDOW || {};
  if (!w$2[NAMESPACE_IDENTIFIER]) w$2[NAMESPACE_IDENTIFIER] = {};
  if (!w$2[NAMESPACE_IDENTIFIER].styles) w$2[NAMESPACE_IDENTIFIER].styles = {};
  if (!w$2[NAMESPACE_IDENTIFIER].hooks) w$2[NAMESPACE_IDENTIFIER].hooks = {};
  if (!w$2[NAMESPACE_IDENTIFIER].shims) w$2[NAMESPACE_IDENTIFIER].shims = [];
  var namespace = w$2[NAMESPACE_IDENTIFIER];

  function normalizeIcons(icons) {
    return Object.keys(icons).reduce(function (acc, iconName) {
      var icon = icons[iconName];
      var expanded = !!icon.icon;
      if (expanded) {
        acc[icon.iconName] = icon.icon;
      } else {
        acc[iconName] = icon;
      }
      return acc;
    }, {});
  }
  function defineIcons(prefix, icons) {
    var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    var _params$skipHooks = params.skipHooks,
      skipHooks = _params$skipHooks === void 0 ? false : _params$skipHooks;
    var normalized = normalizeIcons(icons);
    if (typeof namespace.hooks.addPack === 'function' && !skipHooks) {
      namespace.hooks.addPack(prefix, normalizeIcons(icons));
    } else {
      namespace.styles[prefix] = _objectSpread2(_objectSpread2({}, namespace.styles[prefix] || {}), normalized);
    }

    /**
     * Font Awesome 4 used the prefix of `fa` for all icons. With the introduction
     * of new styles we needed to differentiate between them. Prefix `fa` is now an alias
     * for `fas` so we'll ease the upgrade process for our users by automatically defining
     * this as well.
     */
    if (prefix === 'fas') {
      defineIcons('fa', icons);
    }
  }

  var icons = {
    "sidebar": [560, 560, [], "e24e", "M289.6 66c5.3-6.3 13.2-10 21.4-10l53 0c35.6 0 65.9 1.7 91.2 7.2 25.6 5.5 47.8 15.2 65.1 32.5s27 39.5 32.5 65.1c5.5 25.3 7.2 55.7 7.2 91.2l0 56c0 35.6-1.7 65.9-7.2 91.2-5.5 25.6-15.2 47.8-32.5 65.1s-39.5 27-65.1 32.5c-25.3 5.5-55.7 7.2-91.2 7.2l-53 0c-8.3 0-16.1-3.6-21.4-10s-7.6-14.7-6.2-22.8C288.7 440.7 294 384.8 294 280s-5.3-160.7-10.6-191.2c-1.4-8.1 .9-16.5 6.2-22.8zM0 308c0 34.1 1.6 63.3 6.5 87.9 4.9 24.7 13.6 46.5 29 63.9 30.9 34.9 80.5 42.8 142.6 44 22 .4 44.9-13.4 49.7-39.5 4.6-24.9 10.2-77.1 10.2-184.3s-5.6-159.4-10.2-184.3c-4.8-26.1-27.7-39.9-49.7-39.5-62.1 1.2-111.7 9.1-142.6 44-15.4 17.4-24 39.2-29 63.9-4.9 24.6-6.5 53.8-6.5 87.9l0 56z"],
    "question": [392, 560, [10067, 10068, 61736], "3f", "M196 420c-23.1 0-44.7 7.5-60.6 23.4s-23.4 37.5-23.4 60.6 7.5 44.7 23.4 60.6 37.5 23.4 60.6 23.4 44.7-7.5 60.6-23.4 23.4-37.5 23.4-60.6-7.5-44.7-23.4-60.6-37.5-23.4-60.6-23.4zM56 196c0-45.3 14.3-79.7 37.3-102.7S150.7 56 196 56 275.7 70.3 298.7 93.3 336 150.7 336 196c0 28.9-8.5 48.9-20.1 63.4-12 14.9-28.5 25.7-46.7 33.2-18.1 7.5-36.6 11.4-50.8 13.4-17 2.4-33.2 1.9-50.4 1.9-15.5 0-28 12.5-28 28s12.5 28 28 28c19.9 0 38.3 .3 58.1-2.5 17.3-2.4 40.8-7.2 64.7-17.2 23.9-9.9 49.3-25.5 68.8-49.9 19.9-24.9 32.4-57.4 32.4-98.4 0-57.4-18.4-107-53.7-142.3S253.4 0 196 0 89 18.4 53.7 53.7 0 138.6 0 196c0 15.5 12.5 28 28 28s28-12.5 28-28z"],
    "minus": [560, 560, [8211, 8722, 10134, "subtract"], "f068", "M0 280c0 20 .4 41.4 7.7 59.2 8.7 21.2 25.3 33.9 47.7 41 20.5 6.5 47.9 9.2 82.8 10.5 93.8 3.5 189.9 3.5 283.7 0 35-1.3 62.3-4 82.8-10.5 22.4-7.1 39-19.8 47.7-41 7.3-17.8 7.7-39.1 7.7-59.2s-.4-41.4-7.7-59.2c-8.7-21.2-25.3-33.9-47.7-41-20.5-6.5-47.9-9.2-82.8-10.5-93.8-3.5-189.9-3.5-283.7 0-35 1.3-62.3 4-82.8 10.5-22.4 7.1-39 19.8-47.7 41-7.3 17.8-7.7 39.1-7.7 59.2z"],
    "microphone-slash": [560, 560, [], "f131", "M47.8 8.2C36.9-2.7 19.1-2.7 8.2 8.2s-10.9 28.7 0 39.6c168 168 336 336 504 504 10.9 10.9 28.7 10.9 39.6 0s10.9-28.7 0-39.6l-97.1-97.1c50.2-45 77.3-111.8 77.3-191.1 0-15.5-12.5-28-28-28s-28 12.5-28 28c0 67.2-22.8 118.4-61 151.4l-42.1-42.1C403.4 308.1 420 269.4 420 224l0-84c0-40.3-12.9-75.9-38.5-101.5S320.3 0 280 0 204.1 12.9 178.5 38.5c-17.7 17.7-29.3 40.1-34.8 65.6L47.8 8.2zM84 224c0-15.5-12.5-28-28-28s-28 12.5-28 28c0 74.5 23.8 138.1 68.9 183.1 39.3 39.3 92.7 62.4 155.1 67.7l0 57.2c0 15.5 12.5 28 28 28s28-12.5 28-28l0-84c0-15.5-12.5-28-28-28-62.4 0-110.8-19.7-143.5-52.5S84 286.4 84 224z"],
    "car": [560, 560, [128664, "automobile"], "f1b9", "M98.1 81.7L70 183.6C60.2 187.4 51.2 192 43.2 197.7 6.9 223.6 0 264.3 0 308s6.9 84.4 43.2 110.3c4.8 3.4 10 6.5 15.4 9.2 2.2 21.3 5.4 42.8 7.8 57.9 4.3 27.3 27.9 46.6 54.9 46.6l26.5 0c23.8 0 46.6-15.5 52.8-40.8 2.7-11.2 5.9-26.4 7.8-43.2l143.3 0c1.9 16.8 5 32 7.8 43.2 6.2 25.3 29 40.8 52.8 40.8l26.4 0c27 0 50.6-19.4 54.9-46.6 2.4-15.1 5.6-36.6 7.8-57.9 5.5-2.7 10.6-5.7 15.4-9.2 36.3-25.9 43.2-66.6 43.2-110.3s-6.9-84.4-43.2-110.3c-8-5.7-17-10.4-26.8-14.1l-28.1-102C449.9 38.1 412.4 5.1 365.7 2.4 342.6 1.1 313.5 0 280 0s-62.6 1.1-85.7 2.4c-46.7 2.7-84.2 35.7-96.2 79.2zM280 56c32.3 0 60.4 1.1 82.5 2.3 21.1 1.2 39.3 16.2 45.4 38.2l20.4 74.1C409.4 168.8 388 168 364 168l-168 0c-24 0-45.4 .8-64.3 2.6l20.4-74.1c6.1-22 24.3-37 45.4-38.2 22.2-1.3 50.2-2.3 82.5-2.3zM154 266a42 42 0 1 1 0 84 42 42 0 1 1 0-84zm252 0a42 42 0 1 1 0 84 42 42 0 1 1 0-84z"],
    "filter": [504, 560, [], "f0b0", "M410.7 28L93.3 28C67.5 28 42.2 32.4 23.9 49.3 5 66.8 0 91.5 0 116l0 48.3c0 29.5 15.5 56.8 40.8 72L130.2 290c7.4 4.4 12.3 12 13.4 20.5L165.3 484c3.4 27.4 26.7 48 54.4 48 5.9 0 11.7-.9 17.3-2.8l47-15.7c30.2-10.1 52.1-36.3 56.6-67.8l19.3-135.4c1.2-8.3 6.1-15.7 13.3-20.1l90-54c25.3-15.2 40.8-42.5 40.8-72l0-48.3c0-24.5-5-49.2-23.9-66.7-18.3-16.9-43.6-21.3-69.5-21.3z"],
    "envelope": [560, 560, [128386, 9993, 61443], "f0e0", "M537 117.5c5.6 9.6 2.9 21.6-5.1 29.3-12.5 12.1-26.9 25.1-42.6 38.1-60.3 49.9-136.1 95.1-209.2 95.1S131.1 234.8 70.8 184.9c-15.7-13-30-26-42.6-38.1-8-7.7-10.7-19.7-5.1-29.3 4.6-7.9 10.1-15.2 16.6-21.8 17.3-17.3 39.5-27 65.1-32.5 25.3-5.5 55.7-7.2 91.2-7.2l168 0c35.6 0 65.9 1.7 91.2 7.2 25.6 5.5 47.8 15.2 65.1 32.5 6.6 6.6 12.1 13.9 16.6 21.8zM.1 308c0 35.6 1.7 65.9 7.2 91.2 5.5 25.6 15.2 47.8 32.5 65.1s39.5 27 65.1 32.5c25.3 5.5 55.7 7.2 91.2 7.2l168 0c35.6 0 65.9-1.7 91.2-7.2 25.6-5.5 47.8-15.2 65.1-32.5s27-39.5 32.5-65.1c5.5-25.3 7.2-55.7 7.2-91.2 0-21.6 .2-43.3 0-64.9-.2-17.9-21.2-26.5-35-15-62.5 51.6-151.2 107.9-244.9 107.9S97.6 279.7 35.1 228.1c-13.8-11.4-34.9-2.9-35 15-.2 21.6 0 43.3 0 64.9z"],
    "at": [560, 560, [61946], "40", "M56 280c0-71 22.5-126.4 60-164s93-60 164-60 126.4 22.5 164 60 60 93 60 164l0 14c0 23.2-18.8 42-42 42s-42-18.8-42-42l0-14c0-40.3-12.9-75.9-38.5-101.5S320.3 140 280 140 204.1 152.9 178.5 178.5 140 239.7 140 280 152.9 355.9 178.5 381.5 239.7 420 280 420c44.4 0 88.9-17.6 114.9-54.5 17.5 16.5 41.1 26.5 67.1 26.5 54.1 0 98-43.9 98-98l0-14c0-83-26.5-153.6-76.5-203.5S363 0 280 0 126.4 26.5 76.5 76.5 0 197 0 280 26.5 433.6 76.5 483.5 197 560 280 560c74.9 0 139.7-21.6 188.4-62.6 11.8-10 13.3-27.6 3.4-39.5s-27.6-13.3-39.5-3.4c-36.9 31.1-88.3 49.4-152.4 49.4-71 0-126.4-22.5-164-60S56 351 56 280z"],
    "truck": [560, 560, [128666, 9951], "f0d1", "M361.7 137.3c1.7 17.5 2.3 36.9 2.3 58.4L364 308c0 15.5 12.5 28 28 28s28-12.5 28-28l0-179.5c0-8.2 4.7-16.5 12.9-16.5l15.1 0c52.3 0 96.2 35.8 108.5 84.3 3.8 15-9.1 27.7-24.5 27.7l-14 0c-15.5 0-28 12.5-28 28s12.5 28 28 28l14 0c15.5 0 28 12.5 28 28l0 56c0 24.9-10.8 47.2-28 62.6l0 7.4c0 27.4-8.8 52.5-27.2 70.8s-43.4 27.2-70.8 27.2-52.5-8.8-70.8-27.2c-15.1-15.1-23.8-34.9-26.4-56.8l-85.6 0c-2.5 21.9-11.2 41.7-26.4 56.8-18.3 18.3-43.4 27.2-70.8 27.2S101.5 523.2 83.2 504.8 56 461.4 56 434l0-12.5c-5.8-3.8-11.3-8.2-16.3-13.2-17.3-17.3-27-39.5-32.5-65.1-5.5-25.3-7.2-55.7-7.2-91.2l0-56c0-35 .8-65 4.7-89.7 3.9-24.8 11.2-47.2 26.5-65.1 15.6-18.2 36.7-28.3 61.4-34 24.2-5.5 53.9-7.3 89.4-7.3 30.2 0 55.9 1.3 77.4 5 21.6 3.8 40.8 10.3 56.6 22.2 32.6 24.5 41.3 64.3 45.7 110.1z"],
    "bell": [504, 560, [128276, 61602], "f0f3", "M109.7 53.7C145 18.4 194.6 0 252 0S359 18.4 394.3 53.7 448 138.6 448 196l0 53c0 5.5 1.6 10.9 4.7 15.5L490 320.5c9.1 13.7 14 29.8 14 46.2 0 35.2-22.7 68.5-60 76.6-38.7 8.4-103.8 18.7-192 18.7S98.7 451.8 60 443.3c-37.3-8.1-60-41.4-60-76.6 0-16.5 4.9-32.5 14-46.2l37.3-55.9c3.1-4.6 4.7-10 4.7-15.5l0-53c0-57.4 18.4-107 53.7-142.3zm95.6 463.4c-12.4-.5-23.7 7.3-27.7 19.1s.3 24.8 10.6 31.9c18.1 12.6 40.2 20 63.8 20s45.7-7.4 63.8-20c10.2-7.1 14.5-20.1 10.6-31.9s-15.2-19.6-27.7-19.1c-14.8 .6-30.4 .9-46.7 .9s-31.9-.3-46.7-.9z"],
    "mobile": [448, 560, [128241, "mobile-android", "mobile-phone"], "f3ce", "M196 0c-35.6 0-65.9 1.7-91.2 7.2-25.6 5.5-47.8 15.2-65.1 32.5s-27 39.5-32.5 65.1C1.7 130.1 0 160.4 0 196L0 364c0 35.6 1.7 65.9 7.2 91.2 5.5 25.6 15.2 47.8 32.5 65.1s39.5 27 65.1 32.5c25.3 5.5 55.7 7.2 91.2 7.2l56 0c35.6 0 65.9-1.7 91.2-7.2 25.6-5.5 47.8-15.2 65.1-32.5s27-39.5 32.5-65.1c5.5-25.3 7.2-55.7 7.2-91.2l0-168c0-35.6-1.7-65.9-7.2-91.2-5.5-25.6-15.2-47.8-32.5-65.1s-39.5-27-65.1-32.5C317.9 1.7 287.6 0 252 0L196 0zM154 140c0-15.5 12.5-28 28-28l84 0c15.5 0 28 12.5 28 28s-12.5 28-28 28l-84 0c-15.5 0-28-12.5-28-28zm70 252a28 28 0 1 1 0 56 28 28 0 1 1 0-56z"],
    "trophy": [616, 560, [127942], "f091", "M308 0C265.3 0 231.9 2.4 207.8 5.1 166.6 9.8 140 45.2 140 83.4l0 28.6-65.4 0c-41.2 0-74.6 33.4-74.6 74.6 0 59.6 26.1 107.9 62.1 152.9 9.7 12.1 27.3 14 39.4 4.4s14-27.3 4.4-39.4c-28-35-49.9-71.2-49.9-117.9 0-10.3 8.3-18.6 18.6-18.6l65.4 0 0 81.8c0 49.3 15.6 92.4 46 123.3 24.5 24.8 56.8 40 94 45l0 72.6c-39.2 2-78.4 6.7-117 13.7-15.2 2.8-25.3 17.3-22.5 32.6s17.3 25.3 32.6 22.5c44.4-8 89.9-13.5 135-13.5s90.6 5.6 135 13.5c15.2 2.8 29.8-7.3 32.6-22.5s-7.3-29.8-22.5-32.6c-38.6-7-77.9-11.7-117-13.7l0-72.6c37.2-5 69.6-20.2 94-45 30.4-30.9 46-74 46-123.3l0-81.8 65.4 0c10.3 0 18.6 8.3 18.6 18.6 0 46.7-21.9 82.9-49.9 117.9-9.7 12.1-7.7 29.7 4.4 39.4s29.7 7.7 39.4-4.4c36-45 62.1-93.3 62.1-152.9 0-41.2-33.4-74.6-74.6-74.6l-65.4 0 0-28.6C476 45.2 449.4 9.8 408.2 5.1 384.1 2.4 350.7 0 308 0z"],
    "camera-slash": [560, 560, [], "e0d9", "M47.8 8.2C36.9-2.7 19.1-2.7 8.2 8.2s-10.9 28.7 0 39.6l504 504c10.9 10.9 28.7 10.9 39.6 0s10.9-28.7 0-39.6L511.6 472c14.5-11.5 25.4-26.5 33.1-45.6 12.2-30.5 15.3-70.1 15.3-118.4l0-28c0-55.3-4-99.9-21.9-132.4-18-32.8-47.3-49-85-56.8L431.2 61.6C415.3 40.4 390.4 28 364 28L196 28c-26.4 0-51.3 12.4-67.2 33.6L117 77.4 47.8 8.2zM242.6 203c10.9-4.5 23.5-7 37.4-7 51.3 0 84 32.7 84 84 0 14-2.4 26.5-7 37.4L242.6 203zM27.1 166.4c9.8-2.8 20.4-.1 27.6 7.1L337.4 456.2c8 8 10.4 20.1 6.1 30.5S328.9 504 317.6 504L196 504c-35.6 0-65.9-1.7-91.2-7.2-25.6-5.5-47.8-15.2-65.1-32.5s-27-39.5-32.5-65.1C1.7 373.9 0 343.6 0 308l0-28c0-36.3 1.8-67.2 7.6-92.9 2.2-10 9.7-17.9 19.5-20.8z"],
    "signal-bars-fair": [616, 560, ["signal-alt-2"], "f692", "M224 224c-30.9 0-56 25.1-56 56l0 196c0 15.5 12.5 28 28 28l28 0c30.9 0 56-25.1 56-56l0-168c0-30.9-25.1-56-56-56zM56 308c-30.9 0-56 25.1-56 56l0 84c0 30.9 25.1 56 56 56l28 0c15.5 0 28-12.5 28-28l0-140c0-15.5-12.5-28-28-28l-28 0z"],
    "gift": [504, 560, [127873], "f06b", "M96.8 149.2c-8.3-15.1-12.4-32.6-12.4-51.2 0-6.2 .5-12.3 1.4-18.3 3.6-23.3 14.5-43.9 32.2-58.4 17.7-14.4 40.2-21.3 64.4-21.3 27 0 51.8 8.6 70 26.3 18.2-17.8 43-26.3 70-26.3 27.4 0 52.5 8.8 70.8 27.2S420.4 70.6 420.4 98c0 18.6-4.1 36.1-12.4 51.2 22.1 5.8 41.3 15.2 56.7 30.5 17.3 17.3 27 39.5 32.5 65.1 2.3 10.5 3.9 22 5 34.3 1.4 15.8-11.4 28.9-27.2 28.9l-166.6 0c-15.5 0-28-12.5-28-28l0-56c0-15.5-12.5-28-28-28s-28 12.5-28 28l0 56c0 15.5-12.5 28-28 28L29.8 308c-15.8 0-28.7-13.1-27.2-28.9 1.1-12.3 2.8-23.8 5-34.3 5.5-25.6 15.2-47.8 32.5-65.1 15.4-15.4 34.6-24.7 56.7-30.5zM291.2 66.8c-6 6-10.8 15.9-10.8 31.2l0 42 42 0c15.4 0 25.3-4.8 31.2-10.8s10.8-15.9 10.8-31.2-4.8-25.3-10.8-31.2-15.9-10.8-31.2-10.8-25.3 4.8-31.2 10.8zM224.4 140l0-42c0-15.4-4.8-25.3-10.8-31.2S197.8 56 182.4 56c-13.7 0-23 3.8-29 8.7-5.9 4.8-10.6 12.3-12.3 23.6-.5 3-.7 6.2-.7 9.7 0 15.4 4.8 25.3 10.8 31.2S167.1 140 182.4 140l42 0zM29.8 364c-15.8 0-28.7 13.1-27.2 28.9 1.1 12.3 2.8 23.8 5 34.3 5.5 25.6 15.2 47.8 32.5 65.1s39.5 27 65.1 32.5c25.3 5.5 55.7 7.2 91.2 7.2 15.5 0 28-12.5 28-28l0-112c0-15.5-12.5-28-28-28L29.8 364zM280.4 504c0 15.5 12.5 28 28 28 35.6 0 65.9-1.7 91.2-7.2 25.6-5.5 47.8-15.2 65.1-32.5s27-39.5 32.5-65.1c2.3-10.5 3.9-22 5-34.3 1.4-15.8-11.4-28.9-27.2-28.9l-166.6 0c-15.5 0-28 12.5-28 28l0 112z"],
    "block-quote": [504, 560, [], "e0b5", "M168 56c-15.5 0-28 12.5-28 28s12.5 28 28 28l308 0c15.5 0 28-12.5 28-28s-12.5-28-28-28L168 56zm0 196c-15.5 0-28 12.5-28 28s12.5 28 28 28l308 0c15.5 0 28-12.5 28-28s-12.5-28-28-28l-308 0zm0 196c-15.5 0-28 12.5-28 28s12.5 28 28 28l308 0c15.5 0 28-12.5 28-28s-12.5-28-28-28l-308 0zM.2 59.1C-1.5 43.7 9.5 29.9 24.9 28.2s29.2 9.4 30.9 24.7C64.1 128.2 70 204.3 70 280S64.1 431.8 55.8 507.1c-1.7 15.4-15.6 26.4-30.9 24.7S-1.5 516.3 .2 500.9C8.2 427.7 14 353.7 14 280S8.2 132.3 .2 59.1z"],
    "gauge": [560, 560, ["dashboard", "gauge-med", "tachometer-alt-average"], "f624", "M76.5 76.5C126.4 26.5 197 0 280 0S433.6 26.5 483.5 76.5 560 197 560 280 533.5 433.6 483.5 483.5c-4.4 4.4-11.8 1.8-13.2-4.3-7.9-35.1-24.1-65.6-48-89.6-29.4-29.4-68.8-47.1-114.3-52.2L308 224c0-15.5-12.5-28-28-28s-28 12.5-28 28l0 113.5c-45.5 5.1-84.9 22.7-114.3 52.2-24 24-40.1 54.5-48 89.6-1.4 6.1-8.8 8.7-13.2 4.3-49.9-49.9-76.5-120.5-76.5-203.5S26.5 126.4 76.5 76.5zM280 140a28 28 0 1 0 0-56 28 28 0 1 0 0 56zm154 14a28 28 0 1 0 -56 0 28 28 0 1 0 56 0zM112 294a28 28 0 1 0 0-56 28 28 0 1 0 0 56zm70-140a28 28 0 1 0 -56 0 28 28 0 1 0 56 0zM448 294a28 28 0 1 0 0-56 28 28 0 1 0 0 56zM280 392c-45.3 0-79.7 14.3-102.7 37.3-19.4 19.4-32.7 47-36.3 82.4-1.1 10.7 5 20.7 14.9 24.8 36.7 15.5 78.5 23.4 124.1 23.4s87.4-8 124.1-23.4c9.9-4.2 16-14.2 14.9-24.8-3.6-35.4-16.9-63-36.3-82.4-23-23-57.4-37.3-102.7-37.3z"],
    "share-nodes": [560, 560, ["share-alt"], "f1e0", "M339 31c20.7-20.7 49.4-31 81-31s60.3 10.2 81 31 31 49.3 31 81-10.2 60.3-31 81-49.4 31-81 31c-31.3 0-62.7-10.7-84.2-34.2L221.2 252.3c1.9 8.9 2.8 18.1 2.8 27.7s-.9 18.8-2.8 27.7l114.6 62.5c21.4-23.5 52.8-34.2 84.2-34.2 31.7 0 60.3 10.2 81 31s31 49.4 31 81-10.2 60.3-31 81-49.4 31-81 31-60.3-10.2-81-31-31-49.4-31-81c0-9.6 .9-18.8 2.8-27.7L196.2 357.8c-21.4 23.5-52.8 34.2-84.2 34.2-31.7 0-60.3-10.2-81-31s-31-49.4-31-81 10.2-60.3 31-81 49.3-31 81-31c31.3 0 62.7 10.7 84.2 34.2l114.6-62.5c-1.9-8.9-2.8-18.1-2.8-27.7 0-31.7 10.2-60.3 31-81z"],
    "ellipsis": [616, 560, ["ellipsis-h"], "f141", "M23.4 219.4C39.3 203.5 60.9 196 84 196s44.7 7.5 60.6 23.4 23.4 37.5 23.4 60.6-7.5 44.7-23.4 60.6-37.5 23.4-60.6 23.4-44.7-7.5-60.6-23.4-23.4-37.5-23.4-60.6 7.5-44.7 23.4-60.6zM308 196c-23.1 0-44.7 7.5-60.6 23.4s-23.4 37.5-23.4 60.6 7.5 44.7 23.4 60.6 37.5 23.4 60.6 23.4 44.7-7.5 60.6-23.4 23.4-37.5 23.4-60.6-7.5-44.7-23.4-60.6-37.5-23.4-60.6-23.4zm163.4 23.4C487.3 203.5 508.9 196 532 196s44.7 7.5 60.6 23.4 23.4 37.5 23.4 60.6-7.5 44.7-23.4 60.6-37.5 23.4-60.6 23.4-44.7-7.5-60.6-23.4-23.4-37.5-23.4-60.6 7.5-44.7 23.4-60.6z"],
    "percent": [560, 560, [62101, 62785, "percentage"], "25", "M259.3 261.2c-70.8 77.9-114.6 136.3-140 174.4-12.3 18.5-24.9 37.3-33.3 58-5.7 14.4 1.2 30.7 15.6 36.4 14.3 5.7 30.5-1.2 36.3-15.4 7.4-17 18.6-33.9 28.9-49.3 23.6-35.4 64.7-90.3 133.9-166.4 70.8-77.9 114.6-136.3 140-174.4 12.3-18.5 24.9-37.3 33.3-58 5.7-14.4-1.2-30.7-15.6-36.4-14.3-5.7-30.5 1.2-36.3 15.4-7.6 17.5-18.3 33.5-28.9 49.3-23.6 35.4-64.7 90.3-133.9 166.4zm83.5 53.6C365.9 291.6 398 280 434 280s68.1 11.6 91.3 34.7 34.7 55.3 34.7 91.3-11.6 68.1-34.7 91.3-55.3 34.7-91.3 34.7-68.1-11.6-91.3-34.7-34.7-55.3-34.7-91.3 11.6-68.1 34.7-91.3zm-308-252C57.9 39.6 90 28 126 28S194.1 39.6 217.3 62.7 252 118 252 154 240.4 222.1 217.3 245.3 162 280 126 280 57.9 268.4 34.7 245.3 0 190 0 154 11.6 85.9 34.7 62.7z"],
    "magnifying-glass": [560, 560, [128269, "search"], "f002", "M196 0C138.6 0 89 18.4 53.7 53.7S0 138.6 0 196 18.4 303 53.7 338.3 138.6 392 196 392 303 373.6 338.3 338.3 392 253.4 392 196 373.6 89 338.3 53.7 253.4 0 196 0zM168 196c0 15.5-12.5 28-28 28s-28-12.5-28-28c0-23.1 7.5-44.7 23.4-60.6S172.9 112 196 112c15.5 0 28 12.5 28 28s-12.5 28-28 28c-11.1 0-17.5 3.4-21 7s-7 10-7 21zM426 327.9c7.3-1.6 14.9-.2 21.1 3.9l67 43.3c28.6 18.5 45.9 50.3 45.9 84.4 0 55.5-45 100.5-100.5 100.5-34.1 0-65.9-17.3-84.4-45.9l-43.3-67c-4-6.2-5.4-13.8-3.9-21.1s6-13.6 12.2-17.6c13.5-8.6 26.1-18.8 37.8-30.4s21.8-24.3 30.4-37.8c4-6.3 10.4-10.7 17.6-12.2z"],
    "palette": [560, 560, [127912], "f53f", "M280 0C197 0 126.4 26.5 76.5 76.5S0 197 0 280 26.5 433.6 76.5 483.5 197 560 280 560c46.4 0 84-37.6 84-84l0-56c0-19.6 6.1-33 14.5-41.5S400.4 364 420 364l56 0c46.4 0 84-37.6 84-84 0-83-26.5-153.6-76.5-203.5S363 0 280 0zM112 266a42 42 0 1 1 84 0 42 42 0 1 1 -84 0zm98 98a42 42 0 1 1 0 84 42 42 0 1 1 0-84zm14-210a42 42 0 1 1 84 0 42 42 0 1 1 -84 0zm182 14a42 42 0 1 1 0 84 42 42 0 1 1 0-84z"],
    "key": [560, 560, [128273], "f084", "M364 0C306.6 0 257 18.4 221.7 53.7S168 138.6 168 196c0 14.2 1.1 27.9 3.3 41.1L24.6 383.8C8.8 399.6 0 420.9 0 443.2L0 476c0 46.4 37.6 84 84 84l32.8 0c22.3 0 43.6-8.9 59.4-24.6l11.6-11.6c5.3-5.3 8.2-12.4 8.2-19.8l0-28 28 0c7.4 0 14.5-3 19.8-8.2l28-28c5.3-5.3 8.2-12.4 8.2-19.8l0-28 84 0c57.4 0 107-18.4 142.3-53.7S560 253.4 560 196 541.6 89 506.3 53.7 421.4 0 364 0zm42 112a42 42 0 1 1 0 84 42 42 0 1 1 0-84z"],
    "skull": [560, 560, [128128], "f54c", "M280 0C197 0 126.4 26.5 76.5 76.5S0 197 0 280c0 71.5 19.7 133.9 57.2 181.8 1.5 1.9 2.5 4.2 3 6.7 5.3 30.5 17.1 56 43.6 72.2 6 3.7 12.6 6.7 19.6 9.1 8.4 2.9 16.7-3.8 16.7-12.7l0-33c0-15.5 12.5-28 28-28s28 12.5 28 28l0 42.1c0 7.6 6.1 13.9 13.7 13.9 9.4 0 18.9 0 28.3-.1 7.7 0 14-6.3 14-14l0-41.9c0-15.5 12.5-28 28-28s28 12.5 28 28l0 36.4c0 8.6 7.8 15.3 16.1 13 21-5.9 34.1-15.4 43.1-27.1 16.9-22 24.8-59 24.8-120.4l0-14c0-15.5 12.5-28 28-28s28 12.5 28 28l0 14c0 28.4-1.5 55.1-5.9 79.3-2.3 12.9 11.7 23.8 22 15.6 6.8-5.5 13.3-11.3 19.5-17.4 49.9-49.9 76.5-120.5 76.5-203.5S533.5 126.4 483.5 76.5 363 0 280 0zM112 238a42 42 0 1 1 84 0 42 42 0 1 1 -84 0zm182-42a42 42 0 1 1 0 84 42 42 0 1 1 0-84zM224 308c10.6 0 20.3 6 25 15.5l14 28c4.3 8.7 3.9 19-1.2 27.2S247.7 392 238 392l-28 0c-9.7 0-18.7-5-23.8-13.3s-5.6-18.6-1.2-27.2l14-28c4.7-9.5 14.4-15.5 25-15.5z"],
    "tree": [504, 560, [127794], "f1bb", "M462.6 168.6c9.1 12 13.4 26.3 13.4 40.4 0 28.9-18.6 57.1-50.4 63.7-31.5 6.5-87.3 14.3-173.6 14.3s-142.2-7.8-173.6-14.3C46.6 266.1 28 237.9 28 209 28 194.9 32.3 180.6 41.4 168.6 63.6 139.3 132 55.5 225.8 6.4 234.1 2 243.1 0 252 0s17.9 2 26.2 6.4C372 55.5 440.4 139.3 462.6 168.6zM280 475.7l0 56.3c0 15.5-12.5 28-28 28s-28-12.5-28-28l0-56.3c-80-1.6-139.5-9.7-172.7-15.5-30.9-5.4-51.3-32.4-51.3-61.9 0-15 5.2-30 15.7-41.8 4.9-5.6 11.7-13 20-21.9 6.9-7.3 17.2-10.4 27-8 59.8 14.5 124.7 16.5 189.3 16.5s129.5-1.9 189.3-16.5c9.8-2.4 20.1 .7 27 8 8.3 8.9 15.1 16.3 20 21.9 10.5 11.8 15.7 26.8 15.7 41.8 0 29.6-20.4 56.5-51.3 61.9-33.2 5.8-92.7 13.9-172.7 15.5z"],
    "flower": [560, 560, [127804, 10047], "f7ff", "M368.8 542.5c26.9-8.7 54.5-20.5 75.8-36s41-38.2 57.6-61c24.5-33.7 13.1-76.4-18.2-99.2 38.8-.1 73.1-28 73.1-69.6 0-28.2-2.6-58.2-10.8-83.2s-23.6-50.8-40.2-73.7c-24.4-33.7-68.6-36.1-100-13.3 11.9-36.9-4-78.2-43.6-91-26.9-8.7-56.2-15.5-82.5-15.5s-55.6 6.8-82.5 15.5c-39.6 12.8-55.5 54.1-43.6 91-31.4-22.7-75.6-20.3-100 13.3-16.6 22.9-32.1 48.6-40.2 73.7S3 248.5 3 276.7c0 41.6 34.3 69.5 73.1 69.6-31.3 22.9-42.7 65.6-18.2 99.2 16.6 22.8 36.3 45.5 57.6 61s49 27.2 75.8 36c39.6 12.9 76.7-11.1 88.7-48 12.1 36.9 49.2 60.9 88.7 48zM219.4 219.4c15.9-15.9 37.5-23.4 60.6-23.4s44.7 7.5 60.6 23.4 23.4 37.5 23.4 60.6-7.5 44.7-23.4 60.6-37.5 23.4-60.6 23.4-44.7-7.5-60.6-23.4-23.4-37.5-23.4-60.6 7.5-44.7 23.4-60.6z"],
    "font-case": [672, 560, [], "f866", "M308.3 480c-5.4-38.1-13.4-77.5-22.5-116l-179.5 0c-9.2 38.5-17.1 77.8-22.5 116-2.2 15.3-16.4 25.9-31.7 23.8S26.1 487.3 28.3 472c23.6-164.9 90.4-347.9 113-406.6 8.8-23 30.8-37.4 54.8-37.4s45.9 14.4 54.8 37.4c22.5 58.7 89.4 241.8 113 406.6 2.2 15.3-8.5 29.5-23.8 31.7s-29.5-8.5-31.7-23.8zM518 252c-36 0-68.1 11.6-91.3 34.7S392 342 392 378 403.6 446.1 426.7 469.3 482 504 518 504c37.1 0 70.3-12.5 93.5-37l6 17.9c4.9 14.7 20.7 22.6 35.4 17.7s22.6-20.7 17.7-35.4l-16.5-49.5c-6.7-20-10.1-40.9-10.1-62l0-89.7c0-15.5-12.5-28-28-28-18.4 0-28 15.5-28 32.1-20-12.1-44-18.1-70-18.1z"],
    "camera": [560, 560, [62258, "camera-alt"], "f030", "M196 28c-26.4 0-51.3 12.4-67.2 33.6L106.9 90.7C69.2 98.5 39.9 114.8 21.9 147.6 4 180.1 0 224.7 0 280l0 28c0 35.6 1.7 65.9 7.2 91.2 5.5 25.6 15.2 47.8 32.5 65.1s39.5 27 65.1 32.5c25.3 5.5 55.7 7.2 91.2 7.2l168 0c35.6 0 65.9-1.7 91.2-7.2 25.6-5.5 47.8-15.2 65.1-32.5s27-39.5 32.5-65.1c5.5-25.3 7.2-55.7 7.2-91.2l0-28c0-55.3-4-99.9-21.9-132.4-18-32.8-47.3-49-85-56.8L431.2 61.6C415.3 40.4 390.4 28 364 28L196 28zm12.9 180.9C226.5 191.2 251.3 182 280 182s53.5 9.2 71.2 26.9 26.8 42.5 26.8 71.1-9.2 53.5-26.8 71.2-42.5 26.8-71.2 26.8-53.5-9.2-71.1-26.8-26.9-42.5-26.9-71.2 9.2-53.5 26.9-71.1z"],
    "eye": [616, 560, [128065], "f06e", "M252 252c21.2 0 39.6-11.8 49.2-29.1 7.4-13.6 19.7-27.3 34.3-22.2 32.9 11.4 56.5 42.6 56.5 79.4 0 46.4-37.6 84-84 84s-84-37.6-84-84c0-3.7 .2-7.4 .7-11 1.6-12.1 15.1-17 27.3-17zM15.9 216C46.6 165.5 138.8 42 308 42S569.4 165.5 600.1 216c11.7 19.2 15.9 40.6 15.9 60.6l0 6.8c0 20-4.2 41.4-15.9 60.6-30.7 50.5-122.9 174-292.1 174S46.6 394.5 15.9 344C4.2 324.8 0 303.4 0 283.4l0-6.8c0-20 4.2-41.4 15.9-60.6zM448 280a140 140 0 1 0 -280 0 140 140 0 1 0 280 0z"],
    "trash": [504, 560, [], "f1f8", "M106.1 73.6l-5.8 45.5c-23-1.9-46-4.1-68.9-6.9-15.3-1.9-29.3 9-31.3 24.3s9 29.3 24.3 31.3C99.8 177.1 176.2 182 252 182s152.2-4.9 227.5-14.2c15.3-1.9 26.2-15.9 24.3-31.3s-15.9-26.2-31.3-24.3c-22.9 2.8-45.9 5-68.9 6.9l-5.7-45.5c-5.3-42-41-73.6-83.4-73.6L189.4 0c-42.4 0-78.1 31.5-83.4 73.6zM91 230.7c-11.3-.9-21 7.9-21 19.3l0 114c0 72.5 14.3 124.4 49.1 157 34.6 32.3 82.7 39 132.9 39s98.3-6.8 132.9-39c34.9-32.6 49.1-84.5 49.1-157l0-114c0-11.3-9.7-20.2-21-19.3-43.3 3.6-101.8 7.3-161 7.3s-117.7-3.7-161-7.3z"],
    "equals": [504, 560, [62764], "3d", "M8.3 199.4c-7.4-17.6-8.3-38.6-8.3-59.4 0-20.2 .4-41 6.9-58.3 7.7-20.7 22.7-33.9 44-41.5 19.1-6.8 44.2-9.5 75.3-10.8 83-3.5 168.6-3.5 251.6 0 31.1 1.3 56.2 4 75.3 10.8 21.3 7.6 36.3 20.9 44 41.5 6.4 17.3 6.9 38.1 6.9 58.3 0 20.8-.9 41.8-8.3 59.4-8.6 20.5-24.3 33.2-45.5 40.6-19.3 6.7-44.5 9.4-75.3 10.7-81 3.5-164.7 3.5-245.7 0-30.8-1.3-56-4-75.3-10.7-21.2-7.4-36.9-20.1-45.5-40.6zM0 420c0 20.8 .9 41.8 8.3 59.4 8.6 20.5 24.3 33.2 45.5 40.6 19.3 6.7 44.5 9.4 75.3 10.7 81 3.5 164.7 3.5 245.7 0 30.8-1.3 56-4 75.3-10.7 21.2-7.4 36.9-20.1 45.5-40.6 7.4-17.6 8.3-38.6 8.3-59.4 0-20.2-.4-41-6.9-58.3-7.7-20.6-22.7-33.9-44-41.5-19.1-6.8-44.2-9.5-75.3-10.8-83-3.5-168.6-3.5-251.6 0-31.1 1.3-56.2 4-75.3 10.8-21.3 7.6-36.3 20.9-44 41.5-6.4 17.3-6.9 38.1-6.9 58.3z"],
    "expand": [560, 560, [], "f065", "M132.4 172l71.8 71.8c10.9 10.9 28.7 10.9 39.6 0s10.9-28.7 0-39.6L172 132.4c20.2-22.8 36.3-45 43.2-54.9 5.9-8.4 8.8-18.2 8.8-28 0-27.3-22.1-49.5-49.5-49.5L56 0C25.1 0 0 25.1 0 56L0 174.5c0 27.3 22.1 49.5 49.5 49.5 9.8 0 19.6-2.9 28-8.8 9.9-7 32.1-23.1 54.9-43.2zM243.8 355.8L172 427.6c20.2 22.8 36.3 45 43.2 54.9 5.9 8.4 8.8 18.2 8.8 28 0 27.3-22.1 49.5-49.5 49.5L56 560c-30.9 0-56-25.1-56-56L0 385.5c0-27.3 22.1-49.5 49.5-49.5 9.8 0 19.6 2.9 28 8.8 9.9 7 32.1 23.1 54.9 43.2l71.8-71.8c10.9-10.9 28.7-10.9 39.6 0s10.9 28.7 0 39.6zm112-39.6L427.6 388c22.8-20.2 45-36.3 54.9-43.2 8.4-5.9 18.2-8.8 28-8.8 27.3 0 49.5 22.1 49.5 49.5L560 504c0 30.9-25.1 56-56 56l-118.5 0c-27.3 0-49.5-22.1-49.5-49.5 0-9.8 2.9-19.6 8.8-28 7-9.9 23.1-32.1 43.2-54.9l-71.8-71.8c-10.9-10.9-10.9-28.7 0-39.6s28.7-10.9 39.6 0zm-39.6-72.4c-10.9-10.9-10.9-28.7 0-39.6L388 132.4c-20.2-22.8-36.3-45-43.2-54.9-5.9-8.4-8.8-18.2-8.8-28 0-27.3 22.1-49.5 49.5-49.5L504 0c30.9 0 56 25.1 56 56l0 118.5c0 27.3-22.1 49.5-49.5 49.5-9.8 0-19.6-2.9-28-8.8-9.9-7-32.1-23.1-54.9-43.2l-71.8 71.8c-10.9 10.9-28.7 10.9-39.6 0z"],
    "stop": [504, 560, [9209], "f04d", "M0 336c0 35.6 1.7 65.9 7.2 91.2 5.5 25.6 15.2 47.8 32.5 65.1s39.5 27 65.1 32.5c25.3 5.5 55.7 7.2 91.2 7.2l112 0c35.6 0 65.9-1.7 91.2-7.2 25.6-5.5 47.8-15.2 65.1-32.5s27-39.5 32.5-65.1c5.5-25.3 7.2-55.7 7.2-91.2l0-112c0-35.6-1.7-65.9-7.2-91.2-5.5-25.6-15.2-47.8-32.5-65.1s-39.5-27-65.1-32.5C373.9 29.7 343.6 28 308 28L196 28c-35.6 0-65.9 1.7-91.2 7.2-25.6 5.5-47.8 15.2-65.1 32.5s-27 39.5-32.5 65.1C1.7 158.1 0 188.4 0 224L0 336z"],
    "command": [504, 560, [], "e142", "M196 168l0-42c0-27.4-8.8-52.5-27.2-70.8S125.4 28 98 28 45.5 36.8 27.2 55.2 0 98.6 0 126 8.8 178.5 27.2 196.8 70.6 224 98 224l42 0 0 112-42 0c-27.4 0-52.5 8.8-70.8 27.2S0 406.6 0 434 8.8 486.5 27.2 504.8 70.6 532 98 532 150.5 523.2 168.8 504.8 196 461.4 196 434l0-42 112 0 0 42c0 27.4 8.8 52.5 27.2 70.8s43.4 27.2 70.8 27.2 52.5-8.8 70.8-27.2 27.2-43.4 27.2-70.8-8.8-52.5-27.2-70.8-43.4-27.2-70.8-27.2l-42 0 0-112 42 0c27.4 0 52.5-8.8 70.8-27.2S504 153.4 504 126 495.2 73.5 476.8 55.2 433.4 28 406 28 353.5 36.8 335.2 55.2 308 98.6 308 126l0 42-112 0zm0 56l112 0 0 112-112 0 0-112z"],
    "tv-retro": [504, 560, [128250], "f401", "M117.6-16.8c9.3-12.4 26.8-14.9 39.2-5.6L252 49 347.2-22.4c12.4-9.3 29.9-6.8 39.2 5.6s6.8 29.9-5.6 39.2l-45.3 34c24 .8 45.3 2.8 63.8 6.8 25.6 5.5 47.8 15.2 65.1 32.5s27 39.5 32.5 65.1c5.5 25.3 7.2 55.7 7.2 91.2l0 84c0 35.6-1.7 65.9-7.2 91.2-5.5 25.6-15.2 47.8-32.5 65.1s-39.5 27-65.1 32.5c-25.3 5.5-55.7 7.2-91.2 7.2l-112 0c-35.6 0-65.9-1.7-91.2-7.2-25.6-5.5-47.8-15.2-65.1-32.5s-27-39.5-32.5-65.1C1.7 401.9 0 371.6 0 336l0-84c0-35.6 1.7-65.9 7.2-91.2 5.5-25.6 15.2-47.8 32.5-65.1s39.5-27 65.1-32.5c18.5-4 39.8-6 63.8-6.8l-45.3-34c-12.4-9.3-14.9-26.8-5.6-39.2zM420 280a28 28 0 1 0 0-56 28 28 0 1 0 0 56zm28 56a28 28 0 1 0 -56 0 28 28 0 1 0 56 0zm-112 0l0-84c0-70-14-84-84-84l-84 0c-70 0-84 14-84 84l0 84c0 70 14 84 84 84l84 0c70 0 84-14 84-84z"],
    "angle-left": [336, 560, [8249], "f104", "M247 560c-12.5 0-24.8-4.5-34.4-13.1-15.2-13.6-53.1-48.3-93.9-92-40.4-43.3-85-97.1-112.3-148.7-4.4-8.4-6.4-17.5-6.4-26.3s2-17.9 6.4-26.3C33.7 202.1 78.3 148.4 118.7 105 159.4 61.3 197.4 26.6 212.6 13.1 222.2 4.5 234.5 0 247 0 282.4 0 306.6 33.7 298.7 66.4 288.7 108 273 187.9 273 280s15.7 172 25.7 213.6c7.9 32.6-16.3 66.4-51.7 66.4z"],
    "circle-half-stroke": [560, 560, [9680, "adjust"], "f042", "M228.7 3.6c44.7-6.5 80.9 27.5 84.8 68.8 4 42.1 8.5 111.3 8.5 207.6s-4.6 165.5-8.5 207.6c-3.9 41.3-40.1 75.3-84.8 68.8-69.3-10-127-40.8-167.3-89.5-40.2-48.6-61.3-112.8-61.3-187S21.1 141.6 61.3 93c40.3-48.7 98.1-79.5 167.3-89.5zM366.1 38C372.1 23.7 388.4 17 402.7 22.9 502.7 64.3 560 158.2 560 280S502.7 495.7 402.7 537.1c-14.3 5.9-30.7-.8-36.6-15.1s.9-30.7 15.1-36.6C457.1 453.9 504 382.8 504 280S457.1 106.1 381.3 74.6C367 68.7 360.2 52.3 366.1 38z"],
    "clock": [560, 560, [128339, "clock-four"], "f017", "M76.5 76.5C126.4 26.5 197 0 280 0S433.6 26.5 483.5 76.5 560 197 560 280 533.5 433.6 483.5 483.5 363 560 280 560 126.4 533.5 76.5 483.5 0 363 0 280 26.5 126.4 76.5 76.5zM308 140c0-15.5-12.5-28-28-28s-28 12.5-28 28l0 116.8c0 22.3 8.9 43.6 24.6 59.4l67.6 67.6c10.9 10.9 28.7 10.9 39.6 0s10.9-28.7 0-39.6l-67.6-67.6c-5.3-5.3-8.2-12.4-8.2-19.8L308 140z"],
    "book": [448, 560, [128212], "f02d", "M104.8 7.2C130.1 1.7 160.4 0 196 0l56 0c35.6 0 65.9 1.7 91.2 7.2 25.6 5.5 47.8 15.2 65.1 32.5s27 39.5 32.5 65.1c5.5 25.3 7.2 55.7 7.2 91.2l0 141.1c0 53-37.9 100.6-93.5 106-28 2.7-63 4.9-102.5 4.9l-113.5 0c-14.7 0-26.5 11.9-26.5 26.5 0 13 9.4 24 22.2 25.5 16.1 1.9 38.9 4 61.8 4l196 0c15.5 0 28 12.5 28 28s-12.5 28-28 28l-196 0c-35.6 0-65.9-1.7-91.2-7.2-25.6-5.5-47.8-15.2-65.1-32.5s-27-39.5-32.5-65.1C1.7 429.9 0 399.6 0 364L0 196c0-35.6 1.7-65.9 7.2-91.2 5.5-25.6 15.2-47.8 32.5-65.1s39.5-27 65.1-32.5zM140 140c-15.5 0-28 12.5-28 28s12.5 28 28 28l168 0c15.5 0 28-12.5 28-28s-12.5-28-28-28l-168 0z"],
    "magnifying-glass-minus": [560, 560, ["search-minus"], "f010", "M224 0C158.1 0 101.5 21.1 61.3 61.3S0 158.1 0 224 21.1 346.5 61.3 386.7 158.1 448 224 448 346.5 426.9 386.7 386.7 448 289.9 448 224 426.9 101.5 386.7 61.3 289.9 0 224 0zM140 196l168 0c15.5 0 28 12.5 28 28s-12.5 28-28 28l-168 0c-15.5 0-28-12.5-28-28s12.5-28 28-28zM414.2 414.2c10.9-10.9 28.7-10.9 39.6 0l98 98c10.9 10.9 10.9 28.7 0 39.6s-28.7 10.9-39.6 0l-98-98c-10.9-10.9-10.9-28.7 0-39.6z"],
    "paper-plane": [560, 560, [61913], "f1d8", "M104 529.3C97.8 531.2 91.8 532 85.7 532 50 532 21 503 21 467.3l0-4.6c0-15.9 5.4-31 14.8-43.2 22.8-29.8 44.2-61.2 61.9-94.3 5.4-10.1 15.6-17.2 27.1-17.2L280 308c15.5 0 28-12.5 28-28s-12.5-28-28-28l-155.2 0c-11.5 0-21.7-7.1-27.1-17.2-17.7-33.1-39.1-64.5-61.9-94.3-9.3-12.2-14.8-27.3-14.8-43.2l0-4.6c0-35.7 29-64.7 64.7-64.7 6 0 12.1 .8 18.3 2.7 21.1 6.4 106 32.6 197.2 69.3 45.6 18.3 93.2 39.4 135.5 62 41.8 22.4 80.3 47.4 106.2 74.1 12.3 12.7 17.1 29 17.1 43.9s-4.9 31.3-17.1 43.9c-25.8 26.7-64.3 51.7-106.2 74.1-42.3 22.7-89.9 43.7-135.5 62-91.2 36.6-176.1 62.9-197.2 69.3z"],
    "heart": [560, 560, [128153, 128154, 128155, 128156, 128420, 129293, 129294, 129505, 9829, 10084, 61578], "f004", "M280 87.2C308.8 47 357.4 28 406 28 450.5 28 489.6 42.3 517.7 70.3S560 137.5 560 182c0 82.1-40.3 154.4-85.3 209.9-45.3 55.8-97.7 97.5-127.2 119-20.2 14.7-44 21.1-67.4 21.1s-47.2-6.5-67.4-21.1C183 489.4 130.6 447.7 85.3 391.9 40.3 336.4 0 264.1 0 182 0 137.5 14.3 98.4 42.3 70.3S109.5 28 154 28c48.6 0 97.2 19 126 59.2z"],
    "battery-half": [672, 560, ["battery-3"], "f242", "M63.2 399.2C57.7 373.9 56 343.6 56 308l0-56c0-35.6 1.7-65.9 7.2-91.2 5.5-25.6 15.2-47.8 32.5-65.1s39.5-27 65.1-32.5C186.1 57.7 216.4 56 252 56l20.1 0c25.6 0 49.3 17.8 53.5 45.3 4.4 29.2 10.4 86.1 10.4 178.7s-6 149.5-10.4 178.7c-4.1 27.5-27.9 45.3-53.5 45.3L252 504c-35.6 0-65.9-1.7-91.2-7.2-25.6-5.5-47.8-15.2-65.1-32.5s-27-39.5-32.5-65.1zM378 476.5c-.5-15.5 11.5-28.4 27-29 57.6-2 80.7-11.5 92.7-26.2 6.3-7.7 11.6-19.3 15.2-38 3.6-18.9 5.1-43.3 5.1-75.3l0-56c0-32-1.5-56.4-5.1-75.3-3.6-18.8-8.9-30.3-15.2-38-12-14.7-35.2-24.2-92.7-26.2-15.5-.5-27.5-13.5-27-29s13.5-27.5 29-27c58.2 2 105.1 11.2 134.1 46.8 14.2 17.4 22.2 38.8 26.8 63 4.6 24.1 6.1 52.6 6.1 85.7l0 56c0 33.1-1.5 61.6-6.1 85.7-4.6 24.2-12.6 45.6-26.8 63-29 35.5-75.9 44.7-134.1 46.8-15.5 .5-28.4-11.5-29-27zM672 224c0-15.5-12.5-28-28-28s-28 12.5-28 28l0 112c0 15.5 12.5 28 28 28s28-12.5 28-28l0-112z"],
    "font-awesome": [560, 560, [62501, 62694, "font-awesome-flag", "font-awesome-logo-full"], "f2b4", "M23.4-4.6C39.3-20.5 60.9-28 84-28s44.7 7.5 60.6 23.4 23.4 37.5 23.4 60.6-7.5 44.7-23.4 60.6c-9.2 9.2-20.4 15.6-32.6 19.4l0 57.5c26.1-4.8 51.5-16.5 72.2-37.3 15.7-15.7 26.1-33.9 32.4-53 3.8-11.5 14.5-19.3 26.6-19.3L462 84c38.7 0 70 31.3 70 70 0 15.1-4.9 29.9-14 42l-63 84 63 84c9.1 12.1 14 26.9 14 42 0 38.7-31.3 70-70 70l-350 0 0 56c0 15.5-12.5 28-28 28s-28-12.5-28-28l0-396C43.7 132.2 32.6 125.9 23.4 116.6 7.5 100.7 0 79.1 0 56S7.5 11.3 23.4-4.6z"],
    "clone": [560, 560, [], "f24d", "M146 330.7c-4.5-21.1-6-46.2-6-75.2l0-91c0-29 1.4-54.1 6-75.2 4.6-21.4 12.9-40.5 27.8-55.5S207.9 10.6 229.3 6c21.1-4.5 46.2-6 75.2-6l91 0c29 0 54.1 1.4 75.2 6 21.4 4.6 40.5 12.9 55.5 27.8S549.4 67.9 554 89.3c4.5 21.1 6 46.2 6 75.2l0 91c0 29-1.4 54.1-6 75.2-4.6 21.4-12.9 40.5-27.8 55.5s-34.1 23.2-55.5 27.8c-21.1 4.6-46.2 6-75.2 6l-91 0c-29 0-54.1-1.4-75.2-6-21.4-4.6-40.5-12.9-55.5-27.8s-23.2-34.1-27.8-55.5zM84 191.3c0-11-6.5-21.1-16.6-25.6s-21.9-2.7-30.1 4.7c-16.5 14.8-25.7 34.2-30.8 56.3-5 21.6-6.5 47.6-6.5 77.7l0 91c0 29 1.4 54.1 6 75.2 4.6 21.4 12.9 40.5 27.8 55.5S67.9 549.4 89.3 554c21.1 4.5 46.2 6 75.2 6l91 0c30.1 0 56.1-1.5 77.7-6.5 22.1-5.1 41.5-14.3 56.3-30.8 7.4-8.2 9.2-20 4.7-30.1S379.7 476 368.7 476l-64.2 0c-30.1 0-60-1.4-87-7.2-28-6-58.2-17.9-83.3-43s-36.9-55.3-43-83.3c-5.8-27-7.2-56.9-7.2-87l0-64.2z"],
    "forward": [560, 560, [9193], "f04e", "M14.2 106.8c6.6-32.1 35-50.8 64.2-50.8 13.5 0 27.2 3.8 39.1 12.3 17.4 12.4 53 39.4 89.7 77.3 5.7 5.9 8.5 14 7.8 22.1-2.9 30.5-4.9 67.7-4.9 112.3s2 81.8 4.9 112.3c.8 8.2-2 16.3-7.8 22.1-36.7 37.9-72.3 64.9-89.7 77.3-11.8 8.4-25.6 12.3-39.1 12.3-29.2 0-57.6-18.8-64.2-50.8-6.5-31.6-14.2-87.3-14.2-173.2S7.7 138.4 14.2 106.8zM344.5 56c13.5 0 27.2 3.8 39.1 12.3 30.1 21.5 120 90.4 170 185.4 4.4 8.4 6.4 17.4 6.4 26.3s-2 17.9-6.4 26.3c-50 95-139.9 164-170 185.4-11.8 8.4-25.6 12.3-39.1 12.3-29.2 0-57.6-18.8-64.2-50.8-6.5-31.6-14.2-87.3-14.2-173.2s7.7-141.6 14.2-173.2c6.6-32.1 35-50.8 64.2-50.8z"],
    "triangle": [560, 560, [9650], "f2ec", "M280.2 28c-24.6 0-49.6 8.7-68.2 27.6-27.6 28-77.2 84.1-125.8 168.4S13.7 379.3 3.2 417.1c-7.1 25.6-2.1 51.6 10.2 72.9s32.3 38.6 58 45.2c38 9.9 111.4 24.8 208.7 24.8 97.2 0 170.5-14.8 208.6-24.6 25.8-6.7 45.9-24 58.2-45.4 12.3-21.3 17.2-47.3 10.1-72.8-10.5-37.9-34.3-108.9-82.9-193.2-48.6-84.3-98.2-140.4-125.8-168.4-18.6-18.9-43.6-27.6-68.2-27.6z"],
    "strikethrough": [616, 560, [], "f0cc", "M532 392c0-15.5-12.5-28-28-28s-28 12.5-28 28c0 33.4-14.4 60-41.4 79.3-27.9 19.9-70.6 32.7-126.6 32.7-86.1 0-138.7-29.6-158.2-68.6-6.9-13.8-23.8-19.4-37.6-12.5s-19.4 23.8-12.5 37.6C133 526.8 212.1 560 308 560 371.7 560 427 545.6 467.2 516.9 508.3 487.5 532 444.2 532 392zM140 168c0-33.4 14.4-60 41.4-79.3 27.9-19.9 70.6-32.7 126.6-32.7 86.1 0 138.7 29.6 158.2 68.6 6.9 13.8 23.8 19.4 37.6 12.5s19.4-23.8 12.5-37.6C483 33.2 403.9 0 308 0 244.3 0 189 14.4 148.8 43.1 107.7 72.5 84 115.8 84 168 84 195.3 91.1 222.8 107.8 244.8 82.2 243 56.6 241 31.1 238.2 15.7 236.5 1.9 247.5 .2 262.9s9.4 29.2 24.7 30.9C118.7 304.1 213.7 308 308 308s189.3-3.9 283.1-14.2c15.4-1.7 26.5-15.6 24.7-30.9s-15.6-26.4-31-24.7c-91.8 10-184.6 13.8-276.8 13.8-58.9 0-102.3-6.7-130.2-20.9-13.4-6.8-22.4-15-28.2-24.3-5.8-9.3-9.6-21.7-9.6-38.8z"],
    "star-half": [616, 560, [61731], "f089", "M336.2 28c0-24.8-18.7-50-44.9-49.9-17.1 .1-31 11.7-39.2 26-13.5 23.6-38.3 68.8-56.8 122.3-56.7 1.1-105.6 9.5-132.2 15-23.3 4.9-40.9 22.1-47.8 43.4s-2.8 45.6 13.2 63.3c18.3 20.1 52.9 55.7 98.1 89.9-16.5 54.2-23 105.3-25.9 132.3-2.6 23.7 8.4 45.7 26.5 58.9s42.5 16.8 64.2 7c42.6-19.2 83.8-42.4 121.7-69.8 14.5-10.5 23.2-27.4 23.2-45.4l0-393z"],
    "arrow-down-to-line": [448, 560, ["arrow-to-bottom"], "f33d", "M39.3 478.4c-14.1-6.2-30.6 .1-36.9 14.2-6.3 14.1 0 30.7 14.1 37 63 28 140.4 30.4 207.4 30.4s144.4-2.5 207.4-30.4c14.1-6.3 20.5-22.9 14.1-37-6.3-14.1-22.8-20.4-36.9-14.2-56.5 23.8-124.9 25.6-184.7 25.6S95.8 502.2 39.3 478.4zM405.2 258c0 12.4-4.3 24.8-13 34.6-18.5 20.9-79.7 86.9-146.9 122-7.1 3.7-14.7 5.4-22.1 5.4s-15-1.7-22.1-5.4c-67.3-35.2-128.5-101.2-147-122-8.7-9.8-13-22.2-13-34.5 0-24.3 16.8-46.7 42.5-51.1 22.1-3.8 60.8-9.1 112.3-10.6L196 28c0-15.5 12.5-28 28-28s28 12.5 28 28l0 168.4c51 1.5 89 6.7 110.8 10.5 25.6 4.5 42.4 26.9 42.4 51.1z"],
    "fire": [504, 560, [128293], "f06d", "M132.6 23.6c15.4-16.1 36.3-23.6 56.8-23.6 31.6 0 61.4 17.9 74.6 48.1 8.6 19.7 19.9 47.3 31 79.5 9.1-11.7 17.7-20.6 24.6-26.9 13.5-12.4 30.4-16.8 45.3-16.8 13.2 0 27.9 3.4 40.7 13 29.5 22.3 98.4 87.9 98.4 211 0 74.5-23.8 138.1-68.9 183.1S326.5 560 252 560 113.9 536.2 68.9 491.1 0 382.5 0 308c0-67.9 24.5-129.6 52.6-178.3 28.2-48.8 61-86.3 80.1-106.1zM252 504a84 84 0 1 0 0-168 84 84 0 1 0 0 168z"],
    "magnifying-glass-plus": [560, 560, ["search-plus"], "f00e", "M224 0C158.1 0 101.5 21.1 61.3 61.3S0 158.1 0 224 21.1 346.5 61.3 386.7 158.1 448 224 448 346.5 426.9 386.7 386.7 448 289.9 448 224 426.9 101.5 386.7 61.3 289.9 0 224 0zm28 140l0 56 56 0c15.5 0 28 12.5 28 28s-12.5 28-28 28l-56 0 0 56c0 15.5-12.5 28-28 28s-28-12.5-28-28l0-56-56 0c-15.5 0-28-12.5-28-28s12.5-28 28-28l56 0 0-56c0-15.5 12.5-28 28-28s28 12.5 28 28zM414.2 414.2c10.9-10.9 28.7-10.9 39.6 0l98 98c10.9 10.9 10.9 28.7 0 39.6s-28.7 10.9-39.6 0l-98-98c-10.9-10.9-10.9-28.7 0-39.6z"],
    "rectangle-vertical": [448, 560, ["rectangle-portrait"], "f2fb", "M196 0c-35.6 0-65.9 1.7-91.2 7.2-25.6 5.5-47.8 15.2-65.1 32.5s-27 39.5-32.5 65.1C1.7 130.1 0 160.4 0 196L0 364c0 35.6 1.7 65.9 7.2 91.2 5.5 25.6 15.2 47.8 32.5 65.1s39.5 27 65.1 32.5c25.3 5.5 55.7 7.2 91.2 7.2l56 0c35.6 0 65.9-1.7 91.2-7.2 25.6-5.5 47.8-15.2 65.1-32.5s27-39.5 32.5-65.1c5.5-25.3 7.2-55.7 7.2-91.2l0-168c0-35.6-1.7-65.9-7.2-91.2-5.5-25.6-15.2-47.8-32.5-65.1s-39.5-27-65.1-32.5C317.9 1.7 287.6 0 252 0L196 0z"],
    "print": [560, 560, [128424, 128438, 9113], "f02f", "M447.7 145.3c-.7-20.3-2.3-38.4-5.8-54.3-4.7-21.9-13.1-41.3-28.4-56.6S378.9 10.8 357 6.1C335.4 1.4 309.7 0 280 0s-55.4 1.4-77 6.1c-21.9 4.7-41.3 13.1-56.6 28.4S122.8 69.1 118.1 91c-3.4 15.9-5.1 34-5.8 54.3-26 4.3-52 12.9-71.8 31-34.6 31.7-40.6 82.7-40.6 145.8S6 436 40.6 467.8c20.2 18.5 47 27 73.5 31.3-1.6-15.4-2.1-32.4-2.1-51l0-98c0-12.1 7.8-22.8 19.2-26.6 12.2-4 25.2-6.2 37.8-8.1 24.2-3.7 60.7-7.3 111-7.3s86.8 3.6 111 7.3c12.6 1.9 25.6 4.1 37.8 8.1 11.4 3.8 19.1 14.5 19.1 26.6l0 98c0 18.6-.6 35.6-2.1 51 26.6-4.3 53.3-12.7 73.5-31.3 34.6-31.7 40.6-82.7 40.6-145.8s-6-114-40.6-145.8c-19.7-18.1-45.8-26.6-71.8-31zM391.4 140l-222.8 0c.7-15 2.1-27.2 4.2-37.2 3.3-15.3 8-23.6 13.2-28.8s13.4-9.9 28.8-13.2C230.4 57.5 251.4 56 280 56s49.6 1.5 65.2 4.8c15.3 3.3 23.6 8 28.8 13.2s9.9 13.4 13.2 28.8c2.2 10 3.5 22.2 4.2 37.2zM345.2 555.2c-15.6 3.4-36.6 4.8-65.2 4.8s-49.6-1.5-65.2-4.8c-24.2-5.2-36.7-17.7-42-42-3.4-15.6-4.8-36.6-4.8-65.2l0-75.7c20.1-3.6 56.5-8.3 112-8.3s91.9 4.6 112 8.3l0 75.7c0 28.6-1.5 49.6-4.8 65.2-5.2 24.2-17.7 36.7-42 42z"],
    "users": [560, 560, [], "f0c0", "M168 28c-31.7 0-60.3 10.2-81 31s-31 49.3-31 81 10.2 60.3 31 81 49.3 31 81 31 60.3-10.2 81-31 31-49.3 31-81-10.2-60.3-31-81-49.3-31-81-31zM363.2 83.2C381.5 64.8 406.6 56 434 56s52.5 8.8 70.8 27.2 27.2 43.4 27.2 70.8-8.8 52.5-27.2 70.8-43.4 27.2-70.8 27.2-52.5-8.8-70.8-27.2-27.2-43.4-27.2-70.8 8.8-52.5 27.2-70.8zM136 294C90.8 294 50.6 299.7 26 332.2 14.3 347.6 8.1 366.5 4.6 387.3 1.1 408.1 0 433 0 462l0 28C0 502.1 7.7 512.8 19.1 516.6 66 532 119.6 532 168 532s102 0 148.9-15.4c11.4-3.8 19.1-14.5 19.1-26.6l0-28c0-29-1.1-53.9-4.6-74.7-3.5-20.8-9.7-39.7-21.4-55.1-24.7-32.4-64.9-38.2-110-38.2l-64 0zm264 0c-9.3 0-18.1 4.7-23.3 12.4s-6.2 17.6-2.6 26.2c6.4 15.5 10.1 31 12.5 45.4 4.3 25.5 5.4 54.1 5.4 84l0 42c0 7.6 3.1 14.8 8.5 20.1s12.8 8.1 20.3 7.9c39.4-1.2 82.4-2.6 120.3-15.5 11.3-3.9 18.9-14.5 18.9-26.5l0-28c0-29-1.1-53.9-4.6-74.7-3.5-20.8-9.7-39.7-21.4-55.1-24.7-32.4-64.9-38.2-110-38.2l-24 0z"],
    "alarm-clock": [616, 560, [9200], "f34e", "M480.8 53.7c18.1-3.1 38.7 2.7 58.8 22.8s25.9 40.7 22.8 58.8c-2.6 15.2 7.6 29.7 22.9 32.3s29.7-7.6 32.3-22.9c6.7-39.1-7.9-77.3-38.4-107.8S510.5-8.2 471.3-1.5c-15.2 2.6-25.5 17.1-22.9 32.3s17.1 25.5 32.3 22.9zM76.6 76.5c-20.1 20.1-25.9 40.7-22.8 58.8 2.6 15.2-7.6 29.7-22.9 32.3S1.2 160-1.4 144.7C-8.1 105.6 6.5 67.4 37 36.9S105.7-8.2 144.8-1.5c15.2 2.6 25.5 17.1 22.9 32.3s-17.1 25.5-32.3 22.9c-18.1-3.1-38.7 2.7-58.8 22.8zM308.1 56C233.6 56 170 79.8 124.9 124.9S56.1 233.5 56.1 308c0 63.5 17.3 119.1 50.4 162L64.3 512.2c-10.9 10.9-10.9 28.7 0 39.6s28.7 10.9 39.6 0L146 509.6c42.9 33 98.5 50.4 162 50.4s119.1-17.3 162-50.4l42.2 42.2c10.9 10.9 28.7 10.9 39.6 0s10.9-28.7 0-39.6L509.7 470c33-42.9 50.4-98.5 50.4-162 0-74.5-23.8-138.1-68.9-183.1S382.5 56 308.1 56zm28 140l0 88.8c0 7.4 3 14.5 8.2 19.8l39.6 39.6c10.9 10.9 10.9 28.7 0 39.6s-28.7 10.9-39.6 0l-39.6-39.6c-15.8-15.8-24.6-37.1-24.6-59.4l0-88.8c0-15.5 12.5-28 28-28s28 12.5 28 28z"],
    "database": [448, 560, [], "f1c0", "M224 0C161.3 0 106.9 11.3 67.2 34 26.6 57.2 0 93.4 0 140s26.6 82.8 67.2 106c39.7 22.7 94.1 34 156.8 34s117.1-11.3 156.8-34c40.6-23.2 67.2-59.4 67.2-106S421.4 57.2 380.8 34C341.1 11.3 286.7 0 224 0zM0 280c0-5.4 6.5-8.3 10.7-4.9 9 7.3 18.6 13.8 28.7 19.5 51.1 29.2 116.2 41.4 184.6 41.4s133.5-12.2 184.6-41.4c10-5.7 19.7-12.2 28.7-19.5 4.2-3.4 10.7-.5 10.7 4.9 0 46.6-26.6 82.8-67.2 106-39.7 22.7-94.1 34-156.8 34S106.9 408.7 67.2 386C26.6 362.8 0 326.6 0 280zM10.7 415.1c-4.2-3.4-10.7-.5-10.7 4.9 0 46.6 26.6 82.8 67.2 106 39.7 22.7 94.1 34 156.8 34s117.1-11.3 156.8-34c40.6-23.2 67.2-59.4 67.2-106 0-5.4-6.5-8.3-10.7-4.9-9 7.3-18.6 13.8-28.7 19.5-51.1 29.2-116.1 41.4-184.6 41.4S90.5 463.8 39.4 434.6c-10-5.7-19.7-12.2-28.7-19.5z"],
    "newspaper": [560, 560, [128240], "f1ea", "M7.2 399.2C1.7 373.9 0 343.6 0 308l0-84c0-15.5 12.5-28 28-28s28 12.5 28 28l0 140c0 15.5 12.5 28 28 28s28-12.5 28-28l0-140c0-35.6 1.7-65.9 7.2-91.2 5.5-25.6 15.2-47.8 32.5-65.1s39.5-27 65.1-32.5C242.1 29.7 272.4 28 308 28l56 0c35.6 0 65.9 1.7 91.2 7.2 25.6 5.5 47.8 15.2 65.1 32.5s27 39.5 32.5 65.1c5.5 25.3 7.2 55.7 7.2 91.2l0 84c0 35.6-1.7 65.9-7.2 91.2-5.5 25.6-15.2 47.8-32.5 65.1s-39.5 27-65.1 32.5c-25.3 5.5-55.7 7.2-91.2 7.2l-168 0c-35.6 0-65.9-1.7-91.2-7.2-25.6-5.5-47.8-15.2-65.1-32.5s-27-39.5-32.5-65.1zM224 182l0 28c0 23.2 18.8 42 42 42l140 0c23.2 0 42-18.8 42-42l0-28c0-23.2-18.8-42-42-42l-140 0c-23.2 0-42 18.8-42 42zm28 126c-15.5 0-28 12.5-28 28s12.5 28 28 28l168 0c15.5 0 28-12.5 28-28s-12.5-28-28-28l-168 0z"],
    "location-arrow": [616, 560, [], "f124", "M485.7 28c-10.3 0-20.4 2.1-29.8 6.2L41.8 215.4C16.4 226.5 0 251.6 0 279.3 0 308.2 17.8 334.1 44.7 344.4l143.6 55.2 55.2 143.6c10.4 26.9 36.2 44.7 65.1 44.7 27.7 0 52.8-16.4 63.9-41.8L553.8 132.1c4.1-9.4 6.2-19.5 6.2-29.8 0-41-33.3-74.3-74.3-74.3z"],
    "city": [560, 560, [127961], "f64f", "M75 33.1c17.4-3.9 37.9-5.1 61-5.1l64 0c23.1 0 43.5 1.2 61 5.1 17.8 4 34.1 11.2 47 24.5 12.8 13.2 19.5 29.9 23.3 47.9 3.7 17.7 4.8 38.7 4.8 62.6l0 224c0 23.9-1.1 44.7-4.5 62.2-3.4 17.6-9.4 33.9-20.7 47-23.1 27-59.2 30.8-96.8 30.8-9.9 0-18-8.1-18-18l0-66c0-15.5-12.5-28-28-28s-28 12.5-28 28l0 66c0 9.9-8.1 18-18 18-37.5 0-73.6-3.8-96.8-30.8-11.3-13.2-17.3-29.4-20.7-47-3.4-17.5-4.5-38.3-4.5-62.2L0 168c0-23.9 1.1-44.8 4.8-62.6 3.7-18 10.5-34.6 23.3-47.9 12.8-13.3 29.2-20.5 47-24.5zM84 168c0 15.5 12.5 28 28 28l112 0c15.5 0 28-12.5 28-28s-12.5-28-28-28l-112 0c-15.5 0-28 12.5-28 28zm0 140c0 15.5 12.5 28 28 28l112 0c15.5 0 28-12.5 28-28s-12.5-28-28-28l-112 0c-15.5 0-28 12.5-28 28zM420 140c-15.5 0-28 12.5-28 28l0 56c0 15.5 12.5 28 28 28l28 0c15.5 0 28 12.5 28 28s-12.5 28-28 28l-28 0c-15.5 0-28 12.5-28 28s12.5 28 28 28l28 0c15.5 0 28 12.5 28 28s-12.5 28-28 28l-29.9 0c-15 0-27.1 11.8-28.9 26.6-.7 6.2-1.7 12.3-2.8 18.2-1.8 9.4-4.4 19.3-8.1 29.5-3.2 8.6-1.9 18.2 3.3 25.7s13.8 12 23 12l19.4 0c23.1 0 43.5-1.2 61-5.1 17.8-4 34.1-11.2 46.9-24.5 12.8-13.2 19.5-29.9 23.3-47.9 3.7-17.7 4.8-38.7 4.8-62.6l0-112c0-21.5-.9-41.3-4.2-58.6-3.4-17.5-9.8-34.2-22.2-47.9-24.7-27.4-64.6-33.5-113.5-33.5z"],
    "arrow-right-to-bracket": [560, 560, ["sign-in"], "f090", "M336 476c-15.5 0-28 12.5-28 28s12.5 28 28 28c35.6 0 65.9-1.7 91.2-7.2 25.6-5.5 47.8-15.2 65.1-32.5s27-39.5 32.5-65.1c5.5-25.3 7.2-55.7 7.2-91.2l0-112c0-35.6-1.7-65.9-7.2-91.2-5.5-25.6-15.2-47.8-32.5-65.1s-39.5-27-65.1-32.5c-25.3-5.5-55.7-7.2-91.2-7.2-15.5 0-28 12.5-28 28s12.5 28 28 28c34.4 0 60.1 1.8 79.4 5.9 19 4.1 30.1 10.1 37.3 17.4s13.3 18.3 17.4 37.3c4.2 19.3 5.9 45 5.9 79.4l0 112c0 34.4-1.8 60.1-5.9 79.4-4.1 19-10.1 30.1-17.4 37.3s-18.3 13.3-37.3 17.4c-19.3 4.2-45 5.9-79.4 5.9zM202.1 98c12.4 0 24.7 4.3 34.6 13 20.8 18.5 86.9 79.7 122 147 3.7 7.1 5.4 14.7 5.4 22.1s-1.7 15-5.4 22.1c-35.1 67.3-101.2 128.5-122 147-9.8 8.7-22.2 13-34.6 13-24.3 0-46.6-16.8-51.1-42.5-3.8-22-9.1-60.3-10.6-111.5L28 308c-15.5 0-28-12.5-28-28s12.5-28 28-28l112.4 0c1.5-51.2 6.7-89.6 10.6-111.5 4.5-25.7 26.8-42.5 51.1-42.5z"],
    "video-slash": [616, 560, [], "f4e2", "M36.2 8.2C47.1-2.7 64.9-2.7 75.8 8.2l55.4 55.4c25.9-5.8 56.9-7.6 92.8-7.6 35.6 0 65.9 1.7 91.2 7.2 25.6 5.5 47.8 15.2 65.1 32.5s27 39.5 32.5 65.1c5.5 25.3 7.2 55.7 7.2 91.2l0 56c0 15.5-.3 29.9-1.1 43.3L579.8 512.2c10.9 10.9 10.9 28.7 0 39.6s-28.7 10.9-39.6 0l-504-504c-10.9-10.9-10.9-28.7 0-39.6zM562.4 140c18.3 0 36.7 11.5 42.1 31.9 4.8 18.1 11.5 53.5 11.5 108.1s-6.7 89.9-11.5 108.1c-5.7 21.8-31.8 37.8-50.5 19.1l-69.8-69.8c-5.3-5.3-8.3-12.5-8.2-20 .2-21.8 0-43.6 0-65.3 0-22.1-.6-43.8-2.6-64.5-1.3-13.5 7.2-25.9 20.2-29.6 21.6-6.2 46-17.9 68.9-17.9zM49.7 162.9c10.1-3.5 21.4-.9 29 6.6L352 442.8c6.6 6.7 9.5 16.2 7.6 25.4s-8.3 16.9-17 20.4c-30.5 12.3-70.3 15.4-118.7 15.4-35.6 0-65.9-1.7-91.2-7.2-25.6-5.5-47.8-15.2-65.1-32.5s-27-39.5-32.5-65.1C29.7 373.9 28 343.6 28 308l0-56c0-24.6 .8-46.6 3.1-65.9 1.2-10.7 8.5-19.7 18.6-23.2z"],
    "comment": [560, 560, [128489, 61669], "f075", "M280 0c-91.8 0-162.5 20.5-210.4 61.8-48.7 41.9-69.6 101.4-69.6 169.2 0 51.3 11.9 98.1 39.3 136.2 27.3 38.1 68.3 65 121.7 80.1-3.8 16.1-10.9 30.8-14.8 38.3-4.2 8-6.2 16.8-6.2 25.8 0 26.8 21.7 48.6 48.6 48.6 11.4 0 22.4-4 31.1-11.3l106.8-88.6c76.7-6.6 135.9-30.2 176-71.1 40.3-41.2 57.6-96.2 57.6-158 0-67.9-20.9-127.3-69.6-169.2-48-41.3-118.6-61.8-210.4-61.8z"],
    "video": [616, 560, ["video-camera"], "f03d", "M28 308c0 35.6 1.7 65.9 7.2 91.2 5.5 25.6 15.2 47.8 32.5 65.1s39.5 27 65.1 32.5c45.4 9.8 137 9.8 182.4 0 25.6-5.5 47.8-15.2 65.1-32.5s27-39.5 32.5-65.1c5.5-25.3 7.2-55.7 7.2-91.2l0-56c0-35.6-1.7-65.9-7.2-91.2-5.5-25.6-15.2-47.8-32.5-65.1s-39.5-27-65.1-32.5c-45.4-9.8-137-9.8-182.4 0-25.6 5.5-47.8 15.2-65.1 32.5s-27 39.5-32.5 65.1C29.7 186.1 28 216.4 28 252l0 56zM550 141.7c4-1.2 8.2-1.7 12.4-1.7 18.3 0 36.7 11.5 42.1 31.9 4.8 18.1 11.5 53.5 11.5 108.1s-6.7 89.9-11.5 108.1c-5.4 20.4-23.8 31.9-42.1 31.9-4.2 0-8.4-.6-12.4-1.7l-56.5-16.1c-13-3.7-21.5-16.2-20.2-29.6 2-20.7 2.6-42.4 2.6-64.5l0-56c0-22.1-.6-43.8-2.6-64.5-1.3-13.5 7.2-25.9 20.2-29.6L550 141.7z"],
    "wheelchair-move": [504, 560, ["wheelchair-alt"], "e2ce", "M364 0c-23.1 0-44.7 7.5-60.6 23.4S280 60.9 280 84 287.5 128.7 303.4 144.6 340.9 168 364 168 408.7 160.5 424.6 144.6 448 107.1 448 84 440.5 39.3 424.6 23.4 387.1 0 364 0zM42.3 294.3c28-28 67.1-42.3 111.7-42.3 22.2 0 43 3.5 61.8 10.6l35.1-35.1c1.5-1.5 1.4-4.2-.2-5.5l-60.9-50.7c-4.7-3.9-11.8-4.3-16.9-.9L99.5 219.3c-12.9 8.6-30.3 5.1-38.8-7.8s-5.1-30.3 7.8-38.8l73.4-48.9c11.5-7.7 25.1-11.8 38.9-11.8 16.4 0 32.3 5.8 44.9 16.3L286.5 179c13.6 11.3 21.5 28.2 21.5 45.9 0 15.8-6.3 31-17.5 42.2l-26 26c12.5 12.2 22.5 26.7 29.6 42.9l76 0c43 0 77.9 34.9 77.9 77.9 0 6.4-.8 12.7-2.3 18.9l-26.5 106c-3.7 15-19 24.1-34 20.4s-24.1-19-20.4-34l26.5-106c3.4-13.4-7.2-27.2-21.2-27.2l-62.6 0c.3 4.6 .5 9.3 .5 14 0 44.5-14.3 83.6-42.3 111.7S198.5 560 154 560 70.4 545.7 42.3 517.7 0 450.5 0 406 14.3 322.4 42.3 294.3z"],
    "bold": [504, 560, [], "f032", "M28 28C12.5 28 0 40.5 0 56S12.5 84 28 84l28 0 0 392-28 0c-15.5 0-28 12.5-28 28s12.5 28 28 28l364 0c31.7 0 60.3-10.2 81-31s31-49.4 31-81-10.2-60.3-31-81-49.4-31-81-31l-84 0c-15.5 0-28-12.5-28-28s12.5-28 28-28l28 0c31.7 0 60.3-10.2 81-31s31-49.3 31-81-10.2-60.3-31-81-49.4-31-81-31L28 28z"],
    "clipboard": [448, 560, [128203], "f328", "M79 102.5c-2.1-14.7-17.2-24.8-29-15.8-23.7 18-36.7 45.5-42.9 74.1-5.5 25.3-7.2 55.7-7.2 91.2L0 364c0 35.6 1.7 65.9 7.2 91.2 5.5 25.6 15.2 47.8 32.5 65.1s39.5 27 65.1 32.5c25.3 5.5 55.7 7.2 91.2 7.2l56 0c35.6 0 65.9-1.7 91.2-7.2 25.6-5.5 47.8-15.2 65.1-32.5s27-39.5 32.5-65.1c5.5-25.3 7.2-55.7 7.2-91.2l0-112c0-35.6-1.7-65.9-7.2-91.2-6.2-28.6-19.2-56.1-42.9-74.1-11.8-9-26.9 1.1-29 15.8-3.6 25.2-12.6 47.9-32.2 64.7-26.4 22.6-65.4 28.8-112.7 28.8s-86.4-6.2-112.7-28.8C91.6 150.3 82.6 127.7 79 102.5zM140 280l168 0c15.5 0 28 12.5 28 28s-12.5 28-28 28l-168 0c-15.5 0-28-12.5-28-28s12.5-28 28-28zM112 420c0-15.5 12.5-28 28-28l168 0c15.5 0 28 12.5 28 28s-12.5 28-28 28l-168 0c-15.5 0-28-12.5-28-28zM224 0C178 0 157.5 6.9 147.7 15.3 139.4 22.5 133 36 133 70s6.4 47.5 14.7 54.7C157.5 133.1 178 140 224 140s66.5-6.9 76.3-15.3C308.6 117.5 315 104 315 70s-6.4-47.5-14.7-54.7C290.5 6.9 270 0 224 0z"],
    "laptop": [616, 560, [128187], "f109", "M56 280l0-56c0-35.6 1.7-65.9 7.2-91.2 5.5-25.6 15.2-47.8 32.5-65.1s39.5-27 65.1-32.5C186.1 29.7 216.4 28 252 28l112 0c35.6 0 65.9 1.7 91.2 7.2 25.6 5.5 47.8 15.2 65.1 32.5s27 39.5 32.5 65.1c5.5 25.3 7.2 55.7 7.2 91.2l0 56c0 15.3-12.7 28-28 28L84 308c-15.3 0-28-12.7-28-28zM0 440c0 23.7 13.7 48.8 41.5 56.2 34.6 9.2 110.2 21.8 266.5 21.8s231.9-12.6 266.5-21.8c27.8-7.4 41.5-32.5 41.5-56.2s-5-48.2-27.5-62.9c-19.1-12.6-43.7-13.1-65.8-13.1L93.3 364C71.2 364 46.7 364.5 27.5 377.1 5 391.8 0 416.3 0 440z"],
    "battery-three-quarters": [672, 560, ["battery-4"], "f241", "M574 308c0 45-2.7 82.3-12.8 111.6-10.7 31.3-29.8 53.6-59.8 67-14.1 6.3-30.7 0-37-14.1s0-30.7 14.1-37c14.6-6.5 23.5-16.1 29.7-34 6.8-19.9 9.8-49.1 9.8-93.4l0-56c0-44.3-3-73.6-9.8-93.4-6.1-17.9-15-27.5-29.7-34-14.1-6.3-20.4-22.9-14.1-37s22.9-20.4 37-14.1c30 13.4 49.1 35.7 59.8 67 10 29.3 12.8 66.6 12.8 111.6l0 56zM420 280c0 101-5 153.1-9.4 179.6-4.8 29-29.9 44.4-54.2 44.4L252 504c-35.6 0-65.9-1.7-91.2-7.2-25.6-5.5-47.8-15.2-65.1-32.5s-27-39.5-32.5-65.1C57.7 373.9 56 343.6 56 308l0-56c0-35.6 1.7-65.9 7.2-91.2 5.5-25.6 15.2-47.8 32.5-65.1s39.5-27 65.1-32.5C186.1 57.7 216.4 56 252 56l104.4 0c24.4 0 49.5 15.4 54.2 44.4 4.4 26.5 9.4 78.6 9.4 179.6zm224-84c15.5 0 28 12.5 28 28l0 112c0 15.5-12.5 28-28 28s-28-12.5-28-28l0-112c0-15.5 12.5-28 28-28z"],
    "thumbs-down": [560, 560, [128078, 61576], "f165", "M88 56C64.1 56 36.7 57.7 18.6 77.3 9.6 87.2 5.2 99.1 2.9 110.7 .6 122.1 0 135.2 0 149.3L0 326.7c0 14.1 .6 27.2 2.9 38.6 2.3 11.6 6.7 23.5 15.8 33.4 18 19.6 45.5 21.3 69.4 21.3l6 0c23.9 0 51.3-1.7 69.4-21.3 9.1-9.9 13.5-21.8 15.7-33.4 2.3-11.4 2.9-24.5 2.9-38.6l0-177.3c0-14.1-.6-27.2-2.9-38.6-2.3-11.6-6.7-23.5-15.7-33.4-18-19.6-45.5-21.3-69.4-21.3l-6 0zM257.1 75.4c-11.4 3.8-19.1 14.5-19.1 26.6 0 118.8-1.7 184.8-3.5 220.9-1.3 27.1-2.6 37.2-2.9 39.1-1.8 8.4 .4 17.3 5.9 23.9 38.9 46.7 51.3 93 55.1 121.2 3.9 28.5 27.9 56.9 62.2 56.9 37 0 64.6-34.1 56.8-70.3L388.3 384.9c-1.9-8.7 4.8-16.9 13.7-16.9l82.2 0c16.3 0 43.7-4.6 56.9-30.7 10.3-20.2 18.9-53.5 18.9-109.3 0-70.9-26.4-117-46.3-141.4-15.7-19.2-38.2-27.2-58.4-28.7-64.7-4.9-135.7-3.1-198.1 17.5z"],
    "utensils": [560, 560, [127860, 61685, "cutlery"], "f2e7", "M28 28c15.5 0 28 12.5 28 28l0 75.3c14.4 2.7 34.6 5.9 56 7.5L112 56c0-15.5 12.5-28 28-28s28 12.5 28 28l0 82.9c21.4-1.6 41.6-4.8 56-7.5L224 56c0-15.5 12.5-28 28-28s28 12.5 28 28l0 140c0 61.9-50.1 112-112 112l0 196c0 15.5-12.5 28-28 28s-28-12.5-28-28l0-196C50.1 308 0 257.9 0 196L0 56C0 40.5 12.5 28 28 28zM476 392l0 112c0 15.5 12.5 28 28 28s28-12.5 28-28l0-403c0-40.3-32.7-73-73-73-25 0-49.4 12.9-61.9 36.6-20.5 38.8-61 126.1-61 215.4 0 61.9 50.1 112 112 112l28 0z"],
    "circle-xmark": [560, 560, [61532, "times-circle", "xmark-circle"], "f057", "M76.5 76.5C126.4 26.5 197 0 280 0S433.6 26.5 483.5 76.5 560 197 560 280 533.5 433.6 483.5 483.5 363 560 280 560 126.4 533.5 76.5 483.5 0 363 0 280 26.5 126.4 76.5 76.5zm139.3 99.7c-10.9-10.9-28.7-10.9-39.6 0s-10.9 28.7 0 39.6l64.2 64.2-64.2 64.2c-10.9 10.9-10.9 28.7 0 39.6s28.7 10.9 39.6 0l64.2-64.2 64.2 64.2c10.9 10.9 28.7 10.9 39.6 0s10.9-28.7 0-39.6l-64.2-64.2 64.2-64.2c10.9-10.9 10.9-28.7 0-39.6s-28.7-10.9-39.6 0l-64.2 64.2-64.2-64.2z"],
    "microphone": [504, 560, [], "f130", "M150.5 38.5C176.1 12.9 211.7 0 252 0S327.9 12.9 353.5 38.5 392 99.7 392 140l0 84c0 40.3-12.9 75.9-38.5 101.5S292.3 364 252 364 176.1 351.1 150.5 325.5 112 264.3 112 224l0-84c0-40.3 12.9-75.9 38.5-101.5zM28 196c15.5 0 28 12.5 28 28 0 62.4 19.7 110.8 52.5 143.5S189.6 420 252 420 362.8 400.3 395.5 367.5 448 286.4 448 224c0-15.5 12.5-28 28-28s28 12.5 28 28c0 74.5-23.8 138.1-68.9 183.1-39.3 39.3-92.7 62.4-155.1 67.7l0 57.2c0 15.5-12.5 28-28 28s-28-12.5-28-28l0-57.2c-62.4-5.3-115.8-28.4-155.1-67.7-45-45-68.9-108.7-68.9-183.1 0-15.5 12.5-28 28-28z"],
    "crown": [560, 560, [128081], "f521", "M215.4 42.7C226.5 16.8 251.9 0 280.1 0s53.7 16.8 64.8 42.7L404.6 182 451.2 151c10.7-7.2 23.3-11 36.2-11 40.7 0 71.5 36.9 64.3 77L509.6 448.4c-5.5 30-27.2 56-58.9 63.6-35.8 8.6-97.4 20-170.5 20s-134.7-11.5-170.5-20c-31.7-7.6-53.5-33.6-58.9-63.6L8.6 217c-7.3-40.1 23.5-77 64.3-77 12.9 0 25.5 3.8 36.2 11L155.6 182 215.4 42.7zM280.1 392a56 56 0 1 0 0-112 56 56 0 1 0 0 112z"],
    "arrow-up-wide-short": [616, 560, ["sort-amount-up"], "f161", "M302 187.9c5.3 9.3 7.6 19.3 7.6 28.8 0 23.5-14.5 48.1-42.2 54-17.3 3.7-44.4 7.6-84.6 8.8l0 196.4c0 15.5-12.5 28-28 28s-28-12.5-28-28l0-196.4c-40.3-1.3-67.3-5.1-84.6-8.8-27.7-5.9-42.2-30.6-42.2-54 0-9.5 2.2-19.6 7.6-28.8 12.4-21.5 55.1-89.5 123.4-126 7.7-4.1 15.9-5.9 23.8-5.9s16.1 1.8 23.8 5.9c68.3 36.5 111 104.5 123.4 126zM364 84c-15.5 0-28 12.5-28 28s12.5 28 28 28l224 0c15.5 0 28-12.5 28-28s-12.5-28-28-28L364 84zM336 448c0-15.5 12.5-28 28-28l112 0c15.5 0 28 12.5 28 28s-12.5 28-28 28l-112 0c-15.5 0-28-12.5-28-28zm28-196c-15.5 0-28 12.5-28 28s12.5 28 28 28l168 0c15.5 0 28-12.5 28-28s-12.5-28-28-28l-168 0z"],
    "sun": [616, 560, [9728], "f185", "M224 280c0-28.2 8.8-48.6 22.1-61.9s33.7-22.1 61.9-22.1 48.6 8.8 61.9 22.1 22.1 33.7 22.1 61.9-8.8 48.6-22.1 61.9-33.7 22.1-61.9 22.1-48.6-8.8-61.9-22.1-22.1-33.7-22.1-61.9zM279.9-5.8c8.7-5.6 18.5-8.2 28.1-8.2s19.5 2.6 28.1 8.2c20.9 13.5 40.4 29.4 58 45.8 6.2 5.8 14.2 9.1 22.7 9.4 24 .9 49 3.4 73.4 8.6 10.1 2.2 18.9 7.3 25.7 14.1S527.8 87.8 530 97.8c5.2 24.3 7.7 49.3 8.6 73.4 .3 8.4 3.6 16.5 9.4 22.7 16.4 17.6 32.3 37.1 45.8 57.9 5.6 8.7 8.2 18.5 8.2 28.1s-2.6 19.5-8.2 28.1c-13.5 20.9-29.4 40.4-45.8 58-5.8 6.2-9.1 14.2-9.4 22.7-.9 24-3.4 49-8.6 73.4-2.2 10.1-7.3 18.9-14.1 25.7s-15.6 11.9-25.7 14.1c-24.3 5.2-49.3 7.7-73.4 8.6-8.4 .3-16.5 3.6-22.7 9.4-17.6 16.4-37.1 32.3-58 45.8-8.7 5.6-18.5 8.2-28.1 8.2s-19.5-2.6-28.1-8.2c-20.9-13.5-40.4-29.4-57.9-45.8-6.2-5.8-14.2-9.1-22.7-9.4-24-.9-49-3.4-73.4-8.6-10.1-2.2-18.9-7.3-25.7-14.1S88.2 472.2 86 462.2c-5.2-24.3-7.7-49.3-8.6-73.4-.3-8.4-3.6-16.5-9.4-22.7-16.4-17.6-32.3-37.1-45.8-58-5.6-8.7-8.2-18.5-8.2-28.1s2.6-19.5 8.2-28.1c13.5-20.9 29.4-40.4 45.8-57.9 5.8-6.2 9.1-14.2 9.4-22.7 .9-24 3.4-49 8.6-73.4 2.2-10.1 7.3-18.9 14.1-25.7S115.8 60.2 125.8 58c24.3-5.2 49.3-7.7 73.4-8.6 8.4-.3 16.5-3.6 22.7-9.4 17.6-16.4 37.1-32.3 57.9-45.8zM308 140c-40.3 0-75.9 12.9-101.5 38.5S168 239.7 168 280 180.9 355.9 206.5 381.5 267.7 420 308 420 383.9 407.1 409.5 381.5 448 320.3 448 280 435.1 204.1 409.5 178.5 348.3 140 308 140z"],
    "image": [504, 560, [], "f03e", "M42.5 357.5C24.5 366.5 0 356.1 0 336L0 224c0-35.6 1.7-65.9 7.2-91.2 5.5-25.6 15.2-47.8 32.5-65.1s39.5-27 65.1-32.5C130.1 29.7 160.4 28 196 28l112 0c35.6 0 65.9 1.7 91.2 7.2 25.6 5.5 47.8 15.2 65.1 32.5s27 39.5 32.5 65.1c5.5 25.3 7.2 55.7 7.2 91.2l0 21.6c0 7-6.5 12.3-13.4 11.1-18.1-3.1-37-4.6-56.6-4.6-83.8 0-154.1 28.6-201.5 81.3-8.3 9.3-21.3 13.1-33.4 9.9-18.5-4.8-38.3-7.2-59.1-7.2-36.1 0-69.1 7.3-97.5 21.5zM154 224a42 42 0 1 0 0-84 42 42 0 1 0 0 84zM23.4 446.1c-4.7 7-5.1 16-.9 23.4 4.7 8.3 10.3 15.9 17.2 22.8 17.3 17.3 39.5 27 65.1 32.5 25.3 5.5 55.7 7.2 91.2 7.2l71.7 0c6.8 0 12.3-5.5 11.9-12.3-.2-4.2-.6-8.2-1.1-12.2-2.1-16.9-6.5-32-12.8-45.3-11.1-23.5-28.3-41.2-49.8-52.8-20.2-11-45.6-17.4-75.9-17.4-25.9 0-48.2 4.7-66.8 12.9-14 6.2-26 14.5-35.9 24.4-5.1 5.1-9.7 10.7-13.9 16.8zm310.6 54.4c.6 5 1.1 10.1 1.4 15.3 .5 8.6 7.7 15.6 16.3 15.1 17.4-1.1 33.2-3 47.4-6 25.6-5.5 47.8-15.2 65.1-32.5s27-39.5 32.5-65.1c6.8-31.5 7.2-64.1 7.2-96.3 0-8.3-5.5-15.7-13.7-17.4-5.9-1.2-11.9-2.3-18.1-3.1-12.1-1.6-24.9-2.5-38.3-2.5-64.8 0-115.9 19.8-151.3 53.9-8.3 8-6.7 21.2 1.3 29.5 25.6 26.3 44.1 62.7 50 109.1z"],
    "notdef": [448, 560, [], "e1fe", "M104.8 7.2C130.1 1.7 160.4 0 196 0l56 0c35.6 0 65.9 1.7 91.2 7.2 25.6 5.5 47.8 15.2 65.1 32.5s27 39.5 32.5 65.1c5.5 25.3 7.2 55.7 7.2 91.2l0 168c0 35.6-1.7 65.9-7.2 91.2-5.5 25.6-15.2 47.8-32.5 65.1s-39.5 27-65.1 32.5c-25.3 5.5-55.7 7.2-91.2 7.2l-56 0c-35.6 0-65.9-1.7-91.2-7.2-25.6-5.5-47.8-15.2-65.1-32.5s-27-39.5-32.5-65.1C1.7 429.9 0 399.6 0 364L0 196c0-35.6 1.7-65.9 7.2-91.2 5.5-25.6 15.2-47.8 32.5-65.1s39.5-27 65.1-32.5zM61.9 116.6c-4.2 19.3-5.9 45-5.9 79.4l0 168c0 34.4 1.8 60.1 5.9 79.4 .3 1.6 .7 3.1 1.1 4.6L189 280 63 112c-.4 1.5-.7 3-1.1 4.6zM224 326.7L99.2 493c4.9 1.9 10.6 3.6 17.4 5 19.3 4.2 45 5.9 79.4 5.9l56 0c34.4 0 60.1-1.8 79.4-5.9 6.7-1.5 12.4-3.1 17.4-5L224 326.7zM259 280L385 448c.4-1.5 .7-3 1.1-4.6 4.2-19.3 5.9-45 5.9-79.4l0-168c0-34.4-1.8-60.1-5.9-79.4-.3-1.6-.7-3.1-1.1-4.6L259 280zM348.8 67c-4.9-1.9-10.6-3.6-17.4-5-19.3-4.2-45-5.9-79.4-5.9l-56 0c-34.4 0-60.1 1.8-79.4 5.9-6.7 1.5-12.4 3.1-17.4 5L224 233.3 348.8 67z"],
    "pencil": [560, 560, [9999, 61504, "pencil-alt"], "f303", "M345.4 31.1c23.4-20.4 53.3-31.1 83.8-31.1 72.2 0 130.8 58.6 130.8 130.8 0 30.5-10.6 60.4-31.1 83.8-8.8 10-19.7 22.4-32.4 36.5-12.1 13.5-32.3 15.9-47 5.4-24.2-17.3-54.3-40.8-79.7-66.3s-48.9-55.6-66.3-79.7c-10.6-14.7-8.1-34.9 5.4-47 14.1-12.7 26.4-23.6 36.5-32.4zM258 143.1c-7.3-10.2-22.1-11.8-31.1-3.1-10.8 10.5-21.9 21.4-33.2 32.7-65.1 65.1-118.3 124.9-145.8 156.5-16.8 19.4-27.4 43-31.3 67.9L.7 497.6c-.4 2.8-.7 5.6-.7 8.4 0 29.8 24.2 54 54 54 2.8 0 5.6-.2 8.4-.7l100.5-15.9c24.9-3.9 48.5-14.5 67.8-31.3 31.6-27.4 91.3-80.6 156.5-145.8 11.3-11.3 22.2-22.4 32.7-33.2 8.8-9.1 7.2-23.8-3.1-31.1-25.4-18.2-58.2-43.7-86.7-72.2s-54-61.3-72.2-86.7z"],
    "battery-low": [672, 560, ["battery-1"], "e0b1", "M76.4 437.6C59.8 405.4 56 361.8 56 308l0-56c0-53.8 3.8-97.4 20.4-129.6 18.3-35.6 49.6-52.9 90.9-60.5 29.6-5.5 56.5 14.8 60.7 43.6 4.3 29.3 10 84.8 10 174.5s-5.7 145.1-10 174.5c-4.3 28.8-31.2 49.1-60.7 43.6-41.3-7.7-72.5-24.9-90.9-60.5zM280 476c0-15.5 12.5-28 28-28l70 0c34.4 0 60.1-1.8 79.4-5.9 19-4.1 30.1-10.1 37.3-17.4s13.3-18.3 17.4-37.3c4.2-19.3 5.9-45 5.9-79.4l0-56c0-34.4-1.8-60.1-5.9-79.4-4.1-19-10.1-30.1-17.4-37.3s-18.3-13.3-37.3-17.4c-19.3-4.2-45-5.9-79.4-5.9l-70 0c-15.5 0-28-12.5-28-28s12.5-28 28-28l70 0c35.6 0 65.9 1.7 91.2 7.2 25.6 5.5 47.8 15.2 65.1 32.5s27 39.5 32.5 65.1c5.5 25.3 7.2 55.7 7.2 91.2l0 56c0 35.6-1.7 65.9-7.2 91.2-5.5 25.6-15.2 47.8-32.5 65.1s-39.5 27-65.1 32.5c-25.3 5.5-55.7 7.2-91.2 7.2l-70 0c-15.5 0-28-12.5-28-28zM672 224c0-15.5-12.5-28-28-28s-28 12.5-28 28l0 112c0 15.5 12.5 28 28 28s28-12.5 28-28l0-112z"],
    "lightbulb": [448, 560, [128161], "f0eb", "M224 0C158.1 0 101.5 21.1 61.3 61.3S0 158.1 0 224c0 73 33.3 118 62.1 154 23.2 28.9 49.9 58.7 49.9 98 0 31.7 10.2 60.3 31 81s49.4 31 81 31 60.3-10.2 81-31 31-49.4 31-81c0-11.2-11.2-21.6-22-18.7-19 5-38.8 8.4-59.5 10.3-15.4 1.4-29-10-30.4-25.4s10-29 25.4-30.4c61.1-5.6 110.8-26.7 144.9-58.5 33.4-31.3 53.4-74.3 53.6-128.1l0-1.1c0-65.9-21.1-122.5-61.3-162.7S289.9 0 224 0zM140 224c0 15.5-12.5 28-28 28s-28-12.5-28-28c0-40.3 12.9-75.9 38.5-101.5S183.7 84 224 84c15.5 0 28 12.5 28 28s-12.5 28-28 28c-28.2 0-48.6 8.8-61.9 22.1S140 195.8 140 224z"],
    "code": [672, 560, [], "f121", "M419.3 34.1C422.7 19 413.2 4 398.1 .7S368 6.8 364.7 21.9l-112 504c-3.4 15.1 6.2 30.1 21.3 33.4s30.1-6.2 33.4-21.3l112-504zm82 58.6c-10.7 11.2-10.3 28.9 .9 39.6 31.5 30 80 82.8 113.7 147.7-34.3 66-85.2 127.3-143.3 174-12.1 9.6-14.3 27.1-4.7 39.3s27.2 14.3 39.3 4.7c64.6-50.9 120.6-119.2 158.4-191.9 4.3-8.3 6.3-17.3 6.3-26.2 0-8.9-2-17.9-6.3-26.1-37.7-72.6-91.1-130-124.7-162.1-11.2-10.7-28.9-10.3-39.6 .9zM56 280c33.7 64.9 82.3 117.8 113.8 147.8 11.2 10.7 11.6 28.4 .9 39.6s-28.4 11.6-39.6 .9c-33.7-32.1-87-89.5-124.8-162.2-4.3-8.3-6.3-17.3-6.3-26.1 0-8.9 2-17.9 6.3-26.2 37.7-72.6 93.8-141 158.4-191.9 12.2-9.6 29.8-7.4 39.3 4.7s7.4 29.7-4.7 39.3C141.2 152.6 90.3 214 56 280z"],
    "sparkles": [560, 560, [10024], "f890", "M250.1 32.4C256.1 13.1 273.8 0 294 0s37.9 13.1 43.9 32.4L369.4 135c8.2 26.6 29 47.4 55.6 55.6l102.6 31.6c19.3 5.9 32.4 23.7 32.4 43.9s-13.1 37.9-32.4 43.9L425 341.4c-26.6 8.2-47.4 29-55.6 55.6L337.9 499.6C331.9 518.9 314.1 532 294 532s-37.9-13.1-43.9-32.4L218.6 397c-8.2-26.6-29-47.4-55.6-55.6L60.4 309.9C41.1 303.9 28 286.2 28 266s13.1-37.9 32.4-43.9L163 190.6c26.6-8.2 47.4-29 55.6-55.6L250.1 32.4zM84 392c-23.1 0-44.7 7.5-60.6 23.4S0 452.9 0 476 7.5 520.7 23.4 536.6 60.9 560 84 560 128.7 552.5 144.6 536.6 168 499.1 168 476 160.5 431.3 144.6 415.4 107.1 392 84 392zM462 84a42 42 0 1 0 0-84 42 42 0 1 0 0 84zM56 112a28 28 0 1 1 56 0 28 28 0 1 1 -56 0zM476 448a28 28 0 1 0 0-56 28 28 0 1 0 0 56z"],
    "address-card": [560, 560, [62140, "contact-card", "vcard"], "f2bb", "M0 308c0 35.6 1.7 65.9 7.2 91.2 5.5 25.6 15.2 47.8 32.5 65.1s39.5 27 65.1 32.5c25.3 5.5 55.7 7.2 91.2 7.2l168 0c35.6 0 65.9-1.7 91.2-7.2 25.6-5.5 47.8-15.2 65.1-32.5s27-39.5 32.5-65.1c5.5-25.3 7.2-55.7 7.2-91.2l0-56c0-35.6-1.7-65.9-7.2-91.2-5.5-25.6-15.2-47.8-32.5-65.1s-39.5-27-65.1-32.5C429.9 57.7 399.6 56 364 56L196 56c-35.6 0-65.9 1.7-91.2 7.2-25.6 5.5-47.8 15.2-65.1 32.5s-27 39.5-32.5 65.1C1.7 186.1 0 216.4 0 252l0 56zm126-98a42 42 0 1 1 84 0 42 42 0 1 1 -84 0zm42 70c46.4 0 84 38.7 84 84 0 15.5-12.5 28-28 28l-112 0c-15.5 0-28-12.5-28-28 0-45.3 37.6-84 84-84zm168-84l112 0c15.5 0 28 12.5 28 28s-12.5 28-28 28l-112 0c-15.5 0-28-12.5-28-28s12.5-28 28-28zm0 112l112 0c15.5 0 28 12.5 28 28s-12.5 28-28 28l-112 0c-15.5 0-28-12.5-28-28s12.5-28 28-28z"],
    "angle-right": [336, 560, [8250], "f105", "M89 0c12.5 0 24.8 4.5 34.4 13.1 15.2 13.6 53.1 48.3 93.9 92 40.4 43.3 85 97.1 112.3 148.7 4.4 8.4 6.4 17.5 6.4 26.3s-2 17.9-6.4 26.3c-27.2 51.6-71.9 105.4-112.3 148.7-40.7 43.7-78.7 78.4-93.9 92-9.6 8.6-21.9 13.1-34.4 13.1-35.4 0-59.6-33.7-51.7-66.4 10-41.7 25.7-121.5 25.7-213.6S47.3 108 37.3 66.4C29.4 33.7 53.6 0 89 0z"],
    "face-meh": [560, 560, [128528, "meh"], "f11a", "M280 0C197 0 126.4 26.5 76.5 76.5S0 197 0 280 26.5 433.6 76.5 483.5 197 560 280 560 433.6 533.5 483.5 483.5 560 363 560 280 533.5 126.4 483.5 76.5 363 0 280 0zM140 196c0-15.5 12.5-28 28-28l28 0c15.5 0 28 12.5 28 28s-12.5 28-28 28l0 28c0 15.5-12.5 28-28 28s-28-12.5-28-28l0-56zm140 0c0-15.5 12.5-28 28-28l28 0c15.5 0 28 12.5 28 28s-12.5 28-28 28l0 28c0 15.5-12.5 28-28 28s-28-12.5-28-28l0-56zM224 336l140 0c15.5 0 28 12.5 28 28s-12.5 28-28 28l-140 0c-15.5 0-28-12.5-28-28s12.5-28 28-28z"],
    "map": [560, 560, [128506, 62072], "f279", "M108.1 37c22.1-4.5 46.3-9 59.9-9 6.8 0 15 1.5 22.1 3 7.8 1.7 17.1 4 27.1 6.7 45.5 12.2 90.4 26.7 136 38.4 6.4 1.6 10.9 7.3 10.9 13.9l0 218c0 15.5 12.5 28 28 28s28-12.5 28-28l0-212.6c0-8.5 6.1-15.7 14.5-17.4 18.6-3.6 38.9-8.3 55.6-12.3 35.1-8.5 69.9 17.8 69.9 54.7l0 333.7c0 25.6-17.4 48.2-42.7 54.3-17.1 4.1-42 9.9-65.4 14.6-22.1 4.5-46.3 9-59.9 9-6.8 0-15-1.5-22.1-3-7.8-1.7-17.1-4-27.1-6.7-45.5-12.2-90.4-26.7-136-38.4-6.4-1.6-10.9-7.3-10.9-13.9l0-218c0-15.5-12.5-28-28-28s-28 12.5-28 28l0 212.6c0 8.5-6.1 15.7-14.5 17.4-18.6 3.6-38.9 8.3-55.6 12.3-35.1 8.5-69.9-17.8-69.9-54.7L0 105.9c0-25.6 17.4-48.2 42.7-54.3 17.1-4.1 42-9.9 65.4-14.6z"],
    "terminal": [560, 560, [], "f120", "M224 448c-15.5 0-28 12.5-28 28s12.5 28 28 28l308 0c15.5 0 28-12.5 28-28s-12.5-28-28-28l-308 0zM10.7 106C-1.5 96.5-3.6 78.9 6 66.7S33.1 52.4 45.3 62c64.6 51 120.6 119.2 158.4 191.9 4.3 8.3 6.3 17.3 6.3 26.2s-2 17.9-6.3 26.2C165.9 378.8 109.9 447 45.3 498 33.1 507.6 15.5 505.5 6 493.3s-7.4-29.8 4.7-39.3C69.1 407.6 119.8 345.9 154 280 119.8 214.1 69.1 152.4 10.7 106z"],
    "thumbtack": [560, 560, [128204, 128392, "thumb-tack"], "f08d", "M384.3 8.2c-10.9-10.9-28.7-10.9-39.6 0s-10.9 28.7 0 39.6l5.2 5.2-75.5 56.6-90.1-22.5c-11.3-2.8-22.6-3.1-34.1-3.1-51.7 0-93.7 41.9-93.7 93.7 0 17.1 4.7 34.4 14.8 49.4 17.9 26.3 58 81.4 119.4 142.7S307.1 471.3 333.4 489.2c15 10.2 32.4 14.8 49.4 14.8 51.7 0 93.7-41.9 93.7-93.7 0-11.5-.3-22.8-3.1-34.1l-22.5-90.1 56.6-75.5 5.2 5.2c10.9 10.9 28.7 10.9 39.6 0s10.9-28.7 0-39.6l-168-168zm-224 431.6c10.9-10.9 10.9-28.7 0-39.6s-28.7-10.9-39.6 0l-84 84c-10.9 10.9-10.9 28.7 0 39.6s28.7 10.9 39.6 0l84-84z"],
    "circle-plus": [560, 560, ["plus-circle"], "f055", "M280 0C197 0 126.4 26.5 76.5 76.5S0 197 0 280 26.5 433.6 76.5 483.5 197 560 280 560 433.6 533.5 483.5 483.5 560 363 560 280 533.5 126.4 483.5 76.5 363 0 280 0zm28 168l0 84 84 0c15.5 0 28 12.5 28 28s-12.5 28-28 28l-84 0 0 84c0 15.5-12.5 28-28 28s-28-12.5-28-28l0-84-84 0c-15.5 0-28-12.5-28-28s12.5-28 28-28l84 0 0-84c0-15.5 12.5-28 28-28s28 12.5 28 28z"],
    "folder": [560, 560, [128193, 128447, 61716, "folder-blank"], "f07b", "M.2 308c0 35.6 1.7 65.9 7.2 91.2 5.5 25.6 15.2 47.8 32.5 65.1s39.5 27 65.1 32.5c25.3 5.5 55.7 7.2 91.2 7.2l168 0c35.6 0 65.9-1.7 91.2-7.2 25.6-5.5 47.8-15.2 65.1-32.5s27-39.5 32.5-65.1c9.8-45.4 9.8-137 0-182.4-5.5-25.6-15.2-47.8-32.5-65.1s-39.5-27-65.1-32.5c-25.3-5.5-55.7-7.2-91.2-7.2L343 112c-14.9 0-29.1-5.9-39.6-16.4L263.8 56c-17.9-17.9-42.2-28-67.6-28-35.6 0-65.9 1.7-91.2 7.2-25.6 5.5-47.8 15.2-65.1 32.5s-27 39.5-32.5 65.1C1.9 158.1 .2 188.4 .2 224l0 84z"],
    "arrow-up-from-bracket": [504, 560, [], "e09a", "M433.2 162c0-12.4-4.3-24.8-13-34.6-18.5-20.9-79.7-86.9-146.9-122-7.1-3.7-14.7-5.4-22.1-5.4s-15 1.7-22.1 5.4c-67.3 35.2-128.5 101.2-147 122-8.7 9.8-13 22.2-13 34.5 0 24.3 16.8 46.7 42.5 51.1 22.1 3.8 60.8 9.1 112.3 10.6L224 364c0 15.5 12.5 28 28 28s28-12.5 28-28l0-140.4c51-1.5 89-6.7 110.8-10.5 25.6-4.5 42.4-26.9 42.4-51.1zM476 308c-15.5 0-28 12.5-28 28 0 34.4-1.8 60.1-5.9 79.4-4.1 19-10.1 30.1-17.4 37.3s-18.3 13.3-37.3 17.4c-19.3 4.2-45 5.9-79.4 5.9l-112 0c-34.4 0-60.1-1.8-79.4-5.9-19-4.1-30.1-10.1-37.3-17.4S66 434.4 61.9 415.4c-4.2-19.3-5.9-45-5.9-79.4 0-15.5-12.5-28-28-28S0 320.5 0 336c0 35.6 1.7 65.9 7.2 91.2 5.5 25.6 15.2 47.8 32.5 65.1s39.5 27 65.1 32.5c25.3 5.5 55.7 7.2 91.2 7.2l112 0c35.6 0 65.9-1.7 91.2-7.2 25.6-5.5 47.8-15.2 65.1-32.5s27-39.5 32.5-65.1c5.5-25.3 7.2-55.7 7.2-91.2 0-15.5-12.5-28-28-28z"],
    "cloud": [616, 560, [9729], "f0c2", "M171.8 168.3c-2.5 13.3-3.8 27.3-3.8 41.7 0 31.7 6.1 60.9 17.9 86.2 6.5 14 .5 30.7-13.5 37.2s-30.7 .5-37.2-13.5c-15.7-33.6-23.1-71-23.1-109.8 0-16.6-15.7-29.8-30.4-22-13.1 6.9-25 15.7-35.5 26.1-30.5 30.5-46.1 73.1-46.1 121.9 0 42.4 12.4 76.4 35.1 102.2 22.2 25.3 52.2 40.4 83.3 49.6 55.8 16.6 123.3 16.4 175.5 16.2 9.7 0 18.6 0 28.3 0 52.3 .2 119.8 .4 175.5-16.2 31.1-9.2 61-24.3 83.2-49.6 22.7-25.8 35.1-59.8 35.1-102.2 0-65.9-28.7-119.8-81.3-147.8-2.8-1.5-4.1-3.9-4.3-5.5-5.4-46.1-25-85.4-57.3-113-32.2-27.5-74.8-41.6-123.1-41.6-53.1 0-99.2 17-132.1 49.9-23.9 23.9-39.4 54.8-46.1 90.3z"],
    "circle": [560, 560, [128308, 128309, 128992, 128993, 128994, 128995, 128996, 9679, 9898, 9899, 11044, 61708, 61915], "f111", "M280 0C197 0 126.4 26.5 76.5 76.5S0 197 0 280 26.5 433.6 76.5 483.5 197 560 280 560 433.6 533.5 483.5 483.5 560 363 560 280 533.5 126.4 483.5 76.5 363 0 280 0z"],
    "backward": [560, 560, [9194], "f04a", "M545.8 106.8c-6.6-32.1-35-50.8-64.2-50.8-13.5 0-27.2 3.8-39.1 12.3-17.4 12.4-53 39.4-89.7 77.3-5.7 5.9-8.5 14-7.8 22.1 2.9 30.5 4.9 67.7 4.9 112.3s-2 81.8-4.9 112.3c-.8 8.2 2 16.3 7.8 22.1 36.7 37.9 72.3 64.9 89.7 77.3 11.8 8.4 25.6 12.3 39.1 12.3 29.2 0 57.6-18.8 64.2-50.8 6.5-31.6 14.2-87.3 14.2-173.2s-7.7-141.6-14.2-173.2zM215.5 56c-13.5 0-27.2 3.8-39.1 12.3-30.1 21.5-120 90.4-170 185.4-4.4 8.4-6.4 17.4-6.4 26.3s2 17.9 6.4 26.3c50 95 139.9 164 170 185.4 11.8 8.4 25.6 12.3 39.1 12.3 29.2 0 57.6-18.8 64.2-50.8 6.5-31.6 14.2-87.3 14.2-173.2s-7.7-141.6-14.2-173.2c-6.6-32.1-35-50.8-64.2-50.8z"],
    "link": [672, 560, [128279, "chain"], "f0c1", "M525.2 28c-27.9 0-54.9 7.9-78.1 22.5-13.1 8.2-17 25.5-8.8 38.6s25.5 17 38.6 8.8c14.4-9 31.1-13.9 48.3-13.9 50.1 0 90.8 40.6 90.8 90.8 0 24.1-9.6 47.2-26.6 64.2L435 393.4c-17 17-40.1 26.6-64.2 26.6-50.1 0-90.8-40.7-90.8-90.8 0-24.1 9.6-47.2 26.6-64.2l21.2-21.2c10.9-10.9 10.9-28.7 0-39.6s-28.7-10.9-39.6 0L267 225.4c-27.5 27.5-43 64.9-43 103.8 0 81.1 65.7 146.8 146.8 146.8 38.9 0 76.3-15.5 103.8-43L629 278.6c27.5-27.5 43-64.9 43-103.8 0-81.1-65.7-146.8-146.8-146.8zm-224 56c-38.9 0-76.3 15.5-103.8 43L43 281.4c-27.5 27.5-43 64.9-43 103.8 0 81.1 65.7 146.8 146.8 146.8 27.9 0 54.9-7.9 78.1-22.5 13.1-8.2 17-25.5 8.8-38.6s-25.5-17-38.6-8.8c-14.4 9-31.1 13.9-48.3 13.9-50.1 0-90.8-40.7-90.8-90.8 0-24.1 9.6-47.2 26.6-64.2L237 166.6c17-17 40.1-26.6 64.2-26.6 50.1 0 90.8 40.6 90.8 90.8 0 24.1-9.6 47.2-26.6 64.2l-21.2 21.2c-10.9 10.9-10.9 28.7 0 39.6s28.7 10.9 39.6 0L405 334.6c27.5-27.5 43-64.9 43-103.8 0-81.1-65.7-146.8-146.8-146.8z"],
    "backward-step": [560, 560, ["step-backward"], "f048", "M444.3 66.5c11.4-7.2 24.2-10.5 36.7-10.5 29.7 0 58.6 19.1 65.2 51.7 6.4 31.7 14 87.2 14 172.3s-7.6 140.6-14 172.3c-6.6 32.6-35.5 51.7-65.2 51.7-12.5 0-25.3-3.2-36.7-10.5-31.6-20.1-133.9-89.9-185.6-187.2-4.5-8.4-6.5-17.5-6.5-26.4s2-17.9 6.5-26.4c51.7-97.3 154-167.1 185.6-187.2zM105.2 56c17.7 0 36.5 .8 52.7 7.4 18.7 7.7 31 21.7 38.6 41 6.9 17.6 10 40.1 11.7 67.4 4.4 71.5 4.4 144.9 0 216.4-1.7 27.3-4.8 49.8-11.7 67.4-7.5 19.3-19.9 33.3-38.6 41-16.2 6.6-35 7.4-52.7 7.4s-36.5-.8-52.7-7.4c-18.7-7.7-31-21.7-38.6-41-6.9-17.6-10-40.1-11.7-67.4-4.4-71.5-4.4-144.9 0-216.4 1.7-27.3 4.8-49.8 11.7-67.4 7.5-19.3 19.9-33.3 38.6-41 16.2-6.6 35-7.4 52.7-7.4z"],
    "circle-user": [560, 560, [62142, "user-circle"], "f2bd", "M280 0C197 0 126.4 26.5 76.5 76.5S0 197 0 280 26.5 433.6 76.5 483.5 197 560 280 560 433.6 533.5 483.5 483.5 560 363 560 280 533.5 126.4 483.5 76.5 363 0 280 0zM430.8 455.9C393.9 486.3 343.1 504 280 504s-113.9-17.7-150.8-48.1c-9.3-7.9-11.1-21.8-2.6-30.6 32.1-32.9 86.8-33.3 129.4-33.3l48 0c42.6 0 97.2 .4 129.4 33.3 8.6 8.8 6.7 22.7-2.6 30.6zm-221.9-303C226.5 135.2 251.3 126 280 126s53.5 9.2 71.2 26.9 26.8 42.5 26.8 71.1-9.2 53.5-26.8 71.2-42.5 26.8-71.2 26.8-53.5-9.2-71.1-26.8-26.9-42.5-26.9-71.2 9.2-53.5 26.9-71.1z"],
    "hand": [560, 560, [129306, 9995, "hand-paper"], "f256", "M308.4 28c0-15.5-12.5-28-28-28s-28 12.5-28 28l0 196.1c-.1 15.4-12.6 27.9-28 27.9-15.5 0-28-12.5-28-28l0-140c0-15.5-12.5-28-28-28s-28 12.5-28 28l0 260.7c0 18-23.3 25.8-34.3 12L71.6 313.7c-14.3-17.9-41.1-19.4-57.3-3.2-12.3 12.3-14.8 31.3-6.2 46.4 14.5 25.4 29 50.8 43.5 76.2 44.9 78.5 128.4 127 218.8 127l10 0c74.5 0 138.1-23.8 183.1-68.9S532.4 382.5 532.4 308l0-168c0-15.5-12.5-28-28-28s-28 12.5-28 28l0 84.1c-.1 15.4-12.6 27.9-28 27.9-15.5 0-28-12.5-28-28l0-140c0-15.5-12.5-28-28-28s-28 12.5-28 28l0 140.1c-.1 15.4-12.6 27.9-28 27.9-15.5 0-28-12.5-28-28l0-196z"],
    "thumbs-up": [560, 560, [128077, 61575], "f164", "M88 168c-23.9 0-51.3 1.7-69.4 21.3-9.1 9.9-13.5 21.8-15.8 33.4-2.3 11.4-2.9 24.5-2.9 38.6L0 438.7c0 14.1 .6 27.2 2.9 38.6 2.3 11.6 6.7 23.5 15.8 33.4 18 19.6 45.5 21.3 69.4 21.3l6 0c23.9 0 51.3-1.7 69.4-21.3 9.1-9.9 13.5-21.8 15.7-33.4 2.3-11.4 2.9-24.5 2.9-38.6l0-177.3c0-14.1-.6-27.2-2.9-38.6-2.3-11.6-6.7-23.5-15.7-33.4-18-19.6-45.5-21.3-69.4-21.3l-6 0zM257.2 488.6c-11.4-3.8-19.2-14.5-19.2-26.6 0-118.8-1.7-184.8-3.5-220.9-.6-13-.9-26.4-2.9-39.3-1.8-8.4 .4-17.1 5.9-23.7 38.9-46.7 51.3-93 55.1-121.2 3.9-28.5 27.9-56.9 62.2-56.9 37 0 64.6 34.1 56.8 70.3L388.3 179.1C386.4 187.8 393 196 402 196l82.2 0c16.3 0 43.7 4.6 56.9 30.7 10.3 20.2 18.9 53.5 18.9 109.3 0 70.9-26.4 117-46.3 141.4-15.7 19.2-38.2 27.2-58.4 28.7-59.1 4.4-108 .3-142.5-5.1-18.7-2.9-37.6-6.4-55.6-12.4z"],
    "building": [448, 560, [127970, 61687], "f1ad", "M196 0c-35.6 0-65.9 1.7-91.2 7.2-25.6 5.5-47.8 15.2-65.1 32.5s-27 39.5-32.5 65.1C1.7 130.1 0 160.4 0 196L0 364c0 35.6 1.7 65.9 7.2 91.2 5.5 25.6 15.2 47.8 32.5 65.1s39.5 27 65.1 32.5c25.3 5.5 55.7 7.2 91.2 7.2l56 0c35.6 0 65.9-1.7 91.2-7.2 25.6-5.5 47.8-15.2 65.1-32.5s27-39.5 32.5-65.1c5.5-25.3 7.2-55.7 7.2-91.2l0-168c0-35.6-1.7-65.9-7.2-91.2-5.5-25.6-15.2-47.8-32.5-65.1s-39.5-27-65.1-32.5C317.9 1.7 287.6 0 252 0L196 0zM168 84c15.5 0 28 12.5 28 28l0 28c0 15.5-12.5 28-28 28s-28-12.5-28-28l0-28c0-15.5 12.5-28 28-28zm112 0c15.5 0 28 12.5 28 28l0 28c0 15.5-12.5 28-28 28s-28-12.5-28-28l0-28c0-15.5 12.5-28 28-28zM168 224c15.5 0 28 12.5 28 28l0 28c0 15.5-12.5 28-28 28s-28-12.5-28-28l0-28c0-15.5 12.5-28 28-28zm112 0c15.5 0 28 12.5 28 28l0 28c0 15.5-12.5 28-28 28s-28-12.5-28-28l0-28c0-15.5 12.5-28 28-28zM168 476l0-56c0-30.9 25.1-56 56-56s56 25.1 56 56l0 56c0 15.5-12.5 28-28 28l-56 0c-15.5 0-28-12.5-28-28z"],
    "gear": [560, 560, [9881, "cog"], "f013", "M280.2 0c-8.4 0-16.7 .3-24.9 .8-25.2 1.7-44.3 20.3-49.3 43-1.7 7.4-3.4 38-10.9 40.8-15.9 6-30.6 13.7-44 23.2-7 4.9-30.8-7.7-38.4-10.1-22.1-7-47.8 .3-61.9 21.2-9 13.5-17.7 28.5-24.9 43.1-11.1 22.6-4.6 48.5 12.5 64.2 5.8 5.3 33.2 23.8 32.6 31.5-1.2 14.6-1.2 30.1 0 44.7 .6 7.7-26.8 26.2-32.6 31.5-17.1 15.7-23.7 41.5-12.5 64.2 7.2 14.6 15.8 29.6 24.9 43.1 14 21 39.7 28.2 61.9 21.2 7.6-2.4 31.4-15 38.4-10.1 13.4 9.5 28.1 17.2 44 23.2 7.5 2.8 9.3 33.3 10.9 40.8 5 22.7 24.1 41.3 49.3 43 16.2 1.1 33.6 1.1 49.8 0 25.2-1.7 44.3-20.3 49.3-43 1.7-7.4 3.4-38 10.9-40.8 15.9-6 30.6-13.7 44-23.2 7-4.9 30.8 7.7 38.4 10.1 22.1 7 47.8-.3 61.9-21.2 9-13.5 17.7-28.5 24.9-43.1 11.1-22.6 4.6-48.5-12.5-64.2-5.8-5.3-33.2-23.8-32.6-31.5 1.2-14.6 1.2-30.1 0-44.7-.6-7.7 26.8-26.2 32.6-31.5 17.1-15.7 23.7-41.5 12.5-64.2-7.2-14.6-15.8-29.6-24.9-43.1-14-21-39.7-28.2-61.9-21.2-7.6 2.4-31.4 15-38.4 10.1-13.4-9.5-28.1-17.2-44-23.2-7.5-2.8-9.3-33.3-10.9-40.8-5-22.7-24.1-41.3-49.3-43-8.2-.5-16.5-.8-24.9-.8zM240 239.8c11-11 25.6-15.8 40.2-15.8s29.2 4.8 40.2 15.8 15.8 25.6 15.8 40.2-4.8 29.2-15.8 40.2-25.6 15.8-40.2 15.8-29.2-4.8-40.2-15.8-15.8-25.6-15.8-40.2 4.8-29.2 15.8-40.2z"],
    "circle-question": [560, 560, [62108, "question-circle"], "f059", "M280 0C197 0 126.4 26.5 76.5 76.5S0 197 0 280 26.5 433.6 76.5 483.5 197 560 280 560 433.6 533.5 483.5 483.5 560 363 560 280 533.5 126.4 483.5 76.5 363 0 280 0zM238.5 182.5c-8.4 8.4-14.5 21.8-14.5 41.5 0 15.5-12.5 28-28 28s-28-12.5-28-28c0-31.7 10.2-60.3 31-81s49.4-31 81-31 60.3 10.2 81 31 31 49.3 31 81-10.2 60.3-31 81-49.4 31-81 31c-15.5 0-28-12.5-28-28s12.5-28 28-28c19.6 0 33-6.1 41.5-14.5s14.5-21.8 14.5-41.5-6.1-33-14.5-41.5-21.8-14.5-41.5-14.5-33 6.1-41.5 14.5zM280 364a42 42 0 1 1 0 84 42 42 0 1 1 0-84z"],
    "file": [448, 560, [128196, 128459, 61462], "f15b", "M168 .4c15.5-.5 28 12.1 28 27.6l0 154c0 38.7 31.3 70 70 70l154 0c15.5 0 28 12.5 28 28l0 84c0 35.6-1.7 65.9-7.2 91.2-5.5 25.6-15.2 47.8-32.5 65.1s-39.5 27-65.1 32.5c-25.3 5.5-55.7 7.2-91.2 7.2l-56 0c-35.6 0-65.9-1.7-91.2-7.2-25.6-5.5-47.8-15.2-65.1-32.5s-27-39.5-32.5-65.1C1.7 429.9 0 399.6 0 364L0 196c0-35.6 1.7-65.9 7.2-91.2 5.5-25.6 15.2-47.8 32.5-65.1s39.5-27 65.1-32.5c18.4-4 39.4-6 63.2-6.8zm114.2 9C267.1 2.2 252 15.6 252 32.4L252 182c0 7.7 6.3 14 14 14l149.6 0c16.8 0 30.2-15.1 22.9-30.2-15.8-32.8-43.3-62.2-68.7-87.6S315 25.3 282.2 9.5z"],
    "volume-slash": [616, 560, [128263], "f2e2", "M36.2 8.2C47.1-2.7 64.9-2.7 75.8 8.2L161 93.4 184.8 61.6C200.7 40.4 225.6 28 252 28l16.3 0c35.4 0 69 22.9 77.2 60.4 8.4 38.8 18.6 103.7 18.6 191.6 0 5.5 0 10.9-.1 16.3l69.2 69.2c9.6-24.5 14.9-53.1 14.9-85.5 0-50.1-12.8-91.2-34.5-122.2-8.9-12.7-5.8-30.1 6.8-39s30.1-5.8 39 6.8c29.4 41.9 44.7 94.7 44.7 154.4 0 47.7-9.7 90.9-28.7 127.7L518.6 451c26.5-46.2 41.4-103.7 41.4-171 0-85.6-24.1-155.3-65.7-206.3-9.8-12-8-29.6 4-39.4s29.6-8 39.4 4c51.2 62.6 78.3 145.5 78.3 241.7 0 81.6-19.5 153.5-56.7 211.7l20.5 20.5c10.9 10.9 10.9 28.7 0 39.6s-28.7 10.9-39.6 0l-504-504c-10.9-10.9-10.9-28.7 0-39.6zM72.6 163.4c-9.8-9.8-25.3-11-36.5-2.7-16.2 12-25.3 28.7-30.2 47.7-4.7 18.2-6 39.9-6 64.6l0 14c0 22.4 1.1 42.3 4.7 59.2 3.7 17.2 10.5 33.2 23.2 45.9s28.7 19.4 45.9 23.2c15.1 3.3 32.6 4.5 52.2 4.7l58.8 78.4C200.7 519.6 225.6 532 252 532l16.3 0c35.4 0 69-22.9 77.2-60.4 1-4.6 2-9.6 3-14.9 1.8-9.1-1.1-18.5-7.7-25.1L72.6 163.4z"],
    "arrow-up": [504, 560, [8593], "f062", "M488.3 181.5c10.5 11.8 15.7 26.8 15.7 41.8 0 29.6-20.4 56.5-51.3 61.9-22.4 3.9-56.8 8.9-101.4 12.2-9.3 .7-15.3 8.7-14.3 16.6l20.9 167.3c5.2 41.8-27.4 78.7-69.5 78.7l-72.8 0c-42.1 0-74.7-36.9-69.5-78.7L167 314c1-7.9-5.1-15.9-14.3-16.6-44.6-3.3-79-8.3-101.4-12.2-30.9-5.4-51.3-32.4-51.3-61.9 0-15 5.2-30 15.7-41.8 26.8-30.3 114.5-125 210.1-175.1 8.3-4.4 17.4-6.4 26.2-6.4s17.9 2 26.2 6.4c95.6 50.1 183.3 144.8 210.1 175.1z"],
    "rectangle": [560, 560, [9644, "rectangle-landscape"], "f2fa", "M0 308c0 35.6 1.7 65.9 7.2 91.2 5.5 25.6 15.2 47.8 32.5 65.1s39.5 27 65.1 32.5c25.3 5.5 55.7 7.2 91.2 7.2l168 0c35.6 0 65.9-1.7 91.2-7.2 25.6-5.5 47.8-15.2 65.1-32.5s27-39.5 32.5-65.1c5.5-25.3 7.2-55.7 7.2-91.2l0-56c0-35.6-1.7-65.9-7.2-91.2-5.5-25.6-15.2-47.8-32.5-65.1s-39.5-27-65.1-32.5C429.9 57.7 399.6 56 364 56L196 56c-35.6 0-65.9 1.7-91.2 7.2-25.6 5.5-47.8 15.2-65.1 32.5s-27 39.5-32.5 65.1C1.7 186.1 0 216.4 0 252l0 56z"],
    "grid": [504, 560, ["grid-3"], "e195", "M0 154c0 27.8 4.3 55.2 23.5 74.5S70.2 252 98 252l28 0c27.8 0 55.2-4.3 74.5-23.5S224 181.8 224 154l0-28c0-27.8-4.3-55.2-23.5-74.5S153.8 28 126 28L98 28c-27.8 0-55.2 4.3-74.5 23.5S0 98.2 0 126l0 28zM0 434c0 27.8 4.3 55.2 23.5 74.5S70.2 532 98 532l28 0c27.8 0 55.2-4.3 74.5-23.5S224 461.8 224 434l0-28c0-27.8-4.3-55.2-23.5-74.5S153.8 308 126 308l-28 0c-27.8 0-55.2 4.3-74.5 23.5S0 378.2 0 406l0 28zm303.5 74.5C284.3 489.2 280 461.8 280 434l0-28c0-27.8 4.3-55.2 23.5-74.5S350.2 308 378 308l28 0c27.8 0 55.2 4.3 74.5 23.5S504 378.2 504 406l0 28c0 27.8-4.3 55.2-23.5 74.5S433.8 532 406 532l-28 0c-27.8 0-55.2-4.3-74.5-23.5zM280 154c0 27.8 4.3 55.2 23.5 74.5S350.2 252 378 252l28 0c27.8 0 55.2-4.3 74.5-23.5S504 181.8 504 154l0-28c0-27.8-4.3-55.2-23.5-74.5S433.8 28 406 28l-28 0c-27.8 0-55.2 4.3-74.5 23.5S280 98.2 280 126l0 28z"],
    "shirt": [560, 560, [128085, "t-shirt", "tshirt"], "f553", "M56 28C25.1 28 0 53.1 0 84l0 63.8c0 24.1 15.4 45.5 38.3 53.1L84 216.2 84 360c0 30.6 1.5 56.9 6.3 79 4.8 22.4 13.4 42.2 28.9 57.8s35.4 24.1 57.8 28.9c22.1 4.8 48.5 6.3 79 6.3l48 0c30.6 0 56.9-1.5 79-6.3 22.4-4.8 42.2-13.4 57.8-28.9s24.1-35.4 28.9-57.8c4.8-22.1 6.3-48.5 6.3-79l0-143.8 45.7-15.2c22.9-7.6 38.3-29 38.3-53.1L560 84c0-30.9-25.1-56-56-56L377.3 28c-14.3 0-26.3 10.8-27.8 25-2.1 19.8-9.9 34-20.6 43.2-10.8 9.4-26.8 15.7-48.9 15.7s-38.1-6.4-48.9-15.7C220.4 87 212.7 72.8 210.6 53 209 38.8 197 28 182.7 28L56 28z"],
    "suitcase": [560, 560, [129523], "f0f2", "M148.2 81.3c-1.5 15.4 9.8 29.1 25.2 30.5s29.1-9.8 30.5-25.2c1.9-20.1 6.3-23.2 8.2-24.4 5-3.2 16.6-6.3 46.9-6.3l42 0c30.3 0 41.9 3.1 46.9 6.3 1.9 1.2 6.2 4.3 8.2 24.4 1.5 15.4 15.1 26.7 30.5 25.2s26.7-15.1 25.2-30.5C409.3 55.5 401.9 30.6 378.3 15.3 357.8 2 330.2 0 301 0L259 0c-29.2 0-56.8 2-77.3 15.3-23.6 15.3-31 40.3-33.5 66zM332.2 140c14.9 0 27.1 11.6 27.9 26.4 1.9 39.3 4 96.3 4 155.6s-2.1 116.2-4 155.6c-.7 14.8-13 26.4-27.9 26.4l-104.5 0c-14.8 0-27.1-11.6-27.8-26.4-1.9-38.1-3.9-93.7-3.9-155.6s2-117.5 3.9-155.6c.7-14.8 13-26.4 27.8-26.4l104.5 0zm84.3 330.1c-.8 17 13.5 31 30.2 28 30-5.5 54.6-15.7 73.1-33.3 34-32.4 40.2-82.7 40.2-142.8s-6.2-110.4-40.2-142.8c-18.6-17.7-43.1-27.8-73.1-33.3-16.7-3.1-31 11-30.2 28 2.2 49.3 3.6 98.7 3.6 148.1s-1.3 98.8-3.6 148.1zM115.3 146.3c-31.3 6.1-56.5 17.2-75.5 35.9-33.5 33.1-39.8 82.7-39.8 139.8 0 60.1 6.2 110.4 40.2 142.8 18.9 18 44 28.2 74.8 33.6 15.8 2.8 29.3-10.5 28.6-26.5-1.8-38.3-3.5-91.2-3.5-149.9s1.8-111.6 3.5-149.9c.7-15.8-12.7-28.8-28.2-25.8z"],
    "play": [560, 560, [9654], "f04b", "M560 280c0-24.6-8.7-49.6-27.6-68.2-28-27.6-84.1-77.2-168.4-125.8S208.7 13.5 170.9 3.1C145.3-4 119.3 1 98 13.3s-38.6 32.3-45.2 58c-9.9 38-24.8 111.4-24.8 208.7 0 91.7 10.8 160.6 18.7 198.9 6.1 29.3 25.1 52.7 49.4 66.7 22.6 13 50.1 18.3 77.2 10.7 38.4-10.8 108.2-34.6 190.8-82.3 84.3-48.6 140.4-98.2 168.4-125.8 18.9-18.6 27.6-43.6 27.6-68.2z"],
    "paperclip": [448, 560, [128206], "f0c6", "M196 112c0-28.2 8.8-48.6 22.1-61.9S251.8 28 280 28 328.6 36.8 341.9 50.1 364 83.8 364 112l0 280c0 45.3-14.3 79.7-37.3 102.7S269.3 532 224 532 144.3 517.7 121.3 494.7 84 437.3 84 392c0-73.4 3.2-168-31-236.5-6.9-13.8-23.7-19.4-37.6-12.5-13.7 6.9-19.4 23.5-12.7 37.3 28.4 62.5 25.2 145.7 25.2 211.8 0 57.4 18.4 107 53.7 142.3S166.6 588 224 588 331 569.6 366.3 534.3 420 449.4 420 392l0-280c0-40.3-12.9-75.9-38.5-101.5S320.3-28 280-28 204.1-15.1 178.5 10.5 140 71.7 140 112l0 280c0 23.1 7.5 44.7 23.4 60.6s37.5 23.4 60.6 23.4 44.7-7.5 60.6-23.4 23.4-37.5 23.4-60.6l0-280c0-15.5-12.5-28-28-28s-28 12.5-28 28l0 280c0 11.1-3.4 17.5-7 21s-10 7-21 7-17.5-3.4-21-7-7-10-7-21l0-280z"],
    "signal-bars-weak": [616, 560, ["signal-alt-1"], "f691", "M0 364c0-30.9 25.1-56 56-56s56 25.1 56 56l0 84c0 30.9-25.1 56-56 56S0 478.9 0 448l0-84z"],
    "wrench": [560, 560, [128295], "f0ad", "M221.7 53.7c37.8-37.8 90.9-53.8 143.5-53.7 23.4 .1 41.1 14.7 47.5 34 6.1 18.5 1.3 39.7-13.7 54.7l-44.8 44.8c-2.6 2.6-4.1 6.2-4.1 9.9l0 52.6c0 7.7 6.3 14 14 14l52.6 0c3.7 0 7.3-1.5 9.9-4.1l44.8-44.8c15-15 36.2-19.8 54.7-13.7 19.3 6.3 33.9 24.1 34 47.5 .1 52.6-15.9 105.6-53.7 143.5-35.3 35.3-84.9 53.7-142.3 53.7-17.5 0-34.3-1.7-50.2-5.1-1.7-.4-3 .1-3.2 .2L201.3 518.9c-21.6 26-53.7 41.1-87.5 41.1-62.8 0-113.7-50.9-113.7-113.7 0-33.8 15.1-65.9 41.1-87.5L172.9 249.4c.1-.2 .6-1.5 .2-3.2-3.4-15.9-5.1-32.7-5.1-50.2 0-57.4 18.4-107 53.7-142.3zM112 476a28 28 0 1 0 0-56 28 28 0 1 0 0 56z"],
    "life-ring": [560, 560, [], "f1cd", "M119.7 80.1C107.8 68.2 108.9 48.6 123.3 39.9 167.1 13.7 220.3 0 280 0S392.9 13.7 436.7 39.9c14.4 8.6 15.5 28.3 3.6 40.1l-54.1 54.1c-10.9 10.9-10.9 28.7 0 39.6s28.7 10.9 39.6 0l54.1-54.1c11.8-11.8 31.5-10.7 40.1 3.6 26.2 43.8 39.9 97 39.9 156.7s-13.7 112.9-39.9 156.7c-8.6 14.4-28.3 15.5-40.1 3.6l-54.1-54.1c-10.9-10.9-28.7-10.9-39.6 0s-10.9 28.7 0 39.6l54.1 54.1c11.8 11.8 10.7 31.5-3.6 40.1-43.8 26.2-97 39.9-156.7 39.9s-112.9-13.7-156.7-39.9c-14.4-8.6-15.5-28.3-3.6-40.1l54.1-54.1c10.9-10.9 10.9-28.7 0-39.6s-28.7-10.9-39.6 0L80.1 440.3C68.2 452.2 48.6 451.1 39.9 436.7 13.7 392.9 0 339.7 0 280S13.7 167.1 39.9 123.3c8.6-14.4 28.3-15.5 40.1-3.6l54.1 54.1c10.9 10.9 28.7 10.9 39.6 0s10.9-28.7 0-39.6L119.7 80.1zm98.5 138.1C204.8 231.4 196 251.8 196 280s8.8 48.6 22.1 61.9 33.7 22.1 61.9 22.1 48.6-8.8 61.9-22.1 22.1-33.7 22.1-61.9-8.8-48.6-22.1-61.9-33.7-22.1-61.9-22.1-48.6 8.8-61.9 22.1z"],
    "calendar": [504, 560, [128197, 128198], "f133", "M196 28c0-15.5-12.5-28-28-28s-28 12.5-28 28l0 30.1c-12.7 1.1-24.4 2.8-35.2 5.1-25.6 5.5-47.8 15.2-65.1 32.5s-27 39.5-32.5 65.1c-1.7 7.8-3 16.1-4.1 25-1.8 15 9.7 28 24.7 29.2 51 4 133.7 9.1 224.2 9.1s173.1-5.1 224.2-9.1c15-1.2 26.4-14.2 24.7-29.2-1-8.8-2.4-17.1-4.1-25-5.5-25.6-15.2-47.8-32.5-65.1s-39.5-27-65.1-32.5c-10.8-2.3-22.5-4-35.2-5.1L364 28c0-15.5-12.5-28-28-28s-28 12.5-28 28l0 28-112 0 0-28zM0 336c0 35.6 1.7 65.9 7.2 91.2 5.5 25.6 15.2 47.8 32.5 65.1s39.5 27 65.1 32.5c25.3 5.5 55.7 7.2 91.2 7.2l112 0c35.6 0 65.9-1.7 91.2-7.2 25.6-5.5 47.8-15.2 65.1-32.5s27-39.5 32.5-65.1c5.5-25.3 7.2-55.7 7.2-91.2l0-36.7c0-16.4-14.1-29.3-30.5-28.1-52.4 4-133.1 8.7-221.5 8.7s-169.2-4.7-221.5-8.7C14.1 270 0 282.9 0 299.3L0 336z"],
    "italic": [448, 560, [], "f033", "M56.4 23.4c-2.5 15.3 7.8 29.7 23 32.2 46.6 7.7 94 12.1 141.2 13.8l-49.5 421c-49.4 1.4-98.9 6-147.7 14-15.3 2.5-25.6 17-23 32.2s17 25.6 32.2 23c53.8-8.9 108.9-13.6 163.4-13.6 54.5 0 109.4 4.8 163.2 13.6 15.3 2.5 29.9-7.7 32.4-23s-7.8-29.7-23-32.2c-46.7-7.7-93.9-12.1-141.2-13.8l49.5-421c49.4-1.4 98.9-6 147.7-14 15.3-2.5 25.6-17 23-32.2s-17-25.6-32.2-23C361.6 9.2 306.5 14 252 14S142.4 9.2 88.6 .4c-15.3-2.5-29.7 7.8-32.2 23z"],
    "check": [560, 560, [10003, 10004], "f00c", "M410.1 42.9C452.3 16.5 507.7 26 538.7 65s27.8 95.1-7.4 130.3c-57.5 57.5-113.4 129.5-155.8 188.9-21 29.4-38.2 54.9-50.1 73.1-6.1 9.3-12.1 18.6-18 28.1-15.7 25.5-42.3 42.5-72 46s-59.5-6.8-80.7-28l-126-126c-35.6-35.6-38.4-92.5-6.5-131.4s88.2-47.4 130.1-19.4l46.3 30.9c7.7-10.3 16.5-21.5 25.4-32.7 46-58.4 114.4-137 186-181.7z"],
    "wifi-slash": [616, 560, [], "f6ac", "M36.7 8.2C47.6-2.7 65.4-2.7 76.3 8.2l52.2 52.2c53.4-21.3 113.9-32.4 180-32.4 122.2 0 225.4 37.9 299.3 108.2 11.2 10.7 11.6 28.4 1 39.6s-28.4 11.6-39.6 1C507.5 118.1 419 84 308.5 84 258.4 84 212.8 91 172.2 104.1l46.3 46.3c28.1-6.9 58.2-10.4 90-10.4 89 0 164.8 27.6 219.3 79.5 11.2 10.7 11.6 28.4 1 39.6s-28.4 11.6-39.6 1c-42.3-40.3-103.4-64-180.7-64-14.6 0-28.5 .8-41.9 2.5l53.8 53.8c50.7 2.3 94.8 19.5 127.4 50.5 11.2 10.7 11.6 28.4 1 39.6-8.6 9-21.7 11.1-32.4 6L580.3 512.2c10.9 10.9 10.9 28.7 0 39.6s-28.7 10.9-39.6 0l-504-504c-10.9-10.9-10.9-28.7 0-39.6zM258.6 395.8c8.6-8.1 21.7-5.4 30 2.9l69.1 69.1c8.3 8.3 11 21.5 2.9 30-12.2 12.9-30.1 20.1-52.2 20.1-42.8 0-70-27.2-70-70 0-22.1 7.2-40 20.1-52.2z"],
    "chart-bar": [560, 560, ["bar-chart"], "f080", "M462 532c27.8 0 55.2-4.3 74.5-23.5S560 461.8 560 434l0-196c0-27.8-4.3-55.2-23.5-74.5S489.8 140 462 140l-14 0c-15.5 0-28 12.5-28 28l0 336c0 15.5 12.5 28 28 28l14 0zm-126 0c15.5 0 28-12.5 28-28l0-406c0-63.2-6.8-98-84-98s-84 34.8-84 98l0 406c0 15.5 12.5 28 28 28l112 0zm-224 0c15.5 0 28-12.5 28-28l0-224c0-15.5-12.5-28-28-28l-14 0c-27.8 0-55.2 4.3-74.5 23.5S0 322.2 0 350l0 84c0 27.8 4.3 55.2 23.5 74.5S70.2 532 98 532l14 0z"],
    "house": [560, 560, [127968, 63498, 63500, "home", "home-alt", "home-lg-alt"], "f015", "M273 58.6c4.3-3.5 9.7-3.5 13.9 0 29.6 24.3 116.3 92.8 230.6 161.4 13.3 8 30.5 3.7 38.4-9.6s3.7-30.5-9.6-38.4C435.2 105.3 350.9 38.5 322.5 15.3 310.6 5.6 295.7 0 280 0s-30.6 5.6-42.5 15.3C209.2 38.5 124.8 105.3 13.6 172 .3 179.9-4 197.1 4 210.4S29.2 228 42.4 220C156.7 151.4 243.4 82.9 273 58.6zM297.3 138c44.2 33.7 111.2 81.8 191.5 130 8.7 5.2 15.2 13.9 15.2 24l0 43.9c0 35.6-1.7 65.9-7.2 91.2-5.5 25.6-15.2 47.8-32.5 65.1s-39.5 27-65.1 32.5c-25.3 5.5-55.7 7.2-91.2 7.2l-56 0c-35.6 0-65.9-1.7-91.2-7.2-25.6-5.5-47.8-15.2-65.1-32.5s-27-39.5-32.5-65.1C57.7 401.9 56 371.6 56 336l0-43.9c0-10.1 6.6-18.8 15.2-24 80.3-48.2 147.3-96.3 191.5-130 10.2-7.8 24.4-7.8 34.6 0zM224 448.5c0 15.1 11.9 27.4 27 27.5l58 0c15.1 0 27-12.4 27-27.5l0-84.5c0-30.9-25.1-56-56-56s-56 25.1-56 56l0 84.5z"],
    "play-pause": [560, 560, [], "e22f", "M77.5 56c14.6 0 29.5 4.6 41.7 14.5 28.3 22.9 106.2 90.9 154.4 183.3 4.3 8.3 6.4 17.3 6.4 26.2s-2 17.9-6.4 26.2C225.4 398.6 147.5 466.6 119.2 489.5 107 499.4 92.1 504 77.5 504 48.9 504 21 485.6 14.4 454.1 7.9 422.8 0 366.8 0 280S7.9 137.2 14.4 105.9C21 74.4 48.9 56 77.5 56zM350.5 89c-2.8-15.2 7.3-29.8 22.5-32.6s29.8 7.3 32.6 22.5C417.5 144.9 420 213.2 420 280s-2.5 135.1-14.5 201c-2.8 15.2-17.4 25.3-32.6 22.5s-25.3-17.4-22.5-32.6c11-62.7 13.5-127.5 13.5-191s-2.5-128.3-13.5-191zm140 0c-2.8-15.2 7.3-29.8 22.5-32.6s29.8 7.3 32.6 22.5c11.8 66 14.5 134.3 14.5 201s-2.6 135.1-14.5 201c-2.8 15.2-17.4 25.3-32.6 22.5s-25.3-17.4-22.5-32.6c11-62.7 13.5-127.5 13.5-191s-2.5-128.3-13.5-191z"],
    "sliders": [560, 560, ["sliders-h"], "f1de", "M168 280c22.3 0 45.4-5.6 62.2-24 16.3-17.8 21.8-42.5 21.8-69.3l0-93.3c0-26.9-5.5-51.5-21.8-69.3-16.8-18.4-39.9-24-62.2-24s-45.4 5.6-62.2 24C89.6 41.8 84 66.4 84 93.3l0 18.7-56 0c-15.5 0-28 12.5-28 28s12.5 28 28 28l56 0 0 18.7c0 26.9 5.6 51.5 21.8 69.3 16.8 18.4 39.9 24 62.2 24zM454.2 536c-16.8 18.4-39.9 24-62.2 24s-45.4-5.6-62.2-24c-16.3-17.8-21.8-42.5-21.8-69.3l0-93.3c0-26.9 5.5-51.5 21.8-69.3 16.8-18.4 39.9-24 62.2-24s45.4 5.6 62.2 24c16.3 17.8 21.8 42.5 21.8 69.3l0 18.7 56 0c15.5 0 28 12.5 28 28s-12.5 28-28 28l-56 0 0 18.7c0 26.9-5.5 51.5-21.8 69.3zM0 420c0-15.5 12.5-28 28-28l196 0c15.5 0 28 12.5 28 28s-12.5 28-28 28L28 448c-15.5 0-28-12.5-28-28zM336 112c-15.5 0-28 12.5-28 28s12.5 28 28 28l196 0c15.5 0 28-12.5 28-28s-12.5-28-28-28l-196 0z"],
    "face-frown": [560, 560, [9785, "frown"], "f119", "M280 0C197 0 126.4 26.5 76.5 76.5S0 197 0 280 26.5 433.6 76.5 483.5 197 560 280 560 433.6 533.5 483.5 483.5 560 363 560 280 533.5 126.4 483.5 76.5 363 0 280 0zM168 168c15.5 0 28 12.5 28 28l0 56c0 15.5-12.5 28-28 28s-28-12.5-28-28l0-56c0-15.5 12.5-28 28-28zm140 0c15.5 0 28 12.5 28 28l0 56c0 15.5-12.5 28-28 28s-28-12.5-28-28l0-56c0-15.5 12.5-28 28-28zm70.7 205.2c10.4 11.4 9.5 29.2-1.9 39.6s-29.2 9.5-39.6-1.9c-18.2-20-46.5-32.8-85.2-32.8-17.7 0-33.3 2.7-46.5 7.5-14.6 5.2-30.6-2.3-35.8-16.9s2.3-30.6 16.9-35.8c20-7.2 42-10.8 65.5-10.8 51.5 0 96.1 17.4 126.7 51.2z"],
    "forward-step": [560, 560, ["step-forward"], "f051", "M116.2 66.5C104.8 59.2 92 56 79.5 56 49.8 56 20.9 75.1 14.3 107.7 7.8 139.4 .2 194.9 .2 280s7.6 140.6 14 172.3c6.6 32.6 35.5 51.7 65.2 51.7 12.5 0 25.3-3.2 36.7-10.5 31.6-20.1 133.9-89.9 185.6-187.2 4.5-8.4 6.5-17.5 6.5-26.4s-2-17.9-6.5-26.4c-51.7-97.3-154-167.1-185.6-187.2zM455.2 56c-17.7 0-36.5 .8-52.7 7.4-18.7 7.7-31 21.7-38.6 41-6.9 17.6-10 40.1-11.7 67.4-4.4 71.5-4.4 144.9 0 216.4 1.7 27.3 4.8 49.8 11.7 67.4 7.5 19.3 19.9 33.3 38.6 41 16.2 6.6 34.9 7.4 52.7 7.4s36.5-.8 52.7-7.4c18.7-7.7 31.1-21.7 38.6-41 6.9-17.6 10-40.1 11.7-67.4 4.4-71.5 4.4-144.9 0-216.4-1.7-27.3-4.8-49.8-11.7-67.4-7.5-19.3-19.9-33.3-38.6-41-16.2-6.6-35-7.4-52.7-7.4z"],
    "sort": [448, 560, ["unsorted"], "f0dc", "M448 190.6c0-11.8-4-23.7-12.1-33.3-19.8-23.4-89.6-100.9-185.7-150.9-8.3-4.3-17.3-6.3-26.2-6.3s-17.9 2-26.2 6.3C101.7 56.3 31.9 133.9 12.1 157.3 4 166.9 0 178.8 0 190.6 0 214.7 16.8 237.2 42.7 241.2 71 245.6 128.6 252 224 252s153-6.4 181.3-10.8c26-4 42.7-26.5 42.7-50.6zm0 178.8c0 11.8-4 23.7-12.1 33.3-19.8 23.4-89.6 101-185.7 150.9-8.3 4.3-17.3 6.3-26.2 6.3s-17.9-2-26.2-6.3C101.7 503.7 31.9 426.1 12.1 402.7 4 393.1 0 381.2 0 369.4 0 345.3 16.8 322.8 42.7 318.8 71 314.4 128.6 308 224 308s153 6.4 181.3 10.8c26 4 42.7 26.5 42.7 50.6z"],
    "user": [448, 560, [128100, 62144, 62470, "user-alt", "user-large"], "f007", "M224.2 0c-40.3 0-75.9 12.9-101.5 38.5S84.2 99.7 84.2 140 97.1 215.9 122.7 241.5 183.9 280 224.2 280 300 267.1 325.7 241.5 364.2 180.3 364.2 140 351.3 64.1 325.7 38.5 264.4 0 224.2 0zm-28 336c-33.5 0-62.2 1.5-86.3 6-24.2 4.5-45.5 12.2-62.8 25.7-35.8 28-44.8 73.1-46.6 127.5-.9 26.5 17.7 50.3 45 54.4 29.2 4.4 86.1 10.4 178.7 10.4s149.5-6 178.7-10.4c27.3-4.1 45.8-27.9 45-54.4-1.8-54.4-10.7-99.5-46.6-127.5-17.3-13.6-38.6-21.3-62.8-25.7-24.1-4.5-52.8-6-86.3-6l-56 0z"],
    "signal-bars": [616, 560, ["signal-alt", "signal-alt-4", "signal-bars-strong"], "f690", "M560 56c-30.9 0-56 25.1-56 56l0 364c0 15.5 12.5 28 28 28l28 0c30.9 0 56-25.1 56-56l0-336c0-30.9-25.1-56-56-56zM336 196c0-30.9 25.1-56 56-56l28 0c15.5 0 28 12.5 28 28l0 308c0 15.5-12.5 28-28 28l-56 0c-15.5 0-28-12.5-28-28l0-280zM224 224c-30.9 0-56 25.1-56 56l0 196c0 15.5 12.5 28 28 28l56 0c15.5 0 28-12.5 28-28l0-224c0-15.5-12.5-28-28-28l-28 0zM56 308c-30.9 0-56 25.1-56 56l0 84c0 30.9 25.1 56 56 56l28 0c15.5 0 28-12.5 28-28l0-140c0-15.5-12.5-28-28-28l-28 0z"],
    "snowflake": [560, 560, [10052, 10054], "f2dc", "M308.5 0c0-15.5-12.5-28-28-28s-28 12.5-28 28l0 36.6c-4.5-2.4-8.9-4.9-13.3-7.6-13.1-8.1-30.4-4.1-38.5 9.1s-4.1 30.4 9.1 38.5c13.6 8.4 27.9 15.7 42.7 21.8l0 55.4c-10.9 4.5-22.9 10.1-35 17.1s-23 14.5-32.3 21.8l-47.6-27.5c2.2-16 3-32.2 2.5-48.3-.5-15.5-13.4-27.6-28.9-27.1s-27.6 13.4-27.1 28.9c.2 5.2 .1 10.5 0 15.7L52 115.8C38.6 108 21.5 112.6 13.8 126S10.6 156.5 24 164.2l31.8 18.3c-4.4 2.7-8.9 5.3-13.5 7.8-13.6 7.3-18.8 24.2-11.5 37.9S55 247 68.6 239.8c14.3-7.6 27.9-16.4 40.7-26.3l47.9 27.7c-1.6 11.7-2.7 24.8-2.7 38.8s1.1 27.1 2.7 38.8l-48.1 27.8c-12.7-9.8-26.3-18.5-40.5-26.1-13.6-7.3-30.6-2.1-37.9 11.5s-2.1 30.6 11.5 37.9c4.5 2.4 8.9 4.9 13.2 7.6L24 395.8C10.6 403.5 6 420.6 13.8 434S38.6 452 52 444.2l32.1-18.5c.2 5.3 .2 10.6 .1 15.9-.5 15.5 11.7 28.4 27.1 28.9s28.4-11.7 28.9-27.1c.5-16.2-.4-32.5-2.6-48.5l47.7-27.5c9.3 7.2 20.1 14.8 32.3 21.8s24.1 12.6 35 17.1l0 55.6c-14.8 6.1-29.1 13.4-42.7 21.8-13.1 8.1-17.2 25.4-9.1 38.5s25.4 17.2 38.5 9.1c4.3-2.7 8.8-5.2 13.3-7.6l0 36.4c0 15.5 12.5 28 28 28s28-12.5 28-28l0-36.4c4.7 2.5 9.3 5.2 13.8 8 13.1 8.2 30.4 4.2 38.6-8.9s4.2-30.4-8.9-38.6c-13.8-8.6-28.4-16-43.4-22.2l0-55.6c10.9-4.5 22.9-10.1 35-17.1s23-14.5 32.3-21.8l48.5 28c-2.1 16-3 32.2-2.4 48.4 .5 15.5 13.5 27.6 28.9 27s27.6-13.5 27-28.9c-.2-5.2-.2-10.4 0-15.5l31.2 18c13.4 7.7 30.5 3.1 38.2-10.2s3.1-30.5-10.2-38.2l-31.5-18.2c4.4-2.8 9-5.4 13.6-7.9 13.6-7.3 18.7-24.3 11.4-37.9s-24.3-18.7-37.9-11.4c-14.2 7.6-27.8 16.5-40.6 26.4l-48.2-27.8c1.6-11.7 2.7-24.8 2.7-38.8s-1.1-27.1-2.7-38.8l48-27.7c12.8 10 26.4 18.8 40.8 26.5 13.6 7.3 30.6 2.2 37.9-11.4s2.2-30.6-11.4-37.9c-4.7-2.5-9.3-5.2-13.8-8L537 164.2c13.4-7.7 18-24.9 10.3-38.2s-24.9-18-38.3-10.2l-31.2 18c-.2-5.1-.2-10.2 0-15.3 .5-15.5-11.6-28.4-27-28.9s-28.4 11.6-28.9 27c-.5 16.1 .3 32.2 2.4 48.1l-48.5 28c-9.3-7.2-20.1-14.8-32.3-21.8s-24.1-12.6-35-17.1l0-55.4c15.1-6.2 29.6-13.6 43.4-22.2 13.1-8.2 17.1-25.5 8.9-38.6s-25.5-17.1-38.6-8.9c-4.5 2.8-9.1 5.5-13.8 8l0-36.6z"],
    "ticket": [560, 560, [127903], "f145", "M196.2 56l35 0c11.6 0 21 9.4 21 21l0 49c0 15.5 12.5 28 28 28s28-12.5 28-28l0-49c0-11.6 9.4-21 21-21l35 0c59.6 0 107.4 4.6 140.8 27 36.3 24.3 49 64.4 53.3 114.3 1.9 22.1-13.2 37.9-27.9 43.8-15.4 6.3-26.2 21.4-26.2 38.9s10.8 32.6 26.2 38.9c14.6 6 29.8 21.7 27.9 43.8-4.3 49.9-16.9 90-53.3 114.3-33.4 22.3-81.1 27-140.8 27l-35 0c-11.6 0-21-9.4-21-21l0-49c0-15.5-12.5-28-28-28s-28 12.5-28 28l0 49c0 11.6-9.4 21-21 21l-35 0c-59.6 0-107.4-4.6-140.8-27-36.3-24.3-49-64.4-53.3-114.3-1.9-22.1 13.2-37.9 27.9-43.8 15.4-6.3 26.2-21.4 26.2-38.9S45.4 247.4 30 241.1c-14.6-6-29.8-21.7-27.9-43.8 4.3-49.9 16.9-90 53.3-114.3 33.4-22.3 81.1-27 140.8-27zm112 175c0-15.5-12.5-28-28-28s-28 12.5-28 28l0 91c0 15.5 12.5 28 28 28s28-12.5 28-28l0-91z"],
    "volume-off": [616, 560, [], "f026", "M0 273l0 14c0 22.4 1.1 42.3 4.7 59.2 3.7 17.2 10.5 33.2 23.2 45.9s28.7 19.4 45.9 23.2c15.1 3.3 32.6 4.5 52.2 4.7l58.8 78.4C200.7 519.6 225.6 532 252 532l16.3 0c35.4 0 69-22.9 77.2-60.4 8.4-38.8 18.6-103.7 18.6-191.6S353.9 127.2 345.4 88.4C337.3 50.9 303.7 28 268.3 28L252 28c-26.4 0-51.3 12.4-67.2 33.6L126 140c-19.6 .2-37.1 1.4-52.2 4.7-17.2 3.7-33.2 10.5-45.9 23.2S8.4 196.6 4.7 213.8C1.1 230.7 0 250.6 0 273z"],
    "bookmark": [448, 560, [128278, 61591], "f02e", "M196 0c-35.6 0-65.9 1.7-91.2 7.2-25.6 5.5-47.8 15.2-65.1 32.5s-27 39.5-32.5 65.1C1.7 130.1 0 160.4 0 196L0 466.7c0 51.5 41.8 93.3 93.3 93.3 29.4 0 57-13.8 74.7-37.3l56-74.7 56 74.7c17.6 23.5 45.3 37.3 74.7 37.3 51.5 0 93.3-41.8 93.3-93.3L448 196c0-35.6-1.7-65.9-7.2-91.2-5.5-25.6-15.2-47.8-32.5-65.1s-39.5-27-65.1-32.5C317.9 1.7 287.6 0 252 0L196 0z"],
    "list-ol": [504, 560, ["list-1-2", "list-numeric"], "f0cb", "M112 56c0-9.7-5-18.7-13.3-23.8S80.2 26.6 71.5 31l-56 28C1.7 65.9-4 82.7 3 96.5S26.7 116 40.5 109L56 101.3 56 224c0 15.5 12.5 28 28 28s28-12.5 28-28l0-168zM224 84c0-15.5 12.5-28 28-28l196 0c15.5 0 28 12.5 28 28s-12.5 28-28 28l-196 0c-15.5 0-28-12.5-28-28zm0 196c0-15.5 12.5-28 28-28l196 0c15.5 0 28 12.5 28 28s-12.5 28-28 28l-196 0c-15.5 0-28-12.5-28-28zm0 196c0-15.5 12.5-28 28-28l196 0c15.5 0 28 12.5 28 28s-12.5 28-28 28l-196 0c-15.5 0-28-12.5-28-28zM0 336c0-15.5 12.5-28 28-28l43.3 0c37.9 0 68.7 30.7 68.7 68.7 0 29.6-18.9 55.8-47 65.2l-28.4 9.5c-5.2 1.7-8.7 6.6-8.7 12 0 7 5.7 12.7 12.7 12.7l43.3 0c15.5 0 28 12.5 28 28s-12.5 28-28 28l-43.3 0C30.8 532 0 501.3 0 463.3 0 433.8 18.9 407.5 47 398.2l28.4-9.5c5.2-1.7 8.7-6.6 8.7-12 0-7-5.7-12.7-12.7-12.7L28 364c-15.5 0-28-12.5-28-28z"],
    "bomb": [616, 560, [128163], "f1e2", "M400.7-19.8c10.9-10.9 28.7-10.9 39.6 0l28 28c10.9 10.9 10.9 28.7 0 39.6s-28.7 10.9-39.6 0l-28-28c-10.9-10.9-10.9-28.7 0-39.6zm207.6 0c10.9 10.9 10.9 28.7 0 39.6l-28 28c-10.9 10.9-28.7 10.9-39.6 0s-10.9-28.7 0-39.6l28-28c10.9-10.9 28.7-10.9 39.6 0zm-67.6 140c10.9-10.9 28.7-10.9 39.6 0l28 28c10.9 10.9 10.9 28.7 0 39.6s-28.7 10.9-39.6 0l-28-28c-10.9-10.9-10.9-28.7 0-39.6zM93.6 149.1c42.6-42.6 102.7-65.1 172.9-65.1 59.3 0 111.3 16 151.8 46.6l24.4-24.4c10.9-10.9 28.7-10.9 39.6 0s10.9 28.7 0 39.6l-24.4 24.4c30.6 40.4 46.6 92.5 46.6 151.8 0 70.2-22.5 130.3-65.1 172.9S336.7 560 266.5 560 136.2 537.5 93.6 494.9 28.5 392.2 28.5 322 51 191.7 93.6 149.1zM168.5 308c0-28.2 8.8-48.6 22.1-61.9S224.3 224 252.5 224c15.5 0 28-12.5 28-28s-12.5-28-28-28c-40.3 0-75.9 12.9-101.5 38.5S112.5 267.7 112.5 308c0 15.5 12.5 28 28 28s28-12.5 28-28z"],
    "volume-xmark": [616, 560, ["volume-mute", "volume-times"], "f6a9", "M0 287l0-14c0-22.4 1.1-42.3 4.7-59.2 3.7-17.2 10.5-33.2 23.2-45.9s28.7-19.4 45.9-23.2c15.1-3.3 32.6-4.5 52.2-4.7l58.8-78.4C200.7 40.4 225.6 28 252 28l16.3 0c35.4 0 69 22.9 77.2 60.4 8.4 38.8 18.6 103.7 18.6 191.6s-10.1 152.8-18.6 191.6c-8.1 37.5-41.7 60.4-77.2 60.4L252 532c-26.4 0-51.3-12.4-67.2-33.6L126 420c-19.6-.2-37.1-1.4-52.2-4.7-17.2-3.7-33.2-10.5-45.9-23.2S8.4 363.4 4.7 346.2C1.1 329.3 0 309.4 0 287zm495.8-82.8c-10.9-10.9-28.7-10.9-39.6 0s-10.9 28.7 0 39.6l36.2 36.2-36.2 36.2c-10.9 10.9-10.9 28.7 0 39.6s28.7 10.9 39.6 0l36.2-36.2 36.2 36.2c10.9 10.9 28.7 10.9 39.6 0s10.9-28.7 0-39.6l-36.2-36.2 36.2-36.2c10.9-10.9 10.9-28.7 0-39.6s-28.7-10.9-39.6 0l-36.2 36.2-36.2-36.2z"],
    "arrow-right": [560, 560, [8594], "f061", "M378.5 516.3c-11.8 10.5-26.8 15.7-41.8 15.7-29.6 0-56.5-20.4-61.9-51.3-3.9-22.4-8.9-56.8-12.2-101.4-.7-9.3-8.7-15.3-16.6-14.3L78.7 385.9C36.9 391.1 0 358.5 0 316.4l0-72.8c0-42.1 36.9-74.7 78.7-69.5L246 195c7.9 1 15.9-5.1 16.6-14.3 3.3-44.6 8.3-79 12.2-101.4 5.4-30.9 32.4-51.3 61.9-51.3 15 0 30 5.2 41.8 15.7 30.3 26.8 125 114.5 175.1 210.1 4.4 8.3 6.4 17.4 6.4 26.2s-2 17.9-6.4 26.2c-50.1 95.6-144.8 183.3-175.1 210.1z"],
    "battery-bolt": [672, 560, [], "f376", "M56 308c0 35.6 1.7 65.9 7.2 91.2 5.5 25.6 15.2 47.8 32.5 65.1s39.5 27 65.1 32.5c25.3 5.5 55.7 7.2 91.2 7.2l126 0c35.6 0 65.9-1.7 91.2-7.2 25.6-5.5 47.8-15.2 65.1-32.5s27-39.5 32.5-65.1c5.5-25.3 7.2-55.7 7.2-91.2l0-56c0-35.6-1.7-65.9-7.2-91.2-5.5-25.6-15.2-47.8-32.5-65.1s-39.5-27-65.1-32.5C443.9 57.7 413.6 56 378 56L252 56c-35.6 0-65.9 1.7-91.2 7.2-25.6 5.5-47.8 15.2-65.1 32.5s-27 39.5-32.5 65.1C57.7 186.1 56 216.4 56 252l0 56zm142.1-5.1c-12.6 8.9-30.1 5.9-39-6.7s-5.9-30.1 6.7-39L266.6 186c25.3-17.9 60.6-3.1 65.6 27.4l17 102 82.6-58.3c12.6-8.9 30.1-5.9 39 6.7s5.9 30.1-6.7 39L363.4 374c-25.3 17.9-60.6 3.1-65.6-27.4l-17-102-82.6 58.3zM644 196c15.5 0 28 12.5 28 28l0 112c0 15.5-12.5 28-28 28s-28-12.5-28-28l0-112c0-15.5 12.5-28 28-28z"],
    "xmark": [504, 560, [128473, 10005, 10006, 10060, 215, "close", "multiply", "remove", "times"], "f00d", "M252.4 122.3c21.1-20.5 39.4-37.5 55.5-51.1 20.7-17.5 39.5-30.9 57.7-38.4 19.3-8 38.5-9.7 57.9-3 17.8 6.2 32.9 18.7 46.7 32.4s26.2 28.8 32.4 46.7c6.7 19.3 5 38.6-3 57.8-7.6 18.2-20.9 37-38.4 57.7-13.6 16.1-30.7 34.4-51.1 55.5 20.5 21.1 37.5 39.4 51.1 55.6 17.5 20.7 30.9 39.5 38.4 57.7 8 19.3 9.7 38.5 3 57.8-6.2 17.8-18.7 32.9-32.4 46.7s-28.8 26.2-46.7 32.4c-19.3 6.7-38.6 5-57.9-3-18.2-7.6-37-20.9-57.7-38.4-16.1-13.6-34.4-30.7-55.5-51.1-21.1 20.5-39.4 37.5-55.6 51.1-20.7 17.5-39.5 30.9-57.7 38.4-19.3 8-38.5 9.7-57.8 3-17.8-6.2-32.9-18.7-46.7-32.4S8.4 468.9 2.2 451.1c-6.7-19.3-5-38.6 3-57.8 7.6-18.2 20.9-37 38.4-57.7 13.6-16.1 30.7-34.4 51.1-55.6-20.5-21.1-37.5-39.4-51.1-55.5-17.5-20.7-30.9-39.5-38.4-57.7-8-19.3-9.7-38.5-3-57.8 6.2-17.8 18.7-32.9 32.4-46.7S63.5 36 81.3 29.8c19.3-6.7 38.6-5 57.8 3 18.2 7.6 37 20.9 57.7 38.4 16.1 13.6 34.4 30.7 55.6 51.1z"],
    "lock-open": [672, 560, [], "f3c1", "M470.1 78.1C456.8 91.4 448 111.8 448 140l0 33.8c26.6 4.8 52.9 14.5 72.3 33.9 17.3 17.3 27 39.5 32.5 65.1 9.8 45.4 9.8 137 0 182.4-5.5 25.6-15.2 47.8-32.5 65.1s-39.5 27-65.1 32.5c-25.3 5.5-55.7 7.2-91.2 7.2l-56 0c-35.6 0-65.9-1.7-91.2-7.2-25.6-5.5-47.8-15.2-65.1-32.5s-27-39.5-32.5-65.1c-9.8-45.4-9.8-137 0-182.4 5.5-25.6 15.2-47.8 32.5-65.1s39.5-27 65.1-32.5c25.3-5.5 55.7-7.2 91.2-7.2l56 0c9.7 0 19.1 .1 28 .4l0-28.4c0-40.3 12.9-75.9 38.5-101.5S491.7 0 532 0 607.9 12.9 633.5 38.5 672 99.7 672 140l0 56c0 15.5-12.5 28-28 28s-28-12.5-28-28l0-56c0-28.2-8.8-48.6-22.1-61.9S560.2 56 532 56 483.4 64.8 470.1 78.1zM364 392.6c0-5 2.8-9.5 6.7-12.6 13-10.3 21.3-26.1 21.3-44 0-30.9-25.1-56-56-56s-56 25.1-56 56c0 17.8 8.3 33.7 21.3 44 3.9 3.1 6.7 7.6 6.7 12.6l0 27.4c0 15.5 12.5 28 28 28s28-12.5 28-28l0-27.4z"],
    "droplet": [448, 560, [128167, "tint"], "f043", "M155.9 26.9C174.6 8.6 199.5 0 224 0s49.4 8.6 68.1 26.9c23.4 22.8 61.9 64 94.8 117 32.7 52.8 61.1 119.3 61.1 192.1 0 65.9-21.1 122.5-61.3 162.7S289.9 560 224 560 101.5 538.9 61.3 498.7 0 401.9 0 336c0-72.8 28.3-139.3 61.1-192.1 32.9-53 71.4-94.3 94.8-117zm-3.9 233.7c4.7-14.7-3.4-30.5-18.1-35.2s-30.5 3.4-35.2 18.1c-9.3 29.2-14.6 58.4-14.6 86.9 0 55.7 16.3 89.2 34.8 108.5 18.6 19.5 51.1 37.1 105.2 37.1 15.5 0 28-12.5 28-28s-12.5-28-28-28c-41.1 0-58.1-12.8-64.7-19.7-6.7-7-19.3-25.6-19.3-69.9 0-21.7 4-45.1 11.9-69.9z"],
    "shop": [560, 560, ["store-alt"], "f54f", "M364 204c21.4 23.4 52.8 34 84 34 31.7 0 60.3-10.2 81-31s31-49.3 31-81C560 71.1 520.5 37.9 502.4 25.4 491.6 18 479.9 14 468.8 12 443.9 7.7 384.7 0 280 0S116.1 7.7 91.2 12C80.1 14 68.4 18 57.6 25.4 39.5 37.9 0 71.1 0 126 0 157.7 10.2 186.3 31 207s49.3 31 81 31c31.2 0 62.6-10.7 84-34 21.4 23.4 52.8 34 84 34s62.6-10.7 84-34zM207.2 279.3c-7.2-3.1-15.3-3.1-22.5 0-22.9 10.1-47.9 14.7-72.8 14.7-8.2 0-16.3-.5-24.5-1.5-8-1-16 1.5-22 6.8s-9.5 13-9.5 21L56 364c0 35.6 1.7 65.9 7.2 91.2 5.5 25.6 15.2 47.8 32.5 65.1s39.5 27 65.1 32.5c25.3 5.5 55.7 7.2 91.2 7.2l56 0c35.6 0 65.9-1.7 91.2-7.2 25.6-5.5 47.8-15.2 65.1-32.5s27-39.5 32.5-65.1c5.5-25.3 7.2-55.7 7.2-91.2l0-43.8c0-8-3.5-15.7-9.5-21s-14.1-7.8-22-6.8c-8.1 1-16.3 1.5-24.5 1.5-24.9 0-49.8-4.6-72.7-14.7-7.2-3.1-15.3-3.1-22.5 0-22.9 10.1-47.9 14.7-72.7 14.7s-49.8-4.6-72.8-14.7zM224 420c0-30.9 25.1-56 56-56s56 25.1 56 56l0 56.5c0 15.1-11.9 27.4-27 27.5l-58 0c-15.1 0-27-12.4-27-27.5l0-56.5z"],
    "film": [560, 560, [127902, 62368, "film-alt", "film-simple"], "f008", "M168.1 280c0-69.1 3.3-138.2 9.4-207 .9-9.6 8.9-17 18.6-17l168 0c9.7 0 17.7 7.4 18.6 17 6.1 68.8 9.4 137.9 9.4 207s-3.3 138.2-9.4 207c-.9 9.6-8.9 17-18.6 17l-168 0c-9.7 0-17.7-7.4-18.6-17-6.1-68.8-9.4-137.9-9.4-207zM120.9 482.1c.8 9.1-7.1 16.6-16 14.7-25.6-5.5-47.8-15.2-65.1-32.5s-27-39.5-32.5-65.1c-4-18.4-6-39.4-6.8-63.2-.5-15.5 12.1-28 27.6-28l56.5 0c15.3 0 27.8 12.3 28.2 27.6 1.2 48.9 4 97.7 8.1 146.5zM.5 224c-.5 15.5 12.1 28 27.6 28l56.5 0c15.3 0 27.8-12.3 28.2-27.6 1.2-48.9 4-97.7 8.1-146.5 .8-9.1-7.1-16.6-16-14.7-25.6 5.5-47.8 15.2-65.1 32.5s-27 39.5-32.5 65.1c-4 18.4-6 39.4-6.8 63.2zM455.3 496.8c-8.9 1.9-16.8-5.6-16-14.7 4.1-48.7 6.9-97.6 8.1-146.5 .4-15.3 12.8-27.6 28.2-27.6l56.5 0c15.5 0 28.1 12.5 27.6 28-.8 23.8-2.8 44.9-6.8 63.2-5.5 25.6-15.2 47.8-32.5 65.1s-39.5 27-65.1 32.5zm97.6-336c4 18.4 6 39.4 6.8 63.2 .5 15.5-12.1 28-27.6 28l-56.5 0c-15.3 0-27.8-12.3-28.2-27.6-1.2-48.9-4-97.7-8.1-146.5-.8-9.1 7.1-16.6 16-14.7 25.6 5.5 47.8 15.2 65.1 32.5s27 39.5 32.5 65.1z"],
    "comments": [560, 560, [128490, 61670], "f086", "M52.4 48.9C89 15.9 142.4 0 210 0 289 0 348.5 21.7 384.3 66.7 391 75.2 392.2 86.9 387.4 96.6s-14.9 15.8-25.7 15.5c-3.9-.1-7.8-.1-11.7-.1-74.7 0-143.1 16.6-193.7 60.2-37.9 32.7-58.5 74.1-67.3 117.8-2.1 10.4-9.9 18.8-20.2 21.5s-21.2-.5-28.3-8.5C11.9 270.6 0 228.3 0 182 0 129.5 15.4 82.4 52.4 48.9zM350 168c-67.3 0-120.5 15-157.1 46.6-37.3 32.2-52.9 77.6-52.9 128.4 0 46.7 13.2 89.1 44.8 120.8 30.4 30.6 74.6 47.8 130.2 52.7l69.6 61.8c7 6.2 16 9.6 25.3 9.6 21.1 0 38.1-17.1 38.1-38.1 0-14.6-5-29.2-6.5-43.7 37.2-11.2 66.5-30.3 86.9-57.5 22.2-29.7 31.6-66.2 31.6-105.6 0-50.8-15.6-96.2-52.9-128.4-36.6-31.6-89.7-46.6-157.1-46.6z"],
    "circle-check": [560, 560, [61533, "check-circle"], "f058", "M76.5 76.5C126.4 26.5 197 0 280 0S433.6 26.5 483.5 76.5 560 197 560 280 533.5 433.6 483.5 483.5 363 560 280 560 126.4 533.5 76.5 483.5 0 363 0 280 26.5 126.4 76.5 76.5zm333 141.4c12.1-9.7 14-27.3 4.4-39.4s-27.3-14-39.4-4.4c-52.5 42-100.2 111.8-123.8 149.3-15.3-20.1-39.5-48.3-67.2-66.8-12.9-8.6-30.3-5.1-38.8 7.8s-5.1 30.3 7.8 38.8c28.9 19.3 55.6 55.9 65.6 70.7 7.4 11 19.9 18 33.8 18 14.4 0 27.6-7.6 34.9-19.9 14.4-24.5 67.2-109.7 122.8-154.2z"],
    "moon": [560, 560, [127769, 9214], "f186", "M233.7 92.7C239.4 72.3 234 51.1 221.8 36.4 208.9 21 186.7 11.4 162.6 20.7 59.5 61 0 156 0 280 0 363 26.5 433.6 76.5 483.5S197 560 280 560c86.7 0 159.7-28.9 209.9-83 16.6-17.9 16.2-41.2 6.1-58.1-9.5-15.9-27.4-26.9-48-26.9-71 0-126.4-22.5-164-60s-60-93-60-164c0-27.5 3.4-52.7 9.7-75.3z"],
    "plane": [616, 560, [], "f072", "M308 0c-46.2 0-84.8 36-86.9 82.7-1.9 43.3-4.1 106.2-4.1 169.3 0 63.1 6.5 125.8 12.3 169.5-31.9 22-61 44.7-72.9 54.2-10.4 8.3-16.3 20.8-16.3 33.9 0 21.8 16.3 40.7 38.6 43 24.1 2.5 76.6 7.4 129.4 7.4s105.4-4.8 129.4-7.4c22.3-2.4 38.6-21.2 38.6-43 0-13.1-5.9-25.6-16.3-33.9-12-9.5-41-32.2-72.9-54.2 5.8-43.7 12.3-106.4 12.3-169.5 0-63.1-2.2-126.1-4.1-169.3-2.1-46.7-40.7-82.7-86.9-82.7zM150 198.1c7.1 5.4 11.3 13.8 11.2 22.7-.1 10.4-.2 20.8-.2 31.3 0 28 1.2 55.8 3 82 .5 7.7-2.2 15.4-7.4 21.1s-12.7 8.9-20.5 8.9l-59.9 0c-42.1 0-76.2-34.1-76.2-76.2 0-33.6 22.1-63.3 54.3-73l70.8-21.3c8.5-2.6 17.8-.9 24.9 4.4zm316 0c7.1-5.4 16.3-7 24.9-4.4l70.8 21.3c32.2 9.7 54.3 39.3 54.3 73 0 42.1-34.1 76.2-76.2 76.2l-59.9 0c-7.8 0-15.2-3.2-20.5-8.9s-8-13.3-7.5-21.1c1.8-26.2 3-54.1 3-82 0-10.5-.1-20.9-.2-31.3-.1-8.9 4.1-17.3 11.2-22.7z"],
    "images": [560, 560, [], "f302", "M146 330.7c-4.5-21.1-6-46.2-6-75.2l0-91c0-29 1.4-54.1 6-75.2 4.6-21.4 12.9-40.5 27.8-55.5S207.9 10.6 229.3 6c21.1-4.5 46.2-6 75.2-6l91 0c29 0 54.1 1.4 75.2 6 21.4 4.6 40.5 12.9 55.5 27.8S549.4 67.9 554 89.3c5.6 26.2 6 53.2 6 79.8 0 15.1-12.9 26.9-28 26.9-74.5 0-138.1 23.8-183.1 68.9-33.6 33.6-55.3 77.4-64.3 128.4-2.6 14.7-15.1 26.2-30 24.7-9-.9-17.5-2.2-25.4-3.9-21.4-4.6-40.5-12.9-55.5-27.8s-23.2-34.1-27.8-55.5zM266 168a42 42 0 1 0 0-84 42 42 0 1 0 0 84zm291.9 85.2c1.2 .1 2.1 1.1 2.1 2.3 0 29-1.4 54.1-6 75.2-4.6 21.4-12.9 40.5-27.8 55.5s-34.1 23.2-55.5 27.8c-21.1 4.6-46.2 6-75.2 6l-27.1 0c-16.6 0-29.7-14.4-25.9-30.6 8.3-34.8 24.3-63.3 45.9-85 32.7-32.7 81.1-52.5 143.5-52.5 8.9 0 17.6 .4 25.9 1.2zM67.4 165.8C77.5 170.3 84 180.3 84 191.3l0 64.2c0 30.1 1.4 60 7.2 87 6 28 17.9 58.2 43 83.3s55.3 36.9 83.3 43c27 5.8 56.9 7.2 87 7.2l64.2 0c11 0 21.1 6.5 25.6 16.6s2.7 21.9-4.7 30.1c-14.8 16.5-34.2 25.7-56.3 30.8-21.6 5-47.6 6.5-77.7 6.5l-91 0c-29 0-54.1-1.4-75.2-6-21.4-4.6-40.5-12.9-55.5-27.8S10.6 492.1 6 470.7c-4.5-21.1-6-46.2-6-75.2l0-91c0-30.1 1.5-56.1 6.5-77.7 5.1-22.1 14.3-41.5 30.8-56.3 8.2-7.4 20-9.2 30.1-4.7z"],
    "bag-shopping": [448, 560, ["shopping-bag"], "f290", "M162.3 50.1c-13.3 13.3-22.1 33.7-22.1 61.9 0 15.5-12.5 28-28 28s-28-12.5-28-28c0-40.3 12.9-75.9 38.5-101.5S183.9-28 224.2-28 300-15.1 325.6 10.5 364.2 71.7 364.2 112c0 15.5-12.5 28-28 28s-28-12.5-28-28c0-28.2-8.8-48.6-22.1-61.9S252.3 28 224.2 28 175.6 36.8 162.3 50.1zM70.2 192.8c26.4-4.4 77.7-10.8 154-10.8s127.6 6.4 154 10.8c24.4 4.1 41.3 23.8 44.3 46.4l25.5 191.1c.7 5.4 .2 11.1 .2 16.5 0 54.5-39.8 102.4-96.1 107.4-34.1 3-78.3 5.7-127.9 5.7s-93.7-2.7-127.9-5.7c-56.4-5-96.1-52.9-96.1-107.4 0-5.5-.5-11.1 .2-16.5L25.9 239.2c3-22.6 19.9-42.3 44.3-46.4z"],
    "phone": [560, 560, [128222, 128379], "f095", "M117.3 0C98.4 0 80.2 6.4 65.5 18.2L42 36.9C15.5 58.2 0 90.3 0 124.4L0 140C0 265.8 40.2 371.4 114.4 445.6S294.2 560 420 560l15.6 0c34 0 66.2-15.5 87.5-42l18.7-23.4c11.8-14.7 18.2-33 18.2-51.8 0-22-8.7-43.1-24.3-58.6l-50.6-50.6c-35.2-35.2-93.2-44.6-134.9-8.5-33.8 29.3-77.8 74.9-115.6 138.9-30.7-15.4-57.7-34.8-80.7-57.9s-42.5-50-57.9-80.7c64-37.7 109.6-81.7 138.9-115.6 36.1-41.7 26.7-99.7-8.5-134.9L175.9 24.3C160.3 8.7 139.2 0 117.3 0z"],
    "leaf": [560, 560, [], "f06c", "M420 0c-99.8 0-196.2 14.1-268.5 52.2-74.3 39.1-123.5 103.9-123.5 199.8 0 62.8 15.2 118.5 44.2 163.5-10.4 23-20.7 47.2-28.1 71.4-4.3 14-8.6 32.6-15.6 67.6-3 15.2 6.8 29.9 22 32.9s29.9-6.8 32.9-22c7-35 10.8-51.2 14.2-62.3 20.1-66.1 56.6-137.1 106.5-187l84-84c10.9-10.9 28.7-10.9 39.6 0s10.9 28.7 0 39.6l-84 84c-38 38-64.3 89.9-81.2 133.8-1.6 4.2 .2 9 4.2 11.1 40.6 20.6 88.4 31.4 141.2 31.4 95.8 0 160.7-49.1 199.8-123.5 38.1-72.4 52.2-168.7 52.2-268.5 0-43.6-6.9-81.5-32.7-107.3S463.6 0 420 0z"],
    "heart-half": [560, 560, [], "e1ab", "M154 28C109.5 28 70.4 42.3 42.3 70.3S0 137.5 0 182c0 93 51.8 173.6 104 231.7 52.7 58.6 109.6 98.4 127.3 110.2 8.3 5.5 17.7 8.1 26.9 8.1 27.5 0 49.8-22.3 49.8-49.8L308 182c0-44.5-14.3-83.6-42.3-111.7S198.5 28 154 28z"],
    "universal-access": [560, 560, [], "f29a", "M76.5 76.5C126.4 26.5 197 0 280 0S433.6 26.5 483.5 76.5 560 197 560 280 533.5 433.6 483.5 483.5 363 560 280 560 126.4 533.5 76.5 483.5 0 363 0 280 26.5 126.4 76.5 76.5zM238 154a42 42 0 1 0 84 0 42 42 0 1 0 -84 0zm-40.6 46.6c-12.9-8.5-30.2-5-38.7 7.8-8.6 12.9-5.1 30.3 7.8 38.8 25.1 16.6 55.9 26.6 85.5 30.7l0 23.6c-8.5 5-15.3 11.8-20.5 18.3-9.9 12.6-16.8 28.1-21.6 41.6-6.3 17.5-10.9 36-13.6 54.4-2.2 15.3 8.4 29.6 23.7 31.7s29.5-8.5 31.7-23.8c2.2-14.8 5.9-29.5 10.9-43.5 12.1-33.9 22.7-33.9 34.8 0 5 14 8.7 28.8 10.9 43.5 2.2 15.3 16.4 25.9 31.7 23.8s25.9-16.4 23.7-31.7c-2.7-18.4-7.3-36.9-13.6-54.4-4.8-13.5-11.7-28.9-21.6-41.6-5.1-6.5-11.9-13.3-20.5-18.3l0-23.6c29.6-4.1 60.4-14.1 85.5-30.7 12.9-8.6 16.3-26 7.8-38.8-8.6-12.8-25.9-16.3-38.7-7.8-23.9 15.4-54.4 23.4-82.6 23.4s-58.7-8-82.6-23.4z"],
    "square-code": [504, 560, [], "e267", "M0 336c0 35.6 1.7 65.9 7.2 91.2 5.5 25.6 15.2 47.8 32.5 65.1s39.5 27 65.1 32.5c25.3 5.5 55.7 7.2 91.2 7.2l112 0c35.6 0 65.9-1.7 91.2-7.2 25.6-5.5 47.8-15.2 65.1-32.5s27-39.5 32.5-65.1c5.5-25.3 7.2-55.7 7.2-91.2l0-112c0-35.6-1.7-65.9-7.2-91.2-5.5-25.6-15.2-47.8-32.5-65.1s-39.5-27-65.1-32.5C373.9 29.7 343.6 28 308 28L196 28c-35.6 0-65.9 1.7-91.2 7.2-25.6 5.5-47.8 15.2-65.1 32.5s-27 39.5-32.5 65.1C1.7 158.1 0 188.4 0 224L0 336zM215.8 176.2c10.9 10.9 10.9 28.7 0 39.6l-64.2 64.2 64.2 64.2c10.9 10.9 10.9 28.7 0 39.6s-28.7 10.9-39.6 0L112 319.6c-21.9-21.9-21.9-57.3 0-79.2l64.2-64.2c10.9-10.9 28.7-10.9 39.6 0zm72.4 39.6c-10.9-10.9-10.9-28.7 0-39.6s28.7-10.9 39.6 0L392 240.4c21.9 21.9 21.9 57.3 0 79.2l-64.2 64.2c-10.9 10.9-28.7 10.9-39.6 0s-10.9-28.7 0-39.6l64.2-64.2-64.2-64.2z"],
    "volume-low": [616, 560, [128264, "volume-down"], "f027", "M0 287l0-14c0-22.4 1.1-42.3 4.7-59.2 3.7-17.2 10.5-33.2 23.2-45.9s28.7-19.4 45.9-23.2c15.1-3.3 32.6-4.5 52.2-4.7l58.8-78.4C200.7 40.4 225.6 28 252 28l16.3 0c35.4 0 69 22.9 77.2 60.4 8.4 38.8 18.6 103.7 18.6 191.6s-10.1 152.8-18.6 191.6c-8.1 37.5-41.7 60.4-77.2 60.4L252 532c-26.4 0-51.3-12.4-67.2-33.6L126 420c-19.6-.2-37.1-1.4-52.2-4.7-17.2-3.7-33.2-10.5-45.9-23.2S8.4 363.4 4.7 346.2C1.1 329.3 0 309.4 0 287zM459.3 125.6c-8.9-12.7-26.3-15.7-39-6.8s-15.7 26.3-6.8 39c21.8 31 34.5 72.1 34.5 122.2s-12.8 91.2-34.5 122.2c-8.9 12.7-5.8 30.1 6.8 39s30.1 5.8 39-6.8C488.7 392.4 504 339.7 504 280s-15.3-112.4-44.7-154.4z"],
    "hourglass": [504, 560, [9203, 62032, "hourglass-empty"], "f254", "M.2 38.5c-1.9 15.3 9 29.3 24.3 31.3 10.6 1.3 21.3 2.4 32 3.5 3.6 61.4 26.4 106.7 59.4 142.6 5.2 5.6 10.6 10.9 16.2 16.1 9 8.3 22.6 8.7 32.9 2.2 3.3-2.1 6.5-4.1 9.8-6 13.2-8.1 30.4-3.9 38.5 9.3s3.9 30.4-9.3 38.5c-8.8 5.4-17.7 11-26.4 16.9-22.2 15-43.5 31.7-61.6 51.4-36.4 39.2-56.3 89.3-59.4 142.6-10.7 1.1-21.3 2.2-32 3.5-15.3 1.9-26.2 15.9-24.3 31.3s15.9 26.2 31.3 24.3c73-9 147-13.8 220.5-13.8s147.5 4.8 220.5 13.8c15.3 1.9 29.3-9 31.3-24.3s-9-29.3-24.3-31.3c-10.6-1.3-21.3-2.4-32-3.5-3.6-61.4-26.4-106.7-59.4-142.6-5.2-5.6-10.6-10.9-16.2-16.1-9-8.3-22.6-8.7-32.9-2.2-3.3 2.1-6.5 4.1-9.8 6-13.2 8.1-30.4 3.9-38.5-9.3s-3.9-30.4 9.3-38.5c9.5-5.8 19-11.8 28.4-18.2 21.5-14.6 42-30.9 59.6-50 33.1-35.8 55.8-81.2 59.4-142.6 10.7-1.1 21.3-2.2 32-3.5 15.3-1.9 26.2-15.9 24.3-31.3s-15.9-26.2-31.3-24.3c-73 9-147 13.8-220.5 13.8S104.5 23.2 31.5 14.2C16.1 12.3 2.1 23.2 .2 38.5z"],
    "fish": [560, 560, [128031], "f578", "M348.7 21c56.4-4.2 111 .9 139.2 4.5 24.5 3.1 43.6 22.2 46.7 46.7 3.5 28.2 8.7 82.8 4.5 139.2-4.1 54.7-17.4 118.7-57.2 158.5-25.2 25.2-61.8 41.4-98.6 52.2-27.3 8-56.5 13.6-84.6 17.4 .7 11.4-.3 23-3.2 34.4l-5.1 20.3c-9.7 38.7-44.4 65.8-84.3 65.8-9.6 0-20.6-1.6-31.2-6.7-18.1-8.6-54.3-29.2-96.6-71.5S15.3 403.3 6.7 385.2C1.6 374.6 0 363.6 0 354 0 314.1 27.1 279.4 65.8 269.7l20.3-5.1c11.4-2.9 23-3.9 34.4-3.2 3.9-28.1 9.4-57.3 17.4-84.6 10.8-36.8 27-73.4 52.2-98.6 39.8-39.8 103.8-53.1 158.5-57.2zM322 224a42 42 0 1 0 0-84 42 42 0 1 0 0 84z"],
    "list": [448, 560, ["list-squares"], "f03a", "M0 84A56 56 0 1 1 112 84 56 56 0 1 1 0 84zM56 336a56 56 0 1 0 0-112 56 56 0 1 0 0 112zm0 196c34.2 0 56-21.8 56-56s-21.8-56-56-56-56 21.8-56 56 21.8 56 56 56zM224 56c-15.5 0-28 12.5-28 28s12.5 28 28 28l196 0c15.5 0 28-12.5 28-28s-12.5-28-28-28L224 56zm0 196c-15.5 0-28 12.5-28 28s12.5 28 28 28l196 0c15.5 0 28-12.5 28-28s-12.5-28-28-28l-196 0zm0 196c-15.5 0-28 12.5-28 28s12.5 28 28 28l196 0c15.5 0 28-12.5 28-28s-12.5-28-28-28l-196 0z"],
    "headphones": [560, 560, [127911, 62863, "headphones-alt", "headphones-simple"], "f025", "M81 280c-8.1 0-16.2 .5-24 1.9 4.9-59.2 26.6-106 60.1-139 37.6-36.9 92.6-59 162.9-59s125.3 22 162.9 59c33.5 32.9 55.2 79.8 60.1 139-7.8-1.4-15.9-1.9-24-1.9l-27 0c-24.5 0-49.2 5-66.7 23.9-16.9 18.3-21.3 43.6-21.3 69.5l0 93.3c0 25.8 4.4 51.2 21.3 69.5 17.5 18.9 42.2 23.9 66.7 23.9 42.2 0 84.3-25.4 93.6-72.5 11.8-60.4 14.8-122.9 14.4-184.2-1-81.8-28-151.2-77.8-200.2-49.8-49-119.9-75-202.1-75S127.7 54 77.9 103c-49.8 49-76.8 118.5-77.8 200.2-.4 61.4 2.6 123.9 14.4 184.2 9.2 47.1 51.4 72.5 93.6 72.5 24.5 0 49.2-5 66.7-23.9 16.9-18.3 21.3-43.6 21.3-69.5l0-93.3c0-25.8-4.4-51.2-21.3-69.5-17.5-18.9-42.2-23.9-66.7-23.9l-27 0z"],
    "bus": [672, 560, [128653], "f207", "M216.8 7.2C242.1 1.7 272.4 0 308 0l56 0c35.6 0 65.9 1.7 91.2 7.2 25.6 5.5 47.8 15.2 65.1 32.5s27 39.5 32.5 65.1c3.5 16.3 5.5 34.6 6.4 55.2 .7 14.4-10.2 26.6-24.5 27.9-41.8 3.8-109.4 8.2-198.7 8.2s-156.9-4.4-198.7-8.2c-14.3-1.3-25.2-13.5-24.5-27.9 1-20.5 2.9-38.9 6.4-55.2 5.5-25.6 15.2-47.8 32.5-65.1s39.5-27 65.1-32.5zM143 244.5c-16.6-1.4-31 11.6-31 28.2L112 392c0 27.6 5.4 75.5 9.4 107.4 4.4 35 34.3 60.6 69 60.6l17.3 0c29.7 0 58.5-19.3 65.3-51.4 2-9.5 4-20.8 5.4-33 9.4 .3 19.3 .5 29.6 .5l56 0c10.3 0 20.2-.1 29.6-.5 1.3 12.2 3.3 23.5 5.4 33 6.8 32.1 35.6 51.4 65.3 51.4l17.3 0c34.7 0 64.6-25.6 69-60.6 4-31.9 9.4-79.8 9.4-107.4l0-119.3c0-16.6-14.4-29.6-31-28.2-64.2 5.3-128.6 7.5-193 7.5-81.1 0-144.8-3.5-188.5-7.1l-4.6-.4zM210 350a42 42 0 1 1 84 0 42 42 0 1 1 -84 0zm210-42a42 42 0 1 1 0 84 42 42 0 1 1 0-84zM40.5 335.5c-15.2 3-29.9-6.8-32.9-22-4.8-24.8-7.5-50.3-7.5-75.5s2.7-50.7 7.5-75.5c3-15.2 17.8-25 32.9-22s25 17.8 22 33c-4.1 21.2-6.5 43-6.5 64.5s2.3 43.3 6.5 64.5c3 15.2-6.8 29.9-22 33zm624-22c-3 15.2-17.8 25-32.9 22s-25-17.8-22-33c4.1-21.2 6.5-42.9 6.5-64.5s-2.3-43.3-6.5-64.5c-3-15.2 6.8-29.9 22-33s29.9 6.8 32.9 22c4.8 24.8 7.5 50.3 7.5 75.5s-2.7 50.7-7.5 75.5z"],
    "quote-left": [504, 560, [8220, "quote-left-alt"], "f10d", "M0 434c0 27.8 4.3 55.2 23.5 74.5S70.2 532 98 532l28 0c27.8 0 55.2-4.3 74.5-23.5S224 461.8 224 434l0-140c0-27.8-4.3-55.2-23.5-74.5S153.8 196 126 196l-28 0c-14 0-27.8 1.1-40.6 4.6 4.1-33.9 17.1-60.4 35.9-79.3 23-23 57.4-37.3 102.7-37.3 15.5 0 28-12.5 28-28s-12.5-28-28-28C138.6 28 89 46.4 53.7 81.7S0 166.6 0 224L0 434zm280 0c0 27.8 4.3 55.2 23.5 74.5S350.2 532 378 532l28 0c27.8 0 55.2-4.3 74.5-23.5S504 461.8 504 434l0-140c0-27.8-4.3-55.2-23.5-74.5S433.8 196 406 196l-28 0c-14 0-27.8 1.1-40.6 4.6 4.1-33.9 17.1-60.4 35.9-79.3 23-23 57.4-37.3 102.7-37.3 15.5 0 28-12.5 28-28s-12.5-28-28-28c-57.4 0-107 18.4-142.3 53.7S280 166.6 280 224l0 210z"],
    "martini-glass": [504, 560, [127864, "glass-martini-alt"], "f57b", "M464.3-22.8c12.6 9 15.5 26.5 6.5 39.1L415.2 94.1c14.8 1.9 27.4 3.9 37.5 5.7 30.9 5.4 51.3 32.4 51.3 61.9 0 15-5.2 30-15.7 41.8-26.6 30.1-113.5 123.8-208.3 174.1l0 126.3 112 0c15.5 0 28 12.5 28 28s-12.5 28-28 28l-280 0c-15.5 0-28-12.5-28-28s12.5-28 28-28l112 0 0-126.3C129.1 327.4 42.3 233.7 15.7 203.5 5.2 191.7 0 176.7 0 161.7 0 132.1 20.4 105.2 51.3 99.8 88.2 93.3 157.8 84 252 84 289 84 322.1 85.4 351 87.6L425.2-16.3c9-12.6 26.5-15.5 39.1-6.5zM57.6 166.4c6.3 7.1 15.6 17.4 27.4 29.6l334 0c11.7-12.2 21.1-22.5 27.4-29.6 3.1-3.5 1.7-10.6-3.3-11.5-34.2-6-100.6-14.9-191.1-14.9S95.2 149 60.9 154.9c-5 .9-6.4 8-3.3 11.5z"],
    "wifi-weak": [336, 560, ["wifi-1"], "f6aa", "M67.3 343.4C90.2 321.5 124 308 168 308s77.8 13.5 100.7 35.3c11.2 10.7 28.9 10.2 39.6-1s10.2-28.9-1-39.6C272.2 269.3 223.7 252 168 252S63.8 269.3 28.7 302.8c-11.2 10.7-11.6 28.4-1 39.6s28.4 11.6 39.6 1zM168 518c42.8 0 70-27.2 70-70s-27.2-70-70-70-70 27.2-70 70 27.2 70 70 70z"],
    "rectangle-wide": [672, 560, [], "f2fc", "M0 280c0 35.6 1.7 65.9 7.2 91.2 5.5 25.6 15.2 47.8 32.5 65.1s39.5 27 65.1 32.5c25.3 5.5 55.7 7.2 91.2 7.2l280 0c35.6 0 65.9-1.7 91.2-7.2 25.6-5.5 47.8-15.2 65.1-32.5s27-39.5 32.5-65.1c9.8-45.4 9.8-137 0-182.4-5.5-25.6-15.2-47.8-32.5-65.1s-39.5-27-65.1-32.5C541.9 85.7 511.6 84 476 84L196 84c-35.6 0-65.9 1.7-91.2 7.2-25.6 5.5-47.8 15.2-65.1 32.5s-27 39.5-32.5 65.1C1.7 214.1 0 244.4 0 280z"],
    "angle-down": [560, 560, [8964], "f107", "M560 201c0 12.5-4.5 24.8-13.1 34.4-13.6 15.2-48.3 53.1-92 93.9-43.3 40.4-97.1 85-148.7 112.3-8.4 4.4-17.5 6.4-26.3 6.4s-17.9-2-26.3-6.4c-51.6-27.2-105.4-71.9-148.7-112.3-43.7-40.7-78.4-78.7-92-93.9-8.6-9.6-13.1-21.9-13.1-34.4 0-35.4 33.7-59.6 66.4-51.7 41.7 10 121.5 25.7 213.6 25.7s172-15.7 213.6-25.7c32.6-7.9 66.4 16.3 66.4 51.7z"],
    "comment-dots": [560, 560, [128172, 62075, "commenting"], "f4ad", "M69.6 61.8C117.5 20.5 188.2 0 280 0S442.5 20.5 490.4 61.8c48.7 41.9 69.6 101.4 69.6 169.2 0 61.8-17.3 116.8-57.6 158-40 40.9-99.2 64.6-176 71.1L219.6 548.7c-8.7 7.3-19.7 11.3-31.1 11.3-26.8 0-48.6-21.7-48.6-48.6 0-9 1.9-17.8 6.2-25.8 3.9-7.4 11-22.2 14.8-38.3-53.4-15.1-94.3-42.1-121.7-80.1-27.4-38.1-39.3-84.9-39.3-136.2 0-67.9 20.9-127.3 69.6-169.2zM280 266a28 28 0 1 0 0-56 28 28 0 1 0 0 56zm126-28a28 28 0 1 0 -56 0 28 28 0 1 0 56 0zM182 266a28 28 0 1 0 0-56 28 28 0 1 0 0 56z"],
    "chart-pie": [560, 560, ["pie-chart"], "f200", "M252 31.2C252 14.9 238.1 2 222 4.6 164 14.2 114.3 38.6 76.5 76.5 26.5 126.4 0 197 0 280S26.5 433.6 76.5 483.5 197 560 280 560c59.7 0 112.9-13.7 156.7-39.9 14.4-8.6 15.5-28.3 3.6-40.1L276.6 316.2c-15.8-15.8-24.6-37.1-24.6-59.4l0-225.6zM479.9 440.3c11.8 11.8 31.5 10.7 40.1-3.6 26.2-43.8 39.9-97 39.9-156.7 0-83-26.5-153.6-76.5-203.5-37.8-37.8-87.6-62.2-145.6-71.8-16.1-2.7-30 10.3-30 26.6l0 225.6c0 7.4 3 14.5 8.2 19.8L479.9 440.3z"],
    "inbox": [504, 560, [], "f01c", "M40.5 110.2C53 61.1 97.5 28 147.4 28l209.3 0c49.9 0 94.3 33.1 106.9 82.2 11.7 46 22 92.3 30.1 139.1 1.9 11.1-5.9 21.5-17.1 22.7-26.9 3-62.9 6.3-99.4 7.5-25.6 .8-50.3 12.8-66.3 34.1-8.1 10.8-15.6 22.4-30.8 22.4l-56 0c-15.2 0-22.7-11.6-30.8-22.4-15.9-21.3-40.7-33.2-66.3-34.1-37.2-1.2-75-4.5-103.6-7.5-8.9-.9-15.2-9.2-13.7-18.1 8.2-48.3 18.8-96.3 30.9-143.7zM17.4 327.7C8.3 326.7 0 333.6 0 342.8l0 .2c0 33.8 1.7 63 7.2 87.4 5.6 24.8 15.4 46.4 32.8 63.1 17.3 16.7 39.4 26 64.8 31.4 25.2 5.3 55.5 7.1 91.1 7.1l112 0c35.6 0 65.9-1.7 91.1-7.1 25.5-5.4 47.6-14.8 64.8-31.4 17.4-16.7 27.2-38.3 32.8-63.1 5.5-24.4 7.2-53.6 7.2-87.4 0-9.6-8.7-16.8-18.3-15.7-1 .1-2 .2-3 .3-27.8 3.1-65.3 6.6-103.8 7.8-9.6 .3-18.1 4.8-23.3 11.7-19 25.3-42 44.8-75.6 44.8l-56 0c-33.6 0-56.6-19.5-75.6-44.8-5.2-6.9-13.7-11.4-23.3-11.7-39.1-1.2-78.4-4.7-107.7-7.8z"],
    "credit-card": [560, 560, [128179, 62083, "credit-card-alt"], "f09d", "M7.6 399.2c5.5 25.6 15.2 47.8 32.5 65.1s39.5 27 65.1 32.5c25.3 5.5 55.7 7.2 91.2 7.2l168 0c35.6 0 65.9-1.7 91.2-7.2 25.6-5.5 47.8-15.2 65.1-32.5s27-39.5 32.5-65.1c9.4-43.4 7.3-88.9 7.5-133.1 0-16.4-14.3-29-30.7-27.3-59.3 6-150.7 13.2-249.6 13.2S90.1 244.8 30.8 238.8c-16.3-1.7-30.7 10.9-30.7 27.3 .1 44.2-1.9 89.6 7.5 133.1zM308.4 336l112 0c15.5 0 28 12.5 28 28s-12.5 28-28 28l-112 0c-15.5 0-28-12.5-28-28s12.5-28 28-28zM520.7 95.7c14.3 14.3 23.6 33.7 29.5 55.7 4.1 15.3-7.2 29.9-23 31.5-58 5.9-148.9 13.2-246.8 13.2S91.6 188.8 33.6 182.8c-15.7-1.6-27.1-16.2-23-31.5 5.9-22 15.2-41.4 29.5-55.7 17.3-17.3 39.5-27 65.1-32.5 25.3-5.5 55.7-7.2 91.2-7.2l168 0c35.6 0 65.9 1.7 91.2 7.2 25.6 5.5 47.8 15.2 65.1 32.5z"],
    "wand-magic-sparkles": [560, 560, ["magic-wand-sparkles"], "e2ca", "M418.1 18.6c11.6-12 27.5-18.6 44.1-18.6 16.3 0 31.9 6.5 43.4 18L542 54.4c11.5 11.5 18 27.1 18 43.4 0 16.6-6.6 32.4-18.6 44.1-10.3 10-27.7 26.9-48.8 47.7-11 10.8-28.6 10.8-39.5-.1l-82.5-82.5c-10.9-10.9-10.9-28.5-.1-39.5 20.8-21.1 37.7-38.5 47.7-48.8zm-87 128.1c-10.9-10.9-28.6-10.9-39.6-.1-22.4 22.2-45 44.3-65.8 64-77.8 73.9-165.9 147.2-200.4 175.4-15.9 13-25.3 32.5-25.3 53.2 0 9.5 2 20 7.5 29.9 5.9 10.7 17.7 29.5 35.7 47.5S80 546.6 90.8 552.5c9.9 5.5 20.4 7.5 29.9 7.5 20.7 0 40.2-9.4 53.2-25.3 28.3-34.5 101.5-122.7 175.4-200.4 19.7-20.8 41.8-43.4 64-65.8 10.9-11 10.9-28.7-.1-39.6l-82.1-82.1zM196 42a42 42 0 1 1 84 0 42 42 0 1 1 -84 0zM420 434a42 42 0 1 1 84 0 42 42 0 1 1 -84 0zM84 56a28 28 0 1 1 0 56 28 28 0 1 1 0-56z"],
    "folders": [616, 560, [], "f660", "M146.1 332c-4.7-20.9-6.1-45.8-6.1-74.4l0-67.2c0-28.6 1.4-53.5 6.1-74.4 4.8-21.3 13.3-40.2 28.7-55 15.3-14.7 34.7-22.7 56.4-27.2 21.4-4.4 47.1-5.8 76.8-5.8 22.2 0 43.5 8.6 59.6 24l28.8 27.6c10.4 10 24.3 15.6 38.8 15.6l12.9 0c29.7 0 55.3 1.4 76.8 5.8 21.7 4.5 41.1 12.5 56.4 27.2 15.4 14.8 23.9 33.7 28.7 55 4.7 20.9 6.1 45.8 6.1 74.4s-1.4 53.5-6.1 74.4c-4.8 21.3-13.3 40.2-28.7 55-15.3 14.7-34.7 22.7-56.4 27.2-21.4 4.4-47.1 5.8-76.8 5.8l-140 0c-29.7 0-55.3-1.4-76.8-5.8-21.7-4.5-41.1-12.5-56.4-27.2-15.4-14.8-23.9-33.7-28.7-55zM84 191.6c0-11-6.5-21-16.5-25.5s-21.8-2.7-30.1 4.6C20.9 185.2 11.7 204.4 6.6 226.2 1.5 247.6 0 273 0 302.4l0 67.2c0 28.6 1.4 53.5 6.1 74.4 4.8 21.3 13.3 40.2 28.7 55 15.3 14.7 34.7 22.7 56.4 27.2 21.4 4.4 47.1 5.8 76.8 5.8l140 0c15.5 0 28-12.5 28-28s-12.5-28-28-28c-30.8 0-61-1.4-88.1-7-27.9-5.8-58.4-17.2-83.8-41.6-25.7-24.7-38.2-54.9-44.6-83.1-6.1-27.1-7.5-56.9-7.5-86.7l0-66z"],
    "star": [616, 560, [11088, 61446], "f005", "M308.2-28c-22.4 0-44.3 11.4-56.1 32.1-13.5 23.6-36.6 67.5-55.1 121.1-.2 .7-.9 1.2-1.7 1.2-56.7 1.1-105.6 9.5-132.2 15-23.3 4.9-40.9 22.1-47.8 43.4s-2.8 45.6 13.2 63.3c18.3 20.1 52.9 55.7 98.1 89.9 .6 .4 .8 1.3 .6 2-16.5 54.2-23.6 103.3-26.6 130.4-2.6 23.7 8.4 45.7 26.5 58.9s42.5 16.8 64.2 7c24.8-11.2 69.3-33.1 115.8-65.6 .6-.4 1.5-.4 2.1 0 46.5 32.4 91 54.4 115.8 65.6 21.7 9.8 46.1 6.2 64.2-7s29.1-35.2 26.5-58.9c-3-27-10.1-76.2-26.6-130.4-.2-.7 .1-1.5 .6-2 45.2-34.2 79.9-69.7 98.1-89.9 16-17.6 20.1-41.9 13.2-63.3s-24.5-38.6-47.8-43.4c-26.6-5.5-75.5-13.9-132.2-15-.7 0-1.4-.5-1.7-1.2-18.5-53.5-41.6-97.5-55.1-121.1-11.8-20.7-33.6-32.1-56.1-32.1z"],
    "flag": [504, 560, [127988, 61725], "f024", "M56 532c0 15.5-12.5 28-28 28S0 547.5 0 532L0 96.4C0 60.4 23.1 27.2 59.6 17.6 89.1 9.8 132.5 0 168 0 202.7 0 235.9 16.6 261.9 29.6 284.6 41 309.8 56 336 56 353 56 374.1 52.9 395.3 48.6 447.9 37.7 504 75.6 504 133.7l0 189.9c0 35.9-23.1 69.1-59.6 78.8-29.5 7.8-73 17.6-108.4 17.6-34.6 0-66.3-15.8-96.5-31-29.6-14.8-51.4-25-71.5-25-6.9 0-14.4 .5-22.3 1.4-17.6 2-33.7-11.1-33.7-28.8L112 168c0-15.5-12.5-28-28-28s-28 12.5-28 28l0 364z"],
    "triangle-exclamation": [560, 560, [9888, "exclamation-triangle", "warning"], "f071", "M280.2 28c-24.6 0-49.6 8.7-68.2 27.6-27.6 28-77.2 84.1-125.8 168.4S13.7 379.3 3.2 417.1c-7.1 25.6-2.1 51.6 10.2 72.9s32.3 38.6 58 45.2c38 9.9 111.4 24.8 208.7 24.8 97.2 0 170.5-14.8 208.6-24.6 25.8-6.7 45.9-24 58.2-45.4 12.3-21.3 17.2-47.3 10.1-72.8-10.5-37.9-34.3-108.9-82.9-193.2S375.9 83.6 348.3 55.6C329.7 36.7 304.7 28 280.2 28zm-42 392a42 42 0 1 1 84 0 42 42 0 1 1 -84 0zm70-238l0 126c0 15.5-12.5 28-28 28s-28-12.5-28-28l0-126c0-15.5 12.5-28 28-28s28 12.5 28 28z"],
    "wifi-fair": [448, 560, ["wifi-2"], "f6ab", "M43.3 260.1C85.6 219.8 146.7 196 224 196s138.4 23.8 180.7 64c11.2 10.7 28.9 10.2 39.6-1s10.2-28.9-1-39.6C388.8 167.6 313 140 224 140S59.2 167.6 4.7 219.5c-11.2 10.7-11.6 28.4-1 39.6s28.4 11.6 39.6 1zm80 83.3C146.2 321.5 180 308 224 308s77.8 13.5 100.7 35.3c11.2 10.7 28.9 10.2 39.6-1s10.2-28.9-1-39.6C328.2 269.3 279.7 252 224 252S119.8 269.3 84.7 302.8c-11.2 10.7-11.6 28.4-1 39.6s28.4 11.6 39.6 1zM224 518a70 70 0 1 0 0-140 70 70 0 1 0 0 140z"],
    "lock": [448, 560, [128274], "f023", "M84.2 140l0 40.9c-16.9 5.9-31.9 14.4-44.3 26.8-17.3 17.3-27 39.5-32.5 65.1-9.8 45.4-9.8 137 0 182.4 5.5 25.6 15.2 47.8 32.5 65.1s39.5 27 65.1 32.5c25.3 5.5 55.7 7.2 91.2 7.2l56 0c35.6 0 65.9-1.7 91.2-7.2 25.6-5.5 47.8-15.2 65.1-32.5s27-39.5 32.5-65.1c9.8-45.4 9.8-137 0-182.4-5.5-25.6-15.2-47.8-32.5-65.1-12.4-12.4-27.4-20.9-44.3-26.8l0-40.9c0-40.3-12.9-75.9-38.5-101.5S264.4 0 224.2 0 148.3 12.9 122.7 38.5 84.2 99.7 84.2 140zm78.1-61.9C175.6 64.8 196 56 224.2 56s48.6 8.8 61.9 22.1 22.1 33.7 22.1 61.9l0 30.1c-17-1.5-35.6-2.1-56-2.1l-56 0c-20.4 0-39 .6-56 2.1l0-30.1c0-28.2 8.8-48.6 22.1-61.9zm89.9 314.5l0 27.4c0 15.5-12.5 28-28 28s-28-12.5-28-28l0-27.4c0-5-2.8-9.5-6.7-12.6-13-10.3-21.3-26.1-21.3-44 0-30.9 25.1-56 56-56s56 25.1 56 56c0 17.8-8.3 33.7-21.3 44-3.9 3.1-6.7 7.6-6.7 12.6z"],
    "anchor": [504, 560, [9875], "f13d", "M181.2 27.2C199.5 8.8 224.6 0 252 0s52.5 8.8 70.8 27.2 27.2 43.4 27.2 70.8-8.8 52.5-27.2 70.8c-11.8 11.8-26.5 19.7-42.8 23.8l0 71.3c15.9-2.2 31.9-5.5 47.2-10.5 14.7-4.9 30.5 3 35.4 17.7s-3 30.5-17.7 35.4c-20.9 6.9-43 11.4-64.9 13.8l0 182.2c49-5 87.9-23.4 115.5-51.1s46-66.5 51.1-115.6c-14.8-.7-26.6-13-26.6-28 0-15.5 12.5-28 28-28l28 0c15.5 0 28 12.5 28 28 0 74.5-23.8 138.1-68.9 183.1S326.5 560 252 560 113.9 536.2 68.9 491.1 0 382.5 0 308c0-15.5 12.5-28 28-28l28 0c15.5 0 28 12.5 28 28 0 15-11.8 27.2-26.6 28 5 49.1 23.4 87.9 51.1 115.6s66.5 46 115.5 51.1l0-182.2c-21.9-2.4-43.9-6.9-64.9-13.8-14.7-4.9-22.6-20.7-17.7-35.4s20.7-22.6 35.4-17.7c15.3 5 31.2 8.3 47.2 10.5l0-71.3c-16.3-4.1-31-12-42.8-23.8-18.3-18.3-27.2-43.4-27.2-70.8s8.8-52.5 27.2-70.8z"],
    "scissors": [560, 560, [9984, 9986, 9988, "cut"], "f0c4", "M31 59c20.7-20.7 49.3-31 81-31s60.3 10.2 81 31 31 49.3 31 81c0 3.1-.1 6.2-.3 9.3L394.1 65c33.7-16.7 72.8-22.3 105.6-11.4 16.8 5.6 32.2 15.6 43.4 30.9 11.2 15.4 16.9 34.4 16.9 55.5 0 10.6-6 20.3-15.5 25L389.7 242.4c-7.9 3.9-17.2 3.9-25 0l-72.2-36.1c-13.8-6.9-30.6-1.3-37.6 12.5s-1.3 30.7 12.5 37.6L544.5 395c9.5 4.7 15.5 14.4 15.5 25 0 21.2-5.6 40.1-16.9 55.5-11.2 15.3-26.6 25.4-43.4 30.9-32.8 10.9-71.9 5.3-105.6-11.4L223.7 410.7c.2 3 .3 6.1 .3 9.3 0 31.7-10.2 60.3-31 81s-49.3 31-81 31c-20.9 0-40.5-4.4-57.5-13.5-35.7-19.1-54.5-55.6-54.5-98.5 0-31.7 10.2-60.3 31-81s49.3-31 81-31c4.7 0 9.4 .2 14 .7l0-57.4c-4.6 .5-9.3 .7-14 .7-20.9 0-40.5-4.4-57.5-13.5-35.7-19.1-54.5-55.6-54.5-98.5 0-31.7 10.2-60.3 31-81zM70.5 98.5c-8.4 8.4-14.5 21.8-14.5 41.5 0 25.9 10.5 41.4 24.9 49.1 7.8 4.2 18 6.9 31.1 6.9 19.6 0 33-6.1 41.5-14.5S168 159.6 168 140 161.9 107 153.5 98.5 131.6 84 112 84 79 90.1 70.5 98.5zM56 420c0 25.9 10.5 41.4 24.9 49.1 7.8 4.2 18 6.9 31.1 6.9 19.6 0 33-6.1 41.5-14.5S168 439.6 168 420c0-26.3-10.8-42-25.9-49.6-7.6-3.9-17.6-6.4-30.1-6.4-19.6 0-33 6.1-41.5 14.5S56 400.4 56 420z"],
    "bug": [504, 560, [], "f188", "M84 84c0-15.5-12.5-28-28-28S28 68.5 28 84l0 94c0 39 23 74.4 58.6 90.2 14.1 6.3 30.7-.1 37-14.2s-.1-30.7-14.2-37C93.9 210.2 84 194.9 84 178l0-94zM.5 470.5c-3 15.2 6.8 29.9 22 32.9s29.9-6.8 32.9-22l19.5-97.4c3.8-19.1 17-33.4 34.4-41.2 14.1-6.3 20.5-22.8 14.2-37s-22.8-20.5-37-14.2C52.7 306.8 27.4 336.4 20 373.1L.5 470.5zM420 84c0-15.5 12.5-28 28-28s28 12.5 28 28l0 94c0 39-23 74.4-58.6 90.2-14.1 6.3-30.7-.1-37-14.2s.1-30.7 14.2-37c15.4-6.9 25.4-22.2 25.4-39l0-94zm83.5 386.5c3 15.2-6.8 29.9-22 32.9s-29.9-6.8-32.9-22l-19.5-97.4c-3.8-19.1-17-33.4-34.4-41.2-14.1-6.3-20.5-22.8-14.2-37s22.8-20.5 37-14.2c33.9 15.1 59.3 44.6 66.6 81.4l19.5 97.4zM191.3 12.5c-8.6-12.9-26-16.3-38.8-7.8s-16.3 26-7.8 38.8l17.2 25.8c-14.7 19.5-21.9 44-21.9 70.7 0 29.9 9.6 59.8 31.1 81.2-11.4 16.5-17.1 36.8-17.1 58.8 0 20.5 5 39.6 14.9 55.4-29.3 24-42.9 61.4-42.9 98.6 0 36 11.6 68.1 34.7 91.3S216 560 252 560 320.1 548.4 343.3 525.3 378 470 378 434c0-37.2-13.6-74.6-42.9-98.6 9.9-15.8 14.9-34.9 14.9-55.4 0-22-5.7-42.3-17.1-58.8 21.5-21.4 31.1-51.3 31.1-81.2 0-26.7-7.2-51.2-21.9-70.7l17.2-25.8c8.6-12.9 5.1-30.3-7.8-38.8s-30.3-5.1-38.8 7.8L297.1 35.9C283.3 30.6 268 28 252 28s-31.3 2.6-45.1 7.9L191.3 12.5z"],
    "arrow-right-from-bracket": [560, 560, ["sign-out"], "f08b", "M252 504c0-15.5-12.5-28-28-28-34.4 0-60.1-1.8-79.4-5.9-19-4.1-30.1-10.1-37.3-17.4S94 434.4 89.9 415.4c-4.2-19.3-5.9-45-5.9-79.4l0-112c0-34.4 1.8-60.1 5.9-79.4 4.1-19 10.1-30.1 17.4-37.3S125.6 94 144.6 89.9c19.3-4.2 45-5.9 79.4-5.9 15.5 0 28-12.5 28-28s-12.5-28-28-28c-35.6 0-65.9 1.7-91.2 7.2-25.6 5.5-47.8 15.2-65.1 32.5s-27 39.5-32.5 65.1C29.7 158.1 28 188.4 28 224l0 112c0 35.6 1.7 65.9 7.2 91.2 5.5 25.6 15.2 47.8 32.5 65.1s39.5 27 65.1 32.5c25.3 5.5 55.7 7.2 91.2 7.2 15.5 0 28-12.5 28-28zM432.6 111c-9.8-8.7-22.2-13-34.6-13-24.3 0-46.6 16.8-51.1 42.5-3.8 22-9.1 60.3-10.6 111.5L196 252c-15.5 0-28 12.5-28 28s12.5 28 28 28l140.4 0c1.5 51.2 6.7 89.6 10.6 111.5 4.5 25.7 26.8 42.5 51.1 42.5 12.4 0 24.7-4.3 34.6-13 20.8-18.5 86.9-79.7 122-147 3.7-7.1 5.4-14.7 5.4-22.1s-1.7-15-5.4-22.1c-35.1-67.3-101.2-128.5-122-147z"],
    "sidebar-flip": [560, 560, [], "e24f", "M270.4 66c-5.3-6.3-13.2-10-21.4-10l-53 0c-35.6 0-65.9 1.7-91.2 7.2-25.6 5.5-47.8 15.2-65.1 32.5s-27 39.5-32.5 65.1C1.7 186.1 0 216.4 0 252l0 56c0 35.6 1.7 65.9 7.2 91.2 5.5 25.6 15.2 47.8 32.5 65.1s39.5 27 65.1 32.5c25.3 5.5 55.7 7.2 91.2 7.2l53 0c8.3 0 16.1-3.6 21.4-10s7.6-14.7 6.2-22.8C271.3 440.7 266 384.8 266 280s5.3-160.7 10.6-191.2c1.4-8.1-.9-16.5-6.2-22.8zM560 308c0 34.1-1.6 63.3-6.5 87.9-4.9 24.7-13.6 46.5-29 63.9-30.9 34.9-80.5 42.8-142.6 44-22 .4-44.9-13.4-49.7-39.5-4.6-24.9-10.2-77.1-10.2-184.3s5.6-159.4 10.2-184.3c4.8-26.1 27.7-39.9 49.7-39.5 62.1 1.2 111.7 9.1 142.6 44 15.4 17.4 24 39.2 29 63.9 4.9 24.6 6.5 53.8 6.5 87.9l0 56z"],
    "arrow-right-arrow-left": [560, 560, [8644, "exchange"], "f0ec", "M457.4 298.7c-10.7 6.8-22.5 9.3-33.1 9.3-20.1 0-45.2-10.7-51.8-38.5-3.6-14.8-6.9-37.7-8-73.5L28 196c-15.5 0-28-12.5-28-28s12.5-28 28-28l336.4 0c1.1-35.8 4.4-58.7 8-73.5 6.7-27.8 31.7-38.5 51.8-38.5 10.6 0 22.4 2.5 33.1 9.3 19.9 12.7 64.8 46.3 97.3 108.7 3.6 7 5.4 14.6 5.4 22.1s-1.7 15.1-5.4 22.1c-32.5 62.4-77.3 96-97.3 108.7zm-354.8 224c10.7 6.8 22.5 9.3 33.1 9.3 20.1 0 45.2-10.7 51.8-38.5 3.6-14.8 6.9-37.7 8-73.5L532 420c15.5 0 28-12.5 28-28s-12.5-28-28-28l-336.4 0c-1.1-35.8-4.5-58.7-8-73.5-6.7-27.8-31.7-38.5-51.8-38.5-10.6 0-22.4 2.5-33.1 9.3-19.9 12.7-64.8 46.3-97.3 108.7-3.6 7-5.4 14.6-5.4 22.1s1.7 15.1 5.4 22.1c32.5 62.4 77.3 96 97.3 108.7z"],
    "arrow-up-from-line": [448, 560, [8613, "arrow-from-bottom"], "f342", "M18.1 506C3.8 511.8-3.3 528.1 2.5 542.4S24.6 563.7 38.9 558c57.9-22.1 124.6-26 185.6-26s127.7 3.9 185.6 26c14.3 5.8 30.6-1.2 36.4-15.5s-1.3-30.7-15.6-36.5c-64-25.5-138.7-30-206.4-30S82.2 480.5 18.1 506zM405.7 162c0-12.4-4.3-24.8-13-34.6-18.5-20.9-79.7-86.9-146.9-122-7.1-3.7-14.7-5.4-22.1-5.4s-15 1.7-22.1 5.4c-67.3 35.2-128.5 101.2-147 122-8.7 9.8-13 22.2-13 34.5 0 24.3 16.8 46.7 42.5 51.1 22.1 3.8 60.8 9.1 112.3 10.6l0 140.4c0 15.5 12.5 28 28 28s28-12.5 28-28l0-140.4c51-1.5 89-6.7 110.8-10.5 25.6-4.5 42.4-26.9 42.4-51.1z"],
    "font": [504, 560, [], "f031", "M220.7 294l62.7 0-31.3-83.6-31.3 83.6zM0 336c0 35.6 1.7 65.9 7.2 91.2 5.5 25.6 15.2 47.8 32.5 65.1s39.5 27 65.1 32.5c25.3 5.5 55.7 7.2 91.2 7.2l112 0c35.6 0 65.9-1.7 91.2-7.2 25.6-5.5 47.8-15.2 65.1-32.5s27-39.5 32.5-65.1c5.5-25.3 7.2-55.7 7.2-91.2l0-112c0-35.6-1.7-65.9-7.2-91.2-5.5-25.6-15.2-47.8-32.5-65.1s-39.5-27-65.1-32.5C373.9 29.7 343.6 28 308 28L196 28c-35.6 0-65.9 1.7-91.2 7.2-25.6 5.5-47.8 15.2-65.1 32.5s-27 39.5-32.5 65.1C1.7 158.1 0 188.4 0 224L0 336zm199.7 14l-6.2 16.5c9.7 4.4 16.5 14.2 16.5 25.5 0 15.5-12.5 28-28 28l-56 0c-15.5 0-28-12.5-28-28s12.5-28 28-28l8.6 0 72.3-192.7c7.1-18.8 25-31.3 45.1-31.3s38.1 12.5 45.1 31.3l72.3 192.7 8.6 0c15.5 0 28 12.5 28 28s-12.5 28-28 28l-56 0c-15.5 0-28-12.5-28-28 0-11.4 6.8-21.2 16.5-25.5l-6.2-16.5-104.7 0z"],
    "language": [616, 560, [], "f1ab", "M168 28c15.5 0 28 12.5 28 28l0 41.3c36.9-1.8 71.2-6.7 90.7-9.9 24.9-4.1 50.5 15.1 48.8 43.5-5.2 84.2-44.9 151.2-104 196.3 29 6.9 58.3 8.8 87.9 8.8 13.6-38.7 30.6-79.9 50.6-111.3 9.2-14.4 19.7-27.9 31.8-38.1s27.7-18.6 46.2-18.6 34.1 8.4 46.2 18.6 22.6 23.7 31.8 38.1c18.4 28.8 34.3 66.1 47.2 101.8 17 46.8 31.1 94.9 42.1 143.4 3.4 15.1-6.1 30.1-21.2 33.5s-30.1-6.1-33.5-21.2c-6.9-30.4-15.3-60.4-24.6-90.1L448 392c-15.5 0-28-12.5-28-28s12.5-28 28-28l69 0c-11.6-30.8-24.6-59.7-38.3-81.2-7.6-11.9-14.6-20.2-20.7-25.4-7.8-6.6-12.4-6.6-20.2 0-6.1 5.1-13.1 13.5-20.7 25.4-15.1 23.7-29.4 56.4-41.8 90.7-16.1 44.5-29.5 90.3-40.1 136.5-3.4 15.1-18.4 24.7-33.5 21.3s-24.5-18.6-21.1-33.7c6-26.1 13-52 20.6-77.6-46.4-.8-93.1-10-135.1-27.1-42 17.8-89.1 27.2-138.2 27.2-15.5 0-28-12.5-28-28s12.5-28 28-28c25.1 0 49.1-2.8 71.7-8-37.8-27.8-67.3-64.2-82.7-108.8-5-14.6 2.7-30.6 17.3-35.6s30.6 2.7 35.6 17.3c14.8 43 49.7 78.5 96 102.3 60.3-32.6 101.9-87.7 111.8-157.8-27.7 4-68.6 8.6-109.7 8.6-48.5 0-97.8-5.1-145.5-14.5-15.2-3-25-17.8-22-32.9s17.8-25 33-22c35 6.9 70.9 11 106.5 12.7L140 56c0-15.5 12.5-28 28-28z"],
    "shield-halved": [504, 560, ["shield-alt"], "f3ed", "M224 37.7c0-17.5-15.9-30.7-32.9-26.6-41.2 10-99.5 28.4-154.3 61.6-24.3 14.8-36.9 41.1-36.9 67.3 0 148.9 42.5 247.6 93.5 311.8 31.4 39.6 65.5 65.3 93.3 81.7 17.1 10 37.2-3.3 37.2-23.1l0-472.7zm56 472.7c0 19.9 20.1 33.2 37.2 23.1 27.8-16.3 61.9-42 93.3-81.7 51-64.2 93.5-162.9 93.5-311.8 0-26.2-12.5-52.6-36.9-67.3-54.8-33.2-113.1-51.6-154.3-61.6-17-4.1-32.9 9.1-32.9 26.6l0 472.7z"],
    "person-biking": [560, 560, [128692, "biking"], "f84a", "M308 42a42 42 0 1 1 84 0 42 42 0 1 1 -84 0zM293 185.6c25.5 40.9 70.8 66.4 119.1 66.4l7.9 0c15.5 0 28-12.5 28-28s-12.5-28-28-28l-7.9 0c-29 0-55.9-14.9-71.2-39.5l-29-46.4c-10.2-16.3-28-26.1-47.2-26.1-16.2 0-31.7 7.1-42.2 19.4L154 183.3c-9.1 10.6-14 24-14 37.9 0 20.1 10.4 38.8 27.4 49.4l45.1 28.2c24.6 15.3 39.5 42.3 39.5 71.2l0 49.9c0 15.5 12.5 28 28 28s28-12.5 28-28l0-49.9c0-48.3-24.9-93.1-65.8-118.7l-3.7-2.3 54.4-63.5zM31 339c20.7-20.7 49.3-31 81-31s60.3 10.2 81 31 31 49.4 31 81-10.2 60.3-31 81-49.3 31-81 31-60.3-10.2-81-31-31-49.4-31-81 10.2-60.3 31-81zm336 0c20.7-20.7 49.4-31 81-31s60.3 10.2 81 31 31 49.4 31 81-10.2 60.3-31 81-49.4 31-81 31-60.3-10.2-81-31-31-49.4-31-81 10.2-60.3 31-81z"],
    "globe": [560, 560, [127760], "f0ac", "M290 15.9c-5-6.4-14.5-6.4-19.6 0-19.2 24.2-35.6 56.3-48.2 94.1-15.6 46.7-24.6 100.3-26.1 154.8-.2 7.5 5.8 13.7 13.3 14 22 .7 45.7 1.1 71.1 1.1 25.1 0 48.6-.4 70.5-1.1 7.5-.2 13.5-6.5 13.3-14-1.4-54.5-10.5-108.2-26.1-154.9-12.6-37.8-29.1-69.9-48.2-94.1zM176.4 16c11.7-3.9 21.3 9.1 15.8 20.2-8.8 17.7-16.5 36.6-23 56.2-17.1 51.4-27 109.5-28.8 168-.3 8.1-7.1 14.4-15.2 13.8-28.9-2.3-53.4-5.1-73.5-7.9-15.3-2.1-28.2-4.2-38.5-6.1-6.9-1.3-11.7-7.5-11-14.4 6.4-68.2 32-126.4 74.9-169.3 27.4-27.4 61-47.7 99.4-60.5zM143.1 343.6c-.7-6.9-6.2-12.4-13.1-12.9-34.1-2.6-62.7-5.8-86.1-9-8.5-1.2-16.4-2.4-23.5-3.5-9.2-1.5-17.4 6.1-16 15.3 9.1 59.9 33.7 111.3 72.5 150.1 27.4 27.4 61 47.7 99.4 60.5 11.7 3.9 21.3-9.1 15.8-20.2-8.8-17.7-16.5-36.6-23-56.2-12.8-38.5-21.6-80.7-25.9-124.1zM270.4 544.1c5 6.4 14.5 6.4 19.6 0 19.2-24.2 35.6-56.3 48.2-94.1 10.2-30.7 17.7-64.5 22-99.5 1-8.4-5.8-15.6-14.2-15.3-20.5 .6-42.3 .9-65.5 .9-23.4 0-45.4-.3-66-1-8.5-.2-15.3 6.9-14.2 15.3 4.3 35 11.7 68.8 22 99.6 12.6 37.8 29.1 69.9 48.2 94.1zM391.4 92.3c-6.6-19.7-14.3-38.6-23.1-56.4-5.5-11 4-24 15.7-20.2 38.7 12.8 72.6 33.2 100.1 60.7 42.9 42.9 68.5 101.1 74.9 169.3 .6 6.9-4.2 13.2-11 14.4-10.3 1.9-23.2 4-38.5 6.1-20.2 2.8-44.9 5.6-74.1 7.9-8.1 .6-14.9-5.7-15.2-13.8-1.8-58.5-11.7-116.6-28.8-168.1zm0 375.3c-6.6 19.7-14.3 38.7-23.1 56.4-5.5 11 4 24 15.7 20.2 38.7-12.8 72.6-33.2 100.1-60.7 38.8-38.8 63.5-90.1 72.5-150.1 1.4-9.2-6.8-16.7-16-15.3-7.1 1.2-15 2.3-23.5 3.5-23.5 3.2-52.3 6.5-86.6 9-6.9 .5-12.4 6-13.1 12.9-4.4 43.3-13.1 85.5-25.9 124z"],
    "arrow-left": [560, 560, [8592], "f060", "M181.5 516.3c11.8 10.5 26.8 15.7 41.8 15.7 29.6 0 56.5-20.4 61.9-51.3 3.9-22.4 8.9-56.8 12.2-101.4 .7-9.3 8.7-15.3 16.6-14.3l167.3 20.9c41.8 5.2 78.7-27.4 78.7-69.5l0-72.8c0-42.1-36.9-74.7-78.7-69.5L314 195c-7.9 1-15.9-5.1-16.6-14.3-3.3-44.6-8.3-79-12.2-101.4-5.4-30.9-32.4-51.3-61.9-51.3-15 0-30 5.2-41.8 15.7-30.3 26.8-125 114.5-175.1 210.1-4.4 8.3-6.4 17.4-6.4 26.2s2 17.9 6.4 26.2c50.1 95.6 144.8 183.3 175.1 210.1z"],
    "paw": [616, 560, [], "f1b0", "M149.4 23.4C165.3 7.5 186.9 0 210 0s44.7 7.5 60.6 23.4 23.4 37.5 23.4 60.6-7.5 44.7-23.4 60.6-37.5 23.4-60.6 23.4-44.7-7.5-60.6-23.4-23.4-37.5-23.4-60.6 7.5-44.7 23.4-60.6zM308 224c-57.7 0-104.9 26.8-127 75.6-6.3 14-17.2 27.4-30.6 39.6-25.6 23.3-38.5 56.9-38.5 94.8 0 36 11.6 68.1 34.7 91.3S202 560 238 560c9.6 0 18.9-.8 27.9-2.5 26-4.8 58.2-4.8 84.2 0 9 1.7 18.3 2.5 27.9 2.5 36 0 68.1-11.6 91.3-34.7S504 470 504 434c0-37.9-12.9-71.5-38.5-94.8-13.4-12.2-24.2-25.6-30.6-39.6-22.1-48.8-69.2-75.6-127-75.6zM345.4 23.4C361.3 7.5 382.9 0 406 0s44.7 7.5 60.6 23.4 23.4 37.5 23.4 60.6-7.5 44.7-23.4 60.6-37.5 23.4-60.6 23.4-44.7-7.5-60.6-23.4-23.4-37.5-23.4-60.6 7.5-44.7 23.4-60.6zm126 154C487.3 161.5 508.9 154 532 154s44.7 7.5 60.6 23.4 23.4 37.5 23.4 60.6-7.5 44.7-23.4 60.6-37.5 23.4-60.6 23.4-44.7-7.5-60.6-23.4-23.4-37.5-23.4-60.6 7.5-44.7 23.4-60.6zm-448 0C39.3 161.5 60.9 154 84 154s44.7 7.5 60.6 23.4 23.4 37.5 23.4 60.6-7.5 44.7-23.4 60.6-37.5 23.4-60.6 23.4-44.7-7.5-60.6-23.4-23.4-37.5-23.4-60.6 7.5-44.7 23.4-60.6z"],
    "bed": [560, 560, [128716], "f236", "M133.2 33c17.8-3.8 38.9-5 62.8-5l168 0c23.9 0 44.9 1.2 62.8 5 18.2 3.9 34.8 11 48 24.2s20.3 29.9 24.2 48c3.8 17.8 5 38.9 5 62.8l0 13.7c0 8.2-3.6 15.9-9.8 21.3s-14.4 7.7-22.5 6.4c-8.3-1.3-17.2-2.5-26.6-3.7-14.2-1.8-25.1-13.8-25.1-28.1l0-9.5c0-15.5-12.5-28-28-28l-56.1 0c-15.4 0-27.9 12.7-27.9 28.1 0 15.4-12.6 27.9-28 27.9s-28-12.6-28-27.9c0-15.4-12.5-28.1-27.9-28.1L168 140c-15.5 0-28 12.5-28 28l0 9.5c0 14.4-10.9 26.3-25.1 28.1-9.5 1.2-18.3 2.4-26.6 3.7-8.1 1.2-16.3-1.1-22.5-6.4S56 189.9 56 181.7L56 168c0-23.9 1.2-44.9 5-62.8 3.9-18.2 11-34.8 24.2-48s29.9-20.3 48-24.2zM504 448l0 28c0 15.5 12.5 28 28 28s28-12.5 28-28l0-107.5c0-47.9-31.4-92.7-82.2-101.5-43.5-7.5-109.4-15.1-197.8-15.1s-154.3 7.6-197.8 15.1C31.4 275.8 0 320.6 0 368.5L0 476c0 15.5 12.5 28 28 28s28-12.5 28-28l0-28 448 0z"],
    "landmark": [560, 560, [127963], "f66f", "M254.1 6.1C262.2 2.1 271.1 0 280 0s17.8 2.1 25.9 6.1c90.1 45.6 191.3 107.2 227.2 129.5 16.9 10.5 26.9 28.9 26.9 48.5 0 28.8-21.5 53.6-50.9 56.5-41.5 4.1-128 11.3-229.1 11.3S92.3 244.8 50.9 240.7c-29.4-2.9-50.9-27.7-50.9-56.5 0-19.6 10-38 26.9-48.5 36-22.3 137.1-84 227.2-129.5zM84 329l0 142.7c-18.1-.8-36.2-1.6-54.4-2.6-15.4-.9-28.7 10.9-29.6 26.3S10.9 524 26.4 525c84.4 4.8 169.1 7 253.6 7s169.2-2.2 253.6-7c15.4-.9 27.2-14.2 26.3-29.6s-14.2-27.2-29.6-26.3c-18.1 1-36.2 1.9-54.4 2.6L476 329c0-15.5-12.5-28-28-28s-28 12.5-28 28l0 144.7c-17.4 .5-36.2 1-56 1.4L364 336c0-15.5-12.5-28-28-28s-28 12.5-28 28l0 139.9c-18.4 .1-37.6 .1-56 0L252 336c0-15.5-12.5-28-28-28s-28 12.5-28 28l0 139.1c-19.8-.4-38.6-.9-56-1.4L140 329c0-15.5-12.5-28-28-28s-28 12.5-28 28z"],
    "music": [560, 560, [127925], "f001", "M560 56c0-30.9-25.1-56-56-56-99.3 3.5-202.9 21.7-298 51.2-23.6 7.3-38 29.1-38 52.2l0 243.7c-16.7-7.5-35.8-11.1-56-11.1-30.4 0-58.3 8.1-79.2 25.4-21.4 17.8-32.8 43.5-32.8 72.6s11.4 54.7 32.8 72.6C53.7 523.9 81.6 532 112 532s58.3-8.1 79.2-25.4C212.6 488.7 224 463.1 224 434l0-217.8c38.3-11.8 135.6-37.7 280-48.2l0 123c-16.7-7.5-35.8-11.1-56-11.1-30.4 0-58.3 8.1-79.2 25.4-21.4 17.8-32.8 43.5-32.8 72.6s11.4 54.7 32.8 72.6C389.7 467.9 417.6 476 448 476s58.3-8.1 79.2-25.4C548.6 432.7 560 407.1 560 378l0-322z"],
    "files": [504, 560, [], "e178", "M300-28c4.4 0 8 3.6 8 8l0 160c0 30.9 25.1 56 56 56l126 0c7.7 0 14 6.3 14 14l0 70c0 29.7-1.4 55.3-5.7 76.7-4.4 21.6-12.2 41-26.7 56.3-14.6 15.4-33.3 24-54.3 28.9-20.7 4.7-45.2 6.2-73.3 6.2l-44 0c-28.1 0-52.6-1.4-73.3-6.2-21.1-4.8-39.8-13.4-54.3-28.9-14.4-15.3-22.3-34.7-26.7-56.3-4.4-21.4-5.7-47-5.7-76.7l0-140c0-29.7 1.4-55.3 5.7-76.7 4.4-21.6 12.2-41 26.7-56.3 14.6-15.4 33.3-24 54.3-28.9 20.7-4.7 45.2-6.2 73.3-6.2zm82.2 16.6c-8-6-18.2 .7-18.2 10.6L364 126c0 7.7 6.3 14 14 14l108.1 0c8.7 0 15.3-7.9 12.2-16-3.6-9.3-8.9-18-15.7-25.6L394.6 0c-3.8-4.2-7.9-8-12.4-11.3zM67.3 137.5C77.5 141.9 84 152 84 163.1L84 280c0 30.7 1.3 60.8 6.8 87.8 5.6 27.7 16.8 58.1 40.8 83.5 24.4 25.9 54.5 38.6 82.6 45 26.9 6.2 56.5 7.6 85.8 7.6l12.8 0c11 0 20.9 6.4 25.5 16.4s2.8 21.7-4.4 30c-14.4 16.5-33.3 25.8-54.9 31-21.1 5.1-46.2 6.6-75 6.6l-44 0c-28.1 0-52.6-1.4-73.3-6.2-21.1-4.8-39.8-13.4-54.3-28.9-14.4-15.3-22.3-34.7-26.7-56.3-4.4-21.4-5.7-47-5.7-76.7L0 280c0-31.2 1.5-58 6.5-80.2 5.1-22.6 14.1-42.4 30.7-57.5 8.2-7.5 20-9.4 30.2-4.9z"],
    "plus": [560, 560, [10133, 61543, "add"], "2b", "M279.4 0c-19.3 0-40.3 0-57.6 6.3-9.7 3.5-18.7 9.1-26.3 17.6-7.3 8.3-12.2 18.1-15.7 28.6-6.6 20.2-9.2 47.5-10.6 82.7-.4 10.2-.7 21.3-.8 33.3-10.9 .2-21 .4-30.3 .8-35 1.3-62.3 4-82.8 10.5-22.4 7.1-39 19.8-47.7 41-7.3 17.8-7.7 39.1-7.7 59.2s.4 41.4 7.7 59.2c8.7 21.2 25.3 33.9 47.7 41 20.5 6.5 47.9 9.2 82.8 10.5 9.3 .4 19.4 .6 30.3 .8 .2 12.1 .5 23.2 .8 33.3 1.3 35.2 4 62.5 10.6 82.7 3.4 10.5 8.3 20.3 15.7 28.6 7.6 8.5 16.6 14.1 26.3 17.6 17.2 6.3 38.2 6.3 57.6 6.3l1.1 0c19.3 0 40.3 0 57.6-6.3 9.7-3.5 18.7-9.1 26.3-17.6 7.3-8.3 12.2-18.1 15.7-28.6 6.6-20.2 9.2-47.5 10.6-82.7 .4-10.2 .6-21.3 .8-33.3 10.9-.2 21-.4 30.3-.8 35-1.3 62.3-4 82.8-10.5 22.4-7.1 39-19.8 47.7-41 7.3-17.8 7.7-39.1 7.7-59.2s-.4-41.4-7.7-59.2c-8.7-21.2-25.3-33.9-47.7-41-20.5-6.5-47.9-9.2-82.8-10.5-9.3-.4-19.4-.6-30.3-.8-.2-12.1-.5-23.2-.8-33.3-1.3-35.2-4-62.5-10.6-82.7-3.4-10.5-8.3-20.3-15.7-28.6-7.6-8.5-16.6-14.1-26.3-17.6-17.2-6.3-38.2-6.3-57.6-6.3l-1.1 0z"],
    "box": [504, 560, [128230], "f466", "M224 57.5c0-15.9-13.2-28.6-29-27.4-19.9 1.5-37.1 3.5-50.9 5.5-33 4.8-59.4 26-74.3 53.3L13.7 191.8c-5.5 10.1 2.2 21.5 13.7 22.3 13.2 .9 28.2 1.9 44.4 3 38 2.4 82.1 4.7 123.8 6 15.6 .5 28.5-12.1 28.5-27.8l0-137.7zM0 298.4c0-16.3 13.8-29.1 30.1-28 11.6 .8 24.5 1.7 38.2 2.5 56.1 3.5 126.8 7.1 183.7 7.1s127.6-3.5 183.7-7.1c13.7-.9 26.5-1.7 38.2-2.5 16.2-1.1 30.1 11.7 30.1 28l0 37.6c0 35.6-1.7 65.9-7.2 91.2-5.5 25.6-15.2 47.8-32.5 65.1s-39.5 27-65.1 32.5c-25.3 5.5-55.7 7.2-91.2 7.2l-112 0c-35.6 0-65.9-1.7-91.2-7.2-25.6-5.5-47.8-15.2-65.1-32.5s-27-39.5-32.5-65.1C1.7 401.9 0 371.6 0 336l0-37.6zm476.6-84.3c11.5-.8 19.2-12.2 13.7-22.3L434.2 88.9c-14.9-27.3-41.3-48.4-74.3-53.3-13.8-2-31-4.1-50.9-5.5-15.8-1.2-29 11.6-29 27.4l0 137.7c0 15.7 12.8 28.3 28.5 27.8 41.7-1.3 85.8-3.6 123.8-6 16.2-1 31.2-2 44.4-3z"],
    "arrow-rotate-right": [560, 560, [8635, "arrow-right-rotate", "arrow-rotate-forward", "redo"], "f01e", "M84 280c0-62.4 19.7-110.8 52.5-143.5S217.6 84 280 84c45.8 0 84 10.6 113.9 29.1-22.9 25-41.5 50.6-49.1 61.4-5.9 8.4-8.8 18.2-8.8 28 0 27.3 22.1 49.5 49.5 49.5L504 252c30.9 0 56-25.1 56-56l0-118.5c0-27.3-22.1-49.5-49.5-49.5-9.8 0-19.6 2.9-28 8.8-8.8 6.2-27.2 19.6-47.2 36.6-42-29.9-95.1-45.4-155.3-45.4-74.5 0-138.1 23.8-183.1 68.9S28 205.5 28 280 51.8 418.1 96.9 463.1 205.5 532 280 532c103.2 0 184.7-45.9 225-127.6 6.8-13.9 1.1-30.7-12.7-37.5s-30.7-1.1-37.5 12.7c-29.3 59.5-89.2 96.4-174.8 96.4-62.4 0-110.8-19.7-143.5-52.5S84 342.4 84 280z"],
    "signal-bars-slash": [616, 560, ["signal-alt-slash"], "f694", "M75.8 8.2C64.9-2.7 47.1-2.7 36.2 8.2s-10.9 28.7 0 39.6l504 504c10.9 10.9 28.7 10.9 39.6 0s10.9-28.7 0-39.6l-9.2-9.2c25.9-5 45.4-27.7 45.4-55l0-336c0-30.9-25.1-56-56-56s-56 25.1-56 56l0 324.4-56-56 0-212.4c0-15.5-12.5-28-28-28l-28 0c-30.9 0-56 25.1-56 56L336 268.4 75.8 8.2zM0 364c0-30.9 25.1-56 56-56l28 0c15.5 0 28 12.5 28 28l0 140c0 15.5-12.5 28-28 28l-28 0c-30.9 0-56-25.1-56-56l0-84zm280 18.4l0 93.6c0 15.5-12.5 28-28 28l-56 0c-15.5 0-28-12.5-28-28l0-166.5c0-18.7 22.6-28.1 35.8-14.8l67.9 67.9c5.3 5.3 8.2 12.4 8.2 19.8z"],
    "door-closed": [560, 560, [128682], "f52a", "M252 0c-35.6 0-65.9 1.7-91.2 7.2-25.6 5.5-47.8 15.2-65.1 32.5s-27 39.5-32.5 65.1C57.7 130.1 56 160.4 56 196l0 215.4c0 14.5 11.1 26.6 25.5 27.9 7.8 .7 15.8 1.3 23.9 2 42.9 3.4 103.7 6.7 174.6 6.7s131.7-3.4 174.6-6.7c8.1-.6 16.1-1.3 23.9-2 14.5-1.3 25.5-13.4 25.5-27.9L504 196c0-35.6-1.7-65.9-7.2-91.2-5.5-25.6-15.2-47.8-32.5-65.1s-39.5-27-65.1-32.5C373.9 1.7 343.6 0 308 0L252 0zM378 224a42 42 0 1 1 0 84 42 42 0 1 1 0-84zM.2 514.3c2-15.3 16.1-26.1 31.5-24.1 82 10.8 165.7 13.8 248.3 13.8s166.3-2.9 248.3-13.8c15.3-2 29.4 8.7 31.4 24.1s-8.7 29.4-24.1 31.5C451.2 556.9 365.1 560 280 560s-171.2-3.1-255.7-14.2C9 543.7-1.8 529.6 .2 514.3z"],
    "arrow-down-wide-short": [616, 560, ["sort-amount-asc", "sort-amount-down"], "f160", "M302 372.1c5.3-9.3 7.6-19.3 7.6-28.8 0-23.5-14.5-48.1-42.2-54-17.3-3.7-44.4-7.6-84.6-8.8l0-196.4c0-15.5-12.5-28-28-28s-28 12.5-28 28l0 196.4c-40.3 1.3-67.3 5.1-84.6 8.8-27.7 5.9-42.2 30.6-42.2 54 0 9.5 2.2 19.6 7.6 28.8 12.4 21.5 55.1 89.5 123.4 126 7.7 4.1 15.9 5.9 23.8 5.9s16.1-1.8 23.8-5.9c68.3-36.5 111-104.5 123.4-126zM364 84c-15.5 0-28 12.5-28 28s12.5 28 28 28l224 0c15.5 0 28-12.5 28-28s-12.5-28-28-28L364 84zM336 448c0-15.5 12.5-28 28-28l112 0c15.5 0 28 12.5 28 28s-12.5 28-28 28l-112 0c-15.5 0-28-12.5-28-28zm28-196c-15.5 0-28 12.5-28 28s12.5 28 28 28l168 0c15.5 0 28-12.5 28-28s-12.5-28-28-28l-168 0z"],
    "compress": [560, 560, [], "f066", "M47.8 8.2C36.9-2.7 19.1-2.7 8.2 8.2s-10.9 28.7 0 39.6L80 119.6c-20.2 22.8-36.3 45-43.2 54.9-5.9 8.4-8.8 18.2-8.8 28 0 27.3 22.1 49.5 49.5 49.5L196 252c30.9 0 56-25.1 56-56l0-118.5c0-27.3-22.1-49.5-49.5-49.5-9.8 0-19.6 2.9-28 8.8-9.9 7-32.1 23.1-54.9 43.2L47.8 8.2zM8.2 551.8c-10.9-10.9-10.9-28.7 0-39.6L80 440.4c-20.2-22.8-36.3-45-43.2-54.9-5.9-8.4-8.8-18.2-8.8-28 0-27.3 22.1-49.5 49.5-49.5L196 308c30.9 0 56 25.1 56 56l0 118.5c0 27.3-22.1 49.5-49.5 49.5-9.8 0-19.6-2.9-28-8.8-9.9-7-32.1-23.1-54.9-43.2L47.8 551.8c-10.9 10.9-28.7 10.9-39.6 0zm504 0L440.4 480c-22.8 20.2-45 36.3-54.9 43.2-8.4 5.9-18.2 8.8-28 8.8-27.3 0-49.5-22.1-49.5-49.5L308 364c0-30.9 25.1-56 56-56l118.5 0c27.3 0 49.5 22.1 49.5 49.5 0 9.8-2.9 19.6-8.8 28-7 9.9-23.1 32.1-43.2 54.9l71.8 71.8c10.9 10.9 10.9 28.7 0 39.6s-28.7 10.9-39.6 0zm39.6-504L480 119.6c20.2 22.8 36.3 45 43.2 54.9 5.9 8.4 8.8 18.2 8.8 28 0 27.3-22.1 49.5-49.5 49.5L364 252c-30.9 0-56-25.1-56-56l0-118.5c0-27.3 22.1-49.5 49.5-49.5 9.8 0 19.6 2.9 28 8.8 9.9 7 32.1 23.1 54.9 43.2L512.2 8.2c10.9-10.9 28.7-10.9 39.6 0s10.9 28.7 0 39.6z"],
    "eye-slash": [616, 560, [], "f070", "M75.8 8.2C64.9-2.7 47.1-2.7 36.2 8.2s-10.9 28.7 0 39.6l504 504c10.9 10.9 28.7 10.9 39.6 0s10.9-28.7 0-39.6l-67.4-67.4c42.3-34.3 70.3-73 85.7-97.7 13.2-21.2 17.8-44.9 17.8-67.1s-4.6-45.9-17.8-67.1C565.8 160.8 473.9 42 308 42 245.4 42 193.1 59 150.6 83L75.8 8.2zM62.8 167c8-.5 15.8 2.5 21.5 8.1L375.6 466.4c7.4 7.4 10.1 18.4 6.8 28.4s-11.8 17.4-22.2 19C343.7 516.5 326.3 518 308 518 142.1 518 50.2 399.2 17.8 347.1 4.6 325.9 0 302.2 0 280s4.6-45.9 17.8-67.1c6.2-10 14.4-22.1 24.6-35.2 4.9-6.3 12.3-10.2 20.4-10.7z"],
    "mug-hot": [560, 560, [9749], "f7b6", "M138.6-8.9c-4.9-14.7-20.7-22.6-35.4-17.7S80.5-5.8 85.4 8.9l5.1 15.4c3.8 11.5 3.8 23.9 0 35.4L85.4 75.1c-4.9 14.7 3 30.5 17.7 35.4s30.5-3 35.4-17.7l5.1-15.4c7.7-23 7.7-47.8 0-70.8L138.6-8.9zm112 0c-4.9-14.7-20.7-22.6-35.4-17.7S192.5-5.8 197.4 8.9l5.1 15.4c3.8 11.5 3.8 23.9 0 35.4l-5.1 15.4c-4.9 14.7 3 30.5 17.7 35.4s30.5-3 35.4-17.7l5.1-15.4c7.7-23 7.7-47.8 0-70.8L250.6-8.9zm112 0c-4.9-14.7-20.7-22.6-35.4-17.7S304.5-5.8 309.4 8.9l5.1 15.4c3.8 11.5 3.8 23.9 0 35.4l-5.1 15.4c-4.9 14.7 3 30.5 17.7 35.4s30.5-3 35.4-17.7l5.1-15.4c7.7-23 7.7-47.8 0-70.8L362.6-8.9zM84 168c-30.9 0-56 25.1-56 56l0 136c0 30.6 1.5 56.9 6.3 79 4.8 22.4 13.4 42.2 28.9 57.8s35.4 24.1 57.8 28.9c22.1 4.8 48.5 6.3 79 6.3l48 0c30.6 0 56.9-1.5 79-6.3 22.4-4.8 42.2-13.4 57.8-28.9s24.1-35.4 28.9-57.8c4.8-22.1 6.3-48.5 6.3-79l0-136 42 0c24.7 0 32.3 4.5 34.9 7.1S504 241.3 504 266l0 28c0 19.3-2.7 28.3-5.3 32.6-1.5 2.5-4.2 5.6-14.3 7.6-15.2 3.1-24.9 17.9-21.9 33s17.9 24.9 33 21.9c20.9-4.2 39.2-14.1 50.9-33.4 10.7-17.6 13.5-39.2 13.5-61.7l0-28c0-27.8-4.3-55.2-23.5-74.5S489.8 168 462 168L84 168z"],
    "bolt": [448, 560, [9889, "zap"], "f0e7", "M280 0c-13 0-25.4 5.9-36.6 12.1-11.3 6.3-24 15-37.4 25-26.7 20.1-57.8 47.2-87.3 75.8-29.5 28.6-58 59.3-79.4 86.9-10.7 13.8-20 27.3-26.8 39.9-6.3 11.6-12.5 26-12.5 40.3 0 30.4 23.3 55.7 53.6 58.2l90.1 7.5c8.7 .7 14.6 9.1 12.4 17.6L120.2 497.7c-8.4 31.4 15.3 62.3 47.8 62.3 13 0 25.4-5.9 36.6-12.1 11.3-6.3 24-15 37.4-25 26.7-20.1 57.8-47.2 87.3-75.8 29.5-28.6 58-59.3 79.4-86.9 10.7-13.8 20-27.3 26.8-39.9 6.3-11.6 12.5-26 12.5-40.3 0-30.4-23.3-55.7-53.6-58.2l-90.1-7.5c-8.7-.7-14.6-9.1-12.4-17.6L327.8 62.3C336.2 30.8 312.5 0 280 0z"],
    "arrow-rotate-left": [560, 560, [8634, "arrow-left-rotate", "arrow-rotate-back", "arrow-rotate-backward", "undo"], "f0e2", "M476 280c0-62.4-19.7-110.8-52.5-143.5S342.4 84 280 84c-45.8 0-84 10.6-113.9 29.1 22.9 25 41.5 50.6 49.1 61.4 5.9 8.4 8.8 18.2 8.8 28 0 27.3-22.1 49.5-49.5 49.5L56 252c-30.9 0-56-25.1-56-56L0 77.5c0-27.3 22.1-49.5 49.5-49.5 9.8 0 19.6 2.9 28 8.8 8.8 6.2 27.2 19.6 47.2 36.6 42-29.9 95.1-45.4 155.3-45.4 74.5 0 138.1 23.8 183.1 68.9S532 205.5 532 280 508.2 418.1 463.1 463.1 354.5 532 280 532c-103.2 0-184.7-45.9-225-127.6-6.8-13.9-1.1-30.7 12.7-37.5s30.7-1.1 37.5 12.7c29.3 59.5 89.2 96.4 174.8 96.4 62.4 0 110.8-19.7 143.5-52.5S476 342.4 476 280z"],
    "wifi": [616, 560, ["wifi-3", "wifi-strong"], "f1eb", "M47.3 176.8C109 118.1 197.5 84 308 84s199 34.1 260.7 92.8c11.2 10.7 28.9 10.2 39.6-1s10.2-28.9-1-39.6C533.4 65.9 430.2 28 308 28S82.6 65.9 8.7 136.2c-11.2 10.7-11.6 28.4-1 39.6s28.4 11.6 39.6 1zm80 83.3C169.6 219.8 230.7 196 308 196s138.4 23.8 180.7 64c11.2 10.7 28.9 10.2 39.6-1s10.2-28.9-1-39.6C472.8 167.6 397 140 308 140S143.2 167.6 88.7 219.5c-11.2 10.7-11.6 28.4-1 39.6s28.4 11.6 39.6 1zm80 83.3C230.2 321.5 264 308 308 308s77.8 13.5 100.7 35.3c11.2 10.7 28.9 10.2 39.6-1s10.2-28.9-1-39.6C412.2 269.3 363.7 252 308 252s-104.2 17.3-139.3 50.8c-11.2 10.7-11.6 28.4-1 39.6s28.4 11.6 39.6 1zM308 518a70 70 0 1 0 0-140 70 70 0 1 0 0 140z"],
    "volume": [616, 560, [128265, "volume-medium"], "f6a8", "M537.7 38.3c-9.8-12-27.4-13.8-39.4-4s-13.8 27.4-4 39.4C535.9 124.7 560 194.4 560 280s-24.1 155.3-65.7 206.3c-9.8 12-8 29.6 4 39.4s29.6 8 39.4-4C588.8 459.1 616 376.2 616 280S588.8 100.9 537.7 38.3zm-78.4 87.4c-8.9-12.7-26.3-15.7-39-6.8s-15.7 26.3-6.8 39c21.8 31 34.5 72.1 34.5 122.2s-12.8 91.2-34.5 122.2c-8.9 12.7-5.8 30.1 6.8 39s30.1 5.8 39-6.8C488.7 392.4 504 339.7 504 280s-15.3-112.4-44.7-154.4zM0 287l0-14c0-22.4 1.1-42.3 4.7-59.2 3.7-17.2 10.5-33.2 23.2-45.9s28.7-19.4 45.9-23.2c15.1-3.3 32.6-4.5 52.2-4.7l58.8-78.4C200.7 40.4 225.6 28 252 28l16.3 0c35.4 0 69 22.9 77.2 60.4 8.4 38.8 18.6 103.7 18.6 191.6s-10.1 152.8-18.6 191.6c-8.1 37.5-41.7 60.4-77.2 60.4L252 532c-26.4 0-51.3-12.4-67.2-33.6L126 420c-19.6-.2-37.1-1.4-52.2-4.7-17.2-3.7-33.2-10.5-45.9-23.2S8.4 363.4 4.7 346.2C1.1 329.3 0 309.4 0 287z"],
    "tag": [560, 560, [127991], "f02b", "M41 332.6c-26.3-26.3-41-61.9-41-99L0 154c0-26.8 1.3-50.2 5.6-69.9 4.3-20 12.1-38.1 26.3-52.3S64.1 9.9 84.1 5.6C103.8 1.3 127.2 0 154 0l79.6 0c37.1 0 72.7 14.7 99 41L529.7 238.1c19.4 19.4 30.3 45.7 30.3 73.2 0 22-7 43.9-21.2 61.7-16.3 20.5-44.4 54.1-78 87.8s-67.3 61.7-87.8 78c-17.9 14.2-39.8 21.2-61.7 21.2-27.4 0-53.8-10.9-73.2-30.3L41 332.6zM154 196a42 42 0 1 0 0-84 42 42 0 1 0 0 84z"],
    "compact-disc": [560, 560, [128191, 128192, 128440], "f51f", "M546.9 375.2c8.7-29.3 13.1-61.2 13.1-95.2 0-83-26.5-153.6-76.5-203.5S363 0 280 0c-34 0-65.9 4.5-95.2 13.1-18.6 5.5-36.1 12.7-52.4 21.6-20.7 11.3-39.5 25.2-56 41.7s-30.4 35.2-41.7 56C25.9 148.7 18.7 166.2 13.1 184.8 4.5 214.1 0 246 0 280 0 363 26.5 433.6 76.5 483.5S197 560 280 560c34 0 65.9-4.5 95.2-13.1 18.6-5.5 36.1-12.7 52.4-21.6 20.7-11.3 39.5-25.2 56-41.7s30.4-35.2 41.7-56c8.9-16.3 16.1-33.8 21.6-52.4zm-158.2-65c31.7 20.1 66.5 36.7 104.4 49.6-10.2 33.9-27 62.1-49.1 84.1s-50.3 38.9-84.1 49.1c-12.9-37.8-29.6-72.7-49.6-104.4 19.5-4.5 37-13.7 50.9-27.6s23.1-31.3 27.6-50.9zM249.8 171.3c-19.5 4.5-37 13.7-50.9 27.6s-23.1 31.3-27.6 50.9c-31.7-20.1-66.5-36.7-104.4-49.6 10.2-33.9 27-62.1 49.1-84.1S166.3 77.1 200.2 67c12.9 37.8 29.6 72.7 49.6 104.4zM224 280c0-19.6 6.1-33 14.5-41.5s21.8-14.5 41.5-14.5 33 6.1 41.5 14.5 14.5 21.8 14.5 41.5-6.1 33-14.5 41.5-21.8 14.5-41.5 14.5-33-6.1-41.5-14.5-14.5-21.8-14.5-41.5z"],
    "phone-slash": [560, 560, [], "f3dd", "M551.8 8.2c-10.9-10.9-28.7-10.9-39.6 0L135.1 385.3c-15-18.1-28-38.1-39-60 64-37.7 109.6-81.7 138.9-115.6 36.1-41.7 26.7-99.7-8.5-134.9L175.9 24.3C160.3 8.7 139.2 0 117.3 0 98.4 0 80.2 6.4 65.5 18.2L42 36.9C15.5 58.2 0 90.3 0 124.4L0 140C0 254.6 33.3 352.4 95.3 425.1L8.2 512.2c-10.9 10.9-10.9 28.7 0 39.6s28.7 10.9 39.6 0l504-504c10.9-10.9 10.9-28.7 0-39.6zM350.2 325c41.7-36.1 99.7-26.7 134.9 8.5l50.6 50.6c15.5 15.5 24.3 36.6 24.3 58.6 0 18.8-6.4 37.1-18.2 51.8L523.1 518c-21.3 26.6-53.4 42-87.5 42L420 560c-82.8 0-157-17.4-219.3-50.6-13.6-7.3-18.8-24.2-11.5-37.9 10.2-19.1 29.6-15.5 45.5-7.6 37.7-64 81.7-109.6 115.6-138.9z"],
    "arrow-up-right-from-square": [560, 560, ["external-link"], "f08e", "M260.2 299.8c-10.9-10.9-10.9-28.7 0-39.6L388 132.4c-20.2-22.8-36.3-45-43.2-54.9-5.9-8.4-8.8-18.2-8.8-28 0-27.3 22.1-49.5 49.5-49.5L504 0c30.9 0 56 25.1 56 56l0 118.5c0 27.3-22.1 49.5-49.5 49.5-9.8 0-19.6-2.9-28-8.8-9.9-7-32.1-23.1-54.9-43.2L299.8 299.8c-10.9 10.9-28.7 10.9-39.6 0zM35.2 427.2C29.7 401.9 28 371.6 28 336l0-112c0-35.6 1.7-65.9 7.2-91.2 5.5-25.6 15.2-47.8 32.5-65.1s39.5-27 65.1-32.5c25.3-5.5 55.7-7.2 91.2-7.2 15.5 0 28 12.5 28 28s-12.5 28-28 28c-34.4 0-60.1 1.8-79.4 5.9-19 4.1-30.1 10.1-37.3 17.4S94 125.6 89.9 144.6c-4.2 19.3-5.9 45-5.9 79.4l0 112c0 34.4 1.8 60.1 5.9 79.4 4.1 19 10.1 30.1 17.4 37.3s18.3 13.3 37.3 17.4c19.3 4.2 45 5.9 79.4 5.9l112 0c34.4 0 60.1-1.8 79.4-5.9 19-4.1 30.1-10.1 37.3-17.4s13.3-18.3 17.4-37.3c4.2-19.3 5.9-45 5.9-79.4 0-15.5 12.5-28 28-28s28 12.5 28 28c0 35.6-1.7 65.9-7.2 91.2-5.5 25.6-15.2 47.8-32.5 65.1s-39.5 27-65.1 32.5c-25.3 5.5-55.7 7.2-91.2 7.2l-112 0c-35.6 0-65.9-1.7-91.2-7.2-25.6-5.5-47.8-15.2-65.1-32.5s-27-39.5-32.5-65.1z"],
    "rectangle-tall": [392, 560, [], "e791", "M196-56c-35.6 0-65.9 1.7-91.2 7.2-25.6 5.5-47.8 15.2-65.1 32.5S12.7 23.2 7.2 48.8C1.7 74.1 0 104.4 0 140L0 420c0 35.6 1.7 65.9 7.2 91.2 5.5 25.6 15.2 47.8 32.5 65.1s39.5 27 65.1 32.5c45.4 9.8 137 9.8 182.4 0 25.6-5.5 47.8-15.2 65.1-32.5s27-39.5 32.5-65.1c5.5-25.3 7.2-55.7 7.2-91.2l0-280c0-35.6-1.7-65.9-7.2-91.2-5.5-25.6-15.2-47.8-32.5-65.1s-39.5-27-65.1-32.5C261.9-54.3 231.6-56 196-56z"],
    "compass": [560, 560, [129517], "f14e", "M302.2 216.1c26.2-9.5 53.9-17.9 71.7-23-5.1 17.7-13.4 45.5-23 71.7-5.2 14.3-10.6 27.7-15.9 38.6-5.6 11.7-9.8 17.8-11.8 19.8s-8.1 6.2-19.8 11.8c-10.9 5.3-24.3 10.6-38.6 15.9-26.2 9.5-53.9 17.9-71.7 23 5.1-17.7 13.4-45.5 23-71.7 5.2-14.3 10.6-27.7 15.9-38.6 5.6-11.7 9.8-17.8 11.8-19.8s8.1-6.2 19.8-11.8c10.9-5.3 24.3-10.6 38.6-15.9zM76.5 76.5C126.4 26.5 197 0 280 0S433.6 26.5 483.5 76.5 560 197 560 280 533.5 433.6 483.5 483.5 363 560 280 560 126.4 533.5 76.5 483.5 0 363 0 280 26.5 126.4 76.5 76.5zm338.8 75.3c-13.5-13.5-33.3-19.1-52.2-13.7-17.8 5-49.7 14.4-80.1 25.5-15.2 5.5-30.5 11.7-43.8 18-12.5 6-25.9 13.5-35.1 22.7s-16.7 22.6-22.7 35.1c-6.4 13.2-12.5 28.5-18 43.8-11.1 30.5-20.5 62.3-25.5 80.1-5.3 18.9 .3 38.7 13.7 52.2S185 434.4 203.9 429c17.8-5 49.7-14.4 80.1-25.5 15.2-5.5 30.5-11.7 43.8-18 12.5-6 25.9-13.5 35.1-22.7s16.7-22.6 22.7-35.1c6.4-13.2 12.5-28.5 18-43.8 11.1-30.5 20.5-62.3 25.5-80.1 5.3-18.9-.3-38.7-13.7-52.2z"],
    "square": [504, 560, [9632, 9723, 9724, 61590], "f0c8", "M0 336c0 35.6 1.7 65.9 7.2 91.2 5.5 25.6 15.2 47.8 32.5 65.1s39.5 27 65.1 32.5c25.3 5.5 55.7 7.2 91.2 7.2l112 0c35.6 0 65.9-1.7 91.2-7.2 25.6-5.5 47.8-15.2 65.1-32.5s27-39.5 32.5-65.1c5.5-25.3 7.2-55.7 7.2-91.2l0-112c0-35.6-1.7-65.9-7.2-91.2-5.5-25.6-15.2-47.8-32.5-65.1s-39.5-27-65.1-32.5C373.9 29.7 343.6 28 308 28L196 28c-35.6 0-65.9 1.7-91.2 7.2-25.6 5.5-47.8 15.2-65.1 32.5s-27 39.5-32.5 65.1C1.7 158.1 0 188.4 0 224L0 336z"],
    "face-grin": [560, 560, [128512, "grin"], "f580", "M76.5 76.5C126.4 26.5 197 0 280 0S433.6 26.5 483.5 76.5 560 197 560 280 533.5 433.6 483.5 483.5 363 560 280 560 126.4 533.5 76.5 483.5 0 363 0 280 26.5 126.4 76.5 76.5zM168 168c-15.5 0-28 12.5-28 28l0 56c0 15.5 12.5 28 28 28s28-12.5 28-28l0-56c0-15.5-12.5-28-28-28zm140 0c-15.5 0-28 12.5-28 28l0 56c0 15.5 12.5 28 28 28s28-12.5 28-28l0-56c0-15.5-12.5-28-28-28zm0 294c26.9 0 47.5-6.8 62.8-18 29-21.3 40-61.4 35.1-95.9-1.1-7.4-8.6-13-16-11.9l-182 28c-7.6 1.2-13.1 9.1-11.6 16.6 3.2 14.9 10.9 29.2 20.3 41 16.5 20.6 44.9 40.3 91.4 40.3z"],
    "angle-up": [560, 560, [8963], "f106", "M560 359c0-12.5-4.5-24.8-13.1-34.4-13.6-15.2-48.3-53.1-92-93.9-43.3-40.4-97.1-85-148.7-112.3-8.4-4.4-17.5-6.4-26.3-6.4s-17.9 2-26.3 6.4C202.1 145.7 148.4 190.3 105 230.7 61.3 271.4 26.6 309.4 13.1 324.6 4.5 334.2 0 346.5 0 359 0 394.4 33.7 418.6 66.4 410.7 108 400.7 187.9 385 280 385s172 15.7 213.6 25.7c32.6 7.9 66.4-16.3 66.4-51.7z"],
    "face-smile": [560, 560, [128578, "smile"], "f118", "M280 0C197 0 126.4 26.5 76.5 76.5S0 197 0 280 26.5 433.6 76.5 483.5 197 560 280 560 433.6 533.5 483.5 483.5 560 363 560 280 533.5 126.4 483.5 76.5 363 0 280 0zM412.4 312.7c12.9 8.6 16.3 26 7.8 38.8-29.8 44.7-80.1 68.5-140.2 68.5-23.4 0-45.4-3.6-65.5-10.8-14.6-5.2-22.1-21.3-16.9-35.8s21.3-22.1 35.8-16.9c13.3 4.8 28.8 7.5 46.5 7.5 44.8 0 76-17.1 93.6-43.5 8.6-12.9 26-16.3 38.8-7.8zM196 196l0 56c0 15.5-12.5 28-28 28s-28-12.5-28-28l0-56c0-15.5 12.5-28 28-28s28 12.5 28 28zm140 0l0 56c0 15.5-12.5 28-28 28s-28-12.5-28-28l0-56c0-15.5 12.5-28 28-28s28 12.5 28 28z"],
    "umbrella": [560, 560, [], "f0e9", "M390.7 297.5c.7 11.3-7.8 20.9-19.1 21.6-27.2 1.8-57.6 2.9-91.3 2.9s-64.1-1.1-91.3-2.9c-11.2-.7-19.8-10.4-19.1-21.6 2.1-34.3 6.7-86.4 17-138 8.8-44.4 21.4-86.5 38.6-116.7 17.4-30.5 35.7-42.8 54.8-42.8s37.4 12.2 54.8 42.8c17.3 30.2 29.8 72.2 38.6 116.7 10.2 51.6 14.9 103.7 17 138zm4.8-259c-4.1-9.2 4.4-19.5 13.7-15.7 23.3 9.4 44.6 21.6 63.4 36.9 49.9 40.5 79.6 99.8 86.3 173.6 2.9 32.4-18.7 60.8-49.8 67.7-10.4 2.3-23.4 4.8-38.8 7.3-12.2 2-23.2-7.2-24-19.6-2.3-35.7-7.2-87.7-17.6-140.1-7.3-37-18.2-76.4-33.2-110.1zM90.4 308.2c12.2 2 23.2-7.2 24-19.6 2.3-35.7 7.2-87.7 17.6-140.1 7.3-37 18.2-76.4 33.2-110.1 4.1-9.2-4.4-19.5-13.7-15.7-23.3 9.4-44.6 21.6-63.4 36.9-49.9 40.5-79.6 99.8-86.3 173.6-2.9 32.4 18.7 60.8 49.8 67.7 10.4 2.3 23.3 4.8 38.8 7.3zM308.3 406c0-15.5-12.5-28-28-28s-28 12.5-28 28l0 56.8c0 22.8-18.5 41.2-41.2 41.2-15.6 0-29.9-8.8-36.9-22.8l-8.9-17.7c-6.9-13.8-23.7-19.4-37.6-12.5s-19.4 23.7-12.5 37.6l8.9 17.7c16.5 32.9 50.1 53.7 87 53.7 53.7 0 97.2-43.5 97.2-97.2l0-56.8z"],
    "pause": [560, 560, [9208], "f04c", "M79.5 35.9c18.4-6.9 39.6-7.9 60.6-7.9 20.8 0 41.8 .9 59.4 8.3 20.5 8.6 33.2 24.3 40.6 45.5 6.7 19.3 9.4 44.5 10.7 75.3 3.5 81 3.5 164.7 0 245.7-1.3 30.8-4 56-10.7 75.3-7.4 21.2-20.1 36.9-40.6 45.5-17.6 7.4-38.6 8.3-59.4 8.3-21.1 0-42.3-1-60.6-7.9-20.5-7.7-35.4-22-45.3-43.3-9.1-19.7-13.8-45.3-16.5-76.7-7-81.6-7-166.6 0-248.1 2.7-31.4 7.4-57 16.5-76.7 9.9-21.4 24.8-35.6 45.3-43.3zM420.1 28c-20.8 0-41.8 .9-59.4 8.3-20.5 8.6-33.2 24.3-40.6 45.5-6.7 19.3-9.4 44.5-10.7 75.3-3.5 81-3.5 164.7 0 245.7 1.3 30.8 4 56 10.7 75.3 7.4 21.2 20.1 36.9 40.6 45.5 17.6 7.4 38.6 8.3 59.4 8.3 21.1 0 42.3-1 60.6-7.9 20.5-7.7 35.4-22 45.3-43.3 9.1-19.7 13.8-45.3 16.5-76.7 7-81.6 7-166.6 0-248.1-2.7-31.4-7.4-57-16.5-76.7-9.9-21.4-24.8-35.6-45.3-43.3-18.4-6.9-39.6-7.9-60.6-7.9z"],
    "desktop": [560, 560, [128421, 61704, "desktop-alt"], "f390", "M7.4 315.2c-9.8-45.4-9.8-137 0-182.4 5.5-25.6 15.2-47.8 32.5-65.1s39.5-27 65.1-32.5c25.3-5.5 55.7-7.2 91.2-7.2l168 0c35.6 0 65.9 1.7 91.2 7.2 25.6 5.5 47.8 15.2 65.1 32.5s27 39.5 32.5 65.1c9.8 45.4 9.8 137 0 182.4-5.5 25.6-15.2 47.8-32.5 65.1s-39.5 27-65.1 32.5c-25.3 5.5-55.7 7.2-91.2 7.2l-168 0c-35.6 0-65.9-1.7-91.2-7.2-25.6-5.5-47.8-15.2-65.1-32.5s-27-39.5-32.5-65.1zM308.2 490c0-15.5-12.5-28-28-28s-28 12.5-28 28l0 14-84 0c-15.5 0-28 12.5-28 28s12.5 28 28 28l224 0c15.5 0 28-12.5 28-28s-12.5-28-28-28l-84 0 0-14z"],
    "arrow-down": [504, 560, [8595], "f063", "M488.3 378.5c10.5-11.8 15.7-26.8 15.7-41.8 0-29.6-20.4-56.5-51.3-61.9-22.4-3.9-56.8-8.9-101.4-12.2-9.3-.7-15.3-8.7-14.3-16.6L357.9 78.7C363.1 36.9 330.5 0 288.4 0L215.6 0c-42.1 0-74.7 36.9-69.5 78.7L167 246c1 7.9-5.1 15.9-14.3 16.6-44.6 3.3-79 8.3-101.4 12.2-30.9 5.4-51.3 32.4-51.3 61.9 0 15 5.2 30 15.7 41.8 26.8 30.3 114.5 125 210.1 175.1 8.3 4.4 17.4 6.4 26.2 6.4s17.9-2 26.2-6.4c95.6-50.1 183.3-144.8 210.1-175.1z"],
    "location-dot": [448, 560, ["map-marker-alt"], "f3c5", "M61.3 61.3C101.5 21.1 158.1 0 224 0S346.5 21.1 386.7 61.3 448 158.1 448 224c0 72.8-28.3 139.3-61.1 192.1-32.9 53-71.4 94.3-94.8 117-18.8 18.3-43.6 26.9-68.1 26.9s-49.4-8.6-68.1-26.9C132.5 510.4 93.9 469.1 61.1 416.1 28.3 363.3 0 296.8 0 224 0 158.1 21.1 101.5 61.3 61.3zM224 294a70 70 0 1 0 0-140 70 70 0 1 0 0 140z"],
    "bars": [504, 560, ["navicon"], "f0c9", "M0 280c0-15.5 12.5-28 28-28l448 0c15.5 0 28 12.5 28 28s-12.5 28-28 28L28 308c-15.5 0-28-12.5-28-28zM484.2 110.8c14.8-4.5 23.1-20.2 18.6-35s-20.2-23.1-35-18.5C398.8 78 323.5 84 252 84S105.2 78 36.2 57.2C21.5 52.7 5.8 61 1.2 75.8s3.8 30.5 18.6 35C93.9 133.5 175.1 140 252 140s158.1-6.5 232.2-29.2zm0 338.5c14.8 4.6 23.1 20.2 18.6 35s-20.2 23.1-35 18.5C398.8 482 323.5 476 252 476s-146.8 6-215.8 26.8c-14.8 4.5-30.4-3.8-35-18.5s3.8-30.5 18.6-35C93.9 426.5 175.1 420 252 420s158.1 6.5 232.2 29.2z"],
    "battery-empty": [672, 560, ["battery-0"], "f244", "M63.2 399.2C57.7 373.9 56 343.6 56 308l0-56c0-35.6 1.7-65.9 7.2-91.2 5.5-25.6 15.2-47.8 32.5-65.1s39.5-27 65.1-32.5C186.1 57.7 216.4 56 252 56l126 0c35.6 0 65.9 1.7 91.2 7.2 25.6 5.5 47.8 15.2 65.1 32.5s27 39.5 32.5 65.1c5.5 25.3 7.2 55.7 7.2 91.2l0 56c0 35.6-1.7 65.9-7.2 91.2-5.5 25.6-15.2 47.8-32.5 65.1s-39.5 27-65.1 32.5c-25.3 5.5-55.7 7.2-91.2 7.2l-126 0c-35.6 0-65.9-1.7-91.2-7.2-25.6-5.5-47.8-15.2-65.1-32.5s-27-39.5-32.5-65.1zM672 224c0-15.5-12.5-28-28-28s-28 12.5-28 28l0 112c0 15.5 12.5 28 28 28s28-12.5 28-28l0-112z"],
    "stopwatch": [504, 560, [9201], "f2f2", "M224 62.4l0 22.9C165.8 90.5 115.9 112.2 79.1 149.1 36.5 191.7 14 251.8 14 322S36.5 452.3 79.1 494.9 181.8 560 252 560 382.3 537.5 424.9 494.9 490 392.2 490 322c0-59.3-16-111.3-46.6-151.8l24.4-24.4c10.9-10.9 10.9-28.7 0-39.6s-28.7-10.9-39.6 0l-24.4 24.4C369.8 104.9 327.7 89.5 280 85.2l0-22.9c20.9-.9 42-2.4 62.4-7.1 15.1-3.5 24.4-18.6 20.9-33.7S344.7-2.8 329.6 .7C304.3 6.1 277.8 7 252 7s-52.3-.9-77.7-6.3c-15-3.5-30.1 5.8-33.6 20.9s5.8 30.1 20.9 33.7C182 60 203.1 61.4 224 62.4zM252 196c15.5 0 28 12.5 28 28l0 98c0 15.5-12.5 28-28 28s-28-12.5-28-28l0-98c0-15.5 12.5-28 28-28z"],
    "train": [448, 560, [128646], "f238", "M167.7 223.4c-53-1.1-96-3.7-127.6-6.3-8.4-.7-16.1-1.4-22.9-2-9.8-.9-17.2-9.2-17.2-19.1 0-35.6 1.7-65.9 7.2-91.2 5.5-25.6 15.2-47.8 32.5-65.1s39.5-27 65.1-32.5c18.4-4 39.4-6 63.2-6.8 15.5-.5 28 12.1 28 27.6l0 167.6c0 15.6-12.7 28.2-28.3 27.8zM0 300.7c0-16.6 14.4-29.6 31-28.2l4.6 .4C79.2 276.5 142.9 280 224 280s144.8-3.5 188.5-7.1l4.6-.4c16.6-1.4 31 11.6 31 28.2l0 7.3c0 35.6-1.7 65.9-7.2 91.2-5.5 25.6-15.2 47.8-32.5 65.1-4.3 4.3-8.9 8.1-13.7 11.5l42.9 34.3c12.1 9.7 14 27.3 4.4 39.4s-27.3 14-39.4 4.4l-69-55.2c-23.2 4-50.4 5.3-81.5 5.3l-56 0c-31.1 0-58.3-1.3-81.5-5.3l-69 55.2c-12.1 9.7-29.7 7.7-39.4-4.4s-7.7-29.7 4.4-39.4l42.9-34.3c-4.9-3.4-9.4-7.2-13.7-11.5-17.3-17.3-27-39.5-32.5-65.1-5.5-25.3-7.2-55.7-7.2-91.2l0-7.3zM140 420a42 42 0 1 0 0-84 42 42 0 1 0 0 84zm210-42a42 42 0 1 0 -84 0 42 42 0 1 0 84 0zm98-182c0 9.8-7.4 18.1-17.2 19.1-6.8 .7-14.4 1.3-22.9 2-31.7 2.6-74.6 5.2-127.6 6.3-15.6 .3-28.3-12.3-28.3-27.8L252 28c0-15.5 12.5-28.1 28-27.6 23.8 .8 44.9 2.8 63.2 6.8 25.6 5.5 47.8 15.2 65.1 32.5s27 39.5 32.5 65.1c5.5 25.3 7.2 55.7 7.2 91.2z"],
    "gamepad": [616, 560, [], "f11b", "M143.7 41.5C183.4 34.6 239.2 28 308 28s124.6 6.6 164.3 13.5c53.6 9.4 90 52.7 99.1 102.7l42.3 232.9c1.9 10.4 2.2 20.8 2.2 31.3 0 32.8-13 64.2-36.2 87.4l-10.1 10.1c-16.7 16.7-39.4 26.1-63.1 26.1-28.1 0-54.5-13.2-71.4-35.7l-51.6-68.8c-1.4-1.8-5.4-1.4-7.1-1-16.1 3.9-38.9 7.5-68.5 7.5s-52.4-3.6-68.5-7.5c-1.7-.4-5.9-.7-7.2 1l-51.6 68.8c-16.9 22.5-43.3 35.7-71.4 35.7-23.7 0-46.4-9.4-63.1-26.1L36.2 495.8C13 472.6 0 441.2 0 408.4 0 397.9 .4 387.5 2.2 377.1L44.6 144.2c9.1-50 45.6-93.4 99.1-102.7zM420 308a28 28 0 1 0 0-56 28 28 0 1 0 0 56zm28-140a28 28 0 1 0 -56 0 28 28 0 1 0 56 0zm-84 84a28 28 0 1 0 0-56 28 28 0 1 0 0 56zm140-28a28 28 0 1 0 -56 0 28 28 0 1 0 56 0zM210 168c0-15.5-12.5-28-28-28s-28 12.5-28 28l0 14-14 0c-15.5 0-28 12.5-28 28s12.5 28 28 28l14 0 0 14c0 15.5 12.5 28 28 28s28-12.5 28-28l0-14 14 0c15.5 0 28-12.5 28-28s-12.5-28-28-28l-14 0 0-14z"],
    "ship": [560, 560, [128674], "f21a", "M140 112c0-46.4 37.6-84 84-84l112 0c46.4 0 84 37.6 84 84l0 26.3c0 8.8-4.2 17.2-11.2 22.4s-16.2 6.9-24.7 4.4l-66.5-19.7c-12.2-3.6-24.9-5.4-37.6-5.4s-25.4 1.8-37.6 5.4L176 165.1c-8.5 2.5-17.6 .9-24.7-4.4S140 147.1 140 138.3l0-26.3zm118.3 87.1c7-2.1 14.3-3.1 21.7-3.1s14.6 1.1 21.7 3.1l182.3 54c11.9 3.5 20 14.4 20 26.8 0 34.6-10.2 77.3-21.9 115.7-3.8 12.4-15.6 20.6-28.6 19.7-23.8-1.6-47.6 7.3-64.6 24.1-4.2 4.2-9.7 6.9-15.5 7.8-6.1 .9-12.6 .9-18.7 0-5.9-.9-11.3-3.6-15.5-7.8-15.7-15.5-36.9-24.3-59.1-24.3s-43.4 8.8-59.1 24.3c-4.2 4.2-9.7 6.9-15.5 7.8-6.1 .9-12.6 .9-18.7 0-5.9-.9-11.3-3.6-15.5-7.8-17-16.8-40.8-25.7-64.6-24.1-13 .8-24.8-7.3-28.6-19.7-11.8-38.4-21.9-81.1-21.9-115.7 0-12.4 8.2-23.3 20-26.8l182.3-54zM112 471.2c7.8 0 15.2 3.2 20.5 8.9 13.3 14.3 34.2 23.8 63.5 23.8s50.2-9.6 63.5-23.8c5.3-5.7 12.7-8.9 20.5-8.9s15.2 3.2 20.5 8.9C313.8 494.4 334.7 504 364 504s50.2-9.6 63.5-23.8c5.3-5.7 12.7-8.9 20.5-8.9s15.2 3.2 20.5 8.9c13.3 14.3 34.2 23.8 63.5 23.8 15.5 0 28 12.5 28 28s-12.5 28-28 28c-31.8 0-60.7-8.1-84-24-23.3 16-52.2 24-84 24s-60.7-8.1-84-24c-23.3 16-52.2 24-84 24s-60.7-8.1-84-24c-23.3 16-52.2 24-84 24-15.5 0-28-12.5-28-28s12.5-28 28-28c29.3 0 50.2-9.6 63.5-23.8 5.3-5.7 12.7-8.9 20.5-8.9z"],
    "arrows-rotate": [560, 560, [128472, "refresh", "sync"], "f021", "M151.7 123.1c-31.6 24.5-53.7 60.3-62.9 106.4-3 15.2-17.8 25-32.9 22s-25-17.8-22-32.9c11.6-58.1 40.3-106.2 83.5-139.7 43.1-33.4 98.9-50.8 162.6-50.8 61.1 0 107.5 21.6 147 53.8 17.8-14.8 34-26.2 42.1-31.6 8.3-5.6 17.8-8.2 27.2-8.2 27.4 0 49.7 22.3 49.7 49.7L546 196c0 30.9-25.1 56-56 56l-104.3 0c-27.4 0-49.7-22.3-49.7-49.7 0-9.4 2.7-18.9 8.2-27.2 6.6-9.9 22.1-31.9 42-54.2-30.5-23.5-63.6-37-106.3-37-53.5 0-96.6 14.5-128.3 39.1zM504.2 308.5c15.2 3 25 17.8 22 32.9-11.6 58.1-40.3 106.2-83.5 139.7-43.1 33.4-98.9 50.8-162.6 50.8-59.3 0-104.7-20.3-143.5-51-20.6 15.9-40.1 26.8-48.9 31.4-7.4 3.9-15.3 5.6-22.8 5.6-28.1 0-50.8-22.8-50.8-50.8L14 364c0-30.9 25.1-56 56-56l103.4 0c27.9 0 50.6 22.7 50.6 50.6 0 7.9-1.8 16.1-6 23.6-5.6 10.2-20.1 35.1-40.6 59.5 29.5 21.8 61.7 34.2 102.6 34.2 53.5 0 96.6-14.5 128.3-39.1 31.6-24.5 53.7-60.3 62.9-106.4 3-15.2 17.8-25 32.9-22z"],
    "book-open": [560, 560, [128214, 128366], "f518", "M220.7 39.4C240.6 45 252 64.6 252 85.3L252 336c0 15.5 12.5 28 28 28s28-12.5 28-28l0-250.7c0-20.7 11.4-40.3 31.3-45.9 28.4-8 64.2-11.4 108.7-11.4 28.6 0 54.8 18.3 63 47 14.6 50.8 44.2 166.7 48.4 288.1 1.1 31.9-24.8 57-55.5 57-75.2 0-125.8 10.8-156.7 27.1-16.1 8.5-26.4 18.2-32.4 28.9L504 476c15.5 0 28 12.5 28 28s-12.5 28-28 28L56 532c-15.5 0-28-12.5-28-28s12.5-28 28-28l189.1 0c-6-10.7-16.3-20.4-32.4-28.9-30.9-16.3-81.5-27.1-156.7-27.1-30.7 0-56.6-25.1-55.5-57 4.3-121.3 33.8-237.2 48.4-288.1 8.2-28.6 34.4-47 63-47 44.4 0 80.3 3.4 108.7 11.4z"],
    "box-archive": [560, 560, ["archive"], "f187", "M0 98c0 12 1.2 24.2 5.6 35 4.9 12.1 13.3 21.2 24.7 26.9 18.6 9.3 41 8.1 61.3 8.1l376.8 0c20.2 0 42.7 1.2 61.3-8.1 11.4-5.7 19.8-14.8 24.7-26.9 4.4-10.8 5.6-23 5.6-35s-1.2-24.2-5.6-35c-4.9-12.1-13.3-21.2-24.7-26.9-18.6-9.3-41-8.1-61.3-8.1L91.6 28C71.4 28 49 26.8 30.3 36.1 18.9 41.8 10.5 50.9 5.6 63 1.2 73.8 0 86 0 98zM35.2 427.2C29.7 401.9 28 371.6 28 336l0-56c0-30.9 25.1-56 56-56l392 0c30.9 0 56 25.1 56 56l0 56c0 35.6-1.7 65.9-7.2 91.2-5.5 25.6-15.2 47.8-32.5 65.1s-39.5 27-65.1 32.5c-25.3 5.5-55.7 7.2-91.2 7.2l-112 0c-35.6 0-65.9-1.7-91.2-7.2-25.6-5.5-47.8-15.2-65.1-32.5s-27-39.5-32.5-65.1zM224 280c-15.5 0-28 12.5-28 28s12.5 28 28 28l112 0c15.5 0 28-12.5 28-28s-12.5-28-28-28l-112 0z"],
    "money-bill": [560, 560, [], "f0d6", "M7.2 399.2C1.7 373.9 0 343.6 0 308l0-56c0-35.6 1.7-65.9 7.2-91.2 5.5-25.6 15.2-47.8 32.5-65.1s39.5-27 65.1-32.5C130.1 57.7 160.4 56 196 56l168 0c35.6 0 65.9 1.7 91.2 7.2 25.6 5.5 47.8 15.2 65.1 32.5s27 39.5 32.5 65.1c5.5 25.3 7.2 55.7 7.2 91.2l0 56c0 35.6-1.7 65.9-7.2 91.2-5.5 25.6-15.2 47.8-32.5 65.1s-39.5 27-65.1 32.5c-25.3 5.5-55.7 7.2-91.2 7.2l-168 0c-35.6 0-65.9-1.7-91.2-7.2-25.6-5.5-47.8-15.2-65.1-32.5s-27-39.5-32.5-65.1zM280 168c-23.4 0-44.7 10.4-58.8 32.2-7.1 11.1-12 24.3-14.8 39.5-1.3 7-7.2 12.3-14.3 12.3L112 252c-15.5 0-28 12.5-28 28s12.5 28 28 28l80.1 0c7.1 0 13 5.3 14.3 12.3 2.9 15.2 7.7 28.5 14.8 39.5 14.1 21.8 35.4 32.2 58.8 32.2s44.7-10.4 58.8-32.2c7.1-11 12-24.3 14.8-39.5 1.3-7 7.2-12.3 14.3-12.3l80.1 0c15.5 0 28-12.5 28-28s-12.5-28-28-28l-80.1 0c-7.1 0-13-5.3-14.3-12.3-2.9-15.2-7.7-28.5-14.8-39.5-14.1-21.8-35.4-32.2-58.8-32.2z"],
    "cake-candles": [560, 560, [127874, "birthday-cake", "cake"], "f1fd", "M168.1 28c0-15.5-12.5-28-28-28s-28 12.5-28 28l0 89.8c-26.6 4.8-52.9 14.5-72.3 33.9-17.3 17.3-27 39.5-32.5 65.1-2.4 10.9-4 22.8-5.2 35.7-1.3 15 10.9 27.5 26 27.5 29.3 0 50.2-9.6 63.5-23.8 5.3-5.7 12.7-8.9 20.5-8.9s15.2 3.2 20.5 8.9c13.3 14.3 34.2 23.8 63.5 23.8s50.2-9.6 63.5-23.8c5.3-5.7 12.7-8.9 20.5-8.9s15.2 3.2 20.5 8.9c13.3 14.3 34.2 23.8 63.5 23.8s50.2-9.6 63.5-23.8c5.3-5.7 12.7-8.9 20.5-8.9s15.2 3.2 20.5 8.9c13.3 14.3 34.2 23.8 63.5 23.8 15.1 0 27.3-12.5 26-27.5-1.1-12.9-2.8-24.8-5.2-35.7-5.5-25.6-15.2-47.8-32.5-65.1-19.4-19.4-45.7-29.1-72.3-33.9l0-89.8c0-15.5-12.5-28-28-28s-28 12.5-28 28l0 84.4c-8.9-.3-18.3-.4-28-.4l-56 0 0-84c0-15.5-12.5-28-28-28s-28 12.5-28 28l0 84-56 0c-9.7 0-19.1 .1-28 .4l0-84.4zM.5 364c-.5-15.5 12.1-28 27.6-28 24.6 0 47.5-4.8 67.4-14.5 10.4-5 22.7-5 33.2 0 19.9 9.6 42.8 14.5 67.4 14.5s47.5-4.8 67.4-14.5c10.4-5 22.7-5 33.2 0 19.9 9.6 42.8 14.5 67.4 14.5s47.5-4.8 67.4-14.5c10.4-5 22.7-5 33.2 0 19.9 9.6 42.8 14.5 67.4 14.5 15.5 0 28.1 12.5 27.6 28-.8 23.8-2.8 44.9-6.8 63.2-5.5 25.6-15.2 47.8-32.5 65.1s-39.5 27-65.1 32.5c-25.3 5.5-55.7 7.2-91.2 7.2l-168 0c-35.6 0-65.9-1.7-91.2-7.2-25.6-5.5-47.8-15.2-65.1-32.5s-27-39.5-32.5-65.1c-4-18.4-6-39.4-6.8-63.2z"],
    "signal-bars-good": [616, 560, ["signal-alt-3"], "f693", "M392 140c-30.9 0-56 25.1-56 56l0 280c0 15.5 12.5 28 28 28l28 0c30.9 0 56-25.1 56-56l0-252c0-30.9-25.1-56-56-56zM168 280c0-30.9 25.1-56 56-56l28 0c15.5 0 28 12.5 28 28l0 224c0 15.5-12.5 28-28 28l-56 0c-15.5 0-28-12.5-28-28l0-196zM0 364c0-30.9 25.1-56 56-56l28 0c15.5 0 28 12.5 28 28l0 140c0 15.5-12.5 28-28 28l-28 0c-30.9 0-56-25.1-56-56l0-84z"],
    "circle-info": [560, 560, ["info-circle"], "f05a", "M280 0C197 0 126.4 26.5 76.5 76.5S0 197 0 280 26.5 433.6 76.5 483.5 197 560 280 560 433.6 533.5 483.5 483.5 560 363 560 280 533.5 126.4 483.5 76.5 363 0 280 0zM238 154a42 42 0 1 1 84 0 42 42 0 1 1 -84 0zm-14 70l28 0c30.9 0 56 25.1 56 56l0 112 28 0c15.5 0 28 12.5 28 28s-12.5 28-28 28l-112 0c-15.5 0-28-12.5-28-28s12.5-28 28-28l28 0 0-112-28 0c-15.5 0-28-12.5-28-28s12.5-28 28-28z"],
    "layer-group": [560, 560, [], "f5fd", "M211.4 18.8C234.2 8.6 258.8 0 280 0s45.8 8.6 68.6 18.8c23.7 10.7 49.3 24.9 73.6 39.8 48.8 29.8 94.9 63.3 115.4 78.6 14.4 10.7 22.4 27.4 22.4 44.8s-8 34.1-22.4 44.8c-20.5 15.3-66.7 48.8-115.4 78.6-24.4 14.9-49.9 29.2-73.6 39.8-22.8 10.2-47.3 18.8-68.6 18.8s-45.8-8.6-68.6-18.8C187.7 334.6 162.2 320.3 137.8 305.4 89 275.6 42.9 242.1 22.4 226.8 8 216.1 0 199.4 0 182s8-34.1 22.4-44.8c20.5-15.3 66.6-48.8 115.4-78.6 24.4-14.9 49.9-29.2 73.6-39.8zM64.5 325c-9.8-6.5-22.6-6.2-32.1 .7-3.8 2.8-7.2 5.3-10.1 7.4-14.4 10.7-22.4 27.4-22.4 44.8s8 34.1 22.4 44.8c20.5 15.3 66.6 48.8 115.4 78.6 24.4 14.9 49.9 29.2 73.6 39.8 22.8 10.2 47.3 18.8 68.6 18.8s45.8-8.6 68.6-18.8c23.7-10.7 49.3-24.9 73.6-39.8 48.8-29.8 94.9-63.3 115.4-78.6 14.4-10.7 22.4-27.4 22.4-44.8s-8-34.1-22.4-44.8c-2.9-2.2-6.3-4.7-10.1-7.4-9.5-6.9-22.3-7.2-32.1-.7-14 9.3-28.9 18.9-44.1 28.2-25.4 15.5-53.2 31.1-79.9 43.1-23.9 10.7-57.7 23.7-91.5 23.7s-67.7-13-91.5-23.7c-26.7-12-54.5-27.6-79.9-43.1-15.2-9.3-30.1-18.8-44.1-28.2z"],
    "shield": [504, 560, [128737, "shield-blank"], "f132", "M228.9 553.8C201.7 543.5 144.2 515.7 93.5 451.8 42.5 387.6 0 288.9 0 140 0 113.8 12.5 87.4 36.9 72.7 86.7 42.4 139.7 24.4 179.7 13.9 202.5 8 227.9 0 252 0s49.5 8 72.3 13.9c40 10.5 92.9 28.5 142.8 58.7 24.3 14.8 36.9 41.1 36.9 67.3 0 148.9-42.5 247.6-93.5 311.8-50.7 63.9-108.2 91.7-135.4 102-15 5.7-31.2 5.7-46.2 0z"],
    "cart-shopping": [616, 560, [128722, "shopping-cart"], "f07a", "M28 28C12.5 28 0 40.5 0 56S12.5 84 28 84c18.6 0 34.4 13.5 37.4 31.8l38.5 235.9c6.9 42 37.8 78.5 82.9 85.8 32.7 5.3 78.9 10.5 135.2 10.5 64.2 0 107-6.7 133.3-13 28.3-6.9 47.7-27.5 58.4-49.8l64.8-135c6.2-13 9.5-27.3 9.5-41.7 0-53.3-43.2-96.4-96.4-96.4l-370.1 0C113.9 65.1 77.3 28 28 28zM140 518a42 42 0 1 1 84 0 42 42 0 1 1 -84 0zm294 42a42 42 0 1 0 0-84 42 42 0 1 0 0 84z"]
  };

  bunker(function () {
    defineIcons('fajfr', icons);
  });

}());
