/*!
 * Font Awesome Pro 7.1.0 by @fontawesome - https://fontawesome.com
 * License - https://fontawesome.com/license (Commercial License)
 * Copyright 2025 Fonticons, Inc.
 */
(function () {
  'use strict';

  var _WINDOW = {};
  var _DOCUMENT = {};
  try {
    if (typeof window !== 'undefined') _WINDOW = window;
    if (typeof document !== 'undefined') _DOCUMENT = document;
  } catch (e) {} // eslint-disable-line no-empty

  var _ref = _WINDOW.navigator || {},
    _ref$userAgent = _ref.userAgent,
    userAgent = _ref$userAgent === void 0 ? '' : _ref$userAgent;
  var WINDOW = _WINDOW;
  var DOCUMENT = _DOCUMENT;
  var IS_BROWSER = !!WINDOW.document;
  var IS_DOM = !!DOCUMENT.documentElement && !!DOCUMENT.head && typeof DOCUMENT.addEventListener === 'function' && typeof DOCUMENT.createElement === 'function';
  var IS_IE = ~userAgent.indexOf('MSIE') || ~userAgent.indexOf('Trident/');

  function _arrayLikeToArray(r, a) {
    (null == a || a > r.length) && (a = r.length);
    for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e];
    return n;
  }
  function _arrayWithoutHoles(r) {
    if (Array.isArray(r)) return _arrayLikeToArray(r);
  }
  function _defineProperty(e, r, t) {
    return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, {
      value: t,
      enumerable: !0,
      configurable: !0,
      writable: !0
    }) : e[r] = t, e;
  }
  function _iterableToArray(r) {
    if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r);
  }
  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }
  function ownKeys(e, r) {
    var t = Object.keys(e);
    if (Object.getOwnPropertySymbols) {
      var o = Object.getOwnPropertySymbols(e);
      r && (o = o.filter(function (r) {
        return Object.getOwnPropertyDescriptor(e, r).enumerable;
      })), t.push.apply(t, o);
    }
    return t;
  }
  function _objectSpread2(e) {
    for (var r = 1; r < arguments.length; r++) {
      var t = null != arguments[r] ? arguments[r] : {};
      r % 2 ? ownKeys(Object(t), !0).forEach(function (r) {
        _defineProperty(e, r, t[r]);
      }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) {
        Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r));
      });
    }
    return e;
  }
  function _toConsumableArray(r) {
    return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread();
  }
  function _toPrimitive(t, r) {
    if ("object" != typeof t || !t) return t;
    var e = t[Symbol.toPrimitive];
    if (void 0 !== e) {
      var i = e.call(t, r || "default");
      if ("object" != typeof i) return i;
      throw new TypeError("@@toPrimitive must return a primitive value.");
    }
    return ("string" === r ? String : Number)(t);
  }
  function _toPropertyKey(t) {
    var i = _toPrimitive(t, "string");
    return "symbol" == typeof i ? i : i + "";
  }
  function _unsupportedIterableToArray(r, a) {
    if (r) {
      if ("string" == typeof r) return _arrayLikeToArray(r, a);
      var t = {}.toString.call(r).slice(8, -1);
      return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0;
    }
  }

  var _dt;
  var q = {
      classic: {
        fa: "solid",
        fas: "solid",
        "fa-solid": "solid",
        far: "regular",
        "fa-regular": "regular",
        fal: "light",
        "fa-light": "light",
        fat: "thin",
        "fa-thin": "thin",
        fab: "brands",
        "fa-brands": "brands"
      },
      duotone: {
        fa: "solid",
        fad: "solid",
        "fa-solid": "solid",
        "fa-duotone": "solid",
        fadr: "regular",
        "fa-regular": "regular",
        fadl: "light",
        "fa-light": "light",
        fadt: "thin",
        "fa-thin": "thin"
      },
      sharp: {
        fa: "solid",
        fass: "solid",
        "fa-solid": "solid",
        fasr: "regular",
        "fa-regular": "regular",
        fasl: "light",
        "fa-light": "light",
        fast: "thin",
        "fa-thin": "thin"
      },
      "sharp-duotone": {
        fa: "solid",
        fasds: "solid",
        "fa-solid": "solid",
        fasdr: "regular",
        "fa-regular": "regular",
        fasdl: "light",
        "fa-light": "light",
        fasdt: "thin",
        "fa-thin": "thin"
      },
      slab: {
        "fa-regular": "regular",
        faslr: "regular"
      },
      "slab-press": {
        "fa-regular": "regular",
        faslpr: "regular"
      },
      thumbprint: {
        "fa-light": "light",
        fatl: "light"
      },
      whiteboard: {
        "fa-semibold": "semibold",
        fawsb: "semibold"
      },
      notdog: {
        "fa-solid": "solid",
        fans: "solid"
      },
      "notdog-duo": {
        "fa-solid": "solid",
        fands: "solid"
      },
      etch: {
        "fa-solid": "solid",
        faes: "solid"
      },
      jelly: {
        "fa-regular": "regular",
        fajr: "regular"
      },
      "jelly-fill": {
        "fa-regular": "regular",
        fajfr: "regular"
      },
      "jelly-duo": {
        "fa-regular": "regular",
        fajdr: "regular"
      },
      chisel: {
        "fa-regular": "regular",
        facr: "regular"
      },
      utility: {
        "fa-semibold": "semibold",
        fausb: "semibold"
      },
      "utility-duo": {
        "fa-semibold": "semibold",
        faudsb: "semibold"
      },
      "utility-fill": {
        "fa-semibold": "semibold",
        faufsb: "semibold"
      }
    };
  var i = "classic",
    t = "duotone",
    d = "sharp",
    l = "sharp-duotone",
    f = "chisel",
    n = "etch",
    h = "jelly",
    o = "jelly-duo",
    u = "jelly-fill",
    g = "notdog",
    s = "notdog-duo",
    y = "slab",
    m = "slab-press",
    e = "thumbprint",
    p = "utility",
    a = "utility-duo",
    w = "utility-fill",
    x = "whiteboard",
    b = "Classic",
    c = "Duotone",
    I = "Sharp",
    F = "Sharp Duotone",
    v = "Chisel",
    S = "Etch",
    A = "Jelly",
    P = "Jelly Duo",
    j = "Jelly Fill",
    B = "Notdog",
    N = "Notdog Duo",
    k = "Slab",
    D = "Slab Press",
    T = "Thumbprint",
    C = "Utility",
    W = "Utility Duo",
    K = "Utility Fill",
    R = "Whiteboard",
    dt = (_dt = {}, _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_dt, i, b), t, c), d, I), l, F), f, v), n, S), h, A), o, P), u, j), g, B), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_dt, s, N), y, k), m, D), e, T), p, C), a, W), w, K), x, R));
  var gt = {
      classic: {
        900: "fas",
        400: "far",
        normal: "far",
        300: "fal",
        100: "fat"
      },
      duotone: {
        900: "fad",
        400: "fadr",
        300: "fadl",
        100: "fadt"
      },
      sharp: {
        900: "fass",
        400: "fasr",
        300: "fasl",
        100: "fast"
      },
      "sharp-duotone": {
        900: "fasds",
        400: "fasdr",
        300: "fasdl",
        100: "fasdt"
      },
      slab: {
        400: "faslr"
      },
      "slab-press": {
        400: "faslpr"
      },
      whiteboard: {
        600: "fawsb"
      },
      thumbprint: {
        300: "fatl"
      },
      notdog: {
        900: "fans"
      },
      "notdog-duo": {
        900: "fands"
      },
      etch: {
        900: "faes"
      },
      chisel: {
        400: "facr"
      },
      jelly: {
        400: "fajr"
      },
      "jelly-fill": {
        400: "fajfr"
      },
      "jelly-duo": {
        400: "fajdr"
      },
      utility: {
        600: "fausb"
      },
      "utility-duo": {
        600: "faudsb"
      },
      "utility-fill": {
        600: "faufsb"
      }
    };
  var _t = {
      chisel: {
        regular: "facr"
      },
      classic: {
        brands: "fab",
        light: "fal",
        regular: "far",
        solid: "fas",
        thin: "fat"
      },
      duotone: {
        light: "fadl",
        regular: "fadr",
        solid: "fad",
        thin: "fadt"
      },
      etch: {
        solid: "faes"
      },
      jelly: {
        regular: "fajr"
      },
      "jelly-duo": {
        regular: "fajdr"
      },
      "jelly-fill": {
        regular: "fajfr"
      },
      notdog: {
        solid: "fans"
      },
      "notdog-duo": {
        solid: "fands"
      },
      sharp: {
        light: "fasl",
        regular: "fasr",
        solid: "fass",
        thin: "fast"
      },
      "sharp-duotone": {
        light: "fasdl",
        regular: "fasdr",
        solid: "fasds",
        thin: "fasdt"
      },
      slab: {
        regular: "faslr"
      },
      "slab-press": {
        regular: "faslpr"
      },
      thumbprint: {
        light: "fatl"
      },
      utility: {
        semibold: "fausb"
      },
      "utility-duo": {
        semibold: "faudsb"
      },
      "utility-fill": {
        semibold: "faufsb"
      },
      whiteboard: {
        semibold: "fawsb"
      }
    };
  var qt = {
      kit: {
        fak: "kit",
        "fa-kit": "kit"
      },
      "kit-duotone": {
        fakd: "kit-duotone",
        "fa-kit-duotone": "kit-duotone"
      }
    },
    Ht = ["kit"];
  var L = "kit",
    r = "kit-duotone",
    U = "Kit",
    J = "Kit Duotone",
    $t = _defineProperty(_defineProperty({}, L, U), r, J);
  var ol = {
    kit: {
      "fa-kit": "fak"
    },
    "kit-duotone": {
      "fa-kit-duotone": "fakd"
    }
  };
  var fl = {
      kit: {
        fak: "fa-kit"
      },
      "kit-duotone": {
        fakd: "fa-kit-duotone"
      }
    };
  var ul = {
      kit: {
        kit: "fak"
      },
      "kit-duotone": {
        "kit-duotone": "fakd"
      }
    };

  var _ml;
  var l$1 = {
      GROUP: "duotone-group",
      SWAP_OPACITY: "swap-opacity",
      PRIMARY: "primary",
      SECONDARY: "secondary"
    };
  var n$1 = "classic",
    o$1 = "duotone",
    u$1 = "sharp",
    s$1 = "sharp-duotone",
    h$1 = "chisel",
    g$1 = "etch",
    y$1 = "jelly",
    e$1 = "jelly-duo",
    m$1 = "jelly-fill",
    p$1 = "notdog",
    a$1 = "notdog-duo",
    w$1 = "slab",
    b$1 = "slab-press",
    r$1 = "thumbprint",
    c$1 = "utility",
    i$1 = "utility-duo",
    x$1 = "utility-fill",
    I$1 = "whiteboard",
    F$1 = "Classic",
    v$1 = "Duotone",
    S$1 = "Sharp",
    A$1 = "Sharp Duotone",
    P$1 = "Chisel",
    j$1 = "Etch",
    B$1 = "Jelly",
    N$1 = "Jelly Duo",
    k$1 = "Jelly Fill",
    D$1 = "Notdog",
    C$1 = "Notdog Duo",
    T$1 = "Slab",
    L$1 = "Slab Press",
    W$1 = "Thumbprint",
    R$1 = "Utility",
    K$1 = "Utility Duo",
    U$1 = "Utility Fill",
    J$1 = "Whiteboard",
    ml$1 = (_ml = {}, _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_ml, n$1, F$1), o$1, v$1), u$1, S$1), s$1, A$1), h$1, P$1), g$1, j$1), y$1, B$1), e$1, N$1), m$1, k$1), p$1, D$1), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_ml, a$1, C$1), w$1, T$1), b$1, L$1), r$1, W$1), c$1, R$1), i$1, K$1), x$1, U$1), I$1, J$1));
  var E$1 = "kit",
    d$1 = "kit-duotone",
    _$1 = "Kit",
    M$1 = "Kit Duotone",
    rt$1 = _defineProperty(_defineProperty({}, E$1, _$1), d$1, M$1);
  var $t$1 = {
      classic: {
        "fa-brands": "fab",
        "fa-duotone": "fad",
        "fa-light": "fal",
        "fa-regular": "far",
        "fa-solid": "fas",
        "fa-thin": "fat"
      },
      duotone: {
        "fa-regular": "fadr",
        "fa-light": "fadl",
        "fa-thin": "fadt"
      },
      sharp: {
        "fa-solid": "fass",
        "fa-regular": "fasr",
        "fa-light": "fasl",
        "fa-thin": "fast"
      },
      "sharp-duotone": {
        "fa-solid": "fasds",
        "fa-regular": "fasdr",
        "fa-light": "fasdl",
        "fa-thin": "fasdt"
      },
      slab: {
        "fa-regular": "faslr"
      },
      "slab-press": {
        "fa-regular": "faslpr"
      },
      whiteboard: {
        "fa-semibold": "fawsb"
      },
      thumbprint: {
        "fa-light": "fatl"
      },
      notdog: {
        "fa-solid": "fans"
      },
      "notdog-duo": {
        "fa-solid": "fands"
      },
      etch: {
        "fa-solid": "faes"
      },
      jelly: {
        "fa-regular": "fajr"
      },
      "jelly-fill": {
        "fa-regular": "fajfr"
      },
      "jelly-duo": {
        "fa-regular": "fajdr"
      },
      chisel: {
        "fa-regular": "facr"
      },
      utility: {
        "fa-semibold": "fausb"
      },
      "utility-duo": {
        "fa-semibold": "faudsb"
      },
      "utility-fill": {
        "fa-semibold": "faufsb"
      }
    },
    z = {
      classic: ["fas", "far", "fal", "fat", "fad"],
      duotone: ["fadr", "fadl", "fadt"],
      sharp: ["fass", "fasr", "fasl", "fast"],
      "sharp-duotone": ["fasds", "fasdr", "fasdl", "fasdt"],
      slab: ["faslr"],
      "slab-press": ["faslpr"],
      whiteboard: ["fawsb"],
      thumbprint: ["fatl"],
      notdog: ["fans"],
      "notdog-duo": ["fands"],
      etch: ["faes"],
      jelly: ["fajr"],
      "jelly-fill": ["fajfr"],
      "jelly-duo": ["fajdr"],
      chisel: ["facr"],
      utility: ["fausb"],
      "utility-duo": ["faudsb"],
      "utility-fill": ["faufsb"]
    },
    Ht$1 = {
      classic: {
        fab: "fa-brands",
        fad: "fa-duotone",
        fal: "fa-light",
        far: "fa-regular",
        fas: "fa-solid",
        fat: "fa-thin"
      },
      duotone: {
        fadr: "fa-regular",
        fadl: "fa-light",
        fadt: "fa-thin"
      },
      sharp: {
        fass: "fa-solid",
        fasr: "fa-regular",
        fasl: "fa-light",
        fast: "fa-thin"
      },
      "sharp-duotone": {
        fasds: "fa-solid",
        fasdr: "fa-regular",
        fasdl: "fa-light",
        fasdt: "fa-thin"
      },
      slab: {
        faslr: "fa-regular"
      },
      "slab-press": {
        faslpr: "fa-regular"
      },
      whiteboard: {
        fawsb: "fa-semibold"
      },
      thumbprint: {
        fatl: "fa-light"
      },
      notdog: {
        fans: "fa-solid"
      },
      "notdog-duo": {
        fands: "fa-solid"
      },
      etch: {
        faes: "fa-solid"
      },
      jelly: {
        fajr: "fa-regular"
      },
      "jelly-fill": {
        fajfr: "fa-regular"
      },
      "jelly-duo": {
        fajdr: "fa-regular"
      },
      chisel: {
        facr: "fa-regular"
      },
      utility: {
        fausb: "fa-semibold"
      },
      "utility-duo": {
        faudsb: "fa-semibold"
      },
      "utility-fill": {
        faufsb: "fa-semibold"
      }
    },
    G$1 = ["solid", "regular", "light", "thin", "duotone", "brands", "semibold"],
    O$1 = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
    V$1 = O$1.concat([11, 12, 13, 14, 15, 16, 17, 18, 19, 20]),
    $$1 = ["aw", "fw", "pull-left", "pull-right"],
    to = [].concat(_toConsumableArray(Object.keys(z)), G$1, $$1, ["2xs", "xs", "sm", "lg", "xl", "2xl", "beat", "border", "fade", "beat-fade", "bounce", "flip-both", "flip-horizontal", "flip-vertical", "flip", "inverse", "layers", "layers-bottom-left", "layers-bottom-right", "layers-counter", "layers-text", "layers-top-left", "layers-top-right", "li", "pull-end", "pull-start", "pulse", "rotate-180", "rotate-270", "rotate-90", "rotate-by", "shake", "spin-pulse", "spin-reverse", "spin", "stack-1x", "stack-2x", "stack", "ul", "width-auto", "width-fixed", l$1.GROUP, l$1.SWAP_OPACITY, l$1.PRIMARY, l$1.SECONDARY]).concat(O$1.map(function (t) {
      return "".concat(t, "x");
    })).concat(V$1.map(function (t) {
      return "w-".concat(t);
    }));

  var NAMESPACE_IDENTIFIER = '___FONT_AWESOME___';
  var PRODUCTION = function () {
    try {
      return "production" === 'production';
    } catch (e$$1) {
      return false;
    }
  }();
  function familyProxy(obj) {
    // Defaults to the classic family if family is not available
    return new Proxy(obj, {
      get: function get(target, prop) {
        return prop in target ? target[prop] : target[i];
      }
    });
  }
  var _PREFIX_TO_STYLE = _objectSpread2({}, q);

  // We changed FACSSClassesToStyleId in the icons repo to be canonical and as such, "classic" family does not have any
  // duotone styles.  But we do still need duotone in _PREFIX_TO_STYLE below, so we are manually adding
  // {'fa-duotone': 'duotone'}
  _PREFIX_TO_STYLE[i] = _objectSpread2(_objectSpread2(_objectSpread2(_objectSpread2({}, {
    'fa-duotone': 'duotone'
  }), q[i]), qt['kit']), qt['kit-duotone']);
  var PREFIX_TO_STYLE = familyProxy(_PREFIX_TO_STYLE);
  var _STYLE_TO_PREFIX = _objectSpread2({}, _t);

  // We changed FAStyleIdToShortPrefixId in the icons repo to be canonical and as such, "classic" family does not have any
  // duotone styles.  But we do still need duotone in _STYLE_TO_PREFIX below, so we are manually adding {duotone: 'fad'}
  _STYLE_TO_PREFIX[i] = _objectSpread2(_objectSpread2(_objectSpread2(_objectSpread2({}, {
    duotone: 'fad'
  }), _STYLE_TO_PREFIX[i]), ul['kit']), ul['kit-duotone']);
  var STYLE_TO_PREFIX = familyProxy(_STYLE_TO_PREFIX);
  var _PREFIX_TO_LONG_STYLE = _objectSpread2({}, Ht$1);
  _PREFIX_TO_LONG_STYLE[i] = _objectSpread2(_objectSpread2({}, _PREFIX_TO_LONG_STYLE[i]), fl['kit']);
  var PREFIX_TO_LONG_STYLE = familyProxy(_PREFIX_TO_LONG_STYLE);
  var _LONG_STYLE_TO_PREFIX = _objectSpread2({}, $t$1);
  _LONG_STYLE_TO_PREFIX[i] = _objectSpread2(_objectSpread2({}, _LONG_STYLE_TO_PREFIX[i]), ol['kit']);
  var LONG_STYLE_TO_PREFIX = familyProxy(_LONG_STYLE_TO_PREFIX);
  var _FONT_WEIGHT_TO_PREFIX = _objectSpread2({}, gt);
  var FONT_WEIGHT_TO_PREFIX = familyProxy(_FONT_WEIGHT_TO_PREFIX);
  var RESERVED_CLASSES = [].concat(_toConsumableArray(Ht), _toConsumableArray(to));

  function bunker(fn) {
    try {
      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }
      fn.apply(void 0, args);
    } catch (e) {
      if (!PRODUCTION) {
        throw e;
      }
    }
  }

  var w$2 = WINDOW || {};
  if (!w$2[NAMESPACE_IDENTIFIER]) w$2[NAMESPACE_IDENTIFIER] = {};
  if (!w$2[NAMESPACE_IDENTIFIER].styles) w$2[NAMESPACE_IDENTIFIER].styles = {};
  if (!w$2[NAMESPACE_IDENTIFIER].hooks) w$2[NAMESPACE_IDENTIFIER].hooks = {};
  if (!w$2[NAMESPACE_IDENTIFIER].shims) w$2[NAMESPACE_IDENTIFIER].shims = [];
  var namespace = w$2[NAMESPACE_IDENTIFIER];

  function normalizeIcons(icons) {
    return Object.keys(icons).reduce(function (acc, iconName) {
      var icon = icons[iconName];
      var expanded = !!icon.icon;
      if (expanded) {
        acc[icon.iconName] = icon.icon;
      } else {
        acc[iconName] = icon;
      }
      return acc;
    }, {});
  }
  function defineIcons(prefix, icons) {
    var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    var _params$skipHooks = params.skipHooks,
      skipHooks = _params$skipHooks === void 0 ? false : _params$skipHooks;
    var normalized = normalizeIcons(icons);
    if (typeof namespace.hooks.addPack === 'function' && !skipHooks) {
      namespace.hooks.addPack(prefix, normalizeIcons(icons));
    } else {
      namespace.styles[prefix] = _objectSpread2(_objectSpread2({}, namespace.styles[prefix] || {}), normalized);
    }

    /**
     * Font Awesome 4 used the prefix of `fa` for all icons. With the introduction
     * of new styles we needed to differentiate between them. Prefix `fa` is now an alias
     * for `fas` so we'll ease the upgrade process for our users by automatically defining
     * this as well.
     */
    if (prefix === 'fas') {
      defineIcons('fa', icons);
    }
  }

  var icons = {
    "0": [320, 512, [], "30", "M0 192C0 103.6 71.6 32 160 32s160 71.6 160 160l0 128c0 88.4-71.6 160-160 160S0 408.4 0 320L0 192zM160 96c-53 0-96 43-96 96l0 128c0 53 43 96 96 96s96-43 96-96l0-128c0-53-43-96-96-96z"],
    "1": [256, 512, [], "31", "M32 32l-32 0 0 64 96 0 0 320-96 0 0 64 256 0 0-64-96 0 0-384-128 0z"],
    "2": [384, 512, [], "32", "M48 32l203 0c60.2 0 109 48.8 109 109 0 43.8-26.2 83.3-66.4 100.4l-139.1 59C119 315.4 96 350.2 96 388.7l0 27.3 256 0 0 64-320 0 0-91.3c0-64.2 38.4-122.2 97.5-147.3l139.1-59c16.6-7.1 27.4-23.4 27.4-41.4 0-24.9-20.2-45-45-45L48 96 48 32z"],
    "3": [320, 512, [], "33", "M192 288l-144 0 0-64 144 0c35.3 0 64-28.7 64-64s-28.7-64-64-64L0 96 0 32 192 32c70.7 0 128 57.3 128 128 0 38.2-16.8 72.5-43.3 96 26.6 23.5 43.3 57.8 43.3 96 0 70.7-57.3 128-128 128l-192 0 0-64 192 0c35.3 0 64-28.7 64-64s-28.7-64-64-64z"],
    "4": [384, 512, [], "34", "M64 64l0-32-64 0 0 320 256 0 0 128 64 0 0-128 64 0 0-64-64 0 0-256-64 0 0 256-192 0 0-224z"],
    "5": [320, 512, [], "35", "M0 32l288 0 0 64-224 0 0 112 120 0c75.1 0 136 60.9 136 136S259.1 480 184 480l-184 0 0-64 184 0c39.8 0 72-32.2 72-72s-32.2-72-72-72L0 272 0 32z"],
    "6": [384, 512, [], "36", "M256 32l32 0 0 64-120 0c-48.6 0-88 39.4-88 88l0 32.2c22.9-15.3 50.4-24.2 80-24.2l48 0c79.5 0 144 64.5 144 144S287.5 480 208 480l-48 0C80.5 480 16 415.5 16 336l0-152C16 100.1 84.1 32 168 32l88 0zM80 336c0 44.2 35.8 80 80 80l48 0c44.2 0 80-35.8 80-80s-35.8-80-80-80l-48 0c-44.2 0-80 35.8-80 80z"],
    "7": [320, 512, [], "37", "M320 32l0 39.9-3.7 7-211.7 401.1-72.4 0 202.7-384-234.9 0 0-64 320 0z"],
    "8": [320, 512, [], "38", "M304 160c0-70.7-57.3-128-128-128l-32 0c-70.7 0-128 57.3-128 128 0 34.6 13.7 66 36 89-31.5 23.3-52 60.8-52 103 0 70.7 57.3 128 128 128l64 0c70.7 0 128-57.3 128-128 0-42.2-20.5-79.7-52-103 22.3-23 36-54.4 36-89zM176.1 288l15.9 0c35.3 0 64 28.7 64 64s-28.7 64-64 64l-64 0c-35.3 0-64-28.7-64-64s28.7-64 64-64l48.1 0zm0-64L144 224c-35.3 0-64-28.7-64-64 0-35.3 28.7-64 64-64l32 0c35.3 0 64 28.7 64 64 0 35.3-28.6 64-64 64z"],
    "9": [384, 512, [], "39", "M208 320c29.6 0 57.1-8.9 80-24.2l0 32.2c0 48.6-39.4 88-88 88l-136 0 0 64 136 0c83.9 0 152-68.1 152-152l0-152.1C351.9 96.4 287.5 32 208 32l-48 0C80.5 32 16 96.5 16 176S80.5 320 160 320l48 0zm80-144c0 44.2-35.8 80-80 80l-48 0c-44.2 0-80-35.8-80-80s35.8-80 80-80l48 0c44.2 0 80 35.8 80 80z"],
    "chess-pawn-piece": [320, 512, ["chess-pawn-alt"], "f444", "M256 128c0 24.6-9.2 47-24.4 64l24.4 0 0 48-29.3 0 13.3 144 64 80 0 48-288 0 0-48 64-80 13.3-144-29.3 0 0-48 24.4 0c-15.2-17-24.4-39.4-24.4-64 0-53 43-96 96-96s96 43 96 96z"],
    "dollar-sign": [320, 512, [128178, 61781, "dollar", "usd"], "24", "M136 0l48 0 0 64 88 0 0 64-146.9 0c-24.9 0-45.1 20.2-45.1 45.1 0 22.5 16.5 41.5 38.7 44.7l91.6 13.1c53.8 7.7 93.7 53.7 93.7 108 0 60.3-48.9 109.1-109.1 109.1l-10.9 0 0 64-48 0 0-64-104 0 0-64 162.9 0c24.9 0 45.1-20.2 45.1-45.1 0-22.5-16.5-41.5-38.7-44.7l-91.6-13.1C55.9 273.5 16 227.4 16 173.1 16 112.9 64.9 64 125.1 64l10.9 0 0-64z"],
    "layer-plus": [576, 512, ["layer-group-plus"], "f5ff", "M488-8l0-24-48 0 0 56-56 0 0 48 56 0 0 56 48 0 0-56 56 0 0-48-56 0 0-32zM16 224L288 352 560 224 288 96 16 224zm0 160L288 512 560 384 446.4 330.5 288 405 129.6 330.5 16 384z"],
    "grid-4": [448, 512, [], "e198", "M0 32l80 0 0 80-80 0 0-80zM0 154.7l80 0 0 80-80 0 0-80zM0 277.3l80 0 0 80-80 0 0-80zM80 400l0 80-80 0 0-80 80 0zm122.7 0l0 80-80 0 0-80 80 0zm42.7 0l80 0 0 80-80 0 0-80zM448 400l0 80-80 0 0-80 80 0zM202.7 277.3l0 80-80 0 0-80 80 0zm42.7 0l80 0 0 80-80 0 0-80zm202.7 0l0 80-80 0 0-80 80 0zM202.7 154.7l0 80-80 0 0-80 80 0zm42.7 0l80 0 0 80-80 0 0-80zm202.7 0l0 80-80 0 0-80 80 0zM202.7 32l0 80-80 0 0-80 80 0zm42.7 0l80 0 0 80-80 0 0-80zM448 32l0 80-80 0 0-80 80 0z"],
    "dog": [576, 512, [128021], "f6d3", "M64 144c0 17.7 14.3 32 32 32l179.1 0 140.9 60.4 0 275.6-96 0 0-163.3C296 361 268.8 368 240 368s-56-7-80-19.3l0 163.3-96 0 0-277.6C26.7 221.2 0 185.8 0 144l0-32 64 0 0 32zM392 0l72 0 32 32 80 0 0 48c0 44.2-35.8 80-80 80l-64 0-7 28-124.7-53.4 35.7-166.6 32 0 24 32zm56 44a20 20 0 1 0 0 40 20 20 0 1 0 0-40z"],
    "truck-moving": [640, 512, [], "f4df", "M480 32L0 32 0 424c0 48.6 39.4 88 88 88 25.2 0 48-10.6 64-27.6 16 17 38.8 27.6 64 27.6 40.3 0 74.2-27.1 84.7-64l134.6 0c10.4 36.9 44.4 64 84.7 64s74.2-27.1 84.7-64l35.3 0 0-237.3-9.4-9.4-64-64-9.4-9.4-77.3 0 0-96zm0 160l50.7 0 45.3 45.3 0 50.7-96 0 0-96zM88 384a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm392 40a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zM216 384a40 40 0 1 1 0 80 40 40 0 1 1 0-80z"],
    "rotate": [512, 512, [128260, "sync-alt"], "f2f1", "M512-8L433 71C332.7-25 173.6-23.7 75 75 25 125 0 190.5 0 256l64 0c0-49.2 18.7-98.3 56.2-135.8 73.6-73.6 192.2-75 267.5-3.9L312 192 512 192 512-8zM124.3 395.7L200 320 0 320 0 520 79 441c100.3 96 259.4 94.7 358-4 50-50 75-115.6 75-181l-64 0c0 49.2-18.7 98.3-56.2 135.8-73.6 73.6-192.2 75-267.5 3.9z"],
    "arrow-u-turn-up-left": [576, 512, [], "e7ed", "M176.2-29.2l45.2 45.2-80 80 210.7 0C455 96 538.9 176.7 544 278.1l.2 9.9c0 106-86 192-192 192l-256 0 0-64 256 0c70.7 0 128-57.3 128-128l-.2-6.6C476.7 213.8 420.7 160 352.2 160l-210.7 0 80 80-45.2 45.3-157.2-157.3 157.2-157.2z"],
    "keyboard-brightness": [640, 512, [], "e1c0", "M352 64l0 160-64 0 0-160 64 0zM112 130.7c8.2 8.2 37.1 37.1 86.6 86.6L221.3 240 176 285.3c-8.2-8.2-37.1-37.1-86.6-86.6L66.7 176 112 130.7zM573.3 176c-8.2 8.2-37.1 37.1-86.6 86.6L464 285.3 418.7 240c8.2-8.2 37.1-37.1 86.6-86.6L528 130.7 573.3 176zM0 352l128 0 0 64-128 0 0-64zm192 0l256 0 0 64-256 0 0-64zm320 64l0-64 128 0 0 64-128 0z"],
    "tent-double-peak": [576, 512, [], "e627", "M427.6 14.5C469.5 98.3 541.1 142.5 576 160l0 48-576 0 0-48c34.9-17.5 106.5-61.7 148.4-145.5 0 0 55.9 96 139.6 96s139.6-96 139.6-96zM0 512l0-256 576 0 0 256-160 0-128-192 0 192-288 0z"],
    "square-minus": [448, 512, [61767, "minus-square"], "f146", "M448 32l-448 0 0 448 448 0 0-448zM136 232l200 0 0 48-224 0 0-48 24 0z"],
    "water-arrow-up": [512, 512, ["water-rise"], "f775", "M233.6 9.4l22.6-22.6c5.5 5.5 39.7 39.7 102.6 102.6l22.6 22.6-45.3 45.3c-14.6-14.6-30.6-30.6-48-48l0 130.7-64 0 0-130.7-48 48-45.3-45.3c5.5-5.5 39.7-39.7 102.6-102.6zM136.2 286.2l8.9 3.6 111.1 44.4 111.1-44.4 8.9-3.6 8.9 3.6c83 33.2 125 50 126.3 50.5l-17.8 44.6c-2.7-1.1-41.9-16.7-117.4-46.9l-111.1 44.4-8.9 3.6-8.9-3.6-111.1-44.4c-75.5 30.2-114.7 45.9-117.4 47l-17.8-44.6 22.3-8.9 104-41.6 8.9-3.6zm0 128l8.9 3.6 111.1 44.4 111.1-44.4 8.9-3.6 8.9 3.6c83 33.2 125 50 126.3 50.5l-17.8 44.6c-2.7-1.1-41.9-16.7-117.4-46.9l-111.1 44.4-8.9 3.6-8.9-3.6-111.1-44.4c-75.5 30.2-114.7 45.9-117.4 47l-17.8-44.6 22.3-8.9 104-41.6 8.9-3.6z"],
    "xmark-to-slot": [576, 512, ["times-to-slot", "vote-nay"], "f771", "M96 32l384 0 0 352-384 0 0-352zM355.9 174.1l17-17-33.9-33.9c-8.5 8.5-25.5 25.5-50.9 50.9-25.5-25.5-42.4-42.4-50.9-50.9l-33.9 33.9c8.5 8.5 25.5 25.5 50.9 50.9-25.5 25.5-42.4 42.4-50.9 50.9l33.9 33.9c8.5-8.5 25.5-25.5 50.9-50.9 25.5 25.5 42.4 42.4 50.9 50.9l33.9-33.9c-8.5-8.5-25.5-25.5-50.9-50.9l33.9-33.9zM48 312l0 120 480 0 0-144 48 0 0 192-576 0 0-192 48 0 0 24z"],
    "sensor-cloud": [576, 512, ["sensor-smoke"], "e02c", "M64 32l448 0 0 256.3c-16.2-10.3-35.4-16.3-56-16.3-6 0-11.9 .5-17.7 1.5-22.7-20.8-53-33.5-86.3-33.5-69.4 0-125.8 55.2-127.9 124-29.3 23.4-48.1 59.5-48.1 100l0 16-112 0 0-448zM176 96l-48 0 0 160 48 0 0-160zm96 0l-48 0 0 151.2c13.8-14.6 30-26.8 48-36L272 96zM224 464c0-33.9 21.1-62.9 50.9-74.5-1.9-6.8-2.9-14-2.9-21.5 0-44.2 35.8-80 80-80 30.8 0 57.5 17.4 70.9 42.8 9.3-6.8 20.7-10.8 33.1-10.8 34.2 0 60.9 32 55.2 65.4 36.9 7.1 64.8 39.6 64.8 78.6l0 80-352 0 0-80z"],
    "lychee": [512, 512, [], "e824", "M231.6-1.7c8.7 2.7 16.8 6 24.6 9.8 4.9 2.3 9.4 4.8 13.8 7.5 12.6-4.9 26.8-8.1 42.3-8 21.5 22.5 38.8 51.7 56.3 79.6 22-13.2 40-24 54.1-32.5l34.7 34.7c-8.5 14.1-19.3 32.2-32.5 54.1 27.9 17.5 57.1 34.9 79.6 56.4 .1 15.5-3.1 29.8-8 42.3 7.1 11.6 12.9 24.4 17.3 38.5-7.6 12.5-16.4 23.5-26 33.1 1.9 13.4 2.4 27.5 1.2 41.9-11.7 8.6-23.8 15.5-36 21.2-2.8 13.2-6.9 26.6-12.1 39.8-13.5 4.5-26.9 7.7-40.2 10-6.1 12-13.1 23.9-21 35.5-14 1.2-27.7 1.5-41.2 1.1-8.4 10.5-17.5 20.8-27.4 30.7-13.9-1.5-27.5-3.7-40.7-6.7-10.3 8.8-21.2 17.2-33 24.9-13.5-4.2-26.3-9.3-38.6-15.2-12.1 6.3-25.3 11.3-39.4 14.8-11.9-8.3-22.5-17.8-31.4-28-13.5 1.1-27.6 .5-42-1.8-7.7-12.4-13.7-25.2-18-38-12.8-4.3-25.7-10.3-38-18-2.3-14.4-2.9-28.6-1.8-42-10.1-8.9-19.6-19.5-28-31.4 3.5-14.1 8.5-27.3 14.8-39.4-5.9-12.2-10.9-25.1-15.2-38.6 7.7-11.7 16.1-22.7 24.9-33-3-13.1-5.2-26.8-6.7-40.7 9.9-10 20.2-19.1 30.7-27.4-.4-13.5-.1-27.2 1.1-41.2 11.6-7.9 23.5-14.9 35.5-21 2.3-13.3 5.5-26.8 10-40.2 13.2-5.2 26.6-9.3 39.8-12.1 5.7-12.2 12.6-24.4 21.2-36 14.4-1.1 28.6-.7 41.9 1.2 9.6-9.5 20.6-18.3 33.1-26zM195.5 288.5c-30.7 6.1-49.3 9.9-55.7 11.1-1.3 6.4-5 25-11.1 55.7l-4.7 23.5 47.1 9.4c3.1-15.6 6.3-31.5 9.6-47.9 16.3-3.2 32.3-6.4 47.8-9.6l-9.4-47.1-23.5 4.7zm160-32c-30.7 6.1-49.3 9.9-55.7 11.1-1.3 6.4-5 25-11.1 55.7l-4.7 23.5 47.1 9.4c3.1-15.6 6.3-31.5 9.6-47.9 16.3-3.2 32.3-6.4 47.8-9.6l-9.4-47.1-23.5 4.7zm-128-128c-30.7 6.1-49.3 9.9-55.7 11.1-1.3 6.4-5 25-11.1 55.7l-4.7 23.5 47.1 9.4c3.1-15.6 6.3-31.5 9.6-47.9 16.3-3.3 32.3-6.4 47.8-9.6l-9.4-47.1-23.5 4.7z"],
    "align-justify": [448, 512, [], "f039", "M448 32l-448 0 0 64 448 0 0-64zm0 256l-448 0 0 64 448 0 0-64zM0 160l0 64 448 0 0-64-448 0zM448 416l-448 0 0 64 448 0 0-64z"],
    "sunglasses": [576, 512, [128374], "f892", "M72.4 32l103.6 0 0 64-56.4 0-49.2 160 185.6 0 0 32 64 0 0-32 185.6 0-49.2-160-56.4 0 0-64 103.6 0 7 22.6 64 208 1.4 4.6 0 212.8-256 0 0-128-64 0 0 128-256 0 0-212.8 1.4-4.6 64-208 7-22.6zM64 320l0 96 128-96-128 0zm320 0l0 96 128-96-128 0z"],
    "cloud-check": [576, 512, [], "e35c", "M240 32c55.4 0 103.5 31.3 127.6 77.1 14.2-8.3 30.8-13.1 48.4-13.1 53 0 96 43 96 96l0 49.1c38.3 22.1 64 63.5 64 110.9l0 128-576 0 0-144c0-62.7 40.1-116 96-135.8L96 176C96 96.5 160.5 32 240 32zM345.4 201.9L259.8 319.6c-19.3-20-33.7-34.9-43.2-44.7l-34.5 33.3c6.2 6.4 27.2 28.1 63.1 65.3l19.8 20.6 16.8-23.1 102.4-140.8 14.1-19.4-38.8-28.2-14.1 19.4z"],
    "message-minus": [512, 512, ["comment-alt-minus"], "f4a7", "M0 32l0 416 128 0 0 96 160-96 224 0 0-416-512 0zM169.6 216l196.8 0 0 48-220.8 0 0-48 24 0z"],
    "face-clouds": [640, 512, [], "e47d", "M62.4 32C27.8 32.9 0 61.2 0 96l0 64 288 0 0-64c0-34.8-27.8-63.1-62.4-64-9-36.7-42.1-64-81.6-64S71.4-4.7 62.4 32zm6.1 176c-2.9 15.5-4.5 31.6-4.5 48 0 113.4 73.8 209.7 176 243.3l0-35.3c0-40.5 18.8-76.5 48.1-100 1.7-55.3 38.4-101.8 88.8-117.9-5.5-5.7-8.9-13.5-8.9-22.1 0-17.7 14.3-32 32-32s32 14.3 32 32c0 6-1.7 11.7-4.6 16.5 28.8 2.5 54.8 14.6 74.9 33 5.8-1 11.7-1.5 17.7-1.5 19.8 0 38.4 5.5 54.1 15.2 1.2-10.2 1.9-20.6 1.9-31.2 0-141.4-114.6-256-256-256-15.5 0-30.7 1.4-45.5 4 36.5 18.5 61.5 56.3 61.5 100l0 104-68.3 0c2.7 4.7 4.3 10.2 4.3 16 0 17.7-14.3 32-32 32s-32-14.3-32-32c0-5.8 1.6-11.3 4.3-16L68.5 208zM288 464l0 80 352 0 0-80c0-39-27.9-71.5-64.8-78.6 5.7-33.5-21-65.4-55.2-65.4-12.4 0-23.9 4-33.1 10.8-13.4-25.5-40.1-42.8-70.9-42.8-44.2 0-80 35.8-80 80 0 7.4 1 14.6 2.9 21.5-29.8 11.6-50.9 40.6-50.9 74.5z"],
    "left-long-to-line": [640, 512, [], "e41e", "M320 64l-192 192 192 192 0-128 320 0 0-128-320 0 0-128zM0 96l0 352 64 0 0-384-64 0 0 32z"],
    "plane-landing-gear": [640, 512, [], "e7bc", "M240 64L401.3 240 552 240c30.9 0 56 25.1 56 56s-25.1 56-56 56l-504 0-32-176 48 0 51.2 64 103.5 0-58.7-176 80 0zM224 416a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm192-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "calendar-check": [448, 512, [], "f274", "M160 64l128 0 0-64 64 0 0 64 96 0 0 416-448 0 0-416 96 0 0-64 64 0 0 64zM308.5 167l-119.4 164.2-69.1-69.1-33.9 33.9 88.9 88.9 19.8 19.9 16.5-22.7 135.9-186.9 14.1-19.4-38.8-28.3-14.1 19.4z"],
    "square-ring": [448, 512, [], "e44f", "M448 32l-448 0 0 448 448 0 0-448zM128 256a96 96 0 1 0 192 0 96 96 0 1 0 -192 0zm96 160a160 160 0 1 1 0-320 160 160 0 1 1 0 320z"],
    "face-kiss": [512, 512, [128535, "kiss"], "f596", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM232 288l40 0c26.5 0 48 21.5 48 48 0 12.3-4.6 23.5-12.2 32 7.6 8.5 12.2 19.7 12.2 32 0 26.5-21.5 48-48 48l-48 0 0-32 32 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-32 0 0-32 32 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-32 0 0-32 8 0zm-88-80a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm192-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "circle-video": [512, 512, ["video-circle"], "e12b", "M0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm128-64l0 128c0 17.7 14.3 32 32 32l128 0c17.7 0 32-14.3 32-32l0-40 80 40 0-128-80 40 0-40c0-17.7-14.3-32-32-32l-128 0c-17.7 0-32 14.3-32 32z"],
    "cart-shopping-fast": [640, 512, [], "e0dc", "M64-16l116 0c2.1 11.7 5 27.7 8.7 48l451.2 0-48 256-356.7 0 8.7 48 300 0 0 48-340 0-3.6-19.7-60.4-332.3-76 0 0-48zM224 464a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm224 0a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM0 144l0-48 112 0 0 48-112 0zm0 96l0-48 128 0 0 48-128 0zm0 96l0-48 144 0 0 48-144 0z"],
    "desktop-arrow-down": [512, 512, [], "e155", "M280 32l0 158.1c23-23 39-39 48-48L361.9 176c-2.1 2.1-31.8 31.8-89 89l-17 17c-2.1-2.1-31.8-31.8-89-89l-17-17 33.9-33.9 48 48 0-182.1 48 0 0 24zM0 32l176 0 0 64-112 0 0 224 384 0 0-224-112 0 0-64 176 0 0 384-208 0 16 48 96 0 0 48-320 0 0-48 96 0 16-48-208 0 0-384z"],
    "banjo": [512, 512, [129685], "f8a3", "M367.1 99.7l8.9-35.7 72-64 64 64-64 72-35.7 8.9-81.1 81.1c13.9 20.6 23.4 44.3 27 70l25.7 0 0 48-25.7 0c-4.1 28.5-15.3 54.6-31.7 76.6l1.2 1.2 17 17-33.9 33.9-17-17-1.2-1.2c-22 16.5-48.1 27.7-76.6 31.7l0 25.7-48 0 0-25.7c-28.5-4.1-54.6-15.3-76.6-31.7l-1.2 1.2-17 17-33.9-33.9 17-17 1.2-1.2C41 398.6 29.8 372.5 25.7 344l-25.7 0 0-48 25.7 0c4.1-28.5 15.3-54.6 31.7-76.6l-1.2-1.2-17-17 33.9-33.9 17 17 1.2 1.2c22-16.5 48.2-27.7 76.6-31.7l0-25.7 48 0 0 25.7c25.7 3.7 49.5 13.1 70 27l81.1-81.1zM192 432a112 112 0 1 0 0-224 112 112 0 1 0 0 224zM161 303c37.2 37.2 58.8 58.8 65 65L192 401.9c-6.1-6.1-27.8-27.8-65-65l-17-17 33.9-33.9 17 17z"],
    "cloud-hail-mixed": [512, 512, [], "f73a", "M96 320l-96 0 0-96c0-41.8 26.7-77.4 64-90.5L64 112c0-61.9 50.1-112 112-112 43.1 0 80.5 24.3 99.2 60 14.7-17.1 36.5-28 60.8-28 44.2 0 80 35.8 80 80l0 16c53 0 96 43 96 96l0 96-416 0zM38.7 440l24-72 50.6 0-24 72-50.6 0zm376-72l50.6 0-48 144-50.6 0 48-144zm-120 0l50.6 0-24 72-50.6 0 24-72zm-112 0l50.6 0-48 144-50.6 0 48-144zM24 488a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm256-24a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"],
    "square-half-stroke": [448, 512, [], "e793", "M0 32l448 0 0 448-448 0 0-448zM224 416l160 0 0-320-160 0 0 320z"],
    "kitchen-set": [576, 512, [], "e51a", "M240 144a96 96 0 1 0 -192 0 96 96 0 1 0 192 0zm44.4 32C269.9 240.1 212.5 288 144 288 64.5 288 0 223.5 0 144S64.5 0 144 0c68.5 0 125.9 47.9 140.4 112l59.6 0 0-16 200 0 0 96-200 0 0-16-59.6 0zM144 80a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM424 240l0 32 120 0 0 48-288 0 0-48 120 0 0-32 48 0zM288 352l224 0 0 160-224 0 0-160zM176 320c26.5 0 48 21.5 48 48s-21.5 48-48 48l-16 0 0 32-128 0 0-128 144 0zm0 64c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0 0 32 16 0zm48 80l0 48-224 0 0-48 224 0z"],
    "dna": [384, 512, [129516], "f471", "M384 0l-64 0 0 32-256 0 0-32-64 0 0 32c0 57.8 24.4 104.8 57.4 144.5 24.1 28.9 53.8 55.1 83.6 79.5-29.8 24.5-59.5 50.6-83.6 79.5-33 39.6-57.4 86.7-57.4 144.5l0 32 64 0 0-32 256 0 0 32 64 0 0-32c0-57.8-24.4-104.8-57.4-144.5-24.1-28.9-53.8-55.1-83.6-79.5 29.8-24.5 59.5-50.6 83.6-79.5 33-39.6 57.4-86.7 57.4-144.5l0-32zM79.9 96l224.2 0c-5.6 10.9-12.5 21.5-20.6 32l-182.9 0c-8.2-10.5-15.1-21.1-20.6-32zM146 176l92 0c-14.3 13-29.8 25.8-46 39-16.2-13.1-31.7-26-46-39zM304.1 416L79.9 416c5.6-10.9 12.5-21.5 20.6-32l182.9 0c8.2 10.5 15.1 21.1 20.6 32zM238 336l-92 0c14.3-13 29.8-25.8 46-39 16.2 13.1 31.7 26 46 39z"],
    "circle-bangladeshi-taka": [512, 512, [], "e701", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM136 128l27.4 0c33.5 0 60.6 27.1 60.6 60.6l0 19.4 32 0 0 32-32 0 0 83.4c0 6.9 5.6 12.6 12.6 12.6l24 0c37.2 0 67.4-30.2 67.4-67.4l0-16c0-6.9-5.6-12.6-12.6-12.6l-3.4 0-24 0 0-48 24 0 3.4 0c33.5 0 60.6 27.1 60.6 60.6l0 16C376 332.3 324.3 384 260.6 384l-24 0c-33.5 0-60.6-27.1-60.6-60.6l0-83.4-29.7 0 0-32 29.7 0 0-19.4c0-6.9-5.6-12.6-12.6-12.6l-27.4 0 0-48z"],
    "box-circle-check": [576, 512, [], "e0c4", "M401.4 128l-290.7 0 34.3-48 222.1 0 34.3 48zM400 16l-288 0-80 112 0 352 225.4 0c-11.2-24.4-17.4-51.4-17.4-80 0-106 86-192 192-192 16.6 0 32.7 2.1 48 6l0-86-80-112zM576 400a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-73.6-51.5l-9.4 12.9-64 88-11 15.1c-4.4-4.4-22.1-22.1-53.2-53.2L353.4 400 376 377.4c5 5 17.7 17.7 38.1 38.1l53-72.9 9.4-12.9 25.9 18.8z"],
    "trillium": [448, 512, [], "e588", "M233.6 413.8l0 0c16.2 9.3 33.7 15 51.3 18.4-27.2 38.9-60.1 66.6-60.6 67-.6-.5-33.5-28.2-60.6-67 17.6-3.3 35.2-9 51.3-18.4l0 0 6.2-3.8c1.1-.7 2.1-1.4 3.1-2.2 3 2.1 6.1 4.1 9.3 5.9zM224.3 0c.5 .5 96 80.2 96 160 0 14.5-3.2 28.2-8.9 40.5 13.1 1.3 26.1 5.4 38.2 12.4 69.2 39.9 90.5 162.7 90.6 163.1-1 .4-117.6 43-186.6 3.1-11.8-6.8-21.7-15.8-29.3-26.1-7.6 10.3-17.5 19.3-29.3 26.1-69.1 39.9-185.8-2.9-186.6-3.1 .1-.3 21.4-123.2 90.6-163.1 12.1-7 25.1-11.1 38.2-12.4-5.7-12.3-8.9-26-8.9-40.5 0-79.7 95.4-159.5 96-160zm0 200a40 40 0 1 0 0 80 40 40 0 1 0 0-80zM98.9 104c-6.4 17.6-10.5 36.5-10.5 56 0 4.4 .2 8.8 .7 13.1-1.1 .5-2.3 1.1-3.4 1.6l-6.5 3.5 0 0c-15.9 9.2-29.5 21.3-41.1 34.6-21.4-44.3-29.3-89.2-29.4-89.7 .9-.3 42.4-15.3 90.4-19.2zm250.9 0c48 3.8 89.6 18.9 90.4 19.2-.2 .9-8.1 45.6-29.5 89.7-9.5-10.9-20.2-20.9-32.5-29.2l-8.6-5.3 0 0-6.5-3.5c-1.1-.6-2.3-1.1-3.4-1.6 .4-4.3 .7-8.6 .7-13.1 0-19.5-4.2-38.4-10.6-56z"],
    "delete-right": [640, 512, [], "e154", "M64 64l0 384 400 0 176-192-176-192-400 0zM372.9 205.1c-8.5 8.5-25.5 25.5-50.9 50.9 25.5 25.5 42.4 42.4 50.9 50.9l-33.9 33.9c-8.5-8.5-25.5-25.5-50.9-50.9-25.5 25.5-42.4 42.4-50.9 50.9l-33.9-33.9c8.5-8.5 25.5-25.5 50.9-50.9l-50.9-50.9 33.9-33.9 50.9 50.9c25.5-25.5 42.4-42.4 50.9-50.9l33.9 33.9z"],
    "circle-colon": [512, 512, [], "e6fc", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm23.2-394.9l-4.1 12.4c9.7 1.4 19 4 27.8 7.4 7.5-22.4 12.5-37.4 15-45.1l30.4 10.1c-2.2 6.7-7.9 23.6-16.9 50.6 10.3 7.5 19.4 16.5 27 26.6L320 208c-1.6-2.1-3.3-4.2-5.1-6.1L270.6 334.7c20.1-3.7 37.5-14.9 49.4-30.7l38.4 28.8c-23.3 31-60.5 51.2-102.4 51.2-.6 0-1.2 0-1.8 0-5 15-9 27.1-12.1 36.3l-30.4-10.1c3.4-10.1 6.8-20.3 10.2-30.7-9.4-2.6-18.3-6.2-26.7-10.7-9.3 27.8-15 44.9-17.2 51.5l-30.4-10.1c1.7-5 8.5-25.4 20.4-61.1-24.7-23.3-40.1-56.4-40.1-93.1 0-65.8 49.7-120 113.5-127.2l12.3-37 30.4 10.1-5.1 15.2zm8.5 65.4c-8.7-3.7-18.2-6-28.1-6.4L210.9 322c7.9 5.4 16.8 9.4 26.4 11.7l50.4-151.3zm-64.1 .4c-28 12.5-47.5 40.5-47.5 73.1 0 14.2 3.7 27.5 10.1 39l37.4-112.1z"],
    "child-reaching": [384, 512, [], "e59d", "M192.1 0a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm-16 384l0 128-64 0 0-273.2-8.6-10.3C40.2 152.6 6.7 112.4 3 107.9l49.2-41c5.3 6.4 35.6 42.8 90.9 109.1l99.3 0c54-66.1 83.8-102.4 89.1-109l49.5 40.5c-3.8 4.6-36.7 44.9-98.7 120.8l-9.6 11.7-.7 0 0 272-64 0 0-128-32 0z"],
    "face-confounded": [512, 512, [], "e36c", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM228.5 344.4l27.5 22c21-16.8 34-27.2 38.9-31.1 3.5 2.3 20.8 13.9 52 34.7 9.1-3 20.3-6.8 33.7-11.2l12.6 37.9c-11.8 3.9-26.1 8.7-43 14.3l-9.3 3.1c-.8-.5-15.5-10.3-44-29.3-21.7 17.4-35.4 28.3-41.1 32.9-5.6-4.5-19.3-15.5-41.1-32.9-28.5 19-43.2 28.8-44 29.3-9.8-3.3-49.3-16.4-52.3-17.4l12.6-37.9c13.4 4.5 24.6 8.2 33.7 11.2 31.2-20.8 48.5-32.4 52-34.7l11.4 9.1zM135.2 177.7l95.6 48 9.2 4.6 0 20.2-10.2 4.3-95.6 40-14.7-28.3 44.2-27.6-45.3-34 16.8-27.1zm146 48l95.6-48 16.8 27.1-45.3 34 44.2 27.6-14.7 28.3-95.6-40-10.2-4.3 0-20.2 9.2-4.6z"],
    "sidebar": [512, 512, [], "e24e", "M512 448l-256 0 0-384 256 0 0 384zM0 64l208 0 0 384-208 0 0-384zm160 64l-112 0 0 48 112 0 0-48zM48 216l0 48 112 0 0-48-112 0zm112 88l-112 0 0 48 112 0 0-48z"],
    "paste": [512, 512, ["file-clipboard"], "f0ea", "M352 0l-352 0 0 448 176 0 0-336-96 0 0-48 192 0 0 48 80 0 0-112zm64 160l-192 0 0 352 288 0 0-256-96-96z"],
    "inhaler": [640, 512, [], "f5f9", "M224 224l144 0 24.5-91.9 174.6 155.2-55.1 192.7-288 0 0-256zm357.7 12.1L406.3 80.2 432-16 640 32 581.7 236.1zM32 320a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM64 448a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm64-176a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM64 256a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm64 112a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "meteor": [512, 512, [9732], "f753", "M512 0L299.4 75.9 304 16 101.3 133.4C38.6 169.7 0 236.6 0 309 0 421.1 90.9 512 203 512 275.4 512 342.3 473.4 378.6 410.7L496 208 436.1 212.6 512 0zM192 192a128 128 0 1 1 0 256 128 128 0 1 1 0-256zm0 96a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm16 96a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"],
    "honey-pot": [448, 512, [127855], "e418", "M128 32l-96 0 0 64 32 0C25.1 125.2 0 171.7 0 224 0 400 128 480 128 480l192 0s128-80 128-256c0-52.3-25.1-98.8-64-128l32 0 0-64-240 0 0 128-48 0 0-128zM96.9 352C78.7 320.3 64 278.1 64 224l320 0c0 54.1-14.7 96.3-32.9 128L96.9 352z"],
    "laptop-slash": [640, 512, [], "e1c7", "M81.2-16.9l-17-17-33.9 33.9 17 17 512 512 17 17 33.9-33.9-32.1-32.1 6 0 56-56 0-40-158 0-288-288 318 0 0 240 64 0 0-304-446 0-48.9-48.9zM128 336l0-170-64-64 0 234 64 0zM442 480l-96-96-346 0 0 40 56 56 386 0z"],
    "gears": [640, 512, ["cogs"], "f085", "M464.7 261.9c10.4 1.4 20.4 4.2 29.9 8.1l53-35.3 49.8 49.8-35.3 53c1.9 4.7 3.7 9.6 5 14.7s2.3 10.2 3 15.2l57.1 28.2-18.2 68-63.5-4.1c-6.3 8.2-13.7 15.6-21.9 22l4.1 63.5-68 18.2-28.2-57c-10.4-1.4-20.4-4.2-30-8.1l-52.9 35.3-49.8-49.8 35.3-53c-1.9-4.7-3.6-9.6-5-14.7s-2.3-10.2-3-15.2l-57.1-28.2 18.2-68 63.5 4.1c6.3-8.2 13.6-15.6 21.9-22l-4.1-63.4 68-18.2 28.2 57zM448.1 340a44 44 0 1 0 0 88 44 44 0 1 0 0-88zM271.7-32.9l-4.1 63.4c8.3 6.4 15.6 13.8 21.9 22l63.5-4.1 18.2 68-57.1 28.2c-.7 5.1-1.6 10.2-3 15.2-1.4 5.1-3.1 10-5 14.7l35.3 53-49.8 49.8-53-35.3c-9.5 3.9-19.6 6.6-30 8.1l-28.2 57-68-18.2 4.1-63.5c-8.3-6.4-15.6-13.8-21.9-22l-63.5 4.2-18.2-68 57.1-28.3c.7-5.1 1.7-10.2 3-15.2 1.4-5.1 3.1-10 5-14.7L42.8 28.5 92.5-21.3 145.5 14c9.5-3.9 19.6-6.6 30-8.1l28.2-57 68 18.2zM192.1 84a44 44 0 1 0 .1 88 44 44 0 1 0 -.1-88z"],
    "wave-sine": [640, 512, [8767], "f899", "M58.2 148.8C77.4 97.8 126.1 64 180.6 64l4.5 0c56.1 0 106.5 34.1 127.3 86.2L387.5 338c11.1 27.8 38 46 67.9 46 30.5 0 57.8-18.9 68.5-47.4 16.8-44.8 28-74.8 33.7-89.8l59.9 22.5c-5.6 15-16.8 44.9-33.7 89.8-20.1 53.5-71.2 89-128.4 89-56.1 0-106.5-34.1-127.3-86.2L252.9 174c-11.1-27.8-38-46-67.9-46l-4.5 0c-27.8 0-52.6 17.2-62.4 43.2-18.1 48.3-29.9 79.7-35.2 94L23 242.7c5.4-14.3 17.1-45.6 35.2-94z"],
    "arrow-turn-left-up": [384, 512, [], "e634", "M352 448l32 0 0 64-224 0 0-402.7c-57.4 57.4-89.4 89.4-96 96l-45.3-45.3 22.6-22.6 128-128 22.6-22.6 22.6 22.6 128 128 22.6 22.6-45.3 45.3c-6.6-6.6-38.6-38.6-96-96l0 338.7 128 0z"],
    "garage": [576, 512, [], "e009", "M0 512l0-416 288-96 288 96 0 416-64 0 0-320-448 0 0 320-64 0zM464 320l-352 0 0-80 352 0 0 80zm0 192l-352 0 0-144 352 0 0 144zM224 416l0 48 128 0 0-48-128 0z"],
    "flatbread-stuffed": [576, 512, [129369], "e40c", "M436.1 40.2l-67.3 3.3-87-56-75.9 70.3-102.6 13-13 102.6-70.3 75.9 56 87-3.3 67.3 88.1-88.1c-10.5-14.5-16.6-32.3-16.6-51.5 0-48.6 39.4-88 88-88 19.2 0 37 6.2 51.5 16.6L436.1 40.2zM107.1 437c46.3 46.3 110.3 75 181 75 141.4 0 256-114.6 256-256 0-70.7-28.7-134.7-75-181l-362 362zm125-21a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm104-8a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm-40-56a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"],
    "u-turn-down-left": [512, 512, [], "e7ef", "M512 240c0 114.9-93.1 208-208 208l-144 0 0 96-160-160 160-160 0 96 144 0c44.2 0 80-35.8 80-80s-35.8-80-80-80l-240 0 0-128 240 0c114.9 0 208 93.1 208 208z"],
    "face-shaking-horizontal": [640, 512, [], "e79d", "M531.3 336L472 336c-13.3 0-24 10.7-24 24s10.7 24 24 24l37.8 0c-44.3 76.5-127 128-221.8 128-141.4 0-256-114.6-256-256S146.6 0 288 0C407.3 0 507.5 81.6 535.9 192l16.1 0c22.1 0 40-17.9 40-40s-17.9-40-40-40l-24 0 0-48 24 0c48.6 0 88 39.4 88 88s-39.4 88-88 88l-80 0c-13.3 0-24 10.7-24 24 0 13.2 10.7 23.9 23.9 24l80.1 0c33.4 0 64-12 87.6-32-4 44.9-41.7 80-87.6 80l-20.7 0zM163.8 319.5l-39.5 27.3C153.1 388.6 201.3 416 256 416s102.9-27.4 131.8-69.2l-39.5-27.3C328 348.9 294.2 368 256 368s-72-19.1-92.2-48.5zM148 216c0-11 9-20 20-20l16 0c11 0 20 9 20 20l0 16 40 0 0-16c0-33.1-26.9-60-60-60l-16 0c-33.1 0-60 26.9-60 60l0 16 40 0 0-16zm180-20l16 0c11 0 20 9 20 20l0 16 40 0 0-16c0-33.1-26.9-60-60-60l-16 0c-33.1 0-60 26.9-60 60l0 16 40 0 0-16c0-11 9-20 20-20z"],
    "eyes": [576, 512, [], "e367", "M96 224c-11.2 0-21.7 2.9-30.9 7.9 3.5-37.5 15.1-70.1 31-93.9 19.3-29 42.6-42 63.9-42s44.5 13 63.9 42c19.2 28.8 32.1 70.4 32.1 118s-12.9 89.2-32.1 118c-19.3 29-42.6 42-63.9 42s-44.5-13-63.9-42c-4.7-7-9-14.8-12.8-23.3 4.1 .8 8.4 1.3 12.7 1.3 35.3 0 64-28.7 64-64s-28.7-64-64-64zM288 120.6c-3.4-6.3-7-12.4-10.9-18.2-27-40.5-67.8-70.5-117.1-70.5S69.8 62 42.9 102.5C15.7 143.2 0 197.5 0 256S15.7 368.8 42.9 409.5C69.8 450 110.6 480 160 480s90.2-30 117.1-70.5c3.9-5.8 7.5-11.8 10.9-18.2 3.4 6.3 7 12.4 10.9 18.2 27 40.5 67.8 70.5 117.1 70.5s90.2-30 117.1-70.5C560.3 368.8 576 314.5 576 256s-15.7-112.8-42.9-153.5C506.2 62 465.4 32 416 32s-90.2 30-117.1 70.5c-3.9 5.8-7.5 11.8-10.9 18.2zm51.3 230.1c4.1 .8 8.4 1.3 12.7 1.3 35.3 0 64-28.7 64-64s-28.7-64-64-64c-11.2 0-21.7 2.9-30.9 7.9 3.5-37.5 15.1-70.1 31-93.9 19.4-29 42.6-42 63.9-42s44.5 13 63.9 42c19.2 28.8 32.1 70.4 32.1 118s-12.9 89.2-32.1 118c-19.4 29-42.6 42-63.9 42s-44.5-13-63.9-42c-4.7-7-9-14.8-12.8-23.3z"],
    "dash": [512, 512, ["minus-large"], "e404", "M0 224l512 0 0 64-512 0 0-64z"],
    "photo-film-music": [640, 512, [], "e228", "M192 0l416 0 0 181.3-73.5 13.4-70.5-114.6-84.7 137.7-43.3-57.7-96 128 112 0 0 64-160 0 0-352zM352 403.8c-15.3 3.8-29.7 10.5-42.1 19.7-17.1 12.8-31.9 32.2-36.5 56.4l-273.5 0 0-352 144 0 0 272 208 0 0 3.8zM320 96a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM104 184l-48 0 0 48 48 0 0-48zm0 96l-48 0 0 48 48 0 0-48zm0 96l-48 0 0 48 48 0 0-48zM624 255.8l0 208.1c0 23.3-18 35.4-29.1 40.5-11.9 5.4-25.4 7.5-34.9 7.5s-22.9-2.1-34.9-7.5c-11.1-5-29.1-17.2-29.1-40.5s18-35.4 29.1-40.5c11.9-5.4 25.4-7.5 34.9-7.5 4.6 0 10.1 .5 16 1.6l0-85-128 23.3 0 140.1c0 23.3-18 35.4-29.1 40.5-11.9 5.4-25.4 7.5-34.9 7.5s-22.9-2.1-34.9-7.5c-11.1-5-29.1-17.2-29.1-40.5s18-35.4 29.1-40.5c11.9-5.4 25.4-7.5 34.9-7.5 4.6 0 10.1 .5 16 1.6l0-181.8 19.7-3.6 176-32 28.3-5.1 0 28.8z"],
    "location-arrow-slash": [576, 512, [], "e77a", "M49.3-16.9l-17-17-33.9 33.9 17 17 512 512 17 17 33.9-33.9-17-17-162-162 128.8-317.1-317.1 128.8-161.7-161.7zM243.4 313.1l76.8 214.9 39.9-98.3-116.7-116.7zm-129-129L16.1 224 231.1 300.8 114.4 184.1z"],
    "circle-m": [512, 512, [], "e115", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM144 168l0-24 36.2 0 7.2 9.8 68.6 93.6 68.6-93.6 7.2-9.8 36.2 0 0 224-48 0 0-126.7c-34 46.3-55.3 75.4-64 87.3-8.7-11.8-30-40.9-64-87.3l0 126.7-48 0 0-200z"],
    "arrow-up-to-dotted-line": [384, 512, [], "e0a1", "M0 0L64 0 64 64 0 64 0 0zM192 114.7l22.6 22.6 128 128 22.6 22.6-45.3 45.3c-6.6-6.6-38.6-38.6-96-96l0 274.7-64 0 0-274.7c-57.4 57.4-89.4 89.4-96 96l-45.3-45.3 22.6-22.6 128-128 22.6-22.6zM170.7 0l0 64-64 0 0-64 64 0zm42.7 0l64 0 0 64-64 0 0-64zM384 0l0 64-64 0 0-64 64 0z"],
    "file-circle-plus": [576, 512, [58606], "e494", "M272 0l-240 0 0 512 244 0c-22.7-31.5-36-70.2-36-112 0-100.6 77.4-183.2 176-191.3L416 144 272 0zm85.5 176L240 176 240 58.5 357.5 176zM432 544a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm16-208l0 48 64 0 0 32-64 0 0 64-32 0 0-64-64 0 0-32 64 0 0-64 32 0 0 16z"],
    "mustache": [640, 512, [], "e5bc", "M192 112l-8 0-6.4 4.8-83.5 62.7C51.3 155.7 20 138.3 0 127.2l0 80.1 0 0c0 106.4 86.2 192.6 192.6 192.6 46.7 0 91.7-16.9 126.9-47.7l.5-.4 .5 .4C355.6 383.1 400.7 400 447.4 400 553.8 400 640 313.8 640 207.4l0 0c0-26 0-52.7 0-80.1-20 11.1-51.3 28.5-94 52.2l-83.6-62.7-6.4-4.8-99 0c-1 1.2-13.3 15.6-37 43.1-23.6-27.6-35.9-41.9-37-43.1l-91 0z"],
    "window-frame": [448, 512, [129695], "e04f", "M416 448l32 0 0 64-448 0 0-64 32 0 0-448 384 0 0 448zM352 224l0-160-96 0 0 160 96 0zm-96 64l0 160 96 0 0-160-96 0zm-64-64l0-160-96 0 0 160 96 0zM96 288l0 160 96 0 0-160-96 0z"],
    "house-night": [640, 512, [], "e010", "M88 56c0-38.1 24.2-70.5 58-82.7-10.7-3.4-22.1-5.3-34-5.3-61.9 0-112 50.1-112 112S50.1 192 112 192c40.6 0 76.1-21.6 95.8-53.9-9.9 3.8-20.6 5.9-31.8 5.9-48.6 0-88-39.4-88-88zM557.5 336l50.5 0 0-40-240-216-240 216 0 40 50.5 0 0 208 379.1 0 0-208zM522.7 74.7L480 96 522.7 117.3 544 160 565.3 117.3 608 96 565.3 74.7 544 32 522.7 74.7zM256-32L234.7 10.7 192 32 234.7 53.3 256 96 277.3 53.3 320 32 277.3 10.7 256-32zm64 320l96 0 0 96-96 0 0-96z"],
    "reel": [448, 512, [], "e238", "M32 0l384 0 0 64-32 0 0 32-320 0 0-32-32 0 0-64zM384 448l32 0 0 64-384 0 0-64 32 0 0-32 320 0 0 32zm0-312l0 48-320 0 0-48 320 0zm64 96l0 48-384 0 0-48 384 0zM64 328l320 0 0 48-320 0 0-48z"],
    "icicles": [512, 512, [], "f7ad", "M96 352l-96-352 512 0-96 512-80-352-48 192-48-160-48 224-48-224-48 160z"],
    "binary-slash": [576, 512, [], "e33e", "M49.3-16.9l-17-17-33.9 33.9 17 17 512 512 17 17 33.9-33.9c-.6-.6-33.3-33.3-98.1-98.1l0-126-126 0-66-66 0-222-192 0 0 30-46.8-46.8zM160.1 94l0-30 64 0 0 94-64-64zM442.3 512l-154.2-154.2 0 154.2 154.2 0zM352.1 0l-32 0 0 64 48 0 0 96-48 0 0 64 160 0 0-64-48 0 0-160-80 0zm-224 288l-32 0 0 64 48 0 0 96-48 0 0 64 160 0 0-64-48 0 0-160-80 0z"],
    "square-sliders-vertical": [448, 512, ["sliders-v-square"], "f3f2", "M0 32l448 0 0 448-448 0 0-448zM168 96l-48 0 0 64-56 0 0 48 56 0 0 208 48 0 0-208 56 0 0-48-56 0 0-64zm160 24l0-24-48 0 0 208-56 0 0 48 56 0 0 64 48 0 0-64 56 0 0-48-56 0 0-184z"],
    "arrow-trend-up": [640, 512, [], "e098", "M384.3 96l224 0 0 224-64 0 0-114.7-169.4 169.4-22.6 22.6c-1.3-1.3-44-44-128-128l-137.4 137.4-22.6 22.6-45.3-45.3 22.6-22.6 160-160 22.6-22.6c1.3 1.3 44 44 128 128l146.7-146.7-114.7 0 0-64z"],
    "timeline-arrow": [640, 512, [], "e29d", "M208.4 16l-160 0 0 160 48 0 0 48-64 0 0 64 192 0 0 48-48 0 0 160 160 0 0-160-48 0 0-48 224 0 0 73.9c26.1-26.1 55.8-55.8 89-89l17-17c-16.3-16.3-98.1-98.1-105.9-105.9l0 73.9-96 0 0-48 48 0 0-160-160 0 0 160 48 0 0 48-192 0 0-48 48 0 0-160z"],
    "fort": [576, 512, [], "e486", "M64 32l-64 0 0 224 32 0 0 256 512 0 0-256 32 0 0-224-64 0 0 64-32 0 0-64-64 0 0 64-32 0 0-64-64 0 0 128-64 0 0-128-64 0 0 64-32 0 0-64-64 0 0 64-32 0 0-64zM352 320l0 144-128 0 0-144 128 0z"],
    "circle-v": [512, 512, [], "e12a", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM233.9 353.4l-89.5-209.4 52.2 0 59.4 138.9 59.4-138.9 52.2 0-89.5 209.4-2.8 6.6-38.5 0-2.8-6.6z"],
    "hexagon-nodes-bolt": [576, 512, [], "e69a", "M280 56c0 22.3-13.1 41.6-32 50.6l0 98.8c3.4 1.6 6.6 3.6 9.6 5.8L280 224l0 32 0 4.4 8.9 5.1c-9.3 13-16.9 27.2-22.4 42.5l-10.5-6c-2.5 1.8-5.2 3.3-8 4.7l0 98.8c5.3 2.5 10.2 5.9 14.4 9.9c4.1 14.7 10 28.6 17.6 41.5c-.4 30.6-25.3 55.2-56 55.2c-30.9 0-56-25.1-56-56c0-22.3 13.1-41.6 32-50.6l0-98.8c-3.4-1.6-6.6-3.6-9.6-5.8L168 288l0-32 0-4.4L88 206c-2.6 1.8-5.3 3.3-8 4.7l0 90.8c2.8 1.3 5.5 2.9 8 4.7l48-27.4 0 9.4 0 18.6 16.1 9.2 7.8 4.5-48.1 27.5c1.6 20.8-8.6 41.7-27.8 52.8C57.2 416 23 406.8 7.5 380S1.2 319 28 303.5c1.3-.8 2.6-1.5 4-2.1l0-90.8c-1.3-.6-2.7-1.3-4-2.1C1.2 193-8 158.8 7.5 132S57.2 96 84 111.5c19.3 11.1 29.4 32 27.9 52.8L192 210.1c2.5-1.8 5.2-3.3 8-4.7l0-98.8c-18.9-9-32-28.3-32-50.6c0-30.9 25.1-56 56-56s56 25.1 56 56zM432 192c-25.2 0-49.1 5.3-70.8 14.8c-.4-.3-.8-.6-1.3-.9l-48 27.4 0-9.4 0-18.6-16.1-9.2-7.8-4.5 48.1-27.5c-1.6-20.8 8.6-41.6 27.8-52.8c26.8-15.5 61-6.3 76.5 20.5c11.2 19.4 9.5 42.8-2.6 60.1c-2-.1-3.9-.1-5.9-.1zm0 32a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm24 64L352 384l66.7 0L408 448l104-96-66.7 0L456 288z"],
    "light-emergency-on": [640, 512, [], "e420", "M69.3 36l-20-13.3-26.6 39.9c8.6 5.8 31.3 20.9 68 45.3l20 13.3 26.6-39.9-68-45.3zM597.3 76l20-13.3-26.6-39.9c-8.6 5.8-31.3 20.9-68 45.3l-20 13.3 26.6 39.9c8.6-5.8 31.3-20.9 68-45.3zM24 192l-24 0 0 48 120 0 0-48-96 0zm520 0l-24 0 0 48 120 0 0-48-96 0zM320 32c-88.4 0-160 71.6-160 160l0 112 320 0 0-112c0-88.4-71.6-160-160-160zM256 200l0 8-48 0 0-8c0-66.3 53.7-120 120-120l8 0 0 48-8 0c-39.8 0-72 32.2-72 72zM544 352l-448 0 0 128 448 0 0-128z"],
    "question": [320, 512, [10067, 10068, 61736], "3f", "M320 160C320.1 71.6 248.4 0 160.1 0 71.7 0 0 71.6 0 160l0 32 64 0 0-32c0-53 43-96 96-96 53 0 96 43 96 96 0 33.2-17.3 65.4-48 83.2-50.7 29.3-77.3 44.6-80 46.2l0 94.7 64 0 0-57.7 48-27.7c51.3-29.6 80-83.4 80-138.5zM192 448l-64 0 0 64 64 0 0-64z"],
    "square-lira": [448, 512, [], "e6e7", "M448 32l-448 0 0 448 448 0 0-448zM143.5 216c0-46.5 37.5-88 88.1-88l2.2 0c19.7 0 38.8 6.4 54.5 18.2l14.2 10.6-28.8 38.4-14.2-10.6C252 179 243 176 233.7 176l-2.2 0c-23 0-40.1 18.9-40 40l96.5 0 0 32-87.5 0c2.1 7.9 3.2 16 3.5 24l84 0 0 32-88 0c-3.2 11.3-8.3 22.1-15.1 32l135.1 0 0 48-200 0 0-42.5c1.1-1.4 9-11.6 23.7-30.5 1.7-2.2 3.3-4.6 4.7-7l-20.4 0 0-32 27.9 0c-.4-6.4-1.8-12.9-4.3-19l-1.4-3.5c-.2-.5-.4-1-.6-1.5l-21.6 0 0-32 15.5 0z"],
    "square-dashed-circle-plus": [576, 512, [], "e5c2", "M64 32l-32 0 0 112 64 0 0-48 48 0 0-64-80 0zM32 192l0 128 64 0 0-128-64 0zM96 368l-64 0 0 112 225.4 0c-9.1-19.8-14.9-41.3-16.8-64L96 416 96 368zM432 208c16.6 0 32.7 2.1 48 6l0-182-112 0 0 64 48 0 0 112.7c5.3-.4 10.6-.7 16-.7zM320 96l0-64-128 0 0 64 128 0zM432 544a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm16-208l0 48 64 0 0 32-64 0 0 64-32 0 0-64-64 0 0-32 64 0 0-64 32 0 0 16z"],
    "chair-office": [448, 512, [], "f6c1", "M352 0l0 240-256 0 0-240 256 0zM64 160l0 96-64 0 0-128 64 0 0 32zm384 0l0 96-64 0 0-128 64 0 0 32zM32 384l0-96 384 0 0 96-160 0 0 64 64 0 0 64-192 0 0-64 64 0 0-64-160 0z"],
    "user-magnifying-glass": [640, 512, [], "e5c5", "M256.4 248c21 0 40.7-5.4 57.8-14.8 10.7-12.1 23.1-22.7 36.8-31.4 15.9-20.4 25.4-46 25.4-73.8 0-66.3-53.7-120-120-120s-120 53.7-120 120 53.7 120 120 120zm-144 56l-64 208 386.3 0c-90.2-3-162.3-77-162.3-167.9 0-13.8 1.7-27.2 4.8-40.1l-164.8 0zm352 208l-.5-1.5c-5.9 .8-11.8 1.3-17.9 1.5l18.3 0zm-24-239.9a72 72 0 1 1 0 144 72 72 0 1 1 0-144zm0 192c24.5 0 47.2-7.3 66.2-19.9 47.9 47.9 73.8 73.8 77.8 77.8l33.9-33.9c-4-4-29.9-30-77.8-77.8 12.6-19 19.9-41.7 19.9-66.2 0-66.3-53.7-120-120-120s-120 53.7-120 120 53.7 120 120 120z"],
    "container-storage": [576, 512, [], "f4b7", "M0 32l576 0 0 48-32 0 0 352 32 0 0 48-576 0 0-48 32 0 0-352-32 0 0-48zm120 96l0 256 48 0 0-256-48 0zm240 0l-48 0 0 256 48 0 0-256zm48 0l0 256 48 0 0-256-48 0zm-144 0l-48 0 0 256 48 0 0-256z"],
    "arrow-left-to-bracket": [512, 512, [], "e669", "M160 96l-96 0 0 320 128 0 0 64-192 0 0-448 192 0 0 64-32 0zm9.4 182.6l-22.6-22.6 22.6-22.6 128-128 22.6-22.6 45.3 45.3c-6.6 6.6-38.6 38.6-96 96l242.7 0 0 64-242.7 0 96 96-45.3 45.3-150.6-150.6z"],
    "sparkle": [576, 512, [], "e5d6", "M213.3 181.3L288-16 362.7 181.3 560 256 362.7 330.7 288 528 213.3 330.7 16 256 213.3 181.3z"],
    "campfire": [512, 512, [], "f6ba", "M228.5 0c-38.8 24.2-116.4 93.1-116.4 174.5 0 80.3 65.1 145.5 145.5 145.5S403 254.9 403 174.5c0-24.2-17.5-87.3-87.3-145.5L286.6 58.2 228.5 0zm87.3 218.3c0 32.1-26.1 58.2-58.2 58.2s-58.2-26-58.2-58.2c0-43.6 58.2-87.3 58.2-87.3s58.2 43.6 58.2 87.3zm154.8 80.8l-214.4 67.4-214.4-67.4-19.2 61.1 126.9 39.9-126.9 39.9 19.2 61.1 214.4-67.4 214.4 67.4 19.2-61.1-126.9-39.9 126.9-39.9-19.2-61.1z"],
    "hands-bound": [576, 512, [], "e4f9", "M64 32l0-32-64 0 0 235.8 7.7 9 91.9 107.2-27.6 0 0 48 432 0 0-48-27.6 0 91.9-107.2 7.7-9 0-235.8-64 0 0 163.9-76.2 86.4-35.7-24.2c29.6-33.3 50-56.2 61-68.7l-47.8-42.5c-7 7.9-35.5 39.9-85.3 95.9l-8.1 9.1 0 132.2-64 0 0-132.2-8.1-9.1c-49.8-56-78.2-88-85.3-95.9l-47.8 42.5c11.1 12.5 31.4 35.4 61 68.7L140.2 250.3 64 163.9 64 32zM96 432l-24 0 0 48 56 0 0 32 128 0 0-32 64 0 0 32 128 0 0-32 56 0 0-48-408 0z"],
    "panel-fire": [576, 512, [], "e42f", "M32 32l448 0 0 129.4-2.9-2.5-29.1 29.1-32-32 0-60-320 0 0 128 179 0c-2.9 3.4-5.8 6.8-8.6 10.3-14.2 17.8-27.9 38.6-38.6 62-1.3-.2-2.6-.3-3.9-.3-13.3 0-24 10.7-24 24 0 9.2 5.2 17.2 12.7 21.2-3 13.7-4.7 27.9-4.7 42.6 0 34.7 8.5 67.4 23.5 96.2L32 480 32 32zM152 320a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM384 191.9l64 64 32-32c76.8 64 96 133.3 96 160 0 88.4-71.6 160-160 160s-160-71.6-160-160c0-89.6 85.3-165.3 128-192zM480 432c0-48-64-96-64-96s-64 48-64 96c0 35.3 28.7 64 64 64s64-28.7 64-64z"],
    "clock-seven-thirty": [512, 512, [], "e351", "M256 0a256 256 0 1 0 0 512 256 256 0 1 0 0-512zM232 392l0-56.7c-14.5 21.7-25.6 38.4-33.3 50l-39.9-26.6c.4-.6 26.2-39.3 77.3-116l44 13.3 0 160-48 0 0-24z"],
    "tugrik-sign": [384, 512, [], "e2ba", "M32 32l-32 0 0 64 160 0 0 111.3C79 227.5 37.3 237.9 34.9 238.5l11.6 46.6c4.4-1.1 42.2-10.6 113.5-28.4l0 46.5C79 323.5 37.3 333.9 34.9 334.5l11.6 46.6c4.4-1.1 42.2-10.6 113.5-28.4l0 127.3 64 0 0-143.3c81-20.2 122.7-30.7 125.1-31.3l-11.6-46.6c-4.4 1.1-42.2 10.6-113.5 28.4l0-46.5c81-20.2 122.7-30.7 125.1-31.3l-11.6-46.6c-4.4 1.1-42.2 10.6-113.5 28.4l0-95.3 160 0 0-64-352 0z"],
    "audio-description-slash": [576, 512, [], "e0a8", "M32.3-33.8C33-33.2 65.6-.6 130.2 64l414 0 0 384-30 0c36.4 36.4 57.8 57.8 64.1 64.1l-33.9 33.9-17-17-512-512-17-17 33.9-33.9zM352.1 208l24 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24l-6 0 39.7 39.7c22.8-12.1 38.3-36.1 38.3-63.7l0-48c0-39.8-32.2-72-72-72l-72 0 0 78 48 48 0-78zm-80 133.8l106.2 106.2-346.2 0 0-346.2 100 100c-2.6 6.9-4 14.4-4 22.2l0 128 48 0 0-48 48 0 0 48 48 0 0-10.2z"],
    "face-thermometer": [512, 512, [], "e39a", "M256 512c141.4 0 256-114.6 256-256 0-3.2-.1-6.4-.2-9.6l-9.6 9.2-26.9-26.9-22.6 22.6 26.5 26.5-25.8 24.9-26.1-26.1-22.6 22.6 25.6 25.6-25.8 24.9-25.2-25.2-22.6 22.6 28 28-23.1 15.9-.6 .5-.1-.1-12.7 8.8C328 371.1 294.2 352 256 352s-72 19.1-92.2 48.5l-39.5-27.3c28.8-41.8 77.1-69.2 131.8-69.2 22.1 0 43.2 4.5 62.3 12.6L457 182.4C468.2 171.5 483.9 168.1 498 172.2 463.2 72 368 0 256 0 114.6 0 0 114.6 0 256S114.6 512 256 512zM176 176a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm128 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"],
    "lightbulb-cfl-on": [640, 512, [], "e5a7", "M294.8 69L160 96 160 32C255.8 12.8 309.1 2.2 320 0l0 64-25.2 5zM480 128l-320 64 0-64 320-64 0 64zM160 224l320-64 0 64-320 64 0-64zM416 384l0 128-192 0 0-128 32 0 0-82.6 48-9.6 0 92.2 32 0 0-99.2 144-28.8 0 64-96 19.2 0 44.8 32 0zM58.7 26.5l53.5 26.7-21.5 42.9C60.3 81 19.5 60.6 15.8 58.7L37.3 15.8 58.7 26.5zm544 42.9C579.6 81 561.8 89.9 549.3 96.2L527.8 53.3C558.2 38 599 17.7 602.7 15.8l21.5 42.9-21.5 10.7zM24 168l56 0 0 48-80 0 0-48 24 0zm560 0l56 0 0 48-80 0 0-48 24 0zM90.7 341.5C67.6 353 49.8 361.9 37.3 368.2L15.8 325.3C46.2 310 87 289.7 90.7 287.8l21.5 42.9-21.5 10.7zm458.5-53.7l74.9 37.5-21.5 42.9-74.9-37.5 21.5-42.9z"],
    "clock-three": [512, 512, [], "e356", "M256 0a256 256 0 1 1 0 512 256 256 0 1 1 0-512zM232 120l0 160 152 0 0-48-104 0 0-136-48 0 0 24z"],
    "person-walking-luggage": [576, 512, [], "e554", "M408.5 24a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zm-104 88l-13.3 0-9.4 9.4-80 80-9.4 9.4 0 95.6-28.7 57.4c-41.1-20.5-63.2-31.6-66.4-33.2l-79.2 158.3-7.2 14.3 14.3 7.2 80 40 14.3 7.2 7.2-14.3 38.4-76.8 .8 .4 72-144 1.4-2.7 17.2 0 0-82.7 32-32 0 69.3c0 28 12.2 54.7 33.5 72.9l80.6 69.1c11 71.6 17.4 112.9 19.1 123.9l63.3-9.7c-1.4-9-8.3-54.2-20.9-135.6l-1.8-11.7-9-7.7-52.8-45.3 0-115.2c17.6 22 28.4 35.6 32.6 40.8l111.4 0 0-64-80.6 0-54.4-68-9.6-12-95.4 0zM288.6 371L276 415.2c-44.7 44.7-71.6 71.6-80.8 80.8l45.3 45.3c8.2-8.2 37.1-37.1 86.6-86.6l5.9-5.9c.8-2.7 3.8-13.2 9-31.5l-46-39.4c-2.5-2.2-5-4.4-7.4-6.8z"],
    "file-arrow-down": [384, 512, ["file-download"], "f56d", "M0 0L240 0 384 144 384 512 0 512 0 0zM208 58.5L208 176 325.5 176 208 58.5zM175 441l17 17c3.5-3.5 30.5-30.5 81-81l17-17-33.9-33.9c-10.3 10.3-23.6 23.6-40 40l0-110.1-48 0 0 110.1c-16.4-16.4-29.7-29.7-40-40L94.1 360c3.5 3.5 30.5 30.5 81 81z"],
    "person-booth": [576, 512, [], "f756", "M152 24A56 56 0 1 0 40 24 56 56 0 1 0 152 24zM64 112l-32 0 0 160c0 30.2 14.2 58.7 38.4 76.8l89.6 67.2 0 128 64 0 0-160-12.8-9.6-67.2-50.4 0-80.1c16.7 23.4 27.2 38.1 31.5 44.1l112.5 0 0-64-79.5 0-70.4-98.6-9.6-13.4-64.5 0zM32 512l0 32 64 0 0-116-54.4-40.8c-3.3-2.5-6.5-5.1-9.6-7.9L32 512zM280 0l-24 0 0 176 48 0 0-82.7 80 146.7-32 208 176 0 0 96 48 0 0-544-296 0zm24 336l-48 0 0 208 48 0 0-208z"],
    "locust": [576, 512, [], "e520", "M360 32c116.6 0 211.6 92.4 215.8 208l.2 0 0 80c0 44.2-35.8 80-80 80l-12.4 0 45.7 80-55.3 0-45.7-80-80.4 0-55.4 80-58.3 0 55.4-80-53 0-59.8 80-59.9 0 64.9-86.9-41.2-15.7-81 102.6-61.2 0 270.7-342.9 25-31.7c9.7 22.5 22.1 51.6 37.4 87.2 30.2-40.4 52.2-69.8 66.1-88.4 6.7 15.6 26.1 60.8 58.2 135.7l72 0C523.7 150.9 450.1 80 360 80l-72 0 0-48 72 0zM56.3 345.2l-24.3-9.2 0-96 108.4 0-84.2 105.2zM488 296a24 24 0 1 0 0 48 24 24 0 1 0 0-48zM249.1 240l47.2 0 2.1-2.8-16.6-38.6-32.7 41.5zm107.1 0l47.4 0-17.3-40.3-30.2 40.3z"],
    "window": [512, 512, [], "f40e", "M512 64l-512 0 0 384 512 0 0-384zM128 128l0 64-64 0 0-64 64 0zm32 0l64 0 0 64-64 0 0-64zm160 0l0 64-64 0 0-64 64 0z"],
    "right-long": [576, 512, ["long-arrow-alt-right"], "f30b", "M576 256l-192-192 0 128-384 0 0 128 384 0 0 128 192-192z"],
    "truck-droplet": [576, 512, [], "e58c", "M416 32L0 32 0 448 67.3 448c10.4 36.9 44.4 64 84.7 64s74.2-27.1 84.7-64l102.6 0c10.4 36.9 44.4 64 84.7 64s74.2-27.1 84.7-64l67.3 0 0-237.3-9.4-9.4-64-64-9.4-9.4-77.3 0 0-96zm96 205.3l0 50.7-96 0 0-96 50.7 0 45.3 45.3zM152 384a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm232 40a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zM208 304c-39.8 0-72-32.2-72-72 0-48 72-120 72-120s72 72 72 120-32.2 72-72 72z"],
    "hand-holding-medical": [576, 512, [], "e05c", "M240 0l96 0 0 80 80 0 0 96-80 0 0 80-96 0 0-80-80 0 0-96 80 0 0-80zM66.7 384l70.6-70.6 9.4-9.4 237.3 0 0 64-128 0 0 48 138.8 0c73.3-50.4 115.7-79.6 127.5-87.6l45.3 65.9c-6.1 4.2-59.8 41.1-161 110.7l-10.2 7-396.4 0 0-128 66.7 0z"],
    "hand-point-left": [512, 512, [], "f0a5", "M0 96l0 64 240 0 0-64-240 0zM160 288l0 64 128 0 0-64-128 0zm-32-32l112 0 0-64-112 0 0 64zm64 128l0 64 128 0 0-64-128 0zM363 64l-91 0 0 192 80 0 0-112 32 0 0 144-64 0 0 64 32 0 0 96c88.4 0 160-71.6 160-160l0-61.7c0-42.4-16.9-83.1-46.9-113.1l-11.6-11.6C429.5 77.5 396.9 64 363 64z"],
    "calculator": [384, 512, [128425], "f1ec", "M384 0L0 0 0 512 384 512 384 0zM320 64l0 96-256 0 0-96 256 0zM64 208l48 0 0 48-48 0 0-48zm152 0l0 48-48 0 0-48 48 0zm56 0l48 0 0 48-48 0 0-48zM112 304l0 48-48 0 0-48 48 0zm56 0l48 0 0 48-48 0 0-48zm152 0l0 48-48 0 0-48 48 0zM64 400l160 0 0 48-160 0 0-48zm256 0l0 48-48 0 0-48 48 0z"],
    "oil-temperature": [640, 512, ["oil-temp"], "f614", "M592 368s48 64 48 96-21.5 48-48 48-48-21.5-48-48c0-32 48-96 48-96zM209.2 224c-10.9 18.8-17.2 40.7-17.2 64 0 70.7 57.3 128 128 128s128-57.3 128-128c0-11.9-1.7-23.4-4.7-34.4l4.7 2.4 160-32 32 32-208 224-336 0 0-69.3-96-42.7 0-144 209.2 0zM416 64l-64 0 0 32 64 0 0 64-64 0 0 54.7c28.2 12.3 48 40.5 48 73.3 0 44.2-35.8 80-80 80s-80-35.8-80-80c0-32.8 19.8-61 48-73.3L288 0 416 0 416 64zM48 336.8l48 21.3 0-86.1-48 0 0 64.8z"],
    "minus": [448, 512, [8211, 8722, 10134, "subtract"], "f068", "M0 224l448 0 0 64-448 0 0-64z"],
    "message-arrow-down": [512, 512, ["comment-alt-arrow-down"], "e1db", "M0 32l0 416 128 0 0 96 160-96 224 0 0-416-512 0zM239 337c-57.2-57.2-86.8-86.8-89-89L184 214.1c9 9 25 25 48 48l0-126.1 48 0 0 126.1c23-23 39-39 48-48L361.9 248c-2.1 2.1-31.8 31.8-89 89l-17 17-17-17z"],
    "shoe": [640, 512, [], "e6d8", "M0 336l0-160 192 0 32-112 48 0 74.8 67.3c-33.6 33.6-53.9 53.9-60.7 60.7L320 225.9c6.6-6.6 27.4-27.4 62.5-62.5l31.6 28.5C391 215 375 231 366.1 240L400 273.9c7.6-7.6 26.4-26.4 56.5-56.5l101.4 39c36.5 14.1 63.9 43.7 75.7 79.6L0 336zm0 48l640 0 0 64-352 0-96-32 0 32-192 0 0-64z"],
    "game-board-simple": [448, 512, ["game-board-alt"], "f868", "M0 32l448 0 0 448-448 0 0-448zM224 96l0 160 160 0 0-160-160 0zm0 160l-160 0 0 160 160 0 0-160z"],
    "arrow-turn-left": [576, 512, [], "e632", "M480.3 416l0 32 64 0 0-224-402.7 0c57.4-57.4 89.4-89.4 96-96l-45.3-45.3-22.6 22.6-128 128-22.6 22.6 22.6 22.6 128 128 22.6 22.6 45.3-45.3c-6.6-6.6-38.6-38.6-96-96l338.7 0 0 128z"],
    "circle-4": [512, 512, [], "e0f1", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM224 144l0 112 48 0 0-112 48 0 0 112 32 0 0 48-32 0 0 64-48 0 0-64-96 0 0-160 48 0z"],
    "hammer-war": [448, 512, [], "f6e4", "M256 0l0 59.4 192-27.4 0 256-224-32-224 32 0-256 192 27.4 0-59.4 64 0zM224 304.5l32 4.6 0 234.9-64 0 0-234.9 32-4.6z"],
    "light-emergency": [448, 512, [], "e41f", "M64 192c0-88.4 71.6-160 160-160s160 71.6 160 160l0 112-320 0 0-112zm168-64l8 0 0-48-8 0c-66.3 0-120 53.7-120 120l0 8 48 0 0-8c0-39.8 32.2-72 72-72zM448 480l-448 0 0-128 448 0 0 128z"],
    "arrow-up-z-a": [512, 512, ["sort-alpha-up-alt"], "f882", "M150.9 41.4L128.3 18.7c-5.5 5.5-39.7 39.7-102.6 102.6L3 144 48.3 189.3c14.6-14.6 30.6-30.6 48-48l0 338.7 64 0 0-338.7c17.4 17.4 33.4 33.4 48 48L253.5 144c-5.5-5.5-39.7-39.7-102.6-102.6zM448.3 32l-160 0 0 64 82.7 0-73.4 73.4-9.4 9.4 0 45.3 192 0 0-64-82.7 0 73.4-73.4 9.4-9.4 0-45.3-32 0zm-94 224l-7.9 20.5-78.3 203.5 68.6 0 12.3-32 70.5 0 12.3 32 68.6 0-78.3-203.5-7.9-20.5-60 0zm30 100.3l16.8 43.7-33.6 0 16.8-43.7z"],
    "microphone-slash": [576, 512, [], "f131", "M49.3-16.9l-17-17-33.9 33.9 17 17 512 512 17 17 33.9-33.9-153.4-153.4c34.1-34.7 55.2-82.2 55.2-134.7l0-64-48 0 0 64c0 39.2-15.7 74.8-41.2 100.8L357 290.9c16.8-17.3 27.1-40.9 27.1-66.9l0-224-192 0 0 126-142.8-142.8zM298 367.7c-3.3 .2-6.5 .3-9.8 .3-79.5 0-144-64.5-144-144l0-10.2-48-48 0 58.2c0 97.9 73.3 178.7 168 190.5l0 49.5-72 0 0 48 192 0 0-48-72 0 0-49.5c9.3-1.2 18.4-3 27.3-5.4L298 367.7z"],
    "square-pen": [448, 512, ["pen-square", "pencil-square"], "f14b", "M448 32l-448 0 0 448 448 0 0-448zM112 288l95-95 80 80-95 95-96 16 16-96zm256-96l-47 47-80-80 47-47 80 80z"],
    "bell-plus": [512, 512, [], "f849", "M224 0l64 0 0 35.2C361 50 416 114.6 416 192l0 96 80 128-480 0 80-128 0-96c0-77.4 55-142 128-156.8L224 0zm32 512c-29.8 0-54.9-20.4-62-48l124 0c-7.1 27.6-32.2 48-62 48zM232 320l48 0 0-72 72 0 0-48-72 0 0-72-48 0 0 72-72 0 0 48 72 0 0 72z"],
    "hand-fist": [384, 512, [9994, "fist-raised"], "f6de", "M192 0l0 144-64 0 0-144 64 0zM32 32l64 0 0 112-64 0 0-112zm192 0l64 0 0 160-64 0 0-160zm96 64l64 0 0 128-64 0 0-128zM0 253.7l0-77.7 192 0 0 80-112 0 0 32 144 0 0-64 64 0 0 32 96 0c0 52.3-25.1 98.8-64 128l0 128-224 0 0-110.4c-17.3-7.9-33.2-18.8-46.9-32.5l-2.3-2.3C16.9 336.9 0 296.2 0 253.7z"],
    "pants": [512, 512, [], "e6d5", "M97 0l318.6 0 15 77.9 .4 2.1-78.7 0 0 48 87.9 0 70.4 365.9-188.5 36.3-65-338.1-1.4 0-65 338.1-188.5-36.3 70.4-365.9 87.9 0 0-48-78.7 0 .4-2.1 15-77.9z"],
    "comment-sms": [512, 512, ["sms"], "f7cd", "M512 240c0 132.5-114.6 240-256 240-38.3 0-74.7-7.9-107.3-22.1L0 512 55.7 389.5C20.8 348.5 0 296.5 0 240 0 107.5 114.6 0 256 0S512 107.5 512 240zM140.8 172.8c-23 0-41.6 18.6-41.6 41.6S117.8 256 140.8 256c5.3 0 9.6 4.3 9.6 9.6s-4.3 9.6-9.6 9.6l-41.6 0 0 32 41.6 0c23 0 41.6-18.6 41.6-41.6S163.8 224 140.8 224c-5.3 0-9.6-4.3-9.6-9.6s4.3-9.6 9.6-9.6l35.2 0 0-32-35.2 0zm188.8 41.6c0 23 18.6 41.6 41.6 41.6 5.3 0 9.6 4.3 9.6 9.6s-4.3 9.6-9.6 9.6l-41.6 0 0 32 41.6 0c23 0 41.6-18.6 41.6-41.6S394.2 224 371.2 224c-5.3 0-9.6-4.3-9.6-9.6s4.3-9.6 9.6-9.6l35.2 0 0-32-35.2 0c-23 0-41.6 18.6-41.6 41.6zm-19.2-25.6l0-16c-27 0-19.7 0-30.1 0l-4.5 8.5-20 37.8c-16.7-30.3-25.2-45.8-25.5-46.3-14.1 0-14.3 0-28.7 0l0 134.4 32 0 0-61.9c4.6 8.4 12.2 22.1 22.7 41.2 10.2-19.2 17.6-33.1 22.1-41.8l0 62.5 32 0 0-118.4z"],
    "head-side-gear": [512, 512, [], "e611", "M224 0C338.4 0 432.7 85.7 446.3 196.4l49.7 59.6 0 64-64 0 0 128-112 0 0 64-256 0 0-131.2C24.4 340.4 0 285 0 224 0 100.3 100.3 0 224 0zm32 97.2l0-33.2-64 0 0 33.2c-12.7 4.3-24.2 11-34 19.7l-28.8-16.6-32 55.4 28.8 16.6c-1.3 6.4-1.9 12.9-1.9 19.7s.7 13.3 1.9 19.7l-28.8 16.6 32 55.4 28.8-16.6c9.8 8.7 21.4 15.4 34.1 19.7l0 33.2 64 0 0-33.2c12.7-4.3 24.2-11 34.1-19.7l28.8 16.6 32-55.4-28.8-16.6c1.3-6.4 1.9-12.9 1.9-19.7s-.7-13.3-1.9-19.7l28.8-16.6-32-55.4-28.8 16.6c-9.8-8.7-21.4-15.4-34-19.7zM184 192a40 40 0 1 1 80 0 40 40 0 1 1 -80 0z"],
    "transporter-1": [640, 512, [], "e043", "M320 80a56 56 0 1 0 0-112 56 56 0 1 0 0 112zm-51.1 32l-16.3 0-9.6 13.2-92.9 128-18.8 25.9 51.8 37.6c9.3-12.8 28.3-39 56.9-78.4l0 65.7 160 0 0-65.7c28.6 39.4 47.6 65.6 56.9 78.4l51.8-37.6c-.2-.2-37.4-51.6-111.7-153.9l-9.6-13.2-118.5 0zM400 496l-240 0 0 48 320 0 0-48-80 0zM576 160l-16-48-16 48-48 16 48 16 16 48 16-48 48-16-48-16zM96 352l-16-48-16 48-48 16 48 16 16 48 16-48 48-16-48-16zm128 0l0 32 192 0 0-32-192 0zm0 64l0 32 192 0 0-32-192 0z"],
    "scanner-touchscreen": [512, 512, [], "f48a", "M256-32l0 80-64 0 0-80 64 0zM416 224l-48 0 0-256 48 0 0 256zM320-32l0 80-32 0 0-80 32 0zm128 0l64 0 0 256-64 0 0-256zM64 160l0 288 192 0 0-288-192 0zM0 96l320 0 0 416-320 0 0-416z"],
    "flask-round-potion": [384, 512, ["flask-potion"], "f6e1", "M64 64l32 0 0 89.7C38.7 186.9 0 248.9 0 320 0 426 86 512 192 512s192-86 192-192c0-71.1-38.7-133.1-96-166.3l0-89.7 32 0 0-64-256 0 0 64zm96 109.3l0-109.3 64 0 0 130.3 19.2 8.4c45.3 19.8 76.8 64.9 76.8 117.4 0 5.4-.3 10.8-1 16l-18.7 0c-29 0-57.5-7.9-82.3-22.8l-9.6-5.8c-21.2-12.7-45.4-19.4-70.1-19.4-17.3 0-34.5 3.3-50.6 9.7l-23 9.2c4.7-46.8 34.7-86.2 76.2-104.3l19.2-8.4 0-20.9z"],
    "car-bolt": [512, 512, [], "e341", "M120 32l-22.7 0-7.5 21.4-48.5 138.6-41.3 0 0 288 96 0 0-64 320 0 0 64 96 0 0-288-41.3 0-48.5-138.6-7.5-21.4-294.7 0zM64 304a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm352-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM304 80l-24.9 112 88.9 0-160 144 24.9-112-88.9 0 160-144z"],
    "table-rows": [448, 512, ["rows"], "e292", "M0 32l448 0 0 448-448 0 0-448zM128 96l0 128 256 0 0-128-256 0zM384 288l-256 0 0 128 256 0 0-128z"],
    "cloud-slash": [576, 512, [], "e137", "M49.3-17l-17-17-33.9 33.9 17 17 512 512 17 17 33.9-33.9-64-64 61.9 0 0-96c0-47.4-25.7-88.7-64-110.9l0-49.1c0-53-43-96-96-96-17.7 0-34.2 4.8-48.4 13.1-24.1-45.8-72.2-77.1-127.6-77.1-39.2 0-74.8 15.7-100.8 41.1L49.3-17zm361 497L96.5 166.2c-.2 3.3-.3 6.5-.3 9.8l0 24.2C40.2 220 .1 273.3 .1 336l0 144 410.2 0z"],
    "face-hand-yawn": [512, 512, [], "e379", "M430.9 443C480.8 396.3 512 329.8 512 256 512 114.6 397.4 0 256 0S0 114.6 0 256c0 73.2 30.7 139.2 80 185.9l0-137.9 81.3 0c7.6-45.4 47.1-80 94.7-80 45.3 0 83.2 31.3 93.3 73.5 26.8 26.8 72.7 72.7 86.5 86.5l-32 32c9.6 9.6 18.6 18.6 27 27zM225.7 131.7c-2.3 1.8-35.2 28.2-98.7 79l-18.7 15-30-37.5c2.3-1.8 35.2-28.2 98.7-79l18.7-15 30 37.5zm79.3 15l-18.7-15 30-37.5c2.3 1.8 35.2 28.2 98.7 79l18.7 15-30 37.5c-2.3-1.8-35.2-28.2-98.7-79zM128 352l0 122.2c0 56.2 45.6 101.8 101.8 101.8 27 0 52.9-10.7 72-29.8l82.2-82.2-32-32-48 48-16-16 80-80-32-32-80 80-16-16 64-64-32-32-96 96 0-64-48 0z"],
    "tickets": [640, 512, [], "e658", "M96 32l512 0 0 128c-26.5 0-48 21.5-48 48s21.5 48 48 48l0 128-512 0 0-128c26.5 0 48-21.5 48-48s-21.5-48-48-48L96 32zM464 144l0 128-224 0 0-128 224 0zM240 96l-48 0 0 224 320 0 0-224-272 0zM48 152l0 280 464 0 0 48-512 0 0-352 48 0 0 24z"],
    "sim-card": [384, 512, [], "f7c4", "M0 0L285.3 0 294.6 9.4 384 98.7 384 512 0 512 0 0zM64 256l0 72 128 0 0-72-128 0zm0 192l80 0 0-72-80 0 0 72zm256 0l0-72-128 0 0 72 128 0zm0-192l-80 0 0 72 80 0 0-72z"],
    "shield-quartered": [512, 512, [], "e575", "M256 0l11.6 4.5 207.5 80.5 19.2 7.4 1.2 20.5c2.9 50-4.9 126.3-37.3 200.9-32.7 75.3-91.1 150-189.4 192.6l-12.7 5.5-12.7-5.5C144.9 463.9 86.6 389.2 53.9 313.9 21.5 239.3 13.7 162.9 16.6 113L17.8 92.5 37 85 244.5 4.5 256 0zM80.1 137c.3 24.7 3.5 54.9 11.1 87l164.8 0 0-155.3-176 68.3zM256 441.9c72.8-35.5 117.2-93.2 143.5-153.5 9.4-21.6 16.4-43.4 21.4-64.4l-164.9 0 0 217.9z"],
    "square-ellipsis-vertical": [448, 512, [], "e26f", "M448 32l-448 0 0 448 448 0 0-448zM256 192l-64 0 0-64 64 0 0 64zm0 32l0 64-64 0 0-64 64 0zm0 160l-64 0 0-64 64 0 0 64z"],
    "oven": [448, 512, [], "e01d", "M0 0L448 0 448 512 0 512 0 0zM104 112a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm72 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm120-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm72 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm16 88l-320 0 0 224 320 0 0-224zM136 272l200 0 0 48-224 0 0-48 24 0z"],
    "scale-balanced": [640, 512, [9878, "balance-scale"], "f24e", "M384 32l160 0 0 64-145.6 0c-5.2 25.8-22.9 47.1-46.4 57.3l0 294.7 192 0 0 64-448 0 0-64 192 0 0-294.7c-23.5-10.3-41.2-31.6-46.4-57.3L96 96 96 32 256 32c14.6-19.4 37.8-32 64-32s49.4 12.6 64 32zM112 128l46.5 0 6.7 12.9 88 168 2.7 5.2 0 47.8-7 7-40 40-7 7-147.9 0-7-7-40-40-7-7 0-47.8 2.7-5.2 88-168 6.7-12.9 14.5 0zM51.1 320l153.8 0-75.4-144-3 0-75.4 144zM481.5 128l61 0 6.7 12.9 88 168 2.7 5.2 0 47.8-7 7-40 40-7 7-147.9 0-7-7-40-40-7-7 0-47.8 2.7-5.2 88-168 6.7-12.9zm29 48l-75.4 144 153.8 0-75.4-144-3 0z"],
    "car": [512, 512, [128664, "automobile"], "f1b9", "M120 32l-22.7 0-7.5 21.4-48.5 138.6-41.3 0 0 288 96 0 0-64 320 0 0 64 96 0 0-288-41.3 0-48.5-138.6-7.5-21.4-294.7 0zM402.9 192l-293.8 0 33.6-96 226.6 0 33.6 96zM64 304a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm352-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "circle-baht": [512, 512, [], "e72d", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM240 128l0-32 32 0 0 32 4 0c42 0 76 34 76 76 0 16.2-5.1 31.3-13.8 43.7 18.1 13.9 29.8 35.8 29.8 60.3 0 42-34 76-76 76l-20 0 0 32-32 0 0-32-72 0 0-256 72 0zm-24 48l0 56 24 0 0-56-24 0zm56 0l0 56 4 0c15.5 0 28-12.5 28-28s-12.5-28-28-28l-4 0zM216 280l0 56 24 0 0-56-24 0zm56 0l0 56 20 0c15.5 0 28-12.5 28-28s-12.5-28-28-28l-20 0z"],
    "badger-honey": [640, 512, [129441], "f6b4", "M160 400l20.6-48 118.1 0 21.3 128 96 0-23-137.9c27.9-29 80.6-70.8 144.1-90.8L560 288 589.5 240.8c6.1-.5 12.3-.8 18.5-.8l32-32 0-64-144-80-64 0-64 32-240 0C57.3 96 0 153.3 0 224l0 64 49.1 0c9 15.5 21.1 29 35.6 39.5l-20.7 72.5 24 80 96 0-24-80zM368 144l11.3 0 10.1-5.1 53.9-26.9 40.2 0 86.4 48-51.3 0c.9 2.5 1.4 5.2 1.4 8 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-2.8 .5-5.5 1.4-8l-41.4 0-160 96-80 0c-52.3 0-96.2-35.8-108.5-84.3 14.7-17 36.4-27.7 60.5-27.7l224 0z"],
    "crop-simple": [512, 512, ["crop-alt"], "f565", "M128 32l0-32-64 0 0 64-64 0 0 64 64 0 0 320 272 0 0-64-208 0 0-352zM384 480l0 32 64 0 0-64 64 0 0-64-64 0 0-320-272 0 0 64 208 0 0 352z"],
    "timer": [512, 512, [], "e29e", "M256 0l-32 0 0 128 64 0 0-61.3c90.8 15.2 160 94.2 160 189.3 0 106-86 192-192 192S64 362 64 256c0-53.7 22-102.3 57.6-137.1L76.8 73.1C29.5 119.6 0 184.4 0 256 0 397.4 114.6 512 256 512S512 397.4 512 256 397.4 0 256 0zM193 159l-17-17-33.9 33.9c.8 .8 33.1 33.1 97 97l17 17 33.9-33.9-17-17-80-80z"],
    "square-dollar": [448, 512, ["dollar-square", "usd-square"], "f2e9", "M448 32l-448 0 0 448 448 0 0-448zM248 104l0 40 40 0 0 48-85.6 0c-10.2 0-18.4 8.2-18.4 18.4 0 9.2 6.8 17 16 18.2l54.4 7.2c33 4.4 57.7 32.5 57.7 65.8 0 35.9-28.4 65.1-64 66.3l0 40-48 0 0-40-56 0 0-48 101.6 0c10.2 0 18.4-8.2 18.4-18.4 0-9.2-6.8-17-16-18.2l-54.4-7.2c-33-4.4-57.7-32.5-57.7-65.8 0-35.9 28.4-65.1 64-66.3l0-40 48 0z"],
    "medal": [448, 512, [127941], "f5a2", "M80.3 192.6L0 32 128-32 224 128 320-32 448 32 367.7 192.6c30.1 33.9 48.3 78.5 48.3 127.4 0 106-86 192-192 192S32 426 32 320c0-48.9 18.3-93.5 48.3-127.4zm175.8 86.1l-32.1-61.9-32.1 61.9-71.9 9.9 52 48.2-12.3 68.1 64.3-32.1 64.3 32.1-12.3-68.1 52-48.2-71.9-9.9z"],
    "scroll": [576, 512, [128220], "f70e", "M0 120C0 71.4 39.4 32 88 32l264 0c53 0 96 43 96 96l0 176-248 0 0 104c0 39.8-32.2 72-72 72l-16 0 0-272-112 0 0-88zM224 480c15.1-20.1 24-45 24-72l0-56 296 0 0 48c0 44.2-35.8 80-80 80l-240 0zM88 80c-22.1 0-40 17.9-40 40l0 40 64 0 0-80-24 0z"],
    "calendars": [512, 512, [], "e0d7", "M256 0l-64 0 0 64-96 0 0 96 416 0 0-96-96 0 0-64-64 0 0 64-96 0 0-64zM96 208l0 208 416 0 0-208-416 0zM48 184l0-24-48 0 0 352 416 0 0-48-368 0 0-280z"],
    "apple-core": [384, 512, [], "e08f", "M176.3 96l0-16c0-44.2 35.8-80 80-80l32 0 0 32c0 44.2-35.8 80-80 80l-32 0 0-16zM14.5 155.3c17-16.9 38.9-27.3 65.8-27.3l112 32 112-32c26.9 0 48.8 10.4 65.8 27.3-49.2 31.2-81.8 86.1-81.8 148.7 0 60.4 30.5 113.8 76.9 145.5-29.9 39.1-69.4 62.5-108.9 62.5l-64-16-64 16c-39.5 0-79-23.4-108.9-62.5 46.4-31.7 76.9-85 76.9-145.5 0-62.6-32.6-117.5-81.8-148.7z"],
    "file-excel": [384, 512, [], "f1c3", "M0 0L240 0 384 144 384 512 0 512 0 0zM208 58.5L208 176 325.5 176 208 58.5zM109.5 256l54.9 96-54.9 96 55.3 0 27.2-47.6 27.2 47.6 55.3 0-54.9-96 54.9-96-55.3 0-27.2 47.6-27.2-47.6-55.3 0z"],
    "diamond-half": [576, 512, [], "e5b7", "M288-16L16 256 288 528 288-16z"],
    "baguette": [640, 512, [129366], "e3d8", "M322.5 100.5l-74.5 49.6c44.6 44.6 69.2 69.2 73.9 73.9L288 257.9c-3.5-3.5-30.4-30.4-80.7-80.7l-74.5 49.6c47.3 47.3 73 73 77.1 77.1L176 337.9c-3-3-31-31-83.9-83.9L57 277.5C-1.8 316.7-17.7 396.2 21.5 455S140.2 529.7 199 490.5l384-256c58.8-39.2 74.7-118.7 35.5-177.5S499.8-17.7 441 21.5L363.3 73.3c41.9 41.9 65.5 65.5 70.7 70.7L400 177.9c-4.1-4.1-29.9-29.9-77.5-77.5z"],
    "ear-triangle-exclamation": [640, 512, [], "e75c", "M447.2 84.6L203 512 96 512 96 192C96 86 182 0 288 0 354.3 0 412.7 33.6 447.2 84.6zM288 112c28.4 0 53.3 14.8 67.5 37.1l25.6-44.9C357.8 79.5 324.7 64 288 64 217.3 64 160 121.3 160 192l0 64 40 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-40 0 0 48 40 0c39.8 0 72-32.2 72-72 0-37.1-28-67.6-64-71.6l0-16.4c0-44.2 35.8-80 80-80zM240 544.1l192-336 192 336-384 0zm208-208l0-16-32 0 0 112 32 0 0-96zm0 127.7l-32 0 0 32 32 0 0-32z"],
    "h5": [576, 512, [], "e412", "M96 96l0-32-64 0 0 384 64 0 0-160 96 0 0 160 64 0 0-384-64 0 0 160-96 0 0-128zM352 64l-32 0 0 208 112 0c30.9 0 56 25.1 56 56s-25.1 56-56 56l-112 0 0 64 112 0c66.3 0 120-53.7 120-120S498.3 208 432 208l-48 0 0-80 152 0 0-64-184 0z"],
    "person-ski-lift": [576, 512, ["ski-lift"], "f7c8", "M288 198.3l-32 8.5 0-206.8 32 0 0 198.3zM96 80a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm103.5 60.7c6 13.1 21.4 47.1 46.4 102l65.9-17.6 40.2 30.9 0 132.5 144-53.2 0-47.3 48 0 0 64c0 10-6.3 19-15.7 22.5l-344 127.1-22.5 8.3-16.6-45 22.5-8.3 120.3-44.5 0-114.5-66.7 17.8c-22.6 6-46.2-5.1-55.9-26.3-28.2-61-44.7-96.8-49.5-107.2 41.9-20.7 67-33.1 83.6-41.4zm-121.8 49L157 355.6c53.4-14.6 84-22.9 91.8-25l12.6 46.3c-4.6 1.3-41.7 11.4-111.2 30.3l-19.3 5.3-8.6-18.1-88-184-10.4-21.7 43.3-20.7 10.4 21.7z"],
    "square-cedi": [448, 512, [], "e729", "M448 32l-448 0 0 448 448 0 0-448zM248 332.3c16.1-5.1 30.1-15.1 40-28.3l38.4 28.8c-18.7 25-46.5 42.9-78.4 48.9l0 34.2-48 0 0-34.2C140.8 370.5 96 318.5 96 256s44.8-114.5 104-125.8l0-34.2 48 0 0 34.2c31.9 6.1 59.6 24 78.4 48.9L288 208c-10-13.3-23.9-23.3-40-28.3l0 152.7zM200 179.7c-32.5 10.2-56 40.5-56 76.3s23.5 66.1 56 76.3l0-152.7z"],
    "filter": [576, 512, [], "f0b0", "M224 416l128 128 0-272 208-208-544 0 208 208 0 144z"],
    "calculator-simple": [512, 512, ["calculator-alt"], "f64c", "M0 0L224 0 224 224 0 224 0 0zM288 0l224 0 0 224-224 0 0-224zM512 288l0 224-224 0 0-224 224 0zM0 288l224 0 0 224-224 0 0-224zM424 72l0-24-48 0 0 40-40 0 0 48 40 0 0 40 48 0 0-40 40 0 0-48-40 0 0-16zM72 88l-24 0 0 48 128 0 0-48-104 0zM97 351l-17-17-33.9 33.9c11.6 11.6 22.3 22.3 32 32-9.7 9.7-20.4 20.4-32 32L80 465.9c11.6-11.6 22.3-22.3 32-32 9.7 9.7 20.4 20.4 32 32L177.9 432c-11.6-11.6-22.3-22.3-32-32 9.7-9.7 20.4-20.4 32-32L144 334.1c-11.6 11.6-22.3 22.3-32 32L97 351zm263-15l-24 0 0 48 128 0 0-48-104 0zm0 80l-24 0 0 48 128 0 0-48-104 0z"],
    "coin-blank": [512, 512, [], "e3fb", "M0 208l0 96c0 29.1 19.4 55.9 52 77.3L52 295c11.7 8.7 25.1 16.6 40 23.6l0 83.7c23.5 9.8 50.5 17.5 80 22.7l0-80.9c12.9 2.5 26.3 4.5 40 5.8l0 80.2c14.3 1.2 29 1.9 44 1.9s29.7-.6 44-1.9l0-80.2c13.7-1.3 27.1-3.3 40-5.8l0 80.9c29.5-5.1 56.5-12.9 80-22.7l0-83.7c14.9-7 28.3-14.9 40-23.6l0 86.3c32.6-21.5 52-48.3 52-77.3l0-96c0-79.5-114.6-144-256-144S0 128.5 0 208zm256 96c-106 0-192-43-192-96s86-96 192-96 192 43 192 96-86 96-192 96z"],
    "intersection": [384, 512, [8898], "f668", "M64 480l0-256c0-70.7 57.3-128 128-128s128 57.3 128 128l0 256 64 0 0-256c0-106-86-192-192-192S0 118 0 224l0 256 64 0z"],
    "drum": [576, 512, [129345], "f569", "M553.5 62.9c-5.4 3.5-34.7 22.8-88 57.6 48.5 17.9 78.8 46.4 78.8 87.4l0 160c0 31.3-27.4 58.8-72 78.7l0-128c-14.3 6.4-30.5 12-48 16.7l0 128c-33 8.9-71.1 14.5-112 16.1l0-128c-15.7 .6-32.3 .6-48 0l0 128c-40.9-1.6-79-7.2-112-16.1l0-128c-17.5-4.7-33.7-10.3-48-16.7l0 128c-44.6-19.9-72-47.4-72-78.7l0-160c0-80 114.6-112 256-112 41 0 79.8 2.7 114.2 8.5l104.6-68.6 20.1-13.2 26.3 40.2zm-278.4 125l64.6-42.3c-16.3-1.1-33.5-1.6-51.4-1.6-68.2 0-125.4 7.9-163.6 22.7-38.8 15.1-44.4 30.6-44.4 41.3 0 .8 2.7 17.2 46 35.9 38.9 16.8 96 28.1 162 28.1s123.1-11.3 162-28.1c43.3-18.7 46-35.1 46-35.9 0-10.6-5.6-26.2-44.4-41.3-11.5-4.5-24.7-8.3-39.4-11.5l-111.1 72.8-20.1 13.2-26.3-40.2 20.1-13.2z"],
    "map-pin": [320, 512, [128205], "f276", "M192 284.4C256.1 269.9 304 212.5 304 144 304 64.5 239.5 0 160 0S16 64.5 16 144c0 68.5 47.9 125.9 112 140.4l0 227.6 64 0 0-227.6zM168 96c-30.9 0-56 25.1-56 56l-48 0C64 94.6 110.6 48 168 48l0 48z"],
    "circle-house": [512, 512, [], "e6c8", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM368 256l0 128-224 0 0-128-32 0 0-32 144-128 144 128 0 32-32 0zM224 272l0 64 64 0 0-64-64 0z"],
    "table-pivot": [576, 512, [], "e291", "M448 96l-192 0 0 64 144 0 0 64-144 0 0 144-64 0 0-144-64 0 0 192 64 0 0 64-128 0 0-448 448 0 0 128-64 0 0-64zM128 160l64 0 0-64-64 0 0 64zM448 320l-64 0 96-96 96 96-64 0 0 160-160 0 0 64-96-96 96-96 0 64 96 0 0-96z"],
    "bridge-suspension": [512, 512, [], "e4cd", "M0 120l0 52.5c27.8-10.3 52.4-27.1 72-48.6l0 132.1-72 0 0 80c37.6 9.4 64 43.2 64 82l0 94 96 0 0-64c0-53 43-96 96-96s96 43 96 96l0 64 96 0 0-94c0-38.8 26.4-72.6 64-82l0-80-72 0 0-132.1c19.6 21.5 44.2 38.3 72 48.6l0-52.5C469.2 97.1 440 52 440 0L392 0c0 75.1-60.9 136-136 136S120 75.1 120 0L72 0C72 52 42.8 97.1 0 120zm392 3.9l0 132.1-56 0 0-90.3c21.3-10.3 40.3-24.5 56-41.8zM288 181.2l0 74.8-64 0 0-74.8c10.4 1.8 21.1 2.8 32 2.8s21.6-1 32-2.8zM176 165.7l0 90.3-56 0 0-132.1c15.7 17.3 34.7 31.5 56 41.8z"],
    "scale-unbalanced-flip": [640, 512, ["balance-scale-right"], "f516", "M251.1 39.3l-113-37.7-20.2 60.7 125.9 42c7 22 23.3 39.9 44.2 49l0 294.7-192 0 0 64 256 0 0-358.7c5.1-2.2 9.9-5 14.4-8.2 107.9 36 163.1 54.4 165.9 55.3l20.2-60.7c-4.9-1.6-55.9-18.6-153-51 .3-2.9 .5-5.8 .5-8.8 0-44.2-35.8-80-80-80-29.3 0-55 15.8-68.9 39.3zM528 224l-46.5 0-6.7 12.9-88 168-2.7 5.2 0 47.8 7 7 40 40 7 7 147.9 0 7-7 40-40 7-7 0-47.8-2.7-5.2-88-168-6.7-12.9-14.5 0zm60.9 192l-153.8 0 75.4-144 3 0 75.4 144zM158.5 96l-61 0-6.7 12.9-88 168-2.7 5.2 0 47.8 7 7 40 40 7 7 147.9 0 7-7 40-40 7-7 0-47.8-2.7-5.2-88-168-6.7-12.9zm-29 48l75.4 144-153.8 0 75.4-144 3 0z"],
    "light-switch": [384, 512, [], "e017", "M0 0L384 0 384 512 0 512 0 0zM96 96l0 136 192 0 0-136-192 0zm0 184l0 136 192 0 0-136-192 0z"],
    "arrows-to-circle": [576, 512, [], "e4bd", "M64.3-13.3l96 96 0-50.7 64 0 0 160-160 0 0-64 50.7 0-96-96 45.3-45.3zM231.7 256a56.3 56.3 0 1 1 112.5 0 56.3 56.3 0 1 1 -112.5 0zM534.9 54.6l-73.4 73.4 50.7 0 0 64-160 0 0-160 64 0 0 50.7 96-96 45.3 45.3-22.6 22.6zM512.3 525.3l-96-96 0 50.7-64 0 0-160 160 0 0 64-50.7 0 96 96-45.3 45.3zM41.6 457.4l73.4-73.4-50.7 0 0-64 160 0 0 160-64 0 0-50.7c-57.4 57.4-89.4 89.4-96 96L19 480 41.6 457.4z"],
    "ampersand": [448, 512, [], "26", "M144.2 112.7c0 12.2 4.5 24.1 12.5 33l27.6 30.9 36.4-26.6c12.3-9 19.5-23.2 19.5-38.4 0-26.2-21.4-47.6-47.8-47.6-26.2 0-48.2 22-48.2 48.7zm114.3 88.9l-31.3 22.8 88.1 98.5c35.6-32.1 59.4-53.5 71.3-64.2l42.8 47.6c-11.9 10.7-35.7 32.1-71.4 64.3 38.2 42.7 62 69.3 71.4 79.8l-47.7 42.7c-9.5-10.6-33.2-37.1-71.3-79.7l-64.8 58.3-9.1 8.2-76.3 0c-70.2 0-128-56.9-128-127.5 0-40.7 19.4-78.9 52.3-102.9l47.9-35-23.4-26.1c-18.6-20.8-28.8-48-28.8-75.7 0-61.6 50.1-112.7 112.2-112.7 61.5 0 111.8 49.9 111.8 111.6 0 35.6-17 69.1-45.7 90.1zM160.2 416l51.7 0 55.8-50.2-92.4-103.3-53 38.7c-16.4 12-26 31-26 51.3 0 34.9 28.7 63.5 64 63.5z"],
    "chess-clock": [576, 512, [], "f43d", "M224 16l-160 0 0 48 56 0 0 32-56 0C28.7 96 0 124.7 0 160L0 384c0 35.3 28.7 64 64 64l448 0c35.3 0 64-28.7 64-64l0-224c0-35.3-28.7-64-64-64l-16 0 0-32-160 0 0 32-168 0 0-32 56 0 0-48zM336.8 192.8A112 112 0 1 1 495.2 351.2 112 112 0 1 1 336.8 192.8zm152.7 39.6l-33.9-33.9-67.9 67.9 33.9 33.9 67.9-67.9zM160 160a112 112 0 1 1 0 224 112 112 0 1 1 0-224zm24 128l0-96-48 0 0 96 48 0z"],
    "envelope": [512, 512, [128386, 9993, 61443], "f0e0", "M0 64l512 0 0 72-12.8 9.6-224 168-19.2 14.4-19.2-14.4-224-168-12.8-9.6 0-72zM0 196l256 192 256-192 0 252-512 0 0-252z"],
    "baby": [448, 512, [], "f77c", "M152.4 88a72 72 0 1 1 144 0 72 72 0 1 1 -144 0zM63.6 112.1c14 10.2 50.7 36.8 109.8 79.9l102 0c59.2-43 95.8-69.7 109.8-79.9l47.1 64.7c-13.7 10-51 37.1-111.9 81.4l0 29.8-192 0 0-29.8c-60.9-44.3-98.2-71.4-111.9-81.4l47.1-64.7zm65.3 216.3l60.2 52.7-23.7 27.1c10.1 11.7 24.6 28.5 43.4 50.4l-60.6 52.2c-37.4-43.4-87.9-101.9-88.8-103 11.3-12.9 34.5-39.4 69.5-79.4zm130.8 52.7l60.2-52.7c35 40 58.2 66.5 69.5 79.4-30.6 35.5-86.1 99.9-88.8 103L240 458.6c18.9-21.9 33.4-38.7 43.4-50.4l-23.7-27.1z"],
    "nfc-lock": [576, 512, [], "e1f8", "M32 32l448 0 0 145c-5.2-.7-10.6-1-16-1-17 0-33.2 3.3-48 9.3l0-89.3-184 0 0 118.4c-14.3 8.3-24 23.8-24 41.6 0 26.5 21.5 48 48 48s48-21.5 48-48c0-17.8-9.7-33.3-24-41.6l0-70.4 88 0 0 75.3c-19.9 22.6-32 52.2-32 84.7l-32 0 0 64-160 0 0-224 40 0 0-48-88 0 0 320 208 0 0 64-272 0 0-448zM464 272c-17.7 0-32 14.3-32 32l0 48 64 0 0-48c0-17.7-14.3-32-32-32zm-80 32c0-44.2 35.8-80 80-80s80 35.8 80 80l0 48 32 0 0 192-224 0 0-192 32 0 0-48z"],
    "square-caret-down": [448, 512, ["caret-square-down"], "f150", "M0 480l448 0 0-448-448 0 0 448zM224 360L88 192 360 192 224 360z"],
    "hyphen": [320, 512, [], "2d", "M0 224l320 0 0 64-320 0 0-64z"],
    "plane-prop": [576, 512, [], "e22b", "M231 312l9 72-48 0 0 64 56 0 8 64 64 0 8-64 28 0 0 28 40 0 0-120-40 0 0 28-20 0 9-72 175 0c30.9 0 56-25.1 56-56s-25.1-56-56-56l-175 0-9-72 20 0 0 28 40 0 0-120-40 0 0 28-28 0-8-64-64 0-8 64-56 0 0 64 48 0-9 72-71 0-33.5 5-30.5-61-40 0-22.5 75-33.5 5 0 64 33.5 5 22.5 75 40 0 30.5-61 33.5 5 71 0z"],
    "tent": [512, 512, [], "e57d", "M29.7 176l-29.7 304 254.9 0 0-192 129.1 192 128 0-29.7-304-227.4-144-225.1 144z"],
    "chimney": [448, 512, [], "f78b", "M0 32l448 0 0 128-448 0 0-128zM32 192l96 0 0 128-96 0 0-128zm384 0l0 128-256 0 0-128 256 0zM288 352l0 128-256 0 0-128 256 0zm128 0l0 128-96 0 0-128 96 0z"],
    "a": [384, 512, [97], "41", "M170.1 32l44.2 0 7.8 20.6C304.4 269.4 358.4 411.9 384.3 480l-68.5 0-36.4-96-174.5 0-36.4 96-68.5 0C25.9 411.9 80 269.4 162.2 52.6L170.1 32zm85 288l-63-165.8-63 165.8 125.9 0z"],
    "circle-small": [320, 512, [], "e122", "M0 256a160 160 0 1 1 320 0 160 160 0 1 1 -320 0z"],
    "parachute-box": [512, 512, [], "f4cd", "M128 224C128 152.2 144.3 88.4 169.5 43.4 195.1-2.4 226.6-24 256-24s60.9 21.6 86.5 67.4C367.7 88.4 384 152.2 384 224l-104 0 0 96 40.5 0 112-96-.5 0C432 145.6 414.3 73.4 384.4 20 378.3 9 371.5-1.4 364.2-10.9 450.7 24.9 512 104.2 512 208l0 11-8.4 7.2-151.6 130 0 155.8-192 0 0-155.8-151.6-130-8.4-7.2 0-11C0 104.2 61.3 24.9 147.8-10.9 140.5-1.4 133.7 9 127.6 20 97.7 73.4 80 145.6 80 224l-.5 0 112 96 40.5 0 0-96-104 0z"],
    "cart-flatbed-boxes": [576, 512, ["dolly-flatbed-alt"], "f475", "M0 0l128 0 0 384 448 0 0 64-66.7 0c1.8 5 2.7 10.4 2.7 16 0 26.5-21.5 48-48 48s-48-21.5-48-48c0-5.6 1-11 2.7-16l-197.5 0c1.8 5 2.7 10.4 2.7 16 0 26.5-21.5 48-48 48s-48-21.5-48-48c0-5.6 1-11 2.7-16L64 448 64 64 0 64 0 0zM176 64l144 0 0 272-144 0 0-272zm336 96l0 176-144 0 0-176 144 0z"],
    "cart-arrow-down": [640, 512, [], "f218", "M0-16l116 0c2.1 11.7 5 27.7 8.7 48l187.2 0 0 102.1c-23-23-39-39-48-48L230.1 120c2.1 2.1 31.8 31.8 89 89l17 17c2.1-2.1 31.8-31.8 89-89l17-17-33.9-33.9c-9 9-25 25-48 48l0-102.1 216 0-48 256-356.7 0 8.7 48 300 0 0 48-340 0-3.6-19.7-60.4-332.3-76 0 0-48zM160 464a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm224 0a48 48 0 1 1 96 0 48 48 0 1 1 -96 0z"],
    "circle-7": [512, 512, [], "e0f4", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM176 144l156 0 0 37.7-2.5 5.1-90.6 181.3-53.7 0 9.4-18.7 78.6-157.3-97.2 0 0-48z"],
    "lock-hashtag": [384, 512, [], "e423", "M128 96l0 64 128 0 0-64c0-35.3-28.7-64-64-64s-64 28.7-64 64zM64 160l0-64C64 25.3 121.3-32 192-32S320 25.3 320 96l0 64 64 0 0 352-384 0 0-352 64 0zm96 48l-48 0 0 48-48 0 0 48 48 0 0 64-48 0 0 48 48 0 0 48 48 0 0-48 64 0 0 48 48 0 0-48 48 0 0-48-48 0 0-64 48 0 0-48-48 0 0-48-48 0 0 48-64 0 0-48zm0 96l64 0 0 64-64 0 0-64z"],
    "circle-sterling": [512, 512, [], "e5cf", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM160 256l0-32 18.9 0c-15.8-55.2 25.5-112 84.7-112l2.2 0c19.7 0 38.8 6.4 54.5 18.2 8.6 6.5 19.7 14.8 33.4 25l-28.8 38.4c-13.6-10.2-24.8-18.6-33.4-25-7.4-5.6-16.4-8.6-25.7-8.6l-2.2 0c-28.5 0-47.8 28.9-37 55.2l1.4 3.5c.7 1.8 1.4 3.5 2 5.3l90 0 0 32-84 0c.7 22.6-5.8 45-19.1 64l135.1 0 0 48-200 0 0-42.5c1.1-1.4 9-11.6 23.7-30.5 8.8-11.3 12.9-25.1 12.2-39L160 256z"],
    "bridge-circle-exclamation": [576, 512, [], "e4ca", "M32 32l-32 0 0 64 40 0 0 64-40 0 0 112c37.6 9.4 64 43.2 64 82l0 126 96 0 0-96c0-53 43-96 96-96 6.4 0 12.7 .6 18.7 1.8 34.7-49.5 92.2-81.8 157.3-81.8 28.6 0 55.6 6.2 80 17.4l0-65.4-40 0 0-64 40 0 0-64-480 0zM424 96l0 64-80 0 0-64 80 0zM296 96l0 64-80 0 0-64 80 0zM88 96l80 0 0 64-80 0 0-64zM432 544a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm16-64l-32 0 0-32 32 0 0 32zm0-176l0 112-32 0 0-112 32 0z"],
    "cloud-arrow-up": [576, 512, [62338, "cloud-upload", "cloud-upload-alt"], "f0ee", "M144 480l432 0 0-128c0-47.4-25.7-88.7-64-110.9l0-49.1c0-53-43-96-96-96-17.7 0-34.2 4.8-48.4 13.1-24.1-45.8-72.2-77.1-127.6-77.1-79.5 0-144 64.5-144 144l0 24.2C40.1 220 0 273.3 0 336l0 144 144 0zM305 191c57.2 57.2 86.8 86.8 89 89L360 313.9c-9-9-25-25-48-48l0 126.1-48 0 0-126.1c-23 23-39 39-48 48L182.1 280c2.1-2.1 31.8-31.8 89-89l17-17 17 17z"],
    "at": [512, 512, [61946], "40", "M256 64C150 64 64 150 64 256s86 192 192 192l32 0 0 64-32 0C114.6 512 0 397.4 0 256S114.6 0 256 0 512 114.6 512 256l0 128-72 0c-36 0-68.2-15.8-90.2-40.9-23.4 25.1-56.7 40.9-93.8 40.9-70.7 0-128-57.3-128-128s57.3-128 128-128c32.5 0 62.1 12.1 84.7 32l43.3 0 0 104c0 30.9 25.1 56 56 56l8 0 0-64c0-106-86-192-192-192zm64 192a64 64 0 1 0 -128 0 64 64 0 1 0 128 0z"],
    "indian-rupee-sign": [320, 512, ["indian-rupee", "inr"], "e1bc", "M0 32l320 0 0 48-100.7 0c17.7 19.8 30.1 44.6 34.7 72l66 0 0 48-66 0c-10.8 64.4-64.4 114.3-130.5 119.6l133.8 85.5 27 17.2-34.5 53.9-27-17.2-208-132.9-14.8-9.4c0-25 0-35.5 0-60.6l112 0c35.8 0 66.1-23.5 76.3-56L0 200 0 152 188.3 152c-10.2-32.5-40.5-56-76.3-56L0 96 0 32z"],
    "truck": [576, 512, [128666, 9951], "f0d1", "M0 32l416 0 0 96 77.3 0 9.4 9.4 64 64 9.4 9.4 0 237.3-67.3 0c-10.4 36.9-44.4 64-84.7 64s-74.2-27.1-84.7-64l-102.6 0c-10.4 36.9-44.4 64-84.7 64s-74.2-27.1-84.7-64L0 448 0 32zM512 288l0-50.7-45.3-45.3-50.7 0 0 96 96 0zM192 424a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zm232 40a40 40 0 1 0 0-80 40 40 0 1 0 0 80z"],
    "game-console-handheld-crank": [640, 512, [], "e5b9", "M64 32l448 0 0 448-448 0 0-448zM448 96l-320 0 0 160 320 0 0-160zM192 336l0-16-32 0 0 32-32 0 0 32 32 0 0 32 32 0 0-32 32 0 0-32-32 0 0-16zm144 24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm56 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM544 144l96 0 0 80-48 0 0 96-48 0 0-176z"],
    "chalkboard-user": [640, 512, ["chalkboard-teacher"], "f51c", "M128 32l480 0 0 304-96 0 0-48-128 0 0 48-120.6 0-3.9-8.8c8-16.7 12.5-35.4 12.5-55.2 0-70.7-57.3-128-128-128-5.4 0-10.8 .3-16 1l0-113zM312.4 448l-28-64 323.6 0 0 64-295.6 0zM64 272a80 80 0 1 1 160 0 80 80 0 1 1 -160 0zM232 384l56 128-288 0 56-128 176 0z"],
    "user-check": [640, 512, [], "f4fc", "M464.3 512l-416 0 64-208 288 0 64 208zM638.6 114.7l-14.1 19.4-102.4 140.8-16.8 23.1c-8.8-9.1-30.9-32-66.2-68.6l-16.7-17.2 34.5-33.3c9.5 9.8 23.9 24.7 43.2 44.7l85.6-117.7 14.1-19.4 38.8 28.2zM256.3 248a120 120 0 1 1 0-240 120 120 0 1 1 0 240z"],
    "chart-pie-simple-circle-currency": [640, 512, [], "e604", "M496 208C512.1 208 527.7 210 542.6 213.7 529.5 93.5 427.7 0 304 0l0 240 85.8 0c30.4-20.2 66.9-32 106.2-32zM304 400c0-41.8 13.4-80.5 36-112l-84 0 0-255.5c-125.1 8.2-224 112.3-224 239.5 0 132.5 107.5 240 240 240 21.6 0 42.5-2.9 62.4-8.2-19.3-29.9-30.4-65.6-30.4-103.8zm336 0a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zM496 432a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm55.1 .5l28.2 28.2-22.6 22.6-28.2-28.2c-9.5 5.6-20.6 8.9-32.5 8.9s-23-3.2-32.5-8.9l-28.2 28.2-22.6-22.6 28.2-28.2c-5.6-9.5-8.9-20.6-8.9-32.5s3.2-23 8.9-32.5l-28.2-28.2 22.6-22.6 28.2 28.2c9.5-5.6 20.6-8.9 32.5-8.9s23 3.2 32.5 8.9l28.2-28.2 22.6 22.6-28.2 28.2c5.6 9.5 8.9 20.6 8.9 32.5s-3.2 23-8.9 32.5z"],
    "face-fearful": [512, 512, [], "e375", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm0-192c44.2 0 80 35.8 80 80l0 16-160 0 0-16c0-44.2 35.8-80 80-80zM96 224a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zm256-64a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM176 116c-4.2 0-8.4 .3-12.5 .8-20.3 2.7-38.9 11.9-53.8 25.8L95 156.3 67.7 127 82.3 113.4C103 94.1 129.2 81 158.3 77.2 164.1 76.4 170 76 176 76l20 0 0 40-20 0zm172.5 .8c-4.1-.5-8.3-.8-12.5-.8l-20 0 0-40 20 0c6 0 11.9 .4 17.7 1.2 29.1 3.8 55.3 17 75.9 36.2l14.6 13.7-27.3 29.2-14.6-13.7c-14.9-13.9-33.5-23.1-53.8-25.8zM192 224a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm160 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "user-ninja": [448, 512, [129399], "f504", "M352 128c0 70.7-57.3 128-128 128-57.9 0-106.8-38.4-122.6-91.2-16.3 19-41.4 30-70.7 28.3-2-36.7 15.6-66.7 44.1-81.3-28.5-14.5-46.1-44.5-44.1-81.3 34.9-1.9 63.7 13.9 79 39.9 21.1-41.8 64.4-70.5 114.4-70.5 70.7 0 128 57.3 128 128zM144 96l0 32 160 0 0-32-160 0zm80 288l64-64 80 0 64 192-416 0 64-192 80 0 64 64z"],
    "frame": [512, 512, [], "e495", "M512 128l0-64-64 0 0-64-64 0 0 64-256 0 0-64-64 0 0 64-64 0 0 64 64 0 0 256-64 0 0 64 64 0 0 64 64 0 0-64 256 0 0 64 64 0 0-64 64 0 0-64-64 0 0-256 64 0zM128 384l0-256 256 0 0 256-256 0z"],
    "plant-wilt": [512, 512, [], "e5aa", "M344-32c66.3 0 120 53.7 120 120l0 6.2c29.3 12.2 48 41.3 48 76.9 0 51.3-46.9 91.9-80 124.9-33.1-33.1-80-73.7-80-124.9 0-35.6 18.7-64.7 48-76.9l0-6.2c0-30.9-25.1-56-56-56s-56 25.1-56 56l0 456-64 0 0-328c0-30.9-25.1-56-56-56s-56 25.1-56 56l0 38.2c29.3 12.2 48 41.3 48 76.9 0 51.3-46.9 91.9-80 124.9-33.1-33.1-80-73.7-80-124.9 0-35.6 18.7-64.7 48-76.9L48 216c0-66.3 53.7-120 120-120 20.2 0 39.3 5 56 13.8L224 88c0-66.3 53.7-120 120-120z"],
    "weight-scale": [448, 512, ["weight"], "f496", "M116.6 192c-3-10.1-4.6-20.9-4.6-32 0-61.9 50.1-112 112-112S336 98.1 336 160c0 11.1-1.6 21.9-4.6 32l-71 0c18.6-33.5 30.7-55.2 36.3-65.3l-42-23.3c-3.4 6.2-19.9 35.8-49.2 88.6l-88.8 0zM128 32l-128 0 0 448 448 0 0-448-128 0C293.3 11.9 260 0 224 0s-69.3 11.9-96 32z"],
    "farm": [576, 512, ["barn-silo"], "f864", "M112-32C50.1-32 0 18.1 0 80l0 2.2 196 0 27.5-12.5C218.3 12.7 170.4-32 112-32zM80 368l0-80c0-5.2 .8-10.3 2.5-15.2l47.5-142.6-130 0 0 381.8 112 0 0-144-32 0zm48-80l0 32 32 0 0 192 384 0 0-192 32 0 0-32-48-144-176-80-176 80-48 144zM416 464l-128 0 0-128 128 0 0 128zM400 176l0 96-96 0 0-96 96 0z"],
    "caret-right": [320, 512, [], "f0da", "M96 80L296 256 96 432 96 80z"],
    "hexagon-divide": [576, 512, [], "e1ad", "M13.5 256.1l6.8-11.9 123.7-216.1 6.9-12.1 275.1 0 6.9 12.1 123.7 216.1 6.8 11.9-6.8 11.9-123.7 216.1-6.9 12.1-275.1 0-6.9-12.1-123.7-216.1-6.8-11.9zM320.5 128l-64 0 0 64 64 0 0-64zm-120 104l-24 0 0 48 224 0 0-48-200 0zm56 88l0 64 64 0 0-64-64 0z"],
    "florin-sign": [384, 512, [], "e184", "M314.7 32c-38.8 0-73.7 23.3-88.6 59.1l-55.4 132.9-138.7 0 0 64 112 0-45.1 108.3c-5 11.9-16.6 19.7-29.5 19.7l-69.3 0 0 64 69.3 0c38.8 0 73.7-23.3 88.6-59.1l55.4-132.9 138.7 0 0-64-112 0 45.1-108.3c5-11.9 16.6-19.7 29.5-19.7l69.3 0 0-64-69.3 0z"],
    "lightbulb-exclamation-on": [640, 512, [], "e1ca", "M416 528l-192 0 0-96 192 0 0 96zM320 0c106 0 192 86 192 192 0 71.1-38.6 133.1-96 166.3l0 25.7-192 0 0-25.7C166.6 325.1 128 263.1 128 192 128 86 214 0 320 0zM112.2 330.7c-9 4.5-34 17-74.9 37.5L15.8 325.3c9-4.5 34-17 74.9-37.5l21.5 42.9zm490.5-16.2l21.5 10.7-21.5 42.9c-41-20.5-65.9-33-74.9-37.5l21.5-42.9 53.4 26.7zM292 252l0 56 56 0 0-56-56 0zM80 216l-80 0 0-48 80 0 0 48zM288 72l12.8 144 38.4 0 12.8-144-64 0zM640 216l-80 0 0-48 80 0 0 48zM90.7 42.5l21.5 10.8-21.5 42.9c-41-20.5-65.9-33-74.9-37.5L37.3 15.8 90.7 42.5zM624.2 58.7c-9 4.5-34 17-74.9 37.5L527.8 53.3c9-4.5 34-17 74.9-37.5l21.5 42.9z"],
    "bell": [512, 512, [128276, 61602], "f0f3", "M288 0l-64 0 0 35.2C151 50 96 114.6 96 192l0 96-80 128 480 0-80-128 0-96c0-77.4-55-142-128-156.8L288 0zM194 464c7.1 27.6 32.2 48 62 48s54.9-20.4 62-48l-124 0z"],
    "hand-back-point-left": [512, 512, [], "e19f", "M0 208l0-80 336 0 0-32-72 0 40-48 68 0c38 0 74 16.9 98.3 46.1l4.5 5.4c24 28.8 37.1 65 37.1 102.4L512 320c0 70.7-57.3 128-128 128l-144 0 0-80-32 0 0-80-32 0 0-80-176 0z"],
    "lari-sign": [384, 512, [], "e1c8", "M168 0l0 65.5c7.9-1 15.9-1.5 24-1.5s16.1 .5 24 1.5l0-65.5 48 0 0 78c70.4 28.5 120 97.5 120 178l-64 0c0-44-22.2-82.8-56-105.8l0 105.8-48 0 0-125.8c-7.8-1.5-15.8-2.2-24-2.2s-16.2 .8-24 2.2l0 125.8-48 0 0-105.8c-33.8 23-56 61.9-56 105.8 0 70.7 57.3 128 128 128l192 0 0 64-384 0 0-64 48.9 0C18.5 350 0 305.2 0 256 0 175.4 49.6 106.4 120 78l0-78 48 0z"],
    "rectangle-plus": [512, 512, [], "e6b5", "M512 64l-512 0 0 384 512 0 0-384zM232 368l0-88-88 0 0-48 88 0 0-88 48 0 0 88 88 0 0 48-88 0 0 88-48 0z"],
    "cucumber": [512, 512, [129362], "e401", "M37.5 474.5c47.8 47.8 123.9 49.9 174.2 6.4l20.4 20.4 45.3-45.3-20.1-20.1 178.7-178.7 20.1 20.1 45.3-45.3-20.4-20.4c43.5-50.3 41.4-126.4-6.4-174.2-50-50-131-50-181 0l-121.4 121.4-20.1-20.1-45.3 45.3 20.1 20.1-89.4 89.4c-50 50-50 131 0 181zM168 280l0 48-48 0 0-48 48 0zm112-32l48 0 0 48-48 0 0-48zM424 88l0 48-48 0 0-48 48 0z"],
    "seal": [576, 512, [], "e241", "M131.9 99.9L21.5 145.6 67.2 256 21.5 366.4 131.9 412.1 177.6 522.5 288 476.8 398.4 522.5 444.2 412.1 554.6 366.4 508.8 256 554.6 145.6 444.2 99.9 398.4-10.5 288 35.2 177.6-10.5 131.9 99.9z"],
    "circle-caret-down": [512, 512, ["caret-circle-down"], "f32d", "M256 0a256 256 0 1 0 0 512 256 256 0 1 0 0-512zm0 360l-136-168 272 0-136 168z"],
    "mill-sign": [384, 512, [], "e1ed", "M319.3-13.2c-2.7 6.6-15.4 37.8-38 93.6 57.5 4.7 102.7 52.9 102.7 111.6l0 240-64 0 0-240c0-26.5-21.5-48-48-48-6.4 0-12.5 1.2-18 3.5l-30 73.8 0 210.7-64 0 0-53.2-57.8 142.2-9 22.2-44.5-18.1 9-22.2 102.2-251.7 0-59.3c0-26.5-21.5-48-48-48s-48 21.5-48 48l0 240-64 0 0-352 64 0 0 10.8c14.5-6.9 30.8-10.8 48-10.8 31.3 0 59.7 12.9 80 33.6 9.6-9.8 20.9-17.8 33.5-23.5 32.1-78.9 48.5-119.3 49.3-121.3l44.5 18.1z"],
    "mug-tea-saucer": [576, 512, [], "e1f5", "M168 32l0 64-40 48 0 112 128 0 0-112-40-48 0-64 232 0c70.7 0 128 57.3 128 128S518.7 288 448 288l0 96-384 0 0-352 104 0zM448 224c35.3 0 64-28.7 64-64s-28.7-64-64-64l0 128zM32 448l448 0 0 64-448 0 0-64z"],
    "cart-circle-check": [640, 512, [], "e3f1", "M24-16l-24 0 0 48 76 0 60.4 332.3 3.6 19.7 164.7 0c1.4-16.7 4.9-32.8 10.3-48l-134.9 0-8.7-48 168.7 0c34.9-48.5 91.7-80 156-80 15.8 0 31.2 1.9 46 5.5L576 32 124.8 32c-3.7-20.3-6.6-36.3-8.7-48L24-16zM208 512a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM640 400a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-73.6-51.5l-9.4 12.9-64 88-11 15.1c-4.4-4.4-22.1-22.1-53.2-53.2L417.4 400 440 377.4c5 5 17.7 17.7 38.1 38.1l53-72.9 9.4-12.9 25.9 18.8z"],
    "album": [448, 512, [128189], "f89f", "M0 32l448 0 0 448-448 0 0-448zM384 256a160 160 0 1 0 -320 0 160 160 0 1 0 320 0zM224 224a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "left-to-line": [512, 512, ["arrow-alt-to-left"], "f34b", "M0 448l0-384 64 0 0 384-64 0zM117 256l18.5-17.4C248.8 131.6 310.3 73.5 320 64.3l0 127.7 160 0 0 0 32 0 0 128-192 0 0 127.7c-9.7-9.2-71.2-67.3-184.5-174.2L117 256z"],
    "person-snowboarding": [576, 512, [127938, "snowboarding"], "f7ce", "M424.4 16a56 56 0 1 1 0 112 56 56 0 1 1 0-112zM184.8 19.4l26.1 18.5 272 192 26.1 18.5-36.9 52.3c-6.4-4.5-45.9-32.4-118.4-83.6l-62.2 53.3c39.2 32.7 59.5 49.6 60.9 50.7l0 125.3 87 17c38.2-10.9 62.7-17.9 73.5-21l13.2 46.2c-9.9 2.8-36.3 10.4-79.1 22.6-3.6 1-7.5 1.2-11.2 .5l-368-72c-4.7-.9-9-3.2-12.4-6.6-30.5-30.5-49.5-49.5-57-57l33.9-33.9c8.3 8.3 25.6 25.6 51.8 51.8l76.2 14.9 0-123.7c0-27.7 12-54 32.8-72.2l69-60.4C193 103.6 154.9 76.7 147.8 71.7l36.9-52.3zm39.7 401.9l64 12.5 0-82.8-64-53.3 0 123.6z"],
    "tty": [512, 512, ["teletype"], "f1e4", "M512.1 143.4l-36.6 109.7-128.4-17.8 .4-91.9c-59.1-21.4-123.8-21.4-182.9 0l.4 91.9-128.4 17.8-36.6-109.7 9.1-9.1C145.5-2.1 366.6-2.1 502.9 134.2l9.1 9.1zM32 320l64 0 0 64-64 0 0-64zm96 0l64 0 0 64-64 0 0-64zM96 416l0 64-64 0 0-64 64 0zm320 0l64 0 0 64-64 0 0-64zM288 320l0 64-64 0 0-64 64 0zm32 0l64 0 0 64-64 0 0-64zm160 0l0 64-64 0 0-64 64 0zM128 416l256 0 0 64-256 0 0-64z"],
    "slider-circle": [576, 512, [], "e750", "M476 288c-14.2 55.2-64.3 96-124 96-70.7 0-128-57.3-128-128s57.3-128 128-128c59.6 0 109.8 40.8 124 96l100 0 0 64-100 0zM32 224l146.9 0c-1.9 10.4-2.9 21.1-2.9 32s1 21.6 2.9 32L0 288 0 224 32 224z"],
    "users-rectangle": [576, 512, [], "e594", "M576 0L0 0 0 512 576 512 576 0zM224 160a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zm-48 0c0 28.2 10.4 54 27.7 73.7-8.4 4-17.8 6.3-27.7 6.3-35.3 0-64-28.7-64-64s28.7-64 64-64c3.5 0 7 .3 10.4 .8-6.7 14.3-10.4 30.3-10.4 47.2zm224 80c-9.9 0-19.3-2.3-27.7-6.3 17.2-19.7 27.7-45.5 27.7-73.7 0-16.8-3.7-32.8-10.4-47.2 3.4-.6 6.8-.8 10.4-.8 35.3 0 64 28.7 64 64s-28.7 64-64 64zM124.7 400l-44.7 0 48-112 38.7 0-35.7 95.1-6.3 16.9zm326.5 0l-6.3-16.9-35.7-95.1 38.7 0 48 112-44.7 0zM352 272l48 128-224 0 48-128 128 0z"],
    "mobile": [384, 512, [128241, "mobile-android", "mobile-phone"], "f3ce", "M368 0l-352 0 0 512 352 0 0-512zM152 416l104 0 0 48-128 0 0-48 24 0z"],
    "arrows-turn-to-dots": [448, 512, [], "e4c1", "M265.4-6.6L288-29.3 333.3 16c-14.6 14.6-30.6 30.6-48 48l162.7 0 0 160-64 0 0-96-98.7 0c17.4 17.4 33.4 33.4 48 48L288 221.3c-5.5-5.5-39.7-39.7-102.6-102.6L162.7 96c5.5-5.5 39.7-39.7 102.6-102.6zm-82.7 272c62.9 62.9 97.1 97.1 102.6 102.6-5.5 5.5-39.7 39.7-102.6 102.6L160 493.3 114.7 448c14.6-14.6 30.6-30.6 48-48l-98.7 0 0 96-64 0 0-160 162.7 0c-17.4-17.4-33.4-33.4-48-48l45.3-45.3 22.6 22.6zM320 368a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zM64 160a64 64 0 1 1 0-128 64 64 0 1 1 0 128z"],
    "exclamation": [128, 512, [10069, 10071, 61738], "21", "M96 512l-64 0 0-64 64 0 0 64zm0-128L32 384 16 0 112 0 96 384z"],
    "location-xmark": [384, 512, ["map-marker-times", "map-marker-xmark"], "f60e", "M0 188.6C0 84.4 86 0 192 0S384 84.4 384 188.6C384 339.4 192 528 192 528S0 339.4 0 188.6zm276.9-47.5l-33.9-33.9c-8.5 8.5-25.5 25.5-50.9 50.9-25.5-25.5-42.4-42.4-50.9-50.9l-33.9 33.9c8.5 8.5 25.5 25.5 50.9 50.9-25.5 25.5-42.4 42.4-50.9 50.9l33.9 33.9c8.5-8.5 25.5-25.5 50.9-50.9 25.5 25.5 42.4 42.4 50.9 50.9l33.9-33.9c-8.5-8.5-25.5-25.5-50.9-50.9 25.5-25.5 42.4-42.4 50.9-50.9z"],
    "church": [512, 512, [9962], "f51d", "M280-8l0-24-48 0 0 48-56 0 0 48 56 0 0 48-120 80 0 64-112 64 0 192c192 0 128 0 384 0l128 0 0-192-112-64 0-64-120-80 0-48 56 0 0-48-56 0 0-24zm40 328l0 144-128 0 0-144 128 0z"],
    "toggle-off": [576, 512, [], "f204", "M512 128l0 256-448 0 0-256 448 0zm64-64l-576 0 0 384 576 0 0-384zM112 176l0 160 160 0 0-160-160 0z"],
    "face-nauseated": [512, 512, [], "e381", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm80-320a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM208 224a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm-23.1-78.1l-81.9 40.9-17.9-35.8 99.8-49.9 17.9 35.8-17.9 8.9zm124.2-8.9l17.9-35.8c4.2 2.1 31.5 15.8 81.9 40.9l17.9 8.9-17.9 35.8c-4.2-2.1-31.5-15.8-81.9-40.9l-17.9-8.9zM160 288c26.9 0 49.9 16.5 59.3 40l73.3 0c9.5-23.5 32.5-40 59.3-40 4.8 0 9.5 .5 14 1.5-18.3 14.7-30 37.2-30 62.5s11.7 47.8 30 62.5c-4.5 1-9.2 1.5-14 1.5-26.9 0-49.9-16.5-59.3-40l-73.3 0c-9.5 23.5-32.5 40-59.3 40-4.8 0-9.5-.5-14-1.5 18.3-14.7 30-37.2 30-62.5s-11.7-47.8-30-62.5c4.5-1 9.2-1.5 14-1.5z"],
    "deer": [512, 512, [129420], "f78e", "M256.3 0l0 40c0 13.3 10.7 24 24 24l16 0c13.3 0 24-10.7 24-24l0-40 32 0 0 40c0 8.6-1.9 16.7-5.4 24l69.4 0c13.3 0 24-10.7 24-24l0-40 32 0 0 40c0 21.7-12.3 40.4-30.3 49.8 .6 .5 1.1 1.1 1.7 1.6l68.6 68.6 0 64-101.3 0-26.7 80 0 208-96 0 0-144-48 0-64-27.4 0 23.3c-7.3 7.3-20.8 20.8-40.7 40.7L173.5 512 71.7 512C42.8 430.1 27.2 385.9 24.9 379.4 38.4 366 54.2 350.1 72.4 332L56.3 315.9c-3-3-5.7-6.1-8.1-9.5l-1.8 23.3-47.9-3.7C-.4 311.2 1 293.1 2.7 272 6.8 217.8 52 176 106.4 176l196.3 0 9.6-32-56 0 0-32 64-16-40 0c-30.9 0-56-25.1-56-56l0-40 32 0zm144 160a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"],
    "box-open-full": [640, 512, ["box-full"], "f49c", "M315.9 170.5c2.9-8.3 4.5-17.2 4.5-26.5 0-44.2-35.8-80-80-80-24.5 0-46.5 11-61.2 28.4l-47.1-26.9-9-5.1C149.3 23.8 192 0 240.4 0 274.1 0 305 11.6 329.6 30.9 340.8 12.4 361.1 0 384.4 0l64 0c35.1 0 63.7 28.3 64 63.4l-3.7 2.1-60.3 34.4 0-35.9-64 0 0 64-.9 0c.3 2.8 .5 5.7 .7 8.6l-63.8 36.5-4.5-2.6zM80.4 392l0-90.5c-34.6-18.5-59.7-32-75.4-40.4 3.3-6.2 27.1-50.3 71.2-132.2l15.4-28.6 28.3 15.7 200.5 111.4 200.5-111.4 25.8-14.3c5.6 8.5 27.1 40.7 64.4 96.6l17.8 26.6-53.3 35.5-15.1-22.7 0 154.3-240 136-240-136zM278.9 277.6l-161.7-89.8-25.4 47.2 165.8 88.8 21.3-46.2z"],
    "cherries": [576, 512, [], "e0ec", "M261.9 0L172.1 209.5c-17.4-11.1-38-17.5-60.1-17.5-61.9 0-112 50.1-112 112 0 97.2 86 176 192 176s192-78.8 192-176c0-61.9-50.1-112-112-112-15.6 0-30.5 3.2-44 9L292.8 49.8 407.3 218.5c15.7 24.7 24.7 54.1 24.7 85.5 0 70.8-34.3 131.9-86.8 172.4 12.5 2.4 25.5 3.6 38.8 3.6 106 0 192-78.8 192-176 0-61.9-50.1-112-112-112-5.4 0-10.7 .4-15.9 1.1L317 0 261.9 0z"],
    "vacuum-robot": [512, 512, [], "e04e", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm95-351c-52.5-52.5-137.6-52.5-190.1 0L127 127c71.2-71.2 186.7-71.2 257.9 0s71.2 186.7 0 257.9L351 351c52.5-52.5 52.5-137.6 0-190.1zM208 206.1c3.5 3.5 30.5 30.5 81 81l17 17-33.9 33.9c-3.5-3.5-30.5-30.5-81-81l-17-17 33.9-33.9zm-64 64c3.5 3.5 30.5 30.5 81 81l17 17-33.9 33.9c-3.5-3.5-30.5-30.5-81-81l-17-17 33.9-33.9z"],
    "circle-eurozone": [512, 512, [], "e745", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM136 144l96 0 0 48-72 0 0 43.2 64 0 0 48-64 0 0 36.8 73.6 0 0 48-121.6 0 0-224 24 0zm152 0l115.8 0c-1.5 3.8-25.5 62.4-72 176l68.3 0 0 48-139.7 0c1.5-3.8 25.5-62.4 72-176l-68.3 0 0-48 24 0z"],
    "shoe-prints": [576, 512, [], "f54b", "M256 160l-32 0 0-128 160-32 192 64 0 112-192 48-128-64zM64 32l112 0 0 128-112 0 0-128zM512 336l0 112-192 64-160-32 0-128 32 0 128-64 192 48zM0 480l0-128 112 0 0 128-112 0z"],
    "squirrel": [512, 512, [], "f71a", "M160 299.3c-19.9 22.6-32 52.2-32 84.7l0 128 352 0 0-64-48 0c10-13.4 16-30 16-48 0-26.2-12.6-49.4-32-64-13.4-10-30-16-48-16-9.4 0-18.3 1.6-26.7 4.5l-10.7-30.2c11.7-4.1 24.3-6.4 37.3-6.4 17.2 0 33.5 3.9 48 10.8l0-58.8 64 0 32-48 0-32-87.9-58.6c-2.5-1.7-5.3-3-8.1-3.9L416 64c-20.4 0-38.2 10.9-48 27.1-9.8-16.3-27.6-27.1-48-27.1l0 160-25.3 38c-2.2-.7-4.4-1.3-6.7-1.9l0-116C288 64.5 223.5 0 144 0S0 64.5 0 144 64.5 288 144 288c5.4 0 10.7-.3 16-.9l0 12.2zM416 144a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"],
    "circle-cedi": [512, 512, [], "e742", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm24-179.7c16.1-5.1 30.1-15.1 40-28.3l38.4 28.8c-18.7 25-46.5 42.9-78.4 48.9l0 34.2-48 0 0-34.2C172.8 370.5 128 318.5 128 256s44.8-114.5 104-125.8l0-34.2 48 0 0 34.2c31.9 6.1 59.6 24 78.4 48.9L320 208c-10-13.3-23.9-23.3-40-28.3l0 152.7zM232 179.7c-32.5 10.2-56 40.5-56 76.3s23.5 66.1 56 76.3l0-152.7z"],
    "file-circle-exclamation": [576, 512, [], "e4eb", "M272 0l-240 0 0 512 244 0c-22.7-31.5-36-70.2-36-112 0-100.6 77.4-183.2 176-191.3L416 144 272 0zm85.5 176L240 176 240 58.5 357.5 176zM432 544a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm16-64l-32 0 0-32 32 0 0 32zm0-176l0 112-32 0 0-112 32 0z"],
    "wallet": [512, 512, [], "f555", "M480 32l-480 0 0 416 512 0 0-320-464 0 0-48 432 0 0-48zM416 256a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "square-tugrik": [448, 512, [], "e728", "M448 32l-448 0 0 448 448 0 0-448zM112 128l224 0 0 48-88 0 0 39.1c33.3-11.1 52.6-17.5 58.1-19.4l10.1 30.4c-3.8 1.3-26.6 8.9-68.2 22.7l0 30.3c33.3-11.1 52.6-17.5 58.1-19.4l10.1 30.4c-3.8 1.3-26.6 8.9-68.2 22.7l0 71.1-48 0 0-55.1c-33.3 11.1-52.6 17.5-58.1 19.4l-10.1-30.4c3.8-1.3 26.6-8.9 68.2-22.7l0-30.3c-33.3 11.1-52.6 17.5-58.1 19.4l-10.1-30.4c3.8-1.3 26.6-8.9 68.2-22.7l0-55.1-88 0 0-48z"],
    "message": [512, 512, ["comment-alt"], "f27a", "M0 448l0-416 512 0 0 416-224 0-160 96 0-96-128 0z"],
    "trophy": [512, 512, [127942], "f091", "M97.6 64C96.6 43.9 96 22.6 96 0L416 0c0 22.6-.6 43.9-1.6 64l97.6 0 0 24c0 56.8-12.7 101.7-33.5 136.8-20.9 35.2-49.2 59.3-78.5 75.7-18 10.1-36.5 17.4-54.1 22.5-20.2 28.6-41.2 43.7-57.9 51.8l0 73.1 96 0 0 64-256 0 0-64 96 0 0-73.1c-16-7.7-35.9-22-55.3-48.3-20.5-5.4-42.8-13.8-64.5-26.8-56.3-34.1-104.2-98-104.2-211.8l0-24 97.6 0zm3.6 48l-52.4 0c6 81.7 42.4 123.8 80.2 146.7 1.6 1 3.3 2 5 2.9-14.4-37.3-26.3-86-32.8-149.6zM379.8 256.8c22-12.9 42.3-31 57.4-56.5 13.2-22.2 23-50.9 25.9-88.4l-52.3 0c-6.2 60.9-17.4 108.2-31 144.8z"],
    "face-dizzy": [512, 512, ["dizzy"], "f567", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM134.1 153.9L160 179.7c19.2-19.2 32.5-32.5 40-40L228.3 168c-7.5 7.5-20.8 20.8-40 40 19.2 19.2 32.5 32.5 40 40L200 276.3c-7.5-7.5-20.8-20.8-40-40-19.2 19.2-32.5 32.5-40 40l-28.3-28.3 40-40c-19.2-19.2-32.5-32.5-40-40l28.3-28.3 14.1 14.1zm192 0L352 179.7c19.2-19.2 32.5-32.5 40-40L420.3 168c-7.5 7.5-20.8 20.8-40 40 19.2 19.2 32.5 32.5 40 40L392 276.3c-7.5-7.5-20.8-20.8-40-40-19.2 19.2-32.5 32.5-40 40L283.7 248c7.5-7.5 20.8-20.8 40-40-19.2-19.2-32.5-32.5-40-40l28.3-28.3 14.1 14.1zM256 304a64 64 0 1 1 0 128 64 64 0 1 1 0-128z"],
    "bacteria": [640, 512, [], "e059", "M280-32l0 35c8.6 2.2 16.9 5.6 24.8 10.3 2.4-2.4 10.1-10.1 23.2-23.2L361.9 24c-13.1 13.1-20.8 20.8-23.2 23.2 4.6 7.8 8 16.2 10.3 24.8l35 0 0 48-35 0c-2.2 8.6-5.6 16.9-10.3 24.8 2.4 2.4 10.1 10.1 23.2 23.2L328 201.9c-13.5-13.5-20.5-20.5-21.1-21.1l-30.1 30.1c.6 .6 7.6 7.6 21.1 21.1L264 265.9c-13.5-13.5-20.5-20.5-21.1-21.1-10 10-20 20-30.1 30.1 .6 .6 7.6 7.6 21.1 21.1L200 329.9c-13.1-13.1-20.8-20.8-23.2-23.2-7.8 4.6-16.2 8-24.8 10.3l0 35-48 0 0-35c-8.6-2.2-16.9-5.6-24.8-10.3-2.4 2.4-10.1 10.1-23.2 23.2L22.1 296c13.1-13.1 20.8-20.8 23.2-23.2-4.6-7.8-8-16.2-10.3-24.8l-35 0 0-48 35 0c2.2-8.6 5.6-16.9 10.3-24.8L22.1 152 56 118.1 77.1 139.1c10-10 20-20 30.1-30.1L86.1 88 120 54.1 141.1 75.1 171.1 45.1 150.1 24 184-9.9c13.1 13.1 20.8 20.8 23.2 23.2 7.8-4.6 16.2-8 24.8-10.3l0-35 48 0zM128 256a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM240 144a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm296 40l0 11c8.6 2.2 16.9 5.6 24.8 10.3 2.4-2.4 10.1-10.1 23.2-23.2L617.9 216c-13.1 13.1-20.8 20.8-23.2 23.2 4.6 7.8 8 16.2 10.3 24.8l35 0 0 48-35 0c-2.2 8.6-5.6 16.9-10.3 24.8L617.9 360 584 393.9c-13.5-13.5-20.5-20.5-21.1-21.1l-30.1 30.1 21.1 21.1-33.9 33.9-21.1-21.1c-10 10-20 20-30.1 30.1l21.1 21.1-33.9 33.9-23.2-23.2c-7.8 4.6-16.2 8-24.8 10.3l0 35-48 0 0-35c-8.6-2.2-16.9-5.6-24.8-10.3-2.4 2.4-10.1 10.1-23.2 23.2L278.1 488c13.1-13.1 20.8-20.8 23.2-23.2-4.6-7.8-8-16.2-10.3-24.8l-35 0 0-48 35 0c2.2-8.6 5.6-16.9 10.3-24.8-2.4-2.4-10.1-10.1-23.2-23.2L312 310.1c13.5 13.5 20.5 20.5 21.1 21.1 10-10 20-20 30.1-30.1L342.1 280 376 246.1c13.5 13.5 20.5 20.5 21.1 21.1l30.1-30.1c-.6-.6-7.6-7.6-21.1-21.1L440 182.1c13.1 13.1 20.8 20.8 23.2 23.2 7.8-4.6 16.2-8 24.8-10.3l0-35 48 0 0 24zM448 384a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "toggle-large-on": [576, 512, [], "e5b1", "M576 64l-576 0 0 384 576 0 0-384zm-64 64l0 256-256 0 0-256 256 0z"],
    "ear-deaf": [512, 512, ["deaf", "deafness", "hard-of-hearing"], "f2a4", "M509.5 48c-33.7 33.7-58.9 58.9-69.3 69.3L395 72c33.7-33.7 58.9-58.9 69.3-69.3L509.5 48zm-304 304L70.9 486.6 48.3 509.3 3 464c.2-.2 45.1-45.1 134.6-134.6l22.6-22.6 45.3 45.3zm34.7-224c-61.9 0-112 50.1-112 112l-64 0c0-97.2 78.8-176 176-176s176 78.8 176 176c0 54.7-25 103.5-64 135.8l0 24.2c0 61.9-50.1 112-112 112l-32 0 0-64 32 0c26.5 0 48-21.5 48-48l0-57.3 14.2-9.5c30.1-20.1 49.8-54.4 49.8-93.2 0-61.9-50.1-112-112-112zm-32 112l-48 0c0-44.2 35.8-80 80-80s80 35.8 80 80l-48 0c0-17.7-14.3-32-32-32s-32 14.3-32 32z"],
    "people-arrows": [512, 512, ["people-arrows-left-right"], "e068", "M32 64A64 64 0 1 1 160 64 64 64 0 1 1 32 64zM160 350.4l0 161.6-128 0 0-160-32 0 0-192 161.7 0c-48.7 44.6-83.6 76.6-104.7 96 21.4 19.6 55.8 51.1 103 94.4zM352 512l0-161.6c47.3-43.3 81.6-74.8 103-94.4-21.1-19.4-56.1-51.4-104.7-96l161.7 0 0 192-32 0 0 160-128 0zm0-448a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zM224 168l0 62.4 64 0 0-62.4 96 88-96 88 0-62.4-64 0 0 62.4-96-88 96-88z"],
    "treasure-chest": [512, 512, [], "f723", "M80 41.3l0 206.7-80 0 0-88C0 106.3 33.1 60.3 80 41.3zM0 296l80 0 0 184-80 0 0-184zM128 480l0-184 96 0 0 56 64 0 0-56 96 0 0 184-256 0zm304 0l0-184 80 0 0 184-80 0zm80-232l-80 0 0-206.7c46.9 19 80 65 80 118.7l0 88zM384 32l0 216-96 0 0-56-64 0 0 56-96 0 0-216 256 0z"],
    "caret-large-right": [320, 512, [], "e82e", "M64 40L296 256 64 472 64 40z"],
    "hands-clapping": [576, 512, [], "e1a8", "M376.4 8l0 88-48 0 0-112 48 0 0 24zm-124 2.7c24.4 36.7 39.6 59.3 45.3 68l-39.9 26.6c-5.8-8.6-20.9-31.3-45.3-68l-13.3-20 39.9-26.6 13.3 20zm-68 91.4l17 17 151 151 0-110.1 64 0 0 185.6c0 57.1-30 110-78.9 139.4-63.9 38.4-145.8 28.3-198.5-24.4l-99.5-99.5-17-17 33.9-33.9c3.5 3.5 30.5 30.5 81 81l22.1-22.1-104-104-17-17 33.9-33.9 17 17 104 104 22.1-22.1-128-128-17-17 33.9-33.9 17 17 128 128 22.1-22.1-104-104-17-17 33.9-33.9zM465.5 484.9c-24.2 14.5-50.9 22.1-77.7 23.1 48.1-39.6 76.6-99 76.6-162.4l0-91.5 16 16 0-110.1 64 0 0 185.6c0 57.1-30 110-78.9 139.4zm.3-494.2l39.9 26.6c-5.8 8.6-20.9 31.3-45.3 68l-13.3 20-39.9-26.6c5.8-8.6 20.9-31.3 45.3-68l13.3-20z"],
    "circle-ampersand": [512, 512, [], "e0f8", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM168 128l144 0 0 59.7c0 20.4-9.7 39.6-26.2 51.6l-18 13.2 28.6 29.9c20.9-30.1 34.7-50 41.4-59.8l39.5 27.3c-5.8 8.4-21.5 31-47 67.9l60.9 63.6c.8 .8 1.5 1.7 2.2 2.6l-66.1 0-24.8-25.9c-7.8 11.3-13.8 19.9-17.9 25.9l-140.6 0 0-63.7c0-22.9 10.9-44.5 29.4-58.1l21.9-16.1-7.3-7.7c-12.8-13.4-20-31.2-20-49.8l0-60.7zm66.4 89.6l23.1-16.9c4.1-3 6.5-7.8 6.5-12.9l0-11.7-48 0 0 12.7c0 6.2 2.4 12.1 6.7 16.6l11.7 12.2zm-5.6 63.6l-27 19.8c-6.2 4.5-9.8 11.7-9.8 19.4l0 15.7 67.4 0 9.2-13.3-39.8-41.5z"],
    "virus-covid-slash": [576, 512, [], "e4a9", "M49.3-16.9l-17-17-33.9 33.9 17 17 512 512 17 17 33.9-33.9c-1.6-1.6-32.3-32.3-92.1-92.1 6.6-6.6 16-16 28.2-28.2l-33.9-33.9c-12.3 12.3-21.7 21.7-28.2 28.2l-23.8-23.8c17.8-23.5 29.9-51.6 34.1-82.3l33.6 0 0 40 48 0 0-128-48 0 0 40-33.6 0c-4.2-30.7-16.3-58.8-34.1-82.3l23.8-23.8c6.6 6.6 16 16 28.3 28.3l33.9-33.9C439 44.8 434.3 40.1 423.9 29.7L390 63.7c12.3 12.3 21.7 21.7 28.3 28.3l-23.8 23.8c-23.5-17.9-51.7-29.9-82.3-34.1l0-33.6 40 0 0-48-128 0 0 48 40 0 0 33.6c-30.6 4.2-58.8 16.2-82.3 34.1l-23.8-23.8 28.2-28.2-33.9-33.9C140.1 42 130.7 51.4 124.1 58L49.3-16.9zm74.3 210.2c-4.7 12.3-8 25.2-9.9 38.7l-33.6 0 0-40-48 0 0 128 48 0 0-40 33.6 0c4.2 30.7 16.3 58.8 34.1 82.3l-23.8 23.8c-6.6-6.6-16-16-28.3-28.3L61.9 391.8c75.4 75.4 80.1 80.1 90.5 90.5l33.9-33.9c-12.3-12.3-21.7-21.7-28.3-28.3l23.8-23.8c23.5 17.9 51.7 29.9 82.3 34.1l0 33.6-40 0 0 48 128 0 0-48-40 0 0-33.6c13.4-1.8 26.4-5.2 38.7-9.9L123.6 193.3z"],
    "chart-simple-horizontal": [448, 512, [], "e474", "M384 128L0 128 0 0 384 0 384 128zm64 64l0 128-448 0 0-128 448 0zM256 384l0 128-256 0 0-128 256 0z"],
    "down-from-dotted-line": [384, 512, [], "e407", "M192 522.9l-192-202.9 128 0 0-192 128 0 0 192 128 0-192 202.9zM0 64L0 0 64 0 64 64 0 64zm170.7 0l-64 0 0-64 64 0 0 64zm42.7 0l0-64 64 0 0 64-64 0zM384 64l-64 0 0-64 64 0 0 64z"],
    "calendar-days": [448, 512, ["calendar-alt"], "f073", "M160 0l0 64 128 0 0-64 64 0 0 64 96 0 0 416-448 0 0-416 96 0 0-64 64 0zM64 288l64 0 0-64-64 0 0 64zm128-64l0 64 64 0 0-64-64 0zm192 64l0-64-64 0 0 64 64 0zM64 416l64 0 0-64-64 0 0 64zm192-64l-64 0 0 64 64 0 0-64zm64 64l64 0 0-64-64 0 0 64z"],
    "lighthouse": [576, 512, [], "e612", "M42.9 10.5c49.7 24.9 78.2 39.1 85.5 42.7L106.9 96.2c-7.2-3.6-35.7-17.9-85.5-42.7L0 42.7 21.5-.2 42.9 10.5zm64 202.9c-49.7 24.9-78.2 39.1-85.5 42.7L0 213.3c7.2-3.6 35.7-17.9 85.5-42.7l21.5-10.7 21.5 42.9-21.5 10.7zM160.2 64l128-64c74.7 37.3 117.3 58.7 128 64l0 48-32 0 0 48 32 0 0 64-19.2 0 44.8 224 38.4 0 0 64-384 0 0-64 38.4 0 44.8-224-19.2 0 0-64 32 0 0-48-32 0 0-48zm160 48l0-24.4-32-16-32 16 0 72.4 64 0 0-48zM554.9-.2l21.5 42.9c-7.2 3.6-35.7 17.9-85.5 42.7L469.5 96.2 448 53.3c7.2-3.6 35.7-17.9 85.5-42.7L554.9-.2zM448 202.7l21.5-42.9c7.2 3.6 35.7 17.9 85.5 42.7l21.5 10.7-21.5 42.9c-7.2-3.6-35.7-17.9-85.5-42.7L448 202.7zM320.2 368l-64 0 0 96 64 0 0-96z"],
    "diamond-turn-right": [576, 512, ["directions"], "f5eb", "M288-16L16 256 288 528 560 256 288-16zM417 257c-57.2 57.2-86.8 86.8-89 89L294.1 312c9-9 25-25 48-48l-102.1 0 0 88-48 0 0-136 150.1 0c-23-23-39-39-48-48L328 134.1c2.1 2.1 31.8 31.8 89 89l17 17-17 17z"],
    "drone": [512, 512, [], "f85f", "M417.7 338.5c26.8 7.7 46.3 32.3 46.3 61.5 0 35.3-28.7 64-64 64-29.2 0-53.9-19.6-61.5-46.3L320.8 400 288 400c0 61.9 50.1 112 112 112s112-50.1 112-112-50.1-112-112-112l0 32.8 17.7 17.7zM512 112C512 50.1 461.9 0 400 0S288 50.1 288 112l32.8 0 17.7-17.7c7.7-26.8 32.3-46.3 61.5-46.3 35.3 0 64 28.7 64 64 0 29.2-19.6 53.9-46.3 61.5L400 191.2 400 224c61.9 0 112-50.1 112-112zM112 0C50.1 0 0 50.1 0 112S50.1 224 112 224l0-32.8-17.7-17.7c-26.8-7.7-46.3-32.3-46.3-61.5 0-35.3 28.7-64 64-64 29.2 0 53.9 19.6 61.5 46.3l17.7 17.7 32.8 0C224 50.1 173.9 0 112 0zm0 288C50.1 288 0 338.1 0 400s50.1 112 112 112 112-50.1 112-112l-32.8 0-17.7 17.7c-7.7 26.8-32.3 46.3-61.5 46.3-35.3 0-64-28.7-64-64 0-29.2 19.6-53.9 46.3-61.5l17.7-17.7 0-32.8zM318.1 160l-124.1 0c-51.3-51.3-78.6-78.6-81.9-81.9L78.1 112c3.3 3.3 30.6 30.6 81.9 81.9l0 124.1c-51.3 51.3-78.6 78.6-81.9 81.9L112 433.9c3.3-3.3 30.6-30.6 81.9-81.9l124.1 0c51.3 51.3 78.6 78.6 81.9 81.9L433.9 400c-3.3-3.3-30.6-30.6-81.9-81.9l0-124.1c51.3-51.3 78.6-78.6 81.9-81.9L400 78.1c-3.3 3.3-30.6 30.6-81.9 81.9z"],
    "text": [384, 512, [], "f893", "M0 32l384 0 0 128-64 0 0-64-96 0 0 320 80 0 0 64-224 0 0-64 80 0 0-320-96 0 0 64-64 0 0-128z"],
    "square-guarani": [448, 512, [], "e70e", "M448 32l-448 0 0 448 448 0 0-448zM208 112l32 0 0 25.1c26.3 3.5 50 15.6 68 33.2l-33.6 34.3c-9.4-9.2-21.2-15.8-34.4-18.8l0 46.2 104 0 0 24c0 60.8-45.3 111.1-104 118.9l0 25.1-32 0 0-25.1c-58.7-7.8-104-58.1-104-118.9s45.3-111.1 104-118.9l0-25.1zM152 256c0 34.3 23.9 62.9 56 70.2l0-140.4c-32.1 7.3-56 36-56 70.2zm139.9 24l-51.9 0 0 46.2c24.2-5.5 43.8-23.2 51.9-46.2z"],
    "toilet-paper-under-slash": [576, 512, ["toilet-paper-reverse-slash"], "e2a1", "M49.3-16.9l-17-17-33.9 33.9 17 17 512 512 17 17 33.9-33.9c-11.3-11.3-22.7-22.7-34.1-34.1l0-254c0-106-43-192-96-192s-96 86-96 192c0 24 2.2 47 6.2 68.2l-54-54c-.2-4.7-.2-9.4-.2-14.2 0-58.9 11.8-114.5 33.2-157.2 5.8-11.7 13.1-23.7 21.9-34.8L128.1 32c-8.3 0-16.3 2.1-23.9 6L49.3-16.9zM394.3 464l-234.2 0 0 80 314.2 0-80-80zm-48-48L48.1 117.8c-10.1 30.4-16 66.9-16 106.2 0 106 43 192 96 192l218.2 0zm69.8-192c0-35.3 14.3-64 32-64s32 28.7 32 64-14.3 64-32 64-32-28.7-32-64z"],
    "hand-point-up": [384, 512, [9757], "f0a6", "M32 0l64 0 0 240-64 0 0-240zM224 160l64 0 0 128-64 0 0-128zm-32-32l0 112-64 0 0-112 64 0zm128 64l64 0 0 128-64 0 0-128zM0 363l0-91 192 0 0 80-112 0 0 32 144 0 0-64 64 0 0 32 96 0c0 88.4-71.6 160-160 160l-61.7 0c-42.4 0-83.1-16.9-113.1-46.9L37.5 453.5C13.5 429.5 0 396.9 0 363z"],
    "pen-slash": [576, 512, [], "e213", "M49.3-16.9l-17-17-33.9 33.9 17 17 512 512 17 17 33.9-33.9-17-17-184.1-184.1 62-62-144-144-62 62-183.9-183.9zM165.2 234.9l-93.1 93.1-56 200 200-56 93.1-93.1-144-144zM473.1 215l87-87-144-144-87 87 144 144z"],
    "comment-plus": [512, 512, [], "f4b2", "M512 240c0 132.5-114.6 240-256 240-38.3 0-74.7-7.9-107.3-22.1L0 512 55.7 389.5C20.8 348.5 0 296.5 0 240 0 107.5 114.6 0 256 0S512 107.5 512 240zM232 350.4l48 0 0-86.4 86.4 0 0-48-86.4 0 0-86.4-48 0 0 86.4-86.4 0 0 48 86.4 0 0 86.4z"],
    "bezier-curve": [640, 512, [], "f55b", "M344 88l0 48-48 0 0-48 48 0zM296 32l-56 0 0 52-118.4 0C111.2 62.7 89.3 48 64 48 28.7 48 0 76.7 0 112s28.7 64 64 64c25.3 0 47.2-14.7 57.6-36l66.9 0c-58.9 39.6-98.9 105-104 180l-52.5 0 0 160 160 0 0-160-51.3 0c5.6-63.8 44.6-118.1 99.3-145.3l0 17.3 160 0 0-17.3c54.7 27.2 93.7 81.5 99.3 145.3l-51.3 0 0 160 160 0 0-160-52.5 0c-5-75-45.1-140.4-104-180l66.9 0c10.4 21.3 32.3 36 57.6 36 35.3 0 64-28.7 64-64s-28.7-64-64-64c-25.3 0-47.2 14.7-57.6 36l-118.4 0 0-52-104 0zM136 376l0 48-48 0 0-48 48 0zm368 0l48 0 0 48-48 0 0-48z"],
    "clipboard-list-check": [384, 512, [], "f737", "M320 0l-256 0 0 32-64 0 0 480 384 0 0-480-64 0 0-32zM112 112l0-48 160 0 0 48-160 0zm58.1 101.2c-2.5 3.1-21.7 26.7-57.4 70.9l-3.2 3.9-23.5 0-3.2-4c-18.7-23.4-31-38.8-36.9-46.1l30-24c8.3 10.4 15.7 19.6 22 27.5 23.3-28.7 37.4-46.2 42.4-52.4l29.8 24.2zM192 232l128 0 0 48-128 0 0-48zM176 360l144 0 0 48-144 0 0-48zM64 352l64 0 0 64-64 0 0-64z"],
    "lamp-desk": [512, 512, [], "e014", "M213.7 117.7L208 112c-26.5-26.5-26.5-69.5 0-96s69.5-26.5 96 0l48 48 112 0 48 48-208 208-48-48 0-105.7-92.7 98.9 45.7 182.8 175 0 0 64-199.3 0c-.5 0-.9 0-1.4 0l-183.3 0 0-64 143 0-46.1-184.2-4.2-16.9 11.9-12.7 109.1-116.4z"],
    "person-half-dress": [384, 512, [], "e548", "M248.2 24c0-30.9-25.1-56-56-56-3 0-5.9 .2-8.8 .7-26.8 4.2-47.2 27.4-47.2 55.3 0 30.9 25.1 56 56 56 3.5 0 7.3-.3 11.3-1.1 25.5-5.2 44.7-27.8 44.7-54.9zm-40 88l0 224 0 0 0 208 64 0 0-305.7c28.6 39.4 47.6 65.6 56.9 78.4l51.8-37.6c-.2-.2-37.4-51.6-111.7-153.9l-9.6-13.2-51.4 0zm-32 272l0-272-51.4 0-9.6 13.2-92.9 128-18.8 25.9 51.8 37.6c9.1-12.6 28.5-39.2 57.9-79.8l-49 147.1 48 0 0 160 64 0 0-160 0 0z"],
    "peanut": [512, 512, [], "e430", "M0 512L0 362.9C0 315.5 21.1 270.4 57.6 240l5.1-4.2c21.8-18.2 48.1-30.2 76.1-34.9l53.2-8.9 6.7-40.4c6-36.2 23.2-69.6 49.2-95.5l4.6-4.6C285.5 18.5 330.2 0 376.9 0L512 0 512 135.1c0 46.7-18.5 91.4-51.5 124.5l-4.6 4.6c-25.9 25.9-59.3 43.1-95.5 49.2l-40.4 6.7-7.6 45.4c-5.5 32.9-21.1 63.3-44.7 86.8l-12.9 12.9c-30 30-70.7 46.9-113.1 46.9L0 512zM435.2 128a19.2 19.2 0 1 0 -38.4 0 19.2 19.2 0 1 0 38.4 0zm0 64a19.2 19.2 0 1 0 -38.4 0 19.2 19.2 0 1 0 38.4 0zm-64 0a19.2 19.2 0 1 0 -38.4 0 19.2 19.2 0 1 0 38.4 0zm-224 224a19.2 19.2 0 1 0 -38.4 0 19.2 19.2 0 1 0 38.4 0zM192 435.2a19.2 19.2 0 1 0 0-38.4 19.2 19.2 0 1 0 0 38.4zm0-64a19.2 19.2 0 1 0 0-38.4 19.2 19.2 0 1 0 0 38.4z"],
    "message-plus": [512, 512, ["comment-alt-plus"], "f4a8", "M0 32l0 416 128 0 0 96 160-96 224 0 0-416-512 0zM232 350.4l0-86.4-86.4 0 0-48 86.4 0 0-86.4 48 0 0 86.4 86.4 0 0 48-86.4 0 0 86.4-48 0z"],
    "bracket-curly": [256, 512, ["bracket-curly-left"], "7b", "M96 32l-32 0 0 146.7-54.6 54.6-9.4 9.4 0 26.5 9.4 9.4 54.6 54.6 0 146.7 160 0 0-64-96 0 0-109.3c-.9-.9-17.8-17.8-50.7-50.7 32.9-32.9 49.8-49.8 50.7-50.7l0-109.3 96 0 0-64-128 0z"],
    "square-poll-horizontal": [448, 512, ["poll-h"], "f682", "M448 480l0-448-448 0 0 448 448 0zM256 176l-160 0 0-48 160 0 0 48zm96 56l0 48-256 0 0-48 256 0zM192 384l-96 0 0-48 96 0 0 48z"],
    "nfc-signal": [576, 512, [], "e1fb", "M32 32l448 0 0 217c-22.6 5.9-44 14.6-64 25.6l0-178.6-184 0 0 118.4c-14.3 8.3-24 23.8-24 41.6 0 26.5 21.5 48 48 48s48-21.5 48-48c0-17.8-9.7-33.3-24-41.6l0-70.4 88 0 0 164.2c-20 17.3-37.4 37.5-51.8 59.8l-172.2 0 0-224 40 0 0-48-88 0 0 320 195.5 0c-8 20.3-13.8 41.7-16.9 64L32 480 32 32zM552 288l24 0 0 48-24 0c-101.6 0-184 82.4-184 184l0 24-48 0 0-24c0-128.1 103.9-232 232-232zm-8 192a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm32-96l0 48-24 0c-48.6 0-88 39.4-88 88l0 24-48 0 0-24c0-75.1 60.9-136 136-136l24 0z"],
    "box-isometric": [512, 512, [], "e797", "M256 65.6L413.8 155 361.2 183.3 205.3 94.3 256 65.6zm-99.2 56.2l154.6 88.4-55.4 29.8-157.8-85 58.6-33.2zM256 536L496 400 496 128 256-8 16 128 16 400 256 536z"],
    "school-circle-xmark": [640, 512, [], "e56d", "M128 128l-128 0 0 384 340 0c-10.5-14.6-19-30.7-25.1-48l-90.9 0 0-128 90.9 0c26.4-74.6 97.5-128 181.1-128 28.6 0 55.6 6.2 80 17.4l0-97.4-128 0-160-128-160 128zm0 256l-64 0 0-64 64 0 0 64zM64 256l0-64 64 0 0 64-64 0zM288 128a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM496 544a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm55.3-176.7L518.6 400c25.4 25.3 40 40 44 44L540 466.6c-4-4-18.6-18.6-44-44-25.3 25.4-40 40-44 44L429.4 444c4-4 18.6-18.6 44-44-25.4-25.3-40-40-44-44L452 333.4c4 4 18.6 18.6 44 44 25.3-25.4 40-40 44-44l22.6 22.6-11.3 11.3z"],
    "person-seat-window": [512, 512, [], "e788", "M176 128a56 56 0 1 0 0-112 56 56 0 1 0 0 112zm-16 48l-32 0 0 144c0 35.3 28.7 64 64 64l96 0 0 128 112 0 0-64-48 0 0-128-120 0 0-144-72 0zM80 160l-64 0 0 336 224 0 0-64-160 0 0-272zM480 32l-160 0 0 224 160 0 0-224z"],
    "grapes": [576, 512, [], "e306", "M400-16L423.4 7.4c31.2 31.2 31.2 81.9 0 113.1 31.2-31.2 81.9-31.2 113.1 0L560 144 536.6 167.4c-31.2 31.2-81.9 31.2-113.1 0l-46.9-46.9c-31.2-31.2-31.2-81.9 0-113.1L400-16zM224 152a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm-80-32a56 56 0 1 1 0 112 56 56 0 1 1 0-112zM64 312a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zM32 456a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm144-32a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm192-80a56 56 0 1 1 0 112 56 56 0 1 1 0-112zM200 288a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm192-80a56 56 0 1 1 0 112 56 56 0 1 1 0-112z"],
    "hand-lizard": [512, 512, [], "f258", "M0 64l345.1 0 14.3 20.7 144 208 8.5 12.3 0 143-160 0 0-45.8-78.1-50.2-209.9 0 0-96 176 0c26.5 0 48-21.5 48-48s-21.5-48-48-48L0 160 0 64z"],
    "camera-slash": [576, 512, [], "e0d9", "M49.3-16.9l-17-17-33.9 33.9 17 17 512 512 17 17 33.9-33.9c-11.3-11.3-22.7-22.7-34.1-34.1l0-382-128 0-32-64-192 0-31.3 62.6-111.5-111.5zM261.8 195.6c8.4-2.4 17.2-3.7 26.3-3.7 53 0 96 43 96 96 0 9.1-1.3 18-3.7 26.3L261.8 195.6zM192.1 288c0-8 1-15.9 2.9-23.3l-162.9-162.9 0 378.2 378.2 0-98.9-98.9c-7.5 1.9-15.3 2.9-23.3 2.9-53 0-96-43-96-96z"],
    "chalkboard": [576, 512, ["blackboard"], "f51b", "M64 64l-32 0 0 320-32 0 0 64 576 0 0-64-32 0 0-320-480 0zM480 384l-64 0 0-64-192 0 0 64-128 0 0-256 384 0 0 256z"],
    "memo-pad": [384, 512, [], "e1da", "M384 0L0 0 0 96 384 96 384 0zm0 144l-384 0 0 368 384 0 0-368zM104 192l200 0 0 48-224 0 0-48 24 0zm0 96l200 0 0 48-224 0 0-48 24 0zm0 96l120 0 0 48-144 0 0-48 24 0z"],
    "bluetooth": [384, 512, [], "f293", "M160.3 0c21.3 16 81.1 60.8 179.2 134.4L373.7 160c-12.8 9.6-55.5 41.6-128 96 72.5 54.4 115.2 86.4 128 96-7.1 5.3-61.2 45.9-162.1 121.6l-51.2 38.4 0-192c-59.7 44.8-93.9 70.4-102.4 76.8L19.5 345.6c5.7-4.3 45.5-34.1 119.5-89.6-74-55.5-113.8-85.3-119.5-89.6l38.4-51.2c8.5 6.4 42.7 32 102.4 76.8l0-192zm64 320l0 64 42.7-32-42.7-32zm0-128l42.7-32-42.7-32 0 64z"],
    "objects-align-center-horizontal": [448, 512, [], "e3bc", "M256 64l0-96-64 0 0 96-192 0 0 160 192 0 0 64-128 0 0 160 128 0 0 96 64 0 0-96 128 0 0-160-128 0 0-64 192 0 0-160-192 0z"],
    "distribute-spacing-vertical": [512, 512, [], "e366", "M0 32l512 0 0 64-512 0 0-64zM96 160l320 0 0 192-320 0 0-192zM512 416l0 64-512 0 0-64 512 0z"],
    "up-right-from-square": [512, 512, ["external-link-alt"], "f35d", "M270.1 0l241.9 0 0 241.9-98.3-98.3-167 167-22.6 22.6-45.3-45.3 22.6-22.6 167-167-98.3-98.3zM0 96l192 0 0 64-128 0 0 288 288 0 0-128 64 0 0 192-416 0 0-416z"],
    "square-turkish-lira": [448, 512, [], "e71f", "M448 32l-448 0 0 448 448 0 0-448zM208 128l0 68.5c46.6-15.5 71.3-23.8 74.1-24.7l10.1 30.4c-1.1 .4-29.2 9.7-84.2 28.1l0 30.3c46.6-15.5 71.3-23.8 74.1-24.7l10.1 30.4c-1.1 .4-29.2 9.7-84.2 28.1l0 41.8 48 0c26.5 0 48-21.5 48-48l0-24 48 0 0 24c0 53-43 96-96 96l-96 0 0-73.8c-19.9 6.6-34 11.3-42.1 14l-10.1-30.4c6.5-2.2 23.9-8 52.2-17.4l0-30.3c-19.9 6.6-34 11.3-42.1 14l-10.1-30.4c6.5-2.2 23.9-8 52.2-17.4l0-84.5 48 0z"],
    "rotate-exclamation": [512, 512, [], "e23c", "M512.2 256c0 65.5-25 131-75 181s-115.6 75-181 75c-69.9 0-137-27.8-186.5-77.3l-4.8-4.8c.3 35.3 .5 62.2 .7 80.8l-64 .5-.2-32-1.1-127-.2-32.2 176.2 0 0 64-66.7 0 5.5 5.5c37.5 37.5 88.3 58.5 141.2 58.5 49.2 0 98.3-18.8 135.8-56.2s56.2-86.6 56.2-135.8l64 0zm-228 124l-56 0 0-56 56 0 0 56zm-8.8-92l-38.4 0-12.8-160 64 0-12.8 160zM512.2 0l0 192-176 0 0-64 66.8 0-5.5-5.5C360.1 85 309.2 64 256.2 64 207.1 64 158 82.8 120.5 120.2S64.2 206.8 64.2 256l-64 0c0-65.5 25-131.1 75-181 50-50 115.5-75 181-75 70 0 137.1 27.8 186.5 77.2l5.5 5.5 0-82.8 64 0z"],
    "right-from-line": [576, 512, ["arrow-alt-from-left"], "f347", "M96.5 64l0 384-64 0 0-384 64 0zm459 192l-18.5 17.4c-113.3 107-174.7 165-184.5 174.2l0-127.7-192 0 0-128 192 0 0-127.7c9.7 9.2 71.2 67.3 184.5 174.2L555.4 256z"],
    "circle-q": [512, 512, [], "e11e", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM184 256c0 39.8 32.2 72 72 72 11.1 0 21.6-2.5 31-7-18.7-18.7-33-33-42.8-42.8l33.9-33.9c9.8 9.8 24.1 24.1 42.8 42.8 4.5-9.4 7-19.9 7-31 0-39.8-32.2-72-72-72s-72 32.2-72 72zm192 0c0 24.5-7.3 47.2-19.9 66.2 7.9 7.9 17.8 17.8 29.8 29.8L352 385.9c-12-12-21.9-21.9-29.8-29.8-19 12.6-41.7 19.9-66.2 19.9-66.3 0-120-53.7-120-120s53.7-120 120-120 120 53.7 120 120z"],
    "moon-over-sun": [576, 512, ["eclipse-alt"], "f74a", "M173.8-20.2c10.6 7.1 48.8 32.4 114.4 75.9 65.6-43.5 103.8-68.8 114.4-75.9 2.5 12.5 11.6 57.4 27.2 134.6 77.2 15.6 122.1 24.7 134.6 27.2-7.1 10.6-32.4 48.8-75.9 114.4 43.5 65.6 68.8 103.8 75.9 114.4-12.5 2.5-57.4 11.6-134.6 27.2-15.6 77.2-24.7 122.1-27.2 134.6-10.6-7.1-48.8-32.4-114.4-75.9-65.6 43.5-103.8 68.8-114.4 75.9-2.5-12.5-11.6-57.4-27.2-134.6-77.2-15.6-122.1-24.7-134.6-27.2 7.1-10.6 32.4-48.8 75.9-114.4-43.5-65.6-68.8-103.8-75.9-114.4 12.5-2.5 57.4-11.6 134.6-27.2 15.6-77.2 24.7-122.1 27.2-134.6zM432.2 256a144.2 144.2 0 1 0 -288.5 0 144.2 144.2 0 1 0 288.5 0zm-144-24c0 39.8 32.2 72 72 72 4 0 7.9-.3 11.7-.9-16.5 29.2-47.8 48.9-83.7 48.9-53 0-96-43-96-96s43-96 96-96c13.8 0 26.9 2.9 38.7 8.1-23 12-38.7 36.1-38.7 63.9z"],
    "360-degrees": [640, 512, [], "e2dc", "M640 32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM320 128l32 0 0-64-32 0c-53 0-96 43-96 96l0 111.8 0 .2 0 96c0 44.2 35.8 80 80 80s80-35.8 80-80l0-96c0-44.2-35.8-80-80-80-5.5 0-10.8 .6-16 1.6l0-33.6c0-17.7 14.3-32 32-32zM288 320l0-48.1c0-8.8 7.2-15.9 16-15.9 8.8 0 16 7.2 16 16l0 96c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-48zM32 64l-32 0 0 64 97.3 0-57.6 67.2-7.7 9 0 51.8 48 0c26.5 0 48 21.5 48 48l0 48c0 17.7-14.3 32-32 32s-32-14.3-32-32L0 352c0 53 43 96 96 96s96-43 96-96l0-48c0-47.6-29.8-88.3-71.7-104.5l64-74.6 7.7-9 0-51.8-160 0zm448 80c0-8.8 7.2-16 16-16s16 7.2 16 16l0 224c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-224zm16-80c-44.2 0-80 35.8-80 80l0 224c0 44.2 35.8 80 80 80s80-35.8 80-80l0-224c0-44.2-35.8-80-80-80z"],
    "bracket-round-right": [192, 512, [], "29", "M192 256C192 140.2 120.1 62.9 81.8 37.4L46.3 90.6C71.9 107.7 128 167 128 256S71.9 404.3 46.3 421.4l35.5 53.3C120.1 449 192 371.8 192 256z"],
    "square-full": [512, 512, [128997, 128998, 128999, 129000, 129001, 129002, 129003, 11035, 11036], "f45c", "M0 0L512 0 512 512 0 512 0 0z"],
    "star-sharp": [576, 512, [], "e28b", "M311.3 32.7L288.4-39.2C277.2-3.8 254 69.2 218.8 179.9l-216.3 0c25.9 20.1 84.6 65.8 176.1 136.9-35.3 111-58.8 184.9-70.5 221.6 31-24.1 91.1-70.9 180.4-140.3 89.3 69.4 149.4 116.2 180.4 140.3-11.7-36.8-35.2-110.7-70.5-221.6 91.5-71.2 150.2-116.8 176.1-136.9l-216.3 0-46.8-147.1z"],
    "list-radio": [512, 512, [], "e1d0", "M64 160a64 64 0 1 0 0-128 64 64 0 1 0 0 128zM224 64l-32 0 0 64 320 0 0-64-288 0zm0 160l-32 0 0 64 320 0 0-64-288 0zm0 160l-32 0 0 64 320 0 0-64-288 0zM40 416a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm88 0a64 64 0 1 0 -128 0 64 64 0 1 0 128 0zM64 232a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm0 88a64 64 0 1 0 0-128 64 64 0 1 0 0 128z"],
    "head-side-medical": [512, 512, [], "f809", "M224 0C338.4 0 432.7 85.7 446.3 196.4l49.7 59.6 0 64-64 0 0 128-112 0 0 64-256 0 0-131.2C24.4 340.4 0 285 0 224 0 100.3 100.3 0 224 0zM192 192l-56 0 0 64 56 0 0 56 64 0 0-56 56 0 0-64-56 0 0-56-64 0 0 56z"],
    "tombstone": [448, 512, [], "f720", "M32 192C32 86 118 0 224 0S416 86 416 192l0 256 32 0 0 64-448 0 0-64 32 0 0-256zm216-72l0-24-48 0 0 64-72 0 0 48 72 0 0 144 48 0 0-144 72 0 0-48-72 0 0-40z"],
    "square-a-lock": [576, 512, [], "e44d", "M480 32l-448 0 0 448 272 0 0-144-102 0-15.4 32-53.2 0 5-10.4 96-200 6.5-13.6 30.2 0 6.5 13.6 54.9 114.4 3.5 0c0-70.7 57.3-128 128-128 5.4 0 10.8 .3 16 1l0-113zM256 223.5l-31 64.5 62 0-31-64.5zM464 240c17.7 0 32 14.3 32 32l0 48-64 0 0-48c0-17.7 14.3-32 32-32zm-80 32l0 48-32 0 0 192 224 0 0-192-32 0 0-48c0-44.2-35.8-80-80-80s-80 35.8-80 80z"],
    "clover": [512, 512, [], "e139", "M145.6 117.7l41.9 69.8-69.8-41.9c-10.4-6.3-22.4-9.6-34.5-9.6-37.1 0-67.1 30.1-67.1 67.1l0 18.6 34.3 34.3-34.3 34.3 0 18.6c0 37.1 30.1 67.1 67.1 67.1 12.2 0 24.1-3.3 34.5-9.6l69.8-41.9-41.9 69.8c-6.3 10.4-9.6 22.4-9.6 34.5 0 37.1 30.1 67.1 67.1 67.1l18.6 0 34.3-34.3 34.3 34.3 18.6 0c37.1 0 67.1-30.1 67.1-67.1 0-12.2-3.3-24.1-9.6-34.5l-41.9-69.8 69.8 41.9c10.4 6.3 22.4 9.6 34.5 9.6 37.1 0 67.1-30.1 67.1-67.1l0-18.6-34.3-34.3 34.3-34.3 0-18.6c0-37.1-30.1-67.1-67.1-67.1-12.2 0-24.1 3.3-34.5 9.6l-69.8 41.9 41.9-69.8c6.3-10.4 9.6-22.4 9.6-34.5 0-37.1-30.1-67.1-67.1-67.1l-18.6 0-34.3 34.3-34.3-34.3-18.6 0c-37.1 0-67.1 30.1-67.1 67.1 0 12.2 3.3 24.1 9.6 34.5z"],
    "signal-bars-fair": [448, 512, ["signal-alt-2"], "f692", "M192 288l0-32-64 0 0 224 64 0 0-192zM64 416l0-32-64 0 0 96 64 0 0-64z"],
    "folder-heart": [512, 512, [], "e189", "M512 448l-512 0 0-416 224 0 64 48 224 0 0 368zM249.6 199.5c-11.1-14.8-28.5-23.5-46.9-23.5-32.4 0-58.7 26.3-58.7 58.7l0 5.3c0 64 112 128 112 128s112-64 112-128l0-5.3c0-32.4-26.3-58.7-58.7-58.7-18.5 0-35.9 8.7-46.9 23.5l-6.4 8.5-6.4-8.5z"],
    "cloud-word": [576, 512, [], "e138", "M448 480L0 480 0 336c0-62.7 40.1-116 96-135.8L96 176c0-79.5 64.5-144 144-144 55.4 0 103.5 31.3 127.6 77.1 14.2-8.3 30.8-13.1 48.4-13.1 53 0 96 43 96 96l0 49.1c38.3 22.1 64 63.5 64 110.9l0 128-128 0zM240 336l-80 0 0 48 80 0 0-48zm120-80l-24 0 0 48 80 0 0-48-56 0zm56 80l-128 0 0 48 128 0 0-48zM184 256l-24 0 0 48 128 0 0-48-104 0z"],
    "screen-users": [640, 512, ["users-class"], "f63d", "M64 0l512 0 0 212.6c-10.1-3-20.9-4.6-32-4.6s-21.9 1.6-32 4.6l0-148.6-384 0 0 148.6c-10.1-3-20.9-4.6-32-4.6s-21.9 1.6-32 4.6L64 0zM32 320a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zm224 0a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zm288-64a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM416 512l-192 0 32-96 128 0 32 96zM32 416l128 0 32 96-192 0 32-96zm608 96l-192 0 32-96 128 0 32 96z"],
    "teeth-open": [512, 512, [], "f62f", "M512 32l-512 0 0 208 512 0 0-208zm0 272l-512 0 0 176 512 0 0-176zM144 144c0-26.5 21.5-48 48-48s48 21.5 48 48l0 48-96 0 0-48zm128 0c0-26.5 21.5-48 48-48s48 21.5 48 48l0 48-96 0 0-48zM80 112c17.7 0 32 14.3 32 32l0 48-64 0 0-48c0-17.7 14.3-32 32-32zm320 32c0-17.7 14.3-32 32-32s32 14.3 32 32l0 48-64 0 0-48zM48 384l0-32 64 0 0 32c0 17.7-14.3 32-32 32s-32-14.3-32-32zm144 48c-26.5 0-48-21.5-48-48l0-32 96 0 0 32c0 26.5-21.5 48-48 48zm128 0c-26.5 0-48-21.5-48-48l0-32 96 0 0 32c0 26.5-21.5 48-48 48zm112-16c-17.7 0-32-14.3-32-32l0-32 64 0 0 32c0 17.7-14.3 32-32 32z"],
    "circle-u": [512, 512, [], "e127", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM208 168l0 104c0 26.5 21.5 48 48 48s48-21.5 48-48l0-128 48 0 0 128c0 53-43 96-96 96s-96-43-96-96l0-128 48 0 0 24z"],
    "calendar-heart": [448, 512, [], "e0d3", "M160 0l0 64 128 0 0-64 64 0 0 64 96 0 0 416-448 0 0-416 96 0 0-64 64 0zm57.6 215.5c-11.1-14.8-28.5-23.5-46.9-23.5-32.4 0-58.7 26.3-58.7 58.7l0 5.3c0 64 112 128 112 128s112-64 112-128l0-5.3c0-32.4-26.3-58.7-58.7-58.7-18.5 0-35.9 8.7-46.9 23.5l-6.4 8.5-6.4-8.5z"],
    "narwhal": [640, 512, [], "f6fe", "M640 336c0-49-20.2-93.2-52.7-125.2L640 0 511.7 166.8c-15.5-4.4-31.8-6.8-48.6-6.8-50.9 0-100.7 17.5-140.2 49.6l-194.9 158.4 0-112 64-32 0-128-96 48-96-48 0 128 64 32 0 96c0 88.4 71.6 160 160 160l240 0c97.2 0 176-78.8 176-176zM496 280a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"],
    "bars-staggered": [512, 512, ["reorder", "stream"], "f550", "M0 64l448 0 0 64-448 0 0-64zM64 224l448 0 0 64-448 0 0-64zM448 384l0 64-448 0 0-64 448 0z"],
    "warehouse": [576, 512, [], "f494", "M0 96l0 416 64 0 0-304 448 0 0 304 64 0 0-416-288-96-288 96zM464 320l0-64-352 0 0 64 352 0zM112 416l352 0 0-64-352 0 0 64zm352 96l0-64-352 0 0 64 352 0z"],
    "swatchbook": [512, 512, [], "f5c3", "M0 416c0 53 43 96 96 96s96-43 96-96L192 0 0 0 0 416zM128 64l0 64-64 0 0-64 64 0zm0 128l0 64-64 0 0-64 64 0zM72 416a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm109 96l331 0 0-192-139 0-192 192zM458 189.7L322.3 54 224 152.2 224 423.8 458 189.7z"],
    "circle-three-quarters": [512, 512, [], "e125", "M256 0C114.6 0 0 114.6 0 256S114.6 512 256 512 512 397.4 512 256l-256 0 0-256z"],
    "circle-chf": [512, 512, [], "e72c", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM136 144c22.1 0 40 17.9 40 40l0 32-32 0 0 80 32 0 0 32c0 22.1-17.9 40-40 40s-40-17.9-40-40l0-144c0-22.1 17.9-40 40-40zm104 24l0 64 16 0 0-88 48 0 0 224-48 0 0-88-16 0 0 88-48 0 0-224 48 0 0 24zm104-24l72 0 0 48-48 0 0 40 40 0 0 48-40 0 0 88-48 0 0-224 24 0z"],
    "campground": [512, 512, [9978], "f6bb", "M344.8 52.3L365 27.5 315.5-13C305.1-.4 285.3 23.9 256 59.7 226.7 23.9 206.9-.4 196.5-13L147 27.5c9 11 31.5 38.6 67.7 82.7l-207.4 253.5-7.2 8.8 0 107.4 512 0 0-107.4-7.2-8.8-207.4-253.5 47.4-58zM256 288l112 128-224 0 112-128z"],
    "person-walking-arrow-right": [640, 512, [], "e552", "M248.4 24a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zm-104 88l-13.3 0-9.4 9.4-80 80-9.4 9.4 0 109.3 64 0 0-82.7 32-32 0 69.3c0 28 12.2 54.7 33.5 72.9l80.7 69.1c11 71.6 17.4 112.9 19.1 123.9l63.3-9.7c-1.4-9-8.3-54.2-20.9-135.6l-1.8-11.7-9-7.7-52.8-45.3 0-115.2c17.6 22 28.4 35.6 32.6 40.8l111.4 0 0-64-80.6 0-54.4-68-9.6-12-95.4 0zM128.6 371L116 415.2C71.3 459.9 44.4 486.8 35.2 496l45.3 45.3 86.6-86.6 5.9-5.9c.8-2.7 3.8-13.2 9-31.5l-46-39.4c-2.5-2.2-5-4.4-7.4-6.8zM609.4 273l17-17c-2.1-2.1-31.8-31.8-89-89l-17-17-33.9 33.9c9 9 25 25 48 48l-126.1 0 0 48 126.1 0c-23 23-39 39-48 48l33.9 33.9c2.1-2.1 31.8-31.8 89-89z"],
    "spider-black-widow": [512, 512, [], "f718", "M398.5 22.8l40 96 6.2 14.8-75.5 75.4 76.4-20.8c15.4-46.1 24.5-73.6 27.5-82.6l45.5 15.2-7.6 22.8-28.1 84.2-12.4 3.4-91.2 24.8 91.2 24.9 12.4 3.4 28.1 84.2 7.6 22.8-45.5 15.2c-3-9-12.2-36.5-27.5-82.6l-76.4-20.8 75.5 75.5-6.2 14.8-40 96-9.2 22.2-44.3-18.4 9.2-22.2 33.8-81.2-35.8-35.8c-1 52.2-43.5 94.1-95.9 94.1s-95-42-96-94.1l-35.7 35.8 33.8 81.2 9.2 22.2-44.3 18.4-9.2-22.2-40-96-6.2-14.8 75.4-75.5-76.3 20.8c-15.4 46.1-24.5 73.6-27.5 82.6l-45.5-15.2 7.6-22.8 28.1-84.2 12.4-3.4 91.1-24.9-91.1-24.8-12.4-3.4-28.1-84.2-7.6-22.8 45.5-15.2c3 9 12.2 36.5 27.5 82.6l76.4 20.8-75.4-75.4 6.2-14.8 40-96 9.2-22.2 44.3 18.4-9.2 22.2-33.8 81.2 51.7 51.8c1-43.3 36.4-78.1 79.9-78.1s78.9 34.8 79.9 78.1l51.8-51.8-33.8-81.2-9.2-22.2 44.3-18.4 9.2 22.2zM216.3 288l24 40-24 40 80 0-24-40 24-40-80 0z"],
    "glasses": [576, 512, [], "f530", "M72.4 32l103.6 0 0 64-56.4 0-49.2 160 185.6 0 0 32 64 0 0-32 185.6 0-49.2-160-56.4 0 0-64 103.6 0 7 22.6 64 208 1.4 4.6 0 212.8-256 0 0-128-64 0 0 128-256 0 0-212.8 1.4-4.6 64-208 7-22.6zM64 320l0 96 128 0 0-96-128 0zm320 0l0 96 128 0 0-96-128 0z"],
    "circle-pause": [512, 512, [62092, "pause-circle"], "f28b", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM224 192l0 160-64 0 0-192 64 0 0 32zm128 0l0 160-64 0 0-192 64 0 0 32z"],
    "memory": [512, 512, [], "f538", "M512 64L0 64 0 146.7c18.6 6.6 32 24.4 32 45.3S18.6 230.7 0 237.3l0 66.7 512 0 0-66.7c-18.6-6.6-32-24.4-32-45.3s13.4-38.7 32-45.3L512 64zm0 288l-512 0 0 96 96 0 0-48 48 0 0 48 88 0 0-48 48 0 0 48 88 0 0-48 48 0 0 48 96 0 0-96zM160 160l0 96-64 0 0-128 64 0 0 32zm128 0l0 96-64 0 0-128 64 0 0 32zm128 0l0 96-64 0 0-128 64 0 0 32z"],
    "gift": [512, 512, [127873], "f06b", "M321.5 68.8C329.1 55.9 342.9 48 357.8 48l2.2 0c22.1 0 40 17.9 40 40s-17.9 40-40 40l-73.3 0 34.8-59.2zm-131 0l34.8 59.2-73.3 0c-22.1 0-40-17.9-40-40s17.9-40 40-40l2.2 0c14.9 0 28.8 7.9 36.3 20.8zm89.6-24.3l-24.1 41-24.1-41C215.7 16.9 186.1 0 154.2 0L152 0c-48.6 0-88 39.4-88 88 0 14.4 3.5 28 9.6 40l-73.6 0 0 96 512 0 0-96-73.6 0c6.1-12 9.6-25.6 9.6-40 0-48.6-39.4-88-88-88l-2.2 0c-31.9 0-61.5 16.9-77.7 44.4zM480 272l-200 0 0 208 200 0 0-208zm-248 0l-200 0 0 208 200 0 0-208z"],
    "sprinkler-ceiling": [384, 512, [], "e44c", "M0 0L0 122.2c4.4 .9 47.1 9.4 128 25.6L128 82.6 64 69.8 64 0 0 0zM256 82.6l0 65.3 128-25.6 0-122.2-64 0 0 69.8-64 12.8zM160 344a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm-48 64c0-13.3-10.7-24-24-24s-24 10.7-24 24 10.7 24 24 24 24-10.7 24-24zM24 496c13.3 0 24-10.7 24-24s-10.7-24-24-24-24 10.7-24 24 10.7 24 24 24zM272 344a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm-80 88c13.3 0 24-10.7 24-24s-10.7-24-24-24-24 10.7-24 24 10.7 24 24 24zm-32 40c0-13.3-10.7-24-24-24s-24 10.7-24 24 10.7 24 24 24 24-10.7 24-24zm136-40c13.3 0 24-10.7 24-24s-10.7-24-24-24-24 10.7-24 24 10.7 24 24 24zm-24 40c0-13.3-10.7-24-24-24s-24 10.7-24 24 10.7 24 24 24 24-10.7 24-24zm88 24c13.3 0 24-10.7 24-24s-10.7-24-24-24-24 10.7-24 24 10.7 24 24 24zM224 64l0-32-64 0 0 160-96 0 0 64 256 0 0-64-96 0 0-128z"],
    "square-phone-hangup": [448, 512, ["phone-square-down"], "e27a", "M448 32l-448 0 0 448 448 0 0-448zM88.2 317.2l-22.6-67.9 5.7-5.7c84.4-84.3 221.1-84.3 305.5 0l5.7 5.7-22.6 67.9-79.5-11 .3-56.8c-36.6-13.2-76.6-13.2-113.1 0l.3 56.8-79.5 11z"],
    "money-bill-wheat": [512, 512, [], "e52a", "M176-16c44.2 0 80 35.8 80 80l0 16-16 0c-44.2 0-80-35.8-80-80l0-16 16 0zM56 0l72 0 0 48-96 0 0-48 24 0zM24 72l136 0 0 48-160 0 0-48 24 0zm8 72l96 0 0 48-96 0 0-48zM272-16l16 0c44.2 0 80 35.8 80 80l0 16-16 0c-44.2 0-80-35.8-80-80l0-16zm128 0c44.2 0 80 35.8 80 80l0 16-16 0c-44.2 0-80-35.8-80-80l0-16 16 0zm80 128l0 16c0 44.2-35.8 80-80 80l-16 0 0-16c0-44.2 35.8-80 80-80l16 0zm-128 0l16 0 0 16c0 44.2-35.8 80-80 80l-16 0 0-16c0-44.2 35.8-80 80-80zm-96 0l0 16c0 44.2-35.8 80-80 80l-16 0 0-16c0-44.2 35.8-80 80-80l16 0zM0 512l0-256 512 0 0 256-512 0zm48-96l0 48 48 0c0-26.5-21.5-48-48-48zM96 304l-48 0 0 48c26.5 0 48-21.5 48-48zM464 416c-26.5 0-48 21.5-48 48l48 0 0-48zM416 304c0 26.5 21.5 48 48 48l0-48-48 0zm-96 80a64 64 0 1 0 -128 0 64 64 0 1 0 128 0z"],
    "circle-florin": [512, 512, [], "e6e4", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm16.4-355.3c9.5-22.3 31.4-36.7 55.7-36.7l47.9 0 0 48-47.9 0c-5 0-9.6 3-11.6 7.6l-20.7 48.4 56.2 0 0 48-76.7 0-35.7 83.3C230 377.6 208.1 392 183.9 392l-47.9 0 0-48 47.9 0c5 0 9.6-3 11.6-7.6l27.6-64.4-63 0 0-48 83.6 0 28.8-67.3z"],
    "dungeon": [512, 512, [], "f6d9", "M379.8 182.3l95-59.4c-21.5-35.2-51.2-64.8-86.5-86.2l-62.2 93.4c22.2 12.4 40.7 30.4 53.7 52.2zM279.2 113.9l65.4-98.1C317 5.6 287.2 0 256 0s-61 5.6-88.6 15.8l65.4 98.1c7.6-1.2 15.3-1.9 23.2-1.9s15.7 .6 23.2 1.9zM123.7 36.8c-35.3 21.3-65 51-86.5 86.2l95 59.4c13-21.8 31.5-39.8 53.7-52.2L123.7 36.8zm-9 191.2L16.1 166.4C5.7 194.3 0 224.5 0 256l0 48 112 0 0-48c0-9.6 .9-18.9 2.7-28zM400 256l0 48 112 0 0-48c0-31.5-5.7-61.7-16.1-89.6L397.3 228c1.8 9.1 2.7 18.4 2.7 28zM0 352l0 160 112 0 0-160-112 0zm400 0l0 160 112 0 0-160-112 0zM280 184l0-24-48 0 0 352 48 0 0-328zm-80 48l0-24-48 0 0 304 48 0 0-280zm160 0l0-24-48 0 0 304 48 0 0-280z"],
    "comet": [512, 512, [], "e003", "M512 0L299.4 75.9 304 16 101.3 133.4C38.6 169.7 0 236.6 0 309 0 421.1 90.9 512 203 512 275.4 512 342.3 473.4 378.6 410.7L496 208 436.1 212.6 512 0zM231.6 275.8l88.4 12.7-64 61.5 15.1 86.8-79.1-41-79.1 41 15.1-86.8-64-61.5 88.4-12.7 39.6-79 39.6 79z"],
    "face-holding-back-tears": [512, 512, [129401], "e482", "M0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm240 20.7c5.1-11.2 8-23.6 8-36.7 0-42.2-29.8-77.5-69.5-86 6.8-9.3 12-19.8 15.2-31.3 .3-1.1 2.6-9.2 7-24.4l-38.5-11c-4.3 15.2-6.7 23.3-7 24.4-6.6 23.1-26.4 40.1-50.2 43.1-6.3 .8-16.8 2.1-31.4 3.9l5 39.7 4.1-.5c-6.9 12.5-10.8 26.9-10.8 42.2 0 23.4 9.1 44.6 24 60.4l0 51.6 32 0 0-30c9.9 3.9 20.7 6 32 6 17.7 0 34.2-5.2 48-14.2l0 22.2 32 0 0-59.3zM352 328c11.3 0 22.1-2.1 32-6l0 30 32 0 0-51.6c14.9-15.8 24-37 24-60.4 0-15.3-3.9-29.7-10.8-42.2l4.1 .5 5-39.7c-14.6-1.8-25.1-3.1-31.4-3.9-23.9-3-43.6-19.9-50.2-43.1-.3-1.1-2.6-9.2-7-24.4l-38.5 11 5.5 19.2 1.5 5.2c3.3 11.5 8.5 22 15.2 31.3-39.7 8.5-69.5 43.8-69.5 86 0 48.6 39.4 88 88 88zm-96 74c-23.9 0-45.2-10.7-59.6-27.6l-36.6 31C182.9 432.6 217.4 450 256 450s73.1-17.4 96.2-44.6l-36.6-31C301.2 391.3 279.9 402 256 402zM128 232c17.7 0 32-14.3 32-32 0-5.8-1.5-11.2-4.2-15.8 1.4-.1 2.8-.2 4.2-.2 30.9 0 56 25.1 56 56s-25.1 56-56 56-56-25.1-56-56c0-5.7 .8-11.2 2.4-16.4 5.7 5.2 13.3 8.4 21.6 8.4zm224-32c0-5.8-1.5-11.2-4.2-15.8 1.4-.1 2.8-.2 4.2-.2 30.9 0 56 25.1 56 56s-25.1 56-56 56-56-25.1-56-56c0-5.7 .8-11.2 2.4-16.4 5.7 5.2 13.3 8.4 21.6 8.4 17.7 0 32-14.3 32-32z"],
    "card-heart": [384, 512, [], "e3eb", "M384 0L0 0 0 512 384 512 384 0zM185.6 183.5l6.4 8.5 6.4-8.5c11.1-14.8 28.5-23.5 46.9-23.5 32.4 0 58.7 26.3 58.7 58.7l0 5.3c0 64-112 128-112 128S80 288 80 224l0-5.3c0-32.4 26.3-58.7 58.7-58.7 18.5 0 35.9 8.7 46.9 23.5z"],
    "car-mirrors": [576, 512, [], "e343", "M152 32l-22.7 0-7.5 21.4-48.5 138.6-73.3 0 0 64 32 0 0 224 96 0 0-64 320 0 0 64 96 0 0-224 32 0 0-64-73.3 0-48.5-138.6-7.5-21.4-294.7 0zM434.9 192l-293.8 0 33.6-96 226.6 0 33.6 96zM96 304a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm352-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "suitcase-medical": [512, 512, ["medkit"], "f0fa", "M144 0l224 0 0 480-224 0 0-480zM416 480l0-384 96 0 0 384-96 0zM96 192l0 288-96 0 0-384 96 0 0 96zM320 48l-128 0 0 48 128 0 0-48zM228 208l0 52-52 0 0 56 52 0 0 52 56 0 0-52 52 0 0-56-52 0 0-52-56 0z"],
    "block-quote": [448, 512, [], "e0b5", "M448 64l-448 0 0 64 448 0 0-64zm0 160l-320 0 0 64 320 0 0-64zM128 384l0 64 320 0 0-64-320 0zM64 224l-64 0 0 224 64 0 0-224z"],
    "hands-holding-heart": [640, 512, ["hands-heart"], "f4c3", "M311.6 23C297.5 3.5 274.9-8 250.9-8 209.5-8 176 25.5 176 66.9l0 2.4C176 154.7 320 248 320 248S464 154.7 464 69.3l0-2.4c0-41.4-33.5-74.9-74.9-74.9-24 0-46.6 11.5-60.7 31L320 34.7 311.6 23zM80 64l-80 0 0 301.3 9.4 9.4 128 128 9.4 9.4 141.3 0 0-173.3-9.4-9.4C125.1 175.9 201.5 252.2 160 210.7L114.7 256c48.8 48.8 65.1 65.1 91 91L164.1 374.8 80 290.7 80 64zm480 0l0 226.7-84.1 84.1-41.7-27.8c102.9-102.9 58.7-58.7 91-91L480 210.7c-44.2 44.2-69.7 69.7-118.6 118.6l-9.4 9.4 0 173.3 141.3 0 9.4-9.4 128-128 9.4-9.4 0-301.3-80 0z"],
    "arrow-up-small-big": [512, 512, ["sort-size-up-alt"], "f88f", "M150.6 41.4L128 18.7 25.4 121.4 2.7 144 48 189.3c14.6-14.6 30.6-30.6 48-48l0 338.7 64 0 0-338.7 48 48 45.3-45.3c-5.5-5.5-39.7-39.7-102.6-102.6zM288 32l0 160 160 0 0-160-160 0zm0 224l0 224 224 0 0-224-224 0z"],
    "sliders-simple": [512, 512, [], "e253", "M64 384l64 0 0-64-64 0 0 64zm128 0l0 64-192 0 0-192 192 0 0 64 320 0 0 64-320 0zM32 192l-32 0 0-64 320 0 0-64 192 0 0 192-192 0 0-64-288 0zm416 0l0-64-64 0 0 64 64 0z"],
    "person-cane": [448, 512, [], "e53c", "M232 80a56 56 0 1 0 0-112 56 56 0 1 0 0 112zm-59.1 32l-16.3 0-9.6 13.2-92.9 128-18.8 25.9 51.8 37.6c9.3-12.8 28.3-39 56.9-78.4l0 305.7 64 0 0-208 32 0 0 208 64 0 0-305.7c28.6 39.4 47.6 65.6 56.9 78.4l51.8-37.6c-.2-.2-37.4-51.6-111.7-153.9l-9.6-13.2-118.5 0zM392 384c4.4 0 8 3.6 8 8l0 152 48 0 0-152c0-30.9-25.1-56-56-56s-56 25.1-56 56l0 24 48 0 0-24c0-4.4 3.6-8 8-8z"],
    "message-music": [512, 512, ["comment-alt-music"], "f8af", "M0 32l0 416 128 0 0 96 160-96 224 0 0-416-512 0zm336 96l0 64-48 0 0 104c0 30.9-28.7 56-64 56s-64-25.1-64-56 28.7-56 64-56c5.5 0 10.9 .6 16 1.8l0-113.8 96 0z"],
    "gauge-low": [512, 512, ["tachometer-alt-slow"], "f627", "M0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zM288 96a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM256 416c35.3 0 64-28.7 64-64s-28.7-64-64-64c-1.7 0-3.4 .1-5.1 .2l-69.5-138.9-42.9 21.5 69.5 138.9c-10 11.3-16 26.1-16 42.3 0 35.3 28.7 64 64 64zM128 256a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm288 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM400 144a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "hexagon-equals": [576, 512, [], "e6b2", "M13.5 256.1l6.8-11.9 123.7-216.1 6.9-12.1 275.1 0 6.9 12.1 123.7 216.1 6.8 11.9-6.8 11.9-123.7 216.1-6.9 12.1-275.1 0-6.9-12.1-123.7-216.1-6.8-11.9zm179-80.1l0 48 192 0 0-48-192 0zm0 112l0 48 192 0 0-48-192 0z"],
    "capsule": [448, 512, [], "e75a", "M189.3 189.3L290.7 290.7 363 218.5c13.5-13.5 21-31.7 21-50.7 0-39.6-32.1-71.8-71.8-71.8-19 0-37.3 7.6-50.7 21l-72.2 72.2zm219 74.5L231.8 440.2c-25.5 25.5-60 39.8-96 39.8-75 0-135.8-60.8-135.8-135.8 0-36 14.3-70.5 39.8-96L216.2 71.8c25.5-25.5 60-39.8 96-39.8 75 0 135.8 60.8 135.8 135.8 0 36-14.3 70.5-39.8 96z"],
    "user-sith": [448, 512, [], "e7b8", "M248-16l-48 0 0 16-8 0C139 0 96 43 96 96l0 64-64 128 80 0 0 16 224 0 0-16 80 0-64-128 0-64c0-53-43-96-96-96l-8 0 0-16zM176 112l32 0 0 48-64 0 0-16c0-17.7 14.3-32 32-32zm128 32l0 16-64 0 0-48 32 0c17.7 0 32 14.3 32 32zm-64 48l0 12 48 36 0 16-128 0 0-16 48-36 0-12c0-8.8 7.2-16 16-16s16 7.2 16 16zM0 512l104 0 0-64 48 0 0 64 48 0 0-64 48 0 0 64 48 0 0-64 48 0 0 64 104 0-48-160-352 0-48 160z"],
    "gauge": [512, 512, ["dashboard", "gauge-med", "tachometer-alt-average"], "f624", "M0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm320 96c0-26.9-16.5-49.9-40-59.3l0-196.7-48 0 0 196.7c-23.5 9.5-40 32.5-40 59.3 0 35.3 28.7 64 64 64s64-28.7 64-64zM144 176a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm-16 80a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm288 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM400 144a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "envelope-open-text": [576, 512, [], "f658", "M288 48L416 144 522.7 144 288-32 32 160 32 480 272 480 272 308.6 102.2 187.3 288 48zm32 144l0 320 256 0 0-320-256 0zm56 64l144 0 0 48-144 0 0-48zm0 96l104 0 0 48-104 0 0-48z"],
    "toolbox": [512, 512, [129520], "f552", "M152 0l-24 0 0 96-48 0-80 80 0 96 136 0 0-40 48 0 0 40 144 0 0-40 48 0 0 40 136 0 0-96-80-80-48 0 0-96-232 0zM336 96l-160 0 0-48 160 0 0 48zM0 480l512 0 0-160-136 0 0 40-48 0 0-40-144 0 0 40-48 0 0-40-136 0 0 160z"],
    "wheat-slash": [576, 512, [], "e339", "M578.2 512.1L544.3 546-1.6 .1 32.3-33.8 578.2 512.1zM145.5 282.7l6.1 6.7c19.7 23.8 26.3 55 19.2 83.9 31.7-7.7 66.2 1 90.6 25.3L318.7 456 300 474.7c-37.5 37.5-98.3 37.5-135.8 0L133.8 444.3 49.1 529c-9.4 9.4-24.5 9.4-33.9 0-9.4-9.4-9.4-24.6 0-33.9l84.7-84.7-30.5-30.5c-37.5-37.5-37.5-98.3 0-135.8l18.7-18.8 57.4 57.4zm208-208l6.1 6.7c19.7 23.7 26.3 55 19.3 83.9 31.7-7.7 66.2 1 90.6 25.3L526.7 248 508 266.7c-37.5 37.5-98.3 37.5-135.8 0l-94.9-94.9c-37.5-37.5-37.5-98.3 0-135.7l18.8-18.8 57.4 57.4zM560.1 35l-.1 4.8c-2.4 47.6-40.5 85.7-88.1 88.1l-4.8 .1-51 0 0-51c0-51.4 41.6-93 93-93l51 0 0 51z"],
    "power-off": [512, 512, [9211], "f011", "M288 0l0-32-64 0 0 320 64 0 0-288zM64 256c0-75 43-140.1 105.9-171.7L141.2 27.1C57.5 69.2 0 155.8 0 256 0 397.4 114.6 512 256 512S512 397.4 512 256c0-100.2-57.5-186.8-141.2-228.9L342.1 84.3C405 115.9 448 181 448 256 448 362 362 448 256 448S64 362 64 256z"],
    "signal": [512, 512, [128246, "signal-5", "signal-perfect"], "f012", "M488 56l0-24-48 0 0 448 48 0 0-424zM384 128l-48 0 0 352 48 0 0-352zM280 248l0-24-48 0 0 256 48 0 0-232zM176 320l-48 0 0 160 48 0 0-160zM72 384l-48 0 0 96 48 0 0-96z"],
    "arrows-spin": [512, 512, [], "e4bb", "M192 0l0 176-63.8-63.8-8 8C78.7 161.8 60.1 217.6 64.7 272L.5 272C-3.9 201.3 20.9 129.1 75 75l8-8-67-67 176 0zM391.8 391.8c41.5-41.5 60.1-97.4 55.6-151.8l64.2 0c4.4 70.7-20.4 142.9-74.5 197l-8 8 67 67-176 0 0-176 63.8 63.8 8-8zM512 192l-176 0 63.8-63.8-8-8C350.2 78.7 294.4 60.1 240 64.7L240 .5C310.7-3.9 382.9 20.9 437 75l8 8 67-67 0 176zM120.2 391.8c41.5 41.5 97.4 60.1 151.8 55.6l0 64.2c-70.7 4.4-142.9-20.4-197-74.5l-8-8-67 67 0-176 176 0-63.8 63.8 8 8z"],
    "joint": [576, 512, [], "f595", "M336 0l48 0 0 43c0 40.3 16 79 44.5 107.5l21 21C469 191 480 217.4 480 245l0 43-48 0 0-43c0-14.9-5.9-29.1-16.4-39.6l-21-21C357.1 146.9 336 96 336 43l0-43zM576 288l-48 0 0-43c0-40.3-16-79-44.5-107.5l-21-21C443 97 432 70.6 432 43l0-43 48 0 0 43c0 14.9 5.9 29.1 16.4 39.6l21 21C554.9 141.1 576 192 576 245l0 43zM244.4 320l57.2 0 95.7 155.5-5.2 .8c-16.1 2.5-32.4 3.7-48.7 3.7l-47 0-96.5-156.9c14.7-2.1 29.6-3.1 44.5-3.1zM576 448l-127.2 19.6-90.6-147.2c11.4 .5 22.7 1.7 34 3.4L576 352 576 448zM149.9 333.4L240.1 480c-22.8-.3-45.4-3-67.6-8.2L0 432 0 368 149.9 333.4z"],
    "down-from-line": [384, 512, ["arrow-alt-from-top"], "f349", "M384 64L0 64 0 0 384 0 384 64zM192 523l-17.4-18.5C67.6 391.2 9.5 329.7 .3 320l127.7 0 0-160 0 0 0-32 128 0 0 192 127.7 0c-9.2 9.7-67.3 71.2-174.2 184.5L192 523z"],
    "tablet-rugged": [448, 512, [], "f48f", "M352 64l0 384-256 0 0-384 256 0zM96 0l-64 0 0 48-32 16 0 96 32 16 0 16-32 16 0 96 32 16 0 16-32 16 0 96 32 16 0 48 384 0 0-48 32-16 0-96-32-16 0-16 32-16 0-96-32-16 0-16 32-16 0-96-32-16 0-48-320 0z"],
    "braille": [384, 512, [], "f2a1", "M80 144a80 80 0 1 0 0-160 80 80 0 1 0 0 160zm0 192a80 80 0 1 0 0-160 80 80 0 1 0 0 160zm0 136c-13.3 0-24-10.7-24-24s10.7-24 24-24 24 10.7 24 24-10.7 24-24 24zm0 56c44.2 0 80-35.8 80-80s-35.8-80-80-80-80 35.8-80 80 35.8 80 80 80zm248-80c0 13.3-10.7 24-24 24s-24-10.7-24-24 10.7-24 24-24 24 10.7 24 24zm56 0c0-44.2-35.8-80-80-80s-80 35.8-80 80 35.8 80 80 80 80-35.8 80-80zM304 232a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm0 104a80 80 0 1 0 0-160 80 80 0 1 0 0 160zm0-192a80 80 0 1 0 0-160 80 80 0 1 0 0 160z"],
    "basket-shopping": [576, 512, ["shopping-basket"], "f291", "M288-10.9l17.4 18.4 144 152 .5 .5 110.1 0 0 64-23.1 0-56.9 256-384 0-56.9-256-23.1 0 0-64 110.1 0 .5-.5 144-152 17.4-18.4zm0 69.8L192.2 160 383.8 160 288 58.9zM208 264l0-24-48 0 0 160 48 0 0-136zm104-24l-48 0 0 160 48 0 0-160zm104 24l0-24-48 0 0 160 48 0 0-136z"],
    "party-bell": [512, 512, [], "e31a", "M65.6 382.4c-87.5-87.5-87.5-229.3 0-316.8s229.3-87.5 316.8 0L65.6 382.4zM480 32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM352 448a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM96 480a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM376 150.1c12.8 12.8 21.2 21.2 25.2 25.2 16.7 16.7 38.6 27.2 62.1 29.8l27.4 3-5.3 47.7-27.4-3c-34.3-3.8-66.3-19.2-90.7-43.6-4-4-12.5-12.5-25.2-25.2L376 150.1zM201 359l8.3 8.2c24.4 24.4 39.8 56.4 43.6 90.7l3 27.4-47.7 5.3-3-27.4c-2.6-23.5-13.1-45.4-29.8-62.1-4-4-12.5-12.5-25.2-25.2l33.9-33.9 17 17zM469.7 503.5l-8.5-10c-12.5-14.8-19.1-33.7-18.6-53 .5-16.6-12.4-30.6-29-31.6l-30-1.8c-42.5-2.5-75.3-38.3-74.2-80.8 .2-7.6-2.4-15-7.3-20.7-4.5-5.3-12.5-14.8-24-28.3l36.6-31c11.5 13.6 19.5 23 24 28.3 12.5 14.8 19.1 33.7 18.6 53-.5 16.6 12.4 30.6 29 31.6l30 1.8c42.5 2.5 75.3 38.3 74.2 80.8-.2 7.6 2.4 15 7.3 20.7l8.5 10-36.6 31z"],
    "bra": [576, 512, [], "e6cf", "M143.5 52.7l4.7-23.5-47.1-9.4-4.7 23.5-36.2 180.8c-27.3 26.2-44.3 63.1-44.3 103.9 0 79.5 64.5 144 144 144 49.9 0 93.9-25.4 119.8-64l16.5 0c25.8 38.6 69.8 64 119.8 64 79.5 0 144-64.5 144-144 0-40.8-17-77.7-44.3-103.9l-36.2-180.8-4.7-23.5-47.1 9.4 4.7 23.5 37.3 186.6-101.8 40.7-45.7 64-68.6 0-45.7-64-101.8-40.7 37.3-186.6z"],
    "car-wash": [448, 512, [], "f5e6", "M224 96c-26.5 0-48-21.5-48-48 0-32 48-80 48-80s48 48 48 80-21.5 48-48 48zM89.8 144l268.4 0 7.8 20.8 46.2 123.2 35.8 0 0 224-80 0 0-64-288 0 0 64-80 0 0-224 35.8 0 54-144zm224 64l-179.6 0-30 80 239.6 0-30-80zM96 400a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm288-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM112 48c0 32-21.5 48-48 48S16 74.5 16 48c0-32 48-80 48-80s48 48 48 80zM384 96c-26.5 0-48-21.5-48-48 0-32 48-80 48-80s48 48 48 80-21.5 48-48 48z"],
    "face-sunglasses": [576, 512, [], "e398", "M288.3 512c141.4 0 256-114.6 256-256 0-12.9-1-25.7-2.8-38.1 12.6-56.5 22.8-102.5 30.6-137.9l-97.9 0C427.6 30.7 361.6 0 288.3 0S149.1 30.7 102.4 80L4.5 80c7.9 35.4 18.1 81.4 30.6 137.9-1.9 12.4-2.8 25.1-2.8 38.1 0 141.4 114.6 256 256 256zM511.7 130.8l-31.4 141.2-144 0-11.4-80-73.1 0-11.4 80-144 0-31.4-141.2 0 0-.6-2.8 192 0 0 16 64 0 0-16 192 0-.6 2.8zM288.3 384c38.2 0 72-19.1 92.2-48.5l39.5 27.3C391.3 404.6 343 432 288.3 432s-102.9-27.4-131.8-69.2l39.5-27.3c20.2 29.3 54 48.5 92.2 48.5z"],
    "bridge": [512, 512, [], "e4c8", "M32 32l-32 0 0 64 40 0 0 64-40 0 0 112c37.6 9.4 64 43.2 64 82l0 126 96 0 0-96c0-53 43-96 96-96s96 43 96 96l0 96 96 0 0-126c0-38.8 26.4-72.6 64-82l0-112-40 0 0-64 40 0 0-64-480 0zM424 96l0 64-80 0 0-64 80 0zM296 96l0 64-80 0 0-64 80 0zM88 96l80 0 0 64-80 0 0-64z"],
    "arrows-from-line": [384, 512, [], "e0a4", "M192-32l-120 128 88 0 0 80 64 0 0-80 88 0-120-128zm0 576l120-128-88 0 0-80-64 0 0 80-88 0 120 128zM32 224l-32 0 0 64 384 0 0-64-352 0z"],
    "up-long-to-line": [384, 512, [], "e6c6", "M384 256l-192-192-192 192 128 0 0 320 128 0 0-320 128 0zM320-64l-288 0 0 64 320 0 0-64-32 0z"],
    "up-to-line": [384, 512, ["arrow-alt-to-top"], "f34d", "M32 0L384 0 384 64 0 64 0 0 32 0zM0 320l192-202.9 192 202.9-128 0 0 160 0 0 0 32-128 0 0-192-128 0z"],
    "plane-arrival": [576, 512, [128748], "f5af", "M386.6 193.1l-128.3-201.3-78.8-13.9 27.2 183.5-105-18.5-39.3-71.9-47.3-8.3 1 178.9 66.1 11.7 0 0 417.6 73.6c30.5 5.4 59.5-15 64.9-45.4s-15-59.5-45.4-64.9L386.6 193.1zM224 384a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm131.2-15.3a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM32 448l-32 0 0 64 576 0 0-64-544 0z"],
    "pot-food": [640, 512, [127858], "e43f", "M112 24l0-24-48 0 0 24c0 45.1 21.2 69 37.7 87.5l.4 .4C117.5 129.3 128 141.5 128 168l0 24 48 0 0-24c0-45.1-21.2-69-37.7-87.5l-.4-.4C122.5 62.7 112 50.5 112 24zm112 0l0-24-48 0 0 24c0 45.1 21.2 69 37.7 87.5l.4 .4C229.5 129.3 240 141.5 240 168l0 24 48 0 0-24c0-45.1-21.2-69-37.7-87.5l-.4-.4C234.5 62.7 224 50.5 224 24zm208 88c-50.7 0-93.6 33.7-107.4 80l214.7 0c-13.8-46.3-56.6-80-107.4-80zM576 224l-512 0 1.9 32-49.9 0 0 64 56.4 0C87.1 387.5 132.1 443.2 192 472.9l0 39.1 256 0 0-39.1c59.9-29.7 104.9-85.4 119.6-152.9l56.4 0 0-64-49.9 0 1.9-32z"],
    "cash-register": [512, 512, [], "f788", "M320 0l-288 0 0 128 112 0 0 32-112 0-32 211.2 0 140.8 512 0 0-140.8-32-211.2-272 0 0-32 112 0 0-128zM96 48l176 0 0 32-192 0 0-32 16 0zM64 416l384 0 0 32-384 0 0-32zm72-200l0 48-48 0 0-48 48 0zm48 48l0-48 48 0 0 48-48 0zm0 32l0 48-48 0 0-48 48 0zm96-80l48 0 0 48-48 0 0-48zm-48 80l48 0 0 48-48 0 0-48zm144-80l48 0 0 48-48 0 0-48zm0 80l0 48-48 0 0-48 48 0z"],
    "ring": [512, 512, [], "f70b", "M64 184.3l0 51C106.8 212.1 170 192 256 192s149.2 20.1 192 43.3l0-51c-23.1-20-82.6-56.3-192-56.3S87.1 164.3 64 184.3zM512 192l0 160c-21.3 32-102.4 96-256 96S21.3 384 0 352L0 160c21.3-32 102.4-96 256-96s234.7 64 256 96l0 32zM400.1 265.6C365.8 251.5 318.4 240 256 240s-109.8 11.5-144.1 25.6C150 278.8 197.8 288 256 288s106-9.2 144.1-22.4z"],
    "message-xmark": [512, 512, ["comment-alt-times", "message-times"], "f4ab", "M0 32l0 416 128 0 0 96 160-96 224 0 0-416-512 0zM340.9 189.1c-8.5 8.5-25.5 25.5-50.9 50.9 25.5 25.5 42.4 42.4 50.9 50.9l-33.9 33.9c-8.5-8.5-25.5-25.5-50.9-50.9-25.5 25.5-42.4 42.4-50.9 50.9l-33.9-33.9c8.5-8.5 25.5-25.5 50.9-50.9-25.5-25.5-42.4-42.4-50.9-50.9l33.9-33.9 50.9 50.9c25.5-25.5 42.4-42.4 50.9-50.9l33.9 33.9z"],
    "share-nodes": [512, 512, ["share-alt"], "f1e0", "M384 192c53 0 96-43 96-96s-43-96-96-96-96 43-96 96c0 5.4 .5 10.8 1.3 16L159.6 184.1c-16.9-15-39.2-24.1-63.6-24.1-53 0-96 43-96 96s43 96 96 96c24.4 0 46.6-9.1 63.6-24.1L289.3 400c-.9 5.2-1.3 10.5-1.3 16 0 53 43 96 96 96s96-43 96-96-43-96-96-96c-24.4 0-46.6 9.1-63.6 24.1L190.7 272c.9-5.2 1.3-10.5 1.3-16s-.5-10.8-1.3-16l129.7-72.1c16.9 15 39.2 24.1 63.6 24.1z"],
    "octagon-divide": [512, 512, [], "e203", "M0 160L0 352 160 512 352 512 512 352 512 160 352 0 160 0 0 160zm288-32l0 64-64 0 0-64 64 0zM168 232l200 0 0 48-224 0 0-48 24 0zm56 88l64 0 0 64-64 0 0-64z"],
    "folder-arrow-up": [512, 512, ["folder-upload"], "e054", "M512 80l0 368-512 0 0-416 224 0 64 48 224 0zM273 167l-17-17-105.9 105.9 33.9 33.9c9-9 25-25 48-48l0 126.1 48 0 0-126.1c23 23 39 39 48 48L361.9 256c-2.1-2.1-31.8-31.8-89-89z"],
    "arrows-minimize": [512, 512, ["compress-arrows"], "e0a5", "M64.3 18.8c6.6 6.6 38.6 38.6 96 96l0-66.7 64 0 0 176-176 0 0-64 66.7 0C57.6 102.6 25.6 70.6 19 64L64.3 18.8zM493.5 64c-6.6 6.6-38.6 38.6-96 96l66.7 0 0 64-176 0 0-176 64 0 0 66.7c57.4-57.4 89.4-89.4 96-96L493.5 64zM48.3 352l0-64 176 0 0 176-64 0 0-66.7c-57.4 57.4-89.4 89.4-96 96L19 448c6.6-6.6 38.6-38.6 96-96l-66.7 0zm240-64l176 0 0 64-66.7 0c57.4 57.4 89.4 89.4 96 96l-45.3 45.3-96-96 0 66.7-64 0 0-176z"],
    "person-circle-exclamation": [640, 512, [], "e53f", "M168 24a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm-11.4 88l134.8 0 9.6 13.2 85.2 117.3c-17.8 12.4-33.4 27.8-46.1 45.5l-36.1-49.7 0 305.7-64 0 0-208-32 0 0 208-64 0 0-305.7c-28.6 39.4-47.6 65.6-56.9 78.4l-51.8-37.6 18.8-25.9 92.9-128 9.6-13.2zM496 256a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm16 224l0-32-32 0 0 32 32 0zm0-176l-32 0 0 112 32 0 0-112z"],
    "binoculars": [512, 512, [], "f1e5", "M192 32l0 64-96 0 0-64 96 0zm0 96l0 352-192 0 0-144 48-80 16-128 128 0zm128 0l128 0 16 128 48 80 0 144-192 0 0-352zm0-96l96 0 0 64-96 0 0-64zm-32 96l0 160-64 0 0-160 64 0z"],
    "grid-round-5": [448, 512, [], "e5de", "M28 32a28 28 0 1 0 0 56 28 28 0 1 0 0-56zM0 158a28 28 0 1 0 56 0 28 28 0 1 0 -56 0zm28 70a28 28 0 1 0 0 56 28 28 0 1 0 0-56zM0 354a28 28 0 1 0 56 0 28 28 0 1 0 -56 0zm0 98c0 15.5 12.5 28 28 28s28-12.5 28-28-12.5-28-28-28-28 12.5-28 28zm98 0c0 15.5 12.5 28 28 28s28-12.5 28-28-12.5-28-28-28-28 12.5-28 28zm126-28c-15.5 0-28 12.5-28 28s12.5 28 28 28 28-12.5 28-28-12.5-28-28-28zm70 28c0 15.5 12.5 28 28 28s28-12.5 28-28-12.5-28-28-28-28 12.5-28 28zm126-28c-15.5 0-28 12.5-28 28s12.5 28 28 28 28-12.5 28-28-12.5-28-28-28zM126 326a28 28 0 1 0 0 56 28 28 0 1 0 0-56zm70 28a28 28 0 1 0 56 0 28 28 0 1 0 -56 0zm126-28a28 28 0 1 0 0 56 28 28 0 1 0 0-56zm70 28a28 28 0 1 0 56 0 28 28 0 1 0 -56 0zM98 256a28 28 0 1 0 56 0 28 28 0 1 0 -56 0zm126-28a28 28 0 1 0 0 56 28 28 0 1 0 0-56zm70 28a28 28 0 1 0 56 0 28 28 0 1 0 -56 0zm126-28a28 28 0 1 0 0 56 28 28 0 1 0 0-56zM126 130a28 28 0 1 0 0 56 28 28 0 1 0 0-56zm70 28a28 28 0 1 0 56 0 28 28 0 1 0 -56 0zm126-28a28 28 0 1 0 0 56 28 28 0 1 0 0-56zm70 28a28 28 0 1 0 56 0 28 28 0 1 0 -56 0zM98 60a28 28 0 1 0 56 0 28 28 0 1 0 -56 0zM224 32a28 28 0 1 0 0 56 28 28 0 1 0 0-56zm70 28a28 28 0 1 0 56 0 28 28 0 1 0 -56 0zM420 32a28 28 0 1 0 0 56 28 28 0 1 0 0-56z"],
    "kip-sign": [384, 512, [], "e1c4", "M128 322.9l0 157.1-64 0 0-200-56 0 0-48 56 0 0-200 64 0 0 157.1 195.9-158 40.2 49.8-187.4 151.1 199.3 0 0 48-199.3 0 187.4 151.1-40.2 49.8-195.9-158z"],
    "hard-drive": [448, 512, [128436, "hdd"], "f0a0", "M448 32l-448 0 0 208 448 0 0-208zm0 256l-448 0 0 192 448 0 0-192zM224 384a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm128-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "ranking-star": [576, 512, [], "e561", "M319.8 62.3l-31.8-62.3-31.8 62.3-69 11 49.4 49.5-10.9 69.1 62.3-31.7 62.3 31.7-10.9-69.1 49.4-49.5-69-11zM368 256l-160 0 0 256 160 0 0-256zM160 320l-160 0 0 192 160 0 0-192zm256 64l0 128 160 0 0-128-160 0z"],
    "user-tie": [448, 512, [], "f508", "M224 8a120 120 0 1 0 0 240 120 120 0 1 0 0-240zm48 320l0-24-96 0 0 24 31.4 36.7-31.4 115.3-40-160-56 0-64 192 416 0-64-192-56 0-40 160-.6 0-31-115.1 31.6-36.9z"],
    "square-bitcoin": [448, 512, [], "e6f2", "M0 32l448 0 0 448-448 0 0-448zM244 176c15.5 0 28 12.5 28 28s-12.5 28-28 28l-60 0 0-56 60 0zm62.2 71.7c8.7-12.4 13.8-27.4 13.8-43.7 0-37.9-27.7-69.3-64-75.1l0-32.9-32 0 0 32-16 0 0-32-32 0 0 32-40 0 0 256 40 0 0 32 32 0 0-32 16 0 0 32 32 0 0-32 4 0c42 0 76-34 76-76 0-24.6-11.7-46.4-29.8-60.3zM184 280l76 0c15.5 0 28 12.5 28 28s-12.5 28-28 28l-76 0 0-56z"],
    "ellipsis": [448, 512, ["ellipsis-h"], "f141", "M112 200l0 112-112 0 0-112 112 0zm168 0l0 112-112 0 0-112 112 0zM448 312l-112 0 0-112 112 0 0 112z"],
    "arrow-turn-down-left": [576, 512, [], "e2e1", "M480.3 96l0-32 64 0 0 224-402.7 0c57.4 57.4 89.4 89.4 96 96l-45.3 45.3-22.6-22.6-128-128-22.6-22.6 22.6-22.6 128-128 22.6-22.6 45.3 45.3c-6.6 6.6-38.6 38.6-96 96l338.7 0 0-128z"],
    "octagon-check": [512, 512, [], "e426", "M512 160L512 352 352 512 160 512 0 352 0 160 160 0 352 0 512 160zm-171.5-9l-119.4 164.2-69.1-69.1-33.9 33.9 88.9 88.9 19.8 19.9 16.5-22.7 135.9-186.9 14.1-19.4-38.8-28.3-14.1 19.4z"],
    "store-24": [640, 512, [], "e79b", "M80 32l-64 176 80 32 72-32 56 32 64-32 64 32 56-32 72 32 80-32-64-176-416 0zM64 480l240 0 0-128-176 0 0-73.7c-7.3 3.3-17.7 7.9-31 13.8-13.3-5.3-24.3-9.7-33-13.2L64 480zm284-80l40 0c0-6.6 5.4-12 12-12s12 5.4 12 12l0 1c0 4.8-1.8 9.4-4.9 13l-54 60.8-5.1 5.7 0 35.6 104 0 0-40-46.6 0 31.5-35.5c9.7-10.9 15-25 15-39.6l0-1c0-28.7-23.3-52-52-52s-52 23.3-52 52zm128 32l0 20 64 0 0 60 40 0 0-160-40 0 0 60-24 0 0-60-40 0 0 80z"],
    "store-slash": [576, 512, [], "e071", "M49.3-16.9l-17-17-33.9 33.9 17 17 512 512 17 17 33.9-33.9-66.1-66.1 0-167.1c-8.7 3.5-19.7 7.9-33 13.2-13.3-5.9-23.7-10.5-31-13.8l0 73.7-30 0-139.3-139.3 9.3-4.7 64 32 56-32 72 32 80-32-64-176-398 0-48.9-48.9zm98.2 234.1l-98.8-98.8-32.6 89.6 80 32 51.4-22.8zM410.3 480l-128-128-154.2 0 0-73.7c-7.3 3.3-17.7 7.9-31 13.8-13.3-5.3-24.3-9.7-33-13.2l0 201.1 346.2 0z"],
    "percent": [512, 512, [62101, 62785, "percentage"], "25", "M470.9 86.6l22.6-22.6-45.3-45.3-22.6 22.6-384 384-22.6 22.6 45.3 45.3 22.6-22.6 384-384zM32.3 32l0 160 160 0 0-160-160 0zm288 288l0 160 160 0 0-160-160 0z"],
    "circle-n": [512, 512, [], "e118", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM160 144l35.4 0 7.2 8.8 101.4 124 0-132.8 48 0 0 224-35.4 0-7.2-8.8-101.4-124 0 132.8-48 0 0-224z"],
    "file-zipper": [384, 512, ["file-archive"], "f1c6", "M0 0L240 0 384 144 384 512 0 512 0 0zM208 58.5L208 176 325.5 176 208 58.5zM64 48l0 48 96 0 0-48-96 0zm0 96l0 48 96 0 0-48-96 0zm96 96l-96 0 0 80c0 26.5 21.5 48 48 48s48-21.5 48-48l0-80zm-48 64a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"],
    "trash-can-xmark": [448, 512, [], "e2ae", "M304-16l16 48 128 0 0 64-448 0 0-64 128 0 16-48 160 0zM32 144l384 0 0 368-384 0 0-368zM308.9 269.1l-33.9-33.9c-8.5 8.5-25.5 25.5-50.9 50.9-25.5-25.5-42.4-42.4-50.9-50.9l-33.9 33.9c8.5 8.5 25.5 25.5 50.9 50.9-25.5 25.5-42.4 42.4-50.9 50.9l33.9 33.9c8.5-8.5 25.5-25.5 50.9-50.9 25.5 25.5 42.4 42.4 50.9 50.9l33.9-33.9c-8.5-8.5-25.5-25.5-50.9-50.9 25.5-25.5 42.4-42.4 50.9-50.9z"],
    "display": [512, 512, [], "e163", "M448 96l0 256-384 0 0-256 384 0zM64 32l-64 0 0 384 208 0-16 48-96 0 0 48 320 0 0-48-96 0-16-48 208 0 0-384-448 0z"],
    "ellipsis-stroke": [512, 512, ["ellipsis-h-alt"], "f39b", "M64 240l32 0 0 32-32 0 0-32zM16 272l0 48 128 0 0-128-128 0 0 80zm224-32l32 0 0 32-32 0 0-32zm-48 32l0 48 128 0 0-128-128 0 0 80zm224 0l0-32 32 0 0 32-32 0zm-48 48l128 0 0-128-128 0 0 128z"],
    "air-conditioner": [576, 512, [], "f8f4", "M576 64l-576 0 0 256 576 0 0-256zM88 208l424 0 0 48-448 0 0-48 24 0zM208 472c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-24-48 0 0 24c0 39.8 32.2 72 72 72s72-32.2 72-72l0-104-48 0 0 104zM368 368l-48 0 0 104c0 39.8 32.2 72 72 72s72-32.2 72-72l0-24-48 0 0 24c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-104z"],
    "file-xls": [576, 512, [], "e64d", "M272 0l-240 0 0 512 176 0 0-176 208 0 0-192-144-144zm85.5 176L240 176 240 58.5 357.5 176zM292 400l0-20-40 0 0 20c0 14.4 4.3 28.4 12.2 40.4L280 464 264.2 487.6c-8 12-12.2 26-12.2 40.4l0 20 40 0 0-20c0-6.5 1.9-12.8 5.5-18.2l6.5-9.7 6.5 9.7c3.6 5.4 5.5 11.7 5.5 18.2l0 20 40 0 0-20c0-14.4-4.3-28.4-12.2-40.4L328 464 343.8 440.4c8-12 12.2-26 12.2-40.4l0-20-40 0 0 20c0 6.5-1.9 12.8-5.5 18.2l-6.5 9.7-6.5-9.7c-3.6-5.4-5.5-11.7-5.5-18.2zM400 548l52 0 0-40-32 0 0-128-40 0 0 168 20 0zm76-116c0 28.7 23.3 52 52 52 6.6 0 12 5.4 12 12s-5.4 12-12 12l-52 0 0 40 52 0c28.7 0 52-23.3 52-52s-23.3-52-52-52c-6.6 0-12-5.4-12-12s5.4-12 12-12l44 0 0-40-44 0c-28.7 0-52 23.3-52 52z"],
    "pinata": [512, 512, [], "e3c3", "M256 176l256 0 0 336-128 0 0-96-160 0 0 96-128 0 0-320-96-48 0-112 192 0 0-64 64 0 0 208zM419.1 323l-34 24.4c-20-18-31.9-28.7-35.6-32-3.1 2.2-17.9 12.9-44.4 32-20-18-31.9-28.7-35.6-32-3.1 2.2-17.9 12.9-44.4 32-20-18-31.9-28.7-35.6-32l-10.5 7.5-44.4 32-13 9.4 18.7 26c5.1-3.7 20.8-15 46.9-33.8l26 23.4 9.6 8.6 10.5-7.5 34-24.5 26 23.4 9.6 8.6 10.5-7.5 34-24.5 26 23.4 9.6 8.6 10.5-7.5 34-24.5 26 23.4 11.9 10.7 21.4-23.8-11.9-10.7-35.6-32-9.6-8.6-10.5 7.5zm0-96l-34 24.4c-20-18-31.9-28.7-35.6-32-3.1 2.2-17.9 12.9-44.4 32-20-18-31.9-28.7-35.6-32-3.1 2.2-17.9 12.9-44.4 32-20-18-31.9-28.7-35.6-32l-10.5 7.5-44.4 32-13 9.4 18.7 26c5.1-3.7 20.8-15 46.9-33.8l26 23.4 9.6 8.6 10.5-7.5 34-24.5 26 23.4 9.6 8.6 10.5-7.5 34-24.5 26 23.4 9.6 8.6 10.5-7.5 34-24.5 26 23.4 11.9 10.7 21.4-23.8-11.9-10.7-35.6-32-9.6-8.6-10.5 7.5zM168 80a24 24 0 1 0 0 48 24 24 0 1 0 0-48z"],
    "chart-fft": [512, 512, [], "e69e", "M64 64l0-32-64 0 0 448 512 0 0-64-448 0 0-352zm227.6 47.9L260.6 58.6c-8.2 17.8-43.2 94.3-105.1 229.4l-43.5 0 0 64 84.5 0 8.6-18.7 62.3-136c19.2 33 30.6 52.5 34.2 58.6l78.6 0c30.2 60.5 48.1 96.1 53.5 106.9l57.2-28.6c-3.9-7.8-24.7-49.4-62.3-124.6l-8.8-17.7-81.4 0-46.7-80.1z"],
    "circle-user-circle-exclamation": [640, 512, [], "e7a0", "M496 208c-77.5 0-144.3 45.9-174.6 112l-145.4 0-23.9 71.6c34.8 34.8 82.8 56.4 135.9 56.4 7.4 0 14.6-.4 21.7-1.2 5.5 21.9 14.8 42.4 27.1 60.6-15.8 3-32.1 4.6-48.8 4.6-141.4 0-256-114.6-256-256S146.6 0 288 0c126.8 0 232.1 92.2 252.4 213.2-14.3-3.4-29.1-5.2-44.4-5.2zM288 272a72 72 0 1 0 0-144 72 72 0 1 0 0 144zm208-16a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm16 224l0-32-32 0 0 32 32 0zm0-176l-32 0 0 112 32 0 0-112z"],
    "phone-intercom": [512, 512, [], "e434", "M112 32l-112 0 0 448 112 0 0-448zm400 0l-352 0 0 448 352 0 0-448zM248 344a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm64 24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm112-24a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM224 96l224 0 0 160-224 0 0-160z"],
    "turn-left-up": [384, 512, [], "e638", "M192 0l192 192-128 0 0 192 128 0 0 128-256 0 0-320-128 0 192-192z"],
    "scarf": [576, 512, [129507], "f7c1", "M152.4 0l-24 0 0 225.9 7 7 136 136 17 17 17-17 111-111-113-113-17-17 33.9-33.9 17 17 111 111 0-222.1-296 0zM39.5 375l-17 17 33.9 33.9 17-17 85.1-85.1-33.9-33.9-85.1 85.1zm48 48l-17 17 33.9 33.9 17-17 85.1-85.1-33.9-33.9-85.1 85.1zm48 48l-17 17 33.9 33.9 17-17 85.1-85.1c-11.3-11.3-22.6-22.6-33.9-33.9L135.5 471zm272 33.9l17 17 33.9-33.9-17-17-85.1-85.1c-11.3 11.3-22.6 22.6-33.9 33.9L407.5 505zm48-48l17 17 33.9-33.9-17-17-85.1-85.1-33.9 33.9 85.1 85.1zm48-48l17 17 33.9-33.9-17-17-85.1-85.1-33.9 33.9 85.1 85.1z"],
    "message-pen": [512, 512, ["comment-alt-edit", "message-edit"], "f4a4", "M0 32l0 416 128 0 0 96 160-96 224 0 0-416-512 0zM160 272l144-144 64 64-144 144-80 16 16-80z"],
    "icons": [576, 512, ["heart-music-camera-bolt"], "f86d", "M336 96.9l0 80.6c-5.1-1-10.5-1.5-16-1.5-35.3 0-64 21.5-64 48s28.7 48 64 48 64-21.5 64-48l0-110.1 112-33.6 0 49.2c-5.1-1-10.5-1.5-16-1.5-35.3 0-64 21.5-64 48s28.7 48 64 48 64-21.5 64-48l0-127.1c0-.6 0-1.2 0-1.8l0-55.3-30.9 9.3-160 48-17.1 5.2 0 40.9c0 .6 0 1.2 0 1.8zM128 272l-21.3 32-74.7 0 0 208 288 0 0-208-74.7 0-21.3-32-96 0zm48 88a48 48 0 1 1 0 96 48 48 0 1 1 0-96zM152.7 26.8C140 9.9 120.2 0 99 0 62 0 32 30 32 67l0 6.1c0 73.1 128 146.3 128 146.3S288 146.3 288 73.1l0-6.1c0-37-30-67-67-67-21.1 0-41 9.9-53.6 26.8l-7.3 9.8-7.3-9.8zM528 240l-184 160 81.6 0-57.6 128 184-160-81.6 0 57.6-128z"],
    "file-xml": [576, 512, [], "e654", "M272 0l-240 0 0 512 144 0 0-176 240 0 0-192-144-144zm85.5 176L240 176 240 58.5 357.5 176zM484 400l0-20c-33.7 0-24.7 0-37.6 0l-5.6 10.6-25.1 47.3-26.2-47.5-5.7-10.4c-17.7 0-17.9 0-35.8 0l0 168 40 0 0-77.4c5.8 10.5 15.2 27.6 28.3 51.5 12.7-24 22-41.4 27.7-52.2l0 78.1 40 0 0-148zm-224 0l0-20-40 0 0 20c0 14.4 4.3 28.4 12.2 40.4L248 464 232.2 487.6c-8 12-12.2 26-12.2 40.4l0 20 40 0 0-20c0-6.5 1.9-12.8 5.5-18.2l6.5-9.7 6.5 9.7c3.6 5.4 5.5 11.7 5.5 18.2l0 20 40 0 0-20c0-14.4-4.3-28.4-12.2-40.4L296 464 311.8 440.4c8-12 12.2-26 12.2-40.4l0-20-40 0 0 20c0 6.5-1.9 12.8-5.5 18.2l-6.5 9.7-6.5-9.7c-3.6-5.4-5.5-11.7-5.5-18.2zM508 548l72 0 0-40-32 0 0-128-40 0 0 168z"],
    "ruler-vertical": [256, 512, [], "f548", "M0-32l256 0 0 72-128 0 0 48 128 0 0 48-96 0 0 48 96 0 0 48-128 0 0 48 128 0 0 48-96 0 0 48 96 0 0 48-128 0 0 48 128 0 0 72-256 0 0-576z"],
    "map-location-dot": [640, 512, ["map-marked-alt"], "f5a0", "M576 64l0-51.8c-19.2 9.6-73.4 36.7-162.5 81.2l-179.4-59.8-12.6-4.2-11.9 5.9-128 64-17.7 8.8 0 391.6c19.2-9.6 73.4-36.7 162.5-81.2L387 472.1c-7.1-11.9-13.8-24.3-19.8-37.1-6.1-13.2-11.6-27.4-15.8-42.2l-95.4-31.8 0-252.5 128 42.7 0 83.3c31-35.8 77-58.4 128-58.4 22.6 0 44.2 4.4 64 12.5L576 64zM512 224c-66.3 0-120 52.8-120 117.9 0 94.3 120 212.1 120 212.1S632 436.1 632 341.9C632 276.8 578.3 224 512 224zM472 344a40 40 0 1 1 80 0 40 40 0 1 1 -80 0z"],
    "watermelon-slice": [512, 512, [], "e337", "M391.7 391.4c-96.8 96.8-253.5 96.6-350.4-.3L7.4 425c115.6 115.6 302.6 116 418.3 .3S540.9 122.6 425.3 7L391.4 41c96.9 96.9 97.1 253.6 .3 350.4zM63.6 368.7c84.4 84.4 221.1 84.4 305.5 0 84.2-84.2 84.4-220.7 .3-305.1L353.8 48 48.3 353.5 63.6 368.7zM320.3 137.4c16.2 16.2 36.1 36.1 38.6 38.6l-22.6 22.6c-16.2-16.2-36.1-36.1-38.6-38.6l22.6-22.6zm-80 80c16.2 16.2 36.1 36.1 38.6 38.6l-22.6 22.6c-16.2-16.2-36.1-36.1-38.6-38.6l22.6-22.6zm88 8c16.2 16.2 36.1 36.1 38.6 38.6l-22.6 22.6c-16.2-16.2-36.1-36.1-38.6-38.6l22.6-22.6zm-168 72c16.2 16.2 36.1 36.1 38.6 38.6l-22.6 22.6c-16.2-16.2-36.1-36.1-38.6-38.6l22.6-22.6zm88 8c16.2 16.2 36.1 36.1 38.6 38.6l-22.6 22.6c-16.2-16.2-36.1-36.1-38.6-38.6l22.6-22.6z"],
    "jack-o-lantern": [512, 512, [127875], "f30e", "M188.5 78.1L208 0 304 0 323.5 78.1c-1.2 .6-2.4 1.2-3.5 1.8-19.3-10-40.8-15.9-64-15.9s-44.7 5.9-64 15.9c-1.2-.6-2.3-1.2-3.5-1.8zM192 470.3C173.2 486.6 151.3 496 128 496 57.3 496 0 410 0 304S57.3 112 128 112c23.3 0 45.2 9.3 64 25.7 18.8-16.3 40.7-25.7 64-25.7s45.2 9.3 64 25.7c18.8-16.3 40.7-25.7 64-25.7 70.7 0 128 86 128 192S454.7 496 384 496c-23.3 0-45.2-9.4-64-25.7-18.8 16.3-40.7 25.7-64 25.7s-45.2-9.4-64-25.7zM176 192l-38.4 64 76.8 0-38.4-64zm160 0l-38.4 64 76.8 0-38.4-64zM96 293.1c6.4 38.8 30.1 72.5 64 94.8l0-19.9 48 0 0 41.6c15.2 4.2 31.3 6.4 48 6.4s32.8-2.3 48-6.5l0-41.5 48 0 0 19.9c33.9-22.3 57.6-56.1 64-94.9-39.3 14.1-85.8 23.1-136 25.3l0 33.7-48 0 0-33.7c-50.2-2.2-96.7-11.2-136-25.2z"],
    "candy": [576, 512, [127852], "e3e7", "M494.5 282.7L161.9 90.7c35-26.8 78.8-42.7 126.3-42.7 39.6 0 76.5 11 108 30.2l32.1-105.4 47 7 0 41.9 28.3-12.9 31.8 31.8-12.9 28.3 41.9 0 7 47-105.4 32.1c19.2 31.5 30.2 68.5 30.2 108 0 9-.6 18-1.7 26.7zm-12.3 48.4c-7.8 20.2-18.7 38.8-32 55.4L94.2 180.9c7.8-20.2 18.7-38.8 32.1-55.4l356 205.6zm-67.7 90.2c-35 26.8-78.8 42.7-126.3 42.7-39.6 0-76.5-11-108-30.2l-32.1 105.4-47-7 0-41.9-28.3 12.9-31.8-31.8 12.9-28.3-41.9 0-7-47 105.4-32.1c-19.2-31.5-30.2-68.5-30.2-108 0-9.1 .6-18 1.7-26.8l332.6 192z"],
    "heart-crack": [512, 512, [128148, "heart-broken"], "f7a9", "M288 320l-128-112 80-80-63.3-88.7C162.8 34.5 148.1 32 133.1 32 59.6 32 0 91.6 0 165.1 0 301.9 153.5 425.3 256 496 358.5 425.3 512 301.9 512 165.1 512 91.6 452.4 32 378.9 32 350.1 32 322.6 41.3 300 57.9l20 70.1-96 80 64 112z"],
    "cow": [640, 512, [128004], "f6c8", "M480 64L144 64C77.7 64 24 117.7 24 184l0 54C9.4 249.8 0 267.8 0 288l0 32 8 0c35.3 0 64-28.7 64-64l0-72c0-21.3 9.3-40.5 24-53.7l0 317.7 96 0 0-120.2c9.9 6.6 20.6 12 32 16.1l0 40.2 32 0 0-32.9c5.3 .6 10.6 .9 16 .9s10.7-.3 16-.9l0 32.9 32 0 0-40.2c11.4-4 22.1-9.4 32-16.1l0 120.2 96 0 0-192 32 32 0 64 64 96 64 0 32-160-16-22.4 0-105.6-48 0 0 38.4-96-134.4zm80 272a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM160 128l224 0 0 32-30.1 30.1C332.2 211.8 302.7 224 272 224s-60.2-12.2-81.9-33.9L160 160 160 128z"],
    "rss": [448, 512, ["feed"], "f09e", "M0 32l32 0c229.8 0 416 186.2 416 416l0 32-64 0 0-32C384 253.6 226.4 96 32 96L0 96 0 32zM0 416a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zM32 160c159.1 0 288 128.9 288 288l0 32-64 0 0-32c0-123.7-100.3-224-224-224l-32 0 0-64 32 0z"],
    "magnifying-glass": [576, 512, [128269, "search"], "f002", "M448.3 208c0 45.9-14.9 88.3-40 122.7L534.9 457.4 557.5 480 512.3 525.3 489.6 502.6 363 376c-34.4 25.2-76.8 40-122.7 40-114.9 0-208-93.1-208-208s93.1-208 208-208 208 93.1 208 208zm-208 144a144 144 0 1 0 0-288 144 144 0 1 0 0 288z"],
    "objects-align-left": [512, 512, [], "e3be", "M0 512L64 512 64 0 0 0 0 512zM128 64l0 160 384 0 0-160-384 0zm0 224l0 160 256 0 0-160-256 0z"],
    "cloud-moon": [640, 512, [], "f6c3", "M557.8 16.4c-65.3 16.2-113.8 75.2-113.8 145.6 0 82.8 67.2 150 150 150 13.9 0 27.3-1.9 40.1-5.4-28 37.5-69.3 64.5-117 73.8-11.1-25.3-30.2-46.3-54.1-59.8-7.6-63.4-61.6-112.6-127.1-112.6-11.2 0-22.1 1.5-32.5 4.2-4.8-4.2-9.9-8.2-15.2-11.8-.1-2.8-.2-5.6-.2-8.4 0-106 86-192 192-192 27.7 0 54 5.9 77.8 16.4zM32.1 512l0-96.1c0-47.6 34.6-87 80-94.6 0-52.8 42.6-97.3 96-97.3 34.9 0 65.4 18.6 82.2 46.4 13-9.1 28.8-14.4 45.8-14.4 44.2 0 80 35.8 80 80l0 17.6c36.5 7.4 64 39.7 64 78.4l.1 80.1-448 0z"],
    "abacus": [576, 512, [129518], "f640", "M512 96l0 112-64 0 0-32 32 0 0-48-32 0 0-32 64 0zm-96 32l-32 0 0 48 32 0 0 32-128 0 0-32 32 0 0-48-32 0 0-32 128 0 0 32zm-160 0l-32 0 0 48 32 0 0 32-96 0 0-32 32 0 0-48-32 0 0-32 96 0 0 32zm-128 0l-32 0 0 48 32 0 0 32-64 0 0-112 64 0 0 32zM64 416l0-176 64 0 0 24-32 0 0 48 32 0 0 24-32 0 0 48 32 0 0 32-64 0zm96-32l32 0 0-48-32 0 0-24 32 0 0-48-32 0 0-24 96 0 0 24-32 0 0 48 32 0 0 24-32 0 0 48 32 0 0 32-96 0 0-32zm128-72l32 0 0-48-32 0 0-24 128 0 0 96-32 0 0 48 32 0 0 32-128 0 0-32 32 0 0-48-32 0 0-24zm160 72l32 0 0-48-32 0 0-96 64 0 0 176-64 0 0-32zM64 32l-64 0 0 448 576 0 0-448-512 0z"],
    "boxes-stacked": [512, 512, [62625, "boxes", "boxes-alt"], "f468", "M224 0l0 80 64 0 0-80 96 0 0 208-256 0 0-208 96 0zM512 512l-208 0 0-256 48 0 0 80 64 0 0-80 96 0 0 256zM256 256l0 256-256 0 0-256 96 0 0 80 64 0 0-80 96 0z"],
    "code-branch": [448, 512, [], "f126", "M56 56l0 48 48 0 0-48-48 0zM0 0l160 0 0 160-48 0 0 64 176 0c26.5 0 48-21.5 48-48l0-16-48 0 0-160 160 0 0 160-48 0 0 16c0 61.9-50.1 112-112 112l-176 0 0 64 48 0 0 160-160 0 0-160 48 0 0-192-48 0 0-160zM392 56l-48 0 0 48 48 0 0-48zM104 456l0-48-48 0 0 48 48 0z"],
    "ban": [512, 512, [128683, "cancel"], "f05e", "M367.2 412.5L99.5 144.8c-22.4 31.4-35.5 69.8-35.5 111.2 0 106 86 192 192 192 41.5 0 79.9-13.1 111.2-35.5zm45.3-45.3c22.4-31.4 35.5-69.8 35.5-111.2 0-106-86-192-192-192-41.5 0-79.9 13.1-111.2 35.5L412.5 367.2zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0z"],
    "person-carry-box": [384, 512, ["person-carry"], "f4cf", "M120 24A56 56 0 1 0 8 24 56 56 0 1 0 120 24zM32 112L0 112 0 272c0 30.2 14.2 58.7 38.4 76.8l89.6 67.2 0 128 64 0 0-160-12.8-9.6-67.2-50.4 0-80.1c16.7 23.4 27.2 38.1 31.5 44.1l240.5 0 0-192-192 0 0 128-15.5 0-70.4-98.6-9.6-13.4-64.5 0zM0 512l0 32 64 0 0-116-54.4-40.8c-3.3-2.5-6.5-5.1-9.6-7.9L0 512z"],
    "circle-litecoin": [512, 512, [], "e6f4", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM240 128l0 84.5c46.6-15.5 71.3-23.8 74.1-24.7l10.1 30.4c-1.1 .4-29.2 9.7-84.2 28.1l0 89.8 112 0 0 48-160 0 0-121.8c-19.9 6.6-34 11.3-42.1 14l-10.1-30.4c6.5-2.2 23.9-8 52.2-17.4l0-100.5 48 0z"],
    "jug-detergent": [384, 512, [], "e519", "M96 0l128 0 0 48 32 0 0 48-192 0 0-48 32 0 0-48zM0 256c0-70.7 57.3-128 128-128l256 0 0 384-384 0 0-256zm256-32l0 160 64 0 0-160-64 0z"],
    "floppy-disk-pen": [640, 512, [], "e182", "M96 32l-32 0 0 448 217.6 0 9.2-55.1 10.3-10.3c-4.2 .9-8.5 1.3-13 1.3-35.3 0-64-28.7-64-64s28.7-64 64-64 64 28.7 64 64c0 4.4-.5 8.8-1.3 13L512 203.7 512 146.7 406.6 41.4 397.3 32 96 32zm64 64l224 0 0 128-224 0 0-128zM544 240l-52.8 52.8 80 80 52.8-52.8-80-80zM336 448l-16 96 96-16 132.6-132.6-80-80-132.6 132.6z"],
    "lips": [576, 512, [128068, 128482], "f600", "M114.5 118.6L0 256 92.8 367.4C135.4 418.5 198.4 448 264.9 448l46.2 0c66.5 0 129.5-29.5 172.1-80.6L576 256 461.5 118.6C432.7 84 389.9 64 344.9 64L288 102.4 231.1 64c-45.1 0-87.8 20-116.6 54.6zM96 256l96-64 96 32 96-32 80 64-67.7 38.7c-29 16.6-61.8 25.3-95.3 25.3l-31.7 0c-29.8 0-59.2-6.9-85.9-20.3L96 256z"],
    "outlet": [448, 512, [], "e01c", "M448 32l-448 0 0 448 448 0 0-448zM64 256c0-88 64-128 64-128l192 0s64 40 64 128-64 128-64 128l-192 0S64 344 64 256zm128-80l-48 0 0 80 48 0 0-80zm112 0l-48 0 0 80 48 0 0-80zM224 288c-17.7 0-32 14.3-32 32l0 16 64 0 0-16c0-17.7-14.3-32-32-32z"],
    "reply": [576, 512, [61714, "mail-reply"], "f3e5", "M16.5 208l239.8-215.9 0 135.9 112 0c97.2 0 176 78.8 176 176 0 128-128 176-128 176s32-32 32-80c0-61.9-50.1-112-112-112l-80 0 0 135.9-239.8-215.9z"],
    "sun-plant-wilt": [640, 512, [], "e57a", "M194.4 76.9l-34.4-76.9-34.4 76.9-78.7-30.1 30.1 78.7-76.9 34.4 76.9 34.4-30.1 78.7 78.7-30.1 34.4 76.9 34.4-76.9 78.7 30.1-30.1-78.7 76.9-34.4-76.9-34.4 30.1-78.7-78.7 30.1zM160 96a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm32 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm376 16l0 53.4c-14.8 7.7-24 23.1-24 44.6 0 19.5 21.5 52.9 48 78 26.5-25 48-58.7 48-78 0-21.5-9.2-37-24-44.6l0-53.4c0-44.2-35.8-80-80-80s-80 35.8-80 80l0 22.7c-9.8-4.3-20.6-6.7-32-6.7-44.2 0-80 35.8-80 80l0 21.4c-14.8 7.6-24 23.1-24 44.6 0 19.5 21.5 52.9 48 78 26.5-25 48-58.7 48-78 0-21.5-9.2-37-24-44.6l0-21.4c0-17.7 14.3-32 32-32s32 14.3 32 32l0 176-456 0 0 64 640 0 0-64-136 0 0-272c0-17.7 14.3-32 32-32s32 14.3 32 32z"],
    "face-mask": [512, 512, [], "e37f", "M75.9 437.9C65.3 427.5 55.7 416.1 47.1 404l67.4 0c8.9 34.5 40.2 60 77.5 60l128 0c37.3 0 68.6-25.5 77.5-60l67.4 0c-8.6 12.1-18.2 23.5-28.8 33.9-20.3 43.8-64.7 74.1-116.1 74.1l-128 0c-51.4 0-95.8-30.3-116.1-74.1zM112 364l-88.2 0C8.5 331.2 0 294.6 0 256 0 254.1 0 252.1 .1 250.2l111.9 49 0 64.8zm376.2 0l-88.2 0 0-64.8 111.9-49c0 1.9 .1 3.8 .1 5.8 0 38.6-8.5 75.2-23.8 108zM9.6 202C8.4 201.5 7.2 201.1 6 200.8 31.2 85.9 133.6 0 256 0S480.8 85.9 506 200.8c-1.2 .3-2.4 .7-3.6 1.3L379 256 133 256 9.6 202zm115.7 6l23.5-17.6c12.5-9.3 27.6-14.4 43.2-14.4l32 0 0-48-32 0c-26 0-51.2 8.4-72 24l-25.6 19.2 27.6 36.8 3.3 0zM390 208L417.6 171.2 392 152c-20.8-15.6-46-24-72-24l-32 0 0 48 32 0c15.6 0 30.7 5.1 43.2 14.4 2.5 1.9 10.3 7.7 23.5 17.6l3.3 0zM176 300l180 0 0 40-200 0 0-40 20 0zm0 80l180 0 0 40-200 0 0-40 20 0z"],
    "falafel": [576, 512, [129478], "e40a", "M174.8 113.8l-14.8 30.2 14.8 30.2 .3 .5 13.1-3.3c13 11 24.7 21 35.1 29.8 13.2 2.8 27.9 6 44.3 9.5 6.8 15.1 13.1 29.2 18.9 42.2l1.4 1.1 1.4-1.1c5.8-13 12.1-27 18.9-42.2 16.4-3.5 31.1-6.7 44.3-9.5 10.4-8.8 22.1-18.8 35.1-29.8 16.6 4.2 31.3 7.9 44.2 11.2l1.3-.3-.1-8 14.8-30.2-14.8-30.2 .6-33.8-26.2-20.6-13.8-30.8-32.3-7-25.4-21.6-32 8.1-32-8.1-25.4 21.6-32.3 7-13.8 30.8-26.2 20.6 .6 33.8zm128 224l-14.8 30.2 14.8 30.2-.6 33.8 26.2 20.6 13.8 30.8 32.3 7 25.4 21.6 32-8.1 32 8.1 25.4-21.6 32.3-7 13.8-30.8 26.2-20.6-.6-33.8 14.8-30.2-14.8-30.2 .6-33.8-26.2-20.6-13.8-30.8-32.3-7-25.4-21.6-32 8.1-32-8.1-25.4 21.6-32.3 7-13.8 30.8-26.2 20.6 .6 33.8zM254 288.3l-6.4-5.1-13.8-30.8-32.3-7-25.4-21.6-32 8.1-32-8.1-25.4 21.6-32.3 7-13.8 30.8-26.2 20.6 .6 33.8-14.8 30.2 14.8 30.2-.6 33.8 26.2 20.6 13.8 30.8 32.3 7 25.4 21.6 32-8.1 32 8.1 25.4-21.6 32.3-7 13.8-30.8 6.4-5.1c.2-10 .4-22.9 .7-38.7-6.4-13-13.1-26.7-20.1-41 7-14.3 13.7-28 20.1-41-.3-15.8-.5-28.7-.7-38.7zM128 392a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm232 24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM96 328a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"],
    "tombstone-blank": [448, 512, [129702, "tombstone-alt"], "f721", "M224 0C118 0 32 86 32 192l0 256-32 0 0 64 448 0 0-64-32 0 0-256C416 86 330 0 224 0z"],
    "circle-caret-up": [512, 512, ["caret-circle-up"], "f331", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm0-360l136 168-272 0 136-168z"],
    "lamp-street": [512, 512, [], "e1c5", "M176 64C114.1 64 64 114.1 64 176l0 336-64 0 0-336C0 78.8 78.8 0 176 0 268.7 0 344.6 71.6 351.5 162.6 442.6 177.6 512 256.7 512 352l-105.5 0c-7.5 41-43.4 72-86.5 72s-79-31-86.5-72L128 352c0-94.9 68.8-173.7 159.2-189.2-6.5-55.6-53.8-98.8-111.2-98.8zM283.3 352c6.2 14.1 20.3 24 36.7 24s30.5-9.9 36.7-24l-73.3 0z"],
    "circle-b": [512, 512, [], "e0fd", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM176 144l92 0c37.6 0 68 30.4 68 68 0 12.7-3.5 24.7-9.6 34.8 15.6 12.5 25.6 31.6 25.6 53.2 0 37.6-30.4 68-68 68l-108 0 0-224zm112 68c0-11-9-20-20-20l-44 0 0 40 44 0c11 0 20-9 20-20zM224 320l60 0c11 0 20-9 20-20s-9-20-20-20l-60 0 0 40z"],
    "butterfly": [512, 512, [], "e811", "M55.5 32c85.1 0 160.9 53.9 188.9 134.3l11.6 33.3 11.6-33.3C295.6 85.9 371.4 32 456.5 32l55.5 0 0 220.5-3.9 2.3-113.3 68 60.1 105.2 4.2 7.3-7.6 3.8-134.3 67.2-3.9-5.9-57.3-86-57.3 86-3.9 5.9-134.3-67.2-7.6-3.8 4.2-7.3 60.1-105.2-113.3-68-3.9-2.3 0-220.5 55.5 0z"],
    "bacterium": [576, 512, [], "e05a", "M408 16l0-24-48 0 0 47.4c-13.9 5.3-26.9 13.5-38.2 24.5-11.2-11.2-22.4-22.4-33.8-33.8L254.1 64c11.3 11.3 22.6 22.6 33.8 33.8l-30.1 30.1-33.8-33.8-33.9 33.9 33.8 33.8-30.1 30.1c-11.2-11.2-22.4-22.4-33.8-33.8L126.1 192c11.3 11.3 22.6 22.6 33.8 33.8l-30.1 30.1c-11.2-11.2-22.4-22.4-33.8-33.8L62.1 256c11.3 11.3 22.6 22.6 33.8 33.8-11 11.3-19.2 24.3-24.5 38.2l-47.4 0 0 48 40.3 0c1.3 18.3 7.1 36.4 17.4 52.4-6 6-15.2 15.2-27.6 27.6L88 489.9c12.4-12.4 21.6-21.6 27.6-27.6 16 10.3 34.1 16.1 52.4 17.4l0 40.3 48 0 0-47.4c13.9-5.3 26.9-13.5 38.2-24.5 11.2 11.2 22.4 22.4 33.8 33.8L321.9 448c-11.3-11.3-22.6-22.6-33.8-33.8l30.1-30.1 33.8 33.8 33.9-33.9c-11.3-11.3-22.6-22.6-33.8-33.8l30.1-30.1 33.8 33.8 33.9-33.9c-11.3-11.3-22.6-22.6-33.8-33.8l30.1-30.1 33.8 33.8 33.9-33.9c-11.3-11.3-22.6-22.6-33.8-33.8 11-11.3 19.2-24.3 24.5-38.2l47.4 0 0-48-40.3 0c-1.3-18.3-7.1-36.4-17.4-52.4 6-6 15.2-15.2 27.6-27.6L488 22.1c-12.4 12.4-21.6 21.6-27.6 27.6-16-10.3-34.1-16.1-52.4-17.4L408 16zM160 352a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM272 240a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "square-7": [448, 512, [], "e25c", "M448 32l-448 0 0 448 448 0 0-448zM144 144l156 0 0 37.7-2.5 5.1-90.6 181.3-53.7 0 9.4-18.7 78.6-157.3-97.2 0 0-48z"],
    "magnifying-glass-arrows-rotate": [576, 512, [], "e65e", "M445.8 240c-5.2 33.6-18.4 64.5-37.6 90.7L534.9 457.4 557.5 480 512.3 525.3 489.6 502.6 363 376c-34.4 25.2-76.8 40-122.7 40-53.4 0-102-20.1-138.9-53.1l-45.1 45.1-24-24 0-144 144 0 24 24-53.5 53.5c25.2 21.5 57.8 34.5 93.5 34.5 68.5 0 125.9-47.9 140.4-112l65.1 0zM379.1 53.1l45.1-45.1 24 24 0 144-144 0-24-24 53.5-53.5C308.6 77 275.9 64 240.3 64 171.7 64 114.4 111.9 99.8 176l-65.1 0C50.1 76.3 136.3 0 240.3 0 293.6 0 342.3 20.1 379.1 53.1z"],
    "square-i": [448, 512, [], "e272", "M448 32l-448 0 0 448 448 0 0-448zM152 144l168 0 0 48-72 0 0 128 72 0 0 48-192 0 0-48 72 0 0-128-72 0 0-48 24 0z"],
    "standard-definition": [512, 512, ["rectangle-sd"], "e28a", "M0 64l512 0 0 384-512 0 0-384zM96 216l0 8c0 30.9 25.1 56 56 56l32 0c4.4 0 8 3.6 8 8l0 8c0 4.4-3.6 8-8 8l-80 0 0 48 80 0c30.9 0 56-25.1 56-56l0-8c0-30.9-25.1-56-56-56l-32 0c-4.4 0-8-3.6-8-8l0-8c0-4.4 3.6-8 8-8l80 0 0-48-80 0c-30.9 0-56 25.1-56 56zm200-56l-24 0 0 192 72 0c39.8 0 72-32.2 72-72l0-48c0-39.8-32.2-72-72-72l-48 0zm24 144l0-96 24 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24l-24 0z"],
    "alien-8bit": [576, 512, [128126, "alien-monster"], "f8f6", "M96 32l64 0 0 32 64 0 0 64 128 0 0-64 64 0 0-32 64 0 0 64-64 0 0 64 64 0 0 64 32 0 0-96 64 0 0 160-64 0 0 96-64 0 0 96-128 0 0-64 64 0 0-32-192 0 0 32 64 0 0 64-128 0 0-96-64 0 0-96-64 0 0-160 64 0 0 96 32 0 0-64 64 0 0-64-64 0 0-64zm64 288l64 0 0-96-64 0 0 96zm192 0l64 0 0-96-64 0 0 96z"],
    "vacuum": [640, 512, [], "e04d", "M512 64l-262.1 0-75.4 352 49.6 0 0 96-95.3 0c-.4 0-.9 0-1.3 0L0 512 0 464 48 416 109 416 192.7 25.3 198.1 0 512 0c70.7 0 128 57.3 128 128 0 42.8-21 80.7-53.3 104 13.6 26.4 21.3 56.3 21.3 88l0 192-139.3 0c26.6-23.5 43.3-57.8 43.3-96 0-70.7-57.3-128-128-128-11 0-21.8 1.4-32 4l0-164 64 0c51.2 0 97.8 20.1 132.2 52.8 16.8-11.5 27.8-30.9 27.8-52.8 0-35.3-28.7-64-64-64zM384 320a96 96 0 1 1 0 192 96 96 0 1 1 0-192zm0 128a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "bowl-chopsticks-noodles": [576, 512, [], "e2ea", "M32 96l0 32 96-15 0 28-96 3 0 32 96 0 0 48-104 0 3.6 61.2C32.5 368.1 82 438.2 152 472.9l0 39.1 256 0 0-39.1c70-34.6 119.5-104.8 124.4-187.7l3.6-61.2-264 0 0-208-48 0 0 208-48 0 0-192-48 0 0 46-96 18zm288 39l0 41 224 0 0-48-224 7zm0-93l0 41 224-35 0-48-224 42z"],
    "record-vinyl": [512, 512, [], "f8d9", "M0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm256-96a96 96 0 1 1 0 192 96 96 0 1 1 0-192zm0 240a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm0-112a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "floppy-disk": [448, 512, [128190, 128426, "save"], "f0c7", "M32 32l-32 0 0 448 448 0 0-333.3-105.4-105.4-9.4-9.4-301.3 0zM96 96l224 0 0 128-224 0 0-128zM224 288a64 64 0 1 1 0 128 64 64 0 1 1 0-128z"],
    "down-left": [448, 512, [], "e16a", "M32 448L32 96 152 216 336 32 448 144 264 328 384 448 32 448z"],
    "toilets-portable": [512, 512, [], "e584", "M224 0L224 80 0 80 0 0 224 0zM0 128l224 0 0 384-48 0 0-32-128 0 0 32-48 0 0-384zm128 96l0 96 48 0 0-96-48 0zM512 0l0 80-224 0 0-80 224 0zM288 128l224 0 0 384-48 0 0-32-128 0 0 32-48 0 0-384zm128 96l0 96 48 0 0-96-48 0z"],
    "o": [448, 512, [111], "4f", "M224 96a160 160 0 1 0 0 320 160 160 0 1 0 0-320zM448 256a224 224 0 1 1 -448 0 224 224 0 1 1 448 0z"],
    "palette": [512, 512, [127912], "f53f", "M256 0C397.4 0 512 114.6 512 256l0 64-156.1 0c-37.5 0-67.9 30.4-67.9 67.9 0 18 7.2 35.3 19.9 48L320 448 256 512C114.6 512 0 397.4 0 256S114.6 0 256 0zm0 128a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm-96 32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM128 288a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM416 160a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "paintbrush-fine-slash": [576, 512, [], "e74d", "M49.3-16.9l-17-17-33.9 33.9 17 17 512 512 17 17 33.9-33.9-17-17-194.9-194.9 191-191c25-25 25-65.5 0-90.5s-65.5-25-90.5 0l-191 191-226.6-226.6zM176.1 288c-61.9 0-112 50.1-112 112l0 48-64 0 0 64 176 0c61.9 0 112-50.1 112-112 0-21.6-6.1-41.8-16.7-58.9L235 304.7c-17.1-10.6-37.3-16.7-58.9-16.7z"],
    "blueberries": [512, 512, [], "e2e8", "M512 176c0-97.2-78.8-176-176-176-80.6 0-148.6 54.2-169.4 128.2 3.1-.1 6.3-.2 9.4-.2 114.9 0 208 93.1 208 208 0 3.2-.1 6.3-.2 9.4 74-20.8 128.2-88.8 128.2-169.4zM176 512a176 176 0 1 0 0-352 176 176 0 1 0 0 352zm16-304l0 48 48 0 0 32-48 0 0 48-32 0 0-48-48 0 0-32 48 0 0-48 32 0zM384 64l0 32 48 0 0 32-48 0 0 48-32 0 0-48-48 0 0-32 48 0 0-48 32 0 0 16z"],
    "fish-bones": [576, 512, [], "e304", "M32 96l-32 32 64 128-64 128 32 32 64-64 0-72 40 0 0 96 48 0 0-96 48 0 0 96 48 0 0-96 48 0 0 96 48 0 0-96 40 0 0 120 32 0 128-144-128-144-32 0 0 120-40 0 0-96-48 0 0 96-48 0 0-96-48 0 0 96-48 0 0-96-48 0 0 96-40 0 0-72-64-64z"],
    "unlock": [384, 512, [128275], "f09c", "M128 96c0-35.3 28.7-64 64-64 31.7 0 58 23 63.1 53.3l5.3 31.6 63.1-10.6-5.3-31.6C308.1 14.1 255.5-32 192-32 121.3-32 64 25.3 64 96l0 64-64 0 0 352 384 0 0-352-256 0 0-64z"],
    "fan-table": [448, 512, [], "e004", "M256 413.6C355.7 398.2 432 312 432 208 432 93.1 338.9 0 224 0S16 93.1 16 208c0 104 76.3 190.2 176 205.6l0 34.4-128 0 0 64 320 0 0-64-128 0 0-34.4zM178.9 53.7L224.3 166c18.5-25.3 50-39.8 83.3-35.1 48.1 6.8 81.7 51.3 74.9 99.4l-2.2 15.8-120-16.9c12.6 28.7 9.5 63.2-11.2 89.7-29.9 38.3-85.2 45.1-123.5 15.2l-12.6-9.8 74.6-95.5c-31.2-3.4-59.5-23.4-72.1-54.5-18.2-45.1 3.6-96.4 48.6-114.6l14.8-6zM224 224a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"],
    "ear-listen": [512, 512, ["assistive-listening-systems"], "f2a2", "M361.8 56.6L395.2 2c65.7 39.4 110.9 109.2 116.3 190l-64.2 0c-5.2-57.6-38.2-107.3-85.4-135.4zM160 320a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM32 448a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm54.6-86.6L173.3 448 128 493.3c-8.2-8.2-37.1-37.1-86.6-86.6L18.7 384 64 338.7 86.6 361.4zM240 128c-61.9 0-112 50.1-112 112l-64 0c0-97.2 78.8-176 176-176s176 78.8 176 176c0 54.7-25 103.5-64 135.8l0 24.2c0 61.9-50.1 112-112 112l-32 0 0-64 32 0c26.5 0 48-21.5 48-48l0-57.3 14.2-9.5c30.1-20.1 49.8-54.4 49.8-93.2 0-61.9-50.1-112-112-112zM208 240l-48 0c0-44.2 35.8-80 80-80s80 35.8 80 80l-48 0c0-17.7-14.3-32-32-32s-32 14.3-32 32z"],
    "code-pull-request": [512, 512, [], "e13c", "M320 40l0-57.9c-65.6 65.6-96.8 96.8-97.9 97.9 17.6 17.6 84.8 84.8 97.9 97.9l0-65.9 32 0c17.7 0 32 14.3 32 32l0 208-48 0 0 160 160 0 0-160-48 0 0-208c0-53-43-96-96-96l-32 0 0-8zM72 56l48 0 0 48-48 0 0-48zM16 0l0 160 48 0 0 192-48 0 0 160 160 0 0-160-48 0 0-192 48 0 0-160-160 0zM72 408l48 0 0 48-48 0 0-48zm368 0l0 48-48 0 0-48 48 0z"],
    "thumbtack-angle": [576, 512, [], "e751", "M374.9 9.4L352.3-13.3 307 32c17 17 28.2 28.2 33.5 33.5L235.1 155.8c-60.1-11.2-124.6 6.4-171.2 53L335.5 480.3c46.5-46.5 64.2-111 53-171.2l90.4-105.4c5.3 5.3 16.4 16.4 33.5 33.5l45.3-45.3-22.6-22.6-160-160zM41.6 457.4L19 480 64.3 525.3c1.9-1.9 43.3-43.3 124.1-124.1L143.1 355.9 41.6 457.4z"],
    "key": [512, 512, [128273], "f084", "M336 352c97.2 0 176-78.8 176-176S433.2 0 336 0 160 78.8 160 176c0 18.7 2.9 36.8 8.3 53.7l-161.3 161.3-7 7 0 113.9 128 0 0-64 64 0 0-64 49.9 0 7-7 33.3-33.3c16.9 5.4 35 8.3 53.7 8.3zM376 96a40 40 0 1 1 0 80 40 40 0 1 1 0-80z"],
    "snake": [512, 512, [128013], "f716", "M512 80l-160-64-64 48-112 0C96.5 64 32 128.5 32 208S96.5 352 176 352l144 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-224 0-96 48 96 48 224 0c70.7 0 128-57.3 128-128S390.7 256 320 256l-144 0c-26.5 0-48-21.5-48-48s21.5-48 48-48l112 0 64 48 160-64 0-64zM352 80a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm16 48a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"],
    "circle-waveform-lines": [512, 512, ["waveform-circle"], "e12d", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM240 152l0 232-48 0 0-256 48 0 0 24zm96 48l0 136-48 0 0-160 48 0 0 24zM144 216l0 104-48 0 0-128 48 0 0 24zm288 16l0 72-48 0 0-96 48 0 0 24z"],
    "empty-set": [576, 512, [8709, 216], "f656", "M534.9 54.6L557.5 32 512.3-13.3c-11.5 11.5-33.8 33.8-67 67-43.3-33.7-97.8-53.8-157-53.8-141.4 0-256 114.6-256 256 0 59.2 20.1 113.6 53.8 157-33.2 33.2-55.6 55.6-67 67l45.3 45.3c11.5-11.5 33.8-33.8 67-67 43.3 33.7 97.8 53.8 157 53.8 141.4 0 256-114.6 256-256 0-59.2-20.1-113.6-53.8-157l44.4-44.4zM399.5 99.5L131.8 367.2c-22.4-31.4-35.5-69.8-35.5-111.2 0-106 86-192 192-192 41.5 0 79.9 13.1 111.2 35.5zM177 412.5L444.8 144.8c22.4 31.4 35.5 69.8 35.5 111.2 0 106-86 192-192 192-41.5 0-79.9-13.1-111.2-35.5z"],
    "circle-won": [512, 512, [], "e6ec", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM232.1 144l47.7 0 4.1 18.8 20.5 93.2 18.7 0c23.8-69.4 36.4-106.2 37.9-110.5l45.4 15.6c-2.4 6.9-13.2 38.5-32.5 94.9l26.1 0 0 32-37 0-32.8 95.8-5.6 16.2-37.6 0-4.1-18.8-20.5-93.1-12.7 0c-16.4 74.5-24.6 111.8-24.6 112l-37.6 0-5.6-16.2-32.8-95.8-37 0 0-32 26.1 0c-19.3-56.4-30.2-88-32.5-94.9l45.4-15.6c1.5 4.3 14.1 41.1 37.9 110.5l18.7 0c16.4-74.5 24.6-111.8 24.6-112z"],
    "hockey-stick": [576, 512, [], "e7e6", "M128.1 512l-64 0 0-192 64 0 0 192zM553.7-17.8l-203.9 509.7-8.1 20.1-165.7 0 0-192 173.5 0 132.7-331.9 11.9-29.7 59.4 23.8z"],
    "monkey": [576, 512, [128018], "f6fb", "M160 416c0-80.6 49.6-149.6 120-178l0 50 167.9 0 118.2 112.9 9.9 9.5 0 101.7-64 0 0-74.3-96-91.6 0 101.9 64 0 0 64-320 0C71.6 512 0 440.4 0 352l0-352 224 0 0 192-128 0 0-64 64 0 0-64-96 0 0 288c0 53 43 96 96 96l0-32zm96-288c0-35.3 28.6-64 64-64 15.7-37.6 52.8-64 96-64s80.4 26.4 96 64c35.3 0 64 28.7 64 64 0 32.6-24.4 59.6-56 63.5l0 64.5-208 0 0-64.5c-31.6-3.9-56-30.9-56-63.5zM384 64c-26.5 0-48 21.5-48 48 0 23.8 17.3 43.5 40 47.3l0 48.7 80 0 0-48.7c22.7-3.8 40-23.6 40-47.3 0-26.5-21.5-48-48-48l-64 0zm0 32a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm48 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"],
    "forklift": [576, 512, [], "f47a", "M512 32l0 384 64 0 0 64-128 0 0-480 64 0 0 32zM160 96l0 64 64 96 90.4 0-68.6-160-85.8 0zM96 160l0-128 192 0 96 224 0 100.1c19.5 16.1 32 40.6 32 67.9 0 48.6-39.4 88-88 88-40.3 0-74.2-27.1-84.7-64l-70.6 0c-10.4 36.9-44.4 64-84.7 64-48.6 0-88-39.4-88-88l0-264 96 0zm32 264a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zm240 0a40 40 0 1 0 -80 0 40 40 0 1 0 80 0z"],
    "skull": [512, 512, [128128], "f54c", "M416 427.4c58.5-44 96-111.6 96-187.4 0-132.5-114.6-240-256-240S0 107.5 0 240c0 75.8 37.5 143.4 96 187.4l0 84.6 80 0 0-64 48 0 0 64 64 0 0-64 48 0 0 64 80 0 0-84.6zM96 256a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zm256-64a64 64 0 1 1 0 128 64 64 0 1 1 0-128z"],
    "sneaker": [640, 512, [], "e6da", "M0 128l0 224 640 0 0-19.6c0-62.6-45.2-116-107-126.3l-83.4-13.9-65.7 65.7-33.9-33.9 57.1-57.1-37.2-22.9-66 66-33.9-33.9 57.9-57.9-87.9-54.1-48 0 0 100.7c0 32.8-26.6 59.3-59.3 59.3-22.5 0-43-12.7-53.1-32.8L48 128 0 128zM640 400l-640 0 0 48 640 0 0-48z"],
    "gamepad-modern": [576, 512, [127918, 63676, "gamepad-alt"], "e5a2", "M576 128l0 352-160 0-32-96-192 0-32 96-160 0 0-352 96-96 384 0 96 96zM136 144l0 56-56 0 0 48 56 0 0 56 48 0 0-56 56 0 0-48-56 0 0-56-48 0zm264 96a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm64-96a32 32 0 1 0 0 64 32 32 0 1 0 0-64z"],
    "square-k": [448, 512, [], "e274", "M448 32l-448 0 0 448 448 0 0-448zM265.7 144l68.9 0-9.6 9.3-85 82.6 4.6 7.7 66 110 8.6 14.3-56 0-58.6-97.7-28.6 27.8 0 69.9-48 0 0-224 48 0 0 87.2 89.7-87.2z"],
    "comment-text": [512, 512, [], "e14d", "M512 240c0 132.5-114.6 240-256 240-38.3 0-74.7-7.9-107.3-22.1L0 512 55.7 389.5C20.8 348.5 0 296.5 0 240 0 107.5 114.6 0 256 0S512 107.5 512 240zM184 144l-24 0 0 48 72 0 0 144 48 0 0-144 72 0 0-48-168 0z"],
    "mars-stroke-up": [384, 512, [9896, "mars-stroke-v"], "f22a", "M192 256a112 112 0 1 0 0 224 112 112 0 1 0 0-224zM16 368c0-86.3 62.1-158 144-173.1l0-18.9-64 0 0-64 64 0 0-61.4C140.8 65.9 123.2 80.1 107 93L67 43c7.5-6 42.5-34 105-84l20-16c3.3 2.7 36.7 29.3 100 80l25 20-40 50c-16.2-12.9-33.8-27.1-53-42.4l0 61.4 64 0 0 64-64 0 0 18.9c81.9 15 144 86.8 144 173.1 0 97.2-78.8 176-176 176S16 465.2 16 368z"],
    "cowbell": [512, 512, [], "f8b3", "M160-16l192 0 0 80 48 0 88 352-464 0 88-352 48 0 0-80zM304 32l-96 0 0 32 96 0 0-32zM256 512c-32.8 0-61-19.7-73.3-48l146.7 0c-12.3 28.3-40.5 48-73.3 48z"],
    "fire-flame-simple": [384, 512, ["burn"], "f46a", "M203.1 9.7L192 0 180.9 9.7C104.2 76.8 45.7 162.2 10.9 258 3.7 277.8 0 299 0 320.2 0 425.4 86.8 512 192 512s192-86.6 192-191.8c0-21.1-3.7-42.3-10.9-62.2-34.8-95.8-93.3-181.2-170-248.3zm78.7 296.2c4.1 9.3 6.2 19.4 6.2 29.5 0 53-43 96.5-96 96.5s-96-43.5-96-96.5c0-10.1 2.1-20.3 6.2-29.5l.9-2.1c16.4-36.8 40.5-69.6 70.8-96.1l18-15.7 18 15.7c30.3 26.5 54.5 59.3 70.8 96.1l.9 2.1z"],
    "tree": [512, 512, [127794], "f1bb", "M256-32l-176 208 76.3 0-108.3 128 89.8 0-121.8 144 208 0 0 96 64 0 0-96 208 0-121.8-144 89.8 0-108.3-128 76.3 0-176-208z"],
    "gauge-simple-min": [512, 512, ["tachometer-slowest"], "f62d", "M0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm320 96c0-35.3-28.7-64-64-64-14.5 0-27.8 4.8-38.5 12.9l-109.1-65.5-24.7 41.2 109.1 65.5c-.5 3.2-.8 6.6-.8 9.9 0 35.3 28.7 64 64 64s64-28.7 64-64z"],
    "comments-question-check": [576, 512, [], "e14f", "M384 144c0 97.2-86 176-192 176-22.8 0-44.7-3.6-65-10.3L0 352 35.4 245.8C13.1 217.1 0 181.9 0 144 0 46.8 86-32 192-32S384 46.8 384 144zm0 368c-94.1 0-172.4-62.1-188.8-144 34.3-.4 67.4-7.7 97.3-20.6l8.3 11.1 48 64 7.2 9.6 25.3 0 7-11.3 80-128 12.7-20.4-40.7-25.4c-.4 .6-25.1 40.1-74.2 118.7l-27-36-4.3-5.7c52.7-36.3 89.5-92.5 96-158.6 83.3 19.2 145 88.3 145 170.7 0 37.9-13.1 73.1-35.4 101.8L576 544 460.1 497.6C436.8 506.9 411 512 384 512zM160 101.2c0-17.7 14.3-32 32-32s32 14.3 32 32c0 13.2-6.8 20.5-15.8 25.6-9.4 5.3-20 6.6-30.5 8-2.3 .3-4.6 .6-6.9 .9l0 53.5 42.4 0 0-18.3c4.8-1.7 10.3-4 15.8-7.1 17.6-9.9 37.4-29.2 37.4-62.5 0-41.1-33.3-74.4-74.4-74.4s-74.4 33.3-74.4 74.4l42.4 0zM216 216l-48 0 0 48 48 0 0-48z"],
    "smog": [576, 512, [], "f75f", "M436.7 288l107.3 0 0-112c0-61.9-50.1-112-112-112l-1.1 0C408.7 25.7 367.4 0 320 0 294.3 0 270.4 7.6 250.3 20.6 228.6 7.5 203.2 0 176 0 96.5 0 32 64.5 32 144l0 144 235.3 0c22.6 19.9 52.2 32 84.7 32s62.1-12.1 84.7-32zM512 392c0-13.3-10.7-24-24-24L24 368c-13.3 0-24 10.7-24 24s10.7 24 24 24l464 0c13.3 0 24-10.7 24-24zM88 464c-13.3 0-24 10.7-24 24s10.7 24 24 24l80 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0zm176 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l288 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-288 0z"],
    "s": [320, 512, [115], "53", "M0 157.5C0 88.2 56.2 32 125.5 32l178.5 0 0 64-178.5 0c-34 0-61.5 27.5-61.5 61.5 0 31 23.1 57.2 53.9 61L210.1 230C272.9 237.9 320 291.2 320 354.5 320 423.8 263.8 480 194.5 480l-178.5 0 0-64 178.5 0c34 0 61.5-27.5 61.5-61.5 0-31-23.1-57.2-53.9-61L109.9 282C47.1 274.1 0 220.8 0 157.5z"],
    "phone-arrow-up-right": [512, 512, ["phone-arrow-up", "phone-outgoing"], "e224", "M128 0L0 64 0 80C0 318.6 193.4 512 432 512l16 0 64-128-128-96.8-80 80.8c-70.4-33-127-89.6-160-160L224.8 128 128 0zM335.1 143l-17 17 33.9 33.9 17-17 95-95 0 70.1 48 0 0-152-152 0 0 48 70.1 0-95 95z"],
    "teddy-bear": [512, 512, [], "e3cf", "M96.2 56c0 23 13.8 42.7 33.7 51.4-1.1 6.7-1.7 13.6-1.7 20.6 0 70.7 57.3 128 128 128s128-57.3 128-128c0-7-.6-13.9-1.7-20.6 19.8-8.6 33.7-28.4 33.7-51.4 0-30.9-25.1-56-56-56-22.3 0-41.6 13.1-50.6 32L202.9 32c-9-18.9-28.3-32-50.6-32-30.9 0-56 25.1-56 56zm288 312.1c63.4-33.9 111.9-92.2 132.7-162.4l-92-27.4C403.3 251 335.9 304 256.2 304S109.2 251 87.5 178.3l-92 27.4c20.9 70.1 69.3 128.5 132.7 162.4l0 47.9-32 0 0-32-96 0 0 128 512 0 0-128-96 0 0 32-32 0 0-47.9zM192.2 416c0-35.3 28.7-64 64-64s64 28.7 64 64l-128 0zm16-324a20 20 0 1 1 0 40 20 20 0 1 1 0-40zm76 20a20 20 0 1 1 40 0 20 20 0 1 1 -40 0zm-28 80c-17.7 0-32-10.7-32-24s14.3-24 32-24 32 10.7 32 24-14.3 24-32 24z"],
    "slot-machine": [640, 512, [], "e3ce", "M512 416l48 0 0-236.3c-9.8-8.8-16-21.5-16-35.7 0-26.5 21.5-48 48-48s48 21.5 48 48c0 14.2-6.2 26.9-16 35.7l0 300.3-592 0 0-448 480 0 0 384zM96 160l0 48 41 0-37.3 144 49.6 0 42-162 .8-3 0-27-96 0zm128 0l0 48 41 0-37.3 144 49.6 0 42-162 .8-3 0-27-96 0zm128 0l0 48 41 0-37.3 144 49.6 0 42-162 .8-3 0-27-96 0z"],
    "face-sleeping": [640, 512, [], "e38d", "M533.8-60l0 40 44 0-39.4 37.5-6.2 5.9 0 36.6 105.6 0 0-40-44 0 39.4-37.5 6.2-5.9 0-36.6-105.6 0zM388.2 36l0 40 44 0-39.4 37.5-6.2 5.9 0 36.6 105.6 0 0-40-44 0 39.4-37.5 6.2-5.9 0-36.6-105.6 0zM336.2 .5c-5.3-.3-10.6-.5-16-.5-141.4 0-256 114.6-256 256s114.6 256 256 256 256-114.6 256-256c0-16.4-1.5-32.5-4.5-48l-235.5 0 0-207.5zM196.2 280c0 11 9 20 20 20l16 0c11 0 20-9 20-20s9-20 20-20 20 9 20 20c0 33.1-26.9 60-60 60l-16 0c-33.1 0-60-26.9-60-60 0-11 9-20 20-20s20 9 20 20zm212 20l16 0c11 0 20-9 20-20s9-20 20-20 20 9 20 20c0 33.1-26.9 60-60 60l-16 0c-33.1 0-60-26.9-60-60 0-11 9-20 20-20s20 9 20 20 9 20 20 20zm-128 116a40 40 0 1 1 80 0 40 40 0 1 1 -80 0z"],
    "jedi": [576, 512, [], "f669", "M245.2 318.3l-25.1-50.2 50.1 25.1 9.8-293.2 16 0 9.8 293.2 50.1-25.1-25.1 50.2 53.2 17.7-53.2 17.7 25.1 50.2-47.2-23.6 2.2 65.7c59.8-10.8 105.1-63.1 105.1-126 0-38.3-16.8-72.7-43.5-96.1 45.3-28.3 75.5-78.5 75.5-135.9 0-30.5-8.5-59-23.3-83.2 64.9 37.8 112.8 101.7 129.2 177.4L512 224 559.5 224c.3 5.3 .5 10.6 .5 16 0 18.2-1.8 36-5.2 53.2L496 352 535.9 352C493.3 446.4 398.3 512 288 512S82.7 446.4 40.1 352l39.9 0-58.8-58.8c-3.4-17.2-5.2-35-5.2-53.2 0-5.4 .2-10.7 .5-16l47.5 0-41.8-41.8c16.4-75.6 64.2-139.6 129.2-177.4-14.8 24.2-23.3 52.7-23.3 83.2 0 57.3 30.2 107.6 75.5 135.9-26.7 23.5-43.5 57.8-43.5 96.1 0 62.9 45.4 115.2 105.1 126l2.2-65.7-47.2 23.6 25.1-50.2-53.2-17.7 53.2-17.7z"],
    "police-box": [384, 512, [], "e021", "M216 0l0 32 104 0 0 32 32 0 0 400 32 0 0 48-384 0 0-48 32 0 0-400 32 0 0-32 104 0 0-32 48 0zM96 240l0 80 80 0 0-80-80 0zm80-112l-80 0 0 80 80 0 0-80zm32 0l0 80 80 0 0-80-80 0z"],
    "dog-leashed": [576, 512, [129454], "f6d4", "M64 144c0 17.7 14.3 32 32 32l128 0 0 191.2c-22.9-2.1-44.5-8.5-64-18.5l0 163.3-96 0 0-277.6C26.7 221.2 0 185.8 0 144l0-32 64 0 0 32zm215.1 38.3l136.9 54.8 0 275-96 0 0-163.3c-14.9 7.6-31 13.2-48 16.3l0-185.6 7.1 2.8zM392 0l72 0 32 32 80 0 0 48c0 44.2-35.8 80-80 80l-64 0-7.2 28.8-125.4-50.1 36.6-170.7 32 0 24 32zM128.4-1.5l136 128 1.6 1.5-70 0-100.4-94.5-17.5-16.4 32.9-35 17.5 16.5zM448 44a20 20 0 1 0 0 40 20 20 0 1 0 0-40z"],
    "person-hiking": [448, 512, ["hiking"], "f6ec", "M192-32a56 56 0 1 1 0 112 56 56 0 1 1 0-112zM128 112l93.3 0 9.4 9.4 70.6 70.6 66.7 0 0-96 48 0 0 448-48 0 0-288-93.3 0c-3.6-3.6-15.2-15.2-34.7-34.7l0 109.2 52.8 45.3 9.1 7.8 1.7 11.9c12.6 88.1 19.4 135.9 20.5 143.7l-63.4 9.1c-1.4-9.7-7.7-53.6-18.8-131.8l-80.5-69c-21.3-18.2-33.5-44.9-33.5-72.9L128 112zm47.5 310.7c-.6 1.9-1.7 5-3.1 9.3l-4 4.7-88 104-48.9-41.3 84-99.3 7.6-22.7c2.3 2.3 4.7 4.4 7.1 6.5l45.2 38.8zM0 160c0-35.3 28.7-64 64-64l32 0 0 192-96 0 0-128z"],
    "arrows-up-to-line": [512, 512, [], "e4c2", "M64.3 0l-32 0 0 64 448 0 0-64-416 0zm86.6 137.4l-22.6-22.6c-8.2 8.2-37.1 37.1-86.6 86.6L19 224 64.3 269.3c17.3-17.3 28-28 32-32l0 274.7 64 0 0-274.7c4 4 14.7 14.7 32 32L237.5 224c-8.2-8.2-37.1-37.1-86.6-86.6zm256 0l-22.6-22.6c-8.2 8.2-37.1 37.1-86.6 86.6L275 224 320.3 269.3c17.3-17.3 28-28 32-32l0 274.7 64 0 0-274.7c4 4 14.7 14.7 32 32L493.5 224c-8.2-8.2-37.1-37.1-86.6-86.6z"],
    "pen-line": [640, 512, [], "e212", "M72 328L16 528 216 472 439 249 295 105 72 328zM560 128l-144-144-87 87 144 144 87-87zM312 464l-24 0 0 48 320 0 0-48-296 0z"],
    "badge-percent": [512, 512, [], "f646", "M256 0C292.8 0 324.8 20.7 340.9 51.1 373.8 41 411 49 437 75s34 63.3 23.9 96.1C491.3 187.2 512 219.2 512 256s-20.7 68.8-51.1 84.9C471 373.8 463 411 437 437s-63.3 34-96.1 23.9C324.8 491.3 292.8 512 256 512s-68.8-20.7-84.9-51.1C138.2 471 101 463 75 437s-34-63.3-23.9-96.1C20.7 324.8 0 292.8 0 256s20.7-68.8 51.1-84.9C41 138.2 49 101 75 75s63.3-34 96.1-23.9C187.2 20.7 219.2 0 256 0zM192 224a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm160 96a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM337 209l17-17-33.9-33.9-17 17-128 128-17 17 33.9 33.9 17-17 128-128z"],
    "mars-double": [640, 512, [9891], "f227", "M288 0l192 0 0 192-64 0 0-82.7-95 95c19.5 28.4 31 62.7 31 99.8 0 97.2-78.8 176-176 176S0 401.2 0 304 78.8 128 176 128c37 0 71.4 11.4 99.8 31l95-95-82.7 0 0-64zM176 416a112 112 0 1 0 0-224 112 112 0 1 0 0 224zm160 64c-6.8 0-13.4-.4-20-1.1 23.6-18.9 43.3-42.5 57.6-69.4 43.3-15.5 74.4-56.9 74.4-105.5 0-23.8-7.4-45.9-20.1-64l72.1 0c7.7 19.8 12 41.4 12 64 0 97.2-78.8 176-176 176zM528 157.3l0-157.3 112 0 0 192-64 0 0-82.7-48 48z"],
    "thermometer": [512, 512, [], "f491", "M96.4 382.1l0-112 7-7 31-31 49 49 33.9-33.9-49-49 46.1-46.1 49 49 33.9-33.9-49-49 46.1-46.1 49 49 33.9-33.9-49-49 7.8-7.8c19.4-19.4 45.6-30.2 73-30.2 57 0 103.2 46.2 103.2 103.2 0 27.4-10.9 53.6-30.2 73l-232.8 232.8-7 7-112 0-81 81-17 17-33.9-33.9c.6-.6 33.3-33.3 97.9-97.9z"],
    "paintbrush": [576, 512, [128396, "paint-brush"], "f1fc", "M496 0l-288 192 0 51.2c62.7 12.7 112.1 62.1 124.8 124.8L384 368 576 80 496 0zM288 400c0-61.9-50.1-112-112-112S64 338.1 64 400c0 17.2 3.9 33.4 10.8 48l-74.8 0 0 64 176 0c61.9 0 112-50.1 112-112z"],
    "signal-stream": [576, 512, [], "f8dd", "M400 256c0-36.4-17.3-68.7-44.2-89.1L405.6 125c35.9 32.2 58.4 79 58.4 131s-22.6 98.8-58.4 131l-49.7-41.9C382.7 324.7 400 292.4 400 256zM84.3 52.4l49.2 41.4C90.7 134.7 64 192.2 64 256s26.7 121.4 69.5 162.1L84.3 459.6C32.2 407.5 0 335.5 0 256S32.2 104.5 84.3 52.4zM220.2 345.1L170.4 387C134.6 354.8 112 308 112 256s22.6-98.8 58.4-131l49.7 41.9C193.3 187.3 176 219.6 176 256s17.3 68.7 44.2 89.1zM491.7 459.6l-49.2-41.4C485.3 377.4 512 319.8 512 256S485.3 134.7 442.5 93.9l49.2-41.4C543.8 104.5 576 176.5 576 256s-32.2 151.5-84.3 203.6zM288 208a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"],
    "square-p": [448, 512, [], "e279", "M448 32l-448 0 0 448 448 0 0-448zM168 144l68 0c46.4 0 84 37.6 84 84s-37.6 84-84 84l-44 0 0 56-48 0 0-224 24 0zm68 120c19.9 0 36-16.1 36-36s-16.1-36-36-36l-44 0 0 72 44 0z"],
    "bee": [512, 512, [], "e0b2", "M330.1 448c-36.5 37.3-73.7 63.7-74.1 64-.4-.3-37.6-26.7-74.1-64l148.2 0zM256 319.9c26.9 35.8 63.5 63.7 105.9 80.1l-211.8 0c42.4-16.3 79.1-44.3 105.9-80.1zM361.9 24L326.9 59c5.8 11.1 9.1 23.6 9.1 37l0 34.7c90.8 15.2 160 94.2 160 189.3l0 48-48 0c-102.7 0-186.6-80.7-191.8-182.1L256 176c0 106-86 192-192 192l-48 0 0-48c0-95.1 69.2-174.1 160-189.3L176 96c0-13.3 3.3-25.9 9.1-37l-35-35 33.9-33.9 35 35c11.1-5.8 23.6-9.1 37-9.1 13.3 0 25.9 3.3 36.9 9.1L328-9.9 361.9 24z"],
    "music-slash": [576, 512, [], "f8d1", "M49.3-16.9l-17-17-33.9 33.9 17 17 512 512 17 17 33.9-33.9-17-17-92.3-92.3c26-14.3 43.2-38.9 43.2-66.8l0-343.9-38.9 8.7-288 64-25.1 5.6 0 23.6-110.8-110.8zM253.3 187.2l194.8-43.3 0 116.7c-10-3-20.8-4.6-32-4.6-27.2 0-51.8 9.5-69.3 24.6l-93.5-93.5zm-93.2 42.6l0 94.7c-10-3-20.8-4.6-32-4.6-53 0-96 35.8-96 80s43 80 96 80 96-35.8 96-80l0-106.2-64-64z"],
    "person-simple": [192, 512, [], "e220", "M32 64A64 64 0 1 1 160 64 64 64 0 1 1 32 64zm160 96l0 192-32 0 0 160-128 0 0-160-32 0 0-192 192 0z"],
    "album-collection-circle-user": [576, 512, [], "e48f", "M128 0l0 48 256 0 0-48-256 0zM64 192L8.7 192c1.2 8.3 14.5 101.3 39.8 278.8L54.4 512 276 512c-10.5-14.6-19-30.8-25.1-48.1-86-1.9-154.9-51.3-154.9-111.9 0-61.9 71.6-112 160-112 20.8 0 40.7 2.8 58.9 7.8 32.4-25 73-39.8 117.1-39.8 23.7 0 46.4 4.3 67.3 12.1l4-28.1-439.3 0zM241.2 378c2.2-19 7.1-37.1 14.4-54-21.9 .1-39.6 12.6-39.6 28 0 11.8 10.5 21.9 25.2 26zM104 96l-24 0 0 48 352 0 0-48-328 0zM576 400a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-64.5 78.9C491.2 499.4 463.1 512 432 512s-59.2-12.6-79.5-33.1l15.5-30.9 128 0 15.5 30.9zM384 368a48 48 0 1 1 96 0 48 48 0 1 1 -96 0z"],
    "whale": [640, 512, [128011], "f72c", "M160 0l24 104 104 24-80 80-80.8-11.5-36.6 58.6c-6.7 10.7-8.3 23.9-4.3 35.9 5.8 17.3 22 29 40.3 29l1.1 0c10.5 0 20.7-3.8 28.6-10.6l103.8-89C329.7 160.8 418.4 128 510.1 128l129.9 0 0 352-477.6 0C72.7 480 0 407.3 0 317.6 0 278.2 15.7 240.3 43.6 212.4L92 164 80 80 160 0zM400 328a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"],
    "arrow-up-triangle-square": [512, 512, ["sort-shapes-up"], "f88a", "M150.9 41.4L128.3 18.7 25.6 121.4 3 144 48.3 189.3c14.6-14.6 30.6-30.6 48-48l0 338.7 64 0 0-338.7c17.4 17.4 33.4 33.4 48 48L253.5 144c-5.5-5.5-39.7-39.7-102.6-102.6zM384.3 32l-112 192 224 0-112-192zm96 256l-192 0 0 192 192 0 0-192z"],
    "neuter": [384, 512, [9906], "f22c", "M80 176a112 112 0 1 1 224 0 112 112 0 1 1 -224 0zM224 349.1c81.9-15 144-86.8 144-173.1 0-97.2-78.8-176-176-176S16 78.8 16 176c0 86.3 62.1 158.1 144 173.1l0 194.9 64 0 0-194.9z"],
    "square-phone-flip": [448, 512, ["phone-square-alt"], "f87b", "M448 32l-448 0 0 448 448 0 0-448zM288 128l64 32 0 8c0 119.3-96.7 216-216 216l-8 0-32-64 64-48.4 40 40.4c35.2-16.5 63.5-44.8 80-80l-40.4-40 48.4-64z"],
    "circle-g": [512, 512, [], "e10f", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm0-328c-39.8 0-72 32.2-72 72s32.2 72 72 72c28.3 0 52.7-16.3 64.5-40l-56.5 0 0-48 112 0 0 21-.4 5c-5.1 61.6-56.7 110-119.6 110-66.3 0-120-53.7-120-120s53.7-120 120-120c30.7 0 58.8 11.6 80 30.6l-32 35.8c-12.8-11.4-29.5-18.3-48-18.3z"],
    "circle-down-right": [512, 512, [], "e108", "M256 0a256 256 0 1 0 0 512 256 256 0 1 0 0-512zm72 352l-169.9 0c29.6-29.6 52.3-52.3 68-68l-84-84c24.3-24.3 54.1-54.1 57.9-57.9l84 84c15.7-15.7 38.4-38.4 68-68l0 193.9-24 0z"],
    "people-dress": [640, 512, [], "e217", "M248.3 24a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zm256 0a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zM375.4 252.7l-47.1 147.3 40 0 0 144 64 0 0-144 32 0 0 144 64 0 0-144 40 0-47.1-147.3c19.9 37.3 33.9 63.5 42 78.6l56.5-30.2-15.1-28.2-76.9-144-9-16.9-140.5 0-9 16.9-48.7 91.2-48.7-91.2-9-16.9-140.5 0-9 16.9-76.9 144-15.1 28.2 56.5 30.2c8.1-15.1 22.1-41.3 42-78.6l-47.1 147.3 40 0 0 144 64 0 0-144 32 0 0 144 64 0 0-144 40 0-47.1-147.3c20.9 39.2 32.9 61.6 35.9 67.3l38.4 0c3-5.7 15-28.1 36-67.3z"],
    "circle-half": [512, 512, [], "e110", "M256 0C114.6 0 0 114.6 0 256S114.6 512 256 512L256 0z"],
    "face-grin-tongue-squint": [512, 512, [128541, "grin-tongue-squint"], "f58a", "M0 256c0 104.4 62.5 194.2 152.2 234.1-5.3-13-8.2-27.2-8.2-42.1l0-61.7c-23.5-23-39.9-53.2-45.7-87 45.3 18.1 99.5 28.7 157.7 28.7s112.4-10.6 157.7-28.7c-5.8 33.8-22.2 64-45.7 87l0 61.7c0 14.9-2.9 29.1-8.2 42.1 89.7-39.8 152.2-129.6 152.2-234.1 0-141.4-114.6-256-256-256S0 114.6 0 256zm230.8-78.3l9.2 4.6 0 20.2-10.2 4.3-95.6 40-14.7-28.3 44.2-27.6-45.3-34 16.8-27.1 95.6 48zm146-48l16.8 27.1-45.3 34 44.2 27.6-14.7 28.3-95.6-40-10.2-4.3 0-20.2 9.2-4.6 95.6-48zM320 448l0-64-48 0 0 24-32 0 0-24-48 0 0 64c0 35.3 28.7 64 64 64s64-28.7 64-64z"],
    "pickaxe": [576, 512, [], "e5bf", "M576 224c0 57-18.6 109.7-50.2 152.3-47.6-173.7-184.4-310.5-358.1-358.1 42.6-31.5 95.2-50.2 152.3-50.2 59.2 0 113.6 20.1 157 53.8 6.6-6.6 18.2-18.2 35-35L557.3 32c-16.8 16.8-28.5 28.5-35 35 33.7 43.3 53.8 97.8 53.8 157zM41.4 457.4L336.7 162c16.1 14 31.2 29.2 45.3 45.3L86.6 502.6 64 525.3 18.7 480 41.4 457.4z"],
    "comment-dollar": [512, 512, [], "f651", "M512 240c0 132.5-114.6 240-256 240-38.3 0-74.7-7.9-107.3-22.1L0 512 55.7 389.5C20.8 348.5 0 296.5 0 240 0 107.5 114.6 0 256 0S512 107.5 512 240zM280 128l-40 0 0 24c-28.8 .3-52 23.7-52 52.5 0 25.7 18.5 47.6 43.9 51.8l41.7 7c6 1 10.4 6.2 10.4 12.3 0 6.9-5.6 12.5-12.5 12.5l-75.5 0 0 40 44 0 0 24 40 0 0-24.7c25-4.1 44-25.7 44-51.8 0-25.7-18.5-47.6-43.9-51.8l-41.7-7c-6-1-10.4-6.2-10.4-12.3 0-6.9 5.6-12.5 12.5-12.5l67.5 0 0-40-28 0 0-24z"],
    "list-timeline": [512, 512, [], "e1d1", "M240 16l208 0 0 128-214.6 0-4.7-4.7c-38.1-38.1-57.9-57.9-59.3-59.3 1.4-1.4 21.2-21.2 59.3-59.3l4.7-4.7 6.6 0zm-6.6 176l278.6 0 0 128-278.6 0-4.7-4.7c-38.1-38.1-57.9-57.9-59.3-59.3 1.4-1.4 21.2-21.2 59.3-59.3l4.7-4.7zm0 176l214.6 0 0 128-214.6 0-4.7-4.7c-38.1-38.1-57.9-57.9-59.3-59.3 1.4-1.4 21.2-21.2 59.3-59.3l4.7-4.7zM32 80a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM80 208a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm0 176a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"],
    "swords-laser": [640, 512, [], "e03d", "M426.9 215.8L640-24 600-64 355.3 153.5 426.9 215.8zM182.1 297.9l-26.7 26.7 96 96 26.7-26.7-96-96zm46.6 145.4l-96-96-25.4 25.4 96 96 25.4-25.4zM0 480l96 96 84.7-84.7-96-96-84.7 84.7zM364 224L40-64 0-24 220.4 224 364 224zM595.3 508.7L640 464 531.3 355.3 486.6 400 595.3 508.7zm-22.6 22.6L464 422.6 419.3 467.3 528 576 572.7 531.3zm-176-86.6l112-112-60.7-60.7-224 0 172.7 172.7z"],
    "phone-waveform": [640, 512, [], "e6e2", "M480-8l0-24-48 0 0 256 48 0 0-232zm80 32l0-24-48 0 0 192 48 0 0-168zM400 40l0-24-48 0 0 160 48 0 0-136zM640 72l0-24-48 0 0 96 48 0 0-72zM192 0L64 64 64 80c0 238.6 193.4 432 432 432l16 0 64-128-128-96.8-80 80.8c-70.4-33-127-89.6-160-160L288.7 128 192 0z"],
    "hippo": [640, 512, [129435], "f6ed", "M424.5 30.1c11.3 11.3 22.7 22.7 34.2 34.2 1.9-.1 3.9-.2 5.8-.2l32 0c11.2 0 21.9 2.3 31.6 6.5 10-10 20.9-20.9 32.4-32.4L594.4 72c-12 12-22 22-29.9 29.9 7.6 12.2 12 26.7 12 42.1l0 17.6c36.5 7.4 64 39.7 64 78.4 0 26.2-12.6 49.4-32 64l0 48-64 0 0-32-64 0 0 32-64 0 0-33.6c-11.8-2.4-22.7-7.4-32-14.4-1.5-1.1-2.9-2.3-4.3-3.5-17-14.7-27.7-36.4-27.7-60.5l0-16-32 0 0 16c0 44.7 26.2 83.2 64 101.2l0 42.8 64 0 0 96-128 0 0-108c-19.8 7.7-41.4 12-64 12s-44.2-4.3-64-12l0 108-128 0 0-150.9-18.1 40.7-43.9-19.5 29.9-67.3 0-18.9c0-107.7 85.1-195.5 191.8-199.8l.2-.2 64 0 109 36.3c3.8-5.9 8.4-11.2 13.6-15.8l-3.5-3.5-17-17 33.9-33.9zm56 201.9a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm88 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm-88-112a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm48 16a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"],
    "sword-laser-alt": [640, 512, [], "e03c", "M600-64L276 224 419.6 224 640-24 600-64zM0 464L44.7 508.7 153.4 400 108.7 355.3 0 464zM112 576L220.7 467.3 176 422.6 67.3 531.3 112 576zm19.3-243.3l112 112 172.7-172.7-224 0-60.7 60.7z"],
    "flower": [448, 512, [127804, 10047], "f7ff", "M128 480c38.2 0 72.5-16.8 96-43.3 23.5 26.6 57.8 43.3 96 43.3 70.7 0 128-57.3 128-128 0-38.2-16.8-72.5-43.3-96 26.6-23.5 43.3-57.8 43.3-96 0-70.7-57.3-128-128-128-38.2 0-72.5 16.8-96 43.3-23.5-26.6-57.8-43.3-96-43.3-70.7 0-128 57.3-128 128 0 38.2 16.8 72.5 43.3 96-26.6 23.5-43.3 57.8-43.3 96 0 70.7 57.3 128 128 128zm96-128l-96-96 96-96 96 96-96 96z"],
    "bowl-food": [512, 512, [], "e4c6", "M0 176c0-35.3 28.7-64 64-64 .5 0 1.1 0 1.6 0 7.4-36.5 39.7-64 78.4-64 15 0 29 4.1 40.9 11.2 13.3-25.7 40.1-43.2 71.1-43.2s57.8 17.6 71.1 43.2c12-7.1 26-11.2 40.9-11.2 38.7 0 71 27.5 78.4 64 .5 0 1.1 0 1.6 0 35.3 0 64 28.7 64 64 0 11.7-3.1 22.6-8.6 32L8.6 208C3.1 198.6 0 187.7 0 176zM0 280l0-24 512 0 0 24c0 67-39.2 124.9-96 151.8l0 48.2-320 0 0-48.2C39.2 404.9 0 347 0 280z"],
    "globe-pointer": [640, 512, [], "e60e", "M351.9 280l95.6 0c-3.9 62.3-22.3 121.2-45.3 165.5-13 25-26.6 43.7-38.3 55.4-5.4 5.4-9.3 8.2-11.6 9.7-2.3-1.5-6.2-4.3-11.6-9.7-11.5-11.5-24.9-29.8-37.7-54.3l47.4-161.1 1.6-5.5zm14.1-48l9.1-30.9c-66.9 19.7-101.9 30-105 30.9L257 232c3.9-62.3 22.3-121.2 45.3-165.5 13-25 26.6-43.7 38.3-55.4 5.4-5.4 9.3-8.2 11.6-9.7 2.3 1.5 6.2 4.3 11.6 9.7 11.7 11.7 25.3 30.4 38.3 55.4 23 44.3 41.5 103.2 45.3 165.5l-81.4 0zM97.4 232c9.8-105.6 83.7-192.5 182.4-221.6-35.2 52.1-66 133.6-70.9 221.6L97.4 232zm509.8 48c-9.8 105.6-83.7 192.5-182.4 221.6 35.2-52.1 66-133.6 70.9-221.6l111.6 0zM424.7 10.4c98.7 29.1 172.6 116 182.4 221.6l-111.6 0c-4.9-88-35.7-169.5-70.9-221.6zM32.3 352l272-80-80 272-48-96-1.4-1.4C105.3 516.2 68.4 553.1 64.3 557.3L19 512c4.2-4.2 41.1-41.1 110.6-110.6l-1.4-1.4-96-48z"],
    "eggplant": [512, 512, [], "e16c", "M480 65.9l31.4-31.4-33.9-33.9-31.4 31.4-158.1 0 16 48 48 16 16 48 48 16 16 48 48 16 0-158.1zM257.4 92c-26.9 17.9-57.3 32.7-87.5 47.3-86.5 42-171.5 83.3-169.9 196.7 1.4 95.3 79.8 175.9 176.4 176 125.3 .1 220.1-129.1 270.3-248.5-21.1-7-38.7-12.9-52.7-17.6-4.9-14.8-10.3-30.8-16-48-17.2-5.7-33.2-11.1-48-16-4.9-14.8-10.3-30.8-16-48-17.2-5.7-33.2-11.1-48-16l-7.6-22.8-1.1-3.2z"],
    "folder-arrow-right": [512, 512, [], "e7d3", "M224 32l64 48 224 0 0 368-512 0 0-416 224 0zm6.1 160l48 48-126.1 0 0 48 126.1 0-48 48 33.9 33.9 105.9-105.9-105.9-105.9-33.9 33.9z"],
    "battery-slash": [640, 512, [], "f377", "M81.2-16.9l-17-17-33.9 33.9 17 17 512 512 17 17 33.9-33.9-64.1-64.1 62 0 0-128 32 0 0-128-32 0 0-128-446 0-80.9-80.9zM226 128l318 0 0 256-62 0-256-256zM346.2 384l-250.2 0 0-250.2-64-64 0 378.2 378.2 0-64-64z"],
    "film-slash": [576, 512, [], "e179", "M49.3-16.9l-17-17-33.9 33.9 17 17 512 512 17 17 33.9-33.9c-5.9-5.9-28-28-66.1-66.1l0-414-414 0-48.9-48.9zM64.1 480l346.2 0-234.2-234.2 0 42.2-64 0 0-64 42.2 0-90.2-90.2 0 346.2zm48-128l64 0 0 64-64 0 0-64zm288-128l64 0 0 64-64 0 0-64zm64-128l0 64-64 0 0-64 64 0z"],
    "square-virus": [448, 512, [], "e578", "M448 32l-448 0 0 448 448 0 0-448zM308.9 137.2l33.9 33.9-17 17C309.6 204.3 321.1 232 344 232l24 0 0 48-24 0c-22.9 0-34.4 27.7-18.2 43.9l17 17-33.9 33.9-17-17C275.7 341.6 248 353.1 248 376l0 24-48 0 0-24c0-22.9-27.7-34.4-43.9-18.2l-17 17-33.9-33.9 17-17c16.2-16.2 4.7-43.9-18.2-43.9l-24 0 0-48 24 0c22.9 0 34.4-27.7 18.2-43.9l-17-17 33.9-33.9 17 17c16.2 16.2 43.9 4.7 43.9-18.2l0-24 48 0 0 24c0 22.9 27.7 34.4 43.9 18.2l17-17zM192 248a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm88 40a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"],
    "tricycle-adult": [640, 512, [], "e5c4", "M288 64l96.8 0 9.5 13.8 125.5 181.3c7.7-2 15.8-3.1 24.2-3.1 53 0 96 43 96 96s-43 96-96 96-96-43-96-96c0-21.4 7-41.1 18.8-57.1l-18.2-26.3-83.4 83.4-142.4 0c-7.8 54.3-54.4 96-110.9 96-61.9 0-112-50.1-112-112 0-45.3 26.9-84.3 65.6-102-25-74.9-39-117-42.1-126.3L84.2 87.5c4.3 12.9 15.9 47.8 34.8 104.5l104.9 0 0 64-33.6 0c9.4 9.2 17.1 20 22.8 32l125.5 0 72.8-72.8-60.3-87.2-63.2 0 0-64zM176 336a64 64 0 1 0 -128 0 64 64 0 1 0 128 0zm368 64a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"],
    "circle-phone-flip": [512, 512, ["phone-circle-alt"], "e11c", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm64-384l64 32 0 8c0 119.3-96.7 216-216 216l-8 0-32-64 64-48.4 40 40.4c35.2-16.5 63.5-44.8 80-80l-40.4-40 48.4-64z"],
    "cloud-sun-rain": [640, 512, [127782], "f743", "M335.6-3.2l-4.7-23.2c-4.7 3.1-34.8 23.1-90.5 60-55.6-36.9-85.8-56.9-90.5-60-1.1 5.5-8.3 41-21.5 106.4-65.4 13.2-100.9 20.4-106.4 21.5 3.1 4.7 23.1 34.9 60 90.5-36.9 55.6-56.9 85.8-60 90.5 5.5 1.1 41 8.3 106.4 21.5 13.2 65.4 20.4 100.9 21.5 106.4 10-6.6 29.5-19.6 58.5-38.8l0-89.1c-37.3-13.2-64-48.7-64-90.5 0-53 43-96 96-96 21.7 0 41.8 7.2 57.8 19.4 15.5-17.6 36.9-30 61.1-34l-7-1.4-16.8-83.2zM275.4 159.1c-8.8-9.3-21.2-15.1-35-15.1-26.5 0-48 21.5-48 48 0 17 8.9 32 22.2 40.5 10.2-31.4 32.1-57.4 60.7-73l.1-.4zM608.4 352l0-80c0-33.9-21.1-62.9-50.9-74.5 1.9-6.8 2.9-14 2.9-21.5 0-44.2-35.8-80-80-80-30.8 0-57.5 17.4-70.9 42.8-9.3-6.8-20.7-10.8-33.1-10.8-34.2 0-60.9 32-55.2 65.4-36.9 7.1-64.8 39.6-64.8 78.6l0 80 352 0zM255.1 512l50.6 0 37.3-112-50.6 0-37.3 112zm290.6 0l37.3-112-50.6 0-37.3 112 50.6 0zm-120 0l37.3-112-50.6 0-37.3 112 50.6 0z"],
    "h4": [512, 512, [], "f86a", "M64 96l0-32-64 0 0 384 64 0 0-160 96 0 0 160 64 0 0-384-64 0 0 160-96 0 0-128zm288 0l0-32-64 0 0 224 160 0 0 160 64 0 0-384-64 0 0 160-96 0 0-128z"],
    "circle-caret-right": [512, 512, ["caret-circle-right"], "f330", "M0 256a256 256 0 1 0 512 0 256 256 0 1 0 -512 0zm360 0l-168 136 0-272 168 136z"],
    "keyboard-brightness-low": [512, 512, [], "e1c1", "M224 128l0 64 64 0 0-64-64 0zM96 178.7L50.7 224 96 269.3 141.3 224 96 178.7zM64 352l-64 0 0 64 64 0 0-64zm96 0l-32 0 0 64 256 0 0-64-224 0zm352 0l-64 0 0 64 64 0 0-64zM416 178.7L370.7 224 416 269.3 461.3 224 416 178.7z"],
    "arrow-right-long": [640, 512, ["long-arrow-right"], "f178", "M598.9 278.6L621.5 256 598.9 233.4 448.3 82.7 403 128c6.6 6.6 38.6 38.6 96 96l-466.7 0 0 64 466.7 0-96 96 45.3 45.3 150.6-150.6z"],
    "font-case": [576, 512, [], "f866", "M96.4 168l0 88 96 0 0-88c0-22.1-17.9-40-40-40l-16 0c-22.1 0-40 17.9-40 40zm-64 120l0-120c0-57.4 46.6-104 104-104l16 0c57.4 0 104 46.6 104 104l0 280-64 0 0-128-96 0 0 128-64 0 0-160zm392-32c-22.1 0-40 17.9-40 40l0 48c0 22.1 17.9 40 40 40l16 0c22.1 0 40-17.9 40-40l0-48c0-22.1-17.9-40-40-40l-16 0zm56-56l0-8 64 0 0 170.8c17.6 52.9 27.1 81.3 28.4 85.2l-67.5 0-6.1-18.2c-16.7 11.5-37 18.2-58.9 18.2l-16 0c-57.4 0-104-46.6-104-104l0-48c0-57.4 46.6-104 104-104l16 0c14.2 0 27.7 2.8 40 8z"],
    "building-un": [512, 512, [], "e4d9", "M32 0l384 0 0 336-176 0 0 16-64 0 0 112 64 0 0 48-208 0 0-512zM192 96l-64 0 0 64 64 0 0-64zm64 0l0 64 64 0 0-64-64 0zM192 224l-64 0 0 64 64 0 0-64zm64 0l0 64 64 0 0-64-64 0zM412 380l37.2 0c.7 1.7 9.6 22.7 26.8 63l0-63 40 0 0 168-38.8 0c-1-2.3-9.4-22.1-25.2-59.2l0 59.2-40 0 0-168zm-88 20l0 96c0 6.6 5.4 12 12 12s12-5.4 12-12l0-116 40 0 0 116c0 28.7-23.3 52-52 52s-52-23.3-52-52l0-116 40 0 0 20z"],
    "toilet-paper-xmark": [512, 512, [], "e5b3", "M305.2 66.8C311 55.1 318.3 43.1 327.1 32L96 32C43 32 0 118 0 224S43 416 96 416l231.1 0c-8.8-11.1-16-23.1-21.9-34.8-21.4-42.7-33.2-98.4-33.2-157.2s11.8-114.5 33.2-157.2zM384 224c0-35.3 14.3-64 32-64s32 28.7 32 64-14.3 64-32 64-32-28.7-32-64zm128 0c0-106-43-192-96-192s-96 86-96 192 43 192 96 192 96-86 96-192zM128 464l0 80 384 0 0-137.6c-21.3 30.9-53 57.6-96 57.6l-288 0zM228.9 173.1c-8.5 8.5-25.5 25.5-50.9 50.9 25.5 25.5 42.4 42.4 50.9 50.9l-33.9 33.9c-8.5-8.5-25.5-25.5-50.9-50.9-25.5 25.5-42.4 42.4-50.9 50.9L59.1 274.9c8.5-8.5 25.5-25.5 50.9-50.9-25.5-25.5-42.4-42.4-50.9-50.9l33.9-33.9 50.9 50.9c25.5-25.5 42.4-42.4 50.9-50.9l33.9 33.9z"],
    "temperature-low": [512, 512, [], "f76b", "M96 0l192 0 0 260.7c29.5 26.4 48 64.7 48 107.3 0 79.5-64.5 144-144 144S48 447.5 48 368c0-42.6 18.5-81 48-107.3L96 0zm96 432c35.3 0 64-28.7 64-64 0-26.9-16.5-49.9-40-59.3l0-52.7-48 0 0 52.7c-23.5 9.5-40 32.5-40 59.3 0 35.3 28.7 64 64 64zM464 80a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM352 80a80 80 0 1 1 160 0 80 80 0 1 1 -160 0z"],
    "h2": [576, 512, [], "f314", "M96 96l0-32-64 0 0 384 64 0 0-160 96 0 0 160 64 0 0-384-64 0 0 160-96 0 0-128zM368 64l-32 0 0 64 113.1 0c21.5 0 38.9 17.4 38.9 38.9 0 13.9-7.5 26.8-19.6 33.8l-76.3 43.6C347.5 269.7 320 317.1 320 368.5l0 79.5 224 0 0-64-160 0 0-15.5c0-28.4 15.2-54.6 39.9-68.7l76.3-43.6C532.2 237.9 552 203.8 552 166.9 552 110.1 505.9 64 449.1 64L368 64z"],
    "face-smile-halo": [512, 512, [], "e38f", "M512 48c0-44.2-114.6-80-256-80S0 3.8 0 48 114.6 128 256 128 512 92.2 512 48zm-64 0c0 17.7-86 32-192 32S64 65.7 64 48 150 16 256 16 448 30.3 448 48zm48 224c0-45.7-12.8-88.4-35-124.8-3.2 1.1-6.4 2.2-9.7 3.2-52.1 16.3-121.2 25.6-195.3 25.6s-143.2-9.3-195.3-25.6c-3.3-1-6.5-2.1-9.7-3.2-22.2 36.4-35 79.1-35 124.8 0 132.5 107.5 240 240 240S496 404.5 496 272zM163.8 351.5C184 380.9 217.8 400 256 400s72-19.1 92.2-48.5l39.5 27.3C358.9 420.6 310.7 448 256 448s-102.9-27.4-131.8-69.2l39.5-27.3zM148 272l0 28-40 0 0-28c0-37.6 30.4-68 68-68s68 30.4 68 68l0 28-40 0 0-28c0-15.5-12.5-28-28-28s-28 12.5-28 28zm188-28c-15.5 0-28 12.5-28 28l0 28-40 0 0-28c0-37.6 30.4-68 68-68s68 30.4 68 68l0 28-40 0 0-28c0-15.5-12.5-28-28-28z"],
    "rocket-vertical": [448, 512, [], "e7bd", "M167.4 424.6c3.2-3.2 6.6-6 10.1-8.6l92.9 0c3.5 2.5 6.9 5.4 10.1 8.6L384 528 432 352 340.6 260.6C376 107.5 285.7 25.1 224-16 162.3 25.1 72 107.5 107.4 260.6L16 352 64 528 167.4 424.6zM224 112a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"],
    "door-open": [448, 512, [], "f52b", "M288 64l64 0 0 448 96 0 0-64-32 0 0-448-160 0 0 0-224 0 0 448-32 0 0 64 288 0 0-448zM160 256a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"],
    "align-left": [448, 512, [], "f036", "M288 32l0 64-288 0 0-64 288 0zm0 256l0 64-288 0 0-64 288 0zM0 160l448 0 0 64-448 0 0-64zM448 416l0 64-448 0 0-64 448 0z"],
    "pencil-slash": [576, 512, [], "e215", "M49.3-16.9l-17-17-33.9 33.9 17 17 512 512 17 17 33.9-33.9-17-17-184.4-184.4c18-18 38.7-38.7 62.3-62.3-15.6-15.6-52.3-52.3-110.1-110.1l-33.9-33.9c-23.6 23.6-44.3 44.3-62.3 62.3L49.3-16.9zM164.9 234.6L72.1 327.4c-31.5 112.6-50.2 179.3-56 200 20.8-5.8 87.4-24.5 200-56l92.8-92.8-144-144zM115 352.5l1.1-1 28.1 0 0 48 48 0 0 28.1-1.1 1.1-105.7 29.6 29.6-105.7zm324.2-172l33.9 33.9c53.4-53.4 60.2-60.2 87-87-15.6-15.6-52.3-52.3-110.1-110.1L416.1-16.6c-53.4 53.4-60.2 60.2-87 87 15.6 15.6 52.3 52.3 110.1 110.1z"],
    "camera": [512, 512, [62258, "camera-alt"], "f030", "M160 32l-32 64-128 0 0 384 512 0 0-384-128 0-32-64-192 0zm96 160a96 96 0 1 1 0 192 96 96 0 1 1 0-192z"],
    "hat-winter": [512, 512, [], "f7a8", "M282.5 32L256 5.5 229.5 32 192 32 192 69.5 165.5 96 192 122.5 192 139.3C128.4 163.5 87.4 223.7 62.9 292.6l65.1 32.6 117.3-58.6 10.7-5.4 128 64 65.1-32.6C424.6 223.7 383.6 163.5 320 139.3l0-16.8 26.5-26.5-26.5-26.5 0-37.5-37.5 0zM479.1 448c-1.9-34.5-7-72-16-108.7l-79.1 39.5-128-64-117.3 58.6-10.7 5.4-10.7-5.4-68.4-34.2c-9 36.7-14.1 74.2-16 108.7l-32.9 0 0 64 512 0 0-64-32.9 0z"],
    "house-person-return": [640, 512, ["house-person-arrive", "house-return"], "e011", "M472 24a56 56 0 1 1 -112 0 56 56 0 1 1 112 0zm-8 88l13.3 0 9.4 9.4 80 80 9.4 9.4 0 109.3-64 0 0-82.7-32-32 0 69.3c0 28-12.2 54.7-33.5 72.9l-80.7 69.1c-11 71.6-17.4 112.9-19.1 123.9l-63.3-9.7c1.4-9 8.3-54.2 20.9-135.6l1.8-11.7 9-7.7 52.8-45.3 0-115.2c-17.6 22-28.4 35.6-32.6 40.8l-111.4 0 0-64 80.6 0 54.4-68 9.6-12 95.4 0zm15.9 259l12.6 44.2c44.7 44.7 71.6 71.6 80.8 80.8l-45.3 45.3-86.6-86.6-5.9-5.9c-.8-2.7-3.8-13.2-9-31.5l46-39.4c2.5-2.2 5-4.4 7.4-6.8zM308.9 109.8l-27.4 34.2-105.6 0 0 160 144 0 0 4.3c-27.6 23.6-44.6 38.2-50.9 43.7L48 352 48 192 16 192 16 161.2 192 8 308.9 109.8z"],
    "knife": [576, 512, ["utensil-knife"], "f2e4", "M480 16l-464 464 48 48 192-192 64 64 181.5-181.5c50-50 50-131 0-181L480 16z"],
    "message-exclamation": [512, 512, ["comment-alt-exclamation"], "f4a5", "M512 448l-224 0-160 96 0-96-128 0 0-416 512 0 0 416zM228 308l0 56 56 0 0-56-56 0zm-4-196l12.8 160 38.4 0 12.8-160-64 0z"],
    "right-to-line": [512, 512, ["arrow-alt-to-right"], "f34c", "M512 64l0 384-64 0 0-384 64 0zM395 256l-18.5 17.4c-113.3 107-174.7 165-184.5 174.2l0-127.7-192 0 0-128 192 0 0-127.7c9.7 9.2 71.2 67.3 184.5 174.2L395 256z"],
    "mailbox": [576, 512, [128234], "f813", "M240 208c0-53-43-96-96-96s-96 43-96 96l0 224 192 0 0-224zM0 208C0 128.5 64.5 64 144 64l272 0c88.4 0 160 71.6 160 160l0 256-576 0 0-272zm80 0l128 0 0 48-128 0 0-48zm264 0l-24 0 0 48 80 0 0 64 80 0 0-112-136 0z"],
    "message-heart": [512, 512, [], "e5c9", "M0 32l0 416 128 0 0 96 160-96 224 0 0-416-512 0zM249.6 183.5l6.4 8.5 6.4-8.5c11.1-14.8 28.5-23.5 46.9-23.5 32.4 0 58.7 26.3 58.7 58.7l0 5.3c0 64-112 128-112 128S144 288 144 224l0-5.3c0-32.4 26.3-58.7 58.7-58.7 18.5 0 35.9 8.7 46.9 23.5z"],
    "message-middle-top": [512, 512, ["comment-middle-top-alt"], "e1e2", "M176 64l80-96 80 96 176 0 0 416-512 0 0-416 176 0z"],
    "users-rays": [640, 512, [], "e593", "M48.4-49.9L14.5-16c4.8 4.8 29.1 29.1 73 73l17 17 33.9-33.9c-4.8-4.8-29.1-29.1-73-73l-17-17zm544 0c-4.8 4.8-29.1 29.1-73 73l-17 17 33.9 33.9c4.8-4.8 29.1-29.1 73-73l17-17-33.9-33.9zM65.4 545c43.8-43.8 68.2-68.2 73-73l-33.9-33.9c-4.8 4.8-29.1 29.1-73 73l-17 17 33.9 33.9 17-17zm527 17l33.9-33.9-73-73-17-17-33.9 33.9c4.8 4.8 29.1 29.1 73 73l17 17zM320.4 208a64 64 0 1 0 0-128 64 64 0 1 0 0 128zm112 176l-48-144-128 0-48 144 224 0zm104-224a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zm-96.1 96l37.6 112.8 5.1 15.2 93.4 0-48-128-88.1 0zm-239.9 0l-88.1 0-48 128 93.4 0 5.1-15.2 37.6-112.8zm15.9-96a56 56 0 1 0 -112 0 56 56 0 1 0 112 0z"],
    "circles-overlap": [576, 512, [], "e600", "M160 304c0 14.1 1.4 27.9 4.1 41.2-58-18.6-100.1-73-100.1-137.2 0-79.5 64.5-144 144-144 39 0 74.4 15.5 100.3 40.7-85.8 25.7-148.3 105.2-148.3 199.3zM383.7 96.6C346.8 38.5 281.9 0 208 0 93.1 0 0 93.1 0 208 0 317.6 84.8 407.4 192.3 415.4 229.2 473.5 294.1 512 368 512 482.9 512 576 418.9 576 304 576 194.4 491.2 104.6 383.7 96.6zm28.2 70.2c58 18.6 100.1 73 100.1 137.2 0 79.5-64.5 144-144 144-39 0-74.4-15.5-100.3-40.7 85.8-25.7 148.3-105.2 148.3-199.3 0-14.1-1.4-27.9-4.1-41.2z"],
    "rainbow": [640, 512, [127752], "f75b", "M320 96C178.6 96 64 210.6 64 352l0 96-64 0 0-96C0 175.3 143.3 32 320 32S640 175.3 640 352l0 96-64 0 0-96C576 210.6 461.4 96 320 96zm0 112c-79.5 0-144 64.5-144 144l0 96-64 0 0-96c0-114.9 93.1-208 208-208s208 93.1 208 208l0 96-64 0 0-96c0-79.5-64.5-144-144-144zM288 352l0 96-64 0 0-96c0-53 43-96 96-96s96 43 96 96l0 96-64 0 0-96c0-17.7-14.3-32-32-32s-32 14.3-32 32z"],
    "box-arrow-down-arrow-up": [448, 512, [], "e795", "M448 128l0 352-448 0 0-352 80-112 288 0 80 112zM120 344l-56 0 80 96 80-96-56 0 0-152-48 0 0 152zm104-64l56 0 0 152 48 0 0-152 56 0-80-96-80 96zM78.7 128l290.7 0-34.3-48-222.1 0-34.3 48z"],
    "left-from-dotted-line": [576, 512, [], "e6c2", "M21.5 256l202.9 192 0-128 192 0 0-128-32 0 0 0-160 0 0-128-202.9 192zM480.4 448l64 0 0-64-64 0 0 64zm0-170.7l0 64 64 0 0-64-64 0zm0-42.7l64 0 0-64-64 0 0 64zm0-170.7l0 64 64 0 0-64-64 0z"],
    "sitemap": [512, 512, [], "f0e8", "M192 32l128 0 0 128-40 0 0 64 192 0 0 128 40 0 0 128-128 0 0-128 40 0 0-80-144 0 0 80 40 0 0 128-128 0 0-128 40 0 0-80-144 0 0 80 40 0 0 128-128 0 0-128 40 0 0-128 192 0 0-64-40 0 0-128z"],
    "caravan-simple": [640, 512, ["caravan-alt"], "e000", "M544 32l-512 0 0 384 104.4 0c-.2 2.6-.4 5.3-.4 8 0 48.6 39.4 88 88 88s88-39.4 88-88c0-2.7-.1-5.4-.4-8l328.4 0 0-64-96 0 0-320zM128 128l128 0 0 128-128 0 0-128zm320 0l0 128-128 0 0-128 128 0zM184 424a40 40 0 1 1 80 0 40 40 0 1 1 -80 0z"],
    "face-grin-stars": [576, 512, [129321, "grin-stars"], "f587", "M288.2 512c141.4 0 256-114.6 256-256 0-17.8-1.8-35.1-5.3-51.9l30.9-19.6-13.9-87.1-74.2-18.7-39.7-70.3-66.9 6.7c-27.1-9.8-56.4-15.1-86.9-15.1-30.6 0-60 5.4-87.2 15.3L134 9 96.1 78.5 20.5 97.4 6.5 184.6 37.4 204.1c-3.4 16.8-5.3 34.1-5.3 51.9 0 141.4 114.6 256 256 256zM418.9 324.9c11.9-3.7 23.9 6.3 19.6 18.1-22.4 61.3-81.3 105.1-150.3 105.1S160.2 404.2 137.8 342.9c-4.3-11.8 7.7-21.8 19.6-18.1 39.2 12.2 83.7 19.1 130.7 19.1s91.5-6.9 130.7-19.1zM400.2 67.8l33.8 68.5 75.6 11-54.7 53.3 12.9 75.3-67.6-35.5-67.6 35.5 12.9-75.3-54.7-53.3 75.6-11 33.8-68.5zM210 136.2l75.6 11-54.7 53.3 12.9 75.3-67.6-35.5-67.6 35.5 12.9-75.3-54.7-53.3 75.6-11 33.8-68.5 33.8 68.5z"],
    "message-sms": [512, 512, [], "e1e5", "M0 32l0 416 128 0 0 96 160-96 224 0 0-416-512 0zM140.8 172.8l35.2 0 0 32-35.2 0c-5.3 0-9.6 4.3-9.6 9.6s4.3 9.6 9.6 9.6c23 0 41.6 18.6 41.6 41.6s-18.6 41.6-41.6 41.6l-41.6 0 0-32 41.6 0c5.3 0 9.6-4.3 9.6-9.6s-4.3-9.6-9.6-9.6c-23 0-41.6-18.6-41.6-41.6s18.6-41.6 41.6-41.6zm188.8 41.6c0-23 18.6-41.6 41.6-41.6l35.2 0 0 32-35.2 0c-5.3 0-9.6 4.3-9.6 9.6s4.3 9.6 9.6 9.6c23 0 41.6 18.6 41.6 41.6s-18.6 41.6-41.6 41.6l-41.6 0 0-32 41.6 0c5.3 0 9.6-4.3 9.6-9.6s-4.3-9.6-9.6-9.6c-23 0-41.6-18.6-41.6-41.6zm-19.2-25.6l0 118.4-32 0 0-62.5c-4.6 8.6-12 22.5-22.1 41.8-10.5-19.1-18.1-32.8-22.7-41.2l0 61.9-32 0 0-134.4 16 0 12.7 0c.3 .6 8.8 16 25.5 46.3l20-37.8 4.5-8.5c14.2 0 16.5 0 30.1 0l0 16z"],
    "comments-question": [576, 512, [], "e14e", "M192 320c106 0 192-78.8 192-176S298-32 192-32 0 46.8 0 144c0 37.9 13.1 73.1 35.4 101.8L0 352 127 309.7c20.3 6.7 42.2 10.3 65 10.3zm3.2 48c16.4 81.9 94.7 144 188.8 144 27 0 52.8-5.1 76.1-14.4L576 544 540.6 437.8c22.3-28.7 35.4-63.9 35.4-101.8 0-82.4-61.7-151.5-145-170.7-11.5 115.8-115.8 201.2-235.8 202.7zM192 69.2c-17.7 0-32 14.3-32 32l-42.4 0c0-41.1 33.3-74.4 74.4-74.4s74.4 33.3 74.4 74.4c0 33.3-19.8 52.7-37.4 62.5-5.5 3.1-11 5.4-15.8 7.1l0 18.3-42.4 0 0-53.5c2.3-.3 4.6-.6 6.9-.9 10.5-1.3 21.1-2.7 30.5-8 9-5.1 15.8-12.4 15.8-25.6 0-17.7-14.3-32-32-32zM168 216l48 0 0 48-48 0 0-48z"],
    "sort-up": [448, 512, ["sort-asc"], "f0de", "M8 224L224-8 440 224 8 224z"],
    "billboard": [576, 512, [], "e5cd", "M168 64l-136 0 0 288-32 0 0 64 256 0 0 96 64 0 0-96 256 0 0-64-32 0 0-288-136 0 0 80 40 0 0 48-128 0 0-48 40 0 0-80-144 0 0 80 40 0 0 48-128 0 0-48 40 0 0-80z"],
    "eye": [576, 512, [128065], "f06e", "M288 32C129.6 32 30 181.3 0 256 30 330.7 129.6 480 288 480S546 330.7 576 256C546 181.3 446.4 32 288 32zM144 256a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm144 96c53 0 96-43 96-96s-43-96-96-96l0 96-96 0c0 53 43 96 96 96z"],
    "arrow-down-small-big": [512, 512, ["sort-size-down-alt"], "f88d", "M288 32l160 0 0 160-160 0 0-160zm0 224l224 0 0 224-224 0 0-224zM150.6 470.6L128 493.3c-5.5-5.5-39.7-39.7-102.6-102.6L2.7 368 48 322.7c14.6 14.6 30.6 30.6 48 48l0-338.7 64 0 0 338.7c17.4-17.4 33.4-33.4 48-48L253.3 368c-5.5 5.5-39.7 39.7-102.6 102.6z"],
    "axe": [640, 512, [129683], "f6b2", "M473.9 105.9l54.1 54.1 112 0 0 32c0 123.7-100.3 224-224 224l-32 0 0-112-176-176 144-144 54.1 54.1c1-1 15-15 41.9-41.9L515.9 64c-27 27-40.9 40.9-41.9 41.9zM228.1 216L296 283.9 105.9 473.9 72 507.9 4.1 440 38.1 406.1 228.1 216z"],
    "caret-left": [320, 512, [], "f0d9", "M224 80L24 256 224 432 224 80z"],
    "apple-whole": [448, 512, [127822, 127823, "apple-alt"], "f5d1", "M208 96l0-16c0-44.2 35.8-80 80-80l32 0 0 32c0 44.2-35.8 80-80 80l-32 0 0-16zM0 288c0-76.3 35.7-160 112-160l112 32 112-32c76.3 0 112 83.7 112 160 0 128-80 224-160 224l-64-16-64 16C80 512 0 416 0 288z"],
    "scroll-torah": [576, 512, ["torah"], "f6a0", "M0 0l96 0 0 32 384 0 0-32 96 0 0 512-96 0 0-32-384 0 0 32-96 0 0-512zM176 320l77.9 0 34.1 56 34.1-56 77.9 0-39-64 39-64-77.9 0-34.1-56-34.1 56-77.9 0 39 64-39 64z"],
    "house-lock": [640, 512, [], "e510", "M368 512l0-208 32 0c0-60 41.2-110.3 96.9-124.2L288-16 32 224 32 272 80 272 80 512 368 512zM224 464l0-144 96 0 0 144-96 0zM528 272c17.7 0 32 14.3 32 32l0 48-64 0 0-48c0-17.7 14.3-32 32-32zm-80 32l0 48-32 0 0 192 224 0 0-192-32 0 0-48c0-44.2-35.8-80-80-80s-80 35.8-80 80z"],
    "square-litecoin": [448, 512, [], "e6f7", "M448 32l-448 0 0 448 448 0 0-448zM208 128l0 84.5c46.6-15.5 71.3-23.8 74.1-24.7l10.1 30.4c-1.1 .4-29.2 9.7-84.2 28.1l0 89.8 112 0 0 48-160 0 0-121.8c-19.9 6.6-34 11.3-42.1 14l-10.1-30.4c6.5-2.2 23.9-8 52.2-17.4l0-100.5 48 0z"],
    "arrows-left-right-to-line": [576, 512, [], "e4ba", "M64 96l-64 0 0 320 64 0 0-320zM454.6 278.6L477.3 256c-8.2-8.2-37.1-37.1-86.6-86.6L368 146.7 322.7 192c17.3 17.3 28 28 32 32l-133.5 0c4-4 14.7-14.7 32-32L208 146.7c-8.2 8.2-37.1 37.1-86.6 86.6L98.7 256 185.4 342.6 208 365.3 253.3 320c-17.3-17.3-28-28-32-32l133.5 0-32 32 45.3 45.3 86.6-86.6zM576 128l0-32-64 0 0 320 64 0 0-288z"],
    "trash": [448, 512, [], "f1f8", "M144-16l-16 48-128 0 0 64 448 0 0-64-128 0-16-48-160 0zM416 144l-384 0 24 368 336 0 24-368z"],
    "face-sad-tear": [512, 512, [128546, "sad-tear"], "f5b4", "M0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm271 98c5.5-1.3 11.2-2 17-2 27.6 0 51.6 15.5 63.7 38.4l42.4-22.5c-20.1-37.9-60.1-63.9-106.1-63.9-12.5 0-24.6 1.9-35.9 5.5 9.8 12.7 16.5 27.9 18.9 44.6zM176 240a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm192-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM135.2 338.6c-4.2 8.4-7.2 17.7-7.2 27 0 28.7 20.7 50.4 48 50.4s48-21.7 48-50.4c0-9.3-3.1-18.6-7.2-27-9.7-19.7-24.8-36.2-40.8-50.6-16 14.4-31.1 30.9-40.8 50.6z"],
    "tire-flat": [512, 512, [], "f632", "M400 288c0-39.2-15.7-74.7-41.1-100.7L330.1 227c13.7 16.6 21.9 37.8 21.9 61 0 2-.1 4-.2 6l46.6 15.2c1-6.9 1.5-14 1.5-21.2zm-63.1 51.6c-12.9 20.2-33.2 35.2-57 41.3l0 35 42.1 0c26.3-13.6 47.8-35 61.5-61.2l-46.6-15.2zM232 416l0-35c-23.8-6.1-44-21.2-56.9-41.3l-46.6 15.2C142.2 381 163.7 402.4 190 416l42 0zM36.1 419.1C13.2 380.8 0 335.9 0 288 0 146.6 114.6 32 256 32S512 146.6 512 288c0 47.9-13.2 92.8-36.1 131.1l36.1 28.9 0 64-512 0 0-64 36.1-28.9zM112 288c0 7.2 .5 14.3 1.5 21.2L160.2 294c-.1-2-.2-4-.2-6 0-23.2 8.2-44.4 21.9-61l-28.8-39.7C127.7 213.3 112 248.8 112 288zm144-96c12.5 0 24.4 2.4 35.4 6.7L320.2 159c-19.3-9.6-41.1-15-64.2-15s-44.8 5.4-64.1 15l28.8 39.7c10.9-4.3 22.9-6.7 35.4-6.7zm0 128a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "melon": [512, 512, [], "e310", "M512 256c0 141.4-114.6 256-256 256-50.8 0-98.1-14.8-137.9-40.3 65 .4 164.5-16.1 251-102.6s103-186 102.6-251C497.2 157.9 512 205.2 512 256zM142.9 142.9C68.2 217.5 50.9 334.5 47.6 404.8 17.7 362.8 0 311.5 0 256 0 114.6 114.6 0 256 0 309.1 0 358.5 16.2 399.4 43.9 332 44.8 224.8 61 142.9 142.9zM95.1 422.7c.3-18.9 1.7-43.3 5.7-70.2 9.1-62.3 30.6-130.3 76.1-175.7 54.3-54.3 122.9-75.3 180.7-82.1 25.3-3 47.8-3.2 65-2.4 1.4 15.5 2 35.5-.1 58.3-5.1 54.1-25.4 122.9-87.2 184.7s-130.6 82.1-184.7 87.2c-21.4 2-40.4 1.6-55.4 .4z"],
    "fax": [512, 512, [128224, 128439], "f1ac", "M160 0l0 144 64 0 0-80 146.7 0 45.3 45.3 0 34.7 64 0 0-61.3-73.4-73.4-9.4-9.4-237.3 0zM112 128l-112 0 0 352 112 0 0-352zm400 64l-352 0 0 288 352 0 0-288zM224 288a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm0 96a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM336 264a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM312 384a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM424 264a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM400 384a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"],
    "arrow-left-long-to-line": [640, 512, [], "e3d4", "M265.4 105.4L288 82.7 333.3 128c-6.6 6.6-38.6 38.6-96 96l402.7 0 0 64-402.7 0c57.4 57.4 89.4 89.4 96 96l-45.3 45.3-150.6-150.6-22.6-22.6 22.6-22.6 128-128zM0 128l0-32 64 0 0 320-64 0 0-288z"],
    "user-music": [640, 512, [], "f8eb", "M256 248a120 120 0 1 0 0-240 120 120 0 1 0 0 240zm16 247.9c0-31.8 17.3-56.8 37.9-72.3 12.3-9.3 26.7-15.9 42.1-19.7l0-99.8-240 0-64 208 225.5 0c-1-5.1-1.5-10.5-1.5-16.1zm352-240l0-28.8-28.3 5.1-176 32-19.7 3.6 0 181.8c-5.9-1.1-11.4-1.6-16-1.6-9.5 0-22.9 2.1-34.9 7.5-11.1 5-29.1 17.2-29.1 40.5s18 35.4 29.1 40.5c11.9 5.4 25.4 7.5 34.9 7.5s22.9-2.1 34.9-7.5c11.1-5 29.1-17.2 29.1-40.5l0-140.1 128-23.3 0 85c-5.9-1.1-11.4-1.6-16-1.6-9.5 0-22.9 2.1-34.9 7.5-11.1 5-29.1 17.2-29.1 40.5s18 35.4 29.1 40.5c11.9 5.4 25.4 7.5 34.9 7.5s22.9-2.1 34.9-7.5c11.1-5 29.1-17.2 29.1-40.5l0-208.1z"],
    "person-circle-plus": [640, 512, [], "e541", "M168 24a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm-11.4 88l134.8 0 9.6 13.2 85.2 117.3c-17.8 12.4-33.4 27.8-46.1 45.5l-36.1-49.7 0 305.7-64 0 0-208-32 0 0 208-64 0 0-305.7c-28.6 39.4-47.6 65.6-56.9 78.4l-51.8-37.6 18.8-25.9 92.9-128 9.6-13.2zM496 256a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm16 80l0-16-32 0 0 64-64 0 0 32 64 0 0 64 32 0 0-64 64 0 0-32-64 0 0-48z"],
    "hamsa": [512, 512, [], "f665", "M256 384a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM0 288l96 0 0-256 80 0 0 192 40 0 0-224 80 0 0 224 40 0 0-192 80 0 0 256 96 0 0 48-95.4 105c-41.1 45.2-99.4 71-160.6 71S136.6 486.2 95.4 441L0 336 0 288zm256 0c-48 0-96 64-96 64s48 64 96 64 96-64 96-64-48-64-96-64z"],
    "house-building": [640, 512, [], "e1b1", "M320 0l0 124.6 144 116.3 0 110.9-32 0 0 160.2 208 0 0-512-320 0zM440.2 160l-56.2-45.4 0-18.6 64 0 0 64-7.8 0zM576 96l0 64-64 0 0-64 64 0zM528 224l48 0 0 64-48 0 0-64zm48 128l0 64-64 0 0-64 64 0zM384 304l32 0 0-40-208-168-208 168 0 40 32 0 0 208 352 0 0-208zM256 272l0 96-96 0 0-96 96 0z"],
    "person-circle-question": [640, 512, [], "e542", "M168 24a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm-11.4 88l134.8 0 9.6 13.2 85.2 117.3c-17.8 12.4-33.4 27.8-46.1 45.5l-36.1-49.7 0 305.7-64 0 0-208-32 0 0 208-64 0 0-305.7c-28.6 39.4-47.6 65.6-56.9 78.4l-51.8-37.6 18.8-25.9 92.9-128 9.6-13.2zM352 400a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm144-56c13.3 0 24 10.7 24 24 0 7.2-4.2 13.7-10.8 16.6-14.8 6.6-24.6 10.9-29.2 13l0 26.4 32 0 0-5.6 10.2-4.5c18.1-8.1 29.8-26 29.8-45.9 0-30.9-25.1-56-56-56s-56 25.1-56 56l32 0c0-13.3 10.7-24 24-24zM480 480l32 0 0-32-32 0 0 32z"],
    "crate-empty": [512, 512, [], "e151", "M512 224l-512 0 0 128 512 0 0-128zm0 160l-512 0 0 128 512 0 0-128zM64 272a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM48 448a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM448 272a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM432 448a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"],
    "sun-haze": [576, 512, [], "f765", "M173.6-20.2c10.6 7.1 48.8 32.4 114.4 75.9 65.6-43.5 103.8-68.8 114.4-75.9 2.5 12.5 11.6 57.4 27.2 134.6 77.2 15.6 122.1 24.7 134.6 27.2-7.1 10.6-32.4 48.8-75.9 114.4l42.5 64-131.9 0c10.9-18.8 17.1-40.7 17.1-64 0-70.7-57.3-128-128-128S160 185.3 160 256c0 23.3 6.2 45.2 17.1 64l-131.9 0 42.5-64C44.1 190.4 18.8 152.2 11.8 141.6 24.3 139 69.2 130 146.4 114.3 162 37.1 171-7.7 173.6-20.2zM368 256c0 26.2-12.6 49.4-32 64l-96 0c-19.4-14.6-32-37.8-32-64 0-44.2 35.8-80 80-80s80 35.8 80 80zM512 368l0 48-512 0 0-48 512 0zM64 464l128 0 0 48-128 0 0-48zm176 0l336 0 0 48-336 0 0-48z"],
    "circle-3": [512, 512, [], "e0f0", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm28-280c11 0 20-9 20-20s-9-20-20-20l-108 0 0-48 108 0c37.6 0 68 30.4 68 68 0 16.8-6.1 32.1-16.2 44 10.1 11.9 16.2 27.2 16.2 44 0 37.6-30.4 68-68 68l-108 0 0-48 108 0c11 0 20-9 20-20s-9-20-20-20l-76 0 0-48 76 0z"],
    "clipboard-check": [384, 512, [], "f46c", "M320 32l64 0 0 480-384 0 0-480 64 0 0-32 256 0 0 32zM249.4 217.9L163.8 335.6c-19.3-20-33.7-34.9-43.2-44.7L86.1 324.2c6.2 6.4 27.2 28.1 63.1 65.3l19.8 20.6 16.8-23.1 102.4-140.8 14.1-19.4-38.8-28.2-14.1 19.4zM112 112l160 0 0-48-160 0 0 48z"],
    "share-from-square": [576, 512, [61509, "share-square"], "f14d", "M384 336l192-176-192-176 0 112-64 0c-79.5 0-144 64.5-144 144 0 104.7 128 144 128 144s-32-26.2-32-65.5c0-52.2 42.3-94.5 94.5-94.5l17.5 0 0 112zM64 96l-32 0 0 416 416 0 0-128-64 0 0 64-288 0 0-288 48 0 0-64-80 0z"],
    "fork-knife": [576, 512, ["utensils-alt"], "f2e6", "M456 24L440 8 316.6 78.5c-27.6 15.8-44.6 45.1-44.6 76.8 0 19.4 6.4 38.1 18 53.4L57.4 441.4 34.7 464 80 509.3 102.6 486.6 335.2 254c15.3 11.6 34 18 53.4 18 31.8 0 61.1-17 76.8-44.6l70.5-123.4-16-16-104 104-16-16 96-112-16-16-112 96-16-16 104-104zM96 16L74.5 37.5c-50 50-50 131 0 181l68.9 68.9 87-87c-4.2-13.9-6.5-28.5-6.5-43.3 0-4.2 .2-8.4 .5-12.6L96 16zM512 528l48-48-160.5-160.5c-4.2 .4-8.4 .5-12.6 .5-14.8 0-29.4-2.2-43.3-6.5l-23 23 191.4 191.4z"],
    "receipt": [384, 512, [129534], "f543", "M0 0l0 512 64-48 64 48 64-48 64 48 64-48 64 48 0-512-64 48-64-48-64 48-64-48-64 48-64-48zM104 136l200 0 0 48-224 0 0-48 24 0zM80 328l224 0 0 48-224 0 0-48zm24-96l200 0 0 48-224 0 0-48 24 0z"],
    "equals": [448, 512, [62764], "3d", "M32 128l-32 0 0 64 448 0 0-64-416 0zm0 192l-32 0 0 64 448 0 0-64-416 0z"],
    "diagram-lean-canvas": [576, 512, [], "e156", "M464 96l0 176 48 0 0-176-48 0zm-48 0l-48 0 0 64 48 0 0-64zm-96 0l-64 0 0 176 64 0 0-176zM208 96l-48 0 0 64 48 0 0-64zm-96 0l-48 0 0 176 48 0 0-176zM64 320l0 96 200 0 0-96-200 0zm248 96l200 0 0-96-200 0 0 96zM0 32l576 0 0 448-576 0 0-448zM208 272l0-64-48 0 0 64 48 0zm208-64l-48 0 0 64 48 0 0-64z"],
    "box-arrow-up": [448, 512, [], "e827", "M448 128l0 352-448 0 0-352 80-112 288 0 80 112zM118.1 296l33.9 33.9 48-48 0 126.1 48 0 0-126.1 48 48 33.9-33.9-105.9-105.9-105.9 105.9zM78.7 128l290.7 0-34.3-48-222.1 0-34.3 48z"],
    "chevron-up": [512, 512, [], "f077", "M256.3 82.7l22.6 22.6 214.6 214.6-45.3 45.3-22.6-22.6-169.4-169.4-169.4 169.4-22.6 22.6-45.3-45.3 22.6-22.6 192-192 22.6-22.6z"],
    "virus-slash": [576, 512, [], "e075", "M49.3-16.9l-17-17-33.9 33.9 17 17 512 512 17 17 33.9-33.9c-1.6-1.6-32.3-32.3-92.1-92.1l11.3-11.3-28.4-28.4c-31-31.2-8.9-84.3 35.1-84.3l40 0 0-80-40 0c-44 0-66.1-53.2-35.1-84.4l28.4-28.4-56.6-56.6-28.3 28.3c-31.2 31.2-84.4 9.1-84.4-35l0-40-80 0 0 40c0 44.1-53.3 66.1-84.4 35L135.4 46.7 124.1 58 49.3-16.9zM72.1 216l-40 0 0 80 40 0c44.1 0 66.1 53.3 35 84.5l-28.3 28.3 56.6 56.6 28.6-28.6c31.2-30.7 84.1-8.6 84.1 35.3l0 40 80 0 0-40.1c0-21.4 12.6-37.6 29.1-45l-240-240C109.8 203.4 93.5 216 72.1 216z"],
    "globe-stand": [448, 512, [], "f5f6", "M23.5 359l-17 17 33.9 33.9c12.4-12.4 21.6-21.6 27.5-27.5 34.3 27.7 74.9 43.8 116.5 48.3l0 33.3-120 0 0 48 288 0 0-48-120 0 0-33.3c49.1-5.3 96.8-26.7 134.4-64.3 81.7-81.7 87.1-211 16.1-298.9 5.9-5.9 15.1-15.1 27.5-27.5L376.4 6.1C352.6 29.9 318 64.5 315.9 66.6l17 17c68.7 68.7 68.7 180.2 0 248.9s-180.2 68.7-248.9 0l-17-17c-9.7 9.7-24.2 24.2-43.5 43.5zm185-7a144 144 0 1 0 0-288 144 144 0 1 0 0 288z"],
    "ring-diamond": [384, 512, [], "e5ab", "M128 0l-32 72 35.8 65.6C55.2 162.9 0 235 0 320 0 426 86 512 192 512s192-86 192-192c0-85-55.2-157.1-131.8-182.4L288 72 256 0 128 0zM320 320a128 128 0 1 1 -256 0 128 128 0 1 1 256 0z"],
    "phone-rotary": [512, 512, [9742], "f8d3", "M0 224l0-96s96-96 256-96 256 96 256 96l0 96-64.3 0c-43.4-70.5-66.4-107.8-68.9-112l-245.6 0c-2.6 4.2-25.6 41.5-68.9 112L0 224zM32 480l0-112 128-208 192 0 128 208 0 112-448 0zM328 312a72 72 0 1 0 -144 0 72 72 0 1 0 144 0z"],
    "slash": [576, 512, [], "f715", "M32.3-33.9l17 17 512 512 17 17-33.9 33.9-17-17-512-512-17-17 33.9-33.9z"],
    "arrow-down-to-dotted-line": [384, 512, [], "e095", "M0 512l64 0 0-64-64 0 0 64zM192 397.3l22.6-22.6 128-128 22.6-22.6-45.3-45.3c-6.6 6.6-38.6 38.6-96 96l0-274.7-64 0 0 274.7c-57.4-57.4-89.4-89.4-96-96l-45.3 45.3 22.6 22.6 128 128 22.6 22.6zM170.7 512l0-64-64 0 0 64 64 0zm42.7 0l64 0 0-64-64 0 0 64zM384 512l0-64-64 0 0 64 64 0z"],
    "saxophone-fire": [640, 512, ["sax-hot"], "f8db", "M0 153.6c0 2.1 .1 4.3 .2 6.4L87 160c14.9-25.1 41-44.7 41-44.7s26.1 19.5 41 44.7l86.9 0c.1-2.1 .2-4.3 .2-6.4 0-21.3-15.4-76.8-76.8-128L153.6 51.2 102.4 0C68.3 21.3 0 81.9 0 153.6zM168 344l50.9-88 37.1 0 0-48-256 0 0 48 16.9 0-12.6 53.4C1.5 321.8 0 334.4 0 347.1l0 3.1c0 89.3 72.4 161.8 161.8 161.8 49.4 0 96.1-22.6 126.8-61.4l255.4-322.6 96 0 0-32-48-32-80 0-63 63c-3.8-3.8-12.2-12.2-25-25L390.1 136c12.8 12.8 21.1 21.1 25 25L401 175c-3.8-3.8-12.2-12.2-25-25L342.1 184c12.8 12.8 21.1 21.1 25 25L353 223c-3.8-3.8-12.2-12.2-25-25L294.1 232c12.8 12.8 21.1 21.1 25 25l-119 119-32-32zm-24-64a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zM88 344a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"],
    "window-frame-open": [448, 512, [], "e050", "M416 64l0 224-384 0 0-288 384 0 0 64zM256 64l0 160 96 0 0-160-96 0zm-64 0l-96 0 0 160 96 0 0-160zM96 448l256 0 0-112 64 0 0 112 32 0 0 64-448 0 0-64 32 0 0-112 64 0 0 112z"],
    "circle-d": [512, 512, [], "e104", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM184 144l72 0c61.9 0 112 50.1 112 112S317.9 368 256 368l-96 0 0-224 24 0zm72 176c35.3 0 64-28.7 64-64s-28.7-64-64-64l-48 0 0 128 48 0z"],
    "expand": [448, 512, [], "f065", "M32 32l-32 0 0 160 64 0 0-96 96 0 0-64-128 0zM64 352l0-32-64 0 0 160 160 0 0-64-96 0 0-64zM320 32l-32 0 0 64 96 0 0 96 64 0 0-160-128 0zM448 352l0-32-64 0 0 96-96 0 0 64 160 0 0-128z"],
    "scooter": [512, 512, [], "e7c3", "M256 32l121 0 6.1 24.2 64 256 2.4 9.7c35.8 8 62.5 39.9 62.5 78.1 0 44.2-35.8 80-80 80-32.8 0-61-19.7-73.3-48l-205.3 0c-12.3 28.3-40.5 48-73.3 48-44.2 0-80-35.8-80-80s35.8-80 80-80c32.8 0 61 19.7 73.3 48l205.3 0c6-13.7 15.7-25.4 27.9-33.8l-1.6-6.4-57.9-231.8-71 0 0-64zM112 400a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm352 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "file-mp4": [576, 512, [], "e649", "M272 0l-240 0 0 512 112 0 0-176 272 0 0-192-144-144zm85.5 176L240 176 240 58.5 357.5 176zM324 400l0-20-20 0c-2.7 0-8.5 0-17.6 0-.5 1-10.8 20.3-30.7 57.9-20.8-37.9-31.5-57.2-31.8-57.9-17.7 0-17.9 0-35.8 0l0 168 40 0 0-77.4c5.8 10.5 15.2 27.6 28.3 51.5 12.7-24 22-41.4 27.7-52.2l0 78.1 40 0 0-148zm44-20l-20 0 0 168 40 0 0-48 12 0c33.1 0 60-26.9 60-60s-26.9-60-60-60l-32 0zm32 80l-12 0 0-40 12 0c11 0 20 9 20 20s-9 20-20 20zm76 24l64 0 0 60 40 0 0-160-40 0 0 60-24 0 0-60-40 0 0 100z"],
    "note-sticky": [448, 512, [62026, "sticky-note"], "f249", "M304 480l-304 0 0-448 448 0 0 304-144 144zm85.5-176L272 304 272 421.5 389.5 304z"],
    "dolphin": [512, 512, [], "e168", "M176 0l30.5 0c46.1 0 89.7 10.2 128.9 28.6L464 0 480 16 427.4 94.8c52.4 55 84.6 129.4 84.6 211.3 0 94.2-79.2 169.5-173.3 164.3l-72.5-4-18.3 45.7-88 0 32-80-32-80 88 0 21.5 53.7 60-3c30.5-1.5 54.5-26.7 54.5-57.3 0-31.7-25.7-57.4-57.4-57.4l-6.6 0 0 64-32 0-80-64-208 0 0-66.1c8.5-5.1 22.5-13.5 42-25.2-6.4-16.3-10-34.1-10-52.7 0-79.5 64.5-144 144-144zm0 168a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"],
    "border-bottom": [448, 512, [], "f84d", "M448 480l-448 0 0-64 448 0 0 64zM64 352l-64 0 0-64 64 0 0 64zM384 96l0-64 64 0 0 64-64 0zm64 128l-64 0 0-64 64 0 0 64zM384 352l0-64 64 0 0 64-64 0zM64 224l-64 0 0-64 64 0 0 64zM0 96l0-64 64 0 0 64-64 0zm192 0l-64 0 0-64 64 0 0 64zm64 0l0-64 64 0 0 64-64 0z"],
    "user-message": [576, 512, [], "e7b1", "M320 0l0 192 64 0 0 80 80-80 112 0 0-192-256 0zM224 8C157.7 8 104 61.7 104 128s53.7 120 120 120c17.1 0 33.3-3.6 48-10l0-220c-14.7-6.4-30.9-10-48-10zM432 512l-64-208-288 0-64 208 416 0z"],
    "signal-weak": [512, 512, ["signal-1"], "f68c", "M72 480l-48 0 0-96 48 0 0 96z"],
    "table-columns": [448, 512, ["columns"], "f0db", "M0 32l448 0 0 448-448 0 0-448zM64 160l0 256 128 0 0-256-128 0zm320 0l-128 0 0 256 128 0 0-256z"],
    "person-shelter": [512, 512, [], "e54f", "M64 181.4l0 330.6-64 0 0-368 256-144 256 144 0 368-64 0 0-330.6-192-108-192 108zM256 128a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm-48 96l110.3 0 6.8 12.6 56 104 11.4 21.1-42.3 22.8c-5-9.3-17.8-33-38.2-71l0 198.5-48 0 0-112-16 0 0 112-48 0 0-198.5c-20.5 38.1-33.2 61.7-38.2 71l-42.3-22.8 11.4-21.1 56-104 6.8-12.6 14.3 0z"],
    "camera-security": [448, 512, ["camera-home"], "f8fe", "M448 0l-448 0 0 416 200 0 0 48-104 0 0 48 256 0 0-48-104 0 0-48 200 0 0-416zM224 96a112 112 0 1 1 0 224 112 112 0 1 1 0-224z"],
    "circle-notch": [512, 512, [], "f1ce", "M214.8 68.4C128.6 87.3 64 164.1 64 256 64 362 150 448 256 448s192-86 192-192c0-91.9-64.6-168.7-150.8-187.6L310.8 5.9C425.9 31 512 133.4 512 256 512 397.4 397.4 512 256 512S0 397.4 0 256C0 133.4 86.1 31 201.2 5.9l13.7 62.5z"],
    "water": [512, 512, [], "f773", "M136.2 62.2l8.9 3.6 111.1 44.4 111.1-44.4 8.9-3.6 8.9 3.6c83 33.2 125 50 126.3 50.5l-17.8 44.6c-2.7-1.1-41.9-16.7-117.4-46.9l-111.1 44.4-8.9 3.6-8.9-3.6-111.1-44.4c-75.5 30.2-114.7 45.9-117.4 47L1 116.2c1.2-.5 43.3-17.3 126.3-50.5l8.9-3.6zm0 144l8.9 3.6 111.1 44.4 111.1-44.4 8.9-3.6 8.9 3.6c83 33.2 125 50 126.3 50.5l-17.8 44.6c-2.7-1.1-41.9-16.7-117.4-46.9l-111.1 44.4-8.9 3.6-8.9-3.6-111.1-44.4c-75.5 30.2-114.7 45.9-117.4 47L1 260.2c1.2-.5 43.3-17.3 126.3-50.5l8.9-3.6zm8.9 147.6l111.1 44.4 111.1-44.4 8.9-3.6 8.9 3.6c82.9 33.2 125 50 126.3 50.5l-17.8 44.6c-2.7-1.1-41.8-16.7-117.4-46.9l-111.1 44.4-8.9 3.6-8.9-3.6-111.1-44.4c-75.5 30.2-114.7 45.9-117.4 47L1 404.2c1.2-.5 43.3-17.3 126.3-50.5l8.9-3.6 8.9 3.6z"],
    "delete-left": [640, 512, [9003, "backspace"], "f55a", "M576 64l0 384-400 0-176-192 176-192 400 0zM267.1 205.1L318.1 256c-25.5 25.5-42.4 42.4-50.9 50.9l33.9 33.9c8.5-8.5 25.5-25.5 50.9-50.9 25.5 25.5 42.4 42.4 50.9 50.9l33.9-33.9c-8.5-8.5-25.5-25.5-50.9-50.9 25.5-25.5 42.4-42.4 50.9-50.9l-33.9-33.9c-8.5 8.5-25.5 25.5-50.9 50.9l-50.9-50.9-33.9 33.9z"],
    "circle-rupee": [512, 512, [], "e714", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM152 144l48 0c39.8 0 72 32.2 72 72 0 26.9-14.7 50.3-36.5 62.6 14.8 44.3 23.7 71.2 26.8 80.5l-45.5 15.2C214 366 204.4 337.2 188 288l-12 0 0 80-48 0 0-224 24 0zm48 96c13.3 0 24-10.7 24-24s-10.7-24-24-24l-24 0 0 48 24 0zm80 .1c0-31 25.1-56.1 56.1-56.1l63.9 0 0 48-63.9 0c-4.5 0-8.1 3.6-8.1 8.1 0 3.6 2.3 6.7 5.8 7.8L368 258.1c23.7 7.1 40 29 40 53.7 0 31-25.1 56.1-56.1 56.1l-63.9 0 0-48 63.9 0c4.5 0 8.1-3.6 8.1-8.1 0-3.6-2.3-6.7-5.8-7.8L320 293.9c-23.7-7.1-40-29-40-53.7z"],
    "arrow-down-to-square": [448, 512, [], "e096", "M256 0l0-32-64 0 0 274.7c-4-4-14.7-14.7-32-32L114.7 256c8.2 8.2 37.1 37.1 86.6 86.6L224 365.3 333.3 256 288 210.7 256 242.7 256 0zM32 96l-32 0 0 416 448 0 0-416-128 0 0 64 64 0 0 288-320 0 0-288 64 0 0-64-96 0z"],
    "square-b": [448, 512, [], "e264", "M448 32l-448 0 0 448 448 0 0-448zM144 144l92 0c37.6 0 68 30.4 68 68 0 12.7-3.5 24.7-9.6 34.8 15.6 12.5 25.6 31.6 25.6 53.2 0 37.6-30.4 68-68 68l-108 0 0-224zm112 68c0-11-9-20-20-20l-44 0 0 40 44 0c11 0 20-9 20-20zM192 320l60 0c11 0 20-9 20-20s-9-20-20-20l-60 0 0 40z"],
    "broom-ball": [576, 512, ["quidditch", "quidditch-broom-ball"], "f458", "M496 544a80 80 0 1 1 0-160 80 80 0 1 1 0 160zM106.8 277.2c30.6-30.6 73.1-45.9 115.8-42.2L341 353.3c3.7 42.8-11.6 85.2-42.2 115.9-27.4 27.4-64.6 42.8-103.3 42.8l-195.5 0 0-32 160-144-96 48 0-3.5c0-38.8 15.4-75.9 42.8-103.3zM576 48l-200 200 40 40 0 32-51.7 0-108.3-108.3 0-51.7 32 0 40 40 200-200 48 48z"],
    "h6": [512, 512, [], "e413", "M64 64l0 160 96 0 0-160 64 0 0 384-64 0 0-160-96 0 0 160-64 0 0-384 64 0zm320 64c-17.7 0-32 14.3-32 32l0 53.5c10-3.5 20.8-5.5 32-5.5l32 0c53 0 96 43 96 96l0 48c0 53-43 96-96 96l-32 0c-53 0-96-43-96-96l0-192c0-53 43-96 96-96l96 0 0 64-96 0zM352 304l0 48c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-48c0-17.7-14.3-32-32-32l-32 0c-17.7 0-32 14.3-32 32z"],
    "j": [320, 512, [106], "4a", "M320 32l0 288c0 88.4-71.6 160-160 160S0 408.4 0 320l0-64 64 0 0 64c0 53 43 96 96 96s96-43 96-96l0-288 64 0z"],
    "shuttle-space": [576, 512, ["space-shuttle"], "f197", "M0 368l0 112 160 0 186.7-112-93.3 0-106.7 64-2.7 0 0-80 32-16 190.2 0c71.1 0 135.1-23.1 177.8-80-42.7-56.9-106.7-80-177.8-80l-190.2 0-32-16 0-80 2.7 0 106.7 64 93.3 0-186.7-112-160 0 0 336zm96 0l0 64-48 0 0-64 48 0zM96 80l0 64-48 0 0-64 48 0zM432 224l0 64-32 0 0-64 32 0z"],
    "yin-yang": [512, 512, [9775], "f6ad", "M216 160l40-40 40 40-40 40-40-40zm40 352a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm0-448c53 0 96 43 96 96s-43 96-96 96-96 43-96 96 43 96 96 96C150 448 64 362 64 256S150 64 256 64zM216 352l40-40 40 40-40 40-40-40z"],
    "signal-good": [512, 512, ["signal-3"], "f68e", "M280 248l0-24-48 0 0 256 48 0 0-232zM176 320l-48 0 0 160 48 0 0-160zM72 384l-48 0 0 96 48 0 0-96z"],
    "image-stack": [512, 512, [], "e771", "M120-32l-24 0 0 48 320 0 0-48-296 0zM72 64l-24 0 0 48 416 0 0-48-392 0zm440 96l-512 0 0 320 512 0 0-320zM96 224a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM448 416l-320 0 84-112 33.7 44.9 74.3-92.9 128 160z"],
    "stop": [448, 512, [9209], "f04d", "M0 32l448 0 0 448-448 0z"],
    "trowel": [640, 512, [], "e589", "M464 208l-25.4-25.4-136 136 81.4 81.4-48 48-272 64 64-272 48-48 81.4 81.4 136-136-25.4-25.4 160-160 96 96-160 160z"],
    "circle-2": [512, 512, [], "e0ef", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM208 145.3l62 0c36.5 0 66 29.6 66 66 0 27.1-16.6 51.5-41.9 61.4l-44.7 17.6c-12.9 5.1-22.1 16.3-24.6 29.6l103.3 0 0 48-152 0 0-40.4c0-36.2 22.1-68.7 55.8-81.9l44.7-17.6c6.9-2.7 11.4-9.4 11.4-16.8 0-10-8.1-18-18-18l-86 0 0-48 24 0z"],
    "drumstick": [512, 512, [127831], "f6d6", "M160 278.5L160 176C160 78.8 238.8 0 336 0s176 78.8 176 176-78.8 176-176 176l-102.5 0-58.4 58.3c10.4 10.8 16.8 25.5 16.8 41.7 0 33.1-26.9 60-60 60s-60-26.9-60-60l0-12-12 0c-33.1 0-60-26.9-60-60s26.9-60 60-60c16.2 0 30.9 6.4 41.6 16.8L160 278.5z"],
    "square-x": [448, 512, [], "e286", "M448 32l-448 0 0 448 448 0 0-448zM119.7 144l57.9 0 46.4 69 46.4-69 57.8 0-10.4 15.4-65 96.6 65 96.6 10.4 15.4-57.8 0-46.4-69-46.4 69-57.9 0 10.4-15.4 65-96.6-65-96.6-10.4-15.4z"],
    "peapod": [512, 512, [], "e31c", "M512 0L416 0C186.2 0 0 186.2 0 416l0 96 96 0c229.8 0 416-186.2 416-416l0-96zM256 200a56 56 0 1 1 0 112 56 56 0 1 1 0-112zM88 368a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zM368 88a56 56 0 1 1 0 112 56 56 0 1 1 0-112z"],
    "message-text": [512, 512, ["comment-alt-text"], "e1e6", "M0 32l0 416 128 0 0 96 160-96 224 0 0-416-512 0zM184 144l168 0 0 48-72 0 0 144-48 0 0-144-72 0 0-48 24 0z"],
    "hand-back-fist": [384, 512, ["hand-rock"], "f255", "M0 240l0-96 64 0 0-144 96 0 0 16 96 0 0 16 64 0 0 32 64 0 0 160-64 128-256 0-64-112zM32 400l320 0 0 112-320 0 0-112z"],
    "snowman-head": [448, 512, ["frosty-head"], "f79b", "M64 0l320 0 0 160-320 0 0-160zM330.2 192l117.8 0 0 64-57.7 0c16.3 28.2 25.7 61 25.7 96 0 66.8-34.1 125.6-85.8 160l-212.3 0c-51.7-34.4-85.8-93.2-85.8-160 0-35 9.3-67.8 25.7-96l-57.7 0 0-64 330.2 0zM152 336a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm168-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM224 448l27.8-48.7c2.7-4.8 4.2-10.2 4.2-15.7 0-17.5-14.2-31.6-31.6-31.6l-.8 0c-17.5 0-31.6 14.2-31.6 31.6 0 5.5 1.4 10.9 4.2 15.7L224 448z"],
    "blanket": [448, 512, [], "f498", "M0 32l448 0 0 352-352 0 0-48 304 0 0-48-352 0 0 144 400 0 0 48-448 0 0-448z"],
    "comment-xmark": [512, 512, ["comment-times"], "f4b5", "M512 240c0 132.5-114.6 240-256 240-38.3 0-74.7-7.9-107.3-22.1L0 512 55.7 389.5C20.8 348.5 0 296.5 0 240 0 107.5 114.6 0 256 0S512 107.5 512 240zM340.9 189.1l-33.9-33.9c-8.5 8.5-25.5 25.5-50.9 50.9l-50.9-50.9-33.9 33.9c8.5 8.5 25.5 25.5 50.9 50.9-25.5 25.5-42.4 42.4-50.9 50.9l33.9 33.9c8.5-8.5 25.5-25.5 50.9-50.9 25.5 25.5 42.4 42.4 50.9 50.9l33.9-33.9c-8.5-8.5-25.5-25.5-50.9-50.9 25.5-25.5 42.4-42.4 50.9-50.9z"],
    "person-dolly-empty": [512, 512, [], "f4d1", "M120 24A56 56 0 1 0 8 24 56 56 0 1 0 120 24zM32 112L0 112 0 272c0 30.2 14.2 58.7 38.4 76.8l89.6 67.2 0 128 64 0 0-160-12.8-9.6-67.2-50.4 0-80.1c16.7 23.4 27.2 38.1 31.5 44.1l112.5 0 0 162.7c-18.6 6.6-32 24.4-32 45.3 0 26.5 21.5 48 48 48 20.9 0 38.7-13.4 45.3-32l194.7 0 0-48-208 0 0-304-48 0 0 64-79.5 0-70.4-98.6-9.6-13.4-64.5 0zM0 512l0 32 64 0 0-116-54.4-40.8c-3.3-2.5-6.5-5.1-9.6-7.9L0 512z"],
    "signal-slash": [576, 512, [], "f695", "M49.3-16.9l-17-17-33.9 33.9 17 17 512 512 17 17 33.9-33.9c-7.3-7.3-26.7-26.7-58.1-58.1l0-422-48 0 0 374-56-56 0-222-48 0 0 174-318.8-318.8zM312.1 381.8l-48-48 0 146.2 48 0 0-98.2zM208.1 320l-48 0 0 160 48 0 0-160zm-104 64l-48 0 0 96 48 0 0-96z"],
    "hexagon-plus": [576, 512, ["plus-hexagon"], "f300", "M13.5 256.1l6.8-11.9 123.7-216.1 6.9-12.1 275.1 0 6.9 12.1 123.7 216.1 6.8 11.9-6.8 11.9-123.7 216.1-6.9 12.1-275.1 0-6.9-12.1-123.7-216.1-6.8-11.9zM264.5 368l48 0 0-88 88 0 0-48-88 0 0-88-48 0 0 88-88 0 0 48 88 0 0 88z"],
    "temperature-high": [512, 512, [], "f769", "M96 0l192 0 0 260.7c29.5 26.4 48 64.7 48 107.3 0 79.5-64.5 144-144 144S48 447.5 48 368c0-42.6 18.5-81 48-107.3L96 0zm96 432c35.3 0 64-28.7 64-64 0-26.9-16.5-49.9-40-59.3l0-236.7-48 0 0 236.7c-23.5 9.5-40 32.5-40 59.3 0 35.3 28.7 64 64 64zM464 80a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM352 80a80 80 0 1 1 160 0 80 80 0 1 1 -160 0z"],
    "greater-than": [512, 512, [62769], "3e", "M32 14L493.4 227 512 235.5 512 276.5 493.4 285.1 32 498 32 427.5 403.6 256 32 84.5 32 14z"],
    "toothbrush": [576, 512, [129701], "f635", "M0 160c0-35.3 28.7-64 64-64l224 0c37.7 0 40-33.2 40-64 57.4 0 120 31.6 120 96 0 53-43 96-96 96L0 224 0 160zm80 96l0 160 32 0 0-160 48 0 0 160 32 0 0-160 48 0 0 160 32 0 0-160 48 0 0 160 32 0 0-160 48 0 0 160 176 0 0 64-576 0 0-64 32 0 0-160 48 0z"],
    "flute": [576, 512, [], "f8b9", "M498.3 6.1l-33.9-33.9-33.9 33.9-267 267 107.9 107.9 267-267 33.9-33.9C550.6 58.4 526 33.7 498.3 6.1zm-261 408.9L129.5 307c-70.2 70.2-111.9 111.9-125 125 49.9 49.9 95 95 107.9 107.9 13.1-13.1 54.8-54.8 125-125zm51-182.9a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm-168 168a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm232-232a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm88-88a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"],
    "lobster": [512, 512, [129438], "e421", "M80 2l0 94 42.9-57.2c3.3 7.7 5.1 16.2 5.1 25.2l0 64c0 14.9-5.1 28.6-13.6 39.4l36.9 24.6 46.5 0c2.7-7.3 6.2-14 10.2-20.2l0-118.2c-26.2-4.4-43-7.2-50.4-8.4l5.3-31.6 63.8 10.6 13.4 2.2 0 111.6c5.9-4.4 11.4-7.7 16-10 4.6 2.3 10.1 5.6 16 10l0-111.6c3.1-.5 23.6-3.9 61.4-10.2l15.8-2.6 5.3 31.6c-7.4 1.2-24.2 4-50.4 8.4l0 118.2c4 6.2 7.5 13 10.2 20.2l46.5 0 36.9-24.6C389.1 156.6 384 142.9 384 128l0-64c0-8.9 1.8-17.4 5.1-25.2L432 96 432 2c5.1-1.3 10.5-2 16-2 35.3 0 64 28.7 64 64l0 64c0 35.3-28.7 64-64 64l-.7 0-66 44-6 4-55.3 0 0 16 60.2 0c34.8-17.4 54.4-27.2 58.9-29.5l14.3 28.6c-3.9 2-24.7 12.3-62.3 31.2l-3.4 1.7-67.8 0 0 16 77.4 0c35.4-11.8 55.7-18.6 60.7-20.2l10.1 30.4c-4.6 1.5-25.7 8.6-63.2 21.1l-2.5 .8-82.6 0 0 16 35.8 0 35.4 17.7 14.3 7.2-14.3 28.6-42.9-21.5-28.2 0-21.6 64.8c30.4 5 53.6 31.4 53.6 63.2l-192 0c0-31.8 23.2-58.2 53.6-63.2L192 384 163.8 384c-21.5 10.7-35.8 17.9-42.9 21.5l-14.3-28.6c6.6-3.3 22-11 46.3-23.2l3.4-1.7 35.8 0 0-16-82.6 0-2.5-.8c-37.5-12.5-58.5-19.5-63.2-21.1l10.1-30.4c5.1 1.7 25.3 8.4 60.7 20.2l77.4 0 0-16-67.8 0-3.4-1.7c-37.6-18.8-58.4-29.2-62.3-31.2l14.3-28.6 58.9 29.5 60.2 0 0-16-55.3 0-6-4-66-44-.7 0c-35.3 0-64-28.7-64-64L0 64C0 28.7 28.7 0 64 0 69.5 0 74.9 .7 80 2z"],
    "calendar-circle-exclamation": [576, 512, [], "e46e", "M192 32l0-32-64 0 0 64-96 0 0 112 448 0 0-112-96 0 0-64-64 0 0 64-128 0 0-32zM32 480l225.4 0c-11.2-24.4-17.4-51.4-17.4-80 0-78.7 47.4-146.4 115.1-176L32 224 32 480zm400 64a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm16-64l-32 0 0-32 32 0 0 32zm0-176l0 112-32 0 0-112 32 0z"],
    "mobile-rotate": [640, 512, [], "e813", "M602.5 320L384 538.5 37.5 192 256-26.5 602.5 320zM176 416l-55.5 0c4 36 34.5 64 71.5 64 18.3 0 35-6.9 47.8-18.2l34.1 34c-21.4 20-50.2 32.2-81.8 32.2-63.6 0-115.6-49.5-119.7-112l-56.3 0 80-80 80 80zm198-24L408 425.9 489.9 344 456 310.1 374 392zM448-16c63.6 0 115.6 49.5 119.7 112l56.3 0-80 80-80-80 55.5 0c-4-36-34.5-64-71.5-64-18.3 0-35 6.9-47.8 18.2l-34.1-34C387.6-3.7 416.4-16 448-16z"],
    "crutch": [576, 512, [], "f7f7", "M352.3-13.3l22.6 22.6 160 160 22.6 22.6-45.3 45.3-24-24-177.4 177.4-9.4 9.4-112 0C5.1 584.4 107.4 482.1 64.3 525.3L19 480c24.4-24.4 56.2-56.2 125.3-125.3l0-112 9.4-9.4 177.4-177.4-1.4-1.4-22.6-22.6 45.3-45.3zm24 114.5l-82.7 82.7 66.7 66.7 82.7-82.7-66.7-66.7zm-128 128l-40 40 0 66.7 66.7 0 40-40-66.7-66.7z"],
    "command": [512, 512, [], "e142", "M32 208l112 0 0 96-144 0 0 208 208 0 0-144 96 0 0 144 208 0 0-208-144 0 0-96 144 0 0-208-208 0 0 144-96 0 0-144-208 0 0 208 32 0zm224 96l-48 0 0-96 96 0 0 96-48 0zM64 144l0-80 80 0 0 80-80 0zm80 304l-80 0 0-80 80 0 0 80zM368 144l0-80 80 0 0 80-80 0zm80 224l0 80-80 0 0-80 80 0z"],
    "tv-retro": [512, 512, [128250], "f401", "M160-13.3c6.6 6.6 38.6 38.6 96 96 57.4-57.4 89.4-89.4 96-96L397.3 32c-12 12-33.3 33.3-64 64l178.7 0 0 384-512 0 0-384 178.7 0c-30.7-30.7-52-52-64-64L160-13.3zM384 160l-320 0 0 256 320 0 0-256zm88 72a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM448 336a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"],
    "paw-claws": [512, 512, [], "f702", "M256 224c64 0 192 80 192 256L256 432 64 480c0-176 128-256 192-256zM48 160.4c19.3 2.3 39.6 16.2 52.4 38.2 18.9 32.4 14.3 70.1-10.2 84.2s-59.7-.9-78.5-33.3C3.7 235.8 0 221.3 .1 208l-.1-96 48 0 0 48.4zM511.9 208c.1 13.3-3.7 27.8-11.6 41.4-18.9 32.4-54 47.3-78.5 33.3s-29.1-51.7-10.2-84.2c12.8-22 33-35.8 52.4-38.2l0-48.4 48 0-.1 96zM160 32.3c29.8-3 61.6 22 74.5 60.5 14.3 42.9-.3 86.2-32.6 96.8s-70.1-15.6-84.4-58.5c-4-11.9-5.7-23.9-5.4-35.2l-.1-112 48 0 0 48.3zM399.9 96c.2 11.3-1.4 23.2-5.4 35.2-14.3 42.9-52.1 69.1-84.4 58.5s-46.9-53.9-32.6-96.8c12.9-38.6 44.7-63.6 74.5-60.5l0-48.3 48 0-.1 112z"],
    "septagon": [576, 512, ["heptagon"], "e820", "M516.1 67.7L572.4 314.3 414.7 512.1 161.7 512.1 4 314.3 60.3 67.7 288.2-42.1 516.1 67.7z"],
    "face-smile-upside-down": [512, 512, [], "e395", "M256 0a256 256 0 1 0 0 512 256 256 0 1 0 0-512zm0 144c-38.2 0-72 19.1-92.2 48.5l-39.5-27.3C153.1 123.4 201.3 96 256 96s102.9 27.4 131.8 69.2l-39.5 27.3C328 163.1 294.2 144 256 144zM368 304a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM176 336a32 32 0 1 1 0-64 32 32 0 1 1 0 64z"],
    "glass-empty": [384, 512, [], "e191", "M99.2 448l185.6 0 30-384-245.6 0 30 384zM344 512L40 512 0 0 384 0 379 64 344 512z"],
    "ear": [384, 512, [128066], "f5f0", "M384 192c0 76.8-45.1 143-110.2 173.7L208 512 0 512 0 192C0 86 86 0 192 0S384 86 384 192zm-272 0c0-44.2 35.8-80 80-80s80 35.8 80 80l0 32 48 0 0-32c0-70.7-57.3-128-128-128S64 121.3 64 192l0 64 40 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-40 0 0 48 40 0c39.8 0 72-32.2 72-72 0-37.1-28-67.6-64-71.6l0-16.4z"],
    "street-view": [512, 512, [], "f21d", "M256 0a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM224 160l64 0c35.3 0 64 28.7 64 64l0 80-33.8 0-14.2 128-96 0-14.2-128-33.8 0 0-80c0-35.3 28.7-64 64-64zM412.4 400.2c-16.1-4.2-34.8-7.6-55.4-10.2l5.3-47.7c22.7 2.9 43.7 6.7 62.1 11.5 22.4 5.8 42.6 13.3 57.8 23.3 14.7 9.6 29.8 24.9 29.8 47s-15.1 37.4-29.8 47c-15.2 9.9-35.5 17.5-57.8 23.3-45.1 11.7-105.3 17.8-168.4 17.8s-123.3-6.1-168.4-17.8C65.2 488.4 45 480.9 29.8 471 15.1 461.4 0 446.1 0 424s15.1-37.4 29.8-47c15.2-9.9 35.5-17.5 57.8-23.3 18.5-4.8 39.5-8.6 62.1-11.5L155 390c-20.6 2.6-39.3 6.1-55.4 10.2-56.6 14.6-56.6 32.9 0 47.5 39.9 10.3 95.8 16.2 156.4 16.2s116.5-5.9 156.4-16.2c56.6-14.6 56.6-32.9 0-47.5z"],
    "briefs": [512, 512, [], "e6d0", "M512 64l-512 0 0 48 512 0 0-48zM336 160l-160 0 0 37.9c0 42.6-12.6 84.3-36.3 119.8l-17.8 26.7C145.7 372.3 160 408.5 160 448l192 0c0-39.5 14.3-75.7 38.1-103.6l-17.8-26.7C348.6 282.2 336 240.5 336 197.9l0-37.9zm48 0l0 37.9c0 33.2 9.8 65.6 28.2 93.2l14.4 21.6C451.3 297 480.6 288 512 288l0-128-128 0zM0 160L0 288c31.4 0 60.7 9 85.4 24.7l14.4-21.6c18.4-27.6 28.2-60 28.2-93.2l0-37.9-128 0z"],
    "speakers": [448, 512, [], "f8e0", "M448-32l-352 0 0 480 352 0 0-480zM272 184a104 104 0 1 1 0 208 104 104 0 1 1 0-208zm56 104a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zM240 64a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM48 120l0-24-48 0 0 448 352 0 0-48-304 0 0-376z"],
    "wave-square": [512, 512, [], "f83e", "M64 64l224 0 0 320 96 0 0-160 128 0 0 64-64 0 0 160-224 0 0-320-96 0 0 160-128 0 0-64 64 0 0-160z"],
    "angle-left": [320, 512, [8249], "f104", "M19 256l22.6 22.6 160 160 22.6 22.6 45.3-45.3-160-160 137.4-137.4 22.6-22.6-45.3-45.3-22.6 22.6-160 160-22.6 22.6z"],
    "turtle": [576, 512, [128034], "f726", "M384 288l-352 0 0-80c0-97.2 78.8-176 176-176s176 78.8 176 176l0 80zm192 0l-96 0 0 96-128 0 0 96-128 0 0-96-32 0 0 96-128 0 0-96-64 0 0-64 416 0 0-208 64 0c53 0 96 43 96 96l0 80zm-80-64a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"],
    "arrow-right-to-line": [512, 512, [8677, "arrow-to-right"], "f340", "M512 96l0-32-64 0 0 384 64 0 0-352zM374.6 278.6l22.6-22.6-22.6-22.6-128-128-22.6-22.6-45.3 45.3c6.6 6.6 38.6 38.6 96 96L0 224 0 288 274.7 288c-57.4 57.4-89.4 89.4-96 96l45.3 45.3 22.6-22.6 128-128z"],
    "pants-straight": [448, 512, [], "e6d6", "M448 0l-448 0 4 64 124 0 0 48-121 0 25 400 168 0 0-320 48 0 0 320 168 0 25-400-121 0 0-48 124 0 4-64z"],
    "screwdriver": [576, 512, [129691], "f54a", "M352 146.7l0-66.7 144-96 64 64-96 144-66.7 0-109.3 109.3 0 82.7-160 160-128-128 160-160 82.7 0 109.3-109.3z"],
    "traffic-light-stop": [320, 512, [], "f63a", "M320-32l-320 0 0 576 320 0 0-576zM160 360c30.9 0 56 25.1 56 56s-25.1 56-56 56-56-25.1-56-56 25.1-56 56-56zm56-104a56 56 0 1 1 -112 0 56 56 0 1 1 112 0zM160 152a56 56 0 1 1 0-112 56 56 0 1 1 0 112zm24 104a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM160 440c13.3 0 24-10.7 24-24s-10.7-24-24-24-24 10.7-24 24 10.7 24 24 24z"],
    "square-euro": [448, 512, [], "e732", "M448 32l-448 0 0 448 448 0 0-448zM128.2 240l-24.2 0 0-32 32.1 0c19.6-51.5 69.5-88 127.8-88l57 0 0 48-57 0c-31 0-58.3 15.9-74.2 40l66.3 0 0 32-79.3 0c-1 5.4-1.6 11-1.6 16.8 0 5.2 .4 10.3 1.3 15.2l79.5 0 0 32-67.2 0c15.7 24.9 43.5 41.5 75.2 41.5l57 0 0 48-57 0c-58.9 0-109.1-37.3-128.4-89.5l-31.5 0 0-32 24 0c-.6-5-.8-10.1-.8-15.2 0-5.7 .3-11.3 1-16.8z"],
    "tractor": [576, 512, [128668], "f722", "M235.8 96l57.6 96-133.4 0 0-96 75.8 0zm64.7 288l101.2 0c-6.1 12-9.6 25.6-9.6 40 0 48.6 39.4 88 88 88s88-39.4 88-88c0-32.7-17.8-61.2-44.3-76.4l52.3-43.6 0-112-96 0 0-96-48 0 0 96-64 0-96-160-176 0 0 191c-1.9 .9-3.7 1.9-5.6 2.9l-15.3-15.3-56.6 56.6 15.3 15.3c-5.1 9.3-9.3 19.2-12.3 29.6l-21.6 0 0 80 21.6 0c3 10.4 7.1 20.3 12.3 29.6l-15.3 15.3 56.6 56.6 15.3-15.3c9.3 5.1 19.2 9.3 29.6 12.3l0 21.6 80 0 0-21.6c10.4-3 20.3-7.1 29.6-12.3l15.3 15.3 56.6-56.6-15.3-15.3c6.4-11.6 11.3-24.2 14.3-37.6zM160 416a64 64 0 1 1 0-128 64 64 0 1 1 0 128zm360 8a40 40 0 1 1 -80 0 40 40 0 1 1 80 0z"],
    "bridge-circle-xmark": [576, 512, [], "e4cb", "M32 32l-32 0 0 64 40 0 0 64-40 0 0 112c37.6 9.4 64 43.2 64 82l0 126 96 0 0-96c0-53 43-96 96-96 6.4 0 12.7 .6 18.7 1.8 34.7-49.5 92.2-81.8 157.3-81.8 28.6 0 55.6 6.2 80 17.4l0-65.4-40 0 0-64 40 0 0-64-480 0zM424 96l0 64-80 0 0-64 80 0zM296 96l0 64-80 0 0-64 80 0zM88 96l80 0 0 64-80 0 0-64zM432 544a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm55.3-176.7L454.6 400c25.4 25.3 40 40 44 44L476 466.6c-4-4-18.6-18.6-44-44-25.3 25.4-40 40-44 44L365.4 444c4-4 18.6-18.6 44-44-25.4-25.3-40-40-44-44L388 333.4c4 4 18.6 18.6 44 44 25.3-25.4 40-40 44-44l22.6 22.6-11.3 11.3z"],
    "vials": [512, 512, [], "f493", "M32 0L0 0 0 64 32 64 32 416c0 53 43 96 96 96s96-43 96-96l0-352 64 0 0 352c0 53 43 96 96 96s96-43 96-96l0-352 32 0 0-64-480 0zM160 64l0 128-64 0 0-128 64 0zm256 0l0 128-64 0 0-128 64 0z"],
    "starfighter-twin-ion-engine-advanced": [576, 512, ["starfighter-alt-advanced"], "e28e", "M424.5 53.7l-21.7-23.5 47-43.4c2.1 2.3 41.3 44.8 117.7 127.5l8.5 9.2 0 247.7-7 8.8c-76.7 95.8-115.3 144.2-116 145l-50-40c1.8-2.3 38.2-47.7 109-136.2l0-48-75.6 15.1C412.7 374.6 355.2 416 288 416S163.3 374.6 139.6 315.9L64 300.8 64 356.2C134.1 438 170.5 480.4 173.1 483.5l-48.6 41.6c-1.4-1.6-40.3-47-116.8-136.3l-7.7-9 0-247.7 7.7-9C84.2 33.9 123.2-11.5 124.5-13.1l48.6 41.7c-2.6 3.1-39 45.5-109.1 127.3l0 55.4 75.6-15.1C163.3 137.4 220.8 96 288 96s124.7 41.4 148.4 100.1l75.6 15.1 0-62.7-87.5-94.8zM288 352a96 96 0 1 0 0-192 96 96 0 1 0 0 192zm0-152a56 56 0 1 1 0 112 56 56 0 1 1 0-112z"],
    "stethoscope": [576, 512, [129658], "f0f1", "M32 0l128 0 0 64-64 0 0 128c0 53 43 96 96 96s96-43 96-96l0-128-64 0 0-64 128 0 0 192c0 77.4-55 142-128 156.8l0 19.2c0 61.9 50.1 112 112 112s112-50.1 112-112l0-85.5c-37.3-13.2-64-48.7-64-90.5 0-53 43-96 96-96s96 43 96 96c0 41.8-26.7 77.4-64 90.5l0 85.5c0 97.2-78.8 176-176 176S160 465.2 160 368l0-19.2C87 334 32 269.4 32 192L32 0zM480 224a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "podcast": [448, 512, [], "f2ce", "M334 361.4c40.2-32.3 66-81.8 66-137.4 0-97.2-78.8-176-176-176S48 126.8 48 224c0 55.6 25.8 105.1 66 137.4l8.9 62.6C50 387 0 311.4 0 224 0 100.3 100.3 0 224 0S448 100.3 448 224c0 87.4-50 163-122.9 200l8.9-62.6zm-13.4-53.4l-27.1-33.9-3.6-4.6c8.9-12.9 14.2-28.6 14.2-45.5 0-44.2-35.8-80-80-80s-80 35.8-80 80c0 16.9 5.2 32.6 14.2 45.5l-3.6 4.6-27.1 33.9C107.8 285.5 96 256.1 96 224 96 153.3 153.3 96 224 96s128 57.3 128 128c0 32.1-11.8 61.5-31.4 83.9zM160 344l32-40 64 0 32 40-24 168-80 0-24-168zm64-160a40 40 0 1 1 0 80 40 40 0 1 1 0-80z"],
    "arrow-up-right-dots": [576, 512, [], "e4b7", "M128.3 32l-32 0 0 64 50.7 0C63 180 20.3 222.7 19 224l45.3 45.3c1.3-1.3 44-44 128-128l0 50.7 64 0 0-160-128 0zM436.1 70.1a38.1 38.1 0 1 0 76.2 0 38.1 38.1 0 1 0 -76.2 0zM311.9 194.2a38.1 38.1 0 1 0 76.2 0 38.1 38.1 0 1 0 -76.2 0zm162.2-38.1a38.1 38.1 0 1 0 0 76.2 38.1 38.1 0 1 0 0-76.2zM188.4 317.8a38.1 38.1 0 1 0 76.2 0 38.1 38.1 0 1 0 -76.2 0zM350 279.7a38.1 38.1 0 1 0 0 76.2 38.1 38.1 0 1 0 0-76.2zm86.1 38.1a38.1 38.1 0 1 0 76.2 0 38.1 38.1 0 1 0 -76.2 0zM102.3 403.8a38.1 38.1 0 1 0 0 76.2 38.1 38.1 0 1 0 0-76.2zm86.1 38.1a38.1 38.1 0 1 0 76.2 0 38.1 38.1 0 1 0 -76.2 0zM350 403.8a38.1 38.1 0 1 0 0 76.2 38.1 38.1 0 1 0 0-76.2zm86.1 38.1a38.1 38.1 0 1 0 76.2 0 38.1 38.1 0 1 0 -76.2 0z"],
    "chess-queen": [512, 512, [9819], "f445", "M256 80a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM96 160l-96-32 0 48 128 208-64 80 0 48 384 0 0-48-64-80 128-208 0-48-96 32-80-64-80 64-80-64-80 64z"],
    "anchor-circle-exclamation": [640, 512, [], "e4ab", "M320 96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM288 0c-53 0-96 43-96 96 0 41.8 26.7 77.4 64 90.5l0 261.5-112 0 0-140.1c10.5 9.2 21.9 19.2 34.3 30l31.6-36.1c-4.4-3.8-31.7-27.8-82.1-71.8L112 216.1c-2.5 2.2-29.1 25.5-79.8 69.8l-18.1 15.8 31.6 36.1c12.4-10.8 23.8-20.8 34.3-30l0 204.1 260 0c-22.7-31.5-36-70.2-36-112 0-27.3 5.7-53.3 16-76.9l0-136.6c37.3-13.2 64-48.7 64-90.5 0-53-43-96-96-96zM496 544a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm16-64l-32 0 0-32 32 0 0 32zm0-176l0 112-32 0 0-112 32 0z"],
    "ellipsis-vertical": [128, 512, ["ellipsis-v"], "f142", "M120 32l-112 0 0 112 112 0 0-112zM8 200l0 112 112 0 0-112-112 0zM8 368l0 112 112 0 0-112-112 0z"],
    "acorn": [448, 512, [], "f6ae", "M399.6 240C395.4 320.1 358.7 435.1 224 480 89.3 435.1 52.6 320.1 48.4 240l351.1 0zM273.4 28.7L259.7 48.4c-3.3 4.8-6 10.1-7.9 15.6L352 64c53 0 96 43 96 96l0 32-448 0 0-32c0-53 43-96 96-96l106.2 0c3-15.3 9.2-29.9 18.1-42.9l13.7-19.8 39.5 27.3z"],
    "ban-parking": [512, 512, ["parking-circle-slash"], "f616", "M412.5 367.2L342.3 297c20.6-17.6 33.7-43.8 33.7-73 0-53-43-96-96-96l-106.7 0-28.5-28.5c31.4-22.4 69.8-35.5 111.2-35.5 106 0 192 86 192 192 0 41.5-13.1 79.9-35.5 111.2zm-45.3 45.3c-31.4 22.4-69.8 35.5-111.2 35.5-106 0-192-86-192-192 0-41.5 13.1-79.9 35.5-111.2l68.5 68.5 0 170.7 64 0 0-64 42.7 0 92.5 92.5zM296.6 251.4L237.3 192 280 192c17.7 0 32 14.3 32 32 0 11.6-6.2 21.7-15.4 27.4zM256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512z"],
    "square-dong": [448, 512, [], "e70f", "M448 32l-448 0 0 448 448 0 0-448zM240 112l48 0 0 32 32 0 0 32-32 0 0 176-48 0 0-6.7c-9.8 4.3-20.6 6.7-32 6.7-44.2 0-80-35.8-80-80s35.8-80 80-80c11.4 0 22.2 2.4 32 6.7l0-22.7-48 0 0-32 48 0 0-32zM208 240a32 32 0 1 0 0 64 32 32 0 1 0 0-64zM112 376l224 0 0 32-224 0 0-32z"],
    "list-dropdown": [448, 512, [], "e1cf", "M448 32l0 144-448 0 0-144 448 0zM0 480l0-256 448 0 0 256-448 0zM120 280l-24 0 0 48 256 0 0-48-232 0zm0 96l-24 0 0 48 256 0 0-48-232 0zM312 80l-38.6 0c44.2 44.2 60.1 60.1 62.6 62.6 12.2-12.2 52.1-52.1 62.6-62.6L312 80z"],
    "camera-circle-ellipsis": [640, 512, [], "e766", "M224 32l-32 64-128 0 0 384 257.4 0c-11.2-24.4-17.4-51.4-17.4-80 0-5.8 .3-11.5 .8-17.2-45.8-7.3-80.8-47-80.8-94.8 0-53 43-96 96-96 33 0 62.1 16.7 79.4 42 28.4-16.6 61.4-26 96.6-26 28.6 0 55.6 6.2 80 17.4l0-129.4-128 0-32-64-192 0zM640 400a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zM479.3 384l32 0 0 32-32 0 0-32zM448 384l0 32-32 0 0-32 32 0zm96 0l32 0 0 32-32 0 0-32z"],
    "family-dress": [512, 512, [], "e301", "M128 128a64 64 0 1 0 0-128 64 64 0 1 0 0 128zM64 512l96 0 0-64-32 0 0-240 37.5 0c-3.5-10-5.5-20.8-5.5-32 0-5.5 .5-10.8 1.3-16l-97.3 0-64 224 64 0 0 128zm384 0l0-128 64 0-64-224-97.3 0c.9 5.2 1.3 10.5 1.3 16 0 11.2-1.9 22-5.5 32l37.5 0 0 240-32 0 0 64 96 0zM384 128a64 64 0 1 0 0-128 64 64 0 1 0 0 128zM256 224a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm80 176l0-144-160 0 0 144 32 0 0 112 96 0 0-112 32 0z"],
    "podium": [448, 512, [], "f680", "M176 0L288 0c26.5 0 48 21.5 48 48s-21.5 48-48 48l-112 0 0-24-48 0 0 72 304 0 0 48-416 0 0-48 64 0 0-120 96 0 0-24zM80 512l-23.7-272 335.3 0-23.7 272-288 0z"],
    "robot-astromech": [512, 512, [], "e2d2", "M128 128l0 32 256 0 0-32C384 57.3 326.7 0 256 0S128 57.3 128 128zm96-64a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm64 48a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM0 512l128 0 0-128 64 64 128 0 64-64 0 128 128 0 0-32-48-64 0-224-416 0 0 224-48 64 0 32zM208 256l112 0 0 32-128 0 0-32 16 0zm0 64l112 0 0 32-128 0 0-32 16 0z"],
    "heart-circle-exclamation": [576, 512, [], "e4fe", "M133.1 32C175.8 32 216 52.5 241 87.1l15 20.7 15-20.7c25-34.6 65.2-55.1 107.9-55.1 73.5 0 133.1 59.6 133.1 133.1 0 19.2-3 38.1-8.5 56.6-22.1-8.9-46.2-13.8-71.5-13.8-106 0-192 86-192 192 0 33 8.3 64 23 91.2-2.4 1.6-4.7 3.3-7 4.8-102.5-70.7-256-194.1-256-330.9 0-73.5 59.6-133.1 133.1-133.1zM432 256a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm16 224l0-32-32 0 0 32 32 0zm0-176l-32 0 0 112 32 0 0-112z"],
    "building-circle-exclamation": [576, 512, [], "e4d3", "M416 0l-384 0 0 512 244 0c-10.5-14.6-19-30.7-25.1-48l-74.9 0 0-112 70 0c6-23.3 16.3-45 30-64l-20 0 0-64 64 0 0 20c27.5-19.8 60.3-32.4 96-35.4L416 0zM128 96l64 0 0 64-64 0 0-64zm192 0l0 64-64 0 0-64 64 0zM128 224l64 0 0 64-64 0 0-64zM432 544a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm16-240l0 112-32 0 0-112 32 0zm0 176l-32 0 0-32 32 0 0 32z"],
    "person-arrow-up-from-line": [640, 512, [], "e539", "M621.5 80C616 74.5 581.8 40.3 518.9-22.6L496.3-45.3c-5.5 5.5-39.7 39.7-102.6 102.6L371 80 416.3 125.3c14.6-14.6 30.6-30.6 48-48l0 178.7 64 0 0-178.7c17.4 17.4 33.4 33.4 48 48L621.5 80zM224.2 80a56 56 0 1 0 0-112 56 56 0 1 0 0 112zm-51.1 32l-16.3 0-9.6 13.2-92.9 128-18.8 25.9 51.8 37.6c9.3-12.8 28.3-39 56.9-78.4l0 241.7-112 0 0 64 576 0 0-64-304 0 0-241.7c28.6 39.4 47.6 65.6 56.9 78.4l51.8-37.6-18.8-25.9-92.9-128-9.6-13.2-118.5 0zm67.1 368l-32 0 0-144 32 0 0 144z"],
    "circle-arrow-down-left": [512, 512, [], "e0f9", "M256 512a256 256 0 1 1 0-512 256 256 0 1 1 0 512zm40-208l-54.1 0 103-103 17-17-33.9-33.9-17 17-103 103 0-78.1-48 0 0 160 160 0 0-48-24 0z"],
    "not-equal": [448, 512, [], "f53e", "M100.2 384l-62.8 94.2-1.2 1.8 76.9 0 64-96 270.9 0 0-64-228.2 0 85.3-128 142.9 0 0-64-100.2 0 62.8-94.2 1.2-1.8-76.9 0-64 96-270.9 0 0 64 228.2 0-85.3 128-142.9 0 0 64 100.2 0z"],
    "binary-circle-check": [576, 512, [], "e33c", "M288 0l112 0 0 160 48 0 0 48.7c-5.3-.4-10.6-.7-16-.7-27.3 0-53.3 5.7-76.9 16l-67.1 0 0-64 48 0 0-96-48 0 0-64zM64 288l112 0 0 160 48 0 0 64-160 0 0-64 48 0 0-96-48 0 0-64zM96 0l160 0 0 224-192 0 0-224 32 0zm32 160l64 0 0-96-64 0 0 96zM288 400a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm214.4-51.5l-25.9-18.8-9.4 12.9-53 72.9C393.7 395 381 382.3 376 377.4L353.4 400c2.8 2.8 19.9 19.9 51.3 51.3l13.2 13.2 11-15.1 64-88 9.4-12.9z"],
    "train-tram": [384, 512, [128650], "e5b4", "M24-16l-24 0 0 80 48 0 0-32 120 0 0 64-136 0 0 352 34.1 0C26.7 497.2 6.2 522.8 4.5 525l61.5 0 61.6-77 129 0 61.6 77 61.5 0c-1.7-2.2-22.3-27.8-61.6-77l34 0 0-352-136 0 0-64 120 0 0 32 48 0 0-80-360 0zM288 160l0 96-192 0 0-96 192 0zM96 352a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm160-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "plane-departure": [640, 512, [128747], "f5b0", "M404 143.1l-211.8-110.2-75.2 27.4 115.3 145.3-100.2 36.5-70-42.6-45.1 16.4 90.3 154.4 63.1-23 0 0 398.4-145c29.1-10.6 44-42.7 33.5-71.8s-42.7-44-71.8-33.5L404 143.1zM64.3 448l-32 0 0 64 576 0 0-64-544 0z"],
    "microphone-stand": [512, 512, [127908], "f8cb", "M290.2 52.3c46.9-46.9 122.8-46.9 169.7 0s46.9 122.8 0 169.7l-4.6 4.6-169.7-169.7 4.6-4.6zM257.3 85.3L427 255 420.3 261.6c-21.6 21.6-49.8 32.5-78.1 32.8L217.8 170.1c.3-28.3 11.2-56.5 32.8-78.1l6.7-6.7zM7.5 414.2l184.5-202.1 108.1 108.1-19.8 18.1 0 205.7-48 0 0-161.8-134.4 122.7-90.4-90.6z"],
    "shop-24": [640, 512, [], "e79a", "M16 256l0-64 80-160 384 0 80 160 0 64-48 0 0 48-64 0 0-48-96 0 0 48-64 0 0-48-160 0 0 128 176 0 0 96-240 0 0-224-48 0zM348 400c0-28.7 23.3-52 52-52s52 23.3 52 52l0 1c0 14.6-5.4 28.7-15 39.6l-31.5 35.5 46.6 0 0 40-104 0 0-35.6 5.1-5.7 54-60.8c3.2-3.6 4.9-8.2 4.9-13l0-1c0-6.6-5.4-12-12-12s-12 5.4-12 12l-40 0zm128 32l0-80 40 0 0 60 24 0 0-60 40 0 0 160-40 0 0-60-64 0 0-20z"],
    "brightness": [512, 512, [], "e0c9", "M288 32l0-32-64 0 0 112 64 0 0-80zM118.6 73.4L96 50.7 50.7 96c32.4 32.4 72.2 72.2 77.3 77.3L173.3 128c-13.5-13.5-31.7-31.7-54.6-54.6zm320 45.3L461.3 96 416 50.7c-32.4 32.4-72.2 72.2-77.3 77.3l45.3 45.3 54.6-54.6zM32 224l-32 0 0 64 112 0 0-64-80 0zm448 0l-80 0 0 64 112 0 0-64-32 0zM150.6 406.6L173.3 384 128 338.7C95.6 371.1 55.8 410.9 50.7 416L96 461.3c13.5-13.5 31.7-31.7 54.6-54.6zm256-45.3l-22.6-22.6-45.3 45.3 77.3 77.3 45.3-45.3-54.6-54.6zM288 480l0-80-64 0 0 112 64 0 0-32zM256 352a96 96 0 1 0 0-192 96 96 0 1 0 0 192z"],
    "right-to-bracket": [512, 512, ["sign-in-alt"], "f2f6", "M344.5 273.4L363 256 344.5 238.6C231.2 131.6 169.7 73.5 160 64.3l0 127.7-160 0 0 128 160 0 0 127.7c9.7-9.2 71.2-67.3 184.5-174.2zM352 416l-32 0 0 64 192 0 0-448-192 0 0 64 128 0 0 320-96 0z"],
    "sd-card": [384, 512, [], "f7c2", "M384 0l-285.3 0-9.4 9.4-80 80-9.4 9.4 0 413.3 384 0 0-512zM160 88l0 72-48 0 0-96 48 0 0 24zm88 0l0 72-48 0 0-96 48 0 0 24zm88 0l0 72-48 0 0-96 48 0 0 24z"],
    "dot": [128, 512, [], "e7d1", "M128 320l-128 0 0-128 128 0 0 128z"],
    "house-circle-exclamation": [640, 512, [], "e50a", "M496 208c11.7 0 23.1 1 34.2 3l-242.2-227-256 240 0 48 48 0 0 240 260 0c-10.5-14.6-19-30.7-25.1-48l-90.9 0 0-144 97.4 0c30.3-66.1 97.1-112 174.6-112zm0 336a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm16-240l0 112-32 0 0-112 32 0zm0 176l-32 0 0-32 32 0 0 32z"],
    "shekel-sign": [448, 512, [8362, "ils", "shekel", "sheqel", "sheqel-sign"], "f20b", "M32 32l-32 0 0 448 64 0 0-384 128 0c35.3 0 64 28.7 64 64l0 192 64 0 0-192c0-70.7-57.3-128-128-128L32 32zM320 480c70.7 0 128-57.3 128-128l0-320-64 0 0 320c0 35.3-28.7 64-64 64l-128 0 0-256-64 0 0 320 192 0z"],
    "square-u": [448, 512, [], "e281", "M448 32l-448 0 0 448 448 0 0-448zM176 168l0 104c0 26.5 21.5 48 48 48s48-21.5 48-48l0-128 48 0 0 128c0 53-43 96-96 96s-96-43-96-96l0-128 48 0 0 24z"],
    "truck-container-empty": [640, 512, [], "e2b5", "M448 128l-32 0 0 208-416 0 0 88c0 48.6 39.4 88 88 88 25.2 0 48-10.6 64-27.6 16 17 38.8 27.6 64 27.6 40.3 0 74.2-27.1 84.7-64l118.6 0c10.4 36.9 44.4 64 84.7 64s74.2-27.1 84.7-64l51.3 0 0-237.3-9.4-9.4-64-64-9.4-9.4-109.3 0zM576 288l-96 0 0-96 50.7 0 45.3 45.3 0 50.7zM88 384a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm376 40a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zM216 384a40 40 0 1 1 0 80 40 40 0 1 1 0-80z"],
    "user-pilot-tie": [448, 512, [], "e2c1", "M48 48l0-32 176-48 176 48 0 32-32 19.2 0 44.8s-5.8 2.8-16 6.7l0 25.3c0 70.7-57.3 128-128 128S96 214.7 96 144l0-25.3c-10.2-3.9-16-6.7-16-6.7L80 67.2 48 48zm176 96c-29.1 0-56.8-4.6-80-10.3l0 10.3c0 44.2 35.8 80 80 80s80-35.8 80-80l0-10.3c-23.2 5.7-50.9 10.3-80 10.3zm48 184l-31.6 36.9 31 115.1 .6 0 40-160 56 0 64 192-416 0 64-192 56 0 40 160 31.4-115.3-31.4-36.7 0-24 96 0 0 24zM168.8 26.5L154.5 55.2c3.9 2 24.7 12.3 62.3 31.2l7.2 3.6 7.2-3.6c37.6-18.8 58.4-29.2 62.3-31.2L279.2 26.5c-5.1 2.6-23.5 11.8-55.2 27.6-31.6-15.8-50-25-55.2-27.6zM336 416l-16 0 0 32 48 0 0-32-32 0z"],
    "radio": [512, 512, [128251], "f8d7", "M494.3 15.2l23.2-6-12-46.5-23.2 6-464 120-18 4.7 0 386.6 512 0 0-384-330.3 0 312.3-80.8zM368.2 208a80 80 0 1 1 0 160 80 80 0 1 1 0-160zm-304 16l160 0 0 48-160 0 0-48zm0 96l160 0 0 48-160 0 0-48z"],
    "hand-dots": [512, 512, ["allergies"], "f461", "M288.2 32l0-32-64 0 0 256-32 0 0-224-64 0 0 304c0 1.5 0 3.1 .1 4.6-31.5-30-55.7-53-72.6-69.1L.5 329.4c8.2 7.8 49.7 47.4 124.5 118.6 43.1 41.1 100.4 64 160 64l19.2 0c97.2 0 176-78.8 176-176l0-240-64 0 0 160-32 0 0-224-64 0 0 224-32 0 0-224zm-88 320a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm120-56a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm40 88a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm-88 24a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"],
    "pencil-line": [640, 512, [], "e74f", "M70.1 512.3L16 527.4c5.8-20.7 24.5-87.4 56-200L261.1 138.3 295 104.4c15.6 15.6 52.3 52.3 110.1 110.1L439 248.4 405.1 282.3 216 471.4 70.1 512.3zm45.8-160.9l-1.1 1-29.6 105.7 105.7-29.6 1.1-1 0-28.1-48 0 0-48-28.1 0zM473 214.5c-15.6-15.6-52.3-52.3-110.1-110.1L329 70.5c53.4-53.4 60.2-60.2 87-87 15.6 15.6 52.3 52.3 110.1 110.1L560 127.4c-53.4 53.4-60.2 60.2-87 87zM312 464l296 0 0 48-320 0 0-48 24 0z"],
    "hand-shaka": [576, 512, [], "e831", "M102.8 45.5l24 88 1.4 5.2 0 18.8-42.5 42.5 68 68-16 16 90.5 90.5 16-16 68 68 47.8-47.8 .1 .1 168.1-168 45.3 45.2-201.4 201.4c-35 35-82.4 54.6-131.9 54.6s-96.9-19.7-131.9-54.6l-2.8-2.8c-36.7-36.7-57.4-86.6-57.4-138.5l0-166.7C31.2 86.8 20.1 46.3 15.1 27.9L92.3 6.9 102.8 45.5zM421.5 272L312.3 381.3 267 336 376.3 226.8 421.5 272zm-64-72L228.3 329.3 183 284 312.3 154.8 357.5 200zm-72-64L176.3 245.2 131 200 240.3 90.8 285.5 136z"],
    "flask-gear": [576, 512, [], "e5f1", "M0 448l128-224 0-160-32 0 0-64 256 0 0 64-32 0 0 153.5-36.5-21.1-23.8 42.5-2.4 4.3-1.3-2.2 0-177-64 0 0 177c-.9 1.6-16 27.9-45.1 79l67.5 0-.2 .4-22.4 40 37.7 23.5-37.7 23.4c12.6 22.6 32.1 57.5 58.5 104.8L0 512 0 448zM368.2 223.9l96 0 0 41.4c11.1 4.5 21.4 10.5 30.7 17.8l35.9-20.7 45.3 81.5-33.4 20.9c.9 6.3 1.4 12.7 1.4 19.2 0 6.5-.5 12.9-1.4 19.1l33.4 20.8-45.3 81.7-35.9-20.7c-9.3 7.3-19.6 13.3-30.7 17.8l0 41.4-96 0 0-41.2c-11.2-4.5-21.5-10.5-30.9-17.8l-35.7 20.6-45.6-81.7 33.4-20.7c-.9-6.3-1.4-12.7-1.4-19.2 0-6.5 .5-13 1.4-19.3l-33.4-20.8 45.6-81.5 35.7 20.6c9.3-7.3 19.7-13.3 30.9-17.8l0-41.2zm99.9 160.2a52 52 0 1 0 -104 0 52 52 0 1 0 104 0z"],
    "book-skull": [448, 512, ["book-dead"], "f6b7", "M0 0l448 0 0 384-32 0 0 64 32 0 0 64-448 0 0-512zM64 416l0 32 288 0 0-64-256 0c-17.7 0-32 14.3-32 32zM272 163.2c19.4-11.7 32-30.3 32-51.2 0-35.3-35.8-64-80-64s-80 28.7-80 64c0 20.9 12.6 39.5 32 51.2l0 28.8 96 0 0-28.8zM176 112a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm80-16a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm65.9 109.5c-1.9 .9-34.5 15.7-97.9 44.5-63.4-28.8-96-43.7-97.9-44.5l-16.6 36.4c7.2 3.3 29.2 13.3 66.2 30.1-36.9 16.8-59 26.8-66.2 30.1l16.6 36.4c1.9-.9 34.5-15.7 97.9-44.5 63.4 28.8 96 43.7 97.9 44.5l16.6-36.4c-7.2-3.3-29.2-13.3-66.2-30.1 36.9-16.8 59-26.8 66.2-30.1l-16.6-36.4z"],
    "unlock-keyhole": [384, 512, ["unlock-alt"], "f13e", "M192 32c-35.3 0-64 28.7-64 64l0 64 256 0 0 352-384 0 0-352 64 0 0-64c0-70.7 57.3-128 128-128 63.5 0 116.1 46.1 126.2 106.7l5.3 31.6-63.1 10.6-5.3-31.6C250 55.1 223.7 32 192 32zm40 328l24 0 0-48-128 0 0 48 104 0z"],
    "truck-ramp": [576, 512, [], "f4e0", "M320.3 32l256 0 0 392c0 48.6-39.4 88-88 88s-88-39.4-88-88c0-2.7 .1-5.4 .4-8l-43.7 0-315.5 94.6-30.7 9.2-18.4-61.3 30.7-9.2 297.2-89.2 0-328.2zm208 391.9c-.1-22-17.9-39.9-40-39.9-22.1 0-40 17.9-40 40s17.9 40 40 40 40-17.9 40-40l0-.1z"],
    "envelope-dot": [576, 512, ["envelope-badge"], "e16f", "M496 0a80 80 0 1 1 0 160 80 80 0 1 1 0-160zM368 80c0 56.9 37.1 105 88.3 121.7l-149.1 111.9-19.2 14.4-19.2-14.4-224-168-12.8-9.6 0-72 337 0c-.7 5.2-1 10.6-1 16zM336 352L536.9 201.3c2.4-.8 4.8-1.7 7.1-2.6l0 249.3-512 0 0-252 256 192 48-36z"],
    "house-heart": [512, 512, ["home-heart"], "f4c9", "M512 272l-48 0 0 240-416 0 0-240-48 0 0-48 256-240 256 240 0 48zM249.6 247.5c-11.1-14.8-28.5-23.5-46.9-23.5-32.4 0-58.7 26.3-58.7 58.7l0 5.3c0 64 112 128 112 128s112-64 112-128l0-5.3c0-32.4-26.3-58.7-58.7-58.7-18.5 0-35.9 8.7-46.9 23.5l-6.4 8.5-6.4-8.5z"],
    "file-arrow-up": [384, 512, ["file-upload"], "f574", "M0 0L240 0 384 144 384 512 0 512 0 0zM208 58.5L208 176 325.5 176 208 58.5zM209 263l-17-17c-3.5 3.5-30.5 30.5-81 81l-17 17 33.9 33.9c10.3-10.3 23.6-23.6 40-40l0 110.1 48 0 0-110.1c16.4 16.4 29.7 29.7 40 40L289.9 344c-3.5-3.5-30.5-30.5-81-81z"],
    "game-console-handheld": [384, 512, [], "f8bb", "M0 0L384 0 384 512 0 512 0 0zM96 64l0 160 192 0 0-160-192 0zM232 384a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm88-72a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM96 288l0 32-32 0 0 32 32 0 0 32 32 0 0-32 32 0 0-32-32 0 0-32-32 0z"],
    "face-grin-tears": [640, 512, [128514, "grin-tears"], "f588", "M543.8 380.3C500.1 458.9 416.3 512 320 512S139.9 458.9 96.2 380.3c24.1-13.5 41.6-37.8 45.7-66.8 6.8-47.8 12.6-88 17.2-120.7-37.8 5.4-67.8 9.7-90.2 12.9 23.4-117.3 126.9-205.7 251.1-205.7S547.7 88.4 571.1 205.7c-22.4-3.2-52.5-7.5-90.2-12.9 4.7 32.7 10.4 72.9 17.2 120.7 4.1 29 21.6 53.2 45.8 66.8zm-66.2-81C432.4 317.4 378.2 328 320 328s-112.4-10.6-157.7-28.7C175.3 374.7 240.9 432 320 432s144.7-57.3 157.7-132.7zM212 208c0-15.5 12.5-28 28-28s28 12.5 28 28l0 28 40 0 0-28c0-37.6-30.4-68-68-68s-68 30.4-68 68l0 28 40 0 0-28zm188-28c15.5 0 28 12.5 28 28l0 28 40 0 0-28c0-37.6-30.4-68-68-68s-68 30.4-68 68l0 28 40 0 0-28c0-15.5 12.5-28 28-28zM640 300.6c0 28.4-23 51.4-51.4 51.4-25.6 0-47.3-18.8-50.9-44.1l-9.7-67.9 67.9 9.7c25.3 3.6 44.1 25.3 44.1 50.9zm-640 0c0-25.6 18.8-47.3 44.1-50.9l67.9-9.7-9.7 67.9C98.7 333.2 77 352 51.4 352 23 352 0 329 0 300.6z"],
    "pen-to-square": [576, 512, ["edit"], "f044", "M176 272l-16 112 112-16 191-191-96-96-191 191zM560 80l-96-96-63 63 96 96 63-63zM64 64l-32 0 0 448 448 0 0-224-64 0 0 160-320 0 0-320 160 0 0-64-192 0z"],
    "earth-europe": [512, 512, ["globe-europe"], "f7a2", "M454 320l-22 0-48-48 0-80 32 0 0-32-64 0 0 48-96 0 0 32-64 0 0-32 80-80 0-16-48 0 0-32 32-32c114.9 0 208 93.1 208 208 0 22.3-3.5 43.8-10 64zm-13.4 32C408.2 414.1 345.4 457.8 272 463.4l0-31.4-64 0-48-48 0-112 144 0 48 48 32 0 32 32 24.6 0zM256 512l26.2-1.3c-8.6 .9-17.3 1.3-26.2 1.3zm26.2-1.3C411.3 497.6 512 388.6 512 256 512 114.6 397.4 0 256 0l0 0C114.6 0 0 114.6 0 256 0 383.5 93.2 489.3 215.3 508.8 228.5 510.9 242.1 512 256 512zM187.3 123.3c-24.8 24.8-39.2 39.2-43.3 43.3L121.4 144c4.1-4.1 18.5-18.5 43.3-43.3l11.3-11.3 22.6 22.6-11.3 11.3z"],
    "table-picnic": [512, 512, [], "e32d", "M125.7 347.9l-40.1 100.1-68.9 0 44.8-112 68.9 0-4.8 11.9zm352 56.2l17.6 43.9-68.9 0-8.1-20.1-36.7-91.9 68.9 0 27.3 68.1zM448 128l-80.7 0 38.4 96 106.3 0 0 64-512 0 0-64 106.3 0 38.4-96-80.8 0 0-64 384 0 0 64zM175.2 224l161.5 0-38.4-96-84.7 0-38.4 96z"],
    "face-grin-beam-sweat": [576, 512, [128517, "grin-beam-sweat"], "f583", "M497.7-21.6c4.6-4.5 9.4-8.7 14.3-12.9 4.9 4.2 9.7 8.4 14.3 12.9 10.8 10.5 28.8 29.7 40 51.3 5.6 10.7 9.6 22.5 9.6 34.3 0 36.4-27.6 64-64 64s-64-27.6-64-64c0-11.8 4.1-23.6 9.6-34.3 11.2-21.6 29.2-40.8 40-51.3zM288 0c42.5 0 82.6 10.4 117.8 28.7-3.6 10.9-5.8 22.7-5.8 35.3 0 62.9 49.1 112 112 112 6.4 0 12.7-.5 18.8-1.5 8.6 25.6 13.2 53 13.2 81.5 0 141.4-114.6 256-256 256S32 397.4 32 256 146.6 0 288 0zm0 328c-58.2 0-112.4-10.6-157.7-28.7 13 75.4 78.6 132.7 157.7 132.7s144.7-57.3 157.7-132.7C400.4 317.4 346.2 328 288 328zM208 180c15.5 0 28 12.5 28 28l0 28 40 0 0-28c0-37.6-30.4-68-68-68s-68 30.4-68 68l0 28 40 0 0-28c0-15.5 12.5-28 28-28zm132 28c0-15.5 12.5-28 28-28s28 12.5 28 28l0 28 40 0 0-28c0-37.6-30.4-68-68-68s-68 30.4-68 68l0 28 40 0 0-28z"],
    "circle-half-stroke": [512, 512, [9680, "adjust"], "f042", "M448 256c0-106-86-192-192-192l0 384c106 0 192-86 192-192zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0z"],
    "ruler-triangle": [576, 512, [128208], "f61c", "M64.3-29.3l0 509.3 509.3 0-77.7-77.7c-9.4 9.4-19.9 19.9-31.6 31.6L430.3 400c11.7-11.7 22.2-22.2 31.6-31.6l-46.1-46.1c-29.4 29.4-47.9 47.9-55.6 55.6L326.3 344c7.7-7.7 26.2-26.2 55.6-55.6l-46.1-46.1c-9.4 9.4-19.9 19.9-31.6 31.6L270.3 240c11.7-11.7 22.2-22.2 31.6-31.6l-46.1-46.1c-29.4 29.4-47.9 47.9-55.6 55.6L166.3 184c7.7-7.7 26.2-26.2 55.6-55.6L175.9 82.3c-9.4 9.4-19.9 19.9-31.6 31.6L110.3 80 141.9 48.4 64.3-29.3zm128 293l88.2 88.2-88.2 0 0-88.2z"],
    "octagon-plus": [512, 512, ["plus-octagon"], "f301", "M0 160L0 352 160 512 352 512 512 352 512 160 352 0 160 0 0 160zM232 368l0-88-88 0 0-48 88 0 0-88 48 0 0 88 88 0 0 48-88 0 0 88-48 0z"],
    "user-cowboy": [448, 512, [], "f8ea", "M106.9 80.4c-37.7-10.4-71.8-25.7-100.9-44.7 12.6 39.5 45.8 73.5 91 95.9-.4 4.1-.6 8.2-.6 12.4 0 70.7 57.3 128 128 128s128-57.3 128-128c0-4.2-.2-8.3-.6-12.4 45.2-22.4 78.4-56.3 91-95.9-29.1 19-63.3 34.3-100.9 44.7l-37.5-112.4-80 32-80-32-37.5 112.4zM224.4 224c-42.3 0-77-32.9-79.8-74.5 24.8 6.8 51.7 10.5 79.8 10.5s55-3.7 79.8-10.5c-2.8 41.6-37.5 74.5-79.8 74.5zm208 288l-64-192-288 0-64 192 416 0z"],
    "bookmark-plus": [384, 512, [], "e755", "M0 0L0 528 192 416 384 528 384 0 0 0zM168 320l0-72-72 0 0-48 72 0 0-72 48 0 0 72 72 0 0 48-72 0 0 72-48 0z"],
    "person-military-to-person": [512, 512, [], "e54c", "M200 0l-144 14.1 0 32 144 0 0-46.1zM189.5 78.1l-122.9 0c-1.6 5.7-2.5 11.7-2.5 17.9 0 35.3 28.7 64 64 64s64-28.7 64-64c0-6.2-.9-12.2-2.5-17.9zM192 192L83.8 192 217.8 295 192 192zM32 320L197.8 320 58.7 213.1 32 320zM384 160a64 64 0 1 0 0-128 64 64 0 1 0 0 128zm96 160l-32-128-128 0-32 128 192 0zM272 432l96 80 16 0 0-56c82.7 0 125.3 0 128 0l0-48c-2.7 0-45.3 0-128 0l0-56-16 0-96 80zM128 352l0 56c-82.7 0-125.3 0-128 0l0 48c2.7 0 45.3 0 128 0l0 56 16 0 96-80-96-80-16 0z"],
    "image-music": [640, 512, [], "e770", "M512 32l-448 0 0 448 209.5 0c4.6-24.3 19.4-43.6 36.5-56.4 3.7-2.8 7.5-5.3 11.5-7.6l-209.5 0 96-144 46.1 69.1 81.9-133.1 16 26 0-6.2 160-29.1 0-166.7zM192 112a48 48 0 1 1 0 96 48 48 0 1 1 0-96zM624 255.8l0-28.8-28.3 5.1-176 32-19.7 3.6 0 181.8c-5.9-1.1-11.4-1.6-16-1.6-9.5 0-22.9 2.1-34.9 7.5-11.1 5-29.1 17.2-29.1 40.5s18 35.4 29.1 40.5c11.9 5.4 25.4 7.5 34.9 7.5s22.9-2.1 34.9-7.5c11.1-5 29.1-17.2 29.1-40.5l0-140.1 128-23.3 0 85c-5.9-1.1-11.4-1.6-16-1.6-9.5 0-22.9 2.1-34.9 7.5-11.1 5-29.1 17.2-29.1 40.5s18 35.4 29.1 40.5c11.9 5.4 25.4 7.5 34.9 7.5s22.9-2.1 34.9-7.5c11.1-5 29.1-17.2 29.1-40.5l0-208.1z"],
    "person-pinball": [512, 512, [], "e21d", "M512 544l-64 0 0-160-224 0 0 160-64 0 0-245-48-61.7 0 306.8-64 0 0-178.7-48-48 0-205.3 95.7 0 9.6 12.3 94.3 121.2 231.5-51.4-45.3-136-1.7-4.9 0-85.2 128 0 0 576zM248 288a24 24 0 1 0 0 48 24 24 0 1 0 0-48zM64 80A56 56 0 1 1 64-32 56 56 0 1 1 64 80z"],
    "mouse-field": [512, 512, [], "e5a8", "M396.2 113.6c2.5-8.1 3.8-16.7 3.8-25.6 0-48.6-39.4-88-88-88s-88 39.4-88 88c0 29.8 14.8 56.1 37.4 72l-5.4 0c-88.4 0-160 71.6-160 160l0 48-24 0c-39.8 0-72 32.2-72 72s32.2 72 72 72l408 0 0-48-408 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l344 0 0-56.8c-4.8-1.8-26.8-9.7-65.7-23.9l23.8-63.5c2 .1 4 .2 6 .2l131.9 0 0-23.1c0-43-19.8-81.4-50.8-106.5 11.8-15 18.8-33.9 18.8-54.4 0-46.4-35.9-84.4-81.4-87.8 20.6 20.3 33.4 48.5 33.4 79.8 0 14.5-2.8 28.4-7.8 41.1-8.9-3.4-18.3-6-28-7.5zM400 196a20 20 0 1 1 40 0 20 20 0 1 1 -40 0zM312 48c22.1 0 40 17.9 40 40l0 40-40 0c-22.1 0-40-17.9-40-40s17.9-40 40-40z"],
    "table-cells-column-lock": [640, 512, [], "e678", "M256 224l0 192 64 0 0-192-64 0zm256-79c-46.7 5.8-85.6 36.8-102.7 79l-25.3 0 0 48-16 0 0 208-304 0 0-448 448 0 0 113zM128 224l0 192 64 0 0-192-64 0zm400 16c-17.7 0-32 14.3-32 32l0 48 64 0 0-48c0-17.7-14.3-32-32-32zm-80 32c0-44.2 35.8-80 80-80s80 35.8 80 80l0 48 32 0 0 192-224 0 0-192 32 0 0-48z"],
    "truck-field-un": [640, 512, [], "e58e", "M384 32l-352 0 0 96-32 0 0 160 32 0 0 96 32.4 0c-.2 2.6-.4 5.3-.4 8 0 48.6 39.4 88 88 88s88-39.4 88-88c0-2.7-.1-5.4-.4-8l144.7 0c-.2 2.6-.4 5.3-.4 8 0 48.6 39.4 88 88 88s88-39.4 88-88c0-2.7-.1-5.4-.4-8l48.4 0 0-160-72.7 0-1.7-4.2-56-136-8.2-19.8-85.4 0 0-32zm0 192l0-96 42.6 0 39.5 96-82.1 0zM152 352a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm280 40a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zM132 144l0 64c0 6.6 5.4 12 12 12s12-5.4 12-12l0-84 40 0 0 84c0 28.7-23.3 52-52 52s-52-23.3-52-52l0-84 40 0 0 20zm108-20l20.4 0c1.6 3.2 9.5 18.9 23.6 47.3l0-47.3 40 0 0 136-40.4 0c-1.6-3.2-9.5-18.9-23.6-47.3l0 47.3-40 0 0-136 20 0z"],
    "clock": [512, 512, [128339, "clock-four"], "f017", "M256 0a256 256 0 1 1 0 512 256 256 0 1 1 0-512zM232 120l0 148.8 10.7 7.1 96 64 20 13.3 26.6-39.9c-2.4-1.6-37.5-25-105.3-70.2l0-147.2-48 0 0 24z"],
    "layer-minus": [576, 512, ["layer-group-minus"], "f5fe", "M408 24l136 0 0 48-160 0 0-48 24 0zM288 352L16 224 288 96 560 224 288 352zM129.6 330.5L288 405 446.4 330.5 560 384 288 512 16 384 129.6 330.5z"],
    "circle-euro": [512, 512, [], "e5ce", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM144.2 240l-24.2 0 0-32 32.1 0c19.6-51.5 69.5-88 127.8-88l57 0 0 48-57 0c-31 0-58.3 15.9-74.2 40l66.3 0 0 32-79.3 0c-1 5.4-1.6 11-1.6 16.8 0 5.2 .4 10.3 1.3 15.2l79.5 0 0 32-67.2 0c15.7 24.9 43.5 41.5 75.2 41.5l57 0 0 48-57 0c-58.9 0-109.1-37.3-128.4-89.5l-31.5 0 0-32 24 0c-.6-5-.8-10.1-.8-15.2 0-5.7 .3-11.3 1-16.8z"],
    "book": [448, 512, [128212], "f02d", "M384 0l-384 0 0 512 448 0 0-64-32 0 0-64 32 0 0-384-64 0zM96 384l256 0 0 64-288 0 0-32c0-17.7 14.3-32 32-32zm32-256l224 0 0 48-224 0 0-48zm224 96l0 48-224 0 0-48 224 0z"],
    "face-laugh-wink": [512, 512, ["laugh-wink"], "f59c", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm0-80c-83 0-151.2-63.1-159.2-144l318.4 0c-8 80.9-76.2 144-159.2 144zM144 192a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm164 8l0 16-40 0 0-16c0-33.1 26.9-60 60-60l16 0c33.1 0 60 26.9 60 60l0 16-40 0 0-16c0-11-9-20-20-20l-16 0c-11 0-20 9-20 20z"],
    "transducer": [384, 512, [], "e826", "M80 544l-80 0 0-144 80 0 0 144zm176 0l-128 0 0-144 128 0 0 144zm128 0l-80 0 0-144 80 0 0 144zM160 64l64 0 0-96 48 0 0 96 48 0 0 288-256 0 0-288 48 0 0-96 48 0 0 96z"],
    "user-doctor-hair-long": [448, 512, [], "e459", "M304 128c0-18-6-34.6-16-48l0 0-64 48-80 0 0 16c0 44.2 35.8 80 80 80s80-35.8 80-80l0-16zm48 0l0 48 48 96-352 0 48-96 0-48C96 57.3 153.3 0 224 0S352 57.3 352 128zM284 367.4c-23.3 8.2-40 30.5-40 56.6l0 52 40 0 0-52c0-11 9-20 20-20s20 9 20 20l0 52 40 0 0-52c0-26.1-16.7-48.3-40-56.6l0-47.4 44 0 64 192-416 0 64-192 44 0 0 68.4c-16.5 7.6-28 24.3-28 43.6 0 26.5 21.5 48 48 48s48-21.5 48-48c0-19.4-11.5-36.1-28-43.6l0-68.4 120 0 0 47.4z"],
    "cloud-meatball": [512, 512, [], "f73b", "M0 320l109.7 0 62.6-62.6 26.8 5.4 15.2-22.7 83.4 0 15.2 22.7 26.8-5.4 62.6 62.6 109.7 0 0-96c0-53-43-96-96-96l0-16c0-44.2-35.8-80-80-80-24.3 0-46.1 10.9-60.8 28-18.7-35.7-56.1-60-99.2-60-61.9 0-112 50.1-112 112l0 21.5C26.7 146.6 0 182.2 0 224l0 96zM172.1 434.7l-6.6 33.1 22.6 22.6 33.1-6.6 18.7 28.1 32 0 18.7-28.1 33.1 6.6 22.6-22.6-6.6-33.1 28.1-18.7 0-32-28.1-18.7 6.6-33.1-22.6-22.6-33.1 6.6-18.7-28.1-32 0-18.7 28.1-33.1-6.6-22.6 22.6 6.6 33.1-28.1 18.7 0 32 28.1 18.7zM48 448a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm416 0a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"],
    "cloud-xmark": [576, 512, [], "e35f", "M144 480l432 0 0-128c0-47.4-25.7-88.7-64-110.9l0-49.1c0-53-43-96-96-96-17.7 0-34.2 4.8-48.4 13.1-24.1-45.8-72.2-77.1-127.6-77.1-79.5 0-144 64.5-144 144l0 24.2C40.1 220 0 273.3 0 336l0 144 144 0zM372.9 237.1c-8.5 8.5-25.5 25.5-50.9 50.9 25.5 25.5 42.4 42.4 50.9 50.9l-33.9 33.9c-8.5-8.5-25.5-25.5-50.9-50.9-25.5 25.5-42.4 42.4-50.9 50.9l-33.9-33.9c8.5-8.5 25.5-25.5 50.9-50.9-25.5-25.5-42.4-42.4-50.9-50.9l33.9-33.9c8.5 8.5 25.5 25.5 50.9 50.9 25.5-25.5 42.4-42.4 50.9-50.9l33.9 33.9z"],
    "chart-area": [512, 512, ["area-chart"], "f1fe", "M64 64l0-32-64 0 0 448 512 0 0-64-448 0 0-352zM328.8 189.3l-88.8-96.8-112 122.2 0 137.3 352 0 0-137.9-88-88-63.2 63.2z"],
    "utility-pole-double": [512, 512, [], "e2c4", "M288 0l0 64 96 0 0-32 48 0 0 32 32 0 0-32 48 0 0 96-68.7 0-155.3 103.5 0 24.5 96 0 0-32 48 0 0 32 32 0 0-32 48 0 0 96-68.7 0-155.3 103.5 0 88.5-64 0 0-88.5-155.3-103.5-68.7 0 0-96 48 0 0 32 32 0 0-32 48 0 0 32 96 0 0-24.5-155.3-103.5-68.7 0 0-96 48 0 0 32 32 0 0-32 48 0 0 32 96 0 0-64 64 0zM155.3 128l68.7 45.8 0-45.8-68.7 0zM288 173.8l68.7-45.8-68.7 0 0 45.8zM155.3 320l68.7 45.8 0-45.8-68.7 0zM288 365.8l68.7-45.8-68.7 0 0 45.8z"],
    "rupiah-sign": [512, 512, [], "e23d", "M0 32l112 0c79.5 0 144 64.5 144 144 0 54.3-30 101.5-74.4 126.1 32.7 108.8 49.4 164.6 50.2 167.4l-61.3 18.4c-.8-2.6-17.6-58.7-50.4-168.1-2.7 .1-5.4 .2-8.1 .2l-48 0 0 160-64 0 0-448zM64 256l48 0c44.2 0 80-35.8 80-80s-35.8-80-80-80l-48 0 0 160zm224-32l112 0c61.9 0 112 50.1 112 112S461.9 448 400 448l-48 0 0 96-64 0 0-320zm64 160l48 0c26.5 0 48-21.5 48-48s-21.5-48-48-48l-48 0 0 96z"],
    "diagram-nested": [448, 512, [], "e157", "M0 32l192 0 0 192-64 0 0 128 128 0 0-64 192 0 0 192-192 0 0-64-192 0 0-192-64 0 0-192z"],
    "square-quarters": [448, 512, [], "e44e", "M0 32l448 0 0 448-448 0 0-448zM64 96L224 256 384 96 64 96zm0 320l320 0-160-160-160 160z"],
    "print-slash": [576, 512, [], "f686", "M49.3-16.9l-17-17-33.9 33.9 17 17 512 512 17 17 33.9-33.9c-.6-.6-33.3-33.3-98.1-98.1l0-30 64 0 0-192-286 0-48-48 270 0 0-64-80-80-304 0 0 30-46.8-46.8zM378.2 448l-218 0 0-96 122 0-160-160-90 0 0 192 64 0 0 128 346 0-64-64zm62-176a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"],
    "shield-keyhole": [512, 512, [], "e248", "M256 0l11.6 4.5 207.5 80.5 19.2 7.4 1.2 20.5c2.9 50-4.9 126.3-37.3 200.9-32.7 75.3-91.1 150-189.4 192.6l-12.7 5.5-12.7-5.5C144.9 463.9 86.6 389.2 53.9 313.9 21.5 239.3 13.7 162.9 16.6 113L17.8 92.5 37 85 244.5 4.5 256 0zm56 208c0-30.9-25.1-56-56-56s-56 25.1-56 56c0 22.3 13.1 41.6 32 50.6l0 93.4 48 0 0-93.4c18.9-9 32-28.3 32-50.6z"],
    "square-left": [448, 512, [11013, "arrow-alt-square-left"], "f351", "M0 32l0 448 448 0 0-448-448 0zM224 384l-8 0-128-128 128-128 8 0 0 80 128 0 0 96-128 0 0 80z"],
    "text-width": [512, 512, [], "f035", "M64.3 0l-32 0 0 128 64 0 0-64 128 0 0 160-64 0 0 64 192 0 0-64-64 0 0-160 128 0 0 64 64 0 0-128-416 0zm86.6 406.6l22.6-22.6-45.3-45.3c-8.2 8.2-37.1 37.1-86.6 86.6L19 448c8.2 8.2 37.1 37.1 86.6 86.6l22.6 22.6 45.3-45.3-32-32 229.5 0-32 32 45.3 45.3 109.3-109.3-109.3-109.3-45.3 45.3 32 32-229.5 0 9.4-9.4z"],
    "circle-currency": [512, 512, [], "e6ee", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM168 134.1c10.4 10.4 23.5 23.5 39.2 39.2 14.3-8.4 31-13.3 48.8-13.3s34.5 4.8 48.8 13.3c15.7-15.7 28.8-28.8 39.2-39.2L377.9 168c-10.4 10.4-23.5 23.5-39.2 39.2 8.4 14.3 13.3 31 13.3 48.8s-4.8 34.5-13.3 48.8c15.7 15.7 28.8 28.8 39.2 39.2L344 377.9c-10.4-10.4-23.5-23.5-39.2-39.2-14.3 8.4-31 13.3-48.8 13.3s-34.5-4.8-48.8-13.3c-15.7 15.7-28.8 28.8-39.2 39.2L134.1 344c10.4-10.4 23.5-23.5 39.2-39.2-8.4-14.3-13.3-31-13.3-48.8s4.8-34.5 13.3-48.8c-15.7-15.7-28.8-28.8-39.2-39.2L168 134.1zm54.2 87.9l-.2 .2c-8.6 8.7-13.9 20.6-13.9 33.8s5.3 25.2 13.9 33.8c0-67.7 0-67.6 .2 .2 8.7 8.6 20.6 13.9 33.8 13.9s25.2-5.3 33.8-13.9l.2-.2c8.6-8.7 13.9-20.6 13.9-33.8s-5.3-25.2-13.9-33.8l-.2-.2c-8.7-8.6-20.6-13.9-33.8-13.9s-25.2 5.3-33.8 13.9z"],
    "signature-lock": [576, 512, [], "e3ca", "M160 96c-17.7 0-32 14.3-32 32l0 64-64 0 0-64c0-53 43-96 96-96s96 43 96 96l0 7.8c0 18.2-.9 36.4-2.7 54.6 40.1-13.5 73-24.6 98.7-33.3l0 53c-10.2 18.4-16 39.5-16 62l-48 0 0-25.8-46.8 15.8-1.2 5.3c-11.8 53.3-31.6 104.5-58.7 151.9-19.8 34.6-31.3 54.8-34.8 60.8l-114.6 0 0-215 21.8-7.3 132-44.5c4.2-25.6 6.3-51.4 6.3-77.3l0-7.8c0-17.7-14.3-32-32-32zM304 368l0 48-84.5 0c8.2-15.7 15.6-31.7 22.3-48l62.1 0zM169 286.3l-73 24.6 0 105 13.4 0 16.3-28.6c18.3-32 32.8-65.9 43.3-101.1zm327-14.2c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 47.9 64 0 0-47.9zM352 320l32 0 0-47.9c0-44.2 35.8-80 80-80s80 35.8 80 80l0 47.9 32 0 0 192-224 0 0-192z"],
    "satellite": [576, 512, [128752], "f7bf", "M248.4-9.9l17 17 89.4 89.4c42.1-42.1 68-68 77.7-77.7 10.9 10.9 34.4 34.4 70.6 70.6L525.7 112c-9.7 9.7-35.6 35.6-77.7 77.7l89.4 89.4 17 17-17 17-96 96-17 17-106.3-106.3-15.5 15.5c11.4 24.6 17.8 52 17.8 80.9 0 38.7-11.4 74.7-31.1 104.9L179.1 410.6c-46.2 46.2-73.8 73.8-82.6 82.6L51.2 448c8.9-8.9 36.4-36.4 82.6-82.6L23.6 255.1c30.1-19.7 66.2-31.1 104.9-31.1 28.9 0 56.3 6.4 80.9 17.8l15.5-15.5-89.4-89.4-17-17 17-17 96-96 17-17zm0 67.9l-62.1 62.1 72.4 72.4 62.1-62.1-72.4-72.4zm176 300.1l62.1-62.1-72.4-72.4-62.1 62.1 72.4 72.4z"],
    "ball-pile": [576, 512, [], "f77e", "M288 160a80 80 0 1 0 0-160 80 80 0 1 0 0 160zM176 328a80 80 0 1 0 0-160 80 80 0 1 0 0 160zM160 432a80 80 0 1 0 -160 0 80 80 0 1 0 160 0zm128 80a80 80 0 1 0 0-160 80 80 0 1 0 0 160zm288-80a80 80 0 1 0 -160 0 80 80 0 1 0 160 0zM400 328a80 80 0 1 0 0-160 80 80 0 1 0 0 160z"],
    "seats": [512, 512, [], "e765", "M224 0l0 240-192 0 0-240 192 0zM480 0l0 240-192 0 0-240 192 0zm32 384l-32 0 0 128-64 0 0-128-128 0 0 128-64 0 0-128-128 0 0 128-64 0 0-128-32 0 0-96 512 0 0 96z"],
    "file-eps": [576, 512, [], "e644", "M272 0l-240 0 0 512 144 0 0-176 240 0 0-192-144-144zm85.5 176L240 176 240 58.5 357.5 176zM240 380l-20 0 0 168 104 0 0-40-64 0 0-24 48 0 0-40-48 0 0-24 64 0 0-40-84 0zm128 0l-20 0 0 168 40 0 0-48 12 0c33.1 0 60-26.9 60-60s-26.9-60-60-60l-32 0zm32 80l-12 0 0-40 12 0c11 0 20 9 20 20s-9 20-20 20zm76-28c0 28.7 23.3 52 52 52 6.6 0 12 5.4 12 12s-5.4 12-12 12l-52 0 0 40 52 0c28.7 0 52-23.3 52-52s-23.3-52-52-52c-6.6 0-12-5.4-12-12s5.4-12 12-12l44 0 0-40-44 0c-28.7 0-52 23.3-52 52z"],
    "magnifying-glass-minus": [576, 512, ["search-minus"], "f010", "M448.3 208c0 45.9-14.9 88.3-40 122.7L534.9 457.4 557.5 480 512.3 525.3 489.6 502.6 363 376c-34.4 25.2-76.8 40-122.7 40-114.9 0-208-93.1-208-208s93.1-208 208-208 208 93.1 208 208zm-128 24l24 0 0-48-208 0 0 48 184 0z"],
    "vent-damper": [640, 512, [], "e465", "M64 64l512 0 0 96 64 0 0 192-64 0 0 96-512 0 0-96-64 0 0-192 64 0 0-96zm120 64l-24 0 0 48 320 0 0-48-296 0zm0 104l-24 0 0 48 320 0 0-48-296 0zm0 104l-24 0 0 48 320 0 0-48-296 0z"],
    "people-group": [512, 512, [], "e533", "M256 128a64 64 0 1 0 0-128 64 64 0 1 0 0 128zm64 384l0-128 32 0 0-112c0-53-43-96-96-96s-96 43-96 96l0 112 32 0 0 128 128 0zM96 144a56 56 0 1 0 0-112 56 56 0 1 0 0 112zM32 480l112.1 0c-.1-1.3-.1-2.7-.1-4l0-44-32 0 0-160c0-26.7 7.3-51.6 19.9-73.1-11.1-4.5-23.2-6.9-35.9-6.9-53 0-96 43-96 96l0 96 32 0 0 96zm448 0l0-96 32 0 0-96c0-53-43-96-96-96-12.7 0-24.8 2.5-35.9 6.9 12.6 21.4 19.9 46.4 19.9 73.1l0 160-32 0 0 44c0 1.3 0 2.7-.1 4L480 480zM416 144a56 56 0 1 0 0-112 56 56 0 1 0 0 112z"],
    "square-quote": [448, 512, [], "e329", "M0 32l448 0 0 448-448 0 0-448zM208 160l-112 0 0 112 64 0 0 8c0 13.3-10.7 24-24 24l-24 0 0 48 24 0c39.8 0 72-32.2 72-72l0-120zm32 0l0 112 64 0 0 8c0 13.3-10.7 24-24 24l-24 0 0 48 24 0c39.8 0 72-32.2 72-72l0-120-112 0z"],
    "square-binary": [448, 512, [], "e69b", "M0 32l448 0 0 448-448 0 0-448zm120 68l-20 0 0 136 120 0 0-136-100 0zm20 96l0-56 40 0 0 56-40 0zm140-96l-20 0 0 40 16 0 0 96 40 0 0-136-36 0zM132 276l0 40 16 0 0 96 40 0 0-136-56 0zm96 0l0 136 120 0 0-136-120 0zm40 40l40 0 0 56-40 0 0-56z"],
    "masks-theater": [640, 512, [127917, "theater-masks"], "f630", "M23 97l50 283.6 119.1 40.1 0-96.2-57.8 10.2c-.3-38.6 22.7-73.6 57.8-88.8l0-56.8-83.9 14.8c-4.6-26.1 12.8-51 38.9-55.6 17.4-3.1 34.2 3.6 44.9 16.2l0-52.5 9.6-12.8C222.6 71.3 272.5 35.6 349.1 21.8 318.6 5.5 262.8-10.3 185.2 3.4 84.4 21.2 35.1 73.2 23 97zm217.1 31l0 288 176 96 176-96 0-288c-16-21.3-73.6-64-176-64s-160 42.7-176 64zm176 288c-61.1 0-110.8-48.9-112-109.7 28.9 28.3 68.4 45.7 112 45.7s83.1-17.4 112-45.7c-1.2 60.8-50.9 109.7-112 109.7zm-112-176c0-26.5 21.5-48 48-48s48 21.5 48 48l-96 0zm224 0l-96 0c0-26.5 21.5-48 48-48s48 21.5 48 48z"],
    "house-turret": [576, 512, [], "e1b4", "M448 0l-64 0 0 64-64 0 0-64-64 0 0 72.9 208 168 0 110.9-32 0 0 160.2 144 0 0-512-64 0 0 64-64 0 0-64zM384 304l32 0 0-40-208-168-208 168 0 40 32 0 0 208 352 0 0-208zM256 272l0 96-96 0 0-96 96 0z"],
    "cart-plus": [640, 512, [], "f217", "M0-16l116 0c2.1 11.7 5 27.7 8.7 48l451.2 0-48 256-356.7 0 8.7 48 300 0 0 48-340 0-3.6-19.7-60.4-332.3-76 0 0-48zM160 464a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm224 0a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM312 241.6l48 0 0-57.6 57.6 0 0-48-57.6 0 0-57.6-48 0 0 57.6-57.6 0 0 48 57.6 0 0 57.6z"],
    "hands-asl-interpreting": [640, 512, ["american-sign-language-interpreting", "asl-interpreting", "hands-american-sign-language-interpreting"], "f2a3", "M260.5 69.9l24.6-20.5-41-49.2c-6.2 5.1-43 35.8-110.5 92.1l29.3-58.6-57.2-28.6-14.3 28.6-77.9 155.7C4.6 207.2 0 226.8 0 246.7L0 256c0 70.7 57.3 128 128 128l80 0 0-.3c46.2-3.5 83.8-37.1 93.6-81.3l-62.5-13.8c-4 17.9-20 31.3-39.1 31.3-22.1 0-40-17.9-40-40s17.9-40 40-40c19.1 0 35.1 13.4 39.1 31.3l62.5-13.8c-8-36.3-34.9-65.5-69.9-76.6 48.8-13.3 80.7-22 95.6-26.1L310.5 93.1c-11.6 3.2-50.1 13.7-115.6 31.5l65.6-54.7zM378.8 442.3l-24.6 20.5 41 49.2c6.2-5.1 43-35.8 110.5-92.1l-29.3 58.6 57.2 28.6 14.3-28.6 77.9-155.7c8.9-17.8 13.5-37.4 13.5-57.2l0-9.3c0-70.7-57.3-128-128-128l-80 0 0 .3c-46.2 3.5-83.8 37.1-93.6 81.2l62.5 13.8c4-17.9 20-31.3 39.1-31.3 22.1 0 40 17.9 40 40s-17.9 40-40 40c-19.1 0-35.1-13.4-39.1-31.3l-62.5 13.8c8 36.3 34.9 65.5 69.9 76.6-48.8 13.3-80.7 22-95.6 26.1l16.8 61.7c11.6-3.2 50.1-13.7 115.6-31.5l-65.6 54.7z"],
    "face-anxious-sweat": [640, 512, [], "e36a", "M320 512c141.4 0 256-114.6 256-256S461.4 0 320 0c-131 0-239.1 98.5-254.2 225.4 6.1 4.8 25.8 20.5 34.6 28l.3 .3c14.4 12.5 32.3 29.7 46.8 50.2 14.3 20.1 28.4 47.7 28.4 80.1 0 25.4-8 48.6-21.7 67.2 44.7 38 102.5 60.8 165.7 60.8zm0-192c44.2 0 80 35.8 80 80l0 16-160 0 0-16c0-44.2 35.8-80 80-80zm112-48a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM240 240a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm36.3-80c-10.6 10.6-17.7 17.7-21.5 21.5-24.2 24.2-55.3 40.2-89 45.8l-2.5 .4-19.7 3.3-6.6-39.5 19.7-3.3 2.5-.4c25.5-4.2 49-16.4 67.3-34.6 3.8-3.8 11-11 21.5-21.5L276.3 160zm101.6 14.1L363.7 160 392 131.7c10.6 10.6 17.7 17.7 21.5 21.5 18.3 18.3 41.8 30.4 67.3 34.6l2.5 .4 19.7 3.3-6.6 39.5-19.7-3.3-2.5-.4c-33.7-5.6-64.8-21.6-89-45.8l-7.4-7.4zM49.7 298.4c-10.8 10.5-28.8 29.7-40 51.3-5.6 10.7-9.6 22.5-9.6 34.3 0 36.4 27.6 64 64 64s64-27.6 64-64c0-11.8-4.1-23.6-9.6-34.3-11.2-21.6-29.2-40.8-40-51.3-4.6-4.5-9.4-8.7-14.3-12.9-4.9 4.2-9.7 8.4-14.3 12.9z"],
    "message-smile": [512, 512, ["comment-alt-smile"], "f4aa", "M0 32l0 416 128 0 0 96 160-96 224 0 0-416-512 0zM192 160a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm128 0a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM166.6 280c22 24.6 53.9 40 89.4 40s67.4-15.4 89.4-40l35.8 32c-30.7 34.3-75.5 56-125.2 56s-94.5-21.7-125.2-56l35.8-32z"],
    "location-exclamation": [384, 512, ["map-marker-exclamation"], "f608", "M192 0C298 0 384 84.4 384 188.6 384 339.4 192 528 192 528S0 339.4 0 188.6C0 84.4 86 0 192 0zM164 292l0 56 56 0 0-56-56 0zM160 96l12.8 160 38.4 0 12.8-160-64 0z"],
    "square-naira": [448, 512, [], "e708", "M0 32l448 0 0 448-448 0 0-448zm152 96l-24 0 0 128-32 0 0 32 32 0 0 96 48 0 0-96 39.5 0 52 84.6 7 11.4 45.4 0 0-96 32 0 0-32-32 0 0-128-48 0 0 128-19.8 0-71.7-116.6-7-11.4-21.4 0zm43.8 128l-19.8 0 0-32.2 19.8 32.2z"],
    "table-cells-row-unlock": [640, 512, [], "e691", "M256 224l0 192 64 0 0-192-64 0zm256-79c-46.7 5.8-85.6 36.8-102.7 79l-25.3 0 0 48-16 0 0 208-304 0 0-448 448 0 0 113zM128 224l0 192 64 0 0-192-64 0zm400 16c-17.7 0-32 14.3-32 32l0 48 144 0 0 192-224 0 0-192 32 0 0-48c0-44.2 35.8-80 80-80s80 35.8 80 80l-48 0c0-17.7-14.3-32-32-32z"],
    "diamonds-4": [576, 512, [], "e68b", "M169 409l119-119 119 119-119 119-119-119zM135 375L16 256 135 137 254.1 256 135 375zM169 103l119-119 119 119-119 119-119-119zM441 137l119 119-119 119-119-119 119-119z"],
    "rocket": [576, 512, [], "f135", "M0 320l160 0 64 64 0 160 160-96 0-122.1c141.4-83.5 135.5-212 120.6-286.5-74.5-14.9-203-20.8-286.5 120.6L96 160 0 320zM384 112a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"],
    "file-circle-info": [576, 512, [58604], "e493", "M272 0l-240 0 0 512 244 0c-22.7-31.5-36-70.2-36-112 0-100.6 77.4-183.2 176-191.3L416 144 272 0zm85.5 176L240 176 240 58.5 357.5 176zM432 544a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm15.3-224l0 32-32 0 0-32 32 0zm1.2 64l0 64 15.5 0 0 32-15.5 0-.5 0c-24 0-40 0-48 0l0-32 16 0 .5 0 0-32-.5 0-16 0 0-32c23.9 0 40.8 0 48.5 0z"],
    "cloud-fog": [576, 512, [127787, "fog"], "f74e", "M128 320l-96 0 0-96c0-41.8 26.7-77.4 64-90.5L96 112c0-61.9 50.1-112 112-112 43.1 0 80.5 24.3 99.2 60 14.7-17.1 36.5-28 60.8-28 44.2 0 80 35.8 80 80l0 16c53 0 96 43 96 96l0 96-416 0zm384 48l0 48-512 0 0-48 512 0zM64 464l128 0 0 48-128 0 0-48zm176 0l336 0 0 48-336 0 0-48z"],
    "option": [640, 512, [], "e318", "M448 448l-15.4 0-9.6-12-246.4-308-176.6 0 0-64 207.4 0 9.6 12 246.4 308 176.6 0 0 64-192 0zm0-320l-32 0 0-64 224 0 0 64-192 0z"],
    "utility-pole": [512, 512, [], "e2c3", "M288 0l0 64 96 0 0-32 48 0 0 32 32 0 0-32 48 0 0 96-64.9 0-159.1 132.6 0 251.4-64 0 0-251.4-159.1-132.6-64.9 0 0-96 48 0 0 32 32 0 0-32 48 0 0 32 96 0 0-64 64 0zM139.9 128l84.1 70.1 0-70.1-84.1 0zM288 198.1l84.1-70.1-84.1 0 0 70.1z"],
    "shrimp": [512, 512, [129424], "e448", "M24 32l-24 0 0 144 66.4 0C77.7 257.3 147.5 320 232 320l56 0 0-192-240 0 0-48 432 0 0-48-456 0zM320 320l18.3 0c9.9 0 19.1 3.2 26.6 8.5l133.5-92.4C471.8 172.6 409.1 128 336 128l-16 0 0 192zm62.8 35.1c.8 3.4 1.2 7 1.2 10.6 0 4.6-.7 9-1.9 13.1L472.6 415c24.6-30.3 39.4-68.9 39.4-111 0-12.3-1.3-24.3-3.7-35.9L382.8 355.1zm-21.2 50c-3 1.8-6.2 3.2-9.6 4.3l0 69.9c36.4-3.3 69.5-17.6 96.1-39.6l-86.5-34.6zM320 407.8c-48.1-16.8-80.1-28-96-33.6l0 105.8 96 0 0-72.2zM168 192a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"],
    "alien": [448, 512, [128125], "f8f5", "M224 0C100.3 0 0 100.3 0 224 0 400 224 512 224 512S448 400 448 224C448 100.3 347.7 0 224 0zm32 304c0-44.2 35.8-80 80-80l48 0 0 16c0 44.2-35.8 80-80 80l-48 0 0-16zM112 224c44.2 0 80 35.8 80 80l0 16-48 0c-44.2 0-80-35.8-80-80l0-16 48 0z"],
    "skeleton": [512, 512, [], "f620", "M288 0l0 64 160 0 0 64-160 0 0 48 224 0 0 64-224 0 0 48 128 0 0 64-128 0 0 48 80 0c44.2 0 80 35.8 80 80l0 32-64 0 0-32c0-8.8-7.2-16-16-16l-224 0c-8.8 0-16 7.2-16 16l0 32-64 0 0-32c0-44.2 35.8-80 80-80l80 0 0-48-128 0 0-64 128 0 0-48-224 0 0-64 224 0 0-48-160 0 0-64 160 0 0-64 64 0z"],
    "tire-pressure-warning": [512, 512, [], "f633", "M384 32l0-32 64 0 0 46.5c0 24.1 3.9 48 11.5 70.8l2.5 7.4c4.8 14.4 11.5 28.6 19.3 44.4 17.5 35.6 33.4 82.6 27.5 136.2-5.3 48.6-28.1 99-76.8 148.7l0 58-64 0 0-32-32 0 0 32-64 0 0-32-32 0 0 32-64 0 0-32-32 0 0 32-64 0 0-58c-48.7-49.7-71.4-100.1-76.8-148.7-5.9-53.6 9.9-100.6 27.5-136.2 7.8-15.8 14.5-30 19.3-44.4l2.5-7.4C60.1 94.5 64 70.5 64 46.5l0-46.5 64 0 0 46.5c0 31-5 61.7-14.8 91.1l-2.5 7.4c-6.3 19-14.8 36.6-22.6 52.5-14.7 29.7-25.3 64-21.3 100.9 3.7 34 20.4 74.1 65.7 117.7l246.8 0c45.3-43.6 62-83.7 65.7-117.7 4.1-36.9-6.6-71.1-21.3-100.9-7.8-15.8-16.3-33.5-22.6-52.5l-2.5-7.4C389 108.2 384 77.4 384 46.5L384 32zM280 136l0 120-48 0 0-144 48 0 0 24zm0 160l0 48-48 0 0-48 48 0z"],
    "nose": [448, 512, [], "e5bd", "M448 512L448 368 176 0 64 0 64 249.6c17.5-6.2 36.4-9.6 56-9.6l40 0 0 48-40 0C53.7 288 0 341.7 0 408l0 104 96 0c0-44.2 35.8-80 80-80s80 35.8 80 80l192 0z"],
    "sign-posts-wrench": [640, 512, [], "e626", "M96 64l0-48 64 0 0 48 256 0 0-48 64 0 0 48 64 0 0 114.9c-10.4-1.9-21.1-2.9-32-2.9-97.2 0-176 78.8-176 176 0 35.4 10.5 68.4 28.5 96l-204.5 0 0 64-64 0 0-64-64 0 0-384 64 0zM464 233.3l0 118.7 48 32 48-32 0-118.7c46.9 19 80 65 80 118.7 0 47.4-25.7 88.7-64 110.9l0 81.1-128 0 0-81.1c-38.3-22.1-64-63.5-64-110.9 0-53.7 33.1-99.7 80-118.7z"],
    "tenge-sign": [384, 512, [8376, "tenge"], "f7d7", "M0 32l384 0 0 48-384 0 0-48zm0 96l384 0 0 64-160 0 0 288-64 0 0-288-160 0 0-64z"],
    "face-scream": [576, 512, [], "e38b", "M539.5 304c3-15.5 4.5-31.6 4.5-48 0-141.4-114.6-256-256-256S32 114.6 32 256c0 16.4 1.5 32.5 4.5 48l98.9 0c1.7 8.6 13.7 68.6 36 179.9 35 17.9 74.6 28.1 116.7 28.1s81.7-10.1 116.7-28.1c22.3-111.4 34.3-171.3 36-179.9l98.9 0zM288 320c26.5 0 48 21.5 48 48l0 32c0 26.5-21.5 48-48 48s-48-21.5-48-48l0-32c0-26.5 21.5-48 48-48zm-46.6-77c-22.5 36.9-62.8 54.7-90.1 39.8s-31.1-56.8-8.7-93.7 62.8-54.7 90.1-39.8 31.1 56.9 8.7 93.7zm183.3 39.8c-27.3 14.9-67.6-2.9-90.1-39.8s-18.6-78.8 8.7-93.7 67.6 2.9 90.1 39.8 18.6 78.8-8.7 93.7zM0 352l0 160 128 0-32-160-96 0zm576 0l-96 0-32 160 128 0 0-160z"],
    "house-chimney-medical": [512, 512, ["clinic-medical"], "f7f2", "M464 272l48 0 0-48-48-45 0-131-96 0 0 41-112-105-256 240 0 48 48 0 0 240 416 0 0-240zM224 288l0-56 64 0 0 56 56 0 0 64-56 0 0 56-64 0 0-56-56 0 0-64 56 0z"],
    "square-arrow-left": [448, 512, ["arrow-square-left"], "f33a", "M448 32l-448 0 0 448 448 0 0-448zM103 239c63.8-63.8 96.2-96.2 97-97L233.9 176c-7.6 7.6-26.3 26.3-56 56l150.1 0 24 0 0 48-174.1 0c29.7 29.7 48.4 48.4 56 56l-33.9 33.9-17-17c-63.8-63.8-96.2-96.2-97-97l17-17z"],
    "circle-location-arrow": [512, 512, ["location-circle"], "f602", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM233.4 278.6L86.3 244.7 369.1 142.9 267.3 425.7 233.4 278.6z"],
    "users-slash": [640, 512, [], "e073", "M81.2-16.9l-17-17-33.9 33.9 17 17 512 512 17 17 33.9-33.9-17-17-271.1-271.1c56.5-1.1 102-47.2 102-104 0-57.4-46.6-104-104-104-56.8 0-102.9 45.5-104 102L81.2-16.9zM485 288l-31.2 0 181.2 181.2c1.2 1.2 2.3 2.4 3.3 3.7L592 288 485 288zM59.9 97.7c-21.5 12.5-35.9 35.7-35.9 62.3 0 39.8 32.2 72 72 72 26.6 0 49.8-14.4 62.3-35.9L59.9 97.7zM234.2 272l-26.2 0-48 208 282.2 0-208-208zM110.7 480l2.5-10.8 41.8-181.2-107 0-48 192 110.7 0zM616 160a72 72 0 1 0 -144 0 72 72 0 1 0 144 0z"],
    "traffic-cone": [512, 512, [], "f636", "M173.7 128l50.3-128 64 0 50.3 128-164.6 0zm-25.1 64l214.9 0 37.7 96-290.3 0 37.7-96zM48 448l37.7-96 340.6 0 37.7 96 48 0 0 64-512 0 0-64 48 0z"],
    "star-sharp-half-stroke": [576, 512, ["star-sharp-half-alt"], "e28d", "M288.4-39.1l69.7 219 216.3 0-176.1 136.9 70.5 221.6-180.4-140.3-180.4 140.3 70.5-221.6-176.1-136.9 216.3 0 69.7-219zm0 366.3l72.3 56.2-27.6-86.8 78.1-60.7-94 0-28.7-90.3 0 181.6z"],
    "h1": [512, 512, [], "f313", "M401.7 67.4c-48.6 24.3-79.4 39.7-92.6 46.3l28.6 57.2c20.9-10.5 36.3-18.2 46.3-23.2l0 236.2-64 0 0 64 192 0 0-64-64 0 0-320-39.6 0-6.8 3.4zM64 96l0-32-64 0 0 384 64 0 0-160 128 0 0 160 64 0 0-384-64 0 0 160-128 0 0-128z"],
    "tamale": [320, 512, [129748], "e451", "M0 16S48-32 160-32 320 16 320 16l-23.5 176-68.4 0 15.7-125.5 2.5-19.8-39.7-5-2.5 19.8-16.3 130.5-55.7 0-16.3-130.5-2.5-19.8-39.7 5 2.5 19.8 15.7 125.5-68.4 0-23.5-176zM277.9 348.6l-14.3-28.6 33 0 23.5 176S272 544 160 544 0 496 0 496l23.5-176 33 0-14.3 28.6 43.4 21.7c-7.4 59.3-11.4 91-11.9 95l39.7 5c.8-6.3 4.2-33.3 10.1-81l33.1 16.6 3.4-6.8 3.4 6.8 33.1-16.6c6 47.7 9.3 74.7 10.1 81l39.7-5c-.5-4-4.5-35.7-11.9-95l43.4-21.7zM8 232l304 0 0 48-113.2 0 25.4 50.7-42.9 21.5c-7.2-14.4-14.3-28.6-21.3-42.5-7 14-14.1 28.2-21.3 42.5L95.8 330.7c6.5-13 15-29.9 25.4-50.7L8 280 8 232z"],
    "route-highway": [448, 512, [], "f61a", "M240.7 12.6L224.3 2.7c-12.9 7.8-20 12-21.1 12.7-37.5 22.5-84 24.3-123.1 4.7l-1.4-.7-27.1-13.5c-7.2 12.6-22.9 40-47 82.3L-4 103c3.3 6.7 12 23.9 25.9 51.7 6.8 13.7 10.4 28.8 10.4 44.1 0 12.5-2.4 25-7.1 36.6L9.4 275c-6 15.1-9.1 31.2-9.1 47.5 0 50 29.1 95.4 74.6 116.3l136.1 62.4 13.3 6.1 13.3-6.1 136.1-62.4c45.5-20.8 74.6-66.3 74.6-116.3 0-16.3-3.1-32.4-9.1-47.5l-15.8-39.5c-4.7-11.7-7.1-24.1-7.1-36.6 0-15.3 3.6-30.4 10.4-44.1 13.9-27.8 22.5-45 25.9-51.7-1.7-3.1-15.2-26.7-40.5-70.9l-15-26.3-27.1 13.5-1.4 .7C329.4 39.7 283 37.9 245.4 15.4l-4.7-2.8zM96.1 192l256.3 0c-.1 2.3-.1 4.6-.1 6.8 0 20.7 3.9 41.2 11.6 60.4l15.8 39.5c3 7.5 4.6 15.6 4.6 23.7 0 25-14.6 47.7-37.3 58.1l-122.7 56.3-122.7-56.3c-22.7-10.4-37.3-33.1-37.3-58.1 0-8.1 1.6-16.2 4.6-23.7l15.8-39.5c7.7-19.2 11.6-39.7 11.6-60.4 0-2.3 0-4.6-.1-6.8z"],
    "paper-plane": [640, 512, [61913], "f1d8", "M0 192L608-32 384 576 286.9 329.2 416 160 247.2 289.3 0 192z"],
    "object-intersect": [512, 512, [], "e49d", "M288 64l0 96-128 0 0 128-96 0 0-224 224 0zM64 352l96 0 0 160 352 0 0-352-160 0 0-160-352 0 0 352 64 0zM448 224l0 224-224 0 0-96 128 0 0-128 96 0z"],
    "book-atlas": [448, 512, ["atlas"], "f558", "M0 0l448 0 0 384-32 0 0 64 32 0 0 64-448 0 0-512zM64 416l0 32 288 0 0-64-256 0c-17.7 0-32 14.3-32 32zM302.4 216c-4.5 22.3-18.4 41.3-37.3 52.7 5.4-15 9.1-33 10.4-52.7l26.9 0zm-156.8 0l26.9 0c1.3 19.7 5 37.7 10.4 52.7-18.9-11.4-32.8-30.3-37.3-52.7zm70.7 49.7c-5.6-12.1-10.1-29.3-11.6-49.7l38.8 0c-1.6 20.4-6 37.6-11.6 49.7-3.2 6.9-5.9 10.6-7.7 12.6-1.8-1.9-4.5-5.6-7.7-12.6zm0-131.4c3.2-6.9 5.9-10.6 7.7-12.6 1.8 1.9 4.5 5.6 7.7 12.6 5.6 12.1 10.1 29.3 11.6 49.7l-38.8 0c1.6-20.4 6-37.6 11.6-49.7zM302.4 184l-26.9 0c-1.3-19.7-5-37.7-10.4-52.7 18.9 11.4 32.8 30.3 37.3 52.7zm-129.9 0l-26.9 0c4.5-22.3 18.4-41.3 37.3-52.7-5.4 15-9.1 33-10.4 52.7zM344 200a120 120 0 1 0 -240 0 120 120 0 1 0 240 0z"],
    "table": [448, 512, [], "f0ce", "M256 160l0 96 128 0 0-96-128 0zm-64 0l-128 0 0 96 128 0 0-96zM0 320l0-288 448 0 0 448-448 0 0-160zm384 0l-128 0 0 96 128 0 0-96zM192 416l0-96-128 0 0 96 128 0z"],
    "circle-sort": [512, 512, ["sort-circle"], "e030", "M0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm136-32l240 0-120-128-120 128zM256 416l120-128-240 0 120 128z"],
    "heart": [512, 512, [128153, 128154, 128155, 128156, 128420, 129293, 129294, 129505, 9829, 10084, 61578], "f004", "M133.1 32C175.8 32 216 52.5 241 87.1l15 20.7 15-20.7C296 52.5 336.2 32 378.9 32 452.4 32 512 91.6 512 165.1 512 301.9 358.5 425.3 256 496 153.5 425.3 0 301.9 0 165.1 0 91.6 59.6 32 133.1 32z"],
    "scythe": [640, 512, [], "f710", "M384.4 0l117 0-3.3 15.2-37.9 176.8-427.9 0s80-192 352-192zM488.9 288l62.5-288 65.5 0-70.9 326.7 0 .1-34.3 159.9-6.7 31.3-62.6-13.4c1.3-5.9 12.2-56.7 32.7-152.6l-122.7 0 0-64 136.5 0z"],
    "circle-chevron-up": [512, 512, ["chevron-circle-up"], "f139", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm17-345l104 104 17 17-33.9 33.9-17-17-87-87-87 87-17 17-33.9-33.9 17-17 104-104 17-17 17 17z"],
    "apostrophe": [192, 512, [], "27", "M72 352c66.3 0 120-53.7 120-120l0-200-192 0 0 192 128 0 0 8c0 30.9-25.1 56-56 56l-40 0 0 64 40 0z"],
    "battery-half": [640, 512, ["battery-3"], "f242", "M544 128l0 256-448 0 0-256 448 0zM96 64l-64 0 0 384 576 0 0-128 32 0 0-128-32 0 0-128-512 0zM336 176l-192 0 0 160 192 0 0-160z"],
    "font-awesome": [512, 512, [62501, 62694, "font-awesome-flag", "font-awesome-logo-full"], "f2b4", "M91.7 96C106.3 86.8 116 70.5 116 52 116 23.3 92.7 0 64 0S12 23.3 12 52c0 16.7 7.8 31.5 20 41l0 419 64 0 0-64 400 0 0-32-64-144 64-144 0-32-404.3 0z"],
    "handcuffs": [576, 512, [], "e4f8", "M320-64l-64 0 0 64 64 0 0-64zM224 0l-64 0 0 64 64 0 0-64zm32 96l-128 0 0 42.9C53.4 165.3 0 236.4 0 320 0 426 86 512 192 512s192-86 192-192c0-83.6-53.4-154.7-128-181.1L256 96zM64 320a128 128 0 1 1 256 0 128 128 0 1 1 -256 0zm448 0c0 66.9-51.3 121.8-116.6 127.5-14.3 22.8-32.4 43.1-53.4 59.9 13.5 3 27.6 4.6 42 4.6 106 0 192-86 192-192 0-83.6-53.4-154.7-128-181.1l0-42.9-128 0 0 20.9c30.4 19.2 56.2 45.1 75.4 75.6 65.4 5.8 116.6 60.6 116.6 127.5zM352 0l0 64 64 0 0-64-64 0z"],
    "square-bangladeshi-taka": [448, 512, [], "e744", "M448 32l-448 0 0 448 448 0 0-448zM104 128l27.4 0c33.5 0 60.6 27.1 60.6 60.6l0 19.4 32 0 0 32-32 0 0 83.4c0 6.9 5.6 12.6 12.6 12.6l24 0c37.2 0 67.4-30.2 67.4-67.4l0-16c0-6.9-5.6-12.6-12.6-12.6l-3.4 0-24 0 0-48 24 0 3.4 0c33.5 0 60.6 27.1 60.6 60.6l0 16C344 332.3 292.3 384 228.6 384l-24 0c-33.5 0-60.6-27.1-60.6-60.6l0-83.4-29.7 0 0-32 29.7 0 0-19.4c0-6.9-5.6-12.6-12.6-12.6l-27.4 0 0-48z"],
    "hat-cowboy-side": [640, 512, [], "f8c1", "M640 400l0 43.6-53.4-35.6-292.7-195.1c-36.1-24.1-78.6-36.9-122-36.9l-3.9 0c-2.7 0-5.4 0-8 .1l32-144.1 64 0 64 48 64-48 64 0 43.1 194.1C575.4 239.1 640 312 640 400zM171.9 224c33.9 0 67.1 10 95.4 28.9L560 448 0 448 0 395.9C0 301 77 224 171.9 224z"],
    "sausage": [512, 512, [], "f820", "M320 160c0-42.1 27.1-77.8 64.7-90.8L360 0 472 0 447.3 69.2c37.7 13 64.7 48.7 64.7 90.8 0 194.4-157.6 352-352 352-42.1 0-77.8-27.1-90.8-64.7L0 472 0 360 69.2 384.7c13-37.7 48.7-64.7 90.8-64.7 88.4 0 160-71.6 160-160zM168 412c134.8 0 244-109.2 244-244l-40 0c0 112.7-91.3 204-204 204l0 40z"],
    "chevrons-down": [512, 512, ["chevron-double-down"], "f322", "M278.9 278.6l-22.6 22.6-22.6-22.6-192-192-22.6-22.6 45.3-45.3 22.6 22.6 169.4 169.4 169.4-169.4 22.6-22.6 45.3 45.3-22.6 22.6-192 192zm0 192l-22.6 22.6-22.6-22.6-192-192-22.6-22.6 45.3-45.3 22.6 22.6 169.4 169.4 169.4-169.4 22.6-22.6 45.3 45.3-22.6 22.6-192 192z"],
    "industry": [512, 512, [], "f275", "M128 32l-128 0 0 448 512 0 0-352-192 96 0-96-192 96 0-192z"],
    "people-dress-simple": [512, 512, [], "e218", "M128 128a64 64 0 1 0 0-128 64 64 0 1 0 0 128zM256 384l-64-224-128 0-64 224 64 0 0 128 128 0 0-128 64 0zm0 0l64 0 0 128 128 0 0-128 64 0-64-224-128 0-64 224zM384 128a64 64 0 1 0 0-128 64 64 0 1 0 0 128z"],
    "lines-leaning": [384, 512, [], "e51e", "M190.6 73.5l9.5-30.5-61.1-19.1-9.5 30.5-120 384-9.5 30.5 61.1 19.1 9.5-30.5 120-384zM292.9 37.7l-63.1-10.5-5.3 31.6-64 384-5.3 31.6 63.1 10.5 5.3-31.6 64-384 5.3-31.6zM384.1 32l-64 0 0 448 64 0 0-448z"],
    "passport": [384, 512, [], "f5ab", "M0 0L384 0 384 512 0 512 0 0zM96 384l0 48 192 0 0-48-192 0zM278.6 208c-4.8 26.4-21.5 48.7-44.2 61.2 6.7-17 11.2-38 12.6-61.2l31.6 0zm-173.1 0l31.6 0c1.4 23.1 6 44.2 12.6 61.2-22.7-12.5-39.4-34.8-44.2-61.2zm76.4 55c-6.2-13.4-11.1-32.5-12.7-55l45.8 0c-1.6 22.5-6.5 41.6-12.7 55-4.5 9.6-8.2 13.8-10.2 15.5-2-1.7-5.7-5.8-10.2-15.5zm0-142c4.5-9.6 8.2-13.8 10.2-15.5 2 1.7 5.7 5.8 10.2 15.5 6.2 13.4 11.1 32.5 12.7 55l-45.8 0c1.6-22.5 6.5-41.6 12.7-55zm96.7 55L247 176c-1.4-23.1-6-44.2-12.6-61.2 22.7 12.5 39.4 34.8 44.2 61.2zM137 176l-31.6 0c4.8-26.4 21.5-48.7 44.2-61.2-6.7 17-11.2 38-12.6 61.2zm183 16a128 128 0 1 0 -256 0 128 128 0 1 0 256 0z"],
    "infinity": [640, 512, [8734, 9854], "f534", "M0 96l240 0 9.6 12.8 70.4 93.9 70.4-93.9 9.6-12.8 240 0 0 320-240 0-9.6-12.8-70.4-93.9-70.4 93.9-9.6 12.8-240 0 0-320zM280 256l-72-96-144 0 0 192 144 0 72-96zm80 0l72 96 144 0 0-192-144 0-72 96z"],
    "hand-heart": [640, 512, [], "f4bc", "M549.1 304c41.4 0 74.9 33.5 74.9 74.9l0 2.5c0 85-143 178-144 178.7 0 0-144-93.3-144-178.7l0-2.5c0-41.4 33.5-74.9 74.9-74.9 24 0 46.6 11.5 60.7 31l8.4 11.7 8.4-11.7c14.1-19.5 36.6-31 60.7-31zM352 224l32 0 0-192 64 0 0 192 32 0 0-128 64 0 0 160.2c-23.1 1-45.3 8.3-64 21.1-20.1-13.7-44.1-21.3-69.1-21.3-67.9 0-122.9 55-122.9 122.9l0 2.5c0 34.4 14.2 65.5 30.3 90.1 9.4 14.5 20.4 28.1 31.7 40.6l-1.2 0c-59.6 0-116.9-22.9-160-64-74.8-71.2-116.2-110.7-124.5-118.6l55.2-57.9c16.8 16 41 39.1 72.6 69.1 0-1.5-.1-3.1-.1-4.6l0-304 64 0 0 192 32 0 0-224 64 0 0 224z"],
    "clone": [512, 512, [], "f24d", "M288 448l-224 0 0-224 48 0 0-64-112 0 0 352 352 0 0-112-64 0 0 48zm224-96l0-352-352 0 0 352 352 0z"],
    "forward": [640, 512, [9193], "f04e", "M336 296l0 200 288-240-288-240 0 200-240-200 0 480 240-200z"],
    "square-r": [448, 512, [], "e27c", "M448 32l-448 0 0 448 448 0 0-448zM144 144l104 0c39.8 0 72 32.2 72 72 0 29.5-17.7 54.8-43.1 66l40.2 74.7 6.1 11.4-54.5 0-43.1-80-33.7 0 0 80-48 0 0-224zM286 400l1.2 0-.9 .5-.3-.5zM192 240l56 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-56 0 0 48z"],
    "period": [128, 512, [], "2e", "M0 352l128 0 0 128-128 0 0-128z"],
    "m": [448, 512, [109], "4d", "M0 32l0 448 64 0 0-310.3 133.4 200.1 26.6 39.9 26.6-39.9 133.4-200.1 0 310.3 64 0 0-448-49.1 0-9.5 14.2-165.4 248.1-165.4-248.1-9.5-14.2-49.1 0z"],
    "money-check-pen": [640, 512, ["money-check-edit"], "f872", "M32 64l512 0 0 108.6-.5-.5-252.8 252.8-3.8 23.1-254.9 0 0-384zm96 224l0 48 192 0 0-48-192 0zM448 176l-320 0 0 48 320 0 0-48zm96 63.9l80 80-52.8 52.8-80-80 52.8-52.8zm-208 208l132.6-132.6 80 80-132.6 132.6-96 16 16-96z"],
    "road-spikes": [640, 512, [], "e568", "M32 96l0 256 576 0-160-256-32 0 0 153.6-96-153.6-32 0 0 153.6-96-153.6-32 0 0 153.6-96-153.6-32 0zM0 384l0 64 640 0 0-64-640 0z"],
    "fish-cooked": [576, 512, [], "f7fe", "M320 64c176 0 256 192 256 192S496 448 320 448c-80.3 0-167.8-57.4-216.9-114.5L0 416 0 368 32 256 0 144 0 96 108.7 172.1C158.7 117.2 242.7 64 320 64zm17.9 96L304 126.1c-3.5 3.5-30.5 30.5-81 81l-17 17 33.9 33.9c3.5-3.5 30.5-30.5 81-81l17-17zm112 16l-33.9-33.9-17 17-160 160-17 17 33.9 33.9 17-17 160-160 17-17zm16 112L432 254.1c-3.5 3.5-30.5 30.5-81 81l-17 17 33.9 33.9 97.9-97.9z"],
    "person-seat-reclined": [576, 512, [], "e21f", "M168.5 72a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm17 88l105.3 0 5.1 25.7 26.9 134.3 115.9 0 7.8 20.8 37.2 99.1c10.6-3.5 26.9-9 49.1-16.4L553 484.2c-42.8 14.3-105.1 35-107.6 35.9-2.3-6.2-19.3-51.6-51-136.1l-97.2 0c-.4 0-.8 0-1.3 0l-13.1 0c-30.5 0-56.8-21.5-62.8-51.4-21.1-105.5-32.6-163-34.5-172.6zm-57.8 24.7l58.2 247.3 166.7 0 0 64-217.3 0-5.8-24.7-64-272-7.3-31.1 62.3-14.7 7.3 31.1z"],
    "mountain": [576, 512, [127956], "f6fc", "M560 480L16 480 288-16 560 480zM210.5 258.5l29.5 29.5 64-64 42.6 0-58.6-106.9-77.5 141.3z"],
    "circle-w": [512, 512, [], "e12c", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM176.6 349.5l-48.6-205.5 49.3 0 26 110.1 29.7-93.4 5.3-16.7 35.1 0 5.3 16.7 29.7 93.4 26-110.1 49.3 0-48.6 205.5-4.4 18.5-36.5 0-5.3-16.7-33.1-104.1-33.1 104.1-5.3 16.7-36.5 0-4.4-18.5z"],
    "chess": [512, 512, [], "f439", "M128 56l40 0 0 40-104 0 0 32 36 72-20 0 0 48 29.6 0-13.6 136-64 80 0 48 320 0 0-48-64-80-13.6-136 29.6 0 0-48-20 0 36-72 0-32-104 0 0-40 40 0 0-48-40 0 0-40-48 0 0 40-40 0 0 48zM512 512l0-48-32-48 0-64 32-32 0-160-64 0 0 48-32 0 0-48-58.3 0-5.7 11.3 0 124.7-24.6 0 6.9 69.1 55.2 68.9 10.5 13.2 0 64.8 112 0z"],
    "temperature-three-quarters": [320, 512, ["temperature-3", "thermometer-3", "thermometer-three-quarters"], "f2c8", "M256 0L64 0 64 260.7C34.5 287 16 325.4 16 368 16 447.5 80.5 512 160 512s144-64.5 144-144c0-42.6-18.5-81-48-107.3L256 0zM224 368c0 35.3-28.7 64-64 64s-64-28.7-64-64c0-26.9 16.5-49.9 40-59.3l0-180.7 48 0 0 180.7c23.5 9.5 40 32.5 40 59.3z"],
    "b": [320, 512, [98], "42", "M32 32l-32 0 0 448 192 0c70.7 0 128-57.3 128-128 0-46.5-24.8-87.3-62-109.7 18.7-22.3 30-51 30-82.3 0-70.7-57.3-128-128-128L32 32zM160 224l-96 0 0-128 96 0c35.3 0 64 28.7 64 64s-28.7 64-64 64zM64 288l128 0c35.3 0 64 28.7 64 64s-28.7 64-64 64l-128 0 0-128z"],
    "shield-virus": [512, 512, [], "e06c", "M256 0l11.6 4.5 207.5 80.5 19.2 7.4 1.2 20.5c2.9 50-4.9 126.3-37.3 200.9-32.7 75.3-91.1 150-189.4 192.6l-12.7 5.5-12.7-5.5C144.9 463.9 86.6 389.2 53.9 313.9 21.5 239.3 13.7 162.9 16.6 113L17.8 92.5 37 85 244.5 4.5 256 0zm84.9 137.2l-17 17C307.7 170.4 280 158.9 280 136l0-24-48 0 0 24c0 22.9-27.7 34.4-43.9 18.2l-17-17-33.9 33.9 17 17c16.2 16.2 4.7 43.9-18.2 43.9l-24 0 0 48 24 0c22.9 0 34.4 27.7 18.2 43.9l-17 17 33.9 33.9 17-17c16.2-16.2 43.9-4.7 43.9 18.2l0 24 48 0 0-24c0-22.9 27.7-34.4 43.9-18.2l17 17 33.9-33.9-17-17C341.7 307.7 353.1 280 376 280l24 0 0-48-24 0c-22.9 0-34.4-27.7-18.2-43.9l17-17-33.9-33.9zM224 200a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm40 88a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"],
    "triangle": [576, 512, [9650], "f2ec", "M16 480L288-16 560 480 16 480z"],
    "litecoin-sign": [384, 512, [], "e1d3", "M128 64l0-32-64 0 0 189.9c-28.3 8.1-48.9 14-61.7 17.6l13.2 46.2c15-4.3 31.2-8.9 48.5-13.9l0 208.2 320 0 0-64-256 0 0-162.5 134.6-38.5 23.1-6.6-13.2-46.2-23.1 6.6-121.4 34.7 0-139.6z"],
    "dice-d6": [512, 512, [], "f6d1", "M496 128L496 400 256 536 16 400 16 128 256-8 496 128zM256 248.8l-158.2-93.5-17.8 10.1 0 25.9 156 92.2 0 167.7 20 11.4 20-11.3 0-167.7 156-92.2 0-25.9-17.8-10.1-158.2 93.5z"],
    "grip-lines-vertical": [192, 512, [], "f7a5", "M64 32l-64 0 0 448 64 0 0-448zm128 0l-64 0 0 448 64 0 0-448z"],
    "toggle-large-off": [576, 512, [], "e5b0", "M320 128l-256 0 0 256 256 0 0-256zm64 320l-384 0 0-384 576 0 0 384-192 0zm0-320l0 256 128 0 0-256-128 0z"],
    "golf-ball-tee": [384, 512, ["golf-ball"], "f450", "M320 432l-104 0 0 112-48 0 0-112-104 0 0-48 256 0 0 48zM192 0c106 0 192 86 192 192 0 57.4-25.2 108.8-65.1 144L65.1 336C25.2 300.8 0 249.4 0 192 0 86 86 0 192 0zm16 256c0 8.8-7.2 16-16 16l-16 0 0 32 16 0c26.5 0 48-21.5 48-48l0-16-32 0 0 16zm64-64c0 8.8-7.2 16-16 16l-16 0 0 32 16 0c26.5 0 48-21.5 48-48l0-16-32 0 0 16zm-80-16c0 8.8-7.2 16-16 16l-16 0 0 32 16 0c26.5 0 48-21.5 48-48l0-16-32 0 0 16z"],
    "hexagon": [576, 512, [11043], "f312", "M20.3 244.1l-6.8 11.9 6.8 11.9 123.7 216.1 6.9 12.1 275.1 0 6.9-12.1 123.7-216.1 6.8-11.9-6.8-11.9-123.7-216.1-6.9-12.1-275.1 0-6.9 12.1-123.7 216.1z"],
    "kite": [640, 512, [129665], "f6f4", "M608 320l-343.3 57.2-134.8 134.8-57.9 0 0-222-72 30 0-96 72 30 0-78-72 0 0-48 120 0 0 126 72-30 0 96-72-30 0 164.1 110.8-110.8 57.2-343.3 320 0 0 320zM339.7 80l14.1 14.2 65.8 65.8-113.8 113.8-14.1 14.2 28.3 28.3 14.2-14.1 113.8-113.8 65.8 65.8 14.2 14.1 28.3-28.3-14.1-14.2-65.8-65.8 49.8-49.8 14.1-14.2-28.3-28.3-14.2 14.1-49.8 49.8-65.8-65.8-14.2-14.1-28.3 28.3z"],
    "share-all": [640, 512, [], "f367", "M256.3 432l224-224-224-224 0 144-48 0c-97.2 0-176 78.8-176 176 0 128 128 176 128 176s-32-32-32-80c0-61.9 50.1-112 112-112l16 0 0 144zm119-400.4l176.4 176.4-176.4 176.4 33.9 33.9 193.4-193.4 17-17-17-17-193.4-193.4-33.9 33.9z"],
    "chemex": [384, 512, [], "e830", "M384 318.2l0 1.8-58.2 0 15.3 21.1c27.8 38.3 46.8 86.1 29.3 130l-4.7 10.8c-3.3 7.1-7.1 13.9-11.3 20.4L348 512 36 512c-6.8-9.4-12.7-19.5-17.8-30.1l-4.7-10.8c-16.4-41.2-.8-85.8 24.1-122.8l5.1-7.3 15.3-21.1-58.2 0 0-1.6 54.1-74.4 94.3 0c7.6 16.5 24.2 28 43.6 28s36-11.5 43.6-28l94.3 0 54.1 74.2zM94.6 378.7c-23.9 32.9-26.6 56.2-21.6 68.7 .1 .2 .2 .4 .2 .6l237.4 0c.1-.2 .2-.4 .2-.6 5-12.5 2.4-35.8-21.6-68.7l-42.7-58.7-109.4 0-42.7 58.7zM384 48l-58.2 80 58.2 0 0 1.6-54.2 74.4-94.2 0c-7.6-16.5-24.2-28-43.6-28s-36 11.5-43.6 28L54.1 204 0 129.6 0 128 58.2 128 0 48 0 0 384 0 384 48zM137.3 128l109.4 0 46.5-64-202.4 0 46.5 64z"],
    "folder-open": [576, 512, [128194, 128449, 61717], "f07c", "M32 292.2l0-260.2 224 0 64 48 192 0 0 80-437.2 0C71.2 171.2 56.9 215.2 32 292.2zM498.3 448L32 448 109.7 208 576 208 498.3 448z"],
    "tick": [128, 512, [], "e32f", "M32 288L0 32 128 32 96 288 32 288z"],
    "face-drooling": [512, 512, [], "e372", "M256 512c27.9 0 54.8-4.5 80-12.7l0-104.7c-10 5.8-20.7 10.5-32 14.1l0 55.3-48 0 0-48c-54.7 0-102.9-27.4-131.8-69.2l39.5-27.3C184 348.9 217.8 368 256 368s72-19.1 92.2-48.5l39.5 27.3c-1.2 1.8-2.5 3.5-3.8 5.2l0 125.7C460.5 433.5 512 350.8 512 256 512 114.6 397.4 0 256 0S0 114.6 0 256 114.6 512 256 512zM96 216c0-48.6 39.4-88 88-88l24 0 0 48-24 0c-22.1 0-40 17.9-40 40l0 24-48 0 0-24zm232-88c48.6 0 88 39.4 88 88l0 24-48 0 0-24c0-22.1-17.9-40-40-40l-24 0 0-48 24 0z"],
    "bullseye-arrow": [576, 512, [127919], "f648", "M384 48L464-32 496 48 576 80 496 160 429.1 148.8 297 281 263 247 395.2 114.9 384 48zM288 0c23.3 0 45.8 3.1 67.2 8.9-1.4 1.4-8.9 8.9-22.6 22.6 3 17.8 5.2 30.9 6.6 39.4-16.3-4.5-33.4-6.9-51.2-6.9-106 0-192 86-192 192s86 192 192 192 192-86 192-192c0-17.7-2.4-34.9-6.9-51.2 8.4 1.4 21.6 3.6 39.4 6.6 13.7-13.7 21.2-21.2 22.6-22.6 5.8 21.4 8.9 43.9 8.9 67.2 0 141.4-114.6 256-256 256S32 397.4 32 256 146.6 0 288 0zm0 112c12.9 0 25.4 1.7 37.3 4.9l-63.5 63.5c-31.3 10.9-53.8 40.6-53.8 75.6 0 44.2 35.8 80 80 80 35 0 64.7-22.5 75.6-53.8l63.5-63.5c3.2 11.9 4.9 24.4 4.9 37.3 0 79.5-64.5 144-144 144s-144-64.5-144-144 64.5-144 144-144z"],
    "kaaba": [512, 512, [128331], "f66b", "M256 174.3L419.2 112.4 256 51.3 92.8 112.4 256 174.3zM256 0L512 96 512 165.2 256 262.3 0 165.2 0 96 256 0zM0 269.2l0-52.7 247.5 93.9 8.5 3.2 8.5-3.2 247.5-93.9 0 52.7-128 48.6 0 51.3 128-48.6 0 95.4-256 96-256-96 0-95.4 128 48.6 0-51.3-128-48.6zM247.5 414.4l8.5 3.2 8.5-3.2 71.5-27.1 0-51.3-80 30.3-80-30.3 0 51.3 71.5 27.1z"],
    "hand-back-point-right": [512, 512, [], "e1a1", "M512 208l0-80-336 0 0-32 72 0-40-48-68 0c-38 0-74 16.9-98.3 46.1l-4.5 5.4C13.1 128.3 0 164.5 0 201.9L0 320c0 70.7 57.3 128 128 128l144 0 0-80 32 0 0-80 32 0 0-80 176 0z"],
    "starfighter-twin-ion-engine": [512, 512, ["starfighter-alt"], "e038", "M64 64l0-32-64 0 0 448 64 0 0-181.3 42.4 14.1C129.3 373.1 187.6 416 256 416s126.7-42.9 149.6-103.2l42.4-14.1 0 181.3 64 0 0-448-64 0 0 181.3-42.4-14.1C382.7 138.9 324.4 96 256 96S129.3 138.9 106.4 199.2L64 213.3 64 64zm192 96a96 96 0 1 1 0 192 96 96 0 1 1 0-192zm0 152a56 56 0 1 0 0-112 56 56 0 1 0 0 112z"],
    "hand-holding": [576, 512, [], "f4bd", "M66.7 384l70.6-70.6 9.4-9.4 237.3 0 0 64-128 0 0 48 138.8 0c73.3-50.4 115.7-79.6 127.5-87.6l45.3 65.9c-6.1 4.2-59.8 41.1-161 110.7l-10.2 7-396.4 0 0-128 66.7 0z"],
    "badge-sheriff": [512, 512, [], "f8a2", "M304.4 16c0 15.1-7 28.6-17.9 37.4l41.9 74.6 88.5 0c2.3-13.6 10.4-26.1 23.3-33.6 23-13.3 52.3-5.4 65.6 17.6s5.4 52.3-17.6 65.6c-13 7.5-27.9 8.2-40.9 3.4l-46.9 75.1 46.9 75.1c13-4.9 28-4.1 40.9 3.4 23 13.3 30.8 42.6 17.6 65.6s-42.6 30.8-65.6 17.6c-12.9-7.4-21-20-23.3-33.6l-88.5 0-41.9 74.6c10.9 8.8 17.9 22.3 17.9 37.4 0 26.5-21.5 48-48 48s-48-21.5-48-48c0-15.1 7-28.6 17.9-37.4l-41.9-74.6-88.5 0c-2.3 13.6-10.4 26.1-23.3 33.6-23 13.3-52.3 5.4-65.6-17.6s-5.4-52.3 17.6-65.6c13-7.5 27.9-8.2 40.9-3.4l46.9-75.1-46.9-75.1c-13 4.9-28 4.1-40.9-3.4-23-13.3-30.8-42.6-17.6-65.6S49.5 81.2 72.5 94.4c12.9 7.4 21 20 23.3 33.6l88.5 0 41.9-74.6c-10.9-8.8-17.9-22.3-17.9-37.4 0-26.5 21.5-48 48-48s48 21.5 48 48zm-112 240l64 64 64-64-64-64-64 64z"],
    "rainbow-half": [512, 512, [], "e7ca", "M480 64C250.2 64 64 250.2 64 480L0 480C0 214.9 214.9 0 480 0l0 64zm0 128c-159.1 0-288 128.9-288 288l-64 0c0-194.4 157.6-352 352-352l0 64zM320 480l-64 0c0-123.7 100.3-224 224-224l0 64c-88.4 0-160 71.6-160 160z"],
    "comment-lines": [512, 512, [], "f4b0", "M512 240c0 132.5-114.6 240-256 240-38.3 0-74.7-7.9-107.3-22.1L0 512 55.7 389.5C20.8 348.5 0 296.5 0 240 0 107.5 114.6 0 256 0S512 107.5 512 240zM152 176l-24 0 0 48 256 0 0-48-232 0zm0 96l-24 0 0 48 160 0 0-48-136 0z"],
    "single-quote-right": [192, 512, [], "e81c", "M32 352l40 0c30.9 0 56-25.1 56-56l0-8-128 0 0-192 192 0 0 200c0 66.3-53.7 120-120 120l-40 0 0-64z"],
    "bottle-droplet": [320, 512, [], "e4c4", "M80-32l160 0 0 64-32 0 0 103.3c64.9 20.4 112 81 112 152.7l0 256-320 0 0-256c0-71.6 47.1-132.3 112-152.7l0-103.3-32 0 0-64zm80 448c35.3 0 64-32.4 64-64s-64-112-64-112-64 80.4-64 112 28.7 64 64 64z"],
    "face-explode": [512, 512, ["exploding-head"], "e2fe", "M.9 235l63.1 21 96-32 96 32 96-32 96 32 63.1-21c.6 6.9 .9 14 .9 21 0 141.4-114.6 256-256 256S0 397.4 0 256c0-7.1 .3-14.1 .9-21zM208 336a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm128 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM192 448l128 0c0-35.3-28.7-64-64-64s-64 28.7-64 64zM384 128l-64 0 0 64-64 16-64-16 0-64-128 0 0-64c0-35.3 28.7-64 64-64 5.5 0 10.9 .7 16 2 0-.7 0-1.3 0-2 0-35.3 28.7-64 64-64 19.1 0 36.3 8.4 48 21.7 11.7-13.3 28.9-21.7 48-21.7 35.3 0 64 28.7 64 64 0 .7 0 1.4 0 2 5.1-1.3 10.5-2 16-2 35.3 0 64 28.7 64 64l0 64-64 0z"],
    "window-minimize": [512, 512, [128469], "f2d1", "M0 384l512 0 0 64-512 0 0-64z"],
    "stadium": [640, 512, [], "e6cc", "M432 32l-96 51.2 0 21c53 1.1 102.4 7.8 144 18.7l0-138.8 24 0 120 64-96 51.2 0 39.5c19.9 8.3 37.4 18.2 50.9 29.8 16.3 14 29.1 32.7 29.1 55.6l0 181.2c0 23.1-12.3 42.3-28.7 57.1s-38.6 26.9-64.1 36.7c-36.2 13.8-81.3 23.6-131.3 28.2l0-143.2-128 0 0 143.2c-49.9-4.6-95.1-14.4-131.2-28.2-25.5-9.7-47.8-21.9-64.1-36.7S32 428.3 32 405.2L32 224c0-22.9 12.8-41.6 29.1-55.6 9.7-8.4 21.6-15.9 34.9-22.5l0-161.9 24 0 120 64-96 51.2 0 28.1c40.6-12.3 90.2-20.3 144-22.6l0-136.7 24 0 120 64zM169.5 169.9c-10 2.7-19.3 5.6-27.9 8.7-22.4 8.1-38.8 17.2-49.1 26.2-10.4 9-12.4 15.5-12.4 19.2s2 10.2 12.4 19.2c10.4 8.9 26.8 18 49.1 26.2 11.5 4.2 24.2 8 38 11.3 7.3-12.1 25.4-22.6 50.3-30.2l-57.1-76.1-3.3-4.5zm297.7 4.5l-57.1 76.1c24.9 7.5 43 18.1 50.3 30.2 13.8-3.3 26.6-7.1 38.1-11.3 22.4-8.1 38.8-17.2 49.1-26.2 10.4-9 12.4-15.5 12.4-19.2s-2-10.2-12.4-19.2c-10.4-8.9-26.8-18-49.1-26.2-8.6-3.1-18-6.1-28-8.7l-3.3 4.5zM320 152c-35.2 0-68.6 2.6-98.6 7.2l61 81.3c12-1.2 24.6-1.9 37.7-1.9 13 0 25.6 .7 37.6 1.9l61-81.3c-30.1-4.6-63.4-7.2-98.6-7.2z"],
    "megaphone": [512, 512, [128227], "f675", "M512 32l-64 0 0 41.1-384 109.7 0-22.9-64 0 0 192 64 0 0-22.9 70.5 20.1c-4.2 10.8-6.5 22.5-6.5 34.7 0 53 43 96 96 96 46.9 0 86-33.7 94.3-78.2l129.7 37 0 41.1 64 0 0-448zM271.8 388.5c-2.3 24.4-22.8 43.5-47.8 43.5-26.5 0-48-21.5-48-48 0-7.7 1.8-15 5-21.4l90.8 25.9z"],
    "burger-glass": [576, 512, [], "e0ce", "M108.7 160l-7.5-96 245.6 0-7.5 96-230.6 0zM72 512l136 0 0-199.8c9.6-28.1 25-53.1 46-74.2 30.4-30.5 78.2-58.5 148.2-61.9 6.5-82.8 11.1-141.5 13.8-176.1L32 0 72 512zm184 31.8l320 0 0-64-320 0 0 64zM576 320s-32-96.1-160-96.2C288 224 256 320 256 320l0 47.8 320 0 0-47.8zm0 127.8l0-48-320 0 0 48 320 0zM400 272a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm-64 16a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm144 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"],
    "pen-paintbrush": [576, 512, ["pencil-paintbrush"], "f618", "M72 328L16 528 216 472 439 249 295 105 72 328zM560 128l-144-144-87 87 144 144 87-87zM109.3 18.7c-25-25-65.5-25-90.5 0s-25 65.5 0 90.5l102.1 102.1 90.5-90.5-102.1-102.1zM400 512l176 0 0-64-64 0 0-48c0-42.3-23.4-79.1-58-98.1L301.9 454c19.1 34.6 55.9 58 98.1 58z"],
    "lightbulb-slash": [576, 512, [], "f673", "M49.3-16.9l-17-17-33.9 33.9 17 17 512 512 17 17 33.9-33.9-17-17-153.2-153.2c43.9-35.2 72-89.3 72-149.9 0-106-86-192-192-192-60.7 0-114.7 28.1-149.9 72L49.3-16.9zM181.6 115.5C203.3 84.4 239.3 64 280.1 64l8 0 0 48-8 0c-27.6 0-51.6 15.5-63.7 38.3l-34.9-34.9zM97.7 167.4c-1 8.1-1.6 16.3-1.6 24.6 0 71.1 38.6 133.1 96 166.3l0 25.7 122.2 0-216.6-216.6zM384.1 453.8l-21.8-21.8-170.2 0 0 96 192 0 0-74.2z"],
    "circle-australian-dollar": [512, 512, [], "e730", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm64-376l32 0 0 24 32 0 0 48-52.8 0c-6.2 0-11.2 5-11.2 11.2 0 5.3 3.8 9.9 9 11l23.5 4.7c27.7 5.5 47.6 29.8 47.6 58 0 28.9-20.7 52.9-48 58.1l0 25.1-32 0 0-24-40 0 0-48 60.8 0c6.2 0 11.2-5 11.2-11.2 0-5.3-3.8-9.9-9-11l-23.5-4.7c-27.7-5.5-47.6-29.8-47.6-58 0-28.9 20.7-52.9 48-58.1l0-25.1zm-150.5 8l44.9 0 4.7 18 53.4 206-49.6 0-6.2-24-49.4 0-6.2 24-49.6 0 53.4-206 4.7-18zM192 248.7l-12.3 47.3 24.5 0-12.3-47.3z"],
    "shuttle-space-vertical": [448, 512, [], "e7bf", "M336 544l112 0 0-160-112-186.7 0 93.3 64 106.7 0 2.7-80 0-16-32 0-190.2c0-71.1-23.1-135.1-80-177.8-56.9 42.7-80 106.7-80 177.8l0 190.2-16 32-80 0 0-2.7 64-106.7 0-93.3-112 186.7 0 160 336 0zm0-96l64 0 0 48-64 0 0-48zM48 448l64 0 0 48-64 0 0-48zM192 112l64 0 0 32-64 0 0-32z"],
    "person-to-door": [640, 512, [58704], "e433", "M344 24a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zM128 112l-21.7 0c-1.4 3.4-14.7 36.8-40 100.1l-11.9 29.7 59.4 23.8c5.9-14.8 17.9-44.7 35.8-89.6l41.4 0-22.7 90.6c-8.3 33.2 11 67 43.7 76.8L308 372.2c-38.9 87.5-59.6 134.1-62.2 140l58.5 26 13-29.2c50.9-114.5 77.1-173.5 78.8-177.2-13.5-4.1-56.1-16.8-127.6-38.3l20.7-70.4c14.5 24.8 24 41.1 28.5 48.8l130.4 0 0-64-93.6 0-28.2-48.4C309 130.1 277.4 112 243.3 112L128 112zm4.8 284.9C62.7 454.8 24.7 486.1 19 490.8l40.7 49.4c4.6-3.8 44.8-36.9 120.7-99.5l6.8-5.6c.3-.9 5.6-15.7 15.8-44.3l-4.7-1.4c-20.4-6.1-37.9-17.6-51.2-32.4l-14.3 40zM448 48l0 112 48 0 0 160-48 0 0 144c0 26.5 21.5 48 48 48l64 0c26.5 0 48-21.5 48-48l0-416c0-26.5-21.5-48-48-48L496 0c-26.5 0-48 21.5-48 48z"],
    "face-viewfinder": [512, 512, [], "e2ff", "M24 0l136 0 0 48-112 0 0 112-48 0 0-160 24 0zM376 0l136 0 0 160-48 0 0-112-112 0 0-48 24 0zM48 376l0 88 112 0 0 48-160 0 0-160 48 0 0 24zm464 0l0 136-160 0 0-48 112 0 0-112 48 0 0 24zM96 256a160 160 0 1 1 320 0 160 160 0 1 1 -320 0zm136-40a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm72 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm-98.9 50.6l-27.7 16c15.7 27.1 45 45.4 78.6 45.4s62.9-18.3 78.6-45.4l-27.7-16C296.7 308.2 277.7 320 256 320s-40.7-11.8-50.9-29.4z"],
    "rectangle-video-on-demand": [576, 512, [], "e774", "M576 64l-576 0 0 384 576 0 0-384zM112 184l0 59.8c0 16.5 5.7 32.5 16 45.3 10.3-12.8 16-28.7 16-45.3l0-83.8 48 0 0 83.8c0 31.8-12.6 62.3-35.1 84.9-7.1 7.1-16.7 16.7-28.9 28.9-12.2-12.2-21.8-21.8-28.9-28.9-22.5-22.5-35.1-53-35.1-84.9l0-83.8 48 0 0 24zm168 24c-4.4 0-8 3.6-8 8l0 80c0 4.4 3.6 8 8 8l16 0c4.4 0 8-3.6 8-8l0-80c0-4.4-3.6-8-8-8l-16 0zm-56 8c0-30.9 25.1-56 56-56l16 0c30.9 0 56 25.1 56 56l0 80c0 30.9-25.1 56-56 56l-16 0c-30.9 0-56-25.1-56-56l0-80zm184-56l40 0c35.3 0 64 28.7 64 64l0 64c0 35.3-28.7 64-64 64l-64 0 0-192 24 0zm24 144l16 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16l-16 0 0 96z"],
    "tennis-ball": [512, 512, [127934], "f45e", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM51.9 216c41.7-1 83.1-17.3 114.9-49.2S215 93.6 216 51.9c13-2.5 26.3-3.9 40-3.9 2.7 0 5.3 .1 8 .2 0 55.2-21.1 110.4-63.3 152.6S103.4 264 48.2 264c-.1-2.7-.2-5.3-.2-8 0-13.7 1.3-27.1 3.9-40zM460.2 296c-41.7 1-83.1 17.3-114.9 49.2S297 418.4 296 460.2c-13 2.5-26.3 3.8-40 3.8-2.7 0-5.3-.1-8-.2 0-55.2 21.1-110.4 63.3-152.6S408.6 248 463.8 248c.1 2.7 .2 5.3 .2 8 0 13.7-1.3 27.1-3.8 40z"],
    "chevron-right": [320, 512, [9002], "f054", "M317.5 256L294.9 278.6 102.9 470.6 80.3 493.3 35 448 57.6 425.4 227 256 57.6 86.6 35 64 80.3 18.7 102.9 41.4 294.9 233.4 317.5 256z"],
    "egg": [384, 512, [129370], "f7fb", "M192 496C86 496 0 394 0 288 0 176 64 16 192 16S384 176 384 288c0 106-86 208-192 208zM96 288c0-24.5 5-54.4 15.1-82.8 10.1-28.5 25-54.1 43.7-71.2l-21.6-23.6C109.3 132.2 92.1 163 80.9 194.5 69.7 226.1 64 259.7 64 288l0 16 32 0 0-16z"],
    "conveyor-belt-arm": [640, 512, [], "e5f8", "M192 160l0-96-96 0 0-64 96 0 0 0 64 0 0 0 96 0 0 64-96 0 0 64 96 0 0 0 128 0 0 96-48 0 0-32-208 0-32 0 0-32zm224 96l96 0 0 64 32 0c53 0 96 43 96 96s-43 96-96 96L96 512c-53 0-96-43-96-96s43-96 96-96l0-64 96 0 0 64 64 0 0-64 96 0 0 64 64 0 0-64zM128 448a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm224-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm160 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "landmark-dome": [512, 512, ["landmark-alt"], "f752", "M224 0l64 0 0 34.7C368.4 48.1 431.9 111.6 445.3 192l34.7 0 0 64-32 0 0 160 64 48 0 48-512 0 0-48 64-48 0-160-32 0 0-64 34.7 0C80.1 111.6 143.6 48.1 224 34.7L224 0zM112 416l64 0 0-160-64 0 0 160zm112 0l64 0 0-160-64 0 0 160zm112 0l64 0 0-160-64 0 0 160z"],
    "grate": [448, 512, [], "e193", "M32 32l-32 0 0 448 448 0 0-448-416 0zM64 232l0-136 40 0 0 136-40 0zm0 48l40 0 0 136-40 0 0-136zm88 136l0-136 48 0 0 136-48 0zm96 0l0-136 48 0 0 136-48 0zm96 0l0-136 40 0 0 136-40 0zm40-184l-40 0 0-136 40 0 0 136zM296 96l0 136-48 0 0-136 48 0zm-96 0l0 136-48 0 0-136 48 0z"],
    "worm": [448, 512, [], "e599", "M224 96c0-53 43-96 96-96l128 0 0 376c0 75.1-60.9 136-136 136S176 451.1 176 376l0-80c0-22.1-17.9-40-40-40s-40 17.9-40 40l0 216-96 0 0-216c0-75.1 60.9-136 136-136s136 60.9 136 136l0 80c0 22.1 17.9 40 40 40s40-17.9 40-40l0-184-32 0c-53 0-96-43-96-96zm144-8a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"],
    "sack": [512, 512, [], "f81c", "M384 0l-256 0 56 112 144 0 56-112zM342.4 160l-172.8 0-47.1 39.2C55 255.5 16 338.8 16 426.6l0 85.4 480 0 0-85.4c0-87.8-39-171.2-106.5-227.4L342.4 160z"],
    "user-injured": [448, 512, [], "f728", "M242.7 80L334 80c-10.7-24.6-29.5-44.9-52.9-57.6L242.7 80zm-.9-70.7C236 8.4 230 8 224 8 174.8 8 132.5 37.6 114 80l80.6 0 47.1-70.7zM224 248c66.3 0 120-53.7 120-120l-240 0c0 66.3 53.7 120 120 120zM432 512l-64-192-226.5 0 45 80 165.5 0 0 112 80 0zM86.5 320l-6.5 0-64 192 178.5 0-108-192zM249.5 512l54.5 0 0-64-90.5 0 36 64z"],
    "midi": [512, 512, [], "e806", "M320 8.1C430.4 36.5 512 136.7 512 256 512 397.4 397.4 512 256 512S0 397.4 0 256C0 136.7 81.6 36.5 192 8.1l0 87.9 128 0 0-87.9zM256 384a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm-90.5-37.5a32 32 0 1 0 -45.2 45.2 32 32 0 1 0 45.2-45.2zm226.3 0a32 32 0 1 0 -45.3 45.2 32 32 0 1 0 45.3-45.2zM96 224a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm320 0a32 32 0 1 0 0 64 32 32 0 1 0 0-64z"],
    "moon-star": [512, 512, [], "e7c9", "M208 216C208 122.2 272.6 43.5 359.7 21.9 328 7.8 292.9 0 256 0 114.6 0 0 114.6 0 256S114.6 512 256 512c84.1 0 158.8-40.6 205.4-103.2-17 4.7-34.9 7.2-53.4 7.2-110.5 0-200-89.5-200-200zm163.2 20.8L400 320 428.8 236.8 512 208 428.8 179.2 400 96 371.2 179.2 288 208 371.2 236.8z"],
    "strikethrough": [512, 512, [], "f0cc", "M96 157.5C96 88.2 152.2 32 221.5 32l178.5 0 0 64-178.5 0c-34 0-61.5 27.5-61.5 61.5 0 31 23.1 57.2 53.9 61l44.1 5.5 254 0 0 64-512 0 0-64 115.1 0C103 204.6 96 181.8 96 157.5zM349.2 336l65.5 0c.9 6.1 1.4 12.2 1.4 18.5 0 69.3-56.2 125.5-125.5 125.5l-178.5 0 0-64 178.5 0c34 0 61.5-27.5 61.5-61.5 0-6.4-1-12.7-2.8-18.5z"],
    "calendar-circle-minus": [576, 512, [], "e46f", "M192 32l0 32 128 0 0-64 64 0 0 64 96 0 0 112-448 0 0-112 96 0 0-64 64 0 0 32zM32 480l0-256 323.1 0c-67.8 29.6-115.1 97.3-115.1 176 0 28.6 6.2 55.6 17.4 80L32 480zm256-80a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm224 16l0-32-160 0 0 32 160 0z"],
    "blog": [512, 512, [], "f781", "M224 0l24 0C393.8 0 512 118.2 512 264l0 24-48 0 0-24c0-119.3-96.7-216-216-216l-24 0 0-48zM128 96l0 272c0 26.5 21.5 48 48 48s48-21.5 48-48-21.5-48-48-48l-16 0 0-96 16 0c79.5 0 144 64.5 144 144S255.5 512 176 512 32 447.5 32 368l0-272 96 0zm120 0c92.8 0 168 75.2 168 168l0 24-48 0 0-24c0-66.3-53.7-120-120-120l-24 0 0-48 24 0z"],
    "stopwatch-20": [512, 512, [], "e06f", "M336.3 0l-160 0 0 48 56 0 0 25.3c-108 11.9-192 103.5-192 214.7 0 119.3 96.7 216 216 216s216-96.7 216-216c0-39.8-10.8-77.1-29.6-109.2 19.7-19.7 36.7-36.7 50.8-50.8L448.3 82.7c-15 15-30.3 30.3-46 46-32.9-30.2-75.2-50.3-122-55.5l0-25.3 56 0 0-48zm-196 240c0-28.7 23.3-52 52-52s52 23.3 52 52l0 3.8c0 11.7-3.2 23.1-9.3 33l-43.8 71.2 53.1 0 0 40-104 0 0-33.7 3-4.8 57.6-93.6c2.2-3.6 3.4-7.8 3.4-12.1l0-3.8c0-6.6-5.4-12-12-12s-12 5.4-12 12l-40 0zm180-52c28.7 0 52 23.3 52 52l0 96c0 28.7-23.3 52-52 52s-52-23.3-52-52l0-96c0-28.7 23.3-52 52-52zm-12 52l0 96c0 6.6 5.4 12 12 12s12-5.4 12-12l0-96c0-6.6-5.4-12-12-12s-12 5.4-12 12z"],
    "square-florin": [448, 512, [], "e717", "M448 32l-448 0 0 448 448 0 0-448zM240.4 156.7c9.5-22.3 31.4-36.7 55.7-36.7l47.9 0 0 48-47.9 0c-5 0-9.6 3-11.6 7.6l-20.7 48.4 56.2 0 0 48-76.7 0-35.7 83.3C198 377.6 176.1 392 151.9 392l-47.9 0 0-48 47.9 0c5 0 9.6-3 11.6-7.6l27.6-64.4-63 0 0-48 83.6 0 28.8-67.3z"],
    "binary": [384, 512, [], "e33b", "M256 0l80 0 0 160 48 0 0 64-160 0 0-64 48 0 0-96-48 0 0-64 32 0zM32 288l80 0 0 160 48 0 0 64-160 0 0-64 48 0 0-96-48 0 0-64 32 0zM0 0L192 0 192 224 0 224 0 0zM64 64l0 96 64 0 0-96-64 0zM224 288l160 0 0 224-192 0 0-224 32 0zm32 160l64 0 0-96-64 0 0 96z"],
    "shield-check": [512, 512, [], "f2f7", "M267.6 4.5l207.5 80.5 19.2 7.4 1.2 20.5c2.9 50-4.9 126.3-37.3 200.9-32.7 75.2-91.1 150-189.4 192.6l-12.7 5.5-12.7-5.5C144.9 463.9 86.6 389.2 53.9 313.9 21.5 239.3 13.7 162.9 16.6 113L17.8 92.5 37 85 244.5 4.5 256 0 267.6 4.5zm45.8 165.3L227.8 287.6c-19.3-20-33.7-34.9-43.2-44.7l-34.5 33.3c6.2 6.4 27.2 28.1 63.1 65.2l19.8 20.6 16.8-23.1 102.4-140.8 14.1-19.4-38.8-28.2-14.1 19.4z"],
    "square-cruzeiro": [448, 512, [], "e6ed", "M448 32l-448 0 0 448 448 0 0-448zM131 256c0 44.5 31.2 81.7 73 90.8l0-118.8 40 0 0 17.1c10.7-5.8 23-9.1 36-9.1l8 0 0 40-8 0c-19.9 0-36 16.1-36 36l0 34.8c22.1-4.8 41.2-17.5 54.4-35l38.4 28.8C311.1 374.8 270.1 397 224 397 146.1 397 83 333.9 83 256s63.1-141 141-141c46.1 0 87.1 22.2 112.8 56.4l-38.4 28.8c-17-22.6-44-37.2-74.4-37.2-51.4 0-93 41.6-93 93z"],
    "truck-pickup": [640, 512, [128763], "f63c", "M288 96l0 96 133.4 0-57.6-96-75.8 0zm-64 96l0-160 176 0 96 160 112 0 0 128 32 0 0 64-64.4 0c.2 2.6 .4 5.3 .4 8 0 48.6-39.4 88-88 88s-88-39.4-88-88c0-2.7 .1-5.4 .4-8l-160.7 0c.2 2.6 .4 5.3 .4 8 0 48.6-39.4 88-88 88s-88-39.4-88-88c0-2.7 .1-5.4 .4-8l-64.4 0 0-64 32 0 0-128 192 0zM192 392a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zm296 40a40 40 0 1 0 0-80 40 40 0 1 0 0 80z"],
    "seedling": [512, 512, [127793, "sprout"], "f4d8", "M512 0l0 32C512 140.1 435.4 230.3 333.6 251.4 325.7 193.3 299.6 141 261.1 100.5 301.2 40 369.9 0 448 0l64 0zM0 64l64 0c123.7 0 224 100.3 224 224l0 224-64 0 0-192C100.3 320 0 219.7 0 96L0 64z"],
    "circle-divide": [512, 512, [], "e106", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm32-320l-64 0 0-64 64 0 0 64zM168 232l200 0 0 48-224 0 0-48 24 0zm56 152l0-64 64 0 0 64-64 0z"],
    "circle-kip": [512, 512, [], "e6fd", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm97.8-348.5c-2.9 2.3-34.4 27.9-94.6 76.7l92.7 0 0 32-92.5 0c60 48.4 91.5 73.8 94.4 76.2l-30.1 37.4c-2.1-1.7-35.3-28.5-99.6-80.4l0 78.6-48 0 0-111.8-31.8 0 0-32 31.8 0 0-112.2 48 0 0 78.9c64.3-52.1 97.5-79 99.5-80.7l30.2 37.3z"],
    "transgender": [576, 512, [9895, "transgender-alt"], "f225", "M128-32l32 0 0 64-62.1 0 38.1 38.1 32-32 33.9 33.9c-11.6 11.6-22.3 22.3-32 32l14.2 14.2c27.9-23.8 64.2-38.2 103.8-38.2 36.7 0 70.6 12.4 97.6 33.2l81.2-81.2-50.7 0 0-64 160 0 0 160-64 0 0-50.7-84.4 84.4c13 23.1 20.4 49.9 20.4 78.3 0 77.4-55 142-128 156.8l0 35.2 64 0 0 64-64 0 0 48-64 0 0-48-64 0 0-64 64 0 0-35.2c-73-14.8-128-79.4-128-156.8 0-31.4 9-60.7 24.7-85.4L136 137.9c-9.7 9.7-20.4 20.4-32 32l-33.9-33.9 32-32-38.1-38.1 0 62.1-64 0 0-160 128 0zM288 336a96 96 0 1 0 0-192 96 96 0 1 0 0 192z"],
    "arrow-down-to-bracket": [448, 512, [], "e094", "M246.6 342.6l-22.6 22.6-22.6-22.6-128-128-22.6-22.6 45.3-45.3c6.6 6.6 38.6 38.6 96 96l0-242.7 64 0 0 242.7c57.4-57.4 89.4-89.4 96-96l45.3 45.3-22.6 22.6-128 128zM64 352l0 96 320 0 0-128 64 0 0 192-448 0 0-192 64 0 0 32z"],
    "unicorn": [640, 512, [129412], "f727", "M448 160l0 80 0 0c-.5 30-12.8 56.4-32 75.7l0 196.3-96 0 0-165.3c-4.1-.7-8.2-1.6-12.3-2.8L224 320 224 355.9c-7.2 7.2-20.9 20.9-41.1 41.1l38.3 115-101.2 0c-29.8-89.3-45.4-136.3-47-141 13.1-13.1 28.9-28.9 47.6-47.6L78.2 259.9c-7.3-11-11.9-23.4-13.6-36.4-10.1 7.3-16.7 19.1-16.7 32.5l0 80-48 0 0-80c0-44.6 33.2-81.5 76.3-87.2 14.9-24.4 41.8-40.8 72.5-40.8L320 128C320 57.3 377.3 0 448 0l112 0 0 32-32 0 16 16 96 0 0 16-80 26.7 0 101.3-80 32-32-64zm64-80a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"],
    "left-from-bracket": [576, 512, [], "e66c", "M40 238.6L21.5 256 40 273.4c113.3 107 174.7 165 184.5 174.2l0-127.7 160 0 0-128-160 0 0-127.7c-9.7 9.2-71.2 67.3-184.5 174.2zM384.5 416l-32 0 0 64 192 0 0-448-192 0 0 64 128 0 0 320-96 0z"],
    "ramp-loading": [384, 512, [], "f4d4", "M0 0l384 0 0 404.7-53.1-106.1-10.9-21.9 0-212.7-256 0 0 212.7c-.3 .5-21.6 43.2-64 128L0 0zM320 384l64 128-384 0 96-192 192 0 32 64z"],
    "hand-holding-box": [576, 512, [], "f47b", "M224 128l0-128-96 0 0 256 320 0 0-256-96 0 0 128-64-32-64 32zM137.4 313.4l-70.6 70.6-66.7 0 0 128 396.4 0 10.2-7c101.2-69.6 154.8-106.4 161-110.7l-45.3-65.9c-11.7 8.1-54.2 37.3-127.5 87.6l-138.8 0 0-48 128 0 0-64-237.3 0-9.4 9.4z"],
    "star-half": [576, 512, [61731], "f089", "M304.2-52.8l0 0-108.6 181.4-201.1 32 143.9 144.1-31.7 201.2 197.5-100.5 0-458.1z"],
    "arrow-down-to-line": [384, 512, ["arrow-to-bottom"], "f33d", "M32 512l-32 0 0-64 384 0 0 64-352 0zM214.6 374.6l-22.6 22.6-22.6-22.6-128-128-22.6-22.6 45.3-45.3c6.6 6.6 38.6 38.6 96 96l0-274.7 64 0 0 274.7c57.4-57.4 89.4-89.4 96-96l45.3 45.3-22.6 22.6-128 128z"],
    "photo-film": [640, 512, ["photo-video"], "f87c", "M192 0l448 0 0 352-448 0 0-352zM320 96a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM240 288l352 0-128-208-84.7 137.7-43.3-57.7-96 128zM0 128l144 0 0 272 304 0 0 80-448 0 0-352zm104 56l-48 0 0 48 48 0 0-48zm0 96l-48 0 0 48 48 0 0-48zm0 96l-48 0 0 48 48 0 0-48z"],
    "pi": [512, 512, [], "f67e", "M64.4 32l-32 0 0 64 96 0 0 280.4C107 419.4 92.7 448 85.5 462.3l57.2 28.6c6.6-13.2 22-44.1 46.3-92.6l3.4-6.8 0-295.6 128 0 0 384 131.8 0c11.2-22.3 34.9-69.9 39.2-78.3l-57.2-28.6c-10.7 21.5-17.9 35.8-21.5 42.9l-28.2 0 0-320 96 0 0-64-416 0z"],
    "picture-in-picture": [512, 512, [], "e80b", "M512 208l-64 0 0-112-384 0 0 320 144 0 0 64-208 0 0-448 512 0 0 176zm0 272l-256 0 0-224 256 0 0 224z"],
    "table-cells-lock": [640, 512, [], "e679", "M448 96l0 64-64 0 0-64 64 0zM384 224l25.3 0c17.1-42.2 56-73.2 102.7-79l0-113-448 0 0 448 304 0 0-208 16 0 0-48zm-64 64l-64 0 0-64 64 0 0 64zm-64 64l64 0 0 64-64 0 0-64zm-64-64l-64 0 0-64 64 0 0 64zm-64 64l64 0 0 64-64 0 0-64zm0-192l0-64 64 0 0 64-64 0zm128 0l0-64 64 0 0 64-64 0zm272 80c17.7 0 32 14.3 32 32l0 48-64 0 0-48c0-17.7 14.3-32 32-32zm-80 32l0 48-32 0 0 192 224 0 0-192-32 0 0-48c0-44.2-35.8-80-80-80s-80 35.8-80 80z"],
    "pump-medical": [320, 512, [], "e06a", "M96-32l0 112 128 0 0-24 96 0 0-48-96 0 0-40-128 0zM320 128l-320 0 0 384 320 0 0-384zM128 232l64 0 0 56 56 0 0 64-56 0 0 56-64 0 0-56-56 0 0-64 56 0 0-56z"],
    "fire": [448, 512, [128293], "f06d", "M285.9 58.2c-4.2 5-9 11-14.2 17.9-15.7-25.9-31.8-47.6-45.3-64.2-15.5-19-31.8-35.4-49.5-52.1-14.6 12.3-28.4 24.2-41.8 38-14.9 15.3-34.7 37.5-54.6 65.1-39.4 55-80.5 133.9-80.5 225 0 123.7 100.3 224 224 224S448 411.7 448 288c0-70.3-28.4-132.7-55.6-176.6-13.7-22.1-27.4-40-37.7-52.4-10.5-12.6-22-24.1-33.6-35.7l0 0-1.1-1.1c-.6 .6-1.2 1.2-1.9 1.9-11.2 11.2-22.1 22-32.3 34.3zM225.7 416c-63.2 0-113.7-40.6-113.7-109.2 0-65.6 63.2-114.8 63.2-114.8 5.6 7 87.1 110.6 87.1 110.6l50.6-58.8c4.2 5.6 7 11.2 9.8 16.8 25.3 46.2 14 105-28.1 134.4-21.1 14-43.5 21-68.8 21z"],
    "face-smile-plus": [640, 512, ["smile-plus"], "f5b9", "M568-64l0 72 72 0 0 48-72 0 0 72-48 0 0-72-72 0 0-48 72 0 0-72 48 0zM0 272a240 240 0 1 1 480 0 240 240 0 1 1 -480 0zm147.8 63.5l-39.5 27.3C137.1 404.6 185.3 432 240 432s102.9-27.4 131.8-69.2l-39.5-27.3C312 364.9 278.2 384 240 384s-72-19.1-92.2-48.5zM160 256a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm192-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "magnifying-glass-plus": [576, 512, ["search-plus"], "f00e", "M448.3 208c0 45.9-14.9 88.3-40 122.7L534.9 457.4 557.5 480 512.3 525.3 489.6 502.6 363 376c-34.4 25.2-76.8 40-122.7 40-114.9 0-208-93.1-208-208s93.1-208 208-208 208 93.1 208 208zm-232 96l48 0 0-72 72 0 0-48-72 0 0-72-48 0 0 72-72 0 0 48 72 0 0 72z"],
    "swap": [640, 512, [], "e609", "M128 32l-112 128 80 0 0 320 256 0 0-384 128 0 0 288-80 0 112 128 112-128-80 0 0-352-256 0 0 384-128 0 0-256 80 0-112-128z"],
    "comment-heart": [512, 512, [], "e5c8", "M512 240c0 132.5-114.6 240-256 240-38.3 0-74.7-7.9-107.3-22.1L0 512 55.7 389.5C20.8 348.5 0 296.5 0 240 0 107.5 114.6 0 256 0S512 107.5 512 240zM249.6 183.5c-11.1-14.8-28.5-23.5-46.9-23.5-32.4 0-58.7 26.3-58.7 58.7l0 5.3c0 64 112 128 112 128s112-64 112-128l0-5.3c0-32.4-26.3-58.7-58.7-58.7-18.5 0-35.9 8.7-46.9 23.5l-6.4 8.5-6.4-8.5z"],
    "face-smile-tear": [512, 512, [], "e393", "M0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zM240 366.9c-31.6-4.5-58.9-22.2-76.3-47.3l-39.5 27.3c28.3 40.9 75.2 68.1 128.6 69.2-8.2-14.1-12.8-30.5-12.8-48l0-1.1zM176 240a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm192-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM295.2 338.6c-4.2 8.4-7.2 17.7-7.2 27 0 28.7 20.7 50.4 48 50.4s48-21.7 48-50.4c0-9.3-3.1-18.6-7.2-27-9.7-19.7-24.8-36.2-40.8-50.6-16 14.4-31.1 30.9-40.8 50.6z"],
    "wheat": [576, 512, [], "f72d", "M145.8 282.7l6.1 6.7c19.7 23.8 26.3 55 19.3 83.9 31.7-7.7 66.2 1 90.6 25.3l57.4 57.4-18.7 18.7c-37.5 37.5-98.3 37.5-135.8 0L134.1 444.3 49.4 529c-9.4 9.4-24.5 9.4-33.9 0-9.4-9.4-9.4-24.6 0-33.9l84.7-84.7-30.5-30.5c-37.5-37.5-37.5-98.3 0-135.8l18.7-18.8 57.4 57.4zm104-104l6.1 6.7c19.7 23.8 26.3 55 19.3 83.9 31.7-7.7 66.2 1 90.6 25.3l57.4 57.4-18.7 18.7c-37.5 37.5-98.3 37.5-135.8 0l-94.9-94.9c-37.5-37.5-37.5-98.3 0-135.8l18.7-18.8 57.4 57.4zm104-104l6.1 6.7c19.7 23.8 26.3 55 19.3 83.9 31.7-7.7 66.2 1 90.6 25.3l57.4 57.4-18.7 18.7c-37.5 37.5-98.3 37.5-135.8 0l-94.9-94.9c-37.5-37.5-37.5-98.3 0-135.7l18.8-18.8 57.4 57.4zM560.5 35l-.1 4.8c-2.4 47.6-40.5 85.7-88.1 88.1l-4.8 .1-51 0 0-51c0-51.4 41.6-93 93-93l51 0 0 51z"],
    "barcode-scan": [576, 512, [], "f465", "M128 32l-64 0 0 192-64 0 0 48 576 0 0-48-64 0 0-192-48 0 0 192-48 0 0-192-48 0 0 192-48 0 0-192-64 0 0 192-48 0 0-192-48 0 0 192-32 0 0-192zM64 480l64 0 0-160-64 0 0 160zm96 0l48 0 0-160-48 0 0 160zm96 0l64 0 0-160-64 0 0 160zm112 0l48 0 0-160-48 0 0 160zm96 0l48 0 0-160-48 0 0 160z"],
    "ear-circle-checkmark": [576, 512, [], "e75b", "M447.3 208.6c.5-5.5 .7-11 .7-16.6 0-106-86-192-192-192S64 86 64 192l0 320 208 0 1.6-3.5c-21.2-30.9-33.6-68.2-33.6-108.5 0-57.3 25.1-108.8 65-144l0 0c22.3-19.7 49.3-34.3 79-42l0 0c15.3-3.9 31.4-6 48-6 5.1 0 10.2 .2 15.3 .6zM256 64c61.6 0 113 43.5 125.2 101.4-16 3.4-31.4 8.5-46.1 15-5.6-38.7-38.9-68.3-79.2-68.3-44.2 0-80 35.8-80 80l0 16.4c36 4 64 34.5 64 71.6 0 39.8-32.2 72-72 72l-40 0 0-48 40 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-40 0 0-64c0-70.7 57.3-128 128-128zM432 544a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm60.9-182.6l-64 88-11 15.1c-4.4-4.4-22.1-22.1-53.2-53.2L353.4 400 376 377.4c5 5 17.7 17.7 38.1 38.1l53-72.9 9.4-12.9 25.9 18.8-9.4 12.9z"],
    "galaxy": [512, 512, [], "e008", "M336 0l32 0-12.6 7.8c-51.5 31.7-84.8 85.7-90.5 145.2 16.5-5.8 34.8-9 55.1-9 2.9 0 5.8 .1 8.7 .2 .9-.1 1.9-.2 2.8-.2 1.9 0 3.7 .3 5.5 .7 98.1 8.6 175.1 90.9 175.1 191.3l0 32-7.8-12.6c-31.7-51.5-85.7-84.8-145.2-90.5 5.8 16.5 9 34.8 9 55.1 0 2.9-.1 5.8-.2 8.7 .1 .9 .2 1.9 .2 2.8 0 1.9-.3 3.7-.7 5.5-8.6 98.1-90.9 175.1-191.3 175.1l-32 0 12.6-7.8c51.5-31.7 84.8-85.7 90.5-145.2-16.5 5.8-34.8 9-55.1 9-2.9 0-5.8-.1-8.7-.2-.9 .1-1.9 .2-2.8 .2-1.9 0-3.7-.3-5.5-.7-98.1-8.6-175.1-90.9-175.1-191.3l0-32 7.8 12.6c31.7 51.5 85.7 84.8 145.2 90.5-5.8-16.5-9-34.8-9-55.1 0-2.9 .1-5.8 .2-8.7-.1-.9-.2-1.9-.2-2.8 0-1.9 .3-3.7 .7-5.5 8.6-98.1 90.9-175.1 191.3-175.1zM256 296l40-40-40-40-40 40 40 40z"],
    "flask": [448, 512, [], "f0c3", "M128 224l-128 224 0 64 448 0 0-64-128-224 0-160 32 0 0-64-256 0 0 64 32 0 0 160zM192 64l64 0 0 177c.9 1.6 16 27.9 45.1 79l-154.3 0c29.2-51.1 44.2-77.4 45.1-79l0-177z"],
    "car-key": [576, 512, [], "e7c0", "M152 32l-22.7 0-7.5 21.4-48.5 138.6-41.3 0 0 288 96 0 0-64 240 0 0-48c-38.8-29.2-64-75.6-64-128 0-16.7 2.6-32.8 7.3-48l-170.2 0 33.6-96 219.5 0c21-10.2 44.5-15.9 69.3-16-6.5-18.6-12.1-34.6-16.8-48L152 32zM96 304a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm480-64c0-61.9-50.1-112-112-112S352 178.1 352 240c0 44.7 26.2 83.2 64 101.2l0 122.8 48 48 64-64-32-32 32-32-29.8-37.3C543.3 332.3 576 289.9 576 240zM432 224a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"],
    "fireplace": [576, 512, [], "f79a", "M0 32l576 0 0 96-32 0 0 384-64 0 0-160c0-106-86-192-192-192S96 246 96 352l0 160-64 0 0-384-32 0 0-96zM261.8 224l52.4 52.4 26.2-26.2c62.8 52.4 78.5 109.1 78.5 130.9 0 72.3-58.6 130.9-130.9 130.9S157.1 453.4 157.1 381.1c0-73.3 69.8-135.3 104.7-157.1zm78.5 196.5c0-39.3-52.4-78.5-52.4-78.5s-52.4 39.3-52.4 78.5c0 28.9 23.4 52.4 52.4 52.4s52.4-23.4 52.4-52.4z"],
    "flower-tulip": [448, 512, [127799], "f801", "M64 0l80 64 80-96 80 96 80-64 0 128c0 70.7-57.3 128-128 128l0 128c29.2-38.9 75.7-64 128-64l64 0 0 32c0 88.4-71.6 160-160 160l-128 0C71.6 512 0 440.4 0 352l0-32 64 0c52.3 0 98.8 25.1 128 64l0-128c-70.7 0-128-57.3-128-128L64 0z"],
    "inboxes": [512, 512, [], "e1bb", "M427.5 64l19.2 96-78.7 0-32 64-160 0-32-64-78.7 0 19.2-96 343.1 0zM32 0L0 160 0 320 512 320 512 160 480 0 32 0zM0 368l0 144 512 0 0-144-144 0-32 48-160 0-32-48-144 0z"],
    "rectangle-vertical": [384, 512, ["rectangle-portrait"], "f2fb", "M384 0L384 512 0 512 0 0 384 0z"],
    "align-right": [448, 512, [], "f038", "M448 32l0 64-288 0 0-64 288 0zm0 256l0 64-288 0 0-64 288 0zM0 160l448 0 0 64-448 0 0-64zM448 416l0 64-448 0 0-64 448 0z"],
    "transporter-6": [640, 512, [], "e2a7", "M272-32l-16 0 0 32 128 0 0-32-112 0zM176 224l-16 0 0 32 320 0 0-32-304 0zM480 496l-320 0 0 48 320 0 0-48zM144 48l-48-16-16-48-16 48-48 16 48 16 16 48 16-48 48-16zM576 384l-16-48-16 48-48 16 48 16 16 48 16-48 48-16-48-16z"],
    "cable-car": [512, 512, [128673, 57551, "tram"], "f7da", "M288.2-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm-128 56a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM32.2 224l200 0 0-96.2-193.4 55.3-23.1 6.6-13.2-46.2 23.1-6.6c373.3-106.7 186.7-53.3 448-128l23.1-6.6 13.2 46.2-23.1 6.6-206.6 59 0 109.9 200 0 0 288-448 0 0-288zm264 64l-80 0 0 96 80 0 0-96zm48 0l0 96 72 0 0-96-72 0zm-248 0l0 96 72 0 0-96-72 0z"],
    "kit-medical": [512, 512, ["first-aid"], "f479", "M0 64l0 384 80 0 0-384-80 0zm128 0l0 384 256 0 0-384-256 0zM512 448l0-384-80 0 0 384 80 0zM224 168l64 0 0 56 56 0 0 64-56 0 0 56-64 0 0-56-56 0 0-64 56 0 0-56z"],
    "grip-lines": [448, 512, [], "f7a4", "M0 288l0 64 448 0 0-64-448 0zM0 160l0 64 448 0 0-64-448 0z"],
    "burger": [512, 512, ["hamburger"], "f805", "M32 384l0 96 448 0 0-96-448 0zM480 224l0-48S432 32 256 32 32 176 32 176l0 48 448 0zm32 48l-512 0 0 64 512 0 0-64zM256 72a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM120 128a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm248-24a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"],
    "raindrops": [448, 512, [], "f75c", "M103 101.2c-4.6 8.9-7 18.7-7 28.7 0 34.3 27.8 62.1 62.1 62.1l3.8 0c34.3 0 62.1-27.8 62.1-62.1 0-10-2.4-19.9-7-28.7L160-8 103 101.2zM7 325.2C2.4 334 0 343.9 0 353.9 0 388.2 27.8 416 62.1 416l3.8 0c34.3 0 62.1-27.8 62.1-62.1 0-10-2.4-19.9-7-28.7L64 216 7 325.2zM320 152L210.6 325.9c-12.2 19.4-18.6 41.8-18.6 64.6 0 67.1 54.4 121.4 121.4 121.4l13.1 0c67.1 0 121.4-54.4 121.4-121.4 0-22.9-6.5-45.3-18.6-64.6L320 152z"],
    "snowman": [640, 512, [9731, 9924], "f7d0", "M403 211.7c32.2-24.9 53-63.9 53-107.7 0-75.1-60.9-136-136-136S184 28.9 184 104c0 43.9 20.8 82.9 53 107.7-32.2 16.3-59 41.8-76.8 73.1l-48.1-20.6 0-64.2-48 0 0 43.6c-15.1-6.5-30-12.8-44.6-19.1L.5 268.6c20.5 8.8 118.6 50.8 141.5 60.6-3.9 14.9-6 30.6-6 46.7 0 74.8 44.7 139.3 108.8 168l150.3 0c64.2-28.7 108.8-93.2 108.8-168 0-16.2-2.1-31.8-6-46.7 103.3-44.3 139.3-59.7 141.5-60.6l-18.9-44.1c-14.6 6.3-29.5 12.6-44.6 19.1l0-43.6-48 0 0 64.2-48.2 20.6c-17.9-31.3-44.6-56.8-76.8-73.1zM296 416a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm24-120a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM248 80a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM368 56a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM292.2 159.3c-2.7-4.8-4.2-10.2-4.2-15.7 0-17.5 14.2-31.6 31.6-31.6l.8 0c17.5 0 31.6 14.2 31.6 31.6 0 5.5-1.4 10.9-4.2 15.7L320 208 292.2 159.3z"],
    "hotel": [512, 512, [127976], "f594", "M16 0l480 0 0 48-32 0 0 416 32 0 0 48-480 0 0-48 32 0 0-416-32 0 0-48zM288 384l62.7 0c-7.6-45.4-47.1-80-94.7-80s-87.1 34.6-94.7 80l62.7 0 0 80 64 0 0-80zM112 96l0 64 64 0 0-64-64 0zm176 0l-64 0 0 64 64 0 0-64zm48 0l0 64 64 0 0-64-64 0zM176 192l-64 0 0 64 64 0 0-64zm48 0l0 64 64 0 0-64-64 0zm176 0l-64 0 0 64 64 0 0-64z"],
    "print": [512, 512, [128424, 128438, 9113], "f02f", "M64 0l304 0 80 80 0 64-384 0 0-144zM0 192l512 0 0 192-64 0 0 128-384 0 0-128-64 0 0-192zM128 416l0 32 256 0 0-96-256 0 0 64zM456 272a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"],
    "dial-min": [576, 512, [], "e161", "M320 0l0 64-64 0 0-64 64 0zM128 64l0 64-64 0 0-64 64 0zm384 0l0 64-64 0 0-64 64 0zm0 192l64 0 0 64-64 0 0-64zm0 192l0 64-64 0 0-64 64 0zM64 448l64 0 0 64-64 0 0-64zM0 256l64 0 0 64-64 0 0-64zM400.9 401c-56.7 56.7-145.4 62-208 15.7l111.9-111.9 17-17-33.9-33.9-17 17-111.9 111.9c-46.2-62.6-41-151.3 15.7-208 62.5-62.5 163.8-62.5 226.3 0s62.5 163.8 0 226.3z"],
    "circle-polish-zloty": [512, 512, [], "e700", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm95.4-360l0 77.4c6.4-2.6 14.9-5.9 25.5-10.2l11.9 29.7c-8.6 3.5-21.1 8.4-37.4 14.9l0 120.1-48 0 0-100.9c-5.4 2.2-13.5 5.4-24.3 9.7l-11.9-29.7c8.8-3.5 20.9-8.4 36.2-14.5l0-120.6 48 0 0 24zM136 192l131.1 0c-3.4 8.7-22.1 56.7-56 144l60.9 0 0 48-131.1 0c3.4-8.7 22.1-56.7 56-144l-60.9 0 0-48z"],
    "family": [512, 512, [], "e300", "M128 0a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM64 512l0-160-32 0 0-192 129.3 0c-.9 5.2-1.3 10.5-1.3 16 0 11.2 1.9 22 5.5 32l-37.5 0 0 240 32 0 0 64-96 0zm384 0l-96 0 0-64 32 0 0-240-37.5 0c3.5-10 5.5-20.8 5.5-32 0-5.5-.5-10.8-1.3-16l97.3 0 64 224-64 0 0 128zM384 0a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM256 128a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm80 272l-32 0 0 112-96 0 0-112-32 0 0-144 160 0 0 144z"],
    "starfighter": [640, 512, [], "e037", "M352 0l32 256 0 224-128 0 0-224 32-256 64 0zM288 256l0 64 64 0 0-64c0-17.7-14.3-32-32-32s-32 14.3-32 32zM72 72l0 48 24 0 0 48-24 0 0 184 56 0 0-64 96 0 0 224-64 0 0-44.8-88-35.2 0 40-48 0 0-304-24 0 0-48 24 0 0-48 48 0zm544 0l0 48 24 0 0 48-24 0 0 304-48 0 0-40-88 35.2 0 44.8-64 0 0-224 96 0 0 64 56 0 0-184-24 0 0-48 24 0 0-48 48 0z"],
    "cart-circle-arrow-down": [640, 512, [], "e3ef", "M24-16l-24 0 0 48 76 0 60.4 332.3 3.6 19.7 164.7 0c1.4-16.7 4.9-32.8 10.3-48l-134.9 0-8.7-48 168.7 0c34.9-48.5 91.7-80 156-80 15.8 0 31.2 1.9 46 5.5L576 32 124.8 32c-3.7-20.3-6.6-36.3-8.7-48L24-16zM208 512a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm288 32a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm78.6-136l-11.3 11.3-56 56-11.3 11.3-11.3-11.3-56-56-11.3-11.3 22.6-22.6c4.6 4.6 18 18 40 40l0-105.4 32 0 0 105.4c22-22 35.4-35.4 40-40L574.6 408z"],
    "message-medical": [512, 512, ["comment-alt-medical"], "f7f4", "M0 32l0 416 128 0 0 96 160-96 224 0 0-416-512 0zM217.6 134.4l76.8 0 0 67.2 67.2 0 0 76.8-67.2 0 0 67.2-76.8 0 0-67.2-67.2 0 0-76.8 67.2 0 0-67.2z"],
    "circle-arrow-down-right": [512, 512, [], "e0fa", "M256 0a256 256 0 1 0 0 512 256 256 0 1 0 0-512zM216 304l54.1 0-103-103-17-17 33.9-33.9 17 17 103 103 0-78.1 48 0 0 160-160 0 0-48 24 0z"],
    "volleyball": [512, 512, [127952, "volleyball-ball"], "f45f", "M0 256c0 45.2 11.7 87.6 32.2 124.5l15.7-95.8 1-5.9 3.6-4.8 111.2-145.6-82.8-59.2C31.1 115.9 0 182.3 0 256zM135.4 481.9l10.9-111.5 .6-6.6 3.9-5.3 77.6-105.5-36.2-82.7-97.9 128.2-22.2 135.7c18.4 19 39.7 35.2 63.3 47.8zm46.4 19.2c23.5 7.1 48.4 10.9 74.3 10.9 93.3 0 174.9-49.9 219.6-124.4l-90.7 34.3-5.6 2.1-6-.8-181.7-23.5-9.9 101.4zM502.3 326.2c6.3-22.3 9.7-45.9 9.7-70.2 0-2.8 0-5.6-.1-8.4l-101.9 46.3-6 2.7-6.6-.7-130.2-14.5-53.5 72.8 159.9 20.7 128.7-48.7zM362.2 243.7L300.2 94.8 193.7 7.6c-26.1 6.5-50.7 17.1-72.9 31l91.1 65.2 5.4 3.8 2.6 6 52.6 120 89.8 10zm143.2-45.9C479.3 85.7 379.7 1.9 260.2 0l75 61.4 4.6 3.8 2.3 5.5 70.5 169.1 92.7-42.1z"],
    "arrow-turn-down-right": [576, 512, [], "e3d6", "M96.3 96l0-32-64 0 0 224 402.7 0-96 96 45.3 45.3 173.3-173.3-22.6-22.6-128-128-22.6-22.6-45.3 45.3c6.6 6.6 38.6 38.6 96 96l-338.7 0 0-128z"],
    "traffic-light": [320, 512, [128678], "f637", "M320-32l-320 0 0 576 320 0 0-576zM160 360c30.9 0 56 25.1 56 56s-25.1 56-56 56-56-25.1-56-56 25.1-56 56-56zm56-104a56 56 0 1 1 -112 0 56 56 0 1 1 112 0zM160 152a56 56 0 1 1 0-112 56 56 0 1 1 0 112z"],
    "plane-circle-check": [640, 512, [], "e555", "M232 24c0-30.9 25.1-56 56-56s56 25.1 56 56l0 127.3 78 71.5c-69.3 29-118 97.4-118 177.2 0 49.3 18.6 94.3 49.1 128.3l-65.1-16.3-128 32 0-48 72-57.6 0-99.7-184 61.3 0-80 184-168.7 0-127.3zM352 400a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm214.4-51.5l-25.9-18.8-9.4 12.9-53 72.9C457.7 395 445 382.3 440 377.4L417.4 400c2.8 2.8 19.9 19.9 51.3 51.3l13.2 13.2 11-15.1 64-88 9.4-12.9z"],
    "square-peso": [448, 512, [], "e71a", "M448 32l-448 0 0 448 448 0 0-448zM136 120l88 0c43.3 0 80.4 26.4 96 64l32 0 0 32-24.3 0c.4 5.3 .4 10.7 0 16l24.3 0 0 32-32 0c-15.7 37.6-52.8 64-96 64l-40 0 0 64-48 0 0-128-24 0 0-32 24 0 0-16-24 0 0-32 24 0 0-64zm88 48l-40 0 0 16 79.2 0c-10.1-9.9-23.9-16-39.2-16zm-40 64l95.4 0c.4-2.6 .6-5.3 .6-8s-.2-5.4-.6-8l-95.4 0 0 16zm0 32l0 16 40 0c15.3 0 29.1-6.1 39.2-16L184 264z"],
    "house-water": [640, 512, ["house-flood"], "f74f", "M560.4 272l-50.5 0 0 118.4c-31.2-12.5-54.4-21.8-69.5-27.8-6.7 2.7-46.7 18.7-120 48-73.3-29.3-113.3-45.3-120-48-15.1 6.1-38.3 15.3-69.5 27.8l0-118.4-50.5 0 0-40 240-216 240 216 0 40zM209.3 417.7l111.1 44.4 111.1-44.4 8.9-3.6 8.9 3.6 111.8 44.7c29.3-9.7 50.1-16.7 62.4-20.8l15.2 45.5c-11 3.7-34.6 11.5-70.8 23.6l-8.3 2.8-8.2-3.3-111.1-44.4-111.1 44.4-8.9 3.6-8.9-3.6-111.1-44.4-111.1 44.4-8.2 3.3-8.3-2.8C36.6 498.7 13 490.8 2 487.2l15.2-45.5c12.4 4.1 33.2 11.1 62.4 20.8l111.8-44.7 8.9-3.6 8.9 3.6zM368.4 224l-96 0 0 96 96 0 0-96z"],
    "users": [640, 512, [], "f0c0", "M320 16a104 104 0 1 1 0 208 104 104 0 1 1 0-208zM96 88a72 72 0 1 1 0 144 72 72 0 1 1 0-144zm14.7 392l-110.7 0 48-192 107 0-41.8 181.2-2.5 10.8zm418.5 0l-2.5-10.8-41.8-181.2 107 0 48 192-110.7 0zM472 160a72 72 0 1 1 144 0 72 72 0 1 1 -144 0zM208 272l224 0 48 208-320 0 48-208z"],
    "certificate": [576, 512, [], "f0a3", "M241.2-.5L211.3-31.2c-6 23.8-15.1 59.4-27.1 107-47.2-13.3-82.6-23.3-106.2-30 6.7 23.6 16.7 59 30 106.2-47.6 12.1-83.2 21.1-107 27.1 17.6 17.1 43.9 42.8 79.1 77-35.2 34.2-61.5 59.9-79.1 77 23.8 6 59.4 15.1 107 27.1-13.3 47.2-23.3 82.6-30 106.2 23.6-6.7 59-16.7 106.2-30 12.1 47.6 21.1 83.2 27.1 107 17.1-17.6 42.8-43.9 77-79.1 34.2 35.2 59.9 61.5 77 79.1 6-23.8 15.1-59.4 27.1-107 47.2 13.3 82.6 23.3 106.2 30-6.7-23.6-16.7-59-30-106.2 47.6-12.1 83.2-21.1 107-27.1-17.6-17.1-43.9-42.8-79.1-77 35.2-34.2 61.5-59.9 79.1-77-23.8-6-59.4-15.1-107-27.1 13.3-47.2 23.3-82.6 30-106.2-23.6 6.7-59 16.7-106.2 30-12.1-47.6-21.1-83.2-27.1-107-17.1 17.6-42.8 43.9-77 79.1L241.2-.5z"],
    "alarm-clock": [512, 512, [9200], "f34e", "M492.3 153.2c-32.2-56.4-84-100.1-146.1-121.9 17.4-19.2 42.6-31.3 70.6-31.3 52.6 0 95.2 42.6 95.2 95.2 0 21.8-7.3 41.9-19.7 58zm-472.6 0C7.3 137.2 0 117.1 0 95.2 0 42.6 42.6 0 95.2 0 123.2 0 148.4 12.1 165.8 31.3 103.7 53.1 51.9 96.9 19.7 153.2zM390.2 467.4C352.8 495.4 306.3 512 256 512s-96.8-16.6-134.1-44.6C96.3 493 77 512.3 64 525.3L18.7 480C31.7 467 51 447.7 76.6 422.2 48.6 384.8 32 338.3 32 288 32 164.3 132.3 64 256 64S480 164.3 480 288c0 50.3-16.6 96.8-44.6 134.2l57.8 57.8-45.3 45.3-57.8-57.8zM232 160l0 137.9 7 7 72 72 33.9-33.9-65-65 0-118.1-48 0z"],
    "helicopter-symbol": [512, 512, [], "e502", "M445.4 224l64.7 0C495.6 108.2 403.8 16.4 288 2l0 64.7C368.4 80.1 431.9 143.6 445.4 224zM510 288l-64.7 0C431.9 368.4 368.4 431.9 288 445.3l0 64.7c115.8-14.4 207.6-106.2 222-222zM2 288C16.4 403.8 108.2 495.6 224 510l0-64.7C143.6 431.9 80.2 368.4 66.7 288L2 288zm0-64l64.7 0C80.2 143.6 143.6 80.1 224 66.7L224 2C108.2 16.4 16.4 108.2 2 224zm206-64l0-32-64 0 0 256 64 0 0-96 96 0 0 96 64 0 0-256-64 0 0 96-96 0 0-64z"],
    "house-chimney-crack": [512, 512, ["house-damage"], "f6f1", "M464 272l48 0 0-48-48-45 0-131-96 0 0 41-112-105-256 240 0 48 48 0 0 240 150.4 0-38.4-64 96-80-64-112 160 112-96 80 38.4 64 169.6 0 0-240z"],
    "dryer-heat": [448, 512, ["dryer-alt"], "f862", "M448 0L0 0 0 512 448 512 448 0zM224 160a144 144 0 1 1 0 288 144 144 0 1 1 0-288zM72 96a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM192 72a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM171.3 204.7l-22.6 22.6 28.7 28.7c4.2 4.2 6.6 10 6.6 16s-2.4 11.8-6.6 16l-9.4 9.4c-10.2 10.2-16 24.1-16 38.6s5.8 28.4 16 38.6l28.7 28.7 22.6-22.6-28.7-28.7c-4.2-4.2-6.6-10-6.6-16s2.4-11.8 6.6-16l9.4-9.4c10.2-10.2 16-24.1 16-38.6s-5.8-28.4-16-38.6l-28.7-28.7zM280 233.4l-28.7-28.7-22.6 22.6 28.7 28.7c4.2 4.2 6.6 10 6.6 16s-2.4 11.8-6.6 16l-9.4 9.4c-10.2 10.2-16 24.1-16 38.6s5.8 28.4 16 38.6l28.7 28.7 22.6-22.6-28.7-28.7c-4.2-4.2-6.6-10-6.6-16s2.4-11.8 6.6-16l9.4-9.4c10.2-10.2 16-24.1 16-38.6s-5.8-28.4-16-38.6z"],
    "bring-forward": [512, 512, [], "f856", "M224 448l224 0 0-224-48 0 0-64 112 0 0 352-352 0 0-112 64 0 0 48zM0 352L0 0 352 0 352 352 0 352z"],
    "dial-low": [576, 512, [], "e15d", "M320 0l0 64-64 0 0-64 64 0zM128 64l0 64-64 0 0-64 64 0zm384 0l0 64-64 0 0-64 64 0zm0 192l64 0 0 64-64 0 0-64zm0 192l0 64-64 0 0-64 64 0zM64 448l64 0 0 64-64 0 0-64zM0 256l64 0 0 64-64 0 0-64zM287.6 447.6c-80.2 0-146.6-59-158.2-136l182.2 0 0-48-182.2 0c11.6-77 78-136 158.2-136 88.4 0 160 71.6 160 160s-71.6 160-160 160z"],
    "circle-wifi-circle-wifi": [640, 512, ["circle-wifi-group"], "e67e", "M288 512c16.7 0 33-1.6 48.8-4.6-20.7-30.6-32.8-67.6-32.8-107.4 0-1.4 0-2.9 0-4.3-4.7 2.7-10.2 4.3-16 4.3-17.7 0-32-14.3-32-32s14.3-32 32-32c9.3 0 17.7 4 23.6 10.4 4.8-16.5 11.8-32.2 20.6-46.5-13-7.5-28.1-11.9-44.1-11.9-30.4 0-57.3 15.4-73.1 38.9l-34.4-34.4c24.9-32 63.7-52.6 107.4-52.6 27.5 0 53 8.1 74.4 22.1 12.5-12.1 26.6-22.5 42-30.9-32.3-24.6-72.6-39.2-116.3-39.2-57.1 0-108.4 24.9-143.5 64.5l-34-34c43.9-48.2 107.2-78.5 177.5-78.5 65.2 0 124.4 26 167.6 68.2 13-2.8 26.5-4.2 40.4-4.2 15.3 0 30.2 1.8 44.4 5.2-20.4-121-125.6-213.2-252.4-213.2-141.4 0-256 114.6-256 256S146.6 512 288 512zM640 400a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-31.5-20.4l-25.6 19.2C564.3 370.6 532.3 352 496 352s-68.3 18.6-86.9 46.8l-25.6-19.2c24.5-36 65.7-59.6 112.5-59.6s88.1 23.6 112.5 59.6zM496 384c26.2 0 49.4 12.6 64 32l-25.6 19.2C525.6 423.5 511.7 416 496 416s-29.6 7.5-38.4 19.2L432 416c14.6-19.4 37.8-32 64-32zm0 60a20 20 0 1 1 0 40 20 20 0 1 1 0-40z"],
    "display-medical": [512, 512, ["desktop-medical"], "e166", "M64 96l0 256 384 0 0-256-384 0zM0 32l512 0 0 384-208 0 16 48 96 0 0 48-320 0 0-48 96 0 16-48-208 0 0-384zM224 136l64 0 0 56 56 0 0 64-56 0 0 56-64 0 0-56-56 0 0-64 56 0 0-56z"],
    "person-military-pointing": [576, 512, [], "e54a", "M416.3 1.4l-192 16 0 48 192 0 0-64zm-176 112c0 44.2 35.8 80 80 80s80-35.8 80-80c0-5.5-.6-10.8-1.6-16l-156.8 0c-1 5.2-1.6 10.5-1.6 16zm-168 112l-40 0 0 80 192 0 0 89.4 169.4-169.4-321.4 0zM429 235.3l-182.1 182.1 169.4 0 0-46.3c41.2 69.8 65.9 111.5 73.9 125.1l68.9-40.7-20.4-34.4-104-176-5.7-9.7zM224.3 449.4l0 64 192 0 0-64-192 0z"],
    "database": [448, 512, [], "f1c0", "M0 80l128-80 192 0 128 80 0 48-128 80-192 0-128-80 0 0 0-48zM333.8 256l114.2-71.4 0 103.4-128 80-192 0-128-80 0 0 0-103.4 114.2 71.4 219.5 0zM0 344.6l114.2 71.4 219.5 0 114.2-71.4 0 87.4-128 80-192 0-128-80 0-87.4z"],
    "newspaper": [512, 512, [128240], "f1ea", "M0 480l0-384 48 0 0 336 16 0c17.7 0 32-14.3 32-32l0-368 416 0 0 448-512 0zM160 96l0 128 128 0 0-128-128 0zM448 368l-288 0 0 48 288 0 0-48zM160 272l0 48 288 0 0-48-288 0zm288-96l-112 0 0 48 112 0 0-48z"],
    "cloud-rain": [512, 512, [127783, 9926], "f73d", "M96 320l-96 0 0-96c0-41.8 26.7-77.4 64-90.5L64 112c0-61.9 50.1-112 112-112 43.1 0 80.5 24.3 99.2 60 14.7-17.1 36.5-28 60.8-28 44.2 0 80 35.8 80 80l0 16c53 0 96 43 96 96l0 96-416 0zm8 64l35.9 71.8c2.7 5.4 4.1 11.3 4.1 17.4 0 21.4-17.4 38.8-38.8 38.8l-2.3 0c-21.4 0-38.8-17.4-38.8-38.8 0-6 1.4-12 4.1-17.4L104 384zm116.1 71.8L256 384 291.9 455.8c2.7 5.4 4.1 11.3 4.1 17.4 0 21.4-17.4 38.8-38.8 38.8l-2.3 0c-21.4 0-38.8-17.4-38.8-38.8 0-6 1.4-12 4.1-17.4zM408 384l35.9 71.8c2.7 5.4 4.1 11.3 4.1 17.4 0 21.4-17.4 38.8-38.8 38.8l-2.3 0c-21.4 0-38.8-17.4-38.8-38.8 0-6 1.4-12 4.1-17.4L408 384z"],
    "signal-strong": [512, 512, ["signal-4"], "f68f", "M384 152l0-24-48 0 0 352 48 0 0-328zM280 224l-48 0 0 256 48 0 0-256zM176 344l0-24-48 0 0 160 48 0 0-136zM72 408l0-24-48 0 0 96 48 0 0-72z"],
    "maximize": [448, 512, ["expand-arrows-alt"], "f31e", "M0 32l0 200 72-72 96 96-96 96-72-72 0 200 200 0-72-72 96-96 96 96-72 72 200 0 0-200-72 72-96-96 96-96 72 72 0-200-200 0 72 72-96 96-96-96 72-72-200 0z"],
    "location-arrow": [576, 512, [], "f124", "M16 224L528 16 320 528 240 304 16 224z"],
    "city": [576, 512, [127961], "f64f", "M448 0l-192 0 0 96-48 0 0-96-48 0 0 96-64 0 0-96-48 0 0 96-48 0 0 416 576 0 0-320-128 0 0-192zM384 96l0 64-64 0 0-64 64 0zm-64 96l64 0 0 64-64 0 0-64zm64 96l0 64-64 0 0-64 64 0zm64 0l64 0 0 64-64 0 0-64zm-192 0l0 64-64 0 0-64 64 0zm-64-96l64 0 0 64-64 0 0-64zM64 288l64 0 0 64-64 0 0-64zm0-32l0-64 64 0 0 64-64 0z"],
    "rectangle-code": [512, 512, [], "e322", "M0 64l512 0 0 384-512 0 0-384zM278.1 176c3.6 3.6 30.3 30.3 80 80-49.7 49.7-76.4 76.4-80 80l33.9 33.9 17-17 80-80 17-17-17-17c-63.8-63.8-96.2-96.2-97-97L278.1 176zM217 193l17-17-33.9-33.9c-.8 .8-33.1 33.1-97 97l-17 17c.8 .8 33.1 33.1 97 97l17 17 33.9-33.9c-3.6-3.6-30.3-30.3-80-80l63-63z"],
    "toilet-paper-check": [512, 512, [], "e5b2", "M327.1 32c-8.8 11.1-16 23.1-21.9 34.8-21.4 42.7-33.2 98.4-33.2 157.2l0 320-272 0 0-320C0 118 43 32 96 32l231.1 0zM416 32c53 0 96 86 96 192s-43 192-96 192-96-86-96-192 43-192 96-192zM172.7 159.9l-59.3 81.6c-10.6-11-21.5-22.3-32.8-33.9L46.1 241c7.9 8.2 25.5 26.3 52.6 54.4L118.6 316c1.3-1.8 32.3-44.4 92.9-127.8l14.1-19.4-38.8-28.3-14.1 19.4zM416 160c-17.7 0-32 28.7-32 64s14.3 64 32 64 32-28.7 32-64-14.3-64-32-64z"],
    "seal-question": [512, 512, [], "e243", "M256 0l64 64 128 0 0 128 64 64-64 64 0 128-128 0-64 64-64-64-128 0 0-128-64-64 64-64 0-128 128 0 64-64zm0 181.2c17.7 0 32 14.3 32 32 0 26.9-28.8 31-49.9 34l-3.3 .5 0 53.5 42.4 0 0-18.3c30.4-10.6 53.2-36.1 53.2-69.6 0-41.1-33.3-74.4-74.4-74.4s-74.4 33.3-74.4 74.4l42.4 0c0-17.7 14.3-32 32-32zM232 328l0 48 48 0 0-48-48 0z"],
    "x-ray": [512, 512, [], "f497", "M0 32l512 0 0 64-32 0 0 320 32 0 0 64-512 0 0-64 32 0 0-320-32 0 0-64zm280 88l0-24-48 0 0 40-88 0 0 48 88 0 0 48-104 0 0 48 104 0 0 48-88 0 0 48 88 0 0 40 48 0 0-40 88 0 0-48-88 0 0-48 104 0 0-48-104 0 0-48 88 0 0-48-88 0 0-16z"],
    "umbrella-beach": [512, 512, [127958], "f5ca", "M512 256c0 41.2-9.7 80.1-27 114.5l-206.8-103.4-1.6 3.2-88.8 177.7 324.2 0 0 64-512 0 0-64 116.2 0 103.2-206.3 1.6-3.2-194-97C69 57.6 155.8 0 256 0 397.4 0 512 114.6 512 256z"],
    "arrow-right-to-bracket": [512, 512, ["sign-in"], "f090", "M352 96l96 0 0 320-128 0 0 64 192 0 0-448-192 0 0 64 32 0zm-9.4 182.6l22.6-22.6-22.6-22.6-128-128-22.6-22.6-45.3 45.3 96 96-242.7 0 0 64 242.7 0c-57.4 57.4-89.4 89.4-96 96L192 429.3 342.6 278.6z"],
    "headset": [448, 512, [], "f590", "M224 64C135.6 64 64 135.6 64 224l96 0 0 160-64 0c-53 0-96-43-96-96l0-64C0 100.3 100.3 0 224 0S448 100.3 448 224l0 288.1-24 0c-140-.1-228-.1-264-.1l0-48c0-26.5 21.5-48 48-48l32 0c26.5 0 48 21.5 48 48l0 0 112 .1 0-92.9c-14.1 8.2-30.5 12.8-48 12.8l-64 0 0-160 96 0c0-88.4-71.6-160-160-160z"],
    "thumbtack-angle-slash": [576, 512, [], "e752", "M49.3-16.9l-17-17-33.9 33.9 17 17 512 512 17 17 33.9-33.9-17-17-179-179 96.3-112.4c5.3 5.3 16.4 16.4 33.5 33.5L557.4 192 374.8 9.4 352.1-13.3 306.9 32c17 17 28.2 28.2 33.5 33.5L228 161.8 49.3-16.9zm57.5 193.3c-15.4 8.5-29.9 19.3-42.9 32.4L335.3 480.3c13.1-13.1 23.9-27.5 32.4-42.9L106.7 176.4zM41.5 457.4L18.9 480 64.1 525.3c1.9-1.9 43.3-43.3 124.1-124.1L143 355.9 41.5 457.4z"],
    "camera-polaroid": [576, 512, [], "f8aa", "M64 32l448 0 0 214.3 58.6 87.9 5.4 8.1 0 137.7-576 0 0-137.7 5.4-8.1 58.6-87.9 0-214.3zM288 256a64 64 0 1 0 0-128 64 64 0 1 0 0 128zM384 96l0 64 64 0 0-64-64 0zM120 352l-24 0 0 48 384 0 0-48-360 0z"],
    "face-saluting": [640, 512, [129761], "e484", "M253.4-16l-22.6 22.6-128.5 128.5 26.2 27.3c30.5-30.5 51.7-51.7 63.7-63.7L237.4 144c-9.8 9.8-35.4 35.4-76.7 76.7-31.2 31.2-81.9 31.2-113.1 0l-4.1-4.1c-31.2-31.2-31.2-81.9 0-113.1L185.5-38.6 208.1-61.3 253.4-16zm98.7 528c-129.2 0-236-95.7-253.5-220 34.6 1.5 69.6-11 96-37.4l45.5-45.5c.6 17.2 14.7 30.9 32 30.9 17.7 0 32-14.3 32-32 0-17.3-13.7-31.4-30.9-32l32-32c-21.9-21.9-45.9-45.9-72-72 51.7-51.7 60.8-60.8 66.7-66.7 16.8-3.5 34.3-5.3 52.2-5.3 141.4 0 256 114.6 256 256s-114.6 256-256 256zm0-144c-38.2 0-72-19.1-92.2-48.5l-39.5 27.3c28.8 41.8 77.1 69.2 131.7 69.2S455 388.6 483.9 346.8l-39.5-27.3c-20.2 29.3-54 48.5-92.2 48.5zm80-128a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "hand-horns": [384, 512, [], "e1a9", "M32 0l64 0 0 240-64 0 0-240zM224 160l64 0 0 128-64 0 0-128zm-32-32l0 112-64 0 0-112 64 0zM320 64l64 0 0 288c0 88.4-71.6 160-160 160l-61.7 0c-42.4 0-83.1-16.9-113.1-46.9L37.5 453.5C13.5 429.5 0 396.9 0 363l0-91 192 0 0 80-112 0 0 32 144 0 0-64 96 0 0-256z"],
    "file-exclamation": [384, 512, [], "f31a", "M384 144L384 512 0 512 0 0 240 0 384 144zM164 404l0 56 56 0 0-56-56 0zm-4-180l12.8 144 38.4 0 12.8-144-64 0zm48-48L325.5 176 208 58.5 208 176z"],
    "head-side-circuit": [512, 512, [], "e75e", "M67.5 63.8C25.8 104.4 0 161.2 0 224 0 285 24.4 340.4 64 380.8l0 131.2 256 0 0-64 112 0 0-128 64 0 0-64-49.7-59.6c-6.4-51.7-30.4-98-65.8-132.6l-40.5 40.5 0 53.1c12 6.9 20 19.8 20 34.6 0 22.1-17.9 40-40 40s-40-17.9-40-40c0-14.8 8-27.7 20-34.6l0-69.6 5.9-5.9 43.5-43.5C318.8 17.6 282.8 4.3 244 .9l0 92.5c12 6.9 20 19.8 20 34.6 0 22.1-17.9 40-40 40s-40-17.9-40-40c0-14.8 8-27.7 20-34.6L204 .9C165.2 4.3 129.2 17.6 98.6 38.3l43.5 43.5 5.9 5.9 0 69.6c12 6.9 20 19.8 20 34.6 0 22.1-17.9 40-40 40s-40-17.9-40-40c0-14.8 8-27.7 20-34.6l0-53.1-40.5-40.5zM184 256a40 40 0 1 1 80 0 40 40 0 1 1 -80 0z"],
    "pipe-circle-check": [576, 512, [], "e436", "M96 96l0 32 384 0 0-32 64 0 0 148c-31.5-22.7-70.2-36-112-36-100.6 0-183.2 77.4-191.3 176l-144.7 0 0 32-64 0 0-320 64 0zM288 400a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm214.4-51.5l-25.9-18.8-9.4 12.9-53 72.9C393.7 395 381 382.3 376 377.4L353.4 400c2.8 2.8 19.9 19.9 51.3 51.3l13.2 13.2 11-15.1 64-88 9.4-12.9z"],
    "splotch": [512, 512, [], "f5bc", "M256 0l80 0 30.9 103c10.8 35.9 37.7 64.7 72.8 77.9l72.3 27.1 0 64-73.2 54.9c-34 25.5-52 67-47.3 109.3l8.4 75.9-96 0-73.3-58.6c-4.5-3.6-9.3-6.7-14.5-9.2-15.8-7.9-33.7-10.4-51-7.3L16 464 16 376 40.3 346.9c14.6-17.4 22.6-39.4 22.6-62.1 0-18.8-5.5-37.2-15.8-53L0 160 0 80 101.1 97.2c44 7.5 88.5-10.1 115.5-45.5L256 0z"],
    "square-shekel": [448, 512, [], "e735", "M448 32l-448 0 0 448 448 0 0-448zM352 160l0 144c0 39.8-32.2 72-72 72l-112 0c0-2.7 0-45.3 0-128l0-24 48 0c0 6.7 0 41.3 0 104l64 0c13.3 0 24-10.7 24-24l0-168 48 0 0 24zM120 136l88 0c39.8 0 72 32.2 72 72l0 80-48 0 0-80c0-13.3-10.7-24-24-24l-64 0 0 192-48 0 0-240 24 0z"],
    "up-long": [384, 512, ["long-arrow-alt-up"], "f30c", "M192-32l-192 192 128 0 0 384 128 0 0-384 128 0-192-192z"],
    "face-unamused": [512, 512, [], "e39f", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm-63.7-89.6l-42.4-22.5C170 361.9 210 336 256 336s86 25.9 106.1 63.9l-42.4 22.5C307.6 399.5 283.6 384 256 384s-51.6 15.5-63.7 38.4zM120 192l64 0c22.1 0 40 17.9 40 40s-17.9 40-40 40c-19.4 0-35.5-13.7-39.2-32l-48.8 0 0-48 24 0zm168 0l88 0c22.1 0 40 17.9 40 40s-17.9 40-40 40c-19.4 0-35.5-13.7-39.2-32l-48.8 0 0-48z"],
    "circle-indian-rupee": [512, 512, [], "e734", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM184 120l168 0 0 32-60.1 0c9.3 11.3 15.9 25 18.7 40l41.4 0 0 32-41.4 0c-6.1 33-30.5 59.5-62.3 68.6 55.9 44.7 85.7 68.6 89.5 71.6l-30 37.5-18.7-15-112-89.6-9-7.2 0-41.9 56 0c16.4 0 30.5-9.9 36.7-24l-100.7 0 0-32 100.7 0c-6.2-14.1-20.3-24-36.7-24l-64 0 0-48 24 0z"],
    "spinner-scale": [448, 512, [], "e62a", "M276 12l0 52c0 28.7-23.3 52-52 52s-52-23.3-52-52l0-52 104 0zM224 416c17.7 0 32 14.3 32 32l0 32-64 0 0-32c0-17.7 14.3-32 32-32zM448 288l-32 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l32 0 0 64zM64 256c0 17.7-14.3 32-32 32l-32 0 0-64 32 0c17.7 0 32 14.3 32 32zM359.8 41l79.2 79.2-39.6 39.6c-21.9 21.9-57.3 21.9-79.2 0s-21.9-57.3 0-79.2L359.8 41zM110.9 369.1c12.5 12.5 12.5 32.8 0 45.3L88.2 437 43 391.8 65.6 369.1c12.5-12.5 32.8-12.5 45.3 0zM359.8 437l-22.6-22.6c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0L405 391.8 359.8 437zM122.2 154.2c-18.7 18.7-49.1 18.7-67.9 0l-33.9-33.9 67.9-67.9 33.9 33.9c18.7 18.7 18.7 49.1 0 67.9z"],
    "hexagon-nodes": [448, 512, [], "e699", "M280 56c0 22.3-13.1 41.6-32 50.6l0 98.8c3.4 1.6 6.6 3.6 9.6 5.8L280 224l0 32 0 4.4 80 45.7c2.6-1.8 5.2-3.3 8-4.6l0-90.8c-2.8-1.3-5.5-2.9-8-4.7l-48 27.4 0-9.4 0-18.6-16.1-9.2-7.8-4.5 48.1-27.5c-1.6-20.8 8.6-41.6 27.8-52.8c26.8-15.5 61-6.3 76.5 20.5s6.3 61-20.5 76.5c-1.3 .8-2.7 1.5-4 2.1l0 90.8c1.4 .6 2.7 1.3 4 2.1c26.8 15.5 36 49.7 20.5 76.5s-49.7 36-76.5 20.5c-19.3-11.1-29.4-32-27.8-52.8L256 301.9c-2.5 1.8-5.2 3.3-8 4.7l0 98.8c18.9 9 32 28.3 32 50.6c0 30.9-25.1 56-56 56s-56-25.1-56-56c0-22.3 13.1-41.6 32-50.6l0-98.8c-3.4-1.6-6.6-3.6-9.6-5.8L168 288l0-32 0-4.4L88 206c-2.6 1.8-5.3 3.3-8 4.7l0 90.8c2.8 1.3 5.5 2.9 8 4.7l48-27.4 0 9.4 0 18.6 16.1 9.2 7.8 4.5-48.1 27.5c1.6 20.8-8.6 41.7-27.8 52.8C57.2 416 23 406.8 7.5 380S1.2 319 28 303.5c1.3-.8 2.6-1.5 4-2.1l0-90.8c-1.3-.6-2.7-1.3-4-2.1C1.2 193-8 158.8 7.5 132S57.2 96 84 111.5c19.3 11.1 29.4 32 27.9 52.8L192 210.1c2.5-1.8 5.2-3.3 8-4.7l0-98.8c-18.9-9-32-28.3-32-50.6c0-30.9 25.1-56 56-56s56 25.1 56 56z"],
    "hospital": [576, 512, [127973, 62589, "hospital-alt", "hospital-wide"], "f0f8", "M128 0l320 0 0 128 128 0 0 384-576 0 0-384 128 0 0-128zM336 352l-96 0 0 112 96 0 0-112zM128 384l0-64-64 0 0 64 64 0zM64 256l64 0 0-64-64 0 0 64zM512 384l0-64-64 0 0 64 64 0zM448 256l64 0 0-64-64 0 0 64zM264 96l0 48-48 0 0 48 48 0 0 48 48 0 0-48 48 0 0-48-48 0 0-48-48 0z"],
    "face-relieved": [512, 512, [], "e389", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm68-248c0 11 9 20 20 20l16 0c11 0 20-9 20-20l0-16 40 0 0 16c0 33.1-26.9 60-60 60l-16 0c-33.1 0-60-26.9-60-60l0-16 40 0 0 16zM152 284l16 0c11 0 20-9 20-20l0-16 40 0 0 16c0 33.1-26.9 60-60 60l-16 0c-33.1 0-60-26.9-60-60l0-16 40 0 0 16c0 11 9 20 20 20zm40.3 77.6C204.4 384.5 228.4 400 256 400s51.6-15.5 63.7-38.4l42.4 22.5C342 422.1 302 448 256 448s-86-25.9-106.1-63.9l42.4-22.5zm6-230.7l-6.3 2.1c-22.8 7.6-42.4 22.6-55.7 42.6l-7.6 11.5-33.3-22.2 7.6-11.5c18.3-27.4 45.1-47.9 76.3-58.3l6.3-2.1 12.6 37.9zM320 133.1l-6.3-2.1 12.6-37.9 6.3 2.1c31.2 10.4 58.1 30.9 76.3 58.3l7.6 11.5-33.3 22.2-7.6-11.5c-13.3-20-32.9-35-55.7-42.6z"],
    "square-peruvian-soles": [448, 512, [], "e716", "M448 480l-448 0 0-448 448 0 0 448zM315.6 128l-70.7 247.4-2.5 8.6 49.9 0 70.7-247.4 2.5-8.6-49.9 0zM159.6 152c-35.1 0-63.6 28.5-63.6 63.6 0 30.3 21.4 56.4 51.1 62.3l16.4 3.3c7.3 1.5 12.5 7.8 12.5 15.3 0 8.6-7 15.6-15.6 15.6l-56.4 0 0 48 56.4 0c35.1 0 63.6-28.5 63.6-63.6 0-30.3-21.4-56.4-51.1-62.3l-16.4-3.3c-7.3-1.5-12.5-7.8-12.5-15.2 0-8.6 7-15.6 15.6-15.6l48.4 0 0-48-48.4 0z"],
    "comment-smile": [512, 512, [], "f4b4", "M512 240c0 132.5-114.6 240-256 240-38.3 0-74.7-7.9-107.3-22.1L0 512 55.7 389.5C20.8 348.5 0 296.5 0 240 0 107.5 114.6 0 256 0S512 107.5 512 240zM192 224a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm128 0a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM166.6 280l-35.8 32c30.7 34.3 75.5 56 125.2 56s94.5-21.7 125.2-56l-35.8-32c-22 24.6-53.9 40-89.4 40s-67.4-15.4-89.4-40z"],
    "folder-check": [512, 512, [], "e64e", "M224 32l64 48 224 0 0 368-512 0 0-416 224 0zm89.4 161.9L227.8 311.6c-19.3-20-33.7-34.9-43.2-44.7l-34.5 33.3c6.2 6.4 27.2 28.1 63.1 65.3l19.8 20.6 16.8-23.1 102.4-140.8 14.1-19.4-38.8-28.2-14.1 19.4z"],
    "currency-sign": [448, 512, [], "e72b", "M49.4 47L32.4 30.1-1.5 64c4.6 4.6 29.4 29.4 74.3 74.3-25.3 32.5-40.3 73.4-40.3 117.7s15 85.2 40.3 117.7C27.8 418.7 3.1 443.4-1.5 448l33.9 33.9c4.6-4.6 29.4-29.4 74.3-74.3 32.5 25.3 73.4 40.3 117.7 40.3s85.2-15 117.7-40.3c44.9 44.9 69.7 69.7 74.3 74.3L450.4 448c-4.6-4.6-29.4-29.4-74.3-74.3 25.3-32.5 40.3-73.4 40.3-117.7s-15-85.2-40.3-117.7C421 93.3 445.8 68.6 450.4 64L416.4 30.1c-4.6 4.6-29.4 29.4-74.3 74.3-32.5-25.3-73.4-40.3-117.7-40.3s-85.2 15-117.7 40.3L49.4 47zM95.6 256a128.4 128.4 0 1 1 256.9 0 128.4 128.4 0 1 1 -256.9 0z"],
    "chart-user": [640, 512, ["user-chart"], "f6a3", "M128 32l480 0 0 416-295.6 0-52.9-120.8c8-16.7 12.5-35.4 12.5-55.2 0-70.7-57.3-128-128-128-5.4 0-10.8 .3-16 1l0-113zM446.1 160L368 238.1c-23-23-39-39-48-48L286.1 224c6.1 6.1 27.8 27.8 65 65l17 17 17-17 95-95 0 54.1 48 0 0-136-136 0 0 48 54.1 0zM64 272a80 80 0 1 1 160 0 80 80 0 1 1 -160 0zM56 384l176 0 56 128-288 0 56-128z"],
    "person-harassing": [576, 512, [], "e549", "M192 96a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM59.4 304.5l28.6-47.5 0 255.1 64 0 0-160 16 0 0 160 64 0 0-276.4 60.1 72.8 49.3-40.8-105.7-128-9.6-11.6-135.3 0-9.3 15.5-76.9 128 54.9 33zM480 240a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zm18.7 48l-34.7 34.7 0 80-41.4-41.4-49.8 5.7c-37.2 59.5-58.8 94.1-65 103.9l54.3 33.9c9.7-15.5 24.2-38.8 43.6-69.8l57.6 57.6c12.4 12.4 29.1 19.3 46.6 19.3 36.4 0 65.9-29.5 65.9-65.9l0-158.1-77.3 0zM288 32l0 32 88 0 0-32-88 0zm-.8 65.7l-14.3-7.2-14.3 28.6c3.9 2 24.7 12.4 62.3 31.2l14.3 7.2 14.3-28.6c-3.9-2-24.7-12.4-62.3-31.2z"],
    "flatbread": [512, 512, [129747], "e40b", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM177 369L143 335 335 143 369 177 177 369zm64-224L145 241 111 207 207 111 241 145zm64 256L271 367 367 271 401 305 305 401z"],
    "circle-microphone-lines": [512, 512, ["microphone-circle-alt"], "e117", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM208 240l0-128 96 0 0 32-48 0 0 32 48 0 0 32-48 0 0 32 48 0c0 26.5-21.5 48-48 48s-48-21.5-48-48zm-48-32l0 32c0 53 43 96 96 96s96-43 96-96l0-32 48 0 0 32c0 71.4-51.9 130.6-120 142l0 42-48 0 0-42c-68.1-11.4-120-70.7-120-142l0-32 48 0z"],
    "money-bill-trend-up": [512, 512, [], "e529", "M480 8l0 125.8-48 0 0-67.9-127 127-15.7 15.7-16.9-14.5-96.4-82.6-96.4 82.6-18.2 15.6-31.2-36.4 18.2-15.6 112-96 15.6-13.4 15.6 13.4 95.1 81.5 111.3-111.3-67.9 0 0-48 149.8 0 0 24zM0 256l512 0 0 256-512 0 0-256zM48 416l0 48 48 0c0-26.5-21.5-48-48-48zM96 304l-48 0 0 48c26.5 0 48-21.5 48-48zM464 416c-26.5 0-48 21.5-48 48l48 0 0-48zM416 304c0 26.5 21.5 48 48 48l0-48-48 0zm-96 80a64 64 0 1 0 -128 0 64 64 0 1 0 128 0z"],
    "pen-ruler": [576, 512, ["pencil-ruler"], "f5ae", "M254.4 77.8L222.5 45.9c-44.6 44.6-68 68-70.4 70.4L123.8 88c2.4-2.4 25.9-25.9 70.4-70.4-.2-.2-11.6-11.6-34.1-34.1-8.9 8.9-47.7 47.7-116.3 116.3L15.5 128c12.6 12.6 44 44 94.3 94.3L254.4 77.8zm67.3 356.4c50.3 50.3 81.8 81.8 94.3 94.3l144.6-144.6-28.3-28.3-5.9-5.9c-44.6 44.5-68 68-70.4 70.4L427.8 392c2.4-2.4 25.9-25.9 70.4-70.4l-31.9-31.9-144.6 144.6zM72.1 328l-56 200 200-56 223-223-144-144-223 223zm488-200l-144-144-87 87 144 144 87-87z"],
    "brackets-square": [448, 512, ["brackets"], "f7e9", "M416 32l32 0 0 448-160 0 0-64 96 0 0-320-96 0 0-64 128 0zM32 32l128 0 0 64-96 0 0 320 96 0 0 64-160 0 0-448 32 0z"],
    "person-dress-simple": [256, 512, [], "e21c", "M64 64A64 64 0 1 1 192 64 64 64 0 1 1 64 64zm128 96l64 224-64 0 0 128-128 0 0-128-64 0 64-224 128 0z"],
    "train-subway-tunnel": [512, 512, ["subway-tunnel"], "e2a3", "M256 0C114.6 0 0 114.6 0 256l0 256 94.1 0 64-64-46.1 0 0-320 288 0 0 320-46.1 0 64 64 94.1 0 0-256C512 114.6 397.4 0 256 0zm94.1 512l-64-64-60.1 0-64 64 188.1 0zM280 320l72 0 0-128-72 0 0 128zM232 192l-72 0 0 128 72 0 0-128zM184 400a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm168-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"],
    "repeat": [512, 512, [128257], "f363", "M352 208l0-80-288 0 0 160-64 0 0-224 352 0 0-80 24 0 112 112-112 112-24 0zM160 448l0 80-24 0-112-112 112-112 24 0 0 80 288 0 0-160 64 0 0 224-352 0z"],
    "bottle-baby": [320, 512, [], "e673", "M96 64l0-32 32-16 0-16c0-17.7 14.3-32 32-32s32 14.3 32 32l0 16 32 16 0 32 32 0 0 48-192 0 0-48 32 0zM16 224l48-64 192 0 48 64 0 320-288 0 0-96 112 0 0-48-112 0 0-64 112 0 0-48-112 0 0-64z"],
    "bone": [640, 512, [129460], "f5d7", "M190.7 160c-7.6-45.4-47.1-80-94.7-80-53 0-96 43-96 96 0 33.4 17 62.8 42.9 80-25.9 17.2-42.9 46.6-42.9 80 0 53 43 96 96 96 47.6 0 87.1-34.6 94.7-80l258.7 0c7.6 45.4 47.1 80 94.7 80 53 0 96-43 96-96 0-33.4-17-62.8-42.9-80 25.9-17.2 42.9-46.6 42.9-80 0-53-43-96-96-96-47.6 0-87.1 34.6-94.7 80l-258.7 0z"],
    "right-left-large": [640, 512, [], "e5e1", "M256.3 176l0-71.9c-17.8 16.1-89 80.1-213.4 192.1L16.5 320 42.9 343.8c124.4 112 195.6 176 213.4 192.1l0-119.9 64 0 0-64-128 0 0 40.1-80.2-72.1 80.2-72.1 0 40.1 192 0 0 119.9c17.8-16.1 89-80.1 213.4-192.1l26.4-23.8-26.4-23.8C473.3 56.2 402.2-7.8 384.3-23.9l0 119.9-64 0 0 64 128 0 0-40.1 80.2 72.1-80.2 72.1 0-40.1-192 0 0-48z"],
    "strawberry": [576, 512, [], "e32b", "M408-24L431.4-.6c31.2 31.2 31.2 81.9 0 113.1 31.2-31.2 81.9-31.2 113.1 0L568 136 544.6 159.4c-31.2 31.2-81.9 31.2-113.1 0-15.6-15.6-31.2-31.2-46.9-46.9-31.2-31.2-31.2-81.9 0-113.1L408-24zM32 336c0-176 96.2-272 192.2-272 32.7 .1 65.3 12.6 90.3 37.5l128 128c25 25 37.5 57.8 37.5 90.5 0 96-96 192-272 192l-176 0 0-176zM214.4 137.6c2.8 28.8-16 47.6-44.8 44.8-2.8-28.8 16-47.6 44.8-44.8zm-32 96c2.8 28.8-16 47.6-44.8 44.8-2.8-28.8 16-47.6 44.8-44.8zm64 64c2.8 28.8-16 47.6-44.8 44.8-2.8-28.8 16-47.6 44.8-44.8zm64 64c2.8 28.8-16 47.6-44.8 44.8-2.8-28.8 16-47.6 44.8-44.8zm-160-32c2.8 28.8-16 47.6-44.8 44.8-2.8-28.8 16-47.6 44.8-44.8zm64 64c2.8 28.8-16 47.6-44.8 44.8-2.8-28.8 16-47.6 44.8-44.8zm64-192c2.8 28.8-16 47.6-44.8 44.8-2.8-28.8 16-47.6 44.8-44.8zm64 64c2.8 28.8-16 47.6-44.8 44.8-2.8-28.8 16-47.6 44.8-44.8zm64 64c2.8 28.8-16 47.6-44.8 44.8-2.8-28.8 16-47.6 44.8-44.8z"],
    "square-bolt": [448, 512, [], "e265", "M448 32l-448 0 0 448 448 0 0-448zM88 272l200-168-32.4 136 104.4 0-200 168 32.4-136-104.4 0z"],
    "fire-flame-curved": [384, 512, ["fire-alt"], "f7e4", "M168.3 31.8L208 0 208 43.5c0 13.1 5.4 25.7 14.9 34.7L307.6 159C356.4 205.6 384 270.2 384 337.7 384 434 306 512 209.7 512l-29.9 0C80.5 512 0 431.5 0 332.2 0 274.6 28.8 220.8 76.7 188.9L96 176 96 288c0 35.3 28.7 64 64 64s64-28.7 64-64l0-3.9c0-18-7.2-35.3-19.9-48l-44.7-44.7c-20.1-20.1-31.4-47.4-31.4-75.9 0-32.6 14.8-63.4 40.3-83.8z"],
    "signature-slash": [640, 512, [], "e3cb", "M81.2-16.9l-17-17-33.9 33.9 17 17 512 512 17 17 33.9-33.9c-1-1-33-33-96.1-96.1l126 0 0-48-174 0-48-48 158 0 0-64-115.6 0c11.7-35.2 24.2-72.6 37.5-112.4-28.8 8.6-89.3 26.8-181.4 54.4 2.4-20.7 3.6-41.4 3.6-62.3l0-7.8c0-53-43-96-96-96-26 0-49.6 10.3-66.9 27.1l-76-76zM202.4 104.4c5.7-5.2 13.3-8.4 21.6-8.4 17.7 0 32 14.3 32 32l0 7.8c0 7.2-.2 14.5-.5 21.7l-53.1-53.1zM352.2 254.2l46-13.8-12.5 37.5-2.4 7.3-31-31zm26 161.8l-48-48-7.1 0c-6.5 16.3-13.7 32.3-21.6 48l76.7 0zM196.3 234.1c-60.8 18.2-94.2 28.3-100.3 30.1l0 103.8-96 0 0 48 96 0 0 64 114.6 0c3.4-6 15-26.3 34.8-60.8 17.1-29.9 31.2-61.2 42.3-93.7l-91.4-91.4zm35.6 56.2c-10.4 33.8-24.5 66.4-42.1 97.2l-16.3 28.6-13.4 0 0-104.2 71.8-21.5z"],
    "bus-simple": [448, 512, ["bus-alt"], "f55e", "M448 0l-448 0 0 448 32 0 0 64 96 0 0-64 192 0 0 64 96 0 0-64 32 0 0-448zM64 96l320 0 0 160-320 0 0-160zM96 320a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm256 0a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "square-peseta": [448, 512, [], "e6ea", "M448 32l-448 0 0 448 448 0 0-448zM144 120l88 0c52 0 95.1 38.2 102.8 88l25.2 0 0 32-25.2 0c-7.7 49.8-50.8 88-102.8 88l-40 0 0 64-48 0 0-152-24 0 0-32 24 0 0-88zm88 48l-40 0 0 40 93.7 0c-6.9-23.1-28.3-40-53.7-40zM192 280l40 0c25.4 0 46.8-16.9 53.7-40l-93.7 0 0 40z"],
    "tank-water": [448, 512, [], "e452", "M224 0l60.2 93.7c7.7 12 11.8 25.9 11.8 40.1l0 2.2c0 39.8-32.2 72-72 72s-72-32.2-72-72l0-2.2c0-14.2 4.1-28.2 11.8-40.1L224 0zM64 32l82.4 0-23 35.7C117.7 76.6 113.2 86.1 110 96l-46 0 0 174.2c24.4-9.8 37.8-15.1 40-16l8.9 3.6 111.1 44.4 111.1-44.4 8.9-3.6c2.2 .9 15.6 6.2 40 16l0-174.1-46 0c-3.2-9.9-7.7-19.4-13.4-28.3l-23-35.7 146.4 0 0 448-448 0 0-448 64 0z"],
    "user-shakespeare": [448, 512, [], "e2c2", "M304 144c0 38.7-27.5 71-64 78.4l0-22.4-32 0 0 22.4c-36.5-7.4-64-39.7-64-78.4l0-16c0-44.2 35.8-80 80-80s80 35.8 80 80l0 16zM224 0C153.3 0 96 57.3 96 128l0 24-32 56 0 48 98 0c18.4 10.2 39.5 16 62 16s43.6-5.8 62-16l98 0 0-48-32-56 0-24C352 57.3 294.7 0 224 0zm7.2 137.7l-7.2-3.6c-.6 .3-13.7 6.8-39.2 19.6l-14.3 7.2 14.3 28.6c7.8-3.9 20.8-10.4 39.2-19.6 18.3 9.2 31.4 15.7 39.2 19.6l14.3-28.6-46.3-23.2zM64 320l-64 192 200 0 0-128 48 0 0 128 200 0-64-192-32 0 0-16-54.6 0c-22.3 10.3-47.2 16-73.4 16s-51.1-5.7-73.4-16l-54.6 0 0 16-32 0z"],
    "venus-mars": [640, 512, [9892], "f228", "M480-64l-32 0 0 64 82.7 0-56.7 56.7c-26.3-15.7-57.1-24.7-90-24.7-35.4 0-68.4 10.5-96 28.5-27.6-18-60.6-28.5-96-28.5-97.2 0-176 78.8-176 176 0 86.3 62.1 158.1 144 173.1l0 34.9-64 0 0 64 64 0 0 64 64 0 0-64 64 0 0-64-64 0 0-34.9c23.3-4.3 44.9-13.1 64-25.6 27.6 18 60.6 28.5 96 28.5 97.2 0 176-78.8 176-176 0-41.1-14.1-79-37.8-109l53.8-53.8 0 82.7 64 0 0-192-160 0zM336 309.2c20.2-28.6 32-63.5 32-101.2s-11.8-72.6-32-101.2c14.6-6.9 30.8-10.8 48-10.8 61.9 0 112 50.1 112 112S445.9 320 384 320c-17.2 0-33.5-3.9-48-10.8zM288 150.3c10.2 16.9 16 36.6 16 57.7s-5.8 40.9-16 57.7c-10.2-16.9-16-36.6-16-57.7s5.8-40.9 16-57.7zm-48-43.5c-20.2 28.6-32 63.5-32 101.2s11.8 72.6 32 101.2c-14.5 6.9-30.8 10.8-48 10.8-61.9 0-112-50.1-112-112S130.1 96 192 96c17.2 0 33.5 3.9 48 10.8z"],
    "kazoo": [640, 512, [], "f8c7", "M448.2-45.3l22.6 22.6 128 128 22.6 22.6c-2.8 2.8-42.5 42.5-119 119-9.9 65.6-61.7 117.4-127.3 127.3l-48.3 48.3-2.8 2.8-3.4 2-160 96-21.4 12.9c-4.1-4.1-31.3-31.3-81.7-81.7l-17.7-17.7 12.9-21.4 96-160 2-3.4 2.8-2.8 48.4-48.4c9.9-65.5 61.7-117.3 127.3-127.3 76.5-76.5 116.2-116.2 119-119zM352.3 328a104 104 0 1 0 0-208 104 104 0 1 0 0 208zm20-149.2l0 25.3 45.3 0 0 40-45.3 0 0 45.3-40 0 0-45.3-45.3 0 0-40 45.3 0 0-45.3 40 0 0 20z"],
    "diagram-subtask": [448, 512, [], "e479", "M0 32l448 0 0 192-320 0 0 128 64 0 0-64 256 0 0 192-256 0 0-64-128 0 0-192-64 0 0-192z"],
    "arrows-from-dotted-line": [384, 512, [], "e0a3", "M80 96l112-128 112 128-80 0 0 80-64 0 0-80-80 0zm0 320l80 0 0-80 64 0 0 80 80 0-112 128-112-128zM0 224l64 0 0 64-64 0 0-64zm170.7 0l0 64-64 0 0-64 64 0zm42.7 0l64 0 0 64-64 0 0-64zM384 224l0 64-64 0 0-64 64 0z"],
    "grip-dots": [512, 512, [], "e410", "M64 224a64 64 0 1 1 0-128 64 64 0 1 1 0 128zM256 96a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm192 0a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm0 192a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM256 416a64 64 0 1 1 0-128 64 64 0 1 1 0 128zM64 288a64 64 0 1 1 0 128 64 64 0 1 1 0-128z"],
    "blender": [512, 512, [], "f517", "M0 0l480 0-22.9 80-137.1 0 0 48 123.4 0-18.3 64-105.1 0 0 48 91.4 0-27.4 96-256 0-9.1-96-118.9 0 0-240zM114.3 192l-13.7-144-52.6 0 0 144 66.3 0zM416 384l0 128-320 0 0-128 320 0zM256 472a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"],
    "u": [384, 512, [117], "55", "M64 32l0 256c0 70.7 57.3 128 128 128s128-57.3 128-128l0-256 64 0 0 256c0 106-86 192-192 192S0 394 0 288L0 32 64 32z"],
    "box-heart": [448, 512, [], "f49d", "M369.4 128l-121.4 0 0-48 87.1 0 34.3 48zM200 128l-121.4 0 34.3-48 87.1 0 0 48zM368 16l-288 0-80 112 0 352 448 0 0-352-80-112zM217.6 231.5l6.4 8.5 6.4-8.5c11.1-14.8 28.5-23.5 46.9-23.5 32.4 0 58.7 26.3 58.7 58.7l0 5.3c0 64-112 128-112 128S112 336 112 272l0-5.3c0-32.4 26.3-58.7 58.7-58.7 18.5 0 35.9 8.7 46.9 23.5z"],
    "lightbulb-cfl": [320, 512, [], "e5a6", "M160 64l0-64C149.1 2.2 95.8 12.8 0 32L0 96 134.8 69 160 64zm160 0l-320 64 0 64 320-64 0-64zM0 288l320-64 0-64-320 64 0 64zM256 512l0-128-32 0 0-44.8 96-19.2 0-64-144 28.8 0 99.2-32 0 0-92.2-48 9.6 0 82.6-32 0 0 128 192 0z"],
    "share": [576, 512, ["mail-forward"], "f064", "M560.2 208l-239.8-215.9 0 135.9-112 0c-97.2 0-176 78.8-176 176 0 128 128 176 128 176s-32-32-32-80c0-61.9 50.1-112 112-112l80 0 0 135.9 239.8-215.9z"],
    "cassette-vhs": [512, 512, [128252, "vhs"], "f8ec", "M0 64l512 0 0 80-512 0 0-80zM0 192l512 0 0 256-512 0 0-256zm88.4 64C73.2 273 64 295.4 64 320s9.2 47 24.4 64l71.6 0 0-24c-22.1 0-40-17.9-40-40s17.9-40 40-40l0-24-71.6 0zm192 128l23.6 0 0-128-96 0 0 128 72.4 0zm143.1 0c15.2-17 24.4-39.4 24.4-64s-9.2-47-24.4-64l-71.6 0 0 24c22.1 0 40 17.9 40 40s-17.9 40-40 40l0 24 71.6 0z"],
    "phone-flip": [512, 512, [128381, "phone-alt"], "f879", "M512.1 64l-128-64-96.8 128 80.8 80c-33 70.4-89.6 127-160 160l-80-80.8-128 96.8 64 128 16 0c238.6 0 432-193.4 432-432l0-16z"],
    "face-swear": [640, 512, [], "e399", "M320-32C456-32 567.2 74.1 575.5 208l-511 0C72.8 74.1 184-32 320-32zM240 176c17.7 0 32-14.3 32-32l0-.3c4.9 1.6 14.5 4.8 28.6 9.6l12.6-37.9-19-6.3-96-32-19-6.3-12.6 37.9c11 3.7 27 9 47.8 15.9-4.1 5.4-6.6 12.1-6.6 19.4 0 17.7 14.3 32 32 32zm192-32c0-7.3-2.4-14-6.6-19.4 20.9-7 36.8-12.3 47.8-15.9l-12.6-37.9-19 6.3-96 32-19 6.3 12.6 37.9c14.2-4.7 23.7-7.9 28.6-9.6l0 .3c0 17.7 14.3 32 32 32s32-14.3 32-32zM0 256l640 0 0 256-640 0 0-256zM416 368l0-32-32 0 0-32-32 0 0 32-32 0 0-32-32 0 0 32-32 0 0 32 32 0 0 32-32 0 0 32 32 0 0 32 32 0 0-32 32 0 0 32 32 0 0-32 32 0 0-32-32 0 0-32 32 0zm-64 0l0 32-32 0 0-32 32 0zm220.1-29.6l10.4-12.1-24.3-20.8-10.4 12.1-96 112-10.4 12.1 24.3 20.8 10.4-12.1 96-112zM224 304l-32 0 0 96 32 0 0-96zM96 320.5c-18.2 3.1-32 18.9-32 37.9 0 17.7 12 33 29.1 37.3l30 7.5c2.9 .7 4.9 3.3 4.9 6.3 0 3.6-2.9 6.5-6.5 6.5l-57.5 0 0 32 32 0 0 16 32 0 0-16.5c18.2-3.1 32-18.9 32-37.9 0-17.7-12-33-29.1-37.3l-30-7.5c-2.9-.7-4.9-3.3-4.9-6.3 0-3.6 2.9-6.5 6.5-6.5l49.5 0 0-32-24 0 0-16-32 0 0 16.5zM488 312l-40 0 0 40 40 0 0-40zm48 104l0 40 40 0 0-40-40 0zM192 432l0 32 32 0 0-32-32 0z"],
    "toilet-portable": [320, 512, [], "e583", "M0 0L0 80 320 80 320 0 0 0zM24 128l-24 0 0 384 48 0 0-32 224 0 0 32 48 0 0-384-296 0zm248 96l0 96-48 0 0-96 48 0z"],
    "circle-rupiah": [512, 512, [], "e706", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM152 144l48 0c39.8 0 72 32.2 72 72 0 26.9-14.7 50.3-36.5 62.6 14.8 44.3 23.7 71.2 26.8 80.5l-45.5 15.2C214 366 204.4 337.2 188 288l-12 0 0 80-48 0 0-224 24 0zm48 96c13.3 0 24-10.7 24-24s-10.7-24-24-24l-24 0 0 48 24 0zm88-16l64 0c35.3 0 64 28.7 64 64s-28.7 64-64 64l-16 0 0 56-48 0 0-184zm48 80l16 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0 0 32z"],
    "mobile-vibrate-slash": [640, 512, [], "e817", "M160.4 62l0-62 320 0 0 382 130.1 130.1-33.9 33.9-545.9-545.9 33.9-33.9 95.8 95.8zM474.6 512l-314.2 0 0-314.2 314.2 314.2zM256.4 464l102.3 0-48-48-54.3 0 0 48zM122.5 159.9l-40.1 40.1 38.1 38.1 0 35.9-38.1 38.1 48 48-33.9 33.9-81.9-81.9 56-56-56-56 74.1-74.1 33.9 33.9zM626.4 200l-56 56 56 56-73.9 73.9-33.9-33.9 40-40-38.1-38.1 0-35.9 38.1-38.1-48-48 33.9-33.9 81.9 81.9z"],
    "table-cells-column-unlock": [640, 512, [], "e690", "M256 288l0-64 153.3 0c17.1-42.2 56-73.2 102.7-79l0-113-448 0 0 448 304 0 0-64-112 0 0-64 112 0 0-64-112 0zm0-192l192 0 0 64-192 0 0-64zM528 240c17.7 0 32 14.3 32 32l48 0c0-44.2-35.8-80-80-80s-80 35.8-80 80l0 48-32 0 0 192 224 0 0-192-144 0 0-48c0-17.7 14.3-32 32-32z"],
    "person-pregnant": [384, 512, [], "e31e", "M192.4-32a56 56 0 1 1 0 112 56 56 0 1 1 0-112zm16 448l-32 0 0 128-64 0 0-128-49.8 0c4-14.7 17.8-66 41.4-153.8-21.2 31.8-36.8 55.2-46.8 70.2l-53.3-35.5 17.8-26.6 96-144 9.5-14.2 129.1 0 0 85.9 30.4 18.2c30.8 18.5 49.6 51.7 49.6 87.6 0 29.8-13 58.2-35.7 77.6l-28.3 24.3 0 138.4-64 0 0-128z"],
    "less-than": [512, 512, [62774], "3c", "M480 14L18.6 227 0 235.5 0 276.5 18.6 285.1 480 498 480 427.5 108.4 256 480 84.5 480 14z"],
    "image-circle-arrow-down": [640, 512, [], "e76c", "M512 32l-448 0 0 448 276 0c-13.7-19-24-40.7-30-64l-198 0 96-144 46.1 69.1 81.9-133.1 18.6 30.2c35.1-38.2 85.5-62.2 141.4-62.2 5.4 0 10.7 .2 16 .7L512 32zM192 112a48 48 0 1 1 0 96 48 48 0 1 1 0-96zM496 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm78.6-136l-11.3 11.3-56 56-11.3 11.3-11.3-11.3-56-56-11.3-11.3 22.6-22.6c4.6 4.6 18 18 40 40l0-105.4 32 0 0 105.4c22-22 35.4-35.4 40-40L574.6 376z"],
    "square-fragile": [448, 512, ["box-fragile", "square-wine-glass-crack"], "f49b", "M448 32l-448 0 0 448 448 0 0-448zM128 96l48 0 32 64-32 32 80 64-32-64 48-32-32-64 80 0 0 112c0 46.2-32.6 84.7-76 93.9l0 74.1 60 0 0 40-160 0 0-40 60 0 0-74.1c-43.4-9.2-76-47.8-76-93.9l0-112z"],
    "inbox-full": [512, 512, [], "e1ba", "M423.5 96l24 192-79.5 0-32 64-160 0-32-64-79.5 0 24-192 335 0zM32 32l-32 256 0 192 512 0 0-192-32-256-448 0zm120 96l-24 0 0 48 256 0 0-48-232 0zm0 80l-24 0 0 48 256 0 0-48-232 0z"],
    "film-canister": [576, 512, ["film-cannister"], "f8b7", "M96 0l160 0 0 32 96 0 0 64-32 0 0 352 32 0 0 64-352 0 0-64 32 0 0-352-32 0 0-64 96 0 0-32zM576 112l0 208-64 0 0 112-144 0 0-48 48 0 0-64-48 0 0-96 48 0 0-64-48 0 0-48 208 0zM96 112l0 320 48 0 0-320-48 0zm432 48l-64 0 0 64 64 0 0-64z"],
    "hammer-brush": [640, 512, [], "e620", "M0 137.7C0 91.7 23 48.7 61.3 23.1 83.9 8 110.5 0 137.7 0l86.3 0 48 32 16 0 0-32 64 0 0 160-64 0 0-32-16 0-48 32-96 0-48-32-80 32 0-22.3zM224 208l0 304-96 0 0-304 96 0zM448 448l-32 64-96 0 0-176 288 0 0 176-128 0-32-64zM320 256l96-64 0-192 96 0 0 192 96 64 0 32-288 0 0-32z"],
    "superscript": [576, 512, [], "f12b", "M448 0l96 0 0 160 32 0 0 64-128 0 0-64 32 0 0-96-32 0 0-64zM64 64l80.7 0 9.6 13.6 85.8 122.5 85.8-122.5 9.6-13.6 80.7 0 0 64-47.3 0-89.6 128 89.6 128 47.3 0 0 64-80.7 0-9.6-13.6-85.8-122.6-85.8 122.6-9.6 13.6-80.7 0 0-64 47.3 0 89.6-128-89.6-128-47.3 0 0-64z"],
    "uniform-martial-arts": [640, 512, [], "e3d1", "M180 0l57.7 0 69.9 144.7-54.6 143.3-109 0 0-154.9-48 87.3 0 195.7-96 0 0-220.3 5.9-10.8 88-160 13.7-24.9 72.4 0zM144 352l0-32 352 0 0 32-146.1 0 42.1 63.2 8.9 13.3-26.6 17.8-8.9-13.3-45.4-68.1-45.4 68.1-8.9 13.3-26.6-17.8c.4-.6 17.4-26.1 51-76.5L144 352zm77.3 45.5l-26.6 39.9 79.9 53.3c19.1-28.6 34.2-51.3 45.4-68.1 11.2 16.8 26.4 39.5 45.4 68.1l79.9-53.3c-20.7-31-32.6-48.8-35.6-53.4l86.3 0 0 128-352 0 0-128 86.3 0-9 13.5zM496 133.1l0 154.9-208.8 0c34.4-90.3 71-186.3 109.7-288l135.4 0 13.7 24.9 88 160 5.9 10.8 0 220.3-96 0 0-195.7-48-87.3z"],
    "circle-user-circle-user": [640, 512, [], "e7a5", "M496 208c-77.5 0-144.3 45.9-174.6 112l-145.4 0-23.9 71.6c34.8 34.8 82.8 56.4 135.9 56.4 7.4 0 14.6-.4 21.7-1.2 5.5 21.9 14.8 42.4 27.1 60.6-15.8 3-32.1 4.6-48.8 4.6-141.4 0-256-114.6-256-256S146.6 0 288 0c126.8 0 232.1 92.2 252.4 213.2-14.3-3.4-29.1-5.2-44.4-5.2zM288 272a72 72 0 1 0 0-144 72 72 0 1 0 0 144zm64 128a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm223.5 78.9l-15.5-30.9-128 0-15.5 30.9C436.8 499.4 464.9 512 496 512s59.2-12.6 79.5-33.1zM544 368a48 48 0 1 0 -96 0 48 48 0 1 0 96 0z"],
    "circle-stop": [512, 512, [62094, "stop-circle"], "f28d", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm96-352l0 192-192 0 0-192 192 0z"],
    "arrows-up-down": [320, 512, ["arrows-v"], "f07d", "M137.6 534.6l22.6 22.6 118.6-118.6 22.6-22.6-45.3-45.3c-12 12-33.3 33.3-64 64l0-357.5c30.7 30.7 52 52 64 64L301.5 96c-2.9-2.9-42.4-42.4-118.6-118.6L160.3-45.3C157.4-42.4 117.8-2.9 41.6 73.4L19 96 64.3 141.2c12-12 33.3-33.3 64-64l0 357.5c-30.7-30.7-52-52-64-64L19 416c2.9 2.9 42.4 42.4 118.6 118.6z"],
    "meter-droplet": [640, 512, [], "e1ea", "M566.5 201.8C568 203.6 569.7 205.4 571.4 207.4 548.7 89.2 444.8 0 320 0 178.6 0 64 114.6 64 256S178.6 512 320 512c15.6 0 30.9-1.4 45.8-4.1-13.8-24.1-21.8-51.9-21.8-81.8 0-33.2 10.4-65.4 23.2-93.1 13-28.1 29.9-54.4 46-76.6 16.2-22.3 32.3-41.3 44.4-54.7L512 146.7c3.4 3.3 6.8 6.7 10.2 10 15.1 14.7 30.1 29.4 44.2 45.1zM344 128l0 96-48 0 0-96 48 0zm-96 24l0 72-48 0 0-96 48 0 0 24zM632 426.1C632 331.9 512 214 512 214S392 331.9 392 426.1C392 491.2 445.7 544 512 544s120-52.8 120-117.9z"],
    "ornament": [448, 512, [], "f7b8", "M208 64.6L208 32c0-8.8 7.2-16 16-16s16 7.2 16 16l0 32.6c-10.5-.7-21.5-.7-32 0zm-48 8.7C98.8 91.5 48.6 135.2 21.6 192l404.9 0C399.4 135.2 349.2 91.5 288 73.3L288 32c0-35.3-28.7-64-64-64S160-3.3 160 32l0 41.3zM0 288c0 16.5 1.8 32.5 5.2 48l437.7 0c3.4-15.5 5.2-31.5 5.2-48s-1.8-32.5-5.2-48L5.2 240C1.8 255.5 0 271.5 0 288zm21.6 96c36 75.7 113.1 128 202.4 128s166.5-52.3 202.4-128L21.6 384z"],
    "display-slash": [640, 512, ["desktop-slash"], "e2fa", "M73.4-16.9l-17-17-33.9 33.9 17 17 512 512 17 17 33.9-33.9c-1-1-33-33-96.1-96.1l70 0 0-384-454 0-48.9-48.9zM186.3 96l326 0 0 256-70 0-256-256zm128 256l-186 0 0-186-64-64 0 314 208 0-16 48-96 0 0 48 314 0-48-48-42 0-16-48 10 0-64-64z"],
    "page-caret-up": [384, 512, ["file-caret-up"], "e42a", "M240 0L0 0 0 512 384 512 384 144 240 0zM96 336l0-24 96-104 96 104 0 24-192 0z"],
    "poo-storm": [512, 512, ["poo-bolt"], "f75a", "M352 64c0-53-48-96-112-96 0 0 64 112-48 112l-40 0c-48.6 0-88 39.4-88 88l0 43.3C27.1 221.8 0 255.7 0 296l0 88 67.5 0 219-184 78.3 0-32.4 136 91.6 0 0 48 88 0 0-88c0-40.3-27.1-74.2-64-84.7l0-43.3c0-48.6-39.4-88-88-88l-9.4 0c.9-5 1.4-10.4 1.4-16zM104 416l104.4 0-32.4 136 200-168-104.4 0 32.4-136-200 168z"],
    "video-slash": [576, 512, [], "f4e2", "M49.3-16.9l-17-17-33.9 33.9 17 17 512 512 17 17 33.9-33.9-17-17-145.2-145.2 0-286-286 0-80.9-80.9zM32.1 448l346.2 0-346.2-346.2 0 346.2zm544-32l0-320-112 74.7 0 170.7 112 74.7z"],
    "square-xmark": [448, 512, [10062, "times-square", "xmark-square"], "f2d3", "M448 32l-448 0 0 448 448 0 0-448zM140.1 305.9L190.1 256c-38.8-38.8-61.1-61.1-66.9-66.9l33.9-33.9 66.9 66.9c38.8-38.8 61.1-61.1 66.9-66.9l33.9 33.9c-5.8 5.8-28.1 28.1-66.9 66.9 38.8 38.8 61.1 61.1 66.9 66.9l-33.9 33.9c-5.8-5.8-28.1-28.1-66.9-66.9-38.8 38.8-61.1 61.1-66.9 66.9l-33.9-33.9 17-17z"],
    "message-dots": [512, 512, ["comment-alt-dots", "messaging"], "f4a3", "M0 32l0 416 128 0 0 96 160-96 224 0 0-416-512 0zM128 208a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm128 0a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm96 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"],
    "droplet-degree": [576, 512, ["dewpoint"], "f748", "M256 512C150 512 64 426 64 320S256-32 256-32 448 214 448 320 362 512 256 512zM528 80a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM416 80a80 80 0 1 1 160 0 80 80 0 1 1 -160 0z"],
    "tower-control": [512, 512, [], "e2a2", "M176.1 0l160 0 0 48-56 0 0 48 208.6 0c-.5 2.1-18.4 76.8-53.8 224l29.2 0 0 64-48 0 0 128-320 0 0-128-48 0 0-64 29.2 0C41.9 172.8 24 98.1 23.5 96l208.6 0 0-48-56 0 0-48zM407.5 160l-71.4 0 0 160 33 0 38.4-160zm-119.4 0l-64 0 0 160 64 0 0-160zm-112 0l-71.4 0 38.4 160 33 0 0-160z"],
    "circle-dong": [512, 512, [], "e723", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm16-400l48 0 0 32 32 0 0 32-32 0 0 176-48 0 0-6.7c-9.8 4.3-20.6 6.7-32 6.7-44.2 0-80-35.8-80-80s35.8-80 80-80c11.4 0 22.2 2.4 32 6.7l0-22.7-48 0 0-32 48 0 0-32zM240 240a32 32 0 1 0 0 64 32 32 0 1 0 0-64zM144 408l0-32 224 0 0 32-224 0z"],
    "burger-cheese": [512, 512, [127828, "cheeseburger"], "f7f1", "M32 480l0-80 448 0 0 80-448 0zM480 176l0 48-448 0 0-48S80 32 256 32 480 176 480 176zM248 272l72 48 72-48 120 0 0 80-512 0 0-80 248 0zM280 96a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM144 152a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm248-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"],
    "hand-holding-droplet": [576, 512, ["hand-holding-water"], "f4c1", "M288 0L211.2 102.4c-12.5 16.6-19.2 36.8-19.2 57.6 0 53 43 96 96 96s96-43 96-96c0-20.8-6.7-41-19.2-57.6L288 0zM137.4 313.4l-70.6 70.6-66.7 0 0 128 396.4 0 10.2-7c101.2-69.6 154.8-106.4 161-110.7l-45.3-65.9c-11.7 8.1-54.2 37.3-127.5 87.6l-138.8 0 0-48 128 0 0-64-237.3 0-9.4 9.4z"],
    "won-sign": [576, 512, [8361, "krw", "won"], "f159", "M94.6 54.5l-9.5-30.5-61.1 19.1 9.5 30.5 52 166.5-45.5 0 0 48 60.5 0 53 169.5 7 22.5 65.5 0 5.3-25.5 34.7-166.5 44 0 34.7 166.5 5.3 25.5 65.5 0 7-22.5 53-169.5 60.5 0 0-48-45.5 0 52-166.5 9.5-30.5-61.1-19.1-9.5 30.5-58 185.5-58.1 0-38-182.5-5.3-25.5-68 0-5.3 25.5-38 182.5-58.1 0-58-185.5zm73 233.5l33.1 0-13.2 63.6-19.9-63.6zm108.5-48l12-57.5 12 57.5-24 0zm99.3 48l33.1 0-19.9 63.6-13.2-63.6z"],
    "object-ungroup": [640, 512, [], "f248", "M128 0l-128 0 0 128 32 0 0 96-32 0 0 128 128 0 0-32 192 0 0 32 128 0 0-128-32 0 0-96 32 0 0-128-128 0 0 32-192 0 0-32zM352 224l0 32-256 0 0-160 256 0 0 128zM320 512l0-32 192 0 0 32 128 0 0-128-32 0 0-96 32 0 0-128-128 0 0 32-16 0 0 64 48 0 0 160-272 0 0-48-48 0 0 16-32 0 0 128 128 0z"],
    "chart-waterfall": [512, 512, [], "e0eb", "M64 32l0 384 448 0 0 64-512 0 0-448 64 0zM176 224l0 128-64 0 0-128 64 0zm112-64l0 96-64 0 0-128 64 0 0 32zM400 64l0 128-64 0 0-128 64 0zM512 96l0 256-64 0 0-288 64 0 0 32z"],
    "comment": [512, 512, [128489, 61669], "f075", "M256 480c141.4 0 256-107.5 256-240S397.4 0 256 0 0 107.5 0 240c0 56.5 20.8 108.5 55.7 149.5L0 512 148.7 457.9c32.6 14.2 69 22.1 107.3 22.1z"],
    "space-station-moon": [512, 512, [], "e033", "M512 256c0 10.8-.7 21.4-2 31.9-72.4 25.2-159.6 40.1-254 40.1S74.4 313.1 2 287.9C.7 277.4 0 266.8 0 256 0 114.6 114.6 0 256 0S512 114.6 512 256zM256 376c87 0 169.2-12 241-33.5-35.5 98.8-130 169.5-241 169.5S50.5 441.3 15 342.5C86.8 364 169 376 256 376zM160 160a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm112 0a80 80 0 1 0 -160 0 80 80 0 1 0 160 0z"],
    "up-from-bracket": [448, 512, [], "e590", "M241.4 7.5L224-11 206.6 7.5C99.6 120.8 41.5 182.3 32.3 192l127.7 0 0 160 128 0 0-160 127.7 0c-9.2-9.7-67.3-71.2-174.2-184.5zM64 352l0-32-64 0 0 192 448 0 0-192-64 0 0 128-320 0 0-96z"],
    "calendar-circle-plus": [576, 512, [], "e470", "M192 32l0-32-64 0 0 64-96 0 0 112 448 0 0-112-96 0 0-64-64 0 0 64-128 0 0-32zM32 480l225.4 0c-11.2-24.4-17.4-51.4-17.4-80 0-78.7 47.4-146.4 115.1-176L32 224 32 480zm400 64a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm16-208l0 48 64 0 0 32-64 0 0 64-32 0 0-64-64 0 0-32 64 0 0-64 32 0 0 16z"],
    "tablet-screen": [448, 512, ["tablet-android-alt"], "f3fc", "M0 0L448 0 448 512 0 512 0 0zM160 416l0 48 128 0 0-48-128 0zM384 64l-320 0 0 304 320 0 0-304z"],
    "salt-shaker": [384, 512, [129474], "e446", "M384 512l-8-64-40.1-321C326.8 54.5 265.1 0 192 0S57.2 54.5 48.1 127L8 448 0 512 384 512zm-72.5-64l-239 0 32-256 175 0 32 256zM192 48a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM128 96a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM240 80a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"],
    "file-check": [384, 512, [], "f316", "M384 144L384 512 0 512 0 0 240 0 384 144zM249.4 265.9L163.8 383.6c-19.3-20-33.7-34.9-43.2-44.7L86.1 372.2c6.2 6.4 27.2 28.1 63.1 65.3l19.8 20.6 16.8-23.1 102.4-140.8 14.1-19.4-38.8-28.3-14.1 19.4zM208 176L325.5 176 208 58.5 208 176z"],
    "hill-avalanche": [576, 512, [], "e507", "M.4 512l480 0-480-480 0 480zM551.5 391.1c34.4-34.4 34.4-90.1 0-124.5s-90.1-34.4-124.5 0c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0c15.6-15.6 40.9-15.6 56.6 0s15.6 40.9 0 56.6-40.9 15.6-56.6 0l-81.7-81.7c22.3-14.2 37.1-39.1 37.1-67.5 0-33.9-21.1-62.9-50.9-74.5 1.9-6.8 2.9-14 2.9-21.5 0-44.2-35.8-80-80-80-27.3 0-51.5 13.7-65.9 34.6-5.8-20-24.2-34.6-46.1-34.6-26.5 0-48 21.5-48 48 0 4 .5 7.9 1.4 11.6L440.1 401.9c34.2 23.1 81.1 19.5 111.4-10.8zM448.4 96a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm64 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "arrows-to-eye": [640, 512, [], "e4bf", "M176.4 32l-48 0 0 62.1-80-80-33.9 33.9c3.6 3.6 30.3 30.3 80 80l-62.1 0 0 48 144 0 0-144zm144 88c-80.7 0-139.9 67.5-170.2 136 30.3 68.5 89.6 136 170.2 136s139.9-67.5 170.2-136c-30.3-68.5-89.6-136-170.2-136zm-.9 72a64 64 0 1 1 .9 128 64 64 0 1 1 -.9-128zM176.4 456l0-120-144 0 0 48 62.1 0c-49.7 49.7-76.4 76.4-80 80l33.9 33.9c3.6-3.6 30.3-30.3 80-80l0 62.1 48 0 0-24zm288 0l0 24 48 0 0-62.1c49.7 49.7 76.4 76.4 80 80L626.4 464c-3.6-3.6-30.3-30.3-80-80l62.1 0 0-48-144 0 0 120zm0-424l0 144 144 0 0-48-62.1 0c49.7-49.7 76.4-76.4 80-80L592.4 14.1c-3.6 3.6-30.3 30.3-80 80l0-62.1-48 0z"],
    "snowplow": [640, 512, [], "f7d2", "M128 160l0-160 208 0 112 224 0 72 80 0 0-80c0-48.6 39.4-88 88-88l24 0 0 48-24 0c-22.1 0-40 17.9-40 40l0 208c0 22.1 17.9 40 40 40l24 0 0 48-24 0c-48.6 0-88-39.4-88-88l0-80-63 0c9.5 16.5 15 35.6 15 56 0 61.9-50.1 112-112 112l-224 0c-61.9 0-112-50.1-112-112 0-30.5 12.2-58.2 32-78.4l0-161.6 64 0zm91.7 34.9l43.6 29.1 113.2 0-80-160-104.4 0 0 108.8 27.7 22.1zM416 400c0-26.5-21.5-48-48-48l-224 0c-26.5 0-48 21.5-48 48s21.5 48 48 48l224 0c26.5 0 48-21.5 48-48zm-280 0a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm216-24a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM232 400a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"],
    "shield-exclamation": [512, 512, [], "e247", "M267.6 4.5l207.5 80.5 19.2 7.4 1.2 20.5c2.9 50-4.9 126.3-37.3 200.9-32.7 75.2-91.1 150-189.4 192.6l-12.7 5.5-12.7-5.5C144.9 463.9 86.6 389.2 53.9 313.9 21.5 239.3 13.7 162.9 16.6 113L17.8 92.5 37 85 244.5 4.5 256 0 267.6 4.5zM228 308l0 56 56 0 0-56-56 0zm-4-196l12.8 160 38.4 0 12.8-160-64 0z"],
    "square-w": [448, 512, [], "e285", "M448 32l-448 0 0 448 448 0 0-448zM144.6 349.5l-48.6-205.5 49.3 0 26 110.1 29.7-93.4 5.3-16.7 35.1 0 5.3 16.7 29.7 93.4 26-110.1 49.3 0-48.6 205.5-4.4 18.5-36.5 0-5.3-16.7-33.1-104.1-33.1 104.1-5.3 16.7-36.5 0-4.4-18.5z"],
    "chart-gantt": [512, 512, [], "e0e4", "M64 64l0-32-64 0 0 448 512 0 0-64-448 0 0-352zm96 0l-32 0 0 64 160 0 0-64-128 0zm64 112l-32 0 0 64 192 0 0-64-160 0zM384 288l-32 0 0 64 128 0 0-64-96 0z"],
    "credit-card-blank": [512, 512, [], "f389", "M512 64l-512 0 0 384 512 0 0-384zM88 336l72 0 0 48-96 0 0-48 24 0zm144 0l72 0 0 48-96 0 0-48 24 0zm144 0l72 0 0 48-96 0 0-48 24 0z"],
    "hands-holding-dollar": [640, 512, ["hands-usd"], "f4c5", "M344-16l-48 0 0 36-1.8 0c-36.6 0-66.2 29.7-66.2 66.2 0 33.4 24.9 61.6 58 65.7l61 7.6c5.1 .6 9 5 9 10.2 0 5.7-4.6 10.2-10.2 10.2l-101.8 0 0 56 52 0 0 36 48 0 0-36 1.8 0c36.6 0 66.2-29.7 66.2-66.2 0-33.4-24.9-61.6-58-65.7l-61-7.6c-5.1-.6-9-5-9-10.2 0-5.7 4.6-10.2 10.2-10.2l93.8 0 0-56-44 0 0-36zM80 64l-80 0 0 301.3 9.4 9.4 128 128 9.4 9.4 141.3 0 0-173.3-9.4-9.4C125.1 175.9 201.5 252.2 160 210.7L114.7 256c48.8 48.8 65.1 65.1 91 91L164.1 374.8 80 290.7 80 64zm480 0l0 226.7-84.1 84.1-41.7-27.8c102.9-102.9 58.7-58.7 91-91L480 210.7c-44.2 44.2-69.7 69.7-118.6 118.6l-9.4 9.4 0 173.3 141.3 0 9.4-9.4 128-128 9.4-9.4 0-301.3-80 0z"],
    "building-magnifying-glass": [576, 512, [], "e61c", "M32.4 0l384 0 0 180.9c-12.8-3.1-26.2-4.8-40-4.8-92.8 0-168 75.2-168 168 0 2.6 .1 5.3 .2 7.9l-32.2 0 0 112 82.3 0c29.1 28.5 68.4 46.6 112 48l-338.3 0 0-512zM382.1 512c11.8-.4 23.3-2 34.3-4.7l0 4.7-34.3 0zM192.4 96l-64 0 0 64 64 0 0-64zm64 0l0 64 64 0 0-64-64 0zm-64 128l-64 0 0 64 64 0 0-64zm184 192.1a72 72 0 1 0 0-144 72 72 0 1 0 0 144zm0 48c-66.3 0-120-53.7-120-120s53.7-120 120-120 120 53.7 120 120c0 24.5-7.3 47.2-19.9 66.2 47.9 47.9 73.8 73.8 77.8 77.8L520.4 522c-4-4-29.9-29.9-77.8-77.8-19 12.6-41.7 19.9-66.2 19.9z"],
    "square-a": [448, 512, [], "e25f", "M448 32l-448 0 0 448 448 0 0-448zM208.9 144l30.2 0 6.5 13.6 96 200 5 10.4-53.2 0-15.4-32-108 0-15.4 32-53.2 0 5-10.4 96-200 6.5-13.6zM224 223.5l-31 64.5 62 0-31-64.5z"],
    "video": [576, 512, ["video-camera"], "f03d", "M416 64l-384 0 0 384 384 0 0-384zM576 416l0-320-112 74.7 0 170.7 112 74.7z"],
    "face-pouting": [512, 512, [], "e387", "M0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm208-16l0-.3c4.9 1.6 14.5 4.8 28.6 9.6l12.6-37.9-19-6.3-96-32-19-6.3-12.6 37.9c11 3.7 26.9 9 47.8 15.9-4.1 5.4-6.6 12.1-6.6 19.4 0 17.7 14.3 32 32 32s32-14.3 32-32zm128 32c17.7 0 32-14.3 32-32 0-7.3-2.4-14-6.6-19.4 20.9-7 36.8-12.3 47.8-15.9l-12.6-37.9-19 6.3-96 32-19 6.3 12.6 37.9c14.2-4.7 23.7-7.9 28.6-9.6l0 .3c0 17.7 14.3 32 32 32zM152 414.6c29.1-19.3 64.9-30.6 103.6-30.6s74.5 11.4 103.6 30.6c-4.7-53-49.3-94.6-103.6-94.6S156.7 361.6 152 414.6z"],
    "chess-pawn": [384, 512, [9823], "f443", "M192-32c66.3 0 120 53.7 120 120 0 27-8.9 51.9-24 72l32 0 0 64-42.7 0 26.7 160 64 80 0 48-352 0 0-48 64-80 26.7-160-42.7 0 0-64 32 0c-15.1-20.1-24-45-24-72 0-66.3 53.7-120 120-120z"],
    "user-headset": [448, 512, [], "f82d", "M80 160C80 80.5 144.5 16 224 16S368 80.5 368 160l0 112-80 0c0-26.5-21.5-48-48-48l-32 0c-26.5 0-48 21.5-48 48l0 48 256 0 0-160C416 54 330-32 224-32S32 54 32 160l0 24 48 0 0-24zm256 0c0-61.9-50.1-112-112-112S112 98.1 112 160c0 24.5 7.9 47.2 21.2 65.6 15.5-25 43.2-41.6 74.8-41.6l32 0c30.9 0 58.1 15.9 73.8 40l2.2 0c12.7-18.1 20.1-40.2 20.1-64zM0 512l448 0-64-160-320 0-64 160z"],
    "synagogue": [576, 512, [128333], "f69b", "M16 80c0-35.3 28.7-64 64-64s64 28.7 64 64l0 32-128 0 0-32zm0 432l0-352 128 0 144-96 144 96 128 0 0 352-544 0zM560 112l-128 0 0-32c0-35.3 28.7-64 64-64s64 28.7 64 64l0 32zM352 320l-128 0 0 144 128 0 0-144zm-64-88a40 40 0 1 0 0-80 40 40 0 1 0 0 80z"],
    "mug": [576, 512, [], "f874", "M384 64l-320 0 0 384 384 0 0-128c70.7 0 128-57.3 128-128S518.7 64 448 64l-64 0zm64 64c35.3 0 64 28.7 64 64s-28.7 64-64 64l0-128z"],
    "shirt-jersey": [640, 512, [], "e6d7", "M400 32c0 44.2-35.8 80-80 80s-80-35.8-80-80l-80 0-96 96 96 96 0 288 320 0 0-288 96-96-96-96-80 0zM604.3 156.3l-96 96 35.7 35.7 96-96-35.7-35.7zM0 192l96 96 35.7-35.7-96-96-35.7 35.7zm296 88l48 0 0-80-48 0 0 80zM256 160l128 0 0 160-128 0 0-160z"],
    "building-circle-check": [576, 512, [], "e4d2", "M416 0l-384 0 0 512 244 0c-10.5-14.6-19-30.7-25.1-48l-74.9 0 0-112 70 0c6-23.3 16.3-45 30-64l-20 0 0-64 64 0 0 20c27.5-19.8 60.3-32.4 96-35.4L416 0zM128 96l64 0 0 64-64 0 0-64zm192 0l0 64-64 0 0-64 64 0zM128 224l64 0 0 64-64 0 0-64zM576 400a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-73.6-51.5l-9.4 12.9-64 88-11 15.1c-4.4-4.4-22.1-22.1-53.2-53.2L353.4 400 376 377.4c5 5 17.7 17.7 38.1 38.1l53-72.9 9.4-12.9 25.9 18.8z"],
    "calendar-plus": [448, 512, [], "f271", "M160 0l0 64 128 0 0-64 64 0 0 64 96 0 0 416-448 0 0-416 96 0 0-64 64 0zm40 384l48 0 0-72 72 0 0-48-72 0 0-72-48 0 0 72-72 0 0 48 72 0 0 72z"],
    "wheelchair-move": [448, 512, ["wheelchair-alt"], "e2ce", "M312 56a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zM189.8 29l22.4 18.2c102.3 83.1 153.7 124.9 154.3 125.3-10.1 11.1-35.4 39-75.9 83.5L447 256c-1 5.2-14.3 71.3-39.7 198.3l-6.3 31.4-62.8-12.6c1.2-5.9 11.4-56.9 30.6-153.1l-52.2 0c2.1 10.3 3.2 21 3.2 32 0 88.4-71.6 160-160 160S0 440.4 0 352 71.6 192 160 192c6 0 11.9 .3 17.8 1l50.4-50.4-33.9-27.6c-32.6 32.6-54.6 54.6-66.2 66.2L82.7 136c8.2-8.2 37.1-37.1 86.6-86.6L189.8 29zM160 448a96 96 0 1 0 0-192 96 96 0 1 0 0 192z"],
    "user-key": [576, 512, [], "e7b0", "M224 248a120 120 0 1 0 0-240 120 120 0 1 0 0 240zM368 432c-38.8-29.2-64-75.6-64-128l-224 0-64 208 352 0 0-80zM576 304c0-61.9-50.1-112-112-112S352 242.1 352 304c0 44.7 26.2 83.2 64 101.2l0 122.8 48 48 64-64-32-32 32-32-29.8-37.3C543.3 396.3 576 353.9 576 304zM432 288a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"],
    "user-shield": [576, 512, [], "f505", "M224 248a120 120 0 1 0 0-240 120 120 0 1 0 0 240zm16 107.2l0-51.2-160 0-64 208 282.3 0C261.4 469.2 240 413.9 240 355.2zM462 530.8c69.3-30.8 114-99.6 114-175.5l0-51.2-144-48-144 48 0 51.2c0 75.9 44.7 144.6 114 175.5l30 13.3 30-13.3zm-30-39.2l0-184.9 96 32 0 16.6c0 56.9-33.5 108.5-85.5 131.6L432 491.6z"],
    "tally-4": [448, 512, [], "e297", "M64 64l0-32-64 0 0 448 64 0 0-416zm128 0l0-32-64 0 0 448 64 0 0-416zM320 32l-64 0 0 448 64 0 0-448zM448 64l0-32-64 0 0 448 64 0 0-416z"],
    "bread-loaf": [576, 512, [127838], "f7eb", "M32 256l-32 0 0-64C0 121.3 57.3 64 128 64l96 0c70.7 0 128 57.3 128 128l0 64-32 0 0 224-288 0 0-224zM344.8 64L448 64c70.7 0 128 57.3 128 128l0 64-176 0 0-64c0-50.4-21.2-95.9-55.2-128zM368 480l0-176 176 0 0 176-176 0z"],
    "circle-0": [512, 512, [], "e0ed", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm0-368c53 0 96 43 96 96l0 32c0 53-43 96-96 96s-96-43-96-96l0-32c0-53 43-96 96-96zm-48 96l0 32c0 26.5 21.5 48 48 48s48-21.5 48-48l0-32c0-26.5-21.5-48-48-48s-48 21.5-48 48z"],
    "bold": [384, 512, [], "f032", "M32 32l-32 0 0 64 64 0 0 320-64 0 0 64 256 0c70.7 0 128-57.3 128-128 0-46.5-24.8-87.3-62-109.7 18.7-22.3 30-51 30-82.3 0-70.7-57.3-128-128-128L32 32zm96 384l0-128 128 0c35.3 0 64 28.7 64 64s-28.7 64-64 64l-128 0zm0-320l96 0c35.3 0 64 28.7 64 64s-28.7 64-64 64l-96 0 0-128z"],
    "heart-pulse": [512, 512, ["heartbeat"], "f21e", "M241 87.1C216 52.5 175.9 32 133.1 32 59.6 32 0 91.6 0 165.1l0 2.6c0 23.7 6.3 48.1 16.9 72.3l112.3 0c24.4-48.9 42.3-84.6 53.6-107.2 9.7 17.2 34.7 61.6 75 133.3 31.9-47.9 52.7-79 62.3-93.4 12.5 18.7 27.4 41.2 44.8 67.3l130.3 0c10.6-24.2 16.9-48.6 16.9-72.3l0-2.6C512 91.6 452.4 32 378.9 32 336.2 32 296 52.5 271 87.1l-15 20.7-15-20.7zM468.8 288l-129.6 0c-3.9-5.9-10.3-15.5-19.2-28.7-33.1 49.6-55 82.5-65.7 98.6-7.7-13.7-30.7-54.6-69-122.7-15.4 30.8-24.2 48.4-26.4 52.8L43.2 288C116.2 399.6 256 496 256 496s139.8-96.4 212.8-208z"],
    "square-root-variable": [576, 512, ["square-root-alt"], "f698", "M296 32l280 0 0 64-232 0-105.3 361-6.7 23-42.4 0-9.3-15.9-102.7-176.1-77.6 0 0-64 114.4 0 9.3 15.9 74.5 127.7 91.2-312.5 6.7-23zM528 226.7l45.3 45.3-48 48 48 48-45.3 45.3-48-48-48 48-45.3-45.3 48-48-48-48 45.3-45.3c14.6 14.6 30.6 30.6 48 48 17.4-17.4 33.4-33.4 48-48z"],
    "message-check": [512, 512, ["comment-alt-check"], "f4a2", "M512 448l-224 0-160 96 0-96-128 0 0-416 512 0 0 416zM340.5 135l-119.4 164.2-69.1-69.1-33.9 33.9 88.9 88.9 19.8 19.9 16.5-22.7 135.9-186.9 14.1-19.4-38.8-28.3-14.1 19.4z"],
    "hands-bubbles": [512, 512, ["hands-wash"], "e05e", "M384 64a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM0 128c0 14.6 0 49.4 .1 104.6 .1 52.2 23.9 101 63.9 133 .8-80.9 42.8-155.8 111.5-198.8 33.1-20.7 60.1-37.6 80.8-50.5 30.5-52.8 47.5-82.3 51-88.3l-41.6-24-12 20.8-84 145.5-20.8-12 63.2-109.5 12-20.8-41.6-24-12 20.8-63.2 109.5 0 0-43.3 75c0-35.8-.1-62.9-.1-81.3L0 128zm284.1-11.8l28.8 46.1c22-38 35.5-61.6 40.7-70.6l-41.6-24c-7.3 12.7-16.7 28.9-28 48.5zm43.2 69.1l16.7 26.7 23.4 0c15.2-26.4 26.1-45.2 32.7-56.6l-41.6-24c-6.8 11.8-17.2 29.8-31.1 53.9zm-61.1-37.4c-12.6 7.9-41.7 26.1-87.3 54.6-51.6 32.2-82.9 88.7-82.9 149.5l0 8c0 8.9 .8 17.6 2.2 26.1 35.4 8.2 61.8 40 61.8 77.9 0 6.3-.7 12.5-2.1 18.4 25.2 18.6 56.4 29.6 90.1 29.6l200 0 0-48-128 0 0-24 160 0 0-48-160 0 0-24 192 0 0-48-192 0 0-24 160 0 0-48-160 0 0 0-93.2 0c34-21.2 58.4-36.5 73.3-45.8l-33.9-54.3zM512 160a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM80 512a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"],
    "guitars": [576, 512, [], "f8bf", "M120 0l72 0 0 85.7-2.5 5.1-21.5 42.9 0 44.4c50.3 8.6 88 43.8 88 86 0 14-4.2 27.3-11.6 39.1-8.2 13-7.5 31.9 2.9 43.4 9.8 10.9 17.1 23.3 21.1 36.8-7.3 16.1-12.4 34.7-12.4 54.9 0 6.2 .5 12.2 1.3 18.2-21.4 33.1-64.1 55.6-113.3 55.6-70.7 0-128-46.6-128-104 0-23 9.2-44.3 24.8-61.5 10.3-11.4 11.1-30.4 2.9-43.4-7.5-11.8-11.6-25.1-11.6-39.1 0-42.1 37.7-77.3 88-86l0-44.4-21.5-42.9-2.5-5.1 0-85.7 24 0zm24 344a40 40 0 1 0 0-80 40 40 0 1 0 0 80zM408 148.6L376 112 400 0 432 0c22.1 0 40 17.9 40 40l0 4.4c0 12.4-6.4 23.3-16 29.7l0 164.7c48-7.2 48-46.9 48-46.9l32 0 0 37.5c0 12.9-4.3 25.4-8.5 37.8-1.4 4-2.7 7.9-3.9 11.8-2.1 6.8-3.6 15.1-3.6 24.8 0 33.5 17 70.9 28.8 92.9 6.9 12.7 11.2 26.9 11.2 41.3 0 40.8-33 73.8-73.8 73.8l-108.4 0c-40.8 0-73.8-33-73.8-73.8 0-14.5 4.3-28.6 11.2-41.3 11.8-22 28.8-59.3 28.8-92.9 0-9.8-1.5-18-3.6-24.8-1.2-3.9-2.6-7.9-3.9-11.8-4.2-12.4-8.5-25-8.5-37.8l0-53.5 32 0s0 52.8 48 62.5l0-89.9zM392 288l0 48 88 0 0-48-88 0zm0 80l0 48 88 0 0-48-88 0z"],
    "marker": [512, 512, [], "f5a1", "M263 9l-17-17-17 17-126.1 126.1-17 17 33.9 33.9 17-17 109.1-109.1 31 31-92.1 92.1 144 144 153.2-153.2c19.1-19.1 29.8-45 29.8-72 0-56.2-45.6-101.8-101.8-101.8-27 0-52.9 10.7-72 29.8L311 57 263 9zM40 328L0 512 184 472 295 361 151 217 40 328z"],
    "user-hair-long": [448, 512, [], "e45b", "M304 128c0-18-6-34.6-16-48l0 0-64 48-80 0 0 16c0 44.2 35.8 80 80 80s80-35.8 80-80l0-16zm48 0l0 48 48 96-352 0 48-96 0-48C96 57.3 153.3 0 224 0S352 57.3 352 128zm80 384l-416 0 64-192 288 0 64 192z"],
    "traffic-light-go": [320, 512, [], "f638", "M104 416c0 30.9 25.1 56 56 56s56-25.1 56-56-25.1-56-56-56-56 25.1-56 56zm56-216a56 56 0 1 0 0 112 56 56 0 1 0 0-112zM104 96a56 56 0 1 0 112 0 56 56 0 1 0 -112 0zM0-32l320 0 0 576-320 0 0-576zM136 96a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm24 136a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"],
    "house-person-leave": [640, 512, ["house-leave", "house-person-depart"], "e00f", "M440 24a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zM336 112l-13.3 0-9.4 9.4-80 80-9.4 9.4 0 109.3 64 0 0-82.7 32-32 0 69.3c0 28 12.2 54.7 33.5 72.9l80.7 69.1c11 71.6 17.4 112.9 19.1 123.9l63.3-9.7c-1.4-9-8.3-54.2-20.9-135.6l-1.8-11.7-9-7.7-52.8-45.3 0-115.2c17.6 22 28.4 35.6 32.6 40.8l111.4 0 0-64-80.6 0-54.4-68-9.6-12-95.4 0zM320.1 371l-12.6 44.2c-44.7 44.7-71.6 71.6-80.8 80.8L272 541.3c8.2-8.2 37.1-37.1 86.6-86.6l5.9-5.9c.8-2.7 3.8-13.2 9-31.5l-46-39.4c-2.5-2.2-5-4.4-7.4-6.8zM192 8l-176 153.2 0 30.8 32 0 0 160 128 0 0-161.1c6.2-6.2 40.7-40.7 103.4-103.4L281.2 85.7 192 8z"],
    "down-up": [576, 512, [], "e6c1", "M16 352l112 0 0-352 64 0 0 352 112 0-144 160-144-160zM448 160l0 352-64 0 0-352-112 0 144-160 144 160-112 0z"],
    "clipboard": [384, 512, [128203], "f328", "M64 0l256 0 0 32 64 0 0 480-384 0 0-480 64 0 0-32zm48 64l0 48 160 0 0-48-160 0z"],
    "place-of-worship": [512, 512, [], "f67f", "M96 208l64-48 0-96 96-80 96 80 0 96 64 48 0 64 96 48 0 192c-682.7 0-277.3 0-512 0l0-192 96-48 0-64zM320 464l0-144-128 0 0 144 128 0z"],
    "cannabis": [512, 512, [], "f55f", "M330.3 199.3c11.2-8.5 23-16.1 34.8-22.8 41-23.3 84.4-36.9 112.2-42.5l23.5-4.7-4.7 23.5c-5.6 27.7-19.3 70.9-42.7 111.7-9.3 16.2-20.4 32.4-33.3 47.2 24.8 6.7 46.3 16.9 60.1 24.6l25.2 14-25.2 14c-14.8 8.2-38.4 19.4-65.5 26-18.9 4.6-40.1 7.2-61.5 4.7 5.5 22 11.1 44.2 16.8 66.8-16.2-8-46.1-22.9-89.6-44.6l0 94.8-48 0 0-94.8c-43.5 21.7-73.4 36.5-89.6 44.6 5.7-22.6 11.3-44.9 16.8-66.8-21.4 2.5-42.6-.1-61.4-4.7-20.3-5-38.7-12.5-52.8-19.4l-12.7-6.6-25.2-14 25.2-14c13.8-7.7 35.2-17.9 60-24.6-12.9-14.8-23.9-30.9-33.2-47.2-23.4-40.8-37.1-84-42.7-111.7l-4.7-23.5 23.5 4.7c27.9 5.5 71.2 19.2 112.2 42.5 11.8 6.7 23.6 14.3 34.8 22.8-3-115.5 73.9-199.3 73.9-199.3s76.9 83.9 73.9 199.3z"],
    "face-zipper": [576, 512, [], "e3a5", "M527.3 347.3c10.8-28.4 16.8-59.2 16.8-91.3 0-141.4-114.6-256-256-256s-256 114.6-256 256 114.6 256 256 256c32.2 0 63-5.9 91.3-16.8-18.7-18.7-39.8-39.8-63.2-63.2l33.9-33.9 6.1-6.1-28.1 0 0-80 48 0 0 60.1c39.4-39.4 68.7-68.7 88-88 23.4 23.4 44.5 44.5 63.2 63.2zM176.1 208a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm192-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm-72 136l0 80-48 0 0-80 48 0zm-80 0l0 80-48 0 0-80 48 0zm320 112l-72-72-80 80 72 72c22.1 22.1 57.9 22.1 80 0s22.1-57.9 0-80zm-56 40a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"],
    "people-roof": [640, 512, [], "e537", "M334.7-12.6l-14.3-7.2-14.3 7.2-256 128-28.6 14.3 28.6 57.2 28.6-14.3 241.7-120.8 241.7 120.8 28.6 14.3 28.6-57.2-28.6-14.3-256-128zM320.4 272a56 56 0 1 0 0-112 56 56 0 1 0 0 112zm0 48c-53 0-96 43-96 96l0 64 192 0 0-64c0-53-43-96-96-96zm-128-64a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM64.4 416l0 64 112 0 0-80c0-18.4 3.5-36 9.8-52.2-12.2-7.5-26.5-11.8-41.8-11.8-44.2 0-80 35.8-80 80zm400 64l112 0 0-64c0-44.2-35.8-80-80-80-15.3 0-29.6 4.3-41.8 11.8 6.3 16.2 9.8 33.8 9.8 52.2l0 80zm80-224a48 48 0 1 0 -96 0 48 48 0 1 0 96 0z"],
    "pump": [640, 512, [], "e442", "M128 0l224 0 0 64-32 0 0 320-256 0 0 32-64 0 0-224 64 0 0 32 96 0 0-160-32 0 0-64zM640 96l0 416-272 0 0-416 272 0zM432 192l0 48 144 0 0-48-144 0zm0 88l0 48 144 0 0-48-144 0zm0 88l0 48 144 0 0-48-144 0z"],
    "square-ampersand": [448, 512, [], "e260", "M448 32l-448 0 0 448 448 0 0-448zM136 128l144 0 0 59.7c0 20.4-9.7 39.6-26.2 51.6l-18 13.2 28.6 29.9c20.9-30.1 34.7-50 41.4-59.8l39.5 27.3c-5.8 8.4-21.5 31-47 67.9l60.9 63.6c.8 .8 1.5 1.7 2.2 2.6l-66.1 0-24.8-25.9c-7.8 11.3-13.8 19.9-17.9 25.9l-140.6 0 0-63.7c0-22.9 10.9-44.5 29.4-58.1l21.9-16.1-7.3-7.7c-12.8-13.4-20-31.2-20-49.8l0-60.7zm66.4 89.6l23.1-16.9c4.1-3 6.5-7.8 6.5-12.9l0-11.7-48 0 0 12.7c0 6.2 2.4 12.1 6.7 16.6l11.7 12.2zm-5.6 63.6l-27 19.8c-6.2 4.5-9.8 11.7-9.8 19.4l0 15.7 67.4 0 9.2-13.3-39.8-41.5z"],
    "disease": [512, 512, [], "f7fa", "M236.5 29.4L224 48c-20 30-53.6 48-89.7 48L68 96c-37.5 0-67.9 30.4-67.9 67.9 0 18 7.2 35.2 19.9 47.9l27 27c11 11 17.2 25.9 17.2 41.5 0 15.8-6.4 30.9-17.7 42L33.4 335.1c-11.1 10.8-17.3 25.7-17.3 41.2 0 36.8 34.1 64.2 70.1 56.2l62.3-13.8c7.7-1.7 15.7-2.6 23.6-2.6 32.8 0 64.2 14.6 85.2 39.8l30.5 36.6c10.4 12.4 25.7 19.6 41.9 19.6 30.1 0 54.5-24.4 54.5-54.5l0-51.2c0-41.4 25.4-78.5 64-93.5l22.2-8.6c25.2-9.8 41.8-34.1 41.8-61.1 0-26.4-15.9-50.3-40.3-60.5L429 164.8c-33.2-13.9-57.6-43-65.5-78.1l-7.9-35.2c-6.8-30.1-33.5-51.5-64.3-51.5-22 0-42.6 11-54.8 29.4zM192 256l-64 0 0-64 64 0 0 64zm64 32l64 0 0 64-64 0 0-64zm64-64l-64 0 0-64 64 0 0 64z"],
    "book-bible": [448, 512, ["bible"], "f647", "M384 0l-384 0 0 512 448 0 0-64-32 0 0-64 32 0 0-384-64 0zM96 384l256 0 0 64-288 0 0-32c0-17.7 14.3-32 32-32zM192 64l64 0 0 64 64 0 0 64-64 0 0 128-64 0 0-128-64 0 0-64 64 0 0-64z"],
    "chess-board": [448, 512, [], "f43c", "M448 32l-448 0 0 448 448 0 0-448zM128 96l0 64 64 0 0-64 64 0 0 64 64 0 0-64 64 0 0 64-64 0 0 64 64 0 0 64-64 0 0 64 64 0 0 64-64 0 0-64-64 0 0 64-64 0 0-64-64 0 0 64-64 0 0-64 64 0 0-64-64 0 0-64 64 0 0-64-64 0 0-64 64 0zm64 128l64 0 0-64-64 0 0 64zm0 64l0-64-64 0 0 64 64 0zm64 0l-64 0 0 64 64 0 0-64zm0 0l64 0 0-64-64 0 0 64z"],
    "sprinkler": [512, 512, [], "e035", "M24 0a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM0 128a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM0 232a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM64 72a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm24 88a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm40-32a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm360 80a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm24-80a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zM488 0a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM448 72a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm-24 88a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm-40-32a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zM288 64l0 192 128 0 0 40-96 88 0 128-128 0 0-128-96-88 0-40 128 0 0-192 64 0z"],
    "gun-squirt": [576, 512, [], "e19d", "M128 32l0 32 416 0 0 64 32 0 0 64-32 0 0 64-296 0-18 72 42 0 0-40 48 0 0 128-48 0 0-40-54 0-26 104-160 0 56.1-224.3C38.8 251.7 0 210.4 0 160 0 112.4 34.6 72.9 80 65.3l0-33.3 48 0zm352 96l-416 0 0 64 416 0 0-64z"],
    "mug-marshmallows": [576, 512, [], "f7b7", "M416 0l0 80-320 0 0-48 160 0 0-32 160 0zM64 128l80 0 0 128 48 0 0-128 256 0c70.7 0 128 57.3 128 128S518.7 384 448 384l0 96-384 0 0-352zM448 320c35.3 0 64-28.7 64-64s-28.7-64-64-64l0 128z"],
    "circle-heart": [512, 512, ["heart-circle"], "f4c7", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm-6.4-312.5l6.4 8.5 6.4-8.5c11.1-14.8 28.5-23.5 46.9-23.5 32.4 0 58.7 26.3 58.7 58.7l0 5.3c0 64-112 128-112 128S144 304 144 240l0-5.3c0-32.4 26.3-58.7 58.7-58.7 18.5 0 35.9 8.7 46.9 23.5z"],
    "user-hat-tie-magnifying-glass": [576, 512, [], "e7af", "M96 80l48-112 32 0 48 32 48-32 32 0 48 112 48 0 0 48-48 0 0 14.8c0 26.5-8.1 51.2-21.9 71.6-33.1 9.4-62 28.6-83.4 54.4-7.4 1.3-15 2-22.7 2-70.7 0-128-57.3-128-128l0-14.8-48 0 0-48 48 0zM208 376.1c0 55.9 27.3 105.4 69.2 135.9l-261.2 0 64-192 56 0 40 160 31.4-115.3-31.4-36.7 0-24 48.2 0c-10.4 21.8-16.2 46.3-16.2 72.1zM144 142.8c0 44.2 35.8 80 80 80s80-35.8 80-80l0-14.8-160 0 0 14.8zM376 448.1a72 72 0 1 0 0-144 72 72 0 1 0 0 144zm0 48c-66.3 0-120-53.7-120-120s53.7-120 120-120 120 53.7 120 120c0 24.5-7.3 47.2-19.9 66.2 47.9 47.9 73.8 73.8 77.8 77.8L520 554c-4-4-29.9-29.9-77.8-77.8-19 12.6-41.7 19.9-66.2 19.9z"],
    "diagram-sankey": [576, 512, [], "e158", "M308.4 64l235.6 0 0 64-212.4 0-87.1 72.6-8.9 7.4-235.6 0 0-64 212.4 0 87.1-72.6 8.9-7.4zM144 320l-144 0 0-64 544 0 0 64-320 0 48 64 272 0 0 64-304 0-9.6-12.8-86.4-115.2z"],
    "sunset": [576, 512, [127751], "f767", "M305.2 185c50.5-50.5 77.5-77.5 81-81L352.2 70.1c-10.3 10.3-23.6 23.6-40 40l0-126.1-48 0 0 126.1-40-40-33.9 33.9c3.5 3.5 30.5 30.5 81 81l17 17 17-17zM203.5 207.5l-29.7-19.7c-2.5 12.5-11.6 57.4-27.2 134.6-77.2 15.6-122.1 24.7-134.6 27.2 12.4 18.6 27.1 40.8 44.1 66.4l113.5 0c19-46.9 65-80 118.7-80s99.7 33.1 118.7 80l113.5 0c17-25.6 31.7-47.8 44.1-66.4-12.5-2.5-57.4-11.6-134.6-27.2-15.6-77.2-24.7-122.1-27.2-134.6-10.6 7.1-48.8 32.4-114.4 75.9l-84.7-56.2zM32.2 464l0 48 512 0 0-48-512 0z"],
    "circle-equals": [512, 512, [], "e6b1", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM160 176l192 0 0 48-192 0 0-48zm0 112l192 0 0 48-192 0 0-48z"],
    "mars": [512, 512, [9794], "f222", "M320 0l192 0 0 192-64 0 0-82.7-95 95c19.5 28.4 31 62.7 31 99.8 0 97.2-78.8 176-176 176S32 401.2 32 304 110.8 128 208 128c37 0 71.4 11.4 99.8 31l95-95-82.7 0 0-64zM208 416a112 112 0 1 0 0-224 112 112 0 1 0 0 224z"],
    "user-vneck-hair-mullet": [448, 512, [], "e7ba", "M144 144l0-32 64 0 16-48 16 48 64 0 0 32c0 44.2-35.8 80-80 80s-80-35.8-80-80zm208 0l0-32 16 0 0-48-26.8 0C323.2 26.2 284.7 0 240 0L208 0c-44.7 0-83.2 26.2-101.2 64l-26.8 0 0 48 16 0 0 32c0 25.1 7.3 48.6 19.8 68.4L80 272 368 272 332.2 212.4C344.7 192.6 352 169.1 352 144zM224 384l-64-64-80 0-64 192 416 0-64-192-80 0-64 64z"],
    "laptop": [640, 512, [128187], "f109", "M96 32l-32 0 0 304 64 0 0-240 384 0 0 240 64 0 0-304-480 0zM0 384l0 40 56 56 528 0 56-56 0-40-640 0z"],
    "user-xmark": [640, 512, ["user-times"], "f235", "M104.4 128a120 120 0 1 1 240 0 120 120 0 1 1 -240 0zm264 176l64 208-416 0 64-208 288 0zM629.2 141.1c-8.5 8.5-25.5 25.5-50.9 50.9 25.5 25.5 42.4 42.4 50.9 50.9l-33.9 33.9-50.9-50.9c-25.5 25.5-42.4 42.4-50.9 50.9l-33.9-33.9c8.5-8.5 25.5-25.5 50.9-50.9-25.5-25.5-42.4-42.4-50.9-50.9l33.9-33.9c8.5 8.5 25.5 25.5 50.9 50.9 25.5-25.5 42.4-42.4 50.9-50.9l33.9 33.9z"],
    "flag-usa": [448, 512, [], "f74d", "M64 0l0 48 69-17.2c38.1-9.5 78.3-5.1 113.5 12.5 46.3 23.2 100.8 23.2 147.1 0l54.4-27.2 0 86.2-44.7 16.2c-42.8 15.6-90 13.9-131.6-4.6l-16.1-7.2c-20.3-9-41.8-14.7-63.6-16.9l0 32.2c17.4 2.1 34.4 6.7 50.6 13.9l16.1 7.2c49.2 21.9 105 23.8 155.6 5.4l33.7-12.3 0 62-44.7 16.2c-42.8 15.6-90 13.9-131.6-4.6l-16.1-7.2c-40.2-17.9-85-22.5-128.1-13.3l-63.5 13.6 0 32.7 70.2-15.1c36.4-7.8 74.3-3.9 108.4 11.3l16.1 7.2c49.2 21.9 105 23.8 155.6 5.4l33.7-12.3 0 61.9-44.7 16.2c-42.8 15.6-90 13.9-131.6-4.6l-16.1-7.2c-40.2-17.9-85-22.5-128.1-13.3l-63.5 13.6 0 32.7 70.2-15.1c36.4-7.8 74.3-3.9 108.4 11.3l16.1 7.2c49.2 21.9 105 23.8 155.6 5.4l33.7-12.3 0 55.7-55.5 20.8c-46.2 17.3-97.6 14.6-141.7-7.4-37.9-19-81.4-23.7-122.5-13.4L64 400 64 512 0 512 0 0 64 0zm48 96a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm32 0a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm-32 48a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm32 0a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"],
    "hand-middle-finger": [448, 512, [128405], "f806", "M272 0l-80 0 0 192-80 0 0 144-32 0 0-72-48 40 0 57.5c0 44.7 19.8 87 54.1 115.6 27 22.5 61.1 34.9 96.3 34.9L304 512c70.7 0 128-57.3 128-128l0-144-80 0 0-32-80 0 0-208z"],
    "alt": [640, 512, [], "e08a", "M448 64l-15.4 0-9.6 12-246.4 308-176.6 0 0 64 207.4 0 9.6-12 246.4-308 176.6 0 0-64-192 0zm0 320l-32 0 0 64 224 0 0-64-192 0z"],
    "mortar-pestle": [512, 512, [], "f5a7", "M469.5 0L252.3 160 397.3 160 510.1 47.2 469.5 0zM32 192l-32 0 0 64 32 0c0 82.5 43.4 147.7 123.9 176.2-17.4 21.9-27.9 49.6-27.9 79.8l256 0c0-30.2-10.4-57.9-27.9-79.8 80.5-28.6 123.9-93.7 123.9-176.2l32 0 0-64-480 0z"],
    "banana": [640, 512, [], "e2e5", "M385.6 10.4c58.2 52.7 94.8 128.9 94.8 213.6 0 12.3-.8 24.4-2.3 36.3l-115.9 24.4-50.8-30.1c16.1-33.5 25-71 25-110.6 0-31.4-5.6-61.3-15.9-89l65.1-44.6zm-29 308.2c204.4-43 125.1-26.3 155.6-32.8l9.2 9.2 80 80 17 17-33.9 33.9-87.8-87.8-43.9 9.3C406.5 444.7 307.3 512 192.4 512l-160 0 0-112 48 0c72.9 0 138.7-30.5 185.4-79.4l-22.1-13.1c-63.3 33-97.1 50.6-101.4 52.9l-22.2-42.6c2.4-1.2 40.2-21 113.3-59.1l11.8-6.2c4.4 2.6 83 49.2 111.5 66z"],
    "umbrella-simple": [512, 512, ["umbrella-alt"], "e2bc", "M288-32l0 34C414.3 17.7 512 125.5 512 256L0 256C0 125.5 97.7 17.7 224 2l0-34 64 0zm0 459.9c0 46.5-37.7 84.1-84.1 84.1-28.1 0-54.4-14.1-70-37.5l-.5-.8-17.8-26.6 53.3-35.5 17.8 26.6 .5 .8c3.7 5.6 10 9 16.7 9 11.1 0 20.1-9 20.1-20.1l0-123.9 64 0 0 123.9z"],
    "joystick": [448, 512, [128377], "f8c5", "M448 512l-448 0 0-160 448 0 0 160zM224 0c61.9 0 112 50.1 112 112 0 50.7-33.7 93.5-80 107.3l0 84.7-64 0 0-84.7c-46.3-13.8-80-56.6-80-107.3 0-61.9 50.1-112 112-112zM200 48a24 24 0 1 0 0 48 24 24 0 1 0 0-48z"],
    "head-side-cough": [512, 512, [], "e061", "M0 512l256 0 0-192 64 0 0-64-49.7-59.6C256.7 85.7 162.4 0 48 0 31.5 0 15.5 1.8 0 5.2L0 512zM112 192a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm0 232l0-40 96-24 0 72-96-8zM480 312a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm-40 24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm-64 48a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm128 0a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM480 504a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm-40-72a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"],
    "plane-lock": [640, 512, [], "e558", "M288-32c-30.9 0-56 25.1-56 56l0 127.3-184 168.7 0 80 184-61.3 0 99.7-72 57.6 0 48 128-32 80 20 0-228 32 0c0-29.1 9.7-55.9 26.1-77.4L344 151.3 344 24c0-30.9-25.1-56-56-56zM496 304c0-17.7 14.3-32 32-32s32 14.3 32 32l0 48-64 0 0-48zm-48 48l-32 0 0 192 224 0 0-192-32 0 0-48c0-44.2-35.8-80-80-80s-80 35.8-80 80l0 48z"],
    "battery-three-quarters": [640, 512, ["battery-4"], "f241", "M544 128l0 256-448 0 0-256 448 0zM96 64l-64 0 0 384 576 0 0-128 32 0 0-128-32 0 0-128-512 0zM416 176l-272 0 0 160 272 0 0-160z"],
    "franc-sign": [320, 512, [], "e18f", "M320 32l-272 0 0 288-48 0 0 48 48 0 0 112 64 0 0-112 112 0 0-48-112 0 0-64 176 0 0-64-176 0 0-96 208 0 0-64z"],
    "triple-chevrons-right": [640, 512, [], "e7f9", "M237.5 256L64.3 429.3 19 384 147 256 19 128 64.3 82.8 237.5 256zm192 0L256.3 429.3 211 384 339 256 211 128 256.3 82.8 429.5 256zm192 0L448.3 429.3 403 384 531 256 403 128 448.3 82.8 621.5 256z"],
    "filter-circle-dollar": [640, 512, ["funnel-dollar"], "f662", "M224 416l66.7 66.6c-12-25-18.7-53.1-18.7-82.6 0-86.4 57.1-159.5 135.6-183.6L560 64 16 64 224 272 224 416zm384-16a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zM480 328l32 0 0 32-61.8 0c-5.6 0-10.2 4.6-10.2 10.2 0 4.9 3.5 9.1 8.3 10l45 8.2c20 3.6 34.6 21.1 34.6 41.5 0 23.3-18.9 42.2-42.2 42.2l-5.8 0 0 24-32 0 0-24-32 0 0-32 69.8 0c5.6 0 10.2-4.6 10.2-10.2 0-4.9-3.5-9.1-8.3-10l-45-8.2c-20-3.6-34.6-21.1-34.6-41.5 0-22.6 17.7-41 40-42.1l0-24.1 32 0 0 24z"],
    "cheese": [512, 512, [], "f7ef", "M0 256L288 32c123.7 0 224 100.3 224 224L0 256zm512 48l0 176-512 0 0-176 512 0z"],
    "circle-h": [512, 512, [9405, "hospital-symbol"], "f47e", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm96-344l0 200-48 0 0-88-96 0 0 88-48 0 0-224 48 0 0 88 96 0 0-88 48 0 0 24z"],
    "box-ballot": [512, 512, [128499], "f735", "M238.6 256L270.6 256 424 102.6 273.4-48 104 121.4 238.6 256zM416 256l0 48-320 0 0-48 74.7 0c-79.3-79.3-122-122-128-128l-42.7 0 0 224 512 0 0-224-45.5 0-8.5 8.5-119.5 119.5 77.5 0zM0 512l512 0 0-112-512 0 0 112z"],
    "location-check": [384, 512, ["map-marker-check"], "f606", "M192 0C298 0 384 84.4 384 188.6 384 339.4 192 528 192 528S0 339.4 0 188.6C0 84.4 86 0 192 0zm57.4 137.9L163.8 255.6c-19.3-20-33.7-34.9-43.2-44.7L86.1 244.2c6.2 6.4 27.2 28.1 63.1 65.2l19.8 20.6 16.8-23.1 102.4-140.8 14.1-19.4-38.8-28.2-14.1 19.4z"],
    "tilde": [512, 512, [63135], "7e", "M0 128l173.3 0 9.4 9.4 182.6 182.6 82.7 0 0-160 64 0 0 224-173.3 0-9.4-9.4-182.6-182.6-82.7 0 0 160-64 0 0-224z"],
    "comment-middle": [512, 512, [], "e149", "M191.5 440.8L256 544 320.5 440.8C430.6 415.8 512 328.2 512 224 512 100.3 397.4 0 256 0S0 100.3 0 224C0 328.2 81.4 415.8 191.5 440.8z"],
    "arrow-left-from-dotted-line": [576, 512, [], "e6b9", "M19 256l22.6 22.6 128 128 22.6 22.6 45.3-45.3-96-96 274.7 0 0-64-274.7 0c57.4-57.4 89.4-89.4 96-96l-45.3-45.3-22.6 22.6-128 128-22.6 22.6zM480.3 64l0 64 64 0 0-64-64 0zm0 170.7l64 0 0-64-64 0 0 64zm0 42.7l0 64 64 0 0-64-64 0zm0 170.7l64 0 0-64-64 0 0 64z"],
    "u-turn-left-down": [576, 512, ["u-turn"], "e7f1", "M304 0C189.1 0 96 93.1 96 208l0 144-96 0 160 160 160-160-96 0 0-144c0-44.2 35.8-80 80-80s80 35.8 80 80l0 240 128 0 0-240C512 93.1 418.9 0 304 0z"],
    "arrow-down-from-bracket": [448, 512, [], "e667", "M246.6 486.6l-22.6 22.6-22.6-22.6-128-128-22.6-22.6 45.3-45.3c6.6 6.6 38.6 38.6 96 96l0-226.7 64 0 0 226.7 96-96 45.3 45.3-150.6 150.6zM64 160l0 32-64 0 0-192 448 0 0 192-64 0 0-128-320 0 0 96z"],
    "school": [576, 512, [127979], "f549", "M0 128l128 0 160-128 160 128 128 0 0 384-576 0 0-384zM352 336l-128 0 0 128 128 0 0-128zM64 384l64 0 0-64-64 0 0 64zm64-128l0-64-64 0 0 64 64 0zM448 384l64 0 0-64-64 0 0 64zm64-128l0-64-64 0 0 64 64 0zm-224 0a64 64 0 1 0 0-128 64 64 0 1 0 0 128z"],
    "ear-muffs": [512, 512, [], "f795", "M256 64c-70.7 0-128 57.3-128 128l0 32 32 0 0 64c0 11.6-3.1 22.6-8.6 32 5.4 9.4 8.6 20.4 8.6 32s-3.1 22.6-8.6 32c5.4 9.4 8.6 20.4 8.6 32l0 64-80 0c-35.3 0-64-28.7-64-64 0-6.5 1-12.8 2.8-18.7-11.6-11.6-18.8-27.6-18.8-45.3s7.2-33.7 18.8-45.3c-1.8-5.9-2.8-12.2-2.8-18.7 0-29.8 20.4-54.9 48-62l0-34C64 86 150 0 256 0S448 86 448 192l0 34c27.6 7.1 48 32.2 48 62 0 6.5-1 12.8-2.8 18.7 11.6 11.6 18.8 27.6 18.8 45.3s-7.2 33.7-18.8 45.3c1.8 5.9 2.8 12.2 2.8 18.7 0 35.3-28.7 64-64 64l-80 0 0-64c0-11.6 3.1-22.6 8.6-32-5.4-9.4-8.6-20.4-8.6-32s3.1-22.6 8.6-32c-5.4-9.4-8.6-20.4-8.6-32l0-64 32 0 0-32c0-70.7-57.3-128-128-128z"],
    "clock-seven": [512, 512, [], "e350", "M256 0a256 256 0 1 1 0 512 256 256 0 1 1 0-512zM232 120l0 128.7c-47.7 71.6-72.2 108.3-73.3 109.9l39.9 26.6c.4-.6 26.2-39.3 77.3-116l4-6 0-167.3-48 0 0 24z"],
    "dice-five": [448, 512, [9860], "f523", "M448 32l-448 0 0 448 448 0 0-448zM128 128a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM96 352a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM224 224a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm64-64a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm32 160a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "tornado": [448, 512, [127786], "f76f", "M0 0L0 45.6C0 62.7 1.7 79.6 5 96l352.8 0c3.2-6.9 7.5-13.3 13-18.8L416 32 416 0 0 0zM355.7 144l-336 0c12.4 29.7 30.2 56.8 52.7 80l339.6 0-47.2-62.9c-3.9-5.2-7-11-9.2-17.1zM242.6 334.7c8.2 4.8 15.8 10.7 22.5 17.3l178.6 0c2.8-11 4.3-22.5 4.3-34.1 0-15.7-2.7-31.2-7.9-45.9L136 272 242.6 334.7zM294.3 400c5.3 17 6.5 35.2 3.6 53l-9.8 59 108.4-86.7c9.3-7.4 17.5-16 24.4-25.3l-126.5 0z"],
    "arrow-left-to-line": [512, 512, [8676, "arrow-to-left"], "f33e", "M0 416l0 32 64 0 0-384-64 0 0 352zM137.4 233.4l-22.6 22.6 22.6 22.6 128 128 22.6 22.6 45.3-45.3c-6.6-6.6-38.6-38.6-96-96l274.7 0 0-64-274.7 0c57.4-57.4 89.4-89.4 96-96l-45.3-45.3-22.6 22.6-128 128z"],
    "jet-fighter": [576, 512, ["fighter-jet"], "f0fb", "M480 200l-118 0-114-152 72 0 0-48-192 0 0 48 32 0 0 152-54.4 0-57.6-72-48 0 0 104 64 0 0 48-64 0 0 104 48 0 57.6-72 54.4 0 0 152-32 0 0 48 192 0 0-48-72 0 114-152 118 0 96-40 0-32-96-40z"],
    "person-biking-mountain": [640, 512, [128693, "biking-mountain"], "f84b", "M400 0a48 48 0 1 1 0 96 48 48 0 1 1 0-96zM336 88l91.2 72 84.8 0 0 64-107.2 0-49.5-39.6-60.3 48.5 57 38 0 177.1-64 0 0-142.9-60.5-38.4c-32.8-20.8-35-67.9-4.3-91.6L336 88zM536 274.6c13.1 2.9 25.4 8 36.4 15.1l13.1-13.1 33.9 33.9-13.1 13.1c7 11 12.2 23.3 15.1 36.4l18.6 0 0 48-18.6 0c-2.9 13.1-8 25.4-15.1 36.4l13.1 13.1-33.9 33.9-13.1-13.1c-11 7-23.3 12.2-36.4 15.1l0 18.6-48 0 0-18.6c-13.1-2.9-25.4-8-36.4-15.1l-13.1 13.1-33.9-33.9 13.1-13.1c-7-11-12.2-23.3-15.1-36.4l-18.6 0 0-48 18.6 0c2.9-13.1 8-25.4 15.1-36.4l-13.1-13.1 33.9-33.9 13.1 13.1c11-7 23.3-12.2 36.4-15.1l0-18.6 48 0 0 18.6zM512 448a64 64 0 1 0 0-128 64 64 0 1 0 0 128zM152 256l0 18.6c13.1 2.9 25.4 8 36.4 15.1l13.1-13.1 33.9 33.9-13.1 13.1c7 11 12.2 23.3 15.1 36.4l18.6 0 0 48-18.6 0c-2.9 13.1-8 25.4-15.1 36.4l13.1 13.1-33.9 33.9-13.1-13.1c-11 7-23.3 12.2-36.4 15.1l0 18.6-48 0 0-18.6c-13.1-2.9-25.4-8-36.4-15.1l-13.1 13.1-33.9-33.9 13.1-13.1c-7-11-12.2-23.3-15.1-36.4l-18.6 0 0-48 18.6 0c2.9-13.1 8-25.4 15.1-36.4l-13.1-13.1 33.9-33.9 13.1 13.1c11-7 23.3-12.2 36.4-15.1l0-18.6 48 0zm40 128a64 64 0 1 0 -128 0 64 64 0 1 0 128 0z"],
    "thumbs-down": [512, 512, [128078, 61576], "f165", "M432 32l0 64 32 0 0 64 16 0 0 80 16 0 0 112-208 0 48 96-96 48-80-144 0-256 96-64 176 0zM112 96l0 320-112 0 0-320 112 0z"],
    "function": [640, 512, [], "f661", "M64 0l160 0 0 64-96 0 0 128 64 0 0 64-64 0 0 224-128 0 0-64 64 0 0-160-64 0 0-64 64 0 0-192zM288 320c0 52.7 15.7 101.6 42.7 142.3l-53.4 35.3C243.6 446.7 224 385.6 224 320s19.6-126.7 53.3-177.7l53.4 35.3C303.7 218.4 288 267.3 288 320zm288 0c0-52.7-15.7-101.6-42.7-142.3l53.4-35.3C620.4 193.3 640 254.4 640 320s-19.6 126.7-53.3 177.7l-53.4-35.3c27-40.7 42.7-89.6 42.7-142.3zM398.6 241.4L432 274.7c24-24 42.7-42.7 56-56l45.3 45.3-56 56 56 56-45.3 45.3-56-56-56 56-45.3-45.3 56-56-56-56 45.3-45.3 22.6 22.6z"],
    "broom": [576, 512, [129529], "f51a", "M416 288l-40-40 200-200-48-48-200 200-40-40-32 0 0 51.7 108.3 108.3 51.7 0 0-32zm-74.9 65.4L222.6 234.9c-42.7-3.7-85.2 11.7-115.8 42.3-27.4 27.4-42.8 64.6-42.8 103.4l0 3.5 96-48-160 144 0 32 195.5 0c38.8 0 75.9-15.4 103.4-42.8 30.6-30.6 45.9-73.1 42.3-115.8z"],
    "disc-drive": [512, 512, [], "f8b5", "M32 32l448 0 0 384 32 0 0 64-512 0 0-64 32 0 0-384zM224 256a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm192 0a160 160 0 1 0 -320 0 160 160 0 1 0 320 0z"],
    "grill": [448, 512, [], "e5a3", "M0 32l448 0 0 64c0 89.8-52.9 167.3-129.2 203l55.2 128.9c1.8 4.1 6.2 14.6 13.5 31.4l-44.1 18.9c-14.5-33.8-15.2-35.4-26.6-62.2L160 416c0 35.3-28.7 64-64 64s-64-28.7-64-64 28.7-64 64-64c3.4 0 6.8 .3 10.1 .8L129.2 299C52.9 263.3 0 185.8 0 96L0 32zM151.8 368l144.4 0-22.9-53.4c-15.9 3.6-32.3 5.4-49.3 5.4s-33.4-1.9-49.3-5.4L151.8 368zM96 440a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"],
    "file-import": [384, 512, ["arrow-right-to-file"], "f56f", "M240 0L0 0 0 304 182.1 304c-23-23-39-39-48-48L168 222.1c2.1 2.1 31.8 31.8 89 89l17 17c-2.1 2.1-31.8 31.8-89 89l-17 17-33.9-33.9c9-9 25-25 48-48L0 352 0 512 384 512 384 144 240 0zm85.5 176L208 176 208 58.5 325.5 176z"],
    "jug": [448, 512, [], "f8c6", "M160-16l160 0 0 64-192 0 0-64 32 0zM359 151l-3.7 3.7 31.7 36.2 5.9-5.9c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0zm67.9 67.9l-10.9 10.9 0 282.2-384 0 0-288 112-128 160 0 19.7 22.5 1.4-1.4c28.1-28.1 73.7-28.1 101.8 0s28.1 73.7 0 101.8zM352 288l-256 0 0 128 256 0 0-128z"],
    "utensils": [512, 512, [127860, 61685, "cutlery"], "f2e7", "M32.1-1.5L17.9 149.8c-1.2 5.9-1.9 12-1.9 18.1 0 45.9 35.1 83.6 80 87.7l0 256.4 64 0 0-256.4c44.9-4.1 80-41.8 80-87.7 0-6.1-.6-12.1-1.9-18.1l-14.2-151.3-31.9 0-14.7 161.4-20.1 0-13.3-161.3-31.9 0-13.3 161.3-20.1 0-14.7-161.4-31.9 0zM480 0C432 0 320 32 320 176l0 176 96 0 0 160 64 0 0-512z"],
    "id-badge": [384, 512, [], "f2c1", "M384 0L0 0 0 512 384 512 384 0zM272 352l32 96-224 0 32-96 160 0zM136 256a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zM152 64l104 0 0 48-128 0 0-48 24 0z"],
    "spider": [512, 512, [128375], "f717", "M398.5 22.8l40 96 6.2 14.8-75.5 75.4 76.4-20.8c15.4-46.1 24.5-73.6 27.5-82.6l45.5 15.2-7.6 22.8-28.1 84.2-12.4 3.4-91.2 24.8 91.2 24.9 12.4 3.4 28.1 84.2 7.6 22.8-45.5 15.2c-3-9-12.2-36.5-27.5-82.6l-76.4-20.8 75.5 75.5-6.2 14.8-40 96-9.2 22.2-44.3-18.4 9.2-22.2 33.8-81.2-35.8-35.8c-1 52.2-43.5 94.1-95.9 94.1s-95-42-96-94.1l-35.7 35.8 33.8 81.2 9.2 22.2-44.3 18.4-9.2-22.2-40-96-6.2-14.8 75.4-75.5-76.3 20.8c-15.4 46.1-24.5 73.6-27.5 82.6l-45.5-15.2 7.6-22.8 28.1-84.2 12.4-3.4 91.1-24.9-91.1-24.8-12.4-3.4-28.1-84.2-7.6-22.8 45.5-15.2c3 9 12.2 36.5 27.5 82.6l76.4 20.8-75.4-75.4 6.2-14.8 40-96 9.2-22.2 44.3 18.4-9.2 22.2-33.8 81.2 51.7 51.8c1-43.3 36.4-78.1 79.9-78.1s78.9 34.8 79.9 78.1l51.8-51.8-33.8-81.2-9.2-22.2 44.3-18.4 9.2 22.2z"],
    "user-question": [576, 512, [], "e7b7", "M104.4 128a120 120 0 1 1 240 0 120 120 0 1 1 -240 0zm264 176l64 208-416 0 64-208 288 0zm128-186.8c-17.7 0-32 14.3-32 32l-42.4 0c0-41.1 33.3-74.4 74.4-74.4s74.4 33.3 74.4 74.4c0 33.5-22.8 59-53.2 69.6l0 18.3-42.4 0 0-53.5 3.3-.5c21.1-3 49.9-7.1 49.9-34 0-17.7-14.3-32-32-32zM472.4 264l48 0 0 48-48 0 0-48z"],
    "person-fairy": [576, 512, [], "e608", "M288 0a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm96 352l-32 0 0 160-128 0 0-160-32 0 0-192 192 0 0 192zM0 56l64 0c52.9 0 100.8 21.4 135.5 56l-55.5 0 0 288 32 0 0 30.7c-14.8 6-31 9.3-48 9.3l-64 0 0-48c0-39.5 17.9-74.8 46-98.3-65-30.7-110-97-110-173.7L0 56zM448 440c-17 0-33.2-3.3-48-9.3l0-30.7 32 0 0-288-55.5 0C411.2 77.4 459.1 56 512 56l64 0 0 64c0 76.7-45 142.9-110 173.7 28.1 23.5 46 58.8 46 98.3l0 48-64 0z"],
    "mobile-retro": [384, 512, [], "e527", "M16 0l352 0 0 512-352 0 0-512zM96 128l0 128 192 0 0-128-192 0zM216 304l-48 0 0 48 48 0 0-48zm-48 96l0 48 48 0 0-48-48 0zm136 0l-48 0 0 48 48 0 0-48zM80 400l0 48 48 0 0-48-48 0zm224-96l-48 0 0 48 48 0 0-48zM80 304l0 48 48 0 0-48-48 0zM168 40l-24 0 0 48 96 0 0-48-72 0z"],
    "signs-post": [512, 512, ["map-signs"], "f277", "M288 0l-64 0 0 64-192 0 0 128 192 0 0 64-160 0-64 64 64 64 160 0 0 128 64 0 0-128 192 0 0-128-192 0 0-64 160 0 64-64-64-64-160 0 0-64z"],
    "group-arrows-rotate": [512, 512, [], "e4f6", "M37.6 122.3c-11.5 18.7-20.6 39-27 60.5l61.3 18.3C90.4 139.2 139.2 90.4 201.1 71.9L182.9 10.6C161.4 17 141.1 26.1 122.3 37.6 112.3 15.4 89.9 0 64 0 28.7 0 0 28.7 0 64 0 89.9 15.4 112.3 37.6 122.3zm436.7 0c22.2-10 37.6-32.4 37.6-58.3 0-35.3-28.7-64-64-64-25.9 0-48.3 15.4-58.3 37.6-18.7-11.5-39-20.6-60.5-27L310.9 71.9c61.9 18.4 110.8 67.3 129.2 129.2l61.3-18.3c-6.4-21.5-15.5-41.8-27-60.5zM512 448c0-25.9-15.4-48.3-37.6-58.3 11.5-18.7 20.6-39 27-60.5l-61.3-18.3c-18.4 61.9-67.3 110.8-129.2 129.2l18.3 61.3c21.5-6.4 41.8-15.5 60.5-27 10 22.2 32.4 37.6 58.3 37.6 35.3 0 64-28.7 64-64zM37.6 389.7c-22.2 10-37.6 32.4-37.6 58.3 0 35.3 28.7 64 64 64 25.9 0 48.3-15.4 58.3-37.6 18.7 11.5 39 20.6 60.5 27l18.3-61.3C139.2 421.6 90.4 372.8 71.9 310.9L10.6 329.1c6.4 21.5 15.5 41.8 27 60.5zM360 144l-28.9 28.9c-19.8-17.9-46.2-28.9-75.1-28.9-43.6 0-81.3 24.9-99.8 61.1L199 226.9c10.6-20.8 32.2-34.9 57-34.9 15.6 0 30 5.6 41.1 14.9l-33.1 33.1 96 0 0-96zM314.6 285.1c-10.6 20.8-32.2 34.9-57 34.9-15.7 0-30-5.6-41.1-14.9l33.1-33.1-96 0 0 96 28.9-28.9c19.8 17.9 46.2 28.9 75.1 28.9 43.6 0 81.3-24.9 99.8-61.1l-42.7-21.8z"],
    "diagram-venn": [640, 512, [], "e15a", "M224 416c-88.4 0-160-71.6-160-160S135.6 96 224 96c11 0 21.7 1.1 32 3.2-39.6 40.4-64 95.7-64 156.8s24.4 116.4 64 156.8c-10.3 2.1-21.1 3.2-32 3.2zm0 64c34.4 0 66.9-7.7 96-21.6 29.1 13.8 61.6 21.6 96 21.6 123.7 0 224-100.3 224-224S539.7 32 416 32C381.6 32 349.1 39.7 320 53.6 290.9 39.7 258.4 32 224 32 100.3 32 0 132.3 0 256S100.3 480 224 480zM416 96c88.4 0 160 71.6 160 160S504.4 416 416 416c-11 0-21.7-1.1-32-3.2 39.6-40.4 64-95.7 64-156.8S423.6 139.6 384 99.2C394.3 97.1 405 96 416 96z"],
    "arrows-split-up-and-left": [576, 512, [], "e4bc", "M374.9-22.6L352.3-45.3c-2.9 2.9-42.4 42.4-118.6 118.6L211 96 256.3 141.3c12-12 33.3-33.3 64-64l0 178.7-178.7 0c30.7-30.7 52-52 64-64l-45.3-45.3c-2.9 2.9-42.4 42.4-118.6 118.6L19 288c2.9 2.9 42.4 42.4 118.6 118.6l22.6 22.6 45.3-45.3-64-64 178.7 0 0 192 192 0 0-64-128 0 0-370.7 64 64 45.3-45.3c-2.9-2.9-42.4-42.4-118.6-118.6z"],
    "image-polaroid-user": [448, 512, [], "e1b6", "M448 32l-448 0 0 448 448 0 0-448zM384 96l0 256-58.7 0-21.3-64-160 0-21.3 64-58.7 0 0-256 320 0zM224 248a56 56 0 1 0 0-112 56 56 0 1 0 0 112z"],
    "arrow-up-left": [448, 512, [], "e09d", "M64.3 64l-32 0 0 288 64 0 0-178.7 265.4 265.4 22.6 22.6 45.3-45.3-22.6-22.6-265.4-265.4 178.7 0 0-64-256 0z"],
    "square-australian-dollar": [448, 512, [], "e718", "M448 32l-448 0 0 448 448 0 0-448zM288 136l32 0 0 24 32 0 0 48-52.8 0c-6.2 0-11.2 5-11.2 11.2 0 5.3 3.8 9.9 9 11l23.5 4.7c27.7 5.5 47.6 29.8 47.6 58 0 28.9-20.7 52.9-48 58.1l0 25.1-32 0 0-24-40 0 0-48 60.8 0c6.2 0 11.2-5 11.2-11.2 0-5.3-3.8-9.9-9-11l-23.5-4.7c-27.7-5.5-47.6-29.8-47.6-58 0-28.9 20.7-52.9 48-58.1l0-25.1zm-150.5 8l44.9 0 4.7 18 53.4 206-49.6 0-6.2-24-49.4 0-6.2 24-49.6 0 53.4-206 4.7-18zM160 248.7l-12.3 47.3 24.5 0-12.3-47.3z"],
    "car-garage": [640, 512, [], "f5e2", "M333-13.3l256 112 29.3 12.8-25.7 58.6-29.3-12.8-243.2-106.4-243.2 106.4-29.3 12.8-25.7-58.6 29.3-12.8 256-112 12.8-5.6 12.8 5.6zM186 144l268.4 0 7.8 20.8 46.2 123.2 35.8 0 0 224-80 0 0-64-288 0 0 64-80 0 0-224 35.8 0 46.2-123.2 7.8-20.8zm224 64l-179.6 0-30 80 239.6 0-30-80zM192.1 400a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm288-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "person-from-portal": [576, 512, ["portal-exit"], "e023", "M180.3 117.9C164 28.6 132.3-32 96-32 43-32 0 96.9 0 256S43 544 96 544c19.6 0 37.9-17.7 53.1-48l-69.1 0 0-160 108.2 0c1.2-12.7 2.2-25.7 2.8-39l-71-28.4c19.7-49.2 39.8-99.4 60.3-150.6zM416 80a56 56 0 1 0 0-112 56 56 0 1 0 0 112zM256 112l-21.7 0c-1.4 3.4-14.7 36.8-40 100.1l-11.9 29.7 59.4 23.8c5.9-14.8 17.9-44.7 35.8-89.6l41.4 0-22.7 90.6c-8.3 33.2 11 67 43.7 76.8L436 372.2c-38.9 87.5-59.6 134.1-62.2 140l58.5 26 13-29.2c50.9-114.5 77.1-173.5 78.8-177.2-13.5-4.1-56.1-16.8-127.6-38.3l20.7-70.4c14.5 24.8 24 41.1 28.5 48.8l130.4 0 0-64-93.6 0-28.2-48.4C437 130.1 405.4 112 371.2 112L256 112zm19.1 245l-9.7 27-137.4 0 0 64 182.6 0c4.2-11.7 11-30.8 20.4-57.2l-4.7-1.4c-20.4-6.1-37.9-17.6-51.2-32.4z"],
    "fill-drip": [576, 512, [], "f576", "M334.6 1.4L312-21.3c-4 4-41.3 41.3-112 112-37.4-37.4-61.4-61.4-72-72L82.7 64c10.6 10.6 34.6 34.6 72 72l-121.4 121.4-22.6 22.6 22.6 22.6 208 208 22.6 22.6 22.6-22.6 256-256 22.6-22.6-22.6-22.6-208-208zM233.4 214.6L256 237.3 301.3 192c-13.3-13.3-32-32-56-56l66.7-66.7 162.7 162.7-56 56-309.5 0-8-8 98.7-98.7 33.4 33.4zM512 352l-55.7 97.4c-5.5 9.5-8.3 20.4-8.3 31.4 0 34.9 28.3 63.2 63.2 63.2l1.6 0c34.9 0 63.2-28.3 63.2-63.2 0-11-2.9-21.8-8.3-31.4L512 352z"],
    "shield-heart": [512, 512, [], "e574", "M256 0l11.6 4.5 207.5 80.5 19.2 7.4 1.2 20.5c2.9 50-4.9 126.3-37.3 200.9-32.7 75.3-91.1 150-189.4 192.6l-12.7 5.5-12.7-5.5C144.9 463.9 86.6 389.2 53.9 313.9 21.5 239.3 13.7 162.9 16.6 113L17.8 92.5 37 85 244.5 4.5 256 0zm-6.4 183.4c-11.1-14.8-28.5-23.5-46.9-23.5-32.4 0-58.7 26.3-58.7 58.7l0 5.3c0 64 112 128 112 128s112-64 112-128l0-5.3c0-32.4-26.3-58.7-58.7-58.7-18.5 0-35.9 8.7-46.9 23.5l-6.4 8.5-6.4-8.5z"],
    "trash-can-undo": [448, 512, ["trash-can-arrow-turn-left", "trash-undo-alt"], "f896", "M304-16l16 48 128 0 0 64-448 0 0-64 128 0 16-48 160 0zM32 144l384 0 0 368-384 0 0-368zM209 257l17-17-33.9-33.9c-3.5 3.5-30.5 30.5-81 81l-17 17c3.5 3.5 30.5 30.5 81 81l17 17 33.9-33.9c-10.3-10.3-23.6-23.6-40-40l54.1 0c22.1 0 40 17.9 40 40l0 64 48 0 0-64c0-48.6-39.4-88-88-88l-54.1 0 23-23z"],
    "champagne-glass": [256, 512, ["glass-champagne"], "f79e", "M41.4-32l173.4 0 7.5 21.4c19.3 55.1 39.9 139.6 36.6 212-1.7 36.1-9.4 73.3-30.1 102.2-16.4 22.9-39.5 38.6-68.7 45l0 131.4 64 0 0 64-192 0 0-64 64 0 0-131.4C67 342.2 43.9 326.6 27.5 303.6 6.8 274.8-1 237.6-2.6 201.5-6 129 14.6 44.6 33.9-10.6L41.4-32zm24 160l125.3 0C186 94.5 177.8 60.8 169 32L87.3 32c-8.9 28.8-17 62.5-21.8 96z"],
    "person-skiing-nordic": [640, 512, ["skiing-nordic"], "f7ca", "M457.1 16a56 56 0 1 1 0 112 56 56 0 1 1 0-112zM571.2 238.3l-26.9 13.5 0 180.2-32 0 0-164.2c-24.1 12.1-43.2 21.6-57.3 28.6-7.5-9.7-24.7-32.1-51.7-67.3L363.8 298c38 19 63.6 31.8 76.8 38.4-2.3 5.8-18.6 48.4-49.1 127.6L553 464c11.6-7.8 24.3-16.2 37.9-25.3l26.6 39.9c-12.6 8.4-27.3 18.2-44 29.3l-6 4-215.8 0c-.5 0-1 0-1.5 0l-318 0 0-48 98.7 0c6.5-6.5 38.8-38.8 96.8-96.8L238 331.4c11.3 18.3 27.7 33.8 48.4 44.2l4.8 2.4c-3.1 11-5.3 18.6-6.5 22.8l-5.9 5.9-57.4 57.4 101.3 0 37.1-96.4-55.6-27.8C262.7 319 247.5 267 271.5 227.1l37.7-62.7-44.3-12.3c-6.7 33.3-11.8 59.2-15.5 77.6l-26.5-5.3-129.8 207.6-37.7 0 134-214.3-2.8-.6c2.6-12.8 10-49.9 22.3-111.4l6.8-33.8c13.9 3.9 52.4 14.6 115.5 32.1 46.7 13 88 40.8 117.6 79.3l24.9 32.3c28.9-14.5 51.9-26 69-34.5l28.6 57.2z"],
    "diagram-cells": [448, 512, [], "e475", "M448 32l0 192-448 0 0-192 448 0zM384 416l0-64-320 0 0 64 320 0zm64 64l-448 0 0-192 448 0 0 192z"],
    "square-6": [448, 512, [], "e25b", "M448 32l-448 0 0 448 448 0 0-448zM280 144l0 48-72 0c-13.3 0-24 10.7-24 24l0 12.1c7.5-2.7 15.6-4.1 24-4.1l32 0c39.8 0 72 32.2 72 72s-32.2 72-72 72l-32 0c-39.8 0-72-32.2-72-72l0-80c0-39.8 32.2-72 72-72l72 0zM208 320l32 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-32 0c-13.3 0-24 10.7-24 24s10.7 24 24 24z"],
    "square-2": [448, 512, [], "e257", "M448 32l-448 0 0 448 448 0 0-448zM176 145.3l62 0c36.5 0 66 29.6 66 66 0 27.1-16.6 51.5-41.9 61.4l-44.7 17.6c-12.9 5.1-22.1 16.3-24.6 29.6l103.3 0 0 48-152 0 0-40.4c0-36.2 22.1-68.7 55.8-81.9l44.7-17.6c6.9-2.7 11.4-9.4 11.4-16.8 0-10-8.1-18-18-18l-86 0 0-48 24 0z"],
    "arrows-to-dotted-line": [384, 512, [], "e0a6", "M80 48l112 128 112-128-80 0 0-80-64 0 0 80-80 0zm0 416l80 0 0 80 64 0 0-80 80 0-112-128-112 128zM0 224l0 64 64 0 0-64-64 0zm170.7 0l-64 0 0 64 64 0 0-64zm42.7 0l0 64 64 0 0-64-64 0zM384 224l-64 0 0 64 64 0 0-64z"],
    "hat-beach": [640, 512, [], "e606", "M320 32c-88.4 0-160 71.6-160 160l161.1 0c-.8-5.2-1.1-10.6-1.1-16 0-56.9 42.4-103.8 97.3-111-27-20.7-60.7-33-97.3-33zm1.1 224l-161.1 0-160 128 0 64 640 0 0-64-36.5-29.2c-19.9 18.2-46.4 29.2-75.5 29.2-17.2 0-33.5-3.9-48-10.8-14.5 6.9-30.8 10.8-48 10.8-61.9 0-112-50.1-112-112 0-5.4 .4-10.8 1.1-16zM480 314.3c11.7 13.3 28.9 21.7 48 21.7 35.3 0 64-28.7 64-64 0-19.1-8.4-36.3-21.7-48 13.3-11.7 21.7-28.9 21.7-48 0-35.3-28.7-64-64-64-19.1 0-36.3 8.4-48 21.7-11.7-13.3-28.9-21.7-48-21.7-35.3 0-64 28.7-64 64 0 19.1 8.4 36.3 21.7 48-13.3 11.7-21.7 28.9-21.7 48 0 35.3 28.7 64 64 64 19.1 0 36.3-8.4 48-21.7zM440 224l40-40 40 40-40 40-40-40z"],
    "router": [576, 512, [], "f8da", "M352.1 0c79.5 0 151.5 32.2 203.6 84.4l-33.9 33.9C478.4 74.9 418.4 48 352.1 48S225.9 74.9 182.4 118.3L148.5 84.4C200.6 32.2 272.6 0 352.1 0zm0 112c48.6 0 92.6 19.7 124.5 51.5l-33.9 33.9c-23.2-23.2-55.2-37.5-90.5-37.5s-67.3 14.3-90.5 37.5l-33.9-33.9c31.8-31.8 75.8-51.5 124.5-51.5zm24 112l0 96 168 0 0 160-512 0 0-160 296 0 0-96 48 0zm-256 152a24 24 0 1 0 0 48 24 24 0 1 0 0-48zm72 24a24 24 0 1 0 48 0 24 24 0 1 0 -48 0z"],
    "sensor": [448, 512, [], "e028", "M448 32l-448 0 0 448 448 0 0-448zM112 120l0 136-48 0 0-160 48 0 0 24zm96 0l0 136-48 0 0-160 48 0 0 24z"],
    "square-check": [448, 512, [9745, 9989, 61510, "check-square"], "f14a", "M448 480l-448 0 0-448 448 0 0 448zM308.5 151l-119.4 164.2-69.1-69.1-33.9 33.9 88.9 88.9 19.8 19.9 16.5-22.7 135.9-186.9 14.1-19.4-38.8-28.3-14.1 19.4z"],
    "paintbrush-fine": [576, 512, ["paint-brush-alt", "paint-brush-fine", "paintbrush-alt"], "f5a9", "M525.3 141.3L570.5 96 480 5.5c-4.3 4.3-86.2 86.2-245.5 245.5 41.3 16.2 74.3 49.2 90.5 90.5L525.3 141.3zM176 512c61.9 0 112-50.1 112-112S237.9 288 176 288 64 338.1 64 400l0 48-64 0 0 64 176 0z"],
    "bath": [512, 512, [128705, "bathtub"], "f2cd", "M64 0l-32 0 0 256-32 0 0 64 32 0 0 48c0 28.4 12.4 54 32 71.6l0 72.4 64 0 0-48 256 0 0 48 64 0 0-72.4c19.6-17.6 32-43.1 32-71.6l0-48 32 0 0-64-416 0 0-192 18.7 0 18.8 18.8c-3.6 9.1-5.5 18.9-5.5 29.2 0 19.6 7 37.5 18.7 51.4l-12.6 12.6 33.9 33.9 17-17 104-104 17-17-33.9-33.9-12.6 12.6C245.5 39 227.6 32 208 32 197.7 32 187.8 34 178.8 37.5 156.9 15.6 144.4 3.1 141.3 0L64 0z"],
    "chess-bishop": [320, 512, [9821], "f43a", "M64 384L48.3 368.3C17.4 337.4 0 295.4 0 251.7 0 213.1 13.5 175.8 38.2 146.1l68.4-82.1-42.7 0 0-64 192 0 0 64-42.7 0 47.6 57.1-102.9 102.9 33.9 33.9 99.3-99.3c18.7 27.3 28.7 59.7 28.7 93 0 43.7-17.4 85.7-48.3 116.6l-15.7 15.7 64 80 0 48-320 0 0-48 64-80z"],
    "fence": [512, 512, [], "e303", "M80 32l-64 80 0 368 128 0 0-62.6 48 0 0 62.6 128 0 0-62.6 48 0 0 62.6 128 0 0-368-64-80-64 80 0 49.4-48 0 0-49.4-64-80-64 80 0 49.4-48 0 0-49.4-64-80zM368 225.4l0 128-48 0 0-128 48 0zm-176 0l0 128-48 0 0-128 48 0z"],
    "microwave": [576, 512, [], "e01b", "M0 64l576 0 0 384-64 0 0 32-64 0 0-32-320 0 0 32-64 0 0-32-64 0 0-384zm96 96l0 192 288 0 0-192-288 0zm416 0l-48 0 0 192 48 0 0-192z"],
    "alarm-exclamation": [512, 512, [], "f843", "M256 64c123.7 0 224 100.3 224 224 0 50.3-16.6 96.8-44.6 134.2l57.8 57.8-45.3 45.3-57.8-57.8C352.8 495.4 306.3 512 256 512s-96.8-16.6-134.2-44.6L64 525.3 18.8 480 76.6 422.2C48.6 384.8 32 338.3 32 288 32 164.3 132.3 64 256 64zM228 356l0 56 56 0 0-56-56 0zm-4-196l12.8 160 38.4 0 12.8-160-64 0zM95.2 0C123.2 0 148.4 12.1 165.8 31.3 103.7 53.1 51.9 96.9 19.7 153.2 7.3 137.2 0 117.1 0 95.2 0 42.6 42.6 0 95.2 0zM416.7 0c52.6 0 95.3 42.6 95.3 95.2 0 21.8-7.3 41.9-19.7 58-32.2-56.4-84-100.1-146.2-121.9 17.4-19.2 42.6-31.3 70.6-31.3z"],
    "tomato": [512, 512, [], "e330", "M280-32l0 86.9C294.4 40.7 314.2 32 336 32l48 0 0 16c0 31.7-18.4 59-45.1 72 26.7 13 45.1 40.3 45.1 72l0 16-64 0c-26.2 0-49.4-12.6-64-32-14.6 19.4-37.8 32-64 32l-64 0 0-16c0-31.7 18.4-59 45.1-72-26.7-13-45.1-40.3-45.1-72l0-16 48 0c21.8 0 41.6 8.7 56 22.9l0-86.9 48 0zM256 112c0-2.7 .1-5.4 .4-8l-.8 0c.3 2.6 .4 5.3 .4 8zM432 256l0-64c0-18.7-4-36.4-11.2-52.4 55.8 35.5 91.2 91.7 91.2 164.4 0 130.9-114.6 208-256 208S0 434.9 0 304C0 231.2 35.4 175.1 91.2 139.6 84 155.6 80 173.3 80 192l0 64 112 0c23.3 0 45.2-6.2 64-17.1 18.8 10.9 40.7 17.1 64 17.1l112 0z"],
    "prescription-bottle-medical": [384, 512, ["prescription-bottle-alt"], "f486", "M0 0L384 0 384 96 0 96 0 0zM32 144l320 0 0 368-320 0 0-368zm128 88l0 56-56 0 0 64 56 0 0 56 64 0 0-56 56 0 0-64-56 0 0-56-64 0z"],
    "watch-calculator": [384, 512, [], "f8f0", "M80-32l224 0 10.7 96 69.3 0 0 384-69.3 0-10.7 96-224 0-10.7-96-69.3 0 0-384 69.3 0 10.7-96zM320 128l-256 0 0 256 256 0 0-256zm-32 32l0 64-192 0 0-64 192 0zM96 248l48 0 0 48-48 0 0-48zm120 0l0 48-48 0 0-48 48 0zm24 0l48 0 0 48-48 0 0-48zm-96 64l0 48-48 0 0-48 48 0zm24 0l48 0 0 48-48 0 0-48zm120 0l0 48-48 0 0-48 48 0z"],
    "draw-polygon": [512, 512, [58055, "vector-polygon"], "f5ee", "M512 0l-128 0 0 32-256 0 0-32-128 0 0 128 32 0 0 256-32 0 0 128 128 0 0-32 256 0 0 32 128 0 0-128-60.1 0-2-2.7-65.9-91.3 0-67.9 65.9-91.3 2-2.7 60.1 0 0-128zM384 112.7l-57.3 79.3-70.7 0 0 128 70.7 0 2 2.7 55.3 76.5 0 16.7-256 0 0-32-32 0 0-256 32 0 0-32 256 0 0 16.7z"],
    "circle-guarani": [512, 512, [], "e73b", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM240 137.1l0-25.1 32 0 0 25.1c26.3 3.5 50 15.6 68 33.2l-33.6 34.3c-9.4-9.2-21.2-15.8-34.4-18.8l0 46.2 104 0 0 24c0 60.8-45.3 111.1-104 118.9l0 25.1-32 0 0-25.1c-58.7-7.8-104-58.1-104-118.9s45.3-111.1 104-118.9zM184 256c0 34.3 23.9 62.9 56 70.2l0-140.4c-32.1 7.3-56 36-56 70.2zm139.9 24l-51.9 0 0 46.2c24.2-5.5 43.8-23.2 51.9-46.2z"],
    "slider": [576, 512, [], "e252", "M288 96l160 0 0 128 128 0 0 64-128 0 0 128-160 0 0-320zM0 288l0-64 240 0 0 64-240 0z"],
    "i-cursor": [256, 512, [], "f246", "M32 0C70.2 0 104.5 16.8 128 43.3 151.5 16.8 185.8 0 224 0l32 0 0 64-32 0c-35.3 0-64 28.7-64 64l0 96 64 0 0 64-64 0 0 96c0 35.3 28.7 64 64 64l32 0 0 64-32 0c-38.2 0-72.5-16.8-96-43.3-23.5 26.6-57.8 43.3-96 43.3l-32 0 0-64 32 0c35.3 0 64-28.7 64-64l0-96-64 0 0-64 64 0 0-96c0-35.3-28.7-64-64-64L0 64 0 0 32 0z"],
    "cloud-rainbow": [576, 512, [], "f73e", "M552 240c-23.5 0-45.3 7.2-63.4 19.6-8.5-5-17.5-9.1-27-12.3-1.5-7.8-3.8-15.4-6.6-22.6 26.9-20.5 60.5-32.8 97-32.8l24 0 0 48-24 0zm0-96c-46 0-88.5 14.9-122.9 40.2-11.5-12.2-25.3-22.1-40.8-29 44.4-36.9 101.4-59.2 163.7-59.2l24 0 0 48-24 0zm0-96c-87.5 0-166.4 37-221.8 96.1-16.1 .7-31.4 4.4-45.4 10.5-4.9-4.5-10-8.7-15.4-12.6 64.2-86.2 166.9-142.1 282.6-142.1l24 0 0 48-24 0zM96 480l-96 0 0-96c0-41.8 26.7-77.4 64-90.5L64 272c0-61.9 50.1-112 112-112 43.1 0 80.5 24.3 99.2 60 14.7-17.1 36.5-28 60.8-28 44.2 0 80 35.8 80 80l0 16c53 0 96 43 96 96l0 96-416 0z"],
    "heart-circle-plus": [576, 512, [], "e500", "M133.1 32C175.8 32 216 52.5 241 87.1l15 20.7 15-20.7c25-34.6 65.2-55.1 107.9-55.1 73.5 0 133.1 59.6 133.1 133.1 0 19.2-3 38.1-8.5 56.6-22.1-8.9-46.2-13.8-71.5-13.8-106 0-192 86-192 192 0 33 8.3 64 23 91.2-2.4 1.6-4.7 3.3-7 4.8-102.5-70.7-256-194.1-256-330.9 0-73.5 59.6-133.1 133.1-133.1zM432 256a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm16 80l0-16-32 0 0 64-64 0 0 32 64 0 0 64 32 0 0-64 64 0 0-32-64 0 0-48z"],
    "shield-dog": [512, 512, [], "e573", "M256 0l11.6 4.5 207.5 80.5 19.2 7.4 1.2 20.5c2.9 50-4.9 126.3-37.3 200.9-32.7 75.3-91.1 150-189.4 192.6l-12.7 5.5-12.7-5.5C144.9 463.9 86.6 389.2 53.9 313.9 21.5 239.3 13.7 162.9 16.6 113L17.8 92.5 37 85 244.5 4.5 256 0zM160.9 286.2l-16.9 33.8 128 64 0-64 48 0c44.2 0 80-35.8 80-80l0-48-80 0-16-32-64 0 0 64c0 35.3-28.7 64-64 64-5.2 0-10.3-.6-15.1-1.8zM144 160l0 64c0 17.7 14.3 32 32 32s32-14.3 32-32l0-64-64 0zm112 48a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"],
    "file-slash": [576, 512, [], "e3a7", "M49.3-16.9l-17-17-33.9 33.9 17 17 512 512 17 17 33.9-33.9c-.6-.6-33.3-33.3-98.1-98.1l0-270-144-144-240 0 0 30-46.8-46.8zM96.1 512l346.2 0-346.2-346.2 0 346.2zM421.6 176l-117.5 0 0-117.5 117.5 117.5z"],
    "chess-rook-piece": [320, 512, ["chess-rook-alt"], "f448", "M16 32l0 160 48 64 0 128-64 80 0 48 320 0 0-48-64-80 0-128 48-64 0-160-64 0 0 48-48 0 0-48-64 0 0 48-48 0 0-48-64 0z"],
    "greater-than-equal": [448, 512, [], "f532", "M426.1 161.6L0 19.6 0 87.1 314.8 192 0 296.9 0 364.4 426.1 222.4 448 215.1 448 168.9 426.1 161.6zM416 416l-416 0 0 64 448 0 0-64-32 0z"],
    "envelope-open": [512, 512, [62135], "f2b6", "M441.8 187.3L256 48 70.2 187.3 256 320 441.8 187.3zM0 160l256-192 256 192 0 320-512 0 0-320z"],
    "mound": [576, 512, [], "e52d", "M142.6 178.3C173.3 127.2 228.4 96 288 96s114.7 31.2 145.4 82.3L576 416 0 416 142.6 178.3z"],
    "rings-wedding": [512, 512, [], "f81b", "M128.7 102.4L96 48 128 0 224 0 256 48 223.3 102.4C297.5 123.1 352 191.2 352 272 352 318.3 334.1 360.5 304.8 391.9 285.2 381 272 360 272 336l0-6.3c10.2-16.9 16-36.6 16-57.7 0-12-1.9-23.6-5.4-34.5-34.9 19-58.6 56-58.6 98.5 0 61.9 50.1 112 112 112s112-50.1 112-112c0-38.9-19.8-73.1-49.9-93.2-3.7-28.4-12.7-55.1-26-79.1 79.9 16.7 139.9 87.5 139.9 172.3 0 97.2-78.8 176-176 176-55.3 0-104.7-25.5-137-65.5-7.5 1-15.2 1.5-23 1.5-97.2 0-176-78.8-176-176 0-80.8 54.5-148.9 128.7-169.6zM176 160c-61.9 0-112 50.1-112 112 0 58.7 45.1 106.8 102.5 111.6-4.2-15.1-6.5-31.1-6.5-47.6 0-64.4 34.5-120.7 86.1-151.3-19.2-15.4-43.6-24.7-70.1-24.7z"],
    "grill-fire": [640, 512, [], "e5a4", "M64 32l448 0 0 64c0 27.4-4.9 53.7-14 78l-43.1-43.1-32.4 20.2c-25.4 15.9-61.7 45-92.1 83.2-18.8 23.6-36.9 52.6-47.8 85.6-15-.4-29.7-2.2-43.9-5.4l-22.9 53.4 56.8 0c-.4 5.2-.7 10.5-.7 15.8 0 10.9 .8 21.7 2.5 32.2L224 416c0 35.3-28.7 64-64 64s-64-28.7-64-64 28.7-64 64-64c3.4 0 6.8 .3 10.1 .8L193.2 299C116.9 263.3 64 185.8 64 96l0-64zm96 408a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM448 192l64 64 32-32c76.8 64 96 133.3 96 160 0 88.4-71.6 160-160 160S320 472.4 320 384c0-89.6 85.3-165.3 128-192zm96 240.2c0-48-64-96-64-96s-64 48-64 96c0 35.3 28.7 64 64 64s64-28.7 64-64z"],
    "distribute-spacing-horizontal": [448, 512, [], "e365", "M0 0L64 0 64 512 0 512 0 0zM128 96l192 0 0 320-192 0 0-320zM448 0l0 512-64 0 0-512 64 0z"],
    "bowl-soft-serve": [448, 512, [], "e46b", "M224 0l32 0c70.7 0 128 57.3 128 128 0 11.7-3.1 22.6-8.6 32l8.6 0c35.3 0 64 28.7 64 64l0 64-448 0 0-64c0-35.3 28.7-64 64-64l8.6 0c-5.4-9.4-8.6-20.3-8.6-32 0-35.3 28.7-64 64-64l81.3 0c17 0 30.7-13.7 30.7-30.7 0-6.1-1.8-12-5.2-17L224 0zM32 336l384 0 0 8c0 57.4-46.6 104-104 104l-16 0 24 64-192 0 24-64-16 0C78.6 448 32 401.4 32 344l0-8z"],
    "voicemail": [640, 512, [], "f897", "M144 320a80 80 0 1 1 0-160 80 80 0 1 1 0 160zm119.8 0c15.3-22.9 24.2-50.4 24.2-80 0-79.5-64.5-144-144-144S0 160.5 0 240 64.5 384 144 384l352 0c79.5 0 144-64.5 144-144S575.5 96 496 96 352 160.5 352 240c0 29.6 8.9 57.1 24.2 80l-112.5 0zM496 160a80 80 0 1 1 0 160 80 80 0 1 1 0-160z"],
    "vest": [448, 512, [], "e085", "M200 512l0-224-55.6-222.6C162.2 77.3 188.4 88 224 88s61.8-10.7 79.6-22.6l-55.6 222.6 0 224 200 0 0-256-64-96 0-160-84.4 0-6.9 11.1-.3 .4c-.4 .6-1.2 1.5-2.3 2.8-2.3 2.6-6.1 6.3-11.4 10.1-10.6 7.4-28.1 15.6-54.7 15.6s-44.1-8.2-54.7-15.6c-5.4-3.8-9.2-7.5-11.5-10.1-1.1-1.3-1.9-2.3-2.3-2.8l-.3-.4-6.9-11.1-84.4 0 0 160-64 96 0 256 200 0z"],
    "audio-description": [512, 512, [], "f29e", "M0 64l512 0 0 384-512 0 0-384zM96 224l0 128 48 0 0-48 48 0 0 48 48 0 0-128c0-35.3-28.7-64-64-64l-16 0c-35.3 0-64 28.7-64 64zm48 32l0-32c0-8.8 7.2-16 16-16l16 0c8.8 0 16 7.2 16 16l0 32-48 0zm152-96l-24 0 0 192 72 0c39.8 0 72-32.2 72-72l0-48c0-39.8-32.2-72-72-72l-48 0zm48 144l-24 0 0-96 24 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24z"],
    "w": [576, 512, [119], "57", "M507.2 32l67.6 0-144.1 426.2-7.4 21.8-47 0-6.7-23-81.3-278.7-81.3 278.7-6.7 23-47 0-7.4-21.8-144.1-426.2 67.6 0 104.6 309.4 83.5-286.4 6.7-23 48 0 6.7 23 83.5 286.4 104.6-309.4z"],
    "cart-circle-xmark": [640, 512, [], "e3f4", "M24-16l-24 0 0 48 76 0 60.4 332.3 3.6 19.7 164.7 0c1.4-16.7 4.9-32.8 10.3-48l-134.9 0-8.7-48 168.7 0c34.9-48.5 91.7-80 156-80 15.8 0 31.2 1.9 46 5.5L576 32 124.8 32c-3.7-20.3-6.6-36.3-8.7-48L24-16zM208 512a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm288 32a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm55.3-176.7L518.6 400c25.4 25.3 40 40 44 44L540 466.6c-4-4-18.6-18.6-44-44-25.3 25.4-40 40-44 44L429.4 444c4-4 18.6-18.6 44-44-25.4-25.3-40-40-44-44L452 333.4c4 4 18.6 18.6 44 44 25.3-25.4 40-40 44-44l22.6 22.6-11.3 11.3z"],
    "clouds-sun": [576, 512, [], "f746", "M330.5-26.4c1.1 5.5 8.3 41 21.5 106.4 65.4 13.2 100.9 20.4 106.4 21.5-8.1 12.2-18.2 27.4-30.2 45.6-9.1-2-18.5-3.1-28.2-3.1-25.1 0-48.5 7.2-68.2 19.7-12.1-39.2-48.6-67.7-91.8-67.7-53 0-96 43-96 96 0 13.6 2.8 26.5 7.9 38.2-23.8 16.2-41.8 40.3-50.4 68.4-43.4-8.8-70-14.2-80-16.2 3.1-4.7 23.1-34.9 60-90.5-36.9-55.6-56.9-85.8-60-90.5 5.5-1.1 41-8.3 106.4-21.5 13.2-65.4 20.4-100.9 21.5-106.4 4.7 3.1 34.9 23.1 90.5 60 55.6-36.9 85.8-56.9 90.5-60zM273.7 218c-15.3-6.4-32-10-49.7-10-9.6 0-19 1.1-28.1 3.1-2.5-5.8-3.9-12.3-3.9-19.1 0-26.5 21.5-48 48-48s48 21.5 48 48c0 8.1-2 15.8-5.6 22.5-3 1.1-5.9 2.2-8.8 3.5zm213 166c-11.2-27.6-31.7-50.4-57.6-64.5-11-45.6-52.1-79.5-101.1-79.5l-1.3 0c12.3-28.3 40.5-48 73.3-48 35 0 64.8 22.5 75.6 53.8 8.7-3.7 18.3-5.8 28.4-5.8 39.8 0 72 32.2 72 72l0 72-89.3 0zM96 432c0-33.9 21.1-62.9 50.9-74.6-1.9-6.8-2.9-14-2.9-21.5 0-44.2 35.8-80 80-80 30.8 0 57.5 17.4 70.9 42.8 9.3-6.8 20.7-10.8 33.1-10.8 34.2 0 60.9 32 55.2 65.4 36.9 7.1 64.8 39.6 64.8 78.6l0 80-352 0 0-80z"],
    "eye-dropper": [512, 512, ["eye-dropper-empty", "eyedropper"], "f1fb", "M341.6 29.2L240.1 130.8C236 126.7 225.3 116 208 98.7l-45.3 45.3 22.6 22.6 160 160 22.6 22.6 45.3-45.3c-17.3-17.3-28-28-32.1-32.1L482.8 170.4c39-39 39-102.2 0-141.1s-102.2-39-141.1 0zM32 344l0 88-3.7 5.5C10.1 464.9 .6 479.1 0 480l32 32 8-5.3 34.5-23 5.5-3.7 88 0 131.4-131.4-45.3-45.3-112.7 112.7-45.5 0 0-45.5 112.7-112.7-45.3-45.3-131.4 131.4z"],
    "circle-xmark": [512, 512, [61532, "times-circle", "xmark-circle"], "f057", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM172.1 305.9L222.1 256c-38.8-38.8-61.1-61.1-66.9-66.9l33.9-33.9 66.9 66.9c38.8-38.8 61.1-61.1 66.9-66.9l33.9 33.9c-5.8 5.8-28.1 28.1-66.9 66.9 38.8 38.8 61.1 61.1 66.9 66.9l-33.9 33.9c-5.8-5.8-28.1-28.1-66.9-66.9-38.8 38.8-61.1 61.1-66.9 66.9l-33.9-33.9 17-17z"],
    "trailer": [640, 512, [], "e041", "M32 32l512 0 0 320 96 0 0 64-328.4 0c.2 2.6 .4 5.3 .4 8 0 48.6-39.4 88-88 88s-88-39.4-88-88c0-2.7 .1-5.4 .4-8L32 416 32 32zm432 80l-48 0 0 208 48 0 0-208zm-352 0l0 208 48 0 0-208-48 0zm200 0l-48 0 0 208 48 0 0-208zM264 424a40 40 0 1 0 -80 0 40 40 0 1 0 80 0z"],
    "turkish-lira-sign": [448, 512, ["try", "turkish-lira"], "e2bb", "M192 32l0 75.6 121.4-34.7 23.1-6.6 13.2 46.2-23.1 6.6-134.6 38.5 0 46.1 121.4-34.7 23.1-6.6 13.2 46.2-23.1 6.6-134.6 38.5 0 162.5 72 0c53 0 96-43 96-96l64 0c0 88.4-71.6 160-160 160l-136 0 0-208.2c-17.3 4.9-33.5 9.6-48.5 13.9L66.3 239.5c12.8-3.7 33.4-9.5 61.7-17.6l0-46.1c-17.3 5-33.5 9.6-48.5 13.9L66.3 143.5c12.8-3.7 33.4-9.5 61.7-17.6l0-93.9 64 0z"],
    "gauge-circle-minus": [640, 512, [], "e497", "M288 0c126.8 0 232.1 92.2 252.4 213.2-14.3-3.4-29.1-5.2-44.4-5.2-70.9 0-132.8 38.4-166.1 95.6-5.3-4.6-11.3-8.3-17.9-11l0-196.7-48 0 0 196.7c-23.5 9.5-40 32.5-40 59.3 0 35.3 28.7 64 64 64 5.7 0 11.2-.7 16.5-2.1 2.5 34.5 14 66.4 32.3 93.5-15.8 3-32.1 4.6-48.8 4.6-141.4 0-256-114.6-256-256S146.6 0 288 0zM176 176a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm-16 80a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM432 144a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM352 400a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm224 16l0-32-160 0 0 32 160 0z"],
    "draw-square": [512, 512, [62923, "vector-square"], "f5ef", "M384 0l128 0 0 128-32 0 0 256 32 0 0 128-128 0 0-32-256 0 0 32-128 0 0-128 32 0 0-256-32 0 0-128 128 0 0 32 256 0 0-32zM96 128l0 256 32 0 0 32 256 0 0-32 32 0 0-256-32 0 0-32-256 0 0 32-32 0z"],
    "mountains": [640, 512, [9968], "f6fd", "M637 480L565.9 480 553 456.7 381.4 145.3 416 83.2 637 480zm-126-.2L1 479.8 256 17.3 511 479.8zM186.7 275.5l24.3 24.2 60-59.7 34.7 0-49.7-90.1-69.3 125.7z"],
    "truck-tow": [640, 512, [], "e2b8", "M120-32l-24 0 0 160c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-32-48 0 0 32c0 35.3 28.7 64 64 64s64-28.7 64-64l0-64 48 192-160 0 0 192 67.3 0c10.4 36.9 44.4 64 84.7 64s74.2-27.1 84.7-64l102.6 0c10.4 36.9 44.4 64 84.7 64s74.2-27.1 84.7-64l67.3 0 0-192-64-160-192 0 0 156.8-204.7-275.1-7.2-9.7-20.1 0zM500.7 160l38.4 96-123.1 0 0-96 84.7 0zM144 424a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zm312-40a40 40 0 1 1 0 80 40 40 0 1 1 0-80z"],
    "location-minus": [384, 512, ["map-marker-minus"], "f609", "M0 188.6C0 84.4 86 0 192 0S384 84.4 384 188.6C384 339.4 192 528 192 528S0 339.4 0 188.6zM120 168l-24 0 0 48 192 0 0-48-168 0z"],
    "shield-xmark": [512, 512, ["shield-times"], "e24c", "M256 0l11.6 4.5 207.5 80.5 19.2 7.4 1.2 20.5c2.9 50-4.9 126.3-37.3 200.9-32.7 75.3-91.1 150-189.4 192.6l-12.7 5.5-12.7-5.5C144.9 463.9 86.6 389.2 53.9 313.9 21.5 239.3 13.7 162.9 16.6 113L17.8 92.5 37 85 244.5 4.5 256 0zm84.8 189.1l-33.9-33.9c-8.5 8.5-25.5 25.5-50.9 50.9-25.5-25.5-42.4-42.4-50.9-50.9l-33.9 33.9c8.5 8.5 25.5 25.5 50.9 50.9-25.5 25.5-42.4 42.4-50.9 50.9l33.9 33.9c8.5-8.5 25.5-25.5 50.9-50.9 25.5 25.5 42.4 42.4 50.9 50.9l33.9-33.9c-8.5-8.5-25.5-25.5-50.9-50.9 25.5-25.5 42.4-42.4 50.9-50.9z"],
    "face-shush": [512, 512, [], "e38c", "M512 256c0 88-44.4 165.6-112 211.7l0-131.7-64 0 0-5.4c20.6-11.9 38.3-28.3 51.8-47.8l-39.5-27.3c-3.7 5.3-7.8 10.3-12.2 14.8l0-46.4-144 0 0 59.9c-11-7.7-20.6-17.3-28.2-28.4l-39.5 27.3c16.8 24.4 40.3 43.9 67.8 55.9l0 21.3c-29.1 21.9-48 56.7-48 96l0 16C144 477 144.3 481.9 144.9 486.7 59.2 445.3 0 357.6 0 256 0 114.6 114.6 0 256 0S512 114.6 512 256zM208 160a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm128 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM264 432c-13.3 0-24 10.7-24 24l0 16c0 13.3 10.7 24 24 24l88 0 0 48-88 0c-39.8 0-72-32.2-72-72l0-16c0-31.4 20-58 48-67.9l0-116.1 48 0 0 112 64 0 0 80-48 0 0-32-40 0z"],
    "square-eurozone": [448, 512, [], "e727", "M448 32l-448 0 0 448 448 0 0-448zM104 144l96 0 0 48-72 0 0 43.2 64 0 0 48-64 0 0 36.8 73.6 0 0 48-121.6 0 0-224 24 0zm152 0l115.8 0c-1.5 3.8-25.5 62.4-72 176l68.3 0 0 48-139.7 0c1.5-3.8 25.5-62.4 72-176l-68.3 0 0-48 24 0z"],
    "head-side-speak": [640, 512, [], "e75f", "M64.4 512l256 0 0-192 64 0 0-64-49.7-59.6C321.1 85.7 226.8 0 112.4 0 96 0 79.9 1.8 64.4 5.2l0 506.8zm112-320a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm0 232l0-40 96-24 0 72-96-8zm357-216l-33.9 33.9 17 17c71.9 71.9 71.9 188.4 0 260.2l-17 17 33.9 33.9 17-17c90.6-90.6 90.6-237.5 0-328.1l-17-17zm-67.9 67.9l-33.9 33.9 17 17c34.4 34.4 34.4 90.1 0 124.5l-17 17 33.9 33.9 17-17c53.1-53.1 53.1-139.2 0-192.3l-17-17z"],
    "house-day": [640, 512, [], "e00e", "M192 16c8.2 0 16.3 .9 24 2.6l0-74.6-48 0 0 74.6c7.7-1.7 15.8-2.6 24-2.6zm60.4 17.7c13.6 8.7 25.2 20.3 33.9 33.9 27-27 44.6-44.6 52.7-52.7L305.1-19.1c-8.2 8.2-25.8 25.8-52.7 52.7zM170.6 193.1l88.7-79.9c-7.7-28.4-33.7-49.3-64.5-49.3-36.9 0-66.8 29.9-66.8 66.8 0 28.4 17.7 52.6 42.6 62.3zm-39 29.2c-13.6-8.7-25.2-20.3-33.9-33.9l-52.7 52.7 33.9 33.9c8.2-8.2 25.8-25.8 52.7-52.7zM80 128c0-8.2 .9-16.3 2.6-24l-74.6 0 0 48 74.6 0c-1.7-7.7-2.6-15.8-2.6-24zM97.7 67.6c8.7-13.6 20.3-25.2 33.9-33.9-27-27-44.6-44.6-52.7-52.7L44.9 14.9 97.7 67.6zM557.5 336l50.5 0 0-40-240-216-240 216 0 40 50.5 0 0 208 379.1 0 0-208zM320 288l96 0 0 96-96 0 0-96z"],
    "volcano": [512, 512, [127755], "f770", "M160 144c-35.3 0-64-28.7-64-64s28.7-64 64-64c15.7 0 30 5.6 41.2 15 11.2-18.6 31.6-31 54.8-31s43.6 12.4 54.8 31c11.1-9.4 25.5-15 41.2-15 35.3 0 64 28.7 64 64s-28.7 64-64 64l-48 0-32 48-32 0-32-48-48 0zM298.4 272l-84.9 0-66.2 74.5 92.6-26.5 80 64 54-27-75.6-85zM192 224l128 0 192 216 0 72-512 0 0-72 192-216z"],
    "wand-sparkles": [512, 512, [], "f72b", "M0 432l80 80 288-320 48 0 0-53.3 96-106.7-32-32-284.4 256-67.6 0 0 60.8-128 115.2zm432 16l24-56 56-24-56-24-24-56-24 56-56 24 56 24 24 56zM56 168l24 56 24-56 56-24-56-24-24-56-24 56-56 24 56 24zM208 96l16-32 32-16-32-16-16-32-16 32-32 16 32 16 16 32z"],
    "fire-flame": [384, 512, ["flame"], "f6df", "M203.1 9.7L192 0 180.9 9.7C104.2 76.8 45.7 162.2 10.9 258 3.7 277.8 0 299 0 320.2 0 425.4 86.8 512 192 512s192-86.6 192-191.8c0-21.1-3.7-42.3-10.9-62.2-34.8-95.8-93.3-181.2-170-248.3zM208 144l0 15.9c0 12.9 5.2 25.2 14.3 34.2l47.1 46.4c22.1 21.8 34.6 51.5 34.6 82.5 0 60.2-48.8 109-109 109l-3 0c-61.9 0-112-50.6-112-112.4 0-25.5 12-49.6 32.4-64.9l15.6-11.7 0 55c0 24.3 19.8 44 44.1 44 24.2 0 43.9-19.6 43.9-43.8 0-11.6-4.6-22.8-12.8-31l-16.8-16.8c-11.7-11.7-18.3-27.7-18.3-44.3 0-19 8.6-37 23.5-48.9L208 144z"],
    "bowling-ball-pin": [640, 512, [], "e0c3", "M240 512a208 208 0 1 1 0-416 208 208 0 1 1 0 416zM632 384l-64 128-112 0-21.1-42.2c38-44.7 61.1-102.6 61.1-165.8 0-34-6.7-66.3-18.7-96l91.8 0 62.8 176zM228 232a28 28 0 1 0 0 56 28 28 0 1 0 0-56zm-72-40a28 28 0 1 0 0 56 28 28 0 1 0 0-56zm72-48a28 28 0 1 0 0 56 28 28 0 1 0 0-56zM512 0c35.3 0 64 28.7 64 64l0 5.8c0 6.8-1 13.6-2.9 20.1l-21.1 70.2-80 0-21-70.2c-2-6.5-3-13.3-3-20.1l0-5.8c0-35.3 28.7-64 64-64z"],
    "microphone": [384, 512, [], "f130", "M288 0L96 0 96 224c0 53 43 96 96 96s96-43 96-96L288 0zM48 184l0-24-48 0 0 64c0 97.9 73.3 178.7 168 190.5l0 49.5-72 0 0 48 192 0 0-48-72 0 0-49.5c94.7-11.8 168-92.6 168-190.5l0-64-48 0 0 64c0 79.5-64.5 144-144 144S48 303.5 48 224l0-40z"],
    "crown": [576, 512, [128081], "f521", "M307 91.2c12.5-6.8 21-20 21-35.2 0-22.1-17.9-40-40-40s-40 17.9-40 40c0 15.2 8.5 28.4 21 35.2L176 224 88.9 158.7c4.5-6.4 7.1-14.3 7.1-22.7 0-22.1-17.9-40-40-40s-40 17.9-40 40c0 21.8 17.5 39.6 39.2 40l40.8 272 384 0 40.8-272c21.7-.4 39.2-18.2 39.2-40 0-22.1-17.9-40-40-40s-40 17.9-40 40c0 8.4 2.6 16.3 7.1 22.7L400 224 307 91.2z"],
    "tent-arrow-turn-left": [576, 512, [], "e580", "M31.5 113c57.2 57.2 86.8 86.8 89 89l33.9-33.9-48-48 54.1 0 0 0 336 0 0 88 48 0 0-136-312 0 0 0-126.1 0c23-23 39-39 48-48l-33.9-33.9-89 89-17 17 17 17zM94.2 277.3l-29.7 234.7 222.9 0 0-160 97.1 160 128 0-29.7-234.7-195.4-117.3-193.1 117.3z"],
    "truck-fast": [640, 512, ["shipping-fast"], "f48b", "M64 32l416 0 0 96 77.3 0 9.4 9.4 64 64 9.4 9.4 0 237.3-67.3 0c-10.4 36.9-44.4 64-84.7 64s-74.2-27.1-84.7-64l-102.6 0c-10.4 36.9-44.4 64-84.7 64s-74.2-27.1-84.7-64l-67.3 0 0-112-64 0 0-48 160 0 0-48-160 0 0-48 224 0 0-48-224 0 0-48 64 0 0-64zM576 288l0-50.7-45.3-45.3-50.7 0 0 96 96 0zM256 424a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zm232 40a40 40 0 1 0 0-80 40 40 0 1 0 0 80z"],
    "user-pen": [640, 512, ["user-edit"], "f4ff", "M256 8a120 120 0 1 1 0 240 120 120 0 1 1 0-240zm34.7 416.9l-14.5 87.1-228.2 0 64-208 288 0 2.7 8.9-112 112zM544 239.9l80 80-52.8 52.8-80-80 52.8-52.8zm-208 208l132.6-132.6 80 80-132.6 132.6-96 16 16-96z"],
    "square-norwegian-krone": [448, 512, [], "e707", "M448 32l-448 0 0 448 448 0 0-448zM144 128l0 126.1c43-43 67-67 72-72L249.9 216c-7.8 7.8-26.1 26.1-54.7 54.7l53.3 99-42.3 22.8c-3.6-6.7-19.1-35.5-46.5-86.3l-15.8 15.8 0 62.1-48 0 0-256 48 0zm160 78.2c9.6-4.1 20-6.2 30.6-6.2l33.4 0 0 48-33.4 0c-8.1 0-15.9 3.2-21.7 9s-9 13.5-9 21.7l0 105.4-48 0 0-192 48 0 0 14.2z"],
    "person-snowmobiling": [512, 512, ["snowmobile"], "f7d1", "M192 48a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM309.5 85.3l-10.7-21.5-42.9 21.5c3.6 7.2 17.9 35.7 42.7 85.5l0 .1-23.2 29-99.4-71.8-80 0 0 96-64 0 0 112c-19.4 14.6-32 37.8-32 64 0 44.2 35.8 80 80 80l160 0c44.2 0 80-35.8 80-80 0-18-6-34.6-16-48l53.6 0 4.6 10.1 32.3 69.9-43.5 0 0 48 161 0 0-80-48 0 0 32-16.6 0-36.9-80C466.7 350.7 512 304.6 512 248l0-8-166.9-83.4-3.6-7.3-32-64zM80 368l160 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L80 432c-17.7 0-32-14.3-32-32s14.3-32 32-32z"],
    "burger-soda": [576, 512, [], "f858", "M240-16l-18.4 0-4.8 17.8-25.1 94.2-151.7 0 0 48 24 0 32 368 112 0 0-199.8c9.6-28.1 25-53.1 46-74.2 27.3-27.3 68.4-52.7 127-60.1l3-34 24 0 0-48-166.6 0 17.1-64 61.6 0 0-48-80 0zm16 559.8l320 0 0-64-320 0 0 64zM576 320s-32-96.1-160-96.2C288 224 256 320 256 320l0 47.8 320 0 0-47.8zm0 127.8l0-48-320 0 0 48 320 0zM400 272a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm-64 16a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm144 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"],
    "rabbit-running": [640, 512, ["rabbit-fast"], "f709", "M480 32l-24 0-4.7 16.5c-3.2 11.2-5 22.5-5.6 33.8 23.5 20.8 41.5 47.4 51.9 77.7l-25.6 0c-18-44.5-55.4-79-102.1-93l-9.8-3-32 16 7.1 19.7c13.5 37.5 39.5 68.4 72.9 88.2l0 26.8-104.3-59.6c-30.9-17.7-65.9-26.9-101.5-26.9-32.3 0-62.2 16.8-78.9 44.4-10.3-12.5-25.8-20.4-43.2-20.4-30.9 0-56 25.1-56 56s25.1 56 56 56c11.3 0 21.8-3.3 30.6-9.1 4.9 17.2 14.5 33.1 28.4 45.9l151.4 138.8 9.2 8.4 172.4 0 0-64-128 0 0-43.5c0-42.9-28.4-80.5-69.6-92.3l-30.8-8.8 8.8-30.8 30.8 8.8c55 15.7 92.8 65.9 92.8 123.1l0 15.7 56-32.4 6.4-3.7 161.6 0 0-88.9-71-57.9c8-48.9-7.6-99.1-42.8-135L480 32zM184.1 408.4l-26.8 17.5 35 53.6c17.6-11.5 36-23.5 55-35.9l-48.7-44.6-14.5 9.5zM504 240a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"],
    "dial-max": [576, 512, [], "e15e", "M320 0l0 64-64 0 0-64 64 0zM128 64l0 64-64 0 0-64 64 0zm384 0l0 64-64 0 0-64 64 0zm0 192l64 0 0 64-64 0 0-64zm0 192l0 64-64 0 0-64 64 0zM64 448l64 0 0 64-64 0 0-64zM0 256l64 0 0 64-64 0 0-64zm401.4-81.3c56.7 56.7 62 145.4 15.7 208l-111.9-111.9-17-17-33.9 33.9 17 17 111.9 111.9c-62.6 46.2-151.3 41-208-15.7-62.5-62.5-62.5-163.8 0-226.3s163.8-62.5 226.3 0z"],
    "face-hushed": [512, 512, [], "e37b", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM176 224a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm128 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm-48 80a48 48 0 1 1 0 96 48 48 0 1 1 0-96zM192 164c-4.2 0-8.4 .3-12.5 .8-20.3 2.7-38.9 11.9-53.8 25.8L111 204.3 83.7 175 98.3 161.4c20.6-19.3 46.8-32.4 75.9-36.2 5.8-.8 11.7-1.2 17.7-1.2l20 0 0 40-20 0zm140.5 .8c-4.1-.5-8.3-.8-12.5-.8l-20 0 0-40 20 0c6 0 11.9 .4 17.7 1.2 29.1 3.8 55.3 17 75.9 36.2l14.6 13.7-27.3 29.2-14.6-13.7c-14.9-13.9-33.5-23.1-53.8-25.8z"],
    "stocking": [384, 512, [], "f7d5", "M384 0l-320 0 0 96 320 0 0-96zM96 144l0 112-40.3 26.9C20.9 306.1 0 345.1 0 386.9l0 2.2c0 67.8 55 122.8 122.8 122.8 24.2 0 48-7.2 68.1-20.6L352 384 352 144 96 144z"],
    "circle-danish-krone": [512, 512, [], "e746", "M0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zM176 152l0-24-48 0 0 256 48 0 0-62.1 15.8-15.8c27.4 50.8 42.9 79.6 46.5 86.3l42.3-22.8-53.3-99c28.6-28.7 46.9-46.9 54.7-54.7L248 182.1c-5 5-29 29-72 72L176 152zm160 40l-48 0 0 192 48 0 0-105.4c0-8.1 3.2-15.9 9-21.7s13.5-9 21.7-9l33.4 0 0-48-33.4 0c-10.6 0-21 2.2-30.6 6.2l0-14.2zm40 192a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"],
    "user-clock": [576, 512, [], "f4fd", "M224 8a120 120 0 1 1 0 240 120 120 0 1 1 0-240zm16 392c0 41.8 13.4 80.5 36 112l-260 0 64-208 185.7 0c-16.3 28.2-25.7 61-25.7 96zm48 0a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm160-80l-32 0 0 96 80 0 0-32-48 0 0-64z"],
    "face-downcast-sweat": [512, 512, [], "e371", "M49.7 10.4C38.9 20.9 20.9 40.1 9.6 61.7 4.1 72.4 0 84.2 0 96 0 132.4 27.6 160 64 160s64-27.6 64-64c0-11.8-4.1-23.6-9.6-34.3-11.2-21.6-29.2-40.8-40-51.3-4.6-4.5-9.4-8.7-14.3-12.9-4.9 4.2-9.7 8.4-14.3 12.9zM256 512c141.4 0 256-114.6 256-256S397.4 0 256 0c-37.4 0-72.9 8-104.9 22.4 12.5 18.8 25 44.2 25 73.6 0 62.9-49.1 112-112 112-20.7 0-39.9-5.3-56.3-14.6-5 20-7.7 41-7.7 62.6 0 141.4 114.6 256 256 256zm-63.7-89.6l-42.4-22.5C170 361.9 210 336 256 336s86 25.9 106.1 63.9l-42.4 22.5C307.6 399.5 283.6 384 256 384s-51.6 15.5-63.7 38.4zM120 240l104 0 0 48-128 0 0-48 24 0zm168 0l128 0 0 48-128 0 0-48z"],
    "shield-plus": [512, 512, [], "e24a", "M256 0l11.6 4.5 207.5 80.5 19.2 7.4 1.2 20.5c2.9 50-4.9 126.3-37.3 200.9-32.7 75.3-91.1 150-189.4 192.6l-12.7 5.5-12.7-5.5C144.9 463.9 86.6 389.2 53.9 313.9 21.5 239.3 13.7 162.9 16.6 113L17.8 92.5 37 85 244.5 4.5 256 0zM232 336l48 0 0-72 72 0 0-48-72 0 0-72-48 0 0 72-72 0 0 48 72 0 0 72z"],
    "accent-grave": [192, 512, [], "60", "M144 0l32 224-64 0-80-224 112 0z"],
    "headphones-slash": [576, 512, [], "e77c", "M49.3-16.9l-17-17-33.9 33.9 17 17 512 512 17 17 33.9-33.9c-3.7-3.7-30.2-30.2-79.4-79.4 8.4-14.3 13.3-30.9 13.3-48.7l0-160c0-123.7-100.3-224-224-224-61.3 0-116.9 24.7-157.4 64.6L49.3-16.9zM176 109.8c28.9-28.4 68.4-45.8 112.1-45.8 88.4 0 160 71.6 160 160l0 32-96 0 0 30-176.1-176.1zM186.3 256l-58.2 0 0-32c0-8.3 .6-16.4 1.8-24.3L77.6 147.3c-8.7 23.9-13.5 49.8-13.5 76.7l0 160c0 53 43 96 96 96l64 0 0-186.2-37.8-37.8z"],
    "hood-cloak": [512, 512, [], "f6ef", "M0 464l0 48 512 0 0-48-64-96 0-149.9c0-37.9-11.2-75-32.2-106.5L384 64 448 32 448 0 288 0C164.3 0 64 100.3 64 224l0 144-64 96zm352-16l-192 0 0-160c0-53 43-96 96-96s96 43 96 96l0 160z"],
    "file-odf": [576, 512, [], "e7fc", "M280 380c24.3 0 44 19.7 44 44l0 80c0 24.3-19.7 44-44 44l-16 0c-24.3 0-44-19.7-44-44l0-80c0-24.3 19.7-44 44-44l16 0zm120 0c28.7 0 52 23.3 52 52l0 64c0 28.7-23.3 52-52 52l-52 0 0-168 52 0zm164 40l-48 0 0 24 48 0 0 40-48 0 0 64-40 0 0-168 88 0 0 40zM416 144l0 192-240 0 0 176-144 0 0-512 240 0 144 144zM264 420c-2.2 0-4 1.8-4 4l0 80c0 2.2 1.8 4 4 4l16 0c2.2 0 4-1.8 4-4l0-80c0-2.2-1.8-4-4-4l-16 0zm124 88l12 0c6.6 0 12-5.4 12-12l0-64c0-6.6-5.4-12-12-12l-12 0 0 88zM240 176L357.5 176 240 58.5 240 176z"],
    "square-arrow-up": [448, 512, ["arrow-square-up"], "f33c", "M448 32l-448 0 0 448 448 0 0-448zM241 135l80 80 17 17-33.9 33.9c-7.6-7.6-26.3-26.3-56-56l0 174.1-48 0 0-174.1c-29.7 29.7-48.4 48.4-56 56l-33.9-33.9 97-97 17-17 17 17z"],
    "clock-ten-thirty": [512, 512, [], "e355", "M256 512a256 256 0 1 1 0-512 256 256 0 1 1 0 512zm24-120l0-148.8-10.7-7.1c-76.7-51.1-115.3-76.9-116-77.3l-26.6 39.9c2.4 1.6 37.5 25 105.3 70.2l0 147.2 48 0 0-24z"],
    "square-4": [448, 512, [], "e259", "M448 32l-448 0 0 448 448 0 0-448zM192 144l0 112 48 0 0-112 48 0 0 112 32 0 0 48-32 0 0 64-48 0 0-64-96 0 0-160 48 0z"],
    "shower": [512, 512, [128703], "f2cc", "M32 32l-32 0 0 448 64 0 0-384 50.7 0 26.7 26.7c-21 38.9-17.4 87.5 10.9 123l-1.3 1.3-17 17 33.9 33.9 17-17 160-160 17-17-33.9-33.9-17 17-1.3 1.3c-35.5-28.3-84.1-31.9-123-10.9-28.5-28.5-43.7-43.7-45.5-45.5L32 32zM256 352a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm64 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm0-128a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm64 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm0-128a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm64 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm32-32a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "square-sterling": [448, 512, [], "e713", "M0 32l448 0 0 448-448 0 0-448zM202.3 256c-1.3-7.2-3.4-14.4-6.3-21.3l-1.4-3.5c-10.8-26.3 8.5-55.2 37-55.2l2.2 0c9.3 0 18.3 3 25.7 8.6l14.2 10.6 28.8-38.4-14.2-10.6c-15.7-11.8-34.9-18.2-54.5-18.2l-2.2 0c-62.6 0-105.2 63.6-81.4 121.5l1.4 3.5c.4 1 .8 2 1.1 3l-24.8 0 0 32 26.6 0c-1.9 8.2-5.5 16.1-10.8 23-14.7 18.9-22.6 29.1-23.7 30.5l0 42.5 200 0 0-48-135.1 0c10.1-14.5 16.3-31 18.3-48l84.8 0 0-32-85.7 0z"],
    "fishing-rod": [448, 512, [], "e3a8", "M284.6 0l91.4 0 0 160-48 0 0-112-36.6 0-203.4 58.1 0 181.9 40 0 0 224-128 0 0-224 40 0 0-218.1 17.4-5 224-64 3.2-.9zM256 344c0-76.8 64-136 96-152 32 16 96 75.2 96 152 0 32-16 80-64 112l32 40 0 16-128 0 0-16 32-40c-48-32-64-80-64-112zm128-32a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"],
    "square-caret-up": [448, 512, ["caret-square-up"], "f151", "M448 32l-448 0 0 448 448 0 0-448zM224 152l136 168-272 0 136-168z"],
    "circle-arrow-up-left": [512, 512, [], "e0fb", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm40-304l-54.1 0 103 103 17 17-33.9 33.9-17-17-103-103 0 78.1-48 0 0-160 160 0 0 48-24 0z"],
    "box-dollar": [448, 512, ["box-usd"], "f4a0", "M369.4 128l-121.4 0 0-48 87.1 0 34.3 48zM200 128l-121.4 0 34.3-48 87.1 0 0 48zM368 16l-288 0-80 112 0 352 448 0 0-352-80-112zM248 192l0 24 28 0 0 40-67.5 0c-6.9 0-12.5 5.6-12.5 12.5 0 6.1 4.4 11.3 10.4 12.3l41.7 7c25.3 4.2 43.9 26.1 43.9 51.8 0 26.1-19 47.7-44 51.8l0 24.7-40 0 0-24-44 0 0-40 75.5 0c6.9 0 12.5-5.6 12.5-12.5 0-6.1-4.4-11.3-10.4-12.3l-41.7-7c-25.3-4.2-43.9-26.1-43.9-51.8 0-28.8 23.2-52.2 52-52.5l0-24 40 0z"],
    "theta": [384, 512, [], "f69e", "M64 256C64 200 80.2 150.7 104.9 116.2 129.6 81.6 160.8 64 192 64s62.4 17.6 87.1 52.2C303.8 150.7 320 200 320 256s-16.2 105.3-40.9 139.8C254.4 430.4 223.2 448 192 448s-62.4-17.6-87.1-52.2C80.2 361.3 64 312 64 256zM192 0C134.8 0 86 32.5 52.8 79 19.6 125.6 0 188.2 0 256S19.6 386.4 52.8 433c33.2 46.5 82 79 139.2 79s106-32.5 139.2-79C364.4 386.4 384 323.8 384 256S364.4 125.6 331.2 79C298 32.5 249.2 0 192 0zM144 224l-32 0 0 64 160 0 0-64-128 0z"],
    "face-smile-tongue": [512, 512, [], "e394", "M478.9 382.1C500 344.9 512 301.8 512 256 512 114.6 397.4 0 256 0S0 114.6 0 256 114.6 512 256 512c26.5 0 52-4 76-11.5-4.2-3-8.2-6.4-12-10.2l-58.4-58.4c-1.9 .1-3.7 .1-5.6 .1-87.9 0-161.4-61.6-179.6-144l49.6 0c17.1 55.6 68.8 96 130 96s112.9-40.4 130-96l49.6 0c-2.4 10.8-5.8 21.3-10 31.3L458.3 352c8.9 8.9 15.8 19.2 20.5 30.1zm-160.2 39l35.3 35.3c19.5 19.5 51 19.5 70.4 0s19.5-51 0-70.4L400.4 362c-21 26.6-49.3 47.3-81.8 59.1zM176 180c-15.5 0-28 12.5-28 28l0 28-40 0 0-28c0-37.6 30.4-68 68-68s68 30.4 68 68l0 28-40 0 0-28c0-15.5-12.5-28-28-28zm132 28l0 28-40 0 0-28c0-37.6 30.4-68 68-68s68 30.4 68 68l0 28-40 0 0-28c0-15.5-12.5-28-28-28s-28 12.5-28 28z"],
    "file-vector": [384, 512, [], "e64c", "M0 0L240 0 384 144 384 512 0 512 0 0zM208 58.5L208 176 325.5 176 208 58.5zM152 232l-64 0 0 64 24 0 0 80-24 0 0 64 64 0 0-24 80 0 0 24 64 0 0-64-24 0 0-80 24 0 0-64-64 0 0 24-80 0 0-24zm80 64l0 80-80 0 0-80 80 0z"],
    "video-arrow-up-right": [576, 512, [], "e2c9", "M32 64l384 0 0 384-384 0 0-384zM464 341.3l0-170.7 112-74.7 0 320-112-74.7zM184 208l54.1 0-103 103-17 17 33.9 33.9 17-17 103-103 0 78.1 48 0 0-160-160 0 0 48 24 0z"],
    "map-location": [640, 512, ["map-marked"], "f59f", "M576 64l0-51.8c-19.2 9.6-73.4 36.7-162.5 81.2l-179.4-59.8-12.6-4.2-11.9 5.9-128 64-17.7 8.8 0 391.6c19.2-9.6 73.4-36.7 162.5-81.2L387 472.1c-7.1-11.9-13.8-24.3-19.8-37.1-6.1-13.2-11.6-27.4-15.8-42.2l-95.4-31.8 0-252.5 128 42.7 0 83.3c31-35.8 77-58.4 128-58.4 22.6 0 44.2 4.4 64 12.5L576 64zM392 341.9C392 436.1 512 554 512 554S632 436.1 632 341.9C632 276.8 578.3 224 512 224S392 276.8 392 341.9z"],
    "table-cells-header-lock": [640, 512, [], "e6ae", "M384 224l0 48-16 0 0 208-304 0 0-448 448 0 0 113c-46.7 5.8-85.6 36.8-102.7 79L384 224zm-64 0l-64 0 0 64 64 0 0-64zm-128 0l-64 0 0 64 64 0 0-64zm64 128l0 64 64 0 0-64-64 0zm-128 0l0 64 64 0 0-64-64 0zM528 240c-17.7 0-32 14.3-32 32l0 48 64 0 0-48c0-17.7-14.3-32-32-32zm-80 32c0-44.2 35.8-80 80-80s80 35.8 80 80l0 48 32 0 0 192-224 0 0-192 32 0 0-48z"],
    "face-icicles": [512, 512, [], "e37c", "M320 503.9c-20.5 5.3-41.9 8.1-64 8.1-85.7 0-161.5-42.1-208-106.7l0 74.7-48 0 0-224C0 114.6 114.6 0 256 0S512 114.6 512 256l0 224-48 0 0-74.7c-24.7 34.3-57.7 62.3-96 81l0 57.7-48 0 0-40.1zm36-104.1c24.6-2 44-22.7 44-47.8s-19.4-45.8-44-47.8l0 95.7zM316 304l-40 0 0 96 40 0 0-96zm-80 96l0-96-40 0 0 96 40 0zM112 352c0 25.2 19.4 45.8 44 47.8l0-95.7c-24.6 2-44 22.7-44 47.8zm64-112a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm192-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "pen-fancy": [576, 512, [128395, 10002], "f5ac", "M128.2 387.5c-.1-1.2-.2-2.3-.2-3.5 0-17.7 14.3-32 32-32s32 14.3 32 32-14.3 32-32 32c-1.2 0-2.4-.1-3.5-.2L71.6 500.7 256 448 290.4 356.3 187.7 253.6 96 288 43.3 472.4 128.2 387.5zm185.1-76.2L560 80 464-16 232.7 230.7 313.3 311.3z"],
    "user-chef": [448, 512, [], "e3d2", "M64 32c0 20.9 13.4 38.7 32 45.3L96 144c0 70.7 57.3 128 128 128s128-57.3 128-128l0-66.7c18.6-6.6 32-24.4 32-45.3 0-26.5-21.5-48-48-48-14.3 0-27.2 6.3-36 16.3-8.8-10-21.7-16.3-36-16.3-16.7 0-31.4 8.5-40 21.5-8.6-12.9-23.3-21.5-40-21.5-14.3 0-27.2 6.3-36 16.3-8.8-10-21.7-16.3-36-16.3-26.5 0-48 21.5-48 48zM304 144c0 44.2-35.8 80-80 80s-80-35.8-80-80l0-16 160 0 0 16zM275.8 320l-147.8 73.9 0 118.1 304 0-64-192-92.2 0zm-71.6 0l-124.2 0-64 192 80 0 0-137.9 8.8-4.4 99.4-49.7zM280 432a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm-72-24a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"],
    "droplet-plus": [384, 512, [], "e800", "M192-32S384 214 384 320 298 512 192 512 0 426 0 320 192-32 192-32zM168 224l0 72-72 0 0 48 72 0 0 72 48 0 0-72 72 0 0-48-72 0 0-72-48 0z"],
    "euro-sign": [448, 512, [8364, "eur", "euro"], "f153", "M73.3 192C100.8 99.5 186.5 32 288 32l96 0 0 64-96 0c-65.6 0-122 39.5-146.7 96l154.7 0 0 48-167.2 0c-.5 5.3-.8 10.6-.8 16s.3 10.7 .8 16l167.2 0 0 48-154.7 0c24.7 56.5 81.1 96 146.7 96l96 0 0 64-96 0c-101.5 0-187.2-67.5-214.7-160l-57.3 0 0-48 48.6 0c-.7-10.5-.7-21.5 0-32l-48.6 0 0-48 57.3 0z"],
    "house-circle-xmark": [640, 512, [], "e50b", "M496 208c11.7 0 23.1 1 34.2 3l-242.2-227-256 240 0 48 48 0 0 240 260 0c-10.5-14.6-19-30.7-25.1-48l-90.9 0 0-144 97.4 0c30.3-66.1 97.1-112 174.6-112zm0 336a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm55.3-176.7L518.6 400c25.4 25.3 40 40 44 44L540 466.6c-4-4-18.6-18.6-44-44-25.3 25.4-40 40-44 44L429.4 444c4-4 18.6-18.6 44-44-25.4-25.3-40-40-44-44L452 333.4c4 4 18.6 18.6 44 44 25.3-25.4 40-40 44-44l22.6 22.6-11.3 11.3z"],
    "lira-sign": [320, 512, [8356], "f195", "M52.4 256l-52.4 0 0-48 35.6 0C20.7 124.7 84.3 42 175.1 42l8.2 0c33.6 0 66.2 11.3 92.5 32.2 9.2 7.3 22.9 18.2 41.2 32.6L277.2 157c-18.2-14.4-32-25.3-41.2-32.6-15-11.9-33.6-18.4-52.8-18.4l-8.2 0c-53.8 0-90.1 52.9-73.5 102l186.4 0 0 48-169.1 0c2.3 10.6 3.6 21.3 3.9 32l165.2 0 0 48-170.5 0c-4.8 18.6-12.6 36.5-23.6 52.9l-18.1 27.1 244.2 0 0 64-320 0 0-65.7 5.4-8.1 35.2-52.8c3.7-5.6 6.9-11.4 9.4-17.4l-50 0 0-48 58.8 0c-.5-10.8-2.6-21.6-6.4-32z"],
    "circle-peso": [512, 512, [], "e6ff", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM168 120l88 0c43.3 0 80.4 26.4 96 64l32 0 0 32-24.3 0c.4 5.3 .4 10.7 0 16l24.3 0 0 32-32 0c-15.7 37.6-52.8 64-96 64l-40 0 0 64-48 0 0-128-24 0 0-32 24 0 0-16-24 0 0-32 24 0 0-64zm88 48l-40 0 0 16 79.2 0c-10.1-9.9-23.9-16-39.2-16zm-40 64l95.4 0c.4-2.6 .6-5.3 .6-8s-.2-5.4-.6-8l-95.4 0 0 16zm0 32l0 16 40 0c15.3 0 29.1-6.1 39.2-16L216 264z"],
    "yen-sign": [384, 512, [165, "cny", "jpy", "rmb", "yen"], "f157", "M85.6 62.7l-17.3-26.9-53.8 34.6 17.3 26.9 112.3 174.7-79.7 0 0 48 96 0 0 32-96 0 0 48 96 0 0 80 64 0 0-80 96 0 0-48-96 0 0-32 96 0 0-48-79.7 0 112.3-174.7 17.3-26.9-53.8-34.6-17.3 26.9-106.8 166.1-106.8-166.1z"],
    "box-open": [640, 512, [], "f49e", "M80.4 301.4l0 90.5 240 136 240-136 0-154.3 15.1 22.7 53.3-35.5C622 214.7 600 181.8 563 126.2l-4.3-6.5-6.8-3.8-216-120-15.5-8.6-15.5 8.6-216 120-8.2 4.6-4.4 8.3c-44.1 82-67.8 126-71.2 132.2 15.7 8.4 40.8 21.9 75.4 40.4zm240-74.1L170.2 144 320.4 60.6 470.5 144 320.4 227.4zm-41.5 50.2l-21.3 46.2-165.8-88.8 25.4-47.2 161.7 89.8z"],
    "golf-flag-hole": [512, 512, [], "e3ac", "M128-32L416 96 175.5 202.9c.4 1.6 .5 3.3 .5 5.1l0 85.6c25.2-3.6 52.1-5.6 80-5.6 141.4 0 256 50.1 256 112S397.4 512 256 512 0 461.9 0 400c0-41.5 51.5-77.7 128-97l0-335zm96 448c35.3 0 64-14.3 64-32s-28.7-32-64-32-64 14.3-64 32 28.7 32 64 32z"],
    "truck-field": [640, 512, [], "e58d", "M32 32l352 0 0 32 85.4 0 8.2 19.8 56 136 1.7 4.2 72.7 0 0 160-48.4 0c.2 2.6 .4 5.3 .4 8 0 48.6-39.4 88-88 88s-88-39.4-88-88c0-2.7 .1-5.4 .4-8l-144.7 0c.2 2.6 .4 5.3 .4 8 0 48.6-39.4 88-88 88s-88-39.4-88-88c0-2.7 .1-5.4 .4-8l-32.4 0 0-96-32 0 0-160 32 0 0-96zm352 96l0 96 82.1 0-39.5-96-42.6 0zM192 392a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zm280 40a40 40 0 1 0 0-80 40 40 0 1 0 0 80z"],
    "u-turn-left-up": [576, 512, [], "e7f2", "M304 512C189.1 512 96 418.9 96 304l0-144-96 0 160-160 160 160-96 0 0 144c0 44.2 35.8 80 80 80s80-35.8 80-80l0-240 128 0 0 240c0 114.9-93.1 208-208 208z"],
    "circle-mill": [512, 512, [], "e702", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm85.1-408.1c-2.3 5.1-10.7 24.1-25.4 57.1 34.2 5.6 60.2 35.3 60.2 71l0 120-48 0 0-120c0-13.3-10.7-24-24-24-3.6 0-7.1 .8-10.2 2.2L280 241.4c0 68.2 0 105.1 0 110.6l-48 0 0-2.6c-20.1 45.2-30.7 69.1-31.9 71.7l-29.2-13 6.5-14.6 54.6-122.9 0-38.6 0-.4c-.2-13.1-10.9-23.6-24-23.6-13.3 0-24 10.7-24 24 0 76 0 116 0 120l-48 0c0-10.7 0-37.3 0-80l0 0c0-9.3 0-38.7 0-88l0-24 48 0 0 4.1c7.5-2.7 15.6-4.1 24-4.1 18.4 0 35.3 6.9 48 18.3 6.7-6 14.6-10.8 23.2-13.9 20.7-46.6 31.6-71.1 32.7-73.5l29.2 13z"],
    "whistle": [640, 512, [], "f460", "M416 112l64 0 0-48 160 0 0 128-226.2 50.2c1.4 9.7 2.2 19.6 2.2 29.8 0 114.9-93.1 208-208 208S0 386.9 0 272 93.1 64 208 64l208 0 0 48zM208 192a80 80 0 1 0 0 160 80 80 0 1 0 0-160z"],
    "kerning": [576, 512, [], "f86f", "M30.8 22.4l-11.3-22.4 71.7 0 77.2 153 77.2-153 71.7 0-11.3 22.4-109 216-8.9 17.6-39.4 0-8.9-17.6-109-216zm349-4.8l8.9-17.6 39.4 0 8.9 17.6 109 216 11.3 22.4-71.7 0-24.2-48-105.9 0-24.2 48-71.7 0 11.3-22.4 109-216zM387.7 144l41.3 0-20.7-41-20.7 41zM237.6 352c-17.3 17.3-28 28-32 32l165.5 0-32-32 45.3-45.3 109.3 109.3-109.3 109.3-45.3-45.3 32-32-165.5 0c4 4 14.7 14.7 32 32l-45.3 45.3c-8.2-8.2-37.1-37.1-86.6-86.6l-22.6-22.6 86.6-86.6 22.6-22.6 45.3 45.3z"],
    "location-pin-lock": [512, 512, [], "e51f", "M0 188.6C0 84.4 86 0 192 0 294.1 0 377.6 78.3 383.6 177 320.7 185.1 272 238.8 272 304l-32 0 0 171.6c-27.6 32.3-48 52.4-48 52.4S0 339.4 0 188.6zM192 256a64 64 0 1 0 0-128 64 64 0 1 0 0 128zm208 16c-17.7 0-32 14.3-32 32l0 48 64 0 0-48c0-17.7-14.3-32-32-32zm-80 32c0-44.2 35.8-80 80-80s80 35.8 80 80l0 48 32 0 0 192-224 0 0-192 32 0 0-48z"],
    "waves-sine": [576, 512, [], "e65d", "M0 448l32 0c39.4 0 75.8-18.3 99.4-48.2l-31.7-79.2-9.6 24.1C80.6 368.4 57.6 384 32 384l-32 0 0 64zM160 169.8l-10.5-26.3C130.3 95.5 83.7 64 32 64l-32 0 0 64 32 0c25.6 0 48.6 15.6 58.1 39.3l80.5 201.2c19.2 48 65.7 79.5 117.5 79.5 39.4 0 75.8-18.3 99.4-48.3l-31.7-79.2-9.7 24.2C336.6 368.4 313.6 384 288 384s-48.6-15.6-58.1-39.3L194.5 256 230 167.3c9.5-23.7 32.5-39.3 58.1-39.3s48.6 15.6 58.1 39.3l80.5 201.2c19.2 48 65.7 79.5 117.5 79.5l32 0 0-64-32 0c-25.6 0-48.6-15.6-58.1-39.3l-35.5-88.7 35.5-88.7c9.5-23.7 32.5-39.3 58.1-39.3l32 0 0-64-32 0c-51.7 0-98.3 31.5-117.5 79.5l-10.5 26.3-10.5-26.3C386.3 95.5 339.7 64 288 64s-98.3 31.5-117.5 79.5L160 169.8z"],
    "person-praying": [384, 512, [128720, "pray"], "f683", "M192.4 64a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zm-72.1 80l92.5 0c3.5 4.8 20.5 28.2 51.1 70.2 27.6-22.6 51.1-41.8 70.3-57.5l50.7 61.9C371.1 229.9 336.7 258 281.8 303L249 329.8c-16.9-23.3-32.9-45.2-47.8-65.8l-45 90 116.1 85.8-23.8 72.2-248 0 0-80 126.6 0-53.2-39.3C38.8 366.8 28 319.4 48.2 280.9L109 165.4 120.3 144z"],
    "location-plus": [384, 512, ["map-marker-plus"], "f60a", "M0 188.6C0 84.4 86 0 192 0S384 84.4 384 188.6C384 339.4 192 528 192 528S0 339.4 0 188.6zM168 288l48 0 0-72 72 0 0-48-72 0 0-72-48 0 0 72-72 0 0 48 72 0 0 72z"],
    "diamond-half-stroke": [576, 512, [], "e5b8", "M16 256c7.5 7.5 83.1 83.1 226.7 226.7L288 528 560 256c-7.5-7.5-83.1-83.1-226.7-226.7L288-16c-7.5 7.5-83.1 83.1-226.7 226.7L16 256zM288 437.5L288 74.5 469.5 256 288 437.5z"],
    "clipboard-list": [384, 512, [], "f46d", "M320 0l-256 0 0 32-64 0 0 480 384 0 0-480-64 0 0-32zM112 112l0-48 160 0 0 48-160 0zM64 224l64 0 0 64-64 0 0-64zm112 8l144 0 0 48-144 0 0-48zm0 128l144 0 0 48-144 0 0-48zm-48-8l0 64-64 0 0-64 64 0z"],
    "objects-align-center-vertical": [576, 512, [], "e3bd", "M96 32l160 0 0 192 64 0 0-128 160 0 0 128 96 0 0 64-96 0 0 128-160 0 0-128-64 0 0 192-160 0 0-192-96 0 0-64 96 0 0-192z"],
    "candy-bar": [640, 512, [127851, "chocolate-bar"], "e3e8", "M192 416l128 0 0-136-128 0 0 136zm176 0l272 0 0-320-272 0 0 320zM320 96l-128 0 0 136 128 0 0-136zM144 96L94.9 96c-7 49.1-45.8 87.8-94.9 94.9l0 41.1 144 0 0-136zM0 280l0 136 144 0 0-136-144 0z"],
    "booth-curtain": [448, 512, [], "f734", "M32 0l-32 0 0 512 64 0 0-448 32 0 0 336c0 26.5 21.5 48 48 48s48-21.5 48-48c0 26.5 21.5 48 48 48s48-21.5 48-48c0 26.5 21.5 48 48 48s48-21.5 48-48l0 112 64 0 0-512-416 0z"],
    "sack-dollar": [512, 512, [128176], "f81d", "M128 0l256 0-56 112-144 0-56-112zm41.6 160l172.8 0 47.1 39.2C457 255.5 496 338.8 496 426.6l0 85.4-480 0 0-85.4c0-87.8 39-171.2 106.5-227.4L169.6 160zM280 224l-40 0 0 24c-28.8 .3-52 23.7-52 52.5 0 25.7 18.5 47.6 43.9 51.8l41.7 7c6 1 10.4 6.2 10.4 12.3 0 6.9-5.6 12.5-12.5 12.5l-75.5 0 0 40 44 0 0 24 40 0 0-24.7c25-4.1 44-25.7 44-51.8 0-25.7-18.5-47.6-43.9-51.8l-41.7-7c-6-1-10.4-6.2-10.4-12.3 0-6.9 5.6-12.5 12.5-12.5l67.5 0 0-40-28 0 0-24z"],
    "mountain-sun": [576, 512, [], "e52f", "M560.5 480l-544 0 272-496 272 496zM210.9 258.5l29.5 29.5 64-64 42.6 0-58.6-106.9-77.5 141.3zM496.5 160a80 80 0 1 1 0-160 80 80 0 1 1 0 160z"],
    "hockey-mask": [448, 512, [], "f6ee", "M0 240C0 432 48 512 224 512s224-80 224-272L448 0 0 0 0 240zM160 56a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm40 72a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM176 296a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm0 64a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm-24 88a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM272 296a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM264 80a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm8 280a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm-24 88a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM128 272c-35.3 0-64-28.7-64-64l0-32 128 0 0 32c0 35.3-28.7 64-64 64zm256-64c0 35.3-28.7 64-64 64s-64-28.7-64-64l0-32 128 0 0 32z"],
    "location-smile": [384, 512, ["map-marker-smile"], "f60d", "M0 188.6C0 84.4 86 0 192 0S384 84.4 384 188.6C384 339.4 192 528 192 528S0 339.4 0 188.6zM128 192a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm160-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM95.4 267.1C106.9 284.4 140.9 316 192 316s85.1-31.6 96.6-48.9l-33.3-22.2c-6.2 9.4-29.1 31.1-63.4 31.1s-57.1-21.7-63.4-31.1L95.4 267.1z"],
    "tally-3": [448, 512, [], "e296", "M64 32l0 448-64 0 0-448 64 0zm128 0l0 448-64 0 0-448 64 0zM320 64l0 416-64 0 0-448 64 0 0 32z"],
    "arrow-down-from-line": [384, 512, [8615, "arrow-from-top"], "f345", "M32 64L0 64 0 0 384 0 384 64 32 64zM214.6 502.6l-22.6 22.6-22.6-22.6-128-128-22.6-22.6 45.3-45.3c6.6 6.6 38.6 38.6 96 96l0-274.7 64 0 0 274.7 96-96 45.3 45.3-150.6 150.6z"],
    "chart-pyramid": [576, 512, [], "e0e6", "M103.7 320l368.5 0-61.4-112-245.7 0-61.4 112zM77.4 368l-61.4 112 544 0-61.4-112-421.2 0zM288-16l-96.5 176 193 0-96.5-176z"],
    "goal-net": [576, 512, [], "e3ab", "M576 480l-64 0 0-384-448 0 0 384-64 0 0-448 576 0 0 448zM192 176l72 0 0-48 48 0 0 48 72 0 0-48 48 0 0 48 48 0 0 48-48 0 0 48 48 0 0 48-48 0 0 48 48 0 0 48-48 0 0 64-48 0 0-64-72 0 0 64-48 0 0-64-72 0 0 64-48 0 0-64-48 0 0-48 48 0 0-48-48 0 0-48 48 0 0-48-48 0 0-48 48 0 0-48 48 0 0 48zm0 192l72 0 0-48-72 0 0 48zm120 0l72 0 0-48-72 0 0 48zM192 272l72 0 0-48-72 0 0 48zm120 0l72 0 0-48-72 0 0 48z"],
    "link-horizontal-slash": [576, 512, ["chain-horizontal-slash"], "e1cc", "M49.3-16.9l-17-17-33.9 33.9 17 17 512 512 17 17 33.9-33.9c-6.1-6.1-27.8-27.8-65-65 38.2-29.2 62.8-75.3 62.8-127.1 0-59.3-32.3-111.1-80.3-138.8 .2 3.6 .3 7.1 .3 10.8 0 21.9-3.4 42.9-9.6 62.7 15.9 17.1 25.6 40.1 25.6 65.3 0 34.2-17.9 64.2-44.8 81.2l-82.1-82.1c38.2-29.2 62.8-75.3 62.8-127.1 0-88.4-71.6-160-160-160l-128 0c-18.6 0-36.4 3.2-53 9L49.3-16.9zM162.2 96l126 0c53 0 96 43 96 96 0 34.2-17.9 64.2-44.8 81.2l-49.2-49.2 30 0 0-64-32 0c-18.6 0-36.4 3.2-53 9l-73-73zM410.3 480l-64-64-58.2 0c-53 0-96-43-96-96 0-16.8 4.3-32.6 11.9-46.3l-46.3-46.3c-18.6 26.1-29.5 58.1-29.5 92.6 0 88.4 71.6 160 160 160l122.2 0zM29.7 99.4c-18.6 26.1-29.5 58.1-29.5 92.6 0 59.3 32.3 111.1 80.3 138.8-.2-3.6-.3-7.1-.3-10.8 0-21.9 3.4-42.9 9.6-62.7-15.9-17.1-25.6-40.1-25.6-65.3 0-16.8 4.3-32.6 11.9-46.3L29.7 99.4z"],
    "carpool": [512, 512, ["car-people"], "e69c", "M96 16l-18.9 0-4.4 18.4-45.5 189.6-27.2 0 0 256 96 0 0-64 320 0 0 64 96 0 0-256-27.2 0-45.5-189.6-4.4-18.4-338.9 0zM435.5 224l-35.5 0-16-32-96 0-16 32-32 0-16-32-96 0-16 32-35.5 0 38.4-160 282.2 0 38.4 160zM176 168a40 40 0 1 0 0-80 40 40 0 1 0 0 80zM96 288a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm288 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm-8-192a40 40 0 1 0 -80 0 40 40 0 1 0 80 0z"],
    "arrow-up-wide-short": [576, 512, ["sort-amount-up"], "f161", "M150.9 41.4L128.3 18.7c-4.2 4.2-41.1 41.1-110.6 110.6L-5 152 40.3 197.3c13.3-13.3 32-32 56-56l0 338.7 64 0 0-338.7c24 24 42.7 42.7 56 56L261.5 152c-4.2-4.2-41.1-41.1-110.6-110.6zM320.3 480l64 0 0-64-96 0 0 64 32 0zm0-128l128 0 0-64-160 0 0 64 32 0zm0-128l192 0 0-64-224 0 0 64 32 0zm0-128l256 0 0-64-288 0 0 64 32 0z"],
    "arrow-up-from-dotted-line": [384, 512, [], "e09b", "M192-13.3l22.6 22.6 128 128 22.6 22.6-45.3 45.3c-6.6-6.6-38.6-38.6-96-96l0 274.7-64 0 0-274.7c-57.4 57.4-89.4 89.4-96 96L18.7 160 41.4 137.4 169.4 9.4 192-13.3zM0 448l64 0 0 64-64 0 0-64zm170.7 0l0 64-64 0 0-64 64 0zm42.7 0l64 0 0 64-64 0 0-64zM384 448l0 64-64 0 0-64 64 0z"],
    "u-turn-right-up": [576, 512, [], "e7f4", "M272 512c114.9 0 208-93.1 208-208l0-144 96 0-160-160-160 160 96 0 0 144c0 44.2-35.8 80-80 80s-80-35.8-80-80l0-240-128 0 0 240c0 114.9 93.1 208 208 208z"],
    "hexagon-image": [576, 512, [], "e504", "M13.5 256.1l6.8-11.9 123.7-216.1 6.9-12.1 275.1 0 6.9 12.1 123.7 216.1 6.8 11.9-6.8 11.9-90.9 158.8 0 0-3 5.2 0 0c-23.7 41.4-35.9 62.7-36.7 64.1l-275.1 0-6.9-12.1-123.7-216.1-6.8-11.9zM341.8 224l-76.7 125.6-65.5-93.6-61.8 88.3 50.2 87.8 134.8 0-.1-.1 66.2 0 38.7-67.5-85.8-140.5zm-69.3-64a48 48 0 1 0 -96 0 48 48 0 1 0 96 0z"],
    "users-line": [576, 512, [], "e592", "M224 128a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zm128 96l48 144-224 0 48-144 128 0zm40-80a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm15.9 96l88.1 0 48 128-93.4 0-5.1-15.2-37.6-112.8zm-239.9 0l-37.6 112.8-5.1 15.2-93.4 0 48-128 88.1 0zM72 144a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zM0 416l576 0 0 48-576 0 0-48z"],
    "arrow-up-right-and-arrow-down-left-from-center": [512, 512, [], "e0a0", "M352 0l-32 0 0 64 82.7 0c-84 84-126.7 126.7-128 128L320 237.3c1.3-1.3 44-44 128-128l0 82.7 64 0 0-192-160 0zM214.6 342.6L237.3 320 192 274.7c-1.3 1.3-44 44-128 128l0-82.7-64 0 0 192 192 0 0-64-82.7 0 105.4-105.4z"],
    "camera-viewfinder": [512, 512, ["screenshot"], "e0da", "M0 0l0 160 48 0 0-112 112 0 0-48-160 0zM192 96l-12 32-84 0 0 256 320 0 0-256-84 0-12-32-128 0zm64 96a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM488 0l-136 0 0 48 112 0 0 112 48 0 0-160-24 0zM0 512l160 0 0-48-112 0 0-112-48 0 0 160zm488 0l24 0 0-160-48 0 0 112-112 0 0 48 136 0z"],
    "star-of-david": [512, 512, [10017], "f69a", "M0 416l156.3 0 74.1 128 51.2 0 74.1-128 156.3 0 0-49.9-3.5-6.1-60.2-104 60.2-104 3.5-6.1 0-49.9-156.3 0-74.1-128-51.2 0-74.1 128-156.3 0 0 49.9 3.5 6.1 60.2 104-60.2 104-3.5 6.1 0 49.9zM96.1 311.9l27.8 48.1-55.7 0 27.8-48.1zM188.6 360l-60.2-104 60.2-104 134.8 0 60.2 104-60.2 104-134.8 0zM221 416l70 0-35 60.4-35-60.4zm167.1-56l27.8-48.1 27.8 48.1-55.7 0zm27.8-159.9l-27.8-48.1 55.7 0-27.8 48.1zM291 96l-70 0 35-60.4 35 60.4zM123.9 152l-27.8 48.1-27.8-48.1 55.7 0z"],
    "notes-medical": [512, 512, [], "f481", "M96 416l272 0 144-144 0-272-416 0 0 416zM336 112l0 64 64 0 0 64-64 0 0 64-64 0 0-64-64 0 0-64 64 0 0-64 64 0zM48 120l0-24-48 0 0 416 352 0 0-48-304 0 0-344z"],
    "austral-sign": [448, 512, [], "e0a9", "M195.9 32l56.1 0 8.2 19.8 77.9 188.2 101.9 0 0 48-82 0 19.9 48 62.2 0 0 48-42.3 0 39.7 96-69.3 0-39.7-96-208.8 0-39.7 96-69.3 0 39.7-96-42.3 0 0-48 62.2 0 19.9-48-82 0 0-48 101.9 0 77.9-188.2 8.2-19.8zM159.3 288l-19.9 48 169.1 0-19.9-48-129.4 0zm109.5-48L224 131.6 179.2 240 268.8 240z"],
    "file-chart-pie": [384, 512, [], "f65a", "M0 0L240 0 384 144 384 512 0 512 0 0zM208 58.5L208 176 325.5 176 208 58.5zM80 336c0 61.9 50.1 112 112 112 53.6 0 98.4-37.7 109.4-88l-133.4 0 0-133.4c-50.3 11-88 55.8-88 109.4zm136-24l85.4 0c-9.3-42.6-42.8-76.1-85.4-85.4l0 85.4z"],
    "face-sad-sweat": [640, 512, [], "e38a", "M320 512c141.4 0 256-114.6 256-256S461.4 0 320 0c-131 0-239.1 98.5-254.2 225.4 6.1 4.8 25.8 20.5 34.6 28l.3 .3c14.4 12.5 32.3 29.7 46.8 50.2 14.3 20.1 28.4 47.7 28.4 80.1 0 25.4-8 48.6-21.7 67.2 44.7 38 102.5 60.8 165.7 60.8zm-63.7-89.6l-42.4-22.5C234 361.9 274 336 320 336s86 25.9 106.1 63.9l-42.4 22.5C371.6 399.5 347.6 384 320 384s-51.6 15.5-63.7 38.4zM432 272a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM240 240a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm36.3-80c-10.6 10.6-17.7 17.7-21.5 21.5-24.2 24.2-55.3 40.2-89 45.8l-2.5 .4-19.7 3.3-6.6-39.5 19.7-3.3 2.5-.4c25.5-4.2 49-16.4 67.3-34.6 3.8-3.8 11-11 21.5-21.5L276.3 160zm101.6 14.1L363.7 160 392 131.7c10.6 10.6 17.7 17.7 21.5 21.5 18.3 18.3 41.8 30.4 67.3 34.6l2.5 .4 19.7 3.3-6.6 39.5-19.7-3.3-2.5-.4c-33.7-5.6-64.8-21.6-89-45.8l-7.4-7.4zM49.7 298.4c-10.8 10.5-28.8 29.7-40 51.3-5.6 10.7-9.6 22.5-9.6 34.3 0 36.4 27.6 64 64 64s64-27.6 64-64c0-11.8-4.1-23.6-9.6-34.3-11.2-21.6-29.2-40.8-40-51.3-4.6-4.5-9.4-8.7-14.3-12.9-4.9 4.2-9.7 8.4-14.3 12.9z"],
    "clipboard-user": [384, 512, [], "f7f3", "M320 0l-256 0 0 32-64 0 0 480 384 0 0-480-64 0 0-32zM112 112l0-48 160 0 0 48-160 0zm80 120a56 56 0 1 1 0 112 56 56 0 1 1 0-112zM293.3 448l-202.7 0 21.3-64 160 0 21.3 64z"],
    "comment-arrow-down": [512, 512, [], "e143", "M512 240c0 132.5-114.6 240-256 240-38.3 0-74.7-7.9-107.3-22.1L0 512 55.7 389.5C20.8 348.5 0 296.5 0 240 0 107.5 114.6 0 256 0S512 107.5 512 240zM239 337l17 17c2.1-2.1 31.8-31.8 89-89l17-17-33.9-33.9c-9 9-25 25-48 48l0-126.1-48 0 0 126.1c-23-23-39-39-48-48L150.1 248c2.1 2.1 31.8 31.8 89 89z"],
    "file-image": [384, 512, [128443], "f1c5", "M0 0L240 0 384 144 384 512 0 512 0 0zM208 58.5L208 176 325.5 176 208 58.5zM128 256a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM320 448l0-48-128-112-128 112 0 48 256 0z"],
    "file-mov": [576, 512, [], "e647", "M272 0l-240 0 0 512 112 0 0-176 272 0 0-192-144-144zm85.5 176L240 176 240 58.5 357.5 176zM324 400l0-20-20 0c-2.7 0-8.5 0-17.6 0-.5 1-10.8 20.3-30.7 57.9-20.8-37.9-31.5-57.2-31.8-57.9-17.7 0-17.9 0-35.8 0l0 168 40 0 0-77.4c5.8 10.5 15.2 27.6 28.3 51.5 12.7-24 22-41.4 27.7-52.2l0 78.1 40 0 0-148zm68-20c-24.3 0-44 19.7-44 44l0 80c0 24.3 19.7 44 44 44l16 0c24.3 0 44-19.7 44-44l0-80c0-24.3-19.7-44-44-44l-16 0zm-4 44c0-2.2 1.8-4 4-4l16 0c2.2 0 4 1.8 4 4l0 80c0 2.2-1.8 4-4 4l-16 0c-2.2 0-4-1.8-4-4l0-80zm128-44l-40 0 0 55c0 21.6 3.9 43 11.5 63.2 10.7 28.5 16.9 45.1 18.7 49.8l43.7 0c1.8-4.7 8-21.3 18.7-49.8 7.6-20.2 11.5-41.6 11.5-63.2l0-55-40 0 0 55c0 16.8-3 33.4-8.9 49.2l-3.1 8.2-3.1-8.2C519 468.4 516 451.8 516 435l0-55z"],
    "pie": [576, 512, [129383], "f705", "M544 240l-12.7 0C497.7 137.8 401.4 64 288 64S78.3 137.8 44.7 240l-44.7 0 0 64 41.2 0 63.9-30.4 6-2.9 6.3 2.3 82.5 30 82.5-30 5.5-2 5.5 2 82.5 30 82.5-30 6.3-2.3 6.1 2.9 63.9 30.4 41.2 0 0-64-32 0zM96 448l384 0 38.7-116.2-55.6-26.5-81.7 29.7-5.5 2-5.5-2-82.5-30-82.5 30-5.5 2-5.5-2-81.7-29.7-55.6 26.5 38.7 116.2zM206.3 151.2c-12.1 24.3-19.9 39.7-23.2 46.3l-28.6-14.3c3.3-6.6 11-22 23.2-46.3l7.2-14.3 28.6 14.3-7.2 14.3zm192-14.3c12.1 24.3 19.9 39.7 23.2 46.3l-28.6 14.3c-3.3-6.6-11-22-23.2-46.3l-7.2-14.3 28.6-14.3 7.2 14.3zM304 144l0 48-32 0 0-64 32 0 0 16z"],
    "user-police-hair-long": [448, 512, [], "e7b5", "M48 16l0 32 32 19.2 0 44.8s5.8 2.8 16 6.7l0 57.3-48 96 352 0-48-96 0-57.3c10.2-3.9 16-6.7 16-6.7l0-44.8 32-19.2 0-32-176-48-176 48zm96 117.7c23.2 5.7 50.9 10.3 80 10.3s56.8-4.6 80-10.3l0 10.3c0 44.2-35.8 80-80 80s-80-35.8-80-80l0-10.3zM160 320l-80 0-64 192 416 0-64-192-80 0-64 64-64-64zM224 24l40 40-40 40-40-40 40-40zm80 376a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "bagel": [640, 512, [129391], "e3d7", "M640 208c0 112.8-89.7 204.6-201.7 207.9 7.5-15.3 13.4-31.5 17.7-48.4l22.7-15.6 56.7-1.6 19-53.4 44.9-34.6-16-54.4 16-54.4-44.9-34.6-19-53.4-56.7-1.6-46.8-32-46.8 32-56.7 1.6-3.7 10.5C312.4 69.7 299.3 64.3 285.8 60 323.4 22.9 375 0 432 0 546.9 0 640 93.1 640 208zM410.7 147.6c6.7-2.3 13.8-3.6 21.3-3.6 35.3 0 64 28.7 64 64 0 24.9-14.2 46.5-34.9 57-6.7-43.8-24.4-83.9-50.3-117.4zM0 304a208 208 0 1 1 416 0 208 208 0 1 1 -416 0zm256 0a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM120 208l24 24 24-24-24-24-24 24zM80 296l24-24-24-24-24 24 24 24zm32 128l24-24-24-24-24 24 24 24zM304 264l24-24-24-24-24 24 24 24zM216 432l24 24 24-24-24-24-24 24zm88-8l24-24-24-24-24 24 24 24z"],
    "cart-xmark": [640, 512, [], "e0dd", "M0-16l116 0c2.1 11.7 5 27.7 8.7 48l451.2 0-48 256-356.7 0 8.7 48 300 0 0 48-340 0-3.6-19.7-60.4-332.3-76 0 0-48zM160 464a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm224 0a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm31.8-349.8L381.8 80.2c-9.3 9.3-24.6 24.6-45.8 45.8-21.2-21.2-36.5-36.5-45.8-45.8l-33.9 33.9c9.3 9.3 24.6 24.6 45.8 45.8-21.2 21.2-36.5 36.5-45.8 45.8l33.9 33.9c9.3-9.3 24.6-24.6 45.8-45.8 21.2 21.2 36.5 36.5 45.8 45.8l33.9-33.9c-9.3-9.3-24.6-24.6-45.8-45.8 21.2-21.2 36.5-36.5 45.8-45.8z"],
    "square-caret-right": [448, 512, ["caret-square-right"], "f152", "M448 480l0-448-448 0 0 448 448 0zM328 256l-168 136 0-272 168 136z"],
    "utensils-slash": [576, 512, [], "e464", "M49.3-16.9l-17-17-33.9 33.9 17 17 512 512 17 17 33.9-33.9-17-17-295.2-295.2c3.9-9.9 6-20.7 6-32 0-6.1-.6-12.1-1.9-18.1l-14.2-151.3-31.9 0-13.3 146.2-24.8-24.8-10-121.2-31.9 0-6.1 73.3-38.9-38.9-3.1-34.5-31.4 0-15.4-15.4zM512.1 378.2L512.1 0c-48 0-160 32-160 176l0 42.2 160 160zM52.6 122.3L50 149.8c-1.2 5.9-1.9 12-1.9 18.1 0 45.9 35.1 83.6 80 87.7l0 256.4 64 0 0-250.2-139.5-139.5z"],
    "vial": [512, 512, [129514], "f492", "M356.1 22.8L333.4 .2 288.2 45.4 306.7 64 28.1 342.6C10.1 360.6 0 385 0 410.5L0 416c0 53 43 96 96 96l5.5 0c25.5 0 49.9-10.1 67.9-28.1l278.6-278.6 18.6 18.6 45.3-45.3c-22.4-22.4-62-62-137.2-137.2l0 0-18.6-18.6zM205.3 256l146.7-146.7 50.7 50.7-96 96-101.5 0z"],
    "helicopter": [640, 512, [128641], "f533", "M208.3 32l-24 0 0 48 176 0 0 48-220.8 0c-26.1-31.4-39.5-47.4-40-48L17.5 80C24 92.9 45.8 136.5 82.9 210.7l6.6 13.3 122.6 0 120.8 166.1 7.2 9.9 116.2 0c75.1 0 136-60.9 136-136s-60.9-136-136-136l-48 0 0-48 176 0 0-48-376 0zm200 160l48 0c39.8 0 72 32.2 72 72s-32.2 72-72 72l-48 0 0-144zm200 224l-48 0 0 32-304 0 0 48 352 0 0-80z"],
    "mitten": [448, 512, [], "f7b5", "M352 384L64 384 5.4 178.9C1.8 166.4 0 153.4 0 140.3 0 62.8 62.8 0 140.3 0l3.4 0c66 0 123.5 44.9 139.5 108.9l33.6 134.3 51.2-51.2 80 80-96 112zM32 432l352 0 0 80-352 0 0-80z"],
    "file-music": [384, 512, [], "f8b6", "M0 0L240 0 384 144 384 512 0 512 0 0zM208 58.5L208 176 325.5 176 208 58.5zM272 240l-96 0 0 113.8c-5.1-1.2-10.5-1.8-16-1.8-35.3 0-64 25.1-64 56s28.7 56 64 56 64-25.1 64-56l0-104 48 0 0-64z"],
    "gas-pump": [512, 512, [9981], "f52f", "M320 0l-288 0 0 464-16 0 0 48 320 0 0-48-16 0 0-160 48 0 0 144 144 0 0-313.3-6.2-6.9c-64-70.4-96-105.6-96.1-105.8L374.1 54.4c9.2 10.1 23.1 25.4 41.9 46.1l0 91.5 48 0 0 208-48 0 0-144-96 0 0-256zM256 64l0 128-160 0 0-128 160 0z"],
    "helmet-battle": [576, 512, [], "f6eb", "M96 192l0 240 160 80 0-256-96-32 0-32 256 0 0 32-96 32 0 256 160-80 0-240c0-40.3-19-78.2-51.2-102.4L288-16 147.2 89.6C115 113.8 96 151.7 96 192zM64 256L64 0 32 0 0 256 64 256zM512 0l0 256 64 0-32-256-32 0z"],
    "meat": [512, 512, [127830], "f814", "M243.6 19.6C283.7-20.4 371.9 2.8 440.5 71.5s91.9 156.8 51.8 196.9l-115.5 115.6-175.4 0-26.4 26.4c10.4 10.8 16.8 25.5 16.8 41.6 0 33.1-26.9 60-60 60s-60-26.9-60-60l0-12-12 0c-33.1 0-60-26.9-60-60s26.9-60 60-60c16.2 0 30.9 6.4 41.7 16.8l26.3-26.4 0-175.2 115.6-115.6zm64 184.8c49.6 49.6 113.3 66.4 142.2 37.4s12.2-92.6-37.4-142.2-113.3-66.4-142.2-37.4-12.2 92.6 37.4 142.2zm36.3-36.3c-15.3-15.3-20.4-34.9-11.5-43.8s28.5-3.7 43.8 11.5 20.4 34.9 11.5 43.8-28.5 3.7-43.8-11.5z"],
    "trumpet": [640, 512, [127930], "f8e3", "M512 285.5c38.4 25.4 71.5 63.4 96 98.5l32 0 0-320-32 0c-41.7 59.7-108.4 128-184 128l-24 0 0-64-48 0 0 64-40 0 0-64-48 0 0 64-40 0 0-64-48 0 0 64-128 0 0-16-48 0 0 96 48 0 0-16 33.1 0c-10.9 18.8-17.1 40.7-17.1 64 0 70.7 57.3 128 128 128l192 0c62.4 0 114.4-44.7 125.7-103.8-3.5-3.1-7-6-10.6-8.8-17.7-13.8-34.8-23.2-51.1-27.8l0 12.5c0 29.8-20.4 54.9-48 62l0-126 24 0c8.1 0 16.1 .8 24 2.3 1.3 .2 2.6 .5 3.9 .8 21.1 4.6 41.2 14 60.1 26.5zM352 384l-40 0 0-128 40 0 0 128zM176 258l0 124c-27.6-7.1-48-32.2-48-62s20.4-54.9 48-62zm48-2l40 0 0 128-40 0 0-128z"],
    "browsers": [576, 512, [], "e0cb", "M496 32l80 0 0 352-480 0 0-352 400 0zM48 128l0 304 432 0 0 48-480 0 0-352 48 0zM256 88l0 48 256 0 0-48-256 0zm-32-8l-64 0 0 64 64 0 0-64z"],
    "arrow-down-left": [448, 512, [], "e091", "M64.3 448l-32 0 0-288 64 0 0 178.7 265.4-265.4 22.6-22.6 45.3 45.3-22.6 22.6-265.4 265.4 178.7 0 0 64-256 0z"],
    "square-1": [448, 512, [], "e256", "M448 32l-448 0 0 448 448 0 0-448zM184 144l64 0 0 176 56 0 0 48-160 0 0-48 56 0 0-128-40 0 0-48 24 0z"],
    "user-nurse-hair-long": [448, 512, [], "e45e", "M96 24l128-56 128 56 0 152 48 96-352 0 48-96 0-152zM304 144l0-16-160 0 0 16c0 44.2 35.8 80 80 80s80-35.8 80-80zM224 384l64-64 80 0 64 192-416 0 64-192 80 0 64 64zM208 8l0 24-24 0 0 32 24 0 0 24 32 0 0-24 24 0 0-32-24 0 0-24-32 0z"],
    "temperature-sun": [576, 512, ["temperature-hot"], "f76a", "M256.4 28.4l0 89.1c-10-3.5-20.8-5.5-32-5.5-53 0-96 43-96 96 0 51.3 40.3 93.3 91 95.9-7.1 20.1-11 41.6-11 64.1 0 3 .1 5.9 .2 8.9-42.5 28.2-67.4 44.7-74.7 49.5-1.1-5.5-8.3-41-21.5-106.4-65.4-13.2-100.9-20.4-106.4-21.5 3.1-4.7 23.1-34.8 60-90.5-36.9-55.6-56.9-85.8-60-90.5 5.5-1.1 41-8.3 106.4-21.5 13.2-65.4 20.4-100.9 21.5-106.4 4.7 3.1 34.8 23.1 90.5 60l32-21.2zm0 143.9l0 68.8c-2.2 2.5-4.3 5-6.3 7.6-7.4 4.7-16.2 7.4-25.7 7.4-26.5 0-48-21.5-48-48s21.5-48 48-48c12.3 0 23.5 4.6 32 12.2zM304.4 0l192 0 0 260.7c29.5 26.4 48 64.7 48 107.3 0 79.5-64.5 144-144 144s-144-64.5-144-144c0-42.6 18.5-81 48-107.3L304.4 0zm96 432c35.3 0 64-28.7 64-64 0-26.9-16.5-49.9-40-59.3l0-236.7-48 0 0 236.7c-23.5 9.5-40 32.5-40 59.3 0 35.3 28.7 64 64 64z"],
    "gas-pump-slash": [576, 512, [], "f5f4", "M49.3-16.9l-17-17-33.9 33.9 17 17 512 512 17 17 33.9-33.9c-6.3-6.3-27.7-27.7-64.1-64.1l30 0 0-313.3-6.2-6.9c-64-70.4-96-105.6-96.1-105.8L406.2 54.4c9.2 10.1 23.1 25.4 41.9 46.1l0 91.5 48 0 0 208-30 0-114-114 0-286-286 0-16.9-16.9zM130.2 64l158 0 0 128-30 0-128-128zm-66 69.8l0 330.2-16 0 0 48 320 0 0-48-16 0 0-42.2-288-288z"],
    "envelope-circle-check": [640, 512, [], "e4e8", "M96 64l-32 0 0 72 12.8 9.6 224 168 9.1 6.9c21.2-83 96.4-144.5 186.1-144.5 28.6 0 55.6 6.2 80 17.4L576 64 96 64zM272 352l-208-156 0 252 257.4 0c-10.1-22-16.2-46.3-17.2-71.9L272 352zm368 16a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-73.6-51.5l-9.4 12.9-64 88-11 15.1c-4.4-4.4-22.1-22.1-53.2-53.2L417.4 368 440 345.4c5 5 17.7 17.7 38.1 38.1l53-72.9 9.4-12.9 25.9 18.8z"],
    "file-gif": [576, 512, [], "e645", "M272 0l-240 0 0 512 208 0 0-176 176 0 0-192-144-144zm85.5 176L240 176 240 58.5 357.5 176zM328 380c-24.3 0-44 19.7-44 44l0 80c0 24.3 19.7 44 44 44l16 0c24.3 0 44-19.7 44-44l0-44-48 0 0 40 8 0 0 4c0 2.2-1.8 4-4 4l-16 0c-2.2 0-4-1.8-4-4l0-80c0-2.2 1.8-4 4-4l16 0c2.2 0 4 1.8 4 4l0 8 40 0 0-8c0-24.3-19.7-44-44-44l-16 0zm124 20l0-20-40 0 0 168 40 0 0-148zm24-20l0 168 40 0 0-64 48 0 0-40-48 0 0-24 48 0 0-40-88 0z"],
    "person-skating": [512, 512, ["skating"], "f7c5", "M368.1 56a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm-240 40l211.8 0c11.8 23.7 34.3 68.6 35.2 70.3-1.4 1.4-31.2 31.2-89.2 89.2 62.9 28 95.6 42.5 98.3 43.7l0 148.8-64 0 0-107.2-82.4-36.6c-41-18.2-51-72-19.3-103.7l40.4-40.4-130.7 0 0-64zM89.5 361.4l75.9-75.9c7.7 19.7 21.6 37.3 41 49.6-55.9 55.9-87.3 87.3-94.2 94.2L66.9 384 89.5 361.4zm331 83.2l31 7.8c-1.9 7.6-5.9 23.4-11.9 47.5l-3 12.1-148.5 0 0-32 123.5 0c3.5-14 6.4-25.8 8.8-35.4zM143.3 486.3c-24.9 12.5-39.1 19.5-42.3 21.2l-8.2-8.2-80-80-11.3-11.3 22.6-22.6 11.3 11.3 71.8 71.8c15.7-7.8 27.7-13.8 36-18l14.3 28.6-14.3 7.2z"],
    "face-angry-horns": [640, 512, [], "e368", "M320 0C264.6 0 213.2 17.6 171.3 47.6 57.1 42.8 0 0 0 0 0 80.1 55.6 160.1 74.1 184.5 67.5 207.2 64 231.2 64 256 64 397.4 178.6 512 320 512S576 397.4 576 256c0-24.8-3.5-48.8-10.1-71.5 18.5-24.4 74.1-104.4 74.1-184.5 0 0-57.1 42.8-171.3 47.6-41.9-30-93.2-47.6-148.7-47.6zm0 384c-27.6 0-51.6 15.5-63.7 38.4l-42.4-22.5C234 361.9 274 336 320 336s86 25.9 106.1 63.9l-42.4 22.5C371.6 399.5 347.6 384 320 384zm-80-80c-17.7 0-32-14.3-32-32 0-7.3 2.4-14 6.6-19.4-20.9-7-36.8-12.3-47.8-15.9l12.6-37.9 19 6.3 96 32 19 6.3-12.6 37.9c-14.2-4.7-23.7-7.9-28.7-9.6l0 .3c0 17.7-14.3 32-32 32zm192-32c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-.3c-4.9 1.6-14.5 4.8-28.7 9.6l-12.6-37.9 19-6.3 96-32 19-6.3 12.6 37.9c-11 3.7-27 9-47.8 15.9 4.1 5.4 6.6 12.1 6.6 19.4z"],
    "sun": [576, 512, [9728], "f185", "M173.8-20.2c10.6 7.1 48.8 32.4 114.4 75.9 65.6-43.5 103.8-68.8 114.4-75.9 2.5 12.5 11.6 57.4 27.2 134.6 77.2 15.6 122.1 24.7 134.6 27.2-7.1 10.6-32.4 48.8-75.9 114.4 43.5 65.6 68.8 103.8 75.9 114.4-12.5 2.5-57.4 11.6-134.6 27.2-15.6 77.2-24.7 122.1-27.2 134.6-10.6-7.1-48.8-32.4-114.4-75.9-65.6 43.5-103.8 68.8-114.4 75.9-2.5-12.5-11.6-57.4-27.2-134.6-77.2-15.6-122.1-24.7-134.6-27.2 7.1-10.6 32.4-48.8 75.9-114.4-43.5-65.6-68.8-103.8-75.9-114.4 12.5-2.5 57.4-11.6 134.6-27.2 15.6-77.2 24.7-122.1 27.2-134.6zm34 276.2a80.2 80.2 0 1 1 160.5 0 80.2 80.2 0 1 1 -160.5 0zm208.5 0a128.2 128.2 0 1 0 -256.5 0 128.2 128.2 0 1 0 256.5 0z"],
    "diploma": [640, 512, ["scroll-ribbon"], "f5ea", "M80 64C35.8 64 0 135.6 0 224l0 160 163.2 0c-12.3-24-19.2-51.2-19.2-80 0-97.2 78.8-176 176-176s176 78.8 176 176c0 28.8-6.9 56-19.2 80l163.2 0 0-160c0-88.4-35.8-160-80-160L80 64zM448 304c0-70.7-57.3-128-128-128S192 233.3 192 304c0 32.5 12.1 62.1 32 84.7l0 131.3 96-40 96 40 0-131.3c19.9-22.6 32-52.2 32-84.7zM320 256a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"],
    "baseball": [512, 512, [129358, 9918, "baseball-ball"], "f433", "M232.4 1.1c-122.2 11.4-219.5 108.7-230.9 230.9 22.3-.1 43.9-3.4 64.3-9.3l13.5 46.1c-24.7 7.2-50.8 11.2-77.8 11.3 11.4 122.2 108.7 219.5 230.9 230.9 .1-27 4-53.1 11.3-77.8l46.1 13.5c-6 20.4-9.2 41.9-9.3 64.3 122.2-11.4 219.5-108.7 230.9-230.9-22.3 .1-43.9 3.4-64.3 9.3l-13.5-46.1c24.7-7.2 50.8-11.2 77.8-11.3-11.4-122.2-108.7-219.5-230.9-230.9-.1 27-4 53.1-11.3 77.8L223.1 65.4c6-20.4 9.2-41.9 9.3-64.3zM134.6 245.8l-23-42.1c39-21.3 71.2-53.5 92.5-92.5l42.1 23c-25.7 47-64.5 85.8-111.6 111.6zm132 132c25.7-47 64.5-85.8 111.6-111.6l23 42.1c-39 21.3-71.2 53.5-92.5 92.5l-42.1-23z"],
    "image": [448, 512, [], "f03e", "M448 32l-448 0 0 448 448 0 0-448zM128 112a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm16 160l46.1 69.1 81.9-133.1 128 208-352 0 96-144z"],
    "boot": [448, 512, [129406], "f782", "M0 0l320 0 0 112-128 0 0 48 96 0 0 48-96 0 0 48 128 0c70.7 0 128 57.3 128 128L0 384 0 0zM0 432l448 0 0 48-28 32-56 0-28-32-28 32-56 0-28-32-28 32-56 0-28-32-28 32-56 0-28-32 0-48z"],
    "car-bump": [576, 512, [], "f5e0", "M252.2 4.5l-19.2 11.1-194 112-19.2 11.1 3.6 21.9 21.6 129.8-31 17.9c77.3 133.9 90.7 157 112 194l69.3-40-32-55.4 249.4-144 32 55.4 69.3-40c-45.3-78.5-82.7-143.2-112-194l-31 17.9-101.6-83.6-17.1-14.1zM90.2 171.9l155.6-89.8 66 54.3-207.5 119.8-14-84.3zm252.6 1.9a32 32 0 1 1 32 55.4 32 32 0 1 1 -32-55.4zm-178 139.7a32 32 0 1 1 -55.4 32 32 32 0 1 1 55.4-32zM464 400c-61.9 0-112 50.1-112 112l224 0c0-61.9-50.1-112-112-112z"],
    "money-bill-simple": [512, 512, [], "e1f1", "M512 64l-512 0 0 384 512 0 0-384zM256 160a96 96 0 1 1 0 192 96 96 0 1 1 0-192z"],
    "square-arrow-down": [448, 512, ["arrow-square-down"], "f339", "M448 32l-448 0 0 448 448 0 0-448zM241 377l-17 17-17-17c-63.8-63.8-96.2-96.2-97-97L144 246.1c7.6 7.6 26.3 26.3 56 56l0-174.1 48 0 0 174.1c29.7-29.7 48.4-48.4 56-56l33.9 33.9-17 17-80 80z"],
    "notdef": [384, 512, [], "e1fe", "M0 0L384 0 384 512 0 512 0 0zM64 390.3L153.5 256 64 121.7 64 390.3zM102.5 448L281.5 448 192 313.7 102.5 448zm128-192L320 390.3 320 121.7 230.5 256zM281.5 64L102.5 64 192 198.3 281.5 64z"],
    "comment-question": [512, 512, [], "e14b", "M512 240c0 132.5-114.6 240-256 240-38.3 0-74.7-7.9-107.3-22.1L0 512 55.7 389.5C20.8 348.5 0 296.5 0 240 0 107.5 114.6 0 256 0S512 107.5 512 240zM256 165.2c17.7 0 32 14.3 32 32 0 13.2-6.8 20.5-15.8 25.6-9.4 5.3-20 6.6-30.5 8-2.3 .3-4.6 .6-6.9 .9l0 53.5 42.4 0 0-18.3c4.8-1.7 10.3-4 15.8-7.1 17.6-9.9 37.4-29.2 37.4-62.5 0-41.1-33.3-74.4-74.4-74.4s-74.4 33.3-74.4 74.4l42.4 0c0-17.7 14.3-32 32-32zM232 312l0 48 48 0 0-48-48 0z"],
    "user-robot": [448, 512, [], "e04b", "M248 24l0-24-48 0 0 64-120 0 0 104-48 0 0 48 48 0 0 88 288 0 0-88 48 0 0-48-48 0 0-104-120 0 0-40zM0 352l0 160 104 0 0-64 48 0 0 64 48 0 0-64 48 0 0 64 48 0 0-64 48 0 0 64 104 0 0-160-448 0zM128 160a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm160-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "basketball": [512, 512, [127936, "basketball-ball"], "f434", "M92.7 58.8l78.4 78.4c18.2-25 28.9-55.9 28.9-89.2 0-14.1-1.9-27.7-5.5-40.6-38 9.4-72.6 27.2-101.8 51.4zM58.8 92.7c-24.2 29.2-42 63.8-51.4 101.8 12.9 3.6 26.5 5.5 40.6 5.5 33.3 0 64.1-10.7 89.2-28.9L58.8 92.7zM256 0c-4.6 0-9.2 .1-13.7 .4 3.7 15.3 5.7 31.2 5.7 47.6 0 46.6-15.9 89.4-42.6 123.4L256 222.1 419.3 58.8C374.9 22.1 318.1 0 256 0zM48 248c-16.4 0-32.4-2-47.6-5.7-.2 4.5-.4 9.1-.4 13.7 0 62.1 22.1 118.9 58.8 163.3L222.1 256 171.4 205.4C137.4 232.1 94.6 248 48 248zm463.6 21.7c.2-4.5 .4-9.1 .4-13.7 0-62.1-22.1-118.9-58.8-163.3L289.9 256 340.6 306.6c34-26.7 76.9-42.6 123.4-42.6 16.4 0 32.4 2 47.6 5.7zm-7.1 47.8c-12.9-3.6-26.5-5.5-40.6-5.5-33.3 0-64.1 10.7-89.2 28.9l78.4 78.4c24.2-29.2 42-63.8 51.4-101.8zM340.9 374.8c-18.2 25-28.9 55.9-28.9 89.2 0 14.1 1.9 27.7 5.5 40.6 38-9.4 72.6-27.2 101.8-51.4l-78.4-78.4zm-34.3-34.3L256 289.9 92.7 453.2c44.3 36.7 101.2 58.8 163.3 58.8 4.6 0 9.2-.1 13.7-.4-3.7-15.3-5.7-31.2-5.7-47.6 0-46.6 15.9-89.4 42.6-123.4z"],
    "pencil": [576, 512, [9999, 61504, "pencil-alt"], "f303", "M16 527.4c20.7-5.8 87.4-24.5 200-56L405.1 282.3 439 248.4c-15.6-15.6-52.3-52.3-110.1-110.1L295 104.4 261.1 138.3 72 327.4C40.5 440 21.8 506.7 16 527.4zm98.4-173.6l75.1 75.1-104.3 29.2 29.2-104.3zM439 180.5L473 214.5c53.4-53.4 60.2-60.2 87-87-15.6-15.6-52.3-52.3-110.1-110.1L416-16.6c-53.4 53.4-60.2 60.2-87 87 15.6 15.6 52.3 52.3 110.1 110.1z"],
    "person-walking-arrow-loop-left": [640, 512, [], "e551", "M160-32a56 56 0 1 1 0 112 56 56 0 1 1 0-112zM98.7 112l108.6 0 9.6 12 54.4 68 80.6 0 0 64-111.4 0c-4.2-5.2-15-18.8-32.6-40.8l0 115.2 52.8 45.3 9 7.7 1.8 11.7c12.5 81.4 19.5 126.6 20.9 135.6l-63.3 9.7c-1.7-11-8-52.3-19.1-123.9l-80.7-69.1C108.2 329.2 96 302.6 96 274.6l0-69.3-32 32 0 82.7-64 0 0-109.3 9.4-9.4 80-80 9.4-9.4zM83.5 415.2L96.1 371c2.4 2.3 4.8 4.6 7.4 6.8l46 39.4c-5.2 18.3-8.2 28.8-9 31.5L134.6 454.6 48 541.3 2.7 496c9.2-9.2 36.1-36.1 80.8-80.8zM342.1 352c2.1-2.1 31.8-31.8 89-89l17-17 33.9 33.9c-9 9-25 25-48 48l158.1 0 0-120-176 0 0-48 224 0 0 216-206.1 0c23 23 39 39 48 48L448 457.9c-2.1-2.1-31.8-31.8-89-89l-17-17z"],
    "boot-heeled": [448, 512, [], "e33f", "M96 0l-96 0 32 288-32 128 0 96 128 0 0-32 128 32 192 0 0-96-192-128 32-288-144 0 0 224-48 0 0-224z"],
    "dice-six": [448, 512, [9861], "f526", "M0 32l448 0 0 448-448 0 0-448zM160 160a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM128 288a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm32 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM320 192a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm32 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM320 384a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "circle-ellipsis": [512, 512, [], "e10a", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM192 224l0 64-64 0 0-64 64 0zm192 0l0 64-64 0 0-64 64 0zm-160 0l64 0 0 64-64 0 0-64z"],
    "swedish-krona-sign": [512, 512, [], "e73e", "M112 48l0-32-64 0 0 464 64 0 0-113.8 29.1-26.5c70.8 101.2 106.5 152.1 107 152.9l52.4-36.7-18.4-26.2-93.4-133.4c69.9-63.6 107.4-97.6 112.3-102.1l-43-47.4-23.7 21.5-122.5 111.3 0-231.7zM448 224l48 0 0-64-48 0c-22.8 0-44.8 6.1-64 17.1l0-17.1-64 0 0 320 64 0 0-192c0-13.8 4.5-27.3 12.8-38.4 12.1-16.1 31.1-25.6 51.2-25.6z"],
    "arrow-up-square-triangle": [512, 512, ["sort-shapes-up-alt"], "f88b", "M150.9 41.4l-22.6-22.6-102.6 102.6-22.6 22.6 45.3 45.3 48-48 0 338.7 64 0 0-338.7 48 48 45.3-45.3c-5.5-5.5-39.7-39.7-102.6-102.6zM288.3 32l0 192 192 0 0-192-192 0zm96 256l-112 192 224 0-112-192z"],
    "angles-down": [448, 512, ["angle-double-down"], "f103", "M246.9 470.6l-22.6 22.6-22.6-22.6-160-160-22.6-22.6 45.3-45.3 22.6 22.6 137.4 137.4 137.4-137.4 22.6-22.6 45.3 45.3-182.6 182.6zm0-192l-22.6 22.6-22.6-22.6-160-160-22.6-22.6 45.3-45.3 22.6 22.6 137.4 137.4 160-160 45.3 45.3-22.6 22.6-160 160z"],
    "van": [576, 512, [], "e7c8", "M0 64l464 0 9.6 12.8 96 128 6.4 8.5 0 186.7-64.4 0c-4 44.9-41.7 80-87.6 80s-83.6-35.1-87.6-80l-96.7 0c-4 44.9-41.7 80-87.6 80s-83.6-35.1-87.6-80L0 400 0 64zM384 224l120 0-72-96-48 0 0 96zm80 168a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zM152 432a40 40 0 1 0 0-80 40 40 0 1 0 0 80z"],
    "battery-low": [640, 512, ["battery-1"], "e0b1", "M544 128l0 256-448 0 0-256 448 0zM96 64l-64 0 0 384 576 0 0-128 32 0 0-128-32 0 0-128-512 0zm96 112l-48 0 0 160 48 0 0-160z"],
    "lacrosse-stick-ball": [576, 512, [], "e3b6", "M496.5 544a80 80 0 1 1 0-160 80 80 0 1 1 0 160zm-96-576c97.2 0 176 78.8 176 176 0 57.8-35.9 109-89.3 129.2l-10.9 3.6-11.5 3.3c-8.6 2.5-16.8 6.2-24.2 11l-7.2 5.2-34.9 27.9c-22.5 18-50.4 27.8-79.2 27.8-23.4 0-45.3-6.4-64.1-17.4L48.5 541.2 3.2 496 209.9 289.3c-11-18.8-17.4-40.7-17.4-64.1 0-28.8 9.8-56.7 27.8-79.2l27.9-34.9 5.2-7.2c4.9-7.5 8.6-15.6 11-24.2l3.3-11.5 3.6-10.9C291.5 3.9 342.7-32 400.5-32zm0 64c-31 0-58.5 19.3-69.3 47.9l-1.9 5.8-3.3 11.5c-4.9 17.2-12.8 33.3-23.2 47.8l-4.6 6.1-27.9 34.9c-8.9 11.1-13.7 25-13.8 39.2 0 34.7 28.1 62.7 62.7 62.7 14.2 0 28.1-4.8 39.2-13.7l34.9-27.9 6.1-4.6c14.4-10.4 30.6-18.3 47.8-23.2l11.5-3.3 5.8-1.9c28.6-10.8 47.9-38.3 47.9-69.3 0-61.9-50.1-112-112-112z"],
    "seat-airline-window": [384, 512, [], "e7be", "M64 0l0 154.8 55.1 165.2 264.9 0 0 64-311.1 0-7.3-21.9-64-192-1.6-4.9 0-165.2 64 0zM32 448l352 0 0 64-352 0 0-64zM352 0l0 224-160 0 0-224 160 0z"],
    "alarm-snooze": [512, 512, [], "f845", "M492.3 153.2c-32.2-56.4-84-100.1-146.1-121.9 17.4-19.2 42.6-31.3 70.6-31.3 52.6 0 95.2 42.6 95.2 95.2 0 21.8-7.3 41.9-19.7 58zm-472.6 0C7.3 137.2 0 117.1 0 95.2 0 42.6 42.6 0 95.2 0 123.2 0 148.4 12.1 165.8 31.3 103.7 53.1 51.9 96.9 19.7 153.2zM390.2 467.4C352.8 495.4 306.3 512 256 512s-96.8-16.6-134.1-44.6C96.3 493 77 512.3 64 525.3L18.7 480C31.7 467 51 447.7 76.6 422.2 48.6 384.8 32 338.3 32 288 32 164.3 132.3 64 256 64S480 164.3 480 288c0 50.3-16.6 96.8-44.6 134.2l57.8 57.8-45.3 45.3-57.8-57.8zM200 192l-24 0 0 48 79.2 0c-46.9 84.4-73.5 132.3-80 144l160.8 0 0-48-79.2 0c46.9-84.4 73.5-132.3 80-144L200 192z"],
    "syringe": [576, 512, [128137], "f48e", "M497.4-17l-17-17-33.9 33.9c11.6 11.6 22.3 22.3 32 32L432.4 78.1c-49.7-49.7-76.4-76.4-80-80L318.5 32c13 13 21 21 24 24l-78.1 78.1c31.3 31.3 50.6 50.6 57.9 57.9l-33.9 33.9c-7.3-7.3-26.6-26.6-57.9-57.9l-46.1 46.1 57.9 57.9-33.9 33.9c-7.3-7.3-26.6-26.6-57.9-57.9l-47 47-7 7 0 112C51.8 458.7 27.2 483.4 22.5 488l33.9 33.9c4.6-4.6 29.3-29.3 73.9-73.9l112 0 7-7 239-239c3 3 11 11 24 24L546.4 192c-3.6-3.6-30.3-30.3-80-80l46.1-46.1c9.7 9.7 20.4 20.4 32 32L578.4 64c-20.5-20.4-70-70-81-81z"],
    "shower-down": [384, 512, ["shower-alt"], "e24d", "M224 0l0 35.2C297 50 352 114.6 352 192l32 0 0 64-384 0 0-64 32 0C32 114.6 87 50 160 35.2L160 0 224 0zm32 416l27.8 48.7c2.7 4.8 4.2 10.2 4.2 15.7 0 17.5-14.2 31.6-31.6 31.6l-.8 0c-17.5 0-31.6-14.2-31.6-31.6 0-5.5 1.4-10.9 4.2-15.7L256 416zm36.2-79.3L320 288 347.8 336.7c2.7 4.8 4.2 10.2 4.2 15.7 0 17.5-14.2 31.6-31.6 31.6l-.8 0c-17.5 0-31.6-14.2-31.6-31.6 0-5.5 1.4-10.9 4.2-15.7zM128 416l27.8 48.7c2.7 4.8 4.2 10.2 4.2 15.7 0 17.5-14.2 31.6-31.6 31.6l-.8 0c-17.5 0-31.6-14.2-31.6-31.6 0-5.5 1.4-10.9 4.2-15.7L128 416zm36.2-79.3L192 288 219.8 336.7c2.7 4.8 4.2 10.2 4.2 15.7 0 17.5-14.2 31.6-31.6 31.6l-.8 0c-17.5 0-31.6-14.2-31.6-31.6 0-5.5 1.4-10.9 4.2-15.7zM64 288l27.8 48.7c2.7 4.8 4.2 10.2 4.2 15.7 0 17.5-14.2 31.6-31.6 31.6l-.8 0c-17.5 0-31.6-14.2-31.6-31.6 0-5.5 1.4-10.9 4.2-15.7L64 288z"],
    "wheat-awn": [576, 512, ["wheat-alt"], "e2cd", "M145.8 282.7l6.1 6.7c19.7 23.8 26.3 55 19.3 83.9 31.7-7.7 66.2 1 90.6 25.3l57.4 57.4-18.8 18.7c-37.5 37.5-98.3 37.5-135.7 0L134.1 444.3 49.4 529c-9.4 9.4-24.5 9.4-33.9 0-9.4-9.4-9.4-24.6 0-33.9l84.7-84.7-30.5-30.5c-37.5-37.5-37.5-98.3 0-135.8l18.8-18.7 57.4 57.4zm104-104l6.1 6.7c19.7 23.7 26.3 55 19.3 83.9 31.7-7.7 66.2 1 90.6 25.3l57.4 57.4-18.8 18.7c-37.5 37.5-98.3 37.5-135.7 0l-94.9-94.9c-37.5-37.5-37.5-98.3 0-135.8l18.8-18.7 57.4 57.4zM546.1 32l-17 17-114.5 114.4c7.7 1 15.2 3 22.5 5.9l58.3-58.3 17-17 33.9 34-17 16.9-52.7 52.7 50.3 50.3-18.8 18.7c-37.5 37.5-98.3 37.5-135.7 0l-94.9-94.9c-37.5-37.5-37.5-98.3 0-135.8l18.8-18.7 50.3 50.3 52.7-52.7 17-17 33.9 34-17 16.9-58.3 58.3c2.8 7.1 4.7 14.5 5.8 22l114.3-114.2 17-17 33.9 34z"],
    "plane-up": [512, 512, [], "e22d", "M200 24c0-30.9 25.1-56 56-56s56 25.1 56 56l0 127.3 184 168.7 0 80-184-61.3 0 99.7 72 57.6 0 48-128-32-128 32 0-48 72-57.6 0-99.7-184 61.3 0-80 184-168.7 0-127.3z"],
    "circle-user-circle-check": [640, 512, [], "e79f", "M496 208c-77.5 0-144.3 45.9-174.6 112l-145.4 0-23.9 71.6c34.8 34.8 82.8 56.4 135.9 56.4 7.4 0 14.6-.4 21.7-1.2 5.5 21.9 14.8 42.4 27.1 60.6-15.8 3-32.1 4.6-48.8 4.6-141.4 0-256-114.6-256-256S146.6 0 288 0c126.8 0 232.1 92.2 252.4 213.2-14.3-3.4-29.1-5.2-44.4-5.2zM288 272a72 72 0 1 0 0-144 72 72 0 1 0 0 144zm64 128a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm214.4-51.5l-25.9-18.8-9.4 12.9-53 72.9C457.7 395 445 382.3 440 377.4L417.4 400c2.8 2.8 19.9 19.9 51.3 51.3l13.2 13.2 11-15.1 64-88 9.4-12.9z"],
    "bat": [576, 512, [], "f6b5", "M224 48L288 80 352 48 379.9 159.7 480 112c61.9 72.3 96 164.3 96 259.5l0 28.5-96-48-48 80-64-64-80 112-80-112-64 64-48-80-96 48 0-28.5C0 276.3 34.1 184.3 96 112L196.1 159.7 224 48z"],
    "align-center": [448, 512, [], "f037", "M352 32l-256 0 0 64 256 0 0-64zm96 128l-448 0 0 64 448 0 0-64zM0 416l0 64 448 0 0-64-448 0zM352 288l-256 0 0 64 256 0 0-64z"],
    "hockey-puck": [512, 512, [], "f453", "M512 352c0 53-114.6 96-256 96S0 405 0 352L0 242.6c16.9 12.3 36.9 22.3 58.1 30.2 53 19.9 123 31.2 197.9 31.2s144.9-11.3 197.9-31.2c21.2-7.9 41.2-17.9 58.1-30.2L512 352zM256 64c141.4 0 256 43 256 96S397.4 256 256 256 0 213 0 160 114.6 64 256 64z"],
    "circle-arrow-left": [512, 512, ["arrow-circle-left"], "f0a8", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM135 273l-17-17c.8-.8 33.1-33.1 97-97l17-17 33.9 33.9c-7.6 7.6-26.3 26.3-56 56l174.1 0 0 48-174.1 0c29.7 29.7 48.4 48.4 56 56l-33.9 33.9-17-17-80-80z"],
    "chart-radar": [576, 512, [], "e0e7", "M13.5 256.1l6.8-11.9 123.7-216.1 6.9-12.1 275.1 0 6.9 12.1 123.7 216.1 6.8 11.9-6.8 11.9-123.7 216.1-6.9 12.1-275.1 0-6.9-12.1-123.7-216.1-6.8-11.9zm323-96.1c0-26.5-21.5-48-48-48s-48 21.5-48 48c0 6.7 1.4 13.1 3.9 18.9l-46.1 61.5c-1.9-.2-3.8-.3-5.7-.3-26.5 0-48 21.5-48 48s21.5 48 48 48c14.4 0 27.3-6.3 36.1-16.3L307 335.4c6.4 19 24.4 32.6 45.5 32.6 26.5 0 48-21.5 48-48 0-24.2-17.9-44.2-41.2-47.5l-33.1-82.8c6.4-8.2 10.3-18.5 10.3-29.7zM313.7 287.8l-75.8-15.2c-.4-1.2-.8-2.3-1.3-3.5l45.4-60.6 31.7 79.2z"],
    "arrow-progress": [512, 512, [], "e5df", "M254.4 52.8l-38.4-28.8 0 40-216 0 0 224 448 0 0 96-8.6 0c-11.1-19.1-31.7-32-55.4-32-35.3 0-64 28.7-64 64s28.7 64 64 64c23.7 0 44.4-12.9 55.4-32l72.6 0 0-224-448 0 0-96 152 0 0 40c60.8-45.6 83.2-62.4 96-72L254.4 52.8zM416 160a64 64 0 1 0 0-128 64 64 0 1 0 0 128zM151.4 448l32.6 0 0 40c60.8-45.6 83.2-62.4 96-72-35.2-26.4-76.8-57.6-96-72l0 40-32.6 0c-11.1-19.1-31.7-32-55.4-32-35.3 0-64 28.7-64 64s28.7 64 64 64c23.7 0 44.4-12.9 55.4-32z"],
    "warehouse-full": [576, 512, ["warehouse-alt"], "f495", "M0 512l0-416 288-96 288 96 0 416-64 0 0-320-448 0 0 320-64 0zM320 256l0 128 128 0 0 128-320 0 0-256 192 0z"],
    "pen-swirl": [576, 512, [], "e214", "M208 240l159-159 96 96-159 159-112 16 16-112zM560 80l-63 63-96-96 63-63 96 96zM288 0c27.8 0 54.5 4.4 79.5 12.6L314.3 65.8C305.7 64.6 296.9 64 288 64 182 64 96 150 96 256s86 192 192 192l32 0 0 64-32 0C146.6 512 32 397.4 32 256S146.6 0 288 0zM480 256c0-8.9-.6-17.7-1.8-26.3l53.2-53.2c8.2 25 12.6 51.8 12.6 79.5 0 88.4-71.6 160-160 160l-32 0 0-64 32 0c53 0 96-43 96-96z"],
    "truck-ladder": [640, 512, [], "e657", "M352 32l0 48-32 0 0 80 32 0 0 48-352 0 0-48 32 0 0-80-32 0 0-48 352 0zM272 80l-32 0 0 80 32 0 0-80zm-80 0l-32 0 0 80 32 0 0-80zm-80 0l-32 0 0 80 32 0 0-80zM608 320l0 96-67.3 0c-10.4 36.9-44.4 64-84.7 64s-74.2-27.1-84.7-64l-102.6 0c-10.4 36.9-44.4 64-84.7 64s-74.2-27.1-84.7-64l-67.3 0 0-160 352 0 0-160 144 0 80 160 0 64zM488.4 160l-40.4 0 0 96 88.4 0-48-96zM224 392a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zm232 40a40 40 0 1 0 0-80 40 40 0 1 0 0 80z"],
    "comment-image": [512, 512, [], "e148", "M512 240c0 132.5-114.6 240-256 240-38.3 0-74.7-7.9-107.3-22.1L0 512 55.7 389.5C20.8 348.5 0 296.5 0 240 0 107.5 114.6 0 256 0S512 107.5 512 240zM192 144a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM384 336l0-48-128-112-128 112 0 48 256 0z"],
    "plug-circle-bolt": [640, 512, [], "e55b", "M224-32l0 128 128 0 0-128 64 0 0 128 96 0 0 64-32 0 0 48.7c-98.6 8.1-176 90.7-176 191.3 0 27.3 5.7 53.3 16 76.9l0 35.1-64 0 0-98.7C165.2 398.1 96 319.1 96 224l0-64-32 0 0-64 96 0 0-128 64 0zM496 256a144 144 0 1 1 0 288 144 144 0 1 1 0-288zM400 416l70.9 0-22.9 80 144-112-70.9 0 22.9-80-144 112z"],
    "jeans": [512, 512, [], "e6d2", "M97 0L86.2 56 426.3 56 415.6 0 97 0zM78.5 96l-10 52 11.8 0c30.4 0 55.6-22.6 59.5-52L78.5 96zM180 96c-4.1 51.5-47.1 92-99.7 92l-19.5 0-58.8 305.9 188.5 36.3 45.7-237.8 0-196.3-56.3 0zm96.3 0l0 196.3 45.7 237.8 188.5-36.3-58.8-305.9-19.5 0c-52.5 0-95.6-40.5-99.7-92l-56.3 0zm96.5 0c3.9 29.4 29 52 59.5 52l11.8 0-10-52-61.2 0z"],
    "grid-5": [448, 512, [], "e199", "M56 32l-56 0 0 56 56 0 0-56zM0 130l0 56 56 0 0-56-56 0zm56 98l-56 0 0 56 56 0 0-56zM0 326l0 56 56 0 0-56-56 0zm0 98l0 56 56 0 0-56-56 0zm98 0l0 56 56 0 0-56-56 0zm154 0l-56 0 0 56 56 0 0-56zm42 0l0 56 56 0 0-56-56 0zm154 0l-56 0 0 56 56 0 0-56zM154 326l-56 0 0 56 56 0 0-56zm42 0l0 56 56 0 0-56-56 0zm154 0l-56 0 0 56 56 0 0-56zm42 0l0 56 56 0 0-56-56 0zM98 228l0 56 56 0 0-56-56 0zm154 0l-56 0 0 56 56 0 0-56zm42 0l0 56 56 0 0-56-56 0zm154 0l-56 0 0 56 56 0 0-56zM154 130l-56 0 0 56 56 0 0-56zm42 0l0 56 56 0 0-56-56 0zm154 0l-56 0 0 56 56 0 0-56zm42 0l0 56 56 0 0-56-56 0zM98 32l0 56 56 0 0-56-56 0zm154 0l-56 0 0 56 56 0 0-56zm42 0l0 56 56 0 0-56-56 0zm154 0l-56 0 0 56 56 0 0-56z"],
    "pipe-section": [640, 512, [], "e438", "M64 96l0 32 512 0 0-32 64 0 0 320-64 0 0-32-512 0 0 32-64 0 0-320 64 0z"],
    "restroom": [640, 512, [], "f7bd", "M80 48a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM53.4 128l149.2 0 7 22.5 44.9 144-54.5 17 0 200.5-64 0 0-160-16 0 0 160-64 0 0-200.5-54.5-17 44.9-144 7-22.5zM344 0l0 512-48 0 0-512 48 0zM464 48a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm-26.6 80l149.2 0 7 22.5 44.9 144-40.2 12.5 25.7 77-40 0 0 128-64 0 0-128-16 0 0 128-64 0 0-128-40 0 25.7-77-40.2-12.5 44.9-144 7-22.5z"],
    "reflect-both": [448, 512, [], "e66f", "M87 73l120 120 17 17 17-17c93.2-93.2 146.8-146.8 161-161L46.1 32 87 73zM41 119L0 78.1 0 433.9c14.1-14.1 67.8-67.8 161-161l17-17-17-17-120-120zM87 439l-41 41 355.9 0-177.9-177.9-17 17-120 120zm361-361c-14.1 14.1-67.8 67.8-161 161l-17 17 17 17c93.2 93.2 146.8 146.8 161 161l0-355.9z"],
    "gear-code": [512, 512, [], "e5e8", "M200.1-16l112 0 19.7 95.5c14.1 6 27.3 13.7 39.3 22.8l92.6-30.7 56 97-72.9 64.8c.9 7.4 1.3 15 1.3 22.7s-.5 15.3-1.3 22.7l72.9 64.8-56 97-92.6-30.7c-12.1 9.1-25.3 16.7-39.3 22.8l-19.7 95.5-112 0-19.7-95.5c-14.1-6-27.2-13.7-39.3-22.8l-92.6 30.7-56-97 72.9-64.8c-.9-7.4-1.3-15-1.3-22.7s.5-15.3 1.3-22.7l-72.9-64.8 56-97 92.6 30.7c12.1-9.1 25.3-16.7 39.3-22.8L200.1-16zm99.5 172.5l4.5-19.5-39-9-4.5 19.5-48 208-4.5 19.5 39 9 4.5-19.5 48-208zM182.2 238.1l14.1-14.1-28.3-28.3c-6.5 6.5-21.8 21.8-46.1 46.1L107.8 256c6.5 6.5 21.8 21.8 46.1 46.1l14.1 14.1 28.3-28.3c-8.8-8.8-19.5-19.5-32-32l17.9-17.9zm176-28.3l-14.1-14.1-28.3 28.3c8.8 8.8 19.5 19.5 32 32-12.5 12.5-23.2 23.2-32 32l28.3 28.3c6.5-6.5 21.8-21.8 46.1-46.1L404.3 256c-6.5-6.5-21.8-21.8-46.1-46.1z"],
    "curling-stone": [512, 512, [129356, "curling"], "f44a", "M160 32l-32 0 0 128-64 0 0 64-64 0 0 104 512 0 0-104-64 0 0-64-256 0 0-64 192 0 0-64-224 0zM512 376l-512 0 0 104 512 0 0-104z"],
    "anchor-lock": [640, 512, [], "e4ad", "M288 64a32 32 0 1 0 0 64 32 32 0 1 0 0-64zM192 96c0-53 43-96 96-96s96 43 96 96c0 41.8-26.7 77.4-64 90.5l0 261.5 48 0 0 64-288 0 0-204.1c-10.5 9.2-21.9 19.2-34.3 30L14.1 301.7c4.4-3.8 31.7-27.8 82.1-71.8L112 216.1c2.5 2.2 29.1 25.5 79.8 69.8l18.1 15.8-31.6 36.1c-12.4-10.8-23.8-20.8-34.3-30l0 140.1 112 0 0-261.5c-37.3-13.2-64-48.7-64-90.5zM528 272c-17.7 0-32 14.3-32 32l0 48 64 0 0-48c0-17.7-14.3-32-32-32zm-80 32c0-44.2 35.8-80 80-80s80 35.8 80 80l0 48 32 0 0 192-224 0 0-192 32 0 0-48z"],
    "timeline": [576, 512, [], "e29c", "M48 16l160 0 0 160-48 0 0 48 256 0 0-48-48 0 0-160 160 0 0 160-48 0 0 48 96 0 0 64-256 0 0 48 48 0 0 160-160 0 0-160 48 0 0-48-256 0 0-64 96 0 0-48-48 0 0-160z"],
    "briefcase-blank": [512, 512, [], "e0c8", "M168 0l-24 0 0 96-144 0 0 384 512 0 0-384-144 0 0-96-200 0zM320 96l-128 0 0-48 128 0 0 48z"],
    "coin-front": [512, 512, [], "e3fc", "M0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zM256 112a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm0 336a192 192 0 1 0 0-384 192 192 0 1 0 0 384zm24-240l0-24-48 0 0 144 48 0 0-120z"],
    "calendar-star": [448, 512, [], "f736", "M160 0l0 64 128 0 0-64 64 0 0 64 96 0 0 416-448 0 0-416 96 0 0-64 64 0zM261.6 244.2l-37.6-76.2-37.6 76.2-84.1 12.2 60.9 59.3-14.4 83.8 75.2-39.6 75.2 39.6-14.4-83.8 60.9-59.3-84.1-12.2z"],
    "pen-circle": [512, 512, [], "e20e", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM144 288l95-95 80 80-95 95-96 16 16-96zm256-96l-47 47-80-80 47-47 80 80z"],
    "lightbulb": [384, 512, [128161], "f0eb", "M288 358.3c57.4-33.2 96-95.2 96-166.3 0-106-86-192-192-192S0 86 0 192c0 71.1 38.6 133.1 96 166.3l0 25.7 192 0 0-25.7zm0 73.7l-192 0 0 96 192 0 0-96zM184 112c-39.8 0-72 32.2-72 72l0 8-48 0 0-8c0-66.3 53.7-120 120-120l8 0 0 48-8 0z"],
    "page-caret-down": [384, 512, ["file-caret-down"], "e429", "M240 0L0 0 0 512 384 512 384 144 240 0zM96 224l192 0 0 24-96 104-96-104 0-24z"],
    "book-blank": [448, 512, [128213, 128215, 128216, 128217, "book-alt"], "f5d9", "M384 0l-384 0 0 512 448 0 0-64-32 0 0-64 32 0 0-384-64 0zM96 384l256 0 0 64-288 0 0-32c0-17.7 14.3-32 32-32z"],
    "trash-undo": [448, 512, ["trash-arrow-turn-left"], "f895", "M304-16l16 48 128 0 0 64-448 0 0-64 128 0 16-48 160 0zM32 144l384 0-24 368-336 0-24-368zM209 257l17-17-33.9-33.9c-3.5 3.5-30.5 30.5-81 81l-17 17c3.5 3.5 30.5 30.5 81 81l17 17 33.9-33.9c-10.3-10.3-23.6-23.6-40-40l54.1 0c22.1 0 40 17.9 40 40l0 64 48 0 0-64c0-48.6-39.4-88-88-88l-54.1 0 23-23z"],
    "subtitles": [512, 512, [], "e60f", "M512 64l-512 0 0 384 512 0 0-384zM88 240l200 0 0 48-224 0 0-48 24 0zm272 0l88 0 0 48-112 0 0-48 24 0zM88 336l88 0 0 48-112 0 0-48 24 0zm160 0l200 0 0 48-224 0 0-48 24 0z"],
    "wave-triangle": [576, 512, [], "f89a", "M196.2 40.1l23.7 39.5 168.3 280.5 99.2-124.1 20-25 50 40-20 25C435.6 403.3 383.3 468.6 380.7 471.9l-23.7-39.5-168.3-280.5-99.3 124.1-20 25-50-40 20-25C141.4 108.7 193.6 43.4 196.2 40.1z"],
    "foot-wing": [576, 512, [], "e834", "M246.4-32c94.6 0 171.2 76.7 171.3 171.2 0 39.6-13.8 78.1-38.9 108.7l-3.9 4.7 73.7 147.3 43.9 5.5c48 6 84.1 46.8 84.1 95.2l0 43.3-224 0-240.7-144.4C67.5 373 52.2 316.2 77 271l25.6-46.6c-23-15.9-38.1-42.4-38.1-72.4l0-27.4C27.6 114.1 .5 80.3 .5 40l0-72 245.9 0zM48.5 40c0 22.1 17.9 40 40 40l168 0 0 48-144 0 0 24c0 22.1 17.9 40 40 40l85.1 0 0 48-85.1 0c-1.2 0-2.4-.1-3.5-.2l-18.7 34 110.6 66.3 100.8-122.7c18.1-22.1 28-49.7 28-78.3 0-68.1-55.2-123.2-123.3-123.2l-197.9 0 0 24z"],
    "gauge-circle-plus": [640, 512, [], "e498", "M288 0c126.8 0 232.1 92.2 252.4 213.2-14.3-3.4-29.1-5.2-44.4-5.2-70.9 0-132.8 38.4-166.1 95.6-5.3-4.6-11.3-8.3-17.9-11l0-196.7-48 0 0 196.7c-23.5 9.5-40 32.5-40 59.3 0 35.3 28.7 64 64 64 5.7 0 11.2-.7 16.5-2.1 2.5 34.5 14 66.4 32.3 93.5-15.8 3-32.1 4.6-48.8 4.6-141.4 0-256-114.6-256-256S146.6 0 288 0zM176 176a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm-16 80a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM432 144a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm64 112a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm16 80l0-16-32 0 0 64-64 0 0 32 64 0 0 64 32 0 0-64 64 0 0-32-64 0 0-48z"],
    "film-music": [640, 512, [], "e769", "M64 32l448 0 0 166.7-160 29.1 0 176c-15.3 3.8-29.7 10.5-42.1 19.7-17.1 12.8-31.9 32.2-36.5 56.4L64 480 64 32zm48 320l0 64 64 0 0-64-64 0zm0-128l0 64 64 0 0-64-64 0zm0-128l0 64 64 0 0-64-64 0zm352 0l-64 0 0 64 64 0 0-64zM624 255.8l0 208.1c0 23.3-18 35.4-29.1 40.5-11.9 5.4-25.4 7.5-34.9 7.5s-22.9-2.1-34.9-7.5c-11.1-5-29.1-17.2-29.1-40.5s18-35.4 29.1-40.5c11.9-5.4 25.4-7.5 34.9-7.5 4.6 0 10.1 .5 16 1.6l0-85-128 23.3 0 140.1c0 23.3-18 35.4-29.1 40.5-11.9 5.4-25.4 7.5-34.9 7.5s-22.9-2.1-34.9-7.5c-11.1-5-29.1-17.2-29.1-40.5s18-35.4 29.1-40.5c11.9-5.4 25.4-7.5 34.9-7.5 4.6 0 10.1 .5 16 1.6l0-181.8 19.7-3.6 176-32 28.3-5.1 0 28.8z"],
    "head-side": [512, 512, [], "f6e9", "M224 0C338.4 0 432.7 85.7 446.3 196.4l49.7 59.6 0 64-64 0 0 128-112 0 0 64-256 0 0-131.2C24.4 340.4 0 285 0 224 0 100.3 100.3 0 224 0zm96 224a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "octagon-equals": [512, 512, [], "e6b3", "M0 160L0 352 160 512 352 512 512 352 512 160 352 0 160 0 0 160zm160 16l192 0 0 48-192 0 0-48zm0 112l192 0 0 48-192 0 0-48z"],
    "chevrons-left": [512, 512, ["chevron-double-left"], "f323", "M41.6 233.4l-22.6 22.6 22.6 22.6 192 192 22.6 22.6 45.3-45.3-22.6-22.6-169.4-169.4 169.4-169.4 22.6-22.6-45.3-45.3-22.6 22.6-192 192zm192 0l-22.6 22.6 22.6 22.6 192 192 22.6 22.6 45.3-45.3-22.6-22.6-169.4-169.4 169.4-169.4 22.6-22.6-45.3-45.3-22.6 22.6-192 192z"],
    "circle-arrow-right": [512, 512, ["arrow-circle-right"], "f0a9", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM377 273l-80 80-17 17-33.9-33.9c7.6-7.6 26.3-26.3 56-56l-174.1 0 0-48 174.1 0c-29.7-29.7-48.4-48.4-56-56L280 142.1c.8 .8 33.1 33.1 97 97l17 17-17 17z"],
    "game-board": [448, 512, [], "f867", "M0 32l448 0 0 448-448 0 0-448zM144 96l0 80 80 0 0-80-80 0zm0 160l0-80-80 0 0 80 80 0zm80 0l-80 0 0 80-80 0 0 80 80 0 0-80 80 0 0 80 80 0 0-80 80 0 0-80-80 0 0-80 80 0 0-80-80 0 0 80-80 0 0 80zm0 0l80 0 0 80-80 0 0-80z"],
    "file-chart-column": [384, 512, ["file-chart-line"], "f659", "M0 0L240 0 384 144 384 512 0 512 0 0zM208 58.5L208 176 325.5 176 208 58.5zM208 280l0-24-48 0 0 192 48 0 0-168zm96 32l0-24-48 0 0 160 48 0 0-136zM112 344l0-24-48 0 0 128 48 0 0-104z"],
    "custard": [512, 512, [127854], "e403", "M416 64l27.7 124.7-69.1-19.7-6.6-1.9-6.6 1.9-105.4 30.1-105.4-30.1-6.6-1.9-6.6 1.9-69.1 19.7 27.7-124.7 320 0zM32.3 350.9l24.2-108.9 87.6-25 105.4 30.1 6.6 1.9 6.6-1.9 105.4-30.1 87.5 25 24.5 110-447.7-1.1zM24 400l488 0 0 48-512 0 0-48 24 0z"],
    "block-question": [448, 512, [], "e3dd", "M448 480l-448 0 0-448 448 0 0 448zM72 384a24 24 0 1 0 0 48 24 24 0 1 0 0-48zm304 0a24 24 0 1 0 0 48 24 24 0 1 0 0-48zM200 352l0 48 48 0 0-48-48 0zm-8-208c-30.9 0-56 25.1-56 56l0 6.5 48 0 0-6.5c0-4.4 3.6-8 8-8l56.8 0c8.4 0 15.2 6.8 15.2 15.2 0 4.4-2.7 10.5-14.3 19.6-15.6 12.1-33.4 21.4-49.7 32.7l0 52.5 48 0 0-26.9c8.4-5.1 20.2-12 31.1-20.5 14.7-11.5 32.9-30 32.9-57.5 0-34.9-28.3-63.2-63.2-63.2L192 144zM72 80a24 24 0 1 0 0 48 24 24 0 1 0 0-48zm304 0a24 24 0 1 0 0 48 24 24 0 1 0 0-48z"],
    "mars-and-venus": [512, 512, [9893], "f224", "M336-64l176 0 0 176-64 0 0-66.7-63 63c19.5 28.4 31 62.7 31 99.8 0 86.3-62.1 158.1-144 173.1l0 34.9 64 0 0 64-64 0 0 64-64 0 0-64-64 0 0-64 64 0 0-34.9c-81.9-15-144-86.8-144-173.1 0-97.2 78.8-176 176-176 37 0 71.4 11.4 99.8 31l63-63-66.7 0 0-64zm16 272a112 112 0 1 0 -224 0 112 112 0 1 0 224 0z"],
    "network-wired": [576, 512, [], "f6ff", "M328 88l0 48-80 0 0-48 80 0zM248 32l-56 0 0 160 64 0 0 32-256 0 0 64 128 0 0 32-64 0 0 160 192 0 0-160-64 0 0-32 192 0 0 32-64 0 0 160 192 0 0-160-64 0 0-32 128 0 0-64-256 0 0-32 64 0 0-160-136 0zM120 376l80 0 0 48-80 0 0-48zm336 0l0 48-80 0 0-48 80 0z"],
    "face-confused": [512, 512, [], "e36d", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM203.2 385.6l-32 24-28.8-38.4c13.9-10.4 24.5-18.4 32-24 37.4-28 82.9-43.2 129.6-43.2l64 0 0 48-64 0c-36.3 0-71.7 11.8-100.8 33.6zM144 208a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm192-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "building-shield": [576, 512, [], "e4d8", "M416 0l-384 0 0 512 266.3 0c-12.6-14.6-23.5-30.8-32.2-48l-90.1 0 0-112 64 0 0-82.6 16-5.3 0-40.1 64 0 0 18.7 96-32 0-210.7zM128 96l64 0 0 64-64 0 0-64zm192 0l0 64-64 0 0-64 64 0zM128 224l64 0 0 64-64 0 0-64zM462 530.8c69.3-30.8 114-99.6 114-175.5l0-51.2-144-48-144 48 0 51.2c0 75.9 44.7 144.6 114 175.5l30 13.3 30-13.3zm-30-39.2l0-184.9 96 32 0 16.6c0 56.9-33.5 108.5-85.5 131.6L432 491.6z"],
    "bed-empty": [576, 512, [128719], "f8f9", "M64 64l0-32-64 0 0 448 64 0 0-96 448 0 0 96 64 0 0-288-512 0 0-128z"],
    "grill-hot": [448, 512, [], "e5a5", "M128-64l0 24c0 9 3.6 17.6 9.9 24L168 14.1c15.4 15.4 24 36.2 24 57.9l0 24-48 0 0-24c0-9-3.6-17.6-9.9-24L104 17.9C88.6 2.6 80-18.3 80-40l0-24 48 0zM0 144l448 0c0 86.2-52.4 160.2-127.2 191.7l53.2 124.2c1.8 4.1 6.2 14.6 13.5 31.4l-44.1 18.9c-14.5-33.8-15.2-35.4-26.6-62.2L160 448c0 35.3-28.7 64-64 64s-64-28.7-64-64 28.7-64 64-64c3.4 0 6.8 .3 10.1 .8l21-49.1C52.4 304.2 0 230.2 0 144zM151.8 400l144.4 0-21.8-50.8C263.2 351 251.7 352 240 352l-32 0c-11.7 0-23.2-1-34.4-2.8L151.8 400zM96 472a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM240-40c0 9 3.6 17.6 9.9 24L280 14.1c15.4 15.4 24 36.2 24 57.9l0 24-48 0 0-24c0-9-3.6-17.6-9.9-24L216 17.9C200.6 2.6 192-18.3 192-40l0-24 48 0 0 24z"],
    "ear-waveform": [640, 512, [], "e75d", "M474 240c3.9-15.3 6-31.4 6-48 0-106-86-192-192-192S96 86 96 192l0 320 208 0 0-224 80 0 0-48 90 0zM288 112c-44.2 0-80 35.8-80 80l0 16.4c36 4 64 34.5 64 71.6 0 39.8-32.2 72-72 72l-40 0 0-48 40 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-40 0 0-64c0-70.7 57.3-128 128-128s128 57.3 128 128l-48 0c0-44.2-35.8-80-80-80zM480 288l-48 0 0 256 48 0 0-256zm80 32l-48 0 0 192 48 0 0-192zM400 336l-48 0 0 160 48 0 0-160zm240 32l-48 0 0 96 48 0 0-96z"],
    "code": [640, 512, [], "f121", "M362.3-7.6l-8.8 30.8-128 448-8.8 30.8 61.5 17.6 8.8-30.8 128-448 8.8-30.8-61.5-17.6zM435 160c6.6 6.6 38.6 38.6 96 96-57.4 57.4-89.4 89.4-96 96l45.3 45.3 118.6-118.6 22.6-22.6c-2.9-2.9-42.4-42.4-118.6-118.6L480.3 114.7 435 160zM160.3 114.7c-2.9 2.9-42.4 42.4-118.6 118.6L19 256c2.9 2.9 42.4 42.4 118.6 118.6l22.6 22.6 45.3-45.3c-6.6-6.6-38.6-38.6-96-96 57.4-57.4 89.4-89.4 96-96l-45.3-45.3z"],
    "feather-pointed": [512, 512, ["feather-alt"], "f56b", "M512 0c-4.4 53.7-19.9 155.2-54.5 245.1l-89.5 26.9 0 16 71.1 0c-8.2 16.9-17.2 32.9-27.1 47.6l-108 32.4 0 16 66.3 0c-65 57.7-174.7 91.5-248.8 38.4L32 512 0 480c44.2-44.3 134.9-134.9 272-272L240 176 68.9 347.1C48.3 273.6 85.1 183.9 137.4 131.6 228.5 40.5 428.3 6.9 512 0z"],
    "box-isometric-tape": [512, 512, [], "e798", "M496 391L256 526 16 391 16 120 105.5 69.3 352 208 352 333 432 288 432 160 187.8 22.6 256-16 496 120 496 391z"],
    "file-circle-question": [576, 512, [], "e4ef", "M272 0l-240 0 0 512 244 0c-22.7-31.5-36-70.2-36-112 0-100.6 77.4-183.2 176-191.3L416 144 272 0zm85.5 176L240 176 240 58.5 357.5 176zM576 400a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zM432 344c-13.3 0-24 10.7-24 24l-32 0c0-30.9 25.1-56 56-56s56 25.1 56 56c0 19.8-11.7 37.8-29.8 45.9l-10.2 4.5 0 5.6-32 0 0-26.4c4.6-2.1 14.4-6.4 29.2-13 6.6-2.9 10.8-9.4 10.8-16.6 0-13.3-10.7-24-24-24zM416 480l0-32 32 0 0 32-32 0z"],
    "face-nose-steam": [512, 512, [], "e382", "M498.3 339.8c9.1-26.2 14-54.4 14-83.8 0-141.4-114.6-256-256-256S.3 114.6 .3 256c0 29.6 5 58.1 14.3 84.6 31.8-22.5 75.1-21.5 105.8 3.1 33.3-19.3 57.3-33.3 71.9-41.8 34.9 34.9 31.5 31.5 51.5 51.5-8.5 14.6-22.4 38.6-41.8 71.9 19.2 24 24.1 55.7 14.5 83.6 13 2 26.2 3.1 39.7 3.1 14 0 27.7-1.1 41.1-3.3-9.5-27.8-4.6-59.4 14.6-83.3-19.3-33.3-33.3-57.3-41.8-71.9 34.9-34.9 31.5-31.5 51.5-51.5 14.6 8.5 38.6 22.4 71.9 41.8 30.3-24.3 73-25.6 104.6-3.9zM96.3 224l128 0 0 48-128 0 0-48zm192 0l128 0 0 48-128 0 0-48zm88.9-62.1c-50.3 25.2-77.6 38.8-81.9 40.9l-17.9-35.8c4.2-2.1 31.5-15.8 81.9-40.9l17.9-8.9 17.9 35.8-17.9 8.9zm-259.8-8.9l17.9-35.8 81.9 40.9 17.9 8.9-17.9 35.8-81.9-40.9-17.9-8.9zM414.7 378.5c-5.5 5.5-9.4 12-11.7 19l-82.7-45.5 45.5 82.7c-6.9 2.3-13.5 6.2-19 11.7-18.7 18.7-18.7 49.1 0 67.9 14.8 14.8 36.8 17.9 54.7 9.4 .6 .7 1.2 1.3 1.9 2 25 25 65.5 25 90.5 0s25-65.5 0-90.5c-.6-.6-1.3-1.3-2-1.9 8.6-17.8 5.4-39.9-9.4-54.7-18.7-18.7-49.1-18.7-67.9 0zM22.2 433.2c-.7 .6-1.3 1.2-2 1.9-25 25-25 65.5 0 90.5s65.5 25 90.5 0c.6-.6 1.3-1.3 1.9-2 17.9 8.6 39.9 5.4 54.7-9.4 18.7-18.7 18.7-49.1 0-67.9-5.7-5.7-12.4-9.6-19.5-11.9L192.3 352 111 397.2c-2.3-6.8-6.1-13.2-11.6-18.7-18.7-18.7-49.1-18.7-67.9 0-14.8 14.8-17.9 36.8-9.4 54.7z"],
    "signature": [640, 512, [], "f5b7", "M192 128c0-17.7 14.3-32 32-32s32 14.3 32 32l0 7.8c0 27.7-2.4 55.3-7.1 82.5l-130 39-22.8 6.8 0 103.8-96 0 0 48 96 0 0 64 114.6 0c3.4-6 15-26.3 34.8-60.8 26.8-47 46.5-97.7 58.4-150.5l94.4-28.3c-8.1 24.2-16.9 50.8-26.5 79.6l204.4 0 0-64-115.6 0c11.7-35.2 24.2-72.6 37.5-112.4-28.8 8.6-89.3 26.8-181.4 54.4 2.4-20.7 3.6-41.4 3.6-62.3l0-7.8c0-53-43-96-96-96s-96 43-96 96l0 64 64 0 0-64zM160 311.8l71.8-21.5c-10.4 33.8-24.5 66.4-42.1 97.2l-16.3 28.6-13.4 0 0-104.2zM616 416l24 0 0-48-316.9 0c-6.5 16.3-13.7 32.3-21.6 48L616 416z"],
    "earth-americas": [512, 512, [127758, "earth", "earth-america", "globe-americas"], "f57d", "M55.7 199.7l40.3 40.3 48 0 48 48 0 64 32 32 0 64 64 0 0-48 64-64 0-80-128 0-32-32 0-32 80 0 0-32-32-32 0-16 32-32 0-31.4c-5.3-.4-10.6-.6-16-.6-95.4 0-175.7 64.2-200.3 151.7zM464 256c0-36.9-9.6-71.5-26.4-101.6l-37.6 37.6 0 80 63.4 0c.4-5.3 .6-10.6 .6-16zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0z"],
    "carrot": [640, 512, [129365], "f787", "M464-48L440.6-24.6c-31.2 31.2-31.2 81.9 0 113.1 15.6 15.6 31.2 31.2 46.9 46.9 31.2 31.2 81.9 31.2 113.1 0L624 112 600.6 88.6c-31.2-31.2-81.9-31.2-113.1 0 31.2-31.2 31.2-81.9 0-113.1L464-48zM332.3 96c-45.5 0-87.6 20.8-115.2 55.2 43.7 43.7 68 68 72.8 72.8L256 257.9c-6.4-6.4-27.5-27.5-63.4-63.4-86.5 201.8-133.7 311.9-141.6 330.3 40.9-17.5 106.2-45.5 195.9-84-30.5-30.5-49.5-49.5-57-57L224 350.1c5.2 5.2 28.7 28.7 70.5 70.5l95.9-41.1C444.8 356.2 480 302.8 480 243.7 480 162.1 413.9 96 332.3 96z"],
    "sparkles": [640, 512, [10024], "f890", "M480 32l32-72 32 72 72 32-72 32-32 72-32-72-72-32 72-32zM160 192l64-144 64 144 144 64-144 64-64 144-64-144-144-64 144-64zM480 344l32 72 72 32-72 32-32 72-32-72-72-32 72-32 32-72z"],
    "square-l": [448, 512, [], "e275", "M448 32l-448 0 0 448 448 0 0-448zM192 168l0 152 112 0 0 48-160 0 0-224 48 0 0 24z"],
    "cauldron": [448, 512, [], "f6bf", "M160 32c17.7 0 32-14.3 32-32s-14.3-32-32-32-32 14.3-32 32 14.3 32 32 32zm128 80a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM35.1 224C16.5 257 0 297.1 0 334.4 0 371.8 11.9 403.8 32 429.9l0 82.1 48 0 0-39c40.4 25.5 91.8 39 144 39s103.6-13.5 144-39l0 39 48 0 0-82.1c20.1-26.1 32-58.1 32-95.5 0-37.3-16.5-77.4-35.1-110.4l35.1 0 0-64-448 0 0 64 35.1 0z"],
    "temperature-full": [320, 512, ["temperature-4", "thermometer-4", "thermometer-full"], "f2c7", "M256 0L64 0 64 260.7C34.5 287 16 325.4 16 368 16 447.5 80.5 512 160 512s144-64.5 144-144c0-42.6-18.5-81-48-107.3L256 0zM224 368c0 35.3-28.7 64-64 64s-64-28.7-64-64c0-26.9 16.5-49.9 40-59.3l0-236.7 48 0 0 236.7c23.5 9.5 40 32.5 40 59.3z"],
    "table-cells-row-lock": [640, 512, [], "e67a", "M256 288l0-64 153.3 0c17.1-42.2 56-73.2 102.7-79l0-113-448 0 0 448 304 0 0-64-112 0 0-64 112 0 0-64-112 0zm0-192l192 0 0 64-192 0 0-64zM528 240c17.7 0 32 14.3 32 32l0 48-64 0 0-48c0-17.7 14.3-32 32-32zm-80 32l0 48-32 0 0 192 224 0 0-192-32 0 0-48c0-44.2-35.8-80-80-80s-80 35.8-80 80z"],
    "circle-user-circle-plus": [640, 512, [], "e7a3", "M496 208c-77.5 0-144.3 45.9-174.6 112l-145.4 0-23.9 71.6c34.8 34.8 82.8 56.4 135.9 56.4 7.4 0 14.6-.4 21.7-1.2 5.5 21.9 14.8 42.4 27.1 60.6-15.8 3-32.1 4.6-48.8 4.6-141.4 0-256-114.6-256-256S146.6 0 288 0c126.8 0 232.1 92.2 252.4 213.2-14.3-3.4-29.1-5.2-44.4-5.2zM288 272a72 72 0 1 0 0-144 72 72 0 1 0 0 144zm208-16a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm16 80l0-16-32 0 0 64-64 0 0 32 64 0 0 64 32 0 0-64 64 0 0-32-64 0 0-48z"],
    "bolt-lightning": [384, 512, [], "e0b7", "M0 288l32-288 224 0-48 160 176 0 0 48-256 304 48-224-176 0z"],
    "cloud-showers-water": [512, 512, [], "e4e4", "M279.4 55.7c-15.2-32.9-48.5-55.7-87.2-55.7-53 0-96 43-96 96-35.3 0-64 28.7-64 64l0 64 448 0 0-64c0-35.3-28.7-64-64-64l-1.6 0c-7.4-36.5-39.7-64-78.4-64-22.2 0-42.3 9.1-56.8 23.7zM22.9 384l50.6 0 37.3-112-50.6 0-37.3 112zm402.6 0l37.3-112-50.6 0-37.3 112 50.6 0zm-120 0l37.3-112-50.6 0-37.3 112 50.6 0zm-112 0l37.3-112-50.6 0-37.3 112 50.6 0zm-48.4 33.7l-8.9-3.6-8.9 3.6C44.3 450.9 2.2 467.7 1 468.2l17.8 44.6c2.7-1.1 41.9-16.7 117.4-47l111.1 44.4 8.9 3.6 8.9-3.6 111.1-44.4c75.5 30.2 114.6 45.9 117.4 46.9l17.8-44.6c-1.2-.5-43.3-17.3-126.3-50.5l-8.9-3.6-8.9 3.6-111.1 44.4-111.1-44.4z"],
    "arrow-up-long": [384, 512, ["long-arrow-up"], "f176", "M214.9-22.6l-22.6-22.6-22.6 22.6-128 128-22.6 22.6 45.3 45.3c6.6-6.6 38.6-38.6 96-96l0 466.7 64 0 0-466.7 96 96 45.3-45.3-22.6-22.6-128-128z"],
    "flux-capacitor": [448, 512, [], "f8ba", "M0 32l448 0 0 448-448 0 0-448zM384 152c0-30.9-25.1-56-56-56s-56 25.1-56 56c0 6.6 1.1 12.9 3.2 18.8l-51.2 51.2-51.2-51.2c2.1-5.9 3.2-12.2 3.2-18.8 0-30.9-25.1-56-56-56s-56 25.1-56 56 25.1 56 56 56c6.6 0 12.9-1.1 18.8-3.2l61.2 61.2 0 43.4c-18.9 9-32 28.3-32 50.6 0 30.9 25.1 56 56 56s56-25.1 56-56c0-22.3-13.1-41.6-32-50.6l0-43.4 61.2-61.2c5.9 2.1 12.2 3.2 18.8 3.2 30.9 0 56-25.1 56-56z"],
    "address-card": [576, 512, [62140, "contact-card", "vcard"], "f2bb", "M576 32l-576 0 0 448 576 0 0-448zM256 288l32 96-224 0 32-96 160 0zM120 192a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm240-48l136 0 0 48-160 0 0-48 24 0zm0 96l136 0 0 48-160 0 0-48 24 0z"],
    "staff": [512, 512, [], "f71b", "M306.3 0L512 0 512 244.2c-23.4 6.7-46.2 13.2-68.3 19.5l-30.1 53.3-52.6-29.7-96 27.4C138.1 441.8 73.8 506.1 72 507.9L4.1 440c18.6-18.6 49.3-49.3 91.9-91.9l0-60.1 60.1 0 49.9-49.9 8.8-8.8 12-3.4 189.2-54.1 0-75.8-50.3 0-2.7 5.5-21.5 42.9-85.9-42.9c34.5-69 43.2-86.4 50.7-101.5z"],
    "basket-shopping-minus": [576, 512, [], "e652", "M288-10.9l17.4 18.4 144 152 .5 .5 110.1 0 0 64-23.1 0-56.9 256-384 0-56.9-256-23.1 0 0-64 110.1 0 .5-.5 144-152 17.4-18.4zm0 69.8L192.2 160 383.8 160 288 58.9zM216 296l-24 0 0 48 192 0 0-48-168 0z"],
    "angle-right": [320, 512, [8250], "f105", "M301.5 256L278.9 278.6 118.9 438.6 96.3 461.3 51 416 73.6 393.4 211 256 73.6 118.6 51 96 96.3 50.7 118.9 73.4 278.9 233.4 301.5 256z"],
    "toilet-paper-under": [512, 512, [58015, "toilet-paper-blank-under", "toilet-paper-reverse", "toilet-paper-reverse-alt"], "e2a0", "M327.1 32c-8.8 11.1-16 23.1-21.9 34.8-21.4 42.7-33.2 98.4-33.2 157.2s11.8 114.5 33.2 157.2c5.9 11.7 13.1 23.7 21.9 34.8L96 416C43 416 0 330 0 224S43 32 96 32l231.1 0zM416 288c17.7 0 32-28.7 32-64s-14.3-64-32-64-32 28.7-32 64 14.3 64 32 64zm0 128c-53 0-96-86-96-192s43-192 96-192 96 86 96 192-43 192-96 192zM128 520l0-56 288 0c43 0 74.7-26.7 96-57.6l0 137.6-384 0 0-24z"],
    "stomach": [512, 512, [], "f623", "M192 32l0-32-64 0 0 224 128 0 0 64c0 35.3-28.7 64-64 64l-192 0 0 160 64 0 0-80 48 0c24.6 0 36 9.5 58.2 28.2l0 0c1.7 1.4 3.4 2.9 5.3 4.4 12.6 10.5 28.4 22.9 49.6 32.2 21.4 9.5 46.9 15.2 78.9 15.2 114.9 0 208-93.1 208-208l0-80c0-70.7-57.3-128-128-128-47.4 0-88.7 25.7-110.9 64l-81.1 0 0-128zM352 256l-32 0 0-32c0-35.3 28.7-64 64-64s64 28.7 64 64l0 80c0 5.4-.3 10.7-.9 16l-39.1 0-43.2-57.6-4.8-6.4-8 0z"],
    "face-cowboy-hat": [512, 512, [], "e36e", "M0 15C33.9 37.2 73.8 55 117.7 67.2L161.5-64 254.8-26.7 348.1-64 391.8 67.2c43.9-12.1 83.8-30 117.7-52.2-26.5 83-130.5 145-254.8 145S26.5 98 0 15zM32 288c0-46 13.9-88.8 37.7-124.4 47.8 24.5 109.7 41.8 186.3 41.8s138.5-17.3 186.3-41.8C466.1 199.2 480 242 480 288 480 411.7 379.7 512 256 512S32 411.7 32 288zm224 79c-50.9 0-98.3-9.2-138-25.1 11.3 65.9 68.8 116.1 138 116.1s126.6-50.2 138-116.1c-39.6 15.9-87 25.1-138 25.1zm-48-95a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm128 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "face-meh": [512, 512, [128528, "meh"], "f11a", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM176 176a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm128 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM176 320l184 0 0 48-208 0 0-48 24 0z"],
    "arrow-up-from-ground-water": [640, 512, [], "e4b5", "M320.4-9.9l17 17 88 88 17 17-33.9 33.9c-6.3-6.3-27.6-27.6-64-64l0 302.1-48 0 0-302.1c-36.4 36.4-57.7 57.7-64 64l-33.9-33.9 17-17 88-88 17-17zM240.4 192l0 186.6c-6.6-2.6-19.9-8-40-16-6.4 2.5-47.1 18.8-122.3 48.9l-13.8-4.6 0-214.9 176 0zm336 0l0 214.9-13.7 4.6c-75.1-30.1-115.9-46.4-122.3-48.9-20.1 8-33.4 13.4-40 16l0-186.6 176 0zM209.3 417.7l111.1 44.4 111.1-44.4 8.9-3.6 8.9 3.6 111.8 44.7c29.2-9.7 50.1-16.7 62.4-20.8l15.2 45.5c-11 3.7-34.6 11.5-70.8 23.6l-8.3 2.8-8.2-3.3-111.1-44.4-111.1 44.4-8.9 3.6-8.9-3.6-111.1-44.4-111.1 44.4-8.2 3.3-8.3-2.8C36.6 498.7 13 490.8 2 487.2l15.2-45.5c12.4 4.1 33.2 11.1 62.4 20.8l111.8-44.7 8.9-3.6 8.9 3.6z"],
    "face-pleading": [512, 512, [], "e386", "M0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm160 72c48.6 0 88-39.4 88-88 0-42.2-29.8-77.5-69.5-86 6.8-9.3 12-19.8 15.2-31.3 .3-1.1 2.6-9.2 7-24.4l-38.5-11c-4.3 15.2-6.7 23.3-7 24.4-6.6 23.1-26.4 40.1-50.2 43.1-6.3 .8-16.8 2.1-31.4 3.9l5 39.7 4.1-.5c-6.9 12.5-10.8 26.9-10.8 42.2 0 48.6 39.4 88 88 88zm192 0c48.6 0 88-39.4 88-88 0-15.3-3.9-29.7-10.8-42.2l4.1 .5 5-39.7c-14.6-1.8-25.1-3.1-31.4-3.9-23.9-3-43.6-19.9-50.2-43.1-.3-1.1-2.6-9.2-7-24.4l-38.5 11 5.5 19.2 1.5 5.2c3.3 11.5 8.5 22 15.2 31.3-39.7 8.5-69.5 43.8-69.5 86 0 48.6 39.4 88 88 88zM224 384l-24 0 0 48 112 0 0-48-88 0zM128 232c17.7 0 32-14.3 32-32 0-5.8-1.5-11.2-4.2-15.8 1.4-.1 2.8-.2 4.2-.2 30.9 0 56 25.1 56 56s-25.1 56-56 56-56-25.1-56-56c0-5.7 .8-11.2 2.4-16.4 5.7 5.2 13.3 8.4 21.6 8.4zm224-32c0-5.8-1.5-11.2-4.2-15.8 1.4-.1 2.8-.2 4.2-.2 30.9 0 56 25.1 56 56s-25.1 56-56 56-56-25.1-56-56c0-5.7 .8-11.2 2.4-16.4 5.7 5.2 13.3 8.4 21.6 8.4 17.7 0 32-14.3 32-32z"],
    "envelope-circle-user": [640, 512, [], "e6de", "M96 64l-32 0 0 72 12.8 9.6 224 168 9.1 6.9c21.2-83 96.4-144.5 186.1-144.5 28.6 0 55.6 6.2 80 17.4L576 64 96 64zM272 352l-208-156 0 252 257.4 0c-10.1-22-16.2-46.3-17.2-71.9L272 352zm368 16a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-64.5 78.9C555.2 467.4 527.1 480 496 480s-59.2-12.6-79.5-33.1l15.5-30.9 128 0 15.5 30.9zM448 336a48 48 0 1 1 96 0 48 48 0 1 1 -96 0z"],
    "barn": [576, 512, [], "e6c7", "M80 80l208-80 208 80 56 208-40 0 0 224-448 0 0-224-40 0 56-208zm256 32l-96 0 0 96 96 0 0-96zM192 464L348.5 464 192 320.6 192 464zm35.5-176L384 431.4 384 288 227.5 288z"],
    "map": [512, 512, [128506, 62072], "f279", "M512 64l0-51.8c-19.2 9.6-73.4 36.7-162.5 81.2l-179.4-59.8-12.6-4.2-11.9 5.9-128 64-17.7 8.8 0 391.6c19.2-9.6 73.4-36.7 162.5-81.2l179.4 59.8 12.6 4.2 11.9-5.9 128-64 17.7-8.8 0-339.8zM192 360.9l0-252.5 128 42.7 0 252.5-128-42.7z"],
    "user-plus": [640, 512, [], "f234", "M136 128a120 120 0 1 1 240 0 120 120 0 1 1 -240 0zM400 304l64 208-416 0 64-208 288 0zm120-16l0-72-72 0 0-48 72 0 0-72 48 0 0 72 72 0 0 48-72 0 0 72-48 0z"],
    "turn-down-left": [512, 512, [], "e331", "M0 256l192-192 0 128 192 0 0-128 128 0 0 256-320 0 0 128-192-192z"],
    "plane-engines": [576, 512, [9992, "plane-alt"], "f3de", "M520 200c30.9 0 56 25.1 56 56s-25.1 56-56 56l-127.3 0-66 72 25.3 0 0 64-84 0-44 48-80 0 61.3-184-99.7 0-57.6 72-48 0 32-128-32-128 48 0 57.6 72 99.7 0-61.3-184 80 0 44 48 84 0 0 64-25.3 0 66 72 127.3 0z"],
    "venus": [384, 512, [9792], "f221", "M80 176a112 112 0 1 1 224 0 112 112 0 1 1 -224 0zM224 349.1c81.9-15 144-86.8 144-173.1 0-97.2-78.8-176-176-176S16 78.8 16 176c0 86.3 62.1 158.1 144 173.1l0 66.9-64 0 0 64 64 0 0 64 64 0 0-64 64 0 0-64-64 0 0-66.9z"],
    "user-doctor-message": [576, 512, ["user-md-chat"], "f82e", "M320 0l0 192 64 0 0 80 80-80 112 0 0-192-256 0zM224 8C157.7 8 104 61.7 104 128s53.7 120 120 120c17.1 0 33.3-3.6 48-10l0-220c-14.7-6.4-30.9-10-48-10zm60 359.4l0-47.4-120 0 0 68.4c16.5 7.6 28 24.3 28 43.6 0 26.5-21.5 48-48 48s-48-21.5-48-48c0-19.4 11.5-36.1 28-43.6l0-68.4-44 0-64 192 416 0-64-192-44 0 0 47.4c23.3 8.2 40 30.5 40 56.6l0 52-40 0 0-52c0-11-9-20-20-20s-20 9-20 20l0 52-40 0 0-52c0-26.1 16.7-48.3 40-56.6z"],
    "bars-sort": [448, 512, [], "e0ae", "M0 64l448 0 0 64-448 0 0-64zM0 224l320 0 0 64-320 0 0-64zM192 384l0 64-192 0 0-64 192 0z"],
    "high-definition": [512, 512, ["rectangle-hd"], "e1ae", "M0 64l512 0 0 384-512 0 0-384zm144 96l-48 0 0 192 48 0 0-72 48 0 0 72 48 0 0-192-48 0 0 72-48 0 0-72zm152 0l-24 0 0 192 72 0c39.8 0 72-32.2 72-72l0-48c0-39.8-32.2-72-72-72l-48 0zm48 144l-24 0 0-96 24 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24z"],
    "circle-peseta": [576, 512, [], "e741", "M296 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM208 120l88 0c52 0 95.1 38.2 102.8 88l25.2 0 0 32-25.2 0c-7.7 49.8-50.8 88-102.8 88l-40 0 0 64-48 0 0-152-24 0 0-32 24 0 0-88zm88 48l-40 0 0 40 93.7 0c-6.9-23.1-28.3-40-53.7-40zM256 280l40 0c25.4 0 46.8-16.9 53.7-40l-93.7 0 0 40z"],
    "ditto": [320, 512, [], "22", "M0 32l32 256 64 0 32-256-128 0zm192 0l32 256 64 0 32-256-128 0z"],
    "square-arrow-down-right": [448, 512, [], "e262", "M0 480l448 0 0-448-448 0 0 448zM184 304l54.1 0-103-103-17-17 33.9-33.9 17 17 103 103 0-78.1 48 0 0 160-160 0 0-48 24 0z"],
    "pipe-valve": [512, 512, [], "e439", "M288 32l0 32 96 0 0 64-96 0 0 64 160 0 0-32 64 0 0 320-64 0 0-32-384 0 0 32-64 0 0-320 64 0 0 32 160 0 0-64-96 0 0-64 96 0 0-32 64 0z"],
    "square-s": [448, 512, [], "e27d", "M448 32l-448 0 0 448 448 0 0-448zM202.5 144l93.5 0 0 48-93.5 0c-10.2 0-18.5 8.3-18.5 18.5 0 9.3 6.9 17.2 16.2 18.3l53.6 6.7c33.3 4.2 58.2 32.4 58.2 66 0 36.7-29.8 66.5-66.5 66.5l-101.5 0 0-48 101.5 0c10.2 0 18.5-8.3 18.5-18.5 0-9.3-6.9-17.2-16.2-18.3l-53.6-6.7c-33.3-4.2-58.2-32.4-58.2-66 0-36.7 29.8-66.5 66.5-66.5z"],
    "diagram-successor": [512, 512, [], "e47a", "M305.5 128l70.6 0 0-48-120 0 0 144-224 0 0-192 392 0 0 96 70.6 0c-13.4 13.4-41.2 41.2-83.3 83.3l-11.3 11.3-11.3-11.3c-42.1-42.1-69.9-69.9-83.3-83.3zM480.1 480l-448 0 0-192 448 0 0 192zm-288-320l0-64-96 0 0 64 96 0z"],
    "head-side-cough-slash": [576, 512, [], "e062", "M527-16.9l17-17 33.9 33.9-17 17-512 512-17 17-33.9-33.9C9.3 500.8 20.7 489.4 32.1 478l0-472.8C47.6 1.8 63.7 0 80.1 0 194.5 0 288.8 85.7 302.4 196.4l5.1 6.2 219.4-219.4zM134 512l154.2-154.2 0 154.2-154.2 0zm74.2-320a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm280 96a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm-40 24a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm-64 48a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm128 0a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm-24 120a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm-40-72a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"],
    "arrows-maximize": [448, 512, ["expand-arrows"], "f31d", "M288 32l-32 0 0 64 82.7 0-114.7 114.7-114.7-114.7 82.7 0 0-64-192 0 0 192 64 0 0-82.7 114.7 114.7-114.7 114.7 0-82.7-64 0 0 192 192 0 0-64-82.7 0 114.7-114.7 114.7 114.7-82.7 0 0 64 192 0 0-192-64 0 0 82.7-114.7-114.7 114.7-114.7 0 82.7 64 0 0-192-160 0z"],
    "plus-large": [512, 512, [], "e59e", "M288 32l0-32-64 0 0 224-224 0 0 64 224 0 0 224 64 0 0-224 224 0 0-64-224 0 0-192z"],
    "mug-tea": [576, 512, [], "f875", "M168 64l0 64-40 48 0 112 128 0 0-112-40-48 0-64 232 0c70.7 0 128 57.3 128 128S518.7 320 448 320l0 128-384 0 0-384 104 0zM512 192c0-35.3-28.7-64-64-64l0 128c35.3 0 64-28.7 64-64z"],
    "diagram-project": [512, 512, ["project-diagram"], "f542", "M0 32l192 0 0 64 128 0 0-64 192 0 0 192-192 0 0-64-128 0 0 42.7 64 85.3 128 0 0 192-192 0 0-170.7-64-85.3-128 0 0-192z"],
    "terminal": [576, 512, [], "f120", "M41.6 118.6L19 96 64.3 50.7 86.9 73.4 246.9 233.4 269.5 256 246.9 278.6 86.9 438.6 64.3 461.3 19 416 41.6 393.4 179 256 41.6 118.6zM256.3 384l288 0 0 64-320 0 0-64 32 0z"],
    "eclipse": [640, 512, [], "f749", "M165.6-20.2c10.6 7.1 48.8 32.4 114.4 75.9 65.6-43.5 103.8-68.8 114.4-75.9 4.4 21.6 9.8 48.3 16.2 80.1-39.4 13.9-73.4 39.4-97.8 72.4-10.5-2.8-21.5-4.2-32.8-4.2-70.7 0-128 57.3-128 128s57.3 128 128 128c11.3 0 22.3-1.5 32.8-4.2 24.4 33 58.4 58.5 97.8 72.4-6.4 31.8-11.8 58.5-16.2 80.1-10.6-7.1-48.8-32.4-114.4-75.9-65.6 43.5-103.8 68.8-114.4 75.9-2.5-12.5-11.6-57.4-27.2-134.6-77.2-15.6-122.1-24.7-134.6-27.2 7.1-10.6 32.4-48.8 75.9-114.4-43.5-65.6-68.8-103.8-75.9-114.4 12.5-2.5 57.4-11.6 134.6-27.2 15.6-77.2 24.7-122.1 27.2-134.6zM280 176c2.6 0 5.2 .1 7.8 .4-10.2 24.5-15.8 51.4-15.8 79.6s5.6 55.1 15.8 79.6c-2.6 .2-5.2 .4-7.8 .4-44.2 0-80-35.8-80-80s35.8-80 80-80zM480 96a160 160 0 1 1 0 320 160 160 0 1 1 0-320z"],
    "house-fire": [640, 512, [], "e50c", "M288 464c7.2 17.3 16.7 33.4 28.2 48l-236.2 0 0-240-48 0 0-48 256-240 160.8 150.7-26.2 16.4c-25.4 15.9-61.7 45-92.1 83.2-18.8 23.6-36.9 52.6-47.9 85.7l-58.6 0 0 144 64 0zM448 192l64 64 32-32c76.8 64 96 133.3 96 160 0 88.4-71.6 160-160 160S320 472.4 320 384c0-89.6 85.3-165.3 128-192zm96 240.2c0-48-64-96-64-96s-64 48-64 96c0 35.3 28.7 64 64 64s64-28.7 64-64z"],
    "mask": [576, 512, [], "f6fa", "M288 64C64 64 0 160 0 272S80 448 176 448l48 0 32-96 64 0 32 96 48 0c96 0 176-64 176-176S512 64 288 64zM96 256a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zm320-64a64 64 0 1 1 0 128 64 64 0 1 1 0-128z"],
    "hurricane": [384, 512, [], "f751", "M0 208C0 98.5 84.6 8.8 192 .6L192 96c107.4 8.2 192 97.9 192 207.4S299.4 502.6 192 510.8l0-95.4C84.6 407.2 0 317.5 0 208zm288 48a96 96 0 1 0 -192 0 96 96 0 1 0 192 0zm-96-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "earth-africa": [512, 512, [127757, "globe-africa"], "f57c", "M454 192c-27-83.6-105.4-144-198-144-22.3 0-43.8 3.5-64 10l0 102 32 0 32-32 96 0-64 64-88 0-40 40 0 88 96 0 0 96 48 0 48-48 0-48 32 0 0-64-32-32 0-32 102 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0z"],
    "thumbtack": [384, 512, [128204, 128392, "thumb-tack"], "f08d", "M64 0l-32 0 0 64 61.5 0-10 129.5C33.1 228.1 0 286.2 0 352l384 0c0-65.8-33.1-123.9-83.6-158.5L290.5 64 352 64 352 0 64 0zm96 400l0 144 64 0 0-144-64 0z"],
    "square-up": [448, 512, [11014, "arrow-alt-square-up"], "f353", "M448 32l-448 0 0 448 448 0 0-448zM96 256l0-8 128-128 128 128 0 8-80 0 0 128-96 0 0-128-80 0z"],
    "face-tongue-money": [512, 512, [], "e39d", "M336-16l-48 0 0 18c-22.2-2.8-41.7-2.2-56-.9l0-17.1-136 0 0 36.4c-31 17.1-52 50.1-52 88 0 1.3 0 2.6 .1 3.9-27.8 41-44.1 90.4-44.1 143.7 0 88 44.4 165.6 112 211.7l0-115.7-32 0 0-48 352 0 0 48-32 0 0 115.7c67.6-46.1 112-123.7 112-211.7 0-62.7-22.6-120.2-60-164.7l0-83.3-28 0 0-24-88 0zM184 32l0 24 28 0 0 40-67.5 0c-6.9 0-12.5 5.6-12.5 12.5 0 6.1 4.4 11.3 10.4 12.3l41.7 7c25.3 4.2 43.9 26.1 43.9 51.8 0 26.1-19 47.7-44 51.8l0 24.7-40 0 0-24-44 0 0-40 75.5 0c6.9 0 12.5-5.6 12.5-12.5 0-6.1-4.4-11.3-10.4-12.3l-41.7-7C110.5 156 92 134.1 92 108.5 92 79.7 115.2 56.3 144 56l0-24 40 0zm152 0l40 0 0 24 28 0 0 40-67.5 0c-6.9 0-12.5 5.6-12.5 12.5 0 6.1 4.4 11.3 10.4 12.3l41.7 7c25.3 4.2 43.9 26.1 43.9 51.8 0 26.1-19 47.7-44 51.8l0 24.7-40 0 0-24-44 0 0-40 75.5 0c6.9 0 12.5-5.6 12.5-12.5 0-6.1-4.4-11.3-10.4-12.3l-41.7-7c-25.3-4.2-43.9-26.1-43.9-51.8 0-28.8 23.2-52.2 52-52.5l0-24zm16 320l-192 0 0 128c0 53 43 96 96 96s96-43 96-96l0-128zm-80 48l24 0 0 32-49.5 0c-3.6 0-6.5 2.9-6.5 6.5 0 3 2 5.6 4.9 6.3l30 7.5c17.1 4.3 29.1 19.7 29.1 37.3 0 19-13.8 34.8-32 37.9l0 16.5-32 0 0-16-24 0 0-32 49.5 0c3.6 0 6.5-2.9 6.5-6.5 0-3-2-5.6-4.9-6.3l-30-7.5c-17.1-4.3-29.1-19.7-29.1-37.3 0-19 13.8-34.8 32-37.9l0-16.5 32 0 0 16z"],
    "hand-point-down": [384, 512, [], "f0a7", "M32 512l64 0 0-240-64 0 0 240zM224 352l64 0 0-128-64 0 0 128zm-32 32l0-112-64 0 0 112 64 0zm128-64l64 0 0-128-64 0 0 128zM0 149l0 91 192 0 0-80-112 0 0-32 144 0 0 64 64 0 0-32 96 0C384 71.6 312.4 0 224 0L162.3 0C119.8 0 79.1 16.9 49.1 46.9L37.5 58.5C13.5 82.5 0 115.1 0 149z"],
    "face-meh-blank": [512, 512, [128566, "meh-blank"], "f5a4", "M0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm208-48a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm128 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "bowl-hot": [512, 512, ["soup"], "f823", "M176 8c0 26.5 10.5 38.7 25.9 56.1l.4 .4C218.8 83 240 106.9 240 152l0 24-48 0 0-24c0-26.5-10.5-38.7-25.9-56.1l-.4-.4C149.2 77 128 53.1 128 8l0-24 48 0 0 24zM304 8c0 26.5 10.5 38.7 25.9 56.1l.4 .4C346.8 83 368 106.9 368 152l0 24-48 0 0-24c0-26.5-10.5-38.7-25.9-56.1l-.4-.4C277.2 77 256 53.1 256 8l0-24 48 0 0 24zM3.6 285.2l-3.6-61.2 512 0-3.6 61.2C503.5 368.1 454 438.2 384 472.9l0 39.1-256 0 0-39.1C58 438.2 8.5 368.1 3.6 285.2z"],
    "party-horn": [512, 512, [], "e31b", "M32 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM448 160a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm32 256a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM150.1 136c12.8-12.8 21.2-21.2 25.2-25.2 16.7-16.7 27.2-38.6 29.8-62.1l3-27.4 47.7 5.3-3 27.4c-3.8 34.3-19.2 66.3-43.6 90.7L184 169.9 150.1 136zM359 311l8.2-8.3c24.4-24.4 56.4-39.8 90.7-43.6l27.4-3 5.3 47.7-27.4 3c-23.5 2.6-45.4 13.1-62.1 29.8-4 4-12.5 12.5-25.2 25.2l-33.9-33.9 17-17zM503.5 42.3l-10 8.5c-14.8 12.5-33.7 19.1-53 18.6-16.6-.4-30.6 12.4-31.6 29l-1.8 30c-2.5 42.5-38.3 75.3-80.8 74.2-7.6-.2-15 2.4-20.7 7.3-5.3 4.5-14.8 12.5-28.3 24l-31-36.6c13.6-11.5 23-19.5 28.3-24 14.8-12.5 33.7-19.1 53-18.6 16.6 .4 30.6-12.4 31.6-29l1.8-30c2.5-42.5 38.3-75.3 80.8-74.2 7.6 .2 15-2.4 20.7-7.3l10-8.5 31 36.6zM32 512L0 480 38.5 381.1 130.9 473.5 32 512zm131.5-51.1l-112.4-112.4 23.2-59.6 148.8 148.8-59.6 23.2zM255.7 425L87 256.3 112 192 320 400 255.7 425z"],
    "bells": [640, 512, [], "f77f", "M0 256l229.9 63.4-8.3-31.6c-26.6-101.2 33.7-205.6 134.6-233.1 2.7-.7 5.3-1.4 8-2-16.9-37.7-49.9-67.9-92.6-79.6-75.3-20.6-152.5 23.9-172.3 99.5L76.7 158.4 0 256zm128.2 85.6c2.9 32.7 30.3 58.3 63.8 58.3 18 0 34.2-7.4 45.8-19.3l1.7-8.6-111.3-30.4zM265.2 487.3L640 384 563.3 286.4 540.7 200.5C520.9 125 443.8 80.4 368.4 101S248.1 199.6 267.9 275.1l22.6 85.9-25.3 126.3zm94.9 23.8c10.9 19.6 31.9 32.9 55.9 32.9 35.3 0 64-28.7 64-64 0-.6 0-1.1 0-1.7L360.1 511.1z"],
    "temperature-empty": [320, 512, ["temperature-0", "thermometer-0", "thermometer-empty"], "f2cb", "M64 0l192 0 0 260.7c29.5 26.4 48 64.7 48 107.3 0 79.5-64.5 144-144 144S16 447.5 16 368c0-42.6 18.5-81 48-107.3L64 0zm96 432c35.3 0 64-28.7 64-64s-28.7-64-64-64-64 28.7-64 64 28.7 64 64 64z"],
    "popcorn": [384, 512, [127871], "f819", "M2.7 160c-1.8-5-2.7-10.4-2.7-16 0-26.5 21.5-48 48-48 3.9 0 7.6 .5 11.2 1.3-2.1-5.4-3.2-11.2-3.2-17.3 0-26.5 21.5-48 48-48 12.8 0 24.4 5 33 13.2 5-25.8 27.7-45.2 55-45.2s49.9 19.4 55 45.2c8.6-8.2 20.2-13.2 33-13.2 26.5 0 48 21.5 48 48 0 6.1-1.1 11.9-3.2 17.3 3.6-.9 7.4-1.3 11.2-1.3 26.5 0 48 21.5 48 48 0 5.6-1 11-2.7 16L2.7 160zm259.7 48l-27.6 304-85.6 0-27.6-304 140.9 0zM0 208l73.4 0 27.6 304-69 0-32-304zM283 512l27.6-304 73.4 0-32 304-69 0z"],
    "border-left": [448, 512, [], "f84f", "M0 480l0-448 64 0 0 448-64 0zm128 0l0-64 64 0 0 64-64 0zm0-448l64 0 0 64-64 0 0-64zM256 480l0-64 64 0 0 64-64 0zm0-448l64 0 0 64-64 0 0-64zM384 480l0-64 64 0 0 64-64 0zm0-448l64 0 0 64-64 0 0-64zm0 320l0-64 64 0 0 64-64 0zm0-192l64 0 0 64-64 0 0-64z"],
    "border-none": [448, 512, [], "f850", "M0 416l0 64 64 0 0-64-64 0zM128 32l0 64 64 0 0-64-64 0zM256 416l0 64 64 0 0-64-64 0zM128 480l64 0 0-64-64 0 0 64zM256 32l0 64 64 0 0-64-64 0zM384 480l64 0 0-64-64 0 0 64zm0-384l64 0 0-64-64 0 0 64zM0 32l0 64 64 0 0-64-64 0zM384 352l64 0 0-64-64 0 0 64zM0 160l0 64 64 0 0-64-64 0zM0 352l64 0 0-64-64 0 0 64zM384 160l0 64 64 0 0-64-64 0z"],
    "highlighter": [576, 512, [], "f591", "M314.3 314.3l146.1-203.4-27.1-27.1-203.4 146.1 84.5 84.5zM128 320l0-96 312-224 104 104-224 312-96 0-48 48-96-96 48-48 0 0zM4.7 468.7l54.1-54.1 70.6 70.6-22.1 22.1-4.7 4.7-102.6 0 0-38.6 4.7-4.7z"],
    "pallet-box": [576, 512, [], "e208", "M448 0l0 256-320 0 0-256 320 0zM0 320l576 0 0 64-64 0 0 64 64 0 0 64-576 0 0-64 64 0 0-64-64 0 0-64zM128 448l128 0 0-64-128 0 0 64zm192 0l128 0 0-64-128 0 0 64z"],
    "star-exclamation": [576, 512, [], "f2f3", "M380.8 128.6l201.1 32-143.9 144.1 31.7 201.2-181.5-92.3-181.5 92.3 31.7-201.2-143.9-144.1 201.1-32 92.6-181.4 92.6 181.4zM260.2 308l0 56 56 0 0-56-56 0zm-4-180l12.8 144 38.4 0 12.8-144-64 0z"],
    "sickle": [512, 512, [], "f822", "M224 352l-43-43c-33.9-33.9-53-80-53-128 0-100 81-181 181-181l11 0C426 0 512 86 512 192l-22.7-31.2C463.3 125.1 421.9 104 377.8 104 301.7 104 240 165.7 240 241.8l0 9.8c0 18.8 3.6 37.4 10.6 54.8l5.4 13.6-32 32zM0 448l88-88-24-24 48-48 112 112-48 48-24-24-88 88-64-64z"],
    "money-bill-wave": [512, 512, [], "f53a", "M0 451.7L0 60.3c113.2 50.4 185.6 26.3 258.4 2 71.2-23.7 142.9-47.6 253.6-2l0 391.5c-113.2-50.4-185.6-26.3-258.4-2-71.2 23.7-142.9 47.6-253.6 2zM336 256c0-53-35.8-96-80-96s-80 43-80 96 35.8 96 80 96 80-43 80-96zM64 406c23.3 6.1 44.2 8.2 64 7.4-1.3-34.2-29.5-61.5-64-61.5l0 54zm320.8-47.9c19.8 0 40.9 1.8 63.2 6.1l0-60.3c-32 0-58.5 23.5-63.2 54.2zM448 106c-23.3-6.1-44.2-8.2-64-7.4 1.3 34.2 29.5 61.5 64 61.5l0-54zM64 208c32 0 58.5-23.5 63.2-54.2-19.8 0-40.9-1.8-63.2-6.1L64 208z"],
    "plane-tail": [512, 512, [], "e22c", "M56 0l144 0 235.8 256 76.2 0 0 256-41.8 0c-154.4 0-303.9-53.8-422.9-152.1-4-3.3-9.1-7.5-15.3-12.6L32 256 130.1 256 56 0zM248 336l-24 0 0 48 224 0 0-48-200 0z"],
    "toilet-paper-slash": [576, 512, [], "e072", "M49.3-16.9l-17-17-33.9 33.9 17 17 512 512 17 17 33.9-33.9-17-17-86.6-86.6c40.1-23.1 69.4-96.9 69.4-184.5 0-106-43-192-96-192s-96 86-96 192c0 24 2.2 47 6.2 68.2l-54.2-54.2 0-14c0-58.9 11.8-114.5 33.2-157.2 5.8-11.7 13.1-23.7 21.9-34.8L128.1 32c-8.3 0-16.3 2.1-23.9 6L49.3-16.9zM32.1 224l0 320 272 0 0-170.2-256-256c-10.1 30.4-16 66.9-16 106.2zm416 64c-17.7 0-32-28.7-32-64s14.3-64 32-64 32 28.7 32 64-14.3 64-32 64z"],
    "siren-on": [640, 512, [], "e02e", "M69.3 36l-20-13.3-26.6 39.9c8.6 5.8 31.3 20.9 68 45.3l20 13.3 26.6-39.9-68-45.3zM597.3 76l20-13.3-26.6-39.9c-8.6 5.8-31.3 20.9-68 45.3l-20 13.3 26.6 39.9c8.6-5.8 31.3-20.9 68-45.3zM24 192l-24 0 0 48 112 0 0-48-88 0zm528 0l-24 0 0 48 112 0 0-48-88 0zM176 32l-32 272 68.3 0 19.6-176 48.3 0-.3 2.7-19.3 173.3 235.4 0-32-272-288 0zM544 352l-448 0 0 128 448 0 0-128z"],
    "file-shield": [576, 512, [], "e4f0", "M272 0l-240 0 0 512 266.3 0C261.4 469.2 240 413.9 240 355.2l0-85.8c3.5-1.2 62.2-20.7 176-58.7L416 144 272 0zm85.5 176L240 176 240 58.5 357.5 176zM462 530.8c69.3-30.8 114-99.6 114-175.4l0-51.2-144-48-144 48 0 51.2c0 75.9 44.7 144.6 114 175.4l30 13.3 30-13.3zm-30-39.2l0-184.9 96 32 0 16.6c0 56.9-33.5 108.5-85.5 131.6L432 491.6z"],
    "whiskey-glass-ice": [448, 512, ["glass-whiskey-rocks"], "f7a1", "M32 32L0 32 0 352c0 70.7 57.3 128 128 128l192 0c70.7 0 128-57.3 128-128l0-320-416 0zM64 256l0-160 320 0 0 160-48.3 0 25.5 95.2-216.4 58-41-153.2-39.8 0zm239.5 61.3l-33.1-123.6-123.6 33.1 33.1 123.6 123.6-33.1z"],
    "squid": [512, 512, [129425], "e450", "M396.3 26c33.9-10 72.3-18.8 115.7-26-7.1 42.7-15.7 80.7-25.5 114.2l18.2 115.3 3.5 22.1c-9.9-1.8-34.2-6-72.9-12.9-47.1 81.4-102.8 111.2-147.7 115.8l37.2 37.2c6.2 6.2 16.4 6.2 22.6 0l56.1-56.1c19-19 49.9-18.7 68.6 .7 21.3 22.2 33.6 35 37 38.5l-8.3 10.9-2.5 3.3c-28.3 37-81 40.1-113.6 10.9L370 414.4c-18.7 18.7-49.1 18.7-67.9 0l-45.3-45.3-33.9 33.9 32.6 32.6c19.5 19.5 18.6 51.5-2.1 69.8l-2.8 2.5-21.2-23.9 2.8-2.5c6.9-6.1 7.2-16.8 .7-23.3l-56-56c-1.7 6.5-4.7 12.7-8.8 18.4l-20.1 27.3c-2.5 3.5-3.9 7.6-3.9 11.9 0 11.1 9 20.1 20.1 20.1l27.9 0 0 32-27.9 0c-28.8 0-52.1-23.3-52.1-52.1 0-11.1 3.6-21.9 10.1-30.9l20.1-27.3c6.8-9.2 5.8-22-2.3-30.1-8.2-8.2-21.2-9.1-30.4-2.1l-26.2 20C74.3 396.3 63.2 400 51.9 400 23.2 400 0 376.8 0 348.1l0-28.1 32 0 0 28.1c0 11 8.9 19.9 19.9 19.9 4.4 0 8.6-1.4 12-4.1l26.2-20c5.8-4.4 12.3-7.6 19.1-9.4L53.8 279.2c-6.4-6.4-16.7-6.2-22.9 .3l-3.3 3.5-23.2-22 3.3-3.5c18.6-19.6 49.7-20 68.7-.9l33.4 33.4 33.9-33.9-45.3-45.3c-18.7-18.7-18.7-49.1 0-67.9L113 128.4c-29.4-32.7-26.5-85.5 10.4-114.1 1.2-1 6.1-4.8 14.7-11.4 3.5 3.4 16.5 16.1 39 38.1 19.1 18.7 19.3 49.4 .4 68.3l-56.3 56.3c-6.2 6.2-6.2 16.4 0 22.6l36.3 36.3c4.7-45 34.7-100.8 116.4-147.9-6.7-37.8-10.9-61.7-12.7-71.8L283.4 8.2 396.3 26zM200.9 280a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm32 64a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"],
    "text-height": [640, 512, [], "f034", "M470.9 361.4l-22.6-22.6-45.3 45.3 109.3 109.3 109.3-109.3-45.3-45.3-32 32 0-229.5 32 32 45.3-45.3c-8.2-8.2-37.1-37.1-86.6-86.6L512.3 18.7c-8.2 8.2-37.1 37.1-86.6 86.6l-22.6 22.6 45.3 45.3 32-32 0 229.5-9.4-9.4zM64.3 32l-32 0 0 128 64 0 0-64 64 0 0 320-64 0 0 64 192 0 0-64-64 0 0-320 64 0 0 64 64 0 0-128-288 0z"],
    "money-check-dollar-pen": [640, 512, ["money-check-edit-alt"], "f873", "M544 64l-512 0 0 384 254.9 0 3.8-23.1 88.9-88.9-75.7 0 0-48 123.7 0 115.9-115.9 .5 .5 0-108.6zM304 176l176 0 0 48-176 0 0-48zM200 144l0 24 28 0 0 40-67.5 0c-6.9 0-12.5 5.6-12.5 12.5 0 6.1 4.4 11.3 10.4 12.3l41.7 7c25.3 4.2 43.9 26.1 43.9 51.8 0 26.1-19 47.7-44 51.8l0 24.7-40 0 0-24-44 0 0-40 75.5 0c6.9 0 12.5-5.6 12.5-12.5 0-6.1-4.4-11.3-10.4-12.3l-41.7-7c-25.3-4.2-43.9-26.1-43.9-51.8 0-28.8 23.2-52.2 52-52.5l0-24 40 0zm344 95.9l-52.8 52.8 80 80 52.8-52.8-80-80zm-208 208l-16 96 96-16 132.6-132.6-80-80-132.6 132.6z"],
    "hand-wave": [576, 512, [], "e1a7", "M392 72l0-8c0-22.1-17.9-40-40-40l-32 0 0-48 32 0c48.6 0 88 39.4 88 88l0 32-48 0 0-24zM217.4 70.6l-22.6-22.6 45.3-45.3 22.6 22.6 192 192c3.3 3.3 6.4 6.7 9.4 10.2l0-131.5 80 0 0 216.3c0 60.2-27.9 116.9-75.5 153.7-50.8 39.2-115.5 49.7-173.6 32.7-28.4-7.1-55.3-21.8-77.6-44.1l-4.9-4.9C-20 217.3 106.6 343.8 50.7 288L96 242.7c45.6 45.6 68.4 68.4 110.6 110.6l18.7-18.7-136-136-22.6-22.6 45.3-45.3 22.6 22.6 136 136 18.7-18.7-174.6-174.6 45.3-45.3 22.6 22.6 152 152 18.7-18.7-136-136zM56 352l0 32c0 22.1 17.9 40 40 40l32 0 0 48-32 0c-48.6 0-88-39.4-88-88l0-32 48 0z"],
    "chart-candlestick": [512, 512, [], "e0e2", "M64 32l0 384 448 0 0 64-512 0 0-448 64 0zM344 96l24 0 0 160-24 0 0 64-48 0 0-64-24 0 0-160 24 0 0-64 48 0 0 64zm96 88l0-56 48 0 0 56 24 0 0 128-24 0 0 56-48 0 0-56-24 0 0-128 24 0zM200 120l24 0 0 192-24 0 0 56-48 0 0-56-24 0 0-192 24 0 0-56 48 0 0 56z"],
    "transporter-4": [640, 512, [], "e2a5", "M272-32l-16 0 0 32 128 0 0-32-112 0zm0 64l-16 0 0 32 128 0 0-32-112 0zM240 96l-16 0 0 32 192 0 0-32-176 0zm-32 64l-16 0 0 32 256 0 0-32-240 0zm-32 64l-16 0 0 32 320 0 0-32-304 0zm-16 64l-16 0 0 32 352 0 0-32-336 0zm80 64l-16 0 0 32 192 0 0-32-176 0zm0 64l-16 0 0 32 192 0 0-32-176 0zm240 80l-320 0 0 48 320 0 0-48zM144 400l-48-16-16-48-16 48-48 16 48 16 16 48 16-48 48-16zM576 160l-16-48-16 48-48 16 48 16 16 48 16-48 48-16-48-16z"],
    "pan-food": [640, 512, [129368], "e42b", "M320 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm0-448c39.8 0 72 32.2 72 72l0 8-144 0 0-8c0-39.8 32.2-72 72-72zM244.3 200c-6.5 6.5-21.8 21.8-46.1 46.1l-14.1 14.1-28.3-28.3 46.1-46.1 14.1-14.1 28.3 28.3zM296 224a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM416 360a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM238.6 296l-8 8 16 16 33.4 0c30.9 0 56 25.1 56 56s-25.1 56-56 56-56-25.1-56-56l0-33.4-16-16-8 8-22.6-22.6c32.2-32.2 28.1-28.1 38.6-38.6L238.6 296zM464 176l11 11c13.4 13.4 21 31.6 21 50.6l0 4.8c0 18.7-8.5 36.4-23.1 48.1-10.9 8.7-24.5 13.5-38.5 13.5l-4.1 0c-19.4 0-38-7.7-51.8-21.4L368 272 464 176zM48 160l-48 0 0 192 48 0 0-192zm592 24l0-24-48 0 0 192 48 0 0-168z"],
    "eurozone-sign": [576, 512, [], "e740", "M32.4 64l224 0 0 64-160 0 0 96 144 0 0 64-144 0 0 96 160 0 0 64-224 0 0-384zm272 0l252.9 0-24.6 46.9-143.4 273.1 147.1 0 0 64-252.9 0 24.6-46.9 143.4-273.1-147.1 0 0-64z"],
    "face-grin-tongue": [512, 512, [128539, "grin-tongue"], "f589", "M0 256c0 104.4 62.5 194.2 152.2 234.1-5.3-13-8.2-27.2-8.2-42.1l0-61.7c-23.5-23-39.9-53.2-45.7-87 45.3 18.1 99.5 28.7 157.7 28.7s112.4-10.6 157.7-28.7c-5.8 33.8-22.2 64-45.7 87l0 61.7c0 14.9-2.9 29.1-8.2 42.1 89.7-39.8 152.2-129.6 152.2-234.1 0-141.4-114.6-256-256-256S0 114.6 0 256zm176-80a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm128 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm16 240l0-64-48 0 0 24-32 0 0-24-48 0 0 64c0 35.3 28.7 64 64 64s64-28.7 64-64z"],
    "potato": [512, 512, [129364], "e440", "M43.1 260.9l52.9-52.9 48-80 80-48 36.9-36.9c27.6-27.6 65-43.1 104-43.1 81.2 0 147.1 65.8 147.1 147.1 0 39-15.5 76.4-43.1 104l-4.9 4.9-80 144-112 48-20.9 20.9c-27.6 27.6-65 43.1-104 43.1-81.2 0-147.1-65.8-147.1-147.1 0-39 15.5-76.4 43.1-104zM408 168l-48 0 0 48 48 0 0-48zM216 200l-48 0 0 48 48 0 0-48zM136 392l0 48 48 0 0-48-48 0z"],
    "file-signature": [640, 512, [], "f573", "M64 0l240 0 144 144 0 123.7-132.3 132.3-28.8 0-33.4-66.7-6.6-13.3-42.2 0-7.2 8.8-72 88 37.2 30.4 58.5-71.5c23.5 47 35.5 71 36.1 72.3l29.7 0-10.7 64-212.2 0 0-512zM272 58.5L272 176 389.5 176 272 58.5zM544 239.9l80 80-52.8 52.8-80-80 52.8-52.8zm-208 208l132.6-132.6 80 80-132.6 132.6-96 16 16-96z"],
    "square-dashed": [448, 512, [], "e269", "M32 32l80 0 0 64-48 0 0 48-64 0 0-112 32 0zM0 192l64 0 0 128-64 0 0-128zm384 0l64 0 0 128-64 0 0-128zm64-48l-64 0 0-48-48 0 0-64 112 0 0 112zm0 224l0 112-112 0 0-64 48 0 0-48 64 0zM64 368l0 48 48 0 0 64-112 0 0-112 64 0zM288 480l-128 0 0-64 128 0 0 64zM160 96l0-64 128 0 0 64-128 0z"],
    "steak": [576, 512, [129385], "f824", "M352 384l-256 0 0-95.9 145.2 0 85.7-158.4c11.3-20.8 33-33.8 56.7-33.8 35.6 0 64.4 28.8 64.4 64.4L448 288c0 53-43 96-96 96zm64-192a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm-232 .1L242.5 84.1C270.5 32.3 324.7 0 383.6 0 472.2 0 544 71.8 544 160.4L544 288c0 106-86 192-192 192l-352 0 0-287.9 184 0zM352 416c70.7 0 128-57.3 128-128l0-127.6c0-53.3-43.2-96.4-96.4-96.4-35.4 0-67.9 19.4-84.8 50.5l-76.7 141.6-158.1 0 0 159.9 288 0z"],
    "axe-battle": [512, 512, [], "f6b3", "M176 106.6C134.4 82.6 104.7 40.4 97.6-9.1 38.2 37.7 0 110.4 0 192S38.2 346.3 97.6 393.1c7.1-49.5 36.8-91.7 78.4-115.7l0-170.8zM336 277.4c41.6 24 71.3 66.2 78.4 115.7 49.4-39 84.1-95.7 94.4-160.6L448 192 508.8 151.5c-10.3-64.9-45-121.6-94.4-160.6-7.1 49.5-36.8 91.7-78.4 115.7l0 170.8zM288 32l0-32-64 0 0 544 64 0 0-512z"],
    "circle-quarter-stroke": [512, 512, [], "e5d3", "M64 256l192 0 0-192c106 0 192 86 192 192S362 448 256 448 64 362 64 256zM0 256a256 256 0 1 0 512 0 256 256 0 1 0 -512 0z"],
    "phone-hangup": [640, 512, [], "e225", "M591.9 378.5l45.2-135.8-11.3-11.3C457.1 62.7 183.6 62.7 14.9 231.4l-11.3 11.3 45.3 135.8 158.9-22.1-.5-113.7c73.1-26.5 153.2-26.5 226.3 0l-.5 113.7 158.9 22.1z"],
    "square-heart": [448, 512, [128159, "heart-square"], "f4c8", "M448 32l-448 0 0 448 448 0 0-448zM217.6 199.5l6.4 8.5 6.4-8.5c11.1-14.8 28.5-23.5 46.9-23.5 32.4 0 58.7 26.3 58.7 58.7l0 5.3c0 64-112 128-112 128S112 304 112 240l0-5.3c0-32.4 26.3-58.7 58.7-58.7 18.5 0 35.9 8.7 46.9 23.5z"],
    "conveyor-belt": [640, 512, [], "f46e", "M480 0l0 256-320 0 0-256 320 0zM0 416c0-53 43-96 96-96l448 0c53 0 96 43 96 96s-43 96-96 96L96 512c-53 0-96-43-96-96zm160 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm160 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm224-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "box-check": [448, 512, [], "f467", "M448 128l0 352-448 0 0-352 80-112 288 0 80 112zM281.4 217.9L195.8 335.6c-19.3-20-33.7-34.9-43.2-44.7l-34.5 33.3c6.2 6.4 27.2 28.1 63.1 65.3l19.8 20.6 16.8-23.1 102.4-140.8 14.1-19.4-38.8-28.2-14.1 19.4zM78.7 128l290.7 0-34.3-48-222.1 0-34.3 48z"],
    "blanket-fire": [640, 512, [], "e3da", "M120 32l-24 0 0 448 199.5 0c-7.8-15-13.9-31.1-17.9-48l-133.6 0 0-144 151.9 0c10-20 22.1-38 34.6-53.7 30.4-38.2 66.7-67.3 92.1-83.2l32.4-20.2 55.1 55.1 34-34 0-120-424 0zM272 384l0-.2c0-16.6 2.2-32.6 6-47.8l-86 0 0 48 80 0zM448 192c-42.7 26.7-128 102.4-128 192 0 88.4 71.6 160 160 160s160-71.6 160-160c0-26.7-19.2-96-96-160l-32 32-64-64zm96 240.2c0 35.3-28.7 64-64 64s-64-28.7-64-64c0-48 64-96 64-96s64 48 64 96z"],
    "square-9": [448, 512, [], "e25e", "M448 32l-448 0 0 448 448 0 0-448zM168 368l0-48 72 0c13.3 0 24-10.7 24-24l0-12.1c-7.5 2.7-15.6 4.1-24 4.1l-32 0c-39.8 0-72-32.2-72-72s32.2-72 72-72l32 0c39.8 0 72 32.2 72 72l0 80c0 39.8-32.2 72-72 72l-72 0zm72-176l-32 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l32 0c13.3 0 24-10.7 24-24s-10.7-24-24-24z"],
    "building-wheat": [640, 512, [], "e4db", "M416 0l-384 0 0 512 313.3 0c-6-14.8-9.3-31-9.3-48l0-64 9.3 0c-6-14.8-9.3-31-9.3-48l0-64 9.3 0c-6-14.8-9.3-31-9.3-48l0-64 32 0 0-120 48 0 0-56zM272 352l0 112-96 0 0-112 96 0zM128 96l64 0 0 64-64 0 0-64zm192 0l0 64-64 0 0-64 64 0zM128 224l64 0 0 64-64 0 0-64zm192 0l0 64-64 0 0-64 64 0zm320 0l-32 0c-44.2 0-80 35.8-80 80l0 16 32 0c44.2 0 80-35.8 80-80l0-16zm0 128l0-16-32 0c-44.2 0-80 35.8-80 80l0 16 32 0c44.2 0 80-35.8 80-80zm0 112l0-16-32 0c-44.2 0-80 35.8-80 80l0 16 32 0c44.2 0 80-35.8 80-80zM496 528c0-44.2-35.8-80-80-80l-32 0 0 16c0 44.2 35.8 80 80 80l32 0 0-16zm0-96l0-16c0-44.2-35.8-80-80-80l-32 0 0 16c0 44.2 35.8 80 80 80l32 0zm0-128c0-44.2-35.8-80-80-80l-32 0 0 16c0 44.2 35.8 80 80 80l32 0 0-16zM536 64l-48 0 0 152 48 0 0-152zm72 64l0-24-48 0 0 80 48 0 0-56zM464 104l-48 0 0 80 48 0 0-80z"],
    "plug-circle-minus": [640, 512, [], "e55e", "M224-32l0 128 128 0 0-128 64 0 0 128 96 0 0 64-32 0 0 48.7c-98.6 8.1-176 90.7-176 191.3 0 27.3 5.7 53.3 16 76.9l0 35.1-64 0 0-98.7C165.2 398.1 96 319.1 96 224l0-64-32 0 0-64 96 0 0-128 64 0zM352 400a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm224 16l0-32-160 0 0 32 160 0z"],
    "book-spine": [448, 512, [], "e754", "M0 0l448 0 0 384-32 0 0 64 32 0 0 64-448 0 0-512zM64 416l0 32 288 0 0-64-256 0c-17.7 0-32 14.3-32 32zM64 64l0 261.5c10-3.5 20.8-5.5 32-5.5l64 0 0-256-96 0z"],
    "hockey-sticks": [640, 512, [], "f454", "M528 512l-132.4 0-8.6-18.5-40.6-86.9 40.5-86.7 141.1 0 0 192zm112 0l-64 0 0-192 64 0 0 192zM64 512l-64 0 0-192 64 0 0 192zM490.5-15.5l-13.5 29-224 480-8.6 18.5-132.4 0 0-192 151.3 0 155.7-333.5 13.5-29 58 27.1zM221-13.5l72.5 155.3-35.3 75.7-95.2-203.9-13.5-29 58-27.1 13.5 29z"],
    "down-long-to-line": [384, 512, [], "e6c0", "M0 256l192 192 192-192-128 0 0-320-128 0 0 320-128 0zM64 576l288 0 0-64-320 0 0 64 32 0z"],
    "colon": [128, 512, [], "3a", "M128 64l-128 0 0 128 128 0 0-128zm0 256l-128 0 0 128 128 0 0-128z"],
    "futbol": [512, 512, [9917, "futbol-ball", "soccer-ball"], "f1e3", "M406.2 136.4l-28.5 80.1 70.1 48c-1.6 35.9-13 69.2-31.6 97.4l-85-2.3-24 81.5c-16.3 4.5-33.5 6.9-51.2 6.9s-34.9-2.4-51.2-6.9l-24-81.5-85 2.3c-18.6-28.1-30.1-61.5-31.6-97.4l70.1-48-28.5-80.1c21.5-26.9 50-47.9 82.8-60.2L256 128 323.4 76.2c32.8 12.3 61.3 33.3 82.8 60.2zM256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm0-336l-76.1 55.3 29.1 89.4 94 0 29.1-89.4-76.1-55.3z"],
    "face-hand-over-mouth": [512, 512, [129762], "e378", "M88 442.2C88 444.6 88.1 447 88.2 449.3 34.2 402.4 0 333.2 0 256 0 114.6 114.6 0 256 0S512 114.6 512 256c0 79-35.8 149.7-92.1 196.6L440.6 432c-20.3-20.3-36.3-36.3-48-48l3.7-3.7 28.3-28.3c-41.8-41.8-76.9-76.9-88.6-88.6l-16 16c-11.7-11.7-27.7-27.7-48-48-20.2 20.2-36.4 36.4-48.6 48.6L88 280 88 442.2zM208 192a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm128 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM128 320l48 0 0 64 96-96 32 32-64 64 16 16 80-80 32 32-80 80 16 16 48-48 32 32-82.2 82.2c-19.1 19.1-45 29.8-72 29.8-56.2 0-101.8-45.6-101.8-101.8L128 320z"],
    "circle-plus": [512, 512, ["plus-circle"], "f055", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM232 368l0-88-88 0 0-48 88 0 0-88 48 0 0 88 88 0 0 48-88 0 0 88-48 0z"],
    "coffee-pot": [512, 512, [], "e002", "M32 32l-32 0 0 192 64 0 0-128 53.3 0 27.8 83.3C96 214 64 271.3 64 336l0 8c0 80 72 136 72 136l304 0s72-56 72-136l0-8c0-64.7-32-122-81.1-156.7L480 32 32 32zM194 224l188 0c34.9 19.4 59.8 54.6 65 96l-318 0c5.2-41.4 30.1-76.6 65-96z"],
    "square-question": [448, 512, ["question-square"], "f2fd", "M448 32l-448 0 0 448 448 0 0-448zM224 176c-17.7 0-32 14.3-32 32l-48 0c0-44.2 35.8-80 80-80s80 35.8 80 80c0 35.1-20.5 57.5-38.2 70-6.3 4.4-12.5 7.8-17.8 10.4l0 21.9-48 0 0-56.7c1.4-.4 2.7-.7 4.1-1.1 12.2-3.2 23.3-6.1 34.1-13.7 10.4-7.3 17.8-16.9 17.8-30.8 0-17.7-14.3-32-32-32zM200 344l48 0 0 48-48 0 0-48z"],
    "list-tree": [512, 512, [], "e1d2", "M96 48l-96 0 0 96 24 0 0 296 104 0 0 24 96 0 0-96-96 0 0 24-56 0 0-112 56 0 0 24 96 0 0-96-96 0 0 24-56 0 0-88 24 0 0-96zm64 16l0 64 352 0 0-64-352 0zM288 224l0 64 224 0 0-64-224 0zm0 160l0 64 224 0 0-64-224 0z"],
    "brazilian-real-sign": [512, 512, [], "e46c", "M432 16l0 48 48 0 0 64-80.9 0c-26 0-47.1 21.1-47.1 47.1 0 22.5 15.9 41.8 37.9 46.2l32.8 6.6c51.9 10.4 89.3 56 89.3 109 0 50.6-33.8 93.3-80 106.7l0 52.4-64 0 0-48-64 0 0-64 96.9 0c26 0 47.1-21.1 47.1-47.1 0-22.5-15.9-41.8-37.9-46.2l-32.8-6.6c-51.9-10.4-89.3-56-89.3-109 0-50.6 33.8-93.2 80-106.7l0-52.4 64 0zM0 32l112 0c79.5 0 144 64.5 144 144 0 54.3-30 101.5-74.4 126.1 32.7 108.8 49.4 164.6 50.2 167.4l-61.3 18.4c-.8-2.6-17.6-58.7-50.4-168.1-2.7 .1-5.4 .2-8.1 .2l-48 0 0 160-64 0 0-448zM64 256l48 0c44.2 0 80-35.8 80-80s-35.8-80-80-80l-48 0 0 160z"],
    "book-open-lines": [512, 512, [], "e753", "M256 141.3c16.3-6.8 32.9-13.7 49.7-20.7 39-16.2 80.8-24.6 123.1-24.6l19.2 0 0 320-19.2 0c-59.1 0-117.7 11.7-172.3 34.5l-.5 .2 0-309.3zM512 32l-83.2 0c-50.7 0-100.9 10-147.7 29.5L256 72 230.9 61.5C184.1 42 133.9 32 83.2 32L0 32 0 480 83.2 480c50.7 0 100.9 10 147.7 29.5L256 520 281.1 509.5c46.8-19.5 97-29.5 147.7-29.5l83.2 0 0-448zM304 399.6l21.2-9.4c21-9.3 43.8-14.2 66.8-14.2l24 0 0-48-24 0c-29.7 0-59.1 6.2-86.3 18.3l-1.7 .8 0 52.5zm0-96l21.2-9.4c21-9.3 43.8-14.2 66.8-14.2l24 0 0-48-24 0c-29.7 0-59.1 6.2-86.3 18.3l-1.7 .8 0 52.5zm0-96l21.2-9.4c21-9.3 43.8-14.2 66.8-14.2l24 0 0-48-24 0c-29.7 0-59.1 6.2-86.3 18.3l-1.7 .8 0 52.5zM64 136l24 0c35.4 0 70.5 5.6 104 16.7l0 51-4-1.5c-32-12-65.9-18.1-100-18.1l-24 0 0-48zM192 395.6l-4-1.5c-32-12-65.9-18.1-100-18.1l-24 0 0-48 24 0c35.4 0 70.5 5.6 104 16.7l0 51zm0-96l-4-1.5c-32-12-65.9-18.1-100-18.1l-24 0 0-48 24 0c35.4 0 70.5 5.6 104 16.7l0 51z"],
    "ellipsis-stroke-vertical": [128, 512, ["ellipsis-v-alt"], "f39c", "M80 64l0 32-32 0 0-32 32 0zM48 16l-48 0 0 128 128 0 0-128-80 0zM80 240l0 32-32 0 0-32 32 0zM48 192l-48 0 0 128 128 0 0-128-80 0zm0 224l32 0 0 32-32 0 0-32zM0 368l0 128 128 0 0-128-128 0z"],
    "star-and-crescent": [576, 512, [9770], "f699", "M360.5 48c44.1 0 85 13.7 118.6 37.1-46.9-52.2-114.9-85.1-190.6-85.1-141.4 0-256 114.6-256 256s114.6 256 256 256c75.7 0 143.8-32.9 190.6-85.1-33.6 23.4-74.5 37.1-118.6 37.1-114.9 0-208-93.1-208-208s93.1-208 208-208zm98.3 157.8l-42.3-85.8-42.3 85.8-94.6 13.8 68.5 66.7-16.2 94.2 84.6-44.5 84.6 44.5-16.2-94.2 68.5-66.7-94.6-13.8z"],
    "text-size": [576, 512, [], "f894", "M32 32l-32 0 0 128 64 0 0-64 64 0 0 320-64 0 0 64 192 0 0-64-64 0 0-320 64 0 0 64 64 0 0-128-288 0zM288 224l-32 0 0 128 64 0 0-64 64 0 0 128-64 0 0 64 192 0 0-64-64 0 0-128 64 0 0 64 64 0 0-128-288 0z"],
    "face-surprise": [512, 512, [128558, "surprise"], "f5c2", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM176 176a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm128 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm-48 80a64 64 0 1 1 0 128 64 64 0 1 1 0-128z"],
    "hospital-user": [640, 512, [], "f80d", "M64 0l384 0 0 185.3c-46.9 19-80 65-80 118.7 0 19.8 4.5 38.5 12.5 55.2L313.6 512 64 512 64 0zM208 352l0 112 74.2 0 21.8-49.8 0-62.2-96 0zM280 88l-48 0 0 48-48 0 0 48 48 0 0 48 48 0 0-48 48 0 0-48-48 0 0-48zM416 304a80 80 0 1 1 160 0 80 80 0 1 1 -160 0zM584 416l56 128-288 0 56-128 176 0z"],
    "arrow-down-up-lock": [576, 512, [], "e4b0", "M160 525.3c5.5-5.5 39.7-39.7 102.6-102.6L285.3 400 240 354.7c-14.6 14.6-30.6 30.6-48 48l0-114.7 145 0c4.2-33.9 21.7-63.6 47-83.9l0-94.8c17.4 17.4 33.4 33.4 48 48L477.3 112c-5.5-5.5-39.7-39.7-102.6-102.6L352-13.3c-5.5 5.5-39.7 39.7-102.6 102.6L226.7 112 272 157.3c14.6-14.6 30.6-30.6 48-48l0 114.7-288 0 0 64 96 0 0 114.7c-17.4-17.4-33.4-33.4-48-48L34.7 400c5.5 5.5 39.7 39.7 102.6 102.6L160 525.3zM128 32l0 144 64 0 0-176-64 0 0 32zM464 272c17.7 0 32 14.3 32 32l0 48-64 0 0-48c0-17.7 14.3-32 32-32zm-80 32l0 48-32 0 0 192 224 0 0-192-32 0 0-48c0-44.2-35.8-80-80-80s-80 35.8-80 80z"],
    "folder": [512, 512, [128193, 128447, 61716, "folder-blank"], "f07b", "M0 448l512 0 0-368-224 0-64-48-224 0 0 416z"],
    "holly-berry": [512, 512, [], "f7aa", "M256 96a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm-32 48a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zm160 0a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM112 343.1l-96 10.7 33.8 69.3-17.8 88.9 81.8-39.1 75.5 15.7-13.3-95.7 94.7-9-30.7-73.3 16-86.6-80 36.8-78.6-11.7 14.6 94zm222.7 49.8l-13.3 95.7 75.5-15.7 81.8 39.1-17.8-88.9 33.8-69.3-96-10.7 14.6-94-78.6 11.7-48.8-22.5-12.7 68.7c21.2 50.6 32.8 78.4 34.9 83.3l26.6 2.5z"],
    "message-image": [512, 512, ["comment-alt-image"], "e1e0", "M0 32l0 416 128 0 0 96 160-96 224 0 0-416-512 0zM128 144a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM384 336l-256 0 0-48 128-112 128 112 0 48z"],
    "comment-quote": [512, 512, [], "e14c", "M512 240c0 132.5-114.6 240-256 240-38.3 0-74.7-7.9-107.3-22.1L0 512 55.7 389.5C20.8 348.5 0 296.5 0 240 0 107.5 114.6 0 256 0S512 107.5 512 240zM224 160l-112 0 0 112 64 0 0 8c0 13.3-10.7 24-24 24l-24 0 0 48 24 0c39.8 0 72-32.2 72-72l0-120zM384 272l0-112-112 0 0 112 64 0 0 8c0 13.3-10.7 24-24 24l-24 0 0 48 24 0c39.8 0 72-32.2 72-72l0-8z"],
    "venus-double": [640, 512, [9890], "f226", "M192 288a112 112 0 1 0 0-224 112 112 0 1 0 0 224zM368 176c0 86.3-62.1 158.1-144 173.1l0 66.9 64 0 0 64-64 0 0 64-64 0 0-64-64 0 0-64 64 0 0-66.9C78.1 334.1 16 262.3 16 176 16 78.8 94.8 0 192 0S368 78.8 368 176zM357.5 327c14.4-15.8 26.6-33.7 36.1-53.1 16.1 9 34.7 14.1 54.5 14.1 61.9 0 112-50.1 112-112S509.9 64 448 64c-19.8 0-38.3 5.1-54.5 14.1-9.5-19.4-21.6-37.3-36.1-53.1 26.4-15.9 57.4-25 90.5-25 97.2 0 176 78.8 176 176 0 86.3-62.1 158-144 173.1l0 66.9 64 0 0 64-64 0 0 64-64 0 0-64-64 0 0-64 64 0 0-66.9c-21.1-3.9-40.8-11.5-58.5-22.1z"],
    "elephant": [640, 512, [128024], "f6da", "M122.3 72.6c11.7-9.1 24.5-16.9 38.1-23.2l0 62.6c0 79.5 64.5 144 144 144l16 0 0-32-16 0c-61.9 0-112-50.1-112-112l0-112 112 0c30.5 0 58.2 12.2 78.4 32l1.6 0c88.4 0 160 71.6 160 160l0 119.4c-9.4 5.4-20.3 8.6-32 8.6-20.9 0-39.5-10-51.2-25.6l-25.6 19.2c6.6 8.7 14.6 16.3 23.7 22.4l0 0c6.5 4.3 13.6 7.9 21.1 10.5l0 0c10 3.5 20.8 5.5 32 5.5s22-1.9 32-5.5l0 0c13.9-4.9 26.4-13 36.6-23.4l11.2-11.4 22.9 22.4-11.2 11.4c-16.1 16.4-36.5 28.5-59.4 34.4l0 21.5c0 8 6.5 14.5 14.5 14.5 6.2 0 11.8-4 13.7-9.9l5.4-16.2 60.7 20.2-5.4 16.2c-10.7 32.1-40.7 53.7-74.5 53.7-43.4 0-78.5-35.1-78.5-78.5l0-21.5c-25.2-6.5-47.3-20.4-64-39.3l0 171.3-128 0 0-102c-15.3 3.9-31.4 6-48 6s-32.7-2.1-48-6l0 102-128 0 0-174.9-18.1 40.7-43.9-19.5 29.9-67.3 0-42.9c0-72.2 35.4-136.2 89.9-175.4zM464.4 224a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"],
    "clipboard-question": [384, 512, [], "e4e3", "M320 0l-256 0 0 32-64 0 0 480 384 0 0-480-64 0 0-32zM112 112l0-48 160 0 0 48-160 0zm80 133.2c-17.7 0-32 14.3-32 32l-42.4 0c0-41.1 33.3-74.4 74.4-74.4s74.4 33.3 74.4 74.4c0 33.5-22.8 59-53.2 69.6l0 18.3-42.4 0 0-53.5 3.3-.5c21.1-3 49.9-7.1 49.9-34 0-17.7-14.3-32-32-32zM168 392l48 0 0 48-48 0 0-48z"],
    "hotdog": [576, 512, [127789], "f80f", "M218.5 506.5l37.5 37.5 320-320-37.5-37.5-320 320zM0 288L37.5 325.5 357.5 5.5 320-32 0 288zM488.6 168.6c31.2-31.2 31.2-81.9 0-113.1s-81.9-31.2-113.1 0l-288 288c-31.2 31.2-31.2 81.9 0 113.1s81.9 31.2 113.1 0l288-288z"],
    "arrow-up-from-bracket": [448, 512, [], "e09a", "M246.6 9.4L224-13.3 201.4 9.4 73.4 137.4 50.7 160 96 205.3c6.6-6.6 38.6-38.6 96-96l0 242.7 64 0 0-242.7c57.4 57.4 89.4 89.4 96 96l45.3-45.3-22.6-22.6-128-128zM64 352l0-32-64 0 0 192 448 0 0-192-64 0 0 128-320 0 0-96z"],
    "reply-clock": [640, 512, ["reply-time"], "e239", "M320.3 112a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm160-80l-32 0 0 96 80 0 0-32-48 0 0-64zm-16 272c26.1 0 51-5.2 73.7-14.7 4.1 14.9 6.3 30.5 6.3 46.7 0 128-128 176-128 176s32-32 32-80c0-61.9-50.1-112-112-112l-80 0 0 135.9-239.8-215.9 239.8-215.9 0 135.9 22 0c21.3 82.8 96.5 144 186 144z"],
    "chart-line-up": [512, 512, [], "e0e5", "M64 32l0 384 448 0 0 64-512 0 0-448 64 0zM304 349.3c-6.6-6.6-38.6-38.6-96-96-30.7 30.7-52 52-64 64L98.7 272c8.2-8.2 37.1-37.1 86.6-86.6L208 162.7c6.6 6.6 38.6 38.6 96 96l65.4-65.4-65.4-65.4 176 0 0 176-65.4-65.4C345.1 308.2 308.2 345.1 304 349.3z"],
    "microscope": [512, 512, [128300], "f610", "M288 0l-160 0 0 304 160 0 0-112 32 0c70.7 0 128 57.3 128 128S390.7 448 320 448l-320 0 0 64 512 0 0-64-48.9 0c30.4-34 48.9-78.8 48.9-128 0-106-86-192-192-192l-32 0 0-128zM120 352l-24 0 0 48 224 0 0-48-200 0z"],
    "cat-space": [576, 512, [], "e001", "M400-32c97.2 0 176 78.8 176 176 0 80.6-54.1 148.4-128 169.3l0 198.7-64 0 0-172.8-136 108.8 88 0 0 64-272 0 0-320c0-17.7-14.3-32-32-32l-32 0 0-64 32 0c53 0 96 43 96 96l0 85.8c24.6-37 61.6-64.9 105.2-77.8-5.9-17.6-9.2-36.4-9.2-56 0-97.2 78.8-176 176-176zm96 176c0 53-43 96-96 96s-96-43-96-96l0-84.7c-19.9 22.6-32 52.2-32 84.7 0 70.7 57.3 128 128 128s128-57.3 128-128c0-32.5-12.1-62.1-32-84.7l0 84.7zM368 124a20 20 0 1 0 0 40 20 20 0 1 0 0-40zm64 0a20 20 0 1 0 0 40 20 20 0 1 0 0-40zM147.4 12.5L200 32 147.4 51.4 128 104 108.6 51.4 56 32 108.6 12.5 128-40 147.4 12.5zM400 16c-26.7 0-51.6 8.2-72.1 22.2l44.7 37.2 54.9 0 44.6-37.2C451.5 24.2 426.7 16 400 16z"],
    "circle-exclamation-check": [640, 512, [], "e10d", "M320.3 0c123.7 0 226.9 87.7 250.8 204.3-11.5 15.9-36.9 50.8-76.2 104.8l-29.1-30-103.5 100.1c35.3 36.5 64.8 67.1 88.7 91.7l3.3 3.3c-39 24-84.8 37.8-133.9 37.8-141.4 0-256-114.6-256-256S178.9 0 320.3 0zM638.6 274.7l-14.1 19.4-102.4 140.8-16.8 23.1c-10.1-10.5-29.6-30.6-58.5-60.5l-16.7-17.3 34.5-33.3c10.8 11.1 22.6 23.4 35.4 36.6l85.6-117.7 14.1-19.4 38.8 28.3zM292.3 380l56 0 0-56-56 0 0 56zm8.8-92l38.4 0 12.8-160-64 0 12.8 160z"],
    "cards": [576, 512, [], "e3ed", "M544 512l-320 0 0-6.4 271.3-72.7-98.8-368.9 147.5 0 0 448zM436.6 399L127.5 481.8 11.5 49.1 320.6-33.8 436.6 399zM203.3 318l10.3 38.6 92.4-24.7-10.3-38.7-92.4 24.8zM132.1 216.2c-15.4 26.8-6.3 61 20.5 76.5l4.8 2.5c24.2 11.1 53 3.4 68.6-18.2l9-15 15.3 8.5c25.9 11.6 56.9 2.1 71.4-23.1l2.5-4.8c11.1-24.2 3.4-53-18.1-68.6l-112-65-61.9 107.2z"],
    "cloud": [576, 512, [9729], "f0c2", "M448 480L0 480 0 336c0-62.7 40.1-116 96-135.8L96 176c0-79.5 64.5-144 144-144 55.4 0 103.5 31.3 127.6 77.1 14.2-8.3 30.8-13.1 48.4-13.1 53 0 96 43 96 96l0 49.1c38.3 22.1 64 63.5 64 110.9l0 128-128 0z"],
    "album-circle-plus": [576, 512, [], "e48c", "M32 32l448 0 0 182c-15.3-3.9-31.4-6-48-6-7.8 0-15.4 .5-22.9 1.4-20-65.6-81-113.4-153.1-113.4-88.4 0-160 71.6-160 160 0 83.2 63.5 151.5 144.6 159.3 1.8 23 7.6 44.8 16.8 64.7L32 480 32 32zM256 224a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm176 32a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm16 80l0-16-32 0 0 64-64 0 0 32 64 0 0 64 32 0 0-64 64 0 0-32-64 0 0-48z"],
    "baseball-bat-ball": [640, 512, [], "f432", "M624 80l-240 240-160 80-103 103 17 17-33.9 33.9-81.9-81.9 33.9-33.9 17 17 103-103 80-160 240-240 128 128zM496 544a80 80 0 1 1 0-160 80 80 0 1 1 0 160z"],
    "car-rear": [512, 512, ["car-alt"], "f5de", "M97.3 32l317.4 0 7.5 21.4 48.5 138.6 41.3 0 0 224-32 0 0 64-96 0 0-64-256 0 0 64-96 0 0-64-32 0 0-224 41.3 0 48.5-138.6 7.5-21.4zm272 64l-226.6 0-33.6 96 293.8 0-33.6-96zM320 288l-128 0 0 64 128 0 0-64zM48 256l0 48 80 0 0-48-80 0zm416 0l-80 0 0 48 80 0 0-48z"],
    "windsock": [512, 512, [], "f777", "M64 32l0-32-64 0 0 512 64 0 0-192 64 0 0 48 80-16.7 0-286.7-80-16.7 0 48-64 0 0-64zm64 112l0 128-64 0 0-128 64 0zM256 74.7l0 266.7 112-23.3 0-220-112-23.3zM512 288l0-160-96-20 0 200 96-20z"],
    "face-worried": [512, 512, [], "e3a3", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm-.4-112c-38.7 0-74.5 11.4-103.6 30.6 4.7-53 49.3-94.6 103.6-94.6s98.8 41.6 103.6 94.6C330.1 411.4 294.3 400 255.6 400zM144 272a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm192-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM192 164c-4.2 0-8.4 .3-12.5 .8-20.3 2.7-38.9 11.9-53.8 25.8L111 204.3 83.7 175 98.3 161.4c20.6-19.3 46.8-32.4 75.9-36.2 5.8-.8 11.7-1.2 17.7-1.2l20 0 0 40-20 0zm140.5 .8c-4.1-.5-8.3-.8-12.5-.8l-20 0 0-40 20 0c6 0 11.9 .4 17.7 1.2 29.1 3.8 55.3 17 75.9 36.2l14.6 13.7-27.3 29.2-14.6-13.7c-14.9-13.9-33.5-23.1-53.8-25.8z"],
    "microphone-circle-xmark": [576, 512, [], "e77e", "M320 0l0 148c-48.5 34.9-80 91.7-80 156 0 4.9 .2 9.8 .5 14.6-5.4 .9-10.9 1.4-16.5 1.4-53 0-96-43-96-96L128 0 320 0zM224 368c8.9 0 17.6-.8 26.1-2.4 5.4 15.8 12.7 30.7 21.8 44.3-7.8 2-15.7 3.5-23.9 4.5l0 49.5 72 0 0 48-192 0 0-48 72 0 0-49.5C105.3 402.7 32 321.9 32 224l0-64 48 0 0 64c0 79.5 64.5 144 144 144zM432 160a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm55.3 111.3L498.6 260 476 237.4c-4 4-18.7 18.7-44 44-25.4-25.4-40-40-44-44L365.4 260c4 4 18.6 18.7 44 44-25.4 25.4-40 40-44 44L388 370.6c4-4 18.7-18.6 44-44 25.4 25.4 40 40 44 44L498.6 348c-4-4-18.6-18.7-44-44l32.7-32.7z"],
    "message-lines": [512, 512, ["comment-alt-lines"], "f4a6", "M0 32l0 416 128 0 0 96 160-96 224 0 0-416-512 0zM152 176l232 0 0 48-256 0 0-48 24 0zm0 96l136 0 0 48-160 0 0-48 24 0z"],
    "thumbtack-slash": [576, 512, ["thumb-tack-slash"], "e68f", "M49.3-16.9l-17-17-33.9 33.9 17 17 512 512 17 17 33.9-33.9-17-17-143.1-143.1 62 0c0-65.8-33.1-123.9-83.6-158.5l-10-129.5 61.5 0 0-64-314.2 0 56.3 56.3-4.8 62.9-136.1-136.1zM282.3 352L149.5 219.2c-33 34.5-53.4 81.3-53.4 132.8l186.2 0zM256.1 512l0 32 64 0 0-144-64 0 0 112z"],
    "box-arrow-down": [448, 512, [], "e794", "M335.1 80l-222.1 0-34.3 48 290.7 0-34.3-48zM80 16l288 0 80 112 0 352-448 0 0-352 80-112zM207 401l17 17c2.1-2.1 31.8-31.8 89-89l17-17-33.9-33.9c-9 9-25 25-48 48l0-126.1-48 0 0 126.1c-23-23-39-39-48-48L118.1 312c2.1 2.1 31.8 31.8 89 89z"],
    "plus-minus": [384, 512, [], "e43c", "M224 32l0-32-64 0 0 160-160 0 0 64 160 0 0 160 64 0 0-160 160 0 0-64-160 0 0-128zM0 448l0 64 384 0 0-64-384 0z"],
    "house-circle-check": [640, 512, [], "e509", "M496 208c11.7 0 23.1 1 34.2 3l-242.2-227-256 240 0 48 48 0 0 240 260 0c-10.5-14.6-19-30.7-25.1-48l-90.9 0 0-144 97.4 0c30.3-66.1 97.1-112 174.6-112zM640 400a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-73.6-51.5l-9.4 12.9-64 88-11 15.1c-4.4-4.4-22.1-22.1-53.2-53.2L417.4 400 440 377.4c5 5 17.7 17.7 38.1 38.1l53-72.9 9.4-12.9 25.9 18.8z"],
    "face-woozy": [512, 512, [], "e3a2", "M0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm384-48c0-35.3-21.5-64-48-64s-48 28.7-48 64 21.5 64 48 64 48-28.7 48-64zM213.8 263.3l23.3-5.8-11.6-46.6-87.3 21.8-23.3 5.8 11.6 46.6c8.7-2.2 37.8-9.5 87.3-21.8zm27.5-144.6L214.7 78.7c-.6 .4-39.3 26.2-116 77.3l-20 13.3 26.6 39.9c.6-.4 39.3-26.2 116-77.3l20-13.3zM161 335l-17-17-33.9 33.9c13.3 13.3 20.6 20.6 21.7 21.7 23.6 23.6 59.6 29.4 89.4 14.5 10-5 21.9-3.9 30.8 2.8L280 412c10.4 7.8 23.1 12 36.1 12 19.8 0 38.4-9.8 49.6-26.2 16.2-23.6 28.1-41 35.7-52.1l-39.6-27.1c-7.6 11.1-19.5 28.5-35.7 52.1-2.3 3.3-6 5.3-10 5.3-2.6 0-5.2-.9-7.3-2.4l-27.9-21c-23.5-17.6-54.9-20.4-81.1-7.3-11.3 5.7-25 3.4-34-5.5L161 335z"],
    "crate-apple": [512, 512, ["apple-crate"], "f6b1", "M160 54.9C160 24.6 184.6 0 214.9 0l9.1 0 0 9.1C224 39.4 199.4 64 169.1 64l-9.1 0 0-9.1zm192 0C352 24.6 376.6 0 406.9 0l9.1 0 0 9.1C416 39.4 391.4 64 361.1 64l-9.1 0 0-9.1zM96 80c27.4 0 64 18.3 64 18.3S196.6 80 224 80c43.6 0 64 47.8 64 91.4 0 7-.4 13.9-1.2 20.6L33.2 192c-.8-6.7-1.2-13.5-1.2-20.6 0-43.6 20.4-91.4 64-91.4zm384 91.4c0 7-.4 13.9-1.2 20.6L319 192c.7-6.7 1-13.6 1-20.6 0-26.1-6-55.1-20.3-78.6-2.7-4.4-5.7-8.7-9-12.7 27.1 1.1 61.3 18.2 61.3 18.2S388.6 80 416 80c43.6 0 64 47.8 64 91.4zM0 224l512 0 0 128-512 0 0-128zM0 384l512 0 0 128-512 0 0-128zm80-96a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM64 464a16 16 0 1 0 0-32 16 16 0 1 0 0 32zM464 288a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM448 464a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"],
    "calendar-day": [448, 512, [], "f783", "M160 0l0 64 128 0 0-64 64 0 0 64 96 0 0 416-448 0 0-416 96 0 0-64 64 0zm64 384l0-128-128 0 0 128 128 0z"],
    "circle": [512, 512, [128308, 128309, 128992, 128993, 128994, 128995, 128996, 9679, 9898, 9899, 11044, 61708, 61915], "f111", "M0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0z"],
    "notebook": [512, 512, [], "e201", "M64 0l0 104-64 0 0 48 64 0 0 80-64 0 0 48 64 0 0 80-64 0 0 48 64 0 0 104 112 0 0-512-112 0zM480 0l-256 0 0 512 256 0 0-512z"],
    "octagon-xmark": [512, 512, ["times-octagon", "xmark-octagon"], "f2f0", "M0 160L0 352 160 512 352 512 512 352 512 160 352 0 160 0 0 160zM172.1 305.9L222.1 256c-38.8-38.8-61.1-61.1-66.9-66.9l33.9-33.9 66.9 66.9c38.8-38.8 61.1-61.1 66.9-66.9l33.9 33.9c-5.8 5.8-28.1 28.1-66.9 66.9 38.8 38.8 61.1 61.1 66.9 66.9l-33.9 33.9c-5.8-5.8-28.1-28.1-66.9-66.9-38.8 38.8-61.1 61.1-66.9 66.9l-33.9-33.9 17-17z"],
    "racquet": [576, 512, [], "f45a", "M405.2-15.8c40 1.7 78.8 16.6 108.5 46.3l5.8 6.1c27.7 30.9 40.7 70.3 40.7 110.5l-.3 10.2c-2.7 51-25.8 103-66.7 143.8-54.4 54.4-131.8 78.6-198.2 61.6-29.4-7.5-62.9-5.5-84.3 16l-37.4 37.3 16 16-109.2 109.3-77.2-77.3 109.2-109.3 16 16 37.6-37.6c21.4-21.4 23.5-54.7 16-83.9-3-11.8-4.8-24-5.3-36.2l-.2-8c0-54.2 23.4-110.5 66.9-154S343-16 397.2-16l8 .2zm-8 63.8c-36 0-76.4 15.8-108.8 48.2S240.2 168.9 240.2 205l.4 10.4c2.1 23.9 11.4 45 27.3 60.9 40.4 40.4 120.7 39 180.1-20.5 30.4-30.4 46.2-67.7 48-102l.2-6.8c0-28.2-9.6-53.2-27.7-71.3-15.9-15.9-37-25.2-60.9-27.3L397.2 48z"],
    "mobile-vibrate": [640, 512, [], "e816", "M480.4 512l-320 0 0-512 320 0 0 512zm-224-48l128 0 0-48-128 0 0 48zM130.4 152l-48 48 38.1 38.1 0 35.9-38.1 38.1 48 48-33.9 33.9-81.9-81.9 56-56-56-56 81.9-81.9 33.9 33.9zm496 48l-56 56 56 56-81.9 81.9-33.9-33.9 48-48-38.1-38.1 0-35.9 38.1-38.1-48-48 33.9-33.9 81.9 81.9z"],
    "face-grin-squint": [512, 512, [128518, "grin-squint"], "f585", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm0-184c58.2 0 112.4-10.6 157.7-28.7-13 75.4-78.6 132.7-157.7 132.7S111.3 374.7 98.3 299.3C143.6 317.4 197.8 328 256 328zM127.2 129.7l95.6 48 9.2 4.6 0 20.2-10.2 4.3-95.6 40-14.7-28.3 44.2-27.6-45.3-34 16.8-27.1zm162 48l95.6-48 16.8 27.1-45.3 34 44.2 27.6-14.7 28.3-95.6-40-10.2-4.3 0-20.2 9.2-4.6z"],
    "tree-deciduous": [512, 512, [127795, "tree-alt"], "f400", "M256 0c47.6 0 87 34.6 94.7 80L368 80c53 0 96 43 96 96l0 36.1c29 20.2 48 53.8 48 91.9l0 80-224 28 0 132-64 0 0-132-224-28 0-80c0-38.1 19-71.7 48-91.9L48 176c0-53 43-96 96-96l17.3 0C169 34.6 208.4 0 256 0z"],
    "users-between-lines": [576, 512, [], "e591", "M24 16l552 0 0 48-576 0 0-48 24 0zm0 448l552 0 0 48-576 0 0-48 24 0zM392 192a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm15.9 96l88.1 0 48 128-93.4 0-5.1-15.2-37.6-112.8zm-239.9 0l-37.6 112.8-5.1 15.2-93.4 0 48-128 88.1 0zM72 192a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm152-16a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zm128 96l48 144-224 0 48-144 128 0z"],
    "mango": [512, 512, [], "e30f", "M480 0c0 44.2-35.8 80-80 80l-64 0 0 18.5c99.5 15.6 176 101.7 176 205.5 0 114.9-93.1 208-208 208L0 512 0 384 130.2 188.6c35.7-53.5 94.1-87.3 157.8-92L288 48c0-44.2 35.8-80 80-80l112 0 0 32zM384 296c0 48.6-39.4 88-88 88l0 48c75.1 0 136-60.9 136-136l-48 0z"],
    "crosshairs-simple": [512, 512, [], "e59f", "M445.3 224l-93.3 0 0 64 93.3 0C431.9 368.4 368.4 431.9 288 445.3l0-93.3-64 0 0 93.3C143.6 431.9 80.1 368.4 66.7 288l93.3 0 0-64-93.3 0C80.1 143.6 143.6 80.1 224 66.7l0 7.3c0 39.7 0 68.4 0 86.1l64 0c0-17.7 0-46.3 0-86.1l0-7.3C368.4 80.1 431.9 143.6 445.3 224zM256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512z"],
    "pipe-smoking": [640, 512, [], "e3c4", "M0 224L0 346.4c0 91.5 74.1 165.6 165.6 165.6 56.3 0 108.8-28.6 139.3-76l136.3-212-117.9 0-67.2 96 0-96-256 0zm356.8-48l115.2 0 72-112 96 0 0-64-160 0-123.2 176z"],
    "coconut": [512, 512, [], "e2f6", "M141.6 141.1c-43.7 43.7-73 91.8-85.8 133.3-13.2 42.7-7.4 71.9 7.5 86.7s44 20.6 86.7 7.5c41.5-12.8 89.6-42.1 133.3-85.8s73-91.8 85.8-133.3c13.2-42.7 7.4-71.9-7.5-86.7s-44-20.6-86.7-7.5c-41.5 12.8-89.6 42.1-133.3 85.8zM260.8 9.4C310-5.8 362-4.8 395.6 28.8l41 40.9c48.6 48.6 75.9 114.5 75.9 183.2 0 143.1-116 259-259 259-68.7 0-134.6-27.3-183.2-75.9l-41-41c-33.6-33.6-34.6-85.6-19.4-134.8 15.6-50.4 49.7-105 97.8-153.1S210.4 25 260.8 9.4zm63.5 88.2c25 25-5.4 95.9-67.9 158.4S123 348.9 98 323.9 103.4 228 165.9 165.5 299.3 72.6 324.3 97.6zm95.4 107.1l-11.3-11.3-22.6 22.6c4.1 4.1 18.5 18.5 43.3 43.3l11.3 11.3 22.6-22.6c-4.1-4.1-18.5-18.5-43.3-43.3zm-56 136l-11.3-11.3-22.6 22.6c4.1 4.1 18.5 18.5 43.3 43.3l11.3 11.3 22.6-22.6c-4.1-4.1-18.5-18.5-43.3-43.3zm-136 56l-11.3-11.3-22.6 22.6c4.1 4.1 18.5 18.5 43.3 43.3l11.3 11.3 22.6-22.6c-4.1-4.1-18.5-18.5-43.3-43.3z"],
    "face-diagonal-mouth": [512, 512, [129764], "e47e", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM358.1 335.2l-184 48-23.2 6.1-12.1-46.4 23.2-6.1 184-48 23.2-6.1 12.1 46.4-23.2 6.1zM144 208a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm192-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "star-sharp-half": [576, 512, [], "e28c", "M304.4-32l-85.7 211.9-216.3 0 176.1 136.9-70.5 221.6 196.4-152.7 0-417.7z"],
    "message-waveform": [640, 512, [], "e6e0", "M64 448l0-416 512 0 0 240-48 0 0-32-144 0 0 48-80 0 0 188.8-112 67.2 0-96-128 0zM480 312l0 232-48 0 0-256 48 0 0 24zm80 32l0 168-48 0 0-192 48 0 0 24zM400 360l0 136-48 0 0-160 48 0 0 24zm240 32l0 72-48 0 0-96 48 0 0 24z"],
    "music-magnifying-glass": [640, 512, [], "e662", "M448 208c0 62.7-40.1 116-96 135.8l0 66.6c27.4-6.5 52.7-18.4 74.7-34.5L553.4 502.6 576 525.3 621.3 480 598.6 457.4 472 330.7C497.1 296.3 512 253.9 512 208 512 93.1 418.9 0 304 0 197.3 0 109.3 80.4 97.4 183.9l67.2-12.2C180.7 109.7 237 64 304 64 383.5 64 448 128.5 448 208zM304 223.9l0-28.8-28.3 5.1-176 32-19.7 3.6 0 181.8c-5.9-1.1-11.4-1.6-16-1.6-9.5 0-22.9 2.1-34.9 7.5-11.1 5-29.1 17.2-29.1 40.5s18 35.4 29.1 40.5C41.1 509.9 54.5 512 64 512s22.9-2.1 34.9-7.5c11.1-5 29.1-17.2 29.1-40.5l0-140.1 128-23.3 0 85c-5.9-1.1-11.4-1.6-16-1.6-9.5 0-22.9 2.1-34.9 7.5-11.1 5-29.1 17.2-29.1 40.5s18 35.4 29.1 40.5c11.9 5.4 25.4 7.5 34.9 7.5s22.9-2.1 34.9-7.5c11.1-5 29.1-17.2 29.1-40.5l0-208.1z"],
    "house-medical-circle-xmark": [640, 512, [], "e513", "M80 512l260 0c-21.2-29.5-34.3-65.3-35.9-104l-48.2 0 0-56-56 0 0-64 56 0 0-56 64 0 0 56 20 0c34.9-48.5 91.7-80 156-80 11.7 0 23.1 1 34.2 3L288-16 32 224 32 272 80 272 80 512zm416 32a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm55.3-176.7L518.6 400c25.4 25.3 40 40 44 44L540 466.6c-4-4-18.6-18.6-44-44-25.3 25.4-40 40-44 44L429.4 444c4-4 18.6-18.6 44-44-25.4-25.3-40-40-44-44L452 333.4c4 4 18.6 18.6 44 44 25.3-25.4 40-40 44-44l22.6 22.6-11.3 11.3z"],
    "club": [512, 512, [9827], "f327", "M380 160.1c2.6-10.2 4-21 4-32.1 0-70.7-57.3-128-128-128S128 57.3 128 128c0 11.1 1.4 21.8 4 32.1-1.3 0-2.7-.1-4-.1-70.7 0-128 57.3-128 128S57.3 416 128 416c38.2 0 72.5-16.8 96-43.3l0 75.3-64 0 0 64 192 0 0-64-64 0 0-75.3c23.5 26.6 57.8 43.3 96 43.3 70.7 0 128-57.3 128-128S454.7 160 384 160c-1.4 0-2.7 0-4 .1z"],
    "fire-smoke": [512, 512, [], "f74b", "M96 192c0 16.8 2.6 33 7.4 48.2 2.8-.2 5.7-.2 8.6-.2 12.7 0 25.1 1.5 36.9 4.3 14.1-10.8 30-19.6 47-25.8 14-39.8 60-74.4 60-74.4s46.1 34.6 60 74.4c17.1 6.2 32.9 14.9 47 25.8 11.9-2.8 24.3-4.3 36.9-4.3 2.9 0 5.8 .1 8.6 .2 4.8-15.2 7.4-31.4 7.4-48.2 0-26.7-19.2-96-96-160L288 64 224 0C181.3 26.7 96 102.4 96 192zM256 512l256 0 0-112c0-61.9-50.1-112-112-112-17.3 0-33.7 3.9-48.3 10.9-23.4-26.3-57.6-42.9-95.7-42.9s-72.2 16.6-95.7 42.9c-14.6-7-31-10.9-48.3-10.9-61.9 0-112 50.1-112 112l0 112 256 0z"],
    "table-list": [448, 512, ["th-list"], "f00b", "M0 32l448 0 0 448-448 0 0-448zM64 96l0 64 64 0 0-64-64 0zm320 0l-192 0 0 64 192 0 0-64zM64 224l0 64 64 0 0-64-64 0zm320 0l-192 0 0 64 192 0 0-64zM64 352l0 64 64 0 0-64-64 0zm320 0l-192 0 0 64 192 0 0-64z"],
    "flask-vial": [640, 512, [], "e4f3", "M179.9 429.1l-2.2 5c-14.5 8.8-31.5 13.9-49.7 13.9-53 0-96-43-96-96l0-288-32 0 0-64 256 0 0 64-32 0 0 262.1-44.1 102.9zM96 64l0 128 64 0 0-128-64 0zM378.8 249.2l-30.3 70.8 135 0-30.3-70.8-5.2-12.1 0-173.1-64 0 0 173.1-5.2 12.1zM224 512l0-64 96-224 0-160-32 0 0-64 256 0 0 64-32 0 0 160 96 224 0 64-384 0z"],
    "luchador-mask": [448, 512, ["luchador", "mask-luchador"], "f455", "M224-16C109.1-16 16 77.1 16 192l0 336 416 0 0-336C432 77.1 338.9-16 224-16zM192 144l32 56 32-56 128 0 0 144-120 0 16 32 72 0 0 128-256 0 0-128 72 0 16-32-120 0 0-144 128 0zM104 248l96 0-40-64-56 0 0 64zm240-64l-56 0-40 64 96 0 0-64zM312 360l-176 0 0 48 176 0 0-48z"],
    "circle-exclamation": [512, 512, ["exclamation-circle"], "f06a", "M256 512a256 256 0 1 1 0-512 256 256 0 1 1 0 512zM228 324l0 56 56 0 0-56-56 0zm-4-196l12.8 160 38.4 0 12.8-160-64 0z"],
    "block-brick": [448, 512, ["wall-brick"], "e3db", "M96 32l0 80 256 0 0-80-256 0zM64 112l0-80-64 0 0 80 64 0zM0 144l0 96 208 0 0-96-208 0zM0 368l64 0 0-96-64 0 0 96zm0 32l0 80 208 0 0-80-208 0zm240 0l0 80 208 0 0-80-208 0zm208-32l0-96-64 0 0 96 64 0zm-96 0l0-96-256 0 0 96 256 0zm96-224l-208 0 0 96 208 0 0-96zm0-32l0-80-64 0 0 80 64 0z"],
    "arrow-u-turn-right-up": [576, 512, [], "e7ec", "M573.5 144l-45.3 45.2-80-80 0 210.7c0 102.7-80.7 186.6-182.1 191.8l-9.9 .2c-106 0-192-86-192-192l0-256 64 0 0 256c0 70.7 57.3 128 128 128l6.6-.2c67.6-3.4 121.4-59.4 121.4-127.8l0-210.7-80 80-45.2-45.2 157.2-157.2 157.3 157.2z"],
    "taxi": [512, 512, [128662, "cab"], "f1ba", "M352 0l-192 0 0 64-81 0c-.7 2.9-11.4 45.6-32 128l-47 0 0 288 96 0 0-64 320 0 0 64 96 0 0-288-47 0c-20.6-82.4-31.3-125.1-32-128l-81 0 0-64zm31 128l16 64-286 0 16-64 254 0zM96 272a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm288 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"],
    "text-slash": [576, 512, ["remove-format"], "f87d", "M49.3-16.9l-17-17-33.9 33.9 17 17 512 512 17 17 33.9-33.9-255.3-255.3 45.4-160.7 102.8 0c-3.4 13.6-8.7 34.9-16 64l66 0c2.4-9.5 9.7-39 22.1-88.2l9.9-39.8-418 0c-4.8 19.3-7.3 29.2-7.4 29.6L49.3-16.9zM180.5 114.4l4.6-18.4 116.7 0-30.8 108.9-90.5-90.5zM293 362.7l-51.9-51.9-29.7 105.2-83.3 0 0 64 224 0 0-58.2-5.8-5.8-68.4 0 15.1-53.3z"],
    "people-pulling": [576, 512, [], "e535", "M128 48a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zm10.8 304l29.8 134.1 3.9 23.2 .5 2.7 64.9 0c-1.2-7.1-3.2-19.5-6.2-37.3-.1-.6-.2-1.1-.3-1.7L174.3 216.8c90.7 44.5 140.5 68.9 149.4 73.3 7.1-23.6 14.7-48.5 22.7-74.8 16.6-7.4 28.7-12.7 36.2-16.1l-17 63.6c-5.6 21.1-.1 43.6 14.7 59.7l70.9 77.4c16.9 62 27 99.1 30.4 111.4l61.7-16.8-32.4-118.9-2-7.5-5.2-5.7-52.3-57 18.4-62.4c10.6 21.2 16.8 33.6 18.5 36.9l9.5 4.8 48 24 28.6-57.2-38.5-19.2-35.2-70.5-7-14-15.3-3.1-80-16-10-2c-146.8 65.3-75.8 33.7-94.7 42.1l-4.1 13.6-5.7 17-138.7-68-6.7-3.3-138.5 0 0 224 58.2 0 26.2 157.3 .5 2.7 64.9 0-2.2-13.3-24.5-146.7 15.7 0zM464 96a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM349.7 335.6l-25 62.4c-32.4 32.4-54.4 54.4-66 66l45.3 45.3 75.3-75.3 2.4-6.1 15.7-39.3-40.7-44.4c-2.5-2.7-4.8-5.6-7-8.6z"],
    "backward": [640, 512, [9194], "f04a", "M304 296l0 200-288-240 288-240 0 200 240-200 0 480-240-200z"],
    "spade": [512, 512, [9824], "f2f4", "M347 69.5L256.5-21c-54.1 54.1-126.9 126.9-218.5 218.5-50 50-50 131 0 181s131 50 181 0l5.5-5.5 0 75-64 0 0 64 192 0 0-64-64 0 0-75 5.5 5.5c50 50 131 50 181 0s50-131 0-181L347 69.5z"],
    "dreidel": [576, 512, [], "f792", "M557.5 32l-22.6 22.6-136 136 97.4 97.4-71 71-240-240 71-71 97.4 97.4 136-136 22.6-22.6 45.3 45.3zM151.3 153l240 240-87 87-240 0 0-240 87-87z"],
    "car-burst": [640, 512, ["car-crash"], "f5e1", "M232 8.1l0 24-48 0 0-88 48 0 0 64zM32 168.1l-24 0 0-48 88 0 0 48-64 0zM304.2 81.9L270.2 47.9c23.6-23.6 61.3-61.3 62.2-62.2l33.9 33.9c-23.6 23.6-61.3 61.3-62.2 62.2zM100.5 285.5l-17 17-33.9-33.9c23.6-23.6 61.3-61.3 62.2-62.2l33.9 33.9c-9.4 9.4-24.5 24.5-45.3 45.3zM49.6 19.6L83.5-14.3C107.1 9.3 144.8 47 145.8 47.9L111.8 81.9C88.3 58.3 50.6 20.6 49.6 19.6zM315.9 99.3l21.4 5.7 216.4 58 21.4 5.7 2.1 22.1 12.7 131 34.6 9.3c-40 149.4-46.9 175.2-58 216.4l-77.3-20.7 16.6-61.8-278.2-74.5-16.6 61.8-77.3-20.7c23.5-87.6 42.8-159.7 58-216.4l34.6 9.3 76.5-107.1 12.9-18zM515.8 219.1l-173.5-46.5-49.7 69.5 231.5 62-8.3-85zM255.7 348.1a32 32 0 1 0 16.6-61.8 32 32 0 1 0 -16.6 61.8zm286.5 43.6a32 32 0 1 0 -61.8-16.6 32 32 0 1 0 61.8 16.6z"],
    "comment-minus": [512, 512, [], "f4b1", "M512 240c0 132.5-114.6 240-256 240-38.3 0-74.7-7.9-107.3-22.1L0 512 55.7 389.5C20.8 348.5 0 296.5 0 240 0 107.5 114.6 0 256 0S512 107.5 512 240zM169.6 216l-24 0 0 48 220.8 0 0-48-196.8 0z"],
    "square-f": [448, 512, [], "e270", "M448 32l-448 0 0 448 448 0 0-448zM168 144l136 0 0 48-112 0 0 48 96 0 0 48-96 0 0 80-48 0 0-224 24 0z"],
    "chess-queen-piece": [320, 512, ["chess-queen-alt"], "f446", "M160 22c14.9 0 27-12.1 27-27s-12.1-27-27-27-27 12.1-27 27 12.1 27 27 27zM64 64l-64-16 0 32 72.7 120-24.7 0 0 48 29.6 0-13.6 136-64 80 0 48 320 0 0-48-64-80-13.6-136 29.6 0 0-48-24.7 0 72.7-120 0-32-64 16-48-32-48 32-48-32-48 32z"],
    "turn-left-down": [384, 512, [], "e637", "M192 512l192-192-128 0 0-192 128 0 0-128-256 0 0 320-128 0 192 192z"],
    "link": [576, 512, [128279, "chain"], "f0c1", "M372.7 108.7c14.1-8.3 30.2-12.7 46.8-12.7 51.1 0 92.5 41.4 92.5 92.5 0 24.5-9.7 48-27.1 65.4l-71.1 71.1c-17.3 17.3-40.9 27.1-65.4 27.1-54.6 0-92.7-45.4-92.4-103.9l.1-24.1-64 0-.1 23.9c-.4 84.9 57.9 168.1 156.4 168.1 41.5 0 81.3-16.5 110.6-45.8l71.1-71.1c29.3-29.3 45.8-69.1 45.8-110.6 0-86.4-70-156.5-156.5-156.5-37.3 0-73.1 13.3-101.3 37.2 20.3 10.1 38.7 23.5 54.5 39.5zM162.2 187.1c17.3-17.3 40.9-27.1 65.4-27.1 54.4 0 92.6 45.5 92.4 103.9l-.1 24.1 64 0 .1-23.9c.3-84.7-58.2-168.1-156.4-168.1-41.5 0-81.3 16.5-110.6 45.8L45.8 212.9c-29.3 29.3-45.8 69.1-45.8 110.6 0 86.4 70 156.5 156.5 156.5 37.2 0 73.1-13.3 101.3-37.2-20.3-10.1-38.8-23.5-54.6-39.5-14 8.2-30.1 12.6-46.7 12.6-51.1 0-92.5-41.4-92.5-92.5 0-24.5 9.7-48 27.1-65.4l71.1-71.1z"],
    "chart-line-down": [512, 512, [128201], "f64d", "M64 32l0 384 448 0 0 64-512 0 0-448 64 0zM414.6 209.4l65.4-65.4 0 176-176 0 65.4-65.4-65.4-65.4c-57.4 57.4-89.4 89.4-96 96-8.2-8.2-37.1-37.1-86.6-86.6L98.7 176 144 130.7c12 12 33.3 33.3 64 64 57.4-57.4 89.4-89.4 96-96 4.2 4.2 41.1 41.1 110.6 110.6z"],
    "backward-step": [384, 512, ["step-backward"], "f048", "M64 296l0 184-64 0 0-448 64 0 0 184 320-200 0 480-320-200z"],
    "clock-one": [512, 512, [], "e34e", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm24-392l0 56.7c14.5-21.7 25.6-38.4 33.3-50l39.9 26.6-13.3 20-64 96-44-13.3 0-160 48 0 0 24z"],
    "dice-d4": [576, 512, [], "f6d0", "M576 320L288 544 0 320 288-32 576 320zM268 93.5l0 353.8 20 15.6 20-15.6 0-353.8-20-24.4-20 24.4z"],
    "x": [384, 512, [120], "58", "M306.3 32l77.5 0-1.4 2-151.5 222 151.5 222 1.4 2-77.5 0-114.2-167.2-114.2 167.2-77.5 0 1.4-2 151.5-222-151.5-222-1.4-2 77.5 0 114.2 167.2 114.2-167.2z"],
    "circle-user": [512, 512, [62142, "user-circle"], "f2bd", "M391.9 391.6l-23.9-71.6-224 0-23.9 71.6C154.9 426.5 202.9 448 256 448s101.1-21.5 135.9-56.4zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm256 16a72 72 0 1 0 0-144 72 72 0 1 0 0 144z"],
    "rectangle-list": [512, 512, ["list-alt"], "f022", "M512 64l-512 0 0 384 512 0 0-384zM160 320a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm-32-96a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm120-56l168 0 0 48-192 0 0-48 24 0zm0 128l168 0 0 48-192 0 0-48 24 0z"],
    "circle-wifi": [512, 512, [], "e67d", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM399.5 256.5C364.4 216.9 313.1 192 256 192s-108.4 24.9-143.5 64.5l-34-34C122.4 174.3 185.7 144 256 144s133.6 30.3 177.5 78.5l-34 34zm-36.1 36.1l-34.4 34.4C313.3 303.4 286.4 288 256 288s-57.3 15.4-73.1 38.9l-34.4-34.4c24.9-32 63.7-52.6 107.4-52.6s82.5 20.6 107.4 52.6zM224 368a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"],
    "hand": [512, 512, [129306, 9995, "hand-paper"], "f256", "M288.2 32l0-32-64 0 0 256-32 0 0-224-64 0 0 304c0 1.5 0 3.1 .1 4.6-31.5-30-55.7-53-72.6-69.1L.5 329.4c8.2 7.8 49.7 47.4 124.5 118.6 43.1 41.1 100.4 64 160 64l19.2 0c97.2 0 176-78.8 176-176l0-240-64 0 0 160-32 0 0-224-64 0 0 224-32 0 0-224z"],
    "lasso-sparkles": [640, 512, [], "e1c9", "M368-40L341.3 21.3 280 48 341.3 74.7 368 136 394.7 74.7 456 48 394.7 21.3 368-40zM184.3 58.7c-16.5 7.1-31.7 15.4-45.3 24.8-46.4 31.9-75 75.9-75 124.5s28.6 92.6 75 124.4c5.5 3.8 11.2 7.4 17.1 10.8l49.1 30.7c11.7 7.3 18.8 20.2 18.8 34 0 22.1-17.9 40.1-40.1 40.1l-5.6 0c-7.1 0-14.1-1.7-20.4-4.8-34.9-17.5-60.3-30.2-76.2-38.1L53.1 462.3c15.9 8 41.3 20.7 76.2 38.1 15.2 7.6 32 11.6 49 11.6l5.6 0c57.5 0 104.1-46.6 104.1-104.1 0-8.7-1.1-17.3-3.2-25.6 11.5 1.1 23.2 1.7 35.2 1.7 141.3 0 256.1-78.9 256-176 0-48.5-28.6-92.6-75-124.5-.8-.6-1.7-1.1-2.5-1.7-12.2 5.3-34.6 15-67.4 29.3l-2.5 5.7c13.4 5.7 25.5 12.2 36.1 19.5 34.6 23.8 47.2 50.2 47.2 71.7s-12.7 47.9-47.2 71.7c-34.4 23.6-85.4 40.3-144.8 40.3-52 0-97.5-12.7-131.1-31.8l-14.2-8.9c-34.2-23.7-46.7-49.9-46.7-71.3 0-21.5 12.7-47.9 47.2-71.7 25.7-17.7 60.8-31.5 101.7-37.3-.6-.3-31.5-13.7-92.6-40.3zm317 378.6L440 464 501.3 490.7 528 552 554.7 490.7 616 464 554.7 437.3 528 376 501.3 437.3z"],
    "arrow-up-from-square": [448, 512, [], "e09c", "M256 288l0-210.7 32 32 45.3-45.3c-8.2-8.2-37.1-37.1-86.6-86.6L224-45.3c-8.2 8.2-37.1 37.1-86.6 86.6L114.7 64 160 109.3c17.3-17.3 28-28 32-32l0 242.7 64 0 0-32zM32 128l-32 0 0 384 448 0 0-384-128 0 0 64 64 0 0 256-320 0 0-256 64 0 0-64-96 0z"],
    "circle-r": [512, 512, [], "e120", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM176 144l104 0c39.8 0 72 32.2 72 72 0 29.5-17.7 54.8-43.1 66l40.2 74.7 6.1 11.4-54.5 0-43.1-80-33.7 0 0 80-48 0 0-224zM318 400l1.2 0-.9 .5-.3-.5zM224 240l56 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-56 0 0 48z"],
    "polish-zloty-sign": [448, 512, [], "e70b", "M384.1 32l0 162.4c15.9-6 31.2-11.7 46-17.3L447 222c-12 4.5-33 12.4-62.9 23.6l0 234.4-64 0 0-210.4c-15.9 6-31.2 11.7-46 17.3L257.2 242c12-4.5 33-12.4 62.9-23.6l0-186.4 64 0zM32.1 192l199.1 0c-6 10.5-48.7 85.2-128 224l120.9 0 0 64-231.1 0c6-10.5 48.7-85.2 128-224l-120.9 0 0-64 32 0z"],
    "phone-connection": [640, 512, [], "e6e1", "M591.5 81l-96-96 33.9-33.9 96 96-33.9 33.9zM64.4 64l128-64 96.8 128-80.8 80c33 70.4 89.6 127 160 160l80-80.8 128 96.8-64 128-16 0c-238.6 0-432-193.4-432-432l0-16zm303.1 49l33.9-33.9 96 96-33.9 33.9-96-96zm93-33a36 36 0 1 1 72 0 36 36 0 1 1 -72 0zm-92 92a36 36 0 1 1 0 72 36 36 0 1 1 0-72z"],
    "snooze": [448, 512, [128164, "zzz"], "f880", "M192 0l-32 0 0 64 65.3 0-57.6 67.2-7.7 9 0 51.8 160 0 0-64-65.3 0 57.6-67.2 7.7-9 0-51.8-128 0zM320 224l-32 0 0 64 65.3 0-57.6 67.2-7.7 9 0 51.8 160 0 0-64-65.3 0 57.6-67.2 7.7-9 0-51.8-128 0zM32 256l-32 0 0 64 130.7 0-121.4 121.4-9.4 9.4 0 61.3 224 0 0-64-130.7 0 121.4-121.4 9.4-9.4 0-61.3-192 0z"],
    "user-doctor-hair-mullet": [448, 512, [], "e7ad", "M144 144l0-32 64 0 16-48 16 48 64 0 0 32c0 44.2-35.8 80-80 80s-80-35.8-80-80zm208 0l0-32 16 0 0-48-26.8 0C323.2 26.2 284.7 0 240 0L208 0c-44.7 0-83.2 26.2-101.2 64l-26.8 0 0 48 16 0 0 32c0 25.1 7.3 48.6 19.8 68.4L80 272 368 272 332.2 212.4C344.7 192.6 352 169.1 352 144zM284 367.4l0-47.4-120 0 0 68.4c16.5 7.6 28 24.3 28 43.6 0 26.5-21.5 48-48 48s-48-21.5-48-48c0-19.4 11.5-36.1 28-43.6l0-68.4-44 0-64 192 416 0-64-192-44 0 0 47.4c23.3 8.2 40 30.5 40 56.6l0 52-40 0 0-52c0-11-9-20-20-20s-20 9-20 20l0 52-40 0 0-52c0-26.1 16.7-48.3 40-56.6z"],
    "pan-frying": [576, 512, [127859], "e42c", "M448 224c0 33.4-7.3 65.1-20.4 93.6L567.9 408.2 487.2 512 364.8 398.3C326.3 429.4 277.3 448 224 448 100.3 448 0 347.7 0 224S100.3 0 224 0 448 100.3 448 224zM319.9 154c-21.2-5.4-50.6-22.6-65.8-38.4-24.5-25.5-65-26.3-90.5-1.8-11.6 11.2-18.1 25.6-19.4 40.5-2.2 24.7-9.2 56.2-21.5 77.6-22.1 38.3-9 87.2 29.3 109.3s87.2 9 109.3-29.3c9.4-16.3 33-30 51.6-32.6 10.2-1.4 20.3-5.4 29.2-12 28.4-21.1 34.3-61.1 13.3-89.5-9.1-12.3-21.8-20.4-35.5-23.9zM504 424a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM224 176a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"],
    "van-shuttle": [576, 512, [128656, "shuttle-van"], "f5b6", "M32 64l-32 0 0 336 64.4 0c4 44.9 41.7 80 87.6 80s83.6-35.1 87.6-80l104.7 0c4 44.9 41.7 80 87.6 80s83.6-35.1 87.6-80l56.4 0 0-186.7-6.4-8.5-96-128-9.6-12.8-432 0zM504 224l-120 0 0-96 48 0 72 96zM64 224l0-96 96 0 0 96-96 0zm160 0l0-96 96 0 0 96-96 0zM392 392a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zM152 352a40 40 0 1 1 0 80 40 40 0 1 1 0-80z"],
    "stairs": [576, 512, [], "e289", "M384 32l192 0 0 64-128 0 0 128-128 0 0 128-128 0 0 128-192 0 0-64 128 0 0-128 128 0 0-128 128 0 0-128z"],
    "shuttlecock": [512, 512, [], "f45b", "M262.9 424.3l-33.2 29.2C181.7 495.4 109.5 493 64.5 448S17.1 330.8 59 282.8l29.1-33.3 174.8 174.8zM288.5 64l-64 160 112-144 80 16 16 80-144 112 160-64 64 32 0 32-207.4 110.6-191.2-191.2 110.7-207.4 32 0 32 64z"],
    "coin-vertical": [384, 512, [], "e3fd", "M240 512l-96 0C64.5 512 0 397.4 0 256S64.5 0 144 0l96 0c29.1 0 55.9 19.4 77.3 52L231 52c8.7 11.7 16.6 25.1 23.6 40l83.7 0c9.8 23.5 17.5 50.5 22.7 80l-80.9 0c2.5 12.9 4.5 26.3 5.8 40l80.2 0c1.2 14.3 1.9 29 1.9 44s-.6 29.7-1.9 44l-80.2 0c-1.3 13.7-3.3 27.1-5.8 40l80.9 0c-5.1 29.5-12.9 56.5-22.7 80l-83.7 0c-7 14.9-14.9 28.3-23.6 40l86.3 0c-21.5 32.6-48.3 52-77.3 52zm-96-64c53 0 96-86 96-192s-43-192-96-192-96 86-96 192 43 192 96 192zm0-48c-35.3 0-64-64.5-64-144s28.7-144 64-144 64 64.5 64 144-28.7 144-64 144z"],
    "circle-turkish-lira": [512, 512, [], "e739", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM240 128l0 68.5c46.6-15.5 71.3-23.8 74.1-24.7l10.1 30.4c-1.1 .4-29.2 9.7-84.2 28.1l0 30.3c46.6-15.5 71.3-23.8 74.1-24.7l10.1 30.4c-1.1 .4-29.2 9.7-84.2 28.1l0 41.8 48 0c26.5 0 48-21.5 48-48l0-24 48 0 0 24c0 53-43 96-96 96l-96 0 0-73.8c-19.9 6.6-34 11.3-42.1 14l-10.1-30.4c6.5-2.2 23.9-8 52.2-17.4l0-30.3c-19.9 6.6-34 11.3-42.1 14l-10.1-30.4c6.5-2.2 23.9-8 52.2-17.4l0-84.5 48 0z"],
    "sheep": [640, 512, [128017], "f711", "M576 135.8c8.4 3.6 20.6 8.8 36.6 15.7l18.9-44.1c-9.2-3.9-34.9-15-77.2-33.1L512 32 448 32 405.7 74.3c-42.3 18.1-68 29.2-77.2 33.1l18.9 44.1c16-6.8 28.2-12.1 36.6-15.7l0 152.2 192 0 0-152.2zM464 128a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm48 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM286.5 90.6l15.8-6.8c-11.7-12.2-28.1-19.8-46.3-19.8-19.2 0-36.5 8.5-48.2 21.9-10.9-8.7-24.8-13.9-39.8-13.9-30.1 0-55.3 20.8-62.2 48.8-3.2-.5-6.5-.8-9.8-.8-35.3 0-64 28.7-64 64 0 5.3 .7 10.5 1.9 15.5-20.2 10.8-33.9 32-33.9 56.5s13.7 45.7 33.9 56.5c-1.2 5-1.9 10.2-1.9 15.5 0 35.3 28.7 64 64 64 .5 0 1 0 1.5 0l22.5 120 88 0 0-85.7c11.7 13.3 28.9 21.7 48 21.7s36.3-8.4 48-21.7l0 85.7 88 0 22.5-120c.5 0 1 0 1.5 0 35.3 0 64-28.7 64-64 0-2.7-.2-5.4-.5-8l-127.5 0 0-135.6-21.4 9.2-44.1-102.9z"],
    "horse-head": [512, 512, [], "f7ab", "M0 512L0 319.2c0-109.5 69.7-207 173.4-242.3l178.6-60.9 32 48-48 32 104 64 72 192-64 64-80 0-58.6-70.4c-11.6 4.1-24.1 6.4-37.1 6.4l-.2 0c-6.3 0-12.5-.5-18.6-1.5-3.6-.6-7.2-1.4-10.7-2.3l0 0c-28.9-7.8-53.1-26.8-67.8-52.2l-8-13.8-27.7 16 8 13.8c24 41.5 68.3 70 119.3 71.9L352 512 0 512zM328 224a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"],
    "circle-calendar": [512, 512, ["calendar-circle"], "e102", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM224 112l0 32 64 0 0-32 40 0 0 32 56 0 0 64-256 0 0-64 56 0 0-32 40 0zM128 384l0-128 256 0 0 128-256 0z"],
    "vault": [512, 512, [], "e2c5", "M512 32l-512 0 0 448 64 0 0 32 64 0 0-32 256 0 0 32 64 0 0-32 64 0 0-448zM192 320a64 64 0 1 0 0-128 64 64 0 1 0 0 128zm0-192a128 128 0 1 1 0 256 128 128 0 1 1 0-256zM424 249.6l0 102.4-48 0 0-102.4c-14.3-8.3-24-23.8-24-41.6 0-26.5 21.5-48 48-48s48 21.5 48 48c0 17.8-9.7 33.3-24 41.6z"],
    "closed-captioning-slash": [576, 512, [], "e135", "M32.3-33.8C33-33.2 65.6-.6 130.2 64l414 0 0 384-30 0c36.4 36.4 57.8 57.8 64.1 64.1l-33.9 33.9-17-17-512-512-17-17 33.9-33.9zM352.1 286l0-70c0-4.4 3.6-8 8-8l32 0c4.4 0 8 3.6 8 8l0 24 48 0 0-24c0-30.9-25.1-56-56-56l-32 0c-30.9 0-56 25.1-56 56l0 22 48 48zm61.7 61.7c20.2-8.5 34.3-28.4 34.3-51.6l0-24-48 0 0 24c0 4.4-3.6 8-8 8l-22 0 43.6 43.6zM378.3 448l-346.2 0 0-346.2 98.3 98.3c-1.5 5-2.3 10.4-2.3 15.9l0 80c0 30.9 25.1 56 56 56l32 0c18.1 0 34.1-8.5 44.4-21.8L378.3 448zM176.1 245.8l48 48 0 2.2c0 4.4-3.6 8-8 8l-32 0c-4.4 0-8-3.6-8-8l0-50.2z"],
    "drum-steelpan": [576, 512, [], "f56a", "M473 209.8c-22.2 9.4-49.7 17-81 22.2L353.9 176 411.2 91.7c23.4 4.9 44.2 11.2 61.7 18.6 47.1 19.9 55 39.9 55 49.8s-8 29.9-55 49.8zM340.7 238.1c-16.9 1.3-34.5 1.9-52.7 1.9s-35.8-.7-52.7-1.9l14.6-46.1 76.2 0 14.6 46.1zm-156.6-6.1c-31.4-5.2-58.8-12.8-81-22.2-47.1-19.9-55-39.9-55-49.8s8-29.9 55-49.8c17.5-7.4 38.3-13.7 61.7-18.6l57.4 84.3-38 55.9zM225.5 82.8C245.3 81 266.2 80 288 80s42.7 1 62.5 2.8l-24.4 77.2-76.2 0-24.4-77.2zM576 160C576 80 447.1 32 288 32S0 80 0 160L0 352c0 80 128.9 128 288 128s288-48 288-128l0-192z"],
    "thumbs-up": [512, 512, [128077, 61575], "f164", "M160 160l80-144 96 48-48 96 208 0 0 112-16 0 0 80-16 0 0 64-32 0 0 64-176 0-96-64 0-256zm-48 0l0 320-112 0 0-320 112 0z"],
    "engine": [576, 512, [], "e16e", "M376 80l24 0 0-48-224 0 0 48 88 0 0 48-168 0 0 104-32 0 0-104-48 0 0 256 48 0 0-104 32 0 0 104 85.3 0 42.7 64 224 0 0-320-136 0 0-48 64 0zm120 80l0 256 48 0 0-256-48 0zM328 240l-136 0 0-48 160 0 0 48-24 0z"],
    "user-alien": [448, 512, [], "e04a", "M64 167C64 74.8 135.6 0 224 0S384 74.8 384 167l0 89-160 128-160-128 0-89zm80 9l-32 0 0 16c0 35.3 28.7 64 64 64l32 0 0-16c0-35.3-28.7-64-64-64zm96 64l0 16 32 0c35.3 0 64-28.7 64-64l0-16-32 0c-35.3 0-64 28.7-64 64zM80 352l27.2 0c67.4 53.9 106.3 85.1 116.8 93.5 10.5-8.4 49.5-39.6 116.8-93.5l27.2 0 64 160-416 0 64-160z"],
    "rectangle-history": [512, 512, [], "e4a2", "M512 480l0-272-512 0 0 272 512 0zM464 104l-416 0 0 48 416 0 0-48zM416 0l-320 0 0 48 320 0 0-48z"],
    "rectangle-minus": [512, 512, [], "e6b4", "M512 64l-512 0 0 384 512 0 0-384zM168 232l200 0 0 48-224 0 0-48 24 0z"],
    "stamp": [512, 512, [], "f5bf", "M320 167.6c19.6-17.6 32-43.1 32-71.6 0-53-43-96-96-96s-96 43-96 96c0 28.4 12.4 54 32 71.6l0 88.4-80 0C50.1 256 0 306.1 0 368l0 48 512 0 0-48c0-61.9-50.1-112-112-112l-80 0 0-88.4zM56 464l-24 0 0 48 448 0 0-48-424 0z"],
    "triple-chevrons-up": [384, 512, [], "e7fa", "M365.5 512l-45.3 45.3-128-128-128 128-45.3-45.3 173.2-173.2 173.3 173.2zm0-192l-45.3 45.3-128-128-128 128-45.3-45.3 173.2-173.2 173.3 173.2zm0-192l-45.3 45.3-128-128-128 128-45.3-45.3 173.2-173.2 173.3 173.2z"],
    "menorah": [640, 512, [], "f676", "M32 0L59.8 48.7C62.6 53.5 64 58.9 64 64.4 64 81.8 49.8 96 32.4 96l-.8 0C14.2 96 0 81.8 0 64.4 0 58.9 1.4 53.5 4.2 48.7L32 0zm96 0l27.8 48.7c2.7 4.8 4.2 10.2 4.2 15.7 0 17.5-14.2 31.6-31.6 31.6l-.8 0c-17.5 0-31.6-14.2-31.6-31.6 0-5.5 1.4-10.9 4.2-15.7L128 0zm68.2 48.7L224 0 251.8 48.7c2.7 4.8 4.2 10.2 4.2 15.7 0 17.5-14.2 31.6-31.6 31.6l-.8 0c-17.5 0-31.6-14.2-31.6-31.6 0-5.5 1.4-10.9 4.2-15.7zM320 0l27.8 48.7c2.7 4.8 4.2 10.2 4.2 15.7 0 17.5-14.2 31.6-31.6 31.6l-.8 0c-17.5 0-31.6-14.2-31.6-31.6 0-5.5 1.4-10.9 4.2-15.7L320 0zm68.2 48.7L416 0 443.8 48.7c2.7 4.8 4.2 10.2 4.2 15.7 0 17.5-14.2 31.6-31.6 31.6l-.8 0c-17.5 0-31.6-14.2-31.6-31.6 0-5.5 1.4-10.9 4.2-15.7zM512 0l27.8 48.7c2.7 4.8 4.2 10.2 4.2 15.7 0 17.5-14.2 31.6-31.6 31.6l-.8 0c-17.5 0-31.6-14.2-31.6-31.6 0-5.5 1.4-10.9 4.2-15.7L512 0zm68.2 48.7L608 0 635.8 48.7c2.7 4.8 4.2 10.2 4.2 15.7 0 17.5-14.2 31.6-31.6 31.6l-.8 0c-17.5 0-31.6-14.2-31.6-31.6 0-5.5 1.4-10.9 4.2-15.7zM64 128l0 192 224 0 0-192 64 0 0 192 224 0 0-192 64 0 0 256-288 0 0 64 160 0 0 64-384 0 0-64 160 0 0-64-288 0 0-256 64 0zm96 0l0 160-64 0 0-160 64 0zm96 0l0 160-64 0 0-160 64 0zm192 0l0 160-64 0 0-160 64 0zm96 0l0 160-64 0 0-160 64 0z"],
    "turn-left": [512, 512, [], "e636", "M0 256l192 192 0-128 192 0 0 128 128 0 0-256-320 0 0-128-192 192z"],
    "square-won": [448, 512, [], "e709", "M448 32l-448 0 0 448 448 0 0-448zM200.1 128l47.7 0 4.1 18.8 20.5 93.2 18.7 0c23.8-69.4 36.4-106.2 37.9-110.5l45.4 15.6c-2.4 6.9-13.2 38.5-32.5 94.9l26.1 0 0 32-37 0-32.8 95.8-5.6 16.2-37.6 0-4.1-18.8-20.5-93.1-12.7 0c-16.4 74.5-24.6 111.8-24.6 112l-37.6 0-5.6-16.2-32.8-95.8-37 0 0-32 26.1 0c-19.3-56.4-30.2-88-32.5-94.9l45.4-15.6c1.5 4.3 14.1 41.1 37.9 110.5l18.7 0c16.4-74.5 24.6-111.8 24.6-112z"],
    "malaysian-ringgit-sign": [576, 512, [], "e6fa", "M288 96l0-32 49.6 0 9.4 14.8 85 133.6 85-133.6 9.4-14.8 49.6 0 0 384-64 0 0-242.1c-39.7 62.3-66.3 104.2-80 125.7-13.7-21.5-40.3-63.4-80-125.7l0 242.1-64 0 0-352zM0 64l128 0c70.7 0 128 57.3 128 128 0 50.2-28.8 93.6-70.9 114.6 28.8 76.8 44.8 119.6 48.1 128.2l-59.9 22.5c-2.7-7.1-19.8-52.8-51.4-137.2L64 320 64 448 0 448 0 64zM64 256l64 0c35.3 0 64-28.7 64-64s-28.7-64-64-64l-64 0 0 128z"],
    "presentation-screen": [512, 512, ["presentation"], "f685", "M24 32l488 0 0 48-512 0 0-48 24 0zM232 384l-200 0 0-256 448 0 0 256-200 0 0 35.5c54.9 38.4 84.7 59.3 89.4 62.6l-27.5 39.3c-5.3-3.7-34-23.8-85.9-60.1-51.9 36.3-80.6 56.4-85.9 60.1l-27.5-39.3c4.8-3.3 34.6-24.2 89.4-62.6l0-35.5z"],
    "camera-movie": [576, 512, [127909, 127910], "f8a9", "M128 240C57.3 240 0 182.7 0 112S57.3-16 128-16c48.2 0 90.2 26.6 112 66 21.8-39.4 63.8-66 112-66 70.7 0 128 57.3 128 128S422.7 240 352 240l-224 0zm224-80a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM176 112a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM464 437.3l0-170.7 112-74.7 0 320-112-74.7zM64 288l352 0 0 208-352 0 0-208z"],
    "square-currency": [448, 512, [], "e70c", "M448 32l-448 0 0 448 448 0 0-448zM136 134.1c10.4 10.4 23.5 23.5 39.2 39.2 14.3-8.4 31-13.3 48.8-13.3s34.5 4.8 48.8 13.3c15.7-15.7 28.8-28.8 39.2-39.2L345.9 168c-10.4 10.4-23.5 23.5-39.2 39.2 8.4 14.3 13.3 31 13.3 48.8s-4.8 34.5-13.3 48.8c15.7 15.7 28.8 28.8 39.2 39.2L312 377.9c-10.4-10.4-23.5-23.5-39.2-39.2-14.3 8.4-31 13.3-48.8 13.3s-34.5-4.8-48.8-13.3c-15.7 15.7-28.8 28.8-39.2 39.2L102.1 344c10.4-10.4 23.5-23.5 39.2-39.2-8.4-14.3-13.3-31-13.3-48.8s4.8-34.5 13.3-48.8c-15.7-15.7-28.8-28.8-39.2-39.2L136 134.1zm54.2 87.9l-.2 .2c-8.6 8.7-13.9 20.6-13.9 33.8s5.3 25.2 13.9 33.8c0-67.7 0-67.6 .2 .2 8.7 8.6 20.6 13.9 33.8 13.9s25.2-5.3 33.8-13.9l.2-.2c8.6-8.7 13.9-20.6 13.9-33.8s-5.3-25.2-13.9-33.8l-.2-.2c-8.7-8.6-20.6-13.9-33.8-13.9s-25.2 5.3-33.8 13.9z"],
    "hat-chef": [512, 512, [], "f86b", "M448 384l-384 0 0 128 384 0 0-128zm0-48l0-90.8c37.8-18 64-56.5 64-101.2 0-61.9-50.1-112-112-112-17.3 0-33.7 3.9-48.3 10.9-23.4-26.3-57.6-42.9-95.7-42.9s-72.2 16.6-95.7 42.9C145.7 35.9 129.3 32 112 32 50.1 32 0 82.1 0 144 0 188.7 26.2 227.2 64 245.2l0 90.8 64 0 0-144 48 0 0 144 56 0 0-144 48 0 0 144 56 0 0-144 48 0 0 144 64 0z"],
    "children": [640, 512, [], "e4e1", "M160.2 128a64 64 0 1 0 0-128 64 64 0 1 0 0 128zm-41.5 32l-16.2 0-9.6 13.1C37.4 248.8 7.5 289.4 3.5 294.9l51.6 37.9c13.6-18.5 24.3-33.1 32.3-44l-31.1 111.2 32 0 0 112 64 0 0-112 16 0 0 112 64 0 0-112 32 0-31.1-111.2c8 10.9 18.7 25.5 32.3 44L317 294.9c-4-5.5-33.9-46.1-89.4-121.8l-9.6-13.1-99.2 0zm361.5-32a64 64 0 1 0 0-128 64 64 0 1 0 0 128zm-41.5 32l-16.2 0-9.6 13.1c-55.6 75.7-85.4 116.3-89.4 121.8l51.6 37.9c13.4-18.3 24.5-33.3 33.2-45.1l0 224.4 64 0 0-128 16 0 0 128 64 0 0-224.4c8.7 11.8 19.7 26.9 33.1 45.1L637 294.9c-4-5.5-33.9-46.1-89.4-121.8l-9.6-13.1-99.2 0z"],
    "snow-blowing": [640, 512, [], "f761", "M512 48l32 0c53 0 96 43 96 96s-43 96-96 96l-160 0 0-64 160 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0 0-64 32 0zM200 64l0 49.4c8.7-8.7 16.7-16.7 24-24L246.6 112c-3.5 3.5-19.1 19.1-46.6 46.6l0 55.8 48.3-27.9c10.1-37.6 15.8-58.9 17.1-63.7l30.9 8.3c-2.7 10-5.6 20.9-8.8 32.8 9.1-5.2 21-12.1 35.8-20.7l24 41.6c-14.8 8.6-26.8 15.4-35.8 20.7 11.9 3.2 22.8 6.1 32.8 8.8L336 245.2c-4.8-1.3-26.1-7-63.7-17.1L224 256 272.3 283.9c37.6-10.1 58.9-15.8 63.7-17.1l8.3 30.9c-10 2.7-20.9 5.6-32.8 8.8 9.1 5.2 21 12.1 35.8 20.7l-24 41.6c-14.8-8.6-26.8-15.4-35.8-20.7 3.2 11.9 6.1 22.8 8.8 32.8l-30.9 8.3c-1.3-4.8-7-26.1-17.1-63.7l-48.3-27.9 0 55.8c27.5 27.5 43.1 43.1 46.6 46.6L224 422.6c-7.3-7.3-15.3-15.3-24-24l0 49.4-48 0 0-49.4c-8.7 8.7-16.7 16.7-24 24L105.4 400c3.5-3.5 19.1-19.1 46.6-46.6l0-55.8-48.3 27.9c-10.1 37.6-15.8 58.9-17.1 63.7l-30.9-8.3c2.7-10 5.6-20.9 8.8-32.8-9.1 5.2-21 12.1-35.8 20.7l-24-41.6c14.8-8.6 26.8-15.4 35.8-20.7-11.9-3.2-22.8-6.1-32.8-8.8L16 266.8c4.8 1.3 26.1 7 63.7 17.1L128 256 79.7 228.1C42 238.2 20.8 243.9 16 245.2L7.7 214.3c10-2.7 20.9-5.6 32.8-8.8-9.1-5.2-21-12.1-35.8-20.7l24-41.6c14.8 8.6 26.8 15.4 35.8 20.7-3.2-11.9-6.1-22.8-8.8-32.8l30.9-8.3c1.3 4.8 7 26.1 17.1 63.7l48.3 27.9 0-55.8c-27.5-27.5-43.1-43.1-46.6-46.6L128 89.4c7.3 7.3 15.3 15.3 24 24l0-49.4 48 0zM480 464l0-64 56 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-152 0 0-64 152 0c53 0 96 43 96 96s-43 96-96 96l-56 0z"],
    "album-collection": [512, 512, [], "f8a0", "M128.3 0l0 48 256 0 0-48-256 0zm-64 192L9 192c1.2 8.3 14.5 101.3 39.8 278.8l5.9 41.2 403.3 0 5.9-41.2c25.4-177.6 38.6-270.5 39.8-278.8L64.3 192zm352 160c0 61.9-71.6 112-160 112s-160-50.1-160-112 71.6-112 160-112 160 50.1 160 112zm-160 28c22.1 0 40-12.5 40-28s-17.9-28-40-28-40 12.5-40 28 17.9 28 40 28zM104.3 96l-24 0 0 48 352 0 0-48-328 0z"],
    "chart-line": [512, 512, ["line-chart"], "f201", "M64 64l0-32-64 0 0 448 512 0 0-64-448 0 0-352zm406.6 86.6L493.3 128 448 82.7c-1.3 1.3-44 44-128 128-44-44-70.7-70.7-80-80-2.9 2.9-42.4 42.4-118.6 118.6L98.7 272 144 317.3c6.6-6.6 38.6-38.6 96-96 44 44 70.7 70.7 80 80l22.6-22.6 128-128z"],
    "circle-up-left": [512, 512, [], "e128", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM184 160l169.9 0c-29.6 29.6-52.3 52.3-68 68 53 53 81 81 84 84-24.3 24.3-54.1 54.1-57.9 57.9-3-3-31-31-84-84-15.7 15.7-38.4 38.4-68 68l0-193.9 24 0z"],
    "envelope-ribbon": [640, 512, ["envelope-certificate"], "e829", "M512 160c70.7 0 128 57.3 128 128 0 40.4-18.8 76.4-48 99.9l0 132.1-80-40-80 40 0-132.1c-29.2-23.5-48-59.5-48-99.9 0-70.7 57.3-128 128-128zM320 388l32.9-24.7c8 16.8 18.5 32.1 31.1 45.4l0 39.3-320 0 0-252 256 192zM512 240a48 48 0 1 0 0 96 48 48 0 1 0 0-96zm64-115.9c-19.8-7.8-41.4-12.1-64-12.1-97.2 0-176 78.8-176 176 0 9 .7 17.8 2 26.5l-18 13.5-19.2-14.4-224-168-12.8-9.6 0-72 512 0 0 60.1z"],
    "tire": [512, 512, [], "f631", "M400 256c0-39.2-15.7-74.7-41.1-100.7L330.1 195c13.7 16.6 21.9 37.8 21.9 61 0 2-.1 4-.2 6l46.6 15.2c1-6.9 1.5-14 1.5-21.2zm-63.1 51.6c-12.9 20.2-33.2 35.2-57 41.3l0 49c45.1-7.6 83.1-36.1 103.6-75.2l-46.6-15.2zM232 349c-23.8-6.1-44-21.2-56.9-41.3l-46.6 15.2c20.5 39.1 58.5 67.6 103.6 75.2l0-49zM112 256c0 7.2 .5 14.3 1.5 21.2L160.2 262c-.1-2-.2-4-.2-6 0-23.2 8.2-44.4 21.9-61l-28.8-39.7C127.7 181.3 112 216.8 112 256zm144-96c12.5 0 24.4 2.4 35.4 6.7L320.2 127c-19.3-9.6-41.1-15-64.2-15s-44.8 5.4-64.1 15l28.8 39.7c10.9-4.3 22.9-6.7 35.4-6.7zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm256 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "australian-dollar-sign": [576, 512, [], "e6fe", "M400.2 16l0 52.4c-46.2 13.5-80 56.1-80 106.7 0 53 37.4 98.6 89.3 109l32.8 6.6c22 4.4 37.9 23.8 37.9 46.2 0 26-21.1 47.1-47.1 47.1l-96.9 0 0 64 64 0 0 48 64 0 0-52.4c46.2-13.5 80-56.1 80-106.7 0-53-37.4-98.6-89.3-109l-32.8-6.6c-22-4.4-37.9-23.7-37.9-46.2 0-26 21.1-47.1 47.1-47.1l80.9 0 0-64-48 0 0-48-64 0zm-248 32l-25.2 0-5.9 24.5-98.1 407.5 65.8 0 23.1-96 96.5 0 23.1 96 65.8 0-98.1-407.5-5.9-24.5-41.2 0zm40.9 272l-65.7 0 32.9-136.5 32.9 136.5z"],
    "square-envelope": [448, 512, ["envelope-square"], "f199", "M448 32l-448 0 0 448 448 0 0-448zM96 160l256 0 0 41.3-128 74-128-74 0-41.3zM232 307.6l120-69.3 0 113.8-256 0 0-113.8 120 69.3 8 4.6 8-4.6z"],
    "object-exclude": [512, 512, [], "e49c", "M0 0l352 0 0 160 160 0 0 352-352 0 0-160-160 0 0-352zM320 192l-128 0 0 128 128 0 0-128z"],
    "user-group-crown": [576, 512, ["users-crown"], "f6a5", "M64 53.7L64 128c0 61.9 50.1 112 112 112s112-50.1 112-112l0-128-64 32-48-48-48 48-64-32 0 53.7zM240 128c0 35.3-28.7 64-64 64s-64-28.7-64-64l128 0zM432 256a96 96 0 1 0 0-192 96 96 0 1 0 0 192zm80 48l-169.5 0 55.7 194.8 3.8 13.2 174.1 0-64-208zM64 288l-64 224 352 0-64-224-224 0z"],
    "ban-smoking": [512, 512, [128685, "smoking-ban"], "f54d", "M99.5 144.8c113.9 113.9 228.2 228.2 267.8 267.8-31.4 22.4-69.8 35.5-111.2 35.5-106 0-192-86-192-192 0-41.5 13.1-79.9 35.5-111.2zM333.3 288l-32-32 82.7 0 0 32-50.7 0zm32 32l50.7 0 0-96-146.7 0-124.5-124.5c31.4-22.4 69.8-35.5 111.2-35.5 106 0 192 86 192 192 0 41.5-13.1 79.9-35.5 111.2L365.3 320zM256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM288 96l-32 0 0 16c0 26.5 21.5 48 48 48l32 0c8.8 0 16 7.2 16 16l0 16 32 0 0-16c0-26.5-21.5-48-48-48l-32 0c-8.8 0-16-7.2-16-16l0-16zM229.5 320l-96-96-37.5 0 0 96 133.5 0z"],
    "user-visor": [448, 512, [], "e04c", "M334 176c-18.5 42.4-60.8 72-110 72s-91.5-29.6-110-72l-34 0 0-128 54.6 0c22-24.6 53.9-40 89.4-40s67.5 15.4 89.4 40l54.6 0 0 128-34 0zm34 128l64 208-416 0 64-208 288 0zM272 472l48-28 48 28-48-96-48 96zM152 92l-20 0 0 40 184 0 0-40-164 0z"],
    "bar-progress-half": [512, 512, [], "e6a7", "M256 160l0 192 192 0 0-192-192 0zM0 96l512 0 0 320-512 0 0-320z"],
    "truck-front": [512, 512, [], "e2b7", "M0 32l512 0 0 416-32 0 0 64-96 0 0-64-256 0 0 64-96 0 0-64-32 0 0-416zM128 160l0 96 256 0 0-96-256 0zm0 192a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm288 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "blinds-open": [448, 512, [], "f8fc", "M448 32l-448 0 0 64 112 0 0 256 48 0 0-256 288 0 0-64zm0 192l0-64-240 0 0 64 240 0zM64 160l-64 0 0 64 64 0 0-64zm0 144l0-16-64 0 0 64 64 0 0-48zm144-16l0 64 240 0 0-64-240 0zM0 480l448 0 0-64-448 0 0 64z"],
    "building": [384, 512, [127970, 61687], "f1ad", "M384 0L0 0 0 512 384 512 384 0zM240 352l0 112-96 0 0-112 96 0zM96 96l64 0 0 64-64 0 0-64zm192 0l0 64-64 0 0-64 64 0zM96 224l64 0 0 64-64 0 0-64zm192 0l0 64-64 0 0-64 64 0z"],
    "bullseye": [512, 512, [], "f140", "M448 256a192 192 0 1 0 -384 0 192 192 0 1 0 384 0zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm256 80a80 80 0 1 0 0-160 80 80 0 1 0 0 160zm0-224a144 144 0 1 1 0 288 144 144 0 1 1 0-288zM224 256a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"],
    "album-circle-user": [576, 512, [], "e48d", "M32 32l448 0 0 182c-15.3-3.9-31.4-6-48-6-7.8 0-15.4 .5-22.9 1.4-20-65.6-81-113.4-153.1-113.4-88.4 0-160 71.6-160 160 0 83.2 63.5 151.5 144.6 159.3 1.8 23 7.6 44.8 16.8 64.7L32 480 32 32zM256 224a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm32 176a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm223.5 78.9l-15.5-30.9-128 0-15.5 30.9C372.8 499.4 400.9 512 432 512s59.2-12.6 79.5-33.1zM480 368a48 48 0 1 0 -96 0 48 48 0 1 0 96 0z"],
    "arrow-left-long": [640, 512, ["long-arrow-left"], "f177", "M41.6 233.4l-22.6 22.6 22.6 22.6 128 128 22.6 22.6 45.3-45.3-96-96 466.7 0 0-64-466.7 0c57.4-57.4 89.4-89.4 96-96l-45.3-45.3-22.6 22.6-128 128z"],
    "swap-arrows": [640, 512, [], "e60a", "M19 128c8.2-8.2 37.1-37.1 86.6-86.6l22.6-22.6c8.2 8.2 37.1 37.1 86.6 86.6l22.6 22.6-45.3 45.3c-17.3-17.3-28-28-32-32l0 274.7 128 0 0-384 256 0 0 338.7 32-32 45.3 45.3-109.3 109.3-109.3-109.3 45.3-45.3 32 32 0-274.7-128 0 0 384-256 0 0-338.7c-4 4-14.7 14.7-32 32L19 128z"],
    "chess-rook": [384, 512, [9820], "f447", "M0 0l0 160 64 64 0 160-64 80 0 48 384 0 0-48-64-80 0-160 64-64 0-160-96 0 0 64-48 0 0-64-96 0 0 64-48 0 0-64-96 0z"],
    "blender-phone": [576, 512, [], "f6b6", "M76.6-1.4l75.4 25.1-12.3 88.3-50.6-.3c-14.7 40.6-14.7 85.1 0 125.7l50.6-.3 12.3 88.3-75.4 25.1-6.3-6.3c-93.7-93.7-93.7-245.7 0-339.4l6.3-6.3zM224 336l-32-336 384 0-22.9 80-137.1 0 0 48 123.4 0-18.3 64-105.1 0 0 48 91.4 0-27.4 96-256 0zm288 48l0 128-320 0 0-128 320 0zM352 472a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"],
    "arrow-turn-up": [384, 512, ["level-up"], "f148", "M32 448l-32 0 0 64 224 0 0-402.7c57.4 57.4 89.4 89.4 96 96l45.3-45.3-22.6-22.6-128-128-22.6-22.6-22.6 22.6-128 128-22.6 22.6 45.3 45.3c6.6-6.6 38.6-38.6 96-96l0 338.7-128 0z"],
    "shelves-empty": [512, 512, [], "e246", "M64 32l0-32-64 0 0 512 64 0 0-32 384 0 0 32 64 0 0-512-64 0 0 160-384 0 0-128zm0 192l384 0 0 192-384 0 0-192z"],
    "note": [448, 512, [], "e1ff", "M0 480l304 0 144-144 0-304-448 0 0 448zm272-58.5L272 304 389.5 304 272 421.5zM112 112l0 48-48 0 0-48 48 0zM64 232l48 0 0 48-48 0 0-48zm48 120l0 48-48 0 0-48 48 0z"],
    "pen-field": [640, 512, [], "e211", "M288 320l16-112 164.7-164.7 96 96-164.7 164.7-112 16zM587.3 116.7l-96-96 52.7-52.7 96 96-52.7 52.7zM64 96l224 0 0 64-160 0 0 256 384 0 0-160 64 0 0 224-512 0 0-384zM256 256l0 64-64 0 0-64 64 0z"],
    "corn": [512, 512, [127805], "f6c7", "M512 40c0 15-8.3 28.1-20.5 34.9 7.7 7.3 12.5 17.6 12.5 29.1 0 18-11.8 33.2-28.2 38.2 2.7 5.4 4.2 11.4 4.2 17.8 0 18-11.8 33.2-28.2 38.2 2.7 5.4 4.2 11.4 4.2 17.8 0 22.1-17.9 40-40 40-1.1 0-2.3 0-3.4-.1 2.2 4.9 3.4 10.4 3.4 16.1 0 13.6-6.8 25.7-17.3 32.9-47.7-29.7-103.6-41.1-157.5-34.2 6.9-53.9-4.5-109.8-34.2-157.5 7.2-10.4 19.3-17.3 32.9-17.3 5.7 0 11.2 1.2 16.1 3.4-.1-1.1-.1-2.2-.1-3.4 0-22.1 17.9-40 40-40 6.4 0 12.4 1.5 17.8 4.2 5-16.3 20.2-28.2 38.2-28.2 6.4 0 12.4 1.5 17.8 4.2 5-16.3 20.2-28.2 38.2-28.2 11.4 0 21.8 4.8 29.1 12.5 6.8-12.2 19.9-20.5 34.9-20.5 22.1 0 40 17.9 40 40zM139.9 82.5l10.4 10.4c50.2 50.2 69.4 119.6 57.5 184.6-38.7 10.7-75.2 31.2-105.5 61.6L28.7 412.7 0 384 0 320 112 208 139.9 82.5zM51.3 435.3l73.6-73.6c28.6-28.6 63.5-47.1 100.1-55.6 67.6-15.6 141.4 3 194 55.6l10.4 10.4-125.5 27.9-112 112-64 0-76.7-76.7z"],
    "piano-keyboard": [576, 512, [127929], "f8d5", "M576 64l-576 0 0 384 576 0 0-384zM512 224l0 160-76 0 0-64 12 0 0-96 64 0zM396 384l-88 0 0-64 12 0 0-96 64 0 0 96 12 0 0 64zm-128 0l-88 0 0-64 12 0 0-96 64 0 0 96 12 0 0 64zm-128 0l-76 0 0-160 64 0 0 96 12 0 0 64z"],
    "face-tongue-sweat": [640, 512, [], "e39e", "M429.5 487.4c86.6-41 146.5-129.3 146.5-231.4 0-141.4-114.6-256-256-256-131 0-239.1 98.5-254.2 225.4 6.1 4.8 25.8 20.5 34.6 28l.3 .3c14.4 12.5 32.3 29.7 46.8 50.2 14.3 20.1 28.4 47.7 28.4 80.1 0 25.4-8 48.6-21.7 67.2 17 14.4 35.8 26.7 56.1 36.3-1.6-7.6-2.5-15.4-2.5-23.4l0-44.9c-10.2-8-16-17.3-16-27.1 0-30.9 57.3-56 128-56s128 25.1 128 56c0 9.8-5.8 19.1-16 27.1l0 44.9c0 8-.8 15.9-2.5 23.4zM400 224a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM272 256a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm-9.9-97.9l-7.4 7.4c-24.2 24.2-55.3 40.2-89 45.8l-2.5 .4-19.7 3.3-6.6-39.5 19.7-3.3 2.5-.4c25.5-4.2 49-16.4 67.3-34.6 3.8-3.8 11-11 21.5-21.5l28.3 28.3-14.1 14.1zM363.7 144L392 115.7c10.6 10.6 17.7 17.7 21.5 21.5 18.3 18.3 41.8 30.4 67.3 34.6l2.5 .4 19.7 3.3-6.6 39.5-19.7-3.3-2.5-.4c-33.7-5.6-64.8-21.6-89-45.8-3.8-3.8-11-11-21.5-21.5zM64 285.5c-4.9 4.2-9.7 8.4-14.3 12.9-10.8 10.5-28.8 29.7-40 51.3-5.6 10.7-9.6 22.5-9.6 34.3 0 36.4 27.6 64 64 64s64-27.6 64-64c0-11.8-4.1-23.6-9.6-34.3-11.2-21.6-29.2-40.8-40-51.3-4.6-4.5-9.4-8.7-14.3-12.9zM384 448l0-64-48 0 0 24-32 0 0-24-48 0 0 64c0 35.3 28.7 64 64 64s64-28.7 64-64z"],
    "bicycle": [640, 512, [128690], "f206", "M313.6 32l166.4 0 0 48-89.6 0 72.2 148.4c10.7-2.9 21.9-4.4 33.4-4.4 70.7 0 128 57.3 128 128s-57.3 128-128 128-128-57.3-128-128c0-42 20.2-79.2 51.4-102.6l-20.4-41.9-73.6 147.2-6.6 13.3-47.8 0c-7.9 63.1-61.7 112-127 112-70.7 0-128-57.3-128-128S73.3 224 144 224c10.8 0 21.2 1.3 31.2 3.8l28.5-56.9-11.5-26.9-64.2 0 0-48 95.8 0c2.8 6.5 9.7 22.5 20.6 48l123.7 0c-28.6-58.8-46.8-96.2-54.5-112zM228.5 228.7l-45.6 91.3 84.8 0-39.1-91.3zM305.7 287l47.5-95-88.2 0 40.7 95zm168.7 75.5l-29.7-61c-12.8 13-20.7 30.8-20.7 50.5 0 39.8 32.2 72 72 72s72-32.2 72-72-32.2-72-72-72c-2.7 0-5.5 .2-8.1 .5 23 47.3 36.4 74.8 40.2 82.6l-43.2 21-10.5-21.6zM144 368l-38.8 0c10-20.1 24.7-49.4 43.9-87.8-1.7-.1-3.4-.2-5.1-.2-39.8 0-72 32.2-72 72s32.2 72 72 72c34.3 0 62.9-23.9 70.2-56L144 368z"],
    "money-simple-from-bracket": [576, 512, [], "e313", "M24 0l552 0 0 192-48 0 0-144-480 0 0 144-48 0 0-192 24 0zM480 96l0 416-384 0 0-416 384 0zM288 352a96 96 0 1 0 0-192 96 96 0 1 0 0 192z"],
    "user-tie-hair-long": [448, 512, [], "e460", "M304 128c0-18-6-34.6-16-48l0 0-64 48-80 0 0 16c0 44.2 35.8 80 80 80s80-35.8 80-80l0-16zm48 0l0 48 48 96-352 0 48-96 0-48C96 57.3 153.3 0 224 0S352 57.3 352 128zM272 328l-31.6 36.9 31 115.1 .6 0 40-160 56 0 64 192-416 0 64-192 56 0 40 160 31.4-115.3-31.4-36.7 0-24 96 0 0 24z"],
    "badge": [512, 512, [], "f335", "M340.9 51.1C324.8 20.7 292.8 0 256 0s-68.8 20.7-84.9 51.1C138.2 41 101 49 75 75s-34 63.3-23.9 96.1C20.7 187.2 0 219.2 0 256s20.7 68.8 51.1 84.9C41 373.8 49 411 75 437s63.3 34 96.1 23.9C187.2 491.3 219.2 512 256 512s68.8-20.7 84.9-51.1C373.8 471 411 463 437 437s34-63.3 23.9-96.1C491.3 324.8 512 292.8 512 256s-20.7-68.8-51.1-84.9C471 138.2 463 101 437 75s-63.3-34-96.1-23.9z"],
    "truck-utensils": [576, 512, [], "e628", "M416 32L0 32 0 448 67.3 448c10.4 36.9 44.4 64 84.7 64s74.2-27.1 84.7-64l102.6 0c10.4 36.9 44.4 64 84.7 64s74.2-27.1 84.7-64l67.3 0 0-237.3-9.4-9.4-64-64-9.4-9.4-77.3 0 0-96zm96 205.3l0 50.7-96 0 0-96 50.7 0 45.3 45.3zM152 384a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm232 40a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zM208 192c0 23.8-17.3 43.5-40 47.3l0 96.7-48 0 0-96.7c-22.7-3.8-40-23.6-40-47.3l0-96 32 0 0 80 16 0 0-80 32 0 0 80 16 0 0-80 32 0 0 96zM320 96l0 240-48 0 0-80-32 0 0-80c0-44.2 35.8-80 80-80z"],
    "file-brackets-curly": [384, 512, [], "e804", "M384 144L384 512 0 512 0 0 240 0 384 144zM84 292.4c-20.5 23-33.4 37.6-38.8 43.6 5.4 6 18.3 20.5 38.8 43.6l0 64.4 72 0 0-40-32 0 0-39.6c-.8-1-9.3-10.4-25.3-28.4 16-18 24.4-27.5 25.3-28.4l0-39.6 32 0 0-40-72 0 0 64.4zM228 268l32 0 0 39.6c.8 1 9.3 10.4 25.3 28.4-16 18-24.4 27.5-25.3 28.4l0 39.6-32 0 0 40 72 0 0-64.4c20.5-23 33.4-37.5 38.7-43.6-5.4-6-18.3-20.5-38.7-43.6l0-64.4-72 0 0 40zm-20-92L325.5 176 208 58.5 208 176z"],
    "circle-arrow-down": [512, 512, ["arrow-circle-down"], "f0ab", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM239 377c-63.8-63.8-96.2-96.2-97-97L176 246.1c7.6 7.6 26.3 26.3 56 56l0-150.1 0-24 48 0 0 174.1c29.7-29.7 48.4-48.4 56-56l33.9 33.9-17 17-80 80-17 17-17-17z"],
    "peruvian-soles-sign": [512, 512, [], "e705", "M516.5 11.5l-121.2 500.5-65.8 0 2.8-11.5 121.2-500.5 65.8 0-2.8 11.5zM272.4 128l-146.9 0c-24.9 0-45.1 20.2-45.1 45.1 0 22.4 16.5 41.5 38.8 44.7l91.6 13.1c53.8 7.7 93.7 53.7 93.7 108 0 60.3-48.9 109.1-109.1 109.1l-162.9 0 0-64 162.9 0c24.9 0 45.1-20.2 45.1-45.1 0-22.4-16.5-41.5-38.8-44.7l-91.6-13.1c-53.8-7.7-93.7-53.7-93.7-108 0-60.3 48.9-109.1 109.1-109.1l146.9 0 0 64z"],
    "triple-chevrons-left": [640, 512, [], "e7f8", "M237.5 128L109.5 256 237.5 384 192.3 429.3 19 256 192.3 82.8 237.5 128zm192 0L301.5 256 429.5 384 384.3 429.3 211 256 384.3 82.8 429.5 128zm192 0L493.5 256 621.5 384 576.3 429.3 403 256 576.3 82.8 621.5 128z"],
    "gear": [512, 512, [9881, "cog"], "f013", "M200.1-16l112 0 19.7 95.5c14.1 6 27.3 13.7 39.3 22.8l92.6-30.7 56 97-72.9 64.8c.9 7.4 1.3 15 1.3 22.7s-.5 15.3-1.3 22.7l72.9 64.8-56 97-92.6-30.7c-12.1 9.1-25.3 16.7-39.3 22.8l-19.7 95.5-112 0-19.7-95.5c-14.1-6-27.2-13.7-39.3-22.8l-92.6 30.7-56-97 72.9-64.8c-.9-7.4-1.3-15-1.3-22.7s.5-15.3 1.3-22.7l-72.9-64.8 56-97 92.6 30.7c12.1-9.1 25.3-16.7 39.3-22.8L200.1-16zm56 352a80 80 0 1 0 -.1-160 80 80 0 1 0 .1 160z"],
    "films": [576, 512, [], "e17a", "M96 32l448 0 0 384-448 0 0-384zM48 128l0 336 400 0 0 48-448 0 0-384 48 0zm96-48l0 64 64 0 0-64-64 0zm0 112l0 64 64 0 0-64-64 0zm64 112l-64 0 0 64 64 0 0-64zM432 80l0 64 64 0 0-64-64 0zm64 112l-64 0 0 64 64 0 0-64zM432 304l0 64 64 0 0-64-64 0z"],
    "walker": [448, 512, [], "f831", "M119.3 0l297 0 0 392.6c19.1 11.1 32 31.7 32 55.4 0 35.3-28.7 64-64 64s-64-28.7-64-64c0-23.7 12.9-44.4 32-55.4l0-168.6-223 0-65.9 263.8-7.8 31-62.1-15.5 7.8-31 112-448 6.1-24.2zm26 160l207 0 0-96-183 0-24 96z"],
    "square-arrow-right": [448, 512, ["arrow-square-right"], "f33b", "M448 32l-448 0 0 448 448 0 0-448zM345 273l-80 80-17 17-33.9-33.9c7.6-7.6 26.3-26.3 56-56l-174.1 0 0-48 174.1 0c-29.7-29.7-48.4-48.4-56-56L248 142.1c.8 .8 33.1 33.1 97 97l17 17-17 17z"],
    "face-party": [640, 512, [], "e383", "M38.1 73.1c25.7-39.5 59.5-73.3 99-99L203.5-7.5c-65.4 29-118 81.6-147 147L38.1 73.1zM257.8 7.6C277.7 2.6 298.5 0 320 0 433.4 0 529.7 73.8 563.3 176l-110.5 0c-11-12.3-27-20-44.7-20l-16 0c-33.1 0-60 26.9-60 60l0 16 40 0 0-16c0-11 9-20 20-20l16 0c11 0 20 9 20 20l0 16 36 0 0 64-69.5 0c-7.6-5.1-16.7-8-26.5-8l-48 0 0 32 32 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-32 0 0 32 32 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-32 0 0 32 48 0c9.8 0 18.9-2.9 26.5-8L498 440c-46.1 44.6-108.8 72-178 72-141.4 0-256-114.6-256-256 0-21.5 2.6-42.3 7.6-62.2 22.8-91.4 94.8-163.4 186.2-186.2zM27 33.3L0-64 97.3-37C70.8-16.8 47.2 6.8 27 33.3zM232 196l16 0c11 0 20 9 20 20l0 16 40 0 0-16c0-33.1-26.9-60-60-60l-16 0c-33.1 0-60 26.9-60 60l0 16 40 0 0-16c0-11 9-20 20-20zm280 28l128 0 0 168-216 0 0-48 168 0 0-72-32 0 0 32-48 0 0-80z"],
    "mars-and-venus-burst": [640, 512, [], "e523", "M496-64l-32 0 0 64 66.7 0-63 63c-28.4-19.5-62.7-31-99.8-31-97.2 0-176 78.8-176 176 0 86.3 62.1 158.1 144 173.1l0 34.9-64 0 0 64 64 0 0 64 64 0 0-64 64 0 0-64-64 0 0-34.9c81.9-15 144-86.8 144-173.1 0-37-11.4-71.4-31-99.8l63-63 0 66.7 64 0 0-176-144 0zM368 96a112 112 0 1 1 0 224 112 112 0 1 1 0-224zM176-32l-42.2 88.5-95.4-22.2 42.9 88.1-76.9 60.8 95.6 21.4-.4 98 50.8-40.9c-4.2-17.2-6.5-35.2-6.5-53.7 0-63.7 26.6-121.1 69.2-161.9L176-32z"],
    "columns-3": [448, 512, [], "e361", "M320 96l0 320 64 0 0-320-64 0zm-64 0l-64 0 0 320 64 0 0-320zM128 416l0-320-64 0 0 320 64 0zM0 32l448 0 0 448-448 0 0-448z"],
    "otter": [640, 512, [129446], "f700", "M188.8 193.6l19.2 14.4 48 0 0-64c0-35.3-28.7-64-64-64l-64 0c-35.3 0-64 28.7-64 64l0 64 48 0c14.7-11 23.7-17.8 27.1-20.3-5.7-3.8-9.4-6.3-11.1-7.4l0-36.3 64 0 0 36.3c-1.7 1.1-5.4 3.6-11.1 7.4l7.9 5.9zM256 320l0 64 128 0 0-64 64-64 0-64 64 0 0 128 32 0 0-115.7c0-48.2-30.8-91-76.6-106.3l-8.5-2.8 8.2-30.9 19.9 4C576 86.1 640 164.2 640 254.9l0 1.1 0 0c0 123.7-100.3 224-224 224l-160.6 0C132 480 32 380 32 256.6l0-.6-16 0 0-112-16 0 0-48 26.8 0C44.8 58.2 83.3 32 128 32l64 0c44.7 0 83.2 26.2 101.2 64l26.8 0 0 48-16 0 0 16 80 0 0 64-64 0 0 32 80 0-48 48 0 16-32 0c-41.8 0-77.4-26.7-90.5-64l-37.5 0-32-24-32 24-32 0c0 35.3 28.7 64 64 64l96 0zM96 128a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm112 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"],
    "arrow-u-turn-right-down": [576, 512, [], "e7eb", "M573.5 368l-45.3-45.3-80 80 0-210.7C448.3 89.3 367.6 5.4 266.1 .2L256.3 0c-106 0-192 86-192 192l0 256 64 0 0-256c0-70.7 57.3-128 128-128l6.6 .2c67.6 3.4 121.4 59.4 121.4 127.8l0 210.7-80-80-45.2 45.3 157.2 157.2 157.3-157.2z"],
    "circle-9": [512, 512, [], "e0f6", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM200 368l0-48 72 0c13.3 0 24-10.7 24-24l0-12.1c-7.5 2.7-15.6 4.1-24 4.1l-32 0c-39.8 0-72-32.2-72-72s32.2-72 72-72l32 0c39.8 0 72 32.2 72 72l0 80c0 39.8-32.2 72-72 72l-72 0zm72-176l-32 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l32 0c13.3 0 24-10.7 24-24s-10.7-24-24-24z"],
    "sneaker-running": [640, 512, [], "e819", "M240 480l-208 0 0-48 208 0 0 48zm203.9-49.1l196.1 0 0 49.1-224 0-352-208 26.9-44.9 353 203.8zM128 400l-96 0 0-48 96 0 0 48zM256 82.8c0 25 20.3 45.2 45.2 45.2 12 0 23.5-4.8 32-13.2l50.7-50.8 48 0 24.6 64-72.6 0 0 48 91.1 0 18.5 48-77.5 0 0 48 96 0c64.9 0 118.4 48.3 126.8 110.9l-182 0-341.2-197 92.4-153.9 48 0 0 50.8z"],
    "circle-chevron-left": [512, 512, ["chevron-circle-left"], "f137", "M512 256a256 256 0 1 0 -512 0 256 256 0 1 0 512 0zM167 239l104-104 17-17 33.9 33.9-17 17-87 87 87 87 17 17-33.9 33.9-17-17-104-104-17-17 17-17z"],
    "circle-question": [512, 512, [62108, "question-circle"], "f059", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm0-336c-17.7 0-32 14.3-32 32l-48 0c0-44.2 35.8-80 80-80s80 35.8 80 80c0 35.1-20.5 57.5-38.2 70-6.3 4.4-12.5 7.8-17.8 10.4l0 21.9-48 0 0-56.7c1.4-.4 2.7-.7 4.1-1.1 12.2-3.2 23.3-6.1 34.1-13.7 10.4-7.3 17.8-16.9 17.8-30.8 0-17.7-14.3-32-32-32zM232 344l48 0 0 48-48 0 0-48z"],
    "arrow-rotate-right-10": [512, 512, [], "e837", "M512 192l-59.2 16.9-32-51.4-.1-.2-.1-.2C386.9 101.2 325.8 64 256 64 150 64 64 150 64 256s86 192 192 192c75 0 140-43 171.7-105.8 19 9.6 38.1 19.2 57.2 28.7-42.1 83.6-128.7 141.1-228.8 141.1-141.4 0-256-114.6-256-256S114.6 0 256 0c76.5 0 145.1 33.6 192 86.7l0-86.7 64 0 0 192zM208 352l-48 0 0-129.2-18.7 9.4-21.5-42.9c11.7-5.9 31.2-15.6 58.5-29.3l29.7 0 0 192zM312 160c30.9 0 56 25.1 56 56l0 80c0 30.9-25.1 56-56 56l-16 0c-30.9 0-56-25.1-56-56l0-80c0-30.9 25.1-56 56-56l16 0zm-16 48c-4.4 0-8 3.6-8 8l0 80c0 4.4 3.6 8 8 8l16 0c4.4 0 8-3.6 8-8l0-80c0-4.4-3.6-8-8-8l-16 0z"],
    "walkie-talkie": [384, 512, [], "f8ef", "M112-32l0 96 48 0 0-32 64 0 0 32 32 0 0-32 64 0 0 32 64 0 0 224-32 64 0 160-320 0 0-160-32-64 0-224 64 0 0-96 48 0zm8 176l-24 0 0 48 192 0 0-48-168 0zm0 96l-24 0 0 48 192 0 0-48-168 0z"],
    "user-group": [576, 512, [128101, "user-friends"], "f500", "M64 128a112 112 0 1 1 224 0 112 112 0 1 1 -224 0zM288 288l64 224-352 0 64-224 224 0zM432 64a96 96 0 1 1 0 192 96 96 0 1 1 0-192zm80 240l64 208-174.1 0-3.8-13.2-55.7-194.8 169.5 0z"],
    "bed-front": [512, 512, ["bed-alt"], "f8f7", "M480 32l-448 0 0 144 48 0 0-48 152 0 0 48 48 0 0-48 152 0 0 48 48 0 0-144zM32 224l-32 0 0 256 64 0 0-64 384 0 0 64 64 0 0-256-480 0z"],
    "house-chimney": [512, 512, [63499, "home-lg"], "e3af", "M464 272l48 0 0-48-48-45 0-131-96 0 0 41-112-105-256 240 0 48 48 0 0 240 416 0 0-240zM320 464l-128 0 0-144 128 0 0 144z"],
    "right-from-bracket": [576, 512, ["sign-out-alt"], "f2f5", "M536.9 273.4l18.5-17.4-18.5-17.4c-113.3-107-174.7-165-184.5-174.2l0 127.7-160 0 0 128 160 0 0 127.7c9.7-9.2 71.2-67.3 184.5-174.2zM192.5 96l32 0 0-64-192 0 0 448 192 0 0-64-128 0 0-320 96 0z"],
    "peanuts": [576, 512, [129372], "e431", "M32 362.9l0 149.1 141.7 0c42.4 0 83.1-16.9 113.1-46.9l12.9-12.9c23.6-23.6 39.2-53.9 44.7-86.8l7.6-45.4 40.4-6.7c36.2-6 69.6-23.2 95.5-49.2l4.6-4.6c33-33 51.5-77.8 51.5-124.5L544 0 408.9 0c-46.7 0-91.4 18.5-124.5 51.5l-4.6 4.6c-25.9 25.9-43.1 59.3-49.2 95.5l-6.7 40.4-53.2 8.9c-28 4.7-54.3 16.7-76.1 34.9L89.6 240C53.1 270.4 32 315.5 32 362.9zM448 108.8a19.2 19.2 0 1 1 0 38.4 19.2 19.2 0 1 1 0-38.4zm0 64a19.2 19.2 0 1 1 0 38.4 19.2 19.2 0 1 1 0-38.4zm-64 0a19.2 19.2 0 1 1 0 38.4 19.2 19.2 0 1 1 0-38.4zm-224 224a19.2 19.2 0 1 1 0 38.4 19.2 19.2 0 1 1 0-38.4zM204.8 416a19.2 19.2 0 1 1 38.4 0 19.2 19.2 0 1 1 -38.4 0zm0-64a19.2 19.2 0 1 1 38.4 0 19.2 19.2 0 1 1 -38.4 0zM576 218.3c-11.2 27.9-27.9 53.5-49.6 75.2l-4.6 4.6c-33 33-75.5 54.9-121.6 62.6l-6.5 1.1-1.9 11.6c-7.1 42.8-27.4 82.2-58.1 112.9l-12.9 12.9c-19.4 19.4-42.2 34.6-67.1 44.9l44.6 0c31.8 0 62.3-12.6 84.9-35.1l9.7-9.7c17.7-17.7 29.4-40.5 33.5-65.1l5.7-34.1 30.3-5c27.1-4.5 52.2-17.4 71.6-36.9l3.4-3.4c24.8-24.8 38.7-58.3 38.7-93.3l0-41.3c0-.6 0-1.1 0-1.7z"],
    "triangle-instrument": [576, 512, ["triangle-music"], "f8e2", "M320 42.4l0-74.4-64 0 0 74.4-4.5 8.2-200.4 365.4-35.1 64 544 0c-14.7-26.7-55.5-101.3-122.6-223.6l-47.1 47.1 61.7 112.4-327.8 0 163.9-298.9 54.2 98.8-35.4 35.4c-5.9-2.1-12.2-3.2-18.8-3.2-30.9 0-56 25.1-56 56s25.1 56 56 56 56-25.1 56-56c0-6.6-1.1-12.9-3.2-18.8L537 89 553.9 72 520 38.1 503 55 389.3 168.7 324.5 50.6 320 42.4z"],
    "bowl-spoon": [512, 512, [129379], "e3e0", "M0 80C0 27 50.1-16 112-16l112 0 0 64 288 0 0 64-288 0 0 64-112 0C50.1 176 0 133 0 80zM0 224l512 0-3.6 61.2C503.5 368.1 454 438.2 384 472.9l0 39.1-256 0 0-39.1C58 438.2 8.5 368.1 3.6 285.2L0 224z"],
    "file": [384, 512, [128196, 128459, 61462], "f15b", "M240 0L0 0 0 512 384 512 384 144 240 0zm85.5 176L208 176 208 58.5 325.5 176z"],
    "plane-slash": [576, 512, [], "e069", "M49.3-16.9l-17-17-33.9 33.9 17 17 512 512 17 17 33.9-33.9-17-17-175.5-175.5 7-7.6 127.3 0c30.9 0 56-25.1 56-56s-25.1-56-56-56l-127.3 0-168.7-184-80 0 31 92.9-125.8-125.8zm81 216.9l-24.6 0-57.6-72-48 0 32 128-32 128 48 0 57.6-72 99.7 0-61.3 184 80 0 96.7-105.5-190.5-190.5z"],
    "industry-windows": [512, 512, [127981, "industry-alt"], "f3b3", "M0 32l128 0 0 192 192-96 0 96 192-96 0 352-512 0 0-448zM288 320l-64 0 0 64 64 0 0-64zm-128 0l-64 0 0 64 64 0 0-64zm256 0l-64 0 0 64 64 0 0-64z"],
    "cloud-showers-heavy": [512, 512, [], "f740", "M96 320l-96 0 0-96c0-41.8 26.7-77.4 64-90.5L64 112c0-61.9 50.1-112 112-112 43.1 0 80.5 24.3 99.2 60 14.7-17.1 36.5-28 60.8-28 44.2 0 80 35.8 80 80l0 16c53 0 96 43 96 96l0 96-416 0zM62.7 368l50.6 0-48 144-50.6 0 48-144zm402.6 0l-48 144-50.6 0 48-144 50.6 0zm-120 0l-48 144-50.6 0 48-144 50.6 0zm-112 0l-48 144-50.6 0 48-144 50.6 0z"],
    "bed-bunk": [512, 512, [], "f8f8", "M64 32l0-32-64 0 0 512 64 0 0-64 384 0 0 64 64 0 0-512-288 0 0 128-160 0 0-96zM224 288l0 96-160 0 0-192 384 0 0 64-224 0 0 32zm-32 16a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM144 96a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"],
    "person-falling": [512, 512, [], "e546", "M320.3 32l0-32-64 0c0 13.7 0 50.3 0 109.9L189.5 150c-57.8 34.7-93.2 97.2-93.2 164.6 0 52.5 0 86.3 0 101.4l64 0c0-15.1 0-48.9 0-101.4 0-16.7 3.3-33 9.4-48l189.8 233.6 20.2 24.8 49.7-40.4-20.2-24.8-113.6-139.8 104.8 0c28.8 38.4 48 64 57.6 76.8l51.2-38.4c-8-10.7-30.4-40.5-67.2-89.6l-9.6-12.8-113 0-60.7-72.8c35.9-21.5 56.5-33.9 61.7-37l0-114.1zm-216 112a56 56 0 1 0 0-112 56 56 0 1 0 0 112z"],
    "square-chevron-down": [448, 512, ["chevron-square-down"], "f329", "M0 480l448 0 0-448-448 0 0 448zM207 345l-104-104-17-17 33.9-33.9 17 17 87 87 87-87 17-17 33.9 33.9-17 17-104 104-17 17-17-17z"],
    "butter": [640, 512, [129480], "e3e4", "M448 128l64 0 0 144 64 0 0-208-512 0 0 208 384 0 0-144zM64 320l-32 0 0 64 32 0 0 64 512 0 0-64 40 0 0-64-552 0z"],
    "turn-down": [384, 512, [10549, "level-down-alt"], "f3be", "M192 512l-192-192 128 0 0-192-128 0 0-128 256 0 0 320 128 0-192 192z"],
    "volume-slash": [576, 512, [128263], "f2e2", "M49.3-16.9l-17-17-33.9 33.9 17 17 512 512 17 17 33.9-33.9-17-17-241.2-241.2 0-246-137.3 108.7-133.6-133.6zM90.3 160l-58.2 0 0 192 96 0 192 152 0-114.2-229.8-229.8zM373 211.1l9.4 7.6c10.9 8.8 17.7 22.2 17.7 37.3 0 6.4-1.2 12.4-3.5 18L432 309.3c10.2-15.2 16.2-33.6 16.2-53.3 0-30.1-13.9-56.9-35.5-74.5l-10.9-8.8-28.8 38.4zM544.1 256c0-60.1-27.7-113.8-70.9-149l-13.7-11.2-28.8 38.4 12.3 10c32.5 26.4 53.2 66.7 53.2 111.8 0 33-11.1 63.4-29.8 87.7l34.2 34.2c27.2-33.1 43.6-75.6 43.6-121.9z"],
    "up-right-and-down-left-from-center": [512, 512, ["expand-alt"], "f424", "M512 0l0 208-71-71-96 96-17 17c-8.8-8.8-25.1-25.1-49-49l-17-17 17-17 96-96-71-71 208 0zM0 512l0-208 71 71 96-96 17-17c8.8 8.8 25.1 25.1 49 49l17 17-17 17-96 96 71 71-208 0z"],
    "user-tag": [640, 512, [], "f507", "M256 256a128 128 0 1 0 0-256 128 128 0 1 0 0 256zM364.1 512l-60.1-60.1 0-147.9-192 0-64 208 316.1 0zM352 288.1l0 144 144 144 144-144-144-144-144 0zM432 344a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"],
    "square-0": [448, 512, [], "e255", "M448 32l-448 0 0 448 448 0 0-448zM224 144c53 0 96 43 96 96l0 32c0 53-43 96-96 96s-96-43-96-96l0-32c0-53 43-96 96-96zm-48 96l0 32c0 26.5 21.5 48 48 48s48-21.5 48-48l0-32c0-26.5-21.5-48-48-48s-48 21.5-48 48z"],
    "inbox-in": [512, 512, [128229, "inbox-arrow-down"], "f310", "M423.5 96l24 192-79.5 0-32 64-160 0-32-64-79.5 0 24-192 335 0zM32 32l-32 256 0 192 512 0 0-192-32-256-448 0zM273 313c50.5-50.5 77.5-77.5 81-81L320 198.1c-10.3 10.3-23.6 23.6-40 40l0-110.1-48 0 0 110.1c-16.4-16.4-29.7-29.7-40-40L158.1 232c3.5 3.5 30.5 30.5 81 81l17 17 17-17z"],
    "kettlebell": [384, 512, [], "e832", "M352 168.9l-4.6 7.6-34.9 58.1c43.6 35.2 71.5 89 71.5 149.4 0 49.2-18.5 94-48.9 128L48.9 512C18.5 478 0 433.2 0 384 0 323.6 27.9 269.8 71.4 234.6L36.6 176.5 32 168.9 32 0 352 0 352 168.9zM96 151.1l31.2 52.1c20.2-7.2 42-11.2 64.8-11.2 22.7 0 44.5 4 64.7 11.2l31.3-52.1 0-87.1-192 0 0 87.1z"],
    "globe-snow": [448, 512, [], "f7a3", "M448 224c0 54.8-19.7 105.1-52.4 144l-65.6 0-60-64 66 0-112-112-112 112 66 0-60 64-65.6 0C19.7 329.1 0 278.8 0 224 0 100.3 100.3 0 224 0S448 100.3 448 224zM240 104a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm96 96a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm-232 8a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM16 480l57.6-64 300.8 0 57.6 64 0 32-416 0 0-32z"],
    "hand-sparkles": [640, 512, [], "e05d", "M352 0l0 256 32 0 0-224 64 0 0 224 32 0 0-160 64 0 0 171.5-44.6 104-57.7 24.7-9.7 4.2 0 63.3c3.4 1.5 16 6.8 37.6 16.1-28.7 20.3-63.7 32.2-101.6 32.2l-19.2 0c-59.6 0-116.9-22.9-160-64-74.8-71.2-116.3-110.7-124.5-118.6l55.2-57.9c16.9 16.1 41.1 39.1 72.6 69.1 0-1.5-.1-3.1-.1-4.6l0-304 64 0 0 224 32 0 0-256 64 0zM256 368l32 16 16 32 16-32 32-16-32-16-16-32-16 32-32 16zM56 120l24-56 24 56 56 24-56 24-24 56-24-56-56-24 56-24zM560 352l24 56 56 24-56 24-24 56-24-56-56-24 56-24 24-56z"],
    "file-ppt": [576, 512, [], "e64a", "M272 0l-240 0 0 512 144 0 0-176 240 0 0-192-144-144zm85.5 176L240 176 240 58.5 357.5 176zM240 380l-20 0 0 168 40 0 0-48 12 0c33.1 0 60-26.9 60-60s-26.9-60-60-60l-32 0zm32 80l-12 0 0-40 12 0c11 0 20 9 20 20s-9 20-20 20zm96-80l-20 0 0 168 40 0 0-48 12 0c33.1 0 60-26.9 60-60s-26.9-60-60-60l-32 0zm32 80l-12 0 0-40 12 0c11 0 20 9 20 20s-9 20-20 20zm76-80l0 40 32 0 0 128 40 0 0-128 32 0 0-40-104 0z"],
    "arrows-to-dot": [512, 512, [], "e4be", "M376 64l-88 0 0-64-64 0 0 64-88 0 120 128 120-128zM64 224l-64 0 0 64 64 0 0 88 128-120-128-120 0 88zm224 32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm160-32l0-88-128 120 128 120 0-88 64 0 0-64-64 0zM376 448l-120-128-120 128 88 0 0 64 64 0 0-64 88 0z"],
    "face-sad-cry": [512, 512, [128557, "sad-cry"], "f5b3", "M352 493.4c-29.6 12-62.1 18.6-96 18.6s-66.4-6.6-96-18.6l0-221.4-48 0 0 195.7C44.4 421.6 0 344 0 256 0 114.6 114.6 0 256 0S512 114.6 512 256c0 88-44.4 165.6-112 211.7l0-195.7-48 0 0 221.4zM208 336l0 32c0 26.5 21.5 48 48 48s48-21.5 48-48l0-32c0-26.5-21.5-48-48-48s-48 21.5-48 48zM132 216c0-11 9-20 20-20l16 0c11 0 20 9 20 20l0 16 40 0 0-16c0-33.1-26.9-60-60-60l-16 0c-33.1 0-60 26.9-60 60l0 16 40 0 0-16zm212-20l16 0c11 0 20 9 20 20l0 16 40 0 0-16c0-33.1-26.9-60-60-60l-16 0c-33.1 0-60 26.9-60 60l0 16 40 0 0-16c0-11 9-20 20-20z"],
    "image-slash": [576, 512, [], "e1b7", "M49.3-16.9l-17-17-33.9 33.9 17 17 512 512 17 17 33.9-33.9c-5.9-5.9-28-28-66.1-66.1l0-414-414 0-48.9-48.9zM179.8 113.6c3.9-1 8.1-1.6 12.4-1.6 26.5 0 48 21.5 48 48 0 4.3-.6 8.4-1.6 12.4l-58.8-58.8zM312.5 246.4l23.6-38.4 99.1 161.1-122.7-122.7zM410.3 480l-64-64-234.2 0 93.7-140.5-141.7-141.7 0 346.2 346.2 0z"],
    "trophy-star": [512, 512, ["trophy-alt"], "f2eb", "M96 0c0 22.6 .6 43.9 1.6 64L0 64 0 88c0 113.7 47.9 177.7 104.2 211.8 21.6 13.1 44 21.5 64.5 26.8 19.4 26.3 39.4 40.6 55.3 48.3l0 73.1-96 0 0 64 256 0 0-64-96 0 0-73.1c16.6-8 37.7-23.2 57.9-51.8 17.6-5.2 36.1-12.4 54.1-22.5 29.3-16.4 57.6-40.6 78.5-75.7 20.9-35.2 33.5-80.1 33.5-136.8l0-24-97.6 0c1-20.1 1.6-41.4 1.6-64L96 0zM48.8 112l52.4 0c6.5 63.6 18.3 112.3 32.8 149.6-1.7-.9-3.3-1.9-5-2.9-37.9-22.9-74.3-65-80.2-146.7zm388.3 88.4c-15.1 25.5-35.4 43.6-57.4 56.5 13.6-36.7 24.8-83.9 31-144.8l52.3 0c-2.9 37.4-12.7 66.1-25.9 88.4zm-154.8-71l58.9 8.6-42.6 41.5 10.1 58.6-52.7-27.7-52.7 27.7 10.1-58.6-42.6-41.5 58.9-8.6 26.3-53.4 26.3 53.4z"],
    "dong-sign": [384, 512, [], "e169", "M320-16l-64 0 0 64-128 0 0 48 128 0 0 72.2c-22.9-15.3-50.4-24.2-80-24.2-79.5 0-144 64.5-144 144S96.5 432 176 432c29.6 0 57.1-8.9 80-24.2l0 24.2 64 0 0-336 64 0 0-48-64 0 0-64zM96 288a80 80 0 1 1 160 0 80 80 0 1 1 -160 0zM384 464l-384 0 0 48 384 0 0-48z"],
    "square-cent": [448, 512, [], "e6f0", "M448 32l-448 0 0 448 448 0 0-448zM200 96l48 0 0 34.2c31.9 6.1 59.6 24 78.4 48.9L288 208c-14.6-19.5-37.9-32-64-32-44.2 0-80 35.8-80 80s35.8 80 80 80c26.2 0 49.4-12.5 64-32l38.4 28.8c-18.7 25-46.5 42.9-78.4 48.9l0 34.2-48 0 0-34.2C140.8 370.5 96 318.5 96 256s44.8-114.5 104-125.8L200 96z"],
    "people-line": [576, 512, [], "e534", "M288 0a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm64 384l0 32-128 0 0-32-32 0 0-112c0-53 43-96 96-96s96 43 96 96l0 112-32 0zm-208 0l0 32-80 0 0-32-32 0 0-96c0-53 43-96 96-96 12.7 0 24.8 2.5 35.9 6.9-12.6 21.4-19.9 46.4-19.9 73.1l0 112zm288 32l0-144c0-26.7-7.3-51.6-19.9-73.1 11.1-4.5 23.2-6.9 35.9-6.9 53 0 96 43 96 96l0 96-32 0 0 32-80 0zM128 32a56 56 0 1 1 0 112 56 56 0 1 1 0-112zm320 0a56 56 0 1 1 0 112 56 56 0 1 1 0-112zM24 464l552 0 0 48-576 0 0-48 24 0z"],
    "square-rss": [448, 512, ["rss-square"], "f143", "M448 32l-448 0 0 448 448 0 0-448zM96 112c150.2 0 272 121.8 272 272l-48 0c0-123.7-100.3-224-224-224l0-48zm0 96c97.2 0 176 78.8 176 176l-48 0c0-70.7-57.3-128-128-128l0-48zm0 144a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"],
    "island-tropical": [512, 512, [127965, "island-tree-palm"], "f811", "M112 96L62.2 96c0-36 38.4-96 128-96 58.4 0 95 25.5 113.5 53.2 19.9-12.6 46.5-21.2 80.3-21.2 89.6 0 128 60 128 96l-64 0-32-32-32 32-82.5 0c28 79.9 21.2 170.2 9.9 226.1 59.5 11 104.6 63.2 104.6 125.9l0 32-384 0 0-32c0-70.7 57.3-128 128-128l64 0c29.7-79.3 29.4-150.9 22.8-194l-98.9 98.9c-25.5-25.5-40.7-95 22.6-158.4 1.3-1.3 2.7-2.7 4.1-3.9L144 64 112 96z"],
    "clock-twelve": [512, 512, [], "e358", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm24-392l0 160-48 0 0-184 48 0 0 24z"],
    "calendar-minus": [448, 512, [], "f272", "M160 0l0 64 128 0 0-64 64 0 0 64 96 0 0 416-448 0 0-416 96 0 0-64 64 0zm-8 264l-24 0 0 48 192 0 0-48-168 0z"],
    "chart-diagram": [512, 512, [], "e695", "M480 32l-448 0 0 96 200 0 0 40-48 48-144 0 0 136-40 0 0 128 128 0 0-128-40 0 0-88 96 0 48 48 0 40-40 0 0 128 128 0 0-128-40 0 0-40 48-48 96 0 0 88-40 0 0 128 128 0 0-128-40 0 0-136-144 0-48-48 0-40 200 0 0-96z"],
    "ballot-check": [384, 512, [], "f733", "M384 0L0 0 0 512 384 512 384 0zM128 96l0 64-64 0 0-64 64 0zm0 256l0 64-64 0 0-64 64 0zm48 8l144 0 0 48-144 0 0-48zm24-256l120 0 0 48-144 0 0-48 24 0zm8 128l112 0 0 48-112 0 0-48zm-37.1-27.8c-1.6 2.1-21.4 28.6-59.5 79.4l-3.4 4.5-24 0-3.4-4.5c-18.1-24.1-29.9-39.9-35.5-47.4L75.8 213.1 96 240c25.3-33.7 40-53.3 44.2-58.9l30.7 23z"],
    "chf-sign": [640, 512, [], "e602", "M80 128c-8.8 0-16 7.2-16 16l0 224c0 8.8 7.2 16 16 16s16-7.2 16-16l0-16 64 0 0 16c0 44.2-35.8 80-80 80S0 412.2 0 368L0 144C0 99.8 35.8 64 80 64s80 35.8 80 80l0 16-64 0 0-16c0-8.8-7.2-16-16-16zM256 64l0 160 96 0 0-160 64 0 0 384-64 0 0-160-96 0 0 160-64 0 0-384 64 0zm192 0l192 0 0 64-128 0 0 96 96 0 0 64-96 0 0 160-64 0 0-384z"],
    "calendar-image": [448, 512, [], "e0d4", "M160 0l0 64 128 0 0-64 64 0 0 64 96 0 0 416-448 0 0-416 96 0 0-64 64 0zm0 192a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM352 384l0-48-128-112-128 112 0 48 256 0z"],
    "down-right": [448, 512, [], "e16b", "M416 448L416 96 296 216 112 32 0 144 184 328 64 448 416 448z"],
    "calendar-circle-user": [576, 512, [], "e471", "M192 32l0 32 128 0 0-64 64 0 0 64 96 0 0 112-448 0 0-112 96 0 0-64 64 0 0 32zM32 480l0-256 323.1 0c-67.8 29.6-115.1 97.3-115.1 176 0 28.6 6.2 55.6 17.4 80L32 480zm256-80a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm223.5 78.9l-15.5-30.9-128 0-15.5 30.9C372.8 499.4 400.9 512 432 512s59.2-12.6 79.5-33.1zM480 368a48 48 0 1 0 -96 0 48 48 0 1 0 96 0z"],
    "circle-share-nodes": [512, 512, [], "e6db", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM400 160c0 35.3-28.7 64-64 64-15.4 0-29.5-5.4-40.6-14.5l-85.3 46.5 85.3 46.5c11-9.1 25.2-14.5 40.6-14.5 35.3 0 64 28.7 64 64s-28.7 64-64 64-64-28.7-64-64c0-2.5 .1-4.9 .4-7.3L190.5 300c-11.7 12.3-28.2 20-46.5 20-35.3 0-64-28.7-64-64s28.7-64 64-64c18.3 0 34.8 7.7 46.5 20l81.9-44.7c-.3-2.4-.4-4.9-.4-7.3 0-35.3 28.7-64 64-64s64 28.7 64 64z"],
    "face-tired": [512, 512, [128555, "tired"], "f5c8", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm0-128c-48.9 0-93.5 16.8-127.4 44.3-.4-4.1-.6-8.2-.6-12.3 0-70.7 57.3-128 128-128s128 57.3 128 128c0 4.2-.2 8.3-.6 12.3-33.9-27.6-78.5-44.3-127.4-44.3zM135.2 145.7l95.6 48 9.2 4.6 0 20.2-10.2 4.3-95.6 40-14.7-28.3 44.2-27.6-45.3-34 16.8-27.1zm146 48l95.6-48 16.8 27.1-45.3 34 44.2 27.6-14.7 28.3-95.6-40-10.2-4.3 0-20.2 9.2-4.6z"],
    "diagram-previous": [448, 512, [], "e478", "M448 224l0-192-448 0 0 192 61.5 0c48.3-48.3 77.5-77.5 117.3-117.3 3.8-3.8 18.9-18.9 45.3-45.3 51 51 50.8 50.8 101.3 101.3 17.1 17.1 37.5 37.5 61.3 61.3l61.5 0zM0 288l0 192 448 0 0-192-192 0 0-64 62.6 0c-13.4-13.4-41.2-41.2-83.3-83.3l-11.3-11.3-11.3 11.3c-42.1 42.1-69.9 69.9-83.3 83.3l62.6 0 0 64-192 0z"],
    "face-astonished": [512, 512, [], "e36b", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm0-208c26.5 0 48 21.5 48 48l0 32c0 26.5-21.5 48-48 48s-48-21.5-48-48l0-32c0-26.5 21.5-48 48-48zM144 224a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm192-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM192 132c-4.2 0-8.4 .3-12.5 .8-20.3 2.7-38.9 11.9-53.8 25.8L111 172.3 83.7 143 98.3 129.4C119 110.1 145.2 97 174.3 93.2 180.1 92.4 186 92 192 92l20 0 0 40-20 0zm140.5 .8c-4.1-.5-8.3-.8-12.5-.8l-20 0 0-40 20 0c6 0 11.9 .4 17.7 1.2 29.1 3.8 55.3 17 75.9 36.2l14.6 13.7-27.3 29.2-14.6-13.7c-14.9-13.9-33.5-23.1-53.8-25.8z"],
    "ice-skate": [576, 512, [9976], "f7ac", "M320 96l-80 0 0 48 80 0 0 32-80 0 0 48 80 0 160 48 0 144-48 0 0 48 56 0c22.1 0 40-17.9 40-40l0-8 48 0 0 8c0 48.6-39.4 88-88 88l-488 0 0-48 96 0 0-48-32 0 0-352 192-32 0-32 64 0 0 96zM144 464l240 0 0-48-240 0 0 48z"],
    "arrow-u-turn-left-up": [576, 512, [], "e7ea", "M3 144l45.2 45.2 80-80 0 210.8c0 102.7 80.7 186.6 182.1 191.7l9.9 .3c106 0 192-86 192-192l0-256-64 0 0 256c0 70.7-57.3 128-128 128l-6.6-.2C246 444.4 192.3 388.5 192.2 320l0-210.8 80 80 45.3-45.2-157.3-157.2-157.2 157.2z"],
    "laptop-arrow-down": [640, 512, [], "e1c6", "M352 32l0-32-64 0 0 210.7c-17.4-17.4-33.4-33.4-48-48L194.7 208c5.5 5.5 39.7 39.7 102.6 102.6L320 333.3c5.5-5.5 39.7-39.7 102.6-102.6L445.3 208 400 162.7c-14.6 14.6-30.6 30.6-48 48L352 32zM96 32l-32 0 0 304 64 0 0-240 112 0 0-64-144 0zM512 96l0 240 64 0 0-304-176 0 0 64 112 0zM0 384l0 40 56 56 528 0 56-56 0-40-640 0z"],
    "user-circle-plus": [576, 512, [], "e7ab", "M224 248a120 120 0 1 0 0-240 120 120 0 1 0 0 240zm16 152c0-35 9.3-67.8 25.7-96L80 304 16 512 276 512c-22.7-31.5-36-70.2-36-112zM432 544a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm16-208l0 48 64 0 0 32-64 0 0 64-32 0 0-64-64 0 0-32 64 0 0-64 32 0 0 16z"],
    "raygun": [576, 512, [], "e025", "M192 64l96 0 0-32 48 0 0 288-48 0 0-32-112 224-128-64 80-160-16 0C50.1 288 0 237.9 0 176 0 131.3 26.2 92.8 64 74.8L64 0 192 64zm224 0l0 80 64 0 96-48 0 160-96-48-64 0 0 80-48 0 0-224 48 0zM136 176a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm72 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"],
    "hand-point-right": [512, 512, [], "f0a4", "M512 96l0 64-240 0 0-64 240 0zM352 288l0 64-128 0 0-64 128 0zm32-32l-112 0 0-64 112 0 0 64zM320 384l0 64-128 0 0-64 128 0zM149 64l91 0 0 192-80 0 0-112-32 0 0 144 64 0 0 64-32 0 0 96C71.6 448 0 376.4 0 288l0-61.7c0-42.4 16.9-83.1 46.9-113.1l11.6-11.6C82.5 77.5 115.1 64 149 64z"],
    "conveyor-belt-empty": [640, 512, [], "e150", "M96 320c-53 0-96 43-96 96s43 96 96 96l448 0c53 0 96-43 96-96s-43-96-96-96L96 320zm32 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm160 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm224-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "arrow-right-from-arc": [576, 512, [], "e4b1", "M96.3 256c0-106 86-192 192-192l32 0 0-64-32 0c-141.4 0-256 114.6-256 256s114.6 256 256 256l32 0 0-64-32 0c-106 0-192-86-192-192zM422.9 121.4L400.3 98.7 355 144c9.3 9.3 36 36 80 80l-242.7 0 0 64 242.7 0-80 80 45.3 45.3 157.3-157.3c-.2-.2-45.1-45.1-134.6-134.6z"],
    "signal-stream-slash": [576, 512, [], "e250", "M49.3-16.9l-17-17-33.9 33.9 17 17 512 512 17 17 33.9-33.9c-5.3-5.3-28.7-28.7-70.2-70.2 42.4-50.2 68-115.1 68-185.9 0-79.5-32.2-151.5-84.3-203.6L442.7 93.9c42.8 40.8 69.5 98.4 69.5 162.1 0 53.2-18.5 102-49.5 140.5l-34.2-34.2c22.4-29.5 35.7-66.3 35.7-106.3 0-52-22.6-98.8-58.4-131L356 166.9c26.8 20.5 44.2 52.8 44.2 89.1 0 22.2-6.5 42.9-17.6 60.3l-48-48c1-3.9 1.6-8.1 1.6-12.4 0-26.5-21.5-48-48-48-4.3 0-8.4 .6-12.4 1.6L49.3-16.9zm74.3 210.2c-7.4 19.5-11.5 40.6-11.5 62.7 0 52 22.6 98.8 58.4 131l49.7-41.9c-26.8-20.5-44.2-52.8-44.2-89.1 0-3.3 .1-6.5 .4-9.8l-52.9-52.9zM40 109.7C14.7 152.6 .1 202.6 .1 256 .1 335.5 32.3 407.5 84.4 459.6l49.2-41.4c-42.8-40.8-69.5-98.4-69.5-162.1 0-35.6 8.3-69.2 23.1-99.1L40 109.7z"],
    "court-sport": [640, 512, [], "e643", "M640 480l-296 0 0-114.6c50.3-11 88-55.8 88-109.4s-37.7-98.4-88-109.4l0-114.6 296 0 0 96-128 0 0 256 128 0 0 96zM296 146.6c-50.3 11-88 55.8-88 109.4s37.7 98.4 88 109.4l0 114.6-296 0 0-96 128 0 0-256-128 0 0-96 296 0 0 114.6zm0 168.8c-23.5-9.5-40-32.5-40-59.3s16.5-49.9 40-59.3l0 118.7zm48 0l0-118.7c23.5 9.5 40 32.5 40 59.3s-16.5 49.9-40 59.3zM560 176l80 0 0 160-80 0 0-160zM80 336l-80 0 0-160 80 0 0 160z"],
    "train-track": [512, 512, [], "e453", "M119 96l16-64 66 0c-.3 1.1-5.6 22.4-16 64l142 0c-10.4-41.6-15.7-62.9-16-64l66 0 16 64 55 0 0 64-39 0 16 64 55 0 0 64-39 0 16 64 55 0 0 64-39 0c10.4 41.6 15.7 62.9 16 64l-66 0-16-64-302 0-16 64-66 0c.3-1.1 5.6-22.4 16-64l-39 0 0-64 55 0 16-64-39 0 0-64 55 0 16-64-39 0 0-64 55 0zm50 64l-16 64 206 0-16-64-174 0zM375 288l-238 0-16 64 270 0-16-64z"],
    "user-microphone": [576, 512, [], "e7b2", "M224 8a120 120 0 1 1 0 240 120 120 0 1 1 0-240zm48 360.2c0 59.4 29.4 111.9 74.5 143.8l-330.5 0 64-208 192 0 0 64.2zM400 224l96 0 0 144c0 26.5-21.5 48-48 48s-48-21.5-48-48l0-144zM368 336l0 32c0 44.2 35.8 80 80 80s80-35.8 80-80l0-32 48 0 0 32c0 62.5-44.8 114.5-104 125.8l0 50.2-48 0 0-50.2C364.8 482.5 320 430.5 320 368l0-32 48 0z"],
    "cars": [576, 512, [], "f85b", "M96.1-.1l192 .5 24.1 .1c1.3 4.5 12 41.7 32 111.7l-66.6-.2-13.7-47.6-143.8-.4-18.3 64 121.2 0-32 112.1-47.1 0 0 63.9-80 0 0 48-64 0 0-224 35.3 0C59.1 44.5 71.3 1.8 71.9-.2L96.1-.1zM128 223.5a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm135.9-63.7l24.2 .1 192 .5 24.1 .1c.5 1.9 12.7 44.4 36.6 127.6l35.3 0 0 224-64 0 0-48-256 0 0 48-64 0 0-224 35.3 0c23.9-83.5 36.1-126.2 36.6-128.2zm192 64.5l-143.8-.4-18.3 64 180.3 0-18.3-63.7zM288 415.5a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm224-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "nfc-pen": [640, 512, [], "e1fa", "M64 32l448 0 0 171.7-64 64 0-171.7-184 0 0 118.4c-14.3 8.3-24 23.8-24 41.6 0 26.5 21.5 48 48 48s48-21.5 48-48c0-17.8-9.7-33.3-24-41.6l0-70.4 88 0 0 171.7-52.3 52.3-171.7 0 0-224 40 0 0-48-88 0 0 320 171.7 0-8.9 8.9-9.2 55.1-217.6 0 0-448zM544 239.9l80 80-52.8 52.8-80-80 52.8-52.8zm-208 208l132.6-132.6 80 80-132.6 132.6-96 16 16-96z"],
    "arrow-up": [448, 512, [8593], "f062", "M246.9 17.4l-22.6-22.6-22.6 22.6-160 160-22.6 22.6 45.3 45.3c1.3-1.3 44-44 128-128l0 402.7 64 0 0-402.7c84 84 126.7 126.7 128 128l45.3-45.3-22.6-22.6-160-160z"],
    "xmark-large": [576, 512, [], "e59b", "M534.9 54.6L557.5 32 512.3-13.3 489.6 9.4 288.3 210.7 86.9 9.4 64.3-13.3 19 32 41.6 54.6 243 256 41.6 457.4 19 480 64.3 525.3 86.9 502.6 288.3 301.3 489.6 502.6 512.3 525.3 557.5 480 333.5 256 534.9 54.6z"],
    "cubes-stacked": [512, 512, [], "e4e6", "M192 0l128 0 0 128-128 0 0-128zM320 384l0 128-128 0 0-128 128 0zm192 0l0 128-128 0 0-128 128 0zM416 192l0 128-128 0 0-128 128 0zM160 165.5L250.5 256 160 346.5 69.5 256 160 165.5zM128 384l0 128-128 0 0-128 128 0z"],
    "child-combatant": [576, 512, ["child-rifle"], "e4e0", "M160 128a64 64 0 1 0 0-128 64 64 0 1 0 0 128zm-43.1 32l-16 0-9.6 12.8C34.4 248.5 4 289 0 294.4l51.2 38.4c14.4-19.2 24-32 28.8-38.4l0 217.6 64 0 0-128 32 0 0 128 64 0 0-217.6c4.8 6.4 14.4 19.2 28.8 38.4l51.2-38.4-91.3-121.6-9.6-12.8-102.1 0zM464 0l-64 0 0 32 16 0 0 96-16 0 0 64-32 0 0 208 48 0 0 112 96 0-28-112 60 0 0-48-64 0 0-26.7 64-21.3 0-112-48 0 0 72-16 5.3 0-141.3-16 0 0-128z"],
    "square-g": [448, 512, [], "e271", "M448 32l-448 0 0 448 448 0 0-448zM224 184c-39.8 0-72 32.2-72 72s32.2 72 72 72c28.3 0 52.7-16.3 64.5-40l-56.5 0 0-48 112 0 0 21-.4 5c-5.1 61.6-56.7 110-119.6 110-66.3 0-120-53.7-120-120s53.7-120 120-120c30.7 0 58.8 11.6 80 30.6l-32 35.8c-12.8-11.4-29.5-18.3-48-18.3z"],
    "vest-patches": [448, 512, [], "e086", "M200 288l0 224-200 0 0-256 64-96 0-160 84.4 0 6.9 11.1 .3 .4c.4 .6 1.2 1.5 2.3 2.8 2.3 2.6 6.1 6.3 11.5 10.1 10.6 7.4 28.1 15.6 54.7 15.6s44.1-8.2 54.7-15.6c5.4-3.8 9.2-7.5 11.4-10.1 1.1-1.3 1.9-2.3 2.3-2.8l.3-.4 6.9-11.1 84.4 0 0 160 64 96 0 256-200 0 0-224 55.6-222.6C285.8 77.3 259.6 88 224 88s-61.8-10.7-79.6-22.6L200 288zM96 456a40 40 0 1 0 0-80 40 40 0 1 0 0 80zM72 247L55 264c4.5 4.5 12.5 12.5 24 24-11.5 11.5-19.5 19.5-24 24l17 17c4.5-4.5 12.5-12.5 24-24 11.5 11.5 19.5 19.5 24 24l17-17c-4.5-4.5-12.5-12.5-24-24 11.5-11.5 19.5-19.5 24-24l-17-17c-4.5 4.5-12.5 12.5-24 24-11.5-11.5-19.5-19.5-24-24zm232 33l0 56 56 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-8 0 0-8c0-13.3-10.7-24-24-24s-24 10.7-24 24z"],
    "image-circle-plus": [640, 512, [], "e76e", "M512 32l-448 0 0 448 276 0c-13.7-19-24-40.7-30-64l-198 0 96-144 46.1 69.1 81.9-133.1 18.6 30.2c35.1-38.2 85.5-62.2 141.4-62.2 5.4 0 10.7 .2 16 .7L512 32zM192 112a48 48 0 1 1 0 96 48 48 0 1 1 0-96zM496 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm16-208l0 48 64 0 0 32-64 0 0 64-32 0 0-64-64 0 0-32 64 0 0-64 32 0 0 16z"],
    "martini-glass-empty": [512, 512, ["glass-martini"], "f000", "M0 80l16 16 194.7 194.7 13.3 13.3 0 144-96 0 0 64 256 0 0-64-96 0 0-144 224-224 0-48-512 0 0 48zM106.5 96L405.5 96 256 245.5 106.5 96z"],
    "circle-lari": [512, 512, [], "e71d", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm0-375.9c1.3 0 2.7-.1 4-.1 4 0 8.1 .2 12 .6l0-24.6 32 0 0 32c39.3 14.9 69 49.2 77.5 91.2l4.2 20.8-49 0-2.3-11.2C330.6 225.6 319.4 209 304 198l0 42-32 0 0-55.1c-3.9-.6-7.9-.9-12-.9-1.3 0-2.7 0-4 .1l0 55.9-32 0 0-46.9c-23.8 12.8-40 38-40 66.9 0 42 34 76 76 76l108 0 0 48-224 0 0-48 18 0c-16.3-21-26-47.4-26-76 0-56 37.1-103.3 88-118.7l0-29.3 32 0 0 24.1z"],
    "kidneys": [640, 512, [], "f5fb", "M265.7 34.5C231.8-6.2 171.3-11.7 130.5 22.3l-10 8.3C44.2 94.2 0 188.5 0 288 0 341 43 384 96 384s96-43 96-96c0-5.9 .4-11.8 1.1-17.7l30.9 30.9 0 210.7 64 0 0-237.3-9.4-9.4-60.2-60.2c7.1-10 15.5-19.1 25.1-27.1l10-8.3c40.7-33.9 46.2-94.5 12.3-135.2zM446.9 270.3c.7 5.8 1.1 11.7 1.1 17.7 0 53 43 96 96 96s96-43 96-96c0-99.5-44.2-193.8-120.6-257.4l-10-8.3C468.7-11.7 408.2-6.2 374.2 34.5s-28.4 101.3 12.3 135.2l10 8.3c9.6 8 18 17.1 25.1 27.1l-60.2 60.2-9.4 9.4 0 237.3 64 0 0-210.7 30.9-30.9z"],
    "brackets-curly": [576, 512, [], "f7ea", "M64 32l160 0 0 64-96 0 0 109.3c-.9 .9-17.8 17.8-50.7 50.7 32.9 32.9 49.8 49.8 50.7 50.7l0 109.3 96 0 0 64-160 0 0-146.7-54.6-54.6-9.4-9.4 0-26.5 9.4-9.4 54.6-54.6 0-146.7zm448 0l0 146.7 54.6 54.6 9.4 9.4 0 26.5-64 64 0 146.7-160 0 0-64 96 0 0-109.3 50.7-50.7c-32.9-32.9-49.8-49.8-50.7-50.7l0-109.3-96 0 0-64 160 0z"],
    "person-soccer": [576, 512, [], "e789", "M344 24a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zM128 112l-21.7 0c-1.4 3.4-14.7 36.8-40 100.1l-11.9 29.7 59.4 23.8c5.9-14.8 17.9-44.7 35.8-89.6l41.4 0-22.7 90.6c-8.3 33.2 11 67 43.7 76.8L308 372.2c-38.9 87.5-59.6 134.1-62.2 140l58.5 26 13-29.2c50.9-114.5 77.1-173.5 78.8-177.2-13.5-4.1-56.1-16.8-127.6-38.3l20.7-70.4c14.5 24.8 24 41.1 28.5 48.8l130.4 0 0-64-93.6 0-28.2-48.4C309 130.1 277.4 112 243.3 112L128 112zm4.8 284.9C62.7 454.8 24.7 486.1 19 490.8l40.7 49.4c4.6-3.8 44.8-36.9 120.7-99.5l6.8-5.6c.3-.9 5.6-15.7 15.8-44.3l-4.7-1.4c-20.4-6.1-37.9-17.6-51.2-32.4l-14.3 40zM480 544a64 64 0 1 0 0-128 64 64 0 1 0 0 128z"],
    "diamond-exclamation": [576, 512, [], "e405", "M560 256L288 528 16 256 288-16 560 256zM260 324l0 56 56 0 0-56-56 0zm-4-196l12.8 160 38.4 0 12.8-160-64 0z"],
    "magnet": [448, 512, [129522], "f076", "M0 176L0 288C0 411.7 100.3 512 224 512S448 411.7 448 288l0-112-128 0 0 112c0 53-43 96-96 96s-96-43-96-96l0-112-128 0zm0-48l128 0 0-96-128 0 0 96zm320 0l128 0 0-96-128 0 0 96z"],
    "road-barrier": [640, 512, [], "e562", "M64 64l0-32-64 0 0 448 64 0 0-213.7 85.2-170.3-85.2 0 0-32zm576 0l0-32-64 0 0 85.7-85.2 170.3 85.2 0 0 192 64 0 0-416zM330.8 96l-5.4 10.7-90.6 181.3 74.3 0 5.4-10.7 90.6-181.3-74.3 0zM437.2 288l5.4-10.7 90.6-181.3-74.3 0-5.4 10.7-90.6 181.3 74.3 0zM277.2 96l-74.3 0-5.4 10.7-90.6 181.3 74.3 0 5.4-10.7 90.6-181.3z"],
    "compass-drafting": [512, 512, ["drafting-compass"], "f568", "M352 96c0 14.1-3.1 27.6-8.6 39.7l45.3 75.9c-23.3 26.7-54.3 46.2-89.5 55.1L256 192 188 309.5c21.5 6.8 44.3 10.5 68 10.5 82.9 0 155.3-45 194.1-112l55.4 32c-49.7 86-142.8 144-249.4 144-35.4 0-69.4-6.4-100.7-18.1L91.4 476.2 0 512 0 417.8 64 310.7C41.3 290.4 21.9 266.5 6.6 240l55.4-32c9.8 17 21.9 32.6 35.7 46.4l70.9-118.7c-5.5-12.1-8.5-25.5-8.5-39.7 0-53 43-96 96-96s96 43 96 96zm29 311.9c33.7-13.5 64.7-32.3 92-55.4l39 65.3 0 94.2-91.4-35.8-39.5-68.2zM256 128a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "rectangle": [512, 512, [9644, "rectangle-landscape"], "f2fa", "M0 64l512 0 0 384-512 0 0-384z"],
    "hand-holding-skull": [576, 512, [], "e1a4", "M432 104c0-66.3-64.5-120-144-120S144 37.7 144 104c0 35.5 18.5 67.5 48 89.4l0 62.6 192 0 0-62.6c29.5-22 48-53.9 48-89.4zM240 80a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm64 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM137.4 313.4l-70.6 70.6-66.7 0 0 128 396.4 0 10.2-7c101.2-69.6 154.8-106.4 161-110.7l-45.3-65.9c-11.7 8.1-54.2 37.3-127.5 87.6l-138.8 0 0-48 128 0 0-64-237.3 0-9.4 9.4z"],
    "square-person-confined": [448, 512, [], "e577", "M0 32l448 0 0 448-448 0 0-448zM256 144a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zm18.7 48c-5.1 5.1-13.6 13.6-25.4 25.4l-9.4 9.4 0 13.3 0 66.7-41.4-41.4-51.2 8.3C63.2 442 93.5 381.4 76.2 416l71.6 0c35.5-71 34.6-69.2 37-74l54.7 54.7c12.4 12.4 29.1 19.3 46.6 19.3 36.4 0 65.9-29.5 65.9-65.9l0-158.1-77.3 0z"],
    "grid": [448, 512, ["grid-3"], "e195", "M0 32l112 0 0 112-112 0 0-112zM0 200l112 0 0 112-112 0 0-112zM112 368l0 112-112 0 0-112 112 0zM168 32l112 0 0 112-112 0 0-112zM280 200l0 112-112 0 0-112 112 0zM168 368l112 0 0 112-112 0 0-112zM448 32l0 112-112 0 0-112 112 0zM336 200l112 0 0 112-112 0 0-112zM448 368l0 112-112 0 0-112 112 0z"],
    "cabinet-filing": [384, 512, [128452], "f64b", "M0 0L0 224 384 224 384 0 0 0zM0 272l0 240 384 0 0-240-384 0zM96 80l192 0 0 80-48 0 0-32-96 0 0 32-48 0 0-80zm0 272l192 0 0 80-48 0 0-32-96 0 0 32-48 0 0-80z"],
    "plate-wheat": [512, 512, [], "e55a", "M400 32c44.2 0 80 35.8 80 80l0 32-16 0c-44.2 0-80-35.8-80-80l0-32 16 0zM56 64l72 0 0 48-96 0 0-48 24 0zM24 136l136 0 0 48-160 0 0-48 24 0zm8 72l96 0 0 48-96 0 0-48zM272 32l16 0c44.2 0 80 35.8 80 80l0 32-16 0c-44.2 0-80-35.8-80-80l0-32zm-96 0c44.2 0 80 35.8 80 80l0 32-16 0c-44.2 0-80-35.8-80-80l0-32 16 0zM480 176l0 32c0 44.2-35.8 80-80 80l-16 0 0-32c0-44.2 35.8-80 80-80l16 0zm-128 0l16 0 0 32c0 44.2-35.8 80-80 80l-16 0 0-32c0-44.2 35.8-80 80-80zm-96 0l0 32c0 44.2-35.8 80-80 80l-16 0 0-32c0-44.2 35.8-80 80-80l16 0zM96 444C40.8 429.8 0 379.6 0 320l512 0c0 59.6-40.8 109.8-96 124l0 36-320 0 0-36z"],
    "rectangle-vertical-history": [512, 512, [], "e237", "M480 0l-272 0 0 512 272 0 0-512zM104 48l0 416 48 0 0-416-48 0zM0 96l0 320 48 0 0-320-48 0z"],
    "sign-hanging": [512, 512, ["sign"], "f4d9", "M128 0l0 64 384 0 0 64-384 0 0 384-64 0 0-384-64 0 0-64 64 0 0-64 64 0zM480 176l0 208-304 0 0-208 304 0z"],
    "circle-8": [512, 512, [], "e0f5", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM176 212c0-37.6 30.4-68 68-68l24 0c37.6 0 68 30.4 68 68 0 14.7-4.6 28.2-12.5 39.3 12.7 12.3 20.5 29.6 20.5 48.7 0 37.6-30.4 68-68 68l-40 0c-37.6 0-68-30.4-68-68 0-19.1 7.9-36.3 20.5-48.7-7.9-11.1-12.5-24.7-12.5-39.3zm112 0c0-11-9-20-20-20l-24 0c-11 0-20 9-20 20s9 20 20 20l24 0c11 0 20-9 20-20zm-52 68c-11 0-20 9-20 20s9 20 20 20l40 0c11 0 20-9 20-20s-9-20-20-20l-40 0z"],
    "car-battery": [512, 512, ["battery-car"], "f5df", "M80 32l128 0 0 32 96 0 0-32 128 0 0 32 80 0 0 384-512 0 0-384 80 0 0-32zM392 184l0-24-48 0 0 56-56 0 0 48 56 0 0 56 48 0 0-56 56 0 0-48-56 0 0-32zM64 216l0 48 160 0 0-48-160 0z"],
    "shirt": [640, 512, [128085, "t-shirt", "tshirt"], "f553", "M320 112c44.2 0 80-35.8 80-80l80 0 160 160-96 96-64-64 0 288-320 0 0-288-64 64-96-96 160-160 80 0c0 44.2 35.8 80 80 80z"],
    "paragraph": [448, 512, [182], "f1dd", "M160 0l288 0 0 64-64 0 0 448-64 0 0-448-48 0 0 448-64 0 0-192-48 0C71.6 320 0 248.4 0 160S71.6 0 160 0z"],
    "envelopes-bulk": [576, 512, ["mail-bulk"], "f674", "M448 0l0 80-304 0 0 128-80 0 0-208 384 0zM192 160l0-32 384 0 0 288-208 0 0-208-176 0 0-48zm320 32l-96 0 0 96 96 0 0-96zM320 256l0 58.3-160 84-160-84 0-58.3 320 0zm0 112.6l0 143.4-320 0 0-143.4 148.8 78.2 11.2 5.9 11.2-5.9 148.8-78.2z"],
    "file-doc": [576, 512, [], "e5ed", "M272 0l-240 0 0 512 144 0 0-176 240 0 0-192-144-144zm85.5 176L240 176 240 58.5 357.5 176zM240 380l-20 0 0 168 52 0c28.7 0 52-23.3 52-52l0-64c0-28.7-23.3-52-52-52l-32 0zm20 128l0-88 12 0c6.6 0 12 5.4 12 12l0 64c0 6.6-5.4 12-12 12l-12 0zM392 380c-24.3 0-44 19.7-44 44l0 80c0 24.3 19.7 44 44 44l16 0c24.3 0 44-19.7 44-44l0-80c0-24.3-19.7-44-44-44l-16 0zm-4 44c0-2.2 1.8-4 4-4l16 0c2.2 0 4 1.8 4 4l0 80c0 2.2-1.8 4-4 4l-16 0c-2.2 0-4-1.8-4-4l0-80zm88 0l0 80c0 24.3 19.7 44 44 44l16 0c24.3 0 44-19.7 44-44l0-16-40 0 0 16c0 2.2-1.8 4-4 4l-16 0c-2.2 0-4-1.8-4-4l0-80c0-2.2 1.8-4 4-4l16 0c2.2 0 4 1.8 4 4l0 16 40 0 0-16c0-24.3-19.7-44-44-44l-16 0c-24.3 0-44 19.7-44 44z"],
    "guitar": [512, 512, [], "f7a6", "M376 64l-8.9 35.7-82.5 82.5c-45.1-29.4-99.3-30.2-131 1.6-11 11-18 24.6-21.4 39.6-3.7 16.6-19.1 30.7-36.1 31.6-25.6 1.3-49.3 10.7-67.3 28.6-44.8 44.8-36.4 125.8 18.7 180.9S183.6 528 228.4 483.2c17.9-17.9 27.4-41.7 28.6-67.3 .9-17 15-32.3 31.6-36.1 15-3.4 28.6-10.5 39.6-21.4 31.8-31.8 31-85.9 1.6-131l82.5-82.5 35.7-8.9 64-72-64-64-72 64zM208 256a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"],
    "flying-disc": [448, 512, [], "e3a9", "M23.7 456.3c-20.7-20.7-27.3-52.3-21.9-89.7 2 3 4.2 5.9 6.7 8.7l3.5 3.7 3.7 3.5c18.9 16.7 42.3 21.9 62.7 21.7 21.6-.2 43.6-6.1 64.2-14.5 41.4-17 86.2-48.3 126.4-88.6s71.5-85 88.6-126.4c8.5-20.6 14.4-42.6 14.5-64.2 .2-21.8-5.7-46.9-25.2-66.4-3.9-3.9-8.1-7.3-12.4-10.2 37.4-5.5 69.1 1.2 89.7 21.9 55.3 55.3 10.5 189.8-100.2 300.5S79 511.6 23.7 456.3zM235.1 267.1C161.4 340.9 76.7 375.8 45.9 345s4.1-115.4 77.9-189.2 158.4-108.6 189.2-77.9-4.1 115.4-77.9 189.2z"],
    "suitcase": [512, 512, [129523], "f0f2", "M168 0l-24 0 0 480 224 0 0-480-200 0zM416 96l0 384 96 0 0-384-96 0zM0 96l0 384 96 0 0-384-96 0zm320 0l-128 0 0-48 128 0 0 48z"],
    "circle-up": [512, 512, [61467, "arrow-alt-circle-up"], "f35b", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM128 256l0-8 128-128 128 128 0 8-80 0 0 128-96 0 0-128-80 0z"],
    "f": [320, 512, [102], "46", "M32 32l-32 0 0 448 64 0 0-192 192 0 0-64-192 0 0-128 256 0 0-64-288 0z"],
    "xmarks-lines": [640, 512, [], "e59a", "M32 32l-32 0 0 64 640 0 0-64-608 0zm0 384l-32 0 0 64 640 0 0-64-608 0zM57 183L40 166.1 6.1 200c7.6 7.6 26.3 26.3 56 56-29.7 29.7-48.4 48.4-56 56L40 345.9c7.6-7.6 26.3-26.3 56-56 29.7 29.7 48.4 48.4 56 56L185.9 312c-7.6-7.6-26.3-26.3-56-56l56-56-33.9-33.9c-7.6 7.6-26.3 26.3-56 56L57 183zm224 0l-17-17-33.9 33.9 56 56c-29.7 29.7-48.4 48.4-56 56L264 345.9c7.6-7.6 26.3-26.3 56-56 29.7 29.7 48.4 48.4 56 56L409.9 312c-7.6-7.6-26.3-26.3-56-56 29.7-29.7 48.4-48.4 56-56L376 166.1c-7.6 7.6-26.3 26.3-56 56l-39-39zm224 0l-17-17-33.9 33.9c7.6 7.6 26.3 26.3 56 56-29.7 29.7-48.4 48.4-56 56L488 345.9c7.6-7.6 26.3-26.3 56-56 29.7 29.7 48.4 48.4 56 56L633.9 312c-7.6-7.6-26.3-26.3-56-56 29.7-29.7 48.4-48.4 56-56L600 166.1c-7.6 7.6-26.3 26.3-56 56l-39-39z"],
    "hashtag-lock": [640, 512, [], "e415", "M186.7 128l27.4-128 65.5 0-27.4 128 126.5 0 27.4-128 65.5 0-27.4 128 99.9 0-10.3 48.1c-1.9-.1-3.8-.1-5.8-.1-22.5 0-43.6 5.8-62 16l-35.6 0-8.7 40.6C408 253 400 277.6 400 304l-32 0 0 179.4-6.1 28.6-65.5 0 27.4-128-126.5 0-27.4 128-65.5 0 27.4-128-99.9 0 13.7-64 99.9 0 27.4-128-99.9 0 13.7-64 99.9 0zm51.7 64l-27.4 128 126.5 0 27.4-128-126.5 0zM528 272c-17.7 0-32 14.3-32 32l0 48 64 0 0-48c0-17.7-14.3-32-32-32zm-80 32c0-44.2 35.8-80 80-80s80 35.8 80 80l0 48 32 0 0 192-224 0 0-192 32 0 0-48z"],
    "garage-open": [576, 512, [], "e00b", "M0 512l0-416 288-96 288 96 0 416-64 0 0-320-448 0 0 320-64 0zM207.1 240l175.7 0 0 0 81.2 0 0 48-352 0 0-48 81.2 0 0 0 13.9 0zm230.8 96c5.2 9.1 8.6 15 10.1 17.6l0 158.4-64 0 0-48-192 0 0 48-64 0 0-158.4c1.5-2.6 4.9-8.5 10.1-17.6l299.8 0zM208 424a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm184-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"],
    "gas-pump-left": [640, 512, [], "e778", "M192 0l288 0 0 256 80 0 0 112 32 0 0-176-48 0 0-91.5c-18.8-20.7-32.7-36-41.9-46.1l35.5-32.3 16.1 17.8 80 88 6.2 6.9 0 281.3-128 0 0-112-32 0 0 208-288 0 0-512zm64 64l0 128 160 0 0-128-160 0zM0 256l128-96 0 192-128-96z"],
    "pump-impeller": [512, 512, [], "e835", "M374.2 356l5.3 53.5 1.1 11.1-6 9.3c-29.9 46.5-48.7 75.9-56.5 88.1l-53.9-34.6c8.9-13.8 25.7-40.1 50.5-78.8-2.9-30.1-5.3-54.8-7.3-74.3l63.7-6.2 3.1 31.8zm-85 29.5c-11.2 13.7-29.4 35.8-54.4 66.3l-7.1 8.6-10.8 2.3c-54 11.8-88.1 19.2-102.3 22.3l-13.7-62.5c16-3.5 46.5-10.2 91.4-20 19.2-23.3 35-42.5 47.4-57.7l49.4 40.6zM410.3 243.2l41.6 34.1 8.6 7.1 2.3 10.8c11.8 54 19.2 88.1 22.3 102.3l-62.5 13.7c-3.5-16-10.2-46.5-20-91.4-23.3-19.2-42.5-35-57.7-47.4l40.6-49.4 24.7 20.3zM55.5 281.3l51.8 33.3c30.1-2.9 54.8-5.3 74.3-7.3l6.2 63.7c-17.6 1.7-46.1 4.5-85.4 8.4l-11.1 1.1-9.3-6-61.2-39.3-26.9-17.2 34.6-53.9 26.9 17.3zM255.9 296a40 40 0 1 1 .1-80 40 40 0 1 1 -.1 80zM96.3 132.1l13.2 60.2c23.3 19.2 42.5 35 57.7 47.4l-40.6 49.4c-13.7-11.2-35.8-29.4-66.3-54.4l-8.6-7.1-2.3-10.8c-11.8-54-19.2-88.1-22.3-102.3l62.5-13.7 6.8 31.3zM430 137.6c46.5 29.9 75.9 48.7 88.1 56.5L483.6 248c-13.8-8.9-40.1-25.7-78.8-50.5-30.1 2.9-54.8 5.3-74.3 7.2L324.3 141c17.6-1.7 46.1-4.5 85.4-8.4l11.1-1.1 9.3 6zM248 28.5c-8.9 13.8-25.7 40.1-50.5 78.8 2.9 30.1 5.3 54.8 7.2 74.3l-63.7 6.2c-1.7-17.6-4.5-46.1-8.4-85.4l-1.1-11.1 6-9.3c29.9-46.5 48.7-75.9 56.5-88.1L248 28.5zM411.3 89.4c-16 3.5-46.5 10.2-91.4 20-19.2 23.3-35 42.5-47.4 57.7L223 126.5c11.2-13.7 29.4-35.8 54.4-66.3l7.1-8.6 10.8-2.3c54-11.8 88.1-19.2 102.3-22.3l13.7 62.5z"],
    "basket-shopping-plus": [576, 512, [], "e653", "M288-10.9l17.4 18.4 144 152 .5 .5 110.1 0 0 64-23.1 0-56.9 256-384 0-56.9-256-23.1 0 0-64 110.1 0 .5-.5 144-152 17.4-18.4zm0 69.8L192.2 160 383.8 160 288 58.9zM264 416l48 0 0-72 72 0 0-48-72 0 0-72-48 0 0 72-72 0 0 48 72 0 0 72z"],
    "hand-fingers-crossed": [384, 512, [], "e1a3", "M101 35.6l-13.5-29-58 27.1C35.4 46.4 50.6 78.9 75 131.3l35.3-75.7-9.4-20.1zM165.6 240l26.4 0 0-9.4-11-23.7-15.4 33zM288 320l-64 0 0 64-144 0 0-32 112 0 0-80-192 0 0 91c0 33.9 13.5 66.5 37.5 90.5l11.6 11.6c30 30 70.7 46.9 113.1 46.9l61.7 0c88.4 0 160-71.6 160-160l-96 0 0-32zM212.9 63l13.5-29-58-27.1-13.5 29-95.2 204.1 70.6 0 82.6-177zM224 160l0 128 64 0 0-128-64 0zm96 32l0 128 64 0 0-128-64 0z"],
    "brain-arrow-curved-right": [640, 512, ["mind-share"], "f677", "M184 56c0-30.9 25.1-56 56-56l56 0 0 365.9c-5.2 15.8-8 32.6-8 50.1 0 17.3 3.1 33 8 46.9l0 49.1-64 0c-29.8 0-54.9-20.4-62-48-.7 0-1.3 0-2 0-44.2 0-80-35.8-80-80 0-18 6-34.6 16-48-19.4-14.6-32-37.8-32-64 0-30.9 17.6-57.8 43.2-71.1-7.1-12-11.2-26-11.2-40.9 0-44.2 35.8-80 80-80l0-24zM464 192l0 64-16 0c-39.7 0-76 14.5-104 38.4L344 0 400 0c30.9 0 56 25.1 56 56l0 24c44.2 0 80 35.8 80 80 0 11.4-2.4 22.2-6.7 32L464 192zm64 48l112 112-112 112-16 0 0-64-48 0c-35.3 0-64 28.7-64 64l0 48s-64-32-64-96c0-61.9 50.1-112 112-112l64 0 0-64 16 0z"],
    "person-sign": [640, 512, [], "f757", "M152.3 24a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm40 312l0 208-64 0 0-305.5c-35.6 46.5-57.6 75.3-66 86.3l-50.8-38.9 19.4-25.4 104-136 9.6-12.6 127.2 0 9.6 12 59.6 74.5 57.7 28.9 4.8 2.4 18.6-51-82.3-29.9 54.7-150.4 82.3 29.9c2.5-6.8 6.7-18.5 12.8-35.2L534.7 9.7c-6.1 16.7-10.3 28.4-12.8 35.2l83.1 30.2-54.7 150.4-83.1-30.2-44.6 122.6-8.2 22.6-45.1-16.4c6.2-16.9 10.3-28.2 12.3-33.7l-11.4-5.7-64-32-6.3-3.1c-2.5-3.1-6.3-7.9-11.4-14.3l0 308.8-64 0 0-208-32 0z"],
    "circle-trash": [512, 512, ["trash-circle"], "e126", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM224 112l80.2 0c3.9 9.8 8.2 20.4 12.8 32l67 0 0 48-256 0 0-48 67 0c4.6-11.6 8.9-22.2 12.8-32l16.2 0zM176 384l-16-144 192 0-16 144-160 0z"],
    "earth-oceania": [512, 512, ["globe-oceania"], "e47b", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM411.3 379.3c-24.8 24.8-39.2 39.2-43.3 43.3L345.4 400c4.1-4.1 18.5-18.5 43.3-43.3l11.3-11.3 22.6 22.6-11.3 11.3zM288 416l0 32-64 0 0-32 64 0zM448 256l0 64-32 0 0-64 32 0zM192 160l0-32 96 0 0 64-64 0-32-32zM96 352l0-64 64-64 32 0 0 32 32 0 0-32 32 0 64 64 0 96-96 0-32-32-96 0z"],
    "u-turn-up-left": [512, 512, [], "e7f5", "M512 272c0-114.9-93.1-208-208-208l-144 0 0-96-160 160 160 160 0-96 144 0c44.2 0 80 35.8 80 80s-35.8 80-80 80l-240 0 0 128 240 0c114.9 0 208-93.1 208-208z"],
    "comment-slash": [576, 512, [], "f4b3", "M49.3-17l-17-17-33.9 33.9 17 17 512 512 17 17 33.9-33.9-17-17-88.7-88.7c44.3-43.1 71.5-101.8 71.5-166.4 0-132.5-114.6-240-256-240-63 0-120.7 21.3-165.3 56.7L49.3-17zM32.1 239.9c0 56.5 20.8 108.5 55.7 149.5L32.1 511.9 180.8 457.8c32.6 14.2 69 22.1 107.3 22.1 36.4 0 70.9-7.1 102.3-19.9L60.5 130.1C42.4 163 32.1 200.3 32.1 239.9z"],
    "play": [512, 512, [9654], "f04b", "M64 16L64 496 496 256 64 16z"],
    "user-dashed": [448, 512, [], "e7ac", "M224 256c-14.7 0-28.9-2.5-42.1-7.1l33.2-57.5c2.9 .4 5.9 .6 8.9 .6s6-.2 8.9-.6l33.2 57.5c-13.2 4.6-27.4 7.1-42.1 7.1zm-83.7-31.1c-21.4-18.5-36.6-44-42.1-72.9l66.4 0c2.2 5.6 5.3 10.7 8.9 15.4l-33.2 57.5zM283.3 104c-2.2-5.6-5.3-10.7-8.9-15.4l33.2-57.5c21.4 18.5 36.6 44 42.1 72.9l-66.4 0zM232.9 64.6c-2.9-.4-5.9-.6-8.9-.6s-6 .2-8.9 .6L181.9 7.1C195.1 2.5 209.3 0 224 0s28.9 2.5 42.1 7.1L232.9 64.6zM98.2 104c5.5-28.9 20.7-54.4 42.1-72.9l33.2 57.5c-3.6 4.7-6.6 9.8-8.9 15.4l-66.4 0zM307.7 224.9l-33.2-57.5c3.6-4.7 6.6-9.8 8.9-15.4l66.4 0c-5.5 28.9-20.7 54.4-42.1 72.9zM144 304l0 64-14.1 0-53.3-64 67.4 0zm48 64l0-64 64 0 0 64-64 0zm112-64l67.4 0-53.3 64-14.1 0 0-64zm93.5 43.7l21 68.3-66.5 0 0 1.6-3.4-11.2 5.9-7.1 43-51.6zM433.2 464l14.8 48-67 0-14.8-48 67 0zM99.4 406.4l-3.4 11.2 0-1.6-66.5 0 21-68.3 43 51.6 5.9 7.1zM81.7 464l-14.8 48-67 0 14.8-48 67 0z"],
    "house-window": [512, 512, [], "e3b3", "M512 272l-48 0 0 240-416 0 0-240-48 0 0-48 256-240 256 240 0 48zM320 352l0-128-128 0 0 128 128 0z"],
    "vial-circle-check": [512, 512, [], "e596", "M32 0l288 0 0 64-32 0 0 161.4c-66.1 30.3-112 97.1-112 174.6 0 39.7 12 76.6 32.7 107.2-10.3 3.1-21.3 4.8-32.7 4.8-61.9 0-112-50.1-112-112l0-336-32 0 0-64zm96 64l0 128 96 0 0-128-96 0zm96 336a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm214.4-51.5l-25.9-18.8-9.4 12.9-53 72.9C329.7 395 317 382.3 312 377.4L289.4 400c2.8 2.8 19.9 19.9 51.3 51.3l13.2 13.2 11-15.1 64-88 9.4-12.9z"],
    "bridge-circle-check": [576, 512, [], "e4c9", "M32 32l-32 0 0 64 40 0 0 64-40 0 0 112c37.6 9.4 64 43.2 64 82l0 126 96 0 0-96c0-53 43-96 96-96 6.4 0 12.7 .6 18.7 1.8 34.7-49.5 92.2-81.8 157.3-81.8 28.6 0 55.6 6.2 80 17.4l0-65.4-40 0 0-64 40 0 0-64-480 0zM424 96l0 64-80 0 0-64 80 0zM296 96l0 64-80 0 0-64 80 0zM88 96l80 0 0 64-80 0 0-64zM576 400a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-73.6-51.5l-9.4 12.9-64 88-11 15.1c-4.4-4.4-22.1-22.1-53.2-53.2L353.4 400 376 377.4c5 5 17.7 17.7 38.1 38.1l53-72.9 9.4-12.9 25.9 18.8z"],
    "cedi-sign": [384, 512, [], "e0df", "M232.5 32l0-24-48 0 0 50.5C89.2 73.9 16.5 156.4 16.5 256s72.8 182.1 168 197.5l0 50.5 48 0 0-48.6c58.9-4.7 110.5-34.8 144-79.3l-51.2-38.4c-21.8 29.1-55 49-92.8 53.5l0-270.1c37.9 4.4 71 24.4 92.8 53.5L376.5 136c-33.4-44.5-85.1-74.7-144-79.3l0-24.6zm-48 91.8l0 264.4c-59.7-14.4-104-68.1-104-132.2s44.3-117.8 104-132.2z"],
    "hat-santa": [576, 512, [], "f7a7", "M464 336l-352 0 112-336 192 0-48 48 96 288zm64 144l-480 0 0-96 480 0 0 96zM519.3 23.8l33.3-.4-.4 33.3 23.8 23.3-23.8 23.3 .4 33.3-33.3-.4-23.3 23.8-23.3-23.8-33.3 .4 .4-33.3-23.8-23.3 23.8-23.3-.4-33.3 33.3 .4 23.3-23.8 23.3 23.8z"],
    "puzzle-piece": [512, 512, [129513], "f12e", "M192 89.6c-19.1-8.3-32-23.8-32-41.6 0-26.5 28.7-48 64-48s64 21.5 64 48c0 17.8-12.9 33.3-32 41.6l0 38.4 128 0 0 128 38.4 0c8.3-19.1 23.8-32 41.6-32 26.5 0 48 28.7 48 64s-21.5 64-48 64c-17.8 0-33.3-12.9-41.6-32l-38.4 0 0 192-128 0 0-38.4c19.1-8.3 32-23.8 32-41.6 0-26.5-28.7-48-64-48s-64 21.5-64 48c0 17.8 12.9 33.3 32 41.6l0 38.4-192 0 0-192 38.4 0c8.3 19.1 23.8 32 41.6 32 26.5 0 48-28.7 48-64s-21.5-64-48-64c-17.8 0-33.3 12.9-41.6 32l-38.4 0 0-128 192 0 0-38.4z"],
    "helmet-un": [512, 512, [], "e503", "M479.5 224C471.2 98.9 367.2 0 240 0 107.5 0 0 107.5 0 240l0 144 214.9 0 128.6 121.4c4.5 4.2 10.4 6.6 16.5 6.6l120 0 0-48-110.5 0-1.5-1.5 0-174.5 144 0 0-64-32.5 0zM320 417.2l-78-73.7 32.4-55.5 45.6 0 0 129.2zM160 112l0 64c0 8.8 7.2 16 16 16s16-7.2 16-16l0-80 32 0 0 80c0 26.5-21.5 48-48 48s-48-21.5-48-48l0-80 32 0 0 16zM272 96l17.9 0 4.4 8.8 25.7 51.4 0-60.2 32 0 0 128-33.9 0-4.4-8.8-25.7-51.4 0 60.2-32 0 0-128 16 0z"],
    "glass-water": [384, 512, [], "e4f4", "M76.6 158.3l-7.4-94.3 245.6 0-7.4 94.3-20.6 10.3c-19.4 9.7-42.2 9.7-61.6 0-20.9-10.4-45.5-10.4-66.4 0-19.4 9.7-42.2 9.7-61.6 0L76.6 158.3zM40 512l304 0 35-448 5-64-384 0 40 512z"],
    "pen-fancy-slash": [576, 512, [], "e210", "M49.3-16.9l-17-17-33.9 33.9 17 17 512 512 17 17 33.9-33.9-17-17-214.8-214.8 213.7-200.3-96-96-200.3 213.7-214.5-214.5zM96.1 288l-52.7 184.4 84.9-84.9c-.1-1.2-.2-2.3-.2-3.5 0-17.7 14.3-32 32-32s32 14.3 32 32-14.3 32-32 32c-1.2 0-2.4-.1-3.5-.2L71.7 500.7 256.1 448 289.4 359.1 185 254.7 96.1 288z"],
    "heart-circle-bolt": [576, 512, [], "e4fc", "M133.1 32C175.8 32 216 52.5 241 87.1l15 20.7 15-20.7c25-34.6 65.2-55.1 107.9-55.1 73.5 0 133.1 59.6 133.1 133.1 0 19.2-3 38.1-8.5 56.6-22.1-8.9-46.2-13.8-71.5-13.8-106 0-192 86-192 192 0 33 8.3 64 23 91.2-2.4 1.6-4.7 3.3-7 4.8-102.5-70.7-256-194.1-256-330.9 0-73.5 59.6-133.1 133.1-133.1zM432 256a144 144 0 1 1 0 288 144 144 0 1 1 0-288zM336 416l70.9 0-22.9 80 144-112-70.9 0 22.9-80-144 112z"],
    "fire-hydrant": [384, 512, [], "e17f", "M224 32l0 4c45 11.6 80.4 47 92 92l36 0 0 48-320 0 0-48 36 0c11.6-45 47-80.4 92-92l0-36 64 0 0 32zM32 464l32 0 0-64-48 0 0-128 48 0 0-64 256 0 0 64 48 0 0 128-48 0 0 64 32 0 0 48-320 0 0-48zm160-64a64 64 0 1 0 0-128 64 64 0 1 0 0 128z"],
    "memo-circle-check": [576, 512, [], "e1d9", "M416 0l-384 0 0 512 244 0c-22.7-31.5-36-70.2-36-112 0-100.6 77.4-183.2 176-191.3L416 0zM128 128l192 0 0 48-192 0 0-48zm0 96l112 0 0 48-112 0 0-48zm0 96l80 0 0 48-80 0 0-48zm448 80a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-73.6-51.5l-9.4 12.9-64 88-11 15.1c-4.4-4.4-22.1-22.1-53.2-53.2L353.4 400 376 377.4c5 5 17.7 17.7 38.1 38.1l53-72.9 9.4-12.9 25.9 18.8z"],
    "pump-soap": [320, 512, [], "e06b", "M96-32l0 112 128 0 0-24 96 0 0-48-96 0 0-40-128 0zM320 128l-320 0 0 384 320 0 0-384zM224 344c0 35.3-28.7 56-64 56s-64-20.7-64-56c0-40.8 36-84 64-112 28 28 64 71.2 64 112z"],
    "hand-scissors": [512, 512, [], "f257", "M40 208l-40 0 0 80 208 0 0 80 32 0 0 80 144 0c70.7 0 128-57.3 128-128l0-113.1c0-40.2-16-78.8-44.4-107.3-22.8-22.8-53.6-35.6-85.8-35.6l-93.7 0 0 32.3 76.9 24.5 15.2 4.9-9.7 30.5c-1.5-.5-29-9.2-82.4-26.2l0 .1C144.3 84.8 71.6 62 69.8 61.4l-24 76.3c.9 .3 75.5 23.7 223.7 70.3L40 208z"],
    "sandwich": [512, 512, [129386], "f81f", "M0 64l512 0 0 112-512 0 0-112zM320 384l96-48 96 0 0 112-512 0 0-112 224 0 96 48zM144.2 209.1l111.8 29.8 111.8-29.8 8-2.1 8 2c74.8 18.7 117.2 29.3 127 31.8l-15.5 62.1c-11.2-2.8-50.9-12.7-119-29.8l-112 29.9-8.2 2.2-8.2-2.2-112-29.9c-68.1 17-107.8 27-119 29.8L1.2 240.7c9.9-2.5 52.2-13.1 127-31.8l8-2 8 2.1z"],
    "dolly": [640, 512, ["dolly-box"], "f472", "M64.5 0l-32 0 0 64 104.9 0 92.1 276.2c-22.5 17.6-37 45-37 75.8 0 53 43 96 96 96 52.4 0 95.1-42 96-94.3l202.1-67.4 30.4-10.1-20.2-60.7-30.4 10.1-202.1 67.4c-17.2-22.1-43.9-36.5-74-37L190.8 21.9 183.5 0 64.5 0zm176 416a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm26.9-311.9l55.9 172.1c20.5 5.1 39.2 14.5 55.1 27.3l171.2-55.6-69.2-213-213 69.2z"],
    "paperclip": [512, 512, [128206], "f0c6", "M224.6 12.8c56.2-56.2 147.4-56.2 203.6 0s56.2 147.4 0 203.6l-164 164c-34.4 34.4-90.1 34.4-124.5 0s-34.4-90.1 0-124.5l152.7-152.7 22.6-22.6 45.3 45.3-22.6 22.6-152.7 152.7c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l164-164c31.2-31.2 31.2-81.9 0-113.1s-81.9-31.2-113.1 0l-164 164c-53.1 53.1-53.1 139.2 0 192.3s139.2 53.1 192.3 0l130.1-130.1 22.6-22.6 45.3 45.3-22.6 22.6-130.1 130.1c-78.1 78.1-204.7 78.1-282.8 0s-78.1-204.7 0-282.8l164-164z"],
    "meter-fire": [640, 512, [], "e1eb", "M272 383.8C272 432.2 288.5 476.7 316.1 512 176.5 509.9 64 396.1 64 256 64 114.6 178.6 0 320 0 434.2 0 530.9 74.7 563.9 177.9l-22.8-19-29.1 29.1-57.1-57.1-32.4 20.2c-25.4 15.9-61.7 45-92.1 83.2-30.2 37.9-58.5 89.6-58.5 149.5zm72-236l0-19.8-48 0 0 69.7c15.4-18.8 31.9-35.6 48-49.9zM248 128l-48 0 0 96 48 0 0-96zm200 64l64 64 32-32c76.8 64 96 133.3 96 160 0 88.4-71.6 160-160 160S320 472.4 320 384c0-89.6 85.3-165.3 128-192zm96 240.2c0-48-64-96-64-96s-64 48-64 96c0 35.3 28.7 64 64 64s64-28.7 64-64z"],
    "democrat": [640, 512, [], "f747", "M64 32C64 12.1 80 0 80 0L128 45.7 176 0s16 12.1 16 32c0 26.5-21.9 42-29.5 46.6L248 160c412.3 0 263.7 0 310.3 0l9.5 10.6 72 80-47.6 42.8-49.4-54.9 1.2 1.5 0 80-352 0-48-112-72 48-72-72 87.6-109.4C78.1 67.4 64 53.2 64 32zM544 352l0 160-96 0 0-96-160 0 0 96-96 0 0-160 352 0zM256 280a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm248-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM368 280a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"],
    "square-arrow-up-right": [448, 512, ["external-link-square"], "f14c", "M0 32l448 0 0 448-448 0 0-448zM184 208l54.1 0-103 103-17 17 33.9 33.9 17-17 103-103 0 78.1 48 0 0-160-160 0 0 48 24 0z"],
    "square-exclamation": [448, 512, ["exclamation-square"], "f321", "M448 480l-448 0 0-448 448 0 0 448zM196 324l0 56 56 0 0-56-56 0zm-4-196l12.8 160 38.4 0 12.8-160-64 0z"],
    "wave": [512, 512, [], "e65b", "M334 271c-21.9 8.8-45.8-7.4-45.8-31 0-44.2 35.8-80 80-80 21.5 0 41 8.5 55.4 22.3l38.6-27.1C429.8 82.7 356.9 32 272.2 32 157.3 32 64.2 125.1 64.2 240l0 43C33.8 295.1 12.8 303.5 1 308.2l17.8 44.6c25-10 114.7-45.9 117.4-47l111.1 44.4 8.9 3.6 8.9-3.6 86.7-34.7 0 0 24.4-9.7c75.5 30.2 114.6 45.9 117.4 46.9l17.8-44.6-22.3-8.9-104-41.6-8.9-3.6c-1.9 .8-15.9 6.4-42.2 16.9l0 0zM136.2 382.2l-8.9 3.6C44.3 418.9 2.2 435.7 1 436.2l17.8 44.6c2.7-1.1 41.8-16.7 117.4-47l111.1 44.4 8.9 3.6 8.9-3.6 111.1-44.4c75.5 30.2 114.6 45.9 117.4 46.9l17.8-44.6c-1.2-.5-43.3-17.3-126.3-50.5l-8.9-3.6-8.9 3.6-111.1 44.4-111.1-44.4-8.9-3.6z"],
    "ferry": [640, 512, [], "e4ea", "M224.4 0l192 0 0 64 128 0 0 256-37.7 69.1c-28.5-11.4-50.6-20.2-66.3-26.5l-26.7 10.7-93.3 37.3-93.2-37.3-26.8-10.7c-15.7 6.3-37.8 15.1-66.3 26.5l-37.7-69.1 0-256 128 0 0-64zm-64 256l320 0 0-128-320 0 0 128zm48.9 161.7l111.1 44.4 111.1-44.4 8.9-3.6 8.9 3.6 111.8 44.7c29.3-9.7 50.1-16.7 62.4-20.8l15.2 45.5c-11 3.7-34.6 11.5-70.8 23.6l-8.3 2.8-8.2-3.3-111.1-44.4-111.1 44.4-8.9 3.6-8.9-3.6-111.1-44.4-111.1 44.4-8.2 3.3-8.3-2.8C36.6 498.7 13 490.8 2 487.2l15.2-45.5c12.4 4.1 33.2 11.1 62.4 20.8l111.8-44.7 8.9-3.6 8.9 3.6z"],
    "mosquito": [576, 512, [], "e52b", "M127.3 487.3c4.6-7.4 21-33.6 49-78.5l0-41 0-8.3 4.9-6.6 39.3-52.2-66.2 59.5c-17 15.3-39 23.7-61.9 23.8l-8.1 0c-46.6 0-84.4-37.8-84.4-84.4 0-43 32.4-79.2 75.1-83.9l130.5-14.5c-35.4-30.3-54.1-46.3-56.2-48.2l3.8-14.9 13.3-53.4c-19.4-29-32.5-48.7-39.3-59l39-27.5c5.8 8.7 20.9 31.4 45.3 68.1l6.1 9.1-2.7 10.7-12.3 49.2 53.3 45.7 0-60.8 16 0 0-72.2 32 0 0 72.2 16 0 0 60.9 53.4-45.7-12.3-49.2-2.7-10.7 6.1-9.1c24.4-36.7 39.5-59.3 45.3-68.1l39 27.5c-6.8 10.3-19.9 29.9-39.3 59l13.3 53.4 3.8 14.9-11.5 9.9-44.7 38.3 130.4 14.5c42.8 4.8 75.1 40.9 75.1 83.9 0 46.6-37.8 84.4-84.4 84.4l-8.1 0c-22.8 0-44.9-8.5-61.9-23.8l-66.1-59.5 39.2 52.2 5 6.6 0 49.3 36.2 58 12.8 20.5-39.8 26.3-12.8-20.5-40-64-3.8-6 0-47-32.4-43.1 0 106.7-64 0 0-106.6-32.3 43 0 47-3.8 6-40 64-12.8 20.5-39.8-26.3z"],
    "hexagon-minus": [576, 512, ["minus-hexagon"], "f307", "M13.5 256.1l6.8-11.9 123.7-216.1 6.9-12.1 275.1 0 6.9 12.1 123.7 216.1 6.8 11.9-6.8 11.9-123.7 216.1-6.9 12.1-275.1 0-6.9-12.1-123.7-216.1-6.8-11.9zm187-24.1l-24 0 0 48 224 0 0-48-200 0z"],
    "building-circle-arrow-right": [576, 512, [], "e4d1", "M32 0l384 0 0 208.7c-35.7 2.9-68.5 15.6-96 35.4l0-20-64 0 0 64 20 0c-13.7 19-24 40.7-30 64l-70 0 0 112 74.9 0c6.1 17.3 14.6 33.4 25.1 48L32 512 32 0zM192 96l-64 0 0 64 64 0 0-64zm64 0l0 64 64 0 0-64-64 0zM192 224l-64 0 0 64 64 0 0-64zm96 176a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm152-78.6L417.4 344c4.6 4.6 18 18 40 40l-105.4 0 0 32 105.4 0c-22 22-35.4 35.4-40 40l22.6 22.6 11.3-11.3 56-56 11.3-11.3-11.3-11.3-56-56-11.3-11.3z"],
    "face-hand-peeking": [640, 512, [129763], "e481", "M430.4 487c-33.4 16-70.9 25-110.4 25-91.4 0-171.6-47.9-216.9-120 37.2-.3 72.7-15.2 99-41.5 63.8-63.8 100.6-100.6 110.5-110.5-20.3-20.3-36.3-36.3-48-48l3.7-3.7 28.3-28.3c-41.8-41.8-76.9-76.9-88.6-88.6l-16 16C177.5 73 167 62.4 160.4 55.8 204.2 20.9 259.6 0 320 0 453.3 0 562.8 101.9 574.9 232l-30.3 0-69.1-67.3-.1-.1c-32.8-32.8-86-32.8-118.8 0s-32.8 86 0 118.8c1.2 1.2 2.5 2.4 3.8 3.6l-17 17 32 32-22.7 22.7c-9.6-4.3-20.8-6.7-32.7-6.7-35.3 0-64 21.5-64 48s28.7 48 64 48c21.2 0 40.1-7.8 51.7-19.7L430.4 487zM416.4 200a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM0 250.2l0-122.2 48 0 0 64 96-96 32 32-64 64 16 16 80-80 32 32-80 80 16 16 48-48 32 32-82.2 82.2C154.7 341.3 128.8 352 101.8 352 45.6 352 0 306.4 0 250.2zM640 272l0 122.2c0 56.2-45.6 101.8-101.8 101.8-27 0-52.9-10.7-72-29.8l-82.2-82.2 32-32 48 48 16-16-80-80 32-32 80 80 16-16-64-64 32-32 96 96 0-64 48 0z"],
    "arrow-left-from-line": [576, 512, [8612, "arrow-from-right"], "f344", "M480.3 416l0 32 64 0 0-384-64 0 0 352zM41.6 233.4l-22.6 22.6 22.6 22.6 128 128 22.6 22.6 45.3-45.3c-6.6-6.6-38.6-38.6-96-96l274.7 0 0-64-274.7 0c57.4-57.4 89.4-89.4 96-96l-45.3-45.3-22.6 22.6-128 128z"],
    "left-right": [512, 512, [8596, "arrows-alt-h"], "f337", "M0 128l160-144 0 112 352 0 0 64-352 0 0 112-160-144zM352 528l0-112-352 0 0-64 352 0 0-112 160 144-160 144z"],
    "signal-bars-weak": [448, 512, ["signal-alt-1"], "f691", "M64 384l0 96-64 0 0-96 64 0z"],
    "airplay-audio": [512, 512, [], "e77b", "M48 256c0 53.1 19.9 101.5 52.6 138.3l-29.2 29.2-4.8 4.8C25.2 382.8 0 322.3 0 256 0 114.6 114.6 0 256 0S512 114.6 512 256c0 66.3-25.2 126.8-66.6 172.2l-4.8-4.8-29.2-29.2C444.1 357.5 464 309.1 464 256 464 141.1 370.9 48 256 48S48 141.1 48 256zm368 0c0 39.8-14.5 76.2-38.6 104.2l-34.1-34.1c15.4-19.2 24.7-43.6 24.7-70.2 0-61.9-50.1-112-112-112S144 194.1 144 256c0 26.6 9.2 51 24.7 70.2l-34.1 34.1C110.5 332.2 96 295.8 96 256 96 167.6 167.6 96 256 96s160 71.6 160 160zM256 238.9l-53 53c-6.9-10.2-11-22.6-11-35.9 0-35.3 28.7-64 64-64s64 28.7 64 64c0 13.3-4.1 25.6-11 35.9l-53-53zM50.7 512c24.2-24.2 85.1-85.1 182.6-182.6L256 306.7 461.3 512 50.7 512z"],
    "lightbulb-gear": [576, 512, [], "e5fd", "M229.4 383.8l-.3 .2-101.1 0 0-25.7C70.6 325.1 32 263.1 32 192 32 86 118 0 224 0 324.6 0 407.1 77.4 415.3 175.9l-95.2 0 0 41.7-36.7-21.2c-12.2 21.8-35.3 63.1-69.3 123.9l-22.4 40 37.7 23.5zM128 432l77.6 0 8.5 15.2 45.1 80.8-131.2 0 0-96zm88-320l8 0 0-48-8 0C149.7 64 96 117.7 96 184l0 8 48 0 0-8c0-39.8 32.2-72 72-72zM368.2 223.9l96 0 0 41.4c11.1 4.5 21.4 10.5 30.7 17.8l35.9-20.7 45.3 81.5-33.4 20.9c.9 6.3 1.4 12.7 1.4 19.2 0 6.5-.5 12.9-1.4 19.1l33.4 20.8-45.3 81.7-35.9-20.7c-9.3 7.3-19.6 13.3-30.7 17.8l0 41.4-96 0 0-41.2c-11.2-4.5-21.5-10.5-30.9-17.8l-35.7 20.6-45.6-81.7 33.4-20.7c-.9-6.3-1.4-12.7-1.4-19.2 0-6.5 .5-13 1.4-19.3l-33.4-20.8 45.6-81.5 35.7 20.6c9.3-7.3 19.7-13.3 30.9-17.8l0-41.2zm99.9 160.2a52 52 0 1 0 -104 0 52 52 0 1 0 104 0z"],
    "grid-2-minus": [448, 512, [], "e6aa", "M192 32l-192 0 0 192 192 0 0-192zm0 256l-192 0 0 192 192 0 0-192zM256 32l0 192 192 0 0-192-192 0zm24 328l-24 0 0 48 192 0 0-48-168 0z"],
    "rectangle-terminal": [512, 512, [], "e236", "M0 64l512 0 0 384-512 0 0-384zM86.1 176l80 80c-49.7 49.7-76.4 76.4-80 80l33.9 33.9 17-17c63.8-63.8 96.2-96.2 97-97-.8-.8-33.1-33.1-97-97l-17-17-33.9 33.9zM248 336l-24 0 0 48 192 0 0-48-168 0z"],
    "square-down-left": [448, 512, [], "e26b", "M448 480l-448 0 0-448 448 0 0 448zM152 352l169.9 0c-29.6-29.6-52.3-52.3-68-68 53-53 81-81 84-84-24.3-24.3-54.1-54.1-57.9-57.9-3 3-31 31-84 84-15.7-15.7-38.4-38.4-68-68l0 193.9 24 0z"],
    "mailbox-open-letter": [640, 512, [], "e823", "M164.8 414.7l11.2 5.8 11.2-5.8 100.8-53 0 118.2-288 0 0-151.9 164.8 86.6zM576 96c38.9 29.2 64 75.7 64 128l0 256-304 0 0-272c0-53-43-96-96-96-41.8 0-77.2 26.7-90.4 64l-49.9 0C114.2 111.9 171.5 64 240 64l128 0 0-16 208 0 0 48zM288 307.5l-112 58.8-176-92.5 0-49.9 288 0 0 83.5zM416 256l48 0 0-80 64 0 0-80-112 0 0 160z"],
    "pepper": [512, 512, [129745], "e432", "M320 24c-22.1 0-40 17.9-40 40l0 3c13.8-3.6 28.7-4.1 43.6-1 8.3 1.7 16.2 4.5 23.5 8.2 21.6-10.4 47-13.3 71.9-6.6 55.5 14.9 88.3 72 73.4 127.5l-56 208c-14.9 55.5-72 88.3-127.5 73.4-4.8-1.3-9.4-2.9-13.8-4.8-6 2.7-12.4 4.8-19.1 6.2-22.2 4.8-44.3 1.4-63.2-8.1-6.8 3.2-14 5.8-21.6 7.5-56 12.9-111.8-22-124.7-78l-48-208c-12.9-56 22-111.8 78-124.7 23.9-5.5 47.8-2.3 68.3 7.5 7.1-3.6 14.8-6.3 23-8.1 15.1-3.2 30.1-2.7 44.1 .9l0-3c0-48.6 39.4-88 88-88l24 0 0 48-24 0z"],
    "moon-stars": [512, 512, [], "f755", "M448-32l16 48 48 16-48 16-16 48-16-48-48-16 48-16 16-48zM314.7 83.1c-76.2 18.9-132.7 87.8-132.7 169.9 0 96.6 78.3 175 175 175 16.2 0 31.9-2.2 46.8-6.3-40.8 54.8-106.1 90.3-179.8 90.3-123.7 0-224-100.3-224-224S100.3 64 224 64c32.3 0 63 6.8 90.7 19.1zM384 352L355.2 268.8 272 240 355.2 211.2 384 128 412.8 211.2 496 240 412.8 268.8 384 352z"],
    "clock-five": [512, 512, [], "e349", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm24-392l0 128.7 60 90 13.3 20-39.9 26.6-13.3-20-64-96-4-6 0-167.3 48 0 0 24z"],
    "corner": [512, 512, [], "e3fe", "M0 160l512 0 0 224-64 0 0-160-448 0 0-64z"],
    "virus": [512, 512, [], "e074", "M296 0l0 40c0 44.1 53.3 66.1 84.5 35l28.3-28.3 56.6 56.6-28.4 28.4c-31 31.2-9 84.4 35.1 84.4l40 0 0 80-40 0c-44 0-66.1 53.2-35.1 84.3l28.4 28.4-56.6 56.6-28.3-28.3c-31.2-31.1-84.4-9.1-84.5 34.9l0 40.1-80 0 0-40c0-43.9-52.9-66-84.1-35.3l-28.6 28.6-56.6-56.6 28.3-28.3c31.2-31.2 9.1-84.5-35-84.5l-40 0 0-80 40 0c44 0 66-53 35.2-84.2L46.7 103.3 103.3 46.7 131.5 75c31.2 31.2 84.5 9.1 84.5-35l0-40 80 0zM224 224a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm96 96a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "norwegian-krone-sign": [512, 512, [], "e6e8", "M112 48l0-32-64 0 0 464 64 0 0-113.8 29.1-26.5c70.8 101.2 106.5 152.1 107 152.9l52.4-36.7-18.4-26.2-93.4-133.4c69.9-63.6 107.4-97.6 112.3-102.1l-43-47.4-23.7 21.5-122.5 111.3 0-231.7zM448 224l48 0 0-64-48 0c-22.8 0-44.8 6.1-64 17.1l0-17.1-64 0 0 320 64 0 0-192c0-13.8 4.5-27.3 12.8-38.4 12.1-16.1 31.1-25.6 51.2-25.6z"],
    "gem": [512, 512, [128142], "f3a5", "M0 208L256 480 512 208 400 32 112 32 0 208zM376 64L299.6 189 464 208 256 232 48 208 212.4 189 136 64 256 177.7 376 64z"],
    "toilet": [448, 512, [128701], "f7d8", "M24 0L0 0 0 48 32 48 32 196.9c-1.9 1.4-3.8 2.9-5.6 4.4-15.5 13.2-26.4 31.6-26.4 54.6 0 46.9 14.3 84.1 37 112.5 15.1 18.9 33.3 33.1 51.9 43.9L64 512 384 512 359.1 412.4c18.6-10.8 36.8-25 51.9-43.9 22.7-28.4 37-65.5 37-112.5 0-23.1-10.9-41.5-26.4-54.6-1.8-1.5-3.7-3-5.6-4.4l0-148.9 32 0 0-48-424 0zM96 64l64 0 0 32-64 0 0-32zM224 288c-88.4 0-160-14.3-160-32s71.6-32 160-32 160 14.3 160 32-71.6 32-160 32z"],
    "burger-fries": [576, 512, [], "e0cd", "M208-16l0 239.1c-17.4-1.9-33.7-6.6-48-13.3L160-32 208-16zM128 32l0 128-48 0 0-144 48 16zm240 0l0 128-48 0 0-144 48 16zM288 16l0 192.5-.5 .2c-16 7.4-32.6 12.1-47.5 14.2L240 32 288 16zM32.8 222.2l42.8-20.1c29 40.9 87 69.9 148.4 69.9 1 0 2 0 3 0-7.8 12.5-14.2 26-19 40.2l0 167.8-106.4 0-4.8-17.8-64-240zM256 543.8l0-64 320 0 0 64-320 0zM576 320l0 47.8-320 0 0-47.8s32-96 160-96.2c128 .1 160 96.2 160 96.2zm0 127.8l-320 0 0-48 320 0 0 48zM432 272a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm-96 48a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm176-16a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"],
    "paperclip-vertical": [448, 512, [], "e3c2", "M32 112C32 32.5 96.5-32 176-32S320 32.5 320 112l0 232c0 48.6-39.4 88-88 88s-88-39.4-88-88l0-248 64 0 0 248c0 13.3 10.7 24 24 24s24-10.7 24-24l0-232c0-44.2-35.8-80-80-80S96 67.8 96 112l0 232c0 75.1 60.9 136 136 136s136-60.9 136-136l0-216 64 0 0 216c0 110.5-89.5 200-200 200S32 454.5 32 344l0-232z"],
    "shirt-long-sleeve": [576, 512, [], "e3c7", "M288 112c44.2 0 80-35.8 80-80l103 0 12.7 28.3 72 160 4.2 9.4 0 218.3-64 0 0-192-48 0 0 256-320 0 0-256-48 0 0 192-64 0 0-218.3 4.2-9.4 72-160 12.7-28.3 103 0c0 44.2 35.8 80 80 80z"],
    "trash-can-check": [448, 512, [], "e2a9", "M416 512l-384 0 0-368 384 0 0 368zM281.4 233.9L195.8 351.6c-19.3-20-33.7-34.9-43.2-44.7l-34.5 33.3c6.2 6.4 27.2 28.1 63.1 65.3l19.8 20.6 16.8-23.1 102.4-140.8 14.1-19.4-38.8-28.2-14.1 19.4zM320 32l128 0 0 64-448 0 0-64 128 0 16-48 160 0 16 48z"],
    "single-quote-left": [192, 512, [], "e81b", "M160 160l-40 0c-30.9 0-56 25.1-56 56l0 8 128 0 0 192-192 0 0-200C0 149.7 53.7 96 120 96l40 0 0 64z"],
    "arrow-u-turn-down-right": [576, 512, [], "e7e8", "M400.2 541.3l-45.3-45.3 80-80-210.7 0C121.5 416 37.6 335.3 32.5 233.9l-.2-9.9c0-106 86-192 192-192l256 0 0 64-256 0c-70.7 0-128 57.3-128 128l.2 6.6C99.8 298.2 155.8 352 224.2 352l210.7 0-80-80 45.3-45.2 157.2 157.2-157.2 157.3z"],
    "money-bills": [576, 512, [], "e1f3", "M576 32l-480 0 0 352 480 0 0-352zM336 128a80 80 0 1 1 0 160 80 80 0 1 1 0-160zM160 160l0-64 64 0c0 35.3-28.7 64-64 64zm0 96c35.3 0 64 28.7 64 64l-64 0 0-64zM448 96l64 0 0 64c-35.3 0-64-28.7-64-64zm64 160l0 64-64 0c0-35.3 28.7-64 64-64zM48 152l0-24-48 0 0 352 480 0 0-48-432 0 0-280z"],
    "car-circle-bolt": [640, 512, [], "e342", "M129.3 32l317.4 0 7.5 21.4 42.9 122.6-1.1 0c-16.9 0-33.3 2.2-48.9 6.3-9.5 2.5-18.9 5.7-28 9.7-18.4 8-35.3 18.9-50.1 32-39.9 35.2-65 86.7-65 144 0 16.6 2.1 32.7 6 48l-182 0 0 64-96 0 0-288 41.3 0 48.5-138.6 7.5-21.4zM332.8 192c24-22.3 52.7-39.7 84.3-50.7l-15.8-45.3-226.6 0-33.6 96 191.7 0zM128 336a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm224 32a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm192-96l-144 112 70.9 0-22.9 80 144-112-70.9 0 22.9-80z"],
    "tablet-button": [448, 512, [], "f10a", "M448 0L0 0 0 512 448 512 448 0zM224 400a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "rectangle-high-dynamic-range": [576, 512, ["rectangle-hdr"], "e773", "M576 64l-576 0 0 384 576 0 0-384zM112 184l0 48 32 0 0-72 48 0 0 192-48 0 0-72-32 0 0 72-48 0 0-192 48 0 0 24zm112-24l64 0c35.3 0 64 28.7 64 64l0 64c0 35.3-28.7 64-64 64l-64 0 0-192zm48 144l16 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16l-16 0 0 96zM384 160l60 0c37.6 0 68 30.4 68 68 0 17.4-6.5 33.2-17.2 45.3 10.8 12.6 17.2 28.9 17.2 46.7l0 32-48 0 0-32c0-13.3-10.7-24-24-24l-8 0 0 56-48 0 0-192zm60 88c11 0 20-9 20-20s-9-20-20-20l-12 0 0 40 12 0z"],
    "square-yen": [448, 512, [], "e724", "M448 32l-448 0 0 448 448 0 0-448zM165.3 127.2c2.3 4 21.9 37.5 58.7 100.5 36.8-63 56.4-96.5 58.7-100.5l41.4 24.2c-1.9 3.3-22.3 38.2-61.1 104.6l41 0 0 32-56 0 0 32 56 0 0 32-56 0 0 48-48 0 0-48-56 0 0-32 56 0 0-32-56 0 0-32 41 0c-38.8-66.5-59.2-101.3-61.1-104.6l41.4-24.2z"],
    "square-arrow-down-left": [448, 512, [], "e261", "M448 480l-448 0 0-448 448 0 0 448zM264 304l-54.1 0 103-103 17-17-33.9-33.9-17 17-103 103 0-78.1-48 0 0 160 160 0 0-48-24 0z"],
    "bulldozer": [640, 512, [], "e655", "M64 32l179.8 0 8.8 17.7 71.2 142.3 28.2 0 0-96 48 0 0 96 48 0 0 104 80 0 0-80c0-48.6 39.4-88 88-88l24 0 0 48-24 0c-22.1 0-40 17.9-40 40l0 208c0 22.1 17.9 40 40 40l24 0 0 48-24 0c-48.6 0-88-39.4-88-88l0-80-63 0c9.5 16.5 15 35.6 15 56 0 61.9-50.1 112-112 112l-224 0c-61.9 0-112-50.1-112-112 0-30.5 12.2-58.2 32-78.4L64 32zm80 320c-26.5 0-48 21.5-48 48s21.5 48 48 48l224 0c26.5 0 48-21.5 48-48s-21.5-48-48-48l-224 0zM204.2 96l-76.2 0 0 96 124.2 0-48-96zM328 400a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm-72-24a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM136 400a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"],
    "calendar-pen": [448, 512, ["calendar-edit"], "f333", "M160 0l0 64 128 0 0-64 64 0 0 64 96 0 0 416-448 0 0-416 96 0 0-64 64 0zM128 320l-16 80 80-16 144-144-64-64-144 144z"],
    "bell-on": [640, 512, [128365], "f8fa", "M615.5 36.6L596.6-7.5c-9 3.9-35.1 15-78.1 33.5l-22.1 9.5 18.9 44.1c9-3.9 35.1-15 78.1-33.5l22.1-9.5zM352 0l-64 0 0 35.2C215 50 160 114.6 160 192l0 96-80 128 480 0-80-128 0-96c0-77.4-55-142-128-156.8L352 0zM258 464c7.1 27.6 32.2 48 62 48s54.9-20.4 62-48l-124 0zM0 160l0 48 112 0 0-48-112 0zm552 0l-24 0 0 48 112 0 0-48-88 0zM46.5 46.1c43 18.4 69 29.6 78.1 33.5l18.9-44.1-78.1-33.5-22.1-9.5-18.9 44.1 22.1 9.5z"],
    "excavator": [640, 512, [], "e656", "M416 384c0-26.3-10.6-50.2-27.8-67.5l187.8-156.5 0 144-128 128 0 48 112 0c44.2 0 80-35.8 80-80l0-368-64 0-192 160-96-160-160 0 0 160-96 0 0 120.4C12.4 330 0 355.6 0 384 0 437 43 480 96 480l224 0c53 0 96-43 96-96zM309.4 192l-117.4 0 0-96 59.8 0 57.6 96zM64 384c0-17.7 14.3-32 32-32l224 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L96 416c-17.7 0-32-14.3-32-32z"],
    "rectangle-xmark": [512, 512, [62164, "rectangle-times", "times-rectangle", "window-close"], "f410", "M512 64l-512 0 0 384 512 0 0-384zM172.1 305.9L222.1 256c-38.8-38.8-61.1-61.1-66.9-66.9l33.9-33.9 66.9 66.9c38.8-38.8 61.1-61.1 66.9-66.9l33.9 33.9c-5.8 5.8-28.1 28.1-66.9 66.9 38.8 38.8 61.1 61.1 66.9 66.9l-33.9 33.9c-5.8-5.8-28.1-28.1-66.9-66.9-38.8 38.8-61.1 61.1-66.9 66.9l-33.9-33.9 17-17z"],
    "wrench": [576, 512, [128295], "f0ad", "M416.3 192L524.9 83.5c12.4 22.7 19.5 48.8 19.5 76.5 0 88.4-71.6 160-160 160-17.5 0-34.4-2.8-50.2-8-134 134-207.9 207.9-221.8 221.8L10.5 432c13.9-13.9 87.9-87.9 221.8-221.8-5.2-15.8-8-32.6-8-50.2 0-88.4 71.6-160 160-160 27.7 0 53.8 7.1 76.5 19.5l-108.5 108.5 0 64 64 0z"],
    "message-slash": [576, 512, ["comment-alt-slash"], "f4a9", "M49.3-16.9l-17-17-33.9 33.9 17 17 512 512 17 17 33.9-33.9c-6.3-6.3-27.7-27.7-64.1-64.1l30 0 0-416-446 0-48.9-48.9zM32.1 101.8l0 346.2 128 0 0 96 160-96 58.2 0-346.2-346.2z"],
    "mace": [640, 512, [], "f6f8", "M384-64L338.4 38.6c-51.7 15.3-92.5 56.1-107.8 107.8L128 192 230.6 237.6c15.3 51.7 56.1 92.5 107.8 107.8L384 448 429.6 345.4c51.7-15.3 92.5-56.1 107.8-107.8L640 192 537.4 146.4C522.1 94.7 481.3 53.9 429.6 38.6L384-64zM261.3 360C244 347.3 228.7 332 216 314.7L73.4 457.4 50.7 480 96 525.3 118.6 502.6 261.3 360zM384 160a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "watch": [448, 512, [8986], "f2e1", "M155-32L293-32c24.5 0 45 18.4 47.7 42.7l10.1 90.6C395.5 138 424 193.7 424 256s-28.5 118-73.2 154.7l-10.1 90.6C338 525.6 317.5 544 293 544L155 544c-24.5 0-45-18.4-47.7-42.7L97.2 410.7C52.5 374 24 318.3 24 256S52.5 138 97.2 101.3l10.1-90.6C110-13.6 130.5-32 155-32zm93 184l0 94.1c31.3 31.3 50.6 50.6 57.9 57.9L272 337.9c-6.1-6.1-27.8-27.8-65-65l-7-7 0-113.9 48 0zM360 256a136 136 0 1 0 -272 0 136 136 0 1 0 272 0z"],
    "tally-1": [448, 512, [], "e294", "M64 32l0 448-64 0 0-448 64 0z"],
    "trash-can": [448, 512, [61460, "trash-alt"], "f2ed", "M144-16l160 0 16 48 128 0 0 64-448 0 0-64 128 0 16-48zM32 144l384 0 0 368-384 0 0-368zm112 64l-48 0 0 240 48 0 0-240zm104 0l-48 0 0 240 48 0 0-240zm104 0l-48 0 0 240 48 0 0-240z"],
    "puzzle": [512, 512, [], "e443", "M304 0l208 0 0 208-80 0 0 16c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-16-64 0 0-64 32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0 0-80zM0 272l0-208 208 0 0 64 16 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-16 0 0 80-64 0 0-32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 32-80 0zM0 512l0-208 208 0 0 64-32 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l32 0 0 80-208 0zM240 304l64 0 0 32c0 17.7 14.3 32 32 32s32-14.3 32-32l0-32 80 0 0 208-208 0 0-208z"],
    "table-cells": [448, 512, ["th"], "f00a", "M384 96l0 64-64 0 0-64 64 0zm0 128l0 64-64 0 0-64 64 0zm0 128l0 64-64 0 0-64 64 0zM256 288l-64 0 0-64 64 0 0 64zm-64 64l64 0 0 64-64 0 0-64zm-64-64l-64 0 0-64 64 0 0 64zM64 352l64 0 0 64-64 0 0-64zm0-192l0-64 64 0 0 64-64 0zm128 0l0-64 64 0 0 64-64 0zM64 32l-64 0 0 448 448 0 0-448-384 0z"],
    "trash-can-list": [640, 512, [], "e2ab", "M336-16l16 48 96 0 0 64-416 0 0-64 96 0 16-48 192 0zM480 128l160 0 0 64-160 0 0-64zm0 128l128 0 0 64-128 0 0-64zm96 128l0 64-96 0 0-64 96 0zM64 144l352 0 0 368-352 0 0-368zm144 64l-48 0 0 240 48 0 0-240zm112 0l-48 0 0 240 48 0 0-240z"],
    "ribbon": [384, 512, [127895], "f4d6", "M95 0L289 0 293.7 7.7c15.8 25.9 45.2 73.9 88 144l5.9 9.6-7 8.8-102.2 127.7 86.2 108.3 9.9 12.5-12.5 10-80 64-12.5 10-10-12.5-256-320-7-8.8 5.9-9.6C101.9-11.3 92.3 4.5 95 0zm97 189.2l48.6-61.2-97.3 0 48.6 61.2zM75 336.2L161.3 444c-29 36.2-44.6 55.7-46.8 58.5l-12.5-10-80-64-12.5-10 9.9-12.5 55.5-69.8z"],
    "landmark-flag": [512, 512, [], "e51c", "M368-32l-144 0 0 160-208 0 0 64 48 0 0 224-64 48 0 48 512 0 0-48-64-48 0-224 48 0 0-64-224 0 0-64 96 0 0-96zm32 224l0 224-64 0 0-224 64 0zm-112 0l0 224-64 0 0-224 64 0zm-112 0l0 224-64 0 0-224 64 0z"],
    "badminton": [576, 512, [], "e33a", "M480.2 380c28.2 0 52.4 20.1 57.6 47.8l18.1 96.5 3.7 19.7-.2 0-40.5 0c-.8-4.3-3.8-20.3-9-48l-9.7 0 0 48-40 0 0-48-9.7 0c-5.2 27.7-8.2 43.7-9 48l-40.5 0-.2 0 3.7-19.7 18.1-96.5 1.2-5.1c7-25 30-42.7 56.4-42.7zm-75-395.8c40 1.7 78.8 16.6 108.5 46.3l5.8 6.1c27.7 30.9 40.7 70.3 40.7 110.5l-.3 10.2c-2.7 51-25.8 103-66.7 143.8-54.4 54.4-131.8 78.6-198.2 61.6-29.4-7.5-62.9-5.5-84.3 16l-37.4 37.3 16 16-109.2 109.3-77.2-77.3 109.2-109.3 16 16 37.6-37.6c21.4-21.4 23.5-54.7 16-83.9-3-11.8-4.8-24-5.3-36.2l-.2-8c0-54.2 23.4-110.5 66.9-154S343-16 397.2-16l8 .2zm-8 63.8c-36 0-76.4 15.8-108.8 48.2S240.2 168.9 240.2 205l.4 10.4c2.1 23.9 11.4 45 27.3 60.9 40.4 40.4 120.7 39 180.1-20.5 30.4-30.4 46.2-67.7 48-102l.2-6.8c0-28.2-9.6-53.2-27.7-71.3-15.9-15.9-37-25.2-60.9-27.3L397.2 48z"],
    "up-to-bracket": [448, 512, [], "e66e", "M206.6 167.5L224 149 241.4 167.5c107 113.3 165 174.7 174.2 184.5l-127.7 0 0 160-128 0 0-160-127.7 0c9.2-9.7 67.3-71.2 174.2-184.5zM64 160l0 32-64 0 0-192 448 0 0 192-64 0 0-128-320 0 0 96z"],
    "chart-line-up-down": [512, 512, [], "e5d7", "M64 32l0 384 448 0 0 64-512 0 0-448 64 0zM97.4 209.4c89.6-89.6 134.4-134.4 134.6-134.6 9.3 9.3 36 36 80 80l77.4-77.4-45.4-45.4 136 0 0 136-45.4-45.4c-79.6 79.6-120.4 120.4-122.6 122.6-9.3-9.3-36-36-80-80l-89.4 89.4-45.3-45.3zM480 352l-136 0 45.4-45.4-35.4-35.4 45.3-45.3 35.4 35.4 45.4-45.4 0 136z"],
    "up-down-left-right": [576, 512, ["arrows-alt"], "f0b2", "M265.6 502.6l22.6 22.6C312.6 500.9 392.4 421.1 413.5 400l-93.3 0 0-112 112 0 0 93.3c88.4-88.4 120.2-120.2 125.3-125.3-24.4-24.4-104.2-104.2-125.3-125.3l0 93.3-112 0 0-112 93.3 0C325.1 23.6 293.3-8.2 288.3-13.3 263.9 11.1 184.1 90.9 163 112l93.3 0 0 112-112 0 0-93.3C55.9 219.1 24.1 250.9 19 256 43.4 280.4 123.2 360.2 144.3 381.3l0-93.3 112 0 0 112-93.3 0c37.5 37.5 71.7 71.7 102.6 102.6z"],
    "garage-empty": [576, 512, [], "e6c9", "M0 96l0 416 64 0 0-320 448 0 0 320 64 0 0-416-288-96-288 96z"],
    "car-side": [640, 512, [128663], "f5e4", "M128 32l-22.7 0-7.5 21.4-48.5 138.6-49.3 0 0 208 64.4 0c4 44.9 41.7 80 87.6 80s83.6-35.1 87.6-80l144.7 0c4 44.9 41.7 80 87.6 80s83.6-35.1 87.6-80l80.4 0 0-208-120 0-110.4-147.2-9.6-12.8-272 0zM440 192l-152 0 0-96 80 0 72 96zM240 96l0 96-122.9 0 33.6-96 89.3 0zM152 352a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm280 40a40 40 0 1 1 80 0 40 40 0 1 1 -80 0z"],
    "trash-arrow-up": [448, 512, ["trash-restore"], "f829", "M304-16l16 48 128 0 0 64-448 0 0-64 128 0 16-48 160 0zM32 144l384 0-24 368-336 0-24-368zm209 79l-17-17c-2.1 2.1-31.8 31.8-89 89l-17 17 33.9 33.9c9-9 25-25 48-48l0 126.1 48 0 0-126.1c23 23 39 39 48 48L329.9 312c-2.1-2.1-31.8-31.8-89-89z"],
    "life-ring": [512, 512, [], "f1cd", "M367.2 412.5C335.9 434.9 297.5 448 256 448s-79.9-13.1-111.2-35.5l58-58c15.8 8.6 34 13.5 53.3 13.5s37.4-4.9 53.3-13.5l58 58zm91 .5c33.7-43.3 53.8-97.8 53.8-157S491.9 142.4 458.2 99l19-19-45.3-45.3-19 19C369.6 20.1 315.2 0 256 0S142.4 20.1 99 53.8l-19-19-45.3 45.3 19 19C20.1 142.4 0 196.8 0 256S20.1 369.6 53.8 413l-19 19 45.3 45.3 19-19c43.3 33.7 97.8 53.8 157 53.8s113.6-20.1 157-53.8l19 19 45.3-45.3-19-19zm-45.7-45.7l-58-58c8.6-15.8 13.5-34 13.5-53.3s-4.9-37.4-13.5-53.3l58-58C434.9 176.1 448 214.5 448 256s-13.1 79.9-35.5 111.2zM367.2 99.5l-58 58c-15.8-8.6-34-13.5-53.3-13.5s-37.4 4.9-53.3 13.5l-58-58C176.1 77.1 214.5 64 256 64s79.9 13.1 111.2 35.5zM157.5 309.3l-58 58C77.1 335.9 64 297.5 64 256s13.1-79.9 35.5-111.2l58 58c-8.6 15.8-13.5 34-13.5 53.3s4.9 37.4 13.5 53.3zM208 256a48 48 0 1 1 96 0 48 48 0 1 1 -96 0z"],
    "bar-progress-three-quarters": [512, 512, [], "e6a9", "M352 160l0 192 96 0 0-192-96 0zM0 96l512 0 0 320-512 0 0-320z"],
    "copyright": [512, 512, [169], "f1f9", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM205.1 306.9c28.1 28.1 73.7 28.1 101.8 0l33.9 33.9c-46.9 46.9-122.8 46.9-169.7 0s-46.9-122.8 0-169.7 122.8-46.9 169.7 0l-33.9 33.9c-28.1-28.1-73.7-28.1-101.8 0s-28.1 73.7 0 101.8z"],
    "leafy-green": [576, 512, [129388], "e41d", "M216.5 26.2c-34.9-34.9-91.5-34.9-126.4 0-15.4 15.4-24 35.1-25.8 55.3-15.3 2.5-30.1 9.6-41.9 21.4-28.3 28.3-29.8 73.3-4.5 103.4l0 72.6 54.2 54.2 0 80.4 23.9-23.9 0-98.7 48-48 0-96 66.1-66.1c2.8-15.4 8.4-29.8 16.2-42.7-2.9-4.1-6.2-8-9.9-11.7zM549.9 183.9C566.2 164.4 576 139.4 576 112 576 50.1 525.9 0 464 0 436.6 0 411.6 9.8 392.1 26.1 376.3 14.7 357 8 336 8 285.8 8 244.6 46.5 240.4 95.6l-64.4 64.4 0 96-48 48 0 98.7C99.6 431.2 79.2 451.6 66.7 464L112 509.3c12.4-12.4 32.8-32.8 61.3-61.3l98.7 0 48-48 96 0 64.4-64.4c49.1-4.2 87.6-45.4 87.6-95.6 0-21-6.7-40.3-18.1-56.1zM486.6 112l-11.3 11.3-84.7 84.7 73.4 0 0 32-105.4 0c-41.4 41.4-77.2 77.2-107.3 107.3L240 358.6 217.4 336c2.2-2.2 20.4-20.4 54.6-54.6l0-105.4 32 0 0 73.4c11.9-11.9 61.5-61.5 148.7-148.7L464 89.4 486.6 112z"],
    "highlighter-line": [576, 512, [], "e1af", "M229.7 229.7l203.4-146.1 27.1 27.1-146.1 203.4-84.5-84.5zM128 224l0 96 0 0-48 48 96 96 48-48 96 0 224-312-104-104-312 224zM58.7 414.6l-54.1 54.1-4.7 4.7 0 38.6 102.6 0 4.7-4.7 22.1-22.1-70.6-70.6zM280 464l-24 0 0 48 320 0 0-48-296 0z"],
    "rectangle-history-circle-user": [576, 512, [], "e4a4", "M257.4 480c-11.2-24.4-17.4-51.4-17.4-80 0-106 86-192 192-192l-432 0 0 272 257.4 0zM464 160l0-48-416 0 0 48 416 0zM416 64l0-48-320 0 0 48 320 0zM576 400a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-64.5 78.9C491.2 499.4 463.1 512 432 512s-59.2-12.6-79.5-33.1l15.5-30.9 128 0 15.5 30.9zM384 368a48 48 0 1 1 96 0 48 48 0 1 1 -96 0z"],
    "ferris-wheel": [512, 512, [], "e174", "M304 0l-96 0 0 37.2c-24.2 5.3-46.9 14.5-67.4 26.8L64 64 64 140.6C51.6 161.1 42.4 183.8 37.2 208l-37.2 0 0 96 37.2 0c5.3 24.2 14.5 46.9 26.8 67.4l0 76.6 57.2 0 24.5-76.1c-25.1-23.9-42.5-56-47.9-91.9l65.2 0c-2-7.7-3-15.7-3-24s1-16.3 3-24l-65.2 0c4-26.3 14.3-50.4 29.4-70.9l46.1 46.1c8.3-14 20-25.7 33.9-33.9l-46.1-46.1c20.5-15.1 44.6-25.4 70.9-29.4l0 65.2c7.7-2 15.7-3 24-3s16.3 1 24 3l0-65.2c26.3 4 50.4 14.3 70.9 29.4l-46.1 46.1c14 8.3 25.7 20 33.9 33.9l46.1-46.1c15.1 20.5 25.4 44.6 29.4 70.9L349 232c2 7.7 3 15.7 3 24s-1.1 16.3-3 24l65.2 0c-5.4 35.9-22.8 68-47.9 91.9l24.5 76.1 57.2 0 0-76.6c12.4-20.6 21.6-43.3 26.8-67.4l37.2 0 0-96-37.2 0c-5.3-24.2-14.5-46.9-26.8-67.4l0-76.6-76.6 0C350.9 51.6 328.2 42.4 304 37.2L304 0zM166.5 464c-2.8 8.7-7.9 24.7-15.4 48l209.8 0c-21-65.3-24.7-76.7-59.2-184.3l-12.1-37.5c8.9-8.7 14.4-20.8 14.4-34.2 0-24-17.6-43.9-40.6-47.4-2.4-.4-4.9-.6-7.4-.6s-5 .2-7.4 .6c-23 3.6-40.6 23.4-40.6 47.4 0 13.4 5.5 25.5 14.4 34.2-3.5 11-20.6 64-51.1 159.1L166.5 464z"],
    "arrow-up-from-arc": [512, 512, [], "e4b4", "M256 448C150 448 64 362 64 256l0-32-64 0 0 32C0 397.4 114.6 512 256 512S512 397.4 512 256l0-32-64 0 0 32c0 106-86 192-192 192zM121.4 121.4L98.7 144 144 189.3c9.3-9.3 36-36 80-80l0 242.7 64 0 0-242.7 80 80 45.3-45.3c-.2-.2-45.1-45.1-134.6-134.6L256-13.3c-.2 .2-45.1 45.1-134.6 134.6z"],
    "grid-dividers": [448, 512, [], "e3ad", "M0 16l448 0 0 48-448 0 0-48zm112 96l0 112-112 0 0-112 112 0zm0 256l0 112-112 0 0-112 112 0zm56 0l112 0 0 112-112 0 0-112zM280 112l0 112-112 0 0-112 112 0zm56 256l112 0 0 112-112 0 0-112zM448 112l0 112-112 0 0-112 112 0zM24 272l424 0 0 48-448 0 0-48 24 0z"],
    "lightbulb-dollar": [384, 512, [], "f670", "M288 358.3c57.4-33.2 96-95.2 96-166.3 0-106-86-192-192-192S0 86 0 192c0 71.1 38.6 133.1 96 166.3l0 25.7 192 0 0-25.7zM96 528l192 0 0-96-192 0 0 96zM216 80l0 24 28 0 0 40-67.5 0c-6.9 0-12.5 5.6-12.5 12.5 0 6.1 4.4 11.3 10.4 12.3l41.7 7c25.3 4.2 43.9 26.1 43.9 51.8 0 26.1-19 47.7-44 51.8l0 24.7-40 0 0-24-44 0 0-40 75.5 0c6.9 0 12.5-5.6 12.5-12.5 0-6.1-4.4-11.3-10.4-12.3l-41.7-7c-25.3-4.2-43.9-26.1-43.9-51.8 0-28.8 23.2-52.2 52-52.5l0-24 40 0z"],
    "coffin": [384, 512, [9904], "f6c6", "M0 144L104 512 280 512 384 144 272 0 112 0 0 144z"],
    "file-prescription": [384, 512, [], "f572", "M0 0L240 0 384 144 384 512 0 512 0 0zM208 58.5L208 176 325.5 176 208 58.5zM88 208l-24 0 0 176 48 0 0-48 32 0c2.4 0 4.8-.1 7.2-.4L193 374.9c-18.4 17.4-32.7 30.9-43 40.6l33 34.9c9.9-9.4 24.9-23.6 45.1-42.6 20 18.7 35 32.8 45 42.2l32.8-35c-10.4-9.7-24.7-23.1-42.9-40.2 18.3-17.3 32.6-30.8 42.9-40.6l-33-34.9c-9.9 9.4-24.9 23.6-45 42.5l-33.1-31c8.2-10.8 13.1-24.2 13.1-38.8 0-35.3-28.7-64-64-64l-56 0zm32 80l-8 0 0-32 32 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-24 0z"],
    "eraser": [640, 512, [], "f12d", "M218.5 416l107 0 69.3-69.3-165.5-165.5-122.7 122.7 112 112zM256 480l-64 0C90.6 378.6 31.9 319.9 16 304L61.3 258.7 290.7 29.3 336-16c10.1 10.1 80.4 80.4 210.7 210.7l45.3 45.3-176 176 160 0 0 64-320 0z"],
    "flask-round-poison": [384, 512, ["flask-poison"], "f6e0", "M64 0l256 0 0 64-32 0 0 89.7c57.3 33.2 96 95.2 96 166.3 0 106-86 192-192 192S0 426 0 320c0-71.1 38.7-133.1 96-166.3L96 64 64 64 64 0zM304 312c0-48.6-50.1-88-112-88S80 263.4 80 312c0 29.9 19 56.3 48 72.2l0 47.8 128 0 0-47.8c29-15.9 48-42.3 48-72.2zM152 288a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm56 24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"],
    "camera-clock": [640, 512, [], "e767", "M224 32l-32 64-128 0 0 384 257.4 0c-11.2-24.4-17.4-51.4-17.4-80 0-5.8 .3-11.5 .8-17.2-45.8-7.3-80.8-47-80.8-94.8 0-53 43-96 96-96 33 0 62.1 16.7 79.4 42 28.4-16.6 61.4-26 96.6-26 28.6 0 55.6 6.2 80 17.4l0-129.4-128 0-32-64-192 0zM640 400a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zM512 320l0 64 48 0 0 32-80 0 0-96 32 0z"],
    "circle-half-horizontal": [512, 512, [], "e80c", "M512 256c0 141.4-114.6 256-256 256S0 397.4 0 256l512 0z"],
    "square-t": [448, 512, [], "e280", "M448 32l-448 0 0 448 448 0 0-448zM136 144l200 0 0 48-88 0 0 176-48 0 0-176-88 0 0-48 24 0z"],
    "circle-shekel": [512, 512, [], "e703", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM384 160l0 144c0 39.8-32.2 72-72 72l-112 0c0-2.7 0-45.3 0-128l0-24 48 0c0 6.7 0 41.3 0 104l64 0c13.3 0 24-10.7 24-24l0-168 48 0 0 24zM152 136l88 0c39.8 0 72 32.2 72 72l0 80-48 0 0-80c0-13.3-10.7-24-24-24l-64 0 0 192-48 0 0-240 24 0z"],
    "space-station-moon-construction": [512, 512, ["space-station-moon-alt"], "e034", "M510 287.9c1.3-10.5 2-21.1 2-31.9 0-10.8-.7-21.5-2-32l-62 0 0-64-96 0 0-64 64 0 0-39.9C372.2 21 316.5 0 256 0 114.6 0 0 114.6 0 256 0 266.8 .7 277.4 2 287.9 74.4 313.1 161.6 328 256 328s181.6-14.9 254-40.1zM384 367c-40.9 5.9-83.9 9-128 9-87 0-169.2-12-241-33.5 35.5 98.8 130 169.5 241 169.5 76.5 0 145.1-33.5 192-86.7l0-25.3-64 0 0-33zM192 192a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm0-112a80 80 0 1 1 0 160 80 80 0 1 1 0-160z"],
    "circle-moon": [512, 512, [], "e7e0", "M256 512a256 256 0 1 1 0-512 256 256 0 1 1 0 512zm0-448C150 64 64 150 64 256s86 192 192 192c63.1 0 119.1-30.5 154.1-77.5-12.8 3.5-26.2 5.5-40.1 5.5-82.8 0-150-67.2-150-150 0-70.3 48.4-129.3 113.7-145.6-23.8-10.5-50-16.4-77.7-16.4z"],
    "basketball-hoop": [576, 512, [], "f435", "M464 288l-14.1 0-30.1 210.8-1.9 13.2-30.6 0-2.6-3.1-42.4-50.2-38.5 49.5-2.9 3.7-25.7 0-2.9-3.7-38.5-49.5-42.4 50.2-2.6 3.1-30.6 0-1.9-13.2-30.1-210.8-14.1 0 0-48 352 0 0 48zM260.1 427.6l27.9 35.8 27.9-35.8-27.9-33-27.9 33zm-70.6 21.5l19.1-22.6-27.3-35.1 8.3 57.7zm177.9-22.6l19.1 22.6 8.3-57.7-27.3 35.1zM201.2 351.8l33.8 43.5 26.8-31.7-36.8-43.6-23.8 31.7zm113 11.8l26.8 31.7 33.8-43.5-23.8-31.7-36.8 43.6zM288 0C496 0 576 176 576 176l0 176-76.4 33.9 12.4-65.9 0-128-96 0 0-80-256 0 0 80-96 0 0 128 12.3 65.9-76.3-33.9 0-176S80 0 288 0zm0 332.7l37.8-44.7-75.6 0 37.8 44.7zm-116.3-8.3l27.3-36.4-32.5 0 5.2 36.4zm232.6 0l5.2-36.4-32.5 0 27.3 36.4zM368 192l-160 0 0-32 160 0 0 32z"],
    "code-simple": [640, 512, [], "e13d", "M246.9 118.6l22.6-22.6-45.3-45.3-22.6 22.6-160 160-22.6 22.6 22.6 22.6 160 160 22.6 22.6 45.3-45.3-22.6-22.6-137.4-137.4 137.4-137.4zm146.7 0l137.4 137.4-160 160 45.3 45.3 205.3-205.3-22.6-22.6-160-160-22.6-22.6-45.3 45.3 22.6 22.6z"],
    "left-to-dotted-line": [512, 512, [], "e6c3", "M0 64l64 0 0 64-64 0 0-64zM117.1 256l202.9-192 0 128 192 0 0 128-192 0 0 128-202.9-192zM0 234.7l0-64 64 0 0 64-64 0zm0 42.7l64 0 0 64-64 0 0-64zM0 448l0-64 64 0 0 64-64 0z"],
    "hockey-stick-puck": [640, 512, [], "e3ae", "M128 512l-64 0 0-192 64 0 0 192zM553.6-17.8l-203.9 509.7-8.1 20.1-165.7 0 0-192 173.5 0 132.7-331.9 11.9-29.7 59.4 23.8zM640 512l-192 0 0-96 192 0 0 96z"],
    "hourglass-start": [384, 512, ["hourglass-1"], "f251", "M0 0l384 0 0 64-32 0 0 77.3-9.4 9.4-105.4 105.4 114.7 114.7 0 77.3 32 0 0 64-384 0 0-64 32 0 0-77.3 9.4-9.4 105.4-105.4-105.4-105.4-9.4-9.4 0-77.3-32 0 0-64zM96 397.3l0 50.7 192 0 0-50.7-96-96-96 96z"],
    "circle-left": [512, 512, [61840, "arrow-alt-circle-left"], "f359", "M512 256a256 256 0 1 0 -512 0 256 256 0 1 0 512 0zM256 384l-8 0-128-128 128-128 8 0 0 80 128 0 0 96-128 0 0 80z"],
    "restroom-simple": [640, 512, [], "e23a", "M192 64A64 64 0 1 0 64 64 64 64 0 1 0 192 64zm32 96l-192 0 0 192 32 0 0 160 128 0 0-160 32 0 0-192zM344 0l-48 0 0 512 48 0 0-512zM512 128a64 64 0 1 0 0-128 64 64 0 1 0 0 128zM640 384l-64-224-128 0-64 224 64 0 0 128 128 0 0-128 64 0z"],
    "cruzeiro-sign": [448, 512, [], "e152", "M240.5 96c-88.4 0-160 71.6-160 160 0 71.6 47.1 132.3 112 152.7l0-176.7 48 0 0 22.7C256 245.2 274 240 292.7 240l35.8 0 0 48-35.8 0c-18.8 0-36.1 10-45.4 26.3-4.5 7.9-6.9 16.8-6.9 25.9l0 75.8c52.3 0 98.8-25.1 128-64l51.2 38.4c-40.8 54.3-105.9 89.6-179.2 89.6-123.7 0-224-100.3-224-224S116.8 32 240.5 32c73.3 0 138.4 35.2 179.2 89.6L368.5 160c-29.2-38.9-75.7-64-128-64z"],
    "smoking": [576, 512, [128684], "f48d", "M336 0l48 0 0 43c0 40.3 16 79 44.5 107.5l21 21C469 191 480 217.4 480 245l0 43-48 0 0-43c0-14.9-5.9-29.1-16.4-39.6l-21-21C357.1 146.9 336 96 336 43l0-43zM576 288l-48 0 0-43c0-40.3-16-79-44.5-107.5l-21-21C443 97 432 70.6 432 43l0-43 48 0 0 43c0 14.9 5.9 29.1 16.4 39.6l21 21C554.9 141.1 576 192 576 245l0 43zM320 448l96 0 0-32-96 0 0 32zM0 352l480 0 0 160-480 0 0-160zm576 24l0 136-48 0 0-160 48 0 0 24z"],
    "chart-pie-simple-circle-dollar": [640, 512, [], "e605", "M496 208C512.1 208 527.7 210 542.6 213.7 529.5 93.5 427.7 0 304 0l0 240 85.8 0c30.4-20.2 66.9-32 106.2-32zM304 400c0-41.8 13.4-80.5 36-112l-84 0 0-255.5c-125.1 8.2-224 112.3-224 239.5 0 132.5 107.5 240 240 240 21.6 0 42.5-2.9 62.4-8.2-19.3-29.9-30.4-65.6-30.4-103.8zm336 0a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zM512 328l32 0 0 32-61.8 0c-5.6 0-10.2 4.6-10.2 10.2 0 4.9 3.5 9.1 8.3 10l45 8.2c20 3.6 34.6 21.1 34.6 41.5 0 23.3-18.9 42.2-42.2 42.2l-5.8 0 0 24-32 0 0-24-32 0 0-32 69.8 0c5.6 0 10.2-4.6 10.2-10.2 0-4.9-3.5-9.1-8.3-10l-45-8.2c-20-3.6-34.6-21.1-34.6-41.5 0-22.6 17.7-41 40-42.1l0-24.1 32 0 0 24z"],
    "user-vneck-hair": [448, 512, [], "e462", "M304 144c0 44.2-35.8 80-80 80s-80-35.8-80-80l0-16 48 0c20.8 0 41-6.7 57.6-19.2L288 80 288 80c10 13.4 16 30 16 48l0 16zM224 0C153.3 0 96 57.3 96 128l0 16c0 70.7 57.3 128 128 128s128-57.3 128-128l0-16C352 57.3 294.7 0 224 0zm64 320l-64 64-64-64-80 0-64 192 416 0-64-192-80 0z"],
    "square-poll-vertical": [448, 512, ["poll"], "f681", "M448 32l-448 0 0 448 448 0 0-448zM144 224l0 160-48 0 0-160 48 0zm56-96l48 0 0 256-48 0 0-256zM352 288l0 96-48 0 0-96 48 0z"],
    "person-circle-minus": [640, 512, [], "e540", "M168 24a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm-11.4 88l134.8 0 9.6 13.2 85.2 117.3c-17.8 12.4-33.4 27.8-46.1 45.5l-36.1-49.7 0 305.7-64 0 0-208-32 0 0 208-64 0 0-305.7c-28.6 39.4-47.6 65.6-56.9 78.4l-51.8-37.6 18.8-25.9 92.9-128 9.6-13.2zM352 400a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm224 16l0-32-160 0 0 32 160 0z"],
    "envelope-open-dollar": [576, 512, [], "f657", "M473.8 187.3L288 48 102.2 187.3 288 320 473.8 187.3zM32 160l256-192 256 192 0 96-96 0 0 36.5c-31 17.1-52 50.1-52 88 0 13.9 2.8 27.2 8 39.3l0 60.2-372 0 0-320zM536 304l0 24 28 0 0 40-67.5 0c-6.9 0-12.5 5.6-12.5 12.5 0 6.1 4.4 11.3 10.4 12.3l41.7 7c25.3 4.2 43.9 26.1 43.9 51.8 0 26.1-19 47.7-44 51.8l0 24.7-40 0 0-24-44 0 0-40 75.5 0c6.9 0 12.5-5.6 12.5-12.5 0-6.1-4.4-11.3-10.4-12.3l-41.7-7c-25.3-4.2-43.9-26.1-43.9-51.8 0-28.8 23.2-52.2 52-52.5l0-24 40 0z"],
    "biohazard": [576, 512, [9763], "f780", "M260-3.3c-68.7 13.3-120.6 74.1-120.6 147 0 25.1 6.1 48.7 17 69.5-21 1.8-42 8.2-61.5 19.5-62.8 36.5-89.2 112-66.4 178.4l22.7-13.2c-1.1-6.1-1.7-12.7-1.7-19.6 0-123.5 184.4-123.5 184.4 0 0 92.6-103.5 115.8-155.4 69.6L57 460.5c45.8 53.1 124.1 67.9 186.9 31.4 17.9-10.4 32.8-23.9 44.5-39.4 11.7 15.6 26.6 29.1 44.5 39.4 62.8 36.5 141.1 21.7 186.9-31.5l-21.6-12.5c-51.9 46.2-155.5 23-155.5-69.6 0-123.5 184.4-123.5 184.4 0 0 6.9-.6 13.5-1.7 19.6l22.7 13.2c22.9-66.4-3.5-142-66.4-178.4-19.5-11.3-40.4-17.7-61.5-19.5 10.9-20.8 17-44.4 17-69.5 0-72.9-51.9-133.7-120.6-147l0 25.9c93.7 26.1 84.2 181.6-28.4 181.6S166.3 48.7 260 22.6l0-25.9zM248.4 288a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zM435 317.7c-16.2 0-31.4 5.5-42.1 15-10.1 9.1-18.1 23.4-18.1 45.6 0 21.1 7.2 35 16.5 44.1 32.2-24.6 55.5-60.5 63.9-101.8-6.3-1.9-13.2-3-20.2-3zM202 378.3c0-22.3-8-36.6-18.1-45.6-10.7-9.6-25.9-15-42.1-15-7 0-13.9 1-20.2 3 8.4 41.3 31.6 77.2 63.9 101.8 9.4-9.1 16.5-23.1 16.5-44.2zm41.2-224.3c9 10.2 23.2 18.2 45.2 18.2s36.2-8 45.2-18.2c6.7-7.6 11.5-17.5 13.6-28.4-18.3-6.8-38.2-10.5-58.8-10.5s-40.5 3.7-58.8 10.5c2.2 10.9 6.9 20.8 13.6 28.5z"],
    "objects-align-bottom": [512, 512, [], "e3bb", "M512 512l0-64-512 0 0 64 512 0zM64 384l160 0 0-384-160 0 0 384zm224 0l160 0 0-256-160 0 0 256z"],
    "scroll-old": [576, 512, [], "f70f", "M88 32C39.4 32 0 71.4 0 120l0 88 112 0 0 48 48 32-48 32 0 160 16 0c39.8 0 72-32.2 72-72l0-104 248 0 0-112-48-32 48-32c0-53-43-96-96-96L88 32zM448 480l16 0c44.2 0 80-35.8 80-80l0-48-160 0-32 48-32-48-72 0 0 56c0 27-8.9 51.9-24 72l224 0zM112 80l0 80-64 0 0-40c0-22.1 17.9-40 40-40l24 0z"],
    "bell-concierge": [512, 512, [128718, "concierge-bell"], "f562", "M216 64l-24 0 0 48 40 0 0 33.3C124.8 156.7 40.2 243.7 32.6 352l446.9 0C471.8 243.7 387.2 156.7 280 145.3l0-33.3 40 0 0-48-104 0zM24 400l-24 0 0 48 512 0 0-48-488 0z"],
    "ruler-horizontal": [576, 512, [], "f547", "M0 384l0-256 72 0 0 128 48 0 0-128 48 0 0 96 48 0 0-96 48 0 0 128 48 0 0-128 48 0 0 96 48 0 0-96 48 0 0 128 48 0 0-128 72 0 0 256-576 0z"],
    "horse": [576, 512, [128014], "f6f0", "M448 238.1l0-78.1 16 0 32 64 80-32 0-128-32-32 32 0 0-32-128 0C377.3 0 320 57.3 320 128l-171.2 0C118.1 128 91.2 144.3 76.3 168.8 33.2 174.5 0 211.4 0 256l0 80 48 0 0-80c0-13.4 6.6-25.2 16.7-32.5 1.6 13 6.3 25.4 13.6 36.4l42.4 63.6c-18.7 18.6-34.5 34.5-47.6 47.6 1.5 4.6 17.2 51.6 47 141l101.2 0-38.3-115c20.2-20.2 33.9-33.9 41.1-41.1l0-35.9 83.7 23.9c4.1 1.2 8.2 2.1 12.3 2.8l0 165.3 96 0 0-196.3c19.2-19.2 31.5-45.7 32-75.7l0 0 0-1.9zM496 64a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"],
    "angle-90": [448, 512, [], "e08d", "M64 64l0-32-64 0 0 448 448 0 0-64-384 0 0-352zM178 169l25.6-41c-28.5-13.8-59.3-23.6-91.7-28.4l0 48.6c23.2 4.1 45.3 11.2 66 20.8zM331.8 368l48.6 0c-4.9-32.4-14.6-63.2-28.4-91.7L311 302c9.6 20.7 16.6 42.9 20.8 66zm-4-133.2c-22.3-32.4-50.3-60.4-82.7-82.7l-25.5 40.8c26.2 18.3 49.1 41.2 67.4 67.4l40.8-25.5z"],
    "down-to-bracket": [448, 512, [], "e4e7", "M206.6 344.5L224 363 241.4 344.5c107-113.3 165-174.7 174.2-184.5l-127.7 0 0-160-128 0 0 160-127.7 0c9.2 9.7 67.3 71.2 174.2 184.5zM64 352l0-32-64 0 0 192 448 0 0-192-64 0 0 128-320 0 0-96z"],
    "book-copy": [576, 512, [], "e0be", "M224 384l352 0 0-64-32 0 0-64 32 0 0-256-352 0 0 384zm64-80c0-26.5 21.5-48 48-48l144 0 0 64-192 0 0-16zM0 128l0 384 352 0 0-64-288 0 0-16c0-26.5 21.5-48 48-48l64 0 0-256-176 0z"],
    "calendar": [448, 512, [128197, 128198], "f133", "M160 0l-64 0 0 64-96 0 0 112 448 0 0-112-96 0 0-64-64 0 0 64-128 0 0-64zM0 224l0 256 448 0 0-256-448 0z"],
    "hands-holding-child": [640, 512, [], "e4fa", "M320 48a40 40 0 1 0 0-80 40 40 0 1 0 0 80zM290.5 64l-8.8 0-6.7 5.7c-39 33-61.9 52.4-68.8 58.2l31 36.7c12-10.1 24.7-20.9 38.1-32.2-8.8 70-13.4 107.5-14.1 112.6l47.6 6c1.8-14 4.2-33.6 7.3-58.8l7.6 0c3.1 25.2 5.6 44.8 7.3 58.8l47.6-6c-.6-5-5.3-42.6-14.1-112.6 13.4 11.4 26.1 22.1 38.1 32.2l31-36.7C427 122 404 102.6 365 69.7l-6.7-5.7-67.9 0zM80 64l-80 0 0 301.3 9.4 9.4 128 128 9.4 9.4 141.3 0 0-173.3-9.4-9.4C125.1 175.9 201.5 252.2 160 210.7L114.7 256c48.8 48.8 65.1 65.1 91 91L164.1 374.8 80 290.7 80 64zm480 0l0 226.7-84.1 84.1-41.7-27.8c102.9-102.9 58.7-58.7 91-91L480 210.7c-44.2 44.2-69.7 69.7-118.6 118.6l-9.4 9.4 0 173.3 141.3 0 146.7-146.7 0-301.3-80 0z"],
    "poll-people": [512, 512, [], "f759", "M80 128a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm0 256a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm384-48l0 64-144 0 0-64 144 0zM272 288l-48 0 0 160 288 0 0-160-240 0zM384 112l80 0 0 64-80 0 0-64zM224 64l0 160 288 0 0-160-288 0zM0 480l160 0-24-64-112 0-24 64zM24 160l-24 64 160 0-24-64-112 0z"],
    "bracket-round": [192, 512, ["parenthesis"], "28", "M0 256C0 140.2 71.9 62.9 110.2 37.4l35.5 53.3C120.1 107.7 64 167 64 256s56.1 148.3 81.8 165.4l-35.5 53.3C71.9 449.1 0 371.8 0 256z"],
    "truck-container": [640, 512, [], "f4dc", "M0 32l352 0 0 256-352 0 0-256zM104 80l-48 0 0 160 48 0 0-160zm96 0l-48 0 0 160 48 0 0-160zm96 0l-48 0 0 160 48 0 0-160zm120 48l141.3 0 9.4 9.4 64 64 9.4 9.4 0 237.3-51.3 0c-10.4 36.9-44.4 64-84.7 64s-74.2-27.1-84.7-64l-118.6 0c-10.4 36.9-44.4 64-84.7 64-25.2 0-48-10.6-64-27.6-16 17-38.8 27.6-64 27.6-48.6 0-88-39.4-88-88l0-88 416 0 0-208zM576 237.3l-45.3-45.3-50.7 0 0 96 96 0 0-50.7zM128 424a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zm376 40a40 40 0 1 0 0-80 40 40 0 1 0 0 80zM256 424a40 40 0 1 0 -80 0 40 40 0 1 0 80 0z"],
    "eye-evil": [640, 512, [], "f6db", "M258.1 111.4L320 0 381.9 111.4c11 2.7 21.7 6.2 31.8 10.3l136.3-39-59 94.5c7.1 8.9 13 18.4 17.7 28.3L640 256 508.7 306.5c-4.6 10-10.6 19.4-17.7 28.3l59 94.5-136.3-39c-10.1 4.1-20.7 7.5-31.8 10.3L320 512 258.1 400.6c-11-2.7-21.7-6.2-31.8-10.2l-136.3 39 59-94.5c-7.1-8.9-13-18.4-17.7-28.3L0 256 131.3 205.5c4.6-10 10.6-19.4 17.7-28.3l-59-94.5 136.3 39c10.1-4.1 20.7-7.5 31.8-10.3zM320 352c53 0 96-43 96-96 0-19.7-6-38.1-16.2-53.3-16.9 9.7-35.7 16.5-55.8 19.5 4.6 9.3 7.9 20.7 7.9 33.8 0 40.4-32 64-32 64s-32-23.6-32-64c0-13.1 3.4-24.5 7.9-33.8-20.1-3-38.9-9.8-55.8-19.5-10.2 15.3-16.2 33.6-16.2 53.3 0 53 43 96 96 96z"],
    "play-flip": [512, 512, [], "e780", "M448 16L448 496 16 256 448 16z"],
    "border-inner": [448, 512, [], "f84e", "M252 64l0-28-56 0 0 192-192 0 0 56 192 0 0 192 56 0 0-192 192 0 0-56-192 0 0-164zM8 40l0 48 48 0 0-48-48 0zM8 424l0 48 48 0 0-48-48 0zM56 184l0-48-48 0 0 48 48 0zm336 0l48 0 0-48-48 0 0 48zM56 328l-48 0 0 48 48 0 0-48zm336 0l0 48 48 0 0-48-48 0zM152 424l-48 0 0 48 48 0 0-48zM104 40l0 48 48 0 0-48-48 0zM344 424l-48 0 0 48 48 0 0-48zM296 40l0 48 48 0 0-48-48 0zM440 424l-48 0 0 48 48 0 0-48zM392 40l0 48 48 0 0-48-48 0z"],
    "italic": [384, 512, [], "f033", "M128 32l256 0 0 64-90.7 0-133.3 320 96 0 0 64-256 0 0-64 90.7 0 133.3-320-96 0 0-64z"],
    "microphone-circle-plus": [576, 512, [], "e77d", "M320 0l0 148c-48.5 34.9-80 91.7-80 156 0 4.9 .2 9.8 .5 14.6-5.4 .9-10.9 1.4-16.5 1.4-53 0-96-43-96-96L128 0 320 0zM224 368c8.9 0 17.6-.8 26.1-2.4 5.4 15.8 12.7 30.7 21.8 44.3-7.8 2-15.7 3.5-23.9 4.5l0 49.5 72 0 0 48-192 0 0-48 72 0 0-49.5C105.3 402.7 32 321.9 32 224l0-64 48 0 0 64c0 79.5 64.5 144 144 144zM432 160a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm16 80l0-16-32 0 0 64-64 0 0 32 64 0 0 64 32 0 0-64 64 0 0-32-64 0 0-48z"],
    "down-to-line": [384, 512, ["arrow-alt-to-bottom"], "f34a", "M128 32l0-32 128 0 0 192 127.7 0c-9.2 9.7-67.3 71.2-174.2 184.5L192 395 174.6 376.5C67.6 263.2 9.5 201.7 .3 192l127.7 0 0-160 0 0zM384 512l-384 0 0-64 384 0 0 64z"],
    "circle-cruzeiro": [512, 512, [], "e722", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM163 256c0 44.5 31.2 81.7 73 90.8l0-118.8 40 0 0 17.1c10.7-5.8 23-9.1 36-9.1l8 0 0 40-8 0c-19.9 0-36 16.1-36 36l0 34.8c22.1-4.8 41.2-17.5 54.4-35l38.4 28.8c-25.7 34.2-66.6 56.4-112.8 56.4-77.9 0-141-63.1-141-141s63.1-141 141-141c46.1 0 87.1 22.2 112.8 56.4l-38.4 28.8c-17-22.6-44-37.2-74.4-37.2-51.4 0-93 41.6-93 93z"],
    "cloud-binary": [576, 512, [], "e601", "M144 480l432 0 0-128c0-47.4-25.7-88.7-64-110.9l0-49.1c0-53-43-96-96-96-17.7 0-34.2 4.8-48.4 13.1-24.1-45.8-72.2-77.1-127.6-77.1-79.5 0-144 64.5-144 144l0 24.2C40.1 220 0 273.3 0 336l0 144 144 0zm64-320l80 0 0 112-96 0 0-112 16 0zm16 80l32 0 0-48-32 0 0 48zm112-80l32 0 0 112-32 0 0-80-16 0 0-32 16 0zM224 304l32 0 0 112-32 0 0-80-16 0 0-32 16 0zm96 0l80 0 0 112-96 0 0-112 16 0zm16 80l32 0 0-48-32 0 0 48z"],
    "card-club": [384, 512, [], "e3e9", "M384 512L0 512 0 0 384 0 384 512zM136 352l0 48 112 0 0-48-112 0zm56-240c-35.3 0-64 28.7-64 64 0 5.6 .8 11.1 2.2 16.3-32.6 3-58.2 30.3-58.2 63.7 0 35.3 28.7 64 64 64 24.1 0 45.1-13.4 56-33.1 10.9 19.7 31.9 33.1 56 33.1 35.3 0 64-28.7 64-64 0-33.4-25.6-60.8-58.2-63.7 1.4-5.2 2.2-10.6 2.2-16.3 0-35.3-28.7-64-64-64z"],
    "light-switch-on": [384, 512, [], "e019", "M0 0L384 0 384 512 0 512 0 0zM144 256l0-112 96 0 0 112-96 0zm0 160l144 0 0-320-192 0 0 320 48 0z"],
    "truck-suv": [576, 512, [], "e7c6", "M96 32l-20.3 0-8.6 18.4-64 136-2.6 5.6-.4 0 0 192 48.4 0c-.2 2.6-.4 5.3-.4 8 0 48.6 39.4 88 88 88s88-39.4 88-88c0-2.7-.1-5.4-.4-8l128.7 0c-.2 2.6-.4 5.3-.4 8 0 48.6 39.4 88 88 88s88-39.4 88-88c0-2.7-.1-5.4-.4-8l48.4 0 0-192-85.1 0-78.9-143.4-9.1-16.6-306.9 0zM417.9 192l-161.9 0 0-96 109.1 0 52.8 96zM192 192l-120.9 0 45.2-96 75.7 0 0 96zM96 392a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zm344-40a40 40 0 1 1 0 80 40 40 0 1 1 0-80z"],
    "khanda": [512, 512, [9772], "f66d", "M192 48l64-48 64 48s-6.6 10.6-14.5 27.5C342.5 93.8 368 131.9 368 176s-25.5 82.2-62.5 100.5C313.4 293.4 320 304 320 304l-48 36 0 22.6 34.5-23.7 .1-.1c57.2-39.3 109.4-82.8 109.4-158.2 0-47.6-14.7-106.7-32-132.6 0 0 128 54.5 128 176 0 96-112 192-112 192l-83.4-45.3-32.4 22.3 46.1 31.7c1.8-.4 3.7-.7 5.7-.7 13.3 0 24 10.7 24 24s-10.7 24-24 24c-12.2 0-22.3-9.1-23.8-21l-40.2-27.6 0 28.9c9.6 5.5 16 15.9 16 27.7 0 17.7-14.3 32-32 32s-32-14.3-32-32c0-11.8 6.4-22.2 16-27.7l0-28.9-40.2 27.6c-1.5 11.8-11.6 21-23.8 21-13.3 0-24-10.7-24-24s10.7-24 24-24c2 0 3.9 .2 5.7 .7L227.8 393 195.4 370.7 112 416S0 320 0 224c0-121.5 128-176 128-176-17.3 25.9-32 85.1-32 132.6 0 75.4 52.2 118.9 109.4 158.2l.1 .1 34.5 23.7 0-22.6-48-36s6.6-10.6 14.5-27.5C169.5 258.2 144 220.1 144 176s25.5-82.2 62.5-100.5C198.6 58.6 192 48 192 48zm0 128c0 23.5 12.7 44.1 31.6 55.2 4.9-17.3 8.4-36.2 8.4-55.2s-3.5-37.9-8.4-55.2C204.7 131.9 192 152.5 192 176zm88 0c0 18.9 3.5 37.9 8.4 55.2 18.9-11.1 31.6-31.7 31.6-55.2s-12.7-44.1-31.6-55.2c-4.9 17.3-8.4 36.2-8.4 55.2z"],
    "face-frown-open": [512, 512, [128550, "frown-open"], "f57a", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM176 176a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm128 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM255.6 368c-38.7 0-74.5 11.4-103.6 30.6 4.7-53 49.3-94.6 103.6-94.6s98.8 41.6 103.6 94.6C330.1 379.4 294.3 368 255.6 368z"],
    "check": [512, 512, [10003, 10004], "f00c", "M493 88.9l-18.8 25.9-256 352-22 30.3c-.7-.7-52.2-52.2-154.5-154.5L19 320 64.3 274.7c1.9 1.9 43.3 43.3 124.1 124.1l234-321.7 18.8-25.9 51.8 37.6z"],
    "bow-arrow": [640, 512, [127993], "f6b9", "M576 115.9l-6.9 27.4-51-51-307.1 307.1 12.7 50.8 3.3 13.2-9.6 9.6-94 94c-6.5-25.9-14.1-56.3-22.8-91.2l-91.1-22.8 94-94 9.6-9.6 13.2 3.3 50.8 12.7 307.1-307.1-51-51 27.4-6.9 153.9-38.5-38.5 153.9zM497 181.2c51.7 94.5 39.4 214.8-37.2 297l17.8 17.8-45.3 45.3-147.7-147.7 45.3-45.3 84.7 84.7c51.5-56.7 63-136.8 34.6-203.9L497 181.2zM98.2 116.5C180.4 40 300.7 27.6 395.3 79.4l-47.8 47.8c-67.2-28.5-147.3-16.9-204 34.6l84.7 84.7-45.2 45.3-147.7-147.7 45.2-45.2 17.8 17.8z"],
    "ban-bug": [512, 512, ["debug"], "f7f9", "M256 448c-106 0-192-86-192-192 0-41.5 13.1-79.9 35.5-111.2L367.2 412.5C335.9 434.9 297.5 448 256 448zm98.4-138.8c11.2 1.6 25.2 3.6 42 6l6.8-47.5c-12.6-1.8-34.9-5-67.2-9.6l0-4.1c32.2-4.6 54.6-7.8 67.2-9.6l-6.8-47.5c-13.7 2-33.8 4.8-60.4 8.6l0-10.6c18.7-9.3 34.8-17.4 48.2-24.1l-21.5-42.9c-13.1 6.6-29.8 14.9-50 25l-24.8-24.8-64 0-25.4 25.4-53.9-53.9c31.4-22.4 69.8-35.5 111.2-35.5 106 0 192 86 192 192 0 41.5-13.1 79.9-35.5 111.2l-58.1-58.1zM256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM132.6 264.2l-23.8 3.4 6.8 47.5c13.7-2 33.8-4.8 60.4-8.6l0 10.6c-18.7 9.3-34.8 17.4-48.2 24.1l21.5 42.9c13.1-6.6 29.8-14.9 50-25l24.8 24.8 46.9 0-122.1-122.1-16.2 2.3z"],
    "arrow-down-from-dotted-line": [384, 512, [], "e090", "M192 525.3l173.3-173.3-45.3-45.3-96 96 0-274.7-64 0 0 274.7c-57.4-57.4-89.4-89.4-96-96l-45.3 45.3 22.6 22.6 128 128 22.6 22.6zM0 64L64 64 64 0 0 0 0 64zm170.7 0l0-64-64 0 0 64 64 0zm42.7 0l64 0 0-64-64 0 0 64zM384 64l0-64-64 0 0 64 64 0z"],
    "fingerprint": [512, 512, [], "f577", "M48 256c0-114.9 93.1-208 208-208 63.1 0 119.6 28.1 157.8 72.5l15.6 18.2 36.4-31.3-15.6-18.2C403.3 34.6 333.7 0 256 0 114.6 0 0 114.6 0 256l0 64 48 0 0-64zm458.5-52.9l-4.9-23.5-47 9.9 4.9 23.5c2.9 13.9 4.5 28.3 4.5 43.1l0 64 48 0 0-64c0-18.1-1.9-35.8-5.5-52.9zM256 80c-34.2 0-66 9.7-93 26.6l31.7 37c18.2-9.9 39.1-15.6 61.3-15.6 70.7 0 128 57.3 128 128l0 24.9c0 34.6-2.8 69.1-8.4 103.1l48.6 0c5.2-34 7.8-68.5 7.8-103.1l0-24.9c0-97.2-78.8-176-176-176zM126.1 137.3C97.5 168.6 80 210.3 80 256l0 24.9c0 35-5.5 69.8-16.2 103.1l50.1 0c9.3-33.5 14.1-68.2 14.1-103.1l0-24.9c0-31.1 11.1-59.7 29.6-81.9l-31.6-36.8zM256 160c-53 0-96 43-96 96l0 24.9c0 46-7.6 91.6-22.5 135.1l46.3 0c13.4-43.7 20.3-89.2 20.3-135.1l0-24.9c0-28.7 23.3-52 52-52s52 23.3 52 52l0 24.9c0 45.6-5.5 91-16.4 135.1l45.2 0c10.1-44.2 15.2-89.5 15.2-135.1l0-24.9c0-53-43-96-96-96zm24 96l-48 0 0 24.9c0 59.9-11 119.3-32.5 175.2-4.3 11.3-7.4 19.3-9.2 23.9l51.4 0 2.6-6.7C267.9 411.9 280 346.7 280 280.9l0-24.9z"],
    "bowl-scoop": [448, 512, [127847, "bowl-shaved-ice"], "e3de", "M416 192c0 5.4-.2 10.7-.7 16L32.7 208c-.4-5.3-.7-10.6-.7-16 0-106 86-192 192-192S416 86 416 192zM0 288l0-32 448 0 0 32c0 70.7-57.3 128-128 128l-36.6 0 68.6 96-256 0 68.6-96-36.6 0C57.3 416 0 358.7 0 288z"],
    "charging-station": [576, 512, [], "f5e7", "M64 0l288 0 0 288 80 0 0 112 40 0 0-147.7c-32.5-10.2-56-40.5-56-76.3l0-48 32 0 0-64 32 0 0 64 32 0 0-64 32 0 0 64 32 0 0 48c0 35.8-23.5 66.1-56 76.3l0 195.7-136 0 0-112-32 0 0 128 16 0 0 48-320 0 0-48 16 0 0-464zM249.1 66.3l-137.1 123.4 76.2 0-21.3 96 137.1-123.4-76.2 0 21.3-96z"],
    "plane-up-slash": [576, 512, [], "e22e", "M49.3-16.9l-17-17-33.9 33.9 17 17 512 512 17 17 33.9-33.9-17-17-126.1-126.1 92.9 31 0-80-184-168.7 0-127.3c0-30.9-25.1-56-56-56s-56 25.1-56 56l0 127.3-7.6 7-175.2-175.2zM153.6 223.3l-105.5 96.7 0 80 184-61.3 0 99.7-72 57.6 0 48 128-32 128 32 0-48-72-57.6 0-24.6-190.5-190.5z"],
    "user-lock": [576, 512, [], "f502", "M224 248a120 120 0 1 0 0-240 120 120 0 1 0 0 240zm80 104l0-48-224 0-64 208 288 0 0-160zm160-80c17.7 0 32 14.3 32 32l0 48-64 0 0-48c0-17.7 14.3-32 32-32zm-80 32l0 48-32 0 0 192 224 0 0-192-32 0 0-48c0-44.2-35.8-80-80-80s-80 35.8-80 80z"],
    "mobile-screen-button": [384, 512, ["mobile-alt"], "f3cd", "M16 0l352 0 0 512-352 0 0-512zM80 64l0 304 224 0 0-304-224 0zM192 472c17.7 0 32-14.3 32-32s-14.3-32-32-32-32 14.3-32 32 14.3 32 32 32z"],
    "olive": [448, 512, [], "e316", "M0 320c0 88.4 71.6 160 160 160 192 0 288-181.9 288-280 0-76.5-91.5-168-168-168-98.1 0-280 96-280 288zM265.1 105.1c71.3-10.4 120.1 38.4 109.7 109.7-71.3 10.4-120.1-38.4-109.7-109.7z"],
    "anchor-circle-check": [640, 512, [], "e4aa", "M320 96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM288 0c-53 0-96 43-96 96 0 41.8 26.7 77.4 64 90.5l0 261.5-112 0 0-140.1c10.5 9.2 21.9 19.2 34.3 30l31.6-36.1c-4.4-3.8-31.7-27.8-82.1-71.8L112 216.1c-2.5 2.2-29.1 25.5-79.8 69.8l-18.1 15.8 31.6 36.1c12.4-10.8 23.8-20.8 34.3-30l0 204.1 260 0c-22.7-31.5-36-70.2-36-112 0-27.3 5.7-53.3 16-76.9l0-136.6c37.3-13.2 64-48.7 64-90.5 0-53-43-96-96-96zM640 400a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-73.7-51.5l-9.4 12.9-64 88-11 15.1c-4.4-4.4-22.1-22.1-53.2-53.2L417.4 400 440 377.4c5 5 17.7 17.7 38.1 38.1l53-72.9 9.4-12.9 25.9 18.8z"],
    "rectangle-4k": [512, 512, [], "e772", "M0 128C0 92.7 28.7 64 64 64l384 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64L64 448c-35.3 0-64-28.7-64-64L0 128zm144 32l-48 0 0 72c0 30.9 25.1 56 56 56l40 0 0 64 48 0 0-192-48 0 0 80-40 0c-4.4 0-8-3.6-8-8l0-72zm176 0l-48 0 0 192 48 0 0-72c26.5 0 48 21.5 48 48l0 24 48 0 0-24c0-28.7-12.6-54.4-32.5-72 19.9-17.6 32.5-43.3 32.5-72l0-24-48 0 0 24c0 26.5-21.5 48-48 48l0-72z"],
    "scalpel": [640, 512, [], "f61d", "M111.6 368L0 480 192 480 304 368 111.6 368zm47.8-48L416 320 580.7 155.3c17.2-17.2 26.8-40.7 26.8-64.9 0-49.8-40.1-90.8-89.9-91.2-24.4-.2-47.8 9.4-65 26.7L159.4 320z"],
    "person-walking-with-cane": [576, 512, ["blind"], "f29d", "M224.1-32a56 56 0 1 1 0 112 56 56 0 1 1 0-112zm-64 237.3l-32 32 0 82.7-64 0 0-109.3 9.4-9.4 80-80 9.4-9.4 107.9 0 9.6 11 104 120 12 13.8-7.4 5.5-38.4 28.8-5.6 4.2-9-10.4-63.8-73.6 0 119.1 52.8 45.3 9 7.7 1.8 11.7c12.5 81.4 19.5 126.6 20.9 135.6l-63.3 9.7c-1.7-11-8-52.3-19.1-123.9l-80.7-69.1c-21.3-18.2-33.5-44.9-33.5-72.9l0-69.3zm.1 165.8c2.4 2.3 4.8 4.6 7.4 6.8l46 39.4c-5.2 18.3-8.2 28.8-9 31.5l-5.9 5.9-86.6 86.6-45.3-45.3c9.2-9.2 36.1-36.1 80.8-80.8L160.2 371zm252.9-76.6l14.3 19.3 136 184 14.3 19.3-38.6 28.5-14.3-19.3-136-184-14.3-19.3 38.6-28.5z"],
    "candle-holder": [512, 512, [128367], "f6bc", "M224 192c44.2 0 80-35.8 80-80 0-48-80-112-80-112s-80 64-80 112c0 44.2 35.8 80 80 80zM128 464l-64 0 0 48 376 0c39.8 0 72-32.2 72-72s-32.2-72-72-72-72 32.2-72 72l0 24-48 0 0-224-192 0 0 224zm288-24c0-13.3 10.7-24 24-24s24 10.7 24 24-10.7 24-24 24l-24 0 0-24z"],
    "file-waveform": [384, 512, ["file-medical-alt"], "f478", "M0 0l240 0 144 144 0 368-384 0 0-160 67.2 0 40.9 61.3 7.1 10.7 28.1 0 6.5-13.8 42.9-91.2c7.1 14.3 12.6 25.3 16.5 33l110.8 0 0-48-81.2 0c-20-40.1-30.7-61.4-32-64l-30.1 0-6.5 13.8-45.9 97.5c-19.2-28.7-29.7-44.5-31.5-47.3L0 304 0 0zM208 58.5L208 176 325.5 176 208 58.5z"],
    "renminbi-sign": [384, 512, [], "e73c", "M85.6 62.7l-17.3-26.9-53.8 34.6 17.3 26.9 112.3 174.7-79.7 0 0 48 96 0 0 32-96 0 0 48 96 0 0 80 64 0 0-80 96 0 0-48-96 0 0-32 96 0 0-48-79.7 0 112.3-174.7 17.3-26.9-53.8-34.6-17.3 26.9-106.8 166.1-106.8-166.1z"],
    "face-spiral-eyes": [512, 512, [], "e485", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm36.9-95.4L256 392c-28.9 19.3-44.9 29.9-48 32-2.9-1.9-19.3-12.9-49.4-33-15 7.5-28.2 14.1-39.5 19.8l-17.9-35.8c9.6-4.8 26.2-13.1 49.9-24.9l10.4-5.2c1.9 1.3 17.4 11.6 46.6 31 28.9-19.3 44.9-29.9 48-32 3.1 2.1 19.1 12.7 48 32 29.1-19.4 44.7-29.8 46.6-31l60.3 30.1-17.9 35.8-39.5-19.8c-30.1 20.1-46.6 31.1-49.4 33l-11.1-7.4zM173.7 140c-21.8 0-42.6 8.4-57.9 23.4-15.3 14.9-23.8 35.1-23.8 56.1 0 14.9 6.1 29.3 17 39.9 10.9 10.6 25.8 16.7 41.3 16.7s30.4-6 41.3-16.7c10.9-10.6 17-25 17-39.9 0-8.8-3.6-17.4-10.1-23.7-6.5-6.4-15.4-10-24.8-10s-18.2 3.6-24.8 10c-6.5 6.3-10.1 14.9-10.1 23.7 0 2.8 1.1 5.5 3.2 7.6 2.1 2.1 5.1 3.3 8.2 3.3s6.1-1.2 8.2-3.3c2.1-2.1 3.2-4.8 3.2-7.6l24 0c0 9.3-3.8 18.2-10.5 24.8-6.7 6.5-15.6 10.1-24.9 10.1s-18.3-3.6-24.9-10.1c-6.7-6.5-10.5-15.4-10.5-24.8 0-15.4 6.3-30.1 17.3-40.9 11.1-10.8 26-16.8 41.5-16.8s30.5 6 41.5 16.8c11.1 10.8 17.3 25.5 17.3 40.9 0 21.5-8.7 42-24.2 57.1-15.5 15.1-36.4 23.5-58.1 23.5s-42.6-8.4-58.1-23.5c-15.5-15.1-24.2-35.6-24.2-57.1 0-27.5 11.2-53.9 31.1-73.2 19.8-19.4 46.7-30.2 74.7-30.2l0 24zM396.2 252.6c15.3-14.9 23.8-35.1 23.8-56.1 0-14.9-6.1-29.3-17-39.9-10.9-10.6-25.8-16.7-41.3-16.7s-30.4 6-41.3 16.7c-10.9 10.6-17 25-17 39.9 0 8.8 3.6 17.4 10.1 23.7 6.5 6.4 15.4 10 24.8 10s18.2-3.6 24.8-10c6.5-6.3 10.1-14.9 10.1-23.7 0-2.8-1.1-5.5-3.2-7.6-2.1-2.1-5.1-3.3-8.2-3.3s-6.1 1.2-8.2 3.3c-2.1 2.1-3.2 4.8-3.2 7.6l-24 0c0-9.3 3.8-18.2 10.5-24.8 6.7-6.5 15.6-10.1 24.9-10.1s18.3 3.6 24.9 10.1c6.7 6.5 10.5 15.4 10.5 24.8 0 15.4-6.3 30.1-17.3 40.9-11.1 10.8-26 16.8-41.5 16.8s-30.5-6-41.5-16.8c-11.1-10.8-17.3-25.5-17.3-40.9 0-21.5 8.7-42 24.2-57.1 15.5-15.1 36.4-23.5 58.1-23.5s42.6 8.4 58.1 23.5c15.5 15.1 24.2 35.6 24.2 57.1 0 27.5-11.2 53.9-31.1 73.2-19.8 19.4-46.7 30.2-74.7 30.2l0-24c21.8 0 42.6-8.4 57.9-23.4z"],
    "calendar-arrow-up": [448, 512, ["calendar-upload"], "e0d1", "M160 0l0 64 128 0 0-64 64 0 0 64 96 0 0 416-448 0 0-416 96 0 0-64 64 0zm81 191l-17-17c-2.1 2.1-31.8 31.8-89 89l-17 17 33.9 33.9c9-9 25-25 48-48l0 126.1 48 0 0-126.1c23 23 39 39 48 48L329.9 280c-2.1-2.1-31.8-31.8-89-89z"],
    "person-arms-raised": [384, 512, [], "e783", "M80 0l0-32-64 0 0 224 96 0 0 352 64 0 0-192 32 0 0 192 64 0 0-352 96 0 0-224-64 0 0 160-224 0 0-128zM192 80a56 56 0 1 0 0-112 56 56 0 1 0 0 112z"],
    "person-dress-fairy": [576, 512, [], "e607", "M288 128a64 64 0 1 0 0-128 64 64 0 1 0 0 128zM416 384l-64-224-128 0-64 224 64 0 0 128 128 0 0-128 64 0zM192 104.9C158 74.5 113.2 56 64 56L0 56 0 120c0 76.7 45 142.9 110 173.7-28.1 23.5-46 58.8-46 98.3l0 48 27.5 0 100.5-335.1zM484.5 440l27.5 0 0-48c0-39.5-17.9-74.8-46-98.3 65-30.7 110-97 110-173.7l0-64-64 0c-49.2 0-94 18.5-128 48.9L484.5 440z"],
    "bar-progress": [512, 512, [], "e6a4", "M320 160l0 192 128 0 0-192-128 0zM0 96l512 0 0 320-512 0 0-320z"],
    "chart-kanban": [512, 512, [], "e64f", "M384 448l128 0 0-384-128 0 0 384zM320 320l0-256-128 0 0 256 128 0zM128 416l0-352-128 0 0 352 128 0z"],
    "cloud-music": [576, 512, [], "f8ae", "M144 480l432 0 0-128c0-47.4-25.7-88.7-64-110.9l0-49.1c0-53-43-96-96-96-17.7 0-34.2 4.8-48.4 13.1-24.1-45.8-72.2-77.1-127.6-77.1-79.5 0-144 64.5-144 144l0 24.2C40.1 220 0 273.3 0 336l0 144 144 0zM368 192l0 64-48 0 0 104c0 30.9-28.7 56-64 56s-64-25.1-64-56 28.7-56 64-56c5.5 0 10.9 .6 16 1.8l0-113.8 96 0z"],
    "watch-smart": [384, 512, [], "e2cc", "M123-32L261-32c24.5 0 45 18.4 47.7 42.7l6 54C353.8 70 384 103.5 384 144l0 224c0 40.5-30.2 74-69.3 79.3l-6 54C306 525.6 285.5 544 261 544L123 544c-24.5 0-45-18.4-47.7-42.7l-6-54C30.2 442 0 408.5 0 368L0 144c0-40.5 30.2-74 69.3-79.3l6-54C78-13.6 98.5-32 123-32zM304 128L80 128c-8.8 0-16 7.2-16 16l0 224c0 8.8 7.2 16 16 16l224 0c8.8 0 16-7.2 16-16l0-224c0-8.8-7.2-16-16-16zm-88 56l0 62.1c31.3 31.3 50.6 50.6 57.9 57.9L240 337.9c-6.1-6.1-27.8-27.8-65-65l-7-7 0-105.9 48 0 0 24z"],
    "left-to-bracket": [512, 512, [], "e66d", "M167.5 273.4L149 256 167.5 238.6C280.8 131.6 342.3 73.5 352 64.3l0 127.7 160 0 0 128-160 0 0 127.7c-9.7-9.2-71.2-67.3-184.5-174.2zM160 416l32 0 0 64-192 0 0-448 192 0 0 64-128 0 0 320 96 0z"],
    "grate-droplet": [640, 512, [], "e194", "M128 32l-32 0 0 448 257.1 0c-5.9-16.9-9.1-35-9.1-54 0-3.3 .1-6.7 .3-10l-.3 0 0-136 48 0 0 7.6c15.8-25.1 33.1-47.8 48-65.6l0-125.9 40 0 0 90c20.3-9.4 43.7-9.4 64 0l0-154-416 0zm32 200l0-136 40 0 0 136-40 0zm0 48l40 0 0 136-40 0 0-136zm88 136l0-136 48 0 0 136-48 0zM392 96l0 136-48 0 0-136 48 0zm-96 0l0 136-48 0 0-136 48 0zM632 426.1C632 331.9 512 214 512 214S392 331.9 392 426.1C392 491.2 445.7 544 512 544s120-52.8 120-117.9z"],
    "house-crack": [512, 512, [], "e3b1", "M512 272l-48 0 0 240-169.6 0-38.4-64 96-80-160-112 64 112-96 80 38.4 64-150.4 0 0-240-48 0 0-48 256-240 256 240 0 48z"],
    "wifi-slash": [576, 512, [], "f6ac", "M32.5-33.8C33.1-33.2 65.8-.5 130.6 64.3 179 43.5 232.3 32 288.3 32 404.7 32 509.5 81.7 582.6 161.1l-45.8 44.7c-61.5-67.4-150-109.8-248.4-109.8-37.8 0-74.2 6.3-108.2 17.8l94.6 94.6c4.5-.3 9-.4 13.6-.4 31.8 0 62 6.6 89.3 18.5l0 0c30.4 13.2 57.2 33 78.8 57.5l-45.9 44.8-7.8 7.6 158.7 158.7 17 17-33.9 33.9-17-17-512-512-17-17 33.9-33.9zM218.5 288c-20.2 9.8-38.1 23.8-52.4 40.8L120.1 284c14.8-16.8 32.1-31.4 51.3-43.1L218.5 288zM45 114.5l45.7 45.7c-18.5 13.4-35.5 28.7-50.8 45.6L-6 161.1c15.6-16.9 32.7-32.5 51-46.6zM240.3 432a48 48 0 1 1 96 0 48 48 0 1 1 -96 0z"],
    "hat-wizard": [512, 512, [], "f6e8", "M64 400l112-272 240-128-48 192 80 208-217.1 0 17.1-40 56-24-56-24-24-56-24 56-56 24 56 24 17.1 40-153.1 0zM256 192l16 32 16-32 32-16-32-16-16-32-16 32-32 16 32 16zM32 448l480 0 0 64-512 0 0-64 32 0z"],
    "football-helmet": [512, 512, [], "f44f", "M256 0C386.6 0 494.3 97.8 510 224.2l-159.2 18.7 28.2 93.1 133 0 0 176-129.8 0-5.2-17-33.6-111-55.4 0 0 80-64 0-188.9-78.7C12.8 347.3 0 303.2 0 256 0 114.6 114.6 0 256 0zM417.8 464l46.2 0 0-80-70.4 0 24.2 80zM160 288a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm80-32l30 80 58.8 0-26.5-87.4-62.4 7.4z"],
    "user-doctor": [448, 512, ["user-md"], "f0f0", "M224 8a120 120 0 1 0 0 240 120 120 0 1 0 0-240zm60 359.4l0-47.4-120 0 0 68.4c16.5 7.6 28 24.3 28 43.6 0 26.5-21.5 48-48 48s-48-21.5-48-48c0-19.4 11.5-36.1 28-43.6l0-68.4-44 0-64 192 416 0-64-192-44 0 0 47.4c23.3 8.2 40 30.5 40 56.6l0 52-40 0 0-52c0-11-9-20-20-20s-20 9-20 20l0 52-40 0 0-52c0-26.1 16.7-48.3 40-56.6z"],
    "glasses-round": [576, 512, [128083, "glasses-alt"], "f5f5", "M71 32l137 0 0 64-87 0-29.9 119.6c14.1-4.9 29.2-7.6 44.9-7.6 55.1 0 102.6 32.8 124 80l56.1 0c21.3-47.2 68.8-80 124-80 15.7 0 30.9 2.7 44.9 7.6l-29.9-119.6-87 0 0-64 137 0 6.1 24.2 58.3 233.1c4.4 17.8 6.7 36 6.7 54.3l0 .4c0 75.1-60.9 136-136 136-72.4 0-131.6-56.6-135.8-128l-32.5 0C267.6 423.4 208.4 480 136 480 60.9 480 0 419.1 0 344l0-.4c0-18.3 2.2-36.6 6.7-54.3L65 56.2 71 32zM64 344a72 72 0 1 0 144 0 72 72 0 1 0 -144 0zm376 72a72 72 0 1 0 0-144 72 72 0 1 0 0 144z"],
    "rocket-launch": [512, 512, [128640], "e027", "M160 288l-160 0 96-160 122.1 0C301.6-13.4 430.1-7.5 504.6 7.4 519.5 81.9 525.4 210.4 384 293.9l0 122.1-160 96 0-160-64-64zM432 128a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM152.4 473.6c-45.3 45.3-152 38-152 38s-7.3-106.7 38-152c31.5-31.5 82.5-31.5 114 0s31.5 82.5 0 114zm-40.6-32c11.4-11.4 11.4-30 0-41.4s-30-11.4-41.4 0c-16.5 16.5-13.8 55.2-13.8 55.2s38.7 2.7 55.2-13.8z"],
    "hand-holding-circle-dollar": [576, 512, [], "e621", "M416 112a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zM288 40l32 0 0 32-61.8 0c-5.6 0-10.2 4.6-10.2 10.2 0 4.9 3.5 9.1 8.3 10l45 8.2c20 3.6 34.6 21.1 34.6 41.5 0 23.3-18.9 42.2-42.2 42.2l-5.8 0 0 24-32 0 0-24-32 0 0-32 69.8 0c5.6 0 10.2-4.6 10.2-10.2 0-4.9-3.5-9.1-8.3-10l-45-8.2c-20-3.6-34.6-21.1-34.6-41.5 0-22.6 17.7-41 40-42.1l0-24.1 32 0 0 24zM137.4 313.4l-70.6 70.6-66.7 0 0 128 396.4 0 10.2-7c101.2-69.6 154.8-106.4 161-110.7l-45.3-65.9c-11.7 8.1-54.2 37.3-127.5 87.6l-138.8 0 0-48 128 0 0-64-237.3 0-9.4 9.4z"],
    "chart-bar": [512, 512, ["bar-chart"], "f080", "M64 32l0 384 448 0 0 64-512 0 0-448 64 0zm320 96l-256 0 0-64 256 0 0 64zM160 176l160 0 0 64-192 0 0-64 32 0zm0 112l288 0 0 64-320 0 0-64 32 0z"],
    "message-dollar": [512, 512, ["comment-alt-dollar"], "f650", "M0 32l0 416 128 0 0 96 160-96 224 0 0-416-512 0zm280 96l0 24 28 0 0 40-67.5 0c-6.9 0-12.5 5.6-12.5 12.5 0 6.1 4.4 11.3 10.4 12.3l41.7 7c25.3 4.2 43.9 26.1 43.9 51.8 0 26.1-19 47.7-44 51.8l0 24.7-40 0 0-24-44 0 0-40 75.5 0c6.9 0 12.5-5.6 12.5-12.5 0-6.1-4.4-11.3-10.4-12.3l-41.7-7c-25.3-4.2-43.9-26.1-43.9-51.8 0-28.8 23.2-52.2 52-52.5l0-24 40 0z"],
    "video-down-to-line": [448, 512, [], "e776", "M24 496l424 0 0 48-448 0 0-48 24 0zM384 0l0 320-103.2 0 55.2 96-224 0 55.2-96-103.2 0 0-320 320 0z"],
    "spray-can-sparkles": [576, 512, ["air-freshener"], "f5d0", "M160 0l0 112 128 0 0-112-128 0zm0 160c-53 0-96 43-96 96l0 256 320 0 0-256c0-53-43-96-96-96l-128 0zm64 96a80 80 0 1 1 0 160 80 80 0 1 1 0-160zM384 32l-32 16 32 16 16 32 16-32 32-16-32-16-16-32-16 32zm32 112l32 16 16 32 16-32 32-16-32-16-16-32-16 32-32 16zM528 0l-16 32-32 16 32 16 16 32 16-32 32-16-32-16-16-32zM512 224l-32 16 32 16 16 32 16-32 32-16-32-16-16-32-16 32z"],
    "baht-sign": [320, 512, [], "e0ac", "M160 0l-48 0 0 64-112 0 0 384 112 0 0 64 48 0 0-64 48 0c61.9 0 112-50.1 112-112 0-40.1-21.1-75.3-52.7-95.1 13.1-18.3 20.7-40.7 20.7-64.9 0-61.9-50.1-112-112-112l-16 0 0-64zM112 128l0 96-48 0 0-96 48 0zm48 96l0-96 16 0c26.5 0 48 21.5 48 48s-21.5 48-48 48l-16 0zm-48 64l0 96-48 0 0-96 48 0zm48 96l0-96 48 0c26.5 0 48 21.5 48 48s-21.5 48-48 48l-48 0z"],
    "face-beam-hand-over-mouth": [512, 512, [129325], "e47c", "M88 436C88 440.6 88.2 445.2 88.6 449.7 34.3 402.8 0 333.4 0 256 0 114.6 114.6 0 256 0S512 114.6 512 256c0 68.5-26.9 130.7-70.7 176.7-4.9-4.9-21.1-21.1-48.7-48.7l3.7-3.7 28.3-28.3c-41.8-41.8-76.9-76.9-88.6-88.6l-16 16c-11.7-11.7-27.7-27.7-48-48-20.2 20.2-36.4 36.4-48.6 48.6L88 280 88 436zm88-272c15.5 0 28 12.5 28 28l0 28 40 0 0-28c0-37.6-30.4-68-68-68s-68 30.4-68 68l0 28 40 0 0-28c0-15.5 12.5-28 28-28zm132 28c0-15.5 12.5-28 28-28s28 12.5 28 28l0 28 40 0 0-28c0-37.6-30.4-68-68-68s-68 30.4-68 68l0 28 40 0 0-28zM128 320l48 0 0 64 96-96 32 32-64 64 16 16 80-80 32 32-80 80 16 16 48-48 32 32-82.2 82.2c-19.1 19.1-45 29.8-72 29.8-56.2 0-101.8-45.6-101.8-101.8L128 320z"],
    "temperature-arrow-up": [576, 512, ["temperature-up"], "e040", "M470.9 9.4c49.6 49.6 78.4 78.4 86.6 86.6l-45.3 45.3-32-32 0 210.7-64 0 0-210.7-32 32-45.3-45.3c8.2-8.2 37.1-37.1 86.6-86.6l22.6-22.6 22.6 22.6zM96.3 0l192 0 0 260.7c29.5 26.4 48 64.7 48 107.3 0 79.5-64.5 144-144 144s-144-64.5-144-144c0-42.6 18.5-81 48-107.3L96.3 0zm96 432c35.3 0 64-28.7 64-64 0-26.9-16.5-49.9-40-59.3l0-236.7-48 0 0 236.7c-23.5 9.5-40 32.5-40 59.3 0 35.3 28.7 64 64 64z"],
    "web-awesome": [640, 512, [], "e682", "M372.2 52c0 20.9-12.4 39-30.2 47.2L448 192 552.4 171.1c-5.3-7.7-8.4-17.1-8.4-27.1 0-26.5 21.5-48 48-48s48 21.5 48 48c0 26-20.6 47.1-46.4 48L464 480 176 480 46.4 192C20.6 191.1 0 170 0 144 0 117.5 21.5 96 48 96s48 21.5 48 48c0 10.1-3.1 19.4-8.4 27.1L192 192 298.1 99.1c-17.7-8.3-30-26.3-30-47.1 0-28.7 23.3-52 52-52s52 23.3 52 52z"],
    "non-binary": [384, 512, [], "e807", "M192 544c-97.2 0-176-78.8-176-176 0-86.3 62.1-158 144-173l0-47.2c-36.6 18.3-62.7 31.3-78.3 39.1L53.1 129.7C70.5 121 92.9 109.8 120.5 96 93 82.2 70.5 71 53.1 62.3L81.7 5.1c15.5 7.8 41.6 20.8 78.3 39.2l0-76.2 64 0 0 76.2c36.6-18.3 62.7-31.4 78.3-39.1l28.6 57.2C313.6 71 291.1 82.2 263.6 96l67.3 33.7-28.6 57.2c-15.6-7.8-41.7-20.8-78.3-39.1l0 47.2c81.9 15.1 144 86.8 144 173 0 97.2-78.8 176-176 176zm0-64a112 112 0 1 0 0-224 112 112 0 1 0 0 224z"],
    "shield-slash": [576, 512, [], "e24b", "M49.3-16.9l-17-17-33.9 33.9 17 17 512 512 17 17 33.9-33.9-17-17-110.5-110.5c16.1-22.8 29.1-46.7 39.5-70.7 32.4-74.7 40.2-151 37.3-200.9L526.4 92.5 507.2 85 299.7 4.5 288.1 0 276.5 4.5 128.2 62.1 49.3-16.9zm-.8 135c-2.1 50 6.2 123.6 37.6 195.8 32.7 75.3 91 150 189.4 192.6l12.7 5.5 12.7-5.5c32.4-14 60.4-31.5 84.6-51.3l-337-337z"],
    "floppy-disks": [512, 512, [], "e183", "M96 0l297.9 0 7 7 104 104 7 7 0 297.9-416 0 0-416zM48 120l0 344 368 0 0 48-416 0 0-416 48 0 0 24zM360 280a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zM384 64l-192 0 0 96 192 0 0-96z"],
    "n": [384, 512, [110], "4e", "M0 32l47 0 9.6 11.5 263.4 316.1 0-327.6 64 0 0 448-47 0-9.6-11.5-263.4-316.1 0 327.6-64 0 0-448z"],
    "arrows-up-down-left-right": [576, 512, ["arrows"], "f047", "M310.9 9.4L288.3-13.3c-8.2 8.2-37.1 37.1-86.6 86.6L179 96 224.3 141.3c17.3-17.3 28-28 32-32l0 114.7-114.7 0c4-4 14.7-14.7 32-32l-45.3-45.3c-8.2 8.2-37.1 37.1-86.6 86.6l-22.6 22.6 86.6 86.6 22.6 22.6 45.3-45.3-32-32 114.7 0 0 114.7c-4-4-14.7-14.7-32-32L179 416c8.2 8.2 37.1 37.1 86.6 86.6l22.6 22.6 109.3-109.3-45.3-45.3-32 32 0-114.7 114.7 0-32 32 45.3 45.3 109.3-109.3c-8.2-8.2-37.1-37.1-86.6-86.6L448.3 146.7 403 192c17.3 17.3 28 28 32 32l-114.7 0 0-114.7 32 32 45.3-45.3c-8.2-8.2-37.1-37.1-86.6-86.6z"],
    "house": [512, 512, [127968, 63498, 63500, "home", "home-alt", "home-lg-alt"], "f015", "M512 272l-48 0 0 240-416 0 0-240-48 0 0-48 256-240 256 240 0 48zM320 464l0-144-128 0 0 144 128 0z"],
    "spinner": [512, 512, [], "f110", "M208 0l0 96 96 0 0-96-96 0zM0 208l0 96 96 0 0-96-96 0zM208 512l96 0 0-96-96 0 0 96zM512 208l-96 0 0 96 96 0 0-96zM41 403.1l67.9 67.9 67.9-67.9-67.9-67.9-67.9 67.9zm362 67.9l67.9-67.9-67.9-67.9-67.9 67.9 67.9 67.9zM41 108.9l67.9 67.9 67.9-67.9-67.9-67.9-67.9 67.9z"],
    "square-y": [448, 512, [], "e287", "M448 32l-448 0 0 448 448 0 0-448zM118 155.2l-7.4-11.2 57.6 0 55.9 84.5 55.9-84.5 57.6 0-7.4 11.2-82 124 0 88.8-48 0 0-88.8-82-124z"],
    "square-mill": [448, 512, [], "e70a", "M448 32l-448 0 0 448 448 0 0-448zM309.1 103.9c-2.3 5.1-10.7 24.1-25.4 57.1 34.2 5.6 60.2 35.3 60.2 71l0 120-48 0 0-120c0-13.3-10.7-24-24-24-3.6 0-7.1 .8-10.2 2.2l-13.8 31.1 0 110.6-48 0 0-2.6c-20.1 45.2-30.7 69.1-31.9 71.7l-29.2-13 6.5-14.6 54.6-122.9 0-38.6 0-.4c-.2-13.1-10.9-23.6-24-23.6-13.3 0-24 10.7-24 24 0 76 0 116 0 120l-48 0c0-10.7 0-37.3 0-80l0 0c0-9.3 0-38.7 0-88l0-24 48 0 0 4.1c7.5-2.7 15.6-4.1 24-4.1 18.4 0 35.3 6.9 48 18.3 6.7-6 14.6-10.8 23.2-13.9 20.7-46.6 31.6-71.1 32.7-73.5l29.2 13z"],
    "gavel": [640, 512, ["legal"], "f0e3", "M224.5 176l-64-64 160-160 64 64-160 160zm83.7 35.7l-31.4-31.4 112-112 119.4 119.4-112 112-31.4-31.4-232 232-28.3 28.3-56.6-56.6 28.3-28.3 232-232zM400.5 352l160-160 64 64-160 160-64-64z"],
    "circle-tugrik": [512, 512, [], "e711", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM144 144l224 0 0 48-88 0 0 39.1c33.3-11.1 52.6-17.5 58.1-19.4l10.1 30.4c-3.8 1.3-26.6 8.9-68.2 22.7l0 30.3c33.3-11.1 52.6-17.5 58.1-19.4l10.1 30.4c-3.8 1.3-26.6 8.9-68.2 22.7l0 71.1-48 0 0-55.1c-33.3 11.1-52.6 17.5-58.1 19.4l-10.1-30.4c3.8-1.3 26.6-8.9 68.2-22.7l0-30.3c-33.3 11.1-52.6 17.5-58.1 19.4l-10.1-30.4c3.8-1.3 26.6-8.9 68.2-22.7l0-55.1-88 0 0-48z"],
    "trash-clock": [576, 512, [], "e2b0", "M176-16l-16 48-128 0 0 64 448 0 0-64-128 0-16-48-160 0zM448 144l-384 0 24 368 188 0c-22.7-31.5-36-70.2-36-112 0-106 86-192 192-192 4 0 7.9 .1 11.8 .4L448 144zM576 400a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zM448 320l0 64 48 0 0 32-80 0 0-96 32 0z"],
    "circle-phone": [512, 512, ["phone-circle"], "e11b", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM192 128l48.4 64-40.4 40c16.5 35.2 44.8 63.5 80 80l40-40.4 64 48.4-32 64-8 0c-119.3 0-216-96.7-216-216l0-8 64-32z"],
    "bolt-auto": [576, 512, [], "e0b6", "M352 0L0 288 183.1 288 96 512 448 224 264.9 224 352 0zM479.8 288l-31.7 0-6.2 14.6-89.5 209.4 52.2 0 17.1-40 84.5 0 17.1 40 52.2 0-89.5-209.4-6.2-14.6zm5.9 136l-43.5 0 21.8-50.9 21.8 50.9z"],
    "user-pilot-tie-hair-long": [448, 512, [], "e7b4", "M48 16l0 32 32 19.2 0 44.8s5.8 2.8 16 6.7l0 57.3-48 96 352 0-48-96 0-57.3c10.2-3.9 16-6.7 16-6.7l0-44.8 32-19.2 0-32-176-48-176 48zM224.2 224l-.4 0c-44.1-.1-79.8-35.9-79.8-80l0-10.3c23.2 5.7 50.9 10.3 80 10.3s56.8-4.6 80-10.3l0 10.3c0 44.1-35.7 79.9-79.8 80zM272 304l-96 0 0 24 31.4 36.7-31.4 115.3-40-160-56 0-64 192 416 0-64-192-56 0-40 160-.6 0-31-115.1 31.6-36.9 0-24zM168.8 26.5c5.1 2.6 23.5 11.8 55.2 27.6 31.7-15.8 50-25 55.2-27.6l14.3 28.6c-3.9 2-24.7 12.4-62.3 31.2l-7.2 3.6-7.2-3.6c-37.6-18.8-58.4-29.2-62.3-31.2l14.3-28.6zM336 416l32 0 0 32-48 0 0-32 16 0z"],
    "arrow-turn-left-down": [384, 512, [], "e633", "M352 64l32 0 0-64-224 0 0 402.7c-57.4-57.4-89.4-89.4-96-96l-45.3 45.3 22.6 22.6 128 128 22.6 22.6 173.3-173.3-45.3-45.3-96 96 0-338.7 128 0z"],
    "ticket-simple": [576, 512, ["ticket-alt"], "f3ff", "M0 64l576 0 0 144c-26.5 0-48 21.5-48 48s21.5 48 48 48l0 144-576 0 0-144c26.5 0 48-21.5 48-48S26.5 208 0 208L0 64z"],
    "dove": [576, 512, [128330], "f4ba", "M512 128l0 176c0 79.5-64.5 144-144 144l-112 0-64 64-160-96 160-64C32 304 37.4 117.3 64 64l288 160 0-80c0-44.2 35.8-80 80-80l128 0-48 64zm-80-8a24 24 0 1 0 0 48 24 24 0 1 0 0-48zM313.4 95.9c-5.8 14.4-9.2 30.1-9.4 46.5L170.2 68C185.3 20.8 215.6-15.8 240-32L313.4 95.9z"],
    "circle-yen": [512, 512, [], "e5d0", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM197.3 127.2c2.3 4 21.9 37.5 58.7 100.5 36.8-63 56.4-96.5 58.7-100.5l41.4 24.2c-1.9 3.3-22.3 38.2-61.1 104.6l41 0 0 32-56 0 0 32 56 0 0 32-56 0 0 48-48 0 0-48-56 0 0-32 56 0 0-32-56 0 0-32 41 0c-38.8-66.5-59.2-101.3-61.1-104.6l41.4-24.2z"],
    "tarp-droplet": [512, 512, [], "e57c", "M256 160c35.3 0 64-26.9 64-60s-64-108-64-108-64 74.9-64 108 28.7 60 64 60zM368 96c0 61.9-50.1 112-112 112S144 157.9 144 96c0-11.1 1.6-21.9 4.6-32L0 64 0 448 368 448 512 304 512 64 363.4 64c3 10.1 4.6 20.9 4.6 32zm85.5 176L336 389.5 336 272 453.5 272zM96 128a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "broom-wide": [576, 512, [], "e5d1", "M328 168l200-200 48 48-200 200 40 40-37.8 61.9-152.1-152.1 61.9-37.8 40 40zM191 187.3L356.7 353 240 544 108 412 128 352 68 372 0 304 191 187.3z"],
    "play-pause": [512, 512, [], "e22f", "M256 256L0 464 0 48 256 256zM384 96l0 352-64 0 0-384 64 0 0 32zm128 0l0 352-64 0 0-384 64 0 0 32z"],
    "tree-city": [640, 512, [], "e587", "M288 0l192 0 0 96 48 0 0-96 48 0 0 96 64 0 0 416-352 0 0-512zm64 96l0 64 64 0 0-64-64 0zm64 96l-64 0 0 64 64 0 0-64zm-64 96l0 64 64 0 0-64-64 0zm224-96l-64 0 0 64 64 0 0-64zm-64 96l0 64 64 0 0-64-64 0zM96 480l0-160-96 0 0-80c0-26.7 13.1-50.3 33.2-64.9-.8-4.9-1.2-10-1.2-15.1 0-53 43-96 96-96s96 43 96 96l0 160-64 0 0 192-64 0 0-32z"],
    "calendar-range": [448, 512, [], "e0d6", "M160 32l0-32-64 0 0 64-96 0 0 416 448 0 0-416-96 0 0-64-64 0 0 64-128 0 0-32zM128 192l0 64-64 0 0-64 64 0zM384 384l-64 0 0-64 64 0 0 64zm0-192l0 48-192 0 0-48 192 0zM64 320l192 0 0 48-192 0 0-48z"],
    "turn-up": [384, 512, [10548, "level-up-alt"], "f3bf", "M192 0l-192 192 128 0 0 192-128 0 0 128 256 0 0-320 128 0-192-192z"],
    "credit-card-front": [512, 512, [], "f38a", "M0 64l512 0 0 384-512 0 0-384zM64 336l0 48 96 0 0-48-96 0zm144 0l0 48 96 0 0-48-96 0zm144 0l0 48 96 0 0-48-96 0zM192 160l-128 0 0 96 128 0 0-96z"],
    "temperature-quarter": [320, 512, ["temperature-1", "thermometer-1", "thermometer-quarter"], "f2ca", "M256 0L64 0 64 260.7C34.5 287 16 325.4 16 368 16 447.5 80.5 512 160 512s144-64.5 144-144c0-42.6-18.5-81-48-107.3L256 0zM224 368c0 35.3-28.7 64-64 64s-64-28.7-64-64c0-26.9 16.5-49.9 40-59.3l0-52.7 48 0 0 52.7c23.5 9.5 40 32.5 40 59.3z"],
    "chestnut": [448, 512, [127792], "e3f6", "M.5 336C12.4 152.9 224 32 224 32S435.6 152.9 447.5 336L.5 336zM0 384l448 0 0 32-64 64-320 0-64-64 0-32z"],
    "crystal-ball": [448, 512, [], "e362", "M448 224c0 54.8-19.7 105.1-52.4 144L52.4 368C19.7 329.1 0 278.8 0 224 0 100.3 100.3 0 224 0S448 100.3 448 224zM177.3 126.7L160 80 142.7 126.7 96 144 142.7 161.3 160 208 177.3 161.3 224 144 177.3 126.7zM288 144L262.1 198.1 208 224 262.1 249.9 288 304 313.9 249.9 368 224 313.9 198.1 288 144zM16 480l57.6-64 300.8 0 57.6 64 0 32-416 0 0-32z"],
    "flag-swallowtail": [448, 512, ["flag-alt"], "f74c", "M64 32l0-32-64 0 0 512 64 0 0-128 384 0-96-160 96-160-384 0 0-32z"],
    "sliders": [512, 512, ["sliders-h"], "f1de", "M112 24l144 0 0 40 256 0 0 64-256 0 0 40-144 0 0-40-112 0 0-64 112 0 0-40zM32 224l272 0 0-40 144 0 0 40 64 0 0 64-64 0 0 40-144 0 0-40-304 0 0-64 32 0zm0 160l32 0 0-40 144 0 0 40 304 0 0 64-304 0 0 40-144 0 0-40-64 0 0-64 32 0z"],
    "person-sledding": [576, 512, ["sledding"], "f7cb", "M384.4 80a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM46.1 215.6L67.4 226.7 204.8 298c-12.8-20.3-10.5-49.8 13.8-66l60.1-40.1-118.3 0 0-64 205.3 0c5.7 5.7 13.1 13.1 22.2 22.2l3.2 3.2 22.6 22.6c-9.3 9.3-36 36-80 80l82.7 0 0 151.9 56.2 29.2c27.3-13.7 46.8-23.4 58.5-29.3l21.5 42.9c-9.9 4.9-33 16.5-69.5 34.7l-10.9 5.5-10.9-5.6-416-216-21.3-11.1 22.1-42.6zm306.2 159l0-54.6-105.3 0 105.3 54.6z"],
    "mosque": [576, 512, [128332], "f678", "M96 145.2c0 43.5 35.3 78.8 78.8 78.8l226.4 0c43.5 0 78.8-35.3 78.8-78.8 0-25.5-12.3-49.4-33.1-64.2L288-32 129.1 81C108.3 95.8 96 119.7 96 145.2zM0 288l0 224 576 0 0-320-64 0 0 80-448 0 0-80-64 0 0 96zM240 464l0-128 96 0 0 128-96 0z"],
    "folder-magnifying-glass": [512, 512, ["folder-search"], "e18b", "M512 448l-512 0 0-416 224 0 64 48 224 0 0 368zM336 256c0-53-43-96-96-96s-96 43-96 96 43 96 96 96c17.8 0 34.4-4.8 48.7-13.2l55.3 55.3 33.9-33.9c-7.8-7.8-26.2-26.2-55.3-55.3 8.5-14.3 13.3-31 13.3-48.9zm-96-48a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"],
    "link-horizontal": [576, 512, ["chain-horizontal"], "e1cb", "M288 288c53 0 96-43 96-96s-43-96-96-96L160 96c-53 0-96 43-96 96 0 25.2 9.7 48.2 25.6 65.3-6.2 19.8-9.6 40.9-9.6 62.7 0 3.6 .1 7.2 .3 10.8-48-27.6-80.3-79.4-80.3-138.8 0-88.4 71.6-160 160-160l128 0c88.4 0 160 71.6 160 160S376.4 352 288 352l-32 0 0-64 32 0zm224 32c0-25.2-9.7-48.2-25.6-65.3 6.2-19.8 9.6-40.9 9.6-62.7 0-3.6-.1-7.2-.3-10.8 48 27.6 80.3 79.4 80.3 138.8 0 88.4-71.6 160-160 160l-128 0c-88.4 0-160-71.6-160-160s71.6-160 160-160l32 0 0 64-32 0c-53 0-96 43-96 96s43 96 96 96l128 0c53 0 96-43 96-96z"],
    "h": [384, 512, [104], "48", "M320 288l0 192 64 0 0-448-64 0 0 192-256 0 0-192-64 0 0 448 64 0 0-192 256 0z"],
    "message-bot": [640, 512, [], "e3b8", "M96 192l0-160 448 0 0 160 96 0 0 48-96 0 0 208-192 0-160 96 0-96-96 0 0-208-96 0 0-48 96 0zm64-64l0 192 320 0 0-192-320 0zm96 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm96 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"],
    "info": [192, 512, [], "f129", "M128 0l0 64-64 0 0-64 64 0zM0 160l128 0 0 288 64 0 0 64-192 0 0-64 64 0 0-224-64 0 0-64z"],
    "person-walking": [384, 512, [128694, "walking"], "f554", "M192-32a56 56 0 1 1 0 112 56 56 0 1 1 0-112zM130.7 112l108.6 0 9.6 12 54.4 68 80.6 0 0 64-111.4 0c-4.2-5.2-15-18.8-32.6-40.8l0 115.2 52.8 45.3 9 7.7 1.8 11.7c12.5 81.4 19.5 126.6 20.9 135.6l-63.3 9.7c-1.7-11-8-52.3-19.1-123.9l-80.7-69.1c-21.3-18.2-33.5-44.9-33.5-72.9l0-69.3-32 32 0 82.7-64 0 0-109.3 9.4-9.4 80-80 9.4-9.4zM115.5 415.2L128.1 371c2.4 2.3 4.8 4.6 7.4 6.8l46 39.4c-5.2 18.3-8.2 28.8-9 31.5l-5.9 5.9c-49.6 49.6-78.4 78.4-86.6 86.6L34.7 496c9.2-9.2 36.1-36.1 80.8-80.8z"],
    "radio-tuner": [512, 512, ["radio-alt"], "f8d8", "M494.3 15.2l23.2-6-12-46.5-23.2 6-464 120-18 4.7 0 386.6 512 0 0-384-330.3 0 312.3-80.8zM384.2 280a72 72 0 1 1 0 144 72 72 0 1 1 0-144zM64.2 160l384 0 0 64-384 0 0-64zm32 128a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm96 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"],
    "computer-mouse-scrollwheel": [384, 512, ["mouse-alt"], "f8cd", "M384 0L0 0 0 352c0 88.4 71.6 160 160 160l64 0c88.4 0 160-71.6 160-160L384 0zM224 128l0 64-64 0 0-96 64 0 0 32z"],
    "car-siren-on": [512, 512, [], "e7c2", "M72.8-38.4c11 3.7 34.6 11.5 70.8 23.6L128.4 30.8 57.6 7.2 72.8-38.4zM312 64l121 0c.7 2.9 11.4 45.6 32 128l47 0 0 288-96 0 0-64-320 0 0 64-96 0 0-288 47 0C67.6 109.6 78.3 66.9 79 64l121 0 16-64 80 0 16 64zm71 64l-254 0-16 64 286 0-16-64zM96 336a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm352-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM416.4-30.8l22.8-7.6 15.2 45.5c-11 3.7-34.6 11.5-70.8 23.6l-15.2-45.5 48-16z"],
    "up-right": [448, 512, [], "e2be", "M416 64L416 416 296 296 112 480 0 368 184 184 64 64 416 64z"],
    "paintbrush-slash": [576, 512, [], "e74e", "M49.3-16.9l-17-17-33.9 33.9 17 17 512 512 17 17 33.9-33.9-17-17-157.1-157.1 172-258-80-80-258 172-188.9-188.9zM176.1 288c-61.9 0-112 50.1-112 112 0 17.2 3.9 33.5 10.8 48l-74.8 0 0 64 176 0c61.9 0 112-50.1 112-112 0-21.6-6.1-41.8-16.7-58.9L235 304.7c-17.1-10.6-37.3-16.7-58.9-16.7z"],
    "circle-arrow-up-right": [512, 512, [], "e0fc", "M256 0a256 256 0 1 1 0 512 256 256 0 1 1 0-512zM216 208l54.1 0-103 103-17 17 33.9 33.9 17-17 103-103 0 78.1 48 0 0-160-160 0 0 48 24 0z"],
    "arrow-turn-down": [384, 512, ["level-down"], "f149", "M32 64l-32 0 0-64 224 0 0 402.7 96-96 45.3 45.3-173.3 173.3-22.6-22.6-128-128-22.6-22.6 45.3-45.3c6.6 6.6 38.6 38.6 96 96L160 64 32 64z"],
    "road": [512, 512, [128739], "f018", "M224 32l-118.6 0-105.4 448 224 0 0-96 64 0 0 96 224 0-105.4-448-118.6 0 0 96-64 0 0-96zm64 192l0 96-64 0 0-128 64 0 0 32z"],
    "buoy": [640, 512, [], "e5b5", "M448.4 0l-256 0 0 64 25 0-51.2 256-37.8 0 0 71.4c33.3-13.3 57.3-22.9 72-28.8l26.8 10.7 93.3 37.3 93.2-37.3 26.8-10.7c14.7 5.9 38.8 15.5 72 28.8l0-71.4-37.8 0-51.2-256 25 0 0-64zM358.1 64l9.8 49-47.6 55.5-47.6-55.5 9.8-49 75.5 0zm21.8 108.8l17 84.9-44.9-52.4 27.9-32.6zm-91.1 32.6l-44.9 52.4 17-84.9 27.9 32.6zM253.7 320l66.7-77.8 66.7 77.8-133.4 0zm-44.4 97.7l-8.9-3.6-8.9 3.6-111.8 44.7c-29.3-9.8-50.1-16.7-62.4-20.8L2 487.2c11 3.7 34.6 11.5 70.8 23.6l8.3 2.8 8.2-3.3 111.1-44.4 111.1 44.4 8.9 3.6 8.9-3.6 111.1-44.4 111.1 44.4 8.2 3.3 8.3-2.8 70.8-23.6-15.2-45.5c-12.4 4.1-33.2 11.1-62.4 20.8l-111.8-44.7-8.9-3.6-8.9 3.6-111.1 44.4-111.1-44.4z"],
    "spiral": [512, 512, [], "e80a", "M164.8 17.8L181.6 45C110.9 88.8 64 166.9 64 256 64 362 150 448 256 448s192-86 192-192c0-75.1-60.9-136-136-136S176 180.9 176 256c0 44.2 35.8 80 80 80s80-35.8 80-80c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 32-64 0 0-32c0-48.6 39.4-88 88-88s88 39.4 88 88c0 79.5-64.5 144-144 144S112 335.5 112 256c0-110.5 89.5-200 200-200s200 89.5 200 200c0 141.4-114.6 256-256 256S0 397.4 0 256C0 143.9 59.2 45.6 147.9-9.4l16.9 27.2z"],
    "paintbrush-pencil": [576, 512, [], "e206", "M296.8 120.8L160-16 16 128 133.7 245.7c13.5-3.7 27.7-5.7 42.3-5.7l1.6 0c3.1-3.1 42.8-42.8 119.2-119.2zm33.5 321.5l29.7 29.7 200 56-56-200-48.8-48.8C378.8 355.6 339.1 395.3 336 398.4l0 1.6c0 14.7-2 28.9-5.7 42.3zm34.3-253.7L311.3 242c8.1 7 15.7 14.5 22.6 22.6l53.4-53.4-22.6-22.6zm160.6-47.4L570.5 96 480 5.5c-4.3 4.3-86.2 86.2-245.5 245.5 41.3 16.2 74.3 49.2 90.5 90.5L525.3 141.3zM176 512c61.9 0 112-50.1 112-112S237.9 288 176 288 64 338.1 64 400l0 48-64 0 0 64 176 0z"],
    "file-cad": [576, 512, [], "e672", "M272 0l-240 0 0 512 144 0 0-176 240 0 0-192-144-144zm85.5 176L240 176 240 58.5 357.5 176zM264 380c-24.3 0-44 19.7-44 44l0 80c0 24.3 19.7 44 44 44l16 0c24.3 0 44-19.7 44-44l0-16-40 0 0 16c0 2.2-1.8 4-4 4l-16 0c-2.2 0-4-1.8-4-4l0-80c0-2.2 1.8-4 4-4l16 0c2.2 0 4 1.8 4 4l0 16 40 0 0-16c0-24.3-19.7-44-44-44l-16 0zm128 0c-24.3 0-44 19.7-44 44l0 120 40 0 0-44 24 0 0 44 40 0 0-120c0-24.3-19.7-44-44-44l-16 0zm20 80l-24 0 0-36c0-2.2 1.8-4 4-4l16 0c2.2 0 4 1.8 4 4l0 36zm64-80l0 168 52 0c28.7 0 52-23.3 52-52l0-64c0-28.7-23.3-52-52-52l-52 0zm40 40l12 0c6.6 0 12 5.4 12 12l0 64c0 6.6-5.4 12-12 12l-12 0 0-88z"],
    "people-pants-simple": [448, 512, [], "e21a", "M96 128A64 64 0 1 0 96 0 64 64 0 1 0 96 128zm96 224l0-192-192 0 0 192 32 0 0 160 128 0 0-160 32 0zM352 128a64 64 0 1 0 0-128 64 64 0 1 0 0 128zm96 224l0-192-192 0 0 192 32 0 0 160 128 0 0-160 32 0z"],
    "face-frown": [512, 512, [9785, "frown"], "f119", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm0-160c-38.2 0-72 19.1-92.2 48.5l-39.5-27.3C153.1 331.4 201.3 304 256 304s102.9 27.4 131.8 69.2l-39.5 27.3C328 371.1 294.2 352 256 352zM144 208a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm192-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "wine-glass-empty": [320, 512, ["wine-glass-alt"], "f5ce", "M64 0L37.8 0 32.6 25.7 3.2 173C1.1 183.5 0 194.2 0 205l0 3c0 77.4 55 142 128 156.8l0 115.2-96 0 0 64 256 0 0-64-96 0 0-115.2C265 350 320 285.4 320 208l0-3c0-10.7-1.1-21.4-3.2-32L287.4 25.7 282.2 0 64 0zm1.9 185.6L90.2 64 229.8 64 254.1 185.6c1.3 6.4 1.9 12.9 1.9 19.4l0 3c0 53-43 96-96 96s-96-43-96-96l0-3c0-6.5 .6-13 1.9-19.4z"],
    "clapperboard": [512, 512, [], "e131", "M361.9 64l92.1 0-96 96 67.9 0 86.1-86.1 0 374.1-512 0 0-384 134.1 0-96 96 67.9 0 95-95 1-1 92.1 0-96 96 67.9 0 95-95 1-1z"],
    "oil-can-drip": [640, 512, [], "e205", "M352 128l-64 0 0 32 96 0 64 32 160-32 32 32-208 224-336 0 0-69.3-96-42.7 0-144 224 0 0-32-64 0 0-64 192 0 0 64zM48 208l0 64.8 48 21.3 0-86.1-48 0zM592 448c-26.5 0-48-21.5-48-48 0-32 48-96 48-96s48 64 48 96-21.5 48-48 48z"],
    "phone-plus": [512, 512, [], "f4d2", "M128 0L0 64 0 80C0 318.6 193.4 512 432 512l16 0 64-128-128-96.8-80 80.8c-70.4-33-127-89.6-160-160L224.8 128 128 0zM392 192l48 0 0-72 72 0 0-48-72 0 0-72-48 0 0 72-72 0 0 48 72 0 0 72z"],
    "forward-step": [384, 512, ["step-forward"], "f051", "M320 296l0 184 64 0 0-448-64 0 0 184-320-200 0 480 320-200z"],
    "file-dashed-line": [576, 512, ["page-break"], "f877", "M336 0l-240 0 0 240 384 0 0-96-144-144zM96 512l384 0 0-128-384 0 0 128zM421.5 176L304 176 304 58.5 421.5 176zM24 288l-24 0 0 48 160 0 0-48-136 0zm208 0l-24 0 0 48 160 0 0-48-136 0zm208 0l-24 0 0 48 160 0 0-48-136 0z"],
    "scribble": [512, 512, [], "e23f", "M170.4 23.3C187 8.3 208.5 0 230.8 0l1.1 0c48.9 0 88.6 39.7 88.6 88.6 0 23.5-9.3 46-25.9 62.6L103.7 342.1c-4.6 4.6-7.2 10.9-7.2 17.4 0 13.6 11 24.6 24.6 24.6 6.5 0 12.8-2.6 17.4-7.2L361.3 153.9c16.6-16.6 39.1-25.9 62.6-25.9 48.9 0 88.6 39.7 88.6 88.6 0 23.5-9.3 46-25.9 62.6l-88.2 88.2c-8.9 8.9-13.8 20.9-13.8 33.4 0 26.1 21.1 47.2 47.2 47.2l4.4 0c4.8 0 9.5-.8 14.1-2.3 5.1-1.7 19.3-6.4 42.6-14.2L513 492.2c-23.3 7.8-37.5 12.5-42.6 14.2-11.1 3.7-22.6 5.6-34.3 5.6l-4.4 0c-61.4 0-111.2-49.8-111.2-111.2 0-29.5 11.7-57.8 32.6-78.6l88.2-88.2c4.6-4.6 7.2-10.9 7.2-17.4 0-13.6-11-24.6-24.6-24.6-6.5 0-12.8 2.6-17.4 7.2L183.7 422.1c-16.6 16.6-39.1 25.9-62.6 25.9-48.9 0-88.6-39.7-88.6-88.6 0-23.5 9.3-46 25.9-62.6L249.3 105.9c4.6-4.6 7.2-10.9 7.2-17.4 0-13.6-11-24.6-24.6-24.6l-1.1 0c-6.4 0-12.6 2.4-17.3 6.7L54 215.7 11 168.3 170.4 23.3z"],
    "gauge-min": [512, 512, ["tachometer-alt-slowest"], "f628", "M0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zM288 96a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM256 416c35.3 0 64-28.7 64-64s-28.7-64-64-64c-14.5 0-27.8 4.8-38.5 12.9l-109.1-65.5-24.7 41.2 109.1 65.5c-.5 3.2-.8 6.6-.8 9.9 0 35.3 28.7 64 64 64zM176 144a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM416 288a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM400 144a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "square-up-right": [448, 512, [8599, "external-link-square-alt"], "f360", "M0 32l448 0 0 448-448 0 0-448zM296 160l-169.9 0c29.6 29.6 52.3 52.3 68 68-53 53-81 81-84 84 24.3 24.3 54.1 54.1 57.9 57.9 3-3 31-31 84-84 15.7 15.7 38.4 38.4 68 68l0-193.9-24 0z"],
    "wifi-exclamation": [576, 512, [], "e2cf", "M264.3 320l-24-288 96 0-24 288-48 0zm146.3 8.8c-13.2-15.6-29.4-28.7-47.6-38.4l5.6-67.6c34.1 13.1 64.2 34.3 87.9 61.2l-45.9 44.8zM213.7 290.4c-18.3 9.6-34.4 22.7-47.6 38.4L120.1 284c23.7-26.9 53.8-48.1 87.9-61.2l5.6 67.6zm323.1-84.7c-42-46.1-96.7-80.5-158.6-97.6l5.4-64.7c77.7 19 146.6 60.7 199.1 117.7l-45.8 44.7zM198.5 108.1c-61.9 17.1-116.6 51.5-158.6 97.6L-6 161.1c52.5-57 121.3-98.7 199.1-117.7l5.4 64.7zM288.3 384a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"],
    "book-journal-whills": [448, 512, ["journal-whills"], "f66a", "M0 0l448 0 0 384-32 0 0 64 32 0 0 64-448 0 0-512zM64 416l0 32 288 0 0-64-256 0c-17.7 0-32 14.3-32 32zM272.8 109c5.2 8.6 8.2 18.7 8.2 29.5 0 15.1-5.9 28.8-15.5 39.1l-4.2 4.5 3.3 5.2c4.6 7.3 7.3 15.9 7.4 25.2l0 .6c-.1 21.5-14.4 39.7-34 45.6L237 234c7.1-4.4 11.8-12.2 11.8-21.1 0-9.6-5.5-18-13.5-22.1l-3.3-81.8-16 0-3.3 81.8c-8 4.1-13.5 12.4-13.5 22.1 0 8.9 4.7 16.7 11.8 21.1l-1 24.8c-19.7-6-34-24.3-34-45.9 0-9.4 2.7-18.2 7.4-25.5l3.3-5.2-4.2-4.5c-9.6-10.2-15.5-23.9-15.5-39.1 0-10.8 3-20.9 8.2-29.5L164.1 98.1c-32.1 20-53.4 55.6-53.4 96.2 0 62.6 50.7 113.3 113.3 113.3s113.3-50.7 113.3-113.3c0-40.6-21.4-76.2-53.4-96.2L272.8 109z"],
    "octagon-minus": [512, 512, ["minus-octagon"], "f308", "M0 160L0 352 160 512 352 512 512 352 512 160 352 0 160 0 0 160zm168 72l200 0 0 48-224 0 0-48 24 0z"],
    "champagne-glasses": [640, 512, [129346, "glass-cheers"], "f79f", "M183.6 127.4l25.3-48.1 61.2 22.3-11.5 53.2-75-27.3zM178.4 0L87.7 172.2C60.2 224.4 76.8 287 122 319.8L91.1 404.7c-27.6-10.1-50.7-18.5-69.2-25.2L0 439.6c165.5 60.2 186.6 67.9 198.6 72.3l21.9-60.1c-18.5-6.7-41.6-15.1-69.2-25.2l30.9-84.9c55.7 3.9 108.6-33.3 121.2-91l16.7-76.9 16.7 76.9c12.5 57.7 65.4 94.9 121.2 91l30.9 84.9c-27.6 10.1-50.7 18.5-69.2 25.2l21.9 60.1C606.9 451.7 628 444 640 439.6l-21.9-60.1c-18.5 6.7-41.6 15.1-69.2 25.2L518 319.8c45.2-32.8 61.8-95.4 34.3-147.6L461.6 0 320 51.5 178.4 0zm278 127.4l-75 27.3-11.5-53.2 61.2-22.3 25.3 48.1z"],
    "folder-xmark": [512, 512, ["folder-times"], "f65f", "M512 80l0 368-512 0 0-416 224 0 64 48 224 0zM340.9 213.1l-33.9-33.9c-8.5 8.5-25.5 25.5-50.9 50.9-25.5-25.5-42.4-42.4-50.9-50.9l-33.9 33.9c8.5 8.5 25.5 25.5 50.9 50.9-25.5 25.5-42.4 42.4-50.9 50.9l33.9 33.9c8.5-8.5 25.5-25.5 50.9-50.9 25.5 25.5 42.4 42.4 50.9 50.9l33.9-33.9c-8.5-8.5-25.5-25.5-50.9-50.9 25.5-25.5 42.4-42.4 50.9-50.9z"],
    "trash-list": [640, 512, [], "e2b1", "M336-16l16 48 96 0 0 64-416 0 0-64 96 0 16-48 192 0zM64 144l352 0-24 368-304 0-24-368zm576-16l0 64-160 0 0-64 160 0zM480 256l128 0 0 64-128 0 0-64zm64 128l0 64-64 0 0-64 64 0z"],
    "dumpster": [576, 512, [], "f793", "M32 64L0 192 106.7 192 132.3 64 32 64zM264 192l0-128-82.7 0-25.6 128 108.3 0zm48 0l108.3 0-25.6-128-82.7 0 0 128zm157.3 0l106.7 0-32-128-100.3 0 25.6 128zM64 240l-37.8 0 6.2 37.3 32 192 1.8 10.7 64.9 0c-2.2-13.3-4.9-29.3-8-48l329.8 0c-3.1 18.7-5.8 34.7-8 48l64.9 0 1.8-10.7 32-192 6.2-37.3-485.8 0z"],
    "circle-envelope": [512, 512, ["envelope-circle"], "e10c", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM128 201.3l0-41.3 256 0 0 41.3-128 74-128-74zM264 307.6l120-69.3 0 113.8-256 0 0-113.8 120 69.3 8 4.6 8-4.6z"],
    "mobile-notch": [384, 512, ["mobile-iphone"], "e1ee", "M128 64l0 32 128 0 0-32 48 0 0 384-224 0 0-384 48 0zM80 0l-64 0 0 512 352 0 0-512-288 0zm48 352l0 48 128 0 0-48-128 0z"],
    "mobile-signal": [576, 512, [], "e1ef", "M32 0l352 0 0 295.3c-58 43.4-98.6 108.9-109.2 183.9l-.1 .7c-1.5 10.5-2.3 21.2-2.6 32L32 512 32 0zM168 416l-24 0 0 48 84.6 0c2.8-16.5 6.8-32.5 11.9-48L168 416zM552 288l24 0 0 48-24 0c-101.6 0-184 82.4-184 184l0 24-48 0 0-24c0-128.1 103.9-232 232-232zm-8 192a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm32-96l0 48-24 0c-48.6 0-88 39.4-88 88l0 24-48 0 0-24c0-75.1 60.9-136 136-136l24 0z"],
    "heart-circle-xmark": [576, 512, [], "e501", "M133.1 32C175.8 32 216 52.5 241 87.1l15 20.7 15-20.7c25-34.6 65.2-55.1 107.9-55.1 73.5 0 133.1 59.6 133.1 133.1 0 19.2-3 38.1-8.5 56.6-22.1-8.9-46.2-13.8-71.5-13.8-106 0-192 86-192 192 0 33 8.3 64 23 91.2-2.4 1.6-4.7 3.3-7 4.8-102.5-70.7-256-194.1-256-330.9 0-73.5 59.6-133.1 133.1-133.1zM432 256a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm55.3 111.3L498.6 356 476 333.4c-4 4-18.7 18.6-44 44-25.4-25.4-40-40-44-44L365.4 356c4 4 18.6 18.7 44 44-25.4 25.4-40 40-44 44L388 466.6c4-4 18.7-18.6 44-44 25.4 25.4 40 40 44 44L498.6 444c-4-4-18.6-18.7-44-44l32.7-32.7z"],
    "computer": [576, 512, [], "e4e5", "M336 32l-336 0 0 352 336 0 0-64-272 0 0-224 272 0 0-64zm0 400l-240 0 0 48 240 0 0-48zM576 32l-192 0 0 448 192 0 0-448zM456 96l72 0 0 48-96 0 0-48 24 0zm0 96l72 0 0 48-96 0 0-48 24 0zm-8 144a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"],
    "wand-magic": [576, 512, ["magic"], "f0d0", "M346.6 104.4L439.9 197.7 557.5 80 464.3-13.3 346.6 104.4zm-33.9 33.9L19 432 112.3 525.3 405.9 231.6 312.7 138.3z"],
    "brain": [512, 512, [129504], "f5dc", "M120 56c0-30.9 25.1-56 56-56l56 0 0 512-64 0c-29.8 0-54.9-20.4-62-48-.7 0-1.3 0-2 0-44.2 0-80-35.8-80-80 0-18 6-34.6 16-48-19.4-14.6-32-37.8-32-64 0-30.9 17.6-57.8 43.2-71.1-7.1-12-11.2-26-11.2-40.9 0-44.2 35.8-80 80-80l0-24zm272 0l0 24c44.2 0 80 35.8 80 80 0 15-4.1 29-11.2 40.9 25.7 13.3 43.2 40.1 43.2 71.1 0 26.2-12.6 49.4-32 64 10 13.4 16 30 16 48 0 44.2-35.8 80-80 80-.7 0-1.3 0-2 0-7.1 27.6-32.2 48-62 48l-64 0 0-512 56 0c30.9 0 56 25.1 56 56z"],
    "people-pants": [640, 512, [], "e219", "M192.3 80a56 56 0 1 0 0-112 56 56 0 1 0 0 112zm-80 464l64 0 0-208 32 0 0 208 64 0 0-277.9c15 28 24.6 46 28.8 53.9l38.4 0c4.2-7.9 13.8-25.9 28.8-53.9l0 277.9 64 0 0-208 32 0 0 208 64 0 0-277.9c14 26.1 25.6 47.9 34.9 65.2l56.5-30.2-15.1-28.2-76.9-144-9-16.9-140.5 0-9 16.9-48.7 91.2-48.7-91.2-9-16.9-140.5 0-9 16.9-76.9 144-15.1 28.2 56.5 30.2c9.3-17.4 20.9-39.1 34.9-65.2l0 277.9zm336-464a56 56 0 1 0 0-112 56 56 0 1 0 0 112z"],
    "dialpad": [384, 512, [], "e7cc", "M144 0l96 0 0 96-96 0 0-96zm96 144l0 96-96 0 0-96 96 0zM96 288l0 96-96 0 0-96 96 0zm144 0l0 96-96 0 0-96 96 0zm48 0l96 0 0 96-96 0 0-96zM0 144l96 0 0 96-96 0 0-96zm384 0l0 96-96 0 0-96 96 0zM240 432l0 96-96 0 0-96 96 0zM0 0L96 0 96 96 0 96 0 0zM384 0l0 96-96 0 0-96 96 0z"],
    "briefcase-medical": [512, 512, [], "f469", "M144 0l224 0 0 96 144 0 0 384-512 0 0-384 144 0 0-96zM320 48l-128 0 0 48 128 0 0-48zM224 200l0 56-56 0 0 64 56 0 0 56 64 0 0-56 56 0 0-64-56 0 0-56-64 0z"],
    "smoke": [576, 512, [], "f760", "M384.4 75.8c-23.5-26.9-58-43.8-96.4-43.8-22 0-42.6 5.5-60.7 15.3-23.5-28.8-59.2-47.3-99.3-47.3-70.7 0-128 57.3-128 128 0 46.6 24.9 87.3 62.1 109.7 7.8-5.2 16-9.8 24.6-13.8 20.9-73.9 88.8-128 169.4-128 25.6 0 50 5.5 71.9 15.3 16.2-15.2 35.4-27.3 56.5-35.5zM144.7 208.7c5-.4 10.1-.7 15.3-.7 26.3 0 51.3 5.8 73.8 16.2 21.2-10.4 45-16.2 70.2-16.2 52.8 0 99.6 25.6 128.7 65 42.2 4.9 78.9 28 101.9 61.3 25.5-23.4 41.4-57 41.4-94.3 0-70.7-57.3-128-128-128-46.5 0-87.3 24.8-109.7 62-22.3-18.7-51-30-82.3-30-47.6 0-89.2 26-111.3 64.7zM32 384l0 128 480 0 0-96c0-53-43-96-96-96-3.6 0-7.1 .2-10.5 .6-17.9-38.1-56.6-64.6-101.5-64.6-26.2 0-50.3 9-69.3 24-21-15.1-46.8-24-74.7-24-70.7 0-128 57.3-128 128z"],
    "house-medical-circle-exclamation": [640, 512, [], "e512", "M80 512l260 0c-21.2-29.5-34.3-65.3-35.9-104l-48.2 0 0-56-56 0 0-64 56 0 0-56 64 0 0 56 20 0c34.9-48.5 91.7-80 156-80 11.7 0 23.1 1 34.2 3L288-16 32 224 32 272 80 272 80 512zm416 32a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm16-64l-32 0 0-32 32 0 0 32zm0-176l0 112-32 0 0-112 32 0z"],
    "face-monocle": [512, 512, [], "e380", "M256 512c46.6 0 90.3-12.5 128-34.2L384 312c-20.1 15.1-45 24-72 24-66.3 0-120-53.7-120-120S245.7 96 312 96 432 149.7 432 216c0 2.7-.1 5.4-.3 8l.3 0 0 217.9C481.3 395.2 512 329.2 512 256 512 114.6 397.4 0 256 0S0 114.6 0 256 114.6 512 256 512zM128 160a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm144 48a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm112 8a72 72 0 1 0 -144 0 72 72 0 1 0 144 0zM184 416l-24 0 0-48 24.2 0c8.5 0 31 0 56.1 6.8 25.3 6.9 55.3 21.4 75.7 51.8L276 453.3c-11.7-17.5-29.7-27.1-48.3-32.2-18.7-5.1-36-5.2-43.7-5.2z"],
    "line-columns": [448, 512, [], "f870", "M192 32l-192 0 0 64 192 0 0-64zm0 128l-192 0 0 64 192 0 0-64zM0 288l0 64 192 0 0-64-192 0zM192 416l-192 0 0 64 192 0 0-64zM256 32l0 64 192 0 0-64-192 0zM448 160l-192 0 0 64 192 0 0-64zM256 288l0 64 192 0 0-64-192 0zM448 416l-192 0 0 64 192 0 0-64z"],
    "face-vomit": [576, 512, [], "e3a0", "M544 256c0 69.9-28.1 133.3-73.5 179.5l-4.3-1.3c-17.3-5.2-30-19.6-33.3-36.9 9.7-11.4 15.1-24 15.1-37.4 0-48.6-71.6-88-160-88s-160 39.4-160 88c0 13.4 5.4 26.1 15.1 37.4-3.3 17.3-16 31.7-33.3 36.9l-4.3 1.3C60.1 389.3 32 325.9 32 256 32 114.6 146.6 0 288 0S544 114.6 544 256zM246.8 177.7l-95.6-48-16.8 27.1 45.3 34-44.2 27.6 14.7 28.3 95.6-40 10.2-4.3 0-20.2-9.2-4.6zm178-48l-95.6 48-9.2 4.6 0 20.2 10.2 4.3 95.6 40 14.7-28.3-44.2-27.6 45.3-34-16.8-27.1zM32 448a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm480 0a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM192 396.1l0-57.4c23.6-11.1 57.3-18.7 96-18.7s72.4 7.6 96 18.7l0 57.4c0 31 19.8 58.5 49.2 68.3l46.8 15.6 0 32-384 0 0-32 46.8-15.6c29.4-9.8 49.2-37.3 49.2-68.3zM304 384a16 16 0 1 0 0 32 16 16 0 1 0 0-32zm-48 48a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"],
    "person-dolly": [512, 512, [], "f4d0", "M64-32A56 56 0 1 1 64 80 56 56 0 1 1 64-32zM0 112l96.5 0 9.6 13.4 70.4 98.6 79.5 0 0-64 48 0 0 304 208 0 0 48-194.7 0c-6.6 18.6-24.4 32-45.3 32-26.5 0-48-21.5-48-48 0-20.9 13.4-38.7 32-45.3l0-162.7-112.5 0c-4.3-6-14.8-20.8-31.5-44.1l0 80.1 67.2 50.4 12.8 9.6 0 160-64 0 0-128-89.6-67.2C14.2 330.7 0 302.2 0 272L0 112zM0 379.3c3.1 2.7 6.3 5.4 9.6 7.9L64 428 64 544 0 544 0 379.3zM512 256l0 160-160 0 0-160 160 0z"],
    "code-commit": [576, 512, [], "f386", "M224 192l0 128 128 0 0-128-128 0zm-80-80l288 0 0 112 144 0 0 64-144 0 0 112-288 0 0-112-144 0 0-64 144 0 0-112z"],
    "person-breastfeeding": [448, 512, [], "e53a", "M144.3 80a80 80 0 1 1 160 0 80 80 0 1 1 -160 0zM269.4 443.8l23-32.9-52.8-8.8-47.4-47.4 0-66.7-64 0c0 40 0 66.7 0 80 0 .7 0 1.4 .1 2.1 50.5 25 87.9 43.5 112.2 55.6l-42.6 86c-14.5-7.2-71.5-35.4-171-84.7L.3 413.8c0-49.3 0-49.2 0-61.8l9.6-12.8 96-128 14.4-19.2 226.2 0 14.2 22c57.1 88.8 86.9 135.2 89.4 139.1-6.1 8.7-30.9 44.1-74.5 106.4l-27.5 39.3-78.6-55zm6.8-67.8a44 44 0 1 0 0-88 44 44 0 1 0 0 88z"],
    "square-baht": [448, 512, [], "e719", "M448 32l-448 0 0 448 448 0 0-448zM208 96l32 0 0 32 4 0c42 0 76 34 76 76 0 16.2-5.1 31.3-13.8 43.7 18.1 13.9 29.8 35.8 29.8 60.3 0 42-34 76-76 76l-20 0 0 32-32 0 0-32-72 0 0-256 72 0 0-32zm-24 80l0 56 24 0 0-56-24 0zm56 0l0 56 4 0c15.5 0 28-12.5 28-28s-12.5-28-28-28l-4 0zM184 280l0 56 24 0 0-56-24 0zm56 0l0 56 20 0c15.5 0 28-12.5 28-28s-12.5-28-28-28l-20 0z"],
    "person-rays": [576, 512, [], "e54d", "M232.4 24a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm-11.4 88l134.8 0 9.6 13.2C439.7 227.6 477 278.8 477.1 279.1l-51.8 37.6c-9.3-12.8-28.3-39-56.9-78.4l0 305.7-64 0 0-208-32 0 0 208-64 0 0-305.7c-28.6 39.4-47.6 65.6-56.9 78.4l-51.8-37.6 18.8-25.9 92.9-128 9.6-13.2zM56.4-9.9c.8 .8 33.1 33.1 97 97l17 17-33.9 33.9c-.8-.8-33.1-33.1-97-97L22.5 24 56.4-9.9zm447 17l17-17 33.9 33.9-17 17c-63.8 63.8-96.2 96.2-97 97l-33.9-33.9 17-17 80-80zM56.4 521.9L22.5 488c.8-.8 33.1-33.1 97-97l17-17 33.9 33.9c-.8 .8-33.1 33.1-97 97l-17 17zm447-17l-80-80-17-17 33.9-33.9 17 17 80 80 17 17-33.9 33.9-17-17z"],
    "water-arrow-down": [512, 512, ["water-lower"], "f774", "M233.6 230.6l22.6 22.6c5.5-5.5 39.7-39.7 102.6-102.6l22.6-22.6-45.3-45.3c-14.6 14.6-30.6 30.6-48 48l0-130.7-64 0 0 130.7-48-48-45.3 45.3c5.5 5.5 39.7 39.7 102.6 102.6zm-97.4 55.5l-8.9 3.6C44.3 322.9 2.2 339.7 1 340.2l17.8 44.6c2.7-1.1 41.8-16.7 117.4-47l111.1 44.4 8.9 3.6 8.9-3.6 111.1-44.4c75.5 30.2 114.6 45.9 117.4 46.9l17.8-44.6c-1.2-.5-43.3-17.3-126.3-50.5l-8.9-3.6-8.9 3.6-111.1 44.4-111.1-44.4-8.9-3.6zm0 128l-8.9 3.6C44.3 450.9 2.2 467.7 1 468.2l17.8 44.6c2.7-1.1 41.8-16.7 117.4-47l111.1 44.4 8.9 3.6 8.9-3.6 111.1-44.4c75.5 30.2 114.6 45.9 117.4 46.9l17.8-44.6c-1.2-.5-43.3-17.3-126.3-50.5l-8.9-3.6-8.9 3.6-111.1 44.4-111.1-44.4-8.9-3.6z"],
    "symbols": [576, 512, [128291, "icons-alt"], "f86e", "M544.3-7l0 183c0 26.5-28.7 48-64 48s-64-21.5-64-48 28.7-48 64-48l0-57-96 19.2 0 117.8c0 26.5-28.7 48-64 48s-64-21.5-64-48 28.7-48 64-48l0-122.2 25.7-5.1C472.9 7.2 539-6 544.3-7zM64.3 0l160 0 0 64-192 0 0-64 32 0zm0 112l160 0 0 64-64 0 0 48-64 0 0-48-64 0 0-64 32 0zM534.9 342.6L352.3 525.3 307 480 512.3 274.7 557.5 320 534.9 342.6zM360.3 288a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm104 184a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zm-352-216c35.3 0 64 28.7 64 64l0 1.9c0 17.2-6.7 33.7-18.7 46.1l18.7 18.7c17.4-17.4 33.4-33.4 48-48L269.5 384c-14.6 14.6-30.6 30.6-48 48 17.4 17.4 33.4 33.4 48 48l-45.3 45.3c-14.6-14.6-30.6-30.6-48-48l-12.1 12.1c-14.5 14.5-34.1 22.6-54.6 22.6-42.7 0-77.3-34.6-77.3-77.3 0-20.5 8.1-40.1 22.6-54.6L67 368c-12-12.3-18.7-28.8-18.7-46.1l0-1.9c0-35.3 28.7-64 64-64zm-11.3 52.7c-6.2 6.2-6.2 16.4 0 22.6l11.3 11.3 11.3-11.3c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0zm14.1 101.7l-2.8-2.8c-.3 .3-5.3 5.3-14.9 14.9-3.2 3.2-5.1 7.6-5.1 12.2 0 9.5 7.7 17.3 17.3 17.3 4.6 0 9-1.8 12.2-5.1 9.6-9.6 14.6-14.6 14.9-14.9l-2.8-2.8-18.7-18.7z"],
    "chart-mixed-up-circle-currency": [640, 512, [], "e5d8", "M432.5 0l-32 0 0 64 60.8 0-109.4 87.5-108.2-81.1-19.8-14.9-19.4 15.5-160 128-25 20 40 50 25-20 140.6-112.5 108.2 81.1 19.8 14.9 19.4-15.5 140-112 0 71 64 0 0-176-144 0zm-240 224l0 256 64 0 0-256-64 0zm-128 96l0 160 64 0 0-160-64 0zm400 224a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm32-144a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm32 0c0 11.9-3.2 23-8.9 32.5l28.2 28.2-22.6 22.6-28.2-28.2c-9.5 5.6-20.6 8.9-32.5 8.9s-23-3.2-32.5-8.9l-28.2 28.2-22.6-22.6 28.2-28.2c-5.6-9.5-8.9-20.6-8.9-32.5s3.2-23 8.9-32.5l-28.2-28.2 22.6-22.6 28.2 28.2c9.5-5.6 20.6-8.9 32.5-8.9s23 3.2 32.5 8.9l28.2-28.2 22.6 22.6-28.2 28.2c5.6 9.5 8.9 20.6 8.9 32.5z"],
    "manat-sign": [384, 512, [], "e1d5", "M216 32l-48 0 0 65.5C73.3 109.3 0 190.1 0 288l0 192 64 0 0-192c0-62.5 44.8-114.5 104-125.8l0 317.8 48 0 0-317.8c59.2 11.2 104 63.3 104 125.8l0 192 64 0 0-192c0-97.9-73.3-178.7-168-190.5L216 32z"],
    "bag-seedling": [448, 512, [], "e5f2", "M0 0l448 0-32 64 18.6 74.5c8.9 35.5 13.4 72 13.4 108.7l0 17.7c0 36.6-4.5 73.1-13.4 108.7l-18.6 74.5 32 64-448 0 32-64-18.6-74.5C4.5 338 0 301.5 0 264.8l0-17.7C0 210.5 4.5 174 13.4 138.5L32 64 0 0zM128 160l-32 0 0 16c0 59.2 45.9 107.6 104 111.7l0 64.3 48 0 0-64.3c58.1-4.1 104-52.6 104-111.7l0-16-32 0c-40.7 0-76.4 21.8-96 54.3-19.6-32.5-55.3-54.3-96-54.3z"],
    "sort": [448, 512, ["unsorted"], "f0dc", "M224-8L8 224 440 224 224-8zm0 528L440 288 8 288 224 520z"],
    "circle-radiation": [512, 512, [9762, "radiation-alt"], "f7ba", "M0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm64 0l96 0c.6-36.9 22.1-68.8 53.2-84.3L164.4 87.2C104.6 119.8 64 183.1 64 256zm139 81.7l-47.3 82C184.9 437.7 219.2 448 256 448s71.1-10.3 100.3-28.3l-47.3-82c-15.2 10.1-33.4 15.9-53 15.9s-37.8-5.9-53-15.9zM352 256l96 0c0-72.9-40.6-136.2-100.4-168.8l-48.8 84.5c31.1 15.5 52.5 47.3 53.2 84.3zm-96 49.7a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"],
    "laptop-code": [640, 512, [], "f5fc", "M64 32l512 0 0 304-64 0 0-240-384 0 0 240-64 0 0-304zM0 424l0-40 640 0 0 40-56 56-528 0-56-56zM281 209l-31 31c23 23 39 39 48 48L264 321.9c-6.1-6.1-27.8-27.8-65-65l-17-17 65-65 17-17 33.9 33.9-17 17zM393 175c37.2 37.2 58.8 58.8 65 65-6.1 6.1-27.8 27.8-65 65l-17 17-33.9-33.9c9-9 25-25 48-48-23-23-39-39-48-48l33.9-33.9 17 17z"],
    "sink": [512, 512, [], "e06d", "M288 96c0-17.7 14.3-32 32-32s32 14.3 32 32l0 32 64 0 0-32c0-53-43-96-96-96s-96 43-96 96l0 192-64 0 0-96-128 0 0 48 80 0 0 48-112 0 0 64 32 0 0 64c0 53 43 96 96 96l256 0c53 0 96-43 96-96l0-64 32 0 0-64-112 0 0-48 88 0 0-48-136 0 0 96-64 0 0-192z"],
    "table-cells-rows": [448, 512, [], "e6b0", "M192 288l0-64 192 0 0 64-192 0zm0-192l192 0 0 64-192 0 0-64zm0 320l0-64 192 0 0 64-192 0zM64 32l-64 0 0 448 448 0 0-448-384 0z"],
    "arrow-up-from-water-pump": [640, 512, [], "e4b6", "M497.3 39l-17-17-17 17-88 88-17 17 33.9 33.9c6.3-6.3 27.6-27.6 64-64l0 142.1-136 0 0-224-224 0 0 224-64 0 0 140.3c15.1 5 30.4 10.1 45.8 15.2 75.1-30.1 115.9-46.4 122.3-48.9 6.7 2.7 46.7 18.7 120 48 73.3-29.3 113.3-45.3 120-48 6.4 2.5 47.1 18.8 122.3 48.9 15.4-5.1 30.6-10.2 45.7-15.2l0-140.3-104 0 0-142.1c36.4 36.4 57.7 57.7 64 64l33.9-33.9-17-17-88-88zm-297 375.1l-8.9 3.6-111.8 44.7c-29.3-9.7-50.1-16.7-62.4-20.8L2 487.2c11 3.7 34.6 11.5 70.8 23.6l8.3 2.8 8.2-3.3 111.1-44.4 111.1 44.4 8.9 3.6 8.9-3.6 111.1-44.4 111.1 44.4 8.2 3.3 8.3-2.8c36.2-12.1 59.8-19.9 70.8-23.6l-15.2-45.5c-12.4 4.1-33.2 11.1-62.4 20.8l-111.8-44.7-8.9-3.6-8.9 3.6-111.1 44.4-111.1-44.4-8.9-3.6z"],
    "microphone-lines-slash": [576, 512, ["microphone-alt-slash"], "f539", "M32.3-33.8l17 17 142.8 142.8 0-126 192 0 0 88-80 0 0 48 80 0 0 48-80 0 0 48 79.7 0c-1.9 22.8-11.7 43.4-26.8 58.9L391 324.8c25.5-26 41.2-61.6 41.2-100.8l0-64 48 0 0 64c0 52.5-21.1 100.1-55.2 134.7l153.4 153.4-33.9 33.9-17-17-512-512-17-17 33.9-33.9zM339.4 409.1c-8.8 2.4-17.9 4.3-27.3 5.4l0 49.5 72 0 0 48-192 0 0-48 72 0 0-49.5c-94.7-11.8-168-92.6-168-190.5l0-58.2 48 48 0 10.2c0 79.5 64.5 144 144 144 3.3 0 6.6-.1 9.8-.3l41.4 41.4z"],
    "face-shaking-vertical": [512, 512, [], "e79e", "M192-64l0 128 48 0 0-128 48 0 0 66c126.3 15.7 224 123.5 224 254 0 141.4-114.6 256-256 256-22.1 0-43.5-2.8-64-8.1l0 72.1-48 0 0-144-48 0 0 23.9C37.5 408.9 0 336.8 0 256S37.5 103.1 96 56.1l0 71.9 48 0 0-192 48 0zm64 464c-38.2 0-72-19.1-92.2-48.5l-39.5 27.3C153.1 420.6 201.3 448 256 448s102.9-27.4 131.8-69.2l-39.5-27.3C328 380.9 294.2 400 256 400zM168 260l16 0c11 0 20 9 20 20l0 16 40 0 0-16c0-33.1-26.9-60-60-60l-16 0c-33.1 0-60 26.9-60 60l0 16 40 0 0-16c0-11 9-20 20-20zm140 20c0-11 9-20 20-20l16 0c11 0 20 9 20 20l0 16 40 0 0-16c0-33.1-26.9-60-60-60l-16 0c-33.1 0-60 26.9-60 60l0 16 40 0 0-16z"],
    "browser": [512, 512, [128468], "f37e", "M0 64l512 0 0 384-512 0 0-384zm64 64l0 64 64 0 0-64-64 0zm120 8l-24 0 0 48 288 0 0-48-264 0z"],
    "face-sleepy": [576, 512, [], "e38e", "M532.5 332.1C540 308.1 544 282.5 544 256 544 114.6 429.4 0 288 0S32 114.6 32 256 146.6 512 288 512c40.2 0 78.3-9.3 112.2-25.8-.1-2-.2-4.1-.2-6.2 0-16.7-.4-32.8-4.9-46.8-2-6.3-4.5-10.7-7-13.7-2.4-2.8-5.8-5.7-11.8-8.1l-2.2-.9-22.3 11.8C339.6 399.5 315.6 384 288 384s-51.6 15.5-63.7 38.4l-42.4-22.5c20.1-37.9 60.1-63.9 106.1-63.9 21.9 0 42.4 5.9 60 16.1 3.3-17.3 6.4-33 9.1-47.1-23.9-7.9-41.1-30.4-41.1-57l0-16 40 0 0 16c0 11 9 20 20 20l16 0c11 0 20-9 20-20l0-16 40 0 0 16c0 17.1-7.2 32.6-18.7 43.5 32.5 6.3 68.6 20.9 99.2 40.6zM184 268l16 0c11 0 20-9 20-20l0-16 40 0 0 16c0 33.1-26.9 60-60 60l-16 0c-33.1 0-60-26.9-60-60l0-16 40 0 0 16c0 11 9 20 20 20zm210.1 98.9c26.5 10.6 39.8 30.2 46.7 51.7 7.1 22.1 7.2 45.3 7.2 61.5 0 35.3 28.7 64 64 64s64-28.7 64-64c0-48.1-33.5-84.3-69.3-107.4-35.9-23.2-78.9-36.6-106.7-36.6l-5.9 30.9z"],
    "server": [448, 512, [], "f233", "M448 32l-448 0 0 192 448 0 0-192zM280 104a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm56 24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM448 288l-448 0 0 192 448 0 0-192zM280 360a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm56 24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"],
    "user": [448, 512, [128100, 62144, 62470, "user-alt", "user-large"], "f007", "M224 248a120 120 0 1 0 0-240 120 120 0 1 0 0 240zM432 512l-64-208-288 0-64 208 416 0z"],
    "signal-bars": [448, 512, ["signal-alt", "signal-alt-4", "signal-bars-strong"], "f690", "M448 64l0-32-64 0 0 448 64 0 0-416zM320 128l-64 0 0 352 64 0 0-352zM192 288l0-32-64 0 0 224 64 0 0-192zM64 416l0-32-64 0 0 96 64 0 0-64z"],
    "starship-freighter": [576, 512, [], "e03a", "M224 480C100.3 480 0 379.7 0 256S100.3 32 224 32c42.3 0 84.2 7.9 123.6 23.2l228.4 88.8 0 80-160 0 0 64 160 0 0 80-96 37.3 0 74.7-128 0-18.2-18.2C298.5 473.9 261.4 480 224 480zm0-256a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm0 112a80 80 0 1 0 0-160 80 80 0 1 0 0 160zM80 280a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm56-120a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM112 376a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"],
    "snowflake": [576, 512, [10052, 10054], "f2dc", "M320.4 0l0-32-64 0 0 94.1-24-24-33.9 33.9c7.3 7.3 26.6 26.6 57.9 57.9l0 70.6-61.2-35.3c-11.5-42.8-18.5-69.2-21.2-79.1L127.7 98.5c4.7 17.7 7.7 28.6 8.8 32.8-40.2-23.2-67.3-38.9-81.5-47L23 139.7c14.1 8.2 41.3 23.8 81.5 47-4.1 1.1-15.1 4-32.8 8.8l12.4 46.4c10-2.7 36.4-9.7 79.1-21.2l61.2 35.3-61.2 35.3c-42.8-11.5-69.2-18.5-79.1-21.2L71.7 316.5c17.7 4.8 28.6 7.7 32.8 8.8-40.2 23.2-67.3 38.9-81.5 47l32 55.4c14.1-8.2 41.3-23.8 81.5-47-1.1 4.1-4 15.1-8.8 32.8L174 425.9c2.7-10 9.7-36.4 21.2-79.1l61.2-35.3 0 70.6c-31.3 31.3-50.6 50.6-57.9 57.9l33.9 33.9c13-13 21-21 24-24l0 94.1 64 0 0-94.1c3 3 11 11 24 24l33.9-33.9-57.9-57.9 0-70.6 61.2 35.3c11.5 42.8 18.5 69.1 21.2 79.1l46.4-12.4c-4.7-17.7-7.7-28.6-8.8-32.8 40.2 23.2 67.3 38.9 81.5 47l32-55.4c-14.1-8.2-41.3-23.8-81.5-47 4.1-1.1 15.1-4 32.8-8.8l-12.4-46.4c-10 2.7-36.4 9.7-79.1 21.2l-61.2-35.3 61.2-35.3c42.8 11.5 69.1 18.5 79.1 21.2l12.4-46.4c-17.7-4.7-28.6-7.7-32.8-8.8 40.2-23.2 67.3-38.9 81.5-47l-32-55.4c-14.1 8.2-41.3 23.8-81.5 47 1.1-4.1 4-15.1 8.8-32.8L402.8 86.1c-2.7 10-9.7 36.4-21.2 79.1l-61.2 35.3 0-70.6C351.7 98.6 371 79.3 378.4 72L344.4 38.1c-13 13-21 21-24 24l0-62.1z"],
    "dial-med": [576, 512, [], "e15f", "M320 0l0 64-64 0 0-64 64 0zM128 64l0 64-64 0 0-64 64 0zm384 0l0 64-64 0 0-64 64 0zm0 192l64 0 0 64-64 0 0-64zm0 192l0 64-64 0 0-64 64 0zM64 448l64 0 0 64-64 0 0-64zM0 256l64 0 0 64-64 0 0-64zm128 31.2C128 207 187 140.6 264 129l0 182.2 48 0 0-182.2c77 11.6 136 78 136 158.2 0 88.4-71.6 160-160 160s-160-71.6-160-160z"],
    "skull-crossbones": [512, 512, [128369, 9760], "f714", "M416.3 144c0-79.5-71.6-144-160-144s-160 64.5-160 144c0 47.1 25.1 88.9 64 115.2l0 60.8 192 0 0-60.8c38.9-26.3 64-68.1 64-115.2zm-224-16a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm96 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM465.6 310.2l-29.5 12.3-179.7 74.9-179.7-74.9-29.5-12.3-24.6 59.1c4.4 1.8 54.7 22.8 150.6 62.8-96 40-146.2 60.9-150.6 62.8l24.6 59.1 29.5-12.3 179.7-74.9 179.7 74.9 29.5 12.3 24.6-59.1c-4.4-1.8-54.7-22.8-150.6-62.8 96-40 146.2-60.9 150.6-62.8l-24.6-59.1z"],
    "peso-sign": [448, 512, [], "e222", "M112 32l-32 0 0 96-48 0 0 48 48 0 0 32-48 0 0 48 48 0 0 224 64 0 0-128 96 0c65.6 0 122-39.5 146.7-96l61.3 0 0-48-48.8 0c.5-5.3 .8-10.6 .8-16s-.3-10.7-.8-16l48.8 0 0-48-61.3 0C362 71.5 305.6 32 240 32L112 32zm199.6 96l-167.6 0 0-32 96 0c28.4 0 54 12.4 71.6 32zM144 176l190.7 0c.9 5.2 1.3 10.5 1.3 16s-.5 10.8-1.3 16l-190.7 0 0-32zm167.6 80c-17.6 19.6-43.1 32-71.6 32l-96 0 0-32 167.6 0z"],
    "wine-glass": [320, 512, [127863], "f4e3", "M37.8 0l244.5 0 5.1 25.7 29.5 147.3c2.1 10.5 3.2 21.2 3.2 32l0 3c0 77.4-55 142-128 156.8l0 115.2 96 0 0 64-256 0 0-64 96 0 0-115.2C55 350 0 285.4 0 208l0-3c0-10.7 1.1-21.4 3.2-32L32.6 25.7 37.8 0zM77.4 128l165.1 0-12.8-64-139.5 0-12.8 64z"],
    "temperature-half": [320, 512, [127777, "temperature-2", "thermometer-2", "thermometer-half"], "f2c9", "M256 0L64 0 64 260.7C34.5 287 16 325.4 16 368 16 447.5 80.5 512 160 512s144-64.5 144-144c0-42.6-18.5-81-48-107.3L256 0zM224 368c0 35.3-28.7 64-64 64s-64-28.7-64-64c0-26.9 16.5-49.9 40-59.3l0-116.7 48 0 0 116.7c23.5 9.5 40 32.5 40 59.3z"],
    "chart-tree-map": [512, 512, [], "e0ea", "M0 64l192 0 0 160-192 0 0-160zM0 288l192 0 0 160-192 0 0-160zM512 64l0 96-256 0 0-96 256 0zM256 208l256 0 0 96-256 0 0-96zM512 352l0 96-256 0 0-96 256 0z"],
    "ticket": [576, 512, [127903], "f145", "M576 64L0 64 0 208c26.5 0 48 21.5 48 48S26.5 304 0 304l0 144 576 0 0-144c-26.5 0-48-21.5-48-48s21.5-48 48-48l0-144zM160 176l0 160 256 0 0-160-256 0zm-48-48l352 0 0 256-352 0 0-256z"],
    "nfc-symbol": [512, 512, [], "e531", "M163.1 40.2l-17.3-15.5-20.1 11.6C50.3 79.9 0 163.2 0 256S50.3 432.1 125.7 475.7l32-55.4C101.9 388 64 325.7 64 256 64 194.6 93.5 138.8 138.8 104.4l159.9 143.5 23.8 21.4 42.7-47.6-23.8-21.4-178.3-160zM348.9 471.8l17.3 15.5 20.1-11.6C461.6 432.1 512 348.8 512 256S461.6 79.9 386.3 36.3l-32 55.4c55.8 32.3 93.7 94.7 93.7 164.3 0 61.4-29.5 117.2-74.8 151.7l-159.9-143.5-23.8-21.4-42.7 47.6 23.8 21.4 178.3 160z"],
    "shield-user": [512, 512, [], "e809", "M267.6 4.5l207.5 80.5 19.2 7.4 1.2 20.5c2.9 50-4.9 126.3-37.3 200.9-32.7 75.2-91.1 150-189.4 192.5l-12.7 5.5-12.7-5.5C144.9 463.9 86.6 389.1 53.9 313.9 21.5 239.3 13.7 162.9 16.6 113L17.8 92.5 37 85 244.5 4.5 256 0 267.6 4.5zM176 272l-32 96 224 0-32-96-160 0zm80-152a56 56 0 1 0 0 112 56 56 0 1 0 0-112z"],
    "tire-rugged": [512, 512, [], "f634", "M192 0l128 0 0 41.3c14.9 4.4 29.1 10.4 42.6 17.6l29.2-29.2 90.5 90.5-29.2 29.2c7.3 13.4 13.2 27.7 17.6 42.6l41.3 0 0 128-41.3 0c-4.4 14.9-10.4 29.1-17.6 42.6l29.2 29.2-90.5 90.5-29.2-29.2c-13.4 7.3-27.7 13.2-42.6 17.6l0 41.3-128 0 0-41.3c-14.9-4.4-29.1-10.4-42.6-17.6l-29.2 29.2-90.5-90.5 29.2-29.2c-7.3-13.4-13.2-27.7-17.6-42.6L0 320 0 192 41.3 192c4.4-14.9 10.4-29.1 17.6-42.6l-29.2-29.2 90.5-90.5 29.2 29.2c13.4-7.3 27.7-13.2 42.6-17.6L192 0zM384 256a128 128 0 1 0 -256 0 128 128 0 1 0 256 0zM232 192a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm88 88a24 24 0 1 1 0-48 24 24 0 1 1 0 48zm-64 64a24 24 0 1 1 0-48 24 24 0 1 1 0 48zm-88-88a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"],
    "wheat-awn-circle-exclamation": [640, 512, [], "e598", "M496 576a144 144 0 1 1 0-288 144 144 0 1 1 0 288zM177.4 282.7l6.1 6.7c19.7 23.8 26.3 55 19.2 83.9 31.7-7.7 66.2 1 90.6 25.3l12 12c-.8 7-1.2 14.2-1.2 21.4 0 20 3 39.3 8.7 57.4-36.8 21.8-85 16.9-116.6-14.7L165.7 444.3 81 529c-9.4 9.4-24.5 9.4-33.9 0-9.4-9.4-9.4-24.6 0-33.9l84.7-84.7-30.5-30.5c-37.5-37.5-37.5-98.3 0-135.8l18.8-18.7 57.4 57.4zM480 512l32 0 0-32-32 0 0 32zm0-64l32 0 0-112-32 0 0 112zM281.4 178.7l6.1 6.7c19.7 23.7 26.3 55 19.2 83.9 24.2-5.9 50.2-2.1 71.9 10.8-32.2 24.9-56.2 59.8-67.5 100.1-3.8-2.8-7.5-6-11-9.4l-94.9-94.9c-37.5-37.5-37.5-98.3 0-135.8l18.8-18.7 57.4 57.4zM577.6 32l-17 17-114.5 114.4c7.7 1 15.2 3 22.5 5.9 45.8-45.7 70.9-70.8 75.3-75.2l34 34-17 16.9-52.7 52.7 50.3 50.3-1.9 1.8c-19.1-6.4-39.5-9.8-60.7-9.8-34.2 0-66.2 8.9-94 24.6l-92.7-92.7c-37.5-37.5-37.5-98.3 0-135.8L328 17.4 378.3 67.7 448-1.9 482 32 465 49 406.7 107.2c2.8 7.1 4.7 14.5 5.8 22l114.3-114.2 17-17 33.9 34z"],
    "circle-l": [512, 512, [], "e114", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM224 168l0 152 112 0 0 48-160 0 0-224 48 0 0 24z"],
    "arrows-turn-right": [512, 512, [], "e4c0", "M368.3-29.3c7.1 7.1 38.2 38.2 93.3 93.3l2.7 0 0 2.7c1.8 1.8 11.5 11.5 29.3 29.3-17.8 17.8-27.5 27.5-29.3 29.3l0 2.7-2.7 0c-55.1 55.1-86.2 86.2-93.3 93.3L323 176c14.6-14.6 30.6-30.6 48-48l-274.7 0 0 128-64 0 0-192 338.7 0-48-48 45.3-45.3zm-96 256c7.1 7.1 38.2 38.2 93.3 93.3l2.7 0 0 2.7 29.3 29.3-29.3 29.3 0 2.7-2.7 0-93.3 93.3-45.3-45.3c14.6-14.6 30.6-30.6 48-48l-178.7 0 0 96-64 0 0-160 242.7 0c-17.4-17.4-33.4-33.4-48-48l45.3-45.3z"],
    "route-interstate": [512, 512, [], "f61b", "M273.2 12.9l-17-10.6-17 10.6c-29.7 18.6-53.7 28.5-78.3 32.6-24.8 4.1-52.6 2.8-90.5-4.8l-32.8-6.6-5.1 33.1c-16.2 105.3-17.4 193.1 14.5 266 32.6 74.4 96.8 127.1 196.9 168.5l12.9 5.4 12.7-5.9c97.3-44.9 161.1-97.3 194.1-170.4 32.5-71.9 32.3-158 16.1-263.6l-5.1-33.1-32.8 6.6c-37.9 7.6-65.7 8.9-90.5 4.8-24.6-4.1-48.6-14-78.3-32.6zM85.5 192l341.1 0c-.3 44.7-7 81.2-21.1 112.3-22.9 50.7-67.7 92.7-149.9 132.6-83.2-36.6-127.5-78.3-149.9-129.5-14-31.9-20.4-69.6-20.2-115.4z"],
    "candy-cane": [448, 512, [], "f786", "M421.8 39.6C452 85.2 456.5 142.9 435.1 192l-165.4 0 41.4-41.4c.8-.8 1.5-1.6 2.2-2.4L421.8 39.6zM268 103c-.8 .7-1.6 1.4-2.4 2.2-15.9 15.9-40.3 40.4-73.4 73.4L101.7 88 175 14.6C229.9-40.2 314.5-46.7 376.5-5.6L268 103zM125.7 336l80-80 181 0-80 80-181 0zm117 64C165.9 476.8 117 525.7 96.2 546.5L5.7 456c35.9-35.9 54.6-54.6 56-56l181 0z"],
    "circle-6": [512, 512, [], "e0f3", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm56-368l0 48-72 0c-13.3 0-24 10.7-24 24l0 12.1c7.5-2.7 15.6-4.1 24-4.1l32 0c39.8 0 72 32.2 72 72s-32.2 72-72 72l-32 0c-39.8 0-72-32.2-72-72l0-80c0-39.8 32.2-72 72-72l72 0zM240 320l32 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-32 0c-13.3 0-24 10.7-24 24s10.7 24 24 24z"],
    "citrus": [512, 512, [], "e2f4", "M288 112l0 16 96 0c53 0 96-43 96-96l0-32-96 0c-53 0-96 43-96 96l0 16zM244 96c0-23.1 5.6-44.8 15.4-64-1.1 0-2.3 0-3.4 0-132.5 0-240 107.5-240 240S123.5 512 256 512 496 404.5 496 272c0-45.2-12.5-87.5-34.2-123.6-22.2 14.9-49 23.6-77.8 23.6l-140 0 0-76z"],
    "wheelchair": [576, 512, [], "f193", "M280.5 40a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zM150.4 197.6c-68 18.5-117.9 80.6-117.9 154.4 0 88.4 71.6 160 160 160 71.6 0 132.3-47.1 152.7-112L290 400c-1 0-2.1 0-3.1 0l-4.1 0c-2.3 0-4.7-.1-7-.2-16.6 28.8-47.7 48.2-83.3 48.2-53 0-96-43-96-96 0-42.7 27.9-79 66.5-91.4l-12.6-63zM224.5 128l-39 0c1.9 9.5 13.4 67 34.5 172.6 6 29.9 32.2 51.4 62.8 51.4l13.1 0c.4 0 .8 0 1.3 0l97.2 0c31.7 84.6 48.7 129.9 51 136.1 40.6-13.5 104.6-34.9 107.6-35.9l-20.2-60.7c-22.2 7.4-38.5 12.8-49.1 16.4l-37.2-99.1-7.8-20.8-115.9 0-26.9-134.3-5.1-25.7-66.2 0z"],
    "expand-wide": [512, 512, [], "f320", "M32 64l-32 0 0 160 64 0 0-96 96 0 0-64-128 0zM64 320l0-32-64 0 0 160 160 0 0-64-96 0 0-64zM384 64l-32 0 0 64 96 0 0 96 64 0 0-160-128 0zM512 320l0-32-64 0 0 96-96 0 0 64 160 0 0-128z"],
    "spell-check": [640, 512, [], "f891", "M152.5 32c-48.6 0-88 39.4-88 88l0 200 64 0 0-96 64 0 0 96 64 0 0-200c0-48.6-39.4-88-88-88l-16 0zm40 128l-64 0 0-40c0-13.3 10.7-24 24-24l16 0c13.3 0 24 10.7 24 24l0 40zm144-128l-32 0 0 288 104 0c48.6 0 88-39.4 88-88 0-23.6-9.3-45-24.4-60.8 10.3-14.4 16.4-32.1 16.4-51.2 0-48.6-39.4-88-88-88l-64 0zm64 112l-32 0 0-48 32 0c13.3 0 24 10.7 24 24s-10.7 24-24 24zm-32 112l0-48 40 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-40 0zm233 84l20-25-50-40-20 25-105.7 132.1-61.3-61.3-45.3 45.3 86.6 86.6 25.3 25.3 22.3-27.9 128-160z"],
    "turn-down-right": [512, 512, [], "e455", "M512 256l-192-192 0 128-192 0 0-128-128 0 0 256 320 0 0 128 192-192z"],
    "volume-off": [320, 512, [], "f026", "M96 352l-96 0 0-192 96 0 192-152 0 496-192-152z"],
    "saxophone": [640, 512, [127927], "f8dc", "M246.7 176L171.4 306.1c-2.2 3.8-3.4 8.2-3.4 12.6l0 2.6c0 12.5 10.1 22.6 22.6 22.6 6 0 11.8-2.4 16-6.6L319 225 294.1 200 328 166.1c12.8 12.8 21.1 21.1 25 25L367 177c-3.8-3.8-12.2-12.2-25-25L376 118.1c12.8 12.8 21.1 21.1 25 25L415 129c-3.8-3.8-12.2-12.2-25-25L424 70.1c12.8 12.8 21.1 21.1 25 25l63-63 80 0 48 32 0 32-96 0-255.4 322.6C257.9 457.4 211.2 480 161.8 480 72.4 480 0 407.6 0 318.2l0-3.1c0-12.7 1.5-25.4 4.4-37.8l23.9-101.4-28.2 0 0-48 288 0 0 48-41.3 0zM120 320a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm8-72a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"],
    "sensor-triangle-exclamation": [640, 512, ["sensor-alert"], "e029", "M544 32l-448 0 0 448 125.3 0 210.7-368.7 112 196 0-275.3zM208 120l0 136-48 0 0-160 48 0 0 24zm96 0l0 136-48 0 0-160 48 0 0 24zM240 544.1l384 0-192-336-192 336zm208-208l0 96-32 0 0-112 32 0 0 16zm0 159.7l-32 0 0-32 32 0 0 32z"],
    "lungs": [576, 512, [129729], "f604", "M320 32l0-32-64 0 0 173.9-32 19.2 0-161.1-64 0C57 145.2 0 292.8 0 445.9l0 66.1 128 0 96-64 0-180.3 64-38.4 64 38.4 0 180.3 96 64 128 0 0-54.3c0-141.1-46.7-278.3-132.7-390.2l-27.3-35.5-64 0 0 161.1-32-19.2 0-141.9z"],
    "car-wrench": [512, 512, ["car-mechanic"], "f5e3", "M80.3 128C44.5 128 14.2 104.5 4 72l92.3 0 0-48-92.3 0c10.2-32.5 40.5-56 76.3-56 32.8 0 61 19.7 73.3 48L359 16c12.3-28.3 40.5-48 73.3-48 35.8 0 66.1 23.5 76.3 56l-92.3 0 0 48 92.3 0c-10.2 32.5-40.5 56-76.3 56-32.8 0-61-19.7-73.3-48L153.7 80c-12.3 28.3-40.5 48-73.3 48zm41.8 16l268.4 0 7.8 20.8 46.2 123.2 35.8 0 0 224-80 0 0-64-288 0 0 64-80 0 0-224 35.8 0 54-144zm224 64l-179.6 0-30 80 239.6 0-30-80zM128.3 400a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm288-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "popsicle": [320, 512, [], "e43e", "M160 0C71.6 0 0 71.6 0 160l0 224 128 0 0 128 64 0 0-128 128 0 0-224C320 71.6 248.4 0 160 0z"],
    "bookmark": [384, 512, [128278, 61591], "f02e", "M0 528L0 0 384 0 384 528 192 416 0 528z"],
    "barcode": [448, 512, [], "f02a", "M64 32l-64 0 0 448 64 0 0-448zm80 0l-48 0 0 448 48 0 0-448zm48 0l0 448 64 0 0-448-64 0zm208 0l0 448 48 0 0-448-48 0zm-96 0l0 448 48 0 0-448-48 0z"],
    "wheat-awn-slash": [576, 512, [], "e338", "M578.2 512.1L544.3 546-1.6 .1 32.3-33.8 578.2 512.1zM145.5 282.7l6.1 6.7c19.7 23.8 26.3 55 19.2 83.9 31.7-7.7 66.2 1 90.6 25.3L318.7 456 300 474.7c-37.5 37.5-98.3 37.5-135.8 0L133.8 444.3 49.1 529c-9.4 9.4-24.5 9.4-33.9 0-9.4-9.4-9.4-24.6 0-33.9l84.7-84.7-30.5-30.5c-37.5-37.5-37.5-98.3 0-135.8l18.8-18.7 57.4 57.4zM545.7 32l-17 17-114.5 114.4c7.7 1 15.3 3 22.5 5.9 45.8-45.7 70.9-70.8 75.3-75.2l34 34-17 16.9-52.7 52.7 50.3 50.3-18.7 18.7c-37.5 37.5-98.3 37.5-135.8 0l-94.9-94.9c-37.5-37.5-37.5-98.3 0-135.8l18.8-18.7 50.3 50.3 69.7-69.7 34 34-17 16.9-58.3 58.3c2.8 7.1 4.7 14.5 5.8 22l114.3-114.2 17-17 33.9 34z"],
    "list-ol": [576, 512, ["list-1-2", "list-numeric"], "f0cb", "M32.1 48l96 0 0 128 48 0 0 48-144 0 0-48 48 0 0-80-48 0 0-48zM62.5 301.2c11.4-8.6 25.3-13.2 39.6-13.2l4.9 0c33.7 0 61.1 27.4 61.1 61.1 0 19.6-9.4 37.9-25.2 49.4l-24 17.5 57.2 0 0 48-144 0 0-44.2 9.9-7.2 72.7-52.9c3.4-2.5 5.4-6.4 5.4-10.6 0-7.2-5.9-13.1-13.1-13.1l-4.9 0c-3.9 0-7.7 1.3-10.8 3.6l-40 30-28.8-38.4c12.5-9.4 25.9-19.4 40-30zM256.1 64l288 0 0 64-320 0 0-64 32 0zm0 160l288 0 0 64-320 0 0-64 32 0zm0 160l288 0 0 64-320 0 0-64 32 0z"],
    "typewriter": [448, 512, [], "f8e7", "M96 0l-32 0 0 144 64 0 0-80 146.7 0 45.3 45.3 0 34.7 64 0 0-61.3-73.4-73.4-9.4-9.4-205.3 0zM0 192l0 96 32 0 0 224 384 0 0-224 32 0 0-96-144 0-32 32-96 0-32-32-144 0zM104 352a24 24 0 1 1 0-48 24 24 0 1 1 0 48zm104-24a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm56 24a24 24 0 1 1 0-48 24 24 0 1 1 0 48zm104-24a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zM144 432a24 24 0 1 1 0-48 24 24 0 1 1 0 48zm104-24a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm56 24a24 24 0 1 1 0-48 24 24 0 1 1 0 48z"],
    "file-circle-xmark": [576, 512, [], "e5a1", "M272 0l-240 0 0 512 244 0c-22.7-31.5-36-70.2-36-112 0-100.6 77.4-183.2 176-191.3L416 144 272 0zm85.5 176L240 176 240 58.5 357.5 176zM432 544a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm55.3-176.7L454.6 400c25.4 25.3 40 40 44 44L476 466.6c-4-4-18.6-18.6-44-44-25.3 25.4-40 40-44 44L365.4 444c4-4 18.6-18.6 44-44-25.4-25.3-40-40-44-44L388 333.4c4 4 18.6 18.6 44 44 25.3-25.4 40-40 44-44l22.6 22.6-11.3 11.3z"],
    "inbox-out": [512, 512, [128228, "inbox-arrow-up"], "f311", "M423.5 96l24 192-79.5 0-32 64-160 0-32-64-79.5 0 24-192 335 0zM32 32l-32 256 0 192 512 0 0-192-32-256-448 0zM273 135l-17-17c-3.5 3.5-30.5 30.5-81 81l-17 17 33.9 33.9c10.3-10.3 23.6-23.6 40-40l0 110.1 48 0 0-110.1c16.4 16.4 29.7 29.7 40 40L353.9 216c-3.5-3.5-30.5-30.5-81-81z"],
    "cube": [512, 512, [], "f1b2", "M256.3-21l16 9.2 207.8 120 16 9.2 0 277-16 9.2-207.8 120-16 9.2-16-9.2-207.8-120-16-9.2 0-277 16-9.2 207.8-120 16-9.2zM432.2 357.5l0-166.1-143.8 83.1 0 166.1 143.8-83z"],
    "tape": [576, 512, [], "f4db", "M412.8 416c41.5-40.7 67.2-97.3 67.2-160 0-123.7-100.3-224-224-224S32 132.3 32 256 132.3 480 256 480l320 0 0-64-163.2 0zM256 160a96 96 0 1 1 0 192 96 96 0 1 1 0-192zm48 96a48 48 0 1 0 -96 0 48 48 0 1 0 96 0z"],
    "bomb": [576, 512, [128163], "f1e2", "M480 152l24-64 64-24-64-24-24-64-24 64-64 24 64 24 24 64zM366.6 97.4L344 74.7c-17 17-28.2 28.2-33.5 33.5-22-7.9-45.8-12.2-70.5-12.2-114.9 0-208 93.1-208 208s93.1 208 208 208 208-93.1 208-208c0-24.7-4.3-48.5-12.2-70.5 5.3-5.3 16.5-16.5 33.5-33.5-5.5-5.5-39.7-39.7-102.6-102.6zM240 208c-53 0-96 43-96 96l0 24-48 0 0-24c0-79.5 64.5-144 144-144l24 0 0 48-24 0z"],
    "camera-web": [448, 512, ["webcam"], "f832", "M64 224a160 160 0 1 1 320 0 160 160 0 1 1 -320 0zM248 446.7C360.4 434.8 448 339.6 448 224 448 100.3 347.7 0 224 0S0 100.3 0 224C0 339.6 87.6 434.8 200 446.7l0 33.3-104 0 0 48 256 0 0-48-104 0 0-33.3zM224 336a112 112 0 1 0 0-224 112 112 0 1 0 0 224z"],
    "lacrosse-stick": [576, 512, [], "e3b5", "M400-32c97.2 0 176 78.8 176 176 0 57.8-35.9 109-89.3 129.2l-10.9 3.6-11.5 3.3c-8.6 2.5-16.8 6.2-24.2 11l-7.2 5.2-34.9 27.9c-22.5 18-50.4 27.8-79.2 27.8-23.4 0-45.3-6.4-64.1-17.4L48 541.3 2.8 496 209.4 289.3c-11-18.8-17.4-40.7-17.4-64.1 0-28.8 9.8-56.7 27.8-79.2l27.9-34.9 5.2-7.2c4.9-7.5 8.6-15.6 11-24.2l3.3-11.5 3.6-10.9C291 3.9 342.2-32 400-32zm0 64c-31 0-58.5 19.3-69.3 47.9l-1.9 5.8-3.3 11.5c-4.9 17.2-12.8 33.3-23.2 47.8l-4.6 6.1-27.9 34.9c-8.9 11.1-13.8 25-13.8 39.2 0 34.7 28.1 62.7 62.7 62.8 14.3 0 28.1-4.8 39.2-13.8l34.9-27.9 6.1-4.6c14.4-10.4 30.6-18.3 47.8-23.2l11.5-3.3 5.8-1.9C492.7 202.5 512 175 512 144 512 82.1 461.9 32 400 32z"],
    "display-chart-up": [512, 512, [], "e5e3", "M64 96l0 256 384 0 0-256-384 0zM0 32l512 0 0 384-208 0 16 48 96 0 0 48-320 0 0-48 96 0 16-48-208 0 0-384zM312 144l104 0 0 128-48 0 0-46.1c-56.4 56.4-85.7 85.7-88 88-3.6-3.6-30.3-30.3-80-80-49.7 49.7-76.4 76.4-80 80L86.1 280c.8-.8 33.1-33.1 97-97l17-17c3.6 3.6 30.3 30.3 80 80l54.1-54.1-46.1 0 0-48 24 0z"],
    "trash-slash": [576, 512, [], "e2b3", "M49.3-16.9l-17-17-33.9 33.9 17 17 512 512 17 17 33.9-33.9-17-17-97.7-97.7 16.5-253.4-270 0-48-48 350 0 0-64-128 0-16-48-160 0-16 48-94 0-48.9-48.9zM97.6 167.3L120.1 512 442.3 512 97.6 167.3z"],
    "sd-cards": [448, 512, [], "e240", "M448 448l-352 0 0-368 112-112 240 0 0 480zM48 160l0 336 304 0 0 48-352 0 0-384 48 0zM288 56l0-24-48 0 0 96 48 0 0-72zm96 0l0-24-48 0 0 96 48 0 0-72z"],
    "scale-unbalanced": [640, 512, ["balance-scale-left"], "f515", "M388.9 39.3l113-37.7 20.2 60.7-125.9 42c-7 22-23.3 39.9-44.2 49l0 294.7 192 0 0 64-256 0 0-358.7c-5.1-2.2-9.9-5-14.4-8.2-107.9 36-163.1 54.4-165.9 55.3L87.5 139.8c4.9-1.6 55.9-18.6 153-51-.3-2.9-.5-5.8-.5-8.8 0-44.2 35.8-80 80-80 29.3 0 55 15.8 68.9 39.3zM112 224l46.5 0 6.7 12.9 88 168 2.7 5.2 0 47.8-7 7-40 40-7 7-147.9 0-7-7-40-40-7-7 0-47.8 2.7-5.2 88-168 6.7-12.9 14.5 0zM51.1 416l153.8 0-75.4-144-3 0-75.4 144zM481.5 96l61 0 6.7 12.9 88 168 2.7 5.2 0 47.8-7 7-40 40-7 7-147.9 0-7-7-40-40-7-7 0-47.8 2.7-5.2 88-168 6.7-12.9zm29 48l-75.4 144 153.8 0-75.4-144-3 0z"],
    "circle-malaysian-ringgit": [512, 512, [], "e6f9", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM120 160l54.7 0c37.6 0 68 30.4 68 68 0 24.1-12.5 45.2-31.4 57.3 12.7 22.2 22.5 39.4 29.5 51.6l-41.7 23.8c-5.7-10-18.1-31.6-37-64.7l-18.1 0 0 56-48 0 0-192 24 0zm54.7 88c11 0 20-9 20-20s-9-20-20-20l-30.7 0 0 40 30.7 0zM256 352l0-192 42.1 0c.8 1.2 13.5 19.3 37.9 54.1 24.4-34.9 37.1-52.9 37.9-54.1l42.1 0 0 192-48 0 0-99.9c-7 10-17.7 25.2-32 45.7-14.3-20.5-25-35.7-32-45.7l0 99.9-48 0z"],
    "book-circle-arrow-right": [576, 512, [], "e0bc", "M416 0l-384 0 0 512 244 0c-13.7-19-24-40.7-30-64l-150 0 0-32c0-17.7 14.3-32 32-32l112.7 0c8.1-98.6 90.7-176 191.3-176 16.6 0 32.7 2.1 48 6l0-214-64 0zM576 400a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zM440 321.4l11.3 11.3 56 56 11.3 11.3-11.3 11.3-56 56-11.3 11.3-22.6-22.6c4.6-4.6 18-18 40-40l-105.4 0 0-32 105.4 0c-22-22-35.4-35.4-40-40L440 321.4z"],
    "square-caret-left": [448, 512, ["caret-square-left"], "f191", "M0 32l0 448 448 0 0-448-448 0zM120 256l168-136 0 272-168-136z"],
    "ruler": [576, 512, [128207], "f545", "M175 550.2l-181-181 50.9-50.9c58.5 58.5 88.6 88.6 90.5 90.5l33.9-33.9c-1.9-1.9-32.1-32.1-90.5-90.5l33.9-33.9c39.6 39.6 62.2 62.2 67.9 67.9l33.9-33.9c-5.7-5.7-28.3-28.3-67.9-67.9l33.9-33.9c58.5 58.5 88.6 88.6 90.5 90.5L305.1 239c-1.9-1.9-32.1-32.1-90.5-90.5l33.9-33.9c39.6 39.6 62.2 62.2 67.9 67.9l33.9-33.9c-5.7-5.7-28.3-28.3-67.9-67.9l33.9-33.9c58.5 58.5 88.6 88.6 90.5 90.5l33.9-33.9c-1.9-1.9-32.1-32.1-90.5-90.5l50.9-50.9 181 181-407.3 407.3z"],
    "cards-blank": [576, 512, [], "e4df", "M544 512l-320 0 0-6.4 271.3-72.7-98.8-368.9 147.5 0 0 448zM436.6 399L127.5 481.8 11.5 49.1 320.6-33.8 436.6 399z"],
    "i": [320, 512, [105], "49", "M32 32l-32 0 0 64 128 0 0 320-128 0 0 64 320 0 0-64-128 0 0-320 128 0 0-64-288 0z"],
    "circle-norwegian-krone": [512, 512, [], "e738", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM176 128l0 126.1c43-43 67-67 72-72L281.9 216c-7.8 7.8-26.1 26.1-54.7 54.7l53.3 99-42.3 22.8c-3.6-6.7-19.1-35.5-46.5-86.3l-15.8 15.8 0 62.1-48 0 0-256 48 0zm160 78.2c9.6-4.1 20-6.2 30.6-6.2l33.4 0 0 48-33.4 0c-8.1 0-15.9 3.2-21.7 9s-9 13.5-9 21.7l0 105.4-48 0 0-192 48 0 0 14.2z"],
    "airplay": [512, 512, [], "e089", "M64 128l384 0 0 224-62.9 0c28.8 28.8 50.1 50.1 64 64l62.9 0 0-352-512 0 0 352 62.9 0c13.9-13.9 35.2-35.2 64-64L64 352 64 128zm2.7 352L445.3 480 256 290.7c-.2 .2-45.1 45.1-134.6 134.6L66.7 480z"],
    "volume-xmark": [576, 512, ["volume-mute", "volume-times"], "f6a9", "M0 352l96 0 192 152 0-496-192 152-96 0 0 192zM545.9 192L512 158.1c-6.3 6.3-27.6 27.6-64 64-36.4-36.4-57.7-57.7-64-64L350.1 192c6.3 6.3 27.6 27.6 64 64-36.4 36.4-57.7 57.7-64 64L384 353.9c6.3-6.3 27.6-27.6 64-64 36.4 36.4 57.7 57.7 64 64L545.9 320c-6.3-6.3-27.6-27.6-64-64 36.4-36.4 57.7-57.7 64-64z"],
    "archway": [512, 512, [], "f557", "M0 32l512 0 0 64-512 0 0-64zM0 416l32 0 0-272 448 0 0 272 32 0 0 64-160 0 0-128c0-53-43-96-96-96s-96 43-96 96l0 128-160 0 0-64z"],
    "person-digging": [640, 512, ["digging"], "f85e", "M352 40a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zm-67.3 88l-152.4 0-32.9 54.9c-17-8.5-32.3-16.2-46.1-23.1L31.8 202.7 53.3 213.5 402 387.8c-33 55-57.8 96.4-74.5 124.2l305 0c-8.2-13.7-49.9-83.2-125.1-208.5L480 257.8c-18.6 30.9-36.3 60.5-53.2 88.7l-92.9-46.4-47.1-164.9-2.1-7.2zM87.1 512l43.6-130.9 61.3 30.7 0 100.2 64 0 0-139.8-17.7-8.8c-87.8-43.9-136.2-68.1-145-72.5l-11.7 35-62 186.1 67.5 0z"],
    "gauge-high": [512, 512, [62461, "tachometer-alt", "tachometer-alt-fast"], "f625", "M0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zM288 96a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM256 416c35.3 0 64-28.7 64-64 0-16.2-6-31.1-16-42.3l69.5-138.9-42.9-21.5-69.5 138.9c-1.7-.1-3.4-.2-5.1-.2-35.3 0-64 28.7-64 64s28.7 64 64 64zM176 144a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM96 288a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm352-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "square-half": [448, 512, [], "e792", "M224 32l-224 0 0 448 224 0 0-448z"],
    "genderless": [384, 512, [], "f22d", "M192 128a128 128 0 1 1 0 256 128 128 0 1 1 0-256zm0 320a192 192 0 1 0 0-384 192 192 0 1 0 0 384z"],
    "clock-ten": [512, 512, [], "e354", "M256 0a256 256 0 1 1 0 512 256 256 0 1 1 0-512zM232 120l0 91.2c-45.6-30.4-71.8-47.9-78.7-52.4l-26.6 39.9c.6 .4 39.3 26.2 116 77.3l37.3 24.9 0-204.8-48 0 0 24z"],
    "wireless": [448, 512, [], "e7df", "M32 208c132.5 0 240 107.5 240 240l0 32-64 0 0-32c0-97.2-78.8-176-176-176l-32 0 0-64 32 0zM32 32c229.7 0 416 186.3 416 416l0 32-64 0 0-32C384 253.6 226.4 96 32 96L0 96 0 32 32 32zM82 465.9A48 48 0 1 1 14.1 398 48 48 0 1 1 82 465.9z"],
    "square-austral": [448, 512, [], "e726", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM204.5 144l39 0 6.3 14.3 43.3 97.7 58.9 0 0 32-44.7 0 10.6 24 34.1 0 0 32-19.9 0c6.6 14.9 13.1 29.7 19.6 44.2l-43.9 19.4c-5-11.3-14.4-32.6-28.2-63.7l-111.2 0c-13.8 31.1-23.2 52.3-28.2 63.7L96.3 388.2c6.5-14.6 13-29.3 19.6-44.2l-19.9 0 0-32 34.1 0 10.6-24-44.7 0 0-32 58.9 0 43.3-97.7 6.3-14.3zM224 218.5l-16.6 37.5 33.2 0-16.6-37.5zM182.6 312l82.8 0-10.6-24-61.6 0-10.6 24z"],
    "cloud-sun": [640, 512, [9925], "f6c4", "M490.9-26.4c1.1 5.5 8.3 41 21.5 106.4 65.4 13.2 100.9 20.4 106.4 21.5-3.1 4.7-23.1 34.9-60 90.5 36.9 55.6 56.9 85.8 60 90.5-9 1.8-37.5 7.6-85.4 17.3-11.9-8.7-25.1-15.6-39.3-20.4-2.5-12.7-6.8-24.7-12.7-35.7 9.5-14.9 15.1-32.6 15.1-51.7 0-53-43-96-96-96-47.9 0-87.6 35.1-94.8 80.9-26.5-20.3-59.5-32.5-95.4-32.9-10.4-15.6-19.8-29.8-28.2-42.5 5.5-1.1 41-8.3 106.4-21.5 13.2-65.4 20.4-100.9 21.5-106.4 4.7 3.1 34.8 23.1 90.5 60 55.6-36.9 85.8-56.9 90.5-60zM448.4 192c0 3.8-.4 7.5-1.3 11.1-21.7-17-49-27.1-78.7-27.1-4.6 0-9.1 .2-13.5 .7 6.4-19 24.4-32.7 45.5-32.7 26.5 0 48 21.5 48 48zm-320 320l-96 0 0-96c0-41.8 26.7-77.4 64-90.5l0-21.5c0-61.9 50.1-112 112-112 43.1 0 80.5 24.3 99.2 60 14.7-17.1 36.5-28 60.8-28 44.2 0 80 35.8 80 80l0 16c53 0 96 43 96 96l0 96-416 0z"],
    "arrow-right": [576, 512, [8594], "f061", "M534.9 278.6l22.6-22.6-22.6-22.6-160-160-22.6-22.6-45.3 45.3c1.3 1.3 44 44 128 128l-402.7 0 0 64 402.7 0c-84 84-126.7 126.7-128 128l45.3 45.3 22.6-22.6 160-160z"],
    "square-info": [448, 512, [8505, "info-square"], "f30f", "M448 32l-448 0 0 448 448 0 0-448zM184 336l24 0 0-64-48 0 0-48 96 0 0 112 32 0 0 48-128 0 0-48 24 0zm72-208l0 64-64 0 0-64 64 0z"],
    "handshake": [576, 512, [129309, 62662, "handshake-alt", "handshake-simple"], "f2b5", "M288 64l0 0 128 0 48 32 112-64 0 288-70.4 56C411.3 282.5 346.8 218.5 312 184l0 0-47.4 47.4c-21.5 21.5-52.1 28.2-79.3 20.1-.4-.1-.8-.2-1.1-.3-7-2.2-13.8-5.4-20.1-9.5-.4-.3-.9-.6-1.3-.9-3.9-2.7-7.7-5.8-11.2-9.4L144 224 288 64zM160 64l63.4 0c-90.8 100.9-139.4 154.8-145.6 161.7 25.6 25.6 38.8 38.8 39.6 39.6 50 50 131 50 181 0l13.6-13.6 157.9 156.6-41.3 34.4c-26.9-26.9-44.5-44.5-52.7-52.7L342.1 424c8.7 8.7 25.2 25.2 49.6 49.6l-7.7 6.4-62.1 0c-31.3-31.3-50.6-50.6-57.9-57.9L230.1 456c13 13 21 21 24 24L192 480 0 320 0 32 112 96 160 64z"],
    "cloud-question": [576, 512, [], "e492", "M144 480l432 0 0-128c0-47.4-25.7-88.7-64-110.9l0-49.1c0-53-43-96-96-96-17.7 0-34.2 4.8-48.4 13.1-24.1-45.8-72.2-77.1-127.6-77.1-79.5 0-144 64.5-144 144l0 24.2C40.1 220 0 273.3 0 336l0 144 144 0zM288 213.2c-17.7 0-32 14.3-32 32l-42.4 0c0-41.1 33.3-74.4 74.4-74.4s74.4 33.3 74.4 74.4c0 33.5-22.8 59-53.2 69.6l0 18.3-42.4 0 0-53.5 3.3-.5c21.1-3 49.9-7.1 49.9-34 0-17.7-14.3-32-32-32zM264 360l48 0 0 48-48 0 0-48z"],
    "person-skiing": [640, 512, [9975, "skiing"], "f7c9", "M448.4 56a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zM46.1 279.6l21.3 11.1 197.8 102.7 62.3-87.2-82-92.2c-11-12.4-16.2-27.5-16.2-42.4L340.9 225c40 45 62.8 70.6 68.3 76.9l-14.8 20.8-71.8 100.6 150 77.9c27.3-13.7 46.8-23.4 58.5-29.3l21.5 42.9c-9.9 4.9-33 16.5-69.5 34.7l-10.9 5.5-10.9-5.6-416-216-21.3-11.1 22.1-42.6zM135.3 49.6l18 8.7c6.1-12.1 11.4-22.7 15.9-31.8l28.6 14.3c-4.5 9.1-9.8 19.5-15.7 31.4l84.8 41 .4-.2c82-36.4 126-56 131.9-58.6 4.3 8.6 23 46.1 56.2 112.5 52.3 20.9 85.1 34 98.4 39.4l-23.8 59.4c-11.4-4.6-48-19.2-109.7-43.9l-11.3-4.5c-2.2-4.3-8.7-17.4-19.7-39.4-16.4 9.4-25.9 14.8-28.5 16.3l-7.6-3.7-185.6-89.6c-6.4 12.9-11.9 23.8-16.3 32.6L122.9 119.2 139 86.9c-12.3-5.9-22.9-11.1-32-15.5l13.9-28.8 14.4 7z"],
    "bridge-water": [640, 512, [], "e4ce", "M64.4 64l512 0 0 112c-37.6 9.4-64 43.2-64 82l0 101.4c-33.3-13.3-57.3-22.9-72-28.8l-24 9.6 0-52.2c0-53-43-96-96-96s-96 43-96 96l0 52.2-24-9.6c-14.7 5.9-38.7 15.5-72 28.8l0-101.4c0-38.8-26.4-72.6-64-82l0-112zM209.3 385.7l111.1 44.4 111.1-44.4 8.9-3.6 8.9 3.6 111.8 44.7c29.3-9.7 50.1-16.7 62.4-20.8l15.2 45.5-70.8 23.6-8.3 2.8-8.2-3.3-111.1-44.4-111.1 44.4-8.9 3.6-8.9-3.6-111.1-44.4-111.1 44.4-8.2 3.3-8.3-2.8C36.6 466.7 13 458.8 2 455.2l15.2-45.5c12.4 4.1 33.2 11.1 62.4 20.8l111.8-44.7 8.9-3.6 8.9 3.6z"],
    "building-ngo": [576, 512, [], "e4d7", "M448 0l-384 0 0 512 112 0 0-176 272 0 0-336zM160 96l64 0 0 64-64 0 0-64zm192 0l0 64-64 0 0-64 64 0zM160 224l64 0 0 64-64 0 0-64zm192 0l0 64-64 0 0-64 64 0zM520 380c-24.3 0-44 19.7-44 44l0 80c0 24.3 19.7 44 44 44l16 0c24.3 0 44-19.7 44-44l0-80c0-24.3-19.7-44-44-44l-16 0zm-4 44c0-2.2 1.8-4 4-4l16 0c2.2 0 4 1.8 4 4l0 80c0 2.2-1.8 4-4 4l-16 0c-2.2 0-4-1.8-4-4l0-80zm-168 0l0 80c0 24.3 19.7 44 44 44l16 0c24.3 0 44-19.7 44-44l0-44-48 0 0 40 8 0 0 4c0 2.2-1.8 4-4 4l-16 0c-2.2 0-4-1.8-4-4l0-80c0-2.2 1.8-4 4-4l16 0c2.2 0 4 1.8 4 4l0 8 40 0 0-8c0-24.3-19.7-44-44-44l-16 0c-24.3 0-44 19.7-44 44zM240 380l-20 0 0 168 40 0 0-59.2c15.8 37.2 24.2 56.9 25.2 59.2l38.8 0 0-168-40 0 0 63c-17.1-40.3-26.1-61.3-26.8-63L240 380z"],
    "moped": [576, 512, [], "e3b9", "M312 32l-24 0 0 48 76 0 26.5 146-82.5 110-84 0 0-144-96 0C57.3 192 0 249.3 0 320l0 64 40.4 0c-.2 2.6-.4 5.3-.4 8 0 48.6 39.4 88 88 88s88-39.4 88-88c0-2.7-.1-5.4-.4-8l116.4 0 7.2-9.6 96-128 6.3-8.4c-.1-.8-3.6-19.8-10.4-57l80.9 27 0-128-93.6 31.2C410 64.9 405.2 38.5 404 32l-92 0zM167.2 384c.5 2.6 .8 5.3 .8 8 0 22.1-17.9 40-40 40s-40-17.9-40-40c0-2.7 .3-5.4 .8-8l78.4 0zM64 112l0 48 160 0 0-48-160 0zM568 392a88 88 0 1 0 -176 0 88 88 0 1 0 176 0zm-88-40a40 40 0 1 1 0 80 40 40 0 1 1 0-80z"],
    "grid-round-2": [448, 512, [], "e5db", "M96 32a96 96 0 1 0 0 192 96 96 0 1 0 0-192zm0 256a96 96 0 1 0 0 192 96 96 0 1 0 0-192zM256 128a96 96 0 1 0 192 0 96 96 0 1 0 -192 0zm96 160a96 96 0 1 0 0 192 96 96 0 1 0 0-192z"],
    "igloo": [576, 512, [], "f7ae", "M320 33.8l0 126.2-271.5 0c51.7-77.2 139.6-128 239.5-128 10.8 0 21.5 .6 32 1.8zM368 160l0-116.7c66 19 122.2 61 159.5 116.7L368 160zM22.6 208l73.4 0 0 112-96 0c0-39.7 8-77.6 22.6-112zM176 320l-32 0 0-112 288 0 0 112-32 0 0 48 176 0 0 112-576 0 0-112 176 0 0-48zm304 0l0-112 73.4 0C568 242.4 576 280.3 576 320l-96 0zM352 432l0-144-128 0 0 144 128 0z"],
    "chess-knight-piece": [384, 512, ["chess-knight-alt"], "f442", "M208 0c88.4 0 160 71.6 160 160l0 144-64 96 64 64 0 48-352 0 0-48 64-64-16-80 128-96-48 0-12.1 12.1c-12.7 12.7-30 19.9-48 19.9l-4.6 0c-34.9 0-63.2-28.3-63.2-63.2 0-21 8.3-41.1 23.2-55.9L112 64 112 0 208 0zM176 104a24 24 0 1 0 0 48 24 24 0 1 0 0-48z"],
    "hand-holding-magic": [576, 512, [], "f6e5", "M176 0l-32 0 0 224 176 0 0-112-64 0 0 48-48 0 0-96 160 0 0 192 64 0 0-256-256 0zM137.4 313.4l-70.6 70.6-66.7 0 0 128 396.4 0 10.2-7c101.2-69.6 154.8-106.4 161-110.7l-45.3-65.9c-11.7 8.1-54.2 37.3-127.5 87.6l-138.8 0 0-48 128 0 0-64-237.3 0-9.4 9.4z"],
    "circle-dollar-to-slot": [576, 512, ["donate"], "f4b9", "M96 224a192 192 0 1 1 384 0 192 192 0 1 1 -384 0zM272 112l0 24c-28.8 .3-52 23.7-52 52.5 0 25.7 18.5 47.6 43.9 51.8l41.7 7c6 1 10.4 6.2 10.4 12.3 0 6.9-5.6 12.5-12.5 12.5l-75.5 0 0 40 44 0 0 24 40 0 0-24.7c25-4.1 44-25.7 44-51.8 0-25.7-18.5-47.6-43.9-51.8l-41.7-7c-6-1-10.4-6.2-10.4-12.3 0-6.9 5.6-12.5 12.5-12.5l67.5 0 0-40-28 0 0-24-40 0zM48 344l0 120 480 0 0-144 48 0 0 192-576 0 0-192 48 0 0 24z"],
    "user-tie-hair-mullet": [448, 512, [], "e7b9", "M144 144l0-32 64 0 16-48 16 48 64 0 0 32c0 44.2-35.8 80-80 80s-80-35.8-80-80zm208 0l0-32 16 0 0-48-26.8 0C323.2 26.2 284.7 0 240 0L208 0c-44.7 0-83.2 26.2-101.2 64l-26.8 0 0 48 16 0 0 32c0 25.1 7.3 48.6 19.8 68.4L80 272 368 272 332.2 212.4C344.7 192.6 352 169.1 352 144zM272 328l0-24-96 0 0 24 31.4 36.7-31.4 115.3-40-160-56 0-64 192 416 0-64-192-56 0-40 160-.6 0-31-115.1 31.6-36.9z"],
    "award-simple": [512, 512, [], "e0ab", "M256-40l53.4 32.6 62.6-1.5 30 54.9 54.9 30-1.5 62.6 32.6 53.4-32.6 53.4 1.5 62.6-54.9 30-18 33 0 173-128-64-128 64 0-173-18-33-54.9-30 1.5-62.6-32.6-53.4 32.6-53.4-1.5-62.6 54.9-30 30-54.9 62.6 1.5 53.4-32.6zm0 328a96 96 0 1 0 0-192 96 96 0 1 0 0 192z"],
    "conveyor-belt-boxes": [640, 512, ["conveyor-belt-alt"], "f46f", "M64 0l0 256 256 0 0-256-256 0zM96 320c-53 0-96 43-96 96s43 96 96 96l448 0c53 0 96-43 96-96s-43-96-96-96L96 320zm32 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm160 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm224-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM576 64l-192 0 0 192 192 0 0-192z"],
    "file-svg": [576, 512, [], "e64b", "M272 0l-240 0 0 512 144 0 0-176 240 0 0-192-144-144zm85.5 176L240 176 240 58.5 357.5 176zM272 380c-28.7 0-52 23.3-52 52s23.3 52 52 52c6.6 0 12 5.4 12 12s-5.4 12-12 12l-52 0 0 40 52 0c28.7 0 52-23.3 52-52s-23.3-52-52-52c-6.6 0-12-5.4-12-12s5.4-12 12-12l44 0 0-40-44 0zm116 20l0-20-40 0 0 55c0 21.6 3.9 43 11.5 63.2 10.7 28.5 16.9 45.1 18.7 49.8l43.7 0c1.8-4.7 8-21.3 18.7-49.8 7.6-20.2 11.5-41.6 11.5-63.2l0-55-40 0 0 55c0 16.8-3 33.4-8.9 49.2l-3.1 8.2-3.1-8.2C391 468.4 388 451.8 388 435l0-35zm88 24l0 80c0 24.3 19.7 44 44 44l16 0c24.3 0 44-19.7 44-44l0-44-48 0 0 40 8 0 0 4c0 2.2-1.8 4-4 4l-16 0c-2.2 0-4-1.8-4-4l0-80c0-2.2 1.8-4 4-4l16 0c2.2 0 4 1.8 4 4l0 8 40 0 0-8c0-24.3-19.7-44-44-44l-16 0c-24.3 0-44 19.7-44 44z"],
    "y": [384, 512, [121], "59", "M1.5 32l158.9 264.9 0 183.1 64 0 0-183.1 158.9-264.9-74.6 0-116.3 193.8-116.3-193.8-74.6 0z"],
    "face-smile-wink": [512, 512, [128521, "smile-wink"], "f4da", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm0-144c38.2 0 72-19.1 92.2-48.5l39.5 27.3C358.9 388.6 310.7 416 256 416s-102.9-27.4-131.8-69.2l39.5-27.3C184 348.9 217.8 368 256 368zM144 208a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm164 8l0 16-40 0 0-16c0-33.1 26.9-60 60-60l16 0c33.1 0 60 26.9 60 60l0 16-40 0 0-16c0-11-9-20-20-20l-16 0c-11 0-20 9-20 20z"],
    "circle-manat": [512, 512, [], "e6fb", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM240 104l32 0 0 25.1c58.7 7.8 104 58.1 104 118.9l0 120-48 0 0-120c0-34.3-23.9-62.9-56-70.2l0 190.2-32 0 0-190.2c-32.1 7.3-56 36-56 70.2l0 120-48 0 0-120c0-60.8 45.3-111.1 104-118.9l0-25.1z"],
    "dice-four": [448, 512, [9859], "f524", "M0 32l448 0 0 448-448 0 0-448zM160 160a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM128 384a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM352 160a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM320 384a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "file-minus": [384, 512, [], "f318", "M0 0L240 0 384 144 384 512 0 512 0 0zM208 58.5L208 176 325.5 176 208 58.5zM120 304l-24 0 0 48 192 0 0-48-168 0z"],
    "arrow-left-to-arc": [512, 512, [], "e616", "M64 256C64 150 150 64 256 64l32 0 0-64-32 0C114.6 0 0 114.6 0 256S114.6 512 256 512l32 0 0-64-32 0C150 448 64 362 64 256zM257.4 145.4c-69.6 69.6-106.4 106.4-110.6 110.6 4.2 4.2 41.1 41.1 110.6 110.6l22.6 22.6 45.3-45.3-56-56 242.7 0 0-64-242.7 0c24-24 42.7-42.7 56-56l-45.3-45.3-22.6 22.6z"],
    "car-tilt": [576, 512, [], "f5e5", "M80.8 88.7l21.4-5.7 216.4-58 21.4-5.7 12.9 18 76.5 107.1 34.6-9.3c40 149.4 46.9 175.2 58 216.4l-77.3 20.7-16.6-61.8-278.2 74.5 16.6 61.8-4.8 1.3 414.2 0 0 64-576 0 0-64 84.1 0C70.2 396 44.8 301.3 31.4 251.1l34.6-9.3 12.7-131 2.1-22.1zm232.9 3.8l-173.5 46.5-8.3 85 231.5-62-49.7-69.5zM153.1 334.4a32 32 0 1 0 -16.6-61.8 32 32 0 1 0 16.6 61.8zM423 229A32 32 0 1 0 361.2 245.5 32 32 0 1 0 423 229z"],
    "cloud-bolt-sun": [640, 512, ["thunderstorm-sun"], "f76e", "M284.9-40.8c-4 2.6-29.5 19.6-76.6 50.8-47.1-31.2-72.6-48.2-76.6-50.8-.9 4.7-7 34.7-18.2 90-55.4 11.2-85.4 17.3-90 18.2 2.6 4 19.6 29.5 50.8 76.6-31.2 47.1-48.2 72.6-50.8 76.6 4.8 1 34.5 7 88.9 18 .5-47.2 26.5-88.2 64.9-110 7.3-60.8 57.2-108.5 119.1-112.3-5.6-27.9-9.5-46.9-11.5-57.1zM608.2 320l0-96.1c0-47.6-34.6-87-80-94.6 0-52.8-42.6-97.3-96-97.3-34.9 0-65.4 18.6-82.2 46.4-13-9.1-28.8-14.4-45.8-14.4-44.2 0-80 35.8-80 80l0 17.6c-36.5 7.4-64 39.7-64 78.4l-.1 80.1 92.7 0 161.9-136 78.3 0-32.4 136 147.5 0zM336.7 400l-32.4 136 200-168-104.4 0 32.4-136-200 168 104.4 0z"],
    "face-grin-squint-tears": [576, 512, [129315, "grin-squint-tears"], "f586", "M560 40c0-30.9-25.1-56-56-56S448 9.1 448 40l0 56 56 0c30.9 0 56-25.1 56-56zM400 25.7C304.6-20.7 186.2-4.3 107 75S11.3 272.6 57.7 368l118.3 0 0 118.3c95.4 46.4 213.8 30 293-49.3s95.7-197.6 49.3-293L400 144 400 25.7zM417.8 201c5.8-11.1 21.4-12.4 26.6-1.1 27.5 59.2 16.8 131.8-32 180.6s-121.4 59.5-180.6 32c-11.3-5.3-10-20.8 1.1-26.6 36.4-19.1 72.7-45.6 106-78.9s59.8-69.6 78.9-106zM113.3 252.1l101.6-33.7 9.8-3.2 14.3 14.3-4.2 10.2-39.3 95.9-30.4-9.7 11.7-50.8-56.1 8-7.3-31zm137.2-69.3l33.7-101.6 31 7.3-8 56.1 50.8-11.7 9.7 30.4-95.9 39.3-10.2 4.2-14.3-14.3 3.2-9.8zM72 416c-30.9 0-56 25.1-56 56s25.1 56 56 56 56-25.1 56-56l0-56-56 0z"],
    "snowflakes": [640, 512, [], "f7cf", "M504-32l0 56 56 0 0 48-56 0 0 56-48 0 0-56-56 0 0-48 56 0 0-56 48 0zM256 64l0 67.7 9.9-9.9 28.3 28.3-38.1 38.1 0 44.3 38.4-22.1 14-52.1 38.6 10.4-3.6 13.5c21.2-12.2 40.7-23.5 58.6-33.9l32 55.4c-17.9 10.4-37.5 21.6-58.6 33.9l13.5 3.6-10.4 38.6-52.1-14-38.4 22.1 38.4 22.1 52.1-14 10.4 38.6-13.5 3.6c21.2 12.2 40.7 23.5 58.6 33.9l-32 55.4c-17.9-10.4-37.5-21.6-58.6-33.9l3.6 13.5-38.6 10.4-14-52.1-38.4-22.1 0 44.3 38.1 38.1-28.3 28.3-9.9-9.9 0 67.7-64 0 0-67.7-9.9 9.9-28.3-28.3 38.1-38.1 0-44.3-38.4 22.1-14 52.1-38.6-10.4 3.6-13.5C83.5 406.1 64 417.4 46 427.7L14 372.3c17.9-10.4 37.5-21.6 58.6-33.9l-13.5-3.6 10.4-38.6 52.1 14 38.4-22.1-38.4-22.1-52.1 14-10.4-38.6 13.5-3.6C51.5 225.4 32 214.1 14 203.7l32-55.4c17.9 10.4 37.5 21.6 58.6 33.9l-3.6-13.5 38.6-10.4 14 52.1 38.3 22.1 0-44.3-38.1-38.1 28.3-28.3 9.9 9.9 0-67.7 64 0zm328 96l0 32 56 0 0 48-56 0 0 56-48 0 0-56-56 0 0-48 56 0 0-56 48 0 0 24z"],
    "pretzel": [512, 512, [129384], "e441", "M138.6 32C62.1 32 0 94.1 0 170.6 0 253.3 40.9 326.5 103.7 371 89.9 390.5 75.2 411.5 59.5 433.7l65.4 46c14.4-20.5 31.6-45 51.7-73.5 21.8 6.4 44.9 9.8 68.7 9.8l21.2 0c23.9 0 46.9-3.4 68.7-9.8 20 28.5 37.3 53 51.7 73.4l65.4-46C436.8 411.4 422.1 390.5 408.3 371 471.1 326.5 512 253.3 512 170.6 512 94.1 449.9 32 373.4 32L364 32C321.4 32 283 50 256 78.8 229 50 190.6 32 148 32l-9.4 0zM216 180l0 7.4c0 15.5-4.8 30.7-13.7 43.4l-52.5 74.7c-42.2-30-69.7-79.2-69.7-134.9 0-32.4 26.2-58.6 58.6-58.6l9.4 0c37.6 0 68 30.4 68 68zm40 113.5L285.2 335c-6.1 .7-12.3 1-18.6 1l-21.2 0c-6.3 0-12.5-.3-18.6-1L256 293.5zm53.7-62.6C300.8 218.2 296 203 296 187.4l0-7.4c0-37.6 30.4-68 68-68l9.4 0c32.4 0 58.6 26.2 58.6 58.6 0 55.7-27.5 105-69.7 134.9l-52.5-74.7z"],
    "glass": [384, 512, [129371], "f804", "M74.2 128l-5-64 245.6 0-5 64-235.6 0zM40 512l304 0 35-448 5-64-384 0 40 512z"],
    "triple-chevrons-down": [384, 512, [], "e7f7", "M365.5 384l-173.3 173.3-173.2-173.3 45.2-45.3 128 128 128-128 45.3 45.3zm0-192l-173.3 173.3-173.2-173.3 45.2-45.2 128 128 128-128 45.3 45.2zm0-192L192.3 173.2 19 0 64.3-45.2 192.3 82.8 320.3-45.2 365.5 0z"],
    "file-audio": [384, 512, [], "f1c7", "M0 0L240 0 384 144 384 512 0 512 0 0zM208 58.5L208 176 325.5 176 208 58.5zm0 412.9c62.5-4.1 112-56.2 112-119.7S270.5 236.1 208 232l0 40.1c40.4 4 72 38.1 72 79.6s-31.6 75.6-72 79.6l0 40.1zm0-76.5c20.5-3.8 36-21.7 36-43.3s-15.5-39.5-36-43.3l0 86.5zM104 311.7l-40 0 0 80 40 0 32 40 24 0 0-160-24 0-32 40z"],
    "square-franc": [448, 512, [], "e72f", "M448 32l-448 0 0 448 448 0 0-448zM160 128l160 0 0 48-112 0 0 40 80 0 0 48-80 0 0 24 48 0 0 32-48 0 0 64-48 0 0-64-32 0 0-32 32 0 0-160z"],
    "arrows-down-to-line": [512, 512, [], "e4b8", "M150.6 374.6L128 397.3c-8.2-8.2-37.1-37.1-86.6-86.6L18.7 288 64 242.7c17.3 17.3 28 28 32 32L96 0 160 0 160 274.7c4-4 14.7-14.7 32-32L237.3 288c-8.2 8.2-37.1 37.1-86.6 86.6zm256 0L384 397.3 274.7 288 320 242.7c17.3 17.3 28 28 32 32l0-274.7 64 0 0 274.7c4-4 14.7-14.7 32-32l45.3 45.3-86.6 86.6zM32 512l-32 0 0-64 512 0 0 64-480 0z"],
    "mobile-slash": [576, 512, [], "e815", "M112.1 46l0-46 352 0 0 398 114.1 114.1-33.9 33.9-545.9-545.9 33.9-33.9 79.8 79.8zM442.3 512l-330.2 0 0-330.2 330.2 330.2zM224.1 464l102.3 0-48-48-54.3 0 0 48z"],
    "video-arrow-down-left": [576, 512, [], "e2c8", "M32 64l384 0 0 384-384 0 0-384zM464 341.3l0-170.7 112-74.7 0 320-112-74.7zM264 304l-54.1 0 103-103 17-17-33.9-33.9-17 17-103 103 0-78.1-48 0 0 160 160 0 0-48-24 0z"],
    "right-long-to-line": [640, 512, [], "e444", "M320 64l192 192-192 192 0-128-320 0 0-128 320 0 0-128zm320 64l0 288-64 0 0-320 64 0 0 32z"],
    "g": [448, 512, [103], "47", "M224 96C135.6 96 64 167.6 64 256s71.6 160 160 160c77.4 0 142-55 156.8-128l-156.8 0 0-64 224 0 0 32c0 123.7-100.3 224-224 224S0 379.7 0 256 100.3 32 224 32c70.8 0 134 32.9 175 84.1l-50 40C319.6 119.4 274.6 96 224 96z"],
    "vihara": [576, 512, [], "f6a7", "M288-14l14.4 10.8 153.6 115.2 40 0 0 48-48 0 0 48 58.7 64 37.3 0 0 48-32 0 0 48 24.4 32 39.6 0 0 48-64 0 0 64-64 0 0-64-128 0 0 64-64 0 0-64-128 0 0 64-64 0 0-64-64 0 0-48 46.1 0 17.9-32 0-48-32 0 0-48 37.3 0 58.7-64 0-48-48 0 0-48 40 0 153.6-115.2 14.4-10.8zM128 368l320 0 0-48-320 0 0 48zM384 160l-192 0 0 48 192 0 0-48z"],
    "flag-checkered": [448, 512, [127937], "f11e", "M64 0l0 48 69-17.2c38.1-9.5 78.3-5.1 113.5 12.5 43.2 21.6 93.4 23 137.6 4.4 3.2-1.4 6.4-2.8 9.6-4.4l54.4-27.2 0 352-55.5 20.8c-46.2 17.3-97.6 14.6-141.7-7.4-37.9-19-81.4-23.7-122.5-13.4L64 384 64 512 0 512 0 0 64 0zm0 187.1l64-13.9 0 65.5-64 13.9 0 65.5 48.8-12.2c5.1-1.3 10.1-2.4 15.2-3.3l0-63.9 38.9-8.4c8.3-1.8 16.7-2.5 25.1-2.1l0-64c13.6 .4 27.2 2.6 40.4 6.4l23.6 6.9 0 66.7-41.7-12.3c-7.3-2.1-14.8-3.4-22.3-3.8l0 71.4c21.8 1.9 43.3 6.7 64 14.4l0-69.8 22.7 6.7c13.5 4 27.3 6.4 41.3 7.4l0-64.2c-7.8-.8-15.6-2.3-23.2-4.5l-40.8-12 0-62c-13-3.8-25.8-8.8-38.2-15-8.2-4.1-16.9-7-25.8-8.8l0 72.4c-13-.4-26 .8-38.7 3.6l-25.3 5.5 0-75.2-64 16 0 73.1zM320 335.7c16.8 1.5 33.9-.7 50-6.8l14-5.2 0-71.7-7.9 1.8c-18.4 4.3-37.3 5.7-56.1 4.5l0 77.4zm64-149.4l0-70.8c-20.9 6.1-42.4 9.1-64 9.1l0 69.4c13.9 1.4 28 .5 41.7-2.6l22.3-5.2z"],
    "briefcase-arrow-right": [512, 512, [], "e2f2", "M144 0l224 0 0 96 144 0 0 384-512 0 0-384 144 0 0-96zM320 48l-128 0 0 48 128 0 0-48zm33 257l17-17c-2.1-2.1-31.8-31.8-89-89l-17-17-33.9 33.9c9 9 25 25 48 48l-126.1 0 0 48 126.1 0c-23 23-39 39-48 48L264 393.9c2.1-2.1 31.8-31.8 89-89z"],
    "heart-half-stroke": [512, 512, ["heart-half-alt"], "e1ac", "M256 107.8l-17.3-24c-23.6-32.6-61.8-51.9-102-51.9-74.9 0-136.7 60.8-136.7 135.7 0 151.6 255.6 328.1 256 328.3 0 0 256-176.6 256-328.3 0-74.9-61.7-135.7-136.7-135.7-27.9 0-54.8 9.3-76.5 25.8-9.6 7.3-18.2 16.1-25.5 26.1l-17.3 24zm0 109.2l69.2-95.7c11.4-15.8 30.2-25.4 50.2-25.4 40.2 0 72.7 32.7 72.7 71.7 0 20.7-9.1 48-30.1 81-20.4 32.3-48.8 64.8-78.9 94.4-26.2 25.9-54.1 50.1-83.1 72.9l0-199z"],
    "comment-captions": [512, 512, [], "e146", "M512 240c0 132.5-114.6 240-256 240-38.3 0-74.7-7.9-107.3-22.1L0 512 55.7 389.5C20.8 348.5 0 296.5 0 240 0 107.5 114.6 0 256 0S512 107.5 512 240zM120 208l-24 0 0 48 176 0 0-48-152 0zm224 0l-24 0 0 48 96 0 0-48-72 0zM120 304l-24 0 0 48 96 0 0-48-72 0zm144 0l-24 0 0 48 176 0 0-48-152 0z"],
    "gauge-simple": [512, 512, ["gauge-simple-med", "tachometer-average"], "f629", "M0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm320 96c0-26.9-16.5-49.9-40-59.3l0-196.7-48 0 0 196.7c-23.5 9.5-40 32.5-40 59.3 0 35.3 28.7 64 64 64s64-28.7 64-64z"],
    "shredder": [512, 512, [], "f68a", "M368 0l-304 0 0 144 384 0 0-64-80-80zM512 192l-512 0 0 192 64 0 0 128 48 0 0-128 64 0 0 128 48 0 0-128 64 0 0 128 48 0 0-128 64 0 0 128 48 0 0-128 64 0 0-192zM408 272a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"],
    "fondue-pot": [512, 512, [129749], "e40d", "M392.9 172.4l-13.3-8.9-19 28.5-38.5 0 30.8-46.2-13.3-8.9 91.2-136.9 53.3 35.5-91.2 136.9zM231.5 192l9.2-36.8-15.5-3.9 37.8-151.3 62.1 15.5-37.8 151.3-15.5-3.9-7.3 29.1-33 0zM0 224l64 0 0 96 32 0 0-64 32 0 0 32 32 0 0-64 352 0 0 64-64 0 0 32c0 52.3-25.1 98.8-64 128l0 64-64 0 0-35.2c-10.3 2.1-21 3.2-32 3.2l-128 0c-11 0-21.7-1.1-32-3.2l0 35.2-64 0 0-64C25.1 418.8 0 372.3 0 320l0-96z"],
    "right-left": [512, 512, ["exchange-alt"], "f362", "M512 128l-160-144 0 112-352 0 0 64 352 0 0 112 160-144zM160 528l0-112 352 0 0-64-352 0 0-112-160 144 160 144z"],
    "planet-ringed": [576, 512, [129680], "e020", "M63.5 379.1c11.2 20.4 25.5 39.7 42.7 57.1-.5 1-1 2-1.4 3.1 14.2-6.6 30.2-14.9 47.7-25.5-44.4-38.1-72.5-94.7-72.5-157.8 0-114.9 93.1-208 208-208 63.1 0 119.6 28.1 157.8 72.5 10.6-17.6 18.9-33.5 25.5-47.7-1 .5-2 .9-3.1 1.4-17.4-17.2-36.6-31.5-57.1-42.7 33.3-18.3 61.7-29.6 84.4-36.6 13.6-4.2 25.3-6.8 34.7-8.4 19.4-3.3 29.7-2.5 29.7-2.5s.9 10.3-2.5 29.7c-1.6 9.5-4.2 21.1-8.4 34.7-18 59-65.4 155.9-189.1 279.5S139.5 499.1 80.5 517.1c-13.6 4.2-25.3 6.8-34.7 8.4-19.4 3.3-29.7 2.5-29.7 2.5s-.9-10.3 2.5-29.7c1.6-9.5 4.2-21.1 8.4-34.7 6.9-22.7 18.3-51.1 36.6-84.4zM288 464c-3.4 0-6.7-.1-10-.2 35.8-27 74.6-60.5 116-101.8s74.8-80.1 101.8-116c.2 3.3 .2 6.7 .2 10 0 114.9-93.1 208-208 208z"],
    "pills": [512, 512, [], "f484", "M64 112c0-26.5 21.5-48 48-48s48 21.5 48 48l0 112-96 0 0-112zM176 368c0-48.7 18.1-93.2 48-127l0-129C224 50.1 173.9 0 112 0S0 50.1 0 112L0 400c0 61.9 50.1 112 112 112 37.3 0 70.3-18.2 90.7-46.3-17-28.6-26.7-62-26.7-97.7zm48 0c0 31.1 9.9 59.9 26.6 83.4L451.4 250.6c-23.5-16.8-52.3-26.6-83.4-26.6-79.5 0-144 64.5-144 144zm261.4-83.4L284.6 485.4c23.5 16.8 52.3 26.6 83.4 26.6 79.5 0 144-64.5 144-144 0-31.1-9.9-59.9-26.6-83.4z"],
    "explosion": [576, 512, [], "e4e9", "M312-32l-48 0 0 96 48 0 0-96zM144 368l-144-48 82.3 96 115.2 0c13.2-37.3 48.7-64 90.5-64s77.4 26.7 90.5 64l115.2 0 82.3-96-144 48 112-368-208 296-24-168-48 0-24 176-144-112 48 176zM24 464l-24 0 0 48 576 0 0-48-552 0z"],
    "arrows-down-to-people": [512, 512, [], "e4b9", "M96.4 169.9c-3.5-3.5-30.5-30.5-81-81l-17-17 33.9-33.9 40 40 0-110.1 48 0 0 110.1 40-40 33.9 33.9-81 81-17 17zm320 0c-3.5-3.5-30.5-30.5-81-81l-17-17 33.9-33.9c10.3 10.3 23.6 23.6 40 40l0-110.1 48 0 0 110.1c16.4-16.4 29.7-29.7 40-40L514.4 72c-3.5 3.5-30.5 30.5-81 81l-17 17zM256.4 192a56 56 0 1 1 0 112 56 56 0 1 1 0-112zm0 160c53 0 96 43 96 96l0 64-192 0 0-64c0-53 43-96 96-96zm-224-64a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm352 0a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm-304 80c15.3 0 29.6 4.3 41.8 11.8-6.3 16.2-9.8 33.8-9.8 52.2l0 80-112 0 0-64c0-44.2 35.8-80 80-80zm320 144l0-80c0-18.4-3.5-36-9.8-52.2 12.2-7.5 26.5-11.8 41.8-11.8 44.2 0 80 35.8 80 80l0 64-112 0z"],
    "users-viewfinder": [576, 512, [], "e595", "M0 0l0 160 48 0 0-112 112 0 0-48-160 0zM576 0l-160 0 0 48 112 0 0 112 48 0 0-160zM24 512l136 0 0-48-112 0 0-112-48 0 0 160 24 0zm552 0l0-160-48 0 0 112-112 0 0 48 160 0zM352 160a64 64 0 1 0 -128 0 64 64 0 1 0 128 0zm-176 0c0-16.8 3.7-32.8 10.4-47.2-3.4-.6-6.8-.8-10.4-.8-35.3 0-64 28.7-64 64s28.7 64 64 64c9.9 0 19.3-2.3 27.7-6.3-17.2-19.7-27.7-45.5-27.7-73.7zm224 80c35.3 0 64-28.7 64-64s-28.7-64-64-64c-3.5 0-7 .3-10.4 .8 6.7 14.3 10.4 30.3 10.4 47.2 0 28.2-10.4 54-27.7 73.7 8.4 4 17.8 6.3 27.7 6.3zM124.7 400l6.3-16.9 35.7-95.1-38.7 0-48 112 44.7 0zm326.5 0l44.7 0-48-112-38.7 0 35.7 95.1 6.3 16.9zM352 272l-128 0-48 128 224 0-48-128z"],
    "music-note": [384, 512, ["music-alt"], "f8cf", "M384-9l0 162c-2.9 .7-45.6 11.4-128 32l0 215c0 53-50.1 96-112 96s-112-43-112-96 50.1-96 112-96c17.2 0 33.5 3.3 48 9.2L192 39 216.2 33C316.3 7.9 372.2-6 384-9z"],
    "car-on": [512, 512, [], "e4dd", "M280.4-8l0 88-48 0 0-112 48 0 0 24zM122.3 144l268.4 0 7.8 20.8 46.2 123.2 35.8 0 0 224-80 0 0-64-288 0 0 64-80 0 0-224 35.8 0 54-144zm224 64l-179.6 0-30 80 239.6 0-30-80zM128.4 400a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm288-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM56.4-9.9l65 65 17 17-33.9 33.9c-6.1-6.1-27.8-27.8-65-65L22.5 24 56.4-9.9zm383 17l17-17 33.9 33.9c-6.1 6.1-27.8 27.8-65 65l-17 17-33.9-33.9c6.1-6.1 27.8-27.8 65-65z"],
    "circle-camera": [512, 512, ["camera-circle"], "e103", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM196 160l12-32 96 0 12 32 68 0 0 192-256 0 0-192 68 0zm108 96a48 48 0 1 0 -96 0 48 48 0 1 0 96 0z"],
    "sun-bright": [512, 512, ["sun-alt"], "e28f", "M232 488l0 24 48 0 0-104-48 0 0 80zm0-408l0 24 48 0 0-104-48 0 0 80zM92 58L58 92c7.5 7.5 26.4 26.4 56.6 56.6l17 17 33.9-33.9c-7.5-7.5-26.4-26.4-56.6-56.6L92 58zM380.5 346.5l-33.9 33.9 73.5 73.5 33.9-33.9-73.5-73.5zM0 232l0 48 104 0 0-48-104 0zm408 0l0 48 104 0 0-48-104 0zM58 420L92 454c7.5-7.5 26.4-26.4 56.6-56.6l17-17-33.9-33.9c-7.5 7.5-26.4 26.4-56.6 56.6L58 420zM346.5 131.5l33.9 33.9c7.5-7.5 26.4-26.4 56.6-56.6L454 91.9 420 58c-7.5 7.5-26.4 26.4-56.6 56.6l-17 17zM256 368a112 112 0 1 0 0-224 112 112 0 1 0 0 224z"],
    "battery-bolt": [640, 512, [], "f376", "M160 280l256-248-64.5 200 128.5 0-256 248 64.5-200-128.5 0zM96 64l218 0-66.1 64-151.9 0 0 256 108.5 0-20.6 64-151.9 0 0-384 64 0zM544 384l0-256-108.5 0 20.6-64 151.9 0 0 128 32 0 0 128-32 0 0 128-282 0 66.1-64 151.9 0z"],
    "mushroom": [512, 512, [127812], "e425", "M256 0C397.4 0 512 114.6 512 256l0 64-512 0 0-64C0 114.6 114.6 0 256 0zM182.4 368l147.2 0 22.4 112-192 0 22.4-112zM128 256a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm288-48a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM256 48c-41.6 0-80.3 12.2-112.8 33.2 12.6 27.6 40.5 46.8 72.8 46.8 42.9 0 77.9-33.8 79.9-76.2-12.9-2.5-26.3-3.8-39.9-3.8z"],
    "globe-wifi": [640, 512, [], "e685", "M304 400c0 27.1 5.6 52.8 15.7 76.2-7 10.2-13.8 18.5-20.1 24.8-5.4 5.4-9.3 8.2-11.6 9.7-2.3-1.5-6.2-4.3-11.6-9.7-11.7-11.7-25.3-30.4-38.3-55.4-23-44.3-41.5-103.2-45.3-165.5l153.4 0C319.8 312.9 304 354.6 304 400zM192.8 232c3.9-62.3 22.3-121.2 45.3-165.5 13-25 26.6-43.7 38.3-55.4 5.4-5.4 9.3-8.2 11.6-9.7 2.3 1.5 6.2 4.3 11.6 9.7 11.7 11.7 25.3 30.4 38.3 55.4 23 44.3 41.5 103.2 45.3 165.5l-190.5 0zm-48.1 0L33.1 232c9.8-105.6 83.7-192.5 182.4-221.6-35.2 52.1-66 133.6-70.9 221.6zM33.1 280l111.6 0c4.9 88 35.7 169.5 70.9 221.6-98.7-29.1-172.6-116-182.4-221.6zM496 208c-23 0-45.1 4.1-65.5 11.5-7-83.2-36.5-159.4-70-209.1 92.8 27.3 163.7 105.8 180 202.8-14.3-3.4-29.1-5.2-44.4-5.2zM352 400a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm256.5-20.4C584.1 343.6 542.8 320 496 320s-88.1 23.6-112.5 59.6l25.6 19.2C427.7 370.6 459.7 352 496 352s68.3 18.6 86.9 46.8l25.6-19.2zM496 384c-26.2 0-49.4 12.6-64 32l25.6 19.2c8.8-11.7 22.7-19.2 38.4-19.2s29.6 7.5 38.4 19.2L560 416c-14.6-19.4-37.8-32-64-32zm0 100a20 20 0 1 0 0-40 20 20 0 1 0 0 40z"],
    "arrow-rotate-left-10": [512, 512, [], "e836", "M64 86.7C110.9 33.6 179.5 0 256 0 397.4 0 512 114.6 512 256S397.4 512 256 512C155.9 512 69.2 454.5 27.2 370.9 46.3 361.3 65.3 351.7 84.3 342.2 116 405 181 448 256 448 362 448 448 362 448 256S362 64 256 64c-69.8 0-130.9 37.2-164.6 93.1l-.1 .2-.1 .2-32 51.4-59.2-16.9 0-192 64 0 0 86.7zM208 352l-48 0 0-129.2-18.7 9.4-21.5-42.9c11.7-5.9 31.2-15.6 58.5-29.3l29.7 0 0 192zM312 160c30.9 0 56 25.1 56 56l0 80c0 30.9-25.1 56-56 56l-16 0c-30.9 0-56-25.1-56-56l0-80c0-30.9 25.1-56 56-56l16 0zm-16 48c-4.4 0-8 3.6-8 8l0 80c0 4.4 3.6 8 8 8l16 0c4.4 0 8-3.6 8-8l0-80c0-4.4-3.6-8-8-8l-16 0z"],
    "sleigh": [640, 512, [], "f7cc", "M64 32l-32 0 0 64 32 0 0 160c0 41.8 26.7 77.4 64 90.5l0 69.5-96 0 0 48 528 0c44.2 0 80-35.8 80-80l0-32-48 0 0 32c0 17.7-14.3 32-32 32l-80 0 0-64c53 0 96-43 96-96l0-96 32 0 0-64-96 0 0 128-192 0-96-192-160 0zM432 416l-256 0 0-64 256 0 0 64z"],
    "arrow-down-left-and-arrow-up-right-to-center": [512, 512, [], "e092", "M381.4 176l121.4-121.4-45.3-45.3-121.4 121.4 0-82.7-64 0 0 192 192 0 0-64-82.7 0zM80.1 272l-32 0 0 64 82.7 0-121.4 121.4 45.3 45.3 121.4-121.4 0 82.7 64 0 0-192-160 0z"],
    "person-swimming-water": [640, 512, [], "e78b", "M552.4 120a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zM294.2 166.4l-84.1 72.1 17 6.8 93.1 37.2c92.7-37.1 144.2-57.7 154.3-61.7l-3.5-3.5-80-80-4.9-4.9-6.5-2.4-128-48-14.5-5.4-13.2 7.9C161.8 121.8 126 143.3 116.5 149l32.9 54.9c11.7-7 43.1-25.9 94.2-56.5l50.7 19zM200.4 286.2l-8.9 3.6-111.8 44.7c-29.3-9.7-50.1-16.7-62.4-20.8L2 359.2c11 3.7 34.6 11.5 70.8 23.6l8.3 2.8 8.2-3.3 111.1-44.4 111.1 44.4 8.9 3.6 8.9-3.6 111.1-44.4 111.1 44.4 8.2 3.3 8.3-2.8c36.2-12.1 59.8-19.9 70.8-23.6l-15.2-45.5c-12.4 4.1-33.2 11.1-62.4 20.8l-111.8-44.7-8.9-3.6-8.9 3.6-111.1 44.4-111.1-44.4-8.9-3.6zm8.9 99.6l-8.9-3.6-8.9 3.6-111.8 44.7c-29.3-9.8-50.1-16.7-62.4-20.8L2 455.2c11 3.7 34.6 11.5 70.8 23.6l8.3 2.8 8.2-3.3 111.1-44.4 111.1 44.4 8.9 3.6 8.9-3.6 111.1-44.4 111.1 44.4 8.2 3.3 8.3-2.8c36.2-12.1 59.8-19.9 70.8-23.6l-15.2-45.5c-12.4 4.1-33.2 11.1-62.4 20.8l-111.8-44.7-8.9-3.6-8.9 3.6-111.1 44.4-111.1-44.4z"],
    "dial-high": [576, 512, [], "e15c", "M320 0l0 64-64 0 0-64 64 0zM128 64l0 64-64 0 0-64 64 0zm384 0l0 64-64 0 0-64 64 0zm0 192l64 0 0 64-64 0 0-64zm0 192l0 64-64 0 0-64 64 0zM64 448l64 0 0 64-64 0 0-64zM0 256l64 0 0 64-64 0 0-64zM288.4 127.6c80.2 0 146.6 59 158.2 136l-182.2 0 0 48 182.2 0c-11.6 77-78 136-158.2 136-88.4 0-160-71.6-160-160s71.6-160 160-160z"],
    "dumbbell": [640, 512, [], "f44b", "M96 64l96 0 0 160 256 0 0-160 96 0 0 64 64 0 0 96 32 0 0 64-32 0 0 96-64 0 0 64-96 0 0-160-256 0 0 160-96 0 0-64-64 0 0-96-32 0 0-64 32 0 0-96 64 0 0-64z"],
    "baby-carriage": [512, 512, ["carriage-baby"], "f77d", "M64 208l0 176 384 0 0-208 64 0 0-48-112 0 0 80-336 0zm.2-48l223.8 0 0-160-56 0C141.9 0 68.4 70.9 64.2 160zM160 464a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zm288 0a48 48 0 1 0 -96 0 48 48 0 1 0 96 0z"],
    "clouds": [576, 512, [], "f744", "M416 160c-14 0-27.4 2.2-40 6.4-27.9-23.9-64.3-38.4-104-38.4-84.4 0-153.6 65.4-159.6 148.4-5.6 3.5-11 7.4-16 11.6L0 288 0 192c0-53 43-96 96-96l1.1 0c7.8-54.3 54.4-96 110.9-96 47.9 0 88.8 30.1 104.8 72.4 12-5.4 25.2-8.4 39.2-8.4 53 0 96 43 96 96 0 1.3 0 2.7-.1 4-10.2-2.6-20.9-4-31.9-4zM184 480l-88 0 0-88c0-40.3 27.1-74.2 64-84.7l0-19.3c0-61.9 50.1-112 112-112 39 0 73.3 19.9 93.3 50.1 13.8-11.3 31.4-18.1 50.7-18.1 44.2 0 80 35.8 80 80 0 .4 0 .9 0 1.3 45.4 7.6 80 47.1 80 94.7l0 96-392 0z"],
    "camera-cctv": [576, 512, ["cctv"], "f8ac", "M533 143.8l-436-158.7-98.5 270.6 153.8 56 0 8.3 0 104-72 0 0-48-48 0 0 144 48 0 0-48 120 0c0-.2 0-47.8 0-142.8L284.2 359.7 533 143.8zm-53.4 287l65.7-180.4-43.6-15.9-165.9 143.9 143.9 52.4z"],
    "buildings": [512, 512, [], "e0cc", "M512 0l-320 0 0 128-192 0 0 384 512 0 0-512zM96 320l64 0 0 64-64 0 0-64zm224 32l-64 0 0-64 64 0 0 64zm64 0l0-64 64 0 0 64-64 0zM160 224l0 64-64 0 0-64 64 0zM256 96l64 0 0 64-64 0 0-64zm192 0l0 64-64 0 0-64 64 0zM256 256l0-64 64 0 0 64-64 0zm192 0l-64 0 0-64 64 0 0 64z"],
    "rectangle-barcode": [512, 512, ["barcode-alt"], "f463", "M512 64l-512 0 0 384 512 0 0-384zM144 160l0 192-48 0 0-192 48 0zm32 0l32 0 0 192-32 0 0-192zm128 0l0 192-48 0 0-192 48 0zm16 0l32 0 0 192-32 0 0-192zm96 0l0 192-32 0 0-192 32 0z"],
    "truck-fire": [576, 512, [], "e65a", "M0 0l0 48 32 0 0 80-32 0 0 112 304 0 0-192 272 0 0-48-576 0zM0 288l0 160 67.3 0c10.4 36.9 44.4 64 84.7 64s74.2-27.1 84.7-64l102.6 0c10.4 36.9 44.4 64 84.7 64s74.2-27.1 84.7-64l67.3 0 0-320-96 0 0-32-64 0 0 32-64 0 0 160-352 0zM256 128l-64 0 0-80 64 0 0 80zM80 48l64 0 0 80-64 0 0-80zM416 288l0-96 96 0 0 96-96 0zM152 384a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm232 40a40 40 0 1 1 80 0 40 40 0 1 1 -80 0z"],
    "arrow-down-big-small": [512, 512, ["sort-size-down"], "f88c", "M288 32l224 0 0 224-224 0 0-224zm0 288l160 0 0 160-160 0 0-160zM150.6 470.6L128 493.3c-5.5-5.5-39.7-39.7-102.6-102.6L2.7 368 48 322.7c14.6 14.6 30.6 30.6 48 48l0-338.7 64 0 0 338.7c17.4-17.4 33.4-33.4 48-48L253.3 368c-5.5 5.5-39.7 39.7-102.6 102.6z"],
    "hand-love": [512, 512, [], "e1a5", "M192.1 0l0 352 224 0 0-288 64 0 0 272c0 97.2-78.8 176-176 176l-19.2 0c-59.6 0-116.9-22.9-160-64-75.6-72-117.4-111.8-125.4-119.5l55.2-57.9c16.7 15.9 41.2 39.3 73.5 70 0-1.5-.1-3.1-.1-4.6l0-336 64 0zm32 160l64 0 0 160-64 0 0-160zm160 32l0 128-64 0 0-128 64 0z"],
    "bag-shopping-minus": [448, 512, [], "e650", "M224 16c-35.3 0-64 28.7-64 64l0 48 128 0 0-48c0-35.3-28.7-64-64-64zM0 128l112 0 0-48c0-61.9 50.1-112 112-112S336 18.1 336 80l0 48 112 0 0 352-448 0 0-352zM152 284l-20 0 0 40 184 0 0-40-164 0z"],
    "clock-eleven-thirty": [512, 512, [], "e348", "M256 0a256 256 0 1 0 0 512 256 256 0 1 0 0-512zM232 392l0-128.7c-47.7-71.6-72.2-108.3-73.3-109.9l39.9-26.6c.4 .6 26.2 39.3 77.3 116l4 6 0 167.3-48 0 0-24z"],
    "slash-forward": [384, 512, [], "2f", "M363.8 20.1l-15.9 27.8-256 448-15.9 27.8-55.6-31.8 15.9-27.8 256-448 15.9-27.8 55.6 31.8z"],
    "pineapple": [512, 512, [], "e31f", "M512 96l-40 40 24 24-57.1 22.9 9.1 9.1 0 128-192 192-128 0-128-128 0-128 192-192 128 0 9.1 9.1 22.9-57.1 24 24 40-40 10 30 70-14-14 70 30 10zM176 201.4L153.4 224c4.1 4.1 18.5 18.5 43.3 43.3L208 278.6c4.1-4.1 18.5-18.5 43.3-43.3L262.6 224 240 201.4c-6 6-16.6 16.6-32 32-15.4-15.4-26-26-32-32zm-80 80L73.4 304c4.1 4.1 18.5 18.5 43.3 43.3L128 358.6c4.1-4.1 18.5-18.5 43.3-43.3L182.6 304 160 281.4c-6 6-16.6 16.6-32 32-15.4-15.4-26-26-32-32zm160 0L233.4 304c4.1 4.1 18.5 18.5 43.3 43.3L288 358.6c4.1-4.1 18.5-18.5 43.3-43.3L342.6 304 320 281.4c-6 6-16.6 16.6-32 32-15.3-15.4-26-26-32-32zm-80 80L153.4 384c4.1 4.1 18.5 18.5 43.3 43.3L208 438.6c4.1-4.1 18.5-18.5 43.3-43.3L262.6 384 240 361.4c-6 6-16.6 16.6-32 32-15.4-15.4-26-26-32-32z"],
    "face-persevering": [512, 512, [], "e385", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm-63.7-89.6l-42.4-22.5C170 361.9 210 336 256 336s86 25.9 106.1 63.9l-42.4 22.5C307.6 399.5 283.6 384 256 384s-51.6 15.5-63.7 38.4zm36-310.4c-10.6 10.6-17.7 17.7-21.5 21.5-24.2 24.2-55.3 40.2-89 45.8l-2.5 .4-19.7 3.3-6.6-39.5 19.7-3.3 2.5-.4c25.5-4.2 49-16.4 67.3-34.6L200 83.7 228.3 112zm69.6 14.1L283.7 112 312 83.7c10.6 10.6 17.7 17.7 21.5 21.5 18.3 18.3 41.8 30.4 67.3 34.6l2.5 .4 19.7 3.3-6.6 39.5-19.7-3.3-2.5-.4c-33.7-5.6-64.8-21.6-89-45.8l-7.4-7.4zM135.2 209.7l95.6 48 9.2 4.6 0 20.2-10.2 4.3-95.6 40-14.7-28.3 44.2-27.6-45.3-34 16.8-27.1zm146 48l95.6-48 16.8 27.1-45.3 34 44.2 27.6-14.7 28.3-95.6-40-10.2-4.3 0-20.2 9.2-4.6z"],
    "card-diamond": [384, 512, [], "e3ea", "M384 0L0 0 0 512 384 512 384 0zM80 256L192 144 304 256 192 368 80 256z"],
    "raccoon": [512, 512, [], "e613", "M288.4 0l-.4 .5 0-.5-73.9 0c-1 2-7.8 15.6-20.4 40.8l-3 5.9 2.1 6.3 15.3 45.8-28.5 35.1-3.6 4.4 0 57.6 11.4 3.4 77.7 23.3 46 30.7 4 2.7 41.7 0 4-2.7 46-30.7 77.7-23.3 11.4-3.4 0-57.6-3.6-4.4-28.5-35.1 15.3-45.8 2.1-6.3-3-5.9C465.7 15.7 458.9 2 457.9 0l-73.9 0 0 .5-.4-.5-95.2 0zm19 32l57.2 0c1.3 0 2.6 .1 3.9 .2l49.2 60.5-31.5-7.3c-20.2-4.7-39.7 4.2-50.2 19.9-10.5-15.7-30.1-24.6-50.2-19.9l-31.5 7.3 49.2-60.5c1.3-.1 2.6-.2 3.9-.2zm45.4 141.5l38.6 21-.2 .1-31.1 20.8c-.3-13-10.9-23.4-24-23.4s-23.7 10.4-24 23.4l-31.1-20.8-.2-.1 38.6-21c6.9-3.8 12.6-9.1 16.8-15.3 4.2 6.3 9.9 11.6 16.8 15.3zM288 112a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm80 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM182.4 231.2C130.1 269 96 330.5 96 400l0 16-32 0 0-16c0-16.4 1.7-32.5 4.8-48L0 352 0 400c0 61.9 50.1 112 112 112l208 0 0-16c0-26.5-21.5-48-48-48l-48 0 0-32 48 0c44.2 0 80 35.8 80 80l0 16 128 0 0-16.4c-.2-26.3-21.6-47.6-48-47.6l-16 0 0-72-19.2 14.4-19.2-25.6c1.1-.8 24.5-18.4 70.4-52.8l0-9.3c0-19.7-7.2-38.5-20.1-53l-7.3 2.2c-33 22-51.1 34-54.1 36.1l-61.1 0c-3.1-2-21.1-14.1-54.1-36.1l-68.9-20.7zM0 128l128 0 0-96-128 0 0 96zm0 32l0 64 128 0 0-64-128 0zM0 320l77.7 0c8.2-23.2 19.8-44.7 34.3-64L0 256 0 320zm480-24l-.2-.6 0 .7 .2-.2zM326 362.5l-16.5 27.4-13.7-8.2-80-48-13.7-8.2 16.5-27.4 13.7 8.2 80 48 13.7 8.2z"],
    "folder-bookmark": [512, 512, [], "e186", "M512 448l-512 0 0-416 224 0 64 48 224 0 0 368zM288 144l0 192 80-56 80 56 0-192-160 0z"],
    "key-skeleton-left-right": [640, 512, [], "e3b4", "M448 128a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zm-60 32c14.2 55.2 64.3 96 124 96 70.7 0 128-57.3 128-128S582.7 0 512 0C452.4 0 402.2 40.8 388 96L160 96c0 16 0 48 0 96l0 32 64 0 0-64 32 0 0 64 64 0 0-64 68 0zM192 384a64 64 0 1 1 -128 0 64 64 0 1 1 128 0zm60-32c-14.2-55.2-64.3-96-124-96-70.7 0-128 57.3-128 128S57.3 512 128 512c59.6 0 109.8-40.8 124-96l228 0c0-16 0-48 0-96l0-32-64 0c0 21.3 0 42.7 0 64l-32 0 0-64-64 0 0 64-68 0z"],
    "circle-i": [512, 512, [], "e111", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM184 144l168 0 0 48-72 0 0 128 72 0 0 48-192 0 0-48 72 0 0-128-72 0 0-48 24 0z"],
    "kiwi-bird": [576, 512, [], "f535", "M208 415.3c-5.3 .4-10.6 .7-16 .7-16.6 0-32.7-2.1-48-6l0 70-48 0 0-89.7C38.6 357.1 0 295.1 0 224 0 118 86 32 192 32 248.9 32 300 56.7 335.1 96L448 96c70.7 0 128 57.3 128 128l0 256-112-128-128.9 0c-21.3 23.8-48.4 42.2-79.1 53.1l0 74.9-48 0 0-64.7zM448 248a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"],
    "calendar-xmark": [448, 512, ["calendar-times"], "f273", "M160 0l0 64 128 0 0-64 64 0 0 64 96 0 0 416-448 0 0-416 96 0 0-64 64 0zM308.9 237.1l-33.9-33.9c-8.5 8.5-25.5 25.5-50.9 50.9-25.5-25.5-42.4-42.4-50.9-50.9l-33.9 33.9c8.5 8.5 25.5 25.5 50.9 50.9-25.5 25.5-42.4 42.4-50.9 50.9l33.9 33.9c8.5-8.5 25.5-25.5 50.9-50.9 25.5 25.5 42.4 42.4 50.9 50.9l33.9-33.9c-8.5-8.5-25.5-25.5-50.9-50.9 25.5-25.5 42.4-42.4 50.9-50.9z"],
    "circle-down": [512, 512, [61466, "arrow-alt-circle-down"], "f358", "M256 512a256 256 0 1 1 0-512 256 256 0 1 1 0 512zM128 256l0 8 128 128 128-128 0-8-80 0 0-128-96 0 0 128-80 0z"],
    "file-medical": [384, 512, [], "f477", "M0 0L240 0 384 144 384 512 0 512 0 0zM208 58.5L208 176 325.5 176 208 58.5zM160 264l0 56-56 0 0 64 56 0 0 56 64 0 0-56 56 0 0-64-56 0 0-56-64 0z"],
    "xmark": [448, 512, [128473, 10005, 10006, 10060, 215, "close", "multiply", "remove", "times"], "f00d", "M86.9 73.4L64.3 50.7 19 96 41.6 118.6 179 256 41.6 393.4 19 416 64.3 461.3 86.9 438.6 224.3 301.3 361.6 438.6 384.3 461.3 429.5 416 406.9 393.4 269.5 256 406.9 118.6 429.5 96 384.3 50.7 361.6 73.4 224.3 210.7 86.9 73.4z"],
    "shapes": [512, 512, ["triangle-circle-square"], "f61f", "M112 224l144-240 144 240-288 0zM16 384a112 112 0 1 1 224 0 112 112 0 1 1 -224 0zm272-96l192 0 0 192-192 0 0-192z"],
    "dice-one": [448, 512, [9856], "f525", "M448 32l-448 0 0 448 448 0 0-448zM224 224a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "knife-kitchen": [576, 512, [128298], "f6f5", "M480 0L568 88 448 208 448 272 392.5 315.2 278.6 201.4 480 0zM448 144a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm40-40a16 16 0 1 0 0-32 16 16 0 1 0 0 32zM0 480L256 224 400 368S272 512 112 512C48 512 0 480 0 480z"],
    "arrows-cross": [512, 512, [], "e0a2", "M86.9 41.4L64.3 18.7 19 64 41.6 86.6 177.1 222.1 222.3 176.8 86.9 41.4zM371 416l-82.7 0 0 64 192 0 0-192-64 0 0 82.7-80.8-80.8-45.3 45.3 80.8 80.8zM320.3 32l-32 0 0 64 82.7 0-329.4 329.4-22.6 22.6 45.3 45.3 22.6-22.6 329.4-329.4 0 82.7 64 0 0-192-160 0z"],
    "compass-slash": [576, 512, [], "f5e9", "M49.3-16.9l-17-17-33.9 33.9 17 17 512 512 17 17 33.9-33.9c-1.5-1.5-32.5-32.5-92.9-92.9 36.7-44.3 58.8-101.2 58.8-163.2 0-141.4-114.6-256-256-256-62 0-118.9 22.1-163.2 58.8L49.3-16.9zM242.7 176.6L416.1 128 367.6 301.4 242.7 176.6zM160.1 384L193.9 263.5 63.5 133.2c-20 36.5-31.3 78.3-31.3 122.8 0 141.4 114.6 256 256 256 44.5 0 86.4-11.4 122.8-31.3L280.6 350.3 160.1 384z"],
    "lock-open": [576, 512, [], "f3c1", "M384 96c0-35.3 28.7-64 64-64s64 28.7 64 64l0 64 64 0 0-64c0-70.7-57.3-128-128-128S320 25.3 320 96l0 64-224 0 0 352 384 0 0-352-96 0 0-64z"],
    "pepper-hot": [576, 512, [127798], "f816", "M545.4 65L513.3 97.1c19.6 26.5 31.2 59.4 31.2 94.9 0 52.3-25.1 98.8-64 128l0-96-128 0 0-128-96 0c29.2-38.9 75.7-64 128-64 35.5 0 68.3 11.6 94.9 31.2 24-23.9 40.3-40.3 49.1-49.1l33.9 33.9-17 17zm-281 79l40 0 0 128 128 0 0 40-157.4 110.2C221.3 459.8 157.2 480 91.6 480l-75.1 0 0-96 55 0c15.7 0 30.3-7.6 39.3-20.5L264.4 144z"],
    "droplet-slash": [576, 512, ["tint-slash"], "f5c7", "M49.3-16.9l-17-17-33.9 33.9 17 17 512 512 17 17 33.9-33.9-17-17-97.5-97.5c10.5-23.7 16.3-50 16.3-77.6 0-106-192-352-192-352S234.3 36.9 183.7 117.5L49.3-16.9zm84.9 220.7c-22.4 44.1-38 85.8-38 116.1 0 106 86 192 192 192 43.4 0 83.4-14.4 115.5-38.6L134.2 203.9z"],
    "droplet": [384, 512, [128167, "tint"], "f043", "M192 512C86 512 0 426 0 320S192-32 192-32 384 214 384 320 298 512 192 512zM64 312c0 75.1 60.9 136 136 136l0-48c-48.6 0-88-39.4-88-88l-48 0z"],
    "person-meditating": [448, 512, [], "e7e1", "M416 480l-384 0 0-96 192 38.4 192-38.4 0 96zM296.6 187.5l70.4 84.5 81 0 0 64-111 0c-4.1-4.9-15.1-18.1-33-39.6l0 69.2-80 16-80-16 0-69.2c-17.9 21.5-28.9 34.7-33 39.6l-111 0 0-64 81 0 70.4-84.5 9.6-11.5 126 0 9.6 11.5zM224 128a56 56 0 1 1 0-112 56 56 0 1 1 0 112z"],
    "file-lines": [384, 512, [128441, 128462, 61686, "file-alt", "file-text"], "f15c", "M0 0L240 0 384 144 384 512 0 512 0 0zM208 58.5L208 176 325.5 176 208 58.5zM120 256l-24 0 0 48 192 0 0-48-168 0zm0 96l-24 0 0 48 192 0 0-48-168 0z"],
    "comments-dollar": [576, 512, [], "f653", "M192 320c106 0 192-78.8 192-176S298-32 192-32 0 46.8 0 144c0 37.9 13.1 73.1 35.4 101.8L0 352 127 309.7c20.3 6.7 42.2 10.3 65 10.3zm3.2 48c16.4 81.9 94.7 144 188.8 144 27 0 52.8-5.1 76.1-14.4L576 544 540.6 437.8c22.3-28.7 35.4-63.9 35.4-101.8 0-82.4-61.7-151.5-145-170.7-11.5 115.8-115.8 201.2-235.8 202.7zM216 32l0 24 28 0 0 40-67.5 0c-6.9 0-12.5 5.6-12.5 12.5 0 6.1 4.4 11.3 10.4 12.3l41.7 7c25.3 4.2 43.9 26.1 43.9 51.8 0 26.1-19 47.7-44 51.8l0 24.7-40 0 0-24-44 0 0-40 75.5 0c6.9 0 12.5-5.6 12.5-12.5 0-6.1-4.4-11.3-10.4-12.3l-41.7-7c-25.3-4.2-43.9-26.1-43.9-51.8 0-28.8 23.2-52.2 52-52.5l0-24 40 0z"],
    "person-golfing": [512, 512, [], "e786", "M72.3-32L55-32c-1.9 5.7-9 27.2-21.5 64.4L23 64 105.6 64c2.8-8.4 8.1-24.4 16-48l202.9 0 49.5 98.9c-93 51.7-141.5 78.6-145.5 80.9 4.4 7.6 27.8 48.6 70.3 122.9l-106.4 159.5-17.8 26.6 53.3 35.5 17.8-26.6 103.4-155c-8.9 106.9-13.5 162.4-13.9 166.5l63.8 5.3 2.7-31.9 13.5-161.7c1.2-14.2-.8-28.4-5.8-41.7L369.9 190.4c47.2-26.2 76.8-42.6 88.7-49.3-3.3-6.6-24.1-48.3-62.5-125.1l4.2 0 0-48-328 0zm240 128a56 56 0 1 0 -112 0 56 56 0 1 0 112 0z"],
    "trash-check": [448, 512, [], "e2af", "M392 512l-336 0-24-368 384 0-24 368zM281.4 233.9L195.8 351.6c-19.3-20-33.7-34.9-43.2-44.7l-34.5 33.3c6.2 6.4 27.2 28.1 63.1 65.3l19.8 20.6 16.8-23.1 102.4-140.8 14.1-19.4-38.8-28.2-14.1 19.4zM320 32l128 0 0 64-448 0 0-64 128 0 16-48 160 0 16 48z"],
    "magnifying-glass-location": [576, 512, ["search-location"], "f689", "M448.3 208c0 45.9-14.9 88.3-40 122.7L534.9 457.4 557.5 480 512.3 525.3 489.6 502.6 363 376c-34.4 25.2-76.8 40-122.7 40-114.9 0-208-93.1-208-208s93.1-208 208-208 208 93.1 208 208zm-128-32c0-44.2-35.8-80-80-80s-80 35.8-80 80c0 64 80 144 80 144s80-80 80-144zm-112 0a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"],
    "floppy-disk-circle-arrow-right": [576, 512, ["save-circle-arrow-right"], "e180", "M64 32l-32 0 0 448 225.4 0c-9.3-20.3-15.2-42.5-16.9-65.9-27.9-6.9-48.5-32.1-48.5-62.1 0-35.3 28.7-64 64-64 6.3 0 12.4 .9 18.2 2.6 34.7-49.9 92.4-82.6 157.8-82.6 16.6 0 32.7 2.1 48 6l0-67.3-105.4-105.4-9.4-9.4-301.3 0zm64 64l224 0 0 128-224 0 0-128zM576 400a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zM440 321.4l11.3 11.3 56 56 11.3 11.3-11.3 11.3-56 56-11.3 11.3-22.6-22.6c4.6-4.6 18-18 40-40l-105.4 0 0-32 105.4 0c-22-22-35.4-35.4-40-40L440 321.4z"],
    "magnifying-glass-play": [576, 512, [], "e660", "M448.3 208c0 45.9-14.9 88.3-40 122.7L534.9 457.4 557.5 480 512.3 525.3 489.6 502.6 363 376c-34.4 25.2-76.8 40-122.7 40-114.9 0-208-93.1-208-208s93.1-208 208-208 208 93.1 208 208zM178.7 304l163.2-96-163.2-96 0 192z"],
    "file-invoice": [384, 512, [], "f570", "M240 0L0 0 0 512 384 512 384 144 240 0zm85.5 176L208 176 208 58.5 325.5 176zM64 416l0-128 256 0 0 128-256 0zM88 64l72 0 0 48-96 0 0-48 24 0zm0 96l72 0 0 48-96 0 0-48 24 0z"],
    "pentagon": [576, 512, [], "e790", "M306.9-9.9l-18.8-13.7-18.8 13.7-243.5 176.9-18.8 13.7 7.2 22.1 93 286.2 7.2 22.1 347.4 0 7.2-22.1 93-286.2 7.2-22.1-18.8-13.7-243.5-176.9z"],
    "phone-office": [512, 512, [], "f67d", "M0 32l512 0 0 448-352 0 0-384-160 0 0-64zM248 320a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm0 96a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM360 296a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM336 416a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM448 296a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM424 416a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM448 96l-224 0 0 96 224 0 0-96zM112 144l0 336-112 0 0-336 112 0z"],
    "tree-palm": [576, 512, [127796], "f82b", "M96 80l37.2 61.9c-4 3.5-8 7.2-12 11.2-79.2 79.2-56.6 169.7-22.6 203.6L248.4 206.9c4 10.8 7.8 26.2 9.7 47.2 4.2 46.5-1.6 116.8-32.7 216.4l-13 41.5 135.8 0 3.5-28c12.4-99-2.3-207.2-31.7-292l131.2 0 28.8-48 28.8 48 67.2 0C576 144 528 64 416 64 372.3 64 338.4 76.2 313.2 93.8 296.5 49.4 248 0 160 0 48 0 0 80 0 128L67.2 128 96 80z"],
    "onion": [448, 512, [129477], "e427", "M272 0l-96 0 0 15.1c0 2-.3 4.1-.8 6L117.7 229.3c-3.8 13.8-5.7 28.1-5.7 42.4 0 33.2 10.4 65.7 29.7 92.7l6.9 9.7 47.5 55.5 3.9 4.5 0 77.9 48 0 0-77.9 3.9-4.5 47.5-55.5 6.9-9.7c19.3-27 29.7-59.5 29.7-92.7 0-14.3-1.9-28.6-5.7-42.4L272.8 21.1c-.5-2-.8-4-.8-6L272 0zm8 453.1l0 58.9 48 0 0-72.2c68.3-25.9 120-79.1 120-159.8 0-64-44-102-88-140-9.5-8.2-19-16.4-28.1-24.9l29.2 105.7c4.6 16.6 6.9 33.7 6.9 50.9 0 39.9-12.5 78.8-35.7 111.3l-7.3 10.2-.4 .6-.5 .5-44.1 51.5 0 7.2zM88 140l0 0C44 178 0 216 0 280 0 360.7 51.7 414 120 439.8l0 72.2 48 0 0-66.1-44.1-51.5-.5-.5-.4-.6-7.3-10.2c-23.2-32.5-35.7-71.4-35.7-111.3 0-17.2 2.3-34.3 6.9-50.9l29.2-105.7C107 123.6 97.5 131.8 88 140z"],
    "value-absolute": [512, 512, [], "f6a6", "M64 64l-64 0 0 384 64 0 0-384zm118.6 73.4L160 114.7 114.7 160c6.6 6.6 38.6 38.6 96 96-57.4 57.4-89.4 89.4-96 96L160 397.3c6.6-6.6 38.6-38.6 96-96l96 96 45.3-45.3-96-96c57.4-57.4 89.4-89.4 96-96L352 114.7c-6.6 6.6-38.6 38.6-96 96l-73.4-73.4zM512 96l0-32-64 0 0 384 64 0 0-352z"],
    "republican": [640, 512, [], "f75e", "M0 192C0 103.6 71.6 32 160 32l224 0c88.4 0 160 71.6 160 160l0 64-544 0 0-64zm152-32a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm232 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM280 160a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM128 288l416 0 0 112c0 8.8 7.2 16 16 16s16-7.2 16-16l0-80 64 0 0 80c0 44.2-35.8 80-80 80s-80-35.8-80-80l0-48-32 0 0 128-128 0 0-96-192 0 0 96-128 0 0-192 128 0z"],
    "shop": [576, 512, ["store-alt"], "f54f", "M16 256l0-64 80-160 384 0 80 160 0 64-48 0 0 224-64 0 0-224-96 0 0 224-288 0 0-224-48 0zm112 0l0 128 160 0 0-128-160 0z"],
    "film": [448, 512, [127902, 62368, "film-alt", "film-simple"], "f008", "M0 32l448 0 0 448-448 0 0-448zM48 352l0 64 64 0 0-64-64 0zm352 0l-64 0 0 64 64 0 0-64zM48 224l0 64 64 0 0-64-64 0zm352 0l-64 0 0 64 64 0 0-64zM48 96l0 64 64 0 0-64-64 0zm352 0l-64 0 0 64 64 0 0-64z"],
    "washing-machine": [448, 512, ["washer"], "f898", "M0 0L448 0 448 512 0 512 0 0zM368 304a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zM96 120a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM216 96a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm8 304c-53 0-96-43-96-96 0-17.5 4.7-33.8 12.8-48 1.1 0 2.1 0 3.2 0 64 0 96 64 160 64 5 0 10-.2 14.8-.6-7.4 45.7-47 80.6-94.8 80.6z"],
    "building-circle-xmark": [576, 512, [], "e4d4", "M416 0l-384 0 0 512 244 0c-10.5-14.6-19-30.7-25.1-48l-74.9 0 0-112 70 0c6-23.3 16.3-45 30-64l-20 0 0-64 64 0 0 20c27.5-19.8 60.3-32.4 96-35.4L416 0zM128 96l64 0 0 64-64 0 0-64zm192 0l0 64-64 0 0-64 64 0zM128 224l64 0 0 64-64 0 0-64zM432 544a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm55.3-176.7L454.6 400c25.4 25.3 40 40 44 44L476 466.6c-4-4-18.6-18.6-44-44-25.3 25.4-40 40-44 44L365.4 444c4-4 18.6-18.6 44-44-25.4-25.3-40-40-44-44L388 333.4c4 4 18.6 18.6 44 44 25.3-25.4 40-40 44-44l22.6 22.6-11.3 11.3z"],
    "comments": [576, 512, [128490, 61670], "f086", "M384 144c0 97.2-86 176-192 176-22.8 0-44.7-3.6-65-10.3L0 352 35.4 245.8C13.1 217.1 0 181.9 0 144 0 46.8 86-32 192-32S384 46.8 384 144zm0 368c-94.1 0-172.4-62.1-188.8-144 120-1.5 224.3-86.9 235.8-202.7 83.3 19.2 145 88.3 145 170.7 0 37.9-13.1 73.1-35.4 101.8L576 544 460.1 497.6C436.8 506.9 411 512 384 512z"],
    "tags": [640, 512, [], "f02c", "M433.4 39.1l181.6 184 16.6 16.9-16.7 16.9-189.7 192-16.9 17.1-34.1-33.7 16.9-17.1 173.1-175.1-164.9-167.1-16.9-17.1 34.2-33.7 16.9 17.1zM64.3 256l0-224 224 0 208 208-224 224-208-208zm144-112a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "file-spreadsheet": [384, 512, [], "f65b", "M0 0L240 0 384 144 384 512 0 512 0 0zM208 58.5L208 176 325.5 176 208 58.5zM88 228l-20 0 0 216 248 0 0-216-228 0zm20 176l0-48 64 0 0 48-64 0zm104 0l0-48 64 0 0 48-64 0zm0-88l0-48 64 0 0 48-64 0zm-40-48l0 48-64 0 0-48 64 0z"],
    "gun": [576, 512, [], "e19b", "M528 32l0 32 48 0 0 144-96 0-32 32-47.1 0-34.3 96.1-5.7 15.9-136.9 0-32 128-160 0 60-240-92 0 0-176 480 0 0-32 48 0zM327.1 304l22.9-64-97.9 0-16 64 91.1 0zM480 128l-416 0 0 32 416 0 0-32z"],
    "nesting-dolls": [640, 512, [], "e3ba", "M307.2 272C295 296 288 323.2 288 352l0 70.8-35.7 89.2-144.3 0c-27.6-30.9-44-77.8-44-120s16.4-89.1 44-120l199.2 0zM464 224c70.7 0 128 57.3 128 128l0 80 32 80-320 0 32-80 0-80c0-70.7 57.3-128 128-128zM432 352l-46.4 0c-1 5.2-1.6 10.5-1.6 16 0 44.2 35.8 80 80 80s80-35.8 80-80c0-5.5-.5-10.8-1.6-16l-46.4 0-32-32-32 32zM256 0c70.7 0 128 57.3 128 128l0 67.2c-14.9 7.6-28.6 17.4-40.7 28.8l-215.3 0 0-96C128 57.3 185.3 0 256 0zM224 112l-48 0 .4 8.2c4.1 40.3 38.2 71.8 79.6 71.8 44.2 0 80-35.8 80-80l-48 0-32-32-32 32z"],
    "dial": [576, 512, ["dial-med-high"], "e15b", "M320 0l0 64-64 0 0-64 64 0zM128 64l0 64-64 0 0-64 64 0zm384 0l0 64-64 0 0-64 64 0zm0 192l64 0 0 64-64 0 0-64zm0 192l0 64-64 0 0-64 64 0zM64 448l64 0 0 64-64 0 0-64zM0 256l64 0 0 64-64 0 0-64zm175.1-81.8c56.7-56.7 145.4-62 208-15.7l-111.9 111.9-17 17 33.9 33.9 17-17 111.9-111.9c46.2 62.6 41 151.3-15.7 208-62.5 62.5-163.8 62.5-226.3 0s-62.5-163.8 0-226.3z"],
    "truck-flatbed": [576, 512, [], "e2b6", "M416 160l0 96 88.4 0-48-96-40.4 0zm-64 96l0-160 144 0 80 160 0 160-67.3 0c-10.4 36.9-44.4 64-84.7 64s-74.2-27.1-84.7-64l-102.6 0c-10.4 36.9-44.4 64-84.7 64s-74.2-27.1-84.7-64L0 416 0 256 352 256zM192 392a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zm232 40a40 40 0 1 0 0-80 40 40 0 1 0 0 80z"],
    "pen-nib-slash": [576, 512, [], "e4a1", "M49.3-16.9l-17-17-33.9 33.9 17 17 512 512 17 17 33.9-33.9-17-17-152.6-152.6 37-111-133-133-111 37-152.4-152.4zM271 340.7c-8.4 7-19.1 11.3-30.9 11.3-4.3 0-8.5-.6-12.4-1.6L81.1 497 96.1 512 355.8 425.5 271 340.7zM118.7 188.4L32.1 448 47.2 463 193.8 316.4c-1.1-4-1.6-8.1-1.6-12.4 0-11.8 4.2-22.6 11.3-30.9l-84.7-84.7zM349.1 67l128 128 99-99-128-128-99 99z"],
    "circle-check": [512, 512, [61533, "check-circle"], "f058", "M256 512a256 256 0 1 1 0-512 256 256 0 1 1 0 512zm84.5-361l-119.4 164.2-69.1-69.1-33.9 33.9 88.9 88.9 19.8 19.9 16.5-22.7 135.9-186.9 14.1-19.4-38.8-28.3-14.1 19.4z"],
    "house-tree": [640, 512, [], "e1b3", "M640 464l-80-112 48 0 0-48-80-112 48 0 0-48-160-144-103.2 92.9 183.2 148 0 110.9-32 0 0 160.2 176 0 0-48zM416 304l32 0 0-40-208-168-208 168 0 40 32 0 0 208 352 0 0-208zM288 272l0 96-96 0 0-96 96 0z"],
    "user-pilot": [448, 512, [], "e2c0", "M48 48l0-32 176-48 176 48 0 32-32 19.2 0 44.8s-5.8 2.8-16 6.7l0 25.3c0 70.7-57.3 128-128 128S96 214.7 96 144l0-25.3c-10.2-3.9-16-6.7-16-6.7L80 67.2 48 48zm176 96c-29.1 0-56.8-4.6-80-10.3l0 10.3c0 44.2 35.8 80 80 80s80-35.8 80-80l0-10.3c-23.2 5.7-50.9 10.3-80 10.3zm0 240l64-64 80 0 64 192-416 0 64-192 80 0 64 64zM168.8 26.5L154.5 55.2c3.9 2 24.7 12.3 62.3 31.2l7.2 3.6 7.2-3.6c37.6-18.8 58.4-29.2 62.3-31.2L279.2 26.5c-5.1 2.6-23.5 11.8-55.2 27.6-31.6-15.8-50-25-55.2-27.6zM304 416l-16 0 0 32 64 0 0-32-48 0z"],
    "bracket-square": [192, 512, ["bracket", "bracket-left"], "5b", "M0 32l160 0 0 64-96 0 0 320 96 0 0 64-160 0 0-448z"],
    "user-pilot-hair-long": [448, 512, [], "e7b3", "M48 16l0 32 32 19.2 0 44.8s5.8 2.8 16 6.7l0 57.3-48 96 352 0-48-96 0-57.3c10.2-3.9 16-6.7 16-6.7l0-44.8 32-19.2 0-32-176-48-176 48zm96 117.7c23.2 5.7 50.9 10.3 80 10.3s56.8-4.6 80-10.3l0 10.3c0 44.2-35.8 80-80 80s-80-35.8-80-80l0-10.3zM160 320l-80 0-64 192 416 0-64-192-80 0-64 64-64-64zm8.8-293.5c5.1 2.6 23.5 11.8 55.2 27.6 31.7-15.8 50-25 55.2-27.6l14.3 28.6c-3.9 2-24.7 12.4-62.3 31.2l-7.2 3.6-7.2-3.6c-37.6-18.8-58.4-29.2-62.3-31.2l14.3-28.6zM304 416l48 0 0 32-64 0 0-32 16 0z"],
    "id-card-clip": [576, 512, ["id-card-alt"], "f47f", "M352-32l0 96-128 0 0-96 128 0zM0 32l176 0 0 80 224 0 0-80 176 0 0 448-576 0 0-448zM400 416l-32-96-160 0-32 96 224 0zM288 280a56 56 0 1 0 0-112 56 56 0 1 0 0 112z"],
    "moon": [512, 512, [127769, 9214], "f186", "M359.7 21.9C272.6 43.5 208 122.2 208 216 208 326.4 297.5 416 408 416 426.5 416 444.4 413.5 461.4 408.8 414.8 471.4 340.1 512 256 512 114.6 512 0 397.4 0 256S114.6 0 256 0c36.9 0 72 7.8 103.7 21.9z"],
    "caret-large-up": [448, 512, [], "e82f", "M8 352L224 120 440 352 8 352z"],
    "lamp": [448, 512, [], "f4ca", "M96 32L0 288 448 288 352 32 96 32zm0 384c0 38.2 16.8 72.5 43.3 96l169.3 0c26.6-23.5 43.3-57.8 43.3-96 0-30.3-10.5-58.1-28.1-80l-199.9 0C106.5 357.9 96 385.7 96 416z"],
    "mobile-arrow-down": [384, 512, [], "e74b", "M16 0l352 0 0 512-352 0 0-512zM128 416l0 48 128 0 0-48-128 0zm81-119c57.2-57.2 86.8-86.8 89-89L264 174.1c-9 9-25 25-48 48l0-126.1-48 0 0 126.1-48-48-33.9 33.9c2.1 2.1 31.8 31.8 89 89l17 17 17-17z"],
    "file-plus": [384, 512, [], "f319", "M0 0L240 0 384 144 384 512 0 512 0 0zM208 58.5L208 176 325.5 176 208 58.5zM168 432l48 0 0-72 72 0 0-48-72 0 0-72-48 0 0 72-72 0 0 48 72 0 0 72z"],
    "image-user": [448, 512, [], "e1b8", "M0 32l448 0 0 448-448 0 0-448zM336 384l-32-96-160 0-32 96 224 0zM224 248a56 56 0 1 0 0-112 56 56 0 1 0 0 112z"],
    "turn-right": [512, 512, [], "e639", "M512 256l-192 192 0-128-192 0 0 128-128 0 0-256 320 0 0-128 192 192z"],
    "hexagon-vertical-nft": [512, 512, [58630, "hexagon-vertical-nft-slanted"], "e505", "M257 531.5l-11.9-6.8-216.1-123.7-12.1-6.9 0-275.1 12.1-6.9 216.1-123.7 11.9-6.8 11.9 6.8 216.1 123.7 12.1 6.9 0 275.1-12.1 6.9-216.1 123.7-11.9 6.8zM112 172l-20 0 0 168 40 0 0-59.2c15.8 37.2 24.2 56.9 25.2 59.2l38.8 0 0-168-40 0 0 63c-17.1-40.3-26.1-61.3-26.8-63L112 172zm108 0l0 168 40 0 0-64 48 0 0-40-48 0 0-24 48 0 0-40-88 0zm116 0l-20 0 0 40 32 0 0 128 40 0 0-128 32 0 0-40-84 0z"],
    "skull-cow": [640, 512, [], "f8de", "M0 95.5C0 166.1 57.2 224 128 224l0-96-23 0c-28.7 0-52.7-21.7-55.6-50.3-1.6-16 5.3-35.5 11.1-51.8 1.2-3.4 2.4-6.7 3.4-9.9L40 0C19 26.2 0 61 0 95.5zM512 224c70.8 0 128-57.9 128-128.5 0-34.5-19-69.3-40-95.5L576 16c1 3.1 2.2 6.4 3.4 9.9l0 0c5.8 16.4 12.7 35.8 11.1 51.8-2.9 28.6-26.9 50.3-55.6 50.3l-23 0 0 96zM480 96l-320 0 0 272 60 0 36 144 128 0 36-144 60 0 0-272zM224 256a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm160-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "oil-well": [576, 512, [], "e532", "M528.3 61.3c-11.4-42.7-55.3-68-98-56.6L384 17.1 416.8 139.5 308.5 167.5c-4-11.5-8.6-24.7-13.8-39.5l-45.4 0c-4 11.4-11 31.5-21.1 60.4l-132.2 34.3 0-62.6-48 0 0 288-48 0 0 64 576 0 0-64-169.3 0-64-182.9-62.2 16.1 24.8 70.8-66.6 0 23.1-66-74.6 19.3-49.9 142.6-41.3 0 0-159.2 337.4-87.5 33.5 124.9 46.4-12.4c42.7-11.4 68-55.3 56.6-98L528.3 61.3zM205.1 448l11.2-32 111.4 0 11.2 32-133.8 0zM272.3 64l-.3-.9-.3 .9 .6 0z"],
    "rhombus": [448, 512, [], "e23b", "M249.2 4.1l-25.1-31.6-25.1 31.6-184 232-16.1 20.2 16.4 20 184 224 24.7 30.1 24.7-30.1 184-224 16.4-20-16-20.2-184-232z"],
    "square-lari": [448, 512, [], "e73f", "M448 32l-448 0 0 448 448 0 0-448zM224 136.1c1.3 0 2.7-.1 4-.1 4 0 8.1 .2 12 .6l0-24.6 32 0 0 32c39.3 14.9 69 49.2 77.5 91.2l4.2 20.8-49 0-2.3-11.2C298.6 225.6 287.4 209 272 198l0 42-32 0 0-55.1c-3.9-.6-7.9-.9-12-.9-1.3 0-2.7 0-4 .1l0 55.9-32 0 0-46.9c-23.8 12.8-40 38-40 66.9 0 42 34 76 76 76l108 0 0 48-224 0 0-48 18 0c-16.3-21-26-47.4-26-76 0-56 37.1-103.3 88-118.7l0-29.3 32 0 0 24.1z"],
    "circle-user-circle-xmark": [640, 512, [], "e7a6", "M496 208c-77.5 0-144.3 45.9-174.6 112l-145.4 0-23.9 71.6c34.8 34.8 82.8 56.4 135.9 56.4 7.4 0 14.6-.4 21.7-1.2 5.5 21.9 14.8 42.4 27.1 60.6-15.8 3-32.1 4.6-48.8 4.6-141.4 0-256-114.6-256-256S146.6 0 288 0c126.8 0 232.1 92.2 252.4 213.2-14.3-3.4-29.1-5.2-44.4-5.2zM288 272a72 72 0 1 0 0-144 72 72 0 1 0 0 144zm208-16a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm55.3 111.3L562.6 356 540 333.4c-4 4-18.7 18.6-44 44-25.4-25.4-40-40-44-44L429.4 356c4 4 18.6 18.7 44 44-25.4 25.4-40 40-44 44L452 466.6c4-4 18.7-18.6 44-44 25.4 25.4 40 40 44 44L562.6 444c-4-4-18.6-18.7-44-44l32.7-32.7z"],
    "apartment": [576, 512, [], "e468", "M448 0l-320 0 0 96-128 0 0 416 576 0 0-320-128 0 0-192zM240 352l96 0 0 112-96 0 0-112zM64 352l0-64 64 0 0 64-64 0zM384 96l0 64-64 0 0-64 64 0zM192 96l64 0 0 64-64 0 0-64zM384 256l-64 0 0-64 64 0 0 64zm64 96l0-64 64 0 0 64-64 0zM128 256l-64 0 0-64 64 0 0 64zm64 0l0-64 64 0 0 64-64 0z"],
    "user-bounty-hunter": [448, 512, [], "e2bf", "M323 120C309.4 78 270 48 224 48s-85.4 30-99 72L323 120zm5.5 36.4l-80.5 15.1 0 95.9 8.8-1.6c5.1-43.6 33.6-80 72.5-96.4l-.8-13zm-209 0l-.8 13c38.9 16.5 67.4 52.9 72.5 96.4l8.8 1.6 0-95.9-80.5-15.1zM96 70c27.1-42.2 74.5-70 128-70 80.1 0 146.5 62.2 151.7 142.2l8.3 128.2 1.4 21.4-21.2 3.7-136 24c-2.8 .5-5.6 .5-8.3 0l-136-24-21.2-3.7 1.3-20.7 0-271.2 48 0 0 32-16 0 0 38zM48 352l352 0 48 160-160 0 0-48-64-48-64 48 0 48-160 0 48-160z"],
    "seat": [384, 512, [], "e764", "M64 0l256 0 0 240-256 0 0-240zM0 384l0-96 384 0 0 96-32 0 0 128-64 0 0-128-192 0 0 128-64 0 0-128-32 0z"],
    "eye-dropper-half": [512, 512, [], "e173", "M240.1 130.8L341.6 29.2c39-39 102.2-39 141.1 0s39 102.2 0 141.1L381.2 271.9c4.1 4.1 14.8 14.8 32.1 32.1l-45.3 45.3-22.6-22.6-160-160-22.6-22.6 45.3-45.3c17.3 17.3 28 28 32.1 32.1zm-76.6 81.8l45.3 45.3-62.2 62.2 91 0 16.7-16.7 16.7 16.7 1.1 0-.6 .6 28 28-131.4 131.4-88 0-5.5 3.7C47.1 501.9 32.9 511.4 32 512L0 480c.6-.9 10-15.1 28.3-42.5l3.7-5.5 0-88 131.4-131.4z"],
    "comment-code": [512, 512, [], "e147", "M512 240c0 132.5-114.6 240-256 240-38.3 0-74.7-7.9-107.3-22.1L0 512 55.7 389.5C20.8 348.5 0 296.5 0 240 0 107.5 114.6 0 256 0S512 107.5 512 240zM217 193l17-17-33.9-33.9c-3.5 3.5-30.5 30.5-81 81l-17 17c3.5 3.5 30.5 30.5 81 81l17 17 33.9-33.9c-6.3-6.3-27.6-27.6-64-64l47-47zM329 159l-17-17-33.9 33.9c6.3 6.3 27.6 27.6 64 64-36.4 36.4-57.7 57.7-64 64L312 337.9c3.5-3.5 30.5-30.5 81-81l17-17c-3.5-3.5-30.5-30.5-81-81z"],
    "tachograph-digital": [576, 512, ["digital-tachograph"], "f566", "M0 64l576 0 0 384-576 0 0-384zm64 64l0 96 224 0 0-96-224 0zM88 352l-24 0 0 48 184 0 0-48-160 0zm256 0l-24 0 0 48 192 0 0-48-168 0zM496 192a64 64 0 1 0 -128 0 64 64 0 1 0 128 0zM88 312a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm104-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm56 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"],
    "hand-back-point-ribbon": [448, 512, [], "e1a0", "M176 0l0 32c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16L32 128 75.6 80 32 32 96 32 96 0 176 0zM96 224l0-64 80 0 0 16 80 0 0 32 80 0 0 32 80 0 0 144c0 70.7-57.3 128-128 128l-118.1 0c-37.4 0-73.7-13.1-102.4-37.1l-5.4-4.5C32.9 446.1 16 410 16 372l0-68 48-40 0 72 32 0 0-112z"],
    "laptop-binary": [640, 512, [], "e5e7", "M64 32l512 0 0 304-64 0 0-240-384 0 0 240-64 0 0-304zM0 424l0-40 640 0 0 40-56 56-528 0-56-56zM176 128l80 0 0 112-96 0 0-112 16 0zm16 80l32 0 0-48-32 0 0 48zm112-80l32 0 0 112-32 0 0-80-16 0 0-32 16 0zm80 0l96 0 0 112-96 0 0-112zm32 32l0 48 32 0 0-48-32 0zM192 272l32 0 0 64-32 0 0-32-16 0 0-32 16 0zm256 16l0 48-32 0 0-32-16 0 0-32 48 0 0 16zm-80 0l0 48-32 0 0-32-32 0 0 32-32 0 0-64 96 0 0 16z"],
    "tablet": [448, 512, ["tablet-android"], "f3fb", "M448 0L0 0 0 512 448 512 448 0zM184 400l104 0 0 48-128 0 0-48 24 0z"],
    "ruble-sign": [448, 512, [8381, "rouble", "rub", "ruble"], "f158", "M112 32l-32 0 0 240-64 0 0 48 64 0 0 48-64 0 0 48 64 0 0 64 64 0 0-64 176 0 0-48-176 0 0-48 112 0c79.5 0 144-64.5 144-144S335.5 32 256 32L112 32zM256 256l-112 0 0-160 112 0c44.2 0 80 35.8 80 80s-35.8 80-80 80z"],
    "closed-captioning": [512, 512, [], "f20a", "M0 64l512 0 0 384-512 0 0-384zM152 208l32 0c4.4 0 8 3.6 8 8l0 24 48 0 0-24c0-30.9-25.1-56-56-56l-32 0c-30.9 0-56 25.1-56 56l0 80c0 30.9 25.1 56 56 56l32 0c30.9 0 56-25.1 56-56l0-24-48 0 0 24c0 4.4-3.6 8-8 8l-32 0c-4.4 0-8-3.6-8-8l0-80c0-4.4 3.6-8 8-8zm168 8c0-4.4 3.6-8 8-8l32 0c4.4 0 8 3.6 8 8l0 24 48 0 0-24c0-30.9-25.1-56-56-56l-32 0c-30.9 0-56 25.1-56 56l0 80c0 30.9 25.1 56 56 56l32 0c30.9 0 56-25.1 56-56l0-24-48 0 0 24c0 4.4-3.6 8-8 8l-32 0c-4.4 0-8-3.6-8-8l0-80z"],
    "interrobang": [320, 512, [8253], "e5ba", "M160.1 0c88.3 0 160.1 71.6 160 160-.1 55.1-28.7 108.9-80 138.5l-48 27.7 0 57.7-64 0c0-19.3 0-44.7 0-76.2l0-18.5 0 0 0-161.3 64 0 0 124.4 16-9.2c30.7-17.7 48-49.9 48-83.2 0-53-43-96-96-96-53 0-96 43-96 96l0 32-64 0 0-32C0 71.6 71.7 0 160.1 0zM128 448l64 0 0 64-64 0 0-64z"],
    "pen": [576, 512, [128394], "f304", "M16 528L72 328 295 105 439 249 216 472 16 528zM473 215l-144-144 87-87 144 144-87 87z"],
    "pallet-boxes": [576, 512, [57863, "palette-boxes", "pallet-alt"], "f483", "M32 0l0 256 256 0 0-256-256 0zm0 320l-32 0 0 64 64 0 0 64-64 0 0 64 576 0 0-64-64 0 0-64 64 0 0-64-544 0zm96 64l128 0 0 64-128 0 0-64zm192 0l128 0 0 64-128 0 0-64zM544 64l-192 0 0 192 192 0 0-192z"],
    "plane": [576, 512, [], "f072", "M520 200c30.9 0 56 25.1 56 56s-25.1 56-56 56l-127.3 0-168.7 184-80 0 61.3-184-99.7 0-57.6 72-48 0 32-128-32-128 48 0 57.6 72 99.7 0-61.3-184 80 0 168.7 184 127.3 0z"],
    "book-arrow-right": [448, 512, [], "e0b9", "M0 0l448 0 0 384-32 0 0 64 32 0 0 64-448 0 0-512zM64 416l0 32 288 0 0-64-256 0c-17.7 0-32 14.3-32 32zM321 209l17-17c-2.1-2.1-31.8-31.8-89-89l-17-17-33.9 33.9c9 9 25 25 48 48l-126.1 0 0 48 126.1 0c-23 23-39 39-48 48L232 297.9c2.1-2.1 31.8-31.8 89-89z"],
    "images": [576, 512, [], "f302", "M96 32l448 0 0 384-448 0 0-384zM48 128l0 336 400 0 0 48-448 0 0-384 48 0zm144 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm48 48l-96 144 352 0-128-208-81.9 133.1-46.1-69.1z"],
    "mobile-screen": [384, 512, ["mobile-android-alt"], "f3cf", "M16 0l352 0 0 512-352 0 0-512zM128 416l0 48 128 0 0-48-128 0zM304 64l-224 0 0 304 224 0 0-304z"],
    "guarani-sign": [384, 512, [], "e19a", "M216 0l-48 0 0 65.5C73.3 77.3 0 158.1 0 256S73.3 434.7 168 446.5l0 65.5 48 0 0-65.5c94.7-11.8 168-92.6 168-190.5l0-32-168 0 0-93.8c25.3 4.8 47.9 17 65.6 34.3l44.8-45.7C297.2 90.2 258.8 70.8 216 65.5L216 0zM168 130.2l0 251.5C108.8 370.5 64 318.5 64 256s44.8-114.5 104-125.8zm48 251.5l0-93.8 100 0c-12.3 47.6-51.2 84.5-100 93.8z"],
    "bag-shopping": [448, 512, ["shopping-bag"], "f290", "M160 80c0-35.3 28.7-64 64-64s64 28.7 64 64l0 48-128 0 0-48zm-48 48l-112 0 0 352 448 0 0-352-112 0 0-48c0-61.9-50.1-112-112-112S112 18.1 112 80l0 48zm24 48a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm152 24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"],
    "circle-austral": [512, 512, [], "e71b", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM236.5 128l39 0 6.3 14.3 43.3 97.7 58.9 0 0 32-44.7 0 10.6 24 34.1 0 0 32-19.9 0c6.6 14.9 13.1 29.7 19.6 44.2l-43.9 19.4c-5-11.3-14.4-32.6-28.2-63.7l-111.2 0c-13.8 31.1-23.2 52.3-28.2 63.7l-43.9-19.4c6.5-14.6 13-29.3 19.6-44.2l-19.9 0 0-32 34.1 0 10.6-24-44.7 0 0-32 58.9 0 43.3-97.7 6.3-14.3zM256 202.5l-16.6 37.5 33.2 0-16.6-37.5zM214.6 296l82.8 0-10.6-24-61.6 0-10.6 24z"],
    "circle-right": [512, 512, [61838, "arrow-alt-circle-right"], "f35a", "M0 256a256 256 0 1 0 512 0 256 256 0 1 0 -512 0zM256 128l8 0 128 128-128 128-8 0 0-80-128 0 0-96 128 0 0-80z"],
    "person-running-fast": [576, 512, [], "e5ff", "M472 24a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zM256 112l-21.7 0c-1.4 3.4-14.7 36.8-40 100.1l-11.9 29.7 59.4 23.8c5.9-14.8 17.9-44.7 35.8-89.6l41.4 0-22.7 90.6c-8.3 33.2 11 67 43.7 76.8L436 372.2c-38.9 87.5-59.6 134.1-62.2 140l58.5 26 13-29.2c50.9-114.5 77.1-173.5 78.8-177.2-13.5-4.1-56.1-16.8-127.6-38.3l20.7-70.4c14.5 24.8 24 41.1 28.5 48.8l130.4 0 0-64-93.6 0-28.2-48.4C437 130.1 405.4 112 371.2 112L256 112zm4.8 284.9c-70.2 57.9-108.2 89.2-113.9 93.9l40.7 49.4c4.6-3.8 44.8-36.9 120.7-99.5l6.8-5.6c.3-.9 5.6-15.7 15.8-44.3l-4.7-1.4c-20.4-6.1-37.9-17.6-51.2-32.4l-14.3 40zM24 95.8l-24 0 0 48 160 0 0-48-136 0zm8 96l0 48 112 0 0-48-112 0zm-8 96l-24 0 0 48 192 0 0-48-168 0z"],
    "cloud-sleet": [512, 512, [], "f741", "M96.3 320l-96 0 0-96c0-41.8 26.7-77.4 64-90.5l0-21.5c0-61.9 50.1-112 112-112 43.1 0 80.5 24.3 99.2 60 14.7-17.1 36.5-28 60.8-28 44.2 0 80 35.8 80 80l0 16c53 0 96 43 96 96l0 96-416 0zM47 368l50.6 0-48 144-50.6 0 48-144zm298.6 0l-48 144-50.6 0 48-144 50.6 0zM200.3 392l0 16 40 0 0 48-40 0 0 40-48 0 0-40-40 0 0-48 40 0 0-40 48 0 0 24zm248-24l0 40 40 0 0 48-40 0 0 40-48 0 0-40-40 0 0-48 40 0 0-40 48 0z"],
    "piano": [512, 512, [], "f8d4", "M0 192l0 320 512 0 0-224-128-64 0-32C384 86 298 0 192 0S0 86 0 192zM416 352l32 0 0 96-384 0 0-96 32 0 0 64 32 0 0-64 32 0 0 64 32 0 0-64 32 0 0 64 32 0 0-64 64 0 0 64 32 0 0-64 32 0 0 64 32 0 0-64z"],
    "phone-volume": [576, 512, ["volume-control-phone"], "f2a0", "M344-32l-24 0 0 48 24 0c101.6 0 184 82.4 184 184l0 24 48 0 0-24C576 71.9 472.1-32 344-32zm8 256a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM320 64l0 48 24 0c48.6 0 88 39.4 88 88l0 24 48 0 0-24c0-75.1-60.9-136-136-136l-24 0zM160 0L32 64 32 80c0 238.6 193.4 432 432 432l16 0 64-128-128-96.8-80 80.8c-70.4-33-127-89.6-160-160L256.7 128 160 0z"],
    "cubes": [512, 512, [], "f1b3", "M268-10.5l-12-6.9-12 6.9-116.3 67.1-12 6.9 0 134.2-104.3 60.2-12 6.9 0 162 12 6.9 116.3 67.1 12 6.9 12-6.9 104.3-60.2 104.3 60.2 12 6.9 12-6.9 116.3-67.1 12-6.9 0-13.9 0-134.2 0-13.9-12-6.9-104.3-60.2 0-134.2-12-6.9-116.3-67.1zM232 292.6l0 106.5-92.3 53.3 0-106.5 92.3-53.3zm232.5 0l0 106.5-92.3 53.3 0-106.5 92.3-53.3zM348.3 91.2l0 106.5-92.3 53.3 0-106.5 92.3-53.3z"],
    "file-magnifying-glass": [384, 512, ["file-search"], "f865", "M0 0L240 0 384 144 384 512 0 512 0 0zM208 58.5L208 176 325.5 176 208 58.5zM272 320c0-53-43-96-96-96s-96 43-96 96 43 96 96 96c17.8 0 34.4-4.8 48.7-13.2l55.3 55.3 33.9-33.9c-7.8-7.8-26.2-26.2-55.3-55.3 8.5-14.3 13.3-31 13.3-48.9zm-96-48a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"],
    "phone": [512, 512, [128222, 128379], "f095", "M0 64L128 0 224.8 128 144 208c33 70.4 89.6 127 160 160l80-80.8 128 96.8-64 128-16 0C193.4 512 0 318.6 0 80L0 64z"],
    "hexagon-check": [576, 512, [], "e416", "M433 28.1l123.7 216 6.8 11.9-6.8 11.9-123.7 216.1-6.9 12.1-275.2 0-6.9-12.1-123.7-216.1-6.8-11.9 6.8-11.9 123.7-216 6.9-12.1 275.2 0 6.9 12.1zM373 151l-119.4 164.2-69.1-69.1-33.9 33.9 88.9 88.9 19.8 19.9 16.5-22.7 135.9-186.9 14.1-19.4-38.8-28.3-14.1 19.4z"],
    "user-beard-bolt": [640, 512, [], "e689", "M232 0l48 0c57.4 0 104 46.6 104 104l0 8 32 88 0 40-32 32 0 32-48 48-32 0-32 32-32 0-32-32-32 0-48-48 0-32-32-32 0-40 32-88 0-8C128 46.6 174.6 0 232 0zM336 128c0-11.4-2.4-22.2-6.7-32l-41.3 0-32-32-32 32-41.3 0c-4.3 9.8-6.7 20.6-6.7 32l0 16c0 12.7 3 24.8 8.3 35.5 20.4-20.4 30.8-30.8 31.5-31.5l80.6 0c.6 .6 11.1 11.1 31.5 31.5 5.3-10.7 8.3-22.7 8.3-35.5l0-16zm-40 85.3c1.9-1.1 3.8-2.3 5.5-3.5l-21.8-21.8-47.4 0-21.8 21.8c1.8 1.2 3.6 2.4 5.5 3.5 11.8 6.8 25.4 10.7 40 10.7s28.2-3.9 40-10.7zM48 512l55-165.1c30.2 30.2 47.9 47.9 53.1 53.1l32 0c12.6 12.6 23.3 23.3 32 32l71.8 0 12.1-12.1 0 60.1 79.4 0-7.6 32-327.7 0zm312-96l200-168-32.4 136 104.4 0-200 168 32.4-136-104.4 0z"],
    "torii-gate": [448, 512, [9961], "f6a1", "M0 96l0-80 80 48 288 0 80-48 0 80c0 35.3-28.7 64-64 64l0 64 48 0 0 64-48 0 0 224-64 0 0-224-192 0 0 224-64 0 0-224-48 0 0-64 48 0 0-64C28.7 160 0 131.3 0 96zM128 224l64 0 0-64-64 0 0 64zm128 0l64 0 0-64-64 0 0 64z"],
    "dice-d8": [576, 512, [], "f6d2", "M576 272L288 544 0 272 288-32 576 272zM268 82.2l0 212.2-162.6-40.7-14.9 15.8 31.3 29.6 146.1 36.5 0 101.5 20 18.9 20-18.9 0-101.5 146.1-36.5 31.4-29.6-14.9-15.8-162.5 40.7 0-212.2-20-21.1-20 21.1z"],
    "clock-nine": [512, 512, [], "e34c", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm24-392l0 160-152 0 0-48 104 0 0-136 48 0 0 24z"],
    "file-mp3": [576, 512, [], "e648", "M272 0l-240 0 0 512 112 0 0-176 272 0 0-192-144-144zm85.5 176L240 176 240 58.5 357.5 176zM324 400l0-20-20 0c-2.7 0-8.5 0-17.6 0-.5 1-10.8 20.3-30.7 57.9-20.8-37.9-31.5-57.2-31.8-57.9-17.7 0-17.9 0-35.8 0l0 168 40 0 0-77.4c5.8 10.5 15.2 27.6 28.3 51.5 12.7-24 22-41.4 27.7-52.2l0 78.1 40 0 0-148zm44-20l-20 0 0 168 40 0 0-48 12 0c33.1 0 60-26.9 60-60s-26.9-60-60-60l-32 0zm32 80l-12 0 0-40 12 0c11 0 20 9 20 20s-9 20-20 20zm128 88c28.7 0 52-23.3 52-52 0-12.1-4.1-23.2-11-32 6.9-8.8 11-19.9 11-32 0-28.7-23.3-52-52-52l-48 0 0 40 48 0c6.6 0 12 5.4 12 12s-5.4 12-12 12l-32 0 0 40 32 0c6.6 0 12 5.4 12 12s-5.4 12-12 12l-48 0 0 40 48 0z"],
    "user-tie-hair": [448, 512, [], "e45f", "M304 144c0 44.2-35.8 80-80 80s-80-35.8-80-80l0-16 80 0 64-48 0 0c10 13.4 16 30 16 48l0 16zM224 0C153.3 0 96 57.3 96 128l0 16c0 70.7 57.3 128 128 128s128-57.3 128-128l0-16C352 57.3 294.7 0 224 0zm48 328l0-24-96 0 0 24 31.4 36.7-31.4 115.3-40-160-56 0-64 192 416 0-64-192-56 0-40 160-.6 0-31-115.1 31.6-36.9z"],
    "square-indian-rupee": [448, 512, [], "e6f5", "M448 32l-448 0 0 448 448 0 0-448zM152 120l168 0 0 32-60.1 0c9.3 11.3 15.9 25 18.7 40l41.4 0 0 32-41.4 0c-6.1 33-30.5 59.5-62.3 68.6 55.9 44.7 85.7 68.6 89.5 71.6l-30 37.5-18.7-15-112-89.6-9-7.2 0-41.9 56 0c16.4 0 30.5-9.9 36.7-24l-100.7 0 0-32 100.7 0c-6.2-14.1-20.3-24-36.7-24l-64 0 0-48 24 0z"],
    "coffin-cross": [384, 512, [], "e051", "M104 512L0 144 112 0 272 0 384 144 280 512 104 512zM216 120l0-24-48 0 0 64-72 0 0 48 72 0 0 144 48 0 0-144 72 0 0-48-72 0 0-40z"],
    "bacon": [640, 512, [129363], "f7e5", "M550.9 58.7l65.6 65.6-162.9 115.2-100.4 197.5-166.3 113.6-64.2-64.2 146.4-112.6 4.4-3.4 2.5-4.9 95.8-191.6 179.2-115.2zM516.2 23.9l-176 113.1-5.5 3.6-2.9 5.9-96.3 192.6-147 113.1-64.5-64.5 162.9-115.2 100.4-197.5 166.3-113.6 62.6 62.6z"],
    "images-user": [576, 512, [], "e1b9", "M544 32l-448 0 0 384 448 0 0-384zM48 152l0-24-48 0 0 384 448 0 0-48-400 0 0-312zM432 352l-224 0 32-96 160 0 32 96zM320 104a56 56 0 1 1 0 112 56 56 0 1 1 0-112z"],
    "person-falling-burst": [576, 512, [], "e547", "M288 0c0 10.7 0 53.3 0 128l0 18.1c-5.2 3.1-25.8 15.5-61.7 37l60.7 72.8 113 0 9.6 12.8c36.8 49.1 59.2 78.9 67.2 89.6l-51.2 38.4C416 384 396.8 358.4 368 320l-104.8 0 113.6 139.8 20.2 24.8-49.7 40.4-20.2-24.8-199.2-245.1c0 102.1 0 155.8 0 161l-64 0 0-32 0-160 0-18.1 15.5-9.3 144.5-86.7c0-59.6 0-96.2 0-109.9l64 0zM16 88A56 56 0 1 1 128 88 56 56 0 1 1 16 88zM392 72.1l0 24-48 0 0-88 48 0 0 64zm112 160l-24 0 0-48 88 0 0 48-64 0zm-39.8-86.2l-33.9-33.9c23.6-23.6 61.3-61.3 62.2-62.2l33.9 33.9c-23.6 23.6-61.3 61.3-62.2 62.2z"],
    "caduceus": [512, 512, [], "e681", "M280 89.6c14.3-8.3 24-23.8 24-41.6 0-26.5-21.5-48-48-48s-48 21.5-48 48c0 17.8 9.7 33.3 24 41.6l0 26.4-104-52-128 160 138.7 0c33.5 0 66.2-10.5 93.3-30l0 136.5-20.6-12.3c-12-7.2-19.4-20.2-19.4-34.3l0-27.8-48 0 0 27.8c0 30.9 16.2 59.6 42.7 75.5l22.6 13.6-6.6 4c-26.5 15.9-42.7 44.5-42.7 75.5l0 27.8 48 0 0-27.8c0-14.1 7.4-27.1 19.4-34.3l4.6-2.7 0 96.8 48 0 0-96.8 4.6 2.7c12 7.2 19.4 20.2 19.4 34.3l0 27.8 48 0 0-27.8c0-30.9-16.2-59.6-42.7-75.5l-6.6-4 22.6-13.6c26.5-15.9 42.7-44.5 42.7-75.5l0-27.8-48 0 0 27.8c0 14.1-7.4 27.1-19.4 34.3L280 330.4 280 194c27.2 19.5 59.8 30 93.3 30l138.7 0-128-160-104 52 0-26.4z"],
    "quote-right": [448, 512, [8221, "quote-right-alt"], "f10e", "M448 296c0 66.3-53.7 120-120 120l-40 0 0-64 40 0c30.9 0 56-25.1 56-56l0-8-128 0 0-192 192 0 0 200zm-256 0c0 66.3-53.7 120-120 120l-40 0 0-64 40 0c30.9 0 56-25.1 56-56l0-8-128 0 0-192 192 0 0 200z"],
    "house-medical-flag": [640, 512, [], "e514", "M512 0l-64 0 0 512 64 0 0-320 128 0 0-160-128 0 0-32zM400 192l-160-144-240 216 0 40 50.5 0 0 208 349.5 0 0-320zM275.2 239.2l0 61.6 61.6 0 0 70.4-61.6 0 0 61.6-70.4 0 0-61.6-61.6 0 0-70.4 61.6 0 0-61.6 70.4 0z"],
    "prescription": [448, 512, [], "f5b1", "M32 0l-32 0 0 320 64 0 0-96 50.7 0 128 128c-70.7 70.7-108 108-112 112L176 509.3c4-4 41.3-41.3 112-112l112 112 45.3-45.3-112-112 112-112-45.3-45.3c-4 4-41.3 41.3-112 112l-85.8-85.8C251.4 209.1 288 164.8 288 112 288 50.1 237.9 0 176 0L32 0zM176 160l-112 0 0-96 112 0c26.5 0 48 21.5 48 48s-21.5 48-48 48z"],
    "face-weary": [512, 512, [], "e3a1", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM214.1 190.1l-7.4 7.4c-24.2 24.2-55.3 40.2-89 45.8l-2.5 .4-19.7 3.3-6.6-39.5 19.7-3.3 2.5-.4c25.5-4.2 49-16.4 67.3-34.6 3.8-3.8 11-11 21.5-21.5l28.3 28.3-14.1 14.1zM283.7 176L312 147.7c10.6 10.6 17.7 17.7 21.5 21.5 18.3 18.3 41.8 30.4 67.3 34.6l2.5 .4 19.7 3.3-6.6 39.5-19.7-3.3-2.5-.4c-33.7-5.6-64.8-21.6-89-45.8-3.8-3.8-11-11-21.5-21.5zM256 384c-48.9 0-93.5 16.8-127.4 44.3-.4-4.1-.6-8.2-.6-12.3 0-70.7 57.3-128 128-128s128 57.3 128 128c0 4.2-.2 8.3-.6 12.3-33.9-27.6-78.5-44.3-127.4-44.3z"],
    "up-left": [448, 512, [], "e2bd", "M32 64L32 416 152 296 336 480 448 368 264 184 384 64 32 64z"],
    "hand-back-point-up": [448, 512, [], "e1a2", "M176 0l-80 0 0 336-32 0 0-72-48 40 0 68c0 38 16.9 74 46.1 98.3l5.4 4.5c28.8 24 65 37.1 102.4 37.1L288 512c70.7 0 128-57.3 128-128l0-144-80 0 0-32-80 0 0-32-80 0 0-176z"],
    "rectangle-history-circle-plus": [576, 512, [], "e4a3", "M257.4 480c-11.2-24.4-17.4-51.4-17.4-80 0-106 86-192 192-192l-432 0 0 272 257.4 0zM464 160l0-48-416 0 0 48 416 0zM416 64l0-48-320 0 0 48 320 0zm16 480a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm16-208l0 48 64 0 0 32-64 0 0 64-32 0 0-64-64 0 0-32 64 0 0-64 32 0 0 16z"],
    "person-water-arms-raised": [640, 512, [], "e78c", "M208.4 32l0 160 224 0 0-160 64 0 0 224-96 0 0 58.6-80 32-80-32 0-58.6-96 0 0-224 64 0zm56 56a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zM209.3 353.7l111.1 44.4 111.1-44.4 8.9-3.6 8.9 3.6 111.8 44.7c29.3-9.7 50.1-16.7 62.4-20.8l15.2 45.5c-11 3.7-34.6 11.5-70.8 23.6l-8.3 2.8-8.2-3.3-111.1-44.4-111.1 44.4-8.9 3.6-8.9-3.6-111.1-44.4-111.1 44.4-8.2 3.3-8.3-2.8C36.6 434.7 13 426.8 2 423.2l15.2-45.5c12.4 4.1 33.2 11.1 62.4 20.8l111.8-44.7 8.9-3.6 8.9 3.6z"],
    "beer-mug": [576, 512, ["beer-foam"], "e0b3", "M256 128c-35.7 0-65.9-23.4-76.2-55.6-10 27.8-36.6 47.6-67.8 47.6-39.8 0-72-32.2-72-72s32.2-72 72-72C143.2-24 169.8-4.1 179.8 23.6 190.1-8.6 220.3-32 256-32s65.9 23.4 76.2 55.6c10-27.8 36.6-47.6 67.8-47.6 39.8 0 72 32.2 72 72s-32.2 72-72 72c-31.2 0-57.8-19.9-67.8-47.6-10.3 32.3-40.5 55.6-76.2 55.6zM64 512l0-354c14.7 6.4 30.9 10 48 10 24 0 46.4-7.1 65.1-19.2 21.7 17 49.1 27.2 78.9 27.2s57.2-10.2 78.9-27.2c18.8 12.1 41.2 19.2 65.1 19.2 35.5 0 67.5-15.4 89.4-40l86.6 0 0 211.8-128 64 0 108.2-384 0zM448 332.2l64-32 0-108.2-64 0 0 140.2zM192 248l0-24-48 0 0 192 48 0 0-168zm88 0l0-24-48 0 0 192 48 0 0-168zm88 0l0-24-48 0 0 192 48 0 0-168z"],
    "dice-three": [448, 512, [9858], "f527", "M448 32l-448 0 0 448 448 0 0-448zM128 128a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm64 128a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm128 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "lasso": [576, 512, [], "f8c8", "M288.4 96c59.4 0 110.4 16.7 144.8 40.3 34.6 23.8 47.2 50.2 47.2 71.7s-12.7 47.9-47.2 71.7c-34.4 23.6-85.4 40.3-144.8 40.3-52 0-97.5-12.7-131.1-31.8l-14.2-8.9c-34.2-23.7-46.7-49.9-46.7-71.3 0-21.5 12.7-47.9 47.2-71.7 34.4-23.6 85.3-40.3 144.8-40.3zM253.2 382.4c11.5 1.1 23.2 1.6 35.2 1.6 141.3 0 256.1-78.9 256-176 .1-97.1-114.7-176-256-176-141.3 0-256.1 78.9-256 176 0 48.5 28.6 92.6 75 124.5 5.5 3.8 11.2 7.4 17.1 10.8l49.1 30.7c11.7 7.3 18.8 20.2 18.8 34 0 22.1-17.9 40.1-40.1 40.1l-5.6 0c-7.1 0-14.1-1.7-20.4-4.8-34.9-17.4-60.3-30.2-76.2-38.1L21.5 462.3c15.9 8 41.3 20.7 76.2 38.1 15.2 7.6 32 11.6 49 11.6l5.6 0c57.5 0 104.1-46.6 104.1-104.1 0-8.7-1.1-17.3-3.2-25.6z"],
    "file-aiff": [576, 512, [], "e7fb", "M416 144l0 192-288 0 0 176-96 0 0-512 240 0 144 144zM240 176L357.5 176 240 58.5 240 176zm-8 204c24.3 0 44 19.7 44 44l0 124-40 0 0-48-24 0 0 48-40 0 0-124c0-24.3 19.7-44 44-44l16 0zM340 548l-40 0 0-168 40 0 0 168zM452 420l-48 0 0 24 48 0 0 40-48 0 0 64-40 0 0-168 88 0 0 40zm112 0l-48 0 0 24 48 0 0 40-48 0 0 64-40 0 0-168 88 0 0 40zm-348 0c-2.2 0-4 1.8-4 4l0 36 24 0 0-36c0-2.2-1.8-4-4-4l-16 0z"],
    "building-lock": [576, 512, [], "e4d6", "M416 0l-384 0 0 512 272 0 0-208 32 0c0-53.7 33.1-99.7 80-118.7L416 0zM176 352l80 0 0 112-80 0 0-112zm80-128l51.2 0c-5.2 10.1-9.4 20.8-12.6 32l-38.6 0 0-32zM128 96l64 0 0 64-64 0 0-64zm192 0l0 64-64 0 0-64 64 0zM128 224l64 0 0 64-64 0 0-64zm304 80c0-17.7 14.3-32 32-32s32 14.3 32 32l0 48-64 0 0-48zm-48 48l-32 0 0 192 224 0 0-192-32 0 0-48c0-44.2-35.8-80-80-80s-80 35.8-80 80l0 48z"],
    "id-card": [576, 512, [62147, "drivers-license"], "f2c2", "M0 32l576 0 0 64-576 0 0-64zM0 144l576 0 0 336-576 0 0-336zM64 416l224 0-32-64-160 0-32 64zM176 312a56 56 0 1 0 0-112 56 56 0 1 0 0 112zM360 208l-24 0 0 48 160 0 0-48-136 0zm0 96l-24 0 0 48 160 0 0-48-136 0z"],
    "square-ruble": [448, 512, [], "e6f8", "M448 32l-448 0 0 448 448 0 0-448zM144 120l104 0c48.6 0 88 39.4 88 88s-39.4 88-88 88l-56 0 0 24 72 0 0 32-72 0 0 40-48 0 0-40-40 0 0-32 40 0 0-40-40 0 0-32 40 0 0-128zM248 248c22.1 0 40-17.9 40-40s-17.9-40-40-40l-56 0 0 80 56 0z"],
    "clock-desk": [448, 512, [], "e134", "M384 224a160 160 0 1 0 -320 0 160 160 0 1 0 320 0zM224 0C347.7 0 448 100.3 448 224l0 288-448 0 0-288C0 100.3 100.3 0 224 0zm24 112l0 102.1c31.3 31.3 50.6 50.6 57.9 57.9L272 305.9c-6.1-6.1-27.8-27.8-65-65l-7-7 0-121.9 48 0z"],
    "circle-play": [512, 512, [61469, "play-circle"], "f144", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM384 256l-208 128 0-256 208 128z"],
    "face-laugh-beam": [512, 512, [128513, "laugh-beam"], "f59a", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm0-80c-83 0-151.2-63.1-159.2-144l318.4 0c-8 80.9-76.2 144-159.2 144zM176 164c-15.5 0-28 12.5-28 28l0 28-40 0 0-28c0-37.6 30.4-68 68-68s68 30.4 68 68l0 28-40 0 0-28c0-15.5-12.5-28-28-28zm132 28l0 28-40 0 0-28c0-37.6 30.4-68 68-68s68 30.4 68 68l0 28-40 0 0-28c0-15.5-12.5-28-28-28s-28 12.5-28 28z"],
    "leaf": [512, 512, [], "f06c", "M512 24l0 186.9C512 342.1 403.9 448 273.2 448 196.2 448 129.8 398.5 105.7 329.3 70.4 360.1 48 405.4 48 456l0 24-48 0 0-24C0 381.1 38.2 315.1 96.1 276.3 131.3 252.8 173.5 240 216 240l104 0 0-48-104 0c-39.7 0-77.3 8.8-111 24.5 23.3-70 89.2-120.5 167-120.5 58 0 107.5-21.8 143.2-44.3 17.7-11.2 31.7-22.4 41.2-30.8 4.8-4.2 9.4-8.7 13.9-13.2L512 24z"],
    "house-chimney-user": [512, 512, [], "e065", "M464 272l48 0 0-48-48-45 0-131-96 0 0 41-112-105-256 240 0 48 48 0 0 240 416 0 0-240zM200 256a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm136 96l32 96-224 0 32-96 160 0z"],
    "rotate-right": [512, 512, ["redo-alt", "rotate-forward"], "f2f9", "M512 192l0-200-79 79c-100.3-96-259.4-94.7-358 4-50.2 50.2-75.2 116.1-75 181.9 0 2 0 3.9 .1 5.9 .9 35.4 9 68.9 22.9 99.3 12.4 27.2 29.7 52.6 52 74.9l0 0c46.3 46.3 110.3 75 181 75 100.1 0 186.8-57.5 228.8-141.1l-57.2-28.8c-31.6 62.8-96.6 105.8-171.6 105.8-84.3 0-156-54.4-181.8-130-6.1-17.9-9.5-36.6-10.1-55.3-.1-2.2-.1-4.5-.1-6.8l0 0c0-49.2 18.7-98.3 56.2-135.8 73.6-73.6 192.2-75 267.5-3.9L312 192 512 192z"],
    "books-medical": [640, 512, [], "f7e8", "M483.6-7.8l-123.6 33.1 20.7 77.3 123.6-33.1-20.7-77.3zm33.1 123.6l-123.6 33.1 20.8 77.5c24.9-11.8 52.8-18.4 82.2-18.4 16.2 0 31.9 2 46.9 5.8l-26.3-98zM352 96l-112 0 0 416 100 0c-22.7-31.5-36-70.2-36-112 0-48.7 18.1-93.2 48-127l0-177zM64 0l0 80 128 0 0-80-128 0zm0 128l0 256 128 0 0-256-128 0zm0 304l0 80 128 0 0-80-128 0zM496 544a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm26.7-224l0 53.3 53.3 0 0 53.3-53.3 0 0 53.3-53.3 0 0-53.3-53.3 0 0-53.3 53.3 0 0-53.3 53.3 0z"],
    "dress": [576, 512, [], "e6d1", "M117.7 0l41.1 219.3-123.2 246.4-23.2 46.3 551.6 0-23.2-46.3-123.2-246.4 41.1-219.3-69.6 0-8.3 27.6C368.9 68 330.9 96 288.3 96s-80.6-28-92.7-68.4L187.3 0 117.7 0z"],
    "tooth": [448, 512, [129463], "f5c9", "M145 5.7L224 32 303 5.7C314.3 1.9 326 0 337.9 0 398.7 0 448 49.3 448 110.1l0 113.9-48 64-32 224-80 0-32-192-64 0-32 192-80 0-32-224-48-64 0-113.9C0 49.3 49.3 0 110.1 0 122 0 133.7 1.9 145 5.7z"],
    "house-chimney-window": [512, 512, [], "e00d", "M464 272l48 0 0-48-48-45 0-131-96 0 0 41-112-105-256 240 0 48 48 0 0 240 416 0 0-240zM320 352l-128 0 0-128 128 0 0 128z"],
    "square-ellipsis": [448, 512, [], "e26e", "M448 480l0-448-448 0 0 448 448 0zM160 224l0 64-64 0 0-64 64 0zm32 0l64 0 0 64-64 0 0-64zm160 0l0 64-64 0 0-64 64 0z"],
    "motorcycle": [640, 512, [127949], "f21c", "M280 16l-24 0 0 48 80.6 0 22.5 48.7-95.1 71.3c-33.4-25.1-75-40-120-40l-80 0 0 48 80 0c78.5 0 143.2 59.6 151.2 136l-25.4 0c-11.2-59.2-63.3-104-125.8-104-70.7 0-128 57.3-128 128S73.3 480 144 480c62.5 0 114.5-44.8 125.8-104l74.2 0 0-46.5c0-45.1 25.7-85.4 65.5-107.7l12.1 26.1c-32.4 23.2-53.5 61.2-53.5 104.1 0 70.7 57.3 128 128 128s128-57.3 128-128-57.3-128-128-128c-10.7 0-21 1.3-30.9 3.8l-31.3-67.8 78.2 0 0-96-88 0c-2.1 1.6-10.7 8-25.6 19.2-19.4-42.1-29.8-64.5-31-67.2L280 16zM445.8 300.4c22 47.7 34.9 75.5 38.5 83.4l43.6-20.1c-3.6-7.9-16.5-35.7-38.5-83.4 2.2-.2 4.4-.3 6.7-.3 39.8 0 72 32.2 72 72s-32.2 72-72 72-72-32.2-72-72c0-20.2 8.3-38.5 21.8-51.6zM144 424c-39.8 0-72-32.2-72-72s32.2-72 72-72c31.3 0 58 20 67.9 48l-91.9 0 0 48 91.9 0c-9.9 28-36.6 48-67.9 48z"],
    "grid-round-2-minus": [448, 512, [], "e6ab", "M96 32a96 96 0 1 0 0 192 96 96 0 1 0 0-192zm0 256a96 96 0 1 0 0 192 96 96 0 1 0 0-192zM256 128a96 96 0 1 0 192 0 96 96 0 1 0 -192 0zm24 232l-24 0 0 48 192 0 0-48-168 0z"],
    "shield-minus": [512, 512, [], "e249", "M256 0l11.6 4.5 207.5 80.5 19.2 7.4 1.2 20.5c2.9 50-4.9 126.3-37.3 200.9-32.7 75.3-91.1 150-189.4 192.6l-12.7 5.5-12.7-5.5C144.9 463.9 86.6 389.2 53.9 313.9 21.5 239.3 13.7 162.9 16.6 113L17.8 92.5 37 85 244.5 4.5 256 0zM184 216l-24 0 0 48 192 0 0-48-168 0z"],
    "backward-fast": [512, 512, [9198, "fast-backward"], "f049", "M512 494.5c-15.7-13.8-90.4-79.1-224-196l0 196c-15.7-13.8-90.4-79.1-224-196l0 181.5-64 0 0-448 64 0 0 181.5C197.6 96.6 272.3 31.3 288 17.5l0 196C421.6 96.6 496.3 31.3 512 17.5l0 477z"],
    "dolly-empty": [640, 512, [], "f473", "M32.5 0l151.1 0 7.3 21.9 99.4 298.1c30.1 .5 56.8 14.9 74 37l202.1-67.4 30.4-10.1 20.2 60.7-30.4 10.1-202.1 67.4c-.9 52.2-43.5 94.3-96 94.3-53 0-96-43-96-96 0-30.8 14.5-58.2 37-75.8L137.4 64 32.5 64 32.5 0zm256 464a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"],
    "address-book": [512, 512, [62138, "contact-book"], "f2b9", "M448 0l-416 0 0 512 416 0 0-512zM320 288l32 96-224 0 32-96 160 0zM184 192a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zM512 80l0-16-32 0 0 96 32 0 0-80zm0 112l-32 0 0 96 32 0 0-96zm0 144l0-16-32 0 0 96 32 0 0-80z"],
    "clouds-moon": [576, 512, [], "f745", "M418.4 135c0-58.6 40.4-107.8 94.8-121.3-19.8-8.8-41.7-13.7-64.8-13.7-84 0-152.8 64.7-159.5 147 .4 .7 .8 1.5 1.2 2.2 32.1 10.1 57.9 34.2 70.3 65.2 46.2 15.2 80.8 56 87 105.6l1 0c52.6 0 99.2-25.4 128.4-64.5-10.6 2.9-21.8 4.5-33.4 4.5-69 0-125-56-125-125zm-304 185l.9-.5c11-45.6 52.1-79.5 101.1-79.5 6 0 11.9 .5 17.7 1.5 18.1-16.5 41-28 66.4-32-11.5-10.9-27-17.5-44-17.5-.5 0-1.1 0-1.6 0-7.4-36.5-39.7-64-78.4-64-35 0-64.8 22.5-75.6 53.8-8.7-3.7-18.3-5.8-28.4-5.8-39.8 0-72 32.2-72 72l0 72 114 0zm334 192l0-80c0-33.9-21.1-62.9-50.9-74.5 1.9-6.8 2.9-14 2.9-21.5 0-44.2-35.8-80-80-80-30.8 0-57.5 17.4-70.9 42.8-9.3-6.8-20.7-10.8-33.1-10.8-34.3 0-60.9 32-55.2 65.4-36.9 7.1-64.8 39.6-64.8 78.6l0 80 352 0z"],
    "car-building": [576, 512, [], "f859", "M0 0l320 0 0 112-92.3-.2-36.6 128.2-47.1 0 0 239.9-144 0 0-480zM64 96l0 64 64 0 0-64-64 0zM96 224l-32 0 0 64 32 0 0-64zm167.9-64.2l24.2 .1 192 .5 24.1 .1c.5 1.9 12.7 44.4 36.6 127.6l35.3 0 0 224-64 0 0-48-256 0 0 48-64 0 0-224 35.3 0c23.9-83.5 36.1-126.2 36.6-128.2zm192 64.5l-143.8-.4-18.3 64 180.3 0-18.3-63.7zM288 415.5a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm224-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "face-awesome": [512, 512, ["gave-dandy"], "e409", "M0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm203.5-95.6c-5.6 9.4-15.8 15.6-27.5 15.6-17.7 0-32-14.3-32-32 0-9.1 3.8-17.4 10-23.2-3.3-.5-6.6-.8-10-.8-35.3 0-64 28.7-64 64l0 40 128 0 0-40c0-8.3-1.6-16.3-4.5-23.6zM384 176c-17.7 0-32-14.3-32-32 0-8.5 3.3-16.3 8.8-22-5.4-1.3-11-2-16.8-2-39.8 0-72 32.2-72 72l0 32 144 0 0-32c0-10.4-2.2-20.2-6.1-29.1-5.8 8-15.2 13.1-25.9 13.1zm48 112l-352 0 3.8 18.8c.9 4.5 2 8.9 3.2 13.2 21.1 75.2 89.9 128 169.1 128 55.9 0 106.6-26.3 139-68.3l0 0c16.2-20.9 27.8-45.6 33.2-73L432 288zM240.1 415.1c1.7-44 37.8-79.1 82.2-79.1 19.6 0 37.6 6.8 51.7 18.3-26.2 37.7-69.7 61.7-118 61.7-5.4 0-10.7-.3-15.9-.9z"],
    "blinds": [448, 512, [], "f8fb", "M448 32l-448 0 0 64 32 0-32 96 64 0 0-96 48 0 0 240 48 0 0-240 48 0 0 96 240 0-32-96 32 0 0-64zM32 240l-32 96 64 0 0-96-32 0zm416 96l-32-96-208 0 0 96 240 0zm0 144l-32-96-384 0-32 96 448 0z"],
    "sailboat": [512, 512, [], "e445", "M240-16l0 400-240 0 64 128 384 0 64-128-224 0 0-48 192 0-240-352zM192 336l0-240-160 240 160 0z"],
    "arrow-up-left-from-circle": [512, 512, [], "e09e", "M32 0L0 0 0 224 64 224 64 109.3 297.4 342.6 320 365.3 365.3 320 342.6 297.4 109.3 64 224 64 224 0 32 0zM288 128c88.4 0 160 71.6 160 160s-71.6 160-160 160-160-71.6-160-160l-64 0c0 123.7 100.3 224 224 224S512 411.7 512 288 411.7 64 288 64l0 64z"],
    "right-from-dotted-line": [576, 512, [], "e6c4", "M555.3 256l-202.9-192 0 128-192 0 0 128 192 0 0 128 202.9-192zM96.4 64l-64 0 0 64 64 0 0-64zm0 170.7l0-64-64 0 0 64 64 0zm0 42.7l-64 0 0 64 64 0 0-64zm0 170.7l0-64-64 0 0 64 64 0z"],
    "book-bookmark": [448, 512, [], "e0bb", "M352 0l96 0 0 384-32 0 0 64 32 0 0 64-448 0 0-512 192 0 0 192 80-48 80 48 0-192zM64 416l0 32 288 0 0-64-256 0c-17.7 0-32 14.3-32 32z"],
    "square-brazilian-real": [448, 512, [], "e6f1", "M448 32l-448 0 0 448 448 0 0-448zM336 128l0 24 32 0 0 48-57.8 0c-7.8 0-14.2 6.3-14.2 14.2 0 5.8 3.5 11 8.9 13.1l32 12.8c23.6 9.4 39.1 32.3 39.1 57.7 0 26.5-16.6 49.2-40 58.1l0 28.1-32 0 0-24-48 0 0-48 57.8 0c7.8 0 14.2-6.3 14.2-14.2 0-5.8-3.5-11-8.9-13.1l-32-12.8c-23.6-9.4-39.1-32.3-39.1-57.7 0-32.3 24.6-58.8 56-61.9l0-24.3 32 0zM104 144l48 0c39.8 0 72 32.2 72 72 0 26.9-14.7 50.3-36.5 62.6l26.8 80.5-45.5 15.2C166 366 156.4 337.2 140 288l-12 0 0 80-48 0 0-224 24 0zm48 96c13.3 0 24-10.7 24-24s-10.7-24-24-24l-24 0 0 48 24 0z"],
    "magnifying-glass-arrow-right": [576, 512, [], "e521", "M448.3 208c0 45.9-14.9 88.3-40 122.7L534.9 457.4 557.5 480 512.3 525.3 489.6 502.6 363 376c-34.4 25.2-76.8 40-122.7 40-114.9 0-208-93.1-208-208s93.1-208 208-208 208 93.1 208 208zm-111 17l17-17c-2.1-2.1-31.8-31.8-89-89l-17-17-33.9 33.9 48 48-126.1 0 0 48 126.1 0c-23 23-39 39-48 48l33.9 33.9c2.1-2.1 31.8-31.8 89-89z"],
    "split": [576, 512, [], "e254", "M416.1-30.5C449.7-1.2 488.7 33 533.2 71.9L560.7 96c-31 27.1-133.9 117.1-144.6 126.5l0-94.5-50.7 0-128 128 128 128 50.7 0 0-94.5c33.6 29.4 72.6 63.5 117.1 102.4L560.7 416c-31 27.1-133.9 117.1-144.6 126.5l0-94.5-77.3 0-9.4-9.4-150.6-150.6-146.7 0 0-64 146.7 0 150.6-150.6 9.4-9.4 77.3 0 0-94.5z"],
    "face-pensive": [512, 512, [], "e384", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm64-224c0 13.3 10.7 24 24 24l16 0c13.3 0 24-10.7 24-24l0-16 32 0 0 16c0 30.9-25.1 56-56 56l-16 0c-30.9 0-56-25.1-56-56l0-16 32 0 0 16zM152 312l16 0c13.3 0 24-10.7 24-24l0-16 32 0 0 16c0 30.9-25.1 56-56 56l-16 0c-30.9 0-56-25.1-56-56l0-16 32 0 0 16c0 13.3 10.7 24 24 24zm64 72l104 0 0 48-128 0 0-48 24 0zM83.9 204.9l15.6-12.5 80-64 15.6-12.5 25 31.2-15.6 12.5-80 64-15.6 12.5-25-31.2zm328.6-12.5l15.6 12.5-25 31.2-15.6-12.5-80-64-15.6-12.5 25-31.2 15.6 12.5 80 64z"],
    "book-circle-arrow-up": [576, 512, [], "e0bd", "M32 0l448 0 0 214c-15.3-3.9-31.4-6-48-6-100.6 0-183.2 77.4-191.3 176L128 384c-17.7 0-32 14.3-32 32l0 32 150 0c6 23.3 16.3 45 30 64L32 512 32 0zM576 400a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zM364.7 380.7l56-56 11.3-11.3 11.3 11.3 56 56 11.3 11.3-22.6 22.6c-4.6-4.6-18-18-40-40l0 105.4-32 0 0-105.4c-22 22-35.4 35.4-40 40l-22.6-22.6 11.3-11.3z"],
    "ship-large": [640, 512, [], "e810", "M449.3 417.7l111.8 44.7c29.3-9.8 50.1-16.7 62.5-20.8l15.2 45.5c-9.6 3.2-35.9 12-79.1 26.4l-8.2-3.3-111.1-44.4-120 48-120-48-111.1 44.4-8.2 3.3C37.9 499.2 11.6 490.4 2 487.2l15.2-45.5c12.4 4.1 33.2 11 62.4 20.8l111.8-44.7 8.9-3.6 120 48 120-48 8.9 3.6zM325.4 88.5l224 48 28.7 6.2-11.8 26.9-54 123.4 0 98.4c-33.3-13.3-57.2-22.9-72-28.8-10.7 4.3-42.8 17.1-96 38.4l0-257-48 0 0 257c-53.3-21.3-85.2-34.1-96-38.4-14.7 5.9-38.8 15.5-72 28.8l0-98.4-54-123.4-11.8-26.9 28.8-6.2 224-48 5-1.1 5 1.1zM344.4 0l136 0 0 80.8-146.6-31.4-13.4-2.8-13.4 2.8-146.6 31.4 0-80.8 136 0 0-32 48 0 0 32z"],
    "heart-half": [512, 512, [], "e1ab", "M256.5 107.8l-15-20.7C216.5 52.5 176.3 32 133.6 32 60.1 32 .5 91.6 .5 165.1 .5 301.9 154 425.3 256.5 496l0-388.2z"],
    "circle-lira": [512, 512, [], "e6f6", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM175.5 200c0-46.5 37.5-88 88.1-88l2.2 0c19.7 0 38.8 6.4 54.5 18.2l14.2 10.6-28.8 38.4-14.2-10.6C284 163 275 160 265.7 160l-2.2 0c-23 0-40.1 18.9-40 40l96.5 0 0 32-87.5 0c2.1 7.9 3.2 16 3.5 24l84 0 0 32-88 0c-3.2 11.3-8.3 22.1-15.1 32l135.1 0 0 48-200 0 0-42.5c1.1-1.4 9-11.6 23.7-30.5 1.7-2.2 3.3-4.6 4.7-7l-20.4 0 0-32 27.9 0c-.4-6.4-1.8-12.9-4.3-19l-1.4-3.5c-.2-.5-.4-1-.6-1.5l-21.6 0 0-32 15.5 0z"],
    "microphone-lines": [384, 512, [127897, "microphone-alt"], "f3c9", "M96 0l192 0 0 88-80 0 0 48 80 0 0 48-80 0 0 48 79.7 0c-4.1 49.3-45.3 88-95.7 88-53 0-96-43-96-96L96 0zM48 160l0 64c0 79.5 64.5 144 144 144s144-64.5 144-144l0-64 48 0 0 64c0 97.9-73.3 178.7-168 190.5l0 49.5 72 0 0 48-192 0 0-48 72 0 0-49.5C73.3 402.7 0 321.9 0 224l0-64 48 0z"],
    "reply-all": [640, 512, ["mail-reply-all"], "f122", "M384.3 432l-224-224 224-224 0 144 48 0c97.2 0 176 78.8 176 176 0 128-128 176-128 176s32-32 32-80c0-61.9-50.1-112-112-112l-16 0 0 144zM265.3 31.6L88.9 208 265.3 384.4 231.3 418.3 38 225 21 208 38 191 231.3-2.3 265.3 31.6z"],
    "square-list": [448, 512, [], "e489", "M0 32l448 0 0 448-448 0 0-448zM96 288a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm32-144a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM96 400a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm96-280l-24 0 0 48 208 0 0-48-184 0zm0 112l-24 0 0 48 208 0 0-48-184 0zm0 112l-24 0 0 48 208 0 0-48-184 0z"],
    "universal-access": [512, 512, [], "f29a", "M0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm161.5-86.1l-22.1-9.5-18.9 44.1c16.4 7 27.7 11.9 33.9 14.5 17.3 7.4 35.2 12.9 53.6 16.3l0 56.6c-24.4 73.1-37.2 111.5-38.4 115.1l45.5 15.2c1.9-5.7 13.3-39.8 34.1-102.4l13.4 0c20.8 62.5 32.2 96.6 34.1 102.4l45.5-15.2c-1.2-3.6-14-42-38.4-115.1l0-56.6c18.4-3.5 36.3-8.9 53.6-16.3 6.2-2.7 17.5-7.5 33.9-14.5l-18.9-44.1c-16.4 7-27.7 11.9-33.9 14.5-26.1 11.2-54.2 17-82.7 17s-56.5-5.8-82.7-17l-11.9-5.1zM256 160a40 40 0 1 0 0-80 40 40 0 1 0 0 80z"],
    "shield-cross": [512, 512, [9960], "f712", "M267.6 4.5L256 0 244.5 4.5 37 85 17.8 92.5 16.6 113c-2.9 49.9 4.9 126.3 37.3 200.9 32.7 75.3 91 150 189.4 192.6l12.7 5.5 12.7-5.5c98.4-42.6 156.7-117.3 189.4-192.6 32.4-74.7 40.2-151 37.3-200.9L494.3 92.5 475.1 85 267.6 4.5zM224 81.1l32-12.4 32 12.4 0 78.9 143 0c-1.5 19.5-4.7 41.3-10.1 64l-132.9 0 0 199.8c-10 6.5-20.7 12.6-32 18.1-11.3-5.5-22-11.6-32-18.1l0-199.8-132.8 0c-5.4-22.7-8.6-44.5-10.1-64l142.9 0 0-78.9z"],
    "train-stop": [640, 512, [], "e81f", "M352 416l-56.7 0 47.6 61.3 2.1 2.7-60.8 0-49.8-64-84.9 0-49.8 64-60.8 0 2.1-2.7 47.6-61.3-56.7 0 0-352 320 0 0 352zM512 0c61.9 0 112 50.1 112 112 0 50.7-33.7 93.5-80 107.3l0 260.7-64 0 0-260.7c-46.3-13.8-80-56.6-80-107.3 0-61.9 50.1-112 112-112zM192 304a24 24 0 1 0 0 48 24 24 0 1 0 0-48zM96 256l192 0 0-128-192 0 0 128z"],
    "toilet-paper": [512, 512, [129531, 63263, "toilet-paper-alt", "toilet-paper-blank"], "f71e", "M327.1 32c-8.8 11.1-16 23.1-21.9 34.8-21.4 42.7-33.2 98.4-33.2 157.2l0 320-272 0 0-320C0 118 43 32 96 32l231.1 0zM416 416c-53 0-96-86-96-192s43-192 96-192 96 86 96 192-43 192-96 192zm0-128c17.7 0 32-28.7 32-64s-14.3-64-32-64-32 28.7-32 64 14.3 64 32 64z"],
    "square-code": [448, 512, [], "e267", "M0 32l448 0 0 448-448 0 0-448zM246.1 176c3.6 3.6 30.3 30.3 80 80-49.7 49.7-76.4 76.4-80 80l33.9 33.9 17-17 80-80 17-17-17-17c-63.8-63.8-96.2-96.2-97-97L246.1 176zM185 193l17-17-33.9-33.9c-.8 .8-33.1 33.1-97 97l-17 17c.8 .8 33.1 33.1 97 97l17 17 33.9-33.9c-3.6-3.6-30.3-30.3-80-80l63-63z"],
    "vr-cardboard": [576, 512, [], "f729", "M576 96l-576 0 0 320 208 0 64-64 32 0 64 64 208 0 0-320zM80 240a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zm352-64a64 64 0 1 1 0 128 64 64 0 1 1 0-128z"],
    "pizza-slice": [512, 512, [], "f818", "M97.9 120.3L0 512 391.7 414.1c.2-4.7 .3-9.4 .3-14.1 0-154.6-125.4-280-280-280-4.7 0-9.4 .1-14.1 .3zM440 402l72-18C512 171.9 340.1 0 128 0L110 72c.7 0 1.3 0 2 0 181.1 0 328 146.9 328 328 0 .7 0 1.3 0 2zM176 208a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm64 128a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM96 384a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"],
    "spray-can": [576, 512, [], "f5bd", "M288 0l0 112-128 0 0-112 128 0zM64 256c0-53 43-96 96-96l128 0c53 0 96 43 96 96l0 256-320 0 0-256zm240 80a80 80 0 1 0 -160 0 80 80 0 1 0 160 0zM320 64a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM448 32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm64 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm32 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM512 256a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM448 128a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "nfc-trash": [576, 512, [], "e1fd", "M480 32l-448 0 0 448 274.9 0-4.9-64-206 0 0-320 88 0 0 48-40 0 0 224 128 0 0-66.7c-5 1.8-10.4 2.7-16 2.7-26.5 0-48-21.5-48-48 0-17.8 9.7-33.3 24-41.6l0-118.4 184 0 0 80 64 0 0-144zM368 176l0-32-88 0 0 64 67.5 0 16-32 4.5 0zm25.2 48.1c-4 7.9-9.3 18.6-16 32l-57.2 0 0 48 256 0 0-48-57.2 0c-6.7-13.4-12-24.1-16-32l-109.7 0zM360 544.1l176 0 16-208-208 0 16 208z"],
    "temperature-list": [512, 512, [], "e299", "M64 0l192 0 0 260.7c29.5 26.4 48 64.7 48 107.3 0 79.5-64.5 144-144 144S16 447.5 16 368c0-42.6 18.5-81 48-107.3L64 0zm96 432c35.3 0 64-28.7 64-64 0-26.9-16.5-49.9-40-59.3l0-116.7-48 0 0 116.7c-23.5 9.5-40 32.5-40 59.3 0 35.3 28.7 64 64 64zM352 32l128 0 0 64-160 0 0-64 32 0zm0 128l128 0 0 64-160 0 0-64 32 0zm0 128l128 0 0 64-128 0 0-64z"],
    "shovel-snow": [640, 512, [], "f7c3", "M502.6-22.6L480-45.3c-11.5 11.5-33.8 33.8-66.7 66.7-18.7 18.7-29.3 44.1-29.3 70.6 0 15.9 3.7 30.9 10.3 44.3l-113 113-89.4-89.4-192 224 192 192 224-192-89.4-89.4 113-113c13.4 6.6 28.4 10.3 44.3 10.3 26.5 0 51.9-10.5 70.6-29.3 33-33 55.2-55.2 66.7-66.7-2.9-2.9-42.4-42.4-118.6-118.6zM458.5 66.7L480 45.3 530.7 96 509.3 117.5c-6.7 6.7-15.9 10.5-25.4 10.5-19.8 0-35.9-16.1-35.9-35.9 0-9.5 3.8-18.6 10.5-25.4zM225 321l-80 80-17 17-33.9-33.9c.8-.8 33.1-33.1 97-97l17-17 33.9 33.9-17 17zm64 64l-80 80-17 17-33.9-33.9c.8-.8 33.1-33.1 97-97l17-17 33.9 33.9-17 17z"],
    "volume-low": [448, 512, [128264, "volume-down"], "f027", "M0 352l96 0 192 152 0-496-192 152-96 0 0 192zM350.3 218.7C361.1 227.6 368 241 368 256s-6.9 28.4-17.7 37.3l-9.4 7.6 28.8 38.4 10.9-8.8C402.1 312.9 416 286.1 416 256s-13.9-56.9-35.4-74.5l-10.9-8.8-28.8 38.4 9.4 7.6z"],
    "solar-system": [512, 512, [], "e02f", "M182.9 61.2c74-27.7 160.6-11.8 220.2 47.7 71.8 71.8 80.1 182.9 25.1 263.8-14.8-2.5-30.6 1.9-42.1 13.4-18.7 18.7-18.7 49.1 0 67.9s49.1 18.7 67.9 0c13.6-13.6 17.3-33.4 11.2-50.3 70.7-99.9 61.3-239.2-28.2-328.7-76-76-187.9-94.2-281.2-54.7 1.3 1.2 2.7 2.5 4 3.7 10.8 10.8 18.5 23.6 23.1 37.1zm-74 341.9c-71.8-71.8-80.1-182.9-25.1-263.8 14.8 2.5 30.6-1.9 42.1-13.4 18.7-18.7 18.7-49.1 0-67.9S76.8 39.3 58 58c-13.6 13.6-17.3 33.4-11.2 50.3-70.7 99.9-61.3 239.2 28.2 328.7 76 76 187.9 94.2 281.2 54.7-1.3-1.2-2.7-2.5-4-3.8-10.8-10.8-18.5-23.6-23.1-37.1-74 27.7-160.6 11.8-220.2-47.7zM256 320l64-64-64-64-64 64 64 64zm0-176c20.5 0 39.7 5.5 56.2 15.1-.2 10.5 3.7 21 11.7 29s18.6 11.9 29 11.7c9.6 16.5 15.1 35.7 15.1 56.2 0 61.9-50.1 112-112 112s-112-50.1-112-112 50.1-112 112-112zm86.1-22.9C317.2 105.2 287.7 96 256 96 167.6 96 96 167.6 96 256s71.6 160 160 160 160-71.6 160-160c0-31.7-9.2-61.2-25.1-86.1 3.4-13.3 0-28-10.4-38.4s-25.1-13.9-38.4-10.4z"],
    "cross": [384, 512, [128327, 10013], "f654", "M256 0l-128 0 0 128-128 0 0 128 128 0 0 256 128 0 0-256 128 0 0-128-128 0 0-128z"],
    "person": [384, 512, [129485, "male"], "f183", "M136.2 24a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm-11.4 88l134.8 0 9.6 13.2c74.3 102.4 111.5 153.6 111.7 153.9l-51.8 37.6c-9.3-12.8-28.3-39-56.9-78.4l0 305.7-64 0 0-208-32 0 0 208-64 0 0-305.7c-28.6 39.4-47.6 65.6-56.9 78.4l-51.8-37.6 18.8-25.9 92.9-128 9.6-13.2z"],
    "mp3-player": [384, 512, [], "f8ce", "M0 0L384 0 384 512 0 512 0 0zM192 320a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm0 128a96 96 0 1 0 0-192 96 96 0 1 0 0 192zM320 64l-256 0 0 128 256 0 0-128z"],
    "circle-bolt": [512, 512, [], "e0fe", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM120 272l200-168-32.4 136 104.4 0-200 168 32.4-136-104.4 0z"],
    "hourglass": [384, 512, [9203, 62032, "hourglass-empty"], "f254", "M32 0l-32 0 0 64 32 0 0 77.3 9.4 9.4 105.4 105.4-105.4 105.4-9.4 9.4 0 77.3-32 0 0 64 384 0 0-64-32 0 0-77.3-114.7-114.7 105.4-105.4 9.4-9.4 0-77.3 32 0 0-64-352 0zM288 64l0 50.7-96 96-96-96 0-50.7 192 0zM192 301.3l96 96 0 50.7-192 0 0-50.7 96-96z"],
    "trash-can-slash": [576, 512, ["trash-alt-slash"], "e2ad", "M32.3-33.8c6 6 27.9 27.9 65.8 65.8l94 0 16-48 160 0 16 48 128 0 0 64-350 0 48 48 270 0 0 270 81.2 81.2 17 17-33.9 33.9-17-17-512-512-17-17 33.9-33.9zM416.1 350l0-142-48 0 0 94 48 48zm-152-16.1l0 114.2 48 0 0-66.2 130.2 130.2-346.2 0 0-346.2 64 64 0 218.2 48 0 0-170.2 56 56z"],
    "user-beard": [448, 512, [], "e7a8", "M200 0l48 0c57.4 0 104 46.6 104 104l0 8 32 88 0 40-32 32 0 32-48 48-32 0-32 32-32 0-32-32-32 0-48-48 0-32-32-32 0-40 32-88 0-8C96 46.6 142.6 0 200 0zM304 128c0-11.4-2.4-22.2-6.7-32l-41.3 0-32-32-32 32-41.3 0c-4.3 9.8-6.7 20.6-6.7 32l0 16c0 12.7 3 24.8 8.3 35.5 20.4-20.4 30.8-30.8 31.5-31.5l80.6 0 5.9 5.9 25.6 25.6c5.3-10.7 8.3-22.7 8.3-35.5l0-16zm-40 85.3c1.9-1.1 3.8-2.3 5.5-3.5l-21.8-21.8-47.4 0-21.8 21.8c1.8 1.2 3.6 2.4 5.5 3.5 11.8 6.8 25.4 10.7 40 10.7s28.2-3.9 40-10.7zM16 512L71 346.9c30.2 30.2 47.9 47.9 53.1 53.1l32 0c12.6 12.6 23.3 23.3 32 32l71.8 0c8.7-8.7 19.4-19.4 32-32l32 0c5.2-5.2 22.9-22.9 53.1-53.1L432 512 16 512z"],
    "fish": [576, 512, [128031], "f578", "M336 80c-89.4 0-153.8 54.9-193.2 103.4L32 128 0 160 48 256 0 352 32 384 142.8 328.6C182.2 377.1 246.6 432 336 432 496 432 576 256 576 256S496 80 336 80zm80 144a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "drumstick-bite": [512, 512, [], "f6d7", "M160 176l0 102.5-58.4 58.3C90.9 326.4 76.2 320 60 320 26.9 320 0 346.9 0 380s26.9 60 60 60l12 0 0 12c0 33.1 26.9 60 60 60s60-26.9 60-60c0-16.2-6.4-30.9-16.8-41.7L233.5 352 336 352c34.3 0 66.3-9.8 93.4-26.8-8.6-15.8-13.4-33.9-13.4-53.2 0-56.2 41.4-102.8 95.4-110.8-7.5-90.3-83.2-161.2-175.4-161.2-97.2 0-176 78.8-176 176z"],
    "file-jpg": [576, 512, [], "e646", "M272 0l-240 0 0 512 144 0 0-176 240 0 0-192-144-144zm85.5 176L240 176 240 58.5 357.5 176zM272 548c28.7 0 52-23.3 52-52l0-116-40 0 0 116c0 6.6-5.4 12-12 12s-12-5.4-12-12l0-16-40 0 0 16c0 28.7 23.3 52 52 52zm96-168l-20 0 0 168 40 0 0-48 12 0c33.1 0 60-26.9 60-60s-26.9-60-60-60l-32 0zm32 80l-12 0 0-40 12 0c11 0 20 9 20 20s-9 20-20 20zm76-36l0 80c0 24.3 19.7 44 44 44l16 0c24.3 0 44-19.7 44-44l0-44-48 0 0 40 8 0 0 4c0 2.2-1.8 4-4 4l-16 0c-2.2 0-4-1.8-4-4l0-80c0-2.2 1.8-4 4-4l16 0c2.2 0 4 1.8 4 4l0 8 40 0 0-8c0-24.3-19.7-44-44-44l-16 0c-24.3 0-44 19.7-44 44z"],
    "chart-simple": [512, 512, [], "e473", "M192 32l128 0 0 448-128 0 0-448zM0 224l128 0 0 256-128 0 0-256zM512 96l0 384-128 0 0-384 128 0z"],
    "circle-ellipsis-vertical": [512, 512, [], "e10b", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm32-320l-64 0 0-64 64 0 0 64zm0 192l-64 0 0-64 64 0 0 64zm0-160l0 64-64 0 0-64 64 0z"],
    "atom": [448, 512, [9883], "f5d2", "M224 328c9.4-4.8 19-10.2 28.8-16 12.1-7.3 23.6-14.8 34.2-22.4 .7-10.8 1-22 1-33.6s-.4-22.7-1-33.6c-10.6-7.6-22.1-15.1-34.2-22.4-9.7-5.8-19.3-11.2-28.8-16-9.4 4.8-19 10.2-28.8 16-12.1 7.3-23.6 14.8-34.2 22.4-.7 10.8-1 22-1 33.6s.4 22.7 1 33.6c10.6 7.6 22.1 15.1 34.2 22.4 9.7 5.8 19.3 11.2 28.8 16zm190-72c33 45.2 44.3 90.9 23.6 128-20.2 36.3-62.5 49.3-115.2 43.2-22 52.1-55.7 84.8-98.4 84.8s-76.4-32.7-98.4-84.8C72.9 433.3 30.6 420.3 10.4 384-10.3 346.9 1 301.2 34 256 1 210.8-10.3 165.1 10.4 128 30.6 91.7 72.9 78.7 125.6 84.8 147.6 32.7 181.2 0 224 0s76.4 32.7 98.4 84.8c52.7-6.1 95 6.8 115.2 43.2 20.7 37.1 9.4 82.8-23.6 128zm-65.8 67.4c-1.7 14.2-3.9 28-6.7 41.2 31.8 1.4 38.6-8.7 40.2-11.7 2.3-4.2 7-17.9-11.9-48.1-6.8 6.3-14 12.5-21.6 18.6zM224 398.8c-11.8 5.1-23.4 9.7-34.9 13.5 16.7 33.8 31 35.7 34.9 35.7s18.1-1.9 34.9-35.7c-11.4-3.9-23.1-8.4-34.9-13.5zM341.5 147.5c2.8 13.1 5 26.9 6.7 41.2 7.6 6.1 14.8 12.3 21.6 18.6 18.9-30.2 14.2-44 11.9-48.1-1.6-2.9-8.4-13-40.2-11.7zM258.9 99.7C242.1 65.9 227.9 64 224 64s-18.1 1.9-34.9 35.7c11.4 3.9 23.1 8.4 34.9 13.5 11.8-5.1 23.4-9.7 34.9-13.5zm-159 88.9c1.7-14.3 3.9-28 6.7-41.2-31.8-1.4-38.6 8.7-40.2 11.7-2.3 4.2-7 17.9 11.9 48.1 6.8-6.3 14-12.5 21.6-18.6zM78.2 304.8c-18.9 30.2-14.2 44-11.9 48.1 1.6 2.9 8.4 13 40.2 11.7-2.8-13.1-5-26.9-6.7-41.2-7.6-6.1-14.8-12.3-21.6-18.6zM224 296l-40-40 40-40 40 40-40 40z"],
    "square-malaysian-ringgit": [448, 512, [], "e748", "M448 32l-448 0 0 448 448 0 0-448zM88 160l54.7 0c37.6 0 68 30.4 68 68 0 24.1-12.5 45.2-31.4 57.3 12.7 22.2 22.5 39.4 29.5 51.6l-41.7 23.8c-5.7-10-18.1-31.6-37-64.7l-18.1 0 0 56-48 0 0-192 24 0zm54.7 88c11 0 20-9 20-20s-9-20-20-20l-30.7 0 0 40 30.7 0zM224 352l0-192 42.1 0c.8 1.2 13.5 19.3 37.9 54.1 24.4-34.9 37.1-52.9 37.9-54.1l42.1 0 0 192-48 0 0-99.9c-7 10-17.7 25.2-32 45.7-14.3-20.5-25-35.7-32-45.7l0 99.9-48 0z"],
    "print-magnifying-glass": [640, 512, ["print-search"], "f81a", "M400.4 0l80 80 0 64-384 0 0-144 304 0zM32.4 192l408 0 0 .1c-90.1 0-163.6 70.9-167.8 159.9l-112.2 0 0 96 136.8 0c17 27.7 41.8 50 71.3 64l-272.2 0 0-128-64 0 0-192zm408 240.1a72 72 0 1 0 0-144 72 72 0 1 0 0 144zm0 48c-66.3 0-120-53.7-120-120s53.7-120 120-120 120 53.7 120 120c0 24.5-7.3 47.2-19.9 66.2 47.9 47.9 73.8 73.8 77.8 77.8L584.4 538c-4-4-29.9-29.9-77.8-77.8-19 12.6-41.7 19.9-66.2 19.9z"],
    "image-polaroid": [448, 512, [], "f8c4", "M448 32l-448 0 0 448 448 0 0-448zM384 96l0 256-320 0 0-256 320 0zM160 160a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM352 272l-128-112-128 112 0 48 256 0 0-48z"],
    "square-terminal": [448, 512, [], "e32a", "M0 32l448 0 0 448-448 0 0-448zM54.1 176l80 80c-49.7 49.7-76.4 76.4-80 80l33.9 33.9 17-17c63.8-63.8 96.2-96.2 97-97-.8-.8-33.1-33.1-97-97l-17-17-33.9 33.9zM216 336l-24 0 0 48 192 0 0-48-168 0z"],
    "lightbulb-message": [576, 512, [], "e687", "M240 240l0 144-144 0 0-25.7C38.6 325.1 0 263.1 0 192 0 86 86 0 192 0S384 86 384 192c0 16.6-2.1 32.7-6 48l-138 0zM96 432l144 0 0 96-144 0 0-96zm88-320l8 0 0-48-8 0C117.7 64 64 117.7 64 184l0 8 48 0 0-8c0-39.8 32.2-72 72-72zM576 288l0 224-96 0-48 64-48-64-96 0 0-224 288 0z"],
    "person-limbs-wide": [448, 512, [], "e787", "M168 24a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zM144 179l-130-88.6 36-52.9 132.8 90.4 82.4 0 132.8-90.4 36 52.9-130 88.6 0 135.3 62.1 170.7 10.9 30.1-60.1 21.9-10.9-30.1-56.3-154.9-51.2 0-56.3 154.9-10.9 30.1-60.1-21.9 10.9-30.1 62.1-170.7 0-135.3z"],
    "hands-holding-diamond": [640, 512, ["hand-receiving"], "f47c", "M320 256L448 128 320 0 192 128 320 256zM80 64l-80 0 0 301.3 9.4 9.4 128 128 9.4 9.4 141.3 0 0-173.3-9.4-9.4C125.1 175.9 201.5 252.2 160 210.7L114.7 256c48.8 48.8 65.1 65.1 91 91L164.1 374.8 80 290.7 80 64zm480 0l0 226.7-84.1 84.1-41.7-27.8c102.9-102.9 58.7-58.7 91-91L480 210.7c-44.2 44.2-69.7 69.7-118.6 118.6l-9.4 9.4 0 173.3 141.3 0 9.4-9.4 128-128 9.4-9.4 0-301.3-80 0z"],
    "circle-j": [512, 512, [], "e112", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm80-344l0 112c0 48.6-39.4 88-88 88s-88-39.4-88-88l0-24 48 0 0 24c0 22.1 17.9 40 40 40s40-17.9 40-40l0-136 48 0 0 24z"],
    "pedestal": [448, 512, [], "e20d", "M416 0l-384 0 0 448-32 0 0 64 448 0 0-64-32 0 0-448zM128 72a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM296 96a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"],
    "p": [320, 512, [112], "50", "M64 288l96 0c53 0 96-43 96-96s-43-96-96-96l-96 0 0 192zM0 352L0 32 160 32c88.4 0 160 71.6 160 160S248.4 352 160 352l-96 0 0 128-64 0 0-128z"],
    "square-equals": [448, 512, [], "e6b6", "M448 32l-448 0 0 448 448 0 0-448zM128 176l192 0 0 48-192 0 0-48zm0 112l192 0 0 48-192 0 0-48z"],
    "dagger": [384, 512, [], "f6cb", "M224-32l0 128 160 0 0 48c0 26.5-21.5 48-48 48-20.9 0-38.7-13.4-45.3-32L93.3 160c-6.6 18.6-24.4 32-45.3 32-26.5 0-48-21.5-48-48l0-48 160 0 0-128 64 0zM128 208l128 0 0 272-64 64-64-64 0-272z"],
    "jet-fighter-up": [512, 512, [], "e518", "M200 64l0 118-152 114 0-72-48 0 0 192 48 0 0-32 152 0 0 54.4-72 57.6 0 48 104 0 0-64 48 0 0 64 104 0 0-48-72-57.6 0-54.4 152 0 0 32 48 0 0-192-48 0 0 72-152-114 0-118-40-96-32 0-40 96z"],
    "field-hockey-stick-ball": [576, 512, [127953, "field-hockey"], "f44c", "M464.1 544a80 80 0 1 1 0-160 80 80 0 1 1 0 160zm-2.9-345.5L297 447.1c-26.7 40.5-72 64.9-120.5 64.9-79.8 0-144.4-64.7-144.4-144.4l0-79.6 112 0 0 79.6c0 17.9 14.5 32.4 32.4 32.4 10.9 0 21.1-5.5 27.1-14.6l162.6-246.3 95 59.4zM565.7 40.1c-17.8 27-43.9 66.4-78.1 118.3L392.6 99c35.5-53.8 62-94 79.6-120.6l93.5 61.7z"],
    "computer-mouse-button-right": [384, 512, [], "e7ce", "M168 216L168 0 0 0 0 352c0 88.4 71.6 160 160 160l64 0c88.4 0 160-71.6 160-160l0-112-216 0 0-24zm216-24l0-192-168 0 0 192 168 0z"],
    "plug-circle-xmark": [640, 512, [], "e560", "M224-32l0 128 128 0 0-128 64 0 0 128 96 0 0 64-32 0 0 48.7c-98.6 8.1-176 90.7-176 191.3 0 27.3 5.7 53.3 16 76.9l0 35.1-64 0 0-98.7C165.2 398.1 96 319.1 96 224l0-64-32 0 0-64 96 0 0-128 64 0zM496 256a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm55.3 111.3L562.6 356 540 333.4c-4 4-18.7 18.6-44 44-25.4-25.4-40-40-44-44L429.4 356c4 4 18.6 18.7 44 44-25.4 25.4-40 40-44 44L452 466.6c4-4 18.7-18.6 44-44 25.4 25.4 40 40 44 44L562.6 444c-4-4-18.6-18.7-44-44l32.7-32.7z"],
    "sheet-plastic": [384, 512, [], "e571", "M0 0L0 512 240 512 384 368 384 0 0 0zM208 453.5L208 336 325.5 336 208 453.5zM153 105c-37.2 37.2-58.8 58.8-65 65L54.1 136c6.1-6.1 27.8-27.8 65-65l17-17 33.9 33.9-17 17zm96 32l-112 112-17 17-33.9-33.9 17-17 112-112 17-17 33.9 33.9-17 17z"],
    "v": [384, 512, [118], "56", "M0 32L162.1 459.4 169.9 480 214.1 480 221.9 459.4 384 32 315.6 32 192 357.8 68.4 32 0 32z"],
    "list": [512, 512, ["list-squares"], "f03a", "M112 48l-96 0 0 96 96 0 0-96zm80 16l-32 0 0 64 352 0 0-64-320 0zm0 160l-32 0 0 64 352 0 0-64-320 0zm0 160l-32 0 0 64 352 0 0-64-320 0zM16 208l0 96 96 0 0-96-96 0zm96 160l-96 0 0 96 96 0 0-96z"],
    "olive-branch": [640, 512, [], "e317", "M128 0C48 0 0 64 0 64s31.2 36.4 85.2 50.5C34.5 141.4 0 194.6 0 256l0 32 32 0c86.6 0 157.1-68.7 159.9-154.6L373.4 48 640 48 640 0 368 0c-3.5 0-7 .8-10.2 2.3L247.4 54.2C230.3 36.3 188.2 0 128 0zM336 512c79.5 0 144-86 144-192s-64.5-192-144-192-144 86-144 192 64.5 192 144 192zm129.7-40.2c52.9 16.5 105.5 8.4 139.6-27 56.2-58.3 41-168.6-33.9-246.4-42.9-44.5-96.1-68.7-144.2-70.3 13.6 10.4 25.7 22.9 36.2 36.9 30.6 40.8 48.6 95.7 48.6 155 0 57.8-17.1 111.4-46.3 151.8z"],
    "gif": [512, 512, [], "e190", "M512 64l-512 0 0 384 512 0 0-384zM120 216l0 80c0 4.4 3.6 8 8 8l16 0c4.4 0 8-3.6 8-8l0-56 48 0 0 56c0 30.9-25.1 56-56 56l-16 0c-30.9 0-56-25.1-56-56l0-80c0-30.9 25.1-56 56-56l64 0 0 48-64 0c-4.4 0-8 3.6-8 8zm168-56l0 192-48 0 0-192 48 0zm64 0l104 0 0 48-80 0 0 32 64 0 0 48-64 0 0 64-48 0 0-192 24 0z"],
    "hose-reel": [576, 512, [], "e41a", "M288 64C182 64 96 150 96 256s86 192 192 192c40.8 0 78.6-12.7 109.7-34.4l36.6 52.5C392.8 495 342.3 512 288 512 146.6 512 32 397.4 32 256S146.6 0 288 0 544 114.6 544 256l0 96 32 0 0 48-26.3 0-9.1 64 19.4 0 0 48-96 0 0-48 19.4 0-9.1-64-26.3 0 0-48 32 0 0-96c0-106-86-192-192-192zm0 282a90 90 0 1 0 0-180 90 90 0 1 0 0 180zm0-234a144 144 0 1 1 0 288 144 144 0 1 1 0-288zM240 256a48 48 0 1 1 96 0 48 48 0 1 1 -96 0z"],
    "circle-s": [512, 512, [], "e121", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM234.5 144l93.5 0 0 48-93.5 0c-10.2 0-18.5 8.3-18.5 18.5 0 9.3 6.9 17.2 16.2 18.3l53.6 6.7c33.3 4.2 58.2 32.4 58.2 66 0 36.7-29.8 66.5-66.5 66.5l-101.5 0 0-48 101.5 0c10.2 0 18.5-8.3 18.5-18.5 0-9.3-6.9-17.2-16.2-18.3l-53.6-6.7c-33.3-4.2-58.2-32.4-58.2-66 0-36.7 29.8-66.5 66.5-66.5z"],
    "square-m": [448, 512, [], "e276", "M448 32l-448 0 0 448 448 0 0-448zM112 168l0-24 36.2 0 7.2 9.8 68.6 93.6 68.6-93.6 7.2-9.8 36.2 0 0 224-48 0 0-126.7c-34 46.3-55.3 75.4-64 87.3-8.7-11.8-30-40.9-64-87.3l0 126.7-48 0 0-200z"],
    "circle-caret-left": [512, 512, ["caret-circle-left"], "f32e", "M512 256a256 256 0 1 0 -512 0 256 256 0 1 0 512 0zm-360 0l168-136 0 272-168-136z"],
    "circle-quarters": [512, 512, [], "e3f8", "M120.2 391.8L256 256 391.8 391.8C426.5 357 448 309 448 256s-21.5-101-56.2-135.8L256 256 120.2 120.2C85.5 155 64 203 64 256s21.5 101 56.2 135.8zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0z"],
    "solar-panel": [576, 512, [], "f5ba", "M70.7 32l435.3 0 5.6 25.1 64 288 8.7 38.9-263.9 0 0 64 96 0 0 64-256 0 0-64 96 0 0-64-263.9 0 8.7-38.9 64-288 5.6-25.1zM91.8 232l-19.6 88 106.7 0 7.3-88-94.5 0zm10.7-48l87.8 0 7.3-88-75.6 0-19.6 88zm132 48l-7.3 88 122.5 0-7.3-88-107.8 0zm103.8-48l-7.3-88-85.2 0-7.3 88 99.8 0zm52.2 48l7.3 88 106.7 0-19.6-88-94.5 0zm83.8-48l-19.6-88-75.6 0 7.3 88 87.8 0z"],
    "land-mine-on": [576, 512, [], "e51b", "M312.3 0l0 152-48 0 0-176 48 0 0 24zm-152 256l256 0 0 64 128 0 0 192-512 0 0-192 128 0 0-64zM25.6 94.7c.6 .4 39.3 26.2 116 77.3l20 13.3-26.6 39.9c-.6-.4-39.3-26.2-116-77.3L-1 134.7 25.6 94.7zM531 108l20-13.3 26.6 39.9-20 13.3c-76.7 51.1-115.3 76.9-116 77.3L415 185.3c.6-.4 39.3-26.2 116-77.3z"],
    "ballot": [384, 512, [], "f732", "M384 0L0 0 0 512 384 512 384 0zM64 96l64 0 0 64-64 0 0-64zm0 128l64 0 0 64-64 0 0-64zm64 128l0 64-64 0 0-64 64 0zm48 8l144 0 0 48-144 0 0-48zm24-256l120 0 0 48-144 0 0-48 24 0zM176 232l144 0 0 48-144 0 0-48z"],
    "gift-card": [512, 512, [], "f663", "M321.5 68.8C329.1 55.9 342.9 48 357.8 48l2.2 0c22.1 0 40 17.9 40 40s-17.9 40-40 40l-73.3 0 34.8-59.2zm-131 0l34.8 59.2-73.3 0c-22.1 0-40-17.9-40-40s17.9-40 40-40l2.2 0c14.9 0 28.8 7.9 36.3 20.8zm89.6-24.3l-24.1 41-24.1-41C215.7 16.9 186.1 0 154.2 0L152 0c-48.6 0-88 39.4-88 88 0 14.4 3.5 28 9.6 40l-73.6 0 0 352 512 0 0-352-73.6 0c6.1-12 9.6-25.6 9.6-40 0-48.6-39.4-88-88-88l-2.2 0c-31.9 0-61.5 16.9-77.7 44.4zM448 368l0 48-384 0 0-48 384 0zm0-64l-384 0 0-112 138 0c-8.6 11.5-17.8 23.7-27.6 36.8l38.4 28.8c7.2-9.6 21.6-28.8 43.2-57.6 21.6 28.8 36 48 43.2 57.6l38.4-28.8-27.6-36.8 138 0 0 112z"],
    "circle-user-circle-question": [640, 512, [], "e7a4", "M496 208c-77.5 0-144.3 45.9-174.6 112l-145.4 0-23.9 71.6c34.8 34.8 82.8 56.4 135.9 56.4 7.4 0 14.6-.4 21.7-1.2 5.5 21.9 14.8 42.4 27.1 60.6-15.8 3-32.1 4.6-48.8 4.6-141.4 0-256-114.6-256-256S146.6 0 288 0c126.8 0 232.1 92.2 252.4 213.2-14.3-3.4-29.1-5.2-44.4-5.2zM288 272a72 72 0 1 0 0-144 72 72 0 1 0 0 144zm64 128a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm144-56c13.3 0 24 10.7 24 24 0 7.2-4.2 13.7-10.8 16.6-14.8 6.6-24.6 10.9-29.2 13l0 26.4 32 0 0-5.6 10.2-4.5c18.1-8.1 29.8-26 29.8-45.9 0-30.9-25.1-56-56-56s-56 25.1-56 56l32 0c0-13.3 10.7-24 24-24zM480 480l32 0 0-32-32 0 0 32z"],
    "headphones": [448, 512, [127911, 62863, "headphones-alt", "headphones-simple"], "f025", "M64 224c0-88.4 71.6-160 160-160s160 71.6 160 160l0 32-96 0 0 224 64 0c53 0 96-43 96-96l0-160C448 100.3 347.7 0 224 0S0 100.3 0 224L0 384c0 53 43 96 96 96l64 0 0-224-96 0 0-32z"],
    "bus": [448, 512, [128653], "f207", "M448 0l-448 0 0 448 48 0 0 64 80 0 0-64 192 0 0 64 80 0 0-64 48 0 0-448zM248 144l136 0 0 112-136 0 0-112zm-48 0l0 112-136 0 0-112 136 0zM96 320a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm256 0a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM152 48l144 0 0 48-144 0 0-48z"],
    "file-powerpoint": [384, 512, [], "f1c4", "M0 0L240 0 384 144 384 512 0 512 0 0zM208 58.5L208 176 325.5 176 208 58.5zM152 256l-24 0 0 192 48 0 0-48 24 0c39.8 0 72-32.2 72-72s-32.2-72-72-72l-48 0zm48 96l-24 0 0-48 24 0c13.3 0 24 10.7 24 24s-10.7 24-24 24z"],
    "messages": [576, 512, ["comments-alt"], "f4b6", "M0-32l384 0 0 336-176 0-112 80 0-80-96 0 0-336zM192 464l0-89.6 31.4-22.4 208.6 0 0-224 144 0 0 336-96 0 0 80-112-80-176 0z"],
    "circle-ruble": [512, 512, [], "e6e5", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM176 120l104 0c48.6 0 88 39.4 88 88s-39.4 88-88 88l-56 0 0 24 72 0 0 32-72 0 0 40-48 0 0-40-40 0 0-32 40 0 0-40-40 0 0-32 40 0 0-128zM280 248c22.1 0 40-17.9 40-40s-17.9-40-40-40l-56 0 0 80 56 0z"],
    "barcode-read": [512, 512, [], "f464", "M24 0l-24 0 0 160 48 0 0-112 112 0 0-48-136 0zM376 0l-24 0 0 48 112 0 0 112 48 0 0-160-136 0zM48 376l0-24-48 0 0 160 160 0 0-48-112 0 0-88zm464 0l0-24-48 0 0 112-112 0 0 48 160 0 0-136zM96 128l0 256 64 0 0-256-64 0zm176 0l0 256 48 0 0-256-48 0zm144 0l-64 0 0 256 64 0 0-256zm-224 0l0 256 32 0 0-256-32 0z"],
    "quote-left": [448, 512, [8220, "quote-left-alt"], "f10d", "M0 216C0 149.7 53.7 96 120 96l40 0 0 64-40 0c-30.9 0-56 25.1-56 56l0 8 128 0 0 192-192 0 0-200zm256 0c0-66.3 53.7-120 120-120l40 0 0 64-40 0c-30.9 0-56 25.1-56 56l0 8 128 0 0 192-192 0 0-200z"],
    "screencast": [512, 512, [], "e23e", "M448 96l-384 0 0 82.7c-12.6-1.8-25.5-2.7-38.7-2.7l-25.3 0 0-144 512 0 0 448-208 0 0-25.3c0-13.1-.9-26-2.7-38.7l146.7 0 0-320zM24 224c128.1 0 232 103.9 232 232l0 24-48 0 0-24c0-101.6-82.4-184-184-184l-24 0 0-48 24 0zm8 192a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM0 320l24 0c75.1 0 136 60.9 136 136l0 24-48 0 0-24c0-48.6-39.4-88-88-88l-24 0 0-48z"],
    "ski-boot": [512, 512, [], "e3cc", "M368 144l-96 0 0 48 85.3 0-10.7 48-90.7 0 0 48 80 0 144 64 0 96 32 0 0 64-512 0 0-64 24.8-128.8c.8-.1 1.6-.2 2.5-.3 5.8-.9 13.9-2.5 23.6-5.3 19.4-5.7 45.3-16.3 72.4-36.2 53.2-39.1 108.3-111.9 130.6-245.3l74.2 0 8-32 64 0-32 144zM205 32c-21.2 117.5-69.3 176.6-110.3 206.7-21.9 16.1-42.5 24.5-57.4 28.8-1 .3-1.9 .5-2.8 .7L80 32 205 32z"],
    "family-pants": [448, 512, [], "e302", "M96 128A64 64 0 1 0 96 0 64 64 0 1 0 96 128zM32 512l96 0 0-64-32 0 0-240 37.5 0c-3.5-10-5.5-20.8-5.5-32 0-5.5 .5-10.8 1.3-16L0 160 0 352 32 352 32 512zm384 0l0-160 32 0 0-192-129.3 0c.9 5.2 1.3 10.5 1.3 16 0 11.2-1.9 22-5.5 32l37.5 0 0 240-32 0 0 64 96 0zM352 128a64 64 0 1 0 0-128 64 64 0 1 0 0 128zM224 224a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm80 176l0-144-160 0 0 144 32 0 0 112 96 0 0-112 32 0z"],
    "eye-dropper-full": [512, 512, [], "e172", "M341.6 29.2L240.1 130.8C236 126.7 225.3 116 208 98.7l-45.3 45.3 22.6 22.6 160 160 22.6 22.6 45.3-45.3c-17.3-17.3-28-28-32.1-32.1L482.8 170.4c39-39 39-102.2 0-141.1s-102.2-39-141.1 0zM32 344l0 88-32 48 32 32 48-32 88 0 131.4-131.4-136-136-131.4 131.4z"],
    "chevron-down": [512, 512, [], "f078", "M256.3 429.3l214.6-214.6 22.6-22.6-45.3-45.3-22.6 22.6-169.4 169.4-169.4-169.4-22.6-22.6-45.3 45.3 22.6 22.6 192 192 22.6 22.6z"],
    "earth-asia": [512, 512, [127759, "globe-asia"], "f57e", "M50.4 288l77.6 0 32 32 64 0 0-96 48 0 0-80 32-32 0-58.4c-15.4-3.6-31.5-5.6-48-5.6-114.9 0-208 93.1-208 208 0 10.9 .8 21.6 2.4 32zM454 320l-38 0 0-32-64 0-64 64 0 64 64 0 15.6 15.6C408 405.8 439 366.5 454 320zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm128 96l0 32 64 0 0-32-64 0zm160-96l-32 0 0 64 32 0 0-64zm32-128l0 64 32 0 0-64-32 0z"],
    "cent-sign": [384, 512, [], "e3f5", "M240.5 0l0 57.4c55.5 6.6 104.1 36.1 136 78.5l-51.2 38.4c-24.9-33.1-64.3-54.4-108.8-54.4-75.1 0-136 60.9-136 136s60.9 136 136 136c44.5 0 83.9-21.3 108.8-54.4L376.5 376c-31.9 42.5-80.5 71.9-136 78.5l0 57.4-64 0 0-60c-91.3-18.5-160-99.2-160-196S85.2 78.5 176.5 60l0-60 64 0z"],
    "computer-mouse-button-left": [384, 512, [], "e7cd", "M216 216l0-216 168 0 0 352c0 88.4-71.6 160-160 160l-64 0C71.6 512 0 440.4 0 352l0-112 216 0 0-24zM0 192L0 0 168 0 168 192 0 192z"],
    "shield-cat": [512, 512, [], "e572", "M256 0l11.6 4.5 207.5 80.5 19.2 7.4 1.2 20.5c2.9 50-4.9 126.3-37.3 200.9-32.7 75.3-91.1 150-189.4 192.6l-12.7 5.5-12.7-5.5C144.9 463.9 86.6 389.2 53.9 313.9 21.5 239.3 13.7 162.9 16.6 113L17.8 92.5 37 85 244.5 4.5 256 0zM224 208l-64-64 0 128c0 53 43 96 96 96s96-43 96-96l0-128-64 64-64 0zm-8 48a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm64 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"],
    "school-circle-check": [640, 512, [], "e56b", "M128 128l-128 0 0 384 340 0c-10.5-14.6-19-30.7-25.1-48l-90.9 0 0-128 90.9 0c26.4-74.6 97.5-128 181.1-128 28.6 0 55.6 6.2 80 17.4l0-97.4-128 0-160-128-160 128zm0 256l-64 0 0-64 64 0 0 64zM64 256l0-64 64 0 0 64-64 0zM288 128a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM640 400a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-73.6-51.5l-9.4 12.9-64 88-11 15.1c-4.4-4.4-22.1-22.1-53.2-53.2L417.4 400 440 377.4c5 5 17.7 17.7 38.1 38.1l53-72.9 9.4-12.9 25.9 18.8z"],
    "martini-glass": [512, 512, [127864, "glass-martini-alt"], "f57b", "M16 96l-16-16 0-48 512 0 0 48-224 224 0 144 96 0 0 64-256 0 0-64 96 0 0-144-13.3-13.3-194.7-194.7zm138.5 48l203 0 48-48-299 0 48 48z"],
    "user-unlock": [576, 512, [], "e058", "M224 248a120 120 0 1 0 0-240 120 120 0 1 0 0 240zm80 104l0-48-224 0-64 208 288 0 0-160zm192-48l48 0c0-44.2-35.8-80-80-80s-80 35.8-80 80l0 48-32 0 0 192 224 0 0-192-144 0 0-48c0-17.7 14.3-32 32-32s32 14.3 32 32z"],
    "plug": [448, 512, [128268], "f1e6", "M160-32l0 128 128 0 0-128 64 0 0 128 96 0 0 64-32 0 0 64c0 95.1-69.2 174.1-160 189.3l0 98.7-64 0 0-98.7C101.2 398.1 32 319.1 32 224l0-64-32 0 0-64 96 0 0-128 64 0z"],
    "spinner-third": [512, 512, [], "f3f4", "M477.7 384C499.5 346.4 512 302.6 512 256 512 114.6 397.4 0 256 0l0 64c106 0 192 86 192 192 0 35-9.4 67.8-25.7 96l55.4 32z"],
    "wind-warning": [640, 512, ["wind-circle-exclamation"], "f776", "M256 32c118.3 0 215.2 91.8 223.4 208l-143.4 0 0 144 96 0 0 10.5C391 446.5 327.4 480 256 480 132.3 480 32 379.7 32 256S132.3 32 256 32zM520 288c48.6 0 88 39.4 88 88s-39.4 88-88 88l-40 0 0-48 40 0c22.1 0 40-17.9 40-40s-17.9-40-40-40l-136 0 0-48 136 0zM228 380l56 0 0-56-56 0 0 56zm8.8-92l38.4 0 12.8-160-64 0 12.8 160zM552 48c48.6 0 88 39.4 88 88s-39.4 88-88 88l-25.8 0c-1.9-16.5-5.3-32.5-10.1-48l35.9 0c22.1 0 40-17.9 40-40s-17.9-40-40-40l-40 0 0-48 40 0z"],
    "panorama": [576, 512, [], "e209", "M288 88C144 88 0 48 0 48L0 464s144-40 288-40 288 40 288 40l0-416S432 88 288 88zM499.2 381.4l-1.5-.3C441.6 370.7 365.4 360 288 360S134.4 370.7 78.3 381.1L75.5 381.6 176 256 220.6 311.8 336 144 499.2 381.4zM112 136a40 40 0 1 1 0 80 40 40 0 1 1 0-80z"],
    "clock-rotate-left": [576, 512, ["history"], "f1da", "M288 64c106 0 192 86 192 192S394 448 288 448c-65.2 0-122.9-32.5-157.6-82.3L77.9 402.3C124.1 468.6 201 512 288 512 429.4 512 544 397.4 544 256S429.4 0 288 0C202.3 0 126.5 42.1 80 106.7l0-58.7-64 0 0 176 176 0 0-64-70.3 0C154.9 102.6 217 64 288 64zm24 64l-48 0 0 137.9 7 7c50.5 50.5 77.5 77.5 81 81L385.9 320c-4.6-4.6-29.3-29.3-73.9-73.9L312 128z"],
    "wifi-weak": [128, 512, ["wifi-1"], "f6aa", "M112 432c0 26.5-21.5 48-48 48s-48-21.5-48-48 21.5-48 48-48 48 21.5 48 48z"],
    "waveform": [576, 512, [], "f8f1", "M256.5 26.4l4.7-26.4 53.6 0 4.7 26.4 47.4 265.5 33.5-201.1 4.5-26.7 52.1 0 6.1 24.2 41.9 167.8 55 0 0 64-105 0c-3.3-13.1-8.8-35.4-16.7-67l-38.7 232.2-4.5 26.7-53.9 0-4.7-26.4-48.5-271.6-48.5 271.6-4.7 26.4-53.9 0-4.5-26.7-38.7-232.2c-7.9 31.6-13.5 53.9-16.7 67l-105 0 0-64 55 0 41.9-167.8 6.1-24.2 52.1 0 4.5 26.7 33.5 201.1 47.4-265.5z"],
    "video-question": [576, 512, [], "e777", "M32 64l384 0 0 384-384 0 0-384zM464 341.3l0-170.7 112-74.7 0 320-112-74.7zM224 181.2c17.7 0 32 14.3 32 32 0 26.9-28.8 31-49.9 34l-3.3 .5 0 53.5 42.4 0 0-18.3c30.4-10.6 53.2-36.1 53.2-69.6 0-41.1-33.3-74.4-74.4-74.4s-74.4 33.3-74.4 74.4l42.4 0c0-17.7 14.3-32 32-32zM200 328l0 48 48 0 0-48-48 0z"],
    "ticket-airline": [576, 512, ["ticket-perforated-plane", "ticket-plane"], "e29a", "M0 64l576 0 0 144c-26.5 0-48 21.5-48 48s21.5 48 48 48l0 144-576 0 0-384zM416 184a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm0 96a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm24 72a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM136 224l-24-32-32 0 16 64-16 64 32 0 24-32 40 0-32 80 56 0 56-80 64 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0-56-80-56 0 32 80-40 0z"],
    "arrow-u-turn-up-right": [576, 512, [], "e7ee", "M400.2-29.2L355 16 435 96 224.2 96C121.5 96 37.6 176.7 32.5 278.1l-.2 9.9c0 106 86 192 192 192l256 0 0-64-256 0c-70.7 0-128-57.3-128-128l.2-6.6C99.8 213.8 155.8 160 224.2 160l210.7 0-80 80 45.3 45.3 157.2-157.3-157.2-157.2z"],
    "link-simple": [576, 512, [], "e1cd", "M0 256C0 150 86 64 192 64l64 0 0 64-64 0c-70.7 0-128 57.3-128 128s57.3 128 128 128l64 0 0 64-64 0C86 448 0 362 0 256zm576 0c0 106-86 192-192 192l-64 0 0-64 64 0c70.7 0 128-57.3 128-128S454.7 128 384 128l-64 0 0-64 64 0c106 0 192 86 192 192zM192 224l224 0 0 64-256 0 0-64 32 0z"],
    "rectangle-wide": [640, 512, [], "f2fc", "M0 64l640 0 0 384-640 0 0-384z"],
    "pig": [640, 512, [128022], "f706", "M453.1 46l74.9-14 0 46c0 19.7-9 37.8-23.6 49.7 6.4 4.9 12.7 10.1 18.6 15.7 17.6-15.9 28.5-38.6 29-63.3l56 0 0 32c0 32.8-24.6 59.8-56.3 63.5l6.8 9C570 200 585 212.5 602.2 221.1l5.8 2.9 32 0 0 144-67.5 0c-22.2 21.2-49.7 36.2-79.8 43.3l-19.6 68.7-89.1 0 0-64-112 0 0 64-89.1 0-27.9-97.6C110.3 358 80 310.5 80 256l0-16-32.6 0c-26.2 0-47.4-21.2-47.4-47.4 0-21.8 14.8-40.7 35.9-46l8.2-2 7.8 31-8.2 2c-6.9 1.7-11.7 7.9-11.7 15 0 8.5 6.9 15.4 15.4 15.4l35.8 0C98 135 162.6 80 240 80l122.4 0c14.6 0 29 1.4 43.1 4 8.4-19.3 25.9-33.8 47.7-37.9zM468 256a20 20 0 1 0 0-40 20 20 0 1 0 0 40z"],
    "jar-wheat": [320, 512, [], "e517", "M32-32l256 0 0 48-256 0 0-48zM0 64l320 0 0 448-320 0 0-448zM192 320c35.3 0 64-28.7 64-64l-48 0c-19.1 0-36.3 8.4-48 21.7-11.7-13.3-28.9-21.7-48-21.7l-48 0c0 35.3 28.7 64 64 64l64 0zm0-96c35.3 0 64-28.7 64-64l-48 0c-19.1 0-36.3 8.4-48 21.7-11.7-13.3-28.9-21.7-48-21.7l-48 0c0 35.3 28.7 64 64 64l64 0zm0 192c35.3 0 64-28.7 64-64l-48 0c-19.1 0-36.3 8.4-48 21.7-11.7-13.3-28.9-21.7-48-21.7l-48 0c0 35.3 28.7 64 64 64l16 0 0 48 32 0 0-48 16 0z"],
    "bookmark-slash": [576, 512, [], "e0c2", "M49.3-16.9l-17-17-33.9 33.9 17 17 512 512 17 17 33.9-33.9c-.6-.6-33.3-33.3-98.1-98.1l0-414-384 0 0 30-46.8-46.8zM96.1 165.8l0 362.2 192-112 34.9-23.3-226.9-226.9z"],
    "file-ban": [576, 512, [], "e758", "M272 0l-240 0 0 512 244 0c-22.7-31.5-36-70.2-36-112 0-100.6 77.4-183.2 176-191.3L416 144 272 0zm85.5 176L240 176 240 58.5 357.5 176zM432 496c-53 0-96-43-96-96 0-17.8 4.8-34.5 13.3-48.8L480.8 482.7c-14.3 8.4-31 13.3-48.8 13.3zM383.2 317.3c14.3-8.4 31-13.3 48.8-13.3 53 0 96 43 96 96 0 17.8-4.8 34.5-13.3 48.8L383.2 317.3zM432 544a144 144 0 1 0 0-288 144 144 0 1 0 0 288z"],
    "arrow-up-right": [448, 512, [], "e09f", "M384.3 64l32 0 0 288-64 0 0-178.7-265.4 265.4-22.6 22.6-45.3-45.3 22.6-22.6 265.4-265.4-178.7 0 0-64 256 0z"],
    "square-v": [448, 512, [], "e284", "M448 32l-448 0 0 448 448 0 0-448zM201.9 353.4l-89.5-209.4 52.2 0 59.4 138.9 59.4-138.9 52.2 0-89.5 209.4-2.8 6.6-38.5 0-2.8-6.6z"],
    "cloud-arrow-down": [576, 512, [62337, "cloud-download", "cloud-download-alt"], "f0ed", "M144 480l432 0 0-128c0-47.4-25.7-88.7-64-110.9l0-49.1c0-53-43-96-96-96-17.7 0-34.2 4.8-48.4 13.1-24.1-45.8-72.2-77.1-127.6-77.1-79.5 0-144 64.5-144 144l0 24.2C40.1 220 0 273.3 0 336l0 144 144 0zm161-95l-17 17c-2.1-2.1-31.8-31.8-89-89l-17-17 33.9-33.9c9 9 25 25 48 48l0-126.1 48 0 0 126.1c23-23 39-39 48-48L393.9 296c-2.1 2.1-31.8 31.8-89 89z"],
    "keyboard-left": [640, 512, [], "e1c3", "M192 64l448 0 0 384-448 0 0-384zm48 64l0 64 64 0 0-64-64 0zm64 96l-64 0 0 64 64 0 0-64zm32-96l0 64 64 0 0-64-64 0zm64 96l-64 0 0 64 64 0 0-64zm-64 96l0 64 160 0 0-64-160 0zM496 128l-64 0 0 64 64 0 0-64zm-64 96l0 64 64 0 0-64-64 0zm160-96l-64 0 0 64 64 0 0-64zm-64 96l0 64 64 0 0-64-64 0zm-416-8l0 137.9c-65.6-65.6-96.8-96.8-97.9-97.9 17.6-17.6 84.8-84.8 97.9-97.9l0 57.9z"],
    "badge-check": [512, 512, [], "f336", "M256 0C292.8 0 324.8 20.7 340.9 51.1 373.8 41 411 48.9 437 75s34 63.3 23.9 96.2C491.3 187.2 512 219.2 512 256s-20.7 68.8-51.1 84.9C471 373.8 463 411 437 437s-63.3 34-96.2 23.9C324.8 491.3 292.8 512 256 512s-68.8-20.7-84.9-51.1C138.2 471 101 463 75 437s-34-63.3-23.9-96.2C20.7 324.8 0 292.8 0 256s20.7-68.8 51.1-84.9C41 138.2 48.9 101 75 75s63.3-34 96.2-23.9C187.2 20.7 219.2 0 256 0zm57.4 169.9L227.8 287.6c-19.3-20-33.7-34.9-43.2-44.7l-34.5 33.3c6.2 6.4 27.2 28.1 63.1 65.3l19.8 20.6 16.8-23.1 102.4-140.8 14.1-19.4-38.8-28.2-14.1 19.4z"],
    "truck-ramp-box": [640, 512, ["truck-loading"], "f4de", "M384.3 32l-32 0 0 328.2-297.2 89.2-30.7 9.2 18.4 61.3 30.7-9.2 315.5-94.6 43.7 0c-.2 2.6-.4 5.3-.4 8 0 48.6 39.4 88 88 88s88-39.4 88-88l0-392-224 0zm176 392c0 22.1-17.9 40-40 40s-40-17.9-40-40 17.9-40 40-40c22.1 0 39.9 17.9 40 39.9l0 .1zM237.2 102.7L23 168.2 88.5 382.4 302.7 316.9 237.2 102.7z"],
    "face-dotted": [512, 512, [129765], "e47f", "M163 88C131.5 105.5 105.5 131.5 88 163L28.2 139C52.7 91.5 91.5 52.7 139 28.2L163 88zM304.5 70.2C289 66.1 272.7 64 256 64s-33 2.1-48.5 6.2L183.6 10.4C206.6 3.6 230.9 0 256 0s49.4 3.6 72.4 10.4L304.5 70.2zM424 163C406.5 131.5 380.5 105.5 349 88L373 28.2C420.5 52.7 459.3 91.5 483.8 139L424 163zm17.8 141.5c4-15.5 6.2-31.7 6.2-48.5s-2.1-33-6.2-48.5l59.8-23.9c6.8 23 10.4 47.3 10.4 72.4s-3.6 49.4-10.4 72.4l-59.8-23.9zM349 424c31.5-17.5 57.5-43.5 74.9-74.9L483.8 373c-24.4 47.5-63.3 86.4-110.8 110.8L349 424zM207.5 441.8c15.5 4 31.7 6.2 48.5 6.2s33-2.1 48.5-6.2l23.9 59.8c-23 6.8-47.3 10.4-72.4 10.4s-49.4-3.6-72.4-10.4l23.9-59.8zM88 349c17.5 31.5 43.5 57.5 74.9 74.9L139 483.8C91.5 459.3 52.7 420.5 28.2 373L88 349zM70.2 304.5L10.4 328.4C3.6 305.4 0 281.1 0 256s3.6-49.4 10.4-72.4l59.8 23.9C66.1 223 64 239.3 64 256s2.1 33 6.2 48.5zM176 176a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm160 0a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM184 320l168 0 0 48-192 0 0-48 24 0z"],
    "circle-1": [512, 512, [], "e0ee", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM216 144l64 0 0 176 56 0 0 48-160 0 0-48 56 0 0-128-40 0 0-48 24 0z"],
    "octopus": [640, 512, [], "e688", "M207.8 359.6c-2.8 40.4-36.4 72.3-77.4 72.4l-.1 0c-36.7 0-68.3-25.6-76-61.5L47.5 339 .5 349 7.3 380.6c12.4 58 63.6 99.4 122.9 99.4l.1 0c45 0 89-13.3 126.4-38.3l38.6-25.7 49.5 0 38.6 25.7c37.4 25 81.4 38.3 126.4 38.3 59.3 0 110.5-41.4 123-99.4l6.8-31.6-46.9-10.1-6.8 31.6c-7.7 35.8-39.4 61.5-76 61.5-41.1 0-74.8-31.9-77.6-72.4 11.3 7.3 24.5 11.9 38.9 13 38.8 2.8 74.3-21.9 85.3-59.2l10.9-36.9c6.4-21.6 26.2-36.5 48.8-36.5l24 0 0-48-24 0c-43.8 0-82.5 28.9-94.8 71l-10.9 36.9c-4.6 15.7-19.5 26-35.8 24.8-20.5-1.5-35.3-20.3-31.7-40.6l19-109.3c1.5-8.4 2.2-17 2.2-25.6l0-5.2C464 64.5 399.5 0 320 0S176 64.5 176 144l0 5.2c0 8.6 .7 17.1 2.2 25.6l19 109.3c3.5 20.3-11.2 39.1-31.7 40.6-16.3 1.2-31.2-9.2-35.8-24.8L118.8 263c-12.4-42.1-51-71-94.8-71l-24 0 0 48 24 0c22.6 0 42.4 14.9 48.8 36.5l10.9 36.9c11 37.3 46.5 62 85.3 59.2 14.4-1 27.7-5.7 38.9-13zM248 272a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm120-24a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"],
    "angle-down": [448, 512, [8964], "f107", "M224.3 397.3l182.6-182.6 22.6-22.6-45.3-45.3-22.6 22.6-137.4 137.4-137.4-137.4-22.6-22.6-45.3 45.3 22.6 22.6 160 160 22.6 22.6z"],
    "square-kanban": [448, 512, [], "e488", "M448 32l-448 0 0 448 448 0 0-448zM304 384l0-256 48 0 0 256-48 0zM248 256l-48 0 0-128 48 0 0 128zM96 320l0-192 48 0 0 192-48 0z"],
    "circle-three-quarters-stroke": [512, 512, [], "e5d4", "M256 64l0 192 192 0c0-106-86-192-192-192zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0z"],
    "plug-circle-check": [640, 512, [], "e55c", "M224-32l0 128 128 0 0-128 64 0 0 128 96 0 0 64-32 0 0 48.7c-98.6 8.1-176 90.7-176 191.3 0 27.3 5.7 53.3 16 76.9l0 35.1-64 0 0-98.7C165.2 398.1 96 319.1 96 224l0-64-32 0 0-64 96 0 0-128 64 0zM352 400a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm214.4-51.5l-25.9-18.8-9.4 12.9-53 72.9C457.7 395 445 382.3 440 377.4L417.4 400c2.8 2.8 19.9 19.9 51.3 51.3l13.2 13.2 11-15.1 64-88 9.4-12.9z"],
    "camera-shutter": [576, 512, [], "e768", "M57.4-41l39 39 56-56 33.9 33.9c-4.8 4.8-29.1 29.1-73 73l-17 17-73-73-17-17 33.9-33.9 17 17zm103 137l32-64 192 0 32 64 128 0 0 384-512 0 0-384 128 0zm224 192a96 96 0 1 0 -192 0 96 96 0 1 0 192 0z"],
    "window-maximize": [512, 512, [128470], "f2d0", "M512 64l-512 0 0 384 512 0 0-384zM88 128l360 0 0 48-384 0 0-48 24 0z"],
    "tv-music": [576, 512, [], "f8e6", "M512 96l0 240-448 0 0-240 448 0zM64 32l-64 0 0 368 576 0 0-368-512 0zm64 416l0 64 320 0 0-64-320 0zM376 128l-88 0 0 65.8c-5.1-1.2-10.5-1.8-16-1.8-35.3 0-64 25.1-64 56s28.7 56 64 56 64-25.1 64-56l0-72 40 0 0-48z"],
    "hands-holding-circle": [640, 512, [], "e4fb", "M320 256a128 128 0 1 0 0-256 128 128 0 1 0 0 256zM80 64l-80 0 0 301.3 9.4 9.4 128 128 9.4 9.4 141.3 0 0-173.3-9.4-9.4C125.1 175.9 201.5 252.2 160 210.7L114.7 256c48.8 48.8 65.1 65.1 91 91L164.1 374.8 80 290.7 80 64zm480 0l0 226.7-84.1 84.1-41.7-27.8c102.9-102.9 58.7-58.7 91-91L480 210.7c-44.2 44.2-69.7 69.7-118.6 118.6l-9.4 9.4 0 173.3 141.3 0 9.4-9.4 128-128 9.4-9.4 0-301.3-80 0z"],
    "wreath": [512, 512, [], "f7e2", "M8.7 322.3c6.3 23.6 22.6 41.9 43.1 51.6-1.9 22.6 5.9 45.8 23.2 63.1 10.6 10.6 23.5 17.6 37 21l0-92.6c39.2 13.1 87.2 29.1 144 48l144-48 0 92.6c13.6-3.4 26.4-10.4 37-21 17.3-17.3 25-40.5 23.2-63.1 20.5-9.7 36.8-28 43.1-51.6s1.4-47.6-11.5-66.3c12.9-18.6 17.8-42.6 11.5-66.3s-22.6-41.9-43.1-51.6c1.8-22.6-5.9-45.8-23.2-63.1s-40.5-25-63.1-23.2c-9.7-20.5-28-36.8-51.6-43.1S274.7 7.3 256 20.2C237.4 7.3 213.4 2.4 189.8 8.7s-41.9 22.6-51.6 43.1C115.5 50 92.3 57.7 75 75s-25 40.5-23.2 63.1c-20.5 9.7-36.8 28-43.1 51.6S7.4 237.3 20.3 256C7.3 274.6 2.4 298.6 8.7 322.3zM282.5 192l37.5 0 0 37.5 26.5 26.5-26.5 26.5 0 37.5-37.5 0-26.5 26.5-26.5-26.5-37.5 0 0-37.5-26.5-26.5 26.5-26.5 0-37.5 37.5 0 26.5-26.5 26.5 26.5zM160 432l0 112 96-32 96 32 0-112-96 32-96-32z"],
    "location-pin": [384, 512, ["map-marker"], "f041", "M192 0C86 0 0 84.4 0 188.6 0 339.4 192 528 192 528S384 339.4 384 188.6C384 84.4 298 0 192 0z"],
    "bowling-ball": [512, 512, [], "f436", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM240 80a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM208 208a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm-64-64a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "cart-flatbed": [576, 512, ["dolly-flatbed"], "f474", "M32 0l-32 0 0 64 64 0 0 384 66.7 0c-1.8 5-2.7 10.4-2.7 16 0 26.5 21.5 48 48 48s48-21.5 48-48c0-5.6-1-11-2.7-16l197.5 0c-1.8 5-2.7 10.4-2.7 16 0 26.5 21.5 48 48 48s48-21.5 48-48c0-5.6-1-11-2.7-16l66.7 0 0-64-448 0 0-384-96 0zM512 64l-336 0 0 272 336 0 0-272z"],
    "house-user": [512, 512, ["home-user"], "e1b0", "M512 272l-48 0 0 240-416 0 0-240-48 0 0-48 256-240 256 240 0 48zM312 256a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zm24 96l-160 0-32 96 224 0-32-96z"],
    "brain-circuit": [512, 512, [], "e0c6", "M176 0c-30.9 0-56 25.1-56 56l0 24c-44.2 0-80 35.8-80 80 0 15 4.1 29 11.2 40.9-25.7 13.3-43.2 40.1-43.2 71.1 0 26.2 12.6 49.4 32 64-10 13.4-16 30-16 48 0 44.2 35.8 80 80 80 .7 0 1.3 0 2 0 7.1 27.6 32.2 48 62 48l64 0 0-204-68 0 0 16.4c16.5 7.6 28 24.3 28 43.6 0 26.5-21.5 48-48 48s-48-21.5-48-48c0-19.4 11.5-36.1 28-43.6l0-56.4 108 0 0-72-44.4 0c-7.6 16.5-24.3 28-43.6 28-26.5 0-48-21.5-48-48s21.5-48 48-48c19.4 0 36.1 11.5 43.6 28l44.4 0 0-156-56 0zM280 196l0 200 68 0 0-16.4c-16.5-7.6-28-24.3-28-43.6 0-26.5 21.5-48 48-48s48 21.5 48 48c0 19.4-11.5 36.1-28 43.6l0 56.4-108 0 0 76 64 0c29.8 0 54.9-20.4 62-48 .7 0 1.3 0 2 0 44.2 0 80-35.8 80-80 0-18-6-34.6-16-48 19.4-14.6 32-37.8 32-64 0-30.9-17.6-57.8-43.2-71.1 7.1-12 11.2-26 11.2-40.9 0-44.2-35.8-80-80-80l0-24c0-30.9-25.1-56-56-56l-56 0 0 156 44.4 0c7.6-16.5 24.3-28 43.6-28 26.5 0 48 21.5 48 48s-21.5 48-48 48c-19.4 0-36.1-11.5-43.6-28L280 196zm88-36a16 16 0 1 0 0 32 16 16 0 1 0 0-32zM352 336a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zM128 368a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm0-192a16 16 0 1 0 32 0 16 16 0 1 0 -32 0z"],
    "squareapore-dollar": [448, 512, [], "e733", "M0 32l448 0 0 448-448 0 0-448zM88 215.6c0 30.3 21.4 56.4 51.1 62.3l16.4 3.3c7.3 1.5 12.5 7.8 12.5 15.3 0 8.6-7 15.6-15.6 15.6l-56.4 0 0 48 56.4 0c35.1 0 63.6-28.5 63.6-63.6 0-30.3-21.4-56.4-51.1-62.3l-16.4-3.3c-7.3-1.5-12.5-7.8-12.5-15.3 0-8.6 7-15.6 15.6-15.6l48.4 0 0-48-48.4 0C116.5 152 88 180.5 88 215.6zM312 120l-32 0 0 33.9c-27.6 6.9-48 31.9-48 61.6 0 30.3 21.4 56.4 51.1 62.3l16.4 3.3c7.3 1.5 12.5 7.8 12.5 15.3 0 8.6-7 15.6-15.6 15.6l-56.4 0 0 48 40 0 0 32 32 0 0-33.9c27.6-6.9 48-31.9 48-61.6 0-30.3-21.4-56.4-51.1-62.3l-16.4-3.3c-7.3-1.5-12.5-7.8-12.5-15.3 0-8.6 7-15.6 15.6-15.6l48.4 0 0-48-32 0 0-32z"],
    "envelopes": [576, 512, [], "e170", "M96 32L96 88.7 336 251 576 88.7 576 32 96 32zM349.4 299.9l-13.4 9.1-13.4-9.1-226.6-153.3 0 237.4 480 0 0-237.4-226.6 153.3zM48 152l0-24-48 0 0 352 480 0 0-48-432 0 0-280z"],
    "escalator": [512, 512, [], "e171", "M152 40a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zM328.8 224L512 224 512 352 375.2 352 201 497.2 183.2 512 0 512 0 384 136.8 384 311 238.8 328.8 224zm-48.5-22l-152.3 126.9 0-200.9 160 0 0 68.1c-2.6 1.8-5.2 3.8-7.7 5.9z"],
    "ghost": [384, 512, [128123], "f6e2", "M48 448L0 480 0 192C0 86 86 0 192 0S384 86 384 192l0 288-48-32-72 64-72-64-72 64-72-64zM160 192a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm96 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "shorts": [512, 512, [], "e6d9", "M64.1 32l0 80 384 0 0-80-384 0zm-6 128l-49.7 277.2-2.8 15.8 15.8 2.8 184 32 14.8 2.6 3.5-14.6 32.4-136.2 32.4 136.2 3.5 14.6 14.8-2.6 184-32 15.8-2.8-2.8-15.8-49.8-277.2-396 0z"],
    "floppy-disk-circle-xmark": [576, 512, ["floppy-disk-times", "save-circle-xmark", "save-times"], "e181", "M64 32l-32 0 0 448 225.4 0c-9.3-20.3-15.2-42.5-16.9-65.9-27.9-6.9-48.5-32.1-48.5-62.1 0-35.3 28.7-64 64-64 6.3 0 12.4 .9 18.2 2.6 34.7-49.9 92.4-82.6 157.8-82.6 16.6 0 32.7 2.1 48 6l0-67.3-105.4-105.4-9.4-9.4-301.3 0zm64 64l224 0 0 128-224 0 0-128zM432 544a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm55.3-176.7L454.6 400c25.4 25.3 40 40 44 44L476 466.6c-4-4-18.6-18.6-44-44-25.3 25.4-40 40-44 44L365.4 444c4-4 18.6-18.6 44-44-25.4-25.3-40-40-44-44L388 333.4c4 4 18.6 18.6 44 44 25.3-25.4 40-40 44-44l22.6 22.6-11.3 11.3z"],
    "ball-yarn": [512, 512, [], "e6ce", "M207 136L243.4 .3C150.7 4.8 71 58.6 29.8 136L207 136zM292.5 2.6l-35.8 133.4 66.6 0 31.2-116.4c-19.6-8.2-40.4-14-62-17.1zM117.2 471.2l25.5-95.2-112.9 0c20.6 38.7 50.8 71.5 87.4 95.2zM192.4 376L160.9 493.7c19.7 7.9 40.5 13.4 62.3 16.2L259 376 192.4 376zM482.2 136c-20-37.6-49-69.6-84.2-93.1L373 136 482.2 136zm0 240l-173.5 0-36.4 136 239.7 0 0-48-106.7 0c31.9-23 58.3-53.1 76.9-88zm19.5-48c4.5-15.4 7.6-31.5 9.2-48L1.1 280c1.5 16.5 4.6 32.6 9.2 48l491.5 0zm0-144L10.3 184c-4.5 15.4-7.6 31.5-9.2 48l509.8 0c-1.5-16.5-4.6-32.6-9.2-48z"],
    "display-code": [512, 512, ["desktop-code"], "e165", "M64 96l0 256 384 0 0-256-384 0zM0 32l512 0 0 384-208 0 16 48 96 0 0 48-320 0 0-48 96 0 16-48-208 0 0-384zM217 193l-31 31c23 23 39 39 48 48L200 305.9c-6.1-6.1-27.8-27.8-65-65l-17-17 65-65 17-17 33.9 33.9-17 17zM329 159c37.2 37.2 58.8 58.8 65 65-6.1 6.1-27.8 27.8-65 65l-17 17-33.9-33.9c9-9 25-25 48-48-23-23-39-39-48-48l33.9-33.9 17 17z"],
    "balloons": [576, 512, [], "e2e4", "M320 160C320 71.6 248.4 0 160 0S0 71.6 0 160C0 272 128 368 128 368l-32 80 128 0-32-80s128-96 128-208zM160 96c-35.3 0-64 28.7-64 64l-48 0C48 98.1 98.1 48 160 48l0 48zM384 432l-32 80 128 0-32-80s128-96 128-208c0-88.4-71.6-160-160-160-23.1 0-45.1 4.9-64.9 13.7 6.3 14.7 11 30.3 13.9 46.6 15.3-7.9 32.7-12.3 51.1-12.3l0 48c-19.9 0-37.6 9.1-49.4 23.3-7.3 62.4-42.3 115.8-72.6 152.1 37.7 57.5 90 96.7 90 96.7z"],
    "comment-nodes": [640, 512, [], "e696", "M287 424c-10.1 17.5-15 36.6-15 55.5-32.5-1.9-63.3-9.4-91.3-21.6L32 512 87.7 389.5c-34.9-41-55.7-93-55.7-149.5 0-132.5 114.6-240 256-240 137 0 248.9 100.9 255.7 227.9-18.1-12.5-40-19.9-63.7-19.9-61.9 0-112 50.1-112 112 0 11.7 1.8 23.1 5.2 33.8l-9.2 16c-31.2 5.7-59.9 24.5-77 54.2zm41.6 24c13.4-23.2 39.1-34.8 64-31.4l34.6-60.5c-7-10.3-11.2-22.7-11.2-36.1 0-35.3 28.7-64 64-64s64 28.7 64 64-28.7 64-64 64c-4.4 0-8.6-.4-12.8-1.3l-33 57.7c3.8 4.8 6.8 10 9 15.6l73.4 0c2.2-5.6 5.3-10.8 9-15.6l-16.5-28.9c15.7-5 29.6-13.9 40.6-25.6l17.6 30.7c25-3.4 50.6 8.3 64 31.4 17.7 30.6 7.2 69.7-23.4 87.4s-69.7 7.2-87.4-23.4c-1.5-2.6-2.8-5.3-3.9-8l-73.3 0c-1.1 2.7-2.4 5.4-3.9 8-17.7 30.6-56.8 41.1-87.4 23.4s-41.1-56.8-23.4-87.4z"],
    "tree-christmas": [512, 512, [127876], "f7db", "M404.1 170.2l29.2 35.6-73.9 0c70.3 82.2 112 131 125 146.2l-105.1 0c80.3 93.7 126 147 137.2 160L-3.9 512c11.1-13 56.8-66.3 137.2-160L28.2 352c13-15.2 54.7-64 125-146.2l-73.8 0c11.3-13.9 47-57.4 106.9-130.6l3.8 1.8 20.4 65.3 91.6 0 20.6-65.8 3.4-1.7 78.1 95.4zM320.2 392a24 24 0 1 0 0 48 24 24 0 1 0 0-48zm-128-128a24 24 0 1 0 0 48 24 24 0 1 0 0-48zM282.9-10.7l53.3 26.7-53.3 26.7-26.7 53.3-26.7-53.3-53.3-25.3 53.3-28 26.7-53.3 26.7 53.3z"],
    "person-arrow-down-to-line": [640, 512, [], "e538", "M528.3 0l0 146.7c17.4-17.4 33.4-33.4 48-48L621.5 144c-5.5 5.5-39.7 39.7-102.6 102.6l-22.6 22.6c-5.5-5.5-39.7-39.7-102.6-102.6L371 144 416.3 98.7c14.6 14.6 30.6 30.6 48 48l0-178.7 64 0 0 32zM32.3 480l112 0 0-241.7c-28.6 39.4-47.6 65.6-56.9 78.4l-51.8-37.6 18.8-25.9 92.9-128 9.6-13.2 134.8 0 9.6 13.2 92.9 128 18.8 25.9-51.8 37.6c-9.3-12.8-28.3-39-56.9-78.4l0 241.7 304 0 0 64-576 0 0-64zm176 0l32 0 0-144-32 0 0 144zm16-512a56 56 0 1 1 0 112 56 56 0 1 1 0-112z"],
    "plug-circle-plus": [640, 512, [], "e55f", "M224-32l0 128 128 0 0-128 64 0 0 128 96 0 0 64-32 0 0 56.7c-98.6 8.1-176 90.7-176 191.3 0 27.3 5.7 53.3 16 76.9l0 27.1-64 0 0-98.7C165.2 398.1 96 319.1 96 224l0-64-32 0 0-64 96 0 0-128 64 0zM496 264a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm16 80l0-16-32 0 0 64-64 0 0 32 64 0 0 64 32 0 0-64 64 0 0-32-64 0 0-48z"],
    "person-swimming": [640, 512, [127946, "swimmer"], "f5c4", "M496.4 96a56 56 0 1 1 0 112 56 56 0 1 1 0-112zM210.1 270.5l84.1-72.1-50.7-19c-51.1 30.6-82.5 49.5-94.2 56.5L116.5 181c9.5-5.7 45.4-27.2 107.4-64.5l13.2-7.9 14.5 5.4 128 48 6.5 2.4 4.9 4.9 80 80 3.4 3.5c-10.1 4-61.5 24.6-154.3 61.7l-93.1-37.2-17-6.8zm-.8 51.2l111.1 44.4 111.1-44.4 8.9-3.6 8.9 3.6 111.8 44.7c29.3-9.7 50.1-16.7 62.4-20.8l15.2 45.5c-11 3.7-34.6 11.5-70.8 23.6l-8.3 2.8-8.2-3.3-111.1-44.4-111.1 44.4-8.9 3.6-8.9-3.6-111.1-44.4-111.1 44.4-8.2 3.3-8.3-2.8C36.6 402.7 13 394.8 2 391.2l15.2-45.5c12.4 4.1 33.2 11.1 62.4 20.8l111.8-44.7 8.9-3.6 8.9 3.6z"],
    "comment-dots": [512, 512, [128172, 62075, "commenting"], "f4ad", "M512 240c0 132.5-114.6 240-256 240-38.3 0-74.7-7.9-107.3-22.1L0 512 55.7 389.5C20.8 348.5 0 296.5 0 240 0 107.5 114.6 0 256 0S512 107.5 512 240zM128 272a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm128 0a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm160-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "chart-pie": [576, 512, ["pie-chart"], "f200", "M544.5 240l-240 0 0-240c132.5 0 240 107.5 240 240zM256.5 32.5l0 240.1 5.5 6.7 153.6 185.4c-40 29.7-89.5 47.3-143.1 47.3-132.5 0-240-107.5-240-240 0-127.2 98.9-231.2 224-239.5zM512 288l64 0c-4.8 72.8-42 136.7-97.4 177.4L331.5 288 512 288z"],
    "shirt-running": [384, 512, [], "e3c8", "M112 0l0 80c0 44.2 35.8 80 80 80s80-35.8 80-80l0-80 64 0 0 128 7.6 20.4-343.6 245.5 0-137.8 48-128 0-128 64 0zM0 472.5l366.9-262.1 17.1 45.6 0 256-384 0 0-39.5z"],
    "bus-school": [448, 512, [], "f5dd", "M416 0l-384 0 0 256-32 0 0 192 48 0 0 64 80 0 0-64 192 0 0 64 80 0 0-64 48 0 0-192-32 0 0-256zM64 352a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm288-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM248 256l0-128 120 0 0 128-120 0zM200 128l0 128-120 0 0-128 120 0zM184 48l104 0 0 48-128 0 0-48 24 0z"],
    "phone-arrow-right": [576, 512, [], "e5be", "M545.4 113l17-17c-2.1-2.1-31.8-31.8-89-89l-17-17-33.9 33.9c9 9 25 25 48 48l-126.1 0 0 48 126.1 0c-23 23-39 39-48 48l33.9 33.9c2.1-2.1 31.8-31.8 89-89zM160.4 0l-128 64 0 16c0 238.6 193.4 432 432 432l16 0 64-128-128-96.8-80 80.8c-70.4-33-127-89.6-160-160l80.8-80-96.8-128z"],
    "list-music": [576, 512, [], "f8c9", "M576 32l0-41C564.2-6 508.3 7.9 408.2 33L384 39 384 313.2c-14.5-5.9-30.8-9.2-48-9.2-61.9 0-112 43-112 96s50.1 96 112 96 112-43 112-96l0-215c82.4-20.6 125.1-31.3 128-32l0-121zM64 64l-32 0 0 64 304 0 0-64-272 0zm0 160l-32 0 0 64 192 0 0-64-160 0zm0 160l-32 0 0 64 144 0 0-64-112 0z"],
    "leaf-heart": [512, 512, [], "f4cb", "M512 24l0 186.9C512 342.1 403.9 448 273.2 448 191.7 448 121.9 392.4 101.8 316.8 68.7 347.5 48 391.3 48 440l0 40-48 0 0-40C0 364.9 38.3 298.8 96.4 260.1 102.5 168.4 178.8 96 272 96 355.3 96 404.2 73.4 431.6 52.8 455.9 34.6 464.8 17 465.9 14.7L512 24zM357.3 176c-18.5 0-35.9 8.7-46.9 23.5l-6.4 8.5-6.4-8.5c-11.1-14.8-28.5-23.5-46.9-23.5-32.4 0-58.7 26.3-58.7 58.7l0 5.3c0 63.9 111.6 127.8 112 128 0 0 112-64 112-128l0-5.3c0-32.4-26.3-58.7-58.7-58.7z"],
    "chart-bullet": [512, 512, [], "e0e1", "M288 32l0 32 224 0 0 160-224 0 0 32-48 0 0-32-240 0 0-160 240 0 0-32 48 0zM160 128l0 32 80 0 0-32-80 0zm128 0l0 32 160 0 0-32-160 0zm48 224l-80 0 0 32 80 0 0-32zm0-64l0-32 48 0 0 32 128 0 0 160-128 0 0 32-48 0 0-32-336 0 0-160 336 0zm48 64l0 32 64 0 0-32-64 0z"],
    "face-smile-hearts": [640, 512, [], "e390", "M520.4-20.1c-8-7.6-18.6-11.9-29.6-11.9l-4.4 0C465.2-32 448-14.8 448 6.4 448 57.6 528 96 528 96s80-38.4 80-89.6C608-14.8 590.8-32 569.6-32l-4.4 0c-11 0-21.7 4.3-29.6 11.9l-7.6 7.3-7.6-7.3zM458 107.9C437.8 91.7 403.2 59 400.2 12.8 375 4.5 348 0 320 0 178.6 0 64 114.6 64 256 64 297.6 73.9 336.9 91.6 371.7 99.8 369.3 108.5 368 117.2 368l4.4 0c47.7 0 86.4 38.7 86.4 86.4 0 10.6-1.7 20.5-4.5 29.6 34.9 17.9 74.5 28 116.5 28s81.6-10.1 116.5-28c-2.8-9.2-4.5-19-4.5-29.6 0-47.7 38.7-86.4 86.4-86.4l4.4 0c8.8 0 17.4 1.3 25.6 3.7 17.6-34.7 27.6-74.1 27.6-115.7 0-42-10.1-81.6-28-116.6-6.6 3.4-13.3 6.6-20 9.8-24.7-11.8-48.5-24.2-70-41.4zM320 368c38.2 0 72-19.1 92.2-48.5l39.5 27.3C422.9 388.6 374.7 416 320 416s-102.9-27.4-131.8-69.2l39.5-27.3C248 348.9 281.8 368 320 368zM232 196c-11 0-20 9-20 20l0 16-40 0 0-16c0-33.1 26.9-60 60-60l16 0c33.1 0 60 26.9 60 60l0 16-40 0 0-16c0-11-9-20-20-20l-16 0zm140 20l0 16-40 0 0-16c0-33.1 26.9-60 60-60l16 0c33.1 0 60 26.9 60 60l0 16-40 0 0-16c0-11-9-20-20-20l-16 0c-11 0-20 9-20 20zM72.4 427.9c-8-7.6-18.6-11.9-29.6-11.9l-4.4 0C17.2 416 0 433.2 0 454.4 0 505.6 80 544 80 544s80-38.4 80-89.6c0-21.2-17.2-38.4-38.4-38.4l-4.4 0c-11 0-21.7 4.3-29.6 11.9l-7.6 7.3-7.6-7.3zM522.8 416l-4.4 0c-21.2 0-38.4 17.2-38.4 38.4 0 51.2 80 89.6 80 89.6s80-38.4 80-89.6c0-21.2-17.2-38.4-38.4-38.4l-4.4 0c-11 0-21.7 4.3-29.6 11.9l-7.6 7.3-7.6-7.3c-8-7.6-18.6-11.9-29.6-11.9z"],
    "calendar-arrow-down": [448, 512, ["calendar-download"], "e0d0", "M160 0l0 64 128 0 0-64 64 0 0 64 96 0 0 416-448 0 0-416 96 0 0-64 64 0zm47 385l17 17c2.1-2.1 31.8-31.8 89-89l17-17-33.9-33.9c-9 9-25 25-48 48l0-126.1-48 0 0 126.1c-23-23-39-39-48-48L118.1 296c2.1 2.1 31.8 31.8 89 89z"],
    "mobile-signal-out": [576, 512, [], "e1f0", "M344-32C472.1-32 576 71.9 576 200l0 24-48 0 0-24C528 98.4 445.6 16 344 16l-24 0 0-48 24 0zm8 192a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM320 64l24 0c75.1 0 136 60.9 136 136l0 24-48 0 0-24c0-48.6-39.4-88-88-88l-24 0 0-48zM32 0l240 0 0 272 112 0 0 240-352 0 0-512zM168 416l-24 0 0 48 128 0 0-48-104 0z"],
    "frog": [576, 512, [], "f52e", "M368 32c41.7 0 75.9 31.8 79.7 72.5l128.3 39.5 0 80-175.2 99.5 92.5 92.5 82.7 0 0 64-109.3 0-119.8-119.8c11.7-36 3.2-77.1-25.4-105.7-40.6-40.6-106.3-40.6-146.9-.1l-73.6 70.1-11.6 11 22.1 23.2 11.6-11 73.8-70.2 .1-.1 .1-.1c3.5-3.5 7.3-6.6 11.3-9.2 27.9-18.5 65.9-15.4 90.5 9.2 24.7 24.7 27.7 62.9 9 90.9-2.6 3.8-5.6 7.5-9 10.9l-37.1 37.1 90.2 0 0 64-352 0 0-64C0 249.6 127 112.9 289.3 97.5 296.2 60.2 328.8 32 368 32zm0 104a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"],
    "wrench-simple": [384, 512, [], "e2d1", "M128 160l64 64 64-64 0-160c74.6 26.4 128 92.4 128 176 0 71.1-38.6 133.1-96 166.3l0 169.7-192 0 0-169.7C38.6 309.1 0 247.1 0 176 0 92.4 53.4 26.4 128 0l0 160z"],
    "wine-bottle": [320, 512, [], "f72f", "M80-64l160 0 0 64-16 0 0 141.3c56.5 24.7 96 81.1 96 146.7l0 288-320 0 0-288c0-65.6 39.5-122 96-146.7L96 0 80 0 80-64zM256 288l-192 0 0 192 192 0 0-192z"],
    "pancakes": [512, 512, [129374], "e42d", "M256 192c86.2 0 160.1-20.1 191.7-48.9 10.2-9.3 16-19.5 16.3-30.2 0-.3 0-.6 0-1 0-44.2-93.1-80-208-80S48 67.8 48 112c0 .3 0 .6 0 1 .2 6.7 2.6 13.3 6.9 19.5 6.9 10.1 18.9 19.4 34.7 27.5 7.3 3.7 15.3 7.2 24.1 10.3 1.5 .5 3 1.1 4.6 1.6 8 2.7 16.7 5.2 25.7 7.5l0 196.6 48 0 0-187.9c12.9 1.6 26.4 2.7 40.3 3.3 7.8 .3 15.7 .5 23.7 .5zm0 48c-5.4 0-10.7-.1-16-.2l0 48c5.3 .1 10.6 .2 16 .2 132.5 0 240-34.1 240-112 0-4.7-.4-9.3-1.2-13.7-4.6 6.2-9.7 11.7-14.9 16.4-16.5 15-37.6 26.2-59.6 34.7-44.4 17.1-102.5 26.6-164.3 26.6zM96.5 215.2c-1.6-.6-3.2-1.2-4.8-1.8-22-8.5-43.2-19.8-59.6-34.7-5.2-4.7-10.3-10.2-14.9-16.4-.8 4.4-1.2 9-1.2 13.7 0 41.8 30.9 70.9 80 89l0-41c0-3 .2-5.9 .5-8.8zM96 315.6c-9.9-3-19.3-6.4-28.3-10.2-18.3-7.7-36.2-17.8-51.6-30.7 .6 17.2 6.5 32.3 16.9 45.2l0 0c13.9 17.3 35.6 30.9 63.1 41l0-45.4zm144 68.2c5.3 .1 10.6 .2 16 .2 101.2 0 187.8-19.9 223.1-64l0 0c10.4-13 16.3-28 16.9-45.2-15.4 12.8-33.3 22.9-51.6 30.7-51.8 21.8-119 30.6-188.3 30.6-5.3 0-10.7-.1-16-.2l0 48zM256 432c-69.3 0-136.5-8.8-188.3-30.6-18.3-7.7-36.2-17.8-51.6-30.7 2.5 75.9 109 109.2 240 109.2s237.4-33.3 240-109.2c-15.4 12.8-33.3 22.9-51.6 30.7-51.8 21.8-119 30.6-188.3 30.6zM216 80l104 0 0 48-128 0 0-48 24 0z"],
    "inbox": [512, 512, [], "f01c", "M447.5 288l-24-192-335 0-24 192 79.5 0 32 64 160 0 32-64 79.5 0zM0 288l32-256 448 0 32 256 0 192-512 0 0-192z"],
    "bolt-slash": [576, 512, [], "e0b8", "M49.3-16.9l-17-17-33.9 33.9 17 17 512 512 17 17 33.9-33.9-17-17-155.7-155.7 138.5-115.4-217.6 0 89.6-256-208.3 173.6-158.5-158.5zM241.6 311.3L160.1 544 331.5 401.2 241.6 311.3zM133.7 203.4l-101.6 84.6 186.2 0-84.6-84.6z"],
    "star-shooting": [512, 512, [127776], "e036", "M297 57l17-17-33.9-33.9c-8.8 8.8-25.1 25.1-49 49l-17 17 33.9 33.9c8.8-8.8 25.1-25.1 49-49zM489 249l17-17-33.9-33.9c-8.8 8.8-25.1 25.1-49 49l-17 17 33.9 33.9c8.8-8.8 25.1-25.1 49-49zm17-209l-33.9-33.9-17 17-128 128-17 17 33.9 33.9 17-17 128-128 17-17zM253.3 265.1L193.5 144 133.7 265.1 0 284.6 96.7 378.9 73.9 512 193.5 449.1 313 512 290.2 378.9 386.9 284.6 253.3 265.1z"],
    "horizontal-rule": [640, 512, [8213], "f86c", "M0 224l640 0 0 64-640 0 0-64z"],
    "cloud-bolt-moon": [640, 512, ["thunderstorm-moon"], "f76d", "M496.5 89.5c0-52.8 36.3-97 85.3-109.2-17.8-7.9-37.6-12.3-58.3-12.3-55.9 0-104.4 31.9-128.2 78.4 36.6 19.1 62.9 55.4 68 98.2 38.7 22 64.9 63.6 64.9 111.3 45.4-1.4 85.5-23.9 110.9-58-9.6 2.6-19.6 4.1-30.1 4.1-62.1 0-112.5-50.4-112.5-112.5zM208.6 416l-32.4 136 200-168-104.4 0 32.4-136-200 168 104.4 0zM32.3 239.9l0 96.1 92.6 0 161.9-136 78.3 0-32.4 136 147.6 0-.1-80.1c0-38.7-27.5-71-64-78.4l0-17.6c0-44.2-35.8-80-80-80-17 0-32.8 5.3-45.8 14.4-16.8-27.8-47.3-46.4-82.2-46.4-53.4 0-96 44.5-96 97.3-45.4 7.6-80 47.1-80 94.6z"],
    "nfc-slash": [576, 512, [], "e1fc", "M49.3-16.9l-17-17-33.9 33.9 17 17 512 512 17 17 33.9-33.9c-5.9-5.9-28-28-66.1-66.1l0-414-414 0-48.9-48.9zM162.2 96l54 0 0 48-6 0-48-48zm102 102l0-102 184 0 0 286-48-48 0-190-88 0 0 102-48-48zm-88 170l122 0-122-122 0 122zm-48 24l0-194-64-64 0 346 346 0-64-64-218 0 0-24z"],
    "square-h": [448, 512, ["h-square"], "f0fd", "M448 32l-448 0 0 448 448 0 0-448zM320 168l0 200-48 0 0-88-96 0 0 88-48 0 0-224 48 0 0 88 96 0 0-88 48 0 0 24z"],
    "house-medical": [512, 512, [], "e3b2", "M512 272l-48 0 0 240-416 0 0-240-48 0 0-48 256-240 256 240 0 48zM224 288l-56 0 0 64 56 0 0 56 64 0 0-56 56 0 0-64-56 0 0-56-64 0 0 56z"],
    "circle-chevron-right": [512, 512, ["chevron-circle-right"], "f138", "M0 256a256 256 0 1 0 512 0 256 256 0 1 0 -512 0zm345 17l-104 104-17 17-33.9-33.9 17-17 87-87-87-87-17-17 33.9-33.9 17 17 104 104 17 17-17 17z"],
    "file-csv": [576, 512, [], "f6dd", "M272 0l-240 0 0 512 144 0 0-176 240 0 0-192-144-144zm85.5 176L240 176 240 58.5 357.5 176zM264 380c-24.3 0-44 19.7-44 44l0 80c0 24.3 19.7 44 44 44l16 0c24.3 0 44-19.7 44-44l0-16-40 0 0 16c0 2.2-1.8 4-4 4l-16 0c-2.2 0-4-1.8-4-4l0-80c0-2.2 1.8-4 4-4l16 0c2.2 0 4 1.8 4 4l0 16 40 0 0-16c0-24.3-19.7-44-44-44l-16 0zm136 0c-28.7 0-52 23.3-52 52s23.3 52 52 52c6.6 0 12 5.4 12 12s-5.4 12-12 12l-52 0 0 40 52 0c28.7 0 52-23.3 52-52s-23.3-52-52-52c-6.6 0-12-5.4-12-12s5.4-12 12-12l44 0 0-40-44 0zm116 0l-40 0 0 55c0 21.6 3.9 43 11.5 63.2 10.7 28.5 16.9 45.1 18.7 49.8l43.7 0c1.8-4.7 8-21.3 18.7-49.8 7.6-20.2 11.5-41.6 11.5-63.2l0-55-40 0 0 55c0 16.8-3 33.4-8.9 49.2l-3.1 8.2-3.1-8.2C519 468.4 516 451.8 516 435l0-55z"],
    "hat-cowboy": [640, 512, [], "f8c0", "M192 32L130.8 307.5C145.5 324.9 167.4 336 192 336l256 0c24.6 0 46.5-11.1 61.2-28.5l-61.2-275.5-64 0-64 48-64-48-64 0zM64 256l0-32-64 0 0 32C0 362 86 448 192 448l256 0c106 0 192-86 192-192l0-32-64 0 0 32c0 70.7-57.3 128-128 128l-256 0c-70.7 0-128-57.3-128-128z"],
    "face-grin-tongue-wink": [512, 512, [128540, "grin-tongue-wink"], "f58b", "M152.2 490.1C62.5 450.2 0 360.4 0 256 0 114.6 114.6 0 256 0S512 114.6 512 256c0 104.4-62.5 194.2-152.2 234.1 5.3-13 8.2-27.2 8.2-42.1l0-61.7c23.5-23 39.9-53.2 45.7-87-45.3 18.1-99.5 28.7-157.7 28.7S143.6 317.4 98.3 299.3c5.8 33.8 22.2 64 45.7 87l0 61.7c0 14.9 2.9 29.1 8.2 42.1zM152 212l16 0c11 0 20 9 20 20l0 16 40 0 0-16c0-33.1-26.9-60-60-60l-16 0c-33.1 0-60 26.9-60 60l0 16 40 0 0-16c0-11 9-20 20-20zm184 60a64 64 0 1 0 0-128 64 64 0 1 0 0 128zM320 384l0 64c0 35.3-28.7 64-64 64s-64-28.7-64-64l0-64 48 0 0 24 32 0 0-24 48 0zm16-200a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"],
    "shelves": [512, 512, ["inventory"], "f480", "M64 0l0 160 384 0 0-160 64 0 0 512-64 0 0-32-384 0 0 32-64 0 0-512 64 0zm0 416l384 0 0-192-384 0 0 192zM240 256l0 128-128 0 0-128 128 0zm32 0l128 0 0 128-128 0 0-128zM400 0l0 128-128 0 0-128 128 0z"],
    "hexagon-exclamation": [576, 512, [], "e417", "M433 28.1l123.7 216 6.8 11.9-6.8 11.9-123.7 216.1-6.9 12.1-275.2 0-6.9-12.1-123.7-216.1-6.8-11.9 6.8-11.9 123.7-216 6.9-12.1 275.2 0 6.9 12.1zM260.5 324l0 56 56 0 0-56-56 0zm-4-196l12.8 160 38.4 0 12.8-160-64 0z"],
    "arrows-repeat-1": [512, 512, ["repeat-1-alt"], "f366", "M493.3 96c-5.5 5.5-39.7 39.7-102.6 102.6L368 221.3 322.7 176c14.6-14.6 30.6-30.6 48-48L64 128 64 288 0 288 0 64 370.7 64c-17.4-17.4-33.4-33.4-48-48L368-29.3c5.5 5.5 39.7 39.7 102.6 102.6L493.3 96zM18.7 416c5.5-5.5 39.7-39.7 102.6-102.6L144 290.7 189.3 336c-14.6 14.6-30.6 30.6-48 48l306.7 0 0-160 64 0 0 224-370.7 0c17.4 17.4 33.4 33.4 48 48L144 541.3 41.4 438.6 18.7 416zM240 192l48 0 0 128-48 0 0-80-24 0 0-48 24 0z"],
    "l": [320, 512, [108], "4c", "M96 32l0 384 224 0 0 64-288 0 0-448 64 0z"],
    "phone-missed": [640, 512, [], "e226", "M184.3 0l125.8 0 0 48-67.9 0 78.1 78.1c63-63 95-95 96-96l33.9 33.9-17 17-96 96-17 17-17-17-95-95 0 67.9-48 0 0-149.8 24 0zM637.1 370.7l-45.2 135.8-158.9-22.1 .5-113.7c-73.1-26.5-153.2-26.5-226.3 0l.5 113.7-158.9 22.1-45.3-135.8 11.3-11.3c168.7-168.7 442.2-168.7 610.9 0l11.3 11.3z"],
    "arrow-down-short-wide": [576, 512, ["sort-amount-desc", "sort-amount-down-alt"], "f884", "M150.9 470.6l-22.6 22.6c-4.2-4.2-41.1-41.1-110.6-110.6L-5 360 40.3 314.7c13.3 13.3 32 32 56 56l0-338.7 64 0 0 338.7c24-24 42.7-42.7 56-56L261.5 360 150.9 470.6zM320.3 32l64 0 0 64-96 0 0-64 32 0zm0 128l128 0 0 64-160 0 0-64 32 0zm0 128l192 0 0 64-224 0 0-64 32 0zm0 128l256 0 0 64-288 0 0-64 32 0z"],
    "hourglass-half": [384, 512, ["hourglass-2"], "f252", "M0 0l384 0 0 64-32 0 0 77.3-9.4 9.4-105.4 105.4 114.7 114.7 0 77.3 32 0 0 64-384 0 0-64 32 0 0-77.3 9.4-9.4 105.4-105.4-105.4-105.4-9.4-9.4 0-77.3-32 0 0-64zM96 64l0 50.7 13.3 13.3 165.5 0 13.3-13.3 0-50.7-192 0zm13.3 320l165.5 0-82.7-82.7-82.7 82.7z"],
    "scalpel-line-dashed": [640, 512, ["scalpel-path"], "f61e", "M0 480L111.6 368 304 368 192 480 0 480zM416 320L159.4 320 452.6 25.9c17.2-17.3 40.6-26.9 65-26.7 49.8 .4 89.9 41.5 89.9 91.2 0 24.3-9.6 47.8-26.8 64.9L416 320zM344 432l104 0 0 48-128 0 0-48 24 0zm176 0l88 0 0 48-112 0 0-48 24 0z"],
    "cloud-snow": [512, 512, [127784], "f742", "M96 320l-96 0 0-96c0-41.8 26.7-77.4 64-90.5L64 112c0-61.9 50.1-112 112-112 43.1 0 80.5 24.3 99.2 60 14.7-17.1 36.5-28 60.8-28 44.2 0 80 35.8 80 80l0 16c53 0 96 43 96 96l0 96-416 0zm0 72l0 16 40 0 0 48-40 0 0 40-48 0 0-40-40 0 0-48 40 0 0-40 48 0 0 24zm184 32l0 16 40 0 0 48-40 0 0 40-48 0 0-40-40 0 0-48 40 0 0-40 48 0 0 24zm184-56l0 40 40 0 0 48-40 0 0 40-48 0 0-40-40 0 0-48 40 0 0-40 48 0z"],
    "square-down-right": [448, 512, [], "e26c", "M0 480l448 0 0-448-448 0 0 448zM296 352l-169.9 0c29.6-29.6 52.3-52.3 68-68l-84-84c24.3-24.3 54.1-54.1 57.9-57.9l84 84c15.7-15.7 38.4-38.4 68-68l0 193.9-24 0z"],
    "spoon": [512, 512, [129348, 61873, "utensil-spoon"], "f2e5", "M224 160.2C224 80 320 0 416 0 469 0 512 43 512 96 512 192 432 288 351.8 288l-39.6 0-21.5-21.5-220.1 220.1-22.6 22.6-45.3-45.3 22.6-22.6 220.1-220.1-21.5-21.5 0-39.6z"],
    "clock-eleven": [512, 512, [], "e347", "M256 0a256 256 0 1 1 0 512 256 256 0 1 1 0-512zM232 120l0 56.7c-14.5-21.7-25.6-38.4-33.3-50l-39.9 26.6c.4 .6 26.2 39.3 77.3 116l44-13.3 0-160-48 0 0 24z"],
    "credit-card": [512, 512, [128179, 62083, "credit-card-alt"], "f09d", "M0 64l0 96 512 0 0-96-512 0zM0 208l0 240 512 0 0-240-512 0zM64 336l96 0 0 48-96 0 0-48zm144 0l112 0 0 48-112 0 0-48z"],
    "file-invoice-dollar": [384, 512, [], "f571", "M0 0L240 0 384 144 384 512 0 512 0 0zM208 58.5L208 176 325.5 176 208 58.5zM64 64l0 32 96 0 0-32-96 0zm0 64l0 32 96 0 0-32-96 0zM176 240l0 24c-28.8 .3-52 23.7-52 52.5 0 25.7 18.5 47.6 43.9 51.8l41.7 7c6 1 10.4 6.2 10.4 12.3 0 6.9-5.6 12.5-12.5 12.5l-75.5 0 0 40 44 0 0 24 40 0 0-24.7c25-4.1 44-25.7 44-51.8 0-25.7-18.5-47.6-43.9-51.8l-41.7-7c-6-1-10.4-6.2-10.4-12.3 0-6.9 5.6-12.5 12.5-12.5l67.5 0 0-40-28 0 0-24-40 0z"],
    "violin": [640, 512, [127931], "f8ed", "M520.5 48a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM334.3 52.2l17-17-33.9-33.9-17 17-281.6 281.6-17 17 33.9 33.9 17-17 281.6-281.6zM472.5 96a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm120 72a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm48-48a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM615.1 70.6L637.7 48 592.5 2.7 569.9 25.4 417.5 177.7c-19.1-11.3-41.3-17.7-65-17.7-25.4 0-49.1 7.4-69 20.2 3.2 8.7 5 18.1 5 27.8 0 44.2-35.8 80-80 80-16.7 0-32.3-5.1-45.1-13.9-21.7 25.2-34.9 58-34.9 93.9 0 10.9 1.2 21.5 3.5 31.7 33.2-26.5 59.9-47.9 80.1-64 45.3 45.3 78.7 78.7 92.8 92.8-16.2 20.2-37.5 46.9-64 80.1 10.2 2.3 20.8 3.5 31.7 3.5 35.9 0 68.7-13.1 93.9-34.9-8.8-12.8-13.9-28.4-13.9-45.1 0-44.2 35.8-80 80-80 9.8 0 19.2 1.8 27.8 5 12.8-19.9 20.2-43.6 20.2-69 0-23.7-6.5-46-17.7-65L615.1 70.6zM151.3 445.8l-22.8 18.2 48 48c27.2-34 36.3-45.3 55.4-69.3 4-5 6.8-8.5 8.6-10.7l-32-32c-1 .8-19.2 15.3-42.3 33.8l-14.9 11.9z"],
    "spaghetti-monster-flying": [640, 512, ["pastafarianism"], "f67b", "M208 64a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm48 0c0 16.2-6 31.1-16 42.3l15.6 31.2c18.7-6 39.9-9.5 64.4-9.5s45.8 3.5 64.4 9.5L400 106.3c-10-11.3-16-26.1-16-42.3 0-35.3 28.7-64 64-64s64 28.7 64 64-28.7 64-64 64c-1.7 0-3.4-.1-5.1-.2L427.8 158c21.1 13.6 37.7 30.2 51.4 46.4 7.1 8.3 13.5 16.6 19.3 24l1.4 1.8c6.3 8.1 11.6 14.8 16.7 20.4 10.7 11.7 16.1 13.4 19.4 13.4 2.5 0 4.3-.6 7.1-3.3 3.7-3.5 7.1-8.8 12.5-17.4l.6-.9c4.6-7.4 11-17.6 19.4-25.7 9.7-9.3 22.9-16.7 40.4-16.7l24 0 0 48-24 0c-2.5 0-4.3 .6-7.1 3.3-3.7 3.5-7.1 8.8-12.5 17.4l-.6 .9c-4.6 7.4-11 17.6-19.4 25.7-9.7 9.3-22.9 16.7-40.4 16.7-18.5 0-32.9-8.5-44.3-18.6-3.1 4-6.6 8.3-10.5 12.7 1.4 4.3 2.8 8.5 4 12.5 .9 3 1.8 5.8 2.6 8.6 3 9.8 5.5 18.2 8.6 25.9 3.9 9.8 7.4 15.4 10.8 18.5 2.6 2.4 5.9 4.3 12.8 4.3 8.7 0 16.9-4.2 33.7-13.2 15-8 35.7-18.8 62.3-18.8l24 0 0 48-24 0c-13.4 0-24.7 5.2-39.7 13.2-1 .6-2.1 1.1-3.2 1.7-13.1 7.1-31.6 17.1-53.1 17.1-18.4 0-33.6-6.1-45.5-17.2-11.1-10.3-17.9-23.7-22.7-36-3.6-9-6.7-19.1-9.5-28.5-16.4 12.3-36.1 23.6-58.9 31.3 3.6 10.8 8.4 23.5 14.4 36.2 7.5 15.9 16.2 30.4 25.8 40.5 9.6 10.2 17.7 13.7 24.5 13.7l24 0 0 48-24 0c-25.2 0-45-13.5-59.5-28.8-14.5-15.4-25.7-34.9-34.2-53-8-17-14.1-33.8-18.3-46.9-5.2 .4-10.6 .6-16 .6s-10.8-.2-16-.6c-4.2 13-10.3 29.9-18.3 46.9-8.5 18.1-19.8 37.6-34.2 53-14.4 15.3-34.3 28.8-59.5 28.8l-24 0 0-48 24 0c6.8 0 15-3.5 24.5-13.7 9.5-10.1 18.3-24.6 25.8-40.5 5.9-12.6 10.7-25.4 14.4-36.2-22.8-7.7-42.5-19-58.9-31.3-2.9 9.4-6 19.5-9.5 28.5-4.8 12.2-11.6 25.6-22.7 36-11.9 11.1-27.1 17.2-45.5 17.2-21.4 0-39.9-10-53.1-17.1l0 0c-1.1-.6-2.2-1.2-3.2-1.7-15-8-26.3-13.2-39.7-13.2l-24 0 0-48 24 0c26.6 0 47.3 10.8 62.3 18.8 16.8 9 25 13.2 33.7 13.2 6.8 0 10.2-1.9 12.8-4.3 3.4-3.2 7-8.8 10.8-18.5 3-7.7 5.6-16.1 8.6-25.9 .8-2.7 1.7-5.6 2.6-8.6 1.2-4 2.6-8.2 4-12.5-3.9-4.5-7.4-8.8-10.5-12.7-11.4 10.1-25.9 18.6-44.3 18.6-17.5 0-30.7-7.4-40.4-16.7-8.4-8.1-14.8-18.3-19.4-25.7l-.6-.9c-5.4-8.6-8.8-13.9-12.5-17.4-2.8-2.7-4.6-3.3-7.1-3.3l-24 0 0-48 24 0c17.5 0 30.7 7.4 40.4 16.7 8.4 8.1 14.8 18.3 19.4 25.7l.6 .9c5.4 8.6 8.8 13.9 12.5 17.4 2.8 2.7 4.6 3.3 7.1 3.3 3.3 0 8.7-1.7 19.4-13.4 5.1-5.6 10.4-12.3 16.7-20.4l1.4-1.8c5.8-7.4 12.2-15.7 19.3-24 13.8-16.2 30.3-32.8 51.4-46.4l-15.1-30.2c-1.7 .1-3.4 .2-5.1 .2-35.3 0-64-28.7-64-64s28.7-64 64-64 64 28.7 64 64zm208 0a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"],
    "martini-glass-citrus": [640, 512, ["cocktail"], "f561", "M576 80c0-44.2-35.8-80-80-80-18 0-34.6 6-48 16l-81 0c23.6-47.4 72.5-80 129-80 79.5 0 144 64.5 144 144S575.5 224 496 224c-6.5 0-13-.4-19.3-1.3l64-74.7c1.1-1.3 2.2-2.7 3.3-4.1 19.4-14.6 32-37.8 32-64zM78 128l-14-16 0-48 448 0 0 48-14 16-167.5 191.4-10.5 12 0 116.6 96 0 0 64-256 0 0-64 96 0 0-116.6-10.5-12-167.5-191.4zM288 270.8L413 128 163 128 288 270.8z"],
    "chart-mixed-up-circle-dollar": [640, 512, [], "e5d9", "M432.5 0l-32 0 0 64 60.8 0-109.4 87.5-108.2-81.1-19.8-14.9-19.4 15.5-160 128-25 20 40 50 25-20 140.6-112.5 108.2 81.1 19.8 14.9 19.4-15.5 140-112 0 71 64 0 0-176-144 0zm-240 224l0 256 64 0 0-256-64 0zm-128 96l0 160 64 0 0-160-64 0zm400 224a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm16-240l0 24 32 0 0 32-61.8 0c-5.6 0-10.2 4.6-10.2 10.2 0 4.9 3.5 9.1 8.3 10l45 8.2c20 3.6 34.6 21.1 34.6 41.5 0 23.3-18.9 42.2-42.2 42.2l-5.8 0 0 24-32 0 0-24-32 0 0-32 69.8 0c5.6 0 10.2-4.6 10.2-10.2 0-4.9-3.5-9.1-8.3-10l-45-8.2c-20-3.6-34.6-21.1-34.6-41.5 0-22.6 17.7-41 40-42.1l0-24.1 32 0z"],
    "square-rupee": [448, 512, [], "e715", "M448 32l-448 0 0 448 448 0 0-448zM120 144l48 0c39.8 0 72 32.2 72 72 0 26.9-14.7 50.3-36.5 62.6 14.8 44.3 23.7 71.2 26.8 80.5l-45.5 15.2C182 366 172.4 337.2 156 288l-12 0 0 80-48 0 0-224 24 0zm48 96c13.3 0 24-10.7 24-24s-10.7-24-24-24l-24 0 0 48 24 0zm80 .1c0-31 25.1-56.1 56.1-56.1l63.9 0 0 48-63.9 0c-4.5 0-8.1 3.6-8.1 8.1 0 3.6 2.3 6.7 5.8 7.8L336 258.1c23.7 7.1 40 29 40 53.7 0 31-25.1 56.1-56.1 56.1l-63.9 0 0-48 63.9 0c4.5 0 8.1-3.6 8.1-8.1 0-3.6-2.3-6.7-5.8-7.8L288 293.9c-23.7-7.1-40-29-40-53.7z"],
    "clock-one-thirty": [512, 512, [], "e34f", "M256 512a256 256 0 1 1 0-512 256 256 0 1 1 0 512zm24-120l0-128.7c47.7-71.6 72.2-108.3 73.3-109.9l-39.9-26.6c-.4 .6-26.2 39.3-77.3 116l-4 6 0 167.3 48 0 0-24z"],
    "bullhorn": [512, 512, [128226, 128363], "f0a1", "M380.4 64.7l37.3-32.7 62.3 0 0 448-62.3 0-37.3-32.7c-43.6-38.1-98.7-60.3-156.4-63l0 127.7-96 0 0-128-128 0 0-256 212.5 0c61.8-.2 121.4-22.7 167.9-63.3zM224 320l0 .2c70.3 2.7 137.8 28.5 192 73.4l0-275.3c-54.2 44.9-121.7 70.7-192 73.4L224 320z"],
    "box-tissue": [512, 512, [], "e05b", "M64 32l224 0 32 96 128 0-64 192-256 0-64-288zM0 256l64.6 0C77 311.8 85.3 349.1 89.5 368l329.1 0c4.7-14.2 17.2-51.5 37.3-112l56.1 0 0 224-512 0 0-224z"],
    "do-not-enter": [512, 512, [], "f5ec", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM416 224l0 64-320 0 0-64 320 0z"],
    "angle": [512, 512, [], "e08c", "M284.9 78.3l14.3-28.6-57.2-28.6-14.3 28.6-192 384-23.2 46.3 467.8 0 0-64-364.2 0 168.8-337.7zm83.7 209.1l-40.9 25.4c9 17.5 16.3 36 21.7 55.2l49.6 0c-6.8-28.4-17.1-55.4-30.4-80.6zM302.3 272l40.9-25.4c-16.6-23-36.1-43.9-57.7-62.1l-22.2 44.3c14.4 13.1 27.4 27.5 39 43.1z"],
    "house-unlock": [640, 512, [], "e6ca", "M368 512l0-208 32 0c0-60 41.2-110.3 96.9-124.2L288-16 32 224 32 272 80 272 80 512 368 512zM224 464l0-144 96 0 0 144-96 0zM528 272c17.7 0 32 14.3 32 32l48 0c0-44.2-35.8-80-80-80s-80 35.8-80 80l0 48-32 0 0 192 224 0 0-192-144 0 0-48c0-17.7 14.3-32 32-32z"],
    "mattress-pillow": [576, 512, [], "e525", "M256 64l-256 0 0 384 256 0 0-384zm48 384l272 0 0-384-272 0 0 384zM64 128l128 0 0 256-128 0 0-256z"],
    "message-dot": [576, 512, [], "e6df", "M496 0a80 80 0 1 1 0 160 80 80 0 1 1 0-160zm0 208c17 0 33.2-3.3 48-9.3l0 249.3-224 0-160 96 0-96-128 0 0-416 345.3 0c-6 14.8-9.3 31-9.3 48 0 70.7 57.3 128 128 128z"],
    "cricket-bat-ball": [640, 512, [127951, "cricket"], "f449", "M621.5 0l-22.6 22.6-160 160 73.4 73.4-32 32-192 0 0-192 32-32 73.4 73.4 160-160 22.6-22.6 45.3 45.3zM240.3 144l0 192 192 0-176 176-32 0c-88.4 0-160-71.6-160-160l0-32 176-176zm256 240a80 80 0 1 1 0 160 80 80 0 1 1 0-160z"],
    "chevron-left": [320, 512, [9001], "f053", "M3 256l22.6 22.6 192 192 22.6 22.6 45.3-45.3-22.6-22.6-169.4-169.4 169.4-169.4 22.6-22.6-45.3-45.3-22.6 22.6-192 192-22.6 22.6z"],
    "cloud-moon-rain": [576, 512, [], "f73c", "M418.4 135c0 69 56 125 125 125 11.6 0 22.8-1.6 33.4-4.5-29.2 39.2-75.8 64.5-128.4 64.5-16.7 0-32.8-2.6-48-7.3l0-40.7c0-48.6-27-90.8-66.9-112.5-5.4-22.2-17.9-41.7-34.9-55.8 22.8-60.6 81.3-103.8 149.8-103.8 23.1 0 45 4.9 64.8 13.7-54.5 13.5-94.8 62.7-94.8 121.3zM.4 352l0-80c0-33.9 21.1-62.9 50.9-74.5-1.9-6.8-2.9-14-2.9-21.5 0-44.2 35.8-80 80-80 30.8 0 57.5 17.4 70.9 42.8 9.3-6.8 20.7-10.8 33.1-10.8 34.3 0 60.9 32 55.2 65.4 36.9 7.1 64.8 39.6 64.8 78.6l0 80-352 0zm44 48l50.6 0-37.3 112-50.6 0 37.3-112zM335 400l-37.3 112-50.6 0 37.3-112 50.6 0zm-120 0l-37.3 112-50.6 0 37.3-112 50.6 0z"],
    "arrow-down-1-9": [576, 512, ["sort-numeric-asc", "sort-numeric-down"], "f162", "M182.9 470.6l-22.6 22.6c-2.9-2.9-42.4-42.4-118.6-118.6L19 352 64.3 306.7c12 12 33.3 33.3 64 64l0-338.7 64 0 0 338.7c30.7-30.7 52-52 64-64L301.5 352c-2.9 2.9-42.4 42.4-118.6 118.6zM352.3 32l112 0 0 128 48 0 0 64-160 0 0-64 48 0 0-64-48 0 0-64zm25.6 448l36.6-66c-35.6-8.1-62.3-39.9-62.3-78 0-44.2 35.8-80 80-80s80 35.8 80 80c0 22.2-5.7 44.1-16.5 63.5l-44.7 80.5-73.2 0zm54.4-120a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"],
    "bin-bottles-recycle": [576, 512, [], "e5f6", "M96 32l0 64c-35.3 0-64 28.7-64 64l0 16 512 0 0-16c0-35.3-28.7-64-64-64l0-64-128 0 0 64c-35.3 0-64 28.7-64 64 0-35.3-28.7-64-64-64l0-64-128 0zM0 224l0 64 36 0 28 224 448 0 28-224 36 0 0-64-576 0zm259.8 32l56.3 0 7.2 9.8 40.5 55.2-40.8 25.5-31.2-42.5-7.7 0-31.2 42.5-40.8-25.5 40.5-55.2 7.2-9.8zm86.9 122.9l40.8-25.5 23.8 32.4 4.6 6.3 0 71.9-108 0 0-48 60 0 0-8.1-21.3-29zM208 416l60 0 0 48-108 0 0-71.9 4.6-6.3 23.8-32.4 40.8 25.5-21.3 29 0 8.1z"],
    "bring-front": [576, 512, [], "f857", "M64 32l96 0 0 16 64 0 0-80-224 0 0 224 80 0 0-64-16 0 0-96zM352 480l0 64 224 0 0-224-80 0 0 64 16 0 0 96-96 0 0-16-64 0 0 16zM448 96l-320 0 0 320 320 0 0-320z"],
    "seat-airline": [384, 512, [], "e244", "M64 0l0 154.8 12.4 37.2 243.6 0 0 64-222.3 0 21.3 64 264.9 0 0 64-311.1 0-7.3-21.9-64-192-1.6-4.9 0-165.2 64 0zM32 448l352 0 0 64-352 0 0-64z"],
    "square-tenge": [448, 512, [], "e731", "M448 32l-448 0 0 448 448 0 0-448zM336 128l0 32-224 0 0-32 224 0zm0 64l0 48-88 0 0 144-48 0 0-144-88 0 0-48 224 0z"],
    "hand-spock": [512, 512, [128406], "f259", "M219.5 39.7l-8.3-30.9-61.8 16.6 8.3 30.9 53.5 199.7-29.6 0-46.7-153.3-9.3-30.6-61.2 18.6 9.3 30.6 71.7 235.5c-46.5-44.3-76.6-73-90.5-86.2L-.4 328.5c8.1 7.7 49.9 47.5 125.4 119.5 43.1 41.1 100.4 64 160 64l19.5 0c56.7 0 106.7-37.3 122.8-91.7l83.7-283.2 9.1-30.7-61.4-18.1c-.8 2.7-17.3 58.7-49.6 167.8l-24.7 0 39.2-185.4 6.6-31.3-62.6-13.2-6.6 31.3-42 198.6-41.5 0-57.9-216.3z"],
    "wand-magic-sparkles": [640, 512, ["magic-wand-sparkles"], "e2ca", "M288 112l-24-56-56-24 56-24 24-56 24 56 56 24-56 24-24 56zM16 128l80-32 32-80 32 80 80 32-80 32-32 80-32-80-80-32zM464 368l32-80 32 80 80 32-80 32-32 80-32-80-80-32 80-32zM496-13.3L589.3 80 471.6 197.7 378.3 104.4 496-13.3zM50.7 432L344.4 138.3 437.7 231.6 144 525.3 50.7 432z"],
    "panel-ews": [448, 512, [], "e42e", "M448 32L0 32 0 352 64 352c22.1 0 40-17.9 40-40l0-56-40 0 0-160 128 0 0 160-40 0 0 56c0 48.6-39.4 88-88 88l-64 0 0 80 448 0 0-448zM280 96l104 0 0 48-128 0 0-48 24 0zm0 96l104 0 0 48-128 0 0-48 24 0zm104 96l0 128-128 0 0-128 128 0z"],
    "comment-medical": [512, 512, [], "f7f5", "M512 240c0 132.5-114.6 240-256 240-38.3 0-74.7-7.9-107.3-22.1L0 512 55.7 389.5C20.8 348.5 0 296.5 0 240 0 107.5 114.6 0 256 0S512 107.5 512 240zM217.6 201.6l-67.2 0 0 76.8 67.2 0 0 67.2 76.8 0 0-67.2 67.2 0 0-76.8-67.2 0 0-67.2-76.8 0 0 67.2z"],
    "bell-slash": [576, 512, [128277, 61943], "f1f6", "M49.3-16.9l-17-17-33.9 33.9 17 17 512 512 17 17 33.9-33.9c-1-1-33-33-96.1-96.1l46 0-80-128 0-96c0-77.4-55-142-128-156.8l0-35.2-64 0 0 35.2C217.6 43 184.1 64.7 161 94.8L49.3-16.9zM128.1 288l-80 128 286.9 0-206.9-206.9 0 78.9zm98 176c7.1 27.6 32.2 48 62 48s54.9-20.4 62-48l-124 0z"],
    "handshake-slash": [576, 512, [57439, "handshake-alt-slash", "handshake-simple-slash"], "e060", "M49.3-16.9l-17-17-33.9 33.9 17 17 512 512 17 17 33.9-33.9-17-17-280.1-280.1 31-31 0 0c34.8 34.5 99.3 98.5 193.6 192l70.4-56 0-288-112 64-48-32-128 0 0 0-74.8 83.1-34-34 44.2-49.1-63.4 0-18 12-92.9-92.9zM.1 69.8l0 250.2 192 160 62.1 0c-3-3-11-11-24-24l33.9-33.9c7.3 7.3 26.6 26.6 57.9 57.9l62.1 0 14.3-11.9-398.3-398.3z"],
    "pizza": [576, 512, [127829], "f817", "M256 464c57.4 0 109.4-23.3 147.1-60.9L437 437c-46.3 46.3-110.3 75-181 75-141.4 0-256-114.6-256-256S114.6 0 256 0c70.7 0 134.7 28.7 181 75l-33.9 33.9C365.4 71.3 313.4 48 256 48 141.1 48 48 141.1 48 256s93.1 208 208 208zm124.5-83.5c-68.7 68.7-180.2 68.7-248.9 0s-68.7-180.2 0-248.9 180.2-68.7 248.9 0L256 256 380.5 380.5zM192 264a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm24-72a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm72 184a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm190.6 14.6C509.4 354.3 528 307.3 528 256s-18.6-98.3-49.4-134.6l34-34c39.5 45 63.4 104 63.4 168.6s-23.9 123.6-63.4 168.6l-34-34zM344 256l35.5-35.5c3.6 2.2 7.9 3.5 12.5 3.5 13.3 0 24-10.7 24-24 0-4.6-1.3-8.9-3.5-12.5l43.4-43.4c53.5 64.8 53.5 158.9 0 223.8L344 256zm104 48a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"],
    "bottle-water": [320, 512, [], "e4c5", "M240-32l0 64-160 0 0-64 160 0zM16 144c0-35.3 28.7-64 64-64l160 0c35.3 0 64 28.7 64 64 0 24.1-13.3 45.1-33 56 19.7 10.9 33 31.9 33 56s-13.3 45.1-33 56c19.7 10.9 33 31.9 33 56s-13.3 45.1-33 56c19.7 10.9 33 31.9 33 56l0 64-288 0 0-64c0-24.1 13.3-45.1 33-56-19.7-10.9-33-31.9-33-56s13.3-45.1 33-56c-19.7-10.9-33-31.9-33-56s13.3-45.1 33-56c-19.7-10.9-33-31.9-33-56z"],
    "user-police-tie-hair-long": [448, 512, [], "e7b6", "M65.7 11.2L215.6-29.7c5.5-1.5 11.3-1.5 16.8 0L382.3 11.2c10.5 2.9 17.7 12.4 17.7 23.2 0 8.5-4.4 16.3-11.7 20.6L368 67.2 368 91.8c0 11.4-6 21.8-16 26.7l0 57.5 48 96-352 0 48-96 0-57.5c-10-5-16-15.4-16-26.7L80 67.2 59.7 55C52.4 50.7 48 42.8 48 34.4 48 23.5 55.3 14 65.7 11.2zM304 144l0-10.3c-23.2 5.7-50.9 10.3-80 10.3s-56.8-4.6-80-10.3l0 10.3c0 44.2 35.8 80 80 80s80-35.8 80-80zM272 328l-31.6 36.9 31 115.1 .6 0 40-160 56 0 64 192-416 0 64-192 56 0 40 160 31.4-115.3-31.4-36.7 0-24 96 0 0 24zM264 64l-40-40-40 40 40 40 40-40z"],
    "folders": [576, 512, [], "f660", "M576 384l-480 0 0-384 208 0 64 64 208 0 0 320zM48 120l0 312 432 0 0 48-480 0 0-384 48 0 0 24z"],
    "sun-dust": [576, 512, [], "f764", "M409.7 14.7l17.5 86.3-56.8 56.8c-22.2-18.6-50.9-29.8-82.2-29.8-70.7 0-128 57.3-128 128 0 31.3 11.2 59.9 29.8 82.2l-56.8 56.8C67.2 381.6 26.7 373.4 12 370.4 19.1 359.8 44.4 321.6 87.9 256 44.4 190.4 19.1 152.2 12 141.6 24.5 139 69.4 130 146.6 114.3 162.2 37.1 171.3-7.7 173.8-20.2 184.5-13.2 222.6 12.1 288.2 55.7 353.9 12.1 392-13.2 402.6-20.2l7.1 35zM288.2 176c18 0 34.6 6 48 16l-112 112c-10-13.4-16-30-16-48 0-44.2 35.8-80 80-80zm192-16a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm-80 80a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm112 48a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm-240 80a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm-80 80a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm128 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm192-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm-112-48a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm-48-112a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "dice-d20": [512, 512, [], "f6cf", "M512 118.9L512 409.1 256 554.1 0 409.1 0 118.9 256-26.1 512 118.9zM165.5 192l-.4 0-91.6-49.6-.7-.4-16.8 9.6 0 26.8 88.9 48.2-88.9 149.4 180 64.8 0 37.7 20 11.3 20-11.3 0-37.7 180-64.8-88.9-149.4 88.9-48.2 0-26.8-16.8-9.6-.7 .4-91.6 49.6-.4 0-90.5-152-90.5 152zm64.6 204.1l-114.9-41.3 51.2-86 63.7 127.4zm166.8-41.3l-114.9 41.3 63.7-127.4 51.2 86zM319.3 232L256 358.6 192.7 232 319.3 232zm-19.4-40l-87.8 0 43.9-73.8 43.9 73.8z"],
    "folder-gear": [512, 512, ["folder-cog"], "e187", "M512 448l-512 0 0-416 224 0 64 48 224 0 0 368zM284 160l-56 0 0 29.1c-11.1 3.7-21.2 9.7-29.8 17.2l-25.2-14.5-28 48.5 25.2 14.5c-1.1 5.6-1.7 11.3-1.7 17.2s.6 11.6 1.7 17.2l-25.2 14.5 28 48.5 25.2-14.5c8.6 7.6 18.7 13.5 29.8 17.2l0 29.1 56 0 0-29.1c11.1-3.7 21.2-9.7 29.8-17.2l25.2 14.6 28-48.5-25.2-14.5c1.1-5.6 1.7-11.3 1.7-17.2s-.6-11.6-1.7-17.2l25.2-14.5-28-48.5-25.2 14.6c-8.6-7.6-18.7-13.5-29.8-17.2l0-29.1zM224 272a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"],
    "almost-equal-to": [512, 512, [], "e818", "M478.2 333.2c-12.2 48.7-55.9 82.8-106.1 82.8-10.9 0-21.7-1.6-32.2-4.8L154.2 354c-4.3-1.3-8.8-2-13.3-2-20.8 0-38.9 14.2-44 34.3l-7.4 29.7-65.9 0 11.3-45.2c12.2-48.7 55.9-82.8 106.1-82.8 10.9 0 21.7 1.6 32.2 4.8L358.8 350c4.3 1.3 8.8 2 13.3 2 20.8 0 38.9-14.1 44-34.3l7.4-29.7 65.9 0-11.3 45.2zm0-192c-12.2 48.7-55.9 82.8-106.1 82.8-10.9 0-21.7-1.6-32.2-4.8L154.2 162c-4.3-1.3-8.8-2-13.3-2-20.8 0-38.9 14.2-44 34.3l-7.4 29.7-65.9 0 11.3-45.2c12.2-48.7 55.9-82.8 106.1-82.8 10.9 0 21.7 1.6 32.2 4.8L358.8 158c4.3 1.3 8.8 2 13.3 2 20.8 0 38.9-14.1 44-34.3l7.4-29.7 65.9 0-11.3 45.2z"],
    "arrow-down-z-a": [512, 512, ["sort-alpha-desc", "sort-alpha-down-alt"], "f881", "M150.9 470.6l-22.6 22.6c-5.5-5.5-39.7-39.7-102.6-102.6L3 368 48.3 322.7c14.6 14.6 30.6 30.6 48 48l0-338.7 64 0 0 338.7c17.4-17.4 33.4-33.4 48-48L253.5 368c-5.5 5.5-39.7 39.7-102.6 102.6zM448.3 32l32 0 0 45.3-9.4 9.4-73.4 73.4 82.7 0 0 64-192 0 0-45.3 9.4-9.4 73.4-73.4-82.7 0 0-64 160 0zm-94 224l60 0 7.9 20.5 78.3 203.5-68.6 0-12.3-32-70.5 0-12.3 32-68.6 0 78.3-203.5 7.9-20.5zm30 100.3l-16.8 43.7 33.6 0-16.8-43.7z"],
    "brush": [384, 512, [], "f55d", "M192 64l-32-64-32 0-32 64-32-64-64 0 0 256 384 0 0-256-160 0-32 64zM0 304l0 80 128 0 0 128 128 0 0-128 128 0 0-80-384 0zM192 464c-8.8 0-16-7.2-16-16s7.2-16 16-16 16 7.2 16 16-7.2 16-16 16z"],
    "person-walking-dashed-line-arrow-right": [640, 512, [], "e553", "M216 24a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zM112 112l-13.3 0-9.4 9.4-80 80-9.4 9.4 0 109.3 64 0 0-82.7 32-32 0 69.3c0 28 12.2 54.7 33.5 72.9l80.7 69.1c11 71.6 17.4 112.9 19.1 123.9l63.3-9.7c-1.4-9-8.3-54.2-20.9-135.6l-1.8-11.7-9-7.7-52.8-45.3 0-115.2c17.6 22 28.4 35.6 32.6 40.8l111.4 0 0-64-80.6 0-54.4-68-9.6-12-95.4 0zM96.1 371L83.5 415.2C38.8 459.9 11.9 486.8 2.7 496l45.3 45.3 86.6-86.6 5.9-5.9c.8-2.7 3.8-13.2 9-31.5l-46-39.4c-2.5-2.2-5-4.4-7.4-6.8zM609 273l17-17c-2.1-2.1-31.8-31.8-89-89l-17-17-33.9 33.9c9 9 25 25 48 48l-126.1 0 0 48 126.1 0c-23 23-39 39-48 48L520 361.9c2.1-2.1 31.8-31.8 89-89zM432-16l-48 0 0 80 48 0 0-80zm0 152l0-24-48 0 0 80 48 0 0-56zm0 184l-48 0 0 80 48 0 0-80zm0 152l0-24-48 0 0 80 48 0 0-56z"],
    "arrow-up-short-wide": [576, 512, ["sort-amount-up-alt"], "f885", "M150.9 41.4L128.3 18.7c-4.2 4.2-41.1 41.1-110.6 110.6L-5 152 40.3 197.3c13.3-13.3 32-32 56-56l0 338.7 64 0 0-338.7c24 24 42.7 42.7 56 56L261.5 152c-4.2-4.2-41.1-41.1-110.6-110.6zM320.3 32l-32 0 0 64 96 0 0-64-64 0zm0 128l-32 0 0 64 160 0 0-64-128 0zm0 128l-32 0 0 64 224 0 0-64-192 0zm0 128l-32 0 0 64 288 0 0-64-256 0z"],
    "grip-vertical": [320, 512, ["grid-vertical"], "f58e", "M128 0L0 0 0 128 128 128 128 0zm0 192l-128 0 0 128 128 0 0-128zM0 384l0 128 128 0 0-128-128 0zM320 0l-128 0 0 128 128 0 0-128zM192 192l0 128 128 0 0-128-128 0zM320 384l-128 0 0 128 128 0 0-128z"],
    "car-tunnel": [512, 512, [], "e4de", "M256 0C114.6 0 0 114.6 0 256l0 256 96 0 0-157.6 2.5-5 55.1-112 6.6-13.4 191.7 0 6.6 13.4 55.1 112 2.5 5 0 157.6 96 0 0-256C512 114.6 397.4 0 256 0zm96 512l0-48-192 0 0 48 192 0zm1.4-176l-31.5-64-131.9 0-31.5 64 194.9 0zM176 424a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm184-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"],
    "chart-column": [512, 512, [], "e0e3", "M64 32l0 384 448 0 0 64-512 0 0-448 64 0zM176 224l0 128-64 0 0-128 64 0zm112-64l0 192-64 0 0-224 64 0 0 32zm112 32l0 160-64 0 0-160 64 0zM512 96l0 256-64 0 0-288 64 0 0 32z"],
    "send-back": [576, 512, [], "f87e", "M160 32l0 96-96 0 0-96 96 0zM64-32l-64 0 0 224 224 0 0-224-160 0zM512 384l0 96-96 0 0-96 96 0zm-96-64l-64 0 0 224 224 0 0-224-160 0zM128 240l0 176 176 0 0-144 144 0 0-176-176 0 0 144-144 0z"],
    "comment-arrow-up-right": [512, 512, [], "e145", "M512 240c0 132.5-114.6 240-256 240-38.3 0-74.7-7.9-107.3-22.1L0 512 55.7 389.5C20.8 348.5 0 296.5 0 240 0 107.5 114.6 0 256 0S512 107.5 512 240zM216 192l54.1 0-103 103-17 17 33.9 33.9 17-17 103-103 0 78.1 48 0 0-160-160 0 0 48 24 0z"],
    "truck-arrow-right": [576, 512, [], "e58b", "M416 32L0 32 0 448 67.3 448c10.4 36.9 44.4 64 84.7 64s74.2-27.1 84.7-64l102.6 0c10.4 36.9 44.4 64 84.7 64s74.2-27.1 84.7-64l67.3 0 0-237.3-9.4-9.4-64-64-9.4-9.4-77.3 0 0-96zm96 205.3l0 50.7-96 0 0-96 50.7 0 45.3 45.3zM152 384a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm232 40a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zM305 225c-57.2 57.2-86.8 86.8-89 89L182.1 280c9-9 25-25 48-48l-126.1 0 0-48 126.1 0c-23-23-39-39-48-48L216 102.1c2.1 2.1 31.8 31.8 89 89l17 17-17 17z"],
    "tv": [576, 512, [63717, "television", "tv-alt"], "f26c", "M64 96l0 240 448 0 0-240-448 0zM0 32l576 0 0 368-576 0 0-368zM160 448l288 0 0 64-320 0 0-64 32 0z"],
    "section": [256, 512, [], "e447", "M110 0C49.2 0 0 49.2 0 110 0 133.7 7.6 155.8 20.5 174 7.6 192 0 214.1 0 238 0 291.7 38.9 337.6 91.9 346.4l61.7 10.3c22.2 3.7 38.4 22.9 38.4 45.3 0 25.4-20.6 46-46 46l-130 0 0 64 130 0c60.7 0 110-49.2 110-110 0-23.7-7.6-45.9-20.5-64 12.9-18 20.5-40.1 20.5-64 0-53.8-38.9-99.6-91.9-108.5l-61.7-10.3C80.2 151.6 64 132.4 64 110 64 84.6 84.6 64 110 64l130 0 0-64-130 0zm74.7 299.1c-6.5-2.4-13.4-4.3-20.5-5.5l-61.7-10.3c-22.2-3.7-38.4-22.9-38.4-45.3 0-9.2 2.7-17.8 7.4-25 6.5 2.4 13.4 4.3 20.5 5.5l61.7 10.3c22.2 3.7 38.4 22.9 38.4 45.3 0 9.2-2.7 17.8-7.4 25z"],
    "paragraph-left": [448, 512, ["paragraph-rtl"], "f878", "M152.3 0C86 0 32.3 53.7 32.3 120S86 240 152.3 240l40 0 0 112 64 0 0-288 48 0 0 288 64 0 0-288 48 0 0-64-264 0zm-1.4 406.6l22.6-22.6-45.3-45.3c-8.2 8.2-37.1 37.1-86.6 86.6L19 448c8.2 8.2 37.1 37.1 86.6 86.6l22.6 22.6 45.3-45.3-32-32 274.7 0 0-64-274.7 0 9.4-9.4z"],
    "tree-decorated": [512, 512, [], "f7dc", "M273.1 10.2C377.4 137.6 430.7 202.8 433.2 205.8l-73.9 0c70.3 82.2 112 131 125 146.2l-105.1 0c80.3 93.7 126 147 137.2 160L-4 512c11.1-13 56.8-66.3 137.2-160L28.1 352c13-15.2 54.7-64 125-146.2l-73.8 0 29.2-35.6 130.9-160 16.9-20.7 16.9 20.7zM320.2 392a24 24 0 1 0 0 48 24 24 0 1 0 0-48zm-128-128a24 24 0 1 0 0 48 24 24 0 1 0 0-48zm96-128a24 24 0 1 0 0 48 24 24 0 1 0 0-48z"],
    "bin-bottles": [576, 512, [], "e5f5", "M224 32l0 64c35.3 0 64 28.7 64 64 0-35.3 28.7-64 64-64l0-64 128 0 0 64c35.3 0 64 28.7 64 64l0 16-512 0 0-16c0-35.3 28.7-64 64-64l0-64 128 0zM0 288l0-64 576 0 0 64-36 0-28 224-448 0-28-224-36 0z"],
    "peace": [512, 512, [9774], "f67c", "M224 445.3l0-121.8-94.3 77.1c26.1 22.8 58.5 38.7 94.3 44.7zM89.2 351.1L224 240.8 224 66.7c-90.8 15.2-160 94.2-160 189.3 0 34.6 9.2 67.1 25.2 95.1zm293.1 49.5l-94.3-77.1 0 121.8c35.7-6 68.1-21.9 94.3-44.7zm40.6-49.5c16-28 25.2-60.5 25.2-95.1 0-95.1-69.2-174.1-160-189.3l0 174.2 134.8 110.3zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0z"],
    "star": [576, 512, [11088, 61446], "f005", "M288.2-52.8l-92.6 181.4-201.1 32 143.9 144.1-31.7 201.2 181.5-92.3 181.5 92.3-31.7-201.2 143.9-144.1-201.1-32-92.6-181.4z"],
    "store-lock": [640, 512, [], "e4a6", "M80 32l-64 176 80 32 72-32 56 32 64-32 64 32 56-32 24.4 10.9c23.4-26.3 57.6-42.9 95.6-42.9 7.1 0 14.2 .6 21 1.7L496 32 80 32zm48 320l0-73.7c-7.3 3.3-17.7 7.9-31 13.8-13.3-5.3-24.3-9.7-33-13.2l0 201.1 304 0 0-128-240 0zm400-80c17.7 0 32 14.3 32 32l0 48-64 0 0-48c0-17.7 14.3-32 32-32zm-80 32l0 48-32 0 0 192 224 0 0-192-32 0 0-48c0-44.2-35.8-80-80-80s-80 35.8-80 80z"],
    "flag": [448, 512, [127988, 61725], "f024", "M64 32l0-32-64 0 0 512 64 0 0-153.6 62.7-18.8c41.9-12.6 87.1-8.7 126.2 10.9 42.7 21.4 92.5 24 137.2 7.2L448 336 448 16 391.4 44.3c-44.9 22.5-97.8 22.5-142.8 0-36.4-18.2-78.3-21.8-117.2-10.1L64 54.4 64 32z"],
    "square-e": [448, 512, [], "e26d", "M448 32l-448 0 0 448 448 0 0-448zM168 144l136 0 0 48-112 0 0 40 96 0 0 48-96 0 0 40 112 0 0 48-160 0 0-224 24 0z"],
    "triangle-exclamation": [576, 512, [9888, "exclamation-triangle", "warning"], "f071", "M560 480L16 480 288-16 560 480zM260 356l0 56 56 0 0-56-56 0zm-4-196l12.8 160 38.4 0 12.8-160-64 0z"],
    "face-smirking": [512, 512, [], "e397", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM384