/*!
 * Font Awesome Pro 7.1.0 by @fontawesome - https://fontawesome.com
 * License - https://fontawesome.com/license (Commercial License)
 * Copyright 2025 Fonticons, Inc.
 */
(function () {
  'use strict';

  var _WINDOW = {};
  var _DOCUMENT = {};
  try {
    if (typeof window !== 'undefined') _WINDOW = window;
    if (typeof document !== 'undefined') _DOCUMENT = document;
  } catch (e) {} // eslint-disable-line no-empty

  var _ref = _WINDOW.navigator || {},
    _ref$userAgent = _ref.userAgent,
    userAgent = _ref$userAgent === void 0 ? '' : _ref$userAgent;
  var WINDOW = _WINDOW;
  var DOCUMENT = _DOCUMENT;
  var IS_BROWSER = !!WINDOW.document;
  var IS_DOM = !!DOCUMENT.documentElement && !!DOCUMENT.head && typeof DOCUMENT.addEventListener === 'function' && typeof DOCUMENT.createElement === 'function';
  var IS_IE = ~userAgent.indexOf('MSIE') || ~userAgent.indexOf('Trident/');

  function _arrayLikeToArray(r, a) {
    (null == a || a > r.length) && (a = r.length);
    for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e];
    return n;
  }
  function _arrayWithoutHoles(r) {
    if (Array.isArray(r)) return _arrayLikeToArray(r);
  }
  function _defineProperty(e, r, t) {
    return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, {
      value: t,
      enumerable: !0,
      configurable: !0,
      writable: !0
    }) : e[r] = t, e;
  }
  function _iterableToArray(r) {
    if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r);
  }
  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }
  function ownKeys(e, r) {
    var t = Object.keys(e);
    if (Object.getOwnPropertySymbols) {
      var o = Object.getOwnPropertySymbols(e);
      r && (o = o.filter(function (r) {
        return Object.getOwnPropertyDescriptor(e, r).enumerable;
      })), t.push.apply(t, o);
    }
    return t;
  }
  function _objectSpread2(e) {
    for (var r = 1; r < arguments.length; r++) {
      var t = null != arguments[r] ? arguments[r] : {};
      r % 2 ? ownKeys(Object(t), !0).forEach(function (r) {
        _defineProperty(e, r, t[r]);
      }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) {
        Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r));
      });
    }
    return e;
  }
  function _toConsumableArray(r) {
    return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread();
  }
  function _toPrimitive(t, r) {
    if ("object" != typeof t || !t) return t;
    var e = t[Symbol.toPrimitive];
    if (void 0 !== e) {
      var i = e.call(t, r || "default");
      if ("object" != typeof i) return i;
      throw new TypeError("@@toPrimitive must return a primitive value.");
    }
    return ("string" === r ? String : Number)(t);
  }
  function _toPropertyKey(t) {
    var i = _toPrimitive(t, "string");
    return "symbol" == typeof i ? i : i + "";
  }
  function _unsupportedIterableToArray(r, a) {
    if (r) {
      if ("string" == typeof r) return _arrayLikeToArray(r, a);
      var t = {}.toString.call(r).slice(8, -1);
      return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0;
    }
  }

  var _dt;
  var q = {
      classic: {
        fa: "solid",
        fas: "solid",
        "fa-solid": "solid",
        far: "regular",
        "fa-regular": "regular",
        fal: "light",
        "fa-light": "light",
        fat: "thin",
        "fa-thin": "thin",
        fab: "brands",
        "fa-brands": "brands"
      },
      duotone: {
        fa: "solid",
        fad: "solid",
        "fa-solid": "solid",
        "fa-duotone": "solid",
        fadr: "regular",
        "fa-regular": "regular",
        fadl: "light",
        "fa-light": "light",
        fadt: "thin",
        "fa-thin": "thin"
      },
      sharp: {
        fa: "solid",
        fass: "solid",
        "fa-solid": "solid",
        fasr: "regular",
        "fa-regular": "regular",
        fasl: "light",
        "fa-light": "light",
        fast: "thin",
        "fa-thin": "thin"
      },
      "sharp-duotone": {
        fa: "solid",
        fasds: "solid",
        "fa-solid": "solid",
        fasdr: "regular",
        "fa-regular": "regular",
        fasdl: "light",
        "fa-light": "light",
        fasdt: "thin",
        "fa-thin": "thin"
      },
      slab: {
        "fa-regular": "regular",
        faslr: "regular"
      },
      "slab-press": {
        "fa-regular": "regular",
        faslpr: "regular"
      },
      thumbprint: {
        "fa-light": "light",
        fatl: "light"
      },
      whiteboard: {
        "fa-semibold": "semibold",
        fawsb: "semibold"
      },
      notdog: {
        "fa-solid": "solid",
        fans: "solid"
      },
      "notdog-duo": {
        "fa-solid": "solid",
        fands: "solid"
      },
      etch: {
        "fa-solid": "solid",
        faes: "solid"
      },
      jelly: {
        "fa-regular": "regular",
        fajr: "regular"
      },
      "jelly-fill": {
        "fa-regular": "regular",
        fajfr: "regular"
      },
      "jelly-duo": {
        "fa-regular": "regular",
        fajdr: "regular"
      },
      chisel: {
        "fa-regular": "regular",
        facr: "regular"
      },
      utility: {
        "fa-semibold": "semibold",
        fausb: "semibold"
      },
      "utility-duo": {
        "fa-semibold": "semibold",
        faudsb: "semibold"
      },
      "utility-fill": {
        "fa-semibold": "semibold",
        faufsb: "semibold"
      }
    };
  var i = "classic",
    t = "duotone",
    d = "sharp",
    l = "sharp-duotone",
    f = "chisel",
    n = "etch",
    h = "jelly",
    o = "jelly-duo",
    u = "jelly-fill",
    g = "notdog",
    s = "notdog-duo",
    y = "slab",
    m = "slab-press",
    e = "thumbprint",
    p = "utility",
    a = "utility-duo",
    w = "utility-fill",
    x = "whiteboard",
    b = "Classic",
    c = "Duotone",
    I = "Sharp",
    F = "Sharp Duotone",
    v = "Chisel",
    S = "Etch",
    A = "Jelly",
    P = "Jelly Duo",
    j = "Jelly Fill",
    B = "Notdog",
    N = "Notdog Duo",
    k = "Slab",
    D = "Slab Press",
    T = "Thumbprint",
    C = "Utility",
    W = "Utility Duo",
    K = "Utility Fill",
    R = "Whiteboard",
    dt = (_dt = {}, _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_dt, i, b), t, c), d, I), l, F), f, v), n, S), h, A), o, P), u, j), g, B), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_dt, s, N), y, k), m, D), e, T), p, C), a, W), w, K), x, R));
  var gt = {
      classic: {
        900: "fas",
        400: "far",
        normal: "far",
        300: "fal",
        100: "fat"
      },
      duotone: {
        900: "fad",
        400: "fadr",
        300: "fadl",
        100: "fadt"
      },
      sharp: {
        900: "fass",
        400: "fasr",
        300: "fasl",
        100: "fast"
      },
      "sharp-duotone": {
        900: "fasds",
        400: "fasdr",
        300: "fasdl",
        100: "fasdt"
      },
      slab: {
        400: "faslr"
      },
      "slab-press": {
        400: "faslpr"
      },
      whiteboard: {
        600: "fawsb"
      },
      thumbprint: {
        300: "fatl"
      },
      notdog: {
        900: "fans"
      },
      "notdog-duo": {
        900: "fands"
      },
      etch: {
        900: "faes"
      },
      chisel: {
        400: "facr"
      },
      jelly: {
        400: "fajr"
      },
      "jelly-fill": {
        400: "fajfr"
      },
      "jelly-duo": {
        400: "fajdr"
      },
      utility: {
        600: "fausb"
      },
      "utility-duo": {
        600: "faudsb"
      },
      "utility-fill": {
        600: "faufsb"
      }
    };
  var _t = {
      chisel: {
        regular: "facr"
      },
      classic: {
        brands: "fab",
        light: "fal",
        regular: "far",
        solid: "fas",
        thin: "fat"
      },
      duotone: {
        light: "fadl",
        regular: "fadr",
        solid: "fad",
        thin: "fadt"
      },
      etch: {
        solid: "faes"
      },
      jelly: {
        regular: "fajr"
      },
      "jelly-duo": {
        regular: "fajdr"
      },
      "jelly-fill": {
        regular: "fajfr"
      },
      notdog: {
        solid: "fans"
      },
      "notdog-duo": {
        solid: "fands"
      },
      sharp: {
        light: "fasl",
        regular: "fasr",
        solid: "fass",
        thin: "fast"
      },
      "sharp-duotone": {
        light: "fasdl",
        regular: "fasdr",
        solid: "fasds",
        thin: "fasdt"
      },
      slab: {
        regular: "faslr"
      },
      "slab-press": {
        regular: "faslpr"
      },
      thumbprint: {
        light: "fatl"
      },
      utility: {
        semibold: "fausb"
      },
      "utility-duo": {
        semibold: "faudsb"
      },
      "utility-fill": {
        semibold: "faufsb"
      },
      whiteboard: {
        semibold: "fawsb"
      }
    };
  var qt = {
      kit: {
        fak: "kit",
        "fa-kit": "kit"
      },
      "kit-duotone": {
        fakd: "kit-duotone",
        "fa-kit-duotone": "kit-duotone"
      }
    },
    Ht = ["kit"];
  var L = "kit",
    r = "kit-duotone",
    U = "Kit",
    J = "Kit Duotone",
    $t = _defineProperty(_defineProperty({}, L, U), r, J);
  var ol = {
    kit: {
      "fa-kit": "fak"
    },
    "kit-duotone": {
      "fa-kit-duotone": "fakd"
    }
  };
  var fl = {
      kit: {
        fak: "fa-kit"
      },
      "kit-duotone": {
        fakd: "fa-kit-duotone"
      }
    };
  var ul = {
      kit: {
        kit: "fak"
      },
      "kit-duotone": {
        "kit-duotone": "fakd"
      }
    };

  var _ml;
  var l$1 = {
      GROUP: "duotone-group",
      SWAP_OPACITY: "swap-opacity",
      PRIMARY: "primary",
      SECONDARY: "secondary"
    };
  var n$1 = "classic",
    o$1 = "duotone",
    u$1 = "sharp",
    s$1 = "sharp-duotone",
    h$1 = "chisel",
    g$1 = "etch",
    y$1 = "jelly",
    e$1 = "jelly-duo",
    m$1 = "jelly-fill",
    p$1 = "notdog",
    a$1 = "notdog-duo",
    w$1 = "slab",
    b$1 = "slab-press",
    r$1 = "thumbprint",
    c$1 = "utility",
    i$1 = "utility-duo",
    x$1 = "utility-fill",
    I$1 = "whiteboard",
    F$1 = "Classic",
    v$1 = "Duotone",
    S$1 = "Sharp",
    A$1 = "Sharp Duotone",
    P$1 = "Chisel",
    j$1 = "Etch",
    B$1 = "Jelly",
    N$1 = "Jelly Duo",
    k$1 = "Jelly Fill",
    D$1 = "Notdog",
    C$1 = "Notdog Duo",
    T$1 = "Slab",
    L$1 = "Slab Press",
    W$1 = "Thumbprint",
    R$1 = "Utility",
    K$1 = "Utility Duo",
    U$1 = "Utility Fill",
    J$1 = "Whiteboard",
    ml$1 = (_ml = {}, _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_ml, n$1, F$1), o$1, v$1), u$1, S$1), s$1, A$1), h$1, P$1), g$1, j$1), y$1, B$1), e$1, N$1), m$1, k$1), p$1, D$1), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_ml, a$1, C$1), w$1, T$1), b$1, L$1), r$1, W$1), c$1, R$1), i$1, K$1), x$1, U$1), I$1, J$1));
  var E$1 = "kit",
    d$1 = "kit-duotone",
    _$1 = "Kit",
    M$1 = "Kit Duotone",
    rt$1 = _defineProperty(_defineProperty({}, E$1, _$1), d$1, M$1);
  var $t$1 = {
      classic: {
        "fa-brands": "fab",
        "fa-duotone": "fad",
        "fa-light": "fal",
        "fa-regular": "far",
        "fa-solid": "fas",
        "fa-thin": "fat"
      },
      duotone: {
        "fa-regular": "fadr",
        "fa-light": "fadl",
        "fa-thin": "fadt"
      },
      sharp: {
        "fa-solid": "fass",
        "fa-regular": "fasr",
        "fa-light": "fasl",
        "fa-thin": "fast"
      },
      "sharp-duotone": {
        "fa-solid": "fasds",
        "fa-regular": "fasdr",
        "fa-light": "fasdl",
        "fa-thin": "fasdt"
      },
      slab: {
        "fa-regular": "faslr"
      },
      "slab-press": {
        "fa-regular": "faslpr"
      },
      whiteboard: {
        "fa-semibold": "fawsb"
      },
      thumbprint: {
        "fa-light": "fatl"
      },
      notdog: {
        "fa-solid": "fans"
      },
      "notdog-duo": {
        "fa-solid": "fands"
      },
      etch: {
        "fa-solid": "faes"
      },
      jelly: {
        "fa-regular": "fajr"
      },
      "jelly-fill": {
        "fa-regular": "fajfr"
      },
      "jelly-duo": {
        "fa-regular": "fajdr"
      },
      chisel: {
        "fa-regular": "facr"
      },
      utility: {
        "fa-semibold": "fausb"
      },
      "utility-duo": {
        "fa-semibold": "faudsb"
      },
      "utility-fill": {
        "fa-semibold": "faufsb"
      }
    },
    z = {
      classic: ["fas", "far", "fal", "fat", "fad"],
      duotone: ["fadr", "fadl", "fadt"],
      sharp: ["fass", "fasr", "fasl", "fast"],
      "sharp-duotone": ["fasds", "fasdr", "fasdl", "fasdt"],
      slab: ["faslr"],
      "slab-press": ["faslpr"],
      whiteboard: ["fawsb"],
      thumbprint: ["fatl"],
      notdog: ["fans"],
      "notdog-duo": ["fands"],
      etch: ["faes"],
      jelly: ["fajr"],
      "jelly-fill": ["fajfr"],
      "jelly-duo": ["fajdr"],
      chisel: ["facr"],
      utility: ["fausb"],
      "utility-duo": ["faudsb"],
      "utility-fill": ["faufsb"]
    },
    Ht$1 = {
      classic: {
        fab: "fa-brands",
        fad: "fa-duotone",
        fal: "fa-light",
        far: "fa-regular",
        fas: "fa-solid",
        fat: "fa-thin"
      },
      duotone: {
        fadr: "fa-regular",
        fadl: "fa-light",
        fadt: "fa-thin"
      },
      sharp: {
        fass: "fa-solid",
        fasr: "fa-regular",
        fasl: "fa-light",
        fast: "fa-thin"
      },
      "sharp-duotone": {
        fasds: "fa-solid",
        fasdr: "fa-regular",
        fasdl: "fa-light",
        fasdt: "fa-thin"
      },
      slab: {
        faslr: "fa-regular"
      },
      "slab-press": {
        faslpr: "fa-regular"
      },
      whiteboard: {
        fawsb: "fa-semibold"
      },
      thumbprint: {
        fatl: "fa-light"
      },
      notdog: {
        fans: "fa-solid"
      },
      "notdog-duo": {
        fands: "fa-solid"
      },
      etch: {
        faes: "fa-solid"
      },
      jelly: {
        fajr: "fa-regular"
      },
      "jelly-fill": {
        fajfr: "fa-regular"
      },
      "jelly-duo": {
        fajdr: "fa-regular"
      },
      chisel: {
        facr: "fa-regular"
      },
      utility: {
        fausb: "fa-semibold"
      },
      "utility-duo": {
        faudsb: "fa-semibold"
      },
      "utility-fill": {
        faufsb: "fa-semibold"
      }
    },
    G$1 = ["solid", "regular", "light", "thin", "duotone", "brands", "semibold"],
    O$1 = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
    V$1 = O$1.concat([11, 12, 13, 14, 15, 16, 17, 18, 19, 20]),
    $$1 = ["aw", "fw", "pull-left", "pull-right"],
    to = [].concat(_toConsumableArray(Object.keys(z)), G$1, $$1, ["2xs", "xs", "sm", "lg", "xl", "2xl", "beat", "border", "fade", "beat-fade", "bounce", "flip-both", "flip-horizontal", "flip-vertical", "flip", "inverse", "layers", "layers-bottom-left", "layers-bottom-right", "layers-counter", "layers-text", "layers-top-left", "layers-top-right", "li", "pull-end", "pull-start", "pulse", "rotate-180", "rotate-270", "rotate-90", "rotate-by", "shake", "spin-pulse", "spin-reverse", "spin", "stack-1x", "stack-2x", "stack", "ul", "width-auto", "width-fixed", l$1.GROUP, l$1.SWAP_OPACITY, l$1.PRIMARY, l$1.SECONDARY]).concat(O$1.map(function (t) {
      return "".concat(t, "x");
    })).concat(V$1.map(function (t) {
      return "w-".concat(t);
    }));

  var NAMESPACE_IDENTIFIER = '___FONT_AWESOME___';
  var PRODUCTION = function () {
    try {
      return "production" === 'production';
    } catch (e$$1) {
      return false;
    }
  }();
  function familyProxy(obj) {
    // Defaults to the classic family if family is not available
    return new Proxy(obj, {
      get: function get(target, prop) {
        return prop in target ? target[prop] : target[i];
      }
    });
  }
  var _PREFIX_TO_STYLE = _objectSpread2({}, q);

  // We changed FACSSClassesToStyleId in the icons repo to be canonical and as such, "classic" family does not have any
  // duotone styles.  But we do still need duotone in _PREFIX_TO_STYLE below, so we are manually adding
  // {'fa-duotone': 'duotone'}
  _PREFIX_TO_STYLE[i] = _objectSpread2(_objectSpread2(_objectSpread2(_objectSpread2({}, {
    'fa-duotone': 'duotone'
  }), q[i]), qt['kit']), qt['kit-duotone']);
  var PREFIX_TO_STYLE = familyProxy(_PREFIX_TO_STYLE);
  var _STYLE_TO_PREFIX = _objectSpread2({}, _t);

  // We changed FAStyleIdToShortPrefixId in the icons repo to be canonical and as such, "classic" family does not have any
  // duotone styles.  But we do still need duotone in _STYLE_TO_PREFIX below, so we are manually adding {duotone: 'fad'}
  _STYLE_TO_PREFIX[i] = _objectSpread2(_objectSpread2(_objectSpread2(_objectSpread2({}, {
    duotone: 'fad'
  }), _STYLE_TO_PREFIX[i]), ul['kit']), ul['kit-duotone']);
  var STYLE_TO_PREFIX = familyProxy(_STYLE_TO_PREFIX);
  var _PREFIX_TO_LONG_STYLE = _objectSpread2({}, Ht$1);
  _PREFIX_TO_LONG_STYLE[i] = _objectSpread2(_objectSpread2({}, _PREFIX_TO_LONG_STYLE[i]), fl['kit']);
  var PREFIX_TO_LONG_STYLE = familyProxy(_PREFIX_TO_LONG_STYLE);
  var _LONG_STYLE_TO_PREFIX = _objectSpread2({}, $t$1);
  _LONG_STYLE_TO_PREFIX[i] = _objectSpread2(_objectSpread2({}, _LONG_STYLE_TO_PREFIX[i]), ol['kit']);
  var LONG_STYLE_TO_PREFIX = familyProxy(_LONG_STYLE_TO_PREFIX);
  var _FONT_WEIGHT_TO_PREFIX = _objectSpread2({}, gt);
  var FONT_WEIGHT_TO_PREFIX = familyProxy(_FONT_WEIGHT_TO_PREFIX);
  var RESERVED_CLASSES = [].concat(_toConsumableArray(Ht), _toConsumableArray(to));

  function bunker(fn) {
    try {
      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }
      fn.apply(void 0, args);
    } catch (e) {
      if (!PRODUCTION) {
        throw e;
      }
    }
  }

  var w$2 = WINDOW || {};
  if (!w$2[NAMESPACE_IDENTIFIER]) w$2[NAMESPACE_IDENTIFIER] = {};
  if (!w$2[NAMESPACE_IDENTIFIER].styles) w$2[NAMESPACE_IDENTIFIER].styles = {};
  if (!w$2[NAMESPACE_IDENTIFIER].hooks) w$2[NAMESPACE_IDENTIFIER].hooks = {};
  if (!w$2[NAMESPACE_IDENTIFIER].shims) w$2[NAMESPACE_IDENTIFIER].shims = [];
  var namespace = w$2[NAMESPACE_IDENTIFIER];

  function normalizeIcons(icons) {
    return Object.keys(icons).reduce(function (acc, iconName) {
      var icon = icons[iconName];
      var expanded = !!icon.icon;
      if (expanded) {
        acc[icon.iconName] = icon.icon;
      } else {
        acc[iconName] = icon;
      }
      return acc;
    }, {});
  }
  function defineIcons(prefix, icons) {
    var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    var _params$skipHooks = params.skipHooks,
      skipHooks = _params$skipHooks === void 0 ? false : _params$skipHooks;
    var normalized = normalizeIcons(icons);
    if (typeof namespace.hooks.addPack === 'function' && !skipHooks) {
      namespace.hooks.addPack(prefix, normalizeIcons(icons));
    } else {
      namespace.styles[prefix] = _objectSpread2(_objectSpread2({}, namespace.styles[prefix] || {}), normalized);
    }

    /**
     * Font Awesome 4 used the prefix of `fa` for all icons. With the introduction
     * of new styles we needed to differentiate between them. Prefix `fa` is now an alias
     * for `fas` so we'll ease the upgrade process for our users by automatically defining
     * this as well.
     */
    if (prefix === 'fas') {
      defineIcons('fa', icons);
    }
  }

  var icons = {
    "question": [360, 540, [10067, 10068, 61736], "3f", "M180 72c79.5 0 144 64.5 144 144 0 63-40.4 116.5-96.7 136-6.2 2.2-10.7 7.5-11.8 14-2.9 17-17.7 30-35.5 30-19.9 0-36-16.1-36-36 0-41.3 33-66.7 59.6-75.9 28.3-9.8 48.4-36.6 48.4-68.1 0-39.8-32.2-72-72-72s-72 32.2-72 72c0 19.9-16.1 36-36 36s-36-16.1-36-36c0-79.5 64.5-144 144-144zm47.6 342c9.5-8.4 16.7-19.2 20.8-31.5 65.4-26.9 111.6-91.2 111.6-166.5 0-99.4-80.6-180-180-180S0 116.6 0 216c0 39.8 32.2 72 72 72s72-32.2 72-72c0-19.9 16.1-36 36-36s36 16.1 36 36c0 15.7-10.1 29.1-24.2 34-33.6 11.6-83.8 46.6-83.8 110 0 21.5 9.4 40.8 24.4 54-14.9 13.2-24.4 32.5-24.4 54 0 39.8 32.2 72 72 72s72-32.2 72-72c0-21.5-9.4-40.8-24.4-54zM180 432c19.9 0 36 16.1 36 36s-16.1 36-36 36-36-16.1-36-36 16.1-36 36-36z"],
    "minus": [468, 540, [8211, 8722, 10134, "subtract"], "f068", "M0 288c0-39.8 32.2-72 72-72l324 0c39.8 0 72 32.2 72 72s-32.2 72-72 72L72 360c-39.8 0-72-32.2-72-72zm72-36c-19.9 0-36 16.1-36 36s16.1 36 36 36l324 0c19.9 0 36-16.1 36-36s-16.1-36-36-36L72 252z"],
    "microphone-slash": [504, 540, [], "f131", "M483.4 417.1l-48.8-48.8c21.5-33.6 33.9-73.4 33.9-116.3 0-39.8-32.2-72-72-72-13.1 0-25.4 3.5-36 9.6l0-45.6c0-59.6-48.4-108-108-108-40.7 0-76.1 22.5-94.5 55.7L123.4 57.1C95.3 29 49.7 29 21.6 57.1s-28.1 73.7 0 101.8l39.2 39.2c-14.9 13.2-24.3 32.5-24.3 53.9 0 94.1 60.1 174.1 144 203.7l0 12.3c0 39.8 32.2 72 72 72s72-32.2 72-72l0-6.2 57.1 57.1c28.1 28.1 73.7 28.1 101.8 0s28.1-73.7 0-101.8zm-75-75l-54-54c4-11.3 6.2-23.4 6.2-36 0-19.9 16.1-36 36-36s36 16.1 36 36c0 32.8-8.8 63.6-24.1 90.1zM72.5 252c0-11.5 5.4-21.8 13.8-28.4L150.6 288c10.8 30.7 35.2 55.1 65.9 65.9l76.6 76.6c-2.9 3.2-4.6 7.5-4.6 12.1l0 25.5c0 19.9-16.1 36-36 36s-36-16.1-36-36l0-25.5c0-8.1-5.4-15.1-13.1-17.3-75.6-21.4-130.9-90.9-130.9-173.2zM98 82.5l360 360c14.1 14.1 14.1 36.9 0 50.9s-36.9 14.1-50.9 0L47 133.5C33 119.4 33 96.6 47 82.5s36.9-14.1 50.9 0zM252.5 72c39.8 0 72 32.2 72 72l0 114.2-139.4-139.4C195.3 91.4 221.6 72 252.5 72z"],
    "car": [540, 540, [128664, "automobile"], "f1b9", "M171 360a27 27 0 1 0 0-54 27 27 0 1 0 0 54zm171-27a27 27 0 1 1 54 0 27 27 0 1 1 -54 0zm-90-18c-9.9 0-18 8.1-18 18s8.1 18 18 18l36 0c9.9 0 18-8.1 18-18s-8.1-18-18-18l-36 0zM166.2 72c-31.8 0-59.8 20.9-69 51.3L85.6 162 72 162c-39.8 0-72 32.2-72 72 0 33.5 22.9 61.7 54 69.7L54 450c0 39.8 32.2 72 72 72l18 0c39.8 0 72-32.2 72-72l0-18 108 0 0 18c0 39.8 32.2 72 72 72l18 0c39.8 0 72-32.2 72-72l0-146.3c31.1-8 54-36.2 54-69.7 0-39.8-32.2-72-72-72l-13.6 0-11.6-38.7c-9.1-30.5-37.2-51.3-69-51.3L166.2 72zM116.4 184.8l15.3-51.1c4.6-15.2 18.6-25.7 34.5-25.7l207.6 0c15.9 0 29.9 10.4 34.5 25.7l15.3 51.1c.1 .3 .2 .5 .2 .8l16 53.2c-8-3.1-16.7-4.8-25.8-4.8l-288 0c-9.1 0-17.8 1.7-25.8 4.8l16-53.2c.1-.3 .2-.5 .2-.8zM90 306c0-19.9 16.1-36 36-36l288 0c19.9 0 36 16.1 36 36l0 90-360 0 0-90zM360 450l0-18 90 0 0 18c0 19.9-16.1 36-36 36l-18 0c-19.9 0-36-16.1-36-36zM180 432l0 18c0 19.9-16.1 36-36 36l-18 0c-19.9 0-36-16.1-36-36l0-18 90 0zM504 234c0 13.7-7.7 25.7-19 31.8L465.2 198c20.6 0 38.8 14.2 38.8 36zM36 234c0-21.8 18.2-36 38.8-36L55 265.8c-11.3-6.1-19-18-19-31.8z"],
    "filter": [432, 540, [], "f0b0", "M170.4 534.5c26.9 11.1 57.9 5 78.5-15.6l36-36C298.4 469.4 306 451.1 306 432l0-78.2 104.9-104.9C424.4 235.4 432 217.1 432 198l0-54c0-39.8-32.2-72-72-72L72 72c-19.1 0-37.4 7.6-50.9 21.1S0 124.9 0 144l0 54c0 19.1 7.6 37.4 21.1 50.9L126 353.8 126 468c0 29.1 17.5 55.4 44.4 66.5zm53-41.1c-10.3 10.3-25.8 13.4-39.2 7.8S162 482.6 162 468l0-121.6c0-4.8-1.9-9.4-5.3-12.7L46.5 223.5C39.8 216.7 36 207.5 36 198l0-54c0-9.5 3.8-18.7 10.5-25.5S62.5 108 72 108l288 0c19.9 0 36 16.1 36 36l0 54c0 9.5-3.8 18.7-10.5 25.5L275.3 333.6c-3.4 3.4-5.3 8-5.3 12.7l0 85.6c0 9.5-3.8 18.7-10.5 25.5l-36 36z"],
    "envelope": [504, 540, [128386, 9993, 61443], "f0e0", "M0 414c0 39.8 32.2 72 72 72l360 0c39.8 0 72-32.2 72-72l0-252c0-39.8-32.2-72-72-72L72 90C32.2 90 0 122.2 0 162L0 414zm72 36c-19.9 0-36-16.1-36-36l0-208.2 173.6 122.9c24.9 17.7 59.9 17.7 84.9 0L468 205.8 468 414c0 19.9-16.1 36-36 36L72 450zM468 161.7L273.6 299.4c-12.5 8.9-30.7 8.9-43.2 0L36 161.7C36.2 142 52.2 126 72 126l360 0c19.8 0 35.8 16 36 35.7z"],
    "at": [504, 540, [61946], "40", "M288 288a36 36 0 1 1 -72 0 36 36 0 1 1 72 0zm18.7 133.2c10.8 12.6 17.3 28.9 17.3 46.8 0 39.8-32.2 72-72 72-139.2 0-252-112.8-252-252S112.8 36 252 36 504 148.8 504 288c0 69.6-56.4 126-126 126-15.7 0-30.9-1.2-45.9-6.3-7.9 5.3-16.4 9.9-25.3 13.5zM252 72C132.7 72 36 168.7 36 288s96.7 216 216 216c19.9 0 36-16.1 36-36s-16.1-36-36-36c-79.5 0-144-64.5-144-144s64.5-144 144-144 144 64.5 144 144c0 9.9-8.1 18-18 18s-18-8.1-18-18c0-59.6-48.4-108-108-108s-108 48.4-108 108 48.4 108 108 108c25.1 0 48.1-8.5 66.4-22.8 5.2-4.1 12.3-5 18.4-2.3 13.2 5.9 26.9 7.1 41.2 7.1 49.7 0 90-40.3 90-90 0-119.3-96.7-216-216-216z"],
    "truck": [504, 540, [128666, 9951], "f0d1", "M342 144l0 18 90 0c39.8 0 72 32.2 72 72l0 144c0 33.6-23 61.8-54 69.7 1.2 40.1-31.8 74.3-72 74.3-39.8 0-72-32.2-72-72l-108 0c0 39.8-32.2 72-72 72-40.1 0-73.2-34.2-72-74.3-31.1-8-54-36.2-54-69.7L0 144c0-39.8 32.2-72 72-72l198 0c39.8 0 72 32.2 72 72zM36 144l0 234c0 17.2 12 31.6 28.1 35.1 12.6-21 35.6-35.1 61.9-35.1 26.7 0 49.9 14.5 62.4 36l117.6 0 0-270c0-19.9-16.1-36-36-36L72 108c-19.9 0-36 16.1-36 36zM342 270l126 0 0-36c0-19.9-16.1-36-36-36l-90 0 0 72zm0 36l0 81.6c10.6-6.1 22.9-9.6 36-9.6 26.3 0 49.3 14.1 61.9 35.1 16.1-3.6 28.1-18 28.1-35.1l0-72-126 0zM126 486a36 36 0 1 0 0-72 36 36 0 1 0 0 72zm252 0a36 36 0 1 0 0-72 36 36 0 1 0 0 72z"],
    "bell": [432, 540, [128276, 61602], "f0f3", "M162 216c0-29.8 24.2-54 54-54 9.9 0 18-8.1 18-18s-8.1-18-18-18c-49.7 0-90 40.3-90 90l0 18c0 9.9 8.1 18 18 18s18-8.1 18-18l0-18zM36 216c0-99.4 80.6-180 180-180s180 80.6 180 180l0 99.6c21.5 12.4 36 35.7 36 62.4 0 39.8-32.2 72-72 72l-37.5 0c-8.6 51.1-53 90-106.5 90s-97.9-38.9-106.5-90L72 450c-39.8 0-72-32.2-72-72 0-26.7 14.5-49.9 36-62.4L36 216zM216 504c33.5 0 61.7-22.9 69.7-54l-139.5 0c8 31.1 36.2 54 69.7 54zm0-432C136.5 72 72 136.5 72 216l0 111.1c0 7.6-4.8 14.4-12 17-14 5-24 18.3-24 34 0 19.9 16.1 36 36 36l288 0c19.9 0 36-16.1 36-36 0-15.6-10-29-24-34-7.2-2.5-12-9.3-12-17L360 216c0-79.5-64.5-144-144-144z"],
    "mobile": [324, 540, [128241, "mobile-android", "mobile-phone"], "f3ce", "M189 423c0 14.9-12.1 27-27 27s-27-12.1-27-27 12.1-27 27-27 27 12.1 27 27zM126 126c-9.9 0-18 8.1-18 18s8.1 18 18 18l72 0c9.9 0 18-8.1 18-18s-8.1-18-18-18l-72 0zM0 126C0 86.2 32.2 54 72 54l180 0c39.8 0 72 32.2 72 72l0 324c0 39.8-32.2 72-72 72L72 522c-39.8 0-72-32.2-72-72L0 126zM72 90c-19.9 0-36 16.1-36 36l0 324c0 19.9 16.1 36 36 36l180 0c19.9 0 36-16.1 36-36l0-324c0-19.9-16.1-36-36-36L72 90z"],
    "trophy": [540, 540, [127942], "f091", "M348.4 378l11.6 0c39.8 0 72 32.2 72 72s-32.2 72-72 72l-180 0c-39.8 0-72-32.2-72-72s32.2-72 72-72l11.6 0c-17-13.8-35.7-33.5-51.8-58.6L38.1 265.1C14.7 252.6 0 228.2 0 201.6L0 180c0-39.8 32.2-72 72-72l20.2 .1C100.2 77 128.4 54 162 54l216 0c33.6 0 61.8 23 69.8 54.1L468 108c39.8 0 72 32.2 72 72l0 21.6c0 26.6-14.7 51-38.1 63.5L400.1 319.4c-16 25.1-34.8 44.8-51.8 58.6zM126 126c0 70.1 16.1 144.6 62.7 198.9 13 15.2 26.2 26.2 37.6 34.1 4.9 3.4 7.8 8.9 7.8 14.8l0 22.2c0 9.9-8.1 18-18 18l-36 0c-19.9 0-36 16.1-36 36s16.1 36 36 36l180 0c19.9 0 36-16.1 36-36s-16.1-36-36-36l-36 0c-9.9 0-18-8.1-18-18l0-22.2c0-5.9 2.9-11.5 7.8-14.8 11.3-7.8 24.5-18.9 37.6-34.1 46.6-54.4 62.7-128.8 62.7-198.9 0-19.9-16.1-36-36-36L162 90c-19.9 0-36 16.1-36 36zm378 54c0-19.9-16.1-36-36-36-2 0-4 0-6 0-4.1 0-8.2 0-12.3 0-1.7 47-9.9 86.7-22.2 120l57.5-30.7c11.7-6.3 19.1-18.5 19.1-31.8l0-21.6zM112.6 264C100.2 230.7 92 191 90.3 144L72 144c-19.9 0-36 16.1-36 36l0 21.6c0 13.3 7.3 25.5 19.1 31.8L112.6 264zM468 144c-2 0-4 0-6 0l6 0z"],
    "signal-bars-fair": [468, 540, ["signal-alt-2"], "f692", "M126 479.6c13.2 14.9 32.5 24.4 54 24.4 39.8 0 72-32.2 72-72l0-144c0-39.8-32.2-72-72-72s-72 32.2-72 72l0 9.6c-10.6-6.1-22.9-9.6-36-9.6-39.8 0-72 32.2-72 72l0 72c0 39.8 32.2 72 72 72 21.5 0 40.8-9.4 54-24.4zM108 432c0 19.9-16.1 36-36 36s-36-16.1-36-36l0-72c0-19.9 16.1-36 36-36s36 16.1 36 36l0 72zm36 0l0-144c0-19.9 16.1-36 36-36s36 16.1 36 36l0 144c0 19.9-16.1 36-36 36s-36-16.1-36-36z"],
    "gift": [432, 540, [127873], "f06b", "M194.9 57.1C166.8 29 121.2 29 93.1 57.1 69.5 80.6 65.7 116.5 81.6 144L72 144c-39.8 0-72 32.2-72 72L0 432c0 39.8 32.2 72 72 72l288 0c39.8 0 72-32.2 72-72l0-216c0-39.8-32.2-72-72-72l-9.6 0c15.9-27.5 12.1-63.4-11.5-86.9-28.1-28.1-73.7-28.1-101.8 0L216 78.2 194.9 57.1zM118.5 82.5c14.1-14.1 36.9-14.1 50.9 0l33.8 33.8c6.9 6.9 18.5 6.9 25.5 0l33.8-33.8c14.1-14.1 36.9-14.1 50.9 0s14.1 36.9 0 50.9l-10.5 10.5-173.8 0-10.5-10.5c-14.1-14.1-14.1-36.9 0-50.9zM72 180l72 0 0 126-108 0 0-90c0-19.9 16.1-36 36-36zm72 162l0 126-72 0c-19.9 0-36-16.1-36-36l0-90 108 0zM252 180l0 288-72 0 0-288 72 0zm36 126l0-126 72 0c19.9 0 36 16.1 36 36l0 90-108 0zm0 36l108 0 0 90c0 19.9-16.1 36-36 36l-72 0 0-126z"],
    "gauge": [504, 540, ["dashboard", "gauge-med", "tachometer-alt-average"], "f624", "M234 271.8c-41.1 8.3-72 44.7-72 88.2 0 49.7 40.3 90 90 90s90-40.3 90-90c0-43.5-30.9-79.9-72-88.2L270 144c0-9.9-8.1-18-18-18s-18 8.1-18 18l0 127.8zM252 414a54 54 0 1 1 0-108 54 54 0 1 1 0 108zm72-225a27 27 0 1 1 54 0 27 27 0 1 1 -54 0zM153 162a27 27 0 1 1 0 54 27 27 0 1 1 0-54zM378 279a27 27 0 1 1 54 0 27 27 0 1 1 -54 0zM99 252a27 27 0 1 1 0 54 27 27 0 1 1 0-54zm405 36a252 252 0 1 1 -504 0 252 252 0 1 1 504 0zM252 72a216 216 0 1 0 0 432 216 216 0 1 0 0-432z"],
    "share-nodes": [504, 540, ["share-alt"], "f1e0", "M254.4 121.4C264.7 72.6 308.1 36 360 36 419.6 36 468 84.4 468 144S419.6 252 360 252c-11.9 0-23.4-1.9-34.2-5.5l-72.7 41.5 72.7 41.5c10.8-3.6 22.3-5.5 34.2-5.5 59.6 0 108 48.4 108 108S419.6 540 360 540c-51.9 0-95.3-36.6-105.6-85.4L142.2 390.5c-10.8 3.6-22.3 5.5-34.2 5.5-59.6 0-108-48.4-108-108S48.4 180 108 180c11.9 0 23.4 1.9 34.2 5.5l112.2-64.1zM360 72c-36.7 0-67.1 27.5-71.5 63.1-.7 5.6-4 10.6-8.9 13.4L152.7 221c-4.9 2.8-10.9 3.1-16.1 .9-8.7-3.8-18.4-5.9-28.6-5.9-39.8 0-72 32.2-72 72s32.2 72 72 72c10.2 0 19.9-2.1 28.6-5.9 5.2-2.3 11.2-1.9 16.1 .9l126.9 72.5c4.9 2.8 8.2 7.8 8.9 13.4 4.4 35.5 34.7 63.1 71.5 63.1 39.8 0 72-32.2 72-72s-32.2-72-72-72c-10.2 0-19.9 2.1-28.6 5.9-5.2 2.3-11.2 1.9-16.1-.9L207.9 303.6c-11.9-6.8-11.9-24.5 0-31.3L315.3 211c4.9-2.8 10.9-3.1 16.1-.9 8.7 3.8 18.4 5.9 28.6 5.9 39.8 0 72-32.2 72-72s-32.2-72-72-72z"],
    "percent": [432, 540, [62101, 62785, "percentage"], "25", "M0 180C0 120.4 48.4 72 108 72s108 48.4 108 108c0 2.1-.1 4.3-.2 6.4l93.3-93.3c28.1-28.1 73.7-28.1 101.8 0s28.1 73.7 0 101.8l-93.3 93.3c2.1-.1 4.2-.2 6.4-.2 59.6 0 108 48.4 108 108s-48.4 108-108 108-108-48.4-108-108c0-2.1 .1-4.3 .2-6.4l-93.3 93.3C94.8 511 49.2 511 21.1 482.9s-28.1-73.7 0-101.8l93.3-93.3c-2.1 .1-4.2 .2-6.4 .2-59.6 0-108-48.4-108-108zm108-72a72 72 0 1 0 0 144 72 72 0 1 0 0-144zM324 324a72 72 0 1 0 0 144 72 72 0 1 0 0-144zm10.5-205.5l-288 288c-14.1 14.1-14.1 36.9 0 50.9s36.9 14.1 50.9 0l288-288c14.1-14.1 14.1-36.9 0-50.9s-36.9-14.1-50.9 0z"],
    "magnifying-glass": [504, 540, [128269, "search"], "f002", "M207 162a99 99 0 1 0 0 198 99 99 0 1 0 0-198zm63 99a63 63 0 1 1 -126 0 63 63 0 1 1 126 0zm23.4 188.2l69.7 69.7c28.1 28.1 73.7 28.1 101.8 0s28.1-73.7 0-101.8l-69.7-69.7c12.1-26.3 18.8-55.5 18.8-86.4 0-114.3-92.7-207-207-207S0 146.7 0 261 92.7 468 207 468c30.8 0 60.1-6.7 86.4-18.8zM378 261a171 171 0 1 1 -342 0 171 171 0 1 1 342 0zm-1.4 118.7l62.8 62.8c14.1 14.1 14.1 36.9 0 50.9s-36.9 14.1-50.9 0l-62.8-62.8c19.8-13.9 37-31.1 50.9-50.9z"],
    "palette": [504, 540, [127912], "f53f", "M252 180a27 27 0 1 0 0-54 27 27 0 1 0 0 54zM90 288a27 27 0 1 1 54 0 27 27 0 1 1 -54 0zm238.4-76.4a27 27 0 1 0 38.2-38.2 27 27 0 1 0 -38.2 38.2zM137.4 364.4a27 27 0 1 1 38.2 38.2 27 27 0 1 1 -38.2-38.2zm0-152.7a27 27 0 1 0 38.2-38.2 27 27 0 1 0 -38.2 38.2zM252 36C112.8 36 0 148.8 0 288S112.8 540 252 540l18 0c31.7 0 59.7-20.8 68.9-51.1s-2.6-63.2-29-80.8l-12.2-8.2c-6.1-4-9.7-10.9-9.7-18.1 0-12 9.8-21.8 21.8-21.8L432 360c39.8 0 72-32.2 72-72 0-139.2-112.8-252-252-252zM36 288C36 168.7 132.7 72 252 72s216 96.7 216 216c0 19.9-16.1 36-36 36l-122.2 0c-31.9 0-57.8 25.9-57.8 57.8 0 19.3 9.7 37.4 25.7 48.1L290 438c13.2 8.8 19.1 25.2 14.5 40.4S285.9 504 270 504l-18 0C132.7 504 36 407.3 36 288z"],
    "key": [504, 540, [128273], "f084", "M342 126a72 72 0 1 0 0 144 72 72 0 1 0 0-144zm36 72a36 36 0 1 1 -72 0 36 36 0 1 1 72 0zM324 36c-99.4 0-180 80.6-180 180 0 9 .7 17.9 2 26.6L21.1 367.5C7.6 381 0 399.3 0 418.4L0 468c0 39.8 32.2 72 72 72l56.7 0c14.6 0 28.5-5.8 38.8-16.1 8-8 12.5-18.8 12.5-30.1l0-25.8 23.3 0c12.9 0 25.3-5.1 34.5-14.3S252 432.2 252 419.3l0-23.3 72 0c99.4 0 180-80.6 180-180S423.4 36 324 36zM180 216c0-79.5 64.5-144 144-144s144 64.5 144 144-64.5 144-144 144l-90 0c-9.9 0-18 8.1-18 18l0 41.3c0 6.8-6 12.7-12.7 12.7L162 432c-9.9 0-18 8.1-18 18l0 43.8c0 6.9-9.8 10.2-15.3 10.2L72 504c-19.9 0-36-16.1-36-36l0-49.6c0-9.5 3.8-18.7 10.5-25.5L178 261.4c4.3-4.3 6.1-10.4 4.9-16.3-1.9-9.4-2.9-19.1-2.9-29.1z"],
    "skull": [468, 540, [128128], "f54c", "M216 234a72 72 0 1 1 -144 0 72 72 0 1 1 144 0zm-72-36a36 36 0 1 0 0 72 36 36 0 1 0 0-72zm180-36a72 72 0 1 0 0 144 72 72 0 1 0 0-144zm36 72a36 36 0 1 1 -72 0 36 36 0 1 1 72 0zM282.7 347.3l-36-36c-7-7-18.4-7-25.5 0l-36 36c-7 7-7 18.4 0 25.5s18.4 7 25.5 0l23.3-23.3 23.3 23.3c7 7 18.4 7 25.5 0s7-18.4 0-25.5zM144 540l180 0c39.8 0 72-32.2 72-72l0-29.1c44.4-42.6 72-102.5 72-168.9 0-129.2-104.8-234-234-234S0 140.8 0 270c0 66.4 27.6 126.3 72 168.9L72 468c0 39.8 32.2 72 72 72zM234 72c109.4 0 198 88.6 198 198 0 58.6-25.5 111.3-66 147.6-3.8 3.4-6 8.3-6 13.4l0 37c0 19.9-16.1 36-36 36l0-54c0-9.9-8.1-18-18-18s-18 8.1-18 18l0 54-36 0 0-54c0-9.9-8.1-18-18-18s-18 8.1-18 18l0 54-36 0 0-54c0-9.9-8.1-18-18-18s-18 8.1-18 18l0 54c-19.9 0-36-16.1-36-36l0-37c0-5.1-2.2-10-6-13.4-40.5-36.3-66-88.9-66-147.6 0-109.4 88.6-198 198-198z"],
    "tree": [396, 540, [127794], "f1bb", "M244.1 52.7c-26.7-22.3-65.5-22.3-92.2 0l-108 90c-23.3 19.4-31.9 51.3-21.6 79.8 7.9 21.9 25.8 38.2 47.5 44.6L25.1 305.3C2.3 324.9-6 356.7 4.5 385S41.9 432 72 432l54 0 0 36c0 39.8 32.2 72 72 72s72-32.2 72-72l0-36 54 0c30.1 0 57.1-18.8 67.5-47s2.2-60-20.7-79.6l-44.6-38.2c21.6-6.3 39.5-22.6 47.4-44.6 10.3-28.5 1.7-60.4-21.6-79.8l-108-90zM175 80.3c13.4-11.1 32.7-11.1 46.1 0l108 90c11.6 9.7 16 25.7 10.8 39.9S321.2 234 306 234l-25 0c-7.5 0-14.3 4.7-16.9 11.8s-.6 15 5.2 19.9l78.2 67c11.4 9.8 15.6 25.7 10.3 39.8S339.1 396 324 396L72 396c-15.1 0-28.5-9.4-33.8-23.5s-1.1-30 10.3-39.8l78.2-67c5.7-4.9 7.8-12.8 5.2-19.9S122.6 234 115 234l-25 0c-15.2 0-28.7-9.5-33.8-23.7S55.3 180 67 170.3l108-90zM234 432l0 36c0 19.9-16.1 36-36 36s-36-16.1-36-36l0-36 72 0z"],
    "flower": [504, 540, [127804, 10047], "f7ff", "M355.8 145.4c1.5-13.9 .7-27.8-2.5-40.7-8.7-35.1-35.2-63.8-78.4-67.7-15.1-1.3-30.3-1.3-45.3 0-43.2 3.9-69.7 32.6-78.4 67.7-3.2 13-4 26.8-2.5 40.8-12.8-5.7-26.2-9.2-39.5-10.2-36.1-2.6-71.6 13.7-88.6 53.7-5.9 13.9-10.6 28.4-14 43.1-9.6 42.3 9.4 76.4 40.1 95.5 11.3 7.1 24.3 12.1 38 15-9.4 10.4-16.9 22.1-21.9 34.4-13.6 33.5-9 72.3 23.7 100.9 11.4 10 23.7 18.9 36.6 26.6 37.3 22.2 75.6 14.6 103.2-8.6 10.2-8.6 19-19.3 26-31.5 7 12.2 15.8 22.9 26 31.5 27.7 23.3 66 31 103.2 8.6 13-7.8 25.3-16.7 36.6-26.6 32.7-28.6 37.3-67.3 23.7-100.8-5-12.4-12.5-24.1-21.9-34.5 13.7-2.9 26.6-7.9 38-15 30.7-19.1 49.8-53.2 40.1-95.5-3.4-14.8-8.1-29.2-14-43-17.1-39.9-52.5-56.3-88.6-53.7-13.3 1-26.7 4.5-39.5 10.2zM204.2 191.2c-16-22.1-24.8-50.9-18.1-77.9 5.5-22.1 20.6-38.1 46.7-40.5 12.9-1.2 25.9-1.2 38.8 0 26.1 2.3 41.2 18.3 46.7 40.5 6.7 27-2 55.9-18.1 78-14.5-7.2-30.8-11.2-48-11.2s-33.6 4-48 11.2zm125.2 21.2c16-22.1 40.7-39.3 68.5-41.3 22.7-1.6 42.6 7.9 52.9 31.9 5.1 11.9 9.1 24.2 12 36.9 5.8 25.5-4.7 44.9-24 56.9-23.7 14.7-53.8 15.3-79.7 6.9 .8-5.2 1.1-10.4 1.1-15.8 0-29.4-11.8-56.1-30.8-75.6zM348 338c25.9 8.4 50 26.6 60.4 52.4 8.6 21.1 5.7 42.9-14 60.2-9.7 8.5-20.2 16.2-31.4 22.8-22.4 13.4-44.1 9.4-61.5-5.3-21.3-18-31.2-46.4-31.2-73.7 33.8-5.7 62.4-27.1 77.7-56.5zM234.3 394.5c0 27.3-9.8 55.7-31.2 73.7-17.4 14.6-39.1 18.7-61.6 5.3-11.1-6.6-21.6-14.3-31.4-22.8-19.7-17.2-22.6-39.1-14-60.2 10.5-25.8 34.5-44 60.4-52.5 15.4 29.4 43.9 50.8 77.7 56.5zm-88.9-90.7c-25.9 8.4-56 7.9-79.7-6.9-19.3-12-29.8-31.4-24-56.9 2.9-12.6 6.9-25 12-36.9 10.3-24.1 30.2-33.5 52.9-31.9 27.8 2 52.5 19.2 68.6 41.3-19.1 19.5-30.8 46.2-30.8 75.6 0 5.4 .4 10.6 1.1 15.8zM324.3 288a72 72 0 1 1 -144 0 72 72 0 1 1 144 0z"],
    "camera": [504, 540, [62258, "camera-alt"], "f030", "M252 162a108 108 0 1 0 0 216 108 108 0 1 0 0-216zm72 108a72 72 0 1 1 -144 0 72 72 0 1 1 144 0zM0 198L0 396c0 39.8 32.2 72 72 72l360 0c39.8 0 72-32.2 72-72l0-198c0-39.8-32.2-72-72-72l-13.6 0c-9.5 0-18.7-3.8-25.5-10.5L352.5 75.1C339 61.6 320.7 54 301.6 54l-99.3 0c-19.1 0-37.4 7.6-50.9 21.1l-40.4 40.4c-6.8 6.8-15.9 10.5-25.5 10.5L72 126c-39.8 0-72 32.2-72 72zM36 396l0-198c0-19.9 16.1-36 36-36l13.6 0c19.1 0 37.4-7.6 50.9-21.1l40.4-40.4c6.8-6.8 15.9-10.5 25.5-10.5l99.3 0c9.5 0 18.7 3.8 25.5 10.5l40.4 40.4C381 154.4 399.3 162 418.4 162l13.6 0c19.9 0 36 16.1 36 36l0 198c0 19.9-16.1 36-36 36L72 432c-19.9 0-36-16.1-36-36z"],
    "eye": [504, 540, [128065], "f06e", "M82.2 165.4c41-47.9 100.9-75.4 164-75.4l11.5 0c63.1 0 123 27.6 164 75.4l64.9 75.7c23.1 27 23.1 66.8 0 93.7l-64.9 75.7c-41 47.9-100.9 75.4-164 75.4l-11.5 0c-63.1 0-123-27.6-164-75.4L17.3 334.9c-23.1-27-23.1-66.8 0-93.7l64.9-75.7zm164-39.4c-52.5 0-102.5 23-136.7 62.9L44.7 264.6c-11.6 13.5-11.6 33.4 0 46.9l64.9 75.7C143.8 427 193.7 450 246.2 450l11.5 0c52.5 0 102.5-23 136.7-62.9l64.9-75.7c11.6-13.5 11.6-33.4 0-46.9l-64.9-75.7C360.2 149 310.3 126 257.8 126l-11.5 0zM252 234a54 54 0 1 0 0 108 54 54 0 1 0 0-108zm90 54a90 90 0 1 1 -180 0 90 90 0 1 1 180 0z"],
    "trash": [432, 540, [], "f1f8", "M180 324c0-9.9-8.1-18-18-18s-18 8.1-18 18l0 18c0 19.9 16.1 36 36 36l72 0c19.9 0 36-16.1 36-36l0-18c0-9.9-8.1-18-18-18s-18 8.1-18 18l0 18-72 0 0-18zM0 180c0 29.3 17.5 54.5 42.5 65.7L54.1 454c2.1 38.2 33.7 68 71.9 68l180 0c38.2 0 69.8-29.9 71.9-68l11.6-208.3c25.1-11.3 42.5-36.4 42.5-65.7 0-41-34.2-72-74.3-72-8-31.1-36.2-54-69.7-54L144 54C110.5 54 82.3 76.9 74.3 108 34.2 108 0 139 0 180zm353.1 72L341.9 452c-1.1 19.1-16.8 34-35.9 34l-180 0c-19.1 0-34.9-14.9-35.9-34l-11.1-200 274.1 0zM72 216c-19.9 0-36-16.1-36-36s16.1-36 36-36l18 0c9.9 0 18-8.1 18-18 0-19.9 16.1-36 36-36l144 0c19.9 0 36 16.1 36 36 0 9.8 8.2 18 18 18l18 0c19.9 0 36 16.1 36 36s-16.1 36-36 36L72 216z"],
    "equals": [432, 540, [62764], "3d", "M72 144c-19.9 0-36 16.1-36 36s16.1 36 36 36l288 0c19.9 0 36-16.1 36-36s-16.1-36-36-36L72 144zM0 180c0-39.8 32.2-72 72-72l288 0c39.8 0 72 32.2 72 72s-32.2 72-72 72L72 252c-39.8 0-72-32.2-72-72zM72 360c-19.9 0-36 16.1-36 36s16.1 36 36 36l288 0c19.9 0 36-16.1 36-36s-16.1-36-36-36L72 360zM0 396c0-39.8 32.2-72 72-72l288 0c39.8 0 72 32.2 72 72s-32.2 72-72 72L72 468c-39.8 0-72-32.2-72-72z"],
    "expand": [432, 540, [], "f065", "M216 96.4C202.8 81.4 183.5 72 162 72L72 72C32.8 72 0 104.8 0 144l0 90C0 255.5 9.4 274.8 24.4 288 9.4 301.2 0 320.5 0 342l0 90c0 39.2 32.8 72 72 72l90 0c21.5 0 40.8-9.4 54-24.4 13.2 14.9 32.5 24.4 54 24.4l90 0c39.2 0 72-32.8 72-72l0-90c0-21.5-9.4-40.8-24.4-54 14.9-13.2 24.4-32.5 24.4-54l0-90c0-39.2-32.8-72-72-72l-90 0c-21.5 0-40.8 9.4-54 24.4zM36 144c0-19.6 16.4-36 36-36l90 0c19.9 0 36 16.1 36 36s-16.1 36-36 36l-36 0c-9.8 0-18 8.2-18 18l0 36c0 19.9-16.1 36-36 36s-36-16.1-36-36l0-90zm180 47.6c13.2 14.9 32.5 24.4 54 24.4l18 0 0 18c0 21.5 9.4 40.8 24.4 54-14.9 13.2-24.4 32.5-24.4 54l0 18-18 0c-21.5 0-40.8 9.4-54 24.4-13.2-14.9-32.5-24.4-54-24.4l-18 0 0-18c0-21.5-9.4-40.8-24.4-54 14.9-13.2 24.4-32.5 24.4-54l0-18 18 0c21.5 0 40.8-9.4 54-24.4zM360 270c-19.9 0-36-16.1-36-36l0-36c0-9.8-8.2-18-18-18l-36 0c-19.9 0-36-16.1-36-36s16.1-36 36-36l90 0c19.6 0 36 16.4 36 36l0 90c0 19.9-16.1 36-36 36zm0 36c19.9 0 36 16.1 36 36l0 90c0 19.6-16.4 36-36 36l-90 0c-19.9 0-36-16.1-36-36s16.1-36 36-36l36 0c9.8 0 18-8.2 18-18l0-36c0-19.9 16.1-36 36-36zM162 396c19.9 0 36 16.1 36 36s-16.1 36-36 36l-90 0c-19.6 0-36-16.4-36-36l0-90c0-19.9 16.1-36 36-36s36 16.1 36 36l0 36c0 9.8 8.2 18 18 18l36 0z"],
    "stop": [432, 540, [9209], "f04d", "M0 144c0-39.8 32.2-72 72-72l288 0c39.8 0 72 32.2 72 72l0 288c0 39.8-32.2 72-72 72L72 504c-39.8 0-72-32.2-72-72L0 144zm72-36c-19.9 0-36 16.1-36 36l0 288c0 19.9 16.1 36 36 36l288 0c19.9 0 36-16.1 36-36l0-288c0-19.9-16.1-36-36-36L72 108z"],
    "angle-left": [324, 540, [8249], "f104", "M21.6 237.1c-28.1 28.1-28.1 73.7 0 101.8l144 144c28.1 28.1 73.7 28.1 101.8 0s28.1-73.7 0-101.8l-93.1-93.1 93.1-93.1c28.1-28.1 28.1-73.7 0-101.8s-73.7-28.1-101.8 0l-144 144zM47 313.5C33 299.4 33 276.6 47 262.5l144-144c14.1-14.1 36.9-14.1 50.9 0s14.1 36.9 0 50.9L136.1 275.3c-3.4 3.4-5.3 8-5.3 12.7s1.9 9.4 5.3 12.7L242 406.5c14.1 14.1 14.1 36.9 0 50.9s-36.9 14.1-50.9 0L47 313.5z"],
    "circle-half-stroke": [504, 540, [9680, "adjust"], "f042", "M252.1 540a252 252 0 1 1 0-504 252 252 0 1 1 0 504zm15-36.5C379.3 495.8 468 402.2 468 288S379.3 80.2 267 72.5c1.9 5.6 3 11.5 3 17.5l0 55.1C341 154 396 214.6 396 288S341 422 270 430.9l0 55.1c0 6-1 11.9-3 17.5zM36 288c0 109.8 78.9 197.6 183.1 213.5 6.8 .9 14.9-4.8 14.9-15.5l0-396C234 79.3 225.9 73.6 219.1 74.5 115.4 90.3 36 178.2 36 288zm324 0c0-53.5-38.9-97.9-90-106.5l0 213c51.1-8.6 90-53 90-106.5z"],
    "clock": [504, 540, [128339, "clock-four"], "f017", "M270 144c0-9.9-8.1-18-18-18s-18 8.1-18 18l0 129.1c0 14.3 5.7 28.1 15.8 38.2l61.5 61.5c7 7 18.4 7 25.5 0s7-18.4 0-25.5l-61.5-61.5c-3.4-3.4-5.3-8-5.3-12.7L270 144zM252 36a252 252 0 1 0 0 504 252 252 0 1 0 0-504zM468 288a216 216 0 1 1 -432 0 216 216 0 1 1 432 0z"],
    "book": [396, 540, [128212], "f02d", "M198 198c-9.9 0-18 8.1-18 18s8.1 18 18 18l90 0c9.9 0 18-8.1 18-18s-8.1-18-18-18l-90 0zm-18 72c-9.9 0-18 8.1-18 18s8.1 18 18 18l126 0c9.9 0 18-8.1 18-18s-8.1-18-18-18l-126 0zM0 144c0-39.8 32.2-72 72-72l252 0c39.8 0 72 32.2 72 72l0 288c0 39.8-32.2 72-72 72L72 504c-39.8 0-72-32.2-72-72L0 144zm72-36c-19.9 0-36 16.1-36 36l0 288c0 19.9 16.1 36 36 36l18 0 0-360-18 0zm54 0l0 360 198 0c19.9 0 36-16.1 36-36l0-288c0-19.9-16.1-36-36-36l-198 0z"],
    "paper-plane": [540, 540, [61913], "f1d8", "M118.4 59.8C88.2 46.9 53.1 56 33 82s-20 62.3 .2 88.2L124.8 288 33.2 405.8C13 431.7 12.9 468 33 494s55.2 35.1 85.4 22.2l378-162C522.8 342.8 540 316.8 540 288s-17.2-54.8-43.6-66.2l-378-162zM61.5 104c10-13 27.6-17.6 42.7-11.1l378 162c13.2 5.7 21.8 18.7 21.8 33.1s-8.6 27.4-21.8 33.1l-378 162C89.1 489.6 71.5 485 61.5 472s-10-31.1 .1-44.1L156.4 306 306 306c9.9 0 18-8.1 18-18s-8.1-18-18-18l-149.6 0-94.8-121.9c-10.1-13-10.1-31.1-.1-44.1z"],
    "heart": [504, 540, [128153, 128154, 128155, 128156, 128420, 129293, 129294, 129505, 9829, 10084, 61578], "f004", "M144 108c-59.6 0-108 48.4-108 108 0 32.6 12.9 63.9 36 86.9L226.5 457.5c6.8 6.8 15.9 10.5 25.5 10.5s18.7-3.8 25.5-10.5L432 302.9c23.1-23.1 36-54.3 36-86.9 0-59.6-48.4-108-108-108-39.3 0-73.7 20.9-92.6 52.4-3.3 5.4-9.1 8.7-15.4 8.7s-12.2-3.3-15.4-8.7C217.7 128.9 183.3 108 144 108zM0 216c0-79.5 64.5-144 144-144 43 0 81.6 18.9 108 48.8 26.4-29.9 65-48.8 108-48.8 79.5 0 144 64.5 144 144 0 42.1-16.7 82.6-46.5 112.4L302.9 482.9C289.4 496.4 271.1 504 252 504s-37.4-7.6-50.9-21.1L46.5 328.4C16.7 298.6 0 258.1 0 216z"],
    "font-awesome": [432, 540, [62501, 62694, "font-awesome-flag", "font-awesome-logo-full"], "f2b4", "M72 54C32.2 54 0 86.2 0 126L0 450c0 39.8 32.2 72 72 72s72-32.2 72-72l0-18 216 0c25 0 48.1-12.9 61.2-34.1s14.3-47.7 3.2-70.1l-28.9-57.8 28.9-57.8c11.2-22.3 10-48.8-3.2-70.1S385 108 360 108l-218.3 0c-8-31.1-36.2-54-69.7-54zM36 126c0-19.9 16.1-36 36-36s36 16.1 36 36l0 324c0 19.9-16.1 36-36 36s-36-16.1-36-36l0-324zM144 396l0-252 216 0c12.5 0 24.1 6.5 30.6 17.1s7.2 23.9 1.6 35L359.3 262c-2.5 5.1-2.5 11 0 16.1l32.9 65.9c5.6 11.2 5 24.4-1.6 35S372.5 396 360 396l-216 0z"],
    "forward": [576, 540, [9193], "f04e", "M151.2 453.6c-21.8 16.4-51 19-75.4 6.8S36 423.3 36 396l0-216c0-27.3 15.4-52.2 39.8-64.4s53.6-9.6 75.4 6.8L288 225 288 180c0-27.3 15.4-52.2 39.8-64.4s53.6-9.6 75.4 6.8l144 108C565.3 244 576 265.3 576 288s-10.7 44-28.8 57.6l-144 108c-21.8 16.4-51 19-75.4 6.8S288 423.3 288 396l0-45-136.8 102.6zM324 396c0 13.6 7.7 26.1 19.9 32.2s26.8 4.8 37.7-3.4l144-108C534.7 310 540 299.3 540 288s-5.3-22-14.4-28.8l-144-108c-10.9-8.2-25.5-9.5-37.7-3.4S324 166.4 324 180l0 216zM288 288c0-11.3-5.3-22-14.4-28.8l-144-108c-10.9-8.2-25.5-9.5-37.7-3.4S72 166.4 72 180l0 216c0 13.6 7.7 26.1 19.9 32.2s26.8 4.8 37.7-3.4l144-108C282.7 310 288 299.3 288 288z"],
    "triangle": [504, 540, [9650], "f2ec", "M463.5 432.5c6.2 11.2 6 24.7-.4 35.7S444.8 486 432 486L72 486c-12.8 0-24.6-6.8-31-17.7s-6.6-24.6-.4-35.7l180-324C226.9 97.1 238.9 90 252 90s25.1 7.1 31.5 18.5l180 324zm30.6 54c12.9-22 13.3-49.2 .9-71.5L314.9 91C302.2 68.2 278.1 54 252 54s-50.2 14.2-62.9 37L9.1 415C-3.3 437.3-3 464.5 9.9 486.5S46.5 522 72 522l360 0c25.5 0 49.1-13.5 62.1-35.5z"],
    "star-half": [504, 540, [61731], "f089", "M258.9 46.2c7.2 6.5 11.3 16 11.3 25.8l0 338.9c0 18.6-9.5 35.8-25.2 45.7l-60.2 37.9c-24.9 15.7-56.9 14.6-80.7-2.7S69.4 444.5 76.6 416l19.5-77.3-61.2-51c-22.6-18.8-31.5-49.6-22.4-77.6s34.3-47.6 63.7-49.6l79.5-5.3 29.6-74c7.9-19.8 23.9-34.6 43.3-41.3 11.5-4 22.7-.6 30.3 6.2zM234.2 76.8c-6.9 4-12.4 10.1-15.4 17.8L185 179.1c-2.6 6.4-8.6 10.8-15.5 11.3l-90.8 6c-14.7 1-27.3 10.8-31.9 24.8S46.6 250.6 58 260l69.9 58.3c5.3 4.4 7.6 11.5 5.9 18.2l-22.3 88.2c-3.6 14.3 1.8 29.3 13.7 38s27.9 9.2 40.3 1.3l60.2-37.9c5.2-3.3 8.4-9 8.4-15.2l0-334.1z"],
    "arrow-down-to-line": [360, 540, ["arrow-to-bottom"], "f33d", "M114.2 378L39.1 302.9c-20.6-20.6-26.8-51.6-15.6-78.5S60.9 180 90 180l18 0 0-54c0-39.8 32.2-72 72-72s72 32.2 72 72l0 54 18 0c29.1 0 55.4 17.5 66.5 44.4s5 57.9-15.6 78.5L245.8 378 288 378c39.8 0 72 32.2 72 72s-32.2 72-72 72L72 522c-39.8 0-72-32.2-72-72s32.2-72 72-72l42.2 0zM303.3 238.2C297.7 224.8 284.6 216 270 216l-36 0c-9.9 0-18-8.1-18-18l0-72c0-19.9-16.1-36-36-36s-36 16.1-36 36l0 72c0 9.8-8.2 18-18 18l-36 0c-14.6 0-27.7 8.8-33.3 22.2s-2.5 28.9 7.8 39.2l90 90c7 7 16.2 10.5 25.4 10.5 9.2 0 18.5-3.5 25.5-10.5l90-90c10.3-10.3 13.4-25.8 7.8-39.2zM288 486c19.9 0 36-16.1 36-36s-16.1-36-36-36L72 414c-19.9 0-36 16.1-36 36s16.1 36 36 36l216 0z"],
    "fire": [396, 540, [128293], "f06d", "M163.8 271.3c-7.5-10.1-23.4-9.3-29.9 1.5l-12.5 20.9c-8.8 14.6-13.4 31.3-13.4 48.3 0 49.3 40.9 90 91.1 90 49 0 88.9-39.8 88.9-87.8 0-6.7-1-13.3-2.2-19.9-1.8-9.8-11.5-16.4-21.3-14.4-38 7.7-77.6-7.4-100.7-38.5zm-11.5 40.8c28.1 25.8 64.2 37.5 99.6 35.5-1.8 26.4-24.6 48.4-52.8 48.4-30.6 0-55.1-24.9-55.1-54 0-10.5 2.9-20.9 8.3-29.9zm42.6-273C166.8 11 121.2 11 93.1 39.1 76.8 55.3 70 77.4 72.5 98.5l3.6 32.1c1.7 15.7-1.7 31.5-9.8 45L28.8 238.1c-18.8 31.4-28.8 67.3-28.8 103.9 0 110.2 90.6 198 199.1 198 107.3 0 196.9-86.9 196.9-195.8 0-11.7-1.1-23.5-3.2-35l-16-88c-5.4-29.5-28.4-52.6-57.9-58-25.1-4.6-50.4 4.5-66.9 23.2l0-9.5c0-51.7-20.5-101.3-57.1-137.8zM360 344.2c0 88.7-73 159.8-160.9 159.8-89.1 0-163.1-72.1-163.1-162 0-30.1 8.2-59.6 23.7-85.4l37.5-62.4c12.2-20.3 17.3-44 14.7-67.5l-3.6-32.3c-1.3-10.6 2.2-21.7 10.3-29.8 14.1-14.1 36.9-14.1 50.9 0 29.8 29.8 46.5 70.2 46.5 112.4l0 34.5c0 27.4 38.1 39.2 52.8 14.6l6.3-10.5c7.7-12.9 22.6-19.6 37.3-16.9s26.3 14.2 29 29l16 88c1.7 9.4 2.6 19 2.6 28.6z"],
    "rectangle-vertical": [360, 540, ["rectangle-portrait"], "f2fb", "M0 126C0 86.2 32.2 54 72 54l216 0c39.8 0 72 32.2 72 72l0 324c0 39.8-32.2 72-72 72L72 522c-39.8 0-72-32.2-72-72L0 126zM72 90c-19.9 0-36 16.1-36 36l0 324c0 19.9 16.1 36 36 36l216 0c19.9 0 36-16.1 36-36l0-324c0-19.9-16.1-36-36-36L72 90z"],
    "print": [504, 540, [128424, 128438, 9113], "f02f", "M387 288a27 27 0 1 0 0-54 27 27 0 1 0 0 54zM126 108c0-39.8 32.2-72 72-72l108 0c39.8 0 72 32.2 72 72l0 54c69.6 0 126 56.4 126 126l0 90c0 39.8-32.2 72-72 72l-54 0c0 39.8-32.2 72-72 72l-108 0c-39.8 0-72-32.2-72-72l-54 0c-39.8 0-72-32.2-72-72l0-90c0-69.6 56.4-126 126-126l0-54zm216 0c0-19.9-16.1-36-36-36L198 72c-19.9 0-36 16.1-36 36l0 54 180 0 0-54zM36 288l0 90c0 19.9 16.1 36 36 36l54 0 0-36c0-39.8 32.2-72 72-72l108 0c39.8 0 72 32.2 72 72l0 36 54 0c19.9 0 36-16.1 36-36l0-90c0-49.7-40.3-90-90-90l-252 0c-49.7 0-90 40.3-90 90zm126 90l0 72c0 19.9 16.1 36 36 36l108 0c19.9 0 36-16.1 36-36l0-72c0-19.9-16.1-36-36-36l-108 0c-19.9 0-36 16.1-36 36z"],
    "users": [504, 540, [], "f0c0", "M432 216c0 26.6-11.5 50.5-29.9 67 45.8 19.2 81.8 58.3 96.1 108.2 2.8 9.7 5.8 19.2 5.8 29.4 0 36.1-29.3 65.4-65.4 65.4L66.1 486c-36.5 0-66.1-29.6-66.1-66.1 0-11 3.3-21.5 6-32 14.3-57.1 55.1-102 107.2-123-25.1-19.8-41.2-50.4-41.2-84.9 0-59.6 48.4-108 108-108 48.5 0 89.5 31.9 103.2 75.9 15.8-13.6 36.3-21.9 58.8-21.9 49.7 0 90 40.3 90 90zM180 108a72 72 0 1 0 0 144 72 72 0 1 0 0-144zM438.6 450c16.2 0 29.4-13.1 29.4-29.4 0-6.7-2.6-13.2-4.4-19.5-16.1-56.3-67.5-95.1-126.1-95.1-9.1 0-18 .9-26.6 2.7 20.4 21.7 35.5 48.7 43.1 79.2 2.6 10.5 6 21.1 6 32 0 10.8-2.6 21.1-7.2 30.1l85.9 0zm-144.7 0c16.6 0 30.1-13.5 30.1-30.1 0-7.9-3-15.8-4.9-23.3-16-63.8-73.3-108.6-139.1-108.6S56.9 332.8 40.9 396.6C39 404.1 36 412.1 36 419.9 36 436.5 49.5 450 66.1 450l227.8 0zM342 162a54 54 0 1 0 0 108 54 54 0 1 0 0-108z"],
    "alarm-clock": [504, 540, [9200], "f34e", "M270 180c0-9.9-8.1-18-18-18s-18 8.1-18 18l0 100.5c0 9.5 3.8 18.7 10.5 25.5l48.7 48.7c7 7 18.4 7 25.5 0s7-18.4 0-25.5L270 280.5 270 180zM194.8 79.7c-19.7-26.5-51.2-43.7-86.8-43.7-59.6 0-108 48.4-108 108 0 35.5 17.2 67.1 43.7 86.8-5 18.2-7.7 37.4-7.7 57.2 0 33.3 7.6 64.9 21.1 93.1l-18 18C11 427.2 11 472.8 39.1 500.9s73.7 28.1 101.8 0l18-18C187.1 496.4 218.7 504 252 504s64.9-7.6 93.1-21.1l18 18c28.1 28.1 73.7 28.1 101.8 0s28.1-73.7 0-101.8l-18-18c13.5-28.2 21.1-59.8 21.1-93.1 0-19.8-2.7-39-7.7-57.2 26.5-19.7 43.7-51.2 43.7-86.8 0-59.6-48.4-108-108-108-35.5 0-67.1 17.2-86.8 43.7-18.2-5-37.4-7.7-57.2-7.7s-39 2.7-57.2 7.7zM108 72c19.9 0 37.8 8 50.9 21.1-44.5 21.3-80.5 57.3-101.8 101.8-13-13-21.1-31-21.1-50.9 0-39.8 32.2-72 72-72zM345.1 93.1c13-13 31-21.1 50.9-21.1 39.8 0 72 32.2 72 72 0 19.9-8 37.8-21.1 50.9-21.3-44.5-57.3-80.5-101.8-101.8zM432 288a180 180 0 1 1 -360 0 180 180 0 1 1 360 0zM64.5 424.5l11.4-11.4c14 19.7 31.2 36.9 50.9 50.9l-11.4 11.4c-14.1 14.1-36.9 14.1-50.9 0s-14.1-36.9 0-50.9zm324 50.9l-11.4-11.4c19.7-14 36.9-31.2 50.9-50.9l11.4 11.4c14.1 14.1 14.1 36.9 0 50.9s-36.9 14.1-50.9 0z"],
    "database": [360, 540, [], "f1c0", "M0 432c0 33.2 30.8 55.2 58.1 67.4 32.1 14.3 75.2 22.6 121.9 22.6s89.7-8.4 121.9-22.6C329.2 487.2 360 465.2 360 432l0-288c0-33.2-30.8-55.2-58.1-67.4-32.1-14.3-75.2-22.6-121.9-22.6S90.3 62.4 58.1 76.6C30.8 88.8 0 110.8 0 144L0 432zM36 144C36 126.9 59.9 115.2 72.8 109.5 99.3 97.7 137.2 90 180 90s80.7 7.7 107.2 19.5c12.8 5.7 36.8 17.3 36.8 34.5l0 18c0 17.1-23.9 28.8-36.8 34.5-26.5 11.8-64.4 19.5-107.2 19.5s-80.7-7.7-107.2-19.5C59.9 190.8 36 179.1 36 162l0-18zm288 73.4l0 34.6c0 17.1-23.9 28.8-36.8 34.5-26.5 11.8-64.4 19.5-107.2 19.5s-80.7-7.7-107.2-19.5C59.9 280.8 36 269.1 36 252l0-34.6C77.5 244.6 131.5 252 180 252s102.5-7.4 144-34.6zm0 90l0 34.6c0 17.1-23.9 28.8-36.8 34.5-26.5 11.8-64.4 19.5-107.2 19.5s-80.7-7.7-107.2-19.5C59.9 370.8 36 359.1 36 342l0-34.6C77.5 334.6 131.5 342 180 342s102.5-7.4 144-34.6zm-288 90C77.5 424.6 131.5 432 180 432s102.5-7.4 144-34.6l0 34.6c0 17.1-23.9 28.8-36.8 34.5-26.5 11.8-64.4 19.5-107.2 19.5s-80.7-7.7-107.2-19.5C59.9 460.8 36 449.1 36 432l0-34.6z"],
    "newspaper": [504, 540, [128240], "f1ea", "M180 216c0-19.9 16.1-36 36-36l36 0c19.9 0 36 16.1 36 36l0 54c0 19.9-16.1 36-36 36l-36 0c-19.9 0-36-16.1-36-36l0-54zm72 0l-36 0 0 54 36 0 0-54zm90-36c-9.9 0-18 8.1-18 18s8.1 18 18 18l72 0c9.9 0 18-8.1 18-18s-8.1-18-18-18l-72 0zm0 90c-9.9 0-18 8.1-18 18s8.1 18 18 18l72 0c9.9 0 18-8.1 18-18s-8.1-18-18-18l-72 0zM198 360c-9.9 0-18 8.1-18 18s8.1 18 18 18l216 0c9.9 0 18-8.1 18-18s-8.1-18-18-18l-216 0zM90 162c0-39.8 32.2-72 72-72l270 0c39.8 0 72 32.2 72 72l0 234c0 49.7-40.3 90-90 90L90 486c-49.7 0-90-40.3-90-90L0 234c0-39.8 32.2-72 72-72l18 0zm0 36l-18 0c-19.9 0-36 16.1-36 36l0 162c0 29.8 24.2 54 54 54l324 0c29.8 0 54-24.2 54-54l0-234c0-19.9-16.1-36-36-36l-270 0c-19.9 0-36 16.1-36 36l0 216c0 9.9-8.1 18-18 18s-18-8.1-18-18l0-180z"],
    "location-arrow": [540, 540, [], "f124", "M457.5 100.5C446.9 90 430.9 87 417.2 93.2l-360 162c-14.9 6.7-23.4 22.5-20.8 38.6s15.7 28.4 31.9 30l136 13.6c8.5 .9 15.3 7.6 16.1 16.1l13.6 136c1.6 16.2 13.9 29.3 30 31.9s31.9-5.9 38.6-20.8l162-360c6.1-13.6 3.2-29.7-7.4-40.2zm-55-40.2c27.3-12.3 59.3-6.4 80.5 14.7s27 53.2 14.7 80.5l-162 360c-13.4 29.7-45.1 46.8-77.2 41.5s-56.8-31.5-60.1-63.9L186.2 371.8 64.8 359.6C32.4 356.4 6.2 331.8 .9 299.6s11.8-63.9 41.5-77.2l360-162z"],
    "city": [432, 540, [127961], "f64f", "M270 144c9.9 0 18 8.1 18 18l0 36c0 9.9-8.1 18-18 18s-18-8.1-18-18l0-36c0-9.9 8.1-18 18-18zm72 0c9.9 0 18 8.1 18 18l0 36c0 9.9-8.1 18-18 18s-18-8.1-18-18l0-36c0-9.9 8.1-18 18-18zM288 270c0-9.9-8.1-18-18-18s-18 8.1-18 18l0 36c0 9.9 8.1 18 18 18s18-8.1 18-18l0-36zm72 0c0-9.9-8.1-18-18-18s-18 8.1-18 18l0 36c0 9.9 8.1 18 18 18s18-8.1 18-18l0-36zM288 378c0-9.9-8.1-18-18-18s-18 8.1-18 18l0 36c0 9.9 8.1 18 18 18s18-8.1 18-18l0-36zm72 0c0-9.9-8.1-18-18-18s-18 8.1-18 18l0 36c0 9.9 8.1 18 18 18s18-8.1 18-18l0-36zM108 252c9.9 0 18 8.1 18 18l0 36c0 9.9-8.1 18-18 18s-18-8.1-18-18l0-36c0-9.9 8.1-18 18-18zm0 108c9.9 0 18 8.1 18 18l0 36c0 9.9-8.1 18-18 18s-18-8.1-18-18l0-36c0-9.9 8.1-18 18-18zM252 54c-39.8 0-72 32.2-72 72l0 36-108 0c-39.8 0-72 32.2-72 72L0 450c0 39.8 32.2 72 72 72l288 0c39.8 0 72-32.2 72-72l0-324c0-39.8-32.2-72-72-72L252 54zM360 486l-144 0 0-360c0-19.9 16.1-36 36-36l108 0c19.9 0 36 16.1 36 36l0 324c0 19.9-16.1 36-36 36zm-180 0L72 486c-19.9 0-36-16.1-36-36l0-216c0-19.9 16.1-36 36-36l108 0 0 288z"],
    "arrow-right-to-bracket": [504, 540, ["sign-in"], "f090", "M504 198c0-69.6-56.4-126-126-126l-36 0c-39.8 0-72 32.2-72 72 0 .8 0 1.5 0 2.3-14.8-3.8-30.8-2.9-45.6 3.2-26.9 11.1-44.4 37.4-44.4 66.5L72 216c-39.8 0-72 32.2-72 72s32.2 72 72 72l108 0c0 29.1 17.5 55.4 44.4 66.5 14.8 6.1 30.8 7 45.6 3.2-1.3 40.1 31.8 74.3 72 74.3l36 0c69.6 0 126-56.4 126-126l0-180zM378 108c49.7 0 90 40.3 90 90l0 180c0 49.7-40.3 90-90 90l-36 0c-19.9 0-36-16.1-36-36s16.1-36 36-36l36 0c9.8 0 18-8.2 18-18l0-180c0-9.9-8.1-18-18-18l-36 0c-19.9 0-36-16.1-36-36s16.1-36 36-36l36 0zM238.2 182.7c13.5-5.6 28.9-2.5 39.2 7.8l72 72c14.1 14.1 14.1 36.9 0 50.9l-72 72c-10.3 10.3-25.8 13.4-39.2 7.8S216 374.6 216 360l0-18c0-9.8-8.2-18-18-18L72 324c-19.9 0-36-16.1-36-36s16.1-36 36-36l126 0c9.9 0 18-8.1 18-18l0-18c0-14.6 8.8-27.7 22.2-33.3z"],
    "video-slash": [504, 540, [], "f4e2", "M122.9 57.1C94.8 29 49.2 29 21.1 57.1 0 78.2-5.3 109 5.2 135 1.9 143.3 0 152.5 0 162L0 414c0 39.8 32.2 72 72 72l216 0c16.9 0 32.4-5.8 44.7-15.5l48.4 48.4c28.1 28.1 73.7 28.1 101.8 0 30.2-30.2 25.7-76.2-3.2-105 15.2-13.4 24.3-32.9 24.3-53.9l0-144c0-29.1-17.5-55.4-44.4-66.5s-57.9-5-78.5 15.6L360 186.2 360 162c0-39.8-32.2-72-72-72l-132.2 0-32.9-32.9zM191.8 126l96.2 0c19.9 0 36 16.1 36 36l0 96.2-132.2-132.2zM360 294.2l0-42.2c0-9.5 3.8-18.7 10.5-25.5l36-36c10.3-10.3 25.8-13.4 39.2-7.8S468 201.4 468 216l0 144c0 11.3-5.2 21.6-13.8 28.4L360 294.2zM306.9 444.7c-5.5 3.4-11.9 5.3-18.9 5.3L72 450c-19.9 0-36-16.1-36-36l0-240.2 270.9 270.9zM46.5 82.5c14.1-14.1 36.9-14.1 50.9 0l360 360c14.1 14.1 14.1 36.9 0 50.9s-36.9 14.1-50.9 0l-360-360c-14.1-14.1-14.1-36.9 0-50.9z"],
    "comment": [504, 540, [128489, 61669], "f075", "M0 261C0 126 124.5 36 252 36s252 90 252 225c0 88.9-53 169.2-134.6 204.2l-161 69c-30 12.8-64.8 3.9-85-21.7-14.8-18.8-18.9-43.1-12.4-65.1-64.6-38.6-111-104.5-111-186.4zM252 72c-113.8 0-216 79.5-216 189 0 72 43.6 130.4 106.3 162.6 9.2 4.7 12.5 16.7 7.1 25.5-7.9 12.7-7 29.2 2.3 41.1 10.1 12.8 27.5 17.3 42.5 10.8l161-69C423.6 402.8 468 335.5 468 261 468 151.5 365.8 72 252 72z"],
    "video": [504, 540, ["video-camera"], "f03d", "M72 90C32.2 90 0 122.2 0 162L0 414c0 39.8 32.2 72 72 72l216 0c39.8 0 72-32.2 72-72l0-24.2 21.1 21.1c20.6 20.6 51.6 26.8 78.5 15.6S504 389.1 504 360l0-144c0-29.1-17.5-55.4-44.4-66.5s-57.9-5-78.5 15.6L360 186.2 360 162c0-39.8-32.2-72-72-72L72 90zM360 252c0-9.5 3.8-18.7 10.5-25.5l36-36c10.3-10.3 25.8-13.4 39.2-7.8S468 201.4 468 216l0 144c0 14.6-8.8 27.7-22.2 33.3s-28.9 2.5-39.2-7.8l-36-36c-6.8-6.8-10.5-15.9-10.5-25.5l0-72zm-36-90l0 252c0 19.9-16.1 36-36 36L72 450c-19.9 0-36-16.1-36-36l0-252c0-19.9 16.1-36 36-36l216 0c19.9 0 36 16.1 36 36z"],
    "clipboard": [360, 540, [128203], "f328", "M108 234c-9.9 0-18 8.1-18 18s8.1 18 18 18l144 0c9.9 0 18-8.1 18-18s-8.1-18-18-18l-144 0zM90 324c0-9.9 8.1-18 18-18l144 0c9.9 0 18 8.1 18 18s-8.1 18-18 18l-144 0c-9.9 0-18-8.1-18-18zm18 54c-9.9 0-18 8.1-18 18s8.1 18 18 18l144 0c9.9 0 18-8.1 18-18s-8.1-18-18-18l-144 0zM288 90l-20.3 0c-8-31.1-36.2-54-69.7-54l-36 0c-33.5 0-61.7 22.9-69.7 54L72 90C32.2 90 0 122.2 0 162L0 450c0 39.8 32.2 72 72 72l216 0c39.8 0 72-32.2 72-72l0-288c0-39.8-32.2-72-72-72zM72 126l20.3 0c8 31.1 36.2 54 69.7 54l36 0c33.5 0 61.7-22.9 69.7-54l20.3 0c19.9 0 36 16.1 36 36l0 288c0 19.9-16.1 36-36 36L72 486c-19.9 0-36-16.1-36-36l0-288c0-19.9 16.1-36 36-36zm90-54l36 0c19.9 0 36 16.1 36 36s-16.1 36-36 36l-36 0c-19.9 0-36-16.1-36-36s16.1-36 36-36z"],
    "laptop": [540, 540, [128187], "f109", "M54 144l0 182.3c-31.1 8-54 36.2-54 69.7 0 39.8 32.2 72 72 72l396 0c39.8 0 72-32.2 72-72 0-33.5-22.9-61.7-54-69.7L486 144c0-39.8-32.2-72-72-72L126 72c-39.8 0-72 32.2-72 72zm72-36l288 0c19.9 0 36 16.1 36 36l0 180-54 0 0-144c0-9.9-8.1-18-18-18l-216 0c-9.9 0-18 8.1-18 18l0 144-54 0 0-180c0-19.9 16.1-36 36-36zM360 324l-180 0 0-126 180 0 0 126zm108 36c19.9 0 36 16.1 36 36s-16.1 36-36 36L72 432c-19.9 0-36-16.1-36-36s16.1-36 36-36l396 0z"],
    "thumbs-down": [504, 540, [128078, 61576], "f165", "M156.6 72.8C143.8 61.1 126.7 54 108 54L72 54C32.2 54 0 86.2 0 126L0 288c0 39.8 32.2 72 72 72l36 0c17.6 0 33.8-6.3 46.3-16.9 3 4.9 6.6 9.5 10.8 13.8l7.8 7.8c20.1 20.1 33.8 45.7 39.4 73.6l5.2 25.9c7.8 39 45.7 64.3 84.7 56.5s64.3-45.7 56.5-84.7L353.4 410c-3.4-17.2-8.4-33.9-14.8-50l93.4 0c39.8 0 72-32.2 72-72 0-19.9-8.1-37.9-21.1-51 2-6.7 3.1-13.7 3.1-21 0-19.9-8.1-37.9-21.1-51 2-6.7 3.1-13.7 3.1-21 0-39.8-32.2-72-72-72L162 72c-1.9 0-3.7 .3-5.4 .8zM252.7 457l-5.2-25.9c-7-34.8-24.1-66.8-49.2-92l-7.8-7.8c-4-4-6.8-8.6-8.5-13.4-1.6-4.4-2.1-7.2-2.1-12.1l0-197.9 216 0c19.9 0 36 16.1 36 36 0 6.4-1.7 12.4-4.6 17.6-4.7 8.3-2.1 18.9 6 24 10 6.4 16.6 17.6 16.6 30.4 0 6.4-1.7 12.4-4.6 17.6-4.7 8.3-2.1 18.9 6 24 10 6.4 16.6 17.6 16.6 30.4 0 19.9-16.1 36-36 36l-121.4 0c-6.3 0-12.1 3.3-15.4 8.7s-3.5 12.1-.6 17.6c10.9 20.9 18.8 43.4 23.5 66.8l5.2 25.9c3.9 19.5-8.7 38.5-28.2 42.4s-38.5-8.7-42.4-28.2zM36 288l0-162c0-19.9 16.1-36 36-36l36 0c19.9 0 36 16.1 36 36l0 162c0 19.9-16.1 36-36 36l-36 0c-19.9 0-36-16.1-36-36z"],
    "utensils": [432, 540, [127860, 61685, "cutlery"], "f2e7", "M54 54c13.8 0 26.4 5.2 36 13.8 9.6-8.6 22.2-13.8 36-13.8s26.4 5.2 36 13.8c9.6-8.6 22.2-13.8 36-13.8 21.8 0 40.6 13 49.1 31.6 19.4-19.5 47.2-31.6 76.9-31.6 39.8 0 72 32.2 72 72l0 324c0 39.8-32.2 72-72 72s-72-32.2-72-72l0-99.6c-21.5-12.4-36-35.7-36-62.4l0-10.8c-3.8 3.4-7.8 6.5-12.1 9.4l-5.9 3.9 0 159.5c0 39.8-32.2 72-72 72s-72-32.2-72-72l0-159.5-5.9-3.9C18 266.6 0 232.8 0 196.7L0 108C0 78.2 24.2 54 54 54zM198 90c-9.9 0-18 8.1-18 18l0 72c0 9.9-8.1 18-18 18s-18-8.1-18-18l0-72c0-9.9-8.1-18-18-18s-18 8.1-18 18l0 72c0 9.9-8.1 18-18 18s-18-8.1-18-18l0-72c0-9.9-8.1-18-18-18s-18 8.1-18 18l0 88.7c0 24.1 12 46.6 32.1 59.9L82 265.9c5 3.3 8 9 8 15L90 450c0 19.9 16.1 36 36 36s36-16.1 36-36l0-169.1c0-6 3-11.6 8-15l13.9-9.3c20-13.4 32.1-35.8 32.1-59.9l0-88.7c0-9.9-8.1-18-18-18zm54 71.1L252 288c0 15.6 10 29 24 34 7.2 2.5 12 9.3 12 17L288 450c0 19.9 16.1 36 36 36s36-16.1 36-36l0-324c0-19.9-16.1-36-36-36-39.3 0-72 31.8-72 71.1z"],
    "microphone": [432, 540, [], "f130", "M216 36c-59.6 0-108 48.4-108 108l0 45.6c-10.6-6.1-22.9-9.6-36-9.6-39.8 0-72 32.2-72 72 0 94.1 60.1 174.1 144 203.7l0 12.3c0 39.8 32.2 72 72 72s72-32.2 72-72l0-12.3c83.9-29.7 144-109.6 144-203.7 0-39.8-32.2-72-72-72-13.1 0-25.4 3.5-36 9.6l0-45.6c0-59.6-48.4-108-108-108zM324 252c0-19.9 16.1-36 36-36s36 16.1 36 36c0 82.4-55.3 151.9-130.9 173.2-7.7 2.2-13.1 9.3-13.1 17.3l0 25.5c0 19.9-16.1 36-36 36s-36-16.1-36-36l0-25.5c0-8.1-5.4-15.1-13.1-17.3-75.6-21.4-130.9-90.9-130.9-173.2 0-19.9 16.1-36 36-36s36 16.1 36 36c0 59.6 48.4 108 108 108s108-48.4 108-108zm-36 0c0 39.8-32.2 72-72 72s-72-32.2-72-72l0-108c0-39.8 32.2-72 72-72s72 32.2 72 72l0 108z"],
    "crown": [504, 540, [128081], "f521", "M192.3 67.7C205.7 47.9 228.1 36 252 36s46.3 11.9 59.7 31.7c10.2 14.7 23.1 28 36.7 39.6 25.1 21.5 54 36.7 83.6 36.7 22.2 0 43.1 10.2 56.8 27.7s18.5 40.3 13.1 61.8l-54 216C439.8 481.5 411 504 378 504l-252 0c-33 0-61.8-22.5-69.9-54.5l-54-216c-5.4-21.5-.5-44.3 13.1-61.8S49.8 144 72 144c29.7 0 58.5-15.1 83.6-36.7 13.6-11.6 26.5-24.9 36.7-39.6zM126 468l252 0c16.5 0 30.9-11.2 34.9-27.3l54-216c2.7-10.8 .3-22.1-6.6-30.9S443.1 180 432 180c-41.8 0-78.7-21-107.1-45.3-13.8-11.8-26.4-25.1-37.6-39.4-9.2-11.8-18.2-23.2-35.3-23.2s-26.1 11.4-35.3 23.2c-11.2 14.3-23.8 27.6-37.6 39.4-28.3 24.3-65.2 45.3-107.1 45.3-11.1 0-21.6 5.1-28.4 13.8s-9.2 20.1-6.5 30.9l54 216c4 16 18.4 27.3 34.9 27.3zm97.3-255.9c6.9-8.9 17.5-14.1 28.7-14.1s21.8 5.2 28.7 14.1l51.9 66.8c6 7.8 9.3 17.3 9.3 27.2s-3.3 19.4-9.3 27.2l-51.9 66.8c-6.9 8.9-17.5 14.1-28.7 14.1s-21.8-5.2-28.7-14.1l-51.9-66.8c-6-7.8-9.3-17.3-9.3-27.2s3.3-19.4 9.3-27.2l51.9-66.8zm28.4 22.1l-51.9 66.8c-2.2 2.9-2.2 7.2 0 10.1l51.9 66.8c.2 .2 .5 .2 .6 0l51.9-66.8c2.2-2.9 2.2-7.2 0-10.1l-51.9-66.8c-.2-.2-.5-.2-.6 0z"],
    "arrow-up-wide-short": [540, 540, ["sort-amount-up"], "f161", "M5.5 243.6c-11.1-26.9-5-57.9 15.6-78.5l72-72c28.1-28.1 73.7-28.1 101.8 0l61.6 61.6C266.8 127.4 293.1 108 324 108l144 0c39.8 0 72 32.2 72 72 0 37-27.9 67.5-63.9 71.5 6.3 10.7 9.9 23.2 9.9 36.5 0 37-27.9 67.5-63.9 71.5 6.3 10.7 9.9 23.2 9.9 36.5 0 39.8-32.2 72-72 72l-36 0c-39.8 0-72-32.2-72-72 0-21.5 9.4-40.8 24.4-54-14.9-13.2-24.4-32.5-24.4-54 0-3.4 .2-6.8 .7-10.1-10.9 6.4-23.5 10.1-36.7 10.1l0 144c0 39.8-32.2 72-72 72s-72-32.2-72-72l0-144c-29.1 0-55.4-17.5-66.5-44.4zm41.1-53c-10.3 10.3-13.4 25.8-7.8 39.2S57.4 252 72 252l18 0c9.9 0 18 8.1 18 18l0 162c0 19.9 16.1 36 36 36s36-16.1 36-36l0-162c0-9.8 8.2-18 18-18l18 0c14.6 0 27.7-8.8 33.3-22.2s2.5-28.9-7.8-39.2l-72-72c-14.1-14.1-36.9-14.1-50.9 0l-72 72zM324 324l90 0c19.9 0 36-16.1 36-36s-16.1-36-36-36l-90 0c-19.9 0-36 16.1-36 36s16.1 36 36 36zm-36 72c0 19.9 16.1 36 36 36l36 0c19.9 0 36-16.1 36-36s-16.1-36-36-36l-36 0c-19.9 0-36 16.1-36 36zM468 216c19.9 0 36-16.1 36-36s-16.1-36-36-36l-144 0c-19.9 0-36 16.1-36 36s16.1 36 36 36l144 0z"],
    "sun": [504, 540, [9728], "f185", "M193.8 65.6C207.4 47 229 36 252 36s44.6 11 58.2 29.6l21.6 29.7 36.3-5.7c22.7-3.6 45.8 3.9 62.1 20.2s23.8 39.4 20.2 62.1l-5.7 36.3 29.7 21.6C493 243.4 504 265 504 288s-11 44.6-29.6 58.2l-29.7 21.6 5.7 36.3c3.6 22.7-3.9 45.8-20.2 62.1s-39.4 23.8-62.1 20.2l-36.3-5.7-21.6 29.7C296.6 529 275 540 252 540s-44.6-11-58.2-29.6l-21.6-29.7-36.3 5.7c-22.7 3.6-45.8-3.9-62.1-20.2S50 426.8 53.6 404.1l5.7-36.3-29.7-21.6C11 332.6 0 311 0 288s11-44.6 29.6-58.2l29.7-21.6-5.7-36.3c-3.6-22.7 3.9-45.8 20.2-62.1S113.2 86 135.9 89.6l36.3 5.7 21.6-29.7zM180 288a72 72 0 1 0 144 0 72 72 0 1 0 -144 0zM252 72c-11.5 0-22.3 5.5-29.1 14.8l-28.1 38.6c-4 5.5-10.7 8.2-17.3 7.2l-47.1-7.4c-11.4-1.8-22.9 2-31 10.1s-11.9 19.7-10.1 31l7.4 47.1c1 6.7-1.7 13.4-7.2 17.3L50.8 258.9C41.5 265.7 36 276.5 36 288s5.5 22.3 14.8 29.1l38.6 28.1c5.5 4 8.2 10.7 7.2 17.3l-7.4 47.1c-1.8 11.4 2 22.9 10.1 31s19.7 11.9 31 10.1l47.1-7.4c6.7-1 13.4 1.7 17.3 7.2l28.1 38.6c6.8 9.3 17.6 14.8 29.1 14.8s22.3-5.5 29.1-14.8l28.1-38.6c4-5.5 10.7-8.2 17.3-7.2l47.1 7.4c11.4 1.8 22.9-2 31-10.1s11.9-19.7 10.1-31l-7.4-47.1c-1-6.7 1.7-13.4 7.2-17.3l38.6-28.1c9.3-6.8 14.8-17.6 14.8-29.1s-5.5-22.3-14.8-29.1l-38.6-28.1c-5.5-4-8.2-10.7-7.2-17.3l7.4-47.1c1.8-11.4-2-22.9-10.1-31s-19.7-11.9-31-10.1l-47.1 7.4c-6.7 1-13.4-1.7-17.3-7.2L281.1 86.8C274.3 77.5 263.5 72 252 72zm0 324a108 108 0 1 1 0-216 108 108 0 1 1 0 216z"],
    "image": [432, 540, [], "f03e", "M216 216a72 72 0 1 1 -144 0 72 72 0 1 1 144 0zm-72-36a36 36 0 1 0 0 72 36 36 0 1 0 0-72zM0 144c0-39.8 32.2-72 72-72l288 0c39.8 0 72 32.2 72 72l0 288c0 39.8-32.2 72-72 72L72 504c-39.8 0-72-32.2-72-72L0 144zM396 262.5L396 144c0-19.9-16.1-36-36-36L72 108c-19.9 0-36 16.1-36 36l0 288c0 12.6 6.5 23.8 16.4 30.2L167.3 347.3c26.9-26.9 70.5-26.9 97.5 0 12.9 12.9 33.7 12.9 46.5 0L396 262.5zM97.5 468L360 468c19.9 0 36-16.1 36-36l0-118.5-59.3 59.3c-26.9 26.9-70.5 26.9-97.5 0-12.9-12.9-33.7-12.9-46.5 0L97.5 468z"],
    "notdef": [360, 540, [], "e1fe", "M54.1 94.8C59.4 91.7 65.5 90 72 90l216 0c6.5 0 12.6 1.7 17.9 4.8L180 258.5 54.1 94.8zM36 130.3L157.3 288 36 445.7 36 130.3zM54.1 481.2L180 317.5 305.9 481.2c-5.3 3-11.4 4.8-17.9 4.8L72 486c-6.5 0-12.6-1.7-17.9-4.8zM324 445.7L202.7 288 324 130.3 324 445.7zM72 54C32.2 54 0 86.2 0 126L0 450c0 39.8 32.2 72 72 72l216 0c39.8 0 72-32.2 72-72l0-324c0-39.8-32.2-72-72-72L72 54z"],
    "pencil": [468, 540, [9999, 61504, "pencil-alt"], "f303", "M351 54c-22.1 0-43.2 8.8-58.8 24.4L70.3 300.2c-9.1 9.1-16.1 20-20.6 32L3.1 456.5c-2 5.4-3.1 11.2-3.1 17 0 26.8 21.7 48.5 48.5 48.5 5.8 0 11.6-1 17-3.1l124.2-46.6c12-4.5 23-11.5 32-20.6L443.6 229.8C459.2 214.2 468 193.1 468 171s-8.8-43.2-24.4-58.8L409.8 78.4C394.2 62.8 373.1 54 351 54zm45 172.5L295.5 126 317.6 103.8C326.5 95 338.5 90 351 90s24.5 5 33.4 13.8l33.8 33.8C427 146.5 432 158.5 432 171s-5 24.5-13.8 33.4L396 226.5zM270 151.5L370.5 252 202.5 420 102 319.5 270 151.5zM172.1 440.5L52.9 485.2c-9.8 3.7-19.6-6.5-16.1-16.1l44.7-119.2 90.6 90.6z"],
    "lightbulb": [360, 540, [128161], "f0eb", "M126 216c0-29.8 24.2-54 54-54 9.9 0 18-8.1 18-18s-8.1-18-18-18c-49.7 0-90 40.3-90 90 0 9.9 8.1 18 18 18s18-8.1 18-18zM0 216C0 116.6 80.6 36 180 36s180 80.6 180 180c0 59.1-23 106.7-58.6 151.9-19.1 24.2-31.4 39.8-31.4 64.1l0 18c0 49.7-40.3 90-90 90s-90-40.3-90-90l0-18C90 407.7 77.7 392.1 58.6 367.9 23 322.7 0 275.1 0 216zm36 0c0 50.1 19.4 90.2 49.9 128.2 8.4 10.5 17.2 21.5 24.5 33.8l139.3 0c7.2-12.3 16.1-23.3 24.5-33.8 30.5-38 49.9-78.2 49.9-128.2 0-79.5-64.5-144-144-144S36 136.5 36 216zm90 216l0 18c0 29.8 24.2 54 54 54s54-24.2 54-54l0-18c0-6.3 .6-12.3 1.7-18l-111.3 0c1.1 5.7 1.7 11.7 1.7 18z"],
    "code": [540, 540, [], "f121", "M255 87.3c11.4-38.1 51.6-59.7 89.7-48.3s59.7 51.6 48.3 89.7l-8.2 27.2c24.4-7.1 51.9-1 71.1 18.2l63 63c28.1 28.1 28.1 73.7 0 101.8l-72 72c-28.1 28.1-73.7 28.1-101.8 0-14.4-14.4-21.5-33.5-21.1-52.4L285 488.7c-11.4 38.1-51.6 59.7-89.7 48.3s-59.7-51.6-48.3-89.7l8.2-27.2c-24.4 7.1-51.9 1-71.1-18.2l-63-63C-7 310.8-7 265.2 21.1 237.1l72-72c28.1-28.1 73.7-28.1 101.8 0 14.4 14.4 21.5 33.5 21.1 52.4L255 87.3zm79.3-13.8c-19-5.7-39.1 5.1-44.8 24.1l-108 360c-5.7 19 5.1 39.1 24.1 44.8s39.1-5.1 44.8-24.1l108-360c5.7-19-5.1-39.1-24.1-44.8zm-164.9 117c-14.1-14.1-36.9-14.1-50.9 0l-72 72c-14.1 14.1-14.1 36.9 0 50.9l63 63c14.1 14.1 36.9 14.1 50.9 0s14.1-36.9 0-50.9l-24.8-24.8c-6.9-6.9-6.9-18.5 0-25.5l33.8-33.8c14.1-14.1 14.1-36.9 0-50.9zm261 9c-14.1-14.1-36.9-14.1-50.9 0s-14.1 36.9 0 50.9l24.8 24.8c7 7 7 18.4 0 25.5l-33.8 33.8c-14.1 14.1-14.1 36.9 0 50.9s36.9 14.1 50.9 0l72-72c14.1-14.1 14.1-36.9 0-50.9l-63-63z"],
    "address-card": [504, 540, [62140, "contact-card", "vcard"], "f2bb", "M306 198c-9.9 0-18 8.1-18 18s8.1 18 18 18l90 0c9.9 0 18-8.1 18-18s-8.1-18-18-18l-90 0zm0 72c-9.9 0-18 8.1-18 18s8.1 18 18 18l90 0c9.9 0 18-8.1 18-18s-8.1-18-18-18l-90 0zm0 72c-9.9 0-18 8.1-18 18s8.1 18 18 18l90 0c9.9 0 18-8.1 18-18s-8.1-18-18-18l-90 0zm-93.6-38.6c13.3-13.1 21.6-31.3 21.6-51.4 0-39.8-32.2-72-72-72s-72 32.2-72 72c0 20.1 8.3 38.4 21.6 51.4-23.9 16.2-39.6 43.5-39.6 74.6 0 9.9 8.1 18 18 18s18-8.1 18-18c0-29.8 24.2-54 54-54s54 24.2 54 54c0 9.9 8.1 18 18 18s18-8.1 18-18c0-31-15.7-58.4-39.6-74.6zM162 288a36 36 0 1 1 0-72 36 36 0 1 1 0 72zM72 90C32.2 90 0 122.2 0 162L0 414c0 39.8 32.2 72 72 72l360 0c39.8 0 72-32.2 72-72l0-252c0-39.8-32.2-72-72-72L72 90zM36 162c0-19.9 16.1-36 36-36l360 0c19.9 0 36 16.1 36 36l0 252c0 19.9-16.1 36-36 36L72 450c-19.9 0-36-16.1-36-36l0-252z"],
    "angle-right": [324, 540, [8250], "f105", "M303.4 237.1c28.1 28.1 28.1 73.7 0 101.8l-144 144c-28.1 28.1-73.7 28.1-101.8 0s-28.1-73.7 0-101.8l93.1-93.1-93.1-93.1c-28.1-28.1-28.1-73.7 0-101.8s73.7-28.1 101.8 0l144 144zM278 313.5c14.1-14.1 14.1-36.9 0-50.9l-144-144c-14.1-14.1-36.9-14.1-50.9 0S69 155.4 83 169.5L188.9 275.3c3.4 3.4 5.3 8 5.3 12.7s-1.9 9.4-5.3 12.7L83 406.5C69 420.6 69 443.4 83 457.5s36.9 14.1 50.9 0l144-144z"],
    "face-meh": [504, 540, [128528, "meh"], "f11a", "M126 306c-9.9 0-18 8.1-18 18s8.1 18 18 18l252 0c9.9 0 18-8.1 18-18s-8.1-18-18-18l-252 0zm0-90c0-9.9 8.1-18 18-18l72 0c9.9 0 18 8.1 18 18s-8.1 18-18 18l-72 0c-9.9 0-18-8.1-18-18zm162-18c-9.9 0-18 8.1-18 18s8.1 18 18 18l72 0c9.9 0 18-8.1 18-18s-8.1-18-18-18l-72 0zM252 36a252 252 0 1 0 0 504 252 252 0 1 0 0-504zM468 288a216 216 0 1 1 -432 0 216 216 0 1 1 432 0z"],
    "map": [504, 540, [128506, 62072], "f279", "M212.2 61.6l117.3 58.7 79.7-26.6c22-7.3 46.1-3.6 64.9 9.9S504 138.9 504 162l0 252c0 31-19.8 58.5-49.2 68.3l-108 36c-18.1 6-37.9 4.6-55-3.9l-117.3-58.7-79.7 26.6c-22 7.3-46.1 3.6-64.9-9.9S0 437.1 0 414L0 162c0-31 19.8-58.5 49.2-68.3l108-36c18.1-6 37.9-4.6 55 3.9zM60.6 127.8C45.9 132.7 36 146.5 36 162l0 252c0 11.6 5.6 22.4 15 29.2s21.5 8.6 32.4 4.9l78.6-26.2 0-327.9-101.4 33.8zM306 481.2l0-332.5-108-54 0 332.5 108 54zm36 .7l101.4-33.8c14.7-4.9 24.6-18.7 24.6-34.2l0-252c0-11.6-5.6-22.4-14.9-29.2s-21.5-8.6-32.4-4.9l-78.6 26.2 0 327.9z"],
    "thumbtack": [504, 540, [128204, 128392, "thumb-tack"], "f08d", "M482.9 266.9c28.1-28.1 28.1-73.7 0-101.8l-108-108c-28.1-28.1-73.7-28.1-101.8 0-11.4 11.4-18.1 25.6-20.3 40.3l-99 63c-28.3-23.4-70.2-21.8-96.7 4.7-28.1 28.1-28.1 73.7 0 101.8l57.1 57.1-75.1 75.1C11 427.2 11 472.8 39.1 500.9s73.7 28.1 101.8 0l75.1-75.1 57.1 57.1c28.1 28.1 73.7 28.1 101.8 0 26.5-26.5 28-68.4 4.7-96.7l63-99c14.8-2.2 29-9 40.3-20.3zM190.5 400.4l-75.1 75.1c-14.1 14.1-36.9 14.1-50.9 0s-14.1-36.9 0-50.9l75.1-75.1 50.9 50.9zM457.5 190.5c14.1 14.1 14.1 36.9 0 50.9-7 7-16.1 10.5-25.3 10.5-6.1 0-11.8 3.2-15.1 8.3L341.6 378.8c-4.5 7.1-3.5 16.4 2.5 22.4l5.4 5.4c14.1 14.1 14.1 36.9 0 50.9s-36.9 14.1-50.9 0l-216-216c-14.1-14.1-14.1-36.9 0-50.9s36.9-14.1 50.9 0l5.4 5.4c6 6 15.3 7 22.4 2.5L279.7 123c5.2-3.3 8.3-9 8.3-15.1 0-9.2 3.5-18.3 10.5-25.3 14.1-14.1 36.9-14.1 50.9 0l108 108z"],
    "money-bill-wave": [504, 540, [], "f53a", "M252 180c-53.2 0-90 52.3-90 108s36.8 108 90 108 90-52.3 90-108-36.8-108-90-108zM198 288c0-43.7 27.7-72 54-72s54 28.3 54 72-27.7 72-54 72-54-28.3-54-72zM255.6 88.7c-47.9-12-97.8-14-146.5-5.9L60.2 91C25.4 96.8 0 126.8 0 162L0 414c0 21.2 9.3 41.3 25.5 54.9S63 488.5 83.8 485l48.9-8.2c29.2-4.9 59.2-3.7 87.9 3.5l27.8 6.9c47.9 12 97.8 14 146.5 5.9l48.9-8.2c34.7-5.8 60.2-35.8 60.2-71l0-252c0-21.2-9.3-41.3-25.5-54.9S441 87.5 420.2 91l-48.9 8.2c-29.2 4.9-59.1 3.7-87.9-3.5l-27.8-6.9zM144 126c0-3.8-.2-7.5-.6-11.1 34.7-2.7 69.6 .3 103.4 8.7l27.8 6.9c28.1 7 57.2 9.1 85.9 6.3 5.4 54.6 51.5 97.2 107.5 97.2l0 108c-59.6 0-108 48.4-108 108 0 3.8 .2 7.5 .6 11.1-34.7 2.7-69.6-.3-103.4-8.7l-27.8-6.9c-28.1-7-57.2-9.1-85.9-6.3-5.4-54.6-51.5-97.2-107.5-97.2l0-108c59.6 0 108-48.4 108-108zm324 72c-37.9 0-69-29.3-71.8-66.5l29.9-5c21.6-3.6 41.9 13.6 41.9 35.5l0 36zM36 378c37.9 0 69 29.3 71.8 66.5l-29.9 5C56.3 453.1 36 435.9 36 414l0-36zm360.3 78.4C392.6 415 426.2 378 468 378l0 36c0 17.6-12.7 32.6-30.1 35.5l-41.6 6.9zM36 198l0-36c0-17.6 12.7-32.6 30.1-35.5l41.6-6.9C111.4 161 77.8 198 36 198z"],
    "folder": [504, 540, [128193, 128447, 61716, "folder-blank"], "f07b", "M72 486c-39.8 0-72-32.2-72-72L0 126C0 86.2 32.2 54 72 54l100 0c21.9 0 42.6 9.9 56.2 27l39.6 49.5C274.7 139 285 144 296 144l136 0c39.8 0 72 32.2 72 72l0 198c0 39.8-32.2 72-72 72L72 486zM36 414c0 19.9 16.1 36 36 36l360 0c19.9 0 36-16.1 36-36l0-198c0-19.9-16.1-36-36-36l-136 0c-21.9 0-42.6-9.9-56.2-27l-39.6-49.5C193.3 95 183 90 172 90L72 90c-19.9 0-36 16.1-36 36l0 288z"],
    "arrow-up-from-bracket": [432, 540, [], "e09a", "M0 378c0-39.8 32.2-72 72-72 33.5 0 61.7 22.9 69.7 54l2.3 0 0-108c-29.1 0-55.4-17.5-66.5-44.4-3.6-8.7-5.4-18-5.5-27.1-.1-18.9 7.2-37.4 21.1-51.3l72-72c28.1-28.1 73.7-28.1 101.8 0l72 72c13.9 13.9 21.2 32.6 21.1 51.5-.1 9.1-1.9 18.3-5.5 27-11.1 26.9-37.4 44.4-66.5 44.4l0 108 2.3 0c8-31.1 36.2-54 69.7-54 39.8 0 72 32.2 72 72l0 36c0 69.6-56.4 126-126 126l-180 0C56.4 540 0 483.6 0 414l0-36zm396 36l0-36c0-19.9-16.1-36-36-36s-36 16.1-36 36l0 36c0 9.9-8.1 18-18 18l-180 0c-4.8 0-9.4-1.9-12.7-5.3s-5.3-8-5.3-12.7l0-36c0-19.9-16.1-36-36-36s-36 16.1-36 36l0 36c0 49.7 40.3 90 90 90l180 0c49.7 0 90-40.3 90-90zM252 234c0-9.8 8.2-18 18-18l18 0c14.6 0 27.7-8.8 33.3-22.2 5.5-13.3 2.4-29.1-7.8-39.2l-72-72c-14.1-14.1-36.9-14.1-50.9 0l-72 72c-10.2 10.2-13.3 26-7.8 39.2 5.6 13.5 18.7 22.2 33.3 22.2l18 0c9.9 0 18 8.1 18 18l0 126c0 19.8 16.1 35.9 35.9 36 19.6-.1 36.1-16.3 36.1-36l0-126z"],
    "cloud": [540, 540, [9729], "f0c2", "M167.1 144.1c27-43.2 75.1-72.1 129.9-72.1 84.5 0 153 68.5 153 153 0 11.8-1.3 23.4-3.9 34.4 44.3 16.6 75.9 59.4 75.9 109.6 0 59.7-44.6 108.9-102.3 116.1-1.8 .6-3.7 .9-5.7 .9l-288 0c-69.6 0-126-56.4-126-126 0-42.9 21.4-80.7 54.1-103.5 2.3-61.3 51.7-110.5 113.1-112.5zM410.2 450c.7-.2 1.4-.3 2.2-.3 41.3-3.7 73.6-38.4 73.6-80.7 0-39.5-28.3-72.4-65.7-79.6-10.8-2.1-17.3-13.6-13.5-23.9 4.7-12.6 7.2-26.2 7.2-40.5 0-64.6-52.4-117-117-117-44.9 0-84 25.3-103.6 62.6-4.8 9.1-13.5 9.4-22.4 9.4-44.7 0-81 36.3-81 81 0 8.4-.7 16.3-8.9 21-27 15.6-45.1 44.7-45.1 78 0 49.7 40.3 90 90 90l284.2 0z"],
    "circle": [504, 540, [128308, 128309, 128992, 128993, 128994, 128995, 128996, 9679, 9898, 9899, 11044, 61708, 61915], "f111", "M504 288a252 252 0 1 1 -504 0 252 252 0 1 1 504 0zM252 72a216 216 0 1 0 0 432 216 216 0 1 0 0-432z"],
    "backward": [576, 540, [9194], "f04a", "M424.8 453.6c21.8 16.4 51 19 75.4 6.8S540 423.3 540 396l0-216c0-27.3-15.4-52.2-39.8-64.4s-53.6-9.6-75.4 6.8L288 225 288 180c0-27.3-15.4-52.2-39.8-64.4s-53.6-9.6-75.4 6.8l-144 108C10.7 244 0 265.3 0 288s10.7 44 28.8 57.6l144 108c21.8 16.4 51 19 75.4 6.8S288 423.3 288 396l0-45 136.8 102.6zM252 396c0 13.6-7.7 26.1-19.9 32.2s-26.8 4.8-37.7-3.4l-144-108C41.3 310 36 299.3 36 288s5.3-22 14.4-28.8l144-108c10.9-8.2 25.5-9.5 37.7-3.4S252 166.4 252 180l0 216zm36-108c0-11.3 5.3-22 14.4-28.8l144-108c10.9-8.2 25.5-9.5 37.7-3.4S504 166.4 504 180l0 216c0 13.6-7.7 26.1-19.9 32.2s-26.8 4.8-37.7-3.4l-144-108C293.3 310 288 299.3 288 288z"],
    "link": [504, 540, [128279, "chain"], "f0c1", "M323.8 36C276 36 230.2 55 196.4 88.8l-31.3 31.3c-16.5 16.5-23.3 39.1-20.4 60.6-21.5-2.9-44 3.9-60.6 20.4L52.8 232.4C19 266.2 0 312 0 359.8 0 459.3 80.7 540 180.2 540 228 540 273.8 521 307.6 487.2l31.3-31.3c16.5-16.5 23.3-39.1 20.4-60.6 21.5 2.9 44-3.9 60.6-20.4l31.3-31.3C485 309.8 504 264 504 216.2 504 116.7 423.3 36 323.8 36zM108 359.6c-.1 18.6 6.9 37.1 21.1 51.3 14.4 14.4 33.4 21.4 52.3 21.1 18.7-.3 36.6-7.9 49.8-21.1l31.3-31.3c14.1-14.1 36.9-14.1 50.9 0s14.1 36.9 0 50.9l-31.3 31.3c-27 27-63.7 42.2-102 42.2-79.6 0-144.2-64.6-144.2-144.2 0-38.2 15.2-74.9 42.2-102l31.3-31.3c14.1-14.1 36.9-14.1 50.9 0s14.1 36.9 0 50.9l-31.3 31.3c-13.5 13.5-21.1 31.8-21.1 50.9zm266.9-92.4c13.5-13.5 21.1-31.9 21.1-51 0-18.4-7.1-37.1-21.1-51.1-14.2-14.2-32.7-21.2-51.3-21.1-19.1 .1-37.4 7.7-50.9 21.1l-31.3 31.3c-14.1 14.1-36.9 14.1-50.9 0s-14.1-36.9 0-50.9l31.3-31.3c27-27 63.7-42.2 102-42.2 79.6 0 144.2 64.6 144.2 144.2 0 38.2-15.2 74.9-42.2 102l-31.3 31.3c-14.1 14.1-36.9 14.1-50.9 0s-14.1-36.9 0-50.9l31.3-31.3zM360 215.9c0 9.2-3.5 18.5-10.5 25.5l-144 144c-6.8 6.8-16.3 10.4-25.3 10.5-20 0-36.2-16.2-36.2-36.2 .1-9.1 3.6-18.3 10.5-25.2l144-144c7-7 16.1-10.5 25.2-10.5 19.9 0 36.1 16.1 36.3 35.9z"],
    "backward-step": [432, 540, ["step-backward"], "f048", "M108 108c39.8 0 72 32.2 72 72l0 45 136.8-102.6c21.8-16.4 51-19 75.4-6.8S432 152.7 432 180l0 216c0 27.3-15.4 52.2-39.8 64.4s-53.6 9.6-75.4-6.8L180 351 180 396c0 39.8-32.2 72-72 72l-36 0c-39.8 0-72-32.2-72-72L0 180c0-39.8 32.2-72 72-72l36 0zm36 288l0-216c0-19.9-16.1-36-36-36l-36 0c-19.9 0-36 16.1-36 36l0 216c0 19.9 16.1 36 36 36l36 0c19.9 0 36-16.1 36-36zm36-108c0 11.3 5.3 22 14.4 28.8l144 108c10.9 8.2 25.5 9.5 37.7 3.4S396 409.6 396 396l0-216c0-13.6-7.7-26.1-19.9-32.2s-26.8-4.8-37.7 3.4l-144 108C185.3 266 180 276.7 180 288z"],
    "circle-user": [504, 540, [62142, "user-circle"], "f2bd", "M504 288a252 252 0 1 1 -504 0 252 252 0 1 1 504 0zM252 72c-119.3 0-216 96.7-216 216 0 47.3 15.2 91.1 41 126.6 7.6-11 16.3-21.1 25.3-30.1 19.3-19.3 45.9-38.3 80.4-49.7-23.7-19.8-38.7-49.6-38.7-82.8 0-59.6 48.4-108 108-108s108 48.4 108 108c0 33.3-15 63-38.7 82.8 34.5 11.4 61.1 30.5 80.4 49.7 9 9 17.6 19.1 25.3 30.1 25.8-35.6 41-79.3 41-126.6 0-119.3-96.7-216-216-216zM402.5 443c-7.2-11.8-16.2-23-26.2-32.9-25.2-25.2-65.5-50-124.3-50s-99.1 24.8-124.3 50c-10 10-19.1 21.1-26.2 32.9 38.9 37.8 92 61 150.5 61s111.6-23.3 150.5-61zM252 180a72 72 0 1 0 0 144 72 72 0 1 0 0-144z"],
    "hand": [504, 540, [129306, 9995, "hand-paper"], "f256", "M143.8 489.8c33.7 21 72.6 32.2 112.3 32.2 117 0 211.9-94.9 211.9-211.9L468 180c0-39.8-32.2-72-72-72-13.1 0-25.4 3.5-36 9.6l0-9.6c0-39.8-32.2-72-72-72-31.4 0-58.1 20.1-68 48.2-11.4-7.7-25.2-12.2-40-12.2-39.8 0-72 32.2-72 72l0 153.6C74.6 278.3 31.6 288.8 11 321.8-10.1 355.6 .1 400 33.8 421.1l110 68.7zM252 108c0-19.9 16.1-36 36-36s36 16.1 36 36l0 198c0 9.9 8.1 18 18 18s18-8.1 18-18l0-126.2c.1-19.8 16.2-35.8 36-35.8 19.9 0 36 16.1 36 36l0 130.1c0 97.1-78.7 175.9-175.9 175.9-33 0-65.3-9.3-93.2-26.7l-110-68.7c-16.9-10.5-22-32.7-11.4-49.6s32.7-22 49.6-11.4l25.4 15.9c11.8 7.4 27.5-1.4 27.5-15.3L144 144c0-19.9 16.1-36 36-36 19.9 0 36 16.1 36 36l0 144c0 9.9 8.1 18 18 18s18-8.1 18-18l0-180z"],
    "thumbs-up": [504, 540, [128077, 61575], "f164", "M156.6 503.2C143.8 514.9 126.7 522 108 522l-36 0c-39.8 0-72-32.2-72-72L0 288c0-39.8 32.2-72 72-72l36 0c17.6 0 33.8 6.3 46.3 16.9 3-4.9 6.6-9.5 10.8-13.8l7.8-7.8c20.1-20.1 33.8-45.7 39.4-73.6l5.2-25.9c7.8-39 45.7-64.3 84.7-56.5s64.3 45.7 56.5 84.7L353.4 166c-3.4 17.2-8.4 33.9-14.8 50l93.4 0c39.8 0 72 32.2 72 72 0 19.9-8.1 37.9-21.1 51 2 6.7 3.1 13.7 3.1 21 0 19.9-8.1 37.9-21.1 51 2 6.7 3.1 13.7 3.1 21 0 39.8-32.2 72-72 72l-234 0c-1.9 0-3.7-.3-5.4-.8zm96.1-384.2l-5.2 25.9c-7 34.8-24.1 66.8-49.2 92-6.4 6.4-13.1 12.4-16.3 21.2-1.6 4.4-2.1 7.2-2.1 12.1l0 197.9 216 0c19.9 0 36-16.1 36-36 0-6.4-1.7-12.4-4.6-17.6-4.7-8.3-2.1-18.9 6-24 10-6.4 16.6-17.6 16.6-30.4 0-6.4-1.7-12.4-4.6-17.6-4.7-8.3-2.1-18.9 6-24 10-6.4 16.6-17.6 16.6-30.4 0-19.9-16.1-36-36-36l-121.4 0c-6.3 0-12.1-3.3-15.4-8.7s-3.5-12.1-.6-17.6c10.9-20.9 18.8-43.4 23.5-66.8l5.2-25.9c3.9-19.5-8.7-38.5-28.2-42.4s-38.5 8.7-42.4 28.2zM36 288l0 162c0 19.9 16.1 36 36 36l36 0c19.9 0 36-16.1 36-36l0-162c0-19.9-16.1-36-36-36l-36 0c-19.9 0-36 16.1-36 36z"],
    "building": [360, 540, [127970, 61687], "f1ad", "M108 126c9.9 0 18 8.1 18 18l0 54c0 9.9-8.1 18-18 18s-18-8.1-18-18l0-54c0-9.9 8.1-18 18-18zm72 0c9.9 0 18 8.1 18 18l0 54c0 9.9-8.1 18-18 18s-18-8.1-18-18l0-54c0-9.9 8.1-18 18-18zm72 0c9.9 0 18 8.1 18 18l0 54c0 9.9-8.1 18-18 18s-18-8.1-18-18l0-54c0-9.9 8.1-18 18-18zM126 270c0-9.9-8.1-18-18-18s-18 8.1-18 18l0 54c0 9.9 8.1 18 18 18s18-8.1 18-18l0-54zm72 0c0-9.9-8.1-18-18-18s-18 8.1-18 18l0 54c0 9.9 8.1 18 18 18s18-8.1 18-18l0-54zm72 0c0-9.9-8.1-18-18-18s-18 8.1-18 18l0 54c0 9.9 8.1 18 18 18s18-8.1 18-18l0-54zM0 126C0 86.2 32.2 54 72 54l216 0c39.8 0 72 32.2 72 72l0 324c0 39.8-32.2 72-72 72l-18 0c-39.8 0-72-32.2-72-72l0-18c0-9.9-8.1-18-18-18s-18 8.1-18 18l0 18c0 39.8-32.2 72-72 72l-18 0c-39.8 0-72-32.2-72-72L0 126zM72 90c-19.9 0-36 16.1-36 36l0 324c0 19.9 16.1 36 36 36l18 0c19.9 0 36-16.1 36-36l0-18c0-29.8 24.2-54 54-54s54 24.2 54 54l0 18c0 19.9 16.1 36 36 36l18 0c19.9 0 36-16.1 36-36l0-324c0-19.9-16.1-36-36-36L72 90z"],
    "gear": [468, 540, [9881, "cog"], "f013", "M155.4 97.1C160.8 61.9 191 36 226.6 36l15.3 0c35.5 0 65.8 25.9 71.2 61.1l4.9 31.5c4.3 2.2 8.4 4.7 12.5 7.2l29.8-11.6c33.1-12.9 70.7 .3 88.5 31.1l7.7 13.3c17.8 30.8 10.4 69.9-17.3 92.2l-24.9 20c.2 4.8 .2 9.6 0 14.4l24.9 20c27.7 22.2 35.1 61.4 17.3 92.2l-7.7 13.3c-17.8 30.8-55.3 44-88.5 31.1l-29.8-11.6c-4.1 2.6-8.2 5-12.5 7.2l-4.9 31.5c-5.4 35.1-35.6 61.1-71.2 61.1l-15.3 0c-35.5 0-65.8-25.9-71.2-61.1l-4.9-31.5c-4.3-2.2-8.4-4.7-12.5-7.2l-29.8 11.6c-33.1 12.9-70.7-.3-88.5-31.1l-7.7-13.3c-17.8-30.8-10.4-69.9 17.3-92.2l24.9-20c-.2-4.8-.2-9.6 0-14.4l-24.9-20C1.7 238.6-5.6 199.4 12.2 168.6l7.7-13.3c17.8-30.8 55.3-44 88.5-31.1L138 135.8c4.1-2.6 8.2-5 12.5-7.2l4.9-31.5zM226.6 72c-17.8 0-32.9 13-35.6 30.5l-6.3 40.8c-.9 6-4.8 11.1-10.3 13.6-8.3 3.8-16.3 8.4-23.7 13.7-4.9 3.5-11.3 4.3-17 2.1l-38.5-15c-16.6-6.4-35.3 .2-44.2 15.6l-7.7 13.3c-8.9 15.4-5.2 35 8.6 46.1l32.2 25.9c4.7 3.8 7.2 9.7 6.7 15.7-.8 9-.8 18.4 0 27.4 .6 6-1.9 11.9-6.7 15.7L52 343.3c-13.9 11.1-17.5 30.7-8.6 46.1L51 402.6c8.9 15.4 27.7 22 44.2 15.6l38.5-15c5.7-2.2 12-1.4 17 2.1 7.4 5.3 15.3 9.9 23.7 13.7 5.5 2.5 9.4 7.6 10.3 13.6l6.3 40.8c2.7 17.6 17.8 30.5 35.6 30.5l15.3 0c17.8 0 32.9-13 35.6-30.5l6.3-40.8c.9-6 4.8-11.1 10.3-13.6 8.3-3.8 16.3-8.4 23.7-13.7 4.9-3.5 11.3-4.3 17-2.1l38.5 15c16.6 6.4 35.3-.2 44.2-15.6l7.7-13.3c8.9-15.4 5.2-35-8.6-46.1l-32.2-25.9c-4.7-3.8-7.2-9.7-6.7-15.7 .8-9 .8-18.4 0-27.4-.6-6 1.9-11.9 6.7-15.7l32.2-25.9c13.9-11.1 17.5-30.7 8.6-46.1l-7.7-13.3c-8.9-15.4-27.7-22-44.2-15.6l-38.5 15c-5.7 2.2-12 1.4-17-2.1-7.4-5.3-15.3-9.9-23.7-13.7-5.5-2.5-9.4-7.6-10.3-13.6l-6.3-40.8C274.8 85 259.7 72 241.9 72l-15.3 0zm7.7 180a36 36 0 1 0 0 72 36 36 0 1 0 0-72zm72 36a72 72 0 1 1 -144 0 72 72 0 1 1 144 0z"],
    "circle-question": [504, 540, [62108, "question-circle"], "f059", "M225 405a27 27 0 1 1 54 0 27 27 0 1 1 -54 0zM198 234c0-29.8 24.2-54 54-54s54 24.2 54 54c0 20.4-11.3 38.2-28.1 47.4-22.5 12.3-43.9 33.1-43.9 60.6 0 9.9 8.1 18 18 18s18-8.1 18-18c0-13.4 14.8-23.4 25.2-29 27.9-15.3 46.8-44.9 46.8-79 0-49.7-40.3-90-90-90s-90 40.3-90 90c0 9.9 8.1 18 18 18s18-8.1 18-18zm306 54a252 252 0 1 1 -504 0 252 252 0 1 1 504 0zM252 72a216 216 0 1 0 0 432 216 216 0 1 0 0-432z"],
    "file": [360, 540, [128196, 128459, 61462], "f15b", "M0 126C0 86.2 32.2 54 72 54l108 0c16.3 0 31.9 6.5 43.5 18L342 190.5c11.5 11.5 18 27.2 18 43.5l0 216c0 39.8-32.2 72-72 72L72 522c-39.8 0-72-32.2-72-72L0 126zM72 90c-19.9 0-36 16.1-36 36l0 324c0 19.9 16.1 36 36 36l216 0c19.9 0 36-16.1 36-36l0-198-90 0c-39.8 0-72-32.2-72-72l0-90-90 0zM316.5 216L198 97.5 198 180c0 19.9 16.1 36 36 36l82.5 0z"],
    "volume-slash": [576, 540, [128263], "f2e2", "M158.9 57.1C130.8 29 85.2 29 57.1 57.1s-28.1 73.7 0 101.8l3.9 3.9C26.5 168.1 0 198 0 234L0 342c0 39.8 32.2 72 72 72l39.1 0c4.8 0 9.4 1.9 12.7 5.3l86.3 86.3c10.5 10.5 24.8 16.5 39.7 16.5 31 0 56.2-25.2 56.2-56.2l0-58 111.1 111.1c28.1 28.1 73.7 28.1 101.8 0 24.4-24.4 27.6-61.9 9.7-89.8 29.7-39.2 47.4-88.1 47.4-141.2 0-92-53.1-171.4-130-209.6-35.6-17.7-78.8-3.2-96.5 32.4s-3.2 78.8 32.4 96.5c29.8 14.8 50 45.4 50 80.7 0 12.5-2.5 24.3-7.1 35.1l-118.9-118.9 0-94c0-31-25.2-56.2-56.2-56.2-14.9 0-29.2 5.9-39.7 16.5l-18.9 18.9-32.3-32.3zM451.8 349.9c10.4-18.3 16.2-39.5 16.2-61.9 0-49.4-28.4-92.3-70-112.9-17.8-8.8-25.1-30.5-16.2-48.3s30.5-25.1 48.3-16.2c65.1 32.4 110 99.6 110 177.4 0 42.5-13.4 81.8-36.1 114l-52.1-52.1zM133.5 82.5l360 360c14.1 14.1 14.1 36.9 0 50.9s-36.9 14.1-50.9 0l-360-360c-14.1-14.1-14.1-36.9 0-50.9s36.9-14.1 50.9 0zM72 198l24.2 0 173.8 173.8 0 94c0 11.1-9 20.2-20.2 20.2-5.4 0-10.5-2.1-14.3-5.9l-86.3-86.3c-10.1-10.1-23.9-15.8-38.2-15.8L72 378c-19.9 0-36-16.1-36-36l0-108c0-19.9 16.1-36 36-36zm198-87.8l0 58-53.4-53.4 18.9-18.9c3.8-3.8 8.9-5.9 14.3-5.9 11.1 0 20.2 9 20.2 20.2z"],
    "arrow-up": [468, 540, [8593], "f062", "M446.9 219.1c28.1 28.1 28.1 73.7 0 101.8s-73.7 28.1-101.8 0L306 281.8 306 468c0 39.8-32.2 72-72 72s-72-32.2-72-72l0-186.2-39.1 39.1C94.8 349 49.2 349 21.1 320.9s-28.1-73.7 0-101.8l162-162c28.1-28.1 73.7-28.1 101.8 0l162 162zm-25.5 76.4c14.1-14.1 14.1-36.9 0-50.9l-162-162c-14.1-14.1-36.9-14.1-50.9 0l-162 162c-14.1 14.1-14.1 36.9 0 50.9s36.9 14.1 50.9 0l69.8-69.8c5.1-5.1 12.9-6.7 19.6-3.9s11.1 9.3 11.1 16.6L198 468c0 19.9 16.1 36 36 36s36-16.1 36-36l0-229.6c0-7.3 4.4-13.8 11.1-16.6s14.5-1.2 19.6 3.9l69.8 69.8c14.1 14.1 36.9 14.1 50.9 0z"],
    "rectangle": [504, 540, [9644, "rectangle-landscape"], "f2fa", "M72 486c-39.8 0-72-32.2-72-72L0 162c0-39.8 32.2-72 72-72l360 0c39.8 0 72 32.2 72 72l0 252c0 39.8-32.2 72-72 72L72 486zM36 414c0 19.9 16.1 36 36 36l360 0c19.9 0 36-16.1 36-36l0-252c0-19.9-16.1-36-36-36L72 126c-19.9 0-36 16.1-36 36l0 252z"],
    "grid": [432, 540, ["grid-3"], "e195", "M24.4 288C9.4 274.8 0 255.5 0 234l0-90c0-39.8 32.2-72 72-72l90 0c21.5 0 40.8 9.4 54 24.4 13.2-14.9 32.5-24.4 54-24.4l90 0c39.8 0 72 32.2 72 72l0 90c0 21.5-9.4 40.8-24.4 54 14.9 13.2 24.4 32.5 24.4 54l0 90c0 39.8-32.2 72-72 72l-90 0c-21.5 0-40.8-9.4-54-24.4-13.2 14.9-32.5 24.4-54 24.4l-90 0c-39.8 0-72-32.2-72-72l0-90c0-21.5 9.4-40.8 24.4-54zM270 306c-19.9 0-36 16.1-36 36l0 90c0 19.9 16.1 36 36 36l90 0c19.9 0 36-16.1 36-36l0-90c0-19.9-16.1-36-36-36l-90 0zM198 432l0-90c0-19.9-16.1-36-36-36l-90 0c-19.9 0-36 16.1-36 36l0 90c0 19.9 16.1 36 36 36l90 0c19.9 0 36-16.1 36-36zm0-198l0-90c0-19.9-16.1-36-36-36l-90 0c-19.9 0-36 16.1-36 36l0 90c0 19.9 16.1 36 36 36l90 0c19.9 0 36-16.1 36-36zm36 0c0 19.9 16.1 36 36 36l90 0c19.9 0 36-16.1 36-36l0-90c0-19.9-16.1-36-36-36l-90 0c-19.9 0-36 16.1-36 36l0 90z"],
    "shirt": [504, 540, [128085, "t-shirt", "tshirt"], "f553", "M111.8 61.6c10-5 21-7.6 32.2-7.6 20.7 0 35.6 14.6 42.3 29.4 11.3 25.1 36.5 42.6 65.7 42.6s54.5-17.4 65.7-42.6c6.6-14.8 21.6-29.4 42.3-29.4 11.2 0 22.2 2.6 32.2 7.6l72 36C488.6 109.8 504 134.7 504 162l0 36c0 25-12.9 48.1-34.1 61.2-19.5 12.1-43.5 14-64.6 5.6L414 449.1c1.9 39.5-33.5 72.9-72 72.9l-180 0c-38.5 0-73.9-33.3-72-72.9l8.8-184.3C77.7 273.3 53.7 271.3 34.1 259.2 12.9 246.1 0 223 0 198l0-36c0-27.3 15.4-52.2 39.8-64.4l72-36zm16.1 32.2l-72 36C43.7 135.9 36 148.4 36 162l0 36c0 12.5 6.5 24.1 17.1 30.6s23.9 7.2 35 1.6l22.1-11c12.1-6 26.7 3.5 26 17L126 450.4c.2 19.7 16.2 35.6 36 35.6l180 0c19.8 0 35.8-15.9 36-35.6L367.8 236.1c-.6-13.5 14-23 26-17l22.1 11c11.2 5.6 24.4 5 35-1.6S468 210.5 468 198l0-36c0-13.6-7.7-26.1-19.9-32.2l-72-36c-9.2-4.6-20.6-6.6-25.5 4.4-16.9 37.6-54.6 63.8-98.6 63.8s-81.7-26.2-98.6-63.8c-4.9-11-16.3-9-25.5-4.4z"],
    "suitcase": [504, 540, [129523], "f0f2", "M126 162l0-18c0-39.8 32.2-72 72-72l108 0c39.8 0 72 32.2 72 72l0 18 54 0c39.8 0 72 32.2 72 72l0 198c0 39.8-32.2 72-72 72L72 504c-39.8 0-72-32.2-72-72L0 234c0-39.8 32.2-72 72-72l54 0zm36-18l0 18 180 0 0-18c0-19.9-16.1-36-36-36l-108 0c-19.9 0-36 16.1-36 36zm180 54l-180 0 0 270 180 0 0-270zm36 270l54 0c19.9 0 36-16.1 36-36l0-198c0-19.9-16.1-36-36-36l-54 0 0 270zm-252 0l0-270-54 0c-19.9 0-36 16.1-36 36l0 198c0 19.9 16.1 36 36 36l54 0z"],
    "play": [504, 540, [9654], "f04b", "M107.7 63.8c22.1-12.9 49.4-13.1 71.6-.6l288 162C490 238 504 262 504 288s-14 50-36.7 62.8l-288 162c-22.3 12.5-49.6 12.3-71.6-.6S72 475.6 72 450l0-324c0-25.6 13.6-49.2 35.7-62.2zm54 30.8c-11.1-6.3-24.8-6.2-35.8 .3S108 113.2 108 126l0 324c0 12.8 6.8 24.6 17.8 31.1s24.7 6.6 35.8 .3l288-162C461 313 468 301 468 288s-7-25-18.4-31.4l-288-162z"],
    "paperclip": [504, 540, [128206], "f0c6", "M196.4 88.8C230.2 55 276 36 323.8 36 423.3 36 504 116.7 504 216.2 504 264 485 309.8 451.2 343.6L291.8 503.1c-23.6 23.6-55.7 36.9-89.2 36.9-86.3 0-139.5-80.2-123.5-153.3-20.7 2-42.1-4.9-58-20.7-28.1-28.1-28.1-73.7 0-101.8L196.4 88.8zM298.5 190.6c-53.3 53.2-106.4 106.4-159.6 159.6-56.8 56.8-16.6 153.8 63.7 153.8 23.9 0 46.8-9.5 63.7-26.4L425.8 318.1c27-27 42.2-63.7 42.2-102 0-79.6-64.6-144.2-144.2-144.2-38.2 0-74.9 15.2-102 42.2L46.5 289.5c-14.1 14.1-14.1 36.9 0 50.9s36.9 14 50.9 0L273.1 165.1c28.1-28.1 73.7-28.1 101.8 0s28.1 73.7 0 101.8L215.2 426.7c-7 7-18.4 7-25.5 0s-7-18.4 0-25.5L349.5 241.5c14.1-14.1 14.1-36.9 0-50.9s-36.9-14-50.9 0z"],
    "signal-bars-weak": [468, 540, ["signal-alt-1"], "f691", "M72 504c-39.8 0-72-32.2-72-72l0-72c0-39.8 32.2-72 72-72s72 32.2 72 72l0 72c0 39.8-32.2 72-72 72zM36 432c0 19.9 16.1 36 36 36s36-16.1 36-36l0-72c0-19.9-16.1-36-36-36s-36 16.1-36 36l0 72z"],
    "wrench": [468, 540, [128295], "f0ad", "M108 432a18 18 0 1 0 0-36 18 18 0 1 0 0 36zM297 54c-94.4 0-171 76.6-171 171 0 15.6 2.1 30.7 6 45.1L21.1 381.1C-7 409.2-7 454.8 21.1 482.9l18 18c28.1 28.1 73.7 28.1 101.8 0L251.9 390c14.4 3.9 29.5 6 45.1 6 94.4 0 171-76.6 171-171 0-16.4-2.3-32.2-6.6-47.3-7.9-27.6-40.4-30.1-57-13.5l-87.8 87.8-46.5 0 0-46.5 87.8-87.8c16.6-16.6 14.1-49.1-13.5-57-15-4.3-30.9-6.6-47.3-6.6zM162 225c0-74.6 60.4-135 135-135 11.5 0 22.7 1.4 33.4 4.2L244.5 180c-6.8 6.8-10.5 15.9-10.5 25.5l0 46.5c0 19.9 16.1 36 36 36l46.5 0c9.5 0 18.7-3.8 25.5-10.5l85.8-85.8c2.7 10.7 4.2 21.8 4.2 33.4 0 74.6-60.4 135-135 135-15.5 0-30.4-2.6-44.3-7.4-6.5-2.3-13.8-.6-18.6 4.3L115.5 475.5c-14.1 14.1-36.9 14.1-50.9 0l-18-18c-14.1-14.1-14.1-36.9 0-50.9L165.2 287.9c4.9-4.9 6.5-12.1 4.3-18.6-4.8-13.9-7.4-28.8-7.4-44.3z"],
    "life-ring": [504, 540, [], "f1cd", "M30.9 167.1c-19.5-28.1-16.8-67 8.2-92l.1-.1C64.1 50.3 102.9 47.3 131.1 66.9 167 47.2 208.2 36 252 36s85 11.2 120.9 30.9c28.1-19.5 67-16.8 92 8.2s27.8 63.9 8.2 92C492.8 203 504 244.2 504 288s-11.2 85-30.9 120.9c19.5 28.1 16.8 67-8.2 92s-63.9 27.8-92 8.2C337 528.8 295.8 540 252 540s-85-11.2-120.9-30.9c-28.1 19.5-67 16.8-92-8.2s-27.8-63.9-8.2-92C11.2 373 0 331.8 0 288s11.2-85 30.9-120.9zm26.2 214L144.2 294c-.2-4-.2-8 0-12L57.1 194.9C43.6 223.1 36 254.7 36 288s7.6 64.9 21.1 93.1zm97.5-46.6l-90 90c-14.1 14.1-14.1 36.9 0 50.9s36.9 14.1 50.9 0l90-90c-22.2-10.6-40.3-28.7-50.9-50.9zM246 395.8l-87.1 87.1C187.1 496.4 218.7 504 252 504s64.9-7.6 93.1-21.1L258 395.8c-4 .2-8 .2-12 0zm52.6-10.4l90 90c14.1 14.1 36.9 14.1 50.9 0s14.1-36.9 0-50.9l-90-90c-10.6 22.2-28.7 40.3-50.9 50.9zM359.8 294l87.1 87.1C460.4 352.9 468 321.3 468 288s-7.6-64.9-21.1-93.1L359.8 282c.2 4 .2 8 0 12zm-10.4-52.6l90-90c14.1-14.1 14.1-36.9 0-50.9s-36.9-14.1-50.9 0l-90 90c22.2 10.6 40.3 28.7 50.9 50.9zM258 180.2l87.1-87.1C316.9 79.6 285.3 72 252 72s-64.9 7.6-93.1 21.1L246 180.2c4-.2 8-.2 12 0zm-52.6 10.4l-90-90c-14-14-36.8-13.9-50.9 0-14 14.1-14 36.8 0 50.9l90 90c10.6-22.2 28.7-40.3 50.9-50.9zM252 216a72 72 0 1 0 0 144 72 72 0 1 0 0-144z"],
    "calendar": [432, 540, [128197, 128198], "f133", "M234 72c0-9.9-8.1-18-18-18s-18 8.1-18 18l0 18-72 0 0-18c0-9.9-8.1-18-18-18S90 62.1 90 72l0 18-18 0C32.2 90 0 122.2 0 162L0 432c0 39.8 32.2 72 72 72l288 0c39.8 0 72-32.2 72-72l0-270c0-39.8-32.2-72-72-72l-18 0 0-18c0-9.9-8.1-18-18-18s-18 8.1-18 18l0 18-72 0 0-18zM90 126l0 18c0 9.9 8.1 18 18 18s18-8.1 18-18l0-18 72 0 0 18c0 9.9 8.1 18 18 18s18-8.1 18-18l0-18 72 0 0 18c0 9.9 8.1 18 18 18s18-8.1 18-18l0-18 18 0c19.9 0 36 16.1 36 36l0 54-360 0 0-54c0-19.9 16.1-36 36-36l18 0zM396 432c0 19.9-16.1 36-36 36L72 468c-19.9 0-36-16.1-36-36l0-180 360 0 0 180z"],
    "check": [504, 540, [10003, 10004], "f00c", "M483.4 93.1C455.3 65 409.7 65 381.6 93.1l-201.1 201.1-57.1-57.1C95.3 209 49.7 209 21.6 237.1s-28.1 73.7 0 101.8l108 108c28.1 28.1 73.7 28.1 101.8 0l252-252c28.1-28.1 28.1-73.7 0-101.8zM407 118.5c14.1-14.1 36.9-14.1 50.9 0s14.1 36.9 0 50.9l-252 252c-14.1 14.1-36.9 14.1-50.9 0L47 313.5C33 299.4 33 276.6 47 262.5s36.9-14.1 50.9 0l69.8 69.8c7 7 18.4 7 25.5 0L407 118.5z"],
    "chart-bar": [468, 540, ["bar-chart"], "f080", "M144 126c0-39.8 32.2-72 72-72l36 0c39.8 0 72 32.2 72 72l0 108 72 0c39.8 0 72 32.2 72 72l0 144c0 39.8-32.2 72-72 72L72 522c-39.8 0-72-32.2-72-72L0 234c0-39.8 32.2-72 72-72l72 0 0-36zM288 486l0-360c0-19.9-16.1-36-36-36l-36 0c-19.9 0-36 16.1-36 36l0 360 108 0zm36 0l72 0c19.9 0 36-16.1 36-36l0-144c0-19.9-16.1-36-36-36l-72 0 0 216zM144 198l-72 0c-19.9 0-36 16.1-36 36l0 216c0 19.9 16.1 36 36 36l72 0 0-288z"],
    "house": [432, 540, [127968, 63498, 63500, "home", "home-alt", "home-lg-alt"], "f015", "M238.7 80.1c-13.2-10.7-32.2-10.7-45.4 0l-144 117C40.9 203.9 36 214.2 36 225l0 207c0 19.9 16.1 36 36 36l36 0c19.9 0 36-16.1 36-36l0-72c0-39.8 32.2-72 72-72s72 32.2 72 72l0 72c0 19.9 16.1 36 36 36l36 0c19.9 0 36-16.1 36-36l0-207c0-10.8-4.9-21.1-13.3-27.9l-144-117zM170.6 52.1c26.5-21.5 64.4-21.5 90.8 0l144 117C422.2 182.8 432 203.3 432 225l0 207c0 39.8-32.2 72-72 72l-36 0c-39.8 0-72-32.2-72-72l0-72c0-19.9-16.1-36-36-36s-36 16.1-36 36l0 72c0 39.8-32.2 72-72 72l-36 0c-39.8 0-72-32.2-72-72L0 225c0-21.7 9.8-42.2 26.6-55.9l144-117z"],
    "play-pause": [504, 540, [], "e22f", "M115.2 453.6c-21.8 16.4-51 19-75.4 6.8S0 423.3 0 396L0 180c0-27.3 15.4-52.2 39.8-64.4s53.6-9.6 75.4 6.8L252 225 252 180c0-39.8 32.2-72 72-72 21.5 0 40.8 9.4 54 24.4 13.2-14.9 32.5-24.4 54-24.4 39.8 0 72 32.2 72 72l0 216c0 39.8-32.2 72-72 72-21.5 0-40.8-9.4-54-24.4-13.2 14.9-32.5 24.4-54 24.4-39.8 0-72-32.2-72-72l0-45-136.8 102.6zM288 396c0 19.9 16.1 36 36 36s36-16.1 36-36l0-216c0-19.9-16.1-36-36-36s-36 16.1-36 36l0 216zM252 288c0-11.3-5.3-22-14.4-28.8l-144-108c-10.9-8.2-25.5-9.5-37.7-3.4S36 166.4 36 180l0 216c0 13.6 7.7 26.1 19.9 32.2s26.8 4.8 37.7-3.4l144-108C246.7 310 252 299.3 252 288zM432 432c19.9 0 36-16.1 36-36l0-216c0-19.9-16.1-36-36-36s-36 16.1-36 36l0 216c0 19.9 16.1 36 36 36z"],
    "sliders": [504, 540, ["sliders-h"], "f1de", "M272.3 234L72 234c-39.8 0-72-32.2-72-72S32.2 90 72 90l200.3 0c8-31.1 36.2-54 69.7-54s61.7 22.9 69.7 54L432 90c39.8 0 72 32.2 72 72s-32.2 72-72 72l-20.3 0c-8 31.1-36.2 54-69.7 54s-61.7-22.9-69.7-54zM306 108l0 108c0 19.9 16.1 36 36 36s36-16.1 36-36l0-108c0-19.9-16.1-36-36-36s-36 16.1-36 36zm-36 18L72 126c-19.9 0-36 16.1-36 36s16.1 36 36 36l198 0 0-72zm144 72l18 0c19.9 0 36-16.1 36-36s-16.1-36-36-36l-18 0 0 72zM92.3 486L72 486c-39.8 0-72-32.2-72-72s32.2-72 72-72l20.3 0c8-31.1 36.2-54 69.7-54s61.7 22.9 69.7 54L432 342c39.8 0 72 32.2 72 72s-32.2 72-72 72l-200.3 0c-8 31.1-36.2 54-69.7 54s-61.7-22.9-69.7-54zM126 360l0 108c0 19.9 16.1 36 36 36s36-16.1 36-36l0-108c0-19.9-16.1-36-36-36s-36 16.1-36 36zM90 378l-18 0c-19.9 0-36 16.1-36 36s16.1 36 36 36l18 0 0-72zm144 72l198 0c19.9 0 36-16.1 36-36s-16.1-36-36-36l-198 0 0 72z"],
    "face-frown": [504, 540, [9785, "frown"], "f119", "M154.4 385.7c-4.3 9-15 12.8-24 8.5s-12.8-15-8.5-24C145 321.7 194.5 288 252 288s107 33.7 130.1 82.3c4.3 9 .4 19.7-8.5 24s-19.7 .4-24-8.5C332.3 349.2 295.1 324 252 324s-80.3 25.2-97.6 61.7zM162 207a27 27 0 1 1 54 0 27 27 0 1 1 -54 0zm153 27a27 27 0 1 0 0-54 27 27 0 1 0 0 54zM252 36a252 252 0 1 0 0 504 252 252 0 1 0 0-504zM468 288a216 216 0 1 1 -432 0 216 216 0 1 1 432 0z"],
    "forward-step": [432, 540, ["step-forward"], "f051", "M324 108c-39.8 0-72 32.2-72 72l0 45-136.8-102.6c-21.8-16.4-51-19-75.4-6.8S0 152.7 0 180L0 396c0 27.3 15.4 52.2 39.8 64.4s53.6 9.6 75.4-6.8L252 351 252 396c0 39.8 32.2 72 72 72l36 0c39.8 0 72-32.2 72-72l0-216c0-39.8-32.2-72-72-72l-36 0zM288 396l0-216c0-19.9 16.1-36 36-36l36 0c19.9 0 36 16.1 36 36l0 216c0 19.9-16.1 36-36 36l-36 0c-19.9 0-36-16.1-36-36zM252 288c0 11.3-5.3 22-14.4 28.8l-144 108c-10.9 8.2-25.5 9.5-37.7 3.4S36 409.6 36 396l0-216c0-13.6 7.7-26.1 19.9-32.2s26.8-4.8 37.7 3.4l144 108C246.7 266 252 276.7 252 288z"],
    "wand-magic": [468, 540, ["magic"], "f0d0", "M429.4 75.1C401.3 47 355.7 47 327.6 75.1l-306 306c-28.1 28.1-28.1 73.7 0 101.8l18 18c28.1 28.1 73.7 28.1 101.8 0l306-306c28.1-28.1 28.1-73.7 0-101.8l-18-18zM353 100.5c14.1-14.1 36.9-14.1 50.9 0l18 18c14.1 14.1 14.1 36.9 0 50.9l-59.3 59.3-68.9-68.9 59.3-59.3zm-84.7 84.7L337.2 254.2 116 475.5c-14.1 14.1-36.9 14.1-50.9 0l-18-18C33 443.4 33 420.6 47 406.5L268.3 185.3z"],
    "sort": [396, 540, ["unsorted"], "f0dc", "M371.6 288c8.1-7.1 14.6-16.1 18.9-26.4 11.1-26.9 5-57.9-15.6-78.5l-126-126C220.8 29 175.2 29 147.1 57.1l-126 126c-20.6 20.6-26.8 51.6-15.6 78.5 4.3 10.4 10.8 19.3 18.9 26.4-8.1 7.1-14.6 16.1-18.9 26.4-11.1 26.9-5 57.9 15.6 78.5l126 126c28.1 28.1 73.7 28.1 101.8 0l126-126c20.6-20.6 26.8-51.6 15.6-78.5-4.3-10.4-10.8-19.3-18.9-26.4zM223.5 82.5l126 126c10.3 10.3 13.4 25.8 7.8 39.2S338.6 270 324 270L72 270c-14.6 0-27.7-8.8-33.3-22.2s-2.5-28.9 7.8-39.2l126-126c14.1-14.1 36.9-14.1 50.9 0zM324 306c14.6 0 27.7 8.8 33.3 22.2s2.5 28.9-7.8 39.2l-126 126c-14.1 14.1-36.9 14.1-50.9 0l-126-126c-10.3-10.3-13.4-25.8-7.8-39.2S57.4 306 72 306l252 0z"],
    "user": [432, 540, [128100, 62144, 62470, "user-alt", "user-large"], "f007", "M216.5 54c-69.6 0-126 56.4-126 126 0 41.6 20.2 78.6 51.3 101.5-38.2 12.4-67.5 33.4-88.7 54.6-19 19-36.8 42.7-47.4 69.1-8.9 22.2-6.2 47.3 7.2 67.1S48.6 504 72.5 504l288 0c23.9 0 46.2-11.9 59.6-31.6s16.1-44.9 7.2-67.1c-10.6-26.5-28.4-50.1-47.4-69.1-21.2-21.2-50.6-42.1-88.7-54.6 31.1-22.9 51.3-59.9 51.3-101.5 0-69.6-56.4-126-126-126zm90 126a90 90 0 1 1 -180 0 90 90 0 1 1 180 0zM78.5 361.5c28-28 72.7-55.5 138-55.5s110 27.6 138 55.5c16.7 16.7 31.1 36.3 39.5 57.1 4.4 11.1 3.1 23.6-3.6 33.5S372.4 468 360.5 468l-288 0c-11.9 0-23.1-5.9-29.8-15.8s-8.1-22.5-3.6-33.5c8.3-20.8 22.8-40.4 39.5-57.1z"],
    "signal-bars": [468, 540, ["signal-alt", "signal-alt-4", "signal-bars-strong"], "f690", "M342 479.6c13.2 14.9 32.5 24.4 54 24.4 39.8 0 72-32.2 72-72l0-288c0-39.8-32.2-72-72-72s-72 32.2-72 72l0 9.6c-10.6-6.1-22.9-9.6-36-9.6-39.8 0-72 32.2-72 72l0 9.6c-10.6-6.1-22.9-9.6-36-9.6-39.8 0-72 32.2-72 72l0 9.6c-10.6-6.1-22.9-9.6-36-9.6-39.8 0-72 32.2-72 72l0 72c0 39.8 32.2 72 72 72 21.5 0 40.8-9.4 54-24.4 13.2 14.9 32.5 24.4 54 24.4s40.8-9.4 54-24.4c13.2 14.9 32.5 24.4 54 24.4s40.8-9.4 54-24.4zM108 432c0 19.9-16.1 36-36 36s-36-16.1-36-36l0-72c0-19.9 16.1-36 36-36s36 16.1 36 36l0 72zm36 0l0-144c0-19.9 16.1-36 36-36s36 16.1 36 36l0 144c0 19.9-16.1 36-36 36s-36-16.1-36-36zm144 36c-19.9 0-36-16.1-36-36l0-216c0-19.9 16.1-36 36-36s36 16.1 36 36l0 216c0 19.9-16.1 36-36 36zm72-36l0-288c0-19.9 16.1-36 36-36s36 16.1 36 36l0 288c0 19.9-16.1 36-36 36s-36-16.1-36-36z"],
    "snowflake": [504, 540, [10052, 10054], "f2dc", "M252.5 558c-16.6 0-33.1-5.7-46.6-17.1l-66.8-56.6-82.4-29.5c-16.6-5.9-29.8-17.5-38.1-31.9-8.3-14.3-11.6-31.5-8.4-48.8L25.8 288 10.2 201.9c-3.1-17.3 .2-34.4 8.4-48.7 8.3-14.3 21.6-26 38.2-31.9l82.4-29.5 66.8-56.6c26.9-22.8 66.3-22.8 93.1 0l66.8 56.6 82.4 29.5c33.2 11.9 52.9 46 46.6 80.7l-15.7 86.1 15.7 86.1c6.3 34.7-13.4 68.8-46.6 80.7l-82.4 29.5-66.8 56.6c-13.4 11.4-30 17.1-46.6 17.1zm18-499.2l0 49.2c0 9.9-8.1 18-18 18s-18-8.1-18-18l0-49.2c-1.8 1.1-3.6 2.3-5.3 3.7l-57.8 49 60.7 105.1c5 8.6 2 19.6-6.6 24.6s-19.6 2-24.6-6.6l-60.7-105.1-71.3 25.5c-2.1 .7-4 1.7-5.9 2.7l42.6 24.6c8.6 5 11.6 16 6.6 24.6s-16 11.6-24.6 6.6L45 189c0 2.1 .2 4.3 .6 6.4l13.6 74.6 121.3 0c9.9 0 18 8.1 18 18s-8.1 18-18 18l-121.3 0-13.6 74.6c-.4 2.2-.6 4.3-.6 6.4l42.6-24.6c8.6-5 19.6-2 24.6 6.6s2 19.6-6.6 24.6L63 418.2c1.8 1.1 3.8 2 5.9 2.7l71.3 25.5 60.7-105.1c5-8.6 16-11.6 24.6-6.6s11.6 16 6.6 24.6l-60.7 105.1 57.8 49c1.7 1.4 3.4 2.7 5.3 3.7l0-49.2c0-9.9 8.1-18 18-18s18 8.1 18 18l0 49.2c1.8-1.1 3.6-2.3 5.3-3.7l57.8-49-60.7-105.1c-5-8.6-2-19.6 6.6-24.6s19.6-2 24.6 6.6l60.7 105.1 71.4-25.5c2.1-.7 4-1.7 5.9-2.7l-42.6-24.6c-8.6-5-11.6-16-6.6-24.6s16-11.6 24.6-6.6L460 387c0-2.1-.2-4.3-.6-6.4l-13.6-74.6-121.3 0c-9.9 0-18-8.1-18-18s8.1-18 18-18l121.3 0 13.6-74.6c.4-2.2 .6-4.3 .6-6.4l-42.6 24.6c-8.6 5-19.6 2-24.6-6.6s-2-19.6 6.6-24.6L442 157.8c-1.8-1.1-3.8-2-5.9-2.7l-71.4-25.5-60.7 105.1c-5 8.6-16 11.6-24.6 6.6s-11.6-16-6.6-24.6l60.7-105.1-57.8-49c-1.7-1.4-3.4-2.7-5.3-3.7z"],
    "skull-crossbones": [504, 540, [128369, 9760], "f714", "M252 234.9c-11.4-11.7-27.4-18.9-45-18.9-34.8 0-63 28.2-63 63s28.2 63 63 63c17.6 0 33.6-7.2 45-18.9 11.4 11.7 27.4 18.9 45 18.9 34.8 0 63-28.2 63-63s-28.2-63-63-63c-17.6 0-33.6 7.2-45 18.9zM207 306a27 27 0 1 1 0-54 27 27 0 1 1 0 54zm117-27a27 27 0 1 1 -54 0 27 27 0 1 1 54 0zM75.5 252.4L30.7 221C-1.9 198.2-9.8 153.3 13 120.7S80.7 80.2 113.3 103l44.8 31.4C185.5 117.7 217.6 108 252 108s66.5 9.7 93.9 26.4L390.7 103c32.6-22.8 77.5-14.9 100.3 17.7s14.9 77.5-17.7 100.3l-44.8 31.4c2.3 11.5 3.5 23.4 3.5 35.6s-1.2 24.1-3.5 35.6L473.3 355c32.6 22.8 40.5 67.7 17.7 100.3S423.3 495.8 390.7 473l-18.4-12.9C361.4 485.9 335.8 504 306 504l-108 0c-29.8 0-55.4-18.1-66.3-43.9L113.3 473C80.7 495.8 35.8 487.9 13 455.3S-1.9 377.8 30.7 355l44.8-31.4C73.2 312.1 72 300.2 72 288s1.2-24.1 3.5-35.6zm-33-111c-11.4 16.3-7.4 38.7 8.8 50.1l35.5 24.8c9.7-22.4 23.9-42.4 41.3-59L92.7 132.5c-16.3-11.4-38.7-7.4-50.1 8.8zM306 468c19.9 0 36-16.1 36-36l0-23.3c0-5.1 2.2-10 6-13.4 29.5-26.4 48-64.7 48-107.3 0-79.5-64.5-144-144-144S108 208.5 108 288c0 42.6 18.5 80.9 48 107.3 3.8 3.4 6 8.3 6 13.4l0 23.4c.1 19.8 16.2 35.9 36 35.9l0-36c0-9.9 8.1-18 18-18s18 8.1 18 18l0 36 36 0 0-36c0-9.9 8.1-18 18-18s18 8.1 18 18l0 36zM86.8 359.7L51.4 384.5c-16.3 11.4-20.2 33.8-8.8 50.1s33.8 20.3 50.1 8.8l33.4-23.3 0-3.6c-16.5-16.1-29.8-35.4-39.2-56.9zM378 420.1l33.4 23.3c16.3 11.4 38.7 7.4 50.1-8.8s7.4-38.7-8.8-50.1l-35.5-24.8c-9.3 21.5-22.7 40.7-39.2 56.9l0 3.6zm39.2-203.8l35.5-24.8c16.3-11.4 20.3-33.8 8.8-50.1s-33.8-20.2-50.1-8.8l-35.5 24.9c17.5 16.6 31.6 36.6 41.3 59z"],
    "ticket": [504, 540, [127903], "f145", "M252 153.4c-18.4 0-34.9 11.2-41.8 28.3l-12.7 31.7-34.1 2.3c-18.4 1.2-34.1 13.5-39.8 31s-.1 36.7 14 48.5l26.3 21.9-8.4 33.1c-4.5 17.8 2.3 36.6 17.2 47.4s34.9 11.5 50.4 1.7l28.9-18.2 28.9 18.2c15.6 9.8 35.5 9.1 50.4-1.7S353 368 348.5 350.2l-8.4-33.1 26.3-21.9c14.1-11.8 19.7-31 14-48.5s-21.5-29.8-39.8-31l-34.1-2.3-12.7-31.7c-6.8-17.1-23.4-28.3-41.8-28.3zm-8.4 41.7c1.4-3.4 4.7-5.7 8.4-5.7s7 2.2 8.4 5.7l16.9 42.3c2.6 6.4 8.6 10.8 15.5 11.3l45.4 3c3.7 .2 6.8 2.7 8 6.2s0 7.3-2.8 9.7l-35 29.1c-5.3 4.4-7.6 11.5-5.9 18.2L313.6 359c.9 3.6-.5 7.3-3.4 9.5s-7 2.3-10.1 .3l-38.5-24.3c-5.9-3.7-13.3-3.7-19.2 0l-38.5 24.3c-3.1 2-7.1 1.8-10.1-.3s-4.3-5.9-3.4-9.5l11.2-44.1c1.7-6.7-.6-13.8-5.9-18.2l-35-29.1c-2.8-2.4-3.9-6.2-2.8-9.7s4.3-6 8-6.2l45.4-3c6.9-.5 12.9-4.8 15.5-11.3l16.9-42.3zM72 90c-39.8 0-72 32.2-72 72 0 10.4 4.5 18.9 9.7 24.9 5.1 5.9 11.3 10.3 16.9 13.3 5.6 3.1 9.4 9 9.4 15.8s-3.8 12.7-9.4 15.8c-5.6 3.1-11.9 7.4-16.9 13.3-5.1 6-9.7 14.4-9.7 24.9l0 36c0 10.4 4.5 18.9 9.7 24.9 5.1 5.9 11.3 10.3 16.9 13.3 5.6 3.1 9.4 9 9.4 15.8s-3.8 12.7-9.4 15.8c-5.6 3.1-11.9 7.4-16.9 13.3-5.1 6-9.7 14.4-9.7 24.9 0 39.8 32.2 72 72 72l360 0c39.8 0 72-32.2 72-72 0-10.4-4.6-18.9-9.7-24.9-5.1-5.9-11.3-10.3-16.9-13.3-5.6-3.1-9.4-9-9.4-15.8s3.8-12.7 9.4-15.8c5.6-3.1 11.9-7.4 16.9-13.3 5.1-6 9.7-14.4 9.7-24.9l0-36c0-10.4-4.6-18.9-9.7-24.9-5.1-5.9-11.3-10.3-16.9-13.3-5.6-3.1-9.4-9-9.4-15.8s3.8-12.7 9.4-15.8c5.6-3.1 11.9-7.4 16.9-13.3 5.1-6 9.7-14.4 9.7-24.9 0-39.8-32.2-72-72-72L72 90zM37 163.4c-.7-.8-1-1.4-1-1.6 .1-19.8 16.2-35.8 36-35.8l360 0c19.8 0 36 16 36 35.8-.1 .2-.3 .8-1 1.6-1.4 1.6-3.7 3.5-6.9 5.2-16.7 9.1-28.1 26.9-28.1 47.4s11.4 38.2 28.1 47.4c3.1 1.7 5.5 3.6 6.9 5.2 .7 .8 1 1.3 1 1.5l0 35.7c-.1 .2-.3 .8-1 1.6-1.4 1.6-3.7 3.5-6.9 5.2-16.7 9.1-28.1 26.9-28.1 47.4s11.4 38.2 28.1 47.4c3.1 1.7 5.5 3.6 6.9 5.2 .7 .8 1 1.3 1 1.5-.1 19.8-16.2 35.9-36 35.9L72 450c-19.8 0-35.9-16.1-36-35.9 .1-.2 .3-.7 1-1.5 1.4-1.6 3.7-3.5 6.9-5.2 16.7-9.1 28.1-26.9 28.1-47.4s-11.4-38.2-28.1-47.4c-2.6-1.4-6.8-3.7-7.9-6.7l0-35.8c1.1-3 5.3-5.3 7.9-6.7 16.7-9.1 28.1-26.9 28.1-47.4s-11.4-38.2-28.1-47.4c-3.1-1.7-5.5-3.6-6.9-5.2z"],
    "wheelchair": [432, 540, [], "f193", "M180 36c-39.8 0-72 32.2-72 72 0 24.1 11.8 45.4 30 58.5-18.3 13.2-30 34.6-30 58.5l0 31.5c-62.1 16-108 72.4-108 139.5 0 79.5 64.5 144 144 144 53.8 0 100.8-29.5 125.5-73.3l3.1 11.2c10.5 38.4 50 61 88.4 50.5s61-50 50.5-88.4l-27-99c-8.6-31.4-37.7-53.1-70.1-53.1 6.1-10.6 9.6-22.9 9.6-36 0-39.8-32.2-72-72-72l-15.8 0c-4.1-5.2-8.9-9.7-14.2-13.5 18.2-13.1 30-34.4 30-58.5 0-39.8-32.2-72-72-72zm36 72a36 36 0 1 1 -72 0 36 36 0 1 1 72 0zM36 396c0-47 30.1-87 72-101.9l0 65.9c0 39.8 32.2 72 72 72l65.9 0C231 473.9 191 504 144 504 84.4 504 36 455.6 36 396zm315.5 97.7c-19.2 5.2-39-6.1-44.2-25.3l-16.1-59.2c-2.1-7.8-9.2-13.3-17.4-13.3L180 396c-19.9 0-36-16.1-36-36l0-135c0-18 13.3-33.3 31.2-35.7 14.7-2 28.8 5.3 36 17.7 3.2 5.6 9.2 9 15.6 9l25.2 0c19.9 0 36 16.1 36 36 0 18.5-14 33.8-32 35.8-7.2 .8-14.7 .2-22 .2-9.9 0-18 8.1-18 18s8.1 18 18 18l81 0c16.2 0 30.5 10.9 34.7 26.5l27 99c5.2 19.2-6.1 39-25.3 44.2z"],
    "bookmark": [360, 540, [128278, 61591], "f02e", "M72 90c-19.9 0-36 16.1-36 36l0 324c0 14.6 8.8 27.7 22.2 33.3s28.9 2.5 39.2-7.8l69.8-69.8c7-7 18.4-7 25.5 0l69.8 69.8c10.3 10.3 25.8 13.4 39.2 7.8S324 464.6 324 450l0-324c0-19.9-16.1-36-36-36L72 90zM0 126C0 86.2 32.2 54 72 54l216 0c39.8 0 72 32.2 72 72l0 324c0 29.1-17.5 55.4-44.4 66.5s-57.9 5-78.5-15.6l-57.1-57.1-57.1 57.1c-20.6 20.6-51.6 26.8-78.5 15.6S0 479.1 0 450L0 126z"],
    "bomb": [504, 540, [128163], "f1e2", "M396 54c-29.8 0-54 24.2-54 54l0 24.2c-28.5-28.5-73.8-33.2-104.1-3.9-10.1-1.5-20.4-2.3-30.9-2.3-114.3 0-207 92.7-207 207s92.7 207 207 207 207-92.7 207-207c0-10.5-.8-20.8-2.3-30.9 29.4-30.3 24.6-75.6-3.9-104.1l24.2 0c29.8 0 54-24.2 54-54l0-36c0-29.8-24.2-54-54-54l-36 0zm-18 54c0-9.9 8.1-18 18-18l36 0c9.9 0 18 8.1 18 18l0 36c0 9.9-8.1 18-18 18l-36 0c-9.9 0-18-8.1-18-18l0-36zm-95.9 36.5c11.1-1.8 22.8 1.5 31.4 10.1l72 72c14.1 14.1 14.1 36.9 0 50.9-6.2 6.2-12.7 12.3-10.7 22 2.1 10.8 3.3 22 3.3 33.5 0 94.4-76.6 171-171 171S36 427.4 36 333 112.6 162 207 162c11.5 0 22.7 1.1 33.5 3.3 9.7 1.9 15.8-4.5 22-10.7 5.5-5.5 12.4-8.9 19.5-10.1z"],
    "arrow-right": [504, 540, [8594], "f061", "M320.9 75.1C292.8 47 247.2 47 219.1 75.1s-28.1 73.7 0 101.8L258.2 216 72 216c-39.8 0-72 32.2-72 72s32.2 72 72 72l186.2 0-39.1 39.1c-28.1 28.1-28.1 73.7 0 101.8s73.7 28.1 101.8 0l162-162c28.1-28.1 28.1-73.7 0-101.8l-162-162zm-76.4 25.5c14.1-14.1 36.9-14.1 50.9 0l162 162c14.1 14.1 14.1 36.9 0 50.9l-162 162c-14.1 14.1-36.9 14.1-50.9 0s-14.1-36.9 0-50.9l69.8-69.8c5.1-5.1 6.7-12.9 3.9-19.6S308.9 324 301.6 324L72 324c-19.9 0-36-16.1-36-36s16.1-36 36-36l229.6 0c7.3 0 13.8-4.4 16.6-11.1s1.2-14.5-3.9-19.6l-69.8-69.8c-14.1-14.1-14.1-36.9 0-50.9z"],
    "battery-bolt": [576, 540, [], "f376", "M334.3 59.8C299.7 45 263.5 60 243.5 90L108 90c-39.8 0-72 32.2-72 72l0 252c0 39.8 32.2 72 72 72l99.6 0c7.6 13.1 19.3 23.9 34.1 30.2 34.6 14.8 70.8-.2 90.8-30.2L450 486c39.8 0 72-32.2 72-72l0-20.3c31.1-8 54-36.2 54-69.7l0-72c0-33.6-22.9-61.7-54-69.7l0-20.3c0-39.8-32.2-72-72-72l-81.6 0c-7.6-13.1-19.3-23.9-34.1-30.2zM378 126l72 0c19.9 0 36 16.1 36 36l0 36c0 9.9 8.1 18 18 18 19.9 0 36 16.1 36 36l0 72c0 19.9-16.1 36-36 36-9.9 0-18 8.1-18 18l0 36c0 19.9-16.1 36-36 36l-93.5 0 81.4-122.1c14.7-22.1 16.1-50.5 3.6-73.9s-36.9-38-63.5-38l-18.2 0 16.5-74.4c1.2-5.2 1.7-10.5 1.7-15.6zM198 450l-90 0c-19.9 0-36-16.1-36-36l0-252c0-19.9 16.1-36 36-36l111.5 0-81.4 122.1c-14.7 22.1-16.1 50.5-3.6 73.9s36.9 38 63.5 38l18.2 0-16.5 74.4c-1.2 5.2-1.7 10.4-1.7 15.6zM276 106c9.6-14.4 28.1-19.9 44.1-13.1s24.8 24 21 40.9l-21.4 96.3c-2.5 11.1 6.2 21.9 17.6 21.9l40.7 0c13.3 0 25.5 7.3 31.7 19s5.6 25.9-1.8 37L300 470c-9.6 14.4-28.1 19.9-44.1 13.1s-24.8-24-21-40.9l21.4-96.3c2.5-11.1-6.2-21.9-17.6-21.9L198 324c-13.3 0-25.5-7.3-31.7-19s-5.6-25.9 1.8-37L276 106z"],
    "xmark": [432, 540, [128473, 10005, 10006, 10060, 215, "close", "multiply", "remove", "times"], "f00d", "M97.5 118.5c-14.1-14.1-36.9-14.1-50.9 0s-14.1 36.9 0 50.9L152.4 275.3c6.9 6.9 6.9 18.5 0 25.5L46.5 406.5c-14.1 14.1-14.1 36.9 0 50.9s36.9 14.1 50.9 0L203.3 351.6c7-7 18.4-7 25.5 0L334.5 457.5c14.1 14.1 36.9 14.1 50.9 0s14.1-36.9 0-50.9L279.6 300.7c-7-7-7-18.4 0-25.5L385.5 169.5c14.1-14.1 14.1-36.9 0-50.9s-36.9-14.1-50.9 0L228.7 224.4c-7 7-18.4 7-25.5 0L97.5 118.5zM21.1 93.1C49.2 65 94.8 65 122.9 93.1l93.1 93.1 93.1-93.1c28.1-28.1 73.7-28.1 101.8 0s28.1 73.7 0 101.8l-93.1 93.1 93.1 93.1c28.1 28.1 28.1 73.7 0 101.8s-73.7 28.1-101.8 0l-93.1-93.1-93.1 93.1C94.8 511 49.2 511 21.1 482.9s-28.1-73.7 0-101.8l93.1-93.1-93.1-93.1C-7 166.8-7 121.2 21.1 93.1z"],
    "lock-open": [468, 540, [], "f3c1", "M279 387c9.9 0 18-8.1 18-18s-8.1-18-18-18l-90 0c-9.9 0-18 8.1-18 18s8.1 18 18 18l90 0zM342 36c-69.6 0-126 56.4-126 126l0 54-90 0c-39.8 0-72 32.2-72 72l0 162c0 39.8 32.2 72 72 72l216 0c39.8 0 72-32.2 72-72l0-162c0-21.7-9.6-41.1-24.7-54.3 2.2 .2 4.5 .3 6.7 .3 39.8 0 72-32.2 72-72 0-69.6-56.4-126-126-126zm18 126c0-9.9-8.1-18-18-18s-18 8.1-18 18l0 54-72 0 0-54c0-49.7 40.3-90 90-90s90 40.3 90 90c0 19.9-16.1 36-36 36s-36-16.1-36-36zM126 252l216 0c19.9 0 36 16.1 36 36l0 162c0 19.9-16.1 36-36 36l-216 0c-19.9 0-36-16.1-36-36l0-162c0-19.9 16.1-36 36-36z"],
    "droplet": [360, 540, [128167, "tint"], "f043", "M126 342c0-9.9-8.1-18-18-18s-18 8.1-18 18c0 49.7 40.3 90 90 90 9.9 0 18-8.1 18-18s-8.1-18-18-18c-29.8 0-54-24.2-54-54zM180 36c-25.9 0-50.8 12.5-66.2 34.5-8.8 12.7-36 52.7-61.2 101-23.5 45-52.6 110.6-52.6 170.4 0 99.4 80.6 180 180 180s180-80.6 180-180c0-59.8-29.1-125.4-52.6-170.4-25.2-48.4-52.4-88.4-61.2-101-15.4-22.1-40.3-34.5-66.2-34.5zM143.4 91.1C151.8 78.9 165.6 72 180 72s28.2 6.9 36.6 19.1c8.4 12.1 34.6 50.7 58.8 97.1 23.3 44.7 48.5 103.4 48.5 153.8 0 79.5-64.5 144-144 144S36 421.5 36 342c0-50.3 25.2-109 48.5-153.8 24.2-46.4 50.4-85 58.8-97.1z"],
    "shop": [540, 540, ["store-alt"], "f54f", "M306 414c0-19.9-16.1-36-36-36s-36 16.1-36 36l0 18c0 39.8-32.2 72-72 72l-36 0c-39.8 0-72-32.2-72-72l0-139.7c-32.3-9.1-54-43.9-54-76.3-.1-9.7 1.6-18.8 5.2-28.4l22.6-60.3C42.3 88.6 79.2 63 120.5 63l299.1 0c41.3 0 78.2 25.6 92.7 64.2l22.6 60.3c3.6 9.7 5.3 18.7 5.2 28.4 0 32.4-21.7 67.2-54 76.3L486 432c0 39.8-32.2 72-72 72l-36 0c-39.8 0-72-32.2-72-72l0-18zm27-153c24.5 0 45-20.6 45-45 0-9.9 8.1-18 18-18s18 8.1 18 18c0 24.4 20.5 45 45 45 30.5 0 53-31.8 42.1-60.8l-22.6-60.3c-9.2-24.6-32.7-40.9-59-40.9L120.5 99c-26.3 0-49.8 16.3-59 40.9L38.9 200.2c-10.9 29.1 11.6 60.8 42.1 60.8 24.5 0 45-20.6 45-45 0-9.9 8.1-18 18-18s18 8.1 18 18c0 24.4 20.5 45 45 45 24.9 0 45-20.1 45-45 0-9.9 8.1-18 18-18s18 8.1 18 18c0 24.9 20.1 45 45 45zm63 5.9c-14.8 18.3-37.5 30.1-63 30.1s-48.1-11.7-63-30.1c-14.8 18.4-37.6 30.1-63 30.1s-48.1-11.7-63-30.1c-13.5 16.7-33 27.2-54 29.6L90 432c0 19.9 16.1 36 36 36l36 0c19.9 0 36-16.1 36-36l0-18c0-39.8 32.2-72 72-72s72 32.2 72 72l0 18c0 19.9 16.1 36 36 36l36 0c19.9 0 36-16.1 36-36l0-135.5c-21-2.4-40.6-12.9-54-29.6z"],
    "film": [504, 540, [127902, 62368, "film-alt", "film-simple"], "f008", "M72 486c-39.8 0-72-32.2-72-72L0 162c0-39.8 32.2-72 72-72l360 0c39.8 0 72 32.2 72 72l0 252c0 39.8-32.2 72-72 72L72 486zM36 414c0 19.9 16.1 36 36 36l54 0 0-72-90 0 0 36zm306 36l0-324-180 0 0 324 180 0zm36 0l54 0c19.9 0 36-16.1 36-36l0-36-90 0 0 72zm90-108l0-108-90 0 0 108 90 0zm0-144l0-36c0-19.9-16.1-36-36-36l-54 0 0 72 90 0zm-342 0l0-72-54 0c-19.9 0-36 16.1-36 36l0 36 90 0zm0 36l-90 0 0 108 90 0 0-108z"],
    "comments": [540, 540, [128490, 61670], "f086", "M200.7 423.3l-45.1 20.3c-26.1 11.7-56.6 6.9-77.8-12.2-24.6-22.2-27.5-53.9-17.5-83.7-36.4-32.1-60.2-78.2-60.2-131.7 0-104.9 90.3-180 189-180 67.4 0 130.3 34.7 163.9 90 98 1 187.1 75.8 187.1 180 0 53.6-23.8 99.7-60.2 131.7 9.9 29.8 7.1 61.4-17.5 83.7-21.2 19.2-51.8 24-77.8 12.2L278.3 485.9c-31.5-14.2-57.9-35.9-77.6-62.6zM36 216c0 46.1 22.1 85.4 56.1 111.4 13.1 10 3.8 26.9-.3 39.2-4.5 13.6-.6 28.5 10 38.1s25.9 12 38.9 6.1l41.1-18.5C169 365.9 162 336.5 162 306 162 215.2 229.6 146.7 311.8 130 283.4 94.4 238 72 189 72 107.1 72 36 133.9 36 216zm162 90c0 63.5 37.2 121 95.1 147.1l106.1 47.8c13 5.9 28.3 3.5 38.9-6.1s14.5-24.5 10-38.1l-6.4-19.2c-2.4-7.3 0-15.3 6.1-20 34-26 56.1-65.3 56.1-111.4 0-82.1-71.1-144-153-144S198 223.9 198 306z"],
    "moon": [504, 540, [127769, 9214], "f186", "M197.3 42c29-6.4 59.1 5.7 75.5 30.4s16 57.1-1.1 81.4c-12.4 17.6-19.7 38.9-19.7 62.2 0 59.6 48.4 108 108 108 8.2 0 16-.9 23.5-2.6 29-6.4 59.1 5.7 75.5 30.4s16 57.1-1.1 81.4C412.4 497.7 337.2 540 252 540 112.8 540 0 427.2 0 288 0 167.5 84.5 67 197.3 42zm45.6 50.4c-8.2-12.4-23.2-18.4-37.8-15.2-96.7 21.4-169.1 107.7-169.1 210.9 0 119.3 96.7 216 216 216 73 0 137.5-36.2 176.5-91.5 8.6-12.1 8.8-28.3 .6-40.7s-23.2-18.4-37.8-15.2c-10.1 2.2-20.5 3.4-31.3 3.4-79.5 0-144-64.5-144-144 0-30.9 9.7-59.5 26.3-83 8.6-12.1 8.8-28.3 .6-40.7z"],
    "plane": [504, 540, [], "f072", "M252 72c-18.5 0-34 14-35.8 32.4l-9.1 91.5c-.6 6.4-4.7 12-10.5 14.6L57.2 273.2c-16.7 7.5-25.1 26.4-19.5 43.8s23.4 27.9 41.3 24.3l102.7-20.5c4.9-1 10.1 .1 14.2 3.1s6.7 7.5 7.3 12.5l7.8 70.6c1 9-4.8 17.3-13.5 19.5l-26.2 6.6c-17.6 4.4-29.2 21.3-27 39.3S161.8 504 180 504l144 0c18.2 0 33.5-13.6 35.7-31.6s-9.4-34.9-27-39.3l-26.2-6.6c-8.7-2.2-14.5-10.5-13.5-19.5l7.8-70.6c.6-5 3.2-9.6 7.3-12.5s9.2-4.1 14.2-3.1L425 341.3c18 3.6 35.8-6.9 41.3-24.3s-2.8-36.3-19.5-43.8L307.5 210.5c-5.9-2.6-9.9-8.2-10.5-14.6l-9.1-91.5C286 86 270.5 72 252 72zm-71.6 28.8C184.1 64 215 36 252 36s68 28 71.6 64.8l8.1 81.1 129.8 58.4c33.4 15 50.2 52.7 39 87.6s-46.8 55.8-82.7 48.6l-83.4-16.7-3.9 35.5 11 2.7c35.3 8.8 58.4 42.6 54 78.6S360.4 540 324 540l-144 0c-36.4 0-67-27.1-71.5-63.2s18.7-69.8 54-78.6l11-2.7-3.9-35.5-83.4 16.7C50.2 383.8 14.6 362.9 3.5 328s5.6-72.6 39-87.6l129.8-58.4 8.1-81.1z"],
    "images": [468, 540, [], "f302", "M198 171a27 27 0 1 1 54 0 27 27 0 1 1 -54 0zm-90-45c0-39.8 32.2-72 72-72l216 0c39.8 0 72 32.2 72 72l0 216c0 39.8-32.2 72-72 72l-36 0 0 36c0 39.8-32.2 72-72 72L72 522c-39.8 0-72-32.2-72-72L0 234c0-39.8 32.2-72 72-72l36 0 0-36zm0 72l-36 0c-19.9 0-36 16.1-36 36l0 216c0 19.9 16.1 36 36 36l216 0c19.9 0 36-16.1 36-36l0-36-144 0c-39.8 0-72-32.2-72-72l0-144zM396 90L180 90c-19.9 0-36 16.1-36 36l0 217.5 86.2-86.2c26.9-26.9 70.5-26.9 97.5 0 12.9 12.9 33.7 12.9 46.5 0l57.7-57.7 0-73.5c0-19.9-16.1-36-36-36zM164.1 374.3c4.8 2.4 10.2 3.7 15.9 3.7l216 0c19.9 0 36-16.1 36-36l0-91.5-32.3 32.3c-26.9 26.9-70.5 26.9-97.5 0-12.9-12.9-33.7-12.9-46.5 0l-91.6 91.6z"],
    "bag-shopping": [432, 540, ["shopping-bag"], "f290", "M216.5 36c-49.7 0-90 40.3-90 90l0 18-18 0c-35.5 0-65.8 25.9-71.2 61.1l-36 234C-5.3 482 29 522 72.5 522l288 0c43.5 0 77.8-40 71.2-82.9l-36-234C390.2 169.9 360 144 324.5 144l-18 0 0-18c0-49.7-40.3-90-90-90zm54 108l-108 0 0-18c0-29.8 24.2-54 54-54s54 24.2 54 54l0 18zm-162 36l216 0c17.8 0 32.9 13 35.6 30.5l36 234c3.3 21.5-13.8 41.5-35.6 41.5l-288 0c-21.7 0-38.9-20-35.6-41.5l36-234C75.6 193 90.7 180 108.5 180z"],
    "phone": [468, 540, [128222, 128379], "f095", "M86.1 66.1c28.6-19 66.6-15.3 90.8 9l45 45c28.1 28.1 28.1 73.7 0 101.8l-48.7 48.7c18.8 32.3 45.8 59.3 78.2 78.2l48.7-48.7c28.1-28.1 73.7-28.1 101.8 0l45 45c24.3 24.3 28 62.3 9 90.9l-35.5 53.2c-3.7 5.7-8.1 10.8-13.2 15.2-12.6 11-29.2 17.7-47.3 17.7-198.8 0-360-161.2-360-360 0-25.4 13.1-47.6 32.9-60.4L86.1 66.1zm65.4 34.5c-12.1-12.1-31.1-14-45.4-4.5L52.5 131.7c-10 6.4-16.5 17.6-16.5 30.3 0 178.9 145.1 324 324 324 12.3 0 23.8-6.5 30.4-16.7L426 416c9.5-14.3 7.6-33.3-4.5-45.4l-45-45c-14.1-14.1-36.9-14.1-50.9 0l-58.2 58.2c-5.5 5.5-13.9 6.8-20.8 3.3-48.1-24.3-87.3-63.5-111.6-111.6-3.5-6.9-2.2-15.3 3.3-20.8l58.2-58.2c14.1-14.1 14.1-36.9 0-50.9l-45-45z"],
    "leaf": [468, 540, [], "f06c", "M174 82.6c60.7-13.9 142.7-28.6 222-28.6 39.8 0 72 32.2 72 72 0 79.4-14.6 161.4-28.6 222-22.2 96.5-109.3 156-201.2 156-33.8 0-66.8-6.4-97.3-21.1l-18 18C94.8 529 49.2 529 21.1 500.9 7 486.9 0 468.4 0 450 0 425.8 12.4 407.8 28.7 391.4 21.8 370.2 18 347.5 18 324l0-40.2c0-91.9 59.5-179 156-201.2zM432 126c0-3.2-.4-6.4-1.2-9.3L313.5 234 424 234c4.8-35.1 8-72 8-108zM288 208.5L405.3 91.2c-3-.8-6.1-1.2-9.3-1.2-36 0-72.9 3.2-108 8l0 110.5zm-36 36l0-141c-24.1 4.1-48.2 8.8-72 14.6l0 198.4 72-72zM205.5 342l198.4 0c5.8-23.8 10.4-47.9 14.6-72l-141 0-72 72zm-36 36l-30.7 30.7c-7 7-18.4 7-25.5 0s-7-18.4 0-25.5l30.7-30.7 0-221c-58.4 30.1-90 92.1-90 156.4 0 31.9 8.3 61.8 22.8 87.8 3.9 7 2.7 15.8-3 21.5L46.5 424.5c-14.1 14.1-14.1 36.9 0 50.9s36.9 14.1 50.9 0l27.3-27.3c5.7-5.7 14.5-6.9 21.5-3 28.3 15.8 59.7 22.8 92 22.8 63.7 0 123.3-33.9 152.2-90l-221 0z"],
    "universal-access": [432, 540, [], "f29a", "M126 126c0-49.7 40.3-90 90-90s90 40.3 90 90c0 12.2-2.4 23.8-6.8 34.4l38-12.7c37.7-12.6 78.5 7.8 91.1 45.5s-7.8 78.5-45.5 91.1L334 300.6 358.9 437.1c7.1 39.1-18.8 76.6-58 83.7-43.5 7.9-77.5-23.6-84.9-64.3-7.4 40.8-41.3 72.3-84.9 64.3-39.1-7.1-65.1-44.6-58-83.7L98 300.6 49.3 284.3C11.5 271.7-8.9 231 3.7 193.2s53.3-58.1 91.1-45.5l38 12.7c-4.4-10.6-6.8-22.2-6.8-34.4zm11.6 359.4c19.6 3.6 38.3-9.4 41.9-29l18.9-103.8c1.6-8.6 9-14.8 17.7-14.8s16.2 6.2 17.7 14.8l18.9 103.8c3.6 19.6 22.3 32.5 41.9 29s32.5-22.3 29-41.9L295.8 291.6c-1.6-8.8 3.5-17.5 12-20.3l63.6-21.2c18.9-6.3 29.1-26.7 22.8-45.5s-26.7-29.1-45.5-22.8l-85.8 28.6c-11 3.7-22.5 5.5-34.2 5.5l-25.3 0c-11.6 0-23.1-1.9-34.2-5.5L83.4 181.8c-18.9-6.3-39.2 3.9-45.5 22.8s3.9 39.2 22.8 45.5l63.6 21.2c8.5 2.8 13.6 11.5 12 20.3L108.6 443.6c-3.6 19.6 9.4 38.3 29 41.9zM216 72a54 54 0 1 0 0 108 54 54 0 1 0 0-108z"],
    "hourglass": [360, 540, [9203, 62032, "hourglass-empty"], "f254", "M131.7 173.1c2.8-6.7 9.4-11.1 16.6-11.1l63.3 0c7.3 0 13.8 4.4 16.6 11.1s1.2 14.5-3.9 19.6l-31.6 31.6c-3.4 3.4-8 5.3-12.7 5.3s-9.4-1.9-12.7-5.3l-31.6-31.6c-5.1-5.1-6.7-12.9-3.9-19.6zM180 346.4c4.8 0 9.4 1.9 12.7 5.3l31.6 31.6c5.1 5.1 6.7 12.9 3.9 19.6S218.9 414 211.6 414l-63.3 0c-7.3 0-13.8-4.4-16.6-11.1s-1.2-14.5 3.9-19.6l31.6-31.6c3.4-3.4 8-5.3 12.7-5.3zM0 126C0 86.2 32.2 54 72 54l216 0c39.8 0 72 32.2 72 72 0 53.7-21.3 105.1-59.3 143.1l-18.9 18.9 18.9 18.9c38 38 59.3 89.4 59.3 143.1 0 39.8-32.2 72-72 72L72 522c-39.8 0-72-32.5-72-72.1 0-53.6 21.3-105.1 59.3-143L78.2 288 59.3 269.1C21.3 231.1 0 179.7 0 126zM72 90c-19.9 0-36 16.1-36 36 0 44.1 17.5 86.4 48.7 117.6l31.6 31.6c6.9 6.9 6.9 18.5 0 25.5L84.7 332.4C53.5 363.5 36 405.8 36 450 36 470.1 52.2 486 72 486l216 0c19.9 0 36-16.1 36-36 0-44.1-17.5-86.4-48.7-117.6l-31.6-31.6c-7-7-7-18.4 0-25.5l31.6-31.6c31.2-31.2 48.7-73.5 48.7-117.6 0-19.9-16.1-36-36-36L72 90z"],
    "fish": [540, 540, [128031], "f578", "M351 180a27 27 0 1 0 0-54 27 27 0 1 0 0 54zM425.2 50.9c-23-4.1-61.8-8.8-104.6-3.5-42.9 5.3-95.1 21.4-137.5 63.7-49.7 49.7-70.4 120.6-75.6 189.1l-45.6 6.5C30.6 311.2 6 335.4 .9 366.5s10.7 61.8 38.9 75.9l50.5 25.3 25.3 50.5c14.1 28.2 44.8 43.9 75.9 38.9s55.3-29.7 59.7-60.9l6.5-45.6c68.5-5.3 139.4-25.9 189.1-75.7 42.3-42.3 58.4-94.6 63.7-137.5 5.3-42.8 .6-81.6-3.5-104.6-7.5-41.9-40-74.5-82-82zM325 83.1c37.9-4.7 72.8-.6 93.8 3.2 27.1 4.8 48 25.8 52.9 52.9 3.8 21.1 7.9 55.9 3.2 93.8-4.7 38-18.6 81.6-53.4 116.5-45 45-109.3 59.6-156.9 64.4-8.1 .8-15.9 1.4-23.4 1.7-8.6 .4-15.8 6.9-17 15.4l-8.6 60.1c-2.2 15.6-14.3 27.9-29.9 30.4s-30.9-5.4-38-19.4l-28-55.9c-1.7-3.5-4.6-6.3-8-8.1L55.9 410.2c-14.1-7-22-22.4-19.4-38s14.9-27.6 30.4-29.9l60.1-8.6c8.6-1.2 15-8.4 15.4-17 .3-7.4 .9-15.3 1.7-23.4 4.8-47.5 19.4-111.9 64.4-156.9 34.8-34.8 78.5-48.7 116.5-53.4z"],
    "list": [504, 540, ["list-squares"], "f03a", "M180 90c-21.5 0-40.8 9.4-54 24.4-13.2-14.9-32.5-24.4-54-24.4-39.8 0-72 32.2-72 72 0 27.1 15 50.7 37.1 63-22.1 12.3-37.1 35.9-37.1 63s15 50.7 37.1 63c-22.1 12.3-37.1 35.9-37.1 63 0 39.8 32.2 72 72 72 21.5 0 40.8-9.4 54-24.4 13.2 14.9 32.5 24.4 54 24.4l252 0c39.8 0 72-32.2 72-72 0-27.1-15-50.7-37.1-63 22.1-12.3 37.1-35.9 37.1-63s-15-50.7-37.1-63c22.1-12.3 37.1-35.9 37.1-63 0-39.8-32.2-72-72-72L180 90zM144 414c0-19.9 16.1-36 36-36l252 0c19.9 0 36 16.1 36 36s-16.1 36-36 36l-252 0c-19.9 0-36-16.1-36-36zM72 198a36 36 0 1 1 0-72 36 36 0 1 1 0 72zm72 90c0-19.9 16.1-36 36-36l252 0c19.9 0 36 16.1 36 36s-16.1 36-36 36l-252 0c-19.9 0-36-16.1-36-36zM36 288a36 36 0 1 1 72 0 36 36 0 1 1 -72 0zM144 162c0-19.9 16.1-36 36-36l252 0c19.9 0 36 16.1 36 36s-16.1 36-36 36l-252 0c-19.9 0-36-16.1-36-36zM108 414a36 36 0 1 1 -72 0 36 36 0 1 1 72 0z"],
    "headphones": [468, 540, [127911, 62863, "headphones-alt", "headphones-simple"], "f025", "M0 270C0 140.8 104.8 36 234 36S468 140.8 468 270l0 108c0 69.6-56.4 126-126 126-39.8 0-72-32.2-72-72l0-108c0-33.1 22.3-60.9 52.7-69.4-7.3-42.4-44.2-74.6-88.7-74.6s-81.4 32.2-88.7 74.6c30.4 8.4 52.7 36.3 52.7 69.4l0 108c0 39.8-32.2 72-72 72-69.6 0-126-56.4-126-126L0 270zm342 18c-19.9 0-36 16.1-36 36l0 108c0 19.9 16.1 36 36 36 49.7 0 90-40.3 90-90s-40.3-90-90-90zm90 1.8l0-19.8c0-109.4-88.6-198-198-198S36 160.6 36 270l0 19.8c19.2-19.5 44.6-32.9 73.1-36.7 8.2-61.6 61-109.1 124.9-109.1s116.6 47.5 124.9 109.1c28.5 3.8 54 17.1 73.1 36.7zM126 468c19.9 0 36-16.1 36-36l0-108c0-19.9-16.1-36-36-36-49.7 0-90 40.3-90 90s40.3 90 90 90z"],
    "bus": [504, 540, [128653], "f207", "M162 351a27 27 0 1 1 54 0 27 27 0 1 1 -54 0zm153 27a27 27 0 1 0 0-54 27 27 0 1 0 0 54zM144 54c-39.8 0-72 32.2-72 72l0 18c-39.8 0-72 32.2-72 72l0 54c0 39.8 32.2 72 72 72l0 108c0 39.8 32.2 72 72 72s72-32.2 72-72l72 0c0 39.8 32.2 72 72 72s72-32.2 72-72l0-108c39.8 0 72-32.2 72-72l0-54c0-39.8-32.2-72-72-72l0-18c0-39.8-32.2-72-72-72L144 54zm252 72l0 126-288 0 0-126c0-19.9 16.1-36 36-36l216 0c19.9 0 36 16.1 36 36zm36 54c19.9 0 36 16.1 36 36l0 54c0 19.9-16.1 36-36 36l0-126zM396 288l0 126-288 0 0-126 288 0zM36 216c0-19.9 16.1-36 36-36l0 126c-19.9 0-36-16.1-36-36l0-54zM360 486c-19.9 0-36-16.1-36-36l72 0c0 19.9-16.1 36-36 36zM108 450l72 0c0 19.9-16.1 36-36 36s-36-16.1-36-36z"],
    "quote-left": [504, 540, [8220, "quote-left-alt"], "f10d", "M391 93.7c37.7-12.6 78.7 7.7 91.3 45.5 12.4 37.3-7.3 77.5-44.2 90.6-.5 .2-2.3 1-4.9 2.4 42.2 22.8 70.8 67.4 70.8 118.8 0 74.6-60.4 135-135 135-50 0-93.7-27.2-117-67.6-23.3 40.4-67 67.6-117 67.6-74.6 0-135-60.4-135-135l0-9c0-92.3 35.5-155.3 75.1-194.9 19.1-19.1 38.3-31.9 53.1-40.2 8.8-4.9 18.5-9.7 28.9-13.2 37.7-12.6 78.7 7.7 91.3 45.5 12.4 37.3-7.3 77.5-44.2 90.6-.5 .2-2.3 1-4.9 2.4 16.8 9.1 31.4 21.6 43 36.7 12.7-53.8 38.8-93.7 66.9-121.9 19.1-19.1 38.3-31.9 53.1-40.2 8.8-4.9 18.5-9.7 28.9-13.2zM270 351c0 54.7 44.3 99 99 99s99-44.3 99-99c0-46.5-32.1-85.5-75.3-96.1-6.3-1.5-11.2-6.3-13-12.5s-.1-12.9 4.4-17.5c11.4-11.8 26-23.3 41.8-28.8 18.5-6.5 28.5-26.7 22.3-45.4-6.3-18.8-26.7-29-45.6-22.7-7.5 2.5-15.1 6.2-22.9 10.5-12.4 6.9-28.8 17.8-45.1 34.1-33.3 33.3-64.5 87.3-64.5 169.5zm-36 0c0-46.5-32.1-85.5-75.3-96.1-6.3-1.5-11.2-6.3-13-12.5s-.1-12.9 4.4-17.5c11.4-11.8 26-23.3 41.8-28.8 18.5-6.5 28.5-26.7 22.3-45.4-6.3-18.8-26.7-29-45.6-22.7-7.5 2.5-15.1 6.2-22.9 10.5-12.4 6.9-28.8 17.8-45.1 34.1-33.3 33.3-64.5 87.3-64.5 169.5l0 9c0 54.7 44.3 99 99 99s99-44.3 99-99z"],
    "martini-glass": [432, 540, [127864, "glass-martini-alt"], "f57b", "M5.5 116.4C16.6 89.5 42.9 72 72 72l288 0c29.1 0 55.4 17.5 66.5 44.4s5 57.9-15.6 78.5l-122.9 122.9 0 60.2 18 0c39.8 0 72 32.2 72 72s-32.2 72-72 72l-180 0c-39.8 0-72-32.2-72-72s32.2-72 72-72l18 0 0-60.2-122.9-122.9C.5 174.3-5.7 143.4 5.5 116.4zM72 108c-14.6 0-27.7 8.8-33.3 22.2s-2.5 28.9 7.8 39.2L174.7 297.6c3.4 3.4 5.3 8 5.3 12.7l0 85.6c0 9.9-8.1 18-18 18l-36 0c-19.9 0-36 16.1-36 36s16.1 36 36 36l180 0c19.9 0 36-16.1 36-36s-16.1-36-36-36l-36 0c-9.9 0-18-8.1-18-18l0-85.6c0-4.8 1.9-9.4 5.3-12.7L385.5 169.5c10.3-10.3 13.4-25.8 7.8-39.2S374.6 108 360 108L72 108z"],
    "rectangle-wide": [576, 540, [], "f2fc", "M72 468c-39.8 0-72-32.2-72-72L0 180c0-39.8 32.2-72 72-72l432 0c39.8 0 72 32.2 72 72l0 216c0 39.8-32.2 72-72 72L72 468zM36 396c0 19.9 16.1 36 36 36l432 0c19.9 0 36-16.1 36-36l0-216c0-19.9-16.1-36-36-36L72 144c-19.9 0-36 16.1-36 36l0 216z"],
    "angle-down": [432, 540, [8964], "f107", "M165.6 392.9c28.1 28.1 73.7 28.1 101.8 0l144-144c28.1-28.1 28.1-73.7 0-101.8s-73.7-28.1-101.8 0l-93.1 93.1-93.1-93.1C95.3 119 49.7 119 21.6 147.1s-28.1 73.7 0 101.8l144 144zM242 367.5c-14.1 14.1-36.9 14.1-50.9 0L47 223.5C33 209.4 33 186.6 47 172.5s36.9-14.1 50.9 0L203.8 278.4c3.4 3.4 8 5.3 12.7 5.3s9.4-1.9 12.7-5.3L335 172.5c14.1-14.1 36.9-14.1 50.9 0s14.1 36.9 0 50.9l-144 144z"],
    "chart-pie": [504, 540, ["pie-chart"], "f200", "M234 72.7c-110.9 9.1-198 102-198 215.3 0 119.3 96.7 216 216 216 53.2 0 101.8-19.2 139.5-51.1L255.1 316.5C241.6 303 234 284.7 234 265.6l0-192.9zm36 0l0 192.9c0 9.5 3.8 18.7 10.5 25.5L416.9 427.5C448.8 389.8 468 341.2 468 288 468 174.8 380.9 81.9 270 72.7zM504 288a252 252 0 1 1 -504 0 252 252 0 1 1 504 0z"],
    "inbox": [432, 540, [], "f01c", "M72 72C32.2 72 0 104.2 0 144L0 432c0 39.8 32.2 72 72 72l288 0c39.8 0 72-32.2 72-72l0-288c0-39.8-32.2-72-72-72L72 72zM36 144c0-19.9 16.1-36 36-36l288 0c19.9 0 36 16.1 36 36l0 126-90 0c-19.9 0-36 16.1-36 36 0 29.8-24.2 54-54 54s-54-24.2-54-54c0-19.9-16.1-36-36-36l-90 0 0-126zm0 162l90 0c0 49.7 40.3 90 90 90s90-40.3 90-90l90 0 0 126c0 19.9-16.1 36-36 36L72 468c-19.9 0-36-16.1-36-36l0-126z"],
    "credit-card": [504, 540, [128179, 62083, "credit-card-alt"], "f09d", "M288 324c-9.9 0-18 8.1-18 18s8.1 18 18 18l90 0c9.9 0 18-8.1 18-18s-8.1-18-18-18l-90 0zM72 90C32.2 90 0 122.2 0 162L0 414c0 39.8 32.2 72 72 72l360 0c39.8 0 72-32.2 72-72l0-252c0-39.8-32.2-72-72-72L72 90zM468 198l-432 0 0-36c0-19.9 16.1-36 36-36l360 0c19.9 0 36 16.1 36 36l0 36zM36 234l432 0 0 180c0 19.9-16.1 36-36 36L72 450c-19.9 0-36-16.1-36-36l0-180z"],
    "wand-magic-sparkles": [576, 540, ["magic-wand-sparkles"], "e2ca", "M482.9 75.1C454.8 47 409.2 47 381.1 75.1l-306 306C47 409.2 47 454.8 75.1 482.9l18 18c28.1 28.1 73.7 28.1 101.8 0l306-306c28.1-28.2 28.1-73.7 0-101.8l-18-18zM100.5 457.5c-14.1-14.1-14.1-36.9 0-50.9l221.3-221.3 68.9 68.9-221.3 221.3c-14.1 14.1-36.9 14.1-50.9 0l-18-18zm374.9-288l-59.3 59.3-68.9-68.9 59.3-59.3c14.1-14.1 36.9-14.1 50.9 0l18 18c14.1 14.1 14.1 36.9 0 50.9zM216 144c0 10.5-4.2 20.6-11.6 28.1l-32.3 32.3c-7.5 7.5-17.6 11.6-28.1 11.6s-20.6-4.2-28.1-11.6L83.6 172.1C76.2 164.6 72 154.5 72 144s4.2-20.6 11.6-28.1l32.3-32.3C123.4 76.2 133.5 72 144 72s20.6 4.2 28.1 11.6l32.3 32.3c7.5 7.5 11.6 17.6 11.6 28.1zm-106.9 2.6l32.3 32.3c1.4 1.4 3.9 1.4 5.3 0l32.3-32.3c1.4-1.4 1.4-3.9 0-5.3l-32.3-32.3c-1.4-1.4-3.9-1.4-5.3 0l-32.3 32.3c-1.4 1.4-1.4 3.9 0 5.3zM576 360c0 10.5-4.2 20.6-11.6 28.1l-32.3 32.3c-7.5 7.5-17.6 11.6-28.1 11.6s-20.6-4.2-28.1-11.6l-32.3-32.3c-7.5-7.5-11.6-17.6-11.6-28.1s4.2-20.6 11.6-28.1l32.3-32.3c7.5-7.5 17.6-11.6 28.1-11.6s20.6 4.2 28.1 11.6l32.3 32.3c7.5 7.5 11.6 17.6 11.6 28.1zm-106.9 2.6l32.3 32.3c1.4 1.4 3.9 1.4 5.3 0l32.3-32.3c1.4-1.4 1.4-3.9 0-5.3l-32.3-32.3c-1.4-1.4-3.9-1.4-5.3 0l-32.3 32.3c-1.4 1.4-1.4 3.9 0 5.3zM324 468c0-8.6 3.4-16.9 9.5-23L355 423.5c6.1-6.1 14.4-9.5 23-9.5s16.9 3.4 23 9.5L422.5 445c6.1 6.1 9.5 14.4 9.5 23s-3.4 16.9-9.5 23L401 512.5c-6.1 6.1-14.4 9.5-23 9.5s-16.9-3.4-23-9.5L333.5 491c-6.1-6.1-9.5-14.4-9.5-23zm54-16.5L361.5 468 378 484.5 394.5 468 378 451.5z"],
    "folders": [540, 540, [], "f660", "M108 162l-36 0c-39.8 0-72 32.2-72 72L0 414c0 39.8 32.2 72 72 72l288 0c39.8 0 72-32.2 72-72l0-36 36 0c39.8 0 72-32.2 72-72l0-108c0-39.8-32.2-72-72-72l-99 0c-11.3 0-22-5.3-28.8-14.4L318.6 82.8C305 64.7 283.7 54 261 54l-81 0c-39.8 0-72 32.2-72 72l0 36zm0 144c0 39.8 32.2 72 72 72l216 0 0 36c0 19.9-16.1 36-36 36L72 450c-19.9 0-36-16.1-36-36l0-180c0-19.9 16.1-36 36-36l36 0 0 108zm72 36c-19.9 0-36-16.1-36-36l0-180c0-19.9 16.1-36 36-36l81 0c11.3 0 22 5.3 28.8 14.4l21.6 28.8C325 151.3 346.3 162 369 162l99 0c19.9 0 36 16.1 36 36l0 108c0 19.9-16.1 36-36 36l-288 0z"],
    "tv": [432, 540, [63717, "television", "tv-alt"], "f26c", "M108 216c-19.9 0-36 16.1-36 36l0 144c0 19.9 16.1 36 36 36l162 0c19.9 0 36-16.1 36-36l0-144c0-19.9-16.1-36-36-36l-162 0zm0 36l162 0 0 144-162 0 0-144zm225 0a18 18 0 1 1 36 0 18 18 0 1 1 -36 0zm18 72a18 18 0 1 0 0-36 18 18 0 1 0 0 36zm9-180c39.8 0 72 32.2 72 72l0 216c0 39.8-32.2 72-72 72L72 504c-39.8 0-72-32.2-72-72L0 216c0-39.8 32.2-72 72-72l0-38.2c0-.7 0-1.5 .1-2.2 1-16.9 8-33.6 21-46.5 28.1-28.1 73.7-28.1 101.8 0L216 78.2 237.1 57.1C265.2 29 310.8 29 338.9 57.1 353 71.1 360 89.6 360 108l0 36zM169.5 82.5c-14.1-14.1-36.9-14.1-50.9 0s-14.1 36.9 0 50.9l10.5 10.5 173.8 0 10.5-10.5c14.1-14.1 14.1-36.9 0-50.9s-36.9-14.1-50.9 0l-33.8 33.8c-6.9 6.9-18.5 6.9-25.5 0L169.5 82.5zM360 180L72 180c-19.9 0-36 16.1-36 36l0 216c0 19.9 16.1 36 36 36l288 0c19.9 0 36-16.1 36-36l0-216c0-19.9-16.1-36-36-36z"],
    "star": [504, 540, [11088, 61446], "f005", "M185.3 81.3C196.3 53.9 222.8 36 252.2 36S308.1 53.9 319 81.3l29.6 74 79.5 5.3c29.4 2 54.6 21.6 63.7 49.6s.2 58.7-22.4 77.6l-61.2 51 19.5 77.3c7.2 28.5-3.7 58.6-27.5 75.9s-55.8 18.4-80.7 2.7l-67.4-42.5-67.4 42.5c-24.9 15.7-56.9 14.6-80.7-2.7S69.4 444.5 76.6 416l19.5-77.3-61.2-51c-22.6-18.8-31.5-49.6-22.4-77.6s34.3-47.6 63.7-49.6l79.5-5.3 29.6-74zM252.2 72c-14.7 0-28 9-33.4 22.6L185 179.1c-2.6 6.4-8.6 10.8-15.5 11.3l-90.8 6c-14.7 1-27.3 10.8-31.9 24.8S46.6 250.6 58 260l69.9 58.3c5.3 4.4 7.6 11.5 5.9 18.2l-22.3 88.2c-3.6 14.3 1.8 29.3 13.7 38s27.9 9.2 40.3 1.3l77-48.5c5.9-3.7 13.3-3.7 19.2 0l77 48.5c12.5 7.8 28.4 7.3 40.3-1.3s17.4-23.7 13.7-38l-22.3-88.2c-1.7-6.7 .6-13.8 5.9-18.2L446.4 260c11.3-9.4 15.7-24.8 11.2-38.8s-17.2-23.8-31.9-24.8l-90.8-6c-6.9-.5-12.9-4.8-15.5-11.3L285.6 94.6C280.2 81 266.9 72 252.2 72z"],
    "flag": [432, 540, [127988, 61725], "f024", "M238.8 75.7c-47.3-15.8-97.8-18.9-146.7-9.1L57.9 73.4C24.2 80.1 0 109.7 0 144L0 450c0 39.8 32.2 72 72 72s72-32.2 72-72l0-64.9c16.6-.5 33.3 1.9 49.2 7.2 47.3 15.8 97.8 18.9 146.7 9.1l34.2-6.8c33.7-6.7 57.9-36.3 57.9-70.6l0-180c0-21.6-9.7-42-26.4-55.7S367 69.2 345.9 73.4l-34.2 6.8c-24.3 4.9-49.4 3.3-72.9-4.5zM144 97c28.2-.5 56.4 3.8 83.4 12.8 29.4 9.8 60.9 11.8 91.4 5.7l34.2-6.8c10.6-2.1 21.5 .6 29.9 7.5S396 133.2 396 144l0 180c0 17.2-12.1 31.9-28.9 35.3l-34.2 6.8c-42.7 8.5-86.9 5.8-128.3-8-19.6-6.5-40.1-9.6-60.6-9.1l0-252zm-36 3.2L108 450c0 19.9-16.1 36-36 36s-36-16.1-36-36l0-306c0-17.2 12.1-31.9 28.9-35.3 14.3-2.9 28.6-6.1 43.1-8.4z"],
    "triangle-exclamation": [504, 540, [9888, "exclamation-triangle", "warning"], "f071", "M252.5 162c9.9 0 18 8.1 18 18l0 144c0 9.9-8.1 18-18 18s-18-8.1-18-18l0-144c0-9.9 8.1-18 18-18zm0 279a27 27 0 1 0 0-54 27 27 0 1 0 0 54zM189.6 91c12.7-22.9 36.8-37 62.9-37s50.2 14.2 62.9 37l180 324c12.4 22.3 12.1 49.5-.9 71.5S458 522 432.5 522l-360 0c-25.5 0-49.1-13.5-62.1-35.5S-2.8 437.3 9.6 415l180-324zm62.9-1c-13.1 0-25.1 7.1-31.5 18.5L41 432.5c-6.2 11.2-6 24.7 .4 35.7S59.7 486 72.5 486l360 0c12.8 0 24.6-6.8 31-17.7s6.6-24.6 .4-35.7l-180-324C277.6 97.1 265.6 90 252.5 90z"],
    "lock": [360, 540, [128274], "f023", "M198 324c0-9.9-8.1-18-18-18s-18 8.1-18 18l0 90c0 9.9 8.1 18 18 18s18-8.1 18-18l0-90zM54 162C54 92.4 110.4 36 180 36S306 92.4 306 162l0 56.3c31.1 8 54 36.2 54 69.7l0 162c0 39.8-32.2 72-72 72L72 522c-39.8 0-72-32.2-72-72L0 288c0-33.5 22.9-61.7 54-69.7L54 162zm216 0c0-49.7-40.3-90-90-90s-90 40.3-90 90l0 54 72 0 0-54c0-9.9 8.1-18 18-18s18 8.1 18 18l0 54 72 0 0-54zM36 288l0 162c0 19.9 16.1 36 36 36l216 0c19.9 0 36-16.1 36-36l0-162c0-19.9-16.1-36-36-36L72 252c-19.9 0-36 16.1-36 36z"],
    "anchor": [504, 540, [9875], "f13d", "M252 198a36 36 0 1 0 0-72 36 36 0 1 0 0 72zm0-162c-69.6 0-126 56.4-126 126 0 42.8 21.4 80.7 54 103.4l0 96.2-37.2-14.9c-6.2-33.4-35.5-58.8-70.8-58.8-39.8 0-72 32.2-72 72l0 36c0 29.4 17.9 55.9 45.3 66.9l180 72c17.2 6.9 36.3 6.9 53.5 0l180-72C486.1 451.9 504 425.4 504 396l0-36c0-39.8-32.2-72-72-72-35.2 0-64.6 25.3-70.8 58.8l-37.2 14.9 0-96.2c32.6-22.7 54-60.6 54-103.4 0-69.6-56.4-126-126-126zM162 162c0-49.7 40.3-90 90-90s90 40.3 90 90c0 33.3-18.1 62.4-45 78-5.6 3.2-9 9.2-9 15.6l0 132.7c0 12.5 13.1 21.4 24.7 16.7l72-28.8c6.8-2.7 11.2-9.2 11.3-16.5 .2-19.7 16.2-35.6 36-35.6 19.9 0 36 16.1 36 36l0 36c0 14.7-9 28-22.6 33.4l-180 72c-8.6 3.4-18.2 3.4-26.7 0l-180-72C45 424 36 410.7 36 396l0-36c0-19.9 16.1-36 36-36 19.8 0 35.8 15.9 36 35.6 .1 7.3 4.5 13.8 11.3 16.5l72 28.8c11.6 4.6 24.7-4.2 24.7-16.7l0-132.7c0-6.4-3.4-12.4-9-15.6-26.9-15.6-45-44.7-45-78z"],
    "scissors": [504, 540, [9984, 9986, 9988, "cut"], "f0c4", "M126 216a36 36 0 1 0 0-72 36 36 0 1 0 0 72zM90 396a36 36 0 1 1 72 0 36 36 0 1 1 -72 0zM252 179.2C251.6 110 195.3 54 126 54 56.4 54 0 110.4 0 180 0 225.8 24.5 266 61.1 288 24.5 310 0 350.2 0 396 0 465.6 56.4 522 126 522 195.3 522 251.6 466 252 396.8L364.8 502.5c29 27.2 74.6 25.7 101.8-3.3s25.7-74.6-3.3-101.8L346.5 288 463.2 178.5c29-27.2 30.5-72.8 3.3-101.8s-72.8-30.5-101.8-3.3L252 179.2zM126 90c49.7 0 90 40.3 90 90 0 15.7-4 30.5-11.1 43.3l-40.7 38.2c-11.6 5.4-24.5 8.5-38.2 8.5-49.7 0-90-40.3-90-90s40.3-90 90-90zM320.2 312.7L438.6 423.7c14.5 13.6 15.2 36.4 1.6 50.9s-36.4 15.2-50.9 1.6L267.5 362 320.2 312.7zM36 396c0-49.7 40.3-90 90-90 9.1 0 17.9 1.3 26.1 3.8 6.2 1.9 12.8 .3 17.5-4.1l219.7-206c14.5-13.6 37.3-12.9 50.9 1.6s12.9 37.3-1.6 50.9l-219.7 206c-4.7 4.4-6.7 11-5.2 17.2 1.5 6.6 2.3 13.4 2.3 20.5 0 49.7-40.3 90-90 90s-90-40.3-90-90z"],
    "bug": [504, 540, [], "f188", "M270 288c0-9.9-8.1-18-18-18s-18 8.1-18 18l0 108c0 9.9 8.1 18 18 18s18-8.1 18-18l0-108zM147.6 116.3C159.8 70.1 201.9 36 252 36s92.2 34.1 104.4 80.3l11.5-9.6c30.5-25.5 75.9-21.3 101.4 9.2 27.4 32.9 18.6 78.2-12.8 104.4 27.7 10 47.5 36.6 47.5 67.7s-19.8 57.7-47.5 67.7c31.4 26.1 40.2 71.5 12.8 104.4-25.5 30.5-70.9 34.7-101.4 9.2l-11.5-9.6C344.2 505.9 302.1 540 252 540s-92.2-34.1-104.4-80.3l-11.5 9.6c-30.5 25.5-75.9 21.3-101.4-9.2-27.4-32.9-18.6-78.2 12.8-104.4-27.7-10-47.5-36.6-47.5-67.7s19.8-57.7 47.5-67.7c-31.4-26.1-40.2-71.5-12.8-104.4 25.5-30.5 70.9-34.7 101.4-9.2l11.5 9.6zM252 72c-39.8 0-72 32.2-72 72l0 18c0 19.9 16.1 36 36 36l72 0c19.9 0 36-16.1 36-36l0-18c0-39.8-32.2-72-72-72zM113 134.3c-15.3-12.7-38-10.7-50.7 4.6s-10.7 38 4.6 50.7l36.6 30.5c5.8 4.9 8 12.8 5.4 20S99.6 252 92 252l-20 0c-19.9 0-36 16.1-36 36s16.1 36 36 36l20 0c7.6 0 14.3 4.7 16.9 11.9s.4 15.1-5.4 20L67 386.3c-15.3 12.7-17.3 35.4-4.6 50.7s35.4 17.3 50.7 4.6l37.4-31.2c5.4-4.5 12.8-5.4 19.2-2.5 10 4.7 10.4 14.5 10.4 24 0 39.8 32.2 72 72 72s72-32.2 72-72c0-9.5 .3-19.3 10.4-24 6.3-3 13.8-2 19.2 2.5L391 441.7c15.3 12.7 38 10.7 50.7-4.6s10.7-38-4.6-50.7l-36.6-30.5c-5.8-4.9-8-12.8-5.4-20S404.4 324 412 324l20 0c19.9 0 36-16.1 36-36s-16.1-36-36-36l-20 0c-7.6 0-14.3-4.7-16.9-11.9s-.4-15.1 5.4-20L437 189.7c15.3-12.7 17.3-35.4 4.6-50.7s-35.4-17.3-50.7-4.6l-31 25.8c0 39.9-31.3 73.9-72 73.9l-72 0c-40.7 0-72-33.9-72-73.9l-31-25.8z"],
    "arrow-right-from-bracket": [504, 540, ["sign-out"], "f08b", "M162 72c39.8 0 72 32.2 72 72 0 33.5-22.9 61.7-54 69.7l0 2.3 108 0c0-29.1 17.5-55.4 44.4-66.5 8.7-3.6 18-5.4 27.1-5.5 18.9-.1 37.4 7.2 51.3 21.1l72 72c28.1 28.1 28.1 73.7 0 101.8l-72 72c-13.9 13.9-32.6 21.2-51.5 21.1-9.1-.1-18.3-1.9-27-5.5-26.9-11.1-44.4-37.4-44.4-66.5l-108 0 0 2.3c31.1 8 54 36.2 54 69.7 0 39.8-32.2 72-72 72l-36 0C56.4 504 0 447.6 0 378L0 198C0 128.4 56.4 72 126 72l36 0zM126 468l36 0c19.9 0 36-16.1 36-36s-16.1-36-36-36l-36 0c-9.9 0-18-8.1-18-18l0-180c0-4.8 1.9-9.4 5.3-12.7s8-5.3 12.7-5.3l36 0c19.9 0 36-16.1 36-36s-16.1-36-36-36l-36 0c-49.7 0-90 40.3-90 90l0 180c0 49.7 40.3 90 90 90zM306 324c9.8 0 18 8.2 18 18l0 18c0 14.6 8.8 27.7 22.2 33.3 13.3 5.5 29.1 2.4 39.2-7.8l72-72c14.1-14.1 14.1-36.9 0-50.9l-72-72c-10.2-10.2-26-13.3-39.2-7.8-13.5 5.6-22.2 18.7-22.2 33.3l0 18c0 9.9-8.1 18-18 18l-126 0c-19.8 0-35.9 16.1-36 35.9 .1 19.6 16.3 36.1 36 36.1l126 0z"],
    "arrow-right-arrow-left": [576, 540, [8644, "exchange"], "f0ec", "M576 234c0-18.4-7-36.8-21.1-50.9l-90-90c-20.6-20.6-51.6-26.8-78.5-15.6S342 114.9 342 144l0 18-72 0c-26.2 0-49.1 14-61.7 34.9-5.5-4.7-11.8-8.5-18.8-11.4-26.9-11.1-57.9-5-78.5 15.6l-90 90c-14 14-21.1 32.4-21.1 50.9 0 18.4 7 36.9 21.1 51l90 90c20.6 20.6 51.6 26.8 78.5 15.6S234 461.1 234 432l0-18 72 0c26.2 0 49.1-14 61.7-34.9 5.5 4.7 11.8 8.5 18.8 11.4 26.9 11.1 57.9 5 78.5-15.6l90-90C569 270.9 576 252.4 576 234zM439.5 118.5l90 90c14.1 14.1 14 36.9 0 50.9l-90 90c-10.3 10.3-25.8 13.4-39.2 7.8S378 338.6 378 324l0-36c0-9.8-8.2-18-18-18-30.1 0-60.3 0-90.4 0-19.7-.2-35.6-16.3-35.6-36 0-19.9 16.1-36 36-36l90 0c9.9 0 18-8.1 18-18l0-36c0-14.6 8.8-27.7 22.2-33.3s28.9-2.5 39.2 7.8zM306.4 306c19.7 .2 35.6 16.2 35.6 36 0 19.9-16.1 36-36 36l-90 0c-9.8 0-18 8.2-18 18l0 36c0 14.6-8.8 27.7-22.2 33.3s-28.9 2.5-39.2-7.8l-90-90c-14.1-14.1-14-36.9 0-50.9l90-90c10.3-10.3 25.8-13.4 39.2-7.8S198 237.4 198 252l0 36c0 9.9 8.1 18 18 18z"],
    "arrow-up-from-line": [360, 540, [8613, "arrow-from-bottom"], "f342", "M242.4 378c6.1-10.6 9.6-22.9 9.6-36l0-54 18 0c29.1 0 55.4-17.5 66.5-44.4s5-57.9-15.6-78.5l-90-90C202.8 47 157.2 47 129.1 75.1l-90 90c-20.6 20.6-26.8 51.6-15.6 78.5S60.9 288 90 288l18 0 0 54c0 13.1 3.5 25.4 9.6 36L72 378c-39.8 0-72 32.2-72 72s32.2 72 72 72l216 0c39.8 0 72-32.2 72-72s-32.2-72-72-72l-45.6 0zm60.9-148.2C297.7 243.2 284.6 252 270 252l-36 0c-9.8 0-18 8.2-18 18l0 72c0 19.9-16.1 36-36 36s-36-16.1-36-36l0-72c0-9.9-8.1-18-18-18l-36 0c-14.6 0-27.7-8.8-33.3-22.2s-2.5-28.9 7.8-39.2l90-90c14.1-14.1 36.9-14.1 50.9 0l90 90c10.3 10.3 13.4 25.8 7.8 39.2zM72 414l216 0c19.9 0 36 16.1 36 36s-16.1 36-36 36L72 486c-19.9 0-36-16.1-36-36s16.1-36 36-36z"],
    "font": [468, 540, [], "f031", "M168.9 77.2C180.9 52 206.2 36 234 36s53.2 16 65.1 41.2l162 342c17 35.9 1.7 78.9-34.2 95.9s-78.9 1.7-95.9-34.2l-31.7-66.8-130.6 0-31.7 66.8c-17 35.9-60 51.3-95.9 34.2s-51.3-60-34.2-95.9l162-342zM234 72c-13.9 0-26.6 8-32.5 20.6l-162 342c-8.5 18-.8 39.4 17.1 47.9s39.4 .8 47.9-17.1l36.5-77.1c3-6.3 9.3-10.3 16.3-10.3l153.3 0c7 0 13.3 4 16.3 10.3l36.5 77.1c8.5 18 30 25.6 47.9 17.1s25.6-30 17.1-47.9l-162-342C260.6 80 247.9 72 234 72zm16.3 154.4l25.5 53.9c5.6 11.7-3.3 25.7-16.3 25.7l-51 0c-13 0-21.8-14-16.3-25.7l25.5-53.9c6.4-13.5 26.2-13.5 32.5 0z"],
    "language": [504, 540, [], "f1ab", "M0 162c0-39.8 32.2-72 72-72l360 0c39.8 0 72 32.2 72 72l0 252c0 39.8-32.2 72-72 72L72 486c-39.8 0-72-32.2-72-72L0 162zM36 414c0 19.9 16.1 36 36 36l360 0c19.9 0 36-16.1 36-36l0-252c0-19.9-16.1-36-36-36L72 126c-19.9 0-36 16.1-36 36l0 252zM342 207c7.1 0 13.6 4.2 16.4 10.7l72 162c4 9.1-.1 19.7-9.1 23.8s-19.7-.1-23.8-9.1l-19.2-43.3-72.6 0-19.2 43.3c-4 9.1-14.7 13.2-23.8 9.1s-13.2-14.7-9.1-23.8l12.8-28.7-14.3 0c-28.6 0-52.4-5.9-72-15.3-19.7 9.4-43.4 15.3-72 15.3-9.9 0-18-8.1-18-18s8.1-18 18-18c13.1 0 24.9-1.5 35.4-4.2-13.8-12.8-24.1-27.2-31.8-41.1-4.8-8.7-1.7-19.6 7-24.5s19.6-1.7 24.5 7c8.2 14.8 19.9 30.1 36.9 42 27.6-19.2 41.9-48.6 48.8-69.2L108 225c-9.9 0-18-8.1-18-18s8.1-18 18-18l54 0 0-18c0-9.9 8.1-18 18-18s18 8.1 18 18l0 18 54 0c5.2 0 10.2 2.3 13.6 6.2s5 9.2 4.2 14.3c-1.1 7.6-3.1 15.1-5.4 22.5-4 12.9-10.8 30.2-22 47.7-6.9 10.7-15.4 21.3-25.8 31.1 10.5 2.7 22.3 4.2 35.4 4.2l30.3 0 43.2-97.3c2.9-6.5 9.3-10.7 16.4-10.7zm0 62.3l-20.3 45.7 40.6 0-20.3-45.7z"],
    "person-biking": [504, 540, [128692, "biking"], "f84a", "M288 115.3c.9-44 36.8-79.3 81-79.3 44.7 0 81 36.3 81 81 0 27.1-13.3 51.2-33.8 65.9 30 8.7 51.8 36.4 51.8 69.1 0 19.2-7.5 36.6-19.7 49.5 33.2 18.4 55.7 53.8 55.7 94.5 0 59.6-48.4 108-108 108-36.2 0-68.2-17.8-87.8-45-13.2 16.5-33.5 27-56.2 27s-43-10.6-56.2-27c-19.6 27.3-51.6 45-87.8 45-59.6 0-108-48.4-108-108 0-59.3 47.8-107.4 106.9-108-10.9-15.3-16.9-33.7-16.9-52.7 0-31.2 16.1-60.3 42.6-76.8l52.1-32.6c18.7-11.7 40.3-17.9 62.4-17.9 14.1 0 28 2.5 40.9 7.3zM369 72a45 45 0 1 0 0 90 45 45 0 1 0 0-90zM180 396a72 72 0 1 0 -144 0 72 72 0 1 0 144 0zm36 18c0 19.9 16.1 36 36 36s36-16.1 36-36l0-81c0-9.5-3.8-18.7-10.5-25.5l-53.1-53.1c-8.1-8.1-6.5-22 3.2-28l8-5c7.9-5 18.3-3 23.9 4.5l35.7 47.6C302 282.7 312.7 288 324 288l72 0c19.9 0 36-16.1 36-36s-16.1-36-36-36l-45 0c-5.7 0-11-2.7-14.4-7.2l-24.1-32.1c-15.4-20.6-39.7-32.7-65.4-32.7-15.3 0-30.3 4.3-43.3 12.4L151.7 189c-16 10-25.7 27.5-25.7 46.3 0 14.5 5.8 28.4 16 38.6l68.7 68.7c3.4 3.4 5.3 8 5.3 12.7l0 58.6zm108-18a72 72 0 1 0 144 0 72 72 0 1 0 -144 0z"],
    "globe": [504, 540, [127760], "f0ac", "M252 36a252 252 0 1 0 0 504 252 252 0 1 0 0-504zM36.7 270c7.6-92.4 73.5-168.4 160.8-191.1-41.2 55.3-67.3 122-71 191.1l-89.7 0zm0 36l89.7 0c3.8 69.1 29.8 135.8 71 191.1-87.3-22.7-153.2-98.6-160.8-191.1zM250.4 504c-50.9-52.5-83.4-125.1-87.8-198l178.9 0c-4.5 72.9-36.9 145.5-87.8 198-1.1 0-2.2 0-3.3 0zM377.5 306l89.7 0c-7.6 92.4-73.5 168.4-160.8 191.1 41.2-55.3 67.3-122 71-191.1zm0-36c-3.8-69.1-29.8-135.8-71-191.1 87.3 22.7 153.2 98.6 160.8 191.1l-89.7 0zM253.6 72c50.9 52.5 83.4 125.1 87.8 198l-178.9 0c4.5-72.9 36.9-145.5 87.8-198 1.1 0 2.2 0 3.3 0z"],
    "arrow-left": [504, 540, [8592], "f060", "M183.1 75.1c28.1-28.1 73.7-28.1 101.8 0s28.1 73.7 0 101.8L245.8 216 432 216c39.8 0 72 32.2 72 72s-32.2 72-72 72l-186.2 0 39.1 39.1c28.1 28.1 28.1 73.7 0 101.8s-73.7 28.1-101.8 0l-162-162C-7 310.8-7 265.2 21.1 237.1l162-162zm76.4 25.5c-14.1-14.1-36.9-14.1-50.9 0l-162 162c-14.1 14.1-14.1 36.9 0 50.9l162 162c14.1 14.1 36.9 14.1 50.9 0s14.1-36.9 0-50.9l-69.8-69.8c-5.1-5.1-6.7-12.9-3.9-19.6s9.3-11.1 16.6-11.1L432 324c19.9 0 36-16.1 36-36s-16.1-36-36-36l-229.6 0c-7.3 0-13.8-4.4-16.6-11.1s-1.2-14.5 3.9-19.6l69.8-69.8c14.1-14.1 14.1-36.9 0-50.9z"],
    "paw": [468, 540, [], "f1b0", "M108 126c0-39.8 32.2-72 72-72 21.5 0 40.8 9.4 54 24.4 13.2-14.9 32.5-24.4 54-24.4 39.8 0 72 32.2 72 72l0 9.6c10.6-6.1 22.9-9.6 36-9.6 39.8 0 72 32.2 72 72l0 36c0 40.8-35.3 74.1-76 71.9 24.7 36.3 40 80.8 40 126.1 0 22.5-10.5 43.7-28.4 57.3-17.9 13.6-41.1 18.1-62.7 12.1-35-9.5-71.4-15.4-106.8-15.4s-71.9 5.9-106.8 15.4c-21.7 6-44.9 1.5-62.8-12.1-17.9-13.6-28.4-34.8-28.4-57.3 0-45.3 15.3-89.8 40-126.1-40.6 2.2-76-31.1-76-71.9l0-36c0-39.8 32.2-72 72-72 13.1 0 25.4 3.5 36 9.6l0-9.6zm144 54c0 19.9 16.1 36 36 36s36-16.1 36-36l0-54c0-19.9-16.1-36-36-36s-36 16.1-36 36l0 54zM180 90c-19.9 0-36 16.1-36 36l0 54c0 19.9 16.1 36 36 36s36-16.1 36-36l0-54c0-19.9-16.1-36-36-36zM72 162c-19.9 0-36 16.1-36 36l0 36c0 19.9 16.1 36 36 36s36-16.1 36-36l0-36c0-19.9-16.1-36-36-36zm288 36l0 36c0 19.9 16.1 36 36 36s36-16.1 36-36l0-36c0-19.9-16.1-36-36-36s-36 16.1-36 36zM117.3 310.8C89.6 344 72 388 72 432 72 443.3 77.3 453.9 86.2 460.7s20.7 9 31.5 6C155 456.6 194.7 450 234 450s79 6.6 116.3 16.7c10.8 3 22.6 .8 31.5-6 9-6.8 14.2-17.4 14.2-28.7 0-44-17.6-88-45.3-121.2-27.7-33.2-68.6-58.8-116.7-58.8s-89 25.6-116.7 58.8z"],
    "bed": [540, 540, [128716], "f236", "M0 414c0 39.8 32.2 72 72 72s72-32.2 72-72l252 0c0 39.8 32.2 72 72 72s72-32.2 72-72l0-180c0-39.8-32.2-72-72-72l-180 0c-21.5 0-40.8 9.4-54 24.4-13.2-14.9-32.5-24.4-54-24.4-13.1 0-25.4 3.5-36 9.6l0-9.6c0-39.8-32.2-72-72-72S0 122.2 0 162L0 414zM180 198a36 36 0 1 1 0 72 36 36 0 1 1 0-72zm-72-36l0 126c0 9.9 8.1 18 18 18l378 0 0 108c0 19.9-16.1 36-36 36s-36-16.1-36-36l0-18c0-9.9-8.1-18-18-18l-288 0c-9.9 0-18 8.1-18 18l0 18c0 19.9-16.1 36-36 36s-36-16.1-36-36l0-252c0-19.9 16.1-36 36-36s36 16.1 36 36zm144 72c0-19.9 16.1-36 36-36l180 0c19.9 0 36 16.1 36 36l0 36-252 0 0-36z"],
    "landmark": [432, 540, [127963], "f66f", "M248.2 43.6c-20.3-10.1-44.1-10.1-64.4 0l-144 72C9.9 130.5-5.7 164 1.9 196.5 6.6 216.4 19.3 232.7 36 242.4l0 127.3c-21.5 12.4-36 35.7-36 62.4 0 39.8 32.2 72 72 72l288 0c39.8 0 72-32.2 72-72 0-30.2-18.6-56.1-45-66.8l0-118.5c21.1-8.6 37.6-26.9 43.1-50.2 7.7-32.5-8-66-37.9-80.9l-144-72zM199.9 75.8c10.1-5.1 22.1-5.1 32.2 0l144 72c14.9 7.5 22.8 24.2 18.9 40.5S376.7 216 360 216L72 216c-16.7 0-31.2-11.5-35-27.7s4-33 18.9-40.5l144-72zM351 252l0 108-63 0 0-108 63 0zM252 360l-72 0 0-108 72 0 0 108zm-108 0l-72 0 0-108 72 0 0 108zM36 432c0-19.9 16.1-36 36-36l288 0c19.9 0 36 16.1 36 36s-16.1 36-36 36L72 468c-19.9 0-36-16.1-36-36z"],
    "music": [504, 540, [127925], "f001", "M246.6 433.9c25.6 23.3 61.1 34.1 95.4 34.1 33.3 0 64.2-10.1 87.2-27.3S468 398.3 468 369l0-243c0-21.2-9.3-41.3-25.5-54.9S405 51.5 384.2 55l-216 36c-34.7 5.8-60.2 35.8-60.2 71l0 145C81.6 309.9 57.6 319.3 38.8 333.3 15.9 350.5 0 375.7 0 405s15.9 54.5 38.8 71.7 53.8 27.3 87.2 27.3 64.2-10.1 87.2-27.3c15-11.2 26.9-25.8 33.4-42.8zM419.3 98.5c8.1 6.8 12.7 16.9 12.7 27.5l0 243c0 15.4-8.3 30.8-24.4 42.9s-39.3 20.1-65.6 20.1-49.4-8-65.6-20.1-24.4-27.4-24.4-42.9 8.3-30.8 24.4-42.9 39.3-20.1 65.6-20.1c9.9 0 18-8.1 18-18l0-98.3c0-11-10.2-19.6-21-17.8L231 190c-8.7 1.4-15 9-15 17.8L216 405c0 15.4-8.3 30.8-24.4 42.9S152.3 468 126 468 76.6 460 60.4 447.9 36 420.4 36 405 44.3 374.2 60.4 362.1 99.7 342 126 342c9.9 0 18-8.1 18-18l0-162c0-17.6 12.7-32.6 30.1-35.5l216-36c10.4-1.7 21.1 1.2 29.2 8zM252 299.5l0-76.5 72-12 0 60c-27.7 3.1-52.8 13.2-72 28.5z"],
    "files": [396, 540, [], "e178", "M108 108c0-39.8 32.2-72 72-72l85.6 0c19.1 0 37.4 7.6 50.9 21.1l58.4 58.4C388.4 129 396 147.3 396 166.4L396 360c0 39.8-32.2 72-72 72l-36 0 0 36c0 39.8-32.2 72-72 72L72 540c-39.8 0-72-32.2-72-72L0 216c0-39.8 32.2-72 72-72l36 0 0-36zm72-36c-19.9 0-36 16.1-36 36l0 252c0 19.9 16.1 36 36 36l144 0c19.9 0 36-16.1 36-36l0-162-54 0c-39.8 0-72-32.2-72-72l0-54-54 0zm90 .3l0 53.7c0 19.9 16.1 36 36 36l53.7 0c-1-7.9-4.6-15.4-10.3-21.1L291.1 82.5c-5.7-5.7-13.2-9.3-21.1-10.3zM180 432c-39.8 0-72-32.2-72-72l0-180-36 0c-19.9 0-36 16.1-36 36l0 252c0 19.9 16.1 36 36 36l144 0c19.9 0 36-16.1 36-36l0-36-72 0z"],
    "plus": [468, 540, [10133, 61543, "add"], "2b", "M234 90c-19.9 0-36 16.1-36 36l0 108c0 9.9-8.1 18-18 18L72 252c-19.9 0-36 16.1-36 36s16.1 36 36 36l108 0c9.9 0 18 8.1 18 18l0 108c0 19.9 16.1 36 36 36s36-16.1 36-36l0-108c0-9.9 8.1-18 18-18l108 0c19.9 0 36-16.1 36-36s-16.1-36-36-36l-108 0c-9.9 0-18-8.1-18-18l0-108c0-19.9-16.1-36-36-36zm-72 36c0-39.8 32.2-72 72-72s72 32.2 72 72l0 90 90 0c39.8 0 72 32.2 72 72s-32.2 72-72 72l-90 0 0 90c0 39.8-32.2 72-72 72s-72-32.2-72-72l0-90-90 0c-39.8 0-72-32.2-72-72s32.2-72 72-72l90 0 0-90z"],
    "copy": [468, 540, [], "f0c5", "M198 54c-39.8 0-72 32.2-72 72l0 54-36 0c-39.8 0-72 32.2-72 72l0 198c0 39.8 32.2 72 72 72l198 0c39.8 0 72-32.2 72-72l0-54 36 0c39.8 0 72-32.2 72-72l0-198c0-39.8-32.2-72-72-72L198 54zM324 396l0 54c0 19.9-16.1 36-36 36L90 486c-19.9 0-36-16.1-36-36l0-198c0-19.9 16.1-36 36-36l36 0 0 108c0 39.8 32.2 72 72 72l126 0zM162 126c0-19.9 16.1-36 36-36l198 0c19.9 0 36 16.1 36 36l0 198c0 19.9-16.1 36-36 36l-198 0c-19.9 0-36-16.1-36-36l0-198z"],
    "box": [432, 540, [128230], "f466", "M117 72c-27.3 0-52.2 15.4-64.4 39.8l-45 90c-5 10-7.6 21-7.6 32.2L0 432c0 39.8 32.2 72 72 72l288 0c39.8 0 72-32.2 72-72l0-198c0-11.2-2.6-22.2-7.6-32.2l-45-90C367.2 87.4 342.3 72 315 72L117 72zM84.8 127.9C90.9 115.7 103.4 108 117 108l81 0 0 108-157.2 0 44-88.1zM36 252l360 0 0 180c0 19.9-16.1 36-36 36L72 468c-19.9 0-36-16.1-36-36l0-180zm355.2-36l-157.2 0 0-108 81 0c13.6 0 26.1 7.7 32.2 19.9l44 88.1z"],
    "arrow-rotate-right": [504, 540, [8635, "arrow-right-rotate", "arrow-rotate-forward", "redo"], "f01e", "M426.8 342c14.4 24.9 12.9 57.2-6.2 81-39.5 49.2-100.3 81-168.6 81-119.3 0-216-96.7-216-216S132.7 72 252 72c50 0 98.1 18.5 135.1 51.7 20.3-16.2 48-20.3 72.4-10.2 26.9 11.1 44.4 37.4 44.4 66.5l0 90c0 39.8-32.2 72-72 72l-5.2 0zM252 108c-99.4 0-180 80.6-180 180s80.6 180 180 180c56.9 0 107.6-26.4 140.5-67.5 12.4-15.5 9.9-38.2-5.6-50.6-15.3-12.3-38.2-9.9-50.6 5.6-19.9 24.8-50.2 40.5-84.3 40.5-59.6 0-108-48.4-108-108s48.4-108 108-108c25 0 49 9.9 66.7 27.6 5 5 9.9 9.7 9.9 17.4 0 8.7-6.5 13.9-12.1 19.5-10.3 10.3-13.4 25.8-7.8 39.2S327.4 306 342 306l90 0c19.9 0 36-16.1 36-36l0-90c0-14.6-8.8-27.7-22.2-33.3s-28.9-2.5-39.2 7.8c-5.6 5.6-10.8 12.1-19.5 12.1-7.6 0-12.4-4.9-17.4-9.9-31.2-31.2-73.5-48.7-117.6-48.7zm55.9 225.4c-14.3-7.7-25.9-20.2-32.4-35.9-9.9-24-6.1-51.2 9.4-71.4-9.6-6.6-21.1-10.2-32.9-10.2-39.8 0-72 32.2-72 72s32.2 72 72 72c22.5 0 42.6-10.3 55.9-26.6z"],
    "signal-bars-slash": [504, 540, ["signal-alt-slash"], "f694", "M122.9 57.1C94.8 29 49.2 29 21.1 57.1s-28.1 73.7 0 101.8l108 108c-3.1 10.1-3.1 20.3-3.1 30.7-10.6-6.1-22.9-9.6-36-9.6-39.8 0-72 32.2-72 72l0 72c0 39.8 32.2 72 72 72 21.5 0 40.8-9.4 54-24.4 13.2 14.9 32.5 24.4 54 24.4s40.8-9.4 54-24.4c13.2 14.9 32.5 24.4 54 24.4 16.9 0 32.4-5.8 44.7-15.5l30.4 30.4c28.1 28.1 73.7 28.1 101.8 0 27-27 28.1-70.3 3.1-98.5L486 144c0-39.8-32.2-72-72-72s-72 32.2-72 72l0 9.6c-10.6-6.1-22.9-9.6-36-9.6-26.1 0-48.9 13.9-61.6 34.6L122.9 57.1zM46.5 82.5c14.1-14.1 36.9-14.1 50.9 0l360 360c14.1 14.1 14.1 36.9 0 50.9s-36.9 14.1-50.9 0l-360-360c-14.1-14.1-14.1-36.9 0-50.9zm225 123.1c4.4-14.9 18.2-25.7 34.5-25.7 19.9 0 36 16.1 36 36l0 60.2-70.5-70.5zM378 312.2L378 144c0-19.9 16.1-36 36-36s36 16.1 36 36l0 240.2-72-72zM324.9 462.7c-5.5 3.4-11.9 5.3-18.9 5.3-19.9 0-36-16.1-36-36l0-24.2 54.9 54.9zM234 371.8l0 60.2c0 19.9-16.1 36-36 36s-36-16.1-36-36l0-132.2 72 72zM126 432c0 19.9-16.1 36-36 36s-36-16.1-36-36l0-72c0-19.9 16.1-36 36-36s36 16.1 36 36l0 72z"],
    "arrow-down-wide-short": [540, 540, ["sort-amount-asc", "sort-amount-down"], "f160", "M5.5 332.4c-11.1 26.9-5 57.9 15.6 78.5l72 72c28.1 28.1 73.7 28.1 101.8 0l61.6-61.6C266.8 448.6 293.1 468 324 468l36 0c39.8 0 72-32.2 72-72 0-13.3-3.6-25.8-9.9-36.5 35.9-4 63.9-34.5 63.9-71.5 0-13.3-3.6-25.8-9.9-36.5 35.9-4 63.9-34.5 63.9-71.5 0-39.8-32.2-72-72-72l-144 0c-39.8 0-72 32.2-72 72 0 21.5 9.4 40.8 24.4 54-14.9 13.2-24.4 32.5-24.4 54 0 3.4 .2 6.8 .7 10.1-10.9-6.4-23.5-10.1-36.7-10.1l0-144c0-39.8-32.2-72-72-72s-72 32.2-72 72l0 144c-29.1 0-55.4 17.5-66.5 44.4zm41.1 53c-10.3-10.3-13.4-25.8-7.8-39.2S57.4 324 72 324l18 0c9.9 0 18-8.1 18-18l0-162c0-19.9 16.1-36 36-36s36 16.1 36 36l0 162c0 9.8 8.2 18 18 18l18 0c14.6 0 27.7 8.8 33.3 22.2s2.5 28.9-7.8 39.2l-72 72c-14.1 14.1-36.9 14.1-50.9 0l-72-72zM324 324c-19.9 0-36-16.1-36-36 0-19.9 16.1-36 36-36l90.1 0c19.9 0 36 16.1 36 36 0 19.9-16.1 36-36 36l-90 0zm-36 72c0-19.9 16.1-36 36-36l36 0c19.9 0 36 16.1 36 36s-16.1 36-36 36l-36 0c-19.9 0-36-16.1-36-36zM468 216l-144 0c-19.9 0-36-16.1-36-36s16.1-36 36-36l144 0c19.9 0 36 16.1 36 36s-16.1 36-36 36z"],
    "compress": [432, 540, [], "f066", "M270 504c-21.5 0-40.8-9.4-54-24.4-13.2 14.9-32.5 24.4-54 24.4-39.8 0-72-32.2-72-72l0-18-18 0c-39.8 0-72-32.2-72-72 0-21.5 9.4-40.8 24.4-54-14.9-13.2-24.4-32.5-24.4-54 0-39.8 32.2-72 72-72l18 0 0-18c0-39.8 32.2-72 72-72 21.5 0 40.8 9.4 54 24.4 13.2-14.9 32.5-24.4 54-24.4 39.8 0 72 32.2 72 72l0 18 18 0c39.8 0 72 32.2 72 72 0 21.5-9.4 40.8-24.4 54 14.9 13.2 24.4 32.5 24.4 54 0 39.8-32.2 72-72 72l-18 0 0 18c0 39.8-32.2 72-72 72zM198 234l0-90c0-19.9-16.1-36-36-36s-36 16.1-36 36l0 36c0 9.8-8.2 18-18 18l-36 0c-19.9 0-36 16.1-36 36s16.1 36 36 36l90 0c19.6 0 36-16.4 36-36zm36 198c0 19.9 16.1 36 36 36s36-16.1 36-36l0-36c0-9.8 8.2-18 18-18l36 0c19.9 0 36-16.1 36-36s-16.1-36-36-36l-90 0c-19.6 0-36 16.4-36 36l0 90zM36 342c0 19.9 16.1 36 36 36l36 0c9.8 0 18 8.2 18 18l0 36c0 19.9 16.1 36 36 36s36-16.1 36-36l0-90c0-19.6-16.4-36-36-36l-90 0c-19.9 0-36 16.1-36 36zm324-72c19.9 0 36-16.1 36-36s-16.1-36-36-36l-36 0c-4.8 0-9.4-1.9-12.7-5.3s-5.3-8-5.3-12.7l0-36c0-19.9-16.1-36-36-36s-36 16.1-36 36l0 90c0 19.6 16.4 36 36 36l90 0z"],
    "eye-slash": [504, 540, [], "f070", "M57 194.8L21.1 158.9C-7 130.8-7 85.2 21.1 57.1s73.7-28.1 101.8 0L169.8 104c24.2-9.1 50-14 76.4-14l11.5 0c63.1 0 123 27.6 164 75.4l64.9 75.7c23.1 27 23.1 66.8 0 93.7l-39.7 46.3 35.9 35.9c28.1 28.1 28.1 73.7 0 101.8s-73.7 28.1-101.8 0L334.2 472c-24.2 9.1-50 14-76.4 14l-11.5 0c-63.1 0-123-27.6-164-75.4L17.3 334.9c-23.1-27-23.1-66.8 0-93.7L57 194.8zM46.5 82.5c-14.1 14.1-14.1 36.9 0 50.9l360 360c14.1 14.1 36.9 14.1 50.9 0s14.1-36.9 0-50.9l-360-360c-14.1-14.1-36.9-14.1-50.9 0zm36 137.8L44.7 264.6c-11.6 13.5-11.6 33.4 0 46.9l64.9 75.7C143.8 427 193.7 450 246.2 450l11.5 0c16.4 0 32.5-2.2 47.9-6.5L82.6 220.4zM421.5 355.6l37.9-44.2c11.6-13.5 11.6-33.4 0-46.9l-64.9-75.7C360.2 149 310.3 126 257.8 126l-11.5 0c-16.4 0-32.5 2.2-47.9 6.5L421.5 355.6z"],
    "mug-hot": [504, 540, [9749], "f7b6", "M342 180c0 13.1-3.5 25.4-9.6 36l54.6 0c64.6 0 117 52.4 117 117 0 66.2-54 117-120.1 117-20.2 42.6-63.6 72-113.9 72l-108 0C92.4 522 36 465.6 36 396l0-108c0-37 27.9-67.5 63.9-71.5-6.3-10.7-9.9-23.2-9.9-36.5l0-36c0-39.8 32.2-72 72-72 20.3 0 38.7 8.4 51.8 22 4-9 8.8-17.6 14.3-25.9 22.1-33.1 66.8-42 99.8-20s42 66.8 20 99.8c-3.9 5.8-5.9 12.6-5.9 19.5l0 12.5zM108 252c-19.9 0-36 16.1-36 36l0 108c0 49.7 40.3 90 90 90l108 0c49.7 0 90-40.3 90-90l0-144-252 0zm126-72c0 19.9 16.1 36 36 36s36-16.1 36-36l0-12.5c0-14.1 4.2-27.8 12-39.5 11-16.5 6.6-38.9-10-49.9S269.1 71.5 258 88c-15.7 23.5-24 51.2-24 79.4l0 12.5zm-36 0l0-36c0-19.9-16.1-36-36-36s-36 16.1-36 36l0 36c0 19.9 16.1 36 36 36s36-16.1 36-36zm198 72.5L396 396c0 6-.4 11.9-1.2 17.6 41.1-3.9 73.2-38.5 73.2-80.6 0-41.7-31.5-76-72-80.5z"],
    "bolt": [396, 540, [9889, "zap"], "f0e7", "M159.8 63c20.7-25.9 56.5-34.3 86.6-20.3s46.7 46.8 40.2 79.4L267.8 216 324 216c27.7 0 52.9 15.9 64.9 40.8s8.6 54.6-8.7 76.2l-144 180c-20.7 25.9-56.5 34.3-86.6 20.3s-46.7-46.8-40.2-79.4L128.2 360 72 360c-27.7 0-52.9-15.9-64.9-40.8s-8.6-54.6 8.7-76.2l144-180zm71.4 12.3c-15.1-7-32.9-2.8-43.3 10.1l-144 180c-8.6 10.8-10.3 25.6-4.3 38.1S58.2 324 72 324l78.1 0c5.4 0 10.5 2.4 13.9 6.6s4.8 9.7 3.7 14.9L144.7 460.9c-3.3 16.3 5 32.7 20.1 39.7s32.9 2.8 43.3-10.1l144-180c8.6-10.8 10.3-25.6 4.3-38.1S337.8 252 324 252l-78.1 0c-5.4 0-10.5-2.4-13.9-6.6s-4.8-9.7-3.7-14.9l23.1-115.4c3.3-16.3-5-32.7-20.1-39.7z"],
    "arrow-rotate-left": [504, 540, [8634, "arrow-left-rotate", "arrow-rotate-back", "arrow-rotate-backward", "undo"], "f0e2", "M77.2 342c-14.4 24.9-12.9 57.2 6.2 81 39.5 49.2 100.3 81 168.6 81 119.3 0 216-96.7 216-216S371.3 72 252 72c-50 0-98.1 18.5-135.1 51.7-20.3-16.2-48-20.3-72.4-10.2-26.9 11.1-44.4 37.4-44.4 66.5l0 90c0 39.8 32.2 72 72 72l5.2 0zM252 108c99.4 0 180 80.6 180 180S351.4 468 252 468c-56.9 0-107.6-26.4-140.5-67.5-12.4-15.5-9.9-38.2 5.6-50.6 15.3-12.3 38.2-9.9 50.6 5.6 19.9 24.8 50.2 40.5 84.3 40.5 59.6 0 108-48.4 108-108S311.6 180 252 180c-25 0-49 9.9-66.7 27.6-5 5-9.9 9.7-9.9 17.4 0 8.7 6.5 13.9 12.1 19.5 10.3 10.3 13.4 25.8 7.8 39.2S176.6 306 162 306l-90 0c-19.9 0-36-16.1-36-36l0-90c0-14.6 8.8-27.7 22.2-33.3s28.9-2.5 39.2 7.8c5.6 5.6 10.8 12.1 19.5 12.1 7.6 0 12.4-4.9 17.4-9.9 31.2-31.2 73.5-48.7 117.6-48.7zM196.1 333.4c14.3-7.7 25.9-20.2 32.4-35.9 9.9-24 6.1-51.2-9.4-71.4 9.6-6.6 21.1-10.2 32.9-10.2 39.8 0 72 32.2 72 72s-32.2 72-72 72c-22.5 0-42.6-10.3-55.9-26.6z"],
    "wifi": [576, 540, ["wifi-3", "wifi-strong"], "f1eb", "M24 154.9c150.1-134.5 378-134.5 528.1 0 29.6 26.5 32.1 72.1 5.6 101.7-14.3 16-34.2 24.1-54.1 24 2.3 19.8-3.5 40.5-17.9 56.5-14.3 16-34.2 24.1-54.1 24 2.3 19.8-3.5 40.5-17.9 56.5-14.3 16-34.2 24.1-54.1 24 .3 2.8 .5 5.6 .5 8.5 0 39.8-32.2 72-72 72s-72-32.2-72-72c0-2.9 .2-5.7 .5-8.5-19.9 .1-39.8-8-54.1-24-14.4-16-20.2-36.7-17.9-56.5-19.9 .1-39.8-8-54.1-24-14.4-16-20.2-36.7-17.9-56.5-19.9 .1-39.8-8-54.1-24-26.5-29.6-24-75.1 5.6-101.7zM324 450a36 36 0 1 0 -72 0 36 36 0 1 0 72 0zm12-53.7c14.8 13.3 37.6 12 50.8-2.8s12-37.6-2.8-50.8c-54.6-48.9-137.5-48.9-192 0-14.8 13.3-16.1 36-2.8 50.8s36 16.1 50.8 2.8c13.4-12 29.9-18.3 48-18.3s34.6 6.3 48 18.3zM458.8 313c13.3-14.8 12-37.6-2.8-50.8-95.5-85.6-240.5-85.6-336 0-14.8 13.3-16.1 36-2.8 50.8s36 16.1 50.8 2.8c68.2-61.1 171.8-61.1 240 0 14.8 13.3 37.6 12 50.8-2.8zM528 181.7c-136.4-122.2-343.6-122.2-480 0-14.8 13.3-16.1 36-2.8 50.8s36 16.1 50.8 2.8c109.1-97.7 274.9-97.7 384 0 14.8 13.3 37.6 12 50.8-2.8s12-37.6-2.8-50.8z"],
    "volume": [576, 540, [128265, "volume-medium"], "f6a8", "M249.8 54c-14.9 0-29.2 5.9-39.7 16.5l-86.3 86.3c-3.4 3.4-8 5.3-12.7 5.3L72 162c-39.8 0-72 32.2-72 72L0 342c0 39.8 32.2 72 72 72l39.1 0c4.8 0 9.4 1.9 12.7 5.3l86.3 86.3c10.5 10.5 24.8 16.5 39.7 16.5 31 0 56.2-25.2 56.2-56.2l0-355.6c0-31-25.2-56.2-56.2-56.2zM235.5 95.9c3.8-3.8 8.9-5.9 14.3-5.9 11.1 0 20.2 9 20.2 20.2l0 355.6c0 11.1-9 20.2-20.2 20.2-5.4 0-10.5-2.1-14.3-5.9l-86.3-86.3c-10.1-10.1-23.9-15.8-38.2-15.8L72 378c-19.9 0-36-16.1-36-36l0-108c0-19.9 16.1-36 36-36l39.1 0c14.3 0 28.1-5.7 38.2-15.8l86.3-86.3zM446 78.4c-35.6-17.7-78.8-3.2-96.5 32.4s-3.2 78.8 32.4 96.5c29.8 14.8 50 45.4 50 80.7s-20.3 65.9-50 80.7c-35.6 17.7-50.1 60.9-32.4 96.5s60.9 50.1 96.5 32.4C522.9 459.4 576 380 576 288S522.9 116.6 446 78.4zm-64.3 48.5c8.8-17.8 30.5-25.1 48.3-16.2 65.1 32.4 110 99.6 110 177.4S495.1 433 430 465.4c-17.8 8.8-39.4 1.6-48.3-16.2s-1.6-39.4 16.2-48.3c41.6-20.7 70-63.5 70-112.9s-28.4-92.3-70-112.9c-17.8-8.8-25.1-30.5-16.2-48.3z"],
    "tag": [468, 540, [127991], "f02b", "M162 144a72 72 0 1 0 0 144 72 72 0 1 0 0-144zm36 72a36 36 0 1 1 -72 0 36 36 0 1 1 72 0zM72 54C32.2 54 0 86.2 0 126L0 288c0 19.1 7.6 37.4 21.1 50.9l162 162c28.1 28.1 73.7 28.1 101.8 0l162-162c28.1-28.1 28.1-73.7 0-101.8l-162-162C271.4 61.6 253.1 54 234 54L72 54zM36 126c0-19.9 16.1-36 36-36l162 0c9.5 0 18.7 3.8 25.5 10.5l162 162c14.1 14.1 14.1 36.9 0 50.9l-162 162c-14.1 14.1-36.9 14.1-50.9 0l-162-162C39.8 306.7 36 297.5 36 288l0-162z"],
    "compact-disc": [504, 540, [128191, 128192, 128440], "f51f", "M252 36a252 252 0 1 0 0 504 252 252 0 1 0 0-504zM213.7 75.4c12.4-2.2 25.3-3.4 38.3-3.4 119.3 0 216 96.7 216 216 0 32.9-7.4 64.1-20.5 92.1L337.4 316.5c3-9 4.6-18.6 4.6-28.5 0-51.2-44.5-92.9-95.4-89.8L213.7 75.4zm-34.8 9.3l32.9 122.8c-10.4 5.2-19.6 12.3-27.2 20.9L74.6 164.8C100 128.3 136.3 100 178.9 84.7zM56.5 195.9l110.1 63.6c-3 9-4.6 18.6-4.6 28.5 0 51.2 44.5 92.9 95.4 89.8l32.9 122.8c-12.4 2.2-25.3 3.4-38.3 3.4-119.3 0-216-96.7-216-216 0-32.9 7.4-64.1 20.5-92.1zM325.1 491.3L292.2 368.5c10.4-5.2 19.6-12.3 27.2-20.9l110.1 63.5C404 447.7 367.7 476 325.1 491.3zM252 342a54 54 0 1 1 0-108 54 54 0 1 1 0 108z"],
    "phone-slash": [504, 540, [], "f3dd", "M123.4 518.9C95.3 547 49.7 547 21.6 518.9s-28.1-73.7 0-101.8l55.6-55.6c-37.1-56.2-58.6-123.6-58.6-195.9 0-25.4 10.5-49.1 32.1-63.5l54-36c28.6-19 66.6-15.3 90.8 9l45 45c15.7 15.7 22.6 36.9 20.8 57.4L381.6 57.1c28.1-28.1 73.7-28.1 101.8 0s28.1 73.7 0 101.8L363 279.3c20.5-1.8 41.7 5.1 57.4 20.8l45 45c24.3 24.3 28 62.3 9 90.8l-36 54c-14.4 21.6-38.1 32.1-63.5 32.1-72.4 0-139.7-21.6-195.9-58.6l-55.6 55.6zM205 437.3c49.2 30.9 107.5 48.7 169.9 48.7 13.4 0 25.8-4.4 33.6-16l36-54c9.5-14.3 7.6-33.3-4.5-45.4l-45-45c-14.1-14.1-36.9-14.1-50.9 0l-59.1 59.1c-5.5 5.5-13.8 6.8-20.8 3.4-2.2-1.1-4.4-2.2-6.5-3.4L205 437.3zM155.9 282.8c-1.2-2.2-2.3-4.3-3.4-6.5-3.5-6.9-2.1-15.3 3.4-20.8L215 196.5c14.1-14.1 14.1-36.9 0-50.9l-45-45c-12.1-12.1-31.1-14-45.4-4.5l-54 36c-11.6 7.7-16 20.2-16 33.6 0 62.4 17.8 120.6 48.7 169.9l52.7-52.7zM47 493.5c14.1 14.1 36.9 14.1 50.9 0l360-360c14.1-14.1 14.1-36.9 0-50.9s-36.9-14.1-50.9 0L47 442.5C33 456.6 33 479.4 47 493.5z"],
    "arrow-up-right-from-square": [432, 540, ["external-link"], "f08e", "M432 216c0 26.8-14.8 51.1-38.1 63.5 1.4 5.6 2.1 11.4 2.1 17.5 0 45 0 90 0 135 0 39.8-32.2 72-72 72L72 504c-39.2 0-72-32.8-72-72 0-96 0-156 0-252 0-39.8 32.2-72 72-72l99 0c18.1 0 34.7 6.7 47.3 17.8 .8-3.1 1.9-6.3 3.1-9.3 11.1-26.9 37.4-44.4 66.5-44.4l72 0c39.2 0 72 32.8 72 72l0 72zM360 108l-72 0c-14.6 0-27.7 8.8-33.3 22.2-5.3 12.8-2.8 27.5 6.4 37.7 6.4 7.1 6 18-.7 24.7L154.6 298.5c-14.1 14.1-14.1 36.9 0 50.9s36.9 14.1 50.9 0L311.3 243.6c6.7-6.7 17.6-7.1 24.7-.7 10.3 9.2 24.9 11.7 37.7 6.4 13.4-5.6 22.2-18.6 22.2-33.2l0-72.1c0-19.6-16.4-36-36-36zM36 432c.1 19.6 16.4 36 36 36l252 0c19.9 0 36-16.1 36-36l0-99c0-19.9-16.1-36-36-36s-36 16.1-36 36l0 45c0 9.9-8.1 18-18 18l-144 0c-9.8 0-18-8.2-18-18l0-144c0-9.9 8.1-18 18-18l45 0c19.9 0 36-16.1 36-36s-16.1-36-36-36l-99 0c-19.9 0-36 16.1-36 36l0 252z"],
    "rectangle-tall": [324, 540, [], "e791", "M0 90C0 50.2 32.2 18 72 18l180 0c39.8 0 72 32.2 72 72l0 396c0 39.8-32.2 72-72 72L72 558c-39.8 0-72-32.2-72-72L0 90zM72 54C52.1 54 36 70.1 36 90l0 396c0 19.9 16.1 36 36 36l180 0c19.9 0 36-16.1 36-36l0-396c0-19.9-16.1-36-36-36L72 54z"],
    "compass": [504, 540, [129517], "f14e", "M252 315a27 27 0 1 0 0-54 27 27 0 1 0 0 54zm42.2-164.5c27.3-12.4 59.5-6.6 80.7 14.6s27.1 53.4 14.6 80.7l-45 99c-7.2 15.8-19.9 28.5-35.8 35.8l-99 45c-27.3 12.4-59.5 6.6-80.7-14.6s-27.1-53.4-14.6-80.7l45-99c7.2-15.8 19.9-28.5 35.8-35.8l99-45zm55.2 40.1c-10.6-10.6-26.7-13.5-40.4-7.3l-99 45c-7.9 3.6-14.3 10-17.9 17.9l-45 99c-6.2 13.7-3.3 29.7 7.3 40.4s26.7 13.5 40.4 7.3l99-45c7.9-3.6 14.3-10 17.9-17.9l45-99c6.2-13.7 3.3-29.7-7.3-40.4zM504 288a252 252 0 1 1 -504 0 252 252 0 1 1 504 0zM252 72a216 216 0 1 0 0 432 216 216 0 1 0 0-432z"],
    "square": [432, 540, [9632, 9723, 9724, 61590], "f0c8", "M0 144c0-39.8 32.2-72 72-72l288 0c39.8 0 72 32.2 72 72l0 288c0 39.8-32.2 72-72 72L72 504c-39.8 0-72-32.2-72-72L0 144zm72-36c-19.9 0-36 16.1-36 36l0 288c0 19.9 16.1 36 36 36l288 0c19.9 0 36-16.1 36-36l0-288c0-19.9-16.1-36-36-36L72 108z"],
    "face-grin": [504, 540, [128512, "grin"], "f580", "M162 216c0-9.9 8.1-18 18-18s18 8.1 18 18 8.1 18 18 18 18-8.1 18-18c0-29.8-24.2-54-54-54s-54 24.2-54 54c0 9.9 8.1 18 18 18s18-8.1 18-18zm162-18c-9.9 0-18 8.1-18 18s-8.1 18-18 18-18-8.1-18-18c0-29.8 24.2-54 54-54s54 24.2 54 54c0 9.9-8.1 18-18 18s-18-8.1-18-18-8.1-18-18-18zM154.1 276.9c-11.4-2.6-23.1 .3-31.6 7.2-8.8 7.1-14.4 18.9-11.7 32.2 13.2 66 71.4 115.7 141.2 115.7s128-49.7 141.2-115.7c2.7-13.3-3-25.1-11.7-32.2-8.5-6.9-20.2-9.8-31.6-7.2-21.6 5-56.7 11.1-97.9 11.1s-76.3-6.1-97.9-11.1zM252 396c-51.3 0-94.3-35.8-105.3-83.9 23.5 5.3 61.1 11.9 105.3 11.9s81.8-6.5 105.3-11.9c-11 48-54 83.9-105.3 83.9zm0-360a252 252 0 1 0 0 504 252 252 0 1 0 0-504zM468 288a216 216 0 1 1 -432 0 216 216 0 1 1 432 0z"],
    "angle-up": [432, 540, [8963], "f106", "M165.6 147.1c28.1-28.1 73.7-28.1 101.8 0l144 144c28.1 28.1 28.1 73.7 0 101.8s-73.7 28.1-101.8 0l-93.1-93.1-93.1 93.1C95.3 421 49.7 421 21.6 392.9s-28.1-73.7 0-101.8l144-144zM242 172.5c-14.1-14.1-36.9-14.1-50.9 0L47 316.5C33 330.6 33 353.4 47 367.5s36.9 14.1 50.9 0L203.8 261.6c3.4-3.4 8-5.3 12.7-5.3s9.4 1.9 12.7 5.3L335 367.5c14.1 14.1 36.9 14.1 50.9 0s14.1-36.9 0-50.9l-144-144z"],
    "face-smile": [504, 540, [128578, "smile"], "f118", "M144 288c0-9.9-8.1-18-18-18s-18 8.1-18 18c0 79.5 64.5 144 144 144s144-64.5 144-144c0-9.9-8.1-18-18-18s-18 8.1-18 18c0 59.6-48.4 108-108 108S144 347.6 144 288zm18-81a27 27 0 1 1 54 0 27 27 0 1 1 -54 0zm153 27a27 27 0 1 0 0-54 27 27 0 1 0 0 54zM252 36a252 252 0 1 0 0 504 252 252 0 1 0 0-504zM468 288a216 216 0 1 1 -432 0 216 216 0 1 1 432 0z"],
    "umbrella": [504, 540, [], "f0e9", "M324 306l0 108c0 69.6-56.4 126-126 126S72 483.6 72 414c0-39.8 32.2-72 72-72 13.1 0 25.4 3.5 36 9.6l0-45.6-126 0C24.2 306 0 281.8 0 252 0 182 28.6 127.2 75.4 90.4 121.7 54 184.4 36 252 36S382.3 54 428.6 90.4c46.8 36.8 75.4 91.6 75.4 161.6 0 29.8-24.2 54-54 54l-126 0zM36 252c0 9.9 8.1 18 18 18l91 0c1.6-22 5.4-62.1 14-102.7 6.5-30.7 15.1-62.2 31.3-89.3-36 7.3-67.6 21.1-92.6 40.7-37.9 29.9-61.7 74.1-61.7 133.3zm286.9 18c-1.6-21.6-5.3-58.6-13.1-95.3-6.1-28.6-14.3-55.8-25.3-75.4-11.2-20.1-22.3-27.3-32.5-27.3s-21.3 7.2-32.5 27.3c-10.9 19.6-19.2 46.8-25.3 75.4-7.8 36.6-11.5 73.7-13.1 95.3l141.7 0zM313.7 77.9c16.2 27.1 24.8 58.7 31.3 89.3 8.6 40.6 12.4 80.7 14 102.7l91 0c9.9 0 18-8.1 18-18 0-59.2-23.7-103.4-61.7-133.3-25-19.7-56.6-33.5-92.6-40.7zM216 306l0 107.9c0 9.9-8.1 18-18 18s-18-8-18-18c0-19.9-16.1-36-36-36-19.9 0-36 16.1-36 36 0 49.7 40.3 90 90 90s90-40.3 90-90l0-108-72 0z"],
    "briefcase": [504, 540, [128188], "f0b1", "M126 126l0-18c0-39.8 32.2-72 72-72l108 0c39.8 0 72 32.2 72 72l0 18 54 0c39.8 0 72 32.2 72 72l0 216c0 39.8-32.2 72-72 72L72 486c-39.8 0-72-32.2-72-72L0 198c0-39.8 32.2-72 72-72l54 0zm36-18l0 18 180 0 0-18c0-19.9-16.1-36-36-36L198 72c-19.9 0-36 16.1-36 36zM36 198l0 43.2c9.7 4.8 27.2 12.8 51.2 20.7 21.8 7.2 49 14.5 80.7 19.5 8.9-17.5 27.1-29.4 48.1-29.4l72 0c21 0 39.2 12 48.1 29.4 31.7-5 58.9-12.3 80.7-19.5 24-8 41.5-15.9 51.2-20.7l0-43.2c0-19.9-16.1-36-36-36L72 162c-19.9 0-36 16.1-36 36zm0 82.9L36 414c0 19.9 16.1 36 36 36l360 0c19.9 0 36-16.1 36-36l0-133.1c-10.5 4.6-23.9 9.9-39.9 15.2-23.6 7.8-53 15.7-87.3 21-5.1 24.5-26.8 42.9-52.9 42.9l-72 0c-26 0-47.7-18.4-52.9-42.9-34.2-5.4-63.6-13.2-87.3-21-16-5.3-29.4-10.6-39.9-15.2zM216 288c-9.9 0-18 8.1-18 18s8.1 18 18 18l72 0c9.9 0 18-8.1 18-18s-8.1-18-18-18l-72 0z"],
    "pause": [432, 540, [9208], "f04c", "M72 72C32.2 72 0 104.2 0 144L0 432c0 39.8 32.2 72 72 72l54 0c39.8 0 72-32.2 72-72l0-288c0-39.8-32.2-72-72-72L72 72zM36 144c0-19.9 16.1-36 36-36l54 0c19.9 0 36 16.1 36 36l0 288c0 19.9-16.1 36-36 36l-54 0c-19.9 0-36-16.1-36-36l0-288zM306 72c-39.8 0-72 32.2-72 72l0 288c0 39.8 32.2 72 72 72l54 0c39.8 0 72-32.2 72-72l0-288c0-39.8-32.2-72-72-72l-54 0zm-36 72c0-19.9 16.1-36 36-36l54 0c19.9 0 36 16.1 36 36l0 288c0 19.9-16.1 36-36 36l-54 0c-19.9 0-36-16.1-36-36l0-288z"],
    "desktop": [432, 540, [128421, 61704, "desktop-alt"], "f390", "M108 162c-9.9 0-18 8.1-18 18l0 126c0 9.9 8.1 18 18 18l216 0c9.9 0 18-8.1 18-18l0-126c0-9.9-8.1-18-18-18l-216 0zm18 126l0-90 180 0 0 90-180 0zM350.4 414l9.6 0c39.8 0 72-32.2 72-72l0-198c0-39.8-32.2-72-72-72L72 72C32.2 72 0 104.2 0 144L0 342c0 39.8 32.2 72 72 72l9.6 0c-6.1 10.6-9.6 22.9-9.6 36 0 39.8 32.2 72 72 72l144 0c39.8 0 72-32.2 72-72 0-13.1-3.5-25.4-9.6-36zM72 108l288 0c19.9 0 36 16.1 36 36l0 198c0 19.9-16.1 36-36 36l-90 0c-9.9 0-18 8.1-18 18s8.1 18 18 18l18 0c19.9 0 36 16.1 36 36s-16.1 36-36 36l-144 0c-19.9 0-36-16.1-36-36s16.1-36 36-36l18 0c9.9 0 18-8.1 18-18s-8.1-18-18-18l-90 0c-19.9 0-36-16.1-36-36l0-198c0-19.9 16.1-36 36-36z"],
    "arrow-down": [468, 540, [8595], "f063", "M446.9 356.9c28.1-28.1 28.1-73.7 0-101.8s-73.7-28.1-101.8 0L306 294.2 306 108c0-39.8-32.2-72-72-72s-72 32.2-72 72l0 186.2-39.1-39.1C94.8 227 49.2 227 21.1 255.1s-28.1 73.7 0 101.8l162 162c28.1 28.1 73.7 28.1 101.8 0l162-162zm-25.5-76.4c14.1 14.1 14.1 36.9 0 50.9l-162 162c-14.1 14.1-36.9 14.1-50.9 0l-162-162c-14.1-14.1-14.1-36.9 0-50.9s36.9-14.1 50.9 0l69.8 69.8c5.1 5.1 12.9 6.7 19.6 3.9s11.1-9.3 11.1-16.6L198 108c0-19.9 16.1-36 36-36s36 16.1 36 36l0 229.6c0 7.3 4.4 13.8 11.1 16.6s14.5 1.2 19.6-3.9l69.8-69.8c14.1-14.1 36.9-14.1 50.9 0z"],
    "location-dot": [360, 540, ["map-marker-alt"], "f3c5", "M180 162a72 72 0 1 0 0 144 72 72 0 1 0 0-144zm36 72a36 36 0 1 1 -72 0 36 36 0 1 1 72 0zM180 54c-99.4 0-180 80.6-180 180 0 63.7 26 126 55.3 176.4 29.4 50.6 63.3 90.8 81.1 110.6 11.4 12.6 27.4 19 43.6 19s32.2-6.4 43.6-19c17.9-19.8 51.7-60 81.1-110.6 29.3-50.3 55.3-112.7 55.3-176.4 0-99.4-80.6-180-180-180zM36 234c0-79.5 64.5-144 144-144s144 64.5 144 144c0 54.5-22.5 110.3-50.4 158.2-27.7 47.7-59.8 85.8-76.7 104.6-4 4.5-10 7.1-16.9 7.1s-12.8-2.6-16.9-7.1c-16.9-18.8-49-57-76.7-104.6-27.9-47.9-50.4-103.8-50.4-158.2z"],
    "bars": [504, 540, ["navicon"], "f0c9", "M0 162c0-39.8 32.2-72 72-72l360 0c39.8 0 72 32.2 72 72 0 27.1-15 50.7-37.1 63 22.1 12.3 37.1 35.9 37.1 63s-15 50.7-37.1 63c22.1 12.3 37.1 35.9 37.1 63 0 39.8-32.2 72-72 72L72 486C32.2 486 0 453.8 0 414 0 386.9 15 363.3 37.1 351 15 338.7 0 315.1 0 288s15-50.7 37.1-63C15 212.7 0 189.1 0 162zm72-36c-19.9 0-36 16.1-36 36s16.1 36 36 36l360 0c19.9 0 36-16.1 36-36s-16.1-36-36-36L72 126zm0 126c-19.9 0-36 16.1-36 36s16.1 36 36 36l360 0c19.9 0 36-16.1 36-36s-16.1-36-36-36L72 252zm0 126c-19.9 0-36 16.1-36 36s16.1 36 36 36l360 0c19.9 0 36-16.1 36-36s-16.1-36-36-36L72 378z"],
    "battery-empty": [576, 540, ["battery-0"], "f244", "M144 216c0-9.9 8.1-18 18-18l234 0c9.9 0 18 8.1 18 18l0 144c0 9.9-8.1 18-18 18l-234 0c-9.9 0-18-8.1-18-18l0-144zm36 18l0 108 198 0 0-108-198 0zM36 162c0-39.8 32.2-72 72-72l342 0c39.8 0 72 32.2 72 72l0 20.3c31.1 8 54 36.2 54 69.7l0 72c0 33.5-22.9 61.7-54 69.7l0 20.3c0 39.8-32.2 72-72 72l-342 0c-39.8 0-72-32.2-72-72l0-252zm72-36c-19.9 0-36 16.1-36 36l0 252c0 19.9 16.1 36 36 36l342 0c19.9 0 36-16.1 36-36l0-36c0-9.9 8.1-18 18-18 19.9 0 36-16.1 36-36l0-72c0-19.9-16.1-36-36-36-9.9 0-18-8.1-18-18l0-36c0-19.9-16.1-36-36-36l-342 0z"],
    "stopwatch": [468, 540, [9201], "f2f2", "M234 252c9.9 0 18 8.1 18 18l0 72c0 9.9-8.1 18-18 18s-18-8.1-18-18l0-72c0-9.9 8.1-18 18-18zM180 36c-39.8 0-72 32.2-72 72 0 24.9 12.6 46.8 31.8 59.8-61.8 33.5-103.8 99-103.8 174.2 0 109.4 88.6 198 198 198s198-88.6 198-198c0-14.6-1.6-28.8-4.6-42.4l8.5-5.7c33.1-22.1 42-66.8 20-99.8s-66.8-42-99.8-20l-8.5 5.7c-6.2-4.4-12.7-8.4-19.4-12 19.2-12.9 31.8-34.9 31.8-59.8 0-39.8-32.2-72-72-72L180 36zM376 204c16.5-11 38.9-6.6 49.9 10 11 16.5 6.6 38.9-9.9 49.9-9.6-22.4-23.2-42.7-40-59.9zm-88-60l-108 0c-19.9 0-36-16.1-36-36s16.1-36 36-36l108 0c19.9 0 36 16.1 36 36s-16.1 36-36 36zM234 504a162 162 0 1 1 0-324 162 162 0 1 1 0 324z"],
    "train": [432, 540, [128646], "f238", "M153 378a27 27 0 1 0 0-54 27 27 0 1 0 0 54zm99-27a27 27 0 1 1 54 0 27 27 0 1 1 -54 0zM36 126c0-39.8 32.2-72 72-72l216 0c39.8 0 72 32.2 72 72l0 252c0 6.7-.9 13.2-2.7 19.4l20.2 22.4c26.6 29.6 24.2 75.1-5.4 101.7s-75.1 24.2-101.7-5.4l-59.5-66.2-61.9 0-59.5 66.2c-26.6 29.6-72.1 32-101.7 5.4s-32-72.1-5.4-101.7l20.2-22.4C36.9 391.2 36 384.7 36 378l0-252zM58 429.8L45.2 443.9c-13.3 14.8-12.1 37.5 2.7 50.8s37.5 12.1 50.8-2.7l37.9-42.1-28.6 0c-19.4 0-37.1-7.7-50-20.2zM295.4 450l37.9 42.1c13.3 14.8 36.1 16 50.8 2.7s16-36.1 2.7-50.8L374 429.8c-13 12.5-30.6 20.2-50 20.2l-28.6 0zM108 90c-19.9 0-36 16.1-36 36l0 126 126 0 0-162-90 0zM72 378c0 19.9 16.1 36 36 36l216 0c19.9 0 36-16.1 36-36l0-90-288 0 0 90zM234 252l126 0 0-126c0-19.9-16.1-36-36-36l-90 0 0 162z"],
    "gamepad": [504, 540, [], "f11b", "M65 201.2l-28 168.2c-1.2 7.2-.9 14.4-.9 21.6 0 32.6 26.4 59 59 59 20.7 0 39.9-10.9 50.6-28.6l31.6-52.6c3.3-5.4 9.1-8.7 15.4-8.7l118.9 0c6.3 0 12.2 3.3 15.4 8.7l31.6 52.6c10.7 17.8 29.9 28.6 50.6 28.6 32.6 0 59-26.4 59-59 0-7.2 .3-14.5-.9-21.6L439 201.2c-7.2-43.4-44.8-75.2-88.8-75.2l-196.5 0c-44 0-81.5 31.8-88.8 75.2zM502.6 363.4c.9 5.7 1.4 11.4 1.4 17.2l0 10.4c0 52.5-42.5 95-95 95-33.4 0-64.3-17.5-81.4-46.1l-26.3-43.9-98.5 0-26.3 43.9C159.3 468.5 128.4 486 95 486 42.5 486 0 443.5 0 391l0-10.3c0-5.8 .5-11.6 1.4-17.3l28-168.2C39.6 134.5 92.2 90 153.7 90l196.5 0c61.6 0 114.2 44.5 124.3 105.3l28 168.2zM342 270a27 27 0 1 1 0 54 27 27 0 1 1 0-54zm-81-27a27 27 0 1 1 54 0 27 27 0 1 1 -54 0zm135-27a27 27 0 1 1 0 54 27 27 0 1 1 0-54zm-81-27a27 27 0 1 1 54 0 27 27 0 1 1 -54 0zm-153 9l0 18 18 0c9.9 0 18 8.1 18 18s-8.1 18-18 18l-18 0 0 18c0 9.9-8.1 18-18 18s-18-8.1-18-18l0-18-18 0c-9.9 0-18-8.1-18-18s8.1-18 18-18l18 0 0-18c0-9.9 8.1-18 18-18s18 8.1 18 18z"],
    "ship": [504, 540, [128674], "f21a", "M108 126l0 69.8-17.5 4.4c-20.2 5-37.2 18.6-46.6 37.1s-10.5 40.2-2.7 59.5l31.5 78.9-18.2 4.5c-38.6 9.6-62 48.7-52.4 87.3s48.7 62 87.3 52.4L153 504 199.4 515.6c34.5 8.6 70.8 8.6 105.3 0 0 0 28.2-7 46.3-11.6 24.8 6.2 63.5 15.9 63.5 15.9 38.6 9.6 77.7-13.8 87.3-52.4s-13.8-77.7-52.4-87.3l-18.2-4.5 31.5-78.9c7.7-19.3 6.7-41-2.7-59.5s-26.5-32-46.6-37.1l-17.5-4.4 0-69.8c0-39.8-32.2-72-72-72L180 54c-39.8 0-72 32.2-72 72zm36 0c0-19.9 16.1-36 36-36l144 0c19.9 0 36 16.1 36 36l0 60.8-90.5-22.6c-11.5-2.9-23.5-2.9-34.9 0L144 186.8 144 126zM429.4 283.4l-33.4 83.4-9.9-2.5c-11.5-2.9-23.3-4.3-35.2-4.3s-23.7 1.5-35.2 4.3l-45.8 11.5 0-174.4 134.7 33.7c20.8 5.2 32.7 28.3 24.7 48.3zm-241.2 81c-11.5-2.9-23.3-4.3-35.2-4.3s-23.7 1.5-35.2 4.3l-9.9 2.5-33.4-83.4c-8-20 3.8-43.1 24.7-48.3l134.7-33.7 0 174.4-45.8-11.5zM153 396c8.9 0 17.8 1.1 26.5 3.3l46.1 11.5c8.6 2.1 17.6 3.2 26.5 3.2s17.9-1.1 26.5-3.2l46.1-11.5c8.7-2.2 17.5-3.3 26.5-3.3s17.8 1.1 26.5 3.3l63.3 15.8c19.3 4.8 31 24.4 26.2 43.7s-24.4 31-43.7 26.2L360 469.1c-5.9-1.5-12.1-1.5-18 0L296 480.6c-14.3 3.6-29.2 5.4-43.9 5.4s-29.6-1.8-43.9-5.4L162 469.1c-5.9-1.5-12.1-1.5-18 0L80.8 484.9c-19.3 4.8-38.8-6.9-43.7-26.2s6.9-38.8 26.2-43.7l63.3-15.8c8.7-2.2 17.5-3.3 26.5-3.3z"],
    "arrows-rotate": [504, 540, [128472, "refresh", "sync"], "f021", "M83.4 153c39.5-49.2 100.3-81 168.6-81 50 0 98.1 18.5 135.1 51.7 20.3-16.2 48-20.3 72.4-10.2 26.9 11.1 44.4 37.4 44.4 66.5l0 90c0 39.8-32.2 72-72 72l-5.2 0c14.4 24.9 12.9 57.2-6.2 81-39.5 49.2-100.3 81-168.6 81-50 0-98.1-18.5-135.1-51.7-20.3 16.2-48 20.3-72.4 10.2-26.9-11.1-44.4-37.4-44.4-66.5l0-90c0-39.8 32.2-72 72-72l5.2 0c-14.4-24.9-12.9-57.2 6.2-81zM72 270c-19.9 0-36 16.1-36 36l0 90c0 14.6 8.8 27.7 22.2 33.3s28.9 2.5 39.2-7.8l6.8-6.8c7-7 18.4-7 25.5 0l4.6 4.6c31.2 31.2 73.5 48.7 117.6 48.7 56.9 0 107.6-26.4 140.5-67.5 12.4-15.5 9.9-38.2-5.6-50.6-15.4-12.4-38.3-9.7-50.6 5.6-19.9 24.8-50.2 40.5-84.3 40.5-25 0-49-9.9-66.7-27.6-5-5-9.9-9.7-9.9-17.4 0-8.7 6.5-13.9 12.1-19.5 10.3-10.3 13.4-25.8 7.8-39.2S176.6 270 162 270l-90 0zm270 36l90 0c19.9 0 36-16.1 36-36l0-90c0-14.6-8.8-27.7-22.2-33.3s-28.9-2.5-39.2 7.8c-5.6 5.6-10.8 12.1-19.5 12.1-7.6 0-12.4-4.9-17.4-9.9-31.2-31.2-73.5-48.7-117.6-48.7-56.9 0-107.6 26.4-140.5 67.5-12.4 15.5-9.9 38.2 5.6 50.6 15.3 12.3 38.2 9.9 50.6-5.6 19.9-24.8 50.2-40.5 84.3-40.5 25 0 49 9.9 66.7 27.6l4.6 4.6c7 7 7 18.4 0 25.5l-6.8 6.8c-10.3 10.3-13.4 25.8-7.8 39.2S327.4 306 342 306zM196.1 242.6c14.3 7.7 25.9 20.2 32.4 35.9 9.9 24 6.1 51.2-9.4 71.4 9.6 6.6 21.1 10.2 32.9 10.2 22.5 0 42.6-10.3 55.9-26.6-14.3-7.7-25.9-20.2-32.4-35.9-9.9-24-6.1-51.2 9.4-71.4-9.6-6.6-21.1-10.2-32.9-10.2-22.5 0-42.6 10.3-55.9 26.6z"],
    "book-open": [504, 540, [128214, 128366], "f518", "M110 80.5c23.4-12.5 51.8-11.2 73.9 3.6l68.1 45.4 68.1-45.4c22.1-14.7 50.5-16.1 73.9-3.6 18 9.6 30.8 26.3 35.7 45.5 40.1 0 74.3 31 74.3 72l0 216c0 39.8-32.2 72-72 72L72 486c-39.8 0-72-32.2-72-72L0 198c0-41 34.2-72 74.3-72 5-19.2 17.8-35.9 35.7-45.5zM468 414l0-216c0-19.9-16.1-36-36-36l0 180c0 24.1-12 46.6-32.1 59.9L327.8 450 432 450c19.9 0 36-16.1 36-36zM340 114L270 160.8 270 445.2 380 372c10-6.7 16-17.9 16-30l0-198c0-13.3-7.3-25.5-19-31.7s-25.9-5.6-37 1.8zM108 144l0 198c0 12 6 23.3 16 30l110 73.2 0-284.4-70.1-46.7c-11-7.4-25.3-8.1-37-1.8s-19 18.5-19 31.7zM72 162c-19.9 0-36 16.1-36 36l0 216c0 19.9 16.1 36 36 36l104.2 0-72.1-48.1C84 388.6 72 366.1 72 342l0-180z"],
    "box-archive": [504, 540, ["archive"], "f187", "M198 270c-9.9 0-18 8.1-18 18s8.1 18 18 18l108 0c9.9 0 18-8.1 18-18s-8.1-18-18-18l-108 0zM0 144c0-39.8 32.2-72 72-72l360 0c39.8 0 72 32.2 72 72 0 26.7-14.5 49.9-36 62.4L468 432c0 39.8-32.2 72-72 72l-288 0c-39.8 0-72-32.2-72-72l0-225.6C14.5 193.9 0 170.7 0 144zm468 0c0-19.9-16.1-36-36-36L72 108c-19.9 0-36 16.1-36 36s16.1 36 36 36l360 0c19.9 0 36-16.1 36-36zM72 432c0 19.9 16.1 36 36 36l288 0c19.9 0 36-16.1 36-36l0-216-360 0 0 216z"],
    "cake-candles": [432, 540, [127874, "birthday-cake", "cake"], "f1fd", "M117.1 56.5c-5.6-3.3-12.5-3.3-18.1 0-3.4 2-6.6 4.2-9.8 6.4-5.6 3.9-13.1 9.7-20.6 17-14.3 13.7-32.5 36.2-32.5 64.2 0 21.5 9.4 40.8 24.4 54-14.9 13.2-24.4 32.5-24.4 54l0 9.6C14.5 274.1 0 297.3 0 324L0 432c0 39.8 32.2 72 72 72l288 0c39.8 0 72-32.2 72-72l0-108c0-26.7-14.5-49.9-36-62.4l0-9.6c0-21.5-9.4-40.8-24.4-54 14.9-13.2 24.4-32.5 24.4-54 0-28-18.2-50.5-32.5-64.2-7.6-7.2-15-13-20.6-17-3.2-2.2-6.4-4.4-9.8-6.4-5.6-3.3-12.5-3.3-18.1 0-3.3 2-6.6 4.2-9.8 6.4-5.6 3.9-13.1 9.7-20.6 17-4.7 4.5-9.8 9.9-14.5 16.2-4.7-6.3-9.9-11.7-14.5-16.2-7.6-7.2-15-13-20.6-17-3.2-2.2-6.4-4.4-9.8-6.4-5.6-3.3-12.5-3.3-18.1 0-3.3 2-6.6 4.2-9.8 6.4-5.6 3.9-13.1 9.7-20.6 17-4.7 4.5-9.8 9.9-14.5 16.2-4.7-6.3-9.9-11.7-14.5-16.2-7.6-7.2-15-13-20.6-17-3.2-2.2-6.4-4.4-9.8-6.4zM396 345l-58.5 10.6c-14.9 2.7-30.2 2.7-45.1 0L245 347c-19.2-3.5-38.8-3.5-58 0l-47.5 8.6c-14.9 2.7-30.2 2.7-45.1 0L36 345 36 324c0-15.6 10-29 24-34 7.2-2.5 12-9.3 12-17L72 252c0-19.9 16.1-36 36-36s36 16.1 36 36l0 18c0 9.9 8.1 18 18 18s18-8.1 18-18l0-18c0-19.9 16.1-36 36-36s36 16.1 36 36l0 18c0 9.9 8.1 18 18 18s18-8.1 18-18l0-18c0-19.9 16.1-36 36-36s36 16.1 36 36l0 21.1c0 7.6 4.8 14.4 12 17 14 5 24 18.3 24 34l0 21zM36 381.6L88 391c19.2 3.5 38.8 3.5 58 0l47.5-8.6c14.9-2.7 30.2-2.7 45.1 0L286 391c19.2 3.5 38.8 3.5 58 0l52-9.5 0 50.4c0 19.9-16.1 36-36 36L72 468c-19.9 0-36-16.1-36-36l0-50.4zM360 144c0 19.9-16.1 36-36 36s-36-16.1-36-36c0-12.5 8.8-26 21.5-38.2 5.1-4.9 10.3-9 14.5-12.1 4.2 3.1 9.4 7.2 14.5 12.1 12.7 12.2 21.5 25.6 21.5 38.2zM230.5 105.8c12.7 12.2 21.5 25.6 21.5 38.2 0 19.9-16.1 36-36 36s-36-16.1-36-36c0-12.5 8.8-26 21.5-38.2 5.1-4.9 10.3-9 14.5-12.1 4.2 3.1 9.4 7.2 14.5 12.1zM144 144c0 19.9-16.1 36-36 36s-36-16.1-36-36c0-12.5 8.8-26 21.5-38.2 5.1-4.9 10.3-9 14.5-12.1 4.2 3.1 9.4 7.2 14.5 12.1 12.7 12.2 21.5 25.6 21.5 38.2z"],
    "signal-bars-good": [468, 540, ["signal-alt-3"], "f693", "M288 504c-21.5 0-40.8-9.4-54-24.4-13.2 14.9-32.5 24.4-54 24.4s-40.8-9.4-54-24.4c-13.2 14.9-32.5 24.4-54 24.4-39.8 0-72-32.2-72-72l0-72c0-39.8 32.2-72 72-72 13.1 0 25.4 3.5 36 9.6l0-9.6c0-39.8 32.2-72 72-72 13.1 0 25.4 3.5 36 9.6l0-9.6c0-39.8 32.2-72 72-72s72 32.2 72 72l0 216c0 39.8-32.2 72-72 72zM144 432c0 19.9 16.1 36 36 36s36-16.1 36-36l0-144c0-19.9-16.1-36-36-36s-36 16.1-36 36l0 144zm-36-72c0-19.9-16.1-36-36-36s-36 16.1-36 36l0 72c0 19.9 16.1 36 36 36s36-16.1 36-36l0-72zM288 468c19.9 0 36-16.1 36-36l0-216c0-19.9-16.1-36-36-36s-36 16.1-36 36l0 216c0 19.9 16.1 36 36 36z"],
    "circle-info": [504, 540, ["info-circle"], "f05a", "M162 252c0-9.9 8.1-18 18-18l36 0c29.8 0 54 24.2 54 54l0 90 54 0c9.9 0 18 8.1 18 18s-8.1 18-18 18l-144 0c-9.9 0-18-8.1-18-18s8.1-18 18-18l54 0 0-90c0-9.9-8.1-18-18-18l-36 0c-9.9 0-18-8.1-18-18zm90-54a27 27 0 1 0 0-54 27 27 0 1 0 0 54zm252 90a252 252 0 1 1 -504 0 252 252 0 1 1 504 0zM252 72a216 216 0 1 0 0 432 216 216 0 1 0 0-432z"],
    "layer-group": [504, 540, [], "f5fd", "M0 198c0-27.3 15.4-52.2 39.8-64.4l180-90c20.3-10.1 44.1-10.1 64.4 0l180 90C488.6 145.8 504 170.7 504 198s-15.4 52.2-39.8 64.4L413 288 464.2 313.6C488.6 325.8 504 350.7 504 378s-15.4 52.2-39.8 64.4l-180 90c-20.3 10.1-44.1 10.1-64.4 0l-180-90C15.4 430.2 0 405.3 0 378s15.4-52.2 39.8-64.4L91 288 39.8 262.4C15.4 250.2 0 225.3 0 198zM235.9 75.8l-180 90C43.7 171.9 36 184.4 36 198s7.7 26.1 19.9 32.2l180 90c10.1 5.1 22.1 5.1 32.2 0l180-90c12.2-6.1 19.9-18.6 19.9-32.2s-7.7-26.1-19.9-32.2l-180-90c-10.1-5.1-22.1-5.1-32.2 0zM131.3 308.1L55.9 345.8C43.7 351.9 36 364.4 36 378s7.7 26.1 19.9 32.2l180 90c10.1 5.1 22.1 5.1 32.2 0l180-90c12.2-6.1 19.9-18.6 19.9-32.2s-7.7-26.1-19.9-32.2l-75.4-37.7-88.5 44.3c-20.3 10.1-44.1 10.1-64.4 0l-88.5-44.3z"],
    "shield": [432, 540, [128737, "shield-blank"], "f132", "M39.8 133.6C15.4 145.8 0 170.7 0 198 0 414.8 140.4 496.4 176.9 513.4 190.9 520 204.6 522 216 522s25.1-2 39.1-8.6c36.5-17.1 176.9-98.7 176.9-315.4 0-27.3-15.4-52.2-39.8-64.4l-144-72c-20.3-10.1-44.1-10.1-64.4 0l-144 72zM234 94.8l142.1 71c12.2 6.1 19.9 18.6 19.9 32.2 0 105.3-50.2 247.9-162 285.1l0-388.4zM198 483.1C86.2 445.9 36 303.3 36 198 36 184.4 43.7 171.9 55.9 165.8l142.1-71 0 388.4z"],
    "cart-shopping": [540, 540, [128722, "shopping-cart"], "f07a", "M142.9 403.7c-10.5 12.5-16.9 28.7-16.9 46.3 0 39.8 32.2 72 72 72s72-32.2 72-72c0-13.1-3.5-25.4-9.6-36l73.3 0c-6.1 10.6-9.6 22.9-9.6 36 0 39.8 32.2 72 72 72s72-32.2 72-72c0-17.6-6.3-33.8-16.9-46.3 16.9-10.2 29.4-27.1 33.5-47.6l36-180c4.2-21.2-1.2-43.1-14.9-59.8S471.6 90 450 90L72 90C32.2 90 0 122.2 0 162s32.2 72 72 72l13 0 24.4 122.1c4.1 20.4 16.6 37.4 33.5 47.6zM36 162c0-19.9 16.1-36 36-36l378 0c10.8 0 21 4.8 27.8 13.2s9.6 19.3 7.5 29.9l-36 180C445.9 365.9 431.2 378 414 378l-234 0c-17.2 0-31.9-12.1-35.3-28.9L117.4 212.5c-1.7-8.4-9.1-14.5-17.7-14.5L72 198c-19.9 0-36-16.1-36-36zM396 486a36 36 0 1 1 0-72 36 36 0 1 1 0 72zm-198 0a36 36 0 1 1 0-72 36 36 0 1 1 0 72z"]
  };

  bunker(function () {
    defineIcons('faslpr', icons);
  });

}());
