/*!
 * Font Awesome Pro 7.1.0 by @fontawesome - https://fontawesome.com
 * License - https://fontawesome.com/license (Commercial License)
 * Copyright 2025 Fonticons, Inc.
 */
(function () {
  'use strict';

  var _WINDOW = {};
  var _DOCUMENT = {};
  try {
    if (typeof window !== 'undefined') _WINDOW = window;
    if (typeof document !== 'undefined') _DOCUMENT = document;
  } catch (e) {} // eslint-disable-line no-empty

  var _ref = _WINDOW.navigator || {},
    _ref$userAgent = _ref.userAgent,
    userAgent = _ref$userAgent === void 0 ? '' : _ref$userAgent;
  var WINDOW = _WINDOW;
  var DOCUMENT = _DOCUMENT;
  var IS_BROWSER = !!WINDOW.document;
  var IS_DOM = !!DOCUMENT.documentElement && !!DOCUMENT.head && typeof DOCUMENT.addEventListener === 'function' && typeof DOCUMENT.createElement === 'function';
  var IS_IE = ~userAgent.indexOf('MSIE') || ~userAgent.indexOf('Trident/');

  function _arrayLikeToArray(r, a) {
    (null == a || a > r.length) && (a = r.length);
    for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e];
    return n;
  }
  function _arrayWithoutHoles(r) {
    if (Array.isArray(r)) return _arrayLikeToArray(r);
  }
  function _defineProperty(e, r, t) {
    return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, {
      value: t,
      enumerable: !0,
      configurable: !0,
      writable: !0
    }) : e[r] = t, e;
  }
  function _iterableToArray(r) {
    if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r);
  }
  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }
  function ownKeys(e, r) {
    var t = Object.keys(e);
    if (Object.getOwnPropertySymbols) {
      var o = Object.getOwnPropertySymbols(e);
      r && (o = o.filter(function (r) {
        return Object.getOwnPropertyDescriptor(e, r).enumerable;
      })), t.push.apply(t, o);
    }
    return t;
  }
  function _objectSpread2(e) {
    for (var r = 1; r < arguments.length; r++) {
      var t = null != arguments[r] ? arguments[r] : {};
      r % 2 ? ownKeys(Object(t), !0).forEach(function (r) {
        _defineProperty(e, r, t[r]);
      }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) {
        Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r));
      });
    }
    return e;
  }
  function _toConsumableArray(r) {
    return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread();
  }
  function _toPrimitive(t, r) {
    if ("object" != typeof t || !t) return t;
    var e = t[Symbol.toPrimitive];
    if (void 0 !== e) {
      var i = e.call(t, r || "default");
      if ("object" != typeof i) return i;
      throw new TypeError("@@toPrimitive must return a primitive value.");
    }
    return ("string" === r ? String : Number)(t);
  }
  function _toPropertyKey(t) {
    var i = _toPrimitive(t, "string");
    return "symbol" == typeof i ? i : i + "";
  }
  function _unsupportedIterableToArray(r, a) {
    if (r) {
      if ("string" == typeof r) return _arrayLikeToArray(r, a);
      var t = {}.toString.call(r).slice(8, -1);
      return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0;
    }
  }

  var _dt;
  var q = {
      classic: {
        fa: "solid",
        fas: "solid",
        "fa-solid": "solid",
        far: "regular",
        "fa-regular": "regular",
        fal: "light",
        "fa-light": "light",
        fat: "thin",
        "fa-thin": "thin",
        fab: "brands",
        "fa-brands": "brands"
      },
      duotone: {
        fa: "solid",
        fad: "solid",
        "fa-solid": "solid",
        "fa-duotone": "solid",
        fadr: "regular",
        "fa-regular": "regular",
        fadl: "light",
        "fa-light": "light",
        fadt: "thin",
        "fa-thin": "thin"
      },
      sharp: {
        fa: "solid",
        fass: "solid",
        "fa-solid": "solid",
        fasr: "regular",
        "fa-regular": "regular",
        fasl: "light",
        "fa-light": "light",
        fast: "thin",
        "fa-thin": "thin"
      },
      "sharp-duotone": {
        fa: "solid",
        fasds: "solid",
        "fa-solid": "solid",
        fasdr: "regular",
        "fa-regular": "regular",
        fasdl: "light",
        "fa-light": "light",
        fasdt: "thin",
        "fa-thin": "thin"
      },
      slab: {
        "fa-regular": "regular",
        faslr: "regular"
      },
      "slab-press": {
        "fa-regular": "regular",
        faslpr: "regular"
      },
      thumbprint: {
        "fa-light": "light",
        fatl: "light"
      },
      whiteboard: {
        "fa-semibold": "semibold",
        fawsb: "semibold"
      },
      notdog: {
        "fa-solid": "solid",
        fans: "solid"
      },
      "notdog-duo": {
        "fa-solid": "solid",
        fands: "solid"
      },
      etch: {
        "fa-solid": "solid",
        faes: "solid"
      },
      jelly: {
        "fa-regular": "regular",
        fajr: "regular"
      },
      "jelly-fill": {
        "fa-regular": "regular",
        fajfr: "regular"
      },
      "jelly-duo": {
        "fa-regular": "regular",
        fajdr: "regular"
      },
      chisel: {
        "fa-regular": "regular",
        facr: "regular"
      },
      utility: {
        "fa-semibold": "semibold",
        fausb: "semibold"
      },
      "utility-duo": {
        "fa-semibold": "semibold",
        faudsb: "semibold"
      },
      "utility-fill": {
        "fa-semibold": "semibold",
        faufsb: "semibold"
      }
    };
  var i = "classic",
    t = "duotone",
    d = "sharp",
    l = "sharp-duotone",
    f = "chisel",
    n = "etch",
    h = "jelly",
    o = "jelly-duo",
    u = "jelly-fill",
    g = "notdog",
    s = "notdog-duo",
    y = "slab",
    m = "slab-press",
    e = "thumbprint",
    p = "utility",
    a = "utility-duo",
    w = "utility-fill",
    x = "whiteboard",
    b = "Classic",
    c = "Duotone",
    I = "Sharp",
    F = "Sharp Duotone",
    v = "Chisel",
    S = "Etch",
    A = "Jelly",
    P = "Jelly Duo",
    j = "Jelly Fill",
    B = "Notdog",
    N = "Notdog Duo",
    k = "Slab",
    D = "Slab Press",
    T = "Thumbprint",
    C = "Utility",
    W = "Utility Duo",
    K = "Utility Fill",
    R = "Whiteboard",
    dt = (_dt = {}, _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_dt, i, b), t, c), d, I), l, F), f, v), n, S), h, A), o, P), u, j), g, B), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_dt, s, N), y, k), m, D), e, T), p, C), a, W), w, K), x, R));
  var gt = {
      classic: {
        900: "fas",
        400: "far",
        normal: "far",
        300: "fal",
        100: "fat"
      },
      duotone: {
        900: "fad",
        400: "fadr",
        300: "fadl",
        100: "fadt"
      },
      sharp: {
        900: "fass",
        400: "fasr",
        300: "fasl",
        100: "fast"
      },
      "sharp-duotone": {
        900: "fasds",
        400: "fasdr",
        300: "fasdl",
        100: "fasdt"
      },
      slab: {
        400: "faslr"
      },
      "slab-press": {
        400: "faslpr"
      },
      whiteboard: {
        600: "fawsb"
      },
      thumbprint: {
        300: "fatl"
      },
      notdog: {
        900: "fans"
      },
      "notdog-duo": {
        900: "fands"
      },
      etch: {
        900: "faes"
      },
      chisel: {
        400: "facr"
      },
      jelly: {
        400: "fajr"
      },
      "jelly-fill": {
        400: "fajfr"
      },
      "jelly-duo": {
        400: "fajdr"
      },
      utility: {
        600: "fausb"
      },
      "utility-duo": {
        600: "faudsb"
      },
      "utility-fill": {
        600: "faufsb"
      }
    };
  var _t = {
      chisel: {
        regular: "facr"
      },
      classic: {
        brands: "fab",
        light: "fal",
        regular: "far",
        solid: "fas",
        thin: "fat"
      },
      duotone: {
        light: "fadl",
        regular: "fadr",
        solid: "fad",
        thin: "fadt"
      },
      etch: {
        solid: "faes"
      },
      jelly: {
        regular: "fajr"
      },
      "jelly-duo": {
        regular: "fajdr"
      },
      "jelly-fill": {
        regular: "fajfr"
      },
      notdog: {
        solid: "fans"
      },
      "notdog-duo": {
        solid: "fands"
      },
      sharp: {
        light: "fasl",
        regular: "fasr",
        solid: "fass",
        thin: "fast"
      },
      "sharp-duotone": {
        light: "fasdl",
        regular: "fasdr",
        solid: "fasds",
        thin: "fasdt"
      },
      slab: {
        regular: "faslr"
      },
      "slab-press": {
        regular: "faslpr"
      },
      thumbprint: {
        light: "fatl"
      },
      utility: {
        semibold: "fausb"
      },
      "utility-duo": {
        semibold: "faudsb"
      },
      "utility-fill": {
        semibold: "faufsb"
      },
      whiteboard: {
        semibold: "fawsb"
      }
    };
  var qt = {
      kit: {
        fak: "kit",
        "fa-kit": "kit"
      },
      "kit-duotone": {
        fakd: "kit-duotone",
        "fa-kit-duotone": "kit-duotone"
      }
    },
    Ht = ["kit"];
  var L = "kit",
    r = "kit-duotone",
    U = "Kit",
    J = "Kit Duotone",
    $t = _defineProperty(_defineProperty({}, L, U), r, J);
  var ol = {
    kit: {
      "fa-kit": "fak"
    },
    "kit-duotone": {
      "fa-kit-duotone": "fakd"
    }
  };
  var fl = {
      kit: {
        fak: "fa-kit"
      },
      "kit-duotone": {
        fakd: "fa-kit-duotone"
      }
    };
  var ul = {
      kit: {
        kit: "fak"
      },
      "kit-duotone": {
        "kit-duotone": "fakd"
      }
    };

  var _ml;
  var l$1 = {
      GROUP: "duotone-group",
      SWAP_OPACITY: "swap-opacity",
      PRIMARY: "primary",
      SECONDARY: "secondary"
    };
  var n$1 = "classic",
    o$1 = "duotone",
    u$1 = "sharp",
    s$1 = "sharp-duotone",
    h$1 = "chisel",
    g$1 = "etch",
    y$1 = "jelly",
    e$1 = "jelly-duo",
    m$1 = "jelly-fill",
    p$1 = "notdog",
    a$1 = "notdog-duo",
    w$1 = "slab",
    b$1 = "slab-press",
    r$1 = "thumbprint",
    c$1 = "utility",
    i$1 = "utility-duo",
    x$1 = "utility-fill",
    I$1 = "whiteboard",
    F$1 = "Classic",
    v$1 = "Duotone",
    S$1 = "Sharp",
    A$1 = "Sharp Duotone",
    P$1 = "Chisel",
    j$1 = "Etch",
    B$1 = "Jelly",
    N$1 = "Jelly Duo",
    k$1 = "Jelly Fill",
    D$1 = "Notdog",
    C$1 = "Notdog Duo",
    T$1 = "Slab",
    L$1 = "Slab Press",
    W$1 = "Thumbprint",
    R$1 = "Utility",
    K$1 = "Utility Duo",
    U$1 = "Utility Fill",
    J$1 = "Whiteboard",
    ml$1 = (_ml = {}, _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_ml, n$1, F$1), o$1, v$1), u$1, S$1), s$1, A$1), h$1, P$1), g$1, j$1), y$1, B$1), e$1, N$1), m$1, k$1), p$1, D$1), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_ml, a$1, C$1), w$1, T$1), b$1, L$1), r$1, W$1), c$1, R$1), i$1, K$1), x$1, U$1), I$1, J$1));
  var E$1 = "kit",
    d$1 = "kit-duotone",
    _$1 = "Kit",
    M$1 = "Kit Duotone",
    rt$1 = _defineProperty(_defineProperty({}, E$1, _$1), d$1, M$1);
  var $t$1 = {
      classic: {
        "fa-brands": "fab",
        "fa-duotone": "fad",
        "fa-light": "fal",
        "fa-regular": "far",
        "fa-solid": "fas",
        "fa-thin": "fat"
      },
      duotone: {
        "fa-regular": "fadr",
        "fa-light": "fadl",
        "fa-thin": "fadt"
      },
      sharp: {
        "fa-solid": "fass",
        "fa-regular": "fasr",
        "fa-light": "fasl",
        "fa-thin": "fast"
      },
      "sharp-duotone": {
        "fa-solid": "fasds",
        "fa-regular": "fasdr",
        "fa-light": "fasdl",
        "fa-thin": "fasdt"
      },
      slab: {
        "fa-regular": "faslr"
      },
      "slab-press": {
        "fa-regular": "faslpr"
      },
      whiteboard: {
        "fa-semibold": "fawsb"
      },
      thumbprint: {
        "fa-light": "fatl"
      },
      notdog: {
        "fa-solid": "fans"
      },
      "notdog-duo": {
        "fa-solid": "fands"
      },
      etch: {
        "fa-solid": "faes"
      },
      jelly: {
        "fa-regular": "fajr"
      },
      "jelly-fill": {
        "fa-regular": "fajfr"
      },
      "jelly-duo": {
        "fa-regular": "fajdr"
      },
      chisel: {
        "fa-regular": "facr"
      },
      utility: {
        "fa-semibold": "fausb"
      },
      "utility-duo": {
        "fa-semibold": "faudsb"
      },
      "utility-fill": {
        "fa-semibold": "faufsb"
      }
    },
    z = {
      classic: ["fas", "far", "fal", "fat", "fad"],
      duotone: ["fadr", "fadl", "fadt"],
      sharp: ["fass", "fasr", "fasl", "fast"],
      "sharp-duotone": ["fasds", "fasdr", "fasdl", "fasdt"],
      slab: ["faslr"],
      "slab-press": ["faslpr"],
      whiteboard: ["fawsb"],
      thumbprint: ["fatl"],
      notdog: ["fans"],
      "notdog-duo": ["fands"],
      etch: ["faes"],
      jelly: ["fajr"],
      "jelly-fill": ["fajfr"],
      "jelly-duo": ["fajdr"],
      chisel: ["facr"],
      utility: ["fausb"],
      "utility-duo": ["faudsb"],
      "utility-fill": ["faufsb"]
    },
    Ht$1 = {
      classic: {
        fab: "fa-brands",
        fad: "fa-duotone",
        fal: "fa-light",
        far: "fa-regular",
        fas: "fa-solid",
        fat: "fa-thin"
      },
      duotone: {
        fadr: "fa-regular",
        fadl: "fa-light",
        fadt: "fa-thin"
      },
      sharp: {
        fass: "fa-solid",
        fasr: "fa-regular",
        fasl: "fa-light",
        fast: "fa-thin"
      },
      "sharp-duotone": {
        fasds: "fa-solid",
        fasdr: "fa-regular",
        fasdl: "fa-light",
        fasdt: "fa-thin"
      },
      slab: {
        faslr: "fa-regular"
      },
      "slab-press": {
        faslpr: "fa-regular"
      },
      whiteboard: {
        fawsb: "fa-semibold"
      },
      thumbprint: {
        fatl: "fa-light"
      },
      notdog: {
        fans: "fa-solid"
      },
      "notdog-duo": {
        fands: "fa-solid"
      },
      etch: {
        faes: "fa-solid"
      },
      jelly: {
        fajr: "fa-regular"
      },
      "jelly-fill": {
        fajfr: "fa-regular"
      },
      "jelly-duo": {
        fajdr: "fa-regular"
      },
      chisel: {
        facr: "fa-regular"
      },
      utility: {
        fausb: "fa-semibold"
      },
      "utility-duo": {
        faudsb: "fa-semibold"
      },
      "utility-fill": {
        faufsb: "fa-semibold"
      }
    },
    G$1 = ["solid", "regular", "light", "thin", "duotone", "brands", "semibold"],
    O$1 = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
    V$1 = O$1.concat([11, 12, 13, 14, 15, 16, 17, 18, 19, 20]),
    $$1 = ["aw", "fw", "pull-left", "pull-right"],
    to = [].concat(_toConsumableArray(Object.keys(z)), G$1, $$1, ["2xs", "xs", "sm", "lg", "xl", "2xl", "beat", "border", "fade", "beat-fade", "bounce", "flip-both", "flip-horizontal", "flip-vertical", "flip", "inverse", "layers", "layers-bottom-left", "layers-bottom-right", "layers-counter", "layers-text", "layers-top-left", "layers-top-right", "li", "pull-end", "pull-start", "pulse", "rotate-180", "rotate-270", "rotate-90", "rotate-by", "shake", "spin-pulse", "spin-reverse", "spin", "stack-1x", "stack-2x", "stack", "ul", "width-auto", "width-fixed", l$1.GROUP, l$1.SWAP_OPACITY, l$1.PRIMARY, l$1.SECONDARY]).concat(O$1.map(function (t) {
      return "".concat(t, "x");
    })).concat(V$1.map(function (t) {
      return "w-".concat(t);
    }));

  var NAMESPACE_IDENTIFIER = '___FONT_AWESOME___';
  var PRODUCTION = function () {
    try {
      return "production" === 'production';
    } catch (e$$1) {
      return false;
    }
  }();
  function familyProxy(obj) {
    // Defaults to the classic family if family is not available
    return new Proxy(obj, {
      get: function get(target, prop) {
        return prop in target ? target[prop] : target[i];
      }
    });
  }
  var _PREFIX_TO_STYLE = _objectSpread2({}, q);

  // We changed FACSSClassesToStyleId in the icons repo to be canonical and as such, "classic" family does not have any
  // duotone styles.  But we do still need duotone in _PREFIX_TO_STYLE below, so we are manually adding
  // {'fa-duotone': 'duotone'}
  _PREFIX_TO_STYLE[i] = _objectSpread2(_objectSpread2(_objectSpread2(_objectSpread2({}, {
    'fa-duotone': 'duotone'
  }), q[i]), qt['kit']), qt['kit-duotone']);
  var PREFIX_TO_STYLE = familyProxy(_PREFIX_TO_STYLE);
  var _STYLE_TO_PREFIX = _objectSpread2({}, _t);

  // We changed FAStyleIdToShortPrefixId in the icons repo to be canonical and as such, "classic" family does not have any
  // duotone styles.  But we do still need duotone in _STYLE_TO_PREFIX below, so we are manually adding {duotone: 'fad'}
  _STYLE_TO_PREFIX[i] = _objectSpread2(_objectSpread2(_objectSpread2(_objectSpread2({}, {
    duotone: 'fad'
  }), _STYLE_TO_PREFIX[i]), ul['kit']), ul['kit-duotone']);
  var STYLE_TO_PREFIX = familyProxy(_STYLE_TO_PREFIX);
  var _PREFIX_TO_LONG_STYLE = _objectSpread2({}, Ht$1);
  _PREFIX_TO_LONG_STYLE[i] = _objectSpread2(_objectSpread2({}, _PREFIX_TO_LONG_STYLE[i]), fl['kit']);
  var PREFIX_TO_LONG_STYLE = familyProxy(_PREFIX_TO_LONG_STYLE);
  var _LONG_STYLE_TO_PREFIX = _objectSpread2({}, $t$1);
  _LONG_STYLE_TO_PREFIX[i] = _objectSpread2(_objectSpread2({}, _LONG_STYLE_TO_PREFIX[i]), ol['kit']);
  var LONG_STYLE_TO_PREFIX = familyProxy(_LONG_STYLE_TO_PREFIX);
  var _FONT_WEIGHT_TO_PREFIX = _objectSpread2({}, gt);
  var FONT_WEIGHT_TO_PREFIX = familyProxy(_FONT_WEIGHT_TO_PREFIX);
  var RESERVED_CLASSES = [].concat(_toConsumableArray(Ht), _toConsumableArray(to));

  function bunker(fn) {
    try {
      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }
      fn.apply(void 0, args);
    } catch (e) {
      if (!PRODUCTION) {
        throw e;
      }
    }
  }

  var w$2 = WINDOW || {};
  if (!w$2[NAMESPACE_IDENTIFIER]) w$2[NAMESPACE_IDENTIFIER] = {};
  if (!w$2[NAMESPACE_IDENTIFIER].styles) w$2[NAMESPACE_IDENTIFIER].styles = {};
  if (!w$2[NAMESPACE_IDENTIFIER].hooks) w$2[NAMESPACE_IDENTIFIER].hooks = {};
  if (!w$2[NAMESPACE_IDENTIFIER].shims) w$2[NAMESPACE_IDENTIFIER].shims = [];
  var namespace = w$2[NAMESPACE_IDENTIFIER];

  function normalizeIcons(icons) {
    return Object.keys(icons).reduce(function (acc, iconName) {
      var icon = icons[iconName];
      var expanded = !!icon.icon;
      if (expanded) {
        acc[icon.iconName] = icon.icon;
      } else {
        acc[iconName] = icon;
      }
      return acc;
    }, {});
  }
  function defineIcons(prefix, icons) {
    var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    var _params$skipHooks = params.skipHooks,
      skipHooks = _params$skipHooks === void 0 ? false : _params$skipHooks;
    var normalized = normalizeIcons(icons);
    if (typeof namespace.hooks.addPack === 'function' && !skipHooks) {
      namespace.hooks.addPack(prefix, normalizeIcons(icons));
    } else {
      namespace.styles[prefix] = _objectSpread2(_objectSpread2({}, namespace.styles[prefix] || {}), normalized);
    }

    /**
     * Font Awesome 4 used the prefix of `fa` for all icons. With the introduction
     * of new styles we needed to differentiate between them. Prefix `fa` is now an alias
     * for `fas` so we'll ease the upgrade process for our users by automatically defining
     * this as well.
     */
    if (prefix === 'fas') {
      defineIcons('fa', icons);
    }
  }

  var icons = {
    "0": [320, 512, [], "30", "M0 192C0 103.6 71.6 32 160 32s160 71.6 160 160l0 128c0 88.4-71.6 160-160 160S0 408.4 0 320L0 192zM160 96c-53 0-96 43-96 96l0 128c0 53 43 96 96 96s96-43 96-96l0-128c0-53-43-96-96-96z"],
    "1": [256, 512, [], "31", "M32 32C14.3 32 0 46.3 0 64S14.3 96 32 96l64 0 0 320-64 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l192 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0 0-352c0-17.7-14.3-32-32-32L32 32z"],
    "2": [384, 512, [], "32", "M48 64c0-17.7 14.3-32 32-32l171 0c60.2 0 109 48.8 109 109 0 43.8-26.2 83.3-66.4 100.4l-139.1 59C119 315.4 96 350.2 96 388.7l0 27.3 224 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L64 480c-17.7 0-32-14.3-32-32l0-59.3c0-64.2 38.4-122.2 97.5-147.3l139.1-59c16.6-7.1 27.4-23.4 27.4-41.4 0-24.9-20.2-45-45-45L80 96C62.3 96 48 81.7 48 64z"],
    "3": [320, 512, [], "33", "M80 288c-17.7 0-32-14.3-32-32s14.3-32 32-32l112 0c35.3 0 64-28.7 64-64s-28.7-64-64-64L32 96C14.3 96 0 81.7 0 64S14.3 32 32 32l160 0c70.7 0 128 57.3 128 128 0 38.2-16.8 72.5-43.3 96 26.6 23.5 43.3 57.8 43.3 96 0 70.7-57.3 128-128 128L32 480c-17.7 0-32-14.3-32-32s14.3-32 32-32l160 0c35.3 0 64-28.7 64-64s-28.7-64-64-64L80 288z"],
    "4": [384, 512, [], "34", "M64 64c0-17.7-14.3-32-32-32S0 46.3 0 64L0 288c0 35.3 28.7 64 64 64l192 0 0 96c0 17.7 14.3 32 32 32s32-14.3 32-32l0-96 32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0 0-224c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 224-192 0 0-224z"],
    "5": [320, 512, [], "35", "M0 64C0 46.3 14.3 32 32 32l224 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-192 0 0 112 120 0c75.1 0 136 60.9 136 136S259.1 480 184 480L32 480c-17.7 0-32-14.3-32-32s14.3-32 32-32l152 0c39.8 0 72-32.2 72-72s-32.2-72-72-72L32 272c-17.7 0-32-14.3-32-32L0 64z"],
    "6": [384, 512, [], "36", "M256 32c17.7 0 32 14.3 32 32s-14.3 32-32 32l-88 0c-48.6 0-88 39.4-88 88l0 32.2c22.9-15.3 50.4-24.2 80-24.2l48 0c79.5 0 144 64.5 144 144S287.5 480 208 480l-48 0C80.5 480 16 415.5 16 336l0-152C16 100.1 84.1 32 168 32l88 0zM80 336c0 44.2 35.8 80 80 80l48 0c44.2 0 80-35.8 80-80s-35.8-80-80-80l-48 0c-44.2 0-80 35.8-80 80z"],
    "7": [320, 512, [], "37", "M0 64C0 46.3 14.3 32 32 32l256 0c11.5 0 22 6.1 27.7 16.1s5.7 22.2-.1 32.1l-224 384c-8.9 15.3-28.5 20.4-43.8 11.5s-20.4-28.5-11.5-43.8L232.3 96 32 96C14.3 96 0 81.7 0 64z"],
    "8": [320, 512, [], "38", "M304 160c0-70.7-57.3-128-128-128l-32 0c-70.7 0-128 57.3-128 128 0 34.6 13.7 66 36 89-31.5 23.3-52 60.8-52 103 0 70.7 57.3 128 128 128l64 0c70.7 0 128-57.3 128-128 0-42.2-20.5-79.7-52-103 22.3-23 36-54.4 36-89zM176.1 288l15.9 0c35.3 0 64 28.7 64 64s-28.7 64-64 64l-64 0c-35.3 0-64-28.7-64-64s28.7-64 64-64l48.1 0zm0-64L144 224c-35.3 0-64-28.7-64-64 0-35.3 28.7-64 64-64l32 0c35.3 0 64 28.7 64 64 0 35.3-28.6 64-64 64z"],
    "9": [384, 512, [], "39", "M208 320c29.6 0 57.1-8.9 80-24.2l0 32.2c0 48.6-39.4 88-88 88L96 416c-17.7 0-32 14.3-32 32s14.3 32 32 32l104 0c83.9 0 152-68.1 152-152l0-152.1C351.9 96.4 287.5 32 208 32l-48 0C80.5 32 16 96.5 16 176S80.5 320 160 320l48 0zm80-144c0 44.2-35.8 80-80 80l-48 0c-44.2 0-80-35.8-80-80s35.8-80 80-80l48 0c44.2 0 80 35.8 80 80z"],
    "chess-pawn-piece": [320, 512, ["chess-pawn-alt"], "f444", "M256 128c0 24.6-9.2 47-24.4 64l.4 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-5.3 0 13.3 144 56.2 70.3c5 6.3 7.8 14.1 7.8 22.2 0 19.6-15.9 35.5-35.5 35.5L51.5 512c-19.6 0-35.5-15.9-35.5-35.5 0-8.1 2.7-15.9 7.8-22.2L80 384 93.3 240 88 240c-13.3 0-24-10.7-24-24s10.7-24 24-24l.4 0c-15.2-17-24.4-39.4-24.4-64 0-53 43-96 96-96s96 43 96 96z"],
    "dollar-sign": [320, 512, [128178, 61781, "dollar", "usd"], "24", "M136 24c0-13.3 10.7-24 24-24s24 10.7 24 24l0 40 56 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-114.9 0c-24.9 0-45.1 20.2-45.1 45.1 0 22.5 16.5 41.5 38.7 44.7l91.6 13.1c53.8 7.7 93.7 53.7 93.7 108 0 60.3-48.9 109.1-109.1 109.1l-10.9 0 0 40c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-40-72 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l130.9 0c24.9 0 45.1-20.2 45.1-45.1 0-22.5-16.5-41.5-38.7-44.7l-91.6-13.1C55.9 273.5 16 227.4 16 173.1 16 112.9 64.9 64 125.1 64l10.9 0 0-40z"],
    "layer-plus": [512, 512, ["layer-group-plus"], "f5ff", "M456-8c0-13.3-10.7-24-24-24S408-21.3 408-8l0 32-32 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l32 0 0 32c0 13.3 10.7 24 24 24s24-10.7 24-24l0-32 32 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-32 0 0-32zM279.5 101.2c-14.9-6.9-32.1-6.9-47 0L13.9 202.2C5.4 206.1 0 214.6 0 224s5.4 17.9 13.9 21.8l218.6 101c14.9 6.9 32.1 6.9 47 0l218.6-101c8.5-3.9 13.9-12.4 13.9-21.8s-5.4-17.9-13.9-21.8l-218.6-101zM13.9 362.2C5.4 366.1 0 374.6 0 384s5.4 17.9 13.9 21.8l218.6 101c14.9 6.9 32.1 6.9 47 0l218.6-101c8.5-3.9 13.9-12.4 13.9-21.8s-5.4-17.9-13.9-21.8l-68.7-31.8-129.7 59.9c-27.7 12.8-59.6 12.8-87.3 0L82.7 330.4 13.9 362.2z"],
    "grid-4": [448, 512, [], "e198", "M0 48c0-8.8 7.2-16 16-16l48 0c8.8 0 16 7.2 16 16l0 48c0 8.8-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16L0 48zM0 170.7c0-8.8 7.2-16 16-16l48 0c8.8 0 16 7.2 16 16l0 48c0 8.8-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16l0-48zM0 293.3c0-8.8 7.2-16 16-16l48 0c8.8 0 16 7.2 16 16l0 48c0 8.8-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16l0-48zM16 400l48 0c8.8 0 16 7.2 16 16l0 48c0 8.8-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16l0-48c0-8.8 7.2-16 16-16zm122.7 0l48 0c8.8 0 16 7.2 16 16l0 48c0 8.8-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16l0-48c0-8.8 7.2-16 16-16zm106.7 16c0-8.8 7.2-16 16-16l48 0c8.8 0 16 7.2 16 16l0 48c0 8.8-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16l0-48zM384 400l48 0c8.8 0 16 7.2 16 16l0 48c0 8.8-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16l0-48c0-8.8 7.2-16 16-16zM138.7 277.3l48 0c8.8 0 16 7.2 16 16l0 48c0 8.8-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16l0-48c0-8.8 7.2-16 16-16zm106.7 16c0-8.8 7.2-16 16-16l48 0c8.8 0 16 7.2 16 16l0 48c0 8.8-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16l0-48zm138.7-16l48 0c8.8 0 16 7.2 16 16l0 48c0 8.8-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16l0-48c0-8.8 7.2-16 16-16zM138.7 154.7l48 0c8.8 0 16 7.2 16 16l0 48c0 8.8-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16l0-48c0-8.8 7.2-16 16-16zm106.7 16c0-8.8 7.2-16 16-16l48 0c8.8 0 16 7.2 16 16l0 48c0 8.8-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16l0-48zm138.7-16l48 0c8.8 0 16 7.2 16 16l0 48c0 8.8-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16l0-48c0-8.8 7.2-16 16-16zM138.7 32l48 0c8.8 0 16 7.2 16 16l0 48c0 8.8-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16l0-48c0-8.8 7.2-16 16-16zM245.3 48c0-8.8 7.2-16 16-16l48 0c8.8 0 16 7.2 16 16l0 48c0 8.8-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16l0-48zM384 32l48 0c8.8 0 16 7.2 16 16l0 48c0 8.8-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16l0-48c0-8.8 7.2-16 16-16z"],
    "dog": [576, 512, [128021], "f6d3", "M32 112c16.6 0 30.2 12.6 31.8 28.7l.3 6.6C65.8 163.4 79.4 176 96 176l179.1 0 140.9 60.4 0 243.6c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-131.3C296 361 268.8 368 240 368s-56-7-80-19.3L160 480c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-245.6c-37.3-13.2-64-48.6-64-90.4 0-17.7 14.3-32 32-32zM355.8-32c7.7 0 14.9 3.6 19.6 9.8L392 0 444.1 0c12.7 0 24.9 5.1 33.9 14.1L496 32 552 32c13.3 0 24 10.7 24 24l0 24c0 44.2-35.8 80-80 80l-64 0-7 28-124.7-53.4 31.6-147.2C334.3-23.9 344.2-32 355.8-32zM448 44a20 20 0 1 0 0 40 20 20 0 1 0 0-40z"],
    "truck-moving": [640, 512, [], "f4df", "M64 32C28.7 32 0 60.7 0 96L0 424c0 48.6 39.4 88 88 88 25.2 0 48-10.6 64-27.6 16 17 38.8 27.6 64 27.6 40.3 0 74.2-27.1 84.7-64l134.6 0c10.4 36.9 44.4 64 84.7 64 43 0 78.9-30.9 86.5-71.7 20-10.8 33.5-32 33.5-56.3l0-146.7c0-17-6.7-33.3-18.7-45.3L576 146.7c-12-12-28.3-18.7-45.3-18.7l-50.7 0 0-32c0-35.3-28.7-64-64-64L64 32zM480 192l50.7 0 45.3 45.3 0 50.7-96 0 0-96zM88 384a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm392 40a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zM216 384a40 40 0 1 1 0 80 40 40 0 1 1 0-80z"],
    "rotate": [512, 512, [128260, "sync-alt"], "f2f1", "M480.1 192l7.9 0c13.3 0 24-10.7 24-24l0-144c0-9.7-5.8-18.5-14.8-22.2S477.9 .2 471 7L419.3 58.8C375 22.1 318 0 256 0 127 0 20.3 95.4 2.6 219.5 .1 237 12.2 253.2 29.7 255.7s33.7-9.7 36.2-27.1C79.2 135.5 159.3 64 256 64 300.4 64 341.2 79 373.7 104.3L327 151c-6.9 6.9-8.9 17.2-5.2 26.2S334.3 192 344 192l136.1 0zm29.4 100.5c2.5-17.5-9.7-33.7-27.1-36.2s-33.7 9.7-36.2 27.1c-13.3 93-93.4 164.5-190.1 164.5-44.4 0-85.2-15-117.7-40.3L185 361c6.9-6.9 8.9-17.2 5.2-26.2S177.7 320 168 320L24 320c-13.3 0-24 10.7-24 24L0 488c0 9.7 5.8 18.5 14.8 22.2S34.1 511.8 41 505l51.8-51.8C137 489.9 194 512 256 512 385 512 491.7 416.6 509.4 292.5z"],
    "arrow-u-turn-up-left": [512, 512, [], "e7ed", "M7.7 148.2c-10.3-12.6-9.5-31.1 2.2-42.8l112-112c12.5-12.5 32.8-12.5 45.2 0s12.5 32.8 0 45.2L109.7 96 320.5 96c102.7 0 186.6 80.7 191.8 182.1l.2 9.9c0 106-86 192-192 192l-224 0-3.3-.2c-16.1-1.6-28.7-15.3-28.7-31.8s12.6-30.2 28.7-31.8l3.3-.2 224 0c70.7 0 128-57.3 128-128l-.2-6.6C444.9 213.8 389 160 320.5 160l-210.8 0 57.4 57.4 2.2 2.4c10.2 12.6 9.5 31.1-2.2 42.8s-30.2 12.4-42.8 2.2l-2.4-2.2-112-112-2.2-2.4z"],
    "keyboard-brightness": [640, 512, [], "e1c0", "M134.6 153.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l64 64c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-64-64zM288 192c0 17.7 14.3 32 32 32s32-14.3 32-32l0-96c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 96zm153.4 25.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l64-64c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-64 64zM0 384c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0c-17.7 0-32 14.3-32 32zm224-32c-17.7 0-32 14.3-32 32s14.3 32 32 32l192 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-192 0zm320 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l64 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0z"],
    "tent-double-peak": [576, 512, [], "e627", "M442.2 40.4c32.5 51.6 75.6 85.3 107.9 105.2 15.5 9.5 25.9 25.9 25.9 44.1l0 18.3-576 0 0-18.3c0-18.2 10.4-34.6 25.9-44.1 32.3-19.9 75.4-53.6 107.9-105.2 6.8-10.8 23.6-11.6 31.6-1.6 22.6 28.4 66.3 71.8 122.6 71.8S388 67.2 410.6 38.7c7.9-10 24.8-9.1 31.6 1.6zM0 448l0-192 576 0 0 192c0 35.3-28.7 64-64 64l-77.6 0c-11.4-.1-21.9-6.2-27.6-16.1L317.9 340.3c-8.1-14.2-29.9-8.5-29.9 7.9L288 480c0 17.6-14.2 31.9-31.8 32L64 512c-35.3 0-64-28.7-64-64z"],
    "square-minus": [448, 512, [61767, "minus-square"], "f146", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm72 200l176 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-176 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"],
    "water-arrow-up": [512, 512, ["water-rise"], "f775", "M233.4 9.4c12.5-12.5 32.8-12.5 45.3 0l80 80c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L288 109.3 288 208c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-98.7-25.4 25.4c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l80-80zM410.6 348.1c-21.3-16.1-49.9-16.1-71.2 0-24.2 18.3-52.3 35.9-83.4 35.9s-59.1-17.7-83.4-35.9c-21.3-16.1-49.9-16.1-71.2 0-20.7 15.6-46 30.7-74.2 34.5-13.1 1.8-25.2-7.5-27-20.6s7.5-25.2 20.6-27c15.9-2.1 33.2-11.3 51.7-25.2 38.4-29 90.5-29 129 0 24 18.1 40.7 26.3 54.5 26.3s30.5-8.2 54.5-26.3c38.4-29 90.5-29 129 0 18.5 13.9 35.8 23.1 51.7 25.2 13.1 1.8 22.4 13.8 20.6 27s-13.8 22.4-27 20.6c-28.2-3.8-53.6-18.9-74.2-34.5zm0 128c-21.3-16.1-49.9-16.1-71.2 0-24.2 18.3-52.3 35.9-83.4 35.9s-59.1-17.7-83.4-35.9c-21.3-16.1-49.9-16.1-71.2 0-20.7 15.6-46 30.7-74.2 34.5-13.1 1.8-25.2-7.5-27-20.6s7.5-25.2 20.6-27c15.9-2.1 33.2-11.3 51.7-25.2 38.4-29 90.5-29 129 0 24 18.1 40.7 26.3 54.5 26.3s30.5-8.2 54.5-26.3c38.4-29 90.5-29 129 0 18.5 13.9 35.8 23.1 51.7 25.2 13.1 1.8 22.4 13.8 20.6 27s-13.8 22.4-27 20.6c-28.2-3.8-53.6-18.9-74.2-34.5z"],
    "xmark-to-slot": [576, 512, ["times-to-slot", "vote-nay"], "f771", "M96 96c0-35.3 28.7-64 64-64l256 0c35.3 0 64 28.7 64 64l0 224c0 35.3-28.7 64-64 64l-256 0c-35.3 0-64-28.7-64-64L96 96zm259.9 78.1c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-33.9 33.9-33.9-33.9c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l33.9 33.9-33.9 33.9c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l33.9-33.9 33.9 33.9c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-33.9-33.9 33.9-33.9zM48 312l0 104c0 8.8 7.2 16 16 16l448 0c8.8 0 16-7.2 16-16l0-104c0-13.3 10.7-24 24-24s24 10.7 24 24l0 104c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 312c0-13.3 10.7-24 24-24s24 10.7 24 24z"],
    "sensor-cloud": [576, 512, ["sensor-smoke"], "e02c", "M64 96c0-35.3 28.7-64 64-64l320 0c35.3 0 64 28.7 64 64l0 192.3c-16.2-10.3-35.4-16.3-56-16.3-6 0-11.9 .5-17.7 1.5-22.7-20.8-53-33.5-86.3-33.5-69.4 0-125.8 55.2-127.9 124-29.3 23.4-48.1 59.5-48.1 100 0 5.4 .3 10.8 1 16l-49 0c-35.3 0-64-28.7-64-64L64 96zm88 0c-13.3 0-24 10.7-24 24l0 112c0 13.3 10.7 24 24 24s24-10.7 24-24l0-112c0-13.3-10.7-24-24-24zm96 0c-13.3 0-24 10.7-24 24l0 112c0 4.3 1.2 8.4 3.2 11.9 13.1-13.1 28.2-24.2 44.8-32.7l0-91.2c0-13.3-10.7-24-24-24zM576 464c0 44.2-35.8 80-80 80l-192 0c-44.2 0-80-35.8-80-80 0-33.9 21.1-62.9 50.9-74.5-1.9-6.8-2.9-14-2.9-21.5 0-44.2 35.8-80 80-80 30.8 0 57.5 17.4 70.9 42.8 9.3-6.8 20.7-10.8 33.1-10.8 30.9 0 56 25.1 56 56 0 3.2-.3 6.4-.8 9.4 36.9 7.1 64.8 39.6 64.8 78.6z"],
    "lychee": [512, 512, [], "e824", "M218.8 4.9c7.7-5.5 17.2-6.1 25.9-3.2 7.3 2.9 14.5 6.1 21.1 9.8 2.5 1.4 5.5 1.4 8.2 .8 7.2-2.4 14.5-5.2 22.9-5.2 42.7 0 52.1 41.9 72.2 80l30.8-18.5 4.9-2.4c11.7-4.5 25.1-1.9 34.2 7.2s11.7 22.6 7.2 34.2l-2.4 4.9-18.6 31c38.5 20.7 80 29 80 72 0 8.5-2.8 15.8-5.2 23-.9 2.8-.3 5.7 .8 8.2 3.7 6.6 6.9 13.7 9.8 21 3.5 8.8 1.7 18.2-3.2 25.9-4.5 6.4-9.5 12.4-14.6 18-2 2.1-2.6 5-2.6 7.9 .8 7.5 1.1 15.3 1 23.1-.2 9.4-5.2 17.3-12.6 22.7-6.6 4.2-13.2 8.1-19.9 11.5-2.6 1.3-4.2 3.8-5.1 6.4-1.8 7.3-4 14.7-6.6 22-3 8.7-10 14.6-18.5 17.6-7.4 2.1-14.8 4-22.2 5.5-2.8 .6-5 2.6-6.6 4.9-3.6 6.6-7.5 13.2-11.6 19.7-4.9 7.7-13 11.8-21.8 12.8-7.7 .4-15.3 .6-22.8 .6-2.9 0-5.4 1.5-7.5 3.4-4.8 5.8-9.9 11.4-15.2 17-6.3 6.6-14.9 9.1-23.8 8.4-7.6-1-15.1-2.2-22.5-3.7-2.8-.6-5.6 .5-7.9 2-5.9 4.7-11.9 9.3-18.2 13.8-7.5 5.3-16.6 6-25.2 3.5-7.3-2.6-14.4-5.4-21.3-8.4-2.8-1.3-5.4-.8-8.2 .1-6.8 3.2-14 6.1-21.5 8.5-9 2.9-18.2 .6-25.7-4.8-6.2-4.9-11.9-10.2-17.1-15.6-2-2.1-4.8-2.9-7.7-3.1-7.5 .3-15.3 .1-23.1-.7-9.4-.8-17-6.6-21.8-14.4-3.7-6.9-6.9-14-9.6-21.1-1-2.7-3.3-4.6-5.8-5.9-7.1-2.7-14.1-5.8-21.1-9.5-8.3-4.4-13.1-12.7-14.4-21.8-.7-7.9-.9-15.6-.6-23.2 .1-2.9-1.3-5.5-3.1-7.7-5.5-5.2-10.7-10.9-15.6-17.1-6-7.4-7.1-16.8-4.8-25.7 2.4-7.5 5.3-14.7 8.5-21.6 1.3-2.7 1-5.4 .1-8.2-3.1-7-5.9-14-8.4-21.3-3-8.7-1.2-17.6 3.5-25.2 4.4-6.3 9-12.3 13.7-18.2 1.8-2.3 2.2-5.2 2-8-1.4-7.4-2.7-14.9-3.7-22.5-1.2-9.1 2.3-17.3 8.4-23.8 5.6-5.3 11.2-10.4 17-15.2 2.2-1.8 3.1-4.7 3.4-7.5 0-7.5 .1-15.1 .6-22.8 .5-9.1 5.6-16.6 12.8-21.8 6.5-4.1 13-8 19.7-11.6 2.5-1.4 4-3.9 4.9-6.6 1.5-7.4 3.3-14.8 5.4-22.2 2.4-8.5 9.1-15.7 17.6-18.6 7.3-2.5 14.7-4.7 22-6.5 2.8-.7 5.1-2.6 6.4-5.2 3.4-6.7 7.2-13.4 11.5-20 4.9-7.5 13.7-12.5 22.7-12.6 7.8-.1 15.6 .2 23.1 1 2.9 .3 5.7-.6 7.9-2.6 5.5-5.1 11.6-10 18-14.6zM198.2 288.1l-2.4 .4-40 8c-9.5 1.9-16.9 9.3-18.8 18.8l-8 40-.4 2.4c-1.2 12.1 7 23.4 19.2 25.8s24.1-4.8 27.7-16.4l.6-2.4 4.9-24.3 24.3-4.8 2.4-.6c11.6-3.6 18.9-15.5 16.4-27.7-2.4-12.2-13.7-20.4-25.8-19.2zm160-32l-2.4 .4-40 8c-9.5 1.9-16.9 9.3-18.8 18.8l-8 40-.4 2.4c-1.2 12.1 7 23.4 19.2 25.8s24.1-4.8 27.7-16.4l.6-2.4 4.9-24.3 24.3-4.8 2.4-.6c11.6-3.6 18.9-15.5 16.4-27.7-2.4-12.2-13.7-20.4-25.8-19.2zm-128-128l-2.4 .4-40 8c-9.5 1.9-16.9 9.3-18.8 18.8l-8 40-.4 2.4c-1.2 12.1 7 23.4 19.2 25.8s24.1-4.8 27.7-16.4l.6-2.4 4.9-24.3 24.3-4.8 2.4-.6c11.6-3.6 18.9-15.5 16.4-27.7-2.4-12.2-13.7-20.4-25.8-19.2z"],
    "align-justify": [448, 512, [], "f039", "M448 64c0-17.7-14.3-32-32-32L32 32C14.3 32 0 46.3 0 64S14.3 96 32 96l384 0c17.7 0 32-14.3 32-32zm0 256c0-17.7-14.3-32-32-32L32 288c-17.7 0-32 14.3-32 32s14.3 32 32 32l384 0c17.7 0 32-14.3 32-32zM0 192c0 17.7 14.3 32 32 32l384 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 160c-17.7 0-32 14.3-32 32zM448 448c0-17.7-14.3-32-32-32L32 416c-17.7 0-32 14.3-32 32s14.3 32 32 32l384 0c17.7 0 32-14.3 32-32z"],
    "sunglasses": [576, 512, [128374], "f892", "M143.3 96c-14 0-26.5 9.2-30.6 22.6L70.4 256 224 256c17.7 0 32 14.3 32 32l64 0c0-17.7 14.3-32 32-32l153.6 0-42.3-137.4C459.2 105.2 446.8 96 432.7 96L400 96c-17.7 0-32-14.3-32-32s14.3-32 32-32l32.7 0c42.1 0 79.4 27.5 91.8 67.8l45.4 147.5c4.1 13.2 6.1 26.9 6.1 40.7l0 96c0 53-43 96-96 96l-64 0c-53 0-96-43-96-96l0-32-64 0 0 32c0 53-43 96-96 96l-64 0c-53 0-96-43-96-96l0-96c0-13.8 2.1-27.5 6.1-40.7L51.5 99.8C63.9 59.5 101.1 32 143.3 32L176 32c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32.7 0zM64 320l0 64c0 9.5 4.2 18.1 10.8 23.9L192 320 64 320zm448 0l-128 0 0 64c0 9.5 4.2 18.1 10.8 23.9L512 320z"],
    "cloud-check": [576, 512, [], "e35c", "M240 32c55.4 0 103.5 31.3 127.6 77.1 14.2-8.3 30.8-13.1 48.4-13.1 53 0 96 43 96 96 0 15.7-3.8 30.6-10.5 43.7 44 20.3 74.5 64.7 74.5 116.3 0 70.7-57.3 128-128 128l-304 0C64.5 480 0 415.5 0 336 0 272.6 41 218.8 97.9 199.5 96.6 191.9 96 184 96 176 96 96.5 160.5 32 240 32zM378.9 196.6c-10.7-7.8-25.7-5.4-33.5 5.3l-85.6 117.7-26.5-27.4c-9.2-9.5-24.4-9.8-33.9-.6s-9.8 24.4-.6 33.9l46.4 48c4.9 5.1 11.8 7.8 18.9 7.3s13.6-4.1 17.8-9.8L384.2 230.1c7.8-10.7 5.4-25.7-5.3-33.5z"],
    "message-minus": [512, 512, ["comment-alt-minus"], "f4a7", "M0 128L0 352c0 53 43 96 96 96l32 0 0 72c0 13.3 10.7 24 24 24 5.2 0 10.2-1.7 14.4-4.8l115.2-86.4c4.2-3.1 9.2-4.8 14.4-4.8l120 0c53 0 96-43 96-96l0-224c0-53-43-96-96-96L96 32C43 32 0 75 0 128zm184 88l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"],
    "face-clouds": [640, 512, [], "e47d", "M222.4 32C215-4.5 182.7-32 144-32S73-4.5 65.6 32L64 32C28.7 32 0 60.7 0 96s28.7 64 64 64l160 0c35.3 0 64-28.7 64-64s-28.7-64-64-64l-1.6 0zM68.5 207.9c-3 15.6-4.5 31.6-4.5 48.1 0 115.4 76.4 213 181.4 245-3.5-11.7-5.4-24.1-5.4-37 0-40.5 18.8-76.5 48.1-100 1.7-55.3 38.4-101.8 88.8-117.9-5.5-5.7-8.9-13.5-8.9-22.1 0-17.7 14.3-32 32-32s32 14.3 32 32c0 6-1.7 11.7-4.6 16.5 28.8 2.5 54.8 14.6 74.9 33 5.8-1 11.7-1.5 17.7-1.5 19.8 0 38.4 5.5 54.1 15.2 1.2-10.2 1.9-20.6 1.9-31.2 0-141.4-114.6-256-256-256-18.5 0-36.6 2-54 5.7 40.7 14.1 70 52.8 70 98.3 0 46.2-30.2 85.4-71.9 99 4.9 5.6 7.9 13 7.9 21 0 17.7-14.3 32-32 32s-32-14.3-32-32c0-5.8 1.6-11.3 4.3-16L72 208c-1.2 0-2.3 0-3.5-.1zM640 464c0-39-27.9-71.5-64.8-78.6 .5-3.1 .8-6.2 .8-9.4 0-30.9-25.1-56-56-56-12.4 0-23.9 4-33.1 10.8-13.4-25.5-40.1-42.8-70.9-42.8-44.2 0-80 35.8-80 80 0 7.4 1 14.6 2.9 21.5-29.8 11.6-50.9 40.6-50.9 74.5 0 44.2 35.8 80 80 80l192 0c44.2 0 80-35.8 80-80z"],
    "left-long-to-line": [640, 512, [], "e41e", "M0 96C0 78.3 14.3 64 32 64S64 78.3 64 96l0 320c0 17.7-14.3 32-32 32S0 433.7 0 416L0 96zM137.4 278.6c-12.5-12.5-12.5-32.8 0-45.3l128-128c9.2-9.2 22.9-11.9 34.9-6.9S320 115.1 320 128l0 64 272 0c26.5 0 48 21.5 48 48l0 32c0 26.5-21.5 48-48 48l-272 0 0 64c0 12.9-7.8 24.6-19.8 29.6s-25.7 2.2-34.9-6.9l-128-128z"],
    "plane-landing-gear": [640, 512, [], "e7bc", "M249.8 74.4L401.7 240 552.3 240c30.9 0 56 25.1 56 56s-25.1 56-56 56l-450.6 0c-30.9 0-57.4-22.1-63-52.6l-19-104.6C18 185 25.5 176 35.5 176l17.3 0c7.3 0 14.2 3.3 18.7 9l44 55 103.5 0-51.6-154.9C163.9 74.7 171.6 64 182.5 64l43.7 0c9 0 17.5 3.8 23.6 10.4zM224.3 416a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm192-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "calendar-check": [448, 512, [], "f274", "M320 0c17.7 0 32 14.3 32 32l0 32 32 0c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 128C0 92.7 28.7 64 64 64l32 0 0-32c0-17.7 14.3-32 32-32s32 14.3 32 32l0 32 128 0 0-32c0-17.7 14.3-32 32-32zm22 161.7c-10.7-7.8-25.7-5.4-33.5 5.3L189.1 331.2 137 279.1c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l72 72c5 5 11.9 7.5 18.8 7s13.4-4.1 17.5-9.8L347.3 195.2c7.8-10.7 5.4-25.7-5.3-33.5z"],
    "square-ring": [448, 512, [], "e44f", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm64 224a96 96 0 1 0 192 0 96 96 0 1 0 -192 0zm96 160a160 160 0 1 1 0-320 160 160 0 1 1 0 320z"],
    "face-kiss": [512, 512, [128535, "kiss"], "f596", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM240 288l32 0c26.5 0 48 21.5 48 48 0 12.3-4.6 23.5-12.2 32 7.6 8.5 12.2 19.7 12.2 32 0 26.5-21.5 48-48 48l-32 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zm-96-80a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm192-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "circle-video": [512, 512, ["video-circle"], "e12b", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM128 192c0-17.7 14.3-32 32-32l128 0c17.7 0 32 14.3 32 32l0 38.4 61-36.6c1.9-1.2 4.2-1.8 6.4-1.8 6.9 0 12.5 5.6 12.5 12.5l0 102.9c0 6.9-5.6 12.5-12.5 12.5-2.3 0-4.5-.6-6.4-1.8l-61-36.6 0 38.4c0 17.7-14.3 32-32 32l-128 0c-17.7 0-32-14.3-32-32l0-128z"],
    "cart-shopping-fast": [640, 512, [], "e0dc", "M64 8C64-5.3 74.7-16 88-16l45.3 0c27.1 0 50.3 19.4 55.1 46l.4 2 412.7 0c20 0 35.1 18.2 31.4 37.9L601.8 235.8c-5.7 30.3-32.1 52.2-62.9 52.2l-303.6 0 5.1 28.3c2.1 11.4 12 19.7 23.6 19.7L520 336c13.3 0 24 10.7 24 24s-10.7 24-24 24l-255.9 0c-34.8 0-64.6-24.9-70.8-59.1L141.2 38.6c-.7-3.8-4-6.6-7.9-6.6L88 32C74.7 32 64 21.3 64 8zM224 464a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm224 0a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM24 96l64 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-64 0c-13.3 0-24-10.7-24-24S10.7 96 24 96zm0 96l80 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zm0 96l96 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-96 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"],
    "desktop-arrow-down": [512, 512, [], "e155", "M280 32l0 158.1 39-39c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-80 80c-9.4 9.4-24.6 9.4-33.9 0l-80-80c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l39 39 0-158.1c0-13.3 10.7-24 24-24s24 10.7 24 24zM64 32l112 0 0 64-80 0c-17.7 0-32 14.3-32 32l0 160c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-160c0-17.7-14.3-32-32-32l-80 0 0-64 112 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64l-144 0 16 48 72 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-272 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l72 0 16-48-144 0c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32z"],
    "banjo": [512, 512, [129685], "f8a3", "M465 7c-9.4-9.4-24.6-9.4-33.9 0L383 55c-2.4 2.4-4.3 5.3-5.5 8.5l-15.4 41-76.1 76.1c-20.6-13.9-44.3-23.4-70-27l0-1.7c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 1.7c-28.5 4.1-54.6 15.3-76.6 31.7l-1.2-1.2c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l1.2 1.2C41 241.4 29.8 267.5 25.7 296L24 296c-13.3 0-24 10.7-24 24s10.7 24 24 24l1.7 0c4.1 28.5 15.3 54.6 31.7 76.6l-1.2 1.2c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l1.2-1.2c22 16.5 48.2 27.7 76.6 31.7l0 1.7c0 13.3 10.7 24 24 24s24-10.7 24-24l0-1.7c28.5-4.1 54.6-15.3 76.6-31.7l1.2 1.2c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-1.2-1.2c16.5-22 27.7-48.2 31.7-76.6l1.7 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-1.7 0c-3.7-25.7-13.1-49.5-27-70l76.1-76.1 41-15.4c3.2-1.2 6.1-3.1 8.5-5.5l48-48c9.4-9.4 9.4-24.6 0-33.9L465 7zM192 208a112 112 0 1 1 0 224 112 112 0 1 1 0-224zm-31 95c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l48 48c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-48-48z"],
    "cloud-hail-mixed": [512, 512, [], "f73a", "M96 320c-53 0-96-43-96-96 0-42.5 27.6-78.6 65.9-91.2-1.3-6.7-1.9-13.7-1.9-20.8 0-61.9 50.1-112 112-112 43.1 0 80.5 24.3 99.2 60 14.7-17.1 36.5-28 60.8-28 44.2 0 80 35.8 80 80 0 5.5-.6 10.8-1.6 16 .5 0 1.1 0 1.6 0 53 0 96 43 96 96s-43 96-96 96L96 320zm6.8 79.6l-8 24C90.6 436.2 77 443 64.4 438.8S45 421 49.2 408.4l8-24C61.4 371.8 75 365 87.6 369.2S107 387 102.8 399.6zm120 0l-32 96c-4.2 12.6-17.8 19.4-30.4 15.2S141 493 145.2 480.4l32-96c4.2-12.6 17.8-19.4 30.4-15.2S227 387 222.8 399.6zm112 0l-8 24c-4.2 12.6-17.8 19.4-30.4 15.2S277 421 281.2 408.4l8-24c4.2-12.6 17.8-19.4 30.4-15.2S339 387 334.8 399.6zm120 0l-32 96c-4.2 12.6-17.8 19.4-30.4 15.2S373 493 377.2 480.4l32-96c4.2-12.6 17.8-19.4 30.4-15.2S459 387 454.8 399.6zM24 488a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm256-24a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"],
    "square-half-stroke": [448, 512, [], "e793", "M64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32zM224 416l160 0 0-320-160 0 0 320z"],
    "kitchen-set": [576, 512, [], "e51a", "M240 144a96 96 0 1 0 -192 0 96 96 0 1 0 192 0zm44.4 32C269.9 240.1 212.5 288 144 288 64.5 288 0 223.5 0 144S64.5 0 144 0c68.5 0 125.9 47.9 140.4 112l71.8 0c8.8-9.8 21.6-16 35.8-16l104 0c26.5 0 48 21.5 48 48s-21.5 48-48 48l-104 0c-14.2 0-27-6.2-35.8-16l-71.8 0zM144 80a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM400 240c13.3 0 24 10.7 24 24l0 8 96 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-240 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l96 0 0-8c0-13.3 10.7-24 24-24zM288 464l0-112 224 0 0 112c0 26.5-21.5 48-48 48l-128 0c-26.5 0-48-21.5-48-48zM48 320l128 0c26.5 0 48 21.5 48 48s-21.5 48-48 48l-16 0c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-80c0-8.8 7.2-16 16-16zm128 64c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0 0 32 16 0zM24 464l176 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 512c-13.3 0-24-10.7-24-24s10.7-24 24-24z"],
    "dna": [384, 512, [129516], "f471", "M352 0c17.7 0 32 14.3 32 32 0 57.8-24.4 104.8-57.4 144.5-24.1 28.9-53.8 55.1-83.6 79.5 29.8 24.5 59.5 50.6 83.6 79.5 33 39.6 57.4 86.7 57.4 144.5 0 17.7-14.3 32-32 32s-32-14.3-32-32L64 480c0 17.7-14.3 32-32 32S0 497.7 0 480C0 422.2 24.4 375.2 57.4 335.5 81.5 306.6 111.2 280.5 141 256 111.2 231.5 81.5 205.4 57.4 176.5 24.4 136.8 0 89.8 0 32 0 14.3 14.3 0 32 0S64 14.3 64 32l256 0c0-17.7 14.3-32 32-32zM283.5 384l-182.9 0c-8.2 10.5-15.1 21.1-20.6 32l224.2 0c-5.6-10.9-12.5-21.5-20.6-32zM238 336c-14.3-13-29.8-25.8-46-39-16.2 13.1-31.7 26-46 39l92 0zM100.5 128l182.9 0c8.2-10.5 15.1-21.1 20.6-32L79.9 96c5.6 10.9 12.5 21.5 20.6 32zM146 176c14.3 13 29.8 25.8 46 39 16.2-13.1 31.7-26 46-39l-92 0z"],
    "circle-bangladeshi-taka": [512, 512, [], "e701", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM136.5 147.3c2.6-13 15.2-21.4 28.2-18.8l10.6 2.1c28.3 5.7 48.7 30.5 48.7 59.4l0 18 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0 0 83.4c0 6.9 5.6 12.6 12.6 12.6l24 0c37.2 0 67.4-30.2 67.4-67.4l0-16c0-6.9-5.6-12.6-12.6-12.6l-3.4 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l3.4 0c33.5 0 60.6 27.1 60.6 60.6l0 16C376 332.3 324.3 384 260.6 384l-24 0c-33.5 0-60.6-27.1-60.6-60.6l0-83.4-13.7 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l13.7 0 0-18c0-6-4.2-11.2-10.1-12.3l-10.6-2.1c-13-2.6-21.4-15.2-18.8-28.2z"],
    "box-circle-check": [576, 512, [], "e0c4", "M401.4 128l-34.3-48-222.1 0-34.3 48 290.7 0zM32 148.5c0-13.3 4.2-26.3 11.9-37.2L92.9 42.8C104.9 26 124.3 16 144.9 16l222.1 0c20.7 0 40.1 10 52.1 26.8l48.9 68.5c7.8 10.9 11.9 23.9 11.9 37.2l0 65.5c-15.3-3.9-31.4-6-48-6-106 0-192 86-192 192 0 28.6 6.2 55.6 17.4 80L96 480c-35.3 0-64-28.7-64-64l0-267.5zM288 400a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm201.4-60.9c-7.1-5.2-17.2-3.6-22.4 3.5l-53 72.9-26.8-26.8c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l40 40c3.3 3.3 7.9 5 12.6 4.6s8.9-2.8 11.7-6.5l64-88c5.2-7.1 3.6-17.2-3.5-22.3z"],
    "trillium": [448, 512, [], "e588", "M224 405.4c5.4 4.4 11.2 8.4 17.4 12l7.3 3.9c12.1 6.1 24.8 10.3 37.6 13.2-18.5 27-40.1 48.9-52.4 60.4-5.6 5.3-14.1 5.3-19.7 0-12.3-11.5-33.9-33.4-52.4-60.3 15.4-3.5 30.7-8.9 45-17.1l8.5-5.3c3.1-2.1 6-4.3 8.8-6.6zM214.3 8.9c5.6-5.3 14.1-5.3 19.7 0 24.5 23 86.1 87 86.1 151.1 0 15.7-3.7 30.4-10.4 43.5 16.2 0 32.6 4.2 47.7 12.9 55.5 32 80.2 117.5 87.8 150.2 1.7 7.5-2.5 14.9-9.9 17.1-32.1 9.7-118.5 31-174-1-16.6-9.6-29.2-23.3-37.3-39.2-8.1 15.8-20.8 29.6-37.4 39.2-55.5 32-141.8 10.7-173.9 1-7.4-2.2-11.6-9.6-9.9-17.1 7.6-32.7 32.3-118.1 87.8-150.2 15.1-8.7 31.6-12.9 47.8-12.9-6.6-13.1-10.4-27.8-10.4-43.5 0-64.1 61.6-128.2 86.1-151.1zM224.2 200a40 40 0 1 0 0 80 40 40 0 1 0 0-80zM98.5 104.4c-6.3 17.4-10.3 36.1-10.3 55.6 0 4.4 .2 8.7 .7 13-3.4 1.3-6.7 2.8-10 4.4l-8.1 4.3c-15.6 9-29 20.8-40.3 33.7-15-30.4-23.5-61.4-27.5-78.3-1.7-7.5 2.5-14.9 9.9-17.1 17.3-5.2 50.3-13.8 85.7-15.6zm251.3 0c35.4 1.8 68.3 10.4 85.6 15.6 7.4 2.2 11.6 9.6 9.9 17.1-3.9 16.9-12.5 47.9-27.5 78.3-9.6-11-20.7-21.1-33.4-29.4l-7-4.3c-5.8-3.4-11.9-6.3-18-8.7 .2-1.6 .3-3.2 .4-4.8l.3-8.2c0-19.5-4.1-38.2-10.3-55.6z"],
    "delete-right": [640, 512, [], "e154", "M64 128c0-35.3 28.7-64 64-64l306.7 0c17 0 33.3 6.7 45.3 18.7L630.6 233.4c6 6 9.4 14.1 9.4 22.6s-3.4 16.6-9.4 22.6L480 429.3c-12 12-28.3 18.7-45.3 18.7L128 448c-35.3 0-64-28.7-64-64l0-256zm291.9 60.1c-9.4-9.4-24.6-9.4-33.9 0l-33.9 33.9-33.9-33.9c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l33.9 33.9-33.9 33.9c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l33.9-33.9 33.9 33.9c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-33.9-33.9 33.9-33.9c9.4-9.4 9.4-24.6 0-33.9z"],
    "circle-colon": [512, 512, [], "e6fc", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm23.2-394.9l-4.1 12.4c9.7 1.4 19 4 27.8 7.4l10-29.9c2.8-8.4 11.9-12.9 20.2-10.1s12.9 11.9 10.1 20.2l-11.8 35.5c4.4 3.2 8.6 6.7 12.5 10.4 9.6 9.1 10.1 24.3 1 33.9-7.8 8.3-20.2 9.8-29.6 4.2L270.6 334.7c15.4-2.9 29.3-10.1 40.3-20.5 9.6-9.1 24.8-8.7 33.9 1s8.7 24.8-1 33.9c-22.9 21.6-53.9 34.9-87.9 34.9-.6 0-1.2 0-1.8 0l-7 21.1c-2.8 8.4-11.9 12.9-20.2 10.1s-12.9-11.9-10.1-20.2l5.2-15.5c-9.4-2.6-18.3-6.2-26.7-10.7l-12.1 36.3c-2.8 8.4-11.9 12.9-20.2 10.1s-12.9-11.9-10.1-20.2l15.3-45.9c-24.7-23.3-40.1-56.4-40.1-93.1 0-65.8 49.7-120 113.5-127.2l7.3-21.9c2.8-8.4 11.9-12.9 20.2-10.1s12.9 11.9 10.1 20.2zM176 256c0 14.2 3.7 27.5 10.1 39l37.4-112.1c-28 12.5-47.5 40.5-47.5 73.1zm61.2 77.8l50.4-151.3c-8.7-3.7-18.2-6-28.1-6.4L210.9 322c7.9 5.4 16.8 9.4 26.4 11.7z"],
    "child-reaching": [384, 512, [], "e59d", "M256 64a64 64 0 1 0 -128 0 64 64 0 1 0 128 0zM152.9 169.3c-23.7-8.4-44.5-24.3-58.8-45.8L74.6 94.2C64.8 79.5 45 75.6 30.3 85.4S11.6 115 21.4 129.8L40.9 159c18.1 27.1 42.8 48.4 71.1 62.4L112 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-96 32 0 0 96c0 17.7 14.3 32 32 32s32-14.3 32-32l0-258.4c29.1-14.2 54.4-36.2 72.7-64.2l18.2-27.9c9.6-14.8 5.4-34.6-9.4-44.3s-34.6-5.5-44.3 9.4L291 122.4c-21.8 33.4-58.9 53.6-98.8 53.6-12.6 0-24.9-2-36.6-5.8-.9-.3-1.8-.7-2.7-.9z"],
    "face-confounded": [512, 512, [], "e36c", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM125.8 212.3c-6.2-5.2-7.6-14.3-3.1-21.1s13.3-9.2 20.6-5.5l79.6 40c5.4 2.7 8.8 8.2 8.8 14.3s-3.4 11.6-8.8 14.3l-79.6 40c-7.3 3.6-16.1 1.3-20.6-5.5s-3.1-15.9 3.1-21.1L159 240 125.8 212.3zm263.6-21.1c4.5 6.8 3.1 15.9-3.1 21.1L353 240 386.2 267.7c6.2 5.2 7.6 14.3 3.1 21.1s-13.3 9.2-20.6 5.5l-79.6-40c-5.4-2.7-8.8-8.2-8.8-14.3s3.4-11.6 8.8-14.3l79.6-40c7.3-3.6 16.1-1.3 20.6 5.5zM228.5 344.4l27.5 22 27.5-22c6.8-5.4 16.3-5.9 23.6-1l39.9 26.6 14.7-4.9c10.5-3.5 21.8 2.2 25.3 12.6s-2.2 21.8-12.6 25.3l-24 8c-5.9 2-12.3 1.1-17.4-2.3l-35.8-23.9-28.6 22.9c-7.3 5.8-17.7 5.8-25 0l-28.6-22.9-35.8 23.9c-5.1 3.4-11.6 4.3-17.4 2.3l-24-8c-10.5-3.5-16.1-14.8-12.6-25.3s14.8-16.1 25.3-12.6l14.7 4.9 39.9-26.6c7.2-4.8 16.8-4.4 23.6 1z"],
    "sidebar": [512, 512, [], "e24e", "M448 448l-192 0 0-384 192 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64zM64 64l144 0 0 384-144 0c-35.3 0-64-28.7-64-64L0 128C0 92.7 28.7 64 64 64zm8 64c-13.3 0-24 10.7-24 24s10.7 24 24 24l64 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-64 0zM48 240c0 13.3 10.7 24 24 24l64 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-64 0c-13.3 0-24 10.7-24 24zm24 64c-13.3 0-24 10.7-24 24s10.7 24 24 24l64 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-64 0z"],
    "paste": [512, 512, ["file-clipboard"], "f0ea", "M64 0C28.7 0 0 28.7 0 64L0 384c0 35.3 28.7 64 64 64l112 0 0-224c0-61.9 50.1-112 112-112l64 0 0-48c0-35.3-28.7-64-64-64L64 0zM248 112l-144 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24zm40 48c-35.3 0-64 28.7-64 64l0 224c0 35.3 28.7 64 64 64l160 0c35.3 0 64-28.7 64-64l0-165.5c0-17-6.7-33.3-18.7-45.3l-58.5-58.5c-12-12-28.3-18.7-45.3-18.7L288 160z"],
    "inhaler": [640, 512, [], "f5f9", "M224 288c0-35.3 28.7-64 64-64l80 0 24.5-91.9 174.6 155.2-41.8 146.3c-7.8 27.5-33 46.4-61.5 46.4L288 480c-35.3 0-64-28.7-64-64l0-128zm357.7-51.9L406.3 80.2 416.1 43.8c8.9-33.3 42.6-53.6 76.2-45.9l82.1 18.9c35.7 8.2 57.2 44.7 47.1 79.9L581.7 236.1zM32 320a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM64 448a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm64-176a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM64 256a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm64 112a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "meteor": [512, 512, [9732], "f753", "M493.7 .9l-194.2 74.7 2.3-29.3c1-12.8-12.8-21.5-24-15.1L101.3 133.4C38.6 169.7 0 236.6 0 309 0 421.1 90.9 512 203 512 275.4 512 342.3 473.4 378.6 410.7L480.8 234.3c6.5-11.1-2.2-25-15.1-24l-29.3 2.3 74.7-194.2c.6-1.5 .9-3.2 .9-4.8 0-7.5-6-13.5-13.5-13.5-1.7 0-3.3 .3-4.8 .9zM192 192a128 128 0 1 1 0 256 128 128 0 1 1 0-256zm0 96a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm16 96a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"],
    "honey-pot": [448, 512, [127855], "e418", "M128 32L64 32C46.3 32 32 46.3 32 64S46.3 96 64 96c-38.9 29.2-64 75.7-64 128 0 138.8 79.6 217.9 113.3 245.1 9.3 7.5 21.1 10.9 33.1 10.9l155.3 0c12 0 23.7-3.3 33.1-10.9 33.6-27.2 113.3-106.3 113.3-245.1 0-52.3-25.1-98.8-64-128 17.7 0 32-14.3 32-32s-14.3-32-32-32l-208 0 0 104c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-104zM64 224l320 0c0 53.7-14.7 96.1-32.9 128L96.9 352C78.7 320.1 64 277.7 64 224z"],
    "laptop-slash": [640, 512, [], "e1c7", "M73-24.9c-9.4-9.4-24.6-9.4-33.9 0S29.7-.3 39 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-24.3-24.3c36-6.4 63.3-37.8 63.3-75.6 0-10.6-8.6-19.2-19.2-19.2l-139 0-288-288 318.2 0 0 240 64 0 0-240c0-35.3-28.7-64-64-64L129.8 32 73-24.9zM128 166l-64-64 0 234 64 0 0-170zM442 480l-96-96-326.8 0C8.6 384 0 392.6 0 403.2 0 445.6 34.4 480 76.8 480L442 480z"],
    "gears": [640, 512, ["cogs"], "f085", "M415.9 210.5c12.2-3.3 25 2.5 30.5 13.8L465 261.9c10.3 1.4 20.4 4.2 29.9 8.1l35-23.3c10.5-7 24.4-5.6 33.3 3.3l19.2 19.2c8.9 8.9 10.3 22.9 3.3 33.3l-23.3 34.9c1.9 4.7 3.6 9.6 5 14.7 1.4 5.1 2.3 10.1 3 15.2l37.7 18.6c11.3 5.6 17.1 18.4 13.8 30.5l-7 26.2c-3.3 12.1-14.6 20.3-27.2 19.5l-42-2.7c-6.3 8.1-13.6 15.6-21.9 22l2.7 41.9c.8 12.6-7.4 24-19.5 27.2l-26.2 7c-12.2 3.3-24.9-2.5-30.5-13.8l-18.6-37.6c-10.3-1.4-20.4-4.2-29.9-8.1l-35 23.3c-10.5 7-24.4 5.6-33.3-3.3l-19.2-19.2c-8.9-8.9-10.3-22.8-3.3-33.3l23.3-35c-1.9-4.7-3.6-9.6-5-14.7s-2.3-10.2-3-15.2l-37.7-18.6c-11.3-5.6-17-18.4-13.8-30.5l7-26.2c3.3-12.1 14.6-20.3 27.2-19.5l41.9 2.7c6.3-8.1 13.6-15.6 21.9-22l-2.7-41.8c-.8-12.6 7.4-24 19.5-27.2l26.2-7zM448.4 340a44 44 0 1 0 .1 88 44 44 0 1 0 -.1-88zM224.9-45.5l26.2 7c12.1 3.3 20.3 14.7 19.5 27.2l-2.7 41.8c8.3 6.4 15.6 13.8 21.9 22l42-2.7c12.5-.8 23.9 7.4 27.2 19.5l7 26.2c3.2 12.1-2.5 24.9-13.8 30.5l-37.7 18.6c-.7 5.1-1.7 10.2-3 15.2s-3.1 10-5 14.7l23.3 35c7 10.5 5.6 24.4-3.3 33.3L307.3 262c-8.9 8.9-22.8 10.3-33.3 3.3L239 242c-9.5 3.9-19.6 6.7-29.9 8.1l-18.6 37.6c-5.6 11.3-18.4 17-30.5 13.8l-26.2-7c-12.2-3.3-20.3-14.7-19.5-27.2l2.7-41.9c-8.3-6.4-15.6-13.8-21.9-22l-42 2.7c-12.5 .8-23.9-7.4-27.2-19.5l-7-26.2c-3.2-12.1 2.5-24.9 13.8-30.5l37.7-18.6c.7-5.1 1.7-10.1 3-15.2 1.4-5.1 3-10 5-14.7L55.1 46.5c-7-10.5-5.6-24.4 3.3-33.3L77.6-6c8.9-8.9 22.8-10.3 33.3-3.3l35 23.3c9.5-3.9 19.6-6.7 29.9-8.1l18.6-37.6c5.6-11.3 18.3-17 30.5-13.8zM192.4 84a44 44 0 1 0 0 88 44 44 0 1 0 0-88z"],
    "wave-sine": [576, 512, [8767], "f899", "M24.5 153c20.1-53.5 71.2-89 128.4-89 56.1 0 106.5 34.1 127.3 86.2L355.3 338c11.1 27.8 38 46 67.9 46 30.5 0 57.8-18.9 68.5-47.4L514 276.8c6.2-16.5 24.6-24.9 41.2-18.7s24.9 24.6 18.7 41.2L551.5 359c-20.1 53.5-71.2 89-128.4 89-56.1 0-106.5-34.1-127.3-86.2L220.7 174c-11.1-27.8-38-46-67.9-46-30.5 0-57.8 18.9-68.5 47.4L62 235.2c-6.2 16.5-24.7 24.9-41.2 18.7S-4.2 229.3 2 212.8L24.5 153z"],
    "arrow-turn-left-up": [384, 512, [], "e634", "M352 448c17.7 0 32 14.3 32 32s-14.3 32-32 32l-96 0c-53 0-96-43-96-96l0-306.7-73.4 73.4c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l128-128c12.5-12.5 32.8-12.5 45.3 0l128 128c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L224 109.3 224 416c0 17.7 14.3 32 32 32l96 0z"],
    "garage": [576, 512, [], "e009", "M0 480L0 142.1c0-27.5 17.6-52 43.8-60.7L272.8 5.1c9.9-3.3 20.5-3.3 30.4 0L532.2 81.4c26.1 8.7 43.8 33.2 43.8 60.7L576 480c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-256c0-17.7-14.3-32-32-32L96 192c-17.7 0-32 14.3-32 32l0 256c0 17.7-14.3 32-32 32S0 497.7 0 480zM464 240l0 80-352 0 0-80 352 0zM112 368l352 0 0 144-352 0 0-144zm240 48l-128 0 0 48 128 0 0-48z"],
    "flatbread-stuffed": [512, 512, [129369], "e40c", "M408.6 35.6c-4.6-2.6-9.8-3.9-15.3-3.7l-63.5 2.2c-6.2 .2-12.3-1.5-17.4-5L259.6-6.4c-11.3-7.6-26.2-6.5-36.4 2.7L175.7 39.1c-4.6 4.2-10.4 6.8-16.6 7.5L95.9 53.7C82.4 55.2 71.6 65.8 69.7 79.3l-9.3 63.5c-.9 6.2-3.7 12-8 16.5L8.3 205.7c-9.4 9.9-11 25-3.9 36.6l33.3 54.4c3.3 5.3 4.8 11.5 4.3 17.8l-4.4 64c-.5 7.9 2 15.4 6.8 21.2l84.2-84.2c-10.5-14.5-16.6-32.3-16.6-51.5 0-48.6 39.4-88 88-88 19.2 0 37 6.2 51.5 16.6l157-157zM458.3 99C447.4 85 427 85.1 414.5 97.6L97.7 414.4c-12.5 12.5-12.6 32.9 1.3 43.8 43.4 33.7 97.9 53.8 157 53.8 141.4 0 256-114.6 256-256 0-59.2-20.1-113.7-53.8-157zM224.1 392a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm56 40a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm8-104a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"],
    "u-turn-down-left": [512, 512, [], "e7ef", "M512 240c0 114.9-93.1 208-208 208l-128 0 0 48c0 12.9-7.8 24.6-19.7 29.6s-25.7 2.2-34.9-6.9l-112-112-2.2-2.4c-10.2-12.6-9.5-31.1 2.2-42.8l112-112c9.2-9.2 22.9-11.9 34.9-6.9S176 259.1 176 272l0 48 128 0c44.2 0 80-35.8 80-80s-35.8-80-80-80L96 160c-17.7 0-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32l208 0c114.9 0 208 93.1 208 208z"],
    "face-shaking-horizontal": [640, 512, [], "e79d", "M472 288l80 0c33.4 0 64-12 87.6-32-4 44.9-41.7 80-87.6 80l-80 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l37.8 0c-44.3 76.5-127 128-221.8 128-141.4 0-256-114.6-256-256S146.6 0 288 0C407.3 0 507.5 81.6 535.9 192l16.1 0c22.1 0 40-17.9 40-40s-17.9-40-40-40c-13.3 0-24-10.7-24-24s10.7-24 24-24c48.6 0 88 39.4 88 88s-39.4 88-88 88l-80 0c-13.3 0-24 10.7-24 24s10.7 24 24 24zM131.9 316.6c-10.7 7.8-13.1 22.8-5.3 33.5 29.1 39.9 76.2 65.9 129.4 65.9s100.3-26 129.4-65.9c7.8-10.7 5.4-25.7-5.3-33.5s-25.7-5.4-33.5 5.3c-20.4 28-53.4 46.1-90.6 46.1s-70.2-18.1-90.6-46.1c-7.8-10.7-22.8-13.1-33.5-5.3zM148 216c0-11 9-20 20-20l16 0c11 0 20 9 20 20s9 20 20 20 20-9 20-20c0-33.1-26.9-60-60-60l-16 0c-33.1 0-60 26.9-60 60 0 11 9 20 20 20s20-9 20-20zm180-20l16 0c11 0 20 9 20 20s9 20 20 20 20-9 20-20c0-33.1-26.9-60-60-60l-16 0c-33.1 0-60 26.9-60 60 0 11 9 20 20 20s20-9 20-20 9-20 20-20z"],
    "eyes": [576, 512, [], "e367", "M96 224c-11.2 0-21.7 2.9-30.9 7.9 3.5-37.5 15.1-70.1 31-93.9 19.3-29 42.6-42 63.9-42s44.5 13 63.9 42c19.2 28.8 32.1 70.4 32.1 118s-12.9 89.2-32.1 118c-19.3 29-42.6 42-63.9 42s-44.5-13-63.9-42c-4.7-7-9-14.8-12.8-23.3 4.1 .8 8.4 1.3 12.7 1.3 35.3 0 64-28.7 64-64s-28.7-64-64-64zM288 120.6c-3.4-6.3-7-12.4-10.9-18.2-27-40.5-67.8-70.5-117.1-70.5S69.8 62 42.9 102.5C15.7 143.2 0 197.5 0 256S15.7 368.8 42.9 409.5C69.8 450 110.6 480 160 480s90.2-30 117.1-70.5c3.9-5.8 7.5-11.8 10.9-18.2 3.4 6.3 7 12.4 10.9 18.2 27 40.5 67.8 70.5 117.1 70.5s90.2-30 117.1-70.5C560.3 368.8 576 314.5 576 256s-15.7-112.8-42.9-153.5C506.2 62 465.4 32 416 32s-90.2 30-117.1 70.5c-3.9 5.8-7.5 11.8-10.9 18.2zm51.3 230.1c4.1 .8 8.4 1.3 12.7 1.3 35.3 0 64-28.7 64-64s-28.7-64-64-64c-11.2 0-21.7 2.9-30.9 7.9 3.5-37.5 15.1-70.1 31-93.9 19.4-29 42.6-42 63.9-42s44.5 13 63.9 42c19.2 28.8 32.1 70.4 32.1 118s-12.9 89.2-32.1 118c-19.4 29-42.6 42-63.9 42s-44.5-13-63.9-42c-4.7-7-9-14.8-12.8-23.3z"],
    "dash": [512, 512, ["minus-large"], "e404", "M0 256c0-17.7 14.3-32 32-32l448 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 288c-17.7 0-32-14.3-32-32z"],
    "photo-film-music": [640, 512, [], "e228", "M192 64c0-35.3 28.7-64 64-64L544 0c35.3 0 64 28.7 64 64l0 120.4c-6.8-.8-13.8-.6-20.9 .6l-64.1 11.7-54.5-89.2C464.1 100.4 456.4 96 448 96s-16.1 4.4-20.5 11.5l-54 88.3-17.9-25.6c-4.5-6.4-11.8-10.2-19.7-10.2s-15.2 3.8-19.7 10.2l-56 80c-5.1 7.3-5.8 16.9-1.6 24.8S271.1 288 280 288l72 0 0 64-96 0c-35.3 0-64-28.7-64-64l0-224zM352 403.8c-15.3 3.8-29.7 10.5-42.1 19.7-8.7 6.5-16.8 14.8-23.3 24.5L64 448c-35.3 0-64-28.7-64-64L0 160c0-35.3 28.7-64 64-64l80 0 0 192c0 61.9 50.1 112 112 112l96 0 0 3.8zM320 96a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM52 164l0 24c0 8.8 7.2 16 16 16l24 0c8.8 0 16-7.2 16-16l0-24c0-8.8-7.2-16-16-16l-24 0c-8.8 0-16 7.2-16 16zm16 80c-8.8 0-16 7.2-16 16l0 24c0 8.8 7.2 16 16 16l24 0c8.8 0 16-7.2 16-16l0-24c0-8.8-7.2-16-16-16l-24 0zm0 96c-8.8 0-16 7.2-16 16l0 24c0 8.8 7.2 16 16 16l24 0c8.8 0 16-7.2 16-16l0-24c0-8.8-7.2-16-16-16l-24 0zm556-84.1l0 208c0 23.3-18 35.4-29.1 40.5-11.9 5.4-25.4 7.5-34.9 7.5s-22.9-2.1-34.9-7.5c-11.1-5-29.1-17.2-29.1-40.5s18-35.4 29.1-40.5c11.9-5.4 25.4-7.5 34.9-7.5 4.6 0 10.1 .5 16 1.6l0-84.9-128 23.3 0 139.9c0 23.3-18 35.4-29.1 40.5-11.9 5.4-25.4 7.5-34.9 7.5s-22.9-2.1-34.9-7.5c-11.1-5-29.1-17.2-29.1-40.5s18-35.4 29.1-40.5c11.9-5.4 25.4-7.5 34.9-7.5 4.6 0 10.1 .5 16 1.6l0-161.6c0-11.6 8.3-21.5 19.7-23.6l176-32c7-1.3 14.2 .6 19.7 5.2s8.6 11.3 8.6 18.4z"],
    "location-arrow-slash": [576, 512, [], "e77a", "M41-24.9c-9.4-9.4-24.6-9.4-33.9 0S-2.3-.3 7 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9L407.5 341.7 509.9 75.5c4.5-11.8 1.7-25.2-7.2-34.1s-22.3-11.8-34.1-7.2L202.4 136.5 41-24.9zm63.4 199.1L52.5 194.1C39.9 199 31.7 211.2 32 224.7s9.1 25.4 21.9 29.6l176.8 58.9 58.9 176.8c4.3 12.8 16.1 21.6 29.6 21.9s25.7-7.9 30.6-20.5l19.9-51.9-265.4-265.4z"],
    "circle-m": [512, 512, [], "e115", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM187.4 153.8l68.6 93.6 68.6-93.6c6.1-8.4 17-11.8 26.8-8.6S368 157.6 368 168l0 176c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-102.7-44.6 60.9c-4.5 6.2-11.7 9.8-19.4 9.8s-14.8-3.6-19.4-9.8L192 241.3 192 344c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-176c0-10.4 6.7-19.6 16.5-22.8s20.7 .2 26.8 8.6z"],
    "arrow-up-to-dotted-line": [384, 512, [], "e0a1", "M64 32A32 32 0 1 1 0 32 32 32 0 1 1 64 32zM169.4 137.4c12.5-12.5 32.8-12.5 45.3 0l128 128c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L224 237.3 224 480c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-242.7-73.4 73.4c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l128-128zM138.7 64a32 32 0 1 1 0-64 32 32 0 1 1 0 64zM277.3 32a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM352 64a32 32 0 1 1 0-64 32 32 0 1 1 0 64z"],
    "file-circle-plus": [576, 512, [58606], "e494", "M96 0C60.7 0 32 28.7 32 64l0 384c0 35.3 28.7 64 64 64l180 0c-22.7-31.5-36-70.2-36-112 0-100.6 77.4-183.2 176-191.3l0-38.1c0-17-6.7-33.3-18.7-45.3L290.7 18.7C278.7 6.7 262.5 0 245.5 0L96 0zM357.5 176L264 176c-13.3 0-24-10.7-24-24L240 58.5 357.5 176zM432 544a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm16-208l0 48 48 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-48 0 0 48c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-48-48 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l48 0 0-48c0-8.8 7.2-16 16-16s16 7.2 16 16z"],
    "mustache": [640, 512, [], "e5bc", "M147.9 148.4c21.4-23.2 51.5-36.4 83.1-36.4 35.4 0 66.3 16.7 89 43.1 22.6-26.4 53.6-43.1 89-43.1 31.6 0 61.7 13.2 83.1 36.4l2 2.1c27.6 29.9 74.6 30.9 103.4 2.1 9.8-9.8 25-12 35.5-1.6 4.7 4.7 7 10.8 7 17l0 39.4c0 106.4-86.2 192.6-192.6 192.6-46.7 0-91.7-16.9-126.9-47.7l-.5-.4-.5 .4C284.4 383.1 239.3 400 192.6 400 86.2 400 0 313.8 0 207.4L0 168c0-6.1 2.3-12.3 7-17 10.4-10.4 25.7-8.2 35.5 1.6 28.8 28.8 75.8 27.9 103.4-2.1l2-2.1z"],
    "window-frame": [448, 512, [129695], "e04f", "M416 256l0 192c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 512c-17.7 0-32-14.3-32-32s14.3-32 32-32L32 64C32 28.7 60.7 0 96 0L352 0c35.3 0 64 28.7 64 64l0 192zm-64 32l-96 0 0 160 96 0 0-160zm0-64l0-160-96 0 0 160 96 0zm-160 0l0-160-96 0 0 160 96 0zM96 288l0 160 96 0 0-160-96 0z"],
    "house-night": [640, 512, [], "e010", "M125.2-15.9c6.2-4.4 5.4-14.8-2.2-15.6-3.6-.4-7.3-.5-11-.5-61.9 0-112 50.1-112 112S50.1 192 112 192c32.1 0 61.1-13.5 81.5-35.2 5.2-5.6-1-14-8.6-13.2-2.9 .3-5.9 .4-9 .4-48.6 0-88-39.4-88-88 0-29.7 14.7-55.9 37.2-71.9zM560 336l19.9 0c15.5 0 28.1-12.6 28.1-28.1 0-7.6-3.1-14.9-8.6-20.2L395.5 91.1C388.1 84 378.3 80 368 80s-20.1 4-27.5 11.1L136.6 287.7c-5.5 5.3-8.6 12.6-8.6 20.2 0 15.5 12.6 28.1 28.1 28.1l19.9 0 0 144c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-144zM320 312c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-48zM520 72L487.4 85c-4.5 1.8-7.4 6.1-7.4 11s2.9 9.2 7.4 11l32.6 13 13 32.6c1.8 4.5 6.1 7.4 11 7.4s9.2-2.9 11-7.4l13-32.6 32.6-13c4.5-1.8 7.4-6.1 7.4-11s-2.9-9.2-7.4-11L568 72 555 39.4c-1.8-4.5-6.1-7.4-11-7.4s-9.2 2.9-11 7.4L520 72zM245-24.6L232 8 199.4 21c-4.5 1.8-7.4 6.1-7.4 11s2.9 9.2 7.4 11L232 56 245 88.6c1.8 4.5 6.1 7.4 11 7.4s9.2-2.9 11-7.4L280 56 312.6 43c4.5-1.8 7.4-6.1 7.4-11s-2.9-9.2-7.4-11L280 8 267-24.6c-1.8-4.5-6.1-7.4-11-7.4s-9.2 2.9-11 7.4z"],
    "reel": [448, 512, [], "e238", "M32 32C32 14.3 46.3 0 64 0L384 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l0 32-320 0 0-32C46.3 64 32 49.7 32 32zm0 448c0-17.7 14.3-32 32-32l0-32 320 0 0 32c17.7 0 32 14.3 32 32s-14.3 32-32 32L64 512c-17.7 0-32-14.3-32-32zM88 136l272 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L88 184c-13.3 0-24-10.7-24-24s10.7-24 24-24zm0 96l336 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L88 280c-13.3 0-24-10.7-24-24s10.7-24 24-24zM64 352c0-13.3 10.7-24 24-24l272 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L88 376c-13.3 0-24-10.7-24-24z"],
    "icicles": [512, 512, [], "f7ad", "M75.8 304.8L1 35.7C.3 33.2 0 30.7 0 28.2 0 12.6 12.6 0 28.2 0L482.4 0c16.3 0 29.6 13.2 29.6 29.6 0 1.6-.1 3.3-.4 4.9L434.6 496.1c-1.5 9.2-9.5 15.9-18.8 15.9-9.2 0-17.1-6.6-18.7-15.6L336 160 307.2 303.9c-1.9 9.3-10.1 16.1-19.6 16.1-9.2 0-17.2-6.2-19.4-15.1L240 192 210.6 368.2c-1.5 9.1-9.4 15.8-18.6 15.8s-17.1-6.7-18.6-15.8L144 192 115.9 304.3c-2.3 9.2-10.6 15.7-20.1 15.7-9.3 0-17.5-6.2-20-15.2z"],
    "binary-slash": [576, 512, [], "e33e", "M41-24.9c-9.4-9.4-24.6-9.4-33.9 0S-2.3-.3 7 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-89-89 0-62.2c0-35.3-28.7-64-64-64l-62.2 0-83.7-83.7c11-11.5 17.8-27.1 17.8-44.3l0-96c0-35.3-28.7-64-64-64L160 0c-25.5 0-47.4 14.9-57.8 36.4L41-24.9zm119 119l0-30.2 64 0 0 94.2-64-64zM288 357.8l0 90.2c0 35.3 28.7 64 64 64l64 0c7.8 0 15.3-1.4 22.2-4L288 357.8zM432 32c0-10.3-4.9-19.9-13.3-26s-19.1-7.7-28.8-4.4l-48 16c-16.8 5.6-25.8 23.7-20.2 40.5s23.7 25.8 40.5 20.2l5.9-2 0 83.6-16 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l96 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-16 0 0-128zM208 320c0-10.3-4.9-19.9-13.3-26s-19.1-7.7-28.8-4.4l-48 16c-16.8 5.6-25.8 23.7-20.2 40.5s23.7 25.8 40.5 20.2l5.9-2 0 83.6-16 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l96 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-16 0 0-128z"],
    "square-sliders-vertical": [448, 512, ["sliders-v-square"], "f3f2", "M0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm144 0c-13.3 0-24 10.7-24 24l0 40-32 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l32 0 0 184c0 13.3 10.7 24 24 24s24-10.7 24-24l0-184 32 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-32 0 0-40c0-13.3-10.7-24-24-24zm184 24c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 184-32 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l32 0 0 40c0 13.3 10.7 24 24 24s24-10.7 24-24l0-40 32 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-32 0 0-184z"],
    "arrow-trend-up": [576, 512, [], "e098", "M384 160c-17.7 0-32-14.3-32-32s14.3-32 32-32l160 0c17.7 0 32 14.3 32 32l0 160c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-82.7-169.4 169.4c-12.5 12.5-32.8 12.5-45.3 0L192 269.3 54.6 406.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l160-160c12.5-12.5 32.8-12.5 45.3 0L320 306.7 466.7 160 384 160z"],
    "timeline-arrow": [576, 512, [], "e29d", "M176 96c0 32.8-19.7 61-48 73.3l0 54.7 192 0 0-54.7c-28.3-12.3-48-40.5-48-73.3 0-44.2 35.8-80 80-80s80 35.8 80 80c0 32.8-19.7 61-48 73.3l0 54.7 80 0 0-32c0-9.7 5.8-18.5 14.8-22.2s19.3-1.7 26.2 5.2l64 64c9.4 9.4 9.4 24.6 0 33.9l-64 64c-6.9 6.9-17.2 8.9-26.2 5.2S464 329.7 464 320l0-32-208 0 0 54.7c28.3 12.3 48 40.5 48 73.3 0 44.2-35.8 80-80 80s-80-35.8-80-80c0-32.8 19.7-61 48-73.3l0-54.7-160 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l32 0 0-54.7C35.7 157 16 128.8 16 96 16 51.8 51.8 16 96 16s80 35.8 80 80z"],
    "fort": [576, 512, [], "e486", "M24 32C10.7 32 0 42.7 0 56L0 208c0 20.9 13.4 38.7 32 45.3L32 448c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-194.7c18.6-6.6 32-24.4 32-45.3l0-152c0-13.3-10.7-24-24-24l-16 0c-13.3 0-24 10.7-24 24l0 40-32 0 0-40c0-13.3-10.7-24-24-24l-16 0c-13.3 0-24 10.7-24 24l0 40-32 0 0-40c0-13.3-10.7-24-24-24l-16 0c-13.3 0-24 10.7-24 24l0 104-64 0 0-104c0-13.3-10.7-24-24-24l-16 0c-13.3 0-24 10.7-24 24l0 40-32 0 0-40c0-13.3-10.7-24-24-24l-16 0c-13.3 0-24 10.7-24 24l0 40-32 0 0-40c0-13.3-10.7-24-24-24L24 32zM288 320c35.3 0 64 28.7 64 64l0 80-128 0 0-80c0-35.3 28.7-64 64-64z"],
    "circle-v": [512, 512, [], "e12a", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM189.5 157.3L256 290.3 322.5 157.3c5.9-11.9 20.3-16.7 32.2-10.7s16.7 20.3 10.7 32.2l-88 176c-4.1 8.1-12.4 13.3-21.5 13.3s-17.4-5.1-21.5-13.3l-88-176c-5.9-11.9-1.1-26.3 10.7-32.2s26.3-1.1 32.2 10.7z"],
    "hexagon-nodes-bolt": [576, 512, [], "e69a", "M248 106.6c18.9-9 32-28.3 32-50.6c0-30.9-25.1-56-56-56s-56 25.1-56 56c0 22.3 13.1 41.6 32 50.6l0 98.8c-2.8 1.3-5.5 2.9-8 4.7l-80.1-45.8c1.6-20.8-8.6-41.6-27.9-52.8C57.2 96 23 105.2 7.5 132S1.2 193 28 208.5c1.3 .8 2.6 1.5 4 2.1l0 90.8c-1.3 .6-2.7 1.3-4 2.1C1.2 319-8 353.2 7.5 380S57.2 416 84 400.5c19.3-11.1 29.4-32 27.8-52.8l50.5-28.9c-11.5-11.2-19.9-25.6-23.8-41.7L88 306.1c-2.6-1.8-5.2-3.3-8-4.7l0-90.8c2.8-1.3 5.5-2.9 8-4.7l80.1 45.8c-.1 1.4-.2 2.8-.2 4.3c0 22.3 13.1 41.6 32 50.6l0 98.8c-18.9 9-32 28.3-32 50.6c0 30.9 25.1 56 56 56c30.7 0 55.6-24.7 56-55.2c-7.5-12.9-13.5-26.8-17.6-41.5c-4.2-4-9.1-7.3-14.4-9.9l0-98.8c2.8-1.3 5.5-2.9 8-4.7l10.5 6c5.5-15.3 13.1-29.5 22.4-42.5l-9.1-5.2c.1-1.4 .2-2.8 .2-4.3c0-22.3-13.1-41.6-32-50.6l0-98.8zM440.5 132C425 105.2 390.8 96 364 111.5c-19.3 11.1-29.4 32-27.8 52.8l-50.6 28.9c11.5 11.2 19.9 25.6 23.8 41.7L360 205.9c.4 .3 .8 .6 1.3 .9c21.7-9.5 45.6-14.8 70.8-14.8c2 0 4 0 5.9 .1c12.1-17.3 13.8-40.6 2.6-60.1zM432 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm47.9-225c4.3 3.7 5.4 9.9 2.6 14.9L452.4 356l35.6 0c5.2 0 9.8 3.3 11.4 8.2s-.1 10.3-4.2 13.4l-96 72c-4.5 3.4-10.8 3.2-15.1-.6s-5.4-9.9-2.6-14.9L411.6 380 376 380c-5.2 0-9.8-3.3-11.4-8.2s.1-10.3 4.2-13.4l96-72c4.5-3.4 10.8-3.2 15.1 .6z"],
    "light-emergency-on": [640, 512, [], "e420", "M69.3 36c-11-7.4-25.9-4.4-33.3 6.7S31.7 68.6 42.7 76l48 32c11 7.4 25.9 4.4 33.3-6.7s4.4-25.9-6.7-33.3l-48-32zM597.3 76c11-7.4 14-22.3 6.7-33.3s-22.3-14-33.3-6.7l-48 32c-11 7.4-14 22.3-6.7 33.3s22.3 14 33.3 6.7l48-32zM24 192c-13.3 0-24 10.7-24 24s10.7 24 24 24l64 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-64 0zm528 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l64 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-64 0zM320 32c-88.4 0-160 71.6-160 160l0 112 320 0 0-112c0-88.4-71.6-160-160-160zM256 200c0 13.3-10.7 24-24 24s-24-10.7-24-24c0-66.3 53.7-120 120-120 13.3 0 24 10.7 24 24s-10.7 24-24 24c-39.8 0-72 32.2-72 72zM96 384l0 64c0 17.7 14.3 32 32 32l384 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-384 0c-17.7 0-32 14.3-32 32z"],
    "question": [320, 512, [10067, 10068, 61736], "3f", "M64 160c0-53 43-96 96-96s96 43 96 96c0 42.7-27.9 78.9-66.5 91.4-28.4 9.2-61.5 35.3-61.5 76.6l0 24c0 17.7 14.3 32 32 32s32-14.3 32-32l0-24c0-1.7 .6-4.1 3.5-7.3 3-3.3 7.9-6.5 13.7-8.4 64.3-20.7 110.8-81 110.8-152.3 0-88.4-71.6-160-160-160S0 71.6 0 160c0 17.7 14.3 32 32 32s32-14.3 32-32zm96 352c22.1 0 40-17.9 40-40s-17.9-40-40-40-40 17.9-40 40 17.9 40 40 40z"],
    "square-lira": [448, 512, [], "e6e7", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm86.2 217.5c-.2-.5-.4-1-.6-1.5l-5.6 0c-8.8 0-16-7.2-16-16 0-8.7 6.9-15.7 15.5-16 0-46.5 37.5-88 88.1-88l2.1 0c19.7 0 38.8 6.4 54.5 18.2l14.2 10.6c10.6 8 12.8 23 4.8 33.6s-23 12.8-33.6 4.8l-14.2-10.6C252 179 243 176 233.7 176l-2.1 0c-23 0-40.1 18.9-40 40l80.5 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-71.5 0c2.1 7.9 3.2 16 3.5 24l68 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-72 0c-3.2 11.3-8.3 22.1-15.1 32L296 336c13.3 0 24 10.7 24 24s-10.7 24-24 24l-160 0c-9.2 0-17.5-5.2-21.6-13.5s-3-18 2.6-25.3L143.7 311c1.7-2.2 3.3-4.6 4.7-7l-4.4 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l11.9 0c-.4-6.4-1.8-12.9-4.3-19l-1.4-3.5z"],
    "square-dashed-circle-plus": [576, 512, [], "e5c2", "M192 64c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0c-17.7 0-32 14.3-32 32zm-40.2-3.5c-2.2-17.5-18.2-30-35.7-27.8-43.5 5.4-77.9 39.8-83.3 83.3-2.2 17.5 10.3 33.5 27.8 35.7S94.1 141.5 96.2 124c1.8-14.4 13.3-25.9 27.7-27.7 17.5-2.2 30-18.2 27.8-35.7zm208.5 0c-2.2 17.5 10.3 33.5 27.8 35.7 10 1.3 18.8 7.2 23.7 15.8 2.7 4.7 4.3 10.1 4.3 16l0 80.7c5.3-.4 10.6-.7 16-.7 16.6 0 32.7 2.1 48 6l0-86c0-17.4-4.7-33.9-12.9-48l0 0c-14.7-25.3-40.6-43.4-71.2-47.2-17.5-2.2-33.5 10.3-35.7 27.8zM128 416c-5.9 0-11.3-1.6-16-4.3-8.5-4.9-14.5-13.6-15.8-23.7-2.2-17.5-18.2-30-35.7-27.8s-30 18.2-27.8 35.7c3.8 30.5 21.9 56.5 47.2 71.2l0 0c14.2 8.2 30.6 12.9 48 12.9l129.4 0c-9.1-19.8-14.9-41.3-16.8-64L128 416zM64 192c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32s32-14.3 32-32l0-64c0-17.7-14.3-32-32-32zM432 544a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm16-160l48 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-48 0 0 48c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-48-48 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l48 0 0-48c0-8.8 7.2-16 16-16s16 7.2 16 16l0 48z"],
    "chair-office": [448, 512, [], "f6c1", "M160 0L288 0c35.3 0 64 28.7 64 64l0 176-256 0 0-176c0-35.3 28.7-64 64-64zM64 160l0 64c0 17.7-14.3 32-32 32S0 241.7 0 224l0-64c0-17.7 14.3-32 32-32s32 14.3 32 32zm384 0l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32s32 14.3 32 32zM32 352l0-32c0-17.7 14.3-32 32-32l320 0c17.7 0 32 14.3 32 32l0 32c0 17.7-14.3 32-32 32l-128 0 0 64 32 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-128 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l32 0 0-64-128 0c-17.7 0-32-14.3-32-32z"],
    "user-magnifying-glass": [576, 512, [], "e5c5", "M224 248c20.9 0 40.5-5.3 57.7-14.7 10.7-12.2 23.2-22.9 37.1-31.6 15.8-20.3 25.2-45.9 25.2-73.6 0-66.3-53.7-120-120-120S104 61.7 104 128 157.7 248 224 248zm-29.7 56C95.8 304 16 383.8 16 482.3 16 498.7 29.3 512 45.7 512l356.6 0c.6 0 1.1 0 1.7 0-90.9-2.1-164-76.5-164-168 0-13.8 1.7-27.2 4.8-40l-50.5 0zM408 272.1a72 72 0 1 1 0 144 72 72 0 1 1 0-144zm0 192c24.5 0 47.2-7.3 66.2-19.9L535 505.1c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-60.8-60.9c12.6-19 19.9-41.7 19.9-66.2 0-66.3-53.7-120-120-120s-120 53.7-120 120 53.7 120 120 120z"],
    "container-storage": [576, 512, [], "f4b7", "M0 56C0 42.7 10.7 32 24 32l528 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-8 0 0 352 8 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 480c-13.3 0-24-10.7-24-24s10.7-24 24-24l8 0 0-352-8 0C10.7 80 0 69.3 0 56zm120 96l0 208c0 13.3 10.7 24 24 24s24-10.7 24-24l0-208c0-13.3-10.7-24-24-24s-24 10.7-24 24zm216-24c-13.3 0-24 10.7-24 24l0 208c0 13.3 10.7 24 24 24s24-10.7 24-24l0-208c0-13.3-10.7-24-24-24zm72 24l0 208c0 13.3 10.7 24 24 24s24-10.7 24-24l0-208c0-13.3-10.7-24-24-24s-24 10.7-24 24zM240 128c-13.3 0-24 10.7-24 24l0 208c0 13.3 10.7 24 24 24s24-10.7 24-24l0-208c0-13.3-10.7-24-24-24z"],
    "arrow-left-to-bracket": [512, 512, [], "e669", "M160 96L96 96c-17.7 0-32 14.3-32 32l0 256c0 17.7 14.3 32 32 32l64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-64 0c-53 0-96-43-96-96L0 128C0 75 43 32 96 32l64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32zm9.4 182.6c-12.5-12.5-12.5-32.8 0-45.3l128-128c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3L269.3 224 480 224c17.7 0 32 14.3 32 32s-14.3 32-32 32l-210.7 0 73.4 73.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0l-128-128z"],
    "sparkle": [512, 512, [], "e5d6", "M278.5 15.6C275 6.2 266 0 256 0s-19 6.2-22.5 15.6L174.2 174.2 15.6 233.5C6.2 237 0 246 0 256s6.2 19 15.6 22.5l158.6 59.4 59.4 158.6C237 505.8 246 512 256 512s19-6.2 22.5-15.6l59.4-158.6 158.6-59.4C505.8 275 512 266 512 256s-6.2-19-15.6-22.5L337.8 174.2 278.5 15.6z"],
    "campfire": [512, 512, [], "f6ba", "M279.2 43.9s-22.1-26.7-35-37C239.2 2.9 233.8 .2 227.2 0s-13.1 2.1-18.3 6.8c-21.1 19.2-45 44.4-63.8 72.9-18.7 28.3-33.1 61-33.1 95 0 80.5 63.4 145.3 144 145.3 79.8 0 144-64.7 144-145.3 0-27.3-9.9-55.4-23.6-80.1-13.7-24.9-31.8-47.6-49.5-64.2-5-4.7-11.5-7.1-17.9-7.1-6.8 0-14 2.5-18.8 8.1l-11 12.5zm36.5 174.4c0 32.1-26.1 58.2-58.2 58.2s-58.2-26-58.2-58.2c0-33.2 33.7-66.4 49.8-80.4 4.9-4.2 11.9-4.2 16.8 0 16.1 14 49.8 47.2 49.8 80.4zM42.8 289.9c-16.6-5.9-35 2.7-40.9 19.4s2.7 35 19.4 40.9L160.9 400 21.2 449.9C4.6 455.8-4.1 474.1 1.9 490.8s24.3 25.3 40.9 19.4L256 434 469.2 510.1c16.6 5.9 35-2.7 40.9-19.4s-2.7-35-19.4-40.9L351.2 400 490.8 350.1c16.6-5.9 25.3-24.3 19.4-40.9s-24.3-25.3-40.9-19.4L256 366 42.8 289.9z"],
    "hands-bound": [576, 512, [], "e4f9", "M64 32C64 14.3 49.7 0 32 0S0 14.3 0 32L0 213.9c0 14.2 5.1 27.9 14.3 38.7L99.6 352 96 352c-13.3 0-24 10.7-24 24s10.7 24 24 24l384 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-3.6 0 85.3-99.5c9.2-10.8 14.3-24.5 14.3-38.7L576 32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 112.8-69.3 92.4c-5.7 7.6-16.1 9.6-24.2 4.8-9.7-5.7-12.1-18.7-5.1-27.5L441 180c10.8-13.5 8.9-33.3-4.4-44.5s-33-9.8-44.5 3.2l-46.7 52.5C329 209.7 320 233.4 320 258.1l0 93.9-64 0 0-93.9c0-24.6-9-48.4-25.4-66.8l-46.7-52.5c-11.5-13-31.3-14.4-44.5-3.2S124.2 166.4 135 180l27.6 34.5c7 8.8 4.7 21.8-5.1 27.5-8.1 4.8-18.6 2.7-24.2-4.8L64 144.8 64 32zm64 448l0 32 128 0 0-32 64 0 0 32 128 0 0-32 32 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L96 432c-13.3 0-24 10.7-24 24s10.7 24 24 24l32 0z"],
    "panel-fire": [576, 512, [], "e42f", "M32 96c0-35.3 28.7-64 64-64l320 0c35.3 0 64 28.7 64 64l0 76.2c-12 .3-23.8 3.9-34.1 11-7.9-7.9-15.9-15.6-24.2-23.1-1.8-1.6-3.7-3.2-5.7-4.5l0-27.6c0-17.7-14.3-32-32-32L128 96c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32l149.3 0c-11.1 14-21.1 28.2-29.8 42.3-6 9.7-11.8 20-16.9 30.6-2.1-.6-4.3-.9-6.6-.9-13.3 0-24 10.7-24 24 0 9.5 5.6 17.8 13.6 21.7-3.6 13.5-5.6 27-5.6 40.4 0 35 8.7 68.4 24.1 97.9L96 480c-35.3 0-64-28.7-64-64L32 96zM152 320a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm289.7-79.9L454 226.3c5.4-6.1 13.3-8.8 20.9-8.9 7.2 0 14.3 2.6 19.9 7.8 19.7 18.3 39.8 43.2 55 70.6 15.1 27.2 26.2 58.1 26.2 88.1 0 88.7-71.3 159.8-160 159.8-89.6 0-160-71.3-160-159.8 0-37.3 16-73.4 36.8-104.5 20.9-31.3 47.5-59 70.9-80.2 5.7-5.2 13.1-7.7 20.3-7.5s13.4 3.2 18.8 7.5c14.4 11.4 38.9 40.7 38.9 40.7zM480 432c0-36.5-37-73-54.8-88.4-5.4-4.7-13.1-4.7-18.5 0-17.7 15.4-54.8 51.9-54.8 88.4 0 35.3 28.7 64 64 64s64-28.7 64-64z"],
    "clock-seven-thirty": [512, 512, [], "e351", "M256 0a256 256 0 1 0 0 512 256 256 0 1 0 0-512zM232 392l0-56.7-20 30c-7.4 11-22.3 14-33.3 6.7s-14-22.3-6.7-33.3l64-96c5.9-8.8 16.8-12.7 26.9-9.7s17 12.4 17 23l0 136c0 13.3-10.7 24-24 24s-24-10.7-24-24z"],
    "tugrik-sign": [384, 512, [], "e2ba", "M32 32C14.3 32 0 46.3 0 64S14.3 96 32 96l128 0 0 111.3-101.8 25.5c-12.9 3.2-20.7 16.2-17.5 29.1S57 282.5 69.8 279.3l90.2-22.5 0 46.5-101.8 25.5c-12.9 3.2-20.7 16.2-17.5 29.1S57 378.5 69.8 375.3l90.2-22.5 0 95.3c0 17.7 14.3 32 32 32s32-14.3 32-32l0-111.3 101.8-25.5c12.9-3.2 20.7-16.2 17.5-29.1s-16.2-20.7-29.1-17.5l-90.2 22.5 0-46.5 101.8-25.5c12.9-3.2 20.7-16.2 17.5-29.1s-16.2-20.7-29.1-17.5L224 191.3 224 96 352 96c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 32z"],
    "audio-description-slash": [576, 512, [], "e0a8", "M7-24.9c9.4-9.4 24.6-9.4 33.9 0L129.8 64 480 64c35.3 0 64 28.7 64 64l0 256c0 25.5-14.9 47.4-36.4 57.8L569 503.1c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0L7 9.1C-2.3-.3-2.3-15.5 7-24.9zM352 208l24 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24l-6.2 0 39.7 39.7C432.4 331.7 448 307.6 448 280l0-48c0-39.8-32.2-72-72-72l-48 0c-13.3 0-24 10.7-24 24l0 54.2 48 48 0-78.2zM128 224l0 104c0 13.3 10.7 24 24 24s24-10.7 24-24l0-24 48 0 0 24c0 13.3 10.7 24 24 24 9.2 0 17.3-5.2 21.3-12.9L378.2 448 96 448c-35.3 0-64-28.7-64-64l0-256c0-7.8 1.4-15.3 4-22.2l96 96c-2.6 6.9-4 14.4-4 22.2z"],
    "face-thermometer": [512, 512, [], "e39a", "M511.7 268.8c.4-9 .4-16.6 .1-22.5l-9.6 9.2-18.9-18.9c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l18.5 18.5-25.8 24.9-18.1-18.1c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l17.6 17.6-25.8 24.9-17.2-17.2c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l24 24c.3 .3 .7 .6 1 .9 1.4 8.6-2 17.7-9.6 23.1-10.7 7.8-25.7 5.4-33.5-5.3-20.4-28-53.4-46.1-90.6-46.1s-70.2 18.1-90.6 46.1c-7.8 10.7-22.8 13.1-33.5 5.3s-13.1-22.8-5.3-33.5c29.1-39.9 76.2-65.9 129.4-65.9 22.1 0 43.2 4.5 62.3 12.6L457 182.4C468.2 171.5 483.9 168.1 498 172.2 463.2 72 368 0 256 0 114.6 0 0 114.6 0 256S114.6 512 256 512c134.2 0 244.4-103.3 255.1-234.8 .9-2.7 1.1-5.6 .5-8.4zM176 176a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm128 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"],
    "lightbulb-cfl-on": [640, 512, [], "e5a7", "M351 24.2c4.3 17.1-6.1 34.5-23.3 38.8l-128 32c-17.1 4.3-34.5-6.1-38.8-23.3s6.1-34.5 23.3-38.8l128-32c17.1-4.3 34.5 6.1 38.8 23.3zM455.8 127l-256 64c-17.1 4.3-34.5-6.1-38.8-23.3s6.1-34.5 23.3-38.8l256-64c17.1-4.3 34.5 6.1 38.8 23.3s-6.1 34.5-23.3 38.8zM479 184.2c4.3 17.1-6.1 34.5-23.3 38.8l-256 64c-17.1 4.3-34.5-6.1-38.8-23.3s6.1-34.5 23.3-38.8l256-64c17.1-4.3 34.5 6.1 38.8 23.3zM304 384l32 0 0-75.3c0-.5 0-.9 0-1.4l0-3.3 .2 0c1.6-12.7 10.8-23.7 24-27l80-20c17.1-4.3 34.5 6.1 38.8 23.3s-6.1 34.5-23.3 38.8l-71.8 17.9 0 47 8 0c13.3 0 24 10.7 24 24l0 24c0 44.2-35.8 80-80 80l-32 0c-44.2 0-80-35.8-80-80l0-24c0-13.3 10.7-24 24-24l8 0 0-78 48-12 0 90zM58.7 26.5l32 16c11.9 5.9 16.7 20.3 10.7 32.2S81.1 91.4 69.3 85.5l-32-16C25.4 63.5 20.6 49.1 26.5 37.3S46.9 20.6 58.7 26.5zm544 42.9l-32 16c-11.9 5.9-26.3 1.1-32.2-10.7s-1.1-26.3 10.7-32.2l32-16c11.9-5.9 26.3-1.1 32.2 10.7s1.1 26.3-10.7 32.2zM24 168l32 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-32 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zm560 0l32 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-32 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zM90.7 341.5l-32 16c-11.9 5.9-26.3 1.1-32.2-10.7s-1.1-26.3 10.7-32.2l32-16c11.9-5.9 26.3-1.1 32.2 10.7s1.1 26.3-10.7 32.2zm480-42.9l32 16c11.9 5.9 16.7 20.3 10.7 32.2s-20.3 16.7-32.2 10.7l-32-16c-11.9-5.9-16.7-20.3-10.7-32.2s20.3-16.7 32.2-10.7z"],
    "clock-three": [512, 512, [], "e356", "M256 0a256 256 0 1 1 0 512 256 256 0 1 1 0-512zM232 120l0 136c0 13.3 10.7 24 24 24l104 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0 0-112c0-13.3-10.7-24-24-24s-24 10.7-24 24z"],
    "person-walking-luggage": [512, 512, [], "e554", "M264.3 24a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm-8 181.3l-22.6 22.6c-6 6-9.4 14.1-9.4 22.6l0 37.5c0 12.3-7 23-17.2 28.4-.9 4.2-2.4 8.4-4.3 12.3l-69 138.1-.8-.4-27.7 55.3c-9.9 19.8-33.9 27.8-53.7 17.9L14.6 521c-19.8-9.9-27.8-33.9-17.9-53.7L47.3 366.3c9.9-19.8 33.9-27.8 53.7-17.9l30.7 15.3 28.3-56.6c.3-.6 .4-1.2 .4-1.8l0-16.9c0-.2 0-.3 0-.5l0-37.5c0-25.5 10.1-49.9 28.1-67.9l35.1-35.1c22.8-22.8 53.6-35.6 85.8-35.6 36.9 0 71.8 16.8 94.8 45.6L422.1 180c6.1 7.6 15.3 12 25 12l33.2 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-33.2 0c-29.2 0-56.7-13.3-75-36l-3.8-4.7 0 115.2 34.5 29.6c17.7 15.2 29.3 36.2 32.6 59.3L448 507.5c2.5 17.5-9.7 33.7-27.2 36.2s-33.7-9.7-36.2-27.2L372 428.4c-1.1-7.7-5-14.7-10.9-19.8l-71.4-61.2c-21.3-18.2-33.5-44.9-33.5-72.9l0-69.3zm.1 165.8c2.4 2.3 4.8 4.6 7.4 6.8l46 39.4-2.2 7.6c-4.5 15.7-12.9 30-24.4 41.5l-68.3 68.3c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L238 421.1c3.8-3.8 6.6-8.6 8.1-13.8L256.4 371z"],
    "file-arrow-down": [384, 512, ["file-download"], "f56d", "M0 64C0 28.7 28.7 0 64 0L213.5 0c17 0 33.3 6.7 45.3 18.7L365.3 125.3c12 12 18.7 28.3 18.7 45.3L384 448c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zm208-5.5l0 93.5c0 13.3 10.7 24 24 24L325.5 176 208 58.5zM175 441c9.4 9.4 24.6 9.4 33.9 0l64-64c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-23 23 0-86.1c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 86.1-23-23c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l64 64z"],
    "person-booth": [576, 512, [], "f756", "M40 24A56 56 0 1 1 152 24 56 56 0 1 1 40 24zm51.1 88c23.5 0 45.5 11.3 59.1 30.4l48.7 68.2c6 8.4 15.7 13.4 26 13.4l31.1 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-31.1 0c-31 0-60.1-15-78.1-40.2l-2.8-3.9 0 80.1 41.6 31.2C209.8 373.3 224 401.8 224 432l0 80c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-80c0-10.1-4.7-19.6-12.8-25.6L70.4 348.8C46.2 330.7 32 302.2 32 272l0-100.9C32 138.5 58.5 112 91.1 112zM32 512l0-132.7c3.1 2.7 6.3 5.4 9.6 7.9L96 428 96 512c0 17.7-14.3 32-32 32s-32-14.3-32-32zm544-88l0 96c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-72-168 0c-7.1 0-13.8-3.1-18.4-8.6s-6.5-12.6-5.3-19.6l30.7-176.7-63.1-137.6 0 72c-5.2-1-10.5-1.6-16-1.6l-32 0 0-120c0-30.9 25.1-56 56-56L520 0c30.9 0 56 25.1 56 56l0 368zM288 336c5.5 0 10.8-.6 16-1.6L304 520c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-184 32 0z"],
    "locust": [576, 512, [], "e520", "M328 32c137 0 248 111 248 248l0 40-.4 8.2C571.5 368.5 537.4 400 496 400l-12.3 0 25.2 44.1c6.6 11.5 2.6 26.2-8.9 32.8s-26.2 2.6-32.7-8.9l-38.8-67.9-80.4 0-48.2 69.7c-7.5 10.9-22.5 13.6-33.4 6.1s-13.6-22.5-6.1-33.4l29.3-42.3-74.5 0-51.7 70.2c-7.9 10.7-22.9 12.9-33.6 5.1s-12.9-22.9-5.1-33.6l40.5-55-43-16.4-79.3 100.5c-8.2 10.4-23.3 12.2-33.7 4s-12.2-23.3-4-33.7l240-304 2.1-2.3c5.2-5.1 12.5-7.5 19.9-6.6 8.4 1.1 15.6 6.5 18.9 14.3l21.7 50.7 40.9-55.5 2.1-2.4c5.1-5.3 12.5-8 20-7.2 8.5 1 15.9 6.5 19.3 14.4l41.8 97.5 64.2 0c10.2 0 20 2 29 5.5-16.4-94-98.3-165.5-197-165.5l-16 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l16 0zM488 296a24 24 0 1 0 0 48 24 24 0 1 0 0-48zM43.5 331.1C36.2 321.4 32 309.5 32 296.8 32 265.5 57.5 240 88.9 240l27.6 0-72.9 91.1zM225.1 240l48.2 0 1.4-1.9-16.9-39.5-32.7 41.5zm107.8 0l46.7 0-17.2-40-29.5 40z"],
    "window": [512, 512, [], "f40e", "M64 64C28.7 64 0 92.7 0 128L0 384c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L64 64zm32 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm64 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm128-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "right-long": [576, 512, ["long-arrow-alt-right"], "f30b", "M566.6 233.4c12.5 12.5 12.5 32.8 0 45.3l-128 128c-9.2 9.2-22.9 11.9-34.9 6.9S384 396.9 384 384l0-64-336 0c-26.5 0-48-21.5-48-48l0-32c0-26.5 21.5-48 48-48l336 0 0-64c0-12.9 7.8-24.6 19.8-29.6s25.7-2.2 34.9 6.9l128 128z"],
    "truck-droplet": [576, 512, [], "e58c", "M64 32C28.7 32 0 60.7 0 96L0 384c0 35.3 28.7 64 64 64l3.3 0c10.4 36.9 44.4 64 84.7 64s74.2-27.1 84.7-64l102.6 0c10.4 36.9 44.4 64 84.7 64s74.2-27.1 84.7-64l3.3 0c35.3 0 64-28.7 64-64l0-146.7c0-17-6.7-33.3-18.7-45.3L512 146.7c-12-12-28.3-18.7-45.3-18.7l-50.7 0 0-32c0-35.3-28.7-64-64-64L64 32zM512 237.3l0 50.7-96 0 0-96 50.7 0 45.3 45.3zM152 384a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm232 40a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zM208 304c-39.8 0-72-32.2-72-72 0-33.2 34.5-78 55.8-102.4 8.7-10 23.8-10 32.5 0 21.2 24.4 55.8 69.1 55.8 102.4 0 48-32.2 72-72 72z"],
    "hand-holding-medical": [576, 512, [], "e05c", "M240 24c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24l0 56 56 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24l-56 0 0 56c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-56-56 0c-13.3 0-24-10.7-24-24l0-48c0-13.3 10.7-24 24-24l56 0 0-56zM66.7 384l42.5-42.5c24-24 56.6-37.5 90.5-37.5L352 304c17.7 0 32 14.3 32 32s-14.3 32-32 32l-72 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l112.6 0 119.7-88.2c17.8-13.1 42.8-9.3 55.9 8.5s9.3 42.8-8.5 55.9L433.1 485.5c-23.4 17.2-51.6 26.5-80.7 26.5L32 512c-17.7 0-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32l34.7 0z"],
    "hand-point-left": [512, 512, [], "f0a5", "M32 96C14.3 96 0 110.3 0 128s14.3 32 32 32l208 0 0-64-208 0zM192 288c-17.7 0-32 14.3-32 32s14.3 32 32 32l64 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0zm-64-64c0 17.7 14.3 32 32 32l48 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-48 0c-17.7 0-32 14.3-32 32zm96 160c-17.7 0-32 14.3-32 32s14.3 32 32 32l64 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0zm88-96l-.6 0c5.4 9.4 8.6 20.3 8.6 32 0 13.2-4 25.4-10.8 35.6 24.9 8.7 42.8 32.5 42.8 60.4 0 11.7-3.1 22.6-8.6 32l8.6 0c88.4 0 160-71.6 160-160l0-61.7c0-42.4-16.9-83.1-46.9-113.1l-11.6-11.6C429.5 77.5 396.9 64 363 64l-27 0c-35.3 0-64 28.7-64 64l0 88c0 22.1 17.9 40 40 40s40-17.9 40-40l0-56c0-8.8 7.2-16 16-16s16 7.2 16 16l0 56c0 39.8-32.2 72-72 72z"],
    "calculator": [384, 512, [128425], "f1ec", "M64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-384c0-35.3-28.7-64-64-64L64 0zM96 64l192 0c17.7 0 32 14.3 32 32l0 32c0 17.7-14.3 32-32 32L96 160c-17.7 0-32-14.3-32-32l0-32c0-17.7 14.3-32 32-32zm16 168a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm80 24a24 24 0 1 1 0-48 24 24 0 1 1 0 48zm128-24a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zM88 352a24 24 0 1 1 0-48 24 24 0 1 1 0 48zm128-24a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm80 24a24 24 0 1 1 0-48 24 24 0 1 1 0 48zM64 424c0-13.3 10.7-24 24-24l112 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L88 448c-13.3 0-24-10.7-24-24zm232-24c13.3 0 24 10.7 24 24s-10.7 24-24 24-24-10.7-24-24 10.7-24 24-24z"],
    "oil-temperature": [640, 512, ["oil-temp"], "f614", "M578.9 375.2c5.8-10.6 20.5-10.6 26.3 0 14.2 26.2 34.9 67.8 34.9 88.8 0 32-21.5 48-48 48s-48-21.5-48-48c0-21 20.7-62.6 34.9-88.8zm35.5-154.4c18.1-4 30.8 17.5 18.6 31.4L451.1 458.4c-12.1 13.8-29.6 21.7-48 21.7L144 480c-26.5 0-48-21.5-48-48l0-21.3-67.5-30C12.3 373.5 1.4 357.9 .1 340.4L0 336.8 0 272c0-26.5 21.5-48 48-48l161.2 0c-10.9 18.8-17.2 40.7-17.2 64 0 70.7 57.3 128 128 128s128-57.3 128-128c0-10.1-1.2-20-3.5-29.5l169.9-37.8zM384 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32 0 0 32 32 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32 0 0 54.7c28.2 12.3 48 40.5 48 73.3 0 44.2-35.8 80-80 80s-80-35.8-80-80c0-32.8 19.8-61 48-73.3L288 32c0-17.7 14.3-32 32-32l64 0zM48 336.8l48 21.3 0-86.1-48 0 0 64.8z"],
    "minus": [448, 512, [8211, 8722, 10134, "subtract"], "f068", "M0 256c0-17.7 14.3-32 32-32l384 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 288c-17.7 0-32-14.3-32-32z"],
    "message-arrow-down": [512, 512, ["comment-alt-arrow-down"], "e1db", "M0 128L0 352c0 53 43 96 96 96l32 0 0 72c0 13.3 10.7 24 24 24 5.2 0 10.2-1.7 14.4-4.8l115.2-86.4c4.2-3.1 9.2-4.8 14.4-4.8l120 0c53 0 96-43 96-96l0-224c0-53-43-96-96-96L96 32C43 32 0 75 0 128zM167 265c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l31 31 0-102.1c0-13.3 10.7-24 24-24s24 10.7 24 24l0 102.1 31-31c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-72 72c-9.4 9.4-24.6 9.4-33.9 0l-72-72z"],
    "shoe": [640, 512, [], "e6d8", "M0 336L0 224c0-26.5 21.5-48 48-48l66.3 0c46 0 86.4-30.5 99-74.7l1.9-6.7c5.2-18.1 21.7-30.6 40.6-30.6 10.4 0 20.5 3.9 28.2 10.8L346.8 131.3 303 175c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l45.5-45.5 23.1 20.8c2.8 2.6 5.8 5 8.8 7.4L383 223c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l39.7-39.7c2.8 1.2 5.6 2.4 8.5 3.5l92.8 35.7c36.5 14.1 63.9 43.7 75.7 79.6L0 336zm0 48l640 0 0 16c0 26.5-21.5 48-48 48l-283.2 0c-13.8 0-27.4-2.2-40.5-6.6L192 416c0 17.7-14.3 32-32 32L32 448c-17.7 0-32-14.3-32-32l0-32z"],
    "game-board-simple": [448, 512, ["game-board-alt"], "f868", "M0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm224 0l0 160 160 0 0-160-160 0zm0 160l-160 0 0 160 160 0 0-160z"],
    "arrow-turn-left": [512, 512, [], "e632", "M448 416c0 17.7 14.3 32 32 32s32-14.3 32-32l0-96c0-53-43-96-96-96l-306.7 0 73.4-73.4c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-128 128c-12.5 12.5-12.5 32.8 0 45.3l128 128c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L109.3 288 416 288c17.7 0 32 14.3 32 32l0 96z"],
    "circle-4": [512, 512, [], "e0f1", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM200 144c13.3 0 24 10.7 24 24l0 88 48 0 0-88c0-13.3 10.7-24 24-24s24 10.7 24 24l0 88 8 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-8 0 0 40c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-40-56 0c-22.1 0-40-17.9-40-40l0-96c0-13.3 10.7-24 24-24z"],
    "hammer-war": [448, 512, [], "f6e4", "M224 0c17.7 0 32 14.3 32 32l0 27.4 155.5-22.2C430.8 34.5 448 49.4 448 68.9l0 182.2c0 19.5-17.2 34.4-36.5 31.7l-183-26.1c-3-.4-6-.4-9.1 0L36.5 282.8C17.2 285.5 0 270.6 0 251.1L0 68.9C0 49.4 17.2 34.5 36.5 37.2L192 59.4 192 32c0-17.7 14.3-32 32-32zm0 304.5l32 4.6 0 202.9c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-202.9 32-4.6z"],
    "light-emergency": [448, 512, [], "e41f", "M64 192c0-88.4 71.6-160 160-160s160 71.6 160 160l0 112-320 0 0-112zm168-64c13.3 0 24-10.7 24-24s-10.7-24-24-24c-66.3 0-120 53.7-120 120 0 13.3 10.7 24 24 24s24-10.7 24-24c0-39.8 32.2-72 72-72zM32 352l384 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32L32 480c-17.7 0-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32z"],
    "arrow-up-z-a": [512, 512, ["sort-alpha-up-alt"], "f882", "M150.6 41.4c-12.5-12.5-32.8-12.5-45.3 0l-80 80c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L96 141.3 96 448c0 17.7 14.3 32 32 32s32-14.3 32-32l0-306.7 25.4 25.4c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-80-80zM288 64c0 17.7 14.3 32 32 32l50.7 0-73.4 73.4c-9.2 9.2-11.9 22.9-6.9 34.9S307.1 224 320 224l128 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-50.7 0 73.4-73.4c9.2-9.2 11.9-22.9 6.9-34.9S461 32 448 32L320 32c-17.7 0-32 14.3-32 32zM412.6 273.7C407.2 262.8 396.1 256 384 256s-23.2 6.8-28.6 17.7l-80 160c-7.9 15.8-1.5 35 14.3 42.9s35 1.5 42.9-14.3l7.2-14.3 88.4 0 7.2 14.3c7.9 15.8 27.1 22.2 42.9 14.3s22.2-27.1 14.3-42.9l-80-160zM384 359.6l20.2 40.4-40.4 0 20.2-40.4z"],
    "microphone-slash": [576, 512, [], "f131", "M41-24.9c-9.4-9.4-24.6-9.4-33.9 0S-2.3-.3 7 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9L424.7 358.8C458.9 324.2 480 276.6 480 224l0-40c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 40c0 39.3-15.7 74.9-41.3 100.9L356.8 291C373.6 273.7 384 250 384 224l0-128c0-53-43-96-96-96s-96 43-96 96l0 30.2-151-151zm298.3 434l-41.4-41.4c-3.3 .2-6.5 .3-9.8 .3-79.5 0-144-64.5-144-144l0-10.2-43.6-43.6c-2.8 3.9-4.4 8.7-4.4 13.8l0 40c0 97.9 73.3 178.7 168 190.5l0 49.5-48 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l144 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0 0-49.5c9.3-1.2 18.4-3 27.3-5.4z"],
    "square-pen": [448, 512, ["pen-square", "pencil-square"], "f14b", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM325.8 139.7l14.4 14.4c15.6 15.6 15.6 40.9 0 56.6l-23.8 23.8-71-71 23.8-23.8c15.6-15.6 40.9-15.6 56.6 0zM119.9 289l91.5-91.6 71 71-91.6 91.5c-4.1 4.1-9.2 7-14.9 8.4l-60.1 15c-5.5 1.4-11.2-.2-15.2-4.2s-5.6-9.7-4.2-15.2l15-60.1c1.4-5.6 4.3-10.8 8.4-14.9z"],
    "bell-plus": [448, 512, [], "f849", "M224 0c-17.7 0-32 14.3-32 32l0 3.2C119 50 64 114.6 64 192l0 21.7c0 48.1-16.4 94.8-46.4 132.4L7.8 358.3C2.7 364.6 0 372.4 0 380.5 0 400.1 15.9 416 35.5 416l376.9 0c19.6 0 35.5-15.9 35.5-35.5 0-8.1-2.7-15.9-7.8-22.2l-9.8-12.2C400.4 308.5 384 261.8 384 213.7l0-21.7c0-77.4-55-142-128-156.8l0-3.2c0-17.7-14.3-32-32-32zM162 464c7.1 27.6 32.2 48 62 48s54.9-20.4 62-48l-124 0zm62-336c13.3 0 24 10.7 24 24l0 48 48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0 0 48c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-48-48 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l48 0 0-48c0-13.3 10.7-24 24-24z"],
    "hand-fist": [384, 512, [9994, "fist-raised"], "f6de", "M160 0c17.7 0 32 14.3 32 32l0 112-64 0 0-112c0-17.7 14.3-32 32-32zM32 64c0-17.7 14.3-32 32-32S96 46.3 96 64l0 80-64 0 0-80zm192 0c0-17.7 14.3-32 32-32s32 14.3 32 32l0 96c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-96zm96 64c0-17.7 14.3-32 32-32s32 14.3 32 32l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64zm-96 88l0-.6c9.4 5.4 20.3 8.6 32 8.6 13.2 0 25.4-4 35.6-10.8 8.7 24.9 32.5 42.8 60.4 42.8 11.7 0 22.6-3.1 32-8.6l0 8.6c0 52.3-25.1 98.8-64 128l0 96c0 17.7-14.3 32-32 32l-160 0c-17.7 0-32-14.3-32-32l0-78.4c-17.3-7.9-33.2-18.8-46.9-32.5L37.5 357.5C13.5 333.5 0 300.9 0 267l0-27c0-35.3 28.7-64 64-64l88 0c22.1 0 40 17.9 40 40s-17.9 40-40 40l-56 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l56 0c39.8 0 72-32.2 72-72z"],
    "pants": [512, 512, [], "e6d5", "M90.9 32.4C94.5 13.6 111 0 130.2 0L382.7 0c19.2 0 35.7 13.6 39.3 32.4l8.7 45.4 .4 2.1-54.7 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l63.9 0 62.8 326.6c4.2 21.7-10 42.7-31.7 46.8l-110 21.2c-21.7 4.2-42.7-10-46.8-31.7L257.3 192.7c-.1-.4-.4-.7-.8-.7s-.8 .3-.8 .7L198.3 490.8c-4.2 21.7-25.1 35.9-46.8 31.7l-110-21.2c-21.7-4.2-35.9-25.1-31.7-46.8l62.8-326.6 63.9 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-54.7 0 .4-2.1 8.7-45.4z"],
    "comment-sms": [512, 512, ["sms"], "f7cd", "M256 480c141.4 0 256-107.5 256-240S397.4 0 256 0 0 107.5 0 240c0 54.3 19.2 104.3 51.6 144.5L2.8 476.8c-4.8 9-3.3 20 3.6 27.5s17.8 9.8 27.1 5.8l118.4-50.7C183.7 472.6 218.9 480 256 480zM140.8 172.8l19.2 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-19.2 0c-5.3 0-9.6 4.3-9.6 9.6s4.3 9.6 9.6 9.6c23 0 41.6 18.6 41.6 41.6s-18.6 41.6-41.6 41.6l-25.6 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l25.6 0c5.3 0 9.6-4.3 9.6-9.6s-4.3-9.6-9.6-9.6c-23 0-41.6-18.6-41.6-41.6s18.6-41.6 41.6-41.6zm188.8 41.6c0-23 18.6-41.6 41.6-41.6l19.2 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-19.2 0c-5.3 0-9.6 4.3-9.6 9.6s4.3 9.6 9.6 9.6c23 0 41.6 18.6 41.6 41.6s-18.6 41.6-41.6 41.6l-25.6 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l25.6 0c5.3 0 9.6-4.3 9.6-9.6s-4.3-9.6-9.6-9.6c-23 0-41.6-18.6-41.6-41.6zm-98.3-33.8l24.7 41.1 24.7-41.1c3.7-6.2 11.1-9.1 18-7.2s11.7 8.2 11.7 15.4l0 102.4c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-44.6-8.7 14.5c-2.9 4.8-8.1 7.8-13.7 7.8s-10.8-3-13.7-7.8l-8.7-14.5 0 44.6c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-102.4c0-7.2 4.8-13.5 11.7-15.4s14.3 1 18 7.2z"],
    "head-side-gear": [512, 512, [], "e611", "M329.7 448c-5.1 0-9.7 3.7-9.7 8.8l0 7.2c0 26.5-21.5 48-48 48l-160 0c-26.5 0-48-21.5-48-48l0-63.6c0-12.6-5.1-24.5-13.1-34.2-31.8-38.7-50.9-88.2-50.9-142.2 0-123.7 100.3-224 224-224 112.7 0 206 83.3 221.7 191.7 .4 3 1.7 5.9 3.6 8.3l35.8 42.9c7 8.4 10.9 19.1 10.9 30.1 0 25.9-21 47-47 47l-1 0c-8.8 0-16 7.2-16 16l0 48c0 35.3-28.7 64-64 64l-38.3 0zm7-284.1c6.3-3.6 9.5-11.1 6.8-18-2.1-5.5-4.6-10.8-7.4-15.9l-2.3-4c-3.1-5.1-6.5-9.9-10.2-14.5-4.6-5.7-12.7-6.7-19-3l-2.9 1.7c-9.2 5.3-20.4 4-29.6-1.3S256 94.4 256 83.8l0-3.4c0-7.3-4.9-13.8-12.1-14.9-6.5-1-13.1-1.5-19.9-1.5s-13.4 .5-19.9 1.5c-7.2 1.1-12.1 7.6-12.1 14.9l0 3.4c0 10.6-6.9 19.8-16.1 25.1s-20.4 6.6-29.6 1.3l-2.9-1.7c-6.3-3.6-14.4-2.6-19 3-3.7 4.6-7.1 9.5-10.2 14.6l-2.3 3.9c-2.8 5.1-5.3 10.4-7.4 15.9-2.6 6.8 .5 14.3 6.8 18l2.9 1.7c9.2 5.3 13.7 15.8 13.7 26.4s-4.5 21.1-13.7 26.4l-3 1.7c-6.3 3.6-9.5 11.1-6.8 18 2.1 5.5 4.6 10.7 7.4 15.8l2.4 4.1c3.1 5.1 6.4 9.9 10.1 14.5 4.6 5.7 12.7 6.7 19 3l2.9-1.7c9.2-5.3 20.4-4 29.6 1.3S192 289.6 192 300.2l0 3.4c0 7.3 4.9 13.8 12.1 14.9 6.5 1 13.1 1.5 19.9 1.5s13.4-.5 19.9-1.5c7.2-1.1 12.1-7.6 12.1-14.9l0-3.4c0-10.6 6.9-19.8 16.1-25.1s20.4-6.6 29.6-1.3l2.9 1.7c6.3 3.6 14.4 2.6 19-3 3.7-4.6 7.1-9.4 10.1-14.5l2.4-4.2c2.8-5.1 5.3-10.3 7.4-15.8 2.6-6.8-.5-14.3-6.8-18l-3-1.7c-9.2-5.3-13.7-15.8-13.7-26.4s4.5-21.1 13.7-26.4l3-1.7zM184 192a40 40 0 1 1 80 0 40 40 0 1 1 -80 0z"],
    "transporter-1": [576, 512, [], "e043", "M288-32a56 56 0 1 1 0 112 56 56 0 1 1 0-112zM414.3 299.1l-46.3-62.4 0 67.3-160 0 0-67.3-46.3 62.4c-10.5 14.2-30.6 17.2-44.8 6.6s-17.2-30.6-6.6-44.8l70.5-95C206 132 245.7 112 288 112s82 20 107.2 53.9l70.5 95c10.5 14.2 7.6 34.2-6.6 44.8s-34.2 7.6-44.8-6.6zM152 544c-13.3 0-24-10.7-24-24s10.7-24 24-24l272 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-272 0zM536.7 134.6l7.3 25.4 25.4 7.3c3.9 1.1 6.6 4.7 6.6 8.7s-2.7 7.6-6.6 8.7l-25.4 7.3-7.3 25.4c-1.1 3.9-4.7 6.6-8.7 6.6s-7.6-2.7-8.7-6.6l-7.3-25.4-25.4-7.3c-3.9-1.1-6.6-4.7-6.6-8.7s2.7-7.6 6.6-8.7l25.4-7.3 7.3-25.4c1.1-3.9 4.7-6.6 8.7-6.6s7.6 2.7 8.7 6.6zm-480 192L64 352 89.4 359.3c3.9 1.1 6.6 4.7 6.6 8.7s-2.7 7.6-6.6 8.7L64 384 56.7 409.4c-1.1 3.9-4.7 6.6-8.7 6.6s-7.6-2.7-8.7-6.6L32 384 6.6 376.7C2.7 375.6 0 372.1 0 368s2.7-7.6 6.6-8.7L32 352 39.3 326.6c1.1-3.9 4.7-6.6 8.7-6.6s7.6 2.7 8.7 6.6zM192 368c0-8.8 7.2-16 16-16l160 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-160 0c-8.8 0-16-7.2-16-16zm0 64c0-8.8 7.2-16 16-16l160 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-160 0c-8.8 0-16-7.2-16-16z"],
    "scanner-touchscreen": [512, 512, [], "f48a", "M224-32c17.7 0 32 14.3 32 32l0 48-64 0 0-48c0-17.7 14.3-32 32-32zM392 224c-13.3 0-24-10.7-24-24L368-8c0-13.3 10.7-24 24-24s24 10.7 24 24l0 208c0 13.3-10.7 24-24 24zM320-16l0 84.1c-9.7-6.7-20.4-12-32-15.4L288-16c0-8.8 7.2-16 16-16s16 7.2 16 16zM448 0c0-17.7 14.3-32 32-32s32 14.3 32 32l0 192c0 17.7-14.3 32-32 32s-32-14.3-32-32L448 0zM64 160l0 288 192 0 0-288-192 0zM0 160c0-35.3 28.7-64 64-64l192 0c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 160z"],
    "flask-round-potion": [384, 512, ["flask-potion"], "f6e1", "M96 0C78.3 0 64 14.3 64 32S78.3 64 96 64l0 89.7C38.7 186.9 0 248.9 0 320 0 426 86 512 192 512s192-86 192-192c0-71.1-38.7-133.1-96-166.3L288 64c17.7 0 32-14.3 32-32S305.7 0 288 0L96 0zm64 173.3l0-109.3 64 0 0 109.3c0 12.7 7.5 24.2 19.2 29.3 45.3 19.8 76.8 64.9 76.8 117.4 0 5.4-.3 10.8-1 16l-18.7 0c-29 0-57.5-7.9-82.3-22.8l-9.6-5.8c-21.2-12.7-45.4-19.4-70.1-19.4-17.3 0-34.5 3.3-50.6 9.7l-23 9.2c4.7-46.8 34.7-86.2 76.2-104.3 11.7-5.1 19.2-16.6 19.2-29.3z"],
    "car-bolt": [512, 512, [], "e341", "M39.6 196.8L74.8 96.3C88.3 57.8 124.6 32 165.4 32l181.2 0c40.8 0 77.1 25.8 90.6 64.3l35.2 100.5c23.2 9.6 39.6 32.5 39.6 59.2l0 192c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-32-320 0 0 32c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32L0 256c0-26.7 16.4-49.6 39.6-59.2zM128 304a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm288 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM184.5 224l45.5 0-24.4 78c-2.8 8.9 3.9 18 13.2 18 3.3 0 6.6-1.2 9.1-3.4l110.4-95.7c3.6-3.1 5.7-7.7 5.7-12.5 0-9.1-7.4-16.5-16.5-16.5l-45.5 0 24.4-78c2.8-8.9-3.9-18-13.2-18-3.3 0-6.6 1.2-9.1 3.4L173.7 195.1c-3.6 3.1-5.7 7.7-5.7 12.5 0 9.1 7.4 16.5 16.5 16.5z"],
    "table-rows": [448, 512, ["rows"], "e292", "M0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm128 0l0 128 256 0 0-128-256 0zM384 288l-256 0 0 128 256 0 0-128z"],
    "cloud-slash": [576, 512, [], "e137", "M41-25C31.6-34.3 16.4-34.3 7-25S-2.3-.4 7 9L535 537c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-46.7-46.7c32.5-23.2 53.8-61.3 53.8-104.3 0-51.6-30.5-96.1-74.5-116.3 6.7-13.1 10.5-28 10.5-43.7 0-53-43-96-96-96-17.7 0-34.2 4.8-48.4 13.1-24.1-45.8-72.2-77.1-127.6-77.1-39.3 0-74.9 15.7-100.8 41.2L41-25zM96 176c0 8 .7 15.9 1.9 23.5-56.9 19.2-97.9 73.1-97.9 136.5 0 79.5 64.5 144 144 144l266.2 0-313.8-313.8c-.2 3.3-.3 6.5-.3 9.8z"],
    "face-hand-yawn": [512, 512, [], "e379", "M429.6 444.1C480.3 397.4 512 330.4 512 256 512 114.6 397.4 0 256 0S0 114.6 0 256c0 73.2 30.7 139.2 80 185.9L80 376c0-39.8 32.2-72 72-72 3.1 0 6.2 .2 9.2 .6 7.4-45.7 47-80.6 94.8-80.6 48.2 0 88 35.5 94.9 81.7 15.7 1.5 31 8.3 43 20.3 21.3 21.3 26.1 52.7 14.6 78.6 .5 .4 .9 .9 1.4 1.4 10.8 10.8 17.3 24.1 19.7 38.1zM210.7 113c8.3 10.4 6.6 25.5-3.7 33.7l-80 64c-10.4 8.3-25.5 6.6-33.7-3.7s-6.6-25.5 3.7-33.7l80-64c10.4-8.3 25.5-6.6 33.7 3.7zM305 146.7c-10.4-8.3-12-23.4-3.8-33.7s23.4-12 33.7-3.7l80 64c10.4 8.3 12 23.4 3.8 33.7s-23.4 12-33.7 3.7l-80-64zM128 376l0 98.2c0 56.2 45.6 101.8 101.8 101.8 27 0 52.9-10.7 72-29.8L376 472c8.8-8.8 8.8-23.2 0-32s-23.2-8.8-32 0l-32 32c-4.4 4.4-11.6 4.4-16 0s-4.4-11.6 0-16l64-64c8.8-8.8 8.8-23.2 0-32s-23.2-8.8-32 0l-64 64c-4.4 4.4-11.6 4.4-16 0s-4.4-11.6 0-16l48-48c8.8-8.8 8.8-23.2 0-32s-23.2-8.8-32 0l-81.2 81.2c-2.5 2.5-6.8 .7-6.8-2.8l0-30.3c0-13.3-10.7-24-24-24s-24 10.7-24 24z"],
    "tickets": [640, 512, [], "e658", "M96 96c0-35.3 28.7-64 64-64l384 0c35.3 0 64 28.7 64 64l0 48c0 8.8-7.4 15.7-15.7 18.6-18.8 6.5-32.3 24.4-32.3 45.4s13.5 38.9 32.3 45.4c8.3 2.9 15.7 9.8 15.7 18.6l0 48c0 35.3-28.7 64-64 64l-384 0c-35.3 0-64-28.7-64-64l0-48c0-8.8 7.4-15.7 15.7-18.6 18.8-6.5 32.3-24.4 32.3-45.4s-13.5-38.9-32.3-45.4C103.4 159.7 96 152.8 96 144l0-48zM448 272l-192 0c-8.8 0-16-7.2-16-16l0-96c0-8.8 7.2-16 16-16l192 0c8.8 0 16 7.2 16 16l0 96c0 8.8-7.2 16-16 16zM232 96c-22.1 0-40 17.9-40 40l0 144c0 22.1 17.9 40 40 40l240 0c22.1 0 40-17.9 40-40l0-144c0-22.1-17.9-40-40-40L232 96zM48 152l0 264c0 8.8 7.2 16 16 16l424 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L64 480c-35.3 0-64-28.7-64-64L0 152c0-13.3 10.7-24 24-24s24 10.7 24 24z"],
    "sim-card": [384, 512, [], "f7c4", "M0 64C0 28.7 28.7 0 64 0L258.7 0c17 0 33.3 6.7 45.3 18.7L365.3 80c12 12 18.7 28.3 18.7 45.3L384 448c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zM96 256c-17.7 0-32 14.3-32 32l0 40 128 0 0-72-96 0zM64 416c0 17.7 14.3 32 32 32l48 0 0-72-80 0 0 40zm256 0l0-40-128 0 0 72 96 0c17.7 0 32-14.3 32-32zm0-128c0-17.7-14.3-32-32-32l-48 0 0 72 80 0 0-40z"],
    "shield-quartered": [512, 512, [], "e575", "M269.4 2.9C265.2 1 260.7 0 256 0s-9.2 1-13.4 2.9L54.3 82.8c-22 9.3-38.4 31-38.3 57.2 .5 99.2 41.3 280.7 213.6 363.2 16.7 8 36.1 8 52.8 0 172.4-82.5 213.2-264 213.6-363.2 .1-26.2-16.3-47.9-38.3-57.2L269.4 2.9zM80 141.4l176-74.6 0 157.2-165.9 0c-6.9-30-9.8-58.5-10.1-82.6zM256 444.8l0-220.8 166 0c-18.5 80.5-65.5 172.2-166 220.8z"],
    "square-ellipsis-vertical": [448, 512, [], "e26f", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM224 224a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm-32-64a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm32 160a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "oven": [448, 512, [], "e01d", "M0 96C0 43 43 0 96 0L352 0c53 0 96 43 96 96l0 352c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 96zm104 16a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm72 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm120-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm72 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm16 88l-320 0 0 224 320 0 0-224zM136 272l176 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-176 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"],
    "scale-balanced": [640, 512, [9878, "balance-scale"], "f24e", "M384 32l128 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L398.4 96c-5.2 25.8-22.9 47.1-46.4 57.3l0 294.7 160 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-384 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l160 0 0-294.7c-23.5-10.3-41.2-31.6-46.4-57.3L128 96c-17.7 0-32-14.3-32-32s14.3-32 32-32l128 0c14.6-19.4 37.8-32 64-32s49.4 12.6 64 32zm55.6 288L584.4 320 512 195.8 439.6 320zM512 416c-62.9 0-115.2-34-126-78.9-2.6-11 1-22.3 6.7-32.1l95.2-163.2c5-8.6 14.2-13.8 24.1-13.8s19.1 5.3 24.1 13.8l95.2 163.2c5.7 9.8 9.3 21.1 6.7 32.1-10.8 44.8-63.1 78.9-126 78.9zM126.8 195.8L54.4 320 199.3 320 126.8 195.8zM.9 337.1c-2.6-11 1-22.3 6.7-32.1l95.2-163.2c5-8.6 14.2-13.8 24.1-13.8s19.1 5.3 24.1 13.8l95.2 163.2c5.7 9.8 9.3 21.1 6.7 32.1-10.8 44.8-63.1 78.9-126 78.9S11.7 382 .9 337.1z"],
    "car": [512, 512, [128664, "automobile"], "f1b9", "M135.2 117.4l-26.1 74.6 293.8 0-26.1-74.6C372.3 104.6 360.2 96 346.6 96L165.4 96c-13.6 0-25.7 8.6-30.2 21.4zM39.6 196.8L74.8 96.3C88.3 57.8 124.6 32 165.4 32l181.2 0c40.8 0 77.1 25.8 90.6 64.3l35.2 100.5c23.2 9.6 39.6 32.5 39.6 59.2l0 192c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-32-320 0 0 32c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32L0 256c0-26.7 16.4-49.6 39.6-59.2zM128 304a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm288 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "circle-baht": [512, 512, [], "e72d", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM240 112c0-8.8 7.2-16 16-16s16 7.2 16 16l0 16 4 0c42 0 76 34 76 76 0 16.2-5.1 31.3-13.8 43.7 18.1 13.9 29.8 35.8 29.8 60.3 0 42-34 76-76 76l-20 0 0 16c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-16-43.4 0c-15.8 0-28.6-12.8-28.6-28.6l0-201.1c0-14.5 11.8-26.3 26.3-26.3l45.7 0 0-16zm-24 64l0 56 24 0 0-56-24 0zm56 0l0 56 4 0c15.5 0 28-12.5 28-28s-12.5-28-28-28l-4 0zM216 280l0 56 24 0 0-56-24 0zm56 0l0 56 20 0c15.5 0 28-12.5 28-28s-12.5-28-28-28l-20 0z"],
    "badger-honey": [640, 512, [129441], "f6b4", "M164.6 389.3l16-37.3 118.1 0 16.9 101.3c2.6 15.4 15.9 26.7 31.6 26.7l31.1 0c19.8 0 34.8-17.8 31.6-37.3L393 342.1c27.9-29 80.6-70.8 144.1-90.8l16.1 25.8c3.1 5 10.4 5 13.6 0l22.8-36.5c12.9-2.1 25.2-7.4 34.4-16.6 10.2-10.2 16-24.1 16-38.6l0-3.8c0-23.2-12.6-44.5-32.8-55.8L525.3 80.3c-19.2-10.7-40.8-16.3-62.8-16.3-20.1 0-39.9 4.7-57.8 13.6L400 80c-21 10.5-44.2 16-67.8 16L128 96C57.3 96 0 153.3 0 224l0 32c0 17.7 14.3 32 32 32 5.4 0 10.6-1.4 15-3.7 9.1 17.1 22.1 31.9 37.7 43.3l-16.8 59c-2.5 8.8-2.5 18.2 .2 27l13.1 43.7c4.1 13.5 16.5 22.8 30.7 22.8l29.2 0c21.4 0 36.8-20.7 30.7-41.2l-8.3-27.7c-2.2-7.2-1.7-14.9 1.2-21.8zM570 160l-51.3 0c.9 2.5 1.4 5.2 1.4 8 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-2.8 .5-5.5 1.4-8l-5.9 0c-23.2 0-46 6.3-65.9 18.2L294.8 242.3c-14.9 9-32 13.7-49.4 13.7L192 256C145.6 256 105.8 227.8 88.8 187.5 102 161.7 129 144 160 144l172.2 0c31 0 61.5-7.2 89.2-21.1l4.7-2.4c11.3-5.6 23.7-8.6 36.3-8.6 13.8 0 27.4 3.5 39.5 10.2L570 160z"],
    "crop-simple": [512, 512, ["crop-alt"], "f565", "M128 32c0-17.7-14.3-32-32-32S64 14.3 64 32l0 32-32 0C14.3 64 0 78.3 0 96s14.3 32 32 32l32 0 0 256c0 35.3 28.7 64 64 64l208 0 0-64-208 0 0-352zM384 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-32 32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0 0-256c0-35.3-28.7-64-64-64l-208 0 0 64 208 0 0 352z"],
    "timer": [512, 512, [], "e29e", "M256 0c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32s32-14.3 32-32l0-29.3c90.8 15.2 160 94.2 160 189.3 0 106-86 192-192 192S64 362 64 256c0-53.7 22-102.3 57.6-137.1 12.6-12.4 12.8-32.6 .5-45.3s-32.6-12.8-45.3-.5C29.5 119.6 0 184.4 0 256 0 397.4 114.6 512 256 512S512 397.4 512 256 397.4 0 256 0zM193 159c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l80 80c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-80-80z"],
    "square-dollar": [448, 512, ["dollar-square", "usd-square"], "f2e9", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm160 72c13.3 0 24 10.7 24 24l0 16 16 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-61.6 0c-10.2 0-18.4 8.2-18.4 18.4 0 9.2 6.8 17 16 18.2l54.4 7.2c33 4.4 57.7 32.5 57.7 65.8 0 35.9-28.4 65.1-64 66.3l0 16c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-16-32 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l77.6 0c10.2 0 18.4-8.2 18.4-18.4 0-9.2-6.8-17-16-18.2l-54.4-7.2c-33-4.4-57.7-32.5-57.7-65.8 0-35.9 28.4-65.1 64-66.3l0-16c0-13.3 10.7-24 24-24z"],
    "medal": [448, 512, [127941], "f5a2", "M224.3 128L139.7-12.9c-6.5-10.8-20.1-14.7-31.3-9.1L21.8 21.3C9.9 27.2 5.1 41.6 11 53.5L80.6 192.6c-30.1 33.9-48.3 78.5-48.3 127.4 0 106 86 192 192 192s192-86 192-192c0-48.9-18.3-93.5-48.3-127.4L437.6 53.5c5.9-11.9 1.1-26.3-10.7-32.2L340.2-22.1c-11.2-5.6-24.9-1.6-31.3 9.1L224.3 128zm30.8 142.5c1.4 2.8 4 4.7 7 5.1l50.1 7.3c7.7 1.1 10.7 10.5 5.2 16l-36.3 35.4c-2.2 2.2-3.2 5.2-2.7 8.3l8.6 49.9c1.3 7.6-6.7 13.5-13.6 9.9l-44.8-23.6c-2.7-1.4-6-1.4-8.7 0l-44.8 23.6c-6.9 3.6-14.9-2.2-13.6-9.9l8.6-49.9c.5-3-.5-6.1-2.7-8.3l-36.3-35.4c-5.6-5.4-2.5-14.8 5.2-16l50.1-7.3c3-.4 5.7-2.4 7-5.1l22.4-45.4c3.4-7 13.3-7 16.8 0l22.4 45.4z"],
    "scroll": [576, 512, [128220], "f70e", "M0 112C0 70.5 31.6 36.4 72 32.4l0-.4 280 0c53 0 96 43 96 96l0 176-176 0c-39.8 0-72 32.2-72 72l0 60c0 24.3-19.7 44-44 44s-44-19.7-44-44l0-228-64 0c-26.5 0-48-21.5-48-48l0-48zM236.8 480c7.1-13.1 11.2-28.1 11.2-44l0-60c0-13.3 10.7-24 24-24l248 0c13.3 0 24 10.7 24 24l0 24c0 44.2-35.8 80-80 80l-227.2 0zM80 80c-17.7 0-32 14.3-32 32l0 48 64 0 0-48c0-17.7-14.3-32-32-32z"],
    "calendars": [512, 512, [], "e0d7", "M224 0c-17.7 0-32 14.3-32 32l0 32-48 0c-26.5 0-48 21.5-48 48l0 48 416 0 0-48c0-26.5-21.5-48-48-48l-48 0 0-32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 32-96 0 0-32c0-17.7-14.3-32-32-32zM96 208l0 160c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-160-416 0zM48 184c0-13.3-10.7-24-24-24S0 170.7 0 184L0 448c0 35.3 28.7 64 64 64l328 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L64 464c-8.8 0-16-7.2-16-16l0-264z"],
    "apple-core": [384, 512, [], "e08f", "M192.1 112c-8.8 0-16-7.2-16-16l0-16c0-44.2 35.8-80 80-80l16 0c8.8 0 16 7.2 16 16l0 16c0 44.2-35.8 80-80 80l-16 0zM30.6 167c-8-6.5-9.3-18.7-.7-24.3 14.2-9.3 30.9-14.7 50.3-14.7 27.3 0 59.7 10.3 82.7 19.3 18.8 7.3 39.9 7.3 58.7 0 22.9-8.9 55.4-19.3 82.7-19.3 19.3 0 36.1 5.4 50.3 14.7 8.6 5.6 7.3 17.9-.7 24.3-40 32.3-65.5 81.7-65.5 137 0 54.4 24.7 103 63.4 135.3 7 5.9 8.8 16.3 2.7 23.1-28.3 31.3-63.2 49.6-98.1 49.6-16.5 0-38.1-6.6-51.5-11.3-8.1-2.8-16.9-2.8-25 0-13.4 4.7-35 11.3-51.5 11.3-34.9 0-69.8-18.3-98.1-49.6-6.2-6.8-4.4-17.3 2.7-23.1 38.8-32.3 63.4-80.9 63.4-135.3 0-55.4-25.6-104.7-65.5-137z"],
    "file-excel": [384, 512, [], "f1c3", "M0 64C0 28.7 28.7 0 64 0L213.5 0c17 0 33.3 6.7 45.3 18.7L365.3 125.3c12 12 18.7 28.3 18.7 45.3L384 448c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zm208-5.5l0 93.5c0 13.3 10.7 24 24 24L325.5 176 208 58.5zM164 266.7c-7.4-11-22.3-14-33.3-6.7s-14 22.3-6.7 33.3L163.2 352 124 410.7c-7.4 11-4.4 25.9 6.7 33.3s25.9 4.4 33.3-6.7l28-42 28 42c7.4 11 22.3 14 33.3 6.7s14-22.3 6.7-33.3L220.8 352 260 293.3c7.4-11 4.4-25.9-6.7-33.3s-25.9-4.4-33.3 6.7l-28 42-28-42z"],
    "diamond-half": [512, 512, [], "e5b7", "M256 33.9c0-9.7-5.8-18.5-14.8-22.2S221.9 10.1 215 17L17 215C6.1 225.9 0 240.6 0 256s6.1 30.1 17 41L215 495c6.9 6.9 17.2 8.9 26.2 5.2S256 487.8 256 478.1l0-444.1z"],
    "baguette": [640, 512, [129366], "e3d8", "M322.5 100.5L248.1 150.1 305 207c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-63.7-63.7-74.5 49.6 60.1 60.1c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0L92.1 254.1 57 277.5C-1.8 316.7-17.7 396.2 21.5 455S140.2 529.7 199 490.5l384-256c58.8-39.2 74.7-118.7 35.5-177.5S499.8-17.7 441 21.5L363.3 73.3 417 127c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-60.5-60.5z"],
    "ear-triangle-exclamation": [576, 512, [], "e75c", "M176 506.3c0 1.6 0 3.2 .1 4.7-63.2-7.8-112.1-61.7-112.1-127l0-192C64 86 150 0 256 0S448 86 448 192c0 4.6-.2 9.1-.5 13.5-14-8.7-30.4-13.5-47.5-13.5-31.8 0-61.3 16.8-77.5 44.1L188 462.7c-7.8 13.2-12 28.3-12 43.6zM375.6 146.2C357.1 98.1 310.5 64 256 64 185.3 64 128 121.3 128 192l0 40c0 13.3 10.7 24 24 24l16 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-16 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l16 0c39.8 0 72-32.2 72-72 0-37.1-28-67.6-64-71.6l0-16.4c0-44.2 35.8-80 80-80 33.9 0 62.8 21 74.5 50.8 13.8-8.1 29.1-13.7 45.1-16.6zM229.2 487.3L363.7 260.7c7.6-12.8 21.4-20.6 36.3-20.6s28.7 7.8 36.3 20.6L570.8 487.3c3.4 5.8 5.2 12.4 5.2 19.1 0 20.7-16.8 37.4-37.4 37.4l-277.1 0c-20.7 0-37.4-16.8-37.4-37.4 0-6.7 1.8-13.3 5.2-19.1zM416 327.2c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 80.9c0 8.8 7.2 16 16 16s16-7.2 16-16l0-80.9zM400 504.1a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"],
    "h5": [576, 512, [], "e412", "M96 96c0-17.7-14.3-32-32-32S32 78.3 32 96l0 320c0 17.7 14.3 32 32 32s32-14.3 32-32l0-128 96 0 0 128c0 17.7 14.3 32 32 32s32-14.3 32-32l0-320c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 128-96 0 0-128zM352 64c-17.7 0-32 14.3-32 32l0 144c0 17.7 14.3 32 32 32l80 0c30.9 0 56 25.1 56 56s-25.1 56-56 56l-80 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l80 0c66.3 0 120-53.7 120-120S498.3 208 432 208l-48 0 0-80 120 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L352 64z"],
    "person-ski-lift": [512, 512, ["ski-lift"], "f7c8", "M240 0c8.8 0 16 7.2 16 16l0 182.3-32 8.5 0-190.8c0-8.8 7.2-16 16-16zM64 80a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm36.4 138c-14.2-30.8 8.3-66 42.2-66 18.2 0 34.8 10.7 42.3 27.3l28.8 63.4 55.9-14.9c25.4-6.8 50.3 12.4 50.3 38.6l0 122.1 123.1-45.5c12.6-4.6 20.9-16.6 20.9-30l0-1c0-13.3 10.7-24 24-24s24 10.7 24 24l0 1c0 33.5-20.9 63.4-52.3 75L128.3 510.5c-12.4 4.6-26.2-1.8-30.8-14.2s1.8-26.2 14.2-30.8l144.3-53.3 0-114.5-66.7 17.8c-22.6 6-46.2-5.1-55.9-26.3L100.4 218zM45.7 189.6l65 135.8c8.3 17.4 28 26.4 46.6 21.3l36.5-9.9c12.8-3.5 26 4.1 29.5 16.8s-4.1 26-16.8 29.5l-36.5 9.9c-41 11.2-84.2-8.6-102.5-46.9L2.4 210.4c-5.7-12-.7-26.3 11.3-32s26.3-.7 32 11.3z"],
    "square-cedi": [448, 512, [], "e729", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm184 88l0 10.2c24.5 4.6 46.5 16.3 63.9 32.7 9.6 9.1 10.1 24.3 1 33.9s-24.3 10.1-33.9 1c-8.7-8.2-19.2-14.5-30.9-18.2l0 152.7c11.7-3.7 22.2-9.9 30.9-18.2 9.6-9.1 24.8-8.7 33.9 1s8.7 24.8-1 33.9c-17.4 16.4-39.4 28-63.9 32.7l0 10.2c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-10.2C140.8 370.5 96 318.5 96 256s44.8-114.5 104-125.8l0-10.2c0-13.3 10.7-24 24-24s24 10.7 24 24zM144 256c0 35.8 23.5 66.1 56 76.3l0-152.7c-32.5 10.2-56 40.5-56 76.3z"],
    "filter": [512, 512, [], "f0b0", "M32 64C19.1 64 7.4 71.8 2.4 83.8S.2 109.5 9.4 118.6L192 301.3 192 416c0 8.5 3.4 16.6 9.4 22.6l64 64c9.2 9.2 22.9 11.9 34.9 6.9S320 492.9 320 480l0-178.7 182.6-182.6c9.2-9.2 11.9-22.9 6.9-34.9S492.9 64 480 64L32 64z"],
    "calculator-simple": [512, 512, ["calculator-alt"], "f64c", "M0 48C0 21.5 21.5 0 48 0L176 0c26.5 0 48 21.5 48 48l0 128c0 26.5-21.5 48-48 48L48 224c-26.5 0-48-21.5-48-48L0 48zm288 0c0-26.5 21.5-48 48-48L464 0c26.5 0 48 21.5 48 48l0 128c0 26.5-21.5 48-48 48l-128 0c-26.5 0-48-21.5-48-48l0-128zm48 240l128 0c26.5 0 48 21.5 48 48l0 128c0 26.5-21.5 48-48 48l-128 0c-26.5 0-48-21.5-48-48l0-128c0-26.5 21.5-48 48-48zM0 336c0-26.5 21.5-48 48-48l128 0c26.5 0 48 21.5 48 48l0 128c0 26.5-21.5 48-48 48L48 512c-26.5 0-48-21.5-48-48L0 336zM424 72c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 16-16 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l16 0 0 16c0 13.3 10.7 24 24 24s24-10.7 24-24l0-16 16 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-16 0 0-16zM72 88c-13.3 0-24 10.7-24 24s10.7 24 24 24l80 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L72 88zM55 343c-9.4 9.4-9.4 24.6 0 33.9l23 23-23 23c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l23-23 23 23c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-23-23 23-23c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-23 23-23-23c-9.4-9.4-24.6-9.4-33.9 0zm305-7c-13.3 0-24 10.7-24 24s10.7 24 24 24l80 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0zm0 80c-13.3 0-24 10.7-24 24s10.7 24 24 24l80 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0z"],
    "coin-blank": [512, 512, [], "e3fb", "M0 208l0 96c0 29.1 19.4 55.9 52 77.3L52 295c11.7 8.7 25.1 16.6 40 23.6l0 83.7c23.5 9.8 50.5 17.5 80 22.7l0-80.9c12.9 2.5 26.3 4.5 40 5.8l0 80.2c14.3 1.2 29 1.9 44 1.9s29.7-.6 44-1.9l0-80.2c13.7-1.3 27.1-3.3 40-5.8l0 80.9c29.5-5.1 56.5-12.9 80-22.7l0-83.7c14.9-7 28.3-14.9 40-23.6l0 86.3c32.6-21.5 52-48.3 52-77.3l0-96c0-79.5-114.6-144-256-144S0 128.5 0 208zm256 96c-106 0-192-43-192-96s86-96 192-96 192 43 192 96-86 96-192 96z"],
    "intersection": [384, 512, [8898], "f668", "M32 480c17.7 0 32-14.3 32-32l0-224c0-70.7 57.3-128 128-128s128 57.3 128 128l0 224c0 17.7 14.3 32 32 32s32-14.3 32-32l0-224c0-106-86-192-192-192S0 118 0 224L0 448c0 17.7 14.3 32 32 32z"],
    "drum": [512, 512, [129345], "f569", "M501.2 76.1c11.1-7.3 14.2-22.1 6.9-33.2s-22.1-14.2-33.2-6.9L370.2 104.5C335.8 98.7 297 96 256 96 114.6 96 0 128 0 208L0 368c0 31.3 27.4 58.8 72 78.7L72 344c0-13.3 10.7-24 24-24s24 10.7 24 24l0 119.4c33 8.9 71.1 14.5 112 16.1L232 376c0-13.3 10.7-24 24-24s24 10.7 24 24l0 103.5c40.9-1.6 79-7.2 112-16.1L392 344c0-13.3 10.7-24 24-24s24 10.7 24 24l0 102.7c44.6-19.9 72-47.4 72-78.7l0-160c0-41.1-30.2-69.5-78.8-87.4l67.9-44.5zM307.4 145.6l-64.6 42.3c-11.1 7.3-14.2 22.1-6.9 33.2s22.1 14.2 33.2 6.9l111.1-72.8c14.7 3.2 27.9 7 39.4 11.5 38.8 15.1 44.4 30.6 44.4 41.3 0 .8-2.7 17.2-46 35.9-38.9 16.8-96 28.1-162 28.1S132.9 260.7 94 243.9c-43.3-18.7-46-35.1-46-35.9 0-10.6 5.6-26.2 44.4-41.3 38.3-14.9 95.4-22.7 163.6-22.7 18 0 35.1 .5 51.4 1.6z"],
    "map-pin": [320, 512, [128205], "f276", "M192 284.4C256.1 269.9 304 212.5 304 144 304 64.5 239.5 0 160 0S16 64.5 16 144c0 68.5 47.9 125.9 112 140.4L128 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-195.6zM168 96c-30.9 0-56 25.1-56 56 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-57.4 46.6-104 104-104 13.3 0 24 10.7 24 24s-10.7 24-24 24z"],
    "circle-house": [512, 512, [], "e6c8", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM368 256l0 85.5c0 23.5-19 42.5-42.5 42.5l-139 0C163 384 144 365 144 341.5l0-85.5-9.7 0c-12.3 0-22.3-10-22.3-22.3 0-6.2 2.5-12 7-16.3L242.2 101.5C245.9 98 250.9 96 256 96s10.1 2 13.8 5.5L393 217.4c4.5 4.2 7 10.1 7 16.3 0 12.3-10 22.3-22.3 22.3l-9.7 0zM224 288l0 48 64 0 0-48c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16z"],
    "table-pivot": [576, 512, [], "e291", "M448 96l-192 0 0 64 96 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-96 0 0 96c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-96-64 0 0 192 87.5 0c-10 20.1-10 43.9 0 64L128 480c-35.3 0-64-28.7-64-64L64 96c0-35.3 28.7-64 64-64l320 0c35.3 0 64 28.7 64 64l0 87.5c-20.1-10-43.9-10-64 0L448 96zM128 160l64 0 0-64-64 0 0 64zM528 320l-16 0 0 96c0 35.3-28.7 64-64 64l-96 0 0 16c0 9.7-5.8 18.5-14.8 22.2s-19.3 1.7-26.2-5.2l-48-48c-9.4-9.4-9.4-24.6 0-33.9l48-48c6.9-6.9 17.2-8.9 26.2-5.2S352 390.3 352 400l0 16 96 0 0-96-16 0c-9.7 0-18.5-5.8-22.2-14.8s-1.7-19.3 5.2-26.2l48-48c9.4-9.4 24.6-9.4 33.9 0l48 48c6.9 6.9 8.9 17.2 5.2 26.2S537.7 320 528 320z"],
    "bridge-suspension": [512, 512, [], "e4cd", "M73.4 15.9c-.7 1.9-1.1 3.9-1.3 6-4.1 37.6-27.5 71.3-60.9 92.4-11.2 7.1-14.6 21.9-7.5 33.1s21.9 14.6 33.1 7.5c12.8-8.1 24.6-17.7 35.2-28.6l0 129.7-72 0 0 80c37.6 9.4 64 43.2 64 82l0 62c0 17.7 14.3 32 32 32l34.9 0c16.1 0 29.1-13 29.1-29.1l0-34.9c0-53 43-96 96-96s96 43 96 96l0 34.9c0 16.1 13 29.1 29.1 29.1l34.9 0c17.7 0 32-14.3 32-32l0-62c0-38.8 26.4-72.6 64-82l0-80-72 0 0-128.3c10.5 10.8 22.4 20.4 35.4 28.4 11.3 6.9 26.1 3.4 33-7.9s3.4-26.1-7.9-33c-33.7-20.7-56.5-54.7-60.7-93.2-.2-2.1-.6-4.1-1.3-6.1-2.4-6.7-7.8-12.1-14.6-14.5-2.4-.9-5.1-1.3-7.8-1.3-2.9 0-5.7 .5-8.3 1.4-6.6 2.4-12 7.7-14.4 14.5-.7 1.9-1.1 3.9-1.3 5.9-6.9 62.9-64.1 114.1-136.1 114.1S126.8 84.8 119.9 21.9c-.2-2.1-.6-4-1.3-5.9-1.2-3.5-3.2-6.5-5.8-9-2.4-2.4-5.4-4.3-8.7-5.5-2.6-.9-5.4-1.5-8.3-1.4-2.7 0-5.3 .5-7.8 1.3-3.5 1.2-6.6 3.2-9.2 5.8-2.4 2.4-4.3 5.4-5.5 8.8zM336 166.8c21.2-9.6 40.2-23 56-39.3l0 128.5-56 0 0-89.2zM256 184c10.9 0 21.6-.9 32-2.6l0 74.6-64 0 0-74.6c10.4 1.7 21.1 2.6 32 2.6zM120 127.5c15.8 16.3 34.8 29.6 56 39.3l0 89.2-56 0 0-128.5z"],
    "scale-unbalanced-flip": [640, 512, ["balance-scale-right"], "f516", "M118.2 62.4C101.5 56.8 92.4 38.6 98 21.9S121.7-3.9 138.5 1.6l113 37.7c13.9-23.5 39.6-39.3 68.9-39.3 44.2 0 80 35.8 80 80 0 3-.2 5.9-.5 8.8l122.6 40.9c16.8 5.6 25.8 23.7 20.2 40.5s-23.7 25.8-40.5 20.2L366.7 145.2c-4.5 3.2-9.3 5.9-14.4 8.2l0 326.7c0 17.7-14.3 32-32 32l-192 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l160 0 0-294.7c-21-9.2-37.2-27-44.2-49l-125.9-42zM200.8 288L128.3 163.8 55.9 288 200.8 288zm-72.4 96c-62.9 0-115.2-34-126-78.9-2.6-11 1-22.3 6.7-32.1l95.2-163.2c5-8.6 14.2-13.8 24.1-13.8s19.1 5.3 24.1 13.8l95.2 163.2c5.7 9.8 9.3 21.1 6.7 32.1-10.8 44.8-63.1 78.9-126 78.9zm382.8-92.2l-72.4 124.2 144.9 0-72.4-124.2zm126 141.3C626.4 478 574.1 512 511.2 512s-115.2-34-126-78.9c-2.6-11 1-22.3 6.7-32.1l95.2-163.2c5-8.6 14.2-13.8 24.1-13.8s19.1 5.3 24.1 13.8l95.2 163.2c5.7 9.8 9.3 21.1 6.7 32.1z"],
    "light-switch": [384, 512, [], "e017", "M0 64C0 28.7 28.7 0 64 0L320 0c35.3 0 64 28.7 64 64l0 384c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zm96 96l0 72 192 0 0-72c0-35.3-28.7-64-64-64l-64 0c-35.3 0-64 28.7-64 64zm0 120l0 72c0 35.3 28.7 64 64 64l64 0c35.3 0 64-28.7 64-64l0-72-192 0z"],
    "arrows-to-circle": [512, 512, [], "e4bd", "M9.4 9.4C21.9-3.1 42.1-3.1 54.6 9.4L128 82.7 128 64c0-17.7 14.3-32 32-32s32 14.3 32 32l0 96c0 17.7-14.3 32-32 32l-96 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l18.7 0-73.4-73.4C-3.1 42.1-3.1 21.9 9.4 9.4zM200 256a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zM502.6 54.6L429.3 128 448 128c17.7 0 32 14.3 32 32s-14.3 32-32 32l-96 0c-17.7 0-32-14.3-32-32l0-96c0-17.7 14.3-32 32-32s32 14.3 32 32l0 18.7 73.4-73.4c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3zm-45.3 448L384 429.3 384 448c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-96c0-17.7 14.3-32 32-32l96 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-18.7 0 73.4 73.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0zM9.4 457.4L82.7 384 64 384c-17.7 0-32-14.3-32-32s14.3-32 32-32l96 0c17.7 0 32 14.3 32 32l0 96c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-18.7-73.4 73.4c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3z"],
    "ampersand": [384, 512, [], "26", "M112 112.7c0 12.2 4.5 24.1 12.5 33l27.6 30.9 36.4-26.6c12.3-9 19.5-23.2 19.5-38.4 0-26.2-21.4-47.6-47.8-47.6-26.2 0-48.2 22-48.2 48.7zm114.3 88.9l-31.3 22.8 88.1 98.5 47.5-42.8c13.1-11.8 33.4-10.8 45.2 2.4s10.8 33.4-2.4 45.2l-47.7 42.9 50.1 56c11.8 13.2 10.7 33.4-2.5 45.2s-33.4 10.7-45.2-2.5l-50-55.8-17.2 15.5c-36.5 32.9-83.9 51-133 51-70.2 0-128-56.9-128-127.5 0-40.7 19.4-78.9 52.3-102.9l47.9-35-23.4-26.1C58.2 167.6 48 140.4 48 112.7 48 51.2 98.1 0 160.2 0 221.7 0 272 49.9 272 111.6 272 147.2 255 180.7 226.3 201.7zM128 416c33.3 0 65.4-12.3 90.2-34.6l17.3-15.6-92.4-103.3-53 38.7c-16.4 12-26 31-26 51.3 0 34.9 28.7 63.5 64 63.5z"],
    "chess-clock": [576, 512, [], "f43d", "M224 40c0-13.3-10.7-24-24-24L88 16C74.7 16 64 26.7 64 40S74.7 64 88 64l32 0 0 32-56 0C28.7 96 0 124.7 0 160L0 384c0 35.3 28.7 64 64 64l448 0c35.3 0 64-28.7 64-64l0-224c0-35.3-28.7-64-64-64l-16 0c0-17.7-14.3-32-32-32l-96 0c-17.7 0-32 14.3-32 32l-168 0 0-32 32 0c13.3 0 24-10.7 24-24zM336.8 192.8A112 112 0 1 1 495.2 351.2 112 112 0 1 1 336.8 192.8zm135.8 22.6c-9.4-9.4-24.6-9.4-33.9 0l-33.9 33.9c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l33.9-33.9c9.4-9.4 9.4-24.6 0-33.9zM160 160a112 112 0 1 1 0 224 112 112 0 1 1 0-224zm24 56c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 48c0 13.3 10.7 24 24 24s24-10.7 24-24l0-48z"],
    "envelope": [512, 512, [128386, 9993, 61443], "f0e0", "M48 64c-26.5 0-48 21.5-48 48 0 15.1 7.1 29.3 19.2 38.4l208 156c17.1 12.8 40.5 12.8 57.6 0l208-156c12.1-9.1 19.2-23.3 19.2-38.4 0-26.5-21.5-48-48-48L48 64zM0 196L0 384c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-188-198.4 148.8c-34.1 25.6-81.1 25.6-115.2 0L0 196z"],
    "baby": [384, 512, [], "f77c", "M120 88a72 72 0 1 1 144 0 72 72 0 1 1 -144 0zM7.7 144.5c13-17.9 38-21.8 55.9-8.8L99.8 162c26.8 19.5 59.1 30 92.2 30s65.4-10.5 92.2-30l36.2-26.4c17.9-13 42.9-9 55.9 8.8s9 42.9-8.8 55.9l-36.2 26.4c-13.6 9.9-28.1 18.2-43.3 25l0 36.3-192 0 0-36.3c-15.2-6.7-29.7-15.1-43.3-25L16.5 200.3c-17.9-13-21.8-38-8.8-55.9zM97.5 329.3l60.6 53-26 37.2 24.3 24.3c15.6 15.6 15.6 40.9 0 56.6s-40.9 15.6-56.6 0l-48-48C38 438.6 36.1 417 47.2 401.1l50.2-71.8zm128.5 53l60.6-53 50.2 71.8c11.1 15.9 9.2 37.5-4.5 51.2l-48 48c-15.6 15.6-40.9 15.6-56.6 0s-15.6-40.9 0-56.6l24.3-24.3-26-37.2z"],
    "nfc-lock": [576, 512, [], "e1f8", "M32 96c0-35.3 28.7-64 64-64l320 0c35.3 0 64 28.7 64 64l0 81c-5.2-.7-10.6-1-16-1-17 0-33.2 3.3-48 9.3l0-49.3c0-22.1-17.9-40-40-40L272 96c-22.1 0-40 17.9-40 40l0 78.4c-14.3 8.3-24 23.8-24 41.6 0 26.5 21.5 48 48 48s48-21.5 48-48c0-17.8-9.7-33.3-24-41.6l0-70.4 88 0 0 75.3c-19.9 22.6-32 52.2-32 84.7l0 24.4c-11.9 10.7-21.1 24.2-26.6 39.6l-165.4 0 0-224 24 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-32 0c-22.1 0-40 17.9-40 40l0 240c0 22.1 17.9 40 40 40l168 0 0 64-208 0c-35.3 0-64-28.7-64-64L32 96zM496 304.1c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 47.9 64 0 0-47.9zM352 400c0-20.9 13.4-38.7 32-45.3l0-50.6c0-44.2 35.8-80 80-80s80 35.8 80 80l0 50.6c18.6 6.6 32 24.4 32 45.3l0 96c0 26.5-21.5 48-48 48l-128 0c-26.5 0-48-21.5-48-48l0-96z"],
    "square-caret-down": [448, 512, ["caret-square-down"], "f150", "M384 480c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0zM224 352c-6.7 0-13-2.8-17.6-7.7l-104-112c-6.5-7-8.2-17.2-4.4-25.9S110.5 192 120 192l208 0c9.5 0 18.2 5.7 22 14.4s2.1 18.9-4.4 25.9l-104 112c-4.5 4.9-10.9 7.7-17.6 7.7z"],
    "hyphen": [320, 512, [], "2d", "M0 256c0-17.7 14.3-32 32-32l256 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 288c-17.7 0-32-14.3-32-32z"],
    "plane-prop": [576, 512, [], "e22b", "M231 312l9 72-16 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l24 0 6.2 50c1 8 7.8 14 15.9 14l35.8 0c8.1 0 14.9-6 15.9-14l6.2-50 28 0 0 8c0 11 9 20 20 20s20-9 20-20l0-80c0-11-9-20-20-20s-20 9-20 20l0 8-20 0 9-72 175 0c30.9 0 56-25.1 56-56s-25.1-56-56-56l-175 0-9-72 20 0 0 8c0 11 9 20 20 20s20-9 20-20l0-80c0-11-9-20-20-20s-20 9-20 20l0 8-28 0-6.2-50c-1-8-7.8-14-15.9-14L270.1 0c-8.1 0-14.9 6-15.9 14l-6.2 50-24 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l16 0-9 72-56.7 0c-9.5 0-19.1 .7-28.5 2.1l-19.3 2.9-26.1-52.2c-2.7-5.4-8.3-8.8-14.3-8.8l-18.2 0c-7.1 0-13.3 4.6-15.3 11.4l-19.1 63.6-1.8 .3C13.5 222 0 237.6 0 256s13.5 34 31.6 36.7l1.8 .3 19.1 63.6c2 6.8 8.3 11.4 15.3 11.4l18.2 0c6.1 0 11.6-3.4 14.3-8.8l26.1-52.2 19.3 2.9c9.4 1.4 19 2.1 28.5 2.1l56.7 0z"],
    "tent": [512, 512, [], "e57d", "M26.9 206.9L3.7 444.9C1.8 463.7 16.6 480 35.5 480l172.7 0c26.5 0 48-21.5 48-48l0-129c0-8.3 6.7-15 15-15 5.5 0 10.6 3 13.2 7.9l86.1 159c8.4 15.5 24.6 25.1 42.2 25.1l64.1 0c18.9 0 33.7-16.3 31.8-35.1L485.6 207.1c-1.9-19.6-12.8-37.3-29.5-47.8L280.9 48.3c-15.7-10-35.8-9.9-51.5 .1L56.1 159.2c-16.5 10.6-27.3 28.2-29.2 47.7z"],
    "chimney": [448, 512, [], "f78b", "M0 64C0 46.3 14.3 32 32 32l384 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32L32 160c-17.7 0-32-14.3-32-32L0 64zM32 192l96 0 0 128-96 0 0-128zm384 0l0 128-256 0 0-128 256 0zM288 352l0 128-256 0 0-128 256 0zm128 0l0 128-96 0 0-128 96 0z"],
    "a": [384, 512, [97], "41", "M221.5 51.7C216.6 39.8 204.9 32 192 32s-24.6 7.8-29.5 19.7c-93.3 224-146.7 352-160 384-6.8 16.3 .9 35 17.2 41.8s35-.9 41.8-17.2l31.8-76.3 197.3 0 31.8 76.3c6.8 16.3 25.5 24 41.8 17.2s24-25.5 17.2-41.8c-13.3-32-66.7-160-160-384zM264 320l-144 0 72-172.8 72 172.8z"],
    "circle-small": [320, 512, [], "e122", "M0 256a160 160 0 1 1 320 0 160 160 0 1 1 -320 0z"],
    "parachute-box": [512, 512, [], "f4cd", "M128 224C128 152.2 144.3 88.4 169.5 43.4 195.1-2.4 226.6-24 256-24s60.9 21.6 86.5 67.4C367.7 88.4 384 152.2 384 224l-104 0 0 96 8 0c9.3 0 18.1 2 26 5.5l118.4-101.5-.5 0c0-78.4-17.7-150.6-47.6-204-6.1-11-12.9-21.3-20.3-30.9 86.5 35.9 147.8 115.1 147.8 218.9 0 7-3.1 13.7-8.4 18.2L347.4 360.1c3 7.4 4.6 15.4 4.6 23.9l0 64c0 35.3-28.7 64-64 64l-64 0c-35.3 0-64-28.7-64-64l0-64c0-8.4 1.6-16.5 4.6-23.9L8.4 226.2C3.1 221.7 0 215 0 208 0 104.2 61.3 24.9 147.8-10.9 140.5-1.4 133.7 9 127.6 20 97.7 73.4 80 145.6 80 224l-.5 0 118.4 101.5c8-3.5 16.8-5.5 26-5.5l8 0 0-96-104 0z"],
    "cart-flatbed-boxes": [576, 512, ["dolly-flatbed-alt"], "f475", "M0 32C0 14.3 14.3 0 32 0L48 0c44.2 0 80 35.8 80 80l0 288c0 8.8 7.2 16 16 16l400 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-34.7 0c1.8 5 2.7 10.4 2.7 16 0 26.5-21.5 48-48 48s-48-21.5-48-48c0-5.6 1-11 2.7-16l-197.5 0c1.8 5 2.7 10.4 2.7 16 0 26.5-21.5 48-48 48s-48-21.5-48-48c0-6 1.1-11.7 3.1-17-38.1-6.2-67.1-39.2-67.1-79L64 80c0-8.8-7.2-16-16-16L32 64C14.3 64 0 49.7 0 32zm176 80c0-26.5 21.5-48 48-48l48 0c26.5 0 48 21.5 48 48l0 176c0 26.5-21.5 48-48 48l-48 0c-26.5 0-48-21.5-48-48l0-176zm240 48l48 0c26.5 0 48 21.5 48 48l0 80c0 26.5-21.5 48-48 48l-48 0c-26.5 0-48-21.5-48-48l0-80c0-26.5 21.5-48 48-48z"],
    "cart-arrow-down": [640, 512, [], "f218", "M0 8C0-5.3 10.7-16 24-16l45.3 0c27.1 0 50.3 19.4 55.1 46l.4 2 187.2 0 0 102.1-31-31c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l72 72c9.4 9.4 24.6 9.4 33.9 0l72-72c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-31 31 0-102.1 177.4 0c20 0 35.1 18.2 31.4 37.9L537.8 235.8c-5.7 30.3-32.1 52.2-62.9 52.2l-303.6 0 5.1 28.3c2.1 11.4 12 19.7 23.6 19.7L456 336c13.3 0 24 10.7 24 24s-10.7 24-24 24l-255.9 0c-34.8 0-64.6-24.9-70.8-59.1L77.2 38.6c-.7-3.8-4-6.6-7.9-6.6L24 32C10.7 32 0 21.3 0 8zM160 464a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm224 0a48 48 0 1 1 96 0 48 48 0 1 1 -96 0z"],
    "circle-7": [512, 512, [], "e0f4", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM200 144l112 0c8.3 0 16 4.3 20.4 11.4s4.8 15.9 1 23.4l-88 176c-5.9 11.9-20.3 16.7-32.2 10.7s-16.7-20.3-10.7-32.2L273.2 192 200 192c-13.3 0-24-10.7-24-24s10.7-24 24-24z"],
    "lock-hashtag": [384, 512, [], "e423", "M128 96l0 64 128 0 0-64c0-35.3-28.7-64-64-64s-64 28.7-64 64zM64 160l0-64C64 25.3 121.3-32 192-32S320 25.3 320 96l0 64c35.3 0 64 28.7 64 64l0 224c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 224c0-35.3 28.7-64 64-64zm72 48c-13.3 0-24 10.7-24 24l0 24-24 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l24 0 0 64-24 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l24 0 0 24c0 13.3 10.7 24 24 24s24-10.7 24-24l0-24 64 0 0 24c0 13.3 10.7 24 24 24s24-10.7 24-24l0-24 24 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-24 0 0-64 24 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-24 0 0-24c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 24-64 0 0-24c0-13.3-10.7-24-24-24zm24 96l64 0 0 64-64 0 0-64z"],
    "circle-sterling": [512, 512, [], "e5cf", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM176 264c-8.8 0-16-7.2-16-16s7.2-16 16-16l2.9 0c-15.8-55.2 25.5-112 84.7-112l2.2 0c19.7 0 38.8 6.4 54.5 18.2l14.2 10.6c10.6 8 12.8 23 4.8 33.6s-23 12.8-33.6 4.8l-14.2-10.6C284 171 275 168 265.7 168l-2.2 0c-28.5 0-47.8 28.9-37 55.2l2.5 6c.4 .9 .7 1.8 1.1 2.8l73.9 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-67.1 0c1.3 23.4-5.2 46.9-19.1 66.6l-3.7 5.4 113.9 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-160 0c-8.9 0-17.2-5-21.3-12.9s-3.5-17.5 1.6-24.8l30.2-43.1c8.1-11.5 11.6-25.5 10.3-39.1L176 264z"],
    "bridge-circle-exclamation": [576, 512, [], "e4ca", "M32 32C14.3 32 0 46.3 0 64S14.3 96 32 96l8 0 0 64-40 0 0 112c37.6 9.4 64 43.2 64 82l0 94c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-64c0-53 43-96 96-96 6.4 0 12.7 .6 18.7 1.8 34.7-49.5 92.2-81.8 157.3-81.8 28.6 0 55.6 6.2 80 17.4l0-65.4-40 0 0-64 8 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 32zM424 96l0 64-80 0 0-64 80 0zM296 96l0 64-80 0 0-64 80 0zM88 96l80 0 0 64-80 0 0-64zM432 544a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm0-100a20 20 0 1 1 0 40 20 20 0 1 1 0-40zm0-140c8.8 0 16 7.2 16 16l0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80c0-8.8 7.2-16 16-16z"],
    "cloud-arrow-up": [576, 512, [62338, "cloud-upload", "cloud-upload-alt"], "f0ee", "M144 480c-79.5 0-144-64.5-144-144 0-63.4 41-117.2 97.9-136.5-1.3-7.7-1.9-15.5-1.9-23.5 0-79.5 64.5-144 144-144 55.4 0 103.5 31.3 127.6 77.1 14.2-8.3 30.8-13.1 48.4-13.1 53 0 96 43 96 96 0 15.7-3.8 30.6-10.5 43.7 44 20.3 74.5 64.7 74.5 116.3 0 70.7-57.3 128-128 128l-304 0zM305 191c-9.4-9.4-24.6-9.4-33.9 0l-72 72c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l31-31 0 102.1c0 13.3 10.7 24 24 24s24-10.7 24-24l0-102.1 31 31c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-72-72z"],
    "at": [512, 512, [61946], "40", "M256 64C150 64 64 150 64 256s86 192 192 192c17.7 0 32 14.3 32 32s-14.3 32-32 32C114.6 512 0 397.4 0 256S114.6 0 256 0 512 114.6 512 256l0 32c0 53-43 96-96 96-29.3 0-55.6-13.2-73.2-33.9-22.8 21-53.3 33.9-86.8 33.9-70.7 0-128-57.3-128-128s57.3-128 128-128c27.9 0 53.7 8.9 74.7 24.1 5.7-5 13.1-8.1 21.3-8.1 17.7 0 32 14.3 32 32l0 112c0 17.7 14.3 32 32 32s32-14.3 32-32l0-32c0-106-86-192-192-192zm64 192a64 64 0 1 0 -128 0 64 64 0 1 0 128 0z"],
    "indian-rupee-sign": [320, 512, ["indian-rupee", "inr"], "e1bc", "M0 64C0 46.3 14.3 32 32 32l264 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-76.7 0c17.7 19.8 30.1 44.6 34.7 72l42 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-42 0c-10.4 62.2-60.8 110.9-123.8 118.9L274.6 422c14.4 10.3 17.7 30.3 7.4 44.6s-30.3 17.7-44.6 7.4L13.4 314C2.1 306-2.7 291.5 1.5 278.2S18.1 256 32 256l80 0c35.8 0 66.1-23.5 76.3-56L24 200c-13.3 0-24-10.7-24-24s10.7-24 24-24l164.3 0c-10.2-32.5-40.5-56-76.3-56L32 96C14.3 96 0 81.7 0 64z"],
    "truck": [576, 512, [128666, 9951], "f0d1", "M0 96C0 60.7 28.7 32 64 32l288 0c35.3 0 64 28.7 64 64l0 32 50.7 0c17 0 33.3 6.7 45.3 18.7L557.3 192c12 12 18.7 28.3 18.7 45.3L576 384c0 35.3-28.7 64-64 64l-3.3 0c-10.4 36.9-44.4 64-84.7 64s-74.2-27.1-84.7-64l-102.6 0c-10.4 36.9-44.4 64-84.7 64s-74.2-27.1-84.7-64L64 448c-35.3 0-64-28.7-64-64L0 96zM512 288l0-50.7-45.3-45.3-50.7 0 0 96 96 0zM192 424a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zm232 40a40 40 0 1 0 0-80 40 40 0 1 0 0 80z"],
    "game-console-handheld-crank": [640, 512, [], "e5b9", "M448 32c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64l-320 0c-35.3 0-64-28.7-64-64L64 96c0-35.3 28.7-64 64-64l320 0zM176 320c-8.8 0-16 7.2-16 16l0 16-16 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l16 0 0 16c0 8.8 7.2 16 16 16s16-7.2 16-16l0-16 16 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0 0-16c0-8.8-7.2-16-16-16zm168 16a24 24 0 1 0 0 48 24 24 0 1 0 0-48zm80 0a24 24 0 1 0 0 48 24 24 0 1 0 0-48zM616 144c13.3 0 24 10.7 24 24l0 32c0 13.3-10.7 24-24 24l-8 0 0 72c0 13.3-10.7 24-24 24l-24 0 0-152 .1-2.5c1.2-12.1 11.5-21.5 23.9-21.5l32 0zM160 96c-17.7 0-32 14.3-32 32l0 96c0 17.7 14.3 32 32 32l256 0c17.7 0 32-14.3 32-32l0-96c0-17.7-14.3-32-32-32L160 96z"],
    "chalkboard-user": [640, 512, ["chalkboard-teacher"], "f51c", "M128 96c0-35.3 28.7-64 64-64l352 0c35.3 0 64 28.7 64 64l0 240-96 0 0-16c0-17.7-14.3-32-32-32l-64 0c-17.7 0-32 14.3-32 32l0 16-129.1 0c10.9-18.8 17.1-40.7 17.1-64 0-70.7-57.3-128-128-128-5.4 0-10.8 .3-16 1l0-49zM333 448c-5.1-24.2-16.3-46.1-32.1-64L608 384c0 35.3-28.7 64-64 64l-211 0zM64 272a80 80 0 1 1 160 0 80 80 0 1 1 -160 0zM0 480c0-53 43-96 96-96l96 0c53 0 96 43 96 96 0 17.7-14.3 32-32 32L32 512c-17.7 0-32-14.3-32-32z"],
    "user-check": [640, 512, [], "f4fc", "M286 304c98.5 0 178.3 79.8 178.3 178.3 0 16.4-13.3 29.7-29.7 29.7L78 512c-16.4 0-29.7-13.3-29.7-29.7 0-98.5 79.8-178.3 178.3-178.3l59.4 0zM585.7 105.9c7.8-10.7 22.8-13.1 33.5-5.3s13.1 22.8 5.3 33.5L522.1 274.9c-4.2 5.7-10.7 9.4-17.7 9.8s-14-2.2-18.9-7.3l-46.4-48c-9.2-9.5-9-24.7 .6-33.9 9.5-9.2 24.7-8.9 33.9 .6l26.5 27.4 85.6-117.7zM256.3 248a120 120 0 1 1 0-240 120 120 0 1 1 0 240z"],
    "chart-pie-simple-circle-currency": [640, 512, [], "e604", "M541.9 208.1c-14.2-107-99-191.7-206-206-17.5-2.3-31.9 12.2-31.9 29.9l0 176c0 17.7 14.3 32 32 32l53.8 0c30.4-20.2 66.9-32 106.2-32 15.9 0 31.3 1.9 46.1 5.6 .1-1.8 .1-3.6-.2-5.5zM272 512c21.6 0 42.5-2.9 62.4-8.2-19.3-29.9-30.4-65.6-30.4-103.8 0-41.8 13.4-80.5 36-112l-60 0c-13.3 0-24-10.7-24-24l0-197.3C256 48.2 240.3 33.4 222.2 37.2 113.5 60.1 32 156.5 32 272 32 404.5 139.5 512 272 512zM640 400a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-68.7-52.7l-20.2 20.2c5.6 9.5 8.9 20.6 8.9 32.5s-3.2 23-8.9 32.5l20.2 20.2c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-20.2-20.2c-9.5 5.6-20.6 8.9-32.5 8.9s-23-3.2-32.5-8.9l-20.2 20.2c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l20.2-20.2c-5.6-9.5-8.9-20.6-8.9-32.5s3.2-23 8.9-32.5l-20.2-20.2c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l20.2 20.2c9.5-5.6 20.6-8.9 32.5-8.9s23 3.2 32.5 8.9l20.2-20.2c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6zM496 432a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "face-fearful": [512, 512, [], "e375", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm0-192c44.2 0 80 35.8 80 80 0 8.8-7.2 16-16 16l-128 0c-8.8 0-16-7.2-16-16 0-44.2 35.8-80 80-80zM96 224a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zm256-64a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM176 116c-4.2 0-8.4 .3-12.5 .8-20.3 2.7-38.9 11.9-53.8 25.8-8.1 7.5-20.7 7.1-28.3-1s-7.1-20.7 1-28.3c20.6-19.3 46.8-32.4 75.9-36.2 5.8-.8 11.7-1.2 17.7-1.2 11 0 20 9 20 20s-9 20-20 20zm172.5 .8c-4.1-.5-8.3-.8-12.5-.8-11 0-20-9-20-20s9-20 20-20c6 0 11.9 .4 17.7 1.2 29.1 3.8 55.3 17 75.9 36.2 8.1 7.5 8.5 20.2 1 28.3s-20.2 8.5-28.3 1c-14.9-13.9-33.5-23.1-53.8-25.8zM192 224a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm160 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "user-ninja": [448, 512, [129399], "f504", "M352 128c0 70.7-57.3 128-128 128-57.2 0-105.6-37.5-122-89.3-1.1 1.3-2.2 2.6-3.5 3.8-15.8 15.8-38.8 20.7-53.6 22.1-8.1 .8-14.6-5.7-13.8-13.8 1.4-14.7 6.3-37.8 22.1-53.6 5.8-5.8 12.6-10.1 19.6-13.4-7-3.2-13.8-7.6-19.6-13.4-15.8-15.8-20.7-38.8-22.1-53.6-.8-8.1 5.7-14.6 13.8-13.8 14.7 1.4 37.8 6.3 53.6 22.1 4.8 4.8 8.7 10.4 11.7 16.1 21.3-41.2 64.3-69.4 113.8-69.4 70.7 0 128 57.3 128 128zM144 112c0 8.8 7.2 16 16 16l128 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L160 96c-8.8 0-16 7.2-16 16zm-1.4 211l67 50.2c8.5 6.4 20.3 6.4 28.8 0l67-50.2c6.5-4.9 15.2-6.2 22.6-2.8 61.4 28.2 104.1 90.2 104.1 162.1 0 16.4-13.3 29.7-29.7 29.7L45.7 512c-16.4 0-29.7-13.3-29.7-29.7 0-72 42.7-134 104.1-162.1 7.4-3.4 16.1-2.1 22.6 2.8z"],
    "frame": [512, 512, [], "e495", "M512 96c0-17.7-14.3-32-32-32l-32 0 0-32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 32-256 0 0-32c0-17.7-14.3-32-32-32S64 14.3 64 32l0 32-32 0C14.3 64 0 78.3 0 96s14.3 32 32 32l32 0 0 256-32 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l32 0 0 32c0 17.7 14.3 32 32 32s32-14.3 32-32l0-32 256 0 0 32c0 17.7 14.3 32 32 32s32-14.3 32-32l0-32 32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0 0-256 32 0c17.7 0 32-14.3 32-32zM128 384l0-256 256 0 0 256-256 0z"],
    "plant-wilt": [512, 512, [], "e5aa", "M344-32c66.3 0 120 53.7 120 120l0 6.2c29.3 12.2 48 41.3 48 76.9 0 27.9-25.3 74.8-66 111.7-3.8 3.5-8.8 5.3-14 5.3s-10.2-1.8-14-5.3c-40.7-36.8-66-83.7-66-111.7 0-35.6 18.7-64.7 48-76.9l0-6.2c0-30.9-25.1-56-56-56s-56 25.1-56 56l0 424c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-296c0-30.9-25.1-56-56-56s-56 25.1-56 56l0 38.2c29.3 12.2 48 41.3 48 76.9 0 27.9-25.3 74.8-66 111.7-3.8 3.5-8.8 5.3-14 5.3s-10.2-1.8-14-5.3C25.3 405.9 0 359 0 331.1 0 295.4 18.7 266.4 48 254.2L48 216c0-66.3 53.7-120 120-120 20.2 0 39.3 5 56 13.8L224 88c0-66.3 53.7-120 120-120z"],
    "weight-scale": [448, 512, ["weight"], "f496", "M116.6 192c-3-10.1-4.6-20.9-4.6-32 0-61.9 50.1-112 112-112S336 98.1 336 160c0 11.1-1.6 21.9-4.6 32l-71 0 24.6-44.3c6.4-11.6 2.3-26.2-9.3-32.6s-26.2-2.3-32.6 9.3l-37.6 67.7-88.8 0zM128 32L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64l-64 0C293.3 11.9 260 0 224 0s-69.3 11.9-96 32z"],
    "farm": [576, 512, ["barn-silo"], "f864", "M112-32C50.1-32 0 18.1 0 80l0 2.2 196 0 27.5-12.5C218.3 12.7 170.4-32 112-32zM80 292.5c0-8.1 1.3-16.2 3.9-23.9l40-119.9c2.2-6.5 5-12.7 8.4-18.5L0 130.2 0 464c0 26.5 21.5 48 48 48l84.1 0c-12.7-18.1-20.1-40.2-20.1-64l0-93.8C92.6 340.5 80 318 80 292.5zm89.4-128.6l-40 119.9c-.9 2.8-1.4 5.7-1.4 8.7 0 15.2 12.3 27.5 27.5 27.5l4.5 0 0 128c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-128 4.5 0c15.2 0 27.5-12.3 27.5-27.5 0-3-.5-5.9-1.4-8.7l-40-119.9c-4.2-12.7-13.5-23-25.7-28.5L371.9 73c-12.6-5.7-27.1-5.7-39.7 0L195.1 135.3c-12.2 5.5-21.5 15.9-25.7 28.5zM320 336l64 0c17.7 0 32 14.3 32 32l0 96-128 0 0-96c0-17.7 14.3-32 32-32zM304 200c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-48z"],
    "caret-right": [256, 512, [], "f0da", "M249.3 235.8c10.2 12.6 9.5 31.1-2.2 42.8l-128 128c-9.2 9.2-22.9 11.9-34.9 6.9S64.5 396.9 64.5 384l0-256c0-12.9 7.8-24.6 19.8-29.6s25.7-2.2 34.9 6.9l128 128 2.2 2.4z"],
    "hexagon-divide": [576, 512, [], "e1ad", "M33.5 291.8c-12.7-22.2-12.7-49.4 0-71.5L129.7 52.2C142.5 29.8 166.4 16 192.2 16l191.6 0c25.8 0 49.7 13.8 62.5 36.2l96.2 168.1c12.7 22.2 12.7 49.4 0 71.5L446.3 459.9c-12.8 22.4-36.7 36.2-62.5 36.2l-191.6 0c-25.8 0-49.7-13.8-62.5-36.2L33.5 291.8zM288 192a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm-88 40c-13.3 0-24 10.7-24 24s10.7 24 24 24l176 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-176 0zM320 352a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "florin-sign": [384, 512, [], "e184", "M314.7 32c-38.8 0-73.7 23.3-88.6 59.1L170.7 224 64 224c-17.7 0-32 14.3-32 32s14.3 32 32 32l80 0-45.1 108.3c-5 11.9-16.6 19.7-29.5 19.7L32 416c-17.7 0-32 14.3-32 32s14.3 32 32 32l37.3 0c38.8 0 73.7-23.3 88.6-59.1L213.3 288 320 288c17.7 0 32-14.3 32-32s-14.3-32-32-32l-80 0 45.1-108.3c5-11.9 16.6-19.7 29.5-19.7L352 96c17.7 0 32-14.3 32-32s-14.3-32-32-32l-37.3 0z"],
    "lightbulb-exclamation-on": [640, 512, [], "e1ca", "M416 448c0 44.2-35.8 80-80 80l-32 0c-44.2 0-80-35.8-80-80l0-16 192 0 0 16zM320 0c106 0 192 86 192 192 0 51.2-20 97.7-52.7 132.1-16.5 17.4-31.2 37.6-38.4 59.9l-201.7 0c-7.3-22.3-21.9-42.5-38.4-59.9-32.7-34.4-52.7-80.9-52.7-132.1 0-106 86-192 192-192zM69.3 298.5c11.9-5.9 26.3-1.1 32.2 10.7s1.1 26.3-10.8 32.2l-32 16c-11.9 5.9-26.3 1.1-32.2-10.7s-1.1-26.3 10.8-32.2l32-16zm469.2 10.7c5.9-11.8 20.3-16.7 32.2-10.7l32 16c11.8 5.9 16.7 20.3 10.7 32.2-5.9 11.8-20.3 16.7-32.2 10.7l-32-16c-11.8-5.9-16.7-20.3-10.7-32.2zM320 248a32 32 0 1 0 0 64 32 32 0 1 0 0-64zM56 168c13.3 0 24 10.7 24 24s-10.7 24-24 24l-32 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l32 0zM320 72c-18.3 0-32.8 15.7-31.2 34l7.3 88c1 12.4 11.4 22 23.9 22s22.9-9.6 23.9-22l7.3-88c1.5-18.3-12.9-34-31.3-34zm296 96c13.3 0 24 10.7 24 24s-10.7 24-24 24l-32 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l32 0zM26.5 37.3c5.9-11.9 20.3-16.7 32.2-10.8l32 16c11.9 5.9 16.7 20.3 10.8 32.2S81.1 91.4 69.3 85.5l-32-16C25.4 63.5 20.6 49.1 26.5 37.3zM581.3 26.5c11.9-5.9 26.3-1.1 32.2 10.8s1.1 26.3-10.7 32.2l-32 16c-11.9 5.9-26.3 1.1-32.2-10.8s-1.1-26.3 10.7-32.2l32-16z"],
    "bell": [448, 512, [128276, 61602], "f0f3", "M224 0c-17.7 0-32 14.3-32 32l0 3.2C119 50 64 114.6 64 192l0 21.7c0 48.1-16.4 94.8-46.4 132.4L7.8 358.3C2.7 364.6 0 372.4 0 380.5 0 400.1 15.9 416 35.5 416l376.9 0c19.6 0 35.5-15.9 35.5-35.5 0-8.1-2.7-15.9-7.8-22.2l-9.8-12.2C400.4 308.5 384 261.8 384 213.7l0-21.7c0-77.4-55-142-128-156.8l0-3.2c0-17.7-14.3-32-32-32zM162 464c7.1 27.6 32.2 48 62 48s54.9-20.4 62-48l-124 0z"],
    "hand-back-point-left": [512, 512, [], "e19f", "M0 168c0-22.1 17.9-40 40-40l280 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-55.7 0c1.4-2 3-3.9 4.5-5.8l16-19.2C297 56.4 315 48 334 48L372 48c38 0 74 16.9 98.3 46.1l4.5 5.4c24 28.8 37.1 65 37.1 102.4L512 320c0 70.7-57.3 128-128 128l-96 0c-26.5 0-48-21.5-48-48 0-12.4 4.7-23.6 12.3-32.1-24.8-1.9-44.3-22.6-44.3-47.9 0-12.4 4.7-23.6 12.3-32.1-24.8-1.9-44.3-22.6-44.3-47.9 0-12.3 4.6-23.5 12.2-32L40 208c-22.1 0-40-17.9-40-40z"],
    "lari-sign": [384, 512, [], "e1c8", "M144 0c13.3 0 24 10.7 24 24l0 41.5c7.9-1 15.9-1.5 24-1.5s16.1 .5 24 1.5L216 24c0-13.3 10.7-24 24-24s24 10.7 24 24l0 54c58.9 23.8 103.2 76 116.2 139.7 3.5 17.3-7.7 34.2-25 37.7s-34.2-7.7-37.7-25c-6.7-33.2-26.4-61.8-53.4-80.2l0 81.8c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-101.8c-7.8-1.5-15.8-2.2-24-2.2s-16.2 .8-24 2.2L168 232c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-81.8c-33.8 23-56 61.9-56 105.8 0 70.7 57.3 128 128 128l160 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 448c-17.7 0-32-14.3-32-32s14.3-32 32-32l16.9 0C18.5 350 0 305.2 0 256 0 175.4 49.6 106.4 120 78l0-54c0-13.3 10.7-24 24-24z"],
    "rectangle-plus": [512, 512, [], "e6b5", "M64 64C28.7 64 0 92.7 0 128L0 384c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L64 64zM232 344l0-64-64 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l64 0 0-64c0-13.3 10.7-24 24-24s24 10.7 24 24l0 64 64 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-64 0 0 64c0 13.3-10.7 24-24 24s-24-10.7-24-24z"],
    "cucumber": [512, 512, [129362], "e401", "M37.5 474.5c47.8 47.8 124 49.9 174.3 6.3 12.6 10.3 31.1 9.6 42.9-2.2 11.6-11.6 12.4-30 2.4-42.6L436 257c12.6 10.1 31 9.3 42.6-2.4 11.7-11.7 12.5-30.3 2.2-42.9 43.6-50.3 41.5-126.5-6.3-174.3-50-50-131-50-181 0L172 159c-12.6-10.1-31-9.3-42.6 2.4s-12.4 30-2.4 42.6L37.5 293.5c-50 50-50 131 0 181zM400 88a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM304 248a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM120 304a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"],
    "seal": [512, 512, [], "e241", "M2.7 324.2c-10.1 24.5 1.5 52.6 26 62.7l56 23.2c7.8 3.2 14.1 9.5 17.3 17.3l23.2 56c10.1 24.5 38.2 36.1 62.7 26l56-23.2c7.8-3.2 16.7-3.2 24.5 0l56 23.2c24.5 10.1 52.6-1.5 62.7-26l23.2-56c3.2-7.8 9.5-14.1 17.3-17.3l56-23.2c24.5-10.1 36.1-38.2 26-62.7l-23.2-56c-3.2-7.8-3.2-16.6 0-24.5l23.2-56c10.1-24.5-1.5-52.6-26-62.7l-56-23.2c-7.8-3.2-14.1-9.5-17.3-17.3L387 28.6c-10.1-24.5-38.2-36.1-62.7-26l-56 23.2c-7.8 3.2-16.7 3.2-24.5 0l-56-23.2c-24.5-10.1-52.6 1.5-62.7 26l-23.2 56c-3.2 7.8-9.5 14.1-17.3 17.3l-56 23.2c-24.5 10.1-36.1 38.2-26 62.7l23.2 56c3.2 7.8 3.2 16.7 0 24.5l-23.2 56z"],
    "circle-caret-down": [512, 512, ["caret-circle-down"], "f32d", "M256 0a256 256 0 1 0 0 512 256 256 0 1 0 0-512zm0 352c-6.7 0-13-2.8-17.6-7.7l-104-112c-6.5-7-8.2-17.2-4.4-25.9S142.5 192 152 192l208 0c9.5 0 18.2 5.7 22 14.4s2.1 18.9-4.4 25.9l-104 112c-4.5 4.9-10.9 7.7-17.6 7.7z"],
    "mill-sign": [384, 512, [], "e1ed", "M297-22.2c12.3 5 18.2 19 13.2 31.3l-29 71.3C338.8 85.1 384 133.3 384 192l0 208c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-208c0-26.5-21.5-48-48-48-6.4 0-12.5 1.2-18 3.5l-30 73.8 0 178.7c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-21.2-57.8 142.2c-5 12.3-19 18.2-31.3 13.2s-18.2-19-13.2-31.3L160 251.3 160 192c0-26.5-21.5-48-48-48s-48 21.5-48 48l0 208c0 17.7-14.3 32-32 32S0 417.7 0 400L0 112c0-17.7 14.3-32 32-32 10.9 0 20.5 5.4 26.3 13.7 16-8.7 34.3-13.7 53.7-13.7 31.3 0 59.7 12.9 80 33.6 9.6-9.8 20.9-17.8 33.5-23.5L265.8-9c5-12.3 19-18.2 31.3-13.2z"],
    "mug-tea-saucer": [576, 512, [], "e1f5", "M168 32l0 52.4c0 7.5-2.6 14.7-7.4 20.5l-25.2 30.2c-4.8 5.8-7.4 13-7.4 20.5l0 68.4c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-68.4c0-7.5-2.6-14.7-7.4-20.5l-25.2-30.2c-4.8-5.8-7.4-13-7.4-20.5l0-52.4 232 0c70.7 0 128 57.3 128 128S518.7 288 448 288c0 53-43 96-96 96l-192 0c-53 0-96-43-96-96L64 64c0-17.7 14.3-32 32-32l72 0zM448 224c35.3 0 64-28.7 64-64s-28.7-64-64-64l0 128zM32 480c0-17.7 14.3-32 32-32l384 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L64 512c-17.7 0-32-14.3-32-32z"],
    "cart-circle-check": [640, 512, [], "e3f1", "M24-16C10.7-16 0-5.3 0 8S10.7 32 24 32l45.3 0c3.9 0 7.2 2.8 7.9 6.6l52.1 286.3c6.2 34.2 36 59.1 70.8 59.1l104.6 0c1.4-16.7 4.9-32.8 10.3-48l-114.9 0c-11.6 0-21.5-8.3-23.6-19.7L171.3 288 340 288c34.9-48.5 91.7-80 156-80 15.8 0 31.2 1.9 46 5.5L568.9 69.9C572.6 50.2 557.5 32 537.4 32l-412.7 0-.4-2c-4.8-26.6-28-46-55.1-46L24-16zM208 512a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM640 400a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-86.6-60.9c7.1 5.2 8.7 15.2 3.5 22.3l-64 88c-2.8 3.8-7 6.2-11.7 6.5s-9.3-1.3-12.6-4.6l-40-40c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l26.8 26.8 53-72.9c5.2-7.1 15.2-8.7 22.4-3.5z"],
    "album": [448, 512, [128189], "f89f", "M0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM384 256a160 160 0 1 0 -320 0 160 160 0 1 0 320 0zM224 224a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "left-to-line": [512, 512, ["arrow-alt-to-left"], "f34b", "M32 448c-17.7 0-32-14.3-32-32L0 96C0 78.3 14.3 64 32 64S64 78.3 64 96l0 320c0 17.7-14.3 32-32 32zM135 273c-9.4-9.4-9.4-24.6 0-33.9L279 95c6.9-6.9 17.2-8.9 26.2-5.2S320 102.3 320 112l0 80 144 0c26.5 0 48 21.5 48 48l0 32c0 26.5-21.5 48-48 48l-144 0 0 80c0 9.7-5.8 18.5-14.8 22.2s-19.3 1.7-26.2-5.2L135 273z"],
    "person-snowboarding": [576, 512, [127938, "snowboarding"], "f7ce", "M424.5 16a56 56 0 1 1 0 112 56 56 0 1 1 0-112zM166.4 45.5c10.2-14.4 30.2-17.9 44.6-7.7l272 192c14.4 10.2 17.9 30.2 7.7 44.6s-30.2 17.9-44.6 7.7l-92.2-65.1-62.2 53.3 32.1 26.7c18.2 15.2 28.8 37.7 28.8 61.5l0 87.8 77.5 15.2c6.2 1.2 12.6 .9 18.7-.8l41.2-11.8c12.7-3.6 26 3.7 29.7 16.5s-3.7 26-16.5 29.7l-41.2 11.8c-13.4 3.8-27.4 4.4-41.1 1.8L87.1 443.3c-17.2-3.4-33-11.8-45.3-24.1L15.5 393c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l26.2 26.2c5.6 5.6 12.8 9.4 20.6 11l64.2 12.6 0-123.7c0-27.7 12-54 32.8-72.2l69-60.4-88.2-62.3C159.6 80 156.2 60 166.4 45.5zm58.1 375.7l64 12.5 0-75.3c0-4.7-2.1-9.3-5.8-12.3l-58.2-48.5 0 123.6z"],
    "tty": [512, 512, ["teletype"], "f1e4", "M450.2 266.8c15.8 6.5 34.1 .3 42.6-14.6l2.4-4.2c27.9-48.9 23.6-118.8-31.3-154.5-126-82-289.6-82-415.6 0-54.9 35.7-59.3 105.7-31.3 154.5l2.4 4.2c8.5 14.9 26.7 21.1 42.6 14.6l81.9-33.7c13.9-5.7 22.4-19.9 20.9-34.9l-5.1-51c62.5-21 130.8-19.9 192.6 3.3l-4.8 47.7c-1.5 15 7 29.2 20.9 34.9l81.9 33.7zM32 352a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm96 0a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zM64 416a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm352 32a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zM256 320a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm64 32a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm128-32a32 32 0 1 0 0 64 32 32 0 1 0 0-64zM128 448c0 17.7 14.3 32 32 32l192 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-192 0c-17.7 0-32 14.3-32 32z"],
    "slider-circle": [576, 512, [], "e750", "M476 288c-14.2 55.2-64.3 96-124 96-70.7 0-128-57.3-128-128s57.3-128 128-128c59.6 0 109.8 40.8 124 96l68 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-68 0zM32 224l146.9 0c-1.9 10.4-2.9 21.1-2.9 32s1 21.6 2.9 32L32 288c-17.7 0-32-14.3-32-32s14.3-32 32-32z"],
    "users-rectangle": [576, 512, [], "e594", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l448 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm224 72a56 56 0 1 1 0 112 56 56 0 1 1 0-112zm0 152c53 0 96 43 96 96l0 24c0 13.3-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24l0-24c0-53 43-96 96-96zm96-64a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM168 272.3c-15.2 22.8-24 50.2-24 79.7l0 24c0 8.4 1.4 16.5 4.1 24l-46.8 0C89.6 400 80 390.4 80 378.7L80 368c0-50.3 38.7-91.6 88-95.7zM427.9 400c2.7-7.5 4.1-15.6 4.1-24l0-24c0-29.5-8.8-56.9-24-79.7 49.3 4.1 88 45.3 88 95.7l0 10.7c0 11.8-9.6 21.3-21.3 21.3l-46.8 0zM96 192a48 48 0 1 1 96 0 48 48 0 1 1 -96 0z"],
    "mobile": [384, 512, [128241, "mobile-android", "mobile-phone"], "f3ce", "M80 0C44.7 0 16 28.7 16 64l0 384c0 35.3 28.7 64 64 64l224 0c35.3 0 64-28.7 64-64l0-384c0-35.3-28.7-64-64-64L80 0zm72 416l80 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"],
    "arrows-turn-to-dots": [448, 512, [], "e4c1", "M265.4-6.6c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3L285.3 64 352 64c53 0 96 43 96 96l0 32c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-32c0-17.7-14.3-32-32-32l-66.7 0 25.4 25.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0l-80-80c-12.5-12.5-12.5-32.8 0-45.3l80-80zm-82.7 272l80 80c12.5 12.5 12.5 32.8 0 45.3l-80 80c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L162.7 400 96 400c-17.7 0-32 14.3-32 32l0 32c0 17.7-14.3 32-32 32S0 481.7 0 464l0-32c0-53 43-96 96-96l66.7 0-25.4-25.4c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0zM320 368a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zM64 160a64 64 0 1 1 0-128 64 64 0 1 1 0 128z"],
    "exclamation": [128, 512, [10069, 10071, 61738], "21", "M64 432c22.1 0 40 17.9 40 40s-17.9 40-40 40-40-17.9-40-40c0-22.1 17.9-40 40-40zM64 0c26.5 0 48 21.5 48 48 0 .6 0 1.1 0 1.7l-16 304c-.9 17-15 30.3-32 30.3S33 370.7 32 353.7L16 49.7c0-.6 0-1.1 0-1.7 0-26.5 21.5-48 48-48z"],
    "location-xmark": [384, 512, ["map-marker-times", "map-marker-xmark"], "f60e", "M0 188.6C0 84.4 86 0 192 0S384 84.4 384 188.6c0 119.3-120.2 262.3-170.4 316.8-11.8 12.8-31.5 12.8-43.3 0-50.2-54.5-170.4-197.5-170.4-316.8zm259.9-64.5c-9.4-9.4-24.6-9.4-33.9 0l-33.9 33.9-33.9-33.9c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l33.9 33.9-33.9 33.9c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l33.9-33.9 33.9 33.9c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-33.9-33.9 33.9-33.9c9.4-9.4 9.4-24.6 0-33.9z"],
    "church": [512, 512, [9962], "f51d", "M280-8c0-13.3-10.7-24-24-24S232-21.3 232-8l0 24-32 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l32 0 0 48-98.6 65.8C120 186.7 112 201.6 112 217.7l0 38.3-79.8 45.6C12.3 313 0 334.2 0 357.1L0 448c0 35.3 28.7 64 64 64 74.7 0 85.4 0 320 0l64 0c35.3 0 64-28.7 64-64l0-90.9c0-23-12.3-44.2-32.2-55.6L400 256 400 217.7c0-16-8-31-21.4-39.9l-98.6-65.8 0-48 32 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-32 0 0-24zM256 320c35.3 0 64 28.7 64 64l0 80-128 0 0-80c0-35.3 28.7-64 64-64z"],
    "toggle-off": [576, 512, [], "f204", "M384 128c70.7 0 128 57.3 128 128S454.7 384 384 384l-192 0c-70.7 0-128-57.3-128-128s57.3-128 128-128l192 0zM576 256c0-106-86-192-192-192L192 64C86 64 0 150 0 256S86 448 192 448l192 0c106 0 192-86 192-192zM192 336a80 80 0 1 0 0-160 80 80 0 1 0 0 160z"],
    "face-nauseated": [512, 512, [], "e381", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm80-320a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM208 224a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm-23.1-78.1l-64 32c-9.9 4.9-21.9 .9-26.8-8.9s-.9-21.9 8.9-26.8l64-32c9.9-4.9 21.9-.9 26.8 8.9s.9 21.9-8.9 26.8zm133.2-26.8c4.9-9.9 17-13.9 26.8-8.9l64 32c9.9 4.9 13.9 17 8.9 26.8s-17 13.9-26.8 8.9l-64-32c-9.9-4.9-13.9-17-8.9-26.8zM160 288c26.9 0 49.9 16.5 59.3 40l73.3 0c9.5-23.5 32.5-40 59.3-40 4.8 0 9.5 .5 14 1.5-18.3 14.7-30 37.2-30 62.5s11.7 47.8 30 62.5c-4.5 1-9.2 1.5-14 1.5-26.9 0-49.9-16.5-59.3-40l-73.3 0c-9.5 23.5-32.5 40-59.3 40-4.8 0-9.5-.5-14-1.5 18.3-14.7 30-37.2 30-62.5s-11.7-47.8-30-62.5c4.5-1 9.2-1.5 14-1.5z"],
    "deer": [512, 512, [129420], "f78e", "M240 0c8.8 0 16 7.2 16 16l0 24c0 13.3 10.7 24 24 24l16 0c13.3 0 24-10.7 24-24l0-24c0-8.8 7.2-16 16-16s16 7.2 16 16l0 24c0 8.6-1.9 16.7-5.4 24L416 64c13.3 0 24-10.7 24-24l0-24c0-8.8 7.2-16 16-16s16 7.2 16 16l0 24c0 21.7-12.3 40.4-30.3 49.8 .6 .5 1.1 1.1 1.7 1.6l55.3 55.3c8.5 8.5 13.3 20 13.3 32 0 25-20.3 45.3-45.3 45.3l-56.1 0-26.7 80 0 176c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-112-36.3 0c-28.8 0-55.3-9.8-76.3-26.4-2.1 16.9-9.8 32.6-21.9 44.8L142.9 397c-4.6 4.6-6.2 11.5-4 17.7l19.3 54.7c7.3 20.8-8.1 42.6-30.2 42.6l-33.9 0c-13.6 0-25.7-8.6-30.2-21.4l-15.5-44c-11.4-32.4-7.4-67.8 10-96.3 6.6-10.9 6.6-25.4-2.4-34.4-3-3-5.7-6.1-8.1-9.5-1.3 12.9-12.7 22.5-25.7 21.5-13.2-1-23.1-12.6-22.1-25.8L2.4 272c4.2-54.2 49.3-96 103.7-96l85.9 0c.6 0 1.2 0 1.7 0 .8 0 1.7 0 2.5 0l106.1 0 9.6-32-38 0c-9.9 0-18-8-18-18 0-8.2 5.6-15.4 13.6-17.4L320 96 280 96c-30.9 0-56-25.1-56-56l0-24c0-8.8 7.2-16 16-16zM400 160a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"],
    "box-open-full": [640, 512, ["box-full"], "f49c", "M315.8 170.5c2.9-8.3 4.5-17.2 4.5-26.5 0-44.2-35.8-80-80-80-24.5 0-46.5 11-61.2 28.4l-47.1-26.9-9-5.1C149.2 23.8 192 0 240.3 0 274 0 305 11.6 329.5 30.9 340.7 12.4 361.1 0 384.3 0l64 0c35.1 0 63.7 28.3 64 63.4l-3.7 2.1-60.3 34.4 0-35.9-64 0 0 64-.9 0c.3 2.8 .5 5.7 .7 8.6l-63.8 36.5-4.5-2.6zm286.2 72.1c-13.5 9-31.3 6.4-41.8-5.5l0 117.5c0 23-12.4 44.3-32.4 55.7l-176 99.7c-19.6 11.1-43.5 11.1-63.1 0l-176-99.7C92.7 399 80.3 377.8 80.3 354.7l0-53.3-33-17.7c-23.4-12.5-32.2-41.7-19.6-65.1l48.4-89.9c4.1-7.5 11-13.1 19.2-15.5s17.1-1.4 24.5 2.7L320.3 227.4 520.8 116c14.6-8.1 32.9-3.6 42.2 10.2l48 72c9.8 14.7 5.8 34.6-8.9 44.4zM278.8 277.6l-161.7-89.8-25.4 47.2 165.8 88.8 21.3-46.2z"],
    "cherries": [576, 512, [], "e0ec", "M285.6 .1c8.3-.8 16.5 2.7 21.5 9.4L446.8 193.3c5.6-.9 11.3-1.3 17.2-1.3 61.9 0 112 50.1 112 112 0 97.2-86 176-192 176-13.3 0-26.3-1.2-38.8-3.6 52.5-40.5 86.8-101.6 86.8-172.4 0-27.6-7-53.6-19.3-76.3l-120-157.9-62.6 130.3c12.9-5.2 27.1-8.1 41.9-8.1 61.9 0 112 50.1 112 112 0 97.2-86 176-192 176S0 401.2 0 304c0-61.9 50.1-112 112-112 22.2 0 42.9 6.5 60.3 17.6l94.1-196C270 6.1 277.3 1 285.6 .1z"],
    "vacuum-robot": [512, 512, [], "e04e", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm95-351c-52.5-52.5-137.6-52.5-190.1 0-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9c71.2-71.2 186.7-71.2 257.9 0s71.2 186.7 0 257.9c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9c52.5-52.5 52.5-137.6 0-190.1zM191 223c9.4-9.4 24.6-9.4 33.9 0l64 64c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-64-64c-9.4-9.4-9.4-24.6 0-33.9zm-64 64c9.4-9.4 24.6-9.4 33.9 0l64 64c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-64-64c-9.4-9.4-9.4-24.6 0-33.9z"],
    "circle-eurozone": [512, 512, [], "e745", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM136 144l72 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0 0 43.2 40 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-40 0 0 36.8 49.6 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L136 368c-13.3 0-24-10.7-24-24l0-176c0-13.3 10.7-24 24-24zm152 0l88 0c8.3 0 16 4.3 20.4 11.4s4.8 15.9 1 23.4L326.8 320 376 320c13.3 0 24 10.7 24 24s-10.7 24-24 24l-88 0c-8.3 0-16-4.3-20.4-11.4s-4.8-15.9-1-23.4L337.2 192 288 192c-13.3 0-24-10.7-24-24s10.7-24 24-24z"],
    "shoe-prints": [576, 512, [], "f54b", "M296 192c-21.1-12.1-42.3-24.2-72-29.3l0-140.3C257.7 13 311.4 0 352 0 448 0 576 48 576 128s-119.6 96-176 96c-48 0-76-16-104-32zM128 32l48 0 0 128-48 0c-35.3 0-64-28.7-64-64s28.7-64 64-64zM232 320c28-16 56-32 104-32 56.4 0 176 16 176 96S384 512 288 512c-40.5 0-94.3-13-128-22.4l0-140.3c29.7-5.2 50.9-17.3 72-29.4zM64 480c-35.3 0-64-28.7-64-64s28.7-64 64-64l48 0 0 128-48 0z"],
    "squirrel": [512, 512, [], "f71a", "M160 296.2c0 2-.7 3.9-2 5.4-18.7 22.3-30 51-30 82.3 0 70.7 57.3 128 128 128l192 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-16 0c10-13.4 16-30 16-48 0-26.2-12.6-49.4-32-64-13.4-10-30-16-48-16-9.4 0-18.3 1.6-26.7 4.5-8.3 2.9-17.5-1.4-20.4-9.8s1.4-17.5 9.8-20.4c11.7-4.1 24.3-6.4 37.3-6.4 17.2 0 33.5 3.9 48 10.8l0-58.8 21.2 0c26.7 0 51.7-13.4 66.6-35.6L512 192c0-53-43-96-96-96l0-20.8c0-6.2-5-11.2-11.2-11.2-15.2 0-28.7 7.6-36.8 19.2-8.1-11.6-21.6-19.2-36.8-19.2-6.2 0-11.2 5-11.2 11.2L320 96c0 54.4-10.5 108.1-30.7 158-.9-2-1.3-4.2-1.3-6.4L288 144C288 64.5 223.5 0 144 0S0 64.5 0 144 64.5 288 144 288c2.3 0 4.6-.1 6.9-.2 4.9-.2 9.1 3.5 9.1 8.4zM416 144a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"],
    "circle-cedi": [512, 512, [], "e742", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm24-392l0 10.2c24.5 4.6 46.5 16.3 63.9 32.7 9.6 9.1 10.1 24.3 1 33.9s-24.3 10.1-33.9 1c-8.7-8.2-19.2-14.5-30.9-18.2l0 152.7c11.7-3.7 22.2-9.9 30.9-18.2 9.6-9.1 24.8-8.7 33.9 1s8.7 24.8-1 33.9c-17.4 16.4-39.4 28-63.9 32.7l0 10.2c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-10.2C172.8 370.5 128 318.5 128 256s44.8-114.5 104-125.8l0-10.2c0-13.3 10.7-24 24-24s24 10.7 24 24zM176 256c0 35.8 23.5 66.1 56 76.3l0-152.7c-32.5 10.2-56 40.5-56 76.3z"],
    "file-circle-exclamation": [576, 512, [], "e4eb", "M96 0C60.7 0 32 28.7 32 64l0 384c0 35.3 28.7 64 64 64l180 0c-22.7-31.5-36-70.2-36-112 0-100.6 77.4-183.2 176-191.3l0-38.1c0-17-6.7-33.3-18.7-45.3L290.7 18.7C278.7 6.7 262.5 0 245.5 0L96 0zM357.5 176L264 176c-13.3 0-24-10.7-24-24L240 58.5 357.5 176zM432 544a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm0-100a20 20 0 1 1 0 40 20 20 0 1 1 0-40zm0-140c8.8 0 16 7.2 16 16l0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80c0-8.8 7.2-16 16-16z"],
    "wallet": [512, 512, [], "f555", "M64 32C28.7 32 0 60.7 0 96L0 384c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-192c0-35.3-28.7-64-64-64L72 128c-13.3 0-24-10.7-24-24S58.7 80 72 80l384 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L64 32zM416 256a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "square-tugrik": [448, 512, [], "e728", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm48 120c0-13.3 10.7-24 24-24l176 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-64 0 0 39.1 42.9-14.3c8.4-2.8 17.4 1.7 20.2 10.1s-1.7 17.4-10.1 20.2l-53.1 17.7 0 30.3 42.9-14.3c8.4-2.8 17.4 1.7 20.2 10.1s-1.7 17.4-10.1 20.2L248 312.9 248 360c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-31.1-42.9 14.3c-8.4 2.8-17.4-1.7-20.2-10.1s1.7-17.4 10.1-20.2l53.1-17.7 0-30.3-42.9 14.3c-8.4 2.8-17.4-1.7-20.2-10.1s1.7-17.4 10.1-20.2l53.1-17.7 0-55.1-64 0c-13.3 0-24-10.7-24-24z"],
    "message": [512, 512, ["comment-alt"], "f27a", "M0 352L0 128C0 75 43 32 96 32l320 0c53 0 96 43 96 96l0 224c0 53-43 96-96 96l-120 0c-5.2 0-10.2 1.7-14.4 4.8L166.4 539.2c-4.2 3.1-9.2 4.8-14.4 4.8-13.3 0-24-10.7-24-24l0-72-32 0c-53 0-96-43-96-96z"],
    "trophy": [512, 512, [127942], "f091", "M144.3 0l224 0c26.5 0 48.1 21.8 47.1 48.2-.2 5.3-.4 10.6-.7 15.8l49.6 0c26.1 0 49.1 21.6 47.1 49.8-7.5 103.7-60.5 160.7-118 190.5-15.8 8.2-31.9 14.3-47.2 18.8-20.2 28.6-41.2 43.7-57.9 51.8l0 73.1 64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-192 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l64 0 0-73.1c-16-7.7-35.9-22-55.3-48.3-18.4-4.8-38.4-12.1-57.9-23.1-54.1-30.3-102.9-87.4-109.9-189.9-1.9-28.1 21-49.7 47.1-49.7l49.6 0c-.3-5.2-.5-10.4-.7-15.8-1-26.5 20.6-48.2 47.1-48.2zM101.5 112l-52.4 0c6.2 84.7 45.1 127.1 85.2 149.6-14.4-37.3-26.3-86-32.8-149.6zM380 256.8c40.5-23.8 77.1-66.1 83.3-144.8L411 112c-6.2 60.9-17.4 108.2-31 144.8z"],
    "face-dizzy": [512, 512, ["dizzy"], "f567", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM134.1 153.9l25.9 25.9 25.9-25.9c7.8-7.8 20.5-7.8 28.3 0s7.8 20.5 0 28.3l-25.9 25.9 25.9 25.9c7.8 7.8 7.8 20.5 0 28.3s-20.5 7.8-28.3 0l-25.9-25.9-25.9 25.9c-7.8 7.8-20.5 7.8-28.3 0s-7.8-20.5 0-28.3l25.9-25.9-25.9-25.9c-7.8-7.8-7.8-20.5 0-28.3s20.5-7.8 28.3 0zm192 0l25.9 25.9 25.9-25.9c7.8-7.8 20.5-7.8 28.3 0s7.8 20.5 0 28.3l-25.9 25.9 25.9 25.9c7.8 7.8 7.8 20.5 0 28.3s-20.5 7.8-28.3 0l-25.9-25.9-25.9 25.9c-7.8 7.8-20.5 7.8-28.3 0s-7.8-20.5 0-28.3l25.9-25.9-25.9-25.9c-7.8-7.8-7.8-20.5 0-28.3s20.5-7.8 28.3 0zM256 304a64 64 0 1 1 0 128 64 64 0 1 1 0-128z"],
    "bacteria": [640, 512, [], "e059", "M256-32c13.3 0 24 10.7 24 24l0 11c8.6 2.2 16.9 5.6 24.8 10.3L311 7c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-6.3 6.3c4.6 7.8 8 16.2 10.3 24.8l11 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-11 0c-2.2 8.6-5.6 16.9-10.3 24.8L345 151c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-4.1-4.1-30.1 30.1 4.1 4.1c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-4.1-4.1c-10 10-20 20-30.1 30.1L217 279c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-6.3-6.3c-7.8 4.6-16.2 8-24.8 10.3l0 11c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-11c-8.6-2.2-16.9-5.6-24.8-10.3L73 313c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l6.3-6.3c-4.6-7.8-8-16.2-10.3-24.8l-11 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l11 0c2.2-8.6 5.6-16.9 10.3-24.8L39 169c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l4.1 4.1c10-10 20-20 30.1-30.1L103 105c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l4.1 4.1 30.1-30.1-4.1-4.1c-9.4-9.4-9.4-24.6 0-33.9S191.6-2.3 201 7l6.3 6.3c7.8-4.6 16.2-8 24.8-10.3l0-11c0-13.3 10.7-24 24-24zM128 256a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM240 144a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm296 40l0 11c8.6 2.2 16.9 5.6 24.8 10.3L567 199c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-6.3 6.3c4.6 7.8 8 16.2 10.3 24.8l11 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-11 0c-2.2 8.6-5.6 16.9-10.3 24.8L601 343c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-4.1-4.1-30.1 30.1 4.1 4.1c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-4.1-4.1c-10 10-20 20-30.1 30.1L473 471c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-6.3-6.3c-7.8 4.6-16.2 8-24.8 10.3l0 11c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-11c-8.6-2.2-16.9-5.6-24.8-10.3L329 505c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l6.3-6.3c-4.6-7.8-8-16.2-10.3-24.8l-11 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l11 0c2.2-8.6 5.6-16.9 10.3-24.8L295 361c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l4.1 4.1c10-10 20-20 30.1-30.1L359 297c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l4.1 4.1 30.1-30.1-4.1-4.1c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l6.3 6.3c7.8-4.6 16.2-8 24.8-10.3l0-11c0-13.3 10.7-24 24-24s24 10.7 24 24zM448 384a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "toggle-large-on": [576, 512, [], "e5b1", "M192 64C86 64 0 150 0 256S86 448 192 448l192 0c106 0 192-86 192-192S490 64 384 64L192 64zm192 64a128 128 0 1 1 0 256 128 128 0 1 1 0-256z"],
    "ear-deaf": [512, 512, ["deaf", "deafness", "hard-of-hearing"], "f2a4", "M502.6 54.6l-40 40c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l40-40c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3zm-320 320l-128 128c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l128-128c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3zM240 128c-57.6 0-105.1 43.6-111.3 99.5-1.9 17.6-17.8 30.2-35.3 28.3s-30.2-17.8-28.3-35.3c9.7-88 84.3-156.5 174.9-156.5 97.2 0 176 78.8 176 176 0 46-17.7 87.9-46.6 119.3-12 13-17.4 24.8-17.4 34.7l0 6.1c0 61.9-50.1 112-112 112-17.7 0-32-14.3-32-32s14.3-32 32-32c26.5 0 48-21.5 48-48l0-6.1c0-32.9 17.4-59.6 34.4-78 18.4-20 29.6-46.6 29.6-75.9 0-61.9-50.1-112-112-112zm0 80c-17.7 0-32 14.3-32 32 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-44.2 35.8-80 80-80s80 35.8 80 80c0 13.3-10.7 24-24 24s-24-10.7-24-24c0-17.7-14.3-32-32-32z"],
    "people-arrows": [512, 512, ["people-arrows-left-right"], "e068", "M32 64A64 64 0 1 1 160 64 64 64 0 1 1 32 64zM0 224c0-35.3 28.7-64 64-64l64 0c3.2 0 6.4 .2 9.5 .7L93.1 205.1C65 233.2 65 278.8 93.1 306.9l56 56c3.4 3.4 7 6.4 10.9 9l0 92.1c0 26.5-21.5 48-48 48l-32 0c-26.5 0-48-21.5-48-48l0-120.6C12.9 332.4 0 311.7 0 288l0-64zM352 64a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zm66.9 141.1l-44.4-44.4c3.1-.5 6.3-.7 9.5-.7l64 0c35.3 0 64 28.7 64 64l0 64c0 23.7-12.9 44.4-32 55.4L480 464c0 26.5-21.5 48-48 48l-32 0c-26.5 0-48-21.5-48-48l0-92.1c3.9-2.6 7.5-5.6 10.9-9l56-56c28.1-28.1 28.1-73.7 0-101.8zM302.8 177.8c9-3.7 19.3-1.7 26.2 5.2l56 56c9.4 9.4 9.4 24.6 0 33.9l-56 56c-6.9 6.9-17.2 8.9-26.2 5.2S288 321.7 288 312l0-24-64 0 0 24c0 9.7-5.8 18.5-14.8 22.2s-19.3 1.7-26.2-5.2l-56-56c-9.4-9.4-9.4-24.6 0-33.9l56-56c6.9-6.9 17.2-8.9 26.2-5.2S224 190.3 224 200l0 24 64 0 0-24c0-9.7 5.8-18.5 14.8-22.2z"],
    "treasure-chest": [512, 512, [], "f723", "M80 41.3l0 206.7-80 0 0-88C0 106.3 33.1 60.3 80 41.3zM0 296l80 0 0 184-16 0c-35.3 0-64-28.7-64-64L0 296zM128 480l0-184 96 0 0 24c0 17.7 14.3 32 32 32s32-14.3 32-32l0-24 96 0 0 184-256 0zm304 0l0-184 80 0 0 120c0 35.3-28.7 64-64 64l-16 0zm80-232l-80 0 0-206.7c46.9 19 80 65 80 118.7l0 88zM384 32l0 216-96 0 0-24c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 24-96 0 0-216 256 0z"],
    "caret-large-right": [256, 512, [], "e82e", "M247.1 233.4c12.5 12.5 12.5 32.8 0 45.2l-160 160c-9.2 9.2-22.9 11.9-34.9 6.9S32.5 428.9 32.5 416l0-320c0-12.9 7.8-24.6 19.8-29.6S78 64.2 87.1 73.4l160 160z"],
    "hands-clapping": [512, 512, [], "e1a8", "M344 8l0 64c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-64c0-13.3 10.7-24 24-24S344-5.3 344 8zM220 10.7l32 48c7.4 11 4.4 25.9-6.7 33.3s-25.9 4.4-33.3-6.7l-32-48c-7.4-11-4.4-25.9 6.7-33.3S212.6-.3 220 10.7zM135 119c9.4-9.4 24.6-9.4 33.9 0L292.7 242.7c10.1 10.1 27.3 2.9 27.3-11.3l0-39.4c0-17.7 14.3-32 32-32s32 14.3 32 32l0 153.6c0 57.1-30 110-78.9 139.4-64 38.4-145.8 28.3-198.5-24.4L7 361c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l53 53c6.1 6.1 16 6.1 22.1 0s6.1-16 0-22.1L23 265c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l93 93c6.1 6.1 16 6.1 22.1 0s6.1-16 0-22.1L55 185c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l117 117c6.1 6.1 16 6.1 22.1 0s6.1-16 0-22.1l-93-93c-9.4-9.4-9.4-24.6 0-33.9zM433.1 484.9c-24.2 14.5-50.9 22.1-77.7 23.1 48.1-39.6 76.6-99 76.6-162.4l0-98.1c8.2-.1 16-6.4 16-16l0-39.4c0-17.7 14.3-32 32-32s32 14.3 32 32l0 153.6c0 57.1-30 110-78.9 139.4zM453.3 4c11 7.4 14 22.3 6.7 33.3l-32 48c-7.4 11-22.3 14-33.3 6.7s-14-22.3-6.7-33.3l32-48c7.4-11 22.3-14 33.3-6.7z"],
    "circle-ampersand": [512, 512, [], "e0f8", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM216 191.6c0 4.1 1.6 8.1 4.6 11l14.5 14.5 23.6-17.3c3.4-2.5 5.4-6.4 5.4-10.6 0-7.3-5.9-13.2-13.2-13.2l-19.2 0c-8.6 0-15.6 7-15.6 15.6zm71 46.9l-17.6 12.9 28.7 28.7 26.2-37.8c7.5-10.9 22.5-13.6 33.4-6.1s13.6 22.5 6.1 33.4l-31.1 45 28.4 28.4c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-22.4-22.4c-15.1 18.5-37.8 29.4-62 29.4l-32.2 0c-36.7 0-66.5-29.8-66.5-66.5 0-21.2 10.1-41.1 27.2-53.6l24.7-18.1-9.2-9.2c-11.9-11.9-18.6-28.1-18.6-45 0-35.1 28.5-63.6 63.6-63.6l19.2 0c33.8 0 61.2 27.4 61.2 61.2 0 19.5-9.3 37.8-25 49.3zm-87.5 64.1c-4.7 3.5-7.5 9-7.5 14.9 0 10.2 8.3 18.5 18.5 18.5l32.2 0c10.5 0 20.3-5.2 26.3-13.8l1.4-2-40.1-40.1-30.7 22.5z"],
    "virus-covid-slash": [576, 512, [], "e4a9", "M41-24.9c-9.4-9.4-24.6-9.4-33.9 0S-2.3-.3 7 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-83-83 11.4-11.4c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-11.3 11.3-23.8-23.8c17.9-23.5 29.9-51.7 34.1-82.3l33.6 0 0 16c0 13.3 10.7 24 24 24s24-10.7 24-24l0-80c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 16-33.6 0c-4.2-30.7-16.3-58.8-34.1-82.3l23.8-23.8 11.3 11.3c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9L440.7 46.7c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l11.3 11.3-23.8 23.8C370.8 97.9 342.7 85.8 312 81.6l0-33.6 16 0c13.3 0 24-10.7 24-24S341.3 0 328 0L248 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l16 0 0 33.6c-30.7 4.2-58.8 16.3-82.3 34.1L157.9 92 169.2 80.6c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0L123.9 58.1 41-24.9zM113.6 232l-33.6 0 0-16c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 80c0 13.3 10.7 24 24 24s24-10.7 24-24l0-16 33.6 0c4.2 30.7 16.3 58.8 34.1 82.3l-23.8 23.8-11.3-11.3c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l56.6 56.6c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-11.3-11.3 23.8-23.8c23.5 17.9 51.7 29.9 82.3 34.1l0 33.6-16 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l80 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-16 0 0-33.6c13.4-1.8 26.4-5.2 38.7-9.9L123.5 193.3c-4.7 12.3-8 25.2-9.9 38.7z"],
    "chart-simple-horizontal": [448, 512, [], "e474", "M384 48l0 32c0 26.5-21.5 48-48 48L48 128C21.5 128 0 106.5 0 80L0 48C0 21.5 21.5 0 48 0L336 0c26.5 0 48 21.5 48 48zm16 144c26.5 0 48 21.5 48 48l0 32c0 26.5-21.5 48-48 48L48 320c-26.5 0-48-21.5-48-48l0-32c0-26.5 21.5-48 48-48l352 0zM208 384c26.5 0 48 21.5 48 48l0 32c0 26.5-21.5 48-48 48L48 512c-26.5 0-48-21.5-48-48l0-32c0-26.5 21.5-48 48-48l160 0z"],
    "down-from-dotted-line": [384, 512, [], "e407", "M209 505c-9.4 9.4-24.6 9.4-33.9 0L31 361c-6.9-6.9-8.9-17.2-5.2-26.2S38.3 320 48 320l80 0 0-144c0-26.5 21.5-48 48-48l32 0c26.5 0 48 21.5 48 48l0 144 80 0c9.7 0 18.5 5.8 22.2 14.8s1.7 19.3-5.2 26.2L209 505zM64 32A32 32 0 1 1 0 32 32 32 0 1 1 64 32zM138.7 0a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM277.3 32a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM352 0a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "calendar-days": [448, 512, ["calendar-alt"], "f073", "M128 0c17.7 0 32 14.3 32 32l0 32 128 0 0-32c0-17.7 14.3-32 32-32s32 14.3 32 32l0 32 32 0c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 128C0 92.7 28.7 64 64 64l32 0 0-32c0-17.7 14.3-32 32-32zM64 240l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm128 0l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm144-16c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0zM64 368l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm144-16c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0zm112 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16z"],
    "lighthouse": [576, 512, [], "e612", "M271.9 4.4c10-5.8 22.3-5.8 32.2 0l96 56c15.3 8.9 20.4 28.5 11.5 43.8-5.9 10.2-16.6 15.9-27.6 15.9l0 40c17.7 0 32 14.3 32 32 0 13.3-8.1 24.7-19.7 29.5l45.3 226.5 6.4 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-320 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l6.4 0 45.3-226.5c-11.6-4.8-19.7-16.2-19.7-29.5 0-17.7 14.3-32 32-32l0 0 0-40c-11 0-21.7-5.7-27.6-15.9-8.9-15.3-3.7-34.9 11.5-43.8l96-56zM320 87.7l-32-18.7-32 18.7 0 72.3 64 0 0-72.3zM42.7 10.5l64 32c11.9 5.9 16.7 20.3 10.7 32.2S97.1 91.4 85.3 85.5l-64-32C9.4 47.5 4.6 33.1 10.5 21.3S30.9 4.6 42.7 10.5zm64 202.9l-64 32c-11.9 5.9-26.3 1.1-32.2-10.7s-1.1-26.3 10.7-32.2l64-32c11.9-5.9 26.3-1.1 32.2 10.7s1.1 26.3-10.7 32.2zM565.5 21.3c5.9 11.9 1.1 26.3-10.7 32.2l-64 32c-11.9 5.9-26.3 1.1-32.2-10.7s-1.1-26.3 10.7-32.2l64-32c11.9-5.9 26.3-1.1 32.2 10.7zm-106.9 160c5.9-11.9 20.3-16.7 32.2-10.7l64 32c11.9 5.9 16.7 20.3 10.7 32.2s-20.3 16.7-32.2 10.7l-64-32c-11.9-5.9-16.7-20.3-10.7-32.2zM288 368c-17.7 0-32 14.3-32 32l0 64 64 0 0-64c0-17.7-14.3-32-32-32z"],
    "diamond-turn-right": [512, 512, ["directions"], "f5eb", "M215 17L17 215C6.1 225.9 0 240.6 0 256s6.1 30.1 17 41L215 495c10.9 10.9 25.6 17 41 17s30.1-6.1 41-17L495 297c10.9-10.9 17-25.6 17-41s-6.1-30.1-17-41L297 17C286.1 6.1 271.4 0 256 0s-30.1 6.1-41 17zM385 257l-72 72c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l31-31-78.1 0c-13.3 0-24 10.7-24 24l0 40c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-40c0-39.8 32.2-72 72-72l78.1 0-31-31c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l72 72c9.4 9.4 9.4 24.6 0 33.9z"],
    "drone": [512, 512, [], "f85f", "M417.7 338.5c26.8 7.7 46.3 32.3 46.3 61.5 0 35.3-28.7 64-64 64-29.2 0-53.9-19.6-61.5-46.3L317 396.2c-9.3 2.5-19 3.8-29 3.8 0 61.9 50.1 112 112 112s112-50.1 112-112-50.1-112-112-112c0 10-1.3 19.8-3.8 29l21.5 21.5zM112 0C50.1 0 0 50.1 0 112S50.1 224 112 224c0-10 1.3-19.8 3.8-29L94.3 173.5c-26.8-7.7-46.3-32.3-46.3-61.5 0-35.3 28.7-64 64-64 29.2 0 53.9 19.6 61.5 46.3L195 115.8c9.3-2.5 19-3.8 29-3.8 0-61.9-50.1-112-112-112zM0 400c0 61.9 50.1 112 112 112s112-50.1 112-112c-10 0-19.8-1.3-29-3.8l-21.5 21.5c-7.7 26.8-32.3 46.3-61.5 46.3-35.3 0-64-28.7-64-64 0-29.2 19.6-53.9 46.3-61.5L115.8 317c-2.5-9.3-3.8-19-3.8-29-61.9 0-112 50.1-112 112zM317 115.8l21.5-21.5c7.7-26.8 32.3-46.3 61.5-46.3 35.3 0 64 28.7 64 64 0 29.2-19.6 53.9-46.3 61.5L396.2 195c2.5 9.3 3.8 19 3.8 29 61.9 0 112-50.1 112-112S461.9 0 400 0 288 50.1 288 112c10 0 19.8 1.3 29 3.8zM224 160c-8.9 0-17.3 1.8-25 5.1L129 95c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l70 70c-3.3 7.7-5.1 16.1-5.1 25l0 64c0 8.9 1.8 17.3 5.1 25L95 383c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l70-70c7.7 3.3 16.1 5.1 25 5.1l64 0c8.9 0 17.3-1.8 25-5.1l70 70c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-70-70c3.3-7.7 5.1-16.1 5.1-25l0-64c0-8.9-1.8-17.3-5.1-25l70-70c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-70 70c-7.7-3.3-16.1-5.1-25-5.1l-64 0z"],
    "text": [384, 512, [], "f893", "M64 96l0 32c0 17.7-14.3 32-32 32S0 145.7 0 128L0 72C0 49.9 17.9 32 40 32l304 0c22.1 0 40 17.9 40 40l0 56c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-32-96 0 0 320 48 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-160 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l48 0 0-320-96 0z"],
    "square-guarani": [448, 512, [], "e70e", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm144 96c0-8.8 7.2-16 16-16s16 7.2 16 16l0 9.1c26.3 3.5 50 15.6 68 33.2 9.5 9.3 9.6 24.5 .3 33.9s-24.5 9.6-33.9 .3c-9.4-9.2-21.2-15.8-34.4-18.8l0 46.2 80 0c13.3 0 24 10.7 24 24 0 60.8-45.3 111.1-104 118.9l0 9.1c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-9.1c-58.7-7.8-104-58.1-104-118.9s45.3-111.1 104-118.9l0-9.1zM152 256c0 34.3 23.9 62.9 56 70.2l0-140.4c-32.1 7.3-56 36-56 70.2zm139.9 24l-51.9 0 0 46.2c24.2-5.5 43.8-23.2 51.9-46.2z"],
    "toilet-paper-under-slash": [576, 512, ["toilet-paper-reverse-slash"], "e2a1", "M7-24.9c9.4-9.4 24.6-9.4 33.9 0l63 63c7.7-4 15.8-6.1 24.1-6.1l231.1 0c-8.8 11.1-16 23.1-21.9 34.8-21.4 42.7-33.2 98.4-33.2 157.2 0 4.8 .1 9.6 .2 14.4l54 54c-4.1-21.3-6.3-44.3-6.3-68.4 0-106 43-192 96-192s96 86 96 192l0 254.2 25 25c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0L7 9.1C-2.3-.3-2.3-15.5 7-24.9zM474.2 544L216 544c-30.9 0-56-25.1-56-56l0-24 234.2 0 80 80zM48 117.8L346.2 416 128 416c-53 0-96-86-96-192 0-39.3 5.9-75.8 16-106.2zM416 224c0 35.3 14.3 64 32 64s32-28.7 32-64-14.3-64-32-64-32 28.7-32 64z"],
    "hand-point-up": [384, 512, [9757], "f0a6", "M32 32C32 14.3 46.3 0 64 0S96 14.3 96 32l0 208-64 0 0-208zM224 192c0-17.7 14.3-32 32-32s32 14.3 32 32l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64zm-64-64c17.7 0 32 14.3 32 32l0 48c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-48c0-17.7 14.3-32 32-32zm160 96c0-17.7 14.3-32 32-32s32 14.3 32 32l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64zm-96 88l0-.6c9.4 5.4 20.3 8.6 32 8.6 13.2 0 25.4-4 35.6-10.8 8.7 24.9 32.5 42.8 60.4 42.8 11.7 0 22.6-3.1 32-8.6l0 8.6c0 88.4-71.6 160-160 160l-61.7 0c-42.4 0-83.1-16.9-113.1-46.9L37.5 453.5C13.5 429.5 0 396.9 0 363l0-27c0-35.3 28.7-64 64-64l88 0c22.1 0 40 17.9 40 40s-17.9 40-40 40l-56 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l56 0c39.8 0 72-32.2 72-72z"],
    "pen-slash": [576, 512, [], "e213", "M41-24.9c-9.4-9.4-24.6-9.4-33.9 0S-2.3-.3 7 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9L373.9 308 444 237.9 306.1 100 236 170.1 41-24.9zM168.1 237.9L90.9 315.1c-10.7 10.7-18.5 24.1-22.6 38.7L32.9 481.6c-2.3 8.3 0 17.3 6.2 23.4s15.1 8.5 23.4 6.2l127.8-35.5c14.6-4.1 27.9-11.8 38.7-22.6l77.2-77.2-137.9-137.9zM384.9 21.2L340 66.1 477.9 204 522.8 159.1C536.4 145.6 544 127.2 544 108s-7.6-37.6-21.2-51.1L487.1 21.2C473.6 7.6 455.2 0 436 0s-37.6 7.6-51.1 21.2z"],
    "comment-plus": [512, 512, [], "f4b2", "M256 480c141.4 0 256-107.5 256-240S397.4 0 256 0 0 107.5 0 240c0 54.3 19.2 104.3 51.6 144.5L2.8 476.8c-4.8 9-3.3 20 3.6 27.5s17.8 9.8 27.1 5.8l118.4-50.7C183.7 472.6 218.9 480 256 480zm0-336c13.3 0 24 10.7 24 24l0 48 48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0 0 48c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-48-48 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l48 0 0-48c0-13.3 10.7-24 24-24z"],
    "bezier-curve": [640, 512, [], "f55b", "M296 136l0-48 48 0 0 48-48 0zM288 32c-26.5 0-48 21.5-48 48l0 4-118.4 0C111.2 62.7 89.3 48 64 48 28.7 48 0 76.7 0 112s28.7 64 64 64c25.3 0 47.2-14.7 57.6-36l66.9 0c-58.9 39.6-98.9 105-104 180L80 320c-26.5 0-48 21.5-48 48l0 64c0 26.5 21.5 48 48 48l64 0c26.5 0 48-21.5 48-48l0-64c0-26.5-21.5-48-48-48l-3.3 0c5.9-67 48.5-123.4 107.5-149.1 8.6 12.7 23.2 21.1 39.8 21.1l64 0c16.6 0 31.1-8.4 39.8-21.1 59 25.7 101.6 82.1 107.5 149.1l-3.3 0c-26.5 0-48 21.5-48 48l0 64c0 26.5 21.5 48 48 48l64 0c26.5 0 48-21.5 48-48l0-64c0-26.5-21.5-48-48-48l-4.5 0c-5-75-45.1-140.4-104-180l66.9 0c10.4 21.3 32.3 36 57.6 36 35.3 0 64-28.7 64-64s-28.7-64-64-64c-25.3 0-47.2 14.7-57.6 36l-118.4 0 0-4c0-26.5-21.5-48-48-48l-64 0zM88 376l48 0 0 48-48 0 0-48zm416 48l0-48 48 0 0 48-48 0z"],
    "clipboard-list-check": [384, 512, [], "f737", "M311.4 32l8.6 0c35.3 0 64 28.7 64 64l0 352c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l8.6 0C83.6 12.9 104.3 0 128 0L256 0c23.7 0 44.4 12.9 55.4 32zM248 112c13.3 0 24-10.7 24-24s-10.7-24-24-24L136 64c-13.3 0-24 10.7-24 24s10.7 24 24 24l112 0zm-92.8 81.1c-8.2-6.7-20.3-5.4-27 2.8l-30.3 37.5-10-12.5c-6.6-8.3-18.7-9.6-27-3s-9.6 18.7-3 27L82.8 276c3.6 4.5 9.1 7.2 14.9 7.2s11.3-2.6 15-7.1l45.3-56c6.7-8.2 5.4-20.3-2.8-27zM176 256c0 13.3 10.7 24 24 24l96 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-96 0c-13.3 0-24 10.7-24 24zm0 128c0 13.3 10.7 24 24 24l96 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-96 0c-13.3 0-24 10.7-24 24zM96 416a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "lamp-desk": [512, 512, [], "e014", "M217.4 121.4L208 112c-26.5-26.5-26.5-69.5 0-96s69.5-26.5 96 0l48 48 128 0c17.7 0 32 14.3 32 32l0 2.7c0 8.5-3.4 16.6-9.4 22.6L313.4 310.6c-6 6-14.1 9.4-22.6 9.4l-2.7 0c-17.7 0-32-14.3-32-32l0-114.7-92.1 92.1 52.2 182.7 135.9 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-159.3 0c-.5 0-1 0-1.4 0L32 512c-17.7 0-32-14.3-32-32s14.3-32 32-32l117.6 0-52.3-183.2c-3.2-11.2-.1-23.2 8.1-31.4l112-112z"],
    "person-half-dress": [384, 512, [], "e548", "M143.4-3.9c9.7-16.8 27.8-28.1 48.6-28.1 30.9 0 56 25.1 56 56 0 25.4-16.9 46.8-40 53.7l0 0c-5.1 1.5-10.4 2.3-16 2.3-30.9 0-56-25.1-56-56l0 0c0-10.1 2.7-19.7 7.4-27.9zM318.3 299.1L272 236.7 272 512c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-160 0-.4 0-238.6c36.2 4.4 69.2 23.4 91.2 53l70.5 95c10.5 14.2 7.6 34.2-6.6 44.8s-34.2 7.6-44.8-6.6zM176 113l0 399c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-128-25.8 0c-10.9 0-18.6-10.7-15.2-21.1l43-129-48.3 65.1c-10.5 14.2-30.6 17.2-44.8 6.6s-17.2-30.6-6.6-44.8l70.5-95c22-29.6 55.1-48.6 91.2-53z"],
    "peanut": [512, 512, [], "e430", "M0 432l0-69.1C0 315.5 21.1 270.4 57.6 240l5.1-4.2c21.8-18.2 48.1-30.2 76.1-34.9l19.4-3.2c20.2-3.4 36.1-19.2 39.5-39.5l1.1-6.5c6-36.2 23.2-69.6 49.2-95.5l4.6-4.6C285.5 18.5 330.2 0 376.9 0L432 0c44.2 0 80 35.8 80 80l0 55.1c0 46.7-18.5 91.4-51.5 124.5l-4.6 4.6c-25.9 25.9-59.3 43.1-95.5 49.2l-6.5 1.1c-20.2 3.4-36.1 19.2-39.5 39.5l-1.9 11.6c-5.5 32.9-21.1 63.3-44.7 86.8l-12.9 12.9c-30 30-70.7 46.9-113.1 46.9L80 512c-44.2 0-80-35.8-80-80zM435.2 128a19.2 19.2 0 1 0 -38.4 0 19.2 19.2 0 1 0 38.4 0zm0 64a19.2 19.2 0 1 0 -38.4 0 19.2 19.2 0 1 0 38.4 0zm-64 0a19.2 19.2 0 1 0 -38.4 0 19.2 19.2 0 1 0 38.4 0zm-224 224a19.2 19.2 0 1 0 -38.4 0 19.2 19.2 0 1 0 38.4 0zM192 435.2a19.2 19.2 0 1 0 0-38.4 19.2 19.2 0 1 0 0 38.4zm0-64a19.2 19.2 0 1 0 0-38.4 19.2 19.2 0 1 0 0 38.4z"],
    "message-plus": [512, 512, ["comment-alt-plus"], "f4a8", "M0 128L0 352c0 53 43 96 96 96l32 0 0 72c0 13.3 10.7 24 24 24 5.2 0 10.2-1.7 14.4-4.8l115.2-86.4c4.2-3.1 9.2-4.8 14.4-4.8l120 0c53 0 96-43 96-96l0-224c0-53-43-96-96-96L96 32C43 32 0 75 0 128zm256 16c13.3 0 24 10.7 24 24l0 48 48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0 0 48c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-48-48 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l48 0 0-48c0-13.3 10.7-24 24-24z"],
    "bracket-curly": [256, 512, ["bracket-curly-left"], "7b", "M64 128c0-53 43-96 96-96l32 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32 0c-17.7 0-32 14.3-32 32l0 37.5c0 25.5-10.1 49.9-28.1 67.9L77.3 256 99.9 278.6c18 18 28.1 42.4 28.1 67.9l0 37.5c0 17.7 14.3 32 32 32l32 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32 0c-53 0-96-43-96-96l0-37.5c0-8.5-3.4-16.6-9.4-22.6L9.4 278.6c-12.5-12.5-12.5-32.8 0-45.3l45.3-45.3c6-6 9.4-14.1 9.4-22.6L64 128z"],
    "square-poll-horizontal": [448, 512, ["poll-h"], "f682", "M448 96c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320zM256 152c0 13.3-10.7 24-24 24l-112 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l112 0c13.3 0 24 10.7 24 24zm72 80c13.3 0 24 10.7 24 24s-10.7 24-24 24l-208 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l208 0zM192 360c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l48 0c13.3 0 24 10.7 24 24z"],
    "nfc-signal": [576, 512, [], "e1fb", "M32 96c0-35.3 28.7-64 64-64l320 0c35.3 0 64 28.7 64 64l0 153c-22.6 5.9-44 14.6-64 25.6L416 136c0-22.1-17.9-40-40-40L272 96c-22.1 0-40 17.9-40 40l0 78.4c-14.3 8.3-24 23.8-24 41.6 0 26.5 21.5 48 48 48s48-21.5 48-48c0-17.8-9.7-33.3-24-41.6l0-70.4 88 0 0 164.2c-20 17.3-37.4 37.5-51.8 59.8l-172.2 0 0-224 24 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-32 0c-22.1 0-40 17.9-40 40l0 240c0 22.1 17.9 40 40 40l155.5 0c-8 20.3-13.8 41.7-16.9 64L96 480c-35.3 0-64-28.7-64-64L32 96zM552 288c13.3 0 24 10.7 24 24s-10.7 24-24 24c-101.6 0-184 82.4-184 184 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-128.1 103.9-232 232-232zm-8 192a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm32-72c0 13.3-10.7 24-24 24-48.6 0-88 39.4-88 88 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-75.1 60.9-136 136-136 13.3 0 24 10.7 24 24z"],
    "box-isometric": [512, 512, [], "e797", "M256 240l55.4-29.8-154.6-88.4-58.6 33.2 157.8 85zm105.2-56.7L413.8 155 256 65.6 205.3 94.3 361.2 183.3zm102.3 235l-176 99.7c-19.6 11.1-43.5 11.1-63.1 0l-176-99.7C28.4 407 16 385.8 16 362.7l0-197.4c0-23 12.4-44.3 32.4-55.7l176-99.7C244-1.2 268-1.2 287.6 9.9l176 99.7C483.6 121 496 142.2 496 165.3l0 197.4c0 23-12.4 44.3-32.4 55.7z"],
    "school-circle-xmark": [640, 512, [], "e56d", "M64 128c-35.3 0-64 28.7-64 64L0 448c0 35.3 28.7 64 64 64l276 0c-10.5-14.6-19-30.7-25.1-48l-90.9 0 0-88c0-22.1 17.9-40 40-40l48 0c1 0 1.9 0 2.9 .1 26.3-74.6 97.5-128.1 181.1-128.1 28.6 0 55.6 6.2 80 17.4l0-33.4c0-35.3-28.7-64-64-64l-64 0-127.9-115.1c-18.3-16.4-46-16.4-64.2 0L128 128 64 128zm64 240c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32zM112 256l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16zM288 128a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM496 544a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm59.3-180.7l-36.7 36.7 36.7 36.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-36.7-36.7-36.7 36.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l36.7-36.7-36.7-36.7c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l36.7 36.7 36.7-36.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6z"],
    "person-seat-window": [512, 512, [], "e788", "M176 16a56 56 0 1 1 0 112 56 56 0 1 1 0-112zm56 212l0 92 40 0c44.2 0 80 35.8 80 80l0 48 16 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-48 0c-17.7 0-32-14.3-32-32l0-80c0-8.8-7.2-16-16-16l-80 0c-35.3 0-64-28.7-64-64l0-92c0-28.7 23.3-52 52-52s52 23.3 52 52zM48 160c17.7 0 32 14.3 32 32l0 176c0 35.3 28.7 64 64 64l64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-64 0C73.3 496 16 438.7 16 368l0-176c0-17.7 14.3-32 32-32zM384 32l32 0c35.3 0 64 28.7 64 64l0 96c0 35.3-28.7 64-64 64l-32 0c-35.3 0-64-28.7-64-64l0-96c0-35.3 28.7-64 64-64z"],
    "grapes": [576, 512, [], "e306", "M389.1-4.7c6.2-6.2 16.4-6.2 22.6 0L423.8 7.4c31.2 31.2 31.2 81.9 0 113.1 31.2-31.2 81.9-31.2 113.1 0l12.1 12.1c6.2 6.2 6.2 16.4 0 22.6l-12.1 12.1c-31.2 31.2-81.9 31.2-113.1 0-15.6-15.6-31.2-31.2-46.9-46.9-31.2-31.2-31.2-81.9 0-113.1L389.1-4.7zM224.4 152a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm-80-32a56 56 0 1 1 0 112 56 56 0 1 1 0-112zm-80 192a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm-32 144a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm144-32a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm192-80a56 56 0 1 1 0 112 56 56 0 1 1 0-112zm-168-56a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm192-80a56 56 0 1 1 0 112 56 56 0 1 1 0-112z"],
    "hand-lizard": [512, 512, [], "f258", "M0 112C0 85.5 21.5 64 48 64l238.5 0c36.8 0 71.2 18 92.1 48.2l113.5 164c13 18.7 19.9 41 19.9 63.8l0 76c0 17.7-14.3 32-32 32l-96 0c-17.7 0-32-14.3-32-32l0-13.8-78.1-50.2-161.9 0c-26.5 0-48-21.5-48-48s21.5-48 48-48l128 0c26.5 0 48-21.5 48-48s-21.5-48-48-48L48 160c-26.5 0-48-21.5-48-48z"],
    "camera-slash": [576, 512, [], "e0d9", "M41-24.9c-9.4-9.4-24.6-9.4-33.9 0S-2.3-.3 7 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-42.8-42.8c11-11.5 17.8-27.1 17.8-44.3l0-256c0-35.3-28.7-64-64-64l-74.7 0-10.4-31.2C388.4 45.2 370.1 32 349.4 32L226.6 32c-20.7 0-39 13.2-45.5 32.8L170.7 96 161.8 96 41-24.9zM261.5 195.7c8.4-2.4 17.3-3.7 26.5-3.7 53 0 96 43 96 96 0 9.2-1.3 18.1-3.7 26.5L261.5 195.7zM192 288c0-8 1-15.9 2.9-23.3L47.9 117.7C38 129 32 143.8 32 160l0 256c0 35.3 28.7 64 64 64l314.2 0-98.9-98.9c-7.5 1.9-15.3 2.9-23.3 2.9-53 0-96-43-96-96z"],
    "chalkboard": [576, 512, ["blackboard"], "f51b", "M96 64c-35.3 0-64 28.7-64 64l0 256c-17.7 0-32 14.3-32 32s14.3 32 32 32l512 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l0-256c0-35.3-28.7-64-64-64L96 64zM480 384l-64 0 0-32c0-17.7-14.3-32-32-32l-96 0c-17.7 0-32 14.3-32 32l0 32-160 0 0-256 384 0 0 256z"],
    "memo-pad": [384, 512, [], "e1da", "M64 0C28.7 0 0 28.7 0 64l0 32 384 0 0-32c0-35.3-28.7-64-64-64L64 0zM384 144L0 144 0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-304zM104 192l176 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-176 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zm0 96l176 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-176 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zm0 96l96 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-96 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"],
    "bluetooth": [320, 512, [], "f293", "M146.8 2.9c11.4-5.2 24.8-3.2 34.3 5.1l128 112C316 126 320 134.8 320 144s-4 18-10.9 24.1L208.6 256 309.1 343.9C316 350 320 358.8 320 368s-4 18-10.9 24.1l-128 112c-9.4 8.3-22.9 10.2-34.3 5.1S128 492.6 128 480l0-153.5-74.9 65.6c-13.3 11.6-33.5 10.3-45.2-3s-10.3-33.5 3-45.2L111.4 256 10.9 168.1c-13.3-11.6-14.6-31.9-3-45.2s31.9-14.6 45.2-3L128 185.5 128 32c0-12.6 7.3-24 18.8-29.1zM192 326.5l0 83 47.4-41.5-47.4-41.5zm0-141l47.4-41.5-47.4-41.5 0 83z"],
    "objects-align-center-horizontal": [448, 512, [], "e3bc", "M256 0c0-17.7-14.3-32-32-32S192-17.7 192 0l0 64-144 0C21.5 64 0 85.5 0 112l0 64c0 26.5 21.5 48 48 48l144 0 0 64-80 0c-26.5 0-48 21.5-48 48l0 64c0 26.5 21.5 48 48 48l80 0 0 64c0 17.7 14.3 32 32 32s32-14.3 32-32l0-64 80 0c26.5 0 48-21.5 48-48l0-64c0-26.5-21.5-48-48-48l-80 0 0-64 144 0c26.5 0 48-21.5 48-48l0-64c0-26.5-21.5-48-48-48l-144 0 0-64z"],
    "distribute-spacing-vertical": [512, 512, [], "e366", "M0 64C0 46.3 14.3 32 32 32l448 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 96C14.3 96 0 81.7 0 64zM96 208c0-26.5 21.5-48 48-48l224 0c26.5 0 48 21.5 48 48l0 96c0 26.5-21.5 48-48 48l-224 0c-26.5 0-48-21.5-48-48l0-96zM32 416l448 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 480c-17.7 0-32-14.3-32-32s14.3-32 32-32z"],
    "up-right-from-square": [512, 512, ["external-link-alt"], "f35d", "M290.4 19.8C295.4 7.8 307.1 0 320 0L480 0c17.7 0 32 14.3 32 32l0 160c0 12.9-7.8 24.6-19.8 29.6s-25.7 2.2-34.9-6.9L400 157.3 246.6 310.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L354.7 112 297.4 54.6c-9.2-9.2-11.9-22.9-6.9-34.9zM0 176c0-44.2 35.8-80 80-80l80 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-80 0c-8.8 0-16 7.2-16 16l0 256c0 8.8 7.2 16 16 16l256 0c8.8 0 16-7.2 16-16l0-80c0-17.7 14.3-32 32-32s32 14.3 32 32l0 80c0 44.2-35.8 80-80 80L80 512c-44.2 0-80-35.8-80-80L0 176z"],
    "square-turkish-lira": [448, 512, [], "e71f", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm120 96c13.3 0 24 10.7 24 24l0 44.5 58.9-19.6c8.4-2.8 17.4 1.7 20.2 10.1s-1.7 17.4-10.1 20.2l-69.1 23 0 30.3 58.9-19.6c8.4-2.8 17.4 1.7 20.2 10.1s-1.7 17.4-10.1 20.2l-69.1 23 0 41.8 48 0c26.5 0 48-21.5 48-48 0-13.3 10.7-24 24-24s24 10.7 24 24c0 53-43 96-96 96l-72 0c-13.3 0-24-10.7-24-24l0-49.8-26.9 9c-8.4 2.8-17.4-1.7-20.2-10.1s1.7-17.4 10.1-20.2l37.1-12.4 0-30.3-26.9 9c-8.4 2.8-17.4-1.7-20.2-10.1s1.7-17.4 10.1-20.2l37.1-12.4 0-60.5c0-13.3 10.7-24 24-24z"],
    "rotate-exclamation": [512, 512, [], "e23c", "M482.2 256.3c17.5 2.5 29.7 18.7 27.2 36.2-17.8 124.1-124.4 219.5-253.4 219.5-70.7 0-134.7-28.7-181-75l0 0-10.4-9.8 .4 51.5c.1 17.7-14.1 32.1-31.7 32.3S1.2 496.9 1 479.2l-1-127c-.1-8.5 3.3-16.7 9.3-22.8S23.5 320 32 320l112 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-31.9 0 7.6 7.2 .6 .5c34.8 34.8 82.7 56.2 135.7 56.2 96.7 0 176.8-71.5 190.1-164.5 2.5-17.5 18.7-29.7 36.2-27.2zM256 384a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm0-256c18.2 0 32.7 15.5 31.4 33.7l-7.4 104c-.9 12.6-11.4 22.3-23.9 22.3-12.6 0-23-9.7-23.9-22.3l-7.4-104C223.3 143.5 237.8 128 256 128zM480 0c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32l-112 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l31.9 0-7.6-7.2-.6-.5C357 85.5 309 64 256 64 159.3 64 79.2 135.5 65.9 228.5 63.4 246 47.2 258.2 29.8 255.7S.1 237 2.6 219.5C20.3 95.4 127 0 256 0 326.4 0 390.2 28.5 436.4 74.4l11.6 11 0-53.4c0-17.7 14.3-32 32-32z"],
    "right-from-line": [512, 512, ["arrow-alt-from-left"], "f347", "M32 64c17.7 0 32 14.3 32 32l0 320c0 17.7-14.3 32-32 32S0 433.7 0 416L0 96C0 78.3 14.3 64 32 64zM505 239c9.4 9.4 9.4 24.6 0 33.9L361 417c-6.9 6.9-17.2 8.9-26.2 5.2S320 409.7 320 400l0-80-144 0c-26.5 0-48-21.5-48-48l0-32c0-26.5 21.5-48 48-48l144 0 0-80c0-9.7 5.8-18.5 14.8-22.2S354.1 88.2 361 95L505 239z"],
    "circle-q": [512, 512, [], "e11e", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM184 256c0 39.8 32.2 72 72 72 11.1 0 21.6-2.5 31-7l-25.9-25.9c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0L321 287c4.5-9.4 7-19.9 7-31 0-39.8-32.2-72-72-72s-72 32.2-72 72zm192 0c0 24.5-7.3 47.2-19.9 66.2L369 335c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-12.9-12.9c-19 12.6-41.7 19.9-66.2 19.9-66.3 0-120-53.7-120-120s53.7-120 120-120 120 53.7 120 120z"],
    "moon-over-sun": [576, 512, ["eclipse-alt"], "f74a", "M178.2-10.1c7.4-3.1 15.8-2.2 22.5 2.2l87.8 58.2 87.8-58.2c6.7-4.4 15.1-5.2 22.5-2.2S411.4-.5 413 7.3l20.9 103.2 103.2 20.9c7.8 1.6 14.4 7 17.4 14.3s2.2 15.8-2.2 22.5l-58.2 87.8 58.2 87.8c4.4 6.7 5.2 15.1 2.2 22.5s-9.6 12.8-17.4 14.3L433.8 401.4 413 504.7c-1.6 7.8-7 14.4-14.3 17.4s-15.8 2.2-22.5-2.2l-87.8-58.2-87.8 58.2c-6.7 4.4-15.1 5.2-22.5 2.2s-12.8-9.6-14.3-17.4L143 401.4 39.7 380.5c-7.8-1.6-14.4-7-17.4-14.3s-2.2-15.8 2.2-22.5L82.7 256 24.5 168.2c-4.4-6.7-5.2-15.1-2.2-22.5s9.6-12.8 17.4-14.3L143 110.6 163.9 7.3c1.6-7.8 7-14.4 14.3-17.4zM432.4 256a144.4 144.4 0 1 0 -288.8 0 144.4 144.4 0 1 0 288.8 0zm-240 0c0-53 43-96 96-96 5.6 0 11.1 .5 16.5 1.4 5.8 1 10.6 5.1 12.4 10.7s.5 11.7-3.5 16c-10.8 11.5-17.4 26.9-17.4 43.9 0 31.6 22.9 57.8 53 63.1 5.8 1 10.6 5.1 12.4 10.7s.5 11.7-3.5 16c-17.5 18.6-42.4 30.2-69.9 30.2-53 0-96-43-96-96z"],
    "360-degrees": [640, 512, [], "e2dc", "M640 32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM32 64C14.3 64 0 78.3 0 96s14.3 32 32 32l64 0-57.6 76.8c-7.3 9.7-8.4 22.7-3 33.5S51.9 256 64 256l16 0c26.5 0 48 21.5 48 48l0 48c0 17.7-14.3 32-32 32l-5.5 0c-8.5 0-16.6-3.4-22.6-9.4L54.6 361.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l13.3 13.3c18 18 42.4 28.1 67.9 28.1l5.5 0c53 0 96-43 96-96l0-48c0-47-29-87.3-70.1-103.9l63.7-84.9c7.3-9.7 8.4-22.7 3-33.5S172.1 64 160 64L32 64zm448 80c0-8.8 7.2-16 16-16s16 7.2 16 16l0 224c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-224zm96 224l0-224c0-44.2-35.8-80-80-80s-80 35.8-80 80l0 224c0 44.2 35.8 80 80 80s80-35.8 80-80zM288 160c0-17.7 14.3-32 32-32s32-14.3 32-32-14.3-32-32-32c-53 0-96 43-96 96l0 128 0 .2 0 79.8c0 44.2 35.8 80 80 80s80-35.8 80-80l0-96c0-44.2-35.8-80-80-80-5.5 0-10.8 .6-16 1.6l0-33.6zm0 112c0-8.8 7.2-16 16-16s16 7.2 16 16l0 96c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-96z"],
    "bracket-round-right": [192, 512, [], "29", "M37.4 46.2C27.6 61 31.6 80.8 46.3 90.6 71.9 107.7 128 167 128 256S71.9 404.3 46.3 421.4c-14.7 9.8-18.7 29.7-8.9 44.4s29.7 18.7 44.4 8.9C120.1 449 192 371.8 192 256S120.1 62.9 81.8 37.4c-14.7-9.8-34.6-5.8-44.4 8.9z"],
    "square-full": [512, 512, [128997, 128998, 128999, 129000, 129001, 129002, 129003, 11035, 11036], "f45c", "M0 64C0 28.7 28.7 0 64 0L448 0c35.3 0 64 28.7 64 64l0 384c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64z"],
    "star-sharp": [512, 512, [], "e28b", "M278.9 16.7C275.7 6.8 266.5 0 256 0s-19.7 6.8-22.9 16.7L182.5 176 24 176c-10.3 0-19.4 6.5-22.7 16.2s-.1 20.4 8 26.7L140.1 320.7 89.1 480.7c-3.2 10 .5 21 9.1 27s20.2 5.7 28.5-.7L256 406.4 385.3 506.9c8.3 6.5 19.8 6.8 28.5 .7s12.3-16.9 9.1-27L371.9 320.7 502.7 218.9c8.1-6.3 11.3-17 8-26.7S498.3 176 488 176l-158.5 0-50.7-159.3z"],
    "list-radio": [512, 512, [], "e1d0", "M64 160a64 64 0 1 0 0-128 64 64 0 1 0 0 128zM224 64c-17.7 0-32 14.3-32 32s14.3 32 32 32l256 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L224 64zm0 160c-17.7 0-32 14.3-32 32s14.3 32 32 32l256 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-256 0zm0 160c-17.7 0-32 14.3-32 32s14.3 32 32 32l256 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-256 0zM40 416a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm88 0a64 64 0 1 0 -128 0 64 64 0 1 0 128 0zM64 232a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm0 88a64 64 0 1 0 0-128 64 64 0 1 0 0 128z"],
    "head-side-medical": [512, 512, [], "f809", "M329.7 448c-5.1 0-9.7 3.7-9.7 8.8l0 7.2c0 26.5-21.5 48-48 48l-160 0c-26.5 0-48-21.5-48-48l0-63.6c0-12.6-5.1-24.5-13.1-34.2-31.8-38.7-50.9-88.2-50.9-142.2 0-123.7 100.3-224 224-224 112.7 0 206 83.3 221.7 191.7 .4 3 1.7 5.9 3.6 8.3l35.8 42.9c7 8.4 10.9 19.1 10.9 30.1 0 25.9-21 47-47 47l-1 0c-8.8 0-16 7.2-16 16l0 48c0 35.3-28.7 64-64 64l-38.3 0zM192 152l0 40-40 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l40 0 0 40c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-40 40 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-40 0 0-40c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16z"],
    "tombstone": [448, 512, [], "f720", "M32 192C32 86 118 0 224 0S416 86 416 192l0 256c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 512c-17.7 0-32-14.3-32-32s14.3-32 32-32l0-256zm216-72c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 40-48 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l48 0 0 120c0 13.3 10.7 24 24 24s24-10.7 24-24l0-120 48 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0 0-40z"],
    "square-a-lock": [576, 512, [], "e44d", "M96 32C60.7 32 32 60.7 32 96l0 320c0 35.3 28.7 64 64 64l209.3 0c-.9-5.2-1.3-10.6-1.3-16.1l0-96c0-11.2 1.9-21.9 5.4-31.9l-110.6 0-9.4 18.7c-5.9 11.9-20.3 16.7-32.2 10.7s-16.7-20.3-10.7-32.2l88-176c4.1-8.1 12.4-13.3 21.5-13.3s17.4 5.1 21.5 13.3l58.5 117.1 0-2.3c0-70.7 57.3-128 128-128 5.4 0 10.8 .3 16 1l0-49c0-35.3-28.7-64-64-64L96 32zM256 221.7l-33.2 66.3 66.3 0-33.2-66.3zm240 50.4l0 47.9-64 0 0-47.9c0-17.7 14.3-32 32-32s32 14.3 32 32zM352 368l0 96c0 26.5 21.5 48 48 48l128 0c26.5 0 48-21.5 48-48l0-96c0-20.9-13.4-38.7-32-45.3l0-50.6c0-44.2-35.8-80-80-80s-80 35.8-80 80l0 50.6c-18.6 6.6-32 24.4-32 45.3z"],
    "clover": [512, 512, [], "e139", "M310.4 16C346.6 16 376 45.4 376 81.7l0 5.2c0 11.2-2.7 22.3-7.8 32.2l-2.3 4.2-20.1 33.5c-1.1 1.9-1.2 3.4-1.1 4.5 .2 1.3 .9 2.7 2.1 3.9s2.6 1.9 3.9 2.1c1.1 .2 2.6 .1 4.5-1.1l33.5-20.1 4.2-2.3c10-5.1 21-7.8 32.2-7.8l5.2 0c36.2 0 65.6 29.4 65.6 65.7 0 17.4-6.9 34.1-19.2 46.4l-1.3 1.3c-3.7 3.7-3.7 9.6 0 13.3l1.3 1.3c12.3 12.3 19.2 29 19.2 46.4 0 36.2-29.4 65.6-65.6 65.6l-5.2 0c-12.8 0-25.5-3.5-36.5-10.1l-33.5-20.1c-1.9-1.1-3.4-1.2-4.5-1.1-1.3 .2-2.7 .9-3.9 2.1s-1.9 2.6-2.1 3.9c-.2 1.1-.1 2.6 1.1 4.5l20.1 33.5c6.6 11 10.1 23.6 10.1 36.5l0 5.2c0 36.2-29.4 65.6-65.6 65.6-17.4 0-34.1-6.9-46.4-19.2l-1.3-1.3c-3.7-3.7-9.6-3.7-13.3 0l-1.3 1.3c-12.3 12.3-29 19.2-46.4 19.2-36.2 0-65.6-29.4-65.7-65.6l0-5.2c0-12.8 3.5-25.5 10.1-36.5l20.1-33.5c1.1-1.9 1.2-3.4 1.1-4.5-.2-1.3-.9-2.7-2.1-3.9s-2.6-1.9-3.9-2.1c-.5-.1-1.2-.1-1.9 0l-2.5 1-33.5 20.1c-11 6.6-23.6 10.1-36.5 10.1l-5.2 0C45.4 376 16 346.6 16 310.4 16 293 22.9 276.3 35.2 264l1.3-1.3 1.2-1.5c2.1-3.1 2.1-7.2 0-10.3l-1.2-1.5-1.3-1.3C22.9 235.8 16 219.1 16 201.7 16 165.4 45.4 136 81.7 136l5.2 0c12.8 0 25.5 3.5 36.5 10.1l33.5 20.1 2.5 1c.7 .1 1.4 .1 1.9 .1 1.3-.2 2.7-.9 3.9-2.1s1.9-2.6 2.1-3.9c.1-.5 .1-1.2-.1-1.9l-1-2.5-20.1-33.5c-6.6-11-10.1-23.6-10.1-36.5l0-5.2c0-36.2 29.4-65.7 65.7-65.7 17.4 0 34.1 6.9 46.4 19.2l1.3 1.3c3.7 3.6 9.6 3.7 13.3 0l1.3-1.3 4.8-4.4C280.5 21.3 295.1 16 310.4 16z"],
    "signal-bars-fair": [448, 512, ["signal-alt-2"], "f692", "M192 288c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 160c0 17.7 14.3 32 32 32s32-14.3 32-32l0-160zM64 416c0-17.7-14.3-32-32-32S0 398.3 0 416l0 32c0 17.7 14.3 32 32 32s32-14.3 32-32l0-32z"],
    "folder-heart": [512, 512, [], "e189", "M448 448L64 448c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l138.7 0c13.8 0 27.3 4.5 38.4 12.8l38.4 28.8c5.5 4.2 12.3 6.4 19.2 6.4L448 80c35.3 0 64 28.7 64 64l0 240c0 35.3-28.7 64-64 64zM249.6 199.5c-11.1-14.8-28.5-23.5-46.9-23.5-32.4 0-58.7 26.3-58.7 58.7l0 5.3c0 49.1 65.8 98.1 96.5 118.3 9.5 6.2 21.5 6.2 30.9 0 30.7-20.2 96.5-69.3 96.5-118.3l0-5.3c0-32.4-26.3-58.7-58.7-58.7-18.5 0-35.9 8.7-46.9 23.5l-6.4 8.5-6.4-8.5z"],
    "cloud-word": [576, 512, [], "e138", "M0 336c0 79.5 64.5 144 144 144l304 0c70.7 0 128-57.3 128-128 0-51.6-30.5-96.1-74.5-116.3 6.7-13.1 10.5-28 10.5-43.7 0-53-43-96-96-96-17.7 0-34.2 4.8-48.4 13.1-24.1-45.8-72.2-77.1-127.6-77.1-79.5 0-144 64.5-144 144 0 8 .7 15.9 1.9 23.5-56.9 19.2-97.9 73.1-97.9 136.5zm240 24c0 13.3-10.7 24-24 24l-32 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l32 0c13.3 0 24 10.7 24 24zM360 256l32 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-32 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zm56 104c0 13.3-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l80 0c13.3 0 24 10.7 24 24zM184 256l80 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"],
    "screen-users": [640, 512, ["users-class"], "f63d", "M128 0C92.7 0 64 28.7 64 64l0 148.6c10.1-3 20.9-4.6 32-4.6s21.9 1.6 32 4.6l0-148.6 384 0 0 148.6c10.1-3 20.9-4.6 32-4.6s21.9 1.6 32 4.6L576 64c0-35.3-28.7-64-64-64L128 0zm32 320a64 64 0 1 0 -128 0 64 64 0 1 0 128 0zM0 480c0 17.7 14.3 32 32 32l128 0c17.7 0 32-14.3 32-32 0-35.3-28.7-64-64-64l-64 0c-35.3 0-64 28.7-64 64zM384 320a64 64 0 1 0 -128 0 64 64 0 1 0 128 0zM224 480c0 17.7 14.3 32 32 32l128 0c17.7 0 32-14.3 32-32 0-35.3-28.7-64-64-64l-64 0c-35.3 0-64 28.7-64 64zm320-96a64 64 0 1 0 0-128 64 64 0 1 0 0 128zm-32 32c-35.3 0-64 28.7-64 64 0 17.7 14.3 32 32 32l128 0c17.7 0 32-14.3 32-32 0-35.3-28.7-64-64-64l-64 0z"],
    "teeth-open": [512, 512, [], "f62f", "M64 32C28.7 32 0 60.7 0 96l0 80c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-80c0-35.3-28.7-64-64-64L64 32zm0 272c-35.3 0-64 28.7-64 64l0 48c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-48c0-35.3-28.7-64-64-64L64 304zm80-160c0-26.5 21.5-48 48-48s48 21.5 48 48l0 24c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-24zm128 0c0-26.5 21.5-48 48-48s48 21.5 48 48l0 24c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-24zM80 112c17.7 0 32 14.3 32 32l0 24c0 13.3-10.7 24-24 24l-16 0c-13.3 0-24-10.7-24-24l0-24c0-17.7 14.3-32 32-32zm320 32c0-17.7 14.3-32 32-32s32 14.3 32 32l0 24c0 13.3-10.7 24-24 24l-16 0c-13.3 0-24-10.7-24-24l0-24zM48 384l0-16c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 16c0 17.7-14.3 32-32 32s-32-14.3-32-32zm144 48c-26.5 0-48-21.5-48-48l0-16c0-8.8 7.2-16 16-16l64 0c8.8 0 16 7.2 16 16l0 16c0 26.5-21.5 48-48 48zm128 0c-26.5 0-48-21.5-48-48l0-16c0-8.8 7.2-16 16-16l64 0c8.8 0 16 7.2 16 16l0 16c0 26.5-21.5 48-48 48zm112-16c-17.7 0-32-14.3-32-32l0-16c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 16c0 17.7-14.3 32-32 32z"],
    "circle-u": [512, 512, [], "e127", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM208 168l0 104c0 26.5 21.5 48 48 48s48-21.5 48-48l0-104c0-13.3 10.7-24 24-24s24 10.7 24 24l0 104c0 53-43 96-96 96s-96-43-96-96l0-104c0-13.3 10.7-24 24-24s24 10.7 24 24z"],
    "calendar-heart": [448, 512, [], "e0d3", "M128 0c17.7 0 32 14.3 32 32l0 32 128 0 0-32c0-17.7 14.3-32 32-32s32 14.3 32 32l0 32 32 0c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 128C0 92.7 28.7 64 64 64l32 0 0-32c0-17.7 14.3-32 32-32zm89.6 215.5c-11.1-14.8-28.5-23.5-46.9-23.5-32.4 0-58.7 26.3-58.7 58.7l0 5.3c0 49.1 65.8 98.1 96.5 118.3 9.5 6.2 21.5 6.2 30.9 0 30.7-20.2 96.5-69.3 96.5-118.3l0-5.3c0-32.4-26.3-58.7-58.7-58.7-18.5 0-35.9 8.7-46.9 23.5l-6.4 8.5-6.4-8.5z"],
    "narwhal": [640, 512, [], "f6fe", "M639.3 20.7c2.4-7.8-1.4-16.1-8.9-19.4s-16.2-.4-20.2 6.6L516.7 168.3c-16.9-5.4-34.9-8.3-53.6-8.3-50.9 0-100.7 17.5-140.2 49.6L154.1 346.8c-10.5 8.5-26.1 1.1-26.1-12.4l0-81.3 29.9-20.9c21.4-15 34.1-39.4 34.1-65.5l0-54.7c0-6-3.3-11.4-8.6-14.2s-11.7-2.3-16.6 1.1L96 148.5 25.2 98.9c-4.9-3.4-11.3-3.8-16.6-1.1S0 106 0 112l0 54.7c0 26.1 12.7 50.6 34.1 65.5L64 253.1 64 352c0 88.4 71.6 160 160 160l240 0c97.2 0 176-78.8 176-176 0-51.4-22.3-97.7-57.8-129.9l57-185.4zM496 280a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"],
    "bars-staggered": [512, 512, ["reorder", "stream"], "f550", "M0 96C0 78.3 14.3 64 32 64l384 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 128C14.3 128 0 113.7 0 96zM64 256c0-17.7 14.3-32 32-32l384 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L96 288c-17.7 0-32-14.3-32-32zM448 416c0 17.7-14.3 32-32 32L32 448c-17.7 0-32-14.3-32-32s14.3-32 32-32l384 0c17.7 0 32 14.3 32 32z"],
    "warehouse": [576, 512, [], "f494", "M0 142.1L0 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-240c0-17.7 14.3-32 32-32l384 0c17.7 0 32 14.3 32 32l0 240c0 17.7 14.3 32 32 32s32-14.3 32-32l0-337.9c0-27.5-17.6-52-43.8-60.7L303.2 5.1c-9.9-3.3-20.5-3.3-30.4 0L43.8 81.4C17.6 90.1 0 114.6 0 142.1zM464 256l-352 0 0 64 352 0 0-64zM112 416l352 0 0-64-352 0 0 64zm352 32l-352 0 0 64 352 0 0-64z"],
    "swatchbook": [512, 512, [], "f5c3", "M0 48C0 21.5 21.5 0 48 0l96 0c26.5 0 48 21.5 48 48l0 368c0 53-43 96-96 96S0 469 0 416L0 48zM240 409.6l0-271.5 48.1-48.1c18.7-18.7 49.1-18.7 67.9 0l67.9 67.9c18.7 18.7 18.7 49.1 0 67.9L240 409.6zM205.5 512l192-192 66.6 0c26.5 0 48 21.5 48 48l0 96c0 26.5-21.5 48-48 48l-258.5 0zM80 64c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16L80 64zM64 208l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zM96 440a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"],
    "circle-three-quarters": [512, 512, [], "e125", "M256 32C256 14.3 241.6-.2 224.1 2 97.8 17.7 0 125.4 0 256 0 397.4 114.6 512 256 512 386.6 512 494.3 414.2 510 287.9 512.2 270.4 497.7 256 480 256l-192 0c-17.7 0-32-14.3-32-32l0-192z"],
    "circle-chf": [512, 512, [], "e72c", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM136 144c22.1 0 40 17.9 40 40l0 8c0 13.3-10.7 24-24 24-2.8 0-5.5-.5-8-1.4l0 82.7c2.5-.9 5.2-1.4 8-1.4 13.3 0 24 10.7 24 24l0 8c0 22.1-17.9 40-40 40s-40-17.9-40-40l0-144c0-22.1 17.9-40 40-40zm104 24l0 64 16 0 0-64c0-13.3 10.7-24 24-24s24 10.7 24 24l0 176c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-64-16 0 0 64c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-176c0-13.3 10.7-24 24-24s24 10.7 24 24zm104-24l48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-24 0 0 40 16 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-16 0 0 64c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-176c0-13.3 10.7-24 24-24z"],
    "campground": [512, 512, [9978], "f6bb", "M344.8 52.3c11.2-13.7 9.2-33.8-4.5-45s-33.8-9.2-45 4.5l-39.2 48-39.2-48C205.6-1.9 185.4-4 171.7 7.2s-15.7 31.4-4.5 45l47.4 58-202 246.9C4.5 367.1 0 379.6 0 392.6L0 432c0 26.5 21.5 48 48 48l416 0c26.5 0 48-21.5 48-48l0-39.4c0-12.9-4.5-25.5-12.7-35.5l-202-246.9 47.4-58zM256 288l112 128-224 0 112-128z"],
    "person-walking-arrow-right": [576, 512, [], "e552", "M104.5 24a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm-8 181.3L73.9 227.9c-6 6-9.4 14.1-9.4 22.6l0 37.5c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-37.5c0-25.5 10.1-49.9 28.1-67.9l35.1-35.1c22.8-22.8 53.6-35.6 85.8-35.6 36.9 0 71.8 16.8 94.8 45.6L262.3 180c6.1 7.6 15.3 12 25 12l33.2 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-33.2 0c-29.2 0-56.7-13.3-75-36l-3.8-4.7 0 115.2 34.5 29.6c17.7 15.2 29.3 36.2 32.6 59.3l12.6 88.1c2.5 17.5-9.7 33.7-27.2 36.2s-33.7-9.7-36.2-27.2l-12.6-88.1c-1.1-7.7-5-14.7-10.9-19.8L130 347.5c-21.3-18.2-33.5-44.9-33.5-72.9l0-69.3zM96.6 371c2.4 2.3 4.8 4.6 7.4 6.8l46 39.4-2.2 7.6c-4.5 15.7-12.9 30-24.4 41.5L55.1 534.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l68.3-68.3c3.8-3.8 6.6-8.6 8.1-13.8L96.6 371zM505.5 345c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l31-31-102.1 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l102.1 0-31-31c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l72 72c9.4 9.4 9.4 24.6 0 33.9l-72 72z"],
    "spider-black-widow": [512, 512, [], "f718", "M142.8-31c11.9 3.5 19 15.5 16.8 27.4l-.6 2.4-36 122.3 53 53c1-43.3 36.4-78.1 79.9-78.1 43.6 0 78.9 34.8 79.9 78.2l53.1-53.1-36-122.3-.6-2.4c-2.2-12 4.9-23.9 16.8-27.4 11.9-3.5 24.4 2.7 29 13.9l.8 2.3 40 136c2.5 8.4 .1 17.5-6.1 23.7l-64.1 64.1 76.4-20.8 19.9-59.8 .9-2.3c5-11.1 17.7-16.8 29.5-12.9 11.8 3.9 18.5 16.1 15.8 28l-.7 2.4-24 72c-2.5 7.6-8.7 13.4-16.5 15.6l-91.1 24.8 91.1 24.8c7.7 2.1 13.9 8 16.5 15.6l24 72 .7 2.4c2.7 11.9-4.1 24.1-15.8 28-11.8 3.9-24.5-1.8-29.5-12.9l-.9-2.3-19.9-59.8-76.4-20.8 64.1 64.1c6.1 6.1 8.5 15.1 6.2 23.4l-40 144-.8 2.3c-4.4 11.3-16.8 17.7-28.8 14.4-12-3.3-19.3-15.2-17.2-27.2l.5-2.4 36.2-130.5-37.2-37.2c-1 52.1-43.6 94.1-95.9 94.1-52.4 0-95-42-96-94.1l-37 37 36 122.3 .6 2.4c2.2 11.9-4.9 23.9-16.8 27.4-11.9 3.5-24.4-2.7-29-13.9l-.8-2.3-40-136c-2.5-8.4-.1-17.5 6.1-23.8l64.1-64.1-76.4 20.8-19.9 59.8-.9 2.3c-5 11.1-17.7 16.8-29.5 12.9-11.8-3.9-18.5-16.1-15.8-28l.7-2.4 24-72c2.5-7.6 8.7-13.5 16.5-15.6l91.1-24.8-91.1-24.8c-7.7-2.1-13.9-8-16.5-15.6l-24-72-.7-2.4c-2.7-11.9 4.1-24.1 15.8-28 11.8-3.9 24.5 1.8 29.5 12.9l.9 2.3 19.9 59.8 76.4 20.8-64.1-64.1c-6.2-6.2-8.5-15.3-6.1-23.7l40-136 .8-2.3c4.6-11.3 17.1-17.4 29-13.9zM222 288c-3.3 0-6 2.7-6 6 0 1.3 .4 2.6 1.2 3.6L240 328 217.2 358.4c-.8 1-1.2 2.3-1.2 3.6 0 3.3 2.7 6 6 6l68 0c3.3 0 6-2.7 6-6 0-1.3-.4-2.6-1.2-3.6L272 328 294.8 297.6c.8-1 1.2-2.3 1.2-3.6 0-3.3-2.7-6-6-6l-68 0z"],
    "glasses": [576, 512, [], "f530", "M143.3 96c-14 0-26.5 9.2-30.6 22.6L70.4 256 224 256c17.7 0 32 14.3 32 32l64 0c0-17.7 14.3-32 32-32l153.6 0-42.3-137.4C459.2 105.2 446.8 96 432.7 96L400 96c-17.7 0-32-14.3-32-32s14.3-32 32-32l32.7 0c42.1 0 79.4 27.5 91.8 67.8l45.4 147.5c4.1 13.2 6.1 26.9 6.1 40.7l0 96c0 53-43 96-96 96l-64 0c-53 0-96-43-96-96l0-32-64 0 0 32c0 53-43 96-96 96l-64 0c-53 0-96-43-96-96l0-96c0-13.8 2.1-27.5 6.1-40.7L51.5 99.8C63.9 59.5 101.1 32 143.3 32L176 32c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32.7 0zM64 320l0 64c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-64-128 0zm416 96c17.7 0 32-14.3 32-32l0-64-128 0 0 64c0 17.7 14.3 32 32 32l64 0z"],
    "circle-pause": [512, 512, [62092, "pause-circle"], "f28b", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM224 192l0 128c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-128c0-17.7 14.3-32 32-32s32 14.3 32 32zm128 0l0 128c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-128c0-17.7 14.3-32 32-32s32 14.3 32 32z"],
    "memory": [512, 512, [], "f538", "M64 64C28.7 64 0 92.7 0 128l0 7.4C0 142.2 4.4 148 10.1 151.7 23.3 160.3 32 175.1 32 192s-8.7 31.7-21.9 40.3C4.4 236 0 241.8 0 248.6l0 55.4 512 0 0-55.4c0-6.8-4.4-12.6-10.1-16.3-13.2-8.6-21.9-23.4-21.9-40.3s8.7-31.7 21.9-40.3c5.7-3.7 10.1-9.5 10.1-16.3l0-7.4c0-35.3-28.7-64-64-64L64 64zM512 416l0-64-512 0 0 64c0 17.7 14.3 32 32 32l64 0 0-24c0-13.3 10.7-24 24-24s24 10.7 24 24l0 24 88 0 0-24c0-13.3 10.7-24 24-24s24 10.7 24 24l0 24 88 0 0-24c0-13.3 10.7-24 24-24s24 10.7 24 24l0 24 64 0c17.7 0 32-14.3 32-32zM160 160l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32s32 14.3 32 32zm128 0l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32s32 14.3 32 32zm128 0l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32s32 14.3 32 32z"],
    "gift": [512, 512, [127873], "f06b", "M321.5 68.8C329.1 55.9 342.9 48 357.8 48l2.2 0c22.1 0 40 17.9 40 40s-17.9 40-40 40l-73.3 0 34.8-59.2zm-131 0l34.8 59.2-73.3 0c-22.1 0-40-17.9-40-40s17.9-40 40-40l2.2 0c14.9 0 28.8 7.9 36.3 20.8zm89.6-24.3l-24.1 41-24.1-41C215.7 16.9 186.1 0 154.2 0L152 0c-48.6 0-88 39.4-88 88 0 14.4 3.5 28 9.6 40L32 128c-17.7 0-32 14.3-32 32l0 32c0 17.7 14.3 32 32 32l448 0c17.7 0 32-14.3 32-32l0-32c0-17.7-14.3-32-32-32l-41.6 0c6.1-12 9.6-25.6 9.6-40 0-48.6-39.4-88-88-88l-2.2 0c-31.9 0-61.5 16.9-77.7 44.4zM480 272l-200 0 0 208 136 0c35.3 0 64-28.7 64-64l0-144zm-248 0l-200 0 0 144c0 35.3 28.7 64 64 64l136 0 0-208z"],
    "sprinkler-ceiling": [384, 512, [], "e44c", "M0 0L0 96c0 15.3 10.8 28.4 25.7 31.4L128 147.8 128 82.6 64 69.8 64 0 0 0zM256 82.6l0 65.3 102.3-20.5c15-3 25.7-16.1 25.7-31.4l0-96-64 0 0 69.8-64 12.8zM160 344a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm-48 64c0-13.3-10.7-24-24-24s-24 10.7-24 24 10.7 24 24 24 24-10.7 24-24zM24 496c13.3 0 24-10.7 24-24s-10.7-24-24-24-24 10.7-24 24 10.7 24 24 24zM272 344a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm-80 88c13.3 0 24-10.7 24-24s-10.7-24-24-24-24 10.7-24 24 10.7 24 24 24zm-32 40c0-13.3-10.7-24-24-24s-24 10.7-24 24 10.7 24 24 24 24-10.7 24-24zm136-40c13.3 0 24-10.7 24-24s-10.7-24-24-24-24 10.7-24 24 10.7 24 24 24zm-24 40c0-13.3-10.7-24-24-24s-24 10.7-24 24 10.7 24 24 24 24-10.7 24-24zm88 24c13.3 0 24-10.7 24-24s-10.7-24-24-24-24 10.7-24 24 10.7 24 24 24zM224 64c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 128-64 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l192 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0 0-128z"],
    "square-phone-hangup": [448, 512, ["phone-square-down"], "e27a", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM83.1 311.1l-1.4-2.5c-16.6-29.1-14-70.7 18.7-92 75-48.8 172.3-48.8 247.3 0 32.7 21.3 35.3 62.9 18.7 92l-1.4 2.5c-5.1 8.9-15.9 12.6-25.3 8.7l-48.7-20.1c-8.3-3.4-13.3-11.9-12.5-20.8l3-30.3c-37.2-12.5-77.8-11.9-114.6 2l2.8 28.4c.9 8.9-4.2 17.4-12.5 20.8l-48.7 20.1c-9.4 3.9-20.3 .2-25.3-8.7z"],
    "money-bill-wheat": [512, 512, [], "e52a", "M176-16c44.2 0 80 35.8 80 80 0 8.8-7.2 16-16 16-44.2 0-80-35.8-80-80 0-8.8 7.2-16 16-16zM56 0l48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L56 48C42.7 48 32 37.3 32 24S42.7 0 56 0zM24 72l112 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 120C10.7 120 0 109.3 0 96S10.7 72 24 72zm8 96c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24zM272 0c0-8.8 7.2-16 16-16 44.2 0 80 35.8 80 80 0 8.8-7.2 16-16 16-44.2 0-80-35.8-80-80zM400-16c44.2 0 80 35.8 80 80 0 8.8-7.2 16-16 16-44.2 0-80-35.8-80-80 0-8.8 7.2-16 16-16zm80 144c0 44.2-35.8 80-80 80-8.8 0-16-7.2-16-16 0-44.2 35.8-80 80-80 8.8 0 16 7.2 16 16zM352 112c8.8 0 16 7.2 16 16 0 44.2-35.8 80-80 80-8.8 0-16-7.2-16-16 0-44.2 35.8-80 80-80zm-96 16c0 44.2-35.8 80-80 80-8.8 0-16-7.2-16-16 0-44.2 35.8-80 80-80 8.8 0 16 7.2 16 16zM0 304c0-26.5 21.5-48 48-48l416 0c26.5 0 48 21.5 48 48l0 160c0 26.5-21.5 48-48 48L48 512c-26.5 0-48-21.5-48-48L0 304zM48 416l0 48 48 0c0-26.5-21.5-48-48-48zM96 304l-48 0 0 48c26.5 0 48-21.5 48-48zM464 416c-26.5 0-48 21.5-48 48l48 0 0-48zM416 304c0 26.5 21.5 48 48 48l0-48-48 0zm-96 80a64 64 0 1 0 -128 0 64 64 0 1 0 128 0z"],
    "circle-florin": [512, 512, [], "e6e4", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm16.4-355.3c9.5-22.3 31.4-36.7 55.7-36.7l23.9 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-23.9 0c-5 0-9.6 3-11.6 7.6L295.8 224 328 224c13.3 0 24 10.7 24 24s-10.7 24-24 24l-52.7 0-35.7 83.3C230 377.6 208.1 392 183.9 392L160 392c-13.3 0-24-10.7-24-24s10.7-24 24-24l23.9 0c5 0 9.6-3 11.6-7.6l27.6-64.4-39 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l59.6 0 28.8-67.3z"],
    "dungeon": [512, 512, [], "f6d9", "M347.5 144.8c6.5 5.4 12.5 11.3 18 17.7 8.7 10.2 23.7 14 35.1 6.9l54.1-33.8c11.2-7 14.7-21.7 6.9-32.2-15.3-20.5-33.5-38.6-54.1-53.8-10.4-7.6-24.7-4.3-31.8 6.4l-35.1 52.6c-7.8 11.6-3.8 27.3 7 36.2zM327.8 41.1c8.6-12.9 2.9-30.5-12.2-34.1-19.1-4.6-39.1-7-59.6-7s-40.4 2.4-59.6 7c-15.1 3.6-20.8 21.2-12.2 34.1l40 60c5.2 7.8 14.5 11.7 23.9 11.2 5.2-.3 10.6-.3 15.8 0 9.4 .5 18.7-3.4 23.9-11.2l40-60zM50.5 103.3c-7.9 10.5-4.3 25.3 6.9 32.2l54.1 33.8c11.4 7.1 26.3 3.3 35.1-6.9 5.5-6.4 11.5-12.3 18-17.7 10.8-8.9 14.8-24.6 7-36.2L136.4 55.9c-7.1-10.7-21.5-14-31.8-6.4-20.6 15.1-38.8 33.3-54.1 53.8zm62 141.1c.8-9.9-3.3-19.9-11.8-25.1L41 182c-12.9-8-29.9-2.3-33.6 12.5-4.9 19.7-7.5 40.3-7.5 61.6l0 24c0 13.3 10.7 24 24 24l64 0c13.3 0 24-10.7 24-24l0-24c0-3.9 .2-7.8 .5-11.6zm287.1 0c.3 3.8 .5 7.7 .5 11.6l0 24c0 13.3 10.7 24 24 24l64 0c13.3 0 24-10.7 24-24l0-24c0-21.2-2.6-41.8-7.5-61.6-3.6-14.7-20.7-20.5-33.6-12.5l-59.7 37.3c-8.4 5.3-12.6 15.2-11.8 25.1zM88 352l-64 0c-13.3 0-24 10.7-24 24L0 488c0 13.3 10.7 24 24 24l64 0c13.3 0 24-10.7 24-24l0-112c0-13.3-10.7-24-24-24zm400 0l-64 0c-13.3 0-24 10.7-24 24l0 112c0 13.3 10.7 24 24 24l64 0c13.3 0 24-10.7 24-24l0-112c0-13.3-10.7-24-24-24zM280 184c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 304c0 13.3 10.7 24 24 24s24-10.7 24-24l0-304zm-80 32c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 272c0 13.3 10.7 24 24 24s24-10.7 24-24l0-272zm160 0c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 272c0 13.3 10.7 24 24 24s24-10.7 24-24l0-272z"],
    "comet": [512, 512, [], "e003", "M299.4 75.6L493.7 .9c1.5-.6 3.2-.9 4.8-.9 7.5 0 13.5 6 13.5 13.5 0 1.7-.3 3.3-.9 4.8l-74.7 194.2 29.3-2.3c12.8-1 21.5 12.8 15.1 24L378.6 410.7C342.3 473.4 275.4 512 203 512 90.9 512 0 421.1 0 309 0 236.6 38.6 169.7 101.3 133.4L277.7 31.2c11.1-6.5 25 2.2 24 15.1l-2.3 29.3zM192 200c-6.1 0-11.7 3.5-14.3 8.9l-29.2 59.2-65.3 9.5c-6 .9-11 5.1-12.9 10.9s-.3 12.2 4 16.4l47.2 46-11.2 65c-1 6 1.4 12.1 6.4 15.7s11.5 4.1 16.8 1.2l58.4-30.7 58.4 30.7c5.4 2.8 11.9 2.4 16.8-1.2s7.4-9.6 6.4-15.7l-11.2-65 47.2-46c4.4-4.3 5.9-10.6 4-16.4s-6.9-10-12.9-10.9l-65.3-9.5-29.2-59.2c-2.7-5.5-8.3-8.9-14.3-8.9z"],
    "face-holding-back-tears": [512, 512, [129401], "e482", "M0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm240 20.7c5.1-11.2 8-23.6 8-36.7 0-42.2-29.8-77.5-69.5-86 6.8-9.3 12-19.8 15.2-31.3l1.5-5.2c3-10.6-3.1-21.7-13.7-24.7s-21.7 3.1-24.7 13.7l-1.5 5.2c-6.6 23.1-26.4 40.1-50.2 43.1l-11.5 1.4c-11 1.4-18.7 11.4-17.4 22.3 .8 6.3 4.4 11.5 9.4 14.6-8.6 13.6-13.6 29.7-13.6 46.9 0 23.4 9.1 44.6 24 60.4L96 336c0 8.8 7.2 16 16 16s16-7.2 16-16l0-14c9.9 3.9 20.7 6 32 6 17.7 0 34.2-5.2 48-14.2l0 6.2c0 8.8 7.2 16 16 16s16-7.2 16-16l0-43.3zM352 328c11.3 0 22.1-2.1 32-6l0 14c0 8.8 7.2 16 16 16s16-7.2 16-16l0-35.6c14.9-15.8 24-37 24-60.4 0-17.3-5-33.4-13.6-46.9 5-3.1 8.6-8.3 9.4-14.6 1.4-11-6.4-21-17.4-22.3L407 154.7c-23.9-3-43.6-19.9-50.2-43.1l-1.5-5.2c-3-10.6-14.1-16.8-24.7-13.7s-16.8 14.1-13.7 24.7l1.5 5.2c3.3 11.5 8.5 22 15.2 31.3-39.7 8.5-69.5 43.8-69.5 86 0 48.6 39.4 88 88 88zm-41.3 51.4C300.3 390.2 282.2 402 256 402s-44.3-11.8-54.7-22.6c-9.2-9.6-24.4-9.9-33.9-.7s-9.9 24.4-.7 33.9C184.1 430.8 214.1 450 256 450s71.9-19.2 89.3-37.4c9.2-9.6 8.9-24.8-.7-33.9s-24.8-8.9-33.9 .7zM128 232c17.7 0 32-14.3 32-32 0-5.8-1.5-11.2-4.2-15.8 1.4-.1 2.8-.2 4.2-.2 30.9 0 56 25.1 56 56s-25.1 56-56 56-56-25.1-56-56c0-5.7 .8-11.2 2.4-16.4 5.7 5.2 13.3 8.4 21.6 8.4zm224-32c0-5.8-1.5-11.2-4.2-15.8 1.4-.1 2.8-.2 4.2-.2 30.9 0 56 25.1 56 56s-25.1 56-56 56-56-25.1-56-56c0-5.7 .8-11.2 2.4-16.4 5.7 5.2 13.3 8.4 21.6 8.4 17.7 0 32-14.3 32-32z"],
    "card-heart": [384, 512, [], "e3eb", "M64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-384c0-35.3-28.7-64-64-64L64 0zM185.6 183.5l6.4 8.5 6.4-8.5c11.1-14.8 28.5-23.5 46.9-23.5 32.4 0 58.7 26.3 58.7 58.7l0 5.3c0 49.1-65.8 98.1-96.5 118.3-9.5 6.2-21.5 6.2-30.9 0-30.7-20.2-96.5-69.3-96.5-118.3l0-5.3c0-32.4 26.3-58.7 58.7-58.7 18.5 0 35.9 8.7 46.9 23.5z"],
    "car-mirrors": [576, 512, [], "e343", "M197.4 96c-13.6 0-25.7 8.6-30.2 21.4l-26.1 74.6 293.8 0-26.1-74.6C404.3 104.6 392.2 96 378.6 96L197.4 96zM32 256c-17.7 0-32-14.3-32-32s14.3-32 32-32l41.3 0 33.5-95.7C120.3 57.8 156.6 32 197.4 32l181.2 0c40.8 0 77.1 25.8 90.6 64.3l33.5 95.7 41.3 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l0 192c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-32-320 0 0 32c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-192zm96 80a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm352-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "suitcase-medical": [512, 512, ["medkit"], "f0fa", "M192 56l0 40 128 0 0-40c0-4.4-3.6-8-8-8L200 48c-4.4 0-8 3.6-8 8zm-48 8l0-8c0-30.9 25.1-56 56-56L312 0c30.9 0 56 25.1 56 56l0 424-224 0 0-416zM96 176l0 304-32 0c-35.3 0-64-28.7-64-64L0 160c0-35.3 28.7-64 64-64l32 0 0 80zM416 480l0-384 32 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64l-32 0zM244 208c-8.8 0-16 7.2-16 16l0 36-36 0c-8.8 0-16 7.2-16 16l0 24c0 8.8 7.2 16 16 16l36 0 0 36c0 8.8 7.2 16 16 16l24 0c8.8 0 16-7.2 16-16l0-36 36 0c8.8 0 16-7.2 16-16l0-24c0-8.8-7.2-16-16-16l-36 0 0-36c0-8.8-7.2-16-16-16l-24 0z"],
    "block-quote": [448, 512, [], "e0b5", "M32 64C14.3 64 0 78.3 0 96s14.3 32 32 32l384 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 64zM160 224c-17.7 0-32 14.3-32 32s14.3 32 32 32l256 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-256 0zM128 416c0 17.7 14.3 32 32 32l256 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-256 0c-17.7 0-32 14.3-32 32zM32 224c-17.7 0-32 14.3-32 32L0 416c0 17.7 14.3 32 32 32s32-14.3 32-32l0-160c0-17.7-14.3-32-32-32z"],
    "hands-holding-heart": [640, 512, ["hands-heart"], "f4c3", "M311.6 15L320 26.7 328.4 15c14.1-19.5 36.6-31 60.7-31 41.4 0 74.9 33.5 74.9 74.9l0 2.4c0 64.4-82 133.4-122.2 163.3-13 9.7-30.5 9.7-43.5 0-40.2-30-122.3-98.9-122.2-163.3l0-2.4c0-41.4 33.5-74.9 74.9-74.9 24 0 46.6 11.5 60.7 31zM40 64c22.1 0 40 17.9 40 40l0 160.2c0 17 6.7 33.3 18.7 45.3l51.1 51.1c8.3 8.3 21.3 9.6 31 3.1 12.9-8.6 14.7-26.9 3.7-37.8-7.3-7.3-23.1-23.1-47.2-47.2-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0c24.1 24.1 39.9 39.9 47.2 47.2l0 0 25.3 25.3c21 21 32.8 49.5 32.8 79.2l0 78.9c0 26.5-21.5 48-48 48l-66.7 0c-17 0-33.3-6.7-45.3-18.7L28.1 393.4C10.1 375.4 0 351 0 325.5L0 104C0 81.9 17.9 64 40 64zm560 0c22.1 0 40 17.9 40 40l0 221.5c0 25.5-10.1 49.9-28.1 67.9L512 493.3c-12 12-28.3 18.7-45.3 18.7L400 512c-26.5 0-48-21.5-48-48l0-78.9c0-29.7 11.8-58.2 32.8-79.2l25.3-25.3 0 0c7.3-7.3 23.1-23.1 47.2-47.2 12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3c-24.1 24.1-39.9 39.9-47.2 47.2-11 11-9.2 29.2 3.7 37.8 9.7 6.5 22.7 5.2 31-3.1l51.1-51.1c12-12 18.7-28.3 18.7-45.3L560 104c0-22.1 17.9-40 40-40z"],
    "arrow-up-small-big": [512, 512, ["sort-size-up-alt"], "f88f", "M150.6 41.4c-12.5-12.5-32.8-12.5-45.3 0l-80 80c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L96 141.3 96 448c0 17.7 14.3 32 32 32s32-14.3 32-32l0-306.7 25.4 25.4c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-80-80zM288 80l0 64c0 26.5 21.5 48 48 48l64 0c26.5 0 48-21.5 48-48l0-64c0-26.5-21.5-48-48-48l-64 0c-26.5 0-48 21.5-48 48zm0 224l0 128c0 26.5 21.5 48 48 48l128 0c26.5 0 48-21.5 48-48l0-128c0-26.5-21.5-48-48-48l-128 0c-26.5 0-48 21.5-48 48z"],
    "sliders-simple": [512, 512, [], "e253", "M96 384a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm90.5-64c-13.2-37.3-48.7-64-90.5-64-53 0-96 43-96 96s43 96 96 96c41.8 0 77.4-26.7 90.5-64L480 384c17.7 0 32-14.3 32-32s-14.3-32-32-32l-293.5 0zM448 160a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM325.5 128L32 128c-17.7 0-32 14.3-32 32s14.3 32 32 32l293.5 0c13.2 37.3 48.7 64 90.5 64 53 0 96-43 96-96s-43-96-96-96c-41.8 0-77.4 26.7-90.5 64z"],
    "person-cane": [448, 512, [], "e53c", "M232-32a56 56 0 1 1 0 112 56 56 0 1 1 0-112zM144 236.7L97.7 299.1c-10.5 14.2-30.6 17.2-44.8 6.6s-17.2-30.6-6.6-44.8l70.5-95C142 132 181.7 112 224 112s82 20 107.2 53.9l70.5 95c10.5 14.2 7.6 34.2-6.6 44.8s-34.2 7.6-44.8-6.6L304 236.7 304 512c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-160c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 160c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-275.3zM392 384c-4.4 0-8 3.6-8 8 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-30.9 25.1-56 56-56s56 25.1 56 56l0 128c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-128c0-4.4-3.6-8-8-8z"],
    "message-music": [512, 512, ["comment-alt-music"], "f8af", "M0 128L0 352c0 53 43 96 96 96l32 0 0 72c0 13.3 10.7 24 24 24 5.2 0 10.2-1.7 14.4-4.8l115.2-86.4c4.2-3.1 9.2-4.8 14.4-4.8l120 0c53 0 96-43 96-96l0-224c0-53-43-96-96-96L96 32C43 32 0 75 0 128zm312 0c13.3 0 24 10.7 24 24l0 16c0 13.3-10.7 24-24 24l-24 0 0 104c0 30.9-28.7 56-64 56s-64-25.1-64-56 28.7-56 64-56c5.5 0 10.9 .6 16 1.8l0-89.8c0-13.3 10.7-24 24-24l48 0z"],
    "gauge-low": [512, 512, ["tachometer-alt-slow"], "f627", "M0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zM288 96a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM256 416c35.3 0 64-28.7 64-64s-28.7-64-64-64c-1.7 0-3.4 .1-5.1 .2L181.5 149.3c-5.9-11.9-20.3-16.7-32.2-10.7s-16.7 20.3-10.7 32.2L208 309.7c-10 11.3-16 26.1-16 42.3 0 35.3 28.7 64 64 64zM128 256a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm288 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM400 144a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "hexagon-equals": [576, 512, [], "e6b2", "M33.5 291.8c-12.7-22.2-12.7-49.4 0-71.5L129.7 52.2C142.5 29.8 166.4 16 192.2 16l191.6 0c25.8 0 49.7 13.8 62.5 36.2l96.2 168.1c12.7 22.2 12.7 49.4 0 71.5L446.3 459.9c-12.8 22.4-36.7 36.2-62.5 36.2l-191.6 0c-25.8 0-49.7-13.8-62.5-36.2L33.5 291.8zM192 200c0 13.3 10.7 24 24 24l144 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-144 0c-13.3 0-24 10.7-24 24zm0 112c0 13.3 10.7 24 24 24l144 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-144 0c-13.3 0-24 10.7-24 24z"],
    "capsule": [448, 512, [], "e75a", "M189.3 189.3L290.7 290.7 363 218.5c13.5-13.5 21-31.7 21-50.7 0-39.6-32.1-71.8-71.8-71.8-19 0-37.3 7.6-50.7 21l-72.2 72.2zm219 74.5L231.8 440.2c-25.5 25.5-60 39.8-96 39.8-75 0-135.8-60.8-135.8-135.8 0-36 14.3-70.5 39.8-96L216.2 71.8c25.5-25.5 60-39.8 96-39.8 75 0 135.8 60.8 135.8 135.8 0 36-14.3 70.5-39.8 96z"],
    "user-sith": [448, 512, [], "e7b8", "M216-16c-8.8 0-16 7.2-16 16l-8 0C139 0 96 43 96 96l0 64-52.4 104.8C38.3 275.5 46 288 57.9 288l72.5 0c10.5 9.9 24.7 16 40.3 16l106.7 0c15.6 0 29.8-6.1 40.3-16l72.5 0c11.9 0 19.6-12.5 14.3-23.2L352 160 352 96c0-53-43-96-96-96l-8 0c0-8.8-7.2-16-16-16l-16 0zM176 112l16 0c8.8 0 16 7.2 16 16l0 16c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16 0-17.7 14.3-32 32-32zm128 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-16c0-8.8 7.2-16 16-16l16 0c17.7 0 32 14.3 32 32zm-64 48l0 12 43.7 32.8c2.7 2 4.3 5.2 4.3 8.5 0 5.9-4.8 10.7-10.7 10.7l-106.7 0c-5.9 0-10.7-4.8-10.7-10.7 0-3.4 1.6-6.5 4.3-8.5l43.7-32.8 0-12c0-8.8 7.2-16 16-16s16 7.2 16 16zM16 489.1C16 501.8 26.2 512 38.9 512l65.1 0 0-40c0-13.3 10.7-24 24-24s24 10.7 24 24l0 40 48 0 0-40c0-13.3 10.7-24 24-24s24 10.7 24 24l0 40 48 0 0-40c0-13.3 10.7-24 24-24s24 10.7 24 24l0 40 65.1 0c12.6 0 22.9-10.2 22.9-22.9 0-75.7-61.4-137.1-137.1-137.1l-141.7 0C77.4 352 16 413.4 16 489.1z"],
    "gauge": [512, 512, ["dashboard", "gauge-med", "tachometer-alt-average"], "f624", "M0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm320 96c0-26.9-16.5-49.9-40-59.3L280 120c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 172.7c-23.5 9.5-40 32.5-40 59.3 0 35.3 28.7 64 64 64s64-28.7 64-64zM144 176a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm-16 80a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm288 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM400 144a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "envelope-open-text": [576, 512, [], "f658", "M288 33.9L96.4 175.8 254.5 293c5.3 3.9 11.2 6.9 17.5 8.7L272 464c0 5.5 .5 10.8 1.3 16L96 480c-35.3 0-64-28.7-64-64l0-239.9c0-20.3 9.6-39.4 25.9-51.4L254.5-21c9.7-7.2 21.4-11 33.5-11s23.8 3.9 33.5 11L518.1 124.7c7.2 5.3 13.1 12 17.4 19.6-2.5-.2-5-.3-7.5-.3L436.6 144 288 33.9zM320 240c0-26.5 21.5-48 48-48l160 0c26.5 0 48 21.5 48 48l0 224c0 26.5-21.5 48-48 48l-160 0c-26.5 0-48-21.5-48-48l0-224zm80 16c-13.3 0-24 10.7-24 24s10.7 24 24 24l96 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-96 0zm0 96c-13.3 0-24 10.7-24 24s10.7 24 24 24l56 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-56 0z"],
    "toolbox": [512, 512, [129520], "f552", "M176 56l0 40 160 0 0-40c0-4.4-3.6-8-8-8L184 48c-4.4 0-8 3.6-8 8zM128 96l0-40c0-30.9 25.1-56 56-56L328 0c30.9 0 56 25.1 56 56l0 40 28.1 0c12.7 0 24.9 5.1 33.9 14.1l51.9 51.9c9 9 14.1 21.2 14.1 33.9l0 76.1-136 0 0-16c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 16-144 0 0-16c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 16-136 0 0-76.1c0-12.7 5.1-24.9 14.1-33.9l51.9-51.9c9-9 21.2-14.1 33.9-14.1L128 96zM0 416l0-96 136 0 0 16c0 13.3 10.7 24 24 24s24-10.7 24-24l0-16 144 0 0 16c0 13.3 10.7 24 24 24s24-10.7 24-24l0-16 136 0 0 96c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64z"],
    "wheat-slash": [576, 512, [], "e339", "M7-24.9c8.8-8.8 22.7-9.3 32.1-1.7l1.8 1.7 528 528 1.7 1.8c7.7 9.4 7.1 23.3-1.7 32.1s-22.7 9.3-32.1 1.7L535 537.1 7 9.1 5.4 7.2C-2.3-2.2-1.8-16.1 7-24.9zM79.2 234.6c6.2-4.1 14.7-3.4 20.1 2.1l46.1 46.1 6.1 6.7c19.7 23.8 26.3 55 19.3 83.9 31.7-7.7 66.2 1 90.6 25.3l46.1 46.1c6.2 6.2 6.2 16.4 0 22.6l-7.4 7.4c-37.5 37.5-98.3 37.5-135.7 0L133.6 444.3 48.9 529c-9.4 9.4-24.5 9.4-33.9 0-9.4-9.4-9.4-24.6 0-33.9l84.7-84.7-30.5-30.5c-37.5-37.5-37.5-98.3 0-135.7l7.4-7.4 2.5-2.1zm208-208c6.2-4.1 14.7-3.4 20.1 2.1l46.1 46.1 6.1 6.7c19.7 23.8 26.3 55 19.2 83.9 31.7-7.7 66.2 1 90.6 25.3l46.1 46.1c6.2 6.2 6.2 16.4 0 22.6l-7.4 7.4c-37.5 37.5-98.3 37.5-135.7 0l-94.9-94.9c-37.5-37.5-37.5-98.3 0-135.7l7.4-7.4 2.5-2.1zM547.1-15.7c3.1 .6 5.9 2.1 8.2 4.4 3 3 4.7 7.1 4.7 11.3l0 35-.1 4.8c-2.4 47.6-40.5 85.7-88.1 88.1l-4.8 .1-35 0c-4.2 0-8.3-1.7-11.3-4.7S416 116.2 416 112l0-35c0-51.4 41.7-93 93-93l35 0 3.1 .3z"],
    "power-off": [512, 512, [9211], "f011", "M288 0c0-17.7-14.3-32-32-32S224-17.7 224 0l0 256c0 17.7 14.3 32 32 32s32-14.3 32-32L288 0zM146.3 98.4c14.5-10.1 18-30.1 7.9-44.6s-30.1-18-44.6-7.9C43.4 92.1 0 169 0 256 0 397.4 114.6 512 256 512S512 397.4 512 256c0-87-43.4-163.9-109.7-210.1-14.5-10.1-34.4-6.6-44.6 7.9s-6.6 34.4 7.9 44.6c49.8 34.8 82.3 92.4 82.3 157.6 0 106-86 192-192 192S64 362 64 256c0-65.2 32.5-122.9 82.3-157.6z"],
    "signal": [512, 512, [128246, "signal-5", "signal-perfect"], "f012", "M488 56c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 400c0 13.3 10.7 24 24 24s24-10.7 24-24l0-400zM360 128c-13.3 0-24 10.7-24 24l0 304c0 13.3 10.7 24 24 24s24-10.7 24-24l0-304c0-13.3-10.7-24-24-24zM280 248c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 208c0 13.3 10.7 24 24 24s24-10.7 24-24l0-208zM152 320c-13.3 0-24 10.7-24 24l0 112c0 13.3 10.7 24 24 24s24-10.7 24-24l0-112c0-13.3-10.7-24-24-24zM48 384c-13.3 0-24 10.7-24 24l0 48c0 13.3 10.7 24 24 24s24-10.7 24-24l0-48c0-13.3-10.7-24-24-24z"],
    "arrows-spin": [512, 512, [], "e4bb", "M481.7 240.1c-17.6-1.2-32.9 12-34.2 29.7-3.3 47-23.6 89.4-54.8 121L361 359c-6.9-6.9-17.2-8.9-26.2-5.2S320 366.3 320 376l0 112c0 13.3 10.7 24 24 24l112 0c9.7 0 18.5-5.8 22.2-14.8s1.7-19.3-5.2-26.2l-35-35c41.7-42.2 68.9-98.8 73.4-161.8 1.2-17.6-12-32.9-29.7-34.2zM39 41L74 76c-41.7 42.2-68.9 98.8-73.4 161.8-1.2 17.6 12 32.9 29.7 34.2s32.9-12 34.2-29.7c3.3-47 23.6-89.4 54.8-121L151 153c6.9 6.9 17.2 8.9 26.2 5.2S192 145.7 192 136l0-112c0-13.3-10.7-24-24-24L56 0C46.3 0 37.5 5.8 33.8 14.8S32.2 34.1 39 41zm201-10.7c-1.2 17.6 12 32.9 29.7 34.2 47 3.3 89.4 23.6 121 54.8L359 151c-6.9 6.9-8.9 17.2-5.2 26.2S366.3 192 376 192l112 0c13.3 0 24-10.7 24-24l0-112c0-9.7-5.8-18.5-14.8-22.2S477.9 32.2 471 39L436 74c-42.2-41.7-98.8-68.9-161.8-73.4-17.6-1.2-32.9 12-34.2 29.7zM41 473l35-35c42.2 41.7 98.8 68.9 161.8 73.4 17.6 1.2 32.9-12 34.2-29.7s-12-32.9-29.7-34.2c-47-3.3-89.4-23.6-121-54.8L153 361c6.9-6.9 8.9-17.2 5.2-26.2S145.7 320 136 320L24 320c-13.3 0-24 10.7-24 24L0 456c0 9.7 5.8 18.5 14.8 22.2S34.1 479.8 41 473z"],
    "joint": [576, 512, [], "f595", "M360 0c13.3 0 24 10.7 24 24l0 19c0 40.3 16 79 44.5 107.5l21 21C469 191 480 217.4 480 245l0 19c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-19c0-14.9-5.9-29.1-16.4-39.6l-21-21C357.1 146.9 336 96 336 43l0-19c0-13.3 10.7-24 24-24zM552 288c-13.3 0-24-10.7-24-24l0-19c0-40.3-16-79-44.5-107.5l-21-21C443 97 432 70.6 432 43l0-19c0-13.3 10.7-24 24-24s24 10.7 24 24l0 19c0 14.9 5.9 29.1 16.4 39.6l21 21C554.9 141.1 576 192 576 245l0 19c0 13.3-10.7 24-24 24zM292.7 320c5.6 0 10.7 2.9 13.6 7.6L394.6 471c1.3 2.1 0 4.9-2.4 5.2-16.1 2.5-32.4 3.7-48.7 3.7l-38.1 0c-5.6 0-10.7-2.9-13.6-7.6l-79-128.4c-6-9.8 0-22.6 11.5-23.3 6.7-.4 13.4-.6 20.2-.6l48.3 0zM459.3 465.9c-6.4 1-12.7-1.9-16.1-7.4L374.1 346.1c-6.7-10.9 1.5-24.7 14.2-22.9 1.3 .2 2.6 .4 3.8 .6l136.4 21c27.3 4.2 47.4 27.7 47.4 55.3s-20.1 51.1-47.4 55.3l-69.2 10.6zM138.7 336c6.7-1.5 13.6 1.4 17.2 7.2l68.9 112c6.6 10.7-1.2 24.4-13.8 23.1-13-1.4-25.9-3.5-38.6-6.5L31.2 439.2C12.9 435 0 418.7 0 400s12.9-35 31.2-39.2L138.7 336z"],
    "down-from-line": [384, 512, ["arrow-alt-from-top"], "f349", "M384 32c0 17.7-14.3 32-32 32L32 64C14.3 64 0 49.7 0 32S14.3 0 32 0L352 0c17.7 0 32 14.3 32 32zM209 505c-9.4 9.4-24.6 9.4-33.9 0L31 361c-6.9-6.9-8.9-17.2-5.2-26.2S38.3 320 48 320l80 0 0-144c0-26.5 21.5-48 48-48l32 0c26.5 0 48 21.5 48 48l0 144 80 0c9.7 0 18.5 5.8 22.2 14.8s1.7 19.3-5.2 26.2L209 505z"],
    "tablet-rugged": [448, 512, [], "f48f", "M32 176L8.8 164.4C3.4 161.7 0 156.2 0 150.1L0 73.9c0-6.1 3.4-11.6 8.8-14.3L34.3 46.8C41.8 19.8 66.6 0 96 0L352 0c29.4 0 54.2 19.8 61.7 46.8l25.5 12.7c5.4 2.7 8.8 8.3 8.8 14.3l0 76.2c0 6.1-3.4 11.6-8.8 14.3l-23.2 11.6 0 16 23.2 11.6c5.4 2.7 8.8 8.3 8.8 14.3l0 76.2c0 6.1-3.4 11.6-8.8 14.3l-23.2 11.6 0 16 23.2 11.6c5.4 2.7 8.8 8.2 8.8 14.3l0 76.2c0 6.1-3.4 11.6-8.8 14.3l-25.5 12.7c-7.5 27-32.3 46.8-61.7 46.8L96 512c-29.4 0-54.2-19.8-61.7-46.8L8.8 452.4C3.4 449.7 0 444.2 0 438.1l0-76.2c0-6.1 3.4-11.6 8.8-14.3L32 336 32 320 8.8 308.4C3.4 305.7 0 300.2 0 294.1l0-76.2c0-6.1 3.4-11.6 8.8-14.3L32 192 32 176zM112 64c-8.8 0-16 7.2-16 16l0 352c0 8.8 7.2 16 16 16l224 0c8.8 0 16-7.2 16-16l0-352c0-8.8-7.2-16-16-16L112 64z"],
    "braille": [384, 512, [], "f2a1", "M80 144a80 80 0 1 0 0-160 80 80 0 1 0 0 160zm0 192a80 80 0 1 0 0-160 80 80 0 1 0 0 160zm0 136c-13.3 0-24-10.7-24-24s10.7-24 24-24 24 10.7 24 24-10.7 24-24 24zm0 56c44.2 0 80-35.8 80-80s-35.8-80-80-80-80 35.8-80 80 35.8 80 80 80zm248-80c0 13.3-10.7 24-24 24s-24-10.7-24-24 10.7-24 24-24 24 10.7 24 24zm56 0c0-44.2-35.8-80-80-80s-80 35.8-80 80 35.8 80 80 80 80-35.8 80-80zM304 232a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm0 104a80 80 0 1 0 0-160 80 80 0 1 0 0 160zm0-192a80 80 0 1 0 0-160 80 80 0 1 0 0 160z"],
    "basket-shopping": [576, 512, ["shopping-basket"], "f291", "M288 0c6.6 0 12.9 2.7 17.4 7.5l144 152 .5 .5 78.1 0c17.7 0 32 14.3 32 32 0 14.5-9.6 26.7-22.8 30.7L491.1 429.9c-6.5 29.3-32.5 50.1-62.5 50.1l-281.3 0c-30 0-56-20.8-62.5-50.1l-46-207.2c-13.2-3.9-22.8-16.2-22.8-30.7 0-17.7 14.3-32 32-32l78.1 0 .5-.5 144-152C275.1 2.7 281.4 0 288 0zm0 58.9L192.2 160 383.8 160 288 58.9zM208 264c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 112c0 13.3 10.7 24 24 24s24-10.7 24-24l0-112zm80-24c-13.3 0-24 10.7-24 24l0 112c0 13.3 10.7 24 24 24s24-10.7 24-24l0-112c0-13.3-10.7-24-24-24zm128 24c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 112c0 13.3 10.7 24 24 24s24-10.7 24-24l0-112z"],
    "party-bell": [512, 512, [], "e31a", "M0 224c0-123.7 100.3-224 224-224 35.3 0 68.9 8.2 98.7 22.8 19.3 9.5 29.3 28.8 29.3 47.8 0 14.5-5.7 28.3-16 38.5L109.2 336C99 346.3 85.1 352 70.7 352 51.7 352 32.3 341.9 22.8 322.7 8.2 292.9 0 259.3 0 224zM480 32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM352 448a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM96 480a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM359 167c9.4-9.4 24.6-9.4 33.9 0l8.3 8.3c16.7 16.7 38.6 27.2 62.1 29.8l27.4 3c13.2 1.5 22.7 13.3 21.2 26.5s-13.3 22.7-26.5 21.2l-27.4-3c-34.3-3.8-66.3-19.2-90.7-43.6L359 201c-9.4-9.4-9.4-24.6 0-33.9zM201 359l8.3 8.2c24.4 24.4 39.8 56.4 43.6 90.7l3 27.4c1.5 13.2-8 25-21.2 26.5s-25-8-26.5-21.2l-3-27.4c-2.6-23.5-13.1-45.4-29.8-62.1L167 393c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0zM503.5 506.3c-10.1 8.6-25.3 7.3-33.8-2.8l-8.5-10c-12.5-14.8-19.1-33.7-18.6-53 .5-16.6-12.4-30.6-29-31.6l-30-1.8c-42.5-2.5-75.3-38.3-74.2-80.8 .2-7.6-2.4-15-7.3-20.7l-8.5-10c-8.6-10.1-7.3-25.3 2.8-33.8s25.3-7.3 33.8 2.8l8.5 10c12.5 14.8 19.1 33.7 18.6 53-.5 16.6 12.4 30.6 29 31.6l30 1.8c42.5 2.5 75.3 38.3 74.2 80.8-.2 7.6 2.4 15 7.3 20.7l8.5 10c8.6 10.1 7.3 25.3-2.8 33.8z"],
    "bra": [576, 512, [], "e6cf", "M143.5 60.7c2.6-13-5.8-25.6-18.8-28.2S99.1 38.3 96.5 51.3L60.3 232.1c-27.3 26.2-44.3 63.1-44.3 103.9 0 79.5 64.5 144 144 144 49.9 0 93.9-25.4 119.8-64l16.5 0c25.8 38.6 69.8 64 119.8 64 79.5 0 144-64.5 144-144 0-40.8-17-77.7-44.3-103.9L479.5 51.3c-2.6-13-15.2-21.4-28.2-18.8s-21.4 15.2-18.8 28.2l37.3 186.6-14.7 5.9C403 274 357.4 308.1 322.7 352l-69.5 0c-34.6-43.9-80.2-78-132.3-98.8l-14.7-5.9 37.3-186.6z"],
    "car-wash": [448, 512, [], "f5e6", "M224 96c26.5 0 48-16 48-48 0-22.2-23-52-37.2-68.2-5.8-6.7-15.9-6.7-21.7 0-14.2 16.3-37.2 46.1-37.2 68.2 0 26.5 21.5 48 48 48zM145.3 208l157.5 0c6.7 0 12.6 4.1 15 10.4l26.1 69.6-239.6 0 26.1-69.6c2.3-6.2 8.3-10.4 15-10.4zM34 292.8l-1.3 3.4C13.2 307.1 0 328 0 352L0 480c0 17.7 14.3 32 32 32l16 0c17.7 0 32-14.3 32-32l0-32 288 0 0 32c0 17.7 14.3 32 32 32l16 0c17.7 0 32-14.3 32-32l0-128c0-24-13.2-44.9-32.8-55.9l-1.3-3.4-36.3-96.9c-11.7-31.2-41.6-51.9-74.9-51.9l-157.5 0c-33.3 0-63.2 20.7-74.9 51.9L34 292.8zM96 336a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm224 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM112 48C112 25.8 89-4 74.8-20.2 69-26.9 59-26.9 53.2-20.2 39-4 16 25.8 16 48 16 74.5 37.5 96 64 96s48-16 48-48zM384 96c26.5 0 48-16 48-48 0-22.2-23-52-37.2-68.2-5.8-6.7-15.9-6.7-21.7 0-14.2 16.3-37.2 46.1-37.2 68.2 0 26.5 21.5 48 48 48z"],
    "face-sunglasses": [512, 512, [], "e398", "M256 512c141.4 0 256-114.6 256-256 0-20.9-2.5-41.1-7.2-60.5l1-8.9c4.8-43-19.5-81.9-56.4-98.4-46.9-54.1-116.2-88.2-193.4-88.2S109.6 34.2 62.6 88.2C25.7 104.7 1.4 143.6 6.2 186.6l1 8.9C2.5 214.9 0 235.1 0 256 0 397.4 114.6 512 256 512zM166.7 272l-45.4 0c-32.6 0-60-24.5-63.6-56.9l-3.8-33.8C50.8 152.9 73 128 101.6 128l84.7 0c14.3 0 27 6.2 35.8 16l67.7 0c8.7-9.8 21.5-16 35.8-16l84.7 0c28.6 0 50.9 24.9 47.7 53.3l-3.8 33.8c-3.6 32.4-31 56.9-63.6 56.9l-45.4 0c-32.6 0-60-24.5-63.6-56.9l-2.6-23.1-46.2 0-2.6 23.1c-3.6 32.4-31 56.9-63.6 56.9zm-1.3 65.9c20.4 28 53.4 46.1 90.6 46.1s70.2-18.1 90.6-46.1c7.8-10.7 22.8-13.1 33.5-5.3s13.1 22.8 5.3 33.5C356.3 406 309.2 432 256 432s-100.3-26-129.4-65.9c-7.8-10.7-5.4-25.7 5.3-33.5s25.7-5.4 33.5 5.3z"],
    "bridge": [512, 512, [], "e4c8", "M32 32C14.3 32 0 46.3 0 64S14.3 96 32 96l8 0 0 64-40 0 0 112c37.6 9.4 64 43.2 64 82l0 94c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-64c0-53 43-96 96-96s96 43 96 96l0 64c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-94c0-38.8 26.4-72.6 64-82l0-112-40 0 0-64 8 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 32zM424 96l0 64-80 0 0-64 80 0zM296 96l0 64-80 0 0-64 80 0zM88 96l80 0 0 64-80 0 0-64z"],
    "arrows-from-line": [384, 512, [], "e0a4", "M214.6-22.6c-12.5-12.5-32.8-12.5-45.3 0l-64 64c-9.2 9.2-11.9 22.9-6.9 34.9S115.1 96 128 96l32 0 0 48c0 17.7 14.3 32 32 32s32-14.3 32-32l0-48 32 0c12.9 0 24.6-7.8 29.6-19.8s2.2-25.7-6.9-34.9l-64-64zM160 368l0 48-32 0c-12.9 0-24.6 7.8-29.6 19.8s-2.2 25.7 6.9 34.9l64 64c12.5 12.5 32.8 12.5 45.3 0l64-64c9.2-9.2 11.9-22.9 6.9-34.9S268.9 416 256 416l-32 0 0-48c0-17.7-14.3-32-32-32s-32 14.3-32 32zM32 224c-17.7 0-32 14.3-32 32s14.3 32 32 32l320 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 224z"],
    "up-long-to-line": [320, 512, [], "e6c6", "M288-64c17.7 0 32 14.3 32 32S305.7 0 288 0L32 0C14.3 0 0-14.3 0-32S14.3-64 32-64l256 0zM137.4 73.4c12.5-12.5 32.8-12.5 45.3 0l128 128c9.2 9.2 11.9 22.9 6.9 34.9S300.9 256 288 256l-64 0 0 272c0 26.5-21.5 48-48 48l-32 0c-26.5 0-48-21.5-48-48l0-272-64 0c-12.9 0-24.6-7.8-29.6-19.8S.2 210.5 9.4 201.4l128-128z"],
    "up-to-line": [384, 512, ["arrow-alt-to-top"], "f34d", "M0 32C0 14.3 14.3 0 32 0L352 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 64C14.3 64 0 49.7 0 32zM175 135c9.4-9.4 24.6-9.4 33.9 0L353 279c6.9 6.9 8.9 17.2 5.2 26.2S345.7 320 336 320l-80 0 0 144c0 26.5-21.5 48-48 48l-32 0c-26.5 0-48-21.5-48-48l0-144-80 0c-9.7 0-18.5-5.8-22.2-14.8S24.2 285.9 31 279L175 135z"],
    "plane-arrival": [576, 512, [128748], "f5af", "M386.6 193.1L265.9 3.7c-4.8-7.6-12.6-12.8-21.4-14.3l-43.1-7.6c-10.8-1.9-20.2 7.3-18.6 18.1l24 161.6-105-18.5-33.8-61.8C64.5 74.7 58.2 70.2 51.1 69L34 66c-9.8-1.7-18.8 5.9-18.8 15.8l.6 106.3c.2 30.9 22.4 57.3 52.9 62.7l13.5 2.4 0 0 417.6 73.6c30.5 5.4 59.5-15 64.9-45.4s-15-59.5-45.4-64.9L386.6 193.1zM224 384a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm131.2-15.3a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM32 448c-17.7 0-32 14.3-32 32s14.3 32 32 32l512 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 448z"],
    "pot-food": [640, 512, [127858], "e43f", "M112 24c0 26.5 10.5 38.7 25.9 56.1l.4 .4c16.5 18.6 37.7 42.4 37.7 87.5 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-26.5-10.5-38.7-25.9-56.1l-.4-.4C85.2 93 64 69.1 64 24 64 10.7 74.7 0 88 0s24 10.7 24 24zm112 0c0 26.5 10.5 38.7 25.9 56.1l.4 .4c16.5 18.6 37.7 42.4 37.7 87.5 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-26.5-10.5-38.7-25.9-56.1l-.4-.4C197.2 93 176 69.1 176 24 176 10.7 186.7 0 200 0s24 10.7 24 24zm208 88c50.7 0 93.6 33.7 107.4 80l-214.7 0c13.8-46.3 56.6-80 107.4-80zM77.7 320L48 320c-17.7 0-32-14.3-32-32s14.3-32 32-32l17.9 0c-.2-17.5 14-32 31.7-32l444.8 0c17.7 0 31.9 14.5 31.7 32l17.9 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-29.7 0c-20.6 64-66.1 116.7-124.7 147.2l-1.2 9.7c-2.5 20-19.5 35-39.7 35l-153.4 0c-20.2 0-37.2-15-39.7-35l-1.2-9.7C143.8 436.7 98.3 384 77.7 320z"],
    "cash-register": [512, 512, [], "f788", "M96 0C60.7 0 32 28.7 32 64s28.7 64 64 64l48 0 0 32-57 0c-31.6 0-58.5 23.1-63.3 54.4L1.1 364.1C.4 368.8 0 373.6 0 378.4L0 448c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-69.6c0-4.8-.4-9.6-1.1-14.4L488.2 214.4C483.5 183.1 456.6 160 425 160l-217 0 0-32 48 0c35.3 0 64-28.7 64-64S291.3 0 256 0L96 0zm0 48l160 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L96 80c-8.8 0-16-7.2-16-16s7.2-16 16-16zM64 424c0-13.3 10.7-24 24-24l336 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L88 448c-13.3 0-24-10.7-24-24zm48-160a24 24 0 1 1 0-48 24 24 0 1 1 0 48zm120-24a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zM160 344a24 24 0 1 1 0-48 24 24 0 1 1 0 48zM328 240a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zM256 344a24 24 0 1 1 0-48 24 24 0 1 1 0 48zM424 240a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zM352 344a24 24 0 1 1 0-48 24 24 0 1 1 0 48z"],
    "ring": [512, 512, [], "f70b", "M64 208c0 7.8 4.4 18.7 17.1 30.3 45.4-24.2 107.7-38.3 174.9-38.3s129.5 14.1 174.9 38.3c12.8-11.6 17.1-22.5 17.1-30.3 0-12.3-10.8-32-47.9-50.6-35.2-17.6-86.1-29.4-144.1-29.4s-108.9 11.8-144.1 29.4C74.8 176 64 195.7 64 208zm192 40c-47 0-89.3 7.6-122.9 19.7 33.2 12.4 75.7 20.3 122.9 20.3s89.7-7.8 122.9-20.3C345.3 255.6 303 248 256 248zM0 208C0 158.4 39.4 122.2 83.3 100.2 129.1 77.3 190.3 64 256 64s126.9 13.3 172.7 36.2c43.9 22 83.3 58.2 83.3 107.8l0 96c0 49.6-39.4 85.8-83.3 107.8-45.9 22.9-107 36.2-172.7 36.2S129.1 434.7 83.3 411.8C39.4 389.8 0 353.6 0 304l0-96z"],
    "message-xmark": [512, 512, ["comment-alt-times", "message-times"], "f4ab", "M0 128L0 352c0 53 43 96 96 96l32 0 0 72c0 13.3 10.7 24 24 24 5.2 0 10.2-1.7 14.4-4.8l115.2-86.4c4.2-3.1 9.2-4.8 14.4-4.8l120 0c53 0 96-43 96-96l0-224c0-53-43-96-96-96L96 32C43 32 0 75 0 128zm323.9 44.1c9.4 9.4 9.4 24.6 0 33.9l-33.9 33.9 33.9 33.9c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-33.9-33.9-33.9 33.9c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l33.9-33.9-33.9-33.9c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l33.9 33.9 33.9-33.9c9.4-9.4 24.6-9.4 33.9 0z"],
    "share-nodes": [512, 512, ["share-alt"], "f1e0", "M384 192c53 0 96-43 96-96s-43-96-96-96-96 43-96 96c0 5.4 .5 10.8 1.3 16L159.6 184.1c-16.9-15-39.2-24.1-63.6-24.1-53 0-96 43-96 96s43 96 96 96c24.4 0 46.6-9.1 63.6-24.1L289.3 400c-.9 5.2-1.3 10.5-1.3 16 0 53 43 96 96 96s96-43 96-96-43-96-96-96c-24.4 0-46.6 9.1-63.6 24.1L190.7 272c.9-5.2 1.3-10.5 1.3-16s-.5-10.8-1.3-16l129.7-72.1c16.9 15 39.2 24.1 63.6 24.1z"],
    "octagon-divide": [512, 512, [], "e203", "M143.4 18.8c12-12 28.3-18.7 45.3-18.7l135.6 0c17 0 33.3 6.7 45.3 18.7L493.6 143c12 12 18.7 28.3 18.7 45.3l0 135.6c0 17-6.7 33.3-18.7 45.3L369.5 493.2c-12 12-28.3 18.7-45.3 18.7l-135.6 0c-17 0-33.3-6.7-45.3-18.7L19.2 369C7.2 357 .5 340.8 .5 323.8l0-135.6c0-17 6.7-33.3 18.7-45.3L143.4 18.8zM256.4 192a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm-88 40c-13.3 0-24 10.7-24 24s10.7 24 24 24l176 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-176 0zm120 120a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "folder-arrow-up": [512, 512, ["folder-upload"], "e054", "M512 384c0 35.3-28.7 64-64 64L64 448c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l138.7 0c13.8 0 27.3 4.5 38.4 12.8l38.4 28.8c5.5 4.2 12.3 6.4 19.2 6.4L448 80c35.3 0 64 28.7 64 64l0 240zM273 167c-9.4-9.4-24.6-9.4-33.9 0l-72 72c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l31-31 0 102.1c0 13.3 10.7 24 24 24s24-10.7 24-24l0-102.1 31 31c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-72-72z"],
    "arrows-minimize": [448, 512, ["compress-arrows"], "e0a5", "M9.4 41.4c12.5-12.5 32.8-12.5 45.3 0L128 114.7 128 80c0-17.7 14.3-32 32-32s32 14.3 32 32l0 112c0 17.7-14.3 32-32 32L48 224c-17.7 0-32-14.3-32-32s14.3-32 32-32l34.7 0-73.4-73.4C-3.1 74.1-3.1 53.9 9.4 41.4zm429.3 0c12.5 12.5 12.5 32.8 0 45.3L365.3 160 400 160c17.7 0 32 14.3 32 32s-14.3 32-32 32l-112 0c-17.7 0-32-14.3-32-32l0-112c0-17.7 14.3-32 32-32s32 14.3 32 32l0 34.7 73.4-73.4c12.5-12.5 32.8-12.5 45.3 0zM48 352c-17.7 0-32-14.3-32-32s14.3-32 32-32l112 0c17.7 0 32 14.3 32 32l0 112c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-34.7-73.4 73.4c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L82.7 352 48 352zm208-32c0-17.7 14.3-32 32-32l112 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-34.7 0 73.4 73.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L320 397.3 320 432c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-112z"],
    "person-circle-exclamation": [640, 512, [], "e53f", "M280 24a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zm24 212.7L341 286.6c12.8-17.5 28.5-32.7 46.3-45l-56.2-75.7C306 132 266.3 112 224 112s-82 20-107.2 53.9l-70.5 95c-10.5 14.2-7.6 34.2 6.6 44.8s34.2 7.6 44.8-6.6L144 236.7 144 512c0 17.7 14.3 32 32 32s32-14.3 32-32l0-160c0-8.8 7.2-16 16-16s16 7.2 16 16l0 160c0 17.7 14.3 32 32 32s32-14.3 32-32l0-275.3zM496 544a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm0-100a20 20 0 1 1 0 40 20 20 0 1 1 0-40zm0-140c8.8 0 16 7.2 16 16l0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80c0-8.8 7.2-16 16-16z"],
    "binoculars": [512, 512, [], "f1e5", "M128 32l32 0c17.7 0 32 14.3 32 32l0 32-96 0 0-32c0-17.7 14.3-32 32-32zm64 96l0 320c0 17.7-14.3 32-32 32L32 480c-17.7 0-32-14.3-32-32l0-59.1c0-34.6 9.4-68.6 27.2-98.3 13.7-22.8 22.5-48.2 25.8-74.6L60.5 156c2-16 15.6-28 31.8-28l99.8 0zm227.8 0c16.1 0 29.8 12 31.8 28L459 216c3.3 26.4 12.1 51.8 25.8 74.6 17.8 29.7 27.2 63.7 27.2 98.3l0 59.1c0 17.7-14.3 32-32 32l-128 0c-17.7 0-32-14.3-32-32l0-320 99.8 0zM320 64c0-17.7 14.3-32 32-32l32 0c17.7 0 32 14.3 32 32l0 32-96 0 0-32zm-32 64l0 160-64 0 0-160 64 0z"],
    "grid-round-5": [448, 512, [], "e5de", "M28 32a28 28 0 1 0 0 56 28 28 0 1 0 0-56zM0 158a28 28 0 1 0 56 0 28 28 0 1 0 -56 0zm28 70a28 28 0 1 0 0 56 28 28 0 1 0 0-56zM0 354a28 28 0 1 0 56 0 28 28 0 1 0 -56 0zm0 98c0 15.5 12.5 28 28 28s28-12.5 28-28-12.5-28-28-28-28 12.5-28 28zm98 0c0 15.5 12.5 28 28 28s28-12.5 28-28-12.5-28-28-28-28 12.5-28 28zm126-28c-15.5 0-28 12.5-28 28s12.5 28 28 28 28-12.5 28-28-12.5-28-28-28zm70 28c0 15.5 12.5 28 28 28s28-12.5 28-28-12.5-28-28-28-28 12.5-28 28zm126-28c-15.5 0-28 12.5-28 28s12.5 28 28 28 28-12.5 28-28-12.5-28-28-28zM126 326a28 28 0 1 0 0 56 28 28 0 1 0 0-56zm70 28a28 28 0 1 0 56 0 28 28 0 1 0 -56 0zm126-28a28 28 0 1 0 0 56 28 28 0 1 0 0-56zm70 28a28 28 0 1 0 56 0 28 28 0 1 0 -56 0zM98 256a28 28 0 1 0 56 0 28 28 0 1 0 -56 0zm126-28a28 28 0 1 0 0 56 28 28 0 1 0 0-56zm70 28a28 28 0 1 0 56 0 28 28 0 1 0 -56 0zm126-28a28 28 0 1 0 0 56 28 28 0 1 0 0-56zM126 130a28 28 0 1 0 0 56 28 28 0 1 0 0-56zm70 28a28 28 0 1 0 56 0 28 28 0 1 0 -56 0zm126-28a28 28 0 1 0 0 56 28 28 0 1 0 0-56zm70 28a28 28 0 1 0 56 0 28 28 0 1 0 -56 0zM98 60a28 28 0 1 0 56 0 28 28 0 1 0 -56 0zM224 32a28 28 0 1 0 0 56 28 28 0 1 0 0-56zm70 28a28 28 0 1 0 56 0 28 28 0 1 0 -56 0zM420 32a28 28 0 1 0 0 56 28 28 0 1 0 0-56z"],
    "kip-sign": [384, 512, [], "e1c4", "M340.8 88.3c13.4-11.5 15-31.7 3.5-45.1s-31.7-15-45.1-3.5L128 186.4 128 64c0-17.7-14.3-32-32-32S64 46.3 64 64l0 168-32 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l32 0 0 168c0 17.7 14.3 32 32 32s32-14.3 32-32l0-122.4 171.2 146.7c13.4 11.5 33.6 9.9 45.1-3.5s9.9-33.6-3.5-45.1L173.2 280 352 280c13.3 0 24-10.7 24-24s-10.7-24-24-24L173.2 232 340.8 88.3z"],
    "hard-drive": [448, 512, [128436, "hdd"], "f0a0", "M64 32C28.7 32 0 60.7 0 96L0 260.1C18.1 247.4 40.2 240 64 240l320 0c23.8 0 45.9 7.4 64 20.1L448 96c0-35.3-28.7-64-64-64L64 32zM448 352c0-35.3-28.7-64-64-64L64 288c-35.3 0-64 28.7-64 64l0 64c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-64zM224 384a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm128-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "ranking-star": [576, 512, [], "e561", "M321.8 54.1L298.2 6.3c-3.9-8.3-16.1-8.6-20.4 0l-23.6 47.8-52.3 7.5c-9.3 1.4-13.3 12.9-6.4 19.8l38 37-9 52.1c-1.4 9.3 8.2 16.5 16.8 12.2l46.9-24.8 46.6 24.4c8.6 4.3 18.3-2.9 16.8-12.2l-9-52.1 38-36.6c6.8-6.8 2.9-18.3-6.4-19.8l-52.3-7.5zM256 256c-26.5 0-48 21.5-48 48l0 160c0 26.5 21.5 48 48 48l64 0c26.5 0 48-21.5 48-48l0-160c0-26.5-21.5-48-48-48l-64 0zM48 320c-26.5 0-48 21.5-48 48l0 96c0 26.5 21.5 48 48 48l64 0c26.5 0 48-21.5 48-48l0-96c0-26.5-21.5-48-48-48l-64 0zM416 432l0 32c0 26.5 21.5 48 48 48l64 0c26.5 0 48-21.5 48-48l0-32c0-26.5-21.5-48-48-48l-64 0c-26.5 0-48 21.5-48 48z"],
    "user-tie": [448, 512, [], "f508", "M224 248a120 120 0 1 1 0-240 120 120 0 1 1 0 240zm-30.5 56l61 0c9.7 0 17.5 7.8 17.5 17.5 0 4.2-1.5 8.2-4.2 11.4l-27.4 32 31 115.1 .6 0 34.6-138.5c2.2-8.7 11.1-14 19.5-10.8 61.9 23.6 105.9 83.6 105.9 153.8 0 15.1-12.3 27.4-27.4 27.4L43.4 512c-15.1 0-27.4-12.3-27.4-27.4 0-70.2 44-130.2 105.9-153.8 8.4-3.2 17.3 2.1 19.5 10.8l34.6 138.5 .6 0 31-115.1-27.4-32c-2.7-3.2-4.2-7.2-4.2-11.4 0-9.7 7.8-17.5 17.5-17.5z"],
    "square-bitcoin": [448, 512, [], "e6f2", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM192 96c8.8 0 16 7.2 16 16l0 16 16 0 0-16c0-8.8 7.2-16 16-16s16 7.2 16 16l0 16.9c36.3 5.8 64 37.2 64 75.1 0 16.2-5.1 31.3-13.8 43.7 18.1 13.9 29.8 35.8 29.8 60.3 0 42-34 76-76 76l-4 0 0 16c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-16-16 0 0 16c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-16-13.9 0c-14.4 0-26.1-11.7-26.1-26.1L136 152c0-13.3 10.7-24 24-24l16 0 0-16c0-8.8 7.2-16 16-16zm-8 80l0 56 60 0c15.5 0 28-12.5 28-28s-12.5-28-28-28l-60 0zm0 104l0 56 76 0c15.5 0 28-12.5 28-28s-12.5-28-28-28l-76 0z"],
    "ellipsis": [448, 512, ["ellipsis-h"], "f141", "M0 256a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm168 0a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm224-56a56 56 0 1 1 0 112 56 56 0 1 1 0-112z"],
    "arrow-turn-down-left": [512, 512, [], "e2e1", "M448 96c0-17.7 14.3-32 32-32s32 14.3 32 32l0 96c0 53-43 96-96 96l-306.7 0 73.4 73.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0l-128-128c-12.5-12.5-12.5-32.8 0-45.3l128-128c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3L109.3 224 416 224c17.7 0 32-14.3 32-32l0-96z"],
    "octagon-check": [512, 512, [], "e426", "M324.2 .1c17 0 33.2 6.8 45.2 18.8L493.6 142.9c12 12 18.7 28.3 18.8 45.2l0 135.6c0 17-6.8 33.2-18.8 45.2L369.5 493.2c-12 12-28.3 18.7-45.2 18.7l-135.6 0c-17 0-33.3-6.7-45.2-18.7L19.3 369C7.3 357 .5 340.8 .5 323.8l0-135.6c0-17 6.8-33.3 18.7-45.2L143.4 18.8c12-12 28.3-18.7 45.2-18.8l135.6 0zm50.2 145.7c-10.7-7.8-25.7-5.4-33.5 5.3l-119.4 164.2-52.1-52.1c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l72 72c5 5 11.8 7.5 18.8 7s13.4-4.1 17.5-9.8L379.8 179.3c7.8-10.7 5.4-25.7-5.3-33.5z"],
    "store-24": [576, 512, [], "e79b", "M30.7 72.3C37.6 48.4 59.5 32 84.4 32l344 0c24.9 0 46.8 16.4 53.8 40.3l23.4 80.2c12.8 43.7-20.1 87.5-65.6 87.5-26.3 0-49.4-14.9-60.8-37.1-11.6 21.9-34.6 37.1-61.4 37.1-26.6 0-49.7-15-61.3-37-11.6 22-34.7 37-61.3 37-26.8 0-49.8-15.1-61.4-37.1-11.4 22.1-34.5 37.1-60.8 37.1-45.6 0-78.4-43.7-65.6-87.5L30.7 72.3zM96.4 352l178 0c-1.3 5.1-2 10.5-2 16l0 112-192 0c-26.5 0-48-21.5-48-48l0-151.2c12.5 4.6 26.1 7.2 40.5 7.2 8.1 0 15.9-.8 23.5-2.4l0 66.4zm220 48c0-28.7 23.3-52 52-52s52 23.3 52 52l0 1c0 14.6-5.4 28.7-15 39.6l-31.5 35.5 26.6 0c11 0 20 9 20 20s-9 20-20 20l-58.2 0c-14.2 0-25.8-11.5-25.8-25.8 0-6.3 2.3-12.4 6.5-17.1L375.5 414c3.2-3.6 4.9-8.2 4.9-13l0-1c0-6.6-5.4-12-12-12s-12 5.4-12 12c0 11-9 20-20 20s-20-9-20-20zm128 32l0-64c0-11 9-20 20-20s20 9 20 20l0 44 24 0 0-44c0-11 9-20 20-20s20 9 20 20l0 128c0 11-9 20-20 20s-20-9-20-20l0-44-44 0c-5.3 0-10.4-2.1-14.1-5.9s-5.9-8.8-5.9-14.1z"],
    "store-slash": [576, 512, [], "e071", "M41-24.9c-9.4-9.4-24.6-9.4-33.9 0S-2.3-.3 7 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-58.6-58.6c1.1-4 1.6-8.2 1.6-12.5l0-151.2c-12.5 4.6-26.1 7.2-40.5 7.2-8.1 0-15.9-.8-23.5-2.4l0 66.4-30.2 0-137.5-137.5c2.9-3.6 5.5-7.4 7.6-11.5 11.6 22 34.7 37 61.3 37 26.8 0 49.8-15.1 61.4-37.1 11.4 22.1 34.5 37.1 60.8 37.1 45.6 0 78.4-43.7 65.6-87.5L513.8 72.3C506.8 48.4 484.9 32 460 32L116 32c-5.5 0-10.8 .8-15.9 2.3L41-24.9zM151.5 221.3L48.7 118.6 38.9 152.5c-12.8 43.7 20 87.5 65.6 87.5 18.1 0 34.7-7.1 47-18.7zM410.2 480l-128-128-154.2 0 0-66.4c-7.6 1.6-15.5 2.4-23.5 2.4-14.4 0-28-2.6-40.5-7.2L64 432c0 26.5 21.5 48 48 48l298.2 0z"],
    "percent": [448, 512, [62101, 62785, "percentage"], "25", "M192 128a96 96 0 1 0 -192 0 96 96 0 1 0 192 0zM448 384a96 96 0 1 0 -192 0 96 96 0 1 0 192 0zM438.6 86.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-384 384c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l384-384z"],
    "circle-n": [512, 512, [], "e118", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM202.6 152.8L304 276.8 304 168c0-13.3 10.7-24 24-24s24 10.7 24 24l0 176c0 10.1-6.4 19.2-15.9 22.6s-20.2 .4-26.6-7.4L208 235.2 208 344c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-176c0-10.1 6.4-19.2 15.9-22.6s20.2-.4 26.6 7.4z"],
    "file-zipper": [384, 512, ["file-archive"], "f1c6", "M0 64C0 28.7 28.7 0 64 0L213.5 0c17 0 33.3 6.7 45.3 18.7L365.3 125.3c12 12 18.7 28.3 18.7 45.3L384 448c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zm208-5.5l0 93.5c0 13.3 10.7 24 24 24L325.5 176 208 58.5zM64 72c0 13.3 10.7 24 24 24l48 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L88 48C74.7 48 64 58.7 64 72zm0 96c0 13.3 10.7 24 24 24l48 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0c-13.3 0-24 10.7-24 24zm64 72l-32 0c-17.7 0-32 14.3-32 32l0 48c0 26.5 21.5 48 48 48s48-21.5 48-48l0-48c0-17.7-14.3-32-32-32zm-16 64a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"],
    "trash-can-xmark": [448, 512, [], "e2ae", "M167.1-16l113.9 0c13.8 0 26 8.8 30.4 21.9L320 32 416 32c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 96C14.3 96 0 81.7 0 64S14.3 32 32 32l96 0 8.7-26.1C141.1-7.2 153.3-16 167.1-16zM32 144l384 0 0 304c0 35.3-28.7 64-64 64L96 512c-35.3 0-64-28.7-64-64l0-304zM291.9 252.1c-9.4-9.4-24.6-9.4-33.9 0l-33.9 33.9-33.9-33.9c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l33.9 33.9-33.9 33.9c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l33.9-33.9 33.9 33.9c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-33.9-33.9 33.9-33.9c9.4-9.4 9.4-24.6 0-33.9z"],
    "display": [512, 512, [], "e163", "M448 96l0 256-384 0 0-256 384 0zM64 32C28.7 32 0 60.7 0 96L0 352c0 35.3 28.7 64 64 64l144 0-16 48-72 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l272 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-72 0-16-48 144 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L64 32z"],
    "ellipsis-stroke": [512, 512, ["ellipsis-h-alt"], "f39b", "M64 256a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm80 0a64 64 0 1 1 -128 0 64 64 0 1 1 128 0zm112-16a16 16 0 1 0 0 32 16 16 0 1 0 0-32zm0 80a64 64 0 1 1 0-128 64 64 0 1 1 0 128zm176-80a16 16 0 1 0 0 32 16 16 0 1 0 0-32zm0 80a64 64 0 1 1 0-128 64 64 0 1 1 0 128z"],
    "air-conditioner": [576, 512, [], "f8f4", "M64 64C28.7 64 0 92.7 0 128L0 256c0 35.3 28.7 64 64 64l448 0c35.3 0 64-28.7 64-64l0-128c0-35.3-28.7-64-64-64L64 64zM88 208l400 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L88 256c-13.3 0-24-10.7-24-24s10.7-24 24-24zM208 472c0 13.3-10.7 24-24 24s-24-10.7-24-24-10.7-24-24-24-24 10.7-24 24c0 39.8 32.2 72 72 72s72-32.2 72-72l0-104-48 0 0 104zM368 368l-48 0 0 104c0 39.8 32.2 72 72 72s72-32.2 72-72c0-13.3-10.7-24-24-24s-24 10.7-24 24-10.7 24-24 24-24-10.7-24-24l0-104z"],
    "file-xls": [576, 512, [], "e64d", "M96 0C60.7 0 32 28.7 32 64l0 384c0 35.3 28.7 64 64 64l112 0 0-112c0-35.3 28.7-64 64-64l144 0 0-165.5c0-17-6.7-33.3-18.7-45.3L290.7 18.7C278.7 6.7 262.5 0 245.5 0L96 0zM357.5 176L264 176c-13.3 0-24-10.7-24-24L240 58.5 357.5 176zM292 400c0-11-9-20-20-20s-20 9-20 20c0 14.4 4.3 28.4 12.2 40.4L280 464 264.2 487.6c-8 12-12.2 26-12.2 40.4 0 11 9 20 20 20s20-9 20-20c0-6.5 1.9-12.8 5.5-18.2l6.5-9.7 6.5 9.7c3.6 5.4 5.5 11.7 5.5 18.2 0 11 9 20 20 20s20-9 20-20c0-14.4-4.3-28.4-12.2-40.4L328 464 343.8 440.4c8-12 12.2-26 12.2-40.4 0-11-9-20-20-20s-20 9-20 20c0 6.5-1.9 12.8-5.5 18.2l-6.5 9.7-6.5-9.7c-3.6-5.4-5.5-11.7-5.5-18.2zM400 548l32 0c11 0 20-9 20-20s-9-20-20-20l-12 0 0-108c0-11-9-20-20-20s-20 9-20 20l0 128c0 11 9 20 20 20zm76-116c0 28.7 23.3 52 52 52 6.6 0 12 5.4 12 12s-5.4 12-12 12l-32 0c-11 0-20 9-20 20s9 20 20 20l32 0c28.7 0 52-23.3 52-52s-23.3-52-52-52c-6.6 0-12-5.4-12-12s5.4-12 12-12l24 0c11 0 20-9 20-20s-9-20-20-20l-24 0c-28.7 0-52 23.3-52 52z"],
    "pinata": [512, 512, [], "e3c3", "M224-32c17.7 0 32 14.3 32 32l0 176 176 0c44.2 0 80 35.8 80 80l0 216c0 22.1-17.9 40-40 40l-48 0c-22.1 0-40-17.9-40-40l0-56-160 0 0 56c0 22.1-17.9 40-40 40l-48 0c-22.1 0-40-17.9-40-40l0-280-57.8-28.9C14.8 151.4 0 127.4 0 101.2 0 63 31 32 69.2 32L192 32 192 0c0-17.7 14.3-32 32-32zM448.7 332.7c-10.5-9.4-25.8-10.9-37.8-3.8l-2.3 1.6-23.5 16.9-16.4-14.7c-10.5-9.4-25.8-10.9-37.8-3.8l-2.3 1.6-23.5 16.9-16.4-14.7c-10.5-9.4-25.8-10.9-37.8-3.8l-2.3 1.6-23.5 16.9-16.4-14.7c-10.5-9.4-25.8-10.9-37.8-3.8l-2.3 1.6-34 24.4c-7.2 5.2-8.8 15.2-3.7 22.3s15.2 8.8 22.3 3.7l34-24.5 16.4 14.7 2.2 1.8c11.1 8.4 26.5 8.7 37.9 .4l23.5-16.9 16.4 14.7 2.2 1.8c11.1 8.4 26.5 8.7 37.9 .4l23.5-16.9 16.4 14.7c11.2 10.1 27.9 11 40.1 2.2l23.5-16.9 26 23.4 2.6 1.9c6.4 3.8 14.8 2.7 20-3.1s5.4-14.2 1-20.2l-2.2-2.4-26-23.3zm0-96c-10.5-9.4-25.8-10.9-37.8-3.8l-2.3 1.6-23.5 16.9-16.4-14.7c-10.5-9.4-25.8-10.9-37.8-3.8l-2.3 1.6-23.5 16.9-16.4-14.7c-10.5-9.4-25.8-10.9-37.8-3.8l-2.3 1.6-23.5 16.9-16.4-14.7c-10.5-9.4-25.8-10.9-37.8-3.8l-2.3 1.6-34 24.4c-7.2 5.2-8.8 15.2-3.7 22.3s15.2 8.8 22.3 3.7l34-24.5 16.4 14.7c11.2 10.1 27.9 11 40.1 2.2l23.5-16.9 16.4 14.7c11.2 10.1 27.9 11 40.1 2.2l23.5-16.9 16.4 14.7c11.2 10.1 27.9 11 40.1 2.2l23.5-16.9 26 23.4 2.6 1.9c6.4 3.8 14.8 2.7 20-3.1s5.4-14.2 1-20.2l-2.2-2.4-26-23.3zM168 80a24 24 0 1 0 0 48 24 24 0 1 0 0-48z"],
    "chart-fft": [512, 512, [], "e69e", "M64 64c0-17.7-14.3-32-32-32S0 46.3 0 64L0 400c0 44.2 35.8 80 80 80l400 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L80 416c-8.8 0-16-7.2-16-16L64 64zM284.6 81.7c-5.7-11.5-17.8-18.4-30.5-17.6s-23.9 9.1-28.2 21.2L153.4 288 144 288c-17.7 0-32 14.3-32 32s14.3 32 32 32l32 0c13.5 0 25.6-8.5 30.1-21.2l54.8-153.4 30.5 60.9c5.4 10.8 16.5 17.7 28.6 17.7l60.2 0 39.2 78.3c7.9 15.8 27.1 22.2 42.9 14.3s22.2-27.1 14.3-42.9l-48-96C423.2 198.8 412.1 192 400 192l-60.2 0-55.2-110.3z"],
    "circle-user-circle-exclamation": [640, 512, [], "e7a0", "M496 208c-77.5 0-144.3 45.9-174.6 112l-1.4 0-64 0c-47.4 0-88.9 25.8-111 64.2 35.2 39.2 86.2 63.8 143 63.8 7.4 0 14.6-.4 21.7-1.2 5.5 21.9 14.8 42.4 27.1 60.6-15.8 3-32.1 4.6-48.8 4.6-141.4 0-256-114.6-256-256S146.6 0 288 0c126.8 0 232.1 92.2 252.4 213.2-14.3-3.4-29.1-5.2-44.4-5.2zM288 272a72 72 0 1 0 0-144 72 72 0 1 0 0 144zm208-16a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm0 228a20 20 0 1 0 0-40 20 20 0 1 0 0 40zm0-180c-8.8 0-16 7.2-16 16l0 80c0 8.8 7.2 16 16 16s16-7.2 16-16l0-80c0-8.8-7.2-16-16-16z"],
    "phone-intercom": [512, 512, [], "e434", "M48 32C21.5 32 0 53.5 0 80L0 432c0 26.5 21.5 48 48 48l16 0c26.5 0 48-21.5 48-48l0-352c0-26.5-21.5-48-48-48L48 32zm176 0c-35.3 0-64 28.7-64 64l0 320c0 35.3 28.7 64 64 64l224 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L224 32zm24 312a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm64 24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm112-24a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM224 131.2c0-19.4 15.8-35.2 35.2-35.2l153.6 0c19.4 0 35.2 15.8 35.2 35.2l0 89.6c0 19.4-15.8 35.2-35.2 35.2l-153.6 0c-19.4 0-35.2-15.8-35.2-35.2l0-89.6z"],
    "turn-left-up": [384, 512, [], "e638", "M214.6 9.4c-12.5-12.5-32.8-12.5-45.3 0l-128 128c-9.2 9.2-11.9 22.9-6.9 34.9S51.1 192 64 192l64 0 0 160c0 88.4 71.6 160 160 160l64 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-64 0c-17.7 0-32-14.3-32-32l0-160 64 0c12.9 0 24.6-7.8 29.6-19.8s2.2-25.7-6.9-34.9l-128-128z"],
    "scarf": [512, 512, [129507], "f7c1", "M184.5 0c-48.6 0-88 39.4-88 88l0 101.5c0 23.3 9.3 45.7 25.8 62.2l117.3 117.3 17 17 17-17 111-111-113-113c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0L411.9 217.5c3-8.9 4.6-18.4 4.6-28l0-101.5c0-48.6-39.4-88-88-88l-144 0zM7.5 375c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l85.1-85.1-33.9-33.9-85.1 85.1zm48 48c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l85.1-85.1-33.9-33.9-85.1 85.1zm48 48c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l85.1-85.1c-11.3-11.3-22.6-22.6-33.9-33.9L103.5 471zm272 33.9c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-85.1-85.1c-11.3 11.3-22.6 22.6-33.9 33.9L375.5 505zm48-48c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-85.1-85.1-33.9 33.9 85.1 85.1zm48-48c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-85.1-85.1-33.9 33.9 85.1 85.1z"],
    "message-pen": [512, 512, ["comment-alt-edit", "message-edit"], "f4a4", "M0 128L0 352c0 53 43 96 96 96l32 0 0 72c0 13.3 10.7 24 24 24 5.2 0 10.2-1.7 14.4-4.8l115.2-86.4c4.2-3.1 9.2-4.8 14.4-4.8l120 0c53 0 96-43 96-96l0-224c0-53-43-96-96-96L96 32C43 32 0 75 0 128zM144.4 334.3l12.3-49.4c2.1-8.4 6.5-16.2 12.6-22.3L290.7 141.3c8.5-8.5 20-13.3 32-13.3 25 0 45.3 20.3 45.3 45.3 0 12-4.8 23.5-13.3 32L233.4 326.6c-6.2 6.2-13.9 10.5-22.3 12.6l-49.4 12.3c-1.1 .3-2.3 .4-3.5 .4-7.9 0-14.2-6.4-14.2-14.2 0-1.2 .1-2.3 .4-3.5z"],
    "icons": [512, 512, ["heart-music-camera-bolt"], "f86d", "M174.9 272c10.7 0 20.7 5.3 26.6 14.2l11.8 17.8 26.7 0c26.5 0 48 21.5 48 48l0 112c0 26.5-21.5 48-48 48L48 512c-26.5 0-48-21.5-48-48L0 352c0-26.5 21.5-48 48-48l26.7 0 11.8-17.8c5.9-8.9 15.9-14.2 26.6-14.2l61.7 0zm278.6-12c5.6-4.9 13.9-5.3 19.9-.9s8.3 12.4 5.3 19.3L440.3 368 496 368c6.7 0 12.6 4.1 15 10.4s.6 13.3-4.4 17.7l-128 112c-5.6 4.9-13.9 5.3-19.9 .9s-8.3-12.4-5.3-19.3l38.5-89.7-55.8 0c-6.7 0-12.6-4.1-15-10.4s-.6-13.3 4.4-17.7l128-112zM144 360a48 48 0 1 0 0 96 48 48 0 1 0 0-96zM483.8 .4c6.5-1.1 13.1 .4 18.5 4.4 6.1 4.5 9.7 11.7 9.7 19.2l0 152-.3 4.9c-3.3 24.2-30.5 43.1-63.7 43.1-35.3 0-64-21.5-64-48s28.7-48 64-48c5.5 0 10.9 .6 16 1.6l0-49.3-112 33.6 0 110.2-.3 4.9c-3.3 24.2-30.5 43.1-63.7 43.1-35.3 0-64-21.5-64-48s28.7-48 64-48c5.5 0 10.9 .6 16 1.6L304 72c0-10.6 7-20 17.1-23l160-48 2.7-.6zM188.9 0C226 0 256 30 256 67.1l0 6.1c0 56.1-75.2 112.1-110.3 135.3-10.8 7.1-24.6 7.1-35.4 0-35.1-23.1-110.3-79.2-110.3-135.3l0-6.1C0 30 30 0 67.1 0 88.2 0 108 9.9 120.7 26.8l7.3 9.8 7.3-9.8C148 9.9 167.8 0 188.9 0z"],
    "file-xml": [576, 512, [], "e654", "M96 0C60.7 0 32 28.7 32 64l0 384c0 35.3 28.7 64 64 64l80 0 0-112c0-35.3 28.7-64 64-64l176 0 0-165.5c0-17-6.7-33.3-18.7-45.3L290.7 18.7C278.7 6.7 262.5 0 245.5 0L96 0zM357.5 176L264 176c-13.3 0-24-10.7-24-24L240 58.5 357.5 176zM508 528c0 11 9 20 20 20l32 0c11 0 20-9 20-20s-9-20-20-20l-12 0 0-108c0-11-9-20-20-20s-20 9-20 20l0 128zM385.1 389.7c-4.6-7.7-13.8-11.4-22.5-9S348 391 348 400l0 128c0 11 9 20 20 20s20-9 20-20l0-55.8 10.9 18.1c3.6 6 10.1 9.7 17.1 9.7s13.5-3.7 17.1-9.7l10.9-18.1 0 55.8c0 11 9 20 20 20s20-9 20-20l0-128c0-9-6-16.9-14.7-19.3s-17.9 1.3-22.5 9l-30.9 51.4-30.9-51.4zM260 400c0-11-9-20-20-20s-20 9-20 20c0 14.4 4.3 28.4 12.2 40.4L248 464 232.2 487.6c-8 12-12.2 26-12.2 40.4 0 11 9 20 20 20s20-9 20-20c0-6.5 1.9-12.8 5.5-18.2l6.5-9.7 6.5 9.7c3.6 5.4 5.5 11.7 5.5 18.2 0 11 9 20 20 20s20-9 20-20c0-14.4-4.3-28.4-12.2-40.4L296 464 311.8 440.4c8-12 12.2-26 12.2-40.4 0-11-9-20-20-20s-20 9-20 20c0 6.5-1.9 12.8-5.5 18.2l-6.5 9.7-6.5-9.7c-3.6-5.4-5.5-11.7-5.5-18.2z"],
    "ruler-vertical": [256, 512, [], "f548", "M0 16C0-10.5 21.5-32 48-32l160 0c26.5 0 48 21.5 48 48l0 24-104 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l104 0 0 48-72 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l72 0 0 48-104 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l104 0 0 48-72 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l72 0 0 48-104 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l104 0 0 24c0 26.5-21.5 48-48 48L48 544c-26.5 0-48-21.5-48-48L0 16z"],
    "map-location-dot": [640, 512, ["map-marked-alt"], "f5a0", "M576 48c0-11.1-5.7-21.4-15.2-27.2s-21.2-6.4-31.1-1.4L413.5 77.5 234.1 17.6c-8.1-2.7-16.8-2.1-24.4 1.7l-128 64C70.8 88.8 64 99.9 64 112l0 352c0 11.1 5.7 21.4 15.2 27.2s21.2 6.4 31.1 1.4l116.1-58.1 173.3 57.8c-4.3-6.4-8.5-13.1-12.6-19.9-11-18.3-21.9-39.3-30-61.8l-101.2-33.7 0-284.5 128 42.7 0 99.3c31-35.8 77-58.4 128-58.4 22.6 0 44.2 4.4 64 12.5L576 48zM512 224c-66.3 0-120 52.8-120 117.9 0 68.9 64.1 150.4 98.6 189.3 11.6 13 31.3 13 42.9 0 34.5-38.9 98.6-120.4 98.6-189.3 0-65.1-53.7-117.9-120-117.9zM472 344a40 40 0 1 1 80 0 40 40 0 1 1 -80 0z"],
    "watermelon-slice": [512, 512, [], "e337", "M41.5 391c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9c115.6 115.6 302.6 116 418.3 .3S541 122.6 425.5 7c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9c96.9 96.9 97.1 253.6 .3 350.4S138.4 487.9 41.5 391zm22.3-22.3c84.4 84.4 221.1 84.4 305.5 0 84.2-84.2 84.4-220.7 .3-305.1l-4.3-4.3c-6.2-6.2-16.4-6.2-22.6 0L59.8 342.2c-6.2 6.2-6.2 16.4 0 22.6l4 4zm245.4-220c6.2-6.2 16.4-6.2 22.6 0l16 16c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-16-16c-6.2-6.2-6.2-16.4 0-22.6zm-80 80c6.2-6.2 16.4-6.2 22.6 0l16 16c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-16-16c-6.2-6.2-6.2-16.4 0-22.6zm88 8c6.2-6.2 16.4-6.2 22.6 0l16 16c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-16-16c-6.2-6.2-6.2-16.4 0-22.6zm-168 72c6.2-6.2 16.4-6.2 22.6 0l16 16c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-16-16c-6.2-6.2-6.2-16.4 0-22.6zm88 8c6.2-6.2 16.4-6.2 22.6 0l16 16c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-16-16c-6.2-6.2-6.2-16.4 0-22.6z"],
    "jack-o-lantern": [512, 512, [127875], "f30e", "M203.5 18.2l-15 60c1.2 .6 2.4 1.2 3.5 1.8 19.4-10 41-15.9 64-15.9s44.6 5.9 64 15.9c1.2-.6 2.3-1.2 3.5-1.8l-15-60C305.9 7.5 296.3 0 285.3 0L226.7 0c-11 0-20.6 7.5-23.3 18.2zM175.2 482.5c10.3-6.1 23.4-6.1 33.7 0 14.6 8.7 30.5 13.5 47.2 13.5s32.6-4.8 47.2-13.5c10.3-6.1 23.4-6.1 33.7 0 14.6 8.7 30.5 13.5 47.2 13.5 70.7 0 128-86 128-192S454.7 112 384 112c-16.7 0-32.6 4.8-47.2 13.5-10.3 6.1-23.4 6.1-33.7 0-14.6-8.7-30.5-13.5-47.2-13.5s-32.6 4.8-47.2 13.5c-10.3 6.1-23.4 6.1-33.7 0-14.6-8.7-30.5-13.5-47.2-13.5-70.7 0-128 86-128 192S57.3 496 128 496c16.7 0 32.6-4.8 47.2-13.5zM177.6 192c4.3 0 8.3 2.1 10.7 5.7l25.6 38.4c2.6 3.9 2.9 9 .6 13.1s-6.6 6.8-11.3 6.8L152 256c-4.7 0-9.1-2.6-11.3-6.8s-2-9.2 .6-13.1l25.6-38.4c2.4-3.6 6.4-5.7 10.7-5.7zM345 197.7l25.6 38.4c2.6 3.9 2.9 9 .6 13.1S364.7 256 360 256l-51.2 0c-4.7 0-9.1-2.6-11.3-6.8s-2-9.2 .6-13.1l25.6-38.4c2.4-3.6 6.4-5.7 10.6-5.7s8.3 2.1 10.6 5.7zM115.5 301c35.1 9.6 74.5 15.7 116.5 17.4l0 17.6c0 8.8 7.2 16 16 16l16 0c8.8 0 16-7.2 16-16l0-17.6c41.9-1.7 81.2-7.8 116.3-17.4 11.7-3.2 23 6.7 18.4 18-11.7 29-33.9 53.9-62.7 71.2l0-6.1c0-8.8-7.2-16-16-16l-16 0c-8.8 0-16 7.2-16 16l0 26c-15.2 3.9-31.4 6-48.1 6-16.6 0-32.7-2.1-47.9-5.9l0-26.1c0-8.8-7.2-16-16-16l-16 0c-8.8 0-16 7.2-16 16l0 6.2c-28.9-17.3-51.2-42.1-62.9-71.2-4.5-11.3 6.7-21.2 18.4-18z"],
    "candy": [640, 512, [127852], "e3e7", "M526.5 282.7L194 90.7c35-26.8 78.8-42.7 126.3-42.7 39.6 0 76.5 11 108 30.2L460.3-27.2c3.5-11.4 14.7-18.5 26.5-16.8s20.5 11.8 20.5 23.7l0 41.9 28.3-12.9c9.1-4.1 19.8-2.2 26.9 4.9s9 17.8 4.9 26.9l-12.9 28.3 41.9 0c11.9 0 22 8.7 23.7 20.5s-5.4 23-16.8 26.5L498 148c19.2 31.5 30.2 68.5 30.2 108 0 9-.6 18-1.7 26.7zm-12.3 48.4c-7.8 20.2-18.7 38.8-32 55.4l-356-205.6c7.8-20.2 18.7-38.8 32.1-55.4l356 205.6zm-67.7 90.2c-35 26.8-78.8 42.7-126.3 42.7-39.6 0-76.5-11-108-30.2L180.1 539.2c-3.5 11.4-14.7 18.5-26.5 16.8s-20.5-11.8-20.5-23.7l0-41.9-28.3 12.9c-9.1 4.1-19.8 2.2-26.9-4.9s-9-17.8-4.9-26.9l12.9-28.3-41.9 0c-11.9 0-22-8.7-23.7-20.5s5.4-23 16.8-26.5L142.4 364c-19.2-31.5-30.2-68.5-30.2-108 0-9.1 .6-18 1.7-26.8l332.6 192z"],
    "heart-crack": [512, 512, [128148, "heart-broken"], "f7a9", "M133.1 32c17.3 0 34.2 3.4 49.9 9.7l54.8 85.2-75.4 75.4c-1.5 1.5-2.4 3.6-2.3 5.8s1 4.2 2.6 5.7l112 104c2.9 2.7 7.4 2.9 10.5 .3s3.8-7 1.7-10.4l-60.4-98.1 90.7-75.6c2.6-2.1 3.5-5.7 2.4-8.8L296.4 60.6C319.6 42.3 348.6 32 378.9 32 452.4 32 512 91.6 512 165.1l0 2.6c0 112.2-139.9 242.5-212.9 298.2-12.4 9.4-27.6 14.1-43.1 14.1s-30.8-4.6-43.1-14.1C139.9 410.2 0 279.9 0 167.7l0-2.6C0 91.6 59.6 32 133.1 32z"],
    "cow": [640, 512, [128004], "f6c8", "M96 224l0 192c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-88.2c9.9 6.6 20.6 12 32 16.1l0 24.2c0 8.8 7.2 16 16 16s16-7.2 16-16l0-16.9c5.3 .6 10.6 .9 16 .9s10.7-.3 16-.9l0 16.9c0 8.8 7.2 16 16 16s16-7.2 16-16l0-24.2c11.4-4 22.1-9.4 32-16.1l0 88.2c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-160 32 32 0 49.5c0 9.5 2.8 18.7 8.1 26.6L530 427c8.8 13.1 23.5 21 39.3 21 22.5 0 41.9-15.9 46.3-38l20.3-101.6c2.6-13-.3-26.5-8-37.3l-3.9-5.5 0-81.6c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 14.4-52.9-74.1C496 86.5 452.4 64 405.9 64L144 64C77.7 64 24 117.7 24 184l0 54C9.4 249.8 0 267.8 0 288l0 17.6c0 8 6.4 14.4 14.4 14.4 31.8 0 57.6-25.8 57.6-57.6L72 184c0-24.3 12.1-45.8 30.5-58.9-4.2 10.8-6.5 22.6-6.5 34.9l0 64zM560 336a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM166.6 166.6c-4.2-4.2-6.6-10-6.6-16 0-12.5 10.1-22.6 22.6-22.6l178.7 0c12.5 0 22.6 10.1 22.6 22.6 0 6-2.4 11.8-6.6 16l-23.4 23.4C332.2 211.8 302.7 224 272 224s-60.2-12.2-81.9-33.9l-23.4-23.4z"],
    "rss": [448, 512, ["feed"], "f09e", "M0 64c0-17.7 14.3-32 32-32 229.8 0 416 186.2 416 416 0 17.7-14.3 32-32 32s-32-14.3-32-32C384 253.6 226.4 96 32 96 14.3 96 0 81.7 0 64zM0 416a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zM32 160c159.1 0 288 128.9 288 288 0 17.7-14.3 32-32 32s-32-14.3-32-32c0-123.7-100.3-224-224-224-17.7 0-32-14.3-32-32s14.3-32 32-32z"],
    "magnifying-glass": [512, 512, [128269, "search"], "f002", "M416 208c0 45.9-14.9 88.3-40 122.7L502.6 457.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L330.7 376C296.3 401.1 253.9 416 208 416 93.1 416 0 322.9 0 208S93.1 0 208 0 416 93.1 416 208zM208 352a144 144 0 1 0 0-288 144 144 0 1 0 0 288z"],
    "objects-align-left": [512, 512, [], "e3be", "M0 32L0 480c0 17.7 14.3 32 32 32s32-14.3 32-32L64 32C64 14.3 49.7 0 32 0S0 14.3 0 32zM176 64c-26.5 0-48 21.5-48 48l0 64c0 26.5 21.5 48 48 48l288 0c26.5 0 48-21.5 48-48l0-64c0-26.5-21.5-48-48-48L176 64zm0 224c-26.5 0-48 21.5-48 48l0 64c0 26.5 21.5 48 48 48l160 0c26.5 0 48-21.5 48-48l0-64c0-26.5-21.5-48-48-48l-160 0z"],
    "cloud-moon": [640, 512, [], "f6c3", "M480 0c14.6 0 28.8 1.6 42.5 4.7 7.4 1.7 13 7.8 13.9 15.4s-3 14.9-9.8 18.3c-45.4 22.6-76.6 69.5-76.6 123.6 0 76.2 61.8 138 138 138 3.7 0 7.4-.1 11.1-.4 7.6-.6 14.7 3.6 17.8 10.6s1.5 15.1-3.9 20.4c-26 25-59.1 42.7-95.9 49.9-11.1-25.3-30.2-46.3-54.1-59.8-7.6-63.4-61.6-112.6-127.1-112.6-11.2 0-22.1 1.5-32.5 4.2-4.8-4.2-9.9-8.2-15.2-11.8-.1-2.8-.2-5.6-.2-8.4 0-106 86-192 192-192zm-.1 431.9c0 44.2-35.8 80-80 80l-271.9 0c-53 0-96-43-96-96 0-47.6 34.6-87 80-94.6-.4-52.8 42.9-97.3 96-97.3 34.9 0 65.4 18.6 82.2 46.4 13-9.1 28.8-14.4 45.8-14.4 44.2 0 80 35.8 80 80 0 5.9-.6 11.7-1.9 17.2 37.4 6.7 65.8 39.4 65.8 78.7z"],
    "abacus": [576, 512, [129518], "f640", "M512 96l0 112-64 0 0-32 8 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-8 0 0-32 64 0zm-96 32l-8 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l8 0 0 32-128 0 0-32 8 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-8 0 0-32 128 0 0 32zm-160 0l-8 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l8 0 0 32-96 0 0-32 8 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-8 0 0-32 96 0 0 32zm-128 0l-8 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l8 0 0 32-64 0 0-112 64 0 0 32zM64 416l0-176 64 0 0 24-8 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l8 0 0 24-8 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l8 0 0 32-64 0zm96-32l8 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-8 0 0-24 8 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-8 0 0-24 96 0 0 24-8 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l8 0 0 24-8 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l8 0 0 32-96 0 0-32zm128-72l8 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-8 0 0-24 128 0 0 96-8 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l8 0 0 32-128 0 0-32 8 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-8 0 0-24zm160 72l8 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-8 0 0-96 64 0 0 176-64 0 0-32zM64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l448 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32z"],
    "boxes-stacked": [512, 512, [62625, "boxes", "boxes-alt"], "f468", "M224 0l0 64c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-64 32 0c35.3 0 64 28.7 64 64l0 128c0 5.5-.7 10.9-2 16l-252 0c-1.3-5.1-2-10.5-2-16l0-128c0-35.3 28.7-64 64-64l32 0zm96 512c-11.2 0-21.8-2.9-31-8 9.5-16.5 15-35.6 15-56l0-128c0-20.4-5.5-39.5-15-56 9.2-5.1 19.7-8 31-8l32 0 0 64c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-64 32 0c35.3 0 64 28.7 64 64l0 128c0 35.3-28.7 64-64 64l-128 0zM0 320c0-35.3 28.7-64 64-64l32 0 0 64c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-64 32 0c35.3 0 64 28.7 64 64l0 128c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 320z"],
    "code-branch": [448, 512, [], "f126", "M80 104a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm80-24c0 32.8-19.7 61-48 73.3l0 70.7 176 0c26.5 0 48-21.5 48-48l0-22.7c-28.3-12.3-48-40.5-48-73.3 0-44.2 35.8-80 80-80s80 35.8 80 80c0 32.8-19.7 61-48 73.3l0 22.7c0 61.9-50.1 112-112 112l-176 0 0 70.7c28.3 12.3 48 40.5 48 73.3 0 44.2-35.8 80-80 80S0 476.2 0 432c0-32.8 19.7-61 48-73.3l0-205.3C19.7 141 0 112.8 0 80 0 35.8 35.8 0 80 0s80 35.8 80 80zm232 0a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM80 456a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"],
    "ban": [512, 512, [128683, "cancel"], "f05e", "M367.2 412.5L99.5 144.8c-22.4 31.4-35.5 69.8-35.5 111.2 0 106 86 192 192 192 41.5 0 79.9-13.1 111.2-35.5zm45.3-45.3c22.4-31.4 35.5-69.8 35.5-111.2 0-106-86-192-192-192-41.5 0-79.9 13.1-111.2 35.5L412.5 367.2zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0z"],
    "person-carry-box": [384, 512, ["person-carry"], "f4cf", "M120 24A56 56 0 1 0 8 24 56 56 0 1 0 120 24zM59.1 112C26.5 112 0 138.5 0 171.1L0 272c0 30.2 14.2 58.7 38.4 76.8l76.8 57.6c8.1 6 12.8 15.5 12.8 25.6l0 80c0 17.7 14.3 32 32 32s32-14.3 32-32l0-80c0-30.2-14.2-58.7-38.4-76.8l-41.6-31.2 0-80.1 2.8 3.9c18 25.2 47.1 40.2 78.1 40.2L352 288c17.7 0 32-14.3 32-32l0-128c0-17.7-14.3-32-32-32L224 96c-17.7 0-32 14.3-32 32l0 96c-10-.3-19.3-5.2-25.1-13.4l-48.7-68.2C104.6 123.3 82.5 112 59.1 112zM0 512c0 17.7 14.3 32 32 32s32-14.3 32-32l0-84-54.4-40.8c-3.3-2.5-6.5-5.1-9.6-7.9L0 512z"],
    "circle-litecoin": [512, 512, [], "e6f4", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM216 128c13.3 0 24 10.7 24 24l0 60.5 58.9-19.6c8.4-2.8 17.4 1.7 20.2 10.1s-1.7 17.4-10.1 20.2l-69.1 23 0 89.8 88 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-112 0c-13.3 0-24-10.7-24-24l0-97.8-26.9 9c-8.4 2.8-17.4-1.7-20.2-10.1s1.7-17.4 10.1-20.2l37.1-12.4 0-76.5c0-13.3 10.7-24 24-24z"],
    "jug-detergent": [384, 512, [], "e519", "M96 24c0-13.3 10.7-24 24-24l80 0c13.3 0 24 10.7 24 24l0 24 8 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L88 96C74.7 96 64 85.3 64 72S74.7 48 88 48l8 0 0-24zM0 256c0-70.7 57.3-128 128-128l128 0c70.7 0 128 57.3 128 128l0 192c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 256zm256 0l0 96c0 17.7 14.3 32 32 32s32-14.3 32-32l0-96c0-17.7-14.3-32-32-32s-32 14.3-32 32z"],
    "floppy-disk-pen": [640, 512, [], "e182", "M128.1 32c-35.3 0-64 28.7-64 64l0 320c0 35.3 28.7 64 64 64l152.6 0 4.5-22.5c3.2-15.8 9.6-30.6 18.9-43.5-5.1 1.3-10.5 2-16.1 2-35.3 0-64-28.7-64-64s28.7-64 64-64 64 28.7 64 64c0 4.6-.5 9.1-1.4 13.4L486.1 229.9c7.8-7.8 16.6-14.2 25.9-19l0-37.7c0-17-6.7-33.3-18.7-45.3L416.1 50.7c-12-12-28.3-18.7-45.3-18.7L128.1 32zm32 96c0-17.7 14.3-32 32-32l160 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-160 0c-17.7 0-32-14.3-32-32l0-64zM332.3 467l-11.9 59.6c-.2 .9-.3 1.9-.3 2.9 0 8 6.5 14.6 14.6 14.6 1 0 1.9-.1 2.9-.3l59.6-11.9c12.4-2.5 23.8-8.6 32.7-17.5l118.9-118.9-80-80-118.9 118.9c-8.9 8.9-15 20.3-17.5 32.7zM600.1 344c22.1-22.1 22.1-57.9 0-80s-57.9-22.1-80 0l-28.8 28.8 80 80 28.8-28.8z"],
    "lips": [576, 512, [128068, 128482], "f600", "M30 220.1L132.6 97c17.4-20.9 43.3-33 70.6-33 18.3 0 36.2 5.5 51.4 15.7l33.6 22.7 33.6-22.7c15.2-10.2 33.1-15.7 51.4-15.7 27.3 0 53.1 12.1 70.6 33L546.2 220.1c17.3 20.8 17.3 50.9 0 71.7l-63 75.6C440.7 418.5 377.7 448 311.2 448L265 448c-66.5 0-129.5-29.5-172.1-80.6L30 291.8c-17.3-20.8-17.3-50.9 0-71.7zM119 240.7c-10.2 6.8-9.3 22.1 1.7 27.6l62.8 31.4c26.7 13.3 56.1 20.3 85.9 20.3l31.7 0c33.4 0 66.2-8.7 95.3-25.3l47.3-27c9.8-5.6 10.9-19.3 2.1-26.4l-54.8-43.9c-4.2-3.4-9.9-4.4-15.1-2.7l-47.3 15.8c-26.3 8.8-54.7 8.8-81 0l-48.1-16c-4.7-1.6-9.8-.9-13.9 1.9L119 240.7z"],
    "outlet": [448, 512, [], "e01c", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm0 224c0-61.1 30.8-99.1 49.7-116.6 8.8-8.2 20.7-11.4 32.6-11.4l155.3 0c12 0 23.9 3.3 32.6 11.4 18.9 17.5 49.7 55.5 49.7 116.6s-30.8 99-49.7 116.6c-8.8 8.2-20.7 11.4-32.6 11.4l-155.3 0c-12 0-23.9-3.3-32.6-11.4-18.9-17.5-49.7-55.5-49.7-116.6zm104-80c-13.3 0-24 10.7-24 24l0 32c0 13.3 10.7 24 24 24s24-10.7 24-24l0-32c0-13.3-10.7-24-24-24zm112 0c-13.3 0-24 10.7-24 24l0 32c0 13.3 10.7 24 24 24s24-10.7 24-24l0-32c0-13.3-10.7-24-24-24zM224 288c-17.7 0-32 14.3-32 32l0 16 64 0 0-16c0-17.7-14.3-32-32-32z"],
    "reply": [512, 512, [61714, "mail-reply"], "f3e5", "M204.2 18.4c12 5 19.8 16.6 19.8 29.6l0 80 112 0c97.2 0 176 78.8 176 176 0 113.3-81.5 163.9-100.2 174.1-2.5 1.4-5.3 1.9-8.1 1.9-10.9 0-19.7-8.9-19.7-19.7 0-7.5 4.3-14.4 9.8-19.5 9.4-8.8 22.2-26.4 22.2-56.7 0-53-43-96-96-96l-96 0 0 80c0 12.9-7.8 24.6-19.8 29.6s-25.7 2.2-34.9-6.9l-160-160c-12.5-12.5-12.5-32.8 0-45.3l160-160c9.2-9.2 22.9-11.9 34.9-6.9z"],
    "sun-plant-wilt": [640, 512, [], "e57a", "M160 0c-5.5 0-10.6 2.8-13.5 7.4l-1.1 2.1-24.8 55.4-56.7-21.7c-5.9-2.2-12.5-.8-17 3.7S41 58 43.2 63.9l21.7 56.7-55.4 24.8C3.7 148 0 153.7 0 160s3.7 12 9.5 14.6l55.4 24.8-21.7 56.7c-2.2 5.9-.8 12.5 3.7 17s11.1 5.9 17 3.7l56.7-21.7 24.8 55.4c2.6 5.8 8.3 9.5 14.6 9.5s12-3.7 14.6-9.5l24.8-55.4 56.8 21.7c5.9 2.2 12.5 .8 17-3.7s5.9-11.1 3.7-17l-21.7-56.7 55.4-24.8c5.8-2.6 9.5-8.3 9.5-14.6s-3.7-12-9.5-14.6l-55.4-24.8 21.7-56.7 .7-2.2c1.2-5.3-.4-10.9-4.3-14.8s-9.5-5.5-14.8-4.3l-2.2 .7-56.8 21.7-24.8-55.4C172 3.7 166.3 0 160 0zm0 96a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm32 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm376 16l0 53.4c-14.8 7.7-24 23.1-24 44.6 0 16.8 16 44 37.4 67.2 5.8 6.2 15.5 6.2 21.2 0 21.4-23.3 37.4-50.6 37.4-67.2 0-21.5-9.2-37-24-44.6l0-53.4c0-44.2-35.8-80-80-80s-80 35.8-80 80l0 22.7c-9.8-4.3-20.6-6.7-32-6.7-44.2 0-80 35.8-80 80l0 21.4c-14.8 7.6-24 23.1-24 44.6 0 16.8 16 44 37.4 67.2 5.8 6.2 15.5 6.2 21.2 0 21.4-23.3 37.4-50.6 37.4-67.2 0-21.5-9.2-37-24-44.6l0-21.4c0-17.7 14.3-32 32-32s32 14.3 32 32l0 176-424 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l576 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-104 0 0-272c0-17.7 14.3-32 32-32s32 14.3 32 32z"],
    "face-mask": [512, 512, [], "e37f", "M488.2 364l-88.2 0 0-64.8 111.9-49c0 1.9 .1 3.8 .1 5.8 0 38.6-8.5 75.2-23.8 108zm-23.3 40c-8.6 12.1-18.2 23.5-28.8 33.9-20.3 43.8-64.7 74.1-116.1 74.1l-128 0c-51.4 0-95.8-30.3-116.1-74.1-10.5-10.4-20.2-21.8-28.8-33.9l67.4 0c8.9 34.5 40.2 60 77.5 60l128 0c37.3 0 68.6-25.5 77.5-60l67.4 0zM0 256c0-1.9 0-3.9 .1-5.8l111.9 49 0 64.8-88.2 0C8.5 331.2 0 294.6 0 256zM256 0C378.3 0 480.6 85.8 506 200.4l-3.6 1.6-128 56-.8 .4c-4.2-1.5-8.8-2.4-13.6-2.4l-208 0c-4.8 0-9.3 .8-13.6 2.4l-.8-.4-128-56-3.6-1.6C31.4 85.8 133.7 0 256 0zm56 128c-13.3 0-24 10.7-24 24s10.7 24 24 24l8 0c15.6 0 30.7 5.1 43.2 14.4l6.4 4.8c10.6 8 25.6 5.8 33.6-4.8s5.8-25.6-4.8-33.6L392 152c-20.8-15.6-46-24-72-24l-8 0zm-88 24c0-13.3-10.7-24-24-24l-8 0c-26 0-51.2 8.4-72 24l-6.4 4.8c-10.6 8-12.8 23-4.8 33.6s23 12.8 33.6 4.8l6.4-4.8c12.5-9.3 27.6-14.4 43.2-14.4l8 0c13.3 0 24-10.7 24-24zM176 300l160 0c11 0 20 9 20 20s-9 20-20 20l-160 0c-11 0-20-9-20-20s9-20 20-20zm0 80l160 0c11 0 20 9 20 20s-9 20-20 20l-160 0c-11 0-20-9-20-20s9-20 20-20z"],
    "falafel": [576, 512, [129478], "e40a", "M166.6 125.5c5.9-7.1 8-16.7 5.7-25.7-3.4-13.5 3.2-27.6 15.7-33.3 8.3-3.8 14.3-11.5 16.1-20.6 2.7-13.7 14.6-23.5 28.3-23.1 9.1 .3 17.8-4 23.2-11.4 8.2-11.2 23.2-14.6 35.3-8.2 8.1 4.3 17.7 4.3 25.8 0 12.2-6.4 27.1-2.9 35.3 8.2 5.5 7.4 14.1 11.7 23.2 11.4 13.7-.4 25.7 9.4 28.3 23.1 1.8 9.1 7.8 16.8 16.1 20.6 12.5 5.7 19.2 19.8 15.7 33.3-2.3 9-.1 18.6 5.7 25.7 8.8 10.7 8.8 26.3 0 37-4 4.9-6.3 10.9-6.6 17.1-.9 .3-1.9 .6-2.8 1-28.2-10.3-59.7-2.7-80.4 18.7-29.5 3.1-54 23.3-63.6 50.7-9.6-27.4-34.1-47.5-63.6-50.7-13.8-14.3-32.3-22.4-51.6-23.2-.8-4.9-3-9.6-6.2-13.6-8.8-10.7-8.8-26.3 0-37zm85.5 201c-16.1 25.2-16.1 57.8 0 83-1.7 12.9 0 25.9 4.6 37.7-6.6 4.1-11.3 11-12.9 18.9-2.7 13.7-14.6 23.5-28.3 23.1-9.1-.3-17.8 4-23.2 11.4-8.2 11.2-23.2 14.6-35.3 8.2-8.1-4.3-17.7-4.3-25.8 0-12.2 6.4-27.1 2.9-35.3-8.2-5.5-7.4-14.1-11.7-23.2-11.4-13.7 .4-25.7-9.4-28.3-23.1-1.8-9.1-7.8-16.8-16.1-20.6-12.5-5.7-19.2-19.8-15.7-33.3 2.3-9 .1-18.6-5.7-25.7-8.8-10.7-8.8-26.3 0-37 5.9-7.1 8-16.7 5.7-25.7-3.4-13.5 3.2-27.6 15.7-33.3 8.3-3.8 14.3-11.5 16.1-20.6 2.7-13.7 14.6-23.5 28.3-23.1 9.1 .3 17.8-4 23.2-11.4 8.2-11.2 23.2-14.6 35.3-8.2 8.1 4.3 17.7 4.3 25.8 0 12.2-6.4 27.1-2.9 35.3 8.2 5.5 7.4 14.1 11.7 23.2 11.4 13.7-.4 25.7 9.4 28.3 23.1 1.5 7.9 6.2 14.7 12.9 18.9-4.6 11.8-6.3 24.8-4.6 37.7zm42.5 60c-8.8-10.7-8.8-26.3 0-37 5.9-7.1 8-16.7 5.7-25.7-3.4-13.5 3.2-27.6 15.7-33.3 8.3-3.8 14.3-11.5 16.1-20.6 2.7-13.7 14.6-23.5 28.3-23.1 9.1 .3 17.8-4 23.2-11.4 8.2-11.2 23.2-14.6 35.3-8.2 8.1 4.3 17.7 4.3 25.8 0 12.2-6.4 27.1-2.9 35.3 8.2 5.5 7.4 14.1 11.7 23.2 11.4 13.7-.4 25.7 9.4 28.3 23.1 1.8 9.1 7.8 16.8 16.1 20.6 12.5 5.7 19.2 19.8 15.7 33.3-2.3 9-.1 18.6 5.7 25.7 8.8 10.7 8.8 26.3 0 37-5.9 7.1-8 16.7-5.7 25.7 3.4 13.5-3.2 27.6-15.7 33.3-8.3 3.8-14.3 11.5-16.1 20.6-2.7 13.7-14.6 23.5-28.3 23.1-9.1-.3-17.8 4-23.2 11.4-8.2 11.2-23.2 14.6-35.3 8.2-8.1-4.3-17.7-4.3-25.8 0-12.2 6.4-27.1 2.9-35.3-8.2-5.5-7.4-14.1-11.7-23.2-11.4-13.7 .4-25.7-9.4-28.3-23.1-1.8-9.1-7.8-16.8-16.1-20.6-12.5-5.7-19.2-19.8-15.7-33.3 2.3-9 .1-18.6-5.7-25.7zM128 440a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm280-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM96 376a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"],
    "tombstone-blank": [448, 512, [129702, "tombstone-alt"], "f721", "M224 0C118 0 32 86 32 192l0 256c-17.7 0-32 14.3-32 32s14.3 32 32 32l384 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l0-256C416 86 330 0 224 0z"],
    "circle-caret-up": [512, 512, ["caret-circle-up"], "f331", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm0-352c6.7 0 13 2.8 17.6 7.7l104 112c6.5 7 8.2 17.2 4.4 25.9S369.5 320 360 320l-208 0c-9.5 0-18.2-5.7-22-14.4s-2.1-18.9 4.4-25.9l104-112c4.5-4.9 10.9-7.7 17.6-7.7z"],
    "lamp-street": [512, 512, [], "e1c5", "M176 64C114.1 64 64 114.1 64 176l0 304c0 17.7-14.3 32-32 32S0 497.7 0 480L0 176c0-97.2 78.8-176 176-176 92.7 0 168.6 71.6 175.5 162.6 80.7 13.3 144.4 76.9 157.9 157.6 2.9 17.4-11.7 31.9-29.4 31.9l-73.5 0c-7.5 41-43.4 72-86.5 72s-79-31-86.5-72L160 352c-17.7 0-32.3-14.4-29.4-31.9 13.4-80.2 76.5-143.6 156.6-157.3-6.5-55.6-53.8-98.8-111.2-98.8zM283.3 352c6.2 14.1 20.3 24 36.7 24s30.5-9.9 36.7-24l-73.3 0z"],
    "circle-b": [512, 512, [], "e0fd", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM176 168c0-13.3 10.7-24 24-24l68 0c37.6 0 68 30.4 68 68 0 12.7-3.5 24.7-9.6 34.8 15.6 12.5 25.6 31.6 25.6 53.2 0 37.6-30.4 68-68 68l-84 0c-13.3 0-24-10.7-24-24l0-176zm112 44c0-11-9-20-20-20l-44 0 0 40 44 0c11 0 20-9 20-20zM224 320l60 0c11 0 20-9 20-20s-9-20-20-20l-60 0 0 40z"],
    "butterfly": [576, 512, [], "e811", "M516.4 32C540.5 32 560 51.5 560 75.6l0 88.1c0 75.1-47.1 139.1-113.3 164.4l10.4 10.4 5.2 5.7c11.4 13.9 17.7 31.3 17.7 49.4l-.2 5.5c-1.8 25.5-16.1 48.6-38.1 61.6l-4.8 2.6-13.8 6.9c-11.1 5.5-23.1 8.7-35.5 9.5l-5.3 .2c-39.3 0-74.2-25.1-86.6-62.4l0 0-2.3-6.9-3.1-10c-.8-2.8-1.5-5.6-2.2-8.4-1.6 6.2-3.3 12.3-5.3 18.4l-2.3 6.9 0 0c-12.4 37.3-47.3 62.4-86.6 62.4-12.4 0-24.6-2.5-36-7.4l-4.8-2.2-13.8-6.9c-24.8-12.4-41-36.9-42.9-64.2l-.2-5.5c0-20.7 8.2-40.5 22.8-55.2l10.4-10.4C63 302.8 16 238.8 16 163.7l0-88.1C16 51.5 35.5 32 59.6 32l11.8 .3C175.6 37.4 262.1 110.1 287.9 207.6 314.8 106.5 406.9 32 516.4 32z"],
    "bacterium": [576, 512, [], "e05a", "M408 16c0-13.3-10.7-24-24-24S360 2.7 360 16l0 23.4c-13.9 5.3-26.9 13.5-38.2 24.5L305 47c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l16.8 16.8-30.1 30.1-16.8-16.8c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l16.8 16.8c-10 10-20 20-30.1 30.1L177 175c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l16.8 16.8-30.1 30.1-16.8-16.8c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l16.8 16.8c-11 11.3-19.2 24.3-24.5 38.2L48 328c-13.3 0-24 10.7-24 24s10.7 24 24 24l16.3 0c1.3 18.3 7.1 36.4 17.4 52.4L71 439c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l10.6-10.6c16 10.3 34.1 16.1 52.4 17.4l0 16.3c0 13.3 10.7 24 24 24s24-10.7 24-24l0-23.4c13.9-5.3 26.9-13.5 38.2-24.5L271 465c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-16.8-16.8 30.1-30.1 16.8 16.8c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-16.8-16.8c10-10 20-20 30.1-30.1L399 337c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-16.8-16.8 30.1-30.1 16.8 16.8c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-16.8-16.8c11-11.3 19.2-24.3 24.5-38.2l23.4 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-16.3 0c-1.3-18.3-7.1-36.4-17.4-52.4L505 73c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0L460.4 49.7c-16-10.3-34.1-16.1-52.4-17.4L408 16zM160 352a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM272 240a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "square-7": [448, 512, [], "e25c", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM168 144l112 0c8.3 0 16 4.3 20.4 11.4s4.8 15.9 1 23.4l-88 176c-5.9 11.9-20.3 16.7-32.2 10.7s-16.7-20.3-10.7-32.2L241.2 192 168 192c-13.3 0-24-10.7-24-24s10.7-24 24-24z"],
    "magnifying-glass-arrows-rotate": [512, 512, [], "e65e", "M73.8 155.6C69 168 57.3 175.7 44.7 176l-1.5 0c-3.6-.1-7.3-.8-10.9-2.2-16.5-6.4-24.6-25-18.2-41.4 30.2-77.4 105.6-132.4 193.8-132.4 52.9 0 101.1 19.7 137.8 52.2L375 23c6.9-6.9 17.2-8.9 26.2-5.2S416 30.3 416 40l0 112c0 13.3-10.7 24-24 24l-112 0c-9.7 0-18.5-5.8-22.2-14.8s-1.7-19.3 5.2-26.2l37.4-37.4c-25-21-57.3-33.6-92.5-33.6-61 0-113.2 37.9-134.2 91.6zM342.2 260.4c4.8-12.4 16.6-20.1 29.1-20.4l1.5 0c3.6 .1 7.3 .8 10.9 2.2 16.5 6.4 24.6 25 18.2 41.4-6.6 16.9-15.3 32.7-25.8 47.1L502.6 457.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L330.7 376c-34.4 25.2-76.8 40-122.7 40-52.9 0-101.1-19.7-137.8-52.2L41 393c-6.9 6.9-17.2 8.9-26.2 5.2S0 385.7 0 376L0 264c0-13.3 10.7-24 24-24l112 0c9.7 0 18.5 5.8 22.2 14.8s1.7 19.3-5.2 26.2l-37.4 37.4c25 21 57.3 33.6 92.5 33.6 61 0 113.2-37.9 134.2-91.6z"],
    "square-i": [448, 512, [], "e272", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm88 112l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0 0 128 48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l48 0 0-128-48 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"],
    "standard-definition": [512, 512, ["rectangle-sd"], "e28a", "M0 128C0 92.7 28.7 64 64 64l384 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64L64 448c-35.3 0-64-28.7-64-64L0 128zm96 88l0 8c0 30.9 25.1 56 56 56l32 0c4.4 0 8 3.6 8 8l0 8c0 4.4-3.6 8-8 8l-56 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l56 0c30.9 0 56-25.1 56-56l0-8c0-30.9-25.1-56-56-56l-32 0c-4.4 0-8-3.6-8-8l0-8c0-4.4 3.6-8 8-8l56 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-56 0c-30.9 0-56 25.1-56 56zm200-56c-13.3 0-24 10.7-24 24l0 144c0 13.3 10.7 24 24 24l48 0c39.8 0 72-32.2 72-72l0-48c0-39.8-32.2-72-72-72l-48 0zm24 144l0-96 24 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24l-24 0z"],
    "alien-8bit": [576, 512, [128126, "alien-monster"], "f8f6", "M96 48c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 16 48 0c8.8 0 16 7.2 16 16l0 48 128 0 0-48c0-8.8 7.2-16 16-16l48 0 0-16c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-48 0 0 64 48 0c8.8 0 16 7.2 16 16l0 48 32 0 0-80c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 128c0 8.8-7.2 16-16 16l-48 0 0 80c0 8.8-7.2 16-16 16l-48 0 0 80c0 8.8-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l48 0 0-32-192 0 0 32 48 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16l0-80-48 0c-8.8 0-16-7.2-16-16l0-80-48 0c-8.8 0-16-7.2-16-16L0 144c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 80 32 0 0-48c0-8.8 7.2-16 16-16l48 0 0-64-48 0c-8.8 0-16-7.2-16-16l0-32zm64 192l0 64c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm192 0l0 64c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16z"],
    "vacuum": [640, 512, [], "e04d", "M512 64L301.6 64c-30.2 0-56.3 21.1-62.6 50.6L174.4 416 176 416c26.5 0 48 21.5 48 48s-21.5 48-48 48l-47.3 0c-.4 0-.9 0-1.3 0L32 512c-17.7 0-32-14.3-32-32 0-5.4 1.4-10.5 3.7-15 15.4-30 46.3-49 80-49l25.2 0 67.5-314.8C189.1 42.2 241.3 0 301.6 0L512 0c70.7 0 128 57.3 128 128 0 42.8-21 80.7-53.3 104 13.6 26.4 21.3 56.3 21.3 88l0 128c0 35.3-28.7 64-64 64l-75.3 0c26.6-23.5 43.3-57.8 43.3-96 0-70.7-57.3-128-128-128-11 0-21.8 1.4-32 4l0-100c0-35.3 28.7-64 64-64 51.2 0 97.8 20.1 132.2 52.8 16.8-11.5 27.8-30.9 27.8-52.8 0-35.3-28.7-64-64-64zM384 320a96 96 0 1 1 0 192 96 96 0 1 1 0-192zm0 128a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "bowl-chopsticks-noodles": [512, 512, [], "e2ea", "M96 78L13.1 93.6c-7.6 1.4-13.1 8-13.1 15.7 0 9.8 8.8 17.3 18.5 15.8l77.5-12.1 0 28-80.3 2.5C7 143.8 0 151 0 159.7 0 168.7 7.3 176 16.2 176l79.8 0 0 48-62.4 0C15.4 224 .9 239.3 2 257.5 7.4 349.3 61.6 427.2 138.4 467.2l1.2 9.7c2.5 20 19.5 35 39.7 35l153.4 0c20.2 0 37.2-15 39.7-35l1.2-9.7c76.8-40 131-118 136.4-209.7 1.1-18.2-13.4-33.5-31.6-33.5L240 224 240 40c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 184-48 0 0-168c0-13.3-10.7-24-24-24S96 42.7 96 56l0 22zm192 57l0 41 200.4 0c13 0 23.6-10.6 23.6-23.6 0-13.3-11-24-24.4-23.6L288 135zm0-93l0 41 204.3-31.9c11.3-1.8 19.7-11.5 19.7-23 0-14.6-13.3-25.6-27.6-22.9L288 42z"],
    "record-vinyl": [512, 512, [], "f8d9", "M0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm256-96a96 96 0 1 1 0 192 96 96 0 1 1 0-192zm0 240a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm0-112a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "floppy-disk": [448, 512, [128190, 128426, "save"], "f0c7", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-242.7c0-17-6.7-33.3-18.7-45.3L352 50.7C340 38.7 323.7 32 306.7 32L64 32zm32 96c0-17.7 14.3-32 32-32l160 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-160 0c-17.7 0-32-14.3-32-32l0-64zM224 288a64 64 0 1 1 0 128 64 64 0 1 1 0-128z"],
    "down-left": [448, 512, [], "e16a", "M64.5 448l272 0c12.9 0 24.6-7.8 29.6-19.8s2.2-25.7-6.9-34.9l-78.1-78.1 137.4-137.4c18.7-18.7 18.7-49.1 0-67.9l-48-48c-18.7-18.7-49.1-18.7-67.9 0L165.2 199.4 87.1 121.4c-9.2-9.2-22.9-11.9-34.9-6.9S32.5 131.1 32.5 144l0 272c0 17.7 14.3 32 32 32z"],
    "toilets-portable": [512, 512, [], "e584", "M64 0l96 0c35.3 0 64 28.7 64 64l0 16-224 0 0-16C0 28.7 28.7 0 64 0zM0 128l224 0 0 360c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-8-128 0 0 8c0 13.3-10.7 24-24 24S0 501.3 0 488L0 128zM128 248l0 48c0 13.3 10.7 24 24 24l24 0 0-96-24 0c-13.3 0-24 10.7-24 24zM352 0l96 0c35.3 0 64 28.7 64 64l0 16-224 0 0-16c0-35.3 28.7-64 64-64zM288 128l224 0 0 360c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-8-128 0 0 8c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-360zM416 248l0 48c0 13.3 10.7 24 24 24l24 0 0-96-24 0c-13.3 0-24 10.7-24 24z"],
    "o": [448, 512, [111], "4f", "M224 96a160 160 0 1 0 0 320 160 160 0 1 0 0-320zM448 256a224 224 0 1 1 -448 0 224 224 0 1 1 448 0z"],
    "palette": [512, 512, [127912], "f53f", "M512 256c0 .9 0 1.8 0 2.7-.4 36.5-33.6 61.3-70.1 61.3L344 320c-26.5 0-48 21.5-48 48 0 3.4 .4 6.7 1 9.9 2.1 10.2 6.5 20 10.8 29.9 6.1 13.8 12.1 27.5 12.1 42 0 31.8-21.6 60.7-53.4 62-3.5 .1-7 .2-10.6 .2-141.4 0-256-114.6-256-256S114.6 0 256 0 512 114.6 512 256zM128 288a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm0-96a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM288 96a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm96 96a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "paintbrush-fine-slash": [576, 512, [], "e74d", "M41-24.9c-9.4-9.4-24.6-9.4-33.9 0S-2.3-.3 7 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9L366.2 300.3 557.3 109.3c25-25 25-65.5 0-90.5s-65.5-25-90.5 0L275.7 209.8 41-24.9zM176 288c-61.9 0-112 50.1-112 112 0 3.9 .2 7.8 .6 11.6 1.8 17.5-10.2 36.4-27.8 36.4L32 448c-17.7 0-32 14.3-32 32s14.3 32 32 32l144 0c61.9 0 112-50.1 112-112 0-21.6-6.1-41.8-16.7-58.9l-36.4-36.4C217.8 294.1 197.6 288 176 288z"],
    "blueberries": [512, 512, [], "e2e8", "M512 176c0-97.2-78.8-176-176-176-80.6 0-148.6 54.2-169.4 128.2 3.1-.1 6.3-.2 9.4-.2 114.9 0 208 93.1 208 208 0 3.2-.1 6.3-.2 9.4 74-20.8 128.2-88.8 128.2-169.4zM176 512a176 176 0 1 0 0-352 176 176 0 1 0 0 352zm0-304c8.8 0 16 7.2 16 16l0 32 32 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-32 0 0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-32-32 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l32 0 0-32c0-8.8 7.2-16 16-16zM384 64l0 32 32 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-32 0 0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-32-32 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l32 0 0-32c0-8.8 7.2-16 16-16s16 7.2 16 16z"],
    "fish-bones": [576, 512, [], "e304", "M87.1 148.2c5.6 4.6 8.9 11.4 8.9 18.7l0 41.1 0 0 0 24 40 0 0-72c0-13.3 10.7-24 24-24s24 10.7 24 24l0 72 48 0 0-72c0-13.3 10.7-24 24-24s24 10.7 24 24l0 72 48 0 0-72c0-13.3 10.7-24 24-24s24 10.7 24 24l0 72 40 0 0-101.1c0-16.9 17.1-28.4 31.8-20 16 9.1 30.6 19.7 43.7 30.7 39.1 33 66.9 72.4 81 99.8 4.7 9.2 4.7 20.1 0 29.3-14.1 27.4-41.9 66.8-81 99.8-13.1 11-27.7 21.6-43.7 30.7-14.7 8.4-31.8-3.1-31.8-20l0-101.1-40 0 0 72c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-72-48 0 0 72c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-72-48 0 0 72c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-72-40 0 0 24 0 0 0 41.1c0 7.2-3.3 14.1-8.9 18.7l-48 38.9c-8.8 7.1-21.3 7.1-30.1 .1s-11.5-19.2-6.6-29.3L54.9 266.6c3.3-6.7 3.3-14.5 0-21.2L2.5 138.6c-5-10.1-2.2-22.3 6.6-29.3s21.3-7 30.1 .1l48 38.9z"],
    "unlock": [384, 512, [128275], "f09c", "M128 96c0-35.3 28.7-64 64-64 31.7 0 58 23 63.1 53.3 2.9 17.4 19.4 29.2 36.9 26.3s29.2-19.4 26.3-36.9C308.1 14.1 255.5-32 192-32 121.3-32 64 25.3 64 96l0 64c-35.3 0-64 28.7-64 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-224c0-35.3-28.7-64-64-64l-192 0 0-64z"],
    "fan-table": [448, 512, [], "e004", "M256 413.6C355.7 398.2 432 312 432 208 432 93.1 338.9 0 224 0S16 93.1 16 208c0 104 76.3 190.2 176 205.6l0 34.4-96 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l256 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-96 0 0-34.4zM184.9 68.5L224.3 166c18.5-25.3 50-39.8 83.3-35.1 48.1 6.8 81.7 51.3 74.9 99.4-1.2 8.8-9.3 14.8-18.1 13.6L260.2 229.2c12.6 28.7 9.5 63.2-11.2 89.7-29.9 38.3-85.2 45.1-123.5 15.2-7-5.4-8.2-15.5-2.8-22.5l64.8-82.9c-31.2-3.4-59.5-23.4-72.1-54.5-18.2-45.1 3.6-96.4 48.6-114.6 8.2-3.3 17.5 .6 20.8 8.8zM224 224a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"],
    "ear-listen": [512, 512, ["assistive-listening-systems"], "f2a2", "M379.6 .3c-8.9 1.2-17.2 6.2-22.4 14.1-6.8 10.4-7 24.1-.4 34.6 5.6 8.9 15.5 12.7 23.8 18.5 7.5 5.2 17.6 13.2 27.7 24.2 20 21.7 39.5 54.3 39.5 100.3 0 17.7 14.3 32 32 32s32-14.3 32-32c0-66-28.5-113.4-56.5-143.7-13.9-15.1-27.8-26.1-38.3-33.3-11-7.6-23.5-16.6-37.6-14.7zM240 128c-57.6 0-105.1 43.6-111.3 99.5-1.9 17.6-17.8 30.2-35.3 28.3s-30.2-17.8-28.3-35.3c9.7-88 84.3-156.5 174.9-156.5 97.2 0 176 78.8 176 176 0 46-17.7 87.9-46.6 119.3-12 13-17.4 24.8-17.4 34.7l0 6.1c0 61.9-50.1 112-112 112-17.7 0-32-14.3-32-32s14.3-32 32-32c26.5 0 48-21.5 48-48l0-6.1c0-32.9 17.4-59.6 34.4-78 18.4-20 29.6-46.6 29.6-75.9 0-61.9-50.1-112-112-112zM0 480a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm160-96a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM86.6 361.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l64 64c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-64-64zM240 208c-17.7 0-32 14.3-32 32 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-44.2 35.8-80 80-80s80 35.8 80 80c0 13.3-10.7 24-24 24s-24-10.7-24-24c0-17.7-14.3-32-32-32z"],
    "code-pull-request": [512, 512, [], "e13c", "M328 24c0-9.7-5.8-18.5-14.8-22.2S293.9 .2 287 7L231 63c-9.4 9.4-9.4 24.6 0 33.9l56 56c6.9 6.9 17.2 8.9 26.2 5.2S328 145.7 328 136l0-24 24 0c17.7 0 32 14.3 32 32l0 214.7c-28.3 12.3-48 40.5-48 73.3 0 44.2 35.8 80 80 80s80-35.8 80-80c0-32.8-19.7-61-48-73.3L448 144c0-53-43-96-96-96l-24 0 0-24zM72 80a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm56 73.3c28.3-12.3 48-40.5 48-73.3 0-44.2-35.8-80-80-80S16 35.8 16 80c0 32.8 19.7 61 48 73.3l0 205.3c-28.3 12.3-48 40.5-48 73.3 0 44.2 35.8 80 80 80s80-35.8 80-80c0-32.8-19.7-61-48-73.3l0-205.3zM72 432a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm344-24a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"],
    "thumbtack-angle": [512, 512, [], "e751", "M297.9 9.4c12.5-12.5 32.8-12.5 45.3 0l160 160c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0l-10.5-10.5-98.2 114.6c11.9 40 8.8 84-10.7 123.2l-1.4 2.8c-4.6 9.2-13.3 15.6-23.5 17.3s-20.5-1.7-27.8-9L59.5 226.7c-7.3-7.3-10.6-17.6-9-27.8s8.1-18.9 17.3-23.5l2.8-1.4c39.1-19.6 83.1-22.7 123.2-10.7l114.6-98.2-10.5-10.5c-12.5-12.5-12.5-32.8 0-45.3zm-288 448L116 351.2 161.3 396.5 55.1 502.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3z"],
    "key": [512, 512, [128273], "f084", "M336 352c97.2 0 176-78.8 176-176S433.2 0 336 0 160 78.8 160 176c0 18.7 2.9 36.8 8.3 53.7L7 391c-4.5 4.5-7 10.6-7 17l0 80c0 13.3 10.7 24 24 24l80 0c13.3 0 24-10.7 24-24l0-40 40 0c13.3 0 24-10.7 24-24l0-40 40 0c6.4 0 12.5-2.5 17-7l33.3-33.3c16.9 5.4 35 8.3 53.7 8.3zM376 96a40 40 0 1 1 0 80 40 40 0 1 1 0-80z"],
    "snake": [512, 512, [128013], "f716", "M483.4 65.7L403.6 25.8c-30.8-15.4-68-9.4-92.3 15L288 64 176 64C96.5 64 32 128.5 32 208S96.5 352 176 352l144 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-208.4 0c-10.3 0-20.6 1.7-30.4 4.9l-66 22C6.1 446 0 454.4 0 464s6.1 18 15.2 21.1l66 22c9.8 3.3 20 4.9 30.4 4.9L320 512c70.7 0 128-57.3 128-128S390.7 256 320 256l-144 0c-26.5 0-48-21.5-48-48s21.5-48 48-48l112 0 23.2 23.2c24.3 24.3 61.5 30.4 92.3 15l79.8-39.9c17.5-8.8 28.6-26.7 28.6-46.3s-11.1-37.5-28.6-46.3zM352 80a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm16 48a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"],
    "circle-waveform-lines": [512, 512, ["waveform-circle"], "e12d", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM240 152l0 208c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-208c0-13.3 10.7-24 24-24s24 10.7 24 24zm96 48l0 112c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-112c0-13.3 10.7-24 24-24s24 10.7 24 24zM144 216l0 80c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-80c0-13.3 10.7-24 24-24s24 10.7 24 24zm288 16l0 48c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-48c0-13.3 10.7-24 24-24s24 10.7 24 24z"],
    "empty-set": [512, 512, [8709, 216], "f656", "M502.6 54.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L413 53.8C369.6 20.1 315.2 0 256 0 114.6 0 0 114.6 0 256 0 315.2 20.1 369.6 53.8 413L9.4 457.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L99 458.2c43.3 33.7 97.8 53.8 157 53.8 141.4 0 256-114.6 256-256 0-59.2-20.1-113.6-53.8-157l44.4-44.4zM367.2 99.5L99.5 367.2C77.1 335.9 64 297.5 64 256 64 150 150 64 256 64 297.5 64 335.9 77.1 367.2 99.5zm-222.5 313L412.5 144.8c22.4 31.4 35.5 69.8 35.5 111.2 0 106-86 192-192 192-41.5 0-79.9-13.1-111.2-35.5z"],
    "circle-won": [512, 512, [], "e6ec", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM128.7 145.1c12.6-4 26.1 3 30.2 15.6l30.4 95.3 19.3 0 24.3-94c2.7-10.6 12.2-17.9 23.1-18s20.5 7.2 23.3 17.8l25.4 94.2 19.3 0 29.2-95.1c3.9-12.7 17.3-19.8 30-15.9s19.8 17.3 15.9 30L374 256 384 256c8.8 0 16 7.2 16 16s-7.2 16-16 16l-19.8 0-29.2 95.1c-3.1 10.2-12.7 17.1-23.4 16.9s-20-7.4-22.7-17.8l-25.4-94.2-13.7 0-24.3 94c-2.7 10.4-11.9 17.7-22.6 18s-20.3-6.5-23.5-16.7l-30.4-95.3-21 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l10.8 0-25.7-80.7c-4-12.6 3-26.1 15.6-30.2zm71.2 144.2l.4-1.4-.8 0 .4 1.4zm113.7 0l.4-1.4-.8 0 .4 1.4z"],
    "hockey-stick": [512, 512, [], "e7e6", "M96 512l-32 0c-17.7 0-32-14.3-32-32l0-128c0-17.7 14.3-32 32-32l32 0 0 192zM450.3-11.9c6.6-16.4 25.2-24.4 41.6-17.8s24.4 25.2 17.8 41.6L333.8 451.7c-14.6 36.4-49.9 60.3-89.2 60.3l-100.7 0 0-192 173.5 0 132.7-331.9z"],
    "monkey": [576, 512, [128018], "f6fb", "M160 416c0-89.7 61.4-165 144.5-186.1 24.6 35.1 65.4 58.1 111.5 58.1 9.8 0 19.4-1 28.7-3L526.5 363c31.6 30.2 49.5 72 49.5 115.7l0 1.2c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-1.2c0-26.2-10.7-51.3-29.7-69.4l-66.3-63.3 0 101.9 32 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-288 0C71.6 512 0 440.4 0 352L0 110.1C0 49.3 49.3 0 110.1 0l10.4 0c57.2 0 102.8 47.8 100.1 104.9-2.3 48.2-38.6 88-86.4 94.6l-1.9 .3c-17.5 2.4-33.7-9.8-36.1-27.3s9.8-33.7 27.3-36.1l1.9-.3c17.3-2.4 30.4-16.7 31.2-34.2 1-20.6-15.5-37.9-36.2-37.9l-10.4 0C84.7 64 64 84.7 64 110.1L64 352c0 53 43 96 96 96l0-32zM416 256c-29.3 0-55.9-12.2-74.8-31.7-9-9.3-16.2-20.2-21.3-32.3-35.3 0-64-28.7-64-64s28.6-64 64-64c15.7-37.6 52.8-64 96-64s80.4 26.4 96 64c35.3 0 64 28.7 64 64s-28.6 64-64 64c-15.7 37.6-52.8 64-96 64zM384 64c-26.5 0-48 21.5-48 48 0 20.8 13.2 38.4 31.6 45.1 4.7 1.7 8.4 5.9 8.4 10.9 0 22.1 17.9 40 40 40s40-17.9 40-40c0-5 3.7-9.2 8.4-10.9 18.5-6.7 31.6-24.4 31.6-45.1 0-26.5-21.5-48-48-48l-64 0zm0 32a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm48 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"],
    "forklift": [576, 512, [], "f47a", "M512 32l0 384 32 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-416c0-17.7 14.3-32 32-32s32 14.3 32 32zM160 160l64 96 90.4 0-68.6-160-85.8 0 0 64zm-64 0l0-80c0-26.5 21.5-48 48-48l112.3 0c19.2 0 36.6 11.4 44.1 29.1l79.7 185.9c2.5 5.8 3.9 12.2 3.9 18.9l0 90.3c19.5 16.1 32 40.6 32 67.9 0 48.6-39.4 88-88 88-40.3 0-74.2-27.1-84.7-64l-70.6 0c-10.4 36.9-44.4 64-84.7 64-48.6 0-88-39.4-88-88L0 224c0-35.3 28.7-64 64-64l32 0zm32 264a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zm240 0a40 40 0 1 0 -80 0 40 40 0 1 0 80 0z"],
    "skull": [512, 512, [128128], "f54c", "M416 427.4c58.5-44 96-111.6 96-187.4 0-132.5-114.6-240-256-240S0 107.5 0 240c0 75.8 37.5 143.4 96 187.4L96 464c0 26.5 21.5 48 48 48l32 0 0-40c0-13.3 10.7-24 24-24s24 10.7 24 24l0 40 64 0 0-40c0-13.3 10.7-24 24-24s24 10.7 24 24l0 40 32 0c26.5 0 48-21.5 48-48l0-36.6zM96 256a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zm256-64a64 64 0 1 1 0 128 64 64 0 1 1 0-128z"],
    "sneaker": [640, 512, [], "e6da", "M0 157.7l0 194.3 640 0 0-19.6c0-62.6-45.2-116-107-126.3l-83.4-13.9c-.2 .2-.4 .5-.7 .7l-48 48c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l40.2-40.1-37.3-22.9c-.3 .3-.6 .7-1 1l-48 48c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l40.9-40.9-80.2-49.4c-5-3.1-10.8-4.7-16.8-4.7L224 64c-17.7 0-32 14.3-32 32l0 72c0 30.9-25.1 56-56 56l-5.4 0c-21.2 0-40.6-12-50.1-31L56.2 144.4C51.2 134.3 40.9 128 29.7 128 13.3 128 0 141.3 0 157.7zM640 400L0 400c0 26.5 21.5 48 48 48l544 0c26.5 0 48-21.5 48-48z"],
    "gamepad-modern": [576, 512, [127918, 63676, "gamepad-alt"], "e5a2", "M384 32c106 0 192 86 192 192l0 163c0 51.3-41.6 93-93 93-40 0-75.6-25.6-88.2-63.6l-10.8-32.4-192 0-10.8 32.4C168.5 454.4 133 480 93 480 41.6 480 0 438.4 0 387L0 224C0 118 86 32 192 32l192 0zM160 144c-13.3 0-24 10.7-24 24l0 32-32 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l32 0 0 32c0 13.3 10.7 24 24 24s24-10.7 24-24l0-32 32 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-32 0 0-32c0-13.3-10.7-24-24-24zm240 96a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm64-96a32 32 0 1 0 0 64 32 32 0 1 0 0-64z"],
    "square-k": [448, 512, [], "e274", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM311.4 186.4l-67.3 56.1 70.6 86.2c8.4 10.3 6.9 25.4-3.4 33.8s-25.4 6.9-33.8-3.4l-70.3-85.9-31.1 25.9 0 44.8c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-176c0-13.3 10.7-24 24-24s24 10.7 24 24l0 68.8 104.6-87.2c10.2-8.5 25.3-7.1 33.8 3.1s7.1 25.3-3.1 33.8z"],
    "comment-text": [512, 512, [], "e14d", "M256 480c141.4 0 256-107.5 256-240S397.4 0 256 0 0 107.5 0 240c0 54.3 19.2 104.3 51.6 144.5L2.8 476.8c-4.8 9-3.3 20 3.6 27.5s17.8 9.8 27.1 5.8l118.4-50.7C183.7 472.6 218.9 480 256 480zM184 144l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0 0 120c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-120-48 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"],
    "mars-stroke-up": [384, 512, [9896, "mars-stroke-v"], "f22a", "M192 256a112 112 0 1 0 0 224 112 112 0 1 0 0-224zM16 368c0-86.3 62.1-158.1 144.1-173.1-.1-.9-.1-1.9-.1-2.9l0-16-32 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l32 0 0-61.4-28 22.4c-13.8 11-33.9 8.8-45-5s-8.8-33.9 5-45l80-64c11.7-9.3 28.3-9.3 40 0l80 64c13.8 11 16 31.2 5 45s-31.2 16-45 5l-28-22.4 0 61.4 32 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32 0 0 16c0 1 0 1.9-.1 2.9 82 15 144.1 86.8 144.1 173.1 0 97.2-78.8 176-176 176S16 465.2 16 368z"],
    "cowbell": [448, 512, [], "f8b3", "M184 32l80 0c4.4 0 8 3.6 8 8l0 24-96 0 0-24c0-4.4 3.6-8 8-8zm-56 8l0 24c-28.5 .6-53.3 20-60.6 47.7l-66 251C.5 366.2 0 369.8 0 373.5 0 397 19 416 42.5 416l363 0c23.5 0 42.5-19 42.5-42.5 0-3.6-.5-7.3-1.4-10.8l-66-251C373.3 84 348.5 64.6 320 64l0-24c0-30.9-25.1-56-56-56l-80 0c-30.9 0-56 25.1-56 56zm96 472c32.8 0 61-19.7 73.3-48l-146.7 0c12.3 28.3 40.5 48 73.3 48z"],
    "fire-flame-simple": [384, 512, ["burn"], "f46a", "M372.5 256.5l-.7-1.9C337.8 160.8 282 76.5 209.1 8.5l-3.3-3C202.1 2 197.1 0 192 0s-10.1 2-13.8 5.5l-3.3 3C102 76.5 46.2 160.8 12.2 254.6l-.7 1.9C3.9 277.3 0 299.4 0 321.6 0 426.7 86.8 512 192 512s192-85.3 192-190.4c0-22.2-3.9-44.2-11.5-65.1zm-90.8 49.5c4.1 9.3 6.2 19.4 6.2 29.5 0 53-43 96.5-96 96.5s-96-43.5-96-96.5c0-10.1 2.1-20.3 6.2-29.5l1.9-4.3c15.8-35.4 37.9-67.7 65.3-95.1l8.9-8.9c3.6-3.6 8.5-5.6 13.6-5.6s10 2 13.6 5.6l8.9 8.9c27.4 27.4 49.6 59.7 65.3 95.1l1.9 4.3z"],
    "tree": [448, 512, [127794], "f1bb", "M224-32c7 0 13.7 3.1 18.3 8.5l136 160c6.1 7.1 7.4 17.1 3.5 25.6S369.4 176 360 176l-24.9 0 75.2 88.5c6.1 7.1 7.4 17.1 3.5 25.6S401.4 304 392 304l-38.5 0 88.8 104.5c6.1 7.1 7.4 17.1 3.5 25.6S433.4 448 424 448l-168 0 0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64-168 0c-9.4 0-17.9-5.4-21.8-13.9s-2.6-18.5 3.5-25.6L94.5 304 56 304c-9.4 0-17.9-5.4-21.8-13.9s-2.6-18.5 3.5-25.6L112.9 176 88 176c-9.4 0-17.9-5.4-21.8-13.9s-2.6-18.5 3.5-25.6l136-160C210.3-28.9 217-32 224-32z"],
    "gauge-simple-min": [512, 512, ["tachometer-slowest"], "f62d", "M0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm320 96c0-35.3-28.7-64-64-64-14.5 0-27.8 4.8-38.5 12.9L108.3 235.4c-11.4-6.8-26.1-3.1-32.9 8.2s-3.1 26.1 8.2 32.9l109.1 65.5c-.5 3.2-.8 6.6-.8 9.9 0 35.3 28.7 64 64 64s64-28.7 64-64z"],
    "comments-question-check": [576, 512, [], "e14f", "M192 320c106 0 192-78.8 192-176S298-32 192-32 0 46.8 0 144c0 39.6 14.3 76.2 38.4 105.6L2.8 316.8C-2.1 326.1-.4 337.5 7 345s18.9 9.2 28.2 4.2L116.8 306c23.1 9 48.5 14 75.2 14zm3.2 48c16.4 81.9 94.7 144 188.8 144 26.7 0 52.1-5 75.2-14l81.6 43.2c9.3 4.9 20.7 3.2 28.2-4.2s9.2-18.9 4.2-28.2l-35.6-67.2c24.1-29.4 38.4-66 38.4-105.6 0-82.4-61.7-151.5-145-170.7-6.6 66.5-43.8 122.9-96.9 159.2 1 .7 1.9 1.4 2.7 2.3 4.4 .9 8.5 3.4 11.4 7.3l20.6 27.4 58.9-94.2c7-11.2 21.8-14.7 33.1-7.6s14.7 21.8 7.6 33.1l-80 128c-4.2 6.7-11.4 10.9-19.3 11.3s-15.5-3.2-20.2-9.6l-48-64c-2.9-3.8-4.4-8.2-4.7-12.6-30.9 13.9-65.2 21.8-100.9 22.2zM192 72c-16.1 0-29.2 13.1-29.2 29.2 0 13.3-10.7 24-24 24s-24-10.7-24-24C114.8 58.6 149.4 24 192 24s77.2 34.6 77.2 77.2c0 45.5-34.5 64.7-53.7 71.8-2.3 10.8-11.9 19-23.5 19-13.3 0-24-10.7-24-24 0-20.2 14.6-34.6 29.5-39.5 6-2 12.3-5.1 16.8-9.5 3.9-3.8 6.9-9 6.9-17.7 0-16.1-13.1-29.2-29.2-29.2zM164 240a28 28 0 1 1 56 0 28 28 0 1 1 -56 0z"],
    "smog": [576, 512, [], "f75f", "M176 288C96.5 288 32 223.5 32 144S96.5 0 176 0c27.2 0 52.6 7.5 74.3 20.6 20.1-13 44-20.6 69.7-20.6 47.4 0 88.7 25.7 110.9 64l1.1 0c61.9 0 112 50.1 112 112 0 60.3-47.6 109.4-107.2 111.9-22.6 20-52.3 32.1-84.8 32.1-32.5 0-62.1-12.1-84.7-32L176 288zM512 392c0 13.3-10.7 24-24 24L24 416c-13.3 0-24-10.7-24-24s10.7-24 24-24l464 0c13.3 0 24 10.7 24 24zM88 464l80 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zm176 0l288 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-288 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"],
    "s": [320, 512, [115], "53", "M0 157.5C0 88.2 56.2 32 125.5 32L272 32c17.7 0 32 14.3 32 32s-14.3 32-32 32L125.5 96c-34 0-61.5 27.5-61.5 61.5 0 31 23.1 57.2 53.9 61L210.1 230C272.9 237.9 320 291.2 320 354.5 320 423.8 263.8 480 194.5 480L48 480c-17.7 0-32-14.3-32-32s14.3-32 32-32l146.5 0c34 0 61.5-27.5 61.5-61.5 0-31-23.1-57.2-53.9-61L109.9 282C47.1 274.1 0 220.8 0 157.5z"],
    "phone-arrow-up-right": [512, 512, ["phone-arrow-up", "phone-outgoing"], "e224", "M112.1 1.4c19.7-5.4 40.3 4.7 48.1 23.5l40.5 97.3c6.9 16.5 2.1 35.6-11.8 47l-44.1 36.1c32.5 71.6 89 130 159.3 164.9L342.8 323c11.3-13.9 30.4-18.6 47-11.8L487 351.8c18.8 7.8 28.9 28.4 23.5 48.1l-1.5 5.5C491.4 470.1 428.9 525.3 352.6 509.2 177.6 472.1 39.9 334.4 2.8 159.4-13.3 83.1 41.9 20.6 106.5 2.9l5.5-1.5zM327 151l103-103-54.1 0c-13.3 0-24-10.7-24-24S362.7 0 376 0L488 0c13.3 0 24 10.7 24 24l0 112c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-54.1-103 103c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9z"],
    "teddy-bear": [512, 512, [], "e3cf", "M400.5 228.5c15.2-21.7 45.1-27.1 66.8-11.9s27.1 45.1 11.9 66.8c-24.5 35.1-57.2 64.2-95.2 84.6l0 48 32 0c0-26.5 21.5-48 48-48s48 21.5 48 48l0 32c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64l0-32c0-26.5 21.5-48 48-48 24.9 0 45.3 18.9 47.8 43.1l.2 4.9 32 0 0-48c-38.1-20.3-70.7-49.4-95.2-84.6-15.2-21.7-9.8-51.7 11.9-66.8s51.7-9.8 66.8 11.9C143.4 274.2 196.2 304 256 304s112.6-29.8 144.5-75.5zM256 352c-35.3 0-64 28.7-64 64l128 0c0-35.3-28.7-64-64-64zM360 0c30.9 0 56 25.1 56 56 0 23.1-13.9 42.8-33.8 51.4 1.2 6.4 1.8 13.2 1.8 20.6 0 70.7-57.3 128-128 128S128 198.7 128 128c0-7.3 .6-14.2 1.8-20.6-19.9-8.6-33.8-28.4-33.8-51.4 0-30.9 25.1-56 56-56 24.4 0 45.1 15.6 52.8 37.4 15.7-3.7 33-5.4 51.2-5.4s35.5 1.7 51.2 5.4C314.9 15.6 335.6 0 360 0zM256 144c-17.7 0-32 10.7-32 24s14.3 24 32 24 32-10.7 32-24-14.3-24-32-24zM208 92a20 20 0 1 0 0 40 20 20 0 1 0 0-40zm96 0a20 20 0 1 0 0 40 20 20 0 1 0 0-40z"],
    "slot-machine": [640, 512, [], "e3ce", "M448 32c35.3 0 64 28.7 64 64l0 320 16 0c17.7 0 32-14.3 32-32l0-204.3c-9.8-8.8-16-21.5-16-35.7 0-26.5 21.5-48 48-48s48 21.5 48 48c0 14.2-6.2 26.9-16 35.7L624 384c0 53-43 96-96 96L96 480c-35.3 0-64-28.7-64-64L32 96c0-35.3 28.7-64 64-64l352 0zM120 160c-13.3 0-24 10.7-24 24s10.7 24 24 24l18.1 0-25.5 114.8c-2.9 12.9 5.3 25.8 18.2 28.7s25.8-5.3 28.7-18.2l32-144c1.6-7.1-.2-14.6-4.7-20.3s-11.4-9-18.7-9l-48 0zm128 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l18.1 0-25.5 114.8c-2.9 12.9 5.3 25.8 18.2 28.7s25.8-5.3 28.7-18.2l32-144c1.6-7.1-.2-14.6-4.7-20.3s-11.4-9-18.7-9l-48 0zm128 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l18.1 0-25.5 114.8c-2.9 12.9 5.3 25.8 18.2 28.7s25.8-5.3 28.7-18.2l32-144c1.6-7.1-.2-14.6-4.7-20.3s-11.4-9-18.7-9l-48 0z"],
    "face-sleeping": [640, 512, [], "e38d", "M532-40c0-11 9-20 20-20l64 0c7.7 0 14.7 4.4 18 11.3s2.4 15.2-2.4 21.2L593.6 20 616 20c11 0 20 9 20 20s-9 20-20 20l-64 0c-7.7 0-14.7-4.4-18-11.3s-2.4-15.2 2.4-21.2l38-47.5-22.4 0c-11 0-20-9-20-20zM388 56c0-11 9-20 20-20l64 0c7.7 0 14.7 4.4 18 11.3s2.4 15.2-2.4 21.2l-38 47.5 22.4 0c11 0 20 9 20 20s-9 20-20 20l-64 0c-7.7 0-14.7-4.4-18-11.3s-2.4-15.2 2.4-21.2l38-47.5-22.4 0c-11 0-20-9-20-20zM364.4 3.8c-14.9 12.5-24.4 31.2-24.4 52.2 0 15 4.8 28.8 13 40-14.7 20.2-17.2 46.8-6.3 69.5 11.3 23.6 35.1 38.5 61.3 38.5l64 0c37.6 0 68-30.4 68-68 0-4.5-.4-8.8-1.3-13.1 23.6 38.8 37.3 84.3 37.3 133.1 0 141.4-114.6 256-256 256S64 397.4 64 256 178.6 0 320 0c15.1 0 30 1.3 44.4 3.8zM196 280c0-11-9-20-20-20s-20 9-20 20c0 33.1 26.9 60 60 60l16 0c33.1 0 60-26.9 60-60 0-11-9-20-20-20s-20 9-20 20-9 20-20 20l-16 0c-11 0-20-9-20-20zm212 20c-11 0-20-9-20-20s-9-20-20-20-20 9-20 20c0 33.1 26.9 60 60 60l16 0c33.1 0 60-26.9 60-60 0-11-9-20-20-20s-20 9-20 20-9 20-20 20l-16 0zM360 416a40 40 0 1 0 -80 0 40 40 0 1 0 80 0z"],
    "jedi": [576, 512, [], "f669", "M246 315.7l-21.2-31.9c-2.1-3.2-1.7-7.4 1-10.1s6.9-3.1 10.1-1l29.5 19.7c2.1 1.4 4.9-.1 5-2.6L279.7 8c.1-4.5 3.8-8 8.3-8s8.1 3.5 8.3 8l9.4 281.9c.1 2.5 2.9 3.9 5 2.6l29.5-19.7c3.2-2.1 7.4-1.7 10.1 1s3.1 6.9 1 10.1L330 315.7c-1.3 1.9-.2 4.5 2 4.9l37.6 7.5c3.7 .7 6.4 4 6.4 7.8s-2.7 7.1-6.4 7.8L332 351.4c-2.2 .4-3.3 3-2 4.9l21.2 31.9c2.1 3.2 1.7 7.4-1 10.1s-6.9 3.1-10.1 1l-26.3-17.6c-2.2-1.4-5.1 .2-5 2.8l2.1 61.5c59.8-10.8 105.1-63.1 105.1-126 0-37-15.7-70.4-40.8-93.7-7-6.5-6.5-18.6 1-24.4 34-26.3 55.8-67.5 55.8-113.9 0-16.8-2.9-33-8.2-48-4.6-13 10.2-30 21.4-22 53.5 38 92.7 94.8 107.8 160.7 .5 2.1-.2 4.3-1.7 5.9l-28.4 28.4c-4 4-1.2 10.9 4.5 10.9l26 0c3.4 0 6.2 2.6 6.3 6 .1 3.3 .2 6.6 .2 10 0 17.5-1.7 34.7-4.8 51.3-.2 1.2-.9 2.4-1.7 3.3l-46.5 46.5c-4 4-1.2 10.9 4.5 10.9l14.6 0c4.6 0 7.7 4.8 5.7 9-44.5 89.5-136.9 151-243.7 151S88.8 450.5 44.3 361c-2.1-4.2 1-9 5.7-9l14.6 0c5.7 0 8.6-6.9 4.5-10.9L22.6 294.6c-.9-.9-1.5-2-1.7-3.3-3.2-16.6-4.8-33.8-4.8-51.3 0-3.3 .1-6.7 .2-10 .1-3.4 2.9-6 6.3-6l26 0c5.7 0 8.6-6.9 4.5-10.9L24.6 184.6c-1.5-1.5-2.2-3.8-1.7-5.9 15.2-66 54.3-122.8 107.8-160.7 11.3-8 26 8.9 21.4 22-5.3 15-8.2 31.2-8.2 48 0 46.3 21.9 87.5 55.8 113.9 7.5 5.8 8 17.9 1 24.4-25.1 23.4-40.8 56.7-40.8 93.7 0 62.9 45.4 115.2 105.1 126l2.1-61.5c.1-2.6-2.8-4.2-5-2.8l-26.3 17.6c-3.2 2.1-7.4 1.7-10.1-1s-3.1-6.9-1-10.1L246 356.3c1.3-1.9 .2-4.5-2-4.9l-37.6-7.5c-3.7-.7-6.4-4-6.4-7.8s2.7-7.1 6.4-7.8l37.6-7.5c2.2-.4 3.3-3 2-4.9z"],
    "police-box": [384, 512, [], "e021", "M192 0c13.3 0 24 10.7 24 24l0 8 72 0c17.7 0 32 14.3 32 32 17.7 0 32 14.3 32 32l0 368 8 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 512c-13.3 0-24-10.7-24-24s10.7-24 24-24l8 0 0-368c0-17.7 14.3-32 32-32 0-17.7 14.3-32 32-32l72 0 0-8c0-13.3 10.7-24 24-24zM96 256l0 48c0 8.8 7.2 16 16 16l48 0c8.8 0 16-7.2 16-16l0-48c0-8.8-7.2-16-16-16l-48 0c-8.8 0-16 7.2-16 16zm16-128c-8.8 0-16 7.2-16 16l0 48c0 8.8 7.2 16 16 16l48 0c8.8 0 16-7.2 16-16l0-48c0-8.8-7.2-16-16-16l-48 0zm96 16l0 48c0 8.8 7.2 16 16 16l48 0c8.8 0 16-7.2 16-16l0-48c0-8.8-7.2-16-16-16l-48 0c-8.8 0-16 7.2-16 16z"],
    "dog-leashed": [576, 512, [129454], "f6d4", "M32 112c16.6 0 30.2 12.6 31.8 28.7l.3 6.6C65.8 163.4 79.4 176 96 176l128 0 0 191.2c-22.9-2.1-44.5-8.5-64-18.5L160 480c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-245.6c-37.3-13.2-64-48.6-64-90.4 0-17.7 14.3-32 32-32zm247.1 70.3L416 237 416 480c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-131.3c-14.9 7.6-31 13.2-48 16.3l0-185.6 7.1 2.8zM355.8-32c7.7 0 14.9 3.6 19.6 9.8L392 0 444.1 0c12.7 0 24.9 5.1 33.9 14.1L496 32 552 32c13.3 0 24 10.7 24 24l0 24c0 44.2-35.8 80-80 80l-64 0-7.2 28.8-125.4-50.1 32.5-151.4C334.3-23.9 344.2-32 355.8-32zM94.5-.4c8.5-9 22.4-10 32-2.6l1.9 1.6 136 128 1.6 1.5-70 0-100.4-94.5-1.7-1.8c-8-9.2-7.8-23.1 .7-32.2zM448 44a20 20 0 1 0 0 40 20 20 0 1 0 0-40z"],
    "person-hiking": [448, 512, ["hiking"], "f6ec", "M192-32a56 56 0 1 1 0 112 56 56 0 1 1 0-112zM128 173.6c0-34 27.6-61.6 61.6-61.6 20.3 0 39.7 8.1 54 22.4l48.2 48.2c6 6 14.1 9.4 22.6 9.4l37.5 0c5.8 0 11.3 1.6 16 4.3l0-76.3c0-13.3 10.7-24 24-24s24 10.7 24 24l0 400c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-268.3c-4.7 2.7-10.2 4.3-16 4.3l-37.5 0c-25.5 0-49.9-10.1-67.9-28.1l-6.6-6.6 0 109.2 34.5 29.6c17.7 15.2 29.3 36.2 32.6 59.3l12.6 88.1c2.5 17.5-9.7 33.7-27.2 36.2s-33.7-9.7-36.2-27.2l-12.6-88.1c-1.1-7.7-5-14.7-10.9-19.8l-71.4-61.2c-21.3-18.2-33.5-44.9-33.5-72.9l0-101zm-4.8 203.7c2.3 2.3 4.7 4.4 7.1 6.5l44.9 38.5c-3.6 8.4-8.5 16.3-14.4 23.4L88.6 532.5c-11.3 13.6-31.5 15.4-45.1 4.1s-15.4-31.5-4.1-45.1l72.3-86.7c2.6-3.1 4.5-6.6 5.8-10.4l5.7-17.1zM0 160c0-35.3 28.7-64 64-64 17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-96z"],
    "arrows-up-to-line": [448, 512, [], "e4c2", "M32 0C14.3 0 0 14.3 0 32S14.3 64 32 64l384 0c17.7 0 32-14.3 32-32S433.7 0 416 0L32 0zm86.6 137.4c-12.5-12.5-32.8-12.5-45.3 0l-64 64c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L64 237.3 64 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-242.7 9.4 9.4c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-64-64zm256 0c-12.5-12.5-32.8-12.5-45.3 0l-64 64c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l9.4-9.4 0 242.7c0 17.7 14.3 32 32 32s32-14.3 32-32l0-242.7 9.4 9.4c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-64-64z"],
    "pen-line": [576, 512, [], "e212", "M404 0c19.2 0 37.6 7.6 51.1 21.2l35.7 35.7C504.4 70.4 512 88.8 512 108s-7.6 37.6-21.2 51.1L445.9 204 308 66.1 352.9 21.2C366.4 7.6 384.8 0 404 0zM58.9 315.1L274.1 100 412 237.9 196.9 453.1c-10.7 10.7-24.1 18.5-38.7 22.6L30.4 511.1c-8.3 2.3-17.3 0-23.4-6.2s-8.5-15.1-6.2-23.4L36.4 353.8c4.1-14.6 11.8-27.9 22.6-38.7zM280 464l272 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-272 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"],
    "badge-percent": [512, 512, [], "f646", "M256 0C292.8 0 324.8 20.7 340.9 51.1 373.8 41 411 49 437 75s34 63.3 23.9 96.1C491.3 187.2 512 219.2 512 256s-20.7 68.8-51.1 84.9C471 373.8 463 411 437 437s-63.3 34-96.1 23.9C324.8 491.3 292.8 512 256 512s-68.8-20.7-84.9-51.1C138.2 471 101 463 75 437s-34-63.3-23.9-96.1C20.7 324.8 0 292.8 0 256s20.7-68.8 51.1-84.9C41 138.2 49 101 75 75s63.3-34 96.1-23.9C187.2 20.7 219.2 0 256 0zM192 224a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm160 96a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM337 209c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0L175 303c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0L337 209z"],
    "mars-double": [640, 512, [9891], "f227", "M288 32c0-17.7 14.3-32 32-32L448 0c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-50.7-95 95c19.5 28.4 31 62.7 31 99.8 0 97.2-78.8 176-176 176S0 401.2 0 304 78.8 128 176 128c37 0 71.4 11.4 99.8 31l95-95-50.7 0c-17.7 0-32-14.3-32-32zM176 416a112 112 0 1 0 0-224 112 112 0 1 0 0 224zm160 64c-6.8 0-13.4-.4-20-1.1 23.6-18.9 43.3-42.5 57.6-69.4 43.3-15.5 74.4-56.9 74.4-105.5 0-25.2-8.3-48.5-22.4-67.2 7.1 2.1 14.6 3.2 22.4 3.2 17 0 32.7-5.3 45.7-14.3 11.7 23.6 18.3 50.2 18.3 78.3 0 97.2-78.8 176-176 176zM528 157.3L528 32c0-11.4-2.4-22.2-6.7-32L608 0c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-50.7-48 48z"],
    "thermometer": [512, 512, [], "f491", "M96 382.1l0-88.8c0-14.9 5.9-29.1 16.4-39.6l21.7-21.7 41 41c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-41-41 46.1-46.1 41 41c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-41-41 46.1-46.1 41 41c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-41-41 7.8-7.8c19.4-19.4 45.6-30.2 73-30.2 57 0 103.2 46.2 103.2 103.2 0 27.4-10.9 53.6-30.2 73L258.3 399.6c-10.5 10.5-24.7 16.4-39.6 16.4l-88.8 0-89 89c-9.4 9.4-24.6 9.4-33.9 0S-2.3 480.4 7 471l89-89z"],
    "paintbrush": [576, 512, [128396, "paint-brush"], "f1fc", "M480.5 10.3L259.1 158c-29.1 19.4-47.6 50.9-50.6 85.3 62.3 12.8 111.4 61.9 124.3 124.3 34.5-3 65.9-21.5 85.3-50.6L565.7 95.5c6.7-10.1 10.3-21.9 10.3-34.1 0-33.9-27.5-61.4-61.4-61.4-12.1 0-24 3.6-34.1 10.3zM288 400c0-61.9-50.1-112-112-112S64 338.1 64 400c0 3.9 .2 7.8 .6 11.6 1.8 17.5-10.2 36.4-27.8 36.4L32 448c-17.7 0-32 14.3-32 32s14.3 32 32 32l144 0c61.9 0 112-50.1 112-112z"],
    "signal-stream": [576, 512, [], "f8dd", "M117.2 62.7c13.3 11.7 14.5 31.9 2.8 45.2-34.9 39.5-56 91.3-56 148.2s21.1 108.7 56 148.2c11.7 13.3 10.4 33.5-2.8 45.2S83.7 459.8 72 446.5C27.2 395.8 0 329 0 256S27.2 116.2 72 65.5c11.7-13.3 31.9-14.5 45.2-2.8zm341.7 0C472.1 51 492.3 52.2 504 65.5 548.8 116.2 576 183 576 256s-27.2 139.8-72 190.5c-11.7 13.2-31.9 14.5-45.2 2.8s-14.5-31.9-2.8-45.2c34.9-39.5 56-91.3 56-148.2s-21.1-108.7-56-148.2c-11.7-13.3-10.4-33.5 2.8-45.2zM240 256a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm-35.5-74.7c-17.8 19.8-28.5 46-28.5 74.7s10.8 54.8 28.5 74.7c11.8 13.2 10.7 33.4-2.5 45.2s-33.4 10.7-45.2-2.5C129 342.2 112 301.1 112 256s17-86.2 44.8-117.3c11.8-13.2 32-14.3 45.2-2.5s14.3 32 2.5 45.2zm214.7-42.7C447 169.8 464 210.9 464 256s-17 86.2-44.8 117.3c-11.8 13.2-32 14.3-45.2 2.5s-14.3-32-2.5-45.2c17.8-19.8 28.5-46 28.5-74.7s-10.8-54.8-28.5-74.7c-11.8-13.2-10.7-33.4 2.5-45.2s33.4-10.7 45.2 2.5z"],
    "square-p": [448, 512, [], "e279", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM168 144l68 0c46.4 0 84 37.6 84 84s-37.6 84-84 84l-44 0 0 32c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-176c0-13.3 10.7-24 24-24zm68 120c19.9 0 36-16.1 36-36s-16.1-36-36-36l-44 0 0 72 44 0z"],
    "bee": [512, 512, [], "e0b2", "M334 448c-25.8 28-52 49.8-63.7 59.1-4.1 3.2-9.1 4.9-14.3 4.9s-10.2-1.6-14.3-4.9C230 497.8 203.8 476 178 448l156 0zM256 319.9c26.9 35.8 63.5 63.7 105.9 80.1l-211.8 0c42.4-16.3 79.1-44.3 105.9-80.1zM311 7c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9L326.9 59c5.8 11.1 9.1 23.6 9.1 37l0 34.7c90.8 15.2 160 94.2 160 189.3l0 16c0 17.7-14.3 32-32 32l-16 0c-102.7 0-186.6-80.7-191.8-182.1L256 176c0 106-86 192-192 192l-16 0c-17.7 0-32-14.3-32-32l0-16c0-95.1 69.2-174.1 160-189.3L176 96c0-13.3 3.3-25.9 9.1-37L167 41 165.4 39.1c-7.7-9.4-7.1-23.3 1.7-32.1s22.7-9.3 32.1-1.7L201 7 219 25.1c11.1-5.8 23.6-9.1 37-9.1 13.3 0 25.9 3.3 36.9 9.1L311 7z"],
    "music-slash": [576, 512, [], "f8d1", "M41-24.9c-9.4-9.4-24.6-9.4-33.9 0S-2.3-.3 7 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9L468.7 402.9C494.8 388.6 512 364 512 336l0-304c0-9.7-4.4-18.9-12-25s-17.5-8.4-27-6.3l-288 64C171 67.9 160.8 80 160 94.2L41-24.9zM253.1 187.2l194.9-43.3 0 116.7c-10-2.9-20.8-4.6-32-4.6-27.3 0-51.9 9.5-69.4 24.7l-93.5-93.5zM160 229.8l0 94.7c-10-2.9-20.8-4.6-32-4.6-53 0-96 35.8-96 80s43 80 96 80 96-35.8 96-80l0-106.2-64-64z"],
    "person-simple": [192, 512, [], "e220", "M32 64A64 64 0 1 1 160 64 64 64 0 1 1 32 64zM0 224c0-35.3 28.7-64 64-64l64 0c35.3 0 64 28.7 64 64l0 64c0 23.7-12.9 44.4-32 55.4L160 464c0 26.5-21.5 48-48 48l-32 0c-26.5 0-48-21.5-48-48l0-120.6C12.9 332.4 0 311.7 0 288l0-64z"],
    "album-collection-circle-user": [576, 512, [], "e48f", "M128 24c0 13.3 10.7 24 24 24l208 0c13.3 0 24-10.7 24-24S373.3 0 360 0L152 0c-13.3 0-24 10.7-24 24zM64 192c-13.9 0-27.1 6-36.3 16.6S14.5 233 16.5 246.8l32 224C51.9 494.4 72.1 512 96 512l180 0c-10.5-14.6-19-30.8-25.1-48.1-86-1.9-154.9-51.3-154.9-111.9 0-61.9 71.6-112 160-112 20.8 0 40.7 2.8 58.9 7.8 32.4-25 73-39.8 117.1-39.8 20.3 0 39.8 3.1 58.1 8.9-1.6-3-3.6-5.8-5.8-8.4-9.1-10.5-22.3-16.6-36.3-16.6L64 192zM241.2 378c2.2-19 7.1-37.1 14.4-54-21.9 .1-39.6 12.6-39.6 28 0 11.8 10.5 21.9 25.2 26zM104 96c-13.3 0-24 10.7-24 24s10.7 24 24 24l304 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L104 96zM576 400a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-66.3 80.7C489.5 500.1 462.2 512 432 512s-57.5-11.9-77.7-31.3c6.2-19 24-32.7 45.1-32.7l65.2 0c21 0 38.9 13.7 45.1 32.7zM384 368a48 48 0 1 1 96 0 48 48 0 1 1 -96 0z"],
    "whale": [640, 512, [128011], "f72c", "M175.8 13.4c-1-5.9-5.2-10.8-10.9-12.6s-12-.3-16.2 3.9L108 45.4C89.7 63.7 81.4 89.6 85.6 115.1l7.9 47.4-49.9 49.9C15.7 240.3 0 278.2 0 317.6 0 407.3 72.7 480 162.4 480L544 480c53 0 96-43 96-96l0-111.9c0-79.6-64.5-144.1-144.1-144.1-82.5 0-162.4 29.5-225 83.2L156.4 309.4c-8 6.8-18.1 10.6-28.6 10.6l-1.1 0c-18.3 0-34.5-11.7-40.3-29-4-12-2.4-25.2 4.3-35.9l37.6-60.1 44.7 7.5c25.5 4.2 51.5-4.1 69.7-22.3l40.7-40.7c4.2-4.2 5.8-10.5 3.9-16.2s-6.7-9.9-12.6-10.9l-84.7-14.1-14.1-84.7zM400 280a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"],
    "arrow-up-triangle-square": [512, 512, ["sort-shapes-up"], "f88a", "M150.6 41.4c-12.5-12.5-32.8-12.5-45.3 0l-80 80c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L96 141.3 96 448c0 17.7 14.3 32 32 32s32-14.3 32-32l0-306.7 25.4 25.4c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-80-80zM411.1 47C405.3 37.7 395 32 384 32s-21.3 5.7-27.1 15l-80 128c-6.2 9.9-6.5 22.3-.9 32.5S292.4 224 304 224l160 0c11.6 0 22.3-6.3 28-16.5s5.3-22.6-.9-32.5l-80-128zM288 336l0 96c0 26.5 21.5 48 48 48l96 0c26.5 0 48-21.5 48-48l0-96c0-26.5-21.5-48-48-48l-96 0c-26.5 0-48 21.5-48 48z"],
    "neuter": [384, 512, [9906], "f22c", "M80 176a112 112 0 1 1 224 0 112 112 0 1 1 -224 0zM223.9 349.1C305.9 334.1 368 262.3 368 176 368 78.8 289.2 0 192 0S16 78.8 16 176c0 86.3 62.1 158.1 144.1 173.1-.1 1-.1 1.9-.1 2.9l0 160c0 17.7 14.3 32 32 32s32-14.3 32-32l0-160c0-1 0-1.9-.1-2.9z"],
    "square-phone-flip": [448, 512, ["phone-square-alt"], "f87b", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm232 96.7l2.8 .8c32.3 8.8 59.9 40.1 51.8 78.2-18.5 87.5-87.4 156.3-174.9 174.9-38.1 8.1-69.4-19.5-78.2-51.8l-.8-2.8c-2.7-9.8 2.4-20.1 11.8-24l48.7-20.3c8.3-3.4 17.8-1.1 23.5 5.9l19.3 23.6c35.1-17.4 63.4-46.6 79.6-82.4l-22.1-18c-6.9-5.7-9.3-15.2-5.9-23.5l20.3-48.7c3.9-9.4 14.2-14.4 24-11.8z"],
    "circle-g": [512, 512, [], "e10f", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM184 256c0 39.8 32.2 72 72 72 28.3 0 52.7-16.3 64.5-40L280 288c-13.3 0-24-10.7-24-24s10.7-24 24-24l71.7 0c6.7 0 13.1 2.8 17.7 7.7s6.8 11.5 6.3 18.2c-5.1 61.6-56.7 110-119.6 110-66.3 0-120-53.7-120-120s53.7-120 120-120c30.7 0 58.8 11.6 80 30.6 9.9 8.8 10.7 24 1.9 33.9s-24 10.7-33.9 1.9c-12.8-11.4-29.5-18.3-48-18.3-39.8 0-72 32.2-72 72z"],
    "circle-down-right": [512, 512, [], "e108", "M256 0a256 256 0 1 0 0 512 256 256 0 1 0 0-512zM200 352c-9.7 0-18.5-5.8-22.2-14.8s-1.7-19.3 5.2-26.2l35-35-67-67c-9.4-9.4-9.4-24.6 0-33.9l24-24c9.4-9.4 24.6-9.4 33.9 0l67 67 35-35c6.9-6.9 17.2-8.9 26.2-5.2S352 190.3 352 200l0 128c0 13.3-10.7 24-24 24l-128 0z"],
    "people-dress": [576, 512, [], "e217", "M104 24a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zM80 400l-17.8 0c-10.9 0-18.6-10.7-15.2-21.1l45.3-136-32.1 60.2c-8.3 15.6-27.7 21.5-43.3 13.1S-4.5 288.5 3.8 272.9L56.6 174C77 135.8 116.8 112 160 112s83 23.8 103.4 62l24.6 46.1 24.6-46.1 0 0c20.4-38.2 60.1-62 103.4-62s83 23.8 103.4 62l52.9 98.9c8.3 15.6 2.4 35-13.1 43.3s-35 2.4-43.3-13.1l-32.1-60.2 45.3 136c3.5 10.4-4.3 21.1-15.2 21.1l-17.8 0 0 112c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-112-32 0 0 112c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-112-17.8 0c-10.9 0-18.6-10.7-15.2-21.1l45.3-136-32.1 60.1C310.7 313.5 299.8 320 288 320s-22.7-6.5-28.2-16.9l-32.1-60.2 45.3 136c3.5 10.4-4.3 21.1-15.2 21.1l-17.8 0 0 112c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-112-32 0 0 112c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-112zM360 24a56 56 0 1 1 112 0 56 56 0 1 1 -112 0z"],
    "circle-half": [512, 512, [], "e110", "M256 32C256 14.3 241.6-.2 224.1 2 97.8 17.7 0 125.4 0 256S97.8 494.3 224.1 510c17.5 2.2 31.9-12.4 31.9-30l0-448z"],
    "face-grin-tongue-squint": [512, 512, [128541, "grin-tongue-squint"], "f58a", "M0 256c0 104.4 62.5 194.2 152.2 234.1-5.3-13-8.2-27.2-8.2-42.1l0-61.7c-16.9-16.5-30.1-36.7-38.3-59.3-4.3-11.8 7.7-21.8 19.6-18.1 39.2 12.2 83.7 19.1 130.7 19.1s91.5-6.9 130.7-19.1c11.9-3.7 23.9 6.3 19.6 18.1-8.3 22.6-21.5 42.8-38.3 59.3l0 61.7c0 14.9-2.9 29.1-8.2 42.1 89.7-39.8 152.2-129.6 152.2-234.1 0-141.4-114.6-256-256-256S0 114.6 0 256zm125.8-91.7c-6.2-5.2-7.6-14.3-3.1-21.1s13.3-9.2 20.6-5.5l79.6 40c5.4 2.7 8.8 8.2 8.8 14.3s-3.4 11.6-8.8 14.3l-79.6 40c-7.3 3.6-16.1 1.3-20.6-5.5s-3.1-15.9 3.1-21.1L159 192 125.8 164.3zm263.6-21.1c4.5 6.8 3.1 15.9-3.1 21.1L353 192 386.2 219.7c6.2 5.2 7.6 14.3 3.1 21.1s-13.3 9.2-20.6 5.5l-79.6-40c-5.4-2.7-8.8-8.2-8.8-14.3s3.4-11.6 8.8-14.3l79.6-40c7.3-3.6 16.1-1.3 20.6 5.5zM320 448l0-45.4c0-14.7-11.9-26.6-26.6-26.6l-2 0c-11.3 0-21.1 7.9-23.6 18.9-2.8 12.6-20.8 12.6-23.6 0-2.5-11.1-12.3-18.9-23.6-18.9l-2 0c-14.7 0-26.6 11.9-26.6 26.6l0 45.4c0 35.3 28.7 64 64 64s64-28.7 64-64z"],
    "pickaxe": [576, 512, [], "e5bf", "M543.7 348.7c-6.5 11.7-23.2 8.8-27.6-3.8-51.2-148.3-168.6-265.7-316.9-316.9-12.6-4.4-15.5-21.1-3.8-27.6 36.9-20.6 79.4-32.3 124.7-32.3 59.2 0 113.6 20.1 157 53.8L489.4 9.4c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3L522.2 67c33.7 43.3 53.8 97.8 53.8 157 0 45.3-11.7 87.8-32.3 124.7zM41.4 457.4L336.7 162c16.1 14 31.2 29.2 45.3 45.3L86.6 502.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3z"],
    "comment-dollar": [512, 512, [], "f651", "M256 480c141.4 0 256-107.5 256-240S397.4 0 256 0 0 107.5 0 240c0 54.3 19.2 104.3 51.6 144.5L2.8 476.8c-4.8 9-3.3 20 3.6 27.5s17.8 9.8 27.1 5.8l118.4-50.7C183.7 472.6 218.9 480 256 480zm4-352c11 0 20 9 20 20l0 4 8 0c11 0 20 9 20 20s-9 20-20 20l-47.5 0c-6.9 0-12.5 5.6-12.5 12.5 0 6.1 4.4 11.3 10.4 12.3l41.7 7c25.3 4.2 43.9 26.1 43.9 51.8 0 26.1-19 47.7-44 51.8l0 4.7c0 11-9 20-20 20s-20-9-20-20l0-4-24 0c-11 0-20-9-20-20s9-20 20-20l55.5 0c6.9 0 12.5-5.6 12.5-12.5 0-6.1-4.4-11.3-10.4-12.3l-41.7-7c-25.3-4.2-43.9-26.1-43.9-51.8 0-28.8 23.2-52.2 52-52.5l0-4c0-11 9-20 20-20z"],
    "list-timeline": [512, 512, [], "e1d1", "M246.6 16L416 16c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-169.4 0c-8.5 0-16.6-3.4-22.6-9.4L180.7 91.3c-6.2-6.2-6.2-16.4 0-22.6L224 25.4c6-6 14.1-9.4 22.6-9.4zM224 201.4c6-6 14.1-9.4 22.6-9.4L480 192c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-233.4 0c-8.5 0-16.6-3.4-22.6-9.4l-43.3-43.3c-6.2-6.2-6.2-16.4 0-22.6L224 201.4zm0 176c6-6 14.1-9.4 22.6-9.4L416 368c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-169.4 0c-8.5 0-16.6-3.4-22.6-9.4l-43.3-43.3c-6.2-6.2-6.2-16.4 0-22.6L224 377.4zM32 80a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM80 208a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm0 176a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"],
    "swords-laser": [640, 512, [], "e03d", "M427.2 215.8L621.5-2.9c10.6-11.9 10-29.9-1.2-41.1S591-55.8 579.1-45.2l-223.6 198.7 71.6 62.2zM182.3 297.9l-26.7 26.7 96 96 26.7-26.7-96-96zM229 443.3l-96-96-25.4 25.4 96 96 25.4-25.4zM22.9 457.4c-12.5 12.5-12.5 32.8 0 45.3l50.7 50.7c12.5 12.5 32.8 12.5 45.3 0l62.1-62.1-96-96-62.1 62.1zM364.3 224L61.4-45.2C49.6-55.8 31.5-55.2 20.3-44S8.5-14.7 19.1-2.9L220.7 224 364.3 224zM595.6 508.7l22.1-22.1c12.5-12.5 12.5-32.8 0-45.3l-86.1-86.1-44.7 44.7 108.7 108.7zM573 531.3l-108.7-108.7-44.7 44.7 86.1 86.1c12.5 12.5 32.8 12.5 45.3 0L573 531.3zM397 444.7l112-112-51.3-51.3c-6-6-14.1-9.4-22.6-9.4l-172.1 0c-14.3 0-21.4 17.2-11.3 27.3L397 444.7z"],
    "phone-waveform": [640, 512, [], "e6e2", "M480-8l0 208c0 13.3-10.7 24-24 24s-24-10.7-24-24L432-8c0-13.3 10.7-24 24-24s24 10.7 24 24zm80 32l0 144c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-144c0-13.3 10.7-24 24-24s24 10.7 24 24zM400 40l0 112c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-112c0-13.3 10.7-24 24-24s24 10.7 24 24zM640 72l0 48c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-48c0-13.3 10.7-24 24-24s24 10.7 24 24zM176.1 1.4c19.7-5.4 40.3 4.7 48.1 23.5l40.5 97.3c6.9 16.5 2.1 35.6-11.8 47l-44.1 36.1c32.5 71.6 89 130 159.3 164.9L406.7 323c11.3-13.9 30.4-18.6 47-11.8L551 351.8c18.8 7.8 28.9 28.4 23.5 48.1l-1.5 5.5c-17.6 64.6-80.2 119.8-156.4 103.7-175-37.1-312.7-174.8-349.8-349.8-16.2-76.3 39.1-138.8 103.7-156.4l5.5-1.5z"],
    "hippo": [640, 512, [129435], "f6ed", "M407 47c9.4-9.4 24.6-9.4 33.9 0l17.2 17.2c1.9-.1 3.9-.2 5.8-.2l32 0c11.2 0 21.9 2.3 31.6 6.5L543 55c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9L564 101.9c7.6 12.2 12 26.7 12 42.1 0 10.2 7.4 18.8 16.7 23 27.9 12.5 47.3 40.5 47.3 73 0 26.2-12.6 49.4-32 64l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-16-64 0 0 16c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-17.6c-11.8-2.4-22.7-7.4-32-14.4-1.5-1.1-2.9-2.3-4.3-3.5-17-14.7-27.7-36.4-27.7-60.5 0-8.8-7.2-16-16-16s-16 7.2-16 16c0 44.7 26.2 83.2 64 101.2l0 10.8c0 17.7 14.3 32 32 32l32 0 0 64c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-76c-19.8 7.7-41.4 12-64 12s-44.2-4.3-64-12l0 76c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-118.9-18.1 40.7c-5.4 12.1-19.6 17.6-31.7 12.2S-3.3 362.4 2.1 350.3L24 300.9c5.3-11.9 8-24.7 8-37.7 0-107.5 85.2-195.2 191.8-199.1l.2-.1 64 0c41.7 0 83.4 12.1 117.2 25.7 1.7-1.8 3.5-3.6 5.3-5.2L407 81c-9.4-9.4-9.4-24.6 0-33.9zm73 185a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm88 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM480 144a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm48 16a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"],
    "sword-laser-alt": [640, 512, [], "e03c", "M579.1-45.2L276.3 224 419.8 224 621.5-2.9c10.6-11.9 10-29.9-1.2-41.1S591-55.8 579.1-45.2zM22.9 486.6L45 508.7 153.7 400 109 355.3 22.9 441.4c-12.5 12.5-12.5 32.8 0 45.3zm66.7 66.7c12.5 12.5 32.8 12.5 45.3 0l86.1-86.1-44.7-44.7-108.7 108.7 22.1 22.1zm41.9-220.7l112 112 145.4-145.4c10.1-10.1 2.9-27.3-11.3-27.3l-172.1 0c-8.5 0-16.6 3.4-22.6 9.4l-51.3 51.3z"],
    "flower": [448, 512, [127804, 10047], "f7ff", "M128 480c38.2 0 72.5-16.8 96-43.3 23.5 26.6 57.8 43.3 96 43.3 70.7 0 128-57.3 128-128 0-38.2-16.8-72.5-43.3-96 26.6-23.5 43.3-57.8 43.3-96 0-70.7-57.3-128-128-128-38.2 0-72.5 16.8-96 43.3-23.5-26.6-57.8-43.3-96-43.3-70.7 0-128 57.3-128 128 0 38.2 16.8 72.5 43.3 96-26.6 23.5-43.3 57.8-43.3 96 0 70.7 57.3 128 128 128zm96-304a80 80 0 1 1 0 160 80 80 0 1 1 0-160z"],
    "bowl-food": [512, 512, [], "e4c6", "M0 176c0-35.3 28.7-64 64-64 .5 0 1.1 0 1.6 0 7.4-36.5 39.7-64 78.4-64 15 0 29 4.1 40.9 11.2 13.3-25.7 40.1-43.2 71.1-43.2s57.8 17.6 71.1 43.2c12-7.1 26-11.2 40.9-11.2 38.7 0 71 27.5 78.4 64 .5 0 1.1 0 1.6 0 35.3 0 64 28.7 64 64 0 11.7-3.1 22.6-8.6 32L8.6 208C3.1 198.6 0 187.7 0 176zM0 283.4C0 268.3 12.3 256 27.4 256l457.1 0c15.1 0 27.4 12.3 27.4 27.4 0 70.5-44.4 130.7-106.7 154.1L403.5 452c-2 16-15.6 28-31.8 28l-231.5 0c-16.1 0-29.8-12-31.8-28l-1.8-14.4C44.4 414.1 0 353.9 0 283.4z"],
    "globe-pointer": [576, 512, [], "e60e", "M310.6 280l104.9 0c-2.9 64.5-17.2 123.9-37.5 167.4-11.4 24.5-23.7 41.8-35.1 52.4-11.2 10.5-18.9 12.2-22.9 12.2s-11.7-1.7-22.9-12.2c-9.6-9-19.9-22.8-29.8-41.7l42.5-144.4c3.4-11.7 3.4-23.2 .8-33.7zm-54.3-48c-4.9-.6-10-.6-15.1 0l-16.6 0C227.4 167.5 241.7 108.1 262 64.6 273.4 40.2 285.7 22.8 297.1 12.2 308.3 1.7 316 0 320 0s11.7 1.7 22.9 12.2c11.4 10.6 23.7 28 35.1 52.4 20.3 43.5 34.6 102.9 37.5 167.4l-159.2 0zM65.1 232C74.5 131.2 142.3 47.3 234.4 14.7 202.1 66.9 180 146.4 176.5 232L65.1 232zm509.8 48c-9.4 100.8-77.2 184.7-169.3 217.3 32.3-52.2 54.4-131.7 57.9-217.3l111.4 0zM405.6 14.7C497.7 47.3 565.5 131.2 574.9 232l-111.4 0C460 146.4 437.9 66.9 405.6 14.7zM39 340.5l204.8-60.2c12.1-3.6 23.4 7.7 19.9 19.9L203.5 505c-4.1 13.9-23.2 15.6-29.7 2.6l-28.7-57.3c-.7-1.3-1.5-2.6-2.5-3.7l-88 88c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l88-88c-1.1-1-2.3-1.9-3.7-2.5L36.4 370.2c-13-6.5-11.3-25.6 2.6-29.7z"],
    "eggplant": [512, 512, [], "e16c", "M505 7c9.4 9.4 9.4 24.6 0 33.9l-9 9 0 142.1c0 8.8-7.2 16-16 16-26.5 0-48-21.5-48-48 0-5.8-4-10.7-9.4-12.6-13.3-4.8-25.4-13-35.1-22.8s-18-21.9-22.8-35.1c-2-5.4-6.9-9.4-12.6-9.4-26.5 0-48-21.5-48-48 0-8.8 7.2-16 16-16l142.1 0 9-9c9.4-9.4 24.6-9.4 33.9 0zM169.9 139.3c35.2-17.1 70.7-34.3 100.7-56.6 12.9 20.7 33.5 36.2 57.8 42.4 7.1 12.9 15.9 24.2 25.2 33.4s20.6 18.1 33.4 25.2c8.2 32.3 32.8 58.2 64.5 68-48.8 122.6-145.7 260.4-275.2 260.3-96.5-.1-175-80.8-176.4-176-1.7-113.5 83.3-154.7 169.9-196.7z"],
    "folder-arrow-right": [512, 512, [], "e7d3", "M202.7 32c13.8 0 27.3 4.5 38.4 12.8l38.4 28.8c5.5 4.2 12.3 6.4 19.2 6.4L448 80c35.3 0 64 28.7 64 64l0 240c0 35.3-28.7 64-64 64L64 448c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l138.7 0zM281 175c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l31 31-102.1 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l102.1 0-31 31-1.7 1.8c-7.7 9.4-7.1 23.3 1.7 32.1s22.7 9.3 32.1 1.7l1.8-1.7 72-72c8.8-8.8 9.3-22.7 1.7-32.1l-1.7-1.8-72-72z"],
    "battery-slash": [640, 512, [], "f377", "M73-24.9c-9.4-9.4-24.6-9.4-33.9 0S29.7-.3 39 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-56.8-56.8c36.4-7.5 63.8-39.7 63.8-78.4l0-48c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l0-48c0-44.2-35.8-80-80-80L161.8 64 73-24.9zM225.8 128L528 128c8.8 0 16 7.2 16 16l0 224c0 8.8-7.2 16-16 16l-46.2 0-256-256zM346.2 384L112 384c-8.8 0-16-7.2-16-16l0-224c0-2.9 .8-5.7 2.2-8L52.6 90.4C39.8 104.6 32 123.4 32 144l0 224c0 44.2 35.8 80 80 80l298.2 0-64-64z"],
    "film-slash": [576, 512, [], "e179", "M41-24.9c-9.4-9.4-24.6-9.4-33.9 0S-2.3-.3 7 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-62.1-62.1c3.3-7.7 5.1-16.2 5.1-25.1l0-320c0-35.3-28.7-64-64-64L128 32c-8.9 0-17.4 1.8-25.1 5.1l-62-62zM176 245.8l0 26.2c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l26.2 0-90.2-90.2 0 282.2c0 35.3 28.7 64 64 64L410.2 480 176 245.8zM112 368c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM400 240c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM416 96l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16z"],
    "square-virus": [448, 512, [], "e578", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm160 80c13.3 0 24 10.7 24 24 0 22.9 27.7 34.4 43.9 18.2 9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9c-16.2 16.2-4.7 43.9 18.2 43.9 13.3 0 24 10.7 24 24s-10.7 24-24 24c-22.9 0-34.4 27.7-18.2 43.9 9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0c-16.2-16.2-43.9-4.7-43.9 18.2 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-22.9-27.7-34.4-43.9-18.2-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9c16.2-16.2 4.7-43.9-18.2-43.9-13.3 0-24-10.7-24-24s10.7-24 24-24c22.9 0 34.4-27.7 18.2-43.9-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0c16.2 16.2 43.9 4.7 43.9-18.2 0-13.3 10.7-24 24-24zM192 248a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm88 40a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"],
    "tricycle-adult": [640, 512, [], "e5c4", "M288 96c0-17.7 14.3-32 32-32l48 0c10.5 0 20.3 5.2 26.3 13.8L519.8 259.1c7.7-2 15.8-3.1 24.2-3.1 53 0 96 43 96 96s-43 96-96 96-96-43-96-96c0-21.4 7-41.1 18.8-57.1l-18.2-26.3-55.2 55.2c-18 18-42.4 28.1-67.9 28.1l-102.6 0c-7.8 54.3-54.4 96-110.9 96-61.9 0-112-50.1-112-112 0-48 30.2-88.9 72.6-104.9-7.9-8.3-14.1-18.4-17.9-29.8L33.6 138.1c-5.6-16.8 3.5-34.9 20.2-40.5s34.9 3.5 40.5 20.2l21.1 63.2c2.2 6.5 8.3 10.9 15.2 10.9l61.4 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-1.6 0c9.4 9.2 17.1 20 22.8 32l112.3 0c8.5 0 16.6-3.4 22.6-9.4l63.5-63.5-60.3-87.2-31.2 0c-17.7 0-32-14.3-32-32zM176 336a64 64 0 1 0 -128 0 64 64 0 1 0 128 0zm368 64a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"],
    "circle-phone-flip": [512, 512, ["phone-circle-alt"], "e11c", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm72-383.3l2.8 .8c32.3 8.8 59.9 40.1 51.8 78.2-18.5 87.5-87.4 156.3-174.9 174.9-38.1 8.1-69.4-19.5-78.2-51.8l-.8-2.8c-2.7-9.8 2.4-20.1 11.8-24l48.7-20.3c8.3-3.4 17.8-1.1 23.5 5.9l19.3 23.6c35.1-17.4 63.4-46.6 79.6-82.4l-22.1-18c-6.9-5.7-9.3-15.2-5.9-23.5l20.3-48.7c3.9-9.4 14.2-14.4 24-11.8z"],
    "cloud-sun-rain": [576, 512, [127782], "f743", "M303.2-3.2c-1.1-5.2-4.6-9.5-9.5-11.6s-10.5-1.5-14.9 1.4L208 33.6 137.3-13.3c-4.4-2.9-10-3.5-14.9-1.4s-8.5 6.4-9.5 11.6L96 80 12.8 96.8c-5.2 1.1-9.5 4.6-11.6 9.5s-1.5 10.5 1.4 14.9L49.6 192 2.7 262.7c-2.9 4.4-3.5 10-1.4 14.9s6.4 8.5 11.6 9.5L96 304 112.8 387.2c1.1 5.2 4.6 9.5 9.5 11.6s10.5 1.5 14.9-1.4l67.3-44.6c-15.8-19.4-26-43.5-28.2-69.9-37.5-13.1-64.4-48.7-64.4-90.7 0-53 43-96 96-96 21.7 0 41.8 7.2 57.8 19.4 15.5-17.6 36.9-30 61.1-34L320 80 303.2-3.2zM243 159.1c-8.8-9.3-21.2-15.1-35-15.1-26.5 0-48 21.5-48 48 0 17 8.9 32 22.2 40.5 10.2-31.4 32.1-57.4 60.7-73l.1-.4zM304 352l192 0c44.2 0 80-35.8 80-80 0-33.9-21.1-62.9-50.9-74.5 1.9-6.8 2.9-14 2.9-21.5 0-44.2-35.8-80-80-80-30.8 0-57.5 17.4-70.9 42.8-9.3-6.8-20.7-10.8-33.1-10.8-30.9 0-56 25.1-56 56 0 3.2 .3 6.4 .8 9.4-36.9 7.1-64.8 39.6-64.8 78.6 0 44.2 35.8 80 80 80zm-19 49.1c-12.6-4.2-26.2 2.6-30.4 15.2l-21.4 64.1c-4.2 12.6 2.6 26.2 15.2 30.4s26.2-2.6 30.4-15.2l21.4-64.1c4.2-12.6-2.6-26.2-15.2-30.4zm120 0c-12.6-4.2-26.2 2.6-30.4 15.2l-21.4 64.1c-4.2 12.6 2.6 26.2 15.2 30.4s26.2-2.6 30.4-15.2l21.4-64.1c4.2-12.6-2.6-26.2-15.2-30.4zm120 0c-12.6-4.2-26.2 2.6-30.4 15.2l-21.4 64.1c-4.2 12.6 2.6 26.2 15.2 30.4s26.2-2.6 30.4-15.2l21.4-64.1c4.2-12.6-2.6-26.2-15.2-30.4z"],
    "h4": [512, 512, [], "f86a", "M64 96c0-17.7-14.3-32-32-32S0 78.3 0 96L0 416c0 17.7 14.3 32 32 32s32-14.3 32-32l0-128 96 0 0 128c0 17.7 14.3 32 32 32s32-14.3 32-32l0-320c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 128-96 0 0-128zm288 0c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 112c0 44.2 35.8 80 80 80l80 0 0 128c0 17.7 14.3 32 32 32s32-14.3 32-32l0-320c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 128-80 0c-8.8 0-16-7.2-16-16l0-112z"],
    "circle-caret-right": [512, 512, ["caret-circle-right"], "f330", "M0 256a256 256 0 1 0 512 0 256 256 0 1 0 -512 0zm352 0c0 6.7-2.8 13-7.7 17.6l-112 104c-7 6.5-17.2 8.2-25.9 4.4S192 369.5 192 360l0-208c0-9.5 5.7-18.2 14.4-22s18.9-2.1 25.9 4.4l112 104c4.9 4.5 7.7 10.9 7.7 17.6z"],
    "keyboard-brightness-low": [512, 512, [], "e1c1", "M256 192a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM96 256a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm352-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm32 192a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM64 384a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm96-32c-17.7 0-32 14.3-32 32s14.3 32 32 32l192 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-192 0z"],
    "arrow-right-long": [576, 512, ["long-arrow-right"], "f178", "M566.6 278.6c12.5-12.5 12.5-32.8 0-45.3l-128-128c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L466.7 224 32 224c-17.7 0-32 14.3-32 32s14.3 32 32 32l434.7 0-73.4 73.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l128-128z"],
    "font-case": [576, 512, [], "f866", "M96 168l0 88 96 0 0-88c0-22.1-17.9-40-40-40l-16 0c-22.1 0-40 17.9-40 40zM32 288l0-120C32 110.6 78.6 64 136 64l16 0c57.4 0 104 46.6 104 104l0 248c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-96-96 0 0 96c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-128zm392-32c-22.1 0-40 17.9-40 40l0 48c0 22.1 17.9 40 40 40l16 0c22.1 0 40-17.9 40-40l0-48c0-22.1-17.9-40-40-40l-16 0zm63.5-52.6c5.9-7 14.7-11.4 24.5-11.4 17.7 0 32 14.3 32 32l0 102.5c0 24.1 3.9 48 11.5 70.8l2.9 8.6c5.6 16.8-3.5 34.9-20.2 40.5-15.6 5.2-32.3-2.2-39.1-16.7-16.8 11.6-37.1 18.4-59 18.4l-16 0c-57.4 0-104-46.6-104-104l0-48c0-57.4 46.6-104 104-104l16 0c17.1 0 33.2 4.1 47.5 11.4z"],
    "building-un": [512, 512, [], "e4d9", "M32 64C32 28.7 60.7 0 96 0L352 0c35.3 0 64 28.7 64 64l0 272-112 0c-20.9 0-39.5 10.1-51.2 25.6-8-6-18-9.6-28.8-9.6-26.5 0-48 21.5-48 48l0 64 64 0 0 48-144 0c-35.3 0-64-28.7-64-64L32 64zM144 96c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0zm112 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zM144 224c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0zm112 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zM427.4 380.5c9-2.1 18.3 2.2 22.5 10.5l26.1 52.2 0-43.3c0-11 9-20 20-20s20 9 20 20l0 128c0 9.3-6.4 17.3-15.4 19.5s-18.3-2.2-22.5-10.5L452 484.7 452 528c0 11-9 20-20 20s-20-9-20-20l0-128c0-9.3 6.4-17.3 15.4-19.5zM324 400l0 96c0 6.6 5.4 12 12 12s12-5.4 12-12l0-96c0-11 9-20 20-20s20 9 20 20l0 96c0 28.7-23.3 52-52 52s-52-23.3-52-52l0-96c0-11 9-20 20-20s20 9 20 20z"],
    "toilet-paper-xmark": [512, 512, [], "e5b3", "M305.2 66.8C311 55.1 318.3 43.1 327.1 32L96 32C43 32 0 118 0 224S43 416 96 416l231.1 0c-8.8-11.1-16-23.1-21.9-34.8-21.4-42.7-33.2-98.4-33.2-157.2s11.8-114.5 33.2-157.2zM384 224c0-35.3 14.3-64 32-64s32 28.7 32 64-14.3 64-32 64-32-28.7-32-64zm128 0c0-106-43-192-96-192s-96 86-96 192 43 192 96 192 96-86 96-192zM128 464l0 24c0 30.9 25.1 56 56 56l272 0c30.9 0 56-25.1 56-56l0-81.6c-21.3 30.9-53 57.6-96 57.6l-288 0zm83.9-307.9c9.4 9.4 9.4 24.6 0 33.9l-33.9 33.9 33.9 33.9c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-33.9-33.9-33.9 33.9c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l33.9-33.9-33.9-33.9c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l33.9 33.9 33.9-33.9c9.4-9.4 24.6-9.4 33.9 0z"],
    "temperature-low": [512, 512, [], "f76b", "M96 96c0-53 43-96 96-96s96 43 96 96l0 164.7c29.5 26.4 48 64.7 48 107.3 0 79.5-64.5 144-144 144S48 447.5 48 368c0-42.6 18.5-81 48-107.3L96 96zm96 336c35.3 0 64-28.7 64-64 0-26.9-16.5-49.9-40-59.3l0-28.7c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 28.7c-23.5 9.5-40 32.5-40 59.3 0 35.3 28.7 64 64 64zM464 80a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM352 80a80 80 0 1 1 160 0 80 80 0 1 1 -160 0z"],
    "h2": [576, 512, [], "f314", "M96 96c0-17.7-14.3-32-32-32S32 78.3 32 96l0 320c0 17.7 14.3 32 32 32s32-14.3 32-32l0-128 96 0 0 128c0 17.7 14.3 32 32 32s32-14.3 32-32l0-320c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 128-96 0 0-128zM368 64c-17.7 0-32 14.3-32 32s14.3 32 32 32l81.1 0c21.5 0 38.9 17.4 38.9 38.9 0 13.9-7.5 26.8-19.6 33.8l-76.3 43.6C347.5 269.7 320 317.1 320 368.5l0 47.5c0 17.7 14.3 32 32 32l160 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-128 0 0-15.5c0-28.4 15.2-54.6 39.9-68.7l76.3-43.6C532.2 237.9 552 203.8 552 166.9 552 110.1 505.9 64 449.1 64L368 64z"],
    "face-smile-halo": [512, 512, [], "e38f", "M512 48c0-44.2-114.6-80-256-80S0 3.8 0 48 114.6 128 256 128 512 92.2 512 48zm-64 0c0 17.7-86 32-192 32S64 65.7 64 48 150 16 256 16 448 30.3 448 48zm48 224c0-45.7-12.8-88.4-35-124.8-3.2 1.1-6.4 2.2-9.7 3.2-52.1 16.3-121.2 25.6-195.3 25.6s-143.2-9.3-195.3-25.6c-3.3-1-6.5-2.1-9.7-3.2-22.2 36.4-35 79.1-35 124.8 0 132.5 107.5 240 240 240S496 404.5 496 272zM131.9 348.6c10.7-7.8 25.7-5.4 33.5 5.3 20.4 28 53.4 46.1 90.6 46.1s70.2-18.1 90.6-46.1c7.8-10.7 22.8-13.1 33.5-5.3s13.1 22.8 5.3 33.5C356.3 422 309.2 448 256 448s-100.3-26-129.4-65.9c-7.8-10.7-5.4-25.7 5.3-33.5zM148 272l0 8c0 11-9 20-20 20s-20-9-20-20l0-8c0-37.6 30.4-68 68-68s68 30.4 68 68l0 8c0 11-9 20-20 20s-20-9-20-20l0-8c0-15.5-12.5-28-28-28s-28 12.5-28 28zm188-28c-15.5 0-28 12.5-28 28l0 8c0 11-9 20-20 20s-20-9-20-20l0-8c0-37.6 30.4-68 68-68s68 30.4 68 68l0 8c0 11-9 20-20 20s-20-9-20-20l0-8c0-15.5-12.5-28-28-28z"],
    "rocket-vertical": [448, 512, [], "e7bd", "M337.7 273.4l74.9 74.9c12.2 12.2 16.9 30 12.4 46.6l-26.2 95.9c-6.5 23.7-36.1 31.6-53.5 14.2l-64.4-64.4c0 0-.1-.1-.1-.1l-5.5-5.5c-28.1-28.1-73.7-28.1-101.8 0l-5.7 5.7-64.4 64.4c-17.4 17.4-47 9.5-53.5-14.2L23.7 394.9c-4.5-16.6 .2-34.4 12.4-46.6L111 273.4c-39.7-147 34.5-231.3 96-277.1 10.4-7.7 24.5-7.7 34.8 0 61.5 45.8 135.7 130.1 96 277.1zM272.4 160a48 48 0 1 0 -96 0 48 48 0 1 0 96 0z"],
    "door-open": [448, 512, [], "f52b", "M288 64l64 0 0 416c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l0-384c0-35.3-28.7-64-64-64l-96 0 0 0-160 0C60.7 0 32 28.7 32 64l0 384c-17.7 0-32 14.3-32 32s14.3 32 32 32l224 0c17.7 0 32-14.3 32-32l0-416zM160 256a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"],
    "align-left": [448, 512, [], "f036", "M288 64c0 17.7-14.3 32-32 32L32 96C14.3 96 0 81.7 0 64S14.3 32 32 32l224 0c17.7 0 32 14.3 32 32zm0 256c0 17.7-14.3 32-32 32L32 352c-17.7 0-32-14.3-32-32s14.3-32 32-32l224 0c17.7 0 32 14.3 32 32zM0 192c0-17.7 14.3-32 32-32l384 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 224c-17.7 0-32-14.3-32-32zM448 448c0 17.7-14.3 32-32 32L32 480c-17.7 0-32-14.3-32-32s14.3-32 32-32l384 0c17.7 0 32 14.3 32 32z"],
    "pencil-slash": [576, 512, [], "e215", "M41-24.9c-9.4-9.4-24.6-9.4-33.9 0S-2.3-.3 7 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9L373.6 307.8c24.7-24.7 48.2-48.2 70.4-70.4-16.6-16.6-51.3-51.3-104-104L306.1 99.4c-22.2 22.2-45.7 45.7-70.4 70.4L41-24.9zM167.8 237.7L90.9 314.6c-10.7 10.7-18.5 24.1-22.6 38.7L32.9 481c-2.3 8.3 0 17.3 6.2 23.4s15.1 8.5 23.4 6.2l127.8-35.5c14.6-4.1 27.9-11.8 38.7-22.6l76.9-76.9-137.9-137.9zM115.7 362.7l17.3-6.9c5.3-2.1 11 1.8 11 7.4l0 20.2c0 8.8 7.2 16 16 16l20.2 0c5.7 0 9.5 5.7 7.4 11l-6.9 17.3c-1.1 .4-2.2 .8-3.3 1.1l-86.9 24.1 24.1-86.9c.3-1.1 .7-2.2 1.1-3.3zM477.9 203.4c26.5-26.5 41.4-41.4 44.9-44.9 13.6-13.6 21.2-31.9 21.2-51.1s-7.6-37.6-21.2-51.1L487.1 20.6C473.6 7 455.2-.6 436-.6S398.4 7 384.9 20.6c-3.5 3.5-18.4 18.4-44.9 44.9 16.6 16.6 51.3 51.3 104 104l33.9 33.9z"],
    "camera": [512, 512, [62258, "camera-alt"], "f030", "M149.1 64.8L138.7 96 64 96C28.7 96 0 124.7 0 160L0 416c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64l-74.7 0-10.4-31.2C356.4 45.2 338.1 32 317.4 32L194.6 32c-20.7 0-39 13.2-45.5 32.8zM256 192a96 96 0 1 1 0 192 96 96 0 1 1 0-192z"],
    "hat-winter": [512, 512, [], "f7a8", "M279.9 22.2C279 9.8 268.7 0 256 0s-23 9.8-23.9 22.2c-9.4-8.1-23.7-7.7-32.6 1.2s-9.4 23.2-1.2 32.6C185.8 57 176 67.3 176 80s9.8 23 22.2 23.9c-8.1 9.4-7.7 23.7 1.2 32.6l.1 .1C131.6 158.9 88.4 221 62.9 292.6l47.3 23.6c11.3 5.6 24.5 5.6 35.8 0l70.8-35.4c24.8-12.4 53.9-12.4 78.7 0l70.8 35.4c11.3 5.6 24.5 5.6 35.8 0l47.3-23.6c-25.5-71.6-68.8-133.7-136.7-155.9 0 0 .1-.1 .1-.1 8.9-8.9 9.4-23.2 1.2-32.6 12.4-.9 22.2-11.3 22.2-23.9s-9.8-23-22.2-23.9c8.1-9.4 7.7-23.7-1.2-32.6s-23.2-9.4-32.6-1.2zM0 480c0 17.7 14.3 32 32 32l448 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-.9 0c-1.9-34.5-7-72-16-108.7l-39.7 19.9c-24.8 12.4-53.9 12.4-78.7 0l-70.8-35.4c-11.3-5.6-24.5-5.6-35.8 0l-70.8 35.4c-24.8 12.4-53.9 12.4-78.7 0L48.9 339.3c-9 36.7-14.1 74.2-16 108.7l-.9 0c-17.7 0-32 14.3-32 32z"],
    "house-person-return": [640, 512, ["house-person-arrive", "house-return"], "e011", "M360 24a56 56 0 1 0 112 0 56 56 0 1 0 -112 0zM480 205.3l22.6 22.6c6 6 9.4 14.1 9.4 22.6l0 37.5c0 17.7 14.3 32 32 32s32-14.3 32-32l0-37.5c0-25.5-10.1-49.9-28.1-67.9l-35.1-35.1c-22.8-22.8-53.6-35.6-85.8-35.6-36.9 0-71.8 16.8-94.8 45.6L314.2 180c-6.1 7.6-15.3 12-25 12L256 192c-17.7 0-32 14.3-32 32s14.3 32 32 32l33.2 0c29.2 0 56.7-13.3 75-36l3.8-4.7 0 115.2-34.5 29.6c-17.7 15.2-29.3 36.2-32.6 59.3l-12.6 88.1c-2.5 17.5 9.7 33.7 27.2 36.2s33.7-9.7 36.2-27.2l12.6-88.1c1.1-7.7 5-14.7 10.9-19.8l71.4-61.2c21.3-18.2 33.5-44.9 33.5-72.9l0-69.3zM479.9 371c-2.4 2.3-4.8 4.6-7.4 6.8l-46 39.4 2.2 7.6c4.5 15.7 12.9 30 24.4 41.5l68.3 68.3c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-68.3-68.3c-3.8-3.8-6.6-8.6-8.1-13.8L479.9 371zM213.5 24.2C207.6 18.9 199.9 16 192 16s-15.6 2.9-21.5 8.2L23.1 154.9c-4.5 4-7.1 9.8-7.1 15.9 0 11.7 9.5 21.2 21.2 21.2l10.8 0 0 112c0 26.5 21.5 48 48 48l180.8 0c7.1-10.5 15.6-20.1 25.4-28.4l17.8-15.2 0-7.7c-10 2.2-20.3 3.3-30.8 3.3L256 304c-44.2 0-80-35.8-80-80s35.8-80 80-80l25.6 0 13.1-16.4c4.9-6.2 10.2-11.9 15.9-17.3L213.5 24.2z"],
    "knife": [512, 512, ["utensil-knife"], "f2e4", "M425.8 38.4l-419 419c-12.5 12.5-12.5 32.8 0 45.3l2.7 2.7c12.5 12.5 32.8 12.5 45.3 0L224.2 336 254.3 366.1c18.7 18.7 49.1 18.7 67.9 0L470.6 217.6c49.5-49.5 49.5-129.7 0-179.2-12.4-12.4-32.4-12.4-44.8 0z"],
    "message-exclamation": [512, 512, ["comment-alt-exclamation"], "f4a5", "M416 32c53 0 96 43 96 96l0 224c0 53-43 96-96 96l-120 0c-5.2 0-10.3 1.7-14.4 4.8L166.4 539.2c-4.2 3.1-9.2 4.8-14.4 4.8-13.3 0-24-10.7-24-24l0-72-32 0c-53 0-96-43-96-96L0 128C0 75 43 32 96 32l320 0zM256 304a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm0-192c-18.2 0-32.7 15.5-31.4 33.7l7.4 104c.9 12.6 11.4 22.3 23.9 22.3 12.6 0 23-9.7 23.9-22.3l7.4-104c1.3-18.2-13.1-33.7-31.4-33.7z"],
    "right-to-line": [512, 512, ["arrow-alt-to-right"], "f34c", "M480 64c17.7 0 32 14.3 32 32l0 320c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-320c0-17.7 14.3-32 32-32zM377 239c9.4 9.4 9.4 24.6 0 33.9L233 417c-6.9 6.9-17.2 8.9-26.2 5.2S192 409.7 192 400l0-80-144 0c-26.5 0-48-21.5-48-48l0-32c0-26.5 21.5-48 48-48l144 0 0-80c0-9.7 5.8-18.5 14.8-22.2S226.1 88.2 233 95L377 239z"],
    "mailbox": [576, 512, [128234], "f813", "M240 208c0-53-43-96-96-96s-96 43-96 96l0 208c0 8.8 7.2 16 16 16l160 0c8.8 0 16-7.2 16-16l0-208zM0 208C0 128.5 64.5 64 144 64l272 0c88.4 0 160 71.6 160 160l0 192c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 208zm80 24c0-13.3 10.7-24 24-24l80 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24zm264-24c-13.3 0-24 10.7-24 24s10.7 24 24 24l56 0 0 40c0 13.3 10.7 24 24 24l32 0c13.3 0 24-10.7 24-24l0-64c0-13.3-10.7-24-24-24l-112 0z"],
    "message-heart": [512, 512, [], "e5c9", "M0 128L0 352c0 53 43 96 96 96l32 0 0 72c0 13.3 10.7 24 24 24 5.2 0 10.2-1.7 14.4-4.8l115.2-86.4c4.2-3.1 9.2-4.8 14.4-4.8l120 0c53 0 96-43 96-96l0-224c0-53-43-96-96-96L96 32C43 32 0 75 0 128zm249.6 55.5l6.4 8.5 6.4-8.5c11.1-14.8 28.5-23.5 46.9-23.5 32.4 0 58.7 26.3 58.7 58.7l0 5.3c0 49.1-65.8 98.1-96.5 118.3-9.5 6.2-21.5 6.2-30.9 0-30.7-20.2-96.5-69.3-96.5-118.3l0-5.3c0-32.4 26.3-58.7 58.7-58.7 18.5 0 35.9 8.7 46.9 23.5z"],
    "message-middle-top": [512, 512, ["comment-middle-top-alt"], "e1e2", "M176 64l67.2-89.6c3-4 7.8-6.4 12.8-6.4s9.8 2.4 12.8 6.4L336 64 416 64c53 0 96 43 96 96l0 224c0 53-43 96-96 96L96 480c-53 0-96-43-96-96L0 160c0-53 43-96 96-96l80 0z"],
    "users-rays": [640, 512, [], "e593", "M31-33C21.7-23.6 21.7-8.4 31 1L87 57c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9L65-33c-9.4-9.4-24.6-9.4-33.9 0zM609-33c-9.4-9.4-24.6-9.4-33.9 0L519 23c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0L609 1c9.4-9.4 9.4-24.6 0-33.9zM65 545l56-56c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0L31 511c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0zm544 0c9.4-9.4 9.4-24.6 0-33.9l-56-56c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l56 56c9.4 9.4 24.6 9.4 33.9 0zM320 208a64 64 0 1 0 0-128 64 64 0 1 0 0 128zm0 32c-61.9 0-112 50.1-112 112l0 8c0 13.3 10.7 24 24 24l176 0c13.3 0 24-10.7 24-24l0-8c0-61.9-50.1-112-112-112zm216-80a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zM451.2 260.4C469.4 286.3 480 317.9 480 352l0 8c0 8.4-1.4 16.5-4.1 24l78.8 0c11.8 0 21.3-9.6 21.3-21.3l0-10.7c0-53-43-96-96-96-10 0-19.7 1.5-28.8 4.4zm-262.4 0c-9.1-2.9-18.8-4.4-28.8-4.4-53 0-96 43-96 96l0 10.7c0 11.8 9.6 21.3 21.3 21.3l78.8 0c-2.7-7.5-4.1-15.6-4.1-24l0-8c0-34.1 10.6-65.7 28.8-91.6zM216 160a56 56 0 1 0 -112 0 56 56 0 1 0 112 0z"],
    "circles-overlap": [576, 512, [], "e600", "M160 304c0 14.1 1.4 27.9 4.1 41.2-58-18.6-100.1-73-100.1-137.2 0-79.5 64.5-144 144-144 39 0 74.4 15.5 100.3 40.7-85.8 25.7-148.3 105.2-148.3 199.3zM383.7 96.6C346.8 38.5 281.9 0 208 0 93.1 0 0 93.1 0 208 0 317.6 84.8 407.4 192.3 415.4 229.2 473.5 294.1 512 368 512 482.9 512 576 418.9 576 304 576 194.4 491.2 104.6 383.7 96.6zm28.2 70.2c58 18.6 100.1 73 100.1 137.2 0 79.5-64.5 144-144 144-39 0-74.4-15.5-100.3-40.7 85.8-25.7 148.3-105.2 148.3-199.3 0-14.1-1.4-27.9-4.1-41.2z"],
    "rainbow": [640, 512, [127752], "f75b", "M320 96C178.6 96 64 210.6 64 352l0 64c0 17.7-14.3 32-32 32S0 433.7 0 416l0-64C0 175.3 143.3 32 320 32S640 175.3 640 352l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64C576 210.6 461.4 96 320 96zm0 112c-79.5 0-144 64.5-144 144l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64c0-114.9 93.1-208 208-208s208 93.1 208 208l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64c0-79.5-64.5-144-144-144zM288 352l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64c0-53 43-96 96-96s96 43 96 96l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64c0-17.7-14.3-32-32-32s-32 14.3-32 32z"],
    "box-arrow-down-arrow-up": [448, 512, [], "e795", "M335.1 16c20.7 0 40.1 10 52.1 26.8l48.9 68.5c7.7 10.8 11.9 23.9 11.9 37.2L448 416c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 148.5c0-13.3 4.2-26.3 11.9-37.2L60.8 42.8C72.9 26 92.3 16 112.9 16l222.1 0zM321 199c-8.8-8.8-22.7-9.3-32.1-1.7l-1.8 1.7-40 40c-6.9 6.9-8.9 17.2-5.2 26.2S254.3 280 264 280l16 0 0 112c0 13.3 10.7 24 24 24s24-10.7 24-24l0-112 16 0c9.7 0 18.5-5.8 22.2-14.8s1.6-19.3-5.2-26.2l-40-40zm-177-7c-13.3 0-24 10.7-24 24l0 112-16 0c-9.7 0-18.5 5.8-22.2 14.8S80.2 362.1 87 369l40 40 1.8 1.7c9.4 7.7 23.3 7.1 32.1-1.7l40-40c6.9-6.9 8.9-17.2 5.2-26.2S193.7 328 184 328l-16 0 0-112c0-13.3-10.7-24-24-24zM78.7 128l290.7 0-34.3-48-222.1 0-34.3 48z"],
    "left-from-dotted-line": [512, 512, [], "e6c2", "M7 239c-9.4 9.4-9.4 24.6 0 33.9L151 417c6.9 6.9 17.2 8.9 26.2 5.2S192 409.7 192 400l0-80 144 0c26.5 0 48-21.5 48-48l0-32c0-26.5-21.5-48-48-48l-144 0 0-80c0-9.7-5.8-18.5-14.8-22.2S157.9 88.2 151 95L7 239zM480 448a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM448 309.3a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm32-74.7a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM448 96a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z"],
    "sitemap": [512, 512, [], "f0e8", "M192 64c0-17.7 14.3-32 32-32l64 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-8 0 0 64 120 0c39.8 0 72 32.2 72 72l0 56 8 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32l8 0 0-56c0-13.3-10.7-24-24-24l-120 0 0 80 8 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32l8 0 0-80-120 0c-13.3 0-24 10.7-24 24l0 56 8 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32l8 0 0-56c0-39.8 32.2-72 72-72l120 0 0-64-8 0c-17.7 0-32-14.3-32-32l0-64z"],
    "caravan-simple": [640, 512, ["caravan-alt"], "e000", "M96 32C60.7 32 32 60.7 32 96l0 256c0 35.3 28.7 64 64 64l40.4 0c-.2 2.6-.4 5.3-.4 8 0 48.6 39.4 88 88 88s88-39.4 88-88c0-2.7-.1-5.4-.4-8L608 416c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0 0-192c0-70.7-57.3-128-128-128L96 32zm32 128c0-17.7 14.3-32 32-32l64 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-64zm224-32l64 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32zM184 424a40 40 0 1 1 80 0 40 40 0 1 1 -80 0z"],
    "face-grin-stars": [512, 512, [129321, "grin-stars"], "f587", "M256 512c141.4 0 256-114.6 256-256 0-24.4-3.4-48.1-9.8-70.5 18.6-36.1-2.7-83.6-46.7-90-46.9-58.3-118.9-95.5-199.5-95.5S103.4 37.3 56.5 95.5c-44 6.4-65.3 53.9-46.7 90-6.4 22.4-9.8 46-9.8 70.5 0 141.4 114.6 256 256 256zM386.7 324.9c11.9-3.7 23.9 6.3 19.6 18.1-22.4 61.3-81.3 105.1-150.3 105.1S128.1 404.2 105.7 342.9c-4.3-11.8 7.7-21.8 19.6-18.1 39.2 12.2 83.7 19.1 130.7 19.1s91.5-6.9 130.7-19.1zm-31.6-231c5.3-10.7 20.5-10.7 25.8 0l20.9 42.4 46.7 6.8c11.8 1.7 16.5 16.2 8 24.5l-33.8 33 8 46.6c2 11.7-10.3 20.7-20.9 15.2l-41.8-22-41.8 22c-10.5 5.5-22.9-3.4-20.9-15.2l8-46.6-33.8-33c-8.5-8.3-3.8-22.8 8-24.5l46.7-6.8 20.9-42.4zm-198.2 0l20.9 42.4 46.7 6.8c11.8 1.7 16.5 16.2 8 24.5l-33.8 33 8 46.6c2 11.7-10.3 20.7-20.9 15.2l-41.8-22-41.8 22c-10.5 5.5-22.9-3.4-20.9-15.2l8-46.6-33.8-33c-8.5-8.3-3.8-22.8 8-24.5l46.7-6.8 20.9-42.4c5.3-10.7 20.5-10.7 25.8 0z"],
    "message-sms": [512, 512, [], "e1e5", "M0 128L0 352c0 53 43 96 96 96l32 0 0 72c0 13.3 10.7 24 24 24 5.2 0 10.2-1.7 14.4-4.8l115.2-86.4c4.2-3.1 9.2-4.8 14.4-4.8l120 0c53 0 96-43 96-96l0-224c0-53-43-96-96-96L96 32C43 32 0 75 0 128zm140.8 44.8l19.2 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-19.2 0c-5.3 0-9.6 4.3-9.6 9.6s4.3 9.6 9.6 9.6c23 0 41.6 18.6 41.6 41.6s-18.6 41.6-41.6 41.6l-25.6 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l25.6 0c5.3 0 9.6-4.3 9.6-9.6s-4.3-9.6-9.6-9.6c-23 0-41.6-18.6-41.6-41.6s18.6-41.6 41.6-41.6zm188.8 41.6c0-23 18.6-41.6 41.6-41.6l19.2 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-19.2 0c-5.3 0-9.6 4.3-9.6 9.6s4.3 9.6 9.6 9.6c23 0 41.6 18.6 41.6 41.6s-18.6 41.6-41.6 41.6l-25.6 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l25.6 0c5.3 0 9.6-4.3 9.6-9.6s-4.3-9.6-9.6-9.6c-23 0-41.6-18.6-41.6-41.6zm-98.3-33.8l24.7 41.1 24.7-41.1c3.7-6.2 11.1-9.1 18-7.2s11.7 8.2 11.7 15.4l0 102.4c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-44.6-8.7 14.5c-2.9 4.8-8.1 7.8-13.7 7.8s-10.8-3-13.7-7.8l-8.7-14.5 0 44.6c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-102.4c0-7.2 4.8-13.5 11.7-15.4s14.3 1 18 7.2z"],
    "comments-question": [576, 512, [], "e14e", "M192 320c106 0 192-78.8 192-176S298-32 192-32 0 46.8 0 144c0 39.6 14.3 76.2 38.4 105.6L2.8 316.8C-2.1 326.1-.4 337.5 7 345s18.9 9.2 28.2 4.2L116.8 306c23.1 9 48.5 14 75.2 14zm3.2 48c16.4 81.9 94.7 144 188.8 144 26.7 0 52.1-5 75.2-14l81.6 43.2c9.3 4.9 20.7 3.2 28.2-4.2s9.2-18.9 4.2-28.2l-35.6-67.2c24.1-29.4 38.4-66 38.4-105.6 0-82.4-61.7-151.5-145-170.7-11.5 115.8-115.8 201.2-235.8 202.7zM192 72c-16.1 0-29.2 13.1-29.2 29.2 0 13.3-10.7 24-24 24s-24-10.7-24-24C114.8 58.6 149.4 24 192 24s77.2 34.6 77.2 77.2c0 45.5-34.5 64.7-53.7 71.8-2.3 10.8-11.9 19-23.5 19-13.3 0-24-10.7-24-24 0-20.2 14.6-34.6 29.5-39.5 6-2 12.3-5.1 16.8-9.5 3.9-3.8 6.9-9 6.9-17.7 0-16.1-13.1-29.2-29.2-29.2zM164 240a28 28 0 1 1 56 0 28 28 0 1 1 -56 0z"],
    "sort-up": [384, 512, ["sort-asc"], "f0de", "M32 224c-12.9 0-24.6-7.8-29.6-19.8S.2 178.5 9.4 169.4l160-160c12.5-12.5 32.8-12.5 45.3 0l160 160c9.2 9.2 11.9 22.9 6.9 34.9S364.9 224 352 224L32 224z"],
    "billboard": [576, 512, [], "e5cd", "M168 64L96 64c-35.3 0-64 28.7-64 64l0 224c-17.7 0-32 14.3-32 32s14.3 32 32 32l224 0 0 64c0 17.7 14.3 32 32 32s32-14.3 32-32l0-64 224 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l0-224c0-35.3-28.7-64-64-64l-72 0 0 80 16 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l16 0 0-80-144 0 0 80 16 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l16 0 0-80z"],
    "eye": [576, 512, [128065], "f06e", "M288 32c-80.8 0-145.5 36.8-192.6 80.6-46.8 43.5-78.1 95.4-93 131.1-3.3 7.9-3.3 16.7 0 24.6 14.9 35.7 46.2 87.7 93 131.1 47.1 43.7 111.8 80.6 192.6 80.6s145.5-36.8 192.6-80.6c46.8-43.5 78.1-95.4 93-131.1 3.3-7.9 3.3-16.7 0-24.6-14.9-35.7-46.2-87.7-93-131.1-47.1-43.7-111.8-80.6-192.6-80.6zM144 256a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm144-64c0 35.3-28.7 64-64 64-11.5 0-22.3-3-31.7-8.4-1 10.9-.1 22.1 2.9 33.2 13.7 51.2 66.4 81.6 117.6 67.9s81.6-66.4 67.9-117.6c-12.2-45.7-55.5-74.8-101.1-70.8 5.3 9.3 8.4 20.1 8.4 31.7z"],
    "arrow-down-small-big": [512, 512, ["sort-size-down-alt"], "f88d", "M230.6 390.6l-80 80c-12.5 12.5-32.8 12.5-45.3 0l-80-80c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0L96 370.7 96 64c0-17.7 14.3-32 32-32s32 14.3 32 32l0 306.7 25.4-25.4c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3zM288 80c0-26.5 21.5-48 48-48l64 0c26.5 0 48 21.5 48 48l0 64c0 26.5-21.5 48-48 48l-64 0c-26.5 0-48-21.5-48-48l0-64zm0 224c0-26.5 21.5-48 48-48l128 0c26.5 0 48 21.5 48 48l0 128c0 26.5-21.5 48-48 48l-128 0c-26.5 0-48-21.5-48-48l0-128z"],
    "axe": [640, 512, [129683], "f6b2", "M473.9 105.9l54.1 54.1 88 0c13.3 0 24 10.7 24 24l0 8c0 123.7-100.3 224-224 224l-8 0c-13.3 0-24-10.7-24-24l0-88-153.4-153.4c-12.5-12.5-12.5-32.8 0-45.3L329.4 6.6c12.5-12.5 32.8-12.5 45.3 0l31.4 31.4 8-8c18.7-18.7 49.1-18.7 67.9 0s18.7 49.1 0 67.9l-8 8zM228.1 216L296 283.9 97.9 481.9c-18.7 18.7-49.1 18.7-67.9 0s-18.7-49.1 0-67.9L228.1 216z"],
    "caret-left": [256, 512, [], "f0d9", "M7.7 235.8c-10.3 12.6-9.5 31.1 2.2 42.8l128 128c9.2 9.2 22.9 11.9 34.9 6.9s19.8-16.6 19.8-29.6l0-256c0-12.9-7.8-24.6-19.8-29.6s-25.7-2.2-34.9 6.9l-128 128-2.2 2.4z"],
    "apple-whole": [448, 512, [127822, 127823, "apple-alt"], "f5d1", "M224 112c-8.8 0-16-7.2-16-16l0-16c0-44.2 35.8-80 80-80l16 0c8.8 0 16 7.2 16 16l0 16c0 44.2-35.8 80-80 80l-16 0zM0 288c0-76.3 35.7-160 112-160 27.3 0 59.7 10.3 82.7 19.3 18.8 7.3 39.9 7.3 58.7 0 22.9-8.9 55.4-19.3 82.7-19.3 76.3 0 112 83.7 112 160 0 128-80 224-160 224-16.5 0-38.1-6.6-51.5-11.3-8.1-2.8-16.9-2.8-25 0-13.4 4.7-35 11.3-51.5 11.3-80 0-160-96-160-224z"],
    "scroll-torah": [576, 512, ["torah"], "f6a0", "M0 48C0 21.5 21.5 0 48 0 68.9 0 86.7 13.4 93.3 32l389.5 0c6.6-18.6 24.4-32 45.3-32 26.5 0 48 21.5 48 48l0 416c0 26.5-21.5 48-48 48-20.9 0-38.7-13.4-45.3-32L93.3 480c-6.6 18.6-24.4 32-45.3 32-26.5 0-48-21.5-48-48L0 48zM177.9 301c-1.2 2-1.9 4.2-1.9 6.6 0 6.9 5.6 12.5 12.5 12.5l56.9 0 30.5 49.2c2.6 4.2 7.2 6.8 12.2 6.8s9.6-2.6 12.2-6.8l30.5-49.2 56.9 0c6.9 0 12.5-5.6 12.5-12.5 0-2.3-.6-4.6-1.9-6.6l-27.8-45 27.8-45c1.2-2 1.9-4.2 1.9-6.6 0-6.9-5.6-12.5-12.5-12.5l-56.9 0-30.5-49.2c-2.6-4.2-7.2-6.8-12.2-6.8s-9.6 2.6-12.2 6.8l-30.5 49.2-56.9 0c-6.9 0-12.5 5.6-12.5 12.5 0 2.3 .6 4.6 1.9 6.6l27.8 45-27.8 45z"],
    "house-lock": [640, 512, [], "e510", "M528 224.1c44.2 0 80 35.8 80 80l0 50.6c18.6 6.6 32 24.4 32 45.3l0 96c0 26.5-21.5 48-48 48l-128 0c-26.5 0-48-21.5-48-48l0-96c0-20.9 13.4-38.7 32-45.3l0-50.6c0-44.2 35.8-80 80-80zM268.6 6.5c12.2-9.3 29.7-8.7 41.2 2l185 171.8C440.2 195 400 244.8 400 304l0 24.4c-19.6 17.6-32 43.1-32 71.5l0 96c0 5.5 .5 10.9 1.3 16.1L144 512c-35.3 0-64-28.7-64-64l0-176-16 0c-13.2 0-25-8.1-29.8-20.3s-1.6-26.2 8-35.1l224-208 2.4-2zM272 320c-26.5 0-48 21.5-48 48l0 96 96 0 0-87.3c0-16.5 7-31.5 18.4-42.1-8.7-9-20.9-14.6-34.4-14.6l-32 0zm256-47.9c-17.7 0-32 14.3-32 32l0 47.9 64 0 0-47.9c0-17.7-14.3-32-32-32z"],
    "square-litecoin": [448, 512, [], "e6f7", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm120 96c13.3 0 24 10.7 24 24l0 60.5 58.9-19.6c8.4-2.8 17.4 1.7 20.2 10.1s-1.7 17.4-10.1 20.2l-69.1 23 0 89.8 88 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-112 0c-13.3 0-24-10.7-24-24l0-97.8-26.9 9c-8.4 2.8-17.4-1.7-20.2-10.1s1.7-17.4 10.1-20.2l37.1-12.4 0-76.5c0-13.3 10.7-24 24-24z"],
    "arrows-left-right-to-line": [576, 512, [], "e4ba", "M32 96C14.3 96 0 110.3 0 128L0 384c0 17.7 14.3 32 32 32s32-14.3 32-32l0-256c0-17.7-14.3-32-32-32zM390.6 342.6l64-64c12.5-12.5 12.5-32.8 0-45.3l-64-64c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l9.4 9.4-133.5 0 9.4-9.4c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-64 64c-6 6-9.4 14.1-9.4 22.6s3.4 16.6 9.4 22.6l64 64c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-9.4-9.4 133.5 0-9.4 9.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0zM576 128c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 256c0 17.7 14.3 32 32 32s32-14.3 32-32l0-256z"],
    "trash": [448, 512, [], "f1f8", "M136.7 5.9L128 32 32 32C14.3 32 0 46.3 0 64S14.3 96 32 96l384 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-96 0-8.7-26.1C306.9-7.2 294.7-16 280.9-16L167.1-16c-13.8 0-26 8.8-30.4 21.9zM416 144L32 144 53.1 467.1C54.7 492.4 75.7 512 101 512L347 512c25.3 0 46.3-19.6 47.9-44.9L416 144z"],
    "face-sad-tear": [512, 512, [128546, "sad-tear"], "f5b4", "M0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm271 98c5.5-1.3 11.1-2 17-2 24.1 0 45.4 11.8 58.5 30 7.7 10.8 22.7 13.2 33.5 5.5s13.2-22.7 5.5-33.5c-21.7-30.2-57.3-50-97.5-50-12.5 0-24.6 1.9-35.9 5.5 9.8 12.7 16.5 27.9 18.9 44.6zM176 240a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm192-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM185.4 292.8c-2.4-2.9-5.7-4.8-9.4-4.8s-7 1.9-9.4 4.8c-6.5 7.8-12.6 16.1-18.3 24.6-9 13.4-20.3 30.2-20.3 47.4 0 28.3 21.5 51.2 48 51.2s48-22.9 48-51.2c0-17.2-11.2-34-20.3-47.4-5.7-8.5-11.9-16.7-18.3-24.6z"],
    "tire-flat": [512, 512, [], "f632", "M400 288c0-39.2-15.7-74.7-41.1-100.7L330.1 227c13.7 16.6 21.9 37.8 21.9 61 0 2-.1 4-.2 6l46.6 15.2c1-6.9 1.5-14 1.5-21.2zm-63.1 51.6c-12.9 20.2-33.2 35.2-57 41.3l0 35 42.1 0c26.3-13.6 47.8-35 61.5-61.2l-46.6-15.2zM232 416l0-35c-23.8-6.1-44-21.2-56.9-41.3l-46.6 15.2C142.2 381 163.7 402.4 190 416l42 0zM35.2 417.7C12.8 379.7 0 335.3 0 288 0 146.6 114.6 32 256 32S512 146.6 512 288c0 47.3-12.8 91.7-35.2 129.7 20.3 5.6 35.2 24.2 35.2 46.3 0 26.5-21.5 48-48 48L48 512c-26.5 0-48-21.5-48-48 0-22.1 14.9-40.7 35.2-46.3zM112 288c0 7.2 .5 14.3 1.5 21.2L160.2 294c-.1-2-.2-4-.2-6 0-23.2 8.2-44.4 21.9-61l-28.8-39.7C127.7 213.3 112 248.8 112 288zm144-96c12.5 0 24.4 2.4 35.4 6.7L320.2 159c-19.3-9.6-41.1-15-64.2-15s-44.8 5.4-64.1 15l28.8 39.7c10.9-4.3 22.9-6.7 35.4-6.7zm0 128a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "melon": [512, 512, [], "e310", "M256 512c-38.5 0-75-8.5-107.7-23.7 67.1-5.8 149.8-48.2 220.8-119.2S482.5 215.4 488.3 148.3C503.5 181 512 217.5 512 256 512 397.4 397.4 512 256 512zM23.7 363.7C8.5 331 0 294.5 0 256 0 114.6 114.6 0 256 0 294.5 0 331 8.5 363.7 23.7 296.6 29.5 213.9 71.8 142.9 142.9S29.5 296.6 23.7 363.7zm402-277.4c13.3 13.3 22.4 42.6 8.1 92.5-13.7 48.1-47.1 104.8-98.7 156.4s-108.3 84.9-156.4 98.6c-49.9 14.3-79.2 5.2-92.5-8.1s-22.4-42.6-8.1-92.5c13.7-48.1 47.1-104.8 98.7-156.4S285.1 91.9 333.2 78.2c49.9-14.3 79.2-5.2 92.5 8.1z"],
    "fax": [512, 512, [128224, 128439], "f1ac", "M160 64l0 80 64 0 0-80 146.7 0 45.3 45.3 0 34.7 64 0 0-34.7c0-17-6.7-33.3-18.7-45.3L416 18.7C404 6.7 387.7 0 370.7 0L224 0c-35.3 0-64 28.7-64 64zM32 128c-17.7 0-32 14.3-32 32L0 448c0 17.7 14.3 32 32 32l48 0c17.7 0 32-14.3 32-32l0-288c0-17.7-14.3-32-32-32l-48 0zm448 64l-320 0 0 256c0 17.7 14.3 32 32 32l288 0c17.7 0 32-14.3 32-32l0-224c0-17.7-14.3-32-32-32zM224 288a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm0 96a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM336 264a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM312 384a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM424 264a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM400 384a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"],
    "arrow-left-long-to-line": [640, 512, [], "e3d4", "M265.4 105.4c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3L237.3 224 608 224c17.7 0 32 14.3 32 32s-14.3 32-32 32l-370.7 0 73.4 73.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0l-128-128c-12.5-12.5-12.5-32.8 0-45.3l128-128zM0 128c0-17.7 14.3-32 32-32s32 14.3 32 32l0 256c0 17.7-14.3 32-32 32S0 401.7 0 384L0 128z"],
    "user-music": [640, 512, [], "f8eb", "M256 248a120 120 0 1 0 0-240 120 120 0 1 0 0 240zm-29.7 56C127.8 304 48 383.8 48 482.3 48 498.7 61.3 512 77.7 512l195.8 0c-1-5.2-1.5-10.6-1.5-16.2 0-31.8 17.3-56.8 37.9-72.3 12.3-9.3 26.7-15.9 42.1-19.7l0-87c-20.5-8.2-42.9-12.7-66.3-12.7l-59.4 0zM624 256c0-7.1-3.2-13.9-8.6-18.4s-12.7-6.5-19.7-5.2l-176 32c-11.4 2.1-19.7 12-19.7 23.6l0 161.6c-5.9-1.1-11.4-1.6-16-1.6-9.5 0-22.9 2.1-34.9 7.5-11.1 5-29.1 17.2-29.1 40.5s18 35.4 29.1 40.5c11.9 5.4 25.4 7.5 34.9 7.5s22.9-2.1 34.9-7.5c11.1-5 29.1-17.2 29.1-40.5l0-139.9 128-23.3 0 84.9c-5.9-1.1-11.4-1.6-16-1.6-9.5 0-22.9 2.1-34.9 7.5-11.1 5-29.1 17.2-29.1 40.5s18 35.4 29.1 40.5c11.9 5.4 25.4 7.5 34.9 7.5s22.9-2.1 34.9-7.5c11.1-5 29.1-17.2 29.1-40.5l0-208z"],
    "person-circle-plus": [640, 512, [], "e541", "M280 24a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zm24 212.7L341 286.6c12.8-17.5 28.5-32.7 46.3-45l-56.2-75.7C306 132 266.3 112 224 112s-82 20-107.2 53.9l-70.5 95c-10.5 14.2-7.6 34.2 6.6 44.8s34.2 7.6 44.8-6.6L144 236.7 144 512c0 17.7 14.3 32 32 32s32-14.3 32-32l0-160c0-8.8 7.2-16 16-16s16 7.2 16 16l0 160c0 17.7 14.3 32 32 32s32-14.3 32-32l0-275.3zM496 544a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm16-208l0 48 48 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-48 0 0 48c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-48-48 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l48 0 0-48c0-8.8 7.2-16 16-16s16 7.2 16 16z"],
    "hamsa": [512, 512, [], "f665", "M34.6 288L80 288c8.8 0 16-7.2 16-16L96 72c0-22.1 17.9-40 40-40s40 17.9 40 40l0 132c0 11 9 20 20 20s20-9 20-20l0-164c0-22.1 17.9-40 40-40s40 17.9 40 40l0 164c0 11 9 20 20 20s20-9 20-20l0-132c0-22.1 17.9-40 40-40s40 17.9 40 40l0 200c0 8.8 7.2 16 16 16l45.4 0c19.1 0 34.6 15.5 34.6 34.6 0 8.6-3.2 16.9-9 23.3L416.6 441c-41.1 45.2-99.4 71-160.6 71S136.6 486.2 95.4 441L9 345.9c-5.8-6.4-9-14.7-9-23.3 0-19.1 15.5-34.6 34.6-34.6zM256 288c-38.4 0-76.8 35.8-90.6 50.2-3.6 3.7-5.4 8.7-5.4 13.8s1.8 10.1 5.4 13.8C179.2 380.2 217.6 416 256 416s76.8-35.8 90.6-50.2c3.6-3.7 5.4-8.7 5.4-13.8s-1.8-10.1-5.4-13.8C332.8 323.8 294.4 288 256 288zm0 32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "house-building": [640, 512, [], "e1b1", "M320 64l0 52.1 118.2 103.4c16.4 14.3 25.8 35.1 25.8 56.8 0 25.5-12.6 48.1-32 61.7l0 121.2c0 19.4-5.5 37.4-14.9 52.8L576 512c35.3 0 64-28.7 64-64l0-384c0-35.3-28.7-64-64-64L384 0c-35.3 0-64 28.7-64 64zm120.4 93.6l-56-49c1.6-7.2 8-12.6 15.6-12.6l32 0c8.8 0 16 7.2 16 16l0 32c0 5.8-3 10.8-7.6 13.6zM528 96l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM512 240c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm16 112l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM384 304l4.5 0c15.2 0 27.5-12.3 27.5-27.5 0-7.9-3.4-15.5-9.4-20.7L236 106.5C228.3 99.7 218.3 96 208 96s-20.3 3.7-28 10.5L9.4 255.8C3.4 261 0 268.6 0 276.5 0 291.7 12.3 304 27.5 304l4.5 0 0 155.4C32 488.4 55.6 512 84.6 512l246.8 0c29.1 0 52.6-23.6 52.6-52.6L384 304zm-224-8c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-48z"],
    "person-circle-question": [640, 512, [], "e542", "M280 24a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zm24 212.7L341 286.6c12.8-17.5 28.5-32.7 46.3-45l-56.2-75.7C306 132 266.3 112 224 112s-82 20-107.2 53.9l-70.5 95c-10.5 14.2-7.6 34.2 6.6 44.8s34.2 7.6 44.8-6.6L144 236.7 144 512c0 17.7 14.3 32 32 32s32-14.3 32-32l0-160c0-8.8 7.2-16 16-16s16 7.2 16 16l0 160c0 17.7 14.3 32 32 32s32-14.3 32-32l0-275.3zM496 544a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm0-100a20 20 0 1 1 0 40 20 20 0 1 1 0-40zm0-100c-11.6 0-21.3 8.2-23.5 19.2-1.8 8.7-10.2 14.3-18.9 12.5s-14.3-10.2-12.5-18.9c5.2-25.6 27.8-44.8 54.9-44.8 30.9 0 56 25.1 56 56 0 19.8-11.7 37.8-29.8 45.9l-10.4 4.6c-1.2 7.7-7.8 13.5-15.8 13.5-8.8 0-16-7.2-16-16 0-11.2 6.6-21.3 16.8-25.9l12.4-5.5c6.6-2.9 10.8-9.4 10.8-16.6 0-13.3-10.7-24-24-24z"],
    "crate-empty": [512, 512, [], "e151", "M48 224c-26.5 0-48 21.5-48 48l0 80 512 0 0-80c0-26.5-21.5-48-48-48L48 224zM512 384L0 384 0 464c0 26.5 21.5 48 48 48l416 0c26.5 0 48-21.5 48-48l0-80zM64 272a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM48 448a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM448 272a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM432 448a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"],
    "sun-haze": [576, 512, [], "f765", "M177.8-10.1c7.4-3.1 15.8-2.2 22.5 2.2L288 50.3 375.8-7.9c6.7-4.4 15.1-5.2 22.5-2.2S411-.5 412.6 7.3l20.9 103.2 103.2 20.9c7.8 1.6 14.4 7 17.4 14.3s2.2 15.8-2.2 22.5l-58.2 87.8 42.5 64-137.3 0c10.9-18.8 17.1-40.7 17.1-64 0-70.7-57.3-128-128-128S160 185.3 160 256c0 23.3 6.2 45.2 17.1 64l-137.3 0 42.5-64-58.2-87.8c-4.4-6.7-5.2-15.1-2.2-22.5s9.6-12.8 17.4-14.3L142.6 110.6 163.4 7.3c1.6-7.8 7-14.4 14.3-17.4zM368 256c0 26.2-12.6 49.4-32 64l-96 0c-19.4-14.6-32-37.8-32-64 0-44.2 35.8-80 80-80s80 35.8 80 80zM512 392c0 13.3-10.7 24-24 24L24 416c-13.3 0-24-10.7-24-24s10.7-24 24-24l464 0c13.3 0 24 10.7 24 24zM64 488c0-13.3 10.7-24 24-24l80 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24zm176 0c0-13.3 10.7-24 24-24l288 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-288 0c-13.3 0-24-10.7-24-24z"],
    "circle-3": [512, 512, [], "e0f0", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm20-280c11 0 20-9 20-20s-9-20-20-20l-76 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l76 0c37.6 0 68 30.4 68 68 0 16.8-6.1 32.1-16.2 44 10.1 11.9 16.2 27.2 16.2 44 0 37.6-30.4 68-68 68l-76 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l76 0c11 0 20-9 20-20s-9-20-20-20l-52 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l52 0z"],
    "clipboard-check": [384, 512, [], "f46c", "M256 0c23.7 0 44.4 12.9 55.4 32l8.6 0c35.3 0 64 28.7 64 64l0 352c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l8.6 0C83.6 12.9 104.3 0 128 0L256 0zm26.9 212.6c-10.7-7.8-25.7-5.4-33.5 5.3l-85.6 117.7-26.5-27.4c-9.2-9.5-24.4-9.8-33.9-.6s-9.8 24.4-.6 33.9l46.4 48c4.9 5.1 11.8 7.8 18.9 7.3s13.6-4.1 17.8-9.8L288.2 246.1c7.8-10.7 5.4-25.7-5.3-33.5zM136 64c-13.3 0-24 10.7-24 24s10.7 24 24 24l112 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L136 64z"],
    "share-from-square": [576, 512, [61509, "share-square"], "f14d", "M384.5 24l0 72-64 0c-79.5 0-144 64.5-144 144 0 93.4 82.8 134.8 100.6 142.6 2.2 1 4.6 1.4 7.1 1.4l2.5 0c9.8 0 17.8-8 17.8-17.8 0-8.3-5.9-15.5-12.8-20.3-8.9-6.2-19.2-18.2-19.2-40.5 0-45 36.5-81.5 81.5-81.5l30.5 0 0 72c0 9.7 5.8 18.5 14.8 22.2s19.3 1.7 26.2-5.2l136-136c9.4-9.4 9.4-24.6 0-33.9L425.5 7c-6.9-6.9-17.2-8.9-26.2-5.2S384.5 14.3 384.5 24zm-272 72c-44.2 0-80 35.8-80 80l0 256c0 44.2 35.8 80 80 80l256 0c44.2 0 80-35.8 80-80l0-32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 32c0 8.8-7.2 16-16 16l-256 0c-8.8 0-16-7.2-16-16l0-256c0-8.8 7.2-16 16-16l16 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-16 0z"],
    "fork-knife": [512, 512, ["utensils-alt"], "f2e6", "M411.6 27.3c5.8-5.8 6.3-15.1 1.1-21.5s-14.4-7.7-21.2-3.2l-106.5 71c-27.9 18.6-44.6 49.9-44.6 83.4 0 19.3 5.5 37.9 15.7 53.9L9.6 457.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L301.2 256.3c16 10.2 34.7 15.7 53.9 15.7 33.5 0 64.8-16.8 83.4-44.6l71-106.5c4.6-6.8 3.2-16-3.2-21.2s-15.6-4.8-21.5 1.1L393.6 192c-5.2 5.2-13.6 5.2-18.8 0-4.9-4.9-5.2-12.8-.6-18.1l86.1-99.4c5.5-6.3 5.2-15.9-.8-21.8s-15.4-6.3-21.8-.8L338.4 138c-5.3 4.6-13.2 4.3-18.1-.6-5.2-5.2-5.2-13.6 0-18.8l91.3-91.3zM86.6 38.4C74.3 26 54.2 26 41.8 38.4-7.6 87.9-7.6 168.1 41.8 217.6l69.8 69.8 87-87c-4.2-13.9-6.5-28.5-6.5-43.3 0-4.2 .2-8.4 .5-12.6L86.6 38.4zm371 467c12.5 12.5 32.8 12.5 45.3 0l2.7-2.7c12.5-12.5 12.5-32.8 0-45.3L367.7 319.5c-4.2 .4-8.4 .5-12.6 .5-14.8 0-29.4-2.2-43.3-6.5l-23 23 168.8 168.8z"],
    "receipt": [384, 512, [129534], "f543", "M14 2.2C22.5-1.7 32.5-.3 39.6 5.8L80 40.4 120.4 5.8c9-7.7 22.3-7.7 31.2 0L192 40.4 232.4 5.8c9-7.7 22.2-7.7 31.2 0L304 40.4 344.4 5.8c7.1-6.1 17.1-7.5 25.6-3.6S384 14.6 384 24l0 464c0 9.4-5.5 17.9-14 21.8s-18.5 2.5-25.6-3.6l-40.4-34.6-40.4 34.6c-9 7.7-22.2 7.7-31.2 0l-40.4-34.6-40.4 34.6c-9 7.7-22.3 7.7-31.2 0L80 471.6 39.6 506.2c-7.1 6.1-17.1 7.5-25.6 3.6S0 497.4 0 488L0 24C0 14.6 5.5 6.1 14 2.2zM104 136c-13.3 0-24 10.7-24 24s10.7 24 24 24l176 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-176 0zM80 352c0 13.3 10.7 24 24 24l176 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-176 0c-13.3 0-24 10.7-24 24zm24-120c-13.3 0-24 10.7-24 24s10.7 24 24 24l176 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-176 0z"],
    "equals": [448, 512, [62764], "3d", "M32 128c-17.7 0-32 14.3-32 32s14.3 32 32 32l384 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 128zm0 192c-17.7 0-32 14.3-32 32s14.3 32 32 32l384 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 320z"],
    "diagram-lean-canvas": [576, 512, [], "e156", "M464 96l0 176 48 0 0-176-48 0zm-48 0l-48 0 0 64 48 0 0-64zm-96 0l-64 0 0 176 64 0 0-176zM208 96l-48 0 0 64 48 0 0-64zm-96 0l-48 0 0 176 48 0 0-176zM64 320l0 96 200 0 0-96-200 0zm248 96l200 0 0-96-200 0 0 96zM0 96C0 60.7 28.7 32 64 32l448 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM208 272l0-64-48 0 0 64 48 0zm208-64l-48 0 0 64 48 0 0-64z"],
    "box-arrow-up": [448, 512, [], "e827", "M335.1 16c20.7 0 40.1 10 52.1 26.8l48.9 68.5c7.7 10.8 11.9 23.9 11.9 37.2l0 267.5-.3 6.5c-3.1 30.1-27 54.1-57.1 57.1l-6.5 .3-320 0-6.5-.3c-30.1-3.1-54.1-27-57.1-57.1L0 416 0 148.5c0-11.7 3.2-23.1 9.2-33l2.7-4.2 48.9-68.5c10.5-14.7 26.7-24.2 44.4-26.3l7.7-.5 222.1 0zM241 207c-8.8-8.8-22.7-9.3-32.1-1.7l-1.8 1.7-72 72c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l31-31 0 102.1c0 13.3 10.7 24 24 24s24-10.7 24-24l0-102.1 31 31 1.8 1.7c9.4 7.7 23.3 7.1 32.1-1.7s9.3-22.7 1.7-32.1l-1.7-1.8-72-72zM78.7 128l290.7 0-34.3-48-222.1 0-34.3 48z"],
    "chevron-up": [448, 512, [], "f077", "M201.4 105.4c12.5-12.5 32.8-12.5 45.3 0l192 192c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L224 173.3 54.6 342.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l192-192z"],
    "virus-slash": [576, 512, [], "e075", "M41-24.9c-9.4-9.4-24.6-9.4-33.9 0S-2.3-.3 7 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-88.6-88.6c1.7-12.1-2-24.8-11.3-34-31.2-31.2-9.1-84.5 35-84.5 22.1 0 40-17.9 40-40s-17.9-40-40-40c-44.1 0-66.1-53.3-35-84.5 15.6-15.6 15.6-40.9 0-56.6s-40.9-15.6-56.6 0c-31.2 31.2-84.5 9.1-84.5-35 0-22.1-17.9-40-40-40s-40 17.9-40 40c0 44.1-53.3 66.1-84.5 35-9.3-9.3-22-13-34-11.3L41-24.9zM72 216c-22.1 0-40 17.9-40 40s17.9 40 40 40c44.1 0 66.1 53.3 35 84.5-15.6 15.6-15.6 40.9 0 56.6s40.9 15.6 56.6 0c31.2-31.2 84.5-9.1 84.5 35 0 22.1 17.9 40 40 40s40-17.9 40-40c0-21.4 12.6-37.6 29.1-45.1l-240-240C109.6 203.4 93.4 216 72 216z"],
    "globe-stand": [448, 512, [], "f5f6", "M15 367c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l18.5-18.5c34.3 27.7 74.9 43.8 116.5 48.3l0 33.3-96 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l240 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-96 0 0-33.3c49.1-5.3 96.8-26.7 134.4-64.3 81.7-81.7 87.1-211 16.1-298.9L401 49c9.4-9.4 9.4-24.6 0-33.9S376.4 5.7 367 15L332.5 49.6c-9.4 9.4-9.4 24.6 0 33.9 68.7 68.7 68.7 180.2 0 248.9s-180.2 68.7-248.9 0c-9.4-9.4-24.6-9.4-33.9 0L15 367zm193-15a144 144 0 1 0 0-288 144 144 0 1 0 0 288z"],
    "ring-diamond": [384, 512, [], "e5ab", "M122.5 13.3C126.6 5.1 134.9 0 144 0l96 0c9.1 0 17.4 5.1 21.5 13.3l24 48c3.5 7.1 3.4 15.5-.5 22.4l-30.4 54.8C329.9 164.4 384 235.9 384 320 384 426 298 512 192 512S0 426 0 320c0-84.1 54.1-155.6 129.4-181.6L99 83.7c-3.8-6.9-4-15.3-.5-22.4l24-48zM192 192a128 128 0 1 0 0 256 128 128 0 1 0 0-256z"],
    "phone-rotary": [512, 512, [9742], "f8d3", "M0 147.9c0-12.7 5-24.9 15-32.9 32.8-26.2 118-83 241-83s208.3 56.8 241 83c9.9 8 15 20.1 15 32.9l0 28.1c0 26.5-21.5 48-48 48l-11.6 0-41.4-62.1c-20.8-31.2-55.7-49.9-93.2-49.9l-123.5 0c-37.4 0-72.4 18.7-93.2 49.9L59.6 224 48 224c-26.5 0-48-21.5-48-48l0-28.1zM32 416l0-42.2c0-14.2 4.2-28.1 12.1-39.9L141 188.5c11.9-17.8 31.9-28.5 53.3-28.5l123.5 0c21.4 0 41.4 10.7 53.3 28.5l96.9 145.4c7.9 11.8 12.1 25.7 12.1 39.9l0 42.2c0 35.3-28.7 64-64 64L96 480c-35.3 0-64-28.7-64-64zM328 312a72 72 0 1 0 -144 0 72 72 0 1 0 144 0z"],
    "slash": [576, 512, [], "f715", "M7-25c9.4-9.4 24.6-9.4 33.9 0L569 503c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0L7 9C-2.3-.4-2.3-15.6 7-25z"],
    "arrow-down-to-dotted-line": [384, 512, [], "e095", "M0 480c0 17.7 14.3 32 32 32s32-14.3 32-32-14.3-32-32-32-32 14.3-32 32zM169.4 374.6c12.5 12.5 32.8 12.5 45.3 0l128-128c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L224 274.7 224 32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 242.7-73.4-73.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l128 128zM138.7 512c17.7 0 32-14.3 32-32s-14.3-32-32-32-32 14.3-32 32 14.3 32 32 32zm74.7-32c0 17.7 14.3 32 32 32s32-14.3 32-32-14.3-32-32-32-32 14.3-32 32zM352 512c17.7 0 32-14.3 32-32s-14.3-32-32-32-32 14.3-32 32 14.3 32 32 32z"],
    "saxophone-fire": [640, 512, ["sax-hot"], "f8db", "M158.4 27.6l-9.8 11-15.2-15.9c-1.6-1.7-3.2-3.5-4.8-5.3-7.2-8.2-14.9-17-26.2-17.3-5.8-.1-11.7 1.9-16.3 6-18.7 16.9-40 39.1-56.7 64.1-16.6 24.9-29.4 53.7-29.4 83.6 0 2.1 0 4.2 .1 6.3L87 160c9.9-16.7 24.8-30.9 33.6-38.6 4.3-3.7 10.5-3.7 14.8 0 8.8 7.7 23.7 21.9 33.6 38.6l86.9 0c.1-2.1 .1-4.2 .1-6.3 0-24-8.8-48.7-20.9-70.5-12.2-21.9-28.2-41.9-44-56.5-4.5-4.2-10.2-6.2-15.9-6.2-6.1 0-12.4 2.2-16.7 7.1zm21.7 302.2l49.2-73.8 2.7 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L24 208c-13.3 0-24 10.7-24 24 0 9.5 5.5 17.7 13.5 21.6L2.7 313C.9 323 0 333.1 0 343.2l0 7c0 89.3 72.4 161.8 161.8 161.8 49.4 0 96.1-22.6 126.8-61.4L534.4 140.1c6.1-7.7 15.3-12.1 25.1-12.1l64.2 0c9 0 16.3-7.3 16.3-16.3 0-4.9-2.2-9.5-5.9-12.6L609.8 78.8c-11.5-9.6-26-14.8-41-14.8l-30.3 0c-17 0-33.3 6.7-45.3 18.7l-44.3 44.3-8-8c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l8 8-14.1 14.1-8-8c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l8 8-14.1 14.1-8-8c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l8 8-104.4 104.4c-4.2 4.2-10 6.6-16 6.6-12.5 0-22.6-10.1-22.6-22.6l0-1.9c0-4.9 1.4-9.6 4.1-13.6zM144 280a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zM88 344a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"],
    "window-frame-open": [448, 512, [], "e050", "M416 224l0-160c0-35.3-28.7-64-64-64L96 0C60.7 0 32 28.7 32 64l0 224 384 0 0-64zm-224 0l-96 0 0-160 96 0 0 160zm64 0l0-160 96 0 0 160-96 0zM96 448l0-112-64 0 0 112c-17.7 0-32 14.3-32 32s14.3 32 32 32l384 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l0-112-64 0 0 112-256 0z"],
    "circle-d": [512, 512, [], "e104", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM184 144l72 0c61.9 0 112 50.1 112 112S317.9 368 256 368l-72 0c-13.3 0-24-10.7-24-24l0-176c0-13.3 10.7-24 24-24zm72 176c35.3 0 64-28.7 64-64s-28.7-64-64-64l-48 0 0 128 48 0z"],
    "expand": [448, 512, [], "f065", "M32 32C14.3 32 0 46.3 0 64l0 96c0 17.7 14.3 32 32 32s32-14.3 32-32l0-64 64 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 32zM64 352c0-17.7-14.3-32-32-32S0 334.3 0 352l0 96c0 17.7 14.3 32 32 32l96 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0 0-64zM320 32c-17.7 0-32 14.3-32 32s14.3 32 32 32l64 0 0 64c0 17.7 14.3 32 32 32s32-14.3 32-32l0-96c0-17.7-14.3-32-32-32l-96 0zM448 352c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 64-64 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l96 0c17.7 0 32-14.3 32-32l0-96z"],
    "scooter": [512, 512, [], "e7c3", "M256 64c0-17.7 14.3-32 32-32l64 0c14.6 0 27.3 9.9 31 24l64 248 4.8 18.5c34.6 8.8 60.3 40.2 60.3 77.5 0 44.2-35.8 80-80 80-32.8 0-61-19.7-73.3-48l-205.3 0c-12.3 28.3-40.5 48-73.3 48-44.2 0-80-35.8-80-80s35.8-80 80-80c32.8 0 61 19.7 73.3 48l205.3 0c6.3-14.4 16.7-26.6 29.7-35.1L385 320 327.2 96 288 96c-17.7 0-32-14.3-32-32zM112 400a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm352 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "file-mp4": [576, 512, [], "e649", "M96 0C60.7 0 32 28.7 32 64l0 384c0 35.3 28.7 64 64 64l48 0 0-112c0-35.3 28.7-64 64-64l208 0 0-165.5c0-17-6.7-33.3-18.7-45.3L290.7 18.7C278.7 6.7 262.5 0 245.5 0L96 0zM357.5 176L264 176c-13.3 0-24-10.7-24-24L240 58.5 357.5 176zM225.1 389.7c-4.6-7.7-13.8-11.4-22.5-9S188 391 188 400l0 128c0 11 9 20 20 20s20-9 20-20l0-55.8 10.9 18.1c3.6 6 10.1 9.7 17.1 9.7s13.5-3.7 17.1-9.7l10.9-18.1 0 55.8c0 11 9 20 20 20s20-9 20-20l0-128c0-9-6-16.9-14.7-19.3s-17.9 1.3-22.5 9l-30.9 51.4-30.9-51.4zM368 380c-11 0-20 9-20 20l0 128c0 11 9 20 20 20s20-9 20-20l0-28 12 0c33.1 0 60-26.9 60-60s-26.9-60-60-60l-32 0zm32 80l-12 0 0-40 12 0c11 0 20 9 20 20s-9 20-20 20zm81.9 18.1c3.8 3.8 8.8 5.9 14.1 5.9l44 0 0 44c0 11 9 20 20 20s20-9 20-20l0-128c0-11-9-20-20-20s-20 9-20 20l0 44-24 0 0-44c0-11-9-20-20-20s-20 9-20 20l0 64c0 5.3 2.1 10.4 5.9 14.1z"],
    "note-sticky": [448, 512, [62026, "sticky-note"], "f249", "M64 480c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 213.5c0 17-6.7 33.3-18.7 45.3L322.7 461.3c-12 12-28.3 18.7-45.3 18.7L64 480zM389.5 304L296 304c-13.3 0-24 10.7-24 24l0 93.5 117.5-117.5z"],
    "dolphin": [512, 512, [], "e168", "M477.3 24.9c3.5-5.3 3.6-12.2 .1-17.6S467.7-.8 461.4 .2C444.7 3 418.3 8.8 392.6 17.2 378 22 362.5 28 349 35.3 306.5 12.8 258 0 206.5 0L176 0c-79.5 0-144 64.5-144 144 0 18.6 3.5 36.4 10 52.7L20.5 209.6C7.8 217.2 0 231 0 245.8 0 269.1 18.9 288 42.2 288l160.9 0 92 61.3c4.9 3.3 11.2 3.6 16.4 .8s8.5-8.2 8.5-14.1l0-48 6.6 0c31.7 0 57.4 25.7 57.4 57.4 0 30.6-24 55.8-54.5 57.3l-53.4 2.7c-20.2-33-56.3-53.4-95.4-53.4l-4.7 0c-5.5 0-10.7 2.9-13.6 7.6s-3.2 10.6-.7 15.6l28.4 56.8-28.4 56.8c-2.5 5-2.2 10.9 .7 15.6s8.1 7.6 13.6 7.6l4.7 0c35.9 0 69.2-17.1 90.1-45.4l68 3.8c94.1 5.2 173.3-70 173.3-164.3 0-80.8-31.4-154.5-82.7-209.3l48-72zM176 120a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"],
    "border-bottom": [448, 512, [], "f84d", "M448 448c0 17.7-14.3 32-32 32L32 480c-17.7 0-32-14.3-32-32s14.3-32 32-32l384 0c17.7 0 32 14.3 32 32zM384 320a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM64 320a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM384 192a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM64 192a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM384 64a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM64 64A32 32 0 1 1 0 64 32 32 0 1 1 64 64zm192 0a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm-64 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z"],
    "user-message": [576, 512, [], "e7b1", "M320 48l0 96c0 26.5 21.5 48 48 48l16 0 0 41.4c0 14.3 17.2 21.4 27.3 11.3l52.7-52.7 64 0c26.5 0 48-21.5 48-48l0-96c0-26.5-21.5-48-48-48L368 0c-26.5 0-48 21.5-48 48zm-48 0c0-9.8 1.5-19.2 4.2-28.1-15.8-7.6-33.5-11.9-52.2-11.9-66.3 0-120 53.7-120 120s53.7 120 120 120c31.2 0 59.7-11.9 81.1-31.5-20.3-17.6-33.1-43.5-33.1-72.5l0-96zM194.3 304C95.8 304 16 383.8 16 482.3 16 498.7 29.3 512 45.7 512l356.6 0c16.4 0 29.7-13.3 29.7-29.7 0-98.5-79.8-178.3-178.3-178.3l-59.4 0z"],
    "signal-weak": [512, 512, ["signal-1"], "f68c", "M48 384c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-48c0-13.3 10.7-24 24-24z"],
    "table-columns": [448, 512, ["columns"], "f0db", "M0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm64 64l0 256 128 0 0-256-128 0zm320 0l-128 0 0 256 128 0 0-256z"],
    "person-shelter": [512, 512, [], "e54f", "M271.9 4.2c-9.8-5.6-21.9-5.6-31.8 0l-224 128C6.2 137.9 0 148.5 0 160L0 480c0 17.7 14.3 32 32 32s32-14.3 32-32L64 178.6 256 68.9 448 178.6 448 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-320c0-11.5-6.2-22.1-16.1-27.8l-224-128zM256 208a40 40 0 1 0 0-80 40 40 0 1 0 0 80zm-8 192l16 0 0 88c0 13.3 10.7 24 24 24s24-10.7 24-24l0-174.5 26.9 49.9c6.3 11.7 20.8 16 32.5 9.8s16-20.8 9.8-32.5l-33.2-61.7C329.7 245.1 294.4 224 256 224s-73.7 21.1-91.9 54.9l-33.2 61.7c-6.3 11.7-1.9 26.2 9.8 32.5s26.2 1.9 32.5-9.8L200 313.5 200 488c0 13.3 10.7 24 24 24s24-10.7 24-24l0-88z"],
    "camera-security": [448, 512, ["camera-home"], "f8fe", "M64 0C28.7 0 0 28.7 0 64L0 352c0 35.3 28.7 64 64 64l136 0 0 48-80 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l208 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0 0-48 136 0c35.3 0 64-28.7 64-64l0-288c0-35.3-28.7-64-64-64L64 0zM224 96a112 112 0 1 1 0 224 112 112 0 1 1 0-224z"],
    "circle-notch": [512, 512, [], "f1ce", "M222.7 32.1c5 16.9-4.6 34.8-21.5 39.8-79.3 23.6-137.1 97.1-137.1 184.1 0 106 86 192 192 192s192-86 192-192c0-86.9-57.8-160.4-137.1-184.1-16.9-5-26.6-22.9-21.5-39.8s22.9-26.6 39.8-21.5C434.9 42.1 512 140 512 256 512 397.4 397.4 512 256 512S0 397.4 0 256c0-116 77.1-213.9 182.9-245.4 16.9-5 34.8 4.6 39.8 21.5z"],
    "water": [512, 512, [], "f773", "M410.6 124.1c20.7 15.6 46 30.7 74.2 34.5 13.1 1.8 25.2-7.5 27-20.6s-7.5-25.2-20.6-27c-15.9-2.1-33.2-11.3-51.7-25.2-38.4-29-90.5-29-129 0-24 18.1-40.7 26.3-54.5 26.3s-30.5-8.2-54.5-26.3c-38.4-29-90.5-29-129 0-18.5 13.9-35.8 23.1-51.7 25.2-13.1 1.8-22.4 13.8-20.6 27s13.8 22.4 27 20.6c28.2-3.8 53.6-18.9 74.2-34.5 21.3-16.1 49.9-16.1 71.2 0 24.2 18.3 52.3 35.9 83.4 35.9s59.1-17.7 83.4-35.9c21.3-16.1 49.9-16.1 71.2 0zm0 144c20.7 15.6 46 30.7 74.2 34.5 13.1 1.8 25.2-7.5 27-20.6s-7.5-25.2-20.6-27c-15.9-2.1-33.2-11.3-51.7-25.2-38.4-29-90.5-29-129 0-24 18.1-40.7 26.3-54.5 26.3s-30.5-8.2-54.5-26.3c-38.4-29-90.5-29-129 0-18.5 13.9-35.8 23.1-51.7 25.2-13.1 1.7-22.4 13.8-20.6 27s13.8 22.4 27 20.6c28.2-3.8 53.6-18.9 74.2-34.5 21.3-16.1 49.9-16.1 71.2 0 24.2 18.3 52.3 35.9 83.4 35.9s59.1-17.7 83.4-35.9c21.3-16.1 49.9-16.1 71.2 0zm-71.2 144c21.3-16.1 49.9-16.1 71.2 0 20.7 15.6 46 30.7 74.2 34.5 13.1 1.8 25.2-7.5 27-20.6s-7.5-25.2-20.6-27c-15.9-2.1-33.2-11.3-51.7-25.2-38.4-29-90.5-29-129 0-24 18.1-40.7 26.3-54.5 26.3s-30.5-8.2-54.5-26.3c-38.4-29-90.5-29-129 0-18.5 13.9-35.8 23.1-51.7 25.2-13.1 1.8-22.4 13.8-20.6 27s13.8 22.4 27 20.6c28.2-3.8 53.6-18.9 74.2-34.5 21.3-16.1 49.9-16.1 71.2 0 24.2 18.3 52.3 35.9 83.4 35.9s59.1-17.7 83.4-35.9z"],
    "delete-left": [640, 512, [9003, "backspace"], "f55a", "M576 128c0-35.3-28.7-64-64-64L205.3 64c-17 0-33.3 6.7-45.3 18.7L9.4 233.4c-6 6-9.4 14.1-9.4 22.6s3.4 16.6 9.4 22.6L160 429.3c12 12 28.3 18.7 45.3 18.7L512 448c35.3 0 64-28.7 64-64l0-256zM284.1 188.1c9.4-9.4 24.6-9.4 33.9 0l33.9 33.9 33.9-33.9c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-33.9 33.9 33.9 33.9c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-33.9-33.9-33.9 33.9c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l33.9-33.9-33.9-33.9c-9.4-9.4-9.4-24.6 0-33.9z"],
    "circle-rupee": [512, 512, [], "e714", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM152 144l48 0c39.8 0 72 32.2 72 72 0 26.9-14.7 50.3-36.5 62.6l19.3 57.8c4.2 12.6-2.6 26.2-15.2 30.4s-26.2-2.6-30.4-15.2l-21.2-63.6-12 0 0 56c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-176c0-13.3 10.7-24 24-24zm48 96c13.3 0 24-10.7 24-24s-10.7-24-24-24l-24 0 0 48 24 0zm80 .1c0-31 25.1-56.1 56.1-56.1l39.9 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-39.9 0c-4.5 0-8.1 3.6-8.1 8.1 0 3.6 2.3 6.7 5.8 7.8L368 258.1c23.7 7.1 40 29 40 53.7 0 31-25.1 56.1-56.1 56.1L312 368c-13.3 0-24-10.7-24-24s10.7-24 24-24l39.9 0c4.5 0 8.1-3.6 8.1-8.1 0-3.6-2.3-6.7-5.8-7.8L320 293.9c-23.7-7.1-40-29-40-53.7z"],
    "arrow-down-to-square": [448, 512, [], "e096", "M256 0c0-17.7-14.3-32-32-32S192-17.7 192 0l0 242.7-9.4-9.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l64 64c12.5 12.5 32.8 12.5 45.3 0l64-64c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L256 242.7 256 0zM64 96C28.7 96 0 124.7 0 160L0 448c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-288c0-35.3-28.7-64-64-64l-32 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l32 0 0 288-320 0 0-288 32 0c17.7 0 32-14.3 32-32S113.7 96 96 96L64 96z"],
    "square-b": [448, 512, [], "e264", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm80 136c0-13.3 10.7-24 24-24l68 0c37.6 0 68 30.4 68 68 0 12.7-3.5 24.7-9.6 34.8 15.6 12.5 25.6 31.6 25.6 53.2 0 37.6-30.4 68-68 68l-84 0c-13.3 0-24-10.7-24-24l0-176zm112 44c0-11-9-20-20-20l-44 0 0 40 44 0c11 0 20-9 20-20zM192 320l60 0c11 0 20-9 20-20s-9-20-20-20l-60 0 0 40z"],
    "broom-ball": [576, 512, ["quidditch", "quidditch-broom-ball"], "f458", "M496 544a80 80 0 1 1 0-160 80 80 0 1 1 0 160zM106.8 277.2c30.6-30.6 73.1-45.9 115.8-42.2L341 353.3c3.7 42.8-11.6 85.2-42.2 115.9-27.4 27.4-64.6 42.8-103.3 42.8L22.1 512c-12.2 0-22.1-9.9-22.1-22.1 0-6.3 2.7-12.3 7.3-16.5L133.7 359.7c4.2-3.7-.4-10.4-5.4-7.9L77.2 377.4c-6.1 3-13.2-1.4-13.2-8.2 0-31.5 12.5-61.8 34.8-84l8-8zm417-270c12.6-10.3 31.1-9.5 42.8 2.2s12.4 30.2 2.2 42.8l-2.2 2.4-192 192 34.8 34.7c4.2 4.2 6.6 10 6.6 16 0 12.5-10.1 22.6-22.6 22.6l-29.1 0-108.3-108.3 0-29.1c0-12.5 10.1-22.6 22.6-22.6 6 0 11.8 2.4 16 6.6l34.8 34.7 192-192 2.4-2.2z"],
    "h6": [512, 512, [], "e413", "M32 64c17.7 0 32 14.3 32 32l0 128 96 0 0-128c0-17.7 14.3-32 32-32s32 14.3 32 32l0 320c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-128-96 0 0 128c0 17.7-14.3 32-32 32S0 433.7 0 416L0 96C0 78.3 14.3 64 32 64zm352 64c-17.7 0-32 14.3-32 32l0 53.5c10-3.5 20.8-5.5 32-5.5l32 0c53 0 96 43 96 96l0 48c0 53-43 96-96 96l-32 0c-53 0-96-43-96-96l0-192c0-53 43-96 96-96l64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-64 0zM352 304l0 48c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-48c0-17.7-14.3-32-32-32l-32 0c-17.7 0-32 14.3-32 32z"],
    "j": [320, 512, [106], "4a", "M288 32c17.7 0 32 14.3 32 32l0 256c0 88.4-71.6 160-160 160S0 408.4 0 320l0-32c0-17.7 14.3-32 32-32s32 14.3 32 32l0 32c0 53 43 96 96 96s96-43 96-96l0-256c0-17.7 14.3-32 32-32z"],
    "shuttle-space": [576, 512, ["space-shuttle"], "f197", "M0 368l0 64c0 26.5 21.5 48 48 48l50 0c40.6 0 80.4-11 115.2-31.9l133.5-80.1-93.3 0-64.9 38.9c-14 8.4-28.9 14.7-44.5 19l0-66.4c9.7-5.6 17.8-13.7 23.4-23.4l198.8 0c67.1 0 127.8-20.6 170.3-70.6 4.6-5.4 4.6-13.3 0-18.8-42.5-50.1-103.2-70.6-170.3-70.6l-198.8 0c-5.6-9.7-13.7-17.8-23.4-23.4l0-66.4c15.6 4.2 30.6 10.6 44.5 19l64.9 38.9 93.3 0-133.5-80.1C178.4 43 138.6 32 98 32L48 32C21.5 32 0 53.5 0 80L0 368zm96 0l0 64-48 0 0-64 48 0zM96 80l0 64-48 0 0-64 48 0zM416 224c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16z"],
    "yin-yang": [512, 512, [9775], "f6ad", "M224 160a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm32 352a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm0-448c53 0 96 43 96 96s-43 96-96 96-96 43-96 96 43 96 96 96C150 448 64 362 64 256S150 64 256 64zM224 352a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"],
    "signal-good": [512, 512, ["signal-3"], "f68e", "M280 248c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 208c0 13.3 10.7 24 24 24s24-10.7 24-24l0-208zM152 320c-13.3 0-24 10.7-24 24l0 112c0 13.3 10.7 24 24 24s24-10.7 24-24l0-112c0-13.3-10.7-24-24-24zM48 384c-13.3 0-24 10.7-24 24l0 48c0 13.3 10.7 24 24 24s24-10.7 24-24l0-48c0-13.3-10.7-24-24-24z"],
    "image-stack": [512, 512, [], "e771", "M96-8c0-13.3 10.7-24 24-24l272 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L120 16C106.7 16 96 5.3 96-8zM48 88c0-13.3 10.7-24 24-24l368 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L72 112c-13.3 0-24-10.7-24-24zM0 224c0-35.3 28.7-64 64-64l384 0c35.3 0 64 28.7 64 64l0 192c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 224zm96 64a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm224-32c-7.4 0-14.3 3.4-18.9 9.2l-42.6 54.3-14.8-21.2c-4.5-6.4-11.8-10.2-19.7-10.2s-15.2 3.8-19.7 10.2l-56 80c-5.1 7.3-5.8 16.9-1.6 24.8S159.1 416 168 416l240 0c9.2 0 17.6-5.2 21.6-13.5s3-18.1-2.7-25.3l-88-112c-4.6-5.8-11.5-9.2-18.9-9.2z"],
    "stop": [448, 512, [9209], "f04d", "M64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32z"],
    "trowel": [576, 512, [], "e589", "M407.9 181.4L277.3 312 342.6 377.4c7.9 7.9 11.1 19.4 8.4 30.3s-10.8 19.6-21.5 22.9l-256 80c-11.4 3.5-23.8 .5-32.2-7.9s-11.5-20.8-7.9-32.2l80-256c3.3-10.7 12-18.9 22.9-21.5s22.4 .5 30.3 8.4L232 266.7 362.6 136.1c-14.3-14.6-14.2-38 .3-52.5l95.4-95.4c26.9-26.9 70.5-26.9 97.5 0s26.9 70.5 0 97.5l-95.4 95.4c-14.5 14.5-37.9 14.6-52.5 .3z"],
    "circle-2": [512, 512, [], "e0ef", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM208 145.3l62 0c36.5 0 66 29.6 66 66 0 27.1-16.6 51.5-41.9 61.4l-44.7 17.6c-12.9 5.1-22.1 16.3-24.6 29.6l79.3 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-104 0c-13.3 0-24-10.7-24-24l0-16.4c0-36.2 22.1-68.7 55.8-81.9l44.7-17.6c6.9-2.7 11.4-9.4 11.4-16.8 0-10-8.1-18-18-18l-62 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"],
    "drumstick": [512, 512, [127831], "f6d6", "M150.6 287.8c6-6 9.4-14.1 9.4-22.6l0-89.2C160 78.8 238.8 0 336 0s176 78.8 176 176-78.8 176-176 176l-89.2 0c-8.5 0-16.6 3.4-22.6 9.4l-26.8 26.8c-12.3 12.3-11.4 32.5-7.2 49.4 1.1 4.6 1.8 9.5 1.8 14.5 0 33.1-26.9 60-60 60s-60-26.9-60-60c0-6.3-5.7-12-12-12-33.1 0-60-26.9-60-60s26.9-60 60-60c5 0 9.8 .6 14.5 1.8 16.9 4.2 37.1 5.2 49.4-7.2l26.8-26.8z"],
    "square-x": [448, 512, [], "e286", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM170.6 152.8l53.4 65.3 53.4-65.3c8.4-10.3 23.5-11.8 33.8-3.4s11.8 23.5 3.4 33.8L255 256 314.6 328.8c8.4 10.3 6.9 25.4-3.4 33.8s-25.4 6.9-33.8-3.4l-53.4-65.3-53.4 65.3c-8.4 10.3-23.5 11.8-33.8 3.4s-11.8-23.5-3.4-33.8L193 256 133.4 183.2c-8.4-10.3-6.9-25.4 3.4-33.8s25.4-6.9 33.8 3.4z"],
    "peapod": [512, 512, [], "e31c", "M464 0L416 0C186.2 0 0 186.2 0 416l0 48c0 26.5 21.5 48 48 48l48 0c229.8 0 416-186.2 416-416l0-48c0-26.5-21.5-48-48-48zM256 200a56 56 0 1 1 0 112 56 56 0 1 1 0-112zM88 368a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zM368 88a56 56 0 1 1 0 112 56 56 0 1 1 0-112z"],
    "message-text": [512, 512, ["comment-alt-text"], "e1e6", "M0 128L0 352c0 53 43 96 96 96l32 0 0 72c0 13.3 10.7 24 24 24 5.2 0 10.2-1.7 14.4-4.8l115.2-86.4c4.2-3.1 9.2-4.8 14.4-4.8l120 0c53 0 96-43 96-96l0-224c0-53-43-96-96-96L96 32C43 32 0 75 0 128zm184 16l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0 0 120c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-120-48 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"],
    "hand-back-fist": [384, 512, ["hand-rock"], "f255", "M7.4 253.6C2.6 245.9 0 237.1 0 228l0-36c0-26.5 21.5-48 48-48l16 0 0-80c0-26.5 21.5-48 48-48 17.3 0 32.4 9.1 40.9 22.8 4.3-22.1 23.8-38.8 47.1-38.8 23.4 0 42.9 16.8 47.1 38.9 7.3-4.4 15.8-6.9 24.9-6.9 22.1 0 40.8 15 46.3 35.4 5.5-2.2 11.4-3.4 17.7-3.4 26.5 0 48 21.5 48 48l0 96.9c0 9.9-2.3 19.7-6.8 28.6l-39.6 79.1c-10.8 21.7-33 35.4-57.2 35.4L96 352c-16.5 0-31.8-8.4-40.6-22.4l-48-76zM32 480l0-48c0-17.7 14.3-32 32-32l256 0c17.7 0 32 14.3 32 32l0 48c0 17.7-14.3 32-32 32L64 512c-17.7 0-32-14.3-32-32z"],
    "snowman-head": [448, 512, ["frosty-head"], "f79b", "M64 64C64 28.7 92.7 0 128 0L320 0c35.3 0 64 28.7 64 64l0 96-320 0 0-96zM330.2 192l85.8 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-25.7 0c16.3 28.2 25.7 61 25.7 96 0 59.8-27.4 113.3-70.3 148.5-9.7 8-22.3 11.5-34.9 11.5l-173.7 0c-12.6 0-25.1-3.5-34.9-11.5-42.9-35.2-70.3-88.7-70.3-148.5 0-35 9.3-67.8 25.7-96L32 256c-17.7 0-32-14.3-32-32s14.3-32 32-32l298.2 0zM152 336a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm168-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM219.3 445.2c.9 1.7 2.7 2.8 4.7 2.8s3.8-1.1 4.7-2.8l23.8-46.3c2.3-4.5 3.5-9.6 3.5-14.7 0-17.7-14.3-32.2-32-32.2s-32 14.5-32 32.2c0 5.1 1.2 10.2 3.5 14.7l23.8 46.3z"],
    "blanket": [448, 512, [], "f498", "M120 480C56.4 480 4.4 430.5 .3 368L0 368 0 120C0 71.4 39.4 32 88 32l272 0c48.6 0 88 39.4 88 88l0 192c0 39.8-32.2 72-72 72l-256 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l256 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-256 0c-39.8 0-72 32.2-72 72s32.2 72 72 72l304 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-304 0z"],
    "comment-xmark": [512, 512, ["comment-times"], "f4b5", "M256 480c141.4 0 256-107.5 256-240S397.4 0 256 0 0 107.5 0 240c0 54.3 19.2 104.3 51.6 144.5L2.8 476.8c-4.8 9-3.3 20 3.6 27.5s17.8 9.8 27.1 5.8l118.4-50.7C183.7 472.6 218.9 480 256 480zm67.9-307.9c9.4 9.4 9.4 24.6 0 33.9l-33.9 33.9 33.9 33.9c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-33.9-33.9-33.9 33.9c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l33.9-33.9-33.9-33.9c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l33.9 33.9 33.9-33.9c9.4-9.4 24.6-9.4 33.9 0z"],
    "person-dolly-empty": [512, 512, [], "f4d1", "M120 24A56 56 0 1 0 8 24 56 56 0 1 0 120 24zM59.1 112C26.5 112 0 138.5 0 171.1L0 272c0 30.2 14.2 58.7 38.4 76.8l76.8 57.6c8.1 6 12.8 15.5 12.8 25.6l0 80c0 17.7 14.3 32 32 32s32-14.3 32-32l0-80c0-30.2-14.2-58.7-38.4-76.8l-41.6-31.2 0-80.1 2.8 3.9c18 25.2 47.1 40.2 78.1 40.2l63.1 0 0 162.7c-18.6 6.6-32 24.4-32 45.3 0 26.5 21.5 48 48 48 20.9 0 38.7-13.4 45.3-32L488 512c13.3 0 24-10.7 24-24s-10.7-24-24-24l-184 0 0-280c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 40-63.1 0c-10.3 0-20-5-26-13.4l-48.7-68.2C104.6 123.3 82.5 112 59.1 112zM0 512c0 17.7 14.3 32 32 32s32-14.3 32-32l0-84-54.4-40.8c-3.3-2.5-6.5-5.1-9.6-7.9L0 512z"],
    "signal-slash": [576, 512, [], "f695", "M41-24.9c-9.4-9.4-24.6-9.4-33.9 0S-2.3-.3 7 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-49-49 0-398.2c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 350.2-56-56 0-198.2c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 150.2-327-327zM312 381.8l-48-48 0 122.2c0 13.3 10.7 24 24 24s24-10.7 24-24l0-74.2zM184 320c-13.3 0-24 10.7-24 24l0 112c0 13.3 10.7 24 24 24s24-10.7 24-24l0-112c0-13.3-10.7-24-24-24zM80 384c-13.3 0-24 10.7-24 24l0 48c0 13.3 10.7 24 24 24s24-10.7 24-24l0-48c0-13.3-10.7-24-24-24z"],
    "hexagon-plus": [576, 512, ["plus-hexagon"], "f300", "M33.5 291.8c-12.7-22.2-12.7-49.4 0-71.5L129.7 52.2C142.5 29.8 166.4 16 192.2 16l191.6 0c25.8 0 49.7 13.8 62.5 36.2l96.2 168.1c12.7 22.2 12.7 49.4 0 71.5L446.3 459.9c-12.8 22.4-36.7 36.2-62.5 36.2l-191.6 0c-25.8 0-49.7-13.8-62.5-36.2L33.5 291.8zM264 344c0 13.3 10.7 24 24 24s24-10.7 24-24l0-64 64 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-64 0 0-64c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 64-64 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l64 0 0 64z"],
    "temperature-high": [512, 512, [], "f769", "M96 96c0-53 43-96 96-96s96 43 96 96l0 164.7c29.5 26.4 48 64.7 48 107.3 0 79.5-64.5 144-144 144S48 447.5 48 368c0-42.6 18.5-81 48-107.3L96 96zm96 336c35.3 0 64-28.7 64-64 0-26.9-16.5-49.9-40-59.3L216 96c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 212.7c-23.5 9.5-40 32.5-40 59.3 0 35.3 28.7 64 64 64zM464 80a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM352 80a80 80 0 1 1 160 0 80 80 0 1 1 -160 0z"],
    "greater-than": [512, 512, [62769], "3e", "M34.9 50.6c-7.4 16-.4 35.1 15.6 42.5L403.6 256 50.6 419c-16 7.4-23.1 26.4-15.6 42.5s26.4 23 42.5 15.6l416-192c11.3-5.2 18.6-16.6 18.6-29.1s-7.3-23.8-18.6-29.1L77.4 35c-16-7.4-35.1-.4-42.5 15.6z"],
    "toothbrush": [576, 512, [129701], "f635", "M64 224c-35.3 0-64-28.7-64-64S28.7 96 64 96l224 0c31.2 0 38.2-22.7 39.6-48 .5-8.8 7.6-16.1 16.4-15.2 52.4 5.3 104 36.7 104 95.2 0 53-43 96-96 96L64 224zm-8 32c13.3 0 24 10.7 24 24l0 136 32 0 0-136c0-13.3 10.7-24 24-24s24 10.7 24 24l0 136 32 0 0-136c0-13.3 10.7-24 24-24s24 10.7 24 24l0 136 32 0 0-136c0-13.3 10.7-24 24-24s24 10.7 24 24l0 136 32 0 0-136c0-13.3 10.7-24 24-24s24 10.7 24 24l0 136 144 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 480c-17.7 0-32-14.3-32-32s14.3-32 32-32l0-136c0-13.3 10.7-24 24-24z"],
    "flute": [576, 512, [], "f8b9", "M505.9-1.9c-18.7-18.7-49.1-18.7-67.9 0l-275 275 107.9 107.9 275-275c18.7-18.7 18.7-49.1 0-67.9l-40-40zM237 414.9l-107.9-107.9-99 99c-18.7 18.7-18.7 49.1 0 67.9l40 40c18.7 18.7 49.1 18.7 67.9 0l99-99zM288 232a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM120 400a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM352 168a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm88-88a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"],
    "lobster": [512, 512, [129438], "e421", "M80 8.2C80 4.6 77.5 1.3 73.9 .8 70.7 .3 67.4 0 64 0 28.7 0 0 28.7 0 64l0 64c0 35.3 28.7 64 64 64l.7 0 41.8 27.9C126.2 233 149.4 240 173.1 240l18.9 0 0 16-48.9 0c-7.5 0-14.8-1.7-21.5-5.1L87.2 233.7c-7.9-4-17.5-.7-21.5 7.2s-.7 17.5 7.2 21.5l34.5 17.2c11.1 5.6 23.4 8.4 35.8 8.4l48.9 0 0 16-69.6 0c-5.2 0-10.3-.8-15.2-2.5L69.1 288.8c-8.4-2.8-17.4 1.7-20.2 10.1s1.7 17.4 10.1 20.2l38.1 12.7c8.2 2.7 16.7 4.1 25.3 4.1l69.6 0 0 16-16.9 0c-12.4 0-24.7 2.9-35.8 8.4l-18.5 9.2c-7.9 4-11.1 13.6-7.2 21.5s13.6 11.1 21.5 7.2l18.5-9.2c6.7-3.3 14-5.1 21.5-5.1l16.9 0 21.4 64.1c-29.8 1.8-53.4 26.5-53.4 56.8 0 3.9 3.2 7.1 7.1 7.1l177.8 0c3.9 0 7.1-3.2 7.1-7.1 0-30.2-23.6-55-53.4-56.8l21.4-64.1 16.9 0c7.4 0 14.8 1.7 21.5 5.1l18.5 9.2c7.9 4 17.5 .7 21.5-7.2s.7-17.5-7.2-21.5l-18.5-9.2c-11.1-5.6-23.4-8.4-35.8-8.4l-16.9 0 0-16 69.6 0c8.6 0 17.1-1.4 25.3-4.1l38.1-12.7c8.4-2.8 12.9-11.9 10.1-20.2s-11.9-12.9-20.2-10.1l-38.1 12.7c-4.9 1.6-10 2.5-15.2 2.5l-69.6 0 0-16 48.9 0c12.4 0 24.7-2.9 35.8-8.4l34.5-17.2c7.9-4 11.1-13.6 7.2-21.5s-13.6-11.1-21.5-7.2l-34.5 17.2c-6.7 3.3-14 5.1-21.5 5.1l-48.9 0 0-16 18.9 0c23.7 0 46.9-7 66.6-20.2l41.8-27.9 .7 0c35.3 0 64-28.7 64-64l0-64c0-35.3-28.7-64-64-64-3.4 0-6.7 .3-9.9 .8-3.6 .6-6.1 3.8-6.1 7.5L432 72c0 7.7-9.8 11-14.4 4.8L397.4 49.9c-3.7-4.9-11.2-3.9-12.3 2.1-.7 3.9-1.1 7.9-1.1 11.9l0 64c0 14.9 5.1 28.6 13.6 39.4l-18.7 12.5C367 187.8 353.1 192 338.9 192l-24.7 0c-2.7-7.3-6.2-14-10.2-20.2l0-91.1c0-15.6 11.3-29 26.7-31.6l7.9-1.3c8.7-1.5 14.6-9.7 13.2-18.4s-9.7-14.6-18.4-13.2l-7.9 1.3C294.6 22.7 272 49.4 272 80.7l0 57.3c-3.1-2.3-6.2-4.4-9-6.1-4.3-2.6-9.7-2.6-13.9 0-2.8 1.7-5.9 3.8-9 6.1l0-57.3c0-31.3-22.6-58-53.5-63.1l-7.9-1.3c-8.7-1.5-17 4.4-18.4 13.2s4.4 17 13.2 18.4l7.9 1.3C196.7 51.7 208 65 208 80.7l0 91.1c-4 6.2-7.5 13-10.2 20.2l-24.7 0c-14.2 0-28.1-4.2-39.9-12.1l-18.7-12.5c8.5-10.9 13.6-24.6 13.6-39.4l0-64c0-4.1-.4-8.1-1.1-11.9-1.1-6-8.6-7.1-12.3-2.1L94.4 76.8C89.8 83 80 79.7 80 72L80 8.2z"],
    "calendar-circle-exclamation": [576, 512, [], "e46e", "M192 32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 32-32 0c-35.3 0-64 28.7-64 64l0 48 448 0 0-48c0-35.3-28.7-64-64-64l-32 0 0-32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 32-128 0 0-32zM32 416c0 35.3 28.7 64 64 64l161.4 0c-11.2-24.4-17.4-51.4-17.4-80 0-78.7 47.4-146.4 115.1-176L32 224 32 416zM432 544a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm0-100a20 20 0 1 1 0 40 20 20 0 1 1 0-40zm0-140c8.8 0 16 7.2 16 16l0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80c0-8.8 7.2-16 16-16z"],
    "mobile-rotate": [576, 512, [], "e813", "M52.7 339.3c6.2-6.2 16.4-6.2 22.6 0l48 48c3 3 4.7 7.1 4.7 11.3l0 1.4c0 8.8-7.2 16-16 16l-23.5 0c4 36 34.5 64 71.5 64 18.3 0 35-6.9 47.8-18.2l34.1 34c-21.4 20-50.2 32.2-81.8 32.2-63.6 0-115.6-49.5-119.7-112L16 416c-8.8 0-16-7.2-16-16l0-1.4c0-4.2 1.7-8.3 4.7-11.3l48-48zm130.9-325c25.1-20.5 62.2-19 85.7 4.4l256 256 4.4 4.8c20.5 25.1 19 62.2-4.4 85.7l-128 128c-23.4 23.4-60.5 24.9-85.7 4.4l-4.8-4.4-256-256c-25-25-25-65.5 0-90.5l128-128 4.8-4.4zM440.9 327c-8.8-8.8-22.7-9.3-32.1-1.7l-1.8 1.7-48 48c-9.4 9.4-9.4 24.6 0 33.9 9.4 9.4 24.6 9.4 34 0l48-48 1.7-1.8c7.7-9.4 7.1-23.3-1.7-32.1zM416-16c63.6 0 115.6 49.5 119.7 112L560 96c8.8 0 16 7.2 16 16l0 1.4c0 4.2-1.7 8.3-4.7 11.3l-48 48c-6.2 6.2-16.4 6.2-22.6 0l-48-48c-3-3-4.7-7.1-4.7-11.3l0-1.4c0-8.8 7.2-16 16-16l23.5 0c-4-36-34.5-64-71.5-64-18.3 0-35 6.9-47.8 18.2l-34.1-34C355.6-3.7 384.4-16 416-16z"],
    "crutch": [512, 512, [], "f7f7", "M297.4 9.4c12.5-12.5 32.8-12.5 45.3 0l160 160c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0l-1.4-1.4-158.6 158.6c-18 18-42.4 28.1-67.9 28.1l-59 0c-8.5 0-16.6 3.4-22.6 9.4-61.7 61.7-92.8 92.8-93.3 93.3-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l16-16 0 0 77.3-77.3c6-6 9.4-14.1 9.4-22.6l0-59c0-25.5 10.1-49.9 28.1-67.9L298.7 56 297.4 54.6c-12.5-12.5-12.5-32.8 0-45.3zM344 101.3L261.3 184 328 250.7 410.7 168 344 101.3zm-128 128l-30.6 30.6c-6 6-9.4 14.1-9.4 22.6l0 53.5 53.5 0c8.5 0 16.6-3.4 22.6-9.4L282.7 296 216 229.3z"],
    "command": [512, 512, [], "e142", "M104 208l40 0 0 96-40 0C46.6 304 0 350.6 0 408s46.6 104 104 104 104-46.6 104-104l0-40 96 0 0 40c0 57.4 46.6 104 104 104s104-46.6 104-104-46.6-104-104-104l-40 0 0-96 40 0c57.4 0 104-46.6 104-104S465.4 0 408 0 304 46.6 304 104l0 40-96 0 0-40C208 46.6 161.4 0 104 0S0 46.6 0 104 46.6 208 104 208zm152 96l-48 0 0-96 96 0 0 96-48 0zM104 144c-22.1 0-40-17.9-40-40s17.9-40 40-40 40 17.9 40 40l0 40-40 0zm40 264c0 22.1-17.9 40-40 40s-40-17.9-40-40 17.9-40 40-40l40 0 0 40zM368 144l0-40c0-22.1 17.9-40 40-40s40 17.9 40 40-17.9 40-40 40l-40 0zm40 224c22.1 0 40 17.9 40 40s-17.9 40-40 40-40-17.9-40-40l0-40 40 0z"],
    "tv-retro": [512, 512, [128250], "f401", "M137.4 9.4c12.5-12.5 32.8-12.5 45.3 0L256 82.7 329.4 9.4c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3L333.3 96 448 96c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 160c0-35.3 28.7-64 64-64l114.7 0-41.4-41.4c-12.5-12.5-12.5-32.8 0-45.3zM112 160c-26.5 0-48 21.5-48 48l0 160c0 26.5 21.5 48 48 48l224 0c26.5 0 48-21.5 48-48l0-160c0-26.5-21.5-48-48-48l-224 0zm360 72a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM448 336a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"],
    "paw-claws": [512, 512, [], "f702", "M256.5 224c41.3 0 134.4 35.9 186.8 177.2 3.6 9.7 5.2 20.1 5.2 30.5l0 1.6c0 25.8-20.9 46.7-46.7 46.7-11.5 0-22.9-1.4-34-4.2l-88-22c-15.3-3.8-31.3-3.8-46.6 0l-88 22c-11.1 2.8-22.5 4.2-34 4.2-25.8 0-46.8-20.9-46.8-46.7l0-1.6c0-10.4 1.6-20.8 5.2-30.5 52.4-141.3 145.5-177.2 186.8-177.2zM24.5 112c13.3 0 24 10.7 24 24l0 24.4c19.3 2.3 39.6 16.2 52.4 38.2 18.9 32.4 14.3 70.1-10.2 84.2s-59.7-.9-78.5-33.3C4.2 235.8 .5 221.3 .5 208l0-72c0-13.3 10.7-24 24-24zm464 0c13.3 0 24 10.7 24 24l0 72c.1 13.3-3.7 27.8-11.6 41.4-18.9 32.4-54 47.3-78.5 33.3s-29.1-51.7-10.2-84.2c12.8-22 33-35.8 52.4-38.2l0-24.4c0-13.3 10.7-24 24-24zM136.5-16c13.2 0 24 10.8 24 24l0 24.3c29.8-3 61.6 22 74.5 60.5 14.3 42.9-.3 86.2-32.6 96.8S132.3 174 118 131.2c-4-11.9-5.7-23.9-5.4-35.2l-.1-88c0-13.2 10.7-24 24-24zm240 0c13.2 0 24 10.8 24 24l-.1 88c.2 11.3-1.4 23.2-5.4 35.2-14.3 42.9-52.1 69.1-84.4 58.5S263.7 135.7 278 92.8c12.9-38.6 44.7-63.6 74.5-60.5l0-24.3c0-13.2 10.8-24 24-24z"],
    "septagon": [576, 512, ["heptagon"], "e820", "M267.4-31.5c15.9-5.5 33.5-4.6 48.8 2.7l172.4 83 6.3 3.5c14.2 9 24.5 23.3 28.3 39.9l42.6 186.5 1.2 7.2c1.6 14.3-1.7 28.8-9.4 41.1l-4.2 5.9-119.3 149.6c-12.1 15.2-30.6 24.1-50 24.1l-191.3 0c-19.5 0-37.9-8.9-50-24.1L23.5 338.4c-12.1-15.2-16.7-35.2-12.3-54.2l42.6-186.5 2-7c5.6-15.9 17.2-29 32.6-36.4l172.4-83 6.7-2.7z"],
    "face-smile-upside-down": [512, 512, [], "e395", "M256 0a256 256 0 1 0 0 512 256 256 0 1 0 0-512zm90.6 190.1c-20.4-28-53.4-46.1-90.6-46.1s-70.2 18.1-90.6 46.1c-7.8 10.7-22.8 13.1-33.5 5.3s-13.1-22.8-5.3-33.5C155.7 122 202.8 96 256 96s100.3 26 129.4 65.9c7.8 10.7 5.4 25.7-5.3 33.5s-25.7 5.4-33.5-5.3zM368 304a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM176 336a32 32 0 1 1 0-64 32 32 0 1 1 0 64z"],
    "glass-empty": [384, 512, [], "e191", "M8.6 10.2C14.6 3.7 23.1 0 32 0L352 0c8.9 0 17.4 3.7 23.4 10.2s9.1 15.2 8.5 24.1L355.1 437.7c-3 41.9-37.8 74.3-79.8 74.3l-166.6 0c-42 0-76.8-32.4-79.8-74.3L.1 34.3c-.6-8.9 2.4-17.6 8.5-24.1zM66.4 64L92.7 433.1c.6 8.4 7.6 14.9 16 14.9l166.6 0c8.4 0 15.4-6.5 16-14.9L317.6 64 66.4 64z"],
    "ear": [384, 512, [128066], "f5f0", "M304 348c-12 8.6-22.3 19.7-27.8 33.4l-20.1 50.2C236.7 480.1 189.7 512 137.3 512l-9.3 0C57.3 512 0 454.7 0 384L0 192C0 86 86 0 192 0S384 86 384 192c0 64.2-31.5 121.1-80 156zM112 192c0-44.2 35.8-80 80-80s80 35.8 80 80l0 8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-8c0-70.7-57.3-128-128-128S64 121.3 64 192l0 40c0 13.3 10.7 24 24 24l16 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-16 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l16 0c39.8 0 72-32.2 72-72 0-37.1-28-67.6-64-71.6l0-16.4z"],
    "street-view": [512, 512, [], "f21d", "M256 0a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM224 160l64 0c35.3 0 64 28.7 64 64l0 48c0 17.7-14.3 32-32 32l-1.8 0-11.1 99.5c-1.8 16.2-15.5 28.5-31.8 28.5l-38.7 0c-16.3 0-30-12.3-31.8-28.5l-11.1-99.5-1.8 0c-17.7 0-32-14.3-32-32l0-48c0-35.3 28.7-64 64-64zM412.4 400.2c-16.1-4.2-34.8-7.6-55.4-10.2l5.3-47.7c22.7 2.9 43.7 6.7 62.1 11.5 22.4 5.8 42.6 13.3 57.8 23.3 14.7 9.6 29.8 24.9 29.8 47s-15.1 37.4-29.8 47c-15.2 9.9-35.5 17.5-57.8 23.3-45.1 11.7-105.3 17.8-168.4 17.8s-123.3-6.1-168.4-17.8C65.2 488.4 45 480.9 29.8 471 15.1 461.4 0 446.1 0 424s15.1-37.4 29.8-47c15.2-9.9 35.5-17.5 57.8-23.3 18.5-4.8 39.5-8.6 62.1-11.5L155 390c-20.6 2.6-39.3 6.1-55.4 10.2-56.6 14.6-56.6 32.9 0 47.5 39.9 10.3 95.8 16.2 156.4 16.2s116.5-5.9 156.4-16.2c56.6-14.6 56.6-32.9 0-47.5z"],
    "briefs": [512, 512, [], "e6d0", "M48 64C21.5 64 0 85.5 0 112l512 0c0-26.5-21.5-48-48-48L48 64zm288 96l-160 0 0 37.9c0 42.6-12.6 84.3-36.3 119.8l-17.8 26.7c13.9 16.3 24.5 35.4 31 56.3 7.8 25.3 28.6 47.3 55.1 47.3l96 0c26.5 0 47.3-22 55.1-47.3 6.5-20.9 17.1-40 31-56.3l-17.8-26.7C348.6 282.2 336 240.5 336 197.9l0-37.9zm48 0l0 37.9c0 33.2 9.8 65.6 28.2 93.2l14.4 21.6c11.8-7.4 24.5-13.4 38.1-17.6 25.3-7.8 47.3-28.6 47.3-55.1l0-80-128 0zM0 160l0 80c0 26.5 22 47.3 47.3 55.1 13.6 4.2 26.3 10.1 38.1 17.6l14.4-21.6c18.4-27.6 28.2-60 28.2-93.2l0-37.9-128 0z"],
    "speakers": [448, 512, [], "f8e0", "M160-32C124.7-32 96-3.3 96 32l0 352c0 35.3 28.7 64 64 64l224 0c35.3 0 64-28.7 64-64l0-352c0-35.3-28.7-64-64-64L160-32zM272 184a104 104 0 1 1 0 208 104 104 0 1 1 0-208zm56 104a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zM240 64a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM48 88c0-13.3-10.7-24-24-24S0 74.7 0 88L0 480c0 35.3 28.7 64 64 64l264 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L64 496c-8.8 0-16-7.2-16-16L48 88z"],
    "wave-square": [512, 512, [], "f83e", "M64 96c0-17.7 14.3-32 32-32l160 0c17.7 0 32 14.3 32 32l0 288 96 0 0-128c0-17.7 14.3-32 32-32l64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32 0 0 128c0 17.7-14.3 32-32 32l-160 0c-17.7 0-32-14.3-32-32l0-288-96 0 0 128c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l32 0 0-128z"],
    "angle-left": [256, 512, [8249], "f104", "M9.4 233.4c-12.5 12.5-12.5 32.8 0 45.3l160 160c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L77.3 256 214.6 118.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-160 160z"],
    "turtle": [576, 512, [128034], "f726", "M384 249.2c0 21.4-17.4 38.8-38.8 38.8L70.8 288C49.4 288 32 270.6 32 249.2L32 208c0-97.2 78.8-176 176-176s176 78.8 176 176l0 41.2zM480 288c-2 0-4-.1-5.9-.3-16.3 53.3-64.3 92.7-122.1 96l0 56.2c0 22.1-17.9 40-40 40l-48 0c-22.1 0-40-17.9-40-40l0-56-32 0 0 56c0 22.1-17.9 40-40 40l-48 0c-22.1 0-40-17.9-40-40l0-56-32 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l312 0c39.8 0 72-32.2 72-72l0-72c0-35.3 28.7-64 64-64 53 0 96 43 96 96l0 16c0 35.3-28.7 64-64 64l-32 0zm16-64a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"],
    "arrow-right-to-line": [512, 512, [8677, "arrow-to-right"], "f340", "M512 96c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 320c0 17.7 14.3 32 32 32s32-14.3 32-32l0-320zM374.6 278.6c12.5-12.5 12.5-32.8 0-45.3l-128-128c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L274.7 224 32 224c-17.7 0-32 14.3-32 32s14.3 32 32 32l242.7 0-73.4 73.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l128-128z"],
    "pants-straight": [448, 512, [], "e6d6", "M414.4 0L34.5 0C16 0 1.4 15.6 2.6 34l1.9 30 100 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-97 0 23.1 370c1.1 16.9 15 30 31.9 30l105.9 0c17.7 0 32-14.3 32-32l0-264c0-13.3 10.7-24 24-24s24 10.7 24 24l0 264c0 17.7 14.3 32 32 32l105.9 0c16.9 0 30.9-13.1 31.9-30l23.1-370-97 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l100 0 1.9-30c1.2-18.4-13.5-34-31.9-34z"],
    "screwdriver": [576, 512, [129691], "f54a", "M352.1 146.7l0-49.6c0-10.7 5.3-20.7 14.2-26.6L485.2-8.7c6.3-4.2 14.8-3.4 20.2 2l45.4 45.5c5.4 5.4 6.2 13.8 2 20.2L473.6 177.8c-5.9 8.9-15.9 14.2-26.6 14.2l-49.6 0-90.7 90.7c15 33.3 8.9 73.9-18.5 101.3L162.1 510.1c-18.7 18.7-49.1 18.7-67.9 0L34.1 449.9c-18.7-18.7-18.7-49.1 0-67.9L160.1 256c27.4-27.4 67.9-33.6 101.3-18.5l90.7-90.7z"],
    "traffic-light-stop": [320, 512, [], "f63a", "M64-32C28.7-32 0-3.3 0 32L0 384c0 88.4 71.6 160 160 160s160-71.6 160-160l0-352c0-35.3-28.7-64-64-64L64-32zm96 392c30.9 0 56 25.1 56 56s-25.1 56-56 56-56-25.1-56-56 25.1-56 56-56zm56-104a56 56 0 1 1 -112 0 56 56 0 1 1 112 0zM160 152a56 56 0 1 1 0-112 56 56 0 1 1 0 112zm24 104a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM160 440c13.3 0 24-10.7 24-24s-10.7-24-24-24-24 10.7-24 24 10.7 24 24 24z"],
    "square-euro": [448, 512, [], "e732", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm199.9 88l33 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-33 0c-31 0-58.3 15.9-74.2 40l50.3 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-63.3 0c-1 5.4-1.6 11-1.6 16.8 0 5.2 .4 10.3 1.3 15.2l63.5 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-51.2 0c15.7 24.9 43.5 41.5 75.2 41.5l33 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-33 0c-58.9 0-109.1-37.3-128.4-89.5L120 304c-8.8 0-16-7.2-16-16s7.2-16 16-16l8 0c-.6-5-.8-10.1-.8-15.2 0-5.7 .3-11.3 1-16.8l-8.2 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l16.1 0c19.6-51.5 69.5-88 127.8-88z"],
    "tractor": [576, 512, [128668], "f722", "M160 96l0 96 133.4 0-57.6-96-75.8 0zM96 223L96 64c0-17.7 14.3-32 32-32l107.8 0c22.5 0 43.3 11.8 54.9 31.1l77.4 128.9 64 0 0-72c0-13.3 10.7-24 24-24s24 10.7 24 24l0 72 48 0c26.5 0 48 21.5 48 48l0 41.5c0 14.2-6.3 27.8-17.3 36.9l-35 29.2c26.5 15.2 44.3 43.7 44.3 76.4 0 48.6-39.4 88-88 88s-88-39.4-88-88c0-14.4 3.5-28 9.6-40l-101.2 0c-3 13.4-7.9 26-14.4 37.7 7.7 9.4 7.2 23.4-1.6 32.2l-22.6 22.6c-8.8 8.8-22.7 9.3-32.2 1.6-9.3 5.2-19.3 9.3-29.8 12.3-1.2 12.1-11.4 21.6-23.9 21.6l-32 0c-12.4 0-22.7-9.5-23.9-21.6-10.5-3-20.4-7.2-29.8-12.3-9.4 7.7-23.4 7.2-32.2-1.6L35.5 453.8c-8.8-8.8-9.3-22.7-1.6-32.2-5.2-9.3-9.3-19.3-12.3-29.8-12.1-1.2-21.6-11.4-21.6-23.9l0-32c0-12.4 9.5-22.7 21.6-23.9 3-10.5 7.2-20.4 12.3-29.8-7.7-9.4-7.2-23.4 1.6-32.2l22.6-22.6c8.8-8.8 22.7-9.3 32.2-1.6 1.9-1 3.7-2 5.7-3zm64 65a64 64 0 1 0 0 128 64 64 0 1 0 0-128zM440 424a40 40 0 1 0 80 0 40 40 0 1 0 -80 0z"],
    "bridge-circle-xmark": [576, 512, [], "e4cb", "M32 32C14.3 32 0 46.3 0 64S14.3 96 32 96l8 0 0 64-40 0 0 112c37.6 9.4 64 43.2 64 82l0 94c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-64c0-53 43-96 96-96 6.4 0 12.7 .6 18.7 1.8 34.7-49.5 92.2-81.8 157.3-81.8 28.6 0 55.6 6.2 80 17.4l0-65.4-40 0 0-64 8 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 32zM424 96l0 64-80 0 0-64 80 0zM296 96l0 64-80 0 0-64 80 0zM88 96l80 0 0 64-80 0 0-64zM432 544a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm59.3-180.7l-36.7 36.7 36.7 36.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-36.7-36.7-36.7 36.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l36.7-36.7-36.7-36.7c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l36.7 36.7 36.7-36.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6z"],
    "vials": [512, 512, [], "f493", "M32 0C14.3 0 0 14.3 0 32S14.3 64 32 64l0 352c0 53 43 96 96 96s96-43 96-96l0-352 64 0 0 352c0 53 43 96 96 96s96-43 96-96l0-352c17.7 0 32-14.3 32-32S497.7 0 480 0L32 0zM160 64l0 128-64 0 0-128 64 0zm256 0l0 128-64 0 0-128 64 0z"],
    "starfighter-twin-ion-engine-advanced": [576, 512, ["starfighter-alt-advanced"], "e28e", "M152.3 52.8c11.5-13.4 9.9-33.6-3.5-45.1s-33.6-9.9-45.1 3.5l-88.3 103C5.5 125.8 0 140.6 0 155.8L0 356.2c0 15.3 5.5 30.1 15.4 41.7l88.3 103c11.5 13.4 31.7 15 45.1 3.5s15-31.7 3.5-45.1l-88.3-103 0-55.4 75.6 15.1C163.3 374.6 220.8 416 288 416s124.7-41.4 148.4-100.1l75.6-15.1 0 48-89 111.2c-11 13.8-8.8 33.9 5 45s33.9 8.8 45-5l89-111.2c9.1-11.3 14-25.4 14-40l0-200.3c0-16.1-6.1-31.6-17-43.4L471.5 10.3c-12-13-32.2-13.8-45.2-1.8s-13.8 32.2-1.8 45.2l87.5 94.8 0 62.7-75.6-15.1C412.7 137.4 355.2 96 288 96S163.3 137.4 139.6 196.1l-75.6 15.1 0-55.4 88.3-103zM288 160a96 96 0 1 1 0 192 96 96 0 1 1 0-192zm0 152a56 56 0 1 0 0-112 56 56 0 1 0 0 112z"],
    "stethoscope": [576, 512, [129658], "f0f1", "M32 48C32 21.5 53.5 0 80 0l48 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32 0 0 128c0 53 43 96 96 96s96-43 96-96l0-128-32 0c-17.7 0-32-14.3-32-32S238.3 0 256 0l48 0c26.5 0 48 21.5 48 48l0 144c0 77.4-55 142-128 156.8l0 19.2c0 61.9 50.1 112 112 112s112-50.1 112-112l0-85.5c-37.3-13.2-64-48.7-64-90.5 0-53 43-96 96-96s96 43 96 96c0 41.8-26.7 77.4-64 90.5l0 85.5c0 97.2-78.8 176-176 176S160 465.2 160 368l0-19.2C87 334 32 269.4 32 192L32 48zM480 224a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "podcast": [448, 512, [], "f2ce", "M336 359.8c39.1-32.3 64-81.1 64-135.8 0-97.2-78.8-176-176-176S48 126.8 48 224C48 278.7 72.9 327.5 112 359.8 112.4 377.4 115.2 400.2 118.4 421.6 48 383.9 0 309.5 0 224 0 100.3 100.3 0 224 0S448 100.3 448 224c0 85.6-48 159.9-118.5 197.6 3.3-21.4 6-44.2 6.4-61.8zm-14-53.4c-8.3-12.6-19.2-21.6-30.4-27.8-2.1-1.1-4.2-2.2-6.3-3.2 11.7-13.9 18.8-31.9 18.8-51.5 0-44.2-35.8-80-80-80s-80 35.8-80 80c0 19.6 7.1 37.6 18.8 51.5-2.1 1-4.2 2-6.3 3.2-11.2 6.2-22.1 15.2-30.4 27.8-18.8-22.3-30.1-51-30.1-82.4 0-70.7 57.3-128 128-128s128 57.3 128 128c0 31.4-11.3 60.2-30.1 82.4zM224 312c32.9 0 64 8.6 64 43.8 0 33-12.9 104.1-20.6 132.9-5.1 19-24.5 23.4-43.4 23.4s-38.2-4.4-43.4-23.4c-7.8-28.5-20.6-99.7-20.6-132.8 0-35.1 31.1-43.8 64-43.8zm0-128a40 40 0 1 1 0 80 40 40 0 1 1 0-80z"],
    "arrow-up-right-dots": [512, 512, [], "e4b7", "M96 32C78.3 32 64 46.3 64 64S78.3 96 96 96L114.7 96 9.4 201.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L160 141.3 160 160c0 17.7 14.3 32 32 32s32-14.3 32-32l0-96c0-17.7-14.3-32-32-32L96 32zM403.8 70.1a38.1 38.1 0 1 0 76.2 0 38.1 38.1 0 1 0 -76.2 0zM279.7 194.2a38.1 38.1 0 1 0 76.2 0 38.1 38.1 0 1 0 -76.2 0zm162.2-38.1a38.1 38.1 0 1 0 0 76.2 38.1 38.1 0 1 0 0-76.2zM156.2 317.8a38.1 38.1 0 1 0 76.2 0 38.1 38.1 0 1 0 -76.2 0zm161.6-38.1a38.1 38.1 0 1 0 0 76.2 38.1 38.1 0 1 0 0-76.2zm86.1 38.1a38.1 38.1 0 1 0 76.2 0 38.1 38.1 0 1 0 -76.2 0zM70.1 403.8a38.1 38.1 0 1 0 0 76.2 38.1 38.1 0 1 0 0-76.2zm86.1 38.1a38.1 38.1 0 1 0 76.2 0 38.1 38.1 0 1 0 -76.2 0zm161.6-38.1a38.1 38.1 0 1 0 0 76.2 38.1 38.1 0 1 0 0-76.2zm86.1 38.1a38.1 38.1 0 1 0 76.2 0 38.1 38.1 0 1 0 -76.2 0z"],
    "chess-queen": [512, 512, [9819], "f445", "M256 80a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM5.5 185L128 384 71.8 454.3c-5 6.3-7.8 14.1-7.8 22.2 0 19.6 15.9 35.5 35.5 35.5l312.9 0c19.6 0 35.5-15.9 35.5-35.5 0-8.1-2.7-15.9-7.8-22.2L384 384 506.5 185c3.6-5.9 5.5-12.7 5.5-19.6l0-.6c0-20.3-16.5-36.8-36.8-36.8-7.3 0-14.4 2.2-20.4 6.2l-16.9 11.3c-12.7 8.5-29.6 6.8-40.4-4l-34.1-34.1C356.1 100.1 346.2 96 336 96s-20.1 4.1-27.3 11.3l-30.1 30.1c-12.5 12.5-32.8 12.5-45.3 0l-30.1-30.1C196.1 100.1 186.2 96 176 96s-20.1 4.1-27.3 11.3l-34.1 34.1c-10.8 10.8-27.7 12.5-40.4 4L57.3 134.2c-6.1-4-13.2-6.2-20.4-6.2-20.3 0-36.8 16.5-36.8 36.8l0 .6c0 6.9 1.9 13.7 5.5 19.6z"],
    "anchor-circle-exclamation": [640, 512, [], "e4ab", "M320.5 96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm-32-96c-53 0-96 43-96 96 0 41.8 26.7 77.4 64 90.5l0 257.9c-62.9-14.3-110.2-69.7-111.9-136.5l16.1 14.1c10 8.7 25.1 7.7 33.9-2.3s7.7-25.1-2.3-33.9l-64-56c-9-7.9-22.6-7.9-31.6 0l-64 56c-10 8.7-11 23.9-2.3 33.9s23.9 11 33.9 2.3l16.2-14.2c2.1 113.1 94.4 204.1 208 204.1 16.6 0 32.7-1.9 48.2-5.6-20.3-30.5-32.2-67-32.2-106.4 0-27.3 5.7-53.3 16-76.9l0-136.6c37.3-13.2 64-48.7 64-90.5 0-53-43-96-96-96zm208 544a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm0-100a20 20 0 1 1 0 40 20 20 0 1 1 0-40zm0-140c8.8 0 16 7.2 16 16l0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80c0-8.8 7.2-16 16-16z"],
    "ellipsis-vertical": [128, 512, ["ellipsis-v"], "f142", "M64 144a56 56 0 1 1 0-112 56 56 0 1 1 0 112zm0 224c30.9 0 56 25.1 56 56s-25.1 56-56 56-56-25.1-56-56 25.1-56 56-56zm56-112c0 30.9-25.1 56-56 56s-56-25.1-56-56 25.1-56 56-56 56 25.1 56 56z"],
    "acorn": [448, 512, [], "f6ae", "M399.6 240c-4.1 78.1-39 189.3-165.5 236.4-6.5 2.4-13.7 2.4-20.2 0-126.5-47.2-161.4-158.3-165.5-236.4l351.1 0zM228.8 9.6c8-10.6 23-12.8 33.6-4.8s12.7 23 4.8 33.6l-4.8 6.4c-4.4 5.9-7.9 12.4-10.3 19.2L352 64c53 0 96 43 96 96 0 17.7-14.3 32-32 32L32 192c-17.7 0-32-14.3-32-32 0-53 43-96 96-96l106.4 0C206 46.7 213.3 30.3 224 16l4.8-6.4z"],
    "ban-parking": [512, 512, ["parking-circle-slash"], "f616", "M412.5 367.2L342.3 297c20.6-17.6 33.7-43.8 33.7-73 0-53-43-96-96-96l-72 0c-9.7 0-18.6 3.5-25.5 9.2L144.8 99.5c31.4-22.4 69.8-35.5 111.2-35.5 106 0 192 86 192 192 0 41.5-13.1 79.9-35.5 111.2zm-45.3 45.3c-31.4 22.4-69.8 35.5-111.2 35.5-106 0-192-86-192-192 0-41.5 13.1-79.9 35.5-111.2L168 213.3 168 352c0 17.7 14.3 32 32 32s32-14.3 32-32l0-32 42.7 0 92.5 92.5zM296.6 251.4L237.3 192 280 192c17.7 0 32 14.3 32 32 0 11.6-6.2 21.7-15.4 27.4zM256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512z"],
    "square-dong": [448, 512, [], "e70f", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM240 136c0-13.3 10.7-24 24-24s24 10.7 24 24l0 8 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0 0 152c0 13.3-10.7 24-24 24-7.6 0-14.4-3.6-18.8-9.1-11.1 5.8-23.7 9.1-37.2 9.1-44.2 0-80-35.8-80-80s35.8-80 80-80c11.4 0 22.2 2.4 32 6.7l0-22.7-32 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l32 0 0-8zM208 240a32 32 0 1 0 0 64 32 32 0 1 0 0-64zM112 392c0-8.8 7.2-16 16-16l192 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-192 0c-8.8 0-16-7.2-16-16z"],
    "list-dropdown": [448, 512, [], "e1cf", "M64 32C28.7 32 0 60.7 0 96l0 80 448 0 0-80c0-35.3-28.7-64-64-64L64 32zM448 224L0 224 0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-192zM120 280l208 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-208 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zm0 96l208 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-208 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zM289.2 89.9c2.5-6 8.3-9.9 14.8-9.9l64 0c6.5 0 12.3 3.9 14.8 9.9s1.1 12.9-3.5 17.4l-32 32c-6.2 6.2-16.4 6.2-22.6 0l-32-32c-4.6-4.6-5.9-11.5-3.5-17.4z"],
    "camera-circle-ellipsis": [640, 512, [], "e766", "M213.1 64.8L202.7 96 128 96c-35.3 0-64 28.7-64 64l0 256c0 35.3 28.7 64 64 64l193.4 0c-11.2-24.4-17.4-51.4-17.4-80 0-5.8 .3-11.5 .8-17.2-45.8-7.3-80.8-47-80.8-94.8 0-53 43-96 96-96 33 0 62.1 16.7 79.4 42 28.4-16.6 61.4-26 96.6-26 28.6 0 55.6 6.2 80 17.4l0-65.4c0-35.3-28.7-64-64-64l-74.7 0-10.4-31.2C420.4 45.2 402.1 32 381.4 32L258.6 32c-20.7 0-39 13.2-45.5 32.8zM640 400a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-164 0a20 20 0 1 1 40 0 20 20 0 1 1 -40 0zm84-20a20 20 0 1 1 0 40 20 20 0 1 1 0-40zM412 400a20 20 0 1 1 40 0 20 20 0 1 1 -40 0z"],
    "family-dress": [512, 512, [], "e301", "M128.1 128a64 64 0 1 0 0-128 64 64 0 1 0 0 128zm0 32c-37.9 0-71.2 25.1-81.6 61.5L11.8 343.2C5.9 363.7 21.3 384 42.5 384l21.6 0 0 80c0 26.5 21.5 48 48 48l32 0c7.4 0 14.5-1.7 20.8-4.7-3.1-8.5-4.8-17.7-4.8-27.3l0-49.6c-19.8-20.2-32-47.8-32-78.4l0-16c0-41.9 20.1-79 51.2-102.4-12.1-16-19.2-36-19.2-57.6 0-3.2 .2-6.4 .5-9.5-10.1-4.2-21.1-6.5-32.5-6.5zm240 352l32 0c26.5 0 48-21.5 48-48l0-80 21.6 0c21.3 0 36.6-20.3 30.8-40.8L465.7 221.5c-10.4-36.4-43.7-61.5-81.6-61.5-11.4 0-22.4 2.3-32.5 6.5 .3 3.1 .5 6.3 .5 9.5 0 21.6-7.1 41.6-19.2 57.6 31.1 23.4 51.2 60.5 51.2 102.4l0 16c0 30.5-12.2 58.2-32 78.4l0 49.6c0 9.6-1.7 18.8-4.8 27.3 6.3 3 13.3 4.7 20.8 4.7zm16-384a64 64 0 1 0 0-128 64 64 0 1 0 0 128zm-128 96a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm0 32c-44.2 0-80 35.8-80 80l0 16c0 23.7 12.9 44.4 32 55.4l0 72.6c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-72.6c19.1-11.1 32-31.7 32-55.4l0-16c0-44.2-35.8-80-80-80z"],
    "podium": [448, 512, [], "f680", "M168 72c-22.1 0-40 17.9-40 40l0 32 280 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L40 192c-13.3 0-24-10.7-24-24s10.7-24 24-24l40 0 0-32c0-48.6 39.4-88 88-88l14.4 0C190.7 9.7 206.2 0 224 0l64 0c26.5 0 48 21.5 48 48s-21.5 48-48 48l-64 0c-17.8 0-33.3-9.7-41.6-24L168 72zM74.9 453.5L56.3 240 391.7 240 373.1 453.5c-2.9 33.1-30.6 58.5-63.8 58.5l-170.6 0c-33.2 0-60.9-25.4-63.8-58.5z"],
    "robot-astromech": [512, 512, [], "e2d2", "M256 0c70.7 0 128 57.3 128 128l0 32-256 0 0-32C128 57.3 185.3 0 256 0zm0 96a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm48 32a16 16 0 1 0 0-32 16 16 0 1 0 0 32zM48 240c0-26.5 21.5-48 48-48l320 0c26.5 0 48 21.5 48 48l0 158.3c0 8.7 2.4 17.2 6.8 24.7l38.9 64.8c3 4.9 3 11.1 .2 16.1S501.8 512 496 512l-96 0c-8.8 0-16-7.2-16-16l0-112-45.3 45.3c-12 12-28.3 18.7-45.3 18.7l-75 0c-17 0-33.3-6.7-45.3-18.7L128 384 128 496c0 8.8-7.2 16-16 16l-96 0c-5.8 0-11.1-3.1-13.9-8.1s-2.8-11.2 .2-16.1L41.2 423c4.5-7.5 6.8-16 6.8-24.7L48 240zm160 16c-8.8 0-16 7.2-16 16s7.2 16 16 16l96 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-96 0zm0 64c-8.8 0-16 7.2-16 16s7.2 16 16 16l96 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-96 0z"],
    "heart-circle-exclamation": [576, 512, [], "e4fe", "M241 87.1l15 20.7 15-20.7C296 52.5 336.2 32 378.9 32 452.4 32 512 91.6 512 165.1l0 2.6c0 17.6-3.4 35.6-9.5 53.7-21.8-8.6-45.6-13.4-70.5-13.4-106 0-192 86-192 192 0 28.5 6.2 55.6 17.4 80-.5 0-.9 0-1.4 0-15.5 0-30.8-4.6-43.1-14.1-73-55.7-212.9-186-212.9-298.2l0-2.6C0 91.6 59.6 32 133.1 32 175.8 32 216 52.5 241 87.1zM432 256a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm0 228a20 20 0 1 0 0-40 20 20 0 1 0 0 40zm0-180c-8.8 0-16 7.2-16 16l0 80c0 8.8 7.2 16 16 16s16-7.2 16-16l0-80c0-8.8-7.2-16-16-16z"],
    "building-circle-exclamation": [576, 512, [], "e4d3", "M96 0C60.7 0 32 28.7 32 64l0 384c0 35.3 28.7 64 64 64l180 0c-10.5-14.6-19-30.7-25.1-48l-74.9 0 0-80c0-17.7 14.3-32 32-32l32 0c2 0 4 .2 5.9 .5 6-23.6 16.3-45.4 30.1-64.5l-4 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 4c27.5-19.8 60.3-32.4 96-35.4L416 64c0-35.3-28.7-64-64-64L96 0zm32 112c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM272 96l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM128 240c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM432 544a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm0-100a20 20 0 1 1 0 40 20 20 0 1 1 0-40zm0-140c8.8 0 16 7.2 16 16l0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80c0-8.8 7.2-16 16-16z"],
    "person-arrow-up-from-line": [576, 512, [], "e539", "M192-32a56 56 0 1 1 0 112 56 56 0 1 1 0-112zM318.3 299.1l-46.3-62.4 0 243.3 272 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 544c-17.7 0-32-14.3-32-32s14.3-32 32-32l80 0 0-243.3-46.3 62.4c-10.5 14.2-30.6 17.2-44.8 6.6s-17.2-30.6-6.6-44.8l70.5-95C110 132 149.7 112 192 112s82 20 107.2 53.9l70.5 95c10.5 14.2 7.6 34.2-6.6 44.8s-34.2 7.6-44.8-6.6zM208 480l0-128c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 128 32 0zM566.6 102.6c-12.5 12.5-32.8 12.5-45.3 0L496 77.3 496 224c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-146.7-25.4 25.4c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l80-80c12.5-12.5 32.8-12.5 45.3 0l80 80c12.5 12.5 12.5 32.8 0 45.3z"],
    "circle-arrow-down-left": [512, 512, [], "e0f9", "M256 512a256 256 0 1 1 0-512 256 256 0 1 1 0 512zM208 216c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 112c0 13.3 10.7 24 24 24l112 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-54.1 0 103-103c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-103 103 0-54.1z"],
    "not-equal": [448, 512, [], "f53e", "M378.6 81.8c9.8-14.7 5.8-34.6-8.9-44.4s-34.6-5.8-44.4 8.9L270.9 128 32 128c-17.7 0-32 14.3-32 32s14.3 32 32 32l196.2 0-85.3 128-110.9 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l68.2 0-30.8 46.2c-9.8 14.7-5.8 34.6 8.9 44.4s34.6 5.8 44.4-8.9L177.1 384 416 384c17.7 0 32-14.3 32-32s-14.3-32-32-32l-196.2 0 85.3-128 110.9 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-68.2 0 30.8-46.2z"],
    "binary-circle-check": [576, 512, [], "e33c", "M400 32l0 128 16 0c17.7 0 32 14.3 32 32 0 6-1.6 11.6-4.5 16.3-3.8-.2-7.7-.3-11.5-.3-27.3 0-53.3 5.7-76.9 16L320 224c-17.7 0-32-14.3-32-32s14.3-32 32-32l16 0 0-83.6-5.9 2c-16.8 5.6-34.9-3.5-40.5-20.2s3.5-34.9 20.2-40.5l48-16C367.6-1.6 378.4 0 386.7 6S400 21.7 400 32zM176 320l0 128 16 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-96 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l16 0 0-83.6-5.9 2c-16.8 5.6-34.9-3.5-40.5-20.2s3.5-34.9 20.2-40.5l48-16c9.8-3.3 20.5-1.6 28.8 4.4S176 309.7 176 320zM64 64C64 28.7 92.7 0 128 0l64 0c35.3 0 64 28.7 64 64l0 96c0 35.3-28.7 64-64 64l-64 0c-35.3 0-64-28.7-64-64l0-96zm128 0l-64 0 0 96 64 0 0-96zm96 336a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm201.4-60.9c-7.1-5.2-17.2-3.6-22.4 3.5l-53 72.9-26.8-26.8c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l40 40c3.3 3.3 7.9 5 12.6 4.6s8.9-2.8 11.7-6.5l64-88c5.2-7.1 3.6-17.2-3.5-22.3z"],
    "train-tram": [384, 512, [128650], "e5b4", "M0 8C0-5.3 10.7-16 24-16l336 0c13.3 0 24 10.7 24 24l0 32c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-8-120 0 0 64 40 0c53 0 96 43 96 96l0 160c0 31.2-14.9 59-38 76.5l64.3 76c8.6 10.1 7.3 25.3-2.8 33.8s-25.3 7.3-33.8-2.8l-74.6-88.1c-3.6 .4-7.3 .6-11.1 .6l-128 0c-3.8 0-7.5-.2-11.1-.6L42.3 535.5c-8.6 10.1-23.7 11.4-33.8 2.8s-11.4-23.7-2.8-33.8l64.3-76C46.9 411 32 383.2 32 352l0-160c0-53 43-96 96-96l40 0 0-64-120 0 0 8c0 13.3-10.7 24-24 24S0 53.3 0 40L0 8zM128 160c-17.7 0-32 14.3-32 32l0 32c0 17.7 14.3 32 32 32l128 0c17.7 0 32-14.3 32-32l0-32c0-17.7-14.3-32-32-32l-128 0zm32 192a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm96 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "plane-departure": [576, 512, [128747], "f5b0", "M372 143.9L172.7 40.2c-8-4.1-17.3-4.8-25.7-1.7l-41.1 15c-10.3 3.7-13.8 16.4-7.1 25L200.3 206.4 100.1 242.8 40 206.2c-6.2-3.8-13.8-4.5-20.7-2.1L3 210.1c-9.4 3.4-13.4 14.5-8.3 23.1l53.6 91.8c15.6 26.7 48.1 38.4 77.1 27.8l12.9-4.7 0 0 398.4-145c29.1-10.6 44-42.7 33.5-71.8s-42.7-44-71.8-33.5L372 143.9zM32.2 448c-17.7 0-32 14.3-32 32s14.3 32 32 32l512 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-512 0z"],
    "microphone-stand": [512, 512, [127908], "f8cb", "M290.2 52.3l-4.6 4.6 169.7 169.7 4.6-4.6c46.9-46.9 46.9-122.8 0-169.7S337 5.5 290.2 52.3zM257.3 85.3l-6.7 6.7c-21.6 21.6-32.5 49.8-32.8 78.1L342.2 294.4c28.3-.3 56.5-11.2 78.1-32.8L427 255 257.3 85.3zM192 212.2L38.3 380.4c-17.3 18.9-16.6 48.1 1.5 66.3l25.6 25.7c18.1 18.2 47.4 18.9 66.4 1.6l100.5-91.8 0 137.8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-181.7 19.8-18.1-108.1-108.1z"],
    "shop-24": [640, 512, [], "e79a", "M21.5 181.1L78.3 67.4C89.2 45.7 111.3 32 135.6 32l304.9 0c24.2 0 46.4 13.7 57.2 35.4l56.8 113.7c3.6 7.2 5.5 15.1 5.5 23.2 0 27.3-21.2 49.7-48 51.6l0 48.1-64 0 0-48-96 0 0 48-64 0 0-48-160 0 0 112c0 8.8 7.2 16 16 16l160 0 0 96-192 0c-26.5 0-48-21.5-48-48l0-176.1c-26.8-1.9-48-24.3-48-51.6 0-8 1.9-16 5.5-23.2zM348 400c0-28.7 23.3-52 52-52s52 23.3 52 52l0 1c0 14.6-5.4 28.7-15 39.6L405.4 476 432 476c11 0 20 9 20 20s-9 20-20 20l-58.2 0c-14.2 0-25.8-11.5-25.8-25.8 0-6.3 2.3-12.4 6.5-17.1L407.1 414c3.2-3.6 4.9-8.2 4.9-13l0-1c0-6.6-5.4-12-12-12s-12 5.4-12 12c0 11-9 20-20 20s-20-9-20-20zm128 32l0-64c0-11 9-20 20-20s20 9 20 20l0 44 24 0 0-44c0-11 9-20 20-20s20 9 20 20l0 128c0 11-9 20-20 20s-20-9-20-20l0-44-44 0c-5.3 0-10.4-2.1-14.1-5.9S476 437.3 476 432z"],
    "brightness": [512, 512, [], "e0c9", "M224 80l0-48c0-17.7 14.3-32 32-32s32 14.3 32 32l0 48c0 17.7-14.3 32-32 32s-32-14.3-32-32zM160 256a96 96 0 1 1 192 0 96 96 0 1 1 -192 0zM0 256c0-17.7 14.3-32 32-32l48 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-48 0c-17.7 0-32-14.3-32-32zm432-32l48 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-48 0c-17.7 0-32-14.3-32-32s14.3-32 32-32zM256 512c-17.7 0-32-14.3-32-32l0-48c0-17.7 14.3-32 32-32s32 14.3 32 32l0 48c0 17.7-14.3 32-32 32zM73.4 438.6c-12.5-12.5-12.5-32.8 0-45.3l32-32c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3l-32 32c-12.5 12.5-32.8 12.5-45.3 0zm288-333.3l32-32c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3l-32 32c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3zm77.3 333.3c-12.5 12.5-32.8 12.5-45.3 0l-32-32c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0l32 32c12.5 12.5 12.5 32.8 0 45.3zm-333.3-288l-32-32c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0l32 32c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0z"],
    "right-to-bracket": [512, 512, ["sign-in-alt"], "f2f6", "M345 273c9.4-9.4 9.4-24.6 0-33.9L201 95c-6.9-6.9-17.2-8.9-26.2-5.2S160 102.3 160 112l0 80-112 0c-26.5 0-48 21.5-48 48l0 32c0 26.5 21.5 48 48 48l112 0 0 80c0 9.7 5.8 18.5 14.8 22.2s19.3 1.7 26.2-5.2L345 273zm7 143c-17.7 0-32 14.3-32 32s14.3 32 32 32l64 0c53 0 96-43 96-96l0-256c0-53-43-96-96-96l-64 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l64 0c17.7 0 32 14.3 32 32l0 256c0 17.7-14.3 32-32 32l-64 0z"],
    "sd-card": [384, 512, [], "f7c2", "M384 64c0-35.3-28.7-64-64-64L125.3 0C108.3 0 92 6.7 80 18.7L18.7 80C6.7 92 0 108.3 0 125.3L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-384zM160 88l0 48c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-48c0-13.3 10.7-24 24-24s24 10.7 24 24zm88 0l0 48c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-48c0-13.3 10.7-24 24-24s24 10.7 24 24zm88 0l0 48c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-48c0-13.3 10.7-24 24-24s24 10.7 24 24z"],
    "dot": [128, 512, [], "e7d1", "M64 192c35.3 0 64 28.7 64 64s-28.7 64-64 64-64-28.7-64-64 28.7-64 64-64z"],
    "house-circle-exclamation": [640, 512, [], "e50a", "M496 544a144 144 0 1 1 0-288 144 144 0 1 1 0 288zM268.6 6.5c12.2-9.3 29.7-8.7 41.2 2l217.6 202c-10.2-1.7-20.7-2.6-31.3-2.6-78.6 0-146.1 47.2-175.8 114.8-5.1-1.8-10.5-2.8-16.2-2.8l-32 0c-26.5 0-48 21.5-48 48l0 96 91 0c6.1 17.3 14.6 33.4 25.1 48L144 512c-35.3 0-64-28.7-64-64l0-176-16 0c-13.2 0-25-8.1-29.8-20.3s-1.6-26.2 8-35.1l224-208 2.4-2zM496 444a20 20 0 1 0 0 40 20 20 0 1 0 0-40zm0-140c-8.8 0-16 7.2-16 16l0 80c0 8.8 7.2 16 16 16 8.8 0 16-7.2 16-16l0-80c0-8.8-7.2-16-16-16z"],
    "shekel-sign": [448, 512, [8362, "ils", "shekel", "sheqel", "sheqel-sign"], "f20b", "M32 32C14.3 32 0 46.3 0 64L0 448c0 17.7 14.3 32 32 32s32-14.3 32-32l0-352 128 0c35.3 0 64 28.7 64 64l0 160c0 17.7 14.3 32 32 32s32-14.3 32-32l0-160c0-70.7-57.3-128-128-128L32 32zM320 480c70.7 0 128-57.3 128-128l0-288c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 288c0 35.3-28.7 64-64 64l-128 0 0-224c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 256c0 17.7 14.3 32 32 32l160 0z"],
    "square-u": [448, 512, [], "e281", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM176 168l0 104c0 26.5 21.5 48 48 48s48-21.5 48-48l0-104c0-13.3 10.7-24 24-24s24 10.7 24 24l0 104c0 53-43 96-96 96s-96-43-96-96l0-104c0-13.3 10.7-24 24-24s24 10.7 24 24z"],
    "truck-container-empty": [640, 512, [], "e2b5", "M448 128c-17.7 0-32 14.3-32 32l0 176-368 0c-26.5 0-48 21.5-48 48l0 40c0 48.6 39.4 88 88 88 25.2 0 48-10.6 64-27.6 16 17 38.8 27.6 64 27.6 40.3 0 74.2-27.1 84.7-64l118.6 0c10.4 36.9 44.4 64 84.7 64 40.8 0 75.1-27.7 85.1-65.3 29.1-6 50.9-31.8 50.9-62.7l0-146.7c0-17-6.7-33.3-18.7-45.3L576 146.7c-12-12-28.3-18.7-45.3-18.7L448 128zM576 288l-96 0 0-96 50.7 0 45.3 45.3 0 50.7zM88 384a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm376 40a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zM216 384a40 40 0 1 1 0 80 40 40 0 1 1 0-80z"],
    "user-pilot-tie": [448, 512, [], "e2c1", "M65.7 11.2L215.6-29.7c5.5-1.5 11.3-1.5 16.8 0L382.3 11.2c10.5 2.9 17.7 12.4 17.7 23.2 0 8.5-4.4 16.3-11.7 20.6L368 67.2 368 91.8c0 11.4-6 21.8-16 26.7l0 25.5c0 70.7-57.3 128-128 128S96 214.7 96 144l0-25.5c-10-5-16-15.4-16-26.7L80 67.2 59.7 55C52.4 50.7 48 42.8 48 34.4 48 23.5 55.3 14 65.7 11.2zM224 144c-29.1 0-56.8-4.6-80-10.3l0 10.3c0 44.2 35.8 80 80 80s80-35.8 80-80l0-10.3c-23.2 5.7-50.9 10.3-80 10.3zM193.5 304l61 0c9.7 0 17.5 7.8 17.5 17.5 0 4.2-1.5 8.2-4.2 11.4l-27.4 32 31 115.1 .6 0 34.6-138.5c2.2-8.7 11.1-14 19.5-10.8 61.9 23.6 105.9 83.6 105.9 153.8 0 15.1-12.3 27.4-27.4 27.4L43.4 512c-15.1 0-27.4-12.3-27.4-27.4 0-70.2 44-130.2 105.9-153.8 8.4-3.2 17.3 2.1 19.5 10.8l34.6 138.5 .6 0 31-115.1-27.4-32c-2.7-3.2-4.2-7.2-4.2-11.4 0-9.7 7.8-17.5 17.5-17.5zM161.7 40.8c-4 7.9-.7 17.5 7.2 21.5l48 24c4.5 2.3 9.8 2.3 14.3 0l48-24c7.9-4 11.1-13.6 7.2-21.5s-13.6-11.1-21.5-7.2L224 54.1 183.2 33.7c-7.9-4-17.5-.7-21.5 7.2zM336 416c-8.8 0-16 7.2-16 16s7.2 16 16 16l32 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-32 0z"],
    "radio": [512, 512, [128251], "f8d7", "M494.8 15c12.7-3.7 20-17.1 16.3-29.8S494-34.8 481.3-31L51.8 94.9C42.4 97.6 33.9 102.1 26.6 108 10.5 119.7 0 138.6 0 160L0 416c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L218.5 96 494.8 15zM368 208a80 80 0 1 1 0 160 80 80 0 1 1 0-160zM64 248c0-13.3 10.7-24 24-24l112 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L88 272c-13.3 0-24-10.7-24-24zm0 96c0-13.3 10.7-24 24-24l112 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L88 368c-13.3 0-24-10.7-24-24z"],
    "hand-dots": [512, 512, ["allergies"], "f461", "M288 32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 208c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-176c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 272c0 1.5 0 3.1 .1 4.6L67.6 283c-16-15.2-41.3-14.6-56.6 1.4S-3.6 325.7 12.4 341L124.8 448c43.1 41.1 100.4 64 160 64l19.2 0c97.2 0 176-78.8 176-176l0-208c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 112c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-176c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 176c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-208zM200 352a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm120-56a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm40 88a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm-88 24a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"],
    "pencil-line": [576, 512, [], "e74f", "M58.9 314.6c-10.7 10.7-18.5 24.1-22.6 38.7L.9 481c-2.3 8.3 0 17.3 6.2 23.4s15.1 8.5 23.4 6.2l127.8-35.5c14.6-4.1 27.9-11.8 38.7-22.6L378.1 271.3 412 237.4c-16.6-16.6-51.3-51.3-104-104l-33.9-33.9-33.9 33.9-181.2 181.2zm23.7 51.5c.3-1.1 .7-2.2 1.1-3.3l17.3-6.9c5.3-2.1 11 1.8 11 7.4l0 20.2c0 8.8 7.2 16 16 16l20.2 0c5.7 0 9.5 5.7 7.4 11l-6.9 17.3c-1.1 .4-2.2 .8-3.3 1.1l-86.9 24.1 24.1-86.9zM479.9 169.5l10.9-10.9C504.4 145 512 126.6 512 107.4s-7.6-37.6-21.2-51.1L455.1 20.6C441.6 7 423.2-.6 404-.6S366.4 7 352.9 20.6c-3.5 3.5-18.4 18.4-44.9 44.9 16.6 16.6 51.3 51.3 104 104l33.9 33.9 33.9-33.9zM280 464c-13.3 0-24 10.7-24 24s10.7 24 24 24l272 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-272 0z"],
    "hand-shaka": [576, 512, [], "e831", "M54 1.4c21.3-5.8 43.3 6.8 49.1 28.1l19.5 71.5c3.9 14.4 5.9 29.3 5.9 44.2l0 12.7c-22.1 25.1-21.3 63.4 2.8 87.4l4.9 4.4c9.4 7.6 20.5 12.1 31.8 13.7-7.6 22.4-2.5 48.1 15.3 65.9l4.9 4.4c17.4 14.2 40.6 17.8 61 10.8 1.8 13.4 7.8 26.4 18.1 36.7l4.9 4.4c25.1 20.5 62.2 19 85.6-4.4l2.6-2.6 .1 .1 145.4-145.4c12.5-12.5 32.8-12.5 45.3 0 12.5 12.5 12.5 32.8 0 45.3L372.4 457.4c-35 35-82.4 54.6-131.9 54.6s-96.9-19.7-131.9-54.6l-2.8-2.7c-36.7-36.7-57.4-86.6-57.4-138.5l0-171c0-7.8-1-15.6-3.1-23.2L25.9 50.5C20.1 29.2 32.7 7.2 54 1.4zm299.9 248c12.5-12.5 32.8-12.5 45.3 0 12.5 12.5 12.5 32.8 0 45.3l-64 64c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l64-64zm-61.6-74.2c12.6-10.3 31.1-9.5 42.8 2.2 12.5 12.5 12.5 32.8 0 45.2l-84 84c-12.5 12.5-32.8 12.5-45.2 0s-12.5-32.8 0-45.3l84-84 2.4-2.2zm-72-64c12.6-10.3 31.1-9.5 42.8 2.2s12.4 30.2 2.2 42.8l-2.2 2.4-64 64c-12.5 12.5-32.8 12.5-45.2 0s-12.5-32.8 0-45.2l64-64 2.4-2.2z"],
    "flask-gear": [576, 512, [], "e5f1", "M288 0L128 0C110.3 0 96 14.3 96 32s14.3 32 32 32L128 215.5 7.5 426.3C2.6 435 0 444.7 0 454.7 0 486.4 25.6 512 57.3 512l193.4 0c-1-1.5-2-3.1-2.9-4.7l-22.5-40.4c-15.4-27.6-10.8-61 9.4-83.4-15.5-17.2-21.9-40.9-17-63.5l-75.7 0 41.6-72.7c5.5-9.7 8.4-20.6 8.4-31.8l0-151.5 64 0 0 151.5c0 9.2 2 18.2 5.8 26.6 16.7-15.5 39.9-22.1 62.3-17.9l.4-1-4.4-7.7 0-151.5c17.7 0 32-14.3 32-32S337.7 0 320 0L288 0zm80.2 247.6l0 5.9c0 19-24.2 33-40.7 23.5l-4.8-2.8c-11.6-6.7-26.4-2.6-32.9 9.1l-22.5 40.3c-6.3 11.2-2.6 25.3 8.3 32.1l4.5 2.8c16.3 10.1 16.2 40.1 0 50.2l-4.4 2.7c-10.9 6.8-14.6 20.9-8.3 32.1l22.5 40.4c6.5 11.7 21.4 15.8 33 9.1l4.8-2.8c16.5-9.5 40.7 4.5 40.7 23.5l0 5.9c0 13.3 10.7 24 24 24l48 0c13.3 0 24-10.7 24-24l0-6.1c0-18.9 24.1-32.8 40.5-23.4l4.9 2.9c11.6 6.7 26.5 2.6 33-9.1l22.4-40.4c6.2-11.2 2.5-25.3-8.3-32l-4.6-2.9c-16.2-10.1-16.2-39.9 0-50.1l4.7-2.9c10.8-6.8 14.4-20.8 8.2-32l-22.4-40.2c-6.5-11.7-21.4-15.8-33-9.1l-5 2.9c-16.4 9.5-40.5-4.5-40.5-23.4l0-6.1c0-13.3-10.7-24-24-24l-48 0c-13.3 0-24 10.7-24 24zm-4.1 136.2a52 52 0 1 1 104 0 52 52 0 1 1 -104 0z"],
    "book-skull": [448, 512, ["book-dead"], "f6b7", "M96 512l320 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l0-66.7c18.6-6.6 32-24.4 32-45.3l0-288c0-26.5-21.5-48-48-48L96 0C43 0 0 43 0 96L0 416c0 53 43 96 96 96zM64 416c0-17.7 14.3-32 32-32l256 0 0 64-256 0c-17.7 0-32-14.3-32-32zM272 163.2l0 12.8c0 8.8-7.2 16-16 16l-64 0c-8.8 0-16-7.2-16-16l0-12.8c-19.4-11.7-32-30.3-32-51.2 0-35.3 35.8-64 80-64s80 28.7 80 64c0 20.9-12.6 39.5-32 51.2zM208 112a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm48 16a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm74.2 95.7c4.6 10.1 .1 21.9-9.9 26.5l-47.9 21.8 47.9 21.8c10.1 4.6 14.5 16.4 9.9 26.5s-16.4 14.5-26.5 9.9L224 294 144.3 330.2c-10.1 4.6-21.9 .1-26.5-9.9s-.1-21.9 9.9-26.5l47.9-21.8-47.9-21.8c-10.1-4.6-14.5-16.4-9.9-26.5s16.4-14.5 26.5-9.9L224 250 303.7 213.8c10.1-4.6 21.9-.1 26.5 9.9z"],
    "unlock-keyhole": [384, 512, ["unlock-alt"], "f13e", "M192 32c-35.3 0-64 28.7-64 64l0 64 192 0c35.3 0 64 28.7 64 64l0 224c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 224c0-35.3 28.7-64 64-64l0-64c0-70.7 57.3-128 128-128 63.5 0 116.1 46.1 126.2 106.7 2.9 17.4-8.8 33.9-26.3 36.9s-33.9-8.8-36.9-26.3C250 55.1 223.7 32 192 32zm40 328c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l80 0z"],
    "truck-ramp": [576, 512, [], "f4e0", "M320 112c0-44.2 35.8-80 80-80l176 0 0 392c0 48.6-39.4 88-88 88s-88-39.4-88-88c0-2.7 .1-5.4 .4-8l-43.7 0-315.5 94.6c-16.9 5.1-34.8-4.5-39.8-21.5s4.5-34.8 21.5-39.8L320 360.2 320 112zM528 423.9c-.1-22-17.9-39.9-40-39.9-22.1 0-40 17.9-40 40s17.9 40 40 40 40-17.9 40-40l0-.1z"],
    "envelope-dot": [576, 512, ["envelope-badge"], "e16f", "M496 0a80 80 0 1 1 0 160 80 80 0 1 1 0-160zM80 64l289 0c-.7 5.2-1 10.6-1 16 0 56.9 37.1 105 88.3 121.7L316.8 306.4c-17.1 12.8-40.5 12.8-57.6 0l-208-156C39.1 141.3 32 127.1 32 112 32 85.5 53.5 64 80 64zM345.6 344.8L536.9 201.3c2.4-.8 4.8-1.7 7.1-2.6L544 384c0 35.3-28.7 64-64 64L96 448c-35.3 0-64-28.7-64-64l0-188 198.4 148.8c34.1 25.6 81.1 25.6 115.2 0z"],
    "house-heart": [512, 512, ["home-heart"], "f4c9", "M277.8 8.6c-12.3-11.4-31.3-11.4-43.5 0l-224 208c-9.6 9-12.8 22.9-8 35.1S18.8 272 32 272l16 0 0 176c0 35.3 28.7 64 64 64l288 0c35.3 0 64-28.7 64-64l0-176 16 0c13.2 0 25-8.1 29.8-20.3s1.6-26.2-8-35.1l-224-208zM249.6 247.5l6.4 8.5 6.4-8.5c11.1-14.8 28.5-23.5 46.9-23.5 32.4 0 58.7 26.3 58.7 58.7l0 5.3c0 49.1-65.8 98.1-96.5 118.3-9.5 6.2-21.5 6.2-30.9 0-30.7-20.2-96.5-69.3-96.5-118.3l0-5.3c0-32.4 26.3-58.7 58.7-58.7 18.5 0 35.9 8.7 46.9 23.5z"],
    "file-arrow-up": [384, 512, ["file-upload"], "f574", "M0 64C0 28.7 28.7 0 64 0L213.5 0c17 0 33.3 6.7 45.3 18.7L365.3 125.3c12 12 18.7 28.3 18.7 45.3L384 448c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zm208-5.5l0 93.5c0 13.3 10.7 24 24 24L325.5 176 208 58.5zM209 263c-9.4-9.4-24.6-9.4-33.9 0l-64 64c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l23-23 0 86.1c0 13.3 10.7 24 24 24s24-10.7 24-24l0-86.1 23 23c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-64-64z"],
    "game-console-handheld": [384, 512, [], "f8bb", "M0 64C0 28.7 28.7 0 64 0L320 0c35.3 0 64 28.7 64 64l0 352c0 53-43 96-96 96L96 512c-53 0-96-43-96-96L0 64zM96 80l0 112c0 17.7 14.3 32 32 32l128 0c17.7 0 32-14.3 32-32l0-112c0-8.8-7.2-16-16-16L112 64c-8.8 0-16 7.2-16 16zM232 384a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm88-72a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM96 304l0 16-16 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l16 0 0 16c0 8.8 7.2 16 16 16s16-7.2 16-16l0-16 16 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0 0-16c0-8.8-7.2-16-16-16s-16 7.2-16 16z"],
    "face-grin-tears": [640, 512, [128514, "grin-tears"], "f588", "M554.8 203.4l16.3 2.3C547.7 88.4 444.2 0 320 0S92.3 88.4 68.9 205.7l16.3-2.3c37-5.3 68.6 26.4 63.4 63.4l-6.7 46.7c-4.1 29-21.6 53.2-45.8 66.8 43.7 78.5 127.6 131.7 223.8 131.7s180.1-53.1 223.8-131.7c-24.1-13.5-41.6-37.8-45.8-66.8l-6.7-46.7c-5.3-37 26.4-68.6 63.4-63.4zM470.3 326.9C447.9 388.2 389.1 432 320 432S192.1 388.2 169.7 326.9c-4.3-11.8 7.7-21.8 19.6-18.1 39.2 12.2 83.7 19.1 130.7 19.1s91.5-6.9 130.7-19.1c11.9-3.7 23.9 6.3 19.6 18.1zM212 208l0 8c0 11-9 20-20 20s-20-9-20-20l0-8c0-37.6 30.4-68 68-68s68 30.4 68 68l0 8c0 11-9 20-20 20s-20-9-20-20l0-8c0-15.5-12.5-28-28-28s-28 12.5-28 28zm188-28c-15.5 0-28 12.5-28 28l0 8c0 11-9 20-20 20s-20-9-20-20l0-8c0-37.6 30.4-68 68-68s68 30.4 68 68l0 8c0 11-9 20-20 20s-20-9-20-20l0-8c0-15.5-12.5-28-28-28zM640 300.6c0-25.6-18.8-47.3-44.1-50.9L549.1 243c-10.6-1.5-19.6 7.5-18.1 18.1l6.7 46.7c3.6 25.3 25.3 44.1 50.9 44.1 28.4 0 51.4-23 51.4-51.4zm-640 0C0 329 23 352 51.4 352 77 352 98.7 333.2 102.3 307.9l6.7-46.7c1.5-10.6-7.5-19.6-18.1-18.1l-46.7 6.7C18.8 253.3 0 275 0 300.6z"],
    "pen-to-square": [512, 512, ["edit"], "f044", "M471.6 21.7c-21.9-21.9-57.3-21.9-79.2 0L368 46.1 465.9 144 490.3 119.6c21.9-21.9 21.9-57.3 0-79.2L471.6 21.7zm-299.2 220c-6.1 6.1-10.8 13.6-13.5 21.9l-29.6 88.8c-2.9 8.6-.6 18.1 5.8 24.6s15.9 8.7 24.6 5.8l88.8-29.6c8.2-2.7 15.7-7.4 21.9-13.5L432 177.9 334.1 80 172.4 241.7zM96 64C43 64 0 107 0 160L0 416c0 53 43 96 96 96l256 0c53 0 96-43 96-96l0-96c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 96c0 17.7-14.3 32-32 32L96 448c-17.7 0-32-14.3-32-32l0-256c0-17.7 14.3-32 32-32l96 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L96 64z"],
    "earth-europe": [512, 512, ["globe-europe"], "f7a2", "M256.2 48c114.8 .1 207.8 93.2 207.8 208 0 22.1-3.4 43.4-9.8 63.4-2 .4-4.1 .6-6.2 .6l-2.7 0c-8.5 0-16.6-3.4-22.6-9.4l-29.3-29.3c-6-6-9.4-14.1-9.4-22.6l0-50.7c0-8.8 7.2-16 16-16s16-7.2 16-16-7.2-16-16-16l-24 0c-13.3 0-24 10.7-24 24s-10.7 24-24 24l-56 0c-8.8 0-16 7.2-16 16s-7.2 16-16 16l-25.4 0c-12.5 0-22.6-10.1-22.6-22.6 0-6 2.4-11.8 6.6-16l70.1-70.1c2.1-2.1 3.3-5 3.3-8 0-6.2-5.1-11.3-11.3-11.3l-14.1 0c-12.5 0-22.6-10.1-22.6-22.6 0-6 2.4-11.8 6.6-16l23.1-23.1c.8-.8 1.6-1.5 2.5-2.2zM438.4 356.1c-32.8 59.6-93.9 101.4-165.2 107.2-.7-2.3-1.1-4.8-1.1-7.3 0-13.3-10.7-24-24-24l-26.7 0c-8.5 0-16.6-3.4-22.6-9.4l-29.3-29.3c-6-6-9.4-14.1-9.4-22.6l0-66.7c0-17.7 14.3-32 32-32l98.7 0c8.5 0 16.6 3.4 22.6 9.4l29.3 29.3c6 6 14.1 9.4 22.6 9.4l5.5 0c8.5 0 16.6 3.4 22.6 9.4l16 16c4.2 4.2 10 6.6 16 6.6 4.8 0 9.3 1.5 13 4.1zM256 512l26.2-1.3c-8.6 .9-17.3 1.3-26.2 1.3zm26.2-1.3C411.3 497.6 512 388.6 512 256 512 114.6 397.4 0 256 0l0 0C114.6 0 0 114.6 0 256 0 383.5 93.2 489.3 215.3 508.8 228.5 510.9 242.1 512 256 512zM187.3 123.3l-32 32c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l32-32c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6z"],
    "table-picnic": [512, 512, [], "e32d", "M93.7 427.9c-6.6 16.4-25.2 24.4-41.6 17.8s-24.4-25.2-17.8-41.6l27.2-68.1 68.9 0-36.8 91.9zm384-23.8c6.6 16.4-1.4 35-17.8 41.6s-35-1.4-41.6-17.8l-36.7-91.9 68.9 0 27.3 68.1zM416 64c17.7 0 32 14.3 32 32s-14.3 32-32 32l-48.7 0 38.4 96 74.3 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 288c-17.7 0-32-14.3-32-32s14.3-32 32-32l74.3 0 38.4-96-48.8 0c-17.7 0-32-14.3-32-32S78.3 64 96 64l320 0zM175.2 224l161.5 0-38.4-96-84.7 0-38.4 96z"],
    "face-grin-beam-sweat": [576, 512, [128517, "grin-beam-sweat"], "f583", "M546.2-.1c14.7 17.8 29.8 40.1 29.8 64.1 0 36.4-27.6 64-64 64s-64-27.6-64-64c0-24 15.2-46.3 29.8-64.1 8.8-10.7 18.5-20.8 29-30 3-2.6 7.4-2.6 10.4 0 10.5 9.1 20.1 19.3 29 30zM288 0c42.5 0 82.6 10.4 117.8 28.7-3.6 10.9-5.8 22.7-5.8 35.3 0 62.9 49.1 112 112 112 6.4 0 12.7-.5 18.8-1.5 8.6 25.6 13.2 53 13.2 81.5 0 141.4-114.6 256-256 256S32 397.4 32 256 146.6 0 288 0zM418.7 308.9C379.5 321.1 335.1 328 288 328s-91.5-6.9-130.7-19.1c-11.9-3.7-23.9 6.3-19.6 18.1 22.4 61.3 81.3 105.1 150.3 105.1s127.9-43.8 150.3-105.1c4.3-11.8-7.7-21.8-19.6-18.1zM208 180c15.5 0 28 12.5 28 28l0 8c0 11 9 20 20 20s20-9 20-20l0-8c0-37.6-30.4-68-68-68s-68 30.4-68 68l0 8c0 11 9 20 20 20s20-9 20-20l0-8c0-15.5 12.5-28 28-28zm132 28c0-15.5 12.5-28 28-28s28 12.5 28 28l0 8c0 11 9 20 20 20s20-9 20-20l0-8c0-37.6-30.4-68-68-68s-68 30.4-68 68l0 8c0 11 9 20 20 20s20-9 20-20l0-8z"],
    "circle-half-stroke": [512, 512, [9680, "adjust"], "f042", "M448 256c0-106-86-192-192-192l0 384c106 0 192-86 192-192zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0z"],
    "ruler-triangle": [512, 512, [128208], "f61c", "M86.6 9.4C77.5 .2 63.7-2.5 51.8 2.4S32 19.1 32 32l0 416c0 17.7 14.3 32 32 32l416 0c12.9 0 24.6-7.8 29.6-19.8s2.2-25.7-6.9-34.9l-31-31-14.6 14.6c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l14.6-14.6-46.1-46.1-38.6 38.6c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l38.6-38.6-46.1-46.1-14.6 14.6c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l14.6-14.6-46.1-46.1-38.6 38.6c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9L197.7 120.4 151.6 74.3 137 89c-9.4 9.4-24.6 9.4-33.9 0S93.7 64.4 103 55l14.6-14.6-31-31zM160 263.8l88.2 88.2-88.2 0 0-88.2z"],
    "octagon-plus": [512, 512, ["plus-octagon"], "f301", "M143.4 18.8c12-12 28.3-18.7 45.3-18.7l135.6 0c17 0 33.3 6.7 45.3 18.7L493.6 143c12 12 18.7 28.3 18.7 45.3l0 135.6c0 17-6.7 33.3-18.7 45.3L369.5 493.2c-12 12-28.3 18.7-45.3 18.7l-135.6 0c-17 0-33.3-6.7-45.3-18.7L19.2 369C7.2 357 .5 340.8 .5 323.8l0-135.6c0-17 6.7-33.3 18.7-45.3L143.4 18.8zm89 325.2c0 13.3 10.7 24 24 24s24-10.7 24-24l0-64 64 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-64 0 0-64c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 64-64 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l64 0 0 64z"],
    "user-cowboy": [448, 512, [], "f8ea", "M420.7 36.7c-10.6 10.6-38.6 29.6-83 43.2-9.8-53.7-29.9-111.9-64-111.9-8.9 0-17.7 3.8-25.5 8-7.7 4.2-17.4 8-24.1 8s-16.4-3.8-24.1-8c-7.9-4.3-16.6-8-25.5-8-34.1 0-54.2 58.2-64 111.9-44.4-13.6-72.4-32.5-83-43.2-5.5-5.5-14.3-6.3-20.7-1.7s-8.5 13.1-5 20.1c11.6 23.1 42 57 94.3 80l0 8.9c0 70.7 57.3 128 128 128s128-57.3 128-128l0-8.9c52.3-22.9 82.8-56.8 94.3-80 3.5-7 1.4-15.5-5-20.1s-15.1-3.9-20.7 1.7zm-117 114.5C300.1 192 265.8 224 224 224s-76.1-32-79.7-72.9c23.5 5.6 50 8.9 79.7 8.9s56.2-3.3 79.7-8.9zM180.6 320C89.7 320 16 393.7 16 484.6 16 499.7 28.3 512 43.4 512l361.1 0c15.1 0 27.4-12.3 27.4-27.4 0-90.9-73.7-164.6-164.6-164.6l-86.9 0z"],
    "bookmark-plus": [384, 512, [], "e755", "M0 64C0 28.7 28.7 0 64 0L320 0c35.3 0 64 28.7 64 64l0 416c0 11.5-6.2 22.2-16.2 27.8s-22.3 5.5-32.2-.4L192 421.3 48.5 507.4c-9.9 5.9-22.2 6.1-32.2 .4S0 491.5 0 480L0 64zm192 64c-13.3 0-24 10.7-24 24l0 48-48 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l48 0 0 48c0 13.3 10.7 24 24 24s24-10.7 24-24l0-48 48 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0 0-48c0-13.3-10.7-24-24-24z"],
    "person-military-to-person": [512, 512, [], "e54c", "M71 12.5c-8.6 1-15 8.2-15 16.8 0 9.3 7.5 16.8 16.7 16.9l111.4 0c8.8-.1 15.9-7.2 15.9-16L200 16c0-9.5-8.3-17-17.8-15.9L71 12.5zM189.5 78.1l-122.9 0c-1.6 5.7-2.5 11.7-2.5 17.9 0 35.3 28.7 64 64 64s64-28.7 64-64c0-6.2-.9-12.2-2.5-17.9zM32 256l0 32c0 17.7 14.3 32 32 32l128 0c1.8 0 3.5-.1 5.2-.4L53 208.6C40.1 220.3 32 237.2 32 256zm190.2 42.5c1.1-3.3 1.8-6.8 1.8-10.5l0-32c0-35.3-28.7-64-64-64l-64 0c-3.7 0-7.4 .3-10.9 .9L222.2 298.5zM384 160a64 64 0 1 0 0-128 64 64 0 1 0 0 128zm-32 32c-35.3 0-64 28.7-64 64l0 32c0 17.7 14.3 32 32 32l128 0c17.7 0 32-14.3 32-32l0-32c0-35.3-28.7-64-64-64l-64 0zM215.8 450.1c5.2-4.6 8.2-11.1 8.2-18.1s-3-13.5-8.2-18.1l-64-56c-7.1-6.2-17.1-7.7-25.7-3.8S112 366.6 112 376l0 32-88 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l88 0 0 32c0 9.4 5.5 18 14.1 21.9s18.6 2.4 25.7-3.8l64-56zM288 431.9c0 6.9 3 13.5 8.1 18.1l64 56.4c7.1 6.2 17.1 7.8 25.7 3.9S400 497.8 400 488.4l0-32.4 88 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-88 0 0-32c0-9.4-5.5-18-14.1-21.9s-18.6-2.4-25.7 3.8l-64 56c-5.2 4.5-8.2 11.1-8.2 18z"],
    "image-music": [640, 512, [], "e770", "M128 32C92.7 32 64 60.7 64 96l0 320c0 35.3 28.7 64 64 64l145.5 0c4.6-24.3 19.4-43.7 36.5-56.5 3.6-2.7 7.5-5.2 11.4-7.5L152 416c-8.9 0-17.2-5-21.3-12.9s-3.5-17.5 1.6-24.8l56-80c4.5-6.4 11.8-10.2 19.7-10.2s15.2 3.8 19.7 10.2l26.4 37.8 61.4-100.5c4.4-7.1 12.1-11.5 20.5-11.5s16.1 4.4 20.5 11.5l7.6 12.4c10.5-15.8 27.2-27.3 47-30.9L512 198.7 512 96c0-35.3-28.7-64-64-64L128 32zm64 80a48 48 0 1 1 0 96 48 48 0 1 1 0-96zM624 255.9c0-7.1-3.2-13.9-8.6-18.4s-12.7-6.5-19.7-5.2l-176 32c-11.4 2.1-19.7 12-19.7 23.6l0 161.6c-5.9-1.1-11.4-1.6-16-1.6-9.5 0-22.9 2.1-34.9 7.5-11.1 5-29.1 17.2-29.1 40.5s18 35.4 29.1 40.5c11.9 5.4 25.4 7.5 34.9 7.5s22.9-2.1 34.9-7.5c11.1-5 29.1-17.2 29.1-40.5l0-139.9 128-23.3 0 84.9c-5.9-1.1-11.4-1.6-16-1.6-9.5 0-22.9 2.1-34.9 7.5-11.1 5-29.1 17.2-29.1 40.5s18 35.4 29.1 40.5c11.9 5.4 25.4 7.5 34.9 7.5s22.9-2.1 34.9-7.5c11.1-5 29.1-17.2 29.1-40.5l0-208z"],
    "person-pinball": [512, 512, [], "e21d", "M480-32c17.7 0 32 14.3 32 32l0 512c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-128-224 0 0 128c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-213-48-61.7 0 274.8c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-133.5-.2-3.2c-.6-6.3-3.1-12.2-7.1-17.1l-2.1-2.3-10.5-10.5C10.1 327.4 0 303 0 277.5L0 171.7c0-33 26.7-59.7 59.7-59.7l4.3 .1c21.1 1.2 40.7 11.5 53.8 28.2L199.5 245.5 431 194.1 387.3 63c-2.2-6.5-3.3-13.3-3.3-20.2l0-42.8 .2-3.3C385.8-19.4 399.4-32 416-32l64 0zM248 288a24 24 0 1 0 0 48 24 24 0 1 0 0-48zM64 80A56 56 0 1 1 64-32 56 56 0 1 1 64 80z"],
    "mouse-field": [512, 512, [], "e5a8", "M396.4 112.9c2.3-7.9 3.6-16.2 3.6-24.9 0-48.6-39.4-88-88-88s-88 39.4-88 88c0 29.9 14.9 56.3 37.6 72.2-92.2 4.1-165.6 80.2-165.6 173.4 0 12.3 2.7 24 7.5 34.4L72 368c-39.8 0-72 32.2-72 72s32.2 72 72 72l384 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L72 464c-13.3 0-24-10.7-24-24s10.7-24 24-24l310.6 0c18.5 0 33.4-15 33.4-33.4 0-14.1-8.8-26.6-22-31.4l-43.7-15.9 23.8-63.5c2 .1 4 .2 6 .2l102.8 0c16.1 0 29.1-13 29.1-29.1 0-41.5-19.3-78.4-49.4-102.4 10.9-14.7 17.4-32.8 17.4-52.5 0-46.4-35.9-84.4-81.4-87.8 20.6 20.3 33.4 48.5 33.4 79.8 0 13.9-2.5 27.2-7.2 39.5-9.1-3.2-18.6-5.5-28.4-6.6zM400 196a20 20 0 1 1 40 0 20 20 0 1 1 -40 0zM312 48c22.1 0 40 17.9 40 40l0 24c0 8.8-7.2 16-16 16l-24 0c-22.1 0-40-17.9-40-40s17.9-40 40-40z"],
    "table-cells-column-lock": [640, 512, [], "e678", "M256 224l0 192 64 0 0-192-64 0zm256-79c-46.7 5.8-85.6 36.8-102.7 79l-25.3 0 0 90.8c-10.1 15.2-16 33.4-16 53.1l0 96c0 5.5 .5 10.9 1.3 16.1L128 480c-35.3 0-64-28.7-64-64L64 96c0-35.3 28.7-64 64-64l320 0c35.3 0 64 28.7 64 64l0 49zM128 224l0 192 64 0 0-192-64 0zm432 48.1c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 47.9 64 0 0-47.9zM416 368c0-20.9 13.4-38.7 32-45.3l0-50.6c0-44.2 35.8-80 80-80s80 35.8 80 80l0 50.6c18.6 6.6 32 24.4 32 45.3l0 96c0 26.5-21.5 48-48 48l-128 0c-26.5 0-48-21.5-48-48l0-96z"],
    "truck-field-un": [640, 512, [], "e58e", "M96 32C60.7 32 32 60.7 32 96l0 32c-17.7 0-32 14.3-32 32l0 96c0 17.7 14.3 32 32 32l0 48c0 21.1 13.7 39.1 32.6 45.5-.4 3.4-.6 7-.6 10.5 0 48.6 39.4 88 88 88s88-39.4 88-88c0-2.7-.1-5.4-.4-8l144.7 0c-.2 2.6-.4 5.3-.4 8 0 48.6 39.4 88 88 88s88-39.4 88-88c0-2.7-.1-5.4-.4-8l.4 0c26.5 0 48-21.5 48-48l0-64c0-26.5-21.5-48-48-48l-24.7 0-1.7-4.2-43.8-106.3c-12.3-30-41.6-49.5-74-49.5l-40.4 0C364.4 44.9 343.7 32 320 32L96 32zM384 224l0-96 31.9 0c6.5 0 12.3 3.9 14.8 9.9l35.4 86.1-82.1 0zM152 352a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm280 40a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zM256.6 132.9l27.4 41 0-29.9c0-11 9-20 20-20s20 9 20 20l0 96c0 8.8-5.8 16.6-14.2 19.1s-17.5-.7-22.4-8l-27.4-41 0 29.9c0 11-9 20-20 20s-20-9-20-20l0-96c0-8.8 5.8-16.6 14.2-19.1s17.5 .7 22.4 8zM132 144l0 64c0 6.6 5.4 12 12 12s12-5.4 12-12l0-64c0-11 9-20 20-20s20 9 20 20l0 64c0 28.7-23.3 52-52 52s-52-23.3-52-52l0-64c0-11 9-20 20-20s20 9 20 20z"],
    "clock": [512, 512, [128339, "clock-four"], "f017", "M256 0a256 256 0 1 1 0 512 256 256 0 1 1 0-512zM232 120l0 136c0 8 4 15.5 10.7 20l96 64c11 7.4 25.9 4.4 33.3-6.7s4.4-25.9-6.7-33.3L280 243.2 280 120c0-13.3-10.7-24-24-24s-24 10.7-24 24z"],
    "layer-minus": [512, 512, ["layer-group-minus"], "f5fe", "M376 24l112 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L376 72c-13.3 0-24-10.7-24-24s10.7-24 24-24zM232.5 101.2c14.9-6.9 32.1-6.9 47 0l218.6 101c8.5 3.9 13.9 12.4 13.9 21.8s-5.4 17.9-13.9 21.8l-218.6 101c-14.9 6.9-32.1 6.9-47 0L13.9 245.8C5.4 241.8 0 233.3 0 224s5.4-17.9 13.9-21.8l218.6-101zM82.7 330.4l129.7 59.9c27.7 12.8 59.6 12.8 87.3 0l129.7-59.9 68.7 31.8c8.5 3.9 13.9 12.4 13.9 21.8s-5.4 17.9-13.9 21.8l-218.6 101c-14.9 6.9-32.1 6.9-47 0L13.9 405.8C5.4 401.8 0 393.3 0 384s5.4-17.9 13.9-21.8l68.7-31.8z"],
    "circle-euro": [512, 512, [], "e5ce", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm23.9-392l33 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-33 0c-31 0-58.3 15.9-74.2 40l50.3 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-63.3 0c-1 5.4-1.6 11-1.6 16.8 0 5.2 .4 10.3 1.3 15.2l63.5 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-51.2 0c15.7 24.9 43.5 41.5 75.2 41.5l33 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-33 0c-58.9 0-109.1-37.3-128.4-89.5L136 304c-8.8 0-16-7.2-16-16s7.2-16 16-16l8 0c-.6-5-.8-10.1-.8-15.2 0-5.7 .3-11.3 1-16.8l-8.2 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l16.1 0c19.6-51.5 69.5-88 127.8-88z"],
    "book": [448, 512, [128212], "f02d", "M384 512L96 512c-53 0-96-43-96-96L0 96C0 43 43 0 96 0L400 0c26.5 0 48 21.5 48 48l0 288c0 20.9-13.4 38.7-32 45.3l0 66.7c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32 0zM96 384c-17.7 0-32 14.3-32 32s14.3 32 32 32l256 0 0-64-256 0zm32-232c0 13.3 10.7 24 24 24l176 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-176 0c-13.3 0-24 10.7-24 24zm24 72c-13.3 0-24 10.7-24 24s10.7 24 24 24l176 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-176 0z"],
    "face-laugh-wink": [512, 512, ["laugh-wink"], "f59c", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM101.6 314c-3.7-13.7 7.5-26 21.7-26l265.4 0c14.2 0 25.4 12.3 21.7 26-18.5 68-80.6 118-154.4 118S120 382 101.6 314zM144 192a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm164 8c0 11-9 20-20 20s-20-9-20-20c0-33.1 26.9-60 60-60l16 0c33.1 0 60 26.9 60 60 0 11-9 20-20 20s-20-9-20-20-9-20-20-20l-16 0c-11 0-20 9-20 20z"],
    "transducer": [384, 512, [], "e826", "M80 544l-32 0c-26.5 0-48-21.5-48-48l0-48c0-26.5 21.5-48 48-48l32 0 0 144zm176 0l-128 0 0-144 128 0 0 144zm80-144c26.5 0 48 21.5 48 48l0 48c0 26.5-21.5 48-48 48l-32 0 0-144 32 0zM248-32c13.3 0 24 10.7 24 24l0 72c26.5 0 48 21.5 48 48l0 240-256 0 0-240c0-26.5 21.5-48 48-48l0-72c0-13.3 10.7-24 24-24s24 10.7 24 24l0 72 64 0 0-72c0-13.3 10.7-24 24-24z"],
    "user-doctor-hair-long": [448, 512, [], "e459", "M304 128c0-20.2-7.5-38.6-19.8-52.7l-33.1 28.9c-17.5 15.3-40 23.8-63.2 23.8l-43.9 0 0 16c0 44.2 35.8 80 80 80s80-35.8 80-80l0-16zM96 128c0-38.9 17.4-73.8 44.8-97.3 3.6-3.8 7.9-7.1 12.6-9.5 20.2-13.4 44.5-21.2 70.6-21.2 70.7 0 128 57.3 128 128l0 24.2c0 25.5 10.1 49.9 28.1 67.9l13.3 13.3c4.2 4.2 6.6 10 6.6 16 0 12.5-10.1 22.6-22.6 22.6L70.6 272c-12.5 0-22.6-10.1-22.6-22.6 0-6 2.4-11.8 6.6-16l13.3-13.3c18-18 28.1-42.4 28.1-67.9L96 128zM284 320.8l0 46.6c-23.3 8.2-40 30.5-40 56.6l0 32c0 11 9 20 20 20s20-9 20-20l0-32c0-11 9-20 20-20s20 9 20 20l0 32c0 11 9 20 20 20s20-9 20-20l0-32c0-26.1-16.7-48.3-40-56.6l0-37.4c63 23.1 108 83.6 108 154.6 0 15.1-12.3 27.4-27.4 27.4L43.4 512C28.3 512 16 499.7 16 484.6 16 413.6 61 353 124 330l0 58.4c-16.5 7.6-28 24.3-28 43.6 0 26.5 21.5 48 48 48s48-21.5 48-48c0-19.4-11.5-36.1-28-43.6l0-67.5c5.4-.5 11-.8 16.6-.8l86.9 0c5.6 0 11.1 .3 16.6 .8z"],
    "cloud-meatball": [512, 512, [], "f73b", "M0 224c0 53 43 96 96 96l26.9 0c3.5-12.1 10.1-23.3 19.2-32.4l1.4-1.4c15-15 35.3-22.9 56.1-22.2 14.2-15.1 34.2-23.9 55.4-23.9l2 0c21.1 0 41.1 8.8 55.4 23.9 20.8-.6 41.1 7.3 56.1 22.2l1.4 1.4c9.2 9.2 15.7 20.4 19.2 32.4l26.9 0c53 0 96-43 96-96s-43-96-96-96c-.5 0-1.1 0-1.6 0 1.1-5.2 1.6-10.5 1.6-16 0-44.2-35.8-80-80-80-24.3 0-46.1 10.9-60.8 28-18.7-35.7-56.1-60-99.2-60-61.9 0-112 50.1-112 112 0 7.1 .7 14.1 1.9 20.8-38.3 12.6-65.9 48.7-65.9 91.2zM156.5 424.3c9.5 6.3 14.2 17.7 11.9 28.8-1.8 9.2 1 18.7 7.7 25.3l1.4 1.4c6.6 6.6 16.1 9.5 25.3 7.7 11.1-2.2 22.5 2.5 28.8 11.9 5.2 7.8 14 12.5 23.3 12.5l2 0c9.4 0 18.1-4.7 23.3-12.5 6.3-9.5 17.7-14.2 28.8-11.9 9.2 1.8 18.7-1 25.3-7.7l1.4-1.4c6.6-6.6 9.5-16.1 7.7-25.3-2.2-11.1 2.5-22.5 11.9-28.8 7.8-5.2 12.5-14 12.5-23.3l0-2c0-9.4-4.7-18.1-12.5-23.3-9.5-6.3-14.2-17.7-11.9-28.8 1.8-9.2-1-18.7-7.7-25.3l-1.4-1.4c-6.6-6.6-16.1-9.5-25.3-7.7-11.1 2.2-22.5-2.5-28.8-11.9-5.2-7.8-14-12.5-23.3-12.5l-2 0c-9.4 0-18.1 4.7-23.3 12.5-6.3 9.5-17.7 14.2-28.8 11.9-9.2-1.8-18.7 1-25.3 7.7l-1.4 1.4c-6.6 6.6-9.5 16.1-7.7 25.3 2.2 11.1-2.5 22.5-11.9 28.8-7.8 5.2-12.5 14-12.5 23.3l0 2c0 9.4 4.7 18.1 12.5 23.3zM48 448a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm416 0a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"],
    "cloud-xmark": [576, 512, [], "e35f", "M144 480c-79.5 0-144-64.5-144-144 0-63.4 41-117.2 97.9-136.5-1.3-7.7-1.9-15.5-1.9-23.5 0-79.5 64.5-144 144-144 55.4 0 103.5 31.3 127.6 77.1 14.2-8.3 30.8-13.1 48.4-13.1 53 0 96 43 96 96 0 15.7-3.8 30.6-10.5 43.7 44 20.3 74.5 64.7 74.5 116.3 0 70.7-57.3 128-128 128l-304 0zM355.9 220.1c-9.4-9.4-24.6-9.4-33.9 0l-33.9 33.9-33.9-33.9c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l33.9 33.9-33.9 33.9c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l33.9-33.9 33.9 33.9c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-33.9-33.9 33.9-33.9c9.4-9.4 9.4-24.6 0-33.9z"],
    "chart-area": [512, 512, ["area-chart"], "f1fe", "M32 32c17.7 0 32 14.3 32 32l0 336c0 8.8 7.2 16 16 16l400 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L80 480c-44.2 0-80-35.8-80-80L0 64C0 46.3 14.3 32 32 32zM240 96c6.7 0 13.1 2.8 17.7 7.8L328.8 181.3 375 135c9.4-9.4 24.6-9.4 33.9 0l64 64c4.5 4.5 7 10.6 7 17l0 112c0 13.3-10.7 24-24 24l-304 0c-13.3 0-24-10.7-24-24l0-112c0-6 2.3-11.8 6.3-16.2l88-96c4.5-5 11-7.8 17.7-7.8z"],
    "utility-pole-double": [512, 512, [], "e2c4", "M256 0c17.7 0 32 14.3 32 32l0 32 96 0 0-8c0-13.3 10.7-24 24-24s24 10.7 24 24l0 8 32 0 0-8c0-13.3 10.7-24 24-24s24 10.7 24 24l0 40c0 17.7-14.3 32-32 32l-36.7 0-155.3 103.5 0 24.5 96 0 0-8c0-13.3 10.7-24 24-24s24 10.7 24 24l0 8 32 0 0-8c0-13.3 10.7-24 24-24s24 10.7 24 24l0 40c0 17.7-14.3 32-32 32l-36.7 0-155.3 103.5 0 56.5c0 17.7-14.3 32-32 32s-32-14.3-32-32L224 423.5 68.7 320 32 320c-17.7 0-32-14.3-32-32l0-40c0-13.3 10.7-24 24-24s24 10.7 24 24l0 8 32 0 0-8c0-13.3 10.7-24 24-24s24 10.7 24 24l0 8 96 0 0-24.5-155.3-103.5-36.7 0C14.3 128 0 113.7 0 96L0 56C0 42.7 10.7 32 24 32S48 42.7 48 56l0 8 32 0 0-8c0-13.3 10.7-24 24-24s24 10.7 24 24l0 8 96 0 0-32c0-17.7 14.3-32 32-32zM155.3 128l68.7 45.8 0-45.8-68.7 0zM288 173.8l68.7-45.8-68.7 0 0 45.8zM155.3 320l68.7 45.8 0-45.8-68.7 0zM288 365.8l68.7-45.8-68.7 0 0 45.8z"],
    "rupiah-sign": [512, 512, [], "e23d", "M0 64C0 46.3 14.3 32 32 32l80 0c79.5 0 144 64.5 144 144 0 54.3-30 101.5-74.4 126.1l41 136.7c5.1 16.9-4.5 34.8-21.5 39.8s-34.8-4.5-39.8-21.5L120.1 319.8c-2.7 .1-5.4 .2-8.1 .2l-48 0 0 128c0 17.7-14.3 32-32 32S0 465.7 0 448L0 64zM64 256l48 0c44.2 0 80-35.8 80-80s-35.8-80-80-80l-48 0 0 160zm256-32l80 0c61.9 0 112 50.1 112 112S461.9 448 400 448l-48 0 0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-256c0-17.7 14.3-32 32-32zm80 160c26.5 0 48-21.5 48-48s-21.5-48-48-48l-48 0 0 96 48 0z"],
    "diagram-nested": [448, 512, [], "e157", "M0 80C0 53.5 21.5 32 48 32l96 0c26.5 0 48 21.5 48 48l0 96c0 26.5-21.5 48-48 48l-16 0 0 96c0 17.7 14.3 32 32 32l96 0 0-16c0-26.5 21.5-48 48-48l96 0c26.5 0 48 21.5 48 48l0 96c0 26.5-21.5 48-48 48l-96 0c-26.5 0-48-21.5-48-48l0-16-96 0c-53 0-96-43-96-96l0-96-16 0c-26.5 0-48-21.5-48-48L0 80z"],
    "square-quarters": [448, 512, [], "e44e", "M0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm64 0L224 256 384 96 64 96zm0 320l320 0-160-160-160 160z"],
    "print-slash": [576, 512, [], "f686", "M41-24.9c-9.4-9.4-24.6-9.4-33.9 0S-2.3-.3 7 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-89-89 0-30.2 32 0c17.7 0 32-14.3 32-32l0-96c0-35.3-28.7-64-64-64l-222.2 0-48-48 270.2 0 0-37.5c0-17-6.7-33.3-18.7-45.3L418.7 18.7C406.7 6.7 390.5 0 373.5 0L160 0c-25.5 0-47.5 14.9-57.8 36.4L41-24.9zM378 448l-218 0 0-96 122 0-160-160-26 0c-35.3 0-64 28.7-64 64l0 96c0 17.7 14.3 32 32 32l32 0 0 64c0 35.3 28.7 64 64 64l256 0c7.8 0 15.2-1.4 22.1-3.9L378 448zm62-176a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"],
    "shield-keyhole": [512, 512, [], "e248", "M269.4 2.9C265.2 1 260.7 0 256 0s-9.2 1-13.4 2.9L54.3 82.8c-22 9.3-38.4 31-38.3 57.2 .5 99.2 41.3 280.7 213.6 363.2 16.7 8 36.1 8 52.8 0 172.4-82.5 213.2-264 213.6-363.2 .1-26.2-16.3-47.9-38.3-57.2L269.4 2.9zM312 208c0 22.3-13.1 41.6-32 50.6l0 69.4c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-69.4c-18.9-9-32-28.3-32-50.6 0-30.9 25.1-56 56-56s56 25.1 56 56z"],
    "square-left": [448, 512, [11013, "arrow-alt-square-left"], "f351", "M0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM92.7 267.3l104 104c4.6 4.6 11.5 5.9 17.4 3.5s9.9-8.3 9.9-14.8l0-56 96 0c17.7 0 32-14.3 32-32l0-32c0-17.7-14.3-32-32-32l-96 0 0-56c0-6.5-3.9-12.3-9.9-14.8s-12.9-1.1-17.4 3.5l-104 104c-6.2 6.2-6.2 16.4 0 22.6z"],
    "text-width": [448, 512, [], "f035", "M40 0C17.9 0 0 17.9 0 40L0 96c0 17.7 14.3 32 32 32s32-14.3 32-32l0-32 128 0 0 160-32 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l128 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0 0-160 128 0 0 32c0 17.7 14.3 32 32 32s32-14.3 32-32l0-56c0-22.1-17.9-40-40-40L40 0zm78.6 406.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-64 64c-12.5 12.5-12.5 32.8 0 45.3l64 64c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-9.4-9.4 229.5 0-9.4 9.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l64-64c12.5-12.5 12.5-32.8 0-45.3l-64-64c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l9.4 9.4-229.5 0 9.4-9.4z"],
    "circle-currency": [512, 512, [], "e6ee", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM151 151c9.4-9.4 24.6-9.4 33.9 0l22.3 22.3c14.3-8.4 31-13.3 48.8-13.3s34.5 4.8 48.8 13.3L327 151c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-22.3 22.3c8.4 14.3 13.3 31 13.3 48.8s-4.8 34.5-13.3 48.8L361 327c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-22.3-22.3c-14.3 8.4-31 13.3-48.8 13.3s-34.5-4.8-48.8-13.3L185 361c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l22.3-22.3c-8.4-14.3-13.3-31-13.3-48.8s4.8-34.5 13.3-48.8L151 185c-9.4-9.4-9.4-24.6 0-33.9zm71.1 70.9l-.2 .2c-8.6 8.7-13.9 20.6-13.9 33.8s5.3 25.1 13.9 33.8l.2 .2c8.7 8.6 20.6 13.9 33.8 13.9s25.2-5.3 33.8-13.9l.2-.2c8.6-8.7 13.9-20.6 13.9-33.8s-5.3-25.1-13.9-33.8l-.2-.2c-8.7-8.6-20.6-13.9-33.8-13.9s-25.2 5.3-33.8 13.9z"],
    "signature-lock": [576, 512, [], "e3ca", "M128 128c0-17.7 14.3-32 32-32s32 14.3 32 32l0 7.8c0 26.1-2.1 52.2-6.4 77.9l-88 29.3C58.4 256.1 32 292.8 32 334.1l0 73.4c0 40 32.5 72.5 72.5 72.5 26 0 50-13.9 62.9-36.5l13.9-24.3c27.1-47.4 46.9-98.6 58.7-151.9l1-4.6 60.3-20.1-11.8 35.3c-3.3 9.8-1.6 20.5 4.4 28.8 5.4 7.5 13.7 12.2 22.8 13.1 5.1-8.8 11.6-16.7 19.1-23.5l0-24.4c0-38.4 16.9-72.8 43.6-96.2-1.4-2.3-3-4.5-5-6.4-8.6-8.6-21.2-11.6-32.7-7.7l-88.7 29.6c1.9-18.4 2.8-36.9 2.8-55.4l0-7.8c0-53-43-96-96-96S64 75 64 128l0 32c0 17.7 14.3 32 32 32s32-14.3 32-32l0-32zM259.1 368c-6.5 16.3-13.7 32.3-21.6 48l66.5 0 0-48-44.9 0zM117.9 303.8l51-17c-10.5 35-24.9 68.8-43.1 100.6l-13.9 24.3c-1.5 2.6-4.3 4.3-7.4 4.3-4.7 0-8.5-3.8-8.5-8.5l0-73.4c0-13.8 8.8-26 21.9-30.4zM496 272.1l0 47.9-64 0 0-47.9c0-17.7 14.3-32 32-32s32 14.3 32 32zM352 368l0 96c0 26.5 21.5 48 48 48l128 0c26.5 0 48-21.5 48-48l0-96c0-20.9-13.4-38.7-32-45.3l0-50.6c0-44.2-35.8-80-80-80s-80 35.8-80 80l0 50.6c-18.6 6.6-32 24.4-32 45.3z"],
    "satellite": [512, 512, [128752], "f7bf", "M199 7c9.4-9.4 24.6-9.4 33.9 0l89.4 89.4 55-55c12.5-12.5 32.8-12.5 45.3 0l48 48c12.5 12.5 12.5 32.8 0 45.3l-55 55 89.4 89.4c9.4 9.4 9.4 24.6 0 33.9l-96 96c-9.4 9.4-24.6 9.4-33.9 0l-89.4-89.4-15.5 15.5c11.4 24.6 17.8 52 17.8 80.9 0 31.7-7.7 61.5-21.2 87.8-4.7 9-16.7 10.3-23.8 3.1l-96.3-96.3-60 60c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l60-60-96.3-96.3c-7.2-7.2-5.9-19.2 3.1-23.8 26.3-13.6 56.2-21.2 87.8-21.2 28.9 0 56.3 6.4 80.9 17.8L192.4 226.3 103 137c-9.4-9.4-9.4-24.6 0-33.9L199 7zm17 50.9l-62.1 62.1 72.4 72.4 62.1-62.1-72.4-72.4zM392 358.1l62.1-62.1-72.4-72.4-62.1 62.1 72.4 72.4z"],
    "ball-pile": [576, 512, [], "f77e", "M288 160a80 80 0 1 0 0-160 80 80 0 1 0 0 160zM176 328a80 80 0 1 0 0-160 80 80 0 1 0 0 160zM160 432a80 80 0 1 0 -160 0 80 80 0 1 0 160 0zm128 80a80 80 0 1 0 0-160 80 80 0 1 0 0 160zm288-80a80 80 0 1 0 -160 0 80 80 0 1 0 160 0zM400 328a80 80 0 1 0 0-160 80 80 0 1 0 0 160z"],
    "seats": [512, 512, [], "e765", "M96 0l64 0c35.3 0 64 28.7 64 64l0 176-192 0 0-176C32 28.7 60.7 0 96 0zM352 0l64 0c35.3 0 64 28.7 64 64l0 176-192 0 0-176c0-35.3 28.7-64 64-64zM512 352c0 17.7-14.3 32-32 32l0 96c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-96-128 0 0 96c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-96-128 0 0 96c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-96c-17.7 0-32-14.3-32-32l0-32c0-17.7 14.3-32 32-32l448 0c17.7 0 32 14.3 32 32l0 32z"],
    "file-eps": [576, 512, [], "e644", "M96 0C60.7 0 32 28.7 32 64l0 384c0 35.3 28.7 64 64 64l80 0 0-112c0-35.3 28.7-64 64-64l176 0 0-165.5c0-17-6.7-33.3-18.7-45.3L290.7 18.7C278.7 6.7 262.5 0 245.5 0L96 0zM357.5 176L264 176c-13.3 0-24-10.7-24-24L240 58.5 357.5 176zM240 380c-11 0-20 9-20 20l0 128c0 11 9 20 20 20l64 0c11 0 20-9 20-20s-9-20-20-20l-44 0 0-24 28 0c11 0 20-9 20-20s-9-20-20-20l-28 0 0-24 44 0c11 0 20-9 20-20s-9-20-20-20l-64 0zm128 0c-11 0-20 9-20 20l0 128c0 11 9 20 20 20s20-9 20-20l0-28 12 0c33.1 0 60-26.9 60-60s-26.9-60-60-60l-32 0zm32 80l-12 0 0-40 12 0c11 0 20 9 20 20s-9 20-20 20zm76-28c0 28.7 23.3 52 52 52 6.6 0 12 5.4 12 12s-5.4 12-12 12l-32 0c-11 0-20 9-20 20s9 20 20 20l32 0c28.7 0 52-23.3 52-52s-23.3-52-52-52c-6.6 0-12-5.4-12-12s5.4-12 12-12l24 0c11 0 20-9 20-20s-9-20-20-20l-24 0c-28.7 0-52 23.3-52 52z"],
    "magnifying-glass-minus": [512, 512, ["search-minus"], "f010", "M416 208c0 45.9-14.9 88.3-40 122.7L502.6 457.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L330.7 376C296.3 401.1 253.9 416 208 416 93.1 416 0 322.9 0 208S93.1 0 208 0 416 93.1 416 208zM136 184c-13.3 0-24 10.7-24 24s10.7 24 24 24l144 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-144 0z"],
    "vent-damper": [640, 512, [], "e465", "M64 128c0-35.3 28.7-64 64-64l384 0c35.3 0 64 28.7 64 64l0 32 32 0c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32l-32 0 0 32c0 35.3-28.7 64-64 64l-384 0c-35.3 0-64-28.7-64-64l0-32-32 0c-17.7 0-32-14.3-32-32L0 192c0-17.7 14.3-32 32-32l32 0 0-32zm120 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l272 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-272 0zm0 104c-13.3 0-24 10.7-24 24s10.7 24 24 24l272 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-272 0zm0 104c-13.3 0-24 10.7-24 24s10.7 24 24 24l272 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-272 0z"],
    "people-group": [512, 512, [], "e533", "M256 0a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm96 312c0 25-12.7 47-32 59.9l0 92.1c0 26.5-21.5 48-48 48l-32 0c-26.5 0-48-21.5-48-48l0-92.1C172.7 359 160 337 160 312l0-40c0-53 43-96 96-96s96 43 96 96l0 40zM96 32a56 56 0 1 1 0 112 56 56 0 1 1 0-112zm16 240l0 32c0 32.5 12.1 62.1 32 84.7l0 75.3c0 1.2 0 2.5 .1 3.7-8.5 7.6-19.7 12.3-32.1 12.3l-32 0c-26.5 0-48-21.5-48-48l0-56.6C12.9 364.4 0 343.7 0 320l0-32c0-53 43-96 96-96 12.7 0 24.8 2.5 35.9 6.9-12.6 21.4-19.9 46.4-19.9 73.1zM368 464l0-75.3c19.9-22.5 32-52.2 32-84.7l0-32c0-26.7-7.3-51.6-19.9-73.1 11.1-4.5 23.2-6.9 35.9-6.9 53 0 96 43 96 96l0 32c0 23.7-12.9 44.4-32 55.4l0 56.6c0 26.5-21.5 48-48 48l-32 0c-12.3 0-23.6-4.6-32.1-12.3 0-1.2 .1-2.5 .1-3.7zM416 32a56 56 0 1 1 0 112 56 56 0 1 1 0-112z"],
    "square-quote": [448, 512, [], "e329", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm64 128l48 0c17.7 0 32 14.3 32 32l0 87.3c0 35.2-25.4 65.2-60.2 71l-7.9 1.3c-13.1 2.2-25.4-6.7-27.6-19.7s6.7-25.4 19.7-27.6l7.9-1.3c11.6-1.9 20.1-11.9 20.1-23.7l0-7.3-32 0c-17.7 0-32-14.3-32-32l0-48c0-17.7 14.3-32 32-32zm224 80l0 39.3c0 35.2-25.4 65.2-60.2 71l-7.9 1.3c-13.1 2.2-25.4-6.7-27.6-19.7s6.7-25.4 19.7-27.6l7.9-1.3c11.6-1.9 20.1-11.9 20.1-23.7l0-7.3-32 0c-17.7 0-32-14.3-32-32l0-48c0-17.7 14.3-32 32-32l48 0c17.7 0 32 14.3 32 32l0 48z"],
    "square-binary": [448, 512, [], "e69b", "M0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm144 4c-24.3 0-44 19.7-44 44l0 48c0 24.3 19.7 44 44 44l32 0c24.3 0 44-19.7 44-44l0-48c0-24.3-19.7-44-44-44l-32 0zm-4 44c0-2.2 1.8-4 4-4l32 0c2.2 0 4 1.8 4 4l0 48c0 2.2-1.8 4-4 4l-32 0c-2.2 0-4-1.8-4-4l0-48zm140-44c-11 0-20 9-20 20 0 9.7 6.9 17.7 16 19.6l0 76.4c0 11 9 20 20 20s20-9 20-20l0-96c0-11-9-20-20-20l-16 0zM132 296c0 9.7 6.9 17.7 16 19.6l0 76.4c0 11 9 20 20 20s20-9 20-20l0-96c0-11-9-20-20-20l-16 0c-11 0-20 9-20 20zm96 24l0 48c0 24.3 19.7 44 44 44l32 0c24.3 0 44-19.7 44-44l0-48c0-24.3-19.7-44-44-44l-32 0c-24.3 0-44 19.7-44 44zm44-4l32 0c2.2 0 4 1.8 4 4l0 48c0 2.2-1.8 4-4 4l-32 0c-2.2 0-4-1.8-4-4l0-48c0-2.2 1.8-4 4-4z"],
    "masks-theater": [576, 512, [127917, "theater-masks"], "f630", "M-5 118L23.5 279.7c14 79.5 76.3 141.8 155.8 155.8l12.7 2.2c-16.5-28.6-27.1-60.7-30.6-94.5l-24.1 4.3c-9.7 1.7-18.8-5.8-16.9-15.5 4.8-24.7 19.1-46.6 39.7-60.9l0-74.6c-1.4 .8-3 1.3-4.7 1.6l-63 11.1c-8.7 1.5-17.3-4.4-15.9-13.1 3.1-19.6 18.4-36 39.1-39.7 17.2-3 33.9 3.5 44.6 15.8l0-22.7c0-22.5 6.9-52.4 32.3-73.4 26-21.5 67.7-43.9 124.9-54.2-30.5-16.3-86.3-32-163.8-18.4-80.3 14.2-128 50.1-150.1 76.1-9 10.5-10.8 24.9-8.4 38.5zM208 138.7l0 174.8c0 80.7 50.5 152.9 126.4 180.4L362.1 504c14.1 5.1 29.6 5.1 43.7 0L433.6 494C509.5 466.4 560 394.3 560 313.5l0-174.8c0-6.9-2.1-13.8-7-18.6-22.6-22.5-78.2-56-169-56s-146.4 33.6-169 56c-4.9 4.9-7 11.7-7 18.6zm66.1 187.1c-1.4-7 7-11 12.7-6.6 26.9 20.6 60.6 32.9 97.2 32.9s70.2-12.3 97.2-32.9c5.7-4.4 14.1-.4 12.7 6.6-10.1 51.4-55.5 90.3-109.9 90.3s-99.8-38.8-109.9-90.3zm.5-101.5C281.2 205.5 299 192 320 192s38.9 13.5 45.4 32.3c2.9 8.4-4.5 15.7-13.4 15.7l-64 0c-8.8 0-16.3-7.4-13.4-15.7zM480 240l-64 0c-8.8 0-16.3-7.4-13.4-15.7 6.5-18.8 24.4-32.3 45.4-32.3s38.9 13.5 45.4 32.3c2.9 8.4-4.5 15.7-13.4 15.7z"],
    "house-turret": [576, 512, [], "e1b4", "M288 0c-17.7 0-32 14.3-32 32l0 29.6c4.1 2.6 8 5.4 11.6 8.6L438.2 219.5c16.4 14.3 25.8 35.1 25.8 56.8 0 25.5-12.6 48.1-32 61.7l0 121.2c0 19.4-5.5 37.4-14.9 52.8L528 512c26.5 0 48-21.5 48-48l0-432c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 32-64 0 0-32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 32-64 0 0-32c0-17.7-14.3-32-32-32zm96 304l4.5 0c15.2 0 27.5-12.3 27.5-27.5 0-7.9-3.4-15.5-9.4-20.7L236 106.5C228.3 99.7 218.3 96 208 96s-20.3 3.7-28 10.5L9.4 255.8C3.4 261 0 268.6 0 276.5 0 291.7 12.3 304 27.5 304l4.5 0 0 155.4C32 488.4 55.6 512 84.6 512l246.8 0c29.1 0 52.6-23.6 52.6-52.6L384 304zm-224-8c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-48z"],
    "cart-plus": [640, 512, [], "f217", "M0 8C0-5.3 10.7-16 24-16l45.3 0c27.1 0 50.3 19.4 55.1 46l.4 2 412.7 0c20 0 35.1 18.2 31.4 37.9L537.8 235.8c-5.7 30.3-32.1 52.2-62.9 52.2l-303.6 0 5.1 28.3c2.1 11.4 12 19.7 23.6 19.7L456 336c13.3 0 24 10.7 24 24s-10.7 24-24 24l-255.9 0c-34.8 0-64.6-24.9-70.8-59.1L77.2 38.6c-.7-3.8-4-6.6-7.9-6.6L24 32C10.7 32 0 21.3 0 8zM160 464a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm224 0a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM336 78.4c-13.3 0-24 10.7-24 24l0 33.6-33.6 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l33.6 0 0 33.6c0 13.3 10.7 24 24 24s24-10.7 24-24l0-33.6 33.6 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-33.6 0 0-33.6c0-13.3-10.7-24-24-24z"],
    "hands-asl-interpreting": [640, 512, ["american-sign-language-interpreting", "asl-interpreting", "hands-american-sign-language-interpreting"], "f2a3", "M156.6 46.3c7.9-15.8 1.5-35-14.3-42.9s-35-1.5-42.9 14.3L13.5 189.4C4.6 207.2 0 226.8 0 246.7L0 256c0 70.7 57.3 128 128 128l80 0 0-.3c35.2-2.7 65.4-22.8 82.1-51.7 8.8-15.3 3.6-34.9-11.7-43.7s-34.9-3.6-43.7 11.7c-7 12-19.9 20-34.7 20-22.1 0-40-17.9-40-40s17.9-40 40-40c14.8 0 27.7 8 34.7 20 8.8 15.3 28.4 20.5 43.7 11.7s20.5-28.4 11.7-43.7c-12.8-22.1-33.6-39.1-58.4-47.1l80.8-22c17-4.6 27.1-22.2 22.5-39.3s-22.2-27.1-39.3-22.5l-100.7 27.5 81.6-68c13.6-11.3 15.4-31.5 4.1-45.1S249.1-3.9 235.5 7.4l-101.9 84.9 23-46zM483.4 465.7c-7.9 15.8-1.5 35 14.3 42.9s35 1.5 42.9-14.3l85.9-171.7c8.9-17.8 13.5-37.4 13.5-57.2l0-9.3c0-70.7-57.3-128-128-128l-80 0 0 .3c-35.2 2.7-65.4 22.8-82.1 51.7-8.9 15.3-3.6 34.9 11.7 43.7s34.9 3.6 43.7-11.7c7-12 19.9-20 34.7-20 22.1 0 40 17.9 40 40s-17.9 40-40 40c-14.8 0-27.7-8-34.7-20-8.9-15.3-28.4-20.5-43.7-11.7s-20.5 28.4-11.7 43.7c12.8 22.1 33.6 39.1 58.4 47.1l-80.8 22c-17.1 4.6-27.1 22.2-22.5 39.3s22.2 27.1 39.3 22.5l100.7-27.5-81.6 68c-13.6 11.3-15.4 31.5-4.1 45.1s31.5 15.4 45.1 4.1l101.9-84.9-23 46z"],
    "face-anxious-sweat": [640, 512, [], "e36a", "M320 512c141.4 0 256-114.6 256-256S461.4 0 320 0c-136 0-247.2 106.1-255.5 240 12.8 .1 25.6 4.6 36 13.5l.3 .3c14.4 12.5 32.3 29.7 46.8 50.2 14.3 20.1 28.4 47.7 28.4 80.1 0 25.4-8 48.6-21.7 67.2 44.7 38 102.5 60.8 165.7 60.8zm0-192c44.2 0 80 35.8 80 80 0 8.8-7.2 16-16 16l-128 0c-8.8 0-16-7.2-16-16 0-44.2 35.8-80 80-80zm112-48a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM240 240a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm22.1-94.1c7.8 7.8 7.8 20.5 0 28.3l-7.4 7.4c-24.2 24.2-55.3 40.2-89 45.8l-2.5 .4c-10.9 1.8-21.2-5.5-23-16.4s5.5-21.2 16.4-23l2.5-.4c25.5-4.2 49-16.4 67.3-34.6l7.4-7.4c7.8-7.8 20.5-7.8 28.3 0zm115.7 28.3c-7.8-7.8-7.8-20.5 0-28.3s20.5-7.8 28.3 0l7.4 7.4c18.3 18.3 41.8 30.4 67.3 34.6l2.5 .4c10.9 1.8 18.3 12.1 16.4 23s-12.1 18.3-23 16.4l-2.5-.4c-33.7-5.6-64.8-21.6-89-45.8l-7.4-7.4zM128 384c0-36.9-32.5-71.1-58.8-94.1-3-2.6-7.4-2.6-10.4 0-26.3 23-58.8 57.2-58.8 94.1 0 36.4 27.6 64 64 64s64-27.6 64-64z"],
    "message-smile": [512, 512, ["comment-alt-smile"], "f4aa", "M0 128L0 352c0 53 43 96 96 96l32 0 0 72c0 13.3 10.7 24 24 24 5.2 0 10.2-1.7 14.4-4.8l115.2-86.4c4.2-3.1 9.2-4.8 14.4-4.8l120 0c53 0 96-43 96-96l0-224c0-53-43-96-96-96L96 32C43 32 0 75 0 128zm192 32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm128 0a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM150.5 286.1c9.9-8.8 25-8 33.9 1.9 17.6 19.7 43.1 32 71.6 32s53.9-12.3 71.6-32c8.8-9.9 24-10.7 33.9-1.9s10.7 24 1.9 33.9C337 349.4 298.6 368 256 368s-81-18.6-107.3-48c-8.8-9.9-8-25 1.9-33.9z"],
    "location-exclamation": [384, 512, ["map-marker-exclamation"], "f608", "M192 0C298 0 384 84.4 384 188.6 384 307.9 263.8 450.9 213.6 505.4 201.8 518.2 182.2 518.2 170.4 505.4 120.2 450.9 0 307.9 0 188.6 0 84.4 86 0 192 0zm0 288a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm0-192c-18.2 0-32.7 15.5-31.4 33.7l7.4 104c.9 12.6 11.4 22.3 23.9 22.3 12.6 0 23-9.7 23.9-22.3l7.4-104C224.7 111.5 210.2 96 192 96z"],
    "square-naira": [448, 512, [], "e708", "M0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm171.7 42.3c-6-8.6-16.9-12.4-26.9-9.2S128 141.5 128 152l0 104-16 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l16 0 0 72c0 13.3 10.7 24 24 24s24-10.7 24-24l0-72 41 0 59.3 85.7c6 8.6 16.9 12.4 26.9 9.2S320 370.5 320 360l0-72 16 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0 0-104c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 104-18.8 0-81.5-117.7zM194.8 256l-18.8 0 0-27.2 18.8 27.2z"],
    "table-cells-row-unlock": [640, 512, [], "e691", "M256 224l0 192 64 0 0-192-64 0zm256-79c-46.7 5.8-85.6 36.8-102.7 79l-25.3 0 0 90.8c-10.1 15.2-16 33.4-16 53.1l0 96c0 5.5 .5 10.9 1.3 16.1L128 480c-35.3 0-64-28.7-64-64L64 96c0-35.3 28.7-64 64-64l320 0c35.3 0 64 28.7 64 64l0 49zM128 224l0 192 64 0 0-192-64 0zm432 48c-.1-17.6-14.4-31.9-32-31.9-17.7 0-32 14.3-32 32l0 47.9 96 0c26.5 0 48 21.5 48 48l0 96c0 26.5-21.5 48-48 48l-128 0c-26.5 0-48-21.5-48-48l0-96c0-20.9 13.4-38.7 32-45.3l0-50.6c0-44.2 35.8-80 80-80 44.2 0 79.9 35.8 80 79.9l-48 0z"],
    "diamonds-4": [512, 512, [], "e68b", "M166.9 446.9c-18.7-18.7-18.7-49.1 0-67.9l55.1-55.1c18.7-18.7 49.1-18.7 67.9 0L345.1 379c18.7 18.7 18.7 49.1 0 67.9L297 495c-10.9 10.9-25.6 17-41 17s-30.1-6.1-41-17l-48.1-48.1zM133 345.1c-18.7 18.7-49.1 18.7-67.9 0L17 297C6.1 286.1 0 271.4 0 256s6.1-30.1 17-41l48.1-48.1c18.7-18.7 49.1-18.7 67.9 0l55.1 55.1c18.7 18.7 18.7 49.1 0 67.9L133 345.1zm33.9-280L215 17C225.9 6.1 240.6 0 256 0s30.1 6.1 41 17l48.1 48.1c18.7 18.7 18.7 49.1 0 67.9l-55.1 55.1c-18.7 18.7-49.1 18.7-67.9 0L166.9 133c-18.7-18.7-18.7-49.1 0-67.9zm280 101.8L495 215c10.9 10.9 17 25.6 17 41s-6.1 30.1-17 41l-48.1 48.1c-18.7 18.7-49.1 18.7-67.9 0l-55.1-55.1c-18.7-18.7-18.7-49.1 0-67.9L379 166.9c18.7-18.7 49.1-18.7 67.9 0z"],
    "rocket": [512, 512, [], "f135", "M128 320L24.5 320c-24.9 0-40.2-27.1-27.4-48.5L50 183.3C58.7 168.8 74.3 160 91.2 160l95 0c76.1-128.9 189.6-135.4 265.5-124.3 12.8 1.9 22.8 11.9 24.6 24.6 11.1 75.9 4.6 189.4-124.3 265.5l0 95c0 16.9-8.8 32.5-23.3 41.2l-88.2 52.9c-21.3 12.8-48.5-2.6-48.5-27.4L192 384c0-35.3-28.7-64-64-64l-.1 0zM400 160a48 48 0 1 0 -96 0 48 48 0 1 0 96 0z"],
    "file-circle-info": [576, 512, [58604], "e493", "M96 0C60.7 0 32 28.7 32 64l0 384c0 35.3 28.7 64 64 64l180 0c-22.7-31.5-36-70.2-36-112 0-100.6 77.4-183.2 176-191.3l0-38.1c0-17-6.7-33.3-18.7-45.3L290.7 18.7C278.7 6.7 262.5 0 245.5 0L96 0zM357.5 176L264 176c-13.3 0-24-10.7-24-24L240 58.5 357.5 176zM432 544a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm0-228a20 20 0 1 1 0 40 20 20 0 1 1 0-40zm-32 84c0-8.8 7.2-16 16-16l16 0c8.8 0 16 7.2 16 16l0 48c8.8 0 16 7.2 16 16s-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l0 0 0-32 0 0c-8.8 0-16-7.2-16-16z"],
    "cloud-fog": [576, 512, [127787, "fog"], "f74e", "M32 224c0 53 43 96 96 96l320 0c53 0 96-43 96-96s-43-96-96-96c-.5 0-1.1 0-1.6 0 1.1-5.2 1.6-10.5 1.6-16 0-44.2-35.8-80-80-80-24.3 0-46.1 10.9-60.8 28-18.7-35.7-56.1-60-99.2-60-61.9 0-112 50.1-112 112 0 7.1 .7 14.1 1.9 20.8-38.3 12.6-65.9 48.7-65.9 91.2zM512 392c0-13.3-10.7-24-24-24L24 368c-13.3 0-24 10.7-24 24s10.7 24 24 24l464 0c13.3 0 24-10.7 24-24zM88 464c-13.3 0-24 10.7-24 24s10.7 24 24 24l80 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0zm176 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l288 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-288 0z"],
    "option": [640, 512, [], "e318", "M448 448c-9.7 0-18.9-4.4-25-12L176.6 128 32 128C14.3 128 0 113.7 0 96S14.3 64 32 64l160 0c9.7 0 18.9 4.4 25 12L463.4 384 608 384c17.7 0 32 14.3 32 32s-14.3 32-32 32l-160 0zm0-320c-17.7 0-32-14.3-32-32s14.3-32 32-32l160 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-160 0z"],
    "utility-pole": [512, 512, [], "e2c3", "M256 0c17.7 0 32 14.3 32 32l0 32 96 0 0-8c0-13.3 10.7-24 24-24s24 10.7 24 24l0 8 32 0 0-8c0-13.3 10.7-24 24-24s24 10.7 24 24l0 40c0 17.7-14.3 32-32 32L447.1 128 288 260.6 288 480c0 17.7-14.3 32-32 32s-32-14.3-32-32L224 260.6 64.9 128 32 128C14.3 128 0 113.7 0 96L0 56C0 42.7 10.7 32 24 32S48 42.7 48 56l0 8 32 0 0-8c0-13.3 10.7-24 24-24s24 10.7 24 24l0 8 96 0 0-32c0-17.7 14.3-32 32-32zM139.9 128l84.1 70.1 0-70.1-84.1 0zM288 198.1l84.1-70.1-84.1 0 0 70.1z"],
    "shrimp": [512, 512, [129424], "e448", "M72 32C32.2 32 0 64.2 0 104 0 141.9 29.3 172.9 66.4 175.8 77.6 257.2 147.4 320 232 320l56 0 0-192-216 0c-13.3 0-24-10.7-24-24S58.7 80 72 80l384 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L72 32zM224 456c0 13.3 10.7 24 24 24l72 0 0-72.2-64.1-22.4c-12.5-4.4-26.2 2.2-30.6 14.7s2.2 26.2 14.7 30.6l4.5 1.6C233 433.9 224 443.9 224 456zm128 23.3c36.4-3.3 69.5-17.6 96.1-39.6l-86.5-34.6c-3 1.8-6.2 3.2-9.6 4.3l0 69.9zM472.6 415c24.6-30.3 39.4-68.9 39.4-111 0-12.3-1.3-24.3-3.7-35.9L382.8 355.1c.8 3.4 1.2 7 1.2 10.6 0 4.6-.7 9-1.9 13.1L472.6 415zM336 128l-16 0 0 192 18.3 0c9.9 0 19.1 3.2 26.6 8.5l133.5-92.4C471.8 172.6 409.1 128 336 128zM168 192a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"],
    "alien": [448, 512, [128125], "f8f5", "M224 0C100.3 0 0 100.3 0 224 0 359.3 148.8 471.7 194.7 503.2 203.3 509.1 213.5 512 224 512s20.7-2.9 29.3-8.8C299.2 471.7 448 359.3 448 224 448 100.3 347.7 0 224 0zm32 306.3c0-45.4 36.8-82.3 82.3-82.3l32 0c7.6 0 13.7 6.1 13.7 13.7 0 45.4-36.8 82.3-82.3 82.3l-32 0c-7.6 0-13.7-6.1-13.7-13.7zM109.7 224c45.4 0 82.3 36.8 82.3 82.3 0 7.6-6.1 13.7-13.7 13.7l-32 0c-45.4 0-82.3-36.8-82.3-82.3 0-7.6 6.1-13.7 13.7-13.7l32 0z"],
    "skeleton": [512, 512, [], "f620", "M256 0c17.7 0 32 14.3 32 32l0 32 128 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-128 0 0 48 192 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-192 0 0 48 96 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-96 0 0 48 80 0c44.2 0 80 35.8 80 80 0 17.7-14.3 32-32 32s-32-14.3-32-32c0-8.8-7.2-16-16-16l-224 0c-8.8 0-16 7.2-16 16 0 17.7-14.3 32-32 32s-32-14.3-32-32c0-44.2 35.8-80 80-80l80 0 0-48-96 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l96 0 0-48-192 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l192 0 0-48-128 0c-17.7 0-32-14.3-32-32S78.3 64 96 64l128 0 0-32c0-17.7 14.3-32 32-32z"],
    "tire-pressure-warning": [512, 512, [], "f633", "M384 32c0-17.7 14.3-32 32-32s32 14.3 32 32l0 14.5c0 24.1 3.9 48 11.5 70.8l2.5 7.4c4.8 14.4 11.5 28.6 19.3 44.4 17.5 35.6 33.4 82.6 27.5 136.2-5.3 48.6-28.1 99-76.8 148.7l0 42c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-16-32 0 0 16c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-16-32 0 0 16c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-16-32 0 0 16c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-42c-48.7-49.7-71.4-100.1-76.8-148.7-5.9-53.6 9.9-100.6 27.5-136.2 7.8-15.8 14.5-30 19.3-44.4l2.5-7.4C60.1 94.5 64 70.5 64 46.5L64 32C64 14.3 78.3 0 96 0s32 14.3 32 32l0 14.5c0 31-5 61.7-14.8 91.1l-2.5 7.4c-6.3 19-14.8 36.6-22.6 52.5-14.7 29.7-25.3 64-21.3 100.9 3.7 34 20.4 74.1 65.7 117.7l246.8 0c45.3-43.6 62-83.7 65.7-117.7 4.1-36.9-6.6-71.1-21.3-100.9-7.8-15.8-16.3-33.5-22.6-52.5l-2.5-7.4C389 108.2 384 77.4 384 46.5L384 32zM280 128l0 112c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-112c0-13.3 10.7-24 24-24s24 10.7 24 24zM256 293.3a26.7 26.7 0 1 1 0 53.3 26.7 26.7 0 1 1 0-53.3z"],
    "nose": [448, 512, [], "e5bd", "M159.9 0L96 0C78.3 0 64 14.3 64 32l0 215.3c15.2-4.8 31.3-7.3 48-7.3l24 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-24 0c-61.9 0-112 50.1-112 112 0 56.4 41.7 103.1 96 110.9 .6-43.7 36.2-78.9 80-78.9 44.2 0 80 35.8 80 80l83.7 0c59.8 0 108.3-48.5 108.3-108.3 0-23.2-7.4-45.7-21.2-64.4L185.6 13c-6-8.2-15.6-13-25.7-13z"],
    "sign-posts-wrench": [640, 512, [], "e626", "M96 64l0-16c0-17.7 14.3-32 32-32s32 14.3 32 32l0 16 256 0 0-16c0-17.7 14.3-32 32-32s32 14.3 32 32l0 16c35.3 0 64 28.7 64 64l0 50.9c-10.4-1.9-21.1-2.9-32-2.9-97.2 0-176 78.8-176 176 0 35.4 10.5 68.4 28.5 96l-204.5 0 0 32c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-32c-35.3 0-64-28.7-64-64l0-256c0-35.3 28.7-64 64-64zM448 241.1c7.4-4.3 16 1.5 16 10l0 84.9c0 26.5 21.5 48 48 48s48-21.5 48-48l0-84.9c0-8.5 8.6-14.3 16-10 38.3 22.1 64 63.5 64 110.9s-25.7 88.7-64 110.9l0 45.1c0 19.9-16.1 36-36 36l-56 0c-19.9 0-36-16.1-36-36l0-45.1c-38.3-22.1-64-63.5-64-110.9s25.7-88.8 64-110.9z"],
    "tenge-sign": [384, 512, [8376, "tenge"], "f7d7", "M0 56C0 42.7 10.7 32 24 32l336 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 80C10.7 80 0 69.3 0 56zM0 160c0-17.7 14.3-32 32-32l320 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-128 0 0 256c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-256-128 0c-17.7 0-32-14.3-32-32z"],
    "face-scream": [576, 512, [], "e38b", "M539.3 305.3c3.1-15.9 4.7-32.4 4.7-49.3 0-141.4-114.6-256-256-256S32 114.6 32 256c0 16.9 1.6 33.3 4.7 49.3 5.2-.8 10.6-1.3 16-1.3 48 0 89.4 33.9 98.8 81l19.8 98.9C206.3 501.9 246 512 288 512s81.7-10.1 116.7-28.1L424.5 385c9.4-47.1 50.8-81 98.8-81 5.4 0 10.8 .4 16 1.3zM288 320c26.5 0 48 21.5 48 48l0 32c0 26.5-21.5 48-48 48s-48-21.5-48-48l0-32c0-26.5 21.5-48 48-48zm-46.6-77c-22.5 36.9-62.8 54.7-90.1 39.8s-31.1-56.8-8.7-93.7 62.8-54.7 90.1-39.8 31.1 56.9 8.7 93.7zm183.3 39.8c-27.3 14.9-67.6-2.9-90.1-39.8s-18.6-78.8 8.7-93.7 67.6 2.9 90.1 39.8 18.6 78.8-8.7 93.7zM0 404.8l0 107.2 128 0-23.5-117.6C99.5 369.8 77.9 352 52.8 352 23.6 352 0 375.6 0 404.8zM523.2 352c-25.1 0-46.8 17.8-51.7 42.4L448 512 576 512 576 404.8c0-29.1-23.6-52.8-52.8-52.8z"],
    "house-chimney-medical": [512, 512, ["clinic-medical"], "f7f2", "M234.2 8.6c12.3-11.4 31.3-11.4 43.5 0L368 92.3 368 80c0-17.7 14.3-32 32-32l32 0c17.7 0 32 14.3 32 32l0 101.5 37.8 35.1c9.6 9 12.8 22.9 8 35.1S493.2 272 480 272l-16 0 0 176c0 35.3-28.7 64-64 64l-288 0c-35.3 0-64-28.7-64-64l0-176-16 0c-13.2 0-25-8.1-29.8-20.3s-1.6-26.2 8-35.1l224-208zM224 248l0 40-40 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l40 0 0 40c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-40 40 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-40 0 0-40c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16z"],
    "square-arrow-left": [448, 512, ["arrow-square-left"], "f33a", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm39 207l80-80c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-39 39 150.1 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-150.1 0 39 39c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-80-80c-9.4-9.4-9.4-24.6 0-33.9z"],
    "circle-location-arrow": [512, 512, ["location-circle"], "f602", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM358.2 182.7l-84 196c-3.5 8.1-11.4 13.3-20.2 13.3-1.4 0-2.9-.1-4.4-.4-10.2-2.1-17.6-11.2-17.6-21.6l0-90-90 0c-10.4 0-19.5-7.4-21.5-17.6-2.1-10.2 3.3-20.5 12.9-24.6l196-84c8.5-3.5 18-1.7 24.2 4.7 6.4 6.3 8.2 15.9 4.7 24.2z"],
    "users-slash": [640, 512, [], "e073", "M73-24.9c-9.4-9.4-24.6-9.4-33.9 0S29.7-.3 39 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9L321.8 224c56.6-1 102.2-47.2 102.2-104 0-57.4-46.6-104-104-104-56.8 0-103 45.6-104 102.2L73-24.9zM512 288c-17.2 0-33.7 3.4-48.7 9.6l170 170c4.2-5.4 6.7-12.2 6.7-19.6l0-32c0-70.7-57.3-128-128-128zM59.9 97.7c-21.5 12.5-35.9 35.7-35.9 62.3 0 39.8 32.2 72 72 72 26.6 0 49.8-14.4 62.3-35.9L59.9 97.7zM250.2 288C196.8 313.9 160 368.7 160 432l0 16c0 17.7 14.3 32 32 32l250.2 0-192-192zM128 288C57.3 288 0 345.3 0 416l0 32c0 17.7 14.3 32 32 32l86.7 0c-4.3-9.8-6.7-20.6-6.7-32l0-16c0-53.2 20-101.8 52.9-138.6-11.7-3.5-24.1-5.4-36.9-5.4zM616 160a72 72 0 1 0 -144 0 72 72 0 1 0 144 0z"],
    "traffic-cone": [512, 512, [], "f636", "M173.7 128l38.6-98.2C219.4 11.8 236.7 0 256 0s36.6 11.8 43.7 29.8l38.6 98.2-164.6 0zm-25.1 64l214.9 0 37.7 96-290.3 0 37.7-96zM48 448l37.7-96 340.6 0 37.7 96 16 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 512c-17.7 0-32-14.3-32-32s14.3-32 32-32l16 0z"],
    "star-sharp-half-stroke": [512, 512, ["star-sharp-half-alt"], "e28d", "M233.1 16.7C236.3 6.8 245.6 0 256 0s19.7 6.8 22.9 16.7l5.2 16.2 1.3 4 .1 .3 44.2 138.8 158.5 0c10.3 0 19.4 6.5 22.7 16.2s.1 20.4-8 26.7l-14.7 11.5-2 1.5-.1 .1-114 88.7 44.4 139.5 .1 .4c.4 1.1 2.5 7.8 6.4 20.2 3.2 10-.5 21-9.1 27s-20.2 5.7-28.5-.7c-10.2-8-15.8-12.3-16.7-13l-.3-.3-112.2-87.3-129.3 100.5c-8.3 6.5-19.8 6.8-28.5 .7s-12.3-16.9-9.1-27L140.1 320.7 9.3 218.9c-8.1-6.3-11.3-17-8-26.7S13.7 176 24 176l158.5 0 50.7-159.3zM256 350.4c12.1 0 24.3 3.9 34.4 11.8l47.9 37.2-19.7-61.8c-7.1-22.4 .5-46.8 19-61.2l57.2-44.5-65.2 0c-24.4 0-46-15.8-53.4-39l-20.2-63.4 0 220.9z"],
    "h1": [512, 512, [], "f313", "M448 96c0-11.1-5.7-21.4-15.2-27.2s-21.2-6.4-31.1-1.4l-64 32c-15.8 7.9-22.2 27.1-14.3 42.9s27.1 22.2 42.9 14.3l17.7-8.8 0 236.2-32 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l128 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0 0-288zM64 96c0-17.7-14.3-32-32-32S0 78.3 0 96L0 416c0 17.7 14.3 32 32 32s32-14.3 32-32l0-128 128 0 0 128c0 17.7 14.3 32 32 32s32-14.3 32-32l0-320c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 128-128 0 0-128z"],
    "tamale": [320, 512, [129748], "e451", "M26.3-1.9C51.2-15.6 94.8-32 160.4-32S269.5-15.6 294.4-1.9c17.5 9.6 24.4 29.5 21.7 49.3l-19.3 144.7-68.4 0 15.7-125.5c1.4-11-6.4-21-17.4-22.3s-21 6.4-22.3 17.4l-16.3 130.5-55.7 0-16.3-130.5c-1.4-11-11.4-18.7-22.3-17.4S75.1 55.5 76.5 66.5L92.2 192 23.8 192 4.5 47.3C1.9 27.6 8.8 7.6 26.3-1.9zM256.4 320l40.5 0 19.3 144.6c2.6 19.8-4.3 39.7-21.7 49.3-24.9 13.6-68.5 30.1-134.1 30.1S51.2 527.6 26.3 513.9C8.8 504.4 1.9 484.4 4.5 464.6L23.8 320 64.4 320c0 18.2 7.8 35.9 21.8 48.2l-9.7 77.4c-1.4 11 6.4 21 17.4 22.3s21-6.4 22.3-17.4l8.3-66.6c12.6 .7 25-2.3 35.8-8.5 10.8 6.2 23.3 9.2 35.8 8.5l8.3 66.6c1.4 11 11.4 18.7 22.3 17.4s18.7-11.4 17.4-22.3l-9.7-77.4c14-12.2 21.8-29.9 21.8-48.2zM8.4 256c0-13.3 10.7-24 24-24l256 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-89.2 0 14.6 29.3c5.9 11.9 1.1 26.3-10.7 32.2s-26.3 1.1-32.2-10.7l-10.5-21.1-10.5 21.1c-5.9 11.9-20.3 16.7-32.2 10.7s-16.7-20.3-10.7-32.2l14.6-29.3-89.2 0c-13.3 0-24-10.7-24-24z"],
    "route-highway": [448, 512, [], "f61a", "M240.5 4.6c-10.1-6.1-22.8-6.1-32.9 0l-4.7 2.8c-37.5 22.5-84 24.3-123.1 4.7l-1.4-.7c-15.2-7.6-33.7-2-42.1 12.7l-32 56c-5.3 9.3-5.6 20.6-.8 30.2l16.2 32.5c8.1 16.3 12.4 34.2 12.4 52.5 0 14.9-2.8 29.7-8.4 43.6L9.3 274.5C3.2 289.9 0 306.4 0 323 0 372.5 28 417.8 72.2 439.9l137.4 68.7c9 4.5 19.6 4.5 28.6 0l137.4-68.7c44.3-22.1 72.2-67.4 72.2-116.9 0-16.6-3.2-33.1-9.3-48.5l-14.3-35.7c-5.5-13.9-8.4-28.6-8.4-43.6 0-18.2 4.2-36.2 12.4-52.5l16.2-32.5c4.8-9.6 4.5-20.9-.8-30.2l-32-56c-8.4-14.7-26.9-20.3-42.1-12.7l-1.4 .7c-39.1 19.6-85.6 17.8-123.1-4.7l-4.7-2.8zM96 192L352 192c0 1.1 0 2.2 0 3.2 0 23.1 4.4 45.9 13 67.3l14.3 35.7c3.2 7.9 4.8 16.3 4.8 24.8 0 25.3-14.3 48.4-36.9 59.7L224 444.2 100.9 382.7c-22.6-11.3-36.9-34.4-36.9-59.7 0-8.5 1.6-16.9 4.8-24.8L83 262.6c8.6-21.4 13-44.3 13-67.3 0-1.1 0-2.2 0-3.2z"],
    "paper-plane": [576, 512, [61913], "f1d8", "M536.4-26.3c9.8-3.5 20.6-1 28 6.3s9.8 18.2 6.3 28l-178 496.9c-5 13.9-18.1 23.1-32.8 23.1-14.2 0-27-8.6-32.3-21.7l-64.2-158c-4.5-11-2.5-23.6 5.2-32.6l94.5-112.4c5.1-6.1 4.7-15-.9-20.6s-14.6-6-20.6-.9L229.2 276.1c-9.1 7.6-21.6 9.6-32.6 5.2L38.1 216.8c-13.1-5.3-21.7-18.1-21.7-32.3 0-14.7 9.2-27.8 23.1-32.8l496.9-178z"],
    "object-intersect": [512, 512, [], "e49d", "M288 64l0 96-64 0c-35.3 0-64 28.7-64 64l0 64-96 0 0-224 224 0zM64 352l96 0 0 96c0 35.3 28.7 64 64 64l224 0c35.3 0 64-28.7 64-64l0-224c0-35.3-28.7-64-64-64l-96 0 0-96c0-35.3-28.7-64-64-64L64 0C28.7 0 0 28.7 0 64L0 288c0 35.3 28.7 64 64 64zM448 224l0 224-224 0 0-96 64 0c35.3 0 64-28.7 64-64l0-64 96 0z"],
    "book-atlas": [448, 512, ["atlas"], "f558", "M96 512l320 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l0-66.7c18.6-6.6 32-24.4 32-45.3l0-288c0-26.5-21.5-48-48-48L96 0C43 0 0 43 0 96L0 416c0 53 43 96 96 96zM64 416c0-17.7 14.3-32 32-32l256 0 0 64-256 0c-17.7 0-32-14.3-32-32zM310.6 208L279 208c-1.4 23.1-6 44.2-12.6 61.2 22.7-12.5 39.4-34.8 44.2-61.2zm-173.1 0c4.8 26.4 21.5 48.7 44.2 61.2-6.7-17-11.2-38-12.6-61.2l-31.6 0zm76.4 55c4.5 9.6 8.2 13.8 10.2 15.5 2-1.7 5.7-5.8 10.2-15.5 6.2-13.4 11.1-32.5 12.7-55l-45.8 0c1.6 22.5 6.5 41.6 12.7 55zm-12.7-87l45.8 0c-1.6-22.5-6.5-41.6-12.7-55-4.5-9.6-8.2-13.8-10.2-15.5-2 1.7-5.7 5.8-10.2 15.5-6.2 13.4-11.1 32.5-12.7 55zm109.5 0c-4.8-26.4-21.5-48.7-44.2-61.2 6.7 17 11.2 38 12.6 61.2l31.6 0zM169 176c1.4-23.1 6-44.2 12.6-61.2-22.7 12.5-39.4 34.8-44.2 61.2l31.6 0zM96 192a128 128 0 1 1 256 0 128 128 0 1 1 -256 0z"],
    "table": [448, 512, [], "f0ce", "M256 160l0 96 128 0 0-96-128 0zm-64 0l-128 0 0 96 128 0 0-96zM0 320L0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64l0-96zm384 0l-128 0 0 96 128 0 0-96zM192 416l0-96-128 0 0 96 128 0z"],
    "circle-sort": [512, 512, ["sort-circle"], "e030", "M0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zM239 103l-80 80c-6.9 6.9-8.9 17.2-5.2 26.2S166.3 224 176 224l160 0c9.7 0 18.5-5.8 22.2-14.8s1.7-19.3-5.2-26.2l-80-80c-9.4-9.4-24.6-9.4-33.9 0zM239 409c9.4 9.4 24.6 9.4 33.9 0l80-80c6.9-6.9 8.9-17.2 5.2-26.2S345.7 288 336 288l-160 0c-9.7 0-18.5 5.8-22.2 14.8s-1.7 19.3 5.2 26.2l80 80z"],
    "heart": [512, 512, [128153, 128154, 128155, 128156, 128420, 129293, 129294, 129505, 9829, 10084, 61578], "f004", "M241 87.1l15 20.7 15-20.7C296 52.5 336.2 32 378.9 32 452.4 32 512 91.6 512 165.1l0 2.6c0 112.2-139.9 242.5-212.9 298.2-12.4 9.4-27.6 14.1-43.1 14.1s-30.8-4.6-43.1-14.1C139.9 410.2 0 279.9 0 167.7l0-2.6C0 91.6 59.6 32 133.1 32 175.8 32 216 52.5 241 87.1z"],
    "scythe": [576, 512, [], "f710", "M469 0L352 0c-237.2 0-337 151.1-350.4 173.3-1.1 1.8-1.6 3.8-1.6 6 0 7 5.7 12.7 12.7 12.7L427.9 192 465.8 15.2 469 0zM442.9 352L416.7 473.3c-3.7 17.3 7.3 34.3 24.6 38s34.3-7.3 38-24.6L574 48.4C579.4 23.5 560.4 0 534.9 0L519 0 456.7 288 352 288c-17.7 0-32 14.3-32 32s14.3 32 32 32l90.9 0z"],
    "circle-chevron-up": [512, 512, ["chevron-circle-up"], "f139", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM377 271c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-87-87-87 87c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9L239 167c9.4-9.4 24.6-9.4 33.9 0L377 271z"],
    "apostrophe": [192, 512, [], "27", "M72 352c66.3 0 120-53.7 120-120l0-136c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96l0 64c0 35.3 28.7 64 64 64l64 0 0 8c0 30.9-25.1 56-56 56l-8 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l8 0z"],
    "battery-half": [640, 512, ["battery-3"], "f242", "M528 128c8.8 0 16 7.2 16 16l0 224c0 8.8-7.2 16-16 16l-416 0c-8.8 0-16-7.2-16-16l0-224c0-8.8 7.2-16 16-16l416 0zM112 64c-44.2 0-80 35.8-80 80l0 224c0 44.2 35.8 80 80 80l416 0c44.2 0 80-35.8 80-80l0-48c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l0-48c0-44.2-35.8-80-80-80L112 64zm56 112c-13.3 0-24 10.7-24 24l0 112c0 13.3 10.7 24 24 24l144 0c13.3 0 24-10.7 24-24l0-112c0-13.3-10.7-24-24-24l-144 0z"],
    "font-awesome": [512, 512, [62501, 62694, "font-awesome-flag", "font-awesome-logo-full"], "f2b4", "M91.7 96C106.3 86.8 116 70.5 116 52 116 23.3 92.7 0 64 0S12 23.3 12 52c0 16.7 7.8 31.5 20 41l0 419 64 0 0-64 373.6 0c14.6 0 26.4-11.8 26.4-26.4 0-3.7-.8-7.3-2.3-10.7L432 272 493.7 133.1c1.5-3.4 2.3-7 2.3-10.7 0-14.6-11.8-26.4-26.4-26.4L91.7 96z"],
    "handcuffs": [576, 512, [], "e4f8", "M320-32c0-17.7-14.3-32-32-32s-32 14.3-32 32 14.3 32 32 32 32-14.3 32-32zM192 64a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM152 96c-13.3 0-24 10.7-24 24l0 16c0 1 .1 1.9 .2 2.9-74.7 26.3-128.2 97.5-128.2 181.1 0 106 86 192 192 192s192-86 192-192c0-83.7-53.5-154.8-128.2-181.1 .1-.9 .2-1.9 .2-2.9l0-16c0-13.3-10.7-24-24-24l-80 0zM64 320a128 128 0 1 1 256 0 128 128 0 1 1 -256 0zm448 0c0 66.9-51.3 121.8-116.6 127.5-14.3 22.8-32.4 43.1-53.4 59.9 13.5 3 27.6 4.6 42 4.6 106 0 192-86 192-192 0-83.7-53.5-154.8-128.2-181.1 .1-.9 .2-1.9 .2-2.9l0-16c0-13.3-10.7-24-24-24l-80 0c-12.3 0-22.4 9.2-23.8 21.1 30.3 19.2 56.1 45 75.2 75.4 65.4 5.8 116.6 60.6 116.6 127.5zM384 64a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "square-bangladeshi-taka": [448, 512, [], "e744", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm40.5 115.3c2.6-13 15.2-21.4 28.2-18.8l10.6 2.1c28.3 5.7 48.7 30.5 48.7 59.4l0 18 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0 0 83.4c0 6.9 5.6 12.6 12.6 12.6l24 0c37.2 0 67.4-30.2 67.4-67.4l0-16c0-6.9-5.6-12.6-12.6-12.6l-3.4 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l3.4 0c33.5 0 60.6 27.1 60.6 60.6l0 16C344 332.3 292.3 384 228.6 384l-24 0c-33.5 0-60.6-27.1-60.6-60.6l0-83.4-13.7 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l13.7 0 0-18c0-6-4.2-11.2-10.1-12.3l-10.6-2.1c-13-2.6-21.4-15.2-18.8-28.2z"],
    "hat-cowboy-side": [640, 512, [], "f8c1", "M640 388.3c0 16.9-7.1 32.2-18.4 43.1l-35-23.3-292.7-195.1c-36.1-24.1-78.6-36.9-122-36.9l-3.9 0c-2.7 0-5.4 0-8 .1l22.2-100c5.7-25.8 28.6-44.1 55-44.1 12.2 0 24.1 4 33.8 11.3l4.7 3.5c26.3 19.7 62.4 19.7 88.6 0l4.7-3.5c9.8-7.3 21.6-11.3 33.8-11.3 26.4 0 49.3 18.3 55 44.1l33 148.5C574.5 232.3 640 302.6 640 388.3zM171.9 224c33.9 0 67.1 10 95.4 28.9L560 448 56 448c-30.9 0-56-25.1-56-56 0-92.8 75.2-168 168-168l3.9 0z"],
    "sausage": [512, 512, [], "f820", "M320 160c0-42 26.9-77.7 64.5-90.7L369.2 27.4c-.8-2.2-1.2-4.6-1.2-7 0-11.3 9.1-20.4 20.4-20.4l55.2 0c11.3 0 20.4 9.1 20.4 20.4 0 2.4-.4 4.7-1.2 7L447.5 69.3c37.5 13 64.5 48.7 64.5 90.7 0 194.4-157.6 352-352 352-42 0-77.7-26.9-90.7-64.5L27.4 462.8c-2.2 .8-4.6 1.2-7 1.2-11.3 0-20.4-9.1-20.4-20.4l0-55.2c0-11.3 9.1-20.4 20.4-20.4 2.4 0 4.7 .4 7 1.2l41.9 15.2c13-37.5 48.7-64.5 90.7-64.5 88.4 0 160-71.6 160-160zm92 8c0-11-9-20-20-20s-20 9-20 20c0 112.7-91.3 204-204 204-11 0-20 9-20 20s9 20 20 20c134.8 0 244-109.2 244-244z"],
    "chevrons-down": [448, 512, ["chevron-double-down"], "f322", "M246.6 470.6c-12.5 12.5-32.8 12.5-45.3 0l-192-192c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0L224 402.7 393.4 233.4c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3l-192 192zm192-384l-192 192c-12.5 12.5-32.8 12.5-45.3 0L9.4 86.6C-3.1 74.1-3.1 53.9 9.4 41.4s32.8-12.5 45.3 0L224 210.7 393.4 41.4c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3z"],
    "industry": [512, 512, [], "f275", "M32 32C14.3 32 0 46.3 0 64L0 432c0 26.5 21.5 48 48 48l416 0c26.5 0 48-21.5 48-48l0-279.8c0-18.2-19.4-29.7-35.4-21.1l-156.6 84.3 0-63.2c0-18.2-19.4-29.7-35.4-21.1L128 215.4 128 64c0-17.7-14.3-32-32-32L32 32z"],
    "people-dress-simple": [512, 512, [], "e218", "M128.1 128a64 64 0 1 0 0-128 64 64 0 1 0 0 128zm0 32c-37.9 0-71.2 25.1-81.6 61.5L11.8 343.2C5.9 363.7 21.3 384 42.5 384l21.6 0 0 80c0 26.5 21.5 48 48 48l32 0c26.5 0 48-21.5 48-48l0-80 21.6 0c21.3 0 36.6-20.3 30.8-40.8L209.7 221.5C199.3 185.1 166 160 128.1 160zm256-32a64 64 0 1 0 0-128 64 64 0 1 0 0 128zm0 32c-37.9 0-71.2 25.1-81.6 61.5L267.8 343.2c-5.8 20.4 9.5 40.8 30.8 40.8l21.6 0 0 80c0 26.5 21.5 48 48 48l32 0c26.5 0 48-21.5 48-48l0-80 21.6 0c21.3 0 36.6-20.3 30.8-40.8L465.7 221.5C455.3 185.1 422 160 384.1 160z"],
    "lines-leaning": [384, 512, [], "e51e", "M190.4 74.1c5.6-16.8-3.5-34.9-20.2-40.5s-34.9 3.5-40.5 20.2l-128 384c-5.6 16.8 3.5 34.9 20.2 40.5s34.9-3.5 40.5-20.2l128-384zm70.9-41.7c-17.4-2.9-33.9 8.9-36.8 26.3l-64 384c-2.9 17.4 8.9 33.9 26.3 36.8s33.9-8.9 36.8-26.3l64-384c2.9-17.4-8.9-33.9-26.3-36.8zM352 32c-17.7 0-32 14.3-32 32l0 384c0 17.7 14.3 32 32 32s32-14.3 32-32l0-384c0-17.7-14.3-32-32-32z"],
    "passport": [384, 512, [], "f5ab", "M0 64C0 28.7 28.7 0 64 0L320 0c35.3 0 64 28.7 64 64l0 384c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zM96 408c0 13.3 10.7 24 24 24l144 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-144 0c-13.3 0-24 10.7-24 24zM278.6 208c-4.8 26.4-21.5 48.7-44.2 61.2 6.7-17 11.2-38 12.6-61.2l31.6 0zm-173.1 0l31.6 0c1.4 23.1 6 44.2 12.6 61.2-22.7-12.5-39.4-34.8-44.2-61.2zm76.4 55c-6.2-13.4-11.1-32.5-12.7-55l45.8 0c-1.6 22.5-6.5 41.6-12.7 55-4.5 9.6-8.2 13.8-10.2 15.5-2-1.7-5.7-5.8-10.2-15.5zm0-142c4.5-9.6 8.2-13.8 10.2-15.5 2 1.7 5.7 5.8 10.2 15.5 6.2 13.4 11.1 32.5 12.7 55l-45.8 0c1.6-22.5 6.5-41.6 12.7-55zm96.7 55L247 176c-1.4-23.1-6-44.2-12.6-61.2 22.7 12.5 39.4 34.8 44.2 61.2zM137 176l-31.6 0c4.8-26.4 21.5-48.7 44.2-61.2-6.7 17-11.2 38-12.6 61.2zm183 16a128 128 0 1 0 -256 0 128 128 0 1 0 256 0z"],
    "infinity": [640, 512, [8734, 9854], "f534", "M0 256c0-88.4 71.6-160 160-160 50.4 0 97.8 23.7 128 64l32 42.7 32-42.7c30.2-40.3 77.6-64 128-64 88.4 0 160 71.6 160 160S568.4 416 480 416c-50.4 0-97.8-23.7-128-64l-32-42.7-32 42.7c-30.2 40.3-77.6 64-128 64-88.4 0-160-71.6-160-160zm280 0l-43.2-57.6c-18.1-24.2-46.6-38.4-76.8-38.4-53 0-96 43-96 96s43 96 96 96c30.2 0 58.7-14.2 76.8-38.4L280 256zm80 0l43.2 57.6c18.1 24.2 46.6 38.4 76.8 38.4 53 0 96-43 96-96s-43-96-96-96c-30.2 0-58.7 14.2-76.8 38.4L360 256z"],
    "hand-heart": [640, 512, [], "f4bc", "M549.1 304c41.4 0 74.9 33.5 74.9 74.9l0 2.5c0 64.4-82 133.4-122.2 163.3-13 9.7-30.5 9.7-43.5 0-40.2-30-122.2-98.9-122.2-163.3l0-2.5c0-41.3 33.5-74.9 74.9-74.9 24 0 46.6 11.5 60.7 31l8.4 11.7 8.4-11.7c14.1-19.5 36.7-31 60.7-31zM320 0c17.7 0 32 14.3 32 32l0 176c0 8.8 7.2 16 16 16s16-7.2 16-16l0-144c0-17.7 14.3-32 32-32s32 14.3 32 32l0 144c0 8.8 7.2 16 16 16s16-7.2 16-16l0-80c0-17.7 14.3-32 32-32s32 14.3 32 32l0 128.2c-23.1 1-45.3 8.3-64 21.1-20.1-13.7-44.2-21.3-69.1-21.3-67.9 0-122.9 55-122.9 122.9l0 2.5c0 50.7 31 95.5 58 126.2 1.3 1.5 2.7 2.9 4 4.4l-1.2 0c-59.6 0-116.9-22.9-160-64L76.4 341c-16-15.2-16.6-40.6-1.4-56.6s40.6-16.6 56.6-1.4l60.5 57.6c0-1.5-.1-3.1-.1-4.6l0-272c0-17.7 14.3-32 32-32s32 14.3 32 32l0 144c0 8.8 7.2 16 16 16s16-7.2 16-16l0-176c0-17.7 14.3-32 32-32z"],
    "clone": [512, 512, [], "f24d", "M288 448l-224 0 0-224 48 0 0-64-48 0c-35.3 0-64 28.7-64 64L0 448c0 35.3 28.7 64 64 64l224 0c35.3 0 64-28.7 64-64l0-48-64 0 0 48zm-64-96l224 0c35.3 0 64-28.7 64-64l0-224c0-35.3-28.7-64-64-64L224 0c-35.3 0-64 28.7-64 64l0 224c0 35.3 28.7 64 64 64z"],
    "forward": [576, 512, [9193], "f04e", "M371.7 43.1C360.1 32 343 28.9 328.3 35.2S304 56 304 72l0 136.3-172.3-165.1C120.1 32 103 28.9 88.3 35.2S64 56 64 72l0 368c0 16 9.6 30.5 24.3 36.8s31.8 3.2 43.4-7.9L304 303.7 304 440c0 16 9.6 30.5 24.3 36.8s31.8 3.2 43.4-7.9l192-184c7.9-7.5 12.3-18 12.3-28.9s-4.5-21.3-12.3-28.9l-192-184z"],
    "square-r": [448, 512, [], "e27c", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM168 144l80 0c39.8 0 72 32.2 72 72 0 28.9-17 53.8-41.6 65.3l30.2 50.3c6.8 11.4 3.1 26.1-8.2 32.9s-26.1 3.1-32.9-8.2l-41-68.3-34.4 0 0 56c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-176c0-13.3 10.7-24 24-24zm72 96l8 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-56 0 0 48 48 0z"],
    "period": [128, 512, [], "2e", "M128 416c0 35.3-28.7 64-64 64s-64-28.7-64-64 28.7-64 64-64 64 28.7 64 64z"],
    "m": [448, 512, [109], "4d", "M22.7 33.4c13.5-4.1 28.1 1.1 35.9 12.9L224 294.3 389.4 46.3c7.8-11.7 22.4-17 35.9-12.9S448 49.9 448 64l0 384c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-278.3-133.4 200.1c-5.9 8.9-15.9 14.2-26.6 14.2s-20.7-5.3-26.6-14.2L64 169.7 64 448c0 17.7-14.3 32-32 32S0 465.7 0 448L0 64C0 49.9 9.2 37.5 22.7 33.4z"],
    "money-check-pen": [640, 512, ["money-check-edit"], "f872", "M32.1 128c0-35.3 28.7-64 64-64l384 0c35.3 0 64 28.7 64 64l0 72.5c-21.2 3.3-41.6 13.1-57.9 29.4L315.8 400.2c-13.3 13.3-23 29.8-28.3 47.8L96.1 448c-35.3 0-64-28.7-64-64l0-256zm96 184c0 13.3 10.7 24 24 24l144 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-144 0c-13.3 0-24 10.7-24 24zm24-136c-13.3 0-24 10.7-24 24s10.7 24 24 24l272 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-272 0zM332.3 466.9c2.5-12.4 8.6-23.8 17.5-32.7l118.9-118.9 80 80-118.9 118.9c-8.9 8.9-20.3 15-32.7 17.5l-59.6 11.9c-.9 .2-1.9 .3-2.9 .3-8 0-14.6-6.5-14.6-14.6 0-1 .1-1.9 .3-2.9l11.9-59.6zm267.8-123l-28.8 28.8-80-80 28.8-28.8c22.1-22.1 57.9-22.1 80 0s22.1 57.9 0 80z"],
    "road-spikes": [640, 512, [], "e568", "M64 116.8c0-15.8 20.5-22 29.3-8.9l98.7 148 0-139.2c0-15.8 20.5-22 29.3-8.9l98.7 148 0-139.2c0-15.8 20.5-22 29.3-8.9l98.7 148 0-139.2c0-15.8 20.5-22 29.3-8.9L606.8 302.2c14.2 21.3-1.1 49.8-26.6 49.8L64 352 64 116.8zM32 384l576 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 448c-17.7 0-32-14.3-32-32s14.3-32 32-32z"],
    "fish-cooked": [576, 512, [], "f7fe", "M320 64c120 0 256 128 256 192S440 448 320 448c-74.8 0-155.9-49.8-206.3-102.8-6-6.3-15.8-7.2-22.5-1.7L26.1 396.4c-5.3 4.3-12.9 4.8-18.7 1.1s-8.6-10.7-6.9-17.4L30.5 259.9c.6-2.6 .6-5.2 0-7.8L.5 131.9c-1.6-6.5 .9-13.2 6.4-17s12.7-3.8 18.2 0l72 49.5c6.6 4.5 15.5 3.5 21.1-2.2 50.7-51.2 129.1-98.1 201.8-98.1zm1 79c-9.4-9.4-24.6-9.4-33.9 0l-64 64c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l64-64c9.4-9.4 9.4-24.6 0-33.9zm112 16c-9.4-9.4-24.6-9.4-33.9 0L239 319c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0L433 193c9.4-9.4 9.4-24.6 0-33.9zm16 112c-9.4-9.4-24.6-9.4-33.9 0l-64 64c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l64-64c9.4-9.4 9.4-24.6 0-33.9z"],
    "person-seat-reclined": [512, 512, [], "e21f", "M248 72a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zm42.2 248L266.5 201.5c-4.8-24.1-26-41.5-50.6-41.5-32.6 0-57 29.8-50.6 61.7l22.2 110.8c6 29.9 32.2 51.4 62.8 51.4l13.1 0c.4 0 .8 0 1.3 0l86.1 0c6.7 0 12.6 4.1 15 10.4L402 491.2c6 16.1 23.8 24.6 40.1 19.1l48-16c16.8-5.6 25.8-23.7 20.2-40.5s-23.7-25.8-40.5-20.2l-18.7 6.2-25.5-68c-11.7-31.2-41.6-51.9-74.9-51.9l-60.5 0zM95.2 184.7c-4-17.2-21.3-27.9-38.5-23.8s-27.9 21.3-23.8 38.5l46.6 198C93 455.1 144.6 496 204 496l84 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-84 0c-29.7 0-55.5-20.4-62.3-49.3l-46.6-198z"],
    "mountain": [512, 512, [127956], "f6fc", "M256.5 0c14.7 0 28.2 8.1 35.2 21l216 400c6.7 12.4 6.4 27.4-.8 39.5-7.2 12.1-20.3 19.5-34.3 19.5l-432 0c-14.1 0-27.1-7.4-34.3-19.5s-7.5-27.1-.8-39.5l216-400 2.9-4.6C231.7 6.2 243.6 0 256.5 0zM170.4 249.9l26.8 26.8c6.2 6.2 16.4 6.2 22.6 0l43.3-43.3c6-6 14.1-9.4 22.6-9.4l42.8 0-72.1-133.5-86.1 159.4z"],
    "circle-w": [512, 512, [], "e12c", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM175.2 161.7l26.6 97.6 31.4-98.6c3.2-10 12.4-16.7 22.9-16.7s19.7 6.8 22.9 16.7l31.4 98.6 26.6-97.6c3.5-12.8 16.7-20.3 29.5-16.8s20.3 16.7 16.8 29.5l-48 176c-2.8 10.3-12 17.5-22.7 17.7s-20.1-6.6-23.4-16.7L256 247.2 222.9 351.3c-3.2 10.1-12.7 16.9-23.4 16.7s-19.9-7.4-22.7-17.7l-48-176c-3.5-12.8 4.1-26 16.8-29.5s26 4.1 29.5 16.8z"],
    "chess": [512, 512, [], "f439", "M168 56l0 40-78.1 0c-14.3 0-25.9 11.6-25.9 25.9 0 4 .9 8 2.7 11.6l33.4 66.8c-11.4 1.8-20.2 11.7-20.2 23.7 0 13.3 10.7 24 24 24l5.6 0-13.6 136-56.2 70.3c-5 6.3-7.8 14.1-7.8 22.2 0 19.6 15.9 35.5 35.5 35.5l248.9 0c19.6 0 35.5-15.9 35.5-35.5 0-8.1-2.7-15.9-7.8-22.2L288 384 274.4 248 280 248c13.3 0 24-10.7 24-24 0-11.9-8.7-21.9-20.2-23.7l33.4-66.8c1.8-3.6 2.7-7.6 2.7-11.6 0-14.3-11.6-25.9-25.9-25.9l-78.1 0 0-40 16 0c13.3 0 24-10.7 24-24S245.3 8 232 8l-16 0 0-16c0-13.3-10.7-24-24-24S168-21.3 168-8l0 16-16 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l16 0zM325.8 279.6l8.5 85.5 47.4 59.2 4.2 5.7c9.2 13.7 14.1 29.9 14.1 46.5 0 12.7-2.8 24.8-7.9 35.5l83.1 0c20.3 0 36.8-16.5 36.8-36.8 0-7.3-2.2-14.4-6.2-20.4l-25.8-38.7 0-64 13.3-13.3c12-12 18.7-28.3 18.7-45.3L512 192c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 16-32 0 0-16c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 32c0 22.4-10.2 42.4-26.2 55.6z"],
    "temperature-three-quarters": [320, 512, ["temperature-3", "thermometer-3", "thermometer-three-quarters"], "f2c8", "M160 0C107 0 64 43 64 96l0 164.7C34.5 287 16 325.4 16 368 16 447.5 80.5 512 160 512s144-64.5 144-144c0-42.6-18.5-81-48-107.3L256 96c0-53-43-96-96-96zm64 368c0 35.3-28.7 64-64 64s-64-28.7-64-64c0-26.9 16.5-49.9 40-59.3L136 152c0-13.3 10.7-24 24-24s24 10.7 24 24l0 156.7c23.5 9.5 40 32.5 40 59.3z"],
    "b": [320, 512, [98], "42", "M32 32C14.3 32 0 46.3 0 64L0 448c0 17.7 14.3 32 32 32l160 0c70.7 0 128-57.3 128-128 0-46.5-24.8-87.3-62-109.7 18.7-22.3 30-51 30-82.3 0-70.7-57.3-128-128-128L32 32zM160 224l-96 0 0-128 96 0c35.3 0 64 28.7 64 64s-28.7 64-64 64zM64 288l128 0c35.3 0 64 28.7 64 64s-28.7 64-64 64l-128 0 0-128z"],
    "shield-virus": [512, 512, [], "e06c", "M253.4 2.9C249.2 1 244.7 0 240 0s-9.2 1-13.4 2.9L38.3 82.8c-22 9.3-38.4 31-38.3 57.2 .5 99.2 41.3 280.7 213.6 363.2 16.7 8 36.1 8 52.8 0 172.4-82.5 213.2-264 213.6-363.2 .1-26.2-16.3-47.9-38.3-57.2L253.4 2.9zM240 128c13.3 0 24 10.7 24 24 0 22.9 27.7 34.4 43.9 18.2 9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9c-16.2 16.2-4.7 43.9 18.2 43.9 13.3 0 24 10.7 24 24s-10.7 24-24 24c-22.9 0-34.4 27.7-18.2 43.9 9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0c-16.2-16.2-43.9-4.7-43.9 18.2 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-22.9-27.7-34.4-43.9-18.2-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9c16.2-16.2 4.7-43.9-18.2-43.9-13.3 0-24-10.7-24-24s10.7-24 24-24c22.9 0 34.4-27.7 18.2-43.9-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0c16.2 16.2 43.9 4.7 43.9-18.2 0-13.3 10.7-24 24-24zM208 264a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm88 40a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"],
    "triangle": [512, 512, [9650], "f2ec", "M291.2 21C284.2 8.1 270.7 0 256 0s-28.2 8.1-35.2 21L4.8 421c-6.7 12.4-6.4 27.4 .8 39.5S25.9 480 40 480l432 0c14.1 0 27.1-7.4 34.4-19.5s7.5-27.1 .8-39.5L291.2 21z"],
    "litecoin-sign": [384, 512, [], "e1d3", "M128 64c0-17.7-14.3-32-32-32S64 46.3 64 64l0 157.9-38.6 11c-12.7 3.6-20.1 16.9-16.5 29.7s16.9 20.1 29.7 16.5L64 271.8 64 448c0 17.7 14.3 32 32 32l256 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-224 0 0-162.5 134.6-38.5c12.7-3.6 20.1-16.9 16.5-29.7s-16.9-20.1-29.7-16.5L128 203.6 128 64z"],
    "dice-d6": [512, 512, [], "f6d1", "M224.4 8.3C244-2.8 268-2.8 287.6 8.3l176 99.7c20 11.4 32.4 32.6 32.4 55.7l0 197.4c0 23-12.4 44.3-32.4 55.7l-176 99.7c-19.6 11.1-43.6 11.1-63.1 0l-176-99.7C28.4 405.5 16 384.2 16 361.2l0-197.4c0-23 12.4-44.3 32.4-55.7l176-99.7zM102.6 155.6c-8.8-3.1-18.8 .3-23.8 8.6s-3.2 18.7 3.6 25l3.2 2.4 150.2 90.2 0 148.7c0 11 9 20 20 20 11 0 20-9 20-20l0-148.7 150.3-90.2c9.5-5.7 12.6-18 6.9-27.4s-18-12.5-27.4-6.9l-149.7 89.8-149.7-89.8-3.7-1.7z"],
    "grip-lines-vertical": [192, 512, [], "f7a5", "M64 64c0-17.7-14.3-32-32-32S0 46.3 0 64L0 448c0 17.7 14.3 32 32 32s32-14.3 32-32L64 64zm128 0c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 384c0 17.7 14.3 32 32 32s32-14.3 32-32l0-384z"],
    "toggle-large-off": [576, 512, [], "e5b0", "M192 384a128 128 0 1 1 0-256 128 128 0 1 1 0 256zm0 64l192 0c106 0 192-86 192-192S490 64 384 64L192 64C86 64 0 150 0 256S86 448 192 448zm143.1-64c30.4-34 48.9-78.8 48.9-128s-18.5-94-48.9-128l48.9 0c70.7 0 128 57.3 128 128S454.7 384 384 384l-48.9 0z"],
    "golf-ball-tee": [384, 512, ["golf-ball"], "f450", "M298.5 384.1c12.1 1.2 21.5 11.5 21.5 23.9s-9.4 22.6-21.5 23.9l-2.5 .1-80 0 0 88c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-88-80 0c-13.3 0-24-10.7-24-24 0-12.4 9.4-22.6 21.5-23.9l2.5-.1 208 0 2.5 .1zM192 0c106 0 192 86 192 192 0 57.4-25.2 108.8-65.1 144L65.1 336C25.2 300.8 0 249.4 0 192 0 86 86 0 192 0zm32 240c-7.7 0-14.2 5.5-15.7 12.8l-.6 6.4c-1.3 6.3-6.2 11.2-12.5 12.5l-6.4 .6c-7.3 1.5-12.8 8-12.8 15.7 0 8.8 7.2 16 16 16 26.5 0 48-21.5 48-48 0-8.8-7.2-16-16-16zm64-64c-7.7 0-14.2 5.5-15.7 12.8l-.6 6.4c-1.3 6.3-6.2 11.2-12.5 12.5l-6.4 .6c-7.3 1.5-12.8 8-12.8 15.7 0 8.8 7.2 16 16 16 26.5 0 48-21.5 48-48 0-8.8-7.2-16-16-16zm-80-16c-7.7 0-14.2 5.5-15.7 12.8l-.6 6.4c-1.3 6.3-6.2 11.2-12.5 12.5l-6.4 .6c-7.3 1.5-12.8 8-12.8 15.7 0 8.8 7.2 16 16 16 26.5 0 48-21.5 48-48 0-8.8-7.2-16-16-16z"],
    "hexagon": [576, 512, [11043], "f312", "M33.5 220.3c-12.7 22.2-12.7 49.4 0 71.5l96.2 168.1c12.8 22.4 36.7 36.2 62.5 36.2l191.6 0c25.8 0 49.7-13.8 62.5-36.2l96.2-168.1c12.7-22.2 12.7-49.4 0-71.5L446.3 52.2C433.5 29.8 409.6 16 383.8 16L192.2 16c-25.8 0-49.7 13.8-62.5 36.2L33.5 220.3z"],
    "kite": [640, 512, [129665], "f6f4", "M560 0c26.5 0 48 21.5 48 48l0 231.3c0 23.5-17 43.5-40.1 47.3L264.7 377.2 141.9 500c-7.7 7.7-18.1 12-29 12-22.6 0-41-18.3-41-41l0-179-53.2 26.6c-1.8 .9-3.8 1.4-5.8 1.4-7.1 0-12.9-5.8-12.9-12.9l0-70.1c0-7.1 5.8-12.9 12.9-12.9 2 0 4 .5 5.8 1.4L72 252 72 200c0-13.3-10.7-24-24-24l-24 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l24 0c39.8 0 72 32.2 72 72l0 52 53.3-26.6c1.8-.9 3.8-1.4 5.8-1.4 7.1 0 12.9 5.8 12.9 12.9l0 70.1c0 7.1-5.8 12.9-12.9 12.9-2 0-4-.5-5.8-1.4L120 292 120 454.1 230.8 343.3 281.3 40.1C285.2 17 305.2 0 328.7 0L560 0zM379 63.3c-7.8-5.1-18.3-4.3-25.2 2.6s-7.7 17.4-2.6 25.2l2.6 3.2 65.8 65.8-113.8 113.8c-7.8 7.8-7.8 20.5 0 28.3s20.5 7.8 28.3 0l113.8-113.8 65.8 65.8 3.2 2.6c7.8 5.1 18.3 4.3 25.2-2.6s7.7-17.4 2.6-25.2l-2.6-3.2-65.8-65.8 49.8-49.8c7.8-7.8 7.8-20.5 0-28.3s-20.5-7.8-28.3 0l-49.8 49.8-65.8-65.8-3.2-2.6z"],
    "share-all": [576, 512, [], "f367", "M243.8 18.4c-12 5-19.8 16.6-19.8 29.6l0 80-48 0c-97.2 0-176 78.8-176 176 0 113.3 81.5 163.9 100.2 174.1 2.5 1.4 5.3 1.9 8.1 1.9 10.9 0 19.7-8.9 19.7-19.7 0-7.5-4.3-14.4-9.8-19.5-9.4-8.8-22.2-26.4-22.2-56.7 0-53 43-96 96-96l32 0 0 80c0 12.9 7.8 24.6 19.8 29.6s25.7 2.2 34.9-6.9l160-160c12.5-12.5 12.5-32.8 0-45.3l-160-160c-9.2-9.2-22.9-11.9-34.9-6.9zm126.7 4.7c-9.4 9.4-9.4 24.6 0 33.9L521.4 208 370.4 358.9c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0L566 231.2c6.4-6 10-14.4 10-23.2s-3.6-17.2-10-23.2L404.4 23.1c-9.4-9.4-24.6-9.4-33.9 0z"],
    "chemex": [384, 512, [], "e830", "M362.9 294.6c7.7 10.6 .1 25.4-12.9 25.4l-24.2 0 15.3 21.1c27.8 38.3 46.8 86.1 29.3 130l-2.7 6.4c-.9 2.1-1.9 4.2-2.9 6.3l-1.8 3.4c-9.7 16.3-28.5 24.7-47.8 24.7l-246.3 0-7.7-.4c-16.5-1.9-31.7-10.2-40.1-24.3l-1.8-3.4c-1-2.1-2-4.2-2.9-6.3l-2.7-6.4c-16.4-41.2-.8-85.8 24.1-122.8l5.1-7.3 15.3-21.1-24.2 0c-13.1 0-20.6-14.8-12.9-25.4l36.8-50.6 90.5 0c7.6 16.5 24.2 28 43.6 28s36-11.5 43.6-28l90.5 0 36.8 50.6zM94.6 378.7c-23.9 32.9-26.6 56.2-21.6 68.7 .1 .2 .2 .4 .2 .6l237.4 0c.1-.2 .2-.4 .2-.6 5-12.5 2.4-35.8-21.6-68.7l-42.7-58.7-109.4 0-42.7 58.7zM351.5 .2c18.3 1.8 32.5 17.3 32.5 36 0 7.7-2.4 15.1-6.9 21.3l-51.3 70.5 24.1 0c13.1 0 20.6 14.8 12.9 25.4l-36.8 50.6-90.5 0c-7.6-16.5-24.2-28-43.6-28s-36 11.5-43.6 28l-90.5 0-36.8-50.6C13.4 142.8 21 128 34.1 128l24.1 0-51.2-70.5C2.4 51.3 0 43.9 0 36.2 0 16.2 16.2 0 36.2 0l311.6 0 3.7 .2zM137.3 128l109.4 0 46.5-64-202.4 0 46.5 64z"],
    "folder-open": [576, 512, [128194, 128449, 61717], "f07c", "M56 225.6L32.4 296.2 32.4 96c0-35.3 28.7-64 64-64l138.7 0c13.8 0 27.3 4.5 38.4 12.8l38.4 28.8c5.5 4.2 12.3 6.4 19.2 6.4l117.3 0c35.3 0 64 28.7 64 64l0 16-365.4 0c-41.3 0-78 26.4-91.1 65.6zM477.8 448L99 448c-32.8 0-55.9-32.1-45.5-63.2l48-144C108 221.2 126.4 208 147 208l378.8 0c32.8 0 55.9 32.1 45.5 63.2l-48 144c-6.5 19.6-24.9 32.8-45.5 32.8z"],
    "tick": [128, 512, [], "e32f", "M0 98.3L0 96C0 60.7 28.7 32 64 32s64 28.7 64 64l0 2.3c0 3.8-.3 7.6-1 11.4L101.5 256.5C98.3 274.7 82.5 288 64 288s-34.3-13.3-37.5-31.5L1 109.6c-.7-3.8-1-7.5-1-11.4z"],
    "face-drooling": [512, 512, [], "e372", "M256 512c28 0 55-4.5 80.2-12.8-.1-1-.2-2.1-.2-3.2l0-101.4c-10 5.8-20.7 10.5-32 14.1l0 31.3c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-24c-53.2 0-100.3-26-129.4-65.9-7.8-10.7-5.4-25.7 5.3-33.5s25.7-5.4 33.5 5.3c20.4 28 53.4 46.1 90.6 46.1s70.2-18.1 90.6-46.1c7.8-10.7 22.8-13.1 33.5-5.3s13.1 22.8 5.3 33.5c-.5 .6-.9 1.3-1.4 1.9l0 125.7C460.5 433.5 512 350.8 512 256 512 114.6 397.4 0 256 0S0 114.6 0 256 114.6 512 256 512zM96 216c0-48.6 39.4-88 88-88 13.3 0 24 10.7 24 24s-10.7 24-24 24c-22.1 0-40 17.9-40 40 0 13.3-10.7 24-24 24s-24-10.7-24-24zm232-88c48.6 0 88 39.4 88 88 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-22.1-17.9-40-40-40-13.3 0-24-10.7-24-24s10.7-24 24-24z"],
    "bullseye-arrow": [576, 512, [127919], "f648", "M386.7 64.2c-1.7-10.2 1.6-20.6 8.9-27.9l51.2-51.2C455-23 468.8-20.1 473-9.5L496 48 553.5 71c10.7 4.3 13.5 18 5.4 26.2l-51.2 51.2c-7.3 7.3-17.7 10.6-27.9 8.9L429.1 148.9 305 273c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l124.1-124.1-8.4-50.7zm86.4 140.6c22.1 3.3 44.5-2.8 61.8-16.6 5.9 21.6 9.1 44.3 9.1 67.8 0 141.4-114.6 256-256 256S32 397.4 32 256 146.6 0 288 0c23.5 0 46.2 3.2 67.8 9.1-13.8 17.3-19.9 39.7-16.6 61.8-16.3-4.5-33.4-6.9-51.2-6.9-106 0-192 86-192 192s86 192 192 192 192-86 192-192c0-17.7-2.4-34.9-6.9-51.2zM288 112c12.9 0 25.4 1.7 37.3 4.9l-63.5 63.5c-31.3 10.9-53.8 40.6-53.8 75.6 0 44.2 35.8 80 80 80 35 0 64.7-22.5 75.6-53.8l63.5-63.5c3.2 11.9 4.9 24.4 4.9 37.3 0 79.5-64.5 144-144 144s-144-64.5-144-144 64.5-144 144-144z"],
    "kaaba": [512, 512, [128331], "f66b", "M256 51.3L92.8 112.4 247.5 171.1c5.5 2.1 11.5 2.1 17 0L419.2 112.4 256 51.3zM0 129.3c0-20 12.4-37.9 31.1-44.9l208-78c10.9-4.1 22.8-4.1 33.7 0l208 78c18.7 7 31.1 24.9 31.1 44.9l0 36-253.2 96c-1.8 .7-3.8 .7-5.7 0l-253.2-96 0-36zm0 140l0-52.7 236.1 89.6c12.8 4.9 26.9 4.9 39.7 0l236.1-89.6 0 52.7-128 48.6 0 51.3 128-48.6 0 62.2c0 20-12.4 37.9-31.1 44.9l-208 78c-10.9 4.1-22.8 4.1-33.7 0l-208-78C12.4 420.7 0 402.7 0 382.7l0-62.2 128 48.6 0-51.3-128-48.6zM236.1 410.1c12.8 4.9 26.9 4.9 39.7 0l60.1-22.8 0-51.3-77.2 29.3c-1.8 .7-3.8 .7-5.7 0l-77.2-29.3 0 51.3 60.1 22.8z"],
    "hand-back-point-right": [512, 512, [], "e1a1", "M512 168c0-22.1-17.9-40-40-40l-280 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l55.7 0c-1.4-2-3-3.9-4.5-5.8L227.2 71C215 56.4 197 48 178 48L140 48c-38 0-74 16.9-98.3 46.1l-4.5 5.4C13.1 128.3 0 164.5 0 201.9L0 320c0 70.7 57.3 128 128 128l96 0c26.5 0 48-21.5 48-48 0-12.4-4.7-23.6-12.3-32.1 24.8-1.9 44.3-22.6 44.3-47.9 0-12.4-4.7-23.6-12.3-32.1 24.8-1.9 44.3-22.6 44.3-47.9 0-12.3-4.6-23.5-12.2-32L472 208c22.1 0 40-17.9 40-40z"],
    "starfighter-twin-ion-engine": [512, 512, ["starfighter-alt"], "e038", "M64 64c0-17.7-14.3-32-32-32S0 46.3 0 64L0 448c0 17.7 14.3 32 32 32s32-14.3 32-32l0-149.3 42.4 14.1C129.3 373.1 187.6 416 256 416s126.7-42.9 149.6-103.2L448 298.7 448 448c0 17.7 14.3 32 32 32s32-14.3 32-32l0-384c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 149.3-42.4-14.1C382.7 138.9 324.4 96 256 96S129.3 138.9 106.4 199.2L64 213.3 64 64zm192 96a96 96 0 1 1 0 192 96 96 0 1 1 0-192zm0 152a56 56 0 1 0 0-112 56 56 0 1 0 0 112z"],
    "hand-holding": [576, 512, [], "f4bd", "M66.7 384l42.5-42.5c24-24 56.6-37.5 90.5-37.5L352 304c17.7 0 32 14.3 32 32s-14.3 32-32 32l-72 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l112.6 0 119.7-88.2c17.8-13.1 42.8-9.3 55.9 8.5s9.3 42.8-8.5 55.9L433.1 485.5c-23.4 17.2-51.6 26.5-80.7 26.5L32 512c-17.7 0-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32l34.7 0z"],
    "badge-sheriff": [512, 512, [], "f8a2", "M304.4 16c0 15.1-7 28.6-17.9 37.4l32.8 58.3c5.7 10.1 16.3 16.3 27.9 16.3l69.8 0c2.3-13.6 10.4-26.1 23.3-33.6 23-13.3 52.3-5.4 65.6 17.6s5.4 52.3-17.6 65.6c-13 7.5-27.9 8.2-40.9 3.4L411 239c-6.5 10.4-6.5 23.5 0 33.9l36.3 58.1c13-4.9 28-4.1 40.9 3.4 23 13.3 30.8 42.6 17.6 65.6s-42.6 30.8-65.6 17.6c-12.9-7.4-21-20-23.3-33.6l-69.8 0c-11.6 0-22.2 6.2-27.9 16.3l-32.8 58.3c10.9 8.8 17.9 22.3 17.9 37.4 0 26.5-21.5 48-48 48s-48-21.5-48-48c0-15.1 7-28.6 17.9-37.4l-32.8-58.3c-5.7-10.1-16.3-16.3-27.9-16.3l-69.8 0c-2.3 13.6-10.4 26.1-23.3 33.6-23 13.3-52.3 5.4-65.6-17.6s-5.4-52.3 17.6-65.6c13-7.5 27.9-8.2 40.9-3.4L101.8 273c6.5-10.4 6.5-23.5 0-33.9L65.4 180.9c-13 4.9-28 4.1-40.9-3.3-23-13.3-30.8-42.6-17.6-65.6S49.5 81.2 72.5 94.4c12.9 7.4 21 20 23.3 33.6l69.8 0c11.6 0 22.2-6.2 27.9-16.3l32.8-58.3c-10.9-8.8-17.9-22.3-17.9-37.4 0-26.5 21.5-48 48-48s48 21.5 48 48zm-48 304a64 64 0 1 0 -.7-128 64 64 0 1 0 .7 128z"],
    "rainbow-half": [512, 512, [], "e7ca", "M448 64c-212.1 0-384 171.9-384 384 0 17.7-14.3 32-32 32S0 465.7 0 448C0 200.6 200.6 0 448 0 465.7 0 480 14.3 480 32s-14.3 32-32 32zm0 128c-141.4 0-256 114.6-256 256 0 17.7-14.3 32-32 32s-32-14.3-32-32c0-176.7 143.3-320 320-320 17.7 0 32 14.3 32 32s-14.3 32-32 32zM320 448c0 17.7-14.3 32-32 32s-32-14.3-32-32c0-106 86-192 192-192 17.7 0 32 14.3 32 32s-14.3 32-32 32c-70.7 0-128 57.3-128 128z"],
    "comment-lines": [512, 512, [], "f4b0", "M256 480c141.4 0 256-107.5 256-240S397.4 0 256 0 0 107.5 0 240c0 54.3 19.2 104.3 51.6 144.5L2.8 476.8c-4.8 9-3.3 20 3.6 27.5s17.8 9.8 27.1 5.8l118.4-50.7C183.7 472.6 218.9 480 256 480zM152 176l208 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-208 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zm0 96l112 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-112 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"],
    "single-quote-right": [192, 512, [], "e81c", "M64 416c-17.7 0-32-14.3-32-32s14.3-32 32-32l8 0c30.9 0 56-25.1 56-56l0-8-64 0c-35.3 0-64-28.7-64-64l0-64c0-35.3 28.7-64 64-64l64 0c35.3 0 64 28.7 64 64l0 136c0 66.3-53.7 120-120 120l-8 0z"],
    "bottle-droplet": [320, 512, [], "e4c4", "M80 0c0-17.7 14.3-32 32-32l96 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l0 103.3c64.9 20.4 112 81 112 152.7l0 192c0 35.3-28.7 64-64 64L64 544c-35.3 0-64-28.7-64-64L0 288c0-71.6 47.1-132.3 112-152.7L112 32C94.3 32 80 17.7 80 0zm80 416c35.3 0 64-32.4 64-64 0-21.2-28.9-64.5-47.9-90.6-8.1-11.1-24.2-11.1-32.3 0-19 26.1-47.9 69.4-47.9 90.6 0 31.6 28.7 64 64 64z"],
    "face-explode": [512, 512, ["exploding-head"], "e2fe", "M64 64c0 35.3 28.7 64 64 64l16 0c26.5 0 48 21.5 48 48l0 16 64 16 64-16 0-16c0-26.5 21.5-48 48-48l16 0c35.3 0 64-28.7 64-64S419.3 0 384 0c-5.5 0-10.9 .7-16 2 0-.7 0-1.3 0-2 0-35.3-28.7-64-64-64-19.1 0-36.3 8.4-48 21.7-11.7-13.3-28.9-21.7-48-21.7-35.3 0-64 28.7-64 64 0 .7 0 1.4 0 2-5.1-1.3-10.5-2-16-2-35.3 0-64 28.7-64 64zM53.9 252.6L.9 235c-.6 6.9-.9 14-.9 21 0 141.4 114.6 256 256 256S512 397.4 512 256c0-7.1-.3-14.1-.9-21l-53 17.7c-6.6 2.2-13.7 2.2-20.2 0l-75.8-25.3c-6.6-2.2-13.7-2.2-20.2 0l-75.8 25.3c-6.6 2.2-13.7 2.2-20.2 0l-75.8-25.3c-6.6-2.2-13.7-2.2-20.2 0L74.1 252.6c-6.6 2.2-13.7 2.2-20.2 0zM176 304a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm128 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm-58.7 48l21.3 0c29.5 0 53.3 23.9 53.3 53.3 0 5.9-4.8 10.7-10.7 10.7l-106.7 0c-5.9 0-10.7-4.8-10.7-10.7 0-29.5 23.9-53.3 53.3-53.3z"],
    "window-minimize": [512, 512, [128469], "f2d1", "M0 416c0-17.7 14.3-32 32-32l448 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 448c-17.7 0-32-14.3-32-32z"],
    "stadium": [576, 512, [], "e6cc", "M256 32l0-44.8c0-10.6 8.6-19.2 19.2-19.2 3.2 0 6.3 .8 9.1 2.3L377 20.2c4.3 2.3 7 6.9 7 11.8s-2.7 9.5-7 11.8l-73 39.3 0 21.1c53 1.1 102.4 7.7 144 18.6L448 3.2c0-10.6 8.6-19.2 19.2-19.2 3.2 0 6.3 .8 9.1 2.3L569 36.2c4.3 2.3 7 6.9 7 11.8s-2.7 9.5-7 11.8l-73 39.3 0 39.6c20 8.3 37.4 18.2 50.9 29.8 16.3 14 29.1 32.7 29.1 55.6l0 181.2c0 23.1-12.3 42.3-28.7 57.1s-38.6 27-64.1 36.7c-36.2 13.8-81.3 23.7-131.2 28.3l0-79.2c0-35.3-28.7-64-64-64s-64 28.7-64 64l0 79.2c-49.9-4.6-95.1-14.4-131.2-28.3-25.5-9.7-47.8-21.9-64.1-36.7S0 428.3 0 405.2L0 224c0-22.9 12.8-41.6 29.1-55.6 9.7-8.4 21.6-15.9 34.9-22.5L64 3.2c0-10.6 8.6-19.2 19.2-19.2 3.2 0 6.3 .8 9.1 2.3L185 36.2c4.3 2.3 7 6.9 7 11.8s-2.7 9.5-7 11.8l-73 39.3 0 28.2c40.6-12.3 90.2-20.3 144-22.6L256 32zM438.6 169.9l-3.4 4.5-57 76.1c24.9 7.5 43 18.1 50.3 30.2 13.8-3.3 26.5-7.1 38-11.3 22.4-8.1 38.8-17.2 49.1-26.2 10.4-9 12.4-15.5 12.4-19.2s-1.9-10.2-12.4-19.2c-10.4-8.9-26.8-18-49.1-26.2-8.6-3.1-18-6.1-27.9-8.7zm-51.9-10.7c-30.1-4.6-63.4-7.2-98.6-7.2s-68.5 2.6-98.6 7.2l60.9 81.2c12-1.2 24.6-1.9 37.7-1.9s25.7 .6 37.7 1.9l60.9-81.2zM137.4 169.9c-10 2.7-19.3 5.6-27.9 8.7-22.4 8.1-38.8 17.2-49.1 26.2-10.4 9-12.4 15.5-12.4 19.2l0 0c0 3.6 2 10.2 12.4 19.2 10.4 8.9 26.8 18 49.1 26.2 11.5 4.2 24.2 8 38 11.3 7.3-12.1 25.4-22.7 50.3-30.2l-57-76.1-3.4-4.5z"],
    "megaphone": [512, 512, [128227], "f675", "M480 32c-17.7 0-32 14.3-32 32l0 9.1-385.2 110.1C59 169.8 46.6 160 32 160 14.3 160 0 174.3 0 192L0 320c0 17.7 14.3 32 32 32 14.6 0 27-9.8 30.8-23.2l71.7 20.5c-4.2 10.8-6.5 22.5-6.5 34.7 0 53 43 96 96 96 46.9 0 86-33.7 94.3-78.2l129.7 37 0 9.1c0 17.7 14.3 32 32 32s32-14.3 32-32l0-384c0-17.7-14.3-32-32-32zM271.8 388.5c-2.3 24.4-22.8 43.5-47.8 43.5-26.5 0-48-21.5-48-48 0-7.7 1.8-15 5-21.4l90.8 25.9z"],
    "burger-glass": [576, 512, [], "e0ce", "M64 0C55.1 0 46.6 3.7 40.6 10.2s-9.1 15.2-8.5 24.1L60.9 437.7c3 41.9 37.8 74.3 79.8 74.3l70.4 0c-2-8.1-3.1-16.6-3.1-25.3 0-10.7 3.1-20.7 8.4-29.1-5.3-10.1-8.4-21.5-8.4-33.7 0-15.6 5-30 13.4-41.8-8.4-12.4-13.4-27.3-13.4-43.5 0-16.5 2.3-38.2 14.3-59.1 21-36.6 74.3-99.6 183.5-103.4L415.9 34.3c.6-8.9-2.4-17.6-8.5-24.1S392.9 0 384 0L64 0zm41.2 160l-6.9-96 251.3 0-6.9 96-237.6 0zM256 486.7c0 31.6 25.6 57.1 57.1 57.1l205.7 0c31.6 0 57.1-25.6 57.1-57.1 0-3.8-3.1-6.9-6.9-6.9l-306.3 0c-3.8 0-6.9 3.1-6.9 6.9zm29.3-118.9l261.5 0c16.2 0 29.3-13.1 29.3-29.3 0-12.3-1.8-24.6-7.9-35.2-15.8-27.5-58-79.4-152.1-79.5-94.1 .1-136.3 52-152.1 79.5-6.1 10.7-7.9 22.9-7.9 35.2 0 16.2 13.1 29.3 29.3 29.3zm-5.3 32c-13.3 0-24 10.7-24 24s10.7 24 24 24l272 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-272 0zM400 272a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm-64 16a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm144 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"],
    "pen-paintbrush": [576, 512, ["pencil-paintbrush"], "f618", "M214.3 123.8L123.8 214.3 18.7 109.3c-25-25-25-65.5 0-90.5s65.5-25 90.5 0L214.3 123.8zM450 299.8c36.7 18.4 62 56.4 62 100.2 0 3.9-.2 7.8-.6 11.6-1.8 17.5 10.2 36.4 27.8 36.4l4.8 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-144 0c-43.9 0-81.8-25.2-100.2-62L450 299.8zM436 0c19.2 0 37.6 7.6 51.1 21.2l35.7 35.7C536.4 70.4 544 88.8 544 108s-7.6 37.6-21.2 51.1L477.9 204 340 66.1 384.9 21.2C398.4 7.6 416.8 0 436 0zM90.9 315.1L306.1 100 444 237.9 228.9 453.1c-10.7 10.7-24.1 18.5-38.7 22.6L62.4 511.1c-8.3 2.3-17.3 0-23.4-6.2s-8.5-15.1-6.2-23.4L68.4 353.8c4.1-14.6 11.8-27.9 22.6-38.7z"],
    "lightbulb-slash": [576, 512, [], "f673", "M41-24.9c-9.4-9.4-24.6-9.4-33.9 0S-2.3-.3 7 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9L410.2 344.3c5.3-7.1 11.1-13.8 17.1-20.2 32.7-34.4 52.7-80.9 52.7-132.1 0-106-86-192-192-192-60.7 0-114.8 28.2-150 72.1l-97-97zM181.4 115.6c21.7-31.2 57.7-51.6 98.6-51.6 13.3 0 24 10.7 24 24s-10.7 24-24 24c-27.6 0-51.6 15.6-63.7 38.4l-34.9-34.9zM97.6 167.4c-1 8.1-1.6 16.3-1.6 24.6 0 51.2 20 97.7 52.7 132.1 16.5 17.4 31.2 37.6 38.4 59.9l127.1 0-216.6-216.6zM383.8 453.6l-21.6-21.6-170.2 0 0 16c0 44.2 35.8 80 80 80l32 0c42.3 0 76.9-32.8 79.8-74.4z"],
    "circle-australian-dollar": [512, 512, [], "e730", "M0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zM320 152l0 9.1c-27.3 5.2-48 29.3-48 58.1 0 28.2 19.9 52.5 47.6 58l23.5 4.7c5.2 1 9 5.6 9 11 0 6.2-5 11.2-11.2 11.2L304 304c-13.3 0-24 10.7-24 24s10.7 24 24 24l16 0 0 8c0 8.8 7.2 16 16 16s16-7.2 16-16l0-9.1c27.3-5.2 48-29.3 48-58.1 0-28.2-19.9-52.5-47.6-58L329 230.1c-5.2-1-9-5.6-9-11 0-6.2 5-11.2 11.2-11.2l28.8 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-8 0 0-8c0-8.8-7.2-16-16-16s-16 7.2-16 16zM192 239.4l14.4 48.6-28.8 0 14.4-48.6zm33 111.4c3.8 12.7 17.1 20 29.8 16.2s20-17.1 16.2-29.8L220 164.9c-3.7-12.4-15.1-20.9-28-20.9s-24.3 8.5-28 20.9L113 337.2c-3.8 12.7 3.5 26.1 16.2 29.8s26.1-3.5 29.8-16.2l4.4-14.8 57.2 0 4.4 14.8z"],
    "shuttle-space-vertical": [448, 512, [], "e7bf", "M336 544l64 0c26.5 0 48-21.5 48-48l0-50c0-40.6-11-80.4-31.9-115.2l-80.1-133.5 0 93.3 38.9 64.9c8.4 14 14.7 28.9 19 44.5l-66.4 0c-5.6-9.7-13.7-17.8-23.4-23.4l0-198.8C304 110.7 283.4 50 233.4 7.5 228 2.9 220 2.9 214.6 7.5 164.6 50 144 110.7 144 177.8l0 198.8c-9.7 5.6-17.8 13.7-23.4 23.4l-66.4 0c4.2-15.6 10.6-30.6 19-44.5l38.9-64.9 0-93.3-80.1 133.5C11 365.6 0 405.4 0 446l0 50c0 26.5 21.5 48 48 48l288 0zm0-96l64 0 0 48-64 0 0-48zM48 448l64 0 0 48-64 0 0-48zM192 128c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16z"],
    "person-to-door": [576, 512, [58704], "e433", "M312 24a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zM115.7 181c1.2-3 4.2-5 7.4-5l35.9 0-22.7 90.6c-8.3 33.2 11 67 43.7 76.8L276 372.2 226.8 483c-7.2 16.1 .1 35.1 16.2 42.2s35.1-.1 42.2-16.2l56.6-127.4c11.7-26.4-2.4-57.2-30.1-65.5l-75.4-22.6 20.7-70.4 10 17.1c11.5 19.7 32.5 31.8 55.3 31.8l61.6 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-61.6 0-32.8-56.3c-14.3-24.6-40.6-39.7-69.1-39.7l-97.3 0c-29.4 0-55.9 17.9-66.9 45.3L34.3 212.1c-6.6 16.4 1.4 35 17.8 41.6s35-1.4 41.6-17.8L115.7 181zM103.8 388.6c-1.9 5.4-5.3 10.3-9.8 13.9L11.6 470.5c-13.6 11.2-15.6 31.4-4.3 45s31.4 15.6 45 4.3l82.4-67.9c13.4-11 23.5-25.5 29.3-41.8l6.9-19.3-4.7-1.4c-20.4-6.1-37.9-17.6-51.2-32.4l-11.3 31.7zM416 48l0 118.7c28.3 12.3 48 40.5 48 73.3s-19.7 61-48 73.3L416 464c0 26.5 21.5 48 48 48l64 0c26.5 0 48-21.5 48-48l0-416c0-26.5-21.5-48-48-48L464 0c-26.5 0-48 21.5-48 48z"],
    "face-viewfinder": [512, 512, [], "e2ff", "M64 0l72 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L64 48c-8.8 0-16 7.2-16 16l0 72c0 13.3-10.7 24-24 24S0 149.3 0 136L0 64C0 28.7 28.7 0 64 0zM376 0l72 0c35.3 0 64 28.7 64 64l0 72c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-72c0-8.8-7.2-16-16-16l-72 0c-13.3 0-24-10.7-24-24S362.7 0 376 0zM48 376l0 72c0 8.8 7.2 16 16 16l72 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-72 0c-35.3 0-64-28.7-64-64l0-72c0-13.3 10.7-24 24-24s24 10.7 24 24zm464 0l0 72c0 35.3-28.7 64-64 64l-72 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l72 0c8.8 0 16-7.2 16-16l0-72c0-13.3 10.7-24 24-24s24 10.7 24 24zM96 256a160 160 0 1 1 320 0 160 160 0 1 1 -320 0zm136-40a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm72 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM183.2 284.8c-7.6 4.4-10.3 14.2-5.8 21.9 15.7 27.1 45 45.4 78.6 45.4s62.9-18.3 78.6-45.4c4.4-7.7 1.8-17.4-5.8-21.9s-17.4-1.8-21.9 5.8C296.7 308.2 277.7 320 256 320s-40.7-11.8-50.9-29.4c-4.4-7.6-14.2-10.3-21.9-5.8z"],
    "rectangle-video-on-demand": [576, 512, [], "e774", "M64 64C28.7 64 0 92.7 0 128L0 384c0 35.3 28.7 64 64 64l448 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L64 64zm48 120l0 64.2c0 16.5 5.7 32.5 16 45.3 10.3-12.8 16-28.7 16-45.3l0-64.2c0-13.3 10.7-24 24-24s24 10.7 24 24l0 64.2c0 31.8-12.6 62.3-35.1 84.9L145 345c-4.5 4.5-10.6 7-17 7s-12.5-2.5-17-7L99.1 333.1C76.6 310.6 64 280.1 64 248.2L64 184c0-13.3 10.7-24 24-24s24 10.7 24 24zm168 24c-4.4 0-8 3.6-8 8l0 80c0 4.4 3.6 8 8 8l16 0c4.4 0 8-3.6 8-8l0-80c0-4.4-3.6-8-8-8l-16 0zm-56 8c0-30.9 25.1-56 56-56l16 0c30.9 0 56 25.1 56 56l0 80c0 30.9-25.1 56-56 56l-16 0c-30.9 0-56-25.1-56-56l0-80zm184-56l40 0c35.3 0 64 28.7 64 64l0 64c0 35.3-28.7 64-64 64l-40 0c-13.3 0-24-10.7-24-24l0-144c0-13.3 10.7-24 24-24zm24 144l16 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16l-16 0 0 96z"],
    "tennis-ball": [512, 512, [127934], "f45e", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM51.9 216c41.7-1 83.1-17.3 114.9-49.2S215 93.6 216 51.9c13-2.5 26.3-3.9 40-3.9 2.7 0 5.3 .1 8 .2 0 55.2-21.1 110.4-63.3 152.6S103.4 264 48.2 264c-.1-2.7-.2-5.3-.2-8 0-13.7 1.3-27.1 3.9-40zM460.2 296c-41.7 1-83.1 17.3-114.9 49.2S297 418.4 296 460.2c-13 2.5-26.3 3.8-40 3.8-2.7 0-5.3-.1-8-.2 0-55.2 21.1-110.4 63.3-152.6S408.6 248 463.8 248c.1 2.7 .2 5.3 .2 8 0 13.7-1.3 27.1-3.8 40z"],
    "chevron-right": [320, 512, [9002], "f054", "M311.1 233.4c12.5 12.5 12.5 32.8 0 45.3l-192 192c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L243.2 256 73.9 86.6c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0l192 192z"],
    "egg": [384, 512, [129370], "f7fb", "M192 496C86 496 0 394 0 288 0 176 64 16 192 16S384 176 384 288c0 106-86 208-192 208zM154.8 134c6.5-6 7-16.1 1-22.6s-16.1-7-22.6-1c-23.9 21.8-41.1 52.7-52.3 84.2-11.2 31.6-16.9 65.1-16.9 93.5 0 8.8 7.2 16 16 16s16-7.2 16-16c0-24.5 5-54.4 15.1-82.8 10.1-28.5 25-54.1 43.7-71.2z"],
    "conveyor-belt-arm": [640, 512, [], "e5f8", "M192 160l0-96-64 0c-17.7 0-32-14.3-32-32S110.3 0 128 0l64 0 0 0 64 0 0 0 64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-64 0 0 64 135.4 0c.2 0 .4 0 .6 0l48 0c22.1 0 40 17.9 40 40l0 32c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-8-208 0c-17.7 0-32-14.3-32-32zM416 280c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24l0 40 32 0c53 0 96 43 96 96s-43 96-96 96L96 512c-53 0-96-43-96-96s43-96 96-96l0-40c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24l0 40 64 0 0-40c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24l0 40 64 0 0-40zM128 448a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm224-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm160 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "landmark-dome": [512, 512, ["landmark-alt"], "f752", "M256 0c-17.7 0-32 14.3-32 32 0 .9 0 1.8 .1 2.6-80.5 13.4-144 76.9-157.5 157.4L64 192c-17.7 0-32 14.3-32 32s14.3 32 32 32l0 160-51.2 38.4C4.7 460.4 0 469.9 0 480 0 497.7 14.3 512 32 512l448 0c17.7 0 32-14.3 32-32 0-10.1-4.7-19.6-12.8-25.6L448 416 448 256c17.7 0 32-14.3 32-32s-14.3-32-32-32l-2.7 0c-13.5-80.4-77-143.9-157.5-157.4 .1-.9 .1-1.7 .1-2.6 0-17.7-14.3-32-32-32zm80 256l64 0 0 160-64 0 0-160zM224 416l0-160 64 0 0 160-64 0zM112 256l64 0 0 160-64 0 0-160z"],
    "grate": [448, 512, [], "e193", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm0 64l40 0 0 136-40 0 0-136zm0 184l40 0 0 136-40 0 0-136zm88 136l0-136 48 0 0 136-48 0zm96 0l0-136 48 0 0 136-48 0zm96 0l0-136 40 0 0 136-40 0zm40-184l-40 0 0-136 40 0 0 136zM296 96l0 136-48 0 0-136 48 0zm-96 0l0 136-48 0 0-136 48 0z"],
    "worm": [448, 512, [], "e599", "M224 96c0-53 43-96 96-96l38.4 0C407.9 0 448 40.1 448 89.6L448 376c0 75.1-60.9 136-136 136S176 451.1 176 376l0-80c0-22.1-17.9-40-40-40s-40 17.9-40 40l0 168c0 26.5-21.5 48-48 48S0 490.5 0 464L0 296c0-75.1 60.9-136 136-136s136 60.9 136 136l0 80c0 22.1 17.9 40 40 40s40-17.9 40-40l0-184-32 0c-53 0-96-43-96-96zm144-8a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"],
    "sack": [512, 512, [], "f81c", "M184 112l144 0 37.3-74.5c1.8-3.6 2.7-7.6 2.7-11.6 0-14.3-11.6-25.9-25.9-25.9L169.9 0c-14.3 0-25.9 11.6-25.9 25.9 0 4 .9 8 2.7 11.6L184 112zm158.4 48l-172.8 0-48.7 40.6C54.4 256 16 338 16 424.5 16 472.8 55.2 512 103.5 512l305.1 0c48.3 0 87.5-39.2 87.5-87.5 0-86.5-38.4-168.6-104.9-224L342.4 160z"],
    "user-injured": [448, 512, [], "f728", "M242.7 80L334 80c-10.7-24.6-29.5-44.9-52.9-57.6L242.7 80zm-.9-70.7C236 8.4 230 8 224 8 174.8 8 132.5 37.6 114 80l80.6 0 47.1-70.7zM224 248c66.3 0 120-53.7 120-120l-240 0c0 66.3 53.7 120 120 120zM98.7 341.8C49.3 370.2 16 423.5 16 484.6 16 499.7 28.3 512 43.4 512l151 0-95.8-170.2zm45.1-17.7l42.7 75.9 85.5 0c44.2 0 80 35.8 80 80 0 11.4-2.4 22.2-6.7 32l59.2 0c15.1 0 27.4-12.3 27.4-27.4 0-90.9-73.7-164.6-164.6-164.6l-86.9 0c-12.6 0-24.9 1.4-36.7 4.1zM213.5 448l36 64 22.5 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-58.5 0z"],
    "midi": [512, 512, [], "e806", "M320 49.4c0-20.9 19.8-36.2 39-27.8 90.1 39.6 153 129.7 153 234.5 0 141.4-114.6 256-256 256S0 397.4 0 256c0-104.8 62.9-194.8 153-234.5 19.1-8.4 39 6.9 39 27.8L192 64c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-14.7zM256 384a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm-90.5-37.5a32 32 0 1 0 -45.2 45.2 32 32 0 1 0 45.2-45.2zm226.3 0a32 32 0 1 0 -45.3 45.2 32 32 0 1 0 45.3-45.2zM96 224a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm320 0a32 32 0 1 0 0 64 32 32 0 1 0 0-64z"],
    "moon-star": [512, 512, [], "e7c9", "M0 256c0-141.4 114.6-256 256-256 19.4 0 38.4 2.2 56.7 6.3 9.9 2.2 17.3 10.5 18.5 20.5s-4 19.8-13.1 24.4c-60.6 30.2-102.1 92.7-102.1 164.8 0 101.6 82.4 184 184 184 5 0 9.9-.2 14.8-.6 10.1-.8 19.6 4.8 23.8 14.1s2 20.1-5.3 27.1C387.3 484.8 324.8 512 256 512 114.6 512 0 397.4 0 256zm371.2-19.2l-58-16.6c-5.5-1.6-9.2-6.6-9.2-12.2s3.8-10.7 9.2-12.2l58-16.6 16.6-58c1.6-5.5 6.6-9.2 12.2-9.2s10.7 3.8 12.2 9.2l16.6 58 58 16.6c5.5 1.6 9.2 6.6 9.2 12.2s-3.8 10.7-9.2 12.2l-58 16.6-16.6 58c-1.6 5.5-6.6 9.2-12.2 9.2s-10.7-3.8-12.2-9.2l-16.6-58z"],
    "strikethrough": [512, 512, [], "f0cc", "M96 157.5C96 88.2 152.2 32 221.5 32L368 32c17.7 0 32 14.3 32 32s-14.3 32-32 32L221.5 96c-34 0-61.5 27.5-61.5 61.5 0 31 23.1 57.2 53.9 61l44.1 5.5 222 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 288c-17.7 0-32-14.3-32-32s14.3-32 32-32l83.1 0C103 204.6 96 181.8 96 157.5zM349.2 336l65.5 0c.9 6.1 1.4 12.2 1.4 18.5 0 69.3-56.2 125.5-125.5 125.5L144 480c-17.7 0-32-14.3-32-32s14.3-32 32-32l146.5 0c34 0 61.5-27.5 61.5-61.5 0-6.4-1-12.7-2.8-18.5z"],
    "calendar-circle-minus": [576, 512, [], "e46f", "M192 32l0 32 128 0 0-32c0-17.7 14.3-32 32-32s32 14.3 32 32l0 32 32 0c35.3 0 64 28.7 64 64l0 48-448 0 0-48c0-35.3 28.7-64 64-64l32 0 0-32c0-17.7 14.3-32 32-32s32 14.3 32 32zM32 416l0-192 323.1 0c-67.8 29.6-115.1 97.3-115.1 176 0 28.6 6.2 55.6 17.4 80L96 480c-35.3 0-64-28.7-64-64zm256-16a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm224 0c0-8.8-7.2-16-16-16l-128 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l128 0c8.8 0 16-7.2 16-16z"],
    "blog": [512, 512, [], "f781", "M224 24c0-13.3 10.7-24 24-24 145.8 0 264 118.2 264 264 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-119.3-96.7-216-216-216-13.3 0-24-10.7-24-24zM80 96c26.5 0 48 21.5 48 48l0 224c0 26.5 21.5 48 48 48s48-21.5 48-48-21.5-48-48-48c-8.8 0-16-7.2-16-16l0-64c0-8.8 7.2-16 16-16 79.5 0 144 64.5 144 144S255.5 512 176 512 32 447.5 32 368l0-224c0-26.5 21.5-48 48-48zm168 0c92.8 0 168 75.2 168 168 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-66.3-53.7-120-120-120-13.3 0-24-10.7-24-24s10.7-24 24-24z"],
    "stopwatch-20": [448, 512, [], "e06f", "M168.5 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l32 0 0 25.3c-108 11.9-192 103.5-192 214.7 0 119.3 96.7 216 216 216s216-96.7 216-216c0-39.8-10.8-77.1-29.6-109.2l28.2-28.2c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-23.4 23.4c-32.9-30.2-75.2-50.3-122-55.5l0-25.3 32 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-112 0zm-60 240c0-28.7 23.3-52 52-52s52 23.3 52 52l0 3.8c0 11.7-3.2 23.1-9.3 33l-43.8 71.2 33.1 0c11 0 20 9 20 20s-9 20-20 20l-57.8 0c-14.5 0-26.2-11.7-26.2-26.2 0-4.9 1.3-9.6 3.9-13.8l56.7-92.1c2.2-3.6 3.4-7.8 3.4-12.1l0-3.8c0-6.6-5.4-12-12-12s-12 5.4-12 12c0 11-9 20-20 20s-20-9-20-20zm180-52c28.7 0 52 23.3 52 52l0 96c0 28.7-23.3 52-52 52s-52-23.3-52-52l0-96c0-28.7 23.3-52 52-52zm-12 52l0 96c0 6.6 5.4 12 12 12s12-5.4 12-12l0-96c0-6.6-5.4-12-12-12s-12 5.4-12 12z"],
    "square-florin": [448, 512, [], "e717", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM240.4 156.7c9.5-22.3 31.4-36.7 55.7-36.7l23.9 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-23.9 0c-5 0-9.6 3-11.6 7.6L263.8 224 296 224c13.3 0 24 10.7 24 24s-10.7 24-24 24l-52.7 0-35.7 83.3C198 377.6 176.1 392 151.9 392L128 392c-13.3 0-24-10.7-24-24s10.7-24 24-24l23.9 0c5 0 9.6-3 11.6-7.6l27.6-64.4-39 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l59.6 0 28.8-67.3z"],
    "binary": [384, 512, [], "e33b", "M336 32l0 128 16 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-96 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l16 0 0-83.6-5.9 2c-16.8 5.6-34.9-3.5-40.5-20.2s3.5-34.9 20.2-40.5l48-16C303.6-1.6 314.4 0 322.7 6S336 21.7 336 32zM112 320l0 128 16 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-96 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l16 0 0-83.6-5.9 2c-16.8 5.6-34.9-3.5-40.5-20.2s3.5-34.9 20.2-40.5l48-16c9.8-3.3 20.5-1.6 28.8 4.4S112 309.7 112 320zM0 64C0 28.7 28.7 0 64 0l64 0c35.3 0 64 28.7 64 64l0 96c0 35.3-28.7 64-64 64l-64 0c-35.3 0-64-28.7-64-64L0 64zm128 0l-64 0 0 96 64 0 0-96zM256 288l64 0c35.3 0 64 28.7 64 64l0 96c0 35.3-28.7 64-64 64l-64 0c-35.3 0-64-28.7-64-64l0-96c0-35.3 28.7-64 64-64zm0 64l0 96 64 0 0-96-64 0z"],
    "shield-check": [512, 512, [], "f2f7", "M256.1 0c4.6 0 9.2 1 13.3 2.9L457.8 82.8c22 9.3 38.4 31 38.3 57.2-.5 99.2-41.3 280.7-213.7 363.2-16.7 8-36.1 8-52.7 0-172.4-82.5-213.1-263.9-213.6-363.2-.1-26.2 16.3-47.9 38.3-57.2L242.7 2.9C246.8 1 251.4 0 256.1 0zm90.9 164.6c-10.7-7.8-25.7-5.4-33.5 5.3l-85.6 117.7-26.5-27.4c-9.2-9.5-24.4-9.8-33.9-.6-9.5 9.2-9.8 24.4-.6 33.9l46.4 48c4.9 5.1 11.8 7.8 18.9 7.3s13.6-4.1 17.8-9.8L352.3 198.1c7.8-10.7 5.4-25.7-5.3-33.5z"],
    "square-cruzeiro": [448, 512, [], "e6ed", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm67 224c0 44.5 31.2 81.7 73 90.8l0-98.8c0-11 9-20 20-20 10.1 0 18.4 7.5 19.8 17.2 10.8-5.8 23.1-9.2 36.2-9.2 11 0 20 9 20 20s-9 20-20 20c-19.9 0-36 16.1-36 36l0 34.8c16.7-3.7 31.8-11.8 43.8-23.2 9.6-9.1 24.8-8.7 33.9 1s8.7 24.8-1 33.9c-25.2 23.8-59.3 38.5-96.8 38.5-77.9 0-141-63.1-141-141s63.1-141 141-141c37.5 0 71.5 14.6 96.8 38.5 9.6 9.1 10.1 24.3 1 33.9s-24.3 10.1-33.9 1c-16.7-15.7-39.1-25.4-63.8-25.4-51.4 0-93 41.6-93 93z"],
    "truck-pickup": [640, 512, [128763], "f63c", "M363.8 96l57.6 96-133.4 0 0-96 75.8 0zM496 192L418.6 63.1C407.1 43.8 386.2 32 363.8 32L256 32c-17.7 0-32 14.3-32 32l0 128-144 0c-26.5 0-48 21.5-48 48l0 80c-17.7 0-32 14.3-32 32s14.3 32 32 32l32.4 0c-.2 2.6-.4 5.3-.4 8 0 48.6 39.4 88 88 88s88-39.4 88-88c0-2.7-.1-5.4-.4-8l160.7 0c-.2 2.6-.4 5.3-.4 8 0 48.6 39.4 88 88 88s88-39.4 88-88c0-2.7-.1-5.4-.4-8l32.4 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l0-80c0-26.5-21.5-48-48-48l-64 0zM112 392a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zm376-40a40 40 0 1 1 0 80 40 40 0 1 1 0-80z"],
    "seedling": [512, 512, [127793, "sprout"], "f4d8", "M512 32C512 140.1 435.4 230.3 333.6 251.4 325.7 193.3 299.6 141 261.1 100.5 301.2 40 369.9 0 448 0l32 0c17.7 0 32 14.3 32 32zM0 96C0 78.3 14.3 64 32 64l32 0c123.7 0 224 100.3 224 224l0 192c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-160C100.3 320 0 219.7 0 96z"],
    "circle-divide": [512, 512, [], "e106", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm0-384a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM168 232l176 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-176 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zm56 120a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"],
    "circle-kip": [512, 512, [], "e6fd", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm90.5-375.2c8.4 10.2 6.9 25.4-3.3 33.8l-84.7 69.7 77.3 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-77.1 0 84.5 69.2c10.3 8.4 11.8 23.5 3.4 33.8S323 387 312.8 378.6L224 305.9 224 360c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-87.8-15.8 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l15.8 0 0-88.2c0-13.3 10.7-24 24-24s24 10.7 24 24l0 54.5 88.8-73c10.2-8.4 25.4-6.9 33.8 3.3z"],
    "transgender": [576, 512, [9895, "transgender-alt"], "f225", "M128-32c17.7 0 32 14.3 32 32s-14.3 32-32 32L97.9 32 136 70.1 151 55c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-15 15 14.2 14.2c27.9-23.8 64.2-38.2 103.8-38.2 36.7 0 70.6 12.4 97.6 33.2L466.7 32 448 32c-17.7 0-32-14.3-32-32s14.3-32 32-32l96 0c17.7 0 32 14.3 32 32l0 96c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-18.7-84.4 84.4c13 23.1 20.4 49.9 20.4 78.3 0 77.4-55 142-128 156.8l0 35.2 32 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32 0 0 16c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-16-32 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l32 0 0-35.2c-73-14.8-128-79.4-128-156.8 0-31.4 9-60.7 24.7-85.4l-16.7-16.7-15 15c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l15-15-38.1-38.1 0 30.1c0 17.7-14.3 32-32 32S0 113.7 0 96L0 0C0-17.7 14.3-32 32-32l96 0zM288 336a96 96 0 1 0 0-192 96 96 0 1 0 0 192z"],
    "arrow-down-to-bracket": [448, 512, [], "e094", "M374.6 214.6l-128 128c-12.5 12.5-32.8 12.5-45.3 0l-128-128c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0L192 242.7 192 32c0-17.7 14.3-32 32-32s32 14.3 32 32l0 210.7 73.4-73.4c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3zM64 352l0 64c0 17.7 14.3 32 32 32l256 0c17.7 0 32-14.3 32-32l0-64c0-17.7 14.3-32 32-32s32 14.3 32 32l0 64c0 53-43 96-96 96L96 512c-53 0-96-43-96-96l0-64c0-17.7 14.3-32 32-32s32 14.3 32 32z"],
    "unicorn": [640, 512, [129412], "f727", "M448 160l0 80 0 0c-.5 30-12.8 56.4-32 75.7L416 480c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-133.3c-4.1-.7-8.2-1.6-12.3-2.8l-84-24c.2 2.3 .3 4.6 .3 6.9 0 18.6-7.4 36.5-20.6 49.7l-12.7 12.7c-4.8 4.8-6.4 11.8-4.3 18.2l20.8 62.5c6.9 20.7-8.5 42.1-30.4 42.1l-33.7 0c-13.8 0-26-8.8-30.4-21.9L95.3 437.7c-10.6-31.7-6.5-65.9 10-93.9 7.6-12.9 9.5-29.1 1.2-41.6L78.2 259.9c-7.3-11-11.9-23.4-13.6-36.4-10.1 7.3-16.7 19.1-16.7 32.5l0 56c0 13.3-10.7 24-24 24S0 325.3 0 312l0-56c0-44.6 33.2-81.5 76.3-87.2 14.9-24.4 41.8-40.8 72.5-40.8L320 128C320 57.3 377.3 0 448 0l96 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-5.7 0c5.2 4.6 9.6 10 13.1 16l79.3 0c5.1 0 9.3 4.2 9.3 9.3 0 4-2.6 7.6-6.4 8.8l-73.6 24.5 0 64.8c0 22.1-13.4 41.9-33.9 50.1-26.1 10.4-55.7-.9-68.3-26L448 160zm64-80a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"],
    "left-from-bracket": [512, 512, [], "e66c", "M352 416c-17.7 0-32 14.3-32 32s14.3 32 32 32l64 0c53 0 96-43 96-96l0-256c0-53-43-96-96-96l-64 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l64 0c17.7 0 32 14.3 32 32l0 256c0 17.7-14.3 32-32 32l-64 0zM7 239c-9.4 9.4-9.4 24.6 0 33.9L151 417c6.9 6.9 17.2 8.9 26.2 5.2S192 409.7 192 400l0-80 112 0c26.5 0 48-21.5 48-48l0-32c0-26.5-21.5-48-48-48l-112 0 0-80c0-9.7-5.8-18.5-14.8-22.2S157.9 88.2 151 95L7 239z"],
    "ramp-loading": [384, 512, [], "f4d4", "M0 64C0 28.7 28.7 0 64 0L320 0c35.3 0 64 28.7 64 64l0 340.7-53.1-106.1-10.9-21.9 0-212.7-256 0 0 212.7c-.3 .5-21.6 43.2-64 128L0 64zM372.4 488.8c.8 1.5 1.2 3 1.5 4.6 1.5 9.3-5.6 18.6-15.8 18.6L25.9 512c-10.2 0-17.4-9.2-15.8-18.6 .3-1.5 .7-3.1 1.5-4.6 39.8-79.7 65-130 75.6-151.2 5.4-10.8 16.5-17.7 28.6-17.7l152.4 0c12.1 0 23.2 6.8 28.6 17.7 10.6 21.1 35.8 71.5 75.6 151.2z"],
    "hand-holding-box": [576, 512, [], "f47b", "M224 121.7L224 0 176 0c-26.5 0-48 21.5-48 48l0 160c0 26.5 21.5 48 48 48l224 0c26.5 0 48-21.5 48-48l0-160c0-26.5-21.5-48-48-48l-48 0 0 121.7c0 3.5-2.8 6.3-6.3 6.3-1.1 0-2.2-.3-3.1-.8l-46.6-26.6c-4.9-2.8-11-2.8-15.9 0l-46.6 26.6c-1 .5-2 .8-3.1 .8-3.5 0-6.3-2.8-6.3-6.3zM109.3 341.5L66.7 384 32 384c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32l320.5 0c29 0 57.3-9.3 80.7-26.5l126.6-93.3c17.8-13.1 21.6-38.1 8.5-55.9s-38.1-21.6-55.9-8.5L392.6 416 280 416c-13.3 0-24-10.7-24-24s10.7-24 24-24l72 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-152.2 0c-33.9 0-66.5 13.5-90.5 37.5z"],
    "star-half": [576, 512, [61731], "f089", "M304.1 7.6c0-11.1-7.6-20.7-18.4-23.3s-21.9 2.5-27 12.4L193.1 125.3 33.2 150.7c-8.9 1.4-16.3 7.7-19.1 16.3s-.5 18 5.8 24.4l114.4 114.5-25.2 159.9c-1.4 8.9 2.3 17.9 9.6 23.2s16.9 6.1 25 2L291 416.1c8-4.1 13.1-12.4 13.1-21.4l0-387.1z"],
    "arrow-down-to-line": [384, 512, ["arrow-to-bottom"], "f33d", "M32 512c-17.7 0-32-14.3-32-32s14.3-32 32-32l320 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 512zM214.6 374.6c-12.5 12.5-32.8 12.5-45.3 0l-128-128c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0L160 274.7 160 32c0-17.7 14.3-32 32-32s32 14.3 32 32l0 242.7 73.4-73.4c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3l-128 128z"],
    "photo-film": [640, 512, ["photo-video"], "f87c", "M192 64c0-35.3 28.7-64 64-64L576 0c35.3 0 64 28.7 64 64l0 224c0 35.3-28.7 64-64 64l-320 0c-35.3 0-64-28.7-64-64l0-224zM320 96a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm156.5 11.5C472.1 100.4 464.4 96 456 96s-16.1 4.4-20.5 11.5l-54 88.3-17.9-25.6c-4.5-6.4-11.8-10.2-19.7-10.2s-15.2 3.8-19.7 10.2l-56 80c-5.1 7.3-5.8 16.9-1.6 24.8S279.1 288 288 288l256 0c8.7 0 16.7-4.7 20.9-12.3s4.1-16.8-.5-24.3l-88-144zM144 128l0 160c0 61.9 50.1 112 112 112l192 0 0 16c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 192c0-35.3 28.7-64 64-64l80 0zM52 196l0 24c0 8.8 7.2 16 16 16l24 0c8.8 0 16-7.2 16-16l0-24c0-8.8-7.2-16-16-16l-24 0c-8.8 0-16 7.2-16 16zm16 80c-8.8 0-16 7.2-16 16l0 24c0 8.8 7.2 16 16 16l24 0c8.8 0 16-7.2 16-16l0-24c0-8.8-7.2-16-16-16l-24 0zm0 96c-8.8 0-16 7.2-16 16l0 24c0 8.8 7.2 16 16 16l24 0c8.8 0 16-7.2 16-16l0-24c0-8.8-7.2-16-16-16l-24 0z"],
    "pi": [448, 512, [], "f67e", "M32 32C14.3 32 0 46.3 0 64S14.3 96 32 96l64 0 0 220c0 39.7-9.3 78.9-27 114.5l-1.6 3.2c-7.9 15.8-1.5 35 14.3 42.9s35 1.5 42.9-14.3l1.6-3.2C148.4 414.7 160 365.7 160 316l0-220 128 0 0 302.6c0 45 36.5 81.4 81.4 81.4 30.8 0 59-17.4 72.8-45l2.3-4.7c7.9-15.8 1.5-35-14.3-42.9s-35-1.5-42.9 14.3l-2.3 4.7c-3 5.9-9 9.6-15.6 9.6-9.6 0-17.4-7.8-17.4-17.4l0-302.6 64 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 32z"],
    "picture-in-picture": [512, 512, [], "e80b", "M448 32c35.3 0 64 28.7 64 64l0 112-64 0 0-112-384 0 0 320 144 0 0 64-144 0-6.5-.3c-30.1-3.1-54.1-27-57.1-57.1L0 416 0 96C0 62.9 25.2 35.6 57.5 32.3L64 32 448 32zm16 224c26.5 0 48 21.5 48 48l0 128c0 26.5-21.5 48-48 48l-160 0c-26.5 0-48-21.5-48-48l0-128c0-26.5 21.5-48 48-48l160 0z"],
    "table-cells-lock": [640, 512, [], "e679", "M448 96l0 64-64 0 0-64 64 0zM384 224l25.3 0c17.1-42.2 56-73.2 102.7-79l0-49c0-35.3-28.7-64-64-64L128 32C92.7 32 64 60.7 64 96l0 320c0 35.3 28.7 64 64 64l241.3 0c-.9-5.2-1.3-10.6-1.3-16.1l0-96c0-28.5 12.4-54 32-71.5l0-8.4-16 0 0-64zm-64 64l-64 0 0-64 64 0 0 64zm-64 64l64 0 0 64-64 0 0-64zm-64-64l-64 0 0-64 64 0 0 64zm-64 64l64 0 0 64-64 0 0-64zm0-192l0-64 64 0 0 64-64 0zm128 0l0-64 64 0 0 64-64 0zM560 272.1l0 47.9-64 0 0-47.9c0-17.7 14.3-32 32-32s32 14.3 32 32zM416 368l0 96c0 26.5 21.5 48 48 48l128 0c26.5 0 48-21.5 48-48l0-96c0-20.9-13.4-38.7-32-45.3l0-50.6c0-44.2-35.8-80-80-80s-80 35.8-80 80l0 50.6c-18.6 6.6-32 24.4-32 45.3z"],
    "pump-medical": [320, 512, [], "e06a", "M96 0l0 80 128 0 0-24 72 0c13.3 0 24-10.7 24-24S309.3 8 296 8l-72 0 0-8c0-17.7-14.3-32-32-32l-64 0C110.3-32 96-17.7 96 0zM64 128c-35.3 0-64 28.7-64 64L0 448c0 35.3 28.7 64 64 64l192 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L64 128zm64 120c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 40 40 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-40 0 0 40c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-40-40 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l40 0 0-40z"],
    "fire": [448, 512, [128293], "f06d", "M160.5-26.4c9.3-7.8 23-7.5 31.9 .9 12.3 11.6 23.3 24.4 33.9 37.4 13.5 16.5 29.7 38.3 45.3 64.2 5.2-6.8 10-12.8 14.2-17.9 1.1-1.3 2.2-2.7 3.3-4.1 7.9-9.8 17.7-22.1 30.8-22.1 13.4 0 22.8 11.9 30.8 22.1 1.3 1.7 2.6 3.3 3.9 4.8 10.3 12.4 24 30.3 37.7 52.4 27.2 43.9 55.6 106.4 55.6 176.6 0 123.7-100.3 224-224 224S0 411.7 0 288c0-91.1 41.1-170 80.5-225 19.9-27.7 39.7-49.9 54.6-65.1 8.2-8.4 16.5-16.7 25.5-24.2zM225.7 416c25.3 0 47.7-7 68.8-21 42.1-29.4 53.4-88.2 28.1-134.4-4.5-9-16-9.6-22.5-2l-25.2 29.3c-6.6 7.6-18.5 7.4-24.7-.5-17.3-22.1-49.1-62.4-65.3-83-5.4-6.9-15.2-8-21.5-1.9-18.3 17.8-51.5 56.8-51.5 104.3 0 68.6 50.6 109.2 113.7 109.2z"],
    "face-smile-plus": [640, 512, ["smile-plus"], "f5b9", "M544-64c13.3 0 24 10.7 24 24l0 48 48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0 0 48c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-48-48 0c-13.3 0-24-10.7-24-24S458.7 8 472 8l48 0 0-48c0-13.3 10.7-24 24-24zM0 272a240 240 0 1 1 480 0 240 240 0 1 1 -480 0zm115.9 60.6c-10.7 7.8-13.1 22.8-5.3 33.5 29.1 39.9 76.2 65.9 129.4 65.9s100.3-26 129.4-65.9c7.8-10.7 5.4-25.7-5.3-33.5s-25.7-5.4-33.5 5.3c-20.4 28-53.4 46.1-90.6 46.1s-70.2-18.1-90.6-46.1c-7.8-10.7-22.8-13.1-33.5-5.3zM160 256a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm192-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "magnifying-glass-plus": [512, 512, ["search-plus"], "f00e", "M416 208c0 45.9-14.9 88.3-40 122.7L502.6 457.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L330.7 376C296.3 401.1 253.9 416 208 416 93.1 416 0 322.9 0 208S93.1 0 208 0 416 93.1 416 208zM208 112c-13.3 0-24 10.7-24 24l0 48-48 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l48 0 0 48c0 13.3 10.7 24 24 24s24-10.7 24-24l0-48 48 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0 0-48c0-13.3-10.7-24-24-24z"],
    "swap": [576, 512, [], "e609", "M28.4 158.2l35.6 0 0 193.8c0 70.7 57.3 128 128 128s128-57.3 128-128l0-192c0-35.3 28.7-64 64-64s64 28.7 64 64l0 192-35.6 0c-15.7 0-28.4 12.7-28.4 28.4 0 7.5 3 14.8 8.3 20.1L463 471.2c9.4 9.4 24.6 9.4 33.9 0l70.7-70.7c5.3-5.3 8.3-12.6 8.3-20.1 0-15.7-12.7-28.4-28.4-28.4l-35.6 0 0-192c0-70.7-57.3-128-128-128S256 89.3 256 160l0 192c0 35.3-28.7 64-64 64s-64-28.7-64-64l0-193.8 35.6 0c15.7 0 28.4-12.7 28.4-28.4 0-7.5-3-14.8-8.3-20.1L113 39c-9.4-9.4-24.6-9.4-33.9 0L8.3 109.7C3 115.1 0 122.3 0 129.8 0 145.5 12.7 158.2 28.4 158.2z"],
    "comment-heart": [512, 512, [], "e5c8", "M256 480c141.4 0 256-107.5 256-240S397.4 0 256 0 0 107.5 0 240c0 54.3 19.2 104.3 51.6 144.5L2.8 476.8c-4.8 9-3.3 20 3.6 27.5s17.8 9.8 27.1 5.8l118.4-50.7C183.7 472.6 218.9 480 256 480zm-6.4-296.5l6.4 8.5 6.4-8.5c11.1-14.8 28.5-23.5 46.9-23.5 32.4 0 58.7 26.3 58.7 58.7l0 5.3c0 49.1-65.8 98.1-96.5 118.3-9.5 6.2-21.5 6.2-30.9 0-30.7-20.2-96.5-69.3-96.5-118.3l0-5.3c0-32.4 26.3-58.7 58.7-58.7 18.5 0 35.9 8.7 46.9 23.5z"],
    "face-smile-tear": [512, 512, [], "e393", "M0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zM240 366.9c-30.6-4.4-57.2-21.1-74.6-45-7.8-10.7-22.8-13.1-33.5-5.3s-13.1 22.8-5.3 33.5c28.5 39.1 74.3 64.8 126.2 65.8-8.2-14.1-12.8-30.5-12.8-48l0-1.1zM176 240a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm192-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm-22.6 84.8c-2.4-2.9-5.7-4.8-9.4-4.8s-7 1.9-9.4 4.8c-6.5 7.8-12.6 16.1-18.3 24.6-9 13.4-20.3 30.2-20.3 47.4 0 28.3 21.5 51.2 48 51.2s48-22.9 48-51.2c0-17.2-11.2-34-20.3-47.4-5.7-8.5-11.8-16.7-18.3-24.6z"],
    "wheat": [576, 512, [], "f72d", "M79.7 234.6c6.2-4.1 14.7-3.4 20.1 2.1l46.1 46.1 6.1 6.7c19.7 23.8 26.3 55 19.3 83.9 31.7-7.7 66.2 1 90.6 25.3l46.1 46.1c6.2 6.2 6.2 16.4 0 22.6l-7.4 7.4c-37.5 37.5-98.3 37.5-135.8 0L134.1 444.3 49.4 529c-9.4 9.4-24.5 9.4-33.9 0-9.4-9.4-9.4-24.6 0-33.9l84.7-84.7-30.5-30.5c-37.5-37.5-37.5-98.3 0-135.8l7.4-7.4 2.5-2.1zm104-104c6.2-4.1 14.7-3.4 20.1 2.1l46.1 46.1 6.1 6.7c19.7 23.8 26.3 55 19.3 83.9 31.7-7.7 66.2 1 90.6 25.3l46.1 46.1c6.2 6.2 6.2 16.4 0 22.6l-7.4 7.4c-37.5 37.5-98.3 37.5-135.8 0l-94.9-94.9c-37.5-37.5-37.5-98.3 0-135.8l7.4-7.4 2.5-2.1zm104-104c6.2-4.1 14.7-3.4 20.1 2.1l46.1 46.1 6.1 6.7c19.7 23.8 26.3 55 19.3 83.9 31.7-7.7 66.2 1 90.6 25.3l46.1 46.1c6.2 6.2 6.2 16.4 0 22.6l-7.4 7.4c-37.5 37.5-98.3 37.5-135.8 0l-94.9-94.9c-37.5-37.5-37.5-98.3 0-135.7l7.4-7.4 2.5-2.1zM547.6-15.7c3.1 .6 5.9 2.1 8.2 4.4 3 3 4.7 7.1 4.7 11.3l0 35-.1 4.8c-2.4 47.6-40.5 85.7-88.1 88.1l-4.8 .1-35 0c-4.2 0-8.3-1.7-11.3-4.7s-4.7-7.1-4.7-11.3l0-35c0-51.4 41.6-93 93-93l35 0 3.1 .3z"],
    "barcode-scan": [576, 512, [], "f465", "M96 32C78.3 32 64 46.3 64 64l0 160-40 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l528 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-40 0 0-168c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 168-48 0 0-168c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 168-48 0 0-160c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 160-48 0 0-168c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 168-32 0 0-160c0-17.7-14.3-32-32-32zM64 448c0 17.7 14.3 32 32 32s32-14.3 32-32l0-128-64 0 0 128zm96 8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-136-48 0 0 136zm96-8c0 17.7 14.3 32 32 32s32-14.3 32-32l0-128-64 0 0 128zm112 8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-136-48 0 0 136zm96 0c0 13.3 10.7 24 24 24s24-10.7 24-24l0-136-48 0 0 136z"],
    "ear-circle-checkmark": [576, 512, [], "e75b", "M447.3 208.6c.5-5.5 .7-11 .7-16.6 0-106-86-192-192-192S64 86 64 192l0 192c0 70.7 57.3 128 128 128l9.3 0c22.9 0 44.8-6.1 63.8-17-16-28-25.1-60.4-25.1-95 0-57.3 25.1-108.8 65-144l0 0c22.3-19.7 49.3-34.3 79-42l0 0c15.3-3.9 31.4-6 48-6 5.1 0 10.2 .2 15.3 .6zM256 64c61.6 0 113 43.5 125.2 101.4-16 3.4-31.4 8.5-46.1 15-5.6-38.7-38.9-68.3-79.2-68.3-44.2 0-80 35.8-80 80l0 16.4c36 4 64 34.5 64 71.6 0 39.8-32.2 72-72 72l-16 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l16 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-16 0c-13.3 0-24-10.7-24-24l0-40c0-70.7 57.3-128 128-128zM432 544a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm60.9-182.6l-64 88c-2.8 3.8-7 6.2-11.7 6.5s-9.3-1.3-12.6-4.6l-40-40c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l26.8 26.8 53-72.9c5.2-7.1 15.2-8.7 22.4-3.5s8.7 15.2 3.5 22.3z"],
    "galaxy": [512, 512, [], "e008", "M320 0l11.5 0c11.3 0 20.5 9.2 20.5 20.5 0 7.1-3.7 13.7-9.8 17.5l-12.5 7.7c-35.2 21.7-60.9 54.9-73.3 93.1 19.9-7 41.3-10.8 63.5-10.8 106 0 192 86 192 192l0 11.5c0 11.3-9.2 20.5-20.5 20.5-7.1 0-13.7-3.7-17.5-9.8l-7.7-12.5c-21.7-35.2-54.9-60.9-93.1-73.3 7 19.9 10.8 41.3 10.8 63.5 0 106-86 192-192 192l-11.5 0c-11.3 0-20.5-9.2-20.5-20.5 0-7.1 3.7-13.7 9.8-17.5l12.5-7.7c35.2-21.7 60.9-54.9 73.3-93.1-19.9 7-41.3 10.8-63.5 10.8-106 0-192-86-192-192l0-11.5c0-11.3 9.2-20.5 20.5-20.5 7.1 0 13.7 3.7 17.5 9.8l7.7 12.5c21.7 35.2 54.9 60.9 93.1 73.3-7-19.9-10.8-41.3-10.8-63.5 0-106 86-192 192-192zM256 288a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "flask": [448, 512, [], "f0c3", "M288 0L128 0C110.3 0 96 14.3 96 32s14.3 32 32 32L128 215.5 7.5 426.3C2.6 435 0 444.7 0 454.7 0 486.4 25.6 512 57.3 512l333.4 0c31.6 0 57.3-25.6 57.3-57.3 0-10-2.6-19.8-7.5-28.4L320 215.5 320 64c17.7 0 32-14.3 32-32S337.7 0 320 0L288 0zM192 215.5l0-151.5 64 0 0 151.5c0 11.1 2.9 22.1 8.4 31.8l41.6 72.7-164 0 41.6-72.7c5.5-9.7 8.4-20.6 8.4-31.8z"],
    "car-key": [576, 512, [], "e7c0", "M135.2 117.4c4.5-12.8 16.6-21.4 30.2-21.4l181.2 0c10.3 0 19.7 4.9 25.7 12.9 17.5-12.3 37.6-21.1 59.3-25.6-16.4-31.2-48.9-51.3-85-51.3L165.4 32c-40.8 0-77.1 25.8-90.6 64.3L39.6 196.8C16.4 206.4 0 229.3 0 256L0 448c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-32 272 0 0-48c-38.8-29.2-64-75.6-64-128 0-16.7 2.6-32.8 7.3-48l-202.2 0 26.1-74.6zM64 304a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm512-64c0-61.9-50.1-112-112-112S352 178.1 352 240c0 44.7 26.2 83.2 64 101.2l0 116.2c0 4.2 1.7 8.3 4.7 11.3l32 32c6.2 6.2 16.4 6.2 22.6 0l41.4-41.4c6.2-6.2 6.2-16.4 0-22.6L496 416 517.9 394.1c5.8-5.8 6.3-14.9 1.2-21.3l-20.9-26.1C543.3 332.3 576 289.9 576 240zM432 224a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"],
    "fireplace": [576, 512, [], "f79a", "M0 64C0 46.3 14.3 32 32 32l512 0c17.7 0 32 14.3 32 32l0 32c0 17.7-14.3 32-32 32l0 352c0 17.7-14.3 32-32 32l-32 0 0-160c0-106-86-192-192-192S96 246 96 352l0 160-32 0c-17.7 0-32-14.3-32-32l0-352C14.3 128 0 113.7 0 96L0 64zM309 263.5l10-11.3c4.4-5 10.9-7.2 17.1-7.2 5.9 0 11.7 2.1 16.3 6.4 16.1 15 32.6 35.4 45 57.8 12.4 22.3 21.4 47.6 21.4 72.1 0 72.6-58.4 130.8-130.9 130.8-73.3 0-130.9-58.3-130.9-130.8 0-30.5 13.1-60 30.1-85.5 17.1-25.6 38.9-48.3 58-65.6 4.7-4.2 10.7-6.3 16.6-6.1s10.9 2.6 15.4 6.1c11.8 9.3 31.8 33.3 31.8 33.3zm31.3 157c0-29.9-30.3-59.7-44.8-72.3-4.4-3.8-10.7-3.8-15.1 0-14.5 12.6-44.8 42.5-44.8 72.3 0 28.9 23.4 52.4 52.4 52.4s52.4-23.4 52.4-52.4z"],
    "flower-tulip": [448, 512, [127799], "f801", "M224-32c7.5 0 14.5 3.5 19 9.4L306.3 59.7 343 23c6.9-6.9 17.2-8.9 26.2-5.2S384 30.3 384 40l0 88c0 70.7-57.3 128-128 128l0 138.8c31.8-45.3 84.5-74.8 144-74.8l18.5 0c16.3 0 29.5 13.2 29.5 29.5 0 89.7-72.7 162.5-162.5 162.5l-123.1 0C72.7 512 0 439.3 0 349.5 0 333.2 13.2 320 29.5 320L48 320c59.5 0 112.2 29.6 144 74.8L192 256c-70.7 0-128-57.3-128-128l0-88 .3-3.6c1.2-8.2 6.7-15.3 14.5-18.6 9-3.7 19.3-1.6 26.2 5.2l36.7 36.7 63.3-82.3 1.8-2.1c4.5-4.6 10.7-7.3 17.2-7.3z"],
    "inboxes": [512, 512, [], "e1bb", "M89 64l-24 96 59.2 0c12.1 0 23.2 6.8 28.6 17.7l14.3 28.6c5.4 10.8 16.5 17.7 28.6 17.7l120.4 0c12.1 0 23.2-6.8 28.6-17.7l14.3-28.6c5.4-10.8 16.5-17.7 28.6-17.7l59.2 0-24-96-334 0zM28.4 42.4C34.6 17.5 57 0 82.7 0L429.3 0c25.7 0 48.1 17.5 54.3 42.4l26.7 107c1.1 4.4 1.7 9 1.7 13.6l0 157-512 0 0-157c0-4.6 .6-9.1 1.7-13.6l26.7-107zM0 368l126.9 0c10.7 0 20.7 5.3 26.6 14.2l13 19.5c5.9 8.9 15.9 14.2 26.6 14.2l125.7 0c10.7 0 20.7-5.3 26.6-14.2l13-19.5c5.9-8.9 15.9-14.2 26.6-14.2l126.9 0 0 96c0 26.5-21.5 48-48 48L48 512c-26.5 0-48-21.5-48-48l0-96z"],
    "rectangle-vertical": [384, 512, ["rectangle-portrait"], "f2fb", "M320 0c35.3 0 64 28.7 64 64l0 384c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64C0 28.7 28.7 0 64 0L320 0z"],
    "align-right": [448, 512, [], "f038", "M448 64c0 17.7-14.3 32-32 32L192 96c-17.7 0-32-14.3-32-32s14.3-32 32-32l224 0c17.7 0 32 14.3 32 32zm0 256c0 17.7-14.3 32-32 32l-224 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l224 0c17.7 0 32 14.3 32 32zM0 192c0-17.7 14.3-32 32-32l384 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 224c-17.7 0-32-14.3-32-32zM448 448c0 17.7-14.3 32-32 32L32 480c-17.7 0-32-14.3-32-32s14.3-32 32-32l384 0c17.7 0 32 14.3 32 32z"],
    "transporter-6": [576, 512, [], "e2a7", "M240-32c-8.8 0-16 7.2-16 16s7.2 16 16 16l96 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-96 0zM144 224c-8.8 0-16 7.2-16 16s7.2 16 16 16l288 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-288 0zm8 272c-13.3 0-24 10.7-24 24s10.7 24 24 24l272 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-272 0zM64 32L56.7 6.6C55.6 2.7 52.1 0 48 0s-7.6 2.7-8.7 6.6L32 32 6.6 39.3C2.7 40.4 0 43.9 0 48s2.7 7.6 6.6 8.7L32 64 39.3 89.4C40.4 93.3 43.9 96 48 96s7.6-2.7 8.7-6.6L64 64 89.4 56.7C93.3 55.6 96 52.1 96 48s-2.7-7.6-6.6-8.7L64 32zM536.7 358.6c-1.1-3.9-4.7-6.6-8.7-6.6s-7.6 2.7-8.7 6.6l-7.3 25.4-25.4 7.3c-3.9 1.1-6.6 4.7-6.6 8.7s2.7 7.6 6.6 8.7l25.4 7.3 7.3 25.4c1.1 3.9 4.7 6.6 8.7 6.6s7.6-2.7 8.7-6.6l7.3-25.4 25.4-7.3c3.9-1.1 6.6-4.7 6.6-8.7s-2.7-7.6-6.6-8.7l-25.4-7.3-7.3-25.4z"],
    "cable-car": [512, 512, [128673, 57551, "tram"], "f7da", "M288-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM160 24a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM32 288c0-35.3 28.7-64 64-64l136 0 0-96.2-193.4 55.3c-12.7 3.6-26-3.7-29.7-16.5s3.7-26 16.5-29.7l224-64 0 0 224-64c12.7-3.6 26 3.7 29.7 16.5s-3.7 26-16.5 29.7l-206.6 59 0 109.9 136 0c35.3 0 64 28.7 64 64l0 160c0 35.3-28.7 64-64 64L96 512c-35.3 0-64-28.7-64-64l0-160zm80 0c-8.8 0-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16l56 0 0-96-56 0zm184 96l0-96-80 0 0 96 80 0zm48 0l56 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16l-56 0 0 96z"],
    "kit-medical": [512, 512, ["first-aid"], "f479", "M64 64C28.7 64 0 92.7 0 128L0 384c0 35.3 28.7 64 64 64l16 0 0-384-16 0zm64 0l0 384 256 0 0-384-256 0zM448 448c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64l-16 0 0 384 16 0zM224 184c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 40 40 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-40 0 0 40c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-40-40 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l40 0 0-40z"],
    "grip-lines": [448, 512, [], "f7a4", "M32 288c-17.7 0-32 14.3-32 32s14.3 32 32 32l384 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 288zm0-128c-17.7 0-32 14.3-32 32s14.3 32 32 32l384 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 160z"],
    "burger": [512, 512, ["hamburger"], "f805", "M48 384c-8.8 0-16 7.2-16 16 0 44.2 35.8 80 80 80l288 0c44.2 0 80-35.8 80-80 0-8.8-7.2-16-16-16L48 384zM32 202c0 12.2 9.9 22 22 22L458 224c12.2 0 22-9.9 22-22 0-17.2-2.6-34.4-10.8-49.5-22.2-40.8-82.3-120.5-213.2-120.5S65 111.6 42.8 152.5C34.6 167.6 32 184.8 32 202zM0 304c0 17.7 14.3 32 32 32l448 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 272c-17.7 0-32 14.3-32 32zM256 72a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM120 128a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm248-24a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"],
    "raindrops": [448, 512, [], "f75c", "M102.4 101.6c-4.2 8.6-6.4 18-6.4 27.6 0 34.7 28.1 62.8 62.8 62.8l2.4 0c34.7 0 62.8-28.1 62.8-62.8 0-9.6-2.2-19-6.4-27.6L171.5 7.2C169.4 2.8 164.9 0 160 0s-9.4 2.8-11.5 7.2l-46.1 94.4zm-96 224C2.2 334.2 0 343.6 0 353.2 0 387.9 28.1 416 62.8 416l2.4 0c34.7 0 62.8-28.1 62.8-62.8 0-9.6-2.2-19-6.4-27.6L75.5 231.2c-2.1-4.4-6.6-7.2-11.5-7.2s-9.4 2.8-11.5 7.2L6.4 325.6zM307.8 166.8L210 326.2c-11.8 19.2-18 41.3-18 63.8 0 67.4 54.6 122 122 122l12 0c67.4 0 122-54.6 122-122 0-22.5-6.2-44.6-18-63.8L332.2 166.8c-2.6-4.2-7.2-6.8-12.2-6.8s-9.6 2.6-12.2 6.8z"],
    "snowman": [640, 512, [9731, 9924], "f7d0", "M403 211.7c32.2-24.9 53-63.9 53-107.7 0-75.1-60.9-136-136-136S184 28.9 184 104c0 43.9 20.8 82.9 53 107.7-32.2 16.3-59 41.8-76.8 73.1L112 264.2 112 224c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 19.6-22.5-9.7c-12.2-5.2-26.3 .4-31.5 12.6s.4 26.3 12.6 31.5c36.1 15.5 75.9 32.5 119.4 51.2-3.9 14.9-6 30.6-6 46.7 0 70 39.1 130.8 96.6 161.9 7.9 4.3 16.9 6.1 25.9 6.1l123 0c9 0 18-1.8 25.9-6.1 57.5-31.1 96.6-92 96.6-161.9 0-16.2-2.1-31.8-6-46.7 43.5-18.7 83.4-35.7 119.4-51.2 12.2-5.2 17.8-19.3 12.6-31.5s-19.3-17.8-31.5-12.6l-22.5 9.7 0-19.6c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 40.2-48.2 20.6c-17.9-31.3-44.6-56.8-76.8-73.1zM296 416a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm24-120a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM248 80a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM368 56a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM292.2 159.3c-2.7-4.8-4.2-10.2-4.2-15.7 0-17.5 14.2-31.6 31.6-31.6l.8 0c17.5 0 31.6 14.2 31.6 31.6 0 5.5-1.4 10.9-4.2 15.7L327 195.8c-3.1 5.4-10.8 5.4-13.9 0l-20.9-36.6z"],
    "hotel": [512, 512, [127976], "f594", "M16 24C16 10.7 26.7 0 40 0L472 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-8 0 0 416 8 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L40 512c-13.3 0-24-10.7-24-24s10.7-24 24-24l8 0 0-416-8 0C26.7 48 16 37.3 16 24zm208 88l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zM128 96c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0zm96 112l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zM352 96c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0zM112 208l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm240-16c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0zM288 384l43.8 0c9.9 0 17.5-9 14-18.2-13.8-36.1-48.8-61.8-89.7-61.8s-75.9 25.7-89.7 61.8c-3.5 9.2 4.1 18.2 14 18.2l43.8 0 0 80 64 0 0-80z"],
    "print": [512, 512, [128424, 128438, 9113], "f02f", "M64 64C64 28.7 92.7 0 128 0L341.5 0c17 0 33.3 6.7 45.3 18.7l42.5 42.5c12 12 18.7 28.3 18.7 45.3l0 37.5-384 0 0-80zM0 256c0-35.3 28.7-64 64-64l384 0c35.3 0 64 28.7 64 64l0 96c0 17.7-14.3 32-32 32l-32 0 0 64c0 35.3-28.7 64-64 64l-256 0c-35.3 0-64-28.7-64-64l0-64-32 0c-17.7 0-32-14.3-32-32l0-96zM128 416l0 32 256 0 0-96-256 0 0 64zM456 272a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"],
    "dial-min": [576, 512, [], "e161", "M288 0a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM400.9 401c-56.7 56.7-145.4 62-208 15.7L304.7 304.9c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0L158.9 382.8c-46.2-62.6-41-151.3 15.7-208 62.5-62.5 163.8-62.5 226.3 0s62.5 163.8 0 226.3zM512 288a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM32 256a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM64 96a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM480 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM64 480a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm416-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "circle-polish-zloty": [512, 512, [], "e700", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm95.4-360l0 77.4 10.6-4.2c8.2-3.3 17.5 .7 20.8 8.9s-.7 17.5-8.9 20.8l-22.5 9 0 96.1c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-76.9-9.5 3.8c-8.2 3.3-17.5-.7-20.8-8.9s.7-17.5 8.9-20.8l21.4-8.6 0-96.6c0-13.3 10.7-24 24-24s24 10.7 24 24zM128 216c0-13.3 10.7-24 24-24l96 0c8.7 0 16.7 4.7 20.9 12.3s4.1 16.8-.5 24.3L202.8 336 248 336c13.3 0 24 10.7 24 24s-10.7 24-24 24l-88 0c-8.7 0-16.7-4.7-20.9-12.3s-4.1-16.8 .5-24.3L205.2 240 152 240c-13.3 0-24-10.7-24-24z"],
    "family": [512, 512, [], "e300", "M128.1 0a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm-32 160l64 0c.4 0 .9 0 1.3 0-.9 5.2-1.3 10.5-1.3 16 0 21.6 7.1 41.6 19.2 57.6-31.1 23.4-51.2 60.5-51.2 102.4l0 16c0 30.5 12.2 58.2 32 78.4l0 49.6c0 9.6 1.7 18.8 4.8 27.3-6.3 3-13.3 4.7-20.8 4.7l-32 0c-26.5 0-48-21.5-48-48l0-120.6c-19.1-11.1-32-31.7-32-55.4l0-64c0-35.3 28.7-64 64-64zm272 352c-7.4 0-14.5-1.7-20.8-4.7 3.1-8.5 4.8-17.7 4.8-27.3l0-49.6c19.8-20.2 32-47.8 32-78.4l0-16c0-41.9-20.1-79-51.2-102.4 12.1-16 19.2-36 19.2-57.6 0-3.2-.2-6.4-.5-9.5 10.1-4.2 21.1-6.5 32.5-6.5 37.9 0 71.2 25.1 81.6 61.5l34.8 121.7c5.8 20.4-9.5 40.8-30.8 40.8l-21.6 0 0 80c0 26.5-21.5 48-48 48l-32 0zm16-512a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm-128 128a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm0 128c44.2 0 80 35.8 80 80l0 16c0 23.7-12.9 44.4-32 55.4l0 72.6c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-72.6c-19.1-11.1-32-31.7-32-55.4l0-16c0-44.2 35.8-80 80-80z"],
    "starfighter": [640, 512, [], "e037", "M354.6 21l29.4 235 0 224-128 0 0-224 29.4-235c1.5-12 11.7-21 23.8-21l21.6 0c12.1 0 22.3 9 23.8 21zM288 256l0 64 64 0 0-64c0-17.7-14.3-32-32-32s-32 14.3-32 32zM48 72c13.3 0 24 10.7 24 24l0 24c13.3 0 24 10.7 24 24s-10.7 24-24 24l0 184 56 0 0-40c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24l0 168c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-12.8-92.6-37c-4.4 6-11.4 9.8-19.4 9.8-13.3 0-24-10.7-24-24l0-248c-13.3 0-24-10.7-24-24s10.7-24 24-24l0-24c0-13.3 10.7-24 24-24zm544 0c13.3 0 24 10.7 24 24l0 24c13.3 0 24 10.7 24 24s-10.7 24-24 24l0 280c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-16-88 35.2 0 12.8c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-168c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24l0 40 56 0 0-184c-13.3 0-24-10.7-24-24s10.7-24 24-24l0-24c0-13.3 10.7-24 24-24z"],
    "cart-circle-arrow-down": [640, 512, [], "e3ef", "M24-16C10.7-16 0-5.3 0 8S10.7 32 24 32l45.3 0c3.9 0 7.2 2.8 7.9 6.6l52.1 286.3c6.2 34.2 36 59.1 70.8 59.1l104.6 0c1.4-16.7 4.9-32.8 10.3-48l-114.9 0c-11.6 0-21.5-8.3-23.6-19.7L171.3 288 340 288c34.9-48.5 91.7-80 156-80 15.8 0 31.2 1.9 46 5.5L568.9 69.9C572.6 50.2 557.5 32 537.4 32l-412.7 0-.4-2c-4.8-26.6-28-46-55.1-46L24-16zM208 512a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm288 32a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm67.3-147.3c6.2 6.2 6.2 16.4 0 22.6l-56 56c-6.2 6.2-16.4 6.2-22.6 0l-56-56c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l28.7 28.7 0-89.4c0-8.8 7.2-16 16-16s16 7.2 16 16l0 89.4 28.7-28.7c6.2-6.2 16.4-6.2 22.6 0z"],
    "message-medical": [512, 512, ["comment-alt-medical"], "f7f4", "M0 128L0 352c0 53 43 96 96 96l32 0 0 72c0 13.3 10.7 24 24 24 5.2 0 10.2-1.7 14.4-4.8l115.2-86.4c4.2-3.1 9.2-4.8 14.4-4.8l120 0c53 0 96-43 96-96l0-224c0-53-43-96-96-96L96 32C43 32 0 75 0 128zm217.6 25.6c0-10.6 8.6-19.2 19.2-19.2l38.4 0c10.6 0 19.2 8.6 19.2 19.2l0 48 48 0c10.6 0 19.2 8.6 19.2 19.2l0 38.4c0 10.6-8.6 19.2-19.2 19.2l-48 0 0 48c0 10.6-8.6 19.2-19.2 19.2l-38.4 0c-10.6 0-19.2-8.6-19.2-19.2l0-48-48 0c-10.6 0-19.2-8.6-19.2-19.2l0-38.4c0-10.6 8.6-19.2 19.2-19.2l48 0 0-48z"],
    "circle-arrow-down-right": [512, 512, [], "e0fa", "M256 0a256 256 0 1 0 0 512 256 256 0 1 0 0-512zm48 216c0-13.3 10.7-24 24-24s24 10.7 24 24l0 112c0 13.3-10.7 24-24 24l-112 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l54.1 0-103-103c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l103 103 0-54.1z"],
    "volleyball": [512, 512, [127952, "volleyball-ball"], "f45f", "M512 258.9c-23.4 8-47.8 13.1-72.6 15.1 5.9-98.6-30.7-191.1-94.9-258.3 97.8 36 167.5 130 167.5 240.3 0 1 0 1.9 0 2.9zm-5.9 52c-5.2 23.7-13.6 46.2-24.9 66.9-94.7 52.2-214 50-308.4-13.6 21.7-31.3 49.8-58.9 83.8-80.5 79.5 41.6 168.5 49.1 249.5 27.1zM279.7 241.6c-3.7-89.7-41.7-170.5-101.3-229.7 22.3-7.1 46-11.2 70.5-11.9 92.5 55.9 150.3 160.3 142.4 273.8-38-3.2-75.9-13.7-111.6-32.3zM130.5 32.8C149.1 49.1 165.8 67.7 179.9 88.2 91.5 132.3 29.7 210.3 3.7 299.5 1.3 285.3 0 270.8 0 256 0 160.2 52.6 76.7 130.5 32.8zm73.4 97c16.3 34.5 26.1 72.6 27.9 112.8-75.8 48-126.8 121.3-148.3 202.5-17.6-16.1-33-34.6-45.5-55 2.1-108.1 63.7-210.4 165.9-260.3zM256 512c-47.7 0-92.3-13-130.5-35.7 4.8-24.3 12.6-48 23.2-70.4 82.4 54.4 180.8 68.9 271 47-44.4 37-101.5 59.2-163.7 59.2z"],
    "arrow-turn-down-right": [512, 512, [], "e3d6", "M64 96c0-17.7-14.3-32-32-32S0 78.3 0 96l0 96c0 53 43 96 96 96l306.7 0-73.4 73.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l128-128c12.5-12.5 12.5-32.8 0-45.3l-128-128c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L402.7 224 96 224c-17.7 0-32-14.3-32-32l0-96z"],
    "traffic-light": [320, 512, [128678], "f637", "M64-32C28.7-32 0-3.3 0 32L0 384c0 88.4 71.6 160 160 160s160-71.6 160-160l0-352c0-35.3-28.7-64-64-64L64-32zm96 392c30.9 0 56 25.1 56 56s-25.1 56-56 56-56-25.1-56-56 25.1-56 56-56zm56-104a56 56 0 1 1 -112 0 56 56 0 1 1 112 0zM160 152a56 56 0 1 1 0-112 56 56 0 1 1 0 112z"],
    "plane-circle-check": [640, 512, [], "e555", "M232 24c0-30.9 25.1-56 56-56s56 25.1 56 56l0 127.3 78 71.5c-69.3 29-118 97.4-118 177.2 0 49.3 18.6 94.3 49.1 128.3L288 512 179.9 539c-10.1 2.5-19.9-5.1-19.9-15.5l0-19.8c0-4.9 2.2-9.5 6-12.5l66-52.8 0-99.7-162.9 54.3C58.7 396.4 48 388.7 48 377.8l0-43.7c0-9 3.8-17.5 10.4-23.6L232 151.3 232 24zM352 400a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm201.4-60.9c-7.1-5.2-17.2-3.6-22.4 3.5l-53 72.9-26.8-26.8c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l40 40c3.3 3.3 7.9 5 12.6 4.6s8.9-2.8 11.7-6.5l64-88c5.2-7.1 3.6-17.2-3.5-22.3z"],
    "square-peso": [448, 512, [], "e71a", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm72 112c0-13.3 10.7-24 24-24l64 0c43.3 0 80.4 26.4 96 64l16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-8.3 0c.4 5.3 .4 10.7 0 16l8.3 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0c-15.7 37.6-52.8 64-96 64l-40 0 0 40c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-104-8 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l8 0 0-16-8 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l8 0 0-40zm88 24l-40 0 0 16 79.2 0c-10.1-9.9-23.9-16-39.2-16zm-40 64l95.4 0c.4-2.6 .6-5.3 .6-8s-.2-5.4-.6-8l-95.4 0 0 16zm0 32l0 16 40 0c15.3 0 29.1-6.1 39.2-16L184 264z"],
    "house-water": [640, 512, ["house-flood"], "f74f", "M531.9 272l-19.9 0 0 94.4c-21-9.7-43.5-14.5-66-14.4-32.5 .2-64.9 10.7-92.4 31.4-22.1 16.6-29.1 16.6-51.2 0-28.1-21.1-61.3-31.6-94.4-31.4-27.7 .2-55.4 7.8-80 23l0-103-19.9 0c-15.5 0-28.1-12.6-28.1-28.1 0-7.6 3.1-14.9 8.6-20.2L292.5 27.1C299.9 20 309.7 16 320 16s20.1 4 27.5 11.1L551.4 223.7c5.5 5.3 8.6 12.6 8.6 20.2 0 15.5-12.6 28.1-28.1 28.1zM296 224c-13.3 0-24 10.7-24 24l0 48c0 13.3 10.7 24 24 24l48 0c13.3 0 24-10.7 24-24l0-48c0-13.3-10.7-24-24-24l-48 0zM403.4 476.1C379.1 494.3 351.1 512 320 512s-59.1-17.7-83.4-35.9c-21.3-16.1-49.9-16.1-71.2 0-23.8 17.9-54.1 35.5-88.1 35.3-20.4-.1-40.7-6.7-59.8-21.1-10.6-8-12.7-23-4.7-33.6s23-12.7 33.6-4.7c11.3 8.5 21.6 11.4 31.2 11.5 17.6 .1 37.3-9.4 58.9-25.7 38.4-29 90.5-29 129 0 24 18.1 40.7 26.3 54.5 26.3s30.5-8.2 54.5-26.3c38.4-29 90.5-29 129 0 16.9 12.7 32.9 21.5 47.8 24.6 13.7 2.8 27.4 .9 42.3-10.3 10.6-8 25.6-5.9 33.6 4.7s5.9 25.6-4.7 33.6c-26.4 19.9-54.2 24.4-80.7 19.1-25.3-5.1-48.1-18.9-67.2-33.3-21.3-16.1-49.9-16.1-71.2 0z"],
    "users": [640, 512, [], "f0c0", "M320 16a104 104 0 1 1 0 208 104 104 0 1 1 0-208zM96 88a72 72 0 1 1 0 144 72 72 0 1 1 0-144zM0 416c0-70.7 57.3-128 128-128 12.8 0 25.2 1.9 36.9 5.4-32.9 36.8-52.9 85.4-52.9 138.6l0 16c0 11.4 2.4 22.2 6.7 32L32 480c-17.7 0-32-14.3-32-32l0-32zm521.3 64c4.3-9.8 6.7-20.6 6.7-32l0-16c0-53.2-20-101.8-52.9-138.6 11.7-3.5 24.1-5.4 36.9-5.4 70.7 0 128 57.3 128 128l0 32c0 17.7-14.3 32-32 32l-86.7 0zM472 160a72 72 0 1 1 144 0 72 72 0 1 1 -144 0zM160 432c0-88.4 71.6-160 160-160s160 71.6 160 160l0 16c0 17.7-14.3 32-32 32l-256 0c-17.7 0-32-14.3-32-32l0-16z"],
    "certificate": [576, 512, [], "f0a3", "M239.2-8c-6.1-6.2-15-8.7-23.4-6.4S200.9-5.6 198.8 2.8L183.5 63c-1.1 4.4-5.6 7-9.9 5.7L113.8 51.9c-8.4-2.4-17.4 0-23.5 6.1s-8.5 15.1-6.1 23.5l16.9 59.8c1.2 4.3-1.4 8.8-5.7 9.9L35.1 166.5c-8.4 2.1-15 8.7-17.3 17.1s.2 17.3 6.4 23.4l44.5 43.3c3.2 3.1 3.2 8.3 0 11.5L24.3 305.1c-6.2 6.1-8.7 15-6.4 23.4s8.9 14.9 17.3 17.1l60.2 15.3c4.4 1.1 7 5.6 5.7 9.9L84.2 430.5c-2.4 8.4 0 17.4 6.1 23.5s15.1 8.5 23.5 6.1l59.8-16.9c4.3-1.2 8.8 1.4 9.9 5.7l15.3 60.2c2.1 8.4 8.7 15 17.1 17.3s17.3-.2 23.4-6.4l43.3-44.5c3.1-3.2 8.3-3.2 11.5 0L337.3 520c6.1 6.2 15 8.7 23.4 6.4s14.9-8.9 17.1-17.3L393.1 449c1.1-4.4 5.6-7 9.9-5.7l59.8 16.9c8.4 2.4 17.4 0 23.5-6.1s8.5-15.1 6.1-23.5l-16.9-59.8c-1.2-4.3 1.4-8.8 5.7-9.9l60.2-15.3c8.4-2.1 15-8.7 17.3-17.1s-.2-17.4-6.4-23.4l-44.5-43.3c-3.2-3.1-3.2-8.3 0-11.5l44.5-43.3c6.2-6.1 8.7-15 6.4-23.4s-8.9-14.9-17.3-17.1l-60.2-15.3c-4.4-1.1-7-5.6-5.7-9.9l16.9-59.8c2.4-8.4 0-17.4-6.1-23.5s-15.1-8.5-23.5-6.1L403 68.8c-4.3 1.2-8.8-1.4-9.9-5.7L377.8 2.8c-2.1-8.4-8.7-15-17.1-17.3s-17.3 .2-23.4 6.4L294 36.5c-3.1 3.2-8.3 3.2-11.5 0L239.2-8z"],
    "alarm-clock": [512, 512, [9200], "f34e", "M504.4 132.5c-4.5 10.5-18.4 9.8-24.9 .4-27.8-40-66.1-72.2-111-92.6-10.4-4.7-13.7-18.3-4.1-24.6 15-9.9 33-15.7 52.3-15.7 52.6 0 95.2 42.6 95.2 95.2 0 13.2-2.7 25.8-7.6 37.3zm-471.9 .4c-6.5 9.4-20.5 10.1-24.9-.4-4.9-11.5-7.6-24.1-7.6-37.3 0-52.6 42.6-95.2 95.2-95.2 19.3 0 37.3 5.8 52.3 15.7 9.6 6.3 6.3 19.9-4.1 24.6-44.8 20.4-83.1 52.6-111 92.6zM390.2 467.4C352.8 495.4 306.3 512 256 512s-96.8-16.6-134.1-44.6L86.6 502.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l35.2-35.2C48.6 384.8 32 338.3 32 288 32 164.3 132.3 64 256 64S480 164.3 480 288c0 50.3-16.6 96.8-44.6 134.2l35.2 35.2c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0l-35.2-35.2zM280 184c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 104c0 6.4 2.5 12.5 7 17l56 56c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-49-49 0-94.1z"],
    "helicopter-symbol": [512, 512, [], "e502", "M445.4 224l64.7 0C495.6 108.2 403.8 16.4 288 2l0 64.7C368.4 80.1 431.9 143.6 445.4 224zM510 288l-64.7 0C431.9 368.4 368.4 431.9 288 445.3l0 64.7c115.8-14.4 207.6-106.2 222-222zM2 288C16.4 403.8 108.2 495.6 224 510l0-64.7C143.6 431.9 80.2 368.4 66.7 288L2 288zm0-64l64.7 0C80.2 143.6 143.6 80.1 224 66.7L224 2C108.2 16.4 16.4 108.2 2 224zm206-64c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 192c0 17.7 14.3 32 32 32s32-14.3 32-32l0-64 96 0 0 64c0 17.7 14.3 32 32 32s32-14.3 32-32l0-192c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 64-96 0 0-64z"],
    "house-chimney-crack": [512, 512, ["house-damage"], "f6f1", "M234.2 8.6c12.3-11.4 31.3-11.4 43.5 0L368 92.3 368 80c0-17.7 14.3-32 32-32l32 0c17.7 0 32 14.3 32 32l0 101.5 37.8 35.1c9.6 9 12.8 22.9 8 35.1S493.2 272 480 272l-16 0 0 176c0 35.3-28.7 64-64 64l-105.6 0-38.4-64 80.8-67.3c7.8-6.5 7.6-18.6-.4-24.9L218.6 263.2c-14.6-11.5-33.8 7-22.8 22L256 368 170.5 439.2c-6.1 5-7.5 13.8-3.5 20.5l31.3 52.2-86.4 0c-35.3 0-64-28.7-64-64l0-176-16 0c-13.2 0-25-8.1-29.8-20.3s-1.6-26.2 8-35.1l224-208z"],
    "dryer-heat": [448, 512, ["dryer-alt"], "f862", "M64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-384c0-35.3-28.7-64-64-64L64 0zM224 160a144 144 0 1 1 0 288 144 144 0 1 1 0-288zM72 96a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM192 72a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM179.3 212.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6L177.4 256c4.2 4.2 6.6 10 6.6 16s-2.4 11.8-6.6 16l-9.4 9.4c-10.2 10.2-16 24.1-16 38.6s5.8 28.4 16 38.6l20.7 20.7c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L190.6 352c-4.2-4.2-6.6-10-6.6-16s2.4-11.8 6.6-16l9.4-9.4c10.2-10.2 16-24.1 16-38.6s-5.8-28.4-16-38.6l-20.7-20.7zm80 0c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6L257.4 256c4.2 4.2 6.6 10 6.6 16s-2.4 11.8-6.6 16l-9.4 9.4c-10.2 10.2-16 24.1-16 38.6s5.8 28.4 16 38.6l20.7 20.7c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L270.6 352c-4.2-4.2-6.6-10-6.6-16s2.4-11.8 6.6-16l9.4-9.4c10.2-10.2 16-24.1 16-38.6s-5.8-28.4-16-38.6l-20.7-20.7z"],
    "bring-forward": [512, 512, [], "f856", "M224 448l224 0 0-224-48 0 0-64 48 0c35.3 0 64 28.7 64 64l0 224c0 35.3-28.7 64-64 64l-224 0c-35.3 0-64-28.7-64-64l0-48 64 0 0 48zm64-96L64 352c-35.3 0-64-28.7-64-64L0 64C0 28.7 28.7 0 64 0L288 0c35.3 0 64 28.7 64 64l0 224c0 35.3-28.7 64-64 64z"],
    "dial-low": [576, 512, [], "e15d", "M288 0a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm-.4 447.6c-80.2 0-146.6-59-158.2-136l158.2 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-158.2 0c11.6-77 78-136 158.2-136 88.4 0 160 71.6 160 160s-71.6 160-160 160zM512 288a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM32 256a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM64 96a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM480 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM64 480a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm416-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "circle-wifi-circle-wifi": [640, 512, ["circle-wifi-group"], "e67e", "M288 512c16.7 0 33-1.6 48.8-4.6-20.7-30.6-32.8-67.6-32.8-107.4 0-1.4 0-2.9 0-4.3-4.7 2.7-10.2 4.3-16 4.3-17.7 0-32-14.3-32-32s14.3-32 32-32c9.3 0 17.7 4 23.6 10.4 4.8-16.5 11.8-32.2 20.6-46.5-13-7.5-28-11.9-44.1-11.9-22.7 0-43.4 8.6-59 22.7-9.8 8.9-25 8.1-33.9-1.7s-8.1-25 1.7-33.9c24.1-21.8 56.1-35.1 91.2-35.1 27.4 0 53 8.1 74.4 22.1 12.5-12.1 26.6-22.5 42-30.9-32.3-24.6-72.6-39.3-116.3-39.3-49.4 0-94.4 18.6-128.5 49.3-9.8 8.9-25 8.1-33.9-1.8s-8.1-25 1.8-33.9C169.9 167.3 226.3 144 288 144s118.1 23.3 160.6 61.6c2.3 2 4.1 4.4 5.4 7 13.5-3 27.6-4.6 42-4.6 15.3 0 30.2 1.8 44.4 5.2-20.4-121-125.6-213.2-252.4-213.2-141.4 0-256 114.6-256 256S146.6 512 288 512zM640 400a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zM496 352c-27.2 0-51.9 10.2-70.6 27.1-6.6 5.9-16.7 5.4-22.6-1.2s-5.4-16.7 1.2-22.6c24.4-21.9 56.6-35.3 92-35.3s67.7 13.4 92 35.3c6.6 5.9 7.1 16 1.2 22.6s-16 7.1-22.6 1.2C547.9 362.2 523.2 352 496 352zM476 464a20 20 0 1 1 40 0 20 20 0 1 1 -40 0zm-11.5-35.9c-6.6 5.9-16.7 5.4-22.6-1.1s-5.4-16.7 1.1-22.6c14-12.7 32.6-20.4 53-20.4s39 7.7 53 20.4c6.6 5.9 7.1 16 1.1 22.6s-16 7.1-22.6 1.1c-8.3-7.5-19.4-12.1-31.5-12.1s-23.2 4.6-31.5 12.1z"],
    "display-medical": [512, 512, ["desktop-medical"], "e166", "M64 96l0 256 384 0 0-256-384 0zM0 96C0 60.7 28.7 32 64 32l384 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64l-144 0 16 48 72 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-272 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l72 0 16-48-144 0c-35.3 0-64-28.7-64-64L0 96zm224 56c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 40 40 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-40 0 0 40c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-40-40 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l40 0 0-40z"],
    "person-military-pointing": [512, 512, [], "e54a", "M214.9 14.1C202 15.2 192 26 192 39 192 52.8 203.2 64 217 64l151 0c8.8 0 16-7.2 16-16l0-30.6C384 8 376 .7 366.7 1.4L214.9 14.1zM208 112c0 44.2 35.8 80 80 80s80-35.8 80-80c0-5.5-.6-10.8-1.6-16L209.6 96c-1 5.2-1.6 10.5-1.6 16zM40 224c-22.1 0-40 17.9-40 40s17.9 40 40 40l152 0 0 89.4 162.8-162.8c-13.3-4.3-27.3-6.5-41.6-6.5L40 224zm345.7 20.9l-171.1 171.1 169.4 0 0-46.3 53.6 90.6c11.2 19 35.8 25.3 54.8 14.1s25.3-35.8 14.1-54.8L430.3 290.8c-11.2-19-26.6-34.5-44.6-45.9zM192 448l0 32c0 17.7 14.3 32 32 32l128 0c17.7 0 32-14.3 32-32l0-32-192 0z"],
    "database": [448, 512, [], "f1c0", "M448 205.8c-14.8 9.8-31.8 17.7-49.5 24-47 16.8-108.7 26.2-174.5 26.2S96.4 246.5 49.5 229.8c-17.6-6.3-34.7-14.2-49.5-24L0 288c0 44.2 100.3 80 224 80s224-35.8 224-80l0-82.2zm0-77.8l0-48C448 35.8 347.7 0 224 0S0 35.8 0 80l0 48c0 44.2 100.3 80 224 80s224-35.8 224-80zM398.5 389.8C351.6 406.5 289.9 416 224 416S96.4 406.5 49.5 389.8c-17.6-6.3-34.7-14.2-49.5-24L0 432c0 44.2 100.3 80 224 80s224-35.8 224-80l0-66.2c-14.8 9.8-31.8 17.7-49.5 24z"],
    "newspaper": [512, 512, [128240], "f1ea", "M0 416L0 120c0-13.3 10.7-24 24-24s24 10.7 24 24l0 288c0 13.3 10.7 24 24 24s24-10.7 24-24L96 96c0-35.3 28.7-64 64-64l288 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64zM160 128l0 64c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-64 0c-17.7 0-32 14.3-32 32zm24 240c-13.3 0-24 10.7-24 24s10.7 24 24 24l240 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-240 0zm-24-72c0 13.3 10.7 24 24 24l240 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-240 0c-13.3 0-24 10.7-24 24zM360 176c-13.3 0-24 10.7-24 24s10.7 24 24 24l64 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-64 0z"],
    "cloud-rain": [512, 512, [127783, 9926], "f73d", "M96 320c-53 0-96-43-96-96 0-42.5 27.6-78.6 65.9-91.2-1.3-6.7-1.9-13.7-1.9-20.8 0-61.9 50.1-112 112-112 43.1 0 80.5 24.3 99.2 60 14.7-17.1 36.5-28 60.8-28 44.2 0 80 35.8 80 80 0 5.5-.6 10.8-1.6 16 .5 0 1.1 0 1.6 0 53 0 96 43 96 96s-43 96-96 96L96 320zm1.6 68.2c1.1-2.5 3.6-4.2 6.4-4.2s5.3 1.6 6.4 4.2l30.2 68.2c2.2 5.1 3.4 10.5 3.4 16 0 21.9-18.1 39.6-40 39.6s-40-17.7-40-39.6c0-5.5 1.2-11 3.4-16l30.2-68.2zm152 0c1.1-2.5 3.6-4.2 6.4-4.2s5.3 1.6 6.4 4.2l30.2 68.2c2.2 5.1 3.4 10.5 3.4 16 0 21.9-18.1 39.6-40 39.6s-40-17.7-40-39.6c0-5.5 1.2-11 3.4-16l30.2-68.2zm121.8 68.2l30.2-68.2c1.1-2.5 3.6-4.2 6.4-4.2s5.3 1.6 6.4 4.2l30.2 68.2c2.2 5.1 3.4 10.5 3.4 16 0 21.9-18.1 39.6-40 39.6s-40-17.7-40-39.6c0-5.5 1.2-11 3.4-16z"],
    "signal-strong": [512, 512, ["signal-4"], "f68f", "M384 152c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 304c0 13.3 10.7 24 24 24s24-10.7 24-24l0-304zM256 224c-13.3 0-24 10.7-24 24l0 208c0 13.3 10.7 24 24 24s24-10.7 24-24l0-208c0-13.3-10.7-24-24-24zM176 344c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 112c0 13.3 10.7 24 24 24s24-10.7 24-24l0-112zM72 408c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 48c0 13.3 10.7 24 24 24s24-10.7 24-24l0-48z"],
    "maximize": [448, 512, ["expand-arrows-alt"], "f31e", "M168 32L24 32C10.7 32 0 42.7 0 56L0 200c0 9.7 5.8 18.5 14.8 22.2S34.1 223.8 41 217l40-40 79 79-79 79-40-40c-6.9-6.9-17.2-8.9-26.2-5.2S0 302.3 0 312L0 456c0 13.3 10.7 24 24 24l144 0c9.7 0 18.5-5.8 22.2-14.8s1.7-19.3-5.2-26.2l-40-40 79-79 79 79-40 40c-6.9 6.9-8.9 17.2-5.2 26.2S270.3 480 280 480l144 0c13.3 0 24-10.7 24-24l0-144c0-9.7-5.8-18.5-14.8-22.2s-19.3-1.7-26.2 5.2l-40 40-79-79 79-79 40 40c6.9 6.9 17.2 8.9 26.2 5.2S448 209.7 448 200l0-144c0-13.3-10.7-24-24-24L280 32c-9.7 0-18.5 5.8-22.2 14.8S256.2 66.1 263 73l40 40-79 79-79-79 40-40c6.9-6.9 8.9-17.2 5.2-26.2S177.7 32 168 32z"],
    "location-arrow": [512, 512, [], "f124", "M477.9 75.5c4.5-11.8 1.7-25.2-7.2-34.1s-22.3-11.8-34.1-7.2l-416 160C7.9 199-.3 211.2 0 224.7s9.1 25.4 21.9 29.6l176.8 58.9 58.9 176.8c4.3 12.8 16.1 21.6 29.6 21.9s25.7-7.9 30.6-20.5l160-416z"],
    "city": [576, 512, [127961], "f64f", "M320 0c-35.3 0-64 28.7-64 64l0 32-48 0 0-72c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 72-64 0 0-72C96 10.7 85.3 0 72 0S48 10.7 48 24l0 74c-27.6 7.1-48 32.2-48 62L0 448c0 35.3 28.7 64 64 64l448 0c35.3 0 64-28.7 64-64l0-192c0-35.3-28.7-64-64-64l-64 0 0-128c0-35.3-28.7-64-64-64L320 0zm64 112l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16zm-16 80c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l32 0zm16 112l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16zm112-16c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l32 0zM256 304l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16zM240 192c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l32 0zM128 304l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16zM112 192c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l32 0z"],
    "rectangle-code": [512, 512, [], "e322", "M0 128C0 92.7 28.7 64 64 64l384 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64L64 448c-35.3 0-64-28.7-64-64L0 128zm295 31c-9.4 9.4-9.4 24.6 0 33.9l63 63-63 63c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l80-80c9.4-9.4 9.4-24.6 0-33.9l-80-80c-9.4-9.4-24.6-9.4-33.9 0zM217 193c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-80 80c-9.4 9.4-9.4 24.6 0 33.9l80 80c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-63-63 63-63z"],
    "toilet-paper-check": [512, 512, [], "e5b2", "M327.1 32C318.3 43.1 311 55.1 305.2 66.8 283.8 109.5 272 165.1 272 224l0 264c0 30.9-25.1 56-56 56L56 544c-30.9 0-56-25.1-56-56L0 224C0 118 43 32 96 32l231.1 0zM416 32c53 0 96 86 96 192s-43 192-96 192-96-86-96-192 43-192 96-192zM206.2 154.6c-10.7-7.8-25.7-5.4-33.5 5.3l-59.3 81.6-16.1-16.6c-9.2-9.5-24.4-9.8-33.9-.6-9.5 9.2-9.8 24.4-.6 33.9l35.9 37.2c4.9 5.1 11.9 7.8 18.9 7.3 7.1-.5 13.6-4.1 17.8-9.8l76.1-104.7c7.8-10.7 5.4-25.7-5.3-33.5zM416 160c-17.7 0-32 28.7-32 64s14.3 64 32 64 32-28.7 32-64-14.3-64-32-64z"],
    "seal-question": [512, 512, [], "e243", "M222.2 17.9C241-.8 271.3-.8 290.1 17.9l46.1 46.1 64 0c26.5 0 48 21.5 48 48l0 64 45.6 45.6c18.7 18.7 18.7 49.1 0 67.9l-45.6 45.6 0 64.9c0 26.5-21.5 48-48 48l-64.9 0-45.1 45.1c-18.7 18.7-49.1 18.7-67.9 0l-45.1-45.1-64.9 0c-26.5 0-48-21.5-48-48l0-64.9-45.6-45.6c-18.7-18.7-18.7-49.1 0-67.9l45.6-45.6 0-64c0-26.5 21.5-48 48-48l64 0 46.1-46.1zM256.1 184c16.1 0 29.2 13.1 29.2 29.2 0 8.7-3.1 13.9-6.9 17.7-4.5 4.4-10.7 7.5-16.8 9.5-14.9 5-29.5 19.3-29.5 39.5 0 13.3 10.7 24 24 24 11.5 0 21.2-8.1 23.5-19 19.2-7.1 53.7-26.3 53.7-71.8 0-42.6-34.6-77.2-77.2-77.2s-77.2 34.6-77.2 77.2c0 13.3 10.7 24 24 24s24-10.7 24-24c0-16.1 13.1-29.2 29.2-29.2zm28 168a28 28 0 1 0 -56 0 28 28 0 1 0 56 0z"],
    "x-ray": [512, 512, [], "f497", "M0 64C0 46.3 14.3 32 32 32l448 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l0 320c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 480c-17.7 0-32-14.3-32-32s14.3-32 32-32L32 96C14.3 96 0 81.7 0 64zm280 56c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 16-64 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l64 0 0 48-80 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l80 0 0 48-64 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l64 0 0 16c0 13.3 10.7 24 24 24s24-10.7 24-24l0-16 64 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-64 0 0-48 80 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0 0-48 64 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-64 0 0-16z"],
    "umbrella-beach": [512, 512, [127958], "f5ca", "M497.5 341.1c-5.9 16.7-25.3 23-41.1 15.1l-178.2-89.1-1.6 3.2-88.8 177.7 292.2 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 512c-17.7 0-32-14.3-32-32s14.3-32 32-32l84.2 0 103.2-206.3 1.6-3.2-165.4-82.7c-15.8-7.9-22.4-27.3-12.5-42 45.9-68.6 124.1-113.8 212.9-113.8 141.4 0 256 114.6 256 256 0 29.8-5.1 58.5-14.5 85.1z"],
    "arrow-right-to-bracket": [512, 512, ["sign-in"], "f090", "M352 96l64 0c17.7 0 32 14.3 32 32l0 256c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l64 0c53 0 96-43 96-96l0-256c0-53-43-96-96-96l-64 0c-17.7 0-32 14.3-32 32s14.3 32 32 32zm-9.4 182.6c12.5-12.5 12.5-32.8 0-45.3l-128-128c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L242.7 224 32 224c-17.7 0-32 14.3-32 32s14.3 32 32 32l210.7 0-73.4 73.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l128-128z"],
    "headset": [448, 512, [], "f590", "M224 64c-79 0-144.7 57.3-157.7 132.7 9.3-3 19.3-4.7 29.7-4.7l16 0c26.5 0 48 21.5 48 48l0 96c0 26.5-21.5 48-48 48l-16 0c-53 0-96-43-96-96l0-64C0 100.3 100.3 0 224 0S448 100.3 448 224l0 168.1c0 66.3-53.8 120-120.1 120l-87.9-.1-32 0c-26.5 0-48-21.5-48-48s21.5-48 48-48l32 0c26.5 0 48 21.5 48 48l0 0 40 0c39.8 0 72-32.2 72-72l0-20.9c-14.1 8.2-30.5 12.8-48 12.8l-16 0c-26.5 0-48-21.5-48-48l0-96c0-26.5 21.5-48 48-48l16 0c10.4 0 20.3 1.6 29.7 4.7-13-75.3-78.6-132.7-157.7-132.7z"],
    "thumbtack-angle-slash": [576, 512, [], "e752", "M41-24.9c-9.4-9.4-24.6-9.4-33.9 0S-2.3-.3 7 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-186.5-186.5 96.4-112.5 10.5 10.5c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-160-160c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L339.9 65.1 227.4 161.5 41-24.9zm62.6 198.3l-1.4 .7-2.8 1.4C90.1 180.1 83.7 188.8 82 199s1.7 20.5 9 27.8L317.3 453c7.3 7.3 17.6 10.6 27.8 9s18.9-8.1 23.5-17.3l1.4-2.8 .7-1.4-267.1-267.1zm-62.2 284c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l106.2-106.2-45.3-45.3-106.2 106.2z"],
    "camera-polaroid": [576, 512, [], "f8aa", "M64 96c0-35.3 28.7-64 64-64l320 0c35.3 0 64 28.7 64 64l0 150.3 53.3 79.9c7 10.5 10.7 22.9 10.7 35.5l0 54.3c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64l0-54.3c0-12.6 3.7-25 10.7-35.5L64 246.3 64 96zM288 256a64 64 0 1 0 0-128 64 64 0 1 0 0 128zM448 128a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM120 352c-13.3 0-24 10.7-24 24s10.7 24 24 24l336 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-336 0z"],
    "face-saluting": [640, 512, [129761], "e484", "M230.7-38.6c12.5 12.5 12.5 32.8 0 45.3l-128.5 128.5 26.2 27.3 41.1-41.1c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3l-54.1 54.1c-31.2 31.2-81.9 31.2-113.1 0l-4.1-4.1c-31.2-31.2-31.2-81.9 0-113.1L185.5-38.6c12.5-12.5 32.8-12.5 45.3 0zM352.1 512c-129.2 0-236-95.7-253.5-220 34.6 1.5 69.6-11 96-37.4l45.5-45.5c.6 17.2 14.7 30.9 32 30.9 17.7 0 32-14.3 32-32s-14.3-32-32-32c-2.4 0-4.7 .3-7 .8 13.2-29.4 7.7-65.2-16.4-89.3-5.3-5.3-11.3-9.8-17.5-13.3l33.6-33.6c9.1-9.1 15.6-19.9 19.4-31.4 21.7-6 44.5-9.1 68-9.1 141.4 0 256 114.6 256 256s-114.6 256-256 256zM261.5 321.9c-7.8-10.7-22.8-13.1-33.5-5.3s-13.1 22.8-5.3 33.5C251.8 390 298.9 416 352.1 416s100.3-26 129.4-65.9c7.8-10.7 5.4-25.7-5.3-33.5s-25.7-5.4-33.5 5.3c-20.4 28-53.4 46.1-90.6 46.1s-70.2-18.1-90.6-46.1zM432.1 240a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "hand-horns": [384, 512, [], "e1a9", "M32 32C32 14.3 46.3 0 64 0S96 14.3 96 32l0 208-64 0 0-208zM224 192c0-17.7 14.3-32 32-32s32 14.3 32 32l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64zm-64-64c17.7 0 32 14.3 32 32l0 48c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-48c0-17.7 14.3-32 32-32zM320 96c0-17.7 14.3-32 32-32s32 14.3 32 32l0 256c0 88.4-71.6 160-160 160l-61.7 0c-42.4 0-83.1-16.9-113.1-46.9L37.5 453.5C13.5 429.5 0 396.9 0 363l0-27c0-35.3 28.7-64 64-64l88 0c22.1 0 40 17.9 40 40s-17.9 40-40 40l-56 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l56 0c39.8 0 72-32.2 72-72l0-.6c9.4 5.4 20.3 8.6 32 8.6 35.3 0 64-28.7 64-64l0-160z"],
    "file-exclamation": [384, 512, [], "f31a", "M213.5 0c17 0 33.2 6.8 45.2 18.8L365.3 125.2c12 12 18.7 28.3 18.7 45.2L384 448c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64C0 28.7 28.7 0 64 0L213.5 0zM192 400c-17.7 0-32 14.3-32 32s14.3 32 32 32 32-14.3 32-32-14.3-32-32-32zm0-176c-18.3 0-32.8 15.7-31.2 34l7.3 88c1 12.4 11.4 22 23.9 22s22.9-9.6 23.9-22l7.3-88c1.5-18.3-12.9-34-31.3-34zm16-72c0 13.3 10.7 24 24 24l93.5 0-117.5-117.5 0 93.5z"],
    "head-side-circuit": [512, 512, [], "e75e", "M67.5 63.8C25.8 104.4 0 161.2 0 224 0 278 19.1 327.5 50.9 366.2 58.9 375.9 64 387.8 64 400.4L64 464c0 26.5 21.5 48 48 48l160 0c26.5 0 48-21.5 48-48l0-7.2c0-5.1 4.5-8.8 9.7-8.8l38.3 0c35.3 0 64-28.7 64-64l0-48c0-8.8 7.2-16 16-16l1 0c26 0 47-21 47-47 0-11-3.9-21.6-10.9-30.1L449.3 200c-2-2.4-3.2-5.3-3.6-8.3-7.2-49.8-30.8-94.4-65.2-127.9L352.9 91.4c-8.2 8.3-12.9 19.4-12.9 31.1l0 34.8c12 6.9 20 19.8 20 34.6 0 22.1-17.9 40-40 40s-40-17.9-40-40c0-14.8 8-27.7 20-34.6l0-34.8c0-22.3 8.9-43.6 24.6-59.4l24.8-24.8C318.8 17.6 282.8 4.3 244 .9l0 92.5c12 6.9 20 19.8 20 34.6 0 22.1-17.9 40-40 40s-40-17.9-40-40c0-14.8 8-27.7 20-34.6L204 .9C165.2 4.3 129.2 17.6 98.6 38.3l24.8 24.8c15.8 15.8 24.6 37.1 24.6 59.4l0 34.8c12 6.9 20 19.8 20 34.6 0 22.1-17.9 40-40 40s-40-17.9-40-40c0-14.8 8-27.7 20-34.6l0-34.8c0-11.7-4.6-22.9-12.9-31.1L67.5 63.8zM184 256a40 40 0 1 1 80 0 40 40 0 1 1 -80 0z"],
    "pipe-circle-check": [576, 512, [], "e436", "M64 96c17.7 0 32 14.3 32 32l384 0c0-17.7 14.3-32 32-32s32 14.3 32 32l0 116c-31.5-22.7-70.2-36-112-36-100.6 0-183.2 77.4-191.3 176L96 384c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-256c0-17.7 14.3-32 32-32zM288 400a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm201.4-60.9c-7.1-5.2-17.2-3.6-22.4 3.5l-53 72.9-26.8-26.8c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l40 40c3.3 3.3 7.9 5 12.6 4.6s8.9-2.8 11.7-6.5l64-88c5.2-7.1 3.6-17.2-3.5-22.3z"],
    "splotch": [512, 512, [], "f5bc", "M208.5 62.3l28.1-36.9C248.8 9.4 267.8 0 288 0 316.5 0 341.6 18.7 349.8 46l17.8 59.4c10.3 34.4 36.1 62 69.8 74.6l39.8 14.9c20.9 7.9 34.8 27.9 34.8 50.2 0 16.9-7.9 32.8-21.5 42.9l-67.3 50.5c-24.3 18.2-37.2 47.9-33.8 78.1l2.5 22.7c4.3 38.7-26 72.6-65 72.6-14.8 0-29.3-5.1-40.9-14.3l-55.3-44.3c-4.5-3.6-9.3-6.7-14.5-9.2-15.8-7.9-33.7-10.4-51-7.3L82.4 451.9c-34.6 6.3-66.4-20.3-66.4-55.4 0-13.2 4.7-26 13.1-36.2l11.2-13.4c14.6-17.4 22.6-39.4 22.6-62.1 0-18.8-5.5-37.2-15.8-53L8.8 173.5C3.1 164.7 0 154.4 0 143.9 0 110.5 30.1 85.1 63 90.7l51.3 8.7c35.9 6.1 72.2-8.2 94.2-37.1z"],
    "square-shekel": [448, 512, [], "e735", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm56 104l88 0c39.8 0 72 32.2 72 72l0 56c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-56c0-13.3-10.7-24-24-24l-64 0 0 168c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-192c0-13.3 10.7-24 24-24zm232 24l0 144c0 39.8-32.2 72-72 72l-88 0c-6.4 0-12.5-2.5-17-7s-7-10.6-7-17l0-104c0-13.3 10.7-24 24-24s24 10.7 24 24l0 80 64 0c13.3 0 24-10.7 24-24l0-144c0-13.3 10.7-24 24-24s24 10.7 24 24z"],
    "up-long": [320, 512, ["long-arrow-alt-up"], "f30c", "M137.4-22.6c12.5-12.5 32.8-12.5 45.3 0l128 128c9.2 9.2 11.9 22.9 6.9 34.9S300.9 160 288 160l-64 0 0 336c0 26.5-21.5 48-48 48l-32 0c-26.5 0-48-21.5-48-48l0-336-64 0c-12.9 0-24.6-7.8-29.6-19.8S.2 114.5 9.4 105.4l128-128z"],
    "face-unamused": [512, 512, [], "e39f", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm-58.5-98c-7.7 10.8-22.7 13.2-33.5 5.5s-13.2-22.7-5.5-33.5c21.7-30.2 57.3-50 97.5-50s75.7 19.8 97.5 50c7.7 10.8 5.3 25.8-5.5 33.5s-25.8 5.3-33.5-5.5c-13.1-18.2-34.4-30-58.5-30s-45.4 11.8-58.5 30zM120 192l64 0c22.1 0 40 17.9 40 40s-17.9 40-40 40c-19.4 0-35.5-13.7-39.2-32L120 240c-13.3 0-24-10.7-24-24s10.7-24 24-24zm168 24c0-13.3 10.7-24 24-24l64 0c22.1 0 40 17.9 40 40s-17.9 40-40 40c-19.4 0-35.5-13.7-39.2-32L312 240c-13.3 0-24-10.7-24-24z"],
    "circle-indian-rupee": [512, 512, [], "e734", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM184 120l152 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-44.1 0c9.3 11.3 15.9 25 18.7 40l25.5 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-25.5 0c-6.1 33-30.5 59.5-62.3 68.6L319 349.3c10.3 8.3 12 23.4 3.7 33.7s-23.4 12-33.7 3.8l-120-96c-8-6.4-11-17.1-7.7-26.7S173.8 248 184 248l40 0c16.4 0 30.5-9.9 36.7-24L176 224c-8.8 0-16-7.2-16-16s7.2-16 16-16l84.7 0c-6.2-14.1-20.3-24-36.7-24l-40 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"],
    "spinner-scale": [448, 512, [], "e62a", "M224 116a52 52 0 1 1 0-104 52 52 0 1 1 0 104zm0 300c17.7 0 32 14.3 32 32s-14.3 32-32 32-32-14.3-32-32 14.3-32 32-32zM416 288a32 32 0 1 1 0-64 32 32 0 1 1 0 64zM0 256a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm399.4-96.2a56 56 0 1 1 -79.2-79.2 56 56 0 1 1 79.2 79.2zM65.6 414.4a32 32 0 1 1 45.3-45.3 32 32 0 1 1 -45.3 45.3zm271.5 0a32 32 0 1 1 45.3-45.3 32 32 0 1 1 -45.3 45.3zM54.3 86.3a48 48 0 1 1 67.9 67.9 48 48 0 1 1 -67.9-67.9z"],
    "hexagon-nodes": [448, 512, [], "e699", "M248 106.6c18.9-9 32-28.3 32-50.6c0-30.9-25.1-56-56-56s-56 25.1-56 56c0 22.3 13.1 41.6 32 50.6l0 98.8c-2.8 1.3-5.5 2.9-8 4.7l-80.1-45.8c1.6-20.8-8.6-41.6-27.9-52.8C57.2 96 23 105.2 7.5 132S1.2 193 28 208.5c1.3 .8 2.6 1.5 4 2.1l0 90.8c-1.3 .6-2.7 1.3-4 2.1C1.2 319-8 353.2 7.5 380S57.2 416 84 400.5c19.3-11.1 29.4-32 27.8-52.8l50.5-28.9c-11.5-11.2-19.9-25.6-23.8-41.7L88 306.1c-2.6-1.8-5.2-3.3-8-4.7l0-90.8c2.8-1.3 5.5-2.9 8-4.7l80.1 45.8c-.1 1.4-.2 2.8-.2 4.3c0 22.3 13.1 41.6 32 50.6l0 98.8c-18.9 9-32 28.3-32 50.6c0 30.9 25.1 56 56 56s56-25.1 56-56c0-22.3-13.1-41.6-32-50.6l0-98.8c2.8-1.3 5.5-2.9 8-4.7l80.1 45.8c-1.6 20.8 8.6 41.6 27.8 52.8c26.8 15.5 61 6.3 76.5-20.5s6.3-61-20.5-76.5c-1.3-.8-2.7-1.5-4-2.1l0-90.8c1.4-.6 2.7-1.3 4-2.1c26.8-15.5 36-49.7 20.5-76.5S390.8 96 364 111.5c-19.3 11.1-29.4 32-27.8 52.8l-50.6 28.9c11.5 11.2 19.9 25.6 23.8 41.7L360 205.9c2.6 1.8 5.2 3.3 8 4.7l0 90.8c-2.8 1.3-5.5 2.9-8 4.6l-80.1-45.8c.1-1.4 .2-2.8 .2-4.3c0-22.3-13.1-41.6-32-50.6l0-98.8z"],
    "hospital": [576, 512, [127973, 62589, "hospital-alt", "hospital-wide"], "f0f8", "M128 64c0-35.3 28.7-64 64-64L384 0c35.3 0 64 28.7 64 64l0 64 64 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 192c0-35.3 28.7-64 64-64l64 0 0-64zM272 352c-17.7 0-32 14.3-32 32l0 80 96 0 0-80c0-17.7-14.3-32-32-32l-32 0zM128 368l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16zM112 256c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0zM512 368l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16zM496 256c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0zM264 104l0 32-32 0c-8.8 0-16 7.2-16 16l0 16c0 8.8 7.2 16 16 16l32 0 0 32c0 8.8 7.2 16 16 16l16 0c8.8 0 16-7.2 16-16l0-32 32 0c8.8 0 16-7.2 16-16l0-16c0-8.8-7.2-16-16-16l-32 0 0-32c0-8.8-7.2-16-16-16l-16 0c-8.8 0-16 7.2-16 16z"],
    "face-relieved": [512, 512, [], "e389", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm68-248c0 11 9 20 20 20l16 0c11 0 20-9 20-20s9-20 20-20 20 9 20 20c0 33.1-26.9 60-60 60l-16 0c-33.1 0-60-26.9-60-60 0-11 9-20 20-20s20 9 20 20zM152 284l16 0c11 0 20-9 20-20s9-20 20-20 20 9 20 20c0 33.1-26.9 60-60 60l-16 0c-33.1 0-60-26.9-60-60 0-11 9-20 20-20s20 9 20 20 9 20 20 20zm45.5 86c13.1 18.2 34.4 30 58.5 30s45.4-11.8 58.5-30c7.7-10.8 22.7-13.2 33.5-5.5s13.2 22.7 5.5 33.5c-21.7 30.2-57.3 50-97.5 50s-75.7-19.8-97.5-50c-7.7-10.8-5.3-25.8 5.5-33.5s25.8-5.3 33.5 5.5zM211 105.7c3.5 10.5-2.2 21.8-12.6 25.3l-6.3 2.1c-22.8 7.6-42.4 22.6-55.7 42.6l-7.6 11.5c-6.1 9.2-18.5 11.7-27.7 5.5s-11.7-18.5-5.5-27.7l7.6-11.5c18.3-27.4 45.1-47.9 76.3-58.3l6.3-2.1c10.5-3.5 21.8 2.2 25.3 12.6zM313.7 131c-10.5-3.5-16.1-14.8-12.6-25.3S315.8 89.5 326.3 93l6.3 2.1c31.2 10.4 58.1 30.9 76.3 58.3l7.6 11.5c6.1 9.2 3.6 21.6-5.5 27.7s-21.6 3.6-27.7-5.5l-7.6-11.5c-13.3-20-32.9-35-55.7-42.6l-6.3-2.1z"],
    "square-peruvian-soles": [448, 512, [], "e716", "M384 32c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l320 0zm-41.4 88.9c-12.7-3.6-26 3.7-29.7 16.5l-64 224c-3.6 12.7 3.7 26 16.5 29.7s26-3.7 29.7-16.5l64-224c3.6-12.7-3.7-26-16.5-29.7zM159.6 152c-35.1 0-63.6 28.5-63.6 63.6 0 30.3 21.4 56.4 51.1 62.3l16.4 3.3c7.3 1.5 12.5 7.8 12.5 15.3 0 8.6-7 15.6-15.6 15.6L128 312c-13.3 0-24 10.7-24 24s10.7 24 24 24l32.4 0c35.1 0 63.6-28.5 63.6-63.6 0-30.3-21.4-56.4-51.1-62.3l-16.4-3.3c-7.3-1.5-12.5-7.8-12.5-15.2 0-8.6 7-15.6 15.6-15.6l24.4 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-24.4 0z"],
    "comment-smile": [512, 512, [], "f4b4", "M256 480c141.4 0 256-107.5 256-240S397.4 0 256 0 0 107.5 0 240c0 54.3 19.2 104.3 51.6 144.5L2.8 476.8c-4.8 9-3.3 20 3.6 27.5s17.8 9.8 27.1 5.8l118.4-50.7C183.7 472.6 218.9 480 256 480zM192 160a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm128 0a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM150.5 286.1c9.9-8.8 25-8 33.9 1.9 17.6 19.7 43.1 32 71.6 32s53.9-12.3 71.6-32c8.8-9.9 24-10.7 33.9-1.9s10.7 24 1.9 33.9C337 349.4 298.6 368 256 368s-81-18.6-107.3-48c-8.8-9.9-8-25 1.9-33.9z"],
    "folder-check": [512, 512, [], "e64e", "M202.7 32c13.8 0 27.3 4.5 38.4 12.8l38.4 28.8c5.5 4.2 12.3 6.4 19.2 6.4L448 80c35.3 0 64 28.7 64 64l0 240c0 35.3-28.7 64-64 64L64 448c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l138.7 0zM346.9 180.6c-10.7-7.8-25.7-5.4-33.5 5.3l-85.6 117.7-26.5-27.4c-9.2-9.5-24.4-9.8-33.9-.6s-9.8 24.4-.6 33.9l46.4 48c4.9 5.1 11.8 7.8 18.9 7.3s13.6-4.1 17.8-9.8L352.2 214.1c7.8-10.7 5.4-25.7-5.3-33.5z"],
    "currency-sign": [448, 512, [], "e72b", "M49.5 47c-9.4-9.4-24.6-9.4-33.9 0S6.2 71.6 15.5 81l57.3 57.3C47.5 170.8 32.5 211.6 32.5 256s15 85.2 40.3 117.7L15.5 431c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l57.3-57.3C139.3 433 180.1 448 224.5 448s85.2-15 117.7-40.3L399.5 465c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-57.3-57.3c25.3-32.5 40.3-73.4 40.3-117.7s-15-85.2-40.3-117.7L433.5 81c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-57.3 57.3C309.7 79 268.9 64 224.5 64s-85.2 15-117.7 40.3L49.5 47zm46 209a128.5 128.5 0 1 1 257 0 128.5 128.5 0 1 1 -257 0z"],
    "chart-user": [640, 512, ["user-chart"], "f6a3", "M128 96c0-35.3 28.7-64 64-64l352 0c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64l-211 0c-9.7-46.2-42-84.1-84.8-101.6 15-21 23.8-46.7 23.8-74.4 0-70.7-57.3-128-128-128-5.4 0-10.8 .3-16 1l0-49zm352 97.9l0 30.1c0 13.3 10.7 24 24 24s24-10.7 24-24l0-88c0-13.3-10.7-24-24-24l-88 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l30.1 0-78.1 78.1-31-31c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l48 48c4.5 4.5 10.6 7 17 7s12.5-2.5 17-7l95-95zM64 272a80 80 0 1 1 160 0 80 80 0 1 1 -160 0zM0 480c0-53 43-96 96-96l96 0c53 0 96 43 96 96 0 17.7-14.3 32-32 32L32 512c-17.7 0-32-14.3-32-32z"],
    "person-harassing": [576, 512, [], "e549", "M192 96a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM59.4 304.5L88 256.9 88 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-128 16 0 0 128c0 17.7 14.3 32 32 32s32-14.3 32-32l0-244.7 47.4 57.1c11.3 13.6 31.5 15.5 45.1 4.2s15.5-31.5 4.2-45.1l-73.7-88.9c-18.2-22-45.3-34.7-73.9-34.7l-35.9 0c-33.7 0-64.9 17.7-82.3 46.6l-58.3 97c-9.1 15.1-4.2 34.8 10.9 43.9s34.8 4.2 43.9-10.9zM480 240a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM464 344l0 58.7-41.4-41.4c-7.3-7.3-17.6-10.6-27.8-9s-18.9 8.1-23.5 17.3l-48 96c-7.9 15.8-1.5 35 14.3 42.9s35 1.5 42.9-14.3l28.1-56.3 54.7 54.7c12.4 12.4 29.1 19.3 46.6 19.3 36.4 0 65.9-29.5 65.9-65.9L576 344c0-30.9-25.1-56-56-56s-56 25.1-56 56zM288 48c0 8.8 7.2 16 16 16l56 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-56 0c-8.8 0-16 7.2-16 16zm-.8 49.7c-7.9-4-17.5-.7-21.5 7.2s-.7 17.5 7.2 21.5l48 24c7.9 4 17.5 .7 21.5-7.2s.7-17.5-7.2-21.5l-48-24z"],
    "flatbread": [512, 512, [129747], "e40b", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM361 185L185 361c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9L327 151c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9zM241 111c9.4 9.4 9.4 24.6 0 33.9l-96 96c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l96-96c9.4-9.4 24.6-9.4 33.9 0zM401 305l-96 96c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l96-96c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9z"],
    "circle-microphone-lines": [512, 512, ["microphone-circle-alt"], "e117", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM208 144c0-26.5 21.5-48 48-48s48 21.5 48 48l-32 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l32 0 0 32-32 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l32 0c0 26.5-21.5 48-48 48s-48-21.5-48-48l0-96zm-72 64c13.3 0 24 10.7 24 24l0 8c0 53 43 96 96 96s96-43 96-96l0-8c0-13.3 10.7-24 24-24s24 10.7 24 24l0 8c0 71.4-51.9 130.6-120 142l0 18c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-18c-68.1-11.4-120-70.7-120-142l0-8c0-13.3 10.7-24 24-24z"],
    "money-bill-trend-up": [512, 512, [], "e529", "M480 8c0-13.3-10.7-24-24-24L354.2-16c-13.3 0-24 10.7-24 24s10.7 24 24 24l43.9 0-111.3 111.3-95.1-81.5c-9-7.7-22.2-7.7-31.2 0l-112 96c-10.1 8.6-11.2 23.8-2.6 33.8s23.8 11.2 33.8 2.6l96.4-82.6 96.4 82.6c9.5 8.2 23.7 7.6 32.6-1.3l127-127 0 43.9c0 13.3 10.7 24 24 24s24-10.7 24-24L480 8zM48 256c-26.5 0-48 21.5-48 48L0 464c0 26.5 21.5 48 48 48l416 0c26.5 0 48-21.5 48-48l0-160c0-26.5-21.5-48-48-48L48 256zm47.3 56c-3.4 20.1-19.2 36-39.4 39.4-4.4 .7-8-2.9-8-7.3l0-32c0-4.4 3.6-8 8-8l32 0c4.4 0 8.1 3.6 7.3 8zm0 144.1c.7 4.4-2.9 8-7.3 8l-32 0c-4.4 0-8-3.6-8-8l0-32c0-4.4 3.6-8.1 8-7.3 20.1 3.4 36 19.2 39.4 39.4zM456 416.7c4.4-.7 8 2.9 8 7.3l0 32c0 4.4-3.6 8-8 8l-32 0c-4.4 0-8.1-3.6-7.3-8 3.4-20.1 19.2-36 39.4-39.4zM416.7 312c-.7-4.4 2.9-8 7.3-8l32 0c4.4 0 8 3.6 8 8l0 32c0 4.4-3.6 8.1-8 7.3-20.1-3.4-36-19.2-39.4-39.4zM192 384a64 64 0 1 1 128 0 64 64 0 1 1 -128 0z"],
    "pen-ruler": [512, 512, ["pencil-ruler"], "f5ae", "M404 0c19.2 0 37.6 7.6 51.1 21.2l35.7 35.7C504.4 70.4 512 88.8 512 108s-7.6 37.6-21.2 51.1L445.9 204 308 66.1 352.9 21.2C366.4 7.6 384.8 0 404 0zM58.9 315.1L274.1 100 412 237.9 196.9 453.1c-10.7 10.7-24.1 18.5-38.7 22.6L30.4 511.1c-8.3 2.3-17.3 0-23.4-6.2s-8.5-15.1-6.2-23.4L36.4 353.8c4.1-14.6 11.8-27.9 22.6-38.7zM225.4 80.8L80.8 225.4 11.7 156.3c-15.6-15.6-15.6-40.9 0-56.6l88-88c15.6-15.6 40.9-15.6 56.6 0l5.9 5.9-56.3 56.3c-7.8 7.8-7.8 20.5 0 28.3s20.5 7.8 28.3 0l56.3-56.3 34.9 34.9zM431.2 286.6l34.9 34.9-56.3 56.3c-7.8 7.8-7.8 20.5 0 28.3s20.5 7.8 28.3 0l56.3-56.3 5.9 5.9c15.6 15.6 15.6 40.9 0 56.6l-88 88c-15.6 15.6-40.9 15.6-56.6 0l-69.1-69.1 144.6-144.6z"],
    "brackets-square": [448, 512, ["brackets"], "f7e9", "M384 32c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64l-64 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l64 0 0-320-64 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l64 0zM64 32l64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-64 0 0 320 64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-64 0c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32z"],
    "person-dress-simple": [256, 512, [], "e21c", "M64.1 64a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zM46.5 221.5C56.9 185.1 90.2 160 128.1 160s71.2 25.1 81.6 61.5l34.8 121.7c5.8 20.4-9.5 40.8-30.8 40.8l-21.6 0 0 80c0 26.5-21.5 48-48 48l-32 0c-26.5 0-48-21.5-48-48l0-80-21.6 0c-21.3 0-36.6-20.3-30.8-40.8L46.5 221.5z"],
    "train-subway-tunnel": [512, 512, ["subway-tunnel"], "e2a3", "M256 0C114.6 0 0 114.6 0 256L0 448c0 35.3 28.7 64 64 64l30.1 0 66-66c-27.6-7.1-48.1-32.2-48.1-62l0-192c0-35.3 28.7-64 64-64l160 0c35.3 0 64 28.7 64 64l0 192c0 29.8-20.4 54.9-48.1 62l66 66 30.1 0c35.3 0 64-28.7 64-64l0-192C512 114.6 397.4 0 256 0zm94.1 512l-64-64-60.1 0-64 64 188.1 0zM280 320l48 0c13.3 0 24-10.7 24-24l0-80c0-13.3-10.7-24-24-24l-48 0 0 128zM232 192l-48 0c-13.3 0-24 10.7-24 24l0 80c0 13.3 10.7 24 24 24l48 0 0-128zM184 400a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm168-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"],
    "repeat": [512, 512, [128257], "f363", "M470.6 118.6c12.5-12.5 12.5-32.8 0-45.3l-64-64c-9.2-9.2-22.9-11.9-34.9-6.9S352 19.1 352 32l0 32-160 0C86 64 0 150 0 256 0 273.7 14.3 288 32 288s32-14.3 32-32c0-70.7 57.3-128 128-128l160 0 0 32c0 12.9 7.8 24.6 19.8 29.6s25.7 2.2 34.9-6.9l64-64zM41.4 393.4c-12.5 12.5-12.5 32.8 0 45.3l64 64c9.2 9.2 22.9 11.9 34.9 6.9S160 492.9 160 480l0-32 160 0c106 0 192-86 192-192 0-17.7-14.3-32-32-32s-32 14.3-32 32c0 70.7-57.3 128-128 128l-160 0 0-32c0-12.9-7.8-24.6-19.8-29.6s-25.7-2.2-34.9 6.9l-64 64z"],
    "bottle-baby": [320, 512, [], "e673", "M124.6 17.7L128 16 128 0c0-17.7 14.3-32 32-32s32 14.3 32 32l0 16 3.4 1.7c17.5 8.8 28.6 26.7 28.6 46.3 17.7 0 32 14.3 32 32l0 16-192 0 0-16c0-17.7 14.3-32 32-32 0-19.6 11.1-37.5 28.6-46.3zM16 272c0-31.2 10.1-61.5 28.8-86.4l19.2-25.6 192 0 19.2 25.6C293.9 210.5 304 240.8 304 272l0 208c0 35.3-28.7 64-64 64L80 544c-35.3 0-64-28.7-64-64l0-32 88 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-88 0 0-64 88 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-88 0 0-16z"],
    "bone": [640, 512, [129460], "f5d7", "M197.4 160c-3.9 0-7.2-2.8-8.1-6.6-10.2-42.1-48.1-73.4-93.3-73.4-53 0-96 43-96 96 0 29.1 12.9 55.1 33.3 72.7 4.3 3.7 4.3 10.8 0 14.5-20.4 17.6-33.3 43.7-33.3 72.7 0 53 43 96 96 96 45.2 0 83.1-31.3 93.3-73.4 .9-3.8 4.2-6.6 8.1-6.6l245.1 0c3.9 0 7.2 2.8 8.1 6.6 10.2 42.1 48.1 73.4 93.3 73.4 53 0 96-43 96-96 0-29.1-12.9-55.1-33.3-72.7-4.3-3.7-4.3-10.8 0-14.5 20.4-17.6 33.3-43.7 33.3-72.7 0-53-43-96-96-96-45.2 0-83.1 31.3-93.3 73.4-.9 3.8-4.2 6.6-8.1 6.6l-245.1 0z"],
    "right-left-large": [576, 512, [], "e5e1", "M224 160c0-12.9-7.8-24.6-19.8-29.6s-25.7-2.2-34.9 6.9l-160 160c-12.5 12.5-12.5 32.8 0 45.3l160 160c9.2 9.2 22.9 11.9 34.9 6.9S224 492.9 224 480l0-64 32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0c-17.7 0-32 14.3-32 32l0 18.7-82.7-82.7 82.7-82.7 0 18.7c0 17.7 14.3 32 32 32l160 0 0 64c0 12.9 7.8 24.6 19.8 29.6s25.7 2.2 34.9-6.9l160-160c12.5-12.5 12.5-32.8 0-45.3l-160-160c-9.2-9.2-22.9-11.9-34.9-6.9S352 19.1 352 32l0 64-32 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-18.7 82.7 82.7-82.7 82.7 0-18.7c0-17.7-14.3-32-32-32l-160 0 0-64z"],
    "strawberry": [576, 512, [], "e32b", "M397.1-12.7c6.2-6.2 16.4-6.2 22.6 0L431.8-.6c31.2 31.2 31.2 81.9 0 113.1 31.2-31.2 81.9-31.2 113.1 0l12.1 12.1c6.2 6.2 6.2 16.4 0 22.6l-12.1 12.1c-31.2 31.2-81.9 31.2-113.1 0-15.6-15.6-31.2-31.2-46.9-46.9-31.2-31.2-31.2-81.9 0-113.1l12.1-12.1zM32.4 336c0-176 96.2-272 192.2-272 32.7 .1 65.3 12.6 90.3 37.5l128 128c25 25 37.5 57.8 37.5 90.5 0 96-96 192-272 192-128 0-176-48-176-176zM205.2 172.8c11.9-11.9 14.6-28.3 8.7-34.3s-22.4-3.2-34.3 8.7-14.6 28.3-8.7 34.3 22.4 3.2 34.3-8.7zm72.7 29.7c-5.9-5.9-22.4-3.2-34.3 8.7s-14.6 28.3-8.7 34.3 22.4 3.2 34.3-8.7 14.6-28.3 8.7-34.3zm-32 96c-5.9-5.9-22.4-3.2-34.3 8.7s-14.6 28.3-8.7 34.3 22.4 3.2 34.3-8.7 14.6-28.3 8.7-34.3zm-32 96c-5.9-5.9-22.4-3.2-34.3 8.7s-14.6 28.3-8.7 34.3 22.4 3.2 34.3-8.7 14.6-28.3 8.7-34.3zm87.3 2.3c11.9-11.9 14.6-28.3 8.7-34.3s-22.4-3.2-34.3 8.7-14.6 28.3-8.7 34.3 22.4 3.2 34.3-8.7zm32-96c11.9-11.9 14.6-28.3 8.7-34.3s-22.4-3.2-34.3 8.7-14.6 28.3-8.7 34.3 22.4 3.2 34.3-8.7zm72.7 29.7c-5.9-5.9-22.4-3.2-34.3 8.7s-14.6 28.3-8.7 34.3 22.4 3.2 34.3-8.7 14.6-28.3 8.7-34.3zm-224-96c-5.9-5.9-22.4-3.2-34.3 8.7s-14.6 28.3-8.7 34.3 22.4 3.2 34.3-8.7 14.6-28.3 8.7-34.3zM141.2 364.8c11.9-11.9 14.6-28.3 8.7-34.3s-22.4-3.2-34.3 8.7-14.6 28.3-8.7 34.3 22.4 3.2 34.3-8.7z"],
    "square-bolt": [448, 512, [], "e265", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm64.6 240c-9.2 0-16.6-7.4-16.6-16.6 0-4.7 2-9.2 5.5-12.4L258.7 116.7c3.4-3 7.8-4.7 12.4-4.7 12.4 0 21.3 12 17.8 23.9l-31.2 104.1 61.8 0c9.2 0 16.6 7.4 16.6 16.6 0 4.7-2 9.2-5.5 12.4L189.3 395.3c-3.4 3-7.8 4.7-12.4 4.7-12.4 0-21.3-12-17.8-23.9l31.2-104.1-61.8 0z"],
    "fire-flame-curved": [384, 512, ["fire-alt"], "f7e4", "M153.6 29.9l16-21.3C173.6 3.2 180 0 186.7 0 198.4 0 208 9.6 208 21.3l0 22.1c0 13.1 5.4 25.7 14.9 34.7L307.6 159C356.4 205.6 384 270.2 384 337.7 384 434 306 512 209.7 512L192 512C86 512 0 426 0 320l0-3.8c0-48.8 19.4-95.6 53.9-130.1l3.5-3.5c4.2-4.2 10-6.6 16-6.6 12.5 0 22.6 10.1 22.6 22.6L96 288c0 35.3 28.7 64 64 64s64-28.7 64-64l0-3.9c0-18-7.2-35.3-19.9-48l-38.6-38.6c-24-24-37.5-56.7-37.5-90.7 0-27.7 9-54.8 25.6-76.9z"],
    "signature-slash": [640, 512, [], "e3cb", "M73-24.9c-9.4-9.4-24.6-9.4-33.9 0S29.7-.3 39 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9L513.8 416 616 416c13.3 0 24-10.7 24-24s-10.7-24-24-24l-150.2 0-48-48 126.2 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-83.6 0 18-53.9c3.8-11.3 .9-23.8-7.4-32.4s-20.7-11.8-32.2-8.4L316.4 198.1c2.4-20.7 3.6-41.4 3.6-62.3l0-7.8c0-53-43-96-96-96-26 0-49.7 10.4-67 27.2L73-24.9zM202.3 104.5c5.7-5.3 13.3-8.5 21.7-8.5 17.7 0 32 14.3 32 32l0 7.8c0 7.3-.2 14.6-.5 21.9l-53.2-53.2zM352 254.2l46.1-13.8-12.5 37.5c-.9 2.7-1.4 5.5-1.6 8.3l-32-32zM330.2 368l-7.1 0c-6.5 16.3-13.7 32.3-21.6 48l76.7 0-48-48zm-42.5-42.5l-91.4-91.4-31.9 9.6c-40.6 12.2-68.4 49.6-68.4 92l0 32.4-72 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l72.5 0c4.2 36 34.8 64 72 64 26 0 50-13.9 62.9-36.5l13.9-24.3c17.1-29.9 31.2-61.2 42.3-93.7zM182.8 305l49-14.7c-10.4 33.8-24.5 66.4-42.1 97.2l-13.9 24.3c-1.5 2.6-4.3 4.3-7.4 4.3-4.7 0-8.5-3.8-8.5-8.5l0-71.9c0-14.1 9.3-26.6 22.8-30.7z"],
    "bus-simple": [448, 512, ["bus-alt"], "f55e", "M96 0C43 0 0 43 0 96L0 384c0 29.8 20.4 54.9 48 62l0 34c0 17.7 14.3 32 32 32l16 0c17.7 0 32-14.3 32-32l0-32 192 0 0 32c0 17.7 14.3 32 32 32l16 0c17.7 0 32-14.3 32-32l0-34c27.6-7.1 48-32.2 48-62l0-288c0-53-43-96-96-96L96 0zM64 128c0-17.7 14.3-32 32-32l256 0c17.7 0 32 14.3 32 32l0 96c0 17.7-14.3 32-32 32L96 256c-17.7 0-32-14.3-32-32l0-96zM96 320a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm256 0a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "square-peseta": [448, 512, [], "e6ea", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm80 112c0-13.3 10.7-24 24-24l64 0c52 0 95.1 38.2 102.8 88l9.2 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-9.2 0c-7.7 49.8-50.8 88-102.8 88l-40 0 0 40c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-128-8 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l8 0 0-64zm88 24l-40 0 0 40 93.7 0c-6.9-23.1-28.3-40-53.7-40zM192 280l40 0c25.4 0 46.8-16.9 53.7-40l-93.7 0 0 40z"],
    "tank-water": [448, 512, [], "e452", "M212 6.9c2.5-4.3 7-6.9 12-6.9s9.5 2.7 12 6.9l50 87.6c6.5 11.5 10 24.4 10 37.6l0 3.9c0 39.8-32.2 72-72 72s-72-32.2-72-72l0-3.9c0-13.2 3.4-26.2 10-37.6L212 6.9zM120.3 70.7c-4.6 8-8.2 16.5-10.9 25.3L64 96 64 264.2c34.5-14.4 74.5-9.9 105.5 13.5 24 18.1 40.7 26.3 54.5 26.3s30.5-8.2 54.5-26.3c31.1-23.4 71-27.9 105.5-13.5l0-168.2-45.4 0c-2.7-8.8-6.3-17.3-10.9-25.3L305.6 32 384 32c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l78.4 0-22.1 38.7z"],
    "user-shakespeare": [448, 512, [], "e2c2", "M304 144c0 38.7-27.5 71-64 78.4l0-6.4c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 6.4c-36.5-7.4-64-39.7-64-78.4l0-16c0-44.2 35.8-80 80-80s80 35.8 80 80l0 16zM224 0C153.3 0 96 57.3 96 128l0 11.3c0 8.4-2.2 16.6-6.3 23.8L69 199.3c-3.3 5.7-5 12.2-5 18.8 0 20.9 17 37.9 37.9 37.9l60.1 0c18.4 10.2 39.5 16 62 16s43.6-5.8 62-16l60.1 0c20.9 0 37.9-17 37.9-37.9 0-6.6-1.7-13.1-5-18.8l-20.7-36.2c-4.1-7.3-6.3-15.5-6.3-23.8l0-11.3C352 57.3 294.7 0 224 0zm39.2 153.7l-32-16c-4.5-2.3-9.8-2.3-14.3 0l-32 16c-7.9 4-11.1 13.6-7.2 21.5s13.6 11.1 21.5 7.2l24.8-12.4 24.8 12.4c7.9 4 17.5 .7 21.5-7.2s.7-17.5-7.2-21.5zM96.7 342.9C48.4 371.6 16 424.3 16 484.6 16 499.7 28.3 512 43.4 512l156.6 0 0-104c0-13.3 10.7-24 24-24s24 10.7 24 24l0 104 156.6 0c15.1 0 27.4-12.3 27.4-27.4 0-60.3-32.4-113-80.7-141.7 .5-2.2 .7-4.5 .7-6.9 0-17.7-14.3-32-32-32l-22.6 0c-22.3 10.3-47.2 16-73.4 16s-51.1-5.7-73.4-16L128 304c-17.7 0-32 14.3-32 32 0 2.4 .3 4.7 .7 6.9z"],
    "venus-mars": [640, 512, [9892], "f228", "M480-64c-17.7 0-32 14.3-32 32S462.3 0 480 0L530.7 0 474 56.7c-26.3-15.7-57.1-24.7-90-24.7-35.4 0-68.4 10.5-96 28.5-27.6-18-60.6-28.5-96-28.5-97.2 0-176 78.8-176 176 0 86.3 62.1 158.1 144 173.1l0 34.9-32 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l32 0 0 32c0 17.7 14.3 32 32 32s32-14.3 32-32l0-32 32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0 0-34.9c23.3-4.3 44.9-13.1 64-25.6 27.6 18 60.6 28.5 96 28.5 97.2 0 176-78.8 176-176 0-41.1-14.1-79-37.8-109L576 45.3 576 96c0 17.7 14.3 32 32 32s32-14.3 32-32l0-128c0-17.7-14.3-32-32-32L480-64zM336 309.2c20.2-28.6 32-63.5 32-101.2s-11.8-72.6-32-101.2c14.6-6.9 30.8-10.8 48-10.8 61.9 0 112 50.1 112 112S445.9 320 384 320c-17.2 0-33.5-3.9-48-10.8zM288 150.3c10.2 16.9 16 36.6 16 57.7s-5.8 40.9-16 57.7c-10.2-16.9-16-36.6-16-57.7s5.8-40.9 16-57.7zm-48-43.5c-20.2 28.6-32 63.5-32 101.2s11.8 72.6 32 101.2c-14.5 6.9-30.8 10.8-48 10.8-61.9 0-112-50.1-112-112S130.1 96 192 96c17.2 0 33.5 3.9 48 10.8z"],
    "kazoo": [576, 512, [], "f8c7", "M393.4-22.6c12.5-12.5 32.8-12.5 45.3 0l128 128c12.5 12.5 12.5 32.8 0 45.3L470.3 247c-9.9 65.5-61.7 117.4-127.3 127.3l-48.4 48.4c-1.8 1.8-3.9 3.5-6.2 4.8l-160 96c-12.6 7.6-28.7 5.6-39.1-4.8l-64-64C15 444.2 13 428.1 20.6 415.5l96-160c1.3-2.2 3-4.3 4.8-6.2L169.7 201C179.7 135.5 231.5 83.7 297 73.7l96.4-96.4zM320 328a104 104 0 1 0 0-208 104 104 0 1 0 0 208zm20-149.2l0 25.3 25.3 0c11 0 20 9 20 20s-9 20-20 20l-25.3 0 0 25.3c0 11-9 20-20 20s-20-9-20-20l0-25.3-25.3 0c-11 0-20-9-20-20s9-20 20-20l25.3 0 0-25.3c0-11 9-20 20-20s20 9 20 20z"],
    "diagram-subtask": [448, 512, [], "e479", "M0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 64c0 35.3-28.7 64-64 64l-256 0 0 96c0 17.7 14.3 32 32 32l32 0c0-35.3 28.7-64 64-64l128 0c35.3 0 64 28.7 64 64l0 64c0 35.3-28.7 64-64 64l-128 0c-35.3 0-64-28.7-64-64l-32 0c-53 0-96-43-96-96l0-96c-35.3 0-64-28.7-64-64L0 96z"],
    "arrows-from-dotted-line": [384, 512, [], "e0a3", "M169.4-22.6c12.5-12.5 32.8-12.5 45.3 0l64 64c9.2 9.2 11.9 22.9 6.9 34.9S268.9 96 256 96l-32 0 0 48c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-48-32 0c-12.9 0-24.6-7.8-29.6-19.8s-2.2-25.7 6.9-34.9l64-64zM160 416l0-48c0-17.7 14.3-32 32-32s32 14.3 32 32l0 48 32 0c12.9 0 24.6 7.8 29.6 19.8s2.2 25.7-6.9 34.9l-64 64c-12.5 12.5-32.8 12.5-45.3 0l-64-64c-9.2-9.2-11.9-22.9-6.9-34.9S115.1 416 128 416l32 0zM64 256a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm74.7 32a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm138.7-32a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM352 288a32 32 0 1 1 0-64 32 32 0 1 1 0 64z"],
    "grip-dots": [512, 512, [], "e410", "M64 224a64 64 0 1 1 0-128 64 64 0 1 1 0 128zM256 96a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm192 0a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm0 192a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM256 416a64 64 0 1 1 0-128 64 64 0 1 1 0 128zM64 288a64 64 0 1 1 0 128 64 64 0 1 1 0-128z"],
    "blender": [512, 512, [], "f517", "M0 56C0 25.1 25.1 0 56 0L437.6 0c21.3 0 36.6 20.3 30.8 40.8L457.1 80 344 80c-13.3 0-24 10.7-24 24s10.7 24 24 24l99.4 0-18.3 64-81.1 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l67.4 0-27.4 96-256 0-9.1-96-62.9 0c-30.9 0-56-25.1-56-56L0 56zM114.3 192L100.6 48 56 48c-4.4 0-8 3.6-8 8l0 128c0 4.4 3.6 8 8 8l58.3 0zM136 384l240 0c22.1 0 40 17.9 40 40l0 48c0 22.1-17.9 40-40 40l-240 0c-22.1 0-40-17.9-40-40l0-48c0-22.1 17.9-40 40-40zm120 88a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"],
    "u": [384, 512, [117], "55", "M32 32c17.7 0 32 14.3 32 32l0 224c0 70.7 57.3 128 128 128s128-57.3 128-128l0-224c0-17.7 14.3-32 32-32s32 14.3 32 32l0 224c0 106-86 192-192 192S0 394 0 288L0 64C0 46.3 14.3 32 32 32z"],
    "box-heart": [448, 512, [], "f49d", "M369.4 128l-34.3-48-87.1 0 0 48 121.4 0zM200 128l0-48-87.1 0-34.3 48 121.4 0zM0 148.5c0-13.3 4.2-26.3 11.9-37.2L60.9 42.8C72.9 26 92.3 16 112.9 16l222.1 0c20.7 0 40.1 10 52.1 26.8l48.9 68.5c7.8 10.9 11.9 23.9 11.9 37.2L448 416c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 148.5zm217.6 83c-11.1-14.8-28.5-23.5-46.9-23.5-32.4 0-58.7 26.3-58.7 58.7l0 5.3c0 49.1 65.8 98.1 96.5 118.3 9.5 6.2 21.5 6.2 30.9 0 30.7-20.2 96.5-69.3 96.5-118.3l0-5.3c0-32.4-26.3-58.7-58.7-58.7-18.5 0-35.9 8.7-46.9 23.5l-6.4 8.5-6.4-8.5z"],
    "lightbulb-cfl": [320, 512, [], "e5a6", "M167.8 63c17.1-4.3 27.6-21.7 23.3-38.8S169.4-3.3 152.2 1L24.2 33C7.1 37.2-3.3 54.6 1 71.8S22.6 99.3 39.8 95l128-32zM319.1 88.2c-4.3-17.1-21.7-27.6-38.8-23.3l-256 64C7.1 133.2-3.3 150.6 1 167.8S22.6 195.3 39.8 191l256-64c17.1-4.3 27.6-21.7 23.3-38.8zM295.8 223c17.1-4.3 27.6-21.7 23.3-38.8s-21.7-27.6-38.8-23.3l-256 64C7.1 229.2-3.3 246.6 1 263.8S22.6 291.3 39.8 287l256-64zM176 384l-32 0 0-90-48 12 0 78-8 0c-13.3 0-24 10.7-24 24l0 24c0 44.2 35.8 80 80 80l32 0c44.2 0 80-35.8 80-80l0-24c0-13.3-10.7-24-24-24l-8 0 0-47 71.8-17.9c17.1-4.3 27.6-21.7 23.3-38.8s-21.7-27.6-38.8-23.3l-80 20c-13.7 3.4-24.2 16.5-24.2 30.3l0 76.7z"],
    "share": [512, 512, ["mail-forward"], "f064", "M307.8 18.4c-12 5-19.8 16.6-19.8 29.6l0 80-112 0c-97.2 0-176 78.8-176 176 0 113.3 81.5 163.9 100.2 174.1 2.5 1.4 5.3 1.9 8.1 1.9 10.9 0 19.7-8.9 19.7-19.7 0-7.5-4.3-14.4-9.8-19.5-9.4-8.8-22.2-26.4-22.2-56.7 0-53 43-96 96-96l96 0 0 80c0 12.9 7.8 24.6 19.8 29.6s25.7 2.2 34.9-6.9l160-160c12.5-12.5 12.5-32.8 0-45.3l-160-160c-9.2-9.2-22.9-11.9-34.9-6.9z"],
    "cassette-vhs": [512, 512, [128252, "vhs"], "f8ec", "M0 128C0 92.7 28.7 64 64 64l384 0c35.3 0 64 28.7 64 64l0 16-512 0 0-16zm0 64l512 0 0 192c0 35.3-28.7 64-64 64L64 448c-35.3 0-64-28.7-64-64L0 192zm102.7 64c-9.1 0-18 3.7-23 11.3-9.9 15.1-15.7 33.2-15.7 52.7s5.8 37.6 15.7 52.7c5 7.6 13.9 11.3 23 11.3l57.3 0 0-24c-22.1 0-40-17.9-40-40s17.9-40 40-40l0-24-57.3 0zM280.4 384l23.6 0 0-128-96 0 0 128 72.4 0zm128.8 0c9.1 0 18-3.7 23-11.3 9.9-15.1 15.7-33.2 15.7-52.7s-5.8-37.6-15.7-52.7c-5-7.6-13.9-11.3-23-11.3l-57.3 0 0 24c22.1 0 40 17.9 40 40s-17.9 40-40 40l0 24 57.3 0z"],
    "phone-flip": [512, 512, [128381, "phone-alt"], "f879", "M351.8 25c7.8-18.8 28.4-28.9 48.1-23.5l5.5 1.5c64.6 17.6 119.8 80.2 103.7 156.4-37.1 175-174.8 312.7-349.8 349.8-76.3 16.2-138.8-39.1-156.4-103.7l-1.5-5.5c-5.4-19.7 4.7-40.3 23.5-48.1l97.3-40.5c16.5-6.9 35.6-2.1 47 11.8l38.6 47.2c70.3-34.9 126.8-93.3 159.3-164.9l-44.1-36.1c-13.9-11.3-18.6-30.4-11.8-47L351.8 25z"],
    "face-swear": [640, 512, [], "e399", "M320-32C184-32 72.8 74.1 64.5 208l511 0C567.2 74.1 456-32 320-32zM240 176c-17.7 0-32-14.3-32-32 0-7.3 2.4-14 6.6-19.4L185.7 115c-10.5-3.5-16.1-14.8-12.6-25.3S187.8 73.5 198.3 77l96 32c10.5 3.5 16.1 14.8 12.6 25.3s-14.8 16.1-25.3 12.6l-9.7-3.2 0 .3c0 17.7-14.3 32-32 32zm192-32c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-.3-9.7 3.2c-10.5 3.5-21.8-2.2-25.3-12.6s2.2-21.8 12.6-25.3l96-32c10.5-3.5 21.8 2.2 25.3 12.6s-2.2 21.8-12.6 25.3l-28.9 9.6c4.1 5.4 6.6 12.1 6.6 19.4zM64 256c-35.3 0-64 28.7-64 64L0 448c0 35.3 28.7 64 64 64l512 0c35.3 0 64-28.7 64-64l0-128c0-35.3-28.7-64-64-64L64 256zM400 368l-16 0 0 32 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0 0 16c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-16-32 0 0 16c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-16-16 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0 0-32-16 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0 0-16c0-8.8 7.2-16 16-16s16 7.2 16 16l0 16 32 0 0-16c0-8.8 7.2-16 16-16s16 7.2 16 16l0 16 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16zm-80 0l0 32 32 0 0-32-32 0zm250.4-52.1c6.7 5.8 7.5 15.8 1.7 22.6l-96 112c-5.8 6.7-15.8 7.5-22.6 1.7s-7.5-15.8-1.7-22.6l96-112c5.8-6.7 15.8-7.5 22.6-1.7zM448 336a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm104 72a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM208 304c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-64c0-8.8 7.2-16 16-16zM184 440a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM64 358.5c0-19 13.8-34.8 32-37.9l0-.5c0-8.8 7.2-16 16-16s16 7.2 16 16l8 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-33.5 0c-3.6 0-6.5 2.9-6.5 6.5 0 3 2 5.6 4.9 6.3l30 7.5c17.1 4.3 29.1 19.7 29.1 37.3 0 19-13.8 34.8-32 37.9l0 .5c0 8.8-7.2 16-16 16s-16-7.2-16-16l-16 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l41.5 0c3.6 0 6.5-2.9 6.5-6.5 0-3-2-5.6-4.9-6.3l-30-7.5C76 391.5 64 376.1 64 358.5z"],
    "toilet-portable": [320, 512, [], "e583", "M0 64l0 16 320 0 0-16c0-35.3-28.7-64-64-64L64 0C28.7 0 0 28.7 0 64zm24 64L0 128 0 488c0 13.3 10.7 24 24 24s24-10.7 24-24l0-8 224 0 0 8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-360-296 0zm224 96l24 0 0 96-24 0c-13.3 0-24-10.7-24-24l0-48c0-13.3 10.7-24 24-24z"],
    "circle-rupiah": [512, 512, [], "e706", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM152 144l48 0c39.8 0 72 32.2 72 72 0 26.9-14.7 50.3-36.5 62.6l19.3 57.8c4.2 12.6-2.6 26.2-15.2 30.4s-26.2-2.6-30.4-15.2l-21.2-63.6-12 0 0 56c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-176c0-13.3 10.7-24 24-24zm48 96c13.3 0 24-10.7 24-24s-10.7-24-24-24l-24 0 0 48 24 0zm88 8c0-13.3 10.7-24 24-24l40 0c35.3 0 64 28.7 64 64s-28.7 64-64 64l-16 0 0 32c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-136zm48 56l16 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0 0 32z"],
    "mobile-vibrate-slash": [576, 512, [], "e817", "M7-24.9c8.8-8.8 22.7-9.3 32.1-1.7l1.8 1.7 87.1 87.1C129 27.7 157.3 0 192 0L384 0c35.3 0 64 28.7 64 64l0 318.2 121 121 1.7 1.8c7.7 9.4 7.1 23.3-1.7 32.1s-22.7 9.3-32.1 1.7L535 537.1 7 9.1 5.4 7.2C-2.3-2.2-1.8-16.1 7-24.9zM426.2 496c-11.3 9.9-26 16-42.2 16l-192 0c-35.3 0-64-28.7-64-64L128 197.8 426.2 496zM248 416c-13.3 0-24 10.7-24 24s10.7 24 24 24l78.3 0-48-48-30.3 0zM87.4 157.2c-1 4.3-3.1 8.4-6.4 11.8l-31 31 25.4 25.4 2.9 3.2c6.3 7.7 9.8 17.4 9.8 27.4 0 11.5-4.6 22.5-12.7 30.6l-25.4 25.4 31 31 1.7 1.8c7.7 9.4 7.1 23.3-1.7 32.1s-22.7 9.3-32.1 1.7L47 377 12.7 342.6C5.6 335.5 1.2 326.2 .2 316.3L0 312 .2 307.7c1-9.9 5.4-19.2 12.5-26.3L38.1 256 12.7 230.6C5.6 223.5 1.2 214.2 .2 204.3L0 200 .2 195.7c1-9.9 5.4-19.2 12.5-26.3L47 135 48.8 133.4c3-2.4 6.4-4 10-4.8l28.6 28.6zM495 135c8.8-8.8 22.7-9.3 32.1-1.7l1.8 1.7 34.3 34.3c7.1 7.1 11.5 16.4 12.5 26.3l.2 4.3-.2 4.3c-1 9.9-5.4 19.2-12.5 26.3l-25.4 25.4 25.4 25.4c7.1 7.1 11.5 16.4 12.5 26.3l.2 4.3-.2 4.3c-1 9.9-5.4 19.2-12.5 26.3l-34.3 34.3-1.8 1.7c-9.4 7.7-23.3 7.1-32.1-1.7s-9.3-22.7-1.7-32.1l1.7-1.8 31-31-25.4-25.4c-8.1-8.1-12.7-19.1-12.7-30.6 0-10 3.5-19.7 9.8-27.4l2.9-3.2 25.4-25.4-31-31c-9.4-9.4-9.4-24.6 0-33.9z"],
    "table-cells-column-unlock": [640, 512, [], "e690", "M256 288l0-64 153.3 0c17.1-42.2 56-73.2 102.7-79l0-49c0-35.3-28.7-64-64-64L128 32C92.7 32 64 60.7 64 96l0 320c0 35.3 28.7 64 64 64l241.3 0c-.9-5.2-1.3-10.6-1.3-16.1l0-47.9-112 0 0-64 113.3 0c3.7-22 14.8-41.4 30.7-55.6l0-8.4-144 0zm0-192l192 0 0 64-192 0 0-64zM560 272l48 0c-.1-44.1-35.8-79.9-80-79.9-44.2 0-80 35.8-80 80l0 50.6c-18.6 6.6-32 24.4-32 45.3l0 96c0 26.5 21.5 48 48 48l128 0c26.5 0 48-21.5 48-48l0-96c0-26.5-21.5-48-48-48l-96 0 0-47.9c0-17.7 14.3-32 32-32 17.6 0 31.9 14.3 32 31.9z"],
    "person-pregnant": [384, 512, [], "e31e", "M192 80a56 56 0 1 0 0-112 56 56 0 1 0 0 112zm80 321.2c8.6-4.5 16.8-10 24.3-16.5l4-3.4c22.6-19.4 35.7-47.7 35.7-77.6 0-35.9-18.8-69.1-49.6-87.6l-30.4-18.2 0-1.8c0-46.5-37.7-84.1-84.1-84.1-28.1 0-54.4 14.1-70 37.5L21.4 270.2c-9.8 14.7-5.8 34.6 8.9 44.4s34.6 5.8 44.4-8.9l29-43.5-30.5 113.5c-2.6 9.6-.6 19.9 5.5 27.8S94 416 104 416l8 0 0 96c0 17.7 14.3 32 32 32s32-14.3 32-32l0-96 32 0 0 96c0 17.7 14.3 32 32 32s32-14.3 32-32l0-110.8z"],
    "less-than": [512, 512, [62774], "3c", "M477.1 50.6c7.4 16 .4 35.1-15.6 42.5L108.4 256 461.4 419c16 7.4 23 26.4 15.6 42.5s-26.4 23-42.5 15.6l-416-192C7.3 279.8 0 268.5 0 256S7.3 232.2 18.6 227l416-192c16-7.4 35.1-.4 42.5 15.6z"],
    "image-circle-arrow-down": [640, 512, [], "e76c", "M128 32C92.7 32 64 60.7 64 96l0 320c0 35.3 28.7 64 64 64l212 0c-13.7-19-24-40.7-30-64l-158 0c-8.9 0-17.2-5-21.3-12.9s-3.5-17.5 1.6-24.8l56-80c4.5-6.4 11.8-10.2 19.7-10.2s15.2 3.8 19.7 10.2l26.4 37.8 61.4-100.5c4.4-7.1 12.1-11.5 20.5-11.5s16.1 4.4 20.5 11.5l.2 .4c35-36.9 84.5-59.9 139.3-59.9 5.4 0 10.7 .2 16 .7L512 96c0-35.3-28.7-64-64-64L128 32zm64 80a48 48 0 1 1 0 96 48 48 0 1 1 0-96zM496 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm67.3-147.3c6.2 6.2 6.2 16.4 0 22.6l-56 56c-6.2 6.2-16.4 6.2-22.6 0l-56-56c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l28.7 28.7 0-89.4c0-8.8 7.2-16 16-16s16 7.2 16 16l0 89.4 28.7-28.7c6.2-6.2 16.4-6.2 22.6 0z"],
    "square-fragile": [448, 512, ["box-fragile", "square-wine-glass-crack"], "f49b", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm64 86.3C128 106 138 96 150.3 96l25.7 0 32 64-32 32 80 64-32-64 48-32-32-64 57.7 0C310 96 320 106 320 118.3l0 89.7c0 46.2-32.6 84.7-76 93.9l0 74.1 40 0c11 0 20 9 20 20s-9 20-20 20l-120 0c-11 0-20-9-20-20s9-20 20-20l40 0 0-74.1c-43.4-9.2-76-47.8-76-93.9l0-89.7z"],
    "inbox-full": [512, 512, [], "e1ba", "M28.4 86.9C32.9 55.4 59.9 32 91.8 32l328.5 0c31.8 0 58.9 23.4 63.4 54.9l27.8 194.3c.4 3 .6 6 .6 9.1L512 416c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 290.3c0-3 .2-6.1 .6-9.1L28.4 86.9zM420.2 96l-328.5 0-27.4 192 59.9 0c12.1 0 23.2 6.8 28.6 17.7l14.3 28.6c5.4 10.8 16.5 17.7 28.6 17.7l120.4 0c12.1 0 23.2-6.8 28.6-17.7l14.3-28.6c5.4-10.8 16.5-17.7 28.6-17.7l59.9 0-27.4-192zM152 128l208 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-208 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zm0 80l208 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-208 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"],
    "film-canister": [576, 512, ["film-cannister"], "f8b7", "M96 32c0-17.7 14.3-32 32-32l96 0c17.7 0 32 14.3 32 32l64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l0 352c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 512c-17.7 0-32-14.3-32-32s14.3-32 32-32L32 96C14.3 96 0 81.7 0 64S14.3 32 32 32l64 0zm448 80c17.7 0 32 14.3 32 32l0 144c0 17.7-14.3 32-32 32s-32 14.3-32 32l0 48c0 17.7-14.3 32-32 32l-112 0 0-48 32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0 0-96 32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0 0-48 176 0zM96 136l0 272c0 13.3 10.7 24 24 24s24-10.7 24-24l0-272c0-13.3-10.7-24-24-24s-24 10.7-24 24zm384 24c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0z"],
    "hammer-brush": [640, 512, [], "e620", "M0 137.7C0 91.7 23 48.7 61.3 23.1 83.9 8 110.5 0 137.7 0l62.1 0c15.8 0 31.2 4.7 44.4 13.4L272 32 288 32c0-17.7 14.3-32 32-32s32 14.3 32 32l0 96c0 17.7-14.3 32-32 32s-32-14.3-32-32l-16 0-27.8 18.6C231 155.3 215.6 160 199.8 160l-47.6 0c-15.8 0-31.2-4.7-44.4-13.4L94 137.3c-8.8-5.8-19.9-7-29.6-3.1l-45.1 18C10 156 0 149.2 0 139.2l0-1.5zM224 208l0 256c0 26.5-21.5 48-48 48s-48-21.5-48-48l0-256 96 0zM448 448l-32 64-48 0c-26.5 0-48-21.5-48-48l0-128 288 0 0 128c0 26.5-21.5 48-48 48l-80 0-32-64zM320 288c.7-20.5 11.3-39.5 28.5-51l67.5-45 0-144c0-26.5 21.5-48 48-48s48 21.5 48 48l0 144 67.5 45c17.2 11.5 27.7 30.5 28.5 51L320 288z"],
    "superscript": [576, 512, [], "f12b", "M544 32c0-11.1-5.7-21.4-15.2-27.2s-21.2-6.4-31.1-1.4l-32 16C449.9 27.3 443.5 46.5 451.4 62.3 457 73.5 468.3 80 480 80l0 80c-17.7 0-32 14.3-32 32s14.3 32 32 32l64 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l0-128zM96 64C78.3 64 64 78.3 64 96s14.3 32 32 32l15.3 0 89.6 128-89.6 128-15.3 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l32 0c10.4 0 20.2-5.1 26.2-13.6L240 311.8 325.8 434.4c6 8.6 15.8 13.6 26.2 13.6l32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-15.3 0-89.6-128 89.6-128 15.3 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0c-10.4 0-20.2 5.1-26.2 13.6L240 200.2 154.2 77.6C148.2 69.1 138.4 64 128 64L96 64z"],
    "uniform-martial-arts": [640, 512, [], "e3d1", "M180 0l37.6 0c12.3 0 23.5 7 28.8 18.1l61.1 126.7-54.6 143.3-109 0 0-154.9-46 83.7c-1.3 2.4-2 5-2 7.7L96 384c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32L0 224.4c0-18.9 4.8-37.4 13.9-54L80.3 49.7c15.7-28.5 44.6-47 76.7-49.5 1-.2 2-.3 3-.3l20 0zM389.1 20.6C393.8 8.2 405.7 0 419 0l61 0c1 0 2 .1 3 .3 32.1 2.5 61 20.9 76.7 49.5l66.4 120.7c9.1 16.5 13.9 35.1 13.9 54L640 384c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-159.6c0-2.7-.7-5.3-2-7.7l-46-83.7 0 154.9-208.8 0c35.7-93.7 69.7-182.9 101.9-267.4zM320 320l176 0 0 32-146.1 0 47.4 71.1c4.9 7.4 2.9 17.3-4.4 22.2s-17.3 2.9-22.2-4.4l-50.7-76-50.7 76c-4.9 7.4-14.8 9.3-22.2 4.4s-9.3-14.8-4.4-22.2l47.4-71.1-146.1 0 0-32 176 0zM216.1 405.4c-14.7 22.1-8.7 51.9 13.3 66.6s51.9 8.7 66.6-13.3l24.1-36.1 24.1 36.1c14.7 22.1 44.5 28 66.6 13.3s28-44.5 13.3-66.6l-14.2-21.4 86.3 0 0 64c0 35.3-28.7 64-64 64l-224 0c-35.3 0-64-28.7-64-64l0-64 86.3 0-14.2 21.4z"],
    "circle-user-circle-user": [640, 512, [], "e7a5", "M496 208c-77.5 0-144.3 45.9-174.6 112l-1.4 0-64 0c-47.4 0-88.9 25.8-111 64.2 35.2 39.2 86.2 63.8 143 63.8 7.4 0 14.6-.4 21.7-1.2 5.5 21.9 14.8 42.4 27.1 60.6-15.8 3-32.1 4.6-48.8 4.6-141.4 0-256-114.6-256-256S146.6 0 288 0c126.8 0 232.1 92.2 252.4 213.2-14.3-3.4-29.1-5.2-44.4-5.2zM288 272a72 72 0 1 0 0-144 72 72 0 1 0 0 144zm64 128a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm221.7 80.7c-6.2-19-24-32.7-45.1-32.7l-65.2 0c-21 0-38.9 13.7-45.1 32.7 20.1 19.4 47.5 31.3 77.7 31.3s57.5-11.9 77.7-31.3zM544 368a48 48 0 1 0 -96 0 48 48 0 1 0 96 0z"],
    "circle-stop": [512, 512, [62094, "stop-circle"], "f28d", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM192 160l128 0c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32l-128 0c-17.7 0-32-14.3-32-32l0-128c0-17.7 14.3-32 32-32z"],
    "arrows-up-down": [256, 512, ["arrows-v"], "f07d", "M150.6-22.6c-12.5-12.5-32.8-12.5-45.3 0l-96 96c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L96 77.3 96 434.7 54.6 393.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l96 96c6 6 14.1 9.4 22.6 9.4s16.6-3.4 22.6-9.4l96-96c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-41.4 41.4 0-357.5 41.4 41.4c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-96-96z"],
    "meter-droplet": [640, 512, [], "e1ea", "M569.3 204.9l2 2.3C548.5 89.1 444.7 0 320 0 178.6 0 64 114.6 64 256S178.6 512 320 512c15.7 0 31-1.4 45.9-4.1-13.9-24.1-21.9-52-21.9-81.9 0-47.7 21.5-94.5 43.2-130.6 22.4-37.4 49.2-69.9 67.5-90.5 30.7-34.6 84-34.6 114.7 0zM320 128c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-48c0-13.3 10.7-24 24-24zm-72 24l0 48c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-48c0-13.3 10.7-24 24-24s24 10.7 24 24zM392 426.1C392 491.2 445.7 544 512 544s120-52.8 120-117.9c0-68.9-64.1-150.4-98.6-189.3-11.6-13.1-31.3-13.1-42.9 0-34.5 38.9-98.6 120.4-98.6 189.3z"],
    "ornament": [448, 512, [], "f7b8", "M208 64.6L208 32c0-8.8 7.2-16 16-16s16 7.2 16 16l0 32.6c-10.5-.7-21.5-.7-32 0zm-48 8.7C98.8 91.5 48.6 135.2 21.6 192l404.9 0C399.4 135.2 349.2 91.5 288 73.3L288 32c0-35.3-28.7-64-64-64S160-3.3 160 32l0 41.3zM0 288c0 16.5 1.8 32.5 5.2 48l437.7 0c3.4-15.5 5.2-31.5 5.2-48s-1.8-32.5-5.2-48L5.2 240C1.8 255.5 0 271.5 0 288zm21.6 96c36 75.7 113.1 128 202.4 128s166.5-52.3 202.4-128L21.6 384z"],
    "display-slash": [576, 512, ["desktop-slash"], "e2fa", "M41-24.9c-9.4-9.4-24.6-9.4-33.9 0S-2.3-.3 7 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9L481.8 416c34.5-1 62.2-29.2 62.2-64l0-256c0-35.3-28.7-64-64-64L97.8 32 41-24.9zM161.8 96l318.2 0 0 256-62.2 0-256-256zM282 352l-186 0 0-186-64-64 0 250c0 35.3 28.7 64 64 64l144 0-16 48-72 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l272 0c5.1 0 9.8-1.6 13.7-4.3l-43.7-43.7-42 0-16-48 10 0-64-64z"],
    "page-caret-up": [384, 512, ["file-caret-up"], "e42a", "M64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-277.5c0-17-6.7-33.3-18.7-45.3L258.7 18.7C246.7 6.7 230.5 0 213.5 0L64 0zm36.2 307.1l78.7-93c3.3-3.9 8.1-6.1 13.2-6.1s9.9 2.2 13.2 6.1l78.7 93c2.7 3.2 4.2 7.2 4.2 11.3 0 9.7-7.9 17.6-17.6 17.6l-156.9 0c-9.7 0-17.6-7.9-17.6-17.6 0-4.2 1.5-8.2 4.2-11.3z"],
    "poo-storm": [512, 512, ["poo-bolt"], "f75a", "M268.9-31.8c-5.5-.7-11 1.4-14.5 5.7s-4.6 10.1-2.8 15.3c2.8 8.2 4.3 16.9 4.3 26.1 0 21.7-8.5 37.2-21.9 47.6-13.9 10.8-34.1 17-58.1 17l-24 0c-48.6 0-88 39.4-88 88 0 14.8 3.7 28.8 10.2 41.1-42 6.6-74.2 43-74.2 86.9 0 46.6 36.2 84.7 81.9 87.8 3.1-12.4 9.9-23.8 19.6-32.5L242.7 225c12.2-10.9 28-17 44.4-17 44.6 0 76.5 43 63.7 85.7l-12.7 42.4c28.8 1.2 52.7 21.1 59.8 47.9l26.2 0c48.6 0 88-39.4 88-88 0-43.9-32.1-80.3-74.2-86.9 6.5-12.3 10.2-26.2 10.2-41.1 0-48.6-39.4-88-88-88l-9.4 0c.9-5.4 1.4-10.9 1.4-16.6 0-48.7-36.1-88.9-83.1-95.2zM144.6 416l61.8 0-31.2 104.1c-3.6 11.9 5.3 23.9 17.8 23.9 4.6 0 9-1.7 12.4-4.7L346.5 412.9c3.5-3.1 5.5-7.6 5.5-12.4 0-9.2-7.4-16.6-16.6-16.6l-61.8 0 31.2-104.1c3.6-11.9-5.3-23.9-17.8-23.9-4.6 0-9 1.7-12.4 4.7L133.5 387.1c-3.5 3.1-5.5 7.6-5.5 12.4 0 9.2 7.4 16.6 16.6 16.6z"],
    "video-slash": [576, 512, [], "f4e2", "M41-24.9c-9.4-9.4-24.6-9.4-33.9 0S-2.3-.3 7 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-153-153 0-222.2c0-35.3-28.7-64-64-64L129.8 64 41-24.9zM32 128l0 256c0 35.3 28.7 64 64 64l256 0c7.8 0 15.3-1.4 22.2-4L36 105.8c-2.6 6.9-4 14.4-4 22.2zM464 336l73.5 58.8c4.2 3.4 9.4 5.2 14.8 5.2 13.1 0 23.7-10.6 23.7-23.7l0-240.6c0-13.1-10.6-23.7-23.7-23.7-5.4 0-10.6 1.8-14.8 5.2L464 176 464 336z"],
    "square-xmark": [448, 512, [10062, "times-square", "xmark-square"], "f2d3", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm71 135c9.4-9.4 24.6-9.4 33.9 0l55 55 55-55c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-55 55 55 55c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-55-55-55 55c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l55-55-55-55c-9.4-9.4-9.4-24.6 0-33.9z"],
    "message-dots": [512, 512, ["comment-alt-dots", "messaging"], "f4a3", "M0 128L0 352c0 53 43 96 96 96l32 0 0 72c0 13.3 10.7 24 24 24 5.2 0 10.2-1.7 14.4-4.8l115.2-86.4c4.2-3.1 9.2-4.8 14.4-4.8l120 0c53 0 96-43 96-96l0-224c0-53-43-96-96-96L96 32C43 32 0 75 0 128zm128 80a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm128 0a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm96 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"],
    "droplet-degree": [576, 512, ["dewpoint"], "f748", "M256 512c-106 0-192-86-192-192 0-91.2 130.2-274.1 166.6-323.5 5.9-8 15.2-12.5 25.2-12.5l.4 0c10 0 19.3 4.5 25.2 12.5 36.4 49.4 166.6 232.3 166.6 323.5 0 106-86 192-192 192zM528 80a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM416 80a80 80 0 1 1 160 0 80 80 0 1 1 -160 0z"],
    "tower-control": [448, 512, [], "e2a2", "M144 24c0-13.3 10.7-24 24-24L280 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-32 0 0 48 168 0c9.8 0 19.1 4.5 25.1 12.2s8.3 17.7 6 27.3L402.8 320.1c16.4 1.4 29.2 15.1 29.2 31.9 0 17.7-14.3 32-32 32l-16 0 0 128-320 0 0-128-16 0c-17.7 0-32-14.3-32-32 0-16.7 12.8-30.5 29.2-31.9L.9 135.5c-2.3-9.5-.1-19.6 6-27.3S22.2 96 32 96l168 0 0-48-32 0c-13.3 0-24-10.7-24-24zM375.4 160l-71.4 0 0 160 33 0 38.4-160zM256 160l-64 0 0 160 64 0 0-160zm-112 0l-71.4 0 38.4 160 33 0 0-160z"],
    "circle-dong": [512, 512, [], "e723", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm16-376c0-13.3 10.7-24 24-24s24 10.7 24 24l0 8 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0 0 152c0 13.3-10.7 24-24 24-7.6 0-14.4-3.6-18.8-9.1-11.1 5.8-23.7 9.1-37.2 9.1-44.2 0-80-35.8-80-80s35.8-80 80-80c11.4 0 22.2 2.4 32 6.7l0-22.7-32 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l32 0 0-8zM240 240a32 32 0 1 0 0 64 32 32 0 1 0 0-64zM144 392c0-8.8 7.2-16 16-16l192 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-192 0c-8.8 0-16-7.2-16-16z"],
    "burger-cheese": [512, 512, [127828, "cheeseburger"], "f7f1", "M54 224c-12.2 0-22-9.9-22-22 0-17.2 2.6-34.4 10.8-49.5 22.2-40.8 82.3-120.5 213.2-120.5s191 79.6 213.2 120.5c8.2 15.1 10.8 32.3 10.8 49.5 0 12.2-9.9 22-22 22L54 224zm194 48l72 48 72-48 80 0c22.1 0 40 17.9 40 40s-17.9 40-40 40L40 352c-22.1 0-40-17.9-40-40s17.9-40 40-40l208 0zM456 400c13.3 0 24.4 11 20.4 23.6-10.1 32.6-40.5 56.4-76.4 56.4l-288 0C76 480 45.6 456.3 35.6 423.6 31.6 411 42.7 400 56 400l400 0zM280 96a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM144 152a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm248-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"],
    "hand-holding-droplet": [576, 512, ["hand-holding-water"], "f4c1", "M275.5 6.6L209.2 103C198 119.3 192 138.6 192 158.3l0 1.7c0 53 43 96 96 96s96-43 96-96l0-1.7c0-19.8-6-39-17.2-55.3L300.5 6.6C297.7 2.5 293 0 288 0s-9.7 2.5-12.5 6.6zM109.3 341.5L66.7 384 32 384c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32l320.5 0c29 0 57.3-9.3 80.7-26.5l126.6-93.3c17.8-13.1 21.6-38.1 8.5-55.9s-38.1-21.6-55.9-8.5L392.6 416 280 416c-13.3 0-24-10.7-24-24s10.7-24 24-24l72 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-152.2 0c-33.9 0-66.5 13.5-90.5 37.5z"],
    "won-sign": [512, 512, [8361, "krw", "won"], "f159", "M62.4 53.9C56.8 37.1 38.7 28.1 21.9 33.6S-3.9 57.4 1.7 74.1L56.9 240 32 240c-13.3 0-24 10.7-24 24s10.7 24 24 24l40.9 0 56.7 170.1c4.5 13.5 17.4 22.4 31.6 21.9s26.4-10.4 29.8-24.2L233 288 279 288 321 455.8c3.4 13.8 15.6 23.7 29.8 24.2s27.1-8.4 31.6-21.9L439.1 288 480 288c13.3 0 24-10.7 24-24s-10.7-24-24-24l-24.9 0 55.3-165.9c5.6-16.8-3.5-34.9-20.2-40.5s-34.9 3.5-40.5 20.2l-62 186.1-54.6 0-45.9-183.8C283.5 42 270.7 32 256 32s-27.5 10-31 24.2L179 240 124.4 240 62.4 53.9zm78 234.1l26.6 0-11.4 45.6-15.2-45.6zM245 240l11-44.1 11 44.1-22 0zm100 48l26.6 0-15.2 45.6-11.4-45.6z"],
    "object-ungroup": [640, 512, [], "f248", "M32 119.4C12.9 108.4 0 87.7 0 64 0 28.7 28.7 0 64 0 87.7 0 108.4 12.9 119.4 32l209.1 0c11.1-19.1 31.7-32 55.4-32 35.3 0 64 28.7 64 64 0 23.7-12.9 44.4-32 55.4l0 113.1c19.1 11.1 32 31.7 32 55.4 0 35.3-28.7 64-64 64-23.7 0-44.4-12.9-55.4-32l-209.1 0c-11.1 19.1-31.7 32-55.4 32-35.3 0-64-28.7-64-64 0-23.7 12.9-44.4 32-55.4l0-113.1zM119.4 96c-5.6 9.7-13.7 17.8-23.4 23.4l0 113.1c9.7 5.6 17.8 13.7 23.4 23.4l209.1 0c5.6-9.7 13.7-17.8 23.4-23.4l0-113.1c-9.7-5.6-17.8-13.7-23.4-23.4L119.4 96zM544 279.4c-9.7-5.6-17.8-13.7-23.4-23.4l-29.2 0c-5.3-17.7-14.8-33.5-27.4-46.4l0-17.6 56.6 0c11.1-19.1 31.7-32 55.4-32 35.3 0 64 28.7 64 64 0 23.7-12.9 44.4-32 55.4l0 113.1c19.1 11.1 32 31.7 32 55.4 0 35.3-28.7 64-64 64-23.7 0-44.4-12.9-55.4-32l-209.1 0c-11.1 19.1-31.7 32-55.4 32-35.3 0-64-28.7-64-64 0-23.7 12.9-44.4 32-55.4l0-24.6 64 0 0 24.6c9.7 5.6 17.8 13.7 23.4 23.4l209.1 0c5.6-9.7 13.7-17.8 23.4-23.4l0-113.1z"],
    "chart-waterfall": [512, 512, [], "e0eb", "M32 32c17.7 0 32 14.3 32 32l0 336c0 8.8 7.2 16 16 16l400 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L80 480c-44.2 0-80-35.8-80-80L0 64C0 46.3 14.3 32 32 32zM144 224c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32zm144-64l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32s32 14.3 32 32zm80-96c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32zM512 96l0 224c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-224c0-17.7 14.3-32 32-32s32 14.3 32 32z"],
    "comment": [512, 512, [128489, 61669], "f075", "M512 240c0 132.5-114.6 240-256 240-37.1 0-72.3-7.4-104.1-20.7L33.5 510.1c-9.4 4-20.2 1.7-27.1-5.8S-2 485.8 2.8 476.8l48.8-92.2C19.2 344.3 0 294.3 0 240 0 107.5 114.6 0 256 0S512 107.5 512 240z"],
    "space-station-moon": [512, 512, [], "e033", "M512 256c0 10.8-.7 21.4-2 31.9-72.4 25.2-159.6 40.1-254 40.1S74.4 313.1 2 287.9C.7 277.4 0 266.8 0 256 0 114.6 114.6 0 256 0S512 114.6 512 256zM256 376c87 0 169.2-12 241-33.5-35.5 98.8-130 169.5-241 169.5S50.5 441.3 15 342.5C86.8 364 169 376 256 376zM160 160a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm112 0a80 80 0 1 0 -160 0 80 80 0 1 0 160 0z"],
    "up-from-bracket": [448, 512, [], "e590", "M241 7c-9.4-9.4-24.6-9.4-33.9 0L63 151c-6.9 6.9-8.9 17.2-5.2 26.2S70.3 192 80 192l80 0 0 112c0 26.5 21.5 48 48 48l32 0c26.5 0 48-21.5 48-48l0-112 80 0c9.7 0 18.5-5.8 22.2-14.8s1.7-19.3-5.2-26.2L241 7zM64 352c0-17.7-14.3-32-32-32S0 334.3 0 352l0 64c0 53 43 96 96 96l256 0c53 0 96-43 96-96l0-64c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 64c0 17.7-14.3 32-32 32L96 448c-17.7 0-32-14.3-32-32l0-64z"],
    "calendar-circle-plus": [576, 512, [], "e470", "M192 32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 32-32 0c-35.3 0-64 28.7-64 64l0 48 448 0 0-48c0-35.3-28.7-64-64-64l-32 0 0-32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 32-128 0 0-32zM32 416c0 35.3 28.7 64 64 64l161.4 0c-11.2-24.4-17.4-51.4-17.4-80 0-78.7 47.4-146.4 115.1-176L32 224 32 416zM432 544a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm16-208l0 48 48 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-48 0 0 48c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-48-48 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l48 0 0-48c0-8.8 7.2-16 16-16s16 7.2 16 16z"],
    "tablet-screen": [448, 512, ["tablet-android-alt"], "f3fc", "M0 64C0 28.7 28.7 0 64 0L384 0c35.3 0 64 28.7 64 64l0 384c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zM160 440c0 13.3 10.7 24 24 24l80 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0c-13.3 0-24 10.7-24 24zM384 64l-320 0 0 304 320 0 0-304z"],
    "salt-shaker": [384, 512, [129474], "e446", "M311.5 448l-239 0 32-256 175 0 32 256zm-239 64l239 0c38.5 0 68.3-33.7 63.5-71.9L335.9 127C326.8 54.5 265.1 0 192 0S57.2 54.5 48.1 127L9 440.1C4.2 478.3 34 512 72.5 512zM192 48a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM128 96a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM240 80a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"],
    "file-check": [384, 512, [], "f316", "M213.5 0c17 0 33.2 6.8 45.2 18.8L365.3 125.2c12 12 18.7 28.3 18.7 45.2L384 448c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64C0 28.7 28.7 0 64 0L213.5 0zm69.4 260.6c-10.7-7.8-25.7-5.4-33.5 5.3l-85.6 117.7-26.5-27.4c-9.2-9.5-24.4-9.8-33.9-.6s-9.8 24.4-.6 33.9l46.4 48c4.9 5.1 11.8 7.8 18.9 7.3s13.6-4.1 17.8-9.8L288.2 294.1c7.8-10.7 5.4-25.7-5.3-33.5zM208 152c0 13.3 10.7 24 24 24l93.5 0-117.5-117.5 0 93.5z"],
    "hill-avalanche": [576, 512, [], "e507", "M440.1 401.9c34.2 23.1 81.1 19.5 111.4-10.8 34.4-34.4 34.4-90.1 0-124.5-27.8-27.8-69.5-33.1-102.6-16-11.8 6.1-16.4 20.6-10.3 32.3s20.6 16.4 32.3 10.3c15.1-7.8 34-5.3 46.6 7.3 15.6 15.6 15.6 40.9 0 56.6s-40.9 15.6-56.6 0l-81.7-81.7c22.3-14.2 37.1-39.1 37.1-67.5 0-33.9-21.1-62.9-50.9-74.5 1.9-6.8 2.9-14 2.9-21.5 0-44.2-35.8-80-80-80-27.3 0-51.5 13.7-65.9 34.6-5.8-20-24.2-34.6-46.1-34.6-26.5 0-48 21.5-48 48 0 4 .5 7.9 1.4 11.6L440.1 401.9zM480.4 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm0 128a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM68.7 87C43.5 61.8 .4 79.7 .4 115.3L.4 432c0 44.2 35.8 80 80 80l316.7 0c35.6 0 53.5-43.1 28.3-68.3L68.7 87z"],
    "arrows-to-eye": [640, 512, [], "e4bf", "M176 56c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 38.1-63-63c-9.4-9.4-24.6-9.4-33.9 0S21.7 55.6 31 65l63 63-38.1 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l96 0c13.3 0 24-10.7 24-24l0-96zm0 400l0-96c0-13.3-10.7-24-24-24l-96 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l38.1 0-63 63c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l63-63 0 38.1c0 13.3 10.7 24 24 24s24-10.7 24-24zm312 24c13.3 0 24-10.7 24-24l0-38.1 63 63c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-63-63 38.1 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-96 0c-13.3 0-24 10.7-24 24l0 96c0 13.3 10.7 24 24 24zM464 56l0 96c0 13.3 10.7 24 24 24l96 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-38.1 0 63-63c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-63 63 0-38.1c0-13.3-10.7-24-24-24s-24 10.7-24 24zM320 120c-57.3 0-99.4 34-125.6 64.3-20 23.1-32.4 45.8-37.6 56.1-2.5 5-4.9 9.7-4.9 15.6s2.3 10.6 4.9 15.6c5.2 10.3 17.6 33 37.6 56.1 26.2 30.3 68.2 64.3 125.6 64.3s99.4-34 125.6-64.3c20-23.1 32.4-45.8 37.6-56.1 2.5-5 4.9-9.7 4.9-15.6s-2.3-10.6-4.9-15.6c-5.2-10.3-17.6-33-37.6-56.1-26.2-30.3-68.2-64.3-125.6-64.3zM256 256a64 64 0 1 1 128 0 64 64 0 1 1 -128 0z"],
    "snowplow": [640, 512, [], "f7d2", "M128 160l0-96c0-35.3 28.7-64 64-64L296.4 0c24.2 0 46.4 13.7 57.2 35.4l87.6 175.1c4.4 8.9 6.8 18.7 6.8 28.6l0 56.9 80 0 0-80c0-48.6 39.4-88 88-88 13.3 0 24 10.7 24 24s-10.7 24-24 24c-22.1 0-40 17.9-40 40l0 208c0 22.1 17.9 40 40 40 13.3 0 24 10.7 24 24s-10.7 24-24 24c-48.6 0-88-39.4-88-88l0-80-63 0c9.5 16.5 15 35.6 15 56 0 61.9-50.1 112-112 112l-224 0c-61.9 0-112-50.1-112-112 0-30.5 12.2-58.2 32-78.4L64 224c0-35.3 28.7-64 64-64zm91.7 34.9l43.6 29.1 113.2 0-80-160-104.4 0 0 108.8 27.7 22.1zM416 400c0-26.5-21.5-48-48-48l-224 0c-26.5 0-48 21.5-48 48s21.5 48 48 48l224 0c26.5 0 48-21.5 48-48zm-280 0a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm216-24a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM232 400a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"],
    "shield-exclamation": [512, 512, [], "e247", "M256.1 0c4.6 0 9.2 1 13.3 2.9L457.8 82.8c22 9.3 38.4 31 38.3 57.2-.5 99.2-41.3 280.7-213.7 363.2-16.7 8-36.1 8-52.7 0-172.4-82.5-213.1-263.9-213.6-363.2-.1-26.2 16.3-47.9 38.3-57.2L242.7 2.9C246.8 1 251.4 0 256.1 0zm0 304a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm0-192c-18.2 0-32.7 15.5-31.4 33.7l7.4 104c.9 12.6 11.4 22.3 23.9 22.3 12.6 0 23-9.7 23.9-22.3l7.4-104c1.3-18.2-13.1-33.7-31.4-33.7z"],
    "square-w": [448, 512, [], "e285", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm79.2 129.7l26.6 97.6 31.4-98.6c3.2-10 12.4-16.7 22.9-16.7s19.7 6.8 22.9 16.7l31.4 98.6 26.6-97.6c3.5-12.8 16.7-20.3 29.5-16.8s20.3 16.7 16.8 29.5l-48 176c-2.8 10.3-12 17.5-22.7 17.7s-20.1-6.6-23.4-16.7L224 247.2 190.9 351.3c-3.2 10.1-12.7 16.9-23.4 16.7s-19.9-7.4-22.7-17.7l-48-176c-3.5-12.8 4.1-26 16.8-29.5s26 4.1 29.5 16.8z"],
    "chart-gantt": [512, 512, [], "e0e4", "M64 64c0-17.7-14.3-32-32-32S0 46.3 0 64L0 400c0 44.2 35.8 80 80 80l400 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L80 416c-8.8 0-16-7.2-16-16L64 64zm96 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l96 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-96 0zm64 112c-17.7 0-32 14.3-32 32s14.3 32 32 32l128 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-128 0zM384 288c-17.7 0-32 14.3-32 32s14.3 32 32 32l64 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0z"],
    "credit-card-blank": [512, 512, [], "f389", "M64 64C28.7 64 0 92.7 0 128L0 384c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L64 64zM88 336l48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zm144 0l48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zm144 0l48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"],
    "hands-holding-dollar": [640, 512, ["hands-usd"], "f4c5", "M320-16c13.3 0 24 10.7 24 24l0 12 16 0c15.5 0 28 12.5 28 28s-12.5 28-28 28l-65.8 0c-5.7 0-10.2 4.6-10.2 10.2 0 5.2 3.8 9.5 9 10.2l61 7.6c33.1 4.1 58 32.3 58 65.7 0 36.6-29.7 66.2-66.2 66.2l-1.8 0 0 12c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-12-24 0c-15.5 0-28-12.5-28-28s12.5-28 28-28l73.8 0c5.7 0 10.2-4.6 10.2-10.2 0-5.2-3.8-9.5-9-10.2L286 152c-33.1-4.1-58-32.3-58-65.7 0-36.6 29.7-66.2 66.2-66.2l1.8 0 0-12c0-13.3 10.7-24 24-24zM40 64c22.1 0 40 17.9 40 40l0 160.2c0 17 6.7 33.3 18.7 45.3l51.1 51.1c8.3 8.3 21.3 9.6 31 3.1 12.9-8.6 14.7-26.9 3.7-37.8-7.3-7.3-23.1-23.1-47.2-47.2-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0c24.1 24.1 39.9 39.9 47.2 47.2l0 0 25.3 25.3c21 21 32.8 49.5 32.8 79.2l0 78.9c0 26.5-21.5 48-48 48l-66.7 0c-17 0-33.3-6.7-45.3-18.7L28.1 393.4C10.1 375.4 0 351 0 325.5L0 104C0 81.9 17.9 64 40 64zm560 0c22.1 0 40 17.9 40 40l0 221.5c0 25.5-10.1 49.9-28.1 67.9L512 493.3c-12 12-28.3 18.7-45.3 18.7L400 512c-26.5 0-48-21.5-48-48l0-78.9c0-29.7 11.8-58.2 32.8-79.2l25.3-25.3 0 0c7.3-7.3 23.1-23.1 47.2-47.2 12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3c-24.1 24.1-39.9 39.9-47.2 47.2-11 11-9.2 29.2 3.7 37.8 9.7 6.5 22.7 5.2 31-3.1l51.1-51.1c12-12 18.7-28.3 18.7-45.3L560 104c0-22.1 17.9-40 40-40z"],
    "building-magnifying-glass": [512, 512, [], "e61c", "M0 64C0 28.7 28.7 0 64 0L320 0c35.3 0 64 28.7 64 64l0 116.8c-12.8-3.1-26.2-4.8-40-4.8-92.8 0-168 75.2-168 168 0 2.7 .1 5.4 .2 8l-.2 0c-17.7 0-32 14.3-32 32l0 80 82.4 0c27 26.4 62.9 43.9 102.7 47.4-3 .4-6 .6-9.1 .6L64 512c-35.3 0-64-28.7-64-64L0 64zM112 96c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0zm112 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zM112 224c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0zM344 416.1a72 72 0 1 0 0-144 72 72 0 1 0 0 144zm0 48c-66.3 0-120-53.7-120-120s53.7-120 120-120 120 53.7 120 120c0 24.5-7.3 47.2-19.9 66.2L505 471.1c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-60.8-60.9c-19 12.6-41.7 19.9-66.2 19.9z"],
    "square-a": [448, 512, [], "e25f", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM224 144c9.1 0 17.4 5.1 21.5 13.3l88 176c5.9 11.9 1.1 26.3-10.7 32.2s-26.3 1.1-32.2-10.7l-9.4-18.7-114.3 0-9.4 18.7c-5.9 11.9-20.3 16.7-32.2 10.7s-16.7-20.3-10.7-32.2l88-176c4.1-8.1 12.4-13.3 21.5-13.3zm0 77.7l-33.2 66.3 66.3 0-33.2-66.3z"],
    "video": [576, 512, ["video-camera"], "f03d", "M96 64c-35.3 0-64 28.7-64 64l0 256c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L96 64zM464 336l73.5 58.8c4.2 3.4 9.4 5.2 14.8 5.2 13.1 0 23.7-10.6 23.7-23.7l0-240.6c0-13.1-10.6-23.7-23.7-23.7-5.4 0-10.6 1.8-14.8 5.2L464 176 464 336z"],
    "face-pouting": [512, 512, [], "e387", "M0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zM161.3 382.1c-5.4 12.3 8.7 21.6 21.1 16.4 22.4-9.5 47.4-14.8 73.7-14.8s51.3 5.3 73.7 14.8c12.4 5.2 26.5-4.1 21.1-16.4-16-36.6-52.4-62.1-94.8-62.1s-78.8 25.6-94.8 62.1zM176 272c17.7 0 32-14.3 32-32l0-.3 9.7 3.2c10.5 3.5 21.8-2.2 25.3-12.6s-2.2-21.8-12.6-25.3l-96-32c-10.5-3.5-21.8 2.2-25.3 12.6s2.2 21.8 12.6 25.3l28.9 9.6c-4.1 5.4-6.6 12.1-6.6 19.4 0 17.7 14.3 32 32 32zm192-32c0-7.3-2.4-14-6.6-19.4l28.9-9.6c10.5-3.5 16.1-14.8 12.6-25.3s-14.8-16.1-25.3-12.6l-96 32c-10.5 3.5-16.1 14.8-12.6 25.3s14.8 16.1 25.3 12.6l9.7-3.2 0 .3c0 17.7 14.3 32 32 32s32-14.3 32-32z"],
    "chess-pawn": [384, 512, [9823], "f443", "M192-32c66.3 0 120 53.7 120 120 0 27-8.9 51.9-24 72 17.7 0 32 14.3 32 32s-14.3 32-32 32l-10.7 0 26.7 160 56.2 70.3c5 6.3 7.8 14.1 7.8 22.2 0 19.6-15.9 35.5-35.5 35.5L51.5 512c-19.6 0-35.5-15.9-35.5-35.5 0-8.1 2.7-15.9 7.8-22.2L80 384 106.7 224 96 224c-17.7 0-32-14.3-32-32s14.3-32 32-32c-15.1-20.1-24-45-24-72 0-66.3 53.7-120 120-120z"],
    "user-headset": [448, 512, [], "f82d", "M80 160C80 80.5 144.5 16 224 16S368 80.5 368 160l0 112-80 0c0-26.5-21.5-48-48-48l-32 0c-26.5 0-48 21.5-48 48s21.5 48 48 48l184 0c13.3 0 24-10.7 24-24l0-136C416 54 330-32 224-32S32 54 32 160c0 13.3 10.7 24 24 24s24-10.7 24-24zm256 0c0-61.9-50.1-112-112-112S112 98.1 112 160c0 24.5 7.9 47.2 21.2 65.6 15.5-25 43.2-41.6 74.8-41.6l32 0c30.9 0 58.1 15.9 73.8 40l2.2 0c12.7-18.1 20.1-40.2 20.1-64zM153.1 352C77.4 352 16 413.4 16 489.1 16 501.8 26.2 512 38.9 512l370.3 0c12.6 0 22.9-10.2 22.9-22.9 0-75.7-61.4-137.1-137.1-137.1l-141.7 0z"],
    "synagogue": [576, 512, [128333], "f69b", "M16 80c0-35.3 28.7-64 64-64s64 28.7 64 64l0 32-128 0 0-32zm0 368l0-288 128 0 126.2-84.2c10.7-7.2 24.8-7.2 35.5 0l126.2 84.2 128 0 0 288c0 35.3-28.7 64-64 64L80 512c-35.3 0-64-28.7-64-64zM560 112l-128 0 0-32c0-35.3 28.7-64 64-64s64 28.7 64 64l0 32zM224 384l0 80 128 0 0-80c0-35.3-28.7-64-64-64s-64 28.7-64 64zm64-152a40 40 0 1 0 0-80 40 40 0 1 0 0 80z"],
    "mug": [576, 512, [], "f874", "M96 64C78.3 64 64 78.3 64 96l0 256c0 53 43 96 96 96l192 0c53 0 96-43 96-96l0-32c70.7 0 128-57.3 128-128S518.7 64 448 64L96 64zm352 64c35.3 0 64 28.7 64 64s-28.7 64-64 64l0-128z"],
    "shirt-jersey": [640, 512, [], "e6d7", "M400.2 32c0 44.2-35.8 80-80 80s-80-35.8-80-80l-53.5 0c-17 0-33.3 6.7-45.3 18.7l-77.3 77.3 96 96 0 224c0 35.3 28.7 64 64 64l192 0c35.3 0 64-28.7 64-64l0-224 96-96-77.3-77.3C487 38.7 470.7 32 453.7 32l-53.5 0zM604.5 156.3l-96 96 13.1 13.1c12.5 12.5 32.8 12.5 45.3 0l50.7-50.7c12.5-12.5 12.5-32.8 0-45.3l-13.1-13.1zM22.9 169.4c-12.5 12.5-12.5 32.8 0 45.3l50.7 50.7c12.5 12.5 32.8 12.5 45.3 0l13.1-13.1-96-96-13.1 13.1zM296.2 216l0 48c0 8.8 7.2 16 16 16l16 0c8.8 0 16-7.2 16-16l0-48c0-8.8-7.2-16-16-16l-16 0c-8.8 0-16 7.2-16 16zm-40 0c0-30.9 25.1-56 56-56l16 0c30.9 0 56 25.1 56 56l0 48c0 30.9-25.1 56-56 56l-16 0c-30.9 0-56-25.1-56-56l0-48z"],
    "building-circle-check": [576, 512, [], "e4d2", "M96 0C60.7 0 32 28.7 32 64l0 384c0 35.3 28.7 64 64 64l180 0c-10.5-14.6-19-30.7-25.1-48l-74.9 0 0-80c0-17.7 14.3-32 32-32l32 0c2 0 4 .2 5.9 .5 6-23.6 16.3-45.4 30.1-64.5l-4 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 4c27.5-19.8 60.3-32.4 96-35.4L416 64c0-35.3-28.7-64-64-64L96 0zm32 112c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM272 96l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM128 240c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM576 400a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-86.6-60.9c7.1 5.2 8.7 15.2 3.5 22.3l-64 88c-2.8 3.8-7 6.2-11.7 6.5s-9.3-1.3-12.6-4.6l-40-40c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l26.8 26.8 53-72.9c5.2-7.1 15.2-8.7 22.4-3.5z"],
    "calendar-plus": [448, 512, [], "f271", "M128 0c17.7 0 32 14.3 32 32l0 32 128 0 0-32c0-17.7 14.3-32 32-32s32 14.3 32 32l0 32 32 0c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 128C0 92.7 28.7 64 64 64l32 0 0-32c0-17.7 14.3-32 32-32zm96 192c-13.3 0-24 10.7-24 24l0 48-48 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l48 0 0 48c0 13.3 10.7 24 24 24s24-10.7 24-24l0-48 48 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0 0-48c0-13.3-10.7-24-24-24z"],
    "wheelchair-move": [448, 512, ["wheelchair-alt"], "e2ce", "M312 56a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zM205.4 124.1c-6.4-5.2-15.6-4.7-21.4 1.1l-33.4 33.4c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L138.8 80c29-29 75.2-31.4 107-5.5l81.3 66c21.4 17.4 23.8 49.2 5.2 69.5l-41.8 46 98 0c30.3 0 53 27.7 47.1 57.4L407.4 454.3c-3.5 17.3-20.3 28.6-37.7 25.1s-28.6-20.3-25.1-37.7L369 320 316.8 320c2.1 10.3 3.2 21 3.2 32 0 88.4-71.6 160-160 160S0 440.4 0 352 71.6 192 160 192c6 0 11.9 .3 17.8 1l50.4-50.4-22.7-18.5zM160 448a96 96 0 1 0 0-192 96 96 0 1 0 0 192z"],
    "user-key": [576, 512, [], "e7b0", "M224 248a120 120 0 1 0 0-240 120 120 0 1 0 0 240zm-29.7 56C95.8 304 16 383.8 16 482.3 16 498.7 29.3 512 45.7 512l322.3 0 0-80c-37-27.8-61.6-71.3-63.8-120.8-16-4.7-32.9-7.2-50.4-7.2l-59.4 0zM576 304c0-61.9-50.1-112-112-112S352 242.1 352 304c0 44.7 26.2 83.2 64 101.2l0 116.2c0 4.2 1.7 8.3 4.7 11.3l32 32c6.2 6.2 16.4 6.2 22.6 0l41.4-41.4c6.2-6.2 6.2-16.4 0-22.6L496 480 517.9 458.1c5.8-5.8 6.3-14.9 1.2-21.3l-20.9-26.1C543.3 396.3 576 353.9 576 304zM432 288a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"],
    "user-shield": [576, 512, [], "f505", "M224 248a120 120 0 1 0 0-240 120 120 0 1 0 0 240zm-29.7 56C95.8 304 16 383.8 16 482.3 16 498.7 29.3 512 45.7 512l251.5 0C261 469.4 240 414.5 240 356.4l0-31.1c0-7.3 1-14.5 2.9-21.3l-48.6 0zm251 184.5l-13.3 6.3 0-188.1 96 32 0 19.6c0 55.8-32.2 106.5-82.7 130.3zM421.9 259.5l-112 37.3c-13.1 4.4-21.9 16.6-21.9 30.4l0 31.1c0 74.4 43 142.1 110.2 173.7l18.5 8.7c4.8 2.2 10 3.4 15.2 3.4s10.5-1.2 15.2-3.4l18.5-8.7C533 500.3 576 432.6 576 358.2l0-31.1c0-13.8-8.8-26-21.9-30.4l-112-37.3c-6.6-2.2-13.7-2.2-20.2 0z"],
    "tally-4": [448, 512, [], "e297", "M64 64c0-17.7-14.3-32-32-32S0 46.3 0 64L0 448c0 17.7 14.3 32 32 32s32-14.3 32-32L64 64zm128 0c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 384c0 17.7 14.3 32 32 32s32-14.3 32-32l0-384zm96-32c-17.7 0-32 14.3-32 32l0 384c0 17.7 14.3 32 32 32s32-14.3 32-32l0-384c0-17.7-14.3-32-32-32zM448 64c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 384c0 17.7 14.3 32 32 32s32-14.3 32-32l0-384z"],
    "bread-loaf": [576, 512, [127838], "f7eb", "M0 224l0-32C0 121.3 57.3 64 128 64l96 0c70.7 0 128 57.3 128 128l0 32c0 17.7-14.3 32-32 32l0 160c0 35.3-28.7 64-64 64L96 480c-35.3 0-64-28.7-64-64l0-160c-17.7 0-32-14.3-32-32zM344.8 64L448 64c70.7 0 128 57.3 128 128l0 32c0 17.7-14.3 32-32 32l-150.7 0c4.3-9.8 6.7-20.6 6.7-32l0-32c0-50.4-21.2-95.9-55.2-128zM368 416l0-112 176 0 0 112c0 35.3-28.7 64-64 64l-132.1 0c12.7-18.1 20.1-40.2 20.1-64z"],
    "circle-0": [512, 512, [], "e0ed", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm0-368c53 0 96 43 96 96l0 32c0 53-43 96-96 96s-96-43-96-96l0-32c0-53 43-96 96-96zm-48 96l0 32c0 26.5 21.5 48 48 48s48-21.5 48-48l0-32c0-26.5-21.5-48-48-48s-48 21.5-48 48z"],
    "bold": [384, 512, [], "f032", "M32 32C14.3 32 0 46.3 0 64S14.3 96 32 96l32 0 0 320-32 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l224 0c70.7 0 128-57.3 128-128 0-46.5-24.8-87.3-62-109.7 18.7-22.3 30-51 30-82.3 0-70.7-57.3-128-128-128L32 32zM288 160c0 35.3-28.7 64-64 64l-96 0 0-128 96 0c35.3 0 64 28.7 64 64zM128 416l0-128 128 0c35.3 0 64 28.7 64 64s-28.7 64-64 64l-128 0z"],
    "heart-pulse": [512, 512, ["heartbeat"], "f21e", "M256 107.9L241 87.1C216 52.5 175.9 32 133.1 32 59.6 32 0 91.6 0 165.1l0 2.6c0 23.6 6.2 48 16.6 72.3l106 0c3.2 0 6.1-1.9 7.4-4.9l31.8-76.3c3.7-8.8 12.3-14.6 21.8-14.8s18.3 5.4 22.2 14.1l51.3 113.9 41.4-82.8c4.1-8.1 12.4-13.3 21.5-13.3s17.4 5.1 21.5 13.3l23.2 46.3c1.4 2.7 4.1 4.4 7.2 4.4l123.6 0c10.5-24.3 16.6-48.7 16.6-72.3l0-2.6C512 91.6 452.4 32 378.9 32 336.2 32 296 52.5 271 87.1l-15 20.7zM469.6 288l-97.8 0c-21.2 0-40.6-12-50.1-31l-1.7-3.4-42.5 85.1c-4.1 8.3-12.7 13.5-22 13.3s-17.6-5.7-21.4-14.1l-49.3-109.5-10.5 25.2c-8.7 20.9-29.1 34.5-51.7 34.5l-80.2 0c47.2 73.8 123 141.7 170.4 177.9 12.4 9.4 27.6 14.1 43.1 14.1s30.8-4.6 43.1-14.1C346.6 429.7 422.4 361.8 469.6 288z"],
    "square-root-variable": [576, 512, ["square-root-alt"], "f698", "M282.6 78.1c8-27.3 33-46.1 61.4-46.1l200 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L344 96 238.7 457c-3.6 12.3-14.1 21.2-26.8 22.8s-25.1-4.6-31.5-15.6L77.6 288 32 288c-17.7 0-32-14.3-32-32s14.3-32 32-32l45.6 0c22.8 0 43.8 12.1 55.3 31.8l65.2 111.8 84.4-289.5zM393.4 233.4c12.5-12.5 32.8-12.5 45.3 0l41.4 41.4 41.4-41.4c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3l-41.4 41.4 41.4 41.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0l-41.4-41.4-41.4 41.4c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l41.4-41.4-41.4-41.4c-12.5-12.5-12.5-32.8 0-45.3z"],
    "message-check": [512, 512, ["comment-alt-check"], "f4a2", "M416 32c53 0 96 43 96 96l0 224c0 53-43 96-96 96l-120 0c-5.2 0-10.3 1.7-14.4 4.8L166.4 539.2c-4.2 3.1-9.2 4.8-14.4 4.8-13.3 0-24-10.7-24-24l0-72-32 0c-53 0-96-43-96-96L0 128C0 75 43 32 96 32l320 0zm-42 97.7c-10.7-7.8-25.7-5.4-33.5 5.3L221.1 299.2 169 247.1c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l72 72c5 5 11.9 7.5 18.8 7s13.4-4.1 17.5-9.8L379.3 163.2c7.8-10.7 5.4-25.7-5.3-33.5z"],
    "hands-bubbles": [512, 512, ["hands-wash"], "e05e", "M384 64a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm96 128a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM128 464a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM0 160l.1 72.6c0 44.8 17.6 87.1 47.9 118.4 .3-77 40.1-148.4 105.4-189.3l1.9-1.2c-2.5-3.7-2.8-8.6-.4-12.7l62-107.4c6.6-11.5 2.7-26.2-8.8-32.8S182 5 175.4 16.5l-68 117.8 0 0 0 0-43.3 75 0-49.3c0-17.7-14.4-32-32-32S0 142.4 0 160zm213.6-35.9c14.1-8.8 29.8-12.7 45.2-12.1l36.5-63.3c6.6-11.5 2.7-26.2-8.8-32.8s-26.2-2.7-32.8 8.8l-67.1 116.2 27-16.9zm86.5-35.7l-16.4 28.4c15.1 5.5 28.6 15.6 38.3 29.7l19.7-34.2c6.6-11.5 2.7-26.2-8.8-32.8s-26.2-2.7-32.8 8.8zm46.4 63.7l-12.5 21.7c2 8.6 2.5 17.5 1.7 26.1l4.3 0 0 0 34.4 0 13.7-23.8c6.6-11.5 2.7-26.2-8.8-32.8s-26.2-2.7-32.8 8.8zM283.1 175c-9.4-15-29.1-19.5-44.1-10.2l-60.2 37.6C127.3 234.7 96 291.2 96 352l0 8c0 8.9 .8 17.6 2.2 26.1 35.4 8.2 61.8 40 61.8 77.9 0 6.3-.7 12.5-2.1 18.4 25.2 18.6 56.4 29.6 90.1 29.6l176 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-92 0c-6.6 0-12-5.4-12-12s5.4-12 12-12l124 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-124 0c-6.6 0-12-5.4-12-12s5.4-12 12-12l156 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-156 0c-6.6 0-12-5.4-12-12s5.4-12 12-12l124 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-136 0 0 0 0 0-93.2 0 46.2-28.9c15-9.4 19.5-29.1 10.2-44.1z"],
    "guitars": [576, 512, [], "f8bf", "M120 0l48 0c13.3 0 24 10.7 24 24l0 52.2c0 6.2-1.4 12.3-4.2 17.9L168 133.7 168 178c50.3 8.6 88 43.8 88 86 0 14-4.2 27.3-11.6 39.1-8.2 13-7.5 31.9 2.9 43.4 9.8 10.9 17.1 23.3 21.1 36.8-7.3 16.1-12.4 34.7-12.4 54.9 0 6.2 .5 12.2 1.3 18.2-21.4 33.1-64.1 55.6-113.3 55.6-70.7 0-128-46.6-128-104 0-23 9.2-44.3 24.8-61.5 10.3-11.4 11.1-30.4 2.9-43.4-7.5-11.8-11.6-25.1-11.6-39.1 0-42.1 37.7-77.3 88-86l0-44.4-19.8-39.6C97.4 88.6 96 82.4 96 76.2L96 24c0-13.3 10.7-24 24-24zm24 344a40 40 0 1 0 0-80 40 40 0 1 0 0 80zM408 148.6l-21.4-24.5c-6.6-7.6-9.3-17.9-7.2-27.8l13.9-64.8C397.2 13.1 413.4 0 432.2 0 454.2 0 472 17.8 472 39.8l0 4.6c0 12.4-6.4 23.3-16 29.7l0 164.7c27.9-4.2 39.6-19.4 44.5-31.3 3.3-8.2 10.7-15.5 19.5-15.5s16 7.2 16 16l0 29.3c0 11.6-4.8 22.8-9.3 33.5l-.5 1.1c-3.3 7.8-6.2 18.5-6.2 32.1 0 33.5 17 70.9 28.8 92.9 6.9 12.7 11.2 26.9 11.2 41.3 0 40.8-33 73.8-73.8 73.8l-108.4 0c-40.8 0-73.8-33-73.8-73.8 0-14.5 4.3-28.6 11.2-41.3 11.8-22 28.8-59.3 28.8-92.9 0-11.2-2-20.5-4.5-27.8-.9-2.5-1.8-5-2.7-7.5l0 0c-4.3-11.8-8.8-23.8-8.8-36.2l0-40.6c0-8.8 7.2-16 16-16s16.1 7.2 18.2 15.8c3.9 16.4 14.9 40.5 45.8 46.7l0-89.9zM392 312c0 13.3 10.7 24 24 24l40 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-40 0c-13.3 0-24 10.7-24 24zm0 80c0 13.3 10.7 24 24 24l40 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-40 0c-13.3 0-24 10.7-24 24z"],
    "marker": [512, 512, [], "f5a1", "M408.8 0c-27.4 0-53.6 10.9-73 30.2L318.1 48 305 34.9c-28.1-28.1-73.7-28.1-101.8 0L103 135c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0L237.1 68.9c9.4-9.4 24.6-9.4 33.9 0L284.1 81.9 184 182.1 329.9 328 481.8 176.2c19.4-19.4 30.2-45.6 30.2-73 0-57-46.2-103.2-103.2-103.2zM102.4 263.7c-49.9 49.9-83.3 114-95.5 183.5L.4 483.8C-1 491.6 1.5 499.4 7 505s13.4 8 21.1 6.7l36.7-6.5c69.5-12.3 133.6-45.6 183.5-95.5L296 361.9 150.1 216 102.4 263.7z"],
    "user-hair-long": [448, 512, [], "e45b", "M304 128c0-20.2-7.5-38.6-19.8-52.7l-33.1 28.9c-17.5 15.3-40 23.8-63.2 23.8l-43.9 0 0 16c0 44.2 35.8 80 80 80s80-35.8 80-80l0-16zM96 128c0-38.9 17.4-73.8 44.8-97.3 3.6-3.8 7.9-7.1 12.6-9.5 20.2-13.4 44.5-21.2 70.6-21.2 70.7 0 128 57.3 128 128l0 24.2c0 25.5 10.1 49.9 28.1 67.9l13.3 13.3c4.2 4.2 6.6 10 6.6 16 0 12.5-10.1 22.6-22.6 22.6L70.6 272c-12.5 0-22.6-10.1-22.6-22.6 0-6 2.4-11.8 6.6-16l13.3-13.3c18-18 28.1-42.4 28.1-67.9L96 128zm84.6 192l86.9 0c90.9 0 164.6 73.7 164.6 164.6 0 15.1-12.3 27.4-27.4 27.4L43.4 512C28.3 512 16 499.7 16 484.6 16 393.7 89.7 320 180.6 320z"],
    "traffic-light-go": [320, 512, [], "f638", "M64-32C28.7-32 0-3.3 0 32L0 384c0 88.4 71.6 160 160 160s160-71.6 160-160l0-352c0-35.3-28.7-64-64-64L64-32zm96 392c30.9 0 56 25.1 56 56s-25.1 56-56 56-56-25.1-56-56 25.1-56 56-56zm56-104a56 56 0 1 1 -112 0 56 56 0 1 1 112 0zM160 152a56 56 0 1 1 0-112 56 56 0 1 1 0 112zm24-56a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM160 280a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"],
    "house-person-leave": [640, 512, ["house-leave", "house-person-depart"], "e00f", "M328 24a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm-8 181.3l-22.6 22.6c-6 6-9.4 14.1-9.4 22.6l0 37.5c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-37.5c0-25.5 10.1-49.9 28.1-67.9l35.1-35.1c22.8-22.8 53.6-35.6 85.8-35.6 36.9 0 71.8 16.8 94.8 45.6L485.8 180c6.1 7.6 15.3 12 25 12l33.2 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-33.2 0c-29.2 0-56.7-13.3-75-36l-3.8-4.7 0 115.2 34.5 29.6c17.7 15.2 29.3 36.2 32.6 59.3l12.6 88.1c2.5 17.5-9.7 33.7-27.2 36.2s-33.7-9.7-36.2-27.2l-12.6-88.1c-1.1-7.7-5-14.7-10.9-19.8l-71.4-61.2c-21.3-18.2-33.5-44.9-33.5-72.9l0-69.3zm.1 165.8c2.4 2.3 4.8 4.6 7.4 6.8l46 39.4-2.2 7.6c-4.5 15.7-12.9 30-24.4 41.5l-68.3 68.3c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l68.3-68.3c3.8-3.8 6.6-8.6 8.1-13.8L320.1 371zM213.5 24.2l72.2 64.1c-11.7 7-22.6 15.6-32.5 25.4l-35.1 35.1c-27 27-42.2 63.6-42.2 101.8l0 37.5c0 26.2 12.6 49.4 32 64L96 352c-26.5 0-48-21.5-48-48l0-112-10.8 0c-11.7 0-21.2-9.5-21.2-21.2 0-6.1 2.6-11.8 7.1-15.9L170.5 24.2c5.9-5.3 13.6-8.2 21.5-8.2s15.6 2.9 21.5 8.2z"],
    "down-up": [512, 512, [], "e6c1", "M361.4 9.4c12.5-12.5 32.8-12.5 45.3 0l96 96c9.2 9.2 11.9 22.9 6.9 34.9S492.9 160 480 160l-64 0 0 320c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-320-64 0c-12.9 0-24.6-7.8-29.6-19.8s-2.2-25.7 6.9-34.9l96-96zm-256 493.3l-96-96c-9.2-9.2-11.9-22.9-6.9-34.9S19.1 352 32 352l64 0 0-320c0-17.7 14.3-32 32-32s32 14.3 32 32l0 320 64 0c12.9 0 24.6 7.8 29.6 19.8s2.2 25.7-6.9 34.9l-96 96c-12.5 12.5-32.8 12.5-45.3 0z"],
    "clipboard": [384, 512, [128203], "f328", "M320 32l-8.6 0C300.4 12.9 279.7 0 256 0L128 0C104.3 0 83.6 12.9 72.6 32L64 32C28.7 32 0 60.7 0 96L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-352c0-35.3-28.7-64-64-64zM136 112c-13.3 0-24-10.7-24-24s10.7-24 24-24l112 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-112 0z"],
    "place-of-worship": [512, 512, [], "f67f", "M160 79l0 81-44.8 33.6C103.1 202.7 96 216.9 96 232l0 40-60.6 30.3C13.7 313.2 0 335.3 0 359.6L0 448c0 35.3 28.7 64 64 64 74.7 0 85.4 0 320 0l64 0c35.3 0 64-28.7 64-64l0-88.4c0-24.2-13.7-46.4-35.4-57.2L416 272 416 232c0-15.1-7.1-29.3-19.2-38.4L352 160 352 79c0-9.5-4.2-18.5-11.5-24.6L271.4-3.2c-8.9-7.4-21.8-7.4-30.7 0L171.5 54.4C164.2 60.5 160 69.5 160 79zm96 241c35.3 0 64 28.7 64 64l0 80-128 0 0-80c0-35.3 28.7-64 64-64z"],
    "cannabis": [512, 512, [], "f55f", "M256 0c5.3 0 10.3 2.7 13.3 7.1 15.8 23.5 36.7 63.7 49.2 109 7.3 26.4 11.8 55.3 10.3 84 11.6-8.9 23.7-16.7 35.9-23.7 41-23.3 84.4-36.9 112.2-42.5 5.2-1 10.7 .6 14.4 4.4s5.4 9.2 4.4 14.5c-5.6 27.7-19.3 70.9-42.7 111.7-9.1 15.9-19.9 31.7-32.5 46.3 27.9 6.6 52.5 17.2 67.3 25.4 5.1 2.8 8.2 8.2 8.2 14s-3.2 11.2-8.2 14c-15.2 8.4-40.9 19.5-69.8 26.1-20.2 4.6-42.9 7.2-65.2 4.6l8.3 33.2c1.5 6.1-.6 12.5-5.5 16.4s-11.6 4.6-17.2 1.8L280 417.2 280 488c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-70.8-58.5 29.1c-5.6 2.8-12.3 2.1-17.2-1.8s-7-10.3-5.5-16.4l8.3-33.2c-22.2 2.6-45 0-65.2-4.6-28.9-6.6-54.5-17.6-69.8-26.1-5.1-2.8-8.2-8.2-8.2-14s3.2-11.2 8.2-14l6.2-3.3c15-7.6 36.8-16.4 61.1-22.2-12.5-14.5-23.3-30.4-32.4-46.2-23.4-40.8-37.1-84-42.7-111.7-1.1-5.2 .6-10.7 4.4-14.5s9.2-5.4 14.4-4.4c27.9 5.5 71.2 19.2 112.2 42.5 12.2 6.9 24.3 14.8 35.8 23.7-1.4-28.7 3.1-57.6 10.3-84 12.5-45.3 33.4-85.5 49.2-109l1.2-1.6C246.9 2 251.3 0 256 0z"],
    "face-zipper": [576, 512, [], "e3a5", "M527.3 347.3c10.8-28.4 16.8-59.2 16.8-91.3 0-141.4-114.6-256-256-256s-256 114.6-256 256 114.6 256 256 256c32.2 0 63-5.9 91.3-16.8l-6.7-6.7c-26.7-26.7-30.6-67.5-11.7-98.3-2.8 1.1-5.8 1.7-9 1.7-13.3 0-24-10.7-24-24l0-32c0-13.3 10.7-24 24-24s24 10.7 24 24l0 32c0 1.6-.1 3.1-.4 4.5l31.9-31.9c31.2-31.2 81.9-31.2 113.1 0l6.7 6.7zM176.1 208a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm192-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm-96 136c13.3 0 24 10.7 24 24l0 32c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-32c0-13.3 10.7-24 24-24zm-80 0c13.3 0 24 10.7 24 24l0 32c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-32c0-13.3 10.7-24 24-24zm344 112l-49.4-49.4c-12.5-12.5-32.8-12.5-45.3 0l-34.7 34.7c-12.5 12.5-12.5 32.8 0 45.3L456.1 504c22.1 22.1 57.9 22.1 80 0s22.1-57.9 0-80zm-56 40a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"],
    "people-roof": [576, 512, [], "e537", "M302.3-12.6c-9-4.5-19.6-4.5-28.6 0l-256 128C1.9 123.3-4.5 142.5 3.4 158.3s27.1 22.2 42.9 14.3L288 51.8 529.7 172.6c15.8 7.9 35 1.5 42.9-14.3s1.5-35-14.3-42.9l-256-128zM288 272a56 56 0 1 0 0-112 56 56 0 1 0 0 112zm0 48c-53 0-96 43-96 96l0 32c0 17.7 14.3 32 32 32l128 0c17.7 0 32-14.3 32-32l0-32c0-53-43-96-96-96zM160 256a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zm352 0a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM112 336c-44.2 0-80 35.8-80 80l0 33.1c0 17 13.8 30.9 30.9 30.9l87.8 0c-4.3-9.8-6.7-20.6-6.7-32l0-48c0-18.4 3.5-36 9.8-52.2-12.2-7.5-26.5-11.8-41.8-11.8zM425.4 480l87.8 0c17 0 30.9-13.8 30.9-30.9l0-33.1c0-44.2-35.8-80-80-80-15.3 0-29.6 4.3-41.8 11.8 6.3 16.2 9.8 33.8 9.8 52.2l0 48c0 11.4-2.4 22.2-6.7 32z"],
    "pump": [640, 512, [], "e442", "M128 32c0-17.7 14.3-32 32-32L320 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l0 320-256 0c0 17.7-14.3 32-32 32S0 401.7 0 384L0 224c0-17.7 14.3-32 32-32s32 14.3 32 32l96 0 0-160c-17.7 0-32-14.3-32-32zM576 96c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64l-144 0c-35.3 0-64-28.7-64-64l0-288c0-35.3 28.7-64 64-64l144 0zM432 216c0 13.3 10.7 24 24 24l96 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-96 0c-13.3 0-24 10.7-24 24zm0 88c0 13.3 10.7 24 24 24l96 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-96 0c-13.3 0-24 10.7-24 24zm0 88c0 13.3 10.7 24 24 24l96 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-96 0c-13.3 0-24 10.7-24 24z"],
    "square-ampersand": [448, 512, [], "e260", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM184 191.6c0 4.1 1.6 8.1 4.6 11l14.5 14.5 23.6-17.3c3.4-2.5 5.4-6.4 5.4-10.6 0-7.3-5.9-13.2-13.2-13.2l-19.2 0c-8.6 0-15.6 7-15.6 15.6zm71 46.9l-17.6 12.9 28.7 28.7 26.2-37.8c7.5-10.9 22.5-13.6 33.4-6.1s13.6 22.5 6.1 33.4l-31.1 45 28.4 28.4c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-22.4-22.4c-15.1 18.5-37.8 29.4-62 29.4l-32.2 0c-36.7 0-66.5-29.8-66.5-66.5 0-21.2 10.1-41.1 27.2-53.6l24.7-18.1-9.2-9.2c-11.9-11.9-18.6-28.1-18.6-45 0-35.1 28.5-63.6 63.6-63.6l19.2 0c33.8 0 61.2 27.4 61.2 61.2 0 19.5-9.3 37.8-25 49.3zm-87.5 64.1c-4.7 3.5-7.5 9-7.5 14.9 0 10.2 8.3 18.5 18.5 18.5l32.2 0c10.5 0 20.3-5.2 26.3-13.8l1.4-2-40.1-40.1-30.7 22.5z"],
    "disease": [512, 512, [], "f7fa", "M236.5 29.4L224 48c-20 30-53.6 48-89.7 48L68 96c-37.5 0-67.9 30.4-67.9 67.9 0 18 7.2 35.2 19.9 47.9l27 27c11 11 17.2 25.9 17.2 41.5 0 15.8-6.4 30.9-17.7 42L33.4 335.1c-11.1 10.8-17.3 25.7-17.3 41.2 0 36.8 34.1 64.2 70.1 56.2l62.3-13.8c7.7-1.7 15.7-2.6 23.6-2.6 32.8 0 64.2 14.6 85.2 39.8l30.5 36.6c10.4 12.4 25.7 19.6 41.9 19.6 30.1 0 54.5-24.4 54.5-54.5l0-51.2c0-41.4 25.4-78.5 64-93.5l22.2-8.6c25.2-9.8 41.8-34.1 41.8-61.1 0-26.4-15.9-50.3-40.3-60.5L429 164.8c-33.2-13.9-57.6-43-65.5-78.1l-7.9-35.2c-6.8-30.1-33.5-51.5-64.3-51.5-22 0-42.6 11-54.8 29.4zM160 192a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm96 0a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm32 96a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "book-bible": [448, 512, ["bible"], "f647", "M96 512c-53 0-96-43-96-96L0 96C0 43 43 0 96 0L400 0c26.5 0 48 21.5 48 48l0 288c0 20.9-13.4 38.7-32 45.3l0 66.7c17.7 0 32 14.3 32 32s-14.3 32-32 32L96 512zm0-128c-17.7 0-32 14.3-32 32s14.3 32 32 32l256 0 0-64-256 0zM192 80l0 48-48 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l48 0 0 112c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-112 48 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-48 0 0-48c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16z"],
    "chess-board": [448, 512, [], "f43c", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm64 64l0 64 64 0 0-64 64 0 0 64 64 0 0-64 64 0 0 64-64 0 0 64 64 0 0 64-64 0 0 64 64 0 0 64-64 0 0-64-64 0 0 64-64 0 0-64-64 0 0 64-64 0 0-64 64 0 0-64-64 0 0-64 64 0 0-64-64 0 0-64 64 0zm64 128l64 0 0-64-64 0 0 64zm0 64l0-64-64 0 0 64 64 0zm64 0l-64 0 0 64 64 0 0-64zm0 0l64 0 0-64-64 0 0 64z"],
    "sprinkler": [512, 512, [], "e035", "M24 0a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM0 128a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM0 232a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM64 72a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm24 88a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm40-32a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm360 80a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm24-80a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zM488 0a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM448 72a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm-24 88a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm-40-32a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zM256 64c17.7 0 32 14.3 32 32l0 160 100.2 0c15.3 0 27.8 12.4 27.8 27.8 0 7.8-3.3 15.2-9 20.5l-87 79.7 0 96c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-96-87-79.7c-5.7-5.3-9-12.7-9-20.5 0-15.3 12.4-27.8 27.8-27.8l100.2 0 0-160c0-17.7 14.3-32 32-32z"],
    "gun-squirt": [576, 512, [], "e19d", "M128 56c0-13.3-10.7-24-24-24S80 42.7 80 56l0 9.3c-45.4 7.6-80 47.1-80 94.7 0 47.3 34.3 86.7 79.4 94.6L33 440.2c-2.4 9.6-.2 19.7 5.8 27.5S54.1 480 64 480l104 0c14.7 0 27.5-10 31-24.2l19.9-79.8 53 0 0 16c0 13.3 10.7 24 24 24s24-10.7 24-24l0-80c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 16-41 0 18-72 199 0c41.8 0 77.4-26.7 90.5-64l13.5 0c13.3 0 24-10.7 24-24l0-16c0-13.3-10.7-24-24-24l-13.5 0C525.4 90.7 489.8 64 448 64l-320 0 0-8zM96 128l352 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L96 192c-17.7 0-32-14.3-32-32s14.3-32 32-32z"],
    "mug-marshmallows": [576, 512, [], "f7b7", "M288 0l96 0c17.7 0 32 14.3 32 32l0 48-320 0 0-16c0-17.7 14.3-32 32-32l128 0c0-17.7 14.3-32 32-32zM96 128l48 0 0 104c0 13.3 10.7 24 24 24s24-10.7 24-24l0-104 256 0c70.7 0 128 57.3 128 128S518.7 384 448 384c0 53-43 96-96 96l-192 0c-53 0-96-43-96-96l0-224c0-17.7 14.3-32 32-32zM448 320c35.3 0 64-28.7 64-64s-28.7-64-64-64l0 128z"],
    "circle-heart": [512, 512, ["heart-circle"], "f4c7", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm-6.4-312.5l6.4 8.5 6.4-8.5c11.1-14.8 28.5-23.5 46.9-23.5 32.4 0 58.7 26.3 58.7 58.7l0 5.3c0 49.1-65.8 98.1-96.5 118.3-9.5 6.2-21.5 6.2-30.9 0-30.7-20.2-96.5-69.3-96.5-118.3l0-5.3c0-32.4 26.3-58.7 58.7-58.7 18.5 0 35.9 8.7 46.9 23.5z"],
    "user-hat-tie-magnifying-glass": [576, 512, [], "e7af", "M103.2 80L72.5 80c-13.3 0-24 10.7-24 24s10.7 24 24 24l24 0 0 16c0 70.7 57.3 128 128 128 7.3 0 14.5-.6 21.5-1.8 21.7-26.8 51.5-46.7 85.7-56.2 13.2-20.1 20.9-44.2 20.9-70.1l0-16 24 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-30.7 0c-10.4-53.7-31.9-112-68.3-112-9.6 0-19 3.9-27.5 8.2-8.2 4.1-18.4 7.8-25.5 7.8s-17.3-3.7-25.5-7.8c-8.5-4.3-17.9-8.2-27.5-8.2-36.4 0-57.8 58.3-68.3 112zM194 304c-9.7 0-17.5 7.8-17.5 17.5 0 4.2 1.5 8.2 4.2 11.4l27.4 32-31 115.1-.6 0-34.6-138.5c-2.2-8.7-11.1-14-19.5-10.8-61.9 23.6-105.9 83.6-105.9 153.8 0 15.1 12.3 27.4 27.4 27.4l233.9 0c-42-30.5-69.3-80.1-69.3-136 0-25.8 5.8-50.2 16.2-72L194 304zM304.5 128l0 16c0 44.2-35.8 80-80 80s-80-35.8-80-80l0-16 160 0zm72 176.1a72 72 0 1 1 0 144 72 72 0 1 1 0-144zm0 192c24.5 0 47.2-7.3 66.2-19.9l60.8 60.9c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-60.8-60.9c12.6-19 19.9-41.7 19.9-66.2 0-66.3-53.7-120-120-120s-120 53.7-120 120 53.7 120 120 120z"],
    "diagram-sankey": [576, 512, [], "e158", "M299.5 71.4c5.8-4.8 13-7.4 20.5-7.4l192 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-180.4 0-87.1 72.6c-5.8 4.8-13 7.4-20.5 7.4L32 208c-17.7 0-32-14.3-32-32s14.3-32 32-32l180.4 0 87.1-72.6zM144 320L32 320c-17.7 0-32-14.3-32-32s14.3-32 32-32l480 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-288 0 48 64 240 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-256 0c-10.1 0-19.6-4.7-25.6-12.8L144 320z"],
    "sunset": [576, 512, [127751], "f767", "M369.4 121c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-23 23 0-102.1c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 102.1-23-23c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l64 64c9.4 9.4 24.6 9.4 33.9 0l64-64zM200.6 200.1c-6.7-4.4-15.1-5.2-22.5-2.2s-12.8 9.6-14.3 17.4L143 318.6 39.7 339.4c-7.8 1.6-14.4 7-17.4 14.3s-2.2 15.8 2.2 22.5l26.4 39.8 118.8 0c19-46.9 65-80 118.7-80s99.7 33.1 118.7 80l118.8 0 26.4-39.8c4.4-6.7 5.2-15.1 2.2-22.5s-9.6-12.8-17.4-14.3L433.8 318.6 413 215.3c-1.6-7.8-7-14.4-14.3-17.4s-15.8-2.2-22.5 2.2l-87.8 58.2-87.8-58.2zM32.4 488c0 13.3 10.7 24 24 24l464 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-464 0c-13.3 0-24 10.7-24 24z"],
    "circle-equals": [512, 512, [], "e6b1", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM160 200c0-13.3 10.7-24 24-24l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24zm0 112c0-13.3 10.7-24 24-24l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24z"],
    "mars": [512, 512, [9794], "f222", "M320 32c0-17.7 14.3-32 32-32L480 0c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-50.7-95 95c19.5 28.4 31 62.7 31 99.8 0 97.2-78.8 176-176 176S32 401.2 32 304 110.8 128 208 128c37 0 71.4 11.4 99.8 31l95-95-50.7 0c-17.7 0-32-14.3-32-32zM208 416a112 112 0 1 0 0-224 112 112 0 1 0 0 224z"],
    "user-vneck-hair-mullet": [448, 512, [], "e7ba", "M144 144l0-32 17.9 0c27.5 0 52-17.6 60.7-43.8l1.4-4.2 1.4 4.2c8.7 26.1 33.2 43.8 60.7 43.8l17.9 0 0 32c0 44.2-35.8 80-80 80s-80-35.8-80-80zm208 0l0-32 0-1.4c9.3-3.3 16-12.2 16-22.6 0-13.3-10.7-24-24-24-.9 0-1.8 .1-2.7 .2-17.9-37.9-56.6-64.2-101.3-64.2L208 0c-44.7 0-83.3 26.2-101.3 64.2-.9-.1-1.8-.2-2.7-.2-13.3 0-24 10.7-24 24 0 10.5 6.7 19.3 16 22.6l0 1.4 0 32c0 24.7 7 47.8 19.1 67.3l-15 22.5c-2.7 4-4.1 8.8-4.1 13.6 0 13.6 11 24.6 24.6 24.6l206.9 0c13.6 0 24.6-11 24.6-24.6 0-4.8-1.4-9.6-4.1-13.6l-15-22.5C345 191.8 352 168.7 352 144zM142.6 323c-6.5-4.9-15.2-6.2-22.6-2.8-61.4 28.2-104.1 90.2-104.1 162.1 0 16.4 13.3 29.7 29.7 29.7l356.6 0c16.4 0 29.7-13.3 29.7-29.7 0-72-42.7-134-104.1-162.1-7.4-3.4-16.1-2.1-22.6 2.8l-67 50.2c-8.5 6.4-20.3 6.4-28.8 0l-67-50.2z"],
    "laptop": [640, 512, [128187], "f109", "M128 32C92.7 32 64 60.7 64 96l0 240 64 0 0-240 384 0 0 240 64 0 0-240c0-35.3-28.7-64-64-64L128 32zM19.2 384C8.6 384 0 392.6 0 403.2 0 445.6 34.4 480 76.8 480l486.4 0c42.4 0 76.8-34.4 76.8-76.8 0-10.6-8.6-19.2-19.2-19.2L19.2 384z"],
    "user-xmark": [640, 512, ["user-times"], "f235", "M136.4 128a120 120 0 1 1 240 0 120 120 0 1 1 -240 0zm-88 354.3c0-98.5 79.8-178.3 178.3-178.3l59.4 0c98.5 0 178.3 79.8 178.3 178.3 0 16.4-13.3 29.7-29.7 29.7L78.1 512c-16.4 0-29.7-13.3-29.7-29.7zM612.3 124.1c9.4 9.4 9.4 24.6 0 33.9l-33.9 33.9 33.9 33.9c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-33.9-33.9-33.9 33.9c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l33.9-33.9-33.9-33.9c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l33.9 33.9 33.9-33.9c9.4-9.4 24.6-9.4 33.9 0z"],
    "flag-usa": [448, 512, [], "f74d", "M32 0C49.7 0 64 14.3 64 32l0 16 69-17.2c38.1-9.5 78.3-5.1 113.5 12.5 46.3 23.2 100.8 23.2 147.1 0l9.6-4.8C423.8 28.1 448 43.1 448 66.1l0 36.1-44.7 16.2c-42.8 15.6-90 13.9-131.6-4.6l-16.1-7.2c-20.3-9-41.8-14.7-63.6-16.9l0 32.2c17.4 2.1 34.4 6.7 50.6 13.9l16.1 7.2c49.2 21.9 105 23.8 155.6 5.4l33.7-12.3 0 62-44.7 16.2c-42.8 15.6-90 13.9-131.6-4.6l-16.1-7.2c-40.2-17.9-85-22.5-128.1-13.3l-63.5 13.6 0 32.7 70.2-15.1c36.4-7.8 74.3-3.9 108.4 11.3l16.1 7.2c49.2 21.9 105 23.8 155.6 5.4l33.7-12.3 0 61.9-44.7 16.2c-42.8 15.6-90 13.9-131.6-4.6l-16.1-7.2c-40.2-17.9-85-22.5-128.1-13.3l-63.5 13.6 0 32.7 70.2-15.1c36.4-7.8 74.3-3.9 108.4 11.3l16.1 7.2c49.2 21.9 105 23.8 155.6 5.4l33.7-12.3 0 33.5c0 13.3-8.3 25.3-20.8 30l-34.7 13c-46.2 17.3-97.6 14.6-141.7-7.4-37.9-19-81.4-23.7-122.5-13.4L64 400 64 480c0 17.7-14.3 32-32 32S0 497.7 0 480L0 32C0 14.3 14.3 0 32 0zm80 96a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm32 0a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm-32 48a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm32 0a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"],
    "hand-middle-finger": [448, 512, [128405], "f806", "M232 0c-22.1 0-40 17.9-40 40l0 164.2c-8.5-7.6-19.7-12.2-32-12.2-26.5 0-48 21.5-48 48l0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-55.7c-2 1.4-3.9 3-5.8 4.5L55 284.8C40.4 297 32 315 32 334L32 372c0 38 16.9 74 46.1 98.3l5.4 4.5c28.8 24 65 37.1 102.4 37.1L304 512c70.7 0 128-57.3 128-128l0-96c0-26.5-21.5-48-48-48-12.4 0-23.6 4.7-32.1 12.3-1.9-24.8-22.6-44.3-47.9-44.3-12.3 0-23.5 4.6-32 12.2L272 40c0-22.1-17.9-40-40-40z"],
    "alt": [640, 512, [], "e08a", "M448 64c-9.7 0-18.9 4.4-25 12L176.6 384 32 384c-17.7 0-32 14.3-32 32s14.3 32 32 32l160 0c9.7 0 18.9-4.4 25-12L463.4 128 608 128c17.7 0 32-14.3 32-32s-14.3-32-32-32L448 64zm0 320c-17.7 0-32 14.3-32 32s14.3 32 32 32l160 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-160 0z"],
    "mortar-pestle": [512, 512, [], "f5a7", "M504.3 11.1C493.3-1.6 474.5-3.7 461 6.2L252.3 160 397.3 160 502.6 54.6c11.8-11.8 12.6-30.8 1.6-43.5zM32 192c-17.7 0-32 14.3-32 32s14.3 32 32 32c0 82.5 43.4 147.7 123.9 176.2-11.1 13.9-19.4 30.3-23.9 48.1-4.4 17.1 10.4 31.7 28.1 31.7l192 0c17.7 0 32.4-14.6 28.1-31.7-4.5-17.8-12.8-34.1-23.9-48.1 80.5-28.6 123.9-93.7 123.9-176.2 17.7 0 32-14.3 32-32s-14.3-32-32-32L32 192z"],
    "banana": [576, 512, [], "e2e5", "M304 144c0 35.7-7.3 69.6-20.5 100.5 4.8 3 9.4 6.2 13.9 9.8L332.9 282.6 414 261c10.6-2.8 21.4-4.4 32.3-4.9 1.2-10.5 1.8-21.3 1.8-32.1 0-84.7-36.6-160.9-94.8-213.6-7.6-6.8-17.3-10.4-27-10.4-29.4 0-47.5 29.4-38 55 10.3 27.7 15.9 57.7 15.9 89zM277.4 279.2c-18.8-15-42.1-23.2-66.1-23.2-22.9 0-45.2 7.4-63.5 21.2l-42.2 31.6c-10.6 8-12.8 23-4.8 33.6s23 12.8 33.6 4.8l42.2-31.6c10-7.5 22.2-11.6 34.7-11.6 10.5 0 20.8 2.9 29.7 8.2-46.9 53.8-116 87.8-193 87.8-26.5 0-48 21.5-48 48l0 16c0 26.5 21.5 48 48 48l112 0c117.3 0 218.2-70.1 263.1-170.6l11.5-3.1c5.7-1.5 11.6-2.3 17.5-2.3 23.8 0 45.9 12.5 58.1 32.9l21.3 35.4c6.8 11.4 21.6 15 32.9 8.2s15-21.6 8.2-32.9l-21.3-35.4c-20.9-34.9-58.6-56.2-99.3-56.2-3.8 0-7.5 .2-11.3 .6-5.5 .5-10.9 1.5-16.3 2.8-.8 .2-1.5 .4-2.3 .6l-96.7 25.8-48.1-38.5z"],
    "umbrella-simple": [512, 512, ["umbrella-alt"], "e2bc", "M256.2-32c17.7 0 32 14.3 32 32l0 2c115.8 14.4 207.6 106.3 222 222.1 2.2 17.5-12.4 31.9-30 31.9l-448 0C14.6 256 0 241.6 2.2 224.1 16.6 108.2 108.4 16.4 224.2 2l0-2c0-17.7 14.3-32 32-32zm32 462.6c0 45-36.5 81.4-81.4 81.4-30.8 0-59-17.4-72.8-45l-2.3-4.7c-7.9-15.8-1.5-35 14.3-42.9s35-1.5 42.9 14.3l2.3 4.7c3 5.9 9 9.6 15.6 9.6 9.6 0 17.4-7.8 17.4-17.4l0-126.6 64 0 0 126.6z"],
    "joystick": [448, 512, [128377], "f8c5", "M384 352c35.3 0 64 28.7 64 64l0 32c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64l0-32c0-35.3 28.7-64 64-64l320 0zM224 0c61.9 0 112 50.1 112 112 0 50.7-33.7 93.5-80 107.3l0 84.7-64 0 0-84.7c-46.3-13.8-80-56.6-80-107.3 0-61.9 50.1-112 112-112zM200 48a24 24 0 1 0 0 48 24 24 0 1 0 0-48z"],
    "head-side-cough": [512, 512, [], "e061", "M96 512l64 0c53 0 96-43 96-96l0-80c0-8.8 7.2-16 16-16l1 0c26 0 47-21 47-47 0-11-3.9-21.6-10.9-30.1L273.3 200C271.4 197.6 270.1 194.7 269.7 191.7 254 83.3 160.7 0 48 0 40.4 0 32.9 .4 25.4 1.1 10.5 2.6 0 15.9 0 30.9L0 480c0 17.7 14.3 32 32 32l64 0zm16-320a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm63.1 237.2l-41.5-3.5c-12.2-1-21.6-11.2-21.6-23.4 0-10.8 7.3-20.2 17.8-22.8l40.4-10.1c19.2-4.8 37.8 9.7 37.8 29.5 0 17.8-15.2 31.8-32.9 30.3zM480 312a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm-40 24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm-64 48a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm128 0a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM480 504a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm-40-72a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"],
    "plane-lock": [640, 512, [], "e558", "M232 24c0-30.9 25.1-56 56-56s56 25.1 56 56l0 127.3 82.1 75.2C409.7 248.1 400 274.9 400 304l0 24.4c-7.3 6.6-13.6 14.2-18.7 22.7l-37.3-12.4 0 99.7 24 19.2 0 38.3c0 13.5 2.8 26.4 7.8 38.1L288 512 179.9 539c-10.1 2.5-19.9-5.1-19.9-15.5l0-19.8c0-4.9 2.2-9.5 6-12.5l66-52.8 0-99.7-162.9 54.3C58.7 396.4 48 388.7 48 377.8l0-43.7c0-9 3.8-17.5 10.4-23.6L232 151.3 232 24zM560 304.1c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 47.9 64 0 0-47.9zM416 400c0-20.9 13.4-38.7 32-45.3l0-50.6c0-44.2 35.8-80 80-80s80 35.8 80 80l0 50.6c18.6 6.6 32 24.4 32 45.3l0 96c0 26.5-21.5 48-48 48l-128 0c-26.5 0-48-21.5-48-48l0-96z"],
    "battery-three-quarters": [640, 512, ["battery-4"], "f241", "M528 128c8.8 0 16 7.2 16 16l0 224c0 8.8-7.2 16-16 16l-416 0c-8.8 0-16-7.2-16-16l0-224c0-8.8 7.2-16 16-16l416 0zM112 64c-44.2 0-80 35.8-80 80l0 224c0 44.2 35.8 80 80 80l416 0c44.2 0 80-35.8 80-80l0-48c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l0-48c0-44.2-35.8-80-80-80L112 64zm56 112c-13.3 0-24 10.7-24 24l0 112c0 13.3 10.7 24 24 24l224 0c13.3 0 24-10.7 24-24l0-112c0-13.3-10.7-24-24-24l-224 0z"],
    "franc-sign": [320, 512, [], "e18f", "M80 32C62.3 32 48 46.3 48 64l0 256-24 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l24 0 0 80c0 17.7 14.3 32 32 32s32-14.3 32-32l0-80 88 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-88 0 0-64 144 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-144 0 0-96 176 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L80 32z"],
    "triple-chevrons-right": [576, 512, [], "e7f9", "M9.9 105.4c12.5-12.5 32.8-12.5 45.2 0l128 128 2.2 2.4c10.2 12.6 9.5 31.1-2.2 42.8l-128 128-2.4 2.2c-12.6 10.2-31.1 9.5-42.8-2.2s-12.4-30.2-2.2-42.8L9.9 361.4 115.2 256 9.9 150.6c-12.5-12.5-12.5-32.8 0-45.2zm192 0c12.5-12.5 32.8-12.5 45.2 0l128 128 2.2 2.4c10.2 12.6 9.5 31.1-2.2 42.8l-128 128-2.4 2.2c-12.6 10.2-31.1 9.5-42.8-2.2s-12.4-30.2-2.2-42.8l2.2-2.4 105.4-105.4-105.4-105.4c-12.5-12.5-12.5-32.8 0-45.2zm192 0c12.5-12.5 32.8-12.5 45.2 0l128 128 2.2 2.4c10.2 12.6 9.5 31.1-2.2 42.8l-128 128-2.4 2.2c-12.6 10.2-31.1 9.5-42.8-2.2s-12.4-30.2-2.2-42.8l2.2-2.4 105.4-105.4-105.4-105.4c-12.5-12.5-12.5-32.8 0-45.2z"],
    "filter-circle-dollar": [576, 512, ["funnel-dollar"], "f662", "M32 64C19.1 64 7.4 71.8 2.4 83.8S.2 109.5 9.4 118.6L192 301.3 192 416c0 8.5 3.4 16.6 9.4 22.6l64 64c2.5 2.5 5.3 4.5 8.3 6-21.2-30.9-33.6-68.3-33.6-108.6 0-99.4 75.5-181.1 172.3-191l90.4-90.4c9.2-9.2 11.9-22.9 6.9-34.9S492.9 64 480 64L32 64zM576 400a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zM416 320c0-8.8 7.2-16 16-16s16 7.2 16 16l0 8 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-45.8 0c-5.6 0-10.2 4.6-10.2 10.2 0 4.9 3.5 9.1 8.3 10l45 8.2c20 3.6 34.6 21.1 34.6 41.5 0 23.3-18.9 42.2-42.2 42.2l-5.8 0 0 8c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-8-16 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l53.8 0c5.6 0 10.2-4.6 10.2-10.2 0-4.9-3.5-9.1-8.3-10l-45-8.2c-20-3.6-34.6-21.1-34.6-41.5 0-22.6 17.7-41 40-42.1l0-8.1z"],
    "cheese": [512, 512, [], "f7ef", "M512 240.2l0 15.8-512 0c0-20 10-38.7 26.6-49.8L274.9 40.7c8.6-5.7 18.6-8.7 28.9-8.7 115 0 208.2 93.2 208.2 208.2zm0 63.8l0 112c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64l0-112 512 0z"],
    "circle-h": [512, 512, [9405, "hospital-symbol"], "f47e", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm96-344l0 176c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-64-96 0 0 64c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-176c0-13.3 10.7-24 24-24s24 10.7 24 24l0 64 96 0 0-64c0-13.3 10.7-24 24-24s24 10.7 24 24z"],
    "box-ballot": [512, 512, [128499], "f735", "M137.9 155.4l82.7 82.7c18.7 18.7 49.1 18.7 67.9 0L390.1 136.5c18.7-18.7 18.7-49.1 0-67.9L307.4-14.1c-18.7-18.7-49.1-18.7-67.9 0L137.9 87.5c-18.7 18.7-18.7 49.1 0 67.9zM170.7 256l-67.4-67.4C86.4 171.7 77.2 150.1 75.7 128L64 128c-35.3 0-64 28.7-64 64l0 160 512 0 0-160c0-35-28.1-63.4-62.9-64-4.2 15.3-12.4 29.8-24.4 41.8L338.5 256 392 256c13.3 0 24 10.7 24 24s-10.7 24-24 24l-272 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l50.7 0zM512 400L0 400 0 448c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-48z"],
    "location-check": [384, 512, ["map-marker-check"], "f606", "M192 0C298 0 384 84.4 384 188.6 384 307.9 263.8 450.9 213.6 505.4 201.8 518.2 182.2 518.2 170.4 505.4 120.2 450.9 0 307.9 0 188.6 0 84.4 86 0 192 0zm90.9 132.6c-10.7-7.8-25.7-5.4-33.5 5.3l-85.6 117.7-26.5-27.4c-9.2-9.5-24.4-9.8-33.9-.6-9.5 9.2-9.8 24.4-.6 33.9l46.4 48c4.9 5.1 11.8 7.8 18.9 7.3s13.6-4.1 17.8-9.8L288.2 166.1c7.8-10.7 5.4-25.7-5.3-33.5z"],
    "tilde": [512, 512, [63135], "7e", "M122.5 192C90.2 192 64 218.2 64 250.5L64 320c0 17.7-14.3 32-32 32S0 337.7 0 320l0-69.5c0-67.7 54.8-122.5 122.5-122.5 32.5 0 63.7 12.9 86.6 35.9l139 139c11 11 25.9 17.1 41.4 17.1 32.3 0 58.5-26.2 58.5-58.5l0-69.5c0-17.7 14.3-32 32-32s32 14.3 32 32l0 69.5c0 67.7-54.8 122.5-122.5 122.5-32.5 0-63.7-12.9-86.6-35.9l-139-139c-11-11-25.9-17.1-41.4-17.1z"],
    "comment-middle": [512, 512, [], "e149", "M188 440l44.8 89.7c4.4 8.8 13.3 14.3 23.2 14.3s18.8-5.5 23.2-14.3L324 440C432.4 414 512 327.1 512 224 512 100.3 397.4 0 256 0S0 100.3 0 224C0 327.1 79.6 414 188 440z"],
    "arrow-left-from-dotted-line": [512, 512, [], "e6b9", "M9.4 233.4c-12.5 12.5-12.5 32.8 0 45.3l128 128c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L109.3 288 352 288c17.7 0 32-14.3 32-32s-14.3-32-32-32l-242.7 0 73.4-73.4c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-128 128zM480 64a32 32 0 1 0 0 64 32 32 0 1 0 0-64zM448 202.7a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm32 74.7a32 32 0 1 0 0 64 32 32 0 1 0 0-64zM448 416a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z"],
    "u-turn-left-down": [576, 512, ["u-turn"], "e7f1", "M304 0C189.1 0 96 93.1 96 208l0 128-48 0c-12.9 0-24.6 7.8-29.6 19.8s-2.2 25.7 6.9 34.9l112 112 2.4 2.2c12.6 10.2 31.1 9.5 42.8-2.2l112-112c9.2-9.2 11.9-22.9 6.9-34.9S284.9 336 272 336l-48 0 0-128c0-44.2 35.8-80 80-80s80 35.8 80 80l0 208c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-208C512 93.1 418.9 0 304 0z"],
    "arrow-down-from-bracket": [448, 512, [], "e667", "M384 160c0 17.7 14.3 32 32 32s32-14.3 32-32l0-64c0-53-43-96-96-96L96 0C43 0 0 43 0 96l0 64c0 17.7 14.3 32 32 32s32-14.3 32-32l0-64c0-17.7 14.3-32 32-32l256 0c17.7 0 32 14.3 32 32l0 64zM201.4 502.6c12.5 12.5 32.8 12.5 45.3 0l128-128c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L256 402.7 256 192c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 210.7-73.4-73.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l128 128z"],
    "school": [576, 512, [127979], "f549", "M0 192c0-35.3 28.7-64 64-64l64 0 127.9-115.1c18.3-16.4 46-16.4 64.2 0L448 128 512 128c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 192zM224 376l0 88 128 0 0-88c0-22.1-17.9-40-40-40l-48 0c-22.1 0-40 17.9-40 40zm-112 8c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0zm16-144l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16zM496 384c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0zm16-144l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16zM288 256a64 64 0 1 0 0-128 64 64 0 1 0 0 128z"],
    "ear-muffs": [512, 512, [], "f795", "M256 64c-70.7 0-128 57.3-128 128l0 40.6c19.1 11.1 32 31.7 32 55.4 0 11.6-3.1 22.6-8.6 32 5.4 9.4 8.6 20.4 8.6 32s-3.1 22.6-8.6 32c5.4 9.4 8.6 20.4 8.6 32 0 35.3-28.7 64-64 64l-16 0c-35.3 0-64-28.7-64-64 0-6.5 1-12.8 2.8-18.7-11.6-11.6-18.8-27.6-18.8-45.3s7.2-33.7 18.8-45.3c-1.8-5.9-2.8-12.2-2.8-18.7 0-29.8 20.4-54.9 48-62l0-34C64 86 150 0 256 0S448 86 448 192l0 34c27.6 7.1 48 32.2 48 62 0 6.5-1 12.8-2.8 18.7 11.6 11.6 18.8 27.6 18.8 45.3s-7.2 33.7-18.8 45.3c1.8 5.9 2.8 12.2 2.8 18.7 0 35.3-28.7 64-64 64l-16 0c-35.3 0-64-28.7-64-64 0-11.6 3.1-22.6 8.6-32-5.4-9.4-8.6-20.4-8.6-32s3.1-22.6 8.6-32c-5.4-9.4-8.6-20.4-8.6-32 0-23.7 12.9-44.4 32-55.4l0-40.6c0-70.7-57.3-128-128-128z"],
    "clock-seven": [512, 512, [], "e350", "M256 0a256 256 0 1 1 0 512 256 256 0 1 1 0-512zM232 120l0 128.7-60 90c-7.4 11-4.4 25.9 6.7 33.3s25.9 4.4 33.3-6.7l64-96c2.6-3.9 4-8.6 4-13.3l0-136c0-13.3-10.7-24-24-24s-24 10.7-24 24z"],
    "dice-five": [448, 512, [9860], "f523", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm64 96a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM96 352a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM224 224a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm64-64a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm32 160a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "tornado": [448, 512, [127786], "f76f", "M0 32L0 45.6C0 62.7 1.7 79.6 5 96l352.8 0c3.2-6.9 7.5-13.3 13-18.8l38.6-38.6c4.2-4.2 6.6-10 6.6-16 0-12.5-10.1-22.6-22.6-22.6L32 0C14.3 0 0 14.3 0 32zM355.7 144l-336 0c12.4 29.7 30.2 56.8 52.7 80l339.6 0-47.2-62.9c-3.9-5.2-7-11-9.2-17.1zM242.6 334.7c8.2 4.8 15.8 10.7 22.5 17.3L445 352c2-9.8 3-19.9 3-30.1 0-17.1-2.9-34-8.6-49.9L136 272 242.6 334.7zM294.3 400c5.3 17 6.5 35.2 3.6 53l-5.9 35.7c-2 12.2 7.4 23.4 19.8 23.4 5.3 0 10.4-2.1 14.2-5.9l78.2-78.2c8.5-8.5 15.8-17.8 21.9-27.9l-131.8 0z"],
    "arrow-left-to-line": [512, 512, [8676, "arrow-to-left"], "f33e", "M0 416c0 17.7 14.3 32 32 32s32-14.3 32-32L64 96c0-17.7-14.3-32-32-32S0 78.3 0 96L0 416zM137.4 233.4c-12.5 12.5-12.5 32.8 0 45.3l128 128c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L237.3 288 480 288c17.7 0 32-14.3 32-32s-14.3-32-32-32l-242.7 0 73.4-73.4c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-128 128z"],
    "jet-fighter": [576, 512, ["fighter-jet"], "f0fb", "M496.2 206.8c-10.7-4.5-22.2-6.8-33.8-6.8L362 200 248 48 296 48c13.3 0 24-10.7 24-24S309.3 0 296 0L152 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l8 0 0 152-54.4 0-52.8-66c-3-3.8-7.6-6-12.5-6L16 128c-8.8 0-16 7.2-16 16l0 88 40 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-40 0 0 88c0 8.8 7.2 16 16 16l24.3 0c4.9 0 9.5-2.2 12.5-6l52.8-66 54.4 0 0 152-8 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l144 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0 114-152 100.4 0c11.6 0 23.1-2.3 33.8-6.8l65-27.1c8.9-3.7 14.8-12.5 14.8-22.2s-5.8-18.4-14.8-22.2l-65-27.1z"],
    "person-biking-mountain": [640, 512, [128693, "biking-mountain"], "f84b", "M400 0a48 48 0 1 1 0 96 48 48 0 1 1 0-96zM365.4 111.2l61.8 48.8 52.8 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-64 0c-7.3 0-14.3-2.5-20-7l-40.7-32.6-60.3 48.5 42.7 28.5c8.9 5.9 14.2 15.9 14.2 26.6l0 128c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-110.9-60.5-38.4c-32.8-20.8-35-67.9-4.3-91.6l83.1-64.2c17.4-13.5 41.8-13.3 59.1 .3zM151.4 274.4c13.6 2.9 26.3 8.2 37.6 15.6 9.3-5.7 21.5-4.6 29.6 3.5s9.2 20.3 3.5 29.6c7.3 11.3 12.7 24 15.6 37.6 10.6 2.5 18.4 12 18.4 23.4s-7.9 20.8-18.4 23.4c-2.9 13.6-8.2 26.3-15.6 37.6 5.7 9.3 4.6 21.5-3.5 29.6s-20.3 9.2-29.6 3.5c-11.3 7.3-24 12.7-37.6 15.6-2.5 10.6-12 18.4-23.4 18.4s-20.8-7.9-23.4-18.4c-13.6-2.9-26.3-8.2-37.6-15.6-9.3 5.7-21.5 4.6-29.6-3.5S28.3 454.2 34 445C26.7 433.7 21.3 421 18.4 407.4 7.9 404.8 0 395.3 0 384s7.9-20.8 18.4-23.4c2.9-13.6 8.2-26.3 15.6-37.6-5.7-9.3-4.6-21.5 3.5-29.6S57.8 284.3 67 290c11.3-7.3 24-12.7 37.6-15.6 2.5-10.6 12-18.4 23.4-18.4s20.8 7.9 23.4 18.4zM128 448a64 64 0 1 0 0-128 64 64 0 1 0 0 128zM512 256c11.3 0 20.8 7.9 23.4 18.4 13.6 2.9 26.3 8.2 37.6 15.6 9.3-5.7 21.5-4.6 29.6 3.5s9.2 20.3 3.5 29.6c7.3 11.3 12.7 24 15.6 37.6 10.6 2.5 18.4 12 18.4 23.4s-7.9 20.8-18.4 23.4c-2.9 13.6-8.2 26.3-15.6 37.6 5.7 9.3 4.6 21.5-3.5 29.6s-20.3 9.2-29.6 3.5c-11.3 7.3-24 12.7-37.6 15.6-2.5 10.6-12 18.4-23.4 18.4s-20.8-7.9-23.4-18.4c-13.6-2.9-26.3-8.2-37.6-15.6-9.3 5.7-21.5 4.6-29.6-3.5s-9.2-20.3-3.5-29.6c-7.3-11.3-12.7-24-15.6-37.6-10.6-2.5-18.4-12-18.4-23.4s7.9-20.8 18.4-23.4c2.9-13.6 8.2-26.3 15.6-37.6-5.7-9.3-4.6-21.5 3.5-29.6s20.3-9.2 29.6-3.5c11.3-7.3 24-12.7 37.6-15.6 2.5-10.6 12-18.4 23.4-18.4zm64 128a64 64 0 1 0 -128 0 64 64 0 1 0 128 0z"],
    "thumbs-down": [512, 512, [128078, 61576], "f165", "M384 32c26.5 0 48 21.5 48 48 0 6.3-1.3 12.2-3.4 17.7 20.4 5.5 35.4 24.1 35.4 46.3 0 9.1-2.6 17.6-7 24.9 22.2 4.2 39 23.7 39 47.1 0 19.7-11.9 36.6-28.9 44 17 7.4 28.9 24.3 28.9 44 0 26.5-21.5 48-48 48l-160 0 28.2 70.4c2.5 6.3 3.8 13.1 3.8 19.9l0 4.2c0 27.3-22.1 49.4-49.4 49.4-18.7 0-35.8-10.6-44.2-27.3L170.1 356.3c-6.7-13.3-10.1-28-10.1-42.9l0-186.6c0-19.4 8.9-37.8 24-50l12.2-9.7C224.6 44.4 259.8 32 296.1 32L384 32zM80 96c17.7 0 32 14.3 32 32l0 256c0 17.7-14.3 32-32 32l-48 0c-17.7 0-32-14.3-32-32L0 128c0-17.7 14.3-32 32-32l48 0z"],
    "function": [640, 512, [], "f661", "M64 96c0-53 43-96 96-96l32 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32 0c-17.7 0-32 14.3-32 32l0 96 32 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32 0 0 127.5c0 48.4-36.1 89.3-84.1 95.3l-7.9 1C18.4 481.9 2.4 469.5 .2 452S10.5 418.4 28 416.2l7.9-1c16-2 28-15.6 28-31.8l0-127.5-32 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l32 0 0-96zm266.7 81.7C303.7 218.4 288 267.3 288 320s15.7 101.6 42.7 142.3c9.8 14.7 5.7 34.6-9 44.3s-34.6 5.7-44.3-9C243.6 446.7 224 385.6 224 320s19.6-126.7 53.3-177.7c9.8-14.7 29.6-18.8 44.3-9s18.8 29.6 9 44.3zm202.6 0c-9.8-14.7-5.7-34.6 9-44.3s34.6-5.7 44.3 9C620.4 193.3 640 254.4 640 320s-19.6 126.7-53.3 177.7c-9.8 14.7-29.6 18.8-44.3 9s-18.8-29.6-9-44.3c27-40.7 42.7-89.6 42.7-142.3s-15.7-101.6-42.7-142.3zM398.6 241.4l33.4 33.4 33.4-33.4c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3l-33.4 33.4 33.4 33.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0l-33.4-33.4-33.4 33.4c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l33.4-33.4-33.4-33.4c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0z"],
    "broom": [576, 512, [129529], "f51a", "M566.6 54.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-192 192-34.7-34.7c-4.2-4.2-10-6.6-16-6.6-12.5 0-22.6 10.1-22.6 22.6l0 29.1 108.3 108.3 29.1 0c12.5 0 22.6-10.1 22.6-22.6 0-6-2.4-11.8-6.6-16l-34.7-34.7 192-192zM341.1 353.4L222.6 234.9c-42.7-3.7-85.2 11.7-115.8 42.3l-8 8c-22.3 22.3-34.8 52.5-34.8 84 0 6.8 7.1 11.2 13.2 8.2l51.1-25.5c5-2.5 9.5 4.1 5.4 7.9L7.3 473.4C2.7 477.6 0 483.6 0 489.9 0 502.1 9.9 512 22.1 512l173.3 0c38.8 0 75.9-15.4 103.4-42.8 30.6-30.6 45.9-73.1 42.3-115.8z"],
    "disc-drive": [512, 512, [], "f8b5", "M32 96c0-35.3 28.7-64 64-64l320 0c35.3 0 64 28.7 64 64l0 320c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 480c-17.7 0-32-14.3-32-32s14.3-32 32-32L32 96zM224 256a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm192 0a160 160 0 1 0 -320 0 160 160 0 1 0 320 0z"],
    "grill": [448, 512, [], "e5a3", "M0 72C0 49.9 17.9 32 40 32l368 0c22.1 0 40 17.9 40 40l0 24c0 89.8-52.9 167.3-129.2 203l63.2 147.5c5.2 12.2-.4 26.3-12.6 31.5s-26.3-.4-31.5-12.6L316.7 416 160 416c0 35.3-28.7 64-64 64s-64-28.7-64-64 28.7-64 64-64c3.4 0 6.8 .3 10.1 .8L129.2 299C52.9 263.3 0 185.8 0 96L0 72zM151.8 368l144.4 0-22.9-53.4c-15.9 3.6-32.3 5.4-49.3 5.4s-33.4-1.9-49.3-5.4L151.8 368zM96 440a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"],
    "file-import": [384, 512, ["arrow-right-to-file"], "f56f", "M64 0C28.7 0 0 28.7 0 64l0 240 182.1 0-31-31c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l72 72c9.4 9.4 9.4 24.6 0 33.9l-72 72c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l31-31-182.1 0 0 96c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-277.5c0-17-6.7-33.3-18.7-45.3L258.7 18.7C246.7 6.7 230.5 0 213.5 0L64 0zM325.5 176L232 176c-13.3 0-24-10.7-24-24L208 58.5 325.5 176z"],
    "jug": [448, 512, [], "f8c6", "M160-16l128 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L160 48c-17.7 0-32-14.3-32-32s14.3-32 32-32zM400 168c0-13.3-10.7-24-24-24-10.3 0-19.1 6.5-22.5 15.6l25.1 32.2c12.1-1.3 21.4-11.5 21.4-23.9zM304 96l18.5 23.8c13.2-14.6 32.3-23.8 53.5-23.8 39.8 0 72 32.2 72 72 0 29.2-17.4 54.3-42.3 65.6 6.8 15.8 10.3 32.9 10.3 50.3L416 448c0 35.3-28.7 64-64 64L96 512c-35.3 0-64-28.7-64-64l0-164.1c0-28.5 9.5-56.1 27-78.6L144 96 304 96zM128 288c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32l192 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-192 0z"],
    "utensils": [512, 512, [127860, 61685, "cutlery"], "f2e7", "M63.9 14.4C63.1 6.2 56.2 0 48 0s-15.1 6.2-16 14.3L17.9 149.7c-1.3 6-1.9 12.1-1.9 18.2 0 45.9 35.1 83.6 80 87.7L96 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-224.4c44.9-4.1 80-41.8 80-87.7 0-6.1-.6-12.2-1.9-18.2L223.9 14.3C223.1 6.2 216.2 0 208 0s-15.1 6.2-15.9 14.4L178.5 149.9c-.6 5.7-5.4 10.1-11.1 10.1-5.8 0-10.6-4.4-11.2-10.2L143.9 14.6C143.2 6.3 136.3 0 128 0s-15.2 6.3-15.9 14.6L99.8 149.8c-.5 5.8-5.4 10.2-11.2 10.2-5.8 0-10.6-4.4-11.1-10.1L63.9 14.4zM448 0C432 0 320 32 320 176l0 112c0 35.3 28.7 64 64 64l32 0 0 128c0 17.7 14.3 32 32 32s32-14.3 32-32l0-448c0-17.7-14.3-32-32-32z"],
    "id-badge": [384, 512, [], "f2c1", "M64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-384c0-35.3-28.7-64-64-64L64 0zm96 352l64 0c44.2 0 80 35.8 80 80 0 8.8-7.2 16-16 16L96 448c-8.8 0-16-7.2-16-16 0-44.2 35.8-80 80-80zm-24-96a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zM152 64l80 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"],
    "spider": [512, 512, [128375], "f717", "M369.3-31c11.9-3.5 24.4 2.7 29 13.9l.8 2.3 40 136c2.5 8.4 .1 17.5-6.1 23.7l-64.1 64.1 76.4-20.8 19.9-59.8 .9-2.3c5-11.1 17.7-16.8 29.5-12.9 11.8 3.9 18.5 16.1 15.8 28l-.7 2.4-24 72c-2.5 7.6-8.7 13.4-16.5 15.6l-91.1 24.8 91.1 24.8c7.7 2.1 13.9 8 16.5 15.6l24 72 .7 2.4c2.7 11.9-4.1 24.1-15.8 28-11.8 3.9-24.5-1.8-29.5-12.9l-.9-2.3-19.9-59.8-76.4-20.8 64.1 64.1c6.1 6.1 8.5 15.1 6.2 23.4l-40 144-.8 2.3c-4.4 11.3-16.8 17.7-28.8 14.4-12-3.3-19.3-15.2-17.2-27.2l.5-2.4 36.2-130.5-37.2-37.2C351 406 308.4 448 256 448s-95-42-96-94.1l-37 37 36 122.3 .6 2.4c2.2 11.9-4.9 23.9-16.8 27.4-11.9 3.5-24.4-2.7-29-13.9l-.8-2.3-40-136c-2.5-8.4-.1-17.5 6.1-23.8l64.1-64.1-76.4 20.8-19.9 59.8-.9 2.3c-5 11.1-17.7 16.8-29.5 12.9s-18.5-16.1-15.8-28l.7-2.4 24-72c2.5-7.6 8.7-13.4 16.5-15.6l91.1-24.8-91.1-24.8c-7.7-2.1-13.9-8-16.5-15.6l-24-72-.7-2.4c-2.7-11.9 4.1-24.1 15.8-28s24.5 1.8 29.5 12.9l.9 2.3 19.9 59.8 76.4 20.8-64.1-64.1c-6.2-6.2-8.5-15.3-6.1-23.7l40-136 .8-2.3c4.6-11.3 17.1-17.4 29-13.9 11.9 3.5 19 15.5 16.8 27.4l-.6 2.4-36 122.3 53 53c1-43.3 36.4-78.1 79.9-78.1s78.9 34.8 79.9 78.2l53.1-53.1-36-122.3-.6-2.4c-2.2-12 4.9-23.9 16.8-27.4z"],
    "user-question": [576, 512, [], "e7b7", "M104.2 128a120 120 0 1 1 240 0 120 120 0 1 1 -240 0zm-88 354.3C16.2 383.8 96 304 194.5 304l59.4 0c98.5 0 178.3 79.8 178.3 178.3 0 16.4-13.3 29.7-29.7 29.7L45.9 512c-16.4 0-29.7-13.3-29.7-29.7zM496.2 120c-16.1 0-29.2 13.1-29.2 29.2 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-42.6 34.6-77.2 77.2-77.2s77.2 34.6 77.2 77.2c0 45.5-34.5 64.7-53.7 71.8-2.3 10.8-11.9 19-23.5 19-13.3 0-24-10.7-24-24 0-20.2 14.6-34.6 29.5-39.5 6-2 12.3-5.1 16.8-9.5 3.9-3.8 6.9-9 6.9-17.7 0-16.1-13.1-29.2-29.2-29.2zm-28 168a28 28 0 1 1 56 0 28 28 0 1 1 -56 0z"],
    "person-fairy": [576, 512, [], "e608", "M288 0a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM256 160l64 0c35.3 0 64 28.7 64 64l0 64c0 23.7-12.9 44.4-32 55.4L352 464c0 26.5-21.5 48-48 48l-32 0c-26.5 0-48-21.5-48-48l0-120.6c-19.1-11.1-32-31.7-32-55.4l0-64c0-35.3 28.7-64 64-64zM64 48c42.7 0 82.2 14 114.1 37.5 3.1 15.9 9.6 30.7 18.7 43.4-31.7 19.8-52.7 55-52.7 95.1l0 64c0 30.5 12.2 58.2 32 78.4l0 56.3c-14.8 6-31 9.3-48 9.3l-32 0c-17.7 0-32-14.3-32-32l0-16c0-39.5 17.9-74.8 46-98.3-65-30.7-110-97-110-173.7L0 80C0 62.3 14.3 48 32 48l32 0zM448 432c-17 0-33.2-3.3-48-9.3l0-56.3c19.8-20.2 32-47.8 32-78.4l0-64c0-40.1-21.1-75.3-52.7-95.1 9.1-12.7 15.6-27.5 18.7-43.4 31.9-23.6 71.4-37.5 114.1-37.5l32 0c17.7 0 32 14.3 32 32l0 32c0 76.7-45 142.9-110 173.7 28.1 23.5 46 58.8 46 98.3l0 16c0 17.7-14.3 32-32 32l-32 0z"],
    "mobile-retro": [384, 512, [], "e527", "M16 64C16 28.7 44.7 0 80 0L304 0c35.3 0 64 28.7 64 64l0 384c0 35.3-28.7 64-64 64L80 512c-35.3 0-64-28.7-64-64L16 64zm80 96l0 64c0 17.7 14.3 32 32 32l128 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-128 0c-17.7 0-32 14.3-32 32zm8 192a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm24 72c0-13.3-10.7-24-24-24s-24 10.7-24 24 10.7 24 24 24 24-10.7 24-24zm64-72a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm24 72c0-13.3-10.7-24-24-24s-24 10.7-24 24 10.7 24 24 24 24-10.7 24-24zm64-72a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm24 72c0-13.3-10.7-24-24-24s-24 10.7-24 24 10.7 24 24 24 24-10.7 24-24zM168 40c-13.3 0-24 10.7-24 24s10.7 24 24 24l48 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0z"],
    "signs-post": [512, 512, ["map-signs"], "f277", "M256.4 0c-17.7 0-32 14.3-32 32l0 32-160 0c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32l160 0 0 64-153.4 0c-4.2 0-8.3 1.7-11.3 4.7l-48 48c-6.2 6.2-6.2 16.4 0 22.6l48 48c3 3 7.1 4.7 11.3 4.7l153.4 0 0 96c0 17.7 14.3 32 32 32s32-14.3 32-32l0-96 160 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-160 0 0-64 153.4 0c4.2 0 8.3-1.7 11.3-4.7l48-48c6.2-6.2 6.2-16.4 0-22.6l-48-48c-3-3-7.1-4.7-11.3-4.7l-153.4 0 0-32c0-17.7-14.3-32-32-32z"],
    "group-arrows-rotate": [512, 512, [], "e4f6", "M37.6 122.3c-11.5 18.7-20.6 39-27 60.5-5 16.9 4.6 34.8 21.5 39.8s34.8-4.6 39.8-21.5c18.4-61.9 67.3-110.8 129.2-129.2 16.9-5 26.6-22.9 21.5-39.8S199.8 5.6 182.9 10.6C161.4 17 141.1 26.1 122.3 37.6 112.3 15.4 89.9 0 64 0 28.7 0 0 28.7 0 64 0 89.9 15.4 112.3 37.6 122.3zm436.7 0c22.2-10 37.6-32.4 37.6-58.3 0-35.3-28.7-64-64-64-25.9 0-48.3 15.4-58.3 37.6-18.7-11.5-39-20.6-60.5-27-16.9-5-34.8 4.6-39.8 21.5s4.6 34.8 21.5 39.8c61.9 18.4 110.8 67.3 129.2 129.2 5 16.9 22.9 26.6 39.8 21.5s26.6-22.9 21.5-39.8c-6.4-21.5-15.5-41.8-27-60.5zM512 448c0-25.9-15.4-48.3-37.6-58.3 11.5-18.7 20.6-39 27-60.5 5-16.9-4.6-34.8-21.5-39.8s-34.8 4.6-39.8 21.5c-18.4 61.9-67.3 110.8-129.2 129.2-16.9 5-26.6 22.9-21.5 39.8s22.9 26.6 39.8 21.5c21.5-6.4 41.8-15.5 60.5-27 10 22.2 32.4 37.6 58.3 37.6 35.3 0 64-28.7 64-64zM37.6 389.7c-22.2 10-37.6 32.4-37.6 58.3 0 35.3 28.7 64 64 64 25.9 0 48.3-15.4 58.3-37.6 18.7 11.5 39 20.6 60.5 27 16.9 5 34.8-4.6 39.8-21.5s-4.6-34.8-21.5-39.8c-61.9-18.4-110.8-67.3-129.2-129.2-5-16.9-22.9-26.6-39.8-21.5S5.6 312.2 10.6 329.1c6.4 21.5 15.5 41.8 27 60.5zM256 192c15.6 0 30 5.6 41.1 14.9l-15.3 15.3c-6.6 6.6-1.9 17.8 7.4 17.8l60.5 0c5.7 0 10.4-4.7 10.4-10.4l0-60.5c0-9.3-11.2-13.9-17.8-7.4l-11.2 11.2c-19.8-17.9-46.2-28.9-75.1-28.9-43.6 0-81.3 24.9-99.8 61.1-6 11.8-1.4 26.3 10.4 32.3s26.3 1.4 32.3-10.4c10.6-20.8 32.2-34.9 57-34.9zm58.6 93.1c-10.6 20.8-32.2 34.9-57 34.9-15.7 0-30-5.6-41.1-14.9l15.3-15.3c6.6-6.6 1.9-17.8-7.4-17.8L164 272c-5.7 0-10.4 4.7-10.4 10.4l0 60.5c0 9.3 11.2 13.9 17.8 7.4l11.2-11.2c19.8 17.9 46.2 28.9 75.1 28.9 43.6 0 81.3-24.9 99.8-61.1 6-11.8 1.4-26.3-10.4-32.3s-26.3-1.4-32.3 10.4z"],
    "diagram-venn": [640, 512, [], "e15a", "M224 416c-88.4 0-160-71.6-160-160S135.6 96 224 96c11 0 21.7 1.1 32 3.2-39.6 40.4-64 95.7-64 156.8s24.4 116.4 64 156.8c-10.3 2.1-21.1 3.2-32 3.2zm0 64c34.4 0 66.9-7.7 96-21.6 29.1 13.8 61.6 21.6 96 21.6 123.7 0 224-100.3 224-224S539.7 32 416 32C381.6 32 349.1 39.7 320 53.6 290.9 39.7 258.4 32 224 32 100.3 32 0 132.3 0 256S100.3 480 224 480zM416 96c88.4 0 160 71.6 160 160S504.4 416 416 416c-11 0-21.7-1.1-32-3.2 39.6-40.4 64-95.7 64-156.8S423.6 139.6 384 99.2C394.3 97.1 405 96 416 96z"],
    "arrows-split-up-and-left": [512, 512, [], "e4bc", "M342.6-22.6c-12.5-12.5-32.8-12.5-45.3 0l-96 96c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l41.4-41.4 0 195.9c-18.8-10.9-40.7-17.1-64-17.1l-114.7 0 41.4-41.4c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-96 96c-12.5 12.5-12.5 32.8 0 45.3l96 96c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L109.3 320 224 320c35.3 0 64 28.7 64 64 0 70.7 57.3 128 128 128l32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0c-35.3 0-64-28.7-64-64l0-306.7 41.4 41.4c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-96-96z"],
    "image-polaroid-user": [448, 512, [], "e1b6", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM96 96l256 0c17.7 0 32 14.3 32 32l0 192c0 17.7-14.3 32-32 32l-17.6 0c-7.4-36.5-39.7-64-78.4-64l-64 0c-38.7 0-71 27.5-78.4 64L96 352c-17.7 0-32-14.3-32-32l0-192c0-17.7 14.3-32 32-32zM224 248a56 56 0 1 0 0-112 56 56 0 1 0 0 112z"],
    "arrow-up-left": [384, 512, [], "e09d", "M32 64C14.3 64 0 78.3 0 96L0 320c0 17.7 14.3 32 32 32s32-14.3 32-32l0-146.7 265.4 265.4c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L109.3 128 256 128c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 64z"],
    "square-australian-dollar": [448, 512, [], "e718", "M0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm288 56l0 9.1c-27.3 5.2-48 29.3-48 58.1 0 28.2 19.9 52.5 47.6 58l23.5 4.7c5.2 1 9 5.6 9 11 0 6.2-5 11.2-11.2 11.2L272 304c-13.3 0-24 10.7-24 24s10.7 24 24 24l16 0 0 8c0 8.8 7.2 16 16 16s16-7.2 16-16l0-9.1c27.3-5.2 48-29.3 48-58.1 0-28.2-19.9-52.5-47.6-58L297 230.1c-5.2-1-9-5.6-9-11 0-6.2 5-11.2 11.2-11.2l28.8 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-8 0 0-8c0-8.8-7.2-16-16-16s-16 7.2-16 16zM160 239.4l14.4 48.6-28.8 0 14.4-48.6zm33 111.4c3.8 12.7 17.1 20 29.8 16.2s20-17.1 16.2-29.8L188 164.9c-3.7-12.4-15.1-20.9-28-20.9s-24.3 8.5-28 20.9L81 337.2c-3.8 12.7 3.5 26.1 16.2 29.8s26.1-3.5 29.8-16.2l4.4-14.8 57.2 0 4.4 14.8z"],
    "car-garage": [576, 512, [], "f5e2", "M300.8-13.3c-8.2-3.6-17.5-3.6-25.7 0l-256 112C3 105.8-4.4 124.6 2.7 140.8s26 23.6 42.1 16.5L288 50.9 531.2 157.3c16.2 7.1 35.1-.3 42.1-16.5s-.3-35.1-16.5-42.1l-256-112zM209.3 208l157.5 0c6.7 0 12.6 4.1 15 10.4l26.1 69.6-239.6 0 26.1-69.6c2.3-6.2 8.3-10.4 15-10.4zM98 292.8l-1.3 3.4C77.2 307.1 64 328 64 352l0 128c0 17.7 14.3 32 32 32l16 0c17.7 0 32-14.3 32-32l0-32 288 0 0 32c0 17.7 14.3 32 32 32l16 0c17.7 0 32-14.3 32-32l0-128c0-24-13.2-44.9-32.8-55.9l-1.3-3.4-36.3-96.9c-11.7-31.2-41.6-51.9-74.9-51.9l-157.5 0c-33.3 0-63.2 20.7-74.9 51.9L98 292.8zM160 336a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm224 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"],
    "person-from-portal": [576, 512, ["portal-exit"], "e023", "M180.8 121.2C164.7 30 132.8-32 96-32 43-32 0 96.9 0 256S43 544 96 544c19.8 0 38.2-17.9 53.4-48.7-39.2-5.2-69.4-38.7-69.4-79.3 0-44.2 35.8-80 80-80l28.2 0c1.2-12.7 2.2-25.8 2.8-39.1-38.8-17.5-57.3-62.7-41.3-102.6l21.9-54.9c2.6-6.4 5.6-12.5 9.2-18.3zM416 80a56 56 0 1 0 0-112 56 56 0 1 0 0 112zM275.7 181c1.2-3 4.2-5 7.4-5l35.9 0-22.7 90.6c-8.3 33.2 11 67 43.7 76.8L436 372.2 386.8 483c-7.2 16.1 .1 35.1 16.2 42.2s35.1-.1 42.2-16.2l56.6-127.4c11.7-26.4-2.4-57.2-30.1-65.5l-75.4-22.6 20.7-70.4 10 17.1c11.5 19.7 32.5 31.8 55.3 31.8l61.6 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-61.6 0-32.8-56.3c-14.3-24.6-40.6-39.7-69.1-39.7l-97.3 0c-29.4 0-55.9 17.9-66.9 45.3l-21.9 54.9c-6.6 16.4 1.4 35 17.8 41.6s35-1.4 41.6-17.8L275.7 181zM275.1 357l-2.1 5.8c-4.5 12.7-16.6 21.2-30.1 21.2L160 384c-17.7 0-32 14.3-32 32s14.3 32 32 32l82.9 0c38.2 0 72.6-22.7 87.8-57.3l-4.5-1.3c-20.4-6.1-37.9-17.6-51.2-32.4z"],
    "fill-drip": [576, 512, [], "f576", "M309.7 71.6l-64.4 64.4 33.4 33.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0l-33.4-33.4-96.4 96.4c-2.9 2.9-5.1 6.5-6.3 10.3l321.5 0 53.7-53.7c4.9-4.9 7.6-11.5 7.6-18.3s-2.7-13.5-7.6-18.3L346.3 71.6C341.5 66.7 334.9 64 328 64s-13.5 2.7-18.3 7.6zM58.3 232.4l96.4-96.4-49.4-49.4c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0L200 90.7 264.4 26.3C281.3 9.5 304.1 0 328 0s46.7 9.5 63.6 26.3L517.7 152.4C534.5 169.3 544 192.1 544 216s-9.5 46.7-26.3 63.6L311.6 485.7C294.7 502.5 271.9 512 248 512s-46.7-9.5-63.6-26.3L58.3 359.6C41.5 342.7 32 319.9 32 296s9.5-46.7 26.3-63.6zM512 544c-35.3 0-64-28.7-64-64 0-25.2 32.6-79.6 51.2-108.7 6-9.4 19.5-9.4 25.5 0 18.7 29.1 51.2 83.5 51.2 108.7 0 35.3-28.7 64-64 64z"],
    "shield-heart": [512, 512, [], "e574", "M269.4 2.9C265.2 1 260.7 0 256 0s-9.2 1-13.4 2.9L54.3 82.8c-22 9.3-38.4 31-38.3 57.2 .5 99.2 41.3 280.7 213.6 363.2 16.7 8 36.1 8 52.8 0 172.4-82.5 213.2-264 213.6-363.2 .1-26.2-16.3-47.9-38.3-57.2L269.4 2.9zM249.6 183.5l6.4 8.5 6.4-8.5c11.1-14.8 28.5-23.5 46.9-23.5 32.4 0 58.7 26.3 58.7 58.7l0 5.3c0 49.1-65.8 98.1-96.5 118.3-9.5 6.2-21.5 6.2-30.9 0-30.7-20.2-96.5-69.3-96.5-118.3l0-5.3c0-32.4 26.3-58.7 58.7-58.7 18.5 0 35.9 8.7 46.9 23.5z"],
    "trash-can-undo": [448, 512, ["trash-can-arrow-turn-left", "trash-undo-alt"], "f896", "M136.7 5.9L128 32 32 32C14.3 32 0 46.3 0 64S14.3 96 32 96l384 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-96 0-8.7-26.1C306.9-7.2 294.7-16 280.9-16L167.1-16c-13.8 0-26 8.8-30.4 21.9zM416 144l-384 0 0 304c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-304zM217.8 215.9c8.9 9.9 8.1 25-1.8 33.9L182.5 280 240 280c48.6 0 88 39.4 88 88l0 40c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-40c0-22.1-17.9-40-40-40l-57.5 0 33.5 30.2c9.9 8.9 10.7 24 1.8 33.9s-24 10.7-33.9 1.8l-80-72c-5.1-4.6-7.9-11-7.9-17.8s2.9-13.3 7.9-17.8l80-72c9.9-8.9 25-8.1 33.9 1.8z"],
    "champagne-glass": [256, 512, ["glass-champagne"], "f79e", "M33.9-10.6C38.4-23.4 50.5-32 64.1-32l128 0c13.6 0 25.7 8.6 30.2 21.4 19.3 55.1 39.9 139.6 36.6 212-1.7 36.1-9.4 73.3-30.1 102.2-16.4 22.9-39.5 38.6-68.7 45l0 131.4 32 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-128 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l32 0 0-131.4C67 342.2 43.9 326.6 27.5 303.6 6.8 274.8-1 237.6-2.6 201.5-6 129 14.6 44.6 33.9-10.6zM65.5 128l125.3 0C186 94.5 177.8 60.8 169 32L87.3 32c-8.9 28.8-17 62.5-21.8 96z"],
    "person-skiing-nordic": [576, 512, ["skiing-nordic"], "f7ca", "M424.8 16a56 56 0 1 1 0 112 56 56 0 1 1 0-112zm99.8 193.7c7.6 15.2 1.9 33.6-12.6 42l0 180.3-32 0 0-164.2-10.1 5c-27.4 13.7-60.7 6.1-79.4-18.2l-19.6-25.5-39.5 68.8 24.8 12.4c29.5 14.7 42.9 49.5 31.1 80.2l-28.2 73.4 149.4 0c7.9 0 15.6-2.3 22.2-6.7l7.9-5.3c11-7.4 25.9-4.4 33.3 6.7s4.4 25.9-6.7 33.3l-7.9 5.3C543 506.9 526 512 508.6 512l-189.1 0c-.5 0-1 0-1.5 0L24 512c-13.3 0-24-10.7-24-24s10.7-24 24-24l88 0c0-8.2 3.1-16.4 9.4-22.6l74.1-74.1 10.2-35.9c11.3 18.3 27.7 33.8 48.4 44.2l4.8 2.4-1.9 6.8c-3 10.5-8.6 20-16.3 27.7l-51.5 51.5 101.3 0 37.1-96.4-55.6-27.8C230.4 319 215.3 267 239.3 227.1l37.7-62.7-27.7-7.7c-9-2.5-18.1 3.2-20 12.3l-5.9 29.3c-3.1 15.6-17.1 26.3-32.5 25.7l-130 208-37.7 0 140.6-225c-3.4-6.3-4.6-13.8-3.1-21.3l5.9-29.3c9.1-45.6 55.1-73.8 99.9-61.4l32.5 9c46.7 13 88 40.8 117.6 79.3l24.9 32.3 40.4-20.2c15.8-7.9 35-1.5 42.9 14.3z"],
    "diagram-cells": [448, 512, [], "e475", "M448 160c0 35.3-28.7 64-64 64L64 224c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 64zM384 416l0-64-320 0 0 64 320 0zm0 64L64 480c-35.3 0-64-28.7-64-64l0-64c0-35.3 28.7-64 64-64l320 0c35.3 0 64 28.7 64 64l0 64c0 35.3-28.7 64-64 64z"],
    "square-6": [448, 512, [], "e25b", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM280 168c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24 10.7-24 24l0 12.1c7.5-2.7 15.6-4.1 24-4.1l32 0c39.8 0 72 32.2 72 72s-32.2 72-72 72l-32 0c-39.8 0-72-32.2-72-72l0-80c0-39.8 32.2-72 72-72l48 0c13.3 0 24 10.7 24 24zM208 320l32 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-32 0c-13.3 0-24 10.7-24 24s10.7 24 24 24z"],
    "square-2": [448, 512, [], "e257", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM176 145.3l62 0c36.5 0 66 29.6 66 66 0 27.1-16.6 51.5-41.9 61.4l-44.7 17.6c-12.9 5.1-22.1 16.3-24.6 29.6l79.3 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-104 0c-13.3 0-24-10.7-24-24l0-16.4c0-36.2 22.1-68.7 55.8-81.9l44.7-17.6c6.9-2.7 11.4-9.4 11.4-16.8 0-10-8.1-18-18-18l-62 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"],
    "arrows-to-dotted-line": [384, 512, [], "e0a6", "M278.6 102.6l-64 64c-12.5 12.5-32.8 12.5-45.3 0l-64-64c-9.2-9.2-11.9-22.9-6.9-34.9S115.1 48 128 48l32 0 0-48c0-17.7 14.3-32 32-32s32 14.3 32 32l0 48 32 0c12.9 0 24.6 7.8 29.6 19.8s2.2 25.7-6.9 34.9zm0 306.7c9.2 9.2 11.9 22.9 6.9 34.9S268.9 464 256 464l-32 0 0 48c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-48-32 0c-12.9 0-24.6-7.8-29.6-19.8s-2.2-25.7 6.9-34.9l64-64c12.5-12.5 32.8-12.5 45.3 0l64 64zM64 256a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm74.7 32a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm138.7-32a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM352 288a32 32 0 1 1 0-64 32 32 0 1 1 0 64z"],
    "hat-beach": [640, 512, [], "e606", "M320 32c-88.4 0-160 71.6-160 160l161.1 0c-.8-5.2-1.1-10.6-1.1-16 0-56.9 42.4-103.8 97.3-111-27-20.7-60.7-33-97.3-33zm1.1 224L160 256 16.2 371C6 379.2 0 391.6 0 404.8 0 428.6 19.4 448 43.2 448l553.5 0c23.9 0 43.2-19.4 43.2-43.2 0-13.1-6-25.5-16.2-33.8l-20.3-16.3c-19.9 18.2-46.4 29.2-75.5 29.2-17.2 0-33.5-3.9-48-10.8-14.5 6.9-30.8 10.8-48 10.8-61.9 0-112-50.1-112-112 0-5.4 .4-10.8 1.1-16zM480 314.3c11.7 13.3 28.9 21.7 48 21.7 35.3 0 64-28.7 64-64 0-19.1-8.4-36.3-21.7-48 13.3-11.7 21.7-28.9 21.7-48 0-35.3-28.7-64-64-64-19.1 0-36.3 8.4-48 21.7-11.7-13.3-28.9-21.7-48-21.7-35.3 0-64 28.7-64 64 0 19.1 8.4 36.3 21.7 48-13.3 11.7-21.7 28.9-21.7 48 0 35.3 28.7 64 64 64 19.1 0 36.3-8.4 48-21.7zM448 224a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"],
    "router": [512, 512, [], "f8da", "M320.2 48c58.8 0 112.5 21.8 153.4 57.9 9.9 8.8 25.1 7.8 33.9-2.1s7.8-25.1-2.1-33.9C456 26.4 391.2 0 320.2 0S184.5 26.4 135.1 69.9c-9.9 8.8-10.9 23.9-2.1 33.9s23.9 10.9 33.9 2.1C207.8 69.8 261.4 48 320.2 48zm24 200c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 72-232 0c-35.3 0-64 28.7-64 64l0 32c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-32c0-35.3-28.7-64-64-64l-104 0 0-72zm-99.5-61.3C265.4 170 291.6 160 320.2 160s54.9 10 75.5 26.7c10.3 8.3 25.4 6.8 33.8-3.5s6.8-25.4-3.5-33.8C397.1 126 360.2 112 320.2 112s-76.8 14-105.7 37.4c-10.3 8.3-11.9 23.5-3.5 33.8s23.5 11.9 33.8 3.5zM112.2 400a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm72 24a24 24 0 1 1 0-48 24 24 0 1 1 0 48z"],
    "sensor": [448, 512, [], "e028", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm48 88l0 112c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-112c0-13.3 10.7-24 24-24s24 10.7 24 24zm96 0l0 112c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-112c0-13.3 10.7-24 24-24s24 10.7 24 24z"],
    "square-check": [448, 512, [9745, 9989, 61510, "check-square"], "f14a", "M384 32c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l320 0zM342 145.7c-10.7-7.8-25.7-5.4-33.5 5.3L189.1 315.2 137 263.1c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l72 72c5 5 11.9 7.5 18.8 7s13.4-4.1 17.5-9.8L347.3 179.2c7.8-10.7 5.4-25.7-5.3-33.5z"],
    "paintbrush-fine": [576, 512, ["paint-brush-alt", "paint-brush-fine", "paintbrush-alt"], "f5a9", "M557.3 18.7c25 25 25 65.5 0 90.5L325 341.5c-16.2-41.3-49.2-74.3-90.5-90.5L466.7 18.7c25-25 65.5-25 90.5 0zM288 400c0 61.9-50.1 112-112 112L32 512c-17.7 0-32-14.3-32-32s14.3-32 32-32l4.8 0c17.6 0 29.6-18.9 27.8-36.4-.4-3.8-.6-7.7-.6-11.6 0-61.9 50.1-112 112-112s112 50.1 112 112z"],
    "bath": [512, 512, [128705, "bathtub"], "f2cd", "M96 77.3c0-7.3 5.9-13.3 13.3-13.3 3.5 0 6.9 1.4 9.4 3.9l14.9 14.9c-3.6 9.1-5.5 18.9-5.5 29.2 0 19.9 7.2 38 19.2 52-5.3 9.2-4 21.1 3.8 29 9.4 9.4 24.6 9.4 33.9 0L289 89c9.4-9.4 9.4-24.6 0-33.9-7.8-7.9-19.8-9.1-29-3.8-14-12-32.1-19.2-52-19.2-10.3 0-20.2 2-29.2 5.5L163.9 22.6C149.4 8.1 129.7 0 109.3 0 66.6 0 32 34.6 32 77.3L32 256c-17.7 0-32 14.3-32 32s14.3 32 32 32l0 48c0 28.4 12.4 54 32 71.6L64 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-16 256 0 0 16c0 17.7 14.3 32 32 32s32-14.3 32-32l0-40.4c19.6-17.6 32-43.1 32-71.6l0-48c17.7 0 32-14.3 32-32s-14.3-32-32-32L96 256 96 77.3z"],
    "chess-bishop": [320, 512, [9821], "f43a", "M64 384L48.3 368.3C17.4 337.4 0 295.4 0 251.7 0 213.1 13.5 175.8 38.2 146.1L106.7 64 96 64C78.3 64 64 49.7 64 32S78.3 0 96 0L224 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-10.7 0 47.6 57.1-85.9 85.9c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l82.3-82.3c18.7 27.3 28.7 59.7 28.7 93 0 43.7-17.4 85.7-48.3 116.6L256 384 312.2 454.3c5 6.3 7.8 14.1 7.8 22.2 0 19.6-15.9 35.5-35.5 35.5L35.5 512c-19.6 0-35.5-15.9-35.5-35.5 0-8.1 2.7-15.9 7.8-22.2L64 384z"],
    "fence": [512, 512, [], "e303", "M67.5 47.6L23 103.2c-4.5 5.7-7 12.7-7 20L16 448c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-30.6 48 0 0 30.6c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-30.6 48 0 0 30.6c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-324.8c0-7.3-2.5-14.3-7-20L444.5 47.6c-6.4-8-18.6-8-25 0L375 103.2c-4.5 5.7-7 12.7-7 20l0 38.1-48 0 0-38.1c0-7.3-2.5-14.3-7-20L268.5 47.6c-6.4-8-18.6-8-25 0L199 103.2c-4.5 5.7-7 12.7-7 20l0 38.1-48 0 0-38.2c0-7.3-2.5-14.3-7-20L92.5 47.6c-6.4-8-18.6-8-25 0zM368 225.4l0 128-48 0 0-128 48 0zm-176 0l0 128-48 0 0-128 48 0z"],
    "microwave": [576, 512, [], "e01b", "M0 128C0 92.7 28.7 64 64 64l448 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64 0 17.7-14.3 32-32 32s-32-14.3-32-32l-320 0c0 17.7-14.3 32-32 32s-32-14.3-32-32c-35.3 0-64-28.7-64-64L0 128zm96 56l0 144c0 13.3 10.7 24 24 24l240 0c13.3 0 24-10.7 24-24l0-144c0-13.3-10.7-24-24-24l-240 0c-13.3 0-24 10.7-24 24zm392-24c-13.3 0-24 10.7-24 24l0 144c0 13.3 10.7 24 24 24s24-10.7 24-24l0-144c0-13.3-10.7-24-24-24z"],
    "alarm-exclamation": [512, 512, [], "f843", "M256 64c123.7 0 224 100.3 224 224 0 50.3-16.6 96.8-44.6 134.2l35.2 35.2c12.5 12.5 12.5 32.8 0 45.2s-32.8 12.5-45.2 0l-35.2-35.2C352.8 495.4 306.3 512 256 512s-96.8-16.6-134.2-44.6L86.6 502.6c-12.5 12.5-32.8 12.5-45.2 0s-12.5-32.8 0-45.2l35.2-35.2C48.6 384.8 32 338.3 32 288 32 164.3 132.3 64 256 64zm0 288a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm0-192c-18.2 0-32.7 15.5-31.4 33.7l7.4 104c.9 12.6 11.4 22.3 23.9 22.3 12.6 0 23-9.7 23.9-22.3l7.4-104c1.3-18.2-13.1-33.7-31.4-33.7zM95.2 0c19.3 0 37.3 5.8 52.3 15.7 9.5 6.3 6.3 19.9-4.1 24.6-44.8 20.4-83.1 52.6-110.9 92.6-6.5 9.4-20.5 10.1-25-.4-4.9-11.4-7.6-24.1-7.6-37.3 0-52.6 42.6-95.2 95.2-95.2zM416.7 0c52.6 0 95.3 42.6 95.3 95.2 0 13.2-2.7 25.8-7.6 37.3-4.5 10.5-18.4 9.8-25 .4-27.8-40-66.1-72.2-110.9-92.6-10.4-4.7-13.7-18.3-4.1-24.6 15-9.9 33-15.7 52.3-15.7z"],
    "tomato": [512, 512, [], "e330", "M256-32c13.3 0 24 10.7 24 24l0 62.9C294.4 40.7 314.2 32 336 32l32 0c8.8 0 16 7.2 16 16 0 31.7-18.4 59-45.1 72 26.7 13 45.1 40.3 45.1 72 0 8.8-7.2 16-16 16l-48 0c-26.2 0-49.4-12.6-64-32-14.6 19.4-37.8 32-64 32l-48 0c-8.8 0-16-7.2-16-16 0-31.7 18.4-59 45.1-72-26.7-13-45.1-40.3-45.1-72 0-8.8 7.2-16 16-16l32 0c21.8 0 41.6 8.7 56 22.9L232-8c0-13.3 10.7-24 24-24zM80 192c0 35.3 28.7 64 64 64l48 0c23.3 0 45.2-6.3 64-17.1 18.8 10.9 40.7 17.1 64 17.1l48 0c35.3 0 64-28.7 64-64 0-18.7-4-36.4-11.2-52.4 55.8 35.5 91.2 91.7 91.2 164.4 0 130.9-114.6 208-256 208S0 434.9 0 304C0 231.2 35.4 175.1 91.2 139.6 84 155.6 80 173.3 80 192z"],
    "prescription-bottle-medical": [384, 512, ["prescription-bottle-alt"], "f486", "M0 32C0 14.3 14.3 0 32 0L352 0c17.7 0 32 14.3 32 32l0 32c0 17.7-14.3 32-32 32L32 96C14.3 96 0 81.7 0 64L0 32zM32 144l320 0 0 304c0 35.3-28.7 64-64 64L96 512c-35.3 0-64-28.7-64-64l0-304zM160 248l0 40-40 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l40 0 0 40c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-40 40 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-40 0 0-40c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16z"],
    "watch-calculator": [384, 512, [], "f8f0", "M123-32L261-32c24.5 0 45 18.4 47.7 42.7l6 54C353.8 70 384 103.5 384 144l0 224c0 40.5-30.2 74-69.3 79.3l-6 54C306 525.6 285.5 544 261 544L123 544c-24.5 0-45-18.4-47.7-42.7l-6-54C30.2 442 0 408.5 0 368L0 144c0-40.5 30.2-74 69.3-79.3l6-54C78-13.6 98.5-32 123-32zM304 128L80 128c-8.8 0-16 7.2-16 16l0 224c0 8.8 7.2 16 16 16l224 0c8.8 0 16-7.2 16-16l0-224c0-8.8-7.2-16-16-16zM120 160l144 0c13.3 0 24 10.7 24 24l0 16c0 13.3-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24l0-16c0-13.3 10.7-24 24-24zm16 112a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm56 24a24 24 0 1 1 0-48 24 24 0 1 1 0 48zm104-24a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zM112 360a24 24 0 1 1 0-48 24 24 0 1 1 0 48zm104-24a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm56 24a24 24 0 1 1 0-48 24 24 0 1 1 0 48z"],
    "draw-polygon": [512, 512, [58055, "vector-polygon"], "f5ee", "M64 0c23.7 0 44.4 12.9 55.4 32l273.1 0c11.1-19.1 31.7-32 55.4-32 35.3 0 64 28.7 64 64 0 34-26.5 61.8-60 63.9l-2.1 2.9-71.5 99.1c3.6 8 5.6 16.9 5.6 26.2s-2 18.2-5.6 26.2l2.2 3.1 69.3 96 2.1 2.9c33.5 2.1 60 29.9 60 63.9 0 35.3-28.7 64-64 64-23.7 0-44.4-12.9-55.4-32l-273.1 0c-11.1 19.1-31.7 32-55.4 32-35.3 0-64-28.7-64-64 0-23.7 12.9-44.4 32-55.4l0-273.1C12.9 108.4 0 87.7 0 64 0 28.7 28.7 0 64 0zM394.2 413.4l-65.5-90.6-2.2-3.1c-2.1 .2-4.3 .3-6.5 .3-35.3 0-64-28.7-64-64s28.7-64 64-64c2.2 0 4.4 .1 6.5 .3l67.7-93.7c-.6-.9-1.1-1.7-1.6-2.6L119.4 96c-5.6 9.7-13.7 17.8-23.4 23.4l0 273.1c9.7 5.6 17.8 13.7 23.4 23.4l273.1 0c.5-.9 1.1-1.8 1.6-2.6z"],
    "circle-guarani": [512, 512, [], "e73b", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM240 128c0-8.8 7.2-16 16-16s16 7.2 16 16l0 9.1c26.3 3.5 50 15.6 68 33.2 9.5 9.3 9.6 24.5 .3 33.9s-24.5 9.6-33.9 .3c-9.4-9.2-21.2-15.8-34.4-18.8l0 46.2 80 0c13.3 0 24 10.7 24 24 0 60.8-45.3 111.1-104 118.9l0 9.1c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-9.1c-58.7-7.8-104-58.1-104-118.9s45.3-111.1 104-118.9l0-9.1zM184 256c0 34.3 23.9 62.9 56 70.2l0-140.4c-32.1 7.3-56 36-56 70.2zm139.9 24l-51.9 0 0 46.2c24.2-5.5 43.8-23.2 51.9-46.2z"],
    "slider": [576, 512, [], "e252", "M288 160c0-35.3 28.7-64 64-64l32 0c35.3 0 64 28.7 64 64l0 64 96 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-96 0 0 64c0 35.3-28.7 64-64 64l-32 0c-35.3 0-64-28.7-64-64l0-192zM0 256c0-17.7 14.3-32 32-32l208 0 0 64-208 0c-17.7 0-32-14.3-32-32z"],
    "i-cursor": [256, 512, [], "f246", "M.1 29.3C-1.4 47 11.7 62.4 29.3 63.9l8 .7C70.5 67.3 96 95 96 128.3l0 95.7-32 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l32 0 0 95.7c0 33.3-25.5 61-58.7 63.8l-8 .7C11.7 449.6-1.4 465 .1 482.7S17 513.4 34.7 511.9l8-.7c34.1-2.8 64.2-18.9 85.4-42.9 21.2 24 51.2 40 85.4 42.9l8 .7c17.6 1.5 33.1-11.6 34.5-29.2s-11.6-33.1-29.2-34.5l-8-.7C185.5 444.7 160 417 160 383.7l0-95.7 32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0 0-95.7c0-33.3 25.5-61 58.7-63.8l8-.7c17.6-1.5 30.7-16.9 29.2-34.5S239-1.4 221.3 .1l-8 .7c-34.1 2.8-64.2 18.9-85.4 42.9-21.2-24-51.2-40-85.4-42.9l-8-.7C17-1.4 1.6 11.7 .1 29.3z"],
    "cloud-rainbow": [576, 512, [], "f73e", "M552 240c-23.5 0-45.3 7.2-63.4 19.6-8.5-5-17.5-9.1-27-12.3-1.5-7.8-3.8-15.4-6.6-22.6 26.9-20.5 60.5-32.8 97-32.8 13.3 0 24 10.7 24 24s-10.7 24-24 24zm0-96c-46 0-88.5 14.9-122.9 40.2-11.5-12.2-25.3-22.1-40.8-29 44.4-36.9 101.4-59.2 163.7-59.2 13.3 0 24 10.7 24 24s-10.7 24-24 24zm0-96c-87.5 0-166.4 37-221.8 96.1-16.1 .7-31.4 4.4-45.4 10.5-4.9-4.5-10-8.7-15.4-12.6 64.2-86.2 166.9-142.1 282.6-142.1 13.3 0 24 10.7 24 24s-10.7 24-24 24zM96 480c-53 0-96-43-96-96 0-42.5 27.6-78.6 65.9-91.2-1.3-6.7-1.9-13.7-1.9-20.8 0-61.9 50.1-112 112-112 43.1 0 80.5 24.3 99.2 60 14.7-17.1 36.5-28 60.8-28 44.2 0 80 35.8 80 80 0 5.5-.6 10.8-1.6 16 .5 0 1.1 0 1.6 0 53 0 96 43 96 96s-43 96-96 96L96 480z"],
    "heart-circle-plus": [576, 512, [], "e500", "M241 87.1l15 20.7 15-20.7C296 52.5 336.2 32 378.9 32 452.4 32 512 91.6 512 165.1l0 2.6c0 17.6-3.4 35.6-9.5 53.7-21.8-8.6-45.6-13.4-70.5-13.4-106 0-192 86-192 192 0 28.5 6.2 55.6 17.4 80-.5 0-.9 0-1.4 0-15.5 0-30.8-4.6-43.1-14.1-73-55.7-212.9-186-212.9-298.2l0-2.6C0 91.6 59.6 32 133.1 32 175.8 32 216 52.5 241 87.1zM432 256a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm16 80c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 48-48 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l48 0 0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48 48 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-48 0 0-48z"],
    "shield-dog": [512, 512, [], "e573", "M269.4 2.9C265.2 1 260.7 0 256 0s-9.2 1-13.4 2.9L54.3 82.8c-22 9.3-38.4 31-38.3 57.2 .5 99.2 41.3 280.7 213.6 363.2 16.7 8 36.1 8 52.8 0 172.4-82.5 213.2-264 213.6-363.2 .1-26.2-16.3-47.9-38.3-57.2L269.4 2.9zM160.9 286.2c4.8 1.2 9.9 1.8 15.1 1.8 35.3 0 64-28.7 64-64l0-64 44.2 0c12.1 0 23.2 6.8 28.6 17.7l7.2 14.3 64 0c8.8 0 16 7.2 16 16l0 32c0 44.2-35.8 80-80 80l-48 0 0 50.7c0 7.3-5.9 13.3-13.3 13.3-1.8 0-3.6-.4-5.2-1.1l-98.7-42.3c-6.6-2.8-10.8-9.3-10.8-16.4 0-2.8 .6-5.5 1.9-8l15-30zM160 160l48 0 0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-48c0-8.8 7.2-16 16-16zm128 48a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"],
    "file-slash": [576, 512, [], "e3a7", "M41-24.9c-9.4-9.4-24.6-9.4-33.9 0S-2.3-.3 7 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-89-89 0-243.6c0-17-6.7-33.3-18.7-45.3L354.7 18.7C342.7 6.7 326.5 0 309.5 0L160 0c-25.5 0-47.4 14.9-57.8 36.4L41-24.9zM96 165.8L96 448c0 35.3 28.7 64 64 64l256 0c7.8 0 15.3-1.4 22.2-4L96 165.8zM421.5 176L328 176c-13.3 0-24-10.7-24-24L304 58.5 421.5 176z"],
    "chess-rook-piece": [320, 512, ["chess-rook-alt"], "f448", "M16 64l0 106.7c0 13.8 4.5 27.3 12.8 38.4L64 256 64 384 7.8 454.3C2.7 460.6 0 468.4 0 476.5 0 496.1 15.9 512 35.5 512l248.9 0c19.6 0 35.5-15.9 35.5-35.5 0-8.1-2.7-15.9-7.8-22.2l-56.2-70.3 0-128 35.2-46.9c8.3-11.1 12.8-24.6 12.8-38.4L304 64c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 16-48 0 0-16c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 16-48 0 0-16c0-17.7-14.3-32-32-32S16 46.3 16 64z"],
    "greater-than-equal": [448, 512, [], "f532", "M21.9 94.4C5.1 88.8-3.9 70.6 1.7 53.9S25.4 28.1 42.1 33.6l384 128C439.2 166 448 178.2 448 192s-8.8 26-21.9 30.4l-384 128c-16.8 5.6-34.9-3.5-40.5-20.2s3.5-34.9 20.2-40.5L314.8 192 21.9 94.4zM416 416c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 480c-17.7 0-32-14.3-32-32s14.3-32 32-32l384 0z"],
    "envelope-open": [512, 512, [62135], "f2b6", "M64.4 175.8L256 33.9 447.6 175.8 289.5 293c-9.7 7.2-21.4 11-33.5 11s-23.8-3.9-33.5-11L64.4 175.8zM256-32c-12.1 0-23.8 3.9-33.5 11L25.9 124.7C9.6 136.8 0 155.8 0 176.1L0 416c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-239.9c0-20.3-9.6-39.4-25.9-51.4L289.5-21c-9.7-7.2-21.4-11-33.5-11z"],
    "mound": [512, 512, [], "e52d", "M112.4 179.2C142 127.7 196.8 96 256.2 96s114.2 31.7 143.9 83.2L508.7 368c12.3 21.3-3.1 48-27.7 48L31.5 416c-24.6 0-40-26.6-27.7-48L112.4 179.2z"],
    "rings-wedding": [512, 512, [], "f81b", "M113.7 8.8C116.4 3.4 121.9 0 128 0l96 0c6.1 0 11.6 3.4 14.3 8.8l16 32c2.3 4.5 2.3 9.8 0 14.3l-24.6 49.2C300.6 127.1 352 193.5 352 272 352 318.3 334.1 360.5 304.8 391.9 285.2 381 272 360 272 336l0-6.3c10.2-16.9 16-36.6 16-57.7 0-12-1.9-23.6-5.4-34.5-34.9 19-58.6 56-58.6 98.5 0 61.9 50.1 112 112 112s112-50.1 112-112c0-38.9-19.8-73.1-49.9-93.2-3.7-28.4-12.7-55.1-26-79.1 79.9 16.7 139.9 87.5 139.9 172.3 0 97.2-78.8 176-176 176-55.3 0-104.7-25.5-137-65.5-7.5 1-15.2 1.5-23 1.5-97.2 0-176-78.8-176-176 0-78.5 51.4-144.9 122.3-167.7L97.7 55.2c-2.3-4.5-2.3-9.8 0-14.3l16-32zM64 272c0 58.7 45.1 106.8 102.5 111.6-4.2-15.1-6.5-31.1-6.5-47.6 0-64.4 34.5-120.7 86.1-151.3-19.2-15.4-43.6-24.7-70.1-24.7-61.9 0-112 50.1-112 112z"],
    "grill-fire": [640, 512, [], "e5a4", "M64 72c0-22.1 17.9-40 40-40l368 0c22.1 0 40 17.9 40 40l0 24c0 26.8-4.7 52.4-13.3 76.2-4.3-4.1-8.6-8.1-13-12.1-23.8-21.4-60-21.5-83.9-.2-36.4 32.6-67.7 69.8-90.2 106.4-10.3 16.6-19.8 34.8-26.9 53.7-15.7-.2-31.1-2.1-45.9-5.4l-22.9 53.4 56.9 0c-.5 4.7-.7 9.4-.7 14.1 0 11.5 .9 22.8 2.7 33.9L224 416c0 35.3-28.7 64-64 64s-64-28.7-64-64 28.7-64 64-64c3.4 0 6.8 .3 10.1 .8L193.2 299C116.9 263.3 64 185.8 64 96l0-24zm96 368a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM505.7 240.3L518 226.5c5.4-6.1 13.3-8.8 20.9-8.9 7.2 0 14.3 2.6 19.9 7.8 19.7 18.3 39.8 43.2 55 70.6 15.1 27.2 26.2 58.1 26.2 88.1 0 88.7-71.3 159.8-160 159.8-89.6 0-160-71.3-160-159.8 0-37.3 16-73.4 36.8-104.5 20.9-31.3 47.5-59 70.9-80.2 5.7-5.2 13.1-7.7 20.3-7.5s13.4 3.2 18.8 7.5c14.4 11.4 38.9 40.7 38.9 40.7zM544 432.2c0-36.5-37-73-54.8-88.4-5.4-4.7-13.1-4.7-18.5 0-17.7 15.4-54.8 51.9-54.8 88.4 0 35.3 28.7 64 64 64s64-28.7 64-64z"],
    "distribute-spacing-horizontal": [448, 512, [], "e365", "M0 32C0 14.3 14.3 0 32 0S64 14.3 64 32l0 448c0 17.7-14.3 32-32 32S0 497.7 0 480L0 32zM128 144c0-26.5 21.5-48 48-48l96 0c26.5 0 48 21.5 48 48l0 224c0 26.5-21.5 48-48 48l-96 0c-26.5 0-48-21.5-48-48l0-224zM416 0c17.7 0 32 14.3 32 32l0 448c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-448c0-17.7 14.3-32 32-32z"],
    "bowl-soft-serve": [448, 512, [], "e46b", "M225.2 9.9c2.5-6 8.3-9.9 14.8-9.9l36.6 0c59.3 0 107.4 48.1 107.4 107.4 0 19.9-6.9 38.1-18.3 52.6l18.3 0c35.3 0 64 28.7 64 64s-28.7 64-64 64L64 288c-35.3 0-64-28.7-64-64s28.7-64 64-64l8.6 0c-5.4-9.4-8.6-20.3-8.6-32 0-35.3 28.7-64 64-64l94.1 0c9.9 0 17.9-8 17.9-17.9 0-4.8-1.9-9.3-5.3-12.7l-6.1-6.1c-4.6-4.6-5.9-11.5-3.5-17.4zM32 336l0 8c0 57.4 46.6 104 104 104l14.1 0-20.4 40.8c-2.5 5-2.2 10.9 .7 15.6s8.1 7.6 13.6 7.6l160 0c5.5 0 10.7-2.9 13.6-7.6s3.2-10.6 .7-15.6L297.9 448 312 448c57.4 0 104-46.6 104-104l0-8-384 0z"],
    "voicemail": [640, 512, [], "f897", "M144 160a80 80 0 1 1 0 160 80 80 0 1 1 0-160zM263.8 320c15.3-22.9 24.2-50.4 24.2-80 0-79.5-64.5-144-144-144S0 160.5 0 240 64.5 384 144 384l352 0c79.5 0 144-64.5 144-144S575.5 96 496 96 352 160.5 352 240c0 29.6 8.9 57.1 24.2 80l-112.5 0zM496 160a80 80 0 1 1 0 160 80 80 0 1 1 0-160z"],
    "vest": [448, 512, [], "e085", "M200 464l0-170.1c0-3.9-.5-7.8-1.4-11.6L144.4 65.4C162.1 77.2 188.2 88 224 88s61.9-10.8 79.6-22.6L249.4 282.3c-1 3.8-1.4 7.7-1.4 11.6L248 464c0 26.5 21.5 48 48 48l104 0c26.5 0 48-21.5 48-48l0-193.5c0-9.5-2.8-18.7-8.1-26.6l-47.9-71.8c-5.3-7.9-8.1-17.1-8.1-26.6L384 48c0-26.5-21.5-48-48-48l-3.5 0c-.3 0-.6 0-1 0-.6 0-1.2 0-1.8 0-18.8 0-34.1 9.7-44.1 18.8-9.3 8.4-28.5 21.2-61.7 21.2s-52.4-12.8-61.7-21.2c-10-9.1-25.3-18.8-44.1-18.8-.6 0-1.2 0-1.8 0-.3 0-.6 0-1 0L112 0C85.5 0 64 21.5 64 48l0 97.5c0 9.5-2.8 18.7-8.1 26.6L8.1 243.9C2.8 251.8 0 261.1 0 270.5L0 464c0 26.5 21.5 48 48 48l104 0c26.5 0 48-21.5 48-48z"],
    "audio-description": [512, 512, [], "f29e", "M0 128C0 92.7 28.7 64 64 64l384 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64L64 448c-35.3 0-64-28.7-64-64L0 128zm96 96l0 104c0 13.3 10.7 24 24 24s24-10.7 24-24l0-24 48 0 0 24c0 13.3 10.7 24 24 24s24-10.7 24-24l0-104c0-35.3-28.7-64-64-64l-16 0c-35.3 0-64 28.7-64 64zm48 32l0-32c0-8.8 7.2-16 16-16l16 0c8.8 0 16 7.2 16 16l0 32-48 0zm152-96c-13.3 0-24 10.7-24 24l0 144c0 13.3 10.7 24 24 24l48 0c39.8 0 72-32.2 72-72l0-48c0-39.8-32.2-72-72-72l-48 0zm48 144l-24 0 0-96 24 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24z"],
    "w": [576, 512, [119], "57", "M20.8 34c16.5-6.2 35 2.2 41.2 18.7L172.2 346.7 257.3 55c4-13.7 16.5-23 30.7-23s26.7 9.4 30.7 23L403.8 346.7 514 52.8c6.2-16.5 24.6-24.9 41.2-18.7S580.2 58.7 574 75.2l-144 384c-4.8 12.9-17.4 21.3-31.2 20.7s-25.7-9.8-29.5-23L288 178.3 206.7 457c-3.9 13.2-15.8 22.5-29.5 23s-26.3-7.8-31.2-20.7L2 75.2C-4.2 58.7 4.2 40.2 20.8 34z"],
    "cart-circle-xmark": [640, 512, [], "e3f4", "M24-16C10.7-16 0-5.3 0 8S10.7 32 24 32l45.3 0c3.9 0 7.2 2.8 7.9 6.6l52.1 286.3c6.2 34.2 36 59.1 70.8 59.1l104.6 0c1.4-16.7 4.9-32.8 10.3-48l-114.9 0c-11.6 0-21.5-8.3-23.6-19.7L171.3 288 340 288c34.9-48.5 91.7-80 156-80 15.8 0 31.2 1.9 46 5.5L568.9 69.9C572.6 50.2 557.5 32 537.4 32l-412.7 0-.4-2c-4.8-26.6-28-46-55.1-46L24-16zM208 512a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm288 32a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm59.3-180.7l-36.7 36.7 36.7 36.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-36.7-36.7-36.7 36.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l36.7-36.7-36.7-36.7c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l36.7 36.7 36.7-36.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6z"],
    "clouds-sun": [576, 512, [], "f746", "M325.6-14.8c4.9 2 8.5 6.4 9.5 11.6L352 80 435.2 96.8c5.2 1.1 9.5 4.6 11.6 9.5s1.5 10.5-1.4 14.9l-17.1 25.8c-9.1-2-18.5-3.1-28.2-3.1-25.1 0-48.5 7.2-68.2 19.7-12.1-39.2-48.6-67.7-91.8-67.7-53 0-96 43-96 96 0 13.6 2.8 26.5 7.9 38.2-23.8 16.2-41.8 40.3-50.4 68.4L44.8 287.2c-5.2-1.1-9.5-4.6-11.6-9.5s-1.5-10.5 1.4-14.9L81.6 192 34.7 121.3c-2.9-4.4-3.5-10-1.4-14.9s6.4-8.5 11.6-9.5L128 80 144.8-3.2c1.1-5.2 4.6-9.5 9.5-11.6s10.5-1.5 14.9 1.4L240 33.6 310.7-13.3c4.4-2.9 10-3.5 14.9-1.4zM273.7 218c-15.3-6.4-32-10-49.7-10-9.6 0-19 1.1-28.1 3.1-2.5-5.8-3.9-12.3-3.9-19.1 0-26.5 21.5-48 48-48s48 21.5 48 48c0 8.1-2 15.8-5.6 22.5-3 1.1-5.9 2.2-8.8 3.5zm213 166c-11.2-27.6-31.7-50.4-57.6-64.5-11-45.6-52.1-79.5-101.1-79.5l-1.3 0c12.3-28.3 40.5-48 73.3-48 35 0 64.8 22.5 75.6 53.8 8.7-3.7 18.3-5.8 28.4-5.8 39.8 0 72 32.2 72 72s-32.2 72-72 72l-17.3 0zM448 432c0 44.2-35.8 80-80 80l-192 0c-44.2 0-80-35.8-80-80 0-33.9 21.1-62.9 50.9-74.5-1.9-6.8-2.9-14-2.9-21.5 0-44.2 35.8-80 80-80 30.8 0 57.5 17.4 70.9 42.8 9.3-6.8 20.7-10.8 33.1-10.8 30.9 0 56 25.1 56 56 0 3.2-.3 6.4-.8 9.4 36.9 7.1 64.8 39.6 64.8 78.6z"],
    "eye-dropper": [512, 512, ["eye-dropper-empty", "eyedropper"], "f1fb", "M341.6 29.2l-101.6 101.6-9.4-9.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l160 160c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-9.4-9.4 101.6-101.6c39-39 39-102.2 0-141.1s-102.2-39-141.1 0zM55.4 323.3c-15 15-23.4 35.4-23.4 56.6l0 42.4-26.6 39.9c-8.5 12.7-6.8 29.6 4 40.4s27.7 12.5 40.4 4l39.9-26.6 42.4 0c21.2 0 41.6-8.4 56.6-23.4l109.4-109.4-45.3-45.3-109.4 109.4c-3 3-7.1 4.7-11.3 4.7l-36.1 0 0-36.1c0-4.2 1.7-8.3 4.7-11.3l109.4-109.4-45.3-45.3-109.4 109.4z"],
    "circle-xmark": [512, 512, [61532, "times-circle", "xmark-circle"], "f057", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM167 167c9.4-9.4 24.6-9.4 33.9 0l55 55 55-55c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-55 55 55 55c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-55-55-55 55c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l55-55-55-55c-9.4-9.4-9.4-24.6 0-33.9z"],
    "trailer": [640, 512, [], "e041", "M32 96c0-35.3 28.7-64 64-64l384 0c35.3 0 64 28.7 64 64l0 256 64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-296.4 0c.2 2.6 .4 5.3 .4 8 0 48.6-39.4 88-88 88s-88-39.4-88-88c0-2.7 .1-5.4 .4-8L96 416c-35.3 0-64-28.7-64-64L32 96zm408 16c-13.3 0-24 10.7-24 24l0 160c0 13.3 10.7 24 24 24s24-10.7 24-24l0-160c0-13.3-10.7-24-24-24zM112 136l0 160c0 13.3 10.7 24 24 24s24-10.7 24-24l0-160c0-13.3-10.7-24-24-24s-24 10.7-24 24zm176-24c-13.3 0-24 10.7-24 24l0 160c0 13.3 10.7 24 24 24s24-10.7 24-24l0-160c0-13.3-10.7-24-24-24zM264 424a40 40 0 1 0 -80 0 40 40 0 1 0 80 0z"],
    "turkish-lira-sign": [448, 512, ["try", "turkish-lira"], "e2bb", "M160 32c17.7 0 32 14.3 32 32l0 43.6 121.4-34.7c12.7-3.6 26 3.7 29.7 16.5s-3.7 26-16.5 29.7l-134.6 38.5 0 46.1 121.4-34.7c12.7-3.6 26 3.7 29.7 16.5s-3.7 26-16.5 29.7l-134.6 38.5 0 162.5 72 0c53 0 96-43 96-96 0-17.7 14.3-32 32-32s32 14.3 32 32c0 88.4-71.6 160-160 160l-104 0c-17.7 0-32-14.3-32-32l0-176.2-25.4 7.3c-12.7 3.6-26-3.7-29.7-16.5s3.7-26 16.5-29.7l38.6-11 0-46.1-25.4 7.3c-12.7 3.6-26-3.7-29.7-16.5s3.7-26 16.5-29.7l38.6-11 0-61.9c0-17.7 14.3-32 32-32z"],
    "gauge-circle-minus": [640, 512, [], "e497", "M288 0c126.8 0 232.1 92.2 252.4 213.2-14.3-3.4-29.1-5.2-44.4-5.2-70.9 0-132.8 38.4-166.1 95.6-5.3-4.6-11.3-8.3-17.9-11L312 120c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 172.7c-23.5 9.5-40 32.5-40 59.3 0 35.3 28.7 64 64 64 5.7 0 11.2-.7 16.5-2.1 2.5 34.5 14 66.4 32.3 93.5-15.8 3-32.1 4.6-48.8 4.6-141.4 0-256-114.6-256-256S146.6 0 288 0zM176 176a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm-16 80a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM432 144a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM352 400a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm224 0c0-8.8-7.2-16-16-16l-128 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l128 0c8.8 0 16-7.2 16-16z"],
    "draw-square": [512, 512, [62923, "vector-square"], "f5ef", "M32 119.4C12.9 108.4 0 87.7 0 64 0 28.7 28.7 0 64 0 87.7 0 108.4 12.9 119.4 32l273.1 0c11.1-19.1 31.7-32 55.4-32 35.3 0 64 28.7 64 64 0 23.7-12.9 44.4-32 55.4l0 273.1c19.1 11.1 32 31.7 32 55.4 0 35.3-28.7 64-64 64-23.7 0-44.4-12.9-55.4-32l-273.1 0c-11.1 19.1-31.7 32-55.4 32-35.3 0-64-28.7-64-64 0-23.7 12.9-44.4 32-55.4l0-273.1zm64 0l0 273.1c9.7 5.6 17.8 13.7 23.4 23.4l273.1 0c5.6-9.7 13.7-17.8 23.4-23.4l0-273.1c-9.7-5.6-17.8-13.7-23.4-23.4L119.4 96c-5.6 9.7-13.7 17.8-23.4 23.4z"],
    "mountains": [640, 512, [9968], "f6fd", "M256 32c13.7 0 26.4 7.5 33 19.6l202.5 373c6.3 11.6 6 25.7-.8 37.1-6.8 11.3-19 18.3-32.2 18.3l-405 0c-13.2 0-25.5-7-32.2-18.3s-7-25.5-.7-37.1l202.5-373 2.8-4.3C232.8 37.8 244 32 256 32zM416 96c11.7 0 22.4 6.4 28.1 16.6l175.5 320 1.8 3.8c3.5 9.1 2.7 19.4-2.3 27.9-5.8 9.7-16.2 15.7-27.5 15.7l-56.2 0c12-24.7 11.6-53.8-1.7-78.2l0 0-151.4-278.8 5.7-10.2 2.3-3.7c6-8.1 15.5-13 25.7-13zM178.7 267.5l21.8 21.7c5.9 5.8 15.3 5.8 21.2 0l40.7-40.4c5.6-5.6 13.2-8.7 21.2-8.7l35 0-62.4-115-77.3 142.5z"],
    "truck-tow": [640, 512, [], "e2b8", "M144 64l48 192-96 0c-35.3 0-64 28.7-64 64l0 64c0 35.3 28.7 64 64 64l3.3 0c10.4 36.9 44.4 64 84.7 64s74.2-27.1 84.7-64l102.6 0c10.4 36.9 44.4 64 84.7 64s74.2-27.1 84.7-64l3.3 0c35.3 0 64-28.7 64-64l0-118.8c0-6.1-1.2-12.2-3.4-17.8L556.1 126.2C548.8 107.9 531.1 96 511.5 96L400 96c-26.5 0-48 21.5-48 48l0 108.8-203.1-273C143.3-27.6 134.6-32 125.3-32 109.1-32 96-18.9 96-2.7L96 128c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-8c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 8c0 35.3 28.7 64 64 64s64-28.7 64-64l0-64zM536 256l-120 0 0-96 84.7 0 38.4 96.1c-1 0-2.1-.1-3.1-.1zM144 424a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zm312-40a40 40 0 1 1 0 80 40 40 0 1 1 0-80z"],
    "location-minus": [384, 512, ["map-marker-minus"], "f609", "M0 188.6C0 84.4 86 0 192 0S384 84.4 384 188.6c0 119.3-120.2 262.3-170.4 316.8-11.8 12.8-31.5 12.8-43.3 0-50.2-54.5-170.4-197.5-170.4-316.8zM120 168c-13.3 0-24 10.7-24 24s10.7 24 24 24l144 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-144 0z"],
    "shield-xmark": [512, 512, ["shield-times"], "e24c", "M269.4 2.9C265.2 1 260.7 0 256 0s-9.2 1-13.4 2.9L54.3 82.8c-22 9.3-38.4 31-38.3 57.2 .5 99.2 41.3 280.7 213.6 363.2 16.7 8 36.1 8 52.8 0 172.4-82.5 213.2-264 213.6-363.2 .1-26.2-16.3-47.9-38.3-57.2L269.4 2.9zm54.5 169.2c9.4 9.4 9.4 24.6 0 33.9L290 240 323.9 273.9c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-33.9-33.9-33.9 33.9c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l33.9-33.9-33.9-33.9c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0L256 206.1 290 172.1c9.4-9.4 24.6-9.4 33.9 0z"],
    "face-shush": [512, 512, [], "e38c", "M512 256c0 89.5-45.9 168.2-115.4 214 2.2-6.9 3.4-14.3 3.4-22l0-40c0-37.1-28-67.6-64-71.6l0-5.8c19.4-11.2 36.3-26.4 49.4-44.5 7.8-10.7 5.4-25.7-5.3-33.5s-25.7-5.4-33.5 5.3c-4.2 5.7-8.9 11.1-14.1 15.9-9.4-28.9-36.5-49.8-68.5-49.8-35.9 0-65.6 26.2-71.1 60.6-10.6-7.3-19.9-16.3-27.5-26.7-7.8-10.7-22.8-13.1-33.5-5.3s-13.1 22.8-5.3 33.5c16.6 22.8 39.2 41.1 65.4 52.6l0 21.3c-29.1 21.9-48 56.7-48 96l0 16C144 477 144.3 481.9 144.9 486.7 59.2 445.3 0 357.6 0 256 0 114.6 114.6 0 256 0S512 114.6 512 256zM208 160a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm128 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM264 432c-13.3 0-24 10.7-24 24l0 16c0 13.3 10.7 24 24 24l64 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-64 0c-39.8 0-72-32.2-72-72l0-16c0-31.4 20-58 48-67.9l0-92.1c0-13.3 10.7-24 24-24s24 10.7 24 24l0 88 40 0c13.3 0 24 10.7 24 24l0 32c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-8-40 0z"],
    "square-eurozone": [448, 512, [], "e727", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm40 112l72 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0 0 43.2 40 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-40 0 0 36.8 49.6 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L104 368c-13.3 0-24-10.7-24-24l0-176c0-13.3 10.7-24 24-24zm152 0l88 0c8.3 0 16 4.3 20.4 11.4s4.8 15.9 1 23.4L294.8 320 344 320c13.3 0 24 10.7 24 24s-10.7 24-24 24l-88 0c-8.3 0-16-4.3-20.4-11.4s-4.8-15.9-1-23.4L305.2 192 256 192c-13.3 0-24-10.7-24-24s10.7-24 24-24z"],
    "head-side-speak": [576, 512, [], "e75f", "M64.4 512l128 0c53 0 96-43 96-96l0-72c0-13.3 10.7-24 24-24l1 0c26 0 47-21 47-47 0-11-3.9-21.6-10.9-30.1L313.8 200c-2-2.4-3.2-5.3-3.6-8.3-15.7-108.4-108.9-191.7-221.7-191.7-10.8 0-21.3 .8-31.7 2.2-14.5 2-24.3 15-24.3 29.6l0 448.1c0 17.7 14.3 32 32 32zm80-320a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm63.1 237.2L166 425.8c-12.2-1-21.6-11.2-21.6-23.4 0-10.8 7.3-20.2 17.8-22.8l40.4-10.1c19.2-4.8 37.8 9.7 37.8 29.5 0 17.8-15.2 31.8-32.9 30.3zM476.5 225c-9.4 9.4-9.4 24.6 0 33.9 71.9 71.9 71.9 188.4 0 260.2-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0c90.6-90.6 90.6-237.5 0-328.1-9.4-9.4-24.6-9.4-33.9 0zm-67.9 67.9c-9.4 9.4-9.4 24.6 0 33.9 34.4 34.4 34.4 90.1 0 124.5-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0c53.1-53.1 53.1-139.2 0-192.3-9.4-9.4-24.6-9.4-33.9 0z"],
    "house-day": [640, 512, [], "e00e", "M192 16c8.2 0 16.3 .9 24 2.6L216-32c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 50.6c7.7-1.7 15.8-2.6 24-2.6zm60.4 17.7C266 42.4 277.6 54 286.3 67.6l35.8-35.8c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0L252.4 33.7zm-85.3 158l89.5-86.3c-10-24.3-33.9-41.3-61.8-41.3-36.9 0-66.8 29.9-66.8 66.8 0 27 16 50.3 39.1 60.8zm-35.5 30.7c-13.6-8.7-25.2-20.3-33.9-33.9L61.9 224.2c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l35.8-35.8zM80 128c0-8.2 .9-16.3 2.6-24L32 104c-13.3 0-24 10.7-24 24s10.7 24 24 24l50.6 0c-1.7-7.7-2.6-15.8-2.6-24zM97.7 67.6C106.4 54 118 42.4 131.6 33.7L95.8-2.1c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9L97.7 67.6zM560 336l19.9 0c15.5 0 28.1-12.6 28.1-28.1 0-7.6-3.1-14.9-8.6-20.2L395.5 91.1C388.1 84 378.3 80 368 80s-20.1 4-27.5 11.1L136.6 287.7c-5.5 5.3-8.6 12.6-8.6 20.2 0 15.5 12.6 28.1 28.1 28.1l19.9 0 0 144c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-144zM320 312c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-48z"],
    "volcano": [512, 512, [127755], "f770", "M160 144c-35.3 0-64-28.7-64-64s28.7-64 64-64c15.7 0 30 5.6 41.2 15 11.2-18.6 31.6-31 54.8-31s43.6 12.4 54.8 31c11.1-9.4 25.5-15 41.2-15 35.3 0 64 28.7 64 64s-28.7 64-64 64c-14.7 0-28.3-5-39.1-13.3l-32 48C275.3 187 266 192 256 192s-19.3-5-24.9-13.3l-32-48C188.3 139 174.7 144 160 144zM144 352l48.4-24.2c10.2-5.1 21.6-7.8 33-7.8 19.6 0 38.4 7.8 52.2 21.6l32.5 32.5c6.3 6.3 14.9 9.9 23.8 9.9 11.3 0 21.8-5.6 28-15l9.7-14.6-59-66.3c-9.1-10.2-22.2-16.1-35.9-16.1l-41.8 0c-13.7 0-26.8 5.9-35.9 16.1l-59.9 67.4 4.7-3.5zm19.4-95.8c18.2-20.5 44.3-32.2 71.8-32.2l41.8 0c27.4 0 53.5 11.7 71.8 32.2l150.2 169c8.5 9.5 13.2 21.9 13.2 34.7 0 28.8-23.4 52.2-52.2 52.2L52.2 512C23.4 512 0 488.6 0 459.8 0 447.1 4.7 434.7 13.2 425.2l150.2-169z"],
    "wand-sparkles": [512, 512, [], "f72b", "M464 6.1c9.5-8.5 24-8.1 33 .9l8 8c9 9 9.4 23.5 .9 33l-85.8 95.9c-2.6 2.9-4.1 6.7-4.1 10.7l0 21.4c0 8.8-7.2 16-16 16l-15.8 0c-4.6 0-8.9 1.9-11.9 5.3L100.7 500.9c-6.3 7.1-15.3 11.1-24.8 11.1-8.8 0-17.3-3.5-23.5-9.8L9.7 459.7c-6.2-6.2-9.7-14.7-9.7-23.5 0-9.5 4-18.5 11.1-24.8l111.6-99.8c3.4-3 5.3-7.4 5.3-11.9l0-27.6c0-8.8 7.2-16 16-16l34.6 0c3.9 0 7.7-1.5 10.7-4.1L464 6.1zM432 288c3.6 0 6.7 2.4 7.7 5.8l14.8 51.7 51.7 14.8c3.4 1 5.8 4.1 5.8 7.7s-2.4 6.7-5.8 7.7l-51.7 14.8-14.8 51.7c-1 3.4-4.1 5.8-7.7 5.8s-6.7-2.4-7.7-5.8l-14.8-51.7-51.7-14.8c-3.4-1-5.8-4.1-5.8-7.7s2.4-6.7 5.8-7.7l51.7-14.8 14.8-51.7c1-3.4 4.1-5.8 7.7-5.8zM87.7 69.8l14.8 51.7 51.7 14.8c3.4 1 5.8 4.1 5.8 7.7s-2.4 6.7-5.8 7.7l-51.7 14.8-14.8 51.7c-1 3.4-4.1 5.8-7.7 5.8s-6.7-2.4-7.7-5.8L57.5 166.5 5.8 151.7c-3.4-1-5.8-4.1-5.8-7.7s2.4-6.7 5.8-7.7l51.7-14.8 14.8-51.7c1-3.4 4.1-5.8 7.7-5.8s6.7 2.4 7.7 5.8zM208 0c3.7 0 6.9 2.5 7.8 6.1l6.8 27.3 27.3 6.8c3.6 .9 6.1 4.1 6.1 7.8s-2.5 6.9-6.1 7.8l-27.3 6.8-6.8 27.3c-.9 3.6-4.1 6.1-7.8 6.1s-6.9-2.5-7.8-6.1l-6.8-27.3-27.3-6.8c-3.6-.9-6.1-4.1-6.1-7.8s2.5-6.9 6.1-7.8l27.3-6.8 6.8-27.3c.9-3.6 4.1-6.1 7.8-6.1z"],
    "fire-flame": [384, 512, ["flame"], "f6df", "M372.5 256.5l-.7-1.9C337.8 160.8 282 76.5 209.1 8.5l-3.3-3C202.1 2 197.1 0 192 0s-10.1 2-13.8 5.5l-3.3 3C102 76.5 46.2 160.8 12.2 254.6l-.7 1.9C3.9 277.3 0 299.4 0 321.6 0 426.7 86.8 512 192 512s192-85.3 192-190.4c0-22.2-3.9-44.2-11.5-65.1zM188.8 148.3c2-2.7 5.2-4.3 8.5-4.3 5.9 0 10.7 4.8 10.7 10.7l0 11.4c0 8.9 3.6 17.4 9.9 23.6l51.5 50.7c22.1 21.8 34.6 51.5 34.6 82.5 0 60.2-48.8 109-109 109l-3 0c-61.9 0-112-50.1-112-112l0-8.2c0-21.2 7.8-41.6 21.8-57.4l6.9-7.8c2.1-2.4 5.1-3.7 8.3-3.7 6.1 0 11 4.9 11 11l0 44c0 24.3 19.8 44 44.1 44 24.2 0 43.9-19.6 43.9-43.8 0-11.6-4.6-22.8-12.8-31l-13.2-13.2c-14-14-21.9-33.1-21.9-53 0-16.2 5.3-32 15-44.9l5.8-7.8z"],
    "bowling-ball-pin": [576, 512, [], "e0c3", "M416 64c0-35.3 28.7-64 64-64s64 28.7 64 64l0 1.1c0 7.4-1 14.8-3 22l-17.7 64.8c-.7 2.7-1.3 5.4-1.8 8.1l-83.1 0c-.5-2.7-1.1-5.4-1.8-8.1L418.9 87.1c-2-7.2-2.9-14.6-2.9-22l0-1.1zm2.3 427.9l-10.9-27.3c35.4-43.9 56.6-99.8 56.6-160.6 0-33.9-6.6-66.4-18.6-96l79.7 0c.3 .8 .5 1.6 .8 2.4L566 319.3c6.6 17.9 10 36.8 10 55.8 0 20.5-3.9 40.9-11.5 59.9l-22.7 56.9C536.9 504 525.1 512 512 512l-64 0c-13.1 0-24.9-8-29.7-20.1zM0 304a208 208 0 1 1 416 0 208 208 0 1 1 -416 0zM224 172a28 28 0 1 0 -56 0 28 28 0 1 0 56 0zM196 288a28 28 0 1 0 0-56 28 28 0 1 0 0 56zm-44-68a28 28 0 1 0 -56 0 28 28 0 1 0 56 0z"],
    "microphone": [384, 512, [], "f130", "M192 0C139 0 96 43 96 96l0 128c0 53 43 96 96 96s96-43 96-96l0-128c0-53-43-96-96-96zM48 184c0-13.3-10.7-24-24-24S0 170.7 0 184l0 40c0 97.9 73.3 178.7 168 190.5l0 49.5-48 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l144 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0 0-49.5c94.7-11.8 168-92.6 168-190.5l0-40c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 40c0 79.5-64.5 144-144 144S48 303.5 48 224l0-40z"],
    "crown": [576, 512, [128081], "f521", "M313 87.2c9.2-7.3 15-18.6 15-31.2 0-22.1-17.9-40-40-40s-40 17.9-40 40c0 12.6 5.9 23.9 15 31.2L194.6 194.8c-10 15.7-31.3 19.6-46.2 8.4L88.9 158.7c4.5-6.4 7.1-14.3 7.1-22.7 0-22.1-17.9-40-40-40s-40 17.9-40 40c0 21.8 17.5 39.6 39.2 40L87.8 393.5c4.7 31.3 31.6 54.5 63.3 54.5l273.8 0c31.7 0 58.6-23.2 63.3-54.5L520.8 176c21.7-.4 39.2-18.2 39.2-40 0-22.1-17.9-40-40-40s-40 17.9-40 40c0 8.4 2.6 16.3 7.1 22.7l-59.4 44.6c-14.9 11.2-36.2 7.3-46.2-8.4L313 87.2z"],
    "tent-arrow-turn-left": [512, 512, [], "e580", "M-.5 113l72 72c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-31-31 350.1 0c22.1 0 40 17.9 40 40l0 24c0 13.3 10.7 24 24 24s24-10.7 24-24l0-24c0-48.6-39.4-88-88-88l-350.1 0 31-31c9.4-9.4 9.4-24.6 0-33.9S80.9-2.3 71.5 7L-.5 79c-9.4 9.4-9.4 24.6 0 33.9zM60.3 292.6L37.1 476c-2.4 19.1 12.5 36 31.7 36l154.5 0c17.7 0 32-14.3 32-32l0-117.4c0-5.9 4.7-10.6 10.6-10.6 4 0 7.7 2.3 9.5 5.9l68.2 136.5c5.4 10.8 16.5 17.7 28.6 17.7l71.9 0c19.3 0 34.2-16.9 31.7-36L452.7 292.7c-1.2-9.7-6.9-18.4-15.3-23.4L271.9 169.9c-10.2-6.1-22.9-6.1-33.1 .1L75.4 269.3c-8.3 5.1-13.9 13.7-15.1 23.3z"],
    "truck-fast": [640, 512, ["shipping-fast"], "f48b", "M64 96c0-35.3 28.7-64 64-64l288 0c35.3 0 64 28.7 64 64l0 32 50.7 0c17 0 33.3 6.7 45.3 18.7L621.3 192c12 12 18.7 28.3 18.7 45.3L640 384c0 35.3-28.7 64-64 64l-3.3 0c-10.4 36.9-44.4 64-84.7 64s-74.2-27.1-84.7-64l-102.6 0c-10.4 36.9-44.4 64-84.7 64s-74.2-27.1-84.7-64l-3.3 0c-35.3 0-64-28.7-64-64l0-48-40 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l112 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L24 240c-13.3 0-24-10.7-24-24s10.7-24 24-24l176 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L24 144c-13.3 0-24-10.7-24-24S10.7 96 24 96l40 0zM576 288l0-50.7-45.3-45.3-50.7 0 0 96 96 0zM256 424a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zm232 40a40 40 0 1 0 0-80 40 40 0 1 0 0 80z"],
    "user-pen": [640, 512, ["user-edit"], "f4ff", "M256.1 248a120 120 0 1 0 0-240 120 120 0 1 0 0 240zm-29.7 56c-98.5 0-178.3 79.8-178.3 178.3 0 16.4 13.3 29.7 29.7 29.7l196.5 0 10.9-54.5c4.3-21.7 15-41.6 30.6-57.2l67.3-67.3c-28-18.3-61.4-28.9-97.4-28.9l-59.4 0zM332.3 466.9l-11.9 59.6c-.2 .9-.3 1.9-.3 2.9 0 8 6.5 14.6 14.6 14.6 1 0 1.9-.1 2.9-.3l59.6-11.9c12.4-2.5 23.8-8.6 32.7-17.5l118.9-118.9-80-80-118.9 118.9c-8.9 8.9-15 20.3-17.5 32.7zm267.8-123c22.1-22.1 22.1-57.9 0-80s-57.9-22.1-80 0l-28.8 28.8 80 80 28.8-28.8z"],
    "square-norwegian-krone": [448, 512, [], "e707", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm56 96c13.3 0 24 10.7 24 24l0 102.1 55-55c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-37.8 37.8 41.9 77.9c6.3 11.7 1.9 26.2-9.8 32.5s-26.2 1.9-32.5-9.8l-35.1-65.2-15.8 15.8 0 38.1c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-208c0-13.3 10.7-24 24-24zm182.2 79c10.1-4.6 21.1-7 32.4-7l9.4 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-9.4 0c-8.1 0-15.9 3.2-21.7 9s-9 13.5-9 21.7l0 81.4c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-144c0-13.3 10.7-24 24-24 10.1 0 18.7 6.2 22.2 15z"],
    "person-snowmobiling": [512, 512, ["snowmobile"], "f7d1", "M192 48a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM309.5 85.3c-5.9-11.9-20.3-16.7-32.2-10.7s-16.7 20.3-10.7 32.2l32 64 0 .1-23.2 29-83.5-60.3c-10.3-7.4-22.7-11.4-35.4-11.4-33.4 0-60.5 27.1-60.5 60.5L96 224c-35.3 0-64 28.7-64 64l0 48c-19.4 14.6-32 37.8-32 64 0 44.2 35.8 80 80 80l160 0c44.2 0 80-35.8 80-80 0-18-6-34.6-16-48l53.6 0 4.6 10.1 32.3 69.9-19.5 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l56.5 0c.4 0 .7 0 1.1 0l23.5 0c30.9 0 56-25.1 56-56 0-13.3-10.7-24-24-24s-24 10.7-24 24c0 4.4-3.6 8-8 8l-8.6 0-36.9-80c56.2-.4 101.6-46 101.6-102.3 0-6-3.4-11.4-8.7-14.1l-158.2-79.1-3.6-7.3-32-64zM80 368l160 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L80 432c-17.7 0-32-14.3-32-32s14.3-32 32-32z"],
    "burger-soda": [576, 512, [], "f858", "M264.6-16C239.2-16 217 1.1 210.5 25.6L191.7 96 64 96c-13.3 0-24 10.7-24 24s10.7 24 24 24L92.2 468.2C94.3 493 115.1 512 140 512l71.1 0c-2-8.1-3.1-16.6-3.1-25.3 0-10.7 3.1-20.7 8.4-29.1-5.3-10.1-8.4-21.5-8.4-33.7 0-15.6 5-30 13.4-41.8-8.4-12.4-13.4-27.3-13.4-43.5 0-16.5 2.3-38.2 14.3-59.1 19.3-33.7 66.1-89.8 158.7-101.5l3-34c13.3 0 24-10.7 24-24s-10.7-24-24-24l-142.6 0 15.5-58.1c.9-3.5 4.1-5.9 7.7-5.9L296 32c13.3 0 24-10.7 24-24s-10.7-24-24-24l-31.4 0zM256 486.7c0 31.6 25.6 57.1 57.1 57.1l205.7 0c31.6 0 57.1-25.6 57.1-57.1 0-3.8-3.1-6.9-6.9-6.9l-306.3 0c-3.8 0-6.9 3.1-6.9 6.9zm29.3-118.9l261.5 0c16.2 0 29.3-13.1 29.3-29.3 0-12.3-1.8-24.6-7.9-35.2-15.8-27.5-58-79.4-152.1-79.5-94.1 .1-136.3 52-152.1 79.5-6.1 10.7-7.9 22.9-7.9 35.2 0 16.2 13.1 29.3 29.3 29.3zm-5.3 32c-13.3 0-24 10.7-24 24s10.7 24 24 24l272 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-272 0zM400 272a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm-64 16a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm144 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"],
    "rabbit-running": [576, 512, ["rabbit-fast"], "f709", "M460.7 39.3l-2.2-2.1c-4.7-4.6-11.5-6.4-17.9-4.7s-11.4 6.6-13.1 13l-.8 2.9c-3.3 11.8-5.1 23.7-5.5 35.6 24.3 20.6 42.9 47.8 53.3 78.8-8.2-1.9-16.5-2.9-25-2.9-.6 0-1.1 0-1.7 0-18.4-44-56.5-77.4-103.6-89.3l-3.4-.9c-6.2-1.6-12.9-.6-18.5 2.6-10.8 6.2-15.6 19.5-11.2 31.1 14.9 39.5 44.3 71.4 81.4 89.7-3.7 6.6-6.4 14-7.6 21.8L279.7 154.9c-30.9-17.7-65.9-26.9-101.5-26.9-32.3 0-62.2 16.8-78.9 44.4-10.3-12.5-25.8-20.4-43.2-20.4-30.9 0-56 25.1-56 56s25.1 56 56 56c11.3 0 21.8-3.3 30.6-9.1 4.9 17.2 14.5 33.1 28.4 45.9L257.2 431.2C269 442 284.4 448 300.4 448L416 448c17.7 0 32-14.3 32-32s-14.3-32-32-32l-96 0 0-43.5c0-42.9-28.4-80.5-69.6-92.3l-30.8-8.8c-8.5-2.4-13.4-11.3-11-19.8s11.3-13.4 19.8-11l30.8 8.8c55 15.7 92.8 65.9 92.8 123.1l0 15.7 56-32.4 6.4-3.7 101.3 0c33.3 0 60.3-27 60.3-60.3 0-18.1-8.2-35.3-22.2-46.7l-34.6-28.2c-4.6-3.7-9.4-7.1-14.5-10 8.4-49.3-7.8-100-43.9-135.5zm-318.5 382c-14.7 9.8-18.7 29.7-8.9 44.4s29.7 18.7 44.4 8.9l46-30.7-48.6-44.5-32.9 22zM480 240a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"],
    "dial-max": [576, 512, [], "e15e", "M288 0a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM401.4 174.7c56.7 56.7 61.9 145.4 15.7 208L305.3 270.9c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9L383.2 416.7c-62.6 46.2-151.3 41-208-15.7-62.5-62.5-62.5-163.8 0-226.3s163.8-62.5 226.3 0zM512 288a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM32 256a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM64 96a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM480 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM64 480a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm416-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "face-hushed": [512, 512, [], "e37b", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM176 224a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm128 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM179.5 164.8c-20.3 2.7-38.9 11.9-53.8 25.8-8.1 7.5-20.7 7.1-28.3-1s-7.1-20.7 1-28.3c20.6-19.3 46.8-32.4 75.9-36.2 5.8-.8 11.7-1.2 17.7-1.2 11 0 20 9 20 20s-9 20-20 20c-4.2 0-8.4 .3-12.5 .8zM320 164c-11 0-20-9-20-20s9-20 20-20c6 0 11.9 .4 17.7 1.2 29.1 3.8 55.3 17 75.9 36.2 8.1 7.5 8.5 20.2 1 28.3s-20.2 8.5-28.3 1c-14.9-13.9-33.5-23.1-53.8-25.8-4.1-.5-8.3-.8-12.5-.8zM256 336a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"],
    "stocking": [384, 512, [], "f7d5", "M96 0C78.3 0 64 14.3 64 32l0 32c0 17.7 14.3 32 32 32l256 0c17.7 0 32-14.3 32-32l0-32c0-17.7-14.3-32-32-32L96 0zm0 144l0 94.9c0 10.7-5.3 20.7-14.2 26.6L55.7 282.9C20.9 306.1 0 345.1 0 386.9l0 2.2c0 67.8 55 122.8 122.8 122.8 24.2 0 48-7.2 68.1-20.6L295 422c35.6-23.7 57-63.7 57-106.5l0-171.5-256 0z"],
    "circle-danish-krone": [512, 512, [], "e746", "M0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zM176 152c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 208c0 13.3 10.7 24 24 24s24-10.7 24-24l0-38.1 15.8-15.8 35.1 65.2c6.3 11.7 20.8 16 32.5 9.8s16-20.8 9.8-32.5L227.2 270.7 265 233c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-55 55 0-102.1zm136 40c-13.3 0-24 10.7-24 24l0 144c0 13.3 10.7 24 24 24s24-10.7 24-24l0-81.4c0-8.1 3.2-15.9 9-21.7s13.5-9 21.7-9l9.4 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-9.4 0c-11.3 0-22.3 2.4-32.4 7-3.6-8.8-12.2-15-22.2-15zm64 192a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"],
    "user-clock": [576, 512, [], "f4fd", "M224 8a120 120 0 1 1 0 240 120 120 0 1 1 0-240zM194.3 304l59.4 0c3.9 0 7.9 .1 11.8 .4-16.2 28.2-25.5 60.8-25.5 95.6 0 41.8 13.4 80.5 36 112L45.7 512C29.3 512 16 498.7 16 482.3 16 383.8 95.8 304 194.3 304zM288 400a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm144-80c-8.8 0-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16l48 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-32 0 0-48c0-8.8-7.2-16-16-16z"],
    "face-downcast-sweat": [512, 512, [], "e371", "M98.2 31.9c-8.8-10.7-18.5-20.9-29-30-3-2.6-7.4-2.6-10.4 0-10.5 9.1-20.1 19.3-29 30-14.7 17.8-29.8 40.1-29.8 64.1 0 36.4 27.6 64 64 64s64-27.6 64-64c0-24-15.2-46.3-29.8-64.1zM256 512c141.4 0 256-114.6 256-256S397.4 0 256 0c-37.4 0-72.9 8-104.9 22.4 12.5 18.8 25 44.2 25 73.6 0 62.9-49.1 112-112 112-20.7 0-39.9-5.3-56.3-14.6-5 20-7.7 41-7.7 62.6 0 141.4 114.6 256 256 256zm-58.5-98c-7.7 10.8-22.7 13.2-33.5 5.5s-13.2-22.7-5.5-33.5c21.7-30.2 57.3-50 97.5-50s75.7 19.8 97.5 50c7.7 10.8 5.3 25.8-5.5 33.5s-25.8 5.3-33.5-5.5c-13.1-18.2-34.4-30-58.5-30s-45.4 11.8-58.5 30zM120 240l80 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zm168 24c0-13.3 10.7-24 24-24l80 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24z"],
    "shield-plus": [512, 512, [], "e24a", "M269.4 2.9C265.2 1 260.7 0 256 0s-9.2 1-13.4 2.9L54.3 82.8c-22 9.3-38.4 31-38.3 57.2 .5 99.2 41.3 280.7 213.6 363.2 16.7 8 36.1 8 52.8 0 172.4-82.5 213.2-264 213.6-363.2 .1-26.2-16.3-47.9-38.3-57.2L269.4 2.9zM256 144c13.3 0 24 10.7 24 24l0 48 48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0 0 48c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-48-48 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l48 0 0-48c0-13.3 10.7-24 24-24z"],
    "accent-grave": [192, 512, [], "60", "M108.3 204.8L41.2 95C35.2 85.2 32 73.8 32 62.3 32 28.1 59.8 0 94 0 123.2 0 148.4 20.4 154.5 49l27.1 126.6c5.3 24.9-13.7 48.4-39.2 48.4-14 0-26.9-7.3-34.2-19.2z"],
    "headphones-slash": [576, 512, [], "e77c", "M41-24.9c-9.4-9.4-24.6-9.4-33.9 0S-2.3-.3 7 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-70.3-70.3c8.5-14.3 13.3-31 13.3-48.8l0-160C512 100.3 411.7 0 288 0 226.6 0 171 24.7 130.5 64.7L41-24.9zM175.8 109.9C204.7 81.5 244.3 64 288 64 376.4 64 448 135.6 448 224l0 37.5c-10-3.5-20.8-5.5-32-5.5l-16 0c-21.1 0-39.1 13.7-45.5 32.7L175.8 109.9zm11.8 147.5c-3.7-.9-7.6-1.4-11.6-1.4l-16 0c-11.2 0-22 1.9-32 5.5l0-37.5c0-8.3 .6-16.4 1.8-24.3L77.5 147.3C68.8 171.2 64 197.1 64 224l0 160c0 53 43 96 96 96l16 0c26.5 0 48-21.5 48-48l0-128c0-4-.5-7.9-1.4-11.6l-35-35z"],
    "hood-cloak": [512, 512, [], "f6ef", "M31.8 416.4L6.2 454.7C2.2 460.8 0 467.9 0 475.2 0 495.5 16.5 512 36.8 512l438.3 0c20.3 0 36.8-16.5 36.8-36.8 0-7.3-2.2-14.4-6.2-20.4l-25.6-38.3c-21-31.5-32.2-68.6-32.2-106.5l0-91.7c0-37.9-11.2-75-32.2-106.5L389 71.5c-2.7-4-1.2-9.4 3.1-11.6l45-22.5C443.8 34.1 448 27.3 448 19.8 448 8.9 439.1 0 428.2 0L288 0C164.3 0 64 100.3 64 224l0 85.9c0 37.9-11.2 75-32.2 106.5zM352 448l-192 0 0-160c0-53 43-96 96-96s96 43 96 96l0 160z"],
    "file-odf": [576, 512, [], "e7fc", "M280 380c24.3 0 44 19.7 44 44l0 80c0 24.3-19.7 44-44 44l-16 0c-24.3 0-44-19.7-44-44l0-80c0-24.3 19.7-44 44-44l16 0zm120 0c28.7 0 52 23.3 52 52l0 64c0 28.7-23.3 52-52 52l-32 0c-11 0-20-9-20-20l0-128 .4-4c1.9-9.1 9.9-16 19.6-16l32 0zm144 0c11 0 20 9 20 20s-9 20-20 20l-28 0 0 24 28 0c11 0 20 9 20 20s-9 20-20 20l-28 0 0 44c0 11-9 20-20 20s-20-9-20-20l0-128 .4-4c1.9-9.1 9.9-16 19.6-16l48 0zM245.5 0c17 0 33.2 6.8 45.2 18.8L397.3 125.2c12 12 18.7 28.3 18.7 45.2l0 165.5-176 0c-35.3 0-64 28.7-64 64l0 112-80 0c-35.3 0-64-28.7-64-64L32 64C32 28.7 60.7 0 96 0L245.5 0zM264 420c-2.2 0-4 1.8-4 4l0 80c0 2.2 1.8 4 4 4l16 0c2.2 0 4-1.8 4-4l0-80c0-2.2-1.8-4-4-4l-16 0zm124 88l12 0c6.6 0 12-5.4 12-12l0-64c0-6.6-5.4-12-12-12l-12 0 0 88zM240 152c0 13.3 10.7 24 24 24l93.5 0-117.5-117.5 0 93.5z"],
    "square-arrow-up": [448, 512, ["arrow-square-up"], "f33c", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM241 135l80 80c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-39-39 0 150.1c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-150.1-39 39c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l80-80c9.4-9.4 24.6-9.4 33.9 0z"],
    "clock-ten-thirty": [512, 512, [], "e355", "M256 512a256 256 0 1 1 0-512 256 256 0 1 1 0 512zm24-120l0-136c0-8-4-15.5-10.7-20l-96-64c-11-7.4-25.9-4.4-33.3 6.7s-4.4 25.9 6.7 33.3L232 268.8 232 392c0 13.3 10.7 24 24 24s24-10.7 24-24z"],
    "square-4": [448, 512, [], "e259", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM168 144c13.3 0 24 10.7 24 24l0 88 48 0 0-88c0-13.3 10.7-24 24-24s24 10.7 24 24l0 88 8 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-8 0 0 40c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-40-56 0c-22.1 0-40-17.9-40-40l0-96c0-13.3 10.7-24 24-24z"],
    "shower": [512, 512, [128703], "f2cc", "M64 131.9c0-19.8 16.1-35.9 35.9-35.9 9.5 0 18.6 3.8 25.4 10.5l16.2 16.2c-21 38.9-17.4 87.5 10.9 123L151 247c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0L345 121c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-1.3 1.3c-35.5-28.3-84.1-31.9-123-10.9L170.5 61.3C151.8 42.5 126.4 32 99.9 32 44.7 32 0 76.7 0 131.9L0 448c0 17.7 14.3 32 32 32s32-14.3 32-32l0-316.1zM256 352a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm64 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm0-128a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm64 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm0-128a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm64 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm32-32a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "square-sterling": [448, 512, [], "e713", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm86.2 217.5C126.3 191.6 168.9 128 231.6 128l2.2 0c19.7 0 38.8 6.4 54.5 18.2l14.2 10.6c10.6 8 12.8 23 4.8 33.6s-23 12.8-33.6 4.8l-14.2-10.6C252 179 243 176 233.7 176l-2.2 0c-28.5 0-47.8 28.9-37 55.2l1.4 3.5c2.9 6.9 4.9 14.1 6.3 21.3l69.7 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-68.8 0c-2.1 17-8.3 33.5-18.3 48L296 336c13.3 0 24 10.7 24 24s-10.7 24-24 24l-160 0c-9.2 0-17.5-5.2-21.6-13.5s-3-18 2.6-25.3L143.7 311c5.4-6.9 9-14.7 10.8-23L144 288c-8.8 0-16-7.2-16-16s7.2-16 16-16l8.8 0c-.4-1-.7-2-1.1-3l-1.4-3.5z"],
    "fishing-rod": [448, 512, [], "e3a8", "M328 136l0-16c0-39.8-32.2-72-72-72-92.8 0-168 75.2-168 168l0 72 8 0c17.7 0 32 14.3 32 32l0 160c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32L0 320c0-17.7 14.3-32 32-32l8 0 0-72C40 96.7 136.7 0 256 0 322.3 0 376 53.7 376 120l0 16c0 13.3-10.7 24-24 24s-24-10.7-24-24zM256 344c0-71.6 55.6-127.8 89-148.1 4.3-2.6 9.6-2.6 14 0 33.5 20.3 89 76.6 89 148.1 0 32-16 80-64 112l27.3 27.3c3 3 4.7 7.1 4.7 11.3l0 1.4c0 8.8-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16l0-1.4c0-4.2 1.7-8.3 4.7-11.3L320 456c-48-32-64-80-64-112zm128-32a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"],
    "square-caret-up": [448, 512, ["caret-square-up"], "f151", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM224 160c6.7 0 13 2.8 17.6 7.7l104 112c6.5 7 8.2 17.2 4.4 25.9S337.5 320 328 320l-208 0c-9.5 0-18.2-5.7-22-14.4s-2.1-18.9 4.4-25.9l104-112c4.5-4.9 10.9-7.7 17.6-7.7z"],
    "circle-arrow-up-left": [512, 512, [], "e0fb", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM208 296c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-112c0-13.3 10.7-24 24-24l112 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-54.1 0 103 103c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-103-103 0 54.1z"],
    "box-dollar": [448, 512, ["box-usd"], "f4a0", "M369.4 128l-34.3-48-87.1 0 0 48 121.4 0zM200 128l0-48-87.1 0-34.3 48 121.4 0zM0 148.5c0-13.3 4.2-26.3 11.9-37.2L60.9 42.8C72.9 26 92.3 16 112.9 16l222.1 0c20.7 0 40.1 10 52.1 26.8l48.9 68.5c7.8 10.9 11.9 23.9 11.9 37.2L448 416c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 148.5zM228 192c-11 0-20 9-20 20l0 4c-28.8 .3-52 23.7-52 52.5 0 25.7 18.5 47.6 43.9 51.8l41.7 7c6 1 10.4 6.2 10.4 12.3 0 6.9-5.6 12.5-12.5 12.5L184 352c-11 0-20 9-20 20s9 20 20 20l24 0 0 4c0 11 9 20 20 20s20-9 20-20l0-4.7c25-4.1 44-25.7 44-51.8 0-25.7-18.5-47.6-43.9-51.8l-41.7-7c-6-1-10.4-6.2-10.4-12.3 0-6.9 5.6-12.5 12.5-12.5l47.5 0c11 0 20-9 20-20s-9-20-20-20l-8 0 0-4c0-11-9-20-20-20z"],
    "theta": [384, 512, [], "f69e", "M64 256C64 200 80.2 150.7 104.9 116.2 129.6 81.6 160.8 64 192 64s62.4 17.6 87.1 52.2C303.8 150.7 320 200 320 256s-16.2 105.3-40.9 139.8C254.4 430.4 223.2 448 192 448s-62.4-17.6-87.1-52.2C80.2 361.3 64 312 64 256zM192 0C134.8 0 86 32.5 52.8 79 19.6 125.6 0 188.2 0 256S19.6 386.4 52.8 433c33.2 46.5 82 79 139.2 79s106-32.5 139.2-79C364.4 386.4 384 323.8 384 256S364.4 125.6 331.2 79C298 32.5 249.2 0 192 0zM144 224c-17.7 0-32 14.3-32 32s14.3 32 32 32l96 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-96 0z"],
    "face-smile-tongue": [512, 512, [], "e394", "M320 490.3c3.8 3.8 7.8 7.2 12 10.2-24 7.5-49.5 11.5-76 11.5-141.4 0-256-114.6-256-256S114.6 0 256 0 512 114.6 512 256c0 45.8-12 88.9-33.1 126.1-4.8-10.9-11.6-21.2-20.5-30.1l-32.7-32.7c1-2.3 1.9-4.6 2.8-6.9 4.6-12.4-1.7-26.2-14.1-30.9s-26.2 1.7-30.9 14.1C364.1 347.3 314.3 384 256 384s-108.1-36.7-127.4-88.4c-4.6-12.4-18.5-18.7-30.9-14.1S79 300 83.6 312.4c26.1 69.8 93.4 119.6 172.4 119.6 1.9 0 3.7 0 5.6-.1L320 490.3zm-1.4-69.2c32.5-11.8 60.8-32.4 81.8-59.1l23.9 23.9c19.5 19.5 19.5 51 0 70.4s-51 19.5-70.4 0l-35.3-35.3zM176 180c15.5 0 28 12.5 28 28l0 8c0 11 9 20 20 20s20-9 20-20l0-8c0-37.6-30.4-68-68-68s-68 30.4-68 68l0 8c0 11 9 20 20 20s20-9 20-20l0-8c0-15.5 12.5-28 28-28zm132 28c0-15.5 12.5-28 28-28s28 12.5 28 28l0 8c0 11 9 20 20 20s20-9 20-20l0-8c0-37.6-30.4-68-68-68s-68 30.4-68 68l0 8c0 11 9 20 20 20s20-9 20-20l0-8z"],
    "file-vector": [384, 512, [], "e64c", "M0 64C0 28.7 28.7 0 64 0L213.5 0c17 0 33.3 6.7 45.3 18.7L365.3 125.3c12 12 18.7 28.3 18.7 45.3L384 448c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zm208-5.5l0 93.5c0 13.3 10.7 24 24 24L325.5 176 208 58.5zM240 256l-96 0c0-17.7-14.3-32-32-32s-32 14.3-32 32 14.3 32 32 32l0 96c-17.7 0-32 14.3-32 32s14.3 32 32 32 32-14.3 32-32l96 0c0 17.7 14.3 32 32 32s32-14.3 32-32-14.3-32-32-32l0-96c17.7 0 32-14.3 32-32s-14.3-32-32-32-32 14.3-32 32zM152 376l0-80 80 0 0 80-80 0z"],
    "video-arrow-up-right": [576, 512, [], "e2c9", "M32 128c0-35.3 28.7-64 64-64l256 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64L96 448c-35.3 0-64-28.7-64-64l0-256zm432 48l73.5-58.8c4.2-3.4 9.4-5.2 14.8-5.2 13.1 0 23.7 10.6 23.7 23.7l0 240.6c0 13.1-10.6 23.7-23.7 23.7-5.4 0-10.6-1.8-14.8-5.2L464 336 464 176zM272 296c0 13.3 10.7 24 24 24s24-10.7 24-24l0-112c0-13.3-10.7-24-24-24l-112 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l54.1 0-103 103c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l103-103 0 54.1z"],
    "map-location": [640, 512, ["map-marked"], "f59f", "M576 48c0-11.1-5.7-21.4-15.2-27.2s-21.2-6.4-31.1-1.4L413.5 77.5 234.1 17.6c-8.1-2.7-16.8-2.1-24.4 1.7l-128 64C70.8 88.8 64 99.9 64 112l0 352c0 11.1 5.7 21.4 15.2 27.2s21.2 6.4 31.1 1.4l116.1-58.1 173.3 57.8c-4.3-6.4-8.5-13.1-12.6-19.9-11-18.3-21.9-39.3-30-61.8l-101.2-33.7 0-284.5 128 42.7 0 99.3c31-35.8 77-58.4 128-58.4 22.6 0 44.2 4.4 64 12.5L576 48zM392 341.9c0 68.9 64.1 150.4 98.6 189.3 11.6 13 31.3 13 42.9 0 34.5-38.9 98.6-120.4 98.6-189.3 0-65.1-53.7-117.9-120-117.9S392 276.8 392 341.9z"],
    "table-cells-header-lock": [640, 512, [], "e6ae", "M384 224l0 90.8c-10.1 15.2-16 33.4-16 53.1l0 96c0 5.5 .5 10.9 1.3 16.1L128 480c-35.3 0-64-28.7-64-64L64 96c0-35.3 28.7-64 64-64l320 0c35.3 0 64 28.7 64 64l0 49c-46.7 5.8-85.6 36.8-102.7 79L384 224zm-64 64l0-64-64 0 0 64 64 0zm-128 0l0-64-64 0 0 64 64 0zm64 64l0 64 64 0 0-64-64 0zm-128 0l0 64 64 0 0-64-64 0zm432-79.9c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 47.9 64 0 0-47.9zM416 368c0-20.9 13.4-38.7 32-45.3l0-50.6c0-44.2 35.8-80 80-80s80 35.8 80 80l0 50.6c18.6 6.6 32 24.4 32 45.3l0 96c0 26.5-21.5 48-48 48l-128 0c-26.5 0-48-21.5-48-48l0-96z"],
    "face-icicles": [512, 512, [], "e37c", "M320 503.9c-20.5 5.3-41.9 8.1-64 8.1-85.7 0-161.5-42.1-208-106.7L48 456c0 13.3-10.7 24-24 24S0 469.3 0 456L0 256C0 114.6 114.6 0 256 0S512 114.6 512 256l0 200c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-50.7c-24.7 34.3-57.7 62.3-96 81l0 33.7c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-16.1zm36-104.1c24.6-2 44-22.7 44-47.8s-19.4-45.8-44-47.8l0 95.7zM316 304l-40 0 0 96 40 0 0-96zm-80 96l0-96-40 0 0 96 40 0zM112 352c0 25.2 19.4 45.8 44 47.8l0-95.7c-24.6 2-44 22.7-44 47.8zm64-112a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm192-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "pen-fancy": [512, 512, [128395, 10002], "f5ac", "M373.5 27.1c15-17.2 36.7-27.1 59.6-27.1 43.6 0 79 35.4 79 79 0 22.8-9.9 44.6-27.1 59.6L283.7 313.8 273 303 209 239 198.2 228.3 373.5 27.1zM161.1 259C162 260 188 286 239 337l13.9 13.9-17.1 74.2c-3.9 17.1-16.9 30.7-33.8 35.4l-169.8 47.5 92.3-92.3c1.2 .1 2.3 .2 3.5 .2 17.7 0 32-14.3 32-32s-14.3-32-32-32-32 14.3-32 32c0 1.2 .1 2.4 .2 3.5L3.9 479.8 51.5 310c4.7-16.9 18.3-29.9 35.4-33.8L161.1 259z"],
    "user-chef": [448, 512, [], "e3d2", "M148 .3c-8.8-10-21.7-16.3-36-16.3-26.5 0-48 21.5-48 48 0 20.9 13.4 38.7 32 45.3L96 144c0 70.7 57.3 128 128 128s128-57.3 128-128l0-66.7c18.6-6.6 32-24.4 32-45.3 0-26.5-21.5-48-48-48-14.3 0-27.2 6.3-36 16.3-8.8-10-21.7-16.3-36-16.3-16.7 0-31.4 8.5-40 21.5-8.6-12.9-23.3-21.5-40-21.5-14.3 0-27.2 6.3-36 16.3zM304 128l0 16c0 44.2-35.8 80-80 80s-80-35.8-80-80l0-16 160 0zM96 439.6c0-36.4 20.5-69.6 53.1-85.9l39.2-19.6-54.8-27.4c-3.6-1.8-7.6-2.7-11.6-2.7-14.3 0-25.9 11.6-25.9 25.9l0 14.1-4.5 2.7C44.6 374.8 16 425.4 16 480 16 497.7 30.3 512 48 512l48 0 0-72.4zM128 512l272 0c17.7 0 32-14.3 32-32 0-54.6-28.6-105.2-75.5-133.3l-4.5-2.7 0-14.1c0-14.3-11.6-25.9-25.9-25.9-4 0-8 .9-11.6 2.7L163.4 382.3c-21.7 10.8-35.4 33-35.4 57.2l0 72.4zm152-80a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm-72-24a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"],
    "droplet-plus": [384, 512, [], "e800", "M192.2-16c10 0 19.3 4.5 25.2 12.5 36.4 49.4 166.6 232.3 166.6 323.5 0 106-86 192-192 192S0 426 0 320c0-91.2 130.2-274.1 166.6-323.5 5.9-8 15.2-12.5 25.2-12.5l.4 0zM192 224c-13.3 0-24 10.7-24 24l0 48-48 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l48 0 0 48 .1 2.5c1.2 12.1 11.5 21.5 23.9 21.5s22.6-9.4 23.9-21.5l.1-2.5 0-48 48 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0 0-48c0-13.3-10.7-24-24-24z"],
    "euro-sign": [448, 512, [8364, "eur", "euro"], "f153", "M73.3 192C100.8 99.5 186.5 32 288 32l64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-64 0c-65.6 0-122 39.5-146.7 96L272 192c13.3 0 24 10.7 24 24s-10.7 24-24 24l-143.2 0c-.5 5.3-.8 10.6-.8 16s.3 10.7 .8 16L272 272c13.3 0 24 10.7 24 24s-10.7 24-24 24l-130.7 0c24.7 56.5 81.1 96 146.7 96l64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-64 0c-101.5 0-187.2-67.5-214.7-160L40 320c-13.3 0-24-10.7-24-24s10.7-24 24-24l24.6 0c-.7-10.5-.7-21.5 0-32L40 240c-13.3 0-24-10.7-24-24s10.7-24 24-24l33.3 0z"],
    "house-circle-xmark": [640, 512, [], "e50b", "M496 544a144 144 0 1 1 0-288 144 144 0 1 1 0 288zM268.6 6.5c12.2-9.3 29.7-8.7 41.2 2l217.6 202c-10.2-1.7-20.7-2.6-31.3-2.6-78.6 0-146.2 47.2-175.9 114.8-5-1.8-10.5-2.8-16.1-2.8l-32 0c-26.5 0-48 21.5-48 48l0 96 90.9 0c6.1 17.3 14.6 33.4 25.2 48L144 512c-35.3 0-64-28.7-64-64l0-176-16 0c-13.2 0-25-8.1-29.8-20.3s-1.6-26.2 8-35.1l224-208 2.4-2zM555.3 340.7c-6.2-6.2-16.4-6.2-22.6 0l-36.7 36.7-36.7-36.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l36.7 36.7-36.7 36.7c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l36.7-36.7 36.7 36.7c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-36.7-36.7 36.7-36.7c6.2-6.2 6.2-16.4 0-22.6z"],
    "lira-sign": [384, 512, [8356], "f195", "M84.9 256l-28.4 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l11.6 0C53.2 124.7 116.8 42 207.6 42l8.2 0c33.6 0 66.2 11.3 92.5 32.2l16.1 12.7c13.9 11 16.2 31.1 5.2 45s-31.1 16.2-45 5.2l-16.1-12.7c-15-11.9-33.6-18.4-52.8-18.4l-8.2 0c-53.8 0-90.1 52.9-73.5 102l162.4 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-145.1 0c2.3 10.6 3.6 21.3 3.9 32l141.2 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L150 336c-4.8 18.6-12.6 36.5-23.6 52.9l-18.1 27.1 212.2 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-272 0c-11.8 0-22.6-6.5-28.2-16.9s-5-23 1.6-32.9l51.2-76.8c3.7-5.6 6.9-11.4 9.4-17.4l-26 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l34.8 0c-.5-10.8-2.6-21.6-6.4-32z"],
    "circle-peso": [512, 512, [], "e6ff", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM168 144c0-13.3 10.7-24 24-24l64 0c43.3 0 80.4 26.4 96 64l16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-8.3 0c.4 5.3 .4 10.7 0 16l8.3 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0c-15.7 37.6-52.8 64-96 64l-40 0 0 40c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-104-8 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l8 0 0-16-8 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l8 0 0-40zm88 24l-40 0 0 16 79.2 0c-10.1-9.9-23.9-16-39.2-16zm-40 64l95.4 0c.4-2.6 .6-5.3 .6-8s-.2-5.4-.6-8l-95.4 0 0 16zm0 32l0 16 40 0c15.3 0 29.1-6.1 39.2-16L216 264z"],
    "yen-sign": [384, 512, [165, "cny", "jpy", "rmb", "yen"], "f157", "M74.9 46.7c-9.6-14.9-29.4-19.2-44.2-9.6S11.5 66.4 21.1 81.3L143.7 272 88 272c-13.3 0-24 10.7-24 24s10.7 24 24 24l72 0 0 32-72 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l72 0 0 48c0 17.7 14.3 32 32 32s32-14.3 32-32l0-48 72 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-72 0 0-32 72 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-55.7 0 122.6-190.7c9.6-14.9 5.3-34.7-9.6-44.2s-34.7-5.3-44.2 9.6L192 228.8 74.9 46.7z"],
    "box-open": [640, 512, [], "f49e", "M560.3 237.2c10.4 11.8 28.3 14.4 41.8 5.5 14.7-9.8 18.7-29.7 8.9-44.4l-48-72c-2.8-4.2-6.6-7.7-11.1-10.2L351.4 4.7c-19.3-10.7-42.8-10.7-62.2 0L88.8 116c-5.4 3-9.7 7.4-12.6 12.8L27.7 218.7c-12.6 23.4-3.8 52.5 19.6 65.1l33 17.7 0 53.3c0 23 12.4 44.3 32.4 55.7l176 99.7c19.6 11.1 43.5 11.1 63.1 0l176-99.7c20.1-11.4 32.4-32.6 32.4-55.7l0-117.5zm-240-9.8L170.2 144 320.3 60.6 470.4 144 320.3 227.4zm-41.5 50.2l-21.3 46.2-165.8-88.8 25.4-47.2 161.7 89.8z"],
    "golf-flag-hole": [512, 512, [], "e3ac", "M139.4-28.4c7.1-4.4 15.9-4.8 23.3-1.1l208 104c8.1 4.1 13.3 12.4 13.3 21.5 0 8-3.9 15.3-10.4 19.8l-2.9 1.7-194.7 97.3 0 78.8c25.2-3.6 52.1-5.6 80-5.6 141.4 0 256 50.1 256 112S397.4 512 256 512 0 461.9 0 400c0-41.5 51.5-77.6 128-97l0-95c0-1.4 .1-2.7 .3-4-.2-1.3-.3-2.6-.3-4l0-208 .2-3.1c.9-7.1 5-13.5 11.2-17.3zM224 352c-35.3 0-64 14.3-64 32s28.7 32 64 32 64-14.3 64-32-28.7-32-64-32z"],
    "truck-field": [640, 512, [], "e58d", "M32 96c0-35.3 28.7-64 64-64l224 0c23.7 0 44.4 12.9 55.4 32l40.4 0c32.4 0 61.6 19.6 74 49.5l43.8 106.3 1.7 4.2 24.7 0c26.5 0 48 21.5 48 48l0 64c0 26.5-21.5 48-48 48l-.4 0c.2 2.6 .4 5.3 .4 8 0 48.6-39.4 88-88 88s-88-39.4-88-88c0-2.7 .1-5.4 .4-8l-144.7 0c.2 2.6 .4 5.3 .4 8 0 48.6-39.4 88-88 88s-88-39.4-88-88c0-3.6 .2-7.1 .6-10.5-19-6.4-32.6-24.4-32.6-45.5l0-48c-17.7 0-32-14.3-32-32l0-96c0-17.7 14.3-32 32-32l0-32zm352 32l0 96 82.1 0-35.4-86.1c-2.5-6-8.3-9.9-14.8-9.9L384 128zM192 392a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zm280 40a40 40 0 1 0 0-80 40 40 0 1 0 0 80z"],
    "u-turn-left-up": [576, 512, [], "e7f2", "M304 512C189.1 512 96 418.9 96 304l0-128-48 0c-12.9 0-24.6-7.8-29.6-19.7s-2.2-25.7 6.9-34.9l112-112 2.4-2.2c12.6-10.2 31.1-9.5 42.8 2.2l112 112c9.2 9.2 11.9 22.9 6.9 34.9S284.9 176 272 176l-48 0 0 128c0 44.2 35.8 80 80 80s80-35.8 80-80l0-208c0-17.7 14.3-32 32-32l64 0c17.7 0 32 14.3 32 32l0 208c0 114.9-93.1 208-208 208z"],
    "circle-mill": [512, 512, [], "e702", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM326.5 97.4c8.1 3.6 11.7 13 8.1 21.1L315.8 161c34.2 5.6 60.2 35.3 60.2 71l0 96c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-96c0-13.3-10.7-24-24-24-3.6 0-7.1 .8-10.2 2.2L280 241.4 280 328c0 13.3-10.7 24-24 24-8.5 0-16-4.4-20.2-11.1l-29.1 65.6c-3.6 8.1-13 11.7-21.1 8.1s-11.7-13-8.1-21.1l54.6-122.9 0-38.6 0-.4c-.2-13.1-10.9-23.6-24-23.6-13.3 0-24 10.7-24 24l0 96c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-80 0 0 0-64c0-13.3 10.7-24 24-24 6.6 0 12.6 2.7 17 7 9.4-4.5 19.9-7 31-7 18.4 0 35.3 6.9 48 18.3 6.7-6 14.6-10.8 23.2-13.9l26.2-58.9c3.6-8.1 13-11.7 21.1-8.1z"],
    "whistle": [640, 512, [], "f460", "M400 64c8.8 0 16 7.2 16 16 0 17.7 14.3 32 32 32s32-14.3 32-32c0-8.8 7.2-16 16-16l112 0c17.7 0 32 14.3 32 32l0 70.3c0 15-10.4 28-25.1 31.2L413.8 242.2c1.4 9.7 2.2 19.6 2.2 29.8 0 114.9-93.1 208-208 208S0 386.9 0 272 93.1 64 208 64l192 0zM208 192a80 80 0 1 0 0 160 80 80 0 1 0 0-160z"],
    "kerning": [512, 512, [], "f86f", "M16.8 3.9C1.2 12.3-4.5 31.7 3.9 47.2l104 192c5.6 10.3 16.4 16.8 28.1 16.8s22.5-6.4 28.1-16.8l104-192c8.4-15.5 2.6-35-12.9-43.4s-35-2.6-43.4 12.9L136 156.8 60.1 16.8C51.7 1.2 32.3-4.6 16.8 3.9zM317.1 208l117.9 0 16.9 31.2c8.4 15.5 27.8 21.3 43.4 12.9s21.3-27.8 12.9-43.4l-104-192C398.5 6.4 387.7 0 376 0s-22.5 6.4-28.1 16.8l-104 192c-8.4 15.5-2.6 35 12.9 43.4s35 2.6 43.4-12.9L317.1 208zm34.7-64l24.3-44.8 24.3 44.8-48.5 0zM182.6 374.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-64 64c-12.5 12.5-12.5 32.8 0 45.3l64 64c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-9.4-9.4 165.5 0-9.4 9.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l64-64c12.5-12.5 12.5-32.8 0-45.3l-64-64c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l9.4 9.4-165.5 0 9.4-9.4z"],
    "location-pin-lock": [512, 512, [], "e51f", "M0 188.6C0 84.4 86 0 192 0 294.1 0 377.6 78.3 383.6 177 320.7 185.1 272 238.8 272 304l0 24.4c-19.6 17.6-32 43.1-32 71.5l0 75.7c-9.9 11.6-18.9 21.7-26.4 29.8-11.8 12.8-31.5 12.8-43.3 0-50.2-54.5-170.4-197.5-170.4-316.8zM192 256a64 64 0 1 0 0-128 64 64 0 1 0 0 128zm240 48.1c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 47.9 64 0 0-47.9zM288 400c0-20.9 13.4-38.7 32-45.3l0-50.6c0-44.2 35.8-80 80-80s80 35.8 80 80l0 50.6c18.6 6.6 32 24.4 32 45.3l0 96c0 26.5-21.5 48-48 48l-128 0c-26.5 0-48-21.5-48-48l0-96z"],
    "waves-sine": [576, 512, [], "e65d", "M0 416c0 17.7 14.3 32 32 32 39.4 0 75.8-18.3 99.4-48.2l-31.7-79.2-9.6 24.1C80.6 368.4 57.6 384 32 384 14.3 384 0 398.3 0 416zM160 169.8l-10.5-26.3C130.3 95.5 83.7 64 32 64 14.3 64 0 78.3 0 96s14.3 32 32 32c25.6 0 48.6 15.6 58.1 39.3l80.5 201.2c19.2 48 65.7 79.5 117.5 79.5 39.4 0 75.8-18.3 99.4-48.3l-31.7-79.2-9.7 24.2C336.6 368.4 313.6 384 288 384s-48.6-15.6-58.1-39.3L194.5 256 230 167.3c9.5-23.7 32.5-39.3 58.1-39.3s48.6 15.6 58.1 39.3l80.5 201.2c19.2 48 65.7 79.5 117.5 79.5 17.7 0 32-14.3 32-32s-14.3-32-32-32c-25.6 0-48.6-15.6-58.1-39.3l-35.5-88.7 35.5-88.7c9.5-23.7 32.5-39.3 58.1-39.3 17.7 0 32-14.3 32-32s-14.3-32-32-32c-51.7 0-98.3 31.5-117.5 79.5l-10.5 26.3-10.5-26.3C386.3 95.5 339.7 64 288 64s-98.3 31.5-117.5 79.5L160 169.8z"],
    "person-praying": [384, 512, [128720, "pray"], "f683", "M320 64a64 64 0 1 0 -128 0 64 64 0 1 0 128 0zM200.7 264l22.9 31.5c6.5 8.9 16.3 14.7 27.2 16.1s21.9-1.7 30.4-8.7l88-72c17.1-14 19.6-39.2 5.6-56.3s-39.2-19.6-56.3-5.6l-55.2 45.2-26.2-36c-15.6-21.5-40.6-34.2-67.2-34.2-30.9 0-59.2 17.1-73.6 44.4L47.8 280.9c-20.2 38.5-9.4 85.9 25.6 111.8L126.6 432 40 432c-22.1 0-40 17.9-40 40s17.9 40 40 40l208 0c17.3 0 32.6-11.1 38-27.5s-.3-34.4-14.2-44.7l-116.1-85.8 45-90z"],
    "location-plus": [384, 512, ["map-marker-plus"], "f60a", "M0 188.6C0 84.4 86 0 192 0S384 84.4 384 188.6c0 119.3-120.2 262.3-170.4 316.8-11.8 12.8-31.5 12.8-43.3 0-50.2-54.5-170.4-197.5-170.4-316.8zM192 96c-13.3 0-24 10.7-24 24l0 48-48 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l48 0 0 48c0 13.3 10.7 24 24 24s24-10.7 24-24l0-48 48 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0 0-48c0-13.3-10.7-24-24-24z"],
    "diamond-half-stroke": [512, 512, [], "e5b8", "M256 445.5L256 66.5 445.5 256 256 445.5zM215 17L17 215C6.1 225.9 0 240.6 0 256s6.1 30.1 17 41L215 495c10.9 10.9 25.6 17 41 17s30.1-6.1 41-17L495 297c10.9-10.9 17-25.6 17-41s-6.1-30.1-17-41L297 17C286.1 6.1 271.4 0 256 0s-30.1 6.1-41 17z"],
    "clipboard-list": [384, 512, [], "f46d", "M311.4 32l8.6 0c35.3 0 64 28.7 64 64l0 352c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l8.6 0C83.6 12.9 104.3 0 128 0L256 0c23.7 0 44.4 12.9 55.4 32zM248 112c13.3 0 24-10.7 24-24s-10.7-24-24-24L136 64c-13.3 0-24 10.7-24 24s10.7 24 24 24l112 0zM128 256a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm32 0c0 13.3 10.7 24 24 24l112 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-112 0c-13.3 0-24 10.7-24 24zm0 128c0 13.3 10.7 24 24 24l112 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-112 0c-13.3 0-24 10.7-24 24zM96 416a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "objects-align-center-vertical": [576, 512, [], "e3bd", "M96 80c0-26.5 21.5-48 48-48l64 0c26.5 0 48 21.5 48 48l0 144 64 0 0-80c0-26.5 21.5-48 48-48l64 0c26.5 0 48 21.5 48 48l0 80 64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-64 0 0 80c0 26.5-21.5 48-48 48l-64 0c-26.5 0-48-21.5-48-48l0-80-64 0 0 144c0 26.5-21.5 48-48 48l-64 0c-26.5 0-48-21.5-48-48l0-144-64 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l64 0 0-144z"],
    "candy-bar": [640, 512, [127851, "chocolate-bar"], "e3e8", "M192 416l128 0 0-136-128 0 0 136zm176 0l208 0c35.3 0 64-28.7 64-64l0-192c0-35.3-28.7-64-64-64l-208 0 0 320zM320 96l-128 0 0 136 128 0 0-136zM144 96l-32 0c0 61.9-50.1 112-112 112l0 24 144 0 0-136zM0 280l0 72c0 35.3 28.7 64 64 64l80 0 0-136-144 0z"],
    "booth-curtain": [448, 512, [], "f734", "M64 0C28.7 0 0 28.7 0 64L0 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-416 32 0 0 336c0 26.5 21.5 48 48 48s48-21.5 48-48c0 26.5 21.5 48 48 48s48-21.5 48-48c0 26.5 21.5 48 48 48s48-21.5 48-48l0 80c0 17.7 14.3 32 32 32s32-14.3 32-32l0-416c0-35.3-28.7-64-64-64L64 0z"],
    "sack-dollar": [512, 512, [128176], "f81d", "M328 112l-144 0-37.3-74.5c-1.8-3.6-2.7-7.6-2.7-11.6 0-14.3 11.6-25.9 25.9-25.9L342.1 0c14.3 0 25.9 11.6 25.9 25.9 0 4-.9 8-2.7 11.6L328 112zM169.6 160l172.8 0 48.7 40.6C457.6 256 496 338 496 424.5 496 472.8 456.8 512 408.5 512l-305.1 0C55.2 512 16 472.8 16 424.5 16 338 54.4 256 120.9 200.6L169.6 160zM260 224c-11 0-20 9-20 20l0 4c-28.8 .3-52 23.7-52 52.5 0 25.7 18.5 47.6 43.9 51.8l41.7 7c6 1 10.4 6.2 10.4 12.3 0 6.9-5.6 12.5-12.5 12.5L216 384c-11 0-20 9-20 20s9 20 20 20l24 0 0 4c0 11 9 20 20 20s20-9 20-20l0-4.7c25-4.1 44-25.7 44-51.8 0-25.7-18.5-47.6-43.9-51.8l-41.7-7c-6-1-10.4-6.2-10.4-12.3 0-6.9 5.6-12.5 12.5-12.5l47.5 0c11 0 20-9 20-20s-9-20-20-20l-8 0 0-4c0-11-9-20-20-20z"],
    "mountain-sun": [576, 512, [], "e52f", "M256.5 0c14.7 0 28.2 8.1 35.2 21l216 400c6.7 12.4 6.4 27.4-.8 39.5-7.2 12.1-20.3 19.5-34.3 19.5l-432 0c-14.1 0-27.1-7.4-34.3-19.5s-7.5-27.1-.8-39.5l216-400 2.9-4.6C231.7 6.2 243.6 0 256.5 0zM170.4 249.9l26.8 26.8c6.2 6.2 16.4 6.2 22.6 0l43.3-43.3c6-6 14.1-9.4 22.6-9.4l42.8 0-72.1-133.5-86.1 159.4zM496.5 160a80 80 0 1 1 0-160 80 80 0 1 1 0 160z"],
    "hockey-mask": [448, 512, [], "f6ee", "M0 240C0 111 64 0 224 0S448 111 448 240c0 192-48 272-224 272S0 432 0 240zM160 104a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm88 24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM176 344a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm0 64a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm24 40a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm72-104a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM312 80a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM272 408a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm24 40a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM128 272c35.3 0 64-28.7 64-64 0-17.7-14.3-32-32-32l-64 0c-17.7 0-32 14.3-32 32 0 35.3 28.7 64 64 64zm256-64c0-17.7-14.3-32-32-32l-64 0c-17.7 0-32 14.3-32 32 0 35.3 28.7 64 64 64s64-28.7 64-64z"],
    "location-smile": [384, 512, ["map-marker-smile"], "f60d", "M0 188.6C0 84.4 86 0 192 0S384 84.4 384 188.6c0 119.3-120.2 262.3-170.4 316.8-11.8 12.8-31.5 12.8-43.3 0-50.2-54.5-170.4-197.5-170.4-316.8zM128 192a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm160-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM128.6 244.9c-6.1-9.2-18.5-11.7-27.7-5.5s-11.7 18.5-5.5 27.7C106.9 284.4 140.9 316 192 316s85.1-31.6 96.6-48.9c6.1-9.2 3.6-21.6-5.5-27.7s-21.6-3.6-27.7 5.5c-6.2 9.4-29.1 31.1-63.4 31.1s-57.1-21.7-63.4-31.1z"],
    "tally-3": [448, 512, [], "e296", "M32 32c17.7 0 32 14.3 32 32l0 384c0 17.7-14.3 32-32 32S0 465.7 0 448L0 64C0 46.3 14.3 32 32 32zm128 0c17.7 0 32 14.3 32 32l0 384c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-384c0-17.7 14.3-32 32-32zM320 64l0 384c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-384c0-17.7 14.3-32 32-32s32 14.3 32 32z"],
    "arrow-down-from-line": [384, 512, [8615, "arrow-from-top"], "f345", "M32 64C14.3 64 0 49.7 0 32S14.3 0 32 0L352 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 64zM342.6 374.6l-128 128c-12.5 12.5-32.8 12.5-45.3 0l-128-128c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0L160 402.7 160 160c0-17.7 14.3-32 32-32s32 14.3 32 32l0 242.7 73.4-73.4c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3z"],
    "chart-pyramid": [512, 512, [], "e0e6", "M291.2 21C284.2 8.1 270.7 0 256 0s-28.2 8.1-35.2 21l-75.1 139 220.5 0-75.1-139zM59.3 320l393.3 0-60.5-112-272.4 0-60.5 112zM33.4 368L4.8 421c-6.7 12.4-6.4 27.4 .8 39.5S25.9 480 40 480l432 0c14.1 0 27.1-7.4 34.4-19.5s7.5-27.1 .8-39.5l-28.6-53-445.2 0z"],
    "goal-net": [576, 512, [], "e3ab", "M480 32c53 0 96 43 96 96l0 320c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-320c0-17.7-14.3-32-32-32L96 96c-17.7 0-32 14.3-32 32l0 320c0 17.7-14.3 32-32 32S0 465.7 0 448L0 128C0 75 43 32 96 32l384 0zm-72 96c13.3 0 24 10.7 24 24l0 24 24 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-24 0 0 48 24 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-24 0 0 48 24 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-24 0 0 40c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-40-72 0 0 40c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-40-72 0 0 40c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-40-24 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l24 0 0-48-24 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l24 0 0-48-24 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l24 0 0-24 .1-2.5c1.2-12.1 11.5-21.5 23.9-21.5s22.6 9.4 23.9 21.5l.1 2.5 0 24 72 0 0-24c0-13.3 10.7-24 24-24s24 10.7 24 24l0 24 72 0 0-24c0-13.3 10.7-24 24-24zM192 368l72 0 0-48-72 0 0 48zm120 0l72 0 0-48-72 0 0 48zM192 272l72 0 0-48-72 0 0 48zm120 0l72 0 0-48-72 0 0 48z"],
    "link-horizontal-slash": [576, 512, ["chain-horizontal-slash"], "e1cc", "M41-24.9c-9.4-9.4-24.6-9.4-33.9 0S-2.3-.3 7 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-55.9-55.9c38.3-29.2 62.9-75.3 62.9-127.2 0-59.3-32.3-111.1-80.3-138.8 .2 3.6 .3 7.1 .3 10.8 0 21.9-3.4 42.9-9.6 62.7 15.9 17.1 25.6 40.1 25.6 65.3 0 34.2-17.9 64.3-44.9 81.3l-82.1-82.1C423.3 290 448 243.9 448 192 448 103.6 376.4 32 288 32L160 32c-18.6 0-36.5 3.2-53.1 9L41-24.9zM161.8 96L288 96c53 0 96 43 96 96 0 34.2-17.9 64.3-44.9 81.3L289.8 224 304 224c17.7 0 32-14.3 32-32s-14.3-32-32-32l-16 0c-18.6 0-36.5 3.2-53.1 9l-73-73zM410.2 480l-64-64-58.2 0c-53 0-96-43-96-96 0-16.8 4.3-32.6 11.9-46.3l-46.3-46.3c-18.6 26.1-29.5 58.1-29.5 92.6 0 88.4 71.6 160 160 160l122.2 0zM29.5 99.4c-18.6 26.1-29.5 58.1-29.5 92.6 0 59.3 32.3 111.1 80.3 138.8-.2-3.6-.3-7.1-.3-10.8 0-21.9 3.4-42.9 9.6-62.7-15.9-17.1-25.6-40.1-25.6-65.3 0-16.8 4.3-32.6 11.9-46.3L29.5 99.4z"],
    "carpool": [512, 512, ["car-people"], "e69c", "M107.1 101.8L80.6 224 114.7 224c6.6-18.6 24.4-32 45.3-32l32 0c20.9 0 38.7 13.4 45.3 32l37.5 0c6.6-18.6 24.4-32 45.3-32l32 0c20.9 0 38.7 13.4 45.3 32l34.2 0-26.6-122.2C400.1 79.7 380.6 64 358 64L154 64c-22.6 0-42.1 15.7-46.9 37.8zM29.2 234.3l3.3-15.4 27.7-127.3C69.8 47.5 108.9 16 154 16L358 16c45.2 0 84.2 31.5 93.8 75.6l27.7 127.3 3.3 15.4C500.4 245.7 512 265.5 512 288l0 160c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-32-320 0 0 32c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32L0 288c0-22.5 11.6-42.3 29.2-53.7zM136 128a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zM336 88a40 40 0 1 1 0 80 40 40 0 1 1 0-80zM128 320a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm288 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "arrow-up-wide-short": [576, 512, ["sort-amount-up"], "f161", "M150.6 41.4c-12.5-12.5-32.8-12.5-45.3 0l-96 96c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L96 141.3 96 448c0 17.7 14.3 32 32 32s32-14.3 32-32l0-306.7 41.4 41.4c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-96-96zM320 480l32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0c-17.7 0-32 14.3-32 32s14.3 32 32 32zm0-128l96 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-96 0c-17.7 0-32 14.3-32 32s14.3 32 32 32zm0-128l160 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-160 0c-17.7 0-32 14.3-32 32s14.3 32 32 32zm0-128l224 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L320 32c-17.7 0-32 14.3-32 32s14.3 32 32 32z"],
    "arrow-up-from-dotted-line": [384, 512, [], "e09b", "M169.4 9.4c12.5-12.5 32.8-12.5 45.3 0l128 128c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L224 109.3 224 352c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-242.7-73.4 73.4c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l128-128zM0 480c0-17.7 14.3-32 32-32s32 14.3 32 32-14.3 32-32 32-32-14.3-32-32zm138.7-32c17.7 0 32 14.3 32 32s-14.3 32-32 32-32-14.3-32-32 14.3-32 32-32zm74.7 32c0-17.7 14.3-32 32-32s32 14.3 32 32-14.3 32-32 32-32-14.3-32-32zM352 448c17.7 0 32 14.3 32 32s-14.3 32-32 32-32-14.3-32-32 14.3-32 32-32z"],
    "u-turn-right-up": [576, 512, [], "e7f4", "M272 512c114.9 0 208-93.1 208-208l0-128 48 0c12.9 0 24.6-7.8 29.6-19.7s2.2-25.7-6.9-34.9l-112-112-2.4-2.2c-12.6-10.2-31.1-9.5-42.8 2.2l-112 112c-9.2 9.2-11.9 22.9-6.9 34.9S291.1 176 304 176l48 0 0 128c0 44.2-35.8 80-80 80s-80-35.8-80-80l0-208c0-17.7-14.3-32-32-32L96 64C78.3 64 64 78.3 64 96l0 208c0 114.9 93.1 208 208 208z"],
    "hexagon-image": [576, 512, [], "e504", "M33.5 291.8c-12.7-22.2-12.7-49.4 0-71.5L129.7 52.2C142.5 29.8 166.4 16 192.2 16l191.6 0c25.8 0 49.7 13.8 62.5 36.2l96.2 168.1c12.7 22.2 12.7 49.4 0 71.5L446.3 459.9c-12.8 22.4-36.7 36.2-62.5 36.2l-191.6 0c-25.8 0-49.7-13.8-62.5-36.2L33.5 291.8zm330.6-57.7c-4.8-7.9-13.5-12.8-22.8-12.8s-17.9 4.8-22.8 12.8l-68.2 111.7-29.4-42c-5-7.1-13.1-11.4-21.8-11.4s-16.9 4.2-21.8 11.4l-34.7 49.6 42.7 74.6c1.4 2.5 4.1 4 6.9 4l191.6 0c2.9 0 5.5-1.5 6.9-4l44.4-77.6-71.1-116.4zM272 160a48 48 0 1 0 -96 0 48 48 0 1 0 96 0z"],
    "users-line": [576, 512, [], "e592", "M224 128a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zM176 336c0-61.9 50.1-112 112-112s112 50.1 112 112l0 8c0 13.3-10.7 24-24 24l-176 0c-13.3 0-24-10.7-24-24l0-8zM392 144a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm27.2 100.4c9.1-2.9 18.8-4.4 28.8-4.4 53 0 96 43 96 96l0 10.7c0 11.8-9.6 21.3-21.3 21.3l-78.8 0c2.7-7.5 4.1-15.6 4.1-24l0-8c0-34.1-10.6-65.7-28.8-91.6zm-262.4 0c-18.2 26-28.8 57.5-28.8 91.6l0 8c0 8.4 1.4 16.5 4.1 24l-78.8 0C41.6 368 32 358.4 32 346.7L32 336c0-53 43-96 96-96 10 0 19.7 1.5 28.8 4.4zM72 144a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zM0 440c0-13.3 10.7-24 24-24l528 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 464c-13.3 0-24-10.7-24-24z"],
    "arrow-up-right-and-arrow-down-left-from-center": [512, 512, [], "e0a0", "M352 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l50.7 0-105.4 105.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L448 109.3 448 160c0 17.7 14.3 32 32 32s32-14.3 32-32l0-128c0-17.7-14.3-32-32-32L352 0zM214.6 297.4c-12.5-12.5-32.8-12.5-45.3 0L64 402.7 64 352c0-17.7-14.3-32-32-32S0 334.3 0 352L0 480c0 17.7 14.3 32 32 32l128 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-50.7 0 105.4-105.4c12.5-12.5 12.5-32.8 0-45.3z"],
    "camera-viewfinder": [512, 512, ["screenshot"], "e0da", "M64 0l72 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L64 48c-8.8 0-16 7.2-16 16l0 72c0 13.3-10.7 24-24 24S0 149.3 0 136L0 64C0 28.7 28.7 0 64 0zM376 0l72 0c35.3 0 64 28.7 64 64l0 72c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-72c0-8.8-7.2-16-16-16l-72 0c-13.3 0-24-10.7-24-24S362.7 0 376 0zM48 376l0 72c0 8.8 7.2 16 16 16l72 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-72 0c-35.3 0-64-28.7-64-64l0-72c0-13.3 10.7-24 24-24s24 10.7 24 24zm464 0l0 72c0 35.3-28.7 64-64 64l-72 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l72 0c8.8 0 16-7.2 16-16l0-72c0-13.3 10.7-24 24-24s24 10.7 24 24zM180 128l6.2-16.4c3.5-9.4 12.5-15.6 22.5-15.6l94.7 0c10 0 19 6.2 22.5 15.6l6.2 16.4 36 0c26.5 0 48 21.5 48 48l0 160c0 26.5-21.5 48-48 48l-224 0c-26.5 0-48-21.5-48-48l0-160c0-26.5 21.5-48 48-48l36 0zM320 256a64 64 0 1 0 -128 0 64 64 0 1 0 128 0z"],
    "star-of-david": [512, 512, [10017], "f69a", "M415.9 311.9l-27.8 48.1 55.7 0-27.8-48.1zM383.6 256l-60.2-104-134.8 0-60.2 104 60.2 104 134.8 0 60.2-104zm64.7 0l58.4 100.9c3.5 6 5.3 12.8 5.3 19.7 0 21.7-17.6 39.4-39.4 39.4l-117 0-61.3 105.8C286.5 535.6 271.8 544 256 544s-30.5-8.4-38.4-22.2l-61.3-105.8-117 0c-21.7 0-39.4-17.6-39.4-39.4 0-6.9 1.8-13.7 5.3-19.7L63.7 256 5.3 155.1C1.8 149.1 0 142.3 0 135.4 0 113.6 17.6 96 39.4 96l117 0 61.3-105.8C225.5-23.6 240.2-32 256-32s30.5 8.4 38.4 22.2l61.3 105.8 117 0c21.7 0 39.4 17.6 39.4 39.4 0 6.9-1.8 13.7-5.3 19.7L448.3 256zM388.1 152l27.8 48.1 27.8-48.1-55.7 0zM291 96l-35-60.4-35 60.4 70 0zM123.9 152l-55.7 0 27.8 48.1 27.8-48.1zM96.1 311.9l-27.8 48.1 55.7 0-27.8-48.1zM221 416l35 60.4 35-60.4-70 0z"],
    "notes-medical": [512, 512, [], "f481", "M96 352c0 35.3 28.7 64 64 64l181.5 0c17 0 33.3-6.7 45.3-18.7L493.3 290.7c12-12 18.7-28.3 18.7-45.3L512 64c0-35.3-28.7-64-64-64L160 0C124.7 0 96 28.7 96 64l0 288zM288 112l32 0c8.8 0 16 7.2 16 16l0 48 48 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-48 0 0 48c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-48-48 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l48 0 0-48c0-8.8 7.2-16 16-16zM48 120c0-13.3-10.7-24-24-24S0 106.7 0 120L0 448c0 35.3 28.7 64 64 64l264 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L64 464c-8.8 0-16-7.2-16-16l0-328z"],
    "austral-sign": [448, 512, [], "e0a9", "M266.5 240l-85 0 42.5-106.4 42.5 106.4zm68.9 0L262.9 58.3C256.5 42.4 241.1 32 224 32s-32.5 10.4-38.9 26.3L112.6 240 32 240c-13.3 0-24 10.7-24 24s10.7 24 24 24l61.4 0-19.2 48-42.3 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l23.1 0-20.8 52.1c-6.6 16.4 1.4 35 17.9 41.6s35-1.4 41.6-17.9l30.3-75.9 200 0 30.3 75.9c6.6 16.4 25.2 24.4 41.6 17.9s24.4-25.2 17.9-41.6L392.9 384 416 384c13.3 0 24-10.7 24-24s-10.7-24-24-24l-42.3 0-19.2-48 61.4 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80.6 0zm-49.7 48l19.2 48-161.6 0 19.2-48 123.3 0z"],
    "file-chart-pie": [384, 512, [], "f65a", "M0 64C0 28.7 28.7 0 64 0L213.5 0c17 0 33.3 6.7 45.3 18.7L365.3 125.3c12 12 18.7 28.3 18.7 45.3L384 448c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zm208-5.5l0 93.5c0 13.3 10.7 24 24 24L325.5 176 208 58.5zM80 336c0 61.9 50.1 112 112 112 53.6 0 98.4-37.7 109.4-88L192 360c-13.3 0-24-10.7-24-24l0-109.4c-50.3 11-88 55.8-88 109.4zm136-24l85.4 0c-9.3-42.6-42.8-76.1-85.4-85.4l0 85.4z"],
    "face-sad-sweat": [640, 512, [], "e38a", "M320 512c141.4 0 256-114.6 256-256S461.4 0 320 0c-136 0-247.2 106.1-255.5 240 12.8 .1 25.6 4.6 36 13.5l.3 .3c14.4 12.5 32.3 29.7 46.8 50.2 14.3 20.1 28.4 47.7 28.4 80.1 0 25.4-8 48.6-21.7 67.2 44.7 38 102.5 60.8 165.7 60.8zm-58.5-98c-7.7 10.8-22.7 13.2-33.5 5.5s-13.2-22.7-5.5-33.5c21.7-30.2 57.3-50 97.5-50s75.7 19.8 97.5 50c7.7 10.8 5.3 25.8-5.5 33.5s-25.8 5.3-33.5-5.5c-13.1-18.2-34.4-30-58.5-30s-45.4 11.8-58.5 30zM432 272a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM240 240a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm22.1-94.1c7.8 7.8 7.8 20.5 0 28.3l-7.4 7.4c-24.2 24.2-55.3 40.2-89 45.8l-2.5 .4c-10.9 1.8-21.2-5.5-23-16.4s5.5-21.2 16.4-23l2.5-.4c25.5-4.2 49-16.4 67.3-34.6l7.4-7.4c7.8-7.8 20.5-7.8 28.3 0zm115.7 28.3c-7.8-7.8-7.8-20.5 0-28.3s20.5-7.8 28.3 0l7.4 7.4c18.3 18.3 41.8 30.4 67.3 34.6l2.5 .4c10.9 1.8 18.3 12.1 16.4 23s-12.1 18.3-23 16.4l-2.5-.4c-33.7-5.6-64.8-21.6-89-45.8l-7.4-7.4zM128 384c0-36.9-32.5-71.1-58.8-94.1-3-2.6-7.4-2.6-10.4 0-26.3 23-58.8 57.2-58.8 94.1 0 36.4 27.6 64 64 64s64-27.6 64-64z"],
    "clipboard-user": [384, 512, [], "f7f3", "M311.4 32l8.6 0c35.3 0 64 28.7 64 64l0 352c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l8.6 0C83.6 12.9 104.3 0 128 0L256 0c23.7 0 44.4 12.9 55.4 32zM248 112c13.3 0 24-10.7 24-24s-10.7-24-24-24L136 64c-13.3 0-24 10.7-24 24s10.7 24 24 24l112 0zM192 344a56 56 0 1 0 0-112 56 56 0 1 0 0 112zM98.3 413c-12.9 15.6 2.2 35 22.4 35l142.5 0c20.2 0 35.3-19.4 22.4-35-14.7-17.7-36.9-29-61.7-29l-64 0c-24.8 0-47 11.3-61.7 29z"],
    "comment-arrow-down": [512, 512, [], "e143", "M256 480c141.4 0 256-107.5 256-240S397.4 0 256 0 0 107.5 0 240c0 54.3 19.2 104.3 51.6 144.5L2.8 476.8c-4.8 9-3.3 20 3.6 27.5s17.8 9.8 27.1 5.8l118.4-50.7C183.7 472.6 218.9 480 256 480zM239 337l-72-72c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l31 31 0-102.1c0-13.3 10.7-24 24-24s24 10.7 24 24l0 102.1 31-31c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-72 72c-9.4 9.4-24.6 9.4-33.9 0z"],
    "file-image": [384, 512, [128443], "f1c5", "M0 64C0 28.7 28.7 0 64 0L213.5 0c17 0 33.3 6.7 45.3 18.7L365.3 125.3c12 12 18.7 28.3 18.7 45.3L384 448c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zm208-5.5l0 93.5c0 13.3 10.7 24 24 24L325.5 176 208 58.5zM128 256a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM92.6 448l198.8 0c15.8 0 28.6-12.8 28.6-28.6 0-7.3-2.8-14.4-7.9-19.7L215.3 297.9c-6-6.3-14.4-9.9-23.2-9.9l-.3 0c-8.8 0-17.1 3.6-23.2 9.9L71.9 399.7C66.8 405 64 412.1 64 419.4 64 435.2 76.8 448 92.6 448z"],
    "file-mov": [576, 512, [], "e647", "M96 0C60.7 0 32 28.7 32 64l0 384c0 35.3 28.7 64 64 64l48 0 0-112c0-35.3 28.7-64 64-64l208 0 0-165.5c0-17-6.7-33.3-18.7-45.3L290.7 18.7C278.7 6.7 262.5 0 245.5 0L96 0zM357.5 176L264 176c-13.3 0-24-10.7-24-24L240 58.5 357.5 176zM225.1 389.7c-4.6-7.7-13.8-11.4-22.5-9S188 391 188 400l0 128c0 11 9 20 20 20s20-9 20-20l0-55.8 10.9 18.1c3.6 6 10.1 9.7 17.1 9.7s13.5-3.7 17.1-9.7l10.9-18.1 0 55.8c0 11 9 20 20 20s20-9 20-20l0-128c0-9-6-16.9-14.7-19.3s-17.9 1.3-22.5 9l-30.9 51.4-30.9-51.4zM392 380c-24.3 0-44 19.7-44 44l0 80c0 24.3 19.7 44 44 44l16 0c24.3 0 44-19.7 44-44l0-80c0-24.3-19.7-44-44-44l-16 0zm-4 44c0-2.2 1.8-4 4-4l16 0c2.2 0 4 1.8 4 4l0 80c0 2.2-1.8 4-4 4l-16 0c-2.2 0-4-1.8-4-4l0-80zm108-44c-11 0-20 9-20 20l0 31.6c0 35.5 10.5 70.3 30.2 99.8l5.1 7.7c3.7 5.6 10 8.9 16.6 8.9s12.9-3.3 16.6-8.9l5.1-7.7c19.7-29.6 30.2-64.3 30.2-99.8l0-31.6c0-11-9-20-20-20s-20 9-20 20l0 31.6c0 19.6-4.1 38.9-12 56.7-7.9-17.8-12-37.1-12-56.7l0-31.6c0-11-9-20-20-20z"],
    "pie": [576, 512, [129383], "f705", "M525.8 225.1c3.1 7.8 8.8 14.4 16.3 18.2l16.2 8.1c15.8 7.9 22.2 27.1 14.3 42.9s-27.1 22.2-42.9 14.3l-29.6-14.8c-14.7-7.4-31.7-8.8-47.4-3.9l-41.6 12.8c-23.3 7.2-48.3 6.5-71.2-1.8l-30-10.9c-14.1-5.1-29.6-5.1-43.7 0l-30 10.9c-22.9 8.3-47.9 9-71.2 1.8l-41.6-12.8c-15.7-4.8-32.7-3.4-47.4 3.9L46.3 308.6c-15.8 7.9-35 1.5-42.9-14.3s-1.5-35 14.3-42.9l16.2-8.1C41.4 239.5 47.1 232.9 50.2 225.1 87.9 130.7 180.1 64 288 64s200.1 66.7 237.8 161.1zM199.2 129.7c-7.9-4-17.5-.7-21.5 7.2l-16 32c-4 7.9-.7 17.5 7.2 21.5 2.2 1.1 4.5 1.6 6.8 1.7l.7 0c5.7-.1 11.2-3.3 14-8.8l16-32c4-7.9 .7-17.5-7.2-21.5zm177.7 0c-7.9 4-11.1 13.6-7.2 21.5l16 32c2.7 5.5 8.2 8.7 14 8.8l.7 0c2.3 0 4.6-.6 6.8-1.7 7.9-4 11.1-13.6 7.2-21.5l-16-32c-4-7.9-13.6-11.1-21.5-7.2zM288 128c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16s16-7.2 16-16l0-32c0-8.8-7.2-16-16-16zm10.9 192.1l30 10.9c29.5 10.7 61.6 11.5 91.6 2.3l41.6-12.8c7.9-2.4 16.4-1.7 23.7 2l29.6 14.8c.4 .2 .9 .4 1.3 .6l-22.1 66.4c-8.7 26.1-33.2 43.8-60.7 43.8l-291.7 0c-27.5 0-52-17.6-60.7-43.8L59.3 337.9c.4-.2 .9-.4 1.3-.6l29.6-14.8c7.4-3.7 15.9-4.4 23.7-2l41.6 12.8c30 9.2 62.1 8.4 91.6-2.3l30-10.9c7.1-2.6 14.8-2.6 21.9 0z"],
    "user-police-hair-long": [448, 512, [], "e7b5", "M215.6-29.7L65.7 11.2C55.3 14 48 23.5 48 34.4 48 42.8 52.4 50.7 59.7 55L80 67.2 80 91.8c0 11.4 6 21.8 16 26.7l0 25.5 0 .3 0 8c0 25.5-10.1 49.9-28.1 67.9L54.6 233.4c-4.2 4.2-6.6 10-6.6 16 0 12.5 10.1 22.6 22.6 22.6l306.7 0c12.5 0 22.6-10.1 22.6-22.6 0-6-2.4-11.8-6.6-16l-13.3-13.3c-18-18-28.1-42.4-28.1-67.9l0-33.7c10-5 16-15.4 16-26.7l0-24.6 20.3-12.2c7.2-4.3 11.7-12.2 11.7-20.6 0-10.8-7.3-20.4-17.7-23.2L232.4-29.7c-5.5-1.5-11.3-1.5-16.8 0zM224 224c-44.2 0-80-35.8-80-80l0-10.3c23.2 5.7 50.9 10.3 80 10.3s56.8-4.6 80-10.3l0 10.3c0 44.2-35.8 80-80 80zM120.1 320.1C58.7 348.3 16 410.3 16 482.3 16 498.7 29.3 512 45.7 512l356.6 0c16.4 0 29.7-13.3 29.7-29.7 0-72-42.7-134-104.1-162.1-7.4-3.4-16.1-2.1-22.6 2.8l-67 50.2c-8.5 6.4-20.3 6.4-28.8 0l-67-50.2c-6.5-4.9-15.2-6.2-22.6-2.8zM218.3 29.7c3.1-3.1 8.2-3.1 11.3 0l28.7 28.7c3.1 3.1 3.1 8.2 0 11.3L229.7 98.3c-3.1 3.1-8.2 3.1-11.3 0L189.7 69.7c-3.1-3.1-3.1-8.2 0-11.3l28.7-28.7zM304 400a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "bagel": [640, 512, [129391], "e3d7", "M640 208c0 112.8-89.7 204.6-201.7 207.9 7.5-15.3 13.4-31.5 17.7-48.4L471 357.3c5.1-3.5 11-5.4 17.2-5.6l25.3-.7c13.2-.4 24.8-8.8 29.3-21.3l8.5-23.9c2.1-5.8 5.8-10.9 10.6-14.6L582 275.8c10.5-8.1 14.9-21.7 11.2-34.4L586 217c-1.7-5.9-1.7-12.2 0-18.1l7.2-24.3c3.7-12.7-.7-26.3-11.2-34.4l-20.1-15.5c-4.9-3.8-8.6-8.8-10.6-14.6l-8.5-23.9c-4.4-12.5-16.1-20.9-29.3-21.3l-25.3-.7c-6.2-.2-12.1-2.1-17.2-5.6L450.1 44.4c-10.9-7.5-25.3-7.5-36.2 0L393 58.7c-5.1 3.5-11 5.4-17.2 5.6L350.5 65c-9.6 .3-18.3 4.8-24.1 12-12.9-6.8-26.5-12.4-40.6-16.9 37.6-37.1 89.2-60 146.2-60 114.9 0 208 93.1 208 208zM410.7 147.6c6.7-2.3 13.8-3.6 21.3-3.6 35.3 0 64 28.7 64 64 0 24.9-14.2 46.5-34.9 57-6.7-43.8-24.4-83.9-50.3-117.4zM0 304a208 208 0 1 1 416 0 208 208 0 1 1 -416 0zm256 0a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM112 416a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm144 16a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm48-16a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm16-176a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM144 224a16 16 0 1 0 0-32 16 16 0 1 0 0 32zM96 272a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"],
    "cart-xmark": [640, 512, [], "e0dd", "M0 8C0-5.3 10.7-16 24-16l45.3 0c27.1 0 50.3 19.4 55.1 46l.4 2 412.7 0c20 0 35.1 18.2 31.4 37.9L537.8 235.8c-5.7 30.3-32.1 52.2-62.9 52.2l-303.6 0 5.1 28.3c2.1 11.4 12 19.7 23.6 19.7L456 336c13.3 0 24 10.7 24 24s-10.7 24-24 24l-255.9 0c-34.8 0-64.6-24.9-70.8-59.1L77.2 38.6c-.7-3.8-4-6.6-7.9-6.6L24 32C10.7 32 0 21.3 0 8zM160 464a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm224 0a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM398.8 97.2c-9.4-9.4-24.6-9.4-33.9 0L336 126.1 307.2 97.2c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l28.8 28.8-28.9 28.9c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l28.9-28.9 28.9 28.9c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-28.9-28.9 28.9-28.8c9.4-9.4 9.4-24.6 0-33.9z"],
    "square-caret-right": [448, 512, ["caret-square-right"], "f152", "M448 96c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320zM320 256c0 6.7-2.8 13-7.7 17.6l-112 104c-7 6.5-17.2 8.2-25.9 4.4S160 369.5 160 360l0-208c0-9.5 5.7-18.2 14.4-22s18.9-2.1 25.9 4.4l112 104c4.9 4.5 7.7 10.9 7.7 17.6z"],
    "utensils-slash": [576, 512, [], "e464", "M41-24.9c-9.4-9.4-24.6-9.4-33.9 0S-2.3-.3 7 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-303-303c3.9-10 6.1-20.8 6.1-32.2 0-6.1-.6-12.2-1.9-18.2L255.9 14.3C255.1 6.2 248.2 0 240 0s-15.1 6.2-15.9 14.4l-13.1 130.7-25.5-25.5-9.6-105.1C175.2 6.3 168.3 0 160 0s-15.2 6.3-15.9 14.6l-5.3 58.4-41.1-41.1-1.7-17.4C95.1 6.2 88.2 0 80 0 76.1 0 72.5 1.4 69.7 3.8L41-24.9zM512 378.2L512 32c0-17.7-14.3-32-32-32-16 0-128 32-128 176l0 42.2 160 160zM52.7 122.6l-2.8 27.2c-1.3 6-1.9 12.1-1.9 18.2 0 45.9 35.1 83.6 80 87.7L128 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-218.2-139.3-139.3z"],
    "vial": [512, 512, [129514], "f492", "M342.6 9.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L306.7 64 28.1 342.6C10.1 360.6 0 385 0 410.5L0 416c0 53 43 96 96 96l5.5 0c25.5 0 49.9-10.1 67.9-28.1l278.6-278.6 9.4 9.4c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-160-160zM205.3 256l146.7-146.7 50.7 50.7-96 96-101.5 0z"],
    "helicopter": [576, 512, [128641], "f533", "M176 32c-13.3 0-24 10.7-24 24s10.7 24 24 24l152 0 0 48-220.8 0-32.8-39.4C69.9 83.2 63.1 80 56 80L24 80C15.7 80 8 84.3 3.6 91.4s-4.8 15.9-1.1 23.4l48 96C54.6 218.9 62.9 224 72 224l107.8 0 104 143.1c15.1 20.7 39.1 32.9 64.7 32.9l75.5 0c75.1 0 136-60.9 136-136S499.1 128 424 128l-48 0 0-48 152 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L176 32zM376 192l48 0c39.8 0 72 32.2 72 72s-32.2 72-72 72l-48 0 0-144zM552 416c-13.3 0-24 10.7-24 24 0 4.4-3.6 8-8 8l-272 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l272 0c30.9 0 56-25.1 56-56 0-13.3-10.7-24-24-24z"],
    "mitten": [448, 512, [], "f7b5", "M352 384L64 384 5.4 178.9C1.8 166.4 0 153.4 0 140.3 0 62.8 62.8 0 140.3 0l3.4 0c66 0 123.5 44.9 139.5 108.9l31.4 125.8 17.6-20.1C344.8 200.2 362.9 192 382 192l2.8 0c34.9 0 63.3 28.3 63.3 63.3 0 15.9-6 31.2-16.8 42.9L352 384zM32 464c0-17.7 14.3-32 32-32l288 0c17.7 0 32 14.3 32 32l0 16c0 17.7-14.3 32-32 32L64 512c-17.7 0-32-14.3-32-32l0-16z"],
    "file-music": [384, 512, [], "f8b6", "M0 64C0 28.7 28.7 0 64 0L213.5 0c17 0 33.3 6.7 45.3 18.7L365.3 125.3c12 12 18.7 28.3 18.7 45.3L384 448c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zm208-5.5l0 93.5c0 13.3 10.7 24 24 24L325.5 176 208 58.5zM248 240l-48 0c-13.3 0-24 10.7-24 24l0 89.8c-5.1-1.2-10.5-1.8-16-1.8-35.3 0-64 25.1-64 56s28.7 56 64 56 64-25.1 64-56l0-104 24 0c13.3 0 24-10.7 24-24l0-16c0-13.3-10.7-24-24-24z"],
    "gas-pump": [512, 512, [9981], "f52f", "M32 64C32 28.7 60.7 0 96 0L256 0c35.3 0 64 28.7 64 64l0 192 8 0c48.6 0 88 39.4 88 88l0 32c0 13.3 10.7 24 24 24s24-10.7 24-24l0-154c-27.6-7.1-48-32.2-48-62l0-59.5-25.8-28.3c-8.9-9.8-8.2-25 1.6-33.9s25-8.2 33.9 1.6l71.7 78.8c9.4 10.3 14.6 23.7 14.6 37.7L512 376c0 39.8-32.2 72-72 72s-72-32.2-72-72l0-32c0-22.1-17.9-40-40-40l-8 0 0 161.4c9.3 3.3 16 12.2 16 22.6 0 13.3-10.7 24-24 24L40 512c-13.3 0-24-10.7-24-24 0-10.5 6.7-19.3 16-22.6L32 64zM96 80l0 96c0 8.8 7.2 16 16 16l128 0c8.8 0 16-7.2 16-16l0-96c0-8.8-7.2-16-16-16L112 64c-8.8 0-16 7.2-16 16z"],
    "helmet-battle": [576, 512, [], "f6eb", "M96 192l0 220.2c0 12.1 6.8 23.2 17.7 28.6l119.2 59.6c10.6 5.3 23.2-2.4 23.2-14.3l0-207c0-13.8-8.8-26-21.9-30.4l-61.4-20.5c-7.6-2.5-12.7-9.6-12.7-17.6 0-10.3 8.3-18.6 18.6-18.6l218.8 0c10.3 0 18.6 8.3 18.6 18.6 0 8-5.1 15.1-12.7 17.6l-61.4 20.5c-13.1 4.4-21.9 16.6-21.9 30.4l0 207c0 11.9 12.5 19.6 23.2 14.3l119.2-59.6c10.8-5.4 17.7-16.5 17.7-28.6L480 192c0-40.3-19-78.2-51.2-102.4L307.2-1.6c-11.4-8.5-27-8.5-38.4 0L147.2 89.6C115 113.8 96 151.7 96 192zM64 226L64 17c0-9.4-7.6-17-17-17-8.6 0-15.8 6.4-16.9 14.9L4.2 222.3C2 240.2 16 256 34 256 50.6 256 64 242.6 64 226zM512 17l0 209c0 16.6 13.4 30 30 30 18.1 0 32-15.8 29.8-33.7L545.9 14.9C544.8 6.4 537.6 0 529 0 519.6 0 512 7.6 512 17z"],
    "meat": [512, 512, [127830], "f814", "M243.6 19.6C283.7-20.4 371.9 2.8 440.5 71.5s91.9 156.8 51.8 196.9l-40.5 40.5C403.9 357 338.7 384 270.7 384l-58.2 0c-7.1 0-13.9 2.8-18.9 7.8-10.3 10.3-9.7 26.9-5 40.7 2.1 6.1 3.2 12.7 3.2 19.5 0 33.1-26.9 60-60 60s-60-26.9-60-60c0-6.3-5.7-12-12-12-33.1 0-60-26.9-60-60s26.9-60 60-60c6.8 0 13.4 1.1 19.5 3.2 13.8 4.7 30.4 5.3 40.7-5 5-5 7.8-11.8 7.8-18.9l0-58.1c0-67.9 27-133 75-181l40.7-40.7zm64 184.8c49.6 49.6 113.3 66.4 142.2 37.4s12.2-92.6-37.4-142.2-113.3-66.4-142.2-37.4-12.2 92.6 37.4 142.2zm36.3-36.3c-15.3-15.3-20.4-34.9-11.5-43.8s28.5-3.7 43.8 11.5 20.4 34.9 11.5 43.8-28.5 3.7-43.8-11.5z"],
    "trumpet": [640, 512, [127930], "f8e3", "M628.7 64.7C635.4 66.8 640 73 640 80l0 288c0 7-4.6 13.2-11.3 15.3s-14-.5-18-6.2c-15.7-22.5-35-42.9-55.4-61.1-34.8-30.9-80.7-59.6-130.4-60l-25 0 0 126c27.6-7.1 48-32.2 48-62l0-12.7c20.7 5.5 42 17.5 62.3 33.5-9.9 60.8-62.7 107.2-126.3 107.2l-192 0c-70.7 0-128-57.3-128-128 0-23.3 6.2-45.2 17.1-64l-34.5 0c-3.3 9.3-12.2 16-22.6 16-13.3 0-24-10.7-24-24l0-48c0-13.3 10.7-24 24-24 10.4 0 19.3 6.7 22.6 16l129.4 0 0-40c0-13.3 10.7-24 24-24s24 10.7 24 24l0 40 40 0 0-40c0-13.3 10.7-24 24-24s24 10.7 24 24l0 40 40 0 0-40c0-13.3 10.7-24 24-24s24 10.7 24 24l0 40c4 0 12 0 24 0 50.1 0 96.4-28.8 131.4-60 20.4-18.2 39.7-38.6 55.4-61.1 4-5.8 11.2-8.3 17.9-6.2zM176 258c-27.6 7.1-48 32.2-48 62s20.4 54.9 48 62l0-124zm48 126l40 0 0-128-40 0 0 128zm88 0l40 0 0-128-40 0 0 128z"],
    "browsers": [576, 512, [], "e0cb", "M160 32c-35.3 0-64 28.7-64 64l0 224c0 35.3 28.7 64 64 64l352 0c35.3 0 64-28.7 64-64l0-224c0-35.3-28.7-64-64-64L160 32zm32 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm64 32c0-13.3 10.7-24 24-24l208 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-208 0c-13.3 0-24-10.7-24-24zM48 152c0-13.3-10.7-24-24-24S0 138.7 0 152L0 416c0 35.3 28.7 64 64 64l392 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L64 432c-8.8 0-16-7.2-16-16l0-264z"],
    "arrow-down-left": [384, 512, [], "e091", "M0 416c0 17.7 14.3 32 32 32l224 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-146.7 0 265.4-265.4c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L64 338.7 64 192c0-17.7-14.3-32-32-32S0 174.3 0 192L0 416z"],
    "square-1": [448, 512, [], "e256", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM184 144l40 0c13.3 0 24 10.7 24 24l0 152 32 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-112 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l32 0 0-128-16 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"],
    "user-nurse-hair-long": [448, 512, [], "e45e", "M96 44.9c0-12.7 7.5-24.2 19.2-29.3l96-42c8.2-3.6 17.5-3.6 25.7 0l96 42C344.5 20.7 352 32.2 352 44.9l0 107.3c0 25.5 10.1 49.9 28.1 67.9l13.3 13.3c4.2 4.2 6.6 10 6.6 16 0 12.5-10.1 22.6-22.6 22.6L70.6 272c-12.5 0-22.6-10.1-22.6-22.6 0-6 2.4-11.8 6.6-16l13.3-13.3c18-18 28.1-42.4 28.1-67.9L96 44.9zM304 128l-115.7 0-.4 0-43.9 0 0 16c0 44.2 35.8 80 80 80s80-35.8 80-80l0-16zM142.6 323l67 50.2c8.5 6.4 20.3 6.4 28.8 0l67-50.2c6.5-4.9 15.2-6.2 22.6-2.8 61.4 28.2 104.1 90.2 104.1 162.1 0 16.4-13.3 29.7-29.7 29.7L45.7 512c-16.4 0-29.7-13.3-29.7-29.7 0-72 42.7-134 104.1-162.1 7.4-3.4 16.1-2.1 22.6 2.8zM208 16l0 16-16 0c-4.4 0-8 3.6-8 8l0 16c0 4.4 3.6 8 8 8l16 0 0 16c0 4.4 3.6 8 8 8l16 0c4.4 0 8-3.6 8-8l0-16 16 0c4.4 0 8-3.6 8-8l0-16c0-4.4-3.6-8-8-8l-16 0 0-16c0-4.4-3.6-8-8-8L216 8c-4.4 0-8 3.6-8 8z"],
    "temperature-sun": [576, 512, ["temperature-hot"], "f76a", "M304.5 96c0-53 43-96 96-96s96 43 96 96l0 164.7c29.5 26.4 48 64.7 48 107.3 0 79.5-64.5 144-144 144s-144-64.5-144-144c0-42.6 18.5-81 48-107.3l0-164.7zm96 336c35.3 0 64-28.7 64-64 0-26.9-16.5-49.9-40-59.3l0-212.7c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 212.7c-23.5 9.5-40 32.5-40 59.3 0 35.3 28.7 64 64 64zM285.8 8.9C267.4 33.1 256.5 63.3 256.5 96l0 21.5c-10-3.5-20.8-5.5-32-5.5-53 0-96 43-96 96 0 51.3 40.3 93.3 91 95.9-7.1 20.1-11 41.6-11 64.1 0 3 .1 5.9 .2 8.9l-54.9 36.4c-4.4 2.9-10 3.5-14.9 1.4s-8.5-6.4-9.5-11.6L112.5 320 29.3 303.2c-5.2-1.1-9.5-4.6-11.6-9.5s-1.5-10.5 1.4-14.9L66.1 208 19.2 137.3c-2.9-4.4-3.5-10-1.4-14.9s6.4-8.5 11.6-9.5L112.5 96 129.3 12.8c1.1-5.2 4.6-9.5 9.5-11.6s10.5-1.5 14.9 1.4l70.7 46.9 61.3-40.7zM256.5 172.2l0 68.8c-2.2 2.5-4.3 5-6.3 7.6-7.4 4.7-16.2 7.4-25.7 7.4-26.5 0-48-21.5-48-48s21.5-48 48-48c12.3 0 23.5 4.6 32 12.2z"],
    "gas-pump-slash": [576, 512, [], "f5f4", "M41-24.9c-9.4-9.4-24.6-9.4-33.9 0S-2.3-.3 7 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-63.4-63.4C528.4 427.6 544 403.6 544 376l0-219.6c0-13.9-5.2-27.4-14.6-37.7L457.8 39.9c-8.9-9.8-24.1-10.5-33.9-1.6s-10.5 24.1-1.6 33.9l25.8 28.3 0 59.5c0 29.8 20.4 54.9 48 62l0 154c0 13.3-10.7 24-24 24L465.8 400 352 286.2 352 64c0-35.3-28.7-64-64-64L128 0C110.8 0 95.2 6.8 83.7 17.8L41-24.9zm92.7 92.7c2.8-2.4 6.4-3.8 10.4-3.8l128 0c8.8 0 16 7.2 16 16l0 96c0 8.8-7.2 16-16 16l-14.2 0-124.2-124.2zM64 465.4c-9.3 3.3-16 12.2-16 22.6 0 13.3 10.7 24 24 24l272 0c13.3 0 24-10.7 24-24 0-10.5-6.7-19.3-16-22.6l0-43.5-288-288 0 331.5z"],
    "envelope-circle-check": [640, 512, [], "e4e8", "M64 112c0-26.5 21.5-48 48-48l416 0c26.5 0 48 21.5 48 48l0 81.4c-24.4-11.2-51.4-17.4-80-17.4-87.7 0-161.7 58.8-184.7 139.2-7.1-1.3-14.1-4.2-20.1-8.8l-208-156C71.1 141.3 64 127.1 64 112zM304 368c0 28.6 6.2 55.6 17.4 80L128 448c-35.3 0-64-28.7-64-64l0-188 198.4 148.8c12.6 9.4 26.9 15.4 41.7 17.9 0 1.8-.1 3.5-.1 5.3zm48 0a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm201.4-60.9c-7.1-5.2-17.2-3.6-22.4 3.5l-53 72.9-26.8-26.8c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l40 40c3.3 3.3 7.9 5 12.6 4.6s8.9-2.8 11.7-6.5l64-88c5.2-7.1 3.6-17.2-3.5-22.3z"],
    "file-gif": [576, 512, [], "e645", "M96 0C60.7 0 32 28.7 32 64l0 384c0 35.3 28.7 64 64 64l144 0 0-112c0-35.3 28.7-64 64-64l112 0 0-165.5c0-17-6.7-33.3-18.7-45.3L290.7 18.7C278.7 6.7 262.5 0 245.5 0L96 0zM357.5 176L264 176c-13.3 0-24-10.7-24-24L240 58.5 357.5 176zM328 380c-24.3 0-44 19.7-44 44l0 80c0 24.3 19.7 44 44 44l16 0c24.3 0 44-19.7 44-44l0-24c0-11-9-20-20-20l-8 0c-11 0-20 9-20 20 0 6.5 3.1 12.4 8 16l0 8c0 2.2-1.8 4-4 4l-16 0c-2.2 0-4-1.8-4-4l0-80c0-2.2 1.8-4 4-4l20.4 0c1.9 9.1 9.9 16 19.6 16 11 0 20-9 20-20 0-19.9-16.1-36-36-36l-24 0zm124 20c0-11-9-20-20-20s-20 9-20 20l0 128c0 11 9 20 20 20s20-9 20-20l0-128zm24 0l0 128c0 11 9 20 20 20s20-9 20-20l0-44 28 0c11 0 20-9 20-20s-9-20-20-20l-28 0 0-24 28 0c11 0 20-9 20-20s-9-20-20-20l-48 0c-11 0-20 9-20 20z"],
    "person-skating": [512, 512, ["skating"], "f7c5", "M368 56a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zM128 128c0-17.7 14.3-32 32-32l150.1 0c49.9 0 74.9 60.3 39.6 95.6l-63.9 63.9 69.8 31c17.3 7.7 28.5 24.9 28.5 43.9l0 85.6c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-75.2-82.4-36.6c-41-18.2-51-72-19.3-103.7l40.4-40.4-98.7 0c-17.7 0-32-14.3-32-32zM89.4 361.4l75.9-75.9c7.7 19.7 21.6 37.3 41 49.6l-71.6 71.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3zm346.5 87.1c8.6 2.1 13.8 10.8 11.6 19.4l-.4 1.7c-6.2 24.9-28.6 42.4-54.3 42.4L304 512c-8.8 0-16-7.2-16-16s7.2-16 16-16l88.8 0c11 0 20.6-7.5 23.3-18.2l.4-1.7c2.1-8.6 10.8-13.8 19.4-11.6zM143.2 486.3l-6.2 3.1c-21.6 10.8-47.6 6.6-64.6-10.5L12.7 419.3c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l59.6 59.6c7.3 7.3 18.5 9.1 27.7 4.5l6.2-3.1c7.9-4 17.5-.7 21.5 7.2s.7 17.5-7.2 21.5z"],
    "face-angry-horns": [640, 512, [], "e368", "M576 256c0 141.4-114.6 256-256 256S64 397.4 64 256c0-24.6 3.5-48.4 9.9-70.9-44.3-59.4-67.4-135-73.6-166-1.3-6.3 1.4-12.8 6.8-16.4s12.4-3.6 17.8 0c19.3 12.9 48.5 24.2 78.4 33.1 23.3 7 46 12.2 63 15.5 42.8-32.2 96.1-51.3 153.8-51.3S430.9 19.1 473.8 51.3c17-3.3 39.7-8.6 63-15.5 29.8-8.9 59.1-20.2 78.4-33.1 5.4-3.6 12.4-3.6 17.8 0s8.1 10.1 6.8 16.4c-6.2 31-29.3 106.6-73.6 166 6.5 22.5 9.9 46.3 9.9 70.9zM320 384c24.1 0 45.4 11.8 58.5 30 7.7 10.8 22.7 13.2 33.5 5.5s13.2-22.7 5.5-33.5c-21.7-30.2-57.3-50-97.5-50s-75.7 19.8-97.5 50c-7.7 10.8-5.3 25.8 5.5 33.5s25.8 5.3 33.5-5.5c13.1-18.2 34.4-30 58.5-30zm-80-80c17.7 0 32-14.3 32-32l0-.3 9.7 3.2c10.5 3.5 21.8-2.2 25.3-12.6s-2.2-21.8-12.6-25.3l-96-32c-10.5-3.5-21.8 2.2-25.3 12.6s2.2 21.8 12.6 25.3l28.9 9.6c-4.1 5.4-6.6 12.1-6.6 19.4 0 17.7 14.3 32 32 32zm192-32c0-7.3-2.4-14-6.6-19.4l28.9-9.6c10.5-3.5 16.1-14.8 12.6-25.3s-14.8-16.1-25.3-12.6l-96 32c-10.5 3.5-16.1 14.8-12.6 25.3s14.8 16.1 25.3 12.6l9.7-3.2 0 .3c0 17.7 14.3 32 32 32s32-14.3 32-32z"],
    "sun": [576, 512, [9728], "f185", "M178.2-10.1c7.4-3.1 15.8-2.2 22.5 2.2l87.8 58.2 87.8-58.2c6.7-4.4 15.1-5.2 22.5-2.2S411.4-.5 413 7.3l20.9 103.2 103.2 20.9c7.8 1.6 14.4 7 17.4 14.3s2.2 15.8-2.2 22.5l-58.2 87.8 58.2 87.8c4.4 6.7 5.2 15.1 2.2 22.5s-9.6 12.8-17.4 14.3L433.8 401.4 413 504.7c-1.6 7.8-7 14.4-14.3 17.4s-15.8 2.2-22.5-2.2l-87.8-58.2-87.8 58.2c-6.7 4.4-15.1 5.2-22.5 2.2s-12.8-9.6-14.3-17.4L143 401.4 39.7 380.5c-7.8-1.6-14.4-7-17.4-14.3s-2.2-15.8 2.2-22.5L82.7 256 24.5 168.2c-4.4-6.7-5.2-15.1-2.2-22.5s9.6-12.8 17.4-14.3L143 110.6 163.9 7.3c1.6-7.8 7-14.4 14.3-17.4zM207.6 256a80.4 80.4 0 1 1 160.8 0 80.4 80.4 0 1 1 -160.8 0zm208.8 0a128.4 128.4 0 1 0 -256.8 0 128.4 128.4 0 1 0 256.8 0z"],
    "diploma": [640, 512, ["scroll-ribbon"], "f5ea", "M80 384C35.8 384 0 312.4 0 224S35.8 64 80 64l480 0c44.2 0 80 71.6 80 160s-35.8 160-80 160l-83.2 0c12.3-24 19.2-51.2 19.2-80 0-97.2-78.8-176-176-176S144 206.8 144 304c0 28.8 6.9 56 19.2 80L80 384zm368-80c0 32.5-12.1 62.1-32 84.7l0 103.5c0 10.9-8.9 19.8-19.8 19.8-2.8 0-5.5-.6-8-1.7L320 480 251.8 510.3c-2.5 1.1-5.3 1.7-8 1.7-10.9 0-19.8-8.9-19.8-19.8l0-103.5c-19.9-22.6-32-52.2-32-84.7 0-70.7 57.3-128 128-128s128 57.3 128 128zM320 352a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"],
    "baseball": [512, 512, [129358, 9918, "baseball-ball"], "f433", "M232.4 1.1c-122.2 11.4-219.5 108.7-230.9 230.9 16.2-.1 32-1.8 47.2-5 13-2.7 25.7 5.5 28.4 18.5s-5.5 25.7-18.5 28.4c-18.4 3.9-37.6 6-57.1 6.1 11.4 122.2 108.7 219.5 230.9 230.9 .1-19.5 2.2-38.7 6.1-57.1 2.7-13 15.5-21.3 28.4-18.5s21.3 15.5 18.5 28.4c-3.2 15.2-4.9 31-5 47.2 122.2-11.4 219.5-108.7 230.9-230.9-16.2 .1-32 1.8-47.2 5-13 2.7-25.7-5.5-28.4-18.5s5.5-25.7 18.5-28.4c18.4-3.9 37.6-6 57.1-6.1-11.4-122.2-108.7-219.5-230.9-230.9-.1 19.5-2.2 38.7-6.1 57.1-2.7 13-15.5 21.3-28.4 18.5s-21.3-15.5-18.5-28.4c3.2-15.2 4.9-31 5-47.2zm2.8 151.4c-21.4 32.9-49.5 60.9-82.3 82.3-11.1 7.2-26 4.1-33.2-7s-4.1-26 7-33.2c27.2-17.7 50.5-41 68.3-68.3 7.2-11.1 22.1-14.3 33.2-7s14.3 22.1 7 33.2zM393.1 284.2c7.2 11.1 4.1 26-7 33.2-27.2 17.7-50.5 41-68.3 68.3-7.2 11.1-22.1 14.3-33.2 7s-14.3-22.1-7-33.2c21.4-32.9 49.5-60.9 82.3-82.3 11.1-7.2 26-4.1 33.2 7z"],
    "image": [448, 512, [], "f03e", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm64 80a48 48 0 1 1 0 96 48 48 0 1 1 0-96zM272 224c8.4 0 16.1 4.4 20.5 11.5l88 144c4.5 7.4 4.7 16.7 .5 24.3S368.7 416 360 416L88 416c-8.9 0-17.2-5-21.3-12.9s-3.5-17.5 1.6-24.8l56-80c4.5-6.4 11.8-10.2 19.7-10.2s15.2 3.8 19.7 10.2l26.4 37.8 61.4-100.5c4.4-7.1 12.1-11.5 20.5-11.5z"],
    "boot": [448, 512, [129406], "f782", "M0 32C0 14.3 14.3 0 32 0L288 0c17.7 0 32 14.3 32 32l0 48c0 17.7-14.3 32-32 32l-72 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l72 0 0 48-72 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l104 0c70.7 0 128 57.3 128 128L0 384 0 32zM0 432l448 0 0 28.7c0 12.4-4.5 24.4-12.7 33.8-9.7 11.1-23.8 17.5-38.6 17.5l-4.7 0c-17.8 0-34.7-7.7-46.4-21.1l-3.5-4c-3.2-3.6-8.9-3.6-12 0l-3.5 4C314.7 504.3 297.8 512 280 512s-34.7-7.7-46.4-21.1l-3.5-4c-3.2-3.6-8.9-3.6-12 0l-3.5 4C202.7 504.3 185.8 512 168 512s-34.7-7.7-46.4-21.1l-3.5-4c-3.2-3.6-8.9-3.6-12 0l-3.5 4C90.7 504.3 73.8 512 56 512l-4.7 0c-14.8 0-28.8-6.4-38.6-17.5-8.2-9.3-12.7-21.3-12.7-33.8L0 432z"],
    "car-bump": [576, 512, [], "f5e0", "M236.6 87.6L100.3 166.4c-5.8 3.3-8.9 9.9-7.8 16.5l12.2 73.3 207.5-119.8-57.4-47.2c-5.2-4.2-12.4-4.8-18.2-1.5zm138.7 17.8l2.8 2.3c22.4-.3 44.3 11.2 56.3 32 8 13.9 24 41.6 48 83.1l16 27.7c8.8 15.3 3.6 34.9-11.7 43.7l-13.9 8c-15.3 8.8-34.9 3.6-43.7-11.7l-16-27.7-249.4 144 16 27.7c8.8 15.3 3.6 34.9-11.7 43.7l-13.9 8c-15.3 8.8-34.9 3.6-43.7-11.7-8-13.9-24-41.6-48-83.1l-16-27.7c-12-20.8-11-45.5 .4-64.8l-.6-3.5-17-102c-5.5-32.9 10-65.7 38.9-82.4L204.6 32.2c28.9-16.7 65.1-13.7 90.8 7.5l79.9 65.7zm0 123.9a32 32 0 1 0 -32-55.4 32 32 0 1 0 32 55.4zM109.9 345.6a32 32 0 1 0 55.4-32 32 32 0 1 0 -55.4 32zm462 134.9c5 17-9.8 31.6-27.5 31.6l-160 0c-17.7 0-32.5-14.6-27.5-31.6 13.6-46.5 56.6-80.4 107.5-80.4s93.9 33.9 107.5 80.4z"],
    "money-bill-simple": [512, 512, [], "e1f1", "M64 64C28.7 64 0 92.7 0 128L0 384c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L64 64zm192 96a96 96 0 1 1 0 192 96 96 0 1 1 0-192z"],
    "square-arrow-down": [448, 512, ["arrow-square-down"], "f339", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM207 377l-80-80c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l39 39 0-150.1c0-13.3 10.7-24 24-24s24 10.7 24 24l0 150.1 39-39c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-80 80c-9.4 9.4-24.6 9.4-33.9 0z"],
    "notdef": [384, 512, [], "e1fe", "M64 390.3L153.5 256 64 121.7 64 390.3zM102.5 448L281.5 448 192 313.7 102.5 448zm128-192L320 390.3 320 121.7 230.5 256zM281.5 64L102.5 64 192 198.3 281.5 64zM0 48C0 21.5 21.5 0 48 0L336 0c26.5 0 48 21.5 48 48l0 416c0 26.5-21.5 48-48 48L48 512c-26.5 0-48-21.5-48-48L0 48z"],
    "comment-question": [512, 512, [], "e14b", "M256 480c141.4 0 256-107.5 256-240S397.4 0 256 0 0 107.5 0 240c0 54.3 19.2 104.3 51.6 144.5L2.8 476.8c-4.8 9-3.3 20 3.6 27.5s17.8 9.8 27.1 5.8l118.4-50.7C183.7 472.6 218.9 480 256 480zm0-312c-16.1 0-29.2 13.1-29.2 29.2 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-42.6 34.6-77.2 77.2-77.2s77.2 34.6 77.2 77.2c0 45.5-34.5 64.7-53.7 71.8-2.3 10.8-11.9 19-23.5 19-13.3 0-24-10.7-24-24 0-20.2 14.6-34.6 29.5-39.5 6-2 12.3-5.1 16.8-9.5 3.9-3.8 6.9-9 6.9-17.7 0-16.1-13.1-29.2-29.2-29.2zM228 336a28 28 0 1 1 56 0 28 28 0 1 1 -56 0z"],
    "user-robot": [448, 512, [], "e04b", "M248 16c0-13.3-10.7-24-24-24S200 2.7 200 16l0 40-56 0c-35.3 0-64 28.7-64 64l0 40-24 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l24 0 0 24c0 35.3 28.7 64 64 64l160 0c35.3 0 64-28.7 64-64l0-24 24 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-24 0 0-40c0-35.3-28.7-64-64-64l-56 0 0-40zM0 448l0 32c0 17.7 14.3 32 32 32l72 0 0-40c0-13.3 10.7-24 24-24s24 10.7 24 24l0 40 48 0 0-40c0-13.3 10.7-24 24-24s24 10.7 24 24l0 40 48 0 0-40c0-13.3 10.7-24 24-24s24 10.7 24 24l0 40 72 0c17.7 0 32-14.3 32-32l0-32c0-53-43-96-96-96L96 352c-53 0-96 43-96 96zM128 152a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm160-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "basketball": [512, 512, [127936, "basketball-ball"], "f434", "M92.7 58.8l78.4 78.4c18.2-25 28.9-55.9 28.9-89.2 0-14.1-1.9-27.7-5.5-40.6-38 9.4-72.6 27.2-101.8 51.4zM58.8 92.7c-24.2 29.2-42 63.8-51.4 101.8 12.9 3.6 26.5 5.5 40.6 5.5 33.3 0 64.1-10.7 89.2-28.9L58.8 92.7zM256 0c-4.6 0-9.2 .1-13.7 .4 3.7 15.3 5.7 31.2 5.7 47.6 0 46.6-15.9 89.4-42.6 123.4L256 222.1 419.3 58.8C374.9 22.1 318.1 0 256 0zM48 248c-16.4 0-32.4-2-47.6-5.7-.2 4.5-.4 9.1-.4 13.7 0 62.1 22.1 118.9 58.8 163.3L222.1 256 171.4 205.4C137.4 232.1 94.6 248 48 248zm463.6 21.7c.2-4.5 .4-9.1 .4-13.7 0-62.1-22.1-118.9-58.8-163.3L289.9 256 340.6 306.6c34-26.7 76.9-42.6 123.4-42.6 16.4 0 32.4 2 47.6 5.7zm-7.1 47.8c-12.9-3.6-26.5-5.5-40.6-5.5-33.3 0-64.1 10.7-89.2 28.9l78.4 78.4c24.2-29.2 42-63.8 51.4-101.8zM340.9 374.8c-18.2 25-28.9 55.9-28.9 89.2 0 14.1 1.9 27.7 5.5 40.6 38-9.4 72.6-27.2 101.8-51.4l-78.4-78.4zm-34.3-34.3L256 289.9 92.7 453.2c44.3 36.7 101.2 58.8 163.3 58.8 4.6 0 9.2-.1 13.7-.4-3.7-15.3-5.7-31.2-5.7-47.6 0-46.6 15.9-89.4 42.6-123.4z"],
    "pencil": [512, 512, [9999, 61504, "pencil-alt"], "f303", "M36.4 353.2c4.1-14.6 11.8-27.9 22.6-38.7l181.2-181.2 33.9-33.9c16.6 16.6 51.3 51.3 104 104l33.9 33.9-33.9 33.9-181.2 181.2c-10.7 10.7-24.1 18.5-38.7 22.6L30.4 510.6c-8.3 2.3-17.3 0-23.4-6.2S-1.4 489.3 .9 481L36.4 353.2zm55.6-3.7c-4.4 4.7-7.6 10.4-9.3 16.6l-24.1 86.9 86.9-24.1c6.4-1.8 12.2-5.1 17-9.7L91.9 349.5zm354-146.1c-16.6-16.6-51.3-51.3-104-104L308 65.5C334.5 39 349.4 24.1 352.9 20.6 366.4 7 384.8-.6 404-.6S441.6 7 455.1 20.6l35.7 35.7C504.4 69.9 512 88.3 512 107.4s-7.6 37.6-21.2 51.1c-3.5 3.5-18.4 18.4-44.9 44.9z"],
    "person-walking-arrow-loop-left": [640, 512, [], "e551", "M160 80a56 56 0 1 0 0-112 56 56 0 1 0 0 112zM73.4 227.9l22.6-22.6 0 69.3c0 28 12.2 54.7 33.5 72.9l71.4 61.2c5.9 5.1 9.8 12.1 10.9 19.8l12.6 88.1c2.5 17.5 18.7 29.7 36.2 27.2s29.7-18.7 27.2-36.2l-12.6-88.1c-3.3-23.1-14.9-44.1-32.6-59.3l-34.5-29.6 0-115.2 3.8 4.7c18.2 22.8 45.8 36 75 36l33.2 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-33.2 0c-9.7 0-18.9-4.4-25-12l-17.9-22.4c-23-28.8-57.9-45.6-94.8-45.6-32.2 0-63.1 12.8-85.8 35.6L28.1 182.6C10.1 200.6 0 225 0 250.5L0 288c0 17.7 14.3 32 32 32s32-14.3 32-32l0-37.5c0-8.5 3.4-16.6 9.4-22.6zM85.8 407.3c-1.5 5.2-4.3 10-8.1 13.8L9.4 489.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l68.3-68.3c11.5-11.5 19.9-25.8 24.4-41.5l2.2-7.6-46-39.4c-2.5-2.2-5-4.4-7.4-6.8L85.8 407.3zM359 335c-9.4 9.4-9.4 24.6 0 33.9l72 72c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-31-31 102.1 0c1.2 0 2.4-.1 3.5-.3 56.1-3.9 100.5-50.6 100.5-107.7 0-59.6-48.4-108-108-108l-92 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l92 0c33.1 0 60 26.9 60 60s-26.9 60-60 60l-98.1 0 31-31c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-72 72z"],
    "boot-heeled": [448, 512, [], "e33f", "M96 0L35.8 0C16.7 0 1.8 16.6 3.9 35.5l23 206.7c3.4 30.2 1.3 60.8-6.1 90.4l-17 68.1C1.3 410.9 0 421.3 0 431.8L0 480c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l112.7 28.2c10.2 2.5 20.6 3.8 31 3.8L416 512c17.7 0 32-14.3 32-32l0-43.2c0-22.8-12.1-43.8-31.8-55.3L292 309c-21.9-12.8-34.2-37.2-31.4-62.4L284.1 35.5C286.2 16.6 271.3 0 252.2 0L144 0 144 200c0 13.3-10.7 24-24 24s-24-10.7-24-24L96 0z"],
    "dice-six": [448, 512, [9861], "f526", "M0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm160 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM128 288a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm32 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM320 192a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm32 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM320 384a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "circle-ellipsis": [512, 512, [], "e10a", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM160 224a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm64 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm128-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "swedish-krona-sign": [512, 512, [], "e73e", "M112 48c0-17.7-14.3-32-32-32S48 30.3 48 48l0 400c0 17.7 14.3 32 32 32s32-14.3 32-32l0-81.8 29.1-26.5 88.7 126.7c10.1 14.5 30.1 18 44.6 7.9s18-30.1 7.9-44.6l-93.4-133.4 88.7-80.6c13.1-11.9 14-32.1 2.2-45.2s-32.1-14-45.2-2.2L112 279.7 112 48zM448 224l16 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-16 0c-23.9 0-47 6.7-66.8 18.8-5-11.1-16.2-18.8-29.2-18.8-17.7 0-32 14.3-32 32l0 256c0 17.7 14.3 32 32 32s32-14.3 32-32l0-160c0-13.8 4.5-27.3 12.8-38.4 12.1-16.1 31.1-25.6 51.2-25.6z"],
    "arrow-up-square-triangle": [512, 512, ["sort-shapes-up-alt"], "f88b", "M150.6 41.4c-12.5-12.5-32.8-12.5-45.3 0l-80 80c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L96 141.3 96 448c0 17.7 14.3 32 32 32s32-14.3 32-32l0-306.7 25.4 25.4c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-80-80zM288 80l0 96c0 26.5 21.5 48 48 48l96 0c26.5 0 48-21.5 48-48l0-96c0-26.5-21.5-48-48-48l-96 0c-26.5 0-48 21.5-48 48zM411.1 303c-5.8-9.4-16.1-15-27.1-15s-21.3 5.7-27.1 15l-80 128c-6.2 9.9-6.5 22.3-.9 32.5S292.4 480 304 480l160 0c11.6 0 22.3-6.3 28-16.5s5.3-22.6-.9-32.5l-80-128z"],
    "angles-down": [384, 512, ["angle-double-down"], "f103", "M214.6 470.6c-12.5 12.5-32.8 12.5-45.3 0l-160-160c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0L192 402.7 329.4 265.4c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3l-160 160zm160-352l-160 160c-12.5 12.5-32.8 12.5-45.3 0l-160-160c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0L192 210.7 329.4 73.4c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3z"],
    "van": [576, 512, [], "e7c8", "M0 128C0 92.7 28.7 64 64 64l368 0c20.1 0 39.1 9.5 51.2 25.6l80 106.7c8.3 11.1 12.8 24.6 12.8 38.4L576 336c0 35.3-28.7 64-64 64l-.4 0c-4 44.9-41.7 80-87.6 80s-83.6-35.1-87.6-80l-96.7 0c-4 44.9-41.7 80-87.6 80s-83.6-35.1-87.6-80l-.4 0c-35.3 0-64-28.7-64-64L0 128zm384 96l120 0-72-96-48 0 0 96zm80 168a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zM152 432a40 40 0 1 0 0-80 40 40 0 1 0 0 80z"],
    "battery-low": [640, 512, ["battery-1"], "e0b1", "M528 128c8.8 0 16 7.2 16 16l0 224c0 8.8-7.2 16-16 16l-416 0c-8.8 0-16-7.2-16-16l0-224c0-8.8 7.2-16 16-16l416 0zM112 64c-44.2 0-80 35.8-80 80l0 224c0 44.2 35.8 80 80 80l416 0c44.2 0 80-35.8 80-80l0-48c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l0-48c0-44.2-35.8-80-80-80L112 64zm56 112c-13.3 0-24 10.7-24 24l0 112c0 13.3 10.7 24 24 24s24-10.7 24-24l0-112c0-13.3-10.7-24-24-24z"],
    "lacrosse-stick-ball": [576, 512, [], "e3b6", "M400-32c97.2 0 176 78.8 176 176 0 57.8-35.9 109-89.3 129.2l-10.9 3.6-11.5 3.3c-8.6 2.5-16.8 6.2-24.2 11l-7.2 5.2-34.9 27.9c-22.5 18-50.4 27.8-79.2 27.8-23.4 0-45.3-6.4-64.1-17.4L54.6 534.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l200-200.1c-11-18.8-17.4-40.7-17.4-64.1 0-28.8 9.8-56.7 27.8-79.2l27.9-34.9 5.2-7.2c4.8-7.5 8.6-15.7 11-24.2l3.3-11.5 3.6-10.9C291 3.9 342.2-32 400-32zm96 576a80 80 0 1 1 0-160 80 80 0 1 1 0 160zM400 32c-31 0-58.5 19.3-69.3 47.9l-1.9 5.8-3.3 11.5c-4.9 17.2-12.8 33.3-23.2 47.8l-4.6 6.1-27.9 34.9c-8.9 11.1-13.7 25-13.8 39.2 0 34.7 28.1 62.7 62.7 62.7 14.2 0 28.1-4.8 39.2-13.7l34.9-27.9 6.1-4.6c14.4-10.4 30.6-18.3 47.8-23.2l11.5-3.3 5.8-1.9C492.7 202.5 512 175 512 144 512 82.1 461.8 32 400 32z"],
    "seat-airline-window": [384, 512, [], "e7be", "M32 0C49.7 0 64 14.3 64 32l0 115c0 5.2 .8 10.3 2.5 15.2l45.3 135.9c4.4 13.1 16.6 21.9 30.4 21.9L352 320c17.7 0 32 14.3 32 32s-14.3 32-32 32l-209.9 0c-41.3 0-78-26.4-91.1-65.6L5.7 182.4C1.9 171 0 159.1 0 147L0 32C0 14.3 14.3 0 32 0zm0 480c0-17.7 14.3-32 32-32l288 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L64 512c-17.7 0-32-14.3-32-32zM240 0l64 0c26.5 0 48 21.5 48 48l0 128c0 26.5-21.5 48-48 48l-64 0c-26.5 0-48-21.5-48-48l0-128c0-26.5 21.5-48 48-48z"],
    "alarm-snooze": [512, 512, [], "f845", "M504.4 132.5c-4.5 10.5-18.4 9.8-24.9 .4-27.8-40-66.1-72.2-111-92.6-10.4-4.7-13.7-18.3-4.1-24.6 15-9.9 33-15.7 52.3-15.7 52.6 0 95.2 42.6 95.2 95.2 0 13.2-2.7 25.8-7.6 37.3zm-471.9 .4c-6.5 9.4-20.5 10.1-24.9-.4-4.9-11.5-7.6-24.1-7.6-37.3 0-52.6 42.6-95.2 95.2-95.2 19.3 0 37.3 5.8 52.3 15.7 9.6 6.3 6.3 19.9-4.1 24.6-44.8 20.4-83.1 52.6-111 92.6zM390.2 467.4C352.8 495.4 306.3 512 256 512s-96.8-16.6-134.1-44.6L86.6 502.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l35.2-35.2C48.6 384.8 32 338.3 32 288 32 164.3 132.3 64 256 64S480 164.3 480 288c0 50.3-16.6 96.8-44.6 134.2l35.2 35.2c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0l-35.2-35.2zM200 192c-13.3 0-24 10.7-24 24s10.7 24 24 24l62.9 0-81.9 105.3c-5.6 7.2-6.6 17-2.6 25.3S190.8 384 200 384l112 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-62.9 0 81.9-105.3c5.6-7.2 6.6-17 2.6-25.3S321.2 192 312 192l-112 0z"],
    "syringe": [576, 512, [128137], "f48e", "M497.5-17c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l15 15-46.1 46.1-63-63c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l7 7-78.1 78.1 41 41c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-41-41-46.1 46.1 41 41c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-41-41-37.7 37.7c-10.5 10.5-16.4 24.7-16.4 39.6l0 88.8-57 57c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l57-57 88.8 0c14.9 0 29.1-5.9 39.6-16.4l229.7-229.7 7 7c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-63-63 46.1-46.1 15 15c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-64-64z"],
    "shower-down": [384, 512, ["shower-alt"], "e24d", "M192 0c17.7 0 32 14.3 32 32l0 3.2c73 14.8 128 79.4 128 156.8 17.7 0 32 14.3 32 32s-14.3 32-32 32L32 256c-17.7 0-32-14.3-32-32s14.3-32 32-32C32 114.6 87 50 160 35.2l0-3.2c0-17.7 14.3-32 32-32zm52.8 423.4c1.9-4.5 6.3-7.4 11.2-7.4s9.2 2.9 11.2 7.4l18.2 42.4c1.8 4.1 2.7 8.6 2.7 13.1l0 1.2c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-1.2c0-4.5 .9-8.9 2.7-13.1l18.2-42.4zm-82.2-85.6l18.2-42.4c1.9-4.5 6.3-7.4 11.2-7.4s9.2 2.9 11.2 7.4l18.2 42.4c1.8 4.1 2.7 8.6 2.7 13.1l0 1.2c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-1.2c0-4.5 .9-8.9 2.7-13.1zm146.2-42.4c1.9-4.5 6.3-7.4 11.2-7.4s9.2 2.9 11.2 7.4l18.2 42.4c1.8 4.1 2.7 8.6 2.7 13.1l0 1.2c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-1.2c0-4.5 .9-8.9 2.7-13.1l18.2-42.4zM98.7 465.7l18.2-42.4c1.9-4.5 6.3-7.4 11.2-7.4s9.2 2.9 11.2 7.4l18.2 42.4c1.8 4.1 2.7 8.6 2.7 13.1l0 1.2c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-1.2c0-4.5 .9-8.9 2.7-13.1zM52.8 295.4c1.9-4.5 6.3-7.4 11.2-7.4s9.2 2.9 11.2 7.4l18.2 42.4c1.8 4.1 2.7 8.6 2.7 13.1l0 1.2c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-1.2c0-4.5 .9-8.9 2.7-13.1l18.2-42.4z"],
    "wheat-awn": [576, 512, ["wheat-alt"], "e2cd", "M79.7 234.6c6.2-4.1 14.7-3.4 20.1 2.1l46.1 46.1 6.1 6.7c19.7 23.8 26.3 55 19.2 83.9 31.7-7.7 66.2 1 90.6 25.3l46.1 46.1c6.2 6.2 6.2 16.4 0 22.6l-7.4 7.4c-37.5 37.5-98.3 37.5-135.8 0L134.1 444.3 49.4 529c-9.4 9.4-24.5 9.4-33.9 0-9.4-9.4-9.4-24.6 0-33.9l84.7-84.7-30.5-30.5c-37.5-37.5-37.5-98.3 0-135.7l7.4-7.4 2.5-2.1zm104-104c6.2-4.1 14.7-3.4 20.1 2.1l46.1 46.1 6.1 6.7c19.7 23.8 26.3 55 19.2 83.9 31.7-7.7 66.2 1 90.6 25.3l46.1 46.1c6.2 6.2 6.2 16.4 0 22.6l-7.4 7.4c-37.5 37.5-98.3 37.5-135.8 0l-94.9-94.9c-37.5-37.5-37.5-98.3 0-135.7l7.4-7.4 2.5-2.1zM495.2 15c9.4-9.4 24.6-9.4 34 0 8.8 8.8 9.3 22.7 1.6 32.2L529.2 49 414.7 163.4c7.7 1 15.2 3 22.5 5.9L495.5 111c9.4-9.4 24.6-9.4 34 0 8.8 8.8 9.3 22.7 1.6 32.1l-1.7 1.8-52.7 52.7 39 39c6.2 6.2 6.2 16.4 0 22.6l-7.4 7.4c-37.5 37.5-98.3 37.5-135.8 0l-94.9-94.9c-37.5-37.5-37.5-98.3 0-135.7l7.4-7.4 2.5-2.1c6.2-4.1 14.7-3.4 20.1 2.1l39 39 52.7-52.7c9.4-9.4 24.6-9.4 34 0 8.8 8.8 9.3 22.7 1.6 32.1l-1.7 1.8-58.3 58.3c2.8 7.1 4.7 14.5 5.7 22.1L495.2 15z"],
    "plane-up": [512, 512, [], "e22d", "M200 24c0-30.9 25.1-56 56-56s56 25.1 56 56l0 127.3 173.6 159.2c6.6 6.1 10.4 14.6 10.4 23.6l0 43.7c0 10.9-10.7 18.6-21.1 15.2l-162.9-54.3 0 99.7 66 52.8c3.8 3 6 7.6 6 12.5l0 19.8c0 10.4-9.8 18-19.9 15.5L256 512 147.9 539c-10.1 2.5-19.9-5.1-19.9-15.5l0-19.8c0-4.9 2.2-9.5 6-12.5l66-52.8 0-99.7-162.9 54.3C26.7 396.4 16 388.7 16 377.8l0-43.7c0-9 3.8-17.5 10.4-23.6L200 151.3 200 24z"],
    "circle-user-circle-check": [640, 512, [], "e79f", "M496 208c-77.5 0-144.3 45.9-174.6 112l-1.4 0-64 0c-47.4 0-88.9 25.8-111 64.2 35.2 39.2 86.2 63.8 143 63.8 7.4 0 14.6-.4 21.7-1.2 5.5 21.9 14.8 42.4 27.1 60.6-15.8 3-32.1 4.6-48.8 4.6-141.4 0-256-114.6-256-256S146.6 0 288 0c126.8 0 232.1 92.2 252.4 213.2-14.3-3.4-29.1-5.2-44.4-5.2zM288 272a72 72 0 1 0 0-144 72 72 0 1 0 0 144zm64 128a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm201.4-60.9c-7.1-5.2-17.2-3.6-22.4 3.5l-53 72.9-26.8-26.8c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l40 40c3.3 3.3 7.9 5 12.6 4.6s8.9-2.8 11.7-6.5l64-88c5.2-7.1 3.6-17.2-3.5-22.3z"],
    "bat": [576, 512, [], "f6b5", "M235.4 49.9l36.8 21c9.8 5.6 21.9 5.6 31.8 0l36.8-21c2.2-1.3 4.7-1.9 7.2-1.9 7 0 13.1 5 14.4 11.9l18.6 99.3 71.8-34.2c16.2-7.7 35.5-3.6 47.1 10 49.2 57.4 76.3 130.6 76.3 206.2l0 37.6c0 9.7-10.2 16-18.9 11.7l-63.8-31.9c-7.5-3.7-16.6-1.1-20.9 6.1l-29.8 49.7c-5.4 8.9-17.7 10.4-25 3.1l-36.6-36.6c-6.8-6.8-18.1-6.1-24 1.6l-56.2 73.1c-6.4 8.3-19 8.3-25.4 0l-56.2-73.1c-5.9-7.7-17.2-8.4-24-1.6l-36.6 36.6c-7.4 7.4-19.7 5.8-25-3.1l-29.8-49.7c-4.3-7.2-13.4-9.8-20.9-6.1L18.9 390.5c-8.7 4.3-18.9-2-18.9-11.7l0-37.6c0-75.6 27.1-148.8 76.3-206.2 11.6-13.6 30.9-17.7 47.1-10l71.8 34.2 18.6-99.3c1.3-6.9 7.3-11.9 14.4-11.9 2.5 0 5 .7 7.2 1.9z"],
    "align-center": [448, 512, [], "f037", "M352 64c0-17.7-14.3-32-32-32L128 32c-17.7 0-32 14.3-32 32s14.3 32 32 32l192 0c17.7 0 32-14.3 32-32zm96 128c0-17.7-14.3-32-32-32L32 160c-17.7 0-32 14.3-32 32s14.3 32 32 32l384 0c17.7 0 32-14.3 32-32zM0 448c0 17.7 14.3 32 32 32l384 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 416c-17.7 0-32 14.3-32 32zM352 320c0-17.7-14.3-32-32-32l-192 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l192 0c17.7 0 32-14.3 32-32z"],
    "hockey-puck": [512, 512, [], "f453", "M256 256C114.6 256 0 213 0 160s114.6-96 256-96 256 43 256 96-114.6 96-256 96zM0 352L0 242.7c16.9 12.3 37 22.2 58.1 30.1 53 19.9 123 31.2 197.9 31.2s144.9-11.3 197.9-31.2c21.2-7.9 41.2-17.8 58.1-30.1L512 352c0 53-114.6 96-256 96S0 405 0 352z"],
    "circle-arrow-left": [512, 512, ["arrow-circle-left"], "f0a8", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM135 239l80-80c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-39 39 150.1 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-150.1 0 39 39c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-80-80c-9.4-9.4-9.4-24.6 0-33.9z"],
    "chart-radar": [576, 512, [], "e0e7", "M33.5 291.8c-12.7-22.2-12.7-49.4 0-71.5L129.7 52.2C142.5 29.8 166.4 16 192.2 16l191.6 0c25.8 0 49.7 13.8 62.5 36.2l96.2 168.1c12.7 22.2 12.7 49.4 0 71.5L446.3 459.9c-12.8 22.4-36.7 36.2-62.5 36.2l-191.6 0c-25.8 0-49.7-13.8-62.5-36.2L33.5 291.8zM336 160c0-26.5-21.5-48-48-48s-48 21.5-48 48c0 6.7 1.4 13.1 3.9 18.9l-46.1 61.5c-1.9-.2-3.8-.3-5.7-.3-26.5 0-48 21.5-48 48s21.5 48 48 48c14.4 0 27.3-6.3 36.1-16.3l78.5 15.7c6.4 19 24.4 32.6 45.5 32.6 26.5 0 48-21.5 48-48 0-24.2-17.9-44.2-41.2-47.5l-33.1-82.8c6.4-8.2 10.3-18.5 10.3-29.7zM313.3 287.8l-75.8-15.2c-.4-1.2-.8-2.3-1.3-3.5l45.4-60.6 31.7 79.2z"],
    "arrow-progress": [512, 512, [], "e5df", "M230.8 33.8c9-3.7 19.3-1.7 26.2 5.2l40 40c9.4 9.4 9.4 24.6 0 33.9l-40 40c-6.9 6.9-17.2 8.9-26.2 5.2S216 145.7 216 136l0-8-104 0c-26.5 0-48 21.5-48 48s21.5 48 48 48l288 0c61.9 0 112 50.1 112 112 0 46.4-28.2 86.1-68.3 103.2-9.3 23.9-32.5 40.8-59.7 40.8-35.3 0-64-28.7-64-64s28.7-64 64-64c18.6 0 35.4 7.9 47 20.6 10.4-8.8 17-21.9 17-36.6 0-26.5-21.5-48-48-48l-288 0C50.1 288 0 237.9 0 176S50.1 64 112 64l104 0 0-8c0-9.7 5.8-18.5 14.8-22.2zM416 32a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM151.4 448c-11.1 19.1-31.7 32-55.4 32-35.3 0-64-28.7-64-64s28.7-64 64-64c23.7 0 44.4 12.9 55.4 32l32.6 0 0-8c0-9.7 5.8-18.5 14.8-22.2s19.3-1.7 26.2 5.2l40 40c9.4 9.4 9.4 24.6 0 33.9l-40 40c-6.9 6.9-17.2 8.9-26.2 5.2S184 465.7 184 456l0-8-32.6 0z"],
    "warehouse-full": [576, 512, ["warehouse-alt"], "f495", "M0 480L0 142.1c0-27.5 17.6-52 43.8-60.7L272.8 5.1c9.9-3.3 20.5-3.3 30.4 0L532.2 81.4c26.1 8.7 43.8 33.2 43.8 60.7L576 480c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-256c0-17.7-14.3-32-32-32L96 192c-17.7 0-32 14.3-32 32l0 256c0 17.7-14.3 32-32 32S0 497.7 0 480zM160 256l128 0c17.7 0 32 14.3 32 32l0 80c0 8.8 7.2 16 16 16l80 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-256 0c-17.7 0-32-14.3-32-32l0-192c0-17.7 14.3-32 32-32z"],
    "pen-swirl": [512, 512, [], "e214", "M448 256c0-11.4-1-22.5-2.9-33.4l52.5-51.4c9.3 26.5 14.4 55.1 14.4 84.8 0 88.4-71.6 160-160 160-13.8 0-27.2-1.7-40-5-17.1-4.4-27.4-21.8-23-39s21.8-27.4 39-23c7.6 2 15.7 3 24 3 53 0 96-43 96-96zM256 0c29.5 0 57.7 5 84.1 14.1L287.7 66.6C277.4 64.9 266.8 64 256 64 150 64 64 150 64 256s86 192 192 192c17.7 0 32 14.3 32 32s-14.3 32-32 32C114.6 512 0 397.4 0 256S114.6 0 256 0zM473.9 16l21.9 21.9c18.9 18.9 18.7 49.6-.4 68.2l-34.1 33.3-89.4-89.4 34-34.1c18.7-18.8 49.1-18.8 67.9 0zM200.5 221.8l137.6-137.7 89 89-139.5 136.6c-6.9 6.8-15.3 11.9-24.5 15l-71.5 23.9c-8.6 2.9-18.1 .6-24.6-5.8s-8.7-15.9-5.8-24.6L185 246.8c3.1-9.4 8.4-18 15.4-25z"],
    "truck-ladder": [640, 512, [], "e657", "M24 32l304 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-8 0 0 80 8 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 208c-13.3 0-24-10.7-24-24s10.7-24 24-24l8 0 0-80-8 0C10.7 80 0 69.3 0 56S10.7 32 24 32zM272 80l-32 0 0 80 32 0 0-80zm-80 0l-32 0 0 80 32 0 0-80zm-80 0l-32 0 0 80 32 0 0-80zM32 304c0-26.5 21.5-48 48-48l304 0 0-128c0-17.7 14.3-32 32-32l72.4 0c24.2 0 46.4 13.7 57.2 35.4l55.6 111.1c4.3 8.5 6.8 18.3 6.8 28.6l0 80.9c0 35.3-28.7 64-64 64l-3.3 0c-10.4 36.9-44.4 64-84.7 64s-74.2-27.1-84.7-64l-102.6 0c-10.4 36.9-44.4 64-84.7 64s-74.2-27.1-84.7-64L80 416c-26.5 0-48-21.5-48-48l0-64zM488.4 160l-40.4 0 0 96 88.4 0-48-96zM224 392a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zm232 40a40 40 0 1 0 0-80 40 40 0 1 0 0 80z"],
    "comment-image": [512, 512, [], "e148", "M256 480c141.4 0 256-107.5 256-240S397.4 0 256 0 0 107.5 0 240c0 54.3 19.2 104.3 51.6 144.5L2.8 476.8c-4.8 9-3.3 20 3.6 27.5s17.8 9.8 27.1 5.8l118.4-50.7C183.7 472.6 218.9 480 256 480zM128 144a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm28.6 192c-15.8 0-28.6-12.8-28.6-28.6 0-7.3 2.8-14.4 7.9-19.7l96.8-101.8c6-6.4 14.4-9.9 23.2-9.9l.3 0c8.8 0 17.1 3.6 23.2 9.9l96.8 101.8c5.1 5.3 7.9 12.4 7.9 19.7 0 15.8-12.8 28.6-28.6 28.6l-198.8 0z"],
    "plug-circle-bolt": [640, 512, [], "e55b", "M192-32c17.7 0 32 14.3 32 32l0 96 128 0 0-96c0-17.7 14.3-32 32-32s32 14.3 32 32l0 96 64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l0 48.7c-98.6 8.1-176 90.7-176 191.3 0 27.3 5.7 53.3 16 76.9l0 3.1c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-66.7C165.2 398.1 96 319.1 96 224l0-64c-17.7 0-32-14.3-32-32S78.3 96 96 96l64 0 0-96c0-17.7 14.3-32 32-32zM352 400a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm177.4-77c-5.8-4.2-13.8-4-19.4 .5l-80 64c-5.3 4.2-7.4 11.4-5.1 17.8S433.2 416 440 416l32.9 0-15.9 42.4c-2.5 6.7-.2 14.3 5.6 18.6s13.8 4 19.4-.5l80-64c5.3-4.2 7.4-11.4 5.1-17.8S558.8 384 552 384l-32.9 0 15.9-42.4c2.5-6.7 .2-14.3-5.6-18.6z"],
    "jeans": [512, 512, [], "e6d2", "M90.9 32.4C94.5 13.6 111 0 130.2 0L382.7 0c19.2 0 35.7 13.6 39.3 32.4l4.5 23.6-340.1 0 4.5-23.6zM78.7 96l61.2 0c-3.9 29.4-29 52-59.5 52l-11.8 0 10-52zM9.7 454.6L61 188 80.4 188c52.5 0 95.6-40.5 99.7-92l56.3 0 0 196.3-38.2 198.5c-4.2 21.7-25.1 35.9-46.8 31.7l-110-21.2c-21.7-4.2-35.9-25.1-31.7-46.8zM276.4 96l56.3 0c4.1 51.5 47.1 92 99.7 92l19.5 0 51.3 266.6c4.2 21.7-10 42.7-31.7 46.8l-110 21.2c-21.7 4.2-42.7-10-46.8-31.7l-38.2-198.5 0-196.3zM373 96l61.2 0 10 52-11.8 0c-30.4 0-55.6-22.6-59.5-52z"],
    "grid-5": [448, 512, [], "e199", "M16 32C7.2 32 0 39.2 0 48L0 72c0 8.8 7.2 16 16 16l24 0c8.8 0 16-7.2 16-16l0-24c0-8.8-7.2-16-16-16L16 32zM0 146l0 24c0 8.8 7.2 16 16 16l24 0c8.8 0 16-7.2 16-16l0-24c0-8.8-7.2-16-16-16l-24 0c-8.8 0-16 7.2-16 16zm16 82c-8.8 0-16 7.2-16 16l0 24c0 8.8 7.2 16 16 16l24 0c8.8 0 16-7.2 16-16l0-24c0-8.8-7.2-16-16-16l-24 0zM0 342l0 24c0 8.8 7.2 16 16 16l24 0c8.8 0 16-7.2 16-16l0-24c0-8.8-7.2-16-16-16l-24 0c-8.8 0-16 7.2-16 16zm0 98l0 24c0 8.8 7.2 16 16 16l24 0c8.8 0 16-7.2 16-16l0-24c0-8.8-7.2-16-16-16l-24 0c-8.8 0-16 7.2-16 16zm98 0l0 24c0 8.8 7.2 16 16 16l24 0c8.8 0 16-7.2 16-16l0-24c0-8.8-7.2-16-16-16l-24 0c-8.8 0-16 7.2-16 16zm114-16c-8.8 0-16 7.2-16 16l0 24c0 8.8 7.2 16 16 16l24 0c8.8 0 16-7.2 16-16l0-24c0-8.8-7.2-16-16-16l-24 0zm82 16l0 24c0 8.8 7.2 16 16 16l24 0c8.8 0 16-7.2 16-16l0-24c0-8.8-7.2-16-16-16l-24 0c-8.8 0-16 7.2-16 16zm114-16c-8.8 0-16 7.2-16 16l0 24c0 8.8 7.2 16 16 16l24 0c8.8 0 16-7.2 16-16l0-24c0-8.8-7.2-16-16-16l-24 0zM114 326c-8.8 0-16 7.2-16 16l0 24c0 8.8 7.2 16 16 16l24 0c8.8 0 16-7.2 16-16l0-24c0-8.8-7.2-16-16-16l-24 0zm82 16l0 24c0 8.8 7.2 16 16 16l24 0c8.8 0 16-7.2 16-16l0-24c0-8.8-7.2-16-16-16l-24 0c-8.8 0-16 7.2-16 16zm114-16c-8.8 0-16 7.2-16 16l0 24c0 8.8 7.2 16 16 16l24 0c8.8 0 16-7.2 16-16l0-24c0-8.8-7.2-16-16-16l-24 0zm82 16l0 24c0 8.8 7.2 16 16 16l24 0c8.8 0 16-7.2 16-16l0-24c0-8.8-7.2-16-16-16l-24 0c-8.8 0-16 7.2-16 16zM98 244l0 24c0 8.8 7.2 16 16 16l24 0c8.8 0 16-7.2 16-16l0-24c0-8.8-7.2-16-16-16l-24 0c-8.8 0-16 7.2-16 16zm114-16c-8.8 0-16 7.2-16 16l0 24c0 8.8 7.2 16 16 16l24 0c8.8 0 16-7.2 16-16l0-24c0-8.8-7.2-16-16-16l-24 0zm82 16l0 24c0 8.8 7.2 16 16 16l24 0c8.8 0 16-7.2 16-16l0-24c0-8.8-7.2-16-16-16l-24 0c-8.8 0-16 7.2-16 16zm114-16c-8.8 0-16 7.2-16 16l0 24c0 8.8 7.2 16 16 16l24 0c8.8 0 16-7.2 16-16l0-24c0-8.8-7.2-16-16-16l-24 0zM114 130c-8.8 0-16 7.2-16 16l0 24c0 8.8 7.2 16 16 16l24 0c8.8 0 16-7.2 16-16l0-24c0-8.8-7.2-16-16-16l-24 0zm82 16l0 24c0 8.8 7.2 16 16 16l24 0c8.8 0 16-7.2 16-16l0-24c0-8.8-7.2-16-16-16l-24 0c-8.8 0-16 7.2-16 16zm114-16c-8.8 0-16 7.2-16 16l0 24c0 8.8 7.2 16 16 16l24 0c8.8 0 16-7.2 16-16l0-24c0-8.8-7.2-16-16-16l-24 0zm82 16l0 24c0 8.8 7.2 16 16 16l24 0c8.8 0 16-7.2 16-16l0-24c0-8.8-7.2-16-16-16l-24 0c-8.8 0-16 7.2-16 16zM98 48l0 24c0 8.8 7.2 16 16 16l24 0c8.8 0 16-7.2 16-16l0-24c0-8.8-7.2-16-16-16l-24 0c-8.8 0-16 7.2-16 16zM212 32c-8.8 0-16 7.2-16 16l0 24c0 8.8 7.2 16 16 16l24 0c8.8 0 16-7.2 16-16l0-24c0-8.8-7.2-16-16-16l-24 0zm82 16l0 24c0 8.8 7.2 16 16 16l24 0c8.8 0 16-7.2 16-16l0-24c0-8.8-7.2-16-16-16l-24 0c-8.8 0-16 7.2-16 16zM408 32c-8.8 0-16 7.2-16 16l0 24c0 8.8 7.2 16 16 16l24 0c8.8 0 16-7.2 16-16l0-24c0-8.8-7.2-16-16-16l-24 0z"],
    "pipe-section": [640, 512, [], "e438", "M32 96c17.7 0 32 14.3 32 32l512 0c0-17.7 14.3-32 32-32s32 14.3 32 32l0 256c0 17.7-14.3 32-32 32s-32-14.3-32-32L64 384c0 17.7-14.3 32-32 32S0 401.7 0 384L0 128c0-17.7 14.3-32 32-32z"],
    "restroom": [640, 512, [], "f7bd", "M80 48a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm40 304l0 128c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-154.8c-8.1 9.2-21.1 13.2-33.5 9.4-16.9-5.3-26.3-23.2-21-40.1l29.7-95.2C44.4 156.9 83.6 128 128 128s83.6 28.9 96.8 71.2l29.7 95.2c5.3 16.9-4.1 34.8-21 40.1-12.4 3.9-25.4-.2-33.5-9.4L200 480c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-128-16 0zM320 0c13.3 0 24 10.7 24 24l0 464c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-464c0-13.3 10.7-24 24-24zM464 48a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM440 480l0-96-17.8 0c-10.9 0-18.6-10.7-15.2-21.1l9-26.9c-3.2 0-6.4-.5-9.5-1.5-16.9-5.3-26.3-23.2-21-40.1l29.7-95.2C428.4 156.9 467.6 128 512 128s83.6 28.9 96.8 71.2l29.7 95.2c5.3 16.9-4.1 34.8-21 40.1-3.2 1-6.4 1.5-9.5 1.5l9 26.9c3.5 10.4-4.3 21.1-15.2 21.1l-17.8 0 0 96c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-96-16 0 0 96c0 17.7-14.3 32-32 32s-32-14.3-32-32z"],
    "reflect-both": [448, 512, [], "e66f", "M87 73L207 193c9.4 9.4 24.6 9.4 33.9 0L361 73c6.9-6.9 8.9-17.2 5.2-26.2S353.7 32 344 32L104 32c-9.7 0-18.5 5.8-22.2 14.8S80.2 66.1 87 73zM41 119c-6.9-6.9-17.2-8.9-26.2-5.2S0 126.3 0 136L0 376c0 9.7 5.8 18.5 14.8 22.2S34.1 399.8 41 393L161 273c9.4-9.4 9.4-24.6 0-33.9L41 119zM87 439c-6.9 6.9-8.9 17.2-5.2 26.2S94.3 480 104 480l240 0c9.7 0 18.5-5.8 22.2-14.8s1.7-19.3-5.2-26.2L241 319c-9.4-9.4-24.6-9.4-33.9 0L87 439zM433.2 113.8c-9-3.7-19.3-1.7-26.2 5.2L287 239c-9.4 9.4-9.4 24.6 0 33.9L407 393c6.9 6.9 17.2 8.9 26.2 5.2S448 385.7 448 376l0-240c0-9.7-5.8-18.5-14.8-22.2z"],
    "gear-code": [512, 512, [], "e5e8", "M195.1 9.5C198.1-5.3 211.2-16 226.4-16l59.8 0c15.2 0 28.3 10.7 31.3 25.5L332 79.5c14.1 6 27.3 13.7 39.3 22.8l67.8-22.5c14.4-4.8 30.2 1.2 37.8 14.4l29.9 51.8c7.6 13.2 4.9 29.8-6.5 39.9L447 233.3c.9 7.4 1.3 15 1.3 22.7s-.5 15.3-1.3 22.7l53.4 47.5c11.4 10.1 14 26.8 6.5 39.9l-29.9 51.8c-7.6 13.1-23.4 19.2-37.8 14.4l-67.8-22.5c-12.1 9.1-25.3 16.7-39.3 22.8l-14.4 69.9c-3.1 14.9-16.2 25.5-31.3 25.5l-59.8 0c-15.2 0-28.3-10.7-31.3-25.5l-14.4-69.9c-14.1-6-27.2-13.7-39.3-22.8L73.5 432.3c-14.4 4.8-30.2-1.2-37.8-14.4L5.8 366.1c-7.6-13.2-4.9-29.8 6.5-39.9l53.4-47.5c-.9-7.4-1.3-15-1.3-22.7s.5-15.3 1.3-22.7L12.3 185.8c-11.4-10.1-14-26.8-6.5-39.9L35.7 94.1c7.6-13.2 23.4-19.2 37.8-14.4l67.8 22.5c12.1-9.1 25.3-16.7 39.3-22.8L195.1 9.5zm104.7 147c2.5-10.8-4.2-21.5-15-24s-21.5 4.2-24 15l-48 208c-2.5 10.8 4.2 21.5 15 24s21.5-4.2 24-15l48-208zM182.5 238.1c7.8-7.8 7.8-20.5 0-28.3s-20.5-7.8-28.3 0l-32 32c-7.8 7.8-7.8 20.5 0 28.3l32 32c7.8 7.8 20.5 7.8 28.3 0s7.8-20.5 0-28.3l-17.9-17.9 17.9-17.9zm176-28.3c-7.8-7.8-20.5-7.8-28.3 0s-7.8 20.5 0 28.3L348 256 330.2 273.9c-7.8 7.8-7.8 20.5 0 28.3s20.5 7.8 28.3 0l32-32c7.8-7.8 7.8-20.5 0-28.3l-32-32z"],
    "curling-stone": [512, 512, [129356, "curling"], "f44a", "M512 384c0 53-43 96-96 96L96 480c-53 0-96-43-96-96l0-8 512 0 0 8zM352 32c17.7 0 32 14.3 32 32s-14.3 32-32 32L224 96c-17.7 0-32 14.3-32 32l0 32 192 0c35.3 0 64 28.7 64 64l0 5.6c37.3 13.2 64 48.6 64 90.4l0 8-512 0 0-8c0-41.8 26.7-77.2 64-90.4l0-5.6c0-35.3 28.7-64 64-64l0-32c0-53 43-96 96-96l128 0z"],
    "anchor-lock": [640, 512, [], "e4ad", "M320.5 96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm-32-96c-53 0-96 43-96 96 0 41.8 26.7 77.4 64 90.5l0 257.9c-62.9-14.3-110.2-69.7-111.9-136.5l16.1 14.1c10 8.7 25.1 7.7 33.9-2.3s7.7-25.1-2.3-33.9l-64-56c-9-7.9-22.6-7.9-31.6 0l-64 56c-10 8.7-11 23.9-2.3 33.9s23.9 11 33.9 2.3l16.2-14.2c2.1 113.1 94.4 204.1 208 204.1 28.3 0 55.4-5.7 80-15.9l0-.2 0-72.2c-14.4 9.6-30.6 16.7-48 20.7l0-257.9c37.3-13.2 64-48.7 64-90.5 0-53-43-96-96-96zm272 304.1l0 47.9-64 0 0-47.9c0-17.7 14.3-32 32-32s32 14.3 32 32zM416.5 400l0 96c0 26.5 21.5 48 48 48l128 0c26.5 0 48-21.5 48-48l0-96c0-20.9-13.4-38.7-32-45.3l0-50.6c0-44.2-35.8-80-80-80s-80 35.8-80 80l0 50.6c-18.6 6.6-32 24.4-32 45.3z"],
    "timeline": [576, 512, [], "e29c", "M160 169.3c28.3-12.3 48-40.5 48-73.3 0-44.2-35.8-80-80-80S48 51.8 48 96c0 32.8 19.7 61 48 73.3l0 54.7-64 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l224 0 0 54.7c-28.3 12.3-48 40.5-48 73.3 0 44.2 35.8 80 80 80s80-35.8 80-80c0-32.8-19.7-61-48-73.3l0-54.7 224 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0 0-54.7c28.3-12.3 48-40.5 48-73.3 0-44.2-35.8-80-80-80s-80 35.8-80 80c0 32.8 19.7 61 48 73.3l0 54.7-256 0 0-54.7z"],
    "briefcase-blank": [512, 512, [], "e0c8", "M192 56l0 40 128 0 0-40c0-4.4-3.6-8-8-8L200 48c-4.4 0-8 3.6-8 8zM144 96l0-40c0-30.9 25.1-56 56-56L312 0c30.9 0 56 25.1 56 56l0 40 80 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 160c0-35.3 28.7-64 64-64l80 0z"],
    "coin-front": [512, 512, [], "e3fc", "M0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zM256 112a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm0 336a192 192 0 1 0 0-384 192 192 0 1 0 0 384zm24-240c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 96c0 13.3 10.7 24 24 24s24-10.7 24-24l0-96z"],
    "calendar-star": [448, 512, [], "f736", "M128 0c17.7 0 32 14.3 32 32l0 32 128 0 0-32c0-17.7 14.3-32 32-32s32 14.3 32 32l0 32 32 0c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 128C0 92.7 28.7 64 64 64l32 0 0-32c0-17.7 14.3-32 32-32zM238.3 189.1c-5.9-11.9-22.8-11.9-28.7 0l-23.3 47.2-52 7.6c-13.1 1.9-18.4 18-8.9 27.3l37.7 36.7-8.9 51.8c-2.2 13.1 11.5 23 23.2 16.9L224 352 270.5 376.5c11.7 6.2 25.5-3.8 23.2-16.9l-8.9-51.8 37.7-36.7c9.5-9.3 4.3-25.4-8.9-27.3l-52-7.6-23.3-47.2z"],
    "pen-circle": [512, 512, [], "e20e", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM357.8 139.7l14.4 14.4c15.6 15.6 15.6 40.9 0 56.6l-23.8 23.8-71-71 23.8-23.8c15.6-15.6 40.9-15.6 56.6 0zM151.9 289l91.5-91.6 71 71-91.6 91.5c-4.1 4.1-9.2 7-14.9 8.4l-60.1 15c-5.5 1.4-11.2-.2-15.2-4.2s-5.6-9.7-4.2-15.2l15-60.1c1.4-5.6 4.3-10.8 8.4-14.9z"],
    "lightbulb": [384, 512, [128161], "f0eb", "M292.9 384c7.3-22.3 21.9-42.5 38.4-59.9 32.7-34.4 52.7-80.9 52.7-132.1 0-106-86-192-192-192S0 86 0 192c0 51.2 20 97.7 52.7 132.1 16.5 17.4 31.2 37.6 38.4 59.9l201.7 0zM288 432l-192 0 0 16c0 44.2 35.8 80 80 80l32 0c44.2 0 80-35.8 80-80l0-16zM184 112c-39.8 0-72 32.2-72 72 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-66.3 53.7-120 120-120 13.3 0 24 10.7 24 24s-10.7 24-24 24z"],
    "page-caret-down": [384, 512, ["file-caret-down"], "e429", "M64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-277.5c0-17-6.7-33.3-18.7-45.3L258.7 18.7C246.7 6.7 230.5 0 213.5 0L64 0zm36.2 252.9c-2.7-3.2-4.2-7.2-4.2-11.3 0-9.7 7.9-17.6 17.6-17.6l156.9 0c9.7 0 17.6 7.9 17.6 17.6 0 4.2-1.5 8.2-4.2 11.3l-78.7 93c-3.3 3.9-8.1 6.1-13.2 6.1s-9.9-2.2-13.2-6.1l-78.7-93z"],
    "book-blank": [448, 512, [128213, 128215, 128216, 128217, "book-alt"], "f5d9", "M384 512L96 512c-53 0-96-43-96-96L0 96C0 43 43 0 96 0L400 0c26.5 0 48 21.5 48 48l0 288c0 20.9-13.4 38.7-32 45.3l0 66.7c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32 0zM96 384c-17.7 0-32 14.3-32 32s14.3 32 32 32l256 0 0-64-256 0z"],
    "trash-undo": [448, 512, ["trash-arrow-turn-left"], "f895", "M136.7 5.9L128 32 32 32C14.3 32 0 46.3 0 64S14.3 96 32 96l384 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-96 0-8.7-26.1C306.9-7.2 294.7-16 280.9-16L167.1-16c-13.8 0-26 8.8-30.4 21.9zM416 144L32 144 53.1 467.1C54.7 492.4 75.7 512 101 512L347 512c25.3 0 46.3-19.6 47.9-44.9L416 144zM217.8 215.9c8.9 9.9 8.1 25-1.8 33.9L182.5 280 240 280c48.6 0 88 39.4 88 88l0 40c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-40c0-22.1-17.9-40-40-40l-57.5 0 33.5 30.2c9.9 8.9 10.7 24 1.8 33.9s-24 10.7-33.9 1.8l-80-72c-5.1-4.6-7.9-11-7.9-17.8s2.9-13.3 7.9-17.8l80-72c9.9-8.9 25-8.1 33.9 1.8z"],
    "subtitles": [512, 512, [], "e60f", "M64 64C28.7 64 0 92.7 0 128L0 384c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L64 64zM88 240l176 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L88 288c-13.3 0-24-10.7-24-24s10.7-24 24-24zm272 0l64 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-64 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zM88 336l64 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-64 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zm160 0l176 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-176 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"],
    "wave-triangle": [512, 512, [], "f89a", "M162.1 64.1c10.5 .7 19.9 6.5 25.3 15.5L355.8 360.1 455 236c11-13.8 31.2-16 45-5s16 31.2 5 45L377 436c-6.5 8.2-16.7 12.6-27.1 11.9s-19.9-6.5-25.3-15.5L156.2 151.9 57 276c-11 13.8-31.2 16-45 5s-16-31.2-5-45L135 76c6.5-8.2 16.7-12.6 27.1-11.9z"],
    "foot-wing": [576, 512, [], "e834", "M245.9-32c94.6 0 171.2 76.7 171.2 171.2 0 39.7-13.8 78.1-38.9 108.7l-3.9 4.7 73.7 147.3 46.9 5.9c46.3 5.8 81.1 45.2 81.1 91.8 0 25.6-20.8 46.3-46.3 46.3l-142.2 0c-23.2 0-46-6.3-65.8-18.2L111.3 399.6c-41.5-24.9-57.6-76.4-39-120l4.2-8.6 25.6-46.6C79.1 208.6 64 182.1 64 152l0-27.4C27.1 114.1 0 80.3 0 40L0 13.7C0-11.5 20.5-32 45.7-32l200.2 0zM48 40c0 22.1 17.9 40 40 40l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-120 0 0 24c0 22.1 17.9 40 40 40l61.1 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L152 240c-1.2 0-2.4-.1-3.5-.2l-18.7 34 53.5 32.1c32.8 19.7 75.1 12.4 99.4-17.2l58.5-71.3c18.1-22.1 28-49.7 28-78.3 0-68.1-55.2-123.2-123.2-123.2L48 16 48 40z"],
    "gauge-circle-plus": [640, 512, [], "e498", "M288 0c126.8 0 232.1 92.2 252.4 213.2-14.3-3.4-29.1-5.2-44.4-5.2-70.9 0-132.8 38.4-166.1 95.6-5.3-4.6-11.3-8.3-17.9-11L312 120c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 172.7c-23.5 9.5-40 32.5-40 59.3 0 35.3 28.7 64 64 64 5.7 0 11.2-.7 16.5-2.1 2.5 34.5 14 66.4 32.3 93.5-15.8 3-32.1 4.6-48.8 4.6-141.4 0-256-114.6-256-256S146.6 0 288 0zM176 176a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm-16 80a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM432 144a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm64 112a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm16 80c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 48-48 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l48 0 0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48 48 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-48 0 0-48z"],
    "film-music": [640, 512, [], "e769", "M64 96c0-35.3 28.7-64 64-64l320 0c35.3 0 64 28.7 64 64l0 102.7-100.9 18.3c-34.2 6.2-59.1 36-59.1 70.8l0 115.9c-15.3 3.8-29.7 10.5-42.1 19.7-17.1 12.8-31.9 32.2-36.5 56.5L128 480c-35.3 0-64-28.7-64-64L64 96zm48 272l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm0-128l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm0-128l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zM416 96c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0zM624 255.9l0 208c0 23.3-18 35.4-29.1 40.5-11.9 5.4-25.4 7.5-34.9 7.5s-22.9-2.1-34.9-7.5c-11.1-5-29.1-17.2-29.1-40.5s18-35.4 29.1-40.5c11.9-5.4 25.4-7.5 34.9-7.5 4.6 0 10.1 .5 16 1.6l0-84.9-128 23.3 0 139.9c0 23.3-18 35.4-29.1 40.5-11.9 5.4-25.4 7.5-34.9 7.5s-22.9-2.1-34.9-7.5c-11.1-5-29.1-17.2-29.1-40.5s18-35.4 29.1-40.5c11.9-5.4 25.4-7.5 34.9-7.5 4.6 0 10.1 .5 16 1.6l0-161.6c0-11.6 8.3-21.5 19.7-23.6l176-32c7-1.3 14.2 .6 19.7 5.2s8.6 11.3 8.6 18.4z"],
    "head-side": [512, 512, [], "f6e9", "M329.7 448c-5.1 0-9.7 3.7-9.7 8.8l0 7.2c0 26.5-21.5 48-48 48l-160 0c-26.5 0-48-21.5-48-48l0-63.6c0-12.6-5.1-24.5-13.1-34.2-31.8-38.7-50.9-88.2-50.9-142.2 0-123.7 100.3-224 224-224 112.7 0 206 83.3 221.7 191.7 .4 3 1.7 5.9 3.6 8.3l35.8 42.9c7 8.4 10.9 19.1 10.9 30.1 0 25.9-21 47-47 47l-1 0c-8.8 0-16 7.2-16 16l0 48c0 35.3-28.7 64-64 64l-38.3 0zM320 224a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "octagon-equals": [512, 512, [], "e6b3", "M143.4 18.8c12-12 28.3-18.7 45.3-18.7l135.6 0c17 0 33.3 6.7 45.3 18.7L493.6 143c12 12 18.7 28.3 18.7 45.3l0 135.6c0 17-6.7 33.3-18.7 45.3L369.5 493.2c-12 12-28.3 18.7-45.3 18.7l-135.6 0c-17 0-33.3-6.7-45.3-18.7L19.2 369C7.2 357 .5 340.8 .5 323.8l0-135.6c0-17 6.7-33.3 18.7-45.3L143.4 18.8zm17 181.2c0 13.3 10.7 24 24 24l144 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-144 0c-13.3 0-24 10.7-24 24zm0 112c0 13.3 10.7 24 24 24l144 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-144 0c-13.3 0-24 10.7-24 24z"],
    "chevrons-left": [448, 512, ["chevron-double-left"], "f323", "M9.4 233.4c-12.5 12.5-12.5 32.8 0 45.3l192 192c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L77.3 256 246.6 86.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-192 192zm384-192l-192 192c-12.5 12.5-12.5 32.8 0 45.3l192 192c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L269.3 256 438.6 86.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0z"],
    "circle-arrow-right": [512, 512, ["arrow-circle-right"], "f0a9", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm41-159c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l39-39-150.1 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l150.1 0-39-39c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l80 80c9.4 9.4 9.4 24.6 0 33.9l-80 80z"],
    "game-board": [448, 512, [], "f867", "M0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm144 0l0 80 80 0 0-80-80 0zm0 160l0-80-80 0 0 80 80 0zm80 0l-80 0 0 80-80 0 0 80 80 0 0-80 80 0 0 80 80 0 0-80 80 0 0-80-80 0 0-80 80 0 0-80-80 0 0 80-80 0 0 80zm0 0l80 0 0 80-80 0 0-80z"],
    "file-chart-column": [384, 512, ["file-chart-line"], "f659", "M0 64C0 28.7 28.7 0 64 0L213.5 0c17 0 33.3 6.7 45.3 18.7L365.3 125.3c12 12 18.7 28.3 18.7 45.3L384 448c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zm208-5.5l0 93.5c0 13.3 10.7 24 24 24L325.5 176 208 58.5zM208 280c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 144c0 13.3 10.7 24 24 24s24-10.7 24-24l0-144zm96 32c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 112c0 13.3 10.7 24 24 24s24-10.7 24-24l0-112zM112 344c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 80c0 13.3 10.7 24 24 24s24-10.7 24-24l0-80z"],
    "custard": [512, 512, [127854], "e403", "M364.7 64c30 0 56 20.8 62.5 50.1l13.4 60.3c-21.6-7.3-48.7-14.4-72.5-14.4-28.2 0-49.1 10-65.4 17.9l-1 .5C284.8 186.4 272.7 192 256 192s-28.8-5.6-45.6-13.6l-1-.5c-16.3-7.9-37.2-17.9-65.4-17.9-23.8 0-50.9 7.2-72.5 14.4l13.4-60.3C91.4 84.8 117.3 64 147.3 64l217.3 0zM32.3 350.9L59 230.3c5.7-2.4 12.5-5 20-7.7 21.9-7.9 46.6-14.6 65-14.6 16.7 0 28.8 5.6 45.6 13.6l1 .5C206.9 230 227.8 240 256 240s49.1-10 65.4-17.9l1-.5c16.8-8.1 28.9-13.6 45.6-13.6 18.3 0 43 6.7 65 14.6 7.5 2.7 14.3 5.4 20 7.7L480 352 32.3 350.9zM24 400l464 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 448c-13.3 0-24-10.7-24-24s10.7-24 24-24z"],
    "block-question": [448, 512, [], "e3dd", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm73.8 149.3c7.9-22.3 29.1-37.3 52.8-37.3l58.3 0c34.9 0 63.1 28.3 63.1 63.1 0 22.6-12.1 43.5-31.7 54.8L248 280.4c-.2 13-10.9 23.6-24 23.6-13.3 0-24-10.7-24-24l0-13.5c0-8.6 4.6-16.5 12.1-20.8l44.3-25.4c4.7-2.7 7.6-7.7 7.6-13.1 0-8.4-6.8-15.1-15.1-15.1l-58.3 0c-3.4 0-6.4 2.1-7.5 5.3l-.4 1.2c-4.4 12.5-18.2 19-30.6 14.6s-19-18.2-14.6-30.6l.4-1.2zM192 368a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM48 104a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM376 80a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM48 408a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm328-24a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"],
    "mars-and-venus": [512, 512, [9893], "f224", "M368 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l112 0c17.7 0 32 14.3 32 32l0 112c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-34.7-63 63c19.5 28.4 31 62.7 31 99.8 0 86.3-62.1 158.1-144 173.1l0 34.9 32 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32 0 0 32c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-32-32 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l32 0 0-34.9c-81.9-15-144-86.8-144-173.1 0-97.2 78.8-176 176-176 37 0 71.4 11.4 99.8 31l63-63-34.7 0zM352 208a112 112 0 1 0 -224 0 112 112 0 1 0 224 0z"],
    "network-wired": [576, 512, [], "f6ff", "M248 88l80 0 0 48-80 0 0-48zm-8-56c-26.5 0-48 21.5-48 48l0 64c0 26.5 21.5 48 48 48l16 0 0 32-224 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l96 0 0 32-16 0c-26.5 0-48 21.5-48 48l0 64c0 26.5 21.5 48 48 48l96 0c26.5 0 48-21.5 48-48l0-64c0-26.5-21.5-48-48-48l-16 0 0-32 192 0 0 32-16 0c-26.5 0-48 21.5-48 48l0 64c0 26.5 21.5 48 48 48l96 0c26.5 0 48-21.5 48-48l0-64c0-26.5-21.5-48-48-48l-16 0 0-32 96 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-224 0 0-32 16 0c26.5 0 48-21.5 48-48l0-64c0-26.5-21.5-48-48-48l-96 0zM448 376l8 0 0 48-80 0 0-48 72 0zm-256 0l8 0 0 48-80 0 0-48 72 0z"],
    "face-confused": [512, 512, [], "e36d", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM203.2 385.6l-12.8 9.6c-10.6 8-25.6 5.8-33.6-4.8s-5.8-25.6 4.8-33.6l12.8-9.6c37.4-28 82.9-43.2 129.6-43.2l40 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-40 0c-36.3 0-71.7 11.8-100.8 33.6zM144 208a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm192-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "building-shield": [576, 512, [], "e4d8", "M96 0C60.7 0 32 28.7 32 64l0 384c0 35.3 28.7 64 64 64l201.2 0c-12.5-14.7-23.2-30.8-31.8-48l-89.5 0 0-80c0-17.7 14.3-32 32-32l32 0 0-26.7c0-18.1 6.1-35.2 16.6-48.8-.4-1.4-.6-2.9-.6-4.5l0-32c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 1 86.7-28.9c3.1-1 6.2-1.8 9.3-2.5L416 64c0-35.3-28.7-64-64-64L96 0zm32 112c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM272 96l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM128 240c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM445.3 488.5l-13.3 6.3 0-188.1 96 32 0 19.6c0 55.8-32.2 106.5-82.7 130.3zM421.9 259.5l-112 37.3c-13.1 4.4-21.9 16.6-21.9 30.4l0 31.1c0 74.4 43 142.1 110.2 173.7l18.5 8.7c4.8 2.2 10 3.4 15.2 3.4s10.5-1.2 15.2-3.4l18.5-8.7C533 500.3 576 432.6 576 358.2l0-31.1c0-13.8-8.8-26-21.9-30.4l-112-37.3c-6.6-2.2-13.7-2.2-20.2 0z"],
    "bed-empty": [576, 512, [128719], "f8f9", "M64 64c0-17.7-14.3-32-32-32S0 46.3 0 64L0 448c0 17.7 14.3 32 32 32s32-14.3 32-32l0-64 448 0 0 64c0 17.7 14.3 32 32 32s32-14.3 32-32l0-160c0-53-43-96-96-96L64 192 64 64z"],
    "grill-hot": [448, 512, [], "e5a5", "M104-64c13.3 0 24 10.7 24 24 0 9 3.6 17.6 9.9 24L168 14.1c15.4 15.4 24 36.2 24 57.9 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-9-3.6-17.6-9.9-24L104 17.9C88.6 2.6 80-18.3 80-40 80-53.3 90.7-64 104-64zM0 174.3C0 157.6 13.6 144 30.3 144l387.5 0c16.7 0 30.3 13.6 30.3 30.3 0 80.7-49.4 149.9-119.6 179l53.7 125.2c5.2 12.2-.4 26.3-12.6 31.5s-26.3-.4-31.5-12.6L316.7 448 160 448c0 35.3-28.7 64-64 64s-64-28.7-64-64 28.7-64 64-64c3.4 0 6.8 .3 10.1 .8l13.5-31.5C49.4 324.2 0 255 0 174.3zM151.8 400l144.4 0-14.5-33.9c-8.9 1.3-18.1 1.9-27.4 1.9l-60.5 0c-9.3 0-18.4-.7-27.4-1.9L151.8 400zM96 472a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM240-40c0 9 3.6 17.6 9.9 24L280 14.1c15.4 15.4 24 36.2 24 57.9 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-9-3.6-17.6-9.9-24L216 17.9c-15.4-15.4-24-36.2-24-57.9 0-13.3 10.7-24 24-24s24 10.7 24 24z"],
    "ear-waveform": [640, 512, [], "e75d", "M473.4 242.1c-5.6-1.4-11.4-2.1-17.4-2.1-11.9 0-23.1 2.9-33 8-4.4 2.3-8.5 4.9-12.3 8-10.5 8.5-18.6 19.9-23 33-3.8-.6-7.8-1-11.8-1-39.8 0-72 32.2-72 72l0 112c0 6 .7 11.8 2.1 17.3-20.9 14.5-46.2 22.7-72.8 22.7l-9.3 0c-70.7 0-128-57.3-128-128l0-192C96 86 182 0 288 0S480 86 480 192c0 17.3-2.3 34.1-6.6 50.1zM416 198.8l0-6.8c0-70.7-57.3-128-128-128S160 121.3 160 192l0 40c0 13.3 10.7 24 24 24l16 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-16 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l16 0c39.8 0 72-32.2 72-72 0-37.1-28-67.6-64-71.6l0-16.4c0-44.2 35.8-80 80-80s80 35.8 80 80l0 8c0 8.4 4.3 15.8 10.9 20.1 10.9-9.2 23.4-16.4 37.1-21.3zM456 288c13.3 0 24 10.7 24 24l0 208c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-208c0-13.3 10.7-24 24-24zm80 32c13.3 0 24 10.7 24 24l0 144c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-144c0-13.3 10.7-24 24-24zM376 336c13.3 0 24 10.7 24 24l0 112c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-112c0-13.3 10.7-24 24-24zm240 32c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-48c0-13.3 10.7-24 24-24z"],
    "code": [576, 512, [], "f121", "M360.8 1.2c-17-4.9-34.7 5-39.6 22l-128 448c-4.9 17 5 34.7 22 39.6s34.7-5 39.6-22l128-448c4.9-17-5-34.7-22-39.6zm64.6 136.1c-12.5 12.5-12.5 32.8 0 45.3l73.4 73.4-73.4 73.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l96-96c12.5-12.5 12.5-32.8 0-45.3l-96-96c-12.5-12.5-32.8-12.5-45.3 0zm-274.7 0c-12.5-12.5-32.8-12.5-45.3 0l-96 96c-12.5 12.5-12.5 32.8 0 45.3l96 96c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L77.3 256 150.6 182.6c12.5-12.5 12.5-32.8 0-45.3z"],
    "feather-pointed": [512, 512, ["feather-alt"], "f56b", "M475.3 .1c9.9-.8 19.6 3 26.6 10s10.8 16.7 10 26.6c-4 49.3-17.4 126.2-46.3 199.7-1.8 4.5-5.5 7.9-10.2 9.3L374.5 270c-3.9 1.2-6.5 4.7-6.5 8.8 0 5.1 4.1 9.2 9.2 9.2l38.6 0c12 0 19.7 12.8 13.5 23.1-4 6.7-8.3 13.2-12.7 19.6-2 2.9-5 5-8.4 6.1L310.5 366c-3.9 1.2-6.5 4.7-6.5 8.8 0 5.1 4.1 9.2 9.2 9.2l16 0c14.6 0 21 17.4 8.8 25.4-68 45-137.7 43.3-182.4 31.3-12.7-3.4-24-9.9-34.4-17.9L48 496c-8.8 8.8-23.2 8.8-32 0s-8.8-23.2 0-32l80-80 .5 .5c.7-1.3 1.6-2.5 2.7-3.6L256 224c8.8-8.8 8.8-23.2 0-32s-23.2-8.8-32 0L89.7 326.2c-8.9 8.9-24 4.4-25-8.2-4.3-53.2 9.3-123.1 72.6-186.4 91.1-91.1 254.2-124.7 337.9-131.5z"],
    "box-isometric-tape": [512, 512, [], "e798", "M463.4 409.4l-176 99c-19.5 11-43.3 11-62.8 0l-176-99C28.5 398 16 376.7 16 353.6l0-196.3c0-23 12.4-44.3 32.4-55.7l57-32.3 230.2 129.5c10.1 5.7 16.3 16.3 16.3 27.9l0 78.9c0 12.2 13.2 19.9 23.8 13.9l39.8-22.4c10.1-5.7 16.3-16.3 16.3-27.9l0-90.6c0-11.6-6.2-22.2-16.3-27.9L187.8 22.6 224.4 1.9C244-9.2 268-9.2 287.5 1.9l176 99.7C483.6 113 496 134.2 496 157.3l0 196.3c0 23.1-12.5 44.4-32.6 55.8z"],
    "file-circle-question": [576, 512, [], "e4ef", "M96 0C60.7 0 32 28.7 32 64l0 384c0 35.3 28.7 64 64 64l180 0c-22.7-31.5-36-70.2-36-112 0-100.6 77.4-183.2 176-191.3l0-38.1c0-17-6.7-33.3-18.7-45.3L290.7 18.7C278.7 6.7 262.5 0 245.5 0L96 0zM357.5 176L264 176c-13.3 0-24-10.7-24-24L240 58.5 357.5 176zM432 544a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm0-100a20 20 0 1 1 0 40 20 20 0 1 1 0-40zm0-100c-11.6 0-21.3 8.2-23.5 19.2-1.8 8.7-10.2 14.3-18.9 12.5s-14.3-10.2-12.5-18.9c5.2-25.6 27.8-44.8 54.9-44.8 30.9 0 56 25.1 56 56 0 19.8-11.7 37.8-29.8 45.9l-10.4 4.6c-1.2 7.7-7.8 13.5-15.8 13.5-8.8 0-16-7.2-16-16 0-11.2 6.6-21.3 16.8-25.9l12.4-5.5c6.6-2.9 10.8-9.4 10.8-16.6 0-13.3-10.7-24-24-24z"],
    "face-nose-steam": [512, 512, [], "e382", "M498.3 339.8c9.1-26.2 14-54.4 14-83.8 0-141.4-114.6-256-256-256S.3 114.6 .3 256c0 29.6 5 58.1 14.3 84.6 31.3-22.2 73.8-21.5 104.4 2.1L156.8 320c19.8-11.9 45.1-8.7 61.4 7.6s19.4 41.6 7.6 61.4l-22.6 37.7c18.3 23.8 22.8 54.9 13.5 82.2 13 2 26.2 3.1 39.7 3.1 14 0 27.7-1.1 41.1-3.3-9.3-27.3-4.8-58.2 13.5-82L288.4 389c-11.9-19.8-8.7-45.1 7.6-61.4s41.6-19.4 61.4-7.6L395 342.7c30.2-23.3 72.1-24.2 103.3-2.9zM120.3 224l80 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zm192 0l80 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zm73.9-88.9c4.9 9.9 .9 21.9-8.9 26.8l-64 32c-9.9 4.9-21.9 .9-26.8-8.9s-.9-21.9 8.9-26.8l64-32c9.9-4.9 21.9-.9 26.8 8.9zM135.4 161.9c-9.9-4.9-13.9-17-8.9-26.8s17-13.9 26.8-8.9l64 32c9.9 4.9 13.9 17 8.9 26.8s-17 13.9-26.8 8.9l-64-32zM493.9 435.1c-.6-.6-1.3-1.3-2-1.9 8.6-17.8 5.4-39.9-9.4-54.7-18.7-18.7-49.1-18.7-67.9 0-4.8 4.8-8.3 10.3-10.7 16.2l-67.3-40.4c-4-2.4-9.2-1.8-12.5 1.5s-4 8.5-1.5 12.5L363 435.7c-5.9 2.3-11.4 5.9-16.2 10.7-18.7 18.7-18.7 49.1 0 67.9 14.8 14.8 36.8 17.9 54.7 9.4 .6 .7 1.2 1.3 1.9 2 25 25 65.5 25 90.5 0s25-65.5 0-90.5zM22.2 433.2c-.7 .6-1.3 1.2-2 1.9-25 25-25 65.5 0 90.5s65.5 25 90.5 0c.6-.6 1.3-1.3 1.9-2 17.9 8.6 39.9 5.4 54.7-9.4 18.7-18.7 18.7-49.1 0-67.9-4.8-4.8-10.3-8.3-16.2-10.7l40.4-67.3c2.4-4 1.8-9.2-1.5-12.5s-8.5-4-12.5-1.5l-67.3 40.4c-2.3-5.9-5.9-11.4-10.7-16.2-18.7-18.7-49.1-18.7-67.9 0-14.8 14.8-17.9 36.8-9.4 54.7z"],
    "signature": [640, 512, [], "f5b7", "M192 128c0-17.7 14.3-32 32-32s32 14.3 32 32l0 7.8c0 27.7-2.4 55.3-7.1 82.5l-84.4 25.3c-40.6 12.2-68.4 49.6-68.4 92l0 32.4-72 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l72.5 0c4.2 36 34.8 64 72 64 26 0 50-13.9 62.9-36.5l13.9-24.3c26.8-47 46.5-97.7 58.4-150.5l94.4-28.3-12.5 37.5c-3.3 9.8-1.6 20.5 4.4 28.8S405.7 320 416 320l128 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-83.6 0 18-53.9c3.8-11.3 .9-23.8-7.4-32.4s-20.7-11.8-32.2-8.4L316.4 198.1c2.4-20.7 3.6-41.4 3.6-62.3l0-7.8c0-53-43-96-96-96s-96 43-96 96l0 32c0 17.7 14.3 32 32 32s32-14.3 32-32l0-32zm-9.2 177l49-14.7c-10.4 33.8-24.5 66.4-42.1 97.2l-13.9 24.3c-1.5 2.6-4.3 4.3-7.4 4.3-4.7 0-8.5-3.8-8.5-8.5l0-71.9c0-14.1 9.3-26.6 22.8-30.7zM616 416c13.3 0 24-10.7 24-24s-10.7-24-24-24l-292.9 0c-6.5 16.3-13.7 32.3-21.6 48L616 416z"],
    "earth-americas": [512, 512, [127758, "earth", "earth-america", "globe-americas"], "f57d", "M55.7 199.7l30.9 30.9c6 6 14.1 9.4 22.6 9.4l21.5 0c8.5 0 16.6 3.4 22.6 9.4l29.3 29.3c6 6 9.4 14.1 9.4 22.6l0 37.5c0 8.5 3.4 16.6 9.4 22.6l13.3 13.3c6 6 9.4 14.1 9.4 22.6l0 18.7c0 17.7 14.3 32 32 32s32-14.3 32-32l0-2.7c0-8.5 3.4-16.6 9.4-22.6l45.3-45.3c6-6 9.4-14.1 9.4-22.6l0-34.7c0-17.7-14.3-32-32-32l-82.7 0c-8.5 0-16.6-3.4-22.6-9.4l-16-16c-4.2-4.2-6.6-10-6.6-16 0-12.5 10.1-22.6 22.6-22.6l34.7 0c12.5 0 22.6-10.1 22.6-22.6 0-6-2.4-11.8-6.6-16l-19.7-19.7C242 130 240 125.1 240 120s2-10 5.7-13.7l17.3-17.3c5.8-5.8 9.1-13.7 9.1-21.9 0-7.2-2.4-13.7-6.4-18.9-3.2-.1-6.4-.2-9.6-.2-95.4 0-175.7 64.2-200.3 151.7zM464 256c0-34.6-8.4-67.2-23.4-95.8-6.4 .9-12.7 3.9-17.9 9.1l-13.4 13.4c-6 6-9.4 14.1-9.4 22.6l0 34.7c0 17.7 14.3 32 32 32l24.1 0c2.5 0 5-.3 7.3-.8 .4-5 .5-10.1 .5-15.2zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0z"],
    "carrot": [640, 512, [129365], "f787", "M453.1-36.7L440.9-24.6c-31.2 31.2-31.2 81.9 0 113.1 15.6 15.6 31.2 31.2 46.9 46.9 31.2 31.2 81.9 31.2 113.1 0l12.1-12.1c6.2-6.2 6.2-16.4 0-22.6L600.9 88.6c-31.2-31.2-81.9-31.2-113.1 0 31.2-31.2 31.2-81.9 0-113.1L475.7-36.7c-6.2-6.2-16.4-6.2-22.6 0zM331.6 96c-45.2 0-87.1 20.4-115 54.3L273.3 207c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0L191.6 193.2 67.2 466.8c-5.5 12.1-2.9 26.4 6.5 35.9s23.7 12 35.9 6.5l141.6-64.4-43.8-43.8c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l56.5 56.5 95.3-43.3c53.1-24.1 87.2-77.1 87.2-135.5 0-82.2-66.6-148.8-148.8-148.8z"],
    "sparkles": [576, 512, [10024], "f890", "M391.5 53.2c-4.5 1.7-7.5 6-7.5 10.8s3 9.1 7.5 10.8L448 96 469.2 152.5c1.7 4.5 6 7.5 10.8 7.5s9.1-3 10.8-7.5L512 96 568.5 74.8c4.5-1.7 7.5-6 7.5-10.8s-3-9.1-7.5-10.8L512 32 490.8-24.5c-1.7-4.5-6-7.5-10.8-7.5s-9.1 3-10.8 7.5L448 32 391.5 53.2zm-185 20.1c-2.6-5.7-8.3-9.3-14.5-9.3s-11.9 3.6-14.5 9.3l-53.1 115-115 53.1C3.6 244.1 0 249.8 0 256s3.6 11.9 9.3 14.5l115 53.1 53.1 115c2.6 5.7 8.3 9.3 14.5 9.3s11.9-3.6 14.5-9.3l53.1-115 115-53.1c5.7-2.6 9.3-8.3 9.3-14.5s-3.6-11.9-9.3-14.5l-115-53.1-53.1-115zM416 416l-56.5 21.2c-4.5 1.7-7.5 6-7.5 10.8s3 9.1 7.5 10.8L416 480 437.2 536.5c1.7 4.5 6 7.5 10.8 7.5s9.1-3 10.8-7.5L480 480 536.5 458.8c4.5-1.7 7.5-6 7.5-10.8s-3-9.1-7.5-10.8L480 416 458.8 359.5c-1.7-4.5-6-7.5-10.8-7.5s-9.1 3-10.8 7.5L416 416z"],
    "square-l": [448, 512, [], "e275", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM192 168l0 152 88 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-112 0c-13.3 0-24-10.7-24-24l0-176c0-13.3 10.7-24 24-24s24 10.7 24 24z"],
    "cauldron": [448, 512, [], "f6bf", "M160 32c17.7 0 32-14.3 32-32s-14.3-32-32-32-32 14.3-32 32 14.3 32 32 32zm128 80a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM35.1 224C16.5 257 0 297.1 0 334.4 0 371.8 11.9 403.8 32 429.9L32 488c0 13.3 10.7 24 24 24s24-10.7 24-24l0-15c40.4 25.5 91.8 39 144 39s103.6-13.5 144-39l0 15c0 13.3 10.7 24 24 24s24-10.7 24-24l0-58.1c20.1-26.1 32-58.1 32-95.5 0-37.3-16.5-77.4-35.1-110.4l3.1 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 160c-17.7 0-32 14.3-32 32s14.3 32 32 32l3.1 0z"],
    "temperature-full": [320, 512, ["temperature-4", "thermometer-4", "thermometer-full"], "f2c7", "M160 0C107 0 64 43 64 96l0 164.7C34.5 287 16 325.4 16 368 16 447.5 80.5 512 160 512s144-64.5 144-144c0-42.6-18.5-81-48-107.3L256 96c0-53-43-96-96-96zm64 368c0 35.3-28.7 64-64 64s-64-28.7-64-64c0-26.9 16.5-49.9 40-59.3L136 96c0-13.3 10.7-24 24-24s24 10.7 24 24l0 212.7c23.5 9.5 40 32.5 40 59.3z"],
    "table-cells-row-lock": [640, 512, [], "e67a", "M256 288l0-64 153.3 0c17.1-42.2 56-73.2 102.7-79l0-49c0-35.3-28.7-64-64-64L128 32C92.7 32 64 60.7 64 96l0 320c0 35.3 28.7 64 64 64l241.3 0c-.9-5.2-1.3-10.6-1.3-16.1l0-47.9-112 0 0-64 113.3 0c3.7-22 14.8-41.4 30.7-55.6l0-8.4-144 0zm0-192l192 0 0 64-192 0 0-64zM560 272.1l0 47.9-64 0 0-47.9c0-17.7 14.3-32 32-32s32 14.3 32 32zM416 368l0 96c0 26.5 21.5 48 48 48l128 0c26.5 0 48-21.5 48-48l0-96c0-20.9-13.4-38.7-32-45.3l0-50.6c0-44.2-35.8-80-80-80s-80 35.8-80 80l0 50.6c-18.6 6.6-32 24.4-32 45.3z"],
    "circle-user-circle-plus": [640, 512, [], "e7a3", "M496 208c-77.5 0-144.3 45.9-174.6 112l-1.4 0-64 0c-47.4 0-88.9 25.8-111 64.2 35.2 39.2 86.2 63.8 143 63.8 7.4 0 14.6-.4 21.7-1.2 5.5 21.9 14.8 42.4 27.1 60.6-15.8 3-32.1 4.6-48.8 4.6-141.4 0-256-114.6-256-256S146.6 0 288 0c126.8 0 232.1 92.2 252.4 213.2-14.3-3.4-29.1-5.2-44.4-5.2zM288 272a72 72 0 1 0 0-144 72 72 0 1 0 0 144zm208-16a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm16 80c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 48-48 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l48 0 0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48 48 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-48 0 0-48z"],
    "bolt-lightning": [384, 512, [], "e0b7", "M0 256L28.5 28c2-16 15.6-28 31.8-28L228.9 0c15 0 27.1 12.1 27.1 27.1 0 3.2-.6 6.5-1.7 9.5L208 160 347.3 160c20.2 0 36.7 16.4 36.7 36.7 0 7.4-2.2 14.6-6.4 20.7l-192.2 281c-5.9 8.6-15.6 13.7-25.9 13.7l-2.9 0c-15.7 0-28.5-12.8-28.5-28.5 0-2.3 .3-4.6 .9-6.9L176 288 32 288c-17.7 0-32-14.3-32-32z"],
    "cloud-showers-water": [512, 512, [], "e4e4", "M279.2 55.7C263.9 22.8 230.6 0 192 0 139 0 96 43 96 96 60.7 96 32 124.7 32 160s28.7 64 64 64l320 0c35.3 0 64-28.7 64-64s-28.7-64-64-64l-1.6 0c-7.4-36.5-39.7-64-78.4-64-22.2 0-42.3 9.1-56.8 23.7zM410.6 476.1c20.7 15.6 46 30.7 74.2 34.5 13.1 1.8 25.2-7.5 27-20.6s-7.5-25.2-20.6-27c-15.9-2.1-33.2-11.3-51.7-25.2-38.4-29-90.5-29-129 0-24 18.1-40.7 26.3-54.5 26.3s-30.5-8.2-54.5-26.3c-38.4-29-90.5-29-129 0-18.5 13.9-35.8 23.1-51.7 25.2-13.1 1.8-22.4 13.8-20.6 27s13.8 22.4 27 20.6c28.2-3.8 53.6-18.9 74.2-34.5 21.3-16.1 49.9-16.1 71.2 0 24.2 18.3 52.3 35.9 83.4 35.9s59.1-17.7 83.4-35.9c21.3-16.1 49.9-16.1 71.2 0zM100.1 303.6c4.2-12.6-2.6-26.2-15.2-30.4s-26.2 2.6-30.4 15.2l-21.3 64C29 365 35.8 378.6 48.4 382.8s26.2-2.6 30.4-15.2l21.3-64zm120 0c4.2-12.6-2.6-26.2-15.2-30.4s-26.2 2.6-30.4 15.2l-21.3 64c-4.2 12.6 2.6 26.2 15.2 30.4s26.2-2.6 30.4-15.2l21.3-64zm112 0c4.2-12.6-2.6-26.2-15.2-30.4s-26.2 2.6-30.4 15.2l-21.3 64c-4.2 12.6 2.6 26.2 15.2 30.4s26.2-2.6 30.4-15.2l21.3-64zm120 0c4.2-12.6-2.6-26.2-15.2-30.4s-26.2 2.6-30.4 15.2l-21.3 64c-4.2 12.6 2.6 26.2 15.2 30.4s26.2-2.6 30.4-15.2l21.3-64z"],
    "arrow-up-long": [320, 512, ["long-arrow-up"], "f176", "M182.6-22.6c-12.5-12.5-32.8-12.5-45.3 0l-128 128c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L128 77.3 128 512c0 17.7 14.3 32 32 32s32-14.3 32-32l0-434.7 73.4 73.4c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-128-128z"],
    "flux-capacitor": [448, 512, [], "f8ba", "M0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm384 56c0-30.9-25.1-56-56-56s-56 25.1-56 56c0 6.6 1.1 12.9 3.2 18.8l-51.2 51.2-51.2-51.2c2.1-5.9 3.2-12.2 3.2-18.8 0-30.9-25.1-56-56-56s-56 25.1-56 56 25.1 56 56 56c6.6 0 12.9-1.1 18.8-3.2l61.2 61.2 0 43.4c-18.9 9-32 28.3-32 50.6 0 30.9 25.1 56 56 56s56-25.1 56-56c0-22.3-13.1-41.6-32-50.6l0-43.4 61.2-61.2c5.9 2.1 12.2 3.2 18.8 3.2 30.9 0 56-25.1 56-56z"],
    "address-card": [576, 512, [62140, "contact-card", "vcard"], "f2bb", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l448 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm80 256l64 0c44.2 0 80 35.8 80 80 0 8.8-7.2 16-16 16L80 384c-8.8 0-16-7.2-16-16 0-44.2 35.8-80 80-80zm-24-96a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm240-48l112 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-112 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zm0 96l112 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-112 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"],
    "staff": [512, 512, [], "f71b", "M284.2 44.2C297.8 17.1 325.5 0 355.8 0L432 0c44.2 0 80 35.8 80 80l0 103.9c0 35.7-23.7 67.1-58 76.9l-3.9 1.1c-4 1.2-7.5 3.9-9.5 7.5l-19 33.6c-4.3 7.7-14.1 10.4-21.8 6.1l-32.8-18.5c-3.7-2.1-8.1-2.6-12.3-1.4l-85.5 24.4c-2.6 .7-5 2.1-6.9 4.1L81.9 497.9c-18.7 18.7-49.1 18.7-67.9 0s-18.7-49.1 0-67.9l77.3-77.3c3-3 4.7-7.1 4.7-11.3L96 304c0-8.8 7.2-16 16-16l37.5 0c4.2 0 8.3-1.7 11.3-4.7l39.4-39.4c9.6-9.6 21.5-16.6 34.6-20.4l169.6-48.5c6.9-2 11.6-8.2 11.6-15.4l0-47.7c0-8.8-7.2-16-16-16l-28.2 0c-3.7 0-7.2 2.1-8.8 5.5-11.9 23.7-40.7 33.3-64.4 21.5s-33.3-40.7-21.5-64.4l7.2-14.3z"],
    "basket-shopping-minus": [576, 512, [], "e652", "M288 0c6.6 0 12.9 2.7 17.4 7.5l144 152 .5 .5 78.1 0c17.7 0 32 14.3 32 32 0 14.5-9.6 26.7-22.8 30.7L491.1 429.9c-6.5 29.3-32.5 50.1-62.5 50.1l-281.3 0c-30 0-56-20.8-62.5-50.1l-46-207.2c-13.2-3.9-22.8-16.2-22.8-30.7 0-17.7 14.3-32 32-32l78.1 0 .5-.5 144-152C275.1 2.7 281.4 0 288 0zm0 58.9L192.2 160 383.8 160 288 58.9zM216 296c-13.3 0-24 10.7-24 24s10.7 24 24 24l144 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-144 0z"],
    "angle-right": [256, 512, [8250], "f105", "M247.1 233.4c12.5 12.5 12.5 32.8 0 45.3l-160 160c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L179.2 256 41.9 118.6c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0l160 160z"],
    "toilet-paper-under": [512, 512, [58015, "toilet-paper-blank-under", "toilet-paper-reverse", "toilet-paper-reverse-alt"], "e2a0", "M327.1 32c-8.8 11.1-16 23.1-21.9 34.8-21.4 42.7-33.2 98.4-33.2 157.2s11.8 114.5 33.2 157.2c5.9 11.7 13.1 23.7 21.9 34.8L96 416C43 416 0 330 0 224S43 32 96 32l231.1 0zM416 288c17.7 0 32-28.7 32-64s-14.3-64-32-64-32 28.7-32 64 14.3 64 32 64zm0 128c-53 0-96-86-96-192s43-192 96-192 96 86 96 192-43 192-96 192zM128 488l0-24 288 0c43 0 74.7-26.7 96-57.6l0 81.6c0 30.9-25.1 56-56 56l-272 0c-30.9 0-56-25.1-56-56z"],
    "stomach": [512, 512, [], "f623", "M160 0c17.7 0 32 14.3 32 32l0 64c0 35.3 28.7 64 64 64l17.1 0c22.1-38.3 63.5-64 110.9-64 70.7 0 128 57.3 128 128l0 80c0 114.9-93.1 208-208 208-32 0-57.5-5.8-78.9-15.2-21.2-9.3-36.9-21.7-49.6-32.2-1.8-1.5-3.6-3-5.3-4.4l0 0c-22.2-18.6-33.6-28.2-58.2-28.2-26.5 0-48 21.5-48 48 0 17.7-14.3 32-32 32S0 497.7 0 480c0-70.7 57.3-128 128-128l64 0c35.3 0 64-28.7 64-64l0-64c-70.7 0-128-57.3-128-128l0-64c0-17.7 14.3-32 32-32zM448 304l0-80c0-35.3-28.7-64-64-64s-64 28.7-64 64l0 32.3c27.2 2.3 52.3 16 68.8 38.1 12.1 16.1 31.1 25.6 51.2 25.6l7.1 0c.6-5.3 .9-10.6 .9-16z"],
    "face-cowboy-hat": [512, 512, [], "e36e", "M485.8 16.1c6.5-6.5 16.7-7.3 24.1-1.9s9.9 15.3 5.8 23.5C493.6 81.9 412.1 160 256.3 160S19.1 81.9-3 37.7c-4.1-8.2-1.6-18.1 5.8-23.5s17.6-4.5 24.1 1.9c12.4 12.4 45.1 34.5 96.9 50.4 11.4-62.7 34.9-130.5 74.6-130.5 10.4 0 20.6 4.4 29.8 9.4 9 4.9 20.3 9.3 28.2 9.3s19.1-4.4 28.2-9.3c9.2-5 19.4-9.4 29.8-9.4 39.8 0 63.2 67.8 74.6 130.5 51.8-15.9 84.5-38 96.9-50.4zM32.3 288c0-46 13.9-88.8 37.7-124.4 47.8 24.5 109.7 41.8 186.3 41.8s138.5-17.3 186.3-41.8c23.8 35.6 37.7 78.4 37.7 124.4 0 123.7-100.3 224-224 224s-224-100.3-224-224zm338.4 62.3C336.4 361 297.5 367 256.3 367s-80.1-6-114.4-16.7c-10.5-3.3-20.9 5.5-17.2 15.8 19.6 53.6 71.1 91.9 131.5 91.9s111.9-38.3 131.5-91.9c3.8-10.3-6.7-19.1-17.2-15.8zM208.3 272a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm128 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "face-meh": [512, 512, [128528, "meh"], "f11a", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM176 176a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm128 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM176 320l160 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-160 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"],
    "arrow-up-from-ground-water": [640, 512, [], "e4b5", "M303 7c9.4-9.4 24.6-9.4 33.9 0l88 88c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-47-47 0 278.1c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-278.1-47 47c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9L303 7zM240 192l0 163.1c-10.6-2.2-21.3-3.2-32-3.1-32.5 .2-64.9 10.7-92.3 31.4-8.8 6.6-15.9 10.9-21.7 13.5l-.8 .4c-3.7 1.7-6.4 2.9-9.8 .3-6-4.5-12.6-8-19.3-10.4L64 240c0-26.5 21.5-48 48-48l128 0zm336 48l0 155.2c-1.1 .8-2.2 1.5-3.3 2.4-4.1 3.1-8.3 .8-12.6-1.5-.6-.3-1.2-.6-1.8-1-5.2-2.7-11.1-6.6-18-11.7-28.1-21.1-61.3-31.6-94.4-31.4-15.5 .1-31 2.5-46 7.3l0-167.3 128 0c26.5 0 48 21.5 48 48zM403.4 476.1C379.1 494.3 351.1 512 320 512s-59.1-17.7-83.4-35.9c-21.3-16.1-49.9-16.1-71.2 0-23.8 17.9-54.1 35.5-88.1 35.3-20.4-.1-40.7-6.7-59.8-21.1-10.6-8-12.7-23-4.7-33.6s23-12.7 33.6-4.7c11.3 8.5 21.6 11.4 31.2 11.5 17.6 .1 37.3-9.4 58.9-25.7 38.4-29 90.5-29 129 0 24 18.1 40.7 26.3 54.5 26.3s30.5-8.2 54.5-26.3c38.4-29 90.5-29 129 0 16.9 12.7 32.9 21.5 47.8 24.6 13.7 2.8 27.4 .9 42.3-10.3 10.6-8 25.6-5.9 33.6 4.7s5.9 25.6-4.7 33.6c-26.4 19.9-54.2 24.4-80.7 19.1-25.3-5.1-48.1-18.9-67.2-33.3-21.3-16.1-49.9-16.1-71.2 0z"],
    "face-pleading": [512, 512, [], "e386", "M0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm160 72c48.6 0 88-39.4 88-88 0-42.2-29.8-77.5-69.5-86 6.8-9.3 12-19.8 15.2-31.3l1.5-5.2c3-10.6-3.1-21.7-13.7-24.7s-21.7 3.1-24.7 13.7l-1.5 5.2c-6.6 23.1-26.4 40.1-50.2 43.1l-11.5 1.4c-11 1.4-18.7 11.4-17.4 22.3 .8 6.3 4.4 11.5 9.4 14.6-8.6 13.6-13.6 29.7-13.6 46.9 0 48.6 39.4 88 88 88zm192 0c48.6 0 88-39.4 88-88 0-17.3-5-33.4-13.6-46.9 5-3.1 8.6-8.3 9.4-14.6 1.4-11-6.4-21-17.4-22.3L407 154.7c-23.9-3-43.6-19.9-50.2-43.1l-1.5-5.2c-3-10.6-14.1-16.8-24.7-13.7s-16.8 14.1-13.7 24.7l1.5 5.2c3.3 11.5 8.5 22 15.2 31.3-39.7 8.5-69.5 43.8-69.5 86 0 48.6 39.4 88 88 88zM224 384c-13.3 0-24 10.7-24 24s10.7 24 24 24l64 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-64 0zM128 232c17.7 0 32-14.3 32-32 0-5.8-1.5-11.2-4.2-15.8 1.4-.1 2.8-.2 4.2-.2 30.9 0 56 25.1 56 56s-25.1 56-56 56-56-25.1-56-56c0-5.7 .8-11.2 2.4-16.4 5.7 5.2 13.3 8.4 21.6 8.4zm224-32c0-5.8-1.5-11.2-4.2-15.8 1.4-.1 2.8-.2 4.2-.2 30.9 0 56 25.1 56 56s-25.1 56-56 56-56-25.1-56-56c0-5.7 .8-11.2 2.4-16.4 5.7 5.2 13.3 8.4 21.6 8.4 17.7 0 32-14.3 32-32z"],
    "envelope-circle-user": [640, 512, [], "e6de", "M64 112c0-26.5 21.5-48 48-48l416 0c26.5 0 48 21.5 48 48l0 81.4c-24.4-11.2-51.4-17.4-80-17.4-87.7 0-161.7 58.8-184.7 139.2-7.1-1.3-14.1-4.2-20.1-8.8l-208-156C71.1 141.3 64 127.1 64 112zM304 368c0 28.6 6.2 55.6 17.4 80L128 448c-35.3 0-64-28.7-64-64l0-188 198.4 148.8c12.6 9.4 26.9 15.4 41.7 17.9 0 1.8-.1 3.5-.1 5.3zm48 0a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm221.7 80.7c-6.2-19-24-32.7-45.1-32.7l-65.2 0c-21 0-38.9 13.7-45.1 32.7 20.1 19.4 47.5 31.3 77.7 31.3s57.5-11.9 77.7-31.3zM544 336a48 48 0 1 0 -96 0 48 48 0 1 0 96 0z"],
    "barn": [512, 512, [], "e6c7", "M1 252.4L41.6 103.4c4-14.7 14.8-26.7 29.1-32.2L238.8 6.6c11.1-4.3 23.4-4.3 34.5 0L441.3 71.3c14.3 5.5 25.1 17.4 29.1 32.2L511 252.4c.7 2.4 1 4.9 1 7.4 0 15.6-12.6 28.2-28.2 28.2l-3.8 0 0 160c0 35.3-28.7 64-64 64L96 512c-35.3 0-64-28.7-64-64l0-160-3.8 0c-15.6 0-28.2-12.6-28.2-28.2 0-2.5 .3-5 1-7.4zM208 136l0 48c0 13.3 10.7 24 24 24l48 0c13.3 0 24-10.7 24-24l0-48c0-13.3-10.7-24-24-24l-48 0c-13.3 0-24 10.7-24 24zM160 432c0 17.7 14.3 32 32 32L316.5 464 160 320.6 160 432zm35.5-144L352 431.4 352 320c0-17.7-14.3-32-32-32l-124.5 0z"],
    "map": [512, 512, [128506, 62072], "f279", "M512 48c0-11.1-5.7-21.4-15.2-27.2s-21.2-6.4-31.1-1.4L349.5 77.5 170.1 17.6c-8.1-2.7-16.8-2.1-24.4 1.7l-128 64C6.8 88.8 0 99.9 0 112L0 464c0 11.1 5.7 21.4 15.2 27.2s21.2 6.4 31.1 1.4l116.1-58.1 179.4 59.8c8.1 2.7 16.8 2.1 24.4-1.7l128-64c10.8-5.4 17.7-16.5 17.7-28.6l0-352zM192 376.9l0-284.5 128 42.7 0 284.5-128-42.7z"],
    "user-plus": [640, 512, [], "f234", "M136 128a120 120 0 1 1 240 0 120 120 0 1 1 -240 0zM48 482.3C48 383.8 127.8 304 226.3 304l59.4 0c98.5 0 178.3 79.8 178.3 178.3 0 16.4-13.3 29.7-29.7 29.7L77.7 512C61.3 512 48 498.7 48 482.3zM544 96c13.3 0 24 10.7 24 24l0 48 48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0 0 48c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-48-48 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l48 0 0-48c0-13.3 10.7-24 24-24z"],
    "turn-down-left": [512, 512, [], "e331", "M9.4 233.4c-12.5 12.5-12.5 32.8 0 45.3l128 128c9.2 9.2 22.9 11.9 34.9 6.9S192 396.9 192 384l0-64 160 0c88.4 0 160-71.6 160-160l0-64c0-17.7-14.3-32-32-32l-64 0c-17.7 0-32 14.3-32 32l0 64c0 17.7-14.3 32-32 32l-160 0 0-64c0-12.9-7.8-24.6-19.8-29.6s-25.7-2.2-34.9 6.9l-128 128z"],
    "plane-engines": [576, 512, [9992, "plane-alt"], "f3de", "M520 200c30.9 0 56 25.1 56 56s-25.1 56-56 56l-127.3 0-66.5 72.6c14.7 2.9 25.9 15.8 25.9 31.4 0 17.7-14.3 32-32 32l-52 0-34.5 37.6c-6.1 6.6-14.6 10.4-23.6 10.4l-43.7 0c-10.9 0-18.6-10.7-15.2-21.1l54.3-162.9-99.7 0-52.8 66c-3 3.8-7.6 6-12.5 6l-19.8 0c-10.4 0-18-9.8-15.5-19.9L32 256 5 147.9C2.4 137.8 10.1 128 20.5 128l19.8 0c4.9 0 9.5 2.2 12.5 6l52.8 66 99.7 0-54.3-162.9C147.6 26.7 155.3 16 166.2 16l43.7 0c9 0 17.5 3.8 23.6 10.4L268 64 320 64c17.7 0 32 14.3 32 32 0 15.6-11.1 28.6-25.9 31.4L392.7 200 520 200z"],
    "venus": [384, 512, [9792], "f221", "M80 176a112 112 0 1 1 224 0 112 112 0 1 1 -224 0zM223.9 349.1C305.9 334.1 368 262.3 368 176 368 78.8 289.2 0 192 0S16 78.8 16 176c0 86.3 62.1 158.1 144.1 173.1-.1 1-.1 1.9-.1 2.9l0 64-32 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l32 0 0 32c0 17.7 14.3 32 32 32s32-14.3 32-32l0-32 32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0 0-64c0-1 0-1.9-.1-2.9z"],
    "user-doctor-message": [576, 512, ["user-md-chat"], "f82e", "M320 48l0 96c0 26.5 21.5 48 48 48l16 0 0 41.4c0 14.3 17.2 21.4 27.3 11.3l52.7-52.7 64 0c26.5 0 48-21.5 48-48l0-96c0-26.5-21.5-48-48-48L368 0c-26.5 0-48 21.5-48 48zm-48 0c0-9.8 1.5-19.2 4.2-28.1-15.8-7.6-33.5-11.9-52.2-11.9-66.3 0-120 53.7-120 120s53.7 120 120 120c31.2 0 59.7-11.9 81.1-31.5-20.3-17.6-33.1-43.5-33.1-72.5l0-96zm12 272.8c-5.4-.5-11-.8-16.6-.8l-86.9 0c-5.6 0-11.1 .3-16.6 .8l0 67.5c16.5 7.6 28 24.3 28 43.6 0 26.5-21.5 48-48 48s-48-21.5-48-48c0-19.4 11.5-36.1 28-43.6l0-58.4C61 353 16 413.6 16 484.6 16 499.7 28.3 512 43.4 512l361.1 0c15.1 0 27.4-12.3 27.4-27.4 0-71-45-131.5-108-154.6l0 37.4c23.3 8.2 40 30.5 40 56.6l0 32c0 11-9 20-20 20s-20-9-20-20l0-32c0-11-9-20-20-20s-20 9-20 20l0 32c0 11-9 20-20 20s-20-9-20-20l0-32c0-26.1 16.7-48.3 40-56.6l0-46.6z"],
    "bars-sort": [448, 512, [], "e0ae", "M0 96C0 78.3 14.3 64 32 64l384 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 128C14.3 128 0 113.7 0 96zM0 256c0-17.7 14.3-32 32-32l256 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 288c-17.7 0-32-14.3-32-32zM192 416c0 17.7-14.3 32-32 32L32 448c-17.7 0-32-14.3-32-32s14.3-32 32-32l128 0c17.7 0 32 14.3 32 32z"],
    "high-definition": [512, 512, ["rectangle-hd"], "e1ae", "M0 128C0 92.7 28.7 64 64 64l384 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64L64 448c-35.3 0-64-28.7-64-64L0 128zm120 32c-13.3 0-24 10.7-24 24l0 144c0 13.3 10.7 24 24 24s24-10.7 24-24l0-48 48 0 0 48c0 13.3 10.7 24 24 24s24-10.7 24-24l0-144c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 48-48 0 0-48c0-13.3-10.7-24-24-24zm176 0c-13.3 0-24 10.7-24 24l0 144c0 13.3 10.7 24 24 24l48 0c39.8 0 72-32.2 72-72l0-48c0-39.8-32.2-72-72-72l-48 0zm48 144l-24 0 0-96 24 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24z"],
    "circle-peseta": [512, 512, [], "e741", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM176 144c0-13.3 10.7-24 24-24l64 0c52 0 95.1 38.2 102.8 88l9.2 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-9.2 0c-7.7 49.8-50.8 88-102.8 88l-40 0 0 40c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-128-8 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l8 0 0-64zm88 24l-40 0 0 40 93.7 0c-6.9-23.1-28.3-40-53.7-40zM224 280l40 0c25.4 0 46.8-16.9 53.7-40l-93.7 0 0 40z"],
    "ditto": [320, 512, [], "22", "M0 96l0 2.3c0 3.8 .3 7.6 1 11.4L26.5 256.5C29.7 274.7 45.5 288 64 288s34.3-13.3 37.5-31.5L127 109.6c.7-3.8 1-7.5 1-11.4l0-2.3c0-35.3-28.7-64-64-64S0 60.7 0 96zm192 0l0 2.3c0 3.8 .3 7.6 1 11.4l25.5 146.8c3.2 18.2 19 31.5 37.5 31.5s34.3-13.3 37.5-31.5L319 109.6c.7-3.8 1-7.5 1-11.4l0-2.3c0-35.3-28.7-64-64-64s-64 28.7-64 64z"],
    "square-arrow-down-right": [448, 512, [], "e262", "M384 480c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0zM272 216c0-13.3 10.7-24 24-24s24 10.7 24 24l0 112c0 13.3-10.7 24-24 24l-112 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l54.1 0-103-103c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l103 103 0-54.1z"],
    "pipe-valve": [512, 512, [], "e439", "M256 32c17.7 0 32 14.3 32 32l64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-64 0 0 64 160 0c0-17.7 14.3-32 32-32s32 14.3 32 32l0 256c0 17.7-14.3 32-32 32s-32-14.3-32-32L64 448c0 17.7-14.3 32-32 32S0 465.7 0 448L0 192c0-17.7 14.3-32 32-32s32 14.3 32 32l160 0 0-64-64 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l64 0c0-17.7 14.3-32 32-32z"],
    "square-s": [448, 512, [], "e27d", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM202.5 144l69.5 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-69.5 0c-10.2 0-18.5 8.3-18.5 18.5 0 9.3 6.9 17.2 16.2 18.3l53.6 6.7c33.3 4.2 58.2 32.4 58.2 66 0 36.7-29.8 66.5-66.5 66.5L168 368c-13.3 0-24-10.7-24-24s10.7-24 24-24l77.5 0c10.2 0 18.5-8.3 18.5-18.5 0-9.3-6.9-17.2-16.2-18.3l-53.6-6.7c-33.3-4.2-58.2-32.4-58.2-66 0-36.7 29.8-66.5 66.5-66.5z"],
    "diagram-successor": [448, 512, [], "e47a", "M289.2 137.9c2.5-6 8.3-9.9 14.8-9.9l40 0 0-24c0-13.3-10.7-24-24-24l-98 0c1.3 5.1 2 10.5 2 16l0 64c0 35.3-28.7 64-64 64l-96 0c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l256 0c39.8 0 72 32.2 72 72l0 24 40 0c6.5 0 12.3 3.9 14.8 9.9s1.1 12.9-3.5 17.4l-64 64c-6.2 6.2-16.4 6.2-22.6 0l-64-64c-4.6-4.6-5.9-11.5-3.5-17.4zM384 480L64 480c-35.3 0-64-28.7-64-64l0-64c0-35.3 28.7-64 64-64l320 0c35.3 0 64 28.7 64 64l0 64c0 35.3-28.7 64-64 64zM160 160l0-64-96 0 0 64 96 0z"],
    "head-side-cough-slash": [576, 512, [], "e062", "M535-24.9c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9L41 537.1c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l25-25 0-447.2c0-15 10.5-28.3 25.4-29.8 7.4-.7 14.9-1.1 22.6-1.1 112.7 0 206 83.3 221.7 191.7 .4 3 1.7 5.9 3.6 8.3l2.2 2.6 227.5-227.5zM133.8 512L288 357.8 288 416c0 53-43 96-96 96l-58.2 0zM176 224a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm336 40a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm-88 72a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm-64 48a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm128 0a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm24 72a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm-88-24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"],
    "arrows-maximize": [448, 512, ["expand-arrows"], "f31d", "M288 32c-17.7 0-32 14.3-32 32s14.3 32 32 32L338.7 96 224 210.7 109.3 96 160 96c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 32C14.3 32 0 46.3 0 64L0 192c0 17.7 14.3 32 32 32s32-14.3 32-32L64 141.3 178.7 256 64 370.7 64 320c0-17.7-14.3-32-32-32S0 302.3 0 320L0 448c0 17.7 14.3 32 32 32l128 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L109.3 416 224 301.3 338.7 416 288 416c-17.7 0-32 14.3-32 32s14.3 32 32 32l128 0c17.7 0 32-14.3 32-32l0-128c0-17.7-14.3-32-32-32s-32 14.3-32 32L384 370.7 269.3 256 384 141.3 384 192c0 17.7 14.3 32 32 32s32-14.3 32-32l0-128c0-17.7-14.3-32-32-32L288 32z"],
    "plus-large": [512, 512, [], "e59e", "M288 32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 192-192 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l192 0 0 192c0 17.7 14.3 32 32 32s32-14.3 32-32l0-192 192 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-192 0 0-192z"],
    "mug-tea": [576, 512, [], "f875", "M168 64l0 52.4c0 7.5-2.6 14.7-7.4 20.5l-25.2 30.2c-4.8 5.8-7.4 13-7.4 20.5l0 68.4c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-68.4c0-7.5-2.6-14.7-7.4-20.5l-25.2-30.2c-4.8-5.8-7.4-13-7.4-20.5l0-52.4 232 0c70.7 0 128 57.3 128 128S518.7 320 448 320l0 32c0 53-43 96-96 96l-192 0c-53 0-96-43-96-96L64 96c0-17.7 14.3-32 32-32l72 0zM512 192c0-35.3-28.7-64-64-64l0 128c35.3 0 64-28.7 64-64z"],
    "diagram-project": [512, 512, ["project-diagram"], "f542", "M0 80C0 53.5 21.5 32 48 32l96 0c26.5 0 48 21.5 48 48l0 16 128 0 0-16c0-26.5 21.5-48 48-48l96 0c26.5 0 48 21.5 48 48l0 96c0 26.5-21.5 48-48 48l-96 0c-26.5 0-48-21.5-48-48l0-16-128 0 0 16c0 7.3-1.7 14.3-4.6 20.5l68.6 91.5 80 0c26.5 0 48 21.5 48 48l0 96c0 26.5-21.5 48-48 48l-96 0c-26.5 0-48-21.5-48-48l0-96c0-7.3 1.7-14.3 4.6-20.5L128 224 48 224c-26.5 0-48-21.5-48-48L0 80z"],
    "terminal": [512, 512, [], "f120", "M9.4 118.6c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0l160 160c12.5 12.5 12.5 32.8 0 45.3l-160 160c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L146.7 256 9.4 118.6zM224 384l256 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-256 0c-17.7 0-32-14.3-32-32s14.3-32 32-32z"],
    "eclipse": [640, 512, [], "f749", "M169.8-10.1c7.4-3.1 15.8-2.2 22.5 2.2L280 50.3 367.8-7.9c6.7-4.4 15.1-5.2 22.5-2.2S403-.5 404.6 7.3l10.3 51.1c-41.2 13.6-76.8 39.7-102.1 73.8-10.5-2.8-21.5-4.2-32.8-4.2-70.7 0-128 57.3-128 128s57.3 128 128 128c11.3 0 22.3-1.5 32.8-4.2 25.3 34.2 60.8 60.3 102.1 73.9l-10.3 51.1c-1.6 7.8-7 14.4-14.3 17.4s-15.8 2.2-22.5-2.2l-87.8-58.2-87.8 58.2c-6.7 4.4-15.1 5.2-22.5 2.2s-12.8-9.6-14.3-17.4L134.6 401.4 31.3 380.5c-7.8-1.6-14.4-7-17.4-14.3s-2.2-15.8 2.2-22.5L74.3 256 16.1 168.2c-4.4-6.7-5.2-15.1-2.2-22.5s9.6-12.8 17.4-14.3L134.6 110.6 155.4 7.3c1.6-7.8 7-14.4 14.3-17.4zM280 176c2.6 0 5.2 .1 7.8 .4-10.2 24.5-15.8 51.4-15.8 79.6s5.6 55.1 15.8 79.6c-2.6 .2-5.2 .4-7.8 .4-44.2 0-80-35.8-80-80s35.8-80 80-80zM480 96a160 160 0 1 1 0 320 160 160 0 1 1 0-320z"],
    "house-fire": [640, 512, [], "e50c", "M448 192c14.1 .4 23.8 11.4 32.7 21.7 2 2.3 4 4.6 6 6.7l19 19.9 12.2-13.8c5.4-6.1 13.3-8.9 20.9-8.9 7.2 0 14.3 2.6 19.9 7.8 19.7 18.3 39.8 43.2 55 70.6 15.1 27.2 26.2 58.2 26.2 88.2 0 88.7-71.3 159.8-160 159.8-89.6 0-160-71.3-160-159.8 0-37.3 16-73.4 36.8-104.5 20.9-31.3 47.5-59 70.9-80.1 5.7-5.2 13.1-7.7 20.3-7.5zM268.6 6.5c12.2-9.3 29.7-8.7 41.2 2l147.5 137c-19.2-4.3-40 .5-55.5 14.4-36.4 32.6-67.7 69.8-90.3 106.4-10.3 16.6-19.7 34.9-26.8 53.7L272 320c-26.5 0-48 21.5-48 48l0 96 64.6 0c7.3 17.2 16.8 33.4 28.2 48L144 512c-35.3 0-64-28.7-64-64l0-176-16 0c-13.2 0-25-8.1-29.8-20.3s-1.6-26.2 8-35.1l224-208 2.4-2zM489.3 343.7c-5.4-4.7-13.1-4.7-18.5 0-17.7 15.4-54.7 51.9-54.7 88.4 0 35.3 28.7 64 64 64s64-28.7 64-64c0-36.5-37-73-54.7-88.4z"],
    "mask": [576, 512, [], "f6fa", "M288 64C64 64 0 160 0 272S80 448 176 448l8.4 0c24.2 0 46.4-13.7 57.2-35.4l23.2-46.3c4.4-8.8 13.3-14.3 23.2-14.3s18.8 5.5 23.2 14.3l23.2 46.3c10.8 21.7 33 35.4 57.2 35.4l8.4 0c96 0 176-64 176-176S512 64 288 64zM96 256a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zm320-64a64 64 0 1 1 0 128 64 64 0 1 1 0-128z"],
    "hurricane": [384, 512, [], "f751", "M0 208C0 104.4 75.7 18.5 174.9 2.6 184 1.2 192 8.6 192 17.9l0 63.3c0 8.4 6.5 15.3 14.7 16.5 100.3 14.9 177.3 101.3 177.3 205.7 0 103.6-75.7 189.5-174.9 205.4-9.2 1.5-17.1-5.9-17.1-15.2l0-63.3C192 421.9 185.5 415 177.3 413.7 77 398.9 0 312.4 0 208zm288 48a96 96 0 1 0 -192 0 96 96 0 1 0 192 0zm-96-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "earth-africa": [512, 512, [127757, "globe-africa"], "f57c", "M447.6 175c-31.6-74.6-105.5-127-191.6-127-22.1 0-43.4 3.5-63.4 9.8-.4 2-.6 4.1-.6 6.2l0 73.4c0 12.5 10.1 22.6 22.6 22.6 6 0 11.8-2.4 16-6.6l16-16c6-6 14.1-9.4 22.6-9.4l5.5 0c28.5 0 42.8 34.5 22.6 54.6-6 6-14.1 9.4-22.6 9.4l-61.5 0c-8.5 0-16.6 3.4-22.6 9.4l-21.3 21.3c-6 6-9.4 14.1-9.4 22.6l0 42.7c0 17.7 14.3 32 32 32l32 0c17.7 0 32 14.3 32 32l0 32c0 17.7 14.3 32 32 32l2.7 0c8.5 0 16.6-3.4 22.6-9.4l29.3-29.3c6-6 9.4-14.1 9.4-22.6l0-18.7c0-8.8 7.2-16 16-16s16-7.2 16-16l0-34.7c0-8.5-3.4-16.6-9.4-22.6l-16-16c-4.2-4.2-6.6-10-6.6-16 0-12.5 10.1-22.6 22.6-22.6l45 0c12.4 0 22.7-7.1 28-17zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0z"],
    "thumbtack": [384, 512, [128204, 128392, "thumb-tack"], "f08d", "M32 32C32 14.3 46.3 0 64 0L320 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-29.5 0 10.3 134.1c37.1 21.2 65.8 56.4 78.2 99.7l3.8 13.4c2.8 9.7 .8 20-5.2 28.1S362 352 352 352L32 352c-10 0-19.5-4.7-25.5-12.7s-8-18.4-5.2-28.1L5 297.8c12.4-43.3 41-78.5 78.2-99.7L93.5 64 64 64C46.3 64 32 49.7 32 32zM160 400l64 0 0 112c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-112z"],
    "square-up": [448, 512, [11014, "arrow-alt-square-up"], "f353", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm171.3 92.7l104 104c4.6 4.6 5.9 11.5 3.5 17.4S334.5 256 328 256l-56 0 0 96c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-96-56 0c-6.5 0-12.3-3.9-14.8-9.9s-1.1-12.9 3.5-17.4l104-104c6.2-6.2 16.4-6.2 22.6 0z"],
    "face-tongue-money": [512, 512, [], "e39d", "M450.6 89.7c38.3 44.7 61.4 102.8 61.4 166.3 0 88-44.4 165.6-112 211.7l0-115.7 8 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-304 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l8 0 0 115.7c-67.6-46.1-112-123.7-112-211.7 0-53.2 16.3-102.7 44.1-143.7 0-1.3-.1-2.6-.1-3.9 0-42.1 25.9-78.2 62.7-93.1 12.1-18.8 33.2-31.3 57.3-31.3 18.7 0 35.6 7.6 47.9 19.8 14.3-2.5 29-3.8 44.1-3.8 17.4 0 34.4 1.7 50.8 5 12.4-13 29.8-21 49.2-21 23.6 0 44.4 12 56.6 30.3 23.3 10.8 39.4 34.4 39.4 61.7 0 4.7-.5 9.3-1.4 13.7zM144 52l0 4c-28.8 .3-52 23.7-52 52.5 0 25.7 18.5 47.6 43.9 51.8l41.7 7c6 1 10.4 6.2 10.4 12.3 0 6.9-5.6 12.5-12.5 12.5L120 192c-11 0-20 9-20 20s9 20 20 20l24 0 0 4c0 11 9 20 20 20s20-9 20-20l0-4.7c25-4.1 44-25.7 44-51.8 0-25.7-18.5-47.6-43.9-51.8l-41.7-7c-6-1-10.4-6.2-10.4-12.3 0-6.9 5.6-12.5 12.5-12.5L192 96c11 0 20-9 20-20s-9-20-20-20l-8 0 0-4c0-11-9-20-20-20s-20 9-20 20zM356 32c-11 0-20 9-20 20l0 4c-28.8 .3-52 23.7-52 52.5 0 25.7 18.5 47.6 43.9 51.8l41.7 7c6 1 10.4 6.2 10.4 12.3 0 6.9-5.6 12.5-12.5 12.5L312 192c-11 0-20 9-20 20s9 20 20 20l24 0 0 4c0 11 9 20 20 20s20-9 20-20l0-4.7c25-4.1 44-25.7 44-51.8 0-25.7-18.5-47.6-43.9-51.8l-41.7-7c-6-1-10.4-6.2-10.4-12.3 0-6.9 5.6-12.5 12.5-12.5L384 96c11 0 20-9 20-20s-9-20-20-20l-8 0 0-4c0-11-9-20-20-20zm-4 448c0 53-43 96-96 96s-96-43-96-96l0-128 192 0 0 128zm-80-80c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 .5c-18.2 3.1-32 18.9-32 37.9 0 17.7 12 33 29.1 37.3l30 7.5c2.9 .7 4.9 3.3 4.9 6.3 0 3.6-2.9 6.5-6.5 6.5L232 496c-8.8 0-16 7.2-16 16s7.2 16 16 16l8 0c0 8.8 7.2 16 16 16s16-7.2 16-16l0-.5c18.2-3.1 32-18.9 32-37.9 0-17.7-12-33-29.1-37.3l-30-7.5c-2.9-.7-4.9-3.3-4.9-6.3 0-3.6 2.9-6.5 6.5-6.5l33.5 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-8 0z"],
    "hand-point-down": [384, 512, [], "f0a7", "M32 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-208-64 0 0 208zM224 320c0 17.7 14.3 32 32 32s32-14.3 32-32l0-64c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 64zm-64 64c17.7 0 32-14.3 32-32l0-48c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 48c0 17.7 14.3 32 32 32zm160-96c0 17.7 14.3 32 32 32s32-14.3 32-32l0-64c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 64zm-96-88l0 .6c9.4-5.4 20.3-8.6 32-8.6 13.2 0 25.4 4 35.6 10.8 8.7-24.9 32.5-42.8 60.4-42.8 11.7 0 22.6 3.1 32 8.6l0-8.6C384 71.6 312.4 0 224 0L162.3 0C119.8 0 79.1 16.9 49.1 46.9L37.5 58.5C13.5 82.5 0 115.1 0 149l0 27c0 35.3 28.7 64 64 64l88 0c22.1 0 40-17.9 40-40s-17.9-40-40-40l-56 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l56 0c39.8 0 72 32.2 72 72z"],
    "face-meh-blank": [512, 512, [128566, "meh-blank"], "f5a4", "M0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm208-48a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm128 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "bowl-hot": [512, 512, ["soup"], "f823", "M152.1-16c-13.3 0-24 10.7-24 24l0 8c0 32.7 15.4 63.6 41.6 83.2 14.1 10.6 22.4 27.2 22.4 44.8l0 8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-8c0-32.7-15.4-63.6-41.6-83.2-14.1-10.6-22.4-27.2-22.4-44.8l0-8c0-13.3-10.7-24-24-24zM33.7 224C15.4 224 1 239.3 2.1 257.5 7.5 349.3 61.7 427.2 138.5 467.2l1.2 9.7c2.5 20 19.5 35 39.7 35l153.4 0c20.2 0 37.2-15 39.7-35l1.2-9.7c76.8-40 131-118 136.4-209.7 1.1-18.2-13.4-33.5-31.6-33.5L33.7 224zM304.1 8c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 8c0 32.7 15.4 63.6 41.6 83.2 14.1 10.6 22.4 27.2 22.4 44.8l0 8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-8c0-32.7-15.4-63.6-41.6-83.2-14.1-10.6-22.4-27.2-22.4-44.8l0-8z"],
    "party-horn": [512, 512, [], "e31b", "M32 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM448 160a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm32 256a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM167 153c-9.4-9.4-9.4-24.6 0-33.9l8.3-8.3c16.7-16.7 27.2-38.6 29.8-62.1l3-27.4C209.6 8.2 221.5-1.3 234.7 .1s22.7 13.3 21.2 26.5l-3 27.4c-3.8 34.3-19.2 66.3-43.6 90.7L201 153c-9.4 9.4-24.6 9.4-33.9 0zM359 311l8.2-8.2c24.4-24.4 56.4-39.8 90.7-43.6l27.4-3c13.2-1.5 25 8 26.5 21.2s-8 25-21.2 26.5l-27.4 3c-23.5 2.6-45.4 13.1-62.1 29.8L393 345c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9zM506.3 8.5c8.6 10.1 7.3 25.3-2.8 33.8l-10 8.5c-14.8 12.5-33.7 19.1-53 18.6-16.6-.4-30.6 12.4-31.6 29l-1.8 30c-2.5 42.5-38.3 75.3-80.8 74.2-7.6-.2-15 2.4-20.7 7.3l-10 8.5c-10.1 8.6-25.3 7.3-33.8-2.8s-7.3-25.3 2.8-33.8l10-8.5c14.8-12.5 33.7-19.1 53-18.6 16.6 .4 30.6-12.4 31.6-29l1.8-30c2.5-42.5 38.3-75.3 80.8-74.2 7.6 .2 15-2.4 20.7-7.3l10-8.5c10.1-8.6 25.3-7.3 33.8 2.8zM150.6 201.4l160 160c7.7 7.7 11 18.8 8.6 29.4s-9.9 19.4-20 23.2L259.5 428.9 83.1 252.5 98 212.8c3.8-10.2 12.6-17.7 23.2-20s21.7 1 29.4 8.6zM48.2 345.6l22.6-60.2 155.8 155.8-60.2 22.6-118.2-118.2zM35.9 378.5l97.6 97.6-90.3 33.8c-11.7 4.4-25 1.5-33.9-7.3S-2.4 480.5 2 468.8l33.8-90.3z"],
    "bells": [640, 512, [], "f77f", "M23.9 263.3l205.8 56.3c-.6-3.3-1.4-6.7-2.2-10l-5.8-21.9c-26.6-101.2 33.7-205.6 134.6-233.1 2.7-.7 5.3-1.4 8-2-16.9-37.7-49.9-67.9-92.6-79.6-75.3-20.6-152.5 23.9-172.3 99.5L93.5 94.4C82.6 135.9 58.2 172.4 24 198l-11.3 8.5c-5.7 4.3-9.8 10.4-11.6 17.4-4.5 17.1 5.7 34.8 22.8 39.5zm104.4 78.3c2.9 32.7 30.3 58.3 63.8 58.3 12.1 0 23.4-3.4 33.1-9.2 2.3-7 4-14.1 5.1-21.3l-102-27.9zM296.1 478.9l320-87.5c17.1-4.7 27.3-22.4 22.8-39.5-1.8-7-5.9-13.1-11.6-17.4L616 326c-34.1-25.6-58.6-62.1-69.5-103.6l-5.8-21.9C520.9 125 443.8 80.4 368.4 101S248.1 199.6 267.9 275.1l5.8 21.9c10.9 41.5 7.6 85.6-9.4 125.2l-5.6 13.1c-2.8 6.6-3.4 14-1.6 21 4.5 17.1 22 27.2 39.1 22.6zm63.9 32.3c10.9 19.6 31.9 32.9 55.9 32.9 35.3 0 64-28.7 64-64 0-.6 0-1.1 0-1.7L360.1 511.1z"],
    "temperature-empty": [320, 512, ["temperature-0", "thermometer-0", "thermometer-empty"], "f2cb", "M64 96c0-53 43-96 96-96s96 43 96 96l0 164.7c29.5 26.4 48 64.7 48 107.3 0 79.5-64.5 144-144 144S16 447.5 16 368c0-42.6 18.5-81 48-107.3L64 96zm96 336c35.3 0 64-28.7 64-64s-28.7-64-64-64-64 28.7-64 64 28.7 64 64 64z"],
    "popcorn": [384, 512, [127871], "f819", "M2.7 160c-1.8-5-2.7-10.4-2.7-16 0-26.5 21.5-48 48-48 3.9 0 7.6 .5 11.2 1.3-2.1-5.4-3.2-11.2-3.2-17.3 0-26.5 21.5-48 48-48 12.8 0 24.4 5 33 13.2 5-25.8 27.7-45.2 55-45.2s49.9 19.4 55 45.2c8.6-8.2 20.2-13.2 33-13.2 26.5 0 48 21.5 48 48 0 6.1-1.1 11.9-3.2 17.3 3.6-.9 7.4-1.3 11.2-1.3 26.5 0 48 21.5 48 48 0 5.6-1 11-2.7 16L2.7 160zm259.7 48l-27.6 304-85.6 0-27.6-304 140.9 0zM0 208l73.4 0 27.6 304-25.8 0c-24.6 0-45.2-18.5-47.7-43L0 208zM283 512l27.6-304 73.4 0-27.5 261c-2.6 24.4-23.2 43-47.7 43L283 512z"],
    "border-left": [448, 512, [], "f84f", "M32 480c-17.7 0-32-14.3-32-32L0 64C0 46.3 14.3 32 32 32S64 46.3 64 64l0 384c0 17.7-14.3 32-32 32zm128-64a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm0-320a32 32 0 1 1 0-64 32 32 0 1 1 0 64zM288 480c-17.7 0-32-14.3-32-32s14.3-32 32-32 32 14.3 32 32-14.3 32-32 32zm0-384a32 32 0 1 1 0-64 32 32 0 1 1 0 64zM416 480c-17.7 0-32-14.3-32-32s14.3-32 32-32 32 14.3 32 32-14.3 32-32 32zm0-384a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm0 192a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm0-64a32 32 0 1 1 0-64 32 32 0 1 1 0 64z"],
    "border-none": [448, 512, [], "f850", "M32 416c-17.7 0-32 14.3-32 32s14.3 32 32 32 32-14.3 32-32-14.3-32-32-32zM160 32a32 32 0 1 0 0 64 32 32 0 1 0 0-64zM288 416c-17.7 0-32 14.3-32 32s14.3 32 32 32 32-14.3 32-32-14.3-32-32-32zM160 480c17.7 0 32-14.3 32-32s-14.3-32-32-32-32 14.3-32 32 14.3 32 32 32zM288 32a32 32 0 1 0 0 64 32 32 0 1 0 0-64zM416 480c17.7 0 32-14.3 32-32s-14.3-32-32-32-32 14.3-32 32 14.3 32 32 32zm0-384a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM32 32a32 32 0 1 0 0 64 32 32 0 1 0 0-64zM416 352a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM32 160a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm0 192a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM416 160a32 32 0 1 0 0 64 32 32 0 1 0 0-64z"],
    "highlighter": [576, 512, [], "f591", "M315 315L473.4 99.9 444.1 70.6 229 229 315 315zm-187 5l0 0 0-71.7c0-15.3 7.2-29.6 19.5-38.6L420.6 8.4C428 2.9 437 0 446.2 0 457.6 0 468.5 4.5 476.6 12.6l54.8 54.8c8.1 8.1 12.6 19 12.6 30.5 0 9.2-2.9 18.2-8.4 25.6L334.4 396.5c-9 12.3-23.4 19.5-38.6 19.5l-71.7 0-25.4 25.4c-12.5 12.5-32.8 12.5-45.3 0l-50.7-50.7c-12.5-12.5-12.5-32.8 0-45.3L128 320zM7 466.3l51.7-51.7 70.6 70.6-19.7 19.7c-4.5 4.5-10.6 7-17 7L24 512c-13.3 0-24-10.7-24-24l0-4.7c0-6.4 2.5-12.5 7-17z"],
    "pallet-box": [576, 512, [], "e208", "M176 0L400 0c26.5 0 48 21.5 48 48l0 160c0 26.5-21.5 48-48 48l-224 0c-26.5 0-48-21.5-48-48l0-160c0-26.5 21.5-48 48-48zM0 352c0-17.7 14.3-32 32-32l512 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32 0 0 64 32 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 512c-17.7 0-32-14.3-32-32s14.3-32 32-32l32 0 0-64-32 0c-17.7 0-32-14.3-32-32zm128 96l128 0 0-64-128 0 0 64zm192 0l128 0 0-64-128 0 0 64z"],
    "star-exclamation": [576, 512, [], "f2f3", "M288.1-32c9 0 17.3 5.1 21.4 13.1l73.6 144.2 159.9 25.4c8.9 1.4 16.3 7.7 19.1 16.3s.5 18-5.8 24.4L441.7 305.9 467 465.8c1.4 8.9-2.3 17.9-9.6 23.2s-17 6.1-25 2L288.1 417.6 143.8 491c-8 4.1-17.7 3.3-25-2s-11-14.2-9.6-23.2L134.4 305.9 20 191.4c-6.4-6.4-8.6-15.8-5.8-24.4s10.2-14.9 19.1-16.3l159.8-25.4 73.6-144.2 1.7-2.9c4.5-6.3 11.8-10.2 19.7-10.2zm0 336a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm0-176c-18.3 0-32.8 15.7-31.3 34l7.3 88c1 12.4 11.4 22 23.9 22s22.9-9.6 23.9-22l7.3-88c1.5-18.3-12.9-34-31.3-34z"],
    "sickle": [512, 512, [], "f822", "M213.2 340.7L181.5 309c-33.9-33.9-53-80-53-128 0-100 81-181 181-181l11 0c90.1 0 165.8 62.1 186.4 145.8 1.8 7.3-4 14.2-11.5 14.2-3.9 0-7.5-1.9-9.9-4.9-26.1-32.2-65.4-51.1-107.1-51.1-76.1 0-137.8 61.7-137.8 137.8l0 9.8c0 20.7 5.2 39.7 12.2 58.6 2.2 6 .9 12.8-3.7 17.3l-13.2 13.2c-6.2 6.2-16.4 6.2-22.6 0zM121.5 311c34.7 34.7 73.3 73.3 80 80 9.4 9.4 9.4 24.6 0 33.9l-16 16c-9.4 9.4-24.6 9.4-33.9 0l-7-7-71 71c-9.4 9.4-24.6 9.4-33.9 0l-32-32c-9.4-9.4-9.4-24.6 0-33.9l71-71-7-7c-9.4-9.4-9.4-24.6 0-33.9l16-16c9.4-9.4 24.6-9.4 33.9 0z"],
    "money-bill-wave": [512, 512, [], "f53a", "M0 419.6L0 109.5c0-23.2 24.1-38.6 46.3-32 87.7 26.2 149.7 5.5 212.1-15.3 64.5-21.5 129.4-43.1 223.3-13.1 18.5 5.9 30.3 23.8 30.3 43.3l0 310.1c0 23.2-24.1 38.6-46.2 32-87.7-26.2-149.8-5.5-212.1 15.3-64.5 21.5-129.4 43.1-223.3 13.1-18.5-5.9-30.3-23.8-30.3-43.3zM336 256c0-53-35.8-96-80-96s-80 43-80 96 35.8 96 80 96 80-43 80-96zM120 413.6c4.4 0 7.9-3.8 7.2-8.1-4.6-27.8-27-49.5-55.2-53-4.4-.5-8 3.1-8 7.5l0 39.9c0 3.6 2.4 6.8 6 7.7 17.9 4.2 34.3 6.1 50 6.1zm318.5-51.1c5 .8 9.5-3 9.5-8l0-42.6c0-4.4-3.6-8.1-8-7.5-25.2 3.1-45.9 20.9-53.2 44.6-1.4 4.7 2.3 9.1 7.2 9.2 14.2 .4 29 1.7 44.4 4.3zM448 152l0-39.9c0-3.6-2.5-6.8-6-7.7-17.9-4.2-34.3-6.1-50-6.1-4.4 0-7.9 3.8-7.2 8.1 4.6 27.8 27 49.5 55.2 53 4.4 .5 8-3.1 8-7.5zM125.2 162.9c1.4-4.7-2.3-9.1-7.2-9.2-14.2-.4-29-1.7-44.4-4.3-5-.8-9.5 3-9.5 8L64 200c0 4.4 3.6 8.1 8 7.5 25.2-3.1 45.9-20.9 53.2-44.6z"],
    "plane-tail": [512, 512, [], "e22c", "M98.6 0l59.3 0c26.8 0 52.4 11.2 70.6 31l207.3 225 76.2 0 0 256-51.4 0C312.4 512 168.8 460.3 54.5 365.9 40.3 354.1 32 336.6 32 318.1 32 283.8 59.8 256 94.1 256l36 0-62.3-215.1C61.9 20.4 77.3 0 98.6 0zM248 336c-13.3 0-24 10.7-24 24s10.7 24 24 24l176 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-176 0z"],
    "toilet-paper-slash": [576, 512, [], "e072", "M41-24.9c-9.4-9.4-24.6-9.4-33.9 0S-2.3-.3 7 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-94.5-94.5c40.2-23 69.5-96.9 69.5-184.6 0-106-43-192-96-192s-96 86-96 192c0 24.1 2.2 47.2 6.3 68.4L304 238.2 304 224c0-58.9 11.8-114.5 33.2-157.2 5.9-11.7 13.1-23.7 21.9-34.8L128 32c-8.3 0-16.4 2.1-24.1 6.1l-63-63zM32 224l0 264c0 30.9 25.1 56 56 56l160 0c30.9 0 56-25.1 56-56l0-114.2-256-256C37.9 148.2 32 184.7 32 224zm416 64c-17.7 0-32-28.7-32-64s14.3-64 32-64 32 28.7 32 64-14.3 64-32 64z"],
    "siren-on": [640, 512, [], "e02e", "M69.3 36l48 32c11 7.4 14 22.3 6.7 33.3s-22.3 14-33.3 6.7l-48-32c-11-7.4-14-22.3-6.7-33.3s22.3-14 33.3-6.7zM597.3 76l-48 32c-11 7.4-25.9 4.4-33.3-6.7s-4.4-25.9 6.7-33.3l48-32c11-7.4 25.9-4.4 33.3 6.7s4.4 25.9-6.7 33.3zM24 192l64 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-64 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zm528 0l64 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-64 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zM144 304L169.4 88.5C173.1 56.3 200.5 32 232.9 32l174.2 0c32.5 0 59.8 24.3 63.6 56.5L496 304 258.3 304 271.9 154.2c1.2-13.2-8.5-24.9-21.7-26.1s-24.9 8.5-26.1 21.7l-14 154.2-66.1 0zM96 384c0-17.7 14.3-32 32-32l384 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-384 0c-17.7 0-32-14.3-32-32l0-64z"],
    "file-shield": [576, 512, [], "e4f0", "M96 0C60.7 0 32 28.7 32 64l0 384c0 35.3 28.7 64 64 64l201.2 0C261 469.4 240 414.5 240 356.4l0-31.1c0-34.4 22-65 54.7-75.9l112-37.3c3.1-1 6.2-1.8 9.3-2.5l0-39.1c0-17-6.7-33.3-18.7-45.3L290.7 18.7C278.7 6.7 262.5 0 245.5 0L96 0zM357.5 176L264 176c-13.3 0-24-10.7-24-24L240 58.5 357.5 176zm87.8 312.5l-13.3 6.3 0-188.1 96 32 0 19.6c0 55.8-32.2 106.5-82.7 130.3zM421.9 259.5l-112 37.3c-13.1 4.4-21.9 16.6-21.9 30.4l0 31.1c0 74.4 43 142.1 110.2 173.7l18.5 8.7c4.8 2.2 10 3.4 15.2 3.4s10.5-1.2 15.2-3.4l18.5-8.7C533 500.3 576 432.6 576 358.2l0-31.1c0-13.8-8.8-26-21.9-30.4l-112-37.3c-6.6-2.2-13.7-2.2-20.2 0z"],
    "whiskey-glass-ice": [448, 512, ["glass-whiskey-rocks"], "f7a1", "M0 64C0 46.3 14.3 32 32 32l384 0c17.7 0 32 14.3 32 32l0 288c0 70.7-57.3 128-128 128l-192 0C57.3 480 0 422.7 0 352L0 64zM64 224l43.5 0c-3.7 12.6-4.1 26.3-.5 39.9l19.9 74.2c10.5 39.3 50.9 62.6 90.1 52l74.2-19.9c39.3-10.5 62.6-50.9 52-90.1l-15-56.1 55.8 0 0-128-320 0 0 128zm213-5.7l19.9 74.2c3.7 13.7-4.4 27.7-18.1 31.4l-74.2 19.9c-13.7 3.7-27.7-4.4-31.4-18.1l-19.9-74.2c-3.7-13.7 4.4-27.7 18.1-31.4l74.2-19.9c13.7-3.7 27.7 4.4 31.4 18.1z"],
    "squid": [512, 512, [129425], "e450", "M512.8 18.3c.9-5.1-.8-10.3-4.5-13.9S499.5-1 494.4-.1C458 6 425.2 13.6 395.8 22.5L283.3 2c-6.9-1.3-14 1-18.9 5.9-5.1 5.1-7.2 12.3-5.8 19.3l10.4 51.8c-72.4 47-103.2 103.6-109.4 150.4-2.6-4.9-5.9-9.4-10-13.5l-28.2-28.2c-6.2-6.2-6.2-16.4 0-22.6l56.4-56.4c18.9-18.9 18.7-49.5-.3-68.2L140.2 4.3c-6.3-6.1-16.3-6.1-22.5 .1l-2.8 2.8c-34 34-33.3 87.7-1.9 121L98.6 142.5c-18.7 18.7-18.7 49.1 0 67.9l28.2 28.2c9.4 9.4 9.4 24.7 0 34.2s-24.7 9.4-34.2 0c-3.2-3.2-9-9-17.4-17.4-18.7-18.7-49.1-18.7-67.9 0-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0 16.4-6.2 22.6 0c13.3 13.3 24.1 24.1 55.7 55.7-4.9 1.8-9.7 4.4-14.1 7.7L65 363.6c-3.5 2.6-7.7 4-12 4-11 0-19.9-8.9-19.9-19.9l0-12.1c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 12.1c0 28.7 23.2 51.9 51.9 51.9 11.3 0 22.3-3.7 31.4-10.5L113.6 367c9.1-6.9 22-6 30.1 2.1s9 20.9 2.1 30.1l-22.2 29.3c-6.8 9-10.5 20-10.5 31.4 0 28.7 23.2 51.9 51.9 51.9l12.1 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-12.1 0c-11 0-19.9-8.9-19.9-19.9 0-4.3 1.4-8.6 4-12l22.2-29.3c3.3-4.4 5.9-9.1 7.7-14.1l38.2 38.2c2.4 2.4 7.9 7.9 16.4 16.4 6.2 6.2 6.2 16.4 0 22.6s-6.2 16.4 0 22.6 16.4 6.2 22.6 0c18.7-18.7 18.7-49.1 0-67.9-8.6-8.6-14-14-16.4-16.4-9.3-9.3-9.3-24.6 .1-34.1s24.7-9.4 34.1-.1l28.3 28.3c18.7 18.7 49.1 18.7 67.9 0l14.3-14.3c33.3 31.4 87 32.1 121-1.9l2.8-2.8c6.2-6.2 6.3-16.3 .1-22.5l-36.4-37.1c-18.7-19-49.3-19.2-68.2-.3l-56.3 56.4c-6.2 6.2-16.4 6.2-22.6 0l-28.3-28.3c-4-4-8.6-7.3-13.4-9.9 46.9-6.3 103.6-37.2 150.6-109.8l51.2 10.2c7 1.4 14.2-.8 19.3-5.8 5-5 7.2-12 5.9-18.9L490 117.7C499 88 506.7 55 512.8 18.3zM169 279.7a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm64 32a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"],
    "text-height": [576, 512, [], "f034", "M40 32C17.9 32 0 49.9 0 72l0 56c0 17.7 14.3 32 32 32s32-14.3 32-32l0-32 64 0 0 320-32 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l128 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0 0-320 64 0 0 32c0 17.7 14.3 32 32 32s32-14.3 32-32l0-56c0-22.1-17.9-40-40-40L40 32zM438.6 361.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l64 64c12.5 12.5 32.8 12.5 45.3 0l64-64c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-9.4 9.4 0-229.5 9.4 9.4c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-64-64c-6-6-14.1-9.4-22.6-9.4s-16.6 3.4-22.6 9.4l-64 64c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l9.4-9.4 0 229.5-9.4-9.4z"],
    "money-check-dollar-pen": [640, 512, ["money-check-edit-alt"], "f873", "M96.1 64c-35.3 0-64 28.7-64 64l0 256c0 35.3 28.7 64 64 64l191.5 0c5.3-18 15-34.4 28.3-47.8l64.2-64.2-52 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l100 0 58.1-58.1c16.3-16.3 36.7-26.1 57.9-29.4l0-72.5c0-35.3-28.7-64-64-64l-384 0zm208 136c0-13.3 10.7-24 24-24l128 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-128 0c-13.3 0-24-10.7-24-24zm-124-56c11 0 20 9 20 20l0 4 8 0c11 0 20 9 20 20s-9 20-20 20l-47.5 0c-6.9 0-12.5 5.6-12.5 12.5 0 6.1 4.4 11.3 10.4 12.3l41.7 7c25.3 4.2 43.9 26.1 43.9 51.8 0 26.1-19 47.7-44 51.8l0 4.7c0 11-9 20-20 20s-20-9-20-20l0-4-24 0c-11 0-20-9-20-20s9-20 20-20l55.5 0c6.9 0 12.5-5.6 12.5-12.5 0-6.1-4.4-11.3-10.4-12.3l-41.7-7c-25.3-4.2-43.9-26.1-43.9-51.8 0-28.8 23.2-52.2 52-52.5l0-4c0-11 9-20 20-20zM332.3 466.9l-11.9 59.6c-.2 .9-.3 1.9-.3 2.9 0 8 6.5 14.6 14.6 14.6 1 0 1.9-.1 2.9-.3l59.6-11.9c12.4-2.5 23.8-8.6 32.7-17.5l118.9-118.9-80-80-118.9 118.9c-8.9 8.9-15 20.3-17.5 32.7zm267.8-123c22.1-22.1 22.1-57.9 0-80s-57.9-22.1-80 0l-28.8 28.8 80 80 28.8-28.8z"],
    "hand-wave": [576, 512, [], "e1a7", "M392.2 67.4L391 58.9c-2.5-17.6-16.3-31.4-33.9-33.9l-8.5-1.2c-13.1-1.9-22.2-14-20.4-27.2s14-22.2 27.2-20.4l8.5 1.2c38.7 5.5 69.1 36 74.7 74.7l1.2 8.5c1.9 13.1-7.2 25.3-20.4 27.2s-25.3-7.2-27.2-20.4zM217.4 70.6c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0l192 192c3.3 3.3 9.4 1.1 9.4-3.7l0-77.7c0-22.1 17.9-40 40-40s40 17.9 40 40l0 176.3c0 60.2-27.9 116.9-75.5 153.7-50.8 39.2-115.5 49.7-173.6 32.7-28.4-7.1-55.3-21.8-77.6-44.1l-4.9-4.9c-83.9-83.9-130.2-130.2-139.1-139.1-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0l31.9 31.9 .1 .1 46.6 46.6c5.2 5.2 13.6 5.2 18.7 0s5.2-13.6 0-18.7L89.4 198.6c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0L261.3 280c5.2 5.2 13.6 5.2 18.7 0s5.2-13.6 0-18.7L137.4 118.6c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0L325.3 216c5.2 5.2 13.6 5.2 18.7 0s5.2-13.6 0-18.7L217.4 70.6zM28.6 360.2c13.1-1.9 25.3 7.2 27.2 20.4l1.2 8.5c2.5 17.6 16.3 31.4 33.9 33.9l8.5 1.2c13.1 1.9 22.2 14 20.4 27.2s-14 22.2-27.2 20.4l-8.5-1.2C45.4 465 15 434.6 9.5 395.9l-1.2-8.5c-1.9-13.1 7.2-25.3 20.4-27.2z"],
    "chart-candlestick": [512, 512, [], "e0e2", "M64 64c0-17.7-14.3-32-32-32S0 46.3 0 64L0 400c0 44.2 35.8 80 80 80l400 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L80 416c-8.8 0-16-7.2-16-16L64 64zM320 32c-13.3 0-24 10.7-24 24l0 41c-13.8 3.6-24 16.1-24 31l0 96c0 14.9 10.2 27.4 24 31l0 41c0 13.3 10.7 24 24 24s24-10.7 24-24l0-41c13.8-3.6 24-16.1 24-31l0-96c0-14.9-10.2-27.4-24-31l0-41c0-13.3-10.7-24-24-24zM176 64c-13.3 0-24 10.7-24 24l0 33c-13.8 3.6-24 16.1-24 31l0 128c0 14.9 10.2 27.4 24 31l0 33c0 13.3 10.7 24 24 24s24-10.7 24-24l0-33c13.8-3.6 24-16.1 24-31l0-128c0-14.9-10.2-27.4-24-31l0-33c0-13.3-10.7-24-24-24zm288 64c-13.3 0-24 10.7-24 24l0 33c-13.8 3.6-24 16.1-24 31l0 64c0 14.9 10.2 27.4 24 31l0 33c0 13.3 10.7 24 24 24s24-10.7 24-24l0-33c13.8-3.6 24-16.1 24-31l0-64c0-14.9-10.2-27.4-24-31l0-33c0-13.3-10.7-24-24-24z"],
    "transporter-4": [576, 512, [], "e2a5", "M240-32c-8.8 0-16 7.2-16 16s7.2 16 16 16l96 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-96 0zm0 64c-8.8 0-16 7.2-16 16s7.2 16 16 16l96 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-96 0zM208 96c-8.8 0-16 7.2-16 16s7.2 16 16 16l160 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L208 96zm-32 64c-8.8 0-16 7.2-16 16s7.2 16 16 16l224 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-224 0zm-32 64c-8.8 0-16 7.2-16 16s7.2 16 16 16l288 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-288 0zm-16 64c-8.8 0-16 7.2-16 16s7.2 16 16 16l320 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-320 0zm80 64c-8.8 0-16 7.2-16 16s7.2 16 16 16l160 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-160 0zm0 64c-8.8 0-16 7.2-16 16s7.2 16 16 16l160 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-160 0zm-56 80c-13.3 0-24 10.7-24 24s10.7 24 24 24l272 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-272 0zM64 384l-7.3-25.4c-1.1-3.9-4.7-6.6-8.7-6.6s-7.6 2.7-8.7 6.6L32 384 6.6 391.3C2.7 392.4 0 395.9 0 400s2.7 7.6 6.6 8.7L32 416 39.3 441.4c1.1 3.9 4.7 6.6 8.7 6.6s7.6-2.7 8.7-6.6L64 416 89.4 408.7c3.9-1.1 6.6-4.7 6.6-8.7s-2.7-7.6-6.6-8.7L64 384zM536.7 134.6c-1.1-3.9-4.7-6.6-8.7-6.6s-7.6 2.7-8.7 6.6l-7.3 25.4-25.4 7.3c-3.9 1.1-6.6 4.7-6.6 8.7s2.7 7.6 6.6 8.7l25.4 7.3 7.3 25.4c1.1 3.9 4.7 6.6 8.7 6.6s7.6-2.7 8.7-6.6l7.3-25.4 25.4-7.3c3.9-1.1 6.6-4.7 6.6-8.7s-2.7-7.6-6.6-8.7l-25.4-7.3-7.3-25.4z"],
    "pan-food": [640, 512, [129368], "e42b", "M320 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm0-448c37.2 0 69.3 26.3 76.6 62.8l.6 3.2c1.4 7.3-4.1 14-11.5 14l-131.4 0c-7.4 0-12.9-6.8-11.5-14l.6-3.2C250.7 90.3 282.8 64 320 64zM230.1 185.9c7.8 7.8 7.8 20.5 0 28.3l-32 32c-7.8 7.8-20.5 7.8-28.3 0s-7.8-20.5 0-28.3l32-32c7.8-7.8 20.5-7.8 28.3 0zM296 224a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM416 360a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM227.3 284.7c2.1 2.1 3.5 4.6 4.2 7.3 .4 1.7 .8 3.4 1.1 5.1 1.1 5.4 2.1 11 5.9 14.7l3.4 3.4c3 3 7.1 4.7 11.3 4.7l26.7 0c30.9 0 56 25.1 56 56s-25.1 56-56 56-56-25.1-56-56l0-26.7c0-4.2-1.7-8.3-4.7-11.3l-3.4-3.4c-3.8-3.8-9.3-4.8-14.7-5.9-1.7-.3-3.5-.7-5.1-1.1-2.7-.7-5.2-2.1-7.3-4.2-6.2-6.2-6.2-16.4 0-22.6l16-16c6.2-6.2 16.4-6.2 22.6 0zM455.8 184.2c4.5-4.5 11.9-4.5 16.4 0l2.8 2.8c13.4 13.4 21 31.6 21 50.6l0 4.8c0 18.7-8.5 36.4-23.1 48.1-10.9 8.7-24.5 13.5-38.5 13.5l-4.1 0c-19.4 0-38-7.7-51.8-21.4l-2.4-2.4c-4.5-4.5-4.5-11.9 0-16.4l79.6-79.6zM24 160c-13.3 0-24 10.7-24 24L0 328c0 13.3 10.7 24 24 24s24-10.7 24-24l0-144c0-13.3-10.7-24-24-24zm616 24c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 144c0 13.3 10.7 24 24 24s24-10.7 24-24l0-144z"],
    "eurozone-sign": [512, 512, [], "e740", "M0 96C0 78.3 14.3 64 32 64l160 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-128 0 0 96 112 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-112 0 0 96 128 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 448c-17.7 0-32-14.3-32-32L0 96zm272 0c0-17.7 14.3-32 32-32l176 0c11.3 0 21.8 6 27.5 15.7s5.9 21.8 .5 31.7L358.1 384 480 384c17.7 0 32 14.3 32 32s-14.3 32-32 32l-176 0c-11.3 0-21.8-6-27.5-15.7s-5.9-21.8-.5-31.7L425.9 128 304 128c-17.7 0-32-14.3-32-32z"],
    "face-grin-tongue": [512, 512, [128539, "grin-tongue"], "f589", "M0 256c0 104.4 62.5 194.2 152.2 234.1-5.3-13-8.2-27.2-8.2-42.1l0-61.7c-16.9-16.5-30.1-36.7-38.3-59.3-4.3-11.8 7.7-21.8 19.6-18.1 39.2 12.2 83.7 19.1 130.7 19.1s91.5-6.9 130.7-19.1c11.9-3.7 23.9 6.3 19.6 18.1-8.3 22.6-21.5 42.8-38.3 59.3l0 61.7c0 14.9-2.9 29.1-8.2 42.1 89.7-39.8 152.2-129.6 152.2-234.1 0-141.4-114.6-256-256-256S0 114.6 0 256zm176-80a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm128 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm16 240l0-45.4c0-14.7-11.9-26.6-26.6-26.6l-2 0c-11.3 0-21.1 7.9-23.6 18.9-2.8 12.6-20.8 12.6-23.6 0-2.5-11.1-12.3-18.9-23.6-18.9l-2 0c-14.7 0-26.6 11.9-26.6 26.6l0 45.4c0 35.3 28.7 64 64 64s64-28.7 64-64z"],
    "potato": [512, 512, [129364], "e440", "M466.3 249.2c28.1-26.3 45.7-63.7 45.7-105.2 0-79.5-64.5-144-144-144-39.8 0-75.9 16.2-102 42.3-27.4 27.5-61.1 52.6-95.1 71.3-24.1 13.2-44 33.1-57.3 57.3-18.7 34.1-43.8 67.7-71.3 95.1-26.1 26.1-42.3 62.1-42.3 102 0 79.5 64.5 144 144 144 30.3 0 58.4-9.3 81.5-25.3 28.1-19.3 60.2-35.3 92.5-46.2 44.1-14.9 80.1-50.9 93.1-99.2 9.2-34.2 29.4-67.9 55.2-92.1zM384 168a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM192 200a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM136 416a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"],
    "file-signature": [640, 512, [], "f573", "M64.1 64c0-35.3 28.7-64 64-64L277.6 0c17 0 33.3 6.7 45.3 18.7L429.3 125.3c12 12 18.7 28.3 18.7 45.3l0 97.5-132 132-42.1 0-16.1-53.6c-4.7-15.7-19.1-26.4-35.5-26.4-11.3 0-21.9 5.1-28.9 13.9L133.3 409c-8.3 10.3-6.6 25.5 3.7 33.7s25.5 6.6 33.7-3.8l47.1-58.8 15.2 50.7c3 10.2 12.4 17.1 23 17.1l31.5 0c-.9 3.1-1.7 6.3-2.3 9.5l-10.9 54.5-146.2 0c-35.3 0-64-28.7-64-64l0-384zm208-5.5l0 93.5c0 13.3 10.7 24 24 24l93.5 0-117.5-117.5zm60.2 408.4c2.5-12.4 8.6-23.8 17.5-32.7l118.9-118.9 80 80-118.9 118.9c-8.9 8.9-20.3 15-32.7 17.5l-59.6 11.9c-.9 .2-1.9 .3-2.9 .3-8 0-14.6-6.5-14.6-14.6 0-1 .1-1.9 .3-2.9l11.9-59.6zm267.8-123l-28.8 28.8-80-80 28.8-28.8c22.1-22.1 57.9-22.1 80 0s22.1 57.9 0 80z"],
    "square-dashed": [448, 512, [], "e269", "M160 64c0-17.7 14.3-32 32-32l64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32zm-40.2-3.5c2.2 17.5-10.3 33.5-27.8 35.7-14.4 1.8-25.9 13.3-27.7 27.7-2.2 17.5-18.2 30-35.7 27.8S-1.4 133.6 .7 116C6.2 72.6 40.6 38.2 84 32.7 101.6 30.6 117.6 43 119.8 60.5zm208.5 0c2.2-17.5 18.2-30 35.7-27.8 43.5 5.4 77.9 39.8 83.3 83.3 2.2 17.5-10.3 33.5-27.8 35.7s-33.5-10.3-35.7-27.8c-1.8-14.4-13.3-25.9-27.7-27.7-17.5-2.2-30-18.2-27.8-35.7zM32 192c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32S0 305.7 0 288l0-64c0-17.7 14.3-32 32-32zm384 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32zM28.5 360.2c17.5-2.2 33.5 10.3 35.7 27.8 1.8 14.4 13.3 25.9 27.7 27.7 17.5 2.2 30 18.2 27.8 35.7s-18.2 30-35.7 27.8C40.6 473.8 6.2 439.4 .7 396-1.4 378.4 11 362.4 28.5 360.2zm390.9 0c17.5 2.2 30 18.2 27.8 35.7-5.4 43.5-39.8 77.9-83.3 83.3-17.5 2.2-33.5-10.3-35.7-27.8s10.3-33.5 27.8-35.7c14.4-1.8 25.9-13.3 27.7-27.7 2.2-17.5 18.2-30 35.7-27.8zM160 448c0-17.7 14.3-32 32-32l64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32z"],
    "steak": [576, 512, [129385], "f824", "M143.9 288.1c56.7 0 109.3-22.2 137.5-74.3l45.5-84.1c11.3-20.8 33-33.8 56.7-33.8 35.6 0 64.4 28.8 64.4 64.4L448 288c0 53-43 96-96 96l-208.1 0C117.5 384 96 362.5 96 336.1s21.5-47.9 47.9-47.9zM416 192a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm-272.1 .1C64.4 192.1 0 256.6 0 336.1S64.4 480 143.9 480L352 480c106 0 192-86 192-192l0-127.6C544 71.8 472.2 0 383.6 0 324.7 0 270.5 32.3 242.5 84.1L197 168.2c-11.3 20.9-31.8 24-53 24zm0 64c45 0 86.7-15.8 109.3-57.5l45.5-84.1c16.8-31.1 49.4-50.5 84.8-50.5 53.3 0 96.4 43.2 96.4 96.4L480 288c0 70.7-57.3 128-128 128l-208.1 0C99.8 416 64 380.2 64 336.1s35.8-79.9 79.9-79.9z"],
    "axe-battle": [512, 512, [], "f6b3", "M288 32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-480zM176 106.6C142.2 87.1 116.3 55.6 103.9 17.9 100.1 6.2 85.6 .6 76.8 9.2 29.4 55.7 0 120.4 0 192S29.4 328.3 76.8 374.8c8.8 8.6 23.3 3 27.2-8.7 12.4-37.7 38.3-69.2 72.1-88.7l0-170.8zM336 277.4c33.8 19.5 59.7 51 72.1 88.7 3.8 11.7 18.3 17.3 27.2 8.7 38.3-37.5 64.8-86.9 73.6-142.3L448 192 508.8 151.5c-8.8-55.3-35.3-104.8-73.6-142.3-8.8-8.6-23.3-3-27.2 8.7-12.3 37.7-38.3 69.2-72.1 88.7l0 170.8z"],
    "circle-quarter-stroke": [512, 512, [], "e5d3", "M64 256l160 0c17.7 0 32-14.3 32-32l0-160c106 0 192 86 192 192S362 448 256 448 64 362 64 256zM0 256a256 256 0 1 0 512 0 256 256 0 1 0 -512 0z"],
    "phone-hangup": [640, 512, [], "e225", "M602 366.2c-10.1 17.7-31.8 25.1-50.6 17.4l-97.5-40.1c-16.6-6.8-26.7-23.7-24.9-41.5l5.7-56.7c-73.6-27.7-154.9-29-229.2-3.9l6.1 60.7c1.8 17.8-8.3 34.7-24.9 41.5L89.1 383.6c-18.8 7.8-40.5 .3-50.6-17.4l-2.9-5c-33.2-58.2-28-141.4 37.3-183.9 149.9-97.5 344.7-97.5 494.6 0 65.4 42.5 70.5 125.8 37.3 183.9l-2.9 5z"],
    "square-heart": [448, 512, [128159, "heart-square"], "f4c8", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM217.6 199.5l6.4 8.5 6.4-8.5c11.1-14.8 28.5-23.5 46.9-23.5 32.4 0 58.7 26.3 58.7 58.7l0 5.3c0 49.1-65.8 98.1-96.5 118.3-9.5 6.2-21.5 6.2-30.9 0-30.7-20.2-96.5-69.3-96.5-118.3l0-5.3c0-32.4 26.3-58.7 58.7-58.7 18.5 0 35.9 8.7 46.9 23.5z"],
    "conveyor-belt": [640, 512, [], "f46e", "M208 0L432 0c26.5 0 48 21.5 48 48l0 160c0 26.5-21.5 48-48 48l-224 0c-26.5 0-48-21.5-48-48l0-160c0-26.5 21.5-48 48-48zM0 416c0-53 43-96 96-96l448 0c53 0 96 43 96 96s-43 96-96 96L96 512c-53 0-96-43-96-96zm160 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm160 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm224-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "box-check": [448, 512, [], "f467", "M335.1 16c20.7 0 40.1 10 52.1 26.8l48.9 68.5c7.7 10.8 11.9 23.9 11.9 37.2l0 267.5-.3 6.5c-3.1 30.1-27 54.1-57.1 57.1l-6.5 .3-320 0-6.5-.3c-30.1-3.1-54.1-27-57.1-57.1L0 416 0 148.5c0-11.7 3.2-23.1 9.2-33l2.7-4.2 48.9-68.5c10.5-14.7 26.7-24.2 44.4-26.3l7.7-.5 222.1 0zM314.9 212.6c-10.7-7.8-25.7-5.4-33.5 5.3l-85.6 117.7-26.5-27.4c-9.2-9.5-24.4-9.8-33.9-.6s-9.8 24.4-.6 33.9l46.4 48c4.9 5.1 11.8 7.8 18.9 7.3s13.6-4.1 17.8-9.8L320.2 246.1c7.8-10.7 5.4-25.7-5.3-33.5zM78.7 128l290.7 0-34.3-48-222.1 0-34.3 48z"],
    "blanket-fire": [640, 512, [], "e3da", "M216 480c-63.6 0-115.6-49.5-119.7-112l-.3 0 0-248c0-48.6 39.4-88 88-88l272 0c48.6 0 88 39.4 88 88l0 52.2c-12 .3-23.8 3.9-34.1 11-7.9-7.9-15.9-15.6-24.2-23.1-23.8-21.4-60-21.5-83.9-.2-36.4 32.6-67.7 69.8-90.2 106.4-4.3 7-8.5 14.2-12.4 21.7L216 288c-39.8 0-72 32.2-72 72s32.2 72 72 72l62 0c4.1 16.8 10.2 32.9 18.1 48L216 480zm56-97.9l0 1.9-56 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l63.2 0c-4.5 15.3-7.2 30.8-7.2 46.1zM505.7 240.3L518 226.5c5.4-6.1 13.3-8.8 20.9-8.9 7.2 0 14.3 2.6 19.9 7.8 19.7 18.3 39.8 43.2 55 70.6 15.1 27.2 26.2 58.1 26.2 88.1 0 88.7-71.3 159.8-160 159.8-89.6 0-160-71.3-160-159.8 0-37.3 16-73.4 36.8-104.5 20.9-31.3 47.5-59 70.9-80.2 5.7-5.2 13.1-7.7 20.3-7.5s13.4 3.2 18.8 7.5c14.4 11.4 38.9 40.7 38.9 40.7zM544 432.2c0-36.5-37-73-54.8-88.4-5.4-4.7-13.1-4.7-18.5 0-17.7 15.4-54.8 51.9-54.8 88.4 0 35.3 28.7 64 64 64s64-28.7 64-64z"],
    "square-9": [448, 512, [], "e25e", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM168 344c0-13.3 10.7-24 24-24l48 0c13.3 0 24-10.7 24-24l0-12.1c-7.5 2.7-15.6 4.1-24 4.1l-32 0c-39.8 0-72-32.2-72-72s32.2-72 72-72l32 0c39.8 0 72 32.2 72 72l0 80c0 39.8-32.2 72-72 72l-48 0c-13.3 0-24-10.7-24-24zm72-152l-32 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l32 0c13.3 0 24-10.7 24-24s-10.7-24-24-24z"],
    "building-wheat": [640, 512, [], "e4db", "M96 0C60.7 0 32 28.7 32 64l0 384c0 35.3 28.7 64 64 64l249.3 0c-6-14.8-9.3-31-9.3-48 0-17.7 7.2-33.7 18.8-45.3-11.9-19.4-18.8-42.3-18.8-66.7 0-17.7 7.2-33.7 18.8-45.3-11.9-19.4-18.8-42.3-18.8-66.7 0-25.2 14.5-46.9 35.6-57.4-2.4-7.1-3.6-14.7-3.6-22.6l0-32C368 96.7 388 70.1 415.9 60.1 413.9 26.6 386 0 352 0L96 0zM208 352l32 0c17.7 0 32 14.3 32 32l0 80-96 0 0-80c0-17.7 14.3-32 32-32zM128 112c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM272 96l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM128 240c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm144-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zm352 0l-16 0c-44.2 0-80 35.8-80 80 0 8.8 7.2 16 16 16l16 0c44.2 0 80-35.8 80-80 0-8.8-7.2-16-16-16zm16 128c0-8.8-7.2-16-16-16l-16 0c-44.2 0-80 35.8-80 80 0 8.8 7.2 16 16 16l16 0c44.2 0 80-35.8 80-80zm0 112c0-8.8-7.2-16-16-16l-16 0c-44.2 0-80 35.8-80 80 0 8.8 7.2 16 16 16l16 0c44.2 0 80-35.8 80-80zM496 528c0-44.2-35.8-80-80-80l-16 0c-8.8 0-16 7.2-16 16 0 44.2 35.8 80 80 80l16 0c8.8 0 16-7.2 16-16zm-16-96c8.8 0 16-7.2 16-16 0-44.2-35.8-80-80-80l-16 0c-8.8 0-16 7.2-16 16 0 44.2 35.8 80 80 80l16 0zm16-128c0-44.2-35.8-80-80-80l-16 0c-8.8 0-16 7.2-16 16 0 44.2 35.8 80 80 80l16 0c8.8 0 16-7.2 16-16zM512 64c-13.3 0-24 10.7-24 24l0 104c0 13.3 10.7 24 24 24s24-10.7 24-24l0-104c0-13.3-10.7-24-24-24zm96 64c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 32c0 13.3 10.7 24 24 24s24-10.7 24-24l0-32zM440 104c-13.3 0-24 10.7-24 24l0 32c0 13.3 10.7 24 24 24s24-10.7 24-24l0-32c0-13.3-10.7-24-24-24z"],
    "plug-circle-minus": [640, 512, [], "e55e", "M192-32c17.7 0 32 14.3 32 32l0 96 128 0 0-96c0-17.7 14.3-32 32-32s32 14.3 32 32l0 96 64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l0 48.7c-98.6 8.1-176 90.7-176 191.3 0 27.3 5.7 53.3 16 76.9l0 3.1c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-66.7C165.2 398.1 96 319.1 96 224l0-64c-17.7 0-32-14.3-32-32S78.3 96 96 96l64 0 0-96c0-17.7 14.3-32 32-32zM352 400a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm224 0c0-8.8-7.2-16-16-16l-128 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l128 0c8.8 0 16-7.2 16-16z"],
    "book-spine": [448, 512, [], "e754", "M96 512l320 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l0-66.7c18.6-6.6 32-24.4 32-45.3l0-288c0-26.5-21.5-48-48-48L96 0C43 0 0 43 0 96L0 416c0 53 43 96 96 96zM64 416c0-17.7 14.3-32 32-32l256 0 0 64-256 0c-17.7 0-32-14.3-32-32zM64 96c0-17.7 14.3-32 32-32l64 0 0 256-64 0c-11.2 0-22 1.9-32 5.5L64 96z"],
    "hockey-sticks": [640, 512, [], "f454", "M528 512l-91.6 0c-24.9 0-47.5-14.4-58-36.9l-31.9-68.4 40.5-86.7 141.1 0 0 192zm80-192c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32l-32 0 0-192 32 0zM64 512l-32 0c-17.7 0-32-14.3-32-32L0 352c0-17.7 14.3-32 32-32l32 0 0 192zM420.5-16.4c8.3-13.9 26-19.6 41-12.6s22 24.2 16.7 39.5l-1.2 3-215.4 461.5c-10.5 22.5-33.1 36.9-58 36.9l-91.6 0 0-192 151.3 0 155.7-333.5 1.5-2.9zM178.5-29c16-7.5 35.1-.5 42.5 15.5l72.5 155.3-35.3 75.7-95.2-203.9c-7.5-16-.5-35.1 15.5-42.5z"],
    "down-long-to-line": [320, 512, [], "e6c0", "M32 576c-17.7 0-32-14.3-32-32s14.3-32 32-32l256 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 576zM182.6 438.6c-12.5 12.5-32.8 12.5-45.3 0l-128-128c-9.2-9.2-11.9-22.9-6.9-34.9S19.1 256 32 256l64 0 0-272c0-26.5 21.5-48 48-48l32 0c26.5 0 48 21.5 48 48l0 272 64 0c12.9 0 24.6 7.8 29.6 19.8s2.2 25.7-6.9 34.9l-128 128z"],
    "colon": [128, 512, [], "3a", "M64 192a64 64 0 1 0 0-128 64 64 0 1 0 0 128zm0 256c35.3 0 64-28.7 64-64s-28.7-64-64-64-64 28.7-64 64 28.7 64 64 64z"],
    "futbol": [512, 512, [9917, "futbol-ball", "soccer-ball"], "f1e3", "M417.3 360.1l-71.6-4.8c-5.2-.3-10.3 1.1-14.5 4.2s-7.2 7.4-8.4 12.5l-17.6 69.6C289.5 445.8 273 448 256 448s-33.5-2.2-49.2-6.4L189.2 372c-1.3-5-4.3-9.4-8.4-12.5s-9.3-4.5-14.5-4.2l-71.6 4.8c-17.6-27.2-28.5-59.2-30.4-93.6L125 228.3c4.4-2.8 7.6-7 9.2-11.9s1.4-10.2-.5-15l-26.7-66.6C128 109.2 155.3 89 186.7 76.9l55.2 46c4 3.3 9 5.1 14.1 5.1s10.2-1.8 14.1-5.1l55.2-46c31.3 12.1 58.7 32.3 79.6 57.9l-26.7 66.6c-1.9 4.8-2.1 10.1-.5 15s4.9 9.1 9.2 11.9l60.7 38.2c-1.9 34.4-12.8 66.4-30.4 93.6zM256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm14.1-325.7c-8.4-6.1-19.8-6.1-28.2 0L194 221c-8.4 6.1-11.9 16.9-8.7 26.8l18.3 56.3c3.2 9.9 12.4 16.6 22.8 16.6l59.2 0c10.4 0 19.6-6.7 22.8-16.6l18.3-56.3c3.2-9.9-.3-20.7-8.7-26.8l-47.9-34.8z"],
    "face-hand-over-mouth": [512, 512, [129762], "e378", "M88 442.2C88 444.6 88.1 447 88.2 449.3 34.2 402.4 0 333.2 0 256 0 114.6 114.6 0 256 0S512 114.6 512 256c0 82.7-39.2 156.3-100.1 203.1 16.5-24.4 14-57.8-7.6-79.4-1.8-1.8-3.7-3.5-5.7-5 13.4-23.9 10-54.7-10.3-75-14.5-14.5-34.4-20.4-53.3-17.7-2.8-5.1-6.4-10-10.7-14.3-24.5-24.5-64.1-24.5-88.6 0l-34.9 34.9c-11.7-13.8-29.3-22.6-48.8-22.6-35.3 0-64 28.7-64 64l0 98.2zM208 192a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm128 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM128 344c0-13.3 10.7-24 24-24s24 10.7 24 24l0 30.3c0 3.6 4.3 5.4 6.8 2.8L264 296c8.8-8.8 23.2-8.8 32 0s8.8 23.2 0 32l-48 48c-4.4 4.4-4.4 11.6 0 16s11.6 4.4 16 0l64-64c8.8-8.8 23.2-8.8 32 0s8.8 23.2 0 32l-64 64c-4.4 4.4-4.4 11.6 0 16s11.6 4.4 16 0l32-32c8.8-8.8 23.2-8.8 32 0s8.8 23.2 0 32l-74.2 74.2c-19.1 19.1-45 29.8-72 29.8-56.2 0-101.8-45.6-101.8-101.8l0-98.2z"],
    "circle-plus": [512, 512, ["plus-circle"], "f055", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM232 344l0-64-64 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l64 0 0-64c0-13.3 10.7-24 24-24s24 10.7 24 24l0 64 64 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-64 0 0 64c0 13.3-10.7 24-24 24s-24-10.7-24-24z"],
    "coffee-pot": [512, 512, [], "e002", "M64 128c0-17.7 14.3-32 32-32l12.8 0 34 84.9C95 215.9 64 272.3 64 336l0 8c0 55.5 34.6 99.4 55.9 121.2 9.9 10.2 23.9 14.8 38.1 14.8L418 480c14.2 0 28.1-4.7 38.1-14.8 21.2-21.7 55.9-65.7 55.9-121.2l0-8c0-63.7-31-120.1-78.8-155.1L478.1 68.8c1.3-3.2 1.9-6.6 1.9-10 0-14.8-12-26.8-26.8-26.8L96 32C43 32 0 75 0 128l0 64c0 17.7 14.3 32 32 32s32-14.3 32-32l0-64zm65 192c5.2-41.4 30.1-76.6 65-96l188 0c34.9 19.4 59.8 54.6 65 96l-318 0z"],
    "square-question": [448, 512, ["question-square"], "f2fd", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM224 176c-17.7 0-32 14.3-32 32 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-44.2 35.8-80 80-80s80 35.8 80 80c0 47.2-36 67.2-56 74.5l0 3.8c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-8.1c0-20.5 14.8-35.2 30.1-40.2 6.4-2.1 13.2-5.5 18.2-10.3 4.3-4.2 7.7-10 7.7-19.6 0-17.7-14.3-32-32-32zM192 368a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"],
    "list-tree": [512, 512, [], "e1d2", "M48 48c-26.5 0-48 21.5-48 48 0 17.8 9.7 33.3 24 41.6L24 384c0 30.9 25.1 56 56 56l54.4 0c8.3 14.3 23.8 24 41.6 24 26.5 0 48-21.5 48-48s-21.5-48-48-48c-17.8 0-33.3 9.7-41.6 24L80 392c-4.4 0-8-3.6-8-8l0-104 62.4 0c8.3 14.3 23.8 24 41.6 24 26.5 0 48-21.5 48-48s-21.5-48-48-48c-17.8 0-33.3 9.7-41.6 24l-62.4 0 0-94.4c14.3-8.3 24-23.8 24-41.6 0-26.5-21.5-48-48-48zM160 96c0 17.7 14.3 32 32 32l288 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L192 64c-17.7 0-32 14.3-32 32zM288 256c0 17.7 14.3 32 32 32l160 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-160 0c-17.7 0-32 14.3-32 32zm0 160c0 17.7 14.3 32 32 32l160 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-160 0c-17.7 0-32 14.3-32 32z"],
    "brazilian-real-sign": [512, 512, [], "e46c", "M400 16c17.7 0 32 14.3 32 32l0 16 16 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-48.9 0c-26 0-47.1 21.1-47.1 47.1 0 22.5 15.9 41.8 37.9 46.2l32.8 6.6c51.9 10.4 89.3 56 89.3 109 0 50.6-33.8 93.3-80 106.7l0 20.4c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-16-32 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l64.9 0c26 0 47.1-21.1 47.1-47.1 0-22.5-15.9-41.8-37.9-46.2l-32.8-6.6c-51.9-10.4-89.3-56-89.3-109 0-50.6 33.8-93.2 80-106.7L368 48c0-17.7 14.3-32 32-32zM0 64C0 46.3 14.3 32 32 32l80 0c79.5 0 144 64.5 144 144 0 54.3-30 101.5-74.4 126.1l41 136.7c5.1 16.9-4.5 34.8-21.5 39.8s-34.8-4.5-39.8-21.5L120.1 319.8c-2.7 .1-5.4 .2-8.1 .2l-48 0 0 128c0 17.7-14.3 32-32 32S0 465.7 0 448L0 64zM64 256l48 0c44.2 0 80-35.8 80-80s-35.8-80-80-80l-48 0 0 160z"],
    "book-open-lines": [512, 512, [], "e753", "M256 141.3l0 309.3 .5-.2C311.1 427.7 369.7 416 428.8 416l19.2 0 0-320-19.2 0c-42.2 0-84.1 8.4-123.1 24.6-16.8 7-33.4 13.9-49.7 20.7zM230.9 61.5L256 72 281.1 61.5C327.9 42 378.1 32 428.8 32L464 32c26.5 0 48 21.5 48 48l0 352c0 26.5-21.5 48-48 48l-35.2 0c-50.7 0-100.9 10-147.7 29.5l-12.8 5.3c-7.9 3.3-16.7 3.3-24.6 0l-12.8-5.3C184.1 490 133.9 480 83.2 480L48 480c-26.5 0-48-21.5-48-48L0 80C0 53.5 21.5 32 48 32l35.2 0c50.7 0 100.9 10 147.7 29.5zm78.4 93c24.4-12.2 51.3-18.5 78.5-18.5l4.2 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-4.2 0c-19.8 0-39.3 4.6-57 13.5-11.9 5.9-26.3 1.1-32.2-10.7s-1.1-26.3 10.7-32.2zm0 96c24.4-12.2 51.3-18.5 78.5-18.5l4.2 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-4.2 0c-19.8 0-39.3 4.6-57 13.5-11.9 5.9-26.3 1.1-32.2-10.7s-1.1-26.3 10.7-32.2zm0 96c24.4-12.2 51.3-18.5 78.5-18.5l4.2 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-4.2 0c-19.8 0-39.3 4.6-57 13.5-11.9 5.9-26.3 1.1-32.2-10.7s-1.1-26.3 10.7-32.2zM88 136c-13.3 0-24 10.7-24 24s10.7 24 24 24l20.2 0c19.8 0 39.3 4.6 57 13.5 11.9 5.9 26.3 1.1 32.2-10.7s1.1-26.3-10.7-32.2c-24.4-12.2-51.3-18.5-78.5-18.5L88 136zm0 96c-13.3 0-24 10.7-24 24s10.7 24 24 24l20.2 0c19.8 0 39.3 4.6 57 13.5 11.9 5.9 26.3 1.1 32.2-10.7s1.1-26.3-10.7-32.2c-24.4-12.2-51.3-18.5-78.5-18.5L88 232zm0 96c-13.3 0-24 10.7-24 24s10.7 24 24 24l20.2 0c19.8 0 39.3 4.6 57 13.5 11.9 5.9 26.3 1.1 32.2-10.7s1.1-26.3-10.7-32.2c-24.4-12.2-51.3-18.5-78.5-18.5L88 328z"],
    "ellipsis-stroke-vertical": [128, 512, ["ellipsis-v-alt"], "f39c", "M80 432c0 8.8-7.2 16-16 16s-16-7.2-16-16 7.2-16 16-16 16 7.2 16 16zm48 0c0-35.3-28.7-64-64-64s-64 28.7-64 64 28.7 64 64 64 64-28.7 64-64zM80 256c0 8.8-7.2 16-16 16s-16-7.2-16-16 7.2-16 16-16 16 7.2 16 16zm48 0c0-35.3-28.7-64-64-64s-64 28.7-64 64 28.7 64 64 64 64-28.7 64-64zM64 96a16 16 0 1 1 0-32 16 16 0 1 1 0 32zm0-80a64 64 0 1 0 0 128 64 64 0 1 0 0-128z"],
    "star-and-crescent": [512, 512, [9770], "f699", "M0 256c0-141.4 114.6-256 256-256 33 0 64.6 6.3 93.6 17.7 7.4 2.9 11.5 10.7 9.8 18.4s-8.8 13-16.7 12.4c-4.8-.3-9.7-.5-14.6-.5-114.9 0-208 93.1-208 208s93.1 208 208 208c4.9 0 9.8-.2 14.6-.5 7.9-.5 15 4.7 16.7 12.4s-2.4 15.5-9.8 18.4C320.6 505.7 289 512 256 512 114.6 512 0 397.4 0 256zM375.4 137.4c3.5-7.1 13.7-7.1 17.2 0l31.5 63.8c1.4 2.8 4.1 4.8 7.2 5.3l70.4 10.2c7.9 1.1 11 10.8 5.3 16.4l-50.9 49.6c-2.3 2.2-3.3 5.4-2.8 8.5l12 70.1c1.3 7.8-6.9 13.8-13.9 10.1l-63-33.1c-2.8-1.5-6.1-1.5-8.9 0l-63 33.1c-7 3.7-15.3-2.3-13.9-10.1l12-70.1c.5-3.1-.5-6.3-2.8-8.5L261 233.1c-5.7-5.6-2.6-15.2 5.3-16.4l70.4-10.2c3.1-.5 5.8-2.4 7.2-5.3l31.5-63.8z"],
    "text-size": [576, 512, [], "f894", "M64 128l0-32 64 0 0 320-32 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l128 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0 0-320 64 0 0 32c0 17.7 14.3 32 32 32s32-14.3 32-32l0-56c0-22.1-17.9-40-40-40L40 32C17.9 32 0 49.9 0 72l0 56c0 17.7 14.3 32 32 32s32-14.3 32-32zM320 320l0-32 64 0 0 128-32 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l128 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0 0-128 64 0 0 32c0 17.7 14.3 32 32 32s32-14.3 32-32l0-56c0-22.1-17.9-40-40-40l-240 0c-22.1 0-40 17.9-40 40l0 56c0 17.7 14.3 32 32 32s32-14.3 32-32z"],
    "face-surprise": [512, 512, [128558, "surprise"], "f5c2", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM176 176a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm128 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm-48 80a64 64 0 1 1 0 128 64 64 0 1 1 0-128z"],
    "hospital-user": [640, 512, [], "f80d", "M64 64C64 28.7 92.7 0 128 0L384 0c35.3 0 64 28.7 64 64l0 121.3c-46.9 19-80 65-80 118.7 0 27.7 8.8 53.4 23.8 74.4-51.5 21-87.8 71.6-87.8 130.7 0 1 0 1.9 0 2.9l-176 0c-35.3 0-64-28.7-64-64L64 64zM208 400l0 64 53.4 0c7.2-29.4 21.3-56.1 40.4-78.3-6.1-19.5-24.3-33.7-45.8-33.7-26.5 0-48 21.5-48 48zM248 88c-8.8 0-16 7.2-16 16l0 32-32 0c-8.8 0-16 7.2-16 16l0 16c0 8.8 7.2 16 16 16l32 0 0 32c0 8.8 7.2 16 16 16l16 0c8.8 0 16-7.2 16-16l0-32 32 0c8.8 0 16-7.2 16-16l0-16c0-8.8-7.2-16-16-16l-32 0 0-32c0-8.8-7.2-16-16-16l-16 0zM416 304a80 80 0 1 1 160 0 80 80 0 1 1 -160 0zM352 512c0-53 43-96 96-96l96 0c53 0 96 43 96 96 0 17.7-14.3 32-32 32l-224 0c-17.7 0-32-14.3-32-32z"],
    "arrow-down-up-lock": [576, 512, [], "e4b0", "M262.6 422.6l-80 80c-12.5 12.5-32.8 12.5-45.3 0l-80-80c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0l25.4 25.4 0-114.7-64 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l256 0 0-114.7-25.4 25.4c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l80-80c12.5-12.5 32.8-12.5 45.3 0l80 80c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0l-25.4-25.4 0 94.8c-25.3 20.3-42.8 50.1-47 83.9l-145 0 0 114.7 25.4-25.4c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3zM192 32l0 144-64 0 0-144c0-17.7 14.3-32 32-32s32 14.3 32 32zM496 304.1c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 47.9 64 0 0-47.9zM352 400c0-20.9 13.4-38.7 32-45.3l0-50.6c0-44.2 35.8-80 80-80s80 35.8 80 80l0 50.6c18.6 6.6 32 24.4 32 45.3l0 96c0 26.5-21.5 48-48 48l-128 0c-26.5 0-48-21.5-48-48l0-96z"],
    "folder": [512, 512, [128193, 128447, 61716, "folder-blank"], "f07b", "M64 448l384 0c35.3 0 64-28.7 64-64l0-240c0-35.3-28.7-64-64-64L298.7 80c-6.9 0-13.7-2.2-19.2-6.4L241.1 44.8C230 36.5 216.5 32 202.7 32L64 32C28.7 32 0 60.7 0 96L0 384c0 35.3 28.7 64 64 64z"],
    "holly-berry": [512, 512, [], "f7aa", "M256.2 96a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm-80 96a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM277 383.8c1 .1 2.1 .2 3.2 .2 39.8 0 72 32.2 72 72l0 22.7c0 16.4 16 27.9 31.6 22.8l12.8-4.3c18-6 37.3-6.5 55.6-1.5l19.4 5.3c17.9 4.9 34.4-11.6 29.5-29.5L495.9 452c-5-18.3-4.4-37.6 1.5-55.6l4.3-12.8c5.2-15.5-6.4-31.6-22.8-31.6-34.6 0-62.7-28.1-62.7-62.7l0-32c0-16.4-16-27.9-31.6-22.8l-12.8 4.3c-18 6-37.3 6.5-55.6 1.5l-29.6-8.1c-2.9-.8-5.9-1-8.7-.7 4.2 9.7 5.8 20.8 3.7 32.3l-6.3 34.8c-1.5 8.4-1.4 17 .5 25.3l5.3 23.9c2.8 12.7 1.1 25.2-4 35.9zM127.8 234.5c-15.5-5.2-31.6 6.4-31.6 22.8l0 32c0 34.6-28.1 62.7-62.7 62.7-16.4 0-27.9 16-22.8 31.6L15 396.4c6 18 6.5 37.3 1.5 55.6l-5.3 19.4C6.4 489.4 22.8 505.8 40.7 501l19.4-5.3c18.3-5 37.6-4.5 55.6 1.5l12.8 4.3c15.5 5.2 31.6-6.4 31.6-22.8l0-32c0-34.6 28.1-62.7 62.7-62.7 16.4 0 27.9-16 22.8-31.6l-4.3-12.8c-6-18-6.5-37.3-1.5-55.6l5.3-19.4c4.9-17.9-11.6-34.4-29.5-29.5l-19.4 5.3c-18.3 5-37.6 4.4-55.6-1.5l-12.8-4.3zM384.2 144a48 48 0 1 0 -96 0 48 48 0 1 0 96 0z"],
    "message-image": [512, 512, ["comment-alt-image"], "e1e0", "M0 128L0 352c0 53 43 96 96 96l32 0 0 72c0 13.3 10.7 24 24 24 5.2 0 10.2-1.7 14.4-4.8l115.2-86.4c4.2-3.1 9.2-4.8 14.4-4.8l120 0c53 0 96-43 96-96l0-224c0-53-43-96-96-96L96 32C43 32 0 75 0 128zm128 16a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm28.6 192c-15.8 0-28.6-12.8-28.6-28.6 0-7.3 2.8-14.4 7.9-19.7l96.8-101.8c6-6.4 14.4-9.9 23.2-9.9l.3 0c8.8 0 17.1 3.6 23.2 9.9l96.8 101.8c5.1 5.3 7.9 12.4 7.9 19.7 0 15.8-12.8 28.6-28.6 28.6l-198.8 0z"],
    "comment-quote": [512, 512, [], "e14c", "M256 480c141.4 0 256-107.5 256-240S397.4 0 256 0 0 107.5 0 240c0 54.3 19.2 104.3 51.6 144.5L2.8 476.8c-4.8 9-3.3 20 3.6 27.5s17.8 9.8 27.1 5.8l118.4-50.7C183.7 472.6 218.9 480 256 480zM152 160l32 0c22.1 0 40 17.9 40 40l0 80c0 39.8-32.2 72-72 72-13.3 0-24-10.7-24-24s10.7-24 24-24 24-10.7 24-24l0-8-24 0c-22.1 0-40-17.9-40-40l0-32c0-22.1 17.9-40 40-40zm232 72l0 48c0 39.8-32.2 72-72 72-13.3 0-24-10.7-24-24s10.7-24 24-24 24-10.7 24-24l0-8-24 0c-22.1 0-40-17.9-40-40l0-32c0-22.1 17.9-40 40-40l32 0c22.1 0 40 17.9 40 40l0 32z"],
    "venus-double": [640, 512, [9890], "f226", "M192 288a112 112 0 1 0 0-224 112 112 0 1 0 0 224zM368 176c0 86.3-62.1 158.1-144.1 173.1 .1 1 .1 1.9 .1 2.9l0 64 32 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32 0 0 32c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-32-32 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l32 0 0-64c0-1 0-1.9 .1-2.9-82-15-144.1-86.8-144.1-173.1 0-97.2 78.8-176 176-176S368 78.8 368 176zM357.5 327c14.4-15.8 26.6-33.7 36.1-53.1 16.1 9 34.7 14.1 54.5 14.1 61.9 0 112-50.1 112-112S509.9 64 448 64c-19.8 0-38.3 5.1-54.5 14.1-9.5-19.4-21.6-37.3-36.1-53.1 26.4-15.9 57.4-25 90.5-25 97.2 0 176 78.8 176 176 0 86.3-62.1 158.1-144.1 173.1 .1 .9 .1 1.9 .1 2.9l0 64 32 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32 0 0 32c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-32-32 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l32 0 0-64c0-1 0-1.9 .1-2.9-21.1-3.9-40.9-11.5-58.6-22.2z"],
    "elephant": [640, 512, [128024], "f6da", "M304 0C242.1 0 192 50.1 192 112s50.1 112 112 112c8.8 0 16 7.2 16 16s-7.2 16-16 16c-79.5 0-144-64.5-144-144 0-25.3 6.5-49.1 18-69.8-20.5 7-39.4 17.3-56.1 30.4-54.4 39.2-89.9 103.2-89.9 175.4l0 19c0 12.4-1.2 24.7-3.7 36.9-1.9 9.3-5.8 18-11.4 25.6L4.8 345.6c-8 10.6-5.8 25.6 4.8 33.6s25.6 5.8 33.6-4.8l12.1-16.2c3.2-4.3 6.1-8.8 8.7-13.5L64 480c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-70c15.3 3.9 31.4 6 48 6s32.7-2.1 48-6l0 70c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-139.3c16.7 18.9 38.8 32.8 64 39.3l0 18.6c0 45 36.5 81.4 81.4 81.4 30.8 0 59-17.4 72.8-45l2.3-4.7c7.9-15.8 1.5-35-14.3-42.9s-35-1.5-42.9 14.3l-2.3 4.7c-3 5.9-9 9.6-15.6 9.6-9.6 0-17.4-7.8-17.4-17.4l0-18.6c22.9-5.9 43.4-18 59.4-34.4 6.2-6.3 6.1-16.4-.2-22.6-6.3-6.2-16.3-6.1-22.5 .1-2.5 2.6-5.4 5.2-8.7 7.8-8.3 6.7-17.8 12-28 15.6l0 0c-10 3.5-20.8 5.5-32 5.5s-22-1.9-32-5.5l0 0c-7.5-2.6-14.6-6.2-21.1-10.5l0 0c-9.1-6.1-17.2-13.7-23.7-22.4-5.3-7.1-3.9-17.1 3.2-22.4s17.1-3.9 22.4 3.2c11.7 15.6 30.3 25.6 51.2 25.6 11.7 0 22.6-3.1 32-8.6L544 192c0-88.4-71.6-160-160-160l-1.6 0C362.2 12.2 334.5 0 304 0zM464 192a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"],
    "clipboard-question": [384, 512, [], "e4e3", "M311.4 32l8.6 0c35.3 0 64 28.7 64 64l0 352c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l8.6 0C83.6 12.9 104.3 0 128 0L256 0c23.7 0 44.4 12.9 55.4 32zM248 112c13.3 0 24-10.7 24-24s-10.7-24-24-24L136 64c-13.3 0-24 10.7-24 24s10.7 24 24 24l112 0zM192 248c16.1 0 29.2 13.1 29.2 29.2 0 8.7-3.1 13.9-6.9 17.7-4.5 4.4-10.7 7.5-16.8 9.5-14.9 5-29.5 19.3-29.5 39.5 0 13.3 10.7 24 24 24 11.5 0 21.2-8.1 23.5-19 19.2-7.1 53.7-26.3 53.7-71.8 0-42.6-34.6-77.2-77.2-77.2s-77.2 34.6-77.2 77.2c0 13.3 10.7 24 24 24s24-10.7 24-24c0-16.1 13.1-29.2 29.2-29.2zm28 168c0-15.5-12.5-28-28-28s-28 12.5-28 28 12.5 28 28 28 28-12.5 28-28z"],
    "hotdog": [512, 512, [127789], "f80f", "M288 0c-20.5 0-40.1 8.1-54.6 22.6L22.6 233.4C8.1 247.9 0 267.5 0 288 0 300.2 2.9 312.1 8.2 322.7L322.7 8.2C312.1 2.9 300.2 0 288 0zM224 512c20.5 0 40.1-8.1 54.6-22.6L489.4 278.6c14.5-14.5 22.6-34.1 22.6-54.6 0-12.2-2.9-24.1-8.2-34.7L189.3 503.8c10.7 5.4 22.6 8.2 34.7 8.2zM456.6 168.6c31.2-31.2 31.2-81.9 0-113.1s-81.9-31.2-113.1 0l-288 288c-31.2 31.2-31.2 81.9 0 113.1s81.9 31.2 113.1 0l288-288z"],
    "arrow-up-from-bracket": [448, 512, [], "e09a", "M246.6 9.4c-12.5-12.5-32.8-12.5-45.3 0l-128 128c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L192 109.3 192 320c0 17.7 14.3 32 32 32s32-14.3 32-32l0-210.7 73.4 73.4c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-128-128zM64 352c0-17.7-14.3-32-32-32S0 334.3 0 352l0 64c0 53 43 96 96 96l256 0c53 0 96-43 96-96l0-64c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 64c0 17.7-14.3 32-32 32L96 448c-17.7 0-32-14.3-32-32l0-64z"],
    "reply-clock": [576, 512, ["reply-time"], "e239", "M288 112a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zM432 32c-8.8 0-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16l48 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-32 0 0-48c0-8.8-7.2-16-16-16zm0 272c26.1 0 51-5.2 73.7-14.7 4.1 14.9 6.3 30.5 6.3 46.7 0 113.3-81.5 163.9-100.2 174.1-2.5 1.4-5.3 1.9-8.1 1.9-10.9 0-19.7-8.9-19.7-19.7 0-7.5 4.3-14.4 9.8-19.5 9.4-8.8 22.2-26.4 22.2-56.7 0-53-43-96-96-96l-96 0 0 80c0 12.9-7.8 24.6-19.8 29.6s-25.7 2.2-34.9-6.9l-160-160c-12.5-12.5-12.5-32.8 0-45.3l160-160c9.2-9.2 22.9-11.9 34.9-6.9S224 67.1 224 80l0 80 22 0c21.3 82.8 96.5 144 186 144z"],
    "chart-line-up": [512, 512, [], "e0e5", "M32 32c17.7 0 32 14.3 32 32l0 336c0 8.8 7.2 16 16 16l400 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L80 480c-44.2 0-80-35.8-80-80L0 64C0 46.3 14.3 32 32 32zM361.4 201.4L329 169c-15.1-15.1-4.4-41 17-41L456 128c13.3 0 24 10.7 24 24l0 110.1c0 21.4-25.9 32.1-41 17l-32.4-32.4-80 80c-12.5 12.5-32.8 12.5-45.3 0l-73.4-73.4-41.4 41.4c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l64-64c12.5-12.5 32.8-12.5 45.3 0l73.4 73.4 57.4-57.4z"],
    "microscope": [512, 512, [128300], "f610", "M176 0c-26.5 0-48 21.5-48 48l0 208c0 26.5 21.5 48 48 48l64 0c26.5 0 48-21.5 48-48l0-64 32 0c70.7 0 128 57.3 128 128S390.7 448 320 448L32 448c-17.7 0-32 14.3-32 32s14.3 32 32 32l448 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-16.9 0c30.4-34 48.9-78.8 48.9-128 0-106-86-192-192-192l-32 0 0-80c0-26.5-21.5-48-48-48L176 0zM120 352c-13.3 0-24 10.7-24 24s10.7 24 24 24l176 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-176 0z"],
    "cat-space": [576, 512, [], "e001", "M400-32c97.2 0 176 78.8 176 176 0 80.6-54.1 148.4-128 169.3L448 480c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-140.8-136 108.8 56 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-144 0c-53 0-96-43-96-96l0-224c0-16.6-12.6-30.2-28.7-31.8l-6.6-.3c-16.1-1.6-28.7-15.3-28.7-31.8 0-17.7 14.3-32 32-32 53 0 96 43 96 96l0 85.8c24.6-37 61.6-64.9 105.2-77.8-5.9-17.6-9.2-36.4-9.2-56 0-97.2 78.8-176 176-176zm96 176c0 53-43 96-96 96s-96-43-96-96l0-84.6c-19.9 22.6-32 52.2-32 84.7 0 70.7 57.3 128 128 128s128-57.3 128-128c0-32.5-12.1-62.1-32-84.7l0 84.6zM368 124a20 20 0 1 0 0 40 20 20 0 1 0 0-40zm64 0a20 20 0 1 0 0 40 20 20 0 1 0 0-40zM136.5-19.7c2.6-7 12.4-7 15 0L162.2 9.1c.8 2.2 2.6 3.9 4.8 4.7l28.8 10.7c7 2.6 7 12.4 0 15L166.9 50.2c-2.2 .8-3.9 2.5-4.8 4.7L151.5 83.7c-2.6 7-12.4 7-15 0L125.8 54.9c-.8-2.2-2.6-3.9-4.8-4.7L92.3 39.5c-7-2.6-7-12.4 0-15l28.8-10.7c2.2-.8 3.9-2.5 4.8-4.7l10.7-28.8zM400 16c-26.7 0-51.6 8.2-72.1 22.2l44.7 37.2 54.9 0 44.6-37.2C451.5 24.2 426.7 16 400 16z"],
    "circle-exclamation-check": [640, 512, [], "e10d", "M320.3 0c127.6 0 233.4 93.4 252.8 215.5-10.1 5-19.1 12.4-26.2 22.2l-53.5 73.5c-27.3-16.4-63.1-13.3-87.1 9.9-28.6 27.6-29.4 73.2-1.8 101.8l46.4 48c1.1 1.1 2.3 2.2 3.5 3.2-39 24-84.9 37.9-134.1 37.9-141.4 0-256-114.6-256-256S178.9 0 320.3 0zM585.7 265.9c7.8-10.7 22.8-13.1 33.5-5.3s13.1 22.8 5.3 33.5L522.1 434.9c-4.2 5.7-10.7 9.4-17.7 9.8s-14-2.2-18.9-7.3l-46.4-48c-9.2-9.5-9-24.7 .6-33.9s24.7-8.9 33.9 .6l26.5 27.4 85.6-117.7zM320.3 320a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm0-192c-18.2 0-32.7 15.5-31.4 33.7l7.4 104c.9 12.6 11.4 22.3 23.9 22.3 12.6 0 23-9.7 23.9-22.3l7.4-104c1.3-18.2-13.1-33.7-31.4-33.7z"],
    "cards": [512, 512, [], "e3ed", "M448.2 64c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64l-192 0c-14.6 0-28-5-38.8-13.2l137.9-36.9c59.7-16 95.2-77.4 79.2-137.2L364.6 64 448.2 64zM226.9-17.2C261-26.4 296.1-6.1 305.3 28l82.8 309.1c9.1 34.1-11.1 69.2-45.3 78.4L157.4 465.2C123.3 474.4 88.2 454.1 79 420L-3.8 110.9C-12.9 76.7 7.3 41.6 41.4 32.5L226.9-17.2zm17.6 315.6l-53.8 14.4c-10.7 2.9-17 13.8-14.2 24.5s13.8 17 24.5 14.2l53.8-14.4 3.8-1.4c8.3-4.2 12.8-13.7 10.3-23.1s-11.2-15.3-20.5-14.8l-4 .6zM175.9 117.1c-6.7-3.9-15-2.4-20 3.2l-1.9 2.6c-11 19.1-29 50.2-53.9 93.3-15.4 26.8-6.3 61 20.5 76.5l0 0c25.1 14.5 56.8 7.3 73.4-15.7l.5-.7 2.2-3.4 .4-.7 5.9-10.2 10.2 5.9 .8 .4 3.6 1.8c.2 .1 .5 .2 .7 .3 25.9 11.6 56.9 2 71.4-23.1l2.5-4.8c10.3-22.6 4.4-49.2-14-65.3l-4.1-3.3-.6-.4-3.4-2.2-.7-.5-93.3-53.9z"],
    "cloud": [576, 512, [9729], "f0c2", "M0 336c0 79.5 64.5 144 144 144l304 0c70.7 0 128-57.3 128-128 0-51.6-30.5-96.1-74.5-116.3 6.7-13.1 10.5-28 10.5-43.7 0-53-43-96-96-96-17.7 0-34.2 4.8-48.4 13.1-24.1-45.8-72.2-77.1-127.6-77.1-79.5 0-144 64.5-144 144 0 8 .7 15.9 1.9 23.5-56.9 19.2-97.9 73.1-97.9 136.5z"],
    "album-circle-plus": [576, 512, [], "e48c", "M32 96c0-35.3 28.7-64 64-64l320 0c35.3 0 64 28.7 64 64l0 118c-15.3-3.9-31.4-6-48-6-7.8 0-15.4 .5-22.9 1.4-20-65.6-81-113.4-153.1-113.4-88.4 0-160 71.6-160 160 0 83.2 63.5 151.5 144.6 159.3 1.8 23 7.6 44.8 16.8 64.7L96 480c-35.3 0-64-28.7-64-64L32 96zM256 224a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm176 32a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm16 80c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 48-48 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l48 0 0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48 48 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-48 0 0-48z"],
    "baseball-bat-ball": [576, 512, [], "f432", "M464.1 544a80 80 0 1 1 0-160 80 80 0 1 1 0 160zm8.4-576c15.1 0 29.7 5.8 40.7 16.2l47.2 44.8c12.6 12 19.1 29 17.5 46.3-1.2 13.3-7 25.8-16.5 35.2L363.1 309c-7.3 7.3-15.7 13.4-25 18L206 393c-9.2 4.6-17.7 10.7-25 18l-92 92 1.7 1.8c7.7 9.4 7.1 23.3-1.7 32.1s-22.7 9.3-32.1 1.7l-1.8-1.7-48-48-1.7-1.8c-7.7-9.4-7.1-23.3 1.7-32.1s22.7-9.3 32.1-1.7l1.8 1.7 92-92c7.3-7.3 13.4-15.7 18-25l66.1-132.1c4.6-9.2 10.7-17.7 18-25L430.8-14.7C441.9-25.8 456.9-32 472.5-32z"],
    "car-rear": [512, 512, ["car-alt"], "f5de", "M165.4 96l181.2 0c13.6 0 25.7 8.6 30.2 21.4l26.1 74.6-293.8 0 26.1-74.6c4.5-12.8 16.6-21.4 30.2-21.4zm-90.6 .3L39.6 196.8C16.4 206.4 0 229.3 0 256l0 96c0 23.7 12.9 44.4 32 55.4L32 448c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-32 256 0 0 32c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-40.6c19.1-11.1 32-31.7 32-55.4l0-96c0-26.7-16.4-49.6-39.6-59.2L437.2 96.3C423.7 57.8 387.4 32 346.6 32L165.4 32c-40.8 0-77.1 25.8-90.6 64.3zM208 288l96 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM48 280c0-13.3 10.7-24 24-24l32 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-32 0c-13.3 0-24-10.7-24-24zm360-24l32 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-32 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"],
    "windsock": [512, 512, [], "f777", "M64 32C64 14.3 49.7 0 32 0S0 14.3 0 32L0 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-160 64 0 0 8.6c0 20.3 18.7 35.5 38.5 31.3l41.5-8.6 0-286.7-41.5-8.6c-19.9-4.1-38.5 11-38.5 31.3l0 8.6-64 0 0-64zm64 112l0 128-64 0 0-128 64 0zM256 74.7l0 266.7 112-23.3 0-220-112-23.3zM486.5 293.3c14.8-3.1 25.5-16.2 25.5-31.3l0-108c0-15.2-10.6-28.2-25.5-31.3l-70.5-14.7 0 200 70.5-14.7z"],
    "face-worried": [512, 512, [], "e3a3", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm-73.6-97.5c-12.4 5.2-26.5-4.1-21.1-16.4 16-36.6 52.4-62.1 94.8-62.1s78.8 25.6 94.8 62.1c5.4 12.3-8.7 21.6-21.1 16.4-22.4-9.5-47.4-14.8-73.7-14.8s-51.3 5.3-73.7 14.8zM144 272a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm192-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM192 164c-4.2 0-8.4 .3-12.5 .8-20.3 2.7-38.9 11.9-53.8 25.8-8.1 7.5-20.7 7.1-28.3-1s-7.1-20.7 1-28.3c20.6-19.3 46.8-32.4 75.9-36.2 5.8-.8 11.7-1.2 17.7-1.2 11 0 20 9 20 20s-9 20-20 20zm140.5 .8c-4.1-.5-8.3-.8-12.5-.8-11 0-20-9-20-20s9-20 20-20c6 0 11.9 .4 17.7 1.2 29.1 3.8 55.3 17 75.9 36.2 8.1 7.5 8.5 20.2 1 28.3s-20.2 8.5-28.3 1c-14.9-13.9-33.5-23.1-53.8-25.8z"],
    "microphone-circle-xmark": [576, 512, [], "e77e", "M128 96l0 128c0 53 43 96 96 96 5.6 0 11.2-.5 16.5-1.4-.4-4.8-.5-9.7-.5-14.6 0-64.2 31.5-121.1 80-156l0-52c0-53-43-96-96-96s-96 43-96 96zM250.1 365.6c-8.5 1.6-17.2 2.4-26.1 2.4-79.5 0-144-64.5-144-144l0-40c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 40c0 97.9 73.3 178.7 168 190.5l0 49.5-48 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l144 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0 0-49.5c8.1-1 16.1-2.5 23.9-4.5-9.1-13.7-16.4-28.5-21.8-44.3zM432 448a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm59.3-180.7l-36.7 36.7 36.7 36.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-36.7-36.7-36.7 36.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l36.7-36.7-36.7-36.7c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l36.7 36.7 36.7-36.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6z"],
    "message-lines": [512, 512, ["comment-alt-lines"], "f4a6", "M0 128L0 352c0 53 43 96 96 96l32 0 0 72c0 13.3 10.7 24 24 24 5.2 0 10.2-1.7 14.4-4.8l115.2-86.4c4.2-3.1 9.2-4.8 14.4-4.8l120 0c53 0 96-43 96-96l0-224c0-53-43-96-96-96L96 32C43 32 0 75 0 128zm152 48l208 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-208 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zm0 96l112 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-112 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"],
    "thumbtack-slash": [576, 512, ["thumb-tack-slash"], "e68f", "M41-24.9c-9.4-9.4-24.6-9.4-33.9 0S-2.3-.3 7 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9L417.8 352 448 352c10 0 19.5-4.7 25.5-12.7s8-18.4 5.2-28.1L475 297.8c-12.4-43.3-41-78.5-78.2-99.7L386.5 64 416 64c17.7 0 32-14.3 32-32S433.7 0 416 0L160 0c-7.4 0-14.1 2.5-19.5 6.6L190.1 56.3 185.3 119.4 41-24.9zM282.2 352L149.7 219.6c-22.7 20.5-39.8 47.4-48.7 78.3l-3.8 13.4c-2.8 9.7-.8 20 5.2 28.1S118 352 128 352l154.2 0zM256 512c0 17.7 14.3 32 32 32s32-14.3 32-32l0-112-64 0 0 112z"],
    "box-arrow-down": [448, 512, [], "e794", "M335.1 80l34.3 48-290.7 0 34.3-48 222.1 0zM11.9 111.3C4.2 122.2 0 135.2 0 148.5L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-267.5c0-13.3-4.2-26.3-11.9-37.2L387.1 42.8C375.1 26 355.7 16 335.1 16L112.9 16C92.3 16 72.9 26 60.9 42.8L11.9 111.3zM207 401l-72-72c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l31 31 0-102.1c0-13.3 10.7-24 24-24s24 10.7 24 24l0 102.1 31-31c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-72 72c-9.4 9.4-24.6 9.4-33.9 0z"],
    "plus-minus": [384, 512, [], "e43c", "M224 32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 128-128 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l128 0 0 128c0 17.7 14.3 32 32 32s32-14.3 32-32l0-128 128 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-128 0 0-128zM0 480c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 448c-17.7 0-32 14.3-32 32z"],
    "house-circle-check": [640, 512, [], "e509", "M496 544a144 144 0 1 1 0-288 144 144 0 1 1 0 288zM268.6 6.5c12.2-9.3 29.7-8.7 41.2 2l217.6 202c-10.2-1.7-20.7-2.6-31.3-2.6-78.6 0-146.1 47.2-175.8 114.8-5.1-1.8-10.5-2.8-16.2-2.8l-32 0c-26.5 0-48 21.5-48 48l0 96 91 0c6.1 17.3 14.6 33.4 25.1 48L144 512c-35.3 0-64-28.7-64-64l0-176-16 0c-13.2 0-25-8.1-29.8-20.3s-1.6-26.2 8-35.1l224-208 2.4-2zM553.4 339.1c-7.1-5.2-17.1-3.6-22.3 3.5l-53 72.8-26.7-26.8c-6.2-6.2-16.4-6.2-22.6 0-6.2 6.2-6.2 16.4 0 22.6l40 40c3.3 3.3 7.9 5 12.6 4.7s8.9-2.8 11.7-6.6l64-88c5.2-7.1 3.6-17.1-3.5-22.3z"],
    "face-woozy": [512, 512, [], "e3a2", "M0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm384-48c0-35.3-21.5-64-48-64s-48 28.7-48 64 21.5 64 48 64 48-28.7 48-64zM213.8 263.3c12.9-3.2 20.7-16.2 17.5-29.1s-16.2-20.7-29.1-17.5l-64 16c-12.9 3.2-20.7 16.2-17.5 29.1s16.2 20.7 29.1 17.5l64-16zM228 98.7c-7.4-11-22.3-14-33.3-6.7l-96 64c-11 7.4-14 22.3-6.7 33.3s22.3 14 33.3 6.7l96-64c11-7.4 14-22.3 6.7-33.3zM387.8 365.6c7.5-10.9 4.7-25.9-6.2-33.4s-25.9-4.7-33.4 6.2l-22.1 32.3c-2.3 3.3-6 5.3-10 5.3-2.6 0-5.2-.9-7.3-2.4l-27.9-21c-23.5-17.6-54.9-20.4-81.1-7.3-11.3 5.7-25 3.4-34-5.5L161 335c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l4.8 4.8c23.6 23.6 59.6 29.4 89.4 14.5 10-5 21.9-3.9 30.8 2.8L280 412c10.4 7.8 23.1 12 36.1 12 19.8 0 38.4-9.8 49.6-26.2l22.1-32.3z"],
    "crate-apple": [512, 512, ["apple-crate"], "f6b1", "M160 54.9c0-30.3 24.6-54.9 54.9-54.9 5 0 9.1 4.1 9.1 9.1 0 30.3-24.6 54.9-54.9 54.9-5 0-9.1-4.1-9.1-9.1zM32 171.4c0-43.6 20.4-91.4 64-91.4 15.6 0 34.1 5.9 47.2 11 10.7 4.2 22.8 4.2 33.5 0 13.1-5.1 31.6-11 47.2-11 43.6 0 64 47.8 64 91.4 0 7-.4 13.9-1.2 20.6L33.2 192c-.8-6.7-1.2-13.5-1.2-20.6zM319 192c.7-6.7 1-13.6 1-20.6 0-26.1-6-55.1-20.3-78.6-2.7-4.4-5.7-8.7-9-12.7 15 .6 32.2 6.1 44.6 11 10.7 4.2 22.8 4.2 33.5 0 13.1-5.1 31.6-11 47.2-11 43.6 0 64 47.8 64 91.4 0 7-.4 13.9-1.2 20.6L319 192zM406.9 0c5 0 9.1 4.1 9.1 9.1 0 30.3-24.6 54.9-54.9 54.9-5 0-9.1-4.1-9.1-9.1 0-30.3 24.6-54.9 54.9-54.9zM0 272c0-26.5 21.5-48 48-48l416 0c26.5 0 48 21.5 48 48l0 80-512 0 0-80zM0 384l512 0 0 80c0 26.5-21.5 48-48 48L48 512c-26.5 0-48-21.5-48-48l0-80zm80-96a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM64 464a16 16 0 1 0 0-32 16 16 0 1 0 0 32zM464 288a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM448 464a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"],
    "calendar-day": [448, 512, [], "f783", "M128 0c17.7 0 32 14.3 32 32l0 32 128 0 0-32c0-17.7 14.3-32 32-32s32 14.3 32 32l0 32 32 0c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 128C0 92.7 28.7 64 64 64l32 0 0-32c0-17.7 14.3-32 32-32zm0 256c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-64 0z"],
    "circle": [512, 512, [128308, 128309, 128992, 128993, 128994, 128995, 128996, 9679, 9898, 9899, 11044, 61708, 61915], "f111", "M0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0z"],
    "notebook": [512, 512, [], "e201", "M64 64l0 40-40 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l40 0 0 80-40 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l40 0 0 80-40 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l40 0 0 40c0 35.3 28.7 64 64 64l48 0 0-512-48 0C92.7 0 64 28.7 64 64zM416 0l-192 0 0 512 192 0c35.3 0 64-28.7 64-64l0-384c0-35.3-28.7-64-64-64z"],
    "octagon-xmark": [512, 512, ["times-octagon", "xmark-octagon"], "f2f0", "M143.4 18.8c12-12 28.3-18.7 45.3-18.7l135.6 0c17 0 33.3 6.7 45.3 18.7L493.6 143c12 12 18.7 28.3 18.7 45.3l0 135.6c0 17-6.7 33.3-18.7 45.3L369.5 493.2c-12 12-28.3 18.7-45.3 18.7l-135.6 0c-17 0-33.3-6.7-45.3-18.7L19.2 369C7.2 357 .5 340.8 .5 323.8l0-135.6c0-17 6.7-33.3 18.7-45.3L143.4 18.8zM167.5 167c-9.4 9.4-9.4 24.6 0 33.9l55 55-55 55c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l55-55 55 55c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-55-55 55-55c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-55 55-55-55c-9.4-9.4-24.6-9.4-33.9 0z"],
    "racquet": [576, 512, [], "f45a", "M397-16c42.8 0 84.9 14.8 116.6 46.5S560 104.2 560 147c0 54.2-23.4 110.5-66.9 154-54.4 54.4-131.9 78.6-198.2 61.7-29.4-7.5-62.9-5.5-84.3 16L172.2 417c5.9 11.2 4.8 25.1-3.4 35.2l-2.2 2.4-64 64c-11.7 11.7-30.2 12.4-42.8 2.2l-2.4-2.2-32-32c-12.5-12.5-12.5-32.8 0-45.2l64-64 2.4-2.2c10.1-8.2 24-9.4 35.2-3.5l38.5-38.5c21.4-21.4 23.6-54.7 16-84-3.7-14.4-5.5-29.3-5.5-44.3 0-54.2 23.4-110.5 66.9-154S342.8-16 397-16zm0 64c-36 0-76.4 15.8-108.8 48.2S240 168.9 240 205c0 28.2 9.6 53.2 27.7 71.3 40.4 40.4 120.7 39 180.1-20.5 32.4-32.4 48.2-72.8 48.2-108.8 0-28.2-9.6-53.2-27.7-71.3S425.1 48 397 48z"],
    "mobile-vibrate": [576, 512, [], "e816", "M384 0c35.3 0 64 28.7 64 64l0 384c0 35.3-28.7 64-64 64l-192 0c-35.3 0-64-28.7-64-64l0-384c0-35.3 28.7-64 64-64L384 0zM248 416c-13.3 0-24 10.7-24 24s10.7 24 24 24l80 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0zM48.8 133.4c9.4-7.7 23.3-7.1 32.1 1.7 9.4 9.4 9.4 24.6 0 33.9l-31 31 25.4 25.4 2.9 3.2c6.3 7.7 9.8 17.4 9.8 27.4 0 11.5-4.6 22.5-12.7 30.6l-25.4 25.4 31 31 1.7 1.8c7.7 9.4 7.1 23.3-1.7 32.1s-22.7 9.3-32.1 1.7L47 377 12.7 342.6C5.6 335.5 1.2 326.2 .2 316.3L0 312 .2 307.7c1-9.9 5.4-19.2 12.5-26.3L38.1 256 12.7 230.6C5.6 223.5 1.2 214.2 .2 204.3L0 200 .2 195.7c1-9.9 5.4-19.2 12.5-26.3L47 135 48.8 133.4zM495 135c8.8-8.8 22.7-9.3 32.1-1.7l1.8 1.7 34.3 34.3c7.1 7.1 11.5 16.4 12.5 26.3l.2 4.3-.2 4.3c-1 9.9-5.4 19.2-12.5 26.3l-25.4 25.4 25.4 25.4c7.1 7.1 11.5 16.4 12.5 26.3l.2 4.3-.2 4.3c-1 9.9-5.4 19.2-12.5 26.3l-34.3 34.3-1.8 1.7c-9.4 7.7-23.3 7.1-32.1-1.7s-9.3-22.7-1.7-32.1l1.7-1.8 31-31-25.4-25.4c-8.1-8.1-12.7-19.1-12.7-30.6 0-10 3.5-19.7 9.8-27.4l2.9-3.2 25.4-25.4-31-31c-9.4-9.4-9.4-24.6 0-33.9z"],
    "face-grin-squint": [512, 512, [128518, "grin-squint"], "f585", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM386.7 308.9c11.9-3.7 23.9 6.3 19.6 18.1-22.4 61.3-81.3 105.1-150.3 105.1S128.1 388.2 105.7 326.9c-4.3-11.8 7.7-21.8 19.6-18.1 39.2 12.2 83.7 19.1 130.7 19.1s91.5-6.9 130.7-19.1zM122.6 143.2c4.5-6.8 13.3-9.2 20.6-5.5l79.6 40c5.4 2.7 8.8 8.2 8.8 14.3s-3.4 11.6-8.8 14.3l-79.6 40c-7.3 3.6-16.1 1.3-20.6-5.5s-3.1-15.9 3.1-21.1L159 192 125.8 164.3c-6.2-5.2-7.6-14.3-3.1-21.1zm263.6 21.1L353 192 386.2 219.7c6.2 5.2 7.6 14.3 3.1 21.1s-13.3 9.2-20.6 5.5l-79.6-40c-5.4-2.7-8.8-8.2-8.8-14.3s3.4-11.6 8.8-14.3l79.6-40c7.3-3.6 16.1-1.3 20.6 5.5s3.1 15.9-3.1 21.1z"],
    "tree-deciduous": [512, 512, [127795, "tree-alt"], "f400", "M256 0c44.3 0 81.5 30 92.5 70.8 11-4.4 22.9-6.8 35.5-6.8 53 0 96 43 96 96 0 19.3-5.8 37.3-15.6 52.4 28.8 20.3 47.6 53.7 47.6 91.6 0 61.9-50.1 112-112 112l-112 0 0 96c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-96-112 0c-61.9 0-112-50.1-112-112 0-37.9 18.8-71.4 47.6-91.6-9.8-15.1-15.6-33-15.6-52.4 0-53 43-96 96-96 12.5 0 24.5 2.4 35.4 6.8 11.1-40.8 48.3-70.8 92.6-70.8z"],
    "users-between-lines": [576, 512, [], "e591", "M24 16l528 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 64C10.7 64 0 53.3 0 40S10.7 16 24 16zm0 448l528 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 512c-13.3 0-24-10.7-24-24s10.7-24 24-24zM392 192a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm27.2 100.4c9.1-2.9 18.8-4.4 28.8-4.4 53 0 96 43 96 96l0 10.7c0 11.8-9.6 21.3-21.3 21.3l-78.8 0c2.7-7.5 4.1-15.6 4.1-24l0-8c0-34.1-10.6-65.7-28.8-91.6zm-262.4 0C138.6 318.3 128 349.9 128 384l0 8c0 8.4 1.4 16.5 4.1 24l-78.8 0C41.6 416 32 406.4 32 394.7L32 384c0-53 43-96 96-96 10 0 19.7 1.5 28.8 4.4zM72 192a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm152-16a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zM176 384c0-61.9 50.1-112 112-112s112 50.1 112 112l0 8c0 13.3-10.7 24-24 24l-176 0c-13.3 0-24-10.7-24-24l0-8z"],
    "mango": [512, 512, [], "e30f", "M288 64l0-16c0-44.2 35.8-80 80-80l96 0c8.8 0 16 7.2 16 16l0 16c0 44.2-35.8 80-80 80l-64 0 0 18.5c99.5 15.6 176 101.6 176 205.5 0 114.9-93.1 208-208 208L98.3 512C44 512 0 468 0 413.7 0 394.4 5.7 375.4 16.5 359.2L130.3 188.6c35.7-53.5 94.1-87.3 157.7-92L288 64zM432 296c0-13.3-10.7-24-24-24s-24 10.7-24 24c0 48.6-39.4 88-88 88-13.3 0-24 10.7-24 24s10.7 24 24 24c75.1 0 136-60.9 136-136z"],
    "crosshairs-simple": [512, 512, [], "e59f", "M445.3 224L384 224c-17.7 0-32 14.3-32 32s14.3 32 32 32l61.3 0C431.9 368.4 368.4 431.9 288 445.3l0-61.3c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 61.3C143.6 431.9 80.1 368.4 66.7 288l61.3 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-61.3 0C80.1 143.6 143.6 80.1 224 66.7l0 61.3c0 17.7 14.3 32 32 32s32-14.3 32-32l0-61.3C368.4 80.1 431.9 143.6 445.3 224zM0 256a256 256 0 1 0 512 0 256 256 0 1 0 -512 0z"],
    "pipe-smoking": [640, 512, [], "e3c4", "M0 256l0 90.4c0 91.5 74.1 165.6 165.6 165.6 56.3 0 108.8-28.6 139.3-76l136.3-212-117.9 0-67.2 96 0-64c0-17.7-14.3-32-32-32L32 224c-17.7 0-32 14.3-32 32zm356.8-80l115.2 0 72-112 64 0c17.7 0 32-14.3 32-32S625.7 0 608 0L513.3 0c-20.9 0-40.5 10.2-52.4 27.3L356.8 176z"],
    "coconut": [512, 512, [], "e2f6", "M141.2 141.2c-43.7 43.7-73 91.8-85.8 133.3-13.2 42.7-7.4 71.9 7.5 86.7s44 20.6 86.7 7.5c41.5-12.8 89.6-42.1 133.3-85.8s73-91.8 85.8-133.3c13.2-42.7 7.4-71.9-7.5-86.7s-44-20.6-86.7-7.5C233 68.1 184.9 97.5 141.2 141.2zM260.4 9.5C309.6-5.7 361.6-4.8 395.2 28.8l40.9 40.9c48.6 48.6 75.9 114.5 75.9 183.2 0 143.1-116 259-259 259-68.7 0-134.6-27.3-183.2-75.9l-41-41c-33.6-33.7-34.6-85.6-19.4-134.8 15.6-50.4 49.7-105 97.8-153.1S210 25 260.4 9.5zm63.5 88.2c25 25-5.4 95.9-67.9 158.4S122.6 348.9 97.6 323.9 103 228 165.5 165.5 298.9 72.6 323.9 97.6zm95.4 107.1c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l32 32c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-32-32zm-56 136c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l32 32c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-32-32zm-136 56c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l32 32c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-32-32z"],
    "face-diagonal-mouth": [512, 512, [129764], "e47e", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM358.1 335.2l-184 48c-12.8 3.3-25.9-4.3-29.3-17.2s4.3-25.9 17.2-29.3l184-48c12.8-3.3 25.9 4.3 29.3 17.2s-4.3 25.9-17.2 29.3zM144 208a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm192-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "star-sharp-half": [512, 512, [], "e28c", "M271.9 49.6c0-11.8-8.6-21.9-20.3-23.7S228.6 31 225 42.3L182.5 176 24 176c-10.3 0-19.4 6.5-22.7 16.2s-.1 20.4 8 26.7L140.1 320.7 89.1 480.7c-3.2 10 .5 21 9.1 27s20.2 5.7 28.5-.7L262.6 401.3c5.8-4.5 9.3-11.5 9.3-18.9l0-332.8z"],
    "message-waveform": [640, 512, [], "e6e0", "M64 352l0-224c0-53 43-96 96-96l320 0c53 0 96 43 96 96l0 156.1c-11.4-7.7-25.2-12.1-40-12.1-6.4 0-12.6 .8-18.6 2.4-12.7-20.6-35.4-34.4-61.4-34.4-31.7 0-58.6 20.5-68.2 49-3.8-.6-7.8-1-11.8-1-39.8 0-72 32.2-72 72l0 112c0 3.9 .3 7.6 .9 11.3l-74.5 55.9c-4.2 3.1-9.2 4.8-14.4 4.8-13.3 0-24-10.7-24-24l0-72-32 0c-53 0-96-43-96-96zm416-40l0 208c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-208c0-13.3 10.7-24 24-24s24 10.7 24 24zm80 32l0 144c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-144c0-13.3 10.7-24 24-24s24 10.7 24 24zM400 360l0 112c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-112c0-13.3 10.7-24 24-24s24 10.7 24 24zm240 32l0 48c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-48c0-13.3 10.7-24 24-24s24 10.7 24 24z"],
    "music-magnifying-glass": [640, 512, [], "e662", "M448 208c0 62.7-40.1 116-96 135.8l0 66.6c27.4-6.5 52.7-18.4 74.7-34.5L553.4 502.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L472 330.7C497.1 296.3 512 253.9 512 208 512 93.1 418.9 0 304 0 197.3 0 109.3 80.4 97.4 183.9l67.2-12.2C180.7 109.7 237 64 304 64 383.5 64 448 128.5 448 208zM304 224c0-7.1-3.2-13.9-8.6-18.4s-12.7-6.5-19.7-5.2l-176 32C88.3 234.5 80 244.4 80 256l0 161.6c-5.9-1.1-11.4-1.6-16-1.6-9.5 0-22.9 2.1-34.9 7.5-11.1 5-29.1 17.2-29.1 40.5s18 35.4 29.1 40.5C41.1 509.9 54.5 512 64 512s22.9-2.1 34.9-7.5c11.1-5 29.1-17.2 29.1-40.5l0-139.9 128-23.3 0 84.9c-5.9-1.1-11.4-1.6-16-1.6-9.5 0-22.9 2.1-34.9 7.5-11.1 5-29.1 17.2-29.1 40.5s18 35.4 29.1 40.5c11.9 5.4 25.4 7.5 34.9 7.5s22.9-2.1 34.9-7.5c11.1-5 29.1-17.2 29.1-40.5l0-208z"],
    "house-medical-circle-xmark": [640, 512, [], "e513", "M309.8 8.6c-12.3-11.4-31.3-11.4-43.5 0l-224 208c-9.6 9-12.8 22.9-8 35.1S50.8 272 64 272l16 0 0 176c0 35.3 28.7 64 64 64l196 0c-21.2-29.5-34.3-65.3-35.9-104L272 408c-8.8 0-16-7.2-16-16l0-40-40 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l40 0 0-40c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 40 20 0c34.9-48.5 91.7-80 156-80 10.7 0 21.1 .9 31.3 2.5L309.8 8.6zM496 544a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm22.6-144l36.7 36.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-36.7-36.7-36.7 36.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l36.7-36.7-36.7-36.7c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l36.7 36.7 36.7-36.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6L518.6 400z"],
    "club": [512, 512, [9827], "f327", "M380 160.1c2.6-10.2 4-21 4-32.1 0-70.7-57.3-128-128-128S128 57.3 128 128c0 11.1 1.4 21.8 4 32.1-1.3 0-2.7-.1-4-.1-70.7 0-128 57.3-128 128S57.3 416 128 416c38.2 0 72.5-16.8 96-43.3l0 75.3-32 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l128 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0 0-75.3c23.5 26.6 57.8 43.3 96 43.3 70.7 0 128-57.3 128-128S454.7 160 384 160c-1.4 0-2.7 0-4 .1z"],
    "fire-smoke": [512, 512, [], "f74b", "M294 34.5L281.7 48.3S257.2 18.9 242.8 7.5C237.4 3.2 231.3 .2 224 0s-14.6 2.3-20.3 7.5c-23.4 21.1-50 48.9-70.9 80.2-20.8 31.1-36.8 67.1-36.8 104.5 0 16.8 2.5 32.9 7.2 48.1 2.9-.2 5.8-.2 8.8-.2 12.7 0 25.1 1.5 36.9 4.3 14.1-10.8 30-19.6 47-25.8 10-28.6 36.6-54.5 50.8-66.8 5.4-4.7 13.1-4.7 18.5 0 14.2 12.3 40.8 38.2 50.8 66.8 17.1 6.2 32.9 14.9 47 25.8 11.9-2.8 24.3-4.3 36.9-4.3 2.9 0 5.8 .1 8.7 .2 4.7-15.2 7.3-31.3 7.3-48.1 0-30-11-60.9-26.2-88.1-15.2-27.4-35.3-52.3-55-70.6-5.6-5.2-12.8-7.8-19.9-7.8-7.6 0-15.5 2.8-20.9 8.9zM0 400c0 61.9 50.1 112 112 112l288 0c61.9 0 112-50.1 112-112S461.9 288 400 288c-17.3 0-33.7 3.9-48.3 10.9-23.4-26.3-57.6-42.9-95.7-42.9s-72.2 16.6-95.7 42.9c-14.6-7-31-10.9-48.3-10.9-61.9 0-112 50.1-112 112z"],
    "table-list": [448, 512, ["th-list"], "f00b", "M0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm64 0l0 64 64 0 0-64-64 0zm320 0l-192 0 0 64 192 0 0-64zM64 224l0 64 64 0 0-64-64 0zm320 0l-192 0 0 64 192 0 0-64zM64 352l0 64 64 0 0-64-64 0zm320 0l-192 0 0 64 192 0 0-64z"],
    "flask-vial": [640, 512, [], "e4f3", "M184.6 411.5c-3.1 7.3-5.4 14.9-6.8 22.6-14.5 8.8-31.5 13.9-49.8 13.9-53 0-96-43-96-96L32 64C14.3 64 0 49.7 0 32S14.3 0 32 0L224 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l0 255.6-39.4 91.9zM96 64l0 128 64 0 0-128-64 0zM352 0L512 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l0 153.4 91.3 213c2.3 5.4 3.8 11.1 4.4 17l.3 .6-.3 0c.2 1.8 .3 3.6 .3 5.4 0 32.3-26.2 58.6-58.6 58.6l-266.9 0c-32.3 0-58.6-26.2-58.6-58.6 0-1.8 .1-3.6 .3-5.4l-.3 0 .3-.6c.6-5.8 2.1-11.6 4.4-17L320 217.4 320 64c-17.7 0-32-14.3-32-32S302.3 0 320 0l32 0zM453.2 242.6c-3.4-8-5.2-16.5-5.2-25.2l0-153.4-64 0 0 153.4c0 8.7-1.8 17.2-5.2 25.2l-33.2 77.4 140.7 0-33.2-77.4z"],
    "luchador-mask": [448, 512, ["luchador", "mask-luchador"], "f455", "M224-16C109.1-16 16 77.1 16 192l0 144c0 106 86 192 192 192l32 0c106 0 192-86 192-192l0-144C432 77.1 338.9-16 224-16zM210.4 176.2L224 200 237.6 176.2C249 156.3 270.2 144 293.1 144l58.9 0c17.7 0 32 14.3 32 32l0 32c0 44.2-35.8 80-80 80l-40 0 16 32 8 0c35.3 0 64 28.7 64 64s-28.7 64-64 64l-128 0c-35.3 0-64-28.7-64-64s28.7-64 64-64l8 0 16-32-40 0c-44.2 0-80-35.8-80-80l0-32c0-17.7 14.3-32 32-32l58.9 0c23 0 44.2 12.3 55.6 32.2zM177.8 248c7.9 0 14.2-6.4 14.2-14.2 0-27.5-22.3-49.8-49.8-49.8l-24 0c-7.9 0-14.2 6.4-14.2 14.2 0 27.5 22.3 49.8 49.8 49.8l24 0zm116.4 0c27.5 0 49.8-22.3 49.8-49.8 0-7.9-6.4-14.2-14.2-14.2l-24 0c-27.5 0-49.8 22.3-49.8 49.8 0 7.9 6.4 14.2 14.2 14.2l24 0zM136 384c0 13.3 10.7 24 24 24l128 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-128 0c-13.3 0-24 10.7-24 24z"],
    "circle-exclamation": [512, 512, ["exclamation-circle"], "f06a", "M256 512a256 256 0 1 1 0-512 256 256 0 1 1 0 512zm0-192a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm0-192c-18.2 0-32.7 15.5-31.4 33.7l7.4 104c.9 12.6 11.4 22.3 23.9 22.3 12.6 0 23-9.7 23.9-22.3l7.4-104c1.3-18.2-13.1-33.7-31.4-33.7z"],
    "block-brick": [448, 512, ["wall-brick"], "e3db", "M128 32l0 80 192 0 0-80-192 0zM96 112l0-80-32 0C28.7 32 0 60.7 0 96l0 16 96 0zM0 144l0 96 208 0 0-96-208 0zM0 368l96 0 0-96-96 0 0 96zm0 32l0 16c0 35.3 28.7 64 64 64l144 0 0-80-208 0zm240 0l0 80 144 0c35.3 0 64-28.7 64-64l0-16-208 0zm208-32l0-96-96 0 0 96 96 0zm-128 0l0-96-192 0 0 96 192 0zM448 144l-208 0 0 96 208 0 0-96zm0-32l0-16c0-35.3-28.7-64-64-64l-32 0 0 80 96 0z"],
    "arrow-u-turn-right-up": [576, 512, [], "e7ec", "M396.3 7.2c12.6-10.3 31.1-9.5 42.8 2.2l112 112c12.5 12.5 12.5 32.8 0 45.2s-32.8 12.5-45.2 0l-57.4-57.4 0 210.8c0 102.7-80.7 186.6-182.1 191.8l-9.9 .2c-106 0-192-86-192-192l0-224 .2-3.3C66.3 76.6 79.9 64 96.5 64s30.2 12.6 31.8 28.7l.2 3.3 0 224c0 70.7 57.3 128 128 128l6.6-.2c67.6-3.4 121.4-59.4 121.4-127.8l0-210.8-57.4 57.4-2.4 2.2c-12.6 10.2-31.1 9.5-42.8-2.2s-12.4-30.2-2.2-42.8l2.2-2.4 112-112 2.4-2.2z"],
    "taxi": [512, 512, [128662, "cab"], "f1ba", "M192 0c-17.7 0-32 14.3-32 32l0 32-8.9 0c-42 0-79.1 27.3-91.6 67.4l-23 73.5C14.5 219.1 0 243.9 0 272L0 448c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-32 320 0 0 32c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-176c0-28.1-14.5-52.9-36.4-67.1l-23-73.5C440.1 91.3 402.9 64 360.9 64l-8.9 0 0-32c0-17.7-14.3-32-32-32L192 0zM151.1 128l209.9 0c14 0 26.4 9.1 30.5 22.5l13 41.5-296.9 0 13-41.5c4.2-13.4 16.5-22.5 30.5-22.5zM96 272a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm288 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"],
    "text-slash": [576, 512, ["remove-format"], "f87d", "M41-24.9c-9.4-9.4-24.6-9.4-33.9 0S-2.3-.3 7 9.1l528 528c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9L322.7 256.9 368.2 96 471 96 465 120.2c-4.3 17.1 6.1 34.5 23.3 38.8s34.5-6.1 38.8-23.3l11-44.1C545.6 61.3 522.7 32 491.5 32l-319 0c-19.8 0-37.3 12.1-44.5 30.1l-87-87zM180.4 114.5l4.6-18.5 116.7 0-30.8 109-90.5-90.5zM241 310.8L211.3 416 160 416c-17.7 0-32 14.3-32 32s14.3 32 32 32l160 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-42.2 0 15.1-53.3-51.9-51.9z"],
    "people-pulling": [576, 512, [], "e535", "M80 96a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM64 128c-35.3 0-64 28.7-64 64L0 320c0 17.7 14.3 32 32 32 9.8 0 18.5-4.4 24.4-11.2L80.4 485.3c2.9 17.4 19.4 29.2 36.8 26.3s29.2-19.4 26.3-36.8l-20.5-122.7 15.7 0 30 134.9c3.8 17.3 20.9 28.1 38.2 24.3s28.1-20.9 24.3-38.2l-57.3-258 116.3 53.8c.5 .3 1.1 .5 1.6 .7 8.6 3.6 18 3.1 25.9-.7 3.4-1.6 6.6-3.9 9.3-6.7 3.1-3.2 5.5-7 7.1-11.4 .1-.3 .2-.7 .3-1l2.5-7.5c5.7-17.1 18.3-30.9 34.7-38.2l8-3.5c1-.4 1.9-.8 2.9-1.2l-16.9 63.5c-5.6 21.1-.1 43.6 14.7 59.7l70.7 77.1 22 88.1c4.3 17.1 21.7 27.6 38.8 23.3s27.6-21.7 23.3-38.8l-23-92.1c-1.9-7.8-5.8-14.9-11.2-20.8l-49.5-54 19.3-65.5 9.6 23c4.4 10.6 12.5 19.3 22.8 24.5l26.7 13.3c15.8 7.9 35 1.5 42.9-14.3s1.5-35-14.3-42.9l-21.4-10.7-15.3-36.8c-17.1-41.1-57.3-67.9-101.9-67.9-22.8 0-45.3 4.8-66.1 14l-8 3.5c-24.4 10.9-44.6 29-58.1 51.6L157.3 136.9C144.7 131 130.9 128 117 128l-53 0zM464 96a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM349.7 335.6l-25 62.4-59.4 59.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L372.3 441c4.6-4.6 8.2-10.1 10.6-16.1l14.5-36.2-40.7-44.4c-2.5-2.7-4.8-5.6-7-8.6z"],
    "backward": [576, 512, [9194], "f04a", "M204.3 43.1C215.9 32 233 28.9 247.7 35.2S272 56 272 72l0 136.3 172.3-165.1C455.9 32 473 28.9 487.7 35.2S512 56 512 72l0 368c0 16-9.6 30.5-24.3 36.8s-31.8 3.2-43.4-7.9L272 303.7 272 440c0 16-9.6 30.5-24.3 36.8s-31.8 3.2-43.4-7.9l-192-184C4.5 277.3 0 266.9 0 256s4.5-21.3 12.3-28.9l192-184z"],
    "spade": [512, 512, [9824], "f2f4", "M220.6 14.9C230.1 5.3 243 0 256.5 0s26.4 5.3 35.9 14.9L475 197.5c50 50 50 131 0 181s-131 50-181 0l-5.5-5.5 0 75 32 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-128 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l32 0 0-75-5.5 5.5c-50 50-131 50-181 0s-50-131 0-181L220.6 14.9z"],
    "dreidel": [512, 512, [], "f792", "M503.1 9.4c12.5 12.5 12.5 32.8 0 45.3l-136 136 63.4 63.4c18.7 18.7 18.7 49.1 0 67.9l-37.1 37.1-240-240 37.1-37.1c18.7-18.7 49.1-18.7 67.9 0l63.4 63.4 136-136c12.5-12.5 32.8-12.5 45.3 0zM119.5 153l240 240-73 73c-9 9-21.2 14.1-33.9 14.1L80.5 480c-26.5 0-48-21.5-48-48l0-172.1c0-12.7 5.1-24.9 14.1-33.9l73-73z"],
    "car-burst": [640, 512, ["car-crash"], "f5e1", "M232 16.1l0-48c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 48c0 13.3 10.7 24 24 24s24-10.7 24-24zM32 168.1l48 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0c-13.3 0-24 10.7-24 24s10.7 24 24 24zM281.5 70.6c9.4 9.4 24.6 9.4 33.9 0l33.9-33.9c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0L281.5 36.6c-9.4 9.4-9.4 24.6 0 33.9zm-181 215l33.9-33.9c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0L66.6 251.6c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0zM66.6 2.7c-9.4 9.4-9.4 24.6 0 33.9l33.9 33.9c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9L100.5 2.7C91.1-6.7 76-6.7 66.6 2.7zM352.9 175.4L505 216.2c6.4 1.7 11.1 7.3 11.8 13.9l7.2 74-231.5-62 43.2-60.5c3.9-5.4 10.7-7.9 17.2-6.2zM223.6 228.5l-2.1 2.9c-21.7 5.5-39.9 22.3-46.1 45.5-4.1 15.5-12.4 46.4-24.8 92.7l-8.3 30.9c-4.6 17.1 5.6 34.6 22.6 39.2l15.5 4.1c17.1 4.6 34.6-5.6 39.2-22.6l8.3-30.9 278.2 74.5-8.3 30.9c-4.6 17.1 5.6 34.6 22.6 39.2l15.5 4.1c17.1 4.6 34.6-5.6 39.2-22.6 4.1-15.5 12.4-46.4 24.8-92.7l8.3-30.9c6.2-23.2-1.1-46.8-17.2-62.5l-.3-3.6-10-103c-3.2-33.2-26.7-60.9-58.9-69.5L369.5 113.6c-32.2-8.6-66.4 3.6-85.8 30.8l-60.2 84.2zm48.7 57.8a32 32 0 1 1 -16.6 61.8 32 32 0 1 1 16.6-61.8zm208.1 88.9a32 32 0 1 1 61.8 16.6 32 32 0 1 1 -61.8-16.6z"],
    "comment-minus": [512, 512, [], "f4b1", "M256 480c141.4 0 256-107.5 256-240S397.4 0 256 0 0 107.5 0 240c0 54.3 19.2 104.3 51.6 144.5L2.8 476.8c-4.8 9-3.3 20 3.6 27.5s17.8 9.8 27.1 5.8l118.4-50.7C183.7 472.6 218.9 480 256 480zM184 216l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"],
    "square-f": [448, 512, [], "e270", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM168 144l112 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-88 0 0 48 72 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-72 0 0 56c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-176c0-13.3 10.7-24 24-24z"],
    "chess-queen-piece": [320, 512, ["chess-queen-alt"], "f446", "M187-5c0 14.9-12.1 27-27 27s-27-12.1-27-27 12.1-27 27-27 27 12.1 27 27zm61 205c13.3 0 24 10.7 24 24s-10.7 24-24 24l-5.6 0 13.6 136 56.2 70.3c5 6.3 7.8 14.1 7.8 22.2 0 19.6-15.9 35.5-35.5 35.5L35.5 512c-19.6 0-35.5-15.9-35.5-35.5 0-8.1 2.7-15.9 7.8-22.2L64 384 77.6 248 72 248c-13.3 0-24-10.7-24-24s10.7-24 24-24l.7 0-69.1-114C1.3 82.1 0 77.6 0 73 0 59.2 11.2 48 25 48l.9 0c4 0 8 .9 11.6 2.7L64 64 97.8 37c4-3.2 9.1-5 14.2-5s10.2 1.8 14.2 5L160 64 193.8 37c4-3.2 9.1-5 14.2-5s10.2 1.8 14.2 5L256 64 282.5 50.7c3.6-1.8 7.6-2.7 11.6-2.7l.9 0c13.8 0 25 11.2 25 25 0 4.6-1.3 9.1-3.6 13l-69.1 114 .7 0z"],
    "turn-left-down": [384, 512, [], "e637", "M214.6 502.6c-12.5 12.5-32.8 12.5-45.3 0l-128-128c-9.2-9.2-11.9-22.9-6.9-34.9S51.1 320 64 320l64 0 0-160C128 71.6 199.6 0 288 0l64 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32 14.3-32 32l0 160 64 0c12.9 0 24.6 7.8 29.6 19.8s2.2 25.7-6.9 34.9l-128 128z"],
    "link": [576, 512, [128279, "chain"], "f0c1", "M419.5 96c-16.6 0-32.7 4.5-46.8 12.7-15.8-16-34.2-29.4-54.5-39.5 28.2-24 64.1-37.2 101.3-37.2 86.4 0 156.5 70 156.5 156.5 0 41.5-16.5 81.3-45.8 110.6l-71.1 71.1c-29.3 29.3-69.1 45.8-110.6 45.8-86.4 0-156.5-70-156.5-156.5 0-1.5 0-3 .1-4.5 .5-17.7 15.2-31.6 32.9-31.1s31.6 15.2 31.1 32.9c0 .9 0 1.8 0 2.6 0 51.1 41.4 92.5 92.5 92.5 24.5 0 48-9.7 65.4-27.1l71.1-71.1c17.3-17.3 27.1-40.9 27.1-65.4 0-51.1-41.4-92.5-92.5-92.5zM275.2 173.3c-1.9-.8-3.8-1.9-5.5-3.1-12.6-6.5-27-10.2-42.1-10.2-24.5 0-48 9.7-65.4 27.1L91.1 258.2c-17.3 17.3-27.1 40.9-27.1 65.4 0 51.1 41.4 92.5 92.5 92.5 16.5 0 32.6-4.4 46.7-12.6 15.8 16 34.2 29.4 54.6 39.5-28.2 23.9-64 37.2-101.3 37.2-86.4 0-156.5-70-156.5-156.5 0-41.5 16.5-81.3 45.8-110.6l71.1-71.1c29.3-29.3 69.1-45.8 110.6-45.8 86.6 0 156.5 70.6 156.5 156.9 0 1.3 0 2.6 0 3.9-.4 17.7-15.1 31.6-32.8 31.2s-31.6-15.1-31.2-32.8c0-.8 0-1.5 0-2.3 0-33.7-18-63.3-44.8-79.6z"],
    "chart-line-down": [512, 512, [128201], "f64d", "M32 32c17.7 0 32 14.3 32 32l0 336c0 8.8 7.2 16 16 16l400 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L80 480c-44.2 0-80-35.8-80-80L0 64C0 46.3 14.3 32 32 32zM361.4 246.6l-57.4-57.4-73.4 73.4c-12.5 12.5-32.8 12.5-45.3 0l-64-64c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0l41.4 41.4 73.4-73.4c12.5-12.5 32.8-12.5 45.3 0l80 80 32.4-32.4c15.1-15.1 41-4.4 41 17L480 296c0 13.3-10.7 24-24 24l-110.1 0c-21.4 0-32.1-25.9-17-41l32.4-32.4z"],
    "backward-step": [384, 512, ["step-backward"], "f048", "M363 36.8c-12.9-7-28.7-6.3-41 1.8L64 208.1 64 64c0-17.7-14.3-32-32-32S0 46.3 0 64L0 448c0 17.7 14.3 32 32 32s32-14.3 32-32l0-144.1 258 169.6c12.3 8.1 28 8.8 41 1.8s21-20.5 21-35.2l0-368c0-14.7-8.1-28.2-21-35.2z"],
    "clock-one": [512, 512, [], "e34e", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm24-392l0 56.7 20-30c7.4-11 22.3-14 33.3-6.7s14 22.3 6.7 33.3l-64 96c-5.9 8.8-16.8 12.7-26.9 9.7s-17-12.4-17-23l0-136c0-13.3 10.7-24 24-24s24 10.7 24 24z"],
    "dice-d4": [576, 512, [], "f6d0", "M251.1 13.4c19.2-23.5 55.1-23.5 74.3 0L545 281.9c17.1 20.9 13.6 51.8-7.7 68.3L317.7 521.1c-17.3 13.5-41.6 13.5-58.9 0L39 350.2c-21.3-16.6-24.8-47.4-7.7-68.3L251.1 13.4zM288.2 92c-11 0-20 9-20 20l0 320c0 11 9 20 20 20 11 0 20-9 20-20l0-320c0-11-9-20-20-20z"],
    "x": [384, 512, [120], "58", "M376.6 84.5c11.3-13.6 9.5-33.8-4.1-45.1s-33.8-9.5-45.1 4.1L192 206 56.6 43.5C45.3 29.9 25.1 28.1 11.5 39.4S-3.9 70.9 7.4 84.5L150.3 256 7.4 427.5c-11.3 13.6-9.5 33.8 4.1 45.1s33.8 9.5 45.1-4.1L192 306 327.4 468.5c11.3 13.6 31.5 15.4 45.1 4.1s15.4-31.5 4.1-45.1L233.7 256 376.6 84.5z"],
    "circle-user": [512, 512, [62142, "user-circle"], "f2bd", "M399 384.2C376.9 345.8 335.4 320 288 320l-64 0c-47.4 0-88.9 25.8-111 64.2 35.2 39.2 86.2 63.8 143 63.8s107.8-24.7 143-63.8zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm256 16a72 72 0 1 0 0-144 72 72 0 1 0 0 144z"],
    "rectangle-list": [512, 512, ["list-alt"], "f022", "M64 64C28.7 64 0 92.7 0 128L0 384c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L64 64zm96 256a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm-32-96a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm120-56l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zm0 128l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"],
    "circle-wifi": [512, 512, [], "e67d", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM127.5 241.3c-9.8 8.9-25 8.1-33.9-1.8s-8.1-25 1.8-33.9C137.9 167.3 194.3 144 256 144s118.1 23.3 160.6 61.6c9.8 8.9 10.6 24 1.8 33.9s-24 10.6-33.9 1.8c-34-30.7-79-49.3-128.5-49.3s-94.4 18.6-128.5 49.3zM256 336a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm0-48c-22.7 0-43.4 8.6-59 22.7-9.8 8.9-25 8.1-33.9-1.7s-8.1-25 1.7-33.9C188.9 253.3 220.9 240 256 240s67.1 13.3 91.2 35.1c9.8 8.9 10.6 24.1 1.7 33.9s-24.1 10.6-33.9 1.7c-15.6-14.1-36.3-22.7-59-22.7z"],
    "hand": [512, 512, [129306, 9995, "hand-paper"], "f256", "M288 32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 208c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-176c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 272c0 1.5 0 3.1 .1 4.6L67.6 283c-16-15.2-41.3-14.6-56.6 1.4S-3.6 325.7 12.4 341L124.8 448c43.1 41.1 100.4 64 160 64l19.2 0c97.2 0 176-78.8 176-176l0-208c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 112c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-176c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 176c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-208z"],
    "lasso-sparkles": [576, 512, [], "e1c9", "M351-21.6c-2.3-6.3-8.3-10.4-15-10.4s-12.7 4.2-15 10.4L306.3 18.3 266.4 33c-6.3 2.3-10.4 8.3-10.4 15s4.2 12.7 10.4 15l39.8 14.7 14.7 39.8c2.3 6.3 8.3 10.4 15 10.4s12.7-4.2 15-10.4L365.7 77.7 405.6 63c6.3-2.3 10.4-8.3 10.4-15s-4.2-12.7-10.4-15L365.7 18.3 351-21.6zM208.4 40.7C169.7 49.4 135.1 64.2 107 83.6 60.6 115.4 32 159.5 32 208s28.6 92.6 75 124.4c5.5 3.8 11.2 7.4 17.1 10.8l49.1 30.7c11.7 7.3 18.8 20.2 18.8 34 0 22.1-17.9 40.1-40.1 40.1l-5.6 0c-7.1 0-14.1-1.6-20.4-4.8L78.3 419.4c-15.8-7.9-35-1.5-42.9 14.3s-1.5 35 14.3 42.9l47.6 23.8c15.2 7.6 32 11.6 49 11.6l5.6 0c57.5 0 104.1-46.6 104.1-104.1 0-8.7-1.1-17.3-3.2-25.6 11.5 1.1 23.2 1.6 35.2 1.6 141.3 .1 256.1-78.9 256-176 0-48.5-28.6-92.6-75-124.5-3.7-2.6-7.6-5-11.5-7.4-7.1 14.5-19.5 26.1-35.3 31.9l-19.1 7.1-1.4 3.9c11.5 5.1 21.9 11 31.1 17.3 34.6 23.8 47.2 50.2 47.2 71.7s-12.7 47.9-47.2 71.7c-34.4 23.6-85.4 40.3-144.8 40.3-52 0-97.5-12.7-131.1-31.8l-14.2-8.9c-34.2-23.7-46.7-49.9-46.7-71.3 0-21.5 12.7-47.9 47.2-71.7 23.7-16.3 55.3-29.3 92.2-35.8-16.9-11.8-27.4-31.3-27.4-52.5 0-2.5 .1-4.9 .4-7.3zM496 384c-6.7 0-12.7 4.2-15 10.4l-14.7 39.8-39.8 14.7c-6.3 2.3-10.4 8.3-10.4 15s4.2 12.7 10.4 15l39.8 14.7 14.7 39.8c2.3 6.3 8.3 10.4 15 10.4s12.7-4.2 15-10.4l14.7-39.8 39.8-14.7c6.3-2.3 10.4-8.3 10.4-15s-4.2-12.7-10.4-15l-39.8-14.7-14.7-39.8c-2.3-6.3-8.3-10.4-15-10.4z"],
    "arrow-up-from-square": [448, 512, [], "e09c", "M256 77.3l9.4 9.4c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-64-64c-12.5-12.5-32.8-12.5-45.3 0l-64 64c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l9.4-9.4 0 210.7c0 17.7 14.3 32 32 32s32-14.3 32-32l0-210.7zM64 128c-35.3 0-64 28.7-64 64L0 448c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64l-32 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l32 0 0 256-320 0 0-256 32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0z"],
    "circle-r": [512, 512, [], "e120", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM200 144l80 0c39.8 0 72 32.2 72 72 0 28.9-17 53.8-41.6 65.3l30.2 50.3c6.8 11.4 3.1 26.1-8.2 32.9s-26.1 3.1-32.9-8.2l-41-68.3-34.4 0 0 56c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-176c0-13.3 10.7-24 24-24zm72 96l8 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-56 0 0 48 48 0z"],
    "polish-zloty-sign": [448, 512, [], "e70b", "M352 32c17.7 0 32 14.3 32 32l0 130.4 23.6-8.8c12.4-4.7 26.2 1.6 30.9 14s-1.6 26.2-14 30.9L384 245.6 384 448c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-178.4-23.6 8.8c-12.4 4.7-26.2-1.6-30.9-14s1.6-26.2 14-30.9L320 218.4 320 64c0-17.7 14.3-32 32-32zM32 192l160 0c12 0 23 6.7 28.5 17.4s4.6 23.5-2.4 33.2L94.2 416 192 416c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 480c-12 0-23-6.7-28.5-17.4S-1 439.2 6 429.4L129.8 256 32 256c-17.7 0-32-14.3-32-32s14.3-32 32-32z"],
    "phone-connection": [640, 512, [], "e6e1", "M495.5-49c-9.4 9.4-9.4 24.6 0 33.9l96 96c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-96-96c-9.4-9.4-24.6-9.4-33.9 0zM224.7 25C216.8 6.1 196.2-3.9 176.6 1.4L171 2.9c-64.6 17.6-119.8 80.2-103.7 156.4 37.1 175 174.8 312.7 349.8 349.8 76.3 16.2 138.8-39.1 156.4-103.7l1.5-5.5c5.4-19.7-4.7-40.3-23.5-48.1l-97.3-40.5c-16.5-6.9-35.6-2.1-47 11.8l-38.6 47.2C298.4 335.4 241.8 277 209.3 205.3l44.1-36.1c13.9-11.3 18.6-30.4 11.8-47L224.7 25zM401.5 79c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l96 96c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-96-96zm131 1a36 36 0 1 0 -72 0 36 36 0 1 0 72 0zm-164 164a36 36 0 1 0 0-72 36 36 0 1 0 0 72z"],
    "snooze": [448, 512, [128164, "zzz"], "f880", "M192 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l32 0-57.6 76.8c-7.3 9.7-8.4 22.7-3 33.5S179.9 192 192 192l96 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0 57.6-76.8c7.3-9.7 8.4-22.7 3-33.5S300.1 0 288 0L192 0zM320 224c-17.7 0-32 14.3-32 32s14.3 32 32 32l32 0-57.6 76.8c-7.3 9.7-8.4 22.7-3 33.5S307.9 416 320 416l96 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0 57.6-76.8c7.3-9.7 8.4-22.7 3-33.5S428.1 224 416 224l-96 0zM32 256c-17.7 0-32 14.3-32 32s14.3 32 32 32l91.7 0-116.3 139.5c-7.9 9.5-9.7 22.8-4.4 34.1S19.6 512 32 512l160 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-91.7 0 116.3-139.5c7.9-9.5 9.7-22.8 4.4-34.1S204.4 256 192 256L32 256z"],
    "user-doctor-hair-mullet": [448, 512, [], "e7ad", "M144 144l0-32 17.9 0c27.5 0 52-17.6 60.7-43.8l1.4-4.2 1.4 4.2c8.7 26.1 33.2 43.8 60.7 43.8l17.9 0 0 32c0 44.2-35.8 80-80 80s-80-35.8-80-80zm208 0l0-32 0-1.4c9.3-3.3 16-12.2 16-22.6 0-13.3-10.7-24-24-24-.9 0-1.8 .1-2.7 .2-17.9-37.9-56.6-64.2-101.3-64.2L208 0c-44.7 0-83.3 26.2-101.3 64.2-.9-.1-1.8-.2-2.7-.2-13.3 0-24 10.7-24 24 0 10.5 6.7 19.3 16 22.6l0 1.4 0 32c0 24.7 7 47.8 19.1 67.3l-15 22.5c-2.7 4-4.1 8.8-4.1 13.6 0 13.6 11 24.6 24.6 24.6l206.9 0c13.6 0 24.6-11 24.6-24.6 0-4.8-1.4-9.6-4.1-13.6l-15-22.5C345 191.8 352 168.7 352 144zM284 320.8c-5.4-.5-11-.8-16.6-.8l-86.9 0c-5.6 0-11.1 .3-16.6 .8l0 67.5c16.5 7.6 28 24.3 28 43.6 0 26.5-21.5 48-48 48s-48-21.5-48-48c0-19.4 11.5-36.1 28-43.6l0-58.4C61 353 16 413.6 16 484.6 16 499.7 28.3 512 43.4 512l361.1 0c15.1 0 27.4-12.3 27.4-27.4 0-71-45-131.5-108-154.6l0 37.4c23.3 8.2 40 30.5 40 56.6l0 32c0 11-9 20-20 20s-20-9-20-20l0-32c0-11-9-20-20-20s-20 9-20 20l0 32c0 11-9 20-20 20s-20-9-20-20l0-32c0-26.1 16.7-48.3 40-56.6l0-46.6z"],
    "pan-frying": [576, 512, [127859], "e42c", "M448 224c0 33.4-7.3 65.1-20.4 93.6l123.7 79.9c15.5 11.7 24.7 29.7 24.7 50.5 0 35.3-28.7 64-64 64-15.2 0-28.3-4.6-39.3-13.5L364.8 398.3C326.3 429.4 277.3 448 224 448 100.3 448 0 347.7 0 224S100.3 0 224 0 448 100.3 448 224zM319.9 154c-21.2-5.4-50.6-22.6-65.8-38.4-24.5-25.5-65-26.3-90.5-1.8-11.6 11.2-18.1 25.6-19.4 40.5-2.2 24.7-9.2 56.2-21.5 77.6-22.1 38.3-9 87.2 29.3 109.3s87.2 9 109.3-29.3c9.4-16.3 33-30 51.6-32.6 10.2-1.4 20.3-5.4 29.2-12 28.4-21.1 34.3-61.1 13.3-89.5-9.1-12.3-21.8-20.4-35.5-23.9zM528 448a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM224 176a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"],
    "van-shuttle": [576, 512, [128656, "shuttle-van"], "f5b6", "M64 64C28.7 64 0 92.7 0 128L0 336c0 35.3 28.7 64 64 64l.4 0c4 44.9 41.7 80 87.6 80s83.6-35.1 87.6-80l104.7 0c4 44.9 41.7 80 87.6 80 46.1 0 83.9-35.4 87.7-80.5 31.7-3.8 56.3-30.8 56.3-63.5l0-101.3c0-13.8-4.5-27.3-12.8-38.4l-80-106.7C471.1 73.5 452.1 64 432 64L64 64zM504 224l-120 0 0-96 48 0 72 96zM64 224l0-96 96 0 0 96-96 0zm160 0l0-96 96 0 0 96-96 0zM392 392a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zM152 352a40 40 0 1 1 0 80 40 40 0 1 1 0-80z"],
    "stairs": [576, 512, [], "e289", "M384 64c0-17.7 14.3-32 32-32l128 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-96 0 0 96c0 17.7-14.3 32-32 32l-96 0 0 96c0 17.7-14.3 32-32 32l-96 0 0 96c0 17.7-14.3 32-32 32L32 480c-17.7 0-32-14.3-32-32s14.3-32 32-32l96 0 0-96c0-17.7 14.3-32 32-32l96 0 0-96c0-17.7 14.3-32 32-32l96 0 0-96z"],
    "shuttlecock": [512, 512, [], "f45b", "M262.4 424.3l-33.2 29.2C181.3 495.4 109 493 64 448S16.6 330.8 58.5 282.8l29.1-33.3 174.8 174.8zM239.8 0c10 0 19 5.6 23.5 14.5l18.3 36.6c4.1 8.2 4.5 17.7 1.1 26.2L224 224 323.8 95.6c7.4-9.6 19.7-14.1 31.5-11.8l39.7 7.9c12.7 2.5 22.6 12.4 25.1 25.1l7.9 39.7c2.4 11.9-2.2 24.1-11.8 31.6L288 288 434.7 229.3c8.5-3.4 18-3 26.2 1.1l36.6 18.3c8.9 4.5 14.5 13.5 14.5 23.5 0 9.7-5.4 18.6-13.9 23.2L304.6 398.6 113.4 207.4 216.6 13.9C221.1 5.3 230.1 0 239.8 0z"],
    "coin-vertical": [384, 512, [], "e3fd", "M240 512l-96 0C64.5 512 0 397.4 0 256S64.5 0 144 0l96 0c29.1 0 55.9 19.4 77.3 52L231 52c8.7 11.7 16.6 25.1 23.6 40l83.7 0c9.8 23.5 17.5 50.5 22.7 80l-80.9 0c2.5 12.9 4.5 26.3 5.8 40l80.2 0c1.2 14.3 1.9 29 1.9 44s-.6 29.7-1.9 44l-80.2 0c-1.3 13.7-3.3 27.1-5.8 40l80.9 0c-5.1 29.5-12.9 56.5-22.7 80l-83.7 0c-7 14.9-14.9 28.3-23.6 40l86.3 0c-21.5 32.6-48.3 52-77.3 52zm-96-64c53 0 96-86 96-192s-43-192-96-192-96 86-96 192 43 192 96 192zm0-48c-35.3 0-64-64.5-64-144s28.7-144 64-144 64 64.5 64 144-28.7 144-64 144z"],
    "circle-turkish-lira": [512, 512, [], "e739", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM216 128c13.3 0 24 10.7 24 24l0 44.5 58.9-19.6c8.4-2.8 17.4 1.7 20.2 10.1s-1.7 17.4-10.1 20.2l-69.1 23 0 30.3 58.9-19.6c8.4-2.8 17.4 1.7 20.2 10.1s-1.7 17.4-10.1 20.2l-69.1 23 0 41.8 48 0c26.5 0 48-21.5 48-48 0-13.3 10.7-24 24-24s24 10.7 24 24c0 53-43 96-96 96l-72 0c-13.3 0-24-10.7-24-24l0-49.8-26.9 9c-8.4 2.8-17.4-1.7-20.2-10.1s1.7-17.4 10.1-20.2l37.1-12.4 0-30.3-26.9 9c-8.4 2.8-17.4-1.7-20.2-10.1s1.7-17.4 10.1-20.2l37.1-12.4 0-60.5c0-13.3 10.7-24 24-24z"],
    "sheep": [640, 512, [128017], "f711", "M384 135.8l0 72.2c0 44.2 35.8 80 80 80l32 0c44.2 0 80-35.8 80-80l0-72.2 14.5 6.2c12.2 5.2 26.3-.4 31.5-12.6s-.4-26.3-12.6-31.5L561.6 77.4C544.7 50.2 514.5 32 480 32s-64.7 18.2-81.6 45.4L350.5 97.9c-12.2 5.2-17.8 19.3-12.6 31.5s19.3 17.8 31.5 12.6l14.5-6.2zm80-7.8a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm48 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM352 175.4c-18.7-2.7-35.5-14.8-43.5-33.4-6.9-16.1-5.7-33.5 1.8-47.9-11.3-18.1-31.4-30.1-54.3-30.1-19.2 0-36.5 8.5-48.2 21.9-10.9-8.7-24.8-13.9-39.8-13.9-30.1 0-55.3 20.8-62.2 48.8-3.2-.5-6.5-.8-9.8-.8-35.3 0-64 28.7-64 64 0 5.3 .7 10.5 1.9 15.5-20.2 10.8-33.9 32-33.9 56.5s13.7 45.7 33.9 56.5c-1.2 5-1.9 10.2-1.9 15.5 0 35.3 28.7 64 64 64 .5 0 1 0 1.5 0l17.6 93.9c2.8 15.1 16.1 26.1 31.5 26.1l29.4 0c17.7 0 32-14.3 32-32l0-53.7c11.7 13.3 28.9 21.7 48 21.7s36.3-8.4 48-21.7l0 53.7c0 17.7 14.3 32 32 32l29.4 0c15.4 0 28.6-11 31.4-26.1L414.5 392c.5 0 1 0 1.5 0 35.3 0 64-28.7 64-64 0-2.7-.2-5.4-.5-8L464 320c-61.9 0-112-50.1-112-112l0-32.6z"],
    "horse-head": [512, 512, [], "f7ab", "M0 464L0 316.9C0 208.5 68.3 111.8 170.5 75.6L340.2 15.5c21.4-7.6 43.8 8.3 43.8 30.9 0 11-5.5 21.2-14.6 27.3L336 96c48.1 0 91.2 29.8 108.1 74.9l48.6 129.5c11.8 31.4 4.1 66.8-19.6 90.5-16 16-37.8 25.1-60.5 25.1l-3.4 0c-26.1 0-50.9-11.6-67.6-31.7l-32.3-38.7c-11.7 4.1-24.2 6.4-37.3 6.4l-.1 0c-6.3 0-12.5-.5-18.6-1.5-3.6-.6-7.2-1.4-10.7-2.3l0 0c-28.9-7.8-53.1-26.8-67.8-52.2-4.4-7.7-14.2-10.3-21.9-5.8s-10.3 14.2-5.8 21.9c24 41.5 68.3 70 119.3 71.9l47.2 70.8c4 6.1 6.2 13.2 6.2 20.4 0 20.3-16.5 36.8-36.8 36.8L48 512c-26.5 0-48-21.5-48-48zM328 224a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"],
    "circle-calendar": [512, 512, ["calendar-circle"], "e102", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM204 112c11 0 20 9 20 20l0 12 64 0 0-12c0-11 9-20 20-20s20 9 20 20l0 12 8 0c26.5 0 48 21.5 48 48l0 16-256 0 0-16c0-26.5 21.5-48 48-48l8 0 0-12c0-11 9-20 20-20zM128 336l0-80 256 0 0 80c0 26.5-21.5 48-48 48l-160 0c-26.5 0-48-21.5-48-48z"],
    "vault": [512, 512, [], "e2c5", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64 0 17.7 14.3 32 32 32s32-14.3 32-32l256 0c0 17.7 14.3 32 32 32s32-14.3 32-32c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM256 256a64 64 0 1 0 -128 0 64 64 0 1 0 128 0zM64 256a128 128 0 1 1 256 0 128 128 0 1 1 -256 0zm384-48c0 17.8-9.7 33.3-24 41.6l0 78.4c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-78.4c-14.3-8.3-24-23.8-24-41.6 0-26.5 21.5-48 48-48s48 21.5 48 48z"],
    "closed-captioning-slash": [576, 512, [], "e135", "M7-24.9c9.4-9.4 24.6-9.4 33.9 0L129.8 64 480 64c35.3 0 64 28.7 64 64l0 256c0 25.5-14.9 47.4-36.4 57.8L569 503.1c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0L7 9.1C-2.3-.3-2.3-15.5 7-24.9zm345 311l0-70.2c0-4.4 3.6-8 8-8l32 0c4.4 0 8 3.6 8 8 0 13.3 10.7 24 24 24s24-10.7 24-24c0-30.9-25.1-56-56-56l-32 0c-30.9 0-56 25.1-56 56l0 22.2 48 48zm61.5 61.5c20.2-8.4 34.5-28.4 34.5-51.7 0-13.3-10.7-24-24-24s-24 10.7-24 24c0 4.4-3.6 8-8 8l-22.2 0 43.7 43.7zM130.3 200.1c-1.5 5-2.3 10.4-2.3 15.9l0 80c0 30.9 25.1 56 56 56l32 0c18.1 0 34.1-8.5 44.4-21.8L378.2 448 96 448c-35.3 0-64-28.7-64-64l0-256c0-7.8 1.4-15.3 4-22.2l94.3 94.3zm93.8 93.8c-.1 .7-.1 1.4-.1 2.1 0 4.4-3.6 8-8 8l-32 0c-4.4 0-8-3.6-8-8l0-50.2 48.1 48.1z"],
    "drum-steelpan": [576, 512, [], "f56a", "M288 32c159.1 0 288 48 288 128l0 192c0 80-128.9 128-288 128S0 432 0 352L0 160C0 80 128.9 32 288 32zM528 160c0-9.9-8-29.9-55-49.8-18.6-7.9-40.9-14.4-66-19.4l-27.8 43.6c-7.3 11.5-11.2 24.8-11.2 38.4 0 17.5 6.4 34.4 18.1 47.5l9.8 11c29.8-5.2 55.9-12.5 77.2-21.5 47.1-19.9 55-39.9 55-49.8zM349.2 237.3c-8-26.2-32.4-45.3-61.2-45.3s-53.3 19.1-61.2 45.3c19.4 1.7 39.9 2.7 61.2 2.7s41.8-.9 61.2-2.7zM169 90.8c-25.2 5-47.4 11.6-66 19.4-47.1 19.9-55 39.9-55 49.8s8 29.9 55 49.8c21.3 9 47.4 16.3 77.2 21.5l9.8-11c11.6-13.1 18.1-30 18.1-47.5 0-13.6-3.9-26.9-11.2-38.4L169 90.8zm56.3-8c-.9 4.3-1.4 8.7-1.4 13.2 0 35.3 28.7 64 64 64s64-28.7 64-64c0-4.5-.5-9-1.4-13.2-19.8-1.8-40.8-2.8-62.6-2.8s-42.8 1-62.6 2.8z"],
    "thumbs-up": [512, 512, [128077, 61575], "f164", "M80 160c17.7 0 32 14.3 32 32l0 256c0 17.7-14.3 32-32 32l-48 0c-17.7 0-32-14.3-32-32L0 192c0-17.7 14.3-32 32-32l48 0zM270.6 16C297.9 16 320 38.1 320 65.4l0 4.2c0 6.8-1.3 13.6-3.8 19.9L288 160 448 160c26.5 0 48 21.5 48 48 0 19.7-11.9 36.6-28.9 44 17 7.4 28.9 24.3 28.9 44 0 23.4-16.8 42.9-39 47.1 4.4 7.3 7 15.8 7 24.9 0 22.2-15 40.8-35.4 46.3 2.2 5.5 3.4 11.5 3.4 17.7 0 26.5-21.5 48-48 48l-87.9 0c-36.3 0-71.6-12.4-99.9-35.1L184 435.2c-15.2-12.1-24-30.5-24-50l0-186.6c0-14.9 3.5-29.6 10.1-42.9L226.3 43.3C234.7 26.6 251.8 16 270.6 16z"],
    "engine": [576, 512, [], "e16e", "M376 80c13.3 0 24-10.7 24-24s-10.7-24-24-24L200 32c-13.3 0-24 10.7-24 24s10.7 24 24 24l64 0 0 48-120 0c-26.5 0-48 21.5-48 48l0 56-32 0 0-80c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 208c0 13.3 10.7 24 24 24s24-10.7 24-24l0-80 32 0 0 56c0 26.5 21.5 48 48 48l37.3 0 23.7 35.5c11.9 17.8 31.9 28.5 53.3 28.5L384 448c35.3 0 64-28.7 64-64l0-192c0-35.3-28.7-64-64-64l-72 0 0-48 64 0zM496 184l0 208c0 13.3 10.7 24 24 24s24-10.7 24-24l0-208c0-13.3-10.7-24-24-24s-24 10.7-24 24zM328 240l-112 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l112 0c13.3 0 24 10.7 24 24s-10.7 24-24 24z"],
    "user-alien": [448, 512, [], "e04a", "M64 168C64 75.2 135.6 0 224 0S384 75.2 384 168c0 101.6-106.6 186.1-139.2 209.5-6.1 4.4-13.3 6.5-20.8 6.5s-14.7-2.1-20.8-6.5C170.6 354.1 64 269.6 64 168zm244.6 8c-37.9 0-68.6 30.7-68.6 68.6 0 6.3 5.1 11.4 11.4 11.4l16 0c37.9 0 68.6-30.7 68.6-68.6 0-6.3-5.1-11.4-11.4-11.4l-16 0zM208 244.6c0-37.9-30.7-68.6-68.6-68.6l-16 0c-6.3 0-11.4 5.1-11.4 11.4 0 37.9 30.7 68.6 68.6 68.6l16 0c6.3 0 11.4-5.1 11.4-11.4zM16 489.1c0-60.2 38.7-111.3 92.6-129.8 26.9 27.3 52.8 47.2 66.5 57.1 15 10.8 32.3 15.5 48.8 15.5s33.8-4.7 48.8-15.5c13.8-9.9 39.7-29.8 66.5-57.1 53.9 18.5 92.6 69.6 92.6 129.8 0 12.6-10.2 22.9-22.9 22.9L38.9 512C26.2 512 16 501.8 16 489.1z"],
    "rectangle-history": [512, 512, [], "e4a2", "M512 272c0-35.3-28.7-64-64-64L64 208c-35.3 0-64 28.7-64 64L0 416c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-144zM440 104L72 104c-13.3 0-24 10.7-24 24s10.7 24 24 24l368 0c13.3 0 24-10.7 24-24s-10.7-24-24-24zM392 0L120 0C106.7 0 96 10.7 96 24s10.7 24 24 24l272 0c13.3 0 24-10.7 24-24S405.3 0 392 0z"],
    "rectangle-minus": [512, 512, [], "e6b4", "M64 64C28.7 64 0 92.7 0 128L0 384c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L64 64zM168 232l176 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-176 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"],
    "stamp": [512, 512, [], "f5bf", "M312 201.8c0-17.4 9.2-33.2 19.9-47 12.6-16.2 20.1-36.6 20.1-58.8 0-53-43-96-96-96s-96 43-96 96c0 22.1 7.5 42.5 20.1 58.8 10.7 13.8 19.9 29.6 19.9 47 0 29.9-24.3 54.2-54.2 54.2L112 256c-61.9 0-112 50.1-112 112 0 26.5 21.5 48 48 48l416 0c26.5 0 48-21.5 48-48 0-61.9-50.1-112-112-112l-33.8 0c-29.9 0-54.2-24.3-54.2-54.2zM56 464c-13.3 0-24 10.7-24 24s10.7 24 24 24l400 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L56 464z"],
    "triple-chevrons-up": [320, 512, [], "e7fa", "M140.3 359.2c12.6-10.2 31.1-9.5 42.8 2.2l128 128 2.2 2.4c10.2 12.6 9.5 31.1-2.2 42.8s-30.2 12.4-42.8 2.2l-2.4-2.2-105.4-105.4-105.4 105.4c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.2l128-128 2.4-2.2zm0-192c12.6-10.3 31.1-9.5 42.8 2.2l128 128 2.2 2.4c10.2 12.6 9.5 31.1-2.2 42.8s-30.2 12.4-42.8 2.2l-2.4-2.2-105.4-105.4-105.4 105.4c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.2l128-128 2.4-2.2zm0-192c12.6-10.3 31.1-9.5 42.8 2.2l128 128 2.2 2.4c10.2 12.6 9.5 31.1-2.2 42.8s-30.2 12.4-42.8 2.2l-2.4-2.2-105.4-105.4-105.4 105.4c-12.5 12.5-32.8 12.5-45.3 0-12.5-12.5-12.5-32.8 0-45.2l128-128 2.4-2.2z"],
    "menorah": [640, 512, [], "f676", "M20.8 7.4C22.8 2.9 27.1 0 32 0s9.2 2.9 11.2 7.4L61.3 49.7c1.8 4.1 2.7 8.6 2.7 13.1L64 64c0 17.7-14.3 32-32 32S0 81.7 0 64l0-1.2c0-4.5 .9-8.9 2.7-13.1L20.8 7.4zm96 0C118.8 2.9 123.1 0 128 0s9.2 2.9 11.2 7.4l18.2 42.4c1.8 4.1 2.7 8.6 2.7 13.1l0 1.2c0 17.7-14.3 32-32 32S96 81.7 96 64l0-1.2c0-4.5 .9-8.9 2.7-13.1L116.8 7.4zm77.8 42.4L212.8 7.4C214.8 2.9 219.1 0 224 0s9.2 2.9 11.2 7.4l18.2 42.4c1.8 4.1 2.7 8.6 2.7 13.1l0 1.2c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-1.2c0-4.5 .9-8.9 2.7-13.1zM308.8 7.4C310.8 2.9 315.1 0 320 0s9.2 2.9 11.2 7.4l18.2 42.4c1.8 4.1 2.7 8.6 2.7 13.1l0 1.2c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-1.2c0-4.5 .9-8.9 2.7-13.1L308.8 7.4zm77.8 42.4L404.8 7.4C406.8 2.9 411.1 0 416 0s9.2 2.9 11.2 7.4l18.2 42.4c1.8 4.1 2.7 8.6 2.7 13.1l0 1.2c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-1.2c0-4.5 .9-8.9 2.7-13.1zM500.8 7.4C502.8 2.9 507.1 0 512 0s9.2 2.9 11.2 7.4l18.2 42.4c1.8 4.1 2.7 8.6 2.7 13.1l0 1.2c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-1.2c0-4.5 .9-8.9 2.7-13.1L500.8 7.4zm77.8 42.4L596.8 7.4C598.8 2.9 603.1 0 608 0s9.2 2.9 11.2 7.4l18.2 42.4c1.8 4.1 2.7 8.6 2.7 13.1l0 1.2c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-1.2c0-4.5 .9-8.9 2.7-13.1zM32 128c17.7 0 32 14.3 32 32l0 128c0 17.7 14.3 32 32 32l192 0 0-160c0-17.7 14.3-32 32-32s32 14.3 32 32l0 160 192 0c17.7 0 32-14.3 32-32l0-128c0-17.7 14.3-32 32-32s32 14.3 32 32l0 128c0 53-43 96-96 96l-192 0 0 64 128 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-320 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l128 0 0-64-192 0c-53 0-96-43-96-96L0 160c0-17.7 14.3-32 32-32zm96 0c17.7 0 32 14.3 32 32l0 128-64 0 0-128c0-17.7 14.3-32 32-32zm96 0c17.7 0 32 14.3 32 32l0 128-64 0 0-128c0-17.7 14.3-32 32-32zm192 0c17.7 0 32 14.3 32 32l0 128-64 0 0-128c0-17.7 14.3-32 32-32zm96 0c17.7 0 32 14.3 32 32l0 128-64 0 0-128c0-17.7 14.3-32 32-32z"],
    "turn-left": [512, 512, [], "e636", "M9.4 278.6c-12.5-12.5-12.5-32.8 0-45.3l128-128c9.2-9.2 22.9-11.9 34.9-6.9S192 115.1 192 128l0 64 160 0c88.4 0 160 71.6 160 160l0 64c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-64c0-17.7-14.3-32-32-32l-160 0 0 64c0 12.9-7.8 24.6-19.8 29.6s-25.7 2.2-34.9-6.9l-128-128z"],
    "square-won": [448, 512, [], "e709", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm32.7 97.1c12.6-4 26.1 3 30.2 15.6l30.4 95.3 19.3 0 24.3-94c2.7-10.6 12.2-17.9 23.1-18s20.5 7.2 23.3 17.8l25.4 94.2 19.3 0 29.2-95.1c3.9-12.7 17.3-19.8 30-15.9s19.8 17.3 15.9 30L342 240 352 240c8.8 0 16 7.2 16 16s-7.2 16-16 16l-19.8 0-29.2 95.1c-3.1 10.2-12.7 17.1-23.4 16.9s-20-7.4-22.7-17.8l-25.4-94.2-13.7 0-24.3 94c-2.7 10.4-11.9 17.7-22.6 18s-20.3-6.5-23.5-16.7l-30.4-95.3-21 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l10.8 0-25.7-80.7c-4-12.6 3-26.1 15.6-30.2zm71.2 144.2l.4-1.4-.8 0 .4 1.4zm113.7 0l.4-1.4-.8 0 .4 1.4z"],
    "malaysian-ringgit-sign": [576, 512, [], "e6fa", "M288 416c0 17.7 14.3 32 32 32s32-14.3 32-32l0-210.1 53 83.3c5.9 9.2 16.1 14.8 27 14.8s21.1-5.6 27-14.8l53-83.3 0 210.1c0 17.7 14.3 32 32 32s32-14.3 32-32l0-320c0-14.2-9.4-26.7-23.1-30.7S524.6 66.8 517 78.8L432 212.4 347 78.8c-7.6-12-22.3-17.5-35.9-13.5S288 81.8 288 96l0 320zM0 96L0 416c0 17.7 14.3 32 32 32s32-14.3 32-32l0-96 57.8 0 40.2 107.2c6.2 16.5 24.7 24.9 41.2 18.7s24.9-24.6 18.7-41.2l-36.8-98.2c42-21 70.9-64.4 70.9-114.6 0-70.7-57.3-128-128-128L32 64C14.3 64 0 78.3 0 96zM64 256l0-128 64 0c35.3 0 64 28.7 64 64s-28.7 64-64 64l-64 0z"],
    "presentation-screen": [512, 512, ["presentation"], "f685", "M24 32l464 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 80C10.7 80 0 69.3 0 56S10.7 32 24 32zM232 384L96 384c-35.3 0-64-28.7-64-64l0-192 448 0 0 192c0 35.3-28.7 64-64 64l-136 0 0 35.5 69.8 48.8c10.9 7.6 13.5 22.6 5.9 33.4s-22.6 13.5-33.4 5.9l-66.2-46.4-66.2 46.4c-10.9 7.6-25.8 5-33.4-5.9s-5-25.8 5.9-33.4l69.8-48.8 0-35.5z"],
    "camera-movie": [576, 512, [127909, 127910], "f8a9", "M0 112c0 70.7 57.3 128 128 128l224 0c70.7 0 128-57.3 128-128S422.7-16 352-16c-48.2 0-90.2 26.6-112 66-21.8-39.4-63.8-66-112-66-70.7 0-128 57.3-128 128zm304 0a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM128 64a48 48 0 1 1 0 96 48 48 0 1 1 0-96zM64 352l0 64c0 35.3 28.7 64 64 64l224 0c35.3 0 64-28.7 64-64l0-64c0-35.3-28.7-64-64-64l-224 0c-35.3 0-64 28.7-64 64zM537.5 490.8c4.2 3.4 9.4 5.2 14.8 5.2 13.1 0 23.7-10.6 23.7-23.7l0-240.6c0-13.1-10.6-23.7-23.7-23.7-5.4 0-10.6 1.8-14.8 5.2l-73.5 58.8 0 160 73.5 58.8z"],
    "square-currency": [448, 512, [], "e70c", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm55 119c9.4-9.4 24.6-9.4 33.9 0l22.3 22.3c14.3-8.4 31-13.3 48.8-13.3s34.5 4.8 48.8 13.3L295 151c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-22.3 22.3c8.4 14.3 13.3 31 13.3 48.8s-4.8 34.5-13.3 48.8L329 327c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-22.3-22.3c-14.3 8.4-31 13.3-48.8 13.3s-34.5-4.8-48.8-13.3L153 361c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l22.3-22.3c-8.4-14.3-13.3-31-13.3-48.8s4.8-34.5 13.3-48.8L119 185c-9.4-9.4-9.4-24.6 0-33.9zm71.1 70.9l-.2 .2c-8.6 8.7-13.9 20.6-13.9 33.8s5.3 25.1 13.9 33.8l.2 .2c8.7 8.6 20.6 13.9 33.8 13.9s25.2-5.3 33.8-13.9l.2-.2c8.6-8.7 13.9-20.6 13.9-33.8s-5.3-25.1-13.9-33.8l-.2-.2c-8.7-8.6-20.6-13.9-33.8-13.9s-25.2 5.3-33.8 13.9z"],
    "hat-chef": [512, 512, [], "f86b", "M448 384l-384 0 0 80c0 26.5 21.5 48 48 48l288 0c26.5 0 48-21.5 48-48l0-80zm0-48l0-90.8c37.8-18 64-56.5 64-101.2 0-61.9-50.1-112-112-112-17.3 0-33.7 3.9-48.3 10.9-23.4-26.3-57.6-42.9-95.7-42.9s-72.2 16.6-95.7 42.9C145.7 35.9 129.3 32 112 32 50.1 32 0 82.1 0 144 0 188.7 26.2 227.2 64 245.2l0 90.8 64 0 0-120c0-13.3 10.7-24 24-24s24 10.7 24 24l0 120 56 0 0-120c0-13.3 10.7-24 24-24s24 10.7 24 24l0 120 56 0 0-120c0-13.3 10.7-24 24-24s24 10.7 24 24l0 120 64 0z"],
    "children": [640, 512, [], "e4e1", "M160.5 0a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm-72 480l0-80-17.8 0c-10.9 0-18.6-10.7-15.2-21.1L86.7 285.5 58 323.3c-10.7 14.1-30.8 16.8-44.8 6.2S-3.7 298.7 7 284.7L65.9 207c22.4-29.6 57.5-47 94.6-47s72.2 17.4 94.6 47L314 284.7c10.7 14.1 7.9 34.2-6.2 44.8s-34.2 7.9-44.8-6.2l-28.7-37.8 31.1 93.4c3.5 10.4-4.3 21.1-15.2 21.1l-17.8 0 0 80c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-80-16 0 0 80c0 17.7-14.3 32-32 32s-32-14.3-32-32zM480.5 0a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm-8 384l0 96c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-179.5-12.9 20.5c-9.4 15-29.2 19.4-44.1 10s-19.4-29.2-10-44.1l51.7-82.1c17.6-27.9 48.3-44.9 81.2-44.9l12.3 0c33 0 63.7 16.9 81.2 44.9L619.6 287c9.4 15 4.9 34.7-10 44.1s-34.7 4.9-44.1-10l-12.9-20.5 0 179.5c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-96-16 0z"],
    "snow-blowing": [640, 512, [], "f761", "M512 48l32 0c53 0 96 43 96 96s-43 96-96 96l-128 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l128 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0c-17.7 0-32-14.3-32-32s14.3-32 32-32zM176 64c13.3 0 24 10.7 24 24l0 25.4 12.7-12.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6l-35.3 35.3 0 55.8 48.3-27.9 12.9-48.2c2.3-8.5 11.1-13.6 19.6-11.3s13.6 11.1 11.3 19.6l-4.6 17.3 22-12.7c11.5-6.6 26.2-2.7 32.8 8.8s2.7 26.2-8.8 32.8l-22 12.7 17.3 4.6c8.5 2.3 13.6 11.1 11.3 19.6s-11.1 13.6-19.6 11.3l-48.2-12.9-48.3 27.9 48.3 27.9 48.2-12.9c8.5-2.3 17.3 2.8 19.6 11.3s-2.8 17.3-11.3 19.6l-17.3 4.6 22 12.7c11.5 6.6 15.4 21.3 8.8 32.8s-21.3 15.4-32.8 8.8l-22-12.7 4.6 17.3c2.3 8.5-2.8 17.3-11.3 19.6s-17.3-2.8-19.6-11.3l-12.9-48.2-48.3-27.9 0 55.8 35.3 35.3c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L200 398.6 200 424c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-25.4-12.7 12.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l35.3-35.3 0-55.8-48.3 27.9-12.9 48.2c-2.3 8.5-11.1 13.6-19.6 11.3S57.6 374 59.8 365.4l4.6-17.3-22 12.7C31 367.4 16.4 363.5 9.7 352S7 325.8 18.5 319.2l22-12.7-17.3-4.6c-8.5-2.3-13.6-11.1-11.3-19.6S22.9 268.7 31.4 271L79.7 283.9 128 256 79.7 228.1 31.4 241c-8.5 2.3-17.3-2.8-19.6-11.3s2.8-17.3 11.3-19.6l17.3-4.6-22-12.7C7 186.2 3.1 171.5 9.7 160s21.3-15.4 32.8-8.8l22 12.7-4.6-17.3c-2.3-8.5 2.8-17.3 11.3-19.6s17.3 2.8 19.6 11.3l12.9 48.2 48.3 27.9 0-55.8-35.3-35.3c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0L152 113.4 152 88c0-13.3 10.7-24 24-24zM480 432c0-17.7 14.3-32 32-32l24 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-120 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l120 0c53 0 96 43 96 96s-43 96-96 96l-24 0c-17.7 0-32-14.3-32-32z"],
    "album-collection": [512, 512, [], "f8a0", "M128.5 24c0 13.3 10.7 24 24 24l208 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-208 0c-13.3 0-24 10.7-24 24zm-64 168c-13.9 0-27.1 6-36.3 16.6S15 233 17 246.8l32 224C52.4 494.4 72.6 512 96.5 512l320 0c23.9 0 44.1-17.6 47.5-41.2l32-224c2-13.8-2.1-27.7-11.3-38.2S462.4 192 448.5 192l-384 0zm352 160c0 61.9-71.6 112-160 112s-160-50.1-160-112 71.6-112 160-112 160 50.1 160 112zm-160 28c22.1 0 40-12.5 40-28s-17.9-28-40-28-40 12.5-40 28 17.9 28 40 28zM104.5 96c-13.3 0-24 10.7-24 24s10.7 24 24 24l304 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-304 0z"],
    "chart-line": [512, 512, ["line-chart"], "f201", "M64 64c0-17.7-14.3-32-32-32S0 46.3 0 64L0 400c0 44.2 35.8 80 80 80l400 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L80 416c-8.8 0-16-7.2-16-16L64 64zm406.6 86.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L320 210.7 262.6 153.4c-12.5-12.5-32.8-12.5-45.3 0l-96 96c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l73.4-73.4 57.4 57.4c12.5 12.5 32.8 12.5 45.3 0l128-128z"],
    "circle-up-left": [512, 512, [], "e128", "M256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zm56-352c9.7 0 18.5 5.8 22.2 14.8s1.7 19.3-5.2 26.2l-35 35 67 67c9.4 9.4 9.4 24.6 0 33.9l-24 24c-9.4 9.4-24.6 9.4-33.9 0l-67-67-35 35c-6.9 6.9-17.2 8.9-26.2 5.2S160 321.7 160 312l0-128c0-13.3 10.7-24 24-24l128 0z"],
    "envelope-ribbon": [640, 512, ["envelope-certificate"], "e829", "M512 160c70.7 0 128 57.3 128 128 0 40.4-18.8 76.4-48 99.9L592 493c0 10.5-8.5 19-19 19-3.3 0-6.5-.9-9.4-2.5L512 480 460.4 509.5c-2.9 1.6-6.1 2.5-9.4 2.5-10.5 0-19-8.5-19-19l0-105.2c-29.2-23.5-48-59.5-48-99.9 0-70.7 57.3-128 128-128zM262.4 344.8c25.9 19.4 59.1 24 88.5 14 8.2 18.5 19.4 35.4 33.1 49.9l0 39.3-256 0c-35.3 0-64-28.7-64-64l0-188 198.4 148.8zM512 240a48 48 0 1 0 0 96 48 48 0 1 0 0-96zM528 64c26.5 0 48 21.5 48 48l0 12.1c-19.8-7.8-41.4-12.1-64-12.1-97.2 0-176 78.8-176 176 0 8.3 .6 16.5 1.7 24.6-15.3 6.1-32.9 4-46.5-6.2l-208-156c-10.6-7.9-17.3-19.8-18.8-32.8l-.3-5.6 .2-4.9C66.7 82.9 87.1 64 112 64l416 0z"],
    "tire": [512, 512, [], "f631", "M400 256c0-39.2-15.7-74.7-41.1-100.7L330.1 195c13.7 16.6 21.9 37.8 21.9 61 0 2-.1 4-.2 6l46.6 15.2c1-6.9 1.5-14 1.5-21.2zm-63.1 51.6c-12.9 20.2-33.2 35.2-57 41.3l0 49c45.1-7.6 83.1-36.1 103.6-75.2l-46.6-15.2zM232 349c-23.8-6.1-44-21.2-56.9-41.3l-46.6 15.2c20.5 39.1 58.5 67.6 103.6 75.2l0-49zM112 256c0 7.2 .5 14.3 1.5 21.2L160.2 262c-.1-2-.2-4-.2-6 0-23.2 8.2-44.4 21.9-61l-28.8-39.7C127.7 181.3 112 216.8 112 256zm144-96c12.5 0 24.4 2.4 35.4 6.7L320.2 127c-19.3-9.6-41.1-15-64.2-15s-44.8 5.4-64.1 15l28.8 39.7c10.9-4.3 22.9-6.7 35.4-6.7zM0 256a256 256 0 1 1 512 0 256 256 0 1 1 -512 0zm256 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "australian-dollar-sign": [512, 512, [], "e6fe", "M408 16c13.3 0 24 10.7 24 24l0 24 16 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-48.9 0c-26 0-47.1 21.1-47.1 47.1 0 22.5 15.9 41.8 37.9 46.2l32.8 6.6c51.9 10.4 89.3 56 89.3 109 0 50.6-33.8 93.3-80 106.7l0 28.4c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-24-48 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l64.9 0c26 0 47.1-21.1 47.1-47.1 0-22.5-15.9-41.8-37.9-46.2l-32.8-6.6c-51.9-10.4-89.3-56-89.3-109 0-56.2 41.8-102.7 96-110.1l0-25c0-13.3 10.7-24 24-24zM128 184.1l-32.5 135.9 65 0-32.5-135.9zm64.9 271.3l-17.1-71.4-95.6 0-17.1 71.4c-4.1 17.2-21.4 27.8-38.6 23.7S-3.2 457.7 .9 440.6L87 80.3c4.5-19 21.5-32.3 41-32.3s36.4 13.4 41 32.3l86.1 360.2c4.1 17.2-6.5 34.5-23.7 38.6s-34.5-6.5-38.6-23.7z"],
    "square-envelope": [448, 512, ["envelope-square"], "f199", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM209.1 267.9L108.4 207.4c-7.7-4.6-12.4-12.9-12.4-21.9 0-14.1 11.4-25.5 25.5-25.5l204.9 0c14.1 0 25.5 11.4 25.5 25.5 0 9-4.7 17.3-12.4 21.9L238.9 267.9c-4.5 2.7-9.6 4.1-14.9 4.1s-10.4-1.4-14.9-4.1zM352 237.3l0 82.7c0 17.7-14.3 32-32 32l-192 0c-17.7 0-32-14.3-32-32l0-82.7 96.7 58C202.1 301 213 304 224 304s21.9-3 31.3-8.7l96.7-58z"],
    "object-exclude": [512, 512, [], "e49c", "M0 64C0 28.7 28.7 0 64 0L288 0c35.3 0 64 28.7 64 64l0 96 96 0c35.3 0 64 28.7 64 64l0 224c0 35.3-28.7 64-64 64l-224 0c-35.3 0-64-28.7-64-64l0-96-96 0c-35.3 0-64-28.7-64-64L0 64zM320 192l-128 0 0 128 128 0 0-128z"],
    "user-group-crown": [576, 512, ["users-crown"], "f6a5", "M240 128c0 35.3-28.7 64-64 64s-64-28.7-64-64l128 0zM64 25.9L64 128c0 61.9 50.1 112 112 112s112-50.1 112-112l0-102.1c0-11.9-12.5-19.6-23.2-14.3L234.3 26.8c-6.2 3.1-13.6 1.9-18.5-3L187.3-4.7c-6.2-6.2-16.4-6.2-22.6 0L136.2 23.8c-4.9 4.9-12.3 6.1-18.5 3L87.2 11.6C76.5 6.3 64 14 64 25.9zM432 256a96 96 0 1 0 0-192 96 96 0 1 0 0 192zm0 48c-29 0-56 8.6-78.5 23.3 29.2 37.8 46.5 85.2 46.5 136.7l0 6c0 15.2-3.8 29.5-10.4 42l144.8 0c23 0 41.6-18.6 41.6-41.6l0-22.4c0-79.5-64.5-144-144-144zM176 288C78.8 288 0 366.8 0 464l0 6c0 23.2 18.8 42 42 42l268 0c23.2 0 42-18.8 42-42l0-6c0-97.2-78.8-176-176-176z"],
    "ban-smoking": [512, 512, [128685, "smoking-ban"], "f54d", "M99.5 144.8l79.2 79.2-50.7 0c-17.7 0-32 14.3-32 32l0 32c0 17.7 14.3 32 32 32l146.7 0 92.5 92.5c-31.4 22.4-69.8 35.5-111.2 35.5-106 0-192-86-192-192 0-41.5 13.1-79.9 35.5-111.2zM333.3 288l-32-32 82.7 0 0 32-50.7 0zm32 32l18.7 0c17.7 0 32-14.3 32-32l0-32c0-17.7-14.3-32-32-32L269.3 224 144.8 99.5c31.4-22.4 69.8-35.5 111.2-35.5 106 0 192 86 192 192 0 41.5-13.1 79.9-35.5 111.2L365.3 320zM256 512a256 256 0 1 0 0-512 256 256 0 1 0 0 512zM272 96c-8.8 0-16 7.2-16 16 0 26.5 21.5 48 48 48l32 0c8.8 0 16 7.2 16 16s7.2 16 16 16 16-7.2 16-16c0-26.5-21.5-48-48-48l-32 0c-8.8 0-16-7.2-16-16s-7.2-16-16-16z"],
    "user-visor": [448, 512, [], "e04c", "M334 176c-18.5 42.4-60.8 72-110 72s-91.5-29.6-110-72l-2 0c-17.7 0-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32l22.6 0c22-24.6 53.9-40 89.4-40s67.5 15.4 89.4 40L336 48c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-2 0zM16 482.3C16 383.8 95.8 304 194.3 304l59.4 0c98.5 0 178.3 79.8 178.3 178.3 0 16.4-13.3 29.7-29.7 29.7L45.7 512C29.3 512 16 498.7 16 482.3zM132 112c0 11 9 20 20 20l144 0c11 0 20-9 20-20s-9-20-20-20L152 92c-11 0-20 9-20 20zM311.7 384.7L276.5 455c-4 8 4.5 16.5 12.5 12.5l26.8-13.4c2.6-1.3 5.7-1.3 8.3 0L351 467.5c8 4 16.5-4.5 12.5-12.5l-35.1-70.3c-3.4-6.9-13.3-6.9-16.7 0z"],
    "bar-progress-half": [512, 512, [], "e6a7", "M256 160l0 192 192 0 0-192-192 0zM0 160c0-35.3 28.7-64 64-64l384 0c35.3 0 64 28.7 64 64l0 192c0 35.3-28.7 64-64 64L64 416c-35.3 0-64-28.7-64-64L0 160z"],
    "truck-front": [448, 512, [], "e2b7", "M0 112C0 67.8 35.8 32 80 32l288 0c44.2 0 80 35.8 80 80l0 256c0 26.2-12.6 49.4-32 64l0 48c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-32-192 0 0 32c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-48C12.6 417.4 0 394.2 0 368L0 112zm96 80l0 64 256 0 0-64c0-17.7-14.3-32-32-32l-192 0c-17.7 0-32 14.3-32 32zm32 160a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm224 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "blinds-open": [448, 512, [], "f8fc", "M32 32C14.3 32 0 46.3 0 64S14.3 96 32 96l80 0 0 232c0 13.3 10.7 24 24 24s24-10.7 24-24l0-232 256 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 32zM416 224c17.7 0 32-14.3 32-32s-14.3-32-32-32l-208 0 0 64 208 0zM32 160c-17.7 0-32 14.3-32 32s14.3 32 32 32l32 0 0-64-32 0zm0 192l32 0 0-64-32 0c-17.7 0-32 14.3-32 32s14.3 32 32 32zm384-64l-208 0 0 64 208 0c17.7 0 32-14.3 32-32s-14.3-32-32-32zM32 480l384 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 416c-17.7 0-32 14.3-32 32s14.